﻿USE sofia;
DROP TABLE IF EXISTS sofia.tkr_vpl;
CREATE TABLE tkr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tkr_vpl WRITE;
INSERT INTO tkr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ts'etta Allahee xəybıyiy ç'iye itxhın. ");
INSERT INTO tkr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ç'iye aq'vabıdena q'əradniy vod. K'orane xhyanbışin oodun ciga miç'axdaniy vod. Allahın Rı'h xhyanbışil ooadniy alycaxxva. ");
INSERT INTO tkr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Allahee uvhuyn: «Hasre işix ixhecen». İşix ıxhayn. ");
INSERT INTO tkr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allahık'le g'acuyn, işix yugda vod. Qiyğa Mang'vee işix miç'axıyvalike cura'an. ");
INSERT INTO tkr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allahee işixıs «yiğınyiğ», miç'axıyvalis «xəm» dobı huvu. Xəm quvxha, miç'eediy qıxha; in ts'ettiyn yiğ ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Qiyğa Allahee uvhuyn: «Hasre xhyanbışde yı'q'nee arka vuxhecen, xhyanbı sana-sançike cure'ecen». ");
INSERT INTO tkr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Həməxüdud ıxhayn. Allahee arka haa'ana, arkayn, çik avuduniy oodun xhyanbı sana-sançike cura'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allahee mane arkays «xəv» do huvu. Xəm quvxha, miç'eediy qıxha; in q'öd'esın yiğ ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Qiyğa Allahee uvhuyn: «Hasre xəək avudun xhyanbı sacigeeqa salecen, qeqquyn ciga g'acecen». Həməxüdud ıxhayn. ");
INSERT INTO tkr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allahee qeqquyne cigayk'le «ç'iye», xhyan sadıyne cigayk'lemee «deryahbıva» dobı huvu. Allahık'le g'acuyn, inəxüd yugda vod. ");
INSERT INTO tkr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Qiyğa Allahee uvhuyn: «Hasre ç'iyeyn aq'va xhınak qıxhecen: toxumbınan ok'bı-alafbı, curayn-curayn meyvabı eyxhen yivar aleyle'ecen, toxumbıd meyvabışde ad ixhecen». Həməxüdud ıxhayn. ");
INSERT INTO tkr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ç'iyeyne aq'vayn alabı aleyli'inbı: toxumbınan ok'bı-alafbı, curayn-curayn meyvabı eyxhen yivarıd alyadıynbı, toxumbıd meyvabışde ad ıxha. Allahık'le g'acuyn, inəxüd yugda vod. ");
INSERT INTO tkr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Xəm quvxha, miç'eediy qıxha; in xhebıd'esın yiğ ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Qiyğa Allahee uvhuyn: «Hasre xəəne arkee xəm yiğıke cura'an işixbı ixhecen. Mançin fəsilbı, yiğbı, senbı hagvecen. ");
INSERT INTO tkr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Hasre manbı xəə'əd işixbı ıxha, ç'iyelqa gyatk'vecen». Həməxüdud ıxhayn. ");
INSERT INTO tkr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Allahee q'ölle xədın işartı hı'ı: yiğınyiğ vuk'lek ıkkeecenva xədın işartı, xəm vuk'lek vukkeecenva k'ınin işartı. Mang'vee xənebıd hı'iynbı. ");
INSERT INTO tkr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Allahee manbı xəəne arkeeqa gitk'ıniynbı, ç'iyelqa işix gehecenva, ");
INSERT INTO tkr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","yiğıy xəm vuk'lek ıkkeecenva, işixıke miç'axiyvalla curee'ecenva. Allahık'le g'acuyn, inəxüd yugda vod. ");
INSERT INTO tkr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Xəm quvxha, miç'eediy qıxha; in yoq'ud'esın yiğ ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Qiyğa Allahee uvhuyn: «Hasre xhyanbı nafas ileşşene karbışika gyatsts'ece, ç'iyeyl oo, xəə xətta şit'yar aleetxvecen». ");
INSERT INTO tkr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Allahee xhyanee eyxhen ç'ak'ın karbı, gırgıne curaylin baluğar, gırgın hadağvan nafas helen karbı, mançika sacigee gırgıne curaylin gırgın xılibışikan şit'yar itxhın. Allahık'le g'acuyn, inəxüd yugda vod. ");
INSERT INTO tkr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Allahee mançis xayir-düə huvu eyhen: «G'adı geed qeetxhe, deryahbışeedın xhyanbı gyatsts'e'e; şit'yarıd ç'iyeyne aq'val geed qeetxhecen». ");
INSERT INTO tkr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Xəm quvxha, miç'eediy qıxha; in xhod'esın yiğ ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Qiyğa Allahee uvhuyn: «Hasre ç'iyeyne aq'vayn gırgıne curaylin nafas helen karbı: çavra-vəq'ə, hadağvan həyvanar, çolun həyvanar ixhnecen». Həməxüdud ıxhayn. ");
INSERT INTO tkr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Allahee curayn-curayn çolun həyvanar, çavra-vəq'ə, ç'iyeyl hadağvan, gırgın nafas helen həyvanar itxhıniynbı. Allahık'le g'acuyn, inəxüd yugda vod. ");
INSERT INTO tkr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Qiyğa Allahee uvhuyn: «Yişde k'op'yelyna, Şak akarana insan ixhanas. Hasre mang'vee deryahbışeene baluğaaşis, xəəne şit'yaaşis, çavra-vəq'əys, gırgıne ç'iyeyne aq'vays, ç'iyeyl hadağvane gırgınçis xəbvalla hee'ecen». ");
INSERT INTO tkr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Allahee insan Cune k'op'yeyl irxhın, Allahne k'op'yeyl irxhın, Adamiyiy zəiyfa ipxhın. ");
INSERT INTO tkr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Allahee manbışis xayir-düə huvu, uvhuyn: «Vuxooxe geeb qeepxhe, ç'iyeyn aq'va gyatsts'e'e, man vuşun vod. Deryahbışeene baluğaaşis, xəəne şit'yaaşis, ç'iyeyl hadağvane gırgıne nafas helençis eysivalla hee'e». ");
INSERT INTO tkr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Allahee uvhuyn: «Haane, ç'iyeyne aq'val toxum hoolen ok'bıd-alafbıd, gırgıne yivaaşin meyvabı şos helenbı, oxhnecenva. ");
INSERT INTO tkr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Gırgıne ç'iyelyne həyvanaaşis, gırgıne xəəne şit'yaaşis, gırgıne hadağvançis – nençeeyiy ı'mren nafas vod, gırgınçiscad Zı oxhnecenva xhınakın ok'bı helenbı». Həməxüdud ıxhayn. ");
INSERT INTO tkr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allahık'le g'ecen, itxhınin gırgın kar geed yugda vod. Xəm quvxha, miç'eediy qıxha; in yixhıd'esın yiğ ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","İnəxüd, xəybışiniy ç'iyeyn, maane gırgıne karan itxhıniy ç'əvexhen. ");
INSERT INTO tkr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Allahee yighıd'esde yiğılqameen işbı ç'əvə'ənbı, yighıd'esde yiğıl, hı'iyne işbışiker curxha manzil haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Allahee yighıd'esde yiğıs xayir-düə huvu, man yiğ mansa yiğbışike curuiyn, mane yiğıl gırgın ha'an işbı ç'əvü'ı', manzil haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Xəybıyiy ç'iye itxhıniyle qiyğiyna gaf: Rəbb Allahee xəybıyiy ç'iye itxhıniyle qiyğa, ");
INSERT INTO tkr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ç'iyeyne aq'val ok'bıyiy yivar ələə deşdiy. Rəbb Allahee gyoğiy g'ıxdevuva, sayid ç'iyee ezasda insan deşva, mançil-alla məxüd ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Xhyanıd ç'iyençeniy əlqəən. Mane xhyanıked ç'iyesın xhyanniy eyxhen. ");
INSERT INTO tkr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Manke Rəbb Allahee ç'iyeyne nyuq'vneke insan hı'ı, mang'une quşeeqa ı'mrene nafasna uf üvxü. Həməxürur insan üç'ür qıxha. ");
INSERT INTO tkr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Qiyğa Rəbb Allahee şargılyne Edenıl sa bağ ezu, irxhınna insanır maqa gixhxhı. ");
INSERT INTO tkr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Maa'ad Rəbb Allahee ç'iyeyl uftanda g'ecen, ittun oxhanas eyxhen meyvabınan xətta curayn-curayn yivar aleyli'ı. Mang'vee q'öble menne yivaaşik idyakarana yiv oozu: sa yivene meyvabışe ı'mı'r hoole, mansançined meyvabışe yuguniy pisın ats'axhya'asın ats'al hele. ");
INSERT INTO tkr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Bağıs xhyan helena sa damaniy Edeneençe gyobatstse, mançeb mana yoq'ne cigeeqaniy bit'alooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mançine sançin do Pişon vod. Mana bıkırne Xavila ölkayne hiqiy-allançeniy gyobatstse. Maa'ad k'ınəəğə qı'ğəə. ");
INSERT INTO tkr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","İne ölkayn k'ınəəğə yugun vod. İnyaa'ad yugun evanan gatraniy gıranna eke oniksıb vooxhena. ");
INSERT INTO tkr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Q'öb'esde damayn do Gixonodun. Manab bıkırne Kuş ölkayne hiqiy-allançeniy gyobatstse. ");
INSERT INTO tkr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Xhebıd'esde damayn do Dəclə (Tigır) vodun. Mana Aşşur ölkayne şargıle gyobatstse. Yoq'ub'esda damab Fəratobna (Yefrat). ");
INSERT INTO tkr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Rəbb Allahee insan Edenne bağeeqa giyxhena, man ezu, çikar ilekkecenva. ");
INSERT INTO tkr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Rəbb Allahee insanıs əmr hav'u uvhuyn: «Bağeene gırgıne yivaaşin meyvabı ıkkanang'a oxhanas əxə. ");
INSERT INTO tkr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Saccu yuguniy pisın ats'axha'ane yivena meyva umooxhan, mana opxhunne yiğıl qik'asda». ");
INSERT INTO tkr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Rəbb Allahee meed eyhen: «İnsan sayrena ıxhay yugda deşod, Zı mang'usda cus sik'ına sa kumagçiy ixhanasda». ");
INSERT INTO tkr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Rəbb Allahee gırgın çolun həyvanarıd, xəən şit'yarıd nyuq'vneke ha'a. Qiyğa Allahee manbı insanne k'anyaqa adaylenbı g'aces, mang'vee nəxdun dobıyiy mançis heles. İnsanee nene həyvanıs nen doyiy gixhxhı, məxüdud axvan. ");
INSERT INTO tkr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","İnsanee gırgıne çavra-vəq'əys, çolane həyvanaaşis, xəəne şit'yaaşis do hele, saccu cus sik'ına kumag ha'asda iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Mane gahıl Rəbb Allahee insan k'orane nik'eeqa g'ıxele. Mana nik'eenang'a, Rəbb Allahee mang'une mıglene t'eleyna sa alyapt'ı, çin cigad çurunuka gyatsts'ı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Rəbb Allahee insanıke alyapt'ıyne mıglene t'eleyke xhunaşşe irxhın. Yicir insanne k'anyaqa qarı. ");
INSERT INTO tkr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","İnsanee uvhuyn: «İlekke, ine yəqqees ıxhavud! İna bark'v yizde bark'una vob, Çurud yizde çurunun vod. Do „xhunaşşe“ ixhes, Mana adamiyke alyart'uva». ");
INSERT INTO tkr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mançil-alla adamee dekkiy yed g'alyabaççe, xhunaşşeyka eyxhe. Adamiyiy xhunaşşe sa vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adamiyiy cuna xhunaşşe – q'öyursana ts'elebniy vob, manbışis mançile naş qexhe deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Rəbb Allahee itxhınne çolune həyvanaaşina, gırgınçile hiyləgarna xoçeniy vob. Xoçeyn zəiyfayk'le uvhuyn: – Hək'edane, Allahee şok'le bağeene yivaaşina nençinacab meyva umooxhan uvhu? ");
INSERT INTO tkr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Zəiyfee xoçeyk'le eyhen: – Bağeene yivaaşin meyvabı oxhanas əxə. ");
INSERT INTO tkr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Saccu bağne yı'q'neene yivene meyvabışde hək'ee Allahee uvhu: «Mançike umoyxhan, mançik sumoot'a, deşxhee, hapt'asınbı!» ");
INSERT INTO tkr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Xoçeyn zəiyfayk'le uvhuyn: – De'eş, nəxübcab hapt'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Allahık'le ats'an, mane yivena meyva opxhuniyng'a, vuşun ats'al geed qixhes, yuguniy pisın ats'axhxha, Allah xhinne qeepxhes. ");
INSERT INTO tkr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Zəiyfayk'le g'ecen, mane yiven meyvabı oxhanasıd kara'ə vod, ulesqadıd yugda vod qöö, ats'al ıkkanang'usud ıkkanəxdıd. Mançil-allab məng'ee mana meyva qopxu opxhanna. Qiyğab k'ane ulyorzulyne adamiys meyva hoole, mang'veeyib ooxhanna. ");
INSERT INTO tkr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mane gahıl q'öng'ussana ats'al qadayle, ts'eleb vuxhay ats'axhen. Məxüd ıxha manbışe inciliyne t'eleyke cos tanalqanbı ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Manbışik'le yiğıne serınne gahıl bağee iykaran Rəbb Allahın nıq' g'iyxhe. Manbı heepxı bağeene yivaaşine yı'q'nee dyuguleebaxhe. ");
INSERT INTO tkr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Rəbb Allahee Aadamılqa onu'u, qiyghanan: – Ğu nyaane? ");
INSERT INTO tkr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mang'vee eyhen: – Bağeead yiğın nıq' g'ayxhı, ts'eler ıxhal-alla qərq'ı'n, dyugulyxhana. ");
INSERT INTO tkr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Rəbb Allahee eyhen: – Şavaane vak'le ğu ts'eler ıxhay uvhu? Deşxhee, vas oxhanas q'adağa hav'uyne yivena meyvane opxhun? ");
INSERT INTO tkr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Aadamee eyhen: – Zaka sacigee yixhecenva, Ğu hiyvuyne xhunaşşee mane yivene meyvayke zas huvu, zınab opxhunna. ");
INSERT INTO tkr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Rəbb Allahee zəiyfayk'le eyhen: – Ğu hı'iyn hucoon? Zəiyfee eyhen: – Xoçeyn zı yəqqı'le qığeyhı, zınab opxhunna. ");
INSERT INTO tkr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Rəbb Allahee xoçeyk'le uvhuyn: – Ğu in hı'il-alla, gırgıne çavra-vəq'əyne, çolane həyvanaaşine yı'q'nee bed-düə alyapt'ı: ı'mı'rvolle vuxhnel habğı nyaq'v ooxhanas. ");
INSERT INTO tkr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Zı, yiğneyiy zəiyfayne əreeqa, vuşde kulyfatbışde əreeqa duşmaniyvalla abçes. Şeng'une kulyfatın yiğne vuk'les ı'xəs, ğunab mang'une mı'q'les üvxəs. ");
INSERT INTO tkr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Qiyğa Rəbb Allahee zəiyfayk'le eyhen: – Vas vuxhnenang'a geeb xəppa əziyyat hevles, uşaxar k'ovaka vuxas. Adamee valqa k'ırı gyaqqı vas ıkkiykanas, Meeb mang'veecab xəbvalla vas haa'as. ");
INSERT INTO tkr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Qiyğa Rəbb Allahee Aadamık'leme uvhuyn: – Ğu xhunaşşel k'ırı alixhxhı, umooxhan uvhuna meyva opxhun. Həşdeb val-alla nyaq'v bed-düə hav'u. I'mı'rvolle zəhmətıka ğu vasın g'ık nyuq'vnel ha'as. ");
INSERT INTO tkr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mançin vas zazaayiy ğı'ç'iy aleylya'as, ğunad, ğu ezuyne ç'iyel hucooyiy alyadı man oxhanas. ");
INSERT INTO tkr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nyuq'vnelqa sak'alasmee, ligayne şinıka hı'iyn g'ık oxhanas. Ğu nyaq'v vorna, mançike alyart'uva, ğu nyuq'vnelqar sak'alasda. ");
INSERT INTO tkr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aadamee xhunaşşeyn do Həva (ı'mı'r) giyxhe. Mana ç'iyeyne aq'val vuxhaynbışda gırgıng'una yed yeexhe. ");
INSERT INTO tkr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Manke Rəbb Allahee Aadamılqayiy xhunaşşelqa g'ekvayke tanalinbı hı'ı, alya'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Qiyğa Rəbb Allahee uvhuyn: – Haane, insanık'le yuguniy pisın hucoo ıxhay ats'axhxha, yişda sa xhinne qexhe. Hasre ı'mrene yivena meyva qopxu umooxhancen, gırgıne gahbışisır ımaxvacen! ");
INSERT INTO tkr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Vuc alyart'uyne nyuq'vnel işlemişxhecenva, Rəbb Allahee insan Edenne bağeençe g'e'eşşena. ");
INSERT INTO tkr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mang'vee Eden bağne şargılqa g'oramişa'an malaaikariy gırgıne suralqa iliyk'aran ts'ayıkan g'ılınc giyxhe ı'mrene yivelqa əəna yəq avqecenva. ");
INSERT INTO tkr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Aadam xhunaşşe Həvayka g'alirxhu, mana vuxhne ayxu Gaabil (alyaart'una) uxu. Həvee eyhen: «Rəbbike zı insan pay xhinne alyart'u». ");
INSERT INTO tkr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Qiyğa məng'ee Gaabilna çoc Haabil uxooxa. Haabil vəq'əbı uxhiyxhanna eyxhe, Gaabilir ç'iye ezana. ");
INSERT INTO tkr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sabara vaxt ılğevç'uyle qiyğa, Gaabilee Rəbbis ç'iyeyl alyadıynçike pay abayle. ");
INSERT INTO tkr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Haabileyid ts'etta syurunee ıxhayne nekke yugne vəq'əbışike adayle. Rəbbee Haabilir, Haabile adıynbıd alyaat'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Gaabilir, Gaabilee adıynbıd Rəbbee alyaat'a deş. Mançil-alla Gaabilis it'umba qəl vuxha, aq'va gyavaxana'a. ");
INSERT INTO tkr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Rəbbee Gaabilik'le uvhuyn: – Nya'a qəl haa'a? Nya'a aq'va gyavaxanı'ı? ");
INSERT INTO tkr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nya'a, yugna iş haa'axhee, Zı ilydyabat'aye? Yugna iş hidyaa'axhee, bınahın akkayne ögee gugu hav'u, ğu gozet ha'a. Mançin xuruş valqa vod, ğu mançis xəbvalla haa'as vukkan. ");
INSERT INTO tkr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Qiyğa Gaabilee Haabilik'le eyhen: – Qora çoleeqa vüqqəs. Maa'ad Gaabilee çoculqa xıl g'ot'ul, mana gek'ana. ");
INSERT INTO tkr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Qiyğa Rəbbee Gaabilike qidghın hı'iyn: – Çoc Haabil nyaane? Mang'vee eyhen: – Ats'a deş. Nya'a, zı çocuna g'aravulyne vor? ");
INSERT INTO tkr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Rəbbee eyhen: – Ğu hı'iyn hucoon?! Çocune eban ç'iyeençe Zalqa ona'a. ");
INSERT INTO tkr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mane nyuq'vnen yiğne xıleke k'yapk'ınna çocuna eb hööğəs ghal aaqı. Mançil-allab ğu ine nyuq'vnel bed-düə alyabat'a. ");
INSERT INTO tkr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","G'iyniyke şaqa ğu nimee yugda ç'iye ezveeyid, mançin vas ıkkanəxüdın kar heles deş. Ğu ciga deşda g'e'eşşuna xhinne ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Gaabilee Rəbbik'le eyhen: – Yizda cazaa ts'ıts'aa'asınçileb hexxaba vob. ");
INSERT INTO tkr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Haane, Ğu zı g'iyna ç'iyeyne aq'valer g'e'eşşena. Valer dyugulyxha, zı ciga deşda ixhes. Şavneyiy ögiylqa qığeç'u, mang'veeyir zı gik'asda. ");
INSERT INTO tkr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Rəbbee mang'uk'le eyhen: – De'eş, şavaayiy Gaabil gik'u, mang'uke yighne yəqqees qəl qığaahas. Rəbbee Gaabililqa işaara giyxhe, mana qızaxxıng'vee gimek'acenva. ");
INSERT INTO tkr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Gaabil Rəbbike ark'ın Eden bağne şargıl – Nod eyhene cigee axva. ");
INSERT INTO tkr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Gaabil xhunaşşeyka g'alirxhu. Mana vuxhne ayxu, Xanok uxu. Mane gahıl mang'vee şaharniy alyaa'a. Şaharılqa, Xanokun, dixen do giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Xanokike İrad g'arayle. İradıker Mehuyael g'arayle. Mehuyaeliker Metuşael g'arayle. Metuşaeliker Lemek g'arayle. ");
INSERT INTO tkr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemekee q'öyre xhunaşşe hee'e. Sang'ı'n do Ada, mansəng'ı'nıd Tsillaniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adee Yaval uxu. Yaval çadıree aaxvanbışda, syuru havacenbışda ts'erriyna insan ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mang'une çocun do Yuvalniy. Mana lirayiy dyuttyak' əlivxüna ts'erriyna insan ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tsillee Tuval-Gaabil uxu. Tuval-Gaabilee tuncıkeyiy yivayke curayn-curayn əhtacbıniy ha'a. Mang'uqa Naama eyhena yuçuniy vor. ");
INSERT INTO tkr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemekee xhunaşşeeşik'le in uvhu: «Adayiy Tsilla, zı eyhen g'ayxhe! Lemekın xhunaşşer, yizde cuvabıl k'ırı alixhxhe: Zak ciga hı'iynçil-alla zı sa adamiy gik'u, zas ı'xiynçil-alla zı gade gik'u. ");
INSERT INTO tkr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Gaabilil-alla yighne yəqqees qəl qığaahasxhee, Lemekıl-allab yights'ale yighne (77) yəqqees qəl qığaahas». ");
INSERT INTO tkr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Aadam meer xhunaşşe Həvayka g'alirxhu. Mana vuxhne ayxu, sa dix uxu. Mang'us Şet doyud gixhxhı, eyhen: «Gaabilee gik'uyne Haabilyne cigeeqana Allahee zas meerna dix huvu». ");
INSERT INTO tkr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Şetiqar sa dix eyxhe, doyud Enoş giyxhe. Mane gahıl insanaaşe Rəbbis ı'bəədat ha'a giviyğal. ");
INSERT INTO tkr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aadamne nasılın taarix inəxüd vod. Allahee insan iyxhanang'a, mana Cuk akarara irxhın. ");
INSERT INTO tkr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mang'vee adamiyiy zəiyfa ipxhın. Manbışis xayir-düə huvu. İpxhınne yiğıl manbışis «insan» do gixhxhı. ");
INSERT INTO tkr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Aadamın vəşşe xhebts'al (130) sen g'adıyng'a, cuk akarana, cune k'op'yeylna sa dix ıxha. Doyud Şet giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Aadam, Şet ıxhayle qiyğa molyud vəşşe (800) senna axu. Mang'uqa mebın dixbıyiy yişbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Aadam yüç'üd vəşşe xhebts'al (930) senna axu, qik'u. ");
INSERT INTO tkr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Şetıqa vəşşe xholle (105) sennang'a mang'us dix Enoş eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enoş ıxhayle qiyğa, Şetee molyud vəşşe yighılle (807) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Şetee yüç'üd vəşşe yits'ıq'vəd (912) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoşuqa yüç'əl (90) sennang'a, mang'us dix Qenan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Qenan ıxhayle qiyğa, Enoşee molyud vəşşe yits'ıxhvad (815) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoşee yüç'üd vəşşe xholle (905) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qenanıqa yights'al (70) sennang'a, mang'us dix Mahalalel eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel ıxhayle qiyğa, Qenanee molyud vəşşe yoq'ts'al (840) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Qenanee yüç'üd vəşşe yits'ılle (910) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleliqa yixhts'ale xholle (65) sennang'a, mang'us dix Yered eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yered ıxhayle qiyğa, Mahalalelee molyud vəşşe xhebts'al (830) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalelee molyud vəşşe yüç'əle xholle (895) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yeredıqa vəşşe yixhts'ale q'ölle (162) sennang'a, mang'us dix Xanok ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Xanok ıxhayle qiyğa, Yeredee molyud vəş (800) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yeredee yüç'üd vəşşe yixhts'ale q'ölle (962) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Xanokuqa yixhts'ale xholle (65) sennang'a, mang'us dix Metuşelax eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metuşelax ıxhayle qiyğa, Xanok xhebıd vəş (300) senna Allahne yəqqı'n ark'ın. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Xanokee xhebıd vəşşe xholle (365) sen hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Mana Allahne yəqqı'n ark'ın. Qiyğa mana Allahee insanaaşine yı'q'neençe Cusqa üç'ürra alyarat'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuşelaxıqa vəşşe molyts'ale yighılle (187) sennang'a, mang'us dix Lamek ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamek ıxhayle qiyğa Metuşelaxee yighıd vəşşe molyts'ale q'ölle (782) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metuşelaxee yüç'üd vəşşe yixhts'ale yüç'üd (969) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamekıqa vəşşe molyts'ale q'ölle (182) sennang'a, mang'us dix eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mang'vee dixın do Nüh (yik'bı huviy) gixhxhı, eyhen: «İne dixee, Rəbbee bed-düə hav'uyne ç'iyel, ts'ıts'a'ane əq'übabışee, yişde işbışee şas yik'bı heles». ");
INSERT INTO tkr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nüh ıxhayle qiyğa, Lamekee xhod vəşşe yüç'əle xholle (595) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamekee yighıd vəşşe yights'ale yighılle (777) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nühüs xhod vəş (500) sen qalesse, mang'us Sam, Ham, Yafəs donan dixbı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","İnsanar ç'iyeyne aq'val geeb qeebaxheng'a, manbışis yişbı vuxooxa, ");
INSERT INTO tkr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","manbışde yişbışda micagiyvalla malaaikaaşik'le g'oocena. Cone yik'es yikkanna nenayiy məng'ı'ke xhunaşşe hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Rəbbee eyhen: – Yizın Rı'h insanee gırgıne gahbışis deş vod. Manbıb gırgıne gahbışisınbı deş vob. Manbışis huvuna ı'mı'r vəşşe g'ane (120) senıle hexxaba vuxhes deş. ");
INSERT INTO tkr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Malaaikaaşe insanaaşin yişbı haa'ane gahılib, mançile qiyğiyne dövurbışilib məxbın ç'ak'ın insanar ç'iyeyne aq'valqa vuxooxa vuxha. Manbı avaalıyne dövrun kuşdukurar, qıvaats'an insanar vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Rəbbik'le g'ecen, ç'iyeyne aq'valyne insanaaşine ək'lee, fıkree pisvalla hav'uy vob. ");
INSERT INTO tkr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mang'vee aq'va gyavaxan ha'a. Ç'iyeyne aq'valqa insanar ipxhınva, mang'un yik' gyoyxhan. ");
INSERT INTO tkr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Rəbbee eyhen: – İpxhınin insanar ç'iyeyne aq'vayle havaakal haa'asınbı. Man insanaaşika sacigee həyvanaşined, ç'iyeyl hadağvançined, şit'yaaşined vuk'lelqa qalya'asın. Manbı ipxhınva Yizın yik' gyotxhan. ");
INSERT INTO tkr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Saccu sa Nüh Rəbbine ulen aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nühün taarix inəxüd vod: Nüh qorkuna, məttın yik'nana cune nasılee insan ıxha. Mana Allahne yəqqı'lyniy vor. ");
INSERT INTO tkr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nühüqa xhebiyre dix eyxhe: Sam, Ham, Yafəs. ");
INSERT INTO tkr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Allahne ulele dyunye g'e'exhxhan, pisvalin gyayts'e. ");
INSERT INTO tkr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Gırgın insanar qopkune yəqqı'le qığeepç'iynbı. Allahık'le g'ecen, dyunye badalxha vod. ");
INSERT INTO tkr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Allahee Nühük'le uvhuyn: – Yizde ək'elee gırgınçin q'omıd hitxhır. Dyunye manbışde pisvalika gyatsts'ı. Mançil-allab Zı manbı ç'iyeyne aq'vayka sacigee havaakal haa'as. ");
INSERT INTO tkr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Vas goferne yiveke sa gamı he'e. Ad gozeer hı'ı, adğançed, g'adğançed yivena mızla qabğvee. ");
INSERT INTO tkr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Gamı inəxüd he'e: mançina xıliyvalla xhebıd vəş (300) xılekkum, əq'valla xhots'al (50) xılekkum, axtıvallab xhebts'al (30) xılekkum vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gamıyne ooğançe sa xılekkum avud g'uly he'e. Mıgleked akka gixhxhe. Gamıyka avubna, yı'q'nekna, oona mərtaba vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Zı ç'iyeyn aq'va q'ıfrımıka qadıyne xhineka alyaat'asın. Xəək avudun nafas alyaat'an gırgın kar hakkal ha'asın. Ç'iyeyne aq'valin gırgın kar qik'asın. ");
INSERT INTO tkr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Zı mugaavile saccu vaka ha'a: ğu dixbışika, xhunaşşeyka, sossaaşika sacigee gameeqa ılqeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Vaka üç'üdda axvecenva, gırgıne həyvanaaşike nafas helenemeene karbışike q'öblena, vughulyna-xhuvulyna, gameeqa aleet'e. ");
INSERT INTO tkr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Q'öblena gırgıne şit'yaaşike, həyvanaaşike, ç'iyeyl hadağvançike vasqa qales, üç'üdda axvecenva. ");
INSERT INTO tkr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Vasqa oxhanas eyxhençike vasınıd, çisınıd se'e. ");
INSERT INTO tkr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nühee gırgın kar Allahee uvhuyn xhinne ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Rəbbee Nühük'le uvhuyn: – Xizanıka sacigee gameeqa ılqeç'e. Yizde ögee, vale qorkuna ine nasılee deşor. ");
INSERT INTO tkr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Dyunyeyne aq'vayle cins g'ıts'maaq'vancenva məttıne həyvanaaşina yighıble q'öblena, xhalyne həyvanaaşina vughulyna, xhuvulyna alept'e. Gırgıne xəəne şit'yaaşinab yighıble q'öblena alept'e. ");
INSERT INTO tkr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Yighne yiğılee, ç'iyeyne aq'valqa yoq'ts'al (40) yiğnayiy yoq'ts'al xəmna gyoğiy gyoğa'as. İtxhınin nafasnan gırgın kar ç'iyeyne aq'vayle hakkal ha'asın. ");
INSERT INTO tkr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Rəbbee Nühülqa nəxübiy əmr hav'u, mang'vee gırgın kar həməxüdud hı'iyn. ");
INSERT INTO tkr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ç'iyeyn aq'va q'ıfrımıka qadıyne xhinen alyaat'uyng'a, Nühüqa yixhıd vəş (600) sen ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nüh, cuna xhunaşşe, dixbı, sossar sacigee xhyanıke g'attivxhanasdemee gameeqa ılqeebaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Allahee Nühük'le uvhuyn xhinne, məttın, xhalin həyvanar, şit'yar, gırgın ç'iyeyl hadağvanbı q'öble-q'öblena, vughulynayiy xhuvulyna, Nühüka gameeqa ılqeedaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ç'iye yighne yiğıle q'ıfrımıka qadıyne xhinen alyaat'an. ");
INSERT INTO tkr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nühüne ı'mrene yixhıd vəş'esde (600) senne, q'öb'esde vuzanee yits'ıyighad'esde (17) yiğıl məxdun q'ıfrımıkan gyoğiy gyooğa giyğal, ittehesu, xəən g'uleppı aaqı. Gırgıned k'oralybışeençe xhyan ı'xı'yxə giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yoq'ts'al (40) yiğna, yoq'ts'al xəmna gyoğiy gyoğu. ");
INSERT INTO tkr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mane yiğıl Nühüka sacigee cuna xhunaşşe, dixbı Sam, Ham, Yafəs, con xhunaşşer gameeqa ılqeebaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Manbışika sacigee gırgın həyvanar: çavra-vəq'ə, çolun həyvanar, şit'yar, gırgın ileedaxvanbı, ç'iyeyl hadağvanbı, gameeqa ılqeedaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Gırgın nafas ileşşenbı q'öblena Nühüka gameeqa ılqeeç'u. ");
INSERT INTO tkr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Allahee Nühük'le uvhuyn xhinne, gırgıne həyvanaaşina vughulynayiy xhuvulyna qabı. Manbışiqad qihna Rəbbee gamıyn akka qa'an. ");
INSERT INTO tkr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Q'ıfrım gibğılıyn yoq'ts'al (40) yiğ ıxhamee, xhyan geed qıxha gamı ç'iyeyle haly'etçuyn. ");
INSERT INTO tkr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Xhyan geed ooqa ılqeç'e, gamıd xhinene aq'val ı'ğiykar giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Geed qıxhayne xhyanın, nekke axtın suvabıd çik avud g'alya'a. ");
INSERT INTO tkr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Xhyan yits'ıxhvalle (15) xılekkumna suvabışile axtı qexhe. ");
INSERT INTO tkr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Ç'iyeyne aq'valin gırgın kar: şit'yar, çavra-vəq'ə, çolun həyvanar, hadağvanbı, insanar, nafas ileşşen gırgın qeek'an. ");
INSERT INTO tkr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Rəbbee ç'iyeyne aq'valin nafas ileşşen gırgın kar hakkal ha'an: insanaaşile otçu, çavra-vəq'ə, hadağvanbı, xəəne şit'yaaşılqamee nafas ileşşen gırgın kar gek'an. Saccu Nühiy gameebınbı üç'übba axva. ");
INSERT INTO tkr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Xhyan ç'iyeyne aq'val vəşşe xhots'al (150) yiğna geed qıxhayle qiyğa, ");
INSERT INTO tkr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Allahee Nühür, Nühüka gameedın gırgın çolun həyvanar, çavra-vəq'ə yik'el qalya'an. Allahee ç'iyeyne aq'valqa ablyav'uyne mıtsıka xhyanbı k'ıl qeedaxhe giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Allahee k'oralybıyiy xəən g'uleppı ut'uma'anbı, gyoğiy ulyoyzaran. ");
INSERT INTO tkr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Xhyan ç'iyene aq'vayle ts'ıts'exhxhe giyğal. Vəşşe xhots'alyne (150) yiğıle xhyan k'ıl qexhe. ");
INSERT INTO tkr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yighıb'esde vuzane yits'ı yighad'esde (17) yiğıl gamı Araratne suvabışil ulyoyzaran. ");
INSERT INTO tkr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Yits'ıd'esde vuzalqame xhyan k'ıl qexhe. Yits'ıd'esde vuzane ts'ettiyne yiğıl suvabışin vuk'ulybı g'ece giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nühee yoq'ts'alyne (40) yiğıle vuce hı'iyn gamıyn g'uly aaqı, ");
INSERT INTO tkr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","qən g'avku. Xhyan qeqqvasme, qən ulyooxa, hapk'ın qavayle vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Xhyan ç'iyene aq'vayle ts'ıts'xhay ats'axhxhesdemee, ine yəqqee Nühee qı'nerke g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Qı'nerkeyk'le givxasın ciga iveeke deş, ç'iye xhyanın aqqı eyxhe. Mana Nühüsqa gameeqa siviyk'al. Xıl hotku Nühee qı'nerke avqu, gameeqa abaççe. ");
INSERT INTO tkr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Yighılle yiğ ılğeç'uyle qiyğa, mang'vee qı'nerke sayib g'ookana. ");
INSERT INTO tkr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Exhalqana qı'nerke mang'usqa sapk'ılıyng'a, mançe k'uxhee xhınakna zeytunna t'ele avqu vooxhe. Manke Nühük'le ats'axhen, xhyan ç'iyeyne aq'vayle ts'ıts'xha vod. ");
INSERT INTO tkr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Yighılle yiğ ılğeç'uyle qiyğa, mang'vee sayib qı'nerke g'ookana, mane yəqqee mana mang'usqa siviyk'al deş. ");
INSERT INTO tkr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ts'eppiyne vuzane ts'ettiyne yiğıl Nühüne ı'mrene yixhıd vəşşe ts'ettiyne (601) senee ç'iyeylin xhyan qeqqvan. Nühee gamıyn oodun ciga qottulıyng'a, ç'iye qeqqu g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Q'öb'esde vuzane g'ayi yighad'esde (27) yiğıs, ç'iye bıkırda qeqqvan. ");
INSERT INTO tkr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Allahee Nühük'le uvhuyn: ");
INSERT INTO tkr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","– Ğu yiğne xhunaşşeyka, dixbışika, sossaaşika sacigee gameençe qığeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Vaka sacigeedın gırgın nafas ileşşenbı, şit'yar, həyvanar, ç'iyel hadağvanbı g'aqa qığe'e. Hasre ç'iyeyne aq'valqa aykkecen, g'adı geed qeetxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nüh cune xhunaşşeyka, dixbışika, sossaaşika sacigee gameençe qığeç'ena. ");
INSERT INTO tkr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Gırgın həyvanar, hadağvanbı, şit'yar, ç'iyene aq'valin nafas ileşşen gırgın kar çika sacigeedınçika gameençe qığeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nühee Rəbbis q'urbanbı allya'an ciga alya'a. Mançil mang'vee gırgıne məttıne həyvanaaşike, şit'yaaşike, gyooxhan ha'an q'urbanbı alya'a. ");
INSERT INTO tkr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mançin yugun eva Rəbbis ı'xı'mee, Mang'vee cune yik'ee inəxüd uvhu: – K'ılybanançile otçu insanaaşin fıkırbı yugunbı eyxhe deş. Manbışil-alla sayib ç'iyeys bed-düə haa'as deş. Həşde hı'iyn xhinne, gırgın nafas ileşşenbı hakkal ha'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Dyunye ıxhaylette, Ezuy-qiyşılıy, g'üməəla-mık'aala, G'ı'l-q'ı'dim, xəm-yiğ Ç'əvxhes deş. ");
INSERT INTO tkr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Allahee Nühüsiy Nühüne dixbışis xayir-düə huvu, manbışik'le uvhuyn: – Vuxooxu geeb qeepxha ç'iyeyn aq'va gyatsts'e'e. ");
INSERT INTO tkr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ç'iyeylin gırgın həyvanar, xəədın şit'yar, hadağvanbı, deryahbışeedın baluğar şole qəq'ənasınbı, manbı vuşde xıleqa quvu. ");
INSERT INTO tkr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nafas ileşşen gırgınbı şos oxhanas ixhecen. Nəxüdiy Zı şos şenke ç'iyel alyadıyn oxhanas huvu, həşded manbı hele. ");
INSERT INTO tkr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Saccu mançin çuru ebaka umoyxhan, mançee rı'h vodun. ");
INSERT INTO tkr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Şavaayiy vuşda eb k'yav'u, şu ı'mreke hav'u, mana həyvan vuxheeyib, insan ixheeyir Zı hı'sab qeqqasın. ");
INSERT INTO tkr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Şavaayiy insanna eb k'yav'u, Mang'unab eb insanne xıleke k'yavaak'anas. Allahee insan Cune k'op'yel irxhınil-alla. ");
INSERT INTO tkr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","G'abı geeb qeepxhe. Ç'iyene aq'valqa avkke, hexxeepxhe. ");
INSERT INTO tkr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Qiyğa Allahee Nühük'leyiy cune dixbışik'le uvhuyn: ");
INSERT INTO tkr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","– Şoqab, şole qihniyne vuşde nasılıqab, gameençe qığeç'uyne gırgıne nafas ileşşençika: şit'yaaşika, çavra-vəq'əyka, çolune həyvanaaşika Zı mugaavile haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Zı şoka inəxübna mugaavile haa'a: sayid inçile qiyğa q'ıfrımıka qadıyne xhyanın ç'iyeyne aq'vayka sacigee nafas ileşşenbı hakkal ha'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Allahee uvhuyn: – Yizda şokana, şoka ıxhayne gırgıne nafas helençika hav'uyne gırgıne gahbışisde mugaavileyn işaara in ixhes: xəybışeeqa gyuvxhuna Yizda xənevur. ");
INSERT INTO tkr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Zı xəybışeeqa buludbı qali'iyng'a, buludıka sacigee xənevur g'yavaales, ");
INSERT INTO tkr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","manke Zı şokayiy, gırgıne nafas helençika hav'une mugaavileyna fıkır ooxhanas. Sayid nafas ileşşenbı hakkal ha'asın q'ıfrımıka xhyan qales deş. ");
INSERT INTO tkr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mısayiy xənevur qığevç'u, Zı mançiqa ilyakkı, ç'iyene aq'val nafas helene gırgınçika hav'una gırgıne gahbışisda mugaavile yik'el qavaalyaa'asda. ");
INSERT INTO tkr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Allahee Nühük'le meed eyhen: – Yizın ç'iyeyne aq'val gırgıne nafas helençika hav'uyne mugaavileyna işaara haane. ");
INSERT INTO tkr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nüh cune dixbışika, Samıka, Yafəsıka, Hamıka gameençe qığeç'una (Kana'an Hamna dixniy vor). ");
INSERT INTO tkr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Mana xhebırsana Nühün dixbıniy vob. Ç'iyeyne aq'valqa ipxhınin gırgın insanar manbışike g'abı. ");
INSERT INTO tkr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nüh giyğalna man cigabı eza. Qiyğa mang'vee maqa t'ımılen bağ adaççe. ");
INSERT INTO tkr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mang'vee çaxır ulyodğu, p'iyan qıxha, cune çadıree ts'eler g'ılexha. ");
INSERT INTO tkr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kana'anne dekkık'le Hamık'le mana ts'eler g'acu, g'aqa qığeç'u, mançine hək'ee q'öne cune çocuk'le eyhen. ");
INSERT INTO tkr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sameeyiy Yafəsee tanalqan kar alyaat'u, cone mıgabışilqa atçu, yı'q'ı'hiyna aqa ikkeepç'ı, dekkıne ts'elene tanalqa adaççe. Manbışe aq'vabı menne suralqa sak'al hı'ı ıxha, dek ts'eler g'ımececeva. ");
INSERT INTO tkr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nüh culqa qarımee, k'ınne dixee hı'iyn ats'axhxha, eyhen: ");
INSERT INTO tkr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","– Kana'annıs bed-düə vuxhena, cune xınıbışde həmbalaaşis həmbal ixhena. ");
INSERT INTO tkr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mang'vee meed eyhen: – Rəbbis, Samıne Allahıs, şukur vuxhena, Kana'an Samıs həmbal ixhena. ");
INSERT INTO tkr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Allahee Yafəsın cigabı geed qa'anbı, cune çocune Samıne çadırbışee axvana. Kana'anır Yafəsıs həmbal ixhena. ");
INSERT INTO tkr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nühee q'ıfrımıle qiyğa xhebıd vəşşe xhots'al (350) sen ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nühee yüç'üd vəşşe xhots'al (950) sen hı'ı, qek'a. ");
INSERT INTO tkr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nühüne dixbışin Samın, Hamın, Yafəsın nasılbı inbı vod. Q'ıfrımıle qiyğa manbışis dixbı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafəsin dixbı: Gomer, Magog, Maday, Yavan, Tuval, Meşek, Tiras. ");
INSERT INTO tkr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomerin dixbı: Aşkenaz, Rifat, Togarma. ");
INSERT INTO tkr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavanın dixbı: Elişa, Tarşiş, Kittim, Dodanim. ");
INSERT INTO tkr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Manbışiked adabışeeyiy deryahbışde mıgılybışee axvan milletbı qadı. Manbı cone cigabışeeqa ehevku, avayk'an. Manbışde gırgınbışiqa cona nasıl, cona miz vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamın dixbı: Kuş, Misir, Put, Kana'an. ");
INSERT INTO tkr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuşun dixbı: Seva, Xavila, Savta, Raama, Savteka. Raamayn dixbı: Şevayiy Dedan. ");
INSERT INTO tkr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuşus Nimrod donana sayır dix eyxhena. Mana ç'iyene aq'valyna ts'erriyna qıvaats'ına vuk'lek vukkekana ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrod Rəbbine ögiyl yugna k'onay ıxha, mançil-allad milletne yı'q'nee «Rəbbine ögiyl Nimrod xhineena yugna k'onayvaniy» eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrodne paççahiyvaleedın ts'ettiyn şaharbı inbıniy vod: Baabil, Erek, Akkad, Kalne. Mane şaharbışin gırgınbı Şinarne ölkeeniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mana ine cigabışeençe Aşşurne cigabışeeqa ark'ın, Nineva, Rexovot-İr, Kalax eyhen şaharbı ali'ı. ");
INSERT INTO tkr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Sayıb mang'vee Ninevayneyiy Kalaxne yı'q'neena Resen eyhena xəbna şahar alyav'u. ");
INSERT INTO tkr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirıke g'adıyn nasılbı inbı vod: Ludbı, Anambı, Lehavbı, Naftuxbı, ");
INSERT INTO tkr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusbı, Kasluxbı (manbışike g'abıynbı Filiştinbı vobunbı), Kaftorbı. ");
INSERT INTO tkr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kana'anıke g'abıynbı inbı vob: ts'erriyna dix Sidon, Q'et, ");
INSERT INTO tkr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","həməxbıb Yevusbı, Emorbı, Girgaşbı, ");
INSERT INTO tkr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Q'ivbı, Arqbı, Sinbı, ");
INSERT INTO tkr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Ervadbı, Tsemarbı, Xamatbı. Qiyğa Kana'anın nasılbı hiqiy-allane cigabışeeqa ehekka. ");
INSERT INTO tkr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kana'anbışin cigabı Sidonule Gazzayne k'anene Gerarılqamee, Sodomılqamee, Homoralqamee, Admalqamee, Leşayne k'anene Tsevoyimılqameeniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","İn Hamıke g'abıynbı cone nasılbışilqa, mizyaaşilqa, cigabışilqa, milletbışilqa, bit'aleepxhaynbıniy vob. ");
INSERT INTO tkr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafəsne xərne çocus Samıs dixbı vooxhe. Sam Evernayiy Everıke g'abıynbışda baba-didey eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Samın dixbı: Elam, Aşşur, Arpakşad, Lud, Aram. ");
INSERT INTO tkr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramın dixbı: Uts, Xul, Geter, Maş. ");
INSERT INTO tkr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakşadıke Şelax g'arayle, Şelaxıker Ever g'arayle. ");
INSERT INTO tkr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Everıs q'öyre dix eyxhe: ts'erriyng'un do Peleg (bit'alxhay) ıxha, mang'une gahıl ç'iyene aq'valin insanar bit'aleebaxhenbı. Mang'une çocun doyud Yoqtan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqtanıke Almodad, Şelef, Xatsarmavet, Yarax, ");
INSERT INTO tkr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diqla, ");
INSERT INTO tkr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oval, Avimael, Şeva, ");
INSERT INTO tkr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Xavila, Yovav g'abayle. Man gırgınbı Yoqtanıke g'abıynbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Manbı şargıl Meşale Sefarne suralqane suvabınane cigabışee aaxva vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","İn Samıke g'abıynbı cone nasılbışilqa, mizyaaşilqa, cigabışilqa, milletbışilqa, bit'aleepxhaynbıniy vob. ");
INSERT INTO tkr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Cone dekkaaşis, milletbışis sik'ı Nühüne dixbışin nasılbı inbı vod. Q'ıfrımıle qiyğa manbışde milletbışin insanar ç'iyene aq'valqa ehevku. ");
INSERT INTO tkr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bıkırne dyunyel sa miziy sa yuşe vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","İnsanar şargılqa qööng'ə, Şinarne ölkee manbışik'le q'adaal g'acu, maayib avxuynbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sana-sang'uk'le: «Qudoora karpıç hı'ı yugda qecesva» uvhu. Manbışe g'ayeyne cigee karpıç, battağne cigeeyid g'ır alyaat'u. ");
INSERT INTO tkr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Qiyğad «Şas, sa şahariy q'om xəybışeeqa hiviyxharna gulle alyav'u, do qığahas, deşxhee mançeb ehevkasınbıva» uvhu. ");
INSERT INTO tkr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","İnsanaaşe alyav'una şahariy gulle g'avces Rəbb avqa geç'e. ");
INSERT INTO tkr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Rəbbee uvhuyn: «Haane, manbışin gırgınbı sa milletinbı sa mizelenbı vob. Mançil-allad manbışe inəxübna iş haa'a gibğıl. Həşde manbışde yik'es hucooyiy ıkkan ha'as əxə. ");
INSERT INTO tkr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Qudoora geepç'ı manbışin mizyar alikka'as. Sang'vee uvhuyn mansanbışik'le mats'axhxhecen». ");
INSERT INTO tkr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","İnəxüb Rəbbe manbı ç'iyeyne aq'valqa ehevkaa'anbı, şahar alyav'uyid ulyoyzaran. ");
INSERT INTO tkr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Rəbbee insanaaşin mizyar alikkı'il-alla mane cigayk'le Baabil (alikkı'iy) eyhe. Ç'iyeyne aq'vayne yoq'ne suralqab mançe ehevkaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nühüne dixen Samın nasılın taarix inəxüd vod: q'ıfrımıka qadıyne xhinele q'ölle senna qiyğa, Samıqa vəş (100) sennang'a, mang'una dix Arpakşad yedike eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arpakşad ıxhayle qiyğa, Sam xhod vəş (500) senna axva. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpakşadıqa xhebts'ale xholle (35) sennang'a, mang'us dix Şelax eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Şelax ıxhayle qiyğa Arpakşadee yoq'ud vəşşe xhebılle (403) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Şelaxıqa xhebts'al (30) sennang'a, mang'us dix Ever eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ever ıxhayle qiyğa Şelaxee yoq'ud vəşşe xhebılle (403) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Everıqa xhebts'ale yoq'ulle (34) sennang'a, mang'us dix Peleg eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg ıxhayle qiyğa, Everee yoq'ud vəşşe xhebts'al (430) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegıqa xhebts'al (30) sennang'a, mang'us dix Reu eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu ıxhayle qiyğa Pelegee q'öd vəşşe yüç'ülle (209) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reuqa xhebts'ale q'ölle (32) sennang'a, mang'us dix Serug eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug ıxhayle qiyğa Reu'ee q'öd vəşşe yighılle (207) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruguqa xhebts'al (30) sennang'a, mang'us dix Naxor eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naxor ıxhayle qiyğa Serugee q'öd vəş (200) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naxoruqa g'aye yüç'əd (29) sennang'a, mang'us dix Terax eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terax ıxhayle qiyğa Naxoree vəşşe yits'ıyüç'əd (119) sen ha'a. Mang'us mebın dixbıyiy yişbıb vooxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teraxıs yights'al (70) sen qalesse, mang'uqa in dixbıniy vob: İbram, Naxor, Haran. ");
INSERT INTO tkr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teraxıke g'abıynbışin taarix inəxüd vod: Terax İbramna, Naxorna, Haranna dek ıxha. Haranıqa Lut donana sa dix ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran, vuc ıxhayne ölkee – Xaldeyaaşine Ur şaharee qik'uyng'a, mang'una dek üç'ürraniy vor. ");
INSERT INTO tkr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","İbrameyid Naxoreyid davatbı hı'ı. İbramne xhunaşşeyn do Saray, Naxorned xhunaşşeyn do Milka ıxha (Milkayiy İska Haranın yişbı vuxha). ");
INSERT INTO tkr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarays uşaxar vooxhe deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teraxee dix İbram, Haranna dix eyxhena neva Lut, İbramna xhunaşşe yeexhena sos Saray cuka alyabat'a. Kana'anne ölkeeqa vüqqəva, manbı sanab Xaldeyaaşine Ur şahareençe avayk'ananbı. Manbı Xaraneeqa qabı, maayib aaxvanbı. ");
INSERT INTO tkr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Q'öd vəşşe xholle (205) sennang'a, Xaranee Terax qek'ana. ");
INSERT INTO tkr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Rəbbee İbramık'le eyhen: – Yiğın cigabı, xınıbı, dekkın xav g'aleççe, Zı vak'le hagvasde cigeeqa hoora. ");
INSERT INTO tkr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Vas xayir-düə hevles, vake xədın millet g'ales, do axtı qa'as, yiğne doyuka xayir-düə hevles. ");
INSERT INTO tkr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Zı vas xayir-düə huvuynbışis xayir-düə, bed-düə hav'uynbışis bed-düə g'axuvles. Ç'iyeyne aq'valyne gırgıne milletbışe valek'ena xayir-düə alyapt'as. ");
INSERT INTO tkr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","İbram, Rəbbee eyhəxür, yəqqı'l gexha. Lutur mang'uka sacigee ayk'an. Xaraneençe qığeç'uyng'a, İbramıqa yights'ale xholle (75) senniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","İbramee Xaranee hı'iyn gırgın kar, xhunaşşe Saray, çocuna dix Lut, cun nukarar alyapt'ı Kana'anne ölkeeqa yəqqı'l gexha. Manbı Kana'anne ölkeeqa hiviyxharanbı. ");
INSERT INTO tkr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","İbram maa'ar, Şekem eyhene cigeene, More eyhene mı'qəsqa hiyxhar. Manke maa'ad Kana'anaaşin milletniy eyxhen. ");
INSERT INTO tkr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Rəbb İbramıs gyagu, uvhuyn: – Zı ina ölka yiğne nasılıs hevles. İbramee cus gyaguyne Rəbbis, maa'ad q'urbanbı allya'an ciga alya'a. ");
INSERT INTO tkr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mançer Bet-Eline şargılyne suvabınane cigeeqa ayk'an. Maa'ab mang'vee çadır giviyxə. Çadırne garbıl Bet-El, şargılib Ğay eyhena şahar vooxhe. İbramee maa'ad Rəbbis q'urbanbı gyaat'an ciga ali'ı, ı'bəədat ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","İbram k'ırra-k'ırra mançer canubulqa, Negevne sahrayne suralqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","İne ölkee it'umun mısvalybı xət qeetxhava, İbram sık'ınne gahıs Misirqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Misireeqa hiviyxharang'a, mang'vee cune xhunaşşeyk'le Sarayk'le eyhen: – Ğu geer uftanra yixhay, zak'le ats'an. ");
INSERT INTO tkr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Misirbışe ğu g'aycu, eyhesın: «İng'una xhunaşşevur». Manke manbışe zı gik'u, ğu üç'ürra g'alerçes. ");
INSERT INTO tkr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hucoone ixhes, ğu manbışik'le eyhe, ğu yizda yiçu vor, yiğnemee zak sidyoot'a, üç'ürra g'alyaraççe. ");
INSERT INTO tkr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","İbram Misirqa hirxhılymee, misiribışik'le mang'una xhunaşşe geer uftanra yixhay g'ecen. ");
INSERT INTO tkr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Zəiyfa g'aycuyne fironne, Misirne paççahne, insanaaşe məng'ı'ne micagiyvalina gaf fironus haa'a. Manar qiykekkana fironne sareeqa. ");
INSERT INTO tkr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Firon məng'ı'nimee İbramıkar yugra ıxha. Mang'uqa çavra-vəq'ə, əməler, devabı, nukar adamer, nukar yedar vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","İbramne xhunaşşe Saraynimee Rəbbee fironneyiy fironne xaabınbışilqa xətta ık'arbı allya'a. ");
INSERT INTO tkr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Fironee İbram qort'ul, eyhen: – İn hucoon ğu zak hı'iyn?! Nya'a Saray yiğna xhunaşşe yixhay ittevhu? ");
INSERT INTO tkr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nişil-allane «yizda yiçuva» uvhu, məng'ı'ka davatbı ha'as hassır? Alert'e yiğna xhunaşşer, hoora! ");
INSERT INTO tkr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fironee İbramiy cuna xhunaşşe, coqa vonnemeene karaka sacigee ölkeençe yəqqı'l hee'eva əmr haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","İbram xhunaşşeyka, cuka vonne karaka sacigee Misirğançe qığeç'u, Negev eyhene sahreeqa ayk'an. Lutur mang'uka ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","İbramıqa manke geed çavra-vəq'ə, nuk'rayiy k'ınəəğə ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Negevğançe qığeç'u, İbram k'ırra-k'ırra vucee şenke çadır güvxüyne cigeeqamee qaraylena. Man ciga Bet-El eyhene şaharneyiy Ğay eyhene şaharne yı'q'nee ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Mana, şenke vucee q'urbanbı allya'asva ali'iyne cigaysqa hirxhıl, maa'ad Rəbbis ı'bəədat ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","İbramıka sacigeene Lutuqad çavra-vəq'əbı, çadırbı vodunbıniy. ");
INSERT INTO tkr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Sacigee aaxvasdemee, manbışiqa çavra-vəq'ə havacesın cigabı k'ıldabı ıxha, mançil-allab manbışisse sacigee aaxvas vəəxəs deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Manbışile ğayrı mane gahıl maa'ab Kana'anbıyiy Perizbıb aaxva vuxha. İbramın syuru uxhiyxhana'anbışdeyiy Lutun syuru uxhiyxhana'anbışde yı'q'nee aldapxhıniy gexha. ");
INSERT INTO tkr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","İbramee Lutuk'le eyhen: – Hasre yizdeyiy yiğne, yişin çavra-vəq'əbı uxhiyxhan ha'anbışde yı'q'nee aldatxhuniy gimexhacen, şi sa ebanbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gırgın cigabı yiğne ulene ögiyl dişeene? Qora cureepxhes. Ğu solulqa ark'ınee, zı sağılqa əlyhəəs. De'eş, ğu sağılqa ark'ınee, zı solulqa əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutee vuk'ul ooqa qav'umee, İordanne damayne mıglekın q'adaal g'acu. Mane gahıl mane cigabışis Misireene cigabışis xhinnee, bıkırda Tsoaral eyhene cigeeqamee xhyan heles eyxhenniy. Man ciga Rəbbin bağ xhinnee ıxha. Rəbbee manke Sodomıkıniy Homoraykın hı'ı deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lutee, cus İordanne damayne mıglekın q'adaal g'əyxə. Mana şargıne suralqa ayk'an. Məxüb sana-sang'uke cureebaxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","İbram Kana'an axva, Lutme mane q'adaalilyne şaharbışee axva giyğal. Sodomılqamee cun çadırbı giyxənbı. ");
INSERT INTO tkr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomee vooxhen insanar geeb yəqqı'le qığeepç'iynbı vuxha, manbışe Rəbbine ögiyl xəbna bınah haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut İbramıke curxhayle qiyğa, Rəbbee İbramık'le eyhen: – Vuk'ul ooqa qav'u, ulyorzulyne cigeençe şimalılqa, canubılqa, şargılqa, garbılqa ilekke. ");
INSERT INTO tkr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Vak'le g'ecen cigabı gırgıne gahbışis vasiy vake g'abıynbışis heles. ");
INSERT INTO tkr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Vake g'abıynbı ç'iyeylin tooz xhinnee geeb qaa'as. Savussemecad ç'iyeylin tooz qətqəs əxeene, vake g'abıynbıb qəpqəs vəəxəsınbı. ");
INSERT INTO tkr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Oza, ine cigabışee q'omançe k'anyaqqamee ı'ğı'ykre, in cigabı Zı vas hele. ");
INSERT INTO tkr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","İbramee cuna çadır alyapt'ı, Xevron eyhene şaharısqa qarayle. Mang'vee maa'ab Mamreyne mı'qəəşine k'ane çadır güvxü, Rəbbis q'urbanbı allya'an ciga alya'a. ");
INSERT INTO tkr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mane gahıl Şinarne paççahee Amrafelee, Ellasarne paççahee Aryokee, Elamne paççahee Kedorlaomeree, Goyimne paççahee Tidalee ");
INSERT INTO tkr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ine xhone paççahıka: Sodomne paççahıka Berayka, Homorayne paççahıka Birşayka, Admayne paççahıka Şinavıka, Tsevoyimne paççahıka Şemeverıka, Belayne (Tsoarne) paççahıka dəv'ə givğal haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mane xhone paççahee həşde Q'evana deryah eyhene cigee, Siddimne q'adaalil con g'oşunbı sacigeeqa sa'a. ");
INSERT INTO tkr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Manbı yits'ıq'valle (12) senna Kedorlaomerne xılek avub vuxha. Yits'ıxhebad'esde (13) sen manbı Kedorlaomerılqa g'elil qeepxha. ");
INSERT INTO tkr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Yits'ıyoq'vad'esde (14) sen Kedorlaomer cune suralyne paççahaaşika sacigee arı, Aşterot-Qarnayimee Rafabı, Hamee Zuzbı, Şave-Qiryatayimee Embı gyabaxanbı. ");
INSERT INTO tkr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Mang'vee Seirne suvabışil, El-Paranılqameen, sahrayne mıglekın Xorbıb gyabaxanbı. ");
INSERT INTO tkr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Qiyğa yı'q'əlqa sapk'ıl En-Mişpateeqa (Qadeşqa) avayk'an. Mang'vee gırgın Amalekbışin cigabı aqqaqqanbı, Xatsetson-Tamareebın Emorbı gyabaxanbı. ");
INSERT INTO tkr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sodomna paççah, Homorayna paççah, Admayna paççah, Tsevoyimna paççah, Belayna (Tsoarna) paççah Siddimne q'adaalilqa abayle. Maa'ab manbışis ");
INSERT INTO tkr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elamna paççah eyxhena Kedorlaomer, Goyimna paççah eyxhena Tidal, Şinarna paççah eyxhena Amrafel, Ellasarna paççah eyxhena Aryok qızaaxa. Yoq'uyre paççah xhong'uka maa'ab aldaaxhvan giviyğal. ");
INSERT INTO tkr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddimne q'adaalil gatranıka gyatsts'ıyn xandak'bı ıxha. Sodomne paççahıniy Homorayne paççahın eskerar heebaxamee, maqa g'a'abak'a, üç'übba avxuynbıb suvabışilqa heebaxa. ");
INSERT INTO tkr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ğameepxhaynbışe Sodomıniy Homorayn oxhanas eyxhenmeen gırgın kar, gırgıncad kar alyaat'u avayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","İbramna çocuna dix, Lutur, Sodom eyxhe. Manbışe mana, mang'uqa vodunmeen gırgın kar coka qıkkekka. ");
INSERT INTO tkr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Dəv'eençe g'attirxhınne sang'vee arı, cühüt' İbramıs gaf haa'a. İbram Emorbışde Mamreyne mı'qəəşisnee axva ıxha. Mamreyqa Eşkolıy Aner donan çocar vuxha. Manbışin gırgınbı İbramne sural vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","İbramık'le cuna xını Lut merıng'une xılyaqa arxhuva g'ayxhı. Manke mang'vee cuka cune xaa yedike vuxhayn, aldaaxhvanas xəp qav'uyn xhebıd vəşşe yits'ımolyar (318) həmbal alyarat'a. Manbışika sacigee mana Dana eyhen cigeeqamee duşmanaaşiqa qihna gexha. ");
INSERT INTO tkr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","İbramee cun həmbalar xəmde xhulenexheeyib desteeqa bit'alaa'a. Manbışe məxüd duşmanaaşikın ha'an. Üç'übba avxuynbıb Damask'ne şimalne suralyne Xovalqamee g'e'eebaşenbı. ");
INSERT INTO tkr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","İbramee manbışe alyaat'uynmeen gırgın kar, çocuna dix Lutiy mang'un kar, yadariy milletcad yı'q'əlqa sak'al ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","İbram Kedorlaomeriy mang'ukane paççahaaşile ğamxha siyk'almee, Sodomna paççah «Paççahna q'adaal» eyhene Şaveyne q'adaalil mang'une ögiylqa qığeç'u. ");
INSERT INTO tkr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Maqa sayir Salimna paççah Melki-Tsedek (qorkuvalina paççah) qarayle. Mana Allah-Ta'aalayna kaahin ıxha. Mang'vee gıneyiy çaxır adayle. ");
INSERT INTO tkr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melki-Tsedekee İbramıs xayir-düə huvu, eyhen: – Xəyiy ç'iye itxhınne Allah-Ta'aalee İbramıs xayir-düə hevlecen. ");
INSERT INTO tkr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Duşmanar yiğne xılyaqa quvuyne Allah-Ta'aalays şukur vuxhena. İbramee vucee g'ayşuyne karana, yits'ınçina sa pay Melki-Tsedekıs hoole. ");
INSERT INTO tkr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodomne paççahee İbramık'le eyhen: – Yizın insanar zas hevle, karme vas axvecen. ");
INSERT INTO tkr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","İbrameeme Sodomne paççahık'le eyhen: – Zı xəybıyiy ç'iye itxhınne Allah-Ta'aalalqa k'ın g'iysar, ");
INSERT INTO tkr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","zı vake sa k'üvəna baağe deşxheene, g'ellinçina baağe alyapt'as deş, qiyğa vasse «Zı İbram karana hı'ıva» eyhes məxhecenva. ");
INSERT INTO tkr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nukaraaşe otxhuninçile ğayrı, gırgın kar yiğın ixhecen. Zaka hapk'ıniynbışemee Aneree, Eşkolee, Mamree colqa gexhan aleet'ecen. ");
INSERT INTO tkr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Sabara gahıle İbramıs gyaguyne Rəbbee inəxdun cuvab eyhe: – Qıməyq'ən İbram. Ğu havacesda Zı vorna, Zı vas geed xədın mukaafat heles. ");
INSERT INTO tkr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","İbramee uvhuyn: – Zas, yizda Xudaavanda Rəbb, hucoone heles? Uşax zaqa deşin, yizın kar Damask şahareençene Eliezerıs axvas. ");
INSERT INTO tkr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ğu zas uşax hidevuyl-alla, ina yizda xaana insan yizda varis ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Rəbbee mang'us inəxdun alidghıniy qele: – Mana yiğna varis ixhes deş, yiğna varis vake g'adıyn uşax ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Qiyğa Rəbbee İbram g'aqa qığavhu, eyhen: – Xəybışiqa ilekke, xənebı qətqəs əxəxhee qətqe. Vake g'abına nasılıb hamanimee xəbna vuxhes. ");
INSERT INTO tkr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","İbramee Rəbbee uvhuynçilqa inyam ha'a, mançil-alla Rəbbeyir mana qorkuna insan xhinne hı'sab ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Rəbbee İbramık'le eyhen: – Vas in cigabı helesva, ğu Xaldeyaaşine Ur şahareençe qığavhuna Rəbb Zı vorna. ");
INSERT INTO tkr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","İbramee Rəbbike qidghın ha'an: – Yizda Xudaavanda Rəbb, nençene zak'le ats'axhes, in cigabı yizınbı ixhesva? ");
INSERT INTO tkr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Rəbbee mang'uk'le eyhen: – Yizdemee sa vuç'e, sa ts'e, sayib g'arg able. Adıyne gırgınçiqa xhebılle sen ixhecen. Sayib qı'nerkeyiy k'urk'uray able. ");
INSERT INTO tkr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","İbramee manbı gırgınbı gyaat'anbı. Qiyğad q'öne cigeeqa qı'ı sana sançine hiqa giyxhe. Saccu şit'yar mang'vee q'öne cigeeqa qidya'a. ");
INSERT INTO tkr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Çurunulqa qadıyn yırtıciy şit'yar İbramee g'e'eedaşenbı. ");
INSERT INTO tkr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Verığ k'yooçene gahıl İbram k'orane nik'eeqa ayk'an. Mang'ulqa sayangaba qəq'ənasda miç'axiyvalla k'yoose. ");
INSERT INTO tkr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Rəbbee İbramık'le inəxüd eyhe: – İn vak'le ats'axhe, yiğna nasıl menne ölkee dağamiyvaleeyiy nukariyvalee yoq'ud vəş senna vuxhes. ");
INSERT INTO tkr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Manbışike nukarar hav'uyne milletıke Zı hı'sab qeqqas. Mançile qiyğa yiğne nasılınbı mançe geed xətta karaka qığeepç'es. ");
INSERT INTO tkr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ğunab xıliyna ı'mı'r hav'u, q'əsvalee qik'as. ");
INSERT INTO tkr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Emorğançenbışin bınahbı inçe ğadaraa'asınbı xhinne geed qideetxhava, yiğna yoq'ub'esda nasıl inyaqa savk'alas. ");
INSERT INTO tkr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Verığ k'yooçu xəm quvxhayng'a, kuma q'ığəəna tanduriy ts'abı q'ığəəna yalav q'öna qı'iyne həyvanaaşine yı'q'neençe ılğooç'e. ");
INSERT INTO tkr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mane yiğıl Rəbbee İbramıka hav'uyne mugaavilee inəxüd eyhe: – Zı Misirne damayle xənne Fəratne damaysqameen ine milletbışin: ");
INSERT INTO tkr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Genbışin, Genizbışin, Gadmonbışin, Q'etbışin, Perizbışin, Rafabışin, Emorbışin, Kana'anbışin, Girgaşbışin, Yevusbışin cigabı yiğne nasılıs heles. ");
INSERT INTO tkr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","İbramne xhunaşşeys Sarays uşax eyxhe deşdiy. Məng'ı'qa Haacar donana Misirğançena nukarniy vor. ");
INSERT INTO tkr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saree İbramık'le eyhen: – Rəbbee zas uşax hele deşod. Yizde nukarıka g'alixhe, məng'ee zas uşax uxecen. İbramee Sarayne cuvabıl k'ırı iliyxhen. ");
INSERT INTO tkr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kana'anaaşine cigabışee yits'ılle senna avxuyle qiyğa, Saree cena nukar Haacar İbramıs xhunaşşe xhinne hiyvu. ");
INSERT INTO tkr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","İbram Haacarıka g'alirxhumee mana vuxhne eexva. Haacarık'le vuxhne yixhay ats'axhxhamee, Sarayqa ooğançe avqa ileeka giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saree İbramık'le eyhen: – İn val-alla yizde vuk'lelqa qadı. Zı nukar vasqa tyuleeqa hiyvu. Məng'ı'k'le vuxhne yixhay ats'axhxhamee, mana zaqa ooğançe avqa ileeka girğıl. Hasre Rəbbeecad hagvecen, zı vale qorkura yixhay. ");
INSERT INTO tkr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","İbramee Sarayk'le uvhuyn: – Mana yiğna nukar yeexhe, vas hucooyiy ıkkan he'e. Saree Haacar iğeeda giyğal. Nukar məng'ı'le heexvana. ");
INSERT INTO tkr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Rəbbine malaaikisqa mana qızeexana sahree, xhyan ı'lqəəne cigayne k'ane. Man xhyan ı'lqəən ciga Şurqanne yəqqı's k'ane ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malaaikee məng'ı'ke qidghın ha'an: – Sarayna nukar Haacar, nençen qarı, nyaqane əlyhəə? Haacaree eyhen: – Yizda xərna yeexhene Sarayne k'anençe heexva. ");
INSERT INTO tkr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Rəbbine malaaikee məng'ı'k'le eyhen: – Yiğne xərıng'ısqa sayk'le, məng'ee eyhen he'e. ");
INSERT INTO tkr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Rəbbinecad malaaikee meed eyhen: – Yiğna nasıl hamanimee xəp qaa'as, qəpqəs-ələpqəs vuxhes deş. ");
INSERT INTO tkr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Qiyğa Rəbbine malaaikee məng'ı'k'le sayid eyhen: – Ğu həşde vuxhne vor, vas dix ixhes. Rəbbik'le ğu ts'ıts'ı'iyn uts'ur g'ayxhiyn. Mang'un do I'smı'ı'l (Allahık'le g'ayxhiyn) gixhxhe. ");
INSERT INTO tkr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Şavussecar mana saq'vana'as əxəs deş. Mang'un xıleppı gırgıng'ul, gırgıng'unbıd mang'ul ixhes. Mana gırgıne çocaaşikar qoda ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Haacaree ceka yuşan ha'ane Rəbbis El-Roi (zı g'eecena Allah) do giyxhe. Məng'ee uvhuynniy: – Hək'erar, inyaa'ar zak'le zı G'eecena g'acuna! ");
INSERT INTO tkr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Mane xhyan ı'lqəəne cigays Beer-Laxay-Roi do mançil-alla giyxhe. Man ciga Qadeş eyheneyiy Bered eyhene cigabışde yı'q'nee vod. ");
INSERT INTO tkr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Haacaree İbramıs sa dix uxu. İbramee dixen do I'smı'ı'l gixhxhı. ");
INSERT INTO tkr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Haacaree I'smı'ı'l uxuyng'a, İbramıqa molyts'ale yixhılle (86) senniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","İbramıqa yüç'əle yüç'üd (99) sennang'a mang'us Rəbb gyagu uvhuyn: – Gırgın əxəna Allah (El-Şadday) Zı vorna. Yizde yəqqı'n hohre, məttın yik'nana ixhe. ");
INSERT INTO tkr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mugaavile Yizdeyiy yiğne yı'q'neeqa gyuvxhu, vake g'abıynbı geeb xəp qaa'as. ");
INSERT INTO tkr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","İbram aq'vahiyna ç'iyelqa gizyaraççe. Allahee mang'uk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","– Yizde suralyna mugaavile vakana haane: Ğu geedne milletbışda dek ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Zı vake geedne milletbışda dek ha'asva, g'iyniyle yiğın do İbram (xərna dek) deş, İbrıhım (xəppananbışda dek) ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yiğna nasıl geeb xəp qaa'as. Vake milletbı g'ales. Yiğne nasılee paççaharıb vuxhesınbı. ");
INSERT INTO tkr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Zı vakayiy vale qihnane yiğne nasılıka gırgıne gahbışisda mugaavile haa'a. Zı ixhes, yiğnayiy vale qihnane yiğne nasılbışda Allah. ");
INSERT INTO tkr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Vasiy vale qiyğiyne nasılbışis gırgıne gahbışis ğu alycaxvana Kana'anna ölka huvu, manbışda Allah ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Qiyğa Allahee İbrıhımık'le uvhuyn: – Yiğne suraleb, ğunay vale qiyğiyne nasılbışe mugaavilee nəxüdiy eyhe, həməxüd he'e. ");
INSERT INTO tkr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Vakayiy vale qiyğiyne nasılbışika hav'uyne mugaavileyn işaarat in vod: Gırgın adamer sunnat hav'u vuxhes. ");
INSERT INTO tkr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Sunnatın ç'ürüx g'ats'ak'vne. Sunnat Yizdeyiy vuşde mugaavileyn işaarat ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Vuşde xaa yedike ıxhanar, menne milletbışiker alişşunar adameeşina insan molyulle yiğ ıxhamee sunnat he'e. ");
INSERT INTO tkr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Yiğne xaa yedike vuxhaynbıb, menne milletbışike alivşuynbıb sunnat hidyav'u g'ılymaa'a. Sunnat vuşde tanalin Yizde gırgıne gahbışisda mugaavileyn işaarat ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Sunnat hidi'ına adameeşina insan mugaavile havaakal hav'uva, milletne yı'q'nee mexhecen. ");
INSERT INTO tkr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Allahee İbrıhımık'le meed eyhen: – Xhunaşşeyk'le Sarayva immeyhe. G'iyniyke şaqa məng'ı'n do Sarra (printsesa) ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Zı məng'ı's xayir-düə hevles: məng'ı'ker vas dix heles. Qiyğa məng'ı's sayib xayir-düə hevles: mana milletbışda yed yixhes, milletbışin paççahar məng'ı'ne nasıleençe qığeepç'es. ");
INSERT INTO tkr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","İbrıhım aq'vahiyna gizerçu, əqəna ha'u, culed-alqa uvhuyn: – Vəş sennane insanıs uşax eyxheye? Yüç'əl sennane Sarraysse uxas əxəye? ");
INSERT INTO tkr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Qiyğa İbrıhımee Allahık'le eyhen: – Hasre saccu I'smı'ı'l xheeyir Yiğne xayir-düəyka üç'ürra axhvecen! ");
INSERT INTO tkr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Allahemee uvhuyn: – Sarree, yiğne xhunaşşee vas dix uxas, doyud I'saq' (əqəna) gixhxhe. Zı mugaavile mang'ukab, mang'ule qihniyne nasılıkab gırgıne gahbışis havaacesda. ");
INSERT INTO tkr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ğu I'smı'ı'lil-alla uvhuyn Zak'le g'ayxhiyn. Mang'usub Zı xayir-düə hevles, mang'uke g'abıynbı geeb xəp qaa'as. Mang'uke yits'ıq'vəyre (12) paççah g'avaales. Zı mang'uke xədın millet ha'as. ");
INSERT INTO tkr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mugaavilemee Zı qööne sen ine gahıl Sarree vas uxasde I'saq'ıka haa'as. ");
INSERT INTO tkr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Allahee man İbrıhımık'le uvhu ooqa ts'ıts'xha. ");
INSERT INTO tkr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Manecab yiğıl İbrıhımee cune xaabın gırgın adamer: dix I'smı'ı'l, cune xaa yedike vuxhayn gırgın nukarar, menne milletbışike alivşuynbıb sacigeeqa sav'u, Allahee cuk'le uvhuyn xhinne, sunnat hav'u. ");
INSERT INTO tkr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","İbrıhım sunnat hı'iyng'a mang'uqa yüç'əle yüç'üd (99) senniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","I'smı'ı'l sunnat ha'ang'a, mang'uqa yits'ıxhebad (13) senniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","İbrıhımiy I'smı'ı'l sa yiğıl sunnat hav'u. ");
INSERT INTO tkr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Cuka sa yiğıl, cune xaabın gırgın adamer, menne milletbışike alivşuynbı, cune xaa yedike vuxhaynbı gırgınbı sunnat haa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Rəbb İbrıhımıs yiğıne pırane gahıl Mamreyne mı'qəəşine avur, çadırne ghalee gyu'uriynga gyagva. ");
INSERT INTO tkr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mang'vee vuk'ul ooqa qav'umee xhebiyre insan g'ooce. Manbı g'avcu, çadırene ghaleençe manbışde ögiylqa g'adarxhun ç'iyelqamee k'yorzul eyhen: ");
INSERT INTO tkr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","– Yizda xərna, zı ulen aqqıxhee, ulydyorzul yiğne nukarısse ılğımeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Hasre g'elybı hoğalasın xhyan allecen, yivek avub gyuv're manzil hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Şu vuşde nukarne çadırne k'anençevub ı'lğəə, zı şos sık'ınin gıney alles, oxhne yik' aqqecen. Mançile qiyğa şos vukkanxhee, hudoora. Manbışe eyhen: – Ğu eyhəxüd he'e. ");
INSERT INTO tkr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Sark'ıl mana ek'ra Sarraysqa çadıreeqa ayk'an. Məng'ı'k'le eyhen: – Həşdexhinee xhebne xənne vexhxheedın yugun urva alyaat'u xamır hı'ı, kokaybı qece. ");
INSERT INTO tkr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mana mançe çavra-vəq'əysqa g'adarxhun sa kokna q'ıka avqu mek'vung'usqa qoole. Mek'vnar giyğalna ek'da oxhanasın kar ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","İbrıhımee qoocuna q'ıka, şor, nyak manbışde ögiylqa qadı giyxhe. Manbışe man otxhanang'a, vucur cone k'ane yivek avur ulyoyzar. ");
INSERT INTO tkr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Manbışe qiyghıniyn: – Yiğna xhunaşşe Sarra nyayxha? Mang'vee eyhen: – İnyaa'ar, çadıree vor. ");
INSERT INTO tkr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Manbışde sang'vee meed eyhen: – Qööne ine gahıl zı vasqa meer ayresda. Manke yiğne xhunaşşeys Sarrays dix ixhes. Sarra mang'une yı'q'əl, çadıreeqa əkkəəne cigee ulyorzul, k'ırı iliyxhe yixha. ");
INSERT INTO tkr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","İbrıhımiy Sarra q'əsniy qeepxha. Sarrayn yadaaşik eyxhenbı ç'əveetxhaynbıniy. ");
INSERT INTO tkr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Məng'ee yik'ee əqəna hı'ı, eyhen: – Zı g'art'una, məxbına xoşbaxtıyvalla vooxheyee? Yizda xərnar q'əs qıxha. ");
INSERT INTO tkr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Rəbbee İbrıhımıke qiyghanan: – «Zı Sarra qəsra vor, zasse uşax uxas əxəye?» uvhu, nya'a məng'ee əqəna hı'ı? ");
INSERT INTO tkr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nya'a, Rəbbisse ha'as dəxən vodunne? Qööne sen ine gahıl Zı vasqa sark'ıling'a, Sarrays dix ıxha ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarree qərq'ı'niyvalin horbışika eyhen: – Zı əqəna hı'ı deşdiy. Rəbbee manke eyhen: – De'eş, ğu əqəna hı'inniy. ");
INSERT INTO tkr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mançe in adamer suğootsu Sodomusqa avayk'an. İbrıhımır ayk'anna manbı yəqqı'l haa'as. ");
INSERT INTO tkr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Rəbbee eyhen: – Ha'asın kar İbrıhımılene dyugul ha'as? ");
INSERT INTO tkr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Hək'edad, İbrıhımıke xədın, gucnan millet g'ales, mang'ulek'ena gırgıne milletbışe xayir-düə alyapt'as. ");
INSERT INTO tkr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Cule qiyğa yugun, qotkun ha'a Rəbbine yəqqı'n hophuriy dixbışis, cune xaabınbışis, xət qe'ecenva Zı mana g'əyxı'. Manke Zı Rəbbeeyid İbrıhımıs hucooyiy cuvab huvu, man ha'asın. ");
INSERT INTO tkr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Rəbbee eyhen: – Sodomulqanayiy Homorulqana şikayat geebıb. Maane insanaaşina bınah geeb yı'q'navub. ");
INSERT INTO tkr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mançil-allar giç'u avqa ilyakkasda, Zalqa hiyxharanbı hək'enbıye, dişee. ");
INSERT INTO tkr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","İnsanar sapk'ıl avayk'ananbı Sodomne suralqa. İbrıhımır axvana Rəbbine ögiyl. ");
INSERT INTO tkr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","İbrıhım Mang'usqana qıxha eyhen: – Hək'ebane, bınahnanbışika qopkuynbub havaakal haa'as? ");
INSERT INTO tkr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Eyhes, ine şaharee xhots'al (50) qorkuna insan vor. Ğu mana hək'ebab havaakal haa'asdane? Mane xhots'alyne qorkune insannemee Ğu mane şaharne bınahıle ılyheç'es dişde? ");
INSERT INTO tkr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ğu man hidya'a, qorkunayiy bınahnana sacigee gidek'a. Qorkunayiy bınahna Ğu sa hidya'a. İnimeen dyunye vuk'lek Ikkekkana, qorkura ixhes ıkkan! ");
INSERT INTO tkr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Rəbbee eyhen: – Sodomne şaharee xhots'al qorkuna insan avaykee, manbışdemee ine cigayne bıkırra bınaheençe ılyheç'esda. ");
INSERT INTO tkr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","İbrıhımee meed eyhen: – Zı Yiğnemee yı'qiy tooz xhinnen sa kar ixheeyir, zı meed yik' hı'ı Xudaavandayke qiyghanan, ");
INSERT INTO tkr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","xhots'alyna qorkuna g'ales xhoyre insan ivdekeene, mana xhoyre g'idiyxharva şahar havaakal haa'asdane? Rəbbee eyhen: – Yoq'ts'ale xhoyre (45) aveykeene, şahar havaakal haa'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","İbrıhımee meed qiyghanan: – Maa'ar yoq'ts'al aveykeene, hucoone ha'as? Rəbbee eyhen: – Yoq'ts'alyung'unemeeyir set'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","İbrıhımee eyhen: – Zı geer yuşanı'il-alla Xudaavandays qəl mooxhecen: maa'ar xhebts'al (30) aveykeene, nəxüdne ixhes? Rəbbee uvhuyn: – Maa'ar xhebts'alir aveykeene, vuççud ha'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","İbrıhımee eyhen: – Zı meed yik' hı'ı Xudaavandayke in qiyghanan: maa'ar g'ayre (20) aveykeene, hucoone ha'as? Rəbbee eyhen: – G'ang'unemeeyib havaakal haa'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","İbrıhımee eyhen: – Zı sayid eyheva Xudaavandays qəl mooxhecen, yits'iyre aveykeene, hucoone ha'as? Rəbbee eyhen: – Yits'ıng'unemeeyib havaakal haa'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Rəbbee İbrıhımıka haa'ana gaf ç'əvav'u, ayk'anna. İbrıhımır cune çadıreeqa siyk'alna. ");
INSERT INTO tkr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Exheeqana Sodomeeqa şena q'öyre malaaik arayle. Lut şaharne akkaysana gyu'ur eyxhe. Manbı g'avcu, ayk'anna manbışde ögiylqa. Qiyğar ç'iyelqamee k'yorzul ");
INSERT INTO tkr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","eyhen: – Yizın ç'ak'ınbı, qudoora, vuşde g'ulune xaa g'elybı hoğle, xəm g'eehe. Miç'eeb suğootsu gyapk'e vuşde yəqqı'lqa. Manbışe alidghıniy qelen: – De'eş, şi xəm kuçee g'aahas. ");
INSERT INTO tkr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lutee geed eyheva, malaaikar qavaylenbı mang'une xaaqa. Lutee manbışis exhalyne otxhuniyka qecuyn gıney qadayle, manbışed oyxhanan. ");
INSERT INTO tkr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Manbı g'alyapk'asse, Sodom şaharın gırgın adamer mek'vung'ule otçu q'əsıng'ulqamee savaylenbı xaane hiqiy-alla. ");
INSERT INTO tkr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","İnsanaaşe Lut qort'ul eyhen: – G'iyna xəmde vasqa abıyn insanar nyavxha? Manbı şasqa qavaale, şi manbışika g'alyapk'as. ");
INSERT INTO tkr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lut manbışisqa g'aqa qığeç'u, cuqad qihna akka qa'an. ");
INSERT INTO tkr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Mang'vee eyhen: – Çocar, qəlasın hıma'a. ");
INSERT INTO tkr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Zaqa q'öyre adamiys hidyark'ınna yiş vor. Qavaales şosqa hucooyiy ıkkan he'e. Saccu ine insanaaşik sumoot'a, manbı yizde xaabın mihmanar vob. ");
INSERT INTO tkr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Adameeşe eyhen: – Yı'q'əlqa ts'ıts'xhe! İne insanee menne cigeençe qarı şas yuguniy pisın xət qa'a. Vak manbışiled yı'q'ı'n ha'as. Manbı Lutulqa hoohar, akka haq'var ha'as ıkkiykan. ");
INSERT INTO tkr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Manke xaane malaaikaaşe xıl hotku Lut aqa cosqa ts'ıts'ı, akka it'uma'an. ");
INSERT INTO tkr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Akkayne şene sural ulyobzurne insanaaşina k'ınnar, xərnar manbışe bı'rq' qaa'a. Mançil-alla insanaaşik'le akka iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Malaaikaaşe Lutuk'le eyhen: – Vaqa inya'ar merna vuşune vor? Dixbı, yişbı, yeznebı yiğne xizanın gırgınbı ine şahareençe qığee'e. ");
INSERT INTO tkr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Şi in ciga hakkal ha'asın. İne milletıle geed şikayatbı Rəbbik'le g'ayxhı. Mançil-alla Rəbbee şi g'axuvuynbı ina şahar havaakal haa'as. ");
INSERT INTO tkr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lutee hark'ın yişbı haa'asde adameeşik'le eyhen: – Zaraba hudoora ine cigeençe, Rəbbee ina şahar havaakal haa'as. Yişbı haa'asde adameeşine fıkreeqa, Lutee coka dem haa'a vuxhesva qayle. ");
INSERT INTO tkr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Miç'eed qexheng'a, malaaikaaşe Lutuk'le eyhen: – Ek'ra ixhe! Xhunaşşeyiy yişbı alyapt'ı ine cigeençe hoora. Deşxhee, şahar alytivk'al haa'amee şunab hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lut yı'q'ra ı'ğı'ykır. Rəbbina mang'ulqa rəhı'm qabıva, malaaikaaşe Lutur, cuna xhunaşşer, yişbıb xıleke avqu şahareençe qığaa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Manbı qığaa'ane gahıl malaaikaaşine sang'vee eyhen: – Yı'q'əlqa ilydyakkı hivxe. İne Q'adaalil ulymoyzar, axtıne cigabışeeqa hivxe. Deşxhee, qik'u əəsda. ");
INSERT INTO tkr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lutee manbışik'le eyhen: – Yizın ç'ak'ınbı! Vuşde ulen ina nukar aqqı, şu mana g'attixhanı'iyka, zas haa'ana yugvalla geeb qav'u. ");
INSERT INTO tkr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","20","Saccu hasre zı mane k'anene k'ınne şahareeqa hixu g'attixhanas. Man şu eyhen axtın cigabı geed əq'əna vod. Zı maqa hixharasse, balyaa zalqa hipxhır, zı gik'asda. ");
INSERT INTO tkr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malaaikaaşine sang'vee Lutuk'le eyhen: – Yiğnimee manıd ha'a, ğu eyhena şahar alytivk'al hidyaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ek'ra ixhe, maqa hixve! Ğu maqa hidirxhıl, zı sa kar ha'as deş. Lutee mana şahar k'ınnava uvhiyl-alla, mançin do Tsoar (k'ınin) axva. ");
INSERT INTO tkr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lut Tsoarqa hirxhıliyng'a, verığ ılqevç'u vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Rəbbee Sodomılqayiy Homoralqa ts'ayıkan xəənçe kukurt gyoğa'a. ");
INSERT INTO tkr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","İne Q'adaalilin şaharbı, ç'iyel ələən gırgın kar, maa vooxhen gırgın insanar deşaa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lutuna xhunaşşe yı'q'əlqa sark'ıl ileekımee, q'evane g'ayelqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Qinne yiğıl miç'eer İbrıhım oza qıxha Rəbbine ögiyl ulyorzulyne cigeeqa hayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Mana mançe Sodomıqa, Homorıqa mançine hiqiy-allane Q'adaaliqa ilyakka. Mang'uk'le mane cigeençe xənne ts'ayıke ı'lqən xhinnen sa kuma g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","İne Q'adaalilin şaharbı hakkal ha'ang'a, Allahıs İbrıhım yik'el qarı, dişe Lut mançe hixu'u g'attixhana'a. ");
INSERT INTO tkr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lut q'öne yişşeka Tsoareençe qığeç'u, suvabışee aaxva. Mana Tsoar axvas qəyq'ən ıxha. Mana q'öne yişşeka sa mağaree axva. ");
INSERT INTO tkr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mang'une xərne yişşee k'ıning'ı'k'le eyhen: – Yişda dek q'əs qıxha, gırgıng'uka xhinne, şaka g'alixhasda sa adamiy deşda. ");
INSERT INTO tkr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Qeera, dekkıs çaxır ulyoğu'ı, mang'uka g'alyapk'as, yişde dekkıke g'abına şaqab nasıl vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Manbışe mane xəmde dekkıs çaxır ulyoğa'a. Xərna yiş dekkısqa iyç'u, mang'uka g'ıleexha. Dekkık'le mana mısa cusqa k'iyç'u, qığeyç'uycar ats'a eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Qinne yiğıl xərne yişşee k'ıning'ı'k'le eyhen: – Zı sanıxha dekkıka g'alirxhu. Qeera, g'iynad mang'us çaxır ulyoğa'as, ğunar mang'usqa k'iyç'e, yişde dekkıke g'abına şaqab nasıl vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Manbışe mane xəmded dekkısqa çaxır ulyoğa'a. K'ınna yişşir k'iyç'u, mang'uka g'ıleexha. Dekkık'le mana mısa cusqa k'iyç'u, qığeyç'uycar ats'a eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Məxür Lutuna q'öyursana yiş dekkıke vuxhne aaxva. ");
INSERT INTO tkr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Xərne yişşee sa dix uxu, cun doyud Moav (dekkıke) giyxhe. Mana həşde Moavbışda dek eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","K'ınne yişşeyir sa dix uxu mang'un do Ben-Ammi (yizde ebang'una dix) giyxhe. Mana həşde Ammonbışda dek eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","İbrıhım mançe Negevne cigabışeeqa ayk'an. Mana Qadeşneyiy Şurune yı'q'nee axva. Qiyğa mana sabara gahna Gerar eyhene şaharee axva. ");
INSERT INTO tkr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","İbrıhımee maa'ad cune xhunaşşeyne Sarrayne hək'ee «İna yizda yiçu vorva» uvhu. Gerarne paççahee, Avimelekee, insan g'axuvu, Sarra qiykekkana. ");
INSERT INTO tkr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Xəmde Allah Avimelekıs gyagu, uvhuyn: – Qiykiyne xhunaşşeyl-alla ğu qik'asda, mana merıng'una xhunaşşe yixhal-alla. ");
INSERT INTO tkr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Avimelek məng'ı'k qet'u ıxha deş. Mang'vee eyhen: – Xudaavanda, nya'a Vasse bınah deşin millet gik'as əxəyee? ");
INSERT INTO tkr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Mane insanee «İna yizda yiçu vorva» dişde uvhu? Zəiyfee yiceeyid «Mana yizda çoc vorva» uvhu. Zı man kar yik'eene qəlıke deş hı'ı, yizde xıleppışilib bınah deşda. ");
INSERT INTO tkr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Allahee mang'uk'le nik'ek eyhen: – Zak'le ats'an, ğu man yik'eene qəlıke deş hı'ı. Mançil-allar Zı vas məng'ı'k xıl set'as hassır deş, Zı ğu bınahıke aqqı. ");
INSERT INTO tkr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Həşdeme, zəiyfa adamiysqa sayk'al hee'e, mana peyğambar vorna. Mang'vee yiğnemee düə haa'as, ğunar üç'ürra axvas. Ğu mana zəiyfa sayk'al hidey'eene, ğunar, yiğın milletıd aaxvas deş, hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Avimelek miç'eer çakra oza qıxha, cun gırgın insanar sav'u, man gırgın manbışis yuşan ha'a. İnsanar mançile geeb qəvəyq'ənanbı. ");
INSERT INTO tkr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Avimelekee İbrıhım qort'ul, eyhen: – Ğu şak hı'iyn hucoona? Zı yiğne ögiyl nena bınahne hav'u, ğu zalqayiy yizde paççahiyvalilqa ina xəbna bınah qav'u? Ğu zak hidya'asın kar hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Avimelekee meed İbrıhımık'le eyhen: – Ğu man kar ha'amee, hucooniy yiğne fıkreençe ı'lğəə? ");
INSERT INTO tkr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","İbrıhımee eyhen: – Yizde ək'leençe «İnyaa'ab Allahıle qəpq'ı'niy deşud, xhunaşşel-alla manbışe zı gik'asdava» ılğeç'u. ");
INSERT INTO tkr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mana hək'erar yizda yiçu vor: yişda dek sa vorna, yedyarme curaynbı. Zı mana hey'ı. ");
INSERT INTO tkr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Allahee zı dekkıne xaançe menne cigabışeeqa g'ıxelemee, zı məng'ı'k'le uvhuyn: «Zas inəxübna yugvalla hee'e: şi vüqqəsde cigabışee yizde hək'ee, „İna yizda çocva“ eyhe». ");
INSERT INTO tkr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Avimelekee İbrıhımıs çavra-vəq'ə, həmbal adameriy həmbal yadar huvu. Xhunaşşer Sarrar yı'q'əlqa seek'al hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Avimelekee eyhen: – Yizda ölka yiğne ulene ögiyl vob, vas nyaqayiy ıkkan maayir vasse axvas əxə. ");
INSERT INTO tkr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Qiyğa Sarrayk'le eyhen: – İleeke zı yiğne çocus aazır (1000) nuk'rayn şekel hele. Hasre mane nuk'rayn gırgınbışik'le val bınah devxhay hagvecen. ");
INSERT INTO tkr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","İbrıhımee Allahıs düə haa'a, Allaheeyib Avimelekır, mang'una xhunaşşer, mang'un həmbal zəiyfabıb yug qaa'anbı: manbışisse meeb vuxhne aaxvas vəəxənbı. ");
INSERT INTO tkr_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Rəbbee, İbrıhımne xhunaşşel, Sarral-allaniy, Avimelekne xaan gırgın zəiyfabı vuxhne aaxvas dəəxəsınbı xhinnee qav'u. ");
INSERT INTO tkr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Rəbbee ögiyl uvhuyn xhinne, Sarrays yugvalla haa'ana. Mang'vee huvuyn cuvab aqqaqqan. ");
INSERT INTO tkr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Allahee uvhuyne gahıl, Sarra vuxhne ayxu, q'əsde İbrıhımıs dix uxu. ");
INSERT INTO tkr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","İbrıhımee Sarrayke ıxhayne dixes I'saq' (əqəna) do giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Allahee İbrıhımık'le cune əmree uvhuyn xhinne, mang'vee dix, I'saq' ıxhayne molyne yiğıle sunnat ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","I'saq' yedike ıxhayng'a, İbrıhımıqa vəş senniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarree uvhuyn: – Allahee yizde aq'veeqa əqəna qali'ı! Man g'ayxhıyne gırgıng've zaka sacigee əqəna ha'as! ");
INSERT INTO tkr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sarreecad meed eyhen: – Şavaa İbrıhımık'le eyheyiy, ine q'əsvalee zı uşax uxu yic gyoqa'as? Haane, yicıd uxuyn! ");
INSERT INTO tkr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Uşax xət qıxha, nikneke gyarğılyna. I'saq' nikneke gyarğılyne yiğıl, İbrıhımee xədın otxhun-ulyodğuy hele. ");
INSERT INTO tkr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sarrayk'le g'ecen, Misirğançene Haacaree İbrıhımıke uxuyne dixee I'saq'ıle əqənavud ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sarree İbrıhımık'le eyhen: – İna həmbal zəiyfayiy cena dix g'e'eepşe. Mane həmbal zəiyfayne dixes yizde dixes I'saq'ıs xhinne yiğın kar axvas deş. ");
INSERT INTO tkr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Mançike İbrıhımee it'umda aq'va givaxana'a, nya'as uvhee, I'smı'ı'lir mang'una dixniy vor. ");
INSERT INTO tkr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Allahee İbrıhımık'le eyhen: – Gadeyliy həmbal zəiyfayl-alla ğu aq'va givaxan hımaa'a. Sarree vak'le eyhene gırgınçil k'ırı alixhxhe. I'smı'ı'like g'abıynbı deş, I'saq'ıke g'abıynbı yiğna nasıl vuxhes. ");
INSERT INTO tkr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mane həmbal zəiyfayne dixeked millet g'alya'as, manar yiğna dixnançe. ");
INSERT INTO tkr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","İbrıhım miç'eer çakra suğotsu, gıneyiy sa tuluğ xhinen alyaat'u, Haacarne mıgalqa hele. Qiyğa manayiy uşax mang'vee yəqqı'l aa'a. Haacar əlyhəəme, Beer-Şevayne sahree ileekkana. ");
INSERT INTO tkr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tuluğeedın xhyan g'att'umee, məng'ee dix ğı'ç'iyk avur gya'a. ");
INSERT INTO tkr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Qiyğar sa avhuyn vuk hixharasdemeena yəq apk'ın, «Dix nəxüriy qek'ava g'ımececenva» uvhu, geeşe giy'ar. ");
INSERT INTO tkr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Allahık'le gade geşşe g'iyxhen. Allahne malaaikın xəənçe Haacarılqa onu'u, eyhen: – Haacar vak hucoona ıxha? Qı'meeq'ən, gade gyu'urne cigeençe Allahık'le mana geşşe g'ayxhiyn. ");
INSERT INTO tkr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Oza qiyxhe, yeera gade xılyaqa alert'e. Zı mang'uke xədın millet g'alya'as. ");
INSERT INTO tkr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Allahee Haacarın uleppı aaqa, məng'ı'k'le xhinekana kahrız g'ooce. Ark'ın, tuluğ xhinen gyatsts'ı'ı, gadeys ulyoğa'a. ");
INSERT INTO tkr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah mane gadeyka ıxha. Mana xər qıxha, sahree axva, mang'uke yugda vuk ayhena eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mana Paranne sahree axva. Yedee mang'us Misirğançe xhunaşşe hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mane gahıl Avimelekeeyiy mang'une g'oşunne vuk'lel ulyorzulyne Pikolee, İbrıhımık'le eyhen: – Ğu hucooyid he'ee, Allah vaka vor. ");
INSERT INTO tkr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Həşde inyaa'ad Allahne ögiyl ğu zas k'ın g'aysre, zasıy zake g'abıynbışis ğu qəlasın ha'as deş. Cuvab hele, zı vaka eyxhena xhinne, ğunar zakayiy ğu axvane cigabışde insanaaşika yugra ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","İbrıhımee «Zı k'ın g'iysaranva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Avimelekne nukaraaşe avquyne kahrızıl-alla, İbrıhımee Avimelekıs güx haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Avimelekee eyhen: – Man şava hı'ı ıxhay zak'le ats'a deş. Ğunad zak'le ats'axhxhı'ı deş, man zak'le həşde g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","İbrıhımee çavra-vəq'ə g'əyxı', Avimelekıs hele. Məxüd manbışe cuvab g'ats'ayk'van. ");
INSERT INTO tkr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","İbrıhımee cune vəq'əbışike yighıble vəq'ə curaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Avimelekee İbrıhımık'le eyhen: – İna ğu curav'una yighıble vəq'ə nəxbınane? ");
INSERT INTO tkr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Mang'vee eyhen: – İna yighıble vəq'ə alept'e, mana kahrız zı alipk'ırva, mana yizda vobva, işaarat ixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mançil-allad mang'vee mane cigayn do Beer-Şeva (k'ınena kahrız) giyxhe, manbışde q'öng'eesana maa'ad k'ın g'aysır. ");
INSERT INTO tkr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Məxüd Beer-Şevee cuvab g'ats'ayk'van. Mançile qiyğa Avimelekır, mang'une g'oşunne vuk'lel ulyorzulyna Pikolur mançe Filiştinbışde cigabışeeqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","İbrıhımee Beer-Şevee tamariskna yiv oozu, maa'ad Rəbbis, gırgıne gahbışil vorne Allahıs ı'bəədat ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","İbrıhım Filiştinbışde cigabışee menne cigabışeençe qarına xhinne geer axva. ");
INSERT INTO tkr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sabara gahıle Allahee İbrıhım siliys ı'xı'yxə. Mang'vee «İbrıhımva!» ona'an. İbrıhımee «Hooyva!» eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Allahee mang'uk'le eyhen: – Vas ıkkanna, vorna-deşda yiğna dix I'saq'ır alyart'u Moriya eyhene cigeeqa hoora. Zı vak'le haagvasde suval, dix gyoxhxhane'e, q'urbanna alle'e. ");
INSERT INTO tkr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","İbrıhımee çakra miç'eeqana suğotsu cune əməleys palanbı ı'xı'yxə. Mang'vee cukasana q'öyre mek'vna, sayir dix I'saq' ıkkekka. Mang'vee q'urban gyooxhan ha'asın osbıd qaxı, yəq avqaaqana Allahee uvhuyne cigeeqa. ");
INSERT INTO tkr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Man ciga İbrıhımık'le xhebıd'esde yiğıl, vuk'ul ooqa qav'uyng'a, əq'ənançe g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Mang'vee mek'vunbışik'le eyhen: – Şu əməleyka inyaa aaxve, zı dixeka şaqa ı'qqəs. I'bəədat ha'u, şosqa savk'alas. ");
INSERT INTO tkr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Q'urban gyooxhan ha'as qaxıyn osbı İbrıhımee cune dixene I'saq'ne mıgalqa hele. Ts'ayiy ç'ikad vucee alyaat'a. Cona q'öyre maqa əlyhəəng'ə, ");
INSERT INTO tkr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","I'saq'ee dekkık'le İbrıhımık'le eyhen: – Dek! Mang'vee alidghıniy qelen: – Dix, yizın k'ırı val vod. I'saq'ee qiyghanan: – Ts'ayiy osbı vodunbı, saccu q'urbanna beder nençene vuxhes? ");
INSERT INTO tkr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","İbrıhımee eyhen: – Dix, q'urbanna beder Allahee Vucee haagvasda. İnbı sacigee avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Manbı qavaylenbı Allahee mang'uk'le uvhuyne cigeeqa. İbrıhımee maa'ad q'urbanbı allya'an ciga ali'ı, çilqad osbı giyk'an. Qiyğar I'saq' ayt'ıl mane q'urbanbı allya'ane cigalyne osbışilqa g'alya'a. ");
INSERT INTO tkr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","İbrıhımee dix gik'asva xıl hotku ç'ika alyaat'a. ");
INSERT INTO tkr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mane gahıl Rəbbine malaaikee xəybışeençe mang'ulqa ona'an: – İbrıhım, İbrıhım! Mang'vee eyhen: – Zı inyaa vor! ");
INSERT INTO tkr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaaikee eyhen: – Gadeyk simet'a! Mang'uk vuççud hıma'a! Həşde zak'le ats'axhxhayn, ğu Allahıle qəyq'ən vor, vaqa vornacar hamana sa dix, vucur ğu Cule qiykkın deş. ");
INSERT INTO tkr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","İbrıhımee vuk'ul ooqa qav'umee, ğı'ç'ee gaçbı açatxırna sa g'arg g'ooce. İbrıhımee hark'ın mana g'arg qabı, dixene cigee q'urbanna ablyaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","İbrıhımee mane cigayn do Yahve-İre (Rəbbee hagvasın) giyxhe. Mançil-allad həşdilqamee insanaaşe məxüd eyhe: «Vucee Rəbbee suval hagvasın». ");
INSERT INTO tkr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Rəbbine malaaikee xəybışeençe İbrıhımılqa onu'u meed eyhen: ");
INSERT INTO tkr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","– Rəbbee inəxüdud eyhe: «Ğu ina iş hav'uva, vornacar sa dix qidiykınva, Zı Yizde doyulen k'ın g'iysar: ");
INSERT INTO tkr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Zı vas hək'ebab xayir-düə hevles, yiğna nasıl xəədın xənebımee, deryahne hiqiy-allana g'um xhinne hexxaa'asda. Duşmanaaşin şaharbıd yiğne nasılınbı ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ğu Yizde cuvabıl k'ırı alixhxhiyl-alla, dyunyeyne gırgıne milletbışe yiğne nasılıke xayir-düə alyapt'as». ");
INSERT INTO tkr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","İbrıhım siyk'alna cuka abıyne mek'vunbışisqa. Mançe manbı sacigee siviyk'alanbı Beer-Şeveeqa. İbrıhım Beer-Şevee axva. ");
INSERT INTO tkr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sabara gah ılğevç'uyle qiyğa, İbrıhımık'le eyhen: – Milkayke yed yixha, məng'ee yiğne çocus Naxorus dixbı vuxu: ");
INSERT INTO tkr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ts'erriyna dix Uts, mang'una çoc Buz, Qemuel (Qemuel Aramna dek eyxhe), ");
INSERT INTO tkr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Xazo, Pildaş, İdlaf, Betuel. ");
INSERT INTO tkr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Betuelike yiş Rivq'a yeexhe.) Man molyulle uşax Milkee İbrıhımne çocus Naxorus uxooxa. ");
INSERT INTO tkr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reuma donane mang'une həmbal zəiyfeeyib mang'us Tebax, Gaxam, Taxaş, Maaka donan dixbı uxooxa. ");
INSERT INTO tkr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarree vəşşe g'aye yighılle (127) sen ha'a. Məng'ee manimeena ı'mı'r hav'u. ");
INSERT INTO tkr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarra Kana'anne cigabışeene Qiryat-Arbee (həşde mançin do Xevron vod) qeek'a. İbrıhımee Sarrays yas avqu, geşşena. ");
INSERT INTO tkr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","İbrıhım qiyk'uyne xhunaşşeysse Q'etbışisqa ark'ın, eyhen: ");
INSERT INTO tkr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","– Zı vuşde yı'q'nee menne cigeençe sık'ınne gahısva qarına vorna. Zas xhunaşşe k'eyxhasın ciga massa hele, zı mana k'eyxhes. ");
INSERT INTO tkr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Q'etbışe İbrıhımıs alidghıniy qele: ");
INSERT INTO tkr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","– Yişda xərna, şal k'ırı alixhxhe: ğu yişde yı'q'nee Allahee gixhxhına xərna vor, yiğna xhunaşşer yişde nyaq'vbışde inekke yugunçee k'eyxhe. Yişde neng'uscad ğu xhunaşşe k'eyxhasın ciga qiykkanas deş. ");
INSERT INTO tkr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","İbrıhım oza qıxha, mane cigayne milletne, Q'etbışde ögiyl, k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Qiyğa manbışik'le eyhen: – Şu, zı yizda xhunaşşe k'eyxhes hiyesarxhee, zal k'ırı alixhxhe: yizdemee Tsoxarne dixes Efronus miz k'ee'e. ");
INSERT INTO tkr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Mang'vee cun ciga ç'əvexhene cigeena Maxpelayna mağara zas massa hevlecen. Hasre mang'vee vuşde ulene ögiyl man ciga zı nyaq'v haa'asva bıkırne hək'is zas massa helecen. ");
INSERT INTO tkr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron Q'etbışde yı'q'nee gyu'ur eyxhe. Q'etğançene Efronee şaharne akkabışisqa sabıyne gırgıne Q'etbışde ögiyl İbrıhımıs inəxdın alidghıniy qele: ");
INSERT INTO tkr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","– De'eş, yizda xərna, zal k'ırı alixhxhe: zı man cigayiy maana mağara vas hoole. Yizde milletne insanaaşine ögiyl zı hele. Hoora, yiğna xhunaşşe k'eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","İbrıhım mane cigabışde milletıs meer k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Qiyğa mang'vee, mane cigayne milletne ögiyl Efronuk'le inəxüd eyhe: – Hucoona ixhes, zal k'ırı alixhxhe: mane cigayna hək' zake alept'e, xhunaşşe maqa k'eyxhas. ");
INSERT INTO tkr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efronee İbrıhımıs alidghıniy qele: ");
INSERT INTO tkr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","– Yizda xərna, zal k'ırı alixhxhe: mane cigayna q'iymat yoq'ud vəş (400) nuk'rayn şekel vobna. Man yizdeyiy yiğne yı'q'nee hucoo eyxhen karne? Qiyeele, xhunaşşe k'eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","İbrıhımee Efronne cuvabıl k'ırı alixhxhı, Q'etbışde ögiyl Efronee uvhuyn xhinnee kar alişşu massa helenbışde g'apanıl yoq'ud vəş nuk'rayn şekel gyoodakke. ");
INSERT INTO tkr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Məxüd Mamreyne k'anedın Efronun Maxpeleedın ciga, maana mağara, maadın gırgın yivar ");
INSERT INTO tkr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","şaharne akkabışisqa sabıyne Q'etbışde ögiyl İbrıhımınbı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mançile qiyğa İbrıhımee cuna xhunaşşe Sarra Maxpela eyhene cigeene mağaree k'eyxha. Mana mağara Kana'anne cigabışeene Mamree vob. Həşde mançin do Xevron vod. ");
INSERT INTO tkr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Məxüd Q'etbışe man cigayiy maana mağara İbrıhımıs nyaq'v ha'asın ciga xhinnee massa hele. ");
INSERT INTO tkr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","İbrıhım q'əs qexhe. Rəbbee mang'vee ha'ane gırgıne karas xayir-düə huvu vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","İbrıhımee cune xaadın işbı ha'ane xərne həmbalık'le eyhen: – Xıl yizde umayk avqa gixhxhı, ");
INSERT INTO tkr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Rəbbis, xəəneyiy ç'iyeyne Allahıs, k'ın g'aysre, zı axvane cigabışeençe Kana'anne içeeşike yizde dixes xhunaşşe hee'es deşva. ");
INSERT INTO tkr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Saccu yizde ölkeençe yizde xınıbışisqa hapk'ın, mançe yizde dixes I'saq'ıs xhunaşşe hee'es. ");
INSERT INTO tkr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Həmbalee mang'uk'le eyhen: – İçiys zakasana ine cigabışeeqa qiyeeles diykkınee, hucoone ha'as? Eyxheyeene, yiğna dix ğu qarıyne cigabışeeqa qıkkees? ");
INSERT INTO tkr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","İbrıhımee mang'uk'le eyhen: – Nyaggah yizda dix maqa qıkmekka. ");
INSERT INTO tkr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Rəbbee, xəybışde Allahee, zı dekkıne xaançeyiy yedike ıxhayne cigabışeençe qığavhu. Mana zaka yuşan hı'ı, Mang'vee zas k'ın g'aysır in cigabı yizde nasıles helesva. Mang'vee Cun malaaik g'axıles, ğunar mançe yizde dixes xhunaşşe hey'ı qiyeeles. ");
INSERT INTO tkr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mane içiys vaka qiyeeles diykkıneene, ğu mankecar mane k'ınike g'attixhanasda. Saccu yizda dix maqa qıkmekka. ");
INSERT INTO tkr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Həmbalee mane işil-alla xıl cune xərıng'une İbrıhımne umayk avqa gixhxhı, k'ın g'iysar. ");
INSERT INTO tkr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Həmbalee cune xərıng'uke İbrıhımıke yits'ıble devayiy inekke yugun paybı alyaat'u, Aram-Naharayimeeqa (Mesopotamiyelqa), İbrıhımna çoc Naxor axvane şahareeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Exhal yadar xhyan gyatsts'esva qığeepç'ımee, mang'vee cun devabı şaharne mıglekne xhyan ı'lqəəne cigaysne ulyoyzar ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Qiyğa mang'vee düə haa'a: – Rəbb, yizde xərıng'una İbrıhımna Allah, hucoona ixhes, g'iyna yizda iş sibık qee'e. Yizde xərıng'us İbrıhımıs Yiğna badal dyooxhena yugvalla haagve. ");
INSERT INTO tkr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Zı həşde xhyan ı'lqəəne cigaysnee ulyoyzar, ine şaharın içer inyaqa xhyan gyatsts'es vüqqə. ");
INSERT INTO tkr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Hasre məxüd ixhecen, zı içeeşine sang'ı'k'le eyhesın «Hucoona ixhes parç mıgayle gyaqqe, zı xhyan ulyoğas». Məng'eeyid alidghıniy quveene: «Ğunad ulyoğe, yiğne devabışisıd heles», manar Ğu yiğne g'ulunemee I'saq'nemee g'əyxı'na yixhecen. Məxüd zak'led Ğu yizde xərıng'unemee badal dyooxhena yugvalla hav'uva ats'axhxhes. ");
INSERT INTO tkr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mang'vee düə hav'u ç'əvxha deşdiy, sayır Betuelyna yiş Rivq'a mıgal parçıka maqa ayreele. Betuel Milkayee uxuna Naxorna dix ıxha. Naxorur İbrıhımna çoc ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","İçiy yixhes geer micagna, adamiys hidyark'ınna içiy yixha. Mana xhyan ı'lqəəne cigaysqa giyç'u, parç xhinen gyatsts'ı'ı, ooqa ılqeeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Həmbal məng'ı'ne ögiylqa g'adarxhun, eyhen: – Hucoona ixhes, yiğne parçeençe zas sık'ınin xhyan hele ulyoğas. ");
INSERT INTO tkr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","İçee eyhen: – Xərna, ulyoğe. İçee zarada parç mıgayle gyaqqı, mang'us xhyan hele. ");
INSERT INTO tkr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mang'us xhyan huvuyle qiyğa eyhen: – Yiğne devabışisıd xhyan gyatsts'es mançinıd atsts'esınmeen ulyoğecen. ");
INSERT INTO tkr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","İçee zarada parç axureeqa haç'ı'ı, xhyan gyatsts'esva meer avqa g'adeexhvan. Məng'ee həmbalne gırgıne devabışisın xhyan gyayts'e. ");
INSERT INTO tkr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","İbrıhımna həmbal nıq' dena məng'ı'ka ilyakka ıxha, Rəbbee cune arıys xayir-düə huvuyeeva ats'axhxhes. ");
INSERT INTO tkr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Devabışe xhyan ulyodğu ç'əveetxhamee, mane insanee yı'q'valla sa beqanan quşelqa qaa'ana k'ınəəğəykena ı'm, içiyne guçaaşilqan yı'q'valla yits'ılle şekelynan ı'mər məng'ı's hele. ");
INSERT INTO tkr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Qiyğa eyhen: – Zak'le eyhelan ğu şavna yişne? Yiğne dekkıne xaa şi xəm g'aahasda ciga vobnane? ");
INSERT INTO tkr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","İçee mang'uk'le eyhen: – Zı Betuelyna yiş vorna. Mana Milkayee Naxorus uxuna dix vor. ");
INSERT INTO tkr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Məng'ee meed eyhen: – Şaqa ok'ub, yemıd geed vod, xəm g'aahasın cigad vodun. ");
INSERT INTO tkr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Manke mana insan q'aratsabışil gyu'ur, Rəbbis şukur hav'u, ");
INSERT INTO tkr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","eyhen: – Rəbbis, yizde xərıng'une İbrıhımne Allahıs, şukur vuxhena! Mang'vee badal dyooxhena yugvallayiy qopkuvalla cuke qiviykkın deş. Rəbbee zı q'omançecar yizde xərıng'une çocune xaaqa qarı. ");
INSERT INTO tkr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","İçiy yedine xaaqa g'adarxhun, man ıxhaynbı yedis yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rivq'ayqa Lavan donana sa çoc ıxha. Lavan zaara g'aqa qığeç'u, mane xhyan ı'lqəəne cigaysneene İbrıhımne həmbalısqa g'adayxhvan. ");
INSERT INTO tkr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mang'uk'le yuçeyne q'uşelyna ı'miy guçaaşilin ı'mər g'ece. Sayid yuçee Rivq'ee «Mana insan zaka məxür yuşan hı'ıva» uvhumee, mana g'adarxhun mane insanısqa qarayle. Mana xhyan ı'lqəəne cigee devabışde k'ane ulyorzul ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lavanee eyhen: – Rəbbee xayir-düə huvuna insan, aqa ikkeç'e. Nya'a g'ar ulyorzul? Zı vasda goziy devabışda ciga qav'u vob. ");
INSERT INTO tkr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mana insan xaaqa ikkeç'e. Lavanee devabışil alixhxhıyn gırgın kar q'əra qa'a, mançis ok'ıy yem hele. Mane insanısıd, mang'ukanbışisıd Lavanee g'elybı hoğalasın xhyan adayle. ");
INSERT INTO tkr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Manbışde ögiylqa otxhuniy qadayle, mane insaneeme eyhen: – Zı nişisiy arıva ittevhu zı otxhuniy oxhanas deş. Lavanee eyhen: – Eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Mang'vee eyhen: – Zı İbrıhımna həmbal vorna. ");
INSERT INTO tkr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Rəbbee yizde xərıng'us geeb xayir-düə huvu: mana karana hı'ı, mang'us çavra-vəq'ə, k'ınəəğəyiy nuk'ra, həmbalar, həmbal zəiyfabı, devabı, əməler huvu. ");
INSERT INTO tkr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Yizde xərıng'una xhunaşşe Sarra, q'əsqiyxhayne gahıl, məng'ee xərıng'us sa dix uxu. Yizde xərıng'veeyid cuqa vodun gırgın mang'us huvu. ");
INSERT INTO tkr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Qiyğad zasqa k'ın g'aysara'as alikkı, uvhuyn: «Zı axvane cigabışeençe Kana'anne içeeşike yizde dixes xhunaşşe himee'e. ");
INSERT INTO tkr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ğu yizde dekkıne xaaqa, yizde ebanbışisqa hark'ın, mançe yizde dixes xhunaşşe hee'e». ");
INSERT INTO tkr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Zı xərıng'uk'le uvhuyn: «İçiy zakasana qidyareene, hucoone ha'as?» ");
INSERT INTO tkr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mang'vee zas alidghıniy quvu: «Zı Rəbbine yəqqı'n əlyhəəva, Mang'vee vaka Cun malaaik g'axıles, gırgın yəqqə yugda ixhes, yizda ebana, yizde dekkıne xaançena, ğu yizde dixes xhunaşşe hee'es. ");
INSERT INTO tkr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ğu yizde dekkıne xaaqa arımee, manbışe yizde dixes içiy hideyvee, manke ğu mane k'ınike g'attixhanasda». ");
INSERT INTO tkr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Zınar g'iyna xhyan ı'lqəəne cigaysqa qarı, düə hav'u: «Rəbb, yizde xərıng'una İbrıhımna Allah, hucoona ixhes, yizda yəq eeqe. ");
INSERT INTO tkr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Zı həşde xhyan ı'lqəəne cigaysne ulyorzul vor, içer inyaqa xhyan gyatsts'esıb vüqqə. Hasre məxüd ixhecen, zı içeeşine sang'ı'k'le eyhesın: „Hucoona ixhes, zas yiğne parçeençe ulyoğasın xhyan hele“. ");
INSERT INTO tkr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Məng'eeyid zak'le „Ğunad ulyoğe, yiğne devabışisıd hark'ın, gyatsts'esva“ uvheene, mana içiy yizde xərıng'une dixes Rəbbee g'əyxı'na xhunaşşe yixhecen». ");
INSERT INTO tkr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Zı yik'ee düə hav'u ç'əvxha deşdiy, sayır Rivq'a mıgal parç ana qarı, xhyan gyatsts'es giyç'u. Zı məng'ı'k'le uvhuyn: «Hucoona ixhes, zas xhyan hele». ");
INSERT INTO tkr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Məng'ee zarada mıgayle parç gyaqqı, uvhuyn: «Ğu ulyoğe, zı hark'ın, yiğne devabışisıd xhyan heles». Zınad ulyodğuyn, məng'eeyid yizde devabışis huvu. ");
INSERT INTO tkr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Zı məng'ı'ke qiyghıniyn: «Ğu şavna yişne vor?» Məng'ee zas alidghıniy quvu: «Milkee Naxorus uxuyne Betuelyna yiş zı vorna». Zınad məng'ı'ne quşelqayiy guçaaşilqa ı'mər qı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Zı qiyğar q'aratsabışil gyu'ur, Rəbbis şukur hav'u. Mang'vee zı q'omançecar yizde xərıng'une çocune xaaqa qarı. Rəbbee zı yizde xərıng'une dixes çocuna neva hee'eceva məxüd hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Şu həşde zak'le eyhe, şos yizde xərıng'us yugvalla, qopkuvalla haa'as vukkannane? Şu zak'le man eyhe, zak'led ha'asın ats'a ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lavaneeyiy Betuelee mang'us inəxdın alidghıniy qele: – Man Rəbbike ıxhayn kar vod. Şalqa ho'ovaye de'eşvaye uvhiy gexha deş. ");
INSERT INTO tkr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Haane Rivq'a yiğne ögiyl vor, manar alyart'u, hoora. Rəbbee uvhiyn xhinnee, yiğne xərıng'une dixes xhunaşşe yixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","İbrıhımne həmbalık'le manbışe eyhenbı g'ayxhımee, mana Rəbbis ç'iyelqame k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Həmbalee tanalqan karbı, k'ınəəğəbı, nuk'rabı qığı'ı, Rivq'ays hele. Məng'ı'ne çocusud, yedisıd gıranın karbı helenbı. ");
INSERT INTO tkr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Mang'veeyiy cune insanaaşe otxhun-ulyodğu, xəm maa g'aaha. Miç'eeb oza qeepxhayng'a, həmbalee eyhen: – Zı yizde xərıng'usqa yəqqı'l he'e. ");
INSERT INTO tkr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","İçiyne çoceeyiy yedee eyhen: – Hasre içiy şakasana yits'ılle yiğnaxheeyir eexvecen, qiyğa iyeek'an. ");
INSERT INTO tkr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Həmbalee manbışik'le eyhen: – Rəbbee zas yəq aaqımee, zı ıqmaqqa. Hasre yizde xərıng'usqa hixharas. ");
INSERT INTO tkr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Manbışe eyhen: – Hiyeesre içiy qeet'alas, cen ghal g'ayxhes. ");
INSERT INTO tkr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rivq'a qort'ul, məng'ı'ke qiyghanan: – Ğu ing'uka əlyhəənane? Məng'eeyid «Əlyhəənava» eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Manbışe Rivq'a, məng'ı'ka ileekana, İbrıhımna həmbal, mang'ukan insanar yəqqı'l aa'a. ");
INSERT INTO tkr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rivq'ays xayir-düə huvu, eyhen: – Yişda yiçu, aazırne, yits'ne aazırne uşağıs yed yixhena! Hasre yiğne nasılene ögiyl duşmanaaşine şaharbışin akkabı hı'ğəkkaranbı! ");
INSERT INTO tkr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rivq'ayiy məng'ı'n həmbal zəiyfabı devabışil aleepxı, İbrıhımne həmbalıka avayk'ananbı. Məxür İbrıhımna həmbal Rivq'a ana ayk'anna. ");
INSERT INTO tkr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","I'saq' Beer-Laxay-Roi eyhene cigeençe qarayle, mana Negevee axva. ");
INSERT INTO tkr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Exha qexhemee, I'saq' çolune suralqa ayk'an. Mang'vee vuk'ul ooqa qav'umee, devabı qöö g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rivq'a vuk'ul ooqa qav'u, I'saq' g'acumee, mana devayle geeç'ena. ");
INSERT INTO tkr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Məng'ee İbrıhımne həmbalıke qiyghanan: – Yişde ögilqava çoleeqa arına ina insan vuşune? Həmbalee eyhen: – Mana yizda xərna vor. Manke kalağay alyapt'ı, məng'ee vuk'lelqa abaççe. ");
INSERT INTO tkr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Həmbalee vuk'lelqa qadıyne gırgınçina gaf I'saq'ıs haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","I'saq'ee Rivq'a cuna yed, Sarra, yeexhene çadıreeqa qiykekka, məng'ı'ke cus xhunaşşe hee'e. I'saq'ıs mana geer yikkiykan, cuna yed qiyk'uyle qiyğa məng'ee mang'us yik'bı hele. ");
INSERT INTO tkr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","İbrıhımee sa merna xhunaşşe hee'e. Məng'ı'n do Qetura ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Qeturee mang'us inbı vuxooxa: Zimran, Yoq'şan, Medan, Midyan, İşbaq, Şuax. ");
INSERT INTO tkr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoq'şanıke Şeva, Dedan g'abayle. Dedanıke inbı g'abı: Aşşurbı, Letuşbı, Leumbı. ");
INSERT INTO tkr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midyanın dixbı: Efa, Efer, Xanok, Avida, Eldaa. İnbışin gırgınbı Qeturayn uşaxar vob. ");
INSERT INTO tkr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","İbrıhımee cun gırgın kar I'saq'ıs hele. ");
INSERT INTO tkr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Həmbal zəiyfabışde dixbışisme paybı hele. Qik'assecar mang'vee manbı I'saq'ısse şargılyne surabışilqa g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","İbrıhımee vəşşe yights'ale xholle (175) sen ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Mang'vee xıliyna ı'mı'r haa'a, dyunyeyle ats'ı, q'əs qıxha qek'a. Məxür mana ahaleeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Dixbışe I'saq'ee, I'smı'ı'lee mana Mamreyne k'anene Maxpela eyhene mağaree k'eyxha. Mana mağara Q'etbışda eyxhene Tsoxarne dixene Efronne cigeeniy vob. ");
INSERT INTO tkr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Man ciga İbrıhımee Q'etbışike alişşu ıxha. İbrıhımnab cune xhunaşşeyna Sarraynab nyaq'v maa'ab vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Allahee İbrıhım qik'uyle qiyğa mang'une dixes, I'saq'ıs, xayir-düə hoole. I'saq' Beer-Laxay-Roi eyhene cigee axva ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sarrayne həmbalee Misirğançene Haacaree İbrıhımıs uxuyne I'smı'ı'lyna nasıl ina vob. ");
INSERT INTO tkr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Çiçiqab qihna vuxuyne I'smı'ı'lyne dixbışin dobı inbı vod: I'smı'ı'lyna xərna dix Nevayot, Qedar, Adbeel, Mivsam, ");
INSERT INTO tkr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mişma, Duma, Massa, ");
INSERT INTO tkr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Xadad, Tema, Yetur, Nafiş, Qedma. ");
INSERT INTO tkr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","I'smı'ı'lin dixbı inbı vob. Manbışin dobı co aaxvane cigabışisiy xivaaşis huvu. Manbı cone yits'ıq'vəne (12) nasılen ç'ak'ınbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","I'smı'ı'lee vəşşe xhebts'ale yighılle (137) sen ha'a. Mana qek'ana, məxür mana ahaleeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","I'smı'ı'like g'abıynbı Xavila eyhene cigeençe Şur eyhene cigeeqameene cigee aaxva vuxha. Şur Aşşurqa əlyhəəme Misirne ögiyl vooxhe. Manbı çocaaşika aldaaxhvancab vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","İbrıhımne dixen I'saq'ın taarix inəxüd vod: I'saq' İbrıhımıke g'arı. ");
INSERT INTO tkr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","I'saq'ee Paddan-Arameençe Aramğançene Betuelyna yiş, Lavanna yiçu Rivq'a hee'eng'a, mang'uqa yoq'ts'al (40) senniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","I'saq'ee xhunaşşe vuxhne ideexvava Rəbbis düə hav'u. Rəbbik'le I'saq'na düə g'avxhu, mang'una xhunaşşe Rivq'a vuxhne ayxu. ");
INSERT INTO tkr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Yedine vuxhnee uşaxar sıç'ooka giviyğal. Məng'eeyid «Nişil-allane in yizde vuk'lelqa qadıva?» uvhu, Rəbbike qiyghanas hiyeek'an. ");
INSERT INTO tkr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Rəbbee məng'ı'k'le eyhen: – Yiğne vuxhne q'ölle millet vod, Yiğne vuxhnençe q'ölle xalq' qığeç'es. Sa xalq' manisa xalq'ıle gucuka ixhes, Xərne çocee k'ıning'us g'ullux haa'as. ");
INSERT INTO tkr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rivq'ayna uxasda gah qabıyng'a, ats'axhxhen məng'ı'ne vuxhne q'ömkaler vuxhay. ");
INSERT INTO tkr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ts'erree uxuyne uşaxın g'ekva ç'əradaniy, sayir mana xhayıke hı'iyn kar xhinne xhırıra ıxha. Mançil-allad mang'un do Esav (xhırıra) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Qiyğar manasa çoc Esavne mı'q'leyke at'irq'ın dyunyelqa qarayle. Mançil-allad mang'unud do Yaaq'ub (mı'q'leyke at'irq'ın) giyxhe. Manbı vuxhayng'a I'saq'ıqa yixhts'al (60) senniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Çocar ç'ak'ı qeebaxhe: Esav yugna k'onay, xaa hüdöörəxəna insan eyxhe, Yaaq'ubır hexxan nıq' denana xaana insan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I'saq'ıs Esavniyxhe geer ıkkiykanna, mang'vee ı'xı'yn həyvanar cus ıkkanəxüd eyxheva. Rivq'aysmee Yaaq'ubniyxhe ıkkiykanna. ");
INSERT INTO tkr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sa yiğıl Yaaq'ubee yıq' haa'a. Esavır çoleençe orzul-ortul mıssıra qarayle. ");
INSERT INTO tkr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esavee Yaaq'ubık'le eyhen: – Mane ç'ərane karake sık'ınin zas hele oxhanas, mıs qıxha. Mançil-alla mang'us q'öd'esın do Edom (ç'ərara) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaaq'ubee eyhen: – Manke ts'erriyna dixvalla zas hevle. ");
INSERT INTO tkr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esavee eyhen: – Zı mıssınçe qek'ang'a zas ts'erriyna dixvalla nişistannane? ");
INSERT INTO tkr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaaq'ubee eyhen: – Ts'etta zas k'ın he'e! Esavee k'ın g'assır ts'eppiyna dixvalla Yaaq'ubıs qoole. ");
INSERT INTO tkr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yaaq'ubee Esavıs hüvəyna yıq'iy gıney hele. Esav otxhun-ulyodğu qığeç'u ayk'anna. İnəxüb Esavne ulesqa ts'erriyna dixvalla kar xhinne qavayle deş. ");
INSERT INTO tkr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","İbrıhımne gahılyna mısvalla xhineena, ölkee sa mebnab mısvalla vuxhana. I'saq' Gerar eyhene şahareeqa, Filiştinbışde paççahne, Avimelekne, k'anyaqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Rəbb mang'us gyagu, eyhen: – Misirqa ımayk'an. Zı vak'le uvhuyne cigee axve. ");
INSERT INTO tkr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","İne ölkee menne cigayna xhinnee axve. Zı vaka ixhes, vas xayir-düə hevles. Yiğne dekkıs İbrıhımıs k'ın g'aysır ha'asva uvhuyn karbı ha'asınbı: in gırgın cigabı vasiy vake g'abıynbışis heles. ");
INSERT INTO tkr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Vake g'abıynbı xəədın xənebımee geeb qaa'as, in gırgın cigabı yiğne nasıles heles. Ç'iyene aq'valyne gırgıne milletbışe vake g'abıynbışile ğana xayir-düə alyapt'as. ");
INSERT INTO tkr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","İbrıhımee Yizde cuvabıl k'ırı alixhxhı, Zı uvhuynçika gyu'ur-oza qıxha, Yizde əmrbışil, g'aydabışil, q'aanunbışil k'ırı alixhxhı. Mançil-alla Zı in cigabı vas hele. ");
INSERT INTO tkr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","I'saq'ır Gerar axva. ");
INSERT INTO tkr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mane ölkayne insanaaşe I'saq'ıke cune xhunaşşeyne hək'ee qiyghınmee, mang'vee «İna yizda yiçu vornava» uvhu. Rivq'a geer micagrava, I'saq' «Mana yizda xhunaşşeva» eyhes qərq'ı'nna. Mang'vee culed-alqa eyhen: «Deşxheene, Rivq'al-alla ine ölkayne insanaaşe zı gik'asda». ");
INSERT INTO tkr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","I'saq' maa'ar geer axva. Yiğbışde sa yiğıl Filiştinbışda paççah Avimelek g'ulele horzulymee, I'saq' cune xhunaşşeyka huvaga g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Avimelekee I'saq' qort'ul, eyhen: – Mana yiğna xhunaşşevur. Nya'a ğu məng'ı'ne hək'ee «İna yizda yiçuva» uvhu? I'saq'ee mang'uk'le qiyghanan: – Məng'ı'l-alla zı g'ek'ava qərq'ı'n. ");
INSERT INTO tkr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Avimelekee eyhen: – İn ğu şak hı'iyn hucoona? Yişde insanaaşina sa yiğne xhunaşşeyka g'alixhasse axu. Məxüb ğu şi bınaheeqa aa'asse avxu. ");
INSERT INTO tkr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Qiyğa Avimelekee milletılqa g'ayxha'a: – İne insanıkiy mang'une xhunaşşeyk qet'una gidek'u g'alerçes deş. ");
INSERT INTO tkr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","I'saq'ee mane cigabışee toxum qeehe, mane sen şagav vəş nəqqees ezuynçile geed eyxhe. Məxüb Rəbbee mang'us xayir-düə hoole. ");
INSERT INTO tkr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mang'uke geed karnana insan eyxhe. Yiğ-yiğıle mang'un kar geed qexhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Mang'uqa geed çavra-vəq'ə, həmbalar vobva Filiştinbışde ulen man alyaat'a deş. ");
INSERT INTO tkr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Dekkıne İbrıhımne gahıl mang'une həmbalaaşe alitk'uriyn gırgın kahrızbı Filiştinbışe nyaq'vuka gyatsts'a'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Avimelekee I'saq'ık'le eyhen: – Şasse hoora, ğu şale nimeexheyir gucnana ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","I'saq' mançe ayk'anna. Mana Gerarne q'adaalilqa qarı, maayir axvana. ");
INSERT INTO tkr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","I'saq'ee dekkıne İbrıhımne gahıl xhinesva alitk'uriyn kahrızbı meed iliyk'varanbı. Man kahrızbı Filiştinbışe nyaq'vuka gyatsts'ı'ı ıxha. Mang'vee dekkee gixhxhiyn dobı meed mane kahrızbışilqa giyxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","I'saq'ne həmbalaaşe q'adaalil ciga alitk'ur, maa'ad xhyan ı'lqəən ciga iveeke. ");
INSERT INTO tkr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerarne çobanaaşe «Xhyan yişin vodva» uvhu, I'saq'ne çobanaaşika xıliynbı ha'a giviyğal. Maa'ad xıliynbı ıxhava, I'saq'ee mane kahrızın do Eseq (xıliynbı) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","I'saq'ne həmbalaaşe sa mebna kahrız ilyviyk'ar. Mançil-allad meed xıliynbı ha'a. I'saq'ee mane kahrızın doyud Sitna (duşmaniyvalla) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","I'saq' mançe ark'ın, sa mebna kahrız ilyviyk'ar. Mançil-allamee xıliynbı ha'a deş. Məxüd ıxha, I'saq'ee mançin do Rexovot (ağlaxıyvalla) gixhxhı, eyhen: «Həşde Rəbbee şas ağlaxıyvalla huvu, şi ine cigee geeb qeepxhes». ");
INSERT INTO tkr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","I'saq' mançe Beer-Şeveeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mane xəmde Rəbb mang'us gyagu, eyhen: – Zı yiğne dekkee, İbrıhımee, ı'bəədat hı'ına Allah vorna. Qı'məyq'ən, Zı vaka vorna. Yizde nukarne İbrıhımnemee, Zı vas xayir-düə hevles, vake g'abıynbıb geeb qaa'as. ");
INSERT INTO tkr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","I'saq'ee maa'ad q'urbanbı allya'an ciga ali'ı, Rəbbis ı'bəədat ha'a. Mang'vee maa'ab cusda çadır giviyxə. I'saq'ne həmbalaaşe meeb maa'ab kahrız ilyviyk'ar. ");
INSERT INTO tkr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Mane gahıl Avimelek cune mı'sləhətçiyka, Axuzatıka, g'oşunne xərıng'uka, Pikoluka, sacigee Gerareençe I'saq' eyxhene cigabışeeqa arayle. ");
INSERT INTO tkr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","I'saq'ee manbışik'le eyhen: – Nişisne şu zasqa abı? Şos zı g'ımece qıxha, şu zı g'e'eşşunaniy. ");
INSERT INTO tkr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Manbışe eyhen: – Şak'le g'acuyn, Rəbb hək'erar vakavur. Həşde şas ıkkanan ğunad şinad k'ınybı g'aysaras. Qora, vaka cuvab g'ats'ak'vanas. ");
INSERT INTO tkr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Şi vak syudyoot'u, vaka yugbacab vuxha, yugrar yəqqı'l arçun xhinnee, ğunad şak pisın ha'as deş. Ğu həşde Rəbbee xayir-düə huvuna insan vor. ");
INSERT INTO tkr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","I'saq'ee manbışis sufra qa'a, manbışed yugda otxhun-ulyoğan. ");
INSERT INTO tkr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Manbı miç'eeb çakba oza qeepxha, sana-sang'us k'ın g'iysar. I'saq'ee manbı sağba-salamatba yəqqı'l haa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mane yiğıl I'saq'ın həmbalar abı, alipk'ırne kahrızne hək'ee «Xhyan qığeç'uynva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I'saq'ee mane kahrızın do Şeva (k'ın) giyxhe. Mançil-allad mane şaharın do g'iyniyne yiğılqamee Beer-Şeva (k'ınena kahrız) vod. ");
INSERT INTO tkr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esavıqa yoq'ts'al (40) sennang'a, mang'vee Beerna yiş Yehuditiy, Elonna yiş Basmat cus haa'a. Manbışda q'öyursana Q'etbışinbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Man zəiyfabı I'saq'neyiy Rivq'ayne vuk'lene ık'arılqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","I'saq' q'əsniy qıxha, mang'une uleppışik'le g'ece deşdiy. Mang'vee xərna dix Esav k'anyaqa qort'ul uvhuyn: – Dix! Esavee mang'uk'le «Dek, zı inyaa vor» uvhu. ");
INSERT INTO tkr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I'saq'ee uvhuyn: – Zı haane q'əs qıxha, g'iyna-g'iyqa qik'asda. ");
INSERT INTO tkr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Həşdiylee aleet'e yiğın yaraxbıd – vukiy ayhenbıd – hak'ne çoleeqa yizdemee k'on üvxe. ");
INSERT INTO tkr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Qiyğaled zas ıkkanan geed yugun otxhuniy hı'ı, zas alle. Manıd otxhun, zı vas qik'asse xayir-düə hevles. ");
INSERT INTO tkr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","I'saq' dixeka Esavıka yuşan ha'ang'a Rivq'ee manbışil k'ırıniy iliyxhe. Esav çoleeqa k'on üvxəs ark'ınmee, ");
INSERT INTO tkr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rivq'a dixesqa Yaaq'ubısqa hark'ın inəxüd eyhe: – Zak'le g'ayxhiyn dekke yiğne çocuk'le Esavık'le inva uvhu: ");
INSERT INTO tkr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","«Yizdemee sa k'on üvxü able, çiked sa yugun otxhuniy he'e. Manıd otxhun, zı vas qik'asse Rəbbine ögee xayir-düə hevles». ");
INSERT INTO tkr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Dix, həşde zı eyhençil yugda k'ırı gyaqqe: ");
INSERT INTO tkr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","hak'ne syuruneençe zasqa gırgınçile yugna q'öble mısva able. Mançike zı dekkıs ıkkanəxdun otxhuniy ha'as. ");
INSERT INTO tkr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ğunad man dekkıs oxhanas ıkkees, qik'asse vas xayir-düə hevlecenva. ");
INSERT INTO tkr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaaq'ubee Rivq'ayk'le eyhen: – Yizda çoc Esav xhırına kar vor, zaqame xhırıvalla deşda. ");
INSERT INTO tkr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sayid dekkee zalqa xıl hadağva, ats'axhe zı cus horbı hı'iy. Manke xayir-düəyne cigee, mang'vee zalqa bed-düə g'axuvles. ");
INSERT INTO tkr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yedee mang'uk'le eyhen: – Dix, valqa haa'asda bed-düə zalqa quvooracen. Saccu yizde cuvabıl k'ırı gyaqqe: hoora, uvhuyn kar zasqa alle. ");
INSERT INTO tkr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yaaq'ub hark'ın, mısvabı yedisqa adayle. Yedeeyid dekkıs ıkkanəxdın yugun otxhuniy ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Mançile qiyğa Rivq'ee cone xaadın xərne dixen Esavın gırgınçile yugun tanalinbı alyaat'u, k'ınne dixelqa Yaaq'ubılqa alya'a. ");
INSERT INTO tkr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Xıleppışin oodun ciga, gardanıl nyaabiy xhırıvalla deş məng'ee mısvabışde g'ekvabışika iyt'alanbı. ");
INSERT INTO tkr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Qiyğad hı'iyn yugun otxhuniyiy gıney Yaaq'ubne xıleqa qele. ");
INSERT INTO tkr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaaq'ub dekkısqa qarı eyhen: – Dek! Dekke mang'uk'le eyhen: – Yizın k'ırı val vod. Ğu nenane vor yizde dixbışda? ");
INSERT INTO tkr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaaq'ubee dekkık'le eyhen: – Yiğna ts'erriyna dix, Esav vor. Zı ğu uvhuyn xhinne hı'iyn. Həşder oza qıxha gyu'ur zı adıyn k'onan çuru oxhne, zas xayir-düə hevles vəəxecenva. ");
INSERT INTO tkr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","I'saq'ee dixek'le eyhen: – Dix, nəxüdne ıxha vasqa inəxüb zaraba k'on gipxhı? Mang'vee eyhen: – Yiğne Allahee, Rəbbee zas kumag hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","I'saq'ee Yaaq'ubık'le eyhen: – Dix, zasqa qora. Valqa xıl g'adğvas, zak'le ats'axhes, ğu yizda dix Esavee, dişee? ");
INSERT INTO tkr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaaq'ub dekkısqa qıxhamee, dekkee I'saq'ee mang'ulqa xıl g'adğu, eyhen: – Nıq' Yaaq'ubınıd, xıleppıd Esavınbı vod. ");
INSERT INTO tkr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yaaq'ubınıd xıleppı cune çocunbı Esavınbı xhinne xhırıdava, I'saq'ık'le mana qıvaats'a deş. İnəxüb I'saq'ee Yaaq'ubıs xayir-düə hoolena. ");
INSERT INTO tkr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Mang'vee qiyghanan: – Hək'erar ğu yizda dix Esavne? Yaaq'ubee eyhen: – Ho'o. ");
INSERT INTO tkr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","I'saq'ee meed eyhen: – Dix, k'onan çuru qadı ögeeqa gixhxhe, yic otxhun vas xayir-düə hevles. Yaaq'ubee ts'etta otxhuniy, qiyğad çaxır adayle. I'saq'ee otxhun, ulyoğan. ");
INSERT INTO tkr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mançile qiyğa I'saq'ee eyhen: – Dix, həşde zasqa qora, zas ubba he'e. ");
INSERT INTO tkr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaaq'ub dekkısqana qıxha, mang'us ubba ha'an. I'saq'ıs mang'une tanalinçin eva ı'xı'mee, xayir-düə huvu eyhen: – Yizde dixeken eva, Rəbbee xayir-düə huvuyne çolbışiken xhinnevud. ");
INSERT INTO tkr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hasre Allahee vas ç'iyeyna yugna nyaq'viy xəən gyoğiy helecen, vas xətta g'ıkıy çaxır ixhecenva. ");
INSERT INTO tkr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Havaasre milletbışe vas g'ullux hee'ecen, Ummatbışe yiğne ögee vuk'ul avqa qee'ecen. Ğu yiğne çocaaşis xəbvalla hee'e, Havaasre yiğne yedine dixbışdab yiğne ögiyl gardan hı'kkeba vuxhecen. Vas bed-düə haa'anbışilqa bed-düə vuxhecen, Vas xayir-düə haa'anbışis xayir-düə vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yaaq'ubee I'saq'na xayir-düə alyapt'ı qığeç'umee, k'onaqa hark'ınna çoc Esav siyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esavee sa yugun otxhuniy hı'ı, dekkıs adı eyhen: – Dek, oza qıxha zı adıyne k'onane çurunuke oxhne, zas xayir-düə hevles vəəxecenva. ");
INSERT INTO tkr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Dekkee I'saq'ee mang'uke qiyghanan: – Ğu vuşune? Mang'vee eyhen: – Zı yiğna ts'erriyna dix Esav vorna. ");
INSERT INTO tkr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","I'saq'ne caneeqa it'umna zeze ooxha. Mang'vee ek'da qiyghanan: – Manke şena vuşuniy vor, k'on avaykı zas abına? Ğu qalesse gırgıne karake otxhun, mang'us xayir-düə huvu. Xayir-düəyib mang'una vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Dekkee eyhenbı g'ayxhımee Esavee k'arats'ana ts'ir haa'a: – Dek, zasıb xayir-düə hevle, zınar xayir-düəna he'e! ");
INSERT INTO tkr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","I'saq'ee eyhen: – Çoc horbışika arı, yiğna xayir-düə g'avşuna. ");
INSERT INTO tkr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esavee eyhen: – Mang'un do həməxüdcad deşke Yaaq'ub ıxha? Mang'vee zas q'ö'es horbı ha'anbı vod: ts'eppa yizda ts'erriyna dixvalla g'avşu, həşdeb xayir-düə. Qiyğa eyhen: – Zas xayir-düə havaacı dişde? ");
INSERT INTO tkr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","I'saq'ee mang'uk'le eyhen: – Mana yiğna xərna hı'ı, gırgın ebanbı mang'us nukarar xhinne quvu, gıkınayiy ts'enne çaxırena hı'ı. Vas hucoone he'e, dix? ");
INSERT INTO tkr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esavee dekkık'le eyhen: – Dek, vaqa sa xayir-düəne vob? Zasıb xayir-düə hevle, dek! Esav axtıra geşşuna. ");
INSERT INTO tkr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Dekkee Esavık'le inəxüd eyhe: – Ğu eyxhen ciga, ç'iyeyne barakayle, Xəybışded ç'iyike əq'əna ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ğu vasın g'ık g'ılıncıka ha'as. Çocusub g'ullux haa'as. Ğu mang'uke g'attixhanasda gah qabıyng'a, Mang'una xamut gardanıle qopxu g'uvooxharasda. ");
INSERT INTO tkr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Dekkee Yaaq'ubıs xayir-düə huvuyl-alla, Esavıs çoc g'ımece qexhe. Mang'vee culed-alqa eyhen: – Dekkıqa gyaaşesın yiğbı hiyxharıd. Manke zı yizda çoc Yaaq'ub gek'a. ");
INSERT INTO tkr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Xənne dixee Esavee uvhuynbı Rivq'ayk'le g'ayxhımee, məng'ee k'ınna dix Yaaq'ub qort'ul eyhen: – Yiğne çocus Esavıs ğu gik'u, vake qəl qığaahasıb vukkan. ");
INSERT INTO tkr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Dix, həşde yizde cuvabıl k'ırı alixhxhe: oza qıxha Xaraneeqa, yizde çoc Lavanne k'anyaqa hixve. ");
INSERT INTO tkr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Yiğne çocuna qəl əlyhəəsmee, sabara gahna Lavanne k'ane axve. ");
INSERT INTO tkr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Valqana qəl apk'ınmee, ğu cuk hı'iynbı yik'el hitxınmee, zı valqa xabar g'axuvu mançe qalya'asda. Nişil-allane zı vuşde q'öng'ukesanar sa yiğıl yixhes? ");
INSERT INTO tkr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Qiyğa Rivq'ee I'saq'ık'le eyhen: – Q'etbışda eyxhene Esavne xhunaşşeeşine xılençe zı ı'mreke ayts'ına. Yaaq'ubeeyir mane cigayne içeeşina, manbı xhinnena, həməxürna Q'etbışda cus hey'ee, zı ı'mı'r nişiscabne haa'a? ");
INSERT INTO tkr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","I'saq'ee Yaaq'ub qort'ul, mang'us xayir-düə huvu, inəxübna mı'sləhət g'ooce: – Kana'anğançene içeeşike xhunaşşe himee'e. ");
INSERT INTO tkr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Vaxt xıliy qıdyav'u Paddan-Arameeqa, yiğne yedine dekkıne Betuelyne xaaqa hoora. Yiğne yedine çocune Lavanne yişbışike vas xhunaşşe hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Gırgın əxəne Allahee vas xayir-düə hevlecen, ğu geer kulyfatnana hı'ı, vake g'abıynbı geeb qee'ecen, vake geed milletbı g'alecen. ");
INSERT INTO tkr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","İbrıhımne xayir-düəyke vasiy vake g'adıyne nasılbışisıb vuxhecen: hasre Allahee İbrıhımıs helesva uvhuyn ciga – ğu menne cigeençe qarına xhinne iykaran ciga, hammaşiys vas helecen. ");
INSERT INTO tkr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","I'saq'ee Yaaq'ub yəqqı'l araççe. Mana Paddan-Arameeqa, Yaaq'ubneyiy Esavne yedine Rivq'ayne çocune Aramğançene Betuelyne dixene Lavanne k'anyaqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esavık'le ats'axhen, I'saq'ee Yaaq'ubıs xayir-düə huvu cus xhunaşşe hee'ecenva Paddan-Arameeqa g'axuvuva, sayib, mang'us xayir-düə hooleng'a «Kana'anğançene içeeşike xhunaşşe hime'eva» mı'sləhət g'ooce. ");
INSERT INTO tkr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaaq'ubeeyid dekkıliy yedil k'ırı gyaqqı Paddan-Arameeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esavık'le g'ecen, kana'anğançen içer dekkıs vukkan deşubne. ");
INSERT INTO tkr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esav ayk'anna I'smı'ı'lyne k'anyaqa. Mang'vee İbrıhımne dixena I'smı'ı'lyna yiş Maxalat cune xhunaşşeeşine ooğançe hee'e. Maxalat Nevayotna yiçuniy vor. ");
INSERT INTO tkr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaaq'ub Beer-Şeveençe qığeç'u Xaranne suralqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Sa cigeeqa hirxhılymee, verığ k'yooçuva mang'vee xəm maa g'aaha. Mang'vee ç'iyele sa g'aye alyapt'ı, vuk'lek avqa givxhu, g'ılexhana. ");
INSERT INTO tkr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mang'uk'le nik'ek ç'iyele xəybışeeqa hiyxharan q'ı't'yar, çilek'enad Allahın malaaikar ılqeeç'u-gəə g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Rəbbee q'ı't'yaaşil ulyorzul eyheyiy: – Zı yiğne dekkıne dekkına İbrıhımna, sayir I'saq'na Allah Rəbb vorna. Ğu g'alirxhuyn ç'iye vasiy vake g'abıynbışis heles. ");
INSERT INTO tkr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Yiğna nasıl ç'iyeylin tooz xhinne xəppa vuxhes, geeb qeepxha garbılqayiy şargılqa, şimalılqayiy canubulqa ookas. Ç'iyeyne aq'valyne gırgıne milletbışe valeyiy vale g'abıynbışile k'ena xayir-düə alyapt'as. ");
INSERT INTO tkr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Zı vaka vorna, Zı ğu, nençeğana ark'ıneeyir havacı, ine cigeeqa sak'al ha'asda. Zı ğu g'alerçes deş, Zı uvhuyn gırgın ha'asın. ");
INSERT INTO tkr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaaq'ub nik'eençe muğur qıxha eyhen: – Hək'erar, Rəbb inyaa ooxhur. Zak'le man ats'a deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Mang'vee qərq'iniyvaliyn eyhen: – Nimeeyiy ine cigayn qəq'ən ha'a. İn Allahne xaale ğayrı medın kar deşod, inbı xəybışin akkabıvud. ");
INSERT INTO tkr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaaq'ub miç'eer çakra suğotsu, cune vuk'lek avubna g'aye alyapt'ı işaarat xhinne giviyxhe. Qiyğad Allahne doyule çilqa zeytunun q'ış k'ya'a. ");
INSERT INTO tkr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Mang'vee mane cigayn do Bet-El (Allahın xav) giyxhe, mankilqamee mane şaharın do Luz ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Qiyğa Yaaq'ubee k'ın g'assır eyhen: – Allah zaka ixheene, hoyharne ine yəqqə zı havaceene, zas oxhanasın gıneyiy alya'asın tanalinbıd huveene, ");
INSERT INTO tkr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","yugvale zı dekkıne xaaqa sark'ıleene, manke Rəbb yizda Allah ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","İşaarat xhinne gyuvxhuna ina g'aye Allahın xav ixhes. Ğu helesde gırgınçike yits'ıb'esda pay Vas qevles. ");
INSERT INTO tkr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yaaq'ub ayk'anna şargılyne milletbışde cigabışeeqa. ");
INSERT INTO tkr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Çoleeab mang'uk'le sa kahrız g'ooce. Mançine k'anya'ad xhebılle vəq'əbışin syuru g'alitxhu eyxhe. Vəq'əbışis mane kahrızeençe xhyan hele ıxha. Kahrızne ghalelib xəbna g'aye vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Gırgın vəq'əbı maqa sadıyng'a, çobanaaşe kahrızne ghalelyna g'aye qavaak'anav'u vəq'əbışis ats'esın xhyanbı huvu, g'aye giviyxhe vuxhana çine cigalqa kahrızne ghalilqa. ");
INSERT INTO tkr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaaq'ubee manbışike qiyghanan: – Çocar, şu nençenbıne vob? Manbışe eyhen: – Şi Xaraneençenbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yaaq'ubee manbışik'le eyhen: – Naxorna neva Lavan ats'anane? Manbışe eyhen: – Ats'ana. ");
INSERT INTO tkr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaaq'ubee manbışike qiyghanan: – Mana yugrayee? Manbışe eyhen: – Ho'o, yugra vor. Haaşe, mang'una yiş Raahile cune vəq'əbışika qöövur. ");
INSERT INTO tkr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaaq'ubee eyhen: – Verığ axtıvaleevub, vəq'əbı sa'ana vaxt vuxha deşub. Vəq'əbışis xhyan huvu, uxhiyxhanas ıkkee. ");
INSERT INTO tkr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Manbışe eyhen: – Çobanaaşe gırgın vəq'əbı sacigeeqa sidi'ı, g'aye kahrızne ghalele qavaak'an hidyav'u, man ha'as ixhes deş. Man gırgın hı'iyle qiyğa şasse xhyan heles əxə. ");
INSERT INTO tkr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yaaq'ub manbışika yuşana'ang'a, Raahilee dekkın vəq'əbı qadayle. Raahileyib çobaniyvallaniy haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaaq'ubık'le dayisiy Lavanna yiş Raahileyiy con vəq'əbı g'acesse, mang'vee ark'ın g'aye qavaak'anav'u dayisiyne vəq'əbışis xhyan hele. ");
INSERT INTO tkr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Qiyğa Yaaq'ubee Raahileys ubba hı'ı axtıra geşşe giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Mang'vee Raahileyk'le dekkıne ebanbışikena Rivq'ayna dix ıxhay eyhe. Raahilee g'adeexhvan ark'ın man dekkıs yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lavanık'le yiçeyna dix arıva g'ayxhımee, g'adayxhvan ögiylqa qığeç'e. Mana xhılibışeeqa sı'ı, ubba hı'ı cune xaaqa qıkkekka. Yaaq'ubee gırgın kar Lavanıs yuşan ha'an. ");
INSERT INTO tkr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lavanee mang'uk'le eyhen: – Ğu hək'erar yizde ebanavur. Yaaq'ub manbışəəng'ə sa vazna axuyle qiyğa, ");
INSERT INTO tkr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lavanee mang'uk'le eyhen: – Nya'a, ğu yizda ebanava, ğu zas q'ərabne iş haa'as? Zak'le eyhelan yiğna hək' hucoone vuxhes? ");
INSERT INTO tkr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lavanıqa q'öyre yişniy vor: xərıng'ı'n do Leaniy, k'ıning'ı'nıd Raahileniy vod. ");
INSERT INTO tkr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leayne uleppışik'le torandaniy g'ece, Raahileme ul givxhasda, xhyan ittuna içiy yixha. ");
INSERT INTO tkr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaaq'ubıs Raahile yikkiykınil-alla eyhen: – K'ınne yiş Raahileynimee zı vas yighılle senna iş g'ooce. ");
INSERT INTO tkr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lavanee eyhen: – Mana vas hiyvee, merne insanıs hiyvuyle, nimeexheyid yugda eyhe. Ğu şing'əəcar axve. ");
INSERT INTO tkr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yaaq'ubee Raahilel-alla yighılle senna iş haa'a. Mana yikkiykinil-alla mana vaxt mang'une ulesqa sa-q'ölle yiğ xhinne qavayle. ");
INSERT INTO tkr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yaaq'ubee Lavanık'le eyhen: – Vaxt g'abına, həşde yizda xhunaşşe zasqa qiyeele, məng'ı'ka ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lavanee mane cigabışin gırgın insanar sav'u otxhun-ulyodğuy hele. ");
INSERT INTO tkr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Xəmder Raahileyne cigee Lea akkeehe Yaaq'ubne k'anyaqa. Yaaq'ub məng'ı'ka g'ılexhana. ");
INSERT INTO tkr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Lavanee cuna nukar Zilypan Leays g'ulluxçiy xhinne heele.) ");
INSERT INTO tkr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Yaaq'ubık'le mana Lea yixhay miç'eed ats'axhe! Mang'vee Lavanık'le eyhen: – Nya'a ğu zak məxdun kar hı'ı? Zı Raahileyneme dişde vas iş g'avcu? Nişil-allane ğu zas horbı hı'ı? ");
INSERT INTO tkr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lavanee eyhen: – Yişde ine cigee k'ınna yiş xərıng'ı'le ögee adamiys heelen ədat deşin. ");
INSERT INTO tkr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","İn ülycüm bıkıre'e, Raahiler vas hiyles. Məng'ı'nimeeyir ğu yighılle senna yizde k'ane iş haa'as vukkan. ");
INSERT INTO tkr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaaq'ubee həməxüdud ha'an: man ülycüm bıkıra'an. Lavaneeyir Raahile mang'us xhunaşşe yixhecenva heelena. ");
INSERT INTO tkr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Cuna nukar Bilyhanır, Raahileys g'ulluxçiy xhinne hiyvu.) ");
INSERT INTO tkr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaaq'ub Raahileykar g'ılexhana. Raahile mang'us Leayle geer yikkiykan. Mana Lavanne k'ane sa yighılle sennar höörəxəna. ");
INSERT INTO tkr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Rəbbik'le Lea deykan g'aycumee, məng'ı's uşaxar uxooxas vəvxı'y hele. Raahileyssemee vuxhne eexvas yeexə deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea vuxhne ayxu sa dix uxu. Mang'un do Ruven (ilyaake, dix!) gixhxhı eyhen: – Rəbbik'le zı höödəxən g'acuyn. Həşde zı yizde adamiys yikkiykanasda. ");
INSERT INTO tkr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Mana meer vuxhne eexva. Sayir dix uxu eyhen: – Rəbbik'le zı deykan yixhay g'ayxhı, inar huvuna. Mang'unud do Şimon (Mang'uk'le g'ayxhiyn) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea xhebır'es vuxhne ayxu dix uxu eyhen: – Zı mang'us xhebiyre dix uxuva, ine yəqqə adamiy zaka ixhes, zak at'iq'anasda. Mançil-allad mang'un do Levi (at'iq'anasda) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Yoq'ur'es mana vuxhne ayxu meer dix uxu, eyhen: – İne yəqqə zı Rəbb axtı qa'as. Mançil-allad mang'un do Yahud (axtı qa'as) giyxhe. Mançile qiyğa məng'ee sabara gahna uxooxa deş. ");
INSERT INTO tkr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raahileysse Yaaq'ubıs uşax uxas dəxəmee, məng'ee yuçeys paxılıyvalla haa'a. Məng'ee adamiyk'le eyhen: – Zas uşax hele, deşxhee, qiyk'asda! ");
INSERT INTO tkr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaaq'ub Raahileylqa qəllamışxha eyhen: – Nya'a zıne vas uşax hidele, nya'a zı Allahne vor? ");
INSERT INTO tkr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Raahilee eyhen: – Yizda nukar Bilyhan alert'e, məng'ı'ka g'alixhe. Məng'ee uşax uxumee zı mana alyart'u mang'us yedyvalla haa'as, zı uşaxdena imeexvacenva. ");
INSERT INTO tkr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Raahilee cena nukar Bilyhan adamiys xhunaşşe yixhecenva heele. Yaaq'ubır məng'ı'ka g'ılexhana. ");
INSERT INTO tkr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilyhan vuxhne ayxu, mang'us dix uxu. ");
INSERT INTO tkr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raahilee eyhen: – Allah məhkamee yizde sural ıxha, yizın nıq' g'ayxhı, zas dix huvu. Mançil-allad məng'ee mang'un do Dani (Mang'vee məhkamee havacesda) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Raahileyna nukar Bilyhan meer vuxhne eexva, məng'ee Yaaq'ubıs q'ör'esda dix uxooxa. ");
INSERT INTO tkr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raahilee eyhen: – Zı yuçeyka saç'iyku, Allahne kumagıka ğamiyxhana. Məng'ee mançil-allad uşaxın do Naftali (yizın saç'iykuy) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leaysse sabara gahna uşaxar uxooxas vəvxü deş. Məng'ee mançil-allar cena nukar Zilypan Yaaq'ubıs xhunaşşe yixhecenva heele. ");
INSERT INTO tkr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Leayne nukaree Zilypanee Yaaq'ubıs sa dix uxu. ");
INSERT INTO tkr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leayee eyhen: – Nimee xəbna xoşbaxtıyvallayiy! Məng'ee mang'un doyud Qad (xoşbaxtıyvalla) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leayne nukaree Zilypanee Yaaq'ubıs q'ör'esda dix uxu. ");
INSERT INTO tkr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leayee eyhen: – Zı baxtivarır, yadaaşed zak'le baxtivarva eyhes. Məng'ee uşaxın do Aşer (baxtivar) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruvenık'le suk qiviyşalne gahıl çolead mandragorun ala iveeke, mang'vee manbı yedis Leays adayle. Raahilee Leayk'le eyhen: – Yiğne dixee adıyn mandragorbışike zasıd helelan. ");
INSERT INTO tkr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leayee məng'ı'k'le eyhen: – Adamiy xılençe g'ayşuy ç'əvxha dişdee? Həşded dixen mandragorbıne g'ayşes ıkkan? Raahilee eyhen: – Həməxüdxheene, hasre dixene mandragorbışil-alla ine xəmdiys yizda adamiy vaka g'alixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yaaq'ub exheeqana çoleençe qööng'ə, mang'unee ögeeqa Lea qığeyç'u, eyhen: – Ğu g'iyna zaka g'alixhas, yizde dixee adıyne mandragorbışis zı ğu alişşu. Yaaq'ub mane xəmde məng'ı'ka g'ılexha. ");
INSERT INTO tkr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Allahık'le Leayna düə giviyxhena. Lea vuxhne ayxu, Yaaq'ubıs xhor'esda dix uxu. ");
INSERT INTO tkr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leayee eyhen: – Allahee zı yizda nukar yizde adamiys hiyvuy höötxüva, yizda hək' quvuna. Məng'ee uşaxın do İssaxar (Mang'vee hək' quvuna) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leaye meer vuxhne eexva, məng'ee Yaaq'ubıs yixhır'esda dix uxooxa. ");
INSERT INTO tkr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Məng'ee eyhen: – Allahee zas sa yugna pay huvu. Zı mang'us yixhıyre dix uxuva, həşde yizde adamee zas hı'rmat gyuvxhesda. Məng'ee uşaxın do Zevulun (hı'rmat) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sabara gahıle məng'ee sa yiş yuxu, doyud Dina giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Allahee Raahile yik'el qiyelee'e, məng'ı'na düə g'avxhu, uşax uxasın xhinne qee'e. ");
INSERT INTO tkr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Mana vuxhne ayxu sa dix uxu eyhen: – Allahee zalin pisın do ak'anı'iyn. ");
INSERT INTO tkr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","«Rəbbee zas sayir dix helecenva» uvhu, Raahilee mang'un do Yusuf (Mang'vee sayir helecenva) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raahilee Yusuf uxuyle qiyğa, Yaaq'ubee Lavanık'le eyhen: – Zı g'aykke, hasre yizde ölkeeqa, yizde cigabışeeqa əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Havaasre, zı yizın xhunaşşeriy uşaxar alyapt'ı, əlyhəəs. Zı manbışil-alla vas iş g'avcu. Vak'lecad yugda ats'a, zı vas nimeena iş hav'u vuxhay. ");
INSERT INTO tkr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lavanee mang'uk'le eyhen: – Zı yiğne ulen aqqıxheene, yizde k'ane axve. Falıka ilyakkımee, zak'le Rəbbee zas val-alla xayir-düə huvuy g'acuyn. ");
INSERT INTO tkr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Qiyğa meed eyhen: – Hək' nimeenayiy zak'le eyhe, zı qevles. ");
INSERT INTO tkr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaaq'ubee mang'uk'le eyhen: – Zı vas nəxbiy iş hav'uva, yiğın syurıbıd nimee qeetxhava, vak'lecad ats'an. ");
INSERT INTO tkr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Zı vasqa qalesse, vaqa çavra-vəq'ə k'ıldaniy vod, qiyğalemee xılece geed qıxha. Rəbbe zı vasqa qarıyka vas xayir-düə huvu. Manke zı mısane yizde xizannemee iş haa'as? ");
INSERT INTO tkr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lavanee eyhen: – Vas hucoona heles? Yaaq'ubee eyhen: – Zas vuççud himele. Ğu zas sa kar ha'asva cuvab huveene, zı meer yiğne syurıbışiqa ilyakka. ");
INSERT INTO tkr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hasre g'iyna zı yiğne gırgıne syurıbışde yı'q'neençe ılğeç'u, vəq'əbışdeyiy ts'e'bışde yı'q'neençe k'udananiy xornan vəq'əbıyiy ts'e'bı zas cura'as. Maadın k'aarın urgbıd zı alyaat'asınbı. Manab yizda hək' vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","G'iyniyke şaqa zaqa qopkuna hək'va vasse ilyakkas əxə. K'uda deşde, xor deşde ts'e'ıle ğayrı, k'aarıne urgule ğayrı, mebna vak'le g'avcee, havaasre mana qööqüna xhinnee vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lavanee eyhen: – Hasre ğu eyhen xhinnee ixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Qiyğa Lavaneeme manecad yiğıl k'udananiy xornan (cagvaran cigabınan) q'ınabıyiy ts'e'bı, k'aarın urgbı curı'ı, Yaaq'ubısqa deş, dixbışisqa qele. ");
INSERT INTO tkr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Qiyğa vuc Yaaq'ubıke xhebne yiğee əlyhəəsda yəqmee əq'əna qexhe. Yaaq'ubeeme Lavanın mansa axuyn syuru uxhiyxhan ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaaq'ubee q'avaxın, badamın, çinarın tübəəbı hatq'ur, tübəəbışin q'abıx qişşu, cagvaran xorbı ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Qiyğad q'abıx qişşuyn tübəəbı syurıbışe xhyan ulyoğasde axurbışeeqa, həyvanaaşine ögiylqa giyxhe. Manbı qadı, xhyanbı ulyoğamee, mançis ı'mra abayle vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Mançis tübəəbı gixhxhiyne cigayne ögiyl ı'mra abımee, k'udananiy xornan balabı eyxhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaaq'ubee urgbı cura'anbı. Lavanne syuruneedın vəq'əbıd k'udananeyiy k'aarıne həyvanaaşine suralqa ilyakka'a. Mang'vee cun syuru Lavanne syuriyl alikka'a deş. ");
INSERT INTO tkr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Gucnane həyvanaaşis ı'mra vüqqəmee, Yaaq'ubee axurbışde yı'q'neeqa man tübəəbı giyxhe ıxha, mançis ı'mra tübəəbınane cigayne ögiyl ablecenva. ");
INSERT INTO tkr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Həyvanar zəı'fdanang'a, mang'vee man tübər giyxhe ıxha deş. Məxüd, gucukan həyvanar Yaaq'ubınbı, zəı'fınbıd Lavanınbı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yaaq'ub məxür yiğ-yiğıle geed karnana eyxhe, mang'uqa geed syurıbı, həmbal adameriy həmbal zəiyfabı, devabı, əməler eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaaq'ubık'le Lavanne dixbışe inva eyhe g'ayxhiyn: «Yişde dekkın gırgın kar Yaaq'ubın ıxha. Mang'vee cun gırgın kar yişde dekkıne karake hı'ı». ");
INSERT INTO tkr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaaq'ubık'le Lavan cuka ögilyna xhinnee dexhay g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Rəbbee Yaaq'ubık'le eyhen: – Dekkaaşine cigabışeeqa, vuşde ebanbışisqa sak'le. Zınar vaka ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaaq'ubee insan g'axuvu, Raahileyiy Lea çoleeqa cun syurıbınane cigeeqa qoot'al. ");
INSERT INTO tkr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yaaq'ubee manbışik'le eyhen: – Zak'le vuşda dek zaka ögilyna xhinnee dexhay g'ece. Yizde dekkee ı'bəədat ha'ana Allahmee zaka vor. ");
INSERT INTO tkr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Şok'lecad ats'an, zı vuşde dekkıs vonne gucuka iş hav'iy. ");
INSERT INTO tkr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mang'veeme zas horbı hı'ı, yits'ne yəqqees yizda hək' badal hav'u. Allaheeme mang'usqa zas pisın ha'as hassır deş. ");
INSERT INTO tkr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mang'vee «K'udanan həyvanar yiğna hək' vuxhesva» uvhumee, gırgıne syurununcad k'udanan həyvanar uxu. «Yiğna hək' xornan həyvanar ixhesva» uvhumeeme, syuruneene gırgıne həyvanaaşe xornan həyvanar uxu. ");
INSERT INTO tkr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Məxüd Allahee, vuşde dekkıke çavra-vəq'ə g'ayşu, zasqa quvu. ");
INSERT INTO tkr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","I'mra vüqqəne gahıl zak'le nyak' g'acu: zı vuk'ul ooqa qav'umee, zak'le g'acuyn, ı'mra ablyaa'an q'ınabı xornaniy k'udanan, xalbınanbıvud. ");
INSERT INTO tkr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nik'ek Allahne malaaikın zalqa onuiyn: «Yaaq'ub!» Zı «Hooyvava!» alidghıniy quvu. ");
INSERT INTO tkr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Mang'vee uvhuyn: «Zak'le Lavanee vak hı'iyn g'acuyn. Həşde vuk'ul ooqa qee'e, ilekke, syurunee ı'mra ablyaa'an q'ınabı, xornanbı, k'udananbı, xalbınanbı vod. ");
INSERT INTO tkr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Zı Bet-El vas gyaguna Allah vor. Ğu maa'ab Zasva g'aye givxhu, çilqa q'ış qadğu, Zas k'ınniy g'aysır. Həşde suğotsu, ine cigabışeençe hoora, yedike ıxhane cigabışeeqa sak'le». ");
INSERT INTO tkr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahileeyiy Leayee mang'us alidghıniy qele: – Dekkıne karake şalqa gexhan vodunne? ");
INSERT INTO tkr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mana şaka mebınbışika xhinnee eyxhe. Mang'vee şi massa huvu, şake ıxhayn pılıd əfasaf hı'iyn. ");
INSERT INTO tkr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mançil-allad Allahee yişde dekkıke g'ayşuyn gırgın kar yişiniy yişde uşaxaaşin vod. Həşde ğunad Allahee eyhen gırgın he'e. ");
INSERT INTO tkr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Manke Yaaq'ub oza qıxha, cun uşaxariy xhunaşşer devabışilqa gyaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Gırgın syurud, vucee Paddan-Aramee hı'iyn gırgın karıd alyaat'u, mana Kana'anne cigabışeeqa dekkıne, I'saq'ıne, k'anyaqa yəqqı'l gexha. ");
INSERT INTO tkr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Manbı əlyhəəne gahıl Lavan xaa ıxha deş, mana vəq'əbı qoşşarasva ark'ın ıxha. Raahileeyid dekkıne xaadın byutbı qöqənbı. ");
INSERT INTO tkr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaaq'ubee Aramğançene Lavanıs horbı ha'a, vuc hexvava uvhu deş. ");
INSERT INTO tkr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Məxür mana cun gırgın kar alyaat'u, hexvana. Mana Feratne damayle ılğeç'u, Gileadne suvabınane suralqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yaaq'ubın hixuy Lavanık'le xhebıd'esde yiğıl eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mang'vee cun xınıbı qopt'ul, Yaaq'ubıqa qihna gexha. Yighıd'esde yiğıl Gilead eyhene suvabınane cigee mana avayq'arna. ");
INSERT INTO tkr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Xəmde Allah Aramğançene Lavanıs gyagu, eyhen: – Ğucar ğu aqqe, Yaaq'ubık vuççud hıma'a. ");
INSERT INTO tkr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lavan Yaaq'ubıqa avayq'arna. Yaaq'ubee suvabınane cigee çadır güvxü vuxha. Lavaneeyib cune xınıbışka Gileadne suvabınane cigee çadır giviyxə. ");
INSERT INTO tkr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lavanee Yaaq'ubık'le eyhen: – Ğu in hı'iyn hucoona? Ğu zas horbı hı'ı, yizın yişbıb dəv'ee avquynbı xhinnee quvku. ");
INSERT INTO tkr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nya'a ğu zale dyugulenra hixu? Ğu nya'a man zak'le ittevhu? Zı ğu mə'niybı qədəqqə, şadra dafiy lira ilyviyxəniy yəqqı'l ha'as. ");
INSERT INTO tkr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Zasqa nevabışisiy yişbışis ubba ha'as hassır deş. Ğu ək'el deşiyvalla hav'u. ");
INSERT INTO tkr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Zasse şos qəlasın ha'as əxəyiy. Sanıxha xəmdemee yiğne dekkee ı'bəədat hı'ıne Allahee zak'le uvhuyn: «Ğucar ğu aqqe, Yaaq'ubık vuççud hıma'a». ");
INSERT INTO tkr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Zak'le g'ecen, ğu həşde dekkın xav g'aces üdöörəxəva qığeç'u əlyhəə. Nya'a manke yizın byutbı qöqü qıkkekka? ");
INSERT INTO tkr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaaq'ubee Lavanıs alidghıniy qele: – Zı qərq'ı'n fıkreeqa qadıyn, yiğın yişşar zasse gucuka g'ooşeva. ");
INSERT INTO tkr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yiğın byutbı şavusnee aveykee, mana gik'asda. Xınıbışde ögiyl zasnee yiğın hucoo aveykee, vas aleet'e. Yaaq'ubık'le, Raahilee manbı qöqüva, ats'a deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lavan Yaaq'ubne, Leayne, q'öne həmbal içiyne çadıreeqa ikkeç'u, byutbı aveykı deş. Mana Leayne çadıreençe qığeç'u, Raahileyne çadıreeqa ikkeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raahilee xaan byutbı alyaat'u, deval giviy'arne palanbışeeqa gixhxhı, çil oğa giy'ır yeexhe. Lavan çadıree gırgınəəng'ə ilyakkeeyir, manbı iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raahile dekkık'le eyhen: – Yizda dek, yiğne ögiyl oza qiyxhes deexheva qəl mooxhe, zak yadaaşik eyxhenbı ıxha vod. Mang'vee nəxüd t'abal he'eeyid, byutbı iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaaq'ubıs qəl vuxha, mana Lavanıka cuvabılqa arayle. Mang'vee Lavanık'le eyhen: – Yizda bınahiy taxsir hucoona, ğu zaqar qihna məxür girxhu? ");
INSERT INTO tkr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Gırgıne karaka ilyakkına, yiğın hucoome aveykinne? Aveykiyn kar yizdeyiy yiğne xınıbışde ögiylqa gixhxhe, hasre manbışe eyhecen yişda nenayiy qorkura. ");
INSERT INTO tkr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","G'alle (20) senna zı vas iş hav'u, yiğne ts'e'bışeyiy vəq'əbışe hatt'uyn balabı hı'ı deş. Zı yiğne syuruneençe vəq'əbı deş otxhun. ");
INSERT INTO tkr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ç'alagne həyvanaaşe qodu-sodıyn vəq'əbı zı vasqa adaylenbı deşdiy, mançina hək' zıcabniy vas qoolena. Miç'eebe, exhalee qööqüna həyvan ğu zakeniy qooqqana. ");
INSERT INTO tkr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Yiğıne pıralin, xəmdiyne mık'aalin zakın ha'anniy, zı ulyub gyabaxana deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Zı g'alle senna yiğne xaa axu: yiğne q'öne yişşenemee yıts'ıyoq'vad (14) sen, syurunnemeeyib yixhılle senna zı vas iş hav'u. Ğume yizda hək' yits'ne yəqqee badal hav'una. ");
INSERT INTO tkr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Yizde dekkaaşe, İbrıhımeeyiy I'saq'ee, ı'bəədat hı'ına Allah zaka dexhanaxhiy, həşde ğu zı xıl q'ərarniy yəqqı'l ha'as. Allahık'le yizda əq'üba, yizde xılena zəhmət g'avcuna, Mang'vee sanıxha xəmde Vuc yizde sural ıxhay valqa hixhar hı'iyn. ");
INSERT INTO tkr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lavanee Yaaq'ubıs alidghıniy qele: – Yişbı – yizın yişbı vob, uşaxar – yizın uşaxar vob, syurıbı – yizın syurıbı vod. Ğu hı'iyn gırgın karıd yizın vod. G'iyna zasse yişbışik, manbışe uxooxuyne uşaxaaşik hucoo ha'as əxəyee? ");
INSERT INTO tkr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Qora, həşde zınayiy ğu cuvab g'ats'ak'vanas, manıd yizdeyiy yiğne yı'q'nee şahad ixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yaaq'ubee sa g'aye alyapt'ı, mana dirak xhinne ulyoozar haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Mang'vee cune xınıbışik'le eyhen: – G'aye see'e. Manbışe g'ayebı adı anbareeqa sa'a. Qiyğab mane anbarne k'ane otxhun-ulyoğan. ");
INSERT INTO tkr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lavanee mançin do Yegar-Sahaduta giyxhe, Yaaq'ubeeme mançik'le Gal-Edva eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lavanee eyhen: – İna g'ayeyna anbar yizdeyiy yiğne yı'q'nee şahaadat vobna. Mançil-allad mançin do Gal-Ed vod. ");
INSERT INTO tkr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mançik'le sayıd Mitspavaniy (ilyaakan ciga) eyhe, Lavanee inəxüd uvhuynçil-alla: – Şak'le sana-sanbı g'udyoocemee, havasre Rəbbina ul zalib, valib vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Yik'el aqqe, yizdeyiy yiğne yı'q'nee insan deş, Allah şahad vorna. Zak'le ğu qiyğa g'ıdecveeyir, yizde yişbışika yugra ixhe, manbışil ooqa xhunaşşe himee'e. ");
INSERT INTO tkr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lavanee meed Yaaq'ubık'le eyhen: – İlekke, haane sı'iyn g'ayebıyiy dirak xhinne ulyoozar hav'una g'aye, mana zı yişde yı'q'nee ulyoozar hav'u! ");
INSERT INTO tkr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","İn sı'iyn g'ayebıyiy dirak xhinne ulyoozar hav'una g'aye şahad ixhecen: zı yiğne suralqa, mane sı'iyne g'ayebışde şene aq'valqa pisvalla haa'as ılğeç'es deş. Ğunar zas pisvalla haa'asva mane dirak xhinne ulyoozar hav'uyne g'ayeyneyiy sı'iyne g'ayebışde ine aq'valqa ılğeç'es deş. ");
INSERT INTO tkr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Hasre yişde dekkaaşe: İbrıhımee ı'bəədat ha'ane Allaheeyiy Naxoree ı'bəədat ha'ane allahee şas hökum hevlecen. Yaaq'ubee cune dekkee, I'saq'ee, ı'bəədat ha'ane Allahılqa k'ın g'iysar. ");
INSERT INTO tkr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Qiyğa Yaaq'ubee mane suval q'urban givk'u, xınıbı gıney oxhanas qoot'al. Manbışe gıneybı otxhun, suval xəm g'aaha. ");
INSERT INTO tkr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lavan miç'eer çakra oza qıxha, yişbışisiy nevabışis ubbabı hı'ı, manbışis xayir-düəbı hele. Mançer cune xaaqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaaq'ub cune yəqqı'n ayk'anna. Yəqqə mang'usqa Allahın malaaikar qızaaxa. ");
INSERT INTO tkr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaaq'ubık'le manbı g'acumee, eyhen: – İn Allahna deste ulyobzuriyn ciga vod. Mane cigayn do Maxanayim (deste ulyobzuriyn ciga) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaaq'ubee cule ögiyl Edomne sahreeqa, Seirne cigabışeeqa, cune çocusqa Esavısqa insanar g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Manbışilqa inəxübna əmr haa'a: – Yizde xərıng'uk'le, Esavık'le, eyhe: «Yiğne həmbalee, Yaaq'ubee, inva vod eyhe: „Zı Lavanısnee ıxha, g'iyniyne yiğılqameeyir mang'usne axu. ");
INSERT INTO tkr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Zaqa çavra-vəq'ə, əməler, həmbalar vob. Zı vas, yizde xərıng'us xabar hevlesva, vasqa insanar g'axuvu, vasqa şi yugba qudooracenva“». ");
INSERT INTO tkr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","G'axuvuyn insanar sapk'ıl, Yaaq'ubık'le eyhen: – Şi yiğne çocusqa Esavısqa hapk'ın. Vucur yiğne ögilqava ı'qqə vor, cukasanar yoq'ud vəş (400) insanır. ");
INSERT INTO tkr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaaq'ub mançile qərq'ı'n, mang'un yik' it'umda ı'xiyxə giyğal. Cun insanar, çavra-vəq'ə, devabı q'öne desteeqa curı'ı, ");
INSERT INTO tkr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","eyhen: – Esaviy Esavıkanbı manbışde sanbışilqa k'yophur, manbışikın he'ee, mansanbışisse heepxas vəəxecenva. ");
INSERT INTO tkr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Qiyğa Yaaq'ubee eyhen: – Yizde q'əsde dekkee İbrıhımee ı'bəədat ha'ana Allah, yizde dekkee I'saq'ee ı'bəədat ha'ana Allah! Rəbb, Ğu zak'le uvhuynniy: «Yiğne ölkeeqa, yiğne xınıbışisqa sak'leva. Zı vas yugvalla haa'as». ");
INSERT INTO tkr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ğu zas, Yiğne həmbalıs, hav'une yugvalisiy qopkuvalis zı avaak'ı deş. İordanne damayle ı'lğəəmee, zaqa əsayle ğayrı vuççud deşinniy. Həşdemee zı q'öne desteyka siyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Hucoona ixhes, zı yizde çocune Esavne xılençe g'attixhan he'e. Mana arı, zı, uşaxar, uşaxaaşin yedyar gyabat'ava, qəyq'ənna. ");
INSERT INTO tkr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ğu uvhuyn: «Zı vas yugvalla hidyav'u gyu'aras deş, yiğna nasıl qəpqəs-ələpqəs dyooxhena deryahna g'ummee geeb qaa'as». ");
INSERT INTO tkr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yaaq'ub mane xəmde maa'ar axva. Mang'vee cune çocus Esavıs pay xhinnee ");
INSERT INTO tkr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","q'öd vəş (200) ts'e', g'able (20) q'ına, q'öd vəş vəq'əyiy g'able g'arg, ");
INSERT INTO tkr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","balabışika sacigee xhebts'al (30) gyaazana deva, yoq'ts'al (40) zer, yits'ıble yats, g'able (20) xhuvulyna, yits'ıbleb vughulyna əməle curaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Syurıbı curayda-curayda həmbalaaşisqa ha'aykı'ı, eyhen: – Yizde ögiyl hudoora, syurıbışded yı'q'nee ciga g'aleççe. ");
INSERT INTO tkr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yaaq'ubee ts'erriyne həmbalıs əmr hav'u, eyhen: – Yizda çoc Esav vas qızaxxımee, mang'vee vake qiyghanasın: «Şavna insanne, nyaqane əlyhəə, man həyvanar şavunbıne?» ");
INSERT INTO tkr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Manke ğu mang'uk'le eyhe: «İn həyvanar yiğne həmbalın Yaaq'ubınbı vod. Mang'vee manbı yişde xərıng'us Esavıs pay xhinnee g'ıxele vod. Vucur şaqar qihna qöö vor». ");
INSERT INTO tkr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Qiyğa mang'vee q'ör'esde, xhebır'esde həmbalık'le, syurıbışde qihna əlyhəəne gırgıng'ulqacab əmr hav'u, eyhen: – Esav qızaxxımee, şunad manva eyhe: ");
INSERT INTO tkr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","«Yiğna həmbal Yaaq'ubır qihna qöö vor». Yaaq'ubee culed-alqa eyhe ıxha: «Ts'etta ögiylyne paybışe mang'un yik' g'üvəna qa'as. Qiyğa qızaaxımeeyib, mana mançil-alla sayir zaka yugra eyxhe». ");
INSERT INTO tkr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Paybı Yaaq'ubıle ögiyl ayk'an, vucme mane xəmde çadırbınane cigee axva. ");
INSERT INTO tkr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yaaq'ub xəmde muğur qıxha, q'öyre cuna xhunaşşe, q'öyre həmbal zəiyfa, yits'ıssad (11) cun uşaxıd alyaat'u, Yabboq eyhene aragıle ılğeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mang'vee manbıb, con karıd aragıle alğa'an. ");
INSERT INTO tkr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Qiyğa Yaaq'ub vuccar axva. Miç'eed qıxhesmee, maa'ar Sa Yaaq'ubıka uğodana. ");
INSERT INTO tkr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yaaq'ubıle ğamxhes dəxə g'acu, Mang'vee Yaaq'ubne umays ı'xiyxə. Mançile qiyğa Yaaq'ubın umeençe g'el ığeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yaaq'ubıka Uğodang'vee eyhen: – G'aykke əlyhəəs, miç'eed qexhe. Yaaq'ubee eyhen: – Zas xayir-düə hidevee, zı Ğu g'aykkas deş. ");
INSERT INTO tkr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mang'vee Yaaq'ubıke qiyghanan: – Yiğın do hucoona? Yaaq'ubee eyhen: – Yaaq'ub. ");
INSERT INTO tkr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yaaq'ubıka Uğoduyng'vee eyhen: – Vak'le Yaaq'ubva deş, İzrailyva (mana Allahıka uğoda) eyhes. Ğu Allahıkayiy insanaaşika uğodu, ğamxhana. ");
INSERT INTO tkr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaaq'ubee qiyghanan: – Hucoona ixhes, Yiğın do eyhe. Mang'vee eyhen: – Nya'a ğu Yizın do qiyghan? Mang'vee maa'ab Yaaq'ubıs xayir-düə hoole. ");
INSERT INTO tkr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaaq'ubee mane cigayn do Peniel (Allahın aq'va) gixhxhı, eyhen: – Allah aq'vayle g'acu, üç'ürra axu. ");
INSERT INTO tkr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaaq'ub Penieleençe ı'lğəəmee, verığ ılqooç'e. Mana umayke k'aara iykar ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Mançil-allad g'iyniyne yiğılqamee İzrailybışe umal oodun çuru oyxhan deş. Manbışe məxüd Yaaq'ubıka Uğodana Yaaq'ubne umayne mane cigayk set'uva ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaaq'ubee vuk'ul ooqa qav'umee, Esav yoq'ud vəş (400) insanıka qöö g'ece. Mang'vee Leayn, Raahileyn, q'öne həmbal xhunaşşebışin uşaxar curaa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Q'öyre həmbal xhunaşşeriy manbışin uşaxar ögiylqa qaa'a, Leayiy məng'ı'n uşaxar yı'q'neeqa, Raahileyiy Yusufmee yı'q'əl ulyoozar haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Vucme manbışde ögiylqa ılğeç'e. Çocusqa hiviyxharmee, Yaaq'ub çocune ögiyl ç'iyelqamee yighne yəqqees k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esav Yaaq'ubne ögeeqa g'adarxhun, mana xhılibışeeqa sı'ı, gardanançe givarxın, mang'us ubbabı ha'a. Qiyğa manbı gyaaşenbı. ");
INSERT INTO tkr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esavee vuk'ul ooqa qav'u, xhunaşşebıyiy uşaxar g'avcu, eyhen: – İnbı yiğın vuşbıne? Yaaq'ubee eyhen: – Allahee zas, yiğne həmbalıs, rəhı'm hav'u, huvuyn uşaxar vobunbı. ");
INSERT INTO tkr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ts'eppa həmbal zəiyfabıyiy con uşaxar qeepxha, mang'us k'yoozar. ");
INSERT INTO tkr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Qiyğa Leayiy cen uşaxar qeepxha k'yoozar. Nekke qiyğab Yusufiy Raahile mang'us k'yoozar. ");
INSERT INTO tkr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esavee Yaaq'ubıke qiyghanan: – Şen zasqa ts'etta qızaaxxıyn insanariy çavra-vəq'ə nişisniy g'axuvu? Yaaq'ubee eyhen: – Yizde xərıng'une ulesqa yugra qoracenva. ");
INSERT INTO tkr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esavee eyhen: – Çoc, zaqa xətta kar vod, yiğınbı vas axvecen. ");
INSERT INTO tkr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaaq'ubee eyhen: – De'eş, hucoona ixhes, zı yiğne ulen aqqıxhee, mana pay alept'e. Yiğın aq'va g'acuy zasqa Allahın aq'va g'acuyn xhinnee qadı, ğu zaka yugra ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Hucoona ixhes, zı vas adıyn paybı aleet'e. Allah zaka yugra ıxha, zaqa həşde gırgın vodun. Yaaq'ubee miz k'yav'uyle qiyğa, Esavee paybı alyaat'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esavee eyhen: – Yəq givğalas, zı yizde insanaaşika ögiyl əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaaq'ubee mang'uk'le eyhen: – Yizda xərna, vak'le ats'an uşaxaaşika ark'ıniy dağamda vod. İnyaana çavra-vəq'əb gyaazana vob. Manbı sa yiğnacad zarada ha'aykee, hatt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hucoona ixhes, ğu zale ögee hoora. Zıme vaqar qihna Seirqa hixharasmee, k'ırra-k'ırra, syurıbışisseyiy uşaxaaşisse əlyhəəs vəəxənbı xhinnee qales. ");
INSERT INTO tkr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esavee eyhen: – Zakane insanaaşin sabarabı vaka aaxvas havaasre. Yaaq'ubee eyhen: – Nişisne g'alyaa'a? Yiğne ulen zı aqqiy zas ç'əv. ");
INSERT INTO tkr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esav manecar yiğıl yı'q'əlqa Seirqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaaq'ub Sukkotqa ark'ın, maa'ad cus xaviy həyvanar a'asın yits'abı alya'a. Mançil-allad mane cigayn do Sukkot (yits'abı) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaaq'ub Paddan-Arameençe üç'ürra sark'ıliyle qiyğa, Kana'anne cigabışeene Şekem eyhene şahareeqa qarı, mançine k'ane cusun çadırbı giyxə. ");
INSERT INTO tkr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Mang'vee çadırbı gı'xı'yn ciga Şekemıkeyiy Xamorne menne dixbışike vəşne nuk'rays ileşşe. ");
INSERT INTO tkr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yaaq'ubee maa'ad q'urbanbı allya'an ciga ali'ı, çin doyud El-Elohe-İzrail (Allah İzrailyna Allah vor) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leayee Yaaq'ubıs yuxuna yiş Diina mane ölkayn içer g'avcesva qığeeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mane ölkayne xərıng'une Q'ivbışda eyxhene Xamorne dixek'le Şekemık'le mana g'eece. Mang'vee mana içiy ayqı qiykı, məng'ı'ka g'alirxhu, mana k'ap'ik'ıle avqa qee'e. ");
INSERT INTO tkr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Şekemıs mana içiy yik'eençe yikkiykan, mana Diinayika g'üvənara yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Şekemee dekkık'le Xamoruk'le eyhen: – İna içiy zas hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaaq'ubık'le cuna yiş Diina abır dena qey'ıva g'iyxhen. Dixbı çolee syurıbışisneeva, manbı qavaalesmee mang'vee nıq' qığayhe deş. ");
INSERT INTO tkr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Şekemna dek Xamor Yaaq'ubıka yuşan ha'asva mang'usqa arayle. ");
INSERT INTO tkr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaaq'ubne dixbışik'le man g'ayxhı, aq'vabı qı'ı, çoleençe siviyk'alanbı. Manbı qəlın əvq'ü əə vuxha. Şekem Yaaq'ubne yişşeka g'alirxhu, İzrail k'ap'ik'ıle avqa qaa'a. Məxdın kar ixhes ıkkan deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Xamoree manbışik'le inəxüd eyhe: – Yizde dixes vuşda yiş yik'eençe yikkan. Hucoona ixhes, mana yizde dixes heyle. ");
INSERT INTO tkr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Şaka xınıbı vuxhe: vuşun yişbı şas hevle, yişin yişbıb şos hevles. ");
INSERT INTO tkr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Şaka aaxve, yişda ölka vuşdeb xıle vob. İnyaa aaxve, kar alişşu-massa hele, şoqad kar ixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Şekemee içiyne dekkık'leyiy çocaaşik'le eyhen: – Vuşde ulesqa yugra qoracenva, şu zake hucoo heqqee, zı şos helesın. ");
INSERT INTO tkr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","İçiyl-alla zake geed kar, paybı heqqe, şu uvhuyn zı gırgın helesın. Saccu içiy zas heyle. ");
INSERT INTO tkr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yaaq'ubne dixbışe Şekemısiy mang'une dekkıs Xamorus horbışika cuvab qele, Şekemee cona yiçu Diina abır dena qey'ıva. ");
INSERT INTO tkr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Manbışe eyhen: – Şasse man ha'as dəxə, sunnat hidi'iyne insanıs şasse yiçu heyles deexə. Məxüd he'eene, şi k'ap'ik'ıle avqa qeepxhes. ");
INSERT INTO tkr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Şu eyhençilqa şassee, şu inəxüd he'eene, qavaales vəəxə: vuşun gırgın adamer sunnat hav'u, şina xhinnee qeepxhee, ");
INSERT INTO tkr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","şi yişin içer vuşde adameeşis hoole, vuşun yişbıb şi haa'ayiy. Məxüb şi sa millet eyxheyiy. ");
INSERT INTO tkr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Şu şal k'ırı ilydiyxheene, sunnat devxheene, şi yişda içiy alyart'u, əlyhəəsınbı. ");
INSERT INTO tkr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Manbışe eyhenbı Xamorneyiy cune dixene Şekemne yik'eençe eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mek'vung'vee man hamankecad ha'an, Yaaq'ubna içiy mang'us yik'eençe yikkanva. Şekem dekkıne xaa inekke hı'rmatıkana insan ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Xamoriy mang'una dix Şekem şaharne akkabışisqa qabı, şaharne insanaaşik'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","– Man insanar şaka hambazba vob. Havaasre manbı yişde ölkee avxu, kar alişşu-massa helecen. İne ölkee manbışisdab nimeena vuxhay ciga vobna. Manbışin yişbı yişinbışis, yişinbıb manbışis hoole. ");
INSERT INTO tkr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mane insanaaşe, co, şi eyhençilqa qavaleecenva şak'le in he'evavud eyhe: yişin adamerıb, şenbışin adamer xhinnee, sunnat hav'u vuxhes vukkan. ");
INSERT INTO tkr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mançile qiyğa manbışin syurıbıd, manbışin karıd yişin ixhes. Qudoora, manbışe eyhen ha'as, manbı şaka aaxvecen. ");
INSERT INTO tkr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Şaharne gırgıne milletın Xamorıliy mang'une dixel Şekemıl k'ırı iliyxhen: şaharın gırgın adamer sunnat haa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Xhebıd'esde yiğıl manbışin ık'arbı ç'əvdeetxhacad, Diinayne çocaaşe – Yaaq'ubne q'öne dixee, Şimoneeyiy Leviyee – g'ılıncbı alyaat'u, dağamiyvalla dena şahareeqa ikkeepç'ı, gırgın adamer g'ılıncıke alğaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Xamorur mang'una dix Şekemır gyabat'anbı. Diinar Şekemne xaançe alyart'u, qiykekkana. ");
INSERT INTO tkr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaaq'ubın dixbı hapt'ıynbışde k'anyaqa abı, yiçu k'ap'ik'ıle avqa qey'ıva, şahar q'əra qaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Manbışin çavra-vəq'ə, əməler, şahareeniy çoleedın gırgın kar alyaat'an. ");
INSERT INTO tkr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Manbışin gırgın kar, uşaxar, zəiyfabı avqu, quvkekkanbı, manbışde xaybışeedın gırgın kar qıkkekkan. ");
INSERT INTO tkr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaaq'ubee Şimonuk'leyiy Leviyk'le eyhen: – Mane cigabışee vooxhene Kana'anbışik'leyiy Perizbışik'le zı g'ımece qıxha, şu zalqa ver ablyav'u. Şi, manbışika ilyaakamee, k'ılyba vob. Manbı sabı, şakın he'eene, zakınıd, yizde xizanıkınıd ixhesın. ");
INSERT INTO tkr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Şimoneeyiy Leviyee eyhen: – Nya'a yişde yuçeyka yəqqı'le qığeyç'uyne zəiyfayka xhinnee vuxhes vooxheyee? ");
INSERT INTO tkr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Allahee Yaaq'ubık'le eyhen: – Ğu Esavne xılençe hexvamee, vas Bet-Elee Allah gyagu. Həşde oza qıxha, maqa hoora, maayir axve. Maa'ad Allahıs q'urbanbı allya'an ciga ale'e. ");
INSERT INTO tkr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaaq'ubee xizanık'leyiy cokane gırgınbışik'le eyhen: – Şosneedın gırgın byutbı dağe'e, mətteepxha, tanalinbı badal he'e. ");
INSERT INTO tkr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Oza qeepxha Bet-Elyqa vüqqəs. Zı Allahıs maa'ad q'urbanbı allya'an ciga alya'as. Mang'vee yizde vuk'lel yiğ höömee, zas alidghıniy quvu, zı nyaa ixhiy, Mana zaka ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Manbışe cosneedın byutbıyiy k'ırıbışilin tenebı Yaaq'ubısqa qele. Yaaq'ubee manbı Şekemne k'anene mı'qəq avud k'eyxha. ");
INSERT INTO tkr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Manbı yəqqı'lqa qığeebaç'e. Allahee hiqiy-allane şaharbışin insanar it'umba qəvəəq'ən haa'a. Manbı mançil-allab Yaaq'ubne xizanıqab qihna gyabak'a deş. ");
INSERT INTO tkr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaaq'ubiy cukan gırgın insanar Kana'anne cigabışeene Luzqa (mana Bet-El vob) qabayle. ");
INSERT INTO tkr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yaaq'ubee maa'ad q'urbanbı allya'an ciga ali'ı, mane cigayn doyud El-Bet-El (Bet-Elyna Allah) giyxhe. Çocune xılençe hexvamee, Allahee Vuc maa'arniy Yaaq'ubık'le hagu. ");
INSERT INTO tkr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rivq'a geeq'vey'ına Debora qeek'ana. Mana Bet-Elyne k'anekne mı'qəne avur k'eexha. Mane cigayn doyud Allon-Bakut (k'ane g'yaaşena mı'q) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaaq'ub Paddan-Arameençe siyk'alang'a, Allah mang'us gyagu, xayir-düə huvu, ");
INSERT INTO tkr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","eyhen: – Yiğın do Yaaq'ub vodun. Həşdiyle valqa Yaaq'ubva ona'as deş. G'iyniyke şaqa yiğın do İzrail (mana Allahıka uğoda) ixhes. İnəxüd mang'un do İzrail eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Qiyğa Allahee mang'uk'le eyhen: – Gırgın əxəna Allah Zı vorna. Ğunab yiğna nasıl hexxee'e, geeb qee'e. Vake sa millet deş, geedın milletbı g'ales. Yiğne nasıleab paççaharıb vuxhesınbı. ");
INSERT INTO tkr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","İbrıhımısiy I'saq'ıs huvuyn ç'iyebı Zı vasıd helesınbı. Valed qiyğa yiğne nasılıs heles. ");
INSERT INTO tkr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Allah Yaaq'ubne k'anençe – yuşana'ane cigeençe ooqa ts'ıts'axhxhe. ");
INSERT INTO tkr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaaq'ubee Allah cuka yuşan hı'iyne cigee sa g'aye ulyoozaraa'a. Qiyğad Allahne doyule çilqa zeytunun q'ışiy kya'an k'yı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaaq'ubee Allah cuka yuşan hı'iyne cigayn do Bet-El (Allahın xav) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yaaq'ubiy cuna xizan Bet-Eleençe avayk'ananbı. Efratısqa hiviyxharang'a Raahileys uşax eyxhe. Uxooxang'a məng'ee xəppa k'ov ts'ıts'av'u. Məng'ı'n uxuy dağamda ılğeç'e. ");
INSERT INTO tkr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Məng'ee k'ov ts'ıts'a'ane, uxooxane gahıl kumag ha'ane xhunaşşee eyhen: – Qimeeq'ən, vas meer dix ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mana qeek'aniy vor, dixes Ben-Oni (yizde uts'urna dix) do giyxheng'a. Qiyğa dekkeeme mang'un do badal hı'ı Benyamin (sağne xılena dix) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raahile qeek'ana. Efratne (Bet-Lexemne) yəqqə mana k'eyxhı. ");
INSERT INTO tkr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaaq'ubee Raahileyne nyuq'vnelqa sa g'aye giviyxhe. Mana g'aye g'iyniyne yiğılqamee Raahileyne nyuq'vnel guts xhinne avxuna. ");
INSERT INTO tkr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","İzrail mançe ark'ın, Migdal-Ederne şene aq'val çadır güvxü. ");
INSERT INTO tkr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","İzrail maa'ar axvang'a, Ruven dekkıne həmbal zəiyfayka Bilyhayka g'ılexha. İzrailik'le man ats'axhxhen. Yaaq'ubıqa yits'ıq'vər (12) dixniy vor. ");
INSERT INTO tkr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Manbı Leaye vuxuynbıniy vob: Yaaq'ubna ts'erriyna dix Ruven, qihnanbıb Şimon, Levi, Yahud, İssaxariy Zevulun vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","İnbıb Raahilee vuxuynbıniy vob: Yusuf, Benyamin. ");
INSERT INTO tkr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","İnsabıme Raahileyne nukaree Bilyhanee vuxuynbıniy vob: Dani, Naftali. ");
INSERT INTO tkr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leayeyne nukaree Zilypaneeyib inbıniy vuxu: Qad, Aşer. Yaaq'ubıs Paddan-Aramee vuxhayn dixbı inbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaaq'ub Mamreeqa Qiryat-Arbenne (Xevronne) k'anyaqa, dekkıne I'saq'ne k'anyaqa qarayle. İbrıhımiy I'saq' Mamreab menne cigaynbı xhinne vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","I'saq'ee vəşşe molyts'al (180) sen hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Mana ine dyunyeyle ats'ı, q'əs qıxha qek'a. Məxür mana ahaleeqa ayk'an. Mana dixbışe Esaveeyiy Yaaq'ubee k'eyxha. ");
INSERT INTO tkr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esavın (mang'uk'le Edomvad eyhenniy) nasılın taarix inəxüd vod. ");
INSERT INTO tkr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esavee Kana'anne içeeşike q'öyre hee'e: Q'etbışda eyxhena Elonna yiş Ada, Q'ivbışda eyxhena Tsiveonna neva Anahna yiş Oholivama. ");
INSERT INTO tkr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Sayir mang'vee I'smı'ı'lyna yiş, Nevayotna yiçu yeexhena, Basmat hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adee Esavıs Elifaz uxooxa, Basmateeme Reuel uxooxa. ");
INSERT INTO tkr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholivamee Yeuş, Yalamiy Qorax uxooxa. Esavıs Kana'anne cigabışee vuxhayn dixbı inbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esavee xhunaşşebı, dixbı, yişbı, cune xaabın gırgınbı, syurıbı, gırgın həyvanar, Kana'anne cigabışee hı'iyn gırgın kar alyaat'u, çocune Yaaq'ubne k'anençe menne cigabışeeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Manbışiqa kar geedva manbışisse sacigee aaxvas vəəxə deş, syurıbı geedva mane cigabışee manbı oohar deş. ");
INSERT INTO tkr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esav (mang'un medın do Edom) Seirne suvabınane cigee axva. ");
INSERT INTO tkr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Edombışda dek eyxhene Esavın Seirne suvabınane cigabışee axvang'an taarix inəxüd vod. ");
INSERT INTO tkr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esavne dixbışin dobı inbı vod: Esavne xhunaşşeyna Adayna dix Elifaz, Esavne xhunaşşeyna Basmatna dix Reuel. ");
INSERT INTO tkr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazın dixbı: Teman, Omar, Tsefo, Gatam, Qenaz. ");
INSERT INTO tkr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna Elifazna həmbal zəiyfa yixha. Məng'ee Elifazıs Amalek uxooxa. Esavne xhunaşşeyn Adayn nevabı inbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuelin dixbı inbı vob: Naxat, Zerax, Şamma, Mizza, manbı Esavne xhunaşşeyn Basmatın nevabı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esavne xhunaşşeyn Oholivamanın (mana Tsiveonna neva, Anahna yiş yixha) dixbı inbı vob: məng'ee Esavıs Yeuş, Yalam, Qorax vuxooxa. ");
INSERT INTO tkr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esavıke g'abıynbışin ç'ak'ınbı inbı vob. Esavne ts'erriyne dixen Elifazıke g'abıynbı: xərna Teman, xərna Omar, xərna Tsefo, xərna Qenaz, ");
INSERT INTO tkr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","xərna Qorax, xərna Gatam, xərna Amalek. Edomne cigabışee Elifazıke vuxhayn ç'ak'ınbı inbı vob. Manbı Adayn nevabı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esavne dixen Reuelike g'abıynbı vob: xərna Naxat, xərna Zerax, xərna Şamma, xərna Mizza. Edomne cigabışee Reuelike vuxhayn ç'ak'ınbı inbı vob. Manbı Esavne xhunaşşeyn Basmatın nevabı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esavne xhunaşşee Oholivamee vuxuynbı inbı vob: xərna Yeuş, xərna Yalam, xərna Qorax. Manbı Esavne xhunaşşeyn Anahne yişşen Oholivamanne nasıleençen ç'ak'ınbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","İnbı Esavın (mang'un medın do Edom) dixbı vob, manbıb mang'uke g'abıynbışin ç'ak'ınbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Mane cigabışee vooxhene Seirın (mana Xorbışda eyxhe) dixbı inbı vob: Lotan, Şoval, Tsiveon, Anah, ");
INSERT INTO tkr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dişon, Etser, Dişan. Edomne cigabışee Xorbışis xəbvalla haa'an Seirın dixbı inbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanayn dixbı: Xori, Hemam. Lotanna yiçu Timna yixha. ");
INSERT INTO tkr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Şovalın dixbı inbı vob: Alvan, Manaxat, Eval, Şefo, Onam. ");
INSERT INTO tkr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Tsiveonun dixbı inbı vob: Ayya, Anah. Dekkın Tsiveonun əməler uxhiyxhanang'a, ç'iyek avğançe g'ümən xhyan ı'lqəən cigabı aveykına Anah mana vor. ");
INSERT INTO tkr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anahın uşaxar inbı vob: Dişoniy Anahna yiş Oholivama. ");
INSERT INTO tkr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dişonun dixbı inbı vob: Xemdan, Eşban, İtran, Keran. ");
INSERT INTO tkr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Etserin dixbı inbı vob: Bilhan, Zaavan, Aqan. ");
INSERT INTO tkr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dişanın dixbı inbı vob: Utsiy Aran. ");
INSERT INTO tkr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Xorbışiken ç'ak'ınbı inbı vob: xərna Lotan, xərna Şoval, xərna Tsiveon, xərna Anah, ");
INSERT INTO tkr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","xərna Dişon, xərna Etser, xərna Dişan. Seirne cigabışeene nasılbışis sik'ı Xorbışin ç'ak'ınbı manbı vob. ");
INSERT INTO tkr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","İzrailee paççahar vuxhesse, Edomne cigabışee paççahiyvalla hav'uynbı inbı vob: ");
INSERT INTO tkr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Edomna paççah Beorna dix Bela. Mang'une şaharın do Dinhaba ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela qek'ana, mang'une cigeeqa Botsreençene Zeraxna dix Yovav paççah eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yovav qek'ana, mang'une cigeeqa Temanbışde cigabışeençena Xuşam paççah eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Xuşam qek'ana, mang'une cigee Moavne cigabışee Midyanbı gyapxına Bedadna dix Hadad paççah eyxhe. Mang'une şaharın do Avit ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad qek'ana, mang'une cigee Masreka eyhene şahareençena Şamla paççah eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Şamla qek'ana, mang'une cigee damayne k'anene Rexovot eyhene şahareençena Şaul paççah eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Şaul qek'ana, mang'une cigee Akborna dix Baal-Xanan paççah eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Xanan qek'ana, mang'une cigee Hadar paççah eyxhe. Mang'une şaharın do Pau ıxha. Mang'une xhunaşşeyn do Mehetavel ıxha. Mana Matredna yiş, Mezahavna neva yixha. ");
INSERT INTO tkr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esavne nasıleençene ç'ak'ınbışin nasılbışisiy cigabışis sik'ı dobı inbı vod: xərna Timna, xərna Alva, xərna Yetet, ");
INSERT INTO tkr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","xərna Oholivama, xərna Ela, xərna Pinon, ");
INSERT INTO tkr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","xərna Qenaz, xərna Temam, xərna Mivtsar, ");
INSERT INTO tkr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","xərna Magdiel, xərna İram. Cone ölkee, co vooxhene cigabışee, cigabışis sik'ı Edomun ç'ak'ınbı inbı vob. Esavır Edombışda dek eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaaq'ub Kana'anne ölkee axva. Mang'ule ögiylir mang'una dek, maa'ar menne ölkeençe qarına xhinne axva ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yaaq'ubıke g'abıynbışin taarix inəxüd vod: Yaaq'ubna dix Yusuf yits'ıyighad (17) sennana cehilyniy vor. Mang'vee dekkıne xhunaşşebışde Bilyhanneyiy Zilypanne dixbışika syuruniy uxhiyxhan ha'a. Yusufee manbışe qotkuda hidya'an işbı dekkısniy hixhara'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yusuf dekkıne q'əsvalee uxuva, İzrailis (Yaaq'ub) mana gırgıne dixbışile geerniy ıkkiykan. Mang'vee Yusufus geed rangbınan tanalin iyxhva'a. ");
INSERT INTO tkr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Çocaaşik'le dekkıs Yusuf manbışile geer ıkkan g'acumee, mana manbışis g'ımece qexhe. Mançil-allab mang'uka kara'əəba yuşan haa'as vukkiykan deş. ");
INSERT INTO tkr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufuk'le sa nyak' g'ece. Mang'vee man nyak' çocaaşis yuşana'a. Mançile qiyğa çocaaşis mana sık'ırrar g'ımece qıxha. ");
INSERT INTO tkr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusufee manbışik'le eyhen: – Zak'le g'acuyne nyak'ıl k'ırı gyaqqe! ");
INSERT INTO tkr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Şi çolune yı'q'nee alafniy iyt'al. Sayid sayangada yizın alaf suğotsu qotkuda ulyozzuriyn, vuşunbud yizınçine hiqiy-alla sadı, mançine ögiyl vuk'ul avqa qav'u. ");
INSERT INTO tkr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Çocaaşe mang'uk'le eyhen: – Hək'erane, ğu şas paççahne ixhes, xəbvallane haa'as? Cun nyak'bı məxüd yuşan hı'il-alla, mana sık'ırrar g'ımece qexhe. ");
INSERT INTO tkr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusufuk'le sa medın nyak' g'ece, man çocaaşis yuşan hı'ı eyhen: – Zak'le meed nyak' g'acu, k'ırı gyaqqe! Verığ, vaz, yits'ısable (11) xəne yizde ögiyl k'yoyzariy. ");
INSERT INTO tkr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mang'vee nyak' dekkısiy çocaaşis yuşana'ang'a, dek mang'uqa aldarxhun eyhen: – Man vak'le g'acuyn nyak' hucoova eyhenne? Hək'ebane, zınar, yedir, yits'ıssayre (11) çocur abı, yiğne ögiyl ç'iyelqamee k'yoozaras? ");
INSERT INTO tkr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Dekkee Yusufee uvhuyn in cuvab yik'el aqqaqqan, çocaaşemee man höödəxə deş. ");
INSERT INTO tkr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Yiğbışde sa yiğıl Yusufun çocar Şekem eyhene şaharne suralqa dekkın syuru uxhiyxhana'as hapk'ıning'a, ");
INSERT INTO tkr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","İzrailee cune dixek'le Yusufuk'le eyhen: – Çocaaşe Şekemne sural syuru vodun uxhiyxhan ha'a. Qora ğunar manbışisqa yəqqı'l ha'as. Yusufee dekkık'le eyhen: – Nya'a ı'qdə? ");
INSERT INTO tkr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Dekke mang'uk'le meed eyhen: – Hak'ne ilekke, çocar yugbaye, syuru üç'üddaye? Qiyğab zas sa xabar able. Mana məxür Xevronne q'adaalile Şekemqa yəqqı'l ha'ana. ");
INSERT INTO tkr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Mang'vee çocar çolee t'abal ha'ang'a, mang'usqa maa'ar sa insan qızaxxa. Mane insanee mang'uke qiyghanan: – Hucoone t'abal ha'a? ");
INSERT INTO tkr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Mang'vee eyhen: – Zı çocar t'abal haa'a. Hucoone ixhes, zak'le eyhelan, manbışe syuru nyaadiy uxhiyxhan ha'a? ");
INSERT INTO tkr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mane insanee eyhen: – İnençe apk'ıniynbı. Zak'le manbışike «Dotan eyhene şaharne suralqa vüqqəsva» g'ayxhı. Yusuf ayk'anna çocaaşiqar qihna. Mang'usqa manbı Dotanee gyabak'a. ");
INSERT INTO tkr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Çocaaşik'le mana əq'ənançe qöö g'ecena. Yusuf hixharasse, çocaaşe mana gik'asva q'arar hoole. ");
INSERT INTO tkr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Manbışe sana-sang'uk'le eyhen: – Haane, nyak'bı g'ecena qöövur! ");
INSERT INTO tkr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Qudoora mana xhyan sa'ane k'oraleeqa g'uvoxharas. Qiyğad, mana çolane həyvanaaşe qoduva eyhes. Manked g'ece, nen eyhenbıyiy mang'un nyak'bı. ");
INSERT INTO tkr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Man xərne çocuk'le Ruvenık'le g'ayxhımee, Yusuf manbışde xılençe g'attixhana'asdemee eyhen: – Qudoora mana gidek'as, ");
INSERT INTO tkr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","eb k'idyaa'as, vuşucar deşde cigee sa qeqquyne k'oraleeqa g'uvoxharas, hooracen, saccu mang'uk sumoot'a. Mang'us ıkkiykanan, Yusuf çocaaşine xılençe g'attixhan hı'ı, dekkısqa qıkkees. ");
INSERT INTO tkr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusuf çocaaşisqa hirxhılymee, çocaaşe mang'une tanalin şen rangbınan kar ts'ıts'ı'ı g'eşşen. ");
INSERT INTO tkr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Vucur xhyan deşde k'oraleeqa g'uvoyxhar. ");
INSERT INTO tkr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Çocar kar oxhanas giv'uring'a, Gilead eyhene cigeençe qöön I'smı'ı'lybışin karvan g'ece. Manbışe devabışilqa alixhxhı ədviyatbı, balyzam, ətriyatbı əlyhəəyiy man karbı Misirqa ıkkees. ");
INSERT INTO tkr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yahudee çocaaşik'le eyhen: – Şi çoc gik'u, man dyugul he'ee, şas mançike hucoone hixharas? ");
INSERT INTO tkr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Qudoora mang'uk sidyoot'as I'smı'ı'lybışis massa heles. Nəxürcar mana yişda çoc eyxhe, şi sa ebanbı vob. Çocaaşe mang'une cuvabıl k'ırı iliyxhen. ");
INSERT INTO tkr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Maqa şen Midiyanğançe qöön kar massa helenbı hipxhırmee, çocaaşe Yusuf k'oraleençe alqavhu, I'smı'ı'lybışis g'ane (20) nuk'rays massa hele. Manbışer Yusuf Misirqa qıkkekka. ");
INSERT INTO tkr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruven k'oraalisqa sark'ılymee, g'ecen, Yusuf maa'ar deşur. Çoc maa'ar g'ıdecesse, mang'uk divan qitxhu cun tanalin qıt'axxa. ");
INSERT INTO tkr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Qiyğa mana çocaaşisqa sak'ı eyhen: – Gade şaa'ar deşor, həşde zı hucoone ha'as? ");
INSERT INTO tkr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Manbışe Yusufun tanalinbıd alyaat'u, q'ına givk'u, eb ülyööq'ə. ");
INSERT INTO tkr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Qiyğale çocaaşe man rangbınan tanalin dekkısqa adı eyhen: – Şak'le in avaykı. İlekkelan, man tanalin yiğne dixene, deşxhee, dişeene? ");
INSERT INTO tkr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Dekkık'le tanalinbı qıvaats'ı, eyhen: – İn tanalinbı yizde dixenbıvud! Mana bahalne həyvanın orxhun ixhes! Hək'erar Yusuf qodu-soduvur! ");
INSERT INTO tkr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaaq'ubee cune tanalinbı qıt'axxı, culqa palanbı alya'a. Mana dixeqa geer geşşu. ");
INSERT INTO tkr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Gırgın dixbı, yişbı mang'us yik'bı heles savayle. Mang'us manbışil k'ırı alixhxhes diykkın, eyhen: – Zı ahaleeqa dixına ak' avqu əlyhəəs. Mana dixıqa məxür geer geşşu. ");
INSERT INTO tkr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mane Midiyanaşeer, Yusuf Misirne fironne g'aravulyçeeşine xərıng'us Potifarıs massa hele. ");
INSERT INTO tkr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mane gahıl Yahuda çocaaşike curxha, Xira donane Adullamğançene sa insanne k'anyaqa hark'ın, maa'ar axva. ");
INSERT INTO tkr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yahudayk'le maa'ar Şua donane Kana'anbışde sa adamiyna yiş g'eece. Yahudee mana hey'ı, məng'ı'ka g'ılexha. ");
INSERT INTO tkr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mana zəiyfa vuxhne ayxu, sa dix uxooxa, Yahudee mang'un do Er giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Zəiyfa meer vuxhne ayxu, dix uxooxa, doyud Onan giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Qiyğa meer dix uxu, do Şela giyxhe. Zəiyfee mana uxooxang'a, Yahuda Keziv eyhene şaharee ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahudee ts'erriyne dixes Erıs xhunaşşe hee'e, məng'ı'n do Tamar ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yahudayna ts'erriyna dix Er Rəbbinemee karaı'dəəna insan ıxha. Mançil-allar Rəbbee mana gek'ana. ");
INSERT INTO tkr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yahudee Onanık'le eyhen: – Çocune xhunaşşeyka g'alixhe. Yiğın g'aynivalin şib qele, çocunemee nasıl hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onanık'le ats'anniy, mana nasıl cuna devxhesva. Mançil-allar mana çocune xhunaşşeyka g'alirxhumee, toxum mıgleqqa k'yaa'a vuxha, çocus nasıl hidyaa'asva. ");
INSERT INTO tkr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mang'vee haa'ana iş Rəbbine ulesqa yugba qidyabı, Rəbbee manar gek'ana. ");
INSERT INTO tkr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yahudee cune sossak'le Tamarık'le eyhen: – Yeera dekkıne xaaqa sip'ıriy xhinne sayk'le. Yizda dix Şela xər qıxhesmee, adamiys imeek'an. Yahuda qəyq'ən ıxha, Şelar cun, çocar xhinnee, qek'ava. Tamar ark'ın, dekkıne xaa eexva. ");
INSERT INTO tkr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Xılece gahbışile qiyğa Şuayna yiş yeexhena Yahudayna xhunaşşe qeek'ana. Yahuda yas ç'əvuvxhayle qiyğa, cune hambazıka Adullameençene Xirayka sacigee Timna eyhene cigeeqa syurıbı qoyşaranbışisqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamarık'le eyhen: – Yiğna abattey syurıbı qoşşaras Timneeqa vor ı'qqə. ");
INSERT INTO tkr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamaree sip'ıreeşe alya'an karbı g'ayşu, yic qıvmeets'ecenva şal adaççe. Mana Timneeqa əlyhəəne yəqqəne, Enayimeeqa ı'kkəəne akkabışde ögee giy'ar. Məng'ı'k'le g'ecen Şela xər qıxha vor, yic mang'us adamiys heele deşur. ");
INSERT INTO tkr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yahudayk'le mana g'aycumee, mang'uk'le mana yəqqı'le qığeyç'una zəiyfa xhinnee yeets'a yeexhe, məng'ee aq'va dyugul hı'ıva. ");
INSERT INTO tkr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda məng'ı'ne suralqana ark'ın, eyhen: – Hasre vaka g'alixhas. Mang'uk'le mana cuna sos yixhay yeets'a deşdiy. Zəiyfee eyhen: – Zaka g'alixhasdemee ğu zas hucoona heles? ");
INSERT INTO tkr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahudee eyhen: – Syuruneençe sa mısva g'axuvles. Məng'ee eyhen: – Mana g'axuvlesmee zasne sa kar g'alyadaççeye? ");
INSERT INTO tkr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yahudee qiyghanan: – Zı vas hucoona g'aleççe? Zəiyfee eyhen: – Baağılin yiğın peçatiy xıledın əsaa. Yahudee manbı zəiyfaysqa quvu, məng'ı'sqa ikkeç'e. Zəiyfa mang'uke vuxhne eexva. ");
INSERT INTO tkr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Qiyğa Tamar mançe iyeek'anna. Məng'ee şal g'ayşu, sip'ıreeşe alya'an, tanalinbı alya'a. ");
INSERT INTO tkr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yahudee zəiyfayke vucee g'aletçuyn kar alyaat'asva, Adullamğançene hambazıka mısva g'uxoole. Mang'uk'le mana zəiyfa iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Mang'vee zəiyfa ulyorzulyne cigayne insanaaşike qiyghanan: – Enayimıs k'anene yəqqə giy'ırna yəqqı'le qığeyç'una zəiyfa nyaane vor? Manbışe eyhen: – İnyaa yəqqı'le qığeyç'una zəiyfa deşda. ");
INSERT INTO tkr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Mana insan Yahudayne k'anyaqa sark'ıl eyhen: – Zak'le mana aveykı deş. Mane cigayne insanaaşed «inyaa yəqqı'le qığeyç'una zəiyfa deşdava» uvhu. ");
INSERT INTO tkr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahudee eyhen: – Hasre man karbı məng'ı'nbı ixhecen, saccu şi mane işee k'ap'ik'ıle avqa qıdeepxhes. İna mısva zı məng'ı'sniy g'axuvu, vak'leme mana aveykı deş. ");
INSERT INTO tkr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mançile xheyible vazna qiyğa Yahudayk'le eyhen: – Yiğne sossee Tamaree zina hı'ı, vuxhne ayxu. Yahudee eyhen: – Mana qığeyhı, geexhvan hee'e. ");
INSERT INTO tkr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Mana g'aqa qığeyhımee, məng'ee abatteysqa insan g'axuvu, eyhen: – Zı ine karbışde iyesiyke vuxhne ayxu. Qiyğa eyhen: – İlekkelan in baağılin peçatiy əsaa şavuniy? ");
INSERT INTO tkr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahudayk'le manbı qıvaats'ı, eyhen: – Mana zale qorkura vor, zı mana yizde dixes Şelays hidey'ıva. Yahuda məng'ı'ka sayır g'ılexha deş. ");
INSERT INTO tkr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamaree uxooxamee, məng'ı'ne vuxhne q'ömkaler vuxhay ats'axhxhe. ");
INSERT INTO tkr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Uxooxane gahıl uşaxaaşine sang'vee xıl hozar ha'a. Uşaxar vuxooxang'a, kumag ha'ane zəiyfee mang'une mane xılelqa ç'ərana baağ avt'ul eyhen: – Ts'erree ina g'acu. ");
INSERT INTO tkr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mane uşaxeeme xıl yı'q'əlqa ts'ıts'a'a, ts'erre manasa eyxhe. Kumag ha'ane zəiyfee eyhen: – Nəxürne ğu mançe ılğeç'u? Mançil-allad mang'un do Perets (ılğeç'ena) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mang'ule qiyğa xılel baağnana çoc eyxhe. Mang'un do Zerax (ı'lqəəna verığ) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yusuf Misirqa qıkkı. Fironne g'aravulyçeeşine xərıng'vee, Misirğançene Potifaree mana I'smı'ı'lybışike ileşşena. ");
INSERT INTO tkr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Rəbb Yusufukaniy vor, mana gırgın kar uftanda ha'as həsilexhenaniy. Yusuf Misirğançene xərıng'une xaaniy axvana. ");
INSERT INTO tkr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mang'une xərıng'uk'le g'ecen, Rəbb mang'ukavur, mang'vee gırgın işbı uftanda həsilya'avud. ");
INSERT INTO tkr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusuf xərıng'une ulesqa yugra qarı, mang'uke xərıng'vee cusdacar nukar ha'a. Xərıng'vee Yusufuke cun xav vuk'lek ıkkekana hı'ı, cun gırgın karıd mang'une xıleqa quvu. ");
INSERT INTO tkr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mang'vee Yusufne xıleqa xaanayiy karana xəbvalla quvuyle qiyğa, Rəbbee Yusuful-alla Misirğançeng'une xaas barakat hoole. Potifarne xaa, çolee, gırgıne karee Rəbbina barakat g'ooce giviyğal. ");
INSERT INTO tkr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Mang'vee cun gırgın kar Yusufne xılyaqa qele, mang'une vuk'lee otxhun-ulyodğuyle ğayrı, medın vuççud eyxhe deş. Yusuf tanaler, aq'vayler micagra ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sabara gah ılğevç'uyle qiyğa, xərıng'une xhunaşşeyna Yusufulqa ul gipxhı, eyhen: – Qora zaka g'alixhe. ");
INSERT INTO tkr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","9","Yusufus man ha'as ıkkiykan deş. Mang'vee məng'ı'k'le eyhen: – Zı inyaanang'a xərıng'uk'le cune xaa hucoo ıxhay, nen ıxhay ats'a deş. Zı həşde ine xaa xərna eyxhe. Yizde xərıng'vee cune xaadın gırgın kar vale ğayrı yizde xıleqa quvu. Saccu ğu, cuna xhunaşşeva, qideele. Zı nəxüdne məxdun qəlasın he'e? Man he'ee Allahne ögeyir xənne bınahee k'eyxhas! ");
INSERT INTO tkr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Məng'ee man yiğıs Yusufuk'le eyhe ıxha, Yusufusmee məng'ı'ka ixhesır, g'alixhasır ıkkan deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Yusuf sa yiğıl cune işiqar qihna xaaqa ikkeç'e. Xaane insanaaşike ar vuşucar ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Məng'ee mana tanalinçike aqqı «Zaka g'alixheva!» eyhe. Yusufee tanalinbı məng'ı'ne xıle g'ali'ı g'aqa hexva. ");
INSERT INTO tkr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Zəiyfayk'le g'acuyng'a, Yusufee tanalinbı cene xılevud g'ali'ı hixu, ");
INSERT INTO tkr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","məng'ee xaane insanaaşilqa onu'u eyhen: – İlyaake, vuşde xərıng'vee şi tesser hee'ecenva cühüt' şasqa arı! Mana zaka g'alixhasva zasqa qarı, zımee xəbna ts'ir hav'u! ");
INSERT INTO tkr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Yizda ts'ir g'avxhumee, mang'vee tanalinbı g'ali'ı g'aqa hixu! ");
INSERT INTO tkr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potifar xaaqa sak'alasmee, məng'ee Yusufun tanalinbı cesne havace. ");
INSERT INTO tkr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Məng'ee adamiysıd akaran karbı yuşanı'ı, eyhen: – Ğu inyaqa arıyne nukar cühüt'ee, zı tesser he'esva zasqa ikkeç'u, ");
INSERT INTO tkr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","zı manke k'arats'ana ts'ir hav'u! Ts'ir g'avxhu, mana tanalinbıd g'ali'ı, g'aqa hixu. ");
INSERT INTO tkr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yusufne xərıng'uk'le xhunaşşeyn «yiğne nukaree zak in hı'ı» cuvab g'ayxhesse, mang'us k'yabaylena. ");
INSERT INTO tkr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yusuf aqqı zindaneeqa, paççahın avquynbı havaacene cigeeqa qele. ");
INSERT INTO tkr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Rəbb Yusufukaniy vor. Yusufus Rəbbee yugvalla haa'a: zindanne xərıng'une ulesqa mana yugra qarayle. ");
INSERT INTO tkr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Zindanne xərıng'vee zindanee avquyn gırgınbı Yusufne xılyaqa qoole. Maa'ad ha'ane gırgıne işbışis Yusufeniy xəbvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yusufusqa quvuyne işbışde nençikacar zindanna xərna ilyakkana deşdiy. Rəbb cukava, Yusuf gırgın işbı uftanda ha'as həsilexhenaniy. ");
INSERT INTO tkr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Sabara gah ılğevç'uyle qiyğa, Misirne paççahne insanaaşe, ulyoğan helenbışde xərıng'veeyiy gıney qecenbışde xərıng'vee paççah qəllamişxhesın kar ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Manbı avqu g'aravulyçeeşine xərıng'une xaane, Yusuf aqqıne zindaneeqa qoole. ");
INSERT INTO tkr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","G'aravulyçeeşine xərıng'vee manbı qoolenbı Yusufusqa, Yusufee manbışis k'ılyvalla hee'ecenva. Misirne paççahna ulyoğan helenayiy gıney qecena sabara gahna zindanee avxuyle qiyğa, ");
INSERT INTO tkr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","sa xəmde manbışik'le curayn-curayn mə'nabınan nyak'bı g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusuf miç'eer manbışisqa qarımee, manbışe aq'vabı havaxanı'ı g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yusufee cuka sacigee xərıng'une xaa, zindanee havaacene fironne insanaaşike qidghın ha'an: – Nya'a g'iyna aq'vabı havaxanı'ı? ");
INSERT INTO tkr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Manbışe mang'uk'le eyhen: – Nyak' g'acu, man nyak' nen eyheniy, eyhes əxəna deşur. Yusufee manbışik'le eyhen: – Nya'a Allahee dişde ats'al hele, nyak' hucoova eyheniyva eyhesın? Hinnalan, man zas yuşan he'e. ");
INSERT INTO tkr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ulyoğan helenbışde xərıng'vee cun nyak' yuşan hı'ı eyhen: – Zak'le nik'ek yizde ögee t'ımılena tayang g'avcu. ");
INSERT INTO tkr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Mane t'ımılene tayangıl xheyible tübəəyiy. T'ur qı'ğəə-qı'ğəə mançin t'et' g'avhu, t'ımıl aleyli'ı. ");
INSERT INTO tkr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Yizde xıle fironun k'olaniy vod, zı man ts'ets'ybı fironne k'oleeqa hoç'un, yicıd fironusqa quvu. ");
INSERT INTO tkr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufee mang'uk'le eyhen: – Man in eyhen vodun: xheyible tübəə xhebılle yiğ eyhen vodun. ");
INSERT INTO tkr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Xhebne yiğıle fironee ğu zindaneençe qığavhu, yisseyne işilqa sak'ala'as. Şenkiyn xhinne mang'us ulyoğan helena ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Hucoon ixhes, gırgın kar yəqqı'lqa gitxhumee, zı yik'el qale'e. Zas sa yugvalla hee'e, fironusne yizın do ağmiş he'e. Zı ine zindaneençe g'attixhan he'e. ");
INSERT INTO tkr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Zı cühüt'yaaşine cigeençe qöqüna vor, inyaayıd zı zindaneeqa gixhasın vuççud hı'ı deş. ");
INSERT INTO tkr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Gıney qeceng'uk'le Yusufee nyak' yugvalis yuşan ha'a g'acu, eyhen: – Zak'leme nik'ek yizde vuk'lel oo xheyible ç'emç'e cagvarane gıneyna g'avcu. ");
INSERT INTO tkr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Oğane ç'emç'ee fironusva hı'iyn curayn-curayn gıney ıxha. Mane ç'emç'eеnçis şit'yaaşe k'ufariy ı'xiyxə. ");
INSERT INTO tkr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufee inəxüd eyhe: – Man in eyhen vod: xheyible ç'emç'e, xhebılle yiğ eyhen vod. ");
INSERT INTO tkr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Xhebne yiğıle fironee ğu zindaneençe qığavhu, yiğna vuk'ul candakıke curav'u, candak yivele qı'xəs. Şit'yaaşed çis k'ufar ı'xəs. ");
INSERT INTO tkr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Xhebne yiğıle fironun yedike ıxhayn yiğ eyxhe. Mang'vee cune insanaaşis otxhun-ulyodğuy hele. Ulyoğan helenayiy gıney qecena zindaneençe qığav'u, cune insanaaşine hiqa qavayle. ");
INSERT INTO tkr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ulyoğan helenbışda xərna şenkiyn xhinne cune işilqa sak'ala'a, mang'veeyid ögiylin xhinne k'ola fironne xıleqa qele. ");
INSERT INTO tkr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Gıney qecenabışda xərnar givayxanna. Gırgın kar Yusufee uvhuyn xhinne eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ulyoğan helenbışde xərıng'vee Yusuf yik'el qalya'a deş, yik'el hixanı'ına. ");
INSERT INTO tkr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Q'ölle sen ılğeç'uyle qiyğa fironuk'le inəxdun nyak' g'ece: mana Nil eyhene damayne mıglek ulyorzul eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Dameençe yighıble micagna tavulyna zer qığevç'u, damayne mıglek uxhiyxhan giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mançile ğayrı dameençe meeb yighıble qəlana, yoxxarana zer qığooç'e. Manbı atk'ın şenesa zerbışde k'ane damayne mıglek ileezar. ");
INSERT INTO tkr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Qəlaneyiy yoxxarane zerbışe yighıble micagna tavulyna zer hööğəna. Mane gahıl firon nik'eençe muğur qexhe. ");
INSERT INTO tkr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Mana meer nik'eeqa ark'ıniys, medın nyak' g'ece: sa sukune cucukeençe yighıble gyavts'una micagna sukuna gıt'y (sunbul) ələə g'ooce. ");
INSERT INTO tkr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mançile qiyğa şargıne mıtsee gyotxhuniyn yighılle k'üvən sukun gıt'y aleyle. ");
INSERT INTO tkr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","K'üvəne sukunee gıt'yın yighıble micagna gyavts'una sukuna gıt'y hööğəna. Manke firon muğur qexhe, man sa nyak' ıxhay ats'axhen. ");
INSERT INTO tkr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Miç'eer mana suğotsuyng'a, cusda ciga iveeke deşiy. Misirın nekke k'oran ək'elikan insanariy cadu ha'anbı mang'vee cusqa saa'a. Fironee manbışis cun nyak' yuşan he'eeyid, manbışik'le ats'axhxhe deş man hucoo eyheniy. ");
INSERT INTO tkr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","10","Ulyoğan helenbışde xərıng'vee fironuk'le inəxüd eyhe: – Fironuk'le eyhesın cuvab zas həşde yik'el qadı. Sa yiğıl firon it'umra cune nukaraaşilqa qəllamışxha, mang'vee zınar gıney qecenbışda xərnar g'aravulyçeeşine xərıng'une xaane zindaneeqa akkyaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Sa xəmde yişde q'öng'uk'lesana curayn-curayn mə'nabınan nyak'bı g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Maa'ar şakasana g'aravulyçeeşine xərıng'una nukar, cühüt' cehiliyne. Nik'ek g'acuynbı şi mang'us yuşanı'ı. Zak'leyiy şeng'uk'le curayda-curayda, yişin nyak'bı nen eyheniyva, mang'vee uvhuyn. ");
INSERT INTO tkr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Gırgın kar mang'vee eyhəxüd ıxha. Zı yizde yisseyne işilqa sak'ı, gıney qecenar givarxınna. ");
INSERT INTO tkr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Fironee Yusuf cusqa qoyt'al. Mana hamankecar zindaneençe qığavhu, vuk'ul gyapxı, tanalinbı badal hı'ı, fironusqa qarayle. ");
INSERT INTO tkr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fironee Yusufuk'le eyhen: – Zak'le sa nyak' g'acu, man nen eyhen ıxhay, şavussecad eyhes dəxı'yn. Zak'le g'ayxhiyn, vasse nik'ek g'acuynbı nen eyhenbıyiyva eyhes əxəvud. ");
INSERT INTO tkr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufee inəxüd eyhe: – Man zaken deş vod. Allahee fironus kara'əən alidghıniy qelesın. ");
INSERT INTO tkr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Fironee eyhen: – Zak'le nik'ek g'acuyn, zı Nil eyhene damayne mıglek ulyorzulyur. ");
INSERT INTO tkr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Dameençe yighıble tavulyna micagna zer qığevç'u, damayne mıglek uxhiyxhan giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mançile qiyğa yighıbleb geeb qəlana, həlale g'a'aypxhına zer qığevç'u. Misirvolle zak'le məxdun qəlan zerbı g'acu deşdiy. ");
INSERT INTO tkr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Yoxxaraneyiy qəlane zerbışee, yighıble ts'eppa dameençe qığevç'una tavulyna zer opxhunna. ");
INSERT INTO tkr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tavulyun zerbı mançine vuxhnyaqa atk'ıneeyid, mançin vuxhunbu mə'lim hidi'iynbı. Manbı nəxüdiy vod, həməxüdud axuynbı. Manke zı muğur qıxha. ");
INSERT INTO tkr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Qiyğa zak'le nik'ek in g'acu: sa sukune cucukeençe yighıble gyavts'una yugna sukuna gıt'y alyabı. ");
INSERT INTO tkr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mançile qiyğad yighılle şargıne mıtsın gyoxhxhanı'iyn k'üvən, q'əran sukun gıt'y aleyle. ");
INSERT INTO tkr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","K'üvəne sukune gıt'yın yighıble yugna sukuna gıt'y hööğəna. İn nik'ek g'acuynbı, zı cadu ha'anbışis yuşanı'iynbı. Zak'le man nen eyheniy, eyhes əxəna dexhana. ");
INSERT INTO tkr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufee fironuk'le eyhen: – Fironun nyak'bı sa karake yuşana'a. Allahee, vucee ha'asın kar fironus ats'axhya'a. ");
INSERT INTO tkr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Yighıble tavulyna zeriy yighıble yugna sukuna gıt'y yighılle sen eyhen vodun. Mane nyak'bışe sa karake yuşana'a. ");
INSERT INTO tkr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Mançile qiyğa qığevç'una yighıble yoxxaranayiy qəlana zerıb, şargıne mıtsee gyopxhunna yighıble q'ərana sukuna gıt'yıb, yighılle sen eyhen vodun. Man yighılle senna mısvalla vuxhes eyhen vodun. ");
INSERT INTO tkr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Zas fironuk'le manvaniy eyhes ıkkan, Allahee, vucee ha'asın kar fironus ats'axhya'a. ");
INSERT INTO tkr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sık'ınne gahıle Misir geed barakatnan yighılle sen giğalas. ");
INSERT INTO tkr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mançile qiyğa yighılle senna məxübna mısvalla vuxhes, Misir vuxhana ögilyna baraka mançin yik'el hivxanaa'as. Mısvalin nyaq'v q'əra qaa'as. ");
INSERT INTO tkr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Mana mısvalla məxüb yı'q'ba ılğevç'uva, ögiyl vuxhana barakat ulesqa qavaales deş. ");
INSERT INTO tkr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Fironuk'le man nyak' q'ö'es g'acuyng'a, Allahee man kar hək'edad sık'ınne gahıle vuk'lelqa qalya'asınva eyhen ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Mançil-allar fironee Misirne ölkayna xərna gixhxhesda ək'elikanayiy ats'aalikana insan t'abal he'ecen. ");
INSERT INTO tkr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Fironee ölkavolle cun insanar ç'ak'ınbı xhinne gyuvxhecen, Misir sav'uyne sukuke manbışe xhob'esda pay barakanane yighne senna see'ecen. ");
INSERT INTO tkr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Hasre manbışe mane yugne senbışee alyabına mana suk şaharbışee, fironee əmr hav'uyn xhinne, see'ecen. ");
INSERT INTO tkr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Man sı'iyn gırgın kar Misirilqa qalesde yighne mıssıne seniys ixhecen, ögiyle qööne mane yighne mıssıne senee ölkeebınbı xhal hımabat'acenva. ");
INSERT INTO tkr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Fironusiy cune insanaaşis mana fıkır yik'eençe vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mang'vee cune insanaaşik'le eyhen: – İna insan xhinnena şok'le Allahın Rı'h vodnana insan aveekesdane? ");
INSERT INTO tkr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Fironee Yusufuk'le eyhen: – Vak'le Allahee in karbı haguxhee, man vale ats'alikana, vale k'orane ək'elikana deşdava eyhen vodun. ");
INSERT INTO tkr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Zı ğu yizde xaana xərna giyxhe, yizde ölkayne gırgıng'vee ğu uvhuyn ha'as. Saccu zı paççah xhinne vale xərna ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Fironee Yusufuk'le meed eyhen: – Həşdiyle ilekke, zı ğu bıkırne Misirna xərna giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mang'vee cune t'ubelyna t'ucva g'avşu, Yusufne t'ubelqa qaa'a. Mang'ulqa nekke yugne katanıke hı'iyn g'üvənan tanalinbı ali'ı, gardanılqab k'ınəəğəyke hı'iyn t'exa qalya'a. ");
INSERT INTO tkr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Fironee mang'us cune daşk'abışin q'öd'esın hele. Qiyğab manbışile hiib əlyhəəne cune insanaaşilqa əmr hav'u eyhen: – Yəq' hevlecenva ts'irbı he'e. İnəxür fironee Yusufuke Misirnacar xərna ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Fironee Yusufuk'le eyhen: – Firon zı ixheeyir, ğu ittevhu bıkırne Misiree şavacad t'ub ı'ğviykaraa'as deş. ");
INSERT INTO tkr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fironee Yusufus Safnat-Paneah do giyxhe. Mang'us xhunaşşe yixhecenva On eyhene şaharne kaahinna Fotiferanna yiş Asnat heele. Yusuf mançer ayk'anna bıkırna Misirna ölka alycaaxvas. ");
INSERT INTO tkr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Misirne paççahısnee, fironusnee işilqa giyğalang'a, Yusufuqa xhebts'al (30) senniy vod. Mana fironusse qığeç'u, Misirvolle alycaxvas ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Barakatnane yighne senee ç'iyeyn geed xətta kar aleylya'a. ");
INSERT INTO tkr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Mane barakatnane yighne senee Misiree alyadıyn gırgın kar Yusufee şaharbışeeqa sa'a. Hucooyiy mane şaharne hiqiy-allane çolbuşeençe sı'ı, mane şahareeyid g'alyadaççe ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufee deryaheena g'um xhinne geeb suk saa'a, mang'vee mana qəpqəs dyooxheva qəbəqqə deş. ");
INSERT INTO tkr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Yusufus, mıssın senbı qalesse, On şaharne kaahinne Fotiferanne yişşee Asnatee q'öyre dix uxu. ");
INSERT INTO tkr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Mang'vee ts'erriyne dixen do Menaşşe (yik'el hixana'as) gixhxhı eyhen: – Man do zı mançil-alla gixhxhı, Allahee zı ts'ıts'ı'inbıyiy dekkın xav yik'el hixana'as hassırva. ");
INSERT INTO tkr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mang'vee q'ör'esde dixen do Efrayim (barakatnana) gixhxhı eyhen: – Man do zı mançil-alla gixhxhı, zı mane cigee uts'ur ts'ıts'e'eeyid, Allahee maa'ar zı barakatnana hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Yusufee uvhuyn xhinne, Misiree yighılle barakatnan sen g'attitxhın, yighılle mıssın sen giyğal. Mıssıvalla gırgıne cigabışee vooxhena, saccu Misirıl oxhanasın kar dena idyavxu. ");
INSERT INTO tkr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Misirne cəmə'ətın oxhanasın kar g'att'umee, manbı k'yookkanbı fironusqa oxhanasın kar heqqas. Mang'vee cəmə'ətık'le eyhen: – Hudoora Yusufusqa havak'ne, mang'vee uvhuyn he'e. ");
INSERT INTO tkr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ç'iyeyn aq'vavollette mısvalla vuxha. Misir mısvalla geeb xəb qooxhe g'avcu, Yusufee suk sav'uyn cigabı aaqı, mançe Misirbışis suk massa hoole giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Gırgıne ölkabışee it'umna mısvalla gibğılil-alla, gırgınəəng'ançe insanar Yusufusqa abayle vuxha suk alivşes. ");
INSERT INTO tkr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaaq'ubık'le Misir suk vobva ats'axhxhamee, mang'vee dixbışik'le eyhen: – Nya'a şu sana-sang'uqa ilyaaka avxu? ");
INSERT INTO tkr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Zak'le g'ayxhiyn Misir suk vobubva. Havak'ne mançe şasda suk alivşe, deşxheene şi xhal hapt'as. ");
INSERT INTO tkr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yusufna yits'iyre (10) çoc suk alivşesva Misirqa havayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Saccu Yusufna çoc Benyamin Yaaq'ubee çocaaşika g'ıxele deş. Mana qəyq'ənna Benyaminık sayid sa kar eyxheva. ");
INSERT INTO tkr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kana'anaaşine cigabışee mısvalybıva, suk ulyooşenbışika İzrailin dixbıb abı vuxha. ");
INSERT INTO tkr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusuf bıkırne ölkayna xərnaniy, Misirvolle suk vuceeniy massa hoole. Yusufun çocar abıyng'a, mang'une ögiyl ç'iyelqame k'yobzuriynbı. ");
INSERT INTO tkr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufuk'le cun çocar g'avcuykum qıvaats'eeyib, qıvdyaats'inçilqa hadaççe. Manbışika mana sacurayracar eyxhe. Yusufee manbışike qiyghanan: – Nençene şu abı? Manbışe eyhen: – Kana'anne ölkeençe, otxhanan kar alişşes. ");
INSERT INTO tkr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufuk'le cun çocar qıvaats'anbı, çocaaşik'lemee vuc qıvaats'ı deş. ");
INSERT INTO tkr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufus cehilynang'a çocaaşine hək'ee g'acuyn nyak'bı yik'el qadı, manbışik'le eyhen: – Şu caasusarıb, ölkayn it'um hidi'iyn cigabı ats'axhxhesıb abı! ");
INSERT INTO tkr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Çocaaşe mang'uk'le eyhen: – De'eş, yişda xərna, yiğın g'ular otxhanan kar alişşes abı. ");
INSERT INTO tkr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yişin gırgınbı sang'un dixbı vob. Yiğın g'ular qopkuyn insanar vob, şi caasusar deş vob. ");
INSERT INTO tkr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusufee manbışik'le eyhen: – De'eş, şu abıynbı g'aces, nyaadiy yişde ölkayn it'um hidi'iyn cigabı! ");
INSERT INTO tkr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Manbışe eyhen: – Şi yiğın g'ular yits'ıq'vəyre (12) çoc vob, Kana'anne cigeençene sang'un dixbı vob. Yişda k'ınna çoc dekkıne k'ane vor, manasar xəəqa-ç'iyeeqa ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufee manbışik'le eyhen: – Gırgın kar zı şok'le uvhuyn xhineevud, şu caasusarıb! ");
INSERT INTO tkr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Zı şu inəxüb siliys üvxəs: fironne vuk'lelen k'ın g'iysar, vuşda k'ınna çoc inyaqa ittyareene, şosse inçe əlyhəəs vəəxəs deş. ");
INSERT INTO tkr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Vuşda sa g'axıle k'ınna çoc ayrecen, avxuynbıb inyaa avqas. Manke zak'le g'acesın şu eyhen horee-hək'enee. Deşxheene, fironne vuk'lelqa k'ın ixhecen, şu caasusarıbva! ");
INSERT INTO tkr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yusufee manbı xhebılle yiğna zindanee havaacı. ");
INSERT INTO tkr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Xhebıd'esde yiğıl Yusufee manbışik'le eyhen: – Zı Allahıle qəyq'ənna: zı uvhuyn he'eene, şu üç'übba aaxvas. ");
INSERT INTO tkr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Şu qopkuyn insanarxhee, hasre vuşda sa zindanee axvecen, mansanbışemee xaa'ab mıssıba avxuynbışis suk vukkeecen. ");
INSERT INTO tkr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Qiyğa vuşda k'ınna çoc zasqa ayre. Məxüd zak'le ats'axhxhesın, şu eyhenbı hək'enbıyee, deşxhee dişeene. Mançika şunab hapt'ıyke g'attivxhanasınbı. Mançis çocaaşe ho'ova eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Manbışe sana-sang'uk'le eyhen: – Hək'ebab, şi çocus hı'iynçina cazaa vob ts'ıts'aа'a. Mang'vee şalqa miz k'yaa'ang'a, şak'le mang'uk qitxhuyn divan g'acu, şi mang'vee uvhuyn hı'ı deş. Mançil-allad yişde vuk'lelqa in divan adı. ");
INSERT INTO tkr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruvenee manbışik'le inəxüd eyhe: – Zı uvhu dişdiy gadeys pisvalla hımaa'a, şumee zal k'ırı alixhxhı deş. Həşdeb şi mang'une ebal-alla cazaa ts'ıts'aa'a. ");
INSERT INTO tkr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Çocaaşik'le ats'a deşdiy Yusufee col k'ırı iliyxheva. Mana manbışika sak'ala'ang'une kumagıka yuşan ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusuf çocaaşisse şaqana ark'ın, geşşena. Qiyğar meer cosqacar sak'ı, manbışika gaf haa'a. Çocaaşine yı'q'neençe Şimon aqqeva əmr haa'a. Qiyğaler mana manbışik'le g'ece-g'ece iyt'alna. ");
INSERT INTO tkr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufee əmr haa'a manbışin balagbı sukun gyatsts'e'e, co adiyn nuk'rad conecad balagbışeeqa gixhxhe, yəqqı'sıd oxhanasın kar hele. Həməxüdud ha'an. ");
INSERT INTO tkr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Çocaaşe suk əməleeşilqa alivxhu, mançe avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Manbışde sang'vee xəm g'aahane cigee əməleys yem helesva balagın ghal aaqıyng'a, balagne ghalee cun nuk'ra g'ece. ");
INSERT INTO tkr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Mang'vee çocaaşik'le eyhen: – Yizın nuk'ra sak'ıyn, haane yizde balageevud. Manbışin yik' aqqaqqa, qəpq'ı'n sana-sang'uk'le eyhen: – Şak Allahee hucooyiy hı'ı? ");
INSERT INTO tkr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Manbı dekkıne k'anyaqa Kana'anne cigabışeeqa qabı, mang'us vuk'lelqa qadıynbı inəxüd yuşan ha'a: ");
INSERT INTO tkr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","– Şene ölkayna xərna şaka sacurayracar yuşan hı'ı. Mang'uk'le həməxüd ats'axhxha, şi menne ölkayn caasusarniyxan. ");
INSERT INTO tkr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Şimee mang'uk'le uvhuyn: «Şi qopkuyn insanar vob, caasusar deş. ");
INSERT INTO tkr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Şi yits'ıq'vəyre (12) çoc, sa dekkın dixbı vob. Sa yişda çoc xəəqə-ç'iyeeqa ıxha, k'ınna yişda çocur Kana'anne cigabışee dekkıne k'ane vor». ");
INSERT INTO tkr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Şene ölkayne xərıng'vee şak'le uvhuyn: «Şu qopkuyn insanar vuxhay inçike ats'axhxhes: çocaaşina sa yizde k'ane g'alerçe, şunab xizanbı mıssıvalike g'attixhan ha'as suk alyapt'ı, hudoora. ");
INSERT INTO tkr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mançile qiyğar k'ınna çoc zasqa ayre. Manke zak'le ats'axhxhesın şu caasusaraye deşxhee, qopkuyn insanaare. Qiyğaler vuşda çoc şosqa quvu, zı ine cigabışee iviykarasiy kar alişşes şosqa hassarasın». ");
INSERT INTO tkr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Balagbı haç'a'ang'a, çocaaşik'le con nuk'ranan yut'elybı caa'ad iveeke. Çocarıb cona dekkır nuk'rabı g'acu, qəvəyq'ənanbı. ");
INSERT INTO tkr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yaaq'ubee manbışik'le eyhen: – Şu zı dixbışkena hı'ı! Yusufır deşda, Şimonur deşda, həşder Benyamin qıkkekka! Man eyxhen gırgın zak eyxhe! ");
INSERT INTO tkr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruvenee dekkık'le inəxüd eyhe: – Ğu mana yizde xıleqa qele, zı mana vasqa sak'al ha'asda. Zı mana vasqa sak'al hide'eene, yizda q'öyursana dix gyapt'e. ");
INSERT INTO tkr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaaq'ubee eyhen: – Yizda dix Benyamin maqa şokasana ı'qqəs deş. Yizde xhunaşşeyke Raahileyke sa mana axu, mang'una çoc qik'una. Sayid mang'une vuk'lelqa yəqqə sa kar qadeene, zı q'əsvalee mane uts'uruka ahaleeqa əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kana'anaşine cigabışee mısvalybı geedniy qeetxha. ");
INSERT INTO tkr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Çocaaşe Misirğançe abına suk opxhun g'apt'ımee, dekkee manbışik'le eyhen: – Havak'ne şas sık'ınin oxhanasın kar alişşe. ");
INSERT INTO tkr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yahudee mang'uk'le inəxüd eyhe: – Şene insanee şas yugda g'ayxhı'iyn, yizde ulesqa qımaale şokasana vuşda çoc dexheene. ");
INSERT INTO tkr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ğu çoc şaka g'axuvuynxhiy şi hapk'ın vasın otxhuniy ileşşeyiy. ");
INSERT INTO tkr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ğu mana g'ıxdevee, şi maqa vüqqəs deş. Şene insanee şak'le uvhuynniy çoc ittyaree yizde ulesqa qımaale. ");
INSERT INTO tkr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Manbışde dekkee İzrailee eyhen: – Nya'a şu zalqa ina ver ablyav'u, nişisne şu şene insanık'le uvhu şoqa sayır çoc vornava? ");
INSERT INTO tkr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Manbışe eyhen: – Mane insanee yişdeyiy yişde xizanbışde hək'ee geed qidghınbı hı'ı: «Həşde dek üç'ürne vor? Merna şoqa çoc vornane?» Şinad mang'une alidghıniybışis cuvabniy qele. Nya'a yişde ək'eleeqa qadayleyiy, mang'vee çoc ayreva eyhes ıxhay? ");
INSERT INTO tkr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yahudee dekkık'le İzrailik'le eyhen: – Gade g'aykke, şi əlyhəəs. Ğunar, şinab, uşaxarıb hidyapt'ı, manke üç'übba aaxva. ");
INSERT INTO tkr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Zı mang'ul-alla vas cuvab qeles, ğu mana zake qiyghne. Zı mana vasqa qidyaree, yiğne ögiyl ulyozar hide'ee, zı yiğne ögiyl qik'asmee vuk'ul avqa ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Şi vaxt ılğıdyavhunaxhiy, həşdilqasse q'öneyəqees hapk'ın qabı vooxheyiy. ");
INSERT INTO tkr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","İzrailee eyhen: – Mennəxüd dexhexheene, şu in kar he'e: q'oç'ebışeeqa ine cigayne inette yugne meyvabışike, qiyğale xhinne balyzam, sık'ınin itv, ədviyat, ətriyat, püste, badam sı'ı, mane insanıs pay xhinne ıkkee. ");
INSERT INTO tkr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Q'öd şene ögiylinmeen nuk'ra aleet'e. Balagbışeead yı'q'əlqa qadıyn nuk'rad ıkkı vuşde xıleka sak'ale'e, sayib manbı balagbışeeqa yugba ilydyaakı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Çocur alyart'u, mane insanne k'anyaqa savk'le. ");
INSERT INTO tkr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Gırgın əxəne Allahee mana insan şos məxür g'üvəna qe'ecen, mang'veeyir vuşda şenasa çociy Benyamin şoka xaaqa savaak'alas havaasrecen. Zınar uşaxaaşikena ixhesxhee, hasre ixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Çocaaşe Benyaminır, paybıd, q'öd şenemen nuk'rad alyaat'u, mankecab gyabak'anbı yəqqı'lqa. Misirqa hipxhır, manbı Yusufusqa qavayle. ");
INSERT INTO tkr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufuk'le Benyaminır manbışika sa cigee g'acumee, cun xav vuk'lek ıkkekang'uk'le eyhen: – İn insanar yizde xaaqa quvku, həyvan gyuvk'u, ç'əra qee'e, manbışe zaka yı'q'ı'hiyn karbı oxhanas. ");
INSERT INTO tkr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mane insanee Yusufee cuk'le nəxüdiy uvhu, həməxüdud ha'an: man insanar quvkekkanbı Yusufne xaaqa. ");
INSERT INTO tkr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Manbışe co Yusufne xaaqa quvkekkava qəpq'ı'n, eyhen: – Şene ögiyl balagbışee sak'alı'iyne nuk'rayl-alla şi quvkekka. Mang'us şalqa xıl g'ot'alas, şale ğamxha əməler g'ayşu, şake nukarar haa'as vukkan. ");
INSERT INTO tkr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Manbı xaaqa əkkəəne cigee, Yusufne xav vuk'lek ıkkekang'usqa qeepxha, inva eyhe: ");
INSERT INTO tkr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","– Yişda xərna, şi şene ögiylib otxhanan kar alişşes abıynbıniy. ");
INSERT INTO tkr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Şi xəmde aaxvane cigee balagbışin ghalybı aaqıyng'a, gırgıng'uk'le cun nuk'ra nəxüdiy vod k'ıl qıdexha balagne ad iveeke. Həşde man şi yişde xıleka yı'q'əlqa sak'ala'a. ");
INSERT INTO tkr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","G'iyniysın otxhuniy alişşesınıd şi nuk'ra curayda adı. Şen nuk'rad şavaame yişde balagbışeeqa gixhxhı, ats'a deş. ");
INSERT INTO tkr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Xav vuk'lek ıkkekang'vee eyhen: – Gırgın çine cigal vod, qıməəq'ən. Vuşdeyiy vuşde dekkıne Allahee man nuk'ra vuşde balagbışeeqa gixhxhı. Şu şene ögee adıyn nuk'ra zasnee vod. Qiyğaler Şimon manbışisqa qığayhe. ");
INSERT INTO tkr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mane insanee çocar qavaylenbı Yusufne xaaqa. G'elybı hoğalasın manbışis xhyaniy əməleeşisın yemıd helen. ");
INSERT INTO tkr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Çocaaşik'le uvhuyng'a co Yusufuka yı'q'ı'hiyn kar maa oxhanasva, manbışe mana qalesse con paybı qığa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusuf xaaqa qarımee, manbışe co adiyn paybı hagu, mang'une ögiyl ç'iyelqamee k'yoozaranbı. ");
INSERT INTO tkr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufee manbışike qidghın ha'a: – Co nəxübiyva? Şena şu eyhena vuşda q'əsda dek nəxürneva? Meernaneva həşde? ");
INSERT INTO tkr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Manbışe eyhen: – Yiğna g'ul, yişda dek meerna, yugra vor. Manıd uvhu Yusufne ögiyl ç'iyelqamee k'yoozaranbı. ");
INSERT INTO tkr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufee ul alivk'arav'uyng'a, cune yedikena çoc Benyamin g'acu eyhen: – Şena şu zak'le eyhena k'ınna çoc haynane? Qiyğa Benyaminık'le eyhen: – Dix, Allahee vas yugun helen. ");
INSERT INTO tkr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusufuk'le çoc g'acumee, mang'un yik' hoyç'an giyğal, geşşuy qadayle. Mana ek'ra qığeç'u, cune gozeeqa ark'ın, yugra geşşena. ");
INSERT INTO tkr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yusuf aq'va hodğul qığeç'e. Mang'vee geşşuy aqqı, əmr haa'a: – Otxhuniy qale. ");
INSERT INTO tkr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Otxhuniy mang'us curayda, çocaaşis curayda, mang'uka kar otxhanne Misirğançenbışis curayda qadayle. Misirğançenbışisse Cühüt'yaaşika sacigee kar oxhanas əxən deşdiy, mançile Misirğançenbı həlyvəəq'ənanbıniy. ");
INSERT INTO tkr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusufne ögiyl çocar senbışis sik'ı çiçiqab qihna gyuv'araa'a. Manbı sana-sang'uqa ilyаakı ghalybı aaqı aaxva. ");
INSERT INTO tkr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusufne ögiylyne otxhuniybışike manbışisdab pay curaa'ana. Saccu Benyaminna pay mansanbışde paybışile xhoniyəqqee xəppa vuxha. Məxüd manbışe mang'uka yugda otxhun-ulyoğan. ");
INSERT INTO tkr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufee cun xav vuk'lek ıkkekang'ulqa əmr haa'a: – İne insanaaşin balagbı cosse qıkkes əxəsdemeene otxhuniyka gyatsts'e'e. Co adıyn nuk'rad conecad balagbışde ghaleeqa gixhxhe. ");
INSERT INTO tkr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Yizda nuk'rayna kasamee k'ıning'une balageeqa vucee sukuke quvuyne nuk'rayka sacigee givxhe. Şeng'vee gırgın Yusufee uvhuyn xhinne ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Miç'eed qıxhayng'a, in insanar cone əməleeşika sacigee yəqqı'lyaa'anbı. ");
INSERT INTO tkr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Manbı şaharılee geeb əq'əna qepxha deşdiy, Yusufee xav vuk'lek ıkkekang'uk'le eyheng'a: – Ek'ra oza qıxha, mane insanaaşiqa qihna hoora, avarq'ılymee manbışik'le eyhe: «Nişil-allane şu yugvalis pisvalla hav'u? ");
INSERT INTO tkr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nişil-allane yizde xərıng'una nuk'rayna kasa qöpqü? Mang'vee mançe ulyoğan, falıka ilyakka. Şu qotkuda hı'ı deş!» ");
INSERT INTO tkr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Xav vuk'lek ıkkekana manbışiqa avarq'ıl cuk'le uvhuyn manbışilqa hixhara'an. ");
INSERT INTO tkr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Çocaaşe mang'uk'le eyhen: – Nişil-allane yişde xərıng'vee məxdun cuvab eyhe? Şasse g'ulaaşisse məxdun kar ha'as əxəye! ");
INSERT INTO tkr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Şak'le balagbışee aveykıyn nuk'rad Kana'annee cigabışeençe sak'alı'ı vas qadı. Nişil-allane şi xərıng'une xaançe k'ınəəğəyiy nuk'ra qöqəs? ");
INSERT INTO tkr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Hasre man kar şavusneyiy aveykı, mana insan gik'ecen, avxuynbıb xərıng'us nukarar vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mang'vee eyhen: – Şu yugda uvheeyid, hasre inəxüd ixhecen: man kar şavusneyiy aveykı, mana yizda nukar ixhecen, mansanbışil bınah aaxvas deş. ");
INSERT INTO tkr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Çocaaşe zarada balagbı gyaqqı, çin ghalybı aaqa. ");
INSERT INTO tkr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Xav vuk'lek ıkkekang'vee xərıng'ule girğıl k'ıning'ulqamee t'abala'ana, kasa Benyaminne balagee iveeke. ");
INSERT INTO tkr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Çocaaşe cok qitxhuyne divanıke tanalinbı qıt'axxa'a. Qiyğa əməleeşilqa karıd alixhxhı, siviyk'alanbı şahareeqa. ");
INSERT INTO tkr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yahud çocaaşika sacigee Yusufne xaaqa qarayle. Mane gahıl Yusuf xaa eyxhe. Manbı Yusufne ögee ç'iyelqamee k'yoozaranbı. ");
INSERT INTO tkr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufee manbışik'le eyhen: – Şu hı'iyn hucoone? Şok'le ats'a dişdiy, zına xhinnena insan falıka ilyakkımee, gırgın g'ecen? ");
INSERT INTO tkr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahudee eyhen: – Şi xərıng'uk'le hucoovane, nenvane eyhes? Nəxübne şi qopkuynbı xhinne haagvas? Allahee şi hav'una bınah haagva. Həşde şinab, kasa neng'usneyiy avaykı manar, yişde xərıng'un g'ular vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufee eyhen: – Zı məxdın kar ha'as deş. Kasa şavusneyiy aveykı mana yizda g'ul ixhes, mansanbıb qı'dəpq'ı'n dekkısqa savk'le. ");
INSERT INTO tkr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Manke Yahud mang'usqa qıxha eyhen: – Yizda xərna hucoone ixhes, yiğne g'ulus xərıng'uk'le cuvab eyhes hasre. Ğu firon xhinnena insan ixheeyir, ğu yiğne g'ululqa qəllamışmexhe. ");
INSERT INTO tkr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Şenke xərıng'vee g'ulaaşike qiyghıninniy: «Şoka dek, çoc vornane?» ");
INSERT INTO tkr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Şi manke xərıng'uk'le uvhuynniy: «Şaqa sa q'əsda dek vorna, cuqar q'əsvalee ıxhana sa k'ınna dix vor. Mang'una çoc qik'una, cune yedine dixbışike mana sa axu, dekkısır mana geer ıkkan». ");
INSERT INTO tkr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Manke ğu yiğne g'ulaaşik'le uvhuynniy: «Mana zasqa ayre, zak'le g'aces». ");
INSERT INTO tkr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Şinad xərıng'uk'le uvhuynniy: «Gadeysse dek g'alerçes əxə deş, g'alerçveeyir, dek qik'asda». ");
INSERT INTO tkr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ğumee yiğne g'ulaaşik'le şak'le uvhuynniy: «K'ınna çoc ittyareene, sayib yizde ulesqa qımaale». ");
INSERT INTO tkr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Yiğne g'ulusqa, yişde dekkısqa sapk'ılıyng'a, yişde xərıng'vee uvhuyn mang'us yuşanı'iyn. ");
INSERT INTO tkr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Yişde dekkee uvhuyn: «Meeb havak'ne şas sık'ınin otxhuniy alişşu alle». ");
INSERT INTO tkr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Şimee uvhuyn: «Vüqqəs vəəxəs deş. Saccu yişda k'ınna çoc şaka ı'qqəxhee, şasseb maqa vüqqəs vəəxə. Şasse şeng'usqa qeepxhes vəəxəs deş, k'ınna çoc şaka dexheene». ");
INSERT INTO tkr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Yiğne g'ulee, yişde dekkee, şak'le uvhuyn: «Şok'le ats'an yizde xhunaşşee Raahilee zas q'öyre dix uxu. ");
INSERT INTO tkr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Sa dix yizde k'anençe ark'ın sak'ı deş, zınad uvhuyn: hək'erar mana sa bahalne həyvanın qodu-sodu ixhes. Həşdilqamee zak'le mana dix g'acur deş. ");
INSERT INTO tkr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Şu inasa dixır alyart'vee, mang'uned vuk'lelqa sa kar qadeene, ahaleeqa şu yizda cagvarana vuk'ul uts'uruka quvkees». ");
INSERT INTO tkr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Həşde şassee yiğne g'ulusqa yişde dekkısqa savaak'alas vəəxəs deş. Mana mang'us geerxhe ıkkiykanna. ");
INSERT INTO tkr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Mana gade şaka g'ıdecveene, yik' qotxu qik'asda. Manke yiğne g'ulaaşe dekkına cagvarana uts'urun gyavts'una vuk'ul ahaleeqa quvkees. ");
INSERT INTO tkr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yiğna g'ul eyxhene zımee, dekkıs cuvab huvu uvhuyn: «Zı mana vasqa sak'alde'eene, yiğne ögiyl qik'asmee vuk'ul avqa ixhes». ");
INSERT INTO tkr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Hucoone ixhes, hasre gadeyne cigee xərıng'us g'ul xhinne zı axvas, gader çocaaşika sark'ıl hooracen. ");
INSERT INTO tkr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mana dena, nəxürne zı dekkısqa əlyhəəs? Havaasre zak'le dekkına vuk'ul uts'uruka g'umoocecen! ");
INSERT INTO tkr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusufusse öörxəs dəxı', nukaraaşilqa ts'ir üvxiyxə: – Gırgınbı yizde k'anençe qığeepç'e! Yusufee çocaaşik'le vuc vuşu ıxhay eyhemee, manbışde k'ane vuşucar deşdaniy. ");
INSERT INTO tkr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Mana məxür axtıra geşşe giyğal, misirğançenbışik'le man g'ayxhı fironne xaane insanaaşis yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufee çocaaşik'le eyhen: – Zı Yusuf vorna! Yizda dek meernane? Çocaaşisse mang'us alidghıniy qeles əxə deş, hucoome eyhesınbı manbı aaxvanbı. ");
INSERT INTO tkr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufee çocaaşik'le eyhen: – Zasqana qeepxhe. Manbı cusqana qepxhamee, eyhen: – Şu Misirqa massa huvuna çoc Yusuf zı vorna. ");
INSERT INTO tkr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Zı inyaqa massa huvuva şu qı'məəq'ən, şolqacab qəl hımaa'a. Allahee vuşda ı'mı'r havaacesva zı şole ögee inyaqa yəqqı'l hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Q'ölle sen ıxha ine cigabışee mısvalybı gidğılna, inçile qiyğa xholle sennad ezuyiy-qiyşılıy ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Allahee zı şole ögee inyaqa xəbna suvabna iş haa'as, şu g'attivxhan hav'u, ç'iyeyne aq'val havaacesva g'axuvu. ");
INSERT INTO tkr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Mançil-allar zı inyaqa Allahee g'axuvu, şu deş. Mang'vee zake fironus dek xhinnena insan, cune xaana xərna, Misir ölkab vuk'lek vukkekana hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Zaraba dekkısqa apk'ın, mang'uk'le eyhe, dix Yusufee in vod eyhe: «Allahee zake Misir vuk'lek vukkekana hı'ı. Nimeeyiy əxə, zasqa ek'ra qora. ");
INSERT INTO tkr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ğu Misir Goşen eyhene cigee axvas. Ğunar, yiğın kulyfatbıb, yiğın nevabıb, çavra-vəq'əd, yiğın gırgıncad kar zas k'ane ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Maa'ar zasse vaqa ilyakkas əxəsda. Deşxheene, ğunayiy yiğna xizan, çavra-vəq'ə dağamiyvalee vuxhes. İnçile qiyğab xholle senna mısvalla vuxhes». ");
INSERT INTO tkr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Zı, Yusuf vorna şoka yuşana'ana, şok'led, yizde çoc Benyaminık'led man g'ecen. ");
INSERT INTO tkr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Misir zı nəxriy ats'a, şok'le inyaa hucooyiy g'acu, mançina gırgınçina gaf yizde dekkıs hav'u, mana ek'ra zasqa ayre. ");
INSERT INTO tkr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yusufee cuna çoc Benyamin xhılibışeeqa sı'ımee, q'öyursana gyaaşe giviyğal. ");
INSERT INTO tkr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Qiyğa mang'vee avxuyne çocaaşisıd ubbabı hı'ı, geşşe-geşşe manbı xhılibışeeqa sav'u. Qiyğale çocaaşe mang'uka meeb gaf hav'u. ");
INSERT INTO tkr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yusufun çocar abına gaf fironne xaane insanaaşilqa hiviyxhar. Mana gaf g'avxhuna fironur cun insanarıb şadeebaxhenbı. ");
INSERT INTO tkr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fironee Yusufuk'le eyhen: – Çocaaşik'le eyhe inəxüd he'ecen: «Vuşde həyvanaaşilqa kar alixhxhı, Kana'anne cigabışeeqa hudooracen. ");
INSERT INTO tkr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Qiyğab dekkır, xizanıb ana zasqa savk'lecen. Zı şos Misirın gırgınçile yugun ciga heles. Şunad maa'ad alyadıyn gırgınçile yugun kar oxhanas». ");
INSERT INTO tkr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Sayid manbışik'le eyhe: «İnəxüd he'e: dekkısıniy vuşde xhunaşşeeşisın, uşaxaaşisın daşk'abı Misirğançe alyaat'u, gırgınbı inyaqa qudoora. ");
INSERT INTO tkr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mаa'ad axuyn vuşun kar qimiykan, Misireedın gırgınçile yugun kar vuşun ixhes». ");
INSERT INTO tkr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","İzrailyne dixbışe həməxüdud ha'an. Yusufee fironee əmr hav'uyn xhinne, manbışisın daşk'abıd, oxhanasın yəqqı'lqan otxhuniyıd helen. ");
INSERT INTO tkr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Manbışde gırgıng'us sa tanalinbı hele, Benyaminısmee xholle tanalinbıyiy xhebıd vəş nuk'ra hele. ");
INSERT INTO tkr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yusufee dekkısva Misirın gırgınçile yugun kar, suk, gıney, yəqqı'sın oxhanasın alixhxhına g'able (20) əməle g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Mang'vee çocar yəqqı'l haa'amee, manbışik'le eyhen: – Yəqqı'l uğmooda. ");
INSERT INTO tkr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Manbı Misirğançe qığeepç'ı, Kana'anne cigabışeeqa dekkıne Yaaq'ubne k'anyaqa qabı, ");
INSERT INTO tkr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","mang'uk'le eyhen: – Yusuf meerır, vucur Misir xhinnene ölkayna xərnavur! Man g'ayxhı Yaaq'ubın yik' aqqaqqa, manbışe uvhuynçilqa hayexhe deş. ");
INSERT INTO tkr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yusufee uvhuyn gırgın çocaaşe dekkıs yuşana'an. Vuc ıkkees Yusufee g'axuvuyn daşk'abı g'acumee, Yaaq'ubın yik' cigeeqa qaylen. ");
INSERT INTO tkr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","İzrailee eyhen: – Həşde zak'le ats'axhxhayn yizda Yusuf meerır! Zak'le mançile yugun medın hucoone g'ayxhes! Hasre qik'asse sa hark'ın mana g'aces! ");
INSERT INTO tkr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","İzrailee cuka vodun gırgın sı'ı, yəqqı'lqa gexha. Mana Beer-Şeveeqa hirxhıl cune dekkee I'saq'ee ı'bəədat ha'ane Allahıs q'urban ablyaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Xəmde Allah İzrailis gyagu, mang'ulqa onuiyn: – Yaaq'ub! Yaaq'ub! Yaaq'ubee «Hooyva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Allahee eyhen: – Zı Allah vor, yiğne dekkee ı'bəədat ha'ana Allah. Misirqa ı'qqəs qı'məyq'ən, Zı vake maa'ad xədın millet g'alya'as. ");
INSERT INTO tkr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Vaka Misirqa Zınar ı'qqəsda. Qiyğar yı'q'əlqa Zıcar ğu meer qalesda. Ğu qek'ang'a Yusuf yiğne k'ane ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yaaq'ub Beer-Şeveençe ayk'anna. Yaaq'ubne dixbışe dekkır con uşaxarıb, yedyarıb fironee Yaaq'ubılqa g'axuvuyne daşk'abışeeqa gyav'u quvkekka. ");
INSERT INTO tkr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yaaq'ubeeyiy cune dixbışe çavra-vəq'əyiy, Kana'anne cigabışee co hı'iyn gırgın kar sı'ı Misirqa qavayle. ");
INSERT INTO tkr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Mang'vee cuka Misirqa dixbı, yişbı, nevabı, gırgına cuna xizancab alyapt'ı, ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Misirqa İzrailika sacigee cun dixbıyiy dixbışike g'abıynbı qavayle. Misirqa qabıynbışin dobı inbı vod: Yaaq'ubna ts'erriyna dix Ruven. ");
INSERT INTO tkr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruvenın dixbı: Xanok, Pallu, Xetsron, Karmi. ");
INSERT INTO tkr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Şimonun dixbı: Yemuel, Yamin, Ohad, Yakin, Tsoxar sayir Kana'anğançene zəiyfayke ıxhana Şaul. ");
INSERT INTO tkr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leviyn dixbı: G'erşon, Qohat, Merari. ");
INSERT INTO tkr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahudun dixbı: Er, Onan, Şela, Perets, Zarax. Eriy Onan Kana'anne ölkee habat'anbı. Peretsın dixbı: Xetsron, Xamul. ");
INSERT INTO tkr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","İssaxarın dixbı: Tola, Puvva, Yov, Şimron. ");
INSERT INTO tkr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zevulunun dixbı: Sered, Elon, Yaxle'el. ");
INSERT INTO tkr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Şenbı Leays Yaaq'ubıke vuxhayn uşaxarniy vob. Leayee manbıyiy yiş Dina Paddan-Aramee vuxu. Leayeyn dixbı, yişbı, nevabı gırgınbı sacigee qəbəqqəxhee, xhebts'ale xhebiyre (33) insan ıxha. ");
INSERT INTO tkr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Qadın dixbı: Tsifyon, Xaggi, Şuni, Etsbon, Eri, Arodi, Areli. ");
INSERT INTO tkr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aşerin dixbı: İmna, İşvah, İşvi, Beria sayir manbışda yiçu Serax. Berianın dixbı: Xever, Malkiel. ");
INSERT INTO tkr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Zilypanın Yaaq'ubıken dixbı, yişbı, nevabı gırgınbı sacigee qəbəqqəxhee, ina yits'ıyixhalle (16) insan eyxhe. Lavanee mana cune yişşeys Leays nukar xhinneniy hiyvu. ");
INSERT INTO tkr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaaq'ubne xhunaşşeyn Raahileyn dixbı: Yusufiy Benyamin. ");
INSERT INTO tkr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusufus Misirne On şaharne kaahinne Fotiferanne yişşee Asnatee, Menaşşeyiy Efrayim donan q'öyre dix Misir vuxu. ");
INSERT INTO tkr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyaminın dixbı: Bella, Beker, Aşbel, Gera, Naаman, Exi, Roş, Muppim, Xuppim, Ard. ");
INSERT INTO tkr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","İna yits'ıyoq'var (14) insan Yaaq'ubıniy Raahileyn dixbı, nevabı gırgınbı sacigee qəbəqqəxhee vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daniyna dix: Xuşim. ");
INSERT INTO tkr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftaliyn dixbı: Yaxtsel, Guni, Yetser, Şillem. ");
INSERT INTO tkr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilyhanın Yaaq'ubıken dixbıyiy nevabı gırgınbı sacigee qəbəqqəxhee ina yighıyre (7) insan eyxhe. Lavanee mana cune yişşeys Raahileys nukar xhinneniy hiyvu. ");
INSERT INTO tkr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaaq'ubne dixbışde xhunaşşeeşile ğayrı, Misirqa mang'uke g'arına yixhts'аle yixhıyre (66) insan qarı. ");
INSERT INTO tkr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusufus Misir q'öyre dix ıxha. Yaaq'ubne xizanee Misir yights'al (70) insan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Goşenqa əlyhəəna yəq vaats'a vuxhesva Yaaq'ubee cule hiqa Yusufusqa Yahud g'ıxele. Manbı Goşenısqa hiviyxharmee, ");
INSERT INTO tkr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf daşk'eeqa gyu'ur, dekkıne İzrailyne ögiylqa hayk'an. Dek g'acuys mana xhılibışeeqa sı'ı xılece geşşena. ");
INSERT INTO tkr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","İzrailee Yusufuk'le eyhen: – Ğu yugra g'acu, həşde zasse qik'as əxə. ");
INSERT INTO tkr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufee çocaaşik'leyiy dekkıne xizanık'le eyhen: – Hasre həşde fironusqa hark'ın eyhes, Kana'anne cigabışee eyxhena yizda dek, çocar, cone xizanbışika sacigee zasqa abı. ");
INSERT INTO tkr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Manbı çobanar vob. Mançil-allab manbı cone gırgıne karaka, çavra-vəq'əyka sacigee qabı. ");
INSERT INTO tkr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Fironee şu qopt'ul qiyghanasın: «Hucoonexhe şu ha'anva?» ");
INSERT INTO tkr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Şunad eyhe: «Şi, yiğın g'ular, yişin dekkar xhinne, k'ılybanang'acab çavra-vəq'ee vuxha». Manva uvhee, Goşen şos ciga heles. Misirğançenbıb çobanaaşile həlyvəəq'ənva, şos man ciga helesın. ");
INSERT INTO tkr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusuf fironusqa hark'ın, mang'uk'le eyhen: – Yizda dek, çocar cone gırgıne karaka, çavra-vəq'əyka Kana'anne ölkeençe inyaqa, Goşenqa qabı. ");
INSERT INTO tkr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Qiyğa mang'vee çocaaşike xhoyre g'əyxı', fironusqa abı. ");
INSERT INTO tkr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fironee Yusufne çocaaşik'le eyhen: – Hucoonexhe ha'an? Manbışe fironuk'le eyhen: – Yiğın g'ular, con dekkar xhinne, çobanar vob. ");
INSERT INTO tkr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Şi inyaqa qabıynbı Kana'anne ölkee it'umun mısvalybı gidğılva, yiğne nukaraaşisın çavra-vəq'ə uxhiyxhana'asın cigabı deşva. Hucoone ixhes, şi həşde Goşen aaxvas havaasre. ");
INSERT INTO tkr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Fironee Yusufuk'le eyhen: – Yiğna dekkiy çocar vasqavub abı. ");
INSERT INTO tkr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misir vas ıkkanan ciga g'əyxe: dekkısiy çocaaşis ine cigayne gırgınçile yugne cigee ciga qee'e. Havaasre manbı Goşenee aaxvecen. Vak'le manbışin yugun çobanar vaats'axheene, g'əvxe məxbınbı yizde çavra-vəq'əyqa ilyaakecen. ");
INSERT INTO tkr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusufee cuna dek Yaaq'ub fironusqa arayle. Yaaq'ubee fironus xayir-düə hoole. ");
INSERT INTO tkr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fironee mang'uke qiyghanan: – Vaqa xhulelle senne vod? ");
INSERT INTO tkr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaaq'ubee fironus inəxdun alidghıniy qele: – Yizde ı'mı'ren vəşşe xhebts'al (130) sen zı inyaa-şaa hı'ı. Yizda ı'mı'r k'ılyba, dağamba vuxha. Dekkaаşe mennəəng'ə hı'iyn senbımeeyib xıliyba vuxha deş. ");
INSERT INTO tkr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yaaq'ub fironus xayir-düə huvu, ayk'anna. ");
INSERT INTO tkr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufee fironee uvhuyn xhinne ha'a, dekkısdayiy çocaaşisda ciga Misir qaa'a, manbışis gırgınçile yugun Ramses eyhene cigeençe ciga hele. ");
INSERT INTO tkr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Sayid Yusufee dekkısın, çocaaşisın otxhuniy xizanbışis sik'ı havace. ");
INSERT INTO tkr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mısvalla manimee geeb qooxhe, ç'iyeyne aq'val otxhanan kar ivdeeke giyğal. Misirıniy Kana'anın cəmə'ət mısvaline xılençe vuççud dena axva. ");
INSERT INTO tkr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufee Misirneyiy Kana'anne insanaaşis suk massa huvu, maadın gırgın pılbı fironus sa'a. ");
INSERT INTO tkr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Misirneyiy Kana'anne insanaaşin gırgın pılbı g'att'uyng'a, gırgın misirğançenbı Yusufusqa abı, eyhen: – Şas gıney hele. Nişil-allane şi yiğne ulene ögee hapt'as? Yişin pılbı g'att'uynbı. ");
INSERT INTO tkr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufee eyhen: – Vuşun pılbı g'att'uxhee, manke həyvanar alle, zı şos mançine cigee gıney heles. ");
INSERT INTO tkr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Manbışe Yusufusqa con balkanar, çavra-vəq'ə, əməler ha'aykı adayle. Yusufee mane adıyne həyvanaaşike gıney badal ha'a. Mane sen mang'vee məxüd manbışde həyvanaşike gıney badal ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Man sen ılğeç'umee, manbı Yusufusqa abı eyhen: – Vak'le ats'an, şaqa pıl deşin, yişin həyvanarıd vas ıxha. Şaqa yişde xərıng'unemee tanbışileyiy cigabışile ğayrı vuççud axu deş. ");
INSERT INTO tkr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nişil-allane yiğne ulene ögiyl şakınıd, yişde cigabışikınıd ixhes? Şas, yişde cigabışiliy şal-alla gıney hele. Havaasre şi fironus nukarar vuxhes. Hucoone ixhes, şas sayid toxumbı hele. Manke şinab hapt'as deş, yişin cigabıd sahralqa sak'alas deş. ");
INSERT INTO tkr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","İnəxüd Yusufee gırgın Misirın cigabı fironus ileşşe. Mısvalybışil-alla gırgıne Misirğançenbışe con cigabı massa hele. Məxüd Yusufee Misirın gırgın cigabı fironne doyulqa alğa'a. ");
INSERT INTO tkr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Misireene gırgıne insanaaşike Yusufee fironus g'ular haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Fironee kaahinaaşina hək' qooleva, mang'vee saccu manbışin cigabı ilydeşşe. Mana vucee qoolena hək' manbışde otxhuniys g'iviyxhar vuxha. Mançil-allad kaahinaaşe con cigabı massa hele deş. ");
INSERT INTO tkr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufee milletık'le eyhen: – Həşde şunab, vuşun cigabıd zı fironus alişşu. Haane toxum, alyapt'ı ooze. ");
INSERT INTO tkr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Suk saа'ang'a xhonçuna sa pay fironus qevle. Avxuna yoq'uble payıb oozasiy ooxhanas, şosiy vuşde xizanbışis vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Manbışe eyhen: – Yişda xərna, ğu şas yugvalla hav'u, ğu şi hapt'ıyke g'attivxhan hav'u. G'iyniyke şaqa şi fironun g'ular vob. ");
INSERT INTO tkr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusufee ezu alyadıynçina xhonçuna sa pay fironus qevleva Misirne cəmə'ətıs q'aanun gyuvxhu. Saccu kaahinaaşe ezu alyadıynçina xhob'esda pay fironus qudyoole vuxha. Məxbına q'aanun Misir g'iynab vobna. ");
INSERT INTO tkr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","İzrailyna nasıl Misireene Goşen avxu, karana vuxha. Manbı maa'ab geeb qeebaxhe. ");
INSERT INTO tkr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaaq'ub Misir yits'ıyighalle (17) senna axva. Mang'vee vəşşe yoq'ts'ale yighılle (147) sen hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","İzrailyna qik'asda gah k'ane qooxheng'a, mang'vee cuna dix Yusuf qort'ul eyhen: – Vas zı ıkkanxhee, xıl yizde umayk avqa gixhxhı, k'ın g'assır cuvab hele: zas yugvalla hee'e, yizda nyaq'v Misir hımaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Zı qik'uyng'a Misirğançe qıkkee, yizın dekkar nyaabiy nyuq'vneeqa k'yav'u, zınar maa'ar k'eyxhe. Yusufee mang'us inəxüd cuvab qele: – Zı, ğu nəxdiy eyhe, həməxüdud ha'asın. ");
INSERT INTO tkr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Mang'une cuvabıs dekkee eyhen: – Zas k'ın g'assre. Mang'veeyid k'ın g'iysaran. İzrail vuc g'alirxhuyne karane vuk'lek qirzıl, Allahıs düə haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sabara gahbı ılğeeç'umee, Yusufuk'le uvhuyn: – Dek ık'arır. Mang'vee cuna q'öyre dix Menaşşeyiy Efrayim cuka alyapt'ı, dek g'acesva yəqqı'lqa gexha. ");
INSERT INTO tkr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yaaq'ubıs xabar g'uxoole: – Haane yiğna dix Yusuf vasqavur ı'qqə. İzrailik'le man g'ayxhı, gucuka vuc g'alirxhuyne tülee'ar giy'ar. ");
INSERT INTO tkr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaaq'ubee Yusufuk'le eyhen: – Gırgın əxəna Allah Kana'anne cigeene Luzee zas gyagu xayir-düə huvu, ");
INSERT INTO tkr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","inəxüd uvhu: «İlekkende Zı yiğna nasıl geeb qaa'as, hexxaa'asda, vake xədın xalq' g'alya'as. Vale qiyğad vake g'abıynbışis man cigabı hammaşiys heles». ");
INSERT INTO tkr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Həşdiyle q'öyre yiğna dix, zı inyaqa qalesse, Misir yedike vuxhaynbı yizınbı vuxhes. Efrayimiy Menaşşe, Ruveniy Şimon xhinne yizınbı vuxhes. ");
INSERT INTO tkr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Manbışile qiyğa vake g'abıyn uşaxar yiğınbı vuxhes. Manbışilqa gexhan cigabımee Efrayimıleyiy Menaşşeyle ılğeeç'es. ");
INSERT INTO tkr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Zı inəxüd yizda Raahile qiyk'uva ha'a. Yizda Raahile zı Paddan-Arameençe siyk'alang'a, Kana'anne ölkee Efratısqa hiviyxharne cigee qiyk'u. Mana maacar Efratne yəqqə k'eyxhı. Efratın g'iyniyn do Bet-Lexem vodun. ");
INSERT INTO tkr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","İzrailik'le Yusufun dixbı g'avcu, qiyghanan: – İnbı vuşbune? ");
INSERT INTO tkr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufee dekkıs inəxüd cuvab qele: – Allahee inyaa zas huvuyn dixbı vob. İzrailee eyhen: – Manbı zasqa qavaale xayir-düə hevles. ");
INSERT INTO tkr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","İzrail q'əsniy qıxha, mang'une uleppışik'le yugda g'ece deşdiy. Yusufee dixbı dekkısqana qaa'a, dekkeeyib manbı xhılibışeeqa sav'u, ubbabı ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Qiyğa İzrailee Yusufuk'le eyhen: – Yizde fıkreeqacad qidyayleyiy yiğın sayid aq'va g'eceva, haane Allahee yiğın dixbıb zak'le haaguynbı. ");
INSERT INTO tkr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufee dixbı dekkıne q'aratsaysse g'avşu, mang'une ögiyl ç'iyelqamee k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Qiyğa Yusufee Efrayim ulyozara'ana cune sağne sural, İzrailinıd man solun sura eyxhe, Menaşşeer cune solne, İzrailyneer sağne sural ulyozara'a. Qiyğa manbı dekkısqana qaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","İzraileemee sağın xıl hotku, k'ınne nevayne Efrayimne, solun xılymee xərne nevayne Menaşşeyne vuk'lelqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Qiyğa İzrailee Yusufus xayir-düə hoole: – Yizde dekkaaşe İbrıhımeeyiy I'saq'ee ı'bəədat ha'ane Allahee, G'iyniyne yiğılqamee zı havacıne Allahee, ");
INSERT INTO tkr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Zı gırgıne pisvalybışike g'attixhan hı'iyne malaaikee, Havaasre ine uşaxaaşisıb xayir-düə hevlecen! Yizın doyud, yizde dekkıneyiy cune dekkın İbrıhımıniy I'saq'ın dobıd manbışile k'ena yik'el qale'ecen. Ç'iyene aq'val manbışda nasıl geeb quvxhecen. ");
INSERT INTO tkr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufuk'le dekke sağın xıl Efrayimne vuk'lelqa gixhxhı g'acumee, man mang'une yik'eençe eyxhe deş. Mang'us dekkın xıl Efrayimne vuk'lele alyat'u, Menaşşeyne vuk'lelqa gixhxhes ıkkiykan. ");
INSERT INTO tkr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufee dekkık'le eyhen: – Dek, ğu ha'an qotkuda eyxhe deş. Şena ts'erriyna dix eyxhe, sağın xıl mang'une vuk'lelqa gixhxhe. ");
INSERT INTO tkr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Dekmee, mang'vee eyhençilqa qidyarı, eyhen: – Ats'an dix, zak'le ats'an. Mang'une nasılıked xədın millet g'ales, manar qıvaats'ana ixhes. Saccu mang'una k'ınna çoc mang'uler qıvaats'ana ıxha, mang'une nasılıke sa deş, geedın milletbı g'ales. ");
INSERT INTO tkr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Mane yiğıl Yaaq'ubee manbışis xayir-düə hoole: – İzrailin vuşun dobu xayir-düə hooleng'a, ağmiş ha'as: «Hasre ğu Allahee Efrayimiy Menaşşe xhinne hee'ecenva!» eyhes. Mang'vee məxür Efrayim Menaşşeyle ooqana ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","İzrailee Yusufuk'le eyhen: – Yizın qik'asın yiğbı k'ane qeetxheeyid, Allahee şu yik'el hivxanaa'as deş, şu dekkaaşine cigabışeeqa savaak'al haa'asınbı. ");
INSERT INTO tkr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Vas çocaaşile hexxada zı Şekem axtın ciga hele. Zı mana Emorğançenbışde xılençe yizde g'ılıncikayiy vukkuka g'avşu. ");
INSERT INTO tkr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yaaq'ubee dixbı qopt'ul eyhen: – Yizde k'anyaqa savaale, vuşde vuk'lelqa qalesınbı zı yuşan ha'as. ");
INSERT INTO tkr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yaaq'ubın dixbı, sabı zal k'ırı alixhxhe, Vuşde dekkıl İzrailir k'ırı gyaqqe. ");
INSERT INTO tkr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruven, ğu yizda ts'erriyna dix, ğu yizda guc. Ğu yedike zı mek'varanang'a taq'atıkanang'a ıxha. Ğu gırgıng'ule xərna, qıvaats'ana vor. ");
INSERT INTO tkr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ğu xhyanık akar sa'as-qa'as əxə deş. Vak'le man ats'axhxhe, ğu yik' hı'ı yizde tyuleeqa k'iç'uva, yizde xhunaşşeeşine sang'ıka g'alirxhuva, vake xərna ixhes deş! ");
INSERT INTO tkr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Şimoniy Levi çocar vob, manbışe qəlasın ha'asva g'ılınc xılyaqa alyaat'a. ");
INSERT INTO tkr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Manbı qəlıkanang'a adamer gyabat'a, yik'es ıkkanang'ad manbışin həyvanar kara idyalesın xhinne qa'a. Manbışe ək'elee aqqıyn karbı zı ha'as deş, Zı manbışika sarçes deş. ");
INSERT INTO tkr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Fığan haa'ane manbışde qəlbışisiy xıl ts'ıts'dyaa'ane bahaliyvalis bed-düə vuxhena. Zı manbışike g'abıynbı sacigeeqa savaales havaasaras deş, İzrailvolle oot'alasınbı. ");
INSERT INTO tkr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahud, yiğne çocaaşe ğu axtı qa'as, duşmanaaşina gardan yiğne xıle vuxhes, dekkın dixbıb vas k'yoozaras. ");
INSERT INTO tkr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yizda dix, Yahud, ğu k'on qoodu-soodu qööne mek'vne aslanık akar. Ğu manzil haa'ane şirık akar, horku-qorku ç'iyel g'ılexha, Şavusse şir g'udokana'as əxəyee? ");
INSERT INTO tkr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Paççahiyvalla Yahudne xılençe mısacab əlyhəəs deş. Gırgıne gahbışil vuk'lek vukkiy mang'une nasılınbışisse mebınbışilqa ılğeç'es deş. Nimeeletteyiy gırgın milletbı k'yozarasda vake paççah g'idyarı. ");
INSERT INTO tkr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yahudıqa manimee xətta t'ımılen tayangbı eyxhe, mang'us manbı qidiykkın cuna əməleb çik avt'alas vəəxəna, çike hı'iyne çaxıree tanalinbıd hoğalas əxənbı. ");
INSERT INTO tkr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mang'une uleppışin adın ciga çaxırıle k'ışşeyda, silibıd niknele cagvarada ixhes. ");
INSERT INTO tkr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zevulunun cigad deryahne mıglek ixhes, maa'ad gamıbı ileezaras, mang'un ciga Sidonnee şaharılqa hixharas. ");
INSERT INTO tkr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Xurcunbı mıgal alyaat'u, manzil haa'ana İssaxar taq'atıkane əməleyk akar. ");
INSERT INTO tkr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mang'us vuc manzilis ulyorzuliyn ciga yugda qadı, maana nyaq'v cus vukkanəxüb g'avcu, mang'vee yı'q' k'yozarı'ı mebınbışis iş haa'ana. ");
INSERT INTO tkr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani İzrailyne nasılbışda sa vob, mang'vee cune milletıs məhkama ha'as. ");
INSERT INTO tkr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani yəqqı'ne mıglekna xoçe xhinne ixhes. Balkanne guvuyk üvxü, çilyna yı'q'ı'hiyna g'ı'xə'əne. ");
INSERT INTO tkr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Rəbb, zı gozet ha'an Ğu mısayiy zı duşmanaaşike g'attixhan ha'as! ");
INSERT INTO tkr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Mebınbı Qadın cigabı q'əra qa'as ables, mang'veeyib manbı g'e'eebaşeng'a q'əra qaa'as. ");
INSERT INTO tkr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aşerne cigabışee otxhuniy barakayka ixhes, mang'vee paççahaaşisıd otxhuniy alles. ");
INSERT INTO tkr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali g'avkuyne maralık akar, mang'uke g'abıynbı geeb micagınbı vuxhes. ");
INSERT INTO tkr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufmee, xhyan ı'lqəəne cigaysneene, bıtağbıd cabırıle g'alysikkıyne tayangık akar. ");
INSERT INTO tkr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Duşmanar mang'ulqa qəlıka vukkaaşika k'yoohar, ");
INSERT INTO tkr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","mang'un xıleppı gucuka vodva mang'vee vuk xıle it'umda aqqaqqa. Mang'us guc hoole vuxha Yaaq'ubee ı'bəədat ha'ane Allahee. Allah İzrailiqa çoban cune syuriyqa ilyakkan xhinne ilyakka. Mana manbışda Suva vobna. ");
INSERT INTO tkr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yiğne dekkee ı'bəədat ha'ana Allah hasre vas kumagxhecen, Hasre Mang'vee vas xayir-düə hevlecen, xəəne-ç'iyeyne xhyanbışike ğu g'ıts'mayk'vancen, vas geeb uşaxaariy çavra-vəq'ə helecen. ");
INSERT INTO tkr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Yiğne dekkına xayir-düə barakatnane çolbışileb geeb vob, ğu manisa çocaaşile qıvaats'anava, hasre man gırgın xayir-düəbı yiğınbı ixhecen. ");
INSERT INTO tkr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin bahalne ümulyuk akar, miç'eeb k'on givk'u opxhan, exhalid ing'uke-şeng'uke g'ayşuyn bit'al ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","İna ələpqı'na yits'ıq'vəble (12) nasıl İzrailyna vobna. Dekkee dixbışde gırgıng'us, cus sik'ına inəxübna xayir-düə huvu. ");
INSERT INTO tkr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Qiyğa Yaaq'ubee dixbışilqa əmr haa'a: – Zı sık'ınne gahıle qik'asda, zas yizde xizanısqa, zale ögee hapt'ıynbışde k'anyaqa əlyhəəs ıkkan. Zı Q'etbışda eyxhene Efronne çoleene mağaree k'eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Mana mağara Kana'anne ölkeene Mamrе eyhene cigays k'anene Maxpelayne çolee vobna. İbrıhımee mana mağara nyaq'v haa'asdemee Efronusse çoluka sacigeeniy alivşu. ");
INSERT INTO tkr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Maa'abniy İbrıhımiy cuna xhunaşşe Sarra, I'saq'iy cuna xhunaşşe Rivq'a k'evxhu. Zı Leayer maa'ar k'eyxhı. ");
INSERT INTO tkr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Man çolud, maana mağarab Q'etbışisseniy alivşu. ");
INSERT INTO tkr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaaq'ubee dixbışis əmr hav'u g'attirxhınmee, g'elybı tyuleeqa sı'ı qek'ana. Məxür mana ahaleeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusuf dekkılqa k'yorzul geşşe-geşşe mang'us ubbabı ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mang'vee cune g'ulluxçiy-doxturaaşilqa dekkın mayit mumyelamişe'ecenva əmr haa'a. Doxturaaşed İzrailin mayit mumyelamişa'an. ");
INSERT INTO tkr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Mana iş doxturaaşe yoq'ts'al (40) yiğna haa'a. Mumyelamişa'as manimena vaxtniyxhe vukkiykanna. Yights'al (70) yiğna misirğançenbı mang'uqa gyaaşe. ");
INSERT INTO tkr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ak'ın yiğbı ç'əveetxhamee, Yusufee fironne insanaaşik'le eyhen: – Zı vuşde ulen aqqıxheene, fironuk'le eyhe, ");
INSERT INTO tkr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","dekkee zasqa k'ın g'assaras alikkı, uvhuynniy: «Zı qik'asda xhinne vor. Kana'anne ölkee zı zasda mağaree nyaq'v hav'u. Zı maa k'eyxhe». Həşde fironee zı hasrecen, dek k'eyxhı, yı'q'əlqa sak'alas. ");
INSERT INTO tkr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fironee eyhen: – Dekke nəxdiy vasqa k'ın g'assaras alikkı, həməxürur mana k'eyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Məxür Yusuf ayk'anna dek k'eyxhas. Yusufuka sacigee fironun delesın insanar, Misirın ağsaqqalar, ");
INSERT INTO tkr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusufneyiy dekkıne xaabın gırgınbı, çocar havayk'an. Manbışe saccu çavra-vəq'əyiy uşaxar Goşen g'alyaa'a. ");
INSERT INTO tkr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Manbışika sacigee balkanaaşil alepxıynbı, dəv'əys hı'iyne daşk'abışe gyuv'uriynbı yəqqı'lqa qığeebaç'e. Maa qəpqəs-ələpqəs devxhesınmeen insanar vooxhe. ");
INSERT INTO tkr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Manbı İordan damayne şene sural, Atad eyhene cigeene atteeqa (suk məttaa'an ciga) hipxhıriyng'a, axtıne nıq'ıka gyaaşe giviyğal. Ma'ab Yusufee dekkıs yighılle yiğna ak' hoole. ");
INSERT INTO tkr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mane ölkayne insanaaşik'le, Kana'anğançenbışik'le, Atadee hoolena ak' g'avcumee, uvhuyn: «Misirbışiqa xədın geşşuyud». İordan damayne k'anene cigays çil-alla Avel-Mitsrayim (misirbışin geşşuy) do giyxhe. ");
INSERT INTO tkr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaaq'ubne dixbışe gırgın dekke uvhuyn xhinne ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Mana manbışe Kana'anne ölkeeqa qarı, Mamreys k'anene Maxpela eyhene çoleene mağaree'ar nyuq'vneeqa giyxhe. Mana mağara İbrıhımee çoluka sa cigee cus nyaq'v haa'asın ciga ixhecenva, Q'etbışda eyxhene Efronukeniy alivşu. ");
INSERT INTO tkr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Dek k'eyxhıyle qiyğa, Yusuf cune çocaaşika, dekkıne ak'ıs abıyne gırgınbışika sacigee Misirqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Dek qik'uyle qiyğa, Yusufne çocaaşe sana-sang'uk'le eyhen: – Yusufee şi hı'iynçina qəl yik'el avqu vuxhee, mana qəl şake qığaahas vukkiykınee, şi hucoone ha'as? ");
INSERT INTO tkr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Mançil-allab manbışe Yusufus xabar g'axuvu: – Dekkee qik'asse, şak'le uvhuynniy: ");
INSERT INTO tkr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Yusufuk'le inəxüd eyhe: „Hucoone ixhes, çocaaşe vas hav'una pisvalla, yik'el hivxhanee'e“». Həşded şi vake heqqa, hucoone ixhes, yiğne dekkee ı'bəədat ha'ane Allahee g'ulaaşin bınahbı yik'eliyxan he'ecen. Man eyhenbı Yusufuk'le g'ayxhımee, geşşe giyğal. ");
INSERT INTO tkr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Qiyğa çocar mang'usqa abı, ç'iyelqamee k'yobzur, «Şi həşdiyle yuğun g'ular vobva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yusufee manbışik'le eyhen: – Zı nya'a Allahne vor, şu zale qəvəəq'ənas? ");
INSERT INTO tkr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","İlyaake, şos zas pisvalla haa'as vukkiykın, Allaheeyib mana yugvalis qav'u. G'iyna şok'le g'ecenbıyiy xəppanane insanaaşina ı'mı'r g'attivxhan he'ecenva Allahee məxüd hı'ı. ");
INSERT INTO tkr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Mançil-alla qıməəq'ən zı şoqar vuşde uşaxaaşiqar ilyakkasda. Yusuf manbışiqa g'üvənara yuşanı'ı manbışis yik'bı hele. ");
INSERT INTO tkr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusuf cuneyiy dekkıne xizanıka Misir axva. Yusufee vəşşe yits'ılle (110) sen ha'a. ");
INSERT INTO tkr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Mang'uk'le Efrayimın uşaxarıb nevabıb g'oocenbı. Menaşşeyne dixene Maxiriyne uşaxaaşisıb mang'vee dekvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Sabara gah ılğevç'uyle qiyğa Yusufee çocaaşik'le eyhen: – Yizda qik'asda gah k'ane quvxheeyib, Allahee şu yik'el hivxanaa'as deş. Allahee şu ine ölkeençe qığaa'asınbı. Mang'vee k'ın g'assır İbrıhımıs, I'saq'ıs, Yaaq'ubıs hevlesva uvhiyne cigeeqa şu quvkees. ");
INSERT INTO tkr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Qiyğa Yusufee İzrailybışisqa k'ınbı g'assaras alikkı, eyhen: – Allahee şos huvuyn cuvab mısacad yik'el hixan ha'as deş. Şunad əlyhəəng'ə, yizın bark'vbı inyaa g'ılyma'a, şoka qıkkee. ");
INSERT INTO tkr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusuf vəşşe yits'ılle (110) sen hı'ı qek'a. Mana Misiree mumyelamiş hı'ı, tabuteeqa giyxhe.");
INSERT INTO tkr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","İzrailyne (Yaaq'ubne) xizanbışika sacigee cuka Misirqa qabıyne dixbışin dobı inbı vod: ");
INSERT INTO tkr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruven, Şimon, Levi, Yahud, ");
INSERT INTO tkr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","İssaxar, Zevulun, Benyamin, ");
INSERT INTO tkr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Qad, Aşer. ");
INSERT INTO tkr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yaaq'ubıke g'arına yights'al (70) insan ıxha. Yusuf manke Misirniy vor. ");
INSERT INTO tkr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ooğançe geed gahbı ılğeeç'umee, Yusufur cun çocarıb coka vooxhen cone gahın insanarıb habat'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","İzrailybımee geeb barakatnanbı vuxha, g'abı hexxebaxhenbı. Manbı geeb qeepxha bıkırna ölka gyavts'aa'ana. ");
INSERT INTO tkr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Xılece gahbı ılğeeç'umee, Misirıs xəbvalla Yusuf dyats'ane sa paççahee haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Mang'vee cune xalq'ık'le eyhen: – İlyaakende, İzrailybı şale geeb qepxha, şaleb gucuka vob. ");
INSERT INTO tkr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Qudoora ək'elikan sa kar ha'as, deşxheene manbı sık'ılbab geeb qeepxhes. Dəv'ə gibğılee, manbı yişde duşmanaaşika sapçı şalqa ables. Qiyğale xhineyib yişde ölkeençe qığeepç'ı əlyhəəsınbı. ");
INSERT INTO tkr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Misirbışe İzrailybışda ı'mı'r dağam qa'asva manbışike nukarar hav'u, manbışil ooqa con insanar giviyxhe. Mane cone insanaaşeb manbışis yı'q' haqvara'asda xhinnena iş hoole. Məxüd ıxha İzrailybışe fironus Pitomiy Ramses donan şaharbı ali'ı. Mane şaharbışee manbışin anbarbı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","İzrailybı nimee hopç'un-g'opç'uneyib manbı sa hamanimegab geeb qeebaxhe vuxha. Mançile Misirbı qəpq'ı'n İzrailybı ");
INSERT INTO tkr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","qidviykkın işlemişepxhes ulyooka. ");
INSERT INTO tkr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Misirbışe İzrailybışisqa nyaq'vuke karpıçbı ha'as, cigabı alya'as, çoleedın yı'q'ı'n işbı g'acesniy ulyookanbı. Məxüb manbışe İzrailbışda ı'mı'r dağam qav'u. İzrailybı qidvikkın gırgın yı'q'ı'n işbı manbışisqa ha'as ilekka ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misirne paççahee cühüt'yaaşis ebaçer (uşax uxoxang'a kumag ha'ane) Şifrayiy Pua donane yadaaşik'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","– Cühüt'yaaşine xhunaşşeeşis uşaxar vooxheng'a yugba ilyaake, gade ixheene gik'e, içiy yixheene g'alerçe. ");
INSERT INTO tkr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ebaçer Allahıle qəvəyq'ənanbı vooxhee, manbışe paççahe uvhuyn ha'a deş. Manbışe gadebı üç'übba g'alyaa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Paççahee ebaçer cusqa qopt'ul qiyghanan: – Nya'a şu məxüd ha'a? Nya'a gadebı üç'übba g'alyaa'a? ");
INSERT INTO tkr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ebaçerşe eyhen: – Cühüt'yaaşin yedar misirbışin yedar xhinne deşub, manbı taq'atıkavub, şi hivxharassecad uxoxa vod. ");
INSERT INTO tkr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Mançil-allar Allah ebaçeeşiqa yugra eyxhe. Məxüd milletıd geed qexhe, çina gucub hexxooxhena. ");
INSERT INTO tkr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ebaçer Allahıle qəvəyq'ənva, Allahee manbı xizanınbı, uşaxınbı haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Fironee cune milletılqa əmr haa'a: – Cühüt'yaaşis vuxuyn gırgın gadebı Nil eyhene dameeqa dağee'e! Vuxhayne içeeşikme simoot'a, üç'übba g'alee'e. ");
INSERT INTO tkr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Leviyne nasılıkene sa cühüt'ee, cune nasıleençe cusda xhunaşşe hee'e. ");
INSERT INTO tkr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Mana vuxhne ayxu mang'us dix uxu. Uşax micagda g'acu, məng'ee man uşax xheyible vazna dyugul ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mançile hexxada dyugul ha'as dəxəmee, məng'ee q'amışeke hav'una ç'emç'e alyapt'ı, çilqa g'ır qadğu, uşaxıd caqa gixhxhı Niline mıglek alyadıyne q'amışeeqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Uşaxık hucooyiy ixhesva ileeka, uşaxna yuçu sik'irra şaqana ileezar. ");
INSERT INTO tkr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Fironna yiş əyeexərasva damaysqa geeç'e, cen guluxçerıb damayne mıglek ı'ğviykar vooxhe. Məng'ı'k'le q'amışee ç'emç'e g'ooce. Mana alyapt'as cena guluxçiy g'ıxeele. ");
INSERT INTO tkr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ç'emç'eyn ghal ulyot'ulmee məng'ı'k'lee maa uşax gece. Gade geşşe g'acuys, məng'ı'na rəhı'm qabı eyhen: – İn cühüt'yaaşin uşaxıd. ");
INSERT INTO tkr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Manke uşaxne yuçee fironne yişşeke qiyghanan: – Yiğnemee hark'ın mana gyoqa'asda cühüt'yaaşina sa zəiyfa ayrene? ");
INSERT INTO tkr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Fironne yişşee məng'ı'k'le «Hiyek'neva» eyhe. Yuçee hark'ın uşaxna yed ayreele. ");
INSERT INTO tkr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fironne yişşee məng'ı'k'le eyhen: – İn uşax alyat'u yizdemee gyoqe'e. Mançil-alla zı vas hək' qevles. Zəiyfee uşax alyaat'u cene xaa gyoqa'an. ");
INSERT INTO tkr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Uşax xət qıxhamee, məng'ee mana qıkkekana fironne yişşesqa. Fironne yişşee mana dixvalis alyarat'a. Məng'ee uşaxın do Mısa (qığavhuna) gixhxhı eyhen: – Zı mana xhinençe qığavhu. ");
INSERT INTO tkr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mısa xər qıxha cune xınıbışisqa hark'ınmee, mang'uk'le, cune milletın nimee yı'q'na işiy haa'ava g'ecen. Mang'uk'le maa'ar, cuna xını cühüt' misirğançeng'vee geta g'ece. ");
INSERT INTO tkr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Hiqiy-alla ilyakkı vuşucar g'idecumee, Mısee mana misirğançena gik'u g'umeeqa dyugulya'a. ");
INSERT INTO tkr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Qinne yiğıl mang'uk'le q'öyre sana-sang'uka aldaxhvanan cühüt'yar g'ooce. Mang'vee getang'uke qiyghanan: – Nya'a ğu yiğne milletna insan geta? ");
INSERT INTO tkr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mane insanee eyhen: – Şavaane vake yişda xərnayiy şas məhkama ha'ana hı'ı? Şena misirğançena gik'uyn xhinne, deşxhee, vas zınarne gik'as ıkkan? Mısa qərq'ı'n culed-alqa eyhen: – Mıts'an, zı hı'iyn ats'axhxha ixhes. ");
INSERT INTO tkr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Fironuk'le Mısee hı'iyn g'ayxhımee mana gik'as ıkkiykan. Mısa fironuke hixu, Midyan eyhene ölkeeqa qarı sa kahrızne k'ane axva. ");
INSERT INTO tkr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Yiğbışde sa yiğıl Midyanaaşine kaahinna yighıyre yiş dekkıne vəq'əbışis xhyan helesva maqa abayle. Manbışe kahrızeençe xhyan alqı'ı nəybı gyatsts'a'a eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Maqa qabıyne çobanaaşis içer g'eheebşes vukkiykan. Mısayk'le man g'acu, içeeşineme vuç ögeeqa huvu manbışin vəq'əbı xhinen ats'ya'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","İçer cone dekkısqa Reuelisqa sapk'ılmee, mang'vee qiyghanan: – Nya'a şu g'iyna zaraba sapk'ıl? ");
INSERT INTO tkr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Manbışe eyhen: – Misirğançene sang'vee yişdemee vuc ögiylqa huvu, şi çobanaaşine xılençe g'attivxhan hav'u. Qiyğa mang'vee yişdemee yişin vəq'əbı ats'esın xhyan kahrızeençe alqı'ı. ");
INSERT INTO tkr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Mang'vee yişşaaşike qiyghanan: – Mana insan nyaane vor? Nya'a şu mana g'alerçu? Qot'le, arı şakasana kar oxhnecen. ");
INSERT INTO tkr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Manbışer Mısa cong'ə qoyt'alna. Dekke eyhen: – Mısa, şing'əəcar axve. Mısaysır ıkkiykanna manbışəəng'ə axvas. Sabara gah ılğevç'uyle qiyğa, mang'veeyir Mısays cuna yiş Tsippora xhunaşşe yixhecenva heele. ");
INSERT INTO tkr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Məng'ee Mısays dix uxu. Mısee eyhen: – Zı menne cigeençe qarına xhinne axva vor Mançil-alla mang'vee dixen do Gerşom (menne cigayna) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ooğançe geed senbı ılğeeç'uyle qiyğa Misirna paççah qek'ana. İzrailybışe nukariyvalee uts'ur ts'ıts'a'a, kumag heqqa eyxhe. Manbışe ts'ıts'a'an nukariyvaleedın uts'ur Allahık'le g'eceniy vod. ");
INSERT INTO tkr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Allah manbışe ts'ıts'a'ane uts'uruqa ilyakka-ilyakka İbrıhımıka, I'saq'ıka, Yaaq'ubıka hav'una mugaavile yik'el qavalyaa'a. ");
INSERT INTO tkr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Allahık'le İzrailybı nukarar vuxhay g'acu manbışilqa rəhı'm qavayle. ");
INSERT INTO tkr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mısee cune abbatteyn, Midyanaaşine kaahinın syuru uxhiyxhana'a eyxhe. Mang'une abbatteyn düğəlıd İtron eyhe. Sayəqees mang'vee man syuru əq'ənane sahreeqa, Allahne suvaysqa Xorevisqa ıkekka. ");
INSERT INTO tkr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Sayir mang'us gyotxhanne ğıç'eençe Rəbbina malaaik gyagva. Mısayk'le ts'ayın aqqıyn ğı'ç'iy gidyotxhan g'acumee, ");
INSERT INTO tkr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","mang'vee culed-alqa eyhen: – Hinnalan hark'ın mane curayne işiqa ilyakkas, nya'asiy man ğı'ç'iy gyotxhun ç'əvcad dexhe. ");
INSERT INTO tkr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Rəbbik'le Mısa ilyakasva k'ane qıxha g'acumee, ğıç'eençe mang'ulqa ona'an: – Mısa, Mısa! Mang'veeyir «Hooyva» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Allahee eyhen: – K'anyaqa qımexhe. G'elilinbı g'ayşe. Ğu ulyorzuliyn ciga er ciga vod. ");
INSERT INTO tkr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Zı, yiğne dekkeeyid, İbrıhımeeyid, I'saq'eeyid, Yaaq'ubeeyid ı'bəədat hı'ına Allah vor. Man g'ayxhı Mısee aq'va aqqaqqa, Allahıqa ilyakkas qəyq'ənna. ");
INSERT INTO tkr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Rəbbee eyhen: – Zak'le Yizde milletın Misir opxhanna əq'üba vaats'ana. Manbışil ooqa givxhiyne insanaaşine xıleke höödəxənıd Zak'le ats'an, manbışe kumag heqqad Zak'le g'ayxhin. ");
INSERT INTO tkr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Zı mançil-alla inyaqa arı. Həşde Zı manbı Misirbışde xılençe g'attivxhan hav'u mane ölkeençe qığaa'asınbı. Qiyğaleb sa xənne, kar geednane, nyakiy itv gyodatstsene cigabışeeqa quvkees. Maa'ab həşde Kana'anbı, Q'etbı, Emorbı, Perizbı, Q'ivbı, Yevusbı aaxva. ");
INSERT INTO tkr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","İzrailybışin gyaaşuy Zak'le g'iyxhen. Zak'le Misirbışe manbışis hoolena əq'üba g'oocena. ");
INSERT INTO tkr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Mançil-allar Zı ğu fironusqa Yizın millet İzrailybı, Misirğançe qığe'eva g'ıxele. ");
INSERT INTO tkr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mısee Allahık'le eyhen: – Nya'a, zı vuşune vor, fironusqa hark'ın İzrailybı Misirğançe qığaa'as? ");
INSERT INTO tkr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Allahee eyhen: – Zı vaka ixhes. Zı ğu g'axuvuva inçike ats'axhxhes: ğu millet Misirğançe qığavhuyng'a ine suval şu Zas ı'bəədat ha'as. ");
INSERT INTO tkr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mısee Allahık'le eyhen: – Zı İzrailybışisqa hark'ın uvheene «Vuşde dekkaaşe ı'bəədat hı'ıne Allahee zı şosqa g'axuvu», manbışe qiyghanasın: «Mang'un do hucooyiy?» Hucoovane zı manbışis alidghıniy qeles? ");
INSERT INTO tkr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Allahee mang'us inəxüd cuvab qele: – Zı Vuşuyiy, Manar vorna. İzrailybışik'le eyhe: «Zı Vorna» eyheng'vee vuşde k'anyaqa g'axuvu. ");
INSERT INTO tkr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Allahee Mısayk'le meed eyhen: – İzrailybışik'le eyhe: «YAHVE (Rəbb), vuşde dekkaaşe, İbrıhımee, I'saq'ee, Yaaq'ubee ı'bəədat hı'ıne Allahee zı şosqa g'axuvu». Yizın gırgıne gahbışil do YAHVE ixhes. Nasılbı nimee badaletxheyid Zalqa məxüd ona'as. ");
INSERT INTO tkr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Hak'ne İzrailin ağsaqqalar sav'u manbışik'le eyhe: «Rəbbee, vuşde dekkaaşe, İbrıhımee, I'saq'ee, Yaaq'ubee ı'bəədat hı'ına Allah zas gyagu uvhuyn: «Zı şoqa ilyakkaniy vor, Zak'le g'avcuna şu Misir opxhanna əq'üba. ");
INSERT INTO tkr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Zı şos cuvab hele, şu Misireene əq'übayke g'attivxhan hav'u Kana'anbışde, Q'etbışde, Emorbışde, Perizbışde, Q'ivbışde, Yevusbışde nyakiy itv gyodatstsene cigabışeeqa quvkees“». ");
INSERT INTO tkr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","İzrailyne ağsaqqalaaşe val k'ırı alixhxhesın. Ğunar manbışika sacigee Misirne paççahısqa hark'ın eyhe: «Cühüt'yaaşina Allah, Rəbb şas gyagu. Şi xhebılle yiğna yəq apk'ın sahree yişde Allahıs, Rəbbis q'urbanbı allya'as». ");
INSERT INTO tkr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Zak'le ats'an Misirna paççah gucuka ilydekkee mang'vee şu g'avkvas deş. ");
INSERT INTO tkr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mançil-allab Zı Misirılqa xıl alivka'as, həşdilqamee g'idiyxhiyn yiğbı manbışilqa allya'as. Mançile qiyğa mang'vee şu g'avkasınbı. ");
INSERT INTO tkr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Zı məxüd ha'as şu manbışde ulen avqecen, şu q'ərane xıleka əlyhəəs gimabak'acen. ");
INSERT INTO tkr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Çühüt'yaaşine yedaaşe misirbışde yedaaşike, hasre k'ınəəğəykeyiy nuk'rayke hı'iyn karbıyiy tanalinbı heqqecen. Man karbı şu vuşde dixbışilqayiy yişbışilqa qa'as. Şu məxüb Misirbı q'əra qaa'as. ");
INSERT INTO tkr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mısee inəxdun alidghıniy qele: – Sayid manbışis zal k'ırı alixhxhes diykkıne, zal haydepxha uvheene: «Rəbb vas gyagu deşva»? ");
INSERT INTO tkr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Manke Rəbbe eyhen: – Yiğne xıledın hucoone? Mısee eyhen: – Əsaa. ");
INSERT INTO tkr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Rəbbee eyhen: – Man ç'iyelqa dağeççe. Mısee ç'iyelqa dağetçumee, əsaa xoçelqa siyk'al. Mısar çisse hexvana. ");
INSERT INTO tkr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Rəbbee Mısayk'le eyhen: – Xıl hotku mana bı'ttike avqve. Mısee xıl hotku xoçe bı'ttike avquyng'a, mana xıle əsaalqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Rəbbee eyhen: – Ğu man kar he'e, İzrailybı hayepxhecen Rəbb, manbışde dekkaaşee, İbrıhımee, I'saq'ee, Yaaq'ubee ı'bəədat ha'ana Allah, vas gyaguva. ");
INSERT INTO tkr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Qiyğa Rəbbee meed eyhen: – Xıl eqanaqa k'eççe. Mısee xıl eqanaqa k'eççu qığavhumee, mang'un xıl ık'arıke yiz xhinne cagvara qexhe. ");
INSERT INTO tkr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Qiyğa Rəbbee eyhen: – Xıl meed eqanaqa k'eççe. Mısee q'öd'es xıl eqanaqa k'eççu qığavhumee, mang'un xıl yug qexhe. ");
INSERT INTO tkr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Rəbbee eyhen: – Manbı yiğne ts'eppiyne əlaamatıl haydeepxhene, q'öb'esınçil vuxhesınbı. ");
INSERT INTO tkr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Sayid manbışe val k'ırı ilydiyxhı q'öd'esde əlaamatılib haydeepxhene, Nil eyhene dameençe xhyan alyat'u ç'iyelqa haç'e'e. Manke man xhyan ebalqa sak'alas. ");
INSERT INTO tkr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mısee Rəbbik'le eyhen: – Xudaavanda, zasse şenker uftanra yuşana'as əxı' deş, həşder Ğu zaka yuşanı'ıyle qiyğar əxə deş. Zı yı'q'ra, g'idiyğal yuşana'a. ");
INSERT INTO tkr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Rəbbee mang'uk'le eyhen: – Şavaane insanıs miz huvu? Şavaane insanıke lalıy g'idiyxhena ha'a? Şavaane insanıs uleppı huvu? Şavaane insan bı'rq' qa'a? Nya'a Rəbbee, Zı dişde man gırgın ha'a? ");
INSERT INTO tkr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Həşdiylemee hora hak'ne, Zı vas eyhesınıd xət qa'asın, yuşana'asıd kumag ha'asın. ");
INSERT INTO tkr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mısee eyhen: – Hucoone ixhes, Xudaavanda, merna insan g'axıle. ");
INSERT INTO tkr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Rəbbe Mısalqa qəl hav'u eyhen: – Nya'a Leviyne nasıleençena yiğna çoc Harun? Zak'le ats'an mana yugra yuşana'a. Həşde mana yiğne ögiylqa ı'qqə vor. Ğu g'acu mana şadxhesda. ");
INSERT INTO tkr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Çocuka yuşane'e, hucooyiy eyhes ıkkan mang'us xət qe'e. Zı vuşde q'öng'ussana yuşana'as kumag ha'asın, hucooyiy ha'as ıkkanvad xət qa'asın. ");
INSERT INTO tkr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Vas eyhes ıkkananbı, mang'vee insanaaşilqa hixhara'as. Ğunad mang'ulqa Yizın cuvab hixhar ha'as, manar yiğne cigee yuşan ha'as. ");
INSERT INTO tkr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","İn əsaa vaka aleet'e, ğu inçika əlaamatbı hagvas. ");
INSERT INTO tkr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mısa cune abbateysqa İtronusqa sark'ıl eyhen: – Hasre zı Misireeqa ı'qqəs, ilyakkas yizın xınıbı avxucabee? İtronee eyhen: – Yugna yəq vuxhena. ");
INSERT INTO tkr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Midyanee Rəbbee Mısayk'le eyhen: – Misirqa sak'le, ğu gik'as ıkkanan gırgınbı hapt'ıynbı. ");
INSERT INTO tkr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mısee dixbıyiy xhunaşşe əməlelqa gyav'u, Allahee uvhuyn əsaayid xılyaqa alyat'u Misirqa yəqqı'l gexha. ");
INSERT INTO tkr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Rəbbee Mısayk'le eyhen: – Ğu Misirqa sak'ımee Zı vas xət qı'iyn gırgın əlaamatbı fironusne he'e. Zımee mang'uke hı't'iy qa'as, mang'veeyid millet g'aykkas deş. ");
INSERT INTO tkr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ğu fironuk'le eyhe: «Rəbbee inəxüdud eyhe: «İzrail Yizda ts'erriyna dix vorna. ");
INSERT INTO tkr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Zı vak'le uvhuyn, Zas ı'bəədat he'ecenva Yizda dix g'aykke! Ğumee mana g'aykkı deş. Həşde Zı mançil-allar yiğna ts'erriyna dix gik'as“». ");
INSERT INTO tkr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Yəqqə xəm g'ahaane cigee Rəbb Mısaysqa arı, mana gik'as ıkkiykan. ");
INSERT INTO tkr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Mane gahıl, Tsiporee ek'na g'aye alyapt'ı dix sunnat hı'ı çike g'ayşuyn ç'ürüx Mısayne g'elybışik set'u eyhen: – Ğu həşde yizdemee ebana adamiy eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Məxüb Rəbbee mang'uke xıl ts'ıts'a'ana. Dix sunnat hı'il-alla Tsiporee Mısayk'le «Ebana adamiyva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Sabara gah ılğevç'uyle qiyğa, Rəbbee Harunuk'le eyhen: – Mısayne ögiylqa sahreeqa hak'ne. Harunus Mısa Allahne suvaysne qızaxxımee, mang'vee Mısays ubbabı ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mısee Harunus Rəbbee cuk'le gırgın uvhiynbıyiy hagveva uvhuyn əlaamatbı yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mıseeyiy Harunee İzrailin ağsaqqalar sav'umee, ");
INSERT INTO tkr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Rəbbee Mısayk'le uvhuyn gırgın kar Harunee yuşana'an. Qiyğaled mang'vee insanaaşine ögiyl man əlaamatbı hagva. ");
INSERT INTO tkr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","İzrailybı manbışilqa hayebaxhenbı. Rəbbik'le manbışe opxhanna əq'üba g'avcuna, manbı məxüb g'alepçes deşva, manbışik'le g'ayxhımee, İzrailybı gugaybışil gyuv'ur ı'bəədatbı ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mançile qiyğa Mısayiy Harun fironusqa abı eyhen: – İzrailyne Allahee, Rəbbee, inəxüdud eyhe: «Yizın millet g'aykke Zas sahree bayram he'ecen!» ");
INSERT INTO tkr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Fironee eyhen: – Rəbb vuşune vor, zı mang'ul k'ırı alixhxhı İzrailybı g'avkvas? Zak'le Rəbbir ats'a deş, İzrailybıb g'ooka deş. ");
INSERT INTO tkr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Manbışe eyhen: – Şas cühüt'yaaşina Allah gyagu. Şi g'avke, inçe xhebne yiğna yəq apk'ın sahree, yişde Allahıs, Rəbbis, q'urbanbı allya'as, Mang'vee şalqa yı'q'ı'n ık'arbı g'ıxmelecen, g'ılıncıka gimabat'acen. ");
INSERT INTO tkr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Misirne paççahee manbışik'le eyhen: – Mısayiy Harun, nya'a şu millet işıke ha'a? Hudoora vuşda iş g'avce! ");
INSERT INTO tkr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Həşdiylee millet geed qıxha, şosmee manbışe iş hidyav'u vukkan. ");
INSERT INTO tkr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mane yiğılycab fironee milletne vuk'lel ulyobzurinbışik'leyiy iş haa'as ulyokanbışik'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","– G'iyniyle şaqa mane milletıs karpıç ha'asın balybiy himele, havaasre hapk'ın cocad se'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Karpıçıd manbışike şene ögiylinmencad qeqqe. K'ıl qıma'a. Manbı tambalar vuxhal-alla ts'irbı ha'a: «Hapk'ın yişde Allahıs q'urbanbı alya'as». ");
INSERT INTO tkr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Manbışda iş hexxee'e iş hee'ecen, horbuşil k'ırı ilymiyxhecen. ");
INSERT INTO tkr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Milletne vuk'lel ulyobzurinbıyiy, iş haa'as ulyookanbı g'aqa qığeepç'ı İzrailybışik'le eyhen: – Fironee inva vod eyhe: «Zı şos balybiy heles deş. ");
INSERT INTO tkr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Havak'ne balybiy şos nençeyiy ıkkan se'e. İşib vuşda k'ıl qaa'as deş». ");
INSERT INTO tkr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Millet Misirvolle ehekkı gidyotxuyn balybiy sa'a eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Vuk'lel ooab ulyozrav'uynbışe manbı iş haa'as ulyooka eyhenniy: – Şi şenke şos balybiy heleng'ameena iş hee'e. ");
INSERT INTO tkr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Vuk'lelqa gyuvxhuyne İzrailybışkene ç'ak'ınbışike, fironne insanaaşe gyoota-gyoota qiyghan ıxha: – Nya'a şu sanıxhayiy g'iyna şene ögiylinmeen karpıç hıdi'ı? ");
INSERT INTO tkr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","İzrailybışiken ç'ak'ınbı fironusqa abı gyaaşenbı: – Nya'a ğu yiğne g'ulaşilqa ina ver ooxa? ");
INSERT INTO tkr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Balybiy yiğne nukaraaşis hele deş, karpıçmee ha'as ilekkan. İlekke yiğın nukarar nəxübiy gyoota! Bınah yiğne milletil vob. ");
INSERT INTO tkr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Fironee eyhen: – Şos işcab haa'as devkan! Mançil-allad şu eyhen: «Şi hapk'ın Rəbbis q'urban ablyaa'as». ");
INSERT INTO tkr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Hudoora işlemişepxhe. Şos balybiy heles deş, şumee ögiylinmeen karpıç ha'asıncad. ");
INSERT INTO tkr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","İzrailybışiken ç'ak'ınbışik'le «Yiğısiysın karpıç k'ıl qıma'ava» g'ayxhımee manbışis hayexhen, co dağamiyvaleeqa gyapk'ıva. ");
INSERT INTO tkr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Fironusse qığeepç'ımee manbışik'le Mısayiy Harun g'avcu, ");
INSERT INTO tkr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","eyhen: – Hasre Rəbbik'le şu hucooyiy hı'ıva g'acecen, şosda cazaa g'ats'ak'vnecen. Şu şi fironusiy cune insanaaşis g'umooce qav'u. Şi gyapt'ecenva, şucad vuşde xıleqa manbışisqa g'ılınc huvu. ");
INSERT INTO tkr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mısee Rəbbilqa aq'va aqqı eyhen: – Xudaavanda, nya'a Ğu milletilqa ina balyaa ablyav'u? Nişil-allane Ğu zı g'axuvu? ");
INSERT INTO tkr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Yiğne doyule fironusqa hark'ınne yiğıle, mana milletıka sık'ırar yugra dexhe giyğal. Ğumee vuççud hı'ı deş, Yiğın millet g'attixhan ha'asdemee. ");
INSERT INTO tkr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Manke Rəbbee Mısayk'le eyhen: – Həşde vak'le g'acesın, Zı hucooyiy fironuk ha'a. Yizde xənne gucune ögiyl, mang'vee manbı g'avkasınbıb, vuk'lele haa'as saccu cune ölkeençe hudooracenva. ");
INSERT INTO tkr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Qiyğa Allahee Mısayk'le eyhen: – Zı Rəbb vorna. ");
INSERT INTO tkr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Zı İbrıhımıs, I'saq'ı's, Yaaq'ubıs Gırgın Əxəna Allah xhinne gyagu, Zıcar Zı manbışis YAHVE xhinne qıvats'ı'ı deş. ");
INSERT INTO tkr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Zı manbışika mugaavileniy hav'u, co menne cigaynbı xhinne aaxvan Kana'anğançenbışin cigabı cos helesva. ");
INSERT INTO tkr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Zak'le İzrailybışe, Misirbışde xılençe ts'ıts'a'an uts'ur ats'an. Zasse şenbışika hav'una mugaavile yik'el hipxın deş. ");
INSERT INTO tkr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Mançil-alla İzrailybışik'le eyhe: «Zı Rəbb vorna. Zı şole Misirbışda xamut g'avşesda. Zı Yizde xənne gucuka Misirbışis yı'q'na cazaa huvu, şu manbışde nukariyvalike g'attivxhan haa'asınbı. ");
INSERT INTO tkr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Zı şoke Zasın millet ha'as, Zı vuşda Allah ixhes. Manke şok'le ats'axhxhesın, Zı şu Misireene əq'übeençe g'attivxhan hav'una vuşda Rəbb Allah vor. ");
INSERT INTO tkr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Zı şu İbrıhımıs, I'saq'ı's, Yaaq'ubıs k'ın g'assır helesva uvhuyne cigabışeeqa quvkees. Man cıgabı vuşunbı ixhes. Zı Rəbb vorna». ");
INSERT INTO tkr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mısee man uvhuynbı İzrailybışis yuşana'a. Manbı əq'übayn rı'hı'le g'av'uva, manbışe mang'ul k'ırı iliyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Manke Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","– Fironusqa, Misirne paççahısqa, hark'ın eyhe, İzrailybı cune ölkeençe g'avkecen. ");
INSERT INTO tkr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mısee Rəbbik'le eyhen: – İzrailybışe zal k'ırı ilydiyxhe, fironee nəxüd zal k'ırı ilixheye? Zasse yugrar yuşana'as əxə deş. ");
INSERT INTO tkr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Rəbb Mısaykayiy Harunuka yuşan hı'ı, manbı fironusqa Misirne paççahısqa g'uxoole, İzrailybı cune ölkeençe g'avkecenva. ");
INSERT INTO tkr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","İzrailybışde nasılbışin ç'ak'ınbı inbı vob: İzrailyne ts'erriyne dixen Ruvenın dixbı: Xanok, Pallu, Xetsroniy Karmi. İn xizanbı Ruvenıke g'adıynbı vod. ");
INSERT INTO tkr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Şimonun dixbı: Yemuel, Yamin, Ohad, Yakin, Tsoxar. Sayir Kana'anğançene xhunaşşeykena dix Şaul. İn xizanbı Şimonıke g'adıynbı vod. ");
INSERT INTO tkr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Xərıng'ule otçu k'ıning'ulqamene Leviyne dixbışin dobı: G'erşon, Qohat, Merari. Levee vəşşe xhebts'ale yighılle (137) sen ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","G'erşonun dixbı: Livniyiy Şimey. Manbışqad xizanbı ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Qohatın dixbı: Amram, İtshar, Xevron, Uzziel. Qohatee vəşşe xhebts'ale xhebılle (133) sen ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merariyn dixbı: Maxliyiy Muşi. İn xizanbı Leviyke g'adıynbı vod. ");
INSERT INTO tkr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramee cuna mamasiy Yoxeved hee'e. Məng'ee Amramıs Haruniy Mısa vuxu. Amramee vəşşe xhebts'ale yighılle (137) sen ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","İtsharın dixbı: Qorax, Nefeg, Zixri. ");
INSERT INTO tkr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzzielin dixbı: Mişael, Eltsafan, Zıtri. ");
INSERT INTO tkr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Harunee Amminadavna yiş Elişeeva hee'e. Mana Naxşonna yiçu yixha. Məng'ee Harunus Nadav, Avihu, Eliazar, İtamar vuxu. ");
INSERT INTO tkr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Qoraxın dixbı: Assir, Elqana, Aviasaf. İnbı Qoraxın xizanbı. ");
INSERT INTO tkr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Harunne dixee Eliazaree Putielyne yişbışda sa hee'e. Məng'ee Eleazarıs Pinxas uxu. Leviyne xizanbışin ç'ak'ınbı inbı vob. ");
INSERT INTO tkr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","İne nasılenbıniy vob Haruniy Mısa. Rəbbe manbışik'leniy uvhu, İzrailybı Misirğançe g'oşunbı xhinne qığee'ecenva. ");
INSERT INTO tkr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Manbıniy fironuka Misirne paççahıka İzrailybı Misirğançe qığav'uyne hək'ee yuşan hav'u. İnəxbın insanar vuxha Mısayiy Harun. ");
INSERT INTO tkr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Rəbb Mısayka Misir yuşana'ang'a ");
INSERT INTO tkr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","uvhuynniy: – Zı Rəbb vorna! Zı vak'le uvhuyn gırgın kar fironuk'le, Misirne paççahık'le eyhe. ");
INSERT INTO tkr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mısee Rəbbik'le eyhen: – Zasse yugrar yuşana'as əxə deş, nəxüdne fironee zal k'ırı alixhxhes? ");
INSERT INTO tkr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Rəbbee Mısayk'le eyhen: – Ğu Yizın cuvab Harunule, yiğne çocule, ğana fironulqa hixhar ha'as. Mana yiğna peyğambar xhinne ixhes. ");
INSERT INTO tkr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Zı vak'le uvhuyn gırgın kar yiğne çocus Harunus yuşan he'e. Hasre mang'veeyid fironuk'le eyhecen İzrailybı Misirğançe g'avkeva. ");
INSERT INTO tkr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Zı fironuke hı't'iy ha'as, mang'vee, Zı Misir geed əlaamatbıyiy həşdilqamee g'ıdecuyn karbı he'eyid şol k'ırı alixhxhes deş. Manke Zı Misirılqa xıl alivka'as, yı'q'ı'n əq'übabı g'axıles, Yizın millet, İzrailybı, g'oşunbı xhinne Misirğançe qığaa'as. ");
INSERT INTO tkr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Zı xıl alivkav'u İzrailybı manbışde yı'q'neençe qığav'umee, Misirbışik'le Zı Rəbb ıxhay ats'axhxhes! ");
INSERT INTO tkr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mıseeyiy Harunee Rəbbee nəxüdiy uvhu həməxüdud ha'an. ");
INSERT INTO tkr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Manbı fironuka yuşan ha'ang'a Mısayka molyts'al (80), Harunukad molyts'ale xhebılle (83) sen ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Rəbbee Mısayk'leyiy Harunuk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","– Fironee şok'le uvhuyng'a: «Əlaamat hagveva», Mısee Harunuk'le eyhecen: «Yiğın əsaa alyaat'u fironne ögiylqa dağetç'e». Əsaa manke xoçelqa sak'alas. ");
INSERT INTO tkr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mısayiy Harun fironusqa abı, Rəbbee uvhuyn xhinne ha'a. Harunee cun əsaa fironneyiy cune insanaaşine ögiylqa dağetçumee, man xoçelqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Manke fironee k'oran ək'elynanbıyiy cadu ha'anbı cusqa qoot'al. Misirne cadu ha'anbışisse cadubışika man kar ha'as əxən. ");
INSERT INTO tkr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Gırgıng'vee con əsaabı ç'iyelqa dağa'a. Dağı'iyn əsaabı xoçebışilqa siyk'al. Harunnemee əsaan gırgın əsaabı k'öğənbı. ");
INSERT INTO tkr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Rəbbe uvhuyn eyxhe, firon hı't'iyra ıxha, mang'vee manbışil k'ırı iliyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Rəbbe Mısayk'le eyhen: – Firon hı't'iyra vor, mang'us millet g'aykkas ıkkan deşod. ");
INSERT INTO tkr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","G'iyqa miç'eer firon damaysqa ı'qqəmee xoçelqa siyk'alan əsaayid alyaat'u ğu mang'usqa hak'ne. Mana Niline mıglek gozete'e. ");
INSERT INTO tkr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","G'acumee fironuk'le eyhe: «Rəbbee, cühüt'yaaşine Allahee in eyhesva zı vasqa g'axuvu: Cun millet g'aykke sahree Cus ı'bəədat he'ecen! Ğu həşdilqamee k'ırı alixhxhı deş. ");
INSERT INTO tkr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Rəbbevud eyhe: Həşde vak'le ats'axhxhesın Mana Rəbb ıxhay. Yizde xılene əsaaka zı Niline xhyanıs ı'xı'mee xhyan ebalqa sak'alas. ");
INSERT INTO tkr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nileedın baluğ ar hatt'asınbı, əq'ı'yn eva qales, Misirğançenbışisse mançe xhyan ulyoğas əxəs deş». ");
INSERT INTO tkr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Rəbbee meed Mısayk'le eyhen: – Harunuk'le inəxüd eyhe: əsaa alyaat'u, xıl Misirne damabışilqa, arxbışilqa, g'oleeşilqa, gırgıne xhyan havacene cigabışilqa hotkecen. Maadın gırgın xhyan ebalqa sak'alas. Q'uvayned, g'ayeyned g'abbışee gırgınəəng'ə Misir eb vuxhes. ");
INSERT INTO tkr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mıseeyiy Harunee gırgın Rəbbee cok'le uvhuyn xhinne ha'a. Harunee fironneyiy cune insanaaşine ögiyl əsaa ooqa qı'ı Nileene xhines ı'xı'mee, gırgın xhyan ebalqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nileedın baluğar haat'anbı, mançe məxdun əq'ı'yn eva g'əə giyğal, Misirbışisse mançe xhyan ulyoğas əxə deş. Misir gırgınəəng'ə eb vuxha. ");
INSERT INTO tkr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Misirne cadu ha'anbışissed caduyka man kar ha'as əxən. Firon hı't'iyra ıxha, Rəbbee uvhuyn xhinne, mang'vee Mısaylil Harunul k'ırı iliyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Fironee man yik'eeqa ıkkeka deş, sark'ıl cune sareeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misirbışe Niline hiqiy-alla kahrızbı iliykar ulyoğasın xhyan t'abal ha'a. Manbışisse dameençe ulyoğas əxə deş. ");
INSERT INTO tkr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Rəbbee damalqa ver ablyav'uyn yighılle yiğ eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Rəbbee Mısayk'le eyhen: – Fironusqa hark'ın mang'uk'le eyhe: «Rəbbee inəxüdud eyhe: „Yizın millet g'aykke Zas ı'bəədat he'ecen! ");
INSERT INTO tkr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Vas g'avkas diviykıneene, Zı yiğna ölkavolle qı'rqı'mı't'er gyoğa'as. ");
INSERT INTO tkr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nil qı'rqı'mı'teşika gyavts'u vuxhes. Dameençe manbı qığeeç'u yiğne sareeqa, g'ılexhane cigeeqa, tyuleeqa, yiğne insanaaşineyiy yiğne milletne xaybışeeqa, tandurbışeeqa, xamır ha'ane cigabışeeqa qales. ");
INSERT INTO tkr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Qı'rqı'mı't'er valqa, yiğne insanaaşilqa, yiğne milletılqa g'eek'valas“». ");
INSERT INTO tkr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Rəbbee Mısayk'le meed eyhen: – Harunuk'le inəxüd eyhe: əsaa alyaat'u xıl damabışde, arxbışde, goleeşde ooqa hotkecen. Maadın qı'rqı'mı't'er Misirne ölkalqa salat'e'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Harunee əsaanan xıl Misirne xhyanbışilqa hotkumee, xhinençe qı'rqı'mı't'er ılqeeç'u ç'iyeyn aq'va aqqaqan. ");
INSERT INTO tkr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Cadu ha'anbışissed cadubışika man kar ha'as əxən. Manbışissed Misirne ölkalqa qı'rqı'mı't'er salat'a'as əxənbı. ");
INSERT INTO tkr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Fironee Mısayiy Harun qopt'ul eyhen: – Rəbbis düə he'e, zaked, yizde milletıked qı'rqı'mı't'er əq'əna qe'ecen. Manke zınad Rəbbis q'urban ablya'as millet g'aykkasın. ");
INSERT INTO tkr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mısee fironuk'le eyhen: – Eyhe vas mısane ıkkan, zı val, yiğne insanaaşıl, yiğne milletil-alla düə hav'u? Mançile qiyğa qı'rqı'mı't'er vassed, yiğne saraybışissed əlyhəəsınbı. Manbı saccu Nilee axvas. ");
INSERT INTO tkr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Fironee eyhen: – G'iyqa. Mısee alidghıniy qele: – Ğu eyhen xhinne ha'as, mançiked vak'le ats'axhxhesın yişde Allahık, Rəbbik akarna sacar deşda. ");
INSERT INTO tkr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Qı'rqı'mı't'er vassed, yiğne saraybışissed, yiğne insanaaşissed, yiğne milletıssed əq'əna qeetxhes. Qı'rqı'mı't'er saccu Nilee axvas. ");
INSERT INTO tkr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mısayiy Harun fironusse avayk'ananbı. Mısee Rəbbıke Vuce salat'ı'iyn qı'rqı'mı't'er ak'anı'iy heqqa. ");
INSERT INTO tkr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Rəbbee Mısee Cuke heqqiyn ha'an. Xaybışeedın, məhlabışeedın, çolbuşeedın qı'rqı'mı't'er haat'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Manbı anbarbışeeqa sa'a. Ç'iyeyke əq'ı'yn eva g'əə giyğal. ");
INSERT INTO tkr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Fironuk'le işbı yəqqı'lqa gyatk'u sibık qexhe g'acumee, mana meer hı't'ilqa siyk'al. Rəbbee uvhuyn xhinne eyxhe, fironee Mısayliy Harunul k'ırı iliyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Rəbbee Mısayk'le eyhen: – Harunuk'le eyhe, əsaa alyaat'u ç'iyelyne toozus ı'xecen. Misirvollete tooz huneeşilqa sak'alas. ");
INSERT INTO tkr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Manbışe həməxüdud haa'an. Harunee xıle aqqıyn əsaa ulyot'ul ç'iyeleğana ulyosse. Mançe insanaaşilqad həyvanaşilqad huneer ileedaxva. Misirvollette gırgın tooz huneeşilqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Cadu ha'anbışisıd caduyka insanaaşilqa huneer g'axiles ıkkiykan. Man manbışisse ha'as əxə deş. İnsanarab həyvanarad huneeşe gyayts'enbı. ");
INSERT INTO tkr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Cadu ha'anbışe fironuk'le eyhen: – İnçil Allahna xılib alivku. Meed Rəbbe uvhuyn xhinne eyxhe, firon hı't'ilqa siyk'al, mang'vee manbışil k'ırı iliyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Rəbbee Mısayk'le eyhen: – G'iyqa miç'eer zara oza qıxha, firon damaysqa ı'qqəmee mang'usqa hark'ın eyhe: «Rəbbee invavud eyhe: „Yizın millet Zas ı'bəədat ha'as g'aykke! ");
INSERT INTO tkr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ğu manbı g'ıdivkvee, Zı yiğne saraybışilqad, yiğne insanaaşilqad, yiğne milletılqad goganer veçebışiqa g'axıles. Gırgın ç'iyed, Misirbışin xaybıd goganeeşika gyatts'es. ");
INSERT INTO tkr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Zı həməxüd ha'as Yizın millet eyxhene Goşen eyhene cigee goganer ixhes deş. Məxüd vak'led ats'axhxhesın Zı ine cigaynar Rəbb ıxhay. ");
INSERT INTO tkr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Zı Yizın millet yiğne milletıke cura'asın. Man əlaamat g'iyqa ixhes“». ");
INSERT INTO tkr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Rəbbee həməxüdud ha'an. Goganeeşin veçebı aledxu qadı ikkedaç'enbı fironne sareeqad, cune insanaaşine xaybışeeqad. Goganeeşe Misirne ölkalqa ver ablyav'u. ");
INSERT INTO tkr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Fironee Mısayiy Harun qopt'ul eyhen: – Şu vuşde Allahıs yişdecab ölkee q'urban ablee'e. ");
INSERT INTO tkr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mıseemee eyhen: – Həməxüd ha'as ixhes deş, Misirbış həlyvətq'ıniy qales, şi yişde Allahıs, Rəbbis inyaa q'urban ablya'a g'avce. Manbışis həlyvətq'ıniy qalya'ana şi q'urban ablyav'ee, manbışe şi g'ayeyqqa hevles. ");
INSERT INTO tkr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","De'eş, şi Rəbbis, yişde Allahıs q'urban ablya'asdemee xhebılle yiğna sahreeqa yəq əlyhəəs vukkan. Rəbbee şak'le məxüd uvhu. ");
INSERT INTO tkr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Fironee eyhen: – Zı şu, vuşde Allahıs, Rəbbis q'urban ablyaa'as sahreeqa g'avkasınbı, saccu əq'ənaqa ımaak'an. Zal-allab düə hee'e. ");
INSERT INTO tkr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mısee eyhen: – Zı vasse qığeç'umecar Rəbbis düə haa'as. G'iyqa goganer vassed, yiğne insanaaşissed, yiğne milletıssed aleetxu əlyhəəsınbı. Saccu ğu meed horbu hıma'a, millet Rəbbis q'urban ablyaa'as g'aykkasınva. ");
INSERT INTO tkr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mısa fironusse ark'ın Rəbbis düə haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Rəbbee Mısee Cuke heqqiyn ha'an. Firon vucur, cun insanarıb, cun milletıd goganeeşike g'attivxhan haa'anbı. Ma'ab sacab goganiy aaxva deş. ");
INSERT INTO tkr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Firon meer hı't'ilqa siyk'al, mang'vee millet g'ekka deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Rəbbee Mısayk'le eyhen: – Fironusqa hark'ın mang'uk'le eyhe: «Cühüt'yaaşine Allahee, Rəbbee, invavud eyhe: „Yizın millet Zas ı'bəədat ha'asva g'aykke!“ ");
INSERT INTO tkr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Vas manbı g'avkas diviykkın, avqeene, ");
INSERT INTO tkr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Rəbbee çoleene yiğne həyvanaaşilqa: balkanaaşilqa, əməleeşilqa, devabışilqa, çavra-vəq'əlqa xıl alivkav'u yı'q'ı'n ık'ar g'axiles. ");
INSERT INTO tkr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Rəbbee İzrailybışiniy Misirbışin çavra-vəq'ə sana-sançike cura'asın. İzrailybışda sacab həyvan qivk'as deş». ");
INSERT INTO tkr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Rəbbee vaxt gyuvxhu eyhen: – Zı man g'iyqa ha'as. ");
INSERT INTO tkr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Qinne yiğıl Rəbbe həməxüdud ha'an. Misirbışin gırgın həyvanar haat'anbı. İzrailybışdamee sacab həyvan qook'a deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Fironee hucooyiy eyxheva cun insanar g'axuvumee, İzrailybışda sacab həyvan qivk'u deşubva mang'uk'le ats'axhxhen. Mana meer hı't'ilqa siyk'al, mang'vee millet g'ekka deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Rəbbee Mısayk'leyiy Harunuk'le eyhen: – Kureençe xhaxhbı gyatsts'ına yı'q alept'e. Havaasre mana yı'q Mısee fironne ulene ögiyl xəəqə dağee'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Toz xhinne quvxha, mana yı'q Misirvollette alivxasda. Ölkavolle insanaaşilid həyvanaaşilid maşika gyatsts'ıyn ı'xnabı qığeeç'es. ");
INSERT INTO tkr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Manbışe yı'q alyapt'ı fironne ögee ulyoozaranbı. Mısee mana yı'q xəəqə dağav'umee, insanaaşikıd həyvanaaşikıd maşika gyatsts'ıyn ı'xnabı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Gırgıne Misirbışik xhinne, cadu haa'anbışikıd maşika gyatsts'ıyn ı'xnabı ıxhava, manbışisseb Mısayne ögiyl abı ulyoozaras vəəxə deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Rəbbee meer firon hı't'ilqa sak'al ha'a. Rəbbee Mısayk'le uvhuyn xhinnecad eyxhe, fironee manbışil k'ırı alixhxhı deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Rəbbee Mısayk'le eyhen: – Çakra miç'eer oza qıxha fironusqa hark'ın eyhe: «Cühüt'yaaşine Allahee, Rəbbee, inəxüdud eyhe: „Yizın millet Zas ı'bəədat ha'asva g'aykke! ");
INSERT INTO tkr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","İne yəqqe Zı valqad, yiğne insanaaşilqad, yiğne milletılqad nekke yı'q'ı'n verbı allya'as. Manke vak'le ats'axhxhesın, dyunyelycar Zak akarana deşda. ");
INSERT INTO tkr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Zasse əxəyiy xıl hotku valqad, yiğne milletılqad yı'q'ı'n ık'ar g'axuvu, ç'iyeyne aq'vayle havaakala'as. ");
INSERT INTO tkr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Zımee ğu havacena, Yizda guc haagvas, Yizın do dyunyeyscad g'ayxha'as. ");
INSERT INTO tkr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ğumee, həşdilqamee Yizde milletın ögü aqqı, manbı g'avkku deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Həşde ğu Zal yugda k'ırı alixhxhe: g'iyqa hayne gahıl Zı məxdun it'umun dolu g'axiles, məxdun dolu Misirık'le ipxhıniyle qiyğa g'acu ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mançil-allab insanar g'axuvle çoleedın çavra-vəq'əd, yiğın gırgın karıd vüxənayk avqa se'ecen. Çolead vuk'ul hüvxəsın ciga dena avxuyne insanaaşilqad, çavra-vəq'əlqad dolu ixhes, maadın gırgın kar qik'asın“». ");
INSERT INTO tkr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Rəbbee uvhuynçile qəpq'ı'nne fironne insanaaşee, zaraba con g'ulariy çavra-vəq'ə xaane suralqa hee'ekka. ");
INSERT INTO tkr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","K'ırı ilydiyxhınbışemee g'ularıb, çavra-vəq'əd çoleead g'alya'a. ");
INSERT INTO tkr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Rəbbee Mısayk'le eyhen: – Xıl xəəqə k'yaqqe, Misirne gırgıne insanaaşilqa, həyvanaaşilqa, çolee alyadıyne alabışilqa dolu gyoğas. ");
INSERT INTO tkr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mısee əsaa xəəqə k'yaqqımee, Rəbbee xəybı g'əhətqə'ə, Misirılqa ts'ayılpaniy dolu g'ıxele. ");
INSERT INTO tkr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Gırgınəəng'ə ts'ayılpanıka dolu gyoğa eyxhe. Misir vuxhayle qiyğa maa məxdun it'umun dolu ıxha deşdiy. ");
INSERT INTO tkr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Misirvolle doluyn insanar, həyvanar, çoleedın gırgın kar k'etan. Çolee alyadıyn gırgın ok'bı, yivar doluyn haq'vara'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Saccu Goşen İzrailybı vooxhene cigee dolu dexhe. ");
INSERT INTO tkr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Fironee Mısayiy Harun qopt'ul eyhen: – Zı ine yəqqee bınah hav'u. Rəbbee gırgıncad qotkuda ha'a, zınay yizde milletın bınah hav'u. ");
INSERT INTO tkr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hucoone ixhes, Rəbbis düə hee'e: man xəybı g'əhətqiyiy dolu ç'əv ixhecen! Zı şu g'avkasınbı, inyaa avqas deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mısee mang'uk'le eyhen: – Zı şahareençe qığeç'umee, xıleppı aaqı Rəbbis düə haa'as. Manke xəybı g'əhətqiyıd ulyozarasın, dolud gyoğas deş. Mançile qiyğa vak'le ats'axhxhesın ine dyunyeyna xərna Rəbb ıxhay. ");
INSERT INTO tkr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Zak'le ats'ancad, ğunayiy yiğın insanar meeb Rəbbile Allahıle qıdəəq'ənas vuxhay. ");
INSERT INTO tkr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Kataniy xhıt'a doluyn k'etanbı. Mane gahıl xhıt'ayna den ky'aa'ana, katannab t'et' g'ayhena vaxt vuxha. ");
INSERT INTO tkr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Sukiy perinc qiyğa ələəva doluyn manbı k'eta deş. ");
INSERT INTO tkr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mısa fironne sarayeençe qığeç'umee, şahareençe ayk'anna. Mang'vee xıleppı Rəbbılqana aaqımee, doluyka haç'a'an gyoğuyiy, xəybı g'əhətqiy ulyoyzaran. ");
INSERT INTO tkr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Fironuk'le doluyka haç'a'an gyoğuyiy xəybı g'əhətqiy ulyozzur g'acumee, mang'vee meeb bınah haa'a. Fironur cun insanarıb hı't'eeşilqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Rəbbee Mısayk'le, milletık'le eyheva uvhuyn xhinnecad eyxhe, firon meer hı't'ilqa siyk'al, mang'vee İzrailybı g'ooka deş. ");
INSERT INTO tkr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Rəbbee Mısayk'le eyhen: – Fironusqa hak'ne. Zı əlaamatbı hagvasva fironuniy cun insanar hı't'eeşilqa savaak'al hav'u. ");
INSERT INTO tkr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Qiyğa ğunad Zı nəxübiy Misir tesser hav'u, ma'ad nen əlaamatbıyiy hagu yiğne uşaxaaşısiy nevabışis yuşan he'e. Manke şok'le ats'axhxhesın Zı Rəbb ıxhay. ");
INSERT INTO tkr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mısayiy Harun fironusqa abı eyhen: – İnəxüd Rəbbee, cühüt'yaaşine Allahee vod eyhe: «Nimee gahnane ğu Zı uvhuynçil k'ırı ilydiyxhes, Zı uvhuynçilqa qidyaales? Yizın millet Zas ı'bəədat haa'as g'aykke! ");
INSERT INTO tkr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ğu Zı uvhuyn meed hide'ene, g'iyqa Zı yiğne ölkalqa ts'irtyar salat'a'as. ");
INSERT INTO tkr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Mançin ç'iye məxüd aqqas, çine xılençe avubna nyaq'vub g'avces deş. Mançin doluyle axuyn-dyaxuyn karıd, vuşde çolbışee ələən yivarıd hiç'ixarasınbı. ");
INSERT INTO tkr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mançin yiğın, yiğne insanaaşin, Misirbışde gırgıng'uncad xaybı gyatsts'a'asınbı. Məxdun kar yiğne dekkaaşik'le, dekkaaşine dekkaaşik'le inyaqa qabıyle qiyğa g'acu deşdiy». Mısa manıd uvhu, fironusse ayk'anna. ");
INSERT INTO tkr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Fironne insanaaşe mang'uk'le eyhen: – Geebniyxan mane insanee şas əq'üba hevles? G'avke man insanar, hapk'ın cone Rəbbis Allahıs ı'bəədat he'ecen. Nya'a vak'le g'ece dişde Misir g'ulyoottalna? ");
INSERT INTO tkr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mısayiy Harun meeb fironusqa qoot'al. Fironee manbışik'le eyhen: – Havak'ne Rəbbis, vuşde Allahıs ı'bəədat he'e. Saccu eyhe maqa vuşbıyiy vüqqəs? ");
INSERT INTO tkr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mısee eyhen: – Şi maqa vüqəsınbı yişde uşaxaaşika, q'əsınbışika, dixbışika, yişbışika, çavra-vəq'əyka. Şi maa Rəbbis bayram alğahas. ");
INSERT INTO tkr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","11","Fironee manbışik'le eyhen: – Məxüd ixhes deş! Qiyğad manbı matsxar ha'anbı xhinne eyhen: – Aay-haay, zı şu xhunaşşeeşika, uşaxaaşika g'avkeene, manke Rəbbir şoka eyxhe! Mıts'an şoqa karaı'dəən fıkırbı vod! Şu man heqqıva, havak'ne adamer şucad Rəbbis ı'bəədat he'e. Manva uvhu Mısayiy Harun fironusse g'e'ebaşenbı. ");
INSERT INTO tkr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Rəbbee Mısayk'le eyhen: – Misirne ölkalqa xıl hotku, maqa ts'irtyar qale'e. Mançin çolbışee ələəniy dolu gyoğuyle qiyğa axuyn gırgın kar alyatxhvasın. ");
INSERT INTO tkr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mısee əsaa Misirılqa hotkumee, Rəbbee ç'iyelqa şargına mıts g'uxoole. Mıts bıkırın yiğnayiy xəmna aa'a. Miç'eediysıd mıtsın ts'irtyar adayle. ");
INSERT INTO tkr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ts'irtyar Misirılqa k'yoyhar, mançin ölka bıkırba avqaaqana. Manimeen ts'irtyar g'iynilqameeyid ıxha deş, g'iyniyke şaqad ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ts'irtyaaşe ç'iyeyn oodun ciga gyatsts'a'an, mançike ç'iyelyna nyaq'vub k'aarıba g'ooce. Mançin doluyle qiyğa axuyn, çolbışee ələən kar, yivaaşilin meyvabı gırgıncad oyxhanan. Misirvolle ç'iyeliy yivaaşil xhınakın kar axva deş. ");
INSERT INTO tkr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Fironee zaraba Mısayiy Harun qopt'ul eyhen: – Zı Rəbbine, vuşde Allahneyiy vuşde ögiyl bınah hav'u. ");
INSERT INTO tkr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Hucoone ixhes, hayne sayəqeesıb yizde bınahıle ılğeepç'e. Rəbbis, vuşde Allahıs düə hee'e, şi ine gyabat'ane balyaake g'attixhan he'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mısee fironusse qığeç'umee Rəbbis düə haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Manke Rəbbee deryahne suralqa it'umna mıts g'uxoole. Mane mıtsınıd gırgın ts'irtyar Ç'ərəne deryaheeqa aletxu ha'a. Məxüd Misirvolle sacad ts'irt axva deş. ");
INSERT INTO tkr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Rəbbemee firon meer hı't'ilqa sak'al ha'a, mang'veeyib İzrailybı g'ooka deş. ");
INSERT INTO tkr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Rəbbee Mısayk'le eyhen: – Xıl xəəqə qe'e Misirne ölkalqa miç'axiyvalla k'evxhecen, ulyaqa hiviyxəna t'ub g'umoocecen. ");
INSERT INTO tkr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mısee xıl xəəqə qı'ımee Misirvolle xhebne yiğna geed miç'axda eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Xhebne yiğna insanar sana-sang'uk'le g'avces vəvxü deş, manbı xhebne yiğna cigeençe ı'ğviykır deş. İzrailybı vooxhene cigabışeemee işix ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Fironee Mısa qort'ul mang'uk'le eyhen: – Havak'ne Rəbbis ı'bəədat he'e. Şoka vuşun uşaxarıb vukkee. İnyaa vuşun saccu çavra-vəq'ə axvecen. ");
INSERT INTO tkr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mısee eyhen: – Şi yişde Rəbbis Allahıs q'urban ablyaa'asdemee, ğu yişin çavra-vəq'əd şaka g'aykkas ıkkan! ");
INSERT INTO tkr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Gırgın yişin həyvanar şaka qıkkes ıkkan. Şi inyaa yişde həyvanaaşina xhınt'ayıb g'alepçes vukkan deş. Rəbbis, yişde Allahıs q'urbanna allyasın şi mançike həyvanar g'əxəs. Şi maqa ikkyabı şak'le ats'axhxhes deş, nen həyvanariy Rəbbis q'urbanna allya'as. ");
INSERT INTO tkr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Rəbbee firon meer hı't'ilqa sak'ala'a, mang'us manbı g'avkkas vukkiykan deş. ");
INSERT INTO tkr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Mang'vee Mısayk'le eyhen: – Ğadarxhe yizde ulene ögiyle! Sayir yizde ulesqa qımayle! Sayir ğu yizde ulesqa qareene, qik'asda. ");
INSERT INTO tkr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mısee eyhen: – Hasre ğu eyhəxüd ixhecen, sayir zı yiğne ulesqa qales deş. ");
INSERT INTO tkr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Rəbbee Mısayk'le eyhen: – Zı fironulqayiy Misirılqa sayib balyaa g'axuvles. Mançile qiyğa mang'vee şu inçe g'avkvasınbı. Saccu avak'neva vuk'lele haa'as. ");
INSERT INTO tkr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Milletık'le eyhe, adameeşeyiy yedaaşe hiqiy-allane Misirbışike nuk'raykeyiy k'ınəəğəyke hı'iyn karbı heqqecen. ");
INSERT INTO tkr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Rəbbee məxüd ha'a, Misirbışde ulesqa millet yugda qadayle. Mısamee fironne insanaaşik'le, Misirne milletık'le geer xərna insan xhinne ats'a eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mısee fironuk'le eyhen: – Rəbbe inəxüdud eyhe: «Xəm sura vuxhamee, Zı Misirne yı'q'neençe ılğeç'es. ");
INSERT INTO tkr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Taxtıl gyu'arasde fironne ts'erriyne dixele girğıl, suk giviyxərne g'ayeyne yı'q'əl giy'ırne nukarne dixelqamee, gırgıng'un ts'eppiyn dixbı hapt'asınbı. Həyvanaaşinıd çikana ts'ettiyn balabı hatt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Misirvolle xədın geşşuy ixhes. Məxdın geşşuy mankilqameeyid ıxha deşdiy, mançile qiyğad mısacad ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","İzrailybışilqayiy cone çavra-vəq'əlqa xvaayib gihivxhas deş». Mançike şok'le ats'axhxhesın Rəbbee İzrailybıyiy Misirbı nəxübiy sana-sang'uke curav'u. ");
INSERT INTO tkr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Yiğın insanar zasqa abı, yizde g'elybışeeqa qutyopk'ul eyhesın: «Ğunar hoora, vaqa qihna hoyharan gırgın milletıd hooracen!» Mançile qiyğa zı əlyhəəsda. Manıd uvhu, Mısa qəlın qek'a fironusse qığeç'ena. ");
INSERT INTO tkr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Rəbbee Mısayk'le eyhen: – Zasse Misir geed əlaamatbı hagvas əxecenva, fironee şol k'ırı alixhxhes deş. ");
INSERT INTO tkr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mıseeyiy Harunee man gırgın əlaamatbı fironuk'le hagveyid, Rəbbee fironuke hı't'iy hı'ı, mang'vee İzrailybı cune ölkeençe g'avku deş. ");
INSERT INTO tkr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Rəbbee Mısayk'leyiy Harunuk'le Misireenang'acadniy uvhu: ");
INSERT INTO tkr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","– Havaasre mana vaz vuşdemee vuzaaşina xəbna vuxhecen, senıd çile giğlecen. ");
INSERT INTO tkr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","İzrailyne gırgıne cəmə'ətık'le eyhe: ine vuzane yits'ıd'esde yiğıl gırgıng'vee cune xizanısdayiy, cune xaasda urgee vooxhe, mısvaye vooxhe g'əvxəs vukkan. ");
INSERT INTO tkr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Sa urg ooxhanasdemee xizan k'ılbaxheene, hasre manbışe cone xaas delesne xaybışeene insanaaşis sik'ı bit'alee'ecen. Ats'axhe neng'usse nimeniy oxhanas əxəsva. ");
INSERT INTO tkr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Şu g'əyxı'yn həyvanar sa seniyn vughulinbı, qı'bı'linbı mexhecen. Urgub, mısvab şosse gyuvk'as vəəxə. ");
INSERT INTO tkr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Manbı ine vuzane yits'ıyoq'ad'esde (14) yiğılqamee havace. Exhalqana İzrailyne cəmə'ətın manbı gyatt'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Mançina eb alyapt'ı, şu karbı oxhanasde xaybışde akkabışde çerçivabışilqa q'abğe. ");
INSERT INTO tkr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Manecad xəmde ç'eyç'eybışika, ts'ayıl ç'əra qı'in çuru ilydyadıyne gıneyka oxhne. ");
INSERT INTO tkr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Man çuru qumoyxhar, yugda qecu, vuk'ul-k'ıts'ayka, adne karbışika ts'ayıl ç'əra qı'ı oxhne. ");
INSERT INTO tkr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Miç'eedilqamee vuççud g'ılymadaççe. Axuyn kar ixhee gyoxhxhan he'e. ");
INSERT INTO tkr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Çuru otxhanang'a inəxüd he'e: yı'q'eeqa ts'ira avt'le, g'elilqa g'ellin ale'e, xıled əsaa aqqee. Yicıd zarada oxhne. İna şok qıdet'u ılğeç'uva Rəbbis ablyav'una q'urban vobna. ");
INSERT INTO tkr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","G'iyna xəmde Zı Misirıle k'ena ılğeç'es. Ma'ab yedike vuxhayn ts'eppiyn dixbıb, həyvanaaşin ts'ettiyn balabıd Zı g'iyna xəmde gyapt'asınbı. Rəbb Zı ıxhal-alla Misirıne allahaaşisıb cazaa hevles. ");
INSERT INTO tkr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Şu q'abğına eb vuşde xaybışilin işaarat ixhes. Eb g'avcu Zı set'as deş, qidet'u ılğeç'es. Zı Misirbı gyabat'ana balyaa şolqa havaasras deş. ");
INSERT INTO tkr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","İn yiğ şu yik'el aqqe. Qööne nasılbışed Rəbbin bayram xhinne in yiğ alğehecen. Gırgıne gahbışil in bayram alğehe. İna Zı şos gyuvxhuna q'aanun vobna. ");
INSERT INTO tkr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yighılle yiğna ilydyadıyn gıney oxhne. Vuşde xaana acıxamır ts'eppiyne yiğılycab sav'u avak'anee'e. Şavaayiy ts'eetiyne yiğıle yighıd'esde yiğılqamee acıxamırnan gıney otxhun, İzrailybışde yı'q'ne meexhecen. ");
INSERT INTO tkr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ts'ettiyneyiy yighıd'esde yiğıl muq'addasna iclas see'e. Mane yiğbışil şos otxhuniy hı'iyle ğayrı nenacab iş hımaa'a. ");
INSERT INTO tkr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","İne ilydyadıyne gıneybışin bayram, Zı şu Misirğançe mane yiğıl g'oşunbışikva qığav'unçil-alla alğehe. İn bayram qööne nasılbışed alğehecen. İna Zı şos huvuna q'aanun gırgıne gahbışisda vob. ");
INSERT INTO tkr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","İlydyadıyn gıney ts'eppiyne vuzane yits'ıyoq'ad'esde (14) yiğıne exhaliyle gibğıl g'ayı sad'esde (21) yiğıne exhalilqamee oxhne. ");
INSERT INTO tkr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Yighne yiğna vuşde xaybışee acıxamır ixhes ıkkan deş. Şavaayiy acıxamırnan gıney otxhun İzrailybışde yı'q'ne meexhecen. Cona ixheeyir, menne cigeençe qarına ixheeyir hakkal ha'asda. ");
INSERT INTO tkr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Acıxamırnan vuççud umoyxhan. Şu nyaa vuxheyib ilydyadıyn gıney oxhne. ");
INSERT INTO tkr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mısee İzrailin gırgın ağsaqqalar qopt'ul eyhen: – Hapk'ın vuşde xizanbışisın urgbıyee mısvabıyee g'əyxı' alle. Allah qıdet'u ılğeç'uyne bayramıs q'urbanbı allee'e. ");
INSERT INTO tkr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Sa xudana züfa eyhena ok' alyapt'ı, lyagameene ebeeqa k'yooq'u akkayne çerçivalqa q'abğe. Miç'eerilqameyir vuşucar g'aqa qığmeç'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Rəbb Misirbı gyapt'as ı'qqəmee, çerçivalyna eb g'avcu, mane xaabınbışik qıdet'u ılğeç'es. Gyabat'asva arına malaaik vuşde xaybışeeqa, şu gyapt'as ikkeç'es hassaras deş. ");
INSERT INTO tkr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","İn ədat gırgıne gahbışis şosiy şole qiyğinbışis q'aanun xhinne havaace. ");
INSERT INTO tkr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Rəbbee şos helesva cuvab huvuyne cigeeqa qabı hipxhırmeeyib, şu in ədat yik'el hixan hıma'a. ");
INSERT INTO tkr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Vuşde uşaxaaşe şoke qidghın hı'iyng'a: «Şu in nişisne ha'a?» ");
INSERT INTO tkr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Manbışik'le eyhe: «Rəbbee Misirbı gyabat'ang'a, İzrailybışde xaabınbışik qıdet'u ılğeç'uva, şi g'attivxhan hav'uva Rəbbis ablyaa'ana q'urban vobna». Milletın q'aratsabışil gyu'ur, Rəbbis ı'bəədat ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Mançile qiyğa İzrailybı apk'ın, Rəbbee Mısayk'leyiy Harunuk'le uvhuyn xhinne gırgın ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Xəm sura vuxhayng'a, Rəbbee Misirbışin Misir yedike vuxhayn ts'eppiyn gırgın dixbı gyabat'anbı: fironne ts'erriyne taxtıl gyu'arasde dixele girğıl, zindanee aqqıyng'une ts'erriyne dixelqamee. Həyvanaaşinbıd çikana ts'ettiyn balabı gyaat'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Mane xəmde fironur, cun insanarıb, gırgın Misirbıcab suğootsanbı. Misirğançe it'umun gyaaşen ses qadayle. Məxdın xav eyxhe deş maa'ar vuşumecar qimek'acen. ");
INSERT INTO tkr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Xəmdə fironee Mısayiy Harun qopt'ul eyhen: – Sabı-qabı, hudoora! İzrailybışika sacigee yizde milletıke əq'əna qeepxhe. Havak'ne şu eyheen xhineyid Rəbbis ı'bəədat he'e. ");
INSERT INTO tkr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Şu şenke uvhuyn xhinne he'e: çavra-vəq'əd ha'aykı hudoora. Zasıb xayir-düə hevle. ");
INSERT INTO tkr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirbışe İzrailybı mizel avqaqqa vuxha, manbı cone ölkeençe ek'ba qığeepç'ı hudooracenva. Manbışe eyhe ıxha: – Deşxheene, şi gırgınbı hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Milletın acıxamır üvxəs həsilydexhayn xamırnan con lyagambı tanalinçeeqa hitk'ır mıgabışilqa alyat'u ayk'an. ");
INSERT INTO tkr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","İzrailybışe Mısee uvhuynçil k'ırı gyaqqı, Misirbışisse tanalqan karbı, nuk'ra, k'ınəəğə heqqa. ");
INSERT INTO tkr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Rəbbee həməxüd ha'a Misirbışde ulesqa İzrailybı yugba qavayle. Manbışed İzrailybışis ıkkanan helen. Məxüb manbışe Misirbı q'əra qaa'a. ");
INSERT INTO tkr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","İzrailybı Ramsesğançe Sukkoteeqa avayk'an. Yedaaşileyiy uşaxaaşile hexxana, maa'ar yixhıd vəş aazır (600 000) meena adamiy ıxha. Mançe manbı gırgınbı iviykar apk'ın. ");
INSERT INTO tkr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Manbışika sacigee xəppa menne milletıken insanar, xətta çavra-vəq'əd ayk'an. ");
INSERT INTO tkr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Misirğançe qıkkiyne ilydyadıyne xamırıke manbışe fatirer ha'a. Manbı Misirğançe zaraba hittyavhuva, yəqqı'sın oxhanasın kar ha'as həsileepxha deşdiy. ");
INSERT INTO tkr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","İzrailybı Misir yoq'ud vəşşe xhebts'al (430) senna avxu. ");
INSERT INTO tkr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Yoq'ud vəşşe xhebts'al sen g'adiyne yiğıl, Rəbbin millet g'oşunbışiqa Misirğançe ayk'anan. ");
INSERT INTO tkr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Misirğançe qığaahasde xəmde Rəbbee manbı coleb-alqa g'ılydyav'uva, İzrailybışe mana xəm Misirbışde xılençe g'attipxhınna xəm xhinne yik'el avqu. Hammaşee mana xəm qabıyng'a İzrailybışis Rəbbinemee muğurbaniy aaxvas vukkiykananbı. ");
INSERT INTO tkr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Rəbbee Mısayk'leyiy Harunuk'le eyhen: – Qıdet'u ılğeç'uyn bayramnang'a, şu inəxüd ha'as ıkkan: gyuvk'uyne q'urbanıke menne cigeençe qarıyng'us hideles ıkkan. ");
INSERT INTO tkr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Saccu pılıke alişşuyne g'ulusse man otxhuniy, ğu mana sunnat hı'iyle qiyğa oxhanas əxə. ");
INSERT INTO tkr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Sık'ınna gahna vuşde cigabışee axvasva menne ölkeençe arıng'usiy, pılıke sık'ınna gahna şos iş haa'asva arıng'us, man otxhuniy heles ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Q'urban ablyav'uyng'une xaa man çuru oxhanas ıkkan, mançe g'aqa qığahas ıkkan deş. Sayid mançin nencad bark'vbı haq'var hıma'a. ");
INSERT INTO tkr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","İzrailybışde gırgıng'veecad qıdet'u ılğeç'uva alğayhen bayram alğahas ıkkan. ");
INSERT INTO tkr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Menne cigeençe arı, şüng'əə mihmanna axvang'usud qıdet'u ılğeç'uva Rəbbis alğayhen bayram alğahas ıkkanxhe, mang'une xaabın gırgın adamer sunnat hav'u vuxhes vukkan. Mançile qiyğa mang'ussed, vuşda sa xhinne ıxha man bayram alğahas əxə. Sunnat hidı'iyne adamee mançike hı'iyn otxhuniy umoyxhancen. ");
INSERT INTO tkr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","İzrailybışisıb, menne cigeençe qabı coka aaxvanbışisıb q'aanun sa vobna. ");
INSERT INTO tkr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","İzrailybışe, Rəbbee Mısayk'leyiy Harunuk'le uvhuyn xhinne gırgın ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mane yiğılycab Rəbbee İzrailybı g'oşunbışiqa Misirğançe qığa'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Rəbbe Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","– İzrailee yedarşe ts'eppa vuxuyne dixbışde hək'ee: ts'eppiyn dixbıyiy həyvanaşin ts'ettiyn balabı Yizde doyil qe'e. ");
INSERT INTO tkr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mısee milletık'le eyhen: – Rəbbee Cuna xəbvalla haagu, şu Misirğançe qığav'uyn, nukariyvalike g'attivxhan hav'uyn yiğ yik'el aqqe. Mane yiğıl acıxamırnan gıney umoyxhan. ");
INSERT INTO tkr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","G'iyniyn, şu inçe qığeepç'ı əlyhəən yiğ Aviv eyhene vuzan vod. ");
INSERT INTO tkr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Rəbbee vuşde dekkaaşis k'ınniy g'assır, Kana'anbışin, Q'etbışin, Emorbışin, Q'ivbışin, Yevusbışin nyakiy itv gyodatstsen cigabı şos helesva. Rəbbee şu maqa qabıyng'a, mane vuza man ədat he'e: ");
INSERT INTO tkr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","yighılle yiğna ilydyadıyn, acıxamır deşin gıney oxhne. Yighıd'esde yiğılid Rəbbis bayram alğehe. ");
INSERT INTO tkr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mane yighne yiğee ilydyadıyn, acıxamır deşin gıney oxhne. Şu vooxhenemeene cigabışee, acıxamırıb, acıxamırıke hı'iyn karıd ixhes ıkkan deş. ");
INSERT INTO tkr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mane yiğıl şu vuşde dixbışik'le eyhe: «Şi in ha'an, Rəbbee şi Misirğançe qığa'ang'a hav'una yugvalla yik'el avqu». ");
INSERT INTO tkr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Rəbbee Cuna xəbvalla haagu, şu Misirğançe qığav'uva, havaasre Rəbbina q'aanun vuşde ghalele g'u'moxhacen. Mançil-allad hasre man ədat vuşde xıleyliniy ligaylin k'ats' xhinne vuşde yik'bışee axvecen. ");
INSERT INTO tkr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Senbı atk'ıniylette şu man yiğ yik'el aqqı alğehe. ");
INSERT INTO tkr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Rəbbee şosiy vuşde dekkaaşis k'ın g'assır helesva uvhuyne Kana'anaaşine ölkeeqa qabı hipxhırne yiğıle, ");
INSERT INTO tkr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ts'eppiyn dixbı Rəbbine doyul qee'e. Həyvanaaşinıd ts'ettiyn vughulyun balabı Rəbbine doyul qe'e. ");
INSERT INTO tkr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ts'eppiyne əməleyne balayl-alla urg qevle. Çil-alla vuççud qidelexheene, mançina gardan havaq'ar hee'e. Gırgıne ts'eppa vuxhayne dixbışil-alla nuk'ra qele. ");
INSERT INTO tkr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mısamecad dixee vake man hucooneva qiyghınene, eyhe: «Rəbb şal oğa it'umra ıxha, şi Misirğançe qığav'u, nukariyvalike g'attivxhan hav'u. ");
INSERT INTO tkr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Fironus şi g'avkvas devkanang'a, mana hı't'ilqa sark'ılyne gahıl, Rəbbee Misirbışin gırgın ts'eppiyn dixbı gyabat'anbı. Həyvanaaşinıd ts'ettiyn balabı gyaat'anbı. Mançil-allad zı ts'ettiyn vughulyun həyvanaaşin balabı Rəbbis q'urbanna allya'a, ts'eppiyne yizde dixbışil-allad nuk'ra qele». ");
INSERT INTO tkr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Rəbb şal oğa it'umra ıxhay, şi Misirğançe qığav'uy, vuşdemee xıleyliniy ligaylin k'ats' xhinne ixhecen. ");
INSERT INTO tkr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Fironee millet g'ayqiyng'a, Allahee manbı Filiştinaaşine cigabışile k'ena yəq cit'aba vuxheyib quvqekka deş. Allahee eyhen: – Maa'ab manbışika muhariba hav'eene, manbışe sayid fıkırbı badal hı'ı Misirqacab siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Allahee millet alik'ar hı'ı sahrayle k'ena Ç'ərane deryahısqa qıkkeka. İzrailybı Misireençe dəv'əysınbı xhinnen silahbı alyaat'u avayk'an. ");
INSERT INTO tkr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mısee mançe əlyhəəng'ə, Yusufun bark'vbıd cokasana sı'ı qıkkekanbı. Yusuf qek'ang'a İzrailybışisqa k'ın g'assaras alikkı uvhuynniy: – Allahee şos huvuyn cuvab mısacad yik'el hixan ha'as deş. Şunad əlyhəəng'ə, yizın bark'vbı inyaa g'ılyma'a, şoka qıkkee. ");
INSERT INTO tkr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","İzrailybı Sukkotğançe qığeepç'ı, sahrayne k'anek sa Etam eyhene cigee çadırbı giyxə. ");
INSERT INTO tkr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Rəbb Vuc manbışde hirniy əlyhəə. Mang'vee yiğniyığın manbışis yəq buludne dirakıqa, xəmdeb ts'ayıne dirakıqaniy işix hele haagva. Mang'vee məxüd manbışisse yiğniyığınıb, xəmdeb əlyhəəs vəxəcenvaniy ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Sık'ınne gahıs xheyib buludna dirak yiğniyığın, ts'ayına dirakıb xəmde manbı g'alyav'u avayk'an deş. ");
INSERT INTO tkr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","– İzrailybışik'le eyhe, havaasre manbı yı'q'əlqa sapk'ıl Pi-Haxirot eyhene cigayne k'ane Migdolneyiy deryahne əree çadırbı gı'xecen. Deryahısnee Ba'al-Tsefonne ögee vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Fironusqa həməxüd qales: «İzrailybı nyaqame vuxhesınbı avxu, sahrayn manbışda yəqı'b g'ats'apk'ın». ");
INSERT INTO tkr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Zı firon meer hı't'ilqa sak'ala'as, manar manbışiqa qihna gixhas. Məxüd Zı mang'ukuniy mang'une g'oşunukın hı'ı Yizın do axtı qa'as. Manke Misirbışik'le Zı Rəbb ıxhay ats'axhxhesın. İzrailybışe həməxüdud ha'an. ");
INSERT INTO tkr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Fironuk'le İzrailybı heepxıva uvhuyng'a, mang'unayiy cune insanaaşina fıkır badal vooxhena. Manbışe eyhen: – Şi in hı'iyn kar hucoone? Şi İzrailybı g'avkku nukarar dena avxu! ");
INSERT INTO tkr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Fironee dəv'əysın daşk'a balkanaaşik qa'as alikkı, cuka g'oşunub qopt'ul ayk'anna. ");
INSERT INTO tkr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Mang'vee cuka yixhıd vəş (600) g'əyxı'yne, yugne dəv'əyne daşk'ayle ğayrı, Misirın gırgıncad dəv'əyn daşk'abı alyat'anbı. Gırgıne daşk'abışiqa çin ç'ak'ınbı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Rəbbee firon, Misirna paççah hı't'ilqa sakal ha'a, manar Misirğançe qı'ğəəne İzrailybışqar qihna gexha. İzrailybımee yik'eka əlyhə vuxha. ");
INSERT INTO tkr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misirbı fironne gırgıne dəv'əyne daşk'abışika, balkanaaşil aleepxıynbışika, gırgıne g'oşunbışika sacigee İzrailybışiqa qihna gyabak'a. Misirbışisqa manbı deryahısne çadırbı gixı'yne cigee, Pi-Haxirotne k'ane, Ba'al-Tsefonne hiib gyabak'a. ");
INSERT INTO tkr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firon İzrailybışiqa avayq'arniy vor. Manbı yı'q'əlqa sapk'ıl ilyakiys g'ecen, manbı coqab qihna vob gyapk'ı. Manbı mançile geeb qəpq'ı'n Rəbbilqa ona'a giviyğal. ");
INSERT INTO tkr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Manbışe Mısayk'le eyhen: – Nya'a Misir nyaq'vbıniy deş, ğu şi hapt'as sahreeqa qabı? Karne ğu hı'ı şi Misirğançe qığav'u? ");
INSERT INTO tkr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nya'a, şi vak'le Misir uvhu dişdiy: «Şi şaleb-alqana g'alee'e. Havaasre şi Misirbışda iş haa'as»? Misir nukariyvalla hav'uy, sahree hapt'ıyle yugda eyxheyiy! ");
INSERT INTO tkr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mısee milletıs inəxdun alidghıniy qele: – Qı'məəq'ən, ulyoozre! Şok'le g'iyna g'acesın, Rəbbee şu nəxübiy g'attivxhan haa'a. Həşde g'oocen Misirbı, şok'le sayıb mısacab g'avces deş. ");
INSERT INTO tkr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Rəbbee şol-alla manbışikın ha'asın, yik'bı it'umda aqqe! ");
INSERT INTO tkr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Rəbbee Mısayk'le eyhen: – Nişil-allane ğu Zalqa ona'a? İzrailybışik'le eyhe, ögiylqa hudooracen. ");
INSERT INTO tkr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ğumee əsaa, deryahılqa hotk'u xhyan q'öne cigeeqa qe'e, İzrailybışisse mane xhyan deşde cigeençe deryahıle k'ena ılğeepç'es vəəxhecen. ");
INSERT INTO tkr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Zımee Misirbı hı't'eeşilqa savaak'al haa'as, manbıb şoqab qihna qavaales. Zınad fironne dəv'əyne daşk'abışikıniy balkanaşil aleepxıyne g'oşunbışikın hı'ı Yizın do axtı qa'as. ");
INSERT INTO tkr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Zı mısayiy fironukuniy cune dəv'əyne daşk'abışikın, balkanaaşil aleepxıynbışikın hı'ı, Yizın do axtı qı'ı, manke Misirbışik'le Zı Rəbb ıxhay ats'axhxhes. ");
INSERT INTO tkr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","İzrailybışile ögiyl əlyhəəna Allahna malaaik, ciga badal hav'u, manbışiqar qihna qöö giyğal. Buludne dirakınıb çina ciga badal hav'u, yı'q'əle, ");
INSERT INTO tkr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","İzrailyneyiy Misirne g'oşunbışde əree qöö giviyğal. Xəmvollete dirakın İzrailybışis işix gyavhu, Misirbışismee miç'axiyvalla hav'u. Man g'oşunbı xəmvolletee sana-sançisqa qeetxha deş. ");
INSERT INTO tkr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mısee xıl deryahılqa hodakke. Rəbbeyib xəmvollete şargıle aa'ane mıtsıka deryahın xhyan mançe ak'an ha'a ıxha. Məxüd mane cigayn xhyan qeqqva'an. Xhyan q'öne cigeeqa qexhe. ");
INSERT INTO tkr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","İzrailybıb deryahne xhyan deşde cigayle k'ena ılğeepç'ı avayk'ananbı. Xhyanbı cabırbı xhinne qetxha manbışde sağneyiy solne sural ulyoyzar. ");
INSERT INTO tkr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misirbı gyabak'anbı manbışde qihna. Fironun dəv'əyn daşk'abı, balkanaaşil alepxıynbıb manbışde qihna k'eebaç'enbı deryaheeqa. ");
INSERT INTO tkr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Rəbb verığna ul üvxəsse buludneyiy ts'ayıne dirakeençe horzul Misirbışin g'oşunbı sana-sançil alikka'a. ");
INSERT INTO tkr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Mang'vee dəv'əyne daşk'abışin tekarbı sacuraycad qa'a, mançisse yugda alik'aras məxəcenva. Misirbışe eyhen: – Qudoora inçe heepxas! Rəbbee İzrailybışin sura aqqı, şakınıd ha'as ıkkan. ");
INSERT INTO tkr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Rəbbee Mısayk'le eyhen: – Xıl deryahılqa hotke xhyanbı çine cigeeqa satk'ıl, maabın Misirbı dəv'əyne daşk'abışika, balkanaaşil alepxıynbışika sacigee çik avub g'alee'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mısee deryahılqa xıl hodakke, xhyanbıd miç'eeqana çine cigeeqa siyk'al. Misirbı xhineençe heebaxamee, Rəbbee manbı haly'av'u deryahne yı'q'neeqa g'aa'a. ");
INSERT INTO tkr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","İzrailybışiqa qihna deryaheeqa k'eeç'uyn dəv'əyn daşk'abı, balkanaaşil aleepxıynbı, gırgınacab g'oşun yı'q'əlqa satk'ılne deryahne xhyanbışee hööğəna. Mançe şavussecar g'attixhanas əxə deş. ");
INSERT INTO tkr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Məxüd ıxha İzrailybı deryahne yı'q'neene xhyan deşde cigayle k'ena ılğeepç'ı avayk'an. Xhyan manbışde sağneyiy solne sural çabır xhinne ulyoyzar. ");
INSERT INTO tkr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mane yiğıl İzrailybı Rəbbee Misirbışde xılençe g'attivxhan haa'a. Qiyğa manbışik'le Misirbı deryahne mıglek hapt'ı g'ooce. ");
INSERT INTO tkr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","İzrailybışik'le Misirbışik Rəbbee xənne gucuka hı'iyn g'acumee, manbı Rəbbile qəvəyq'ən giviyğal. Mang'ulqayiy Mang'une g'ululqa, Mısalqa, inyam ha'a giviyğal. ");
INSERT INTO tkr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mane gahıl Mıseeyiy İzrailybışe Rəbbis ina mə'niy haa'a: – Rəbbis ina mə'niy qəpqəs, Mang'vee Cun do geed axtı qı'ı! Balkanıb, çil alixınar, Mang'vee deryaheeqa g'av'u! ");
INSERT INTO tkr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Rəbb Yizda guciy mə'niy vorna, Mang'vee zı g'attixhan hı'ı. Mana Yizda Allah vorna, zı Mana qıvats'a'asda! Mana yizde dekkeeyid ı'bəədat hı'ına Allah vorna, zı Mana axtı qa'as! ");
INSERT INTO tkr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Gırgıne duşmanaaşile ğamxhesde Rəbbin do YAHVE vodun! ");
INSERT INTO tkr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Dəv'əyne daşk'abışika fironna g'oşun deryaheeqa dağav'u! Misirin nekke yugun ç'ak'ınbı Ç'ərane deryahın höbğü! ");
INSERT INTO tkr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Xhyan manbışile g'alysikkı, k'oralybışeeqa manbı g'ayebı xhinne qavayk'an apk'ın! ");
INSERT INTO tkr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Rəbb, Ğu Yiğne gucuka qıvats'ı! Ğu duşmanar g'ulyotal haa'a! ");
INSERT INTO tkr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ğu Yiğne xənne gucuka, Ğu qidvyaats'anbışikın ha'a! Yiğne qəlın, ts'ayın balybiy gyoxhan ha'an xhinne, manbı gyoovxhan hav'u! ");
INSERT INTO tkr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Yiğne nafasın xhyanbı sacigeeqa sa'a, Sacigeeqa sadıyne xhineke cabırbı ha'a, İttehesu deryahne k'oralybışeedın xhyanbı qiyğara'anbı! ");
INSERT INTO tkr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Duşmanee eyhenniy: «Qihna girxhu, zı manbı avqas, Aqqıyn karıd zı bit'al ha'as! Mançike yizın rı'hcad ats'es! Qiyğale xhineyid g'ılınc qığahas, yizde xılekacab zı manbı gyapt'as!» ");
INSERT INTO tkr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ğu manbışis uf üvxü, deryahın manbı höbğü! Gurğuşun xhineyib manbı k'oralybışeene xhinek avqa apk'ın! ");
INSERT INTO tkr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ya Rəbb, vornane Vaka sa aqqasda allahaaşine əree? Muq'addasvallee azamatıka, Vasse xhinne mö'ücüzebı ha'as əxəna vornane? Yiğne xəbvalile xhinne qəvəəq'ənasda merna vornane? ");
INSERT INTO tkr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ğu sağın xıl hotkumee, ç'iyeyn manbı höbğüynbı! ");
INSERT INTO tkr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Vaqa badaldyooxhena yugvallava, Ğu xalq' g'attixhan hı'ı, Ğu manbışis yəq haagu! Ğu eyxhene Yiğne muq'addasne cigeeqa, Ğu Yiğne gucuka quvkees! ");
INSERT INTO tkr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Milletbışik'le man g'ayxhı, tanbışeeqa zeze avxhas, Filiştinar mançile geeb qəvəəq'ənas, ");
INSERT INTO tkr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edomun ç'ak'ınbı qəpq'ı'niyn alyabat'a, Moav vuk'lek vukkeekanbışik zeze ooxha, Kana'anın milletıd nyaqame ixhesın axva! ");
INSERT INTO tkr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Havaasre manbışilqa zeze avkkecen, qəvəq'necen! Rəbb, Yiğne xılene gucen, Yiğın millet ılğeç'esmee manbı g'ayelqa savk'alas, nıq'-ç'ı'q' dena aaxvas! Ya Rəbb, Ğu nukariyvalike g'attixhan hı'iyn millet ılğeç'esmee! ");
INSERT INTO tkr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ya Rəbb, Ğu Yiğın millet qalessın Yiğne suvalqa, Ğu Yiğne Xaasva g'əyxı'yne cigee, Ğu manbışis ciga qaa'as, Ey Xudaavand, Ğu Yiğne xıleka itxhınne muq'addasne cigee! ");
INSERT INTO tkr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Rəbbee gırgıne gahbışil, hammaşe paççahiyvalla haa'as! ");
INSERT INTO tkr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Fironun dəv'əyn daşk'abı, balkanaaşil alepxıynbı deryaheeqa k'epç'ımee, Rəbbee manbışilqa deryahın xhyanbı yı'q'əlqa qalya'a. İzrailybımee deryahne xhyan deşde cigayle k'ena ılğeepç'ı avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Harunne yuçee, peyğambar Mayramee, xıleqa dyaf alyat'umee, gırgıne yedaaşed xıleqa dyafbı alyat'u, məng'ı'qab qihna mık'ar ha'a avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mayramee manbışis ina mə'niy qəpqı': – Rəbbinemee qəpqe, Mang'vee Vuc axtı qı'ı. Balkanıb, cil alixınar Mang'vee deryaheeqa g'av'u. ");
INSERT INTO tkr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mısee İzrailybı Ç'ərane deryahısse Şur eyhene sahreeqa quvkekka. Xhebılle yiğna manbı sahrayle k'ena avayk'an, maa'ad manbışisqa xhyan qızaxxa deş. ");
INSERT INTO tkr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Manbı Mara eyhene cigeeqa qabı hipxhıriyng'a, maadın xhyanıd q'ap'ıdava ulyoğas əxə deş. Mançil-allad mane cigayn do Mara (q'ap'ın) axva. ");
INSERT INTO tkr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Milletın «Hucoone ulyoğasva?» Mısaylena haa'a giviyğal. ");
INSERT INTO tkr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Manke Mısee Rəbbilqa ona'a, Rəbbeeyid mang'uk'le sa os hagva. Mısee man os xhineeqa dağadaççe, mançile qiyğa man xhyan uloğasın xhinne qexhe. Rəbbee maa manbışis g'ayda-q'aanun huvu, maayib siliys üvxü. ");
INSERT INTO tkr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Mang'vee eyhen: – Şu Yizde, Rəbbine, vuşde Allahne cuvabıl yugda k'ırı alixhxheene, Yizde ögiyl qotkun işbı he'eene, Zı he'eva uvhuynçil k'ırı gyaqqı q'aanunbışee hagvan xhinne he'eene, Misirbışilqa g'axuvuyne ık'arbışin nencad şolqa g'axıles deş. Şu yug qaa'ana Rəbb Zı vorna. ");
INSERT INTO tkr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Manbı qavaylenbı Elim eyhene cigeeqa. Mane cigee yits'ıq'ölle (12) xhyan ı'lqəən cigayiy yights'al (70) xurmayna yiv vooxhe. İzrailybışe mane xhyanbı ı'lqəəne cigabışde hiqiy-alla çadırbı giyxə. ");
INSERT INTO tkr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","İzrailybışin cəmə'ət Elimğançe ayk'anan. Manbı Elimneyiy Sinayne yı'q'neene, Sin eyhene sahreeqa Misirğançe qığepç'iyne q'öb'esde vuzane yits'ıxhob'esde (15) yiğıl qabı hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Sahree milletin Mısaylenayiy Harunulena haa'a giviyğal. ");
INSERT INTO tkr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","İzrailybışe manbışik'le eyhe ıxha: – Misir çurunane k'umk'umbışde k'ane gyuv'urne gahıl, avts'esınmeen gıney otxhanang'a, Rəbbine xılençe ma'ab hapt'ıynxhiy nimee yugda eyxheyiy. Şunad inimeen millet sahreeqa mıssıka gyapt'as qadı! ");
INSERT INTO tkr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Rəbbee Mısayk'le eyhen: – Zı şolqa xəənçe gıney gyoğa'as. Hasre millet yiğıs qığeç'ecen, çisın yiğısiysın gıney se'ecen. Zı manbı Yizde q'aanunbışil k'ırı iliyxheyeva məxüb siliys üvxəs. ");
INSERT INTO tkr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Yixhıd'esde yiğıl q'öd şene yiğbışilinmeen sı'ı, ögiykecad otxhanan kar he'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mıseeyiy Harunee İzrailybışik'le eyhen: – Exhal şok'le ats'axhxhesın Misirğançe şu Rəbbee qığav'u vuxhay. ");
INSERT INTO tkr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Miç'eedmee şok'le Mana inyaa ıxhay, Mang'una xəbvalla g'avcesda. Rəbbik'le g'ayxhin şu Culena haa'a. Şi vuşbıne vooxhee, şu şalena haa'a? ");
INSERT INTO tkr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mısee manbışik'le meed eyhen: – Şok'le inəxüd ats'axhxhes Mana Rəbb ıxhay: g'iyna exhal Mang'vee şos çuru heles, miç'eedıd avts'esınmeen gıney. Mang'uk'le g'ayxhiyn şu Culena haa'a. Nya'a şi vuşbune vooxhe? Şu şalena deş, Rəbbilena ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mısee Harunuk'le eyhen: – İzrailyne cəmə'ətık'le eyhe: «Rəbbine ögiylqa savaale, Mang'uk'le g'ayxhiyn şu Culqa alepçiy». ");
INSERT INTO tkr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Harun İzrailyne cəmə'ətıka yuşan ha'ane gahıl, cəmə'ətın vuk'ulybı sak'al ha'anbı sahrayne suralqa. Sayid manbışik'le buludne dirakee Rəbbin nur ıxhay g'ece. ");
INSERT INTO tkr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","– Zak'le İzrailybışe Zalena haa'a g'ayxhı. Manbışik'le eyhe: «Exheqana şu çuru oxhanas, miç'eedıd avts'esınmeen gıney. Manke şok'le ats'axhxhesın Zı Rəbb, vuşda Allah ıxhay». ");
INSERT INTO tkr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Exheeqana bilydirçinar aletxu qadı çadırbı gı'xı'yn ciga gyatsts'a'an. Miç'eebiysıb mane cigayne hiqiy-alla ç'iy ı'xiyxə. ");
INSERT INTO tkr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ç'iy ts'ıts'axhamee, ç'iyene aq'val k'üvən xırıp'-xırıp' ha'an g'iravuk akaran sa kar axva. ");
INSERT INTO tkr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ixhyanbı g'acu İzrailybışe sana-sang'uk'le eyhen: – İn hucoone? Manbışik'le man hucoo ıxhay ats'a deşdiy. Mısee manbışik'le eyhen: – İn Rəbbee şos oxhanasva huvuyn gıney vod. ");
INSERT INTO tkr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Rəbbee inva şok'le uvhu: «Sı'iyle qiyğa, həməxüd he'e, xizaneene insanaaşis sik'ı ixhecen, gırgıng'ulqa sa vexhxheedın hixhrecen». ");
INSERT INTO tkr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","İzrailybışe gırgın cok'le uvhiyn xhinne ha'a. Sanbışe geed sa'a, mansanbışe k'ılda. ");
INSERT INTO tkr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Vexhxhayka gyoobakka gibğılmee, geeb sav'uyng'unab hexxaba haagu deş, k'ılyba sav'uyng'unab k'ılyba haagu deş. Gırgıng'vee q'aralika sav'una xhinnecab haa'gva. ");
INSERT INTO tkr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mısee manbışik'le eyhen: – Vuşde neng'veecad miç'eediys vuççud g'ılymadaççe. ");
INSERT INTO tkr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Sassanbışe Mısayl k'ırı ilydiyxhı kar miç'eediys g'aledaççe. Mane otxhuneeqa mı'qər a'a, mançike eva g'əə giyğal. Mısee manbışilqa qəl haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Miç'eeb gırgıng'vee cus vukkanameena q'aralika sa'a vuxha. Qiyğa verığ pıra quvxhamee, mana xhinelqaniyxhe siviyk'alna. ");
INSERT INTO tkr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Yixhıd'esde yiğıl manbışe q'öd manimeen otxhuniy sa'a, sang'ulqa q'öble vexhxha gyooxha vuxha. Cəmə'ətne ç'ak'ınbışe co nimeen kariy sı'ıva abı Mısays yuşan ha'an. ");
INSERT INTO tkr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mısee manbışik'le eyhen: – Rəbbe inəxüdud eyhe: «G'iyqiyn ülycümün yighıd'esın, manzil haa'an yiğ vod. Man muq'addasın Rəbbin yiğ Şabbat vod. G'iyniykecad qecesın qece, qoxhxharasınıd qoxhre. Hexxada axuynıd g'iyqiys havace». ");
INSERT INTO tkr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Manbışe otxhuniy Mısee uvhiyn xhinne g'iyqilqamee havacıva, mançeeqa mı'q'ərıd ı'ı deş, evad eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mısee eyhen: – G'iyna şu man otxhanan kar oxhne. G'iyna Rəbbin yiğ, Şabbat vod. Şok'le g'iyna g'ad oxhanas vuççud aveykes deş. ");
INSERT INTO tkr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Şu man kar yixhne yiğna se'e, Şabbatıl, yighıd'esde yiğıl, şok'le vuççud aveykes deş. ");
INSERT INTO tkr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Milletıken sabara insanar yighıd'esde yiğılib otxhuniy sa'asva qığepç'eyib manbışik'le vuççud iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Rəbbee Mısayk'le eyhen: – Şu mısılqameene Zı g'ixhxhiyne g'ayda-q'aanunuka gyuv'ur-oza qıdeepxhes? ");
INSERT INTO tkr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","İlyaake, Zı, Rəbbee şos Şabbatın yiğ huvu, mançil-allad Zı yixhıd'esde yiğıl şos q'öd manimeen otxhuniy hele. Yighıd'esde yiğılyıb gırgınbı cone xaybışee gyuv'urecen, əq'ənaqa ımaak'anancen. ");
INSERT INTO tkr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Məxüb milletın yighıb'esde yiğıl manzil haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mane otxhuniyn do İzrailybışe manna giyxhe. Mana vuc k'aşnişne toxumukub akar, rangısıb cagvaraba vob. Opxhıniysıb itv qadğuyn k'alet xhinne vob. ");
INSERT INTO tkr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mısee eyhen: – Rəbbee inəxüd he'eva vod eyhe: «Sa vexhxha mannayna alyapt'ı şole qiyğiyne nasılbışis havaace. Hasre manbışik'led g'acecen, Zı şu Misirğançe qığav'uyng'a şos sahree huvuyn gıney». ");
INSERT INTO tkr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mısee Harunuk'le eyhen: – Kup alyaat'u mançeeqa sa vexhxha mannayna haç'ee'e. Qiyğad Rəbbine ögiylqa gixhxhe qihniyne nasılbışis havaces ixhecen. ");
INSERT INTO tkr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Rəbbee Mısayk'le uvhuyn xhinne, Harunee havacesva mannanan kup mugaavilenane q'utyeyne hiqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","İnsanarnane cigeeqa, Kana'anqa, qavaalesmee, İzrailybışe yoq'ts'al (40) senna manna ooxhan. ");
INSERT INTO tkr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Sa omer efana yits'ıb'esda pay vobna). ");
INSERT INTO tkr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Gırgın İzrailin cəmə'ət Sin eyhene sahreençe yəqqı'lqa qığeç'e. Rəbbe manbışik'le uvhuyn xhinne manbı ulyoozar-ulyoozar avayk'an. Manbı Refidim eyhene cigeeqa qabı çadırbı g'iyxə. Maa'ad milletın ulyoğasın xhyan eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mançil-allar manbışe Mısa t'yats'axal hı'ı eyhen: – Şas ulyoğasın xhyan hele! Mısee manbışik'le eyhen: – Nya'a şu zak'le cuvabbı eyhe? Nişil-allane şu Rəbb siliys ı'xı'yxə? ");
INSERT INTO tkr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Milletıs xhyan ıkkan eyxhe. Mançil-allad manbışe Mısa t'yats'axal hı'ı eyhen: – Nya'a ğu şi Misirğançe qığav'u? İn ğu şak, şinab, yişin uşaxarıb, həyvanarıd xhineka gyatt'asdemene hı'ı? ");
INSERT INTO tkr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mısee Rəbbilqa onu'u eyhen: – İne milletık zı hucoone ha'as? Manbı zalqa g'aye gyooğa'asınçıl qepxha vob. ");
INSERT INTO tkr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Rəbbee Mısays inəxdun alidghıniy qele: – Vakasana sabara milletın ağsaqqalar qopt'ul milletne ögiyl hoora. Nil eyhene damays ı'xı'yn əsayid xılyaqa aleet'e. ");
INSERT INTO tkr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Maane Xorev eyhene ganzıl Zı yiğne ögiyl ulyozaras. Mane yiğne xılene əsaaka ganzıle k'ena it'umda ı'xe, mançeençe milletıs ulyoğasın xhyan qığeç'es. Mısee İzrailyne ağsaqqalaaşine ögiyl həməxüd ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mısee mane cigaynıd do Massayiy Meriva (siliys ı'xı'y, cuvabbı uvhiy) giyxhe. Ma'ad İzrailybışe cok'le cuvabbı eyheva, «Rəbbir şakaniyxan deşxhee, de'eşdaniyxanva» uvhu, Rəbbir siliys ı'xı'va man do giyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Mançile qiyğa Amalekar Refidimeeqa abı İzrailybışika suç'ookanbı. ");
INSERT INTO tkr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mısee Yeşuayk'le eyhen: – Hark'ın milletıke insanar g'əvxe, yişdemee Amalekaaşika saç'uvkecen. Zı g'iyqa Allahne əsaaka tepayne q'oma ulyozarasda. ");
INSERT INTO tkr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yeşueeyid Mısee uvhuyn xhinne ha'a, hark'ın Amalekaaşika siç'ekkvana. Mısa, Harun, Xur hapk'ın ılqeebaç'enbı tepayne q'omaqa. ");
INSERT INTO tkr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mısee xıleppı ooqa qı'ımee İzrailybı ğamebaxhenbıniy, mang'un xıleppı ozzur avqa qeetxhamee, ğamebaxhe giviyğalanbı Amalekar. ");
INSERT INTO tkr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mısayn xıleppı oyzaranbı, mang'usse xıleppı orzuliyvalike ooqa qa'as dəxəmee, Haruneeyiy Xuree g'aye abı Mısa çilqa gya'a. Mang'un sa xıl aqqaqqan Harunee mansad Xuree. Məxüd verığ k'yooçesmee, manbışe mang'un xıleppı xəə aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Məxüb Yeşuee Amalekbı cune g'ılıncıke alğaa'a. ");
INSERT INTO tkr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Rəbbee Mısayk'le eyhen: – İnsanaaşe yik'el aqqecenva kitabeeqa ok'ne. Qiyğad Yeşuayk'le eyhe, Zı Amalekaaşin docad ç'iyene aq'vale hakkal ha'asın. ");
INSERT INTO tkr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mısee q'urban ablya'an ciga ali'ı çin doyud YAHVE Nissi (zas Rəbbee ğamxhesda guc hoole) gixhxhı, ");
INSERT INTO tkr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","eyhen: – Zı Rəbbilqa k'ın g'iysar, Rəbbee Amalekaaşikana dəv'ə ç'əv ha'as deş. ");
INSERT INTO tkr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Midyanaaşine kaahinık'le, Mısayne abatteyk'le İtronuk'le Allahee Mısayneyiy İzrailybışdemee hı'iyn karbıyiy Rəbbee manbı Misirğançe qığav'uy g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Mısayne abattee İtronee Mısayna xhunaşşe Tsipporayiy q'ööle uşax yı'q'əlqa qıkkeka. Mısee ögiylycarniy cuna xhunaşşe dekkıne k'anyaqa g'axiyvu. Mısee «Zı menne cigee, merna xhinne ıxhava» uvhu, dixbışde sang'un do Gerşomniy (menne cigayna) gixhxhı. ");
INSERT INTO tkr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","«Dekkee ı'bəədat hı'iyne Allahee zas kumag hı'ı, fironne g'ılıncıke g'attixhan hı'ıva» uvhu, mansang'unud do Eliyezerniy (Allahee zas kumag ha'a) gixhxhı. ");
INSERT INTO tkr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mısayna abattey İtron, dixbışikayiy xhunaşşeyka sacigee sahreeqa Mısa eyxhene Allahne suvaysqa arayle. ");
INSERT INTO tkr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","İtronee Mısayk'le eyhecenva insan g'ıxele: – Zı yiğna abattey İtron xhunaşşeykayiy q'öne yiğne dixeka vasqa ı'qqə vor. ");
INSERT INTO tkr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mısa abbateysqa qığeç'u mang'une ögiyl k'yorzul, ubba ha'a. Sana-sang'uke qidghınbı ha'a manbı çadıreeqa ikkebaç'e. ");
INSERT INTO tkr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mısee abatteys, Rəbbee İzrailybışdemee fironulqayiy Misirbışilqa alli'iyn yiğbı, co yəqqə opxhunna əq'üba, sayib Rəbbee co nəxübiy g'attivxhan hav'uva yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","İtron Rəbbee İzrailybışis yugvalla hav'uva, manbı Misirbışde xılençe g'attivxhan hav'uva geer şadexhena. ");
INSERT INTO tkr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Mang'vee eyhen: – Şu fironneyiy Misirbışde xılençe g'attivxhan hav'une Rəbbis şukur vuxhena! ");
INSERT INTO tkr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Həşde zak'le ats'an Rəbb manisa allahaaşile nimeexheyir xərra vor. Mang'vee millet hooyç'an-g'oyç'anne Misirbışde xılençe g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Qiyğa Mısayne abattee İtronee, Allahıs medın-medın q'urbanbı allya'a. Haruniy İzrailybışin ağsaqqalar, Mısaykayiy cune abatteyka sacigee Allahne ögee gıney oxhanas abayle. ");
INSERT INTO tkr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Qinne yiğıl Mısa milletne məhkamayqa ilyakka. Milletıd miç'eediyle exhalqamee Mısayne hiqiy-alla iliyk'ar ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mısayne abatteyk'le mang'vee milletık ha'an g'acumee, eyhen: – Ğu hucoone milletık ha'a? Nya'a ğu sayrena məhkama ha'a, nya'a manimeen millet yiğne hiqiy-alla miç'eediyle exhalqamee iliyk'ar axu? ");
INSERT INTO tkr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mısee eyhen: – Millet zasqa Allahee eyhen ats'axhxhes adayle. ");
INSERT INTO tkr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","İnsanar sana-sang'uka parxaçeepxhamee, zasqa abayle. Zınad manbışde neng'uqa nena bınahiyva eyhe. Sayid zı manbışis Allahne g'ayda-q'aanunbışike yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Abattee Mısayk'le eyhen: – Ğu man qotkuda deşod ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ğunar, vasqa abaylenbıb mançike saccu oozaranbı. Sang'unemee mana geeb yı'q'na işib. Vassecab mana iş haa'as vəxəs deş. ");
INSERT INTO tkr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ğu zal yugda k'ırı gyaqqe, zı vak'le həşde sa kar eyhes. Hasre Allahır vaka ixhecen! Allahneyiy milletne yı'q'nena ixhe, milletın nyaabiy dağamiyvalla opxhan, ğu Mang'us yuşan he'e. ");
INSERT INTO tkr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Manbışik'le g'ayda-q'aanun, ha'asın işbı, qopkuna yəq haagve. ");
INSERT INTO tkr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Milletıke kar əxən, Allahıle qəvəyq'ənan, cuvabıl ulyoozaran, pılıka alivşes dyooxhen insanar g'əvxe. Manbı aazırıng'us (1 000), vəşing'us (100), xhots'aling'us (50), yıts'ıng'us (10) ç'ak'ınbı xhinne gyuvxhe. ");
INSERT INTO tkr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Manbışe məhkamabı he'ecen. Cosse ha'as əxən işbı hasre cocad he'ecen, dağamınbıd, dəxənbıd vasqa allecen. Məxüd manbışe vas kumag ha'as, valqa gyooxhana işib k'ıl quvxhes. ");
INSERT INTO tkr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ğu məxüd he'eene, Allahısıd man ıkkiykıneene, vasse örxəs əxəsda. Milletıd yik' sibık qı'ı xaaqa siyk'alıy. ");
INSERT INTO tkr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mısee abattel k'ırı alixhxhı, mang'vee eyhen xhineyid ha'an. ");
INSERT INTO tkr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mısee İzrailybışde əreençe kar əxənbı g'əvxü, milletıs ç'ak'ınbı xhinne giviyxhe. Manbışike aazırıng'us, vəşing'us, xhots'aling'us, yıts'ıng'us ç'ak'ınbı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Mane yiğile otçu manbışe milletıs məhkamabıd ha'a ıxha. Manbışe cosse əxən işbı cocad ha'a ıxha, dağamınbı, dəxənbı Mısaysqa adayle ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Qiyğa Mısee cuna abattey yəqqı'lqa araççe. Abatteyir siyk'alna cune ölkeeqa. ");
INSERT INTO tkr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","İzrailybı Misireençe qığepç'iyne xhebıd'esde vuzane ts'eppiyne yiğıl Sinayne sahreeqa hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Refidimğançe qığeepç'ı, manbı qavaylenbı Sinayne sahreeqa. Manbışe suvalqa ı'lqəəne cigee çadırbı giyxə. ");
INSERT INTO tkr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mısa suvalqa Allahısqana ılqeç'e. Rəbbee mana suvale qort'ul eyhen: – Yaaq'ubıke g'abıynbışik'le, İzrailybışik'le eyhe: ");
INSERT INTO tkr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","«Şok'le Zı Misirbışik hı'iynıd, nəxübiy şu q'aacirın xhinne xılibışil Zasqa qabıyid g'acuyn. ");
INSERT INTO tkr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Həşdiyle şu Yizde cuvabıl yugda k'ırı gyaqqeene, Yizda şokana mugaavile havaaceene, manisa milletbışile Zas delesın millet şu vuxhes. İn dyunyecad Yizın vodun, ");
INSERT INTO tkr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","şunab Yizdemee kaahinaaşin ç'ak'ınbı, paççahar vuxhes, muq'addasın millet ixhes». Man gırgıne İzrailybışik'le eyhe. ");
INSERT INTO tkr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mısa avqa giç'u milletın ağsaqqalar sav'u, Rəbbee uvhuyn gırgın manbışis yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Milletıncad inəxdun alidghıniy qele: – Rəbbee uvhuyn gırgın şi ha'asın! Mısee manbışin alidghıniy Rəbbis hixhar ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Rəbbee Mısayk'le eyhen: – Zı yiğne k'anyaqa k'ışşeyne buludee ayres, milletık'le Zı vaka yuşan ha'a g'ayxhı valqa gırgıne gahbışiscad inyam he'ecenva. Mısee milletın uvhuyn Rəbbilqa hixhara'ang'a, ");
INSERT INTO tkr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Rəbbee meed Mısayk'le eyhen: – Milletısqa hark'ın manbışik'le eyhe: g'iynayiy g'iyqa manbı məttıba vuxhecen, tanalinbıd hoğlecen. ");
INSERT INTO tkr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Qıtsıqiys Rəbbee nəxüdiy uvhu, həməxübub vuxhecen, Rəbb milletne ulene ögiyl Sinayne suvalqa giç'es. ");
INSERT INTO tkr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Suvayne hiqiy-alla milletnemee sarhad ts'ıts'av'u manbışik'le eyhe: «Suvalqa ılqımeebaç'e, mançik xıl simet'a. Suvayk xıl set'una g'ılymaraççe, gik'e. ");
INSERT INTO tkr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Məxrına ixheene, g'ayeyqqaye hele vukukaye gek'a gik'e, saccu mang'uk xıl simet'a. İnsan ixheeyir həyvan vuxheeyib əq'ənançecab gyuvk'e, g'ılymabaççe». G'argıne gaçençe xıliyna syuty hav'umee, manbışisse suvalqa ılqeepç'es vəəxə. ");
INSERT INTO tkr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mısa suvayle g'iç'u milletık'le gicəpxeva eyhe. Manbışed tanalinbı hoyğalanbı. ");
INSERT INTO tkr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mang'vee milletık'le eyhen: – Qıtsıqiys Rəbbee nəxüdiy uvhu, həməxübub vuxhe. Sayid yik'el aqqe yadaaşik xıl simet'a. ");
INSERT INTO tkr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Xhebıd'esde yiğıl miç'eed xəy g'əhədaqqə giyğal, ts'ayılpan eyxhe, k'ışşeyn bulud suval ooqa sadayle, g'argıne gaçençenab it'umna syuty vooxhe. Çadırbışisneebın gırgın insanar mançile it'umba qəvəyq'ənanbı. ");
INSERT INTO tkr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mısee Allah qızaxecenva insanar cone çadırbışisse suvaysqa saa'a. ");
INSERT INTO tkr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Rəbb Sinayne suvalqa ts'ayıne ar giç'uva suva kumayncab alyabat'a. Mane suvayle xənne peşteençen xhinne kuma ı'lqəə eyxhe. Mane gahıl suva it'umba ı'ğviykarna, ");
INSERT INTO tkr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ittehesu g'argıne gaçençena syutyub geeb qooxhe giviyğal. Mısee eyhençis Allahee alidghıniy xəybı g'əhədəqqəne seseka qele ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Rəbb Sinay eyhene suvayne q'omaqa giç'u, maqa Mısa qoyt'al. Mısa maqa ılqeç'umee, ");
INSERT INTO tkr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Rəbbee mang'uk'le eyhen: – Giç'e milletık'le eyhe, Rəbb g'acesva çosva gyuvxhune sarhadıle ılğımebaç'ecen. Uvhuyn hide'eene con gellesınbı hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Rəbbisqa qeepxhesın kaahinaaşin ç'ak'ınbıb gicəpxı' vuxhes vukkan. Uvhuyn hide'eene Rəbbee manbışikınıd ha'asın. ");
INSERT INTO tkr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mısee Rəbbik'le eyhen: – Nya'a Ğu şak'le uvhu dişdiy «Suvayne hiqiy-alla sarhad ts'ıts'av'u mançike er hee'eva». Mançil-allad milletın Sinayne suvalqa gov gyuvxhes deş. ");
INSERT INTO tkr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Rəbbee eyhen: – Giç'e, vakasana inyaqa Harun ayre. İlahiyetçeeşine ç'ak'ınbışeb, milletınıd suvalqa Rəbbisqa ı'lqəəva sarhad ılğımooç'ecen. Uvhuyn hide'eene Rəbbee cokun ha'asın. ");
INSERT INTO tkr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mısa suvayle giç'u man uvhuynbı milletılqa hixhar ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Allahee inəxdun əmrbı huvu: ");
INSERT INTO tkr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Zı Rəbb, yiğna Allah vorna, ğu Misireençe qığavhuna, nukariyvalike g'attixhan hı'ına. ");
INSERT INTO tkr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Hasre vaqa Zale ğayrı mebın allahar mooxhecen. ");
INSERT INTO tkr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ğu vasda byut xəybışker, ç'iyebışker, xhyanbışker hıma'a. ");
INSERT INTO tkr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Məxdıne byuttyaaşis k'yumoyzar, ı'bəədat hıma'a. Zı Rəbb, yiğna Allah vorna, şu merna Zaka sa aqqaqqamee Zı mançis öörəxə deş. Zı g'ımece eyxhene dekkaaşine uşaxaaşilqa xhebne-yoq'ne nasılee Zı yiğbı allya'as. ");
INSERT INTO tkr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Zı ıkkiykın, Zı uvhuynbı ha'anbışdemee aazır nasılbışis yugvalybı ha'as. ");
INSERT INTO tkr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nişil-alla qadiy Rəbbin, yiğne Allahın do ghalelqa ılymaat'a. Məxrına ixheene Rəbbee yiğbı allidyı'ı g'alerçes deş. ");
INSERT INTO tkr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Şabbat yik'el aqqe. Man yiğ manisa yiğbışike curu'u, muq'addasın yiğ he'e. ");
INSERT INTO tkr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Yixhne yiğee yiğın gırgın işbı g'acu ç'əv he'e. ");
INSERT INTO tkr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Yighıd'esın yiğıd, Şabbatıd hasre Rəbbis, yiğne Allahıs ixhecen. Mane yiğıl ğunab, dixbışeb, yişbışeb, nukaraaşeb, həyvanaaşed, menne cigeençe qabı yiğne şaharbışee aaxvanbışeb nenacab iş hımaa'acen. ");
INSERT INTO tkr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Yixhne yiğee Rəbbee xəybıyiy ç'iye, deryahbı, dyunyeylin gırgıncad kar itxhın. Yighıd'esdemee yiğıl Mang'vee manzil haa'a. Mançil-allab Rəbbee Şabbatne yiğıs barakat hoole, man yiğ manisa yiğbışike cura'an, muq'addasın yiğ ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Dekkısiy yedis hı'rmat gyuvxhe. Mançil-allab ğu, Rəbbee, yiğne Allahee, vas huvuyne cigabışee xıliyna ı'mı'r haa'as. ");
INSERT INTO tkr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","İnsan gimek'a. ");
INSERT INTO tkr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Zina hıma'a. ");
INSERT INTO tkr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Qümöqə. ");
INSERT INTO tkr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Merıng'vee hıdi'ıyn, karaı'dəən kar gardanaqa gimiyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Merıng'une karalqa ul hımaa'a. Şavnecab xaalqa, xhunaşşelqa, nukarılqa, yats'ılqa, əməlelqa nişilqacab ul hımaa'a. ");
INSERT INTO tkr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Milletık'le ts'ayılpan, xəybı g'əhədəqqə, suvayle ı'lqəən kuma g'acumee, g'argıne gaçeençena syuty g'avxhumee, manbı it'umba qəpq'ı'n suvayle əq'əna qeebaxhe. ");
INSERT INTO tkr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Manbışe Mısayk'le eyhen: – Ğucar şaka yuşan he'e. Ğu eyhen şak'le g'ayxhes. Hasre Allah şaka yuşan hıma'acen. Mana şaka yuşan he'ee, şi hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mısee milletık'le eyhen: – Qıməəq'ən. Allah şu siliys üvxəs arı. Mana sayid şu bınahbı hıma'acenva, şu qəvəəq'əna'ascar arı. ");
INSERT INTO tkr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Millet əq'əna ulyoyzar. Mısar ayk'anna Allahnane k'aarıne buludusqa. ");
INSERT INTO tkr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Rəbbee Mısayk'le eyhen: – Ğu, Harun, Harunun dixbı Nadav, Avihuyiy sayir İzrailybışde ağsaqqalaaşike yights'al (70) insan Zasqa ılqeepç'ı, Zas əq'ənançecab k'yoozre. ");
INSERT INTO tkr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Qiyğaler, Zasqana saccu ğu qixhe mansabı deş. Millet inyaqa ılqımeç'ecen. ");
INSERT INTO tkr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mısee Rəbbee uvhuynbıyiy Mang'un g'ayda-q'aanun milletıs yuşan hı'ımee, milletıncad mang'us cuvab qele: – Şi gırgın Rəbbee uvhuyn xhinne ha'as! ");
INSERT INTO tkr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mısee Rəbbee uvhuyn gırgın oyk'anan. Mana miç'eer çakra suğotsu suveeqa ı'lqəəne cigee q'urbanbı allya'an ciga alya'a. Qiyğale İzrailyne yits'ıq'öne (12) nasılıs curayda-curayda mang'vee g'ayeyn dirakbı ulyozar ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mançile qiyğa mang'vee İzrailyne mek'vunbışisqa Rəbbis mek'vun congariy medın-medın q'urbanna allya'as ilekka. ");
INSERT INTO tkr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mısee həyvanaaşike gyopts'una sura eb lyagameeqa saa'a, avxunab q'urbanbı allya'an cigalqa k'yaa'a. ");
INSERT INTO tkr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mang'vee Rəbbika mugaavilenan kitab alyaat'u, maa'ad otk'uninbı milletıs qədəqqə. Milletın eyhen: – Şi Rəbbee uvhuyne gırgınçil k'ırı gyaqqı, gırgın Mang'vee eyhəxüd ha'as. ");
INSERT INTO tkr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Qiyğa Mısee lyagameena eb alyapt'ı milletılqa hooçav'u eyhen: – Haane Rəbbee şoka hav'uyne mugaavileyna eb. Mang'vee uvhuyn karbı mugaavile vob. ");
INSERT INTO tkr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mançile qiyğa Mısa, Harun, Nadaviy Avihu, sayir yights'al (70) İzrailyna ağsaqqal suvalqa ılqeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Maa'ar manbışik'le İzrailybışda Allah g'ece. Mang'une g'elybışik avud lagarane gıranne g'ayeyke hı'iyn, məttın xəy xhinnen sa kariyne. ");
INSERT INTO tkr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Allahee İzrailyne ç'ak'ınbışilqa xıl g'oyt'al deş. Manbışe otxhun-ulyooğan, Allahır g'ecena. ");
INSERT INTO tkr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Rəbbee Mısayk'le eyhen: – Suvalqa Zasqa ılqeç'u, maa ulyozre. Zı vasqa, millet xət qa'asva hets'uyne g'ayebışil Zı opk'unna q'aanun, g'ayda qevles. ");
INSERT INTO tkr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mısa Allahne suvalqa ılqeç'esva cus kumag ha'ane Yeşuayka ayk'an. ");
INSERT INTO tkr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mang'vee ağsaqqalaaşik'le eyhen: – Şi şosqa savk'alasmee inyaa ulyoozre. Haruniy Xur şoka aaxva, vuşuyiy dağamiyvaleeqa girxhu manbışisqa hak'necen. ");
INSERT INTO tkr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Man uvhu Mısa suvalqa ılqeç'e. Mane gahıl suva buludun avqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Rəbbin Nurud Sinayne suval g'ece eyxhe. Yixhne yiğna buludun suva avqu vuxha. Yighıd'esde yiğıl Rəbbee Mısa buludeençe qoyt'al. ");
INSERT INTO tkr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","İzrailybışik'le Rəbbin Nur suvane q'oma, maane gırgın gyoxhxhan ha'ane yalavne ad g'ece. ");
INSERT INTO tkr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mısa buludeeqa k'iç'u suvalqa ılqeç'e. Mana suval yoq'ts'al (40) yiğnayiy yoq'ts'al xəmna axva. ");
INSERT INTO tkr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Milletık'le Mısa suvayle gidəə g'acumee, manbı Harunne hiqiy-alla sabı mang'uk'le eyhen: – Şak'le şi Misirğançe qığav'uyne Mısayne vuk'lelqa qadıyn ats'a deş. Mançil-allab oza qıxha şasın allahar hee'e, manbışe şas yəq haagvecen. ");
INSERT INTO tkr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Harunee manbışik'le eyhen: – Vuşde xhunaşşeeşe, yişbışee, dixbışe k'ırıyk qı'in k'ınəəğəyn tenebı zasqa alle. ");
INSERT INTO tkr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Milletıncad k'ınəəğəyke hı'iyn tenebı k'ırıbışile g'ayşu Harunusqa adayle. ");
INSERT INTO tkr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Harunee manbışe adıyn k'ınəəğə alyaat'u, ts'ayıl rışşı qı'ı mançike boğayk akaran sa kar ha'a. Qiyğab hoots'u-q'oots'u boğayk akara qaa'a. Hav'una boğa g'avcu, manbışe eyhen: – İzrailybı, şu Misirğançe qığav'uyn vuşun allahar haane! ");
INSERT INTO tkr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Harunuk'le man g'acu, boğayne ögiyl q'urbanbı alyaa'an ciga ali'ı eyhen: – G'iyqa Rəbbis bayram alğahas! ");
INSERT INTO tkr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Qinne yiğıl millet çakda miç'eeqana suğotsu, q'urbanbı allya'a. Mançile qiyğa millet otxhun-ulyoğasva giy'ar, mançe suğotsumeeyib, mık'ar ha'a. ");
INSERT INTO tkr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Manke Rəbbee Mısayk'le eyhen: – Zaara ixhe suvayle giç'e. Ğu Misirğançe qığavhuyn millet qopkune yəqqı'le qıkkeç'uvud. ");
INSERT INTO tkr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nimee zaraba manbı Zı haagune yəqqı'le qıkkepç'iynbı. Manbışe cos k'ınəəğəyke boğa hav'u, çıs ı'bəədatbı hı'ı, q'urbanbı ali'ı uvhuyn: «İzrailybı, haane şu Misirğançe qığav'uyn allahar!» ");
INSERT INTO tkr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Rəbbee Mısayk'le meed eyhen: – İne milletna hı't'iyvalla Zak'le g'avcuna. ");
INSERT INTO tkr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Havaasre Zı ine milletılqa Yizda qəl k'yaa'as, manbı ç'iyene aq'vayle havaakal haa'as! Vakked sa xədın millet g'alya'as. ");
INSERT INTO tkr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mısee cune Rəbbis Allahıs miz k'yaa'a: – Rəbb, Ğu Yiğne milletilqa qəl hımaa'a. Nya'a, Ğu dişdiy manbı Misireençe xənne q'uvvatıkaneyiy q'udratıkane xıleka qığav'u? ");
INSERT INTO tkr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Misirbışe eyhesın: «Rəbbee manbışikın ha'asva, ç'iyene aq'vayle havaakal haa'asva Misirğançe qığav'u suvabışisqa qabı». Nişil-allane Ğu Misirbışe man cuvabcad ghalyaqa alyat'asın kar ha'as? Hucoone ixhes, qəlasın hıma'a, milletılqa yiğbı allima'a. ");
INSERT INTO tkr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Yiğın g'ular İbrıhım, I'saq', İzrail yik'el qavalee'e, Ğu manbışis Valen k'ın g'assır uvhuynniy «Zı şoke g'abıynbı xəədın xənebımee geeb qaa'as, in Zı şos helesva uvhuyn cigad, gırgıne gahbışis şoke g'abıynbışis heles». ");
INSERT INTO tkr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Man g'ayxhı Rəbb güvəna qexhe, Cune milletılqa g'axuvlesva uvhuna balyaa g'uxoole deş. ");
INSERT INTO tkr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mısa suvayle xıle q'öne g'ayel otk'unin q'aanunbı ana geç'e. G'ayebışde ine aq'vaylid, şene aq'vaylid otk'un ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Man g'ayebı Allahee hı'ı, çilqad man q'aanunbı Vucee hets'u oyk'an. ");
INSERT INTO tkr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yeşuak'le milletna ts'ir g'avxhu Mısayk'le eyhen: – Millet ulyozzurne cigeençe sıç'ookvan nıq'ıd qöö. ");
INSERT INTO tkr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mısee mang'une cuvabıs eyhen: – Zak'le ğameebaxhenbışdayiy avub aaxvanbışda ts'ir deş, mə'niy qəbəqqə g'iviyxhe. ");
INSERT INTO tkr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mısa çadırbı gı'xhı'yne cigaysqa qarımee, maana boğayiy maa'ad ha'an mık'ar g'acu qəllamışexhena. Suvalqa ı'lqəəne cigee mang'vee qəlın xıle aqqıyn q'aanunbı otk'unin g'ayebı ç'iyes gyuvotxhur haq'vra'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mang'vee manbışe hav'una boğa ts'ayeeqa huvopxhur gyooxhan haa'ana. Mançike axuyn karıd getu-getu toozalqa sak'ala'a. Qiyğa man toozud xhinel alikı'ı, İzrailybışisqa ulyoğas ilekka. ");
INSERT INTO tkr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mısee Harunuk'le eyhen: – Mane milletın vak hucoone hı'ı, ğu manbı məxbıne xəbne bınaheeqa av'u? ");
INSERT INTO tkr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harunee eyhen: – Yizda xərna, qəllamışmexhe. Vak'lecad ats'an ine milletıs nimeeyiy qəlasın ha'as ıkkiykanva. ");
INSERT INTO tkr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Manbışe zak'le uvhuyn: «Şi Misirğançe qığav'uyne Mısayne vuk'lelqa hucoome qadı şak'le ats'a deş. Mançil-allab şas allahar hee'e, manbı şale ögee hudooracen». ");
INSERT INTO tkr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Manke zınad uvhuyn: «Şavukayiy k'ınəəğəyke hı'iyn kar vod, man cule g'ayşecen. Milletınıd k'ınəəğə zasqa adıyn. Zınad man k'ınəəğə ts'ayeeqa huvotxhur, mançikeb ina boğa quvxha». ");
INSERT INTO tkr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mısayk'le g'ecen, millet yəqqı'le qığeç'u vod. Naş qıxay yik'el hixan hı'iyn xhinne, millet yəqqı'le qığeç'u eyxhe. Harunee mançis yəq huvu vuxha. Manbışe ha'ançile duşmanaaşed əqənabıniy ha'as. ");
INSERT INTO tkr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mısa çadırbı gı'xhı'yne cigaysqana qıxha eyhen: – Rəbbin sura aqqına zasqa qora. Man g'ayxhı Leviyne nasıleençen gırgınbı mang'usqa savayle. ");
INSERT INTO tkr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mısee manbışik'le eyhen: – Rəbbee, İzrailyne Allahee, inəxüdud eyhe: «Vuşde gırgıng'vee yı'q'eeqa g'ılınc qe'ecen. Şu çadırbı gı'xhı'yne cigayne q'omançe k'anyaqqamee vuşun çocar, hambazar, k'anenbı gyabat'a hudoora, həməxbıb yı'q'əlqa savk'le». ");
INSERT INTO tkr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leviyne nasılenbışe gırgın Mısee uvhuyn xhinne ha'a. Mane yiğıl milletna xhebıd aazırılqa ələəna insan gik'u. ");
INSERT INTO tkr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mısee Leviyne nasılenbışik'le eyhen: – Şu g'iyna vuşde dixbışdayiy çocaaşina eb k'yav'u, şucab şu Rəbbis g'apsır. Mançil-allab Mang'vee şos g'iyna xayir-düə hevles. ");
INSERT INTO tkr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Qinne yiğıl Mısee milletık'le eyhen: – Şu geeb xəbna bınah hav'u. Zı həşde Rəbbisqa ılqeç'es, şavuk'lene ats'a, sayid zasse həməxüd ha'as əxə Rəbb vuşde bınahıle ılyheç'e. ");
INSERT INTO tkr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mısa Rəbbisqa sak'ı eyhen: – İne milletın cos kınəğəyke allahar hav'u, geeb xəbna bınah opxhun. ");
INSERT INTO tkr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Zı Vake heqqa, hucoone ixhes manbışde bınahıle ılyheç'e. Vas manbışde bınahıle ılyheç'es dekkanxhe, manke yizınıd do Yiğne kitabeençe hakkal he'e. ");
INSERT INTO tkr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Rəbbee Mısayk'le eyhen: – Zas bınahısın kar hı'ına insan Yizde kitabeençe hakkal ha'asda. ");
INSERT INTO tkr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Həşdiyle hoora, Zı vak'le millet nyaqayiy qıkkeva uvhu, hamaqab manbı quvkee. Yizın malaaikıd yəq haagva, vale ögiyl əlyhəəs. Mançina gah qabımee, Zı manbışda cazaa hav'une bınahıl-alla qevlesda. ");
INSERT INTO tkr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Sabara gah ılğevçuyle qiyğa, Rəbbee Harunee hav'uyne boğal-alla milletılqa it'umun ık'arbı salat'a'a. ");
INSERT INTO tkr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Rəbbee Mısayk'le eyhen: – Ğunar, ğu Misirğançe qığavhuyn milletıd ine cigeençe qığeepç'e. İbrıhımıs, I'saq'ıs, Yaaq'ubıs Zı k'ın g'assır «Zı şoke g'abıynbışis hevlesva» uvhuynne cigabışeeqa hudoora. ");
INSERT INTO tkr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","3","Manbı nyakiy itv gyodatstsen cigabı vod. Zı maabın Kana'anbı, Emorbı, Q'etbı, Perizbı, Q'ivbı, Yevusbı mançe g'ee'epşesınbı. Şu geed hı't'iy millet ıxhal-alla, yəqqə şokun hidya'asva Zı şoka əlyhəəs deş. Zı vale ögiyl maqa malaaik g'axıles. ");
INSERT INTO tkr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Man qəlıkan cuvab g'ayxhı millet geşşe giyğal. Neng'vecad uftanın karbı qa'a deş. ");
INSERT INTO tkr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Rəbbee Mısayk'le uvhuynniy: – İzrailybışik'le inəxüd eyhe: «Şu hı't'iy milletıd. Zı şoka sık'ırraxheyir ark'ınnaxhiy, Zı şokun ha'asınniy. Həşdemee şu, şolyun uftanın karbı g'ayşe, Zak'led ats'axhxhes şok hucooyiy ha'asva». ");
INSERT INTO tkr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Məxüd Xorev eyhene suvalqa ı'lqəəne cigee İzrailybışe colyun uftanın karbı g'eşşenbı. ");
INSERT INTO tkr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mısee çadır insanar vooxhene cigayle xılece şaqana güvxü vuxha. Mısee mane çadırın do «Rəbbika yuşanaa'ana çadır» giyxhe. Rəbb t'abala'ana insan mane çadırısqa arayle ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mısa Rəbbika yuşanaa'ane çadırısqa əlyhəəne gahıl, millet oza qıxha, cone çadırbışde ghalee ulyozzur, mana çadıreeqa ikkeç'esmee mang'uqa ilyakka ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mısa Rəbbika yuşanaa'ane çadıreeqa ikkeç'umee bulud dirak xhinne givç'u, Rəbb Mısayka yuşana'ane gahıl çadırne ghalee ulyoozar vuxha. ");
INSERT INTO tkr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Milletık'le buludna dirak çadırene ghalee g'avçumee, manbı oza qeepxha cone çadırbışde ghalee ı'bəədat niyxhe ha'an. ");
INSERT INTO tkr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mısayiy Rəbb sana-sang'uka hambazar xhinne yuşan ha'a vuxha. Mançile qiyğa Mısa çadırbı gı'xhı'yne cigeeqa siyk'al ıxha. Mang'una mek'vna kumagçiymee Nunna dix Yeşua mane çadırıke curexhe ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mısee Rəbbik'le eyhen: – Ğu zak'le «in millet hot'leva» uvhu. Zaka vuşuyiy g'axilesvad uvhu deş. Ğu uvhuyn «Zak'le ğu doyuka ats'a, ğu Yizde ulesqa yugra qarı». ");
INSERT INTO tkr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Hək'erar Yiğne ulen zı aqqıxheene, hucoone ixhes zak'le Yiğna yəq haagve. Məxür zak'le Ğu ats'axhxhes, Yiğne ulenır zı aqqasda. Hucoone ixhes, in insanaar Yiğın millet ıxhay yik'el hixan hıma'a. ");
INSERT INTO tkr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Rəbbee Mısayk'le eyhen: – Vas rəhətda ixhecenva, Zıcar vaka ı'qqəs. ");
INSERT INTO tkr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mısee Rəbbik'le eyhen: – Ğu şaka ı'qdəəsxhe, şi inçe qığmaa'a. ");
INSERT INTO tkr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ğu şaka hidyark'ınee, nişikene ats'axhxhes Yiğın milletıd, zınar Yiğne ulen avquvubva? Nişikane menne, zınar, Yiğın milletıd ç'iyeyne aq'valyne milletbışike cura'as əxəs? ");
INSERT INTO tkr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Rəbbee Mısayk'le eyhen: – Ğu Yizde ulesqa yugra qarıva, Zak'le ğu doyuka ats'ava, Zı ğu uvhuyn ha'asın. ");
INSERT INTO tkr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mısee eyhen: – Hucoone ixhes, manke Yiğna gırgına xəbvalla zak'le haagve. ");
INSERT INTO tkr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Rəbbee eyhen: – Zı Yizda gırgına yugvalla vak'le haagvasda, Zı Yizın YAHVE doyud vak'le ats'axhya'asın. Zas ıkkanang'us Zı yugvalla, vukkanang'usub rəhı'm haa'as. ");
INSERT INTO tkr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Vak'le Yizın aq'va g'aces deş. Yizın aq'va g'acuna insan üç'ürra axvas deş. ");
INSERT INTO tkr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Qiyğa Rəbbee eyhen: – Haane Yizde k'anene ganzil ciga vobna, mançil ulyozre. ");
INSERT INTO tkr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Yizın Nur inençe ı'lğəəmee, Zı ğu ganzeene sacigeeqa gixhxhı, ooqad Zı ılğeç'esmee xıl aqqas. ");
INSERT INTO tkr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Qiyğa Zı mançe xıl g'ayşumee, vak'le Yizın yı'q'cad g'aces, aq'va g'aces deş. ");
INSERT INTO tkr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Rəbbee Mısayk'le eyhen: – Şene ögilyna xhinne q'öble g'aye hoots'e. Zı mançilid, ğu şenke haq'varı'iyne g'ayebışil otk'uninbı ok'vanas. ");
INSERT INTO tkr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Miç'eer Sinayne suvalqa ılqeç'e. Suvane q'oma Yizde ögiyl ulyozre. ");
INSERT INTO tkr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Vaka suvalqa vuşucar ılqemeç'ecen, suval vuşucar mexhecen. Suvayne hiqiy-alla çavra-vəq'əd uxhmiyxhancen. ");
INSERT INTO tkr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Rəbbee Mısayk'le uvhuyn xhinne, Mısee şene ögilyna xhinnena q'öble g'ayeb hoots'u, yicbıd alyat'u miç'eer çakra Sinayne suvalqa ılqeç'e. ");
INSERT INTO tkr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Rəbb buludne ar giç'u, Mısayne k'ane ulyorzul Cun do, YAHVEva, eyhe. ");
INSERT INTO tkr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mısayne ögiyle ı'lğəmee eyhen: – YAHVE Zı vorna, rəhı'mıkana, qidiykkın insanaaşis geed helena Rəbb Allah Zı vorna. Zaqa geed xədın sabır, badaldyooxhena yugvalla vobna. ");
INSERT INTO tkr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Aazırıkane nasılbışis yugvalla haagva. Hı'iyn qəlan karbıyiy qopkune yəqqı'le sapk'ılıybı, bınahbı Zı yik'elixan ha'a. Taxsirnang'uk'le vaqa taxsir deşodva itteyhena meer Zıcar vor, məxbıne dekkaaşine uşaxaaşilqa xhebne-yoq'ne nasılee Zı yiğbı allya'as. ");
INSERT INTO tkr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mısa ek'ra aq'vakkena ç'iyelqa gizerçu Rəbbis ı'bəədat hı'ı, ");
INSERT INTO tkr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","eyhen: – Xudaavanda zı Vasqa yugra qarıxheene, hucoone ixhes, Xudaavanda, şaka qora. Şi hı't'iy milletıd ixheene, şi hı'iyn qəlan karbıyiy bınahbı Ğu yik'elixan hı'ı, şi Vasqa Yiğın millet xhinne se'e. ");
INSERT INTO tkr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Rəbbee eyhen: – Zı mugaavile haa'a: Zı yiğne milletıs həşdilqamee ç'iyelyne aq'valyne milletbışik'le g'idecuyn əlaamatbı hagvas. Hasre yiğne hiqiy-allane milletık'le Rəbbee yiğnemee hı'iyn g'acu qəvəq'necen. ");
INSERT INTO tkr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Həşde şu Zı eyhençıl yugda k'ırı gyaqqe, man Zı eyhen kar he'e. Zı şosse Emorbı, Kana'anbı, Q'etbı, Perizbı, Q'ivbı, Yevusbı g'ee'epşesınbı. ");
INSERT INTO tkr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Şu əlyhəəsde cigabışeene milletbışika mugaavile hımaa'a, mana vuşdemee gugu vuxhes. ");
INSERT INTO tkr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Manbışin q'urbanbı alyaa'an cigabı hı'ğəkkar he'e, erın g'ayebı giyxvər he'e, Aşerayin yivarıd gyatxe. ");
INSERT INTO tkr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Merıng'une allahbışis ı'bəədat hıma'a, saccu YAHVEys ı'bəədat he'e, şu merna Zaka sa aqqaqqamee Zı mançis öörəxə deş. ");
INSERT INTO tkr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Nyaggah mane cigabışee aaxvane insanaaşika mugaavilebı hıma'a, manbışe Zas cone allahbışika xayaanat ha'amee, q'urbanbı gyat'amee, şu qoot'alas, man otxhun bınaheeqa k'imabak'a. ");
INSERT INTO tkr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Şu manbışde yişşaşike vuşde dixbışis yedar hımaa'a. Deşxheene, vuşde dixbışed manbışde içeeşe cone allahbışika Zas xayaanat ha'ang'a, manbışe ha'an ha'as. ");
INSERT INTO tkr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Sayid şosun k'ınəəğə ts'ayıl rışşı qı'ı byutbı hıma'a. ");
INSERT INTO tkr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Zı şok'le uvhuyn xhinne, uvhuyne gahıl Avivne vuza acıxamır deşin gıneybışin bayram alğehe. Mane vuza yighılle yiğna ilydyadıyn gıney oxhne. Yik'el aqqe mane vuzaniy şu Misirğançe qığav'u. ");
INSERT INTO tkr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Gırgın şos ts'etta yedike ıxhayncad, gadebıb, çavra-vəq'əyn vughulyın balabıd Yizınbı vod. ");
INSERT INTO tkr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ts'eppa vuxhayne əməleyne q'uduxne cigee urg qevle. Çine cigee kar qidelesxhe gardan havaaq'ar hee'e. Şos ts'eppa vuxhayne dixbışde cigee nuk'ra qele. Hasre nenacar Zasqa xıl q'ərar ımmaylecen. ");
INSERT INTO tkr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Vuşun ha'asın işbı yixhne yiğee he'e, yighıd'esdemee yiğıl manzil hee'e. Kar ezaned sa'aned gahıl, yighıd'esın yiğ manzilis cure'e. ");
INSERT INTO tkr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Sukbı qiyşalang'a ts'ettiyne nugbarıka Şavuot (Ülycümbışin) bayram alğehe. Sen ç'əvexheng'ad Alyadıyn Kar Sı'iyn bayram alğehexhe. ");
INSERT INTO tkr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Senee xhebne yəqqee vuşun gırgın adamer, vuşde Xudaavandne Rəbbine, İzrailyne Allahne hiqa savalecen. ");
INSERT INTO tkr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Zı vuşde hiqiy-alladın milletbı g'e'eşşu, vuşun ciga xət qa'as. Şu senee xhebne yəqqə Rəbbine, vuşde Allahne hiqa savaales vüqqəng'ə, şavussecad yik' hı'ı vuşun ciga aqqas əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Zas ablyaa'ane q'urbanna eb, acıxamırnane gınelqa k'yoohar hımaa'a. Peesaxıs (Allah qıdet'u ılğeç'uyne) bayramısva gyuvk'iyne q'urbanın çuru miç'eediys ımaxvacen. ");
INSERT INTO tkr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Yiğne cigabışee ts'etta alyadıynçike inette yugun Rəbbine, yiğne Allahne xaaqa alle. Mısva çine yedine niknee qumooxhar. ");
INSERT INTO tkr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Rəbbee Mısayk'le eyhen: – İn cuvabbı ok'ne, inçis sikı Zı vakayiy İzrailika mugaavile haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mısa maa'ar Rəbbika yoq'ts'al xəmnayiy yoq'ts'al yiğna ıxha. Mang'vee maa'ad gıneyid, xhyanıd, vuççucad ghalyaqa ıkkı deş. Mang'vee g'ayebışil oo mugaavileyn cuvabbı, yits'ıble əmr, opk'un. ");
INSERT INTO tkr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mısa xılya'ab q'öble mugaavileyna g'aye avqu Sinayne suvayle Rəbbika yuşan hı'ı gəəmee, mang'uk'le ats'a deşdiy cune aq'vayle nur k'əə ıxhay. ");
INSERT INTO tkr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Harunuk'leyiy İzrailybışik'le Mısayne aq'vayle nur k'əə g'acumee, mang'usqa qeepxhes qəvəyq'ən vuxha. ");
INSERT INTO tkr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mısee manbı cusqa qoot'al, Harunur manbışin ç'ak'ınbıb Mısaysqa qabımee, mang'vee manbışika gaf haa'a. ");
INSERT INTO tkr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Mançile qiyğa gırgın İzrailybı mang'usqa savayle. Mısee Rəbbee cusqa Sinayne suvee quvuyn gırgın q'aanunbı milletısqa qele. ");
INSERT INTO tkr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mısa yuşan hı'ı ç'əvxhamee, mang'vee cune aq'valqa şalavniyxhe alyadaççen. ");
INSERT INTO tkr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mısa Rəbbika yuşan ha'asva ı'qqəmee, mang'vee aq'valin şalav g'eşşe ıxha. Qığeç'esnang'ad mang'vee meed vuk'lelqa şalav alyadaççe ıxha. Rəbbisse İzrailybışisqa sak'ımee, mang'vee cuk'le uvhuynbı manbışilqa hixhara'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Mane gahıl İzrailybışik'le Mısayne aq'vayle nur k'əəniyxhe g'ecen. Mana manbışika yuşan ha'ang'ar vuk'lelin şal g'eşşen deşdiy. Mang'vee vuk'lelin şal sak'ı Rəbbisqa əlyhəəmeniy saccu g'eşşen. ");
INSERT INTO tkr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","İzrailybı safareenang'a, Rəbbika yuşan haa'ane çadırıle buludna dirak xəəqə ts'ıts'avxhamee, manbı yəqqı'lqaniyxhe gyabak'anbı. ");
INSERT INTO tkr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Bulud xəəqə ts'ıts'devxhaylette, millet cigeençe ı'ğiykaran deşdiy. ");
INSERT INTO tkr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Safariy ç'əvuvxhesmee, Rəbbin bulud İzrailyne milletne ulene ögiyl, yiğniyığın çadırıl oo vuxha, xəmdemee mane buludee ts'a gyotxhan ıxha.");
INSERT INTO tkr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Millet əq'übeeqa gitxhuva, manbışe Rəbbilena haa'a. Man g'ayxhı Rəbbee it'umba qəl hav'u. Rəbbin ts'a manbı aaxvane cigayne nekke mıglekne çadırbışik qexha. ");
INSERT INTO tkr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Milletıncad Mısalqa ona'a giyğal. Mısee dü'ə hav'umee, ts'a k'ədəqqən. ");
INSERT INTO tkr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Rəbbin ts'a ma'ad qitxhuva, mane cigayn do Tavera (gyotxhuniy) axva. ");
INSERT INTO tkr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Manbışika vooxhene menne cigabışeençe qabıynbışin napsbı geed qeedaxhe. İzrailybı manbışika sacigee gyaaşe-gyaaşe eyhen: – Şaqad oxhanasın çuruxhiy ıxhayn! ");
INSERT INTO tkr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Şi həşdilqamee Misir q'ərad otxhanan baluğar, xiyarar, g'avumar, sipaa, ç'eç'ey, arnaa yik'el qalyaa'an. ");
INSERT INTO tkr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Həşde şi k'yapt'iynbı. Şak'le mannayle ğayrı vuççud g'ece deş. ");
INSERT INTO tkr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna vuc k'aşnişne toxumek akar vuxha, rangıd cagvarada xhinne ıxha. ");
INSERT INTO tkr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","İnsanaaşe mana sav'u, vuxheene xılelyne yöxxeençe qığaa'a vuxha, devxheeneb dibakee gyoota vuxha. Manbışe mana k'umk'umeeyib qooxhar vuxha, kokaybıd ha'a ıxha. Mana zeytunne q'ışee ç'əra qav'uyne kokayk akaraba vuxha. ");
INSERT INTO tkr_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Xəmde ı'xı'yne çiyıka manna İzrailybınane cigee qığooç'e vuxha. ");
INSERT INTO tkr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mısayk'le gırgın xizanbı, milletcad cone çadırne ghalee geşşe g'iyxhe. Rəbbis mançike it'umna qəl vuxha. Mıseeyid mançis aq'va qa'a. ");
INSERT INTO tkr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mısee Rəbbik'le eyhen: – Nişil-allane Ğu zas inəxübna əq'üba hoole? Nya'a zı Yiğne ulen aqqı dişde, Ğu inimeene milletın zalqa yuk alixhxhı? ");
INSERT INTO tkr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nya'a, zakene in millet g'adı? Nya'a, zıne manbı vuxu? Ğu k'ın g'assır yişde dekkaaşis hevlesva uvhuyne cigabışeeqa, nya'a manbı zasqa uşax gyoqa'ane xhunaşşe uşax aqqıyn xhinne, avqu quvkees ulyookka? ");
INSERT INTO tkr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Nençene zı inimeen millet ats'ya'asın çuru ha'as? Manbı zasnee «Şas çuru heleva» gyaaşenbı. ");
INSERT INTO tkr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Zassecad inemeene milletın yuk haqqas əxə deş, yizda mançilqa guc höö deş. ");
INSERT INTO tkr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ğu meed zak ögiylin xhinne ha'asxhee, zalqa ablesda ver zak'le g'avcesse, hucoone ixhes, Vas zı sik'ırra ixheeyir ıkkanxhe yizın can həşdecad alişşe. ");
INSERT INTO tkr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Rəbbee Mısayk'le eyhen: – Vak'le İzrailin ç'ak'ınbı xhinne vaats'an, Zasqa yights'al (70) ağsaqqal ayre. Hasre manbı vakasana abı Rəbbika yuşanaa'ane çadırne ögiyl ulyoozrecen. ");
INSERT INTO tkr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Zı giç'u vaka ma'ar yuşan ha'as. Zı valyne Yizde Rı'hı'ke alyaat'u, manbışisıd helesın, manbışed vaka sacigee milletın yuk ts'ıts'ecenva. Valqacad milletın yuk gimexhecenva, manbışe vas kumag ha'asın. ");
INSERT INTO tkr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Milletık'le eyhe: «„Çuruxhiy ıxhayn oxhanasınva, Misircad yugdayiyva“ şu gyaaşe-gyaaşe eyhen, Rəbbik'le g'ayxhiyn! G'iyqiys gicəpxı' vuxhecen, çuru oxhanas. ");
INSERT INTO tkr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Şu man sa yiğna, q'öne yiğna, xhone yiğna, yits'ne yiğna, g'ane yiğna deş oxhanas. ");
INSERT INTO tkr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Şu man bıkırne vazna quşeençe qalesmee, avts'u həlyvəq'ənasmee oxhanas. Şu vuşde yı'q'neene Rəbbilqa yı'q' sak'al hı'ı, Mang'une ögiyl gyaaşe-gyaaşe uvhuva: „Şi nişisne Misirğançe qığeepç'ı!“» ");
INSERT INTO tkr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mısee eyhen: – Həşde yizde k'ane yixhıd vəş aazır (600 000) adamiy vor, Ğunad eyhen: «Zı manbışis sa vazna avts'esin çuru heles!» ");
INSERT INTO tkr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Nya'a, gırgın çavra-vəq'ə gyatt'veeyid manbı aats'eye? Nya'a, deryaheedın gırgın baluğ aqqeeyid manbı aats'eye? ");
INSERT INTO tkr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Rəbbee Mısayk'le eyhen: – Nya'a Rəbbin xıl cit'adane vod? Həşde vak'le g'acesın Zı vak'le uvhuynbı eyxheye, dişee. ");
INSERT INTO tkr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mısee qığeç'u Rəbbin cuvab insanaaşilqa hixhara'a. Mang'vee milletne ağsaqqalaaşike yights'al (70) insan sı'ı, Rəbbika yuşanaa'ane çadırne hiqiy-alla giviyk'an. ");
INSERT INTO tkr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Mane gahıl Rəbb buludne dirakee giç'u, Mısayka yuşan ha'a. Mang'ulyne Allahne Rı'hı'ke alyaat'u, yights'alyne (70) ağsaqqalıs hele. Manbışilqa Rı'h gixı'mee, manbı Allahıken peyğambarar xhinne yuşan haa'a giviyğal. Sabara gah ılğevç'uyle qiyğab manbışda peyğambariyvalla ç'əvooxhena. ");
INSERT INTO tkr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Eldadiy Medad donan q'öyre insan, co vooxhene cigeecab avxu. Manbı ağsaqqalaaşika sacigee opk'un vuxheyib, manbı Allahne çadırısqa qığeebaç'e deş. Allahın Rı'h manbışilqad geç'en, manbışeb co aaxvane cigee peyğambariyvalla haa'ana. ");
INSERT INTO tkr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Sa cehil Mısaysqa g'adarxhun eyhen: – Eldadeyiy Medadee co aaxvane cigee peyğambariyvalla vob haa'a. ");
INSERT INTO tkr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Mek'vranang'acad Mısays kumag ha'a girğılyne Nunne dixee Yeşuee Mısayk'le eyhen: – Yizda xərna, manbı ulyoozar hee'e! ");
INSERT INTO tkr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mısee mang'us inəxdun cuvab qele: – Zı ıkkanalinne, man yiğne yik'ek qet'u? Zasmee ıkkaniy Rəbbee cune milletne gırgıng'ulqa Cun Rı'h g'axuvu, gırgıng'uke peyğambarar hee'ecen! ");
INSERT INTO tkr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Qiyğa Mısar İzrailin ağsaqqalarıb çadırbı gı'xı'yne cigeeqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Rəbbee deryahıle g'axuvuyne mıtsın çadırbı gı'xhı'yne cigeeqa bilydirçinar adayle. Manbı aaxvane cigayne hiqiy-alla q'öne xılekkumne axtıvallee, sa yiğna əlyhəəsdemeene yəqqə bilydirçinar gırgınəəng'ə gyoku eyxhe. ");
INSERT INTO tkr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mane yiğıl miç'eediyle otçu xəmdilqamee, xəmdeb çikana, qinne yiğılib insanar bilydirçinar sa'a vuxha. Nekke k'ılda sı'ıng'vee yits'ıble xəbna ç'emç'e sav'u vuxha. Manbışe bilydirçinar co aaxvane cigayne hiqiy-alla gyoka. ");
INSERT INTO tkr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Çuru manbışde ghalyaqa hitxhır yic gyeç'esse, Rəbb milletılqa it'umra qəllamişexhena. Manbışilqa hapt'asın ık'ar salat'a'a. ");
INSERT INTO tkr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Naps geednanbı maa'ab k'evxhuva, mane cigalqa Qivrot-Hattaava (naps geednanbışin nyaq'vbı) do giyxhe. ");
INSERT INTO tkr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Millet Qivrot-Hattaavançe ayk'anan. Manbı Xatseroteeqa qabı maayib aaxvanbı. ");
INSERT INTO tkr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mısee Kuşeençe xhunaşşe hey'ıva, Haruneeyiy Mayramee mang'ulena haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Manbışe eyhen: – Nya'a Rəbb saccu Mısaykane yuşan hı'ı, şaka yuşan hı'ıcar dişde? Rəbbik'le man g'iyxhen. ");
INSERT INTO tkr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mısee mısacar vucecar vuc ögeeqa huvu deş, məxür vucecar vuc ıkkekkana merna insan dyunyelyne aq'valycar ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Rəbbee sayangada Mısayk'le, Harunuk'le, Mayramık'le eyhen: – Vuşda xhebırsana, Zaka yuşan haa'ane çadırısqa able. Manbışda xhebırsana maqa havayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Rəbb mane gahıl buludne dirakee giç'u, çadırene ghalee ulyorzul Haruniy Mayram qoot'al. Manbışda q'öyursana ögiylqa qığeepç'ımee, ");
INSERT INTO tkr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Rəbbee manbışik'le eyhen: – Həşde Yizde cuvabıl yugda k'ırı gyaqqe! Vuşde yı'q'nee Rəbbina peyğambarnang'a Zı mang'us gyagvanaxhe, mang'uka nik'ee yuşanxhe ha'a. ");
INSERT INTO tkr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Saccu Yizda nukar Mısa Zı manbışile axtıra aqqaqqa. Zı mang'ulqa Yizın milletcad g'alyadaççe. ");
INSERT INTO tkr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Zı mang'uka işarabışka deş, hambazıka xhinne yuşan ha'a. Mang'uk'le Rəbb nəxürna ıxhay g'acuna. Nəxübne şu qı'dəpq'ı'n Yizde g'uluna Mısaylena hav'u? ");
INSERT INTO tkr_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Rəbb manbışilqa it'umra qəllamışxha mançe ayk'anna. ");
INSERT INTO tkr_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Çadırısse buludna dirak xəəqə ts'ıts'avxhamee, Harun sark'ıl Mayramıqa ilyakkıys, mana yiz xhinne cagvarane ı'xnabışin gyatsts'ı g'eece. ");
INSERT INTO tkr_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Mang'vee Mısayk'le eyhen: – Yizda xərna, hucoone ixhes, şi ina beynyavavallayiy bınah hav'uva şasqa cazaa ts'ıts'aa'as ulymooka. ");
INSERT INTO tkr_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Hucoone ixhes, hımaysar məng'ı'n tan yedine vuxhnecad qik'u qeçe gidğılne uşaxne tanık akarada axvas. ");
INSERT INTO tkr_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mısee Rəbbilqa ona'a: – Allah, zı Vake heqqa, hucoone ixhes mana yug qee'e! ");
INSERT INTO tkr_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Rəbbee Mısayk'le eyhen: – Dakkee məng'ı'ne aq'vays tyu ı'xı'ynxhiy, nya'a mana yighılle yiğna ulele g'iyxhas dişdiy? Mana yighne yiğıs çadırbı gı'xhı'yne cigeençe qığeehe, yighne yiğıle məng'ı'sse maqa sayk'alas yeexə. ");
INSERT INTO tkr_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Mayram məxür yighılle yiğna menne cigee eexva. Mana çadırbı gı'xhı'yne cigeeqa qiyelesmee, millet cigeençe ı'ğiykır deş. ");
INSERT INTO tkr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Qiyğa millet Xatserotğançe qığeç'u Paranne sahreeqa qadayle. ");
INSERT INTO tkr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","– İzrailybışis helesde Kana'anne cigabışeeqa alycaaxvas insanar g'axuvle. Yıts'ıq'vəne (12) nasılıken ç'ak'ınbı g'axuvle. ");
INSERT INTO tkr_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Rəbbe uvhuyn xhinne Mısee manbı Paranne sahreençe g'ıxolenbı. G'axuvuyn gırgınbı İzrailybışde nasılbışin ç'ak'ınbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Haane manbışin dobı: Ruvenne nasıleençene Şammuayna dix Zakkur; ");
INSERT INTO tkr_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Şimonne nasıleençene Xoriyna dix Şafat; ");
INSERT INTO tkr_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Yahudne nasıleençene Yefunna dix Kalev; ");
INSERT INTO tkr_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","İssaxarne nasıleençene Yusufna dix İgal; ");
INSERT INTO tkr_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Efrayimne nasıleençene Nunna dix Hoşia; ");
INSERT INTO tkr_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Benyaminne nasıleençene Rafuyna dix Palti; ");
INSERT INTO tkr_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Zevulunne nasıleençene Sodiyna dix Gaddiel; ");
INSERT INTO tkr_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Yusufna dix Menaşşeyne nasıleençene Susiyna dix Gaddi; ");
INSERT INTO tkr_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Daniyne nasıleençene Gemalliyna dix Ammiel; ");
INSERT INTO tkr_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Aşerne nasıleençene Mikaelyna dix Setur; ");
INSERT INTO tkr_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Naftaliyne nasıleençene Vofsiyna dix Naxbi; ");
INSERT INTO tkr_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Qadne nasıleençene Makiyna dix Geuel. ");
INSERT INTO tkr_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mısee cigayqa ilyaakasva g'axuvuynbışin dobı manbıniy vod. Mısee Nunne dixes Hoşiays (g'attipxhıniy) Yeşua (YAHVE g'attivxhan haa'a) do giyxhe. ");
INSERT INTO tkr_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Kana'anıqa ilyaakas g'uxolemee, Mısee manbışik'le eyhen: – Negevne sahrayle k'ena suvabışeeqa hudoora. ");
INSERT INTO tkr_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","İlyaake, nəxdıniy man ciga, nen milletiy maa eyxhe, geebbıye k'ılbabiye manbı, gucukaye dişe? ");
INSERT INTO tkr_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Manbı vooxhen ciga yugune pisine? Nəxdıne şaharbışeeyiy manbı aaxva: cabırbı vodee, hiqiy-allan cigabı it'um hı'ıye? ");
INSERT INTO tkr_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Maana nyaq'v nəxübiy, kar ələəye dişee? Yivar vodee? Yik'eka, itt'umba vuxhe, qöömee mane cigayn meyvabı alle. (Manke yicıd t'ımılybı hiyxharna gah vuxha.) ");
INSERT INTO tkr_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Manbı Tsinne sahraysse Levo-Xamatne k'anene Rexovusqa hapk'ın maane gırgıne cigabışiqa ilyaakanbı. ");
INSERT INTO tkr_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Manbı Negevıle k'ena qavaylenbı Xevronqa. Mane cigabışee Anaqıke g'abıynbı: Aximan, Şeşay, Talmay vooxhe vuxha. (Xevron Misireene Tsoan şaharıle yighılle senna ögiyl alyav'u vuxha.) ");
INSERT INTO tkr_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Eşkolne q'adaalilqa hipxhırmee, manbışe sa ts'ets'nan t'ımılen bıtağ gyatxı tübəəlqa givayxan. Mana tübəəyib q'öng'ee avqaaqqa. Manbışe mançile ğayrı coka narariy incilerıd alyaat'anbı. ");
INSERT INTO tkr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","İzrailybışe mançe t'ımılena ts'ets' qopxuva mane q'adaalin do Eşkol (ts'ets') giyxhe. ");
INSERT INTO tkr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Yoq'ts'al (40) yiğna manbı mane cigabışee alycaxu siviyk'alanbı. ");
INSERT INTO tkr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Manbı Paranne sahreene Qadeşeeqa Mısa, Harun, İzrailybışin gırgınbı vooxhene cigeeqa siviyk'al. Maa'ad manbışe Mısays, Harunus, milletıkene gırgıng'us co hapk'ınne cigabışee g'acuynbı yuşan ha'a, co mane cigabışeençe adiyn meyvabı hagva. ");
INSERT INTO tkr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Manbışe Mısayk'le eyhen: – Şi ğu g'axuvuyne cigabışeeqa hapk'ın hipxhırinbı. Maa'ad hək'edad nyakiy itv gyodatse vod. Haane mane cigabışin meyvabıd. ");
INSERT INTO tkr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Saccu maa'ad eyxhen millet gucuka vod, manbışin şaharbıd ç'ak'ıda vod, hiqiy-allad yugda it'umı'ı vod. Mançile ğayrı, şak'le maa'ab Anaqıke g'abıynbıb g'avcuynbı. ");
INSERT INTO tkr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Negevee Amalekbı, suvabınane cigee Q'etbı, Yevusbı, Emorbı, deryahneyiy İordanne damayne mıglekıb Kana'anbı vooxhe vuxha. ");
INSERT INTO tkr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kalevee Mısayne k'ane milletıs yik'bı huvu eyhen: – Hapk'ın man ciga xılelqa alğahas, yişda mançilqa guc hivxharasda. ");
INSERT INTO tkr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Mang'uka hapk'ıniynbışemee eyhen: – Şasse şene milletıka saç'uvkas vəəxəs deş, manbı şale gucuka vob. ");
INSERT INTO tkr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Conemee milletıs, manbışe co hapk'ınne cigabışde hək'ee pisda xabar abı eyhen: – Şi hapk'ın alycaxuyn cigabı yugunbı deşiy, maabın insanarıb zarabacab habat'ayiy. Gırgın şak'le maa'ab g'avcuyn insanar geeb ç'ak'ın karbıyiy. ");
INSERT INTO tkr_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Şak'le ma'ab Anaqıke g'abıyn geeb ç'ak'ın kuşdukurarıb g'avcuynbı. Şi manbışde k'ane şasqacab ts'irtyar xhinneyiy qöö. Manbışde ulesqab şi həməxüb qabı. ");
INSERT INTO tkr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mane xəmde milletıke ts'ir g'optul, manbı bıkırne xəmna gyaaşuynbı. ");
INSERT INTO tkr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Gırgıne İzrailybışe Mısaylenayiy Harunulena haa'a vuxha. Cəmə'ətıncad manbışik'le eyhe ıxha: – Misir şi hidyapt'ıynbı, ine sahreexheyib hapt'ıynbıxhiy! ");
INSERT INTO tkr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nişisne Rəbbee şi mane cigabışeeqa quvkekka? Maa'ab yişin yedariy uşaxar mering'une xılyaqa gyapk'as, şinab g'ılıncike hapt'asınbı. Yişdemee Misirqa sapk'ılıy yugda dexheyene? ");
INSERT INTO tkr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Manbışe sana-sang'uk'le eyhe ıxha: – Şasda xərna g'əyxı', Misirqacab savk'alas. ");
INSERT INTO tkr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Manke Mısayiy Harun maqa sabıyne gırgıne İzrailyne cəmə'ətne ulene ögiyl aq'vakkena ç'iyelqa gizepçi Allahıs düə haa'a. ");
INSERT INTO tkr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Şene cigayqa ilyaakas hapk'ıniynbışike qöng'vee, Nunne dixee Yeşueeyiy Yefunne dixee Kalevee, colyun tanalinbı qıt'axxı'ı ");
INSERT INTO tkr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","gırgıne İzrailyne cəmə'ətık'le eyhen: – Şi ilyaakas hapk'ınin, caançe ılğepç'iyn ciga geed yugun vod. ");
INSERT INTO tkr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Şi Rəbbisqa yugba qabee, Mang'vee şi mane cigabışeeqa quvkees, nyakiy itv gyodatstsen cigabı şas heles. ");
INSERT INTO tkr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Saccu Rəbbis əsi mooxhe. Mane cigayne insanaaşileb qı'məəq'ən, şi manbışile ğameepxhescab deş, şi manbı ooxhanasınbı. Rəbb şaka vor, manbışiqamee vuşucar deşda. Manbışile nəxübcab qı'məəq'ən! ");
INSERT INTO tkr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Man g'ayxhı, cəmə'ətın Yeşuayiy Kalev «G'ayeqqa hevleva!» eyhe. Mane gahıl İzrailybışde gırgıng'us sayangaba Rəbbin Nur Cuka yuşana'ane çadırısne gyaagva. ");
INSERT INTO tkr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Rəbbee Mısayk'le eyhen: – Mısılqameene mane milletın Zalena haa'as, Zı karane cigeeqa gidiyxhes? Zı co vooxhene cigabışee hı'iyn əlaamatbı g'ece-g'ece, mısılqameene manbışe Zalqa iman hidya'as? ");
INSERT INTO tkr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Zı manbışilqa hapt'asın ı'kar g'axuvu, Zı manbışin gırgınbı gyapt'asınbı. Vaked manbışiled xədın, gucukan millet g'alyaa'as. ");
INSERT INTO tkr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mısee Rəbbik'le eyhen: – Hucoone ixhes, Ğu man hıma'a! Nya'a, Ğu dişde manbı Misirbışde yı'q'neençe Yiğne xənne gucuka qığav'u. Həşde Misirbışik'le Ğu manbı gyapt'ıva g'ayxhes. ");
INSERT INTO tkr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Manbışed şok ıxhaynbı mane cigayne gırgıne milletbışis yuşan ha'as. Mane milletbışik'le Ğu, Rəbb İzrailybışde yı'q'ne ıxhay g'ayxhiyn. Mane milletbışik'le ats'an Ğu manbışika Ğucar-Ğu hagva yuşan ha'a ıxhay, Ğunana bulud manbışil ooab ulyoozarva. Ğu manbışis yiğniyığın buludne dirakee, xəmdemee ts'ayıne dirakee yəq haagu. ");
INSERT INTO tkr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ğu gırgın in millet sa insan xhinne gyapt'eene, Yiğne hək'ee g'ayxhiyne milletbışe eyhesın: ");
INSERT INTO tkr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","«Rəbbee k'ın g'assır quvkeesva uvhiyne cigabışeeqa millet qıkkes dəxı'va, Mang'vee man millet sahree gik'uyn». ");
INSERT INTO tkr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Xudaavendee həşde Vuce uvhuyn xhinne Cuna xəbvalla haagvecen: ");
INSERT INTO tkr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","«Rəbb xədın sabırnana, badaldyooxhena yugvallanana, bınahbışile ilyheç'ena vor. Taxsirnang'uk'le vaqa taxsir deşodva itteyhena Mana vor. Dekkaaşe hav'une bınahıl-allab manbışde uşaxaaşilqa xhebne-yoq'ne nasılee yiğbı allya'ana meer Mana vor». ");
INSERT INTO tkr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Hucoone ixhes, Yiğne badaldyooxhene xəbne yugvalis sik'ı ine milletne bınahıle ılyheç'e, nəxüriy Misirğançe qığeepç'iyne yiğıle g'iyniyne yiğılqamee ı'lğəə. ");
INSERT INTO tkr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Rəbbee eyhen: – Zı yiğnemee manbışde bınahıle ı'lğəəna. ");
INSERT INTO tkr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Zalqaniy Yizde ç'iyelyne xəbvalilqan k'ın ixhen: ");
INSERT INTO tkr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","manbışik'le Zı Misirnee sahree hı'iyn əlaamatbıyiy Yizın Nur g'acveeyid, manbışe Zı xhuler ıxhiy siliys ı'xı'na, Zal k'ırı alixhxhı deş. ");
INSERT INTO tkr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Mançil-allad Zı manbışde dekkaaşis k'ın g'assır helesva uvhuyn cigabı manbışik'le mısacad g'aces deş! Zı nişinecar cigeeqa gidiyxheng'uk'le man cigabı g'aces deş! ");
INSERT INTO tkr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Yizde g'uluqa Kalevıqa medıncad rı'hı'd, saccu mang'vee vod Zal yik'eençe k'ırı iliyxhe. Mançil-allar Zı mana vuc hark'ınne cigabışeeqa qıkkes, man cigabı mang'uke g'abıynbışis heles. ");
INSERT INTO tkr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Həşde mane q'adaalil Amalekbıyiy Kana'anbı aaxva. Şumee g'iyqa sapk'ıl sahreeqa, Ç'ərane deryahısqa hudoora. ");
INSERT INTO tkr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Rəbbee Mısayk'leyiy Harunuk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","– Mısılqameene ine bınahın gyatsts'ıyne milletın Zalena haa'as? İzrailybışe Zalena haa'ang'a, Zak'le gırgın g'iyxhen. ");
INSERT INTO tkr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Manbışik'le eyhe: «Rəbbee vod eyhe, Zalen k'ın ixhen, Şu Zalena haa'ang'a hucooyiy uvhu, Zı man şok ha'asın. ");
INSERT INTO tkr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","İna sahravolle vuşun mayitbı ot'ul-otxul ixhes. Zalena hav'uynbı, g'alle (20) sennanbıyiy manbışile ç'ak'ın gırgınbı, nenbıyiy siyaheeqa alyapt'ı ine sahree hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Zı helesva k'ın g'assıriyne cigabışeeqa şu ikkepç'es deş. Maqa saccu Yefunna dix Kaleviy Nunna dix Yeşua ikkepç'es. ");
INSERT INTO tkr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Şos diviykkınne, şu vuşun uşaxar merıng'une xılyaqa gyapk'asva eyhene cigabışeeqa Zı manbı quvku man cigabı hagvasınbı. ");
INSERT INTO tkr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Vuşun mayitbımee sahravolle ott'ul-oxal ha'asınbı. ");
INSERT INTO tkr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Vuşdemee uşaxaaşe mane sahree yoq'ts'al (40) senna çobaniyvalla haa'as. Mısılqameeyiy vuşun g'ırgınbı sahreençe hapt'ı idyapk'ın, vuşde inyam deşiyvalin manbışe maa'ab əq'üba ts'ıts'aa'as. ");
INSERT INTO tkr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Cigabışiqa ilyaakas hapk'ınne yoq'ts'alyne yiğıl-alla, şu yoq'ts'al senna sahree iviykaras. Sa yiğıl-alla şu sa senna əq'üba ts'ıts'aa'as. Məxüd şok'le Rəbbis əsi vuxhay nəxdın kar ıxhay ats'axhesın». ");
INSERT INTO tkr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Zı Rəbbee şok'le eyhe, mane Zas əsi vuxhayne cəmə'ətık Zı man uvhiyn kar hidi'ı g'aleççes deş. Manbışikın Zı ine sahree ha'as. Manbışin gırgınbı inyaa hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Mısee Kana'anne cigabışiqa ilyaakasva g'axuvuyn insanar yı'q'əlqa sıviyk'al, manbışe mane cigabışde hək'ee pisın xabarbı adı cəmə'ət Mısalqa g'elil qa'a. ");
INSERT INTO tkr_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Cigabışde hək'ee pisın xabarbı adıyne insanaaşilqa, Rəbbee yı'q'ı'n ık'arbı g'axuvu, gyabat'anbı. ");
INSERT INTO tkr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Cigabı g'avcesva hapk'ınne insanaaşike, saccu Nunna dix Yeşuayiy Yefunna dix Kalev üç'übba aaxva. ");
INSERT INTO tkr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mısee man İzrailybışis yuşan hı'ımee manbı axtıne nıq'ıka gyaaşe giviyğal. ");
INSERT INTO tkr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Manbı miç'eeb çakba suğootsu eyhen: – Şi bınah hav'u, qudoora, həşde Rəbbee şas helesva eyhene cigeeqa vüqqəs. Manıd uvhu, manbı Kana'anne suvabışilqa avayk'an. ");
INSERT INTO tkr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mısee eyhen: – Nya'a şu Rəbbee eyhen hidya'a? Şossee, man şu eyhen ha'as əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Şu hapk'ıneeyib, Rəbb şoka ixhes deş. Duşmanaaşileb şu avub aaxvas. ");
INSERT INTO tkr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Maa'ab şosqa Amalekbıyiy Kana'anbı qızaaxas. Şu Rəbbilqa yı'q' sak'alıil-alla, Mana şoka ixhes deş, mançil-allab şu g'ılıncıke hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Manbı yik' hı'ı suvabışilqa ılqebaç'e. Rəbbika mugaavilenana q'utyeb, Mısar çadırbı gı'xhı'yne cigeençe nyaqacab ı'ğviykar deş. ");
INSERT INTO tkr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Maane suvabışee aaxvan Amalekbıyiy Kana'anbı geepç'ı, manbı gyootu, Xorma eyhene cigalqamee qihna gyapk'ı g'e'eebaşenbı. ");
INSERT INTO tkr_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Leviyne nasıleençe, Qohatna neva eyxhena İsharna dix Qorax yik' hı'ı Mısalqa arayle. Mang'uka sacigee Ruvenne nasıleençe Eliavın dixbı Datanıyiy Aviram, Peletna dix On arayle. ");
INSERT INTO tkr_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Manbışika sacigee İzrailybışkecab g'əvxı'yn q'öd vəşşe xhots'al (250) doyukan, ç'ak'ınbı havayk'an. ");
INSERT INTO tkr_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Manbı sacigeeqa sabı Mısayk'leyiy Harunuk'le eyhen: – Vuşun ç'əv! Milletıken gırgınbıcab muq'addasınbı vob, Rəbb manbışde yı'q'neyir eyxhena. Nya'a, şucab şu Rəbbine milletıke ooqanbı haa'a? ");
INSERT INTO tkr_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Man eyhenbı g'ayxhı Mısa aq'vakkena ç'iyelqa gizerçu, Allahıs düə haa'a. ");
INSERT INTO tkr_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Mang'vee Qoraxık'leyiy mang'une gırgıne hambazaaşik'le eyhen: – G'iyqa miç'eed vuşuyiy Cuna eyxheva, nenayiy muq'addasnava, neng'usseyiy Cusqa qixhes əxəva Rəbbee Vucecad hagvasın. Vuşuyiy Mang'vee g'əyxı', mang'usser Cusqa qixhes əxəsda. ");
INSERT INTO tkr_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Qorax, ğunay yiğne gırgıne hambazaaşe in eyhen he'e: ətirbı gyoxhxhana'asın g'abbı alyaat'u, ");
INSERT INTO tkr_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","g'iyqa mançine aqa gyopxhanna ghadır gyuvxhu, qiyğad mançilqa Rəbbine ögiyl ətirbı gixhxhe. Məxür Rəbbee Vucee, vuşiyiy muq'addasna hagvasda. Leviyke g'abıynbı, şu hı'iynbı ç'əv! ");
INSERT INTO tkr_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mısee Qoraxık'le meed eyhen: – Leviyke g'abıynbı, zal yugda k'ırı gyaqqe! ");
INSERT INTO tkr_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Nya'a, şos ç'əv dişee? İzrailyne Allahee şu İzrailybışike curav'iy, Cus k'ane qav'iy, Cune Rəbbine çadırısneedın gırgın işbı vuşde xılyaqa quviy. Şu məxüb milletıs gullux haa'a. ");
INSERT INTO tkr_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Mang'vee şunab, vuşda gırgına Leviyna nasılıb Cus k'ane qav'u. Şos man k'ıldanan xhinne, ooğançe, ho'ıne şos kaahinaaşin ç'ak'ınbıbne vuxhes vukkan? ");
INSERT INTO tkr_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Qorax, ğunay yiğın hambazar Rəbbilqa vobde g'elil qeepxha hı'nəxüb sabı. Nya'a, Harun vuşune vor şu mang'ulena haa'a? ");
INSERT INTO tkr_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mısee Eliavın dixbı, Dataniy Aviram, qoot'al. Manbışe eyhen: – Deş vüqqə! ");
INSERT INTO tkr_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ğu şi sahree gyapt'asva nyakiy itv gyodatsene cigabışeençe qığav'u. Vas man ç'əv dexha, deşxhee, yişda xərnarne ixhes ıkkan? ");
INSERT INTO tkr_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Mançile ğayrı ğu şi nyakiy itv gyodatstsene cigabışeeqa qabı deş, çolbıyiy t'ımılen bağbı huvu deş. Deşxhee, vak'le man insanar bı'rq'ı'bavane ats'a? Deş vüqqə! ");
INSERT INTO tkr_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mısa it'umra qəllamışxha Rəbbik'le eyhen: – Manbışe helen ılymaat'a. Zı manbışike əməleb alyapt'ı deş, neng'uscadıd pisın hı'ı deş. ");
INSERT INTO tkr_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mısee Qoraxık'le eyhen: – G'iyqa ğu yiğne gırgıne hambazaaşika arı Rəbbine ögiyl ulyozre, maa'ar ğunar, hambazarıb, Harunur ixhecen. ");
INSERT INTO tkr_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Vuşde gırgıng'vee, vuşun ətirbı gyoxhxhan ha'an g'abbı alyaat'u, caqa ətirbı gixhxhe. Qiyğa q'öd vəşşe xhots'alyne (250) insanne gırgıngvee manbı Rəbbine ögiylqa allecen. Ğunad Haruneeyid vuşun ətirbı gyoxhxhan ha'an g'abbı alle. ");
INSERT INTO tkr_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Gırgıng'vee con ətirbı gyoxhxhan ha'an g'abbı alyaat'u caqa gyopxhanna ghadıriy ətir givxhu, Mısaykayiy Harunuka sacigee Rəbbika yuşan ha'ane çadırene ghalee ulyoozar. ");
INSERT INTO tkr_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Qoraxee Mısalqayiy Harunulqava gırgın cəmə'ət çadırene ghalee sı'ımee, Rəbbin Nur milletıs gyaagva. ");
INSERT INTO tkr_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Rəbbee Mısayk'leyiy Harunuk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","– Mane milletıke əq'əna qeepxhe, Zı manbı sa manzilee gyapt'as. ");
INSERT INTO tkr_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Man g'ayxhı Mısayiy Harun aq'vakkena ç'iyelqa gizepçi eyhen: – Gırgıne üç'üdunçıs ı'mı'r hoolena Ğu vorna Allah! Hucoone ixhes, sang'vee bınah hav'uva, Ğu gırgıne cəmə'ətılqacab qəl hımaa'a! ");
INSERT INTO tkr_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","– Milletık'le eyhe: Qorax, Datan, Aviram aaxvane cigabışisse əq'əna qeepxhe! ");
INSERT INTO tkr_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mısa suğotsu Datanısqayiy Aviramısqava ayk'an. İzrailin ağsaqqalarıb Mısayqab qihna avayk'an. ");
INSERT INTO tkr_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mısee milletılqa xabar g'uxoole: – Man pisın insanar aaxvane çadırbışisse əq'əna qeepxhe. Manbışde nişikcab sumot'a, deşxhee, şunab manbışde bınahbışil-alla hapt'as. ");
INSERT INTO tkr_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Gırgınbı Qorax, Datan, Aviram aaxvane çadırbışisse əq'əna qeebaxhe. Dataniy Aviram cone xhunaşşeşika, dixbışika, k'ınne uşaxaaşika qığeepç'ı, çadırene ghalee ulyoozar. ");
INSERT INTO tkr_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mısee eyhen: – İn gırgın karbı zı zaled-alqana deş, Rəbbe uvhu hı'ıva şok'le inçike ats'axhxhes: ");
INSERT INTO tkr_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","man insanar avxuyn gırgın insanar xhinne hapt'eene, manbışde vuk'lelqa qadiynbıd menne insanaaşine vuk'lelqa qadıynçik akarada ıxheene, şok'le ats'axhxhe zı Rəbbee deş g'axuvu. ");
INSERT INTO tkr_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Rəbbee sa medın həşdilqamee g'ıdecuyn kar he'eene, ç'iyeyn ghal aaqı manbı cone karaka höbğeene, manbı şene dyunyelqa üç'übba apk'ıneene, manbı Rəbbis əsi vuxhava şok'le ats'axhxhesın. ");
INSERT INTO tkr_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Man gırgın Mısee yuşan hı'ı ç'əvxhamee, ç'iye q'öne cigeeqa qexhe. ");
INSERT INTO tkr_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Ç'iyeyn ghal aaqı coyub, con xizanbıd, Qoraxın hambazarıb, con gırgın karıd höğən. ");
INSERT INTO tkr_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Manbı cone gırgıne karaka ahaleeqa üç'übba avayk'an. Ç'iye manbışil oo it'umexhen, manbı milletne əreençe avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Manbışde hiqiy-alla ulyobzurne İzrailybışik'le manbışin ts'irbı g'ayxhı, «Ç'iyeyn şinab hümööğəcenva!» uvhu heebaxanbı. ");
INSERT INTO tkr_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Rəbbee ts'a g'axuvu q'öd vəşşe xhots'al (250) ətirbı adına insan gyoyxhan ha'ana. ");
INSERT INTO tkr_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","– İlahiyetçiy Harunne dixek'le Eliazarık'le eyhe, ətirbı gyoxhxhan ha'an g'abbı gyopxhunne insanaaşile aleet'ecen. Ətirbı gyooxhan ha'an g'abbı muq'addasınbı ıxhal-alla ğu manbı se'e. Qiyğa caana ghadır dağe'e. ");
INSERT INTO tkr_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Manbı bınahbı hı'iynbışin ətirbı gyoxhxhan ha'an g'abbı vod. Manbı cone bınahbışil-alla habat'a. Man ətirbı gyooxhan haa'an g'abbı k'etu k'üvə, qotku qe'e, manbı q'urbanbı allya'ane cigalqa gyuvaxanasınbı xhinne qe'e. Man g'abbı Rəbbis adıl-alla manbı muq'addasınbı vod. Hasre man İzrailybışdemee işaarat ixhecen. ");
INSERT INTO tkr_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","40","Gyooxhan hav'uyne insanaaşe adıyn yezake hı'iyn man g'abbı, kaahin Eliazaree Rəbbee Mısayk'le uvhuyn xhinne, alyaat'u yugda k'etu, qotku qı'ı, q'urbanbı allya'ane cigeeqa gyıvaxanasınbı xhinne qa'a. Harunuke g'abıynbışile ğayrı menne şavacad Rəbbine ögiyl arı ətirbı gyoxhxhan hıma'acenva məxüd ha'a. Man İzrailybışe yugda yik'el aqqecenva, Qoraxıkiy cune hambazaaşik qitxhuyn divan mebınbışik mexhecenva ha'a. ");
INSERT INTO tkr_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Qinne yiğıl İzrailyne cəmə'ətıncab Mısaylenayiy Harunulena haa'a vuxha. Manbışe «Şu Rəbbin millet gik'uva» eyhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Millet sadı Mısalqayiy Harunulqa ı'qqəmee, Rəbbika yuşan ha'ane çadırısnee manbışik'le buludun çadır avqu g'ooce. Mançe manbışis Rəbbin Nur gyaagva. ");
INSERT INTO tkr_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mısayiy Harunub çadırısqa qavayle. ");
INSERT INTO tkr_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","– Mane milletıke əq'əna qeepxhe, Zı manbı sa manzilee gyapt'as. Man g'ayxhı Mısayiy Harun aq'vakkena ç'iyelqa dizyabatçe. ");
INSERT INTO tkr_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mısee Harunuk'le eyhen: – Yiğın ətirbı gyoxhxhan ha'an g'ab aleet'e, caqa q'urbanbı allya'ane cigeençe gyopxhanna ghadır alyapt'ı gyuvxhe, qiyğad çilqad ətirbı gixhxhe. Manbıd alyaat'u milletısqa g'adaxhvne, manbışda bınah hooğle. Rəbb it'umra qəllamışxha, milletılqa haptasın xhinnen yı'q'ı'n ık'ar g'axuvu. ");
INSERT INTO tkr_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Harunee Mısee uvhuyn xhinne ha'a, ətirbı gyoxhxhan ha'an g'ab alyat'u milletısqa g'adayxhvan. Maa'ab insanar habat'a gibğıl vooxhe. Mang'vee vucee adiyn ətirbı gyopxhanne ghadırelqa gixhxhı, məxüb milletna bınah hooğalna. ");
INSERT INTO tkr_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Harun hapt'ınbışdeyiy üç'übınbışde yı'q'nee ulyorzuling'a ık'arbı ç'əveetxhaynbı. ");
INSERT INTO tkr_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Qoraxıl-alla hapt'ıynbışile ğayrı, yıts'ıyoq'vad aazıriy yighıd vəş (14 700) insan mane ı'k'arbışike qek'a. ");
INSERT INTO tkr_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Man ı'k'arbı ç'əveetxhava, Harun siyk'alna Rəbbine çadırısqa, Mısayne k'anyaqa. ");
INSERT INTO tkr_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","– İzrailybışika yuşan hı'ı, manbışde nasılbışde ç'ak'ınbışisse yits'ıq'vəne (12) nasılıs yits'ıq'vəlle əsaa aleet'e. Gırgıng'un do cune əsaal ok'ne. ");
INSERT INTO tkr_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Leviyne nasılene əsaalqa Harunun do ok'ne. Gırgıne nasılbışde ç'ak'ınbışde doyul sa əsaa ixhecen. ");
INSERT INTO tkr_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Manbı Zı şosqa araylene çadıree, Rəbbika mugaavilenane q'utyeyne ögiylqa gixhxhe. ");
INSERT INTO tkr_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Zı g'əvxüyne ç'ak'ınbışde sang'une əsaan t'ur g'aahas. Zı məxüd şolena haa'an İzrailybışin ghalybı sa'asınbı. ");
INSERT INTO tkr_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Mısa İzrailybışika yuşan hı'ı ç'əvxhaamee, manbışde gırgıne nasılbışde ç'ak'ınbışe mang'usqa curayda-curayda əsaabı hele. Mane quvuyne yits'ıq'vəne (12) əsaabışde əree Harunun əsaayid ıxhayn. ");
INSERT INTO tkr_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mısee əsaabı çadıree Rəbbine hiqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Qinne yiğıl Mısa çadıreeqa ikkeç'umee g'ecen, Leviyne nasılın quvuyne Harunne əsaal t'urub alyabı vob, t'et'ıd g'avhu vod, çil alyabına badamıb hipxhırıb. ");
INSERT INTO tkr_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mısee man gırgın əsaabı İzrailybışisqa qığa'a. Əsaabı g'əyxı' gırgıng'vee cun əsaa alyaat'a. ");
INSERT INTO tkr_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Rəbbee Mısayk'le eyhen: – Harunun əsaa sak'al hı'ı mugaavileyne q'utyeyne ögiylqa gixhxhe. Hasre man k'ırı ilydixhenbışdemee işaarat ixhecen. Mançin Zalena hav'uyud ç'əvə'əsın, coyub hapt'ıyke havaacesınbı. ");
INSERT INTO tkr_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mısee gırgın Rəbbee cuk'le uvhuyn xhinne ha'a. ");
INSERT INTO tkr_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","İzrailybışe Mısayk'le eyhen: – Şi habat'anbı! Yişde gırgıng'ukuncad ıxhayn! ");
INSERT INTO tkr_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Rəbbine çadırısqa qıxhnana gırgına qik'asda. Ho'ıne, şi gırgınbı hapt'asınbıne? ");
INSERT INTO tkr_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ts'eppiyne vuza gırgın İzrailybı Tsinne sahreeqa qabı, Qadeşee ulyoozar. Maa Mayram qeek'ana, maayir k'eyxhına. ");
INSERT INTO tkr_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","İzrailyne cəmə'ətıqa ulyoğasın xhyan eyxhe deş, mançil-allad cəmə'ət Mısayneyiy Harunne hiqiy-alla sadı, manbışik'le cuvabbı eyhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Cəmə'ətın manbı t'yats'axala'amee eyhe ıxha: – Yişin çocar habat'amee, şinab hapt'ınbıxhiy nimee yugda eyxheyiy! ");
INSERT INTO tkr_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nişisne şu Rəbbin cəmə'ət ine sahreeqa qadı? Şinab yişin həyvanarıd hatt'ecenvane? ");
INSERT INTO tkr_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nişisne şi Misirğançe qığav'u ine pisde cigeeqa qabı? İnyaa taxılib, inciliyib, t'ımılid, narar ələənçik akar deşod. İnyaa ulyoğasın xhyanıd deşod! ");
INSERT INTO tkr_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mısayiy Harun cəmə'ətısse Rəbbika yuşan ha'ane çadıresqa apk'ın, mançine ghalee aq'vakkena ç'iyelqa dizyabatçe. Maa'ad manbışisqa Rəbbin nur gyagva. ");
INSERT INTO tkr_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","– Əsaayid alyat'u, ğunayiy yiğne çocee Harunee cəmə'ət se'e. Manbışde ulene ögiyl ganzıke xhyan heqqe. Məxüd ğu milletıs ganzın xhyan heles, coyud cone çavra-vəq'əynıd avts'esınmeen xhyan ulyoğecenva. ");
INSERT INTO tkr_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mısee cuk'le uvhuyn xhinne əsaa Rəbbine ögiyle alyaat'an. ");
INSERT INTO tkr_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mıseeyiy Harunee cəmə'ət ganzine ögiylqa sı'ımee, Mısee maa'ad manbışik'le bınah ha'asın cuvab uvhu: – Zalqa vüqqənbı, zal k'ırı alixhxhe, nya'a, xhyan şi şos ine ganzeençene qığahas? ");
INSERT INTO tkr_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mısee xıl ooqa qı'ı, xılene əsaaka q'öne yəqqees ganzıle k'ena ı'xı'mee, mançeençe geed xhyan gyodatstse giyğal. Gırgıne cəmə'ətınıd cone çavra-vəq'əynıd mançe avts'esımeen xhyan ulyoğa. ");
INSERT INTO tkr_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Rəbbemee Mısayk'leyiy Harunuk'le eyhen: – İzrailyne milletıs Yizda muq'addasiyvalla haagvas vuşun inyam hiditxhırva, Zı manbışis helesva uvhuyne cigeeqa, Zı şosqa manbı hivxhara'as havaasaras deş. ");
INSERT INTO tkr_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Man xhyan Meriva (cuvabbı uvhiyn) eyhene cigaysneniy vod. İzrailybı ma'ab Rəbbika cuvabılqa abayle, Mang'veeyib Cuna muq'addasiyvalla ma'ab manbışik'le haagva. ");
INSERT INTO tkr_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Millet Or eyhene suvaysse giç'uyng'a, Edomne cigabışeeqa ikkideepç'esva manbı Ç'ərane deryahne suralqa avayk'an. Yəqqı'l milletın sabır g'aat'an. ");
INSERT INTO tkr_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Manbı giviyğalanbı Allahılenayiy Mısaylena haa'a. Manbışe eyhe ıxha: – Şu nişisne şi Misirğançe qığav'u? Sahree hapt'ecenvane? İnyaa, gıneyid, xhyanıd nencad deşin! İne otxhuniyked şas halı'iy qöö! ");
INSERT INTO tkr_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Mane gahıl Rəbbee manbışilqa zəhərıkan xoçebı salat'a'a. İzrailybışike geeb insanar xoçeyn üvxü hapt'ı. ");
INSERT INTO tkr_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Millet Mısaysqa adı eyhen: – Şi valena, Rəbbilena hav'u bınah opxhun. Düə hee'e Rəbbee şake xoçebı əq'əna qee'ecen. Mıseeyib Rəbbis düə haa'ana. ");
INSERT INTO tkr_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Rəbbee Mısayk'le eyhen: – Xoçe hav'u t'at'alqa qüvxhe. Xoçeyn ı'xı'na mançiqa ilyakkımee, üç'ürra axvas. ");
INSERT INTO tkr_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mısee yezake xoçe hav'u t'at'alqa gyuvaaxan. Xoçeyn ı'xı'na insan mane yezake hav'uyne xoçeyqa ilyakkımee, üç'ürra axva ıxha.");
INSERT INTO tkr_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Mısa gırgıne İzrailybışisqa qığeç'u inəxüd eyhe: ");
INSERT INTO tkr_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","– Zaqa vəşşe g'alle (120) sen vod. İnçile qiyğa zasse vuşda xərna ixhes əxəs deş. Rəbbeeyid zak'le uvhuynniy: «Ğu İordan eyhene damayle ılğeç'es deş». ");
INSERT INTO tkr_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Şu maqa ılğepç'ımee, şole ögiyl Vuc Rəbb, vuşda Allah, əlyhəəs. Şos qızaxxıyn milletbı Mangv'eecad kunfa-yakun ha'as. Manbışin cigabıd şos ixhes. Rəbbee uvhuyn xhinne, şos xəbvalla Yeşuee haa'as. ");
INSERT INTO tkr_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Rəbbee Emorğançen paççahar Sixoniy Og gyapt'ı manbışde cigabışilqa alli'ıyn yiğbı, şos qızaaxasde milletbışde vuk'lelqa qalya'asınbı. ");
INSERT INTO tkr_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Rəbbee manbı vuşde xıleqa qevles, şunad manbışik gırgın zı uvhuyn he'e. ");
INSERT INTO tkr_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Qı'məəq'ən, yik'bı it'umda aqqe. Şoka Rəbb, vuşda Allah, ı'qqə, nyaggah manbışile qəpq'ı'n yı'q'əlqa qımeebaxhe. Mang'vee ğu g'alerçu əlyhəəs deş. ");
INSERT INTO tkr_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Qiyğa Mısee Yeşua qort'ul gırgıne İzrailybışde ulene ögiyl mang'uk'le eyhen: – Rəbbee dekkaaşis k'ın g'assır helesva uvhuyne cigeeqa ğu in millet qıkkes. Ğu manbışis man ciga bit'al ha'as. Mançil-allar qı'məyq'ən yik' it'umda aqqe! ");
INSERT INTO tkr_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Rəbb Vuc vaka ixhes, vale ögiyl əlyhəəs. Mang'vee ğu g'alerçu əlyhəəs deş. Yik'eka ixhe, qı'məyq'ən! ");
INSERT INTO tkr_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Mısee mana Q'aanun opk'un, Rəbbika mugaavilenana q'utye quvkekkane Leviyke g'abıyne kaahinaaşisqayiy gırgıne İzrailyne ağsaqqalaaşisqacab qoole. ");
INSERT INTO tkr_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Qiyğa Mısee manbışik'le inəxüd eyhe: – Yighne sene səyaqqees, borcbı yik'el hixana'ane sen, K'odiybışin bayramnang'a ");
INSERT INTO tkr_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","gırgın İzrailybı Rəbbine, vuşde Allahne, ögiyl vuxhesva Mang'vee g'əyxəsde cigeeqa qabıyng'a, mana Q'aanun İzrailybışis qəpqe. ");
INSERT INTO tkr_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Milletıken adamer, yedar, uşaxar, menne cigeençe qabıynbı gırgınbı see'e. Hasre manbışde gırgıng'us g'ayxhı, xət qıxhecen Rəbbile vuşde Allahıle qəpq'ı'n gırgın Mang'une Q'aanunee otk'unin xhinne he'ecen. ");
INSERT INTO tkr_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Hasre Q'aanun dyaats'ane uşaxaaşik'led g'ayxhecen, Rəbbile, vuşde Allahıle, qəvəəq'ənas xət qıxhecen. İordanne damayle ılğepç'ı, man cigabı vuşunbı ıxhameeyid, nimelleteyiy şu ç'iyeyne aq'val vob, hasre məxüd ixhecen. ");
INSERT INTO tkr_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Manecad yiğıl Rəbbee Mısayk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","– Yerixo eyhene şaharne ögiylyne, Moav eyxhene cigeene Avarimne suvabışeene Nevo donane suvalqa ılqeç'e. Zı İzrailybışis helesde Kana'anne cigayqa ilekke. ");
INSERT INTO tkr_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","Yiğna çoc Harun Or eyhene suval qik'uyn xhinne, ğunar ine ğu ılqeç'esde suval qik'u dekkaaşisqa məxür əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","İzrailybışde ögiyl Tsinee sahree, Merivayne xhyanbışisne Qadeşee, şu Zal k'ırı ilydiyxhı, Yizda muq'addasiyvalla hidyaaguva, ");
INSERT INTO tkr_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","vak'le man ciga əq'ənançecad g'aces. Ğu İzrailybışis helesde cigeeqa ikkeç'es deş. ");
INSERT INTO tkr_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Mısa Moav eyhene suvabışde q'adaalile Nevolqa arı, maane Yerixoyne ögiylyne Pisga eyhene axtıne cigeeqa ılqeç'e. Rəbbee mang'uk'le gırgın cıgabı hagvanbı. Danilqamee ts'ıts'ooxhena Gilead, ");
INSERT INTO tkr_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","gırgın Naftaliyn, Efrayimıniy Menaşşeyn cigabı, garbne deryahılqamee ts'ıts'exhxhen Yahudayn cigabı, ");
INSERT INTO tkr_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Negev, xurmabışda şahar Yerixo, mançine qadalilyne Tsoar eyhene şaharılqamee ts'ıts'exhxhen gırgın cigabı hagva. ");
INSERT INTO tkr_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Rəbbee mang'uk'le eyhen: – Haane Zı İbrıhımıs, I'saq'ıs, Yaaq'ubıs k'ın g'assır helesva uvhuyn cigabı, şoke g'abıynbışis Zı manbışis heles. Zı vak'le man cigabı hagvanbı, vassemee maqa ikkeç'es əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Rəbbee uvhuyn xhinne eyxhe, Rəbbina g'ul Mısa Moavee qek'a. ");
INSERT INTO tkr_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Mana Moavee, Bet-Peorne ögiylyne q'adaalil k'eyxha. G'iyniyne yiğilqamee neng'uk'lecad mang'une nyuq'nen ciga ats'a deş. ");
INSERT INTO tkr_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Mısayqa qek'ang'a vəşşe g'alle (120) senniy vod. Mang'une uleppışin işixıd k'ıl qıxha deşdiy, guculer g'a'arxhu deşdiy. ");
INSERT INTO tkr_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Moavne q'adaalil İzrailybışe Mısays xhebts'al (30) yiğna ak' hoole. Mısayqa gyaaşen yiğbı, yasın yiğbı ç'əveedaxhenbı. ");
INSERT INTO tkr_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Mısee Nunne dixelqa Yeşualqa xıleppı gixhxhıva Rəbbee mang'us k'orana ək'el hoole. İzrailybışed Yeşual k'ırı iliyxhen, Rəbbee Mısayk'le nəxüdiy uvhu, manbışed gırgın həməxüdud ha'an. ");
INSERT INTO tkr_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","İzrailybışiqa Mısa peyğambar xhinne, Rəbbika hambaz hambazıka yuşan hı'ına, merna ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Rəbbee mana g'axuvunaniy Misiree fironus, mang'une gırgıne insanaaşis, ölkayscad geed əlaamatbı hagvas. Şavussecad Mısayle geed əlaamatbı hagvas əxı' deş. ");
INSERT INTO tkr_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","İzrailybışik'le məxdın qəvəəq'ənasın, ç'ak'ın, gucnan gorsatmabı hagvana, Mısa xhinnena merna g'acu deş.");
INSERT INTO tkr_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Haakimaaşe xəbvalla haa'ane yiğbışil İzrailil mısvalybı giyğal. Mane yiğbışil Yahudayne cigabışeene Bet-Lexem şahareençene sa adamee xhunaşşeyiy cuna q'öyre dixır alyapt'ı, sık'ınne gahısva ayk'anna Moav eyhene ölkeeqa. ");
INSERT INTO tkr_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Mane adamiyn do Elimelex, xhunaşşeyn Naomi, dixbışde sang'un Maxlon, mansang'unud Kilyon eyxhe. Manbı Yahudayne Bet-Lexem şahareençen Efratbı vuxha. Man insanar Moavqa qabı maayıb aaxvanbı. ");
INSERT INTO tkr_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Sabara gahıle Naomiyna adamiy Elimelex qek'ana, mana q'öne dixeka eexva. ");
INSERT INTO tkr_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Məng'ı'ne dixbışe cos Moavbışin içer haa'a. Manbışde sang'ı'n do Orpa, mansang'ı'nıd Rut eyxhe. Manbı yits'ılle senmee maa'ab avxuyle qiyğa, ");
INSERT INTO tkr_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Maxlonur Kilyonur habat'anbı. Naomi adamiyiy dixbıdena eexva. ");
INSERT INTO tkr_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi Moavne cigabışee yeexhene gahıl, məng'ı'k'le g'iyxhen, Rəbbee Cune milletıs Cuna yugvalla haagu, manbışis gıneyıd huvu. Mana sossaaşika Moavğançe siyk'alnava g'elil qeexhe. ");
INSERT INTO tkr_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Naomi cene q'öne sossaka sayk'alasva, eexvane cigeençe qığeyç'u Yahudayne cıgabışeeqa yəqqı'lqa geexha. ");
INSERT INTO tkr_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomee cene sossaaşik'le eyhen: – Qudoora, vuşda q'öyursana yedyaaşine xaaqa savk'le. Şu hapt'ıynbışisiy zas hav'uyne yugvalil-alla, hasre Rəbbee şos Cuna badal dyooxhena yugvalla haagvecen. ");
INSERT INTO tkr_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Hasre Rəbbee şos adamer hevlecen! Mane xizanee şoqa rəhətiyvalla vuxhecen! Manıd uvhu, məng'ee sossaaşis ubbabı hı'ımee, sossar axtıba gyaaşu, ");
INSERT INTO tkr_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","eyhen: – De'eş, şi vaka sacigee yiğne milletısqa vüqqəs. ");
INSERT INTO tkr_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Naomeeme eyhen: – Yizın yişşar, xaaqa savk'le. Nişisne şu zaka vüqqə? Nya'a, şos adamer vuxhesın, zas mebın dixbıne vuxhes? ");
INSERT INTO tkr_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yizın yişşar, savk'le. Zı adamiys yı'qqəsın xhinne deş vor, q'əs qiyxha. Zı həşde uvheene, zaqa umud vob, zı g'iyna xəmde adamiys ark'ın, vuxhne ayxu dixbı uxasva. ");
INSERT INTO tkr_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Nya'a, manbı ç'ak'ı qeepxhesmee, şu adamer dena aaxvas vooxheyee? De'eş, yizın yişşar! Rəbbee zalqa xıl g'ott'ulva, yizda ı'mı'r q'ap'ı quvxha. Yizın uts'ur vuşun çiled geed vod. ");
INSERT INTO tkr_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Manbı meeb maa'ab axtıba gyaaşe giviyğal. Orpa abays ubba hı'ı iyeek'anna. Rutmee, abayk at'irq'ın eexvana. ");
INSERT INTO tkr_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomee Rutuk'le eyhen: – Haane yiğne g'ayniyna xhunaşşe cene milletısqa, cene allahbışisqa siyk'al. Qeera, ğunar məng'ı'qa sayk'le. ");
INSERT INTO tkr_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rutee eyhen: – Zı mizel iyqimeeqqa valqa yı'q' sak'al hı'ıyee, ğu g'alerçuyee, yeeracenva. Vak'le ats'axhxhe, ğu ark'ınne cigeeqa zınar əlyhəəsda, ğu ulyorzulyne cigee zınar ileezarasda. Yiğın millet yizın millet ixhes, yiğna Allahır yizda Allah ixhes. ");
INSERT INTO tkr_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ğu qiyk'uyne cigee zınar qiyk'asda, maayir k'eyxhasda. Qiyk'uyle ğayrı, menne karan zı vake curey'ee, hasre Rəbbee zakın he'ecen. ");
INSERT INTO tkr_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomilqa hitxhırmee Rutus hək'eracar cekavur yı'qqəs yikkanva, məng'ee məng'ı'ke xıl tsı'ıts'aa'ana. ");
INSERT INTO tkr_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Manbı məxüb Bet-Lexemqa hivxharasmee, sacigee avayk'ananbı. Manbı Bet-Lexemqa qabı hipxhırmee, şaharın cəmə'ət q'omançe-k'anyaqqamee çiçis ı'xı'yxə. Zəiyfabışe eyhen: – İna Naomi dişeene? ");
INSERT INTO tkr_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomee manbışik'le eyhen: – Gırgın əxəne Allahee yizda ı'mı'r q'ap'ı qav'uynçil-alla zak'le Naomiva (ittuna) deş, Marava (q'ap'ına) eyhe. ");
INSERT INTO tkr_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Zı inençe gyayts'ı-giyxhı qığeyç'veeyir, Rəbbee zı inyaqa q'ərar sayk'al hey'ı. Nişil-allane şu zalqa Naomiva ona'a? Rəbbee zalqa dağamiyvalla g'axuvu, Gırgın əxəng'vee zalqa yiğbı alli'ı. ");
INSERT INTO tkr_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Məxür Naomi, Moavne cigabışeençe cene sossaka Moavğançene Rutuka sacigee yı'q'əlqa siyk'al. Manbı Bet-Lexemqa xhıt'a qiviyşalne gahıl qabı hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomiyne adamiyqa Elimelexıqa, hək'erar sa yugna, qıvaats'ına Boaz donana xını eyxhe. ");
INSERT INTO tkr_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Yiğbışde sa yiğıl Moavğançene Rutee Naomiyk'le eyhen: – Hayeesre zı çolbışeeqa yı'qqəs. Şavne ulesqayiy zı yugra qarı, mang'uqa qihna ark'ın, mang'uke avxuna xhıt'a saa'as. Naomee məng'ı'k'le «Yiş, hiyek'neva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Rut hark'ın çolbışde sançee, xhıt'a qiviyşalanbışde qihna ı'ğiykır avxuna xhıt'a saa'a. Məxür mana cek'le dyats'adcad, Elimelexne xınıyne Boazne çoleeqa qiyeele. ");
INSERT INTO tkr_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Mane gahıl Boaz Bet-Lexemğançe qarı, xhıt'a qiviyşalanbışik'le eyhen: – Hasre Rəbb şoka ixhecen! Manbışed mang'us «Rəbbeeyib vas xayir-düə hevlecenva» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boazee qiviyşalanbışde ooqa gixhxhıyng'uke qiyghanan: – İna mek'vna zəiyfa şavunbışdane? ");
INSERT INTO tkr_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Mane insanee eyhen: – İna mek'vna zəiyfa Moavğançe vor. Mana Moavğançe inyaqa Naomiyka sacigee qarı. ");
INSERT INTO tkr_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Məng'ee zak'le uvhuyn: «Hucoone ixhes, zı hiyeesre xhıt'a qiviyşalanbışiqa qihna ı'ğiykır avxuna xhıt'a saa'as». Mana çoleeqa miç'eer arına vor, həşdilqameeyir ark'ın deş. Mana vüxənayk avurur sık'ınna gahna giy'ır. ");
INSERT INTO tkr_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boazee Rutuk'le eyhen: – Yiş, zal k'ırı alixhxhe! Avxuna xhıt'a saa'asva inençe menne çoleeqa imeek'an. İnyaa yizde g'ulluxçiy içeeşika eexve. ");
INSERT INTO tkr_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","İleeke, yizde g'ulluxçiy içeeşe nyaabiy xhıt'a qiviyşal, manbışiqa qihna ı'ğı'ykre. Zı yizde işçeeşik'le vak sumoot'ava uvhu. Vas mısayiy xhyan ıkkiykın, hark'ın yizde işçeeşee gyatsts'ı'iyne parçbışeençe ulyoğe. ");
INSERT INTO tkr_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rut mang'us ç'iyelqamee k'yorzul eyhen: – Nya'a, zı vasqa yugra qarı? Nya'a, ğu zaka menne cigeençe qarıyng'uka yugra eyxhe? ");
INSERT INTO tkr_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boazee məng'ı's inəxdın alidghıniy qele: – Adamiy qik'uyle qiyğa, ğu abaynemee hı'iyn gırgın kar zak'le g'ayxhiyn. Ğu dek, yed, yiğna vatan g'alepçı, vak'le mankilqamee dyats'anecad milletne k'anyaqa qarı. ");
INSERT INTO tkr_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Hasre vas mane işil-allan Rəbbee helecen! Ğu xılik avqa dyuguliyxhesva qariyne Rəbbee, İzrailyne Allahee vas geed mukaafat helecen! ");
INSERT INTO tkr_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rutee eyhen: – Xərna, zı şadra vor, zı yiğne ulen ayqıva. Ğu zas yik'bı huvu. Zı yiğne g'ulluxçiy içeeşina deyxheeyir, ğu zaka manbışika xhinne yugra yuşan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Yı'q'ı'hı'n kar otxhanmee, Boazee məng'ı'k'le eyhen: – İnyaqa qeera, ğunad gıney şakasana bakmazeeqa k'yoq'u oxhne. Rut qarı qiviyşalanbışde k'ane giy'ırmee, Boazee məng'ı's qootsuna xhıt'a hoole. Rut opxhun eets'enar, hexxabab aaxvana. ");
INSERT INTO tkr_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Mana meer k'yapk'ınna xhıt'a saa'asva oza qiyxhamee, Boazee cune nukaraaşik'le eyhen: – Məng'ee ark'ın, bafabışde yı'q'neençeb saa'axhee, məng'ı'k'le cuvab immeyhe. ");
INSERT INTO tkr_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Qiviyşalang'ab məng'ı'sva bafabışeençe q'asdın gıt'ybı dağe'e, hasre se'ecen. Məng'ı'k'le vuççud immeyhe. ");
INSERT INTO tkr_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Məxüb Rutee exhalilqamee çolee gıt'y saa'a. Sav'una gıt'y gyootumee, məng'ı's sa xəbna ç'emç'e xhıt'ayna vooxhe. ");
INSERT INTO tkr_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Qiyğab məng'ee mana alyapt'ı, şahareeqa qiyeele. Abayk'led məng'ee nimee geeb xhıt'ayiy sav'uva g'ecen. Rutee yicee yı'q'ı'hin kar otxhanang'a, hexxada axuyn qığavhu abays hele. ");
INSERT INTO tkr_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Abee məng'ı'ke qiyghanan: – G'iyna ğu gıt'y nençene sav'u? Nyaane işlemiş yixha? Hasre yiğna hav'une insanıs xayir-düə vuxhecen! Şavusneyiy yic işlemiş yixhava, Rutee abays yuşan hı'ı, eyhen: – G'iyna zı işlemiş yixhane adamiyn do Boaziy. ");
INSERT INTO tkr_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomee sossak'le eyhen: – Hasre Rəbbee, üç'übınbışikeyiy hapt'ıynbışike cuna badal dyooxhena yugvalla qivdiykkanne Boazıs xayir-düə hevlecen! Naomee meed eyhen: – Mana, şi g'attivxhan hav'iy gardanaqa gexhane xınıbışda sa vorna. ");
INSERT INTO tkr_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Moavğançene Rutee eyhen: – Sayid mang'vee zak'le uvhuyn, cun qiyşalan cigabı ç'əvxhesmee, cune işçeeşika işlemiş yixhe. ");
INSERT INTO tkr_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomee cene sossak'le, Rutuk'le eyhen: – Yizda yiş, mang'une g'ulluxçiy içeeşika yiğın ı'ğiykıriy yugda ixhes. Deşxhee, merıng'une çolee vak'le cuvabniy eyhes. ");
INSERT INTO tkr_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Məxür Rut xhıt'ayiy suk qiviyşil ç'əvuvxhesmee, Boazne g'ulluxçiy içeeşika işlemişeexhe. Eexvasır mana abayka eexva. ");
INSERT INTO tkr_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Yiğbışde sa yiğıl Rutune abee Naomee məng'ı'k'le eyhen: – Yizda yiş, vas rəhətda ixhecenva, zı vas sa yugun ciga t'abal ha'as ıkkan dişde? ");
INSERT INTO tkr_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Nya'a, ğu g'ulluxçiy içeeşika işlemiş yixhana Boaz, yişda xını eyxhe dişde? Mang'vee g'iyna exhal cune xhıt'ayke attayl vara ha'a vod. ");
INSERT INTO tkr_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ğunar ə'yeexı'r, micagın tanalinbı ali'ı, ətirbıd qadğu maqa hiyek'ne. Mang'vee otxhun-ulyodğu ç'əvxhesmee, ğucar ğu mang'uk'le himeegva. ");
INSERT INTO tkr_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Mana g'alixhasva əlyhəəmee, mana nyaaryiy g'ılexhava ats'axhxhe. Qiyğar maqa ikkeyç'u, mang'une g'elybışilin kar g'ayşu maa'ar g'aliyxhe. Mang'veecad vak'le eyhesın, hucooyiy ha'as ıkkanva. ");
INSERT INTO tkr_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rutee «Zı ğu uvhuyn gırgın ha'asınva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Mana atteeqa arı gırgın abee uvhuyn xhinne ha'a. ");
INSERT INTO tkr_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boaz yugda otxhun-ulyodğu yik' cigeeqa qadımee, g'alixhasva xhıt'ayne anbarbışde mıgleqqa ayk'an. Rutur nıq' dena qarı, mang'une g'elybışilin kar g'ayşu, maa'ar g'ıleexha. ");
INSERT INTO tkr_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Xəm surak Boaz muğur qıxha alytirk'ılmee, cune g'elybışee zəiyfa g'alirxhu g'eece. ");
INSERT INTO tkr_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Mang'vee məng'ı'k'le eyhen: – Ğu vuşuna? Məng'ee eyhen: – Zı yiğna g'ulluxçiy Rut vorna. Zas vukkul hüvxəsın ciga he'e. Ğu, şi g'attivxhan hav'iy gardanaqa gexhana xını vorna. ");
INSERT INTO tkr_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boazee eyhen: – Yizda yiş, hasre vas Rəbbee xayir-düə hevlecen! Ğu ina hav'una yugvalla şene ögiyinçileb yugna vob. Ğu mek'vne karnaneyiy kar deşde adameeşiqa qihna g'iddyarxhuninçil-alla. ");
INSERT INTO tkr_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Yizda yiş, ğu həşdiyle qı'meeq'ən! Zı yiğnemee vas ıkkanan kar ha'asın. Yişde şaharne gırgıne insanaaşik'le ğu hək'erar yugna zəiyfa yixhay ats'an. ");
INSERT INTO tkr_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Zı vuşda xını ıxhay qotkun vodun, saccu şoqa zale k'anena xını vor. ");
INSERT INTO tkr_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","G'iyna xəmdiysır inyaacar eexve. G'iyqa mane vuşde xınıys, şu g'attivxhan haa'as vukkiykınee, yugda ixhes, hasre hee'ecen. De'eş, mang'us man ha'as diykınee, Vorne Rəbbilqan k'ın ixhen, man zı ha'as. Miç'erilqamee inyaa g'aliyxhe. ");
INSERT INTO tkr_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rut miç'erilqamee mang'une g'elybışee g'ileexha. Boazee culed-alqa «Hasre şavuk'lecad atteeqa zəiyfa arıva mats'axhxhecenva» uvhuva, Rut torandanang'acad, yic g'ımececenva, oza qeexhe. ");
INSERT INTO tkr_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boazee Rutuk'le eyhen: – Valqa aletçuyne karan sa sura zasqa hele, ğunad manisa surale aqqe. Rutee Boazee uvhuyn xhinne ha'a. Boazeeyib məng'ı's xılece xhıt'a kyav'u, məng'ı'ne mıgalqa qoole. Mançer Boaz şahareeqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut cene abaysqa Naomisqa sark'ılymee, məng'ee qiyghanan: – Yiş, nəxüdne ıxha? Rutee, Boazee cenemee hı'iyn gırgın kar abays yuşan hı'iyle ");
INSERT INTO tkr_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","qiyğa, eyhen: – Abaysqa xıl q'ərar simiyk'alva uvhu mang'vee zas inimeena xhıt'ab huvuna. ");
INSERT INTO tkr_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomee Rutuk'le eyhen: – Yiş, sık'ırra örxe, ilyaakas ina iş nəxübiy g'ittiviyxhan. Mane insanee g'iyna mana iş, sa suralqa qığdyavhu ulyozaras deş. ");
INSERT INTO tkr_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boaz şaharne akkabışisqa qığeç'u, insanar sabıyne cigee giy'ar. Boazee eyhena şena k'anena xını mançe ı'lğəmee, mang'vee mang'ulqa onu'u eyhen: «Zasqana sark'ıl, inyaa gyu'relan». Manar qarı giy'arna. ");
INSERT INTO tkr_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boazee şaharne ağsaqqalaaşike yits'ıyre insanır qort'ul «Şunab inyaa gyuvreva» eyhe. Manbıb qabı giviy'aranbı. ");
INSERT INTO tkr_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boazee mane xınıyk'le eyhen: – Moavne cigabışeençe sark'ılyne Naomee, yişda ebana eyxhene Elimelexin ciga vod massa hele. ");
INSERT INTO tkr_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","İnyaa gyuv'uriynbışdeyiy cəmə'ətne ağsaqqalaaşine k'ane, zı valqa g'ayxhya'an, man ciga ğu alişşes ıkkan. Ğu ilydeşşesxhee, man zak'le eyhe, zak'le ats'axhxhes. Mane işee ts'erriyna ğu eyxhe, qiyğiynar zı. Mang'vee Boazık'le: «Zı man ciga ileşşenva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Boazee eyhen: – Ğu man ciga Naomiyke ileşşemee, mang'une qik'uyne dixena xhunaşşe Moavğançena Rutur hee'es yikkan. Qiyğa şos dix ıxhayng'a, man ciga qik'uyng'une xizanıs axvecenva. ");
INSERT INTO tkr_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Xınee eyhen: – Məxüdxheene, zasse man ciga alişşes əxəs deş. Zı man ciga alişşvee, man yizde ts'erriyne xhunaşşeykene uşaxaaşis hixharas deş. Zasse man ciga alişşes əxə deşud, ğucad alişşvee yugda eyxhe. ");
INSERT INTO tkr_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Avaala İzrailil sa kar alişşu-massa huvuynemee, sa kar badal hı'iynemee, insanee g'elilin g'ellin g'ayşu mansang'usqa qele ıxha. Man ədat, şi iş yəqqı'lqa gyuvxhunava eyhen ıxha. ");
INSERT INTO tkr_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Xınee Boazık'le eyhen: – Ğucab alivşe. Qiyğad mang'vee cune g'elilin g'ellin g'eşşe. ");
INSERT INTO tkr_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boazee ağsaqqalaaşik'leyiy gırgıne cəmə'ətık'le eyhen: – Şu g'iyna şahadar vobınbı, zı Elimelexıke, Kilyonıke, Maxlonuke axuyn gırgın Naomiyke ileşşen. ");
INSERT INTO tkr_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Qik'uyng'un do cune cigabışil axvecenva, cune xınıbışde yı'q'neençe, cune şahareençe hımaykalcenva, Maxlon qik'u ayxuna cuna xhunaşşe, Moavğançena Rut zı zas hee'e. Şunab g'iyna şahadar vobınbı! ");
INSERT INTO tkr_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Akkabışisqa sabıyne insanaaşeyiy ağsaqqalaaşe eyhen: – Şi şahadar vob. Hasre Rəbbee yiğne akkalqa qööna zəiyfar Raahileykiy Leayk akarna hee'ecen. Manbışe Yaaq'ubıs geeb uşaxar vuxu. Ğu Efratbışde yı'q'ne karnana ixhe, Bet-Lexemılid yiğın do ats'axhxhecen. ");
INSERT INTO tkr_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Hasre Rəbbee mane mek'vne zəiyfee vas vuxasın uşaxar Peretsna xizan xhinne qıvaats'ına hee'ecen. (Perets Tamarıs Yahudaykeniy ıxha.) ");
INSERT INTO tkr_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Boazee Rut hee'e, Rutuke mang'us xhunaşşe yeexhe. Boaz Rutuka g'alirxhumee mana vuxhnee eexva. Rəbbee manbışis uşax hele. Rutee dix uxooxa. ");
INSERT INTO tkr_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Yadaaşe Naomiyk'le eyhe ıxha: – Rəbbis şukur vuxhena, Mang'vee g'iyna vas, ğu gatt'iyxhan hee'esda neva huvu. Hasre mang'un do İzrailvolle ats'axhxhecen! ");
INSERT INTO tkr_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Mang'vee ğu mek'v qee'es, q'əsvalee vaqa ilyakkas. Mana vas yighne dixıle yugne, ğu yikkanne sossee uxuva. ");
INSERT INTO tkr_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomee uşax xhılibışeeqa alyaat'u, man iykar ha'a, mang'uqa ileeka yixha. ");
INSERT INTO tkr_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Maane hiqiy-allane yadaaşe eyhe ıxha: – Naomiynemee dix ıxha. Mang'un do Oved giyxhe. Mana Davud peyğambarne dekkına, Yesseyna dek ıxha. ");
INSERT INTO tkr_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","İna Peretsna nasıl vob: Peretsıke Xetsron g'arayle. ");
INSERT INTO tkr_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Xetsronıke Ram g'arayle. Ramıke Amminadav g'arayle. ");
INSERT INTO tkr_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Amminadavıke Naxşon g'arayle. Naxşonıker Salmon g'arayle. ");
INSERT INTO tkr_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmonıker Boaz g'arayle. Boazıker Oved g'arayle. ");
INSERT INTO tkr_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Ovedıker Yessey g'arayle. Yesseyıker Davud peyğambar g'arayle.");
INSERT INTO tkr_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Efrayimne suvabınane cigee, Rama eyhene şaharee Elkanava adamiy eyxhe ıxha. Mana İyeroxamna dix ıxha. İyeroxamur Elihuyna dix ıxha, Elihur Toxuyna dix ıxha, Toxur Tsufayna dix ıxha. Tsufiy cuke g'abıynbı Efrayimne nasılıne cigabışee aaxva vuxha. ");
INSERT INTO tkr_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elkanıka Xannayiy Peninna donan q'öyre xhunaşşer vuxha. Peninnayka uşaxar vobunbıniy, Xannaysme uşaxar vooxhe deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Seniys mana insan cune şahareençe qığeç'u, hayk'an ıxhana Şilo eyhene şahareeqa Xəəne G'oşunbışde Rəbbis ı'bəədat hı'ı, q'urbanbı alylya'asva. Mane gahıl Xofniyiy Pinxas Rəbbin kaahinarniy vob. Manbı Eliyn dixbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Elkanee q'urban ablyaa'ane yiğıl cune xhunaşşeys Peninnays, məng'ı'ne dixbışdeyiy yişbışde gırgıng'us q'urbanna pay hoolenaniy. ");
INSERT INTO tkr_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Xannaysme mang'vee q'öble pay hoole vuxha. Rəbbee məng'ı's uşax hidele ıxheeyid, Elkanays mana geerniyxhe yikkiykanna. ");
INSERT INTO tkr_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Xannayne q'əyeeme, Rəbbee məng'ı's uşax hideleva məng'ı'lqa cuvabbı ayhe, demalqa giyxhe yixha. ");
INSERT INTO tkr_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Senbı inəxüd ı'lğəə ıxha. Xanna, mısa Rəbbine xaaqa hark'ınee, məng'ı'ne q'əyee məng'ı'lqa cuvabbı ayhe ıxha. Xanna man eyhenbı g'ayxhı, geeşe yixha, karıd məng'ee otxhan ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Məng'ı'ne adamee, Elkanee, məng'ı'k'le eyhe ıxha: – Xanna, nya'a geeşe? Nya'a kar udyotxhan? Nya'a yiğın yik' gyotxhan? Nya'a, zı yiğnemee yits'ne dixele hexxana dişde vor? ");
INSERT INTO tkr_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Manbışe Şilo eyhene şaharee otxhun-ulyodğuyle qiyğa, Xanna g'elilqa sığeetsa. Kaahin Eliyir, Rəbbine xaane akkabışisne gyu'ur eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Yik' gyotxhan-gyotxhan Xannee Rəbbis hülöörəxə düə haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Məng'ee Rəbbis miz k'yav'u, inəxüd cuvab hele: – Xəəna G'oşunbışda Rəbb, Vak'lecab Yiğne bendelqa abına ver g'oocena. Vasse, zı Yiğna bende yik'el hidirxınee, zas sa dix huvee, zınar mana gırgıne gahbışis Vas heles. Mana Rəbbis g'assırva, mang'una vuk'ul mısacab gyapxhas deş. ");
INSERT INTO tkr_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Xannee Rəbbis xıliyna düə haa'a vuxha, Eliyir gyu'ur məng'ı'ne ghalika ilyakka ıxha. ");
INSERT INTO tkr_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Xannee yik'eençe düə haa'ava, məng'ı'n saccu ghalycad ı'ğiykar eyxhe, ses g'iyxhe eyxhe deş. Eliysqa məxı'd qayle, məng'ee ulyodğuniyxan vod. ");
INSERT INTO tkr_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Mançil-allad mang'vee eyhen: – Ğu mısılqameene ulyoğas? Mançıkana g'alepçe, valqa qeera! ");
INSERT INTO tkr_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Xannee eyhen: – Yizda xərna, yizın yik' gyotxhan ıxhayke, zı Rəbbis yizın yik' q'əra qa'a. Zı çaxıriy p'iyva deş ulyodğu. ");
INSERT INTO tkr_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Vasqa məxüd qımaylecen, zı abır deşda zəiyfaniyxan. Zalqa xəbna ver abıva, yizın yik' gyotxhanva, zı düə məxı'b hav'u. ");
INSERT INTO tkr_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Eliyee alidghıniy qele: – Yugna yəq vuxhena. İzrailyne Allahee, ğu heqqiyn vas helesın. ");
INSERT INTO tkr_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Xannee: «Ğu zaqa, yiğne bendeyqa, yugra eyxheva» uvhu, sark'ıl cene yəqqı'n ark'ın kar oyxhan. Mançile qiyğa məng'ee aq'va qa'a deş. ");
INSERT INTO tkr_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Qinne yiğıl manbı miç'eeb çakba oza qeepxha, Rəbbis ı'bəədat hı'ı Ramayeene, cone xaaqa, siviyk'al. Elkana cune xhunaşşeyka Xannayka g'ılexha, Rəbbeeyid məng'ı's ıkkanan ha'an. ");
INSERT INTO tkr_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Sabara gah ılğevç'uyle qiyğa Xanna vuxhne ayxu sa dix uxooxa. Məng'ee «Mana Rəbbike heqqıva» uvhu, mang'un do Şamuel (Allahık'le g'ayxhı) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Elkanayiy cuna xizan, Rəbbis senıs ablyaa'ana q'urban ablyaa'asvayiy Rəbbis huvuyn cuvab aqqasva, Şiloyeeqa havayk'an. ");
INSERT INTO tkr_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Xannamee mang'uka hiyeek'an deş. Məng'ee adamiyk'le eyhen: – Nebeluğ gyarğılıyle qiyğa, zı mana Şiloyeeqa Rəbbis heles ıkkees. Mana gırgıne gahbışis maa axvas. ");
INSERT INTO tkr_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkaneeyid eyhen: – Vas ıkkanəxüd he'e, mana gyarğıl ç'əvxhesmee xaa giyre. Hasre Rəbbeeyid Vuce huvuyn cuvab aqqecen. Mana, dix gyarğıl ç'əvxhesmee, cuka xaa eexva. ");
INSERT INTO tkr_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Uşax gyarğılmee, Xannee xhebne seniyna conga, sa urvanna maşuk', sa tuluğud çaxıren alyaat'u, Rəbbine Şiloyeene xaaqa hiyeek'an. Mane gahıl uşax k'ılda ıxha. ");
INSERT INTO tkr_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Conga gyuvk'iyle qiyğa, Xannee uşaxıd alyaat'u Eliysqa arı, ");
INSERT INTO tkr_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","mang'uk'le eyhen: – Yizda xərna, yiğne canalqan k'ın ixhen, inyaa, yiğne k'ane ulyorzul Rəbbis düə haa'ana şena zəiyfa, zıniy vor. ");
INSERT INTO tkr_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Zı ine uşaxnemeeniy düə haa'a, Rəbbee zı heqqıyn, zas huvuyn. ");
INSERT INTO tkr_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Həşde zı mana Rəbbis hele. I'mı'rvollete mana Rəbbina ixheskan. Manbışe maa'ad Rəbbis ı'bəədat ha'a. ");
INSERT INTO tkr_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Xannee inəxüb düə haa'a: – Rəbbee yizın yik' şad hı'ı, Rəbbee zas xəbna guc huvu. Zı şad yeexhe, Ğu zı g'attiyxhaney'il-alla. Zı həşde yizde duşmanaaşile əqəna ha'a. ");
INSERT INTO tkr_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Rəbbik akarna q'ör'esda məxrına muq'addasna deşda, Ya Rəbb, Ğu sa vorna! Yişda Allah xhinnena şi havaacena merna deşda! ");
INSERT INTO tkr_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Şucab şu ç'ak'ıba vukkiy ç'əv he'e! Hexxan cuvabbı ghaleençe g'ımekka! Saccu Rəbb gırgın ats'ana Allah vor, Mang'vee gyoodakke insanaaşin işbı. ");
INSERT INTO tkr_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","İgidyaaşin vukbı hayq'var, Guc deşinbışismee guc qavayle. ");
INSERT INTO tkr_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Şenke avts'u iviykaranbışe Həşde gıneynemee iş t'abal haa'a, Mıssınbıb həşde avts'u iviykar. Uşax dexheng'ee yighıyre uxu, Geed uşaxaarnanar yiccar ayxu. ");
INSERT INTO tkr_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Rəbbee insanıs ı'mı'rıb hoolena, Vuceeyib alyabat'ana, Mang'veecarır nyuq'vneeqa k'yaraççena, Vucecarır alqayhena. ");
INSERT INTO tkr_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Rəbbee insanıs kar helenıd, g'eşşenıd. Mang'vee insan axtır qa'ana, uleker gyayhena. ");
INSERT INTO tkr_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Rəbbee mı'q'eena kar deşda g'elil qa'ana, Qıvaats'ıynbışika sacigeeyir gya'ana. Mang'vee dyunyecad aqqı. ");
INSERT INTO tkr_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Cuna yəq' avquynbı Mang'vee havaacenbı, Pisınbıb miç'axiyvalee avgales, Manbışde guçun manbışis kumag ha'as deş. ");
INSERT INTO tkr_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Culqa g'elil qeepxhaynbı Rəbbee oot'al-ooxal haa'asınbı, Manbışilqa xəybı g'əhətqə'əs. Rəbbee dyunyeyscad məhkama alğahas! Mang'vee Vucee g'əyxı'yne paççahıs guc hoole, Mana axtı qa'a. ");
INSERT INTO tkr_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Qiyğa Elkana cune Ramayeene xaaqa siyk'al. K'ınna Şamuelymee kaahin Eliyne k'ane Rəbbis k'ılyvalla haa'a axva. ");
INSERT INTO tkr_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Eliyn dixbı geeb karaı'dəən insanar vuxha. Manbışe Rəbbir qizara'a ıxha deş, ");
INSERT INTO tkr_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","kaahiniyvallab kara'əəba haa'a vuxha deş. Şavaamecab q'urban ablyav'u, çuru qoyxharang'a, kaahinna nukar xıle xhebne silinane yabayka hiyxhar ıxha. ");
INSERT INTO tkr_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Mang'vee man yaba çurunane k'umk'umeeqa, lyagameeqa, tavasareeqa, g'abeeqa, nyaqa ıxhay hiyxə ıxha. Yabalqa qadıyn gırgın mang'vee kaahinıs alyaat'a ıxha. Məxüd manbışe, Şilo eyhene cigeeqa İzrailybışe adıyne gırgıne q'urbanne çurunukcad ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Man k'ıldanan xhinne, q'urbanın adın ma' gyoxhxhan ha'asse, kaahinna nukar arı, q'urban ablyaa'ane insanık'le eyhe ıxha: – Kaahinıs ç'əra qa'asın çuru hele. Mang'vee vake qotxhuruyn çuru alyaat'as deş, mang'us çigın çuru hele. ");
INSERT INTO tkr_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Q'urban ablyaa'ang'vee: «Hasre ts'etta ma' gyoxhxhan ha'as, qiyğa vas nenayiy pay vukkan manab alept'eva» – uvhumee, nukaree: «De'eş, həşde qavaleva, qudyoolexheeyib gucuka alyapt'asvaniyxheva» – cuvab qelen. ");
INSERT INTO tkr_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Rəbbine ögiyl mane mek'vunbışda, Eliyne dixbışda, bınah geeb xəbnaniy vob. Manbışe Rəbbis adıynçis hı'rmat haa'a vuxha deş. ");
INSERT INTO tkr_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","K'ınne Şamueleemee katanıke hı'iyn ileylığ givatxın, Rəbbine ögiyl k'ılyvalla haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Yedee seniysın Şamuelisın k'ınin p'laş iyxhva ıxha. Dek seniysda q'urbanana Şilo eyhene cigeeqa ı'qqəmee, yicır man p'laş alyaat'u ayreele yixha. ");
INSERT INTO tkr_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Kaahin Eliyeeme, Elkanaysiy mang'une xhunaşşeys xayir-düə huvu, eyhe ıxha: – Hasre Rəbbee vas ine yiğne xhunaşşeyke, yicee heqqı Rəbbis huvuyne uşaxıl-alla, mebın uşaxar hevlecen. Mançile qiyğa manbı cone xaaqa siviyk'al vuxha. ");
INSERT INTO tkr_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Rəbbee Xannays yugvalla hav'u, məng'ı's Rəbbee mançile qiyğa xhebiyre dixiy q'öyrer yiş heele. K'ınna Şamuelymee Rəbbine ögiyl xər qexhe eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Eli geer q'əs qıxha eyxhe. Mang'uk'le dixbışe İzrailybışik ha'anbıd, Allahne muq'addasne çadırne ghalee iş haa'ane yadaaşika manbı g'alyabak'avad g'ayxhinniy. ");
INSERT INTO tkr_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Eliyee manbışik'le eyhen: – Şu ha'an hucoone? Zak'le gırgıne insanaaşikecad, şu ha'ane karaı'dəəne işbışdecad hək'ee g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Yizın dixbı, vuşun ç'əv! Zak'le Rəbbine milletıke g'avxhuna mana xabar yugna deşub. ");
INSERT INTO tkr_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Sa insanee menne insanne ögee bınah hav'ee, mang'ul-alla merıng'vee Allahıs düə haa'as vooxhe. İnsanee Rəbbis pisın he'eene, şavussene mang'ul-alla düə haa'as vəəxə? Rəbbee manbı gyapt'as vuxhayke, manbışe dekkıl k'ırıcad iliyxhe ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","K'ınna Şamuelymee xər qexhe ıxha. Mana Rəbbisır insanaaşisır geer ıkkan ıxha. ");
INSERT INTO tkr_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Mane gahıl sa Allahna insan Eliysqa arı, mang'uk'le eyhen: – Rəbbee inəxüdud eyhe: «Yiğna dekkiy cuna nasıl Misirnang'a, fironne xalq'ıs nukariyvalla haa'ang'a, nya'a, Zı manbışis gyagu dişdiy? ");
INSERT INTO tkr_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","İzrailyne gırgıne nasılbışde yı'q'neençe yiğne dekkına nasıl Zı Zas kaahinar vuxhecenva g'əvxü. Zı manbışik'le uvhuynniy, Zas q'urbanbı alle'e, ətirbı gyooxhan he'e, Yizde ögeeyib ileylığ qı'ı iviykre. İzrailybışe adıyn gırgın q'urbanbı Zı yiğne dekkıne xizanısniy huvu. ");
INSERT INTO tkr_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Nya'a şu nişil-allane Yizde xaaqa Zasva Zı əmr hav'u allya'an q'urbanbıyiy Zas ıkkeekan karbı g'eliqqa hele? Nişil-allane ğu yiğın dixbı Zale ooqa avqaaqqa? Şu Yizde milletın İzrailin, Zas adıyne karbışin inekke yugun cigabı otxhun kokeebaxhenbı.» ");
INSERT INTO tkr_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Mançil-allad İzrailyne Allahee Rəbbee invavud eyhe: «Zı şenke cuvabniy huvu, yiğneyiy yiğne dekkıne xizanın Zas gırgıne gahbışilycab g'ullux haa'asva.» Həşdemee Rəbbee eyhe vod: «De'eş, Zı məxüd ha'as deş. Zı şavaayiy axtı qa'a, Zı mana axtı qa'as. Şavaayiy Zı g'eliqqa huvu, Zı məxrına uleke alişşes. ");
INSERT INTO tkr_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Gah qavaalesda, Zı yiğne xizanneb xılençe guc g'avşesda. Yiğne xizanıkene şavaacabıb xıliyna ı'mı'r haa'as deş. ");
INSERT INTO tkr_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Vak'le Yizde xaalqa ablesda ver g'avcesda. Yic İzrailik'le yugun yiğbı g'ece ıxheeyid, yiğne xizanıkene şavaacab xıliyna ı'mı'r haa'as deş. ");
INSERT INTO tkr_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Zı yiğne xizanınbı Zas q'urbanbı allya'ane cigaysse gırgınbı deş g'ee'epşes. Manbışin uleppı nağın gyatsts'ı, yik'bıd ık'arın aqqı ixhes. Yiğne xizaneençene gırgıng'veecab cit'ana ı'mı'r hav'u hapt'as. ");
INSERT INTO tkr_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Yiğne q'öne dixene, Xofniyiy Pinxasne, vuk'lelqa qalesın yiğnemee işaarat ixhes: manbı sa yiğıl, sacigee hapt'as. ");
INSERT INTO tkr_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Zımee, Zas ıkkananbıyiy Yizde yik'eedınbı gırgıne gahbışil ha'ana, Zasda sa yugna kaahin g'əxəs. Zı mang'una xizan havaacesda, mang'veeyib Zı g'əyxı'yne paççahne ögiyl k'ılyvalla haa'as. ");
INSERT INTO tkr_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Yiğne xizanıke üç'übba avxuynbımee, sa sık'ınin nuk'rayiy gıney heqqasva mang'usqa abı, mang'une ögiyl k'yoozarasınbı, „hucoona ixhes, sa ghalene gıneynemee, zas nena vuxhay kaahinaaşina iş hevleva“». ");
INSERT INTO tkr_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Mek'vne Şamuelee, Eliyne k'ane Rəbbis k'ılyvalla ha'a vuxha. Mane gahbışil Rəbbin cuvabıy gyaguybı zarada-zarada eyxhenbı deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Sa xəmde Eliy cune tyulee g'alirxhu ıxha. Mang'une uleppışik'le yugda g'ece ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Şamuelymee Rəbbine xaa g'alirxhu eyxhe. Allahna q'utyeb mane xaa vuxha. Maana Allahna bazirıb k'əpq'ı' vuxha deş. ");
INSERT INTO tkr_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Rəbbee Şamuelilqa ona'a, mang'veeyir «İnyaa vorva» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Qiyğar Eliyne k'anyaqa g'adarxhun «Zalqa onuiynne, zı inyaa vorva» uvhu. Eliyeemee «Zı onu'u deş, hoora g'alixheva» eyhe. Şamuelir ark'ın g'ılexhana. ");
INSERT INTO tkr_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Rəbbee «Şamuelyva» meed ona'an. Şamuel meer oza qıxha Eliyne k'anyaqa ark'ın «Zalqa onuiynne? Zı inyaa vorva!» eyhe. Eliyee «Zı onu'u deş. Dix, hoora g'alixheva» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Şamuelik'le manke Rəbb ats'a deşdiy, Rəbbee mang'us cuvabıd aaqı deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Rəbbee xhebe'es Şamuelilqa onu'umee, mana tyuleençe suğotsu Eliyne k'anyaqa ark'ın, eyhen: – Ğu zalqa onu'uva, zı inyaa vor. Manke Eliylqa hiyxharan, mek'vne Şamuelilqa onu'una Rəbb ıxhava. ");
INSERT INTO tkr_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Mançil-allad Şamuelik'le eyhen: – Hoora g'alixhe, meed valqa one'ee, inəxüd eyhe: «Yuşan he'e, ya Rəbb, Yiğne g'ulee k'ırı iliyxhe vod.» Şamuelir ark'ın, cune tyuleeqa k'eç'ena. ");
INSERT INTO tkr_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Rəbb arı maa'ar ulyorzul şene ögiylin xhinne «Şamuel! Şamuelyva!» ona'anan. Şamuelee eyhen: – Yuşan he'e, ya Rəbb, Yiğne g'ulee k'ırı iliyxhe vod. ");
INSERT INTO tkr_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Rəbbee Şamuelik'le inəxüd eyhe: – Zı İzrailil məxbına iş g'avces, g'ayxhiyng'un k'ırı g'avayghas. ");
INSERT INTO tkr_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Mane yiğıl, Eliyne xizanne hək'ee uvhuyn gırgın, Zı q'omançe k'anyaqqamee ha'asın. ");
INSERT INTO tkr_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Zı cuk'le uvhuynniy, cuk'le ats'ane bınahbışil-alla Zı cune xizanıs gırgıne gahbışisda cazaa hevles. Mang'une dixbışe Zı g'eliqqa huvu. Eliyeemee manbışin ögü ı'xı' deş. ");
INSERT INTO tkr_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Zı mançil-allad Eliyne xizanıs k'ınniy g'assır: Eliyne xizanne bınahıle q'urbanıkayiy menne-menne ıkekkane karbışika ılyheç'es deş. ");
INSERT INTO tkr_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Şamuel miç'eerilqamee g'ılexhana, qiyğar oza qıxha Rəbbine xaan akkabı aaqa. Mana cus Allahee gyagu'iyn kar Eliys yuşan ha'as qəyq'ənna. ");
INSERT INTO tkr_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Eliyeemee mang'ulqa onu'u eyhen: – Şamuel, yizda dix. Şamueleeyid «Zı inyaa vorva» mang'us alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Eliyee mang'uke qiyghanan: – Rəbbee vak'le hucoovana uvhu? Hucoona ixhes, man zale dyugul hıma'a. Allahee vak'le uvhuynçin, ğu zale saxheeyid dyugul he'ee, hasre Mang'vee vak divan qaqqecen. ");
INSERT INTO tkr_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Şamuelee mang'us gırgın yuşan ha'an, vuççud dyugul ha'a deş. Eliyeeme eyhen: – Mana Rəbb vorna, hasre Cus nəxüdiy ıkkan həməxüdud he'ecen. ");
INSERT INTO tkr_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Şamuel xər qexhe. Rəbb mang'uka ıxha, Rəbbee Şamuelik'le uvhuyn gırgın kar eyxhen. ");
INSERT INTO tkr_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Rəbbee Şamuelike hək'erar peyğambar hı'iy, gırgıne İzrailik'lecad Danile Beer-Şevalqamee ats'axhxhen. ");
INSERT INTO tkr_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Rəbb meer Şiloyee gyagva giyğal. Mang'vee Cune cuvabıka Vucecar Vuc Şamuelik'le hagva. ");
INSERT INTO tkr_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Şamuelin cuvab gırgıne İzrailis ıxha. Mane gahıl İzrailybı, Filiştinaaşika saç'ivkasva qığeebaç'e. İzrailybışe con çadırbı Even-Ezeree, Filiştinaaşeme Afeqee giyxə. ");
INSERT INTO tkr_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Filiştinarıb İzrailybışika saç'ivkasva giviyk'ananbı. Mane dəv'ee Filiştinar İzrailyaaşile ğameebaxhenbı. Maa'ar İzrailyaaşike yoq'ud aazır insan qek'a. ");
INSERT INTO tkr_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Millet çadırbı gı'xı'yne cigeeqa siyk'almee, İzrailyne ağsaqqalaaşe sana-sang'uke qiyghanan: – Nya'asdiyxan Rəbbee şi g'iyna Filiştinaaşis avub avxav'u? Qudoora, Rəbbika mugaavilenana q'utye Şiloyeençe şasqa qavaales. Hasre mana şaka vuxhecen, şinab duşmanaaşine xılençe g'attivxhan hee'ecen. ");
INSERT INTO tkr_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Milletın Şiloyeeqa insanar g'uxoole. Manbışe Rəbbika mugaavilenana q'utye qavayle. (Mane q'utyel oo keruvar ıxha. Mane keruvaaşe Xəəne G'oşunbışde Rəbbina taxt avqu vuxha.) Eliyna q'öyre dix, Xofniyiy Pinxasıb, Allahıka mugaavilenane q'utyeyne k'ane vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Rəbbika mugaavilenana q'utye co çadırbı g'ı'xı'yne cigeeqa qabı hipxhırmee, İzrailybışe məxdın ç'ak'ın ts'irbı ha'a, mançike dyunye ı'ğiykar. ");
INSERT INTO tkr_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Filiştinaaşik'le maana ts'ir g'avxhumee, eyhen: – Cühüt'yarnane cigeena mana ts'ir nəxbınaniyxan? Manbınane çadırbışeeqa Rəbbina q'utye qabıva ats'axhxhamee, ");
INSERT INTO tkr_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Filiştinar qəpq'ı'n eyhen: – Çadırbışeeqa allahaarıb abı, şalqa ver ables! Həşdilqamee məxdın kar ıxhayncad deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Şalqa ver ables! Şavaane şi Mane gucnane allahaaşine xılençe g'attivxhanaa'as? Sahree, Misirbışde vuk'lelqa cos ıkkanan verbı exan allahar inbı vob. ");
INSERT INTO tkr_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Filiştinar, yik'eka vuxhe, qı'məəq'ən! Deşxheene, cühüt'yar vuşun həmbalar vuxhaynbı xhinne, şunab manbışin həmbalar vuxhes. Adameer xhinne vuxhe, saç'uvke! ");
INSERT INTO tkr_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Filiştinar yugba saç'uvku, İzrailybı avub avxu, cone çadırbışeeqa heebaxa. Mane yiğıl geed xəppa insanar hapt'ı. İzrailybışda maa'ar xhebts'al aazır (30 000) insan qik'u. ");
INSERT INTO tkr_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Allahna q'utye xılelqa alğaaha, Eliyna q'öyursana dix Xofniyiy Pinxasıb maa'ab habat'anbı. ");
INSERT INTO tkr_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Mane yiğılycar Benyaminne nasılena sa insan dəv'eençe hixu Şiloyeeqa qarayle. Mang'vee culyun tanalinbı qıt'axxı'ı, vuk'lelqab colqa ver abıva nyaq'v k'yaa'a. ");
INSERT INTO tkr_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Mana qööne gahıl, Eliy yəqqı'ne mıglek gyu'ur ilyakka ıxha. Mang'un Allahne q'utyeyneme yik' əə ıxha. Mana insan şahareeqa ikkeç'u cok ıxhaynbı yuşan hı'ımee, şaharıke ts'ir g'oottal. ");
INSERT INTO tkr_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Eliyk'le man ses g'ayxhımee, «Mana nəxbına ts'irneva?» mang'vee qiyghanan. Mana insan zaara Eliysqa qarı, mang'us gırgın yuşan ha'an. ");
INSERT INTO tkr_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Mane gahıl Eliyqa yüç'əle molyulle (98) sen eyxhe, mang'un uleppıd aqqı ıxha, vuççud g'ece ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Mane insanee Eliyk'le eyhen: – Zı dəv'ənane cigeençe qöö vor. Dəv'eençe zı g'iyna hixu. Eliyee qiyghanan: – Dix, hucoon ıxha? ");
INSERT INTO tkr_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Mana xabar abıyne insanee eyhen: – İzrailybı Filiştinaaşde ögiyle heepxıynbı, geeb insanar hapt'ı. Yiğın dixbı Xofniyiy Pinxas q'öyursana hapt'ıynbı. Allahna q'utyeb şenbışde xılyaqa ılğevç'u. ");
INSERT INTO tkr_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Mana insan Allahne q'utyeyne hək'ee yuşan ha'amee, Eliy şaharne akkabışisne gyu'urne cigeençe yı'q'əlqa hı'ğəykar. Mana q'əsrayiy yı'q'ra ıxhayke, mang'una gardan hapq'ır qek'ana. Mana yoq'ts'al (40) senna İzrailybışda haakim ıxha. ");
INSERT INTO tkr_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Eliyna sos, Pinxasna xhunaşşe vuxhne yixha. Məng'ı'na uxasda gahıb qabı hıpxhırniy vob. Allahna q'utye mebınbışde xılyaqa ılğevç'u, abbatteyiy adamiyıb hapt'ıynbıva məng'ı'k'le g'ayxhımee, məng'ı's sayangada ık'arbı qayle, məng'ee k'yorzul uxooxan. ");
INSERT INTO tkr_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Mana qeek'ang'a, məng'ı's kumag ha'ane zəiyfabışe eyhen: – Qı'meeq'ən, vas dix ıxha. Məng'ee şavuscad alidghıniyıd qele deş, nişikacarır sark'ıl ileeka deş. ");
INSERT INTO tkr_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Məng'ee «Nur İzrailike apk'ınnava» uvhu, uşaxın do İkavod (nur deşda) giyxhe. Məxüd məng'ee Allahna q'utye merıng'une xılyaqa ılğevç'uva, abbatteyiy adamiyıb hapt'ıva ha'a. ");
INSERT INTO tkr_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Məng'eecad meed eyhen: – Allahna q'utye merıng'une xılyaqa ılğevç'uva İzrailike nurub apk'ınna. ");
INSERT INTO tkr_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Filiştinaaşe Allahna q'utye cone xılyaqa alğavhu, mana Even-Ezerğançe Aşdod eyhene şahareeqa quvkekka. ");
INSERT INTO tkr_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Allahna q'utye Dagonna byutnane xaaqa quvku, mang'une byuttyune k'anyaqa giviyxhe. ");
INSERT INTO tkr_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Qinne yiğıl miç'eeb Aşdodğançenbı oza qeepxhayng'a, Dagonna byut Rəbbine q'utyeyne ögiyl aq'vakkena quvxha g'ooce. Manbışe Dagonun byut alyaat'u, cine cigeeqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Qinne yiğıl miç'eeb manbı oza qeepxhayng'a, meeb Dagonna byut Rəbbine q'utyeyne ögiyl aq'vakkena quvxha g'ooce. İne yəqqees, Dagonna vuk'uliy q'öyudsana xıl gyatxhı akkayne ghaleeqa gixhxhı eyxhe. Mang'un saccu candakcad axu eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Mançil-allad g'iyniyne yiğılqamee Dagonne kaahinaaşed, Aşdodeene Dagonne xaaqa vüqqənbışed akkayne ghaleeqa g'el giyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Rəbbin xıl Aşdodğançenbışde oo yı'q' qexhe. Manbışilqayiy hiqiy-allanbışilqa verbı allya'a, tanbışik fırar qığa'a. ");
INSERT INTO tkr_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Aşdodğançenbışik'le eyxhenbı g'acumee, eyhen: – İzrailyne Allahna q'utye inyaa, şasnee vuxhes vukkan deş, Mang'un xıl şaliy yişde allahne Dagonne oo yı'q' qıxha. ");
INSERT INTO tkr_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Manbışe gırgın Filiştinaaşin ç'ak'ınbı sav'u, manbışike qiyghanan: – İzrailyne Allahne q'utyeyk şi hucoona ha'as? Filiştinaaşine ç'ak'ınbışe eyhen: – Hasre İzrailyne Allahna q'utye Gateeqa quvkeecen. Məxüd ıxha İzrailyne Allahna q'utye Gat eyhene şahareeqa quvkekka. ");
INSERT INTO tkr_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Manbışe q'utye Gatqa qabiyle qiyğa Rəbbina xıl mane şaharıl oo yı'q' qooxhe. Mane şahareebın insanar məxüb qəvəyq'ən giviyğal, manbışin yik'bı qodasınçil qeedaxhe. Rəbbee mane şaharın insanar xərıng'ule otçu, k'ıning'ulqamee fıraaşika gyavts'yaa'a. ");
INSERT INTO tkr_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Manbışe mançile qiyğa Allahna q'utye Ekron eyhene şahareeqa g'uxoole. Allahna q'utye Ekronqa qabı hipxhırmee, maane insanaaşe ts'irbı ha'a: – Şiyiy yişin millet gyapt'asdemee, manbışe İzrailyne Allahna q'utye şasqa qabı! ");
INSERT INTO tkr_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Mançil-allab manbışe gırgın Filiştinaaşin ç'ak'ınbı sav'u eyhen: – İzrailyne Allahna q'utye yəqqı'l hee'e huvooracen. Hasre şakıniy yişde milletıkın mexhecen. Mane şahareebın gırgın insanar məxüb qəvəyq'ən giviyğal, manbışin yik'bı qodu-hapt'asınçil qeebaxhe. Rəbbin xıl manbışil oo geed yı'q'da ıxha. ");
INSERT INTO tkr_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Hidyapt'ı üç'übba avxuynbışin tanbı fıraaşika gyayts'e, mane şahareebınbışe haa'an ts'irarıd xəybışeeqa hiyxhar ıxha. ");
INSERT INTO tkr_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Rəbbina q'utye Filiştinaaşine cigabışee yighıble vazna avxu. ");
INSERT INTO tkr_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Filiştinaaşe kaahinariy falıka ilyaakanbı qopt'ul eyhen: – İne Rəbbine q'utyeyk hucoona ha'as? Şak'le eyhe, şi nəxübiy mana çine cigeeqa savaak'al haa'as? ");
INSERT INTO tkr_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Manbışe eyhen: – İzrailyne Allahna q'utye yı'q'əlqa savaak'al haa'as vukkanxhee, mana q'ərab savaak'al hımaa'a. Şu mançinemee, taxsir şolyva Rəbbis pay haa'as vukkan. Mane gahıl şunab yug qeepxhesınbı, Mang'vee şoke nya'asiy xıl ts'ıts'dyaa'avad, ats'axhxhesın. ");
INSERT INTO tkr_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Filiştinaaşe qiyghanan: – Şal taxsirva nena payne Rəbbis haa'as vukkan? Kaahinaaşeyiy falıka ilyaakanbışe eyhen: – Filiştinaaşika xhuleyre xərnayiy, hamanimen k'ınəəğəykena fıriy q'öv hav'u g'axuvle. Mana ver vuşdecab deş, vuşde ç'ak'ınbışdeb vuk'lelqa qabına. ");
INSERT INTO tkr_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Mançil-alla fıraaşinıd, vuşda ölka q'əra qaa'ane q'övəəşinıd k'opyebı he'e, İzrailyne Allahısıb hı'rmat givxhe. Sayid manke, Mang'vee şokeb, vuşde allahaaşileb, vuşde cigabışileb xıl ts'ıts'aa'a. ");
INSERT INTO tkr_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Misirbışeyiy fironee q'ı't'y k'eççuyn xhinne, şunad hıma'a. Allah manbışilqa rəhı'm dena qıxhamee, manbışe İzrailybı g'avkkuynbı. ");
INSERT INTO tkr_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Həşdemee sa ts'edın daşk'a hı'ı, mançik mısacab xamut qidyav'una q'ıkar gyooqa'ana q'öble zer avt'le. Q'ıkarmee mançike curu'u xaaqa qıkkee. ");
INSERT INTO tkr_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Rəbbina q'utyeb alyapt'ı daşk'eeqa gyuvxhe, taxsir şolyva Mang'us allesın k'ınəəğəyken karbıd mançine k'anene yeşuk'eeqa gixhxhe. Qiyğaled daşk'a yəqqı'l hee'e hooracen. ");
INSERT INTO tkr_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Yı'q'əle saccu ilyaake. Man çine cigeeqa, Bet-Şemeşne suralqa atk'ınee, mana ver şalqa ooxuna Rəbb vornava eyhen vodun. Maqa idyapk'ıneeme, şak'le ats'axhxhesın, şas ı'xı'yn xıl Mang'un deşud. Man çiled-alqa ıxhayn kar vodun. ");
INSERT INTO tkr_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Nəxüdiy uvhu, insanaaşe məxüdud ha'an. Q'öble zer qabı daşk'ayk iviyt'al, mançin q'ıkarıd xaa g'alya'a. ");
INSERT INTO tkr_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Daşk'eeqa Rəbbine q'utyeyka sacigee, manbışe k'ınəəğəyke hı'iyn q'övərnanayiy fırarnana yeşuk giviyxhe. ");
INSERT INTO tkr_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Mançile qiyğa zerbı qotkuda ayk'ananbı Bet-Şemeşne suralqa. Manbı sağılqa, solulqa siditk'ıl, sa yəq avqu, heğa-heğa ayk'ananbı. Filiştinaaşin ç'ak'ınbı mançiqab qihna Bet-Şemeş giviyğalne cigeeqamee avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Mane gahıl Bet-Şemeşğançenbı suk qiviyşal çolee vooxhe. Manbı q'utye g'avcu şadeebaxhenbı. ");
INSERT INTO tkr_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Daşk'a Bet-Şemeşğançene Yeşuayne çoleeqa qadı, sa xənne g'ayeyne k'ane ulyoyzaran. İnsanaaşe daşk'a haq'var hı'ı mançike osbı ha'a. Zerbışiked, Rəbbis gyooxhan haa'ana q'urban ablyaa'a. ");
INSERT INTO tkr_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","Leviyne nasıleençene insanaaşe Rəbbina q'utye, k'ınəəğəyke hı'iyn q'övəriy fırar sı'ına yeşuk'ub daşk'eençe gyaqqı, sa xənne g'ayel ooqa giyxhe. Mane yiğıl Bet-Şemeşğançenbışe Rəbbis gyooxhan haa'ane q'urbanıle ğayrı, medın q'urbanbıd gyaat'anbı. ");
INSERT INTO tkr_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Filiştinaaşine maqa abıyne xhone xərıng'uk'le man g'acu, mane yiğılycab Ekronqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Filiştinaaşe taxsir colyva Aşdod eyhene şaharne doyule, Gəzzə eyhene şaharne doyule, Aşkelon eyhene şaharne doyule, Gat eyhene şaharne doyule, Ekron eyhene şaharne doyule Rəbbis k'ınəəğəyke hı'iyn fırar adayle. ");
INSERT INTO tkr_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","K'ınəəğəyke hı'iyn q'övərmee, hiqiy-alla cabırbışikane şaharbışisiy çine hiqiy-allane xivaaşis sik'ı adayle. Mane şaharbışiqa xhoyre xərna ıxha. Bet-Şemeşğane Yeşuayne çoleena, Rəbbina q'utye gyuvxhuna xəbna g'aye giyniyne yiğılqamee avxu vob. ");
INSERT INTO tkr_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Rəbbine q'utyeyne aq'a ilyaakıva, Allahee Bet-Şemeşğançenbışde vuk'lelqa ver ooxa. Rəbbee manbışda yights'al (70) insan gek'a. Milletıd, Rəbbee cone vuk'lelqa ooxune verır-alla geşşe ıxha. ");
INSERT INTO tkr_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Bet-Şemeşğançenbışe eyhen: – İne muq'addasne Allahne, Rəbbine ögiyl şavusse ulyozaras əxəye? Nyaqane ina q'utye quvkees? ");
INSERT INTO tkr_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Qiyğa manbışe Kiryat-Yearim eyhene şaharne milletısqa xabar ana insanar g'axuvu, eyhen: – Filiştinaaşe Rəbbina q'utye yı'q'əlqa savaak'al hav'u, able mana quvkee. ");
INSERT INTO tkr_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Kiryat-Yearimne milletın abı Rəbbina q'utye quvkekkana. Manbışe mana tepalyne Avinadavne xaaqa alqavhu, çine k'anyaqar mang'una dix Eleazar ulyozar ha'a. ");
INSERT INTO tkr_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Q'utye Kiryat-Yearimeeqa qabıyne yiğıle geeb vaxt ulğooç'e: g'alle (20) sen g'ayts'e. İzrailin milletcad geşşe eyxhe, manbışe Rəbb t'abal ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Şamuelee İzrailyne milletık'lecad eyhen: – Şu yik'eençe Rəbbilqa siviyk'alxhee, mebın allahar, Aştoret donan byuttyar dağe'e. Vuşun yik'bı Rəbbis hele, saccu Mang'us ı'bəədat he'e. Manke Mang'vee şu, Filiştinaaşine xılençe g'attivxhan haa'asınbı. ");
INSERT INTO tkr_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Mane gahıl İzrailybışee, Ba'aliy Aştoret donan byutbı dağı'ı, saccu Rəbbis ı'bəədat ha'a giviyğal. ");
INSERT INTO tkr_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Şamuelee eyhen: – Gırgın İzrailybı Mispa eyhene şahareeqa see'e, zı şol-alla Rəbbis miz k'yaa'as. ");
INSERT INTO tkr_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Manbı Mispeeqa sabı, xhyan alqavhu Rəbbine ögiylqa k'ya'a. Mane yiğıl manbışe sivar aqqı eyhen: – Şi Rəbbine ögiyl bınah hav'u. Şamuelee Mispee İzrailybışis haakimiyvallaniy haa'a. ");
INSERT INTO tkr_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","İzrailybı Mispeeqa sabıva Filiştinaaşik'le g'ayxhımee, manbışin ç'ak'ınbı İzrailybışilqa vüqqə giviyğal. Man g'ayxhıyn İzrailybı qəvəyq'ənanbı. ");
INSERT INTO tkr_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Mançil-allad manbışe Şamuelik'le eyhen: – Şi Filiştinaaşine xılençe g'attivxhan haa'asdemee, Rəbbilqa, yişde Allahılqa, hınva ehesse, miz k'ee'e. ");
INSERT INTO tkr_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Manke Şamuelee gyooqana urg alyapt'ı, mançike Rəbbis gyooxhan haa'ana q'urban ablyaa'a. Şamuelee İzrailynemee Rəbbis miz k'yaa'a, Rəbbeeyid mang'us alidghıniy qelen. ");
INSERT INTO tkr_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Şamuelee gyooxhan haa'ana q'urban ablyaa'amee, Filiştinar İzraililqa k'yooharasva k'ane qeepxha vooxhe. Rəbbee mane yiğıl Filiştinaaşilqa məxüd man xəybı xənne seseka g'əhədəqqə'ə, manbı mançile curaybacab qəpq'ı'n İzrailybışile avub aaxva. ");
INSERT INTO tkr_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","İzrailybı Mispeençe qığeepç'ı, Bet-Qarne cigabışeeqa qabı hivxharasmee, Filiştinaaşiqab qihna gyapk'ı, manbı gyabat'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Şamuelee sa g'aye alyapt'ı Mispayneyiy Şenne yı'q'neeqa giviyxhe. Qiyğad «Rəbbee şas inyaqamee kumag hı'ıva» uvhu, mane g'ayeyn do Even-Ezer (kumagna g'aye) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Maa'ab avub avxuyn Filiştinar sayıb İzrailyne cigabışeeqa abayle deş. Şamuel ıxhaylette, Rəbbin xıl Filiştinaaşil oğa yı'q'da ıxha. ");
INSERT INTO tkr_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Filiştinaaşe, Ekronneyiy Gatıne yı'q'ne aqqıyn İzrailybışin şaharbıyiy çine hiqiy-alladın cigabıd Filiştinaaşine xılençe g'ayşu, yı'q'əlqa sak'al ha'a. İzrailibışdeyiy Emorbışde əree sülyh eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Şamuelee ı'mı'rvollette İzrailis haakimiyvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Mana seniys Bet-Elyqa, Gilgaleeqa, Mispeeqa hark'ın maa İzrailybışis haakimiyvalla haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Qiyğar mana cune Ramayeene xaaqa siyk'al ıxha. Mançeb mang'vee İzrailis haakimiyvalla haa'a vuxha. Mang'vee mane cigee, Rəbbis q'urbanbı allya'an cigad ali'in. ");
INSERT INTO tkr_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Şamuel q'əs qıxhamee, dixbışike İzrailis haakimar haa'a. ");
INSERT INTO tkr_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Mang'une ts'erriyne dixen do Yoel, q'ör'esıng'unud Aviya ıxha. Manbışe Beer-Şevee haakimiyvalla haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Dixbı dekkıne yəqqı'n avayk'an deş. Manbı haramne pılıqab qihna gyabak'a, ruşvatbı alyaat'a, qotkuda deşin q'aralybı hele ıxha. ");
INSERT INTO tkr_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Gırgın İzrailin ağsaqqalar Ramayeeqa sabı, Şamuelyne k'anyaqa abı, ");
INSERT INTO tkr_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","mang'uk'le eyhen: – Ğu q'əs qıxha, yiğın dixbımee yiğne yəqqı'n əlyhəə deş. Həşdeme menne milletbışika nəxürnayiy, şasdar həməxürna sa paççah gixhxhe. Şas xəbvalla hee'ecen. ");
INSERT INTO tkr_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Manbışe: «Şasdar sa paççah gixhxhe, mang'vee şas xəbvalla hee'ecenva» uvhuyng'a, Şamuelis manbışe uvhuyn ıkkiykan deş. Mang'vee Rəbbis düə haa'a. ");
INSERT INTO tkr_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Rəbbee Şamuelik'le eyhen: – Milletın eyhene gırgınçil k'ırı alixhxhe. Manbışe ğu deş, Zı əq'əna qa'a. Manbışis Zı cona Paççah ıxha ıkkan deş. ");
INSERT INTO tkr_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Zı manbı Misirğançe qığav'uyne yiğıle, g'iyniyne yiğılqamee manbışe menne allahaaşis ı'bəədatbı hı'ı. Məxüb manbı Zake əq'əna qeepxha. Zak hı'iyn kar, manbışe həşded vak ha'a. ");
INSERT INTO tkr_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ğu manbışe eyhençil k'ırı alixhxhıyle qiyğa, ğu manbışilqa yugda hixhar he'e, cos xəbvalla haa'asde paççahee xəbvalla nəxübiy haa'as. ");
INSERT INTO tkr_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Şamuelee cuke paççah heqqane milletılqa, Rəbbee uvhuyn cuvab hixhar ha'an. ");
INSERT INTO tkr_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Mang'vee eyhen: – Şos xəbvalla haa'asde paççahee, xəbvalla inəxüb haa'as: mang'vee vuşun dixbı sav'u, quvkeesınbı. Dəv'əyne daşk'abışiliy balkanaaşil cus g'ullux haa'as alivkas. Manbıb mang'une daşk'abışde ögee g'adaaxhvanas. ");
INSERT INTO tkr_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Manbışde sanbışike aazırıng'us, sanbışikeb xhots'aling'us ç'ak'ınbı haa'as. Mansanbıb cun cigabı ezas, şagav sa'as g'axuvles. Avxuynbışisqad silahiy dəv'əyne daşk'abışis kara'alesın karbı ha'as alikkas. ");
INSERT INTO tkr_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Mang'vee vuşun yişbı ətirbıyiy otxhuniybı ha'as, gıneybı qecesva vukkees. ");
INSERT INTO tkr_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Mang'vee vuşun inekke yugun çolbıyiy t'ımıllığbı, zeytunun bağbı xılençe g'ayşu, cune insanaaşis heles. ");
INSERT INTO tkr_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Mang'vee vuşde sukukeyiy t'ımılike yits'ıb'esda pay alyapt'ı, məmuraaşisiy cune insanaaşis hevles. ");
INSERT INTO tkr_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Vuşun g'ular – adamer, yadar – vuşun mek'vunbı, vuşun əməlerıd çikana mang'vee cus alyaat'as. ");
INSERT INTO tkr_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Vuşde vəq'əbışda yits'ıb'esda pay mang'vee cus alyapt'as, şunab mang'un nukarar vuxhes. ");
INSERT INTO tkr_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Yiğ qalesın, şu g'əyxı'yne paççahne xılençe, Allahılqa şucad xıleppı aaqas, Mang'vee şu g'attivxhan hee'ecenva. Rəbbeemee mane gahıl şos cuvab qeles deş. ");
INSERT INTO tkr_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Milletısmee, Şamuelyne cuvabıl k'ırı alixhxhes diykkın, eyhen: – De'eş, şal oğa paççah ıxha şas ıkkan. ");
INSERT INTO tkr_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Havaasre menne milletbışis nəxübiy, şasıb paççahee xəbvalla hee'ecen. Dəv'ə gipxhımeeyib, yişde ögee hooracen. ");
INSERT INTO tkr_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Milletın eyhen gırgın yik'el aqqı, qiyğale man Şamuelee Rəbbis yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Rəbbee Şamuelik'le eyhen: – Manbışe eyhençil k'ırı alixhxhı, manbışis sa paççah gixhxhe. Manke Şamuelee İzrailybışik'le «Gırgınbı vuşde şaharbışeeqa savk'leva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Benyaminaaşiqa Giş donana sa insan ıxha. Mana Avielna dix ıxha. Avielir Tserorna dix ıxha. Tserorur Bekoratna dix ıxha. Bekoratır Afiahna dix ıxha. Mana Gişva eyhena insan geer qıvaats'ına ıxha. ");
INSERT INTO tkr_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Mane Gişiqar Şaulva donana sa mek'vna dix ıxha. İzrailybışiqa mana xhineena micagna merna deşdaniy. Mana cune milletınbışde gırgıng'ule sa ç'ümna axtıra ıxha. ");
INSERT INTO tkr_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Yiğbışde sa yiğıl Şaulyne dekkın Gişin əməler iygval. Gişee dixek'le Şauluk'le eyhen: – Oza qixhe, nukaraaşina sayır vaka alyart'u, əməler t'abal ha'as hak'ne. ");
INSERT INTO tkr_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Manayiy cuna nukar Efrayimıne suvabınane cigee iviykır, mançeb Şalişa eyhene cigeeqa ılğeebaç'e. Maa'ad manbışik'le əməler iveeke deş. Manbı mançe Şa'alim eyhene cigeeqab abaylenbı, maayid manbışik'le əməler iveeke deş. Mançile qiyğa manbı Benyaminaaşine cigabışeeqa qavayle, maayid manbışik'le əməler iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Manbı Tsufne cigabışeeqa qabı hipxhıriyng'a, Şaulee cukane nukarık'le eyhen: – Qora savk'alascab, dekkee əməler yik'el hixan hı'ı, həşde yişda haa'a giğalas. ");
INSERT INTO tkr_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Nukareeme mang'uk'le eyhen: – İne şaharee sa Allahna insan vorna. Mana geer hı'rmatnana insan vor, mang'vee hucooyiy uvhu, manıd eyxhen. Qoralan maqa vüqqəs, sayid mang'vee şak'le eyhe, nyaqayiy vüqqəs vukkanva. ");
INSERT INTO tkr_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Şaulee nukarıke qiyghanan: – Sayıb vüqqəs gyapk'ee, mang'us hucoona ıkkee'es? Yişde q'oç'ebışee oxhanasın karıd axu deş. Mane Allahne insanıs ıkkeesın karıd şaqa deşin. Hucoona şaqa vod? ");
INSERT INTO tkr_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Nukaree mang'us inəxdın alidghıniy qele: – Zaqa sık'ınin nuk'ra vod. Zı man Allahne insanıs heles, mang'veeyib şak'le yəq haagvasda. ");
INSERT INTO tkr_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(Avaala İzrailee Allahee nenvayiy eyheva ats'axhxhesdemee, inəxüd eyhe ıxha: «Qora, ilyaakang'une k'anyaqa vüqqəs». Mane gahıl peyğambaraaşik'le ilyaakanbıvaniyxhe eyhen.) ");
INSERT INTO tkr_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Şauleeme nukarık'le eyhen: – Vüqqəsva eyhexhee, qora vüqqəs. Məxüd ıxha, manbı Allahna insannane şahareeqa avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Manbı tepalyne şahareeqa ı'lqəəmee, yəqqə manbışisqa xhinelqa vüqqən içer qızaaxa. Manbışe içeeşike qiyghanan: – İnyaa ilyakkana vornane? ");
INSERT INTO tkr_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","İçeeşe manbışik'le eyhen: – Ho'o, şole ögee vor. Mana həşde şahareeqa arı, zaraba vuxhe. Milletın g'iyna q'urbanbı allya'ane cigee, q'urbanbı allya'as. ");
INSERT INTO tkr_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Şahareeqa ikkepç'ımee, mana kar oxhanas q'urbanbı allya'ane cigeeqa ılqeç'essecar t'abal he'e. Mana qidyarı milletın kar oxhanas deş. Mang'vee q'urbanıs xayir-düə huvuyle qiyğa qopt'uluynbı kar otxhan giviyğal. Zaraba ılqeepç'ee, mang'uqab qihna avaaq'arasınbı. ");
INSERT INTO tkr_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Manbı şahareeqa ılqeepç'ımee, manbışisqa Şamuel qızaxxa. Manar tepalyne q'urbanbı allya'ane cigeeqa ı'qqə ıxha. ");
INSERT INTO tkr_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Şaul ayresse sa yiğna ögee, Rəbbee Şamuelis man ats'axhxhı'ı, uvhuynniy: ");
INSERT INTO tkr_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","«G'iyqa ine gahbışil yiğne k'anyaqa Benyaminaaşine cigabışeençe sa insan g'axıles. Ğu mang'une vuk'lelqa q'ış qadğve. Məxür ğu mang'uke Yizde milletna İzrailyna xərna ha'as. Mang'vee Yizın millet Filiştinaaşde xılençe g'attixhan ha'as. Yizde milletne vuk'lelqa qadıyn Zak'le g'acuyn, manbışda ts'irıb Zalqa hipxhırna». ");
INSERT INTO tkr_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Şamuelik'le Şaul g'acumee, Rəbbee mang'uk'le eyhen: – Zı vak'le uvhuyne ine insanee, Yizın millet aqqas. ");
INSERT INTO tkr_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Şaulee şaharne akkabışisnee ulyorzulyne Şamuelisqa qıxha qiyghanan: – Hucoona ixhes, ilyaakang'un xav nyaa ıxhay zak'le hagvelan. ");
INSERT INTO tkr_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Şamuelee, Şauluk'le eyhen: – İlyakkana zı vorna, yizde ögiyl q'urbanbı gyaat'ane cigeeqa ılqeç'e. Şu g'iyna zaka sacigee kar oxhanas. G'iyqa miç'eedıd zı vak'le ats'axhxhes ıkkanan uvhu, yəqqı'l ha'asda. ");
INSERT INTO tkr_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Xhebılle yiğna ögee aguyne əməleeşinab hımaa'a, manbı aveykı vod. İzrailyne milletıncad yik'bı şavulqayiy sak'ı? Nya'a, valqayiy yiğne dekkıne xizanılqa dişeene? ");
INSERT INTO tkr_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Şaulee eyhen: – Nya'a, zı İzrailyne nasılbışde nekke k'ıninçeençe, Benyaminne nasıleençena dişde vor? Nya'a, yizda xizanıb, mane nasılene xizanbışda nekke k'ınna dişde vob? Nişisne ğu zak'le manva eyhe? ");
INSERT INTO tkr_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Şamuelee, Şaulıy mang'una nukar gozeeqa qabı, qopt'ulne xhebts'alilqa (30) ələəne insanne q'oma gyaa'a. ");
INSERT INTO tkr_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Şamuelee otxhuniy ha'ang'uk'le eyhen: – Zı vasqa curayda gixhxheva quvuyn çuru qale! ");
INSERT INTO tkr_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Otxhuniy ha'ang'vee guvu qadı, Şaulne ögiylqa giyxhe. Şamuelee eyhen: – İna vasva curav'una pay vob. Oxhne, in yiğnimeeniy curu'u, qopt'ulne mihmanaaşika sacigee ğu oxhnecenva. Mane yiğıl Şaulee, Şamuelika sacigee kar oyxhan. ");
INSERT INTO tkr_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Manbı q'urbanbı allya'ane cigeençe şahareeqa geepç'ımee, Şamuelee Şaulıka gaf cune xaane daxal haa'a. ");
INSERT INTO tkr_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Manbı miç'eeb oza qeebaxhenbı. Çakdacad, Şamuelee daxalyne Şaululqa onu'u eyhen: – Oza qixhe, zı ğu yəqqı'l arçes. Manar oza qıxha, Şamuelika sacigee xaançe g'aqa qığeç'e. ");
INSERT INTO tkr_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Manbı şaharne mıgleqqa geepç'ımee, Şamuelee Şauluk'le eyhen: – Nukarık'le eyhe, şale ögee hooracen. Nukarır ılğeç'ena ögiylqa. Şamueleecad meed eyhen: – Ğu ulyozre, zı valqa Allahın cuvab hixhar ha'as. ");
INSERT INTO tkr_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Şamuelee zeytunun q'ışnan g'ab alyaat'u, Şaulne vuk'lelqa k'yı'ı, mang'us ubba hı'ı eyhen: – Rəbbee zak'le valqa q'ış qadğveva uvhu, məxür ğu İzrailyna, Cune milletna, xərna hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","G'iyna ğu zake curxhayle qiyğa, Benyaminaaşine cigabışee, Tselytsax eyhene şahareene Raahileyne nyuq'vnesne vasqa q'öyre insan qızaaxas. Manbışe vak'le eyhesın: «Ğu t'abala'asva hark'ıniyn əməler aveykıynbı. Yiğne dekkısse əməler yik'el hitxın, həşde yiğna haa'a girğıl: „Yizde dixek hucooniyxan ıxha?“» ");
INSERT INTO tkr_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Mançer ğu Tavoreene mı'qəne yivusqa qales. Maa'ab vasqa xhebiyre Bet-Eleeqa Allahıs ı'bəədatıs vüqəən adamer qızaaxas. Manbışde sang'usnee xheyible mısva, mansang'usnee xheyible gıney, xhebır'esıng'usneeme sa tuluğ çaxıren ixhes. ");
INSERT INTO tkr_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Manbışe vas salam huvu, q'öble gıney hevles. Ğunad alyaat'asınbı. ");
INSERT INTO tkr_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Mançile qiyğa ğu əlyhəəsda Allahne Givea ehene şahareeqa, maa'ab Filiştinaaşin eskerar vuxhes. Şahareeqa ıkkəəmee, vasqa q'urbanbı allya'ane cigeençe gəən peyğambarar qızaaxas. Manbışe maa'ab arfa, dyaf, zurna, lira əlüvxəs. Coyib peyğambariyvalla haa'as. ");
INSERT INTO tkr_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Manke Rəbbin Rı'h valqa giç'es, ğunab manbışika sacigee peyğambariyvalla haa'as. Vake maa sa mernacar insan qıxhes. ");
INSERT INTO tkr_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Man gırgın əlaamatbı ıxhamee, ğu ha'asın kar he'e. Allahır vaka ixhes. ");
INSERT INTO tkr_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Zale ögee Gilgaleeqa giç'e. Zınar gyoxhxhan ha'an q'urbanbıyiy medın q'urbanbı allya'asva maqa giç'es. Zı maqa qalesmee, yighılle yiğna maa'ar axve. Zı vak'le hucooyiy ha'as ıkkanva eyhesmee, vuççud hıma'a. ");
INSERT INTO tkr_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Şaul Şamuelisse xaaqa sak'ımee, Allahee mang'un yik' badal ha'a. Man gırgın əlaamatbıd mane yiğılycad eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Manbı Giveayeeqa qabımee, manbışisqa peyğambarar qızaaxa. Maa'ad Allahın Rı'h Şaululqa geç'e, Şauleeyib manbışika sacigee peyğambariyvalla haa'a giyğal. ");
INSERT INTO tkr_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Mana şenkecar ats'anbışik'le, mang'vee peyğambariyvalla haa'a g'avcumee, sana-sang'uk'le eyhen: – Gişine dixek hucooniyxan ıxha? Nya'a, Şaulur peyğambaraaşinane vor? ");
INSERT INTO tkr_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Maa eyxhene insanaaşine sang'vee eyhen: – İlyaakende, manbışin dekkar sa nəxbıncab insanaare? Mankiyle axuyn vod: «Şaulukerne peyğambar ıxha?» eyhen. ");
INSERT INTO tkr_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Şaulee peyğambariyvalla hav'uyle qiyğa, q'urbanbı allya'ane cigeeqa ılqeç'u. ");
INSERT INTO tkr_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Şaulne emisee, mang'ukeyiy mang'une nukarıke qiyghanan: – Nyaqaniy hapk'ın? Şaulee eyhen: – Əməler t'abal ha'asniy hapk'ın, ivdeeke g'acumee, Şamuelyne k'anyaqa hapk'ın. ");
INSERT INTO tkr_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Şaulne emisee eyhen: – Hucoona ixhes, Şamuelee şok'le uvhuyn zas yuşan he'e. ");
INSERT INTO tkr_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Şaulee emisiyk'le eyhen: – Mang'vee şak'le əməler aveykiynbıva uvhu. Paççahiyvaline hək'ee Şamuelee hucoovayiy uvhuva, mang'vee emisiysne ağmişcad ha'a deş. ");
INSERT INTO tkr_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Şamuelee İzrailybı Rəbbine ögiylqa, Mispeeqa sav'u, ");
INSERT INTO tkr_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","eyhen: – Rəbbee, İzrailyne Allahee, inva vod eyhe: «Zı İzrailybı Misirğançe qığav'u. Misirbışdeyiy menne şos xəbvalla haa'ane, əq'üba hoolene paççahaaşine xılençe Zı şu g'attivxhan hav'u. ");
INSERT INTO tkr_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Şu manimeene dağamiyvalybışike, əq'übabışike g'attivxhan hav'une Allahılqa şu g'iyna yı'q'bı sak'al ha'a. Şu Mang'uk'le „De'eş, şas paççah gixhxheva“ eyhe. Həşdemee Rəbbine ögee nasılbışis, xizanbışis sik'ı ulyoozre». ");
INSERT INTO tkr_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Şamuelee İzrailin gırgın nasılbı, sassadna ögeeqa qığı'ı çöp k'eççu. Çöp Benyaminne nasılılqa gitxhu. ");
INSERT INTO tkr_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Qiyğad Benyaminne nasılen xizanbı sassadna ögeeqa qığı'ı çöp k'eççu. Çöp Matriyne xizanılqa gitxhu. Matriyne xizanınbışik'led sassabna ögeeqa qığeepç'eva eyhe. Manbışiker Gişna dix Şaul çöp k'eççu, g'əxə. Şaul t'abal ha'a gibğılmee, mana iveeke deş. ");
INSERT INTO tkr_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Manke manbışe Rəbbike qiyghan: – Mana inyaqa qarı dişde? Rəbbee eyhen: – Hooşe, yukbışde yı'q'nee dyugulyxha. ");
INSERT INTO tkr_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Manbı maqa g'adapxhın, Şaul ana qavaylenbı. Şaul milletne yı'q'nee ulyorzuling'a, mana gırgıng'ule sa ç'ümna axtıra ıxha. ");
INSERT INTO tkr_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Şamuelee eyhen: – Rəbbee g'əyxı'na insan, şok'le g'eceyee? Milletne yı'q'nee mang'uk akarna sacar deşda. Milletın ts'irıka eyhen: – Paççah geer qa'ana! ");
INSERT INTO tkr_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Şamuelee milletıs paççahee vuk'lek vukkekkane ölkayn q'aanunbı yuşan ha'a. Mang'vee man q'aanunbı kitabeeqa otk'un Rəbbine ögiylqa giyxhe. Mançile qiyğa Şamuelee millet cone xaybışeeqa g'ekka. ");
INSERT INTO tkr_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Şaulur cune xaaqa Giveayeeqa ayk'an. Allahee məxüd ha'a, sassa igidyar Şauluqab qihna avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Sassa karaı'dəəneme insanaaşe inəxüd eyhe ıxha: – İne insanee şi nəxüb g'attivxhan haa'ayee? Manbışe mana qizarır ha'a deş, mang'us paybıd ıkkekka deş. Şaulee mançis nıq' qığayhe deş. ");
INSERT INTO tkr_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Ammonğançene Naxaşee, Gileadne cigabışeena Yaveş eyhena şahar hiqiy-allançe avqaaqqana. Yaveşne milletıncad Naxaşik'le eyhen: – Şaka cuvab g'ats'ak'vne, şinad ğu eyhenbı ha'as. ");
INSERT INTO tkr_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Ammonğançene Naxaşee manbışik'le eyhen: – Vuşun gırgıng'un sağın uleppı alqı'ı, məxüb İzrail g'eliqqa huvuyle qiyğa, zı şu uvhuynçilqa qarayle. ");
INSERT INTO tkr_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Yaveşne ağsaqqalaaşe mang'uk'le eyhen: – Şas sa yighılle yiğ hele, xabar ana İzrailyvolle insanar g'axuvles. Şi şavussecab g'attivxhan haa'as dəəxəxhee, manke şicab şi yiğne xılyaqa qevles. ");
INSERT INTO tkr_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Xabar ana insanar, Giveayeeqa Şaulusqa abı, milletıs hucooyiy ıxhava yuşan ha'an. Milletıd ts'irıka geşşe giyğal. ");
INSERT INTO tkr_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Mane gahıl Şaul cune yastbışiqar qihna çoleençe qöö ıxha. Mang'vee qiyghanan: – Milletık hucoona ıxha, nya'a man geşşe? Manke Yaveşbışe cos yuşan hı'ıynbı, manbışe mang'ulqa hixhar ha'anbı. ");
INSERT INTO tkr_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Man eyhenbı g'ayxhımee, Allahın Rı'h Şaululqa gexa. Şaul qəlın qoxa giyğal. ");
INSERT INTO tkr_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Mang'vee cuna q'öble yats givk'u, san-sanna qaa'a. Qiyğad xabar ana abıynbışisqa man sanbı quvu, İzrailyvolle in eyhe iviykaras ulyooka: – Şaulneyiy Şamuelyne qihna qidyabıynbışde gırgıng'une yatsbışilqab mana ver ooxasvude. Milletılqa Rəbbile qəpq'ı'niyna g'iç' gyooç'e, manbışin gırgınbı sanab oza qeebaxhenbı. ");
INSERT INTO tkr_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Şaulee manbı Bezek' eyhene cigee gipk'ıning'a, İzrailybışiqa xhebıd vəş aazır (300 000), Yahudeeşiqar xhebts'al aazır (30 000) adamiy ıxha. ");
INSERT INTO tkr_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Manbışe Yaveşğançe xabar ana abıynbışik'le eyhen: – Gileadeene Yaveşbışik'le inva eyhe: «G'iyqa verığ pıra quvxhesse, şu g'attivxhanasınbı». Xabar ana abıynbışe mana xabar Yaveşbışilqa hivxhar hav'umee, manbı şadeebaxhenbı. ");
INSERT INTO tkr_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Yaveşbışe Naxaşik'le eyhen: – G'iyqa şicab şi vuşde xılyaqa qevles, manke şos hucooyiy ıkkan, şak he'e. ");
INSERT INTO tkr_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Qinne yiğıl Şaulee cun insanar xhebne cigeeqa bit'al haa'a. Miç'eed qixhesnang'a, manbı Ammonğançenbışin g'oşunbınane cigeeqa akk'yapk'ı, yı'q'ı'hı'lqasmee, manbı gyabat'a vuxha. Üç'übba avxuynbı sassabna mançe heebaxanbı. Q'öyre-q'öyrena vuşucar sacigee axu deş. ");
INSERT INTO tkr_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Milletın Şamuelik'le eyhen: – Şaul yişda paççah ixhes dəxəsva eyhenbı nyavxha? Qavaale şi man insanar gyapt'as. ");
INSERT INTO tkr_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Şaulee eyhen: – G'iyna vuşucar gik'as deş. G'iyna Rəbbee İzrail g'attivxhan hav'uyn yiğ vod. ");
INSERT INTO tkr_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Şamuelee milletık'le eyhen: – Qudoora Gilgaleeqa sapk'ıl, paççah vuşuyiyva sayid eyhes. ");
INSERT INTO tkr_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Gırgın milletcad Gilgaleeqa atk'ın, Rəbbine ögiyl Şauluke paççah ha'a. Maa'ad manbışe, Rəbbine ögiyl q'urbanbı gyaat'a. Gırgıne İzrailybışe Şauluka sacigee mane yiğıl yugda otxhun-ulyoğan. ");
INSERT INTO tkr_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Şamuelee İzrailybışde gırgıng'uk'le eyhen: – Haane, zı şu eyhençil k'ırı alixhxhı şos paççah gixhxhına. ");
INSERT INTO tkr_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Həşde şoqa vuşda paççah vor, zımee q'əs qıxha, ç'ərbı cagvara qeetxha. Yizın dixbımee şoka vob. Zı cehilyranang'ançile g'iyniyne yiğılqamee vuşde ögee ark'ın. ");
INSERT INTO tkr_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","G'iyna zı vuşde ögiyl ulyorzuling'a, şu zak'le eyhelan, zı şavna yatsne, əməlene alyapt'ı? Vuşune zı horç'un? Vuşuyiy zı azırda hı'ı? Şavuke pıl alyaat'uye, mang'une pisde işilqa ul gyapxı? Rəbbineyiy Mangv'ee g'əyxı'ne paççahne ögee, yizde aq'veeqa aqqe. Zı şoke alyat'uyn sak'al ha'as. ");
INSERT INTO tkr_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Manbışe mang'us inəxüd alidghıniy qele: – Ğu şi mısacab hopç'un deş, azırbab g'alyav'uynbı deş, şavnecad xılençe vuççudud g'ayşuyn deş. ");
INSERT INTO tkr_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Şamuelee manbışik'le eyhen: – Şok'le g'iyna yizde aq'vee aqqasın vuççud ivdeeke ıxhay, Rəbbik'led, Mang'vee g'əyxı'yne paççahık'led g'acuyn. Manbışed «Ho'o, şaqa yiğne aq'vee aqqasın kar deşinva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Şamueleecad meed milletık'le eyhen: – Mane Rəbbee Haruniy Mısa g'əvxü, vuşun dekkarıb Misirğançe Mang'veecab qığav'u. ");
INSERT INTO tkr_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Həşde Rəbbine ögiyl ulyoozre. Zı şok'le Rəbbee şosiy vuşde dekkaaşis hav'una yugvalla eyhes, mana vuşde aq'val avqas. ");
INSERT INTO tkr_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Yaaq'ub Misireeqa qarayle. Qiyğa mang'uke g'abıynbışilqa Misirbışe yiğbı examee, manbışe Rəbbilqa xıleppı aaqa. Rəbbeeyib, Haruniy Mısa vuşun dekkar Misirğançe qığav'u, inyaqa qavaalesva g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Manbışemee Rəbb, cona Allah, yik'el hixan ha'a. Rəbbeeyib manbı Xatsorne g'oşunne xərıng'une Sisrayne, Moavne paççahne sayib Filiştinaaşde xılyaqa qoole. Manbışe vuşde dekkaaşika dəv'ə haa'a. ");
INSERT INTO tkr_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Manke milletın gyaaşe-gyaaşe Rəbbilqa xıleppı aaqı, eyhen: «Rəbb, şi Ğu yik'el hixan hı'ı, Ba'aliy Aştoret donane byuttyaaşis ı'bəədat hı'ı, bınah hav'u. Ğu şi həşde duşmanaaşine xılençe g'attivxhan hav'uynxhiy, şi Vas ı'bəədat ha'ayiy». ");
INSERT INTO tkr_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Rəbbeeyib manke Yerubba'al, Bedan, İftah, Şamuel g'uxoole. Şu nişilecab qı'məəq'ənceva Mang'vee şu məxüb hiqiy-allane duşmanaaşine xılençe g'attivxhan haa'a. ");
INSERT INTO tkr_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Şok'le Ammonbışda paççah, Naxaş, şolqa ı'qqə g'acumee, vuşda paççah Rəbb Allah ıxhayka, şu ilydyaakkı, zak'le uvhuyn: «De'eş, şaqa yişda paççah ıxha ıkkan». ");
INSERT INTO tkr_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Haane şos ıkkiykın, şu g'əyxı'na paççah. İlyaake Rəbbee şos paççah gixhxhına. ");
INSERT INTO tkr_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Rəbbile qəpq'ı'n Mang'us ı'bəədat he'eene, Mang'vee eyhençil k'ırıbı alixhxhı, Mang'une əmrbışeençe qığdepç'eene, şunab şol oğa gixhxhına paççahır vuşde Allahee, Rəbbee, eyhençika gyuv'ur oza qeepxheene, geed yugda ixhes! ");
INSERT INTO tkr_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","De'eş, şu Rəbbine cuvabıl k'ırı ilydiyxhı, Rəbbine əmreençe qığeepç'eene, nəxdiy Rəbbin xıl vuşde dekkaaşilqa satk'ıl, həməxdıd şolqad sak'alas. ");
INSERT INTO tkr_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Həşdemee ulyobzur, Rəbbee vuşde ulene ögiyl haa'asde xənne işiqa ilyaake! ");
INSERT INTO tkr_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","G'iyna suk qiviyşalan yiğ dişde vod? Zı həşde Rəbbilqa xıleppı aaqı, Mang'uk'le xəybı g'əhətqe'eva, gyoğiy g'axıleva eyhes. Manke şok'lecad ats'axhxhesın, şos paççah heqqıyka, şu Rəbbine ögiyl nimeena bınahiy hav'uva. ");
INSERT INTO tkr_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Şamuelee Rəbbilqa ona'a, Rəbbeyid manecad yiğıl xəybı g'əhətqı'ı, gyoğiy gyoğa'a. Manke millet Rəbbiled, Şamueliled qətqı'niyn. ");
INSERT INTO tkr_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Milletıncad Şamuelik'le eyhen: – Yişdemee, yiğne g'ulaaşinemee, yiğne Allahılqa, Rəbbilqa, düə hee'e, Mang'vee şi gimabat'acen. Şi yişde manisa bınahbışilqa, paççah heqqıyka sayıb hexxav'una. ");
INSERT INTO tkr_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Şamuelemee milletık'le eyhen: – Qı'məəq'ən, şu mana bınah hav'u vuxheeyib, Rəbbile sivmiyk'al, Rəbbis ı'bəədat yik'eençe he'e. ");
INSERT INTO tkr_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Nişiscad karaı'dəəne byutbışinemee, Rəbbile sivmiyk'al. Manbı nişiscad karaı'dəən karbı ıxhayke, mançisse şos nəxbınacab yugvallab haa'as vəəxəs deş, nişikecabıb g'attivxhan haa'as deş. ");
INSERT INTO tkr_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Rəbbee Cune xənne doyunemee, şu dağaa'as deş. Rəbbis Cus ıkkiykın, şoke Cun millet hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Zalqa axvee, zı şol-alla düə hav'uy g'aleççes deş. Mançike zas Rəbbine ögiyl bınah vuxhes. Zı şos yugna, qopkuna yəq haagvas. ");
INSERT INTO tkr_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Saccu Rəbbile qəvəq'ne, Mang'us gırgıne gahbışil yik'eençe ı'bəədat he'e. Yik'el aqqe, Rəbbee vuşdemee nəxdın ç'ak'ın işbı hı'ı ıxhay. ");
INSERT INTO tkr_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Şu pisvalybışike xıl ts'its'dyav'eene, şunab, vuşda paççahır ç'iyene aq'vayle havaakal haa'asınbı. ");
INSERT INTO tkr_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Şaul paççah ıxhamee, mang'uqa xhebts'al (30) senniy vod. Mana yoq'ts'ale q'olle (42) senna İzrailyna paççah ıxha. ");
INSERT INTO tkr_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Şaulee cune g'oşunbışeeqa xhebıd aazır İzrailyğançena g'əyxə. Manbışda q'öd aazır insan cukasana Mikmas eyhene şahareeyiy Bet-Elyne tepabışee vooxhe. Aazır insanmee cune dixeka, Yonatanıka, Benyaminna nasıl vooxhene Givea eyhene şaharee vooxhe. Mansa axuyn milletmee Şaulee cone xaybışeeqa yəqqı'l ha'a. ");
INSERT INTO tkr_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Yonatanee Giveayeene Filiştinaaşde zastaaveebın eskerar gyabat'a, manıd Filiştinaaşik'le ats'axhxhen. Şauleeme: «Cühüt'yaaşik'le g'ayxhecenva!» uvhu, ölkavolle şeypur hook'as ulyookka. ");
INSERT INTO tkr_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","İzrailybışde gırgıng'uk'le Şaulee, Filiştinaaşde zastaveebın eskerar gyapt'ıyıd, Filiştinaaşik'le İzrailybı g'umooce qeepxhayıd g'ayxhiyn. Millet Şaulne hiqiy-alla salecenva Gilgaleeqa qoyt'al. ");
INSERT INTO tkr_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Filiştinarıb İzrailybışika səvxəsva savayle. Manbışe xhebts'al aazır (30 000) dəv'əyn daşk'a, yixhıd aazırır (6 000) balkanılyna sa'a. Manbışda g'oşun deryahne mıglekna g'um xhinne geeb vuxha. Manbı apk'ın Bet-Aven eyhene şaharne şargıl Mikmasee çadırbı giyxə. ");
INSERT INTO tkr_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","İzrailybışik'le cok ixhesın g'acumee, co ooşaa'a g'avcumee, manbı mağarabışee, axtıne ok'bışee, suvabışee, k'oralybışee, kahrızbışee dyuguleebaxhenbı. ");
INSERT INTO tkr_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Manbışiken sabarabı İordanne damayne şene aqvalqa Qadne nasıleneyiy Gileadne cigabışeeqa ılğeebaç'e. Şaul vuc Gilgalee axva, cukane milletınıd qəpq'ı'niyvalin yik'bı qoda eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Şaulee, Şamuelee uvhuyn xhinne yighılle yiğna gozet ha'an. Mane gahıl Şamuel Gilgalqa arayle deş. Şaulne hiqiy-alla sabıyn insanar heebaxa giviyğal. ");
INSERT INTO tkr_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Şaulee eyhen: – Gyoxhxhan ha'asıniy medın q'urbanbı zasqa qale. Mang'vee vuceecab gyooxhan haa'ana q'urban ablyaa'a. ");
INSERT INTO tkr_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Gyooxhan haa'ana q'urban ablyav'u ç'əveepxhamee, Şamuel qarı hiyxhar. Şaul salam hevlesva mang'une ögiylqa qığeç'e. ");
INSERT INTO tkr_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Şamuelee eyhen: – Ğu in hı'iyn kar hucoone? Şaulee mang'us cuvab qele: – Zak'le g'acuyn yizde hıqiy-alladın millet hexva vod, ğunar ğu eyhene yiğıl arı hirxhıl deş, Filiştinarıb Mikmasqa vob sabı. ");
INSERT INTO tkr_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Zı zaled-alqa uvhuyn: «Həşde xhinnee Filiştinar Gilgalılqa zalqa k'yooharas, zımee Rəbbina xayir-düə alyapt'ı deş». Mançil-allar zıcar zı gyooxhan haa'ana q'urban ablyaa'as alikkı. ");
INSERT INTO tkr_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Şamuelee Şauluk'le eyhen: – Ğu ək'el deşin kar hı'ı. Yiğne Allahne, Rəbbine, əmrılqa əməl hı'ı deş. Ğu məxüd hidi'iynxhiy, Rəbbee yiğna paççahiyvalla İzrailil oğa gırgıne gahbışis havaacesdaniy. ");
INSERT INTO tkr_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Həşdemee yiğna paççahiyvalla xıliyba ts'ıts'uvxhes deş. Rəbbee Cus ıkkanna, Cune yik'es sik'ına insan t'abal hı'ı. Ğu Rəbbine əmrılqa əməl hidi'iynçil-alla, Rəbbee mana insan Cune milletna xərna gixhxhı. ");
INSERT INTO tkr_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Mançile qiyğa Şamuel Gilgaleençe qığeç'u, Benyaminaaşine Givea eyhene şahareeqa ılqeç'e. Şaulee cun insanar qəpq'ı'mee, yixhıd vəşilqa (600) ələəna insan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Şaulıy cuna dix Yonatan, cone insanaaşika Benyaminaaşine Givea eyhene şaharee ulyobzur vuxha. Filiştinarmee mane gahıl, Mikmasee çadırbı gı'xı', ulyobzur vuxha. ");
INSERT INTO tkr_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Filiştinaaşin g'oşunbı xhebne cigeeqa bit'aleetxha hücum haa'asva qığeedaç'e. Manbışda sa deste Şualne cigabışeene Ofra eyhene şaharne suralqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","Manasa desteb Bet-Xoronne yəqqı'lqa avayk'an. Xheyib'esda destemee Tsevoimne q'adaalilqa, sarhadılqa avayk'an. Maa sahraaniy vob. ");
INSERT INTO tkr_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Filiştinaaşe uvhuynniy: «Hasre cühüt'yaaşe g'ılınciy nize hıma'acen». Mançil-allad İzrailee sa ixheeyir yiva getas əxəna insan deşdaniy. ");
INSERT INTO tkr_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Gırgın İzrailybı kyotanbı, toxabı, yak'vbı, ərabbı ek'a'asva Filiştinaaşde k'anyaqa abayle vuxha. ");
INSERT INTO tkr_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Manbışike kyotan, yaba, yak'v, rab, toxa ek'a'as sa pim nuk'raynaniy hooqqana. ");
INSERT INTO tkr_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Mançil-allad dəv'ənang'a Şaulneyiy Yonatanne milletıqa g'ılıncbıyiy nizebı ıxha deş. G'ılınciy nize saccu Şauluqayiy cune dixeqa Yonatanıqa ıxha. ");
INSERT INTO tkr_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Filiştinaaşda deste Mikmasısneene ı'lğəəne cigeeqa qavayle. ");
INSERT INTO tkr_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Sa yiğıl Şaulne dixee Yonatanee cun silah haqqane nukarık'le eyhen: – Qora derayne şene suralyne Filiştinaaşine desteysqa ılğeepç'es. Mançine hək'ee, mang'vee dekkık'le eyhe deş. ");
INSERT INTO tkr_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Şaulna çadırmee Givea ç'əvooxhene cigee Migroneene sa narıne yivek avub güvxü vuxha. Mang'une k'ane yixhıd vəşşilqa (600) ələəna insan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Manbışika sacigee kaahinaaşin ileylığ givatxınna kaahin Axiyar eyxhena. Mana İkavodne çocuna, Axituvna dix eyxhe. Axituvur, Şilo eyhene cigee eyxhene Rəbbine kaahinna Eliyna neva, Pinxasna dix eyxhe. Yonatanın ark'ıniy şavuk'lecad ats'a ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Filiştinaaşina deste ulyobzurne cigeeqa ı'qqəsdemee Yonatan q'öne ganznane cigeençe ılğeç'e. Mane ganzbışin sançin do Botsets, mansançinıd Sene ıxha. ");
INSERT INTO tkr_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Ganzbışin sa şimalne surayle Mikmasıqa, mansa ganzmee canubne surayle Giveayqa ilyakka ıxha. ");
INSERT INTO tkr_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Yonatanee cune silah haqqane nukarık'le eyhen: – Qora ine sunnat hıdyav'uynbışde desteysqa ılğeepç'es. Sayid Rəbbee yişin sura aqqaqqa. Rəbbis ıkkanang'a, geebnanbı ğamaa'a, ıkkanang'ab, k'ılybananbı ğamaa'a. ");
INSERT INTO tkr_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Mang'une nukaree eyhen: – Yiğne yik'es nəxüdiy ıkkan həməxüdud he'e. Hoora he'e, ğu nyaqa ark'ınee, zı vaka vor. ");
INSERT INTO tkr_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Yonatanee eyhen: – Qora şene insanaaşisqa ılğeepç'es, manbışik'le şicab şi haagvas. ");
INSERT INTO tkr_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Manbışe şak'le «Şi şosqa qavaalesmee ulyoozreva» uvheene, şi ulyobzurne cigeençe ı'ğdiviykar, cosqab ılqıdebaç'e. ");
INSERT INTO tkr_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","De'eş, cone k'anyaqa ılqeepç'eva uvhee, şinab ılqeebaç'e. Man yişdemee, Rəbbee man insanar yişde xılyaqa quvuva işaara eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Manbışda q'öyursana şenbışde zastaveençe g'avcesde cigee ulyoozar. Filiştinaaşe eyhen: – İlyaakende, cühüt'yar dyuguleepxhayne q'əç'ürbışeençe qı'ğəə vob. ");
INSERT INTO tkr_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Eskeraaşe Yonatanık'leyiy mang'un nukarık'le eyhen: – Şasqa ılqeepç'e, vuşun darsbı qeles. Yonatanee cune nukarık'le eyhen: – Zaqar qihna qora, Rəbbee manbı İzrailyne xılyaqa quvu. ");
INSERT INTO tkr_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Yonatan g'elybışikayiy xıleppışika ilyt'iyq'an-ilyt'iyq'an ooqa ılqeç'e. Cuqar qihnar cuna nukar ılqeç'e. Yonatan ooqa ılqeç'u, Filiştinar uvxü hı'ğəəkar haa'anbı, cuqar qihna qööne nukareeyib manbı gyabat'anbı. ");
INSERT INTO tkr_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Ts'eppa aldaaxhvan gibğılmee, Yonataneeyiy cune silah haqqane nukaree g'ane (20) insanılqa ələəna insan gek'a. Manbı q'öne yatsısse sa yiğee ezas əxəsde çolun surameene cigee aldaaxhvan vuxha. ");
INSERT INTO tkr_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Zastaveeneyiy çolbışeene milletne yik'eeqa qəpq'ı'niy eç'e. Zastaveene eskeraaşineyiy ts'eppa ögeeqa aldaaxhvanas avayk'ananbışde yı'q'nee məxdın alikkiy-gikkiy gexha, mançike ç'iyecad ı'ğiykar. Man qəpq'ı'niy Allahee g'axuvu eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Benyaminaaşine Giveayee vooxhene Şaulne mane cigayqa ilyaakane eskeraaşik'le, Filiştinaaşin eskerar opt'ul-opxul heepxı əlyhəə g'ooce. ");
INSERT INTO tkr_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Şaulee cune hıqiy-alla sadıyne milletık'le, eyhen: – Qəpqe, ilyaake vuşuyiy yişinbışda deş. Qəpqı'mee, manbışik'le Yonatanıy mang'una silah haqqana cokasana maa devxhay ats'axhxhen. ");
INSERT INTO tkr_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Şaulee Axiyayk'le eyhen: – Allahna q'utye inyaqa qavaale. (Şene gahbışil Allahna q'utye İzrailybışiqa vuxha.) ");
INSERT INTO tkr_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Şaulee kaahinık'le manva eyhemee, Filiştinaaşine g'oşunnane cigee alikkı-gikkiy sık'ıldad geed qexhe. Şaulee kaahinık'le «Qımaaleva!» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Şaulıy mang'une hiqiy-alla sadıyn gırgın millet, dəv'ə əlyhəəne cigeeqa ayk'an. Manbışik'le Filiştinar alivku-givku, sana-sanbı g'ılıncbışika gyabat'a g'ooce. ");
INSERT INTO tkr_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Ts'eppiykecab Filiştinaaşine suralqa, manbışde zastaveeqa ılğeepç'ıyn cühüt'yar, Şaulneyiy Yonatanne k'anene İzrailyne milletne suralqa ılğeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Efrayimaaşine suvabınane cigabışee dyugul vuxhayne gırgıne İzrailybışik'led, Filiştinaaşin heepxıy g'ayxhımee, manbıb conbışika sacigee Filiştinaaşiqa qihna gyabak'a. ");
INSERT INTO tkr_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Məxüb mane yiğıl Rəbbee İzrail g'attivxhanaa'ana. Dəv'əb Bet-Avenısqa hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","İzrailybı mane yiğıl geeb obzur vooxhe. Şaulee «Exhalilqamee, zı duşmanaaşikın ha'asmee, şavaayiy gıney otxhun bed-düə vuxhenava!» uvhu, g'oşunusqa k'ın g'assaras ilekka. G'oşuneenbışike şavaacad ghalik vuççud set'a deş. ");
INSERT INTO tkr_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","G'oşun ç'alagaqa ikkeç'umee, manbışik'le ç'iyel itv g'ece. ");
INSERT INTO tkr_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","G'oşunuk'le ç'alagee g'acuyne p'et'aybışike itv gyodatsts'e ıxheeyid, şavaacad xıl ghalyaqa ıkkekka deş. Manbı co g'assırne k'ınile qəvəyq'ən vuxha. ");
INSERT INTO tkr_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Yonatanık'le, dekkee g'oşunusqa k'ın g'assaras alikkiy ats'a deşdiy. Mang'vee xıledın t'at'aa hotku ç'iyelyne ittveeqa k'yoq'u, qiyğad t'at'alyne ittulqa xıl qadğu, ghalyaqa ıkkekka. Manke mang'une uleppışeeqa işix qayle. ");
INSERT INTO tkr_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","G'oşuneene sang'vee eyhen: – «G'iyna şavaayiy kar otxhun mang'us bed-düə vuxhenava!» uvhu, yiğne dekke g'oşunusqa it'umun k'ın g'assarasniy alikkı. Mançil-allab eskerar g'elike-xıleke g'a'apk'ı. ");
INSERT INTO tkr_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Yonatanee eyhen: – Dekkee, g'oşunus əq'üba vob hoole. İlyaakende, zı mane ittvuke sık'ınincad otxhun, uleppışeeqa işix qadı! ");
INSERT INTO tkr_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","G'iyna eskeraaşe duşmanaaşike g'ayşuyne otxhuniybışike avts'esınmeen otxhun ıxhaynxhiy, hucoo dexheyiy? Nya'a, Filiştinaaşile sık'ılbab yugba ğamdeebaxheyiy? ");
INSERT INTO tkr_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Mane yiğıl Şaulna g'oşun, Mikmasıle Ayaloneeqamee Filiştinaaşile ğameebaxhenbı. Mane yiğıl eskerar geeb obzur vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Eskeraaşe cone xılyaqa aytk'uyn Filiştinaaşin vəq'əbı, yatsbı, vuç'ebı zarada maacad gyat'u, ebakacad çuru oyxhan. ");
INSERT INTO tkr_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Man Şaululqa hixhar ha'a: – İlyaakende, eskeraaşe çuru ebakacad otxhun, Rəbbine ögiyl bınah haa'a. Şaulee eyhen: – Şu Rəbb yik'el hixanı'ı, həşdeme zasqa sa xəbna g'aye qa'aak'an hee'e. ");
INSERT INTO tkr_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Meed Şauleecad eyhen: – G'oşunne yı'q'neençe ılğeepç'ı, manbışik'le eyhe: «Gırgıng'vee cuna yats, vəq'ə zasqa abı, kara'əəba yizde k'ane, mane g'ayel givk'u ooxhnecen. Çuru ebaka otxhun, Rəbbine ögiyl bınah hımaa'a». Mane xəmde gırgıng'vee, con yatsbıyiy vəq'əbı maqa adı, cone xıleka gyaat'a. ");
INSERT INTO tkr_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Məxüd Şaulee ts'etta Rəbbis q'urbanbı allya'an ciga ali'ı. ");
INSERT INTO tkr_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Şaulee eyhen: – Qudoora, Filiştinaaşiqab qihna xəmdecab gyapk'as, miç'eediy qıxhesse, manbışin vodun-deşin g'ayşu, con gırgınbıb gyapt'as. Mang'uk'le «Vas nəxüdiy ıkkan həməxüdud he'eva» eyhe. Kaahineeme «Qudoora, Rəbbike qiyghanasva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Şaulee Allahıke qiyghanan: – Zı Filiştinaaşiqa qihna gixhene? Ğu manbı İzrailybışde xılyaqa qevlesınbıne? Mane yiğıl Allahee mang'us alidghıniy qele deş. ");
INSERT INTO tkr_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Şaulee eyhen: – G'oşunun ç'ak'ınbı, vuşun gırgınbı inyaqa savaale. Şu g'iyna nena bınahiy hav'uva, ats'axhxhes. ");
INSERT INTO tkr_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","İzrail g'attivxhan hav'uyne, Vorne Rəbbilqan k'ın ixhen, ine işee yizde dixen, Yonatanınıd, xıl ixheene, mana gik'as ıkkan. Milletıke şavaacad nıq' qığavhu deş. ");
INSERT INTO tkr_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Şaulee İzrailyne gırgınbışik'le eyhen: – Şu sa sural, zınar yizde dixeka manesa sural ulyoozaras. Eskeraaşe Şauluk'le: «Yiğne yik'es ıkkanəxüd he'eva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Şaulee İzrailyne Allahık'le, Rəbbik'le, eyhen: – Zas qotkuyn alidghıniy qele! K'eççuyne çöpün Şaulıy Yonatan haagva. Bınah milletıl aaxva deş. ");
INSERT INTO tkr_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Şaulee eyhen: – Yizdeyiy dixene Yonatanne yı'q'neeyid çöp k'eççe. Çöpün Yonatan hagva. ");
INSERT INTO tkr_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Şaulee Yonatanık'le eyhen: – Ğu hucoone hı'ı, zak'le eyhe! Yonatanee mang'uk'le eyhen: – Xılene t'at'aane sivelin sık'ınin itv otxhun. Zı mançil-alla qik'asda. ");
INSERT INTO tkr_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Şaulee eyhen: – Yonatan, ğu g'iyna q'idek'vee, hasre Allahee zas mançiled pisın he'ecen! ");
INSERT INTO tkr_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Milletınmee Şauluk'le eyhen: – İzrail məxüb uftanba ğamav'una, Yonatanne qik'as? De'eş! Vorne Rəbbilqan k'ın ixhen, mang'une vuk'lelyna sa ç'ərıb ç'iyelqa g'a'avxhas deş. Nya'a, mang'vee g'iyna Allahne kumaagıka iş g'avcu. Məxür Yonatan milletın qik'uyke g'attixhan ha'a, gik'as haysar deş. ");
INSERT INTO tkr_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Şaulur Filiştinaaşiqar qihna gexha deş. Filiştinarıb cone cigabışeeqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Şaul İzrailyna paççah ıxhayle qiyğa, mang'vee hiqiy-allane cone duşmanaaşika: Moavaaşika, Ammonaaşika, Edomaaşika, Tsovayne paççahaaşika, Filiştinaaşika dəv'ə haa'a. Mana nene suralqa ark'ınee duşmanaaşine vuk'lelqa ver ooxa vuxha. ");
INSERT INTO tkr_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Mana yik'eka sacikku Amalekaaşile ğamxha, İzrail q'əra qaa'anbışike g'attivxhanaa'ana. ");
INSERT INTO tkr_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Yonatan, İşvi, Malki-Şua Şaulun dixbı vuxha. Mang'une xənne yişşen do Merav, k'ıning'ı'nıd Mikal ıxha. ");
INSERT INTO tkr_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Şaulne xhunaşşeyn do Axinoam eyxhe. Mana Axima'atsna yiş yixha. Şaulne g'oşunna xərna Avner ıxha. Avner Şaulne emisiyna, Nerna dix ıxha. ");
INSERT INTO tkr_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Şaulna dek Gişiy Avnerna dek Ner Avielin dixbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Şaulna ı'mı'rcab Filiştinaaşikane yı'q'ne dəv'ee ılğevç'u. Gucukana, yik'ekana insan nyaariy mang'usqa qızaxxı, mang'vee cusqa alyarat'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Şamuelee Şauluk'le eyhen: – Rəbbee zı g'axuvuna, q'ış qadğu vake Cune milletıs İzrailis paççah ha'as. Həşde ğu Rəbbee eyhençıl k'ırı alixhxhe. ");
INSERT INTO tkr_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Xəəne G'oşunbışde Rəbbee, inıd eyhe: «İzrailybı Misireençe əlyhəəmee, Amalekaaşe manbışda yəq avqu. Zı mançil-alla manbışilqa yiğbı allya'as. ");
INSERT INTO tkr_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Hoora, hark'ın Amalekaar gyapxe. Manbışiqa vodunmeen gırgın kar giyxvər he'e, coyub oot'al-ooxal he'e. Manbı qivmiykkan, manbışin adamerıb, yedarıb, uşaxarıb, gyooqanbıb gyapt'e. Manbışin yatsbıd, vəq'əbıd, devabıd, əməlerıd gyat'e». ");
INSERT INTO tkr_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Şaulee millet qot'ul, manbı Telaim eyhene şaharee qəbəqqənbı: maa'ar q'öd vəş aazır (200 000) İzrailyne eskerıle hexxana, Yahudeeşina yits'ıd aazır (10 000) eskerır eyxhena. ");
INSERT INTO tkr_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Şaul Amalekaaşine şaharısqana qarı, maane q'adaalil manbı gyapt'asva dyugul eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Mang'vee Genbışik'le eyhen: – Amalekaaşisse hudoora, manbışike cureepxhe. Şunab manbışika sacigee gidyapt'as. Şu, İzrailybı Misirğançe qı'ğəəmee, manbışis yugvallaniy hav'u. Genbı Amalekaaşike cureepxha avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Şaul Xavila eyhene şahareençe girğıl, Misirne şargılyne Şur eyhene şaharılqamee Amalekbı gyabat'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Mang'vee Amalekaaşina paççah Agag üç'ürra aqqaqqa, mang'un milletmee, gırgıda g'ılıncıke alğayhe. ");
INSERT INTO tkr_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Amalekaaşina paççah Agagiy manbışin nekke yugun vəq'əbı, yatsbı, kokuiyn q'ıkariy urgbı Şaulusiy cune milletıs qiykkın, gyat'u ak'an ha'a deş. Amalekaaşin gıranın, yugun karbıd manbışis qiykkın, haq'var-hiyxvər ha'as ıkkiykan deş. Nimeeniy Amalekaaşiqa karaı'dəən, pisın kar vod İzrailybışe giyxvər hı'ı ak'an ha'an. ");
INSERT INTO tkr_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Mane gahıl Rəbbee Şamuelik'le inəxüd eyhe: ");
INSERT INTO tkr_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","– Zı Şauluke paççah hı'ı paşmanxhana. Mang'vee Zalqa yı'q' sak'al hı'ı, Yizın cuvab ç'iyelqa g'a'aççu. Mançike Şamuelis qəl vuxha, xəmvolle Rəbbilqa düə haa'a. ");
INSERT INTO tkr_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Şamuel miç'eeqana Şaul g'acesva suğotsumee, mang'uk'le şavame eyhen: – Şaul Karmel eyhene şahareeqa ark'ın. Maa'ab mang'vee, cus haykal gyuvxhu, mançer Gilgalqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Şamuel Şauluqa avarq'ılymee, Şaulee eyhen: – Hasre Rəbbee vas xayir-düə hevlecen! Zı Rəbbee eyhen hı'iyn. ");
INSERT INTO tkr_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Şamueleeme mang'uk'le eyhen: – Nya'a manke yizde k'ıriysqa vəq'əbışiniy yatsbışin heghan sesbı qöö? ");
INSERT INTO tkr_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Şaulee eyhen: – Manbı Amalekaaşike adı. Milletıs vəq'əbıyiy yatsbı qiykkıniynbı, manbışe inekke yugunbı Rəbbis, yiğne Allahıs, q'urbanna allya'as havacı. İnsanar gyapt'ıynbı, mansa axuyn karbımee giyxvər hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Şamuelee Şaulık'le eyhen: – Ç'əv, g'iyna xəmde Rəbbee zak'le uvhuyn, zı vak'le eyhes. Şaulee, «Eyheva» cuvab qele. ");
INSERT INTO tkr_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Şamuelee eyhen: – Ğucar vasqa k'ırra qööng'ə, nya'a vake İzrailyne nasılbışda xərna ıxha dişde? Rəbbee, q'ış qadğu, vake İzrailyna paççah hı'ı dişde? ");
INSERT INTO tkr_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Rəbbee ğu g'ıxelemee, inva dişde uvhu: «Hark'ın bınahıka gyavts'uyne milletıkın Amalekaaşikın he'e, manbı gırgıba gyapt'e. Manbışde gırgınbışikın ha'asdesmee, dəv'ə hee'e». ");
INSERT INTO tkr_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Nya'a ğu Rəbbil k'ırı ilydiyxhı? Manbışike g'ayşuyne karal qıxha, Rəbbee ilydyaat'asın kar hı'ı? ");
INSERT INTO tkr_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Şaulee Şamuelik'le eyhen: – Zı Rəbbee eyhençil k'ırı gyaqqıyn. Mang'vee eyhene cigeeqa hark'ınna. Manbışda paççah Agag aqqı inyaqa qarı, gırgın Amalekbı gyapt'ıynbı. ");
INSERT INTO tkr_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Saccu eskeraaşe şenbışike g'ayşuyne çavra-vəq'əyke, gyat'u ak'an ha'asınçike, nekke yugun yatsbıyiy vəq'əbı g'əyxı' Rəbbis, yiğne Allahıs, Gilgalee q'urbanbı allya'asva havacı. ");
INSERT INTO tkr_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Şamueleeme mang'uk'le eyhen: – Gyoxhxhan ha'aneyiy menne q'urbanbışile geed, Rəbbis Cune cuvabıl k'ırı alixhxhıniy ıkkan. Rəbbine cuvabıl k'ırı alixhxhiy, q'urbanbışileeyiy nekke kokun g'argbışile nimeexheyid yugdaniy vod. ");
INSERT INTO tkr_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Rəbbee eyhen hidi'iyna bınah, cadubı hı'iyna xhineecab vob. Culed-alqan karbı hı'iyid, byuttyaaşis ı'bəədat ha'an xhineecad vod. Ğu Rəbbin cuvab əq'əna qı'ı, Mang'veeyir ğu paççahiyvalike hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Şaulee Şamuelik'le eyhen: – Zı bınah hav'u, Rəbbine əmrıliy, yiğne cuvabıl k'ırı ilydiyxhı. Zı yizde g'oşunule qərq'ı'nna, dişe manbışil k'ırı alixhxhı. ");
INSERT INTO tkr_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Hucoona ixhes, həşde ğu yizde bınahıle ilyheç'e, qora zaka yıq'əlqa sak'le, zı Rəbbis ı'bəədat ha'as. ");
INSERT INTO tkr_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Şamuelee Şauluk'le eyhen: – Zı vaka sak'alas deş. Ğu Rəbbee uvhuyn hı'ı deş, Mang'veeyib vasse İzrailyna paççahiyvalla g'avşuna. ");
INSERT INTO tkr_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Şamuel mançe əlyhəəsva sak'ımee, Şaulee mana plaşike aqqaqqa, manıd qoxan. ");
INSERT INTO tkr_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Şamuelee mang'uk'le eyhen: – Nəxdiy ğu yizın plaş qotxu məxbı'b g'iyna Rəbbee yiğne xılençe İzrailyna paççahiyvalla qooxas. Mang'vee vas k'anerıng'une, vale yugung'une xılyaqa qevles. ");
INSERT INTO tkr_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","İzrail Ğamaa'ane Allahee, horbıd ha'a deş, fıkırıb badal haa'a deş, Mana insan deş vor fıkır badal haa'as. ");
INSERT INTO tkr_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Şaulee eyhen: – Zı bınah hav'u. Hucoona ixhes, həşde xalq'ıne ağsaqqalaaşineyiy İzrailyne ögiyl zas hı'rmat givxhe. Zakasana sak'le, yiğne Allahıs, Rəbbis, ı'bəədat ha'as. ");
INSERT INTO tkr_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Şamuel Şauluqar qihna qaraylena, Şauleeyid Rəbbis ı'bəədat ha'a. ");
INSERT INTO tkr_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Şamuelee eyhen: – Amalekaaşina paççah Agag inyaqa yizde k'anyaqa qale. Agagır vuççud dexhesda xhinne qaraylena. Agagee culed-alqa eyhe ıxha: – Mıts'an, zı qik'uyke g'attirxhınna. ");
INSERT INTO tkr_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Şamuelee eyhen: – Yiğne g'ılıncın nəxübiy yedar kulyfatbı dena g'alyav'u, yiğna yedir həməxür kulyfat dena eexvas. Şamuelee Gilgalee, Rəbbine ögiyl Agag gyaraxana. ");
INSERT INTO tkr_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Mançile qiyğa Şamuel ayk'anna Ramayeeqa, Şaulur Giveayeene, cune xaaqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Şamuelee, Şaulna geeb haa'a, geed uts'ur ts'ıts'a'a. Mang'uk'le mana qik'asmee, g'ece deş. Rəbbir Şauluke İzrailyna paççah hı'ıva paşman eyxhena. ");
INSERT INTO tkr_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Rəbbee Şamuelik'le eyhen: – Ğu geebne Şaulna haa'as, geedne uts'ur ts'ıts'a'as? Zı mang'usse İzrailyna paççahiyvalla g'avşuna. Gaç q'ışika gyavts'av'u, yəqqı'lqa gixhe. Zı ğu Bet-Lexemğançene Yesseyne k'anyaqa g'ıxele. Zı mang'une dixbışike Yizdemee paççah g'əyxı'. ");
INSERT INTO tkr_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Şamuelee eyhen: – Zı nəxürna ı'qqəs? Şauluk'le g'ayxhee, zı gik'asda. Rəbbee eyhen: – Vaka sa vuç'e vukkee, «Rəbbis q'urban ablyaa'as arıva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Yesseyir q'urban ablyaa'asde cigeeqa qot'le, qiyğa hucooyiy ha'as ıkkanva Zı vak'le eyhesın. Zı eyhene insanne vuk'lelqa ğu q'ış qadğvas, mang'uke Yizdemee paççah ha'as. ");
INSERT INTO tkr_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Şamuelee Rəbbee eyhəxüd ha'a. Mana Bet-Lexemqa qarımee, şaharın ağsaqqalar mang'une ögiylqa qəvəyq'ən-qəvəyq'ən qığeepç'ı, eyhen: – Ğu yugvalisne arı? ");
INSERT INTO tkr_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Mang'vee eyhen: – Ho'o, yugvalis arı. Zı Rəbbis q'urban ablyaa'as arı. Mətteepxha, zakasana q'urban ablyaa'ane cigeeqa able. Şamuelee Yesseyik'leyiy mang'une dixbışik'led mətteepxha q'urban ablyaa'asde cigeeqa ableva eyhe. ");
INSERT INTO tkr_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Manbı vüqqəmee, Şamuel Eliavıqa ilyakkı culed-alqa eyhen: «İna Rəbbee paççah ixhes g'əyxı'na vor!» ");
INSERT INTO tkr_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Rəbbeemee Şamuelik'le inəxüd eyhe: – Mang'une micagiyvaliqayiy axtıvaliqa ilymakka, Zı mana əq'əna qı'ı. Rəbb, insan ilyakkan xhinne deş ilyakka. İnsan insanne aq'vayqa, tanaqa ilyakka, Rəbbmee insanne yik'eeqa ilyakka. ");
INSERT INTO tkr_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Mane gahıl Yesseyee Avinadav qort'ul, mana Şamuelyne ögiyle alğayhe. Şamuelee eyhen: – Rəbbee inar g'əyxı' deş. ");
INSERT INTO tkr_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Manke Yesseyee Şamma qort'ul, mana alğayhe Şamuelyne ögeençe. Şamuelee eyhen: – Rəbbee inar g'əyxı' deş. ");
INSERT INTO tkr_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Yesseyee dixbışda yighırsana qort'ul, manbı Şamuelyne ögiyle alğaa'a. Şamuelee Yesseyk'le eyhen: – Rəbbee inbı g'əvxü deş. ");
INSERT INTO tkr_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Şamuelee Yesseyke qiyghanan: – İnbı yiğne dixbışin gırgınbıne? Yesseyee eyhen: – Nekke k'ınnar vorna, mang'vee vəq'əbı uxhiyxhan. Şamuelee Yesseyk'le eyhen: – Mang'uqar qihna insan g'axıle, hasre manar inyaqa qoracen. Mana inyaqa qalesmee, şi sufranılqa savaales deş. ");
INSERT INTO tkr_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Yesseyee mang'uqar qihna insan g'axuvu mana qalya'ana. Mang'uqa ç'ərəxən xhinnen danbı, micagın uleppı, uftanınıd aq'va eyxhe. Rəbbee Şamuelik'le eyhen: – Oza qixhe, mang'ulqa q'ış qadğve, Zı eyhena mana vor. ");
INSERT INTO tkr_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Şamuelee q'ışnana gaç alyapt'ı, çocaaşine k'ane Davudulqa q'ış qadağva. Manke Rəbbin Rı'h Davudulqa g'eç'e, mane yiğıled mang'ul oğa axva. Şamuel mançe Ramayeeqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Rəbbin Rı'h Şaulule atk'ınmee, Rəbbee mang'ulqa sa medın pisın rı'h g'ıxele ıxha. Mançinıb Şaulus əq'üba hoole vuxha. ");
INSERT INTO tkr_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Şaulne insanaaşe mang'uk'le eyhen: – Allahee g'axuvuyne pisde rı'hı'n həşde vas əq'üba hoole. ");
INSERT INTO tkr_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Yişda xərna, yiğne insanaaşilqa əmr hee'e, vas yugba lira əlivxəs vəəxəna insan t'abal he'ecen. Allahee g'axuvuyn pisın rı'h valqa qadımee, mang'vee lira əlivxee, vasıd yugda ixhes. ");
INSERT INTO tkr_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Şaulee cune insanaaşik'le eyhen: – Manke yizdemee sa yugba lira ilyviyxəna insan t'abal hı'ı zasqa ayre. ");
INSERT INTO tkr_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Mang'une insanaaşine sang'vee alidghıniy qele: – Zak'le Bet-Lexemğançene Yesseyne dixbışde sang'vee yugba lira ilyviyxə g'avcuna. Mana cehil, yik'ekana, yugra siç'ekkvana, k'orara yuşan ha'ana, micagna gadeyiy. Rəbbir mang'ukayiy. ");
INSERT INTO tkr_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Şaulee, Yesseysqa xabar ana insanar g'axuvu, eyhen: – Vəq'əbı uxhiyxhan ha'ana yiğna dix, Davud, zasqa g'axıle. ");
INSERT INTO tkr_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Yesseyee əməlelqa gıney, çaxıren tuluğ, mısva alivxhu, cune dixeka Davuduka Şaulus g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Davud Şaulusqa qarı, mang'une ögiyl ulyoyzar. Şaulus Davud geer ikkiykan, mang'uke cuna silahdar ha'a. ");
INSERT INTO tkr_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Qiyğa Şaulee, Yesseysqa cuna insan g'axuvu, eyhen: – Hucoona ixhes, hasre Davud yizde k'ane axvecen, mana zasqa yugra qarı. ");
INSERT INTO tkr_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Allahee g'axuvuyn pisın rı'h Şaululqa qadıyne gahbışil, Davudee cuna lira alyapt'ı əlivxümee, mana yug qexhe ıxha. Pisın rı'hı'd mang'uke əq'əna qexhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Filiştinaaşe dəv'ə haa'asdemee g'oşun sav'u, Yahudayne Soko eyhene şahareeqa qavayle. Sokoyneyiy Azeka eyhene şaharbışde yı'q'nee Efes-Dammimee manbışe g'oşun ulyoozarasın ciga ha'a. ");
INSERT INTO tkr_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Şauluy İzrailybı sabı Ela eyhene q'adaalil g'oşun ulyoozarasın ciga hı'ı, Filiştinaaşika dəv'ə vukkeesva manbışde ögee ulyoozar. ");
INSERT INTO tkr_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Filiştinar sa tepal, İzrailybıb manisa tepal ulyobzur vuxha. Manbışde yı'q'nee q'adaal ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Gatne şahareençena Golyat donana sa yugra siç'ekkvana Filiştinaaşde g'oşuneençe ögeeqa qığeç'e. Mana yixhne xılekkumneyiy sayid sa ç'umne axtıvalee ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Mang'une vuk'lel tuncıke hı'iyn dəbilga ıxha, tanalqad xhone aazır şekelyne yı'q'valeedın zireh ali'ı ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Mang'une g'elybışiled tuncıke hı'iyn zireh givatxın, mang'un yı'q'əlid mizrag ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Mang'une nizeyn cık'rı qexhvane xhanayn arğacın dal xhinne xətta ıxha, mançin yivayke hı'iyn sivıd yixhıd vəş (600) şekelyne yı'qvalee ıxha. Mang'un g'alxan haqqanar cule ögiyl əlyhəə ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Golyat gipk'ınne İzrailybışde ögiylqa qığeç'u, ts'ir haa'a-haa'a eyhen: – Nişisne şu qığeepç'ı, dəv'ə haa'asne? Zı Filiştinğançena, şunab Şaulun g'ular dişde vob? Vuşde yı'q'neençe sa insan g'əyxə, hasre mana zasqa giç'ecen. ");
INSERT INTO tkr_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Zaka siç'ekkvamee, mang'usse zı gik'as əxee, manke şi vuşun g'ular vuxhes. De'eş, zı ğamxha, zı mana gik'veene, şu yişin g'ular vuxhes, şi eyhençika şu gyuv'ur oza qeepxhes. ");
INSERT INTO tkr_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Filiştinğançeng'vee meed eyhen: – G'iyna zı İzrailybışilqa cuvab ayhe! Zaka qığeç'u saç'ikkvasda vuşde yı'q'neençe insan g'əyxe. ");
INSERT INTO tkr_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Filiştinğançeng'vee eyhen g'ayxhı, Şaulur cukan İzrailybıb çiçis üvxüyxə, manbı geeb qəvəyq'ən. ");
INSERT INTO tkr_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Davud Yahudayne Bet-Lexem şahareençene Yesseyna dix ıxha. Yessey Efratbışda sa ıxha. Mang'uqa molyuyre dix ıxha. Şaulne gahıl Yessey q'əs qıxha ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Mang'una xərna xhebiyre dix Şauluka qihna dəv'eeqaniy apk'ın. Mang'une dəv'eeqa apk'ınne dixbışin dobı inbıniy vod: ts'erriyna Eliav, q'ör'esda Avinadav, xhebır'esdar Şamma. ");
INSERT INTO tkr_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Davud Yesseyna nekke k'ınna dix ıxha. Dixbışin çak'ınbı, xhebırsana Şauluqa qihna avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Davudur dekkın syuru uxhiyxhan ha'ava, Şaulusqa Bet-Lexemqa hark'ın qarayle ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Filiştinğançena Golyat, yoq'ts'al (40) yiğna exhaliy-miç'eer İzrailybışisqa qığeç'u, manbışilqa cuvab ayhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Yiğbışde sa yiğıl Yesseyee cune dixek'le Davuduk'le eyhen: – Həşde yits'ıble kokayiy sa maşuk' qootsune sukuna alyapt'ı, g'oşun ulyobzurne cigeeqa yiğne çocaaşisqa zaara hoora. ");
INSERT INTO tkr_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Manbışde xərıng'usub yits'ıble guru nissenna alept'e. Çocaaşilir alycaxve, manbı nəxübiyva zas xabar able. ");
INSERT INTO tkr_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Yiğın çocar Şaulukayiy mang'une insanaaşika sacigee Ela eyhene q'adaalil, Filiştinaaşika dəv'ə haa'a vob. ");
INSERT INTO tkr_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Davud miç'eer çakra suğotsu, cun vəq'əbı menne çobanılqa g'alya'a. Qiyğar mana, Yesseyee uvhuyn xhinne, karbı alyaat'u, ayk'anna. Mana g'oşun ulyobzurne cigeeqa qarı hirxhıling'a, g'oşun dəv'ə haa'asde cigeeqa axtıne seseka giviyk'an g'ooce. ");
INSERT INTO tkr_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","İzrailybıyiy Filiştinar sanasanbışde ögee ulyozar haa'a. ");
INSERT INTO tkr_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Davudee, vucee adıyn karbı g'oşuneene g'aravulyçilqa g'ali'ı, g'oşun gipk'ınne cigeeqa çocaaşis xoşgelydiy haa'asva g'adayxhvan. ");
INSERT INTO tkr_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Davudee çocaaşika gaf haa'ang'a, Filiştinaaşine Gat şahareençena Golyat donana sa yugra siç'ekkvana hiqa qığeç'u, meed ögiylin xhinne cuvabbı ayhe. Mang'vee eyhenbı Davuduk'le g'iyxhenbı. ");
INSERT INTO tkr_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Gırgın İzrailybıcab mana insan g'acumee it'umba qəpq'ı'n heebaxa vuxha. ");
INSERT INTO tkr_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Manbışe eyhe ıxha: – Şok'le mana ögiylqa qığeç'una insan g'eceye? Mana İzraililqa cuvab ahas qığeç'u. Mana gik'una insan paççahee geed karnana ha'as, mang'us yişir heylesda, mang'une dekkına xizanıb İzrailyne nalok'bışike g'attivxhan haa'asda. ");
INSERT INTO tkr_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Davudee cune k'ane ulyobzurne insanaaşike qiyghanan: – İna Filiştinğançena gik'uyne, İzrail tesseriyvalike g'attivxhan hav'uyne insanıs hucooy'e heles? İna sunnat hidi'ına Filiştinğançena vuşuna eyxhe, Vorne Allahne g'oşunbışilqa cuvab ayhe? ");
INSERT INTO tkr_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Milletın, mana gik'uyne insanık hucooyiy ha'asva, sayid eyhen. ");
INSERT INTO tkr_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Davud insanaaşika yuşan ha'amee, mang'vee eyhenbı xərne çocuk'le, Eliavık'le g'iyxhe. Mançike çocus qəl vuxha qiyghanan: – Nişisne ğu inyaqa arı? Çoleena yişda sa-q'öble vəq'ə, ğu şavulqane g'alepçı? Zak'le ats'an, ğucar ğu xərra ıkkekka ıxhayke, yiğne yik'eençed yugun karbı ılğı'də ıxhayke, ğu inyaqa dəv'əyqa ilyakkas arı. ");
INSERT INTO tkr_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Davudee eyhen: – Nya'a, zı hucoona hı'ı? Nya'a, zas yuşan ha'asırne dexhes? ");
INSERT INTO tkr_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Davud çocuke merıng'ulqa sak'ı, mançinacab gaf haa'a giyğal, milletınıd ögiylin xhinne mang'us alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Davudee yuşan ha'anbı g'ayxhinbışe, mang'un cuvab Şaululqa hixhar ha'a. Şauleeyir mana cusqa qoyt'al. ");
INSERT INTO tkr_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Davudee Şauluk'le eyhen: – Hasre mane insanıl-alla şavaacad aq'va havaxan hıma'acen. Zı, yiğna g'ul, hark'ın mang'uka səyxəsda. ");
INSERT INTO tkr_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Şaulee Davuduk'le eyhen: – Vasse mane Filiştinğançeng'uka saç'ikkvas əxəs deş, ğu uşax vod, manamee k'ırranang'ançile otç'u dəv'əbışee siç'ekkvana vor. ");
INSERT INTO tkr_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Davudee Şauluk'le eyhen: – Zı dekkın syuru uxhiyxhana'asniy hayk'anna. Şirın, syoyun abı syuruneençe urg avqu əlyhəəmee, ");
INSERT INTO tkr_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","zı mançiqar qihna gyurxhu mançileğana kar ı'xı' ghalençe urg g'ooşenaniy. Mane həyvanaaşina sa zalqa g'opk'uluyng'amee, zı mana həyvan gardanılyne xhayıke avqu mana gyook'ananiy. ");
INSERT INTO tkr_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Zı, yiğne g'ulee, şirıd, syoyub gyuvk'una. Mana sunnat hidi'ına Filiştinğançenar mançina sa xhinne ixhes, mang'vee Vorne Allahne g'oşunulqa cuvab avhuva. ");
INSERT INTO tkr_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Şirneyiy syoyune ghalençe zı g'attixhan hı'iyne Rəbbee, Filiştinğançeng'uner xılençe g'attixhan ha'asda. Şaulee Davuduk'le eyhen: – Hak'ne, Rəbb Vuc vaka ixhecen! ");
INSERT INTO tkr_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Şaulee cun silahbı Davuduk qa'a. Vuk'lelqa tuncuna dəbilga giviyxhe, tanalqad zirehbı alya'a. ");
INSERT INTO tkr_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Davudee mane zirehıl ooğançe g'ılınc qı'ı iykar. Mankilqamee mang'vee silah iykar hı'iyn deşdiy. Qiyğa Davudee Şauluk'le eyhen: – Zasse man karbı ali'ı iykaras əxə deş. Zı həşdilqamee məxdın karbı ali'iynbıcad deşdiy. Davudee manbı tanale g'eşşenbı. ");
INSERT INTO tkr_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Qiyğa xılyaqa əsaa alyaat'u, arageençe cusda xhoble hamavarna g'ayeb g'əvxü, manbıd q'oç'eeqa k'i'ı xılene sapandıka mana Filiştinğançeng'usqa qexhe. ");
INSERT INTO tkr_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Filiştinğançenar cune g'alxan haqqang'uka mane gahıl Davudne suralqa q'öö eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Filiştinğançeng'uk'le Davud ç'ərəne danbışika, aq'vayle uftanra, mek'vra g'acumee, mana mang'uqa ooğançe-avqa ilyakka. ");
INSERT INTO tkr_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Mang'vee Davuduk'le eyhen: – Nya'a, zı vas xvaane vob, ğu zalqa t'at'aaka ı'qqə? Filiştinğançeng'vee cone allahaaşika Davudus bed-düə hav'u eyhen: ");
INSERT INTO tkr_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","– Zasqana qora, zı yiğne ç'urunuke xəəne şit'yaaşisiy, çolane həyvanaaşis heles. ");
INSERT INTO tkr_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Davudeeme Filiştinğançeng'uk'le eyhen: – Ğu zalqa g'ılıncıka, nizeyka, mizragıka qöö, zımee valqa ğu hokuyne İzrailyne g'oşunbışde Allahne, Xəəne G'oşunbışde Rəbbine doyuka q'öö. ");
INSERT INTO tkr_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","G'iyna Rəbbee ğu yizde xılyaqa qeles, zınar ğu gik'asda. Zı yiğna vuk'ul tanake curaa'asda. G'iyna Filiştinaaşde g'oşunbışin leşbı, zı xəəne şit'yaaşisiy çolane həyvanaaşis heles. Mançile qiyğa gırgıne dyunyeyk'lecad ats'axhxhesın İzrailee Allah vorna. ");
INSERT INTO tkr_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","İnyaqa sabıyne gırgıng'uk'lecad ats'axhxhesın, Rəbbee g'ılıncıkayiy nizeyka deş g'attivxhan haa'a, ina Rəbbina dəv'ə vobna, Mang'veeyib şu yişde xılyaqa qevles. ");
INSERT INTO tkr_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Filiştinğançena Davudne ögeeqa qığeç'esva, mang'usqana qöömee, Davud zaara ı'ğiykır Filiştinaaşde g'oşunbışde suralqana g'adayxhvan. ");
INSERT INTO tkr_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Davudee q'oç'eeqa xıl k'eççu g'aye alyabat'a, qiyğab sapandeeqa gyuvxhu avhu, Filiştinğançeng'une ligaylek'ena üvxüyxə. G'aye qipxhırmee mang'une ligayna bark'v havayq'ar, vucur aqvakkena ç'iyelqa qukkyoyk'al. ");
INSERT INTO tkr_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Davud Filiştinğançeng'ule sapandıkayiy g'ayeyka ğamexhe. Davudne xılee g'ılıncıd eyxhe deş, mang'vee Filiştinğançena ı'xı' gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Davud g'adarxhun Filiştinğançeng'une k'ane ulyoyzar. Filiştinğançeng'un g'ılınc qığayşu mana gik'u, qiyğab vuk'ul tanıke curaa'a. Filiştinaaşik'le cona yugra siç'ekkvana qik'u g'acumee, manbı heebaxanbı. ");
INSERT INTO tkr_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","İzrailiniy Yahudayn g'oşunbıd ts'irbı ha'a manbışiqa qihna gyadak'va. Manbışe Filiştinar Gateeqa ikkəəne cigeeqamee, Ekronne akkabışisqamee g'e'eebaşenbı. Gateeqayiy Ekronqa əlyhəəna Şaarayimna yəqvolle Filiştinaaşin gyapt'ıynbı opt'ul-opxul vuxha. ");
INSERT INTO tkr_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","İzrailybı Filiştinaaşiqab qihna gyapk'ı, mançe sapk'ılıyle qiyğa manbışin g'oşunbı ulyozzuriyn cigabı q'əra qa'a. ");
INSERT INTO tkr_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Davudee Golyatna vuk'ul alyapt'ı İyerusalimqa qavayle. Filiştinğançeng'un g'ılıncmee adı, Davudne çadıreeqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Şauluk'le Davud Filiştinğançeng'usqa qı'ğəə g'acumee, mang'vee g'oşunbışde xərıng'uke, Avnerıke, qiyghanan: – Avner, ina cehil şavna dixne? Avneree eyhen: – Paççah, geer qa'ana, ats'a deş. ");
INSERT INTO tkr_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Paççahee eyhen: – Ats'axhxhelan, mana cehil şavna dixiy. ");
INSERT INTO tkr_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Davud Golyat gik'u qöömee, Avneree mana qort'ul, Şaulusqa ıkkekka. Filiştinğançeng'una vuk'ulyub mang'une xıleecab vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Şaulee mang'uke qiyghanan: – Cehil, ğu şavna dixne? Davudee «Yiğne Bet-Lexemğançene g'uluna, Yesseyna dix vornava» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Davud Şauluka yuşan hı'ı ç'əvxhayle qiyğa, Yonatanne yik'esqa Davud yugra qarayle. Mang'us Davud vuc xhinne ıkkiykan giyğal. ");
INSERT INTO tkr_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Mane yiğıle Şaulee Davud cune k'ane aqqaqqa, dekkıne xaaqa əlyhəəs haysar deş. ");
INSERT INTO tkr_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Mana vuc xhinne geer ıkkanva Yonatanee Davuduka hambaziyvalla haa'asva cuvab g'ats'ayk'van. ");
INSERT INTO tkr_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Yonatanee tanalinbı g'ayşu, g'ılıncıka, vukuka, zirehıka sacigee ts'irab Davudusqa qoole. ");
INSERT INTO tkr_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Şaulee Davud nene işiqar qihna g'axuvee, mang'vee mana iş yugba haa'a vuxha. Mançil-allar Şaulee Davuduke cune g'oşunee ç'ak'ınbışda sa ha'a, man milletned, Şaulne hiqiy-allanbışded ulesqa yugda qadayle. ");
INSERT INTO tkr_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Davudee Filiştinğançena gik'u yı'q'əlqa siyk'almee, İzrailyne gırgıne şaharbışeençen yedar dyafbıyiy t'amp'ırbı alyaat'u, şadeebaxhen mə'niybıyiy mık'ar ha'a paççah Şaulne ögeeqa qığeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Yedaaşe mık'ar ha'a-ha'a, inəxdın mə'niybı qədəqqə ıxha: – Şaulee aazırbışika, Davudemee, yits'ıd aazırbışika gyapt'ı. ");
INSERT INTO tkr_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Şaulus mançike geeb qəl vooxhe, manbışe eyhenbı mang'une yik'eençe eyxhe deş. Mang'vee eyhen: – Davudee yits'ıd aazırıka, zımee aazırıkava manbışe eyhe. Sık'ınne gahıle manbışis mang'uke paççahcar ha'as ıkkiykanas. ");
INSERT INTO tkr_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Mane yiğıle Şaul Davuduqa sacurayracar ilyakka giyğal, mang'vee Davudus paxıliyvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Qinne yiğıl Allahee g'axuvuyn pisın rı'h Şaululqa gexa. Mang'vee xaa nen qadiy ha'a giyğal. Davudeeme, vucee ögiyl ha'an xhinne, meeb xılyaqa lira alyapt'ı mana ilyviyxə vuxha. Şaulne xıle nize eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Şaulee «Hasre Davud ine nizeyka baruguk at'iq'an ha'asva» culed-alqa uvhu, man xıledın nize ayhen. Davudusse q'öne yəqqee mançike hixvas əxəna. ");
INSERT INTO tkr_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Rəbbee Davudun sura aqqıva, vucur g'alerçuva, Şaul Davudule qəyq'ənna. ");
INSERT INTO tkr_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Mançil-allar Şaulee Davud cuke əq'əna qı'ı, mang'uke aazırıng'una xərna hı'ı. Mançile qiyğa Davudee g'oşun dəv'eeqa vukku qadayle ıxha. ");
INSERT INTO tkr_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Rəbb Davuduka vorva, mang'une xılençe gırgın işbı qöö ıxha. ");
INSERT INTO tkr_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Davudne xılençe gırgın qöö g'acu, Şaul qəyq'ənna. ");
INSERT INTO tkr_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Gırgıne İzrailybışisiy Yahudabışis Davudee co dəv'eeqa vukku qavayleva, mana geer ıkkan ıxha. ");
INSERT INTO tkr_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Şaulee Davuduk'le eyhen: – İna yizda xərna yiş, Merav vorna, mana zı vas heyles. Saccu ğu yizde yəqqə yik'eka ixhe, Rəbbinab dəv'ə vukkee. Şaulne fıkıreençe «Hasre mana yizde deş, Filiştinaaşde xıle qik'ecenva» ılğeç'e. ");
INSERT INTO tkr_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Davudee Şauluk'le eyhen: – Nya'a, zı vuşune eyxhe? Yizda xizan hucoo eyhen karne, dekkına xizanıb İzrailee şavunbışdane vob, zake paççahıs yezne ixhes? ");
INSERT INTO tkr_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Şaulna yiş Merav, Davudus heylesda gah qabımee, mana Mexolğançene Adrielis heele. ");
INSERT INTO tkr_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Davudmee, Şaulne manisa yişşis Mikalıs ıkkiykan. Mançina gaf Şaululqa hivxhar hav'umee, mana mang'une yik'eençe vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Şaulne fıkreençe «Davudus Mikal hiyvu, mang'us gugu haa'as, Davud Filiştinaaşde xıleka gik'asva» ılğeç'e. Qiyğa Şaulee Davuduk'le eyhen: – Vasse g'iyna meer yizda yezne ixhes əxə. ");
INSERT INTO tkr_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Şaulee cone hiqiy-allanbışilqa əmr haa'a, Davuduk'le dyugulenda inəxüd eyheva: – İlekke paççahıs ğu nimeeyiy ıkkan, mang'une hiqiy-allanbışisir ğu ıkkanna. Qora ğu həşde mang'us yezne ixhe. ");
INSERT INTO tkr_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Şaulne hiqiy-allanbışe, Davudus man g'ayxha'ang'a, Davudee manbışik'le eyhen: – Paççahna yezne ıxhay, vuşdemee nəxdın ıxhay karne vod? Zı kar deşda, şavuk'lecar dyats'ana insan vor. ");
INSERT INTO tkr_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Şaulne hiqiy-allanbışe «Davudee inva uvhuva» Şaululqa hixhar ha'a. ");
INSERT INTO tkr_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Şaulee eyhen: – Davuduk'le eyhe: «Paççahee vake, yişşel-alla pıl deş heqqa. Mang'vee vake, çine cigee, cuna qəl qığaahasva, cune duşmanaaşin vəşne (100) Filiştinğançeng'un sunnat hı'iyn ç'ürüx heqqa». Manıd Şaulee, Davud Filiştinaaşde xıleka gik'asva ha'a. ");
INSERT INTO tkr_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Şaulne hiqiy-allanbışe man eyhenbı Davudulqa hixhar ha'anbı. Davudusur yezne ixhes ıkkiykkanna. Gyuvxhuna gah g'avalessecab, ");
INSERT INTO tkr_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","Davud cune g'oşunıka hark'ın Filiştinaaşda q'öd vəş (200) adamiy gek'a. Paççahna yezne ixhesdemee, Davudee manbı sunnat hav'u ıxhayn ç'ürüxbı paççahısqa adayle. Manke Şauleeyir cuna yiş Mikal Davudus heelena. ");
INSERT INTO tkr_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Şaululqa hitxhırmee, Rəbb Davuduka vorva, yişşes Mikalısır Davud ıkkanırva, ");
INSERT INTO tkr_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","mana mang'ule sık'ırar geer qəyq'ən giyğal. Qik'asmeeyir mana Davudna duşman eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Filiştinaaşde g'oşunbışde ç'ak'ınbışe dəv'ə ç'əvcab haa'a vuxha deş. Manbışe dəv'ə hav'uylette, Davud mane dəv'əbışee, Şaulne gırgıne hiqiy-allane insanaaşile ək'elika ıxha. Mançile qiyğa milletın mang'un do axtıda aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Şaulee cune dixek'le Yonatanık'leyiy cune hiqiy-allanbışik'le Davud gik'eva eyhe. Yonatanısmee, Davud geer ıkkan ıxha. ");
INSERT INTO tkr_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Yonatanee Davudulqa xabar g'uxoole: – Yizde dekkıs Şaulus ğu gik'asır ıkkan. Həşdiyle, hucoon ixhes, ğucar ğu g'iyqa miç'eer havace. Sa ciga t'abal hı'ı, çolee dyugulyxhe. ");
INSERT INTO tkr_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Zınar dekkıkasana çoleeqa, ğu dyugulyxhayne cigaysqa, ayres. Mang'uka yiğne hək'ee yuşan ha'as, mang'vee hucooyiy uvhu zı valqa hixhar ha'asın. ");
INSERT INTO tkr_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Yonatanee dekkıs Şaulus, Davudne hək'ee yugun karbı yuşan hı'ı, eyhen: – Paççahee, cune nukarıs Davudus pisvalla hımaa'acen. Mang'vee vas mısacab pisvalla hav'u deş. Mang'vee hı'iyn gırgın işbıd, yiğne yugvalinemee ıxha. ");
INSERT INTO tkr_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Mang'vee, qik'uyle qı'dərq'ı'n Filiştinğançena Golyat gik'u, Rəbbeeyib İzrail g'attivxhan hav'u. Ğunar man g'acu, şadxhana. Nya'a ğu nişilycar-alla taxsir deşda Davud gik'u, q'ərane cigeeqa eb k'yaavak'an hav'u, vasda bınah haa'as? ");
INSERT INTO tkr_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Şaulee Yonatanne cuvabıl k'ırı alixhxhı, «Zı mana gik'as deşva» uvhu, Vorne Rəbbine hək'ee k'ın g'iysar. ");
INSERT INTO tkr_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Yonatanee Davud qort'ul, co yuşan hı'iyn gırgın mang'us yuşan ha'a. Qiyğar, Davud Şaulusqa ıkkekka. Davudur şenkiyn xhinne, Şaulusnee axva. ");
INSERT INTO tkr_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Meeb dəv'ə giviyğal. Davudur oza qıxha ayk'anna Filiştinaaşika saç'ikkvas. Davud manbı ootal-ooxhal hav'u, ğamexhena, manbı Davudne ögiyle heebaxanbı. ");
INSERT INTO tkr_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Yiğbışde sa yiğıl Şaul xaa'ar xıle nizeyka gyu'uringa, mang'ulqa Rəbbee g'axuvuyn pisın rı'hı'd qadı gexa. Davudee mane gahıl lira ı'lyviyxə vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Şaulus Davud nizeyka barugus at'iq'an ha'as ıkkiykan. Davud mang'une ögiyle hexvana, mang'vee avhuyn nized qadı barugeeqa k'exa. Mane xəmde Davud hixu g'ittiyxhanna. ");
INSERT INTO tkr_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Şaulee Davudne xaaqa insanar g'ıxoole, mana nyaariyva ats'axhxha, miç'eer gik'ecenva. Davudne xhunaşşee Mikalee, mang'us xabar huvu eyhen: – G'iyna xəmde vasse, hixu dyugulyxhes dəxeene, g'iyqa miç'eer ğu g'ik'asda. ");
INSERT INTO tkr_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Qiyğa Mikalee Davud g'uleençe gyaqqa, manar hixu g'ittiyxhanna. ");
INSERT INTO tkr_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Mikalee xaana byut alyapt'ı tyuleeqa giviyxhe, vuk'lelqad ç'ərnan ts'e'ın g'ekva qali'ı, ooqad tanalinbı adaççe. ");
INSERT INTO tkr_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Şaulee, Davud aqqasva g'axuvuyn insanar abımee, Mikalee «Mana ık'ar vorva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Şaulee mebın insanar g'axuvu, eyhen: – Mana tyulyunukacar zasqa ayre, zı mana gik'as. ");
INSERT INTO tkr_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Man insanar aqa ikkeepç'ımee g'ecen, tyuleeqa, vuk'lelqa ts'e'ın g'ekva qali'ıyn byutud hotku. ");
INSERT INTO tkr_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Şaulee Mikalık'le eyhen: – Nya'a zas horbı hı'ı? Yizda duşman g'aykkı, manar hixu g'attirxhınna. Mikalee Şaulus alidghıniy qele: – Davudee zak'le uvhuyn, g'aykke zı əlyhəəs! Deşxheene, zı ğu giyk'as! ");
INSERT INTO tkr_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Davud hixu g'attirxhınmee, Ramayeeqa Şamuelyne k'anyaqa qarı, Şaulee cuk hı'iyn gırgın mang'us yuşan ha'an. Mançile qiyğa mana Şamuelika sacigee Nayot eyhene şahareeqa ark'ın, maa aaxva. ");
INSERT INTO tkr_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Şaulus «Davud Ramayeene Nayoturva» xabar qabayle. ");
INSERT INTO tkr_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Şaulee mana aqqasva, maqa insanar g'ıxoole. İnsanaaşik'le, Şamuel q'oma ulyorzulyne peyğambaraaşine desteyn peyğambariyvalla haa'a g'ooce. Man g'acumee, Şaulee g'axuvuyne insanaaşilqad Allahın Rı'h geç'e. Manbışeb peyğambariyvalla haa'a giviyğal. ");
INSERT INTO tkr_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Man ıxhaynbı Şaululqa hixhar hı'ımee, mang'vee mebın insanar g'ıxoole. Manbışeb peyğambariyvalla haa'a. Şaulee, xhebe'es insanar g'uxoole, manbışeb peyğambariyvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Nekke qiyğa vuccar Ramayeeqa arı, Seku eyhene cigayne k'anene, xənne kahrızısqa qarı, maane insanaaşike qiyghanan: – Şamueliy Davud nyaane vob? Maane neng'veemee, «İnyaa'ab, Ramayeene Nayotee vobva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Şaul Ramayeene Nayotqa əlyhəəmee, mana Allahne Rı'hı'n aqqaqqa. Qıyğar insanaaşe Şaul Ramayeene Nayotulqa qıkkeka. Mang'veeyib peyğambariyvalla haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Qiyğa mang'vee tanalinbı qakki'ı, Şamuelyne ögiyl peyğambariyvalla haa'a. Mana bıkırne yiğnayiy xəmna ts'eler qukyork'ul axva. Mançil-alla insanaaşe eyhe: «Şaulıkerne peyğambar ıxha?» ");
INSERT INTO tkr_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Davud Ramayeene Nayoteençe hixu, Yonatanne k'anyaqa qarı eyhen: – Nya'a, zı hucoona hı'ı? Yizın taxsir hucoona? Zı yiğne dekkıs nəxbına pisvallane hav'u, mang'us zı gik'as ıkkan? ");
INSERT INTO tkr_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Yonatanee mang'us alidghıniy qele: – Məxdın kar mısacad ixhes deş! Ğu qik'as deş. Yizde dekkee nenacab iş, xəbna vuxheeyib k'ınna vuxheyib zak'le ittevhu haa'as deş. Nya'asdiyxan dekkee, mana iş zale dyugul hav'u? Məxdın kar ixhes deş! ");
INSERT INTO tkr_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Davudee mang'us k'ın g'assır, eyhen: – Zı vasqa yugra qarıynçina, yiğne dekkık'le ats'a vod. Mançil-allad dişe mang'us vak'le dyats'axhxha ıkkan. Ğu aq'va qa'asınçina mang'uk'le ats'an. Vorne Rəbbilqaniy yiğne canılqan k'ın ixhen, yizde qik'uys sa g'el qittasın ciga axu. ");
INSERT INTO tkr_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Yonatanee Davuduk'le eyhen: – Yiğne yik'es hucooyiy ıkkan, zı vas ha'asın. ");
INSERT INTO tkr_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Davudee Yonatanık'le eyhen: – G'iyqa ts'ebna vaz giviyğalan bayram vod, zı paççahıka sa sufranıl gyu'ur kar oxhanas ıkkan. Həşde ğu zı hasre, qıtsıq exhalilqamee, hark'ın çolee dyugulyxhes. ");
INSERT INTO tkr_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Yiğne dekke zı qirghın he'ee, mang'uk'le eyhe: «Davudee cune şahareeqa Bet-Lexemqa alycaxxvas ı'qqəseeva zake geed qiyghın». Maa'ab, həşde cone xizanın seniysda q'urban gyook'a. ");
INSERT INTO tkr_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Mang'vee uvheene: «Yugdavud», manke zı, yiğna nukar, yugra ixhes. De'eş, mang'us mançike qəl vuxheene, vak'le ats'axhxhe, mang'uqa kara'əən fıkırbı deşud. ");
INSERT INTO tkr_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Zas yugvalla hee'e, ğu Rəbbine ögiyl zaka cuvab g'ats'atk'un. Zal bınah vobxhee, ğucar zı gik'e. Nişil-allane vas zı yiğne dekkısqa ıkkees ıkkan? ");
INSERT INTO tkr_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Yonatanee eyhen: – Man yiğne vuk'lelqa qales deş! Yizde dekkıqa karaı'dəən fıkırbı ıxhay, zak'le g'acuynxhiy, nya'a vak'le ittevhu g'alyadaççeyiy? ");
INSERT INTO tkr_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Davudee Yonatanık'le eyhen: – Dek vaqa qəlaka yuşan he'eene, man zalqa şavaane hixhar ha'as? ");
INSERT INTO tkr_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Yonatanee Davuduk'le eyhen: – Qora çoleeqa qığeepç'es. Manbışda q'öyursana g'aqa qığeepç'ı, çoleeqa avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Qiyğa Yonatanee Davuduk'le eyhen: – İzrailyne Allahılqan, Rəbbilqan, k'ın ixhen, g'iyqayee, qıtsıqee ine gahılqasse, zak'le dekkına fıkır vaats'a vuxhesda. Mang'uqa yiğne hək'ee yugun fıkırbı ixheene, zı manbı valqa hixhar ha'asınbı. ");
INSERT INTO tkr_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","De'eş, yizde dekkıne fıkreençe karaı'dəən karbı ı'lğəə ixheene, zınad man valqa hixhar hide'eene, ğunar yəqqı'l iderçveene, hasre Rəbbee yizde vuk'lelqa mançiled pisın yiğbı alle'ecen. Hasre Rəbb yizde dekkıka nəxüriy eyxhe, vakar həməxür ixhecen. ");
INSERT INTO tkr_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Zı nimeeletteyiy vor, ğunab zak'le Rəbbina g'idyabat'ana yugvalla haagve. Zı qik'uyng'ar, ");
INSERT INTO tkr_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","Rəbbee Davudun gırgın duşmanar ç'iyene aq'vayle havaakal hav'uyleb qiyğa, mana yugvalla yizde xizanıle g'ıts'maak'vance. ");
INSERT INTO tkr_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Yonatanee Davudne nasılıka cuvab g'ats'atk'un, eyhen: – Hasre Rəbbee vucee, Davudne duşmanaaşikın he'ecen! ");
INSERT INTO tkr_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Yonatanee Davuduk'le eyhen: – Vas zı ıkkanxhee, sayid k'ın g'aysre. Davudus Yonatan cus vuc ıkkanan xhinne ıkkan ıxha. ");
INSERT INTO tkr_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Qiyğa Yonatanee Davuduk'le eyhen: – G'iyqa ts'ebne vuzan bayram alğahas. Yiğna ciga q'ərab g'avcumee, ğu t'abal ha'asda. ");
INSERT INTO tkr_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Qıtsıq ğu şenke dyugul ıxhayne cigaysqana qarı, Ezel eyhene g'ayeysne gyu're. ");
INSERT INTO tkr_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Zı karalqa ayhen xhinne, mane suralqa vukeençe xhebılle ox ahas. ");
INSERT INTO tkr_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Qiyğa «Hoora, oxbı t'abal he'eva» zı maqa sa gade g'axıles. Zı gadeyk'le uvheene: «Oxbı yiğne k'ane vod, hoora manbı zasqa qaleva», manke ğunar qora. Vorne Rəbbilqan k'ın ixhen, manke ğu g'attirxhın ixhes, vak vuççud ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","De'eş, zı gadeyk'le «Oxbı vake əq'əna'ad vodva» uvhee, ğu qığeç'u, yiğne yəqqı'n hoora. Man Rəbbee ğu əq'ənaqa g'ıxeleva eyhen vodun. ");
INSERT INTO tkr_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Zınay ğu, həşde yuşan hı'iynçilqamee qabımeeme, yik'el aqqe, Rəbb yizdayiy yiğna gırgıne gahbışiscar Şahad vorna. ");
INSERT INTO tkr_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Davud çolee dyugul eyxhe. Ts'ebne vuzan bayram giyğalang'a paççah otxhuniy oxhanasva sufranılqa giy'ar. ");
INSERT INTO tkr_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Mana ögiylin xhinne cune cigee barugusnee Yonatanne ögee giy'ar. Şaulne k'anyaqa Avner giy'ar. Davudna cigamee q'ərab aaxva. ");
INSERT INTO tkr_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Mane yiğıl Şaulee vuççud eyhe deş. Mang'usqa həməxüd qayle «Davudne vuk'lelqa hucoomecad qadı ixhes. Mançil-allad mang'un gicərxı'y atk'ın ixhes». ");
INSERT INTO tkr_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Qinne, vuzane q'öd'esde yiğılib Davudna ciga meeb q'ərab aaxva. Şaulee Yonatanıke qiyghanan: – Nya'asdiyxan Yesseyna dix Davud sanıxhar, g'iynar kar oxhanas sufranılqa qidyarı? ");
INSERT INTO tkr_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Yonatanee alidghıniy qele: – Davudee Bet-Lexemqa ı'qqəsva, zake geed qiyghın. ");
INSERT INTO tkr_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Mang'vee uvhuyn: «Hucoona ixhes, hasre zı ı'qqəs. Yişde xizanın şaharee q'urban ablyaa'a, yizde çocee zak'le maa'ar ixheva uvhu. Hucoona ixhes, zı yiğne ulen aqqıxheene, g'aykke hark'ın çocar g'avces». Mançil-alla mang'usse paççahne sufranıl arı, gyu'aras dəxı'. ");
INSERT INTO tkr_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Şaulee Yonatanılqa qəl hav'u eyhen: – İykarne zəiyfayna dix, ğu eyhenniyxan, zak'le ğu Yesseyne dixeka hambaziyvalla haa'ava ats'a dişdiyxhan. Yiğne yedisıd, vasıd naş qixhecen. ");
INSERT INTO tkr_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Nimeeletteyiy Yesseyna mana dix ine ç'iyene aq'val vor, ğunar yiğna paççahiyvallab aaxvas deş. Mang'uqa qihna insan g'axıle, hasre mana yizde k'anyaqa ayrecen. Mana qidek'u ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Yonatanee dekkıs Şaulus alidghıniy qele: – Mana nişil allane qik'as ıkkan? Mang'vee hucoona hı'ı? ");
INSERT INTO tkr_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Şaulee Yonatan gik'asva nize ayhe. Manke Yonatanılqa hiyxharan, dekkıs Davud gik'asır ıkkan. ");
INSERT INTO tkr_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Yonatan qəlın qoxa, sufranıle oza qexhena. Ts'enne vuzane q'öd'esde yiğıl Yonatanee vuççud oyxhan deş. Dekkee Davud k'ap'ik'ıle avuqa qı'ı g'acu, mang'vee aq'va givaxana'a. ");
INSERT INTO tkr_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Yonatan qinne yiğıl miç'eer Davud g'acesva çoleeqa arayle. Mang'une k'aner sa k'ınna gade eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Mang'vee gadeyk'le eyhen: – G'adaxhvne, hark'ın zı ayhen oxbı t'abal he'e. Gade g'adayxhvanmee, Yonatanee mang'une vuk'lel ooğançe ox ayhe. ");
INSERT INTO tkr_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Gade Yonatanee avhune oxasqa hiyxharmee, Yonatanee yı'q'əle onu'u eyhen: – Haaşe, ox vake şaqana vod, yiğne ögee vod! ");
INSERT INTO tkr_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Yonatanee meer gade qort'ul, eyhen: – Zaara ixhe, ulymoyzar, g'adaxhvne! Gadee ox alyaat'u, cune xərıng'usqa Yonatanne k'anyaqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Gadeys nişikecab xabar vuxha deş. Man saccu Yonatanık'leyiy Davuduk'le ats'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Yonatanee cun silahbı gadeysqa quvu, eyhen: – Hoora, inbı şahareeqa qıkkee. ");
INSERT INTO tkr_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Gade ark'ıniyle qiyğa, Davud g'ayeyne canubne suralqa qarı, q'aratsabışil gyu'ur xhebne yəqqees Yonatanne ögee ç'iyelqamee k'yoyzarna. Manbışe sana-sang'us ubbabı hı'ı, gyaaşenbı. Davud Yonatanıle geer geşşe. ");
INSERT INTO tkr_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Yonatanee Davuduk'le eyhen: – Vas yugna yəq vuxhena. Zınay ğu Rəbbine doyule sana-sang'us k'ın g'assır, uvhuynniy: Rəbb yizdeyiy yiğne, yişde uşaxaaşine yı'q'neenar gırgıne gahbışisda Şahad vorna. ");
INSERT INTO tkr_vpl VALUES ("S120_43","010_20_43","1SA","20","43","43","Mançile qiyğa Davud oza qıxha, cune yəqqı'n ayk'an, Yonatanır şahareeqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Davud Nov eyhene şahareeqa kaahin Aximelekne k'anyaqa qarayle. Davud g'acu Aximelek qərq'ı'n, qiyghanan: – Nya'a ğucar ıxha? Nya'a yiğne k'ane vuşucar deş? ");
INSERT INTO tkr_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Davudee Aximelekık'le eyhen: – Paççahee zas iş huvu uvhuyn, zı nişisiy g'axuvu, zas nena işiy huvuva neng'uk'lecad mats'axhxhecen. Zı mançil-allad yizde insanaaşik'le, zı uvhuyne cigabışee yizde ögiylqa qığeepç'eva uvhu. ");
INSERT INTO tkr_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Vaqa oxhanasın hucoona vod? Vaqa vobxhee, zas xhoble komba gıneyna hevle. Deşxheene, vaqa hucooyiy oxhanasın vod, man hele. ");
INSERT INTO tkr_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Kaahinee Davuduk'le eyhen: – Zaqa məxdıncad gıney deşin, yiğne k'anebın mek'vunbı yadaaşika devxhaxheene, muq'addasın gıney vod. ");
INSERT INTO tkr_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Davudee kaahinıs inəxdın cuvab qele: – Mısacab, şi nenemee işiqab qihna vüqqəmee, şaka yedar vuxhaynbı deş. Yizın insanar nenemecab işiqab qihna vüqqəmeeyib, manbışe tanbı məttıda havace. G'iyna manbı manisa yiğbışileb məttıba vob. ");
INSERT INTO tkr_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Rəbbis adıyne gıneyle ğayrı maa'ad medın gıney dexhayke, kaahinee mang'us muq'addasın gıney hele. Man gıney Rəbbine ögiyle alyaat'uyn ıxha, çine cigee manecad yiğıl g'ümən gik'anasva. ");
INSERT INTO tkr_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Mane yiğıl Şaulne insanaaşina sa maa'ar eyxhe. Mang'vee maa'ad Rəbbis ı'bəədat ha'a ıxha. Mana insan Şaulne çobanaaşina xərna, Edomğançena Doeg ıxha. ");
INSERT INTO tkr_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Davudee Aximelekık'le eyhen: – Deşinne vaqa inyaa nize, g'ılınc? Paççahee zak'le zaraba haa'asda iş uvhuynçil-alla, zasse yizın g'ılıncıd, silahbıd alyaat'as əxı' deş. ");
INSERT INTO tkr_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Kaahinee eyhen: – Ğu Elayne q'adaalil gik'uyne Filiştinğançene Golyatın g'ılınc vod. Man tanalinçeeqa hitk'ır kaahinne ileylığne yı'q'əl vod. Vas man ıkkanxhee aleet'e, mançile ğayrı inyaa medın deşin. Davudee eyhen: – Mançile yugun deşin, qale man zasqa. ");
INSERT INTO tkr_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Mane yiğıl Davud Şauluke hixu, Gatne paççahne Akişne k'anyaqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Akişne insanaaşe mang'uk'le eyhen: – İna şene ölkayna paççah Davud dişeene? Mık'ar ha'amee yadaaşee ing'une hək'ee dişdiy qədəqqə: «Şaulee aazırbışika, Davudeeme, yits'ne aazırbışika gyapt'ı»? ");
INSERT INTO tkr_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Davuduk'le man eyhenbı g'ayxhımee, mana Gatne paççahıle, Akişile qəyq'ən giyğal. ");
INSERT INTO tkr_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Davudee vucecar-vuc manbışde ögiyl bəç'ər xhinne hagva, mang'vee beynyava karbı ha'a, qıç'ekku akkayk cıgabı hı'ı, rixhybı saqqalılqa gekka. ");
INSERT INTO tkr_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Akişee cune insanaaşik'le eyhen: – Şok'le g'ecen mana insan bəç'ərır. Nişisne şu mana zasqa arı? ");
INSERT INTO tkr_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Zaqa bəç'ərarne k'ılyba, şu inar zasqa bəç'əriyvalla haa'as arı? İnəxrına insan yizde xaaqa ikkeç'es eyxheye? ");
INSERT INTO tkr_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Davud mançe qığeç'u, Adullamne mağaree dyugul eyxhe. Mang'une çocaaşik'leyiy dekkıne xizaneene mansabışik'le man g'ayxhımee, gırgınbı sabı, mang'usqa abayle. ");
INSERT INTO tkr_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","I'mı'r yı'q'bananbı, borcbınanbı, hooç'an-g'ooç'ananbı, gırgınbı Davudusqa savayle. Mana manbışda xərna eyxhe. Mang'une k'ane yoq'ud vəşilqa (400) ələəna insan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Davud mançe Moavne Mitspa şahareeqa arı, Moavne paççahık'le eyhen: – Hucoona ixhes, Allahee zak ha'asın ats'axhxhesmee, dekkiy yed abı, vuşde k'ane aaxvecen. ");
INSERT INTO tkr_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Davudee manbı Moavne paççahne k'ane g'alyaa'a. Manbı maa'ab, Davud dyugulyxhayne xıl hidixharasde cigeençe qığeç'esmee, aaxva. ");
INSERT INTO tkr_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Qad peyğambaree Davuduk'le eyhen: – Ğu ine dyugulyxhayne cigee ımaxva, Yahudayne cigabışeeqa hoora. Davud mançe ark'ın Xeretne ç'alageeqa ikkeç'e. ");
INSERT INTO tkr_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Şauluk'le g'iyxhen, Davudıy cukan insanar aveekiynbı. Mang'una çadır Giveayeene sa tepal, tamarisk eyhene yivek avub güvxü. Şaul maa xılead nize aqqı, gyu'ur ıxha. Mang'un gırgın insanarıb cune hiqiy-alla sabı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Şaulee cune hiqiy-alla sabıyne insanaaşik'le eyhen: – Benyaminaaşenbı, həşde zal k'ırı alixhxhe. Nya'a, Yesseyne dixee, Davudee, vuşde gırgıng'us çolbıyiy t'ımıllığbı helesınbıne? Nya'a, mang'vee vuşun gırgınbı – vəşı'ng'un, aazırıng'un k'omandirar haa'asınbıne? ");
INSERT INTO tkr_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Dişene, vuşun gırgınbı zalqa dyugulenba g'elil qeepxha? Yizde dixee Yesseyne dixeka cuvab g'ats'ayk'vanmee, şavaacad zalqa hixhar hı'ı deş. Vuşde neg'veecab yizda hav'u deş. G'iyniyn xhinne yizde dixee, yizde nukarıs dyugulxhayne cigeençe zalqa g'ok'alas xər qa'a. Man şu zalqa hixhar hı'iynne? ");
INSERT INTO tkr_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Şaulne insanaaşine k'ane ulyorzulyne Edomğançene Doegee Şauluk'le eyhen: – Zak'le Yesseyna dix, Nov eyhene şaharee, Axituvne dixene, Aximelekne, k'anyaqa arıyng'a g'acu. ");
INSERT INTO tkr_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Aximelekee mang'unemee Rəbbike qiyghın. Sayid mang'vee Davudus otxhuniyiy Filiştinğançene Golyatın g'ılınc huvu. ");
INSERT INTO tkr_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Paççahee Axituvne dixene, kaahin Aximelekneyiy mang'une xizanne, Novee vooxhene avxuyne kaahinaaşine qihna insan g'ıxele. Manbışin gırgınbı paççahısqa abaylenbı. ");
INSERT INTO tkr_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Şaulee eyhen: – Axituvna dix, həşde zal k'ırı alixhxhe. Aximelekee eyhen: – Yizda xərna, k'ırı iliyxhe vod. ");
INSERT INTO tkr_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Şaulee mang'uk'le eyhen: – Nya'a ğunayiy Yesseyna dix zalqa g'elil qeepxha? Ğu Allahıke mang'unemee qiyghın. G'iyniyn xhinne zalqa g'elil qa'asdemee, Yesseyne dixene xılyaqa gıneyiy g'ılınc huvu, nya'a zas gugu hav'u? ");
INSERT INTO tkr_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Aximelekee paççahık'le eyhen: – Yiğne gırgıne insanaaşee Davud xhineena yı'q' qizarasda vornane? Mana paççahna yezne eyxhe, yiğne g'aravulyçeeşinar xərna, yiğne xaayir mana geer hı'rmatnana insan vor. ");
INSERT INTO tkr_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Zı ts'ette deş mang'unemee Allahıke qiyghan. Hasre paççahee zalqa, cune nukarılqa, cune nukarne xizanılqa bınah givmiyxhecen. Mançike zas k'ınna vuxheeyib xabar vuxha deş. ");
INSERT INTO tkr_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Paççahee eyhen: – Aximelek, ğunar, yiğne xizanın gırgınbı hapt'as vukkan. ");
INSERT INTO tkr_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Paççahee cune hiqiy-alla ulyobzurne g'aravulyçeeşik'le eyhen: – Hapk'ın Rəbbin kaahinar gyapt'e. Manbı Davuduka sapçı. Manbışik'le Davudun hixuy g'ayxhı, zalqa hixhar hı'ı deş. Paççahne g'aravulyçeeşis Rəbbine kaahinaaşilqa xıl g'ot'alas, manbı gyapt'as vukkiykan deş. ");
INSERT INTO tkr_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Paççahee Edomğançene Doegık'le eyhen: – Hoora, man kaahinar gyapt'e. Edomğançena Doegır hark'ın, man kaahinar gyabat'anbı. Mane yiğıl mang'vee, katanıke ileylığ ali'ına molyts'ale xhoyre (85) kaahin gek'a. ");
INSERT INTO tkr_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Qiyğa mang'vee kaahinaaşina şaharıb, Novıb, g'ılıncıke alğaahana. Mang'vee maabın gırgın adamer, yedar, uşaxar, gyooqanbı, yatsbı, əməler, vəq'əbı g'ılıncıke alğaa'a. ");
INSERT INTO tkr_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Axituvna neva, Aximelekna dix Evyatar hixu, Davudusqa qarayle. ");
INSERT INTO tkr_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Evyataree, Şaulee Rəbbin kaahinar gyapt'ıva Davudus xabar abayle. ");
INSERT INTO tkr_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Davudee Evyatarık'le eyhen: – Şene ögiyl Edomğançena Doeg zak'le şaa'ar g'acumee, ats'anniy mang'vee gırgın Şaululqa hixhar ha'as ıxhay. Yiğne dekkına xizan gyapt'ıyna bınah zal vobna. ");
INSERT INTO tkr_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Yizde k'ane axve, qı'məyq'ən, yizın can alişşes ıkkanang'us yiğınıd can alişşes ıkkan. Yizde k'ane axvee, vak vuççud ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Davudus xabar abayle: – Filiştinar Qeilalqa k'yoptul, maadın attabı vod q'əra qa'a. ");
INSERT INTO tkr_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Davudee Rəbbike qiyghanan: – Hark'ın Filiştinaaşika səyxene? Rəbbee Davuduk'le eyhen: – Hudoora k'yootle, Filiştinaaşike Qeila g'attivxhan hee'e. ");
INSERT INTO tkr_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Davudne insanaaşemee, Davuduk'le eyhen: – Şi inyaa'acab, Yahudayne cigabışeecab q'əvəyq'ən. Filiştinaaşde Qeilayeene g'oşunbışde ögeeqa şi nəxübne qığeepç'es? ");
INSERT INTO tkr_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Davudee meed Rəbbike qiyghan, Rəbbeeyid mang'uk'le eyhen: – Oza qıxha Qeilayeeqa hak'ne. Zı Filiştinar yiğne xılyaqa qevles. ");
INSERT INTO tkr_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Davudun insanar Qeilayeeqa hapk'ın, maane Filiştinaaşilqa k'yoohar. Manbışin çavra-vəq'ə Davudee g'ahayşu qıkkekkan. Davudee Filiştınbışilqa ver ablyav'u, Qeilayn millet g'attixhan ha'an. ");
INSERT INTO tkr_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","(Mançile oğiylid Aximelekne dixee Evyataree Qeilayeeqa Davudne k'anyaqa g'adayxhvan qöömee, kaahinaaşin ileylığ adayle.) ");
INSERT INTO tkr_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Davud Qeilayeeqa arıva Şaululqa hixhar ha'an. Şaulee eyhen: – Allaheecar mana yizde xılyaqa quvu. Mana ç'ak'ın akkabınaneyiy sat'ulbınane şahareeqa ikkeç'u, vucee cun ögü ı'xı'. ");
INSERT INTO tkr_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Şaulee Qeilayee Davudıy cukan insanar avqasva, gırgına g'oşun dəv'əys sa'a. ");
INSERT INTO tkr_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Davuduk'le Şaulee cuk qəlasın ha'as ıxhay ats'anniy. Mang'vee kaahin Evyatarık'le eyhen: – Kaahinaaşin ileylığ inyaqa qale. ");
INSERT INTO tkr_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Davudeecad meed sak'ı, eyhen: – İzrailyna Allah eyxhena, Rəbb, zak'le g'ayxhiyn, zal-alla Şaulus Qeilayeeqa arı şahar q'əra qaa'asıb vukkan. ");
INSERT INTO tkr_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Qeilayne milletın zı mang'une xılyaqa qelesdaniyxan? Zak'le, Yiğne nukarık'le, g'ayxhiyn ixhesınne, Şaul inyaqa ayresdane? İzrailyna Allah eyxhena, Rəbb, hucoona ixhes, man zak'le eyhe. Rəbbee «Mana ayresdava» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Mane gahıl Davudee meed qiyghanan: – Qeilayne milletın, zınayiy yizın insanar mang'une xılyaqa qevlesınbıniyxan? Rəbbee «Qevlesınbıva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Davud yixhıd vəşşılqa (600) ələəne insanıka Qeilayeençe qığeç'u, inyaa-şa axva giyğal. Davud Qeilayeençe hixu ark'ınnava, Şaululqa hixhar hı'ımee, mang'vee cuna fıkır badal haa'ana, maqa hayk'an deş. ");
INSERT INTO tkr_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Davud xılyaqa gidexhasde xhinene cigabışee, Zif eyhene sahrayne tepabışee axva eyxhe. Şaulee mana yiğıscar t'abal ha'a ıxha, Allaheemee Davud mang'une xılyaqa gixhas haysar deş. ");
INSERT INTO tkr_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Davud Zifne sahreene Xoreşnang'a mang'uk'le g'iyxhen, Şaulee vucur gik'asva t'abal ha'a. ");
INSERT INTO tkr_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","Şaulna dix Yonatan Xoreşeeqa Davudne k'anyaqa arı, mang'us Allahne doyule yik'bı hele. ");
INSERT INTO tkr_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","Davuduk'le mang'vee eyhen: – Qı'məyq'ən, yizde dekkıne Şaulne xılyaqa ğu gixhas deş. Ğu İzrailyna paççah ixhes, zınar vale qiyğiyna q'ör'esda insan. Man yizde dekkık'le Şauluk'led çikana ats'an. ");
INSERT INTO tkr_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Qiyğa manbışde q'öng'eesana sana-sang'us Rəbbine ögiyl cuvab hele. Mançe Yonatan ayk'anna xaaqa, Davudur Xoreş axva. ");
INSERT INTO tkr_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Zifğançenbı Giveayeeqa Şaulusqa abı, eyhen: – Davud yişde k'anene, Yeşimonne canubılyne Xakilayne tepalyne Xoreşee xıl hidixharasde cigabışee dyugulyxha vor. ");
INSERT INTO tkr_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Paççah, vas mısayiy ıkkan, maqa ayre, şicar aqqı mana yiğne xılyaqa qelesda. ");
INSERT INTO tkr_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Şaulee eyhen: – Zas yugvalla hav'uynçil-alla, Rəbbee şos barakat helecen. ");
INSERT INTO tkr_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","Sayıb hapk'ın yugda ats'axhxhe, mang'vee g'el nyaqayiy gixhxhı, şavuk'leyiy mana maa'ar g'acu. Zak'le mana süvə xhinnena insan vorva g'ayxhı. ");
INSERT INTO tkr_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","Mana dyugulexhen cigabı gırgınbı ats'axhxhe, yugda ats'axhxhad, zasqa savk'le. Zınar maqa şoka ı'qqəsda. Mana nimeletteyiy ine ölkee Yahudee, zı mana gırgınəəng'ə t'abal ha'asda. Mana inçeğana ixheene, mana zı Yahudavolle gırgınəəng'ə t'abal ha'asda. ");
INSERT INTO tkr_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Zifğançenbı oza qeepxha Şaulne ögee Zifqa avayk'an. Davudıy cun insanar Yeşimonne canubılyne, Arava eyhene cigayne Maonne sahree vuxha. ");
INSERT INTO tkr_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Şaulıy cun insanar mana t'abal ha'asva, mane cigeeqa havayk'an. Man Davudulqa hixhar hı'ımee, mana ganznane cigeeqa qarı, Maonne sahree ulyoyzar. Şauluk'le man ats'axhxhamee, Maonne sahree Davuduqar qihna gexha. ");
INSERT INTO tkr_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Şaul cune insanaaşika suvane ine surale, Davudur cune insanaaşika suvane şene surale əlyhəə vooxhe. Davudus, Şaulıle hixu, dyugulyxhes ıkkiykan. Şaulusmee mang'un ögü ı'xı', mana aqqas ıkkiykan. ");
INSERT INTO tkr_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","Mane gahıl Şaulusqa xabar ana sa insan arı eyhen: – Zaara ixhe, yı'q'əlqa sak'le, yişde ölkalqa Filiştinar k'yoptul. ");
INSERT INTO tkr_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Şaulee, Davuduqa qihna girxhuy g'aletçu, mançe ayk'anna Filiştinaaşika səyxəs. Mançil-alla mane cigays Sela-Hammaxleqotva (Curepxhayn Ganz) do giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Davud mançe En-Gedi eyhene cigeene xıl hidixharasde cigabışeeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Şaul Filiştinaaşikar qihna girxhu, mançe yıq'əlqa qöömee, mang'uk'le eyhen: – Davud En-Gedi eyhene sahree vor. ");
INSERT INTO tkr_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Şaulee İzrailğançe xhebıd aazır yugra sıc'ekvana insan cuka qort'ul, Davudıy mang'un insanar t'abal haa'asva suvayn ts'e'bı uxiyxhanne suvabışeeqa hayk'an. ");
INSERT INTO tkr_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Mana qaraylena yəqqı'ne mıglekne vəq'əbı akkya'ane cigaysqa. Maa'ab mang'uk'le mağara g'avcu, g'eline yəqqı'sva maqa ikkeç'e. Davudıy mang'un insanarıb mane mağaree aqana gyuv'ur vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Davudne insanaaşe mang'uk'le eyhen: – Rəbbee vak'le eyhen yiğ haane: «Yiğna duşman yiğne xılyaqa qeles, vas hucooyiy ıkkan he'e». Davud dyugulenra Şaulusqa qıxha mang'une tanalinçın siv gyadaxa. ");
INSERT INTO tkr_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Şaulne tanalinçın siv gyatxıva, Davudun mang'uqa yik' gyoyxhan. ");
INSERT INTO tkr_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Mang'vee cune insanaaşik'le eyhen: – Rəbbee g'əyxiyne yizde xərıng'ulqa xıl g'ot'ul məxbına iş hav'uy Rəbbee zake əq'əna qee'ecen. Mana nya'a, Rəbbee g'əyxı'na dişde vor? ");
INSERT INTO tkr_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Məxüd uvhu Davudee cune insanaaşin ögü ı'xı', Şaululqa k'yumootalcenva. Şaulur mağareençe qığeç'u cune yəqqı'n ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Mançile qiyğa Davud, Şauluqa qihna mağareençe qığeç'u, mang'ulqa onu'u eyhen: – Yizda xərna, paççah! Şaul sak'ı yı'q'əlqa ilyakkımee, Davud mang'us aq'va ç'iyek qet'asmee k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Mang'vee Şauluk'le eyhen: – «Davudus yiğın yugun ıkkan deşva» eyhene insanaaşine cuvabıl nya'a ğu k'ırı iliyxhe? ");
INSERT INTO tkr_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","G'iyna vak'le yiğne uleka g'acu, Rəbbee ğu mağaree yizde xılyaqa quvu. Zı ittunçiliy aqqaqqa, ğu gik'ecenva, yizdamee valqa rəhı'm qabı. Zı manbışik'le uvhuyn «Zı yizde xərıng'ulqa xıl g'ot'alas deş, mana Rəbbee g'əyxı'na paççah vorna». ");
INSERT INTO tkr_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Dek, haane ilekke, yizde xılene yiğne tanalinçine siveqa. Yiğne tanalinçin siv gyatxeeyid, zı ğu gik'u deş. Vak'le g'ace, ats'axhxhe, vas qəlasın ha'asıd, valqa insanar g'elil qaa'asıb yizde xılençe qöö deş. Zı yiğne ögiyl bınah hav'u deş, vas meer zı gik'as ıkkan. ");
INSERT INTO tkr_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Zasiy vas Haakim hasre Rəbb Vuc ixhecen! Zal-alla hasre Mang'vee vakın he'ecen. Zı valqa xıl g'ot'alas deş. ");
INSERT INTO tkr_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Avaala inəxüdniyxhe eyhen: «Qəlnang'vee qəlasın ha'a». Mançil-allad zı valqa xıl g'ot'alas deş. ");
INSERT INTO tkr_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Şavulqayiy İzrailyna paççah ı'qqə? Ğu şavuqa qihnane girxhu? Qivk'una xvaane g'ohooşe, deşxhee, genane? ");
INSERT INTO tkr_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Zasiy vas haakimiyvalla havaasre Rəbbee Vucee hee'ecen. Hasre Mana Vuc ilekkecen yizde işiqa. Hasre Rəbbee, Vuce zı yiğne xılençe g'attixhan hı'ı, zı qorkurava hagvecen. ");
INSERT INTO tkr_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Davudee man uvhu ç'əvxhamee, Şaulee qiyghanan: – Yizda dix Davud, yuşan ha'ana mana ğune vor? Manıd qiyghın, Şaul axtıra geşşe giyğal. ");
INSERT INTO tkr_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Qiyğa mang'vee Davuduk'le eyhen: – Zı ğu xhinne qorkuna deş vor, zı vas yugvalla hidyaa'ameeyib, ğu zas yugvalla hav'u. ");
INSERT INTO tkr_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Ğu g'iynar zaka yugra ıxha, Rəbbee, zı yiğne xılyaqa quvuyng'ar, ğu zı gik'u deş. ");
INSERT INTO tkr_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Şavaa cuna duşman aveykımee, vuççud hidyı'ı, g'ekkayiy? Hasre ğu g'iyna zak hı'iynçil-alla, Rəbbee vas yugun helecen. ");
INSERT INTO tkr_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Zak'le ats'an, vake İzrailyna paççah ixhes. İzrailyna paççahiyvalla yiğne xılyaqa ılğevç'umee, ğu mana xılya'ab it'umba avqas. ");
INSERT INTO tkr_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Zale qiyğa yizda nasıl g'itsdyaak'vanasva, zake g'abıynbı gidyapt'asva, həşde ğu zas Rəbbilen k'ın g'assre. ");
INSERT INTO tkr_vpl VALUES ("S124_23","010_24_23","1SA","24","23","23","Davudee, Şaulus k'ın g'iysar. Mançile qiyğa Şaul ayk'anna cune xaaqa. Davudıy cun insanarıb xıl hidixharasde cigeeqa ılqeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Şamuel qik'umee gırgın İzrailybı sabı, mang'us ak' avqaaqqa. Mana Ramayee cune xaane k'ane k'eyxha. Davudmee mançe Paran eyhene sahreeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","Maoneençena sa insan, Karmel eyhene şaharee geed karnana insan ıxha. Mang'uqa xhebıd aazır vəq'ə, aazırıb ts'e' vooxhe. Mang'vee vəq'əbı Karmel qoyşar ıxha. ");
INSERT INTO tkr_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","Mane insanın do Naval, cune xhunaşşeynıd Avigail ıxha. Mang'una xhunaşşe geer ək'elikana, micagna yixha. Kalevne nasıleençena cena adamiymee geed yı'q'ı'n xasyatnana, qı'çına sa ıxha. ");
INSERT INTO tkr_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Davuduk'le sahreenang'a, Navalee vəq'əbı qoyşarva g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Mang'vee cuna yits'ıyre mek'vna insan g'axuvu, manbışik'le eyhen: – Karmelqa, Navalısqa ılqeepç'ı, zalena salam hivxhar hee'e. ");
INSERT INTO tkr_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","Mang'uk'le eyhe: «Xıliyna ı'mı'r haa'ana! Yugra ixhena! Ğunayiy yiğın xav, yiğınbışin gırgınbı yugvalybışeecab vuxhenbı! ");
INSERT INTO tkr_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Zak'le g'ayxhiyn ğu vəq'əbı'e qoyşar. Yiğın çobanar yişde k'anenang'a, şi manbışik soot'u deş. Manbı Karmel vuxhaylette, manbışin vuççud agu deş. ");
INSERT INTO tkr_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Man vasse yiğne nukaraaşiked qidghın ha'as əxə, manbışe cocad vas gırgın yuşan ha'asın. Həşde, hucoona ixhes, yizde mek'vne insanaaşika yugra ixhe, manbı vasqa bayramne yiğıl abı. Hucoona ixhes, şas, yiğne nukaraaşisiy yiğne dixes Davudus vaqa vodunçike vasse əxənmeen hele». ");
INSERT INTO tkr_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Davudun mek'vun insanar Navalısqa abı, Davudee cok'le uvhuyn gırgın mang'us yuşan ha'an. Qiyğad mang'vee hucoovayiy eyhesva, k'ane ulyoozar. ");
INSERT INTO tkr_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Navalee manbışis inəxdun alidghıniy qele: – Vuşune vor mana Davud? Vuşuna Yesseyna dix? Həşde cone ç'ak'ınbışisse heebaxan nukarar geeb qeepxha. ");
INSERT INTO tkr_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Vuşde uvhiyn, zı həşde gıneyke, xhineke, vəq'əbı qoyşaranbışisva gyatt'uyne həyvanaaşine çurunuke alyaat'u, şosne heles? Zak'le şu nençe vuxhaycad ats'a deş. ");
INSERT INTO tkr_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Davudun insanar xıl q'ərab cone yəqqı'n yı'q'əlqa sapk'ıl, şeng'vee uvhuyn gırgın Davudus yuşan ha'an. ");
INSERT INTO tkr_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Davudee cune insanaaşik'le «Gırgıngvee yı'qəqqa g'ılıncbı qe'eva» eyhe. Manbışde gırgınbışed yı'qəqqa g'ılıncbı qa'anbı. Yoq'ud vəş (400) insan Davuduqar qihna ayk'an, q'öd vəşir (200) coqa vonne karaka axva. ");
INSERT INTO tkr_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Navalne nukaraaşine sang'vee mana gaf, mang'une xhunaşşeys, Avigailıs, hivxhar haa'a: – Davudee, yişde xərıng'us salam hevlesva, cun insanar sahreençe g'axuvu. Yişde xərıng'veeme, manbışik'le ghalyaqa qadıyn uvhuyn. ");
INSERT INTO tkr_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Mane insanaaşe şas geeb yugvalla hav'u. Manbı şak mısacab soot'ıynbıb deş. Şi çolee sacigee vuxhayletteb, yişin vuççud aguyn deş. ");
INSERT INTO tkr_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Şi manbışde k'ane vəq'əbı uxhiyxhan ha'ang'a, xəmdeb yiğniyığınıb suvayne yı'q'əl xhinne vuxha. ");
INSERT INTO tkr_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Vasse hucooyiy ha'as əxəva, həşdiyle meer ğucar ilekke. Yişde xərıng'uned, mang'une xaane gırgıng'uned vuk'lel yığ höö vod. Mana Naval geer karaı'dəəna, şavussecad cuvab eyhes dəxəna insan vor. ");
INSERT INTO tkr_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Avigail zaara oza qiyxha, q'öd vəş (200) gıney, q'ölle çaxıren tuluğ, xholle vəq'əyn laşşag, sa xəbna qootsuyne sukuna maşuk', vəş ts'ets' qeqquyne t'ımılena, q'öd vəş t'exa qeqqu'ıyne incileeşin sı'ı, əməleeşilqa iliyxhe. ");
INSERT INTO tkr_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Qiyğad nukaraaşik'le eyhen: – Şu ögee hudoora, zınar yı'q'əle qiyeelesda. Cene adamiyk'le, Navalık'lemee, məng'ee vuççud eyhe deş. ");
INSERT INTO tkr_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Avigail əməlelqa aliyxı, suvayle gəəmee, mana g'eece yixha deş. Məng'ı's Davudıy cun insanar sayangaba qızaaxa. ");
INSERT INTO tkr_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Davudee eyhe ıxha: – Nişisniy zı mang'une çoleene çavra-vəq'əyqa imiygvalycenva, ilyakka. Mang'vee zı hav'une yugvalis pisvalla hav'u. ");
INSERT INTO tkr_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Miç'eerilqasse Navalne insanaaşina sa adamiyxheyir zı üç'ürra g'alerçvee, hasre Allahee Davuduk mançile pisın he'ecen. ");
INSERT INTO tkr_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Avigailik'le, Davud g'aciykum, mana zaara əməleyle giyç'u, Davudus aq'va ç'iyek qet'asdemeene cigeeqa k'eezarna. ");
INSERT INTO tkr_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Qiyğar mang'une g'elybışeeqa qukkyork'ul eyhen: – Yizda xərna, havaasre mançina bınah zal vuxhecen. Həşde, hucoona ixhes, zı, yiğna nukar, vaka yuşan hee'es hiyeesre. Zı eyhençil k'ırı gyaqqe. ");
INSERT INTO tkr_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Mane karaı'dəəne insanın, Navalın cuvab, ğu yik'eeqacad ıkmekka. Mana, cun do xhineenacar vor. Mang'un do Naval (bəç'ər) vod, vucur do xhineenacar bəç'ər vor. Yizda xərna, zak'lemee, yiğne nukarık'le, ğu g'axuvuyn insanar g'avcucab deş. ");
INSERT INTO tkr_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Yizda xərna, Rəbbine doyuleyiy yiğne canalen zı k'ın g'iysar: ğu Rəbbee qəlas eb k'yav'uyke havacı. Hasre yiğne duşmanaaşikıd, valqa yiğbı allya'as ıkkananbışikıd Navalne vuk'lelqa qadıyn qoracen. ");
INSERT INTO tkr_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Zı vas adıyn karbı həşde hasre vaqa qihna qööne yiğne insanaaşisqa qeles. ");
INSERT INTO tkr_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","Hucoona ixhes, yizde bınahıle ilyheç'e! Zak'le ats'a vod, vas Rəbbee yugna nasıl hevles, ğu Rəbbina dəv'ə vukkekka. Hasre ı'mı'rvolle vaqa nəxbınacab qəl mooxhecen. ");
INSERT INTO tkr_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Şavusmee ğu g'eheşşes, gik'as ıkkiykınee, yiğna ı'mı'r Rəbb Allahee Cune yut'elee havaaces. Yiğne duşmanaaşina ı'mı'rmee, Mang'vee sapandeençe aahana g'aye xhinne aahas. ");
INSERT INTO tkr_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Rəbbee vas Vucee eyhen gırgın yugvalybı ha'amee, ğu İzrailyna paççahna alğayhemee, ");
INSERT INTO tkr_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","ğu eyhes deş: «Zı nişiscabniy qəl mang'uke qığaaha, merıng'una eb k'yaa'a, həşde mançike yizın yik' gyotxhan». Rəbbee vas yugvalla haa'amee, yiğna nukar, zı, yik'eliyxan himee'e. ");
INSERT INTO tkr_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Davudee, Avigailik'le eyhen: – İzrailyne Allahıs, Rəbbis, g'iyna ğu yizde ögiylqa qığeyhıva, şukur vuxhena. ");
INSERT INTO tkr_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Ək'elikana iş g'avcuva, hasre Rəbbee vas xayir-düə hevlecen! G'iyna ğu, zı eb k'yav'uyke, yizde xılekacab qəl qığavhuyke g'attixan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Rəbbee zı şoke qəl qığavhuyke havacı. İzrailyne Allahılqa Vorne Rəbbilqan k'ın ixhen: ğu zaara ı'ğiykır, yizde ögiylqa ittyarınaxhiy, miç'eerilqasse Navalne xaane adameeşina sacar axvas deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Davudee, məng'ee adıyn karbı xılyaqa alyaat'u, eyhen: – Ğu geer qee'ena, həşde oşeday xaaqa sayk'le. Haane, zı yiğne cuvabıl k'ırı alixhxhı, ğu uvhuyn hı'iyn. ");
INSERT INTO tkr_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Mançe Avigail Navalısqa siyk'al. Navalne xaa paççahne xaadın xhinnen otxhun-ulyodğiy eyxhe. Mana geed ulyodğiyke kefaka eyxhe. Miç'eediy qıxhesmee, xhunaşşee mang'uk'le vuççud eyhe deş. ");
INSERT INTO tkr_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Miç'eer Naval culqa qarımee, xhunaşşee mang'us gırgın yuşan ha'an. Navalne yik'eeqa ık'ar qayle, mang'un tan ittehesu g'ayelqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Ooğançe yits'ılle yiğ kara ılğeç'umee, Rəbbee Navalıkın ha'an, mana gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Davuduk'le Naval qik'uva g'ayxhımee, eyhen: – Zı tesser hı'iyne Navalıke, yizda qəl qığavhuyne Rəbbis şukur vuxhena. Mang'vee zas, Cune nukarıs, Navalıke qəl qığaahas hapsır deş. Navalna qəl Rəbbee Navalıke cuke qığavhu. Qiyğa Davudee cun insanar Avigailisqa gaxuvu, cus xhunaşşe yixheva eyhe. ");
INSERT INTO tkr_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","Davudun insanar Karmelqa, Avigailyne k'anyaqa abı eyhen: – Davudee, ğu cus hee'esva, şi inyaqa g'axuvu. ");
INSERT INTO tkr_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Avigail ç'iyek qeet'asdemeene cigeeqa k'yorzul, eyhen: – Haane zı, yiğne nukaree, vasıb k'ılyvalla ha'asda, yiğne nukaraaşin g'elybıd hoğalasınbı. ");
INSERT INTO tkr_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Mana zaara oza qiyxha əməlelqa ileexa. Ces nukariyvalla haa'ana xhoyre mek'vna zəiyfar qort'ul, mana Davudne insanaaşiqa qihna iyeek'an, mang'us xhunaşşe yixhes. ");
INSERT INTO tkr_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","Davudee İzre'elyğançena Axinoamır hey'ı yixha. Mana q'öyursana Davudun xhunaşşer vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Şauleemee, cuna yiş Davudna xhunaşşe yeexhena Mikal, Gallim eyhene şahareençene Layişne dixes Paltiys hiyvu yixha. ");
INSERT INTO tkr_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Zifğançenbı Giveayeeqa, Şaulne k'anyaqa abı eyhen: – Davud Yeşimonne şene aq'valyne Xakila eyhene tepal dyugul eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Şaulee, Davud t'abal ha'asva xhebır aazır g'əyxı'na İzrailyğançena insan qort'ul, manbışika sacigee Zifne sahreeqa geç'e. ");
INSERT INTO tkr_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Mang'vee, Yeşimonne şene aq'valyne Xakila eyhene tepal yəqqı'ne mıglek zastava giviyxhe. Sahree axvane Davuduk'le, Şaul cuqar qihna qöö g'ecena. ");
INSERT INTO tkr_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","Davudee cun insanar dyugulenba g'axuvu, hək'erar Şaul arıy ats'axhxha. ");
INSERT INTO tkr_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Mana Şaulee zastava gyuvxiyne cigeeqa arayle. Maa'ar Davud, Şauliy g'oşunna xərna Nerna dix Avner g'alyabak'ane cigayqa ilyakka. Şaul vuc zastavayne yı'q'nee g'alirxhu eyxhe. Eskeraaşe cosun cigabı mang'une hiqiy-alla qa'a. ");
INSERT INTO tkr_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Davudee Q'etbışda eyxhene Aximelekıkeyiy Yoavne çocuke Tseruya donane zəiyfayne dixeke Avişayke qiyghanan: – Vuşune zakasana Şaulne k'anyaqa, zastaveeqa ı'qqə? Avişayee «Zı vaka g'iç'esdava» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Davudıy Avişay zastavaysqa xəmde qabı hiviyxhar. Manbışik'le Şaul zastavayne ar g'alirxhu g'ece, cun nized cune vuk'lene k'anyaqacad k'exı eyxhe. Avneriy eskerar cune hiqiy-alla g'alyapk'ı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Avişayee Davuduk'le eyhen: – G'iyna Allahee yiğna duşman yiğne xılyaqa quvu. Həşde ğu zasqa hasre mana nizeyka ı'xı' ç'iyek at'iq'an ha'as. Q'öd'es ı'xəsıd ıkkiykanas deş. ");
INSERT INTO tkr_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Davudee Avişayk'le eyhen: – Mana gimek'a! Rəbbee g'əyxı'yng'ulqa xıl g'ot'uluyng'ukun Rəbbeecad ha'asın. ");
INSERT INTO tkr_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Davudeecad meed eyhen: – Vorne Rəbbilqa k'ın ixhen, Rəbbee mang'ukun hidyı'ı g'alerçes deş. Mana vuccarme qik'as, deşxhee, dəv'eeme gik'as. ");
INSERT INTO tkr_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Rəbbee g'əyxı'ng'ulqa xıl g'ot'uluyle, Rəbbee Vucee zı havacecen. Hucoona ixhes, həşde ğu mang'une vuk'lene k'anedın nizeyiy parç aleet'e, əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Davudee Şaulne vuk'lene k'anedın nizeyiy parç alyaat'u, mançe avayk'ananbı. Manbı şavuk'lecab g'avcu deş. Manbışe ha'anıd şavuk'lecad ats'axhxhe deş, vuşucarır muğur qexhe deş. Rəbbee manbışilqa it'umun nyak' salat'ı'ıva, manbı g'alyapk'ı vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Davud şene suralqa ılğeç'u, əq'ənane tepayne q'omaqa ılqeç'e. Manbışde yı'q'nee xılece yəq vuxha. ");
INSERT INTO tkr_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Davudee, milletılqayiy Nerne dixelqa Avnerılqa ts'ir haa'a: – Avner, zas alidghıniy qele! Avneree alidghıniy qele: – Ğu vuşune eyxhe, paççah muğur qa'a? ");
INSERT INTO tkr_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Davudee Avnerık'le eyhen: – Ğu adamiy dişde vor? İzrailee vak akarana vuşune vor? Nya'a ğu yiğne xərıng'uqa paççahıqa ilydyakka? Milletıkena sa insan yiğna xərna, paççah gik'asvayiy arı. ");
INSERT INTO tkr_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Ğu valqa gyooxhana yugba haa'a deşub. Vorne Rəbbilqan k'ın ixhen, vuşun gırgınbı hapt'asın karbı vob, Rəbbee g'əyxı'ng'uqa ilyaaka deşub. İlekkende, paççahne vuk'lene k'anedın nizeyiy parç həşde nyaadiy? ");
INSERT INTO tkr_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Şauluk'le Davudun ses qıvaats'ı, eyhen: – Yizda dix Davud, yuşan ha'ana ğune vor? Davudee eyhen: – Ho'o, zı vorna, yizda xərna paççah. ");
INSERT INTO tkr_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Qiyğa vuceecad meed eyhen: – Nya'a, yizda xərna zaqar qihna girxhu? Nya'a, zı hucoone hı'ı? Yizda bınah hucoone? ");
INSERT INTO tkr_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Hucoona ixhes, həşde zal, yiğne nukarıl k'ırı alixhxhe? Zalqa ğu g'elil qı'ına Rəbbxheene, zı Mang'us q'urban ablyaa'as. De'eş, man insanaaşe hı'ıxhee, hasre manbı Rəbbine ögiyl g'ulyootlecen! Manbışe Rəbbike gexhan zı ılymat'acenva zı g'e'eşşuna. Həşde zasse yizde Allahıs ı'bəədat ha'as əxə deş. ");
INSERT INTO tkr_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Hımaasar yizda eb Rəbbike əq'ənane cigabışee k'yavaak'anas. Suvabışee nəxübiy g'ön üvxəsva alycaaxva, həşde İzrailyna paççahır həməxür zı gena xhinne ı'xəsva qığeç'u. ");
INSERT INTO tkr_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Şaulee eyhen: – Yizda dix Davud, zı bınah hav'u, sak'le. G'iyna yizda ı'mı'r yiğne ulesqa gıranba qabıynçil-alla, zı vas sayid pisın ha'as deş. Ək'elydeşiyvalla hav'u, zı xəbna bınah hav'u. ");
INSERT INTO tkr_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","Davudee eyhen: – Paççah, yiğın nize haane! Hasre yiğne nukaraaşina sa arı, man aleet'ecen. ");
INSERT INTO tkr_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Rəbbee, gırgıng'uscad cune qopkuvaliys sik'ı hele. G'iyna Rəbbee ğu yizde xılyaqa quvuyng'ar, zı Rəbbee g'əyxı'ng'ulqa xıl g'ot'ul deş. ");
INSERT INTO tkr_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","G'iyna nəxübiy yiğna ı'mı'r yizde ulesqa gıranba qabı, havaasre yizda ı'mı'rıb Rəbbine ulesqa həməxüb gıranba quvooracen. Mang'vee zı gırgıne dağamiyvalybışike g'attixhan he'ecen. ");
INSERT INTO tkr_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Şaulee Davuduk'le eyhen: – Yizda dix Davud, ğu yugvalybışeecar ixhena! Ğu ç'ak'ın işbı g'aces, gırgın işbıd ha'as həsilyxhesda. Mançile qiyğa Davud cune yəqqı'n ayk'an, Şaulur xaaqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Mane gahıl Davudne ək'eleeqa in qayle: – Sa yiğıl zı Şaulne xılençe qik'asda. Yizdemee inekke yugun, Filiştinaaşde ölkeeqa hixu, dyugulyxhay ixhes. Şauleeyir zı İzrailvolle t'abal hı'iyle xıl ts'ıts'aa'a, zınar mang'une xılençe g'ittiyxhaniy. ");
INSERT INTO tkr_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Davud cuka ı'ğviykarne yixhıd vəş (600) insanıka Gatne paççahne, Maokne dixene Akişne suralqa ılğeç'e. ");
INSERT INTO tkr_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","Davud cune insanaaşiqa Gatee, Akişne k'ane axva. Mang'une gırgıne insanaaşiqa xizan vuxha. Davuduqa cuqamee q'öyre xhunaşşe yixha: İzre'elyğançena Axinoam, sayir Karmelyğançene Navalna sip'ıriy Avigail. ");
INSERT INTO tkr_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Davud Gatqa hixuva Şaululqa hixhar hı'ımee, mang'vee sayır Davud t'abal ha'a deş. ");
INSERT INTO tkr_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Davudee Akişik'le eyhen: – Zı yiğne ulen aqqıxheene, hiqiy-allane şaharbışde sançee zas ciga hele, zı maa'ar axvas. Nişisne zı, yiğna nukar, vaka, paççahne şaharee axva? ");
INSERT INTO tkr_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Mane yiğıl Akişee mang'usqa Tsiklag eyhena şahar qoole. G'iyniyne yiğılqameeyib Tsiklag Yahudayne paççahaaşina vob. ");
INSERT INTO tkr_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Davud Filiştinaaşde cigabışee sa sennayiy yoq'uble vazna axva. ");
INSERT INTO tkr_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Davudıy cun insanar abı, Geşurbışilqa, Girzbışilqa, Amalekbışilqa k'yootal vuxha. Man milletbı avaalacad Şurulqayiy Misirılqa hivxharasdemeene cigabışee eyxhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Davudee hücüm hav'uyne cigabışee adamerıb, yedarıb üç'übba g'alyaa'a vuxha deş. Manbışin vəq'əbı, yatsbı, əməler, devabı, alya'an karbı mang'vee alyaat'u, Akişisqa siyk'al ıxha. ");
INSERT INTO tkr_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Akişee mang'uke qidghın ha'ang'a «G'iyna şavulqane k'yoptulva», Davudee mang'us inəxdın alidghıniyniy qelen sassa yəqqees «Yahudabışde cigabışde canubne suralqa», sassa yəqqees «Yeraxmelybışde cigabışde canubne suralqa», sassa yəqqees «Genibışde cigabışde canubne suralqa». ");
INSERT INTO tkr_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Davudee həməxüdud ha'a ıxha. Mang'vee cuna iş inəxüb g'ooce vuxha: «Şi ha'anbı hasre hixhar hıma'acenva» uvhu, manbışin adamerıb, yedarıb gyabat'a vuxha. Manbışda nenacarır Gateeqa arayle ıxha deş. Filiştinaaşde ölkee axuylette, mang'vee həməxüd hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Akiş, Davudul hayxha, culed-alqa eyhe ıxha: – Mana cune milletne İzrailyne ulele həməxür g'a'arxhu vor, mana g'iyniyke şaqa yizda nukarcar ixhes. ");
INSERT INTO tkr_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Mane gahbışil İzrailybışika səvxəsva, Filiştinaaşe con g'oşunbı sacigeeqa sa'a ıxha. Akişee Davuduk'le eyhen: – İn vak'le ats'axhxhe, ğunayiy yiğın insanar yizde sural, yişde g'oşunee vuxhes. ");
INSERT INTO tkr_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Davudee Akişik'le eyhen: – Geed yugda! Zasse, yiğne nukarısse hucooyiy ha'as əxəva, vak'lecad g'acesın. Akişee Davuduk'le eyhen: – Geed yugda, zı vake, zı qik'asmee, yizda can gyuden ha'as. ");
INSERT INTO tkr_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Şamuel qık'uyng'a, gırgıne İzrailyne xalq'ın mang'us ak' avqu. Mana Ramayee, cune şahareecar, k'eyxhı. Mane gahıl Şaulee ölkeençe cadubı ha'anbıyiy hapt'ıynbışin rı'hbı qoot'alan gırgınbı ge'eepşı vuxha. ");
INSERT INTO tkr_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Filiştinar sabı-qabı, Şunemee eyhene şaharee zastava giviyxhe. Şauleeyib gırgın İzrailybı sav'u, Gilboa eyhene suval zastava giviyxhe. ");
INSERT INTO tkr_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Şauluk'le Filiştinaaşda zastava g'avcumee, qərq'ı'niyvalin mang'un yik' sacuraycad qa'a. ");
INSERT INTO tkr_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Mang'vee Rəbbike qiyghan, Rəbbeemee mang'us cuvab nik'eeyid, kaahinıle ğanad, peyğambaraaşiled ğanad nəxüdcad qele deş. ");
INSERT INTO tkr_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Şaulee cune insanaaşik'le eyhen: – Yizdemee, hapt'ıynbışin rı'hbı qoot'alna sa zəiyfa t'abal hee'e. Zı məng'ı'kexheeyid hark'ın qiyghanas. Mang'une insanaaşe eyhen: – En-Doree sa məxürna zəiyfa vorna. ");
INSERT INTO tkr_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Şaulee cune tanalin paççahaaşin karbı g'ayşu, medınbı ali'ı, q'öyre insanır qort'ul, maqa hayk'an. Mana xəmde mana zəiyfa eexvane cigeeqa hiyxhar. Şaulee məng'ı'k'le eyhen: – Yizdemee, zı eyhene qik'uyng'un rı'h qot'le. ");
INSERT INTO tkr_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Zəiyfee eyhen: – Vak'lecad ats'an, Şaulee ine ölkee hı'iyn. Mang'vee ine ölkeençe cadubı ha'anbıyiy hapt'ıynbışin rı'hbı qoot'alan gırgınbı g'eepşıynbı. Nişil-allane zı qiyk'ecenva, ğu zas gugu haa'a? ");
INSERT INTO tkr_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Şaulee zəiyfayk'le eyhen: – Vorne Rəbbilqan k'ın ixhenva eyhe, ine işil-alla vak vuççud ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Zəiyfee eyhen: – Yiğnemee vuşune qot'le? Şaulee «Zasqa Şamuel qot'leva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Zəiyfayk'le Şamuel g'acuys it'umna bagaray hav'u, eyhen: – Voo, ğu Şaulur, nya'a zas horbı hı'ı? ");
INSERT INTO tkr_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Paççahee məng'ı'k'le eyhen: – Qı'meeq'ən, eyhe vak'le hucooyiy g'ece? Zəiyfee eyhen: – Ç'iyek avğançe qı'ğəən rı'h g'ece. ");
INSERT INTO tkr_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Şaulee qiyghanan: – Mana şavukiy akar? Zəiyfee eyhen: – P'laş ali'ına sa q'əsda adamiyır qı'ğəə. Şauluk'le mana Şamuel ıxhay ats'axhxha, mang'us ç'iyelqamee k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Şamuelee Şauluk'le eyhen: – Nişisne ğu zı ı'giykar ha'a? Nişisne qoyt'al? Şaulee eyhen: – Zı xənne dağamiyvaleeqa girxhu vor. Filiştinar zalqa k'yophur, Allaheeyid zale aq'va sak'al hı'ı. Mang'vee peyğambaraaşile ğanad, nik'eeyid zas cuvab qele deş. Mançil-allar zı ğu qort'ul, zak'le eyheva, zı hucooyiy ha'as ıkkan. ");
INSERT INTO tkr_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Şamuelee eyhen: – Rəbbee vake aq'va sak'al hı'ı, Mana yiğna duşman ıxha. Maa'ad zake qiyghanasın hucooyiy? ");
INSERT INTO tkr_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Rəbbee zale ğana vak'le uvhuyn, həşde hı'iyn. Mang'vee paççahiyvalla yiğne xılençe g'avşu, yiğne k'anerıng'usqa, Davudusqa quvu. ");
INSERT INTO tkr_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Ğu Rəbbine cuvabıl k'ırı alixhxhı deş, Mang'una qəl Amalekbışike qığavhu deş. G'iyna dişe, Mang'vee valqa ina ver ablyav'u. ");
INSERT INTO tkr_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Rəbbee vaka sacigee İzrailib Filiştinaaşde xılyaqa qevles. G'iyqa ğunar yiğın dixbıb yizde k'ane vuxhes. Rəbbee İzrailyna g'oşunub çikana Filiştinaaşde xılyaqa qevles. ");
INSERT INTO tkr_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Şamuelee eyhenbı g'ayxhı, Şaul qərq'ı'niyvalin ç'iyelqa qukkyoyk'al. Mang'vee bıkırne xəmnayiy yiğna kar udyotxhun ıxhayke, mang'uqa taq'at axva deş. ");
INSERT INTO tkr_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Zəiyfa Şaulusqa qiyxhamee, mana sacuray qıxha g'acu, eyhen: – Zı, yiğne nukaree, val k'ırı alixhxhıyn. Zı qiyk'uyle qiyeeq'ən yixheeyir, meed ğu uvhuyn hı'iyncad. ");
INSERT INTO tkr_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Hucoona ixhes, həşde yiğne nukarne cuvabıl k'ırı alixhxhe, zı yiğne ögeeqa sa ghaledın gıney gixhxhes, man oxhne. Yəqqı'lqa qığəmee, taq'at ixhecen. ");
INSERT INTO tkr_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Şaulee «Deş ıkkanva» eyhe. Cune insanaaşed zəiyfayka sacigee mana kar oxhanas ilekkamee, mang'vee manbışil k'ırı iliyxhen. Mana ç'iyele oza qıxha, tyulee g'iya'ar. ");
INSERT INTO tkr_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Zəiyfayqa xaa tavulyna dana vooxhe. Məng'ee mana zaraba givk'u, urvad alyaat'u balatıy deşin gıney ha'a. ");
INSERT INTO tkr_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Qiyğa məng'ee man Şaulneyiy cune insanaaşine ögiylqa giyxhe. Manbışe man otxhun, manecab xəmde oza qeepxha avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Filiştinaaşe gırgına cona g'oşun Afeq eyhene şahareeqa saa'a. İzrailybışemee cos zastava İzre'elyne xhyan ı'lqəəne cigaysne giviyxhe. ");
INSERT INTO tkr_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Filiştinaaşde g'oşunbışin ç'ak'ınbı vəşna, aazırna g'oşunbışika əlyhəə vuxha. Davudıy cun insanarıb Akişika sacigee yı'q'əle qöö vuxha. ");
INSERT INTO tkr_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Filiştinaaşde ç'ak'ınbışe qiyghanan: – İne cühüt'yaaşin inyaa'ad hucoone axu? Akişee manbışis inəxdın alidghıniy qele: – İna İzrailyne paççahna Şaulna nukar Davudur. Mana zasnee eyxhen sa senıle geed vod. Mana Şaulusse hixu zasqa qarıyne yiğıle, zak'le mang'uke pisın kar g'acuyn deş. ");
INSERT INTO tkr_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Filiştinaaşde ç'ak'ınbışe Akişilqa qəl hav'u, eyhen: – Mana insan yı'q'əlqa sak'al he'e, hasre ğu cuk'le uvhuyne cigee axvecen. Mana dəv'eeqa ımmaylecen, deşxheene, conbışika sarçu, şaka səyxəs. Cune xərıng'usqa, Şaulusqa yugra qalesva, mang'vee yişde insanaaşin vuk'ulybı gyatxhı, mang'us ıkkees. ");
INSERT INTO tkr_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","İçeeşe mık'ar ha'amee, «Şaulee aazırbışika, Davudeeme yits'ne aazırbışika gyapt'ıva», mə'niybı qədəqqəng'a, yik'el qalya'ana Davud ina vuc vor. ");
INSERT INTO tkr_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Akişee Davud qort'ul, eyhen: – Vorne Rəbbilqan k'ın ixhen, ğu qorkuna insanır. Yiğın zakasana g'oşunee sacigee ark'ıniy zas ıkkanan. Ğu zasqa qarıyne yiğıle, g'iyniyne yiğılqamee zak'le vake pisın g'acuyn deş. Ç'ak'ınbışik'lemee, ğu yugracar g'ece deşur. ");
INSERT INTO tkr_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Həşdiyle ğu, yugraxhinee yı'q'əlqa sak'le. Filiştinaaşde ç'ak'ınbışde ulesqa yugda qidyalesın kar hıma'a. ");
INSERT INTO tkr_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Davudee Akişik'le eyhen: – Zı vasqa qariyne yiğıle, g'iyniyne yiğılqamee zı vasqa yugda qidyalesın nya'a, hucoona hı'ı? Nya'a zasse həşde hark'ın yizde paççahne duşmanaaşika saç'ikkvas dəxə? ");
INSERT INTO tkr_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Akişee Davudus inəxdın alidghıniy qele: – Zak'le ats'an, ğu yizde ulesqa Allahın malaaik xhinne yugra qöö vor. Filiştinaaşde ç'ak'ınbışemee eyhen: «Davud şaka dəv'eeqa ımmaylecen». ");
INSERT INTO tkr_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Həşde vaka qööne, yiğne xərıng'une, Şaulne, nukaraaşika miç'eer çakra oza qıxha, hoora. ");
INSERT INTO tkr_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Davudıy cun insanar Filiştinaaşde cigabışeeqa savk'alasva miç'eeb çakba oza qeebaxhe. Filiştinaarme İzre'elyqa avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Davudıy cun insanar Tsiklag eyhene şahareeqa xhebı'esde yiğıs qabı hiviyxhar. Mane gahıl Amalekbı abı, Negevılqayiy Tsiklagılqa k'yoohar. Manbışe Tsiklag q'əra qav'u, qiyğab gyooxhan haa'a. ");
INSERT INTO tkr_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","Manbışe, maane zəiyfabışda nenacar geek'a deş. Xərıng'ule k'ıning'ulqamee manbışin gırgınbı avqu, cokasana quvkekka. ");
INSERT INTO tkr_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Davud cune insanaaşika şahareeqa ikkeç'umee, mang'uk'le şahar gyooxhan hav'u, con dixbı, yişbı, yedar şenbışe cone ögeeqa gyavhu quvku, g'ooce. ");
INSERT INTO tkr_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Man g'acu, Davudıy cun insanar uledın nağbı qeqvasmee gyaaşenbı. ");
INSERT INTO tkr_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Şenbışe avqu quvkiynbışde yı'q'nee, Davudna q'öyursana xhunaşşe: İzre'elyğançena Axinoamiy Karmelyğançene Navalna sip'ıriy Avigailir yeexhena. ");
INSERT INTO tkr_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Davudun yik' qoxa eyxhe, milletın mana g'ayeqqa helesva uvhuva. Maane insanaaşin cone uşaxaaşiqa yik' gyotxhan ıxhayke, məxüd eyhe ıxha. Davudeeyid yı'q' cune Allahılqa Rəbbilqa qiyzar. ");
INSERT INTO tkr_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Mang'vee, Aximelekne dixek'le kaahin Evyatarık'le uvhuyn: – Hucoona ixhes, yizdemee kaahinaaşin ileylığ inyaqa alle. Evyatareeyid man kar Davudne k'anyaqa adaylen. ");
INSERT INTO tkr_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","Davudee Rəbbike qiyghan: – Zı ine şaharılqa kyophuriynbışiqa qihna gyurxheene, avayq'aree? Rəbbee mang'uk'le eyhen: – Gixhe qihna. Ğu manbışiqa avaq'arasdar, manbışe avquynbıb g'attivxhan haa'asınbı. ");
INSERT INTO tkr_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Davud cukane yixhıd vəş (600) insanıka Amalekbışiqar qihna gexha. Manbı Besor eyhene qadaalisqa qabı hipxhırmee, q'öd vəş (200) insan maacab aaxva. ");
INSERT INTO tkr_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","Davudıy manasa cukasanana yoq'ud vəş (400) insanmee maa'ab ulyoozarcab deş, manbı Amalekbışiqab qihna gyabak'a. Manasa q'öd vəş (200) insan manimee obzur vooxhe, Besor eyhene qadaalikecab manbışisse ılğeepç'es vəəxə deş. ");
INSERT INTO tkr_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Çolee manbışisqa sa Misirğançena qızaxxa, mana manbışe Davudusqa arayle. Manbışe mang'us gıneyıd xhyanıd helen. ");
INSERT INTO tkr_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","Qiyğa manbışe mang'us qooqqav'una inciliyiy q'öble ts'ets'y t'ımılena hoole. Mang'vee man karbı otxhuniyle qiyğa culqa qarayle. Xhebılle yiğnayiy xheyible xəmna mang'vee mankilqasse gıneyid otxhun ıxha deş, xhyanıd ulyodğu eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Davudee mang'uke qiyghanan: – Ğu vuşune vor, nençena arı? Mang'vee Davuduk'le eyhen: – Amalekbışde sang'una zı nukar vor. İxhesır zı, Misirbışda eyxhe. Hiyyiğna zı ık'iyk'ırna, yizde xərıng'veeyir zı g'alerçuna. ");
INSERT INTO tkr_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","Şi canubulynang'a, Keretbışde, Yahudayne, Kalevne cigabışeeqa k'yophur. Tsiklagıs ts'a ı'xı', gyooxhan hav'una. ");
INSERT INTO tkr_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Davudee mang'uk'le eyhen: – Vasse zı, mane şaharbışilqa k'yophuriynbışisqa ıkkees əxəyee? Mane insanee eyhen: – Ğu zı gidek'asvayiy yizde xərng'une xılyaqa qidelesva Allahılqan k'ın g'assıreene, zınar ğu maqa ıkkeesda. ");
INSERT INTO tkr_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Mang'vee Davud mane insanaaşisqa qarayle. Mane gahıl şaharbışilqa k'yophuriynbı inyaa-şaa opt'ul vuxha. Manbışe Filiştğançeyiy Yahudeençe geed kar qıkkı. Qiyğad inyaa-şaa otxhan-ulyoğa, mık'ar ha'a, cos ıkkananbı ha'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Davud verığ k'yooçuyle qiyğa, qinne yiğıl exhalilyqamee manbı gyabat'a ıxha. Devabışilqa aleepxı, hepxıyne yoq'ud vəş (400) mek'vung'ule ğayrı, mançe şavussecar hixu g'attixhanas əxı' deş. ");
INSERT INTO tkr_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Mang'vee Amalekbışe qıkkiyn gırgın karıd, cuna q'öyursana xhunaşşer yı'q'əlqa siyeek'al hee'ena. ");
INSERT INTO tkr_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Ç'ak'ınbı, k'ıninbı, gırgın dixbıyiy yişbı, şenbışe cone xılelqa qı'iyn gırgın kar Davudee yı'q'əlqa sak'al ha'an. Mançike vuççud inyaqa-şaqa ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","Davudee manbışisse gırgın çavra-vəq'ə g'eşşen. Çavra-vəq'ə ha'aykı qıkkekkamee «İnbıd Davudee g'ayşunbı vodva» eyhe ıxha. ");
INSERT INTO tkr_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Davud, obzurva coqab qihna qavaales dəvxüyne, Besorne qadaalil avxuyne q'öd vəş (200) insanısqa siyk'al. Man insanar Davudneyiy cukane insanaaşine ögiylqa qığeebaç'e. Davudee cosqana qabıyne insanaaşis salam hoole. ");
INSERT INTO tkr_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","Davuduka sacigee hapk'ınne qüvçüneyiy karaı'dəəne insanaaşe eyhen: – Manbı şaka hidyapk'ıninçil-alla, şi Amalekbışike g'ayşuyne karan manbışis vuççud heles deş. Manbışde gırgıng'usqa saccu con yedariy uşaxar qevles. Hasre manbıb alyapt'ı, inençe hudooracen. ");
INSERT INTO tkr_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Davudeeme manbışik'le eyhen: – De'eş, yizın çocar! Rəbbee şas huvuyne karak, şosse man ha'as əxəs deş. Şi Rəbbee havaacı. Mang'vee, yişin cigabı q'əra qı'iynbıb yişde xılyaqa quvu. ");
INSERT INTO tkr_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Şavaa vuşde mane cuvabıl k'ırı iliyxheyee? Dəv'eeqa hark'ıning'uqab, yişde karane k'ane axuyng'uqab akaranacab pay vuxhes vukkan. Gırgıng'us akaraba bit'al haa'as vukkan. ");
INSERT INTO tkr_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Mane yiğıle, Davudee mana q'aanun bıkırne İzrailynemee haa'a. Mana q'aanun İzrailil g'iyniyne yiğılqameeyib avxuna. ");
INSERT INTO tkr_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Davud Tsiklageeqa qarımee, mang'vee Amalekbışike g'ayşuyne karbışin sık'ıninbı, cus hambazar vooxhene Yahudayne ağsaqqalaaşis g'axuvu, eyhen: – Hayna Rəbbine duşmanaaşike g'ayşunçike, şos hav'una pay vobna. ");
INSERT INTO tkr_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","Mang'vee man paybı g'ıxelenbı Bet-Elee, canubul Ramoteeyiy Yattiree, ");
INSERT INTO tkr_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","Aroeree, Sifmotee, Eştemoayee, ");
INSERT INTO tkr_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","Rakalee, Yeraxmelybışdeyiy Genbışisde şaharbışee, ");
INSERT INTO tkr_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","Xormayee, Bor-Aşanee, Ataxee, ");
INSERT INTO tkr_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","Xevronee vooxhenbışisiy vuciy cun insanar nyaabiy vuxha mane cigaynbışis. ");
INSERT INTO tkr_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Mane gahıl Filiştinariy İzrailybı siviyxənbı. İzrailybı, mane Filiştinaaşika siviyxəne cigeençe heepxı avayk'ananbı. İzrailybışin xəppananbı Gilboa eyhene suval gyapt'ıynbı. ");
INSERT INTO tkr_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Filiştinar Şaulneyiy mang'une dixbışde qihna gyapk'ı, mang'un dixbı Yonatan, Avinadav, Malki-Şua gyabat'anbı. ");
INSERT INTO tkr_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Şaulne hiqiy-alla əlyhəəna dəv'ə yı'q' qooxhe. Vuk ayhenbı mang'ulqa k'yophur, mana qik'asde yiğıl araççe. ");
INSERT INTO tkr_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Şaulee cun silah haqqang'uk'le eyhen: – G'ılınc qığavhu zı gik'e, deşxheene, mane sunnat deşde karbışe con g'ılıncbı zak eta'a, zı demalqa gixhxhes. Mang'una silah haqqana geer qəyq'ən ıxhayke, mang'usse man ha'as əxə deş. Manke Şaulee cun g'ılınc alyaat'u, vuc çilqa hı'ğəkkar ha'a. ");
INSERT INTO tkr_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Şaul qik'u g'acumee, mang'une silah haqqang'veeyir vuceecar-vuc g'ılıncılqa hı'ğəkkar hı'ı, Şauluka sacigee qek'ana. ");
INSERT INTO tkr_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Mane yiğıl Şaul vucur, mang'una xhebiyre dixır, cuna silah haqqanar, cun gırgın insanarıb habat'anbı. ");
INSERT INTO tkr_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Q'adaalyne şene aq'valyneyiy İordanne damayne şenesa sural vooxhene İzrailybışik'le İzrailyna g'oşun hooxa, Şaulıy cun dixbıb hapt'ı g'avcumee, con şaharbı g'ali'ı, heebaxa giviyğal. Filiştinar qabı, manbışde cigabışee aaxva. ");
INSERT INTO tkr_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Qinne yiğıl Filiştinar hapt'ıynbışilin karbı g'ayşesva abıyng'a, manbışik'le Gilboa eyhene suval Şauluniy cune xhebne dixen mayitbı iveeke. ");
INSERT INTO tkr_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Manbışe Şaulna vuk'ul g'ats'apk'ın, silahbıd alyaat'anbı. Manbışe byuttyaaşis ı'bəədat ha'ane xaybışeeqayiy milletılqa mana xabar hivxhar haa'asdemee, manbışe Filiştinne ölkayne gırgıne surabışilqa insanar g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Şaulun silahbı manbışe alyaat'u, cone byutne Aştoretne xaaqa giyxhe, Şaulun mayitıd Bet-Şean eyhene şaharne cabırbışis g'adaxbışika ı'xiyxə. ");
INSERT INTO tkr_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Gileadeene Yaveş eyhene şahareene milletık'le Filiştinaaşe Şauluk hı'iyn g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","Man g'ayxhımee şaharın gırgın cehilyar g'elil qepxha, xəmvolle yəq apk'ın, Şauluniy mang'une dixbışin mayitbı Bet-Şeanne cabırbışile g'eşşenbı. Yaveşeeqa qabı, manbışe man mayitbı gyoxhxhan ha'a. ");
INSERT INTO tkr_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Qiyğale xhinnee manbışe, mane mayitbışike axuyn bark'vbı sı'ı, Yaveşeene tamarisk yivek avud k'eyxha. Coyud yighılle yiğna sivar aqqaqqa.");
INSERT INTO tkr_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Şaul qik'uyle qiyğa, Davud Amalekbışile ğamxha siyk'almee, mana Tsiklageeqa qarayle. Ma'ar mana q'ölle yiğna axva. ");
INSERT INTO tkr_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","Xhebıd'esde yiğıl Şaulne zastaveençe sa insan arayle. Mang'vee culqa abına ver haagvasva tanalinbı qıt'axxa'a, vuk'ulelqa nyaq'v kyaa'a. Mana insan Davudusqana qarı, mang'une ögiyl ç'iyelqamee k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Davudee mang'uke qiyghanan: – Nençene qöö? Mane insanee eyhen: – İzrailyne zastaveençe hixu, zıcar zı g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Davudee mang'uk'le eyhen: – Maa'ad hucoona ıxha? Hucoona ixhes, zak'le eyhe. Mane insanee eyhen: – Eskerar dəv'ə əlyhəəne cigeençe heepxıynbı, con g'ellesınbıb hapt'ıynbı. Şaulıy cuna dix Yonatanıb hapt'ıynbı. ");
INSERT INTO tkr_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Davudee cus xabar abıyne insanıke qiyghanan: – Şaulıy Yonatan hapt'ıva vak'le nençene ats'a? ");
INSERT INTO tkr_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","Mang'vee Davuduk'le eyhen: – Mane gahıl nəxüdme ıxha, zı Gilboayne suvaliy. Zak'le maa'ar cune nizeyk qirzıl Şaul g'acu. Balkanaaşil aleepxıynbıyiy dəv'əyn daşk'abıd mang'usqayiy hiyxhar. ");
INSERT INTO tkr_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Şaul yı'q'əlqa sak'ı ilyakkımee, zı g'acu mang'vee onı'ıyn. Zı mang'uk'le «Hooyva» uvhu. ");
INSERT INTO tkr_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","Mang'vee zake qiyghıniyn: «Ğu vuşune vor?» Zınad mang'uk'le, «Zı Amalekbışda vorva» uvhu. ");
INSERT INTO tkr_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Şaulee zak'le uvhuyn: «Zasqana qıxha, zı gik'e. Zı sakaratee vorna, zas ine ık'arbışike g'attixhanas ıkkan». ");
INSERT INTO tkr_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Zı mançil-alla mang'usqa qıxha, mana g'ik'una. Zak'le ats'anniy, mang'usse avur axuyle qiyğa, ı'mı'r haa'as vəəxəs deş. Qiyğa zı mang'une vuk'lelin taciy xılelin lexa g'ayşu, inyaqa yizde xərıng'unemee, vasqa adı. ");
INSERT INTO tkr_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Man g'ayxhımee, Davudeeyiy cune k'anenbışe ts'ıts'ı'ı colyun tanalinbı qıt'axxa'a. ");
INSERT INTO tkr_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Manbışe Şaulnemee, mang'une dixene Yonatannemee, gırgıne Rəbbine milletnemee exhalilqamee ak' avqu. Manbışe gyaaşe-gyaaşe sivar aqqaqqa, geebınbı g'ılıncıke alğav'u gyapt'ıva. ");
INSERT INTO tkr_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Davudee, cus mana xabar abıyne mek'vung'uk'le eyhen: – Ğu nençenane vor? Mang'vee alidghıniy qele: – Zı menne cigeençena vor, zı Amalekbışde sang'una dix vor. ");
INSERT INTO tkr_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Davudee mang'uk'le eyhen: – Nəxürne ğu qı'dərq'ı'n Rəbbee g'əyxı'ng'ulqa gik'asva xıl g'ott'ul? ");
INSERT INTO tkr_vpl VALUES ("S21_15","011_1_15","2SA","1","15","16","Ğu gik'uyna bınah val vob! Ğucad, yiğne ghalika, gardanaqa alyaat'u, «Zı Rəbbee g'əyxı'na paççah gik'uva». Davudee cune insanaaşina sa qort'ul eyhen: – Hoora, mana gik'e. Mang'veeyir ı'xı' mana g'ek'ana. ");
INSERT INTO tkr_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Davudee, Şaulneyiy cune dixene Yonatanee ak'ee ina mə'niy qəpqı'. ");
INSERT INTO tkr_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","Qiyğab mana «Vukuna mə'niy» Yahudabışik'le xəp quvxheva əmr haa'a (mana mə'niy «Qorkuyng'une kitabee» opk'un vobna): ");
INSERT INTO tkr_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","İzrail, yiğna xəbvalla, yiğnecab axtıne cigabışee güvk'una. Nəxbın cehilyar hapt'ıynbı! ");
INSERT INTO tkr_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Filiştinaaşin içer şadmeebaxhecenva, Sunnat hıdyav'uynbışde içeeşe bayrambı hıma'acenva. İn Gatee ats'axhxhıma'a, Aşkelonne şahrabışee mançina hımaa'a. ");
INSERT INTO tkr_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","Gilboayn suvabı, Şolqa çiyiy gyoğıy hasre mexhecen, Vuşde q'adaalybışee hasre şagavıd ılymaylecen. Maa'ad cehilyaaşiniy Şaulun g'alxan g'eliqqa huvu, maa'ad çilqa q'ış qıdyadğu. ");
INSERT INTO tkr_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Gyapt'ıynbışde ebake, gucnanbışde tanıke, Yonatanın vuk yı'q'əlqa siyk'alan deşdiy, Şaulunıd g'ılınc idyats'ı qadaylen deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Şaulıy Yonatan, şu üç'übnang'a manimee vukkananbı, yugunbı vuxha. Habat'ameeyib cureepxha deş. Şu q'aacirıleb ek'ınbı, Aslanaaşileb gucukanbı vuxha. ");
INSERT INTO tkr_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","İzrailin içer, Şaulnemee gyaaşe! Mang'vee şolqa ç'ərəxən, gıranın tanalinbıniyxhe alya'anbı. Tanalinçılqad k'ınəğəyken karbıniyxhe qa'anbı. ");
INSERT INTO tkr_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Siç'ookkane cigee nəxbın cehilyar hapt'ıynbı! Yonatan şene axtıne tepabışil qik'u. ");
INSERT INTO tkr_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Yizda çoc Yonatan, yiğnemee yizın yik' gyotxhan. Ğu yizdemee, geer gıranra ıxha. Yiğın zı ıkkiykıniy, yedar vukkiykıniyle zı ooqaniy aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Nəxüb cehilyar hapt'ıynbı! Dəv'əyn silahbıd aguynbı! ");
INSERT INTO tkr_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Sabara gah ılğevç'uyle qiyğa, Davudee Rəbbike qiyghanan: – Zı Yahudayne nenemecar şahareeqa hak'nene? Rəbbee eyhen: – Hak'ne. Davudee qiyghanan: – Nyaqane hak'ne? Rəbbee eyhen: – Xevroneeqa. ");
INSERT INTO tkr_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Davudur maqa cune q'öyursana xhunaşşeyka hayk'anna: İzre'elyğançena Axinoamır, Karmelyğançena Navalna sip'ıriy Avigailer. ");
INSERT INTO tkr_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Davudee cukan insanarıb cone xizanbışika Xevronqa qabı, mançine hiqiy-allane şaharbışee manbışis aaxvasın cigabı hele. ");
INSERT INTO tkr_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Yahudayeençen insanar abı, Davudulqa q'ış qadğu, maa'ar mang'uke Yahudayne nasılına paççah ha'a. Maa'ad Davuduk'le uvhumee, Şaul Gileadeene Yaveşne milletın k'eyxhıva, ");
INSERT INTO tkr_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","Davudee maqa cun insanar g'uxoole. Mang'vee cune insanaaşik'le eyhen: – Maane milletılqa in yizın cuvab hixhar he'e: «Rəbbee şos xayir-düə hevlecen, vuşda xərna eyxhene Şaulus, şu yugvalla hav'u, mana k'eyxhıva. ");
INSERT INTO tkr_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Hasre mane vuşde işil-alla Rəbbee Cuna badal dyooxhena yugvalla şos haagvecen. Zınad mane vuşde işil-alla şos yugun ha'as. ");
INSERT INTO tkr_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Vuşda xərna eyxhena Şaul qik'uva şu həşde xıleppı avqa qıma'a, it'umba ulyoozre. Yahudayne nasılen, cosda paççah zake hı'ı». ");
INSERT INTO tkr_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","Şaulne g'oşunbışde q'oma ulyorzuling'vee Nerne dixee Avneree, Şaulna dix İşboşet cukasana Maxanayimeeqa qıkkı ıxha. ");
INSERT INTO tkr_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","Maa'ar Avneree mana Gileadne, Aşuriyne, İzre'elyne, Efrayimne, Benyaminne cigabışee vooxhene insanaaşde – gırgıne İzrailyna paççah ha'a. ");
INSERT INTO tkr_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Şaulne dixeqa, İşboşetıqa, İzrailyna paççah ıxhayng'a yoq'ts'al (40) senniy vod. Mang'una paççahiyvalla q'ölle senna ts'ıts'avxha. Yahudayne nasılınmee, Davudun sura aqqı ıxha. ");
INSERT INTO tkr_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","Davudee Xevronee, Yahudayne nasıles paççahiyvalla yighılle sennayiy yixhıble vazna hav'u. ");
INSERT INTO tkr_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","Yiğbışde sa yiğıl Nerna dix Avner, Şaulne dixene İşboşetne insanaaşika Maxanayimğançe Giveoneeqa hayk'an. ");
INSERT INTO tkr_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","Tseruya donane zəiyfayna dix Yoavmee, Davudne insanaaşika Giveonusneene xhyan sadıyne cigaysqa, manbışde ögiylqa qığeç'e. Yoav cune insanaaşika xhyan sadıyne cigayne sa aq'val, Avnerır cune insanaaşika – manisa aq'val giy'ar. ");
INSERT INTO tkr_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","Avneree Yoavık'le eyhen: – Havaasre mek'vunbı suğootsu, yişde ögiyl saç'ivkvecen. Yoaveeyid eyhen: – Havaasre saç'ivkvecen. ");
INSERT INTO tkr_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","Şaulne dixene İşboşetne sural sıç'ookvan Benyaminaaşin mek'vunbı qəpqı'mee, yits'ıq'vəyre (12) insan eyxhe. Davudne suraler yits'ıq'vəyre eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","Manbışe sana-sananbı vuk'ulbışike avqu, g'ılıncbı hiyxə. Manbışin gırgınbı habat'anbı. Mançil-allad Giveoneene mane cigayk'le Xelqat-Hatsurimva (G'ılıncbışin çol) eyhe. ");
INSERT INTO tkr_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","Mane yiğıl ma'ad geed it'umın saç'ikkvuy ıxha. Avneriy İzrailybı, Davudne insanaaşis maa'ab avub avxu. ");
INSERT INTO tkr_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","Tseruya donane zəiyfayna xhebırsana dix: Yoav, Avişay, Asahelib maa'ab vooxhe. Asahel, çolana ceyran xhinne, g'elike ek'ra ıxha. ");
INSERT INTO tkr_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","Mana neng'uqacar ilydyakkı, Avnerıqa qihna girxhu. Mang'uqar qihna g'adayxhvanmee, ");
INSERT INTO tkr_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","Avner yı'q'əlqa ilyakkı, eyhen: – Asahel, ğune vor? Mang'vee eyhen: – Ho'o, zı vorna. ");
INSERT INTO tkr_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","Avneree mang'uk'le eyhen: – Yiğne sağıqa, soluqa sa ilekke. Mane mek'vunbışda sa aqqı, manbışin silahbı g'ayşe. Asaheleemee Avnerıke xıl ts'ıts'a'a vuxha deş. ");
INSERT INTO tkr_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","Avneree, Asahelik'le meed eyhen: – Zaqar qihna gimexha, zake xıl ts'ıts'ee'e! Nişil-allane zı ğu gik'as? Qiyğa zı yiğne çoçune Yoavne aq'veeqa nəxürna ilyakkas? ");
INSERT INTO tkr_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","Asahelee meeb mang'uke xıl ts'ıts'aa'a deş. Manke Avneree cun nize alyat'u, cık'rıhiyna mang'une vuxhnele k'ena məxüd ı'xiyxə, cık'rı mang'une yı'q'ək ciga hı'ı qığeç'e. Asahel qukkyorkul cigeecar qek'ana. Mançile qiyğa Asahel qik'uyne cigaysse ı'lğən gırgınbı, maa'ab ulydyobzur ılğeebaç'e vuxha deş. ");
INSERT INTO tkr_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","Yoaviy Avişay Avnerıqa qihna g'adaaxhvan. Verığ k'yooçemee, manbı qabı hiviyxharanbı Giveonne sahrayne yəqqı'lyne Giahne ögiylyne Ammava eyhene tepalqa. ");
INSERT INTO tkr_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","Benyaminaaşinbı Avnerne hiqiy-alla savayle. Qiyğab apk'ın, sa tepayne q'omaqa ılqeepç'ı, maayib ulyoozaranbı. ");
INSERT INTO tkr_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","Avneree ts'irıka Yoavık'le eyhen: – Şi mısılqameene g'ılıncıke hapt'as? Nya'a, vak'le ats'a dişdiy, nekke qiyğa yugdacad ixhes deş? Ğu yiğne insanaaşik'le mısane eyhes, cone çocaaşiqab qihna gimabak'va? ");
INSERT INTO tkr_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","Yoavee eyhen: – Vorne Allahılqa k'ın ixhen, ğu manva ittevhuynxhiy, yizın insanar cone çocaaşiqa qihna miç'eebilqamee gyapk'asınbıniy. ");
INSERT INTO tkr_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","Qiyğa Yoavee şeypur əlüvxümee, manbışin gırgınbı ulyoozaranbı. İzrailybışiqa qihna gyapk'iy ç'əvə'ən, manbışika sayib sıç'ookka deş. ");
INSERT INTO tkr_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","Avneriy cun insanar xəmvolle Arava eyhene q'adaalile k'ena avayk'an. Manbı İordanne damayle ılğeepç'ı, Bitronule k'ena qabı, Maxanayimeeqa hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","Yoavee, Avnerıqa qihna girxhuy ç'əv hı'ı sark'ılymee, cuna g'oşun sa'a. Asahelıle ğayrı Davudne insanaaşike yits'ıyüç'ər (19) insan hiyxhar deşiy. ");
INSERT INTO tkr_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","Davudne insanaaşemee, Benyaminaaşina, Avnerne insanaaşina, xhebıd vəşşe yixhts'al (360) insan gek'a. ");
INSERT INTO tkr_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","Asahel Bet-Lexemqa qıkkı, cune dekkına nyaq'vanane mağaree k'eyxha. Yoaveeyiy cune insanaaşe xəmvolle yəq avayk'an, miç'eebiys manbı qabı Xevronqa hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Şaulneyiy Davudne nasılen səvxı'y xıliyda ts'ıts'exhe. Vaxt apk'ıniylette, Davudne nasılena guc hexxooxhe, Şaulnemee nasılena k'ıl qooxhe vuxha. ");
INSERT INTO tkr_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","Xevronee Davudus dixbı vooxhe. Ts'erriyna dix İzre'elyğançene Axinoamee uxuna Amnon ıxha. ");
INSERT INTO tkr_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","Q'ör'esda Karmelyğançene Navalne sip'ıree Avigailee uxuna Kilav ıxha. Xhebır'esda Geşurne paççahne Talmayne yişşee Maakayee uxuna Avşalom ıxha. ");
INSERT INTO tkr_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","Yoq'ur'esda Haggitee uxuna Adoniya, xhor'esda Avitalee uxuna Şefatya, ");
INSERT INTO tkr_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","yixhır'esdar Davudne xhunaşşee Eglayee uxuna İtream ıxha. Davudus man gırgınbı dixbı Xevronee vuxha. ");
INSERT INTO tkr_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","Şaulnayiy Davudna nasıl siviyxəmee, Avneree Şaulne sural guc saa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","Şauluqa Ayyayna yiş Ritspa donana həmbal zəiyfa yixha. İşboşetee Avnerık'le eyhen: – Nya'a ğu, yizde dekkıne həmbal zəiyfayka g'ılexha? ");
INSERT INTO tkr_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","İşboşetne mane cuvabıke Avnerıs geeb qəl vuxha, eyhen: – Nya'a zı vas, Yahudaabışin sura aqqına xvaana vuk'ulyne vob? Zı g'iyna yiğıniy yiğne dekkıne Şaulne nasılen, mang'une hambazaaşin sura aqqı. Zı ğu Davudne xılyaqa quvu deş. Ğu həşde mane zəiyfal-alla yizde gardanaqa bınah giviyxhe! ");
INSERT INTO tkr_vpl VALUES ("S23_9","011_3_9","2SA","3","9","9","Zı Davudus, Rəbbee mang'us k'ın g'assırıyn hide'eene, hasre Allahee Avnerne vuk'lelqa yiğbı alle'ecen! ");
INSERT INTO tkr_vpl VALUES ("S23_10","011_3_10","2SA","3","10","10","Zı paççahiyvalla Şaulne nasılıke g'avşu, Davudusqa qevles. Mana İzrailynayiy Yahudeyayna, Danile Beer-Şevalqamee, paççah ixhes. ");
INSERT INTO tkr_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","İşboşetık'le man eyhenbı g'ayxhımee, mana Avnerıle qəyq'ən ıxhayke, mang'us alidghıniycad qeles dəxə axva. ");
INSERT INTO tkr_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","Qiyğa Avneree, Davudusqa cun insanar g'axuvu, eyhen: – İn ciga şavunne vod? Qora, zınayiy ğu cuvab g'ats'ak'vanas. Qiyğa gırgınacab İzrail yiğne suralqa ts'ıts'aa'as zı vas kumag ha'asın. ");
INSERT INTO tkr_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","Davudee eyhen: – Geed yugda, zı vaka cuvab g'ats'ak'vanasın. Saccu ğu zasqa ı'qqəmee, vakasana Şaulna yiş Mikal ayre. Mana dena zasqa ımmayle. ");
INSERT INTO tkr_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","Davudee, İşboşetısqa Şaulne dixesqa cun insanar g'axuvu, eyhen: – Zı vəş sunnat hıdi'ına Filiştinğançena gik'ul-alla zas Şaulee hiyvuna yizda xhunaşşe Mikal zasqa seek'al hee'e. ");
INSERT INTO tkr_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","İşboşetee, insan g'axuvu, zəiyfa adamiysse Layişne dixesse Paltielsee g'ayşes ileeka. ");
INSERT INTO tkr_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","Məng'ı'na adamiy geşşe-geşşe Baxurimqamee xhunaşşeyqa qihna ayk'an. Maa'ad Avneree mang'uk'le eyhen: – Yı'q'əlqa sak'le. Manar siyk'alna. ");
INSERT INTO tkr_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","Avner İzrailyne ağsaqqalaaşika yuşanxha, eyhen: – Şos mısa ıkkannaniy vor, Davuduke şos paççah ha'as! ");
INSERT INTO tkr_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","Həşde vuşde yik'eençe ı'lğəən he'e! Rəbbee Davuduk'le dişdiy uvhu: «Zı Yizde nukarne Davudne xıleka, İzrail Filiştinaaşdeyiy gırgıne duşmanaaşine xılençe g'attivxhan haa'as». ");
INSERT INTO tkr_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","Avneree man, hark'ın, Benyaminaaşik'led eyhen. Qiyğa İzrailyneyiy Benyaminaaşde yik'eençe ılğəən Davudus yuşan ha'asva, mana Xevronqa hayk'an. ");
INSERT INTO tkr_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","Xevroneeqa, Avnerıka sacigee Davudusqa g'ayre (20) insan arayle. Davudee, Avnerısiy cune insanaaşis otxhun-ulyodğiy hele. ");
INSERT INTO tkr_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","Avneree Davuduk'le eyhen: – Hasre zı həşde hark'ın, gırgına İzrail yizde xərıng'usqa, paççahısqa, saa'as. Ğunar manbışika cuvab g'ats'ak'vne. Qiyğab vas nişşisiy vukkan, xəbvalla hee'e. Məxüd ıxha Davudee Avner vuççud hidi'ı g'ekkana. ");
INSERT INTO tkr_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","Mane gahıl Yoav, Davudne insanaaşika dəv'eençe sark'ıl eyxhe. Manbışe mebınbışike g'ayşuyn geed kar adayle. Mane gahıl Avner, Davudusse Xevronğançe ark'ın eyxhe. Davudee, Avner vuççud hidi'ı, g'aykkı ıxha. ");
INSERT INTO tkr_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","Yoav, gırgıne g'oşunuka sark'ıling'a, mang'uk'le eyhen: – Nerna dix Avneriy arı. Paççahee mang'uk vuççud hidi'ı, g'aykkına. ");
INSERT INTO tkr_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","Yoav, paççahne k'anyaqa qarı, eyhen: – Ğu hı'iyn kar hucoone? Yiğne k'anyaqa Avnerniy'e arı? Ğu nya'a mana g'aykkı? Həşde mana ark'ınna. ");
INSERT INTO tkr_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","Vak'lecar Nerna dix Avner ats'ana. Mang'vee vas horbı ha'asva, yiğın hark'ın-qaraylen cigayiy ğu g'ecen işbı ats'axhxhesvacar arı ıxha. ");
INSERT INTO tkr_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","Yoav Davudusse qığeç'umee, mang'vee Avnerıqa qihna cun insanar g'uxoole. Manbışer Avner Sira eyhene kahrızısse yı'q'əlqa sak'al ha'a. Davuduk'le man ats'acad eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","Avner Xevronqa sak'ımee, Yoavee cona q'öyrecab, yuşan haa'asın xhinne, mana şaharne akkabışiyle aqa akkyayhe. Qiyğad cune çocul Asahelil-alla, mang'une vuxhnes g'ılıncıqa ı'xı', gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","Davuduk'le, man ats'axhxhamee, eyhen: – Rəbbine ögiyl Nerne dixene Avnerne ebal-alla, mısacab zaliy yizde ölkal bınah aaxvas deş. ");
INSERT INTO tkr_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","Havaasre mana bınah Yoavılqayiy mang'une xizanılqa vuxhecen. Hasre Yoavne nasılee maşika gyatsts'ıyn ı'xnabınana insan deşda, əsaka iykarna insan deşda, g'ılıncıke qek'ana insan deşda, mıssınçika qek'ana insan deşda gah mooxhecen. ");
INSERT INTO tkr_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","Yoaveeyiy cune çocee Avişayee Avner gek'ana. Manbışe mana cona çoc Asahel Giveonee əlyhəəne dəv'ee gik'uynçil-alla gek'a. ");
INSERT INTO tkr_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","Qiyğa Davudee Yoavık'leyiy cune k'anene insanaaşik'le eyhen: – Tanalinbı qıt'axxı, palanbı ale'e, Avnernemee gyaaşe. Avner qıkkek'ane mıghırıqa qihna vuc paççah Davud ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","Avner Xevronee k'eyxha. Paççah mang'une nyuq'vnel oo axtıra geşşena. Mang'uka sacigee milletıd geşşen. ");
INSERT INTO tkr_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","Paççah Davud Avnerne nyuq'vnel oo inva eyhe-eyhe geşşu: Avner məxür, g'eliqqa huvu, gik'as dexheyiy. ");
INSERT INTO tkr_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","Yiğın xıleppı ayt'ıl ıxha deş, G'elybışisıb zincır üvxü vuxha deş. Ğu sixnareeşine ögiyl qukkyoyk'alan xhinne qukkyork'ul. Manva uvhumee, millet meed Avnernemee geşşen. ");
INSERT INTO tkr_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","Qiyğa manbışin gırgınbı abı, Davudee, exha qixhesse, kar oxhnecenva mana ittunçil aqqaqqa ıxha. Davudeeme, k'ın g'assır, eyhen: – Verığ k'yooçesse, yizde ghalik gıney, medın kar set'veene, havaasre Allahee zalqa ver ablee'ecen! ");
INSERT INTO tkr_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","Milletık'le paççahee ha'an g'acu, man gırgın manbışde yik'eençe eyxhe. Paççahee ha'an gırgıncad milletıs ıkkiykanan. ");
INSERT INTO tkr_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","Mane yiğıl gırgıne milletık'leyiy gırgıne İzrailik'lecad ats'axhxhen, Nerna dix Avner paççahee gidek'u ıxhay. ");
INSERT INTO tkr_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","Paççahee cune insanaaşik'le eyhen: – G'iyna İzrailee xərna, qıvaats'ına insan qik'uva ats'a dişde? ");
INSERT INTO tkr_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","G'iyna zı g'əyxı'na paççahır ixheene, zaqa guc k'ılyba vob. Tseruyayn dixbı, Yoaviy Avişay, zale nimee vuxhee gucuka vob. Havaasre Rəbbee pisvalla haa'ang'us, haa'ane pisvallays sik'ı helecen! ");
INSERT INTO tkr_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","Şaulne dixek'le İşboşetık'le, Avner Xevron eyhene şaharee gik'uva ats'axhxhamee, mang'us zeze ooxha. İzrailin milletıd man g'ayxhı qəyq'ən giyğal. ");
INSERT INTO tkr_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","Şaulne dixeqa İşboşetıqa q'öyre cune destebışda xərna ıxha. Manbı Benyaminaaşinbı vooxhene Beerotğançene Rimmonun dixbı vuxha. Manbışde sang'un do Baana, mansang'unud Rexav ıxha. Beerot vucub Benyaminaaşinacab vuxha. ");
INSERT INTO tkr_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","Beerotbı Gittayimeeqa heepxı qabı vuxha, g'iyniyne yiğılqameeyib manbı maa'ab menne cigaynbı xhinne aaxva. ");
INSERT INTO tkr_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","(Şaulne dixeqa Yonatanıqa q'öyudsana g'el k'aana Mefiboşet donana dix ıxha. İzre'elyğançe Şaulıy Yonatan gyapt'ıva xabar qabımee, mang'uqa xholle sen ıxha. Mane k'ıning'uqa ileekang'vee mana mançe alyart'u, zaara heexvava, gade xılençe g'a'araççe mang'un g'elybı hayq'var.) ");
INSERT INTO tkr_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","İşboşetee yı'q'ı'hna manzil haa'amee, Beerotğançene Rimmonun dixbı Rexaviy Baana yəqqı'l gyabak'va. Manbı pırane gahıl qabı mang'une xaasqa hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("S24_6","011_4_6","2SA","4","6","7","İşboşet cune gozee tyulee g'alirxhu eyxhe. Rexaviy cuna çoc Baana suk alyabat'anbı xhinnee xaaqa ikkeepç'ı, mang'une vuxneeqa xincal hi'yxə. Qiyğab vuk'ul g'ats'pk'ın, vucub alyapt'ı, mançe heebaxanbı. Xəmvolle manbı Arava eyhene qadaalyne yəqqı'le k'ena avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","İşboşetna vuk'ul manbışe Xevroneeqa Davudne k'anyaqa abı, paççahık'le eyhen: – İna Şaulne yiğne duşmanna dixena İşboşetna vuk'ul vob. Mane Şaulısniy ğu gik'as ıkkan. G'iyna Rəbbee, yişde xərıng'ul – paççahıl-alla Şaulukeyiy cune nasılıke in hı'ı, qəl qığavhu. ");
INSERT INTO tkr_vpl VALUES ("S24_9","011_4_9","2SA","4","9","11","Davudee Beerotğançene Rimmonne dixbışis Rexavısiy cune çocus Baanays inəxdın alidghıniy qele: – Zı Tsiklageenang'a culygena ixheene zas yugna xabar ana insanniy arı: «Şaul qik'unava». Zı mançil-allar mana aqqı gik'as alikkı. Mang'vee zas abıyne xabarın mukaafat mang'us man ıxha. Həşde karaı'dəən insanar qopkune insanne xaaqa ikkeepç'ı, mana cune tyulee gik'uyng'a, şosqa nəxüdiy qöö, zı mang'una eb ç'iyel g'alepçı, manbı ç'iyene aq'val gidyapt'ı g'alyaa'aye? Zı gırgınçike g'attixhan ha'ane Vorne Rəbbilqan k'ın ixhen məxdın kar ixhes deş! ");
INSERT INTO tkr_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","Davudee cune insanaaşilqa əmr haa'a, manbışeb manbı avqu gyabat'anbı. Qiyğad manbışin g'elybıyiy xıleppı gyatxı, Xevroneene xhyan səəne cigayne k'ane k'eyxə. İşboşetna vuk'ulyub alyapt'ı, Xevroneene Avnerne nyuq'vneeqa k'evxhu. ");
INSERT INTO tkr_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","İzrailin gırgın nasılbı Xevronqa Davudne k'anyaqa abı inəxüd eyhe: – Şi vaka sa milletınbı, sa ebanbı vob. ");
INSERT INTO tkr_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Şenke yişda paççah Şaulnang'a, ğucabniy İzrailybı dəv'eeqa vukku qavaylenbı. Rəbbee vak'leniy uvhu, ğu Cune milletıs çobaniyvalla haa'as, şi vuk'lek vukkeekana ixhes. ");
INSERT INTO tkr_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","İzrailin gırgın ağsaqqalar Xevronqa paççah Davudne k'anyaqa abayle. Paççahee maa'ad Rəbbine ögiyl manbışika cuvab g'ats'ayk'van. Ağsaqqalaaşe Davud İzrailyna paççah ixhecenva mang'ulqa q'ış qadağva. ");
INSERT INTO tkr_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Davud paççah eyxheng'a mang'uqa xhebts'al (30) senniy vod. Mang'vee İzrailis yoq'ts'al (40) senna paççahiyvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Davudee, Xevronee Yahudays yighılle sennayiy yixhıble vazna paççahiyvalla haa'a. İyerusalimeençeb mang'vee bıkırne İzrailisiy Yahudays xhebts'ale xhebılle (33) senna paççahiyvalla hav'u. ");
INSERT INTO tkr_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Paççahiy cun insanar İyerusalimqa hapk'ın, maane avaalacab vooxhene Yevusbışilqa k'yoohar. Yevusbışe Davuduk'le eyhen: – Vasse inyaqa ikkeç'es əxəs deş. Ğu inyaqa areene yişde bı'rq'ı'nbışisser, k'aanbışisser ğu inençe g'e'eşşes əxəsda. Manbışisqa məxüd qöö ıxha, Davudusse mane şahareeqa ikkeç'es əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","Davudee maana Sion eyhena g'ala avqaaqqana. Həşde mançik'le «Davudna Şaharva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Davudee mane yiğıl eyhen: – Vuşuyiy Yevusbışilqava arı, hasre xhyan qööne tuneleençe ılğeç'u qoracen. Məxüb şu Davud g'ımece eyxhene «bı'rq'ı'nbışileyiy k'aanbışile» ğameepxhes. Həşde dişe eyhe: «Bı'rq'ı'nayiy k'aana xaaqa ikkeepç'es deş». ");
INSERT INTO tkr_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Davud mane g'aleecar axva, mançil-allad mane g'alayk'le Davudna Şaharva eyhe. Mang'vee g'alayn hiqiy-alladın cigad Millo eyhene tepaysqamee adın cigad ali'ı qa'an. ");
INSERT INTO tkr_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Xəəna G'oşunbışda Rəbb Davuduka ıxhal-alla, mang'una guc yiğ-yiğıle hexxooxhe vuxha. ");
INSERT INTO tkr_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Sur eyhene şaharne paççahee Xiramee, Davudne k'anyaqa cun insanar, sidırne yiven os, osanayiy g'ayeyna iş haa'as vəəxən insanar g'uxoole. Manbışe Davudus saray alya'a. ");
INSERT INTO tkr_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Manke Davuduk'le ats'axhxhen, Rəbbee vuc İzrailyna paççah hı'ı, cuna paççahiyvallab axtı qav'u. ");
INSERT INTO tkr_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Davud Xevronğançe İyerusalimqa qarıyle qiyğa, mang'vee cus mançe mebın xhunaşşeriy həmbal zəiyfabı haa'a. Manbışeb Davudus dixbıyiy yişbı vuxooxa. ");
INSERT INTO tkr_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Mang'us İyerusalim vuxhayne dixbışin dobı inbı vod: Şammua, Şovav, Natan, Sıleyman, ");
INSERT INTO tkr_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","İvxar, Elişua, Nefeg, Yafia, ");
INSERT INTO tkr_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","Elişama, Elyada, Elifelet. ");
INSERT INTO tkr_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Filiştinaaşik'le g'iyxhen, Davud İzrailyna paççah ha'asva mang'ulqa q'ış qadğu. Manke manbışin gırgınbı Davud t'abal ha'asva avayk'an. Davuduk'le man ats'axhxhamee, yı'q'əlqa g'aleeqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Filiştinarıb Refaimne q'adaalilqa qabı, maa'ab aaxva. ");
INSERT INTO tkr_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","Davudee Rəbbike qiyghanan: – Zı Filiştinaaşika səyxene? Ğu manbı yizde xılyaqa qevlesınbıne? Rəbbee Davuduk'le eyhen: – Ho'o, hoora səyxe, zı manbı yiğne xılyaqa qıdevu g'alepçes deş. ");
INSERT INTO tkr_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Davud Ba'al-Peratsimeeqa arı, Filiştinar gyapxı-gyapt'ı, eyhen: – Selin çine ögeedın kar haq'var hiyxvər ha'an xhinnee, Rəbbeeyib yizde ögiylin duşmanar oot'al-ooxal hav'u. Mançil-allad mane cigayn do Ba'al-Peratsim (ot'al-oxal ha'ana iyesiy) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","Filiştinar heepxı əlyhəəmee, con byuttyar maa'adcad g'alya'a. Davudeeyiy cune insanaaşed man byuttyar sı'ı, qıkkekkanbı. ");
INSERT INTO tkr_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Filiştinar meeb Refaimne q'adaalilqa abı, maa'ad çadırbı giyxə. ");
INSERT INTO tkr_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Mançinemee Davudee Rəbbike qiyghan, Rəbbeeyid Davuduk'le eyhen: – Ts'erriykecar manbışde ögiylqa qığmeç'e. Yı'q'əle apk'ın, totan yivarnane surale manbışilqa k'yoohre. ");
INSERT INTO tkr_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Totane yivaaşine q'ombışile g'elybışin sesbı qöö gidğılmee, ğu zaara ı'ğı'ykre. Filiştinaaşde g'oşunukun ha'asva, mane gahıl Rəbb yiğne ögiyl əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Davudee gırgın, Rəbbee cuk'le uvhuyn xhinnee ha'a. Mang'vee Gevayeençe Gezereeqa hivxharasdee cigeeqamee Filiştinar gyabat'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Davudee İzrailyğançe meer yugna, siyxənə xhebts'al aazır (30 000) insan g'əyxı', saa'a. ");
INSERT INTO tkr_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Davud, Yahudeene Ba'ala eyhene şahareençe Allahna q'utye qavaalesva, cune insanaaşika sacige maqa ayk'an. Mana q'utye Rəbbine doyul vuxha. Mane q'utyel oo keruvar ıxha. Xəəne G'oşunbışde Rəbbina taxt mane keruvaaşil oo vuxha. ");
INSERT INTO tkr_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","Allahna q'utye ts'enne daşk'eeqa alivxhu, Avinadavne tepalyne xaançe qığaahana. Daşk'ad Avinadavne dixbışe Uzzayeeyiy Axioyee he'ekka ıxha. ");
INSERT INTO tkr_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","Manbışe Allahna q'utye daşk'eeqa gyuvxhu qığaaha. Q'utyeyne ögiylir Axio ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Davudur, gırgın İzrailin milletıd gıranne osake hı'iyn t'ampırbı, lirabı, dafbı, medın aalyatbı əlixı', Rəbbine ögiyl şadba mık'ar hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Naxonne attayle ı'lğəəmee, yatsbı qaçayxaranbı. Uzzeeyib xıl hotku, g'ı'moxhacenva Allahna q'utye avqaaqqa. ");
INSERT INTO tkr_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Rəbbina Uzzalqa qəl avqaaqqa, mang'vee hı'rmat deşvaala hav'uva mana maacar ı'xı' gek'ana. Uzza Allahne q'utyeyne k'ane qek'a. ");
INSERT INTO tkr_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Davudus, Rəbbee Uzza gik'uva qəl vooxhe. Mane cigayn do g'iyniyne yiğılid Perets-Uzza (Uzzayn qik'uy) vod. ");
INSERT INTO tkr_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Mane yiğıl Davud Rəbbile qərq'ı'n, eyhen: – Zasqa Rəbbina q'utye nəxüb ables vooxheye? ");
INSERT INTO tkr_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Davudus Rəbbina q'utye cusqa, Davudne Şahareeqa quvkees vukkiykan deş. Mang'vee mana Gatğançene Oved-Edomne xaaqa quvkees ulyookka. ");
INSERT INTO tkr_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Rəbbina q'utye xheyible vazna Oved-Edomne xaa aaxva. Rəbbee Oved-Edomusub, mang'une xizanısıb yugna barakat hoole. ");
INSERT INTO tkr_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Paççah Davudulqa «Rəbbee Oved-Edomne xizanıb, mang'une gırgıne karasıb Allahne q'utyel-alla barakat huvuva» hixhar ha'a. Manke Davud Oved-Edomne xaaqa hark'ın, mançe Allahna q'utye cun do huvuyne Davudne şahareeqa şadba qavayle. ");
INSERT INTO tkr_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Rəbbina q'utye haaqqanbışe yixhnəqqees g'el qittumee, Davudee sa yats'iy tavulyna q'ıka gyook'a. ");
INSERT INTO tkr_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Davudee katanıken ileylığ ali'ı, Rəbbine ögiyl vəəxəxüb g'oyk'al-ulyoyk'al mık' haa'a. ");
INSERT INTO tkr_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Davuduka sacigee gırgıne İzrailyne milletın şadvalin ts'irbı ha'a-ha'a, şeypur ı'lyviyxə Rəbbina q'utye quvkeeka vuxha. ");
INSERT INTO tkr_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Rəbbina q'utye Davudne Şahareeqa quvkekkamee, Şaulna yiş Mikal g'uleençe ileeka yixha. Məng'ı'k'le paççah Davudee Rəbbine ögiyl g'oyk'al-ulyoyk'al mık' haa'a g'avcumee, məng'ee mana k'ap'ik'ıle avqa qa'a. ");
INSERT INTO tkr_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Rəbbina q'utye qabı, Davudee mançinemee güvxüyne çadırene ab, çisva qav'uyne cigeeqa giviyxhe. Davudee Rəbbine ögiyl gyoxhxhan ha'aniy medın q'urbanbı allya'a. ");
INSERT INTO tkr_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Davudee q'urbanbı alli'iyle qiyğa, milletıs, Xəəne G'oşunbışde Rəbbine doyule xayir-düə hoole. ");
INSERT INTO tkr_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Qiyğa mang'vee İzrailyne milletne adameeşisıb, yadaaşisıb gırgıng'uscab sa gıney, sık'ınin çuru, sa ts'ets'ib qooqqune t'ımılena hoole. Mançeb gırgınbı xaybışeeqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Davud cune xaabınbışis xayir-düə hevlesva xaaqa sak'ımee, Şaulna yiş Mikal mang'une ögiylqa qığeyç'u, eyhen: – İzrailyne paççahee g'iyna vuceecar-vuc nəxür haguna! Mana cune insanaaşineyiy cune g'ulluxçiy içeeşine ögiyl bəç'ər xhinne ts'ele qıxha. ");
INSERT INTO tkr_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Davudee Mikalık'le eyhen: – Zı man Rəbbine ögiyl hı'ı. Mang'vee zı yiğne dekkıneyiy mang'une bıkırne nasılene cigee g'əyxı', Cune milletıs, İzrailybışis, xərna hı'ı. Zı inçile qiyğar Rəbbine ögiyl şadxhesda. ");
INSERT INTO tkr_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Zı yizde ulene ögiyl sık'ırar uleke g'a'ayxhasda. Ğu eyhene g'ulluxçiy içeeşemee zı axtı qa'as. ");
INSERT INTO tkr_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Şaulne yişşeqa, Mikalıqa, qiyk'asde yiğılqamee uşax eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Paççah cune sarayeeqa sarımee, Rəbbee mang'us cune hiqiy-allane duşmanaaşike macal hele. ");
INSERT INTO tkr_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Mane gahıl paççahee Natan donane peyğambarık'le eyhen: – İlekke, zı sidırne gıranne yiveke ali'ıyne sarayee axva, Allahna q'utyemee çadıree vob. ");
INSERT INTO tkr_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Natanee paççahık'le eyhen: – Rəbb vaka vor, hoora yiğne yik'eedın he'e. ");
INSERT INTO tkr_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Mane xəmde Rəbbee Natanık'le inəxdun cuvab eyhe: ");
INSERT INTO tkr_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","– Hark'ın yizde nukarık'le Davuduk'le eyhe, Rəbbee inıd eyhe: «Ğune, Zı axvasın, Zasın xav alya'as? ");
INSERT INTO tkr_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","İzrailybı Misirğançe qığav'uyne yiğıle, g'iyniyne yiğılqamee Zı nenecar xaa axu deş. Zı nyaqa ark'ınee, Yizde çadıree axu. ");
INSERT INTO tkr_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Zı gırgıne gahbışilycar İzrailyne milletıka sacigee ı'ğiykır. Zı mısacad İzrailyne milletna haa'ane ç'ak'ınbışik'le uvhu deş: „Zas sidrıke xav ale'e“». ");
INSERT INTO tkr_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Həşde Yizde nukarık'le Davuduk'le eyhe, Xəəne G'oşunbışde Rəbbee inıd eyhe: «Zı ğu vəq'əbı uxhiyxhanne cigabışeençe qarı, vake İzrailis xərna hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Ğu hark'ınne gırgıne cigabışee, Zı vaka ıxha. Yiğne ögiylin duşmanar oot'al-ooxal hav'u. Həşded yiğın do menne qıvaats'ıyne insanaaşin do xhinne qıvaats'a'asın. ");
INSERT INTO tkr_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","G'iyniyke şaqa cone cigabışee gyuv'recenva, şavaacabıb manbı mançe ı'ğviykar hımaa'acenva, Zı yizde milletne İzrailynemee sa ciga qa'as. Zı haakimar milletın ç'ak'ınbı xhinne gyuvxhuyng'a, qəlnane insanaaşe manbı hooç'an-g'ooç'ananbıniy. Həşde məxdın kar ixhes deş: Zı vas duşmanaaşine xılençe rəhətiyvalla hevles. Vake g'abıynbı paççahar vuxhesva, Rəbbee vak'le g'ayxha'a. ");
INSERT INTO tkr_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Yiğna ı'mı'r ç'əvuvxhamee, ğunar yiğne dekkaaşisqa ark'ınmee, yiğne cigeeqana yiğna dix ha'as. Zı mang'una paççahiyvalla it'umba haa'as. ");
INSERT INTO tkr_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Mang'vee Yizde doyulyun xav alya'as. Zınab mang'una paççahiyvalla gırgıne gahbışis it'umaa'asda. ");
INSERT INTO tkr_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Zı mang'unemee Dek ixhes, manar Yizdemee dix ixhes. Mang'vee bınah hav'umee, Zı mang'us, insanaaşe cone uşaxaaşis caza hoolena xhinnena, caza hevles. ");
INSERT INTO tkr_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Zı mang'uke Yizda badal dyooxhena yugvalla, Şauluke g'avşuna xhinne, g'avşes deş. ");
INSERT INTO tkr_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Zı məxüd ha'as yiğna nasılıb, yiğna paççahiyvallab gırgıne gahbışis vuxhes. Yiğna paççahiyvalina taxtıb gırgıne gahbışiscab vake g'abıynbışisne vuxhes». ");
INSERT INTO tkr_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Natanee gırgın Allahee haguyn Davudus yuşan ha'an. ");
INSERT INTO tkr_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Paççah Davud Allahne çadıreeqa ikkeç'u, Rəbbine ögiyl gyu'ur eyhen: – Ay Xudaavanda Rəbb, zı vuşune vor, yizda nasılıb şavnane vob, Ğu zı inimee axtı qı'ı? ");
INSERT INTO tkr_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Ya Xudaavanda Rəbb, Yiğne ulesqa manıd k'ılda qadı, Ğu zake g'abıynbışde vuk'lelqa qalesınıd uvhu. Xudaavanda Rəbb, inıd insanaaşinemee ı'brat ixhes. ");
INSERT INTO tkr_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Davudusse medın Vak'le hucoo eyhes əxəyee? Ya Xudaavanda Rəbb, Vak'lecar zı, Yiğna g'ul, ats'ana! ");
INSERT INTO tkr_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","Ğu in gırgın ç'ak'ın işbı, Yiğne cuvabnemee, Vas ıkkanəxüd zak'le hagvasdemee hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","Ğu nimeecar Xərrayiy, ya Xudaavanda Rəbb! Şak'le yişde k'ırıbışika g'ayxhı, Vak akarana sacar deşda, Vale ğayrı Allahır deşda. ");
INSERT INTO tkr_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Yiğın İzrail millet xhinnen, ç'iyene aq'val, medın millet vodunne? Ğu manbı Misirğançe qığavhu, gattivxhan hav'u. Yiğın do ats'axhxhecenva Ğu manbışde ögiyl ç'ak'ın əlaamatbı hagu, ç'ak'ın işbı g'acu. Manbışike Vas millet ha'asva, Ğu manbışde ögiylin milletbıyiy manbışin allahbı g'e'epşi. ");
INSERT INTO tkr_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","Gırgıne gahbışis Ğu İzrailike Vasın millet hı'ı, Ğunar, Rəbb, manbışda Allah ıxha. ");
INSERT INTO tkr_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","Həşdiyle, Ya Rəbb Allah, zasiy zake g'abıynbışis huvuyn cuvab həməxüd he'e, gırgıne gahbışis axvecen. Gırgınıd hasre Ğu eyhəxüd ixhecen. ");
INSERT INTO tkr_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","Hasre insanaaşe «Xəəna G'oşunbışda Rəbb İzrailyna Allah vorva» uvhu, Yiğın do gırgıne gahbışis axtı qe'ecen! Yiğne g'uluna, Davudna nasılıb Yiğne ögiyl havaasre it'umba ulyoozrecen. ");
INSERT INTO tkr_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","Xəəna G'oşunbışda Rəbb, İzrailyna Allah, Ğu man zak'le hagu, uvhuyn: «Yiğna nasıl it'umba vuxhes». Mançil-alla zı yik' hı'ı Vas məxübna düə hav'u. ");
INSERT INTO tkr_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","Ya Xudaavanda Rəbb, Ğu Allah vorna, Yiğın cuvabıd qotkuyn vod. Ğu həşde Yiğne g'ulus ina yugna xabar huvu. ");
INSERT INTO tkr_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Gırgıne gahbışil Yiğne ögiyl vuxhecenva, Yiğne g'ulune nasılıs xayir-düə huvuy Vasqa yugda qalecen. Ya Xudaavanda Rəbb, Ğu məxdın cuvabniy huvu. Yizde nasılen Yiğne xayir-düəyka gırgıne gahbışisda xayir-düə alept'ecen! ");
INSERT INTO tkr_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","Mançile qiyğa Davud Filiştinaaşile ğamxha, manbı cus vukkanəxüb vuk'lek vukkeeka. Manbışde xılençe Meteg-Ammahıb g'ooşena. ");
INSERT INTO tkr_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","Qiyğa Davud Moavbışiler ğamexhena. Mang'vee manbı ç'iyelqa g'alyapk'as alivku, baağıka ulyoopku, manbı xhebne desteeqa bit'al ha'a. Xhebne desteyna q'öble deste mang'vee gyabat'anbı. Sa destemee mang'vee g'ookana. Moavbı Davudus nukarar vooxhe, mang'us nalok'bı qele giviyğal. ");
INSERT INTO tkr_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","Tsovayna paççah eyxhena Rexovna dix Hadadezer, Fərat eyhene damayne hiqiy-alladın ciga meed cune xılyaqa alğahasva arayle. Maa'ar Davud mang'ule ğamexhena. ");
INSERT INTO tkr_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","Davudee Hadadezerna aazıriy yighıd vəş (1 700) balkanılyna, g'ad aazırır (20 000) hoyhar arına esker aqqaqqa. Mang'une balkanaaşina vəş Davudee cus avqu, axuyne daşk'ayk qı'iyne balkanaaşinıd g'elin damarbı gyatxas ilekka. ");
INSERT INTO tkr_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","Damask vooxhen Arambı Tsovayne paççahıs Hadadezerıs kumagıs abımee, Davudee manbışda g'ayeq'vəd aazır (22 000) insan gek'a. ");
INSERT INTO tkr_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","Davudee Damask vooxhene Arambışde ölkee cun g'oşunbı ulyozar ha'a. Mang'vee manbışike nukarar haa'a, manbışe Davudus nalok'bı qele giviyğal. Davud nyaqa hark'ıneeyir, Rəbbee mana ğama'ananiy. ");
INSERT INTO tkr_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","Mang'vee Hadadezerıne insanaaşin k'ınəəğəken g'alxanbı alyaat'u, İyerusalimqa qadayle. ");
INSERT INTO tkr_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","Paççah Davudee, Hadadezerne Betaxiy Berotay donane şaharbışeençe geed yez adayle. ");
INSERT INTO tkr_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","Xamatne paççahık'le Toik'le Davud Hadadezerne gırgıne g'oşunulecar ğamxhava g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","Hadadezeree hammaşee Toika dəv'ə haa'a vuxha. Hadadezerıle ğamxhava Davud nəxüriyva qiyghanas, sayir mana tabrik ha'asva paççah Toiyee dix Yoram mang'une k'anyaqa g'ıxele. Yoramee Davudus k'ınəəğəyn, nuk'rayn, yezan karbı adayle. ");
INSERT INTO tkr_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","Paççah Davudee in cus adıyn k'ınəəğəyken, nuk'rayken, yezaken, vucee menne milletbışike g'ayşuyn karbı Rəbbis g'iysar. ");
INSERT INTO tkr_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","Mang'vee Edombışike, Moavbışike, Ammonbışike, Filiştinaaşike, Amalekbışike g'ayşuyn karbı Rəbbis g'iysar. Davudee Tsovayne paççahısse Rexovna dix eyxhene Hadadezerıssed g'ayşuyn karbıd Rəbbis g'iysar. ");
INSERT INTO tkr_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","Davudee Q'evane q'aadalil Edombışda yits'ımoled aazır (18 000) insan oot'al-ooxal hı'ı siyk'almee, mana gırgıng'uk'le ats'axhxhena. ");
INSERT INTO tkr_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","Edomne gırgıne suralqa mang'vee cun g'oşunbı ulyoozar hı'iyle qiyğa, Edombı mang'un g'ular vooxhe. Davud nyaqa hark'ıneeyir Rəbbee mana ğama'ananiy. ");
INSERT INTO tkr_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Davud İzrailynacar paççah eyxhe. Mang'vee millet qotkuda vuk'lek ıkkekka, gırgıngunemeeyir mana qorkura ıxha. ");
INSERT INTO tkr_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","Tseruya donane zəiyfayna dix Yoav g'oşunna xərna ıxha. Axiludna dix Yehoşafat taarix oyk'anna ıxha. ");
INSERT INTO tkr_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","Axituvna dix Tsadokiy Evyatarna dix Aximelek kaahinar vuxha. Seraya mirza ıxha. ");
INSERT INTO tkr_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","Yehoyadayna dix Benaya Keretbışdayiy Peletbışda xərna ıxha. Davudun dixbı kaahinar vuxha. ");
INSERT INTO tkr_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Davudee eyhen: – Şaulne nasılena üç'ürra axuna vornane? Yonatannemee, zı mang'us yugvalla haa'as. ");
INSERT INTO tkr_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Şaulne nasılıs g'ulluxçiyvalla haa'ana Tsiva donana sa insan ıxha. Mana Davudne k'anyaqa qoyt'al, paççahee mang'uke qiyghanan: – Tsiva ğune vor? Mang'vee eyhen: – Ho'o, yizda xərna, zı vorna. ");
INSERT INTO tkr_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Paççahee eyhen: – Şaulne nasıleençe saxheyir üç'ürna insan vornane, zı mang'us Allahne yəqqee yugvalla haa'ayiy? Tsivee paççahıs alidghıniy qele: – Ho'o, Yonatanıqa q'öyudsana g'el k'aana dix vor. ");
INSERT INTO tkr_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Paççahee mang'uk'le eyhen: – Həşde mana nyaane vor? Tsivee paççahık'le eyhen: – Mana həşde Lo-Devar eyhene şaharee, Ammielyne dixene Makirne xaa vorna. ");
INSERT INTO tkr_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Paççah Davudee insan g'axuvu, Lo-Devarğançe Makirne xaançe Mefiboşet cusqa ayra'a. ");
INSERT INTO tkr_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Şaulna neva, Yonatanna dix eyxhena Mefiboşet Davudne k'anyaqa arı, mang'us hı'rmat gyuvxhu, k'yoyzarna. Davudee ona'an: – Mefiboşet! Mang'vee «Zı, yiğna nukar, inyaa vorva» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Davudee mang'uk'le eyhen: – Qı'məyq'ən, yiğne dekkıne Yonatannemee, zı vas yugvalla hidyav'u g'alerçes deş. Yiğne q'əsde dekkın Şaulun gırgın cigabı zı vas sak'al ha'as. Ğu gırgıne gahbışil yizde sufranıle otxhuniy oxhanas. ");
INSERT INTO tkr_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Mefiboşet Davudus k'yorzul, eyhen: – Nya'a, zı, yiğna g'ul, vuşune eyxhe? Ğu, zına xhineene qivk'une xvaana haa'a? ");
INSERT INTO tkr_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Paççahee Şaulna g'ulluxçiy Tsiva qort'ul, eyhen: – Şaulıniy mang'une nasılen gırgın kar, yiğne xərıng'une nevaysqa quvu. ");
INSERT INTO tkr_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Yiğne xərıng'une nevayn cigabı ğunayiy yiğne dixbışeyiy yiğne nukaraaşe mang'unemee ezu-qiyşalas. Şagavıd mang'usqa qeles, mang'uqa oxhanasın kar ixhecenva. Vuşde xərıng'une nevee, Mefiboşetee, gırgıne gahbışil yizde sufranıle kar oxhanas. (Tsivayqa yitsıxhvayre (15) dixıy g'ayrer (20) nukar vor.) ");
INSERT INTO tkr_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Tsivee paççahık'le eyhen: – Yizda xərna, paççah, ğu uvhuyn gırgın zı, yiğne g'ulee, ha'asın. Mefiboşetee, paççahne dixbışde sang'vee xhinne, Davudne sufranıle otxhuniy oyxhan ıxha. ");
INSERT INTO tkr_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mefiboşetıqa sa k'ınna Mika donana dix ıxha. Tsivayne xaabın gırgınbı Mefiboşetın nukarar vuxha. ");
INSERT INTO tkr_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","Mefiboşetee paççahne sufranıle kar otxhan ıxhayke, mana mançile qiyğa İyerusalimee axva. Mang'un q'öyudsana g'el k'aada ıxha. ");
INSERT INTO tkr_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","Sabara gahıle Ammonbışda paççah qek'a. Mang'une cigee paççah mang'una dix Xanun eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","Davudee eyhen: – Dekkee zas badal dyooxhena yugvalla hav'uva, zınab mang'une dixes Xanunus yugvalla haa'as. Davudee cun insanar Naxaşne dixene Xanunne k'anyaqa, dekkıs baş-sağlığıyvalla hevles g'uxoole. Davudun insanar Ammonne ölkeeqa qabı hipxhırmee, ");
INSERT INTO tkr_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","Ammonbışde ç'ak'ınbışe cone xərıng'uk'le Xanunuk'le eyhen: – Vak'le həməxüdmede ats'a, Davudee baş-sağlığıyvalla hevles insanar yiğne dekkıs hı'rmatnemeene g'uxoole? Davudee yiğne k'anyaqa insanar şahar uleke alğaahas, mana vaats'a vuxha, qiyğab hı'ğəəkar haa'as g'axuvu! ");
INSERT INTO tkr_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","Xanunee Davudun insanar avqu, manbışin saqqalbı suralqamee, tanalqa ali'iyn karbıd avğançe giviy'arne cigeeqamee gyatxas ilekka. Qiyğab mang'vee manbı cone xaybışeeqa yəqqı'l haa'a. ");
INSERT INTO tkr_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","Man kar Davudus yuşan hı'ımee, manbı naşvalin habat'ava, Davudee manbışde ögiylqa insanar g'uxoole. Paççahee eyhen: – Saqqalbı aleelesmee Yerixoyee aaxve, qiyğa savk'le. ");
INSERT INTO tkr_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","Ammonbışik'le co Davudne ulele gyapk'ı g'ooce. Manke manbışe Bet-Rexoveeneyiy Tsova eyhene cigeene Arambışike cos g'ad aazır (20 000) hoyharna esker pılıke kumagıs qot'alecenva insanar g'uxoole. Manbışe Maaka eyhene cigayna paççah aazırne (1 000) insanıka, sayir Tov eyhene cigeençe yits'ıq'vəd aazır (12 000) insan qoyt'al. ");
INSERT INTO tkr_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","Davuduk'le man ats'axhxhamee, Yoavıka gırgın yugba sıç'ookan cehilyarnana g'oşun mang'ul ooqa g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","Ammonbı qığeepç'ı, şaharne akkabışde ögiyl saç'uvkasınbı xhinne giviyk'an. Tsovayniy Rexovın Arambı, Tov eyhene cigayneyiy Maaka eyhene cigayne insanaaşika qığeepç'ı, g'ab curayba ulyoozar. ");
INSERT INTO tkr_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","Yoavık'le cune g'oşunne ögiyleyiy yı'q'əle duşmanar gipk'ın g'avcumee, mang'vee İzrailyne gırgıne g'oşunuke yugun gəvxüyn cehilyar curav'u, Arambışde ögiylqa giviyk'an. ");
INSERT INTO tkr_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","Avxuyne insanaaşilqar cuna çoc Avişay xərna gixhxhı, manbı Ammonbışde ögiyl giviyk'an. ");
INSERT INTO tkr_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","Yoavee Avişayık'le eyhen: – Arambı zale gucuka vuxheene, ğu zas kumagıs ayre. De'eş, Ammonbı vale gucuka vuxheene, zı vas kumagıs ayres. ");
INSERT INTO tkr_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","Yik'eka ixhe. Qora, yişde milletnemee, yişde Allahne şaharbışdemee, yişda adamiyvalla haagvas. Hasre Rəbbeyid Cusqa neniy yugda qöö, man he'ecen. ");
INSERT INTO tkr_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","Yoaviy mang'una g'oşun Arambışika sıç'ookka gibğılmee, Arambı Yoavne ögiyle heebaxanbı. ");
INSERT INTO tkr_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","Ammonbışik'le Arambı heebaxa g'avcumee, coyub Avişayne ögiyle heepxı, şahareeqa ikkeebaç'e. Ammonbışikan saç'ivkuy ç'əvxhamee, Yoav İyerusalimqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","Arambışik'le co İzrailybışile avub aaxva g'avcumee, manbı sacigeeqa savayle. ");
INSERT INTO tkr_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","Manbışde paççahee, Hadadezeree, insan g'axuvu, Fərat eyhene damayne şene aq'valin Arambı dəv'eeqa qığaa'a. Manbıb Hadadezerne g'oşunne xərıng'uka, Şovakıka, sacigee Xelam eyhene şahareeqa abayle. ");
INSERT INTO tkr_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","Mançina xabar Davudus abımee, mang'vee gırgın İzrailybı sav'u, İordanne damayle ılğeç'u, Xelameeqa arayle. Arambı Davudne ögiyl saç'uvkasva giviyk'an. ");
INSERT INTO tkr_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","Arambı İzrailybışde ögiyle heebaxanbı. Davudee Arambışda yighıd vəş (700) dəv'əyn daşk'a he'ekkana, yoq'ts'al aazırır (40 000) balkanıl alixı arına esker gek'a. Manbışda g'oşunna xərna Şovakır, Davudee ı'xı' maacar gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","Hadadezerne xılek avubne paççahaaşik'le con gırgınbı İzrailybışis avub avxu g'avcumee, manbışe İzrailybışikana dəv'ə ç'əv hav'u, manbışis nukarar vooxhe. Mançile qiyğa Arambı qəvəyq'ənanbı Ammonbışis kumagbı ha'as. ");
INSERT INTO tkr_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Yuxhxhan qadımee, paççahar dəv'əys qığeebaç'ene gahıl, Davudee Yoav cune insanaaşikayiy gırgıne İzrailyne g'oşunuka dəv'eeqa yəqqı'l ha'a. Manbışe Ammonbışikın hı'ı, manbışda paytaxt Rabba hıqiy-allançe avqaaqqa. Davud vucmee İyerusalimcar axva. ");
INSERT INTO tkr_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Sa yiğıl exheeqana, Davud tyuleençe suğotsu, cune paççahaaşine sarayne daxalqa ılqeç'u maa'ar iykar giyğal. Mana daxayle ilyakkımee, mang'uk'le sa zəiyfa əyeexər g'eece. Mana zəiyfa geer uftanna yixha. ");
INSERT INTO tkr_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Zəiyfayne hək'ee qiyghanasva Davudee insan g'ıxele. G'axuvuyne insanee eyhen: – Mana zəiyfa Q'etbışda eyxhene Uriyna xhunaşşe, Eliamnar yiş Bat-Şeva vor. ");
INSERT INTO tkr_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Davudee insanar g'axuvu mana cusqa ayree'e. Mana zəiyfa Davudusqa arımee, məng'ı'n yadaaşik eyxhenbı manke ç'əveetxha ıxha. Davud məng'ı'ka g'ılexhana. Mançile qiyğa zəiyfa cene xaaqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Zəiyfa vuxhne eexva. Məng'ee Davudusqa insan g'ıxele «Zı vuxhne vorva» eyhes. ");
INSERT INTO tkr_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Davudee Yoavne k'anyaqa insan g'axuvu eyhen: – Q'etbışda eyxhena Uriy yizde k'anyaqa g'axıle. Yoavee Uriy Davudne k'anyaqa g'ıxele. ");
INSERT INTO tkr_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Uriy Davudne k'anyaqa arımee, Davudee mang'uke Yoaviy g'oşun nəxübne, dəv'ə nəxübne əlyhəəva qiyghan. ");
INSERT INTO tkr_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Qiyğa Davudee Uriyk'le eyhen: – Xaaqa hoora, sık'ırra g'alixhe. Uriy paççahne sarayeençe qığeç'umee, paççahee yı'q'əle mang'us pay g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Uriymee xaaqa ayk'an deş. Mana paççahne manesa nukaraaşika sacigee sarayne akkayne ghalee g'ılexha. ");
INSERT INTO tkr_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Davuduk'le «Uriy xaaqa ark'ın deşva» uvhumee, mang'vee Uriyke qiyghanan: – Nya'a, ğu yəqqı'le dişde qarı? Nya'a xaaqa idyark'ın? ");
INSERT INTO tkr_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Uriyee Davuduk'le eyhen: – Allahıka mugavilenana q'utye, İzrailybı, Yahuder çadırbışee aaxvamee, yizda xərna eyxhena Yoaviy eskerar g'ab çolbışee aaxvamee, ho'ne zı xaaqa ark'ın otxhan-ulyoğa xhunaşşeyka g'alixhe? Valqaniy yiğne canılqan k'ın ixhen, zı məxdın kar mısacad ha'as deş. ");
INSERT INTO tkr_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Davudee Uriyk'le eyhen: – Ğu g'iynar inyaa axve, zı ğu g'iyqa yəqqı'l ha'asda. Uriy mane yiğılir, qinne yiğılir İyerusalim axva. ");
INSERT INTO tkr_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Davudee mana cusqa qort'ul yugda otxhun-ulyoğu'ı keçe xhinne qa'a. Uriy paççahısse exheeqana qığeç'e. Mana g'alixhasva meer cune ögiylynecar cigeeqa, paççahne nukaraaşisqa ayk'an. Mana cune xaaqa meer ayk'an deş. ");
INSERT INTO tkr_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Miç'eed qıxhamee, Davudee kağız otk'un, Yoavısqa hixhar he'ecenva Uriysqa qele. ");
INSERT INTO tkr_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Kağızee inva otk'un eyxhe: «Uriy it'umba dəv'ə əəne cigeeqa yəqqı'l he'e. Mana ögiyl ulyozar he'e, qiyğa zaraba şu yı'q'əlqa ts'ıts'eepxhe, hasre mana ı'xı' gik'ecen». ");
INSERT INTO tkr_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Yoavee şahar hiqiy-allançe avqumee, mang'uk'le şenbışin yugba aldaaxhvananbı nene surak vuxhay ats'anniy. Mançil-allar mang'vee Uriy mane suralqa salat' ha'a. ");
INSERT INTO tkr_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Şaharın insanar Yoavıka səvxəsva, şaharıke g'aqa qığeebaç'e. Manke Davudne g'oşunun sabarabı habat'anbı, habat'anbışde yı'q'nee Q'etbışda eyxhena Uriyer ıxhana. ");
INSERT INTO tkr_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Yoavee Davudne k'anyaqa dəv'ə nəxübiy ılğevç'uva xabar ana insan g'ıxele. ");
INSERT INTO tkr_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Mang'vee xabar ana g'ıxelene insanıs xət qa'an: – Ğu dəv'əyne hək'ee yuşan hı'ı ç'əvexhemee, ");
INSERT INTO tkr_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","paççahıs sayıb mançike qəl vuxha vake qiyghınee: «Nya'a şu səvxəsva şaharısqa manimee k'ane qeepxha? Nya'a şok'le ats'a dişdiy, manbışe cabırbışile vukbı ahas ıxhay? ");
INSERT INTO tkr_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Şavaane Yerubbeşetna dix Avimelek gik'u? Nya'a, cabırıle dişdiy mang'ulqa sa zəiyfee yöxxəyna g'aye g'a'apçı, mana Tevetsee gik'u? Nya'a şu manimee cabırbışisqa k'ane qeepxha?» Manva paççahee vak'le uvheene, ğu mang'uk'le eyhe: «Yiğna nukar Q'etbışda eyxhena Uriyer qik'una». ");
INSERT INTO tkr_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Xabar ana ı'qqəna insan yəqqı'lqa gexha. Mana qarı Davudusqa hirxhıl, Yoavee cuk'le uvhuyn gırgın mang'us yuşan ha'an. ");
INSERT INTO tkr_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Xabar ana arıyne insanee Davuduk'le eyhen: – Şen insanar şalqa k'yoptul, şaka saç'uvkasva şaharıke g'aqa qığeepç'ı. Şinab manbı şaharne akkabışisqamee yı'q'əlqa g'ee'epşiynbı. ");
INSERT INTO tkr_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Vukbı ayhenbışee cabırbışile paççahne eskeraaşilqa vukbı gyoğu'u, paççahne eskeraaşike habat'anbıb vuxhaynbı. Yiğna nukar Q'etbışda eyxhena Uriyer maa'ar qik'una. ");
INSERT INTO tkr_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Davudee xabar abıyng'uk'le eyhen: – Yoavık'le eyhe: «Mançil-alla aq'va havaxan hıma'acen. G'ılıncın ina-şena geer gik'u. Həşdiyle guc sacigeeqa sav'u, mane şaharılqa sayıb k'yoohre, mana hı'ğəəkar hee'e». Məxüd ğu Yoavıs yik'bı hele. ");
INSERT INTO tkr_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Uriyne xhunaşşeyk'le Bat-Şevayk'le Uriy qik'uva g'ayxhımee, mang'us ak' avqaaqqa. ");
INSERT INTO tkr_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Ak' ç'əvuvxhayle qiyğa, Davudee insan g'axuvu, Bat-Şeva cune xaaqa qiyelee'e. Məng'ı'ke cus xhunaşşe hee'e. Qiyğa məng'ee Davudus dix uxooxa. Davudee hav'una mana iş Rəbbine yik'eençe vooxhe deş. ");
INSERT INTO tkr_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Rəbbee Natan peyğambar Davudne k'anyaqa g'ıxele. Natan mang'une k'anyaqa arı, inəxüd eyhe: – Sa şaharee q'öyre insan vooxhe. Manbışda sa karnana manasar kar deşda eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Karnane insanıqa geed çavra-vəq'ə eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Kar deşdang'uqamee alivşu xəp qaa'ane vughulyne bederıle ğayrı, vuççud eyxhe deş. Mang'vee mana beder cune uşaxaaşika sacigee xəp qaa'a vuxha. Mançin mang'une xılençe kar oyxhan ıxha, mang'une k'oleençed xhyan ulyoğa ıxha. G'alyuvxhasıb mana mang'ul oo g'ulyoxha vuxha. Mana mang'unemee yişşene cigee vuxha. ");
INSERT INTO tkr_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Sayəqees karnane insanısqa menne cigabışeençe mihman arayle. Karnane insanıs cong'əə arıyne mihmannemee otxhuniy ha'asva cune çavra-vəq'əyke həyvan avqu givk'as qiviykkanna. Mang'vee hark'ın kar deşing'una beder avqu abı, cong'əə arıyne mihmanıs otxhuniy ha'a. ");
INSERT INTO tkr_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Davudna mane insanılqa qəl avqu, Natanık'le eyhen: – Vorne Rəbbilqan k'ın ixhen, man hı'iyne insanıs qik'uyud avaak'a. ");
INSERT INTO tkr_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Rəhı'm hidyav'u, məxbına iş g'avcuva, mang'vee mane bederıl-alla yoq'nəqees geed kar qeles. ");
INSERT INTO tkr_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Natanee Davuduk'le eyhen: – Mana insan ğu vorna! İzrailyne Allahee Rəbbee inəxüdud eyhe: «Zı ğu İzrailyna paççah xhinne g'əyxı', Zı ğu Şaulne xılençe g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Zı vas yiğne xərıng'un xav huvu. Mang'un yadar Zı yiğne xhılibışeeqa quvu. Zı vas İzrailiniy Yahudayn milletbı huvu. Man vak'le k'ılda g'acuxhee, Zı vas mançile hexxanıd helesınniy. ");
INSERT INTO tkr_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Nya'a ğu Rəbbine ulesqa pisba qööna iş hav'u? Nya'a ğu Mang'un cuvab g'eliqqa huvu? Q'etbışda eyxhene Uriyne xhunaşşeyke vas xhunaşşe hee'esva, ğu mana g'ılıncıqqa huvu. Ğu mana Ammonbışde xıleka gik'u. ");
INSERT INTO tkr_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","G'iyniyke şaqa yiğne xaake mısacad g'ılınc əq'əna qixhes deş. Ğu Yizın cuvab g'eliqqa huvu, Q'etbışda eyxhene Uriyne xhunaşşeyke vas xhunaşşe hey'ı». ");
INSERT INTO tkr_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Rəbbee inəxüdud eyhe: «Zı vakın divan yiğne xaabınbışisqacad qaqqas alikkas. Zı yiğne ulene ögiyl, yiğın yadar alyapt'ı, vas delesne insanısqa qevles. Manar yiğne-yiğın, ulek'le g'ece-g'ece yiğne yadaaşika g'alixhas. ");
INSERT INTO tkr_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Ğu man kar dyugulenda hı'ı, Zımee man kar yiğene yı'q'ı'hne gahıl gırgıne İzrailybışde ulene ögiyl ha'as alikkas». ");
INSERT INTO tkr_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Davudee Natanık'le eyhen: – Zı Rəbbine ögiyl bınah hav'u. Nataneeyid sak'ı, Davuduk'le eyhen: – Rəbbee yiğna bınah havaakal hav'una, ğu qik'as deş. ");
INSERT INTO tkr_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Ğu məxdın kar hı'iyle qiyğa, Rəbbine duşmanaaşisser Mana k'ap'ik'ıle avqa qa'as əxə. Mançil-allar vake ıxhana dix qik'asda, axvas deş. ");
INSERT INTO tkr_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Mançile qiyğa Natan cune xaaqa siyk'al. Rəbbee, Davudna dix ık'iyk'ara'ana. Man uşax qik'uyne Uriyeyne xhunaşşeyken ıxha. ");
INSERT INTO tkr_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Davudee uşaxnemee Allahıs düə haa'a. Mana sivacı xəmbı cune gozee q'ərane ç'iyel alğa'a. ");
INSERT INTO tkr_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Sarayn ağsaqqalar mana ç'iyele oza qa'asva qabı k'ane ulyoozar. Mana ozar qexhe deş, karıd oyxhan deş. ");
INSERT INTO tkr_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Yighıd'esde yiğıl uşax qek'an. Davudun nukarar uşax qik'uva mang'uk'le eyhes qəvəyq'ənanbı. Manbışisqa məxüd qayle: – Uşax üç'ürnang'a, şi mana ittunçil aqqeyir, mang'vee şal k'ırı alixhxhı deş. Həşde uşax qik'uva şi mang'uk'le nəxüdne eyhes? Sayid cuk sa kar ha'a. ");
INSERT INTO tkr_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Davuduk'le cune nukaraaşe ğud-ğud haa'a g'avxhumee, uşax qik'uva ats'axhxhen. Mang'vee manbışike «Uşax qik'uynneva?» qiyghan. Manbışe «Ho'ova» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Man g'ayxhı, Davud ç'iyele oza qıxha, əyxı'r-səyxı'r vuk'lelqa zeytunun q'ışid qadğu, tanalinbıd badal hı'ı, Rəbbine xaaqa hark'ın, Mang'us kyoyzarna. Qiyğa mana mançe cune xaaqa sak'ı, cus otxhuniy heleva eyhe. Cus oxhanas hucooyiy huvu, mang'vee oyxhanan. ");
INSERT INTO tkr_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Nukaraaşe mang'uke qiyghanan: – Ğu in ha'an kar hucoone? Uşax üç'ürnang'a, ğu sivacı geşşu-gyaxvananiy, həşde uşax qik'umee, ğu oza qıxha kar otxhan girğıl? ");
INSERT INTO tkr_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Davudee manbışis inəxdın alidghıniy qele: – Uşax üç'ürnang'a, zı sivacı geşşu-gyaxvananiy. Zalygena ixhee, Rəbbis zı qiykkın, uşax gidek'avaniy eyhe. ");
INSERT INTO tkr_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Həşde uşax qik'uyn, zı nişisne siv aqqas? Nya'a mana zasse yı'q'əlqa sak'al ha'as əxəyee? Mana zasqa sak'alas deş, zı mang'usqa əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Qiyğa Davudee xhunaşşeys Bat-Şevays yik'bı hele, ikkeç'u məng'ı'ka g'ılexha. Mana vuxhne ayxu dix uxooxa. Davudee mang'un do Sıleyman giyxhe. Rəbbis man uşax ıkkiykanan. ");
INSERT INTO tkr_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Mang'vee maqa Natan peyğambar g'ıxele, mangv'eeyid uşaxın do Yedidiyah (Rəbbis ıkkanna) giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","Yoavee Ammonbı vooxhene Rabba eyhene şaharılqa cuna g'oşun k'yoohar hav'u, maana paççahna g'ala avqaaqqa. ");
INSERT INTO tkr_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","Qiyğa Yoavee Davudne k'anyaqa ina xabar ana insanar g'uxoole: – Şi Rabba eyhene şaharılqa k'yophur, manbışe xhyan havacen cigabı aqqı. ");
INSERT INTO tkr_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","Həşdiyle ğu avxuna g'oşun sav'u, arı mane şaharın hiqiy-alladın cigabı aqqe. Qiyğab vuc şahar alept'e. Deşxheene, zı mana şahar avqee, mançis yizın do heles. ");
INSERT INTO tkr_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","Davudeeyib avxuna g'oşun sav'u, Rabbeeqa arı, dəv'əyka mana avqaaqqana. ");
INSERT INTO tkr_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","Mang'vee manbışde paççahne vuk'lele tac alyaat'u, cune vuk'lelqa giyxhe. Man tac k'ınəəğəyke hı'ı ıxha, çina yı'q'vaalab sa talant vuxha. Mançine hiqiy-allançed gıranın g'ayebıyiy gitk'ın. Davudee mane şahareençe geed gıranın kar qığa'a. ");
INSERT INTO tkr_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","Mane şahareedın millet mang'vee qığatxhu, ayxaaka, yivayne kılıngıkayiy yak'uka işbı gaces ilekka. Qiyğale xhinne manbışisqa karpıç ha'as ilekka ıxha. Davudee Ammonbışde gırgıne şaharbışik man hı'iyle qiyğa, qığeç'u cune g'oşunuka İyerusalimqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","Qiyğa in ıxha. Davudne dixeqa Avşalomuqa Tamar donana micagna yiçu yixha. Davudne menne dixes Amnonus mana Tamar yikkiykan. ");
INSERT INTO tkr_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","Amnonus cuna duvuxna yiçu Tamar manimee yikkiykan, mana mançike ık'iyk'arna. Mana adamiys hidyark'ınna içiy yixhayke, Amnonus məng'ı'k hucoomecad ha'as dağamda qöö ıxha. ");
INSERT INTO tkr_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","Amnonuqa Yonadav donana sa hambaz ıxha. Yonadav Davudne çocuna, Şimayna dix ıxha. Vucur geer bicna kar ıxha. ");
INSERT INTO tkr_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","Yonadavee Amnonuk'le eyhen: – Ay paççahna dix, nya'a ğu yiğ-yiğıle k'eçe? Ğu man zak'le eyhelan! Amnonee mang'uk'le eyhen: – Zas yizde çocuna Avşalomna yiçu Tamar yikkan. ");
INSERT INTO tkr_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","Yonadavee mang'uk'le eyhen: – Tyuleeqa k'iç'u, ğucar ğu ık'arna xhinne hagve. Dek ğu g'acesva vasqa arımee, mang'uk'le eyhe: «Hucoona ixhes, yuçeyk'le Tamarık'le eyhe arı zas kar oxhan he'ecen. Yizde ulene ögiyl zas otxhuniy he'ecen, zak'ler mana g'ayces, məng'ı'ne xılençe kar oxhanas». ");
INSERT INTO tkr_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","Amnon tyuleeqa k'iç'u, vuceecar vuc ı'kar hag'va. Paççah mana g'acesva arımee, mang'vee paççahık'le eyhen: – Hucoona ixhes, yizda yiçu Tamar ayrecen, yizde ulene ögiyl zas q'öble kokay hee'ecen, zınad manbı cene xılençe oxhanas. ");
INSERT INTO tkr_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","Davudee xaaqa insan g'axuvu, Tamarık'le eyhen: – Həşde yiğne çocune Amnonne xaaqa hiyek'ne, mang'us oxhanasın kar he'e. ");
INSERT INTO tkr_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","Tamar çocune Amnonne xaaqa hark'ıning'a, mana g'alirxhu eyxhe. Tamare xamır hı'ı, çocune ulene ögiyl kokaybı qece. ");
INSERT INTO tkr_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","Qiyğa məng'ee tava alyapt'ı, çocune ögiylqa otxhanan kar giyxhe. Mang'us oxhanas ıkkiykan deş. Amnonee eyhen: – Hasre gırgınbı zasse qığeepç'ecen. Gırgınbı mang'usse qığeebaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","Amnonee Tamarık'le eyhen: – Otxhanan kar anne gozeeqa qıkkee, maa'ad zı yiğne xılençe alyaat'u oxhanasın. Tamare çocusva hı'iyn kokaybı alyaat'u, anne gozeeqa qıkkekka. ");
INSERT INTO tkr_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","Kokaybı Amnonee oxhnecenva cusqana qıkkekkamee, Amnon Tamarık at'irq'ın eyhen: – Yiçu, qeera zaka g'aliyxhe. ");
INSERT INTO tkr_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","Tamare mang'uk'le eyhen: – De'eş çoc, yizın do qığmayhe! İzrailee məxdın karbı ha'anbı deşxhe. Məxbına beynyavavalla hımaa'a. ");
INSERT INTO tkr_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","Məxdıne doyuka zı nyaqana yixhes? Yiğınıd İzrailee beynyavava do qığeç'es. Həşde hucoona ixhes, ğu hark'ın paççahıka yuşanxhe, mang'vee zı vas heylesda. De'eşva eyhes deş. ");
INSERT INTO tkr_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","Amnonee məng'ı'l k'ırı ilydixhı, guc geeb vuxhayke mana qıkkeek'val hey'ı, məng'ı'ka g'ılexhana. ");
INSERT INTO tkr_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","Mançile qiyğa Amnonuk'le Tamar g'ımeece qeexhe. Amnonus Tamar cus yic yikkanançiler geer g'imeece qeexhe. Mang'vee Tamarık'le «Oza qiyxha ğadariyxheva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","Tamare mang'uk'le eyhen: – De'eş, yizda çoc! Ğu zı g'e'eyşuyka, mançile ögiyl hav'uyne pisvalileb, sık'ılbab xəbna pisvalla zas haa'a. Amnonee məng'ı'l k'ırı ilydiyxhı, ");
INSERT INTO tkr_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","cuna nukar qort'ul eyhen: – İna zasse g'e'eyşu, akka qe'e! ");
INSERT INTO tkr_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","Nukareeyir içiy g'aqa qığeyhı, akka qa'an. İçiyne tanal gıranın micagın gurt eyxhe. Məxdın gurtbı paççahne adamiys hidyapk'ınne yişbışe alya'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","Tamaree vuk'lelqa yı'q k'yaa'a. Qiyğad tanalin gurt qıt'axxı'ı, vuk'lelqa xıleppıd aqqı hülöörəxə geeşe-geeşe iyeek'anna. ");
INSERT INTO tkr_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","Çocee Avşalomee məng'ı'kle eyhen: – Vaka, yiğna çoc Amnonne g'alirxhu? Yiçu, həşde nıq' qığmayhe, mana yiğna çoc vorna. Man ıxhayn yik'eeqa ıkmekka. Məxür Tamar cene çocune Avşalomne xaa gırgıng'vee dağerçuna xhinne eexva. ");
INSERT INTO tkr_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","Paççah Davuduk'le mana gaf g'avxhumee, mana qəlın əq'əna. ");
INSERT INTO tkr_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","Avşalomee Amnonuk'le yugunud pisınıd cuvab eyhe deş. Mang'vee yiçu mıc hey'ı, məng'ı'ka g'alirxhuynçil-alla Avşalomuk'le Amnon g'ımece ıxha. ");
INSERT INTO tkr_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","Ooğançe q'ölle sen ılğeç'uyle qiyğa, Efrayim eyhene şaharıs k'anene Ba'al-Xatsoree Avşalomee vəq'əbı qoyşar eyxhe. Avşalomus paççahın gırgın dixbı maqa otxhun-ulyoğas qoot'alas vukkiykan. ");
INSERT INTO tkr_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","Mana paççahısqa arı, eyhen: – G'iyna zı, yiğne nukaree, vəq'əbı qoyşar. Hucoona ixhes, g'iyna paççahiy cun insanar zasqa savaale. ");
INSERT INTO tkr_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","Paççahee Avşalomuk'le eyhen: – De'eş dix, yişin gırgınbı abee, vas yı'q'da gyuaras. Avşalomee mana nimee ittunçil aqqeyir, paççah maqa arayle deş. Paççahee Avşalomus xayir-düəyib huvu, mana yəqqı'l araççe. ");
INSERT INTO tkr_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","Avşalomee meed eyhen: – Manke yizda çoc Amnonxheeyir şaka g'axıle. Paççahee mang'uke qiyghanan: – Nişisne mana şoka ıkkekka? ");
INSERT INTO tkr_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","Avşalomee xıl ts'ıts'aa'a deş. Davudee manke Amnonur gırgın cun dixbıb mang'uka g'uxoolenbı. ");
INSERT INTO tkr_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","Avşalomee cune insanaaşilqa əmr haa'a: – İlyaake Amnonee çaxır ulyodğu vuc xhinne qıxhamee, zı şok'le «Amnonus ı'xeva!» eyhes. Manke şu mana gik'e, qı'məəq'ən. Zı şos əmr hoole! Adamer vuxhe, yik'eka vuxhe! ");
INSERT INTO tkr_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","Avşalomee nəxüdiy uvhu, nukaraaşed həməxüd Amnonus ı'xiyxən. Paççahne dixbışik'le eyxhenbı g'acu, zaraba cone g'atiraaşilqa aleepxı, mançe heebaxanbı. ");
INSERT INTO tkr_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","Manbı yəqqənang'a Davudulqa inəxübna gaf hiviyxhar: – Avşalomee paççahın gırgın dixbı gyapt'ıynbı, manbışda nenacar üç'ürra g'alerçu deş. ");
INSERT INTO tkr_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","Paççah oza qıxha, tanalin qıt'axxı'ı, ç'iyelqa gizyaraççe. Mang'une k'anene gırgıne cune insanaaşed tanalinbı qıt'axxa'anbı. ");
INSERT INTO tkr_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","Davudne çocune Şimayne dixee Yonadaveeme inəxüd eyhe: – Yizde xərıng'usqa həməxüd qımaylecen, cune dixbışin gırgınbıniyxan hapt'ı. Saccu Amnoncar qik'u. Avşalomuqa məxbına fıkır cuna yiçu Tamar Amnonee cuka g'aliyxhas aliykkıyne yiğıle vuxha. ");
INSERT INTO tkr_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","Hasre yizde xərıng'un paççahın gırgın cun dixbı hapt'ıva gaf g'avxhuva yik' gimoyxhancen. Saccu Amnoncar qik'u. ");
INSERT INTO tkr_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","Avşalommee hixu ark'ın ıxha. G'aravulee, vuk'ul ooqa qav'umee, tepayle geeb insanar gəə g'ooce. ");
INSERT INTO tkr_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","Yonadavee paççahık'le eyhen: – Haane paççahın dixbı qöövub! Zı, yiğne nukaree, nəxüdiy uvhu, həməxüdud eyxhen. ");
INSERT INTO tkr_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","Mang'vee cuvab uvhu g'attirxhınmee, axtıba gyaaşe-gyaaşe maqa paççahın dixbı ikkeebaç'e. Paççahır gırgın cun insanarıb hülööbəxə gyaaşe giviyğal. ");
INSERT INTO tkr_vpl VALUES ("S213_37","011_13_37","2SA","13","37","38","Davudee yiğıs-yiğıs dixes, Amnonus, ak' avqaaqqa vuxha. Avşalomeeme hixu Geşurne paççahne Talmayne k'anyaqa ayk'an. Talmay Ammihudna dix ıxha. Geşureeqa hixuna Avşalom maa'ar xhebılle senna axva. ");
INSERT INTO tkr_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","Amnon qik'u, ooğançe sabara gah ılğevç'ule qiyğa, paççah Davud culqa qarayle. Mana Avşalomuke qəl qığahasva qihna gexha deş. ");
INSERT INTO tkr_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","Tseruyayne dixek'le Yoavık'le ats'anniy, paççahın yik' Avşalomuqa gyotxhan ıxhay. ");
INSERT INTO tkr_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","Yoavee Teqoayeeqa insan g'ıxele mançe ats'alynana zəiyfa ayres. Mang'vee arıyne zəiyfayk'le eyhen: – Hucoona ixhes, ğucar ğu ak' avquyn xhinne heegve. K'aarın tanalinbı ale'e, vuk'lelqa zeytunun q'ış qımadağva, ğucar ğu qik'uyng'unemee geer yiğbına geeşen xhinne heegve. ");
INSERT INTO tkr_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","Paççahne k'anyaqa hark'ın, inəxüd eyhe. Yoavee, paççahık'le hucooyiy eyhesva, xət qa'an. ");
INSERT INTO tkr_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","Teqoayeençena zəiyfa paççahısqa ikkeyç'u, mang'une ögee aq'vak k'ena ç'iyelqa gizerçu, eyhen: – Ay paççah, kumag he'e! ");
INSERT INTO tkr_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","Paççahee mang'uk'le eyhen: – Vak hucoona ıxha? Zəiyfee eyhen: – Zalqa yiğ adı, yizda adamiy qik'u. Zı sip'ıriy vorna. ");
INSERT INTO tkr_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","Zaqa, yiğne nukarıqa, q'öyre dixniy vor. Sa yiğıl manbışda q'öyre çolee sana-sang'uka aldapxhıninbı. Maa'ar manbı curaa'asda vuşucar ıxha deş. Sang'vee manasa ı'xı' gik'una. ");
INSERT INTO tkr_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","Həşde gırgınacab xizan zalqa g'elil quvxha, manbışe eyhen: «Çoc gik'una şasqa qale, şi mana çoc gik'yunçil-alla gik'as. Dekkın kar şavusiy axvas manar gik'as». Manbışe məxüd zaqa vodun-deşin man ts'ünq' q'ətqa'as. Məxüb manbışe ç'iyeyne aqval yizde adamiyke g'abıynbı g'alepçes deş. ");
INSERT INTO tkr_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","Paççahee zəiyfayk'le eyhen: – Xaaqa sayk'le. Zı yiğne hək'ee əmr haa'asda. ");
INSERT INTO tkr_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","Teqoayeençene xhunaşşee paççahık'le eyhen: – Yizda xərna paççah, hasre mançina bınah zalqayiy yizde xizanılqa vuxhecen! Paççahılqayiy cune taxtılqa bınah gyumooxhacen! ");
INSERT INTO tkr_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","Paççahee eyhen: – Şavaayiy vak'le sa cuvab uvhu, mana zasqa ayre. Mançile qiyğa mana vak sayır set'as deş. ");
INSERT INTO tkr_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","Zəiyfee eyhen: – Hucoona ixhes, paççahee, Rəbbilqa, cune Allahılqa k'ın g'aysrecen, şavusqacad yizde dixıke qəl qığaahas havaasaras deşva. Deşxhee, manbışe yizda dix gik'as. Davudee eyhen: – Vorne Rəbbilqan k'ın ixhen, yiğne dixene vuk'lele ç'ərıb g'a'avxhas deş. ");
INSERT INTO tkr_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","Zəiyfee Davuduk'le eyhen: – Hucoona ixhes, zasqa sa cuvab eyhes hasre. Paççahee «Eyheva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","Zəiyfee eyhen: – Nya'a manke ğu, Allahne milletne ögiyl məxbına iş hav'u? Ğu məxüd uvhuyka, valqa bınah qaa'a. Menne cigeeqa hixu ark'ınna yiğna dix ğu vasqa sak'al hı'ı deş. ");
INSERT INTO tkr_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","Yişin gırgınbı hapt'asınbı, şi ç'iyelqa ott'ulne yı'q'əlqa sa'as dexhene xhyanık akar. Allaheeyid insanıke ts'ıts'ı'ı can g'eşşe deş, Mang'veeyib Cuke əq'ənaqa girxhuna nəxürne Cus k'ane qa'asva fıkır ooxhan. ");
INSERT INTO tkr_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","Zı milletın qı'yeeq'ən hey'ı, çil-allar zı həşde vasqa, yizde xərıng'usqa paççahısqa arı. Yizde fıkreeqa qadıyn: «Hark'ın paççahıka gaf haa'as, sayid mang'vee zı uvhuyn ha'a. ");
INSERT INTO tkr_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","Paççahee, zı uvhunçil k'ırı alixhxhı, zınayiy yizda dix, şi gyapt'as vukkanang'une xılençe g'attivxhan haa'a. Məxüb şi Allahne milletne yı'q'neençe hakkal hidyaa'a». ");
INSERT INTO tkr_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","Mançil-alla zı məxüd uvhu: «Yizda xərna paççah, sa cuvab eyhe, yizın yik' cigeeqa qoracen». Vasse Allahne malaaikısse xhinne yugun pisınçike cura'as əxən. Hasre Rəbb, yiğna Allah, vas kumagxhecen! ");
INSERT INTO tkr_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","Paççahee zəiyfayk'le eyhen: – Zı vake sa cuvab qiyghanas, mançin alidghıniy zake dyugul hıma'a. Zəiyfee eyhen: – Yizda xərna paççah, hucoona ixhes qiyghne. ");
INSERT INTO tkr_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","Paççahee qiyghanan: – İne yiğne işee Yoavna xılyne alivku vob? Zəiyfee alidghıniy qele: – Yizda xərna paççah, valqan k'ın ixhen, şavussecad val k'ırı ilydiyxhı t'ub cigeençe ı'ğviykar haa'as vəəxəs deş. Ho'o, yiğne nukaree Yoavee zas əmr hav'u, zı hucooyiy eyhes ıkkanvad, mang'vee xət qı'ı. ");
INSERT INTO tkr_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","Məxüd yiğne nukaree Yoavee mana iş qa'asva hı'ı. Yizde xərıng'una paççahna ək'el, Allahne malaaikna ək'elymee geeb vob, mang'uk'le dyunyel eyxhen gırgın ats'an. ");
INSERT INTO tkr_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Paççahee Yoavık'le eyhen: – Ho'o, zı man kar ha'asın. Hoora, şena mek'vna Avşalom yı'q'əlqa sak'al he'e. ");
INSERT INTO tkr_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Yoav aq'vakkena ç'iyelqa gizerçu, «Ğu paççah geer qa'anava» uvhu. Qiyğa Yoavee meed eyhen: – G'iyna paççahee, cune nukaree uvhuyn hı'ı. Həşde zak'le, yiğne nukarık'le, ats'axhxhayn, vasqa zı yugra qarı ıxhay. ");
INSERT INTO tkr_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Yoav Geşureeqa hark'ın, Avşalom İyerusalimeeqa sak'al ha'a. ");
INSERT INTO tkr_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","Paççaheeme eyhen: – Hasre mana cune xaaqa sak'lecen, yizde ulesqa qımaylecen. Avşalom cune xaaqa siyk'al, mana paççahne ulesqa qarayle deş. ");
INSERT INTO tkr_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","İzrailyvolle Avşalom xhinne micagna adameeşina insan ıxha deş. Gırgıng'us mana ıkkan ıxha. Vuk'lele kıts'alqamee mang'uqa qəlan ciga ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Senıs, ç'ərbışe mang'us yı'q'valla haa'ava, mang'vee manbı gyadaxa ıxha. Qiyğad g'apanıl gyoodkumee, q'öd vəş (200) şekel qadayle ıxha. (Şekel paççahee gixhxhiyn standart ıxha.) ");
INSERT INTO tkr_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","Avşalomuqa xhebiyre dixiy Tamar donana sa yiş yixha. Tamar geer micagna içiy yixha. ");
INSERT INTO tkr_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Avşalom q'ölle senna İyerusalim axveeyir, mang'uk'le paççahın aq'va g'ece deş. ");
INSERT INTO tkr_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Avşalomee Yoavıqar qihna insan g'ıxele. Avşalomus ıkkananniy, Yoavee vuc paççahısqa ıkkı. Yoavıs mang'une k'anyaqa ayres ıkkiykan deş. Avşalomee q'ör'es Yoavne k'anyaqa insan g'ıxele. Mang'us meer mang'une k'anyaqa ayres ıkkiykan deş. ");
INSERT INTO tkr_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Avşalomee manke cune nukaraaşik'le eyhen: – İlyaake, Yoavın xhıt'anan çol yizde çoluk at'itq'ın vod. Hapk'ın, maqa ts'a ı'xe. Avşalomne nukaraaşed hapk'ın, maqa ts'a ı'xiyxən. ");
INSERT INTO tkr_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Manke Yoav Avşalomne xaaqa arı, qiyghanan: – Nya'a yiğne nukaraaşe abı, yizde çolus ts'a ı'xı'? ");
INSERT INTO tkr_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Avşalomee Yoavık'le eyhen: – Zasqa ayreva zı yiğne k'anyaqa insan g'axuvu. Eyhelan zak'le, zı inyaqa Geşureençe nişisniy qarı? Zı şaacar axunaxhiy inçile nimeexheyid yugda eyxheyiy. Hasre zak'le paççah g'aces. Zaqa bınah vobxhee, gik'ecen. ");
INSERT INTO tkr_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Yoavee hark'ın, man gırgın paççahılqa hixhar ha'an. Paççaheeyir Avşalom cusqa qoyt'al. Avşalom paççahısqa arı, mang'une ögiyl aq'va ç'iyek qet'asmee k'yoyzarna. Paççahee mang'us ubba ha'a. ");
INSERT INTO tkr_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Sabara gah ılğevç'uyle qiyğa, Avşalomee cus dəv'əyn daşk'a, balkanar, xhots'al (50) cune ögiyl g'adaxhvanasda insan t'abal ha'a. ");
INSERT INTO tkr_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","Mana miç'eer çakra suğotsu, şaharne akkabışisqa əlyhəəne yəqqəniy ulyoyzarna. Mançe cone yı'q'nee gipxhına gaf paççahee məhkama alğehecenva vüqqən insanar ı'lğəəmee, mang'vee manbı cusqa qopt'ul, qiyghan ıxha: – Ğu nene şahareençene? Mane insaneeyid alidghıniy qele ıxha, vuc sa neneme İzrailyne nasıleençena vorna. ");
INSERT INTO tkr_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","Avşalomee mane insanık'le inəxüd eyhe ıxha: – Yiğna iş yugnab, qopkunab vuxheeyib, paççahısnee val k'ırı alixhxhesda insan deşda. ");
INSERT INTO tkr_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Avşalomee meed eyhe ıxha: – İne ölkayna haakim zıcarxhiy hı'ına. Manke zı, vuşuyiy zasqa məhkamee he'eva arı, mang'une işiqa qorkuraniy ilyakkas. ");
INSERT INTO tkr_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Vuşumecar k'yozarasva Avşalomusqa qexhemee, mang'vee xıl hotku, mana insan cusqa ts'ıts'ı'ı, ubba ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Avşalomee məxüd paççahısqa məhkama ha'asva vüqqəne gırgıne İzrailybışikcad ha'a ıxha. Məxüb mang'vee İzrailybı culqa saa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Yoq'ulle sen ılğeç'uyle qiyğa, Avşalomee paççahık'le eyhen: – Hucoona ixhes, hasre zı Xevronqa hark'ın, Rəbbis cuvab huvuyn kar ha'as. ");
INSERT INTO tkr_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Zı, yiğna nukar, Aramne cigabışeene Geşurne şaharee axvamee, k'ınniy g'assır: «Rəbbee zı İyerusalimqa sak'al he'ee, zı Mang'us ı'bəədat ha'as Xevronqa ı'qqəs». ");
INSERT INTO tkr_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","Paççahee mang'uk'le «Yugna yəq vuxhenava» eyhe. Avşalomur Xevronqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","Avşalomee dyugulenba gırgıne İzrailyne nasılbışeeqa cun insanar g'axuvu, maabınbışik'le eyhen: – Gaçeençe qı'ğəəne süttyun ses g'ayxhımee, «Avşalom Xevron paççah ıxhava» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","İyerusalimğançe Avşalomuka sacigee q'öd vəş (200) insan ayk'an. Manbı məttıne yik'eka mang'uqab qihna əlyhəə vuxha. Manbışis nişikecab xabar vuxha deş. ");
INSERT INTO tkr_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Avşalomee q'urbanbı allya'amee, mang'vee Davudna muşaavir Giloonçena Axitofel cune şahareençe, Giloonçe, cusqa qoyt'al. Avşalomne suralqa ı'lğəənbı yiğ-yiğıle geeb qeebaxhe vuxha. Manbışis Davudne yı'q'əle qeepxhes vukkan vuxha. ");
INSERT INTO tkr_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Sa insan Davudusqa arı, mang'uk'le eyhen: – İzrailybışin yik'bı Avşalomulqa vod satk'ıl. ");
INSERT INTO tkr_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","Davudee İyerusalimeene cune gırgıne insanaaşik'le eyhen: – İnçe heepxas! Deşxheene, Avşalomne xılençe yişde neng'ussecar g'attixhanas əxəs deş. Zaraba vuxhe əlyhəəs. Deşxheene, mana şaka avarq'ıl, yişde vuk'lelqa yiğbı exas, şaharıb g'ılıncike alğaahas. ");
INSERT INTO tkr_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Paççahne insanaaşe eyhen: – Şi yiğın nukarar vob, hasre ğu, yişde xərıng'vee, eyhen ixhecen. ");
INSERT INTO tkr_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Paççahıqab qihna mang'un gırgın xaabınbı qığeebaç'enbı. Mang'vee saccu yits'ıyre həmbal zəiyfa xaaqa ilyaakasva g'alyaa'a. ");
INSERT INTO tkr_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","Paççahıqad qihna gırgın milletcad qığeç'u, şahareençe qı'ğəəne xaasqamee qadı, ulyoyzaran. ");
INSERT INTO tkr_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Gırgın mang'un insanar Keretbışika, Peletbışika, yixhıd vəş (600) Gateençe cuqab qihna qabıyne Gatbışika sacigee, cune ögiyle ılğeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","Paççahee Gatğançene İttayk'le eyhen: – Ğu nya'a şaka ı'qqə? Sak'le, ixhesde paççahıka Avşalomuka axve. Ğu menne cigeençe g'e'eşşu qarına vor. ");
INSERT INTO tkr_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","Ğu inyaqa həşdebışee qarı. G'iyna zı ğu zaka əlyhəəsne alikke? Zak'le zı nyaqa əlyəsvacar ats'a deş. Ğumee sak'le, yiğın insanarıb vaka quvke. Hasre Rəbbee Cuna badal dyooxhena yugvalla vak'le haagvecen! ");
INSERT INTO tkr_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","İttayee paççahıs alidghıniy qele: – Vorne Rəbbilqaniy yizde xərıng'une paççahne canılqan k'ın ixhen, ğu, yizda paççah, nyaa'ar ixhee, zınar qik'u ixheeyir, üç'ür ixheeyir, maa'ar ixhes. ");
INSERT INTO tkr_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","Davudee İttayk'le eyhen: – Qora manke ögiylqa ılğeç'e, ögee hoora. Gatğançene İttaykan gırgın mang'un insanar, cone k'anebın gırgın uşaxar qabı, ılğeebaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","Paççahın insanar əlyhəəmee, ölkeebın gırgın insanar okur aletçu gyaaşenbı. Paççahee Qidronna q'adaal ılğevç'umee, mang'ukan gırgın milletcad sahrayne suralqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","Maa'ar Tsadokır ıxhana. Mang'une k'ane Leviyke g'abıynbı vuxhaynbı. Manbışe Allahıka mugaavilenana q'utye quvkekka vuxha. Allahna q'utye manbışe ç'iyelqa giviyxhe. Evyataree gırgın millet şahareençe qığeç'esmee q'urbanbı allya'a. ");
INSERT INTO tkr_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Paççahee Tsadokuk'le eyhen: – Allahna q'utye şahareeqa savk'al hee'e. Zı Rəbbine ulesqa yugra qaree, Mang'vee meer zı yı'q'əlqa sak'al hı'ı, Cuna q'utyeyiy Cuna çadır zak'le hagvasın. ");
INSERT INTO tkr_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","De'eş, «ğu Zas ıkkanna deşurva» uvheene, hasre zak Cus hucooyiy ıkkan he'ecen. Zı Mang'une xıle vorna. ");
INSERT INTO tkr_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Paççahee kaahin Tsadokuk'le eyhen: – İlekke, hucooyiy eyxhe. Ğunayiy yiğna dix Axima'ats, Evyatarne dixeka Yonatanıka sacigee hexxan hidi'ı şahareeqa savk'le. Ğunar, Evyatareeyib q'öyursana vuşun dixbı şoka vukkee. ");
INSERT INTO tkr_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Zı şoke xabar qavaalesmee, İordanne damayle ılğəəne cigee, sahree ixhes. ");
INSERT INTO tkr_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Tsadokeeyiy Evyataree Allahna q'utye İyerusalimeeqa savaak'al haa'a. Cona q'öyursanab İyerusalimee axva. ");
INSERT INTO tkr_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Davud Zeytunne suvalqa geşşe-geşşe ılqeç'e. Mang'vee vuk'lelqa kar atçu eyxhe, g'elilqamee kar ali'ı ıxha deş. Mang'uka sacigee suvalqa ı'lqəənbıb vuk'lelqa kar atçu gyaaşe-gyaaşe ılqeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","Şavaame «Axitofel Avşalomne k'ane vorva, g'elil qeepxhaynbışde suralirva» xabar hoole. Davudee Rəbbis düə haa'a: – Ya Rəbb, zı Vake heqqa, Axitofelin mı'sləhətbı nişiscad karaı'dəənbı he'e. ");
INSERT INTO tkr_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Davud milletın Allahıs ı'bəədat ha'ane suvane q'omaqa hirxhılymee, Arkibışda Xuşay mana g'aces arayle. Mang'vee culqa abına ver haagvasva tanalinbı qıt'axxa'a, vuk'ulelqa nyaq'v kyaa'a. ");
INSERT INTO tkr_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","Davudee mang'uk'le eyhen: – Ğunar zaka sacigee əlyhəəsxhee, ğu zas dağamra ixhes. ");
INSERT INTO tkr_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","İnekke yugun, ğu şahareeqa sak'ı, Avşalomuk'le eyhe: «Paççah, zınar yiğna nukar ixhes. Şenke nəxübiy yiğne dekkıs nukariyvalla hav'u, həşdeb vas haa'as». Məxüd vasse zas kumag ha'as əxə. Vasse Axitofelin mı'sləhətbı alyt'ik'al ha'as əxə. ");
INSERT INTO tkr_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Kaahin Tsadokiy kaahin Evyatar maa'ab vaka vuxhes. Paççahne sarayee g'ayxhiyn gırgın kar, ğu kaahinaaşilqa Tsadokılqayiy Evyatarılqa hixhar ha'as. ");
INSERT INTO tkr_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Manbışda q'öyre dix – Tsadokna dix Axima'ats, Evyatarna dix Yonatan – manbışde k'ane vob. Şok'le g'ayxhiyn gırgın manbışde xıleka zalqa hixhar he'e. ");
INSERT INTO tkr_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Avşalom İyerusalimeeqa ı'kkəəmee, Davudna hambaz Xuşayır şahareeqa ikkeç'e. ");
INSERT INTO tkr_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","Davud suvayle gəə girğılymee, mang'us Mefiboşetna nukar Tsiva qızaxxa. Mang'vee q'öd vəş (200) gıney, vəş t'exa qeqqvuyne t'ımılin, vəş t'exa incilyna, sa tuluğ çaxıren alyaat'u, manbıd q'öne əməlelqa alixhxhı, Davudne ögiylqa arayle. ");
INSERT INTO tkr_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","Paççahee Tsivayk'le eyhen: – İnbı nyaqane ıkkekka? Tsivee eyhen: – Əməler paççahın xaabınbı aleepxecenva, gıneyiy incilerıd yiğne nukaraaşe oxhnecenva, in çaxırıd sahreene obzuruynbışe ulyoğecenva adı. ");
INSERT INTO tkr_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Paççahee Tsivayk'le eyhen: – Yiğne xərıng'una neva, Mefiboşet, nyaane vor? Tsivee paççahık'le eyhen: – Mana «G'iyna İzrailybışe yizde q'əsde dekkına paççahiyvalla zasqa savaak'al haa'asva» uvhu, İyerusalimee axu. ");
INSERT INTO tkr_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","Paççahee Tsivayk'le eyhen: – Manke Mefiboşetın gırgın kar yiğın eyxhe. Tsiva paççahıs k'yorzul, alidghıniy qele: – Saccu zı yiğne ulesqa yugra qoracen. ");
INSERT INTO tkr_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","Paççah Davud Baxurim eyhene şahareeqa qarayle. Mançe mang'usqa Şaulne xınıbışda Gerayna dix Şimey qığeç'e. Şimey Davudus bed-düə haa'a-haa'a qığeç'e. ");
INSERT INTO tkr_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","Davudne hiqiy-alla cehilyaariy cun esker vuxhayka ilydyakkı, mang'vee Davudulqayiy Davudne insanaaşilqa g'ayebı ayhe. ");
INSERT INTO tkr_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Şimeyee Davudulqa inəxübna bed-düə haa'a: – Agvle, agvle, insanar gyabat'ana, karaı'dəəna insan! ");
INSERT INTO tkr_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Ğu Şaulne cigee paççah ıxha. Rəbbeeyid vak in Şaulne nasılıke k'yapk'ınne ebal-alla hı'ı. Həşde Rəbbee paççahiyvalla yiğne dixesqa Avşalomusqa quvu. Valqa mana ver ğu insanar gyabat'anava abı. ");
INSERT INTO tkr_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Tseruya donane zəiyfayne dixee Avişayee paççahık'le eyhen: – Nya'a mane xvaan yizde xərıng'us, paççahıs, məxbına bed-düə hav'u? Hasre zı hark'ın mang'una vuk'ul qooxas. ");
INSERT INTO tkr_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","Paççahee eyhen: – Tseruyayn dixbı, zake şos hucoone? Mang'vee, Rəbbee «Davudus bed-düə hee'eva» uvhu, bed-düə haa'axhee, şavusse mang'uk'le «məxüd hıma'ava» eyhes əxəyee? ");
INSERT INTO tkr_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Davudee Avişayk'leyiy gırgıne cune insanaaşik'le eyhen: – Zake g'ariyne yizde dixes zı gik'as ıkkan. Mane Benyaminyaaşikeng'uk'le hucoo eyhes eyxheyee! Mana culer-alqa g'alerçe, hasre heecen bed-düə. Mang'uk'le məxüd Rəbbee uvhu. ");
INSERT INTO tkr_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Həməxüd eyxhe, Rəbbik'le zak ıxhayn g'acu, şeng'vee g'iyna zas hav'uyne bed-düə-alla, zas yugun ha'a. ");
INSERT INTO tkr_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Davudıy cun insanar cone yəqqı'n əlyhəə vuxha. Şimeyeeme suvayne sirtıle bed-düə haa'a-haa'a ayk'an. Mang'vee manbışilqa g'aye, tooz dağa'a. ");
INSERT INTO tkr_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Paççahiy cukan gırgın insanar İordanne damaysqa hipxhır, obzurva maa'ad manzilybı ha'a. ");
INSERT INTO tkr_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Avşalomiy gırgına İzrailybışda g'oşun İyerusalimeeqa qabayle. Axitofelir mang'uka sacigee ıxha. ");
INSERT INTO tkr_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Davudna hambaz, Arkibışda Xuşay, Avşalomusqa arı «Paççah geer qa'ana! Paççah geer qa'anava!» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Avşalomee Xuşayk'le eyhen: – Manane yiğne hambazılqana, Davudulqana, yiğna badal dyooxhena yugvalla? Nya'a hambazıka sacigee idyark'ın? ");
INSERT INTO tkr_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Xuşayee Avşalomuk'le eyhen: – De'eş, zı saccu Rəbbee, ine milletın, gırgıne İzrailincar, g'əyxı'yne insanın sura aqqas. Zı mang'uka axvas. ");
INSERT INTO tkr_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Ğu zak'le eyhelan zı şavusne nukariyvalla haa'as? Hambazne dixes dişde? Yiğne dekkis nəxbına nukaruyvallayiy hav'u, vasıb həməxübna nukariyvalla haa'as. ");
INSERT INTO tkr_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Avşalomee Axitofelik'le eyhen: – Şi hucooyiy ha'as ıkkanva mı'sləhət g'avcelan! ");
INSERT INTO tkr_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Axitofelee Avşalomuk'le eyhen: – Yiğne dekkee xaaqa ilyaakasva g'alyav'uyne cune həmbal zəiyfabışika g'alixhe. Manke gırgıne İzrailik'lecad ğu dekkıs g'ımece qıxhava ats'axhxhesın. Yiğne suralyne gırgınbışeed yiğın sura sık'ıldad geed aqqas. ");
INSERT INTO tkr_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Avşalomee dekkıne sarayne oğa çadır güvxü, maa'ar gırgıne İzrailyne ulene ögiyl dekkıne həmbal zəiyfabışika g'ılexha. ");
INSERT INTO tkr_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Mane gahbışil Axitofelee g'avcuna mı'sləhət, Allahıken cuvab xhinne ıxha. Axitofelee g'avcuna mı'sləhət Davudnemeeyib Avşalomnemeeyib həməxüb vuxha. ");
INSERT INTO tkr_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Axitofelee Avşalomuk'le eyhen: – Hasre zı yits'ıq'vəd aazır (12 000) insan g'əyxı', xəmde Davuduqa qihna gixhas. ");
INSERT INTO tkr_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Mana orzul, rı'hı'le g'a'arxhung'a, şi manbışilqa k'yophur mang'una ul qəvəəq'ənaa'as. Manke mang'une k'anebın gırgınbı heepxasınbı. Zınar manke saccu paççah Davud gik'as. ");
INSERT INTO tkr_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","Qiyğale gırgın millet zı vasqa sak'al ha'as, istağ tsumaysqa seek'al hee'en xhinne. Gırgınbı valqa savk'lecenva, ğu mana t'abal ha'ana insan gidek'u g'alerçes ıkkan deş. Manke milletıkıd vuççud ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Man cuvab Avşalomusud gırgıne İzrailyne ağsaqqalaaşisıd yugda qadayle. ");
INSERT INTO tkr_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Avşalomee eyhen: – Qudoora, həşde Arkibışda Xuşayır qot'alas, sa mang'vee eyhenıçilid k'ırı alixhxhes. ");
INSERT INTO tkr_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Xuşay Avşalomusqa arımee, Avşalomee mang'uk'le eyhen: – Axitofelee şas inəxübna mı'sləhət g'avcu. Şi mang'vee eyhəxüd ha'asee? De'eş, hidya'asxhee, ğu hucoo he'evane eyhe? ");
INSERT INTO tkr_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Xuşayee eyhen: – Axitofelee həşde huvuna mı'sləhət yugna deşub. ");
INSERT INTO tkr_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Vak'lecad ats'an, yiğna dekkiy mang'ukan insanar igider vob. Manbı həşde balabı g'ayşu axuyn syobı xhinne vob. Yiğna dek ək'elika siç'ekkvana insan vor, mana mısacar g'oşunne yı'q'nee g'alixhas deş. ");
INSERT INTO tkr_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Mana həşde mağarabışde sançeeye, deşxhee, menne cigeeye dyugulyxha vor. Mang'una g'oşun yiğne eskeraaşilqa ts'eppa k'yophur, ğamuvxhee, man g'ayxhiynbışe eyhesın: «Avşalomuqa qihna apk'ıniynbı avub avxu». ");
INSERT INTO tkr_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Manke aslanaaşin xhinnen yik'bınan igiderıb qəvəəq'ənasınbı. Gırgıne İzrailybışik'lecad ats'an, yiğna dek nəxruna g'oçax ıxhay, cukanbıb nəxbın igider vuxhay. ");
INSERT INTO tkr_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Zı vas inəxübna mı'sləhət g'ooce: Danile Beer-Şevalqamee gırgın İzrailybı deryahne mıglena g'um xhinne vasqa savaalecen. Ğunab yiğne xılen manbı dəv'eeqa vukkee. ");
INSERT INTO tkr_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Mana axvane cigabışde sançee şi mang'ulqa xəənçe ç'iyelqa g'e'exhxhan şeh xhinne k'yooharas. Manar, cukane insanaaşina sacarır üç'ürra g'ılydyaraççe. ");
INSERT INTO tkr_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Mana menne şahareeqa ark'ın ixheene, gırgıne İzrailybışe mane şaharısqa t'ü'ər adı, mana şahar habğı, dameeqa g'a'apçes. Mane şaharıke sa k'ınna g'ayeb g'alepçes deş. ");
INSERT INTO tkr_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Avşalomeeyiy cukane gırgıne İzrailybışe eyhen: – Arkibışda Xuşayna mı'sləhət, Axitofelyne mı'sləhətıle yugba vob. Məxüd Rəbbee Avşalomne vuk'lelqa ver ablyaa'asdemee, Axitofelyna yugna mı'sləhət havaakal haa'a. ");
INSERT INTO tkr_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Xuşayee kaahinaaşik'le Tsadokık'leyiy Evyatarık'le eyhen: – Axitofelee Avşalomusiy İzrailyne ağsaqqalaaşis inəxübna mı'sləhət g'avcu. Zımee manbışik'le inva uvhu. ");
INSERT INTO tkr_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","Həşde şu ina xabar ana Davudusqa zaara insan g'axıle. Şu mang'uk'le eyhe: «G'iyna xəm İordanne damayne ine aqval sahree hımaa'a. Damayne şene aq'valqa ılğeepç'e. Deşxheene, paççahır cukan gırgın insanarıb hapt'asınbı». ");
INSERT INTO tkr_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","Yonataniy Axima'ats En-Rogelee aaxva vuxha. Sa nukar içee manbışis xabar abayle vuxha, manbışeb mana xabar paççah Davudus hivxhar haa'a vuxha. Manbı şaharee neng'uk'lecab g'avces vukkan deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Sa gadeyk'le manbı g'ooce, mang'veeyid man hark'ın Avşalomulqa hixhar ha'a. Mançil-allab manbı mançe zaraba qığeepç'ı Baxurimee eyxhene sa adamiyne xaaqa qavayle. Mane adamiyne məhlee kahrız vooxhe. Manbı maqa k'eebaç'e. ");
INSERT INTO tkr_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Mang'une xhunaşşee örtyug alyaat'u kahrızılqa aççu, çilqab xhıt'a gyooka, şavuk'lecad vuççud g'ımececenva. ");
INSERT INTO tkr_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Avşalomun insanar mane xaaqa abı, zəiyfayke qiyghanan: – Axima'atsiy Yonatan nyaane vob? Zəiyfee manbışik'le eyhen: – Damayke ılğeepç'ı. Mane insanaaşe manbı t'abal haa'a. Vuşucar ivdeykımee, sapk'ıl İyerusalimqa avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Avşalomun insanar apk'ıniyle qiyğa, Yonataniy Axima'ats kahrızeençe qığeepç'ı, paççah Davudus xabar hevlesva avayk'an. Manbışe mang'uk'le eyhen: – Oza qeepxhe, damayke zaraba ılğeepç'e. Manke manbışe Axitofelee uvhiynçina gaf ha'a. ");
INSERT INTO tkr_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","Davudıy cun insanar İordanne damayle ılğeebaç'enbı. Miç'eerilqasse damayle ılğıdeç'una sa insan axva deş. ");
INSERT INTO tkr_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Axitofelik'le iş cune mı'sləhətıka hidyav'u g'avcumee, mang'vee cune əməleys palan ı'xı' cune şahareeqa, xaaqa siyk'al. Mang'vee cune karak hucooyiy ha'as ıkkanvad uvhu, ark'ın vuceecar vuc givayxanna. Mana, cuna dek k'eyxiyne mağaree k'eyxha. ");
INSERT INTO tkr_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Davud Maxanayimeeqa qarayle. Avşalomur cune k'anene gırgıne İzrailybışika İordanne damayle ılğeç'e. ");
INSERT INTO tkr_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","Avşalomee, Amasa Yoavne cigeeqa g'oşunbışda xərna giyxhe. Amasa, Yitra donane İzrailyğançeng'una dix ıxha. Mang'una yed Naxaşna yiş Avigailiy yixha. Yoavna yed Tseruya Avigailiynar yiçu yeexhe. ");
INSERT INTO tkr_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Avşalomee İzrailybışika Gilead eyhene cigee çadırbı giyxə. ");
INSERT INTO tkr_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","Davud Maxanayimeeqa arayle. Maqa mang'usqa Ammonne Rabba eyhene şahareençene Naxaşna dix Şovi, Lo-Devareençe Ammielyne dix Makir, Rogelim eyhene şahareençe Gileadğançena Barzilay abayle. ");
INSERT INTO tkr_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","Manbışe Davudusiy cune g'oşunus doşagbı, k'olabı, nyuq'vneke hı'iyn g'abbı, ooxhanas suk, xhıt'a, urva, qoots'una suk, hüvə, ");
INSERT INTO tkr_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","itv, şor, zerane nikneke hı'iyn nisse, vəq'əbı adayle. Manbışisqa məxüd qayle, g'oşun çolee mıssıbaniyxan, obzur, xhyan denamee avxu. ");
INSERT INTO tkr_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","Davud cune hıqiy-allane g'oşunuqa ilyakka. Mang'vee g'oşun aazırna, vəşna bit'al hav'u, manbışilqa ç'ak'ınbı giviyxhe. ");
INSERT INTO tkr_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","Davudee g'oşun xhebne cigeeqa bit'al haa'a. Ts'eppiyne destel ooqa Yoav, q'öd'esde destel ooqa Yoavna çoc, Tseruyayna dix Avişay, xhebıd'esde destel ooqar Gatğançena İttay xərna giyxhe. Paççahee g'oşunuk'le eyhen: – Zı şoka dəv'eeqa hidyark'ın gyuaras deş. ");
INSERT INTO tkr_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","Eskeraaşe mang'uk'le eyhen: – Hımayk'an, şi heepxas gyapk'eene, manbı şaqa sapk'ıl ilyaakas deş. Yişinbışin surabı hapt'eeyib, manbı şaqa meeb sapk'ıl ilyaakas deş. Ğu yişde yits'ne aazırıng'ule ooqana vor. Mançilesa, ğu şas şahareençe kumag he'e. ");
INSERT INTO tkr_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","Paççahee manbışik'le eyhen: – Şosqa nəxüdiy yugda qöö, zı həməxüdud ha'asın. Gırgına g'oşun vəşna, aazırna şahareençe qığevç'esmee, paççah şaharne akkabışisne ulyoyzar. ");
INSERT INTO tkr_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","Paççahee Yoavılqa, Avişayalqa, İttayalqa əmr haa'a: – Hucoona ixhes, yizdemee şene gadeyka, Avşalomuka, g'üvənaba vuxhe! Paççahee g'oşunbışde vuk'lel ulyobzuriynbışis Avşalomne hək'ee huvuna q'arar gırgıne eskeraaşik'le g'avxhuna. ");
INSERT INTO tkr_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","Davudna g'oşun, İzrailybışka dəv'ə haa'asva qığooç'e. Dəv'ə Efrayimne ç'alagee vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","Maa'ab İzrailyna g'oşun Davudne insanaaşile avub aaxva. Mane yiğıl maa'ab geeb eb k'yapk'ın, g'ad aazır (20 000) insan qik'u. ");
INSERT INTO tkr_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","Maana dəv'ə hiqiy-allane gırgıne cigabışeeqab hiviyxharna. Mane yiğıl ç'alagın g'ılıncıle geeb insanar gyabat'a. ");
INSERT INTO tkr_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Avşalom Davudne insanaaşisqa qızaxxa. Mana cune g'atiril alixı, xənne mı'qəne yivek avğançe ı'lğəəmee, mang'una vuk'ul yivene geed bıtağbınane cigayk açayxar. Məxür mana xəə'ər givarxın axva, vuc alixına g'atirme qığevç'u avayk'anna. ");
INSERT INTO tkr_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","Eskeraaşine sang'uk'le man g'acu, Yoavıs yuşan ha'a: – Zak'le həşde Avşalom mı'qəne yivele qı'xı' g'acu. ");
INSERT INTO tkr_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Yoavee cus man yuşan hı'iyne insanık'le eyhen: – Hucoo? Vak'le manayee g'acu? Nya'a ğu mana mankecar ı'xı' gidek'u? Zı vas mançil-alla yits'ılle şekel nuk'rayniy sayib ts'iraniy hevles. ");
INSERT INTO tkr_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Mane insanee Yoavık'le eyhen: – Yizde xılyaqa aazır şekelib huvunaxhiy, zı paççahne dixelqa xıl g'udyoyt'alıy. Vak'le, Avişayk'le, İttayk'le, «Yizdemee mana gade Avşalom havaceva» paççahee əmr haa'a zak'le g'ayxhiyn. ");
INSERT INTO tkr_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","Zı paççahne cuvabıke qığeç'u, Avşalom gik'unaxhiy, vuççud nəxüdcad paççahıke dyugul ha'as eyxhe deş. Ğunad yizın sura aqqas deşdiy. ");
INSERT INTO tkr_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Yoavee mang'uk'le eyhen: – Zaqa, vaka avaak'an haa'asda gah deşda. Avşalom mı'qəne yivele qı'xı'carniy vor, mana qik'u deşiy. Yoavee xılyaqa xhebılle mizrag alyat'u, mang'une yik'eeqa hiyxə. ");
INSERT INTO tkr_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","Yoavın silah haqqana yits'iyre gade Avşalomusqa yoq'ne surale qeepxha, mana ı'xı' gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Qiyğa, g'oşunun İzrailybışiqa qihna gyapk'iy ç'əv he'ecenva, Yoavee şeypur ı'lyviyxə. ");
INSERT INTO tkr_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","Avşalomur yivele g'ayşu, ç'alageene sa xənne g'uyeeqa dağaraççe. Ooqab g'ayebışda anbar saa'a. Manke gırgın İzrailybı cone xaybışeeqa heebaxa. ");
INSERT INTO tkr_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","Avşalomee üç'ürnang'a sa xəbna g'aye alyapt'ı, mana Paççahaaşine Q'adaalil cus aabida xhinne ulyoozar haa'a. Mang'vee mane g'ayel «Zas yizın do havacesda dix ıxha deşva» uvhu, mane g'ayeys cun do hele. G'iyniyne yiğılid mançik'le Avşalomna haykalva eyhe. ");
INSERT INTO tkr_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","Tsadokne dixee, Axima'atsee eyhen: – Hasre zı g'adayxhvan paççahısqa hark'ın, Rəbbee vuc duşmanaaşine xılençe g'attixhan hı'ıva xabar hevles. ");
INSERT INTO tkr_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","Yoavee mang'uk'le eyhen: – Ğu mana gaf g'iyna deş, sa menne yiğıl sa mebna yugna gaf paççahıs hee'e. G'iyna mang'una dix qik'u. ");
INSERT INTO tkr_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","Yoavee Kuş eyhene cigeençene adamiyk'le eyhen: – Hoora, paççahısqa hak'ne, g'iyna g'acuynbı mang'us yuşan he'e. Mana insanır Yoavıs kyorzul, mançe g'adayxhvan ayk'anna. ");
INSERT INTO tkr_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","Tsadokne dixee Axima'atsee meed Yoavık'le eyhen: – Hucooyiy eyxhe ixhecen, hasre zınar şene adamiyqa qihna g'adaxhvanas. Yoavee eyhen: – Nya'a, dix, vasır şeng'uqar qihna g'adaxhvanas ıkkan? Ğu mana gaf hav'uva vas mukaafat heles deş. ");
INSERT INTO tkr_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","Mang'vee eyhen: – Hasre hucooyiy eyxhe ixhecen, zı g'adaxhvanasda. Yoavee mang'uk'le «G'adaxhvneva» eyhe. Axima'ats Q'adaaline yəqqı'n g'adarxhun, Kuş eyhene cigeençene adamiyle ögee qexhe. ");
INSERT INTO tkr_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","Mane gahıl Davud anneyiy g'anne akkabışde yı'q'nee gyu'ur eyxhe. G'aravulyçiy şaharne akkayne oone cabırılqa ılqeç'umee, mang'uk'le sa insan g'adayxhvan qöö g'ece. ");
INSERT INTO tkr_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","Mang'vee paççahılqa onu'u, cuk'le g'acuyn paççahıs yuşan ha'a. Paççahee eyhen: – İnsan saxhee mang'vee, xabar vukkekka vuxhes. Mana insan hiyxhar ıxha. ");
INSERT INTO tkr_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","G'aravulyçiyk'le g'adayxhvan qööna sa merna insanır g'ece. Mang'vee akkee ulyorzuling'ulqa onu'u, eyhen: – Meer sa merna insanır g'adayxhvan qöö. Paççahee eyhen: – Manar xabar vukkekana vor. ");
INSERT INTO tkr_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","G'aravulyçee eyhen: – Ts'erriyng'un g'adarxhuniy Tsadokne dixene Axima'atsne g'adarxhuniyıkıd akar. Paççahee eyhen: – Mana yugna insan vor, mana yugne xabarıka ı'qqə. ");
INSERT INTO tkr_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","Axima'atsee paççahık'le it'umda eyhen: – Gırgın yugda vod! Qiyğa mana paççahne ögiyl ç'iyelqamee k'yorzul eyhen: – Yuğne Allahıs, Rəbbis şukur vuxhena! Rəbbee valqa, yizde paççahılqa, xıl g'ott'uluynbı yuğnecab xılyaqa quvuynbı. ");
INSERT INTO tkr_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","Paççahee eyhen: – Yizda dix Avşalom yugrane vor? Axima'atsee eyhen: – Yoavee zınay sa merna paççahna nukar g'uxoolemee, zak'le maa'ad alikkı-gikkiy gitxhu g'acu. Zak'le maa hucoome ıxhay, nenme ıxhay ats'a deş. ");
INSERT INTO tkr_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","Paççahee eyhen: – Sa suralqana qıxha, maa'ar ulyozre. Manar sa suralqana qıxha ulyoyzarna. ");
INSERT INTO tkr_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Kuş eyhene cigeençena qarı eyhen: – Yizde xərıng'us, paççahıs zaqa yugna xabar vobna! Rəbbee g'iyna valqa g'elil qeepxhaynbışde xılençe ğu g'attixhan hı'ına. ");
INSERT INTO tkr_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","Paççahee mang'uk'le eyhen: – Yizda dix Avşalom yugrane vor? Kuş eyhene cigeençeng'vee eyhen: – Hasre yizde xərıng'une paççahne duşmanaaşikiy, mang'ulqa g'elil qeepxhayne gırgıng'uk Avşalomuk ıxhayn ixhecen. ");
INSERT INTO tkr_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","Paççah sacuraycar qa'a. Mana şaharne akkabışde oone gozeeqa ılqeç'u, geşşena. Mang'vee ooqa ılqə-ılqə eyhe ıxha: – Yizda dix, yizda dix Avşalom! Dix, yiğne cigee zıcarxhiy qik'una! Yizda dix Avşalom! ");
INSERT INTO tkr_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","Yoavılqa «Paççah Avşalomuqa vor geşşe, mang'vee ak'ıb avquva» hixhar ha'a. ");
INSERT INTO tkr_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","Mane yiğıliyn duşmanaaşile ğamepxhay ak'ılqa siyk'al. Eskeraaşik'le paççahın yik' dixeqa gyotxhanva g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","G'oşun mane yiğıl şahareeqa, dəv'eençe hixu qööna, naş qexhe dyugulenra şahareeqa ı'kkəəna xhinne ikkyooç'e. ");
INSERT INTO tkr_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","Paççahee aq'valqa kar atçu, it'umba ts'ir haa'a: – Yizda dix Avşalom, ay Avşalom! Dix yizda, ay dix! ");
INSERT INTO tkr_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","Yoav paççahne xaaqa ikkeç'u, eyhen: – G'iyna yiğın can, dixbışin, yişbışin, yiğne yadaaşin, həmbal zəiyfabışin canbı g'attixhan hı'iyn yiğın insanar ğu k'ap'ik'ıle avqa qav'u. ");
INSERT INTO tkr_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","Vas ğu g'ımecenanbı vukkan, ğu ıkkananbı vukkan deş. G'iyna ğu yişde gırgıng'uk'le haguyn, g'oşunbışin ç'ak'ınbıyiy manbışin insanar yiğnemee vuççud deşin kar vodun. G'iyna zalqa hitxhır, Avşalom axu yişin gırgınbı g'iyna hapt'ıynbıxhiy, man yiğnemee yugdaniy ixhes. ");
INSERT INTO tkr_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","Həşde milletısqa qığeç'e, manbışis yik'bı hele. Rəbbilqan k'ın ixhen, ğu g'iyna milletısqa qığdeç'vee, vaka exhalilqasse sacar insan axvas deş. Manıd mek'valile g'iyniyne yiğılqamee yiğne vuk'lelqa qadıyn nekke pisın kar ixhes. ");
INSERT INTO tkr_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","Paççah oza qıxha, şaharne akkabışisda giy'ar. G'oşunuk'led «Paççah şaharne akkabışisne gyu'urva» uvhumee, g'oşun paççahısqa savayle. Gırgın İzrailybıme cone xaybışeeqa apk'ın vooxhe. ");
INSERT INTO tkr_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","İzrailyne gırgıne nasılbışe sana-sang'uka xıliyn ha'a, eyhe ıxha: – Paççahee şi yişde duşmanaaşine xılençe g'attivxhan hav'u! Filiştinaaşde xılençeb mang'vee şi g'attivxhan hav'u. Həşder Avşalomul-alla mana vuccar ölkeençe hixu. ");
INSERT INTO tkr_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","Şas xəbvalla hee'ecenva şi g'əyxı'na Avşalomur dəv'ee qik'una. Həşde paççah Davud yı'q'əlqa sak'al hı'iynemee, şu nya'a vuççud itteyhe? ");
INSERT INTO tkr_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","Paççah Davudee kaahin Tsadokusqayiy kaahin Evyatarısqa in cuvab hixhar ha'as insan g'ıxele: – Yahudayne ağsaqqalaaşik'le inəxüd eyhe: «Paççah yı'q'əlqa sak'al ha'amee, şu nya'a nekke qiyğiynbı vooxhe? İzrailycad yuşan ha'an karbı paççahılqa, mang'une xaalqa hiyxhar. ");
INSERT INTO tkr_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","Yizın çocar, şi sa ebanbı vob. Nya'a paççah sak'al ha'ang'a şu nekke qiyğiynbı vooxhe?» ");
INSERT INTO tkr_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","Amasayk'led eyhe: «Nya'a şi sa ebanbı dişde vob? Yizde k'ane gırgıne gahbışis Yoavne cigeena g'oşunbışda xərna ğu dexheene, hasre Allahee zalqa mançileb pisda ver ablee'ecen». ");
INSERT INTO tkr_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","Mang'vee məxüd gırgıne Yahudeeşin yik'bı sang'un yik' xhinne culqa sak'al ha'a. Manbışe paççahısqa insan g'axuvu, eyhen: – Paççah, ğunar, yiğın gırgın insanarıb savk'le. ");
INSERT INTO tkr_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","Paççah sak'ı, İordanne damaysqa hiyxhar. Yahuder paççahne ögeeqa, mana damayke alğahasva Gilgal eyhene cigeeqa abayle. ");
INSERT INTO tkr_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","Baxurimğançene Benyaminne nasıleençene Gerayna dix Şimeyir Yahudeeşika sacigee zaara paççah Davudne ögeeqava geç'e. ");
INSERT INTO tkr_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","Mang'uka Benyaminaaşina aazır insan arayle. Qiyğa Şaulne xaana nukar Tsiva, yits'uxhvayre (15) mang'una dix, g'ayrer (20) nukar arayle. Manbı zaraba-zaraba İordanne suralqa paççahısqava avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","Coyub paççahısqa yugba qudoorabacenva mang'una xizan damayle alğaahas, damayne şena aq'valqa ılğeebaç'e. Gerayna dix Şimey, paççah İordanne damayle ılğeç'umee, Davudne ögiyl ç'iyelqa gizyaraççe. ");
INSERT INTO tkr_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","Mang'vee paççahık'le eyhen: – Hasre yizde xərıng'uk'le zal bınah g'umoocecen. Ğu, yizda paççah, İyerusalimğançe qığeç'uyne yiğıl zı, yiğne nukaree, hav'una bınah yik'el qavaale hımaa'a. ");
INSERT INTO tkr_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","Zak'le hav'una bınah vaats'ana. Mançil-allar zı g'iyna paççahne ögiylqa gırgıne İzrailybışile ögee arı. ");
INSERT INTO tkr_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","Tseruyayne dixee Avişayee eyhen: – Şimeyee Rəbbee g'əyxı'ng'uk'le eyhesınbı-ittehesınbı axu deş. Mançil-allar mana gik'as ıkkan. ");
INSERT INTO tkr_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","Davudee eyhen: – Tseruyayn dixbı, zake şos hucoone? Nya'a zas duşmanna g'ats'apk'ın? Zak'le zı İzrailyna paççah ıxhay yugda ats'a vod, mançil-allar g'iyna İzrailee vuşucar gik'as deş. ");
INSERT INTO tkr_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","Paççahee qiyğa Şimeyk'le eyhen: – Ğu gik'as deş. Paççahee mang'us k'ın g'iysar. ");
INSERT INTO tkr_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","Şaulna neva Mefiboşet paççahne ögiylqa arayle. Paççah ark'ınne yiğıle, xaaqa sağra-salamatra sak'alasde yiğılqamee, mang'vee g'elybıyiy tanalinbı hodğul deş, muç'ru gyapxhı deş. ");
INSERT INTO tkr_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","Mana paççahne ögiylqa İyerusalimeeqa arımee, paççahee mang'uke qiyghanan: – Nya'asdiy, Mefiboşet, ğu zaka qidyarı? ");
INSERT INTO tkr_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","Mefiboşetee eyhen: – Yizda xərna paççah! Zı, yiğna nukar, k'aarava, zas əməleys palanbı ı'xı', vaka sacigee əlyhəəsniy ıkkan. Yizde nukaree, Tsiveeme, zas horbı hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","Man k'ıldanan xhinne, mang'vee paççahne ögiyl zalqa zı hidi'iyncad karbı qı'ı. Yizda xərna paççah, ğu Allahna malaaik xhinnena insan vor. Həşde vas hucooyiy ıkkan manıd he'e. ");
INSERT INTO tkr_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","Yizde q'əsde dekkıne nasılen gırgınbı ğu gyapt'askanniy. Ğumee zı, yiğna nukar, yiğne sufranıl gi'ı. Zaqa medın cuvab eyhesın ghal deşin. ");
INSERT INTO tkr_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","Paççahee mang'uk'le eyhen: – Nya'a xıliy qa'a? Zı vak'leyiy Tsivayk'le çolbı q'öna qe'eva eyhe. ");
INSERT INTO tkr_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","Mefiboşetee paççahık'le eyhen: – Yizda paççah xaaqa salamatra sak'iyle qiyğa, hasre gırgın vuceecad aleet'ecen. ");
INSERT INTO tkr_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","Gileadğançena Barzilayır Rogelimğançe arı ıxha. Paççah İordanne damayke alğahasva, manar paççahıqa İordanne damaysqamee qaraylena. ");
INSERT INTO tkr_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","Barzilay geer q'əsda, molyts'alyne (80) seneeqa hirxhılyna sa adamiy ıxha. Mana geed karnana insan ıxha. Paççah Maxanayim eyhene cigee axvamee, paççahısın gırgın kar Barzilayee adayle ıxha. ");
INSERT INTO tkr_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","Paççahee Barzilayk'le eyhen: – Zaka sacigee damayke ılğeç'e, vasın gırgın kar zı İyerusalimee helesın. ");
INSERT INTO tkr_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","Barzilayee paççahık'le eyhen: – Zaqa nimeena ı'mı'rne avxu zı vaka İyerusalimeeqa ı'qqəs? ");
INSERT INTO tkr_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","Həşde zaqa molyts'al sen vod. Zı nişincar şada'a deş. Zasqa ulyoğançıniy otxhaxhançin evad qöönne? Zak'le mə'niy qədəqqəne adameeşiniy zəiyfabışin sesıd g'ayxhes əxəyee? Manke zı nişisne hexxara yizde xərıng'us paççahıs yuk ixhes? ");
INSERT INTO tkr_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","Zas paççahıka İordanne damayle ılğeç'u sık'ınna yəq əlyhəəs vukkan. Nişisınne zas məxdın mukaafat? ");
INSERT INTO tkr_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","Hasre zı sak'ı, yizde şaharee dekkıneyiy yedine k'ane qik'as. Yiğna nukar, yizda dix Kimham hasre vaka damayle ılğeç'ecen. Yiğne yik'eençe nena yugvallayiy qöö mang'us manab hee'e. ");
INSERT INTO tkr_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","Paççahee eyhen: – Kimham zaka sacigee damayne şene aq'valqa ılğeç'es, yiğne yik'esqa yugda qöön zı ha'asın. Vas zake hucooyiy ıkkan, vas ıkkanan gırgın zı ha'asın. ");
INSERT INTO tkr_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","Gırgın millet İordanne damayle ılğeç'uyle qiyğa, paççahır damayle ılğeç'ena. Qiyğa paççahee Barzilayıs ubba hı'ı, mang'us xayir-düə hoole. Manar cune xaaqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","Paççah Gilgaleeqa ayk'an. Cuka sacigeeyir Kimham hayk'an. Yahudeeşina goşunna gırgına, İzrailybışdeme goşunna sura paççahıka avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","Gırgın İzrailybı paççahısqa abı, eyhen: – Nya'a yişde çocaaşe Yahudeeşe ğu qöqü? Nya'a manbışe ğu, yiğna xizan, yiğne k'anebın insanar İordanne damayle alğav'u? ");
INSERT INTO tkr_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","Gırgıne Yahudeeşe alidghıniy qele: – Paççah yişda xını eyxhe. Nya'a, mançike şos qəl vooxhe? Nya'a, şi paççahne sufranıle otxhuniy otxhuninne? Deşxhee, şi paççahıke hucoomecadee alyaat'u? ");
INSERT INTO tkr_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","İzrailybışe Yahudeeşis alidghıniy quvu, eyhen: – Paççah şas şole yits'ne yəqqees geer k'ane eyxhe. Davud şole şas geer eyxhe. Nya'a şu şaqa ooğançe avqa ilyaaka? Paççah yı'q'əlqa sak'al ha'asva, nya'a şi dişdiy ts'etta uvhu? Yahudeeşin cuvab İzrailybışde cuvabıle qetan eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","Mane yiğbışil Benyaminaaşina Bikriyna dix Şeva donana sa karaı'dəəna insan Gilgalee eyxhe. Mang'vee şeypur əlixı', eyhen: – Şaka Davuduka, Yesseyne dixeka, sacigeedın kar deşin! Yişda mang'uka avqas deş! İzrailybı, gırgınbı xaybışeeqa savk'le! ");
INSERT INTO tkr_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","Gırgıne İzrailybışe Davud g'alerçu, Bikriyne dixeqa Şevayqa qihna avayk'an. Yahudermee cone paççahıke Davuduke cureebaxhe deş. Manbı İordanne damaysse İyerusalimqamee Davuduqa qihna avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","Davud cune İyerusalimeene sareeqa siyk'al. Mang'vee sarayqa ilyaakasva g'alyav'uyn həmbal zəiyfabı sa xaaqa akkyaa'a. Qiyğa mane xaane hiqiy-alla g'aravulyçer giviyxhe. Mang'vee manbışis gırgıncad helen. Mana saccu manbışika g'ılexha deş. Manbı sip'ırer xhinne vuxha. Manbı hapt'asmee mane xaançe qığeebaç'e deş. ");
INSERT INTO tkr_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","Paççahee Amasayk'le eyhen: – Xhebne yiğee Yahuder zasqa see'e, ğunar cone k'ane ixhe. ");
INSERT INTO tkr_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","Amasa, Yahuder sacigeeqa qoot'alasva ark'ıneeyir, cus gyuvxhuyne gahıl yı'q'əlqa siyk'al deş. ");
INSERT INTO tkr_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","Davudee Avişayk'le eyhen: – Həşde Bikriyne dixee, Şevayee, şas dekkanan Avşalomuled geed ha'as. Yizın insanarıb alyapt'ı, ğu mang'uqar qihna hoora. Deşxheene, sayıb mang'vee hiqiy-allançe cabırbışika it'um hı'iyn şaharbı t'abal hı'ı, yişde uleke aygval. ");
INSERT INTO tkr_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","Yoavın insanar, Keretbı, Peletbı, gırgın yugun cehiler Bikriyna dix Şeva t'abal ha'asva İyerusalimeençe mang'uqa qihna gyabak'a. Manbışil ooyur Avişay ıxha. ");
INSERT INTO tkr_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","Manbı Giveoneene xənne g'ayeyne k'anenang'a Amasa manbışde ögiylqa arayle. Yoavıl dəv'əyn tanalinbı ıxha, yıq'eeqab ts'ira qav'u vuxha. Mane ts'iraylid g'ılınc givatxın ıxha. Mana ögilqava əlyhəəme, g'ılınc givatxınne cigeençe qakkitxhu, g'e'exhxhan. ");
INSERT INTO tkr_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","Yoavee Amasayk'le eyhen: – Yizda çoc, ğu yugrane vor? Qiyğa Yoavee Amaseys ubba ha'asva, mana sağne xıleka muç'ruyke aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","Amasee, Yoavne solne xılene g'ılıncılqa fıkır hoole deş. Yoavee xılen g'ılınc Amasayne vuxhnyaqa hı'xı' mang'un iç'alatbı ç'iyelqa ehekka'a. Q'öd'es g'ılınc hı'xəsda iş aaxva deş, mana mankecar qek'ana. Yoaviy cuna çoc Avişayıb Bikriyne dixeqa, Şevayqa, qihna avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","Yoavne insanaaşine sang'vee Amasayne k'ane ulyorzul, eyhen: – Şavusiy Yoav ıkkan, vuşuyiy Davudne sural Yoavıqa qihna qoracen. ");
INSERT INTO tkr_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","Amasa yəqqı'ne yı'q'nee eban alyart'u ıxha. Mane insanık'le g'ecen, Amasayne mayitısqa qarına-qarına maa'ar ulyoyzarır. Millet mang'usne ulyoyzar g'ecemee, mang'vee Amasayn mayit yəqqı'ne yı'q'neençe alyaat'u, çoleeqa qıkkı, ooqad tanalin kar adaççe. ");
INSERT INTO tkr_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","Amasa yəqqı'le alyart'uyle qiyğa, gırgınbı Bikriyna dix Şeva aqqasva Yoavne qihna avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S220_14","011_20_14","2SA","20","14","14","Yoav Avel-Bet-Maaka eyhene şaharılqasse gırgıne İzrailyne nasılbışde yı'q'neençe ılğeç'e. Maane cigabışeençeb g'oşun sabı, mang'uqab qihna avayk'an. Sayib mang'uqab qihna Berim eyhene cigeençenbı avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S220_15","011_20_15","2SA","20","15","15","Yoavna g'oşun k'yoptul, Avel-Bet-Maaka hiqiy-allançe avqaaqqana. Manbışe şaharne cabırbışde hiqiy-alla nyuq'vneke sa axtın ciga hı'ı, cabırbı qukkyok'al ha'as havayk'an. ");
INSERT INTO tkr_vpl VALUES ("S220_16","011_20_16","2SA","20","16","16","Mane gahil sa ək'elikane zəiyfee şahareençe ts'ir hav'u, eyhen: – K'ırıbı alixhxhe! K'ırıbı alixhxhe! Hucoona ixhes, Yoavık'le inyaqana qoracen, cuk'le eyhesın cuvab vodun. ");
INSERT INTO tkr_vpl VALUES ("S220_17","011_20_17","2SA","20","17","17","Yoav məng'ı'sqana qarımee, məng'ee qiyghanan: – Yoav ğune vor? Mang'vee, «Ho'o, zı vornava» eyhe. Zəiyfee meed eyhen: – K'ırı alixhxhe, zı, yiğne nukaree, vak'le hucooyiy eyhes. Mang'vee «Yizın k'ırı val vodva» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("S220_18","011_20_18","2SA","20","18","18","Zəiyfee eyhen: – Şenke «Mı'sləhət Avel eyhene şahareençe hevqevaniyxhe» eyhen. İş manbışe məxüb g'ooce vuxha. ");
INSERT INTO tkr_vpl VALUES ("S220_19","011_20_19","2SA","20","19","19","Mana İzrailyna yugvalla vukkanna qopkuna sa şahar vobna. Vas İzrailyne xəbne şaharbışda sane hı'ğəəkar haa'as vukkan? Nişil-allane vas Rəbbis vukkanne şaharbışda sa hı'ğəəkar ha'as vukkan? ");
INSERT INTO tkr_vpl VALUES ("S220_20","011_20_20","2SA","20","20","20","Yoavee alidghıniy qelen: – Hı'ğəəkaraa'asdayiy avaak'an haa'asda fıkır zake əq'əna quvxhecen! ");
INSERT INTO tkr_vpl VALUES ("S220_21","011_20_21","2SA","20","21","21","Man ğu eyhen xhinne deş vod. Efrayimne suvabınane cigeençe Bikriyne dix Şeva paççah Davudılqa g'elil qıxha. Saccu mana şasqa qele, zınar ine şaharısse qığeç'u, əlyhəəsda. Zəiyfee Yoavık'le eyhen: – Mang'una vuk'ul şaharne cabırıle valqa dağepçes. ");
INSERT INTO tkr_vpl VALUES ("S220_22","011_20_22","2SA","20","22","22","Zəiyfa ək'elika ı'ğiykır milletne k'anyaqa iyeek'an. Milletınıb Bikriyne dixena Şevayna vuk'ul gats'apk'ın, mang'usqa dağabaççe. Mançile qiyğa Yoavee şeypur ı'lyviyxə, g'oşunub şaharne hiqiy-allançe ts'ıts'ooxhena. Gırgınbı cone xaybışeeqa siviyk'al. Yoavır İyerusalimqa paççahne k'anyaqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","Yoav gırgıne İzrailyne g'oşunna xərna ıxha. Yehoyadayna dix Benaya Keretbışdayiy Peletbışda xərna ıxha. ");
INSERT INTO tkr_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","Adoram həmbalaaşina xərna ıxha. Axiludna dix Yehoşafat taarix oyk'anna ıxha. ");
INSERT INTO tkr_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","Şeva mirza ıxha, Tsadokiy Evyatarıb kaahinar vuxha. ");
INSERT INTO tkr_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","Yair eyhene şahareençena İra Davudusne kaahin ıxha. ");
INSERT INTO tkr_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","Davudee paççahiyvalla haa'ane gahıl, xhebille sen çiçiqad qihna q'ittin ıxha. Mançinemee Davudee Rəbbike qidghın ha'a. Rəbbee Davuduk'le eyhen: – Man Şauleeyiy cune nasılen k'yav'uyne ebal-alla vod. Mang'vee Giveonğançenbıniy gyapt'ı. ");
INSERT INTO tkr_vpl VALUES ("S221_2","011_21_2","2SA","21","2","2","Paççahee Giveonbı qopt'ul, manbışika yuşan ha'ana. Giveonbı İzrailybı deş vuxha. Manbı Emor eyhene milletıke avxuynbı vuxha. İzrailybışe manbı üçübba g'alya'asva k'ın g'assır ıxha. Şaulusmee manbı gyapt'ı avaak'an haa'as vukkiykın. Mang'us mane cigabışee saccu İzrailybıyiy Yahuder avxu vukkan vuxha. ");
INSERT INTO tkr_vpl VALUES ("S221_3","011_21_3","2SA","21","3","3","Davudee Giveonaaşike qiyghanan: – Zasse vuşdemee hucoo ha'as əxəyee? Şu, Rəbbee g'əyxı'yne milletıs xayir-düə huvuynemee, şi hav'una bınah zasse nəxüb havaakal haa'as vəəxəyee? ");
INSERT INTO tkr_vpl VALUES ("S221_4","011_21_4","2SA","21","4","4","Giveonbışe mang'uk'le eyhen: – Şas Şaulıniy cune nasılen k'ınəəğəyiy nuk'ra ıkkan deş. İzrailir şas vuşucar gik'as ıkkan deş. Davudee manbışik'le eyhen: – Şos hucooyiy ıkkan, zı manıd ha'asın. ");
INSERT INTO tkr_vpl VALUES ("S221_5","011_21_5","2SA","21","5","5","Manbışe paççahık'le eyhen: – Şi İzrailil ımaaxvacenva Şaulee şake öc alyapt'ı, şi gyapt'ı. ");
INSERT INTO tkr_vpl VALUES ("S221_6","011_21_6","2SA","21","6","6","Mang'uke g'arına yighıyre adamiy şasqa hele. Şinab manbı Rəbbee g'əyxı'yne Şaulne Givea eyhene şaharee Rəbbine ögiyl givaaxanas. Paççahee «Manbı zı şosqa qevlesınbıva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("S221_7","011_21_7","2SA","21","7","7","Paççah Davudus Şaulne ühatsühat Yonatanna dix Mefiboşet qiykkanna. Mang'us mana qiykkanna Rəbbine ögiyl Yonatanıs k'ın g'assırva. ");
INSERT INTO tkr_vpl VALUES ("S221_8","011_21_8","2SA","21","8","8","Paççahee Armoniyiy merna Mefiboşet alyabat'a. Manbı Ayyayne yişşee Ritspee Şauluke vuxuyn dixbı vuxha. Sayıb mang'vee Şaulne yişşee Meravee Mexolğançene Barzilayne dixeke Adrielike vuxuyn xhoyre dix alyabat'a. ");
INSERT INTO tkr_vpl VALUES ("S221_9","011_21_9","2SA","21","9","9","Mang'vee manbı Giveonbışisqa qoole. Giveonbışe manbı Rəbbine ögiyl suval givaaxananbı. Manbışda yighırsana sacigee habat'anbı. Manbı xhıt'a qiviyşalne ts'eppiyne yiğbışil givaaxan. ");
INSERT INTO tkr_vpl VALUES ("S221_10","011_21_10","2SA","21","10","10","Ayyayne yişşee Ritspee cesva palan alyaat'u, ganzıl gyadaççe. Ritspa xhıt'abı qiyşal gibğılıne yiğbışile, givapxıninbışilqa gyoğiy gyoğasde yiğılqamee maa'ar ayxu. Məng'ee manbışde mayitbışisqa yiğniyığın xəybışin şit'yar, xəmded çolan həyvanar qeetxhes hassır deş. ");
INSERT INTO tkr_vpl VALUES ("S221_11","011_21_11","2SA","21","11","11","Şaulne həmbal zəiyfee, Ayyayne yişşee Ritspee ha'ana mana iş Davudulqa hivxhar haa'ana. ");
INSERT INTO tkr_vpl VALUES ("S221_12","011_21_12","2SA","21","12","12","Davudee hark'ın, Şaulıniy mang'une dixen Yonatanın bark'vbı Gileadne Yaveşne ç'ak'ınbışike g'eşşenbı. (Filiştinaaşe Gilboa eyhene suval Şaul gik'uyne yiğıl manbışin mayitbı Bet-Şeane maydama givayxananbı. Yaveşğançene insanaaşeb abı, manbışin mayitbı qöqənbı.) ");
INSERT INTO tkr_vpl VALUES ("S221_13","011_21_13","2SA","21","13","13","Davudee Şauluniy mang'une dixen Yonatanın bark'vbı mançe alyaat'anbı, şene givapxınne yıghıng'unud bark'vbı sa'anbı. ");
INSERT INTO tkr_vpl VALUES ("S221_14","011_21_14","2SA","21","14","14","Davudne insanaaşe Şaulıniy mang'une dixen Yonatanın bark'vbı Benyaminaaşine cigabışeene Tsela eyhene şaharee, Şaulne dekkıne, Gişine, mağareene nyuq'vnesnee k'eyxha. Paççahee manbışik'le uvhuyn gırgın, mane insanaaşe ha'an. Mançile qiyğa Allahee ölkaynemee ha'ane gırgıne düəbışis alidghıniy qelen. ");
INSERT INTO tkr_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","Meeb Filiştinaaşda İzrailybışika dəv'ə gyooxha. Davud cune insanaaşika Filiştinaaşika səyxəsva ayk'an. Manbı Filiştinaaşika siviyxəmee Davud oyzarna. ");
INSERT INTO tkr_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","Rafayke g'arıyne İşbi-Benovusus Davud gik'as ıkkiykan. Mang'une nizeyn siv tuncıke xhebıd vəş (300) şekel yı'q'vəlee ıxha. Yı'q'eeqad mang'vee ts'edın g'ılınc qı'ı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","Tseruyayna dix Avişay Davudusqa kumagıs qarı, Filiştinğançena mang'vee ı'xı', gek'ana. Mane gahıl Davudne insanaaşe mang'us k'ın g'assır, eyhen: – İzrailin işix k'imədəqqəcenva, sayır ğu şaka dəv'eeqa ayres deş. ");
INSERT INTO tkr_vpl VALUES ("S221_18","011_21_18","2SA","21","18","18","Mançile qiyğa Filiştinaaşika Gov eyhene cigee meed səvxiy gexha. Mane gahıl Xuşa eyhene cigeençene Sibbekayee Rafayke g'arına Saf gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S221_19","011_21_19","2SA","21","19","19","Filiştinaaşika Gov eyhene cigee meed səvxiy gexha. Manke Bet-Lexemğançene Yareyne dixee Elxananee Gatğançena Golyatna çoc gek'ana. Mang'une nizeyn cık'rı qexhvane xhanayn arğacın dal xhinne xətta ıxha. ");
INSERT INTO tkr_vpl VALUES ("S221_20","011_21_20","2SA","21","20","20","Gat eyhene şaharne k'ane sa menne yəqqees gitxhuyne səvxee, Rafayke g'arına sa axtına canakana insan ıxha. Mane insanne xıleppışilib, g'elybışilib yixhıble t'ubiy. Mang'uqa gırgıba g'ayeyoq'ab (24) t'ub vuxha. ");
INSERT INTO tkr_vpl VALUES ("S221_21","011_21_21","2SA","21","21","21","İzrailybışik'le mang'vee nen qadiy eyhemee, Davudne çocune Şimayne dixee Yonatanee mana gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S221_22","011_21_22","2SA","21","22","22","Mana Rafayke g'arına yoq'uyre insan Gatğançenbı vuxha. Manbı Davudneyiy Davudne insanaaşine xıleke hapt'ı. ");
INSERT INTO tkr_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Rəbbee Davud gırgıne cune duşmanaaşineyiy Şaulne xılençe g'attixhan hı'ımee, Davudee Rəbbis ina mə'niy qəbəqqə: ");
INSERT INTO tkr_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","Rəbb yizda suva vobna, yizda g'ala, zı g'attixhan ha'ana vorna. ");
INSERT INTO tkr_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","Allah yizın ganz vodun, Mang'usne zı dyugul ixhes. Yizın g'alxan, zı g'attixhanasda suva, it'umun ciga Mana vor. Allahee zı g'attixhan ha'a. Ğu, Rəbb, zı eb ulyooğanbışde xılençe g'attixhan ha'a! ");
INSERT INTO tkr_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Şukur gyooxhane Rəbbilqa ona'as, yizde duşmanaaşine xılençer g'attixhanasda. ");
INSERT INTO tkr_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","Yizde hiqiy-alla gyabat'an mırtar ıxha, zı gek'ane damabışile zı qəyq'ən ıxha. ");
INSERT INTO tkr_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Ahalın t'ü'bı zalqa alitk'ır ıxha, gyapt'asde gugubışeqar zı girxhu ıxha. ");
INSERT INTO tkr_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","Dağamiyvalee zı Rəbbilqa onuiyn, Allah kumagıs qort'ul. Mang'uk'le yizın ses Cune Xaa g'ayxhiyn, yizın uts'ur Mang'une k'ıriysqa hitxhıriyn. ");
INSERT INTO tkr_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","Mang'us qəl vuxhal-alla ç'iye oyt'al, ı'ğiykaran, xəən xhebbı ı'ğiykar, manbı hoyharanbı. ");
INSERT INTO tkr_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","Mang'une quşeençe kuma qığeç'u, ghalençe gyooxhan haa'an ts'a ı'xiyxə. Mançikeb gyopxhanna ghadır k'yoohar. ");
INSERT INTO tkr_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","Mang'vee xəybı qaxı, ç'iyelqamee geç'ena. Miç'axiyvalla Mang'une g'elybışik avub vuxha. ");
INSERT INTO tkr_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","Sa keruvulil alixı, mıtsıne xılibışil ilexa. ");
INSERT INTO tkr_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","Hiqiy-allan ciga xəmdilqa sak'al ha'a, xhineka gyatsts'ıyne k'aarıne buludbışike Culqa aççesın kar ha'a. ");
INSERT INTO tkr_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","Mang'une nuruke gyotxhanan ts'a qı'ğəə ıxha. ");
INSERT INTO tkr_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","Rəbbee xəybı g'əhətqə'ə, Haq'-Ta'aalee ses gyayhe. ");
INSERT INTO tkr_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","Vukbı avhu, duşmanar ehevkaa'anbı, ts'ayılpan ı'xı'ı', manbı oot'al-ooxal haa'anbı. ");
INSERT INTO tkr_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","Qəvəəq'ənasde Rəbbine sesıke, quşeençene qı'ğəəne it'umne nafasıke, deryahın k'oralybı g'ece giyğal, dyunyeyn xhebbı g'ece giyğal. ");
INSERT INTO tkr_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","Mang'vee xəybışeençe xıl hotku, zı aqqı, zı k'orane xhyanbışeençe qığavhu. ");
INSERT INTO tkr_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","Zı gucnane duşmanıke Mang'vee g'attixhan hı'ı, zı g'ımece eyxhenbışike, yizdemee geeb gucnanbışike g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","Yizde pisde yiğıl manbı yizde ögiylqa qığeepç'ı, Rəbbeeme zı aqqı. ");
INSERT INTO tkr_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","Mang'vee zı dağamiyvalike hixu'u, zı ıkkiykın, zı g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","Yizde qopkuvalis sik'ı Rəbbee zas huvu, yizde xılene məttıvalis sik'ı huvu. ");
INSERT INTO tkr_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","Mang'vee məxüd hı'iyn zı Rəbbina yəq' avquva, pisda ıxha Allahılqa yı'q' sak'al hidi'ıva. ");
INSERT INTO tkr_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","Mang'un gırgın q'aanunbı yizde ögiyl vod, Mang'une g'aydabışiler hixu deş. ");
INSERT INTO tkr_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Zı Mang'une ögiyl məttıne yik'eka ıxha, zıcar zı bınahıke havacına. ");
INSERT INTO tkr_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Rəbbee yizde qopkuvalis sik'ı huvu, Cune ulene ögiyl yizde məttıvalis sik'ı huvu. ");
INSERT INTO tkr_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","Ğu saadik'ranang'uka saadik'ra eyxhe, kaamilinbışika kaamilyra vor. ");
INSERT INTO tkr_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Məttınbışika məttıra, quç'opkuriynbışika, cone quç'opkuriys sik'ı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","Hooç'an-g'ooç'ananbı Ğu g'attivxhan haa'a, cocab-co axtıba vukkekanbışilqab Ğu ul giviyxhe, manbı k'ap'ik'ıle avqa qaa'a. ");
INSERT INTO tkr_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","Rəbb, Ğu yizın işix vod, Ğu yizda miç'axiyvalla nurulqa savaak'al haa'a. ");
INSERT INTO tkr_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","Zı Vakasana duşmanaaşikın ha'a, yizde Allahıka şaharbı aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Allahna yəq kaamilyba vob, Rəbbin cuvab məttıda vod! Mang'ulqa yı'q' qizzırna gırgına, Mang'vee g'attixhan ha'ana. ");
INSERT INTO tkr_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","Rəbbile ğayrı, Allah vuşune vor? Yişde Allahıle ğayrı, medın ganz nenne vod? ");
INSERT INTO tkr_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","Allah yizda it'umna g'ala vobna, Mang'vee yizda yəq qopku qaa'a. ");
INSERT INTO tkr_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","Mang'vee yizın g'elybı maralın g'elybı xhinne ek' qa'a, Zı axtıvalee it'umra aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","Mang'vee yizın xıleppı dəv'əysın xhinne qa'a, zasse tuncıke hı'iyn vuk quç'okara'as əxən. ");
INSERT INTO tkr_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","Ğu zas g'attixha'anasın g'alxan huvu, Ğu hı'iyne kumaagıka zı axtı qı'ı. ");
INSERT INTO tkr_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","Zasse saccu Vaka əq'ra iykaras əxə, zı məxür qaçayxarır deş. ");
INSERT INTO tkr_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","Zı duşmanar g'ee'epşiynbı, manbı gyapxıynbı, manbışikın ixhesmee yı'q'əlqar sak'ı deş. ");
INSERT INTO tkr_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","Zı manbı hööq'əv'u ç'əvxhana, manbışisse suğoots'asıb vəvxü deş, yizde g'elybışik avqa manbı qukk'yopk'ul. ");
INSERT INTO tkr_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","Dəv'əynemee Ğu zalqa guc alipk'ır, zalqa g'elil qeepxhaynbı Ğu yizde g'eliqqa huvu. ");
INSERT INTO tkr_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","Duşmanar zale heepxasınbı xhinne qaa'a, zı g'ımecenanbışikınıd zı hı'iyn. ");
INSERT INTO tkr_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","Manbışe uleppı ooqa qe'eeyid, manbı g'attivxhan haa'anbı vuxha deş, Rəbbilqa onu'eeyid, Mang'vee alidghıniy quvu deş. ");
INSERT INTO tkr_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","Zı manbı k'ööq'ü, tooz xhinne qav'u, şahrabışeedın battağ xhinneeyib k'ööq'üynbı. ");
INSERT INTO tkr_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","Ğu zı, yizde milletne g'elil qeepxhayke g'attixhan hı'ı, zake milletbışda xərna hı'ı, zak'le dyats'ancad milletbı yizde xılyaqa quvu. ");
INSERT INTO tkr_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","Menne cigeençenbı yizde ögiyl k'yoozarav'uynbı, yizın do g'ayxhımee, eyhen ha'a. ");
INSERT INTO tkr_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","Menne cigeençenbı yizde ögiyl hapq'ıriynbı. Qəpq'ı'n zezebı atk'u, dyuguleepxhayne cigeençe qığeepç'iynbı. ");
INSERT INTO tkr_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","Rəbb vorna! Yizde Ganzıs şukur vuxhena! Zı g'attixhan hı'iyn Ganz, Allah, axtı qe'e! ");
INSERT INTO tkr_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","Allahee zal-alla qəl qığaaha, milletbı yizde xılyaqa qele. ");
INSERT INTO tkr_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","Mang'vee zı yizde duşmanaaşine xılençe g'attixhan ha'a, Mang'vee zı yizde duşmanaaşile ooqana ha'a, Zı eb ulyooğanbışde xılençe g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","Rəbb, mançil-alla zı Ğu menne milletbışde yı'q'nee axtı qa'as, zı Yiğne doyus şukur haa'as! ");
INSERT INTO tkr_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","Allahee Cune paççahıs xədın ğamxhaybı heles, g'əyxı'yne Davudne nasıles gırgıne gahbışilycab yugvalla haagvas. ");
INSERT INTO tkr_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","Davudee nekke qiyğa inva uvhu: – Yesseyne dixee Davudee, Allahee axtı qı'ıne insanee, Yaaq'ubne Allahee g'əyxı'ng'vee, ittune miznane mə'niybı İzrailee qədəqqəng'vee inəxüdud eyhe: ");
INSERT INTO tkr_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","Rəbbine Rı'hı'n zale ğana uvhu, Mang'un cuvab yizde mizel vod. ");
INSERT INTO tkr_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","İzrailyne Allahee inəxüd uvhu, İzrailyne Ganzın zak'le inəxüd uvhu: «Allahıle qəyq'ənang'vee insanaaşis qopkuba xəbvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","Mana buludbı deşde miç'eeb ılqəəne, gyoğiyle qiyğa hits'aagharne, ok' aleylyaa'ane verığne ulek akar». ");
INSERT INTO tkr_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","Hək'ebab, Allahee yizda xizan g'əvxüna! Mang'vee zaka gırgıne gahbışisın cuvab dişde g'ats'atk'un? Man cuvab bıkırın, badal dexhen ıxha. Mang'vee zas ıkkananbı hele, Mang'vee zı g'attixhan ha'a. ");
INSERT INTO tkr_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","Gırgın karaı'dəənbı zazabı xhinne dağaa'as. Manbışilqa şavaacad xıl hotkas deş. ");
INSERT INTO tkr_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","Manbışik soot'asınbışe, nizeyl, g'ılıncıl alyapt'as vukkan. Manbışin gırgınbı cigeecab gyooxhan haa'asınbı. ");
INSERT INTO tkr_vpl VALUES ("S223_8","011_23_8","2SA","23","8","8","Davudne igideeşin dobı inbı vod: Taxmonne şahareençena Yoşev-Başşevet xhebne igidna xərna ıxha. Sa dəv'ee mana molyud vəş (800) insanılqa nizeyka hark'ın, manbı gyapt'ıynbı. ");
INSERT INTO tkr_vpl VALUES ("S223_9","011_23_9","2SA","23","9","9","Mang'ule qiyğa Axoxiyna neva, Dodoyna dix Eleazar ıxha. Mana xhebne igidna sa ıxha. Filiştinaaşine g'oşunulqa cuvab ayhemee, mana Davuduka ıxha. İzrailybı yı'q'əlqa ts'ıts'eepxhamee, ");
INSERT INTO tkr_vpl VALUES ("S223_10","011_23_10","2SA","23","10","10","saccu sa Eleazar cune cigeençe ı'ğdiykar. Mang'vee g'ılıncıd alyaat'u, xıleppı rı'hı'le g'a'atk'vasmee, Filiştinar gyabat'a. Dəv'ə ç'əvuvxhayle qiyğa, mang'usse xıl aaqı, g'ılınc dağeççes əxə deş. Mane yiğıl Rəbbee İzrailybışis xədın ğameepxhay hele. İzrailybı mane yiğıl Eleazarısqa saccu maa'ab avxuyn hapt'ıynbı q'əra qaa'asvacab siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("S223_11","011_23_11","2SA","23","11","11","Mang'ule qiyğiyna Harar eyhene şahareençena Ageyna dix Şamma ıxha. Sa yəqqee Filiştinar Lexi eyhene cigee sabayle. Maad hüvə oozıyn çol ıxha. İzrailybışin millet Filiştinaaşile q'ətq'ı'n, mançe hexvan. ");
INSERT INTO tkr_vpl VALUES ("S223_12","011_23_12","2SA","23","12","12","Saccu Şamma çolune yı'q'nee ulyoyzar. Mang'vee Filiştinaaşisqa çol qele deş, manbı gyabat'anbı. Mane yiğıl Rəbbee İzrailybışis xədın ğameepxhay hele. ");
INSERT INTO tkr_vpl VALUES ("S223_13","011_23_13","2SA","23","13","13","Suk qiviyşalne gahıl xhebts'alyne (30) xərıng'una xhebiyre Davudne k'anyaqa Adullamne mağaraysqa abayle. Mane gahıl Filiştinaaşina g'oşun Refaimne q'adaalilqa savayle. ");
INSERT INTO tkr_vpl VALUES ("S223_14","011_23_14","2SA","23","14","14","Davudmee xıl hidixharasde cigee ıxha. Filiştinaaşikene sabaranbı manke Bet-Lexem vuxha. ");
INSERT INTO tkr_vpl VALUES ("S223_15","011_23_15","2SA","23","15","15","Davud xhyanıka gyorxhan ıxhayke eyhen: – Zas Bet-Lexemne akkaysneene kahrızeençe xhyan ıkkekkanaxhiy ıxhana! ");
INSERT INTO tkr_vpl VALUES ("S223_16","011_23_16","2SA","23","16","16","Manke mane xhebne igidee Filiştinar sabıyne cigayne yı'q'neençe g'ılıncbışika cosda yəq hav'u, Bet-Lexemne akkabışisneene kahrızeençe xhyan gyatsts'ı, paççah Davudus adayle. Davudus man xhyan ulyoğas diykkın, man xhyan Rəbbis helen xhinne ç'iyelqa ot'al ha'a. ");
INSERT INTO tkr_vpl VALUES ("S223_17","011_23_17","2SA","23","17","17","Mang'vee eyhen: – Rəbb, Ğu zı mançike havace. Nya'a, yizdemee hapt'ıyle qı'dəpq'ı'n xhyan gyatsts'es hapk'ıniynbışda zı eb ulyooğayee? Mançil-allad mang'vee man xhyan ulyoğa deş. Man xhebne igidee hı'ı. ");
INSERT INTO tkr_vpl VALUES ("S223_18","011_23_18","2SA","23","18","18","Yoavna çoc Tseruyayna dix Avişay xhebts'alyne (30) igidna xərna ıxha. Mana cune nizeyka xhebıd vəş (300) insanıka saçikku, manbışin gırgınbıb mang'vee gyapt'ıynbı. Mançile qiyğa mang'un do xhebne igidin do xhinne qıvaats'ıyn eyxhe. ");
INSERT INTO tkr_vpl VALUES ("S223_19","011_23_19","2SA","23","19","19","Mana xhebts'alyne (30) igidiler qıvaats'ına ixheeyir, şene xhebne igidika avayq'ar deş. ");
INSERT INTO tkr_vpl VALUES ("S223_20","011_23_20","2SA","23","20","20","Yehoyadayna dixır Benayır ç'ak'ın işbı g'ecena qıvaats'ına insan ıxha. Mana Qavtse'el eyhene şahareençe qarı ıxha. Benayee q'öyre Moavğançena inekke yugna igid gek'a. Mang'vee yiznane yiğıl k'orane cigeeqa giç'u, şir gik'u. ");
INSERT INTO tkr_vpl VALUES ("S223_21","011_23_21","2SA","23","21","21","Sayır mang'vee sa geer xərna Misirğançena gik'u. Misirğançeng'une xıle nize ıxha. Benaya mang'ulqa t'at'aka ark'ın, Misirğançeng'une xılençe ts'ıts'ı'ı mang'un nize g'eşşen. Qiyğar Misirğançeng'une nizeykacar mana gek'ana. ");
INSERT INTO tkr_vpl VALUES ("S223_22","011_23_22","2SA","23","22","22","Man gırgın Yehoyadayne dixee Benayee ha'a. Mançil-alla mana xhebiyre igid xhinne qıvaats'ına ıxha. ");
INSERT INTO tkr_vpl VALUES ("S223_23","011_23_23","2SA","23","23","23","Mana xhebts'alyne (30) igidiler qıvaats'ına ixheeyir, şene xhebne igidika avayq'ar deş. Davudee mana, cus g'aravuliyvalla ha'anbışda xərna giyxhe. ");
INSERT INTO tkr_vpl VALUES ("S223_24","011_23_24","2SA","23","24","24","Mane xhebts'alyne (30) igidne yı'q'nee inbıb vuxhaynbı: Yoavna çoc Asahel, Bet-Lexemğançene Dodoyna dix Elxanan, ");
INSERT INTO tkr_vpl VALUES ("S223_25","011_23_25","2SA","23","25","25","Xarodğançena Şammayiy Eliqa, ");
INSERT INTO tkr_vpl VALUES ("S223_26","011_23_26","2SA","23","26","26","Peletğançena Xelets, Teqoağançena İqqeşna dix İra, ");
INSERT INTO tkr_vpl VALUES ("S223_27","011_23_27","2SA","23","27","27","Anatotğançena Aviezer, Xuşabışda Mevunnay, ");
INSERT INTO tkr_vpl VALUES ("S223_28","011_23_28","2SA","23","28","28","Axoxibışda Tsalmon, Netofğançena Maharay, ");
INSERT INTO tkr_vpl VALUES ("S223_29","011_23_29","2SA","23","29","29","Netofğançene Baana dix Xelev, Benyaminne nasılena Giveağançene Rivayna dix İttay, ");
INSERT INTO tkr_vpl VALUES ("S223_30","011_23_30","2SA","23","30","30","Piratonğançena Benaya, Gaaşne q'adaalile Hidday, ");
INSERT INTO tkr_vpl VALUES ("S223_31","011_23_31","2SA","23","31","31","Aravğançena Avi-Alvon, Barxumğançena Azmavet, ");
INSERT INTO tkr_vpl VALUES ("S223_32","011_23_32","2SA","23","32","33","Şaalvonğançena Eliaxba, Yaşenın dixbı, Hararğançene Şammayna dix Yonatan, Ararğançene Şararna dix Axiam, ");
INSERT INTO tkr_vpl VALUES ("S223_34","011_23_34","2SA","23","34","34","Maakağançene Axasbayna dix Elifelet, Giloğançene Axitofelyna dix Eliam, ");
INSERT INTO tkr_vpl VALUES ("S223_35","011_23_35","2SA","23","35","35","Karmelyğançena Xetsray, Aravğançena Paaray, ");
INSERT INTO tkr_vpl VALUES ("S223_36","011_23_36","2SA","23","36","36","Tsovağançene Natanna dix İgal, Gadne nasılena Bani, ");
INSERT INTO tkr_vpl VALUES ("S223_37","011_23_37","2SA","23","37","37","Ammonğançena Tseleq, Tseruyayne dixen Yoavın silah ı'ğiykar ha'ana Beerotğançena Naxaray, ");
INSERT INTO tkr_vpl VALUES ("S223_38","011_23_38","2SA","23","38","38","Yeterğançena İrayiy Garev, ");
INSERT INTO tkr_vpl VALUES ("S223_39","011_23_39","2SA","23","39","39","Q'etbışda Uriy. Manbı gırgıba sacigee xhebts'ale yighıyre (37) insan ıxha. ");
INSERT INTO tkr_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","Rəbbina qəl meeb İzraililqa avqaaqa. Mang'vee Davuduk'le eyhen: «Hoora, İzrailybıyiy Yahuder qəpqe». Məxür Mang'vee Davud İzrailybışilqa g'elil qı'ı. ");
INSERT INTO tkr_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","Davudee cune k'anene g'oşunne xərıng'uk'le Yoavık'le eyhen: – Həşde Danile Beer-Şevalqamee, gırgıne İzrailyne nasılbışde yı'q'nee iviykre, manbı qəpqe. Zak'le manbı nimeenbı vuxhay ats'axhxhes ıkkan. ");
INSERT INTO tkr_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","Yoavee paççahık'le eyhen: – Yiğın millet nimeeniy, hasre Rəbbee, yiğne Allahee, manbı vəş nəqqees mançile geeb qee'ecen. Yiğne ulek'led man g'acecen. Nya'a, nişil-allane yizde xərıng'us paççahıs məxbına iş haa'as vukkan? ");
INSERT INTO tkr_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","Paççahın cuvab Yoavneyiy g'oşunne ç'ak'ınbışde cuvabıle ooqan ıxha. Yoaviy g'oşunun ç'ak'ınbı İzrailin millet qətqəs vüqqəva paççahısse qığeebaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","Manbışe İordanne damayle ılğeepç'ı, Aroer eyhene şaharne k'ane çadırbı giyxə. Mana şahar q'adaalyne yı'q'nee vuxha. Qiyğa manbı Qadıne nasılene cigabışile k'ena Yazer eyhene şahareeqa avayk'an. ");
INSERT INTO tkr_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","Mançe manbı Gileadeeqa, Taxtim-Xodşi eyhene cigeeqa havayk'an. Mançeb Dan-Yaan eyhena şahar ılğevç'u, Sidonne şahareeqa qabı hiviyxhar. ");
INSERT INTO tkr_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","Sur eyhene g'aleeqa, Q'ivbışdeyiy Kana'anbışde gırgıne şaharbışeeqa manbı hapk'ın, hiviyxharanbı. Nekke qiyğab manbı qavaylenbı Yahudayne canubulyne Beer-Şeveeqa. ");
INSERT INTO tkr_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","Yüç'ne vuzeyiy g'ane (20) yiğee manbışe ölka k'anençe-qomaqamee gits'ibaxhana. Mançe İyerusalimeeqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","Yoavee nimeeniy insanar vuxhava paççahık'le eyhe. İzrailee mane gahıl g'ılıncıka səyxəs əxəsda molyud vəş aazır (800 000), Yahudeeyir xhod vəş aazır (500 000) igid ıxha. ");
INSERT INTO tkr_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","Davudee millet qətqəs alikkıyle qiyğa, mang'us culecad cus naş qexhe. Mang'vee Rəbbik'le eyhen: – Mana iş hav'u, zı xəbna bınah opxhun. Rəbb, həşde hucoona ixhes ine g'ulune taxsirıke ılyheç'e, zı bəç'əriyvalla hav'u. ");
INSERT INTO tkr_vpl VALUES ("S224_11","011_24_11","2SA","24","11","11","Davud qinne yiğıl miç'eer oza qıxesse, Rəbbee Davudulqa hixhar ha'ane Qad peyğambarık'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("S224_12","011_24_12","2SA","24","12","12","– Hoora, Davuduk'le eyhe, Rəbbee inva vod eyhe: «Yiğne ögiylqa xhebılle kar gixhxhes. Mançin sa g'əyxe, Zı vak ha'as». ");
INSERT INTO tkr_vpl VALUES ("S224_13","011_24_13","2SA","24","13","13","Qad Davudusqa arı, mang'uk'le eyhen: – G'əyxe, yighılle senna yiğne ölkee mısvalybı ıxhane vas ıkkan? Xheyible vazna hixu yiğne duşmanaaşine xılençe iykarasne ıkkan? Deşxheene, xhebılle yiğna yiğne ölkee yı'q'ı'n ık'arbı ıxhane ıkkan? Həşde yugba fıkır opxhun, ğu yiğın cuvab eyhe. Zı hark'ın zı G'axuvuyng'uk'le eyhes. ");
INSERT INTO tkr_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","Davudee Qadık'le eyhen: – Yizdemee geed dağamda vod. İnsanne xılyaqa gyapk'asse hasre Rəbbine xılyaqa gyapk'ecen. Rəbbiqa rəhı'm geeb vob. ");
INSERT INTO tkr_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","Mane yiğıl miç'ediyle otçu, Vucee gyuvxhuna gah ç'əvuvxhesmee, Rəbbee İzraililqa yı'q'ı'n ık'arbı g'ıxele. Danile Beer-Şevalqamee yights'al aazır (70 000) insan qek'a. ");
INSERT INTO tkr_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","İyerusalimeen insanar gyapt'asva malaaikın xıl hodakkemee, Rəbbis maabın insanar qiviykkın, malaaikık'le eyhen: – Ç'əv, xıl g'ayşe! Rəbbin malaaik mane gahıl Aravna donane sa insanne attayne k'ane ıxha. Aravna Yevusbışda ıxha. ");
INSERT INTO tkr_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","Davuduk'le millet gek'an malaaik g'acumee, Rəbbik'le eyhen: – Bınah hav'una zı vor, taxsir zal vod. Nya'a ine syuru xhineene insanaaşe hucoone hı'ı? Manbışil-alla zasiy yizde xizanıs caza hevle. ");
INSERT INTO tkr_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","Mane yiğıl Qad Davudusqa arı, eyhen: – Hark'ın Yevusbışda eyxhene Aravnayne attal Rəbbis q'urbanbı allya'an ciga ale'e. ");
INSERT INTO tkr_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","Qadıne cuvabıka, Davud, Rəbbee əmr hav'uyn xhinne maqa hayk'an. ");
INSERT INTO tkr_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","Aravna avqa ilyakkımee, Davudıy cun insanar cusqa qöö g'ooce. Mana g'aqa qığeç'u, paççahne ögiyl ç'iyelqamee k'yorzul, ");
INSERT INTO tkr_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","eyhen: – Nəxürkenane yizda xərna paççah zasqa arı? Davudee eyhen: – Rəbbis q'urbanbı allya'an ciga alya'asdemee zı vake yiğna atta alivşes arı. Milletılin yı'qı'n ıkar ulyoozrecenva zı Rəbbis q'urbanbı alya'as. ");
INSERT INTO tkr_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","Aravnee Davuduk'le eyhen: – Hasre yizde xərıng'vee, paççahee cune ulesqa yugda qöönmeen alyaat'u, Rəbbis q'urbanbı alle'ecen. Haane gyoxhxhan hı'ı q'urbanna allya'asın yatsbı aleet'e. Gyoxhxhan ha'asde osune cigee mıgrabıyiy yatsbışde gardanaqa qa'an karbı aleet'e. ");
INSERT INTO tkr_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","Paççah, man gırgın zı vas hele. Aravnee meed eyhen: – Hasre Rəbb, yiğna Allah, vaka yugra ixhecen. ");
INSERT INTO tkr_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","Paççaheeme Aravnayk'le eyhen: – Zı vake man ciga məxüdcad deş alyaat'as, zı mançike vas hək' qevles. Zas q'ərad gitxhuyn kar zasse Rəbbis, yizde Allahıs, gyooxhan haa'ana q'urban xhinne ablyaa'as dəəxə. Davudee attaykeyiy yatsbışike xhots'al (50) nuk'ra qele. ");
INSERT INTO tkr_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","Davudee maa'ad Rəbbis q'urbanbı allya'an ciga ali'ı, maa'ad gyoxhxhan ha'aniy medın q'urbanbı allya'a. Rəbbee ölkaynemee haa'ana düə q'abıl haa'ana, mançikad İzrailee yı'q'ı'n ık'arbı ç'əveedaxhenbı.");
INSERT INTO tkr_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","Paççah Davud q'əs qıxha eyxhe. Mang'ulqa nimeen karbı aççveyid mana g'üməarak'va ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","Mang'une nukaraaşe mang'uk'le eyhen: – Vas, yişde xərıng'us paççahıs sa mek'vna içiy t'abal hee'es, mana vaqa ileekecen. Vaka g'aliyxhecen, ğu g'üməark've'ecen. ");
INSERT INTO tkr_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","Manbışe paççahıs İzrailvolle micagna içiy t'abal hee'e, yicır iveekena. Mana Şunem eyhene xiveençena Avişag yeexhe. Manbışe mana içiy paççahısqa ayreele. ");
INSERT INTO tkr_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","Avişag geer micagna içiy yixha. Mana paççahıqa qihna iykar, mang'uqa ileeka yixha. Manbı sa tyulee g'alyapk'eeyib, manbışde əree vuççud ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("K11_5","012_1_5","1KI","1","5","5","Davudus Haggitike ıxhayne dixee Adoniyee «Zı paççah ixhesva» vucecar vuc axtı qa'a ıxha. Mang'vee cusqa dəv'əyn daşk'abı, balkanıl aleepxıynbı, cune ögiyl g'adaxhvanasda xhots'al (50) insan sa'a. ");
INSERT INTO tkr_vpl VALUES ("K11_6","012_1_6","1KI","1","6","6","Mang'une dekkee Davudee, mısacad mang'uk'le «Nya'a ğu məxüd ha'ava?» uvhu, mana cigee gyuarı'ına deşdiy. Adoniya micagna kar ıxha. Avşalomule qiyğa nekke xərna dix mananiy vor. ");
INSERT INTO tkr_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","Adoniya Tseruya eyhene xhunaşşeyne dixeka Yoavıkayiy kaahin Evyatarıka saraççe. Manbışe mang'un sura aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","Kaahin Tsadokee, Yehoyadayne dixee Benayayee, Natan peyğambaree, Şimeyee, Reiyee, Davudne igidyaaşe Adoniyayn sura aqqaqqa deş. ");
INSERT INTO tkr_vpl VALUES ("K11_9","012_1_9","1KI","1","9","9","Adoniyee En-Rogelyne k'anene Zoxeletne ganzıl çavra-vəq'ə, kokun q'ıkar q'urbanna allya'a. Gırgın cun çocar, paççahın dixbı, paççahıs k'anen gırgın Yahuder mang'vee qoot'alanbı. ");
INSERT INTO tkr_vpl VALUES ("K11_10","012_1_10","1KI","1","10","10","Natan peyğambar, Benaya, igider, çoc Sıleyman mang'vee qoot'al deş. ");
INSERT INTO tkr_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","Manke Natan peyğambaree Sıleymanne yedik'le Bat-Şevayk'le eyhen: – Nya'a vak'le g'ayxhı dişde, Haggitne dixee Adoniyee, yişde xərıng'uk'le, Davuduk'le dyats'a-dyats'a, cuke paççah hı'ıva? ");
INSERT INTO tkr_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","Həşde k'ırı alixhxhe, yiğıniy yiğne dixen Sıleymanın can nəxüdiy g'attixhan ha'as ıkkanva, zı vas mı'sləhət g'avces. ");
INSERT INTO tkr_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","Paççah Davudusqa hiyek'ne, mang'uk'le eyhe: «Yizda xərna! Vale qiyğa yizda dix Sıleyman paççah ixhesva, yiğne taxtıl mana gyu'arasva, ğu zas, yiğne nukarıs, k'ın dişdiy g'assır? Nya'a manke Adoniyee paççahiyvalla haa'a?» ");
INSERT INTO tkr_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","Ğu maa'ar paççahıka yuşan hee'emee, zı vaqar qihna maqa ikkeç'u, ğu eyhençis «Ho'ova» eyhes. ");
INSERT INTO tkr_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","Bat-Şeva paççahısqa mana eyxhene gozeeqa ikkeeç'e. Paççah q'əs qıxha eyxhe, mang'uqa Şunemğançena Avişag ileeka yixha. ");
INSERT INTO tkr_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","Bat-Şeva paççahne ögiyl ç'iyelqamee k'eezarna. Paççahee məng'ı'ke «Hucoone ıkkanva?» qiyghan. ");
INSERT INTO tkr_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","Bat-Şevee mang'uk'le eyhen: – Yizda xərna! Vale qiyğa yizda dix Sıleyman paççah ixhes, mana yiğne taxtıl gyu'arasva uvhu, ğu zas, yiğne nukarıs, yiğne Allahılen Rəbbilen k'ınniy g'assır. ");
INSERT INTO tkr_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","Yizda xərna, həşdemee Adoniya paççah ıxha, vasıb mançikena deşda. ");
INSERT INTO tkr_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","Mang'vee geed çavra-vəq'ə, kokun q'ıkar q'urbanna alli'ı. Paççahın gırgın dixbı, kaahin Evyatar, g'oşunna xərna Yoav mang'vee maqa sav'u. Yiğna nukar Sıleymanmee mang'vee maqa qort'ul deş. ");
INSERT INTO tkr_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","Yizda xərna paççah, İzrailynacab ul val vob, vale qiyğa yiğne taxtıl vuşuyiy gyu'arasva ğu manbışik'le ats'axhxhya'as ıkkan. ");
INSERT INTO tkr_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","Deşxheene, yizda xərna paççah, şene dyunyeeqa ark'ınmee, zınayiy yizda dix Sıleyman manbışe duşmanne k'ats'ee avqas. ");
INSERT INTO tkr_vpl VALUES ("K11_22","012_1_22","1KI","1","22","22","Bat-Şeva paççahıka yuşan hee'emee, ooğançe Natan peyğambar qarayle. ");
INSERT INTO tkr_vpl VALUES ("K11_23","012_1_23","1KI","1","23","23","Paççahık'le «Natan peyğambar arıva» eyhe. Mana paççahne k'anyaqa ikkeç'u, ç'iyelqamee k'yoyzarna. ");
INSERT INTO tkr_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","Natanee eyhen: – Yizda xərna paççah! Vale qiyğa Adoniya paççah ixhes, mana yiğne taxtıl gyu'arasva, ğu uvhuyn karı'iynne? ");
INSERT INTO tkr_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","G'iyna Adoniyee hark'ın geed çavra-vəq'ə, kokun q'ıkar q'urbanna alli'ı. Mang'vee maqa paççahın gırgın dixbı, g'oşunun ç'ak'ınbı, kaahin Evyatar qort'ul. Həşde manbışe, «Paççah Adoniya geer qa'anava!» uvhu otxhan ulyoğa vod. ");
INSERT INTO tkr_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","Mang'vee saccu zı, kaahin Tsadok, Yehoyadayna dix Benaya, yiğna nukar Sıleyman qudyopt'ul. ");
INSERT INTO tkr_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","Man kar ğu uvhune manbışe hı'ı? Nya'a manke ğu yiğne nukaraaşik'le vale qiyğa paççahne taxtıl vuşuyiy gyu'arasva ittevhu? ");
INSERT INTO tkr_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","Paççah Davudee alidghıniy quvu eyhen: – Bat-Şeva yizde k'anyaqa qeet'le. Bat-Şeva paççahısqa arı, mang'une ögiyl ileezar. ");
INSERT INTO tkr_vpl VALUES ("K11_29","012_1_29","1KI","1","29","29","Paççahee k'ın g'assır eyhen: – Zı gırgıne dağamiyvalybışike g'attixhan hı'iyne Vorne Rəbbilqa k'ın ixhen, ");
INSERT INTO tkr_vpl VALUES ("K11_30","012_1_30","1KI","1","30","30","zale qiyğa yiğna dix Sıleyman paççah ixhes, mana yizde taxtıl gyu'aras. Yiğnemee İzrailyne Allahılqa Rəbbilqa k'ın g'assır uvhuyn kar zı g'iyna ha'asın. ");
INSERT INTO tkr_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","Bat-Şeva paççahne ögiyl ç'iyelqamee k'yorzul, eyhen: – Yizda xərna paççah geer qa'ana! ");
INSERT INTO tkr_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","Paççah Davudee eyhen: – Kaahin Tsadok, Natan peyğambar, Yehoyadayna dix Benaya yizde k'anyaqa qoot'le. Manbışin gırgınbı paççahne k'anyaqa abaylenbı. ");
INSERT INTO tkr_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","Paççahee manbışik'le eyhen: – Yizın nukarar şosqa qoot'le, qiyğar yizda dix Sıleyman yizde g'atirılqa ali'ı, Gixonne xhyan ılqəəne cigaysqa ıkkee. ");
INSERT INTO tkr_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","Maa'ad kaahin Tsadokeeyiy Natan peyğambaree İzrailyna paççah ixhesva mang'ulqa q'ış qadğvecen. Qiyğad şeypur əlivxü, «Paççah Sıleyman geer qa'anava!» ts'irbı he'ecen. ");
INSERT INTO tkr_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","Qiyğa mana yı'q'əlqa qale, hasre yizde taxtıl gyu'recen. Mana yizde cigeena paççah ixhes. Zı mana İzrailynayiy Yahudayna xərna giyxhe. ");
INSERT INTO tkr_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","Yehoyadayne dixee Benayee inəxdın alidghıniy qele: – Aamin! Hasre yizde paççahne Allaheeyid Rəbbeeyid məxüd eyhecen. ");
INSERT INTO tkr_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","Rəbbee yizde xərıng'un paççahın sura aqqıyn xhinnee, hasre Sıleymanınıd sura aqqecen. Hasre mang'una taxt yizde xərıng'une paççah Davudne taxtıle axtıba hee'ecen. ");
INSERT INTO tkr_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","Kaahin Tsadokee, Natan peyğambaree, Yehoyadayne dixee Benayee, Keretbışe, Peletbışe Sıleyman, paççah Davudne g'atirılqa ali'ı, Gixonqa arayle. ");
INSERT INTO tkr_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","Kaahin Tsadokee Allahne çadıreençe q'ışika gyavts'una gaç alyapt'ı, Sıleymanılqa paççah ixhesva q'ış qadğu. Şeypur ilyviyxə gibğılmee, gırgıne cəmə'ətın «Paççah Sıleyman geer qa'anava!» ts'irbı ha'a. ");
INSERT INTO tkr_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","Cəmə'ət oza qıxha, mang'uqad qihna ayk'an. Manbışe zurna ı'lyviyxə, məxüd şadvalin ts'irbı ha'a, mançike ç'iyebı ı'ğiykar. ");
INSERT INTO tkr_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","Adoniyak'leyiy mang'ukane mihmanaaşik'le kar otxhun ç'əveepxhamee, man ses g'iyxhe. Yoavık'le şeypurun ses g'ayxhımee, eyhen: – Şahareençe qöön ses nəxdınniyxan? ");
INSERT INTO tkr_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","Mana cuvab uvhu g'attirxhın deşdiy, sayır ooğançe kaahin Evyatarna dix, Yonatan arayle. Adoniyee mang'uk'le eyhen: – İnyaqana qoralan. Ğu yugna insanır, yugunud xabarbı adı ixhes. ");
INSERT INTO tkr_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","Yonatanee Adoniyays inəxdın alidghıniy qele: – De'eş, məxüd deş vodun. Yişde xərıng'vee, paççah Davudee Sıleymanıke paççah hı'ı. ");
INSERT INTO tkr_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","Paççahee kaahin Tsadok, Natan peyğambar, Yehoyadayna dix Benaya, Keretbı, Peletbı Sıleymanıka sacigee g'axuvu. Mana manbışe paççahne g'atirılqa ali'ı. ");
INSERT INTO tkr_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","Kaahin Tsadokee, Natan peyğambaree Sıleyman paççah ixhecenva Gixonee mang'ulqa q'ış qadğu. Manbı mançe şadba apk'ın, şahareedın milletcad ı'ğiykır. Şok'le g'iyxhen ses mançe vod. ");
INSERT INTO tkr_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","Mançile qiyğa Sıleyman paççahne taxtıl gyu'ur. ");
INSERT INTO tkr_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","Yişda xərna paççah Davud tabrik ha'as abıyne mang'une insanaaşe uvhiyn: «Yiğne Allahee Sıleymanın do yiğne doyule sık'ıldad axtı qe'ecen, mang'una taxt yiğne taxtıleb axtıba avqecen!» Paççah vuc g'alirxhuyne cigeençe k'yorzul, ");
INSERT INTO tkr_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","inəxüd eyhe: «İzrailyne Allahıs Rəbbis şukur! G'iyna Mang'vee, yizde uleppışik'le g'ece-g'ece, yizde taxtıl gyu'arasda insan huvu!» ");
INSERT INTO tkr_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","Man g'ayxhımee, Adoniyayn gırgın mihmanar qəpq'ı'n, oza qeepxha cone yəqqı'n avayk'an. ");
INSERT INTO tkr_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","Adoniyamee, Sıleymanıle qərq'ı'n, ark'ın q'urbanbı allya'ane cigeene gaçbışike aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","Mang'vee hı'iyn Sıleymanıs yuşan ha'a: – Adoniya Sıleyman paççahıle qəyq'ənva mana q'urbanbı allya'ane cigeene gaçbışik ilyt'iyq'an. Mang'vee eyhen: «Hasre paççah Sıleymanee zas g'iyna k'ın g'assrecen, vucee zı g'ılıncıqqa hideles». ");
INSERT INTO tkr_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","Sıleymanee eyhen: – Mana kara'əəna insanxhee, mang'une vuk'lele sa çər g'a'avxhas deş. De'eş, mang'vee pisın kar he'eene, gik'asda. ");
INSERT INTO tkr_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","Paççah Sıleymanee insanar g'uxoole, manbışer Adoniya q'urbanbı allya'ane cigaysse qaraylena. Manar paççah Sıleymanısqa ıkkeç'u, mang'us k'yoyzarna. Paççah Sıleymanee mang'uk'le «Xaaqa hoorava» eyhe. ");
INSERT INTO tkr_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Davud qik'asın yiğbı k'ane qeetxhamee, mang'vee dixes Sıleymanıs nasiyhət haa'a: ");
INSERT INTO tkr_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","– Zınar, gırgınbı xhinne, sık'ınne gahıle qik'asda. Ğunar it'umra, yik'eka ixhe. ");
INSERT INTO tkr_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Yiğne Allahee Rəbbee eyhen hı'ı, Mang'une yəqqı'n hoora. Mısayne Q'aanunee otk'unin xhinne Allahne q'aanunbışil, əmrbışil, g'aydabışil ğu k'ırı alixhxheene, vasse gırgıncad ha'as əxəsın. ");
INSERT INTO tkr_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Manke Rəbbee in zas cuvab huvuyn kar ha'asın: «Vake g'abıynbı Yizde yəqqı'n apk'ınee, Zas yik'eençe, caneençe g'ullux hav'ee, vake g'abıynbışda İzrailyne taxtıle Zı ak'an ha'as deş». ");
INSERT INTO tkr_vpl VALUES ("K12_5","012_2_5","1KI","2","5","5","Vak'lecad Tseruyayne dixee Yoavee zak hı'iyn ats'an. Mang'vee İzrailyne g'oşunna q'öyre xərna – Nerna dix Avneriy Yitrayna dix Amasa – gyapt'ı, dəv'ə deşde gahıl dəv'eena xhineena eb k'yav'u. Yı'q'eena ts'irayiy g'elilinbı mang'vee eban qı'ı. ");
INSERT INTO tkr_vpl VALUES ("K12_6","012_2_6","1KI","2","6","6","Ğunar yiğne k'orane ək'elis sik'ı ı'ğı'ykre. Mang'una cagvara quvxhana vuk'ul ahaleeqa salamatba əlyhəəs hımaasar. ");
INSERT INTO tkr_vpl VALUES ("K12_7","012_2_7","1KI","2","7","7","Gileadğançene Barzilayne dixbışika yugra ixhe. Hasre manbı yiğne sufranıle kar otxhananbı vuxhecen. Zı yiğne çocule Avşalomıle hexvamee, manbı zasqa qabı. ");
INSERT INTO tkr_vpl VALUES ("K12_8","012_2_8","1KI","2","8","8","Benyaminaaşina eyxhena, Baxurimğançena Gerayna dix Şimeyır yiğne k'anençeğana vor. Maxanayimqa hark'ınne yiğıl mang'vee zas pisda bed-düə hav'u. Qiyğamee mana yizde ögiylqa İordanne damaysqa arı. Zı mang'uk'le mana gik'as deşva Rəbbilen k'ın g'assır. ");
INSERT INTO tkr_vpl VALUES ("K12_9","012_2_9","1KI","2","9","9","Həşde vak'le mana bınah deşdava mats'axhe. Ğu k'orana ək'elynana insan vor, vak'lecad mang'uk hucooyiy ha'as ıkkanva ats'an. Mang'una cagvarana vuk'ul eban gyavts'u ahaleeqa əlyhəəs alivke. ");
INSERT INTO tkr_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Davud qik'u cune dekkaaşisqa ayk'an. Mana Davudne Şaharee k'eyxha. ");
INSERT INTO tkr_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Davudee İzrailis yoq'ts'al (40) senna paççahiyvalla haa'a. Yighılle senna mang'vee Xevroneençe, xhebts'ale xhebılle (33) sennab İyerusalimeençe paççahiyvalla hav'u. ");
INSERT INTO tkr_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Sıleyman dekkıne Davudne taxtıl giy'ar. Mang'vee cuna paççahiyvalla it'umba avqaaqa. ");
INSERT INTO tkr_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","Sıleyman fironuka, Misirne paççahıka, xıne eyxhe. Mang'una yiş hey'ı. Mang'vee mana Davudne Şahareeqa qiykekka. Cun saray, Rəbbin xav, sayid İyerusalimne hiqiy-alladın cabırbı ali'ı, ç'əvepxhesmee mana maa'ar ayxu. ");
INSERT INTO tkr_vpl VALUES ("K13_2","012_3_2","1KI","3","2","2","Mane yiğbışilqamee xalq'ın erbışeeqa q'urbanbı adayli ıxha, Rəbbine doyil ali'in xav ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Sıleymanee dekkıne q'aanunbışis əməl ha'u, mançikad cus Rəbb nimee ikkıykıniy hagu. Mang'veeyidçikana erbışeeqa q'urbanbı adı gyooxhan ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Erbışın xədın, Giveon eyhene şahareeniy vod, q'urban gyuvk'asdimee paççah Sıleyman maqa hayk'an. Mana maqa arıng'a, aazır vuk'ulyniy q'urbanna gyooxhan haa'ana. ");
INSERT INTO tkr_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Mane xəmde Giveonul Rəbb Sıleymanne nik'eeqa arı. Allahee eyhen: – Hiqqe, hucooyiy vas ıkkan, hucoone vas heles? ");
INSERT INTO tkr_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","Sıleymanee eyhen: – Yiğne g'ulus, yizde dekkıs, Davudus, mana məttıne yik'eka qorkura Yiğne yəqqı'n əlyhəəva, Ğu, badaldexha, hammaşe geed yugvalbı ha'u. G'iyniyne yiğıl taxtılqa gyu'arasda dix huvuyka, Ğu mang'unemee badaldexhay hagu, xəbna yugvalla hav'u. ");
INSERT INTO tkr_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Ya Rəbb yizda Allah, Ğu Yiğne g'uluke yizda dek Davudne cigeeqana paççah ha'u. Zı uşaxra vor, zak'le ats'a deş ha'asın-hidya'asın. ");
INSERT INTO tkr_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Yiğna g'ul – Yiğne milletne yı'q'nee vor, Ğu g'əyxı'ni, geed xənni, qətqı'-ələtqı' ç'əvdexhesde milletne yı'q'nee. ");
INSERT INTO tkr_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Yiğne g'ulus Yiğın millet vuk'lek ıkkesda, yugunçike pisın cura'asda k'orana ək'el hevle. Menne curayl Yiğın xədın millet şavusse vuk'lek ıkkes əxəyee? ");
INSERT INTO tkr_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","İn Sıleymane heqqıyn Xudaavandays q'abıl eyxhen. ");
INSERT INTO tkr_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Allahee mang'uk'le inəxüd eyhe: «Ğu, yiğnimee xıliyna ı'mı'r, var-devlet, duşmanaaşin hapt'ıy heqqı deş, mançine cigee qotkuyn cura'as əxəsda ək'el hivqu. ");
INSERT INTO tkr_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Vas ıkkanan, Zı ha'asın. Zı vas hamanimee k'orana ək'el hevles, valqame vak akarana ıxha deş, valer qiyğa vaka amq'arna ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Mançile hexxada, ğu Zake hideqqıyn – var-devletıd, şöhratıd Zı vas helesın. Yiğne vaxtal ğu xhinnena paççah ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Yiğna dek Davud xhinne, Ğunar Yizde yəqqı'n horhulee, Yizde q'aanunbışil k'ırı gyaqqı çis sik'ı harakat he'ee, Zı vas xıliyna ı'mı'r hevles». ");
INSERT INTO tkr_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","İnyaa'ar Sıleyman muğur qıxha, ats'axhen man nyak' ıxhay. Mana İyerusalimqa sak'ı, Xudaavandayka mugaavilenane q'utyeyini ögiyl ulyorzul, gyoxhxhan ha'an q'urbanbıyiy əmin-amanın q'urbanbı alya'a. Mançile qiyğa cune hiqiy-allanbışis otxhun – ulyodğuy hele. ");
INSERT INTO tkr_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Sa yiğıl q'öyre g'ahapk'in yedar abı paççahne ögee ulyoozaranbı. ");
INSERT INTO tkr_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Manbışde sang'ee eyhen: – Ay yizda xərna! Şi hayne xhunaşşeyka sa xaa'a aaxva, mana xaanang'a zı uxooxuyn. ");
INSERT INTO tkr_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Xhebıd'esde yiğıl mançile qiyğa məng'eeyid uxooxuyn. Şi sacigeeniy vob, şaka haşucar xaa'ar deşdaniy, şi q'öyrecabniy vob. ");
INSERT INTO tkr_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Xəmde mane xhunaşşeyna dix ces xabar devxha nik'eenang'a horç'un qik'una. ");
INSERT INTO tkr_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Sura xəmde mana oza qiyxha alyarat'ana yizda dix, yiğna g'ulluxçiy g'alirxhuyne gahıl! Məng'ee giyxhena mana cene koksiysqa, cena qik'unamee giyxhena yizde koksiysqa. ");
INSERT INTO tkr_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Zı miç'eer ozaqiyxhayng'a yizde dixes kar oxhan ha'as, mana zak'le qik'u avaykı. Açux qıxhayng'a zı mang'uka sayır yugra ileekına, manke zak'le ats'axhen, mana yizda dix deşorva, zı uxuna. ");
INSERT INTO tkr_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Şene xhunaşşe eyhen: – De'eş! İna üç'ürna – yizda dix, şena qik'una – yiğna! Ts'erring'ee öc alyabat'a: – De'eş! Şena qik'una – yiğna, üç'ürna – yizda! Paççahne ögiyl manbışe həməxdın, hıccatbı ha'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Paççahee eyhen: – Vuşde sang'ee eyhe vod: «Yizda dix üç'ürra, yiğna qik'u», mansang'ee eyhe vod: «De'eş! Yiğna dix qik'u, yizdamee – üç'ürra». ");
INSERT INTO tkr_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Manke paççahee eyhen: – Zasqa xincal alle. Paççahısqa xincal adaylen. ");
INSERT INTO tkr_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Paççahee əmr haa'a: – Gyarxe üç'üdun uşax q'öne cigeeqa, sa sura hele ine xhunaşşeys, mansad – şene xhunaşşeys. ");
INSERT INTO tkr_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Üç'ürne dixene yedin yik' gyoyxhan cene uşaxıs, məng'ee paççahık'le eyhen: – Ay yizda xərna! Qile məng'ı'sqa uşax üç'üdda! Saccu gimek'a mana! Mansang'emee eyhen: – Ne zı, ne ğu mana alyart'as deş. Gyarxe mana! ");
INSERT INTO tkr_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Manke paççahe q'arar hoolena: – Üç'üdun uşax ts'erriyne xhunaşşeysqa qile. Gimek'a mana, mana mang'una yed vorna. ");
INSERT INTO tkr_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Paççahe huvuna q'arar g'avxhumee, gırgıne izrailbışda hı'rmat mang'us geeb qooxhe. Qotkuyn məhkamabı he'ecenva Allahee mang'us k'orana ək'el huvu. ");
INSERT INTO tkr_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Şevayne kraliçayk'le Rəbbike qabıyne Sıleymanne şöhratne hək'ee g'ayxhı. Mana ayreelena mang'us dağamın qidghınbı ha'as. ");
INSERT INTO tkr_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Mana geer xənne karvanıka: gulyağbışika, g'izilika, gıranne ekebışikad gyatsts'iyne devabışikayiy cene xəppanane insanaaşika İyerusalimqa Sıleymanısqa arı. Vuk'leene gırgıne karne hək'ee gaf hav'u. ");
INSERT INTO tkr_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Sıleymane məng'ı'ne gırgıne qidghıniybışis cuvab qelen: məxdun dağamın qidghıniy ıxha deşke, paççahısse cuvab qeles məxəcen. ");
INSERT INTO tkr_vpl VALUES ("K110_4","012_10_4","1KI","10","4","5","Şevayne kraliçayk'le Sıleymanna k'orana ək'elib, vucee alya'uyn sarayıd, sufraylin otxhuniybıd, mang'une kumagçeeşin xaybıd, nukaraaşin harakatbıd, manbışe alya'an tyulibıd, çaxırçerıb, Rəbbine xaaqa gyoxhxhana'as adıyn q'urbanbıd g'acuyng'a məng'ı'n nafas aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Məng'ee paççahık'le eyhen: – Yizde ölkee yiğne k'orane ək'elene hək'ee, işbışde hək'ee eyhenbı qotkuda ooxhud. ");
INSERT INTO tkr_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Arı yizde uleppışik'le g'acesmee, zı mane cuvabbışilqa inyammişeexhe deşdiy. Zak'le g'acuynçine surançine hək'ee zas yuşan hı'ı deşod. Yiğna k'orana ək'el, yiğın var-devlet zak'le g'ayxhınçile hexxada vod. ");
INSERT INTO tkr_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","Baxtivararıb yiğın insanar! Baxtivararıb yiğın kumagçer, nenbıyiy hammaşe yiğne ögiyl ulyoozar, yiğna ək'elikana gaf g'iviyxhe! ");
INSERT INTO tkr_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Allahıs, yiğne Rəbbis şukur vuxhena, ğu ikkıykın, İzrailyne taxtılqa gyu'ar ha'uyl-alla. Rəbbis hammaşe İzrail vukkiykınil-alla, adalətiy qopkuvalla vuxhecenva vake paççah ha'u. ");
INSERT INTO tkr_vpl VALUES ("K110_10","012_10_10","1KI","10","10","10","Məng'ee paççahıs payis yoq'ne tonule hexxan g'izil, geed curabışikan gulyağbı, sayid gıranın ekebı adı ıxha. Məng'ee Sıleyman paççahıs adıynmeen gulyağbı mankilyqamee şavacad adı deşdiy. ");
INSERT INTO tkr_vpl VALUES ("K110_13","012_10_13","1KI","10","13","13","Sıleyman paççahee vucee huvuynçile hexxadad, Şevayne kraliçays hucooyiy ikkıykın, qidiykkın helen. Mançile qiyğa mana cene insanaaşiska cene ölkaylqa siyk'al. ");
INSERT INTO tkr_vpl VALUES ("K116_29","012_16_29","1KI","16","29","29","Yahudayne paççahee Asee paççahiyvalla haa'ane xhebts'ale molyud'esde (38) sen, Omriyna dix Axav İzrailyna paççah eyxhe. Mang'vee Samariya eyhene şaharee g'ayiq'ölle (22) senna paççahiyvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Omriyne dix Axavee, cule ögiyl vuxhaynbışde gırgıne paççahaaşile geeb Rəbbine ulesqa yugba qidyaalesda iş haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Nevatne dixene Yarovamne bınahbışee axuy k'ıldanan xhinne, ooğançe Sidonaaşine paççahna Etba'alına yiş İzevel hee'e. Qiyğale xhineeyid horbışikane allahıs Ba'alıs ı'bəədat ha'a giyğal. ");
INSERT INTO tkr_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Mang'vee Samariyel Ba'alın xav alya'a. Caayid q'urbanbı allya'an cigad ha'a. ");
INSERT INTO tkr_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Qiyğale xhineyib Aşerayn byut ha'a. Mang'vee Rəbbis İzrailyne Allahıs cule ögiyl vuxhayne gırgıne İzrailyne paççahaaşile geeb qəl huvu. ");
INSERT INTO tkr_vpl VALUES ("K116_34","012_16_34","1KI","16","34","34","Axavee paççahiyvalla haa'ane gahıl, Bet-Elyğançene Xielee Yerixo eyhena şahar sayib alyaa'ana. Rəbbee Nunne dixek'le Yeşuayk'le uvhuyn xhinneecad eyxhe: mang'vee şahar alyaa'a gibğılmee, mang'una xərna dix Aviram qek'a; şahar alyav'u akkabı gixhxhesınbı xhinne quvxhamee, mang'una k'ınna dix Seguv qek'a. ");
INSERT INTO tkr_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Gileadne Tişbeençene İlyasee paççah Axavık'le eyhen: – Zı ı'bəədat ha'ane İzrailyne Allahılqa Vorne Rəbbilqa k'ın ixhen, zı ittevhu ögiyle qööne senbışee çiyiy gyoğiy ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Rəbbin cuvab mang'ulqaniy vod: ");
INSERT INTO tkr_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","– İnençe hixu, şargne suralqa hoora. İordanne damayne şargılyne Kerit eyhene aragısne dyugulyxhe. ");
INSERT INTO tkr_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","Xhyan ğu mane arageençe ulyoğas, vasın oxhanasın karıd Zı qənaaşik'le alleva uvhu. ");
INSERT INTO tkr_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Mang'vee Rəbbee uvhuynçil k'ırı gyaqqı, İordanne damayne şargılyne Kerit eyhene aragısqa qarı ma'arır axvana. ");
INSERT INTO tkr_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","Qənaaşe miç'eed-exhal mang'us çuruyiy gıney adayle, xhyanıd mang'vee arageençeniy ulyoğan. ");
INSERT INTO tkr_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Sabara gahılee ölkee gyoğiybı gyudyoğava arag qooqqana. ");
INSERT INTO tkr_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Rəbbin cuvab İlyasılqaniy vod: ");
INSERT INTO tkr_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","– Oza qıxha Sidonne Sarfat eyhene şahareeqa hak'ne. Maayir axve. Maane sa sip'ıriyk'le Zı vasın otxhuniy alleva uvhu. ");
INSERT INTO tkr_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Mana oza qıxha Sarfateeqa ayk'an. Mana şaharne akkabışisqa qarı hixrxhılymee, mang'uk'le maa'ar osbı sa'ana sa sip'ıriy g'eece. Mang'vee məng'ı'lqa onu'u eyhen: – Hucoone ixhes, yiğne k'olee zas ulyoğasın sık'ınin xhyan alle. ");
INSERT INTO tkr_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Mana xhinelqava yı'qqəmee, mang'vee meed onu'u eyhen: – Hucoone ixhes, zas oxhanasın sa ghaledın gıneyıd alle. ");
INSERT INTO tkr_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Zəiyfee eyhen: – Rəbbilqa, yiğne Allahılqa k'ın ixhen, zaqa gıney deşin, şaqa kupune xhanel sa xhaxheedın urva vod, sa t'yank'ıb q'ışina. Zı həşde sık'ınin osbı sı'ı, ark'ın zasıniy dixesın otxhuniy ha'as. Mançile ğayrı şaqa oxhanasın karıd deşin, şinab hapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","İlyasee məng'ı'k'le eyhen: – Qimeeq'ən, xaaqa ark'ın ğu eyhen xhinne he'e. Saccu vaqa vodunçike ts'eppa zas sa k'ınna kokay hav'u able, qiyğad vasıniy dixesın oxhanasın kar he'e. ");
INSERT INTO tkr_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","İnəxüd Rəbbee, İzrailyne Allahee eyhe: «Zı, Rəbbee ç'iyeyne aq'valqa gyoğiy g'axilesde yiğılqamee kupeedın urvad, g'abeedın q'ışid g'att'as deş». ");
INSERT INTO tkr_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Zəiyfee ark'ın İlyasee uvhuyn xhinne ha'a. Məxüd məng'ı'qad, cene xizanıqad, İlyasıqad yiğısiysın otxhanan kar eyxhen. ");
INSERT INTO tkr_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Rəbbee İlyasık'le uvhuyn xhinne kupeedın urvad, g'abeedın q'ışid g'aat'a deş. ");
INSERT INTO tkr_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Sabara gah ılğevç'uyle qiyğa, xaana iyessiy yeexhene mane zəiyfayna dix ık'iyk'ar. Mang'un ık'ar atk'ıniylette yı'q' qexhe, nafas haxıles dəxı' mana qek'ana. ");
INSERT INTO tkr_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Zəiyfee İlyasık'le eyhen: – Allahna insan, zı vak hucoone hı'ı? Nya'a, ğu yizda dix gikasne, yizda bınah yik'el qavalya'asne arı? ");
INSERT INTO tkr_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","İlyasee məng'ı'k'le eyhen: – Yiğna dix zasqa qale. Uşax zəiyfayne xhılibışeençe alyaat'u, vuc axvane oone gozeeqa qıkkı, cune tyuleeqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Mang'vee Rəbbilqa onu'u eyhen: – Ya Rəbbim Allah, nya'a zı axvane zəiyfayna dix gik'u, Ğu məng'ı'k məxdın divan qaqqı? ");
INSERT INTO tkr_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Qiyğa mana uşaxıl oo xhebne yəqqees g'alirxhu Rəbbilqa ona'a: – Yizda Rəbb Allah, zı Vake heqqa, hasre mane uşaxın rı'h caneeqa sak'lecen! ");
INSERT INTO tkr_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Rəbbik'le İlyasee ona'a g'iyxhen, uşaxın rı'h caneeqa satk'ıl, mana üç'ür qexhe. ");
INSERT INTO tkr_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","İlyasee uşax oone cune gozeençe alyaat'u, avqa yedisqa qadı eyhen: – İleekende, yiğna dix üç'ürra vor. ");
INSERT INTO tkr_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Zəiyfee İlyasık'le eyhen: – Həşde ats'axhxhayn ğu hək'erar Allahna insan ıxhay, ğu uvhuyn Rəbbin cuvabıd qotkuyn ıxhay! ");
INSERT INTO tkr_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","Ooğançe xılece gahbı ılğeç'uyle qiyğa, g'uraxbı gyatk'uyne xhebıd'esde sen, Rəbbee İlyasık'le inəxdun cuvab eyhe: – İzrailyne paççahısqa, Axavısqa hak'ne, mang'uk'le ğu g'acecen. Manke Zınad ç'iyelqa gyoğiy g'axıles. ");
INSERT INTO tkr_vpl VALUES ("K118_2","012_18_2","1KI","18","2","2","İlyasır hayk'anna Axavık'le vuc g'acesde cigeeqa. Mane gahıl Samariyeyl it'umın mısvalybı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("K118_3","012_18_3","1KI","18","3","3","Axavee Avdiy qoyt'al. Mana imaaratee işbı bit'al ha'anbışda xərnaniy vor. (Avdee Rəbbin do axtıdaniy aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("K118_4","012_18_4","1KI","18","4","4","Axavne xhunaşşee, İzevelee Rəbbin peyğambarar gyapxı-gyabat'ane gahıl Avdee vəş peyğambar hixva'ana. Manbı quvku q'öne mağaree xhots'al-xhots'alyna dyugul haa'a. Oxhanasın karıd, ulyoğasın xhyanıd manbışis adayle ıxha.) ");
INSERT INTO tkr_vpl VALUES ("K118_5","012_18_5","1KI","18","5","5","Axavee Avdiyk'le eyhen: – Ölkeene gırgıne xhyan ı'lqəəne cigabışisqayiy damabışisqa hak'ne. Mançeğana şak'le sayıb ok' iveeke, yişin balkanar, g'atirer gyatt'as gidyadak'va. ");
INSERT INTO tkr_vpl VALUES ("K118_6","012_18_6","1KI","18","6","6","Manbışe co alycaxvasva eyhen cıgabı cone əree bit'al haa'a, nena nyaqayiy ı'qqəsva. Axav sa suralqa, Avdiyir manisa suralqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("K118_7","012_18_7","1KI","18","7","7","Avdiys yəqqə İlyas qızaxxa. Mang'uk'le İlyas qıvats'ı, aq'vakkena mang'une ögiyl gizerçu eyhen: – Yizda xərna İlyas, ina ğune? ");
INSERT INTO tkr_vpl VALUES ("K118_8","012_18_8","1KI","18","8","8","İlyasee eyhen: – Zı vorna. Hak'ne yiğne xərıng'uk'le eyhe, İlyas inyaa vor. ");
INSERT INTO tkr_vpl VALUES ("K118_9","012_18_9","1KI","18","9","9","Mang'vee eyhen: – Zı nena bınahne hav'u, ğu yiğna g'ul gik'as Axavne xıleqa qele? ");
INSERT INTO tkr_vpl VALUES ("K118_10","012_18_10","1KI","18","10","10","Yiğne Allahılqa Vorne Rəbbilqa k'ın ixhen, yizde xərıng'vee ğu t'abal ha'asva insan g'ıxdevuyn milletiy ölka axu deş. «Mana inyaa deşdava» uvhuyne milletınbışisqayiy ölkaynbışisqa mang'vee k'ın g'assaras alikkı, ğu maa'ar t'abal hı'ı ivdeykınava. ");
INSERT INTO tkr_vpl VALUES ("K118_11","012_18_11","1KI","18","11","11","Həşde ğu eyhen: «Hoora yiğne xərıng'uk'le İlyas inyaa vorva eyhe». ");
INSERT INTO tkr_vpl VALUES ("K118_12","012_18_12","1KI","18","12","12","Zı vasse ark'ınmee, sayir Rəbbine Rı'hı'n ğu zak'le dyats'anecar cigeeqa qıkkekka. Zınar hark'ın Axavık'le uvheene, mang'vee ğu t'abal ha'asda. Ğu ivdekımee, mang'vee zı gik'as. Avdiyee meed eyhen: – Yiğne g'ulee, zımee, k'ırranang'acadniy Rəbbin do axtıda aqqaqqan. ");
INSERT INTO tkr_vpl VALUES ("K118_13","012_18_13","1KI","18","13","13","Nya'a, İzevelee Rəbbin peyğambarar gyapxı-gyabat'amee, zı hı'iynbı vas, yizde xərıng'us, mebınbışe yuşan hı'ı dişdiy? Zı manke Rəbbina vəş peyğambar xhots'al-xhots'alyna mağarabışee dyugul hav'u, manbışis oxhanasın kariy xhyan huvu. ");
INSERT INTO tkr_vpl VALUES ("K118_14","012_18_14","1KI","18","14","14","Ğu həşde eyhen: «Hoora, yiğne xərıng'uk'le eyhe, İlyas inyaa vor». Nya'a, mang'vee zı gik'asda! ");
INSERT INTO tkr_vpl VALUES ("K118_15","012_18_15","1KI","18","15","15","İlyasee eyhen: – Zı ı'bəədat ha'ane Xəybışde Xərıng'ulqan Rəbbilqan k'ın ixhen, Axavık'le g'iyna zı g'acesda. ");
INSERT INTO tkr_vpl VALUES ("K118_16","012_18_16","1KI","18","16","16","Avdiy Axavısqa hark'ın mang'us gırgın yuşan ha'an. Man g'ayxhı, Axav hayk'anna İlyasne ögeeqa. ");
INSERT INTO tkr_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Axavısqa İlyas qızaxxımee, mang'vee eyhen: – Ğune vor İzrailyqa in yiğbı alli'ına? ");
INSERT INTO tkr_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","İlyasee eyhen: – Man zı deş, ğunayiy yiğne dekkıne nasılen İzraililqa mana ver ooxu. Şu Rəbbin əmrbı hidi'ı, Ba'alne byuttyaaşiqa qihna apk'ın. ");
INSERT INTO tkr_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Həşde yiğın insanar g'axuvle, gırgın İzrailybı zasqa Karmel eyhene suvalqa see'ecen. Cokasana sacigee İzevelin g'ık otxhanna yoq'ud vəşşe xhots'al (450) Ba'alna, yoq'ud vəşır (400) Aşerayn horbışikan peyğambar inyaqa qoot'le. ");
INSERT INTO tkr_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Axavee gırgın İzrailybıyiy man peyğambarar Karmelyne suvalqa saa'a. ");
INSERT INTO tkr_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","İlyas milletısqa qığeç'u eyhen: – Şu nimeena gahnane q'öbvalla haa'as? Rəbb vuşda Allahxhee, mang'uqab qihna hudoora! De'eş, şu Ba'alva eyheexhe, manke mang'uqab qihna hudoora! Milletın nıq' qığavhu deş. ");
INSERT INTO tkr_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Manke İlyasee milletık'le eyhen: – Rəbbine peyğambaraaşina saccu zı axu, Ba'alıqamee yoq'ud vəşşe xhots'al (450) peyğambar vor. ");
INSERT INTO tkr_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Həşde şasqa q'öble boğa able. Havaasre mane q'öne boğayna sa manbışe cos g'əvxü gyuvk'ecen. Qiyğab sansanna qav'u, çike ıxhayn sanbı osbışilqa gik'necen. Saccu mançik ts'a hılymaqqacen. Zınab manasa boğa gyuvk'u, sansanna qav'u çike ıxhayn sanbı osbışilqa gik'anas. Ts'ayıd halyaqqas deş. ");
INSERT INTO tkr_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Manke şu vuşde allahılqa on ha'as, zınad yizde Rəbbilqa. Şavaa on hı'iyng'ayiy ts'a g'axuvu, mang'una Allah hək'ena vor. Milletıncad «Ğu geed yugda uvhuva» alidghıniy qele. ");
INSERT INTO tkr_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","İlyasee Ba'alne peyğambaraaşik'le eyhen: – Şu xəppabı vuxhal-alla, ts'eppa şu şosda sa boğa g'əvxü gyuvk'e. Qiyğad vuşde allahılqa on he'e. Saccu şucad mançik ts'a qımaqqa. ");
INSERT INTO tkr_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Manbışe cos huvuna boğa qabı gyook'ana. Mançile qiyğad miç'eediyle yı'q'ı'hı'lqamee Ba'alılqa «Ba'al, şas alidghıniy qeleva!» on hı'ı. Alidghıniy qelenar, nıq' qığayhenar manbışis eyxhe deş. Manbımee cos hı'iyne q'urbanbı allya'ane cigaysne g'ook'al-ulyook'al vuxha. ");
INSERT INTO tkr_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Yı'q'ı'hı'l İlyasee manbı matsxar hav'u eyhen: – Sik'ıldad ç'ak'ın ts'irbı he'e! Nya'a, mana allah dişde vor! Sayır fıkrele ark'ın, vuk'ul alivku, g'eline yəqqı's hark'ın eyxhe! Şavuk'lene ats'a, nik'eeqacarme ark'ın, muğur qa'asme ıkkan? ");
INSERT INTO tkr_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Manbışe sık'ıldad it'umun ts'irbı ha'a, cone ədatbışis sik'ı g'ılıncbışika, vukbışika cok cigabı ha'a, eb ablyaa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Yı'q'ı'hı'le exhaliyna q'urban ablyaa'asmee, manbı g'ook'al-ulyook'al ts'irbı he'eeyid, manbışis alidghıniy qelenar, nıq' qığayhenar, manbışil k'ırı iliyxhenar eyxhe deş. ");
INSERT INTO tkr_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Manke İlyasee milletık'lecad eyhen: – Zasqana qeepxhe. Gırgın millet mang'usqa sadımee, mang'vee hı'ğətkıriyn Rəbbis q'urbanbı alyaa'an ciga qa'an. ");
INSERT INTO tkr_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","İlyasee Yaaq'ubne dixbışde nasılbışis sik'ı yits'ıq'öble (12) g'aye alyabat'a. (Rəbbeeyid mane Yaaq'ubık'le «yiğın do İzrail ixhesva» uvhu.) ");
INSERT INTO tkr_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Mane g'ayebışike İlyasee Rəbbisva q'urbanbı allya'an ciga alya'a. Mane q'urbanbı allya'ane cigayne hiqiy-allab yits'ıxhvalle (15) xhinnen litra aqqasdameena g'uyu ilyviyk'ar. ");
INSERT INTO tkr_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Mançile qiyğa mang'vee osbı giyk'an, boğa sansanna qav'u mançin çuru osbışilqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Qiyğa İlyasee eyhen: – Yoq'ulle xədın parç xhinen gyatsts'ı'ı gyooxhan haa'asde q'urbanılqayiy osbışilqa haç'e'e. Qiyğa mang'vee manbışik'le «Q'öd'esiy xhebıd'es məxüd he'eva» eyhe. Manbışed ha'an. ");
INSERT INTO tkr_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Maqa k'i'iyne xhinen q'urbanbı allya'ane cigayne hiqiy-alla alipk'ırna g'uyu ghalilqamee gyavts'aa'ana. ");
INSERT INTO tkr_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Yı'q'ı'hin kar otxhunne xhebne sə'ətıle, İlyas peyğambar ögiylqa qığeç'u eyhen: – Rəbb, Ğu İbrıhımee, I'saq'ee, İzrailee ı'bəədat hı'ına Allah vorna! Hasre g'iyna İzrailee Allah Ğuva, zınar Yiğna g'ulva, in gırgınıd zı Yiğne cuvabıka ha'ava ats'axhecen! ");
INSERT INTO tkr_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Ya Rəbb, hucoone ixhes, zas alidghıniy qele! Hasre ine xalq'ık'le Ğu Rəbb Allah ıxhay ats'axhecen! Manke, Ğu manbışin yik'bı Valqa sak'alas! ");
INSERT INTO tkr_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Man uvhu ç'əvxhameecad, Rəbbee ts'a g'ıxele, gyooxhan haa'ane q'urbanın çurud, osbıd, çik avudun g'ayebıd, nyaq'vub, hiqiy-alla alipk'ırne g'uyeedın xhyanıd mane ts'ayın höğən. ");
INSERT INTO tkr_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Milletik'le man gacu, aq'vakkena hı'ğətkır eyhen: – Rəbb saccu Allah vorna! Rəbb saccu Allah vorna! ");
INSERT INTO tkr_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","İlyasee manbışik'le eyhen: – Ba'alın peyğambarar avqe, manbışda sacar hixvas hımaysar. Manbışe manbı avqumee, İlyaseeyib Qişon eyhene aragısqa quvku gyabat'anbı. ");
INSERT INTO tkr_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","İlyasee Axavık'le eyhen: – İt'umne gyoğiyn sesıd qöö, mançil-alla hoora otxhun-ulyoğe. ");
INSERT INTO tkr_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Axav ayk'anna otxhun-ulyoğas. İlyasır Karmelyne suvayne q'omaqa ılqeç'e. Mana maa q'aratsabışilqa gyu'ur, vuk'ulyub g'elybışisqa giviyxhe. ");
INSERT INTO tkr_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Qiyğa cune nukarık'le eyhen: – Həşde hark'ın yugra deryahne suralqa ilekke. Nukar hark'ın ilyakkı eyhen: – Vuççud deşod. Məxür İlyasee mana yighne yəqqees ilyakkas g'ıxele. ");
INSERT INTO tkr_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Yighır'es hark'ınmee nukaree eyhen: – Haaşe deryaheençe xhaxheeqa ooharasda sa k'ınna buludıb ı'lqəə. İlyasee eyhen: – Hark'ın Axavık'le eyhe, gyooğeeqa gixhasse balkanık daşk'a qı'ı giç'ecen. Deşxheene, əlyhəəs əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Mane gahıl xəəqə k'arın buludbı sadayle, mıts qavayle, it'umın gyoğiy gyoğa giyğal. Axavır daşk'eeqa gyu'ur İzre'el eyhene şahareeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","İlyasıs Rəbbina guc qavayle, mang'vee cun p'laş yı'q'eeqa ayt'ıl Axavıle ögiyl İzre'eleeqa i'kkecesdemeene cigeeqa g'adayxhvanna. ");
INSERT INTO tkr_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Axavee İlyasee hı'iyn gırgın işbıd, Ba'alın peyğambarar g'ılıncıke alğav'u gyapt'ıyid cune xhunaşşeys İzevelis yuşan ha'an. ");
INSERT INTO tkr_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","İzevelee İlyasısqa ina xabar ana insan g'ıxele: – G'iyqa ine gahıs zı valqa ğu peyğambaraaşilqa ablyav'una ver idyooxeene, hasre allahaaşe mançileb pisda zalqa ver ooxecen. ");
INSERT INTO tkr_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","İlyasık'le man g'ayxhı qəyq'ənna. Mang'vee can g'attixhan ha'asva Yahudeene Beer-Şeveeqa hexva. Cuna nukar maa'ar g'alerçu, ");
INSERT INTO tkr_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","vuc sahreeqa ayk'an. Mang'vee sahree sa yiğna yəq apk'ıniyle qiyğa, sa xhırisne yivek avur gyu'ur cus qik'uy heqqa: – Ya Rəbb, ç'əv, həşde yizın can alişşe. Zı yizde dekkaaşile yugna deş vor. ");
INSERT INTO tkr_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Mana xhırisne yivene avur nik'eeqa ayk'an. Mane gahıl sayangada mang'uk sa malaaik set'u eyhen: – Oza qıxha, kar oxhne. ");
INSERT INTO tkr_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Mana oza qıxha hiqiy-alla ilyakkımee, g'ecen, cune vuk'lene k'ane ç'əra qav'una kokayiy sa parç xhinenıd. Mana kar otxhun, xhyan ulyodğu, meer nik'eeqa ayk'an. ");
INSERT INTO tkr_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Rəbbin malaaik q'öd'es maqa satk'ıl mang'uk set'u eyhen: – Ğu geeb xıliyna yəq əlyhəəs, mançil-alla oza qıxha kar oxhne. ");
INSERT INTO tkr_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Mana oza qıxha karıd oyxhanan, xhyanıd ulyoğan. Kar otxhun culqa qarıyle qiyğa, mang'vee yoq'ts'al yiğnayiy yoq'ts'al xəmna Allahne suvaysqa Xorevısqa yəq avayk'an. ");
INSERT INTO tkr_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Mana maqa hirxhılymee, sa mağareeqa ikkeç'u, xəm g'aaha. Rəbbee mang'uke «İlyas, nya'a ğu inyaa ıxhava?» qiyghan. ");
INSERT INTO tkr_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Mang'vee inəxdın alidghıniy qele: – İzrailybışe Rəbbilqa, gırgın əxəne Allahılqa yı'q'bı sak'al hı'ıva zasse öörxəs əxə deş. İzrailybışe Vaka hav'una mugaavile yik'el hivxan hav'u, Vas q'urban ablyaa'an cigabı hı'ğəkkar hı'ı, Yiğın peyğambarar g'ılıncıke alğav'u gyapt'ıynbı. Saccu sa zı axu, manbışe zınar gik'asva t'abal ha'a vor. ");
INSERT INTO tkr_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Rəbbee eyhen: – Qığeç'u suval Yizde ögiyl ulyozre. Zı mançe ılğeç'es. İlyasık'le Rəbb nəxür qarıy g'ecen. Ts'eppa suvabı qaxana, ganzbı hiyxhvərna it'umna mıts av'eeyib, Rəbb mane mıtsee deşdiy vor. Mançile qiyğa ç'iyebı ı'ğiykar giyğal, Rəbb mane ç'iyebı ı'ğiykıreeyir deşdiy vor. ");
INSERT INTO tkr_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Mançile qiyğa ts'a qadayle. Rəbb mane ts'ayeyır deşdaniy. Man gırgın kar atk'ıniyle qiyğa, sa k'ınin ses axva. ");
INSERT INTO tkr_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","İlyasık'le man ses g'ayxhımee, cun p'laş aq'valqa alyadaççe. Qiyğar ark'ın mağarayne ghalee ulyoyzar. Maa'ad mang'une k'ıriysqa ses qadayle: – İlyas, nya'a ğu inyaa ıxha? ");
INSERT INTO tkr_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","İlyasee eyhen: – İzrailybışe Rəbbilqa, gırgın əxəne Allahılqa yı'q'bı sak'al hı'ıva zasse öörxəs əxə deş. İzrailybışe Vaka hav'una mugaavile yik'el hivxan hav'u, Vas q'urban ablyaa'an cigabı hı'ğəkkar hı'ı, Yiğın peyğambararıb g'ılıncıke alğav'u gyapt'ıynbı. Saccu sa zı axu, manbışe zınar gik'asva t'abal ha'a vor. ");
INSERT INTO tkr_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Rəbbee mang'uk'le eyhen: – Ğu qarıyne yəqqı'n Damask'ne sahreeqa hoora. Maqa hirxhıling'a, Xazaelyne vuk'lelqa q'ış qadğu, mang'uke Aramna paççah he'e. ");
INSERT INTO tkr_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","Nimşiyne dixene Yehulyne vuk'lelqa q'ış qadğu, mang'uke İzrailyna paççah he'e. Avel-Mexola eyhene şahareençene Şafatne dixene Elişayne vuk'lelqa q'ış qadğu, mang'uke yiğne cigalqana peyğambar he'e. ");
INSERT INTO tkr_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Xazaelyne g'ılıncıke g'attirxhınna, Yehuee gik'as, Yehueyne g'ılıncıke g'attirxhınnar Elişee gik'as. ");
INSERT INTO tkr_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Zı İzrailee Ba'alne ögee k'idyorzulyna, mang'une byuttyaaşis ubba hidi'ına yighıd aazır insan havacı. ");
INSERT INTO tkr_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","İlyas mançe ark'ınmee, mang'uk'le Şafatna dix Elişa iveeke. Elişee g'ayi yoq'ab (24) yats q'öble-q'öblena avt'ul ciga eza eyxhe. Vucur nekke yı'q'əlinçiqar qihna qöö eyxhe. İlyas Elişayne k'anençe ı'lğəəmee, cun p'laş mang'ulqa alyadaççe. ");
INSERT INTO tkr_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Elişee yatsbı maa g'ali'ı İlyasıqar qihna g'adarxhun eyhen: – Hucoone ixhes, hasre zı hark'ın ts'etta dekkısiy yedis ubbabı ha'as, mançile qiyğa zı vaqa qihna qales. İlyasee eyhen: – Hak'ne. Zı ğu aqqaqqa deş. ");
INSERT INTO tkr_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Mançe Elişa yı'q'əlqa sak'ı q'öble cuna yats gyook'a. Cune kyotanısıd mang'vee ts'a ı'xı', çil yatsbışin çuru qotxhur insanaaşis bit'al ha'a. İnsanaaşed man oyxhanan. Mançile qiyğa mana ayk'anna İlyasıqar qihna. Elişayke İlyasıs g'ulluxçiy eyxhe. ");
INSERT INTO tkr_vpl VALUES ("K121_1","012_21_1","1KI","21","1","1","Sabara gah ılğevç'uyle qiyğa in karbı eyxhe. İzre'elee, Samariyeyne paççahne Axavne sarayne k'ane İzre'elyğançene Navotuqa t'ımıllığniy vod. ");
INSERT INTO tkr_vpl VALUES ("K121_2","012_21_2","1KI","21","2","2","Axavee Navotuk'le eyhen: – Yiğın t'ımıllığ zas hele, zı maa dirıg ezas, yizde xaas k'ane vod. Ikkanxhee zı vas mançine cigee sık'ıldad yugun t'ımılen bağ qeles, de'eş, ciga ıkkan deşva eyhexhe, nimeeniy ha'a pıl qeles. ");
INSERT INTO tkr_vpl VALUES ("K121_3","012_21_3","1KI","21","3","3","Navotee Axavık'le eyhen: – Rəbbee əq'əna qe'ecen, sa manniy axu, dekkaaşin cigabı vas heles! ");
INSERT INTO tkr_vpl VALUES ("K121_4","012_21_4","1KI","21","4","4","İzre'elyğançene Navotee «Dekkaaşile axuyn cigabı vas heles deş» uvhuva, Axav xaaqa aq'va havaxan hı'ı, eb k'aarı quvxha siyk'al. Mana xaaqa qarı cune tyuleeqa k'iç'u aq'vad sak'al hı'ı g'ılexhana, karıd oyxhan deş. ");
INSERT INTO tkr_vpl VALUES ("K121_5","012_21_5","1KI","21","5","5","Cuna xhunaşşe İzevel mang'usqa qarı eyhen: – Nya'a yiğna eb k'aarı quvxha? Nya'a kar idyotxhan? ");
INSERT INTO tkr_vpl VALUES ("K121_6","012_21_6","1KI","21","6","6","Mang'vee eyhen: – Zı İzre'elyğançene Navotuke «Mang'un t'ımıllığ zas heqqı. Ikkanxhee zı vas mançine cigee pıl qeles, de'eş, ğu pıl ıkkan deşva eyhexhee, mançine cigee zı vas sık'ıldad yugun t'ımılen bağ qelesva» uvhu. Mang'vee «Vas zı yizın t'ımılen bağ heles deşva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("K121_7","012_21_7","1KI","21","7","7","Axavne xhunaşşee İzevelee mang'uk'le eyhen: – İzrailyna paççah ğune, dişde? Yik'eeqa ıkmekka, oza qıxha kar oxhne. İzre'elyğançene Navotun t'ımıllığ zı vas helesın. ");
INSERT INTO tkr_vpl VALUES ("K121_8","012_21_8","1KI","21","8","8","Məng'ee Axavne doyule sa kar otk'un mançilqa Axavın peçatıd gyı'xı', Navotne şahareene ağsaqqalaaşisqayiy qıvaats'ıyne insanaaşisqa yəqqı'l ha'a. ");
INSERT INTO tkr_vpl VALUES ("K121_9","012_21_9","1KI","21","9","9","İzevelee inəxüd oyk'an: «Siv aqqeva ses aççe, Navotur milletne yı'q'nee nekke q'oma g'ee'e. ");
INSERT INTO tkr_vpl VALUES ("K121_10","012_21_10","1KI","21","10","10","Q'öyre karaı'dəəna insan mang'une ögiyl ge'e, hasre manbışe horbışika mang'une aq'val aqqecen: „Nya'a ğu Allahık'leyiy paççahık'le cuvabbı uvhu?“ Qiyğar g'aqa qığavhu gik'asva g'ayeqqa hele.» ");
INSERT INTO tkr_vpl VALUES ("K121_11","012_21_11","1KI","21","11","11","Navotne şahareene qıvaats'ıyne insanaaşeyiy ağsaqqalaaşee, gırgın İzevelee otk'unin xhinne ha'a. ");
INSERT INTO tkr_vpl VALUES ("K121_12","012_21_12","1KI","21","12","12","Manbışe siv aqqeva ses aççu, Navot milletne yı'q'nee nekke q'oma gya'a. ");
INSERT INTO tkr_vpl VALUES ("K121_13","012_21_13","1KI","21","13","13","Q'öyre karaı'dəəna insan abı mang'une ögiyl giviy'ar. Manbışe milletne ögiyl «Navotee Allahık'leyiy paççahık'le cuvabbı uvhuva» gardanaqa giyxhe. Mançile qiyğa mana şahareençe qığavhu, g'ayeqqa hele. Məxür manbışe mana gek'ana. ");
INSERT INTO tkr_vpl VALUES ("K121_14","012_21_14","1KI","21","14","14","Mançile qiyğa manbışe İzevelis xabar g'uxoole: – Navot g'ayeqqa huvu gyuk'una. ");
INSERT INTO tkr_vpl VALUES ("K121_15","012_21_15","1KI","21","15","15","İzevelik'le Navot g'ayeqqa huvu gyuk'uva g'ayxhikkum, məng'ee Axavık'le eyhen: – Hoora hak'ne İzre'elyğançene Navotus vas pılıke heles dekkanan t'ımıllığ həşde aleet'e. Navot deşda, mana qik'una. ");
INSERT INTO tkr_vpl VALUES ("K121_16","012_21_16","1KI","21","16","16","Axavık'le İzre'elyğançena Navot qik'uva g'ayxhımee, mana oza qıxha, şeng'un t'ımıllığ cus alyaat'asva ayk'an. ");
INSERT INTO tkr_vpl VALUES ("K121_17","012_21_17","1KI","21","17","17","Rəbbee Tişbeençene İlyasık'le inəxdun cuvab eyhe: ");
INSERT INTO tkr_vpl VALUES ("K121_18","012_21_18","1KI","21","18","18","– Samariyel İzrailis paççahiyvalla haa'ane Axavısqa hak'ne. Mana Navotne t'ımılyne bağee ixhes. Man cune doyulqa qa'asva mana maqa arı. ");
INSERT INTO tkr_vpl VALUES ("K121_19","012_21_19","1KI","21","19","19","Ğu Rəbbin in cuvab mang'ulqa hixhar he'e: «Ğu insan gik'u, həşded mang'un cigane aqqaqqa?!» Mang'ulqa Rəbbin in cuvabıd hixhar he'e: «Navotne ebas xvaabışe miz üvxiyne cigee vudee, yiğne ebasıb xvaabışe miz üvxəsda». ");
INSERT INTO tkr_vpl VALUES ("K121_20","012_21_20","1KI","21","20","20","Axavee İlyasık'le eyhen: – Yizda duşman, vak'le zınar aveykınane! İlyasee eyhen: – Ho'o, aveykına. Ğu Rəbbine ögiyl nyaayid deşin karbı hı'inçil-alla, ");
INSERT INTO tkr_vpl VALUES ("K121_21","012_21_21","1KI","21","21","21","Rəbbee inəxüd eyhe: «Zı valqa ver ablyaa'as. Zı vake g'abıynbı gyapt'asınbı, Axavne insanaaşike adamer g'alya'as deş, k'ıning'ule xərıng'ulqamee gyapt'asınbı. ");
INSERT INTO tkr_vpl VALUES ("K121_22","012_21_22","1KI","21","22","22","Zı yiğın xav Nevatne dixen Yarovamın, Axiyayne dix Ba'aşayn xav xhinne qa'as. Zı mana ver valqa ooxasda, ğu Zas qəlasın hı'ı, İzrailyne milletısqa bınah haa'as alivkuva». ");
INSERT INTO tkr_vpl VALUES ("K121_23","012_21_23","1KI","21","23","23","Rəbbee İzevelyne hək'eeyid eyhen: «İzre'elyne cabırısne İzevelir xvaabışe eexhvanas». ");
INSERT INTO tkr_vpl VALUES ("K121_24","012_21_24","1KI","21","24","24","Axavne xizanna şaharee q'ik'vene xvaabışe, çolee qik'vener şit'yaaşe ulyodu oxhanas. ");
INSERT INTO tkr_vpl VALUES ("K121_25","012_21_25","1KI","21","25","25","Axavee xhunaşşeyne cuvabıka bınah haa'a vuxha. Rəbbis məxüb qəl hoolena, Axavık akarna, merna sacar ıxha deş. ");
INSERT INTO tkr_vpl VALUES ("K121_26","012_21_26","1KI","21","26","26","Axaveeyid Emorbışe xhinne byuttyaaşis ı'bəədat ha'a ıxha. Man Emorbıb Rəbbee İzrailybışis cigabı helesva mançe g'ee'ebaşşe. Axaveeyid geed karaı'dəən işbı ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("K121_27","012_21_27","1KI","21","27","27","Axavık'le İlyasse eyhenbı g'ayxhımee, mang'vee cune tanalinbı qıt'axxı palanbı alya'a. Mang'vee siv aqqaqqa, palanbışil g'ılexha, aq'va havaxan hı'ı iykar. ");
INSERT INTO tkr_vpl VALUES ("K121_28","012_21_28","1KI","21","28","28","Rəbbee Tişbeençene İlyasık'le inəxdun cuvab eyhe: ");
INSERT INTO tkr_vpl VALUES ("K121_29","012_21_29","1KI","21","29","29","– G'acuynne vak'le Axav Yizde ögiyl nəxür harq'ulyna? Mana Yizde ögiyl harq'ulyva, Zı mana ver mang'une gahıl ooxas deş, dixene zamaanayl manbışde xaane gırgıng'ulqa ooxas. ");
INSERT INTO tkr_vpl VALUES ("K122_51","012_22_51","1KI","22","51","51","Yahudayne paççahee Yehoşafatee paççahiyvalla ha'ane yits'ıyighad'esde (17) sen Axavna dix Axazya Samariyel İzrailyna paççah ıxha. Mang'vee Samariyel q'ölle senna paççahiyvalla haa'a. ");
INSERT INTO tkr_vpl VALUES ("K122_52","012_22_52","1KI","22","52","52","Axazyee Rəbbine ögiyl karaı'dəən işbı ha'a ıxha. Mana dek Axavne, yed İzevelyne, Nevatne dix Yarovamne yəqqı'n əlyhəə ıxha. İne Yarovameeyib İzrailyne milletısqa bınah haa'as ulyookka vuxha. ");
INSERT INTO tkr_vpl VALUES ("K122_53","012_22_53","1KI","22","53","53","Axazya dek xhinne Ba'alıs kyoyzarva, mang'us ı'bəədat ha'ava, Rəbb, İzrailyna Allah mang'ulqa qəllamişexhena.");
INSERT INTO tkr_vpl VALUES ("K21_1","013_1_1","2KI","1","1","1","İzrailyna paççah Axav qik'uyle qiyğa, Moaveedın millet İzraililqa g'elil qexhe. ");
INSERT INTO tkr_vpl VALUES ("K21_2","013_1_2","2KI","1","2","2","Axazyamee Samariyeyne şahareene cune xaane, oone gozene yivabınane g'uleençe g'a'arxhu ık'iyk'arna. Mang'vee cun insanar «Havak'ne Eqronne şaharne allahıke Ba'al-Zevuvuke qidghın he'e, yizın in ık'ar yug qixheseeva?» ats'axhxhes g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("K21_3","013_1_3","2KI","1","3","3","Rəbbine malaaikee Tişbeeğançene İlyasık'le eyhen: – Oza qıxha Samariyeyne paççahne insanaaşine ögiylqa hark'ın manbışik'le eyhe: «Nya'a, İzraililqa Allahne deş, şu Eqronne allahıke Ba'al-Zevuvuke qiyghanasıb vüqqə? ");
INSERT INTO tkr_vpl VALUES ("K21_4","013_1_4","2KI","1","4","4","Mançil-allad Rəbbee ilekkende Axazyayk'le hucoovayiy eyhe: „Ğu g'alirxhuyne tyuleençe vasse suğots'as əxəs deş. Ğu qik'asda, nəxürcar axvas deş!“» Man g'ayxhı, İlyas ayk'anna. ");
INSERT INTO tkr_vpl VALUES ("K21_5","013_1_5","2KI","1","5","5","Paççahın insanarıb paççahısqa siviyk'al. Paççahee manbışike qiyghanan: – Nya'a yı'q'əlqa sapk'ıl? ");
INSERT INTO tkr_vpl VALUES ("K21_6","013_1_6","2KI","1","6","6","Manbışe eyhen: – Sa insan yişde ögiylqa arı uvhuyn: «Şu g'axuvuyne paççahısqa sapk'ıl eyhe, Rəbbee inva vod eyhe: „Nya'a, İzrailiqa Allahne deş, şu Eqronne allahıke Ba'al-Zevuvuke qiyghanas insanaarıb g'uxoole? Mançil-allar vasse, ğu g'alirxhuyne tyuleençe suğots'as əxəs deş. Ğu qik'asda, nəxürcar axvas deş!“» ");
INSERT INTO tkr_vpl VALUES ("K21_7","013_1_7","2KI","1","7","7","Paççahee manbışike qiyghanan: – Vuşde ögiylqa arına, şok'le manva uvhuna insan nəxürnayiy? ");
INSERT INTO tkr_vpl VALUES ("K21_8","013_1_8","2KI","1","8","8","Manbışe eyhen: – Mang'vee xıliyna xhanan q'arq'vuy ali'ı, yı'q'eeqab g'ekvaykenacab ts'irayiy avt'ul. Paççahee eyhen: – Mana Tişbeeğançena İlyas ixhes! ");
INSERT INTO tkr_vpl VALUES ("K21_9","013_1_9","2KI","1","9","9","Paççahee k'omandirıka xhots'al (50) insannana g'oşun İlyasısqa g'uxoole. Tepayne q'oma gyu'urne İlyasısqa k'omandir ılqeç'u eyhen: – Allahna insan, paççahee vak'le «Avqa giç'eva» vod eyhe! ");
INSERT INTO tkr_vpl VALUES ("K21_10","013_1_10","2KI","1","10","10","İlyasee mang'uk'le eyhen: – Zı Allahna insanxhee, hasre xəənçe ts'a gyoğu vakıniy yiğne insanaaşikın he'ecen! Mane gahıl xəənçe ts'a qadı k'omandirıkınıd, cune g'oşuneene xhots'alyne insanıkınıd ha'an. ");
INSERT INTO tkr_vpl VALUES ("K21_11","013_1_11","2KI","1","11","11","Paççahee mang'usqa sa merna k'omandir xhots'alyne insanıka g'ıxele. K'omandiree İlyasık'le eyhen: – Allahna insan, paççahee inva vod eyhe: «Zaara avqa giç'e!» ");
INSERT INTO tkr_vpl VALUES ("K21_12","013_1_12","2KI","1","12","12","İlyasee mang'us inəxdun alidghıniy qele: – Zı Allahna insanxhee, hasre xəənçe ts'a gyoğu vakıniy yiğne insanaaşikın he'ecen! Mane gahıl xəənçe Allahın ts'a qadı k'omandirıkınıd, cune g'oşuneene xhots'alyne insanıkınıd ha'an. ");
INSERT INTO tkr_vpl VALUES ("K21_13","013_1_13","2KI","1","13","13","Xhebır'es paççahee mang'usqa sa merna k'omandir xhots'alyne insanıka g'ıxele. Mana k'omandir İlyasısqa ılqeç'u, gugaybışil gyu'ur mang'us miz k'yav'u eyhen: – Hucoone ixhes, Allahna insan, zınayiy yiğna xhots'alyna nukar qiviykne. ");
INSERT INTO tkr_vpl VALUES ("K21_14","013_1_14","2KI","1","14","14","Xəənçe ts'a qadı zale ögee abıyne q'öne k'omandirıkınıd cone xhots'alyne insanıkınıd hı'iyn. Həşde, hucoone ixhes, zı qiykne! ");
INSERT INTO tkr_vpl VALUES ("K21_15","013_1_15","2KI","1","15","15","Rəbbine malaaikee İlyasık'le eyhen: – Mang'uka avqa giç'e, mang'ule qı'məyq'ən. Man g'ayxhı, İlyas oza qıxha k'omandirıka avqa paççahısqa geç'e. ");
INSERT INTO tkr_vpl VALUES ("K21_16","013_1_16","2KI","1","16","16","İlyasee paççahık'le eyhen: – Rəbbee inva vod eyhe: «Nya'a, İzrailiqa qiyghanasda Allahne deş? Ğu insanar Eqronne allahıke Ba'al-Zevuvuke qiyghanas g'axuvu! Mançil-allar vasse, ğu g'alirxhuyne tyuleençe suğots'as əxəs deş. Ğu qik'asda, nəxürcar axvas deş!» ");
INSERT INTO tkr_vpl VALUES ("K21_17","013_1_17","2KI","1","17","17","İlyasee uvhuyn xhinne, Rəbbine cuvabıqa Axazya qek'ana. Axazyayqa dix deşva, mang'une cigeena paççah mang'una çoc Yehoram eyxhe. İn eyxhen Yahudayne paççahne Yehoşafatne dixee Yoramee paççahiyvalla haa'ane q'öd'esde sen. ");
INSERT INTO tkr_vpl VALUES ("K21_18","013_1_18","2KI","1","18","18","Axazyee hı'iyn medın işbıd, İzrailyne paççahaaşine hək'ee ot'kunne kitabee vod. ");
INSERT INTO tkr_vpl VALUES ("K22_1","013_2_1","2KI","2","1","1","Rəbbee İlyas xəəqə it'umne mıtsıka ts'ıts'a'assecar, İlyasiy Elişa Gilgal eyhene cigeençe avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("K22_2","013_2_2","2KI","2","2","2","İlyasee Elişayk'le eyhen: – Hucoone ixhes, ğu inyaa axve. Rəbbee zı Bet-Elyqa vor g'ıxele. Elişee eyhen: – Vorne Rəbbilqayiy yiğne canılqan k'ın ixhen, zı vake xıl ts'ıts'a'as deş. Məxüd ıxha, manbı sacigee avayk'ananbı Bet-Elyqa. ");
INSERT INTO tkr_vpl VALUES ("K22_3","013_2_3","2KI","2","3","3","Bet-Elyğançene peyğambaraaşin telebabı Elişaysqa abı eyhen: – Vak'le ats'anne, Rəbbee g'iyna yiğna xərna yiğne vuk'lel ooğançe alyart'as ıxhay? Mang'vee eyhen: – Ho'o, ats'an, geed immeyhe. ");
INSERT INTO tkr_vpl VALUES ("K22_4","013_2_4","2KI","2","4","4","İlyasee mang'uk'le eyhen: – Elişa, hucoone ixhes, ğu inyaa axve, Rəbbee zı Yerixo eyhene şahareeqa vor g'ıxele. Elişee eyhen: – Vorne Rəbbilqayiy yiğne canılqan k'ın ixhen, zı vake xıl ts'ıts'aa'as deş. Məxüd ıxha, manbı sacigee Yerixooqa avayk'an. ");
INSERT INTO tkr_vpl VALUES ("K22_5","013_2_5","2KI","2","5","5","Yerixoonçene peyğambaraaşin telebabı Elişaysqa abı eyhen: – Vak'le ats'anne, Rəbbee g'iyna yiğna xərna yiğne vuk'lel ooğançe alyart'as ıxhay? Mang'vee eyhen: – Ho'o, ats'an, geed immeyhe. ");
INSERT INTO tkr_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","İlyasee mang'uk'le eyhen: – Hucoone ixhes, ğu inyaa axve, Rəbbee zı İordanne damaysqa vor g'ıxele. Elişee eyhen: – Vorne Rəbbilqayiy yiğne canılqan k'ın ixhen, zı vake xıl ts'ıts'aa'as deş. Məxüd ıxha, manbı sacigee avayk'an. ");
INSERT INTO tkr_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","Peyğambaraaşine telebabışikena xhots'al (50) insan apk'ın əq'əna manbışde ögiyl ulyoozar. İlyasiy Elişar apk'ın İordanne damayne k'ane ulyoozar. ");
INSERT INTO tkr_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","İlyasee culyun p'laş g'ayşu, hitk'ır xhinele k'ena ı'xiyxə. Xhyan q'öne cigeeqa qexhe. Manbı xhyan ts'ıts'axhxhayne, qeqqvuyne cigayle k'ena ılğeebaç'e. ");
INSERT INTO tkr_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Manbı ılğepç'iyle qiyğa, İlyasee Elişayk'le eyhen: – Zı vasse alyart'asse eyhe, zı hucoone yiğneme ha'as? Elişee eyhen: – Hasre yiğne rı'hı'na guc q'öb hamanimee quvxha zalqa qabı, zake, vale qiyğiyne peyğambaraaşina xərna he'ecen. ");
INSERT INTO tkr_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","İlyasee eyhen: – Ğu dağamın kar heqqı. Vak'le zı, yiğne k'anençe alyarat'a g'acveene, ğu eyhəxüd ixhes; de'eş, vak'le man g'idecveene, ğu eyhəxüd ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Manbı yuşan haa'a əlyhəəng'ə, sayid manbışik'le ts'ayıken balkanariy daşk'a g'ece. Mançin manbı sana-sang'uke curav'u, İlyas it'umne mıtsıka xəəqə ts'ıts'a'a. ");
INSERT INTO tkr_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Elişayk'le man g'acu ts'ir haa'a: – Yizda dek, ay dek! Ğu İzrailynemee balkanarnaneyiy daşk'abınane g'oşunule xəbna guc vuxha! İlyas g'idece girğılymee, mang'vee culyun tanalinbı qıt'axxı ha'a. ");
INSERT INTO tkr_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Qiyğa mang'vee, İlyasıle g'a'aytxhuyn p'laş alyaat'u, İordanne damaysqa yı'q'əlqa sak'ı, mançine mıglek ulyoyzarna. ");
INSERT INTO tkr_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Mang'vee p'laş xhinele k'ena ı'xı' eyhen: – İlyasna Allah nyaane vor? Rəbb nyaane vor? Mang'veeyid p'laş xhinele k'ena ı'xı'mee, xhyan q'öna qexhe. Elişar damayne xhyan ts'ıts'xhayne cigayle k'ena ılğeç'e. ");
INSERT INTO tkr_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Yerixoonçene peyğambaraaşine telebabışik'le mana əq'ənançe g'acu eyhen: – İlyasne rı'hı'na guc Elişaalqa ılğevç'u. Manbı Elişanne ögiylqa abı, ç'iyelqamee k'yoozaranbı. ");
INSERT INTO tkr_vpl VALUES ("K22_16","013_2_16","2KI","2","16","16","Manbışe eyhen: – Şi yiğın g'ular. Şaqar xhots'al (50) gucnana cehil vor. Hasre manbışe hapk'ın yiğna xərna t'abal he'ecen. Sayir Rəbbine Rı'hı'n mana alyart'u suvalyme, qadalilyme dağerçu eyxhe? Elişee manbışik'le insanar «Gıxmoleva» eyhe. ");
INSERT INTO tkr_vpl VALUES ("K22_17","013_2_17","2KI","2","17","17","Manbışe xıl ts'ıts'dyaa'amee, Elişayscad naş qıxha, eyhen: – G'axuvle. Manbışe mana t'abal ha'as xhots'al insan g'ıxele. Mane insanaaşe mana xhebne yiğna t'abal he'eyir, iveeke deş.");
INSERT INTO tkr_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Pisınbışde mı'sləhətıka yəq idyaak'anna, bınahnanbışika gyu'ur oza qidexhena, matsxar haa'anbışika gidiy'arna insan nimeecar baxtivariy! ");
INSERT INTO tkr_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Mang'uname şadvalla saccu Rəbbine Q'aanunee vobna. Xəmbına-yiğbına mang'vee mana qəbəqqə, mançina haa'a. ");
INSERT INTO tkr_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Mana xhyanbışde mıglek oozuna, şagav çine gahıl helena, çin t'eled hı'ç'diyğənna yiv xhinnee ixhes. Mang'vee ha'ane gırgıne karee barakat vuxhes. ");
INSERT INTO tkr_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Pisın insanarmee məxbınbı deş vob, manbı mıtsın alixa'an balybiy xhinnee vooxhe. ");
INSERT INTO tkr_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Mançil-allab pisınbışisse məhkamee, bınahnanbışisseb qopkuyn insanarnane maclisee ulyoozaras vəəxəs deş. ");
INSERT INTO tkr_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Nya'a, Rəbbee qopkuynbışda yəq dişde havaace?! Pisınbışde yəqqı'nıb manbı gyapt'as hoot'al. ");
INSERT INTO tkr_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Nişil-allane milletbı g'elil qeedaxhe? Nişil-allane manbışe cosse dəxəsde karbışda haa'a? ");
INSERT INTO tkr_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Ç'iyene aq'valin paççahar, vuk'lek vukkekkanbı, Rəbbilqayiy Mang'vee g'əyxı'ng'ulqa, paççahılqa, g'elil qeebaxhe. ");
INSERT INTO tkr_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Manbışe eyhen: «Qudoora, Manbışda xamut qakkyaahas, şalin Manbışin zincirbı qoda'as!» ");
INSERT INTO tkr_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Xəybışee taxtıl Gyu'uriyng'vee əqəna ha'as, Xudaavandee manbı matsxara haa'as. ");
INSERT INTO tkr_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Qiyğa Mang'vee qəlın eyhesın. Manbıb Mang'une it'umne qəlıle qəvəəq'ənasınbı. ");
INSERT INTO tkr_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Mang'vee eyhen: «Zı Yizda paççah muq'addasne suval Sionul gi'ı». ");
INSERT INTO tkr_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Paççahee eyhen: Rəbbee uvhuyn zı şolqa hixhar ha'asın. Rəbbee zak'le uvhuyn: «Ğu Yizda dix vor, Zake g'iyna Vas dek ıxha. ");
INSERT INTO tkr_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Zake heqqe, Zı vas gırgıne gahbışis milletbıyiy ç'iyeyn aq'va ç'əvxhesmeen gırgın cigabı Vas heles. ");
INSERT INTO tkr_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ğu manbışikın yivayne əsaaka ha'as, G'ı'bı'ne nyuq'vneke hı'iyn g'ab xhinnee xüvə-xüvəna qaa'as». ");
INSERT INTO tkr_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Həşdiyle, paççahar, ək'elika vuxhe! Ç'iyene aq'valin haakimar, dars aleet'e! ");
INSERT INTO tkr_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Rəbbile qəpq'ı'n Mang'us g'ullux hee'e! Qəvəq'neb, şadeepxheb. ");
INSERT INTO tkr_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Allahne dixes, paççahıs, qəl mooxhecenva hı'rmat givxhe. Deşxheene, mang'una qəl zarabacab ts'ayılqa sapk'ıl, şokunud şu avquyne yəqqə ixhesın. Mang'ulqa yı'q' qizzıriynbı nimee baxtivarbayiy! ");
INSERT INTO tkr_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Maq'amne xərıng'us. Molyne simnane instrumentıkana Davudna mə'niy. ");
INSERT INTO tkr_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Rəbb, qəl vuxha zas cazaa humoole, qəlın qoyxharmee, zake qəl qığmaaha. ");
INSERT INTO tkr_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Rəbb, zas rəhı'm hee'e, Zaqa taq'at axu deş. Rəbb, zı yug qe'e, uts'uruke bark'vbışeeqa zeze aypxhı. ");
INSERT INTO tkr_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Caneeqa it'umna zeze aypxhı. Rəbb, man mısılqameene ts'ıts'xhes? ");
INSERT INTO tkr_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Rəbb, qora zas kumag he'e, Yiğne ç'əvcab dyooxhene yugvalika zı g'attixhan he'e! ");
INSERT INTO tkr_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Qik'u ark'ınne insanee Ğu deş yik'el qalya'as. Şavaane qik'uyne cigeençe Vas şukur haa'as? ");
INSERT INTO tkr_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Zı yizdecar hülöörxüyke orzulyna, yiğıscad xəmde geşşuyke zı g'ılexhan ciga çüvəda eyxhe, ulene nağıke yizın tyulyu çüvə qexhe. ");
INSERT INTO tkr_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Uts'uruke yizın uleppı qeqqu. Duşmanaaşe zı geşşes ilekkançil-alla yizın uleppı ozzur. ");
INSERT INTO tkr_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Rəbbik'le zı geşşe g'ayxhiyn! Pisın işbı g'ecenbı, zake əq'əna qeepxhe! ");
INSERT INTO tkr_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Rəbbik'le, zı rəhı'm hee'eva eyhen, g'ayxhiyn, Rəbbee yizda düə q'abıl hav'una! ");
INSERT INTO tkr_vpl VALUES ("PS6_11","020_6_11","PSA","6","11","11","Yizın gırgın duşmanar k'ap'ik'ıle avqa qeepxhes, Manbı qəpq'ı'n, manbışde caneeqa it'umna zeze avxhas, Matsxareepxha, manbı zaraba heepxasınbı. ");
INSERT INTO tkr_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","2","Maq'amne xərıng'us. Davudna Gittitne instrumentıkana mə'niy. Ay Xudaavanda, yişda Rəbb, nimee axtıdayiy Yiğın do ç'iyene aq'val! Yiğna xəbvalla xəybışileb axtıba vob. ");
INSERT INTO tkr_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Gyooqanbışded, uşaxaaşineb gyaaşuyle ğana Ğu guc haagvas, qəl qığaahane duşmanee nıq' aqqecenva. ");
INSERT INTO tkr_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Yiğne xıleppışde işiqa: xəybışiqa, Ğu gyuvxhuyne vuzaqa, Ğu gitk'ınne xənebışiqa, ilyakkamee, ");
INSERT INTO tkr_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Zı eyhen: «İnsan vuşune vor, Ğu mana yik'el aqqı? İnsanıke g'abiynbı hucoo eyxhen karne, Ğu manbışda haa'a?» ");
INSERT INTO tkr_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ğu insan malaaikıle sık'ırra avqana hı'ı. İnsan axtı qı'ı, tac xhineyid şöhrat huvu, ");
INSERT INTO tkr_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","9","İt'xhınne karalqa mana paççah gixhxhı. İn gırgın: çavra-vəq'ə, çolun həyvanar, Xəədın şit'yar, deryahbışeedın baluğar, Deryahbışeedın gırgıncad, Ğu mang'une g'elybışiqqa huvu. ");
INSERT INTO tkr_vpl VALUES ("PS8_10","020_8_10","PSA","8","10","10","Ay Xudaavanda, yişda Rəbb, nimee axtıdayiy Yiğın do ç'iyene aq'val! ");
INSERT INTO tkr_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Davudna düə Allah, zı havace, Zı dyugulexhen ciga Vasnee vod. ");
INSERT INTO tkr_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Zı Rəbbik'le uvhuyn: «Yizda Xudaavanda Ğu vorna. Vale ğayrı zaqa xoşbaxtıyvalla deşda». ");
INSERT INTO tkr_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Ç'iyene aq'valin Rəbbina yəq avquyn insanar nimeecab yugunbıyiy! Saccu manbışe zı şad ha'a! ");
INSERT INTO tkr_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Menne allahaaşiqab qihna əlyhəənbışde hasre vuk'lelqa geed yiğbı allecen. Zı mane allahaaşinemee q'urbanna eb k'yaa'as deş, Manbışin dobı ghalyaqa alyaat'as deş. ");
INSERT INTO tkr_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Rəbb, zas ıkkanna saccu Ğu vorna, Yizda ı'mı'r nəxübiy ı'lğəə Vake vod. ");
INSERT INTO tkr_vpl VALUES ("PS15_6","020_15_6","PSA","15","6","6","İnekke yugun cigabı Ğu zas huvu, Hək'ebab, zalqa gipxhına pay uftanna vuxha! ");
INSERT INTO tkr_vpl VALUES ("PS15_7","020_15_7","PSA","15","7","7","Zas yəq haagvana Rəbb zı axtı qa'as, Xəmdeb zı fıkır ooxhan, nəxübna Ğu eyhəxüb ı'mı'r haa'as. ");
INSERT INTO tkr_vpl VALUES ("PS15_8","020_15_8","PSA","15","8","8","Rəbb yizde k'ane ıxhay, zı mısacad yik'el hixan ha'a deş, Zı mançil-allar mısacar qaçaxaras deş. ");
INSERT INTO tkr_vpl VALUES ("PS15_9","020_15_9","PSA","15","9","9","Zı yik'eençe şadexhe vor, Zı şadvalin xəybışeena xhinne ilexa vor, Zasse qı'dərq'ı'n manzil haa'as vəəxə. ");
INSERT INTO tkr_vpl VALUES ("PS15_10","020_15_10","PSA","15","10","10","Ğu zı ahalee g'alerçes deş, Yiğna mu'mun Ğu nyuq'vnee qı'çes hassaras deş. ");
INSERT INTO tkr_vpl VALUES ("PS15_11","020_15_11","PSA","15","11","11","Ğu zak'le ı'mı'r hoolena yəq haagu, Yiğne k'ane zı geer şadra vor, Yiğne xılen hammaşe zas yugun hele. ");
INSERT INTO tkr_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Maq'amne xərıng'us. Rəbbine g'uluna, Davudna mə'niy. Rəbbee Davud gırgıne cune duşmanaaşineyiy Şaulne xılençe g'attixhan hı'ımee, Davudee Rəbbis ina mə'niy qəbəqqə: ");
INSERT INTO tkr_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Rəbb, zas Ğu ıkkanna! Ğu yizda guc vob. ");
INSERT INTO tkr_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Rəbb yizda suva vobna, yizda g'ala, zı g'attixhan ha'ana vorna. Allah yizın ganz vodun, Mang'usne zı dyugul ixhes. Yizın g'alxan, zı g'attixhana'asda guc, it'umun ciga Mana vor. ");
INSERT INTO tkr_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Şukur gyooxhane Rəbbilqa ona'as, yizde duşmanaaşine xılençer g'attixhanasda. ");
INSERT INTO tkr_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Yizde hiqiy-alla gyabat'an torbı ıxha, zı gek'ane damabışile zı qəyq'ən ıxha. ");
INSERT INTO tkr_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Ahalın t'ü'bı zalqa alitk'ır ıxha, gyapt'asde gugubışeqar zı girxhu ıxha. ");
INSERT INTO tkr_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Dağamiyvalee zı Rəbbilqa onuiyn, Allah kumagıs qort'ul. Mang'uk'le yizın ses Cune Xaa g'ayxhiyn, yizın uts'ur Mang'une k'ıriysqa hitxhıriyn. ");
INSERT INTO tkr_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Mang'us qəl vuxhal-alla ç'iye oyt'al, ı'ğiykaran, suvabışin xhebbı ı'ğiykar, manbı hoyharanbı. ");
INSERT INTO tkr_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Mang'une quşeençe kuma qığeç'u, ghalençe gyooxhan haa'an ts'a ı'xiyxə. Mançikeb gyopxhanna ghadır k'yoohar. ");
INSERT INTO tkr_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Mang'vee xəybı qaxı, ç'iyelqamee geç'ena. Miç'axiyvalla Mang'une g'elybışik avub vuxha. ");
INSERT INTO tkr_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Sa keruvulil alixı, mıtsıne xılibışil ilexa. ");
INSERT INTO tkr_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Hiqiy-allan ciga xəmdilqa sak'al ha'a, xhineka gyatsts'ıyne k'aarıne buludbışike Culqa aççesın kar ha'a. ");
INSERT INTO tkr_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Mang'une nuruke buludbı ileedaxva, Mang'uke dolu, gyotxhanan ts'a qı'ğəə ıxha. ");
INSERT INTO tkr_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Rəbbee xəybı g'əhətqə'ə, Haq'-Ta'aalee ses gyayhe, dolu, gyotxhanan ts'a g'ıxele. ");
INSERT INTO tkr_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Vukbı avhu, duşmanar ehevkaa'anbı, ts'ayılpan ı'xı'ı', manbı oot'al-ooxal haa'anbı. ");
INSERT INTO tkr_vpl VALUES ("PS17_16","020_17_16","PSA","17","16","16","Ya Rəbb, Yiğne qəvəəq'ənasde sesıke, quşeençene qı'ğəəne it'umne nafasıke, deryahın k'oralybı g'ece giyğal, dyunyeyn xhebbı g'ece giyğal. ");
INSERT INTO tkr_vpl VALUES ("PS17_17","020_17_17","PSA","17","17","17","Mang'vee xəybışeençe xıl hotku, zı aqqı, zı k'orane xhyanbışeençe qığavhu. ");
INSERT INTO tkr_vpl VALUES ("PS17_18","020_17_18","PSA","17","18","18","Zı gucnane duşmanıke Mang'vee g'attixhan hı'ı, zı g'ımece eyxhenbışike, yizdemee geeb gucnanbışike g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("PS17_19","020_17_19","PSA","17","19","19","Yizde pisde yiğıl manbı yizde ögiylqa qığeepç'ı, Rəbbeeme zı aqqı. ");
INSERT INTO tkr_vpl VALUES ("PS17_20","020_17_20","PSA","17","20","20","Mang'vee zı dağamiyvalike hixu'u, zı ıkkiykın, zı g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("PS17_21","020_17_21","PSA","17","21","21","Yizde qopkuvalis sik'ı Rəbbee zas huvu, yizde xılene məttıvalis sik'ı huvu. ");
INSERT INTO tkr_vpl VALUES ("PS17_22","020_17_22","PSA","17","22","22","Mang'vee məxüd hı'iyn, zı Rəbbina yəq' avquva, pisda ıxha Allahılqa yı'q' sak'al hidi'ıva. ");
INSERT INTO tkr_vpl VALUES ("PS17_23","020_17_23","PSA","17","23","23","Mang'un gırgın q'aanunbı yizde ögiyl vod, Mang'une g'aydabışiler hixu deş. ");
INSERT INTO tkr_vpl VALUES ("PS17_24","020_17_24","PSA","17","24","24","Zı Mang'une ögiyl məttıne yik'eka ıxha, zıcar zı bınahıke havacına. ");
INSERT INTO tkr_vpl VALUES ("PS17_25","020_17_25","PSA","17","25","25","Rəbbee yizde qopkuvalis sik'ı huvu, Cune ulene ögiyl yizde məttıne işbışis sik'ı huvu. ");
INSERT INTO tkr_vpl VALUES ("PS17_26","020_17_26","PSA","17","26","26","Ğu saadik'ranang'uka saadik'ra eyxhe, kaamilinbışika kaamilyra vor. ");
INSERT INTO tkr_vpl VALUES ("PS17_27","020_17_27","PSA","17","27","27","Məttınbışika məttıra, quç'opkuriynbışika, cone quç'opkuriys sik'ı eyxhe. ");
INSERT INTO tkr_vpl VALUES ("PS17_28","020_17_28","PSA","17","28","28","Hooç'an-g'ooç'ananbı Ğu g'attivxhan haa'a, cocab-co axtıba vukkekanbışilqab Ğu ul giviyxhe, manbı k'ap'ik'ıle avqa qaa'a. ");
INSERT INTO tkr_vpl VALUES ("PS17_29","020_17_29","PSA","17","29","29","Rəbb, Ğu yizın işix qayhe, Ğu yizda miç'axiyvalla nurulqa savaak'al haa'a. ");
INSERT INTO tkr_vpl VALUES ("PS17_30","020_17_30","PSA","17","30","30","Zı Vakasana duşmanaaşikın ha'a, yizde Allahıka şaharbı aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("PS17_31","020_17_31","PSA","17","31","31","Allahna yəq kaamilyba vob, Rəbbin cuvab məttıda vod! Mang'ulqa yı'q' qizzırna gırgına, Mang'vee g'attixhan ha'ana. ");
INSERT INTO tkr_vpl VALUES ("PS17_32","020_17_32","PSA","17","32","32","Rəbbile ğayrı, Allah vuşune vor? Yişde Allahıle ğayrı, medın ganz nenne vod? ");
INSERT INTO tkr_vpl VALUES ("PS17_33","020_17_33","PSA","17","33","33","Allahee zas dəv'ee guc hoole, Mang'vee yizda yəq qopku qaa'a. ");
INSERT INTO tkr_vpl VALUES ("PS17_34","020_17_34","PSA","17","34","34","Mang'vee yizın g'elybı maralın g'elybı xhinne ek' qa'a, Zı axtıvalee it'umra aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("PS17_35","020_17_35","PSA","17","35","35","Mang'vee yizın xıleppı dəv'əysın xhinne qa'a, zasse tuncıke hı'iyn vuk quç'okara'as əxən. ");
INSERT INTO tkr_vpl VALUES ("PS17_36","020_17_36","PSA","17","36","36","Ğu zas g'attixhana'asın g'alxan huvu, Yiğne sağne xılen zı aqqaqqana. Ğu hı'iyne kumaagıka zı axtı qı'ı. ");
INSERT INTO tkr_vpl VALUES ("PS17_37","020_17_37","PSA","17","37","37","Zasse saccu Vaka əq'ra iykaras əxə, zı məxür qaçayxarır deş. ");
INSERT INTO tkr_vpl VALUES ("PS17_38","020_17_38","PSA","17","38","38","Zı duşmanaaşiqa qihna girxhu, manbışiqa avarq'ılyna, manbışikın ixhesmee yı'q'əlqar sak'ı deş. ");
INSERT INTO tkr_vpl VALUES ("PS17_39","020_17_39","PSA","17","39","39","Zı manbı hööq'əv'u ç'əvxhana, manbışisse suğoots'asıb vəvxü deş. ");
INSERT INTO tkr_vpl VALUES ("PS17_40","020_17_40","PSA","17","40","40","Dəv'əynemee Ğu zalqa guc alipk'ır, zalqa g'elil qeepxhaynbı Ğu yizde g'eliqqa huvu. ");
INSERT INTO tkr_vpl VALUES ("PS17_41","020_17_41","PSA","17","41","41","Duşmanar zale heepxasınbı xhinne qaa'a, zı g'ımecenanbışikınıd zı hı'iyn. ");
INSERT INTO tkr_vpl VALUES ("PS17_42","020_17_42","PSA","17","42","42","Manbışe kumagıs qopt'uleeyib, manbı g'attivxhan haa'anbı vuxha deş, Rəbbilqa onu'eeyid, Mang'vee alidghıniy quvu deş. ");
INSERT INTO tkr_vpl VALUES ("PS17_43","020_17_43","PSA","17","43","43","Zı manbı k'ööq'ü, tooz xhinne qav'u, mıtsınıb manbı inyaqa-şaqa dağav'u. Zı manbı şahrabışeedın battağ xhinneeyib hööq'üynbı. ");
INSERT INTO tkr_vpl VALUES ("PS17_44","020_17_44","PSA","17","44","44","Ğu zı, yizde milletne g'elil qeepxhayke g'attixhan hı'ı, zake milletbışda xərna hı'ı, zak'le dyats'ancad milletbı yizde xılyaqa quvu. ");
INSERT INTO tkr_vpl VALUES ("PS17_45","020_17_45","PSA","17","45","45","Menne cigeençenbı yizde ögiyl k'yoozarav'uynbı, yizın do g'ayxhımee, eyhen ha'a. ");
INSERT INTO tkr_vpl VALUES ("PS17_46","020_17_46","PSA","17","46","46","Menne cigeençenbı yizde ögiyl hapq'ıriynbı. Qəpq'ı'n zezebı atk'u, dyuguleepxhayne cigeençe qığeepç'iynbı. ");
INSERT INTO tkr_vpl VALUES ("PS17_47","020_17_47","PSA","17","47","47","Rəbb vorna! Yizde Ganzıs şukur vuxhena! Zı g'attixhan hı'iyn Ganz, Allah, axtı qe'e! ");
INSERT INTO tkr_vpl VALUES ("PS17_48","020_17_48","PSA","17","48","48","Allahee zal-alla qəl qığaaha, milletbı yizde xılyaqa qele. ");
INSERT INTO tkr_vpl VALUES ("PS17_49","020_17_49","PSA","17","49","49","Mang'vee zı yizde duşmanaaşine xılençe g'attixhan ha'a, Mang'vee zı yizde duşmanaaşile ooqana ha'a, Zı eb ulyooğanbışde xılençe g'attixhan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("PS17_50","020_17_50","PSA","17","50","50","Rəbb, mançil-alla zı Ğu menne milletbışde yı'q'nee axtı qa'as, zı Yiğne doyus şukur haa'as! ");
INSERT INTO tkr_vpl VALUES ("PS17_51","020_17_51","PSA","17","51","51","Allahee Cune paççahıs xədın ğamxhaybı heles, g'əyxı'yne Davudne nasıles gırgıne gahbışilycab yugvalla haagvas. ");
INSERT INTO tkr_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Maskil, Davudna mə'niy. Şavunbıyiy bınahbı Rəbbe yik'elixanı'ı, Şavunbıyiy qotkuda hidi'iyn harakatbı hakkal hı'ı, nimee baxtivariy! ");
INSERT INTO tkr_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Cuna bınah dyugulydyaa'ana, Rəbb bınahılee ilheç'una insan, nimee baxtivariy! ");
INSERT INTO tkr_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","4","Gardanaqa alyat'asmee zı əvəray hav'u. Yiğbına, xəmbına Yiğna yı'q'na xıl zal oğa vuxha. Yizda guç g'apt'ına g'ı'liyne pırane yiğıl qəhətxhayn çiy xhinne. Ik'arang'an xhineyid yizın bark'vbıd rı'hı'le g'a'atk'u. ");
INSERT INTO tkr_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Manke zı bınah Yiğne ögiyl gardanaqa alyapt'ına, Yizın qotkuda hidi'iy Vale dyugul hı'ı deş. Qiyğa zı uvhuyn: «Zı bınahbı Rəbbine ögiyl gardanaqa alyat'anbı», Ğunar yizde bınahıle ilheç'una. ");
INSERT INTO tkr_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Mançil-allab Yiğna yəq avquyng've, Ğu iveekemee Valqa düə hee'ecen. Məhrıng'uk xədın xhyanbıd qadıyng'a set'as deş. ");
INSERT INTO tkr_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Zı dyugulexhen ciga Ğu vorna, Ğu zı dağamiyvalike g'attixhan ha'as, Ğamxhayn şadvalin mə'niybı, Ğu yizde hiqiy-alla alik'ara'a. ");
INSERT INTO tkr_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","9","Ğu eyhen: «Balkaniy g'atir xhinne ək'el kamba mexhe, Manbı salbaniy g'antarağa dena Ğu eyhençilqa qalya'as əxə deş. Zı vas ək'el hevles, Ğu əlyhəəsda yəq haagvas. Zı ğu hot'alasda, Yizda ul val vobna». ");
INSERT INTO tkr_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Yəq avguynbışde vuk'lelqa xətta divanbı adaylenbı, Rəbbir culqa umud ha'anbışiqa Hammaşee yugra eyxhena. ");
INSERT INTO tkr_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Qopkuyn insanar, vuşda şadvalla Rəbbil-alla vuxhecen. Yik' məttınbı, şadvalina mə'niy Rəbbinimee qəpqe. ");
INSERT INTO tkr_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Allahne insanna Mısayna düə ");
INSERT INTO tkr_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nimee nasılbı badaledxheyid, Xudaavanda, şi Valqa yı'q' qizzır. ");
INSERT INTO tkr_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Suvabıyiy ç'iyeyn aq'va, dyunye ixhanassecad Ğu Allah ıxha, Gırgıne gahbışilır Allahcar ixhes. ");
INSERT INTO tkr_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Ğu insanar nyuq'nelqa savaak'al haa'a. Ğu manbışik'le eyhen: «Aadamın dixbı, nyuq'nelqa savk'le». ");
INSERT INTO tkr_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Yiğne ulesqa aazır sen, sa ılğeç'uyn yiğ xhinne, Xəmdiyna sa-q'öble sə'ət xhinne qadayle. ");
INSERT INTO tkr_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Selin xhinne Ğu insanar vukkeka, Manbı nyak' xhinne qabı avayk'an. Manbı miç'eeb alyabıyne ok'uk akar: miç'eeb k'atele qooxhe t'et'-t'ele g'ayhe, xəmdemee hı'ç'ı'bğı'n, qooqqana. ");
INSERT INTO tkr_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Yiğne qəlan şi gyabat'anbı, Vaqa qəlnang'a şi nyaqame vuxhesınbı aaxva. ");
INSERT INTO tkr_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Yişin taxsirbı Vak'le ats'a, Yişde dyugulene bınahbışilqa Yiğne aq'vayn nur gexha. ");
INSERT INTO tkr_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Ğu qəllamışxheene yişda ı'mı'r cit'a qooxhe. Yişin senbı ul gyapxı aaqasse ılğeeç'enbı. ");
INSERT INTO tkr_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Şi yights'al (70) sennana ı'mı'r haa'a, Vuk'diyk'ıree molyts'aleeqab (80) hiviyxharanbı. Mane senbışin g'ellesınbıd dağamiyvalee, ı'k'aree ı'lğəə, Yişda ı'mı'r zarabacab ç'əvooxhena, alivxu avayk'an. ");
INSERT INTO tkr_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Şavuk'lene Yiğne qəlına guc vaats'a? Vale nimeeyiy qəvəyq'ən, Vaqa manimeenab qəl vob. ");
INSERT INTO tkr_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","I'mı'r cit'aba vuxhay şas yik'el qale'e, Şi ək'elika vuxhes. ");
INSERT INTO tkr_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Ya Rəbb, şasqa sak'le! Nimeene gahnane inəxüd ixhes? Yiğne g'ulaaşis rəhı'm hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Şi gırgıne gahbışil şadba vuxhecenva, Miç'eeb şalqa Yiğna yugvalla gyooğee'e. ");
INSERT INTO tkr_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Şalqa ver ablyav'uyn yiğbımee, Balyaa ablyav'uyn senbımee, şi şad hee'e. ");
INSERT INTO tkr_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Ğu hı'iynbı Yiğne g'ulaaşik'le, Yiğna xəbvallab cone uşaxaaşik'le g'avcecen. ");
INSERT INTO tkr_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Ay Xudaavanda yişda Allah, şaqa yugra ixhe, Yişde xılen hı'iynçis baraka hevle, Hucoone ixhes, yişde xılen hı'iynçis baraka hevle. ");
INSERT INTO tkr_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Rəbbilqa şukur hee'e! Nimee baxtivariy Rəbbile qəyq'ənna, Mang'un əmrbı yik'eençe ha'ana! ");
INSERT INTO tkr_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Qəyq'anang'un uşaxar ç'iyeyne aq'val gucuka vuxhes, Qopkuyng'unbışde uşaxaaşeeb xayir-düə alyapt'as. ");
INSERT INTO tkr_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Qopkuynbı karnanbı, barakatnanbı vuxhes, Manbışda qopkuvalla, mısacab aagvales deş. ");
INSERT INTO tkr_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Miç'axiyvaleeyid qopkuynbışdemee nur ixhes, Manbı yugun, rəhı'mıkan, qopkuyn insanar vob. ");
INSERT INTO tkr_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Qidiykkın borcbı helenbışiqayiy horbı hidya'anbışiqa yugna ı'mı'r vuxhes. ");
INSERT INTO tkr_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Məxbın insanar mısacab qaçaaxaras deş, Qopkuyn insanar hammaşe yik'bışee aaxvas. ");
INSERT INTO tkr_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Manbı pisde xabarıle qəvəəq'ənas deş, Rəbbilqa qibzırva manbışin yik'bı it'umda ixhes. ");
INSERT INTO tkr_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Manbışin yik'bı it'umda vod, manbı qəvəəq'ənas deş, Manbışik'le con duşmanar avub aaxva g'avces. ");
INSERT INTO tkr_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Manbışe con var-devlet, kar deşinbışis qidiykkın bit'al hı'ı, Manbışda qopkuvallab hammaşiys aaxvas, Manbışde gucus geeb hı'rmat gyuvxhes. ");
INSERT INTO tkr_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Karaı'dəəne insanık'le man g'acu qəl vuxhes, Manbışe mizyar ats'ak'vanas, əəq'əsınbı. Manbışis ıkkananbı ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Rəbbilqa şukur hee'e! Rəbbin nukarar, şukur hee'e, Rəbbine doyus şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","G'iyniyke şaqa, gırgıne gahbışis Rəbbin do axtı qe'e! ");
INSERT INTO tkr_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Şargıle garbılqamee Rəbbine doyus şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Rəbb gırgıne milletbışile axtıra vor, Mang'una xəbvallab xəybışileb axtıba vob! ");
INSERT INTO tkr_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Axtıne xəybışeene taxtıl gyu'urne, Yişde Rəbbik Allahık akarna vornane? ");
INSERT INTO tkr_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Xəəqə, ç'iyeyqa K'yorzul ilyakkana Mana vor. ");
INSERT INTO tkr_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Mang'vee vuççud deşda, toozençe suğoots'a'a, Goreençena fağırır axtı qa'a, ");
INSERT INTO tkr_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Manbı cone milletne ç'ak'ınbışika, Sacigee gyuv'ar haa'asva. ");
INSERT INTO tkr_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Mang'vee uşax dexhene xhunaşşeys uşaxar hoole, Məxür məng'ı'ke baxtivarna yed hee'e. Rəbbilqa şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Rəbbis şukur hee'e! Muq'addasne Cune cigee Allahıs şukur hee'e! Mang'vee Cuna guc xəybışeene taxtıl haagva. Mang'us şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Ç'ak'ıne işbışil-alla Mang'us şukur hee'e! Ç'əvcab dyooxhene Mang'une xəbvalis sik'ı Mang'us şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Gaçeençe qı'ğəəne seseka Mang'us şukur hee'e! Arfaykayiy, lirayka Mang'us şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Dafıka, mık'ar ha'a-ha'a, Mang'us şukur hee'e! Sazıka, dyuttyak'ıka Mang'us şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","İt'umda ses qı'ğəəne naq'rabışde seseka Mang'us şukur hee'e! G'avayghane sesnane naq'rabışika Mang'us şukur hee'e! ");
INSERT INTO tkr_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Nafas hıxelen gırgınbı Rəbbis şukur hee'e! Rəbbis şukur hee'e!");
INSERT INTO tkr_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Hikmətılqa hirxhılyna, K'orana ək'el avaykına insan nimee baxtivariy! ");
INSERT INTO tkr_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Mançiken xayir nuk'rayle geed vod, İn g'azanc məttıne k'ınəəğəyle q'iymatıka vod. ");
INSERT INTO tkr_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Mana gıranne ekebışileb gıranba vob, Mançika vas ıkkanan nencad kar sa aqqas dexhe. ");
INSERT INTO tkr_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Mançine sağne xılen xıliyna ı'mı'r, Solne xılenıd var-devletiy şöhrat hele ıxha. ");
INSERT INTO tkr_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Mançin yəqbı q'abıledaxhenbı vod, Gırgın yəqbı əmin-amanınbı vod. ");
INSERT INTO tkr_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","At'ipq'ı'ninbışdemee mana ı'mrena yivobna, Mançike it'umba alyt'ipq'ıninbı nimee baxtivarariy! ");
INSERT INTO tkr_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Rəbbee dyunye hikmətıka itxhın, K'orane ək'elika xəybı hı'ı, ");
INSERT INTO tkr_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Ats'aalika k'oralybışençe xhyan alqavhu, Xəybışençe çiy gyuarı'ı. ");
INSERT INTO tkr_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Sirkayn silibışik, kumayn uleppışik ha'an, Tambalee iş hooleng'uk ha'a. ");
INSERT INTO tkr_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Var-devletılqa umudeepxhaynbı k'yooçesınbı, Qopkıynbıb t'et'-t'ele g'ayhene yivaaşik akaraba vuxhes. ");
INSERT INTO tkr_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Yugna xhunaşşe adamiyn tac vodun, Tesser ha'anar vuk'arne bark'uk akar. ");
INSERT INTO tkr_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Bəç'əree qəl zaraba h'aagva, Ək'elikang'un rı'h tsimis qexhen deş. ");
INSERT INTO tkr_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Nəxüd qadıy uvhuynçin ç'ik'ayn xhinne g'ats'ayk'van, K'orane ək'elika uvhuynçinıd yug qaa'a. ");
INSERT INTO tkr_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Ghal sı'ına geer axhvas, Sidi'ınar ek'ra haq'varas. ");
INSERT INTO tkr_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Yats deşdang'a axur məttıba vooxhe, Yugun g'ıkıd yatsbışde taq'atınxhe helen. ");
INSERT INTO tkr_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","G'üvənana miz ı'mrena yiv vobna, Horarlynançinıd yik' haq'vara'an. ");
INSERT INTO tkr_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Mühübbatıka xhınakın ala otxhuniy, Qəlıka boğayn çuru otxhuniyle yugda vod. ");
INSERT INTO tkr_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Qəlnang'vee g'almag'al haa'a, Sabırnang'vee ç'əv haa'a. ");
INSERT INTO tkr_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","T'ap'anedın itv xhinne uftanna yuşe, Canas yugba, rı'hı's ittuba. ");
INSERT INTO tkr_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Gucnang'ule sabırnana yugra, Şaharbı alyaat'ang'uler vuc aqqaqqana yugra. ");
INSERT INTO tkr_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Saç'uvkiy deşda qit'ipk'ınna xüvə, Saç'uvkiynane otxhun-ulyodğuyle ittuba vob. ");
INSERT INTO tkr_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Hambaz ıkkanang'vee qəl yik'elivxanaa'ana, Yik'el qavaalya'ang'vee hambaz agval ha'ana. ");
INSERT INTO tkr_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Hambazıs hammaşe ıkkiykanna, Çocur dağamne yiğıs iyxhanna. ");
INSERT INTO tkr_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Karnanbışisqa həməxüd q'öö, con kar axtıne barugbışika alyav'una g'alaniyxan. ");
INSERT INTO tkr_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Tsimisna çoc – alyapt'as dyooxhene g'alayk akar, Aldapxhıniybıd – akkalne rızayk. ");
INSERT INTO tkr_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Xaviy var-devlet dekkına miras vobna, Ək'elikana xhunaşşer Rəbbikena. ");
INSERT INTO tkr_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Tambale ezang'a ezu deş, Sa'anang'ad avaykı deş. ");
INSERT INTO tkr_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Siç'eekvane xhunaşşeyka sa xaa axvasse, Daxayne vuttul axvee yugda eyxhe. ");
INSERT INTO tkr_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Hı'rmat nuk'rayleyiy-k'ınəəğəyle geeb vukkiykne, Yugun doyud xənne var-devletıle geed ikkiykne. ");
INSERT INTO tkr_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Karnanayiy kar deşda sana-sang'uk akar - Q'öyursanar Rəbbee ipxhın. ");
INSERT INTO tkr_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Ts'eppacab uşaxık'le qopkuna yəq haagve, Q'əsvaleyir mana mançile sak'alas deş. ");
INSERT INTO tkr_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Kar kılydanang'uka gucub kı'lybava g'ımeşşe, Kasibrava məhkamee himeşşe. ");
INSERT INTO tkr_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","Rəbb alikkas manbışil-alla, Manbı g'yootuynbı, hivşuynbı Rəbbee ı'mreke haa'as. ");
INSERT INTO tkr_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Xətta kar ha'asva ğucar ğu gimek'a. Ək'elika ixhe, mane fıkrele ılğeç'e. ");
INSERT INTO tkr_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Var-devlet ul gyapxasse deşxhesın, Q'acır xhinne xılibı aaqı xəybışeeqa alixasın. ");
INSERT INTO tkr_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Tambalne ekıneençe G'anmazne t'ımıllığeençe ılğeç'u. ");
INSERT INTO tkr_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","G'acuyn gırgın sura zazaanıd aalyat'u, Mağaanıd aqqı, cabırbıd hı'ğətkırıd. ");
INSERT INTO tkr_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Mançika ilyakkı fıkır opxhun, Mançike ı'brat aalyat'u: ");
INSERT INTO tkr_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Sık'ırra qorku mırg he'ee, G'el-xıl hotku g'alirxhvee, ");
INSERT INTO tkr_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Kasibiyvalla soyğunçiy xhinne, Ehtiyaccıb g'uldur xhinne sayangaba ooqa hophur ables. ");
INSERT INTO tkr_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Cigal uvhuyn cuvab, nuk'rayne g'abılyne k'ınəəğəyne eçeeşik akar. ");
INSERT INTO tkr_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Paççahnab fıkır sabırnang'vee badal haa'ana, İttune mizen bark'ub g'üvana qaa'ana. ");
INSERT INTO tkr_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Xıl hudyoolena dağamne yiğıl Qiçiyne siliykiy k'aane g'elik akar. ");
INSERT INTO tkr_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Duşman mıssıraxhee, oxhanasın hele, Xhyan ıkkanxhee, ulyoğasın hele. ");
INSERT INTO tkr_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","Məxüd ğu mang'us naş qa'as, Yiğna yugvallab Rəbbee savaak'al haa'as. ");
INSERT INTO tkr_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Qəl avqas dəxəna insan, Cabırbı hı'ğətkırne şaharık akar. ");
INSERT INTO tkr_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Nəxüdiy osake ts'a eyxhe, Ğiybatnang'ukeb g'almag'al vooxhe. ");
INSERT INTO tkr_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Hambazın yik' aliq'alı'iy, Duşmanne geedne ubbabışile yugun vodun. ");
INSERT INTO tkr_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Lemuel donane paççahee uvhuynbı, yedee mang'us xət qıiyn cuvab. ");
INSERT INTO tkr_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","Hucoona zı eyhes dix, zı uxuna dix, Düəbışika heeqqına dix? ");
INSERT INTO tkr_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Guc zəiyfabışis hımoole, Yiğın yəqbı paççahaaşikın ha'anbışik'le hımagva. ");
INSERT INTO tkr_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Lemuel, çaxır ulyoduy paççahaaşik avaakı deş, P'iyan haa'an ulyodğuy ıkkiykıniy vuk'lek vukkekkanbışik avaak'ı deş. ");
INSERT INTO tkr_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Ulyodğumee q'aanunxhe yik'el hiviyxan, Manbışe kar deşinbı hək' dena g'alyaa'as. ");
INSERT INTO tkr_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","P'iyan haa'an ulyodğuy mançika qek'ang'us , Çaxırıd ver abıyng'us hele. ");
INSERT INTO tkr_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Hasre ulyodğu kar deşiyvalla yik'el hivxan hee'ecen, Culqa abına ver sayıb yik'el qavaal hımaa'acen. ");
INSERT INTO tkr_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Miz deşing'ul-alla ghal eeqe, Guc deşinbışda hək' avqe. ");
INSERT INTO tkr_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Ghal eeqe, qotkuyn eyhe, Kar deşinbışda, fağıraaşina hək' qevle. (Yugun ha'ana xhunaşşe) ");
INSERT INTO tkr_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Yugna xhunaşşe aveekına vuşune? Gıranne g'ayebışile mana gıranna vor. ");
INSERT INTO tkr_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Adamiyn yik' məng'ı'le arxayında vod, Mana məng'ı'ka barakat dena axvas deş. ");
INSERT INTO tkr_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","I'mı'r volle adamiys pisın deş, yugun ha'as, ");
INSERT INTO tkr_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Xhayiy katan məng'ee g'əyxə, Xılençe yugda gırgın qöö. ");
INSERT INTO tkr_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Kar alişşu-massa helene gamibışik akar, Cesın oxhanasın kar əq'ənançe adayle. ");
INSERT INTO tkr_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Miç'axdanang'acar mana muğur qeexhe, Xizanısın oxhanasın otxhuniy ha'a, Həmbalaaşisda iş hoole. ");
INSERT INTO tkr_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Çoluka ilyakkiyle qiyğa çol ileşşe, Xılene əq'übayka bağ adaççe. ");
INSERT INTO tkr_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","İş məng'ee geeb haa'a, Məng'ı'na guc cene işis g'iviyxharna. ");
INSERT INTO tkr_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Məng'ı'lqa kar alişşu-massa huvuyna ittulla hipxhırna, Xəmdeb məng'ı'na bazir k'əbəqqə deş. ");
INSERT INTO tkr_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Xıleka xha g'oodan kar iliyk'ar,)) ");
INSERT INTO tkr_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Kar deşing'unemee məng'ee xıl aaqa, Fağıraaşis xıl avqaaqqa. ");
INSERT INTO tkr_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Yiz gyuoğang'ad mana cune xizannemee q'əyq'ən deş, Məng'ı'ne xizanne gırgınbışe ç'əran kar ali'ı. ");
INSERT INTO tkr_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Yic g'ileexhane tyuliys aq'vabı iyxhva, Məng'ee yicee k'ışşeyn ç'əran katanın kar alya'a. ");
INSERT INTO tkr_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Adamiy məng'ı'na şaharne akkabışisnee yugra ats'a, Milletne ağsaqqalaaşika gyu'ur-oza qexhe. ");
INSERT INTO tkr_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Məng'ee zəiyfabışis ts'irabı, Yicee iyxuyn katanıken tanalinbı massa hele. ");
INSERT INTO tkr_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","(--) ");
INSERT INTO tkr_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Mana k'orane ək'elika yuşan hee'e, Məng'ı'ne mizel vukkiykıniy yugvalla vob. ");
INSERT INTO tkr_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Xizanne işbışika mana ileeka, Tanbalıs avaak'iyn gıney oyxhan deş. ");
INSERT INTO tkr_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Uşaxar oza qeepxha məng'ı's gappar ha'a, Adameeyib məng'ı'na yugna gaf haa'a: ");
INSERT INTO tkr_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","\"Yugun zəiyfabı geeb vob, Vaka sa ayqasdame deşda\". ");
INSERT INTO tkr_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Zəiyfayna yugvallayiy micagiyvalla horbışikan kar vod, Saccu Rəbbile qiyeeq'ənne zəiyfayk'le yugun eyhes eyxhe. ");
INSERT INTO tkr_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Məng'ı's gyooxhana hək' qevle, Hasre məng'ı'n işbı şaharne akkabışisnee ələtqecen.");
INSERT INTO tkr_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","İna gaf Mə'əllimee, İyerusalimee paççahiyvalla hav'uyne, Davudne dixee hav'u. ");
INSERT INTO tkr_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Mə'əllimee eyhen: – Q'əran vuççud deşin kar! Q'əran vuççud deşin kar! Gırgın ıxha-ayk'anne booğak akar vod! ");
INSERT INTO tkr_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","İnsanıs verığne avur qorxuyke hucoona hiyxhar? ");
INSERT INTO tkr_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","İnsanar qabı-avayk'ananbı, dyunyemee gırgıne gahbışilycad çine cigee axva. ");
INSERT INTO tkr_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Verığ k'yooçena, ılqooç'ena, qiyğa meeb ılqevç'esva çine cigeeqa zaraba g'adaaxhvan. ");
INSERT INTO tkr_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Mıts cənubulqa, qiyğa şimalılqa aa'a. İlyviyk'ar-ilyviyk'arıb çine yəqqı'lqa siviyk'al. ");
INSERT INTO tkr_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Gırgın damabı deryaheeqa gyodatstse, deryahme gyaats'e deş. Damabı gyodatstsene cigeeqacad meed gyotstses. ");
INSERT INTO tkr_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","İnsanısse gırgıne karan vuc nimeeyiy ozar ha'a, eyhes əxə deş – ul, ilyaakıyke idyaats'e, k'ırıd, k'ırı alixhxhiyke gidyayts'e. ");
INSERT INTO tkr_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Hucooyiy ıxha meed ixhesın, hucooyiy həşdilqamee hı'ı, meed ha'asın. Xəək avud ts'edın kar deşin. ");
INSERT INTO tkr_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Sassa yəqqees eyhen: «İlekke, in ts'edın karıd!» Man ögiylid ıxhayn, yişde dyovrule ögiyl. ");
INSERT INTO tkr_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Şenke vuxhaynbı şavuscab yik'el avxu deş. Qiyğa qavaalesınbıb, cole qiyğiynbışe yik'el avqas deş. ");
INSERT INTO tkr_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Zı, Mə'əllim, İyerusalimee İzrailyna paççahniy vor. ");
INSERT INTO tkr_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","Zıcar zı g'aysırna xəək avud eyxhen işbı k'orane ək'elika xət qeetxhesva. Man yı'q'ı'n işbı Allahee insanaaşine gardanaqa gixhxhı. ");
INSERT INTO tkr_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Zak'le xəək avud ha'an gırgın işbı g'acuynbı. Man gırgın q'əran vuççud deşin kar vodun. Man mıtsıqa qihna g'adarxhuniyk akar. ");
INSERT INTO tkr_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Quç'otkuriyn qotku qa'as, deşinıd hı'sab ha'as dexhe. ");
INSERT INTO tkr_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Zı zascad uvhuyn: «Zake xərna insan ıxha, zaqa zale ögee İyerusalimıs paççahiyvalla haa'ane paççahaaşile k'orana ək'el vob. Yizda k'orana ək'eliy ats'al geeb quvxha». ");
INSERT INTO tkr_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","Zıcar zı g'aysırna k'orana ək'eliy ats'al xət qıxha, bəç'əriyvallayiy beynyavavalla nəxdın kariyva ats'a ixhes. Zak'le manıd mıtsıqa qihna g'adarxhuniyk akaran kar ıxhay ats'axhxhayn. ");
INSERT INTO tkr_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","K'orana ək'el geeb vuxhaylette aq'va havaxan hı'iyid geed qexhe. Geed ats'al alyaat'ang'vee cuna derdıb geeb qa'a. ");
INSERT INTO tkr_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","Zı zak'lecad uvhuyn: «Qoralan, zas yik'eençe ıkkanan karbı hı'ı, gırgınçike kef qığahas». Manıd q'əran vuççud deşin kar vodun. ");
INSERT INTO tkr_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","Əqənayne hək'ee zı uvhuyn: «Bəç'əriyvalla!» Yik'eençe ıkkanne karbışded hək'ee zı uvhuyn: «Mançike hucoona hiyxhar?» ");
INSERT INTO tkr_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Zas ıkkiykınin yizda ək'el zalynang'a çaxır ulyodğu, bəç'əriyvallabı ats'axhxhes. Məxüd zas ats'axhxhesniy ıkkan, xəək avub sık'ınne gahıs huvuyne ı'mree, nişiniy insanaaşin yik'bı aaqa. ");
INSERT INTO tkr_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Zı ç'ak'ın işbı g'acu: zas xaybı ali'ı, t'ımıllığbı ezu, ");
INSERT INTO tkr_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","bağbı, park'bı atçu, caa'ad gırgın meyvabı ezu. ");
INSERT INTO tkr_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","Park'bışeene yivaaşis xhyan heles ixhecenva xhinen golerıd hı'ı. ");
INSERT INTO tkr_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","Həmbal adameriy həmbal zəiyfabı alivşu, zaqa, manbışileb ğayrı, yizde xaa yedike vuxhayn həmbalarıb vuxhaynbı. Çavra-vəq'əd zaqa zale ögee İyerusalimee vuxhayne gırgıng'ule geedniy vod. ");
INSERT INTO tkr_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Zasın k'ınəəğəyiy nuk'ra paççahaaşineyiy vilayatbışde xazinaabışeençe sı'ı. Zas mə'niybı qətqəsın adameriy zəiyfabı ablyav'u. Adameeşis vukkiykanan nekke micagın zəiyfabıb geeb qav'u. ");
INSERT INTO tkr_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","Zı məxür zale ögiyl İyerusalim vuxhaynbışiler karnana, qıvaats'ına ıxha. Mane gahılib yizda k'orana ək'el zalycab vuxha. ");
INSERT INTO tkr_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","Yizde ules ıkkiykınin zı zale qiykkın deş. Yizde yik'es ıkkanan zı gırgın hı'iyn. Man ha'an gırgın yizde yik'eençe ıxha. Mana zı qorxuna hək' vuxha. ");
INSERT INTO tkr_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Zı qorxunne, yizde xılen g'acuyne işbışiqa sak'ı ilyakkımee, man gırgın q'əran vuççud deşin kar vodva zak'le ats'axhxhayn. Man mıtsıqa qihna g'adarxhuniyk akar. Xəək avud nişikecad vuççud hiyxhar deş. ");
INSERT INTO tkr_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Qiyğa zı k'orane ək'eline, bəç'əriyvaline, beynyavaline hək'ee fıkır opxhun. Menne qalesde paççahısse nen medın ine paççahee hidi'iyn işbı g'aces əxəyee? ");
INSERT INTO tkr_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","Zalqa hitxhıriyn, nəxüdiy işix miç'axiyvalile yugda, məxbıb k'orana ək'el beynavavalile yugba vob. ");
INSERT INTO tkr_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","K'orana ək'elynang'uk'le vuc nyaqa ark'ıniy yugda g'ece, bəç'ərme miç'axiyvalee iliyk'ar axva. Zak'leme q'öng'ünesanad vuk'lelqa sa kar qales ıxhay ats'an. ");
INSERT INTO tkr_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","Zı zak'lecad uvhuyn: «Yizded vuk'lelqa bəç'ərne vuk'lelqa qöön qales. Manke zas nişistannane yizda k'orana ək'el?» Mançil-allad, zı zaled-alqa uvhuyn: «Manıd q'əran vuççud deşin kar vodun». ");
INSERT INTO tkr_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","K'orana ək'elynanar, bəç'ər xhinne geer gahna yik'el aqqas deş. Manbışda q'öyursana zarabacab yik'el hivxanasınbı. K'orana ək'elynanar bəç'ər xhinnecar qek'anacar! ");
INSERT INTO tkr_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","I'mırıb zas g'umooce quvxha. Xəək avud ha'an gırgın kar zas qəla qıxha. Man gırgın q'əran vuççud deşin kar vodun. Man mıtsıqa qihna g'adarxhuniyk akar. ");
INSERT INTO tkr_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Zı verığık avud qorxu hı'iyn gırgın kar zas g'ımece qıxha. Zı hı'iyn gırgın kar zale qiyğa qalesıng'us axvas. ");
INSERT INTO tkr_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","Şavuk'lene ats'a, mana ək'elikaname, bəç'ərme ixhes? Zı verığık avud k'orane ək'elikayiy qorxuyka hı'iyn karbı mang'une xılyaqa ılğeeç'es. Manıd q'əran vuççud deşin kar vodun. ");
INSERT INTO tkr_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Mançil-allad verığık avud qorxuyka ha'ane gırgıne karbışike zı mık'a qıxha. ");
INSERT INTO tkr_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Sang'vee k'orane ək'elika, ats'alika, yik'eençe hı'iyn kar, nekke qiyğa t'ubcab ı'ğviykar hidyav'une insanıs g'aleççes gexha. Manıd q'əran vuççud deşin kariy xəbna ver vobna! ");
INSERT INTO tkr_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","İnsanıs verığık avur qorxuyke, yik' gyotxhuniyke hucoona hiyxhar? ");
INSERT INTO tkr_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Gırgıne gahbışil mang'vee aq'va qa'a, derd ts'ıts'aa'a. Xəmder fıkren mana arğançe orxhan eyxhe. Manıd q'əran vuççud deşin kar vodun. ");
INSERT INTO tkr_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","İnsannemee inekke yugun otxhun-ulyodğuyiy sayid cune qorxuyke kef qığavhiy vodun. Zak'le g'acuyn man gırgın helenar Allah vorna. ");
INSERT INTO tkr_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","Mana dena şavusse oxhanas, yik' cigeeqa qalya'as əxəyee? ");
INSERT INTO tkr_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","Allahee Cune ulen aqqıyng'us k'orana ək'el, ats'al, şadvalla hoole. Bınahbınang'usme kar sa'asda əq'üba hoole, qiyğale xhinne Cune ulen aqqıyng'us helesva. Manıd q'əran vuççud deşin kar vodun, mıtsıqab qihna g'adapxhıniyk akar. ");
INSERT INTO tkr_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Gırgınçiqa çina gah vob, xəək avudne gırgıne karaqa çina gah vob. ");
INSERT INTO tkr_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Yedike ıxhayqab çina gah, qik'uyqab çina gah. Ezuyqab çina gah, ezuyn hı'ttitxı'yqab çina gah. ");
INSERT INTO tkr_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","Gyapt'ıyqab çina gah, yug qav'uyqab çina gah. Qottulıyqab çina gah, ali'iyqab çina gah. ");
INSERT INTO tkr_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","Gyaaşuyqab çina gah, əqəna hı'iyqab çina gah. Ak' avquyqab çina gah, mık'ar hı'iyqab çina gah. ");
INSERT INTO tkr_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","G'aye avhuyqab çina gah, g'aye sav'uyqab çina gah. Xüvə apk'iyqab çina gah, xüvə idyapk'iyqab çina gah. ");
INSERT INTO tkr_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","T'abal hav'uyqab çina gah, aagval hav'uyqab çina gah. Havaacıyqab çina gah, dağetçuyqab çina gah. ");
INSERT INTO tkr_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","Qıtt'axı'iyqab çina gah, man iyxhuyqab çina gah. Ghal sı'iyqab çina gah, yuşan hı'iyqab çina gah. ");
INSERT INTO tkr_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","Vukkiykıniyqab çina gah, g'umooce qepxhayqab çina gah. Dəv'əyqab çina gah, sülyhuqab çina gah vob. ");
INSERT INTO tkr_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","Qorxu kar ha'ang'us mançike hucoona hiyxhar? ");
INSERT INTO tkr_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","Zak'le Allahee man yı'q'ı'n işbı insanaaşine gardanaqa gixhxhı g'acu. ");
INSERT INTO tkr_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","Allahee gırgın kar micagda çine gahıl hı'ı. Mang'vee insanne yik'eeqa ç'əv dyooxhene gahıne hək'ee atçu. İnsanılqad Allahee hı'iyn kar q'omançe-k'anyaqqamee hiyxhar deş. ");
INSERT INTO tkr_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","Zalqa hitxhıriyn, insannemee şadra ıxha ı'mı'rvolle ı'mı'rıke kef qığavhuyle yugun kar deşin. ");
INSERT INTO tkr_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","Şavaayiy otxhanançike, ulyoğançike, qorxuyke kef qığayhee, mana Allahna pay vobna. ");
INSERT INTO tkr_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","Zalqa hitxhıriyn, Allahee hav'una iş gırgıne gahbışisda vobna. Mançik vuççudud hexxa'as eyxhe deş, mançike vuççudud g'ats'ak'vanas eyxhe deş. Allahee məxüd ha'a, insanarıb Cule qəvəyq'ənanbı. ");
INSERT INTO tkr_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","Həşde hucooyiy vod, şenked ıxhayn, hucooyiy ixhesıd, avaalad ıxhayn. Allahee şenke ıxhaynçin hı'sab qeqqas. ");
INSERT INTO tkr_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","Xəək avud zak'le inıd g'acuyn: Qotkune məhkamayne cigee horbı, qopkuvaline cigeeyib pisvalla. ");
INSERT INTO tkr_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","Zı zak'lecad uvhuyn: «Allahee qorkung'unud, pisıng'unud məhkama alğahas. Mang'vee gırgıne karas, gırgıne işis çina gah gyuvxhu». ");
INSERT INTO tkr_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","Zı zak'lecad uvhuyn: «Allahee insanar siliys üvxiyxə, co həyvanaaşik akaraba vuxhay g'avcecenva». ");
INSERT INTO tkr_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","Həyvanne vuk'lelqa qaylen insanned vuk'lelqa qaylen. Həyvanıb, insanır qek'ana. Həyvanınıd, insaneeyid sa nafas ileşşe. İnsan həyvanıle ooqana deş vor. Man gırgın q'əran vuççud deşin kar vodun. ");
INSERT INTO tkr_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","İnbıb, şenbıd çine cigeeqa siyk'al: inbıb, şenbıd nyuq'vnekenbı vod, nyuq'vnelqad sak'alasınbı. ");
INSERT INTO tkr_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","Şavuk'lene ats'a, insanaaşin rı'h xəəqə ılqeç'emme deşme, həyvanaaşinıd rı'h avqa, nyuq'vneeqa əlyhəə ıxhay? ");
INSERT INTO tkr_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","Zak'le g'acuyn, insanısqa vucee haa'ana iş yugba qööxhee, mang'unemee mançile yugun kar deşin. I'mreke mang'us axuyn man vod. Şavusse mang'uk'le cule qiyğa eyxhenbı hagvas əxəye? ");
INSERT INTO tkr_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","Zak'le meed xəək avud helen, gırgın əq'übabı g'acu: k'yats'apxıliynbışin gyaaşuybı g'acu, manbışis yik'bı helena vuşucar deşiy. Guc əq'üba hoolenbışde xıleyiy, k'yats'apxıliynbışis yik'bı helenbı deşiy. ");
INSERT INTO tkr_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","Zasqa ögiyl hapt'ıynbı, üç'übınbışile baxtivarba qabı. ");
INSERT INTO tkr_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","Mane q'önbışileb yugunbı, ine dyunyelqa qidyabıynbıcab vob. Manbı xəək avud ha'an pisın karbı g'ıdecuynbı vob. ");
INSERT INTO tkr_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","Zak'le insanaaşe iş yı'q'ba haa'amee, manbışda iş yugba əlyhəə g'avcuna. Mançil-allab mebınbışe manbışde karalqa ul giviyxhe. Manıd q'əran vuççud deşin kar vodun, mıtsıqab qihna g'adapxhıniyk akar. ");
INSERT INTO tkr_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","Şak'le ats'an bəç'əree xıl-xılelqa gixhxhı, mıssıra axu, cukun ha'an. ");
INSERT INTO tkr_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","Sa xhaxheedın vaxxariynme, q'öne xhaxheene qoxa ha'ane karaleyiy mıtsıqa qihna g'adarxhuniyle yugda vod. ");
INSERT INTO tkr_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","Zak'le meed xəək avud q'əran vuççud deşin kar g'acu: ");
INSERT INTO tkr_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","sa vuşucar deşda insanniy vor, mang'uqa dixır, çocur deşdaniy. Mang'una iş ç'əvcab vooxhena deşdiy, mang'un uleppıd karan ayts'e deşdiy. Mang'vee cuke qiyğan deşdiy, «Zı şavnemeene inimeena qoxa? Şavusvane zıcar zı kefıke ha'a?» Manıd q'əran vuççud deşin kariy yı'q'na iş vobna. ");
INSERT INTO tkr_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Sa insanıle q'öyre yugra, manbı qopxu hav'uyne işike yugna hək' vuxhes. ");
INSERT INTO tkr_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Sa qukkyork'ule, mang'une hambazee mana oza qa'asda. Vuccar əlyhəəname qukkyork'ulee, mana oza qa'asda ixhes deş. ");
INSERT INTO tkr_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Məxrür q'öyre insan sacigee g'alyapk'ee, manbışis g'üməda ixhes. Vuccar g'alirxhuna nəxür arak'vayee? ");
INSERT INTO tkr_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","Sang'ule ğamxhay vaxxariyda vod, q'öng'uleme ğameepxhay dağamda ixhes. Xhebılle g'atnana tü'ı'b zaaraba qooxas deş. ");
INSERT INTO tkr_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","Kar deşda, k'orana ək'elynana mek'vna, bəç'ərne, mı'sləhət g'idiyxhene q'əsde paççahıle yugra vor. ");
INSERT INTO tkr_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","Mana mek'vna ine ölkee kar deşde xizanee yedike ixheeyir, zindaneeqa girxheeyir, mang'usse mançe qığeç'u paççah ixhes əxəsda. ");
INSERT INTO tkr_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","Zak'le g'acuyn, xəək avub iviykaran gırgınbı paççah ıxhayne mek'vung'uqab qihna vob əlyhəə. ");
INSERT INTO tkr_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","Mang'une vuk'lelqa sadıyn millet qətqəs-ələtqəs eyxhe deşiy. Qiyğiyne nasılbışis mana yik'eençe ixhes deş. Manıd q'əran vuççud deşin kar vodun, mıtsıqab qihna g'adapxhıniyk akar. ");
INSERT INTO tkr_vpl VALUES ("EC4_17","022_4_17","ECC","4","17","17","Allahne Xaaqa ı'qqəmee, ğu ha'an ats'axhxhe. Beynyavabışik'le co ha'an dyats'a, cone beynyavalis sik'ı q'urban ablyaa'a. Manbışik'le co haa'ana pisvalla vaats'a deş. Ğu manbışe ha'an xhinne hıma'a, man ha'amee, Allahne cuvabıl k'ırı alixhxhe. ");
INSERT INTO tkr_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","Allahne ögiyl cuvab eyhesse fıkır ooxhne, zarada ghal ımaaqa. Allah xəə, ğume ç'iyel vor. Mançil-alla k'ırra yuşan he'e. ");
INSERT INTO tkr_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","İnsanee geeb fıkır opxhanxhee, mang'us alikkı-gikkiyn nyak'bı g'yagva. Həməxdıd geer yuşan ha'ang'vee cuna bəç'əriyvalla aq'valqa qığaaha. ");
INSERT INTO tkr_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","Allahıs cuvab huvuyng'a, man çine gahıl he'e. Mang'us bəç'ərar vukkiykananbı deş, cuvab huvuyn kar he'e. ");
INSERT INTO tkr_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","Cuvab hidevuy, cuvab huvu hidi'iyle yugda vod. ");
INSERT INTO tkr_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","Hımaysar yiğne ghalen ğu bınaheeqa arçes. Vasqa g'axuvuyng'uk'le immeyhe: «Zı cuvab huvu, qotkuda deş hı'ı». Vas nişisınne Allahna yiğne cuvabılqa qəl avqu, ğu yiğne xıleka hı'iynçıkın he'ecen? ");
INSERT INTO tkr_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","Geed nyak'bı g'acuy, geeb yuşan hav'iy q'əran vuççud deşin kar vod. Ğumee Allahıle qəq'ne. ");
INSERT INTO tkr_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","Vak'le nyaamecad karnang'vee kar deşda hoyç'an, qopkuvallayiy qotkuyn məhkama g'eliqqa huvu g'acveene, ghal aaqı ımaxva, məxdın kar eyxhenxhe. Sa xərıng'ul oo, mang'vee ha'ançiqa ilyakkana sa merna xərna vor. Manbışde vuk'lel ooyur manbışile xərna vor. ");
INSERT INTO tkr_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","Manbışde gırgınbışe ç'iyene aq'vayn hixhara'an kar alyaat'a, nyuq'vnen paççahır ats'ya'ana. ");
INSERT INTO tkr_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","K'aarın ıkkanna mançike ayts'ena deş. Kar ıkkannar g'azançıle idyayts'e. Manıd q'əran vuççud deşin kar vodun. ");
INSERT INTO tkr_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Kar geed qıxaylette, man otxhananbıb geeb qeebaxhe. Uleppışik'le g'acuyle ğayrı, iyesiys medın hucoona axva? ");
INSERT INTO tkr_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Xıleppışika iş g'ooceng'vee geedıd, k'ıldad otxhunee, mang'un nyak' ittuda eyxhe. Vuxhun gyavts'una karnanamee, tyulee ittiyk'al axvana. ");
INSERT INTO tkr_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Zak'le xəək avud insanılqa ı'qqən sa xədın divanıd g'acuyn: iyesee kar se'eeyid, mang'ulqa ver abayle – ");
INSERT INTO tkr_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","sa devxhesde işen mang'un kar ak'an ha'a. Mane karane iyesiys dix ıxhamee, mang'us helesın kar axva deş. ");
INSERT INTO tkr_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Nəxüriy mana yedike ts'eler ıxha, həməxürur ine dyunyeençe əlyhəəs. Mana geer qorxveeyir, cuka vuççud qıkkees əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","Manıd insanılqa ı'qqən sa xədın divan vod: insan dyunyelqa nəxüriy qarayle, həməxürur ayk'anna. Mıtsıs hav'uyne işike mang'us hucoona? ");
INSERT INTO tkr_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","Gırgıne gahbışilycad cun g'ık, miç'axiyvalee, dağamiyvalee, ık'arbışee, qəlıka oyxhan. ");
INSERT INTO tkr_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","Qiyğa zalqa hitxhıriyn, insannemee otxhun-ulyodğuy yugda, qotkuda eyxheyiy. Allahee sa-q'öne yiğıs huvuyne ı'mree, xəək avur qorxuyke kef qığehecen. Mang'us axvasın man vod. ");
INSERT INTO tkr_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","Allahee şavusmecad geed kar huvuxhee, man oxhanas, cuna pay alyapt'as, cune qorxuyke kef ts'ıts'a'as hassırxhee, mana Allahna pay vobna. ");
INSERT INTO tkr_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","Məxrıne insanın yik' Allahee şad ha'ava, mang'vee cune ı'mrena k'ılyba haa'a. ");
INSERT INTO tkr_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","Zak'le xəək avud sa medınıd insanaaşilqa ı'qqən divan g'acuyn. Man insanaaşik qitxhuyn divan geed yı'q'ı'n vodun: ");
INSERT INTO tkr_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","məxrına insan vorna Allahee mang'us kar, xəbvalla, ules ıkkanan gırgın helen. Saccu mane karake mang'us otxhun-ulyoğas haysar deş. Sa dyats'anecad insanee mang'un kar oyxhan. Manıd q'əran vuççud deşin kara idyalesın, vuk'lelqa adıyn divan vodun. ");
INSERT INTO tkr_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","Sa insanıqa vəş uşax ıxha, mang'vee xıliyna ı'mı'rıb hav'una. Mang'vee nimeena ı'mı'r hav'eeyib, mang'uk'le mısacad yiğ g'acu deş, mana k'eyxhır deş. Məxrıng'une hək'ee zı invaniy eyhes: qik'u yedike ıxhayn uşax mang'ule yugda eyxheyiy. ");
INSERT INTO tkr_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","Mang'un yedike ıxhay ıxha-ayk'anne booğak akar vod. Mana miç'axiyvalee agu ayk'anna, mang'un doyud ağmiş ha'a deş. ");
INSERT INTO tkr_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","Mang'uk'le verığın aq'vad g'ece deş, vuççudud ats'axhxhe deş. Məxdıne uşaxna vaxxariyvalla şene insanıle geeb vooxhe. ");
INSERT INTO tkr_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","Mane insanee q'öne yəqqees aazır sennana ı'mı'r hav'eeyib, mang'uk'le yiğ g'ıdecuxheene, mang'us mançike hucoona? Nekke qiyğa manbışin gırgınbı sa cigeeqa əlyhəəs. ");
INSERT INTO tkr_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","İnsan cune vuxhnenemee qoxa, meeb mang'una ul aats'e deş. ");
INSERT INTO tkr_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","K'orane ək'elynang'un, bəç'ərıle ooqan ciga hucoone? Kar deşing'usse vuceecar vuc mebınbışde ögiyl ıkkees əxəxhee, mang'us mançike hucoona hixharas? ");
INSERT INTO tkr_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","Vodunçis şadxhay, deşin t'abal hı'iyle yugda vod. Manıd q'əran vuççud deşin kar vodun, mıtsıqab qihna g'adapxhıniyk akar. ");
INSERT INTO tkr_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","Vonne gırgınçis, doyud huvu vodun. İnsanır hucoo ıxhay ögiylycad ats'a. İnsanısse cule Gucnang'uka xıliyn ha'as əxə deş. ");
INSERT INTO tkr_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","Nimee geer yuşan he'ee, manimeeyid q'əran cuvab ixhes. Mançike insanıs hucoona hixharas? ");
INSERT INTO tkr_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","Şavuk'lene ats'a, əq' xhinne ı'lğəəne, cit'ane, q'ərane ı'mree insannemee yugun hucooniyxan? Şavusse insanık'le eyhes əxəyee, cule qiyğa xəək avud hucoobıniyxan ixhes? ");
INSERT INTO tkr_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","Yugun do yugne ətriyatıle, qek'an yiğıd, yedike ıxhayne yiğıle yugda vod. ");
INSERT INTO tkr_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","Ak'nane xaaqa hark'ıniy, otxhun-ulyodğuynane xaaqa hark'ıniyle yugda vod. Qik'uy gırgıng'une vuk'lel vodun, hasre üç'ürung'vee man yik'el aqqecen. ");
INSERT INTO tkr_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","Aq'va qı'iy, əqəna hı'iyle yugda vod. Aq'va qı'iy insanne yik'enemee yugda vod. ");
INSERT INTO tkr_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","K'orane ək'elynang'un yik' ak'nane xaa axva. Beynyavaynme yik' otxhan-ulyoğane xaa. ");
INSERT INTO tkr_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","K'orane ək'elynang'une güxül k'ırı alixhxhiy, beynyavayn ğu yug hı'iyle yugda vod. ");
INSERT INTO tkr_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","Beynyavayn əqəna, k'umk'umuk avud gyotxhanne zazane sesık akar. Manıd q'əran vuççud deşin kar vodun. ");
INSERT INTO tkr_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","K'orane ək'elynang'vee insanaaşike gucuka kar alyaat'axhee, manar beynyavalqa siyk'al. Rüşvatınır insan yəqqı'le qığayhe. ");
INSERT INTO tkr_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","Sa karan ç'əvxhay, mançine gidğılıyle yugda vod. Sabırıkana insan vuceecar-vuc hagvang'ule yugna vor. ");
INSERT INTO tkr_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","Zaraba qəl hımaa'a, qəl beynyavabışde yik'eexhe vooxhena. ");
INSERT INTO tkr_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","«Nya'a ılğeeç'uyn yiğbı inçile yugda ıxhava?» qimiyghan. K'orana ək'el vuxhayke məxdın kar qiyghan deş. ");
INSERT INTO tkr_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","K'orane ək'elynane insanıqa kar geednang'a sık'ıldad yugda eyxhe. Mançin q'öyüd sana ıxhay verığ g'oocene gırgıng'uneme yugda vod. ");
INSERT INTO tkr_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","K'orane ək'elinır, pılın xhinne insan havacena. Ats'aalike insanıs in hiyxhar: k'orane ək'elin çine iyesiyna ı'mı'r havaace. ");
INSERT INTO tkr_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","Allahne işiqa ilyakke: Mang'vee k'yoç'an hı'iyn şavusse qotku qa'as əxəyee? ");
INSERT INTO tkr_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","Yugne yiğbışee şadra ixhe, pisde yiğbışilid in ats'axhxhe: inıd, şenıd Allahee itxhın, insanık'le cule qiyğa ixhesınbı mats'axhxhecenva. ");
INSERT INTO tkr_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","Yizde q'ərane ı'mree zak'le geed kar g'acu: qorkuna insan, cune qorkuvaliqa ilydyakkı, qek'ana, pisde insannab, cune pisvaliqa ilydyakkı, ı'mı'r xıliy qooxhe. ");
INSERT INTO tkr_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Geerır qorkura mexhe, ğucar ğu geerır k'orane ək'elika hımagva. Nişil-allane ğucad vakın ha'as? ");
INSERT INTO tkr_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Geerır pisra mexhe, bəç'ərra mexhe. Nişil-allane ğu gah qidyabıcar qik'as? ");
INSERT INTO tkr_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","İna mı'sləhət yik'el avqee yugba vob, manasab yik'el hivxan hımaa'a. Allahıle qəyq'ənang'vee q'önçulysana k'ırı iliyxhen. ");
INSERT INTO tkr_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","K'orane ək'elin, ək'elynane insanıs, şaharee vooxhene yits'ne xərıng'ule geeb gucxhe hoolena. ");
INSERT INTO tkr_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Məxrına qorkuna insan deşda, mang'vee saccu yugvallacab hee'ecen, bınah hımaa'acen. ");
INSERT INTO tkr_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","İnsanaaşe eyhene gırgınçilqa fıkır hımoole. Manke vak'le yiğne nukaree vaqa hokanıd g'ayxhes deş. ");
INSERT INTO tkr_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","Vak'le yugda ats'a vod, ğunad menne insanaaşiqa geed hoku. ");
INSERT INTO tkr_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","Man gırgın zı k'orane ək'elika siliys ı'xı'. «Zı k'orane ək'elikana ixhesva» uvhu. K'orana ək'elyme zake əq'əna vuxha. ");
INSERT INTO tkr_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","Ixha atk'ıniyn karbı şake əq'əna, geed k'orada vod. Manbı şavuk'le iveekeyiy? ");
INSERT INTO tkr_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","Zas k'orana ək'eliy ats'al t'abal ha'as, xət qıxhes, ats'axhxhes ıkkan. Zas pisde insanaaşina beynyavallayiy ək'el deşinbışda bəç'əriyvalla vaats'a vuxhes vukkan. ");
INSERT INTO tkr_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","Zak'le ats'axhxhayn, merıng'us gugu hav'una zəiyfa qik'uyle q'ap'ıra vor. Məng'ı'n yik' torak, xıleppıd zincirık akar. Allahne ulesqa yugra qarına insan məng'ı'le hexvana. Bınahnaname insan məng'ı'sqa gixhasda. ");
INSERT INTO tkr_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","Mə'əllimee eyhen: zı gırgınçiqa sassadna ilyakkımee, manke ats'axhxha. ");
INSERT INTO tkr_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","Zı t'abal he'eeyid, aveykı deş: aazır adamiyne yı'q'nee sa qorkuna aveykı, manimeene zəiyfayne yı'q'neeme – sa qorkuna aveykı deş. ");
INSERT INTO tkr_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","Zalqa saccu sa kar hitxhır: Allahee insanar qopkuba ipxhın, manbımee alytipk'ılıynbı. ");
INSERT INTO tkr_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","Şavusse k'orane ək'elynane insanıka sa ixhes əxəyee? Eyxhene karbışda mə'na şavuk'lene vaats'a? K'orane ək'elin insanne aq'vays nur hele, kışşin aq'va g'üvəna qa'a. ");
INSERT INTO tkr_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","Zı vak'le eyhen: ğu Allahıs k'ın g'assırva, paççahee eyhen he'e. ");
INSERT INTO tkr_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","Paççahısse cus ıkkanan gırgın ha'as əxən. Mançil-allar zaara mang'une uleke agvle. Mane dağamne cigee ımaxva. ");
INSERT INTO tkr_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","Paççahne cuvabee guc vob. Şavusse mang'uk'le «Ğu ha'an hucooneva» eyhes əxəyee? ");
INSERT INTO tkr_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","Mang'vee uvhuyn hı'iyng'ulqa ver ables deş. K'orane ək'elynane insanık'le qopkuna gahıb, nəxüd hı'iyid ats'an. ");
INSERT INTO tkr_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","Gırgıne karaqa çina gah, çina qopkuna yəq vob. İnsannemee vuk'lelqa geed verbı adayle. ");
INSERT INTO tkr_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","İnsanık'le vuk'lelqa hucoome qales ats'a deş, şavusse mang'uk'le eyhes əxəyee, hucooyiy ixhesva? ");
INSERT INTO tkr_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","Nəxbiy mıts insanısse avqas dəəxə, həməxüdud qik'asın yiğ əq'əna qa'as əxə deş. Esker dəv'eençe xaaqa g'ıdekkan xhinne, pisvalisser pisda insan g'attixhana'as əxə deş. ");
INSERT INTO tkr_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","Man gırgın zak'le g'acuyn, xəək avud g'ecene gırgıne işbışiqa yugra ilyakkına: sa insanee manesa insanaaşis xəbvalla haa'amee, mane insanaaşilqa ver abayle. ");
INSERT INTO tkr_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","Qiyğa zak'le hapt'ıyn pisın insanar k'eebaxhe g'avcu. Man insanar muq'addasne cigeeqa abı-avayk'an vuxha. Mane şaharee manbışik'le yugunbıva eyhe ıxha. Manıd q'əran vuççud deşin kar vodun. ");
INSERT INTO tkr_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","Pisvalla hav'uyng'us cazaa cigeecab g'its'dyaak'vanang'a, insanaaşis sık'ılbab geeb pisvalla haa'as vukkiykan. ");
INSERT INTO tkr_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","Pisde insanee vəşne yəqqee pisın hı'ı, xıliyna ı'mı'r haa'a. Zak'leme ats'an, Allahıle qəvəyq'ənanbışik'le yugvalla g'avcesva. ");
INSERT INTO tkr_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","Pisde insanık'le yugvalla g'avces deş. Mana Allahıle qı'dəyq'ənva, mang'una əqqı'k akarana ı'mı'rıb xıliy qaa'as deş. ");
INSERT INTO tkr_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","İnəxdınıd ç'iyene aq'val q'əran vuççud deşin kar vodun: qopkune insanaaşis gexhan karbı pisde insanaaşis eyxhe, pisde insanaaşis gexhan karbıd qopkune insanaaşis eyxhe. Zı uvhuyn: «Manıd q'əran vuççud deşin kar vodun!» ");
INSERT INTO tkr_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","Məxüb zı xoşbaxtıyvalla gırgınçile ooqa avqu. Xəək avud insannemee otxhun-ulyodğuyleyiy xoşbaxtiyvalile yugun kar deşin. Allahee xəək avub insanıs ı'mı'r huvu. Mane ı'mree qorxuyiy xoşbaxtıyvalla alivkasda. ");
INSERT INTO tkr_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","Zıcar zı g'aysırna k'orana ək'eliy insanaaşe ha'an işbı xət qeetxhes. Xəm-yiğ yizde ulyaqa nyak' idyatk'ın, zı mane işbışiqa ilyakkı. ");
INSERT INTO tkr_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","Manke zak'le Allahın gırgın işbı g'acuynbı. Zak'le ats'axhxhayn, şavulqacad xəək avud g'ecen işbı hixharas deş. Nimeecar mana qorxveeyir, mang'ulqa meed hixharas deş. K'orane ək'elynane insanee man cuk'le ats'anva uvheeyid, meed man mang'ulqa hiyxhar deş. ");
INSERT INTO tkr_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","Mane gırgınçina zı hav'u, ine fıkrelqa qarı: qopkuynbı, k'oran ək'elynanbıyiy manbışe ha'an gırgın işbı Allahne xıle vod. İnsanık'le vuc ıkkiykanasdame, g'ımeceme ixhes ats'a deş. ");
INSERT INTO tkr_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","Gırgıng'une vuk'lelqa sa kar qales: qopkuynbışde, pisınbışde, yugunbışde, məttınbışde, gicərxı'y deşinbışde, q'urban ablyaa'anbışde, q'urban g'idyook'anbışde. Yugne insanık eyxhen, bınahnang'ukud eyxhen. K'ın g'iysarang'uk eyxhen, k'ın g'aysaras qəyq'əng'ukud eyxhen. ");
INSERT INTO tkr_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","Xəək avub vooxhene gırgıng'une vuk'lelqa in pisın divan qadayle. Hək'edad, insanaaşin yik'bı pisvalika gyatsts'ı vod. Nimeena ı'mı'riy haa'a, manimeeyib manbışe bəç'əriyvalla haa'a. Qiyğaleb hapt'ı avayk'ananbı. ");
INSERT INTO tkr_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","İnsanee nimeena ı'mı'r hav'ee, mang'unemee umud vobna. Üç'übna xvaa qik'uyne şirıle yugba dişde vob? ");
INSERT INTO tkr_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","Üç'übınbışik'le hapt'asva ats'an, hapt'ıynbışik'leme vuççud ats'a deş. Manbışis helen-qelenıd ixhes deş, manbı yik'el hipxınva. ");
INSERT INTO tkr_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","Hapt'ıynbışin vukkiykın vuxhayib, g'umooce vuxhayib, manbışiqa naps ıxhayid deşxhayn xhinnee atk'ınin. Xəək avud g'ecene işbışee, manbışda xıl mısacab vuxhes deş. ");
INSERT INTO tkr_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","Gıney xoşbaxtda oxhne, çaxırıd şadne yik'eka ulyoğe. Man Allahne yik'eençe vod. ");
INSERT INTO tkr_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","Hasre yiğne tanalin gırgıne gahbışil cagvarada ixhecen, vuk'lelin ətriyyatıd k'ıl qimexhecen. ");
INSERT INTO tkr_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","Xəək avud Allahee vas huvuyn gırgın yiğbı yikkanne xhunaşşeyka yugda alğehe. Yiğna ı'mı'r sık'ınne gahıs ıxha-ayk'anne booğak akar. I'mreke, xəək avur qorxuyke vas axvasın man vod. ");
INSERT INTO tkr_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","Vasse əxən gırgın he'e. Ğu əəsde ahalee işniy, fıkırniy, ats'alyniy, k'orana ək'elyniy vuxhes deş. ");
INSERT INTO tkr_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","Xəək avud zak'le sa medın karıd g'acuyn: G'adapxhınee hammaşe yugra g'adayxhvanna deş ğamexhe. Dəv'eeyib hammaşe igidyar deş ğameebaxhe. Gıney hammaşe k'orane ək'elynanbışiqa geed deş eyxhe, karıd ək'elynanbışiqa hammaşe geed eyxhen deş. Hı'rmatıb aalimaaşis deş haa'a. Gırgın vaxtıkeyiy xıleqa gipxhıyne imkanıke eyxhe. ");
INSERT INTO tkr_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","İnsanık'le cuna gah mısa qavaales vuxhay ats'a deş. Baluğar g'ıttidiyxhanasde toreeqa, şit'yarıd gugeeqa gyadak'van xhinne, insanılqab ver abıyn yiğxhe eyxhe, sayangada vuk'lelqa qadaylen. ");
INSERT INTO tkr_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","Zak'le xəək avud medınıd k'orane ək'elika hı'iyn xədın kar g'acuyn. ");
INSERT INTO tkr_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","İnsanar k'ılyba vooxhena şahariy. Sa gucnana paççah mane şaharılqa arı, mana hiqiy-allançe avqaaqqana. Mana avqas vuxhecenva mane şaharne hiqiy-alla xılece işbıd g'ecenbı. ");
INSERT INTO tkr_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","Maa'ar kar deşda, k'orane ək'elikana insan eyxhe ıxha. Mang'vee cune k'orane ək'elika şahar g'attivxhan haa'a. Mançile qiyğa mana şavuscar yik'el qarayle deş. ");
INSERT INTO tkr_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","Mane gahıl zı uvhuyn: «K'orana ək'el gucule yugba vob». K'orane ək'eliqane kar deşde insanıqa ooğançe avqa ilyaaka, mang'vee eyhen cuvab neng'veecad qizar ha'a deş. ");
INSERT INTO tkr_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","G'idiyxhe eyhen k'orane ək'elikang'un cuvab, bəç'əraaşine xərıng'une ts'irıle yugda g'iyxhe. ");
INSERT INTO tkr_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","K'orana ək'el silahıle yugba vob, sa bınahınmee geed yugun agval ha'a. ");
INSERT INTO tkr_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","Sa qivk'uyne xı'nit'iyn yugne ətirıkın ha'an. Həməxdıd k'ınne bəç'əriyvalin k'orane ək'elikıniy hı'rmatıkın ha'an. ");
INSERT INTO tkr_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","K'orane ək'elynane insanne yik'en qorkune suralqa ts'ıts'a'a, bəç'ər insanneme yik'en quç'orkune. ");
INSERT INTO tkr_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","Mang'una bəç'əriyvalla yəq' əlyhəəng'əb vaats'a vooxhena. Gırgıng'uk'le mana nimee bəç'ər ıxhay g'ecen. ");
INSERT INTO tkr_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","Xərıng'una valqa qəl avqee, himexva. Cusse vuc aqqas əxəng'une geebne bınahbışike ılyheebaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","Xəək avub zak'le sa mebna verıb g'avcuna: qotkuda hidi'iyn kar cuke paççahıke vodun. ");
INSERT INTO tkr_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","Ək'el deşinbı ç'ak'ıne işbışilqa giviyxhe, karnanbışeme avudun cigabı aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","Zak'le nukarar balkanıl oo, ç'ak'ınbıb nukarar xhinne iviykar əlyhəə g'avcu. ");
INSERT INTO tkr_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","Xandak' ilyviyk'arna xandak'eeqa k'eyxhas əxə. Çabır qoytalang'ukub xoçe üvxəs vəəxə. ");
INSERT INTO tkr_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","G'aye gyabaxanar g'ayeysse qoxa'as əxə. Os qaxanar osasse qoxa'as əxə. ");
INSERT INTO tkr_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","Yak'v ek'da deşxhee, man ek'a'asıd hidevuxheene, mançis geeb guc əlyhəəs. K'orane ək'elisseme man kar qa'as əxə. ");
INSERT INTO tkr_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","Xoçe avqas vəəxəna ayresse xoçe üvxee, mana nişiscarne qoyt'al. ");
INSERT INTO tkr_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","K'orane ək'elynane insanne ghalençe yugun cuvabxhe qığeç'en. Ək'el deşing'une mizenmee mang'ukun ha'anxhe. ");
INSERT INTO tkr_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","Mang'un yuşan hı'iyid ək'el deşvalika giyğal. Yuşan hı'iyid xənne bəç'əriyvalika ç'əvexhe. ");
INSERT INTO tkr_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","Ək'el deşda insan geerxhe yuşan ha'ana. Şavuk'lecadıd vuk'lelqa qalesın ats'a deş. Şavusse cule qiyğa hucoo ixhesınçina eyhes əxəyee? ");
INSERT INTO tkr_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","Ək'el deşinbışe ts'ıts'av'uyne əq'übayn, cocab oozar haa'a. Manbışik'le şaharılqa əlyhəəna yəqı'b vaats'a deş. ");
INSERT INTO tkr_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","Yiğna paççah nukaraaşine nasılınaxheene, ç'ak'ınbıb miç'eeb çakba, otxhan-ulyoğa giviyğalxhee, ölka, vay vak ixhesın! ");
INSERT INTO tkr_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","Yiğna paççah qıvaats'ıyne nasılınaxheene, ç'ak'ınbışed çine gahıl, ulyoğasva deş, guc saa'asva otxhanxhee, ölka, vaqa yugun yiğbı ixhes! ");
INSERT INTO tkr_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","İnsan tambalraxhee, mang'una daxaxhe giviy'arna. Nenacab iş g'idevceene, xaane daxayle xhyan k'yak'anas. ");
INSERT INTO tkr_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","Otxhun-ulyodğuy yik'es ıkkanva ha'a, çaxıren ı'mı'res rang hele. Pılınmee vas ıkkanan gırgın ha'an. ");
INSERT INTO tkr_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","Paççahıqa yik'eeyid humoka, karnane insanne hək'ee ğu g'ılexhane cigeeyid pisın immeyhe. Xəə ileedaxvane şit'yaaşe xabar vukkees, mançisse ğu uvhuyn cuvab hixhar ha'as əxə. ");
INSERT INTO tkr_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","Yiğın gıney xhinel ooqa g'aykke, xılece gah ılğevç'uyle qiyğa, vak'le man meed aveykesın. ");
INSERT INTO tkr_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","Yighneyee, molyneyee insanıs vaqa vodunçike pay hevle. Vak'le ölkayne vuk'lelqa ablesda verıb vaats'a deş. ");
INSERT INTO tkr_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","Buludbı xhineka gyatsts'ı ixhee, mançin ç'iyene aq'valqa gyoğiy gikkas. Yiv canubulqayee, şimalılqayee hı'ğəpkıree, mane qukk'yopk'ulne cigeeyib aaxvasda. ");
INSERT INTO tkr_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","Mıtsıqa ilyakkang'vee toxum üvxüyxəna deş. Buludbışiqa ilyakkang'ussed ezuyn qiyşalas əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","Vak'le mıtsın yəqbı ats'a deş, vuxhnene zəiyfayne vuxhne nəxüdiy bark'vbıd ç'ak'ı qeetxhay şavuk'lecad ats'a deş. Məxı'dıd vas gırgın itxhınne Allahne işbışike xabar deş. ");
INSERT INTO tkr_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","Toxum miç'eeb üvxe, exhalilqameeyid xıleppı iş dena g'ılyma'a. Vak'le ats'a deş inme, şenme şagav yugda ixhes, deşxheene, q'öyudsaname yugda ixhes. ");
INSERT INTO tkr_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","Hək'edad işix micagda vod, verığ g'avciy uleppışisqa yugba qöö. ");
INSERT INTO tkr_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","İnsanee xıliyna ı'mı'r haa'axhee, hasre şadba hee'ecen. Pisın yiğbı ıxhayid yik'el hixan hıma'acen, pisın yiğbı geedbı ixhes. Vuk'lelqa qalesın gırgın kar q'əran vuççud deşin kar vod. ");
INSERT INTO tkr_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Şadxhe mek'vna, nimeeletteyiy mek'vra. Mek'vranang'a yiğın yik' şade'e. Yik'es ıkkanne, uleppışik'le g'ecene cigeeqa hoora. Vak'le manıd ats'axhxhe, mane gırgınçil-alla Allahee ğu məhkameeqa ts'ıts'a'as. ");
INSERT INTO tkr_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Mançil-allad aq'va qıma'a, ık'arbı vake əq'əna hee'e. Mek'vallab, mek'valeena gucub ıxha-ayk'anne booğak akar. ");
INSERT INTO tkr_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Mek'vranang'a ğu İrxhınna yik'el qale'e. Qiyğa pisın yiğbı qadımee, ğu eyhesın: «Həşde yizın kef nişikecad ooqa qexhe deş». ");
INSERT INTO tkr_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","Manke verığın, vazın, xənebışin işix yiğnemee k'ətqəsın, gyoğiyle qiyğa, meed buludbı sak'alas. ");
INSERT INTO tkr_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","Man yiğ qadımee, xaaka ilyaakanbışik zeze avkkas, gucnanbı k'yooç'anasınbı, giviyxəranbışisse co k'ılybava suk giviyxəras vəəxəs deş, g'uleppışile ilyaakanbışik'le miç'axda g'aces. ");
INSERT INTO tkr_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","G'aqa aaqan akkabı it'umeedxhesınbı, yöxxəbışin sesbı k'ıl qeetxhes. Ğu şit'yaaşine sesbışikar çikana muğur qıxhes, mə'niybı qədəqqəne içeeşin k'ılda g'ayxhes. ");
INSERT INTO tkr_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Ğu manke axtıne cigabışile qəq'ənasda, yəq əlyhəəsır qəq'ənasda. Badamne yiven t'et' g'ayhe, ts'irtyar yı'q' qeetxhes, naps k'ıl qixhes. Məxür insan cune gırgıne gahbışilyne xaaqa əlyhəə, ak' avquynbı şahrabışeeqa k'yoohar. ");
INSERT INTO tkr_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","Nuk'rayn baağar qudyodu, k'ınəəğəyna kasa hidyapq'ır, xhyan ı'lqəəne cigaysneedın parç xüvə-xüvəna qıdexha, kahrızılin çarx hidyatq'ur ğu İrxhınna yik'el qale'e. ");
INSERT INTO tkr_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Manke nyuq'vneke hıiyn tan nyuq'vnelqa sak'alas, ı'mren nafasıd yic huvuyne Allahısqa sak'alas. ");
INSERT INTO tkr_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Mə'əllimee eyhen: – Q'əran vuççud deşin kar! Gırgın ıxha-ayk'anne booğak akar vod! ");
INSERT INTO tkr_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Mə'əllim k'orana ək'elynana insan ıxha, mang'vee milletıs ats'aalid hele ıxha. Mang'vee geeb fıkır opxhun, geed ək'elikan kar qiyghın, geed misaalabı sı'ı, otk'un. ");
INSERT INTO tkr_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","Mə'əllimıs micagın uvhiybı t'abal ha'as ıkkiykın. Mang'vee otk'uninbı qotkuda hək'eda vod. ");
INSERT INTO tkr_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","K'orane ək'elynanbışe eyhenbı çobanna çümq xhinne, manbışe sı'iyn cuvabbıd it'umda ı'xiyn g'adaxbı xhinne vod. Man eyhen cuvabbı sa çobanee uvhuynbı vod. ");
INSERT INTO tkr_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Mançile ğayrı, dix, ğu inçilqa fıkır hevle: nimeen ıxhay kitabbı ok'anas eyxhe, geed qətqiynır insan ozarxhe ha'ana. ");
INSERT INTO tkr_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Həşde ğu nekke qiyğiyne cuvabıl k'ırı alixhxhe: Allahıle qəq'ne, Mang'vee eyhen he'e. İnsanee ts'etta ha'asın man vod. ");
INSERT INTO tkr_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","Allahee gırgın işbı, dyugulenın gırgın kar – yugun ixheeyid, pisın ixheeyid – məhkameençe alğahas.");
INSERT INTO tkr_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","Yahudayne paççahee Yehoyakimee paççahiyvalla haa'ane xhebıd'esde sen, Baabilyna paççah Navuxodonosor, cune g'oşunuka İyerusalimısqa qarı. Mang'una g'oşun şaharne hiqiy-alla ulyoozar, mana avqas vukkiykan. ");
INSERT INTO tkr_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","Xudaavandee Yahudayna paççah Yehoyakim Navuxodonosorusqa qele. Navuxodonosoree Allahne Xaançe sabara karbıd alyaat'anbı. Navuxodonosoree manbı Şinareeqa, Baabilyva eyhene cigabışeeqa, cune byutbışde xaaqa qıkkı, maane xazineeqa giyxhe. ");
INSERT INTO tkr_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Qiyğa paççah Navuxodonosoree cune sarayne işçeeşine vuk'lel ulyorzulyne Aşpenazılqa əmr haa'a: «Paççahne nasılençenbıyiy qıvaats'ıyne İzrailyne xizanbışeençen, ");
INSERT INTO tkr_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","vuk'dyak'aran, micagın, ək'elikan, ats'alynan, kar xət qıxhes əxəsın, sarayee paççahıs, paççahee eyhen ha'as əxəsın mek'vunbı see'e. Manbışis ğu Baabilyna miziy kitabbı xət qe'e». ");
INSERT INTO tkr_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Paççahee manbışis vucee otxhanne otxhuniykeyiy çaxırıke yiğısiysta pay curaa'a. Manbışed xhebılle senna qətqı'yle qiyğa, paççahıs xidmat haa'aniy givğalas. ");
INSERT INTO tkr_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","Mang'vee sav'uynbışika sacigee cühütyar Daniyal, Xananya, Mişael, sayır Azarya eyxhe. ");
INSERT INTO tkr_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","Paççahne işçeeşine vuk'lel ulyorzuling'vee manbışis medın dobı giyxhe: Daniyalılqa Belyteşassar, Xananyalqa Şadrak, Mişaelilqa Meşak, Azaryalqad Aved-Nego. ");
INSERT INTO tkr_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","Daniyalee culed-alqa eyhen: «Zıcar zı paççahee otxhanne otxhuniykayiy mang'vee ulyoğane çaxıreka mı'q'ı' qidya'as». Vucecar vuc mı'q'ı' qıdyı'iynemee, mang'vee sarayne işçeeşine vuk'lel ulyorzuling'ulqa ghal aaqa. ");
INSERT INTO tkr_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","Allahee həməxüd ha'a, Daniyal sarayne işçeeşine vuk'lel ulyorzuling'une ulen aqqaqqana, mana mang'usqa yugra qarayle. ");
INSERT INTO tkr_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","Sarayne işçeeşine vuk'lel ulyorzulyung'vee, Daniyalık'le eyhen: – Şos otxhuniyiy çaxır heleva uvhuyne yizde xərıng'ule, paççahıle zı qəyq'ənna. Paççahne ulesqa şu manesa mek'vunbışile zaifba qabee, manke mang'vee yizda vuk'ul g'ats'aak'vanas. ");
INSERT INTO tkr_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","Sarayne işçeeşine vuk'lel oo ulyorzulyung'vee, Daniyalne, Xananyanne, Mişaelyne, Azaryanne vuk'lel ooqa insan giyxhe. Daniyalee mang'uk'le eyhen: ");
INSERT INTO tkr_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","– Qora ğu, yits'ne yiğna şi, yiğın nukarar, siliys üvxe. Hasre şas, oxhanas saccu alyadıynçike allecen, ulyoğasıd xhyan helecen. ");
INSERT INTO tkr_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","Nekke qiyğab ilyaake, şiyee aq'vayle yugba deşxheene, paççahın kar otxhanan mek'vunbıyee. Mançile qiyğa vas nəxüdiy ıkkan həməxüdud he'e. ");
INSERT INTO tkr_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","Mana manbışe eyhençilqa qarı, manbı yits'ılle yiğna siliys üvxiyxə. ");
INSERT INTO tkr_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","Yits'ne yiğıle manbı, paççahın otxhuniybı otxhunne, maane menne mek'vunbışile yugbab, ç'ak'ıbab g'ooce vuxha. ");
INSERT INTO tkr_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","Man g'acu, mane nukaree, manbışin paççahee helen otxhuniyiy çaxır, manbışisse g'ayşu, alyadıynbı hele. ");
INSERT INTO tkr_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","Allahee mane yoq'ne mek'vung'us ats'al, ı'limbı ats'axhxhesda ək'el huvu. Daniyalıs gyagvad ıxhayn, nik'ek g'acuynıd hucoo eyheniyva eyhesıd əxı'yn. ");
INSERT INTO tkr_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","Paççah Navuxodonosoree manbı cusqa ableva eyhen yiğ qadı hitxhıriyng'a, sarayne işçeeşine vuk'lel ulyorzulyung'vee manbı paççahısqa abayle. ");
INSERT INTO tkr_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","19","Paççah manbışde gırgıng'uka yuşan ha'ana, mang'uk'le manbışde yı'q'nee Daniyalıka, Xananyayka, Mişaelika, Azaryayka sa aqqasda merna iveeke deş. Mançile qiyğa manbı paççahısqa işilqa alyabat'a. ");
INSERT INTO tkr_vpl VALUES ("DN1_20","028_1_20","DAN","1","20","20","Paççahee manbışike gırgıne ats'alybışdeyiy ək'elikane karbışde hək'ee qidghın hı'ımee, g'ecen, manbışik'le cune ölkeene gırgıne sehırbazaaşileyiy cadubı ha'anbışile yits'ne yəqqees geedıd ats'a. ");
INSERT INTO tkr_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","Daniyal Kir eyhene paççahee, paççahiyvalla haa'asde senilqamee maa axva. ");
INSERT INTO tkr_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","Navuxodonosoree paççahiyvalla haa'ane q'öd'esde sen, mang'uk'le nyak'bı g'ece. Mançile qiyğa mang'un yik' sacuray qa'a, nyak'cad hexva. ");
INSERT INTO tkr_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","Paççahee əmr haa'a, cuk'le nik'ek g'acuyn nen eyheyiyva ats'axhxhesva, mang'vee cusqa sehirbazar, nyak'bı qa'as əxənbı, cadubı ha'anbı, sayıb Baabilin k'oran ək'elynan insanar qoot'leva eyhe. Manbı paççahısqa sabıyng'a, ");
INSERT INTO tkr_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","mang'vee manbışik'le eyhen: – Zak'le sa nyak' g'acu, mançinıd yizın yik' sacuray qa'a. Zas ats'axhxhes ıkkan, man hucoo eyheniy. ");
INSERT INTO tkr_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","Baabilyne k'orane ək'elynanbışe, paççahıs Arami mizel alidghıniy qele: – Paççah, geer qa'ana! Vak'le g'acuyn nyak' şas, yiğne nukaraaşis, yuşan he'e, şinad eyhes man nenva eyheniy. ");
INSERT INTO tkr_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","Paççahee manbışik'le eyhen: – De'eş! Zı inəxüd ha'as: şu zak'le nik'ek g'acuynud, yizın nyak'ıd nen eyheniyva ittevheene, şoke xüvəbı ha'as, vuşun xaybıd yı'qqı'lqa sak'al ha'as. ");
INSERT INTO tkr_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","Şu zak'le nik'ek g'acuynud, yizın nyak' nen eyheniyvad uvheene, zı mançil-alla şos paybı, mukaafatbı, xəbnab hı'rmat haa'as. Həşde şu zak'le nik'ek g'acuynud, yizın nyak' nen eyheniyvad eyhe. ");
INSERT INTO tkr_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","Manbışe meed alidghıniy qele: – Hasre paççahee şas, cune nukaraaşis, cuk'le g'acuyn nyak' yuşan he'ecen, şinad man nen eyheniyva eyhes. ");
INSERT INTO tkr_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","8","Manke paççahee eyhen: – Zak'le ats'an, şos vaxtcab xıliy qaa'as vukkan. Şok'le zı uvhuyn yugda ats'an: ");
INSERT INTO tkr_vpl VALUES ("DN2_9","028_2_9","DAN","2","9","9","yizın nyak' zas yuşan hidee'ene, şos sa caaza vuxhes. Vuşde ək'eleeqa qımaylecen, şu şoled-alqan karbı qığı'ı, zas horbı he'eene, zı qiyğa mançil-alla fıkır badal haa'as. Həşde şu zas nyak' yuşan he'e. Qiyğa zak'led ats'axhxhes, man nyak' nen eyheniy şosse eyhes əxəvudva. ");
INSERT INTO tkr_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","Baabilyne k'orane ək'elynanbışe paççahık'le inəxüd eyhe: – Ç'iyene aq'valycar, paççahee eyhen ha'as əxəna insan deşda. Nenecad paççahee, vuc nimee xərrar, gucukar ixheene, məxdın kar şehirbazaaşike, nyak'bı qa'as əxənbışike, Baabilyne k'orane ək'elynanbışike heqqiyn deşdiy. ");
INSERT INTO tkr_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","Paççahee eyhen kar geed dağamın kar vod. Man paççahık'le allahaaşile ğayrı şavussecad eyhes əxəs deş. Allaharmee insanaaşile əq'əna vooxhe. ");
INSERT INTO tkr_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","Man cuvab g'ayxhı, Baabilyna paççah əq'əna. Baabilin gırgın k'oran ək'elynanbı gyapt'ecenva mang'vee əmr haa'a. ");
INSERT INTO tkr_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","K'oran ək'elynanbı gyapt'eva əmr qığevç'umee, Daniyalıy cun hambazarıb gyapt'asva t'abal haa'a vuxha. ");
INSERT INTO tkr_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","Paççahne g'aravulyçeeşine oo ulyorzulyna Ariox, Baabilin k'oran ək'elynanbı gyapt'asva ı'qqəmee, Daniyal mang'uka k'orane ək'elika, ats'alika yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","Mang'vee Arioxuke qiyghanan: – Paççahee nya'asdiyxan inəxüb qəvəəq'ənasda əmr hav'u? Manke Arioxee gaf vuxhana xhinne Daniyalıs haa'ana. ");
INSERT INTO tkr_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","Manke Daniyal paççahısqa hark'ın, mang'uke cun nyak' nen eyheniyva, yuşan ha'asda gah hooqa. ");
INSERT INTO tkr_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","Daniyal xaaqa sak'ı, cune vuk'lelqa qadıynçine hək'ee hambazaaşis: Xananyeys, Mişaelıs, Azaryeys yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","Mang'vee manbışik'le eyhen: – Xəybışde Allahıke heqqe, Mang'una zas rəhı'm qabı, zı mançine sirrılqa hixhare'ecen. Manke şi, Baabilyne k'orane ək'elynanbı gyapt'as deş. ");
INSERT INTO tkr_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","Rəbbee, Daniyalıs xəmde man sir gyagva'an. Mançil-allab Daniyalee xəybışde Allahıs inəxüb şukur haa'a: ");
INSERT INTO tkr_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","– K'orana ək'eliy guc Mang'una vuxhal-alla Allahın do hammaşe axtıvalee ixhecen! ");
INSERT INTO tkr_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","Vaxtıy dyovur badal haa'ana Mana vor! Paççahar taxtılqa gyaa'anar, g'a'anar meer Mana vor. Mang'vee ək'elynanbışis k'orana ək'el, kar ats'anbışisıd ats'al hele. ");
INSERT INTO tkr_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","K'oraaleedın, dyugulenıd aaqana Mana vor, nurud Mang'uka vod, miç'axvaleedınıd g'ecenar meer Mana vor! ");
INSERT INTO tkr_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","Ğu zas k'orana ək'eliy guc huvil-alla zı Ğu axtı qa'a, zı Vas şukur haa'a, Yizde dekkaaşina Allah. Şi Vake heqqıyn kar, Ğu zak'le haguyn. Paççahın nyak' nen eyheniyva Ğu şak'le uvhuyn! ");
INSERT INTO tkr_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","Mançile qiyğa Daniyal Baabilin k'oran ək'elynanbı gyapt'ecenva paççahee gixhxhiyne Arioxne k'anyaqa arı, eyhen: – Baabilin k'oran ək'elikanbı gimabat'a. Zı paççahne k'anyaqa ıkkee, zı mang'us cun nyak' nen eyheniyva yuşan ha'as. ");
INSERT INTO tkr_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","Arioxee Daniyal mankecar paççahısqa ıkkı eyhen: – Zak'le paççahın nyak' nen eyheniyva, eyhes əxəsda aveykına. Mana insan Yahudeyeençe aqqı, qarıynbışda sa vorna. ");
INSERT INTO tkr_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","Paççahee Daniyalıke (mang'us mankilqasse Belyteşassarva do gixhxhı) qiyghanan: – Vasse zak'le g'acuyn nyak' yuşan ha'as əxəyee? Sayid man nen eyheniyva eyhes əxəyee? ");
INSERT INTO tkr_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","Daniyalee eyhen: – Nenecad k'orane ək'elynang'usse, cadu ha'ang'usse, nyak' qa'angusse, sehirbazısse paççahık'le g'acuyne nyak'ın sir, mang'us yuşan ha'as əxəs deş. ");
INSERT INTO tkr_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","Xəə'ədme, sirbı aaqas əxəna Allah vor. Mang'vee vuk'lelqa qalesınbıd paççah Navuxodonosoruk'le hagva. Ğu nik'eenang'a vak'le g'acuyn nyak'bı inəxdınbı ıxha: ");
INSERT INTO tkr_vpl VALUES ("DN2_29","028_2_29","DAN","2","29","29","Paççah, ğu yiğne tyulee g'alirxhuyng'a, yiğne fıkreençe ı'lğəə ıxha, vuk'lelqa hucooniyxan qales, inçile qiyğa nenniyxan ixhes. Sirbı Aaqqang'veeyid vak'le hucooyiy ixhesva haguyn. ");
INSERT INTO tkr_vpl VALUES ("DN2_30","028_2_30","DAN","2","30","30","Zı mane sirrılqa dyunyel gırgıng'ule ək'elikananava deş hirxhıl. Zı man nyak' paççahılqa hixhar he'ecenva, vak'led yiğne yik'eençe ı'lğəənbı ats'axhxhecenva, zas man nyak' aaqı. ");
INSERT INTO tkr_vpl VALUES ("DN2_31","028_2_31","DAN","2","31","31","Paççah, vak'le nik'ek sa xəbna haykal g'avcu. Geeb xəbna, qəvəəq'ənasda xhinnena, huç'omç'arna haykal yiğne ögee ulyobzur vuxha. ");
INSERT INTO tkr_vpl VALUES ("DN2_32","028_2_32","DAN","2","32","32","Mane haykalna vuk'ul məttıne k'ınəəğəyke, t'ap'anbıyiy xıleppı nuk'rayke, vuxhuniy umabıd yezake ıxha. ");
INSERT INTO tkr_vpl VALUES ("DN2_33","028_2_33","DAN","2","33","33","G'elybıd yivayke, mı'q'lebışinmee sık'ınin cigabı yivayke, sık'ıninbıd qoocune g'ı'bı'ne nyuq'vneke ıxha. ");
INSERT INTO tkr_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","Ğu mançiqa ilyakkane gahıl, xıl sidet'ucab çileb-alqa g'aye qopxu qabı, mançine yivaykeyiy g'ı'bı'ne nyuq'vneke hı'iyne mı'q'lebışis qipxhır manbı xüvə-xüvəna qa'a. ");
INSERT INTO tkr_vpl VALUES ("DN2_35","028_2_35","DAN","2","35","35","Mankecad yivayke, g'ı'bı'ne nyuq'vneke, yezake, nuk'raykeyiy k'ınəəğəyke xüvəbı ıxha, g'ı'lina attayl eyxhene balybiyk akara qaa'a. Qabıyne mıtsınıd man alixa'an, maa'ad mançike vuççud g'alyadaççe deş. Haykalıs qipxhırne g'ayeyke sa xəbna suva qooxhe, mane suvaynıd dyunyecad aqqaqqa. ");
INSERT INTO tkr_vpl VALUES ("DN2_36","028_2_36","DAN","2","36","36","Vak'le g'acuyn nyak' məxdın ıxha. Həşded paççahıs man nen eyheniyva yuşan ha'as. ");
INSERT INTO tkr_vpl VALUES ("DN2_37","028_2_37","DAN","2","37","37","Ğu paççahaaşina paççah vorna. Xəybışde Allahee vas paççahiyvalla, guc, xəbvalla, manimee xədın do huvu. ");
INSERT INTO tkr_vpl VALUES ("DN2_38","028_2_38","DAN","2","38","38","Mang'vee yiğne xılyaqa insanaaşina nasıl, çolun həyvanar, xəədın şit'yar quvu. Mane gırgınçina paççah, Mang'vee ğu hı'ı. Şena k'ınəəğəykena vuk'ul ğu vorna. ");
INSERT INTO tkr_vpl VALUES ("DN2_39","028_2_39","DAN","2","39","39","Qiyğa, vale avqana sa mebna paççahiyvalla vuxhes. Mançileb qiyğa yezakena, dyunyecad vuk'lek ıkkeesda, xheyıb'esda sa mebnab paççahiyvalla vuxhes. ");
INSERT INTO tkr_vpl VALUES ("DN2_40","028_2_40","DAN","2","40","40","Yoq'ub'esda paççahiyvallamee yiva xhinne it'umba vuxhes. Yivayn gırgın kar haq'var-hiyxvər ha'an xhinne, mane paççahiyvallinıd gırgın man paççahiyvallabı haq'var-hiyxvəra'asın. ");
INSERT INTO tkr_vpl VALUES ("DN2_41","028_2_41","DAN","2","41","41","Mı'q'lebışiniy g'elybışde t'ubaaşin sa sura qoocune g'ı'bı'ne nyuq'vneke, mansa surad yivayke ıxhay vak'le g'acuyn. Həməxbıb mana paççahiyvalla sura-surana vuxhes. Mançika yivayna it'umiyvalla vuxheeyib, g'ı'bı'na nyaq'v alivkiyıd vak'lecad g'acuyn. ");
INSERT INTO tkr_vpl VALUES ("DN2_42","028_2_42","DAN","2","42","42","Nəxüdiy g'elybışde t'ubaaşin sık'ınin ciga yivayke, sık'ıninıd g'ı'bı'ne nyuq'vneke ıxha, həməxdıd mane paççahiyvalin sa sura it'umda, mansa sura kavrakda ixhes. ");
INSERT INTO tkr_vpl VALUES ("DN2_43","028_2_43","DAN","2","43","43","Nəxdiy vak'le yival g'ı'bı'na nyaq'v alivku g'avcu, həməxdıd mang'un milletbı ixhes. Manbışe sana-sang'us yişşar adameeşis huveeyib, manbı sana-sang'uk at'ivq'anas deş, yivayiy g'ı'bı'na nyaq'v sana-sançil itt'idiyq'anan xhinne. ");
INSERT INTO tkr_vpl VALUES ("DN2_44","028_2_44","DAN","2","44","44","Mane paççahaaşine gahıl xəybışde Allahee mısacab ilykidevxhasda, menne milletbışde xılyaqa ılğıdevç'esda xhinnena paççahiyvalla alyaa'as. Mançin çile ögiylin gırgın paççahiyvallabı alykyahasınbı, vucmee mısacab alykivxhas deş. ");
INSERT INTO tkr_vpl VALUES ("DN2_45","028_2_45","DAN","2","45","45","Vak'lecad g'acuyn suvayk xıl sidet'ucab g'aye qopxu qabı, yivayke, yezıke, g'ı'bı'ne nyuq'vneke, nuk'rayke, k'ınəəğəyke xüvəbı hı'ı. Məxüd xənne Allahee g'iyniyke şaqa ixhesınbı paççahılqa hixhar hı'ı. Man nyak' qotkuyn vodun, man nen eyheniyvad qotkuda yuşan hı'ı. ");
INSERT INTO tkr_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","46","Mankecar paççah Navuxodonosor aq'vakkena gizerçu, Daniyalıs k'yorzul, mang'unemee paybı alleva, ətirbı gyoxhxhan he'eva eyhe. ");
INSERT INTO tkr_vpl VALUES ("DN2_47","028_2_47","DAN","2","47","47","Paççahee Daniyalık'le eyhen: – Vasseke mane sirrılqa hixharas əxı'na, vuşda Allah hək'erar allahaaşina Allahır, paççahaaşinar Xərna vor, sirrılqar hixhar ha'ana Mana vor. ");
INSERT INTO tkr_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","Mane yiğıle paççahee Daniyal xənne işbışilqa giyxhe, mang'us geed xədın paybı hele. Mang'une xılyaqa Baabilyna şahariy mançine hıqiy-allan cigabı qele, Baabilyne k'orane ək'elynanbışdar xərna ha'a. ");
INSERT INTO tkr_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","Daniyalee paççahıke heqqa, paççaheeyib Şadrak, Meşak, Aved-Nego Baabilyne cigabışee ç'ak'ıne işbışilqa giviyxhe. Daniyal vucmee paççahne sarayeecar axva. ");
INSERT INTO tkr_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","Paççah Navuxodonosoree k'ınəəğəyna haykal haa'a. Mançina axtıvalla yixhts'al (60), əq'vallab yixhılle xılekkum ıxha. Haykalıb gyuvxhu vuxhana Baabilyne cigabışeene Dura eyhene çoleeqa. ");
INSERT INTO tkr_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","2","Qiyğa paççah Navuxodonosoree caanişinar, emırar, valibı, muşavirar, xazinadarar, haakimar, məmurar, sa cuvabıka, mane cigayne gırgın vuk'lel ulyobzurıynbı vucee gyuvxhuyne haykalısqa, mana g'avsaras savalecenva xabar g'uxoole. ");
INSERT INTO tkr_vpl VALUES ("DN3_3","028_3_3","DAN","3","3","3","Mane gahıl paççah Navuxodonosoree gyuvxhiyne haykalne k'anyaqa, haykalıs g'avsrencenva caanişinar, emırar, valibı, muşavirar, xazinadarar, haakimar, məmurar, mane gırgıne cigayne vuk'lel ulyobzırıynbı savayle. ");
INSERT INTO tkr_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","Xabar hooleng'vee axtıda eyhen: – Menne milletbışin, xalq'bışin, menne-menne mizyaaşil yuşan haa'an insanar, şolqa əmr haa'a: ");
INSERT INTO tkr_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","şeypur, zurna, lira, arfa, naq'ra, tulugna zurna, menne neneyiy ı'liyxəne instrumentbışin ses g'ayxhıyne gahıl paççah Navuxodonosoree givxhiyne k'ınəəğəyne haykalne ögee aq'vakkena qukkyopk'ul mançis k'yoozre. ");
INSERT INTO tkr_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","Vuşuyiy aq'vakkena qukkyudyork'ul mançis k'idyorzul, xəbne gyopxhanne peşteeqa g'uvoxharas. ");
INSERT INTO tkr_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","Məxüd gırgıne milletbışee, xalq'bışee, menne-menne mizyaaşil yuşan haa'anbışe şeypurun, zurnayn, lirayn, arfayn, naq'rayn, tulugne zurnayn, menne neneyiy ı'liyxəne instrumentbışin ses g'ayxhiyne gahıl ç'iyelqa gizepçı, paççah Navuxodonosoree gyuvxhuyne k'ınəəğəyke hav'uyne haykalıs k'yobzur. ");
INSERT INTO tkr_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","Mane gahıl Baabilyaaşiken sabarabı sabı, cühüt'yaaşine hək'ee hexxan karbı yuşan ha'a. ");
INSERT INTO tkr_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","Manbışe paççah Navuxodonosoruk'le eyhen: – Paççah, geer qa'ana! ");
INSERT INTO tkr_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","Ğu əmr hav'u, şavuk'leyiy şeypurun, zurnayn, lirayn, arfayn, naq'rayn, tulugne zurnayn, menne neneyiy ı'liyxəne instrumentbışin ses g'ayxhı, k'ınəəğəyke hav'uyne haykalne ögee ç'iyelqa gizerçu mançis k'yozrecen. ");
INSERT INTO tkr_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","Vuşuyiy mançine ögiyl ç'iyelqa gizderçu mançis k'yudyorzul, xəbne gyopxhanne peşteeqa g'uvoxharas. ");
INSERT INTO tkr_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","Ğu Baabilyne cigabışee ç'ak'ıne işbışilqa gyuvxhuyne çühüty'aaşe Şadrakee, Meşakee, Aved-Negoyee val k'ırı iliyxhe deş. Manbışe yiğne allahaaşis ı'bəədat ha'a deş, ğu hav'uyne k'ınəəğəyne haykalne ögee gizepçi mançis k'yoozar deş. ");
INSERT INTO tkr_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","Mançike Navuxodonosorus qəl vooxhe. Mang'vee Şadrak, Meşak, Aved-Nego cusqa ableva əmr haa'a. Man insanar paççahısqa abaylenbı. ");
INSERT INTO tkr_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","Navuxodonosoree manbışik'le eyhen: – Şadrak, Meşak, Aved-Nego, man hək'enne, şu yizde allahaaşis ı'bəədat hidya'ava, zı gyuvxhuyne k'ınəəğəyne haykalne ögee gizepçi, mançis k'idyoozarva? ");
INSERT INTO tkr_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","Vuşdemee yugdaniy ixhes, şok'le şeypurun, zurnayn, lirayn, arfayn, dyafın, tulugne zurnayn, menne ı'liyxəne instrumentbışin ses g'ayxhıyne gahıl, zı hav'uyne haykalne ögee gizepçi mançis k'yobzuree. Mançine ögee gizepçi mançis k'idyobzureene, xəbne gyopxhanne peşteeqa g'uvooxharas. Mane gahıl nene allaheene şu yizde xılençe g'attivxhan haa'as? ");
INSERT INTO tkr_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","Şadrakee, Meşakee, Aved-Negoyee paççahıs inəxdın alidghıniy qele: – Ay Navuxodonosor, ine işee şicab şi vake g'attivxhan hav'iy nişisınne? ");
INSERT INTO tkr_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Şi xəbne gyopxhanne peşteeqa hüvxəv'ee, şi ı'bəədat ha'ane Allahısse şi peşteençe g'attivxhan haa'as vəəxəsınbı. Mang'vee şi yiğne xılençe g'attivxhan haa'asbı. ");
INSERT INTO tkr_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","Şas, vak'le in ats'axhxha ıkkan, şi eyhencadıd dexheene, meeb şi yiğne allahaaşis ı'bəədat ha'as deş, ğu gyuvxhiyne k'ınəəğəyne haykalne ögee gizepçi mançis k'yoozaras deş. ");
INSERT INTO tkr_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","Manke Navuxodonosorus Şadrakıke, Meşakıke, Aved-Negoyuke qəl vooxhe. Mang'un qəlıke aq'vacad badal eyxhe. Mang'vee əmr haa'a, peşt hammaşee qahaançile yighne yəqqees hissaxaba vuxhecen. ");
INSERT INTO tkr_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","Cune g'oşunne nekke gucukane eskeraaşilqa əmr haa'a Şadrakın, Meşakın, Aved-Negoyn g'elybı-xıleppı ayt'ıl xəbne gyopxhanne peşteeqa dağee'ecenva. ");
INSERT INTO tkr_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","21","Şadrakee, Meşakee, Aved-Negoyee tanalqa cübbabı, şalvarbı ali'ı ıxha, vuk'lelqad çalmabı qı'ı ıxha. Manbı cone tanalinçikacab g'elybı-xıleppı ayt'ıl xəbne gyopxhanne peşteeqa hiviyxə. ");
INSERT INTO tkr_vpl VALUES ("DN3_22","028_3_22","DAN","3","22","23","Paççah cune əmrel oğa it'umra ulyorzulyva, peşt geeb g'ooxhaa'a. Eskeraaşe xhebiyre hambaz peçteeqa hiviyxəng'ə, mançike qı'ğəəne yalavın eskerar gyabat'anbı. ");
INSERT INTO tkr_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","Mane gahıl paççah Navuxodonosor peşteeqa horzulymee, ghal aaqı axva. Qiyğa mana zaara g'elilqa suğotsu, cune mı'sləhətçeeşike qiyghanan: – Nya'a, şi g'el-xıl ayt'ılna xhebiyre insan dişde ts'ayeeqa dağav'u? Manbışe paççahıs inəxdın cuvab qele: – Ay paççah, ğu hək'en eyhe! ");
INSERT INTO tkr_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","Paççahee manbışik'le eyhen: – Zak'le ts'ayee, vuççud dexhayn xhinne iykarna, g'el-xıl idiyt'ılna yoq'uyre insan g'ece. Manbışda yoq'ur'esda allahaaşine dixekır akar. ");
INSERT INTO tkr_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","Navuxodonosor peştıne k'anyaqa qarı, onu'u eyhen: – Allah Ta'aalayn g'ular, Şadrak, Meşak, Aved-Nego, qığeepç'e, inyaqa qudoora. Manke Şadrakır, Meşakır, Aved-Negoyır ts'ayeençe qığeebaç'enbı. ");
INSERT INTO tkr_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","Hiqiy-alla sabıyne canişinaaşık'le, emıraaşık'le, vaalibışik'le, paççahne mı'sləhətçeeşik'le g'ecen, ts'ayın mane insanaaşine tanık vuççud hı'ı deşud. Manbışde ç'ərbışikıd, tanalqa ali'iynçıkıd ts'a set'u deşud, manbışike gyotxhuniyn evad qöö deşud. ");
INSERT INTO tkr_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","Navuxodonosoree eyhen: – Şadrakne, Meşakne, Aved-Negoyne Allahıs şukur vuxhena! Mang'vee Cun malaaik g'axuvu, Culqa yı'q'bı qizzıriyn g'ular g'attivxhan hav'u. Manbı paççahne əmreençe qığeepç'ı hapt'ıyle qəpq'ı'n deş. Manbışis cone Allahıle ğayrı menne allahaaşis k'yoozarasiy ı'bəədat ha'as ıkkiykın deş. ");
INSERT INTO tkr_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","Mançil-allab zı həşde əmr gırgıne xalq'bışis, milletbışis, menne-menne mizyaaşil yuşan ha'anbışis əmr ha'a: Şadrakne, Meşakne, Aved-Negoyne Allahıs kufr hı'ıne insanıke xüvəbı ha'as. Manbışin xaybıd yı'qqı'lqa sak'al ha'as. Məxüb g'attivxhan haa'as vəəxəna merna allah dexhal-alla. ");
INSERT INTO tkr_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","Mançile qiyğa paççahee Baabileeyiy çine hiqiy-allane cigabışee Şadrakıs, Meşakıs, Aved-Negonus sık'ıldad ç'ak'ın işbı hele. ");
INSERT INTO tkr_vpl VALUES ("DN3_31","028_3_31","DAN","3","31","31","Paççah Navuxodonosoree gırgıne dyunyelyne xalq'bışik'le, milletbışik'le, menne-menne mizyaaşil yuşan haa'ane insanaaşik'le eyhen: «Vuşun barakat geed qixhen! ");
INSERT INTO tkr_vpl VALUES ("DN3_32","028_3_32","DAN","3","32","32","Zas ıkkanniy Allah Ta'aalee yizdemee hı'iyn əlaamatbıyiy mö'cuzabı şos yuşan ha'as. ");
INSERT INTO tkr_vpl VALUES ("DN3_33","028_3_33","DAN","3","33","33","Nimeena xəbvallayiy Mang'une əlaamatbışee, Nimeenacab guciy Mang'une mö'cuzabışee! Mang'una paççahiyvalla gırgıne gahbışisda paççahiyvalla vobna, Mang'vee vuk'lek vukkiy nasılıle nasılılqa ılğeç'es!» ");
INSERT INTO tkr_vpl VALUES ("DN4_1","028_4_1","DAN","4","1","1","«Zı, Navuxodonosoree, xaa, yizde sarayee nişinacab hidya'ana yugna, karnana ı'mı'rniy haa'a vob. ");
INSERT INTO tkr_vpl VALUES ("DN4_2","028_4_2","DAN","4","2","2","Yiğbışde sa yiğıl, zı qəq'ənı'iyn sa nyak' g'acu. Nik'ek g'acuyne karbışda zı fıkır opxhanmee, zı mane fıkırbışee geer qəq'ən hı'ı. ");
INSERT INTO tkr_vpl VALUES ("DN4_3","028_4_3","DAN","4","3","3","Zı, mançil-allab əmr hav'u, yizın nyak' nen eyheniyva ats'axhesdemee, zasqa Baabilin gırgın k'oran ək'elynanbı see'eva. ");
INSERT INTO tkr_vpl VALUES ("DN4_4","028_4_4","DAN","4","4","4","Manke zasqa sehirbazar, cadubı ha'anbı, falçer abayle. Zı manbışis yizın nyak' yuşan he'eeyid, manbışisse man nyak' nen eyheniyva eyhes əxı' deş. ");
INSERT INTO tkr_vpl VALUES ("DN4_5","028_4_5","DAN","4","5","5","Nekke qiyğa zasqa Daniyal donana arayle, zı mang'usud yizın nyak' yuşan ha'an. (Mang'un do Belyteşassar vod, yizde allahne doyulyna, muq'addasne allahaaşin rı'h mang'une ad vod). ");
INSERT INTO tkr_vpl VALUES ("DN4_6","028_4_6","DAN","4","6","6","Zı uvhuyn: – Sehirbazaaşina nekke xərna eyxhena Belyteşassar! Zak'le ats'an, yiğne ad muq'addasne allahaaşin rı'h vod, yiğnemee sirrılqa hirxhıliy dağamın deş vod. Həşde zı vas zak'le nik'ek g'acuyn yuşan ha'as. Ğu yizın nyak' zas qe'e. ");
INSERT INTO tkr_vpl VALUES ("DN4_7","028_4_7","DAN","4","7","7","Zak'le nik'ek, dyunyeyne yı'q'nee sa geeb axtına yiv g'avcu. ");
INSERT INTO tkr_vpl VALUES ("DN4_8","028_4_8","DAN","4","8","8","Yiv manimee xəb qooxhe, manimee it'umooxhe, mançin q'om xəybışeeqa hiyxhar. Mana yiv dyunyeyne gırgıne surabışile g'ooce vuxha. ");
INSERT INTO tkr_vpl VALUES ("DN4_9","028_4_9","DAN","4","9","9","Mançil uftanna t'ele, geed meyvabı, gırgıng'uscad oxhanasın kar eyxhen. Mançine avud çolun həyvanar, yivelid xəybışeedın şit'yar eyxhe ıxha. Gırgıne üç'üdunçıncad mançile kar otxhan ıxha. ");
INSERT INTO tkr_vpl VALUES ("DN4_10","028_4_10","DAN","4","10","10","Zı nik'eenang'a zak'le, xəybışeençe muq'addasın malaaik gəə g'acu. ");
INSERT INTO tkr_vpl VALUES ("DN4_11","028_4_11","DAN","4","11","11","Mane malaaikee axtıne seseka eyhen: „Mana yivub, çilin bıtağbıd gyatxe, mançilyna t'eleb g'ılymabaççe ulyoode, meyvabıd inyaqa-şaqa dağe'e. Hasre mançik avudun həyvanarıd, cilin şit'yarıd hetxvecen. ");
INSERT INTO tkr_vpl VALUES ("DN4_12","028_4_12","DAN","4","12","12","Saccu mançin dunk kokbışika sacigee yivaykayiy yezaka alitk'ır, çolee ələəne ok'bışee hasre. Hasre man xəybışde çiyin çüvə qe'ecen, həyvanaaşika sacigeeyid ok'bışee ixhecen. ");
INSERT INTO tkr_vpl VALUES ("DN4_13","028_4_13","DAN","4","13","13","Hasre mane yiveke insanna ək'el g'avşu, mançis həyvanna ək'el hevlecen. Hasre yighılle senna məxüd ixhecen. ");
INSERT INTO tkr_vpl VALUES ("DN4_14","028_4_14","DAN","4","14","14","Həşdiyne insanaaşik'le ats'axhxhecenva, muq'addasne malaaikaaşe əmr hav'u: insanaaşine paççahiyvalis Allah Ta'aalee xəbvalla haa'a. Mang'veeyib paççahiyvallab şavusqayiy Cus vukkan mang'usqab qoolena. Mang'usser insanaaşine yı'q'nee nekke avqanar manbışda xərna ha'as əxəna“. ");
INSERT INTO tkr_vpl VALUES ("DN4_15","028_4_15","DAN","4","15","15","Zak'le – paççah Navuxodonosoruk'le – məxdın nyak' g'acu. Belyteşassar, man zak'le g'acuyn nyak' nen eyheniyva zak'le eyhe. Yizde paççahiyvaleene k'orane ək'elynanbışde sang'ussecad man nen eyheniyva eyhes əxı' deş. Vasse man ha'as əxəsın, val muq'addasne allahaaşin rı'h vod». ");
INSERT INTO tkr_vpl VALUES ("DN4_16","028_4_16","DAN","4","16","16","«Mane gahıl Belyteşassar donana Daniyal, sabara gahna ghal aaqıcar axva, mana cunecar fıkırbışile qəyq'ənna. Paççahee mang'uk'le eyhen: – Belyteşassar, nik'enır, mançine mə'naynır ğu qəq'ən hıma'acen. Belyteşassaree eyhen: – Yizda xərna, ğu şavuk'leyiy g'ımece, man nyak' manbışin ıxhaynxhiy, man nen eyheniyvad yiğne duşmanaaşine vuk'lelqa qadınxhiy! ");
INSERT INTO tkr_vpl VALUES ("DN4_17","028_4_17","DAN","4","17","17","Vak'le g'avcuna axtına, it'umna, q'om xəybışeeqa hiviyxharna, dyunyeyne gırgıne surabışile g'oocena, ");
INSERT INTO tkr_vpl VALUES ("DN4_18","028_4_18","DAN","4","18","18","çılin t'ele micagna, meyvabı geednana, gırgıng'vee otxhanna, çolan həyvanar əqeeeqa qadaylena, xəəne şit'yaaşe çil akvaabı ha'ana ");
INSERT INTO tkr_vpl VALUES ("DN4_19","028_4_19","DAN","4","19","19","yiv, paççah, ğu vorna. Ğu xər qıxha it'umxhana, yiğna xəbvalla xəybışeeqa, yiğın vuk'lek vukkiyid dyunyeyne gırgıne surabışilqa hitxhır. ");
INSERT INTO tkr_vpl VALUES ("DN4_20","028_4_20","DAN","4","20","20","Paççahık'le xəənçe giç'una muq'addasna malaaik g'acu. Mang'vee eyhenıd g'iyxhen: «Mana yiv gyapxı oot'e. Saccu mançin dunkiy kokbı yivaykayiy yezaka alitk'ır nyuq'vnee, çolane ok'bışee g'aletçe. Hasre mançis xəəne çiyin xhyan helecen, yighılle sen ılğeç'esmeeyib çolane həyvanaaşika aaxvecen». ");
INSERT INTO tkr_vpl VALUES ("DN4_21","028_4_21","DAN","4","21","21","Paççah, haane zı vak'le nyak' hucoo eyheniyva eyhe. İn Allah Ta'aalee, yizde xərıng'une, paççahne vuk'lelqa qalesın uvhu. ");
INSERT INTO tkr_vpl VALUES ("DN4_22","028_4_22","DAN","4","22","22","Ğu insanaaşine yı'q'neençe g'e'eşşesda, ğu çolune həyvanaaşika sacigee ixhes. Vas yatsıs xhinne ok' ooxhan haa'as, ğu xəəne çiyın əyxəra'as. Ğu məxür yighılle senna axvas. Allah Ta'aalee insanaaşine paççahiyvallabışis xəbvalla haa'ava, Mang'veecadıd manbı Cus neng'uneyiy xılyaqa ıkkanıd qeleva, manke vak'le ats'axhes. ");
INSERT INTO tkr_vpl VALUES ("DN4_23","028_4_23","DAN","4","23","23","Vak'le nik'ee yivene dunkuka sacigee kokbıd havaceva uvhuyn eyhe g'ayxhiyn, man yiğna paççahiyvalla vasqa savaak'alasdava eyhen vodun. Valqa gırgınçis Xəybışee xəbvalla haa'ava hitxhıriyng'a, man ixhes. ");
INSERT INTO tkr_vpl VALUES ("DN4_24","028_4_24","DAN","4","24","24","Mançil-allad, paççah, ğu zal yugda k'ırı alixhxhe: bınahbışike xıl ts'ıts'ee'e. Bınah haa'asse, kardeşinbışis rəhı'm, qopkuvalla he'e. Ğu məxüd he'eene, sayıb, yiğna yugvalybışeena gah xıliy qooxhe». ");
INSERT INTO tkr_vpl VALUES ("DN4_25","028_4_25","DAN","4","25","25","Man gırgın kar paççah Navuxodonosorne vuk'lelqa qadaylen. ");
INSERT INTO tkr_vpl VALUES ("DN4_26","028_4_26","DAN","4","26","26","Ooğançe yits'ıq'vəble (12) vaz ılğevç'uyle qiyğa, paççah Baabileene sarayne daxal iykarang'a, ");
INSERT INTO tkr_vpl VALUES ("DN4_27","028_4_27","DAN","4","27","27","eyhen: – Hayna xəbna paççahaaşina paytaxt Baabil, zı yizde xənne gucuka, yizın do axtıda ixhenceva alyav'u. ");
INSERT INTO tkr_vpl VALUES ("DN4_28","028_4_28","DAN","4","28","28","Cuvab paççahne ghalençe qığeç'u ç'əvxha deşdiy, xəybışeençe ses qaadayle: – Paççah Navuxodonosor, yiğna paççahiyvalla xılençe g'avşesdava q'arar huvu. ");
INSERT INTO tkr_vpl VALUES ("DN4_29","028_4_29","DAN","4","29","29","Ğu insanaaşine yı'q'neençe g'e'eşşesda, çolane həyvanaaşika ixhes, yatsın xhinneyib ok' ooxhanas. Ğu məxür yighılle senna axvas. Allah Ta'aalee insanaaşine paççahiyvallabışis xəbvalla haa'ava, Mang'veecadıd manbı Cus neng'uneyiy xılyaqa ıkkanıd qeleva, manke vak'le ats'axhes. ");
INSERT INTO tkr_vpl VALUES ("DN4_30","028_4_30","DAN","4","30","30","Navuxodonosorne hək'ee uvhiyn karbı mankecad vuk'lelqa qadaylenbı. Mana insanaaşine yı'q'neençe g'e'eşşena, mang'veeyib yatsan xhinne ok' ooxhan giyğal. Mang'un ç'ərbı q'aacirna vusun xhinne xıliy qıxhesmee, xhınt'arıd şit'yaaşin xhınt'ar xhinne xıliy qıxhesmee xəybışde çiyın mana əyxər ha'a ıxha. ");
INSERT INTO tkr_vpl VALUES ("DN4_31","028_4_31","DAN","4","31","31","«Zı Navuxodonosor, man yiğbı çəveedaxheng'a, xəəqa ilyakkı. Manke yizda ək'el zalqa sapk'ıl. Zı Allah Ta'aalays şukur hav'u, Gırgıne gahbışil Vorung'un do axtı qı'ı. ");
INSERT INTO tkr_vpl VALUES ("DN4_32","028_4_32","DAN","4","32","32","Mang'unemee, dyunyeyn gırgın insanar vuççud deşin kar vod. ");
INSERT INTO tkr_vpl VALUES ("DN4_33","028_4_33","DAN","4","33","33","Yizda ək'el zalqa sapk'ılne gahıl, zalqa paççahaaşina xəbvalla, axtın do satk'ıl. Yizın mı'sləhətçeerayiy zas k'anebınbı meeb zasqa sapk'ıl. Manbışe zı meer paççahiyvalilqa sak'al hı'ı. Zı şenkiynçıler qıvaats'ına ıxha. ");
INSERT INTO tkr_vpl VALUES ("DN4_34","028_4_34","DAN","4","34","34","Xəybışde Paççahın gırgın işbı yugunbı, yəqbıd qotkuynbı ıxhal-alla, həşdiyle zı, Navuxodonosoree, Mang'us şukur haa'a, Mana axtı qa'a. Mang'usse co axtıba avqaaqanbı avqa qa'as vəəxənbı». ");
INSERT INTO tkr_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","Paççah Belyşassaree aazırne cune insanıs xədın otxhun-ulyodğiy hele, manbışika çaxır ulyoğa. ");
INSERT INTO tkr_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","2","Belyşassaree çaxır ulyodğuyle qiyğa əmr haa'a, cune dekkee Navuxodonosoree İyerusalimeene Allahne Xaançe qığı'iy