﻿USE sofia;
DROP TABLE IF EXISTS sofia.tke_vpl;
CREATE TABLE tke_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tke_vpl WRITE;
INSERT INTO tke_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wa Tiyofilu ooriiheya, athu ajinjeene yahisayela osasanyedha bili ya dhego dheereyile vaari va hiyo. ");
INSERT INTO tke_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aliwa yahileba dhedho dhaddeliwiisu ni athu yonile vameentoni okuma omabeelelo, olaleyaga. ");
INSERT INTO tke_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Miyo gosayela sayela dhego dhatedhene dhedhi mohariha pama, okuma omambeelelo guhubuwelela teto, wi giire wulebela we Tiyofilu dhowiireya nda moosasanyedha pama. ");
INSERT INTO tke_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Gihiirana dhedho wi munone wi dhisuuzilinyu sebaribari. ");
INSERT INTO tke_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mudhidhi oyene Heroddi, agali mwene o oZhudeya, wahikala namakutha, ndina naaye eeriwa Zakariya. Aali a nikuru na anamakutha a Abiya. Mwihiyana aaye eeriwa Ezabeli, aali a nihimo na Aaroni. ");
INSERT INTO tke_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aabilene yaali owogoowa murima vameentoni va Mulugu, yohariha mowaakwanela malamulo ni magano a Nabwiya. ");
INSERT INTO tke_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kayanna mwaana, vowi Ezabeli kaabala. Aabilene yaali owululeene. ");
INSERT INTO tke_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nlabo nimohi, Zakariya ahiddaga mabasa aaye oonamakutha vameentoni va Mulugu. Waali mudhidhi wa nikuru naaye na oonamakutha nowimelela, ");
INSERT INTO tke_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","moharihedha mukalelo weewa wonamakutha, ahimoreliwa gari mosakuliwa ovolowa mburo woweela wa Nabwiya, wi apahe dhoonukwela dha mukutho. ");
INSERT INTO tke_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mudhidhi oyene, athu ateene yakala ode olobelaga. ");
INSERT INTO tke_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mungero a Nabwiya ahidha vowambeela, wiimela omoononi wooja wibuwani wapahiwa dhoonukwela dha mukutho. ");
INSERT INTO tke_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariya agamoonile ahirurumuwaga ni woova. ");
INSERT INTO tke_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mungero ahimwiirelaga: “Zakariya, kawoove! Vowi malobelo aawo ehiiweya. Mwihiyana aawo Ezabeli oneere ombala mwaana, oyene onamuthwiwe ndina na Zhuwawu. ");
INSERT INTO tke_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oliye onakale ohagalala ni oteyela wa we, ajinji eneere odhiveliwa ni obaliwa waaye. ");
INSERT INTO tke_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Vowi oliye onakale mulubale vameentoni va Nabwiya. Kadha ang'wa yoong'wa yolezeliha, onaakale oodhaaliwa Muneba Woweela, naari ahinabaliwe. ");
INSERT INTO tke_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Onodha atthwaruse amwaana Ezarayeli ajinjeene wa Nabwiya Mulugu aaye. ");
INSERT INTO tke_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Vano oneere okala vasogolo va Nabwiya mmunebani ni kopolo dha Eliyazi, wi atthwaruse murima dha ababiinya wa aaniwa, atthwaruse avuruvuru wi ekanne zelu ya athu oharihamo, asasanyedhe athu wa Nabwiya nlogo nooharihamo.” ");
INSERT INTO tke_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nuwindo Zakariya ahimukoha mungero: “Ginanone addi dhendo, vowi miyo ni mwihiyanaga nihuluvala?” ");
INSERT INTO tke_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mungero ahimwaakulaga wiira: “Miyo gili Gabiriyeli, gineemelela vameentoni va Mulugu. Ogirumile duliyeene wi giwoge niwe ni wudhelana muselu wapama. ");
INSERT INTO tke_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Woone vowi kuroromele madhu aaga, oneere okala ohuwoga ofiyedha nlabo nenddo dhineereye nda.” ");
INSERT INTO tke_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Athu yomujehaga Zakariya, etikinaga ni mwaha woribeliwa munyuba ya Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Agakumile kaakwanihile wawogana. Aliwa ononelamo wi ohooneyeliwa omburoni woweela. Zakariya awoga ni madada, baahi. Kaanda okumiha madhu. ");
INSERT INTO tke_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dhahipadduwa egaakwanile malabo a mabasa aaye ahiwelela vade. ");
INSERT INTO tke_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nuwindo egavirile malabo ayene Ezabeli ahikanna wari, ofiyedha mweeri mitanu kavenya vade. ");
INSERT INTO tke_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ezabeli ahiira: “Ndala Nabwiya ohiirana wa miyo, ohudhiveliwa ni miyo, ohumaaliha manyazo aaga, yanna miyo vaari va athu.” ");
INSERT INTO tke_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Vigavirile mweeri mitanu na mmohi Ezabeli aganna wari, mungero Gabiriyeli ahirumiwa ni Mulugu murudda wa elabo ya oGalileya nluwa no oNazareti. Wewo wadhowiliye omfwanya namwali, eeriwa Mariya. ");
INSERT INTO tke_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Oyene ahamunonile mulobwana. Attomeliwe ni mulobwana, eeriwa Zhuuze, aali a nlogo na mwene Davidi. ");
INSERT INTO tke_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mungero agafiyile, ahimulojelaga, wiira: “We ohukanna mahala! Nabwiya Oli ni we.” ");
INSERT INTO tke_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya ageewile ahisimwelaga vajinjivene, wubuwelaga: “Olojela wula onatapulela ddi?” ");
INSERT INTO tke_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mungero ola omwiirela: “Mariya, kawoove. Wevo ohufwanya mahala a Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oneere okalana wari. Onombala mwaana pongwe, oyene oneere omuthwa ndina na Yesu. ");
INSERT INTO tke_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Onaakale mulubale, akopolo. Oneethaniwege Mwaana a Mudhulu-dhulu. Nabwiya Mulugu oneere omvaha othonga wa babaye Davidi. ");
INSERT INTO tke_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Oneerege othonga nlogo na Yakobo malabo ni malabo. Omwene waaye kudha omala.” ");
INSERT INTO tke_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariya ahiwoga: “Dhinandeye addi vowi miyo kagimunonile mulobwana?” ");
INSERT INTO tke_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mungero ahimwaakula, wiira: “Muneba Woweela oneere wukitela kopolo dha Mudhulu-dhulu dhinowukuneela ni murinti waaye. Vowi Oweela onabaliwe mwa we oneeriwege Mwaana a Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Woone, mmudhi aawo Ezabeli nuliyeene ohukanna wari. Onomujejiha mwaana pongwe, ola bu mweeri wa neetanu na mmohi. Oliye agali owuluvaleene, oyene athu ateene yamwiiriwa muliba ohubala. ");
INSERT INTO tke_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Vowi ni Mulugu kilivo ehinandeya.” ");
INSERT INTO tke_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Vano Mariya omwaakula, wiira: “Gili va, mwiimeleli a Nabwiya. Dhiireye wa miyo dhatedhene mooligana ni madhu eenyu.” Vano mungero ovenyavo vemeliligiiye. ");
INSERT INTO tke_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Malabo alene Mariya ahivenya mowaaguva odhowa nluwa no oZhudeya murudda wo mwaangoni. ");
INSERT INTO tke_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ovolowa mba mwa Zakariya, omulojela Ezabeli. ");
INSERT INTO tke_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ezabeli ageewile olojela wa Mariya, mwaanaya ahikahinyaga mbaani mwa amaaye. Ezabeli teto ahidhaaleliwa Muneba Woweela. ");
INSERT INTO tke_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ahiwogaga ni ndhu notaama, wiira: “Oreelihiwa di nyo vaari va ahiyana, yoreelihiwa si yoovaha ya mbaani mweenyu! ");
INSERT INTO tke_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Asaa! Dhandeyile a ddi wi amaaye a Nabwiya aaga, egeeddele miyo? ");
INSERT INTO tke_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Vowi viwilimi olojela wa weenyu, mwaana ohiikahinya volubalevene ni ohagalala mbaani mwaaga. ");
INSERT INTO tke_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Muli oorelihiwa mwaha wororomela wi Nabwiya dhuwaaddeliyeni, dhineere wiireya!” ");
INSERT INTO tke_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nuwindo, Mariya ahiira: “Egumi yaaga enomuriha Nabwiya, ");
INSERT INTO tke_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Muneba waaga onohagalala mwa Mulugu, Mvulumusi aaga. ");
INSERT INTO tke_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Vowi uhoona wiiyeviha wa mwiimeleli aaye. Okuma dhiinova ni anamabaliwelamo ateene enagiirege oreelihiwa, ");
INSERT INTO tke_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mwaha wi oowodha ohugiirela dhego dhulubale. Oweela thili ndina naaye. ");
INSERT INTO tke_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Thagaraga dhaaye dhinowaafiyedha anamabaliwelamo ateene, alene enamuriha. ");
INSERT INTO tke_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ohaabalalesa ni moono waaye owiithukula, ni moobuwelelo eewa oovirigana. ");
INSERT INTO tke_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ohakitiha mamwene mudhittenguni dheewa, waagweliha owiiyeviha. ");
INSERT INTO tke_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ohaarubaliha ni dhapama aliba dala, waapaganya ehinna yego oreela. ");
INSERT INTO tke_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ohumukamihedha Ezarayeli mwiimeleli aaye, kaddiwalele thagaraga dhaaye ");
INSERT INTO tke_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","wa Abarahamu ni anamabaliwelamo aaye malabo mateene, woona aroromelihiye makolo eehu.” ");
INSERT INTO tke_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya ahikala ni Ezabeli mweeri dhowaakwana miraaru. Vano owelela vade vaaye. ");
INSERT INTO tke_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mudhidhi ogaakwanile wowi Ezabeli abale, ahimbala mwaana mulobwana. ");
INSERT INTO tke_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Amwaaddamani ni amudhi aaye egeewile wi Nabwiya ohumweddiwela thagaraga volubalevene, yahihagalala ni oliye. ");
INSERT INTO tke_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Vigavirile malabo matanu na maraaru yahimudhowana mwaana wi eeneliwe yafunaga emutwe ndina na babaye, Zakariya. ");
INSERT INTO tke_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Amaaye yahaakula, wiira: “Naari! Eeriwege Zhuwawu.” ");
INSERT INTO tke_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yahimwiirelaga: “Amudhi aawo kalivo winna ndina nenddo.” ");
INSERT INTO tke_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Omukoha baba a mwaana ni madada wi ki mwaana ola eeriwege aani. ");
INSERT INTO tke_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ahilobaga ntabwa olebavo: “Ndina naaye di Zhuwawu.” ");
INSERT INTO tke_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mowaaguva mulomo waaye wahifuguwaga, nlumi otapuwa, owogaga, amutamalaga Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wahikala woova wa amwaaddamani ateene a Zakariya, ni murudda dhatedhene dho mwangoni wa oZhudeya, dhowogiwa dhowiireya nde. ");
INSERT INTO tke_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ateene yeewile nde yoologolela mmurimani, yiiraga: “Mwaana ola onaakale aani?” Mwaha wi kopolo dha Mulugu dhaali ni oliye. ");
INSERT INTO tke_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariya, babaye Zhuwawu, ahidhaaliwa Muneba Woweela wambeela ovuhulela, eeraga: ");
INSERT INTO tke_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Otamaaliwa akale Nabwiya, Mulugu a Ezarayeli, vowi oheeddela ni woobola nlogo naaye. ");
INSERT INTO tke_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ohunivenyihedha ovulumuwa wa kopolo, odheela vade va Davidi, mwiimeleli aaye. ");
INSERT INTO tke_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Woona Mulugu mwawogeliiye odheela vamulomoni vanamavuhulela oweela okuma wale-wale.) ");
INSERT INTO tke_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Wi eere onoobola wa amwiiddani eehu mmadadani mwa ateene alene enanaaba. ");
INSERT INTO tke_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ohooneyiha thagaraga dhaaye wa makolo eehu, wubuwelela wandana wopanganela waaye woweela, ");
INSERT INTO tke_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Olibela wamwiireliye baba eehu Abarahamu: ");
INSERT INTO tke_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Wi eere onivulumusa mmadadani mwa amwiiddani eehu, wi nimwebedhege nihoovaga, ");
INSERT INTO tke_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","moweela murima ni wiiwelela vameentoni vaaye malabo mateene a egumi yeehu. ");
INSERT INTO tke_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","We mwaanaga, oneerege wiithaniwa namavuhulela a Mudhulu-dhulu. Vowi oneere odhowa vasogolo va Nabwiya wi osasanyedhe dila yaaye. ");
INSERT INTO tke_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ni waalaleyela athu a Mulugu, ovulumusiwa weewa odheela mooleveleliwa dhoothega dheewa, ");
INSERT INTO tke_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","vowi Mulugu eehu dathagaraga, ohuneeddela okumela odhulu woona ofuwa wa nduwa, ");
INSERT INTO tke_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","wi naamoneyele ale eneedda mwipipini ni murinti wookwa, wi asogolela manyalo eehu mundila ya murenddele.” ");
INSERT INTO tke_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwaana ole owuunuwa ni oliba mwa muneba, ahikala mwiiddeddereni ofiyedha nlabo nenddo neyooneyihiliye wa Ezarayeli woona pogo. ");
INSERT INTO tke_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mudhidhi olene ahikalawo kingi mulubale elabo yateene, eeriwa Aguxitu. Ahivuwiha nlamulo neeriliye wihinano athu ateene elebeliwe. ");
INSERT INTO tke_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Vano waali olebela wowambeela, Kureniyo aaliye kingi elabo ya oSiriya.) ");
INSERT INTO tke_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Vano athu ateene yahidhowa muthu-ni-muthu mudhi wobaliwela wi yalebeliwe. ");
INSERT INTO tke_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mwaha wa ela, Zhuuze ahivenya mudhi wo oNazareti, wo oGalileya. Odhowa nluwa no oBetelemi, oZhudeya, wewo wabaliwe kingi Davidi. Vowi oliye aali a nlogo na Davidi. ");
INSERT INTO tke_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ahidhowa wihinano alebeliwe ni mwihinaaye Mariya, aganna wari. ");
INSERT INTO tke_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Zhuuze ni Mariya egali oBetelemi wewule, wahifiya mudhidhi wowihina oliye abale. ");
INSERT INTO tke_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ahimbala mwaana aaye, mwaana pongwe owambeela. Ahimuhuruwedha mwaana aaye ni guwo. Omukonantiha munigulani mwajela aneenyama munikolani mwemo pwagoniwa, mwaha wi suubi a aleddo kamwaali mburo. ");
INSERT INTO tke_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mmuruddani mule yahikalamo anamajiha mabila. Ayene yaang'anelaga aneenyama eewa ni mahiyu. ");
INSERT INTO tke_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Vano vowaaguva mungero a Nabwiya Mulugu ahifiya vameentoni veewa. Mungero ole agafiyile, waara wa nthithimiho na Nabwiya Mulugu wahamoneyela vaaligiisu, aliwa yahirurumuwaga ni woova. ");
INSERT INTO tke_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Vano mungero ahiwogaga ni aliwa wiira: “Eee! Kamoove! Guhudhelanani muselu wapama, oyene onavahe odhiveliwa wulubale athu ateene. ");
INSERT INTO tke_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vuruwanani, muselu ya buula: Muhubaliweliwa peeno veva, muluwani na Davidi, Mvulumusi, Kirixtu, Muthikitheliwi a Mulugu, Nabwiya. ");
INSERT INTO tke_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yoonihelo ya enaakale ela: muneere omfwanya mwaana agabaliwe ohuruwedhiwe ni guwo, okonanthihiwe munigulani moojela aneenyama.” ");
INSERT INTO tke_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Vano, wowaaguvene, yahifiya angero ajinji a anyakoddo odhulu, yegi omutamala Mulugu ni madhu ala: ");
INSERT INTO tke_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Athithimihiwe Mulugu odhulu wolapelesa, murenddele elabo ya vati wa athu alene Mulugu enaadhiveliye.” ");
INSERT INTO tke_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Vano, dhahipadduwa angero egavenyile vameentoni va anamajiha mabila, odhowa odhulu, yegi owoga mmohi ni mukwaaye: “Kabeni dhiinoveva oBetelemi noone dhendo dhipadduwile dhinoonihile Nabwiya Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Vano yahimaruwa mowaaguva edhowaga oBetelemi. Yahimfwanya Mariya ni Zhuuze, egamukonantihile mwaana munigulani. ");
INSERT INTO tke_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Vano egamoonile mwaanaya, yahambeelaga olaleya muselu wawaaddelile mungero mwaha wa mwaana ole. ");
INSERT INTO tke_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Vano athu ateene yeewaga dhende, dhalaleyaga anamajiha mabila, yahitikinaga. ");
INSERT INTO tke_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Vano Mariya nda ologolelaga mmurimani apimaga, asayelaga ononelamo. ");
INSERT INTO tke_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vano anamajiha mabila ale yahimaruwaga owelela mundduli. Edhowaga mundila yegi omuthithimiha emutamalaga Mulugu, mwaha wa dhatedhene dhendo dhewiliiwa, woona mwaaddeliwiisu. ");
INSERT INTO tke_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Egavirile malabo matanu ni maraaru mwanaya ahineliwa moligana mmalamuloni a Mozezi. Ageeneliwe yahimuthwa ndina na “Yesu,” woona mwawogele mungero Mariya ahinakanne wari. ");
INSERT INTO tke_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Egaakwanile malabo oweelihiwa, woona malamulo a Mozezi yahimuthukulela mwaanaya oZheruzalemi wi oonihiwe wa Nabwiya, ");
INSERT INTO tke_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Woona mulebeliwiwa mmalamuloni a Nabwiya: “Anapongwe ateene owambeela eneerege oveleeliwa wa Nabwiya.” ) ");
INSERT INTO tke_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ni nvahi wa mukutho, woona dhilebiwe mmalamuloni wa Nabwiya: “paara emohi maziya naari kangayiwa biili dhing'onong'ono.” ");
INSERT INTO tke_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","OZheruzalemi wahikala mulobwana oyene eeriwa Sumeyawu. Oliye aali ohariha, omoova Mulugu. Oojejihedha wooboliwa wa Ezarayeli. Muneba Woweela waali ni oliye ");
INSERT INTO tke_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wahimvuhulela Muneba Woweela wihina kanaakwe ahimoonile Kirixtu a Nabwiya. ");
INSERT INTO tke_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Moosogoleliwa ni Muneba Woweela ahivolowa nyuba ya Mulugu. Ababiinya a mwaana yahimudhowana Yesu wi yaakwanelihe dhatedhene dhilebiwe mmalamuloni dholigana ni mwaana abaliwa. ");
INSERT INTO tke_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Egamfiyilena wule, Sumeyawu ahimuthukulaga mwaana mmadadani mwaaye, omutamalela Mulugu eeraga: ");
INSERT INTO tke_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vano, Nabwiya, gipaganyeni ni murenddele miyo, mwiimeleli eenyu, woona mwagiroromelihe nyo. ");
INSERT INTO tke_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mwaha wi dhiinova meento aaga ehoona ovulumusa weenyu, ");
INSERT INTO tke_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wewo osasanyedhe nyo vameentoni va athu ateene, ");
INSERT INTO tke_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","waara wi wamooneyela athu a milogo dhimohi dinavaha nthithimiho wa nlogo neenyu Ezarayeli.” ");
INSERT INTO tke_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Babaye ni amaaye a Yesu yotikinaga dhawogaga Sumeyawu dha mwaanaya. ");
INSERT INTO tke_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sumeyawu ahareeliha, wiira wa Mariya, amaaye a Yesu: “Mwaana ola ohusakuliwa wi akale totela yotongwa naari ovenya wa athu ajinji a Ezarayeli, onakale etonyihedho yovanyihana. ");
INSERT INTO tke_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Oliye onodha oneeyihe mobuwelo a mmirimani mwa athu ajinjeene. Nyo mmani okubanya onodha olate murima weenyu woona supadda.” ");
INSERT INTO tke_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wahikala namavuhulela mmohi a mwihiyana eeriwa Anna mwaana a Fanuweli a nlogo na Aseri. Aali owuluvaleene agateliwe akalile yaaka tanu nabiili. ");
INSERT INTO tke_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nuwindo okala maamukwele yaaka makumi matanu namaraaru ni yaaka nayi. Kaavenyamo munyuba ya Mulugu, mbwenye owebedha mahiyu ni mutana ni othuga. ");
INSERT INTO tke_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Vano mudhidhi mmohive olene ahimutamalelaga Mulugu, awogaga dha nriiho na mwaanaya wa ale ateene yajejihedha wooboliwa wa Zheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Egamalile oharihamo dhawoga malamulo a Nabwiya yahiwelela o Galileya oluwani weewa, oNazareti. ");
INSERT INTO tke_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwaanaya owuunuwa ni odhaliwa ononelamo, mahala a Mulugu yaali ni oliye. ");
INSERT INTO tke_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yaaka ni yaaka ababiinya a mwaana yodhowesa oZheruzalemi, omathangani a Paxkwa. ");
INSERT INTO tke_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu agaakwanihile yaaka kumi ni biili, aliwa yahidhowa oZheruzalemi omathangani, woona molemeelela. ");
INSERT INTO tke_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Egamalile malabo a mathanga, ewelagawo, Yesu ahihalaga oZheruzalemi, ababiinya ehinonaga. ");
INSERT INTO tke_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yubuwelaga wi oli ni akwaaye a mulenddoni, yaheeddaga nlabo nateenene nuwindo wambeela omusayela mwa amudhi eewa ni mwa ale yamunonile, ");
INSERT INTO tke_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","yahamfwanyiligiisu yahiwelelaga oZheruzalemi wi yamusayelege. ");
INSERT INTO tke_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Vigavirile malabo maraaru yahimfwanyaga munyuba ya Mulugu agakaratile vaari va anamasuuziha a malamulo avuruwanaga akohaga. ");
INSERT INTO tke_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ateene alene yamwiiwaga yotikinaga vajinjivene ni zelu yaaye ni maakulelo aaye. ");
INSERT INTO tke_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mowaaguva ababiinya egamoonile yaaligi otikiniheya, amaaye yahimwiirelaga: “Mwaanaga, wiiriliwe ela ni hiyo ddi? Ababo ni miyo nahisimwela ni wusayela.” ");
INSERT INTO tke_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Oliye ahawaakulaga, wiira: “Mwahaya bwaddi mwagisayelelinyu? Kamunonile wi eli yoofuneya wi nkalege vade va ababa?” ");
INSERT INTO tke_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mbwenye aliwa kayeewelelagamo yawaaddeligiye. ");
INSERT INTO tke_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Omaruwa vamohi ni aliwa odhowaga oNazareti. Amaaye yoologolela dhego dhatedhene dhedhi mmurimani. ");
INSERT INTO tke_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu owuunuwa ni ononelamo, ni mahala, vameentoni va Mulugu ni va athu. ");
INSERT INTO tke_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Vowaakwana yaaka kumi ni tanu dha omwene wa Tibeeriyo Sezari, Pontiyo Pilatu agali kuminadori oZhudeya, Heroddi agali namathonga a elabo ya oGalileya, ddibile Filipi aali namathonga a elabo yo Etureya ni Tarakoniti, Lusaniya aali namathonga a elabo yo Abilene; ");
INSERT INTO tke_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annasi ni Kayifa yaali apogo a anamakutha. Mudhidhi oyene yahidha madhu a Mulugu wa Zhuwawu, mwaana a Zakariya, agali mwiiddeddereni. ");
INSERT INTO tke_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Zhuwawu aheddeedda mirudda dhatedhene dha nikome na mwihinje Zhorodawu alaleyaga wi ebathiziwe etthwaruwaga, wi eleveleliwe mwa dhoothega. ");
INSERT INTO tke_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Woona mwalebeliwiwa muniivuruni na madhu a namavuhulela Ezaya: “Ndhu nnakuwa mwiiddeddereni: ‘Sasanyedhani rampa a Nabwiya, moogolele dila yaaye. ");
INSERT INTO tke_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Maddiba mateene evuheleliwe, mwango dhatedhene ni thuthuma dhiliganelihiwe dila dhokoromana dhineere woogoliwa. Muli magologodha muliganelihiwe. ");
INSERT INTO tke_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Athu ateene eneere woona ovulumusa wa Mulugu!’” ");
INSERT INTO tke_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Anamwinji yodhowa wi yabathiziwe. Zhuwawu oowoga, eeraga: “Nyo mulogo wa dhivili! Wuwaaddelileni ottawa owali wa Mulugu onafuna odha baani? ");
INSERT INTO tke_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mvahe dhoovaha dhebaribari dhowoneyiha otthwaruwa. Muhambeele owoga wekiinyu: ‘Nihikanna baba eehu Abarahamu.’ Miyo ginowuwaaddelani wi Mulugu onowanda, osaddula mabwe alena wi ekale ahima a Abarahamu. ");
INSERT INTO tke_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Vano badho ehimala osasanyedhiwa, eli vati va mithanko. Mithanko dhatedhene dhihinavaha dhoovaha dhapama dhineere okakathiwa wi dhivokedhiwe omunddoni.” ");
INSERT INTO tke_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nuwindo anamwinji yahimukohaga, yiiraga: “Nneere hiyo ddi?” ");
INSERT INTO tke_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Zhuwawu ahaakulaga, eeraga: “Ole winna malaya meenddi, amvahe nimohi ole ohinna. Ole winna yooja, eerena emodha-modhave.” ");
INSERT INTO tke_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yahifiyaga anamakoha-musoko wi ebathiziwe. Yomukohaga, yiiraga: “Namasuuziha, ki nneerege ddi?” ");
INSERT INTO tke_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ahawaakulaga, eeraga: “Naari kamwenjedhedhe okwaranyiha mwaaddeleliwinyu.” ");
INSERT INTO tke_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Teto anyakoddo yahimukohaga, yiiraga: “Ki hiyo, nneerege ddi?” Oliye ahawaakulaga: “Kammwakege muthu korowa dhaaye momuthusa, kammurathelege muthu. Mudhiveliwege ni yoliveliwa yeenyu.” ");
INSERT INTO tke_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mudhidhi oyene athu yomujejihedha Muthikitheliwi, yowikoha weekiwa akala Zhuwawuya daali Muthikitheliwi. ");
INSERT INTO tke_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zhuwawu ahawaakulaga ateene: “Miyo, epaddi yaaga, ginowubathizani ni mahinje, mbwenye onodha oowodha onagikwaranya miyo naari kagifwanele otapula migoyi dha sapatho dhaaye. Oliye Oneerege wubathizani ni Muneba Woweela ni munddo. ");
INSERT INTO tke_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Etelo yaaye eli mmadani amvethena tirigu wi amuhele vatatani, makataya aapahe ni munddo wohuthima.” ");
INSERT INTO tke_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nuwindo, oolaleya muselu wapama alibihaga ni madhu majinjene. ");
INSERT INTO tke_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Vano Zhuwawu agamusumulule namathonga a murudda, Heroddi ole mwaha womutela Heroddiya, mwadha ddibile ni dhabure dhimohi dheeriliyena, ");
INSERT INTO tke_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heroddi ahenjedhedha dhabure dhimohi vomuhela Zhuwawu mukaambura. ");
INSERT INTO tke_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dhahipadduwa athu ateene ebathiziwaga, teto ahibathiziwa Yesu. Alobelaga odhulu wahithuleya. ");
INSERT INTO tke_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Muneba Woweela wahikitela va Oliye ni mooneyelo a kangayiwa. Vano wahiiweya ndhu odhulu neerilege: “We Oli Mwaanaga; odhivela aaga, mwa we ginodhiveliwa.” ");
INSERT INTO tke_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu, aganna yaaka dhowaakwana makumi maraaru, ahambeela mabasa aaye. Aali, woona mweerelisu, mwaana a Zhuuze, mwaana a Heli, ");
INSERT INTO tke_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli mwaana a Mathati, Mathati mwaana a Levi, Levi mwaana a Meliki, ola di mwaana a Yannayi, mwaana a Zhuuze, ");
INSERT INTO tke_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zhuuze mwaana a Matathiya, Matathiya mwaana a Amosi, Amosi mwaana a Nahumu, ola di mwaana a Esili, mwaana a Nagayi, ");
INSERT INTO tke_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi mwaana a Maathi, Maathi mwaana a Matathiya, Matathiya mwaana a Semeyini, ola di mwaana a Yoseki, mwaana a Yoda, ");
INSERT INTO tke_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mwaana a Yowanane, Yowanane mwaana a Resa, Resa mwaana a Zorobabeli, ola di mwaana a Salatiyeli, mwaana a Neri, ");
INSERT INTO tke_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mwaana a Meliki, Meliki mwaana a Addi, Addi mwaana a Kosamu, ola di mwaana a Elemadamu, mwaana a Eri, ");
INSERT INTO tke_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri mwaana a Zhoxuwe, Zhoxuwe mwaana a Eliyeeziri, Eliyeeziri mwaana a Yorimu, ola di mwaana a Mathati, mwaana a Levi, ");
INSERT INTO tke_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi mwaana a Sumeyawu, Sumeyawu mwaana a Zhuda, Zhuda mwaana a Zhuuze, ola di mwaana a Yonamu, mwaana a Eliyakimu, ");
INSERT INTO tke_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu mwaana a Meleya, Meleya mwaana a Menna, Menna mwaana a Matatha, ola di mwaana a Nathani, mwaana a Davidi, ");
INSERT INTO tke_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidi mwaana a Yese, Yese mwaana a Obeddi, Obeddi mwaana a Bowazi, ola di mwaana a Sala, mwaana a Naaxoni, ");
INSERT INTO tke_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naaxoni mwaana a Aminaddabe, Aminaddabe mwaana a Adimini, Adimini mwaana a Arini, Arini mwaana a Hesiromo, ola di mwaana a Perezi, mwaana a Zhuda, ");
INSERT INTO tke_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zhuda mwaana a Yakobo, Yakobo mwaana a Ezaaki, Ezaaki mwaana a Abarahamu, ola di mwaana a Teera, mwaana a Nakori, ");
INSERT INTO tke_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakori mwaana a Seruge, Seruge mwaana a Ragawu, Ragawu mwaana a Pelege, ola di mwaana a Eberi, mwaana a Sala, ");
INSERT INTO tke_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala mwaana a Kayinani, Kayinani mwaana a Arifaxadi, Arifaxadi mwaana a Semu, ola di mwaana a Nowe, mwaana a Lameki, ");
INSERT INTO tke_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki mwaana a Methuzela, Methuzela mwaana a Enoki, Enoki mwaana a Zharedi, ola di mwaana a Mahalaleyeele, mwaana a Kayinani, ");
INSERT INTO tke_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinani mwaana a Enoosi, Enoosi mwaana a Sethi, vano ola, di mwaana a Adamu, mwaana a Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu, agawelilewo omwihinjeni Zhorodawu, ahidhaaleliwa ni Muneba Woweela. Muneba mmohive wahimuthukulela mwiiddeddereni, ");
INSERT INTO tke_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","mowaakwana malabo makumi manayi, wewule ehiiwaga ni Sathana. Kaaja yego malabo alene. Omamalelowa ahivoliwa dala. ");
INSERT INTO tke_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Vano, Sathana ahimwiirela: “Akala Oli Mwaana a Mulugu, wiirele nibwe ndda nsadduwe okale mukaathe.” ");
INSERT INTO tke_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mbwenye Yesu ahaakulaga, wiira: “Dhihilebiwa: ‘Kahuwo mukaatheve onamukalihana muthu egumi.’ ” ");
INSERT INTO tke_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Vano, Sathana ahimuthukulelaga vootaama, omooniha mowaaguva omwene wateene wa mwiilaboni. ");
INSERT INTO tke_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sathana ahimwiirelaga: “Gineere wuvaha othonga wula wateene ni nthithimiho neewa, vowi gihivahiwa, vano ginoovaha wa oyene ginamfunimina. ");
INSERT INTO tke_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wagikokorela, ogeebedha, dhatedhene dhinakala dhaawo.” ");
INSERT INTO tke_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu ahimwaakulaga, wiira: “Dhihilebiwa: ‘Omwebedhe Nabwiya Mulugu aawo, omwiimelela Oliyeeneve, baahi.’ ” ");
INSERT INTO tke_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nuwindo Sathana ahimuthukula, omudhowana oZheruzalemi, omugweliha vadhulu vanyuba ya Mulugu, omwiirela: “Akala Muli Mwaana a Mulugu, mulupele vati, ");
INSERT INTO tke_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","vowi dhihilebiwa: “‘Mulugu oneere waaruma angero aaye wi yuwing'aneleni; ");
INSERT INTO tke_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","vano, aliwa eneere wuhiddeelani ni madada eewa, wi manyalo eenyu enadha eporeye ni mabwe.’ ” ");
INSERT INTO tke_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu ahaakulaga, wiira: “Nda dhihiwogiwa: ‘Ohumweehe Nabwiya Mulugu aawo.’ ” ");
INSERT INTO tke_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sathana vagomeliwiye omweeha, ahimwihiyaga ajejihedhaga ofiya mudhidhi wofwaneelela. ");
INSERT INTO tke_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Vano Yesu ahiwelela oGalileya ni owodha wa Muneba Woweela, bili yaaye yahiweya, okumela wewule ni mirudda dhatedhene dhowaaddamana. ");
INSERT INTO tke_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Oosuuziha wewule munyuba dha malobelo dha aZhudewu, athu ateene yomutamaala. ");
INSERT INTO tke_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nuwindo Yesu ahidhowa oNazareti wewo waleliwiye. Nlabo na Sabuddu woona molemeelela, ahivolowaga nyuba ya malobelo. Ahiimelaga wi eelenge wewule. ");
INSERT INTO tke_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yahimwinkaga niivuru na namavuhulela Ezaya. Oliye ofugula, ofwanya valebiwe madhu ala: ");
INSERT INTO tke_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Muneba wa Mulugu ohugikitela. Ohugithikithela wi gaalaleyele muselu wapama aliba orabula. Ogirumile wi gilaleyele wooboliwa wa athu eli mukaambura, aliba ohoona wi yoonege, ni watapula ale yinna goyi, ");
INSERT INTO tke_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","wi gilaleyele yaaka ya mahala a Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ageelengile, ahifugaga niivuru ndde, omwinka mwiimeleli, okaraati. Vevale, meento a athu ateene yaaligi va Oliye, yegi omusugwa. ");
INSERT INTO tke_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Vano, Yesu ahambeelaga owoga, wiira: “Peeno veva, dhatedhene mwiwiliinyu odheela Maleba Otaleleya, gelengilimi dhihaakwanela.” ");
INSERT INTO tke_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ateene yomwiirelaga onamoona ni otikina mwa madhu aaye amahala, yadheela vamulomoni vaaye. Yookohanaga, yiiraga: “Olaya kahuwo mwaana a Zhuuze?” ");
INSERT INTO tke_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu ahawaaddela, wiira: “Mohanganyedha munodha mugiwogele nigano: ‘Nowi we oli ng'anga, wiyilihe wekaawo! Dhatedhene mwiwiliihu mwiirilinyuna oKafaranawu, Mwiirena owaninyu wuno.’” ");
INSERT INTO tke_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu ahiwogagave, eeraga: “Ebaribareene Ginowuwaaddelani: Kalivo namavuhulela naari mmohi, onaakeliwa ni nriiho veelaboni vaaye. ");
INSERT INTO tke_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ebaribareene Ginowuwaaddelani wi mudhidhi wa Eliyazi wahikala amaamukwele ajinjeene muEzarayeli. Wahikala yuumi yaaka thaaru ni mweeri mitanu na mmohi, muzongwe ahiirubwaga yahikalawo dala yulubale elabo yateene. ");
INSERT INTO tke_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eliyazi karumiwe naari wa amaamukwele ale, arumiwe wa maamukwele oSarapita, baahi, akala waaddamela oSidoni. ");
INSERT INTO tke_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mudhidhi wa Elizewu, muEzarayeli mwahikala aliba maredda gwee, kaavo naari mmohi eelihiwe – aali Naamani, baahi, muSiriya.” ");
INSERT INTO tke_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Athu ateene yaaligi munyuba ya malobelo yewaligiwa, yahitakaleliwaga vajinji. ");
INSERT INTO tke_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yahimukumihaga Yesu muluwani, omudhowana vadhulu va mwango wootaama wewo wamagiliwa nluwa neewa, ni efunelo yowi yamvokedhe musiddo mooddiha. ");
INSERT INTO tke_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mbwenye Yesu ahiviraga vaari veewa, ovenyavo. ");
INSERT INTO tke_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Vano Yesu ahikitelaga oKafaranawu, mudhi mulubale wa oGalileya. Nlabo na Sabuddu egi wasuuziha athu munyuba ya malobelo. ");
INSERT INTO tke_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Athu yotikinaga masuuziho aaye, vowi yaali madhu othonga. ");
INSERT INTO tke_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ahikalagavo mulobwana mmohi ahiddiwe ni muneba wabure. Ahikuwaga ni ndhu notaama, wiira: ");
INSERT INTO tke_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iii! Ninna ddi hiyo ni nyo, Yesu a oNazareti? Mudheele ontolosa? Miyo guhuunonani wi Muli Oweela a Mulugu!” ");
INSERT INTO tke_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu ahimusumululaga, wiira: “Kamaalawo! Okume mwa muthu oyo!” Vano muneba wabure ole wahimutongwihedha vati vameentoni va athu ateene, okumamo mwa muthu ole, kuwamporosege. ");
INSERT INTO tke_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ateene yegi otikina valubalevene. Ewogaga muthu ni mukwaaye: “Alaya madhu baani? Enathonga ni kopolo mineba dhootakala wi dhivenyemo; dhivenyamo.” ");
INSERT INTO tke_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bili ya Yesu yoovuwa mirudda dhatedhene dhowaaddamela. ");
INSERT INTO tke_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu ahimaruwaga nyuba ya malobelo, odhowa vade va Simawu. Omfwanya mbogohi a Simawu ahikalagana goyi mwaha wa nipaddawe nulubale. Anaamudhi aaye yahimulobaga wi amuyilihe. ");
INSERT INTO tke_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ahisusedhaga vaaligi muredda, ageemelile, ahithonga wi nipaddawe nimwihiye; omwihiya, oyila. Mowaaguva ovenya, wambeela waakamihedha aliwa. ");
INSERT INTO tke_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ociguwoni, athu ateene yegi waadhana wa Yesu alene yannaga dhiredda dhohiyana-hiyana. Egi waayiliha, vowaahela madada mmohi ni mmohi. ");
INSERT INTO tke_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vaaligi, mineba dhabure dhegi okuma mwa athu ajinji. Dhigakumile, dhookuwaga, dhiiraga: “Nyo Muli Mwaana a Mulugu!” Yesu oohihaga wi dhihiwoge vowi dhahinona wi Oliye di Kirixtu. ");
INSERT INTO tke_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ode ogasile, Yesu ahidhowaga mburo mmoheene yeekawo. Anamwinji yoomusayelaga, egamfwanyile yahimuwaadelelaga wi ahidhowe. ");
INSERT INTO tke_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mbwenye Oliye ahawaaddelaga, wiira: “Eli yofuneya wi gaalaleyele Muselu Wapama wa Omwene wa Mulugu teto mmaluwani amohi, vowi si dhendo Girumeliwiimi.” ");
INSERT INTO tke_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nuwindo, oolaleyela munyuba dha malobelo dha oZhudeya. ");
INSERT INTO tke_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nlabo nimohi Yesu ahiimelaga seresere ya nyaza yo oGenazareti, athu ajinji yegi ompinyaminya wi yiiwe madhu a Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Oliye ahoonaga mwanddeya miinddi seresere ya nyaza, anamatotaya yahikitagamo, yaahuwaga mathavi eewa. ");
INSERT INTO tke_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu ahigwelaga mmwanddeyani mmohi, waaligi wa Simawu, ahimulobaga wi asusihedhe vang'ono munyaza. Ahikaratigi, wambeela wasuuziha anamwinji. ");
INSERT INTO tke_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Agamalile owoga, ahimwiirelaga Simawu: “Susihedha wooddiiha mwabwinihe mathavi eenyu wi mutote.” ");
INSERT INTO tke_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simawu ahaakulaga, wiira: “Namasuuziha, mahiyu mateene nihilaba kanipile yego. Mbwenye, vowi di Nyo munagiruma waabwiniha, miyo gineere orumeedha.” ");
INSERT INTO tke_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Egabwinihile mathavi, yahipaga somba dhijinji mathaviya yahambeelaga otaleya. ");
INSERT INTO tke_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yahiiraga etonyihedho wa akwiiwa yaaligi mmwanddeyani mmohi, wi edhe yaakamihedhe. Aliwa yahidhowaga, odhaaliha mwanddeya dhaamiinddi dhene ofiyedha ohala vang'ono wi dhibwine. ");
INSERT INTO tke_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simawu Peduru agoonile nde, ahikokoraga vakuukuvi ni Yesu, wiira: “Nabwiyani, mususe wa miyo vowi gili namathega.” ");
INSERT INTO tke_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simawu ni akwaaye yahitikinaga menjivelo a somba dhapiligiisu. ");
INSERT INTO tke_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiyago ni Zhuwawu, amwaana a Zebideyo, akwaaye a Simawu, teto yahitikinaga vajinjivene. Yesu ahiiraga Simawu: “Kawoove! Okuma dhiinoveva odhowa osogolo onakale namatota a athu.” ");
INSERT INTO tke_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mowindo yahisusihedhaga mwanddeya dheewa ode, ohiya dhatedhene, omuharaga Yesu. ");
INSERT INTO tke_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dhahipadduwa ayi, Yesu aaligi nluwa nimohinene, mwahikala mulobwana mmohi anna maredda mumwiilini wateene. Agamoonile Yesu, ahikokoraga, oworomihedha kove vati, omuloba, wiira: “Nabwiya, Nyo muhukanna owodha, mwafuna, mugeelihe.” ");
INSERT INTO tke_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ahimutapulelaga madada omukahinyana, wiira: “Gihifuna. Kala oweela!” Mudhidhi olene maredda yahimmalelaga. ");
INSERT INTO tke_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu ahimuthonga: “Onamwaaddele mmohi; mbwenye odhowe wadhoonihedhe wa anamakutha ni oveleela mukutho woweelihiwa waawo, woona mwalamulele Mozezi, okale onamoona wa athu ateene.” ");
INSERT INTO tke_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mowindo, bili ya Yesu yoovuweya vajinjivene. Athu ajinji yoodha omvuruwana, ni oyilihiwa dhiredda dheewa. ");
INSERT INTO tke_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesu oopothowesa, odhowa mburo mmohi vayeeka, olobelaga. ");
INSERT INTO tke_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nlabo nimohi Yesu eeraga osuuziha. MaFarizi ni anamasuuziha a malamulo yahikaratigi mwemule, yadheelege mirudda dhatedhene dha oGalileya, dha oZhudeya ni dha oZheruzalemi. Owodha wa Nabwiya waaligi ni Oliye wi aayilihe aredda. ");
INSERT INTO tke_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nuwindo alobwana amohiwa yahidhaaga yamuthukulege muliba maredda emuthebaga vanteteni. Yoosayelaga vomvolowana wi yamurule vameentoni va Yesu. ");
INSERT INTO tke_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ehoonile vomvolowana ni mwaha wa anamwinji. Yahigwelaga vadhulu va nyuba mwaaligi Yesu. Ovenyihavo mapalipali, okitelihavo ntete vaari va athu, vameentonivene va Yesu. ");
INSERT INTO tke_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu vowoona nroromelo neewa, ahimwiirelaga muliba oragala ole: “Mukwaaga, dhoothega dhaawo dhihileveleliwa.” ");
INSERT INTO tke_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anamasuuziha a malamulo ni maFarizi yowubuwelaga: “Olaya onanyemula dha Mulugu baani? Onalevelela dhoothega, baani? Muluguve, baahi.” ");
INSERT INTO tke_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu vonona dhobuweligiisu, ahawiirelaga: “Mmirimani mweenyu munaanganyedhela ddi? ");
INSERT INTO tke_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yoohurusa siivi: wiira, ‘Dhoothega dhaawo dhihileveleliwa,’ naari wiira, ‘Venya weedde’? ");
INSERT INTO tke_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mbwenye wi munone Mwaana a Muthu ohukanna othongi mwiilaboni ya vati woolevelela dhoothega” — ahimwiirelaga muliba oragala ole — “Ginowaaddela: Ovenye, othukule ntete naawo, odhowege vade vaawo.” ");
INSERT INTO tke_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mowaaguva ahivenyaga vameentoni veewa, othukula ntete vakonatiligiiye, owelela vade, amutamalaga Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ateene yahitikiniheyaga ni woova, yomuthithimihaga Mulugu, yiiraga: “Peeno dhoonilihu sotikiniha.” ");
INSERT INTO tke_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Dhigeereyile nde, Yesu ahivenyagavo, omoona namakoha-musoko agakaratile vowaakela korowa, eeriwa Levi. Omwiirela: “Giharege.” ");
INSERT INTO tke_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi ahivenyaga, ohiya dhatedhene, omuharaga. ");
INSERT INTO tke_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Vano Levi ahimusasanyedhela Yesu mathanga malubale vade vaaye. Anamakoha-musoko ajinjeene ni athu amohiwa yaaligi vameeza ni aliwa. ");
INSERT INTO tke_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mbwenye maFarizi ni anamasuuziha a malamulo yegi wawaaba anamasuuza a Yesu. Yahaakohaga, yiiraga: “Munaja, ni ong'wa ni anamakoha-musoko, ni anamathega alubale, mwaha wa ddi?” ");
INSERT INTO tke_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu ahawaakulaga, wiira: “Agumi kinamurabulela ng'anga, mbwenye aredda. ");
INSERT INTO tke_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kagidheele wawiithana athu ooharihamo, mbwenye gadheele anamathega wi etthwaruwe.” ");
INSERT INTO tke_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Vevale, maFarizi yahiwogaga ni Yesu, wiira: “Anamasuuza a Zhuwawu enothuga, elobelaga dila biili-biili. Anamasuuza a maFarizi teto enowiirana ndo. Mbwenye aawo enooja, enoong'wa.” ");
INSERT INTO tke_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ahawaaddelaga, wiira: “Akwaaye a namatela enothuga agali vevo namatelaya? Kadhinandeya! ");
INSERT INTO tke_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mbwenye nneere ofiya nlabo onavenyihiwiyevo vaari veewa namatelaya; mudhidhi oyene eneerege othuga.” ");
INSERT INTO tke_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nuwindo Yesu ahawogela musibe ola, wiira: “Kalivo muthu onatala ecapa ya yowara exa, acapelana yowara yawale. Eera ndo, enonongeya, yacapeliwana exa, kinafwaneelela ni yawale. ");
INSERT INTO tke_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kalivo onamuhela vinyu muxa mmathumbani a makupa awale. Eera ndo, vinyu muxa onotala mathumbaya; onothathiya vinyuya, mathumbaya enonongeya. ");
INSERT INTO tke_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mohiyaniha, vinyu muxa onaheliwa mathumba maxa wi dhatedhene dhilogoleleye. ");
INSERT INTO tke_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kalivo onamung'wa vinyu awale, amfunaga muxa, vowi oneerege: ‘Awale dili pama.’” ");
INSERT INTO tke_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabuddu mmohi, Yesu aviraga mmiddani mwa tirigu, anamasuuza aaye yegi ovulula ni madada mangala a tirigu, othikithaga, otakunaga. ");
INSERT INTO tke_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","MaFarizi amohiwa yahimukohaga, yiiraga: “Dhinakooddihiwa nlabo na Sabuddu, muneerelana ddi?” ");
INSERT INTO tke_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu ahawaakulaga, wiira: “Nyo kamweelengile dheerile Davidi ni akwaaye aganna dala? ");
INSERT INTO tke_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ahivolowaga nyuba ya Mulugu, othukula mikaathe dhoreelihiwa, oja. Waavaha ale yannigiyena. Mikaathe nde dhihinarumeedhihiwa ojiwa bure mbwenye anamakutha weekiwa.” ");
INSERT INTO tke_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu ahenjedhedhaga, wawaaddela: “Mwana a Muthu dili Nabwiya a Sabuddu.” ");
INSERT INTO tke_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabuddu mmohiya, ahivolowaga nyuba ya malobelo, egi osuuziha. Vano, mwemule mwahikalaga mulobwana mmohi akwile ndada na moono wooja. ");
INSERT INTO tke_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Anamasuuziha a malamulo ni maFarizi yoomusugwaga, esayelaga woona akala amuyilihe muthu nlabo na Sabuddu wi ekalena yomusumelela. ");
INSERT INTO tke_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mbwenye Yesu aganonile moobuwelelo eewa, ahimwiirelaga mulobwana ole. “Venya, osusedhe vaari va.” Oliye ovenya, okala owimeleene. ");
INSERT INTO tke_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Vano Yesu ahawiirela aliwa: “Ginowukohani, munoona havi? Nlabo na Sabuddu dhinarumeedhiwa siivi? Wiira dhapama, naari dhabure? Ovulumusa, naari opa?” ");
INSERT INTO tke_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Vano ahasugwaga, yamwapelege, omwiirela mulobwana ole: “Katapula ndada naawo.” Oliye wiirana ndo, ndada oyila. ");
INSERT INTO tke_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mbwenye aliwa yahitakaleliwaga vajinjivene, okanganelaga mwakaleligiisu esayelaga dhoofuna omwiirana Yesu. ");
INSERT INTO tke_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nlabo nimohi mwa mudhidhi olene, Yesu ahidhowaga wi alobele omwangoni. Ahivireliwaga mahiyu mateene alobelaga wa Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Vano ogasile, ahawiithanaga anamasuuza aaye, waasakulavo kumi ni abiili, mwa ayene. Waasakulavo, yaavahiliye ndina na arumiwi: ");
INSERT INTO tke_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simawu, amvahiliye ndina na Peduru; ni Andere, ddibilaaye; Tiyago ni Zhuwawu; Filipi ni Baritolomeyo; ");
INSERT INTO tke_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matewuzi; ni Tome; Tiyago, mwaana wa Alifiyu; ni Simawu, eeriwa Muzeloti; ");
INSERT INTO tke_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zhuda, mwaana a Tiyago; ni Zhuda Esikariyothi, ole ampelekile Yesu. ");
INSERT INTO tke_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu, vamohi ni anamasuuza aaye, yakitaga omwangoni. Ahiimelaga vamusewasewani vatugumanege anamasuuza ajinjeene, ni muthithi mulubale wa athu amohi, yadheelaga murudda wateene wo oZhudeya, ni oZheruzalemi, ni a seresere ya nyaza yo oTiru ni oSidoni. ");
INSERT INTO tke_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yadheelege omwiiwa ni oyilihiwa dhiredda. Ale yarabulihiwa ni mineba dhabure yooyilihiwa. ");
INSERT INTO tke_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Anamwinji ateene yoosayelaga omukahinya, vowi kopolo dhookuma mwa Oliye, wayilihaga ateene. ");
INSERT INTO tke_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Vano Yesu ahawang'anaga anamasuuza aaye, wawaaddela, wiira: “Oreelihiwa di nyo, mwihinna yego, vowi Omwene wa Mulugu bweenyu. ");
INSERT INTO tke_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Oreelihiwa di nyo mwinna dala dhiinova, vowi muneere orubala. Oreelihiwa di nyo munaandda dhiinova, vowi muneere oteya. ");
INSERT INTO tke_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Oreelihiwa di nyo athu yowiiddani, ekoodda weedda ni nyo, yuruwanagani, enyemulaga ndina neenyu woona nabure, mwaha wa Mwaana a Muthu. ");
INSERT INTO tke_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Teyelani nlabo nenddo, agalalani ni olupa mwaha wi yothuviwa yeenyu si yulubale odhulu. Vowi yeere ndo awale-wale eewa ni anamavuhulela. ");
INSERT INTO tke_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mbwenye ooddilu di nyo oreela, vowi muhakela yowuhagalasani. ");
INSERT INTO tke_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ooddilu di nyo munarubala mudhidhi ola, vowi munodha mvoliwe. Ooddilu di nyo munateya dhiinoveva, vowi munodha mukubanye ni wuundda. ");
INSERT INTO tke_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ooddilu di nyo, yootamalagani athu ateene, vowi awale-wale eewa yeerile ndo ni anamavuhulela ooratha. ");
INSERT INTO tke_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mbwenye Ginowuwaaddelani nyo, munagiiwa: Mwaadhivelege amwiiddani eenyu. Mwawiirelege dhapama ayene enowiiddani. ");
INSERT INTO tke_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mwareelihege ayene enowulumelani, mwalobelelege ale enootabusani. ");
INSERT INTO tke_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ole onoddwadhani mbarutuni, mmurugunusedhe kukuru emohi. Onowaakani kazako, kamukooddihedhe wuwaakani maleyaya. ");
INSERT INTO tke_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mwaavahege ateene enoolobani, ole onathukula eli yeenyu, kammusanye wi owelihedheni. ");
INSERT INTO tke_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dhatedhene dhinafuniinyu wi athu yuwiirelegeni, nyo mwawiirelege aliwa. ");
INSERT INTO tke_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mwaadhivelaga alene enoodhivelani, munadha muthuviwe ddi? Anamathegeene enowaadhivela teto alene enaadhivela aliwa. ");
INSERT INTO tke_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mwawiirelaga dhapama alene enowiirelani dhapama, munadha muthuviwe ddi? Anamathegeene teto enowiirana ndo. ");
INSERT INTO tke_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mwaabolihaga alene munajejihinyu wi yuwelihedheni, munadha muthuviwe ddi? Vowi, ni anamathegeene enobolihihana anamathegave, ejejihedhaga owelihedhiwa yankene. ");
INSERT INTO tke_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mbwenye nyo, mwaadhivelege amwiiddani eenyu, mwawiirelege dhapama, ni obolihiha muhujejihedhaga waakela yego. Mweera ndo, yothuviwa yeenyu enaakale yijinji. Vano, munaakale aana a Mudhulu-dhulu. Vowi Oliye di apama ni alene ehinamutamala ni agongomwa. ");
INSERT INTO tke_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kalani athagaraga woona Babiinyu Oli athagaraga. ");
INSERT INTO tke_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Muhuthonge, kamudha muthongiwa. Muhukone, kamudha mukoniwa. Mulevelelege wi mudhe muleveleliwe. ");
INSERT INTO tke_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mvahege, munodha mvahiwe mpimo wapama, woopinyedha, woosukuseleya, wootekuma. Moowomeliwa murima muneere ovahiwa, vowi ni mpimo oyene munaapiminyuna akwiinyu, munodha mpimiwena.” ");
INSERT INTO tke_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Vano Oliye ahiwelelaga, owoga vevo vaaligi muthithi mwa musibe, wiira: “Dhili dhoofwaneelela wi muliba ohoona amusogolele muliba ohoona mukwaaye? Kinamorele mmuliddini abiilene? ");
INSERT INTO tke_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Namasuuza kanamukwaranya namasuuziha aaye, mbwenye ateene alene enavirihamo masuuziho, enokala woona anamasuuziha eewa. ");
INSERT INTO tke_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Onooniwe ekata mwiintoni mwa ddibilo, wula ohusugwaga emiri eli mwiintoni mwaawo mwaha wa ddi? ");
INSERT INTO tke_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Onanda addi omwiirela ddibilo: ‘Ddibilaaga, mahi givenyihemo ekata eli mwiintonimo,’ ohoonaga emiri eli mwiintoni mwaawo? Namaleketha, vowambeela ovenyihemo ekata eli mwiintoni mwaawo, vano oneerege woona pama wi ovenyihemo ekata eli mwiintoni mwa ddibilo.” ");
INSERT INTO tke_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kuliwo muthanko wapama onavaha dhoovaha dhabure, naari muthanko wabure onavaha dhoovaha dhapama. ");
INSERT INTO tke_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Muthanko oli wateene onononeya ni dhoovaha dhiwa. Mwaha wi kinahapiwege makaaju mmingani, naari kadhinahapiwege manga mmurothoni. ");
INSERT INTO tke_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muthu apama onokumiha dhapama dhoologolela dha mmurimani mwaaye, teto muthu abure onokumiha dhabure dhoologolela dha mmurimani mwaaye. Mwaha wi mulomo onowoga dhidhaalile mmurimani. ");
INSERT INTO tke_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mwaha wa ddi munagithaninyu ‘aNabwiya’ wula muhiiragana dhinowaaddelimini? ");
INSERT INTO tke_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Olene onadha wa miyo, eewa madhu aaga, avirihagamo, gineere wuwoonihani onaliganiyena. ");
INSERT INTO tke_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Onaligana ni mulobwana mmohi amagaga nyuba yaaye, ahitiba muliddidha vakothokwani oddihiha osiddela. Vano, mwihinje wahidhaala, mahinje ale yahitekumela ode, yahifwanya nyuba kayathikeyile. Mwaha wi nyubaya yahimageya pama. ");
INSERT INTO tke_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Vano, ole oneewa madhu aaga ahavirihagamo, onaligana woona mulobwana amagile nyuba yaaye ahisiddelile, kaatibele mooddihiha. Vano, mahinje edhaaga, yahitekumela nyuba ele mowaaguva yahitongwa. Obwanyuwavo yateene.” ");
INSERT INTO tke_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu agamalile owoga madhu mateene ale wa nlogo, ahivolowaga oKafaranawu. ");
INSERT INTO tke_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mwemule mwahikala musogoleli mmohi a anyakoddo zana a aRoma ahikalana mwiimeleli amudhiveliiye vajinji. Mwiimeleli ole oobulela vajinji ahalile vang'ono wi akwe. ");
INSERT INTO tke_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Musogoleli ole ageewile dhawogiwa dha Yesu, ahaaruma apogo amohiwa aZhudewu wa Oliye yamulobe wi adhe, amuyilihe mwiimeleli aaye. ");
INSERT INTO tke_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Egafiyile wa Yesu, yahimulobaga ni ntidi, yiiraga: “Muthu ole dofwaneelela wi mmwiirele dhedhi, ");
INSERT INTO tke_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mwaha wowi onodhiveliwa ni nlogo neehu, ohufiyedha onimagela nyuba ya malobelo.” ");
INSERT INTO tke_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu ahidhowa ni aliwa. Aaddamelaga vang'ono ofiya vade, musogoleli ole ahaaruma akwaaye wi yeere: “Nabwiyani, kamukukumuwe, kagifwaneelele wi nvolowe mba mwaaga. ");
INSERT INTO tke_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mwahaya buyeene, gihidheliimi menka goonile yowi naari kagifwanelele wi giwoge ni nyo. Mbwenye muwoge ndhu nimohive baahi, mwiimeleli aaga onoyila. ");
INSERT INTO tke_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mwaha wowi ni miyeene ginothongiwa, teto gihikanna anyakoddo ginaathongimi. Geera: ‘We, kadhowa,’ oliye onodhowa; wa mmohiwa, ‘We, kadha,’ onodha. Geera mwiimeleli aaga: ‘We, kasasanya ela,’ onosasanya.” ");
INSERT INTO tke_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ageewile madhu ale, ahitikinaga, orugunuwa wawang'ana ale yamuharaga, wiira: “Ginowuwaaddelani naari muEzarayeli kagifwanyilemo nroromelo nulubale nothabwa woona ndda.” ");
INSERT INTO tke_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Vano, aliba orumiwa ewelelaga vade, yamfwanyilege mwiimeleli agayilile. ");
INSERT INTO tke_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Vovira mudhidhi vang'ono, Yesu ahidhowaga oluwani neeriwa Nayimi, vamohi ni anamasuuza aaye ni athu ajinjeene. ");
INSERT INTO tke_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aaddamelaga ofiya vamulago vanluwa vevale, ahigumanaga ni athu yathukulege muruthu edhowaga omasiye. Aaligi mwaana mmohive a maamukwele. Athu ajinjeene a muluwani mule yaaligi ni maamukwele ole. ");
INSERT INTO tke_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nabwiya agamoonile ahimweddiwelaga thagaraga, wiira: “Kawuundde.” ");
INSERT INTO tke_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Agafiyile vakukuuve ahikahinyaga ntete ale yathukulege wiimela. Yesu wiira: “Muzombwe, miyo ginothonga, kavenya!” ");
INSERT INTO tke_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mwanookwa ahivenyaga, okaraati, wambeela owoga. Vano Yesu omuwelihedha wa ammaaye. ");
INSERT INTO tke_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Athu ateene yowoovaga. Yoomutamalaga Mulugu, yiiraga: “Namavuhulela mulubale ohooneya vaari va hiyo, Mulugu oheeddela nlogo naaye wi akamihedhe.” ");
INSERT INTO tke_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Muselu ola, wawoga dha Oliye, wahivuwa oZhudeya ni mirudda dhatedhene dhowaaddamela. ");
INSERT INTO tke_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Anamasuuza a Zhuwawu yahidhowaga omwaaddela dhego dhatedhene dhende. Zhuwawu ahawiithanaga abiili mwa aliwa, ");
INSERT INTO tke_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","waaruma wa Nabwiya wi yamukohe: “Akala dinyeene eeriwa onodha, naari nimujejihege mmohiwa?” ");
INSERT INTO tke_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Anamasuuza ale egafiyile vaaligi Yesu, yahiiraga: “Zhuwawu Namabathiza ohuniruma wi nuukoheni: ‘Akala dinyeene eeriwa onodha naari nimujejihege mmohiwa?’” ");
INSERT INTO tke_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mudhidhi olene, Yesu ahayiliha athu ajinji dhiredda, dhabure dhimohi dhaakathamiha, ni okumiha mineba dhabure, ni wawooniha aliba ohoona ajinji. ");
INSERT INTO tke_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Oliye ahawaakulaga: “Dhowani, mwamwaaddele Zhuwawu nde dhoniliinyu ni dhiwiliinyu: aliba ohoona enowoona, aliba otopinya enoweedda, aliba maredda enoweelihiwa, aliba ohiiwa enowiiwa, anookwa enovenyihiwa, ni oorabula enolaleyeliwa muselu wapama. ");
INSERT INTO tke_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Oreelihiwa duleene ohunookuwa mwaha wa Miyo.” ");
INSERT INTO tke_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Egavenyilevo anamarumiwa a Zhuwawu, Yesu ahambeelaga owoga ni athu mwaha wa Zhuwawu, eeraga: “Mwadhowile mwiiddeddereni woona ddi? Bango yothikeya ni pevo? ");
INSERT INTO tke_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ki-to mwagele woona ddi? Muthu oowara guwo dhofeewa? Ale enawara dhapama enakala mburo dhooddiddilela, enakala mmanyubani o omwene. ");
INSERT INTO tke_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ki-to mwagele woona ddi? Namavuhulela? Eee, Miyo Ginowuwaaddela wi oliye onomukwaranya namavuhulela. ");
INSERT INTO tke_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ola di oyene onawogiwa mmalebani: “‘Ginowurumihedha vasogolo vameentoni vaawo murumiwi aaga, oyene onasasanyedhe dila vasogolo vaawo.’ ");
INSERT INTO tke_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Miyo Ginowuwaaddelani mwa oobaliwa ni mwihiyana, kaavo oomukwaranya Zhuwawu, mbwenye mung'ono mu omweneni wa Mulugu, oyo dili omukwaranya oliye.” ");
INSERT INTO tke_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Vano athu ohiyana-hiyana ateene, ofiyedha anamakoha-musoko, yeewile madhu a Yesu, bayeene yaakwanihile odidela ebaribari ya Mulugu, vowi yahirumeedha obathiziwa ni Zhuwawu. ");
INSERT INTO tke_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mbwenye maFarizi ni anamatapulela a malamulo kayaakwanihile efunelo ya Mulugu, vowi aliwa kayarumeedhile obathiziwa ni Zhuwawu.) ");
INSERT INTO tke_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu ahiwogaga, eeraga: “Ginaaliganihe ni aani mulogo wa mudhidhi ola. Ki enafwanafwana ni aani? ");
INSERT INTO tke_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Enafwanafwana ni ahima ekeratile vamusika, nikuru nimohi yaakuwelaga ni amohiwa, yiiraga: “‘Hiyo nuhuwoobelani nvilovilo, kamwiinile, nihiiba jibo yathagaraga, nyo kamunddile.’ ");
INSERT INTO tke_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Zhuwawu Namabathiza ohudha, ahijaga mukaathe, ahing'waga vinyu, nyo muni: ‘Ohukanna muneba wabure.’ ");
INSERT INTO tke_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ohudha Mwaana a Muthu ajaga, ang'waga, nyo muni: ‘Ole muliba nrima, namang'wa vinyu, akwaaye ba anamakoha-musoko ni anamathega!’ ");
INSERT INTO tke_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mbwenye ale enarumedha ononelamo wa Mulugu, enowooniha wi dila yaaye si yebaribari.” ");
INSERT INTO tke_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yesu ahiwobiwa ni mFarisi mmohi wi aje vade vaaye. Agavolowile mba mwa mFarizi, Yesu ahikaratigi vamajelo. ");
INSERT INTO tke_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Moone, muluwani mule, mwahikalaga mwihiyana mmohi aali oothega. Ageewile dhowi Yesu onaja mba mwa mFarizi, ahidhaagana garafwa napama mwaaligi makura oonukwela a mutheengo mulubale. ");
INSERT INTO tke_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ahiimelaga odduli wa Yesu waaddamela omanyaloni aaye, anddaga, onyethihaga ni mitori manyalo a Yesu ohuhuraga ni nthithi naaye, ombezharigi manyalo aaye, amukuthulelaga makura oonukwela. ");
INSERT INTO tke_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Vano mFarizi ole amuwobile Yesu agoonile nde, ahambeelaga wuubuwela mmurimani mwaaye: “Ola ahaakale namavuhulela, eere onona wi omukahinyile baani, mwihiyana ola dowi havi: vowi ‘namathega.’” ");
INSERT INTO tke_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ahiwogaga ni mFarizi, wiira: “Simawu, Gihikanna madhu wi guwaaddele.” Oliye ahiiraga: “Namasuuziha, wogani.” ");
INSERT INTO tke_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu ahiiraga: “Yahikalawo athu abiili yafiyaarile korowa wa namafiyaariha. Mmohi afiyaarile korowa dhowaakwana mazana matanu, mmohiya makumi matanu. ");
INSERT INTO tke_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Vowi kayaakwaniha oweliha, mwinya ahaalevelela aabileene. Ki wevo mwa abiili ala onamuttetteelese muliba ofiyaariha duuvi?” ");
INSERT INTO tke_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simawu ahimwaakulaga: “Ginoonelamo aleveleliwe dhijinji.” Yesu ahimuwogagana, wiira: “Ohaakula pama.” ");
INSERT INTO tke_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ageere ndo, Yesu ahimurugunuwelaga mwihiyana ole, omwiirela Simawu: “Onomoona mwihiyana ola? Miyo gihivolowa mba mwaawo, kugivahile mahinje oohuwana manyalo, mbwenye ola ohugikuthulela mitori manyalo aaga. ");
INSERT INTO tke_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ohuhuraga ni mathithi aaye. We kugibezhari, mbwenye ola, givolowileve, kamaalile ogibezhari manyalo aaga. ");
INSERT INTO tke_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kugikuthulele makura mmuruni mwaaga, mbwenye ola ohugikuthulela manyalo aaga ni makura oonukwela. ");
INSERT INTO tke_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mwa ela ginowuwaaddelani wi dhoothega dhaaye dhijinji dhihileveleliwa; vowi ohooneyiha odhivela wujinji. Mbwenye ole oleveleliwe dhooyeva, onadhivela vang'ono.” ");
INSERT INTO tke_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nuwindo, ahiwogaga ni mwihiyana ole, wiira: “Dhoothega dhaawo dhihileveleliwa.” ");
INSERT INTO tke_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ale yaaligi ni Yesu vamajelo; yahambeelaga owogaga wekiiwa, yiiraga: “Ki olaya baani onafiyedha olevelela dhoothega?” ");
INSERT INTO tke_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mbwenye Yesu ahimwaaddelaga mwihiyana ole, wiira: “Nuuvulumusile thi nroromelo naawo; dhowa ni murenddele.” ");
INSERT INTO tke_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nuwindo Yesu ahivenya, odhowa weddeedda nluwa ni nluwa, murudda ni murudda, alaleyaga, awaaddelihaga athu Muselu Wapama wa Omwene wa Mulugu. Anamasuuza kumi ni abiili yaaligi vamohi ni Oliye, ");
INSERT INTO tke_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","teto ni ahiyana amohi ale yaayilihiiye mwa mineba dhabure, ni dhiredda dhimohi, ahiyanaya baala: Mariya eeriwa Madalina, oyene akumihiwe mineba dhootakala mitanu namiinddi; ");
INSERT INTO tke_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ni Zhuwana, mwihiyanaye Kuza musadoro a nyuba ya Heroddi; Suzana ni ahiyana amohiya ajinjeene. Yamukamihedha Yesu ni dhookalana dheewa. ");
INSERT INTO tke_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Athu ajinjeene yoothamagelaga wa Yesu, edheelaga mudhi dhohiyana-hiyana. Oliye ahiwogaga musibe ola, wiira: ");
INSERT INTO tke_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Namadhala ahidhowa odhala. Adhalaga bewu, dhimohi dhamorelege moogomela dila, onyingaleliwa, balame dhahidhaga oddoddavo oja. ");
INSERT INTO tke_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bewu dhimohi dhamorelege vanibweni, omela dhuunuwaga wuuma, vowi kavaali munyetho. ");
INSERT INTO tke_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bewu dhimohi dhamorele vamwingani, dhigamelile dhahuunuwa vamohi ni mwingadha, dhahihogeya. ");
INSERT INTO tke_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Vano bewu dhimohi dhahimorela theya yapama. Omela wuunuwa ofiyedha ovaha mazana ni mazana, okwaranya bewu dhadhaliwege.” Awogagave nda, ahikuwaga, wiira: “Ole winna mabaru owiiwa, eewe!” ");
INSERT INTO tke_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anamasuuza a Yesu yahimukohaga, wiira: “Musibe ola onatapulela ddi?” ");
INSERT INTO tke_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Oliye ahawaakulaga, wiira: “Nyo muhuvahiwa ononelamo dha wiipini dha Omwene wa Mulugu, mbwenye amohiya Ginaawogana mwa misibe, vowi, “‘yoonaga ehoonege; yiiwaga mbwenye ehiiwelelegemo.’ ");
INSERT INTO tke_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Musibe ola onatapulela ndha. Bewu bi madhu a Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bewu dhamorele moogomela dila, bi ale eneewa madhu a Mulugu, mbwenye adha Sathana aavenyihamo mmirimani mweewa, wi enadhe eroromele, evulumusiwe. ");
INSERT INTO tke_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bewu dhamorele vanibweni, bi ale eneewa madhu yawaakela ni ohagalala, mbwenye kinakanna misisi. Enaroromele mudhidhi vang'ono, vofiya dhoweeha, enowelela mundduli. ");
INSERT INTO tke_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bewu dhamorele vamwingani, bi ale eneewa madhu a Mulugu, yawaakela vovira malabo vang'ono, enohogeya ni osanyeyela, dhoreela, ni dhimohi dhoofuna egumi, kinafiyedha ovaha. ");
INSERT INTO tke_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bewu dhamorele theya yapama baale eneewa muupamani ni murima wowogoowa yalogolela madhuya, ofiyedha ovaha furuta ni ovilela. ");
INSERT INTO tke_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kalivo muthu onahiddiha panti, akuneela ni ebale naari ahela vati vakama. Onahela vowooneyela, wi ateene enavolowegemo yoonege waara. ");
INSERT INTO tke_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vowi kilivo yoowipiteya ehinadha yooneya, naari yoologoheya ehinadha enoniwa ni ovuhuleya. ");
INSERT INTO tke_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pole-pole. Mwiiwe pama! Ole winna, onoweenjedhedhiwa; ole ohinna, elene enoobuweleliiye wi ohukanna onowaakiwa.” ");
INSERT INTO tke_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Amaaye ni addibilaye a Yesu yahidhaaga wi yoonane, ni mwaha wa anamwinji, kiyaakwanihilege ofiya vaaligi Yesu. ");
INSERT INTO tke_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Vano muthu mmohi ahidhowaga, omwaaddela, wiira: “Mmeenyu ni addibilinyu eli ode wu, enafuna moonane.” ");
INSERT INTO tke_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu ahawaakulaga: “Amma ni addibilaga bi ale eneewa madhu a Mulugu ni wiirana dhinawoga madhuya.” ");
INSERT INTO tke_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nlabo nimohi, Yesu ahivolowaga mmwanddeyani vamohi ni anamasuuza aaye, ahawiirelaga: “Nilabuwele kobela ya nyaza.” Omaruwa. ");
INSERT INTO tke_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yabuwaga, Yesu ahidhaleliwaga kove, ogonaga. Vano, wahidhaaga nipevo nulubale munyaza, mmwanddeyani mwahambeelaga odhaala mahinje, okala yego yowoopiha wa aliwa ohala nenaa ni obwina. ");
INSERT INTO tke_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yahimususedhaga, omvenyiha ekuwaga, yiiraga: “Namasuuziha, Namasuuziha, ninokwa hiyo!” Yesu ahivenyaga, ohiiha nipevo ni owali wa mahinje; dhatedhene dhahimaalaga, okala murenddele. ");
INSERT INTO tke_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nuwindo, ahakohaga: “Ororomela weenyu oli wuuvi?” Aliwa owoveene, yootikinaga, ekohanaga vakaleligiisu, yiiraga: “Ki olaya baani? Onafiyedha othonga nipevo ni kuluzi, dhimwiiwelelaga.” ");
INSERT INTO tke_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yahaabuwelaga elabo yo Zherasa, eli epaddi emohiya ya nyaza yo oGalileya. ");
INSERT INTO tke_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu akitagawene, ahithamageliwaga ni mulobwana amuluwani mwemule. Oyene ahiddiwe ni muneba wootakala. Mudhidhi mujinjeene kaawara, kaakala vade, akalesa mmasiyeni. ");
INSERT INTO tke_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Vano agamoonile Yesu, ahikokoraga vameentoni vaaye, ahikuwaga, ni ndhu notaama, wiira: “Yesu, Mwaana a Mulugu a Mudhulu-dhulu, miyo ginna ddi ni nyo? Ginowulobani, kamugirabulihe!” ");
INSERT INTO tke_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mwaha wi Yesu ahithongaga wi muneba wabure ovenyemo mwa ole. Womwihidda winddi-winddi. Athu yommaga ni fingwi madada ni meddo wi ang'aneliwege, oorunddumula dhatedhene, woomuthamagihedha muneba wabure mukokolani. ");
INSERT INTO tke_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu ahimukohaga, wiira: “Ndina naawo oli aani?” Ahimwaakulaga, wiira: “Nili anamwinji.” Vowi mineba dhootakala dhijinjidhene dhahivolowa mwa oliye. ");
INSERT INTO tke_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mineba dhootakala dhahimulobaga Yesu wi ahiigarele omuliddini wooddiha. ");
INSERT INTO tke_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Vevale voojihiwa nikwedda nulubale na kumba omwangoni. Mineba dhootakala dhahimulobaga wi arumeedhihe dhivolowe mukumbani. Yesu ahirumeedhihaga. ");
INSERT INTO tke_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mineba dhootakala dhigakumilemo mwa mulobwana ole, dhahivolowaga mukumbani, kumbadha dhahikitaga dhithamagelaga musiddo, omorela munyaza, okwa. ");
INSERT INTO tke_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Anamajiha kumba egoonile nde dhapadduwilege, yahitthawaga, odhowa olaleyaga muluwani ni mmavade. ");
INSERT INTO tke_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Athu yahikumaga, odhowa wi yoone dhende dheereyile. Egafiyile vakukuuve vaaligi Yesu, yahimfwanya mulobwana ole akumihiwemo mineba dhabure agakaratile omanyaloni a Yesu agawarile, aganna zelu dhobaliwana. Yahikalagana woova. ");
INSERT INTO tke_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ale yoonilege nde dhiireyaga yahawaaddelihamo teto mwemule mwamuyiliheliye muliba minebaya. ");
INSERT INTO tke_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nuwindo, athu ateene yaapelele Zherasa yahimulobaga Yesu wi avenyewo, vowi yahikalagana woova wulubalewene. Vano Yesu ahigwelaga mmwanddeyani dila biili wi adhowege. ");
INSERT INTO tke_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mulobwana ole akumihiwe mineba dhootakala ahimulobaga wi amuharege. Yesu ahimpaganyaga, omwiirela: ");
INSERT INTO tke_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Owelele vade vaawo, wawoge dhatedhene nde dhuwiirele Mulugu.” Nuwindo mulobwana ole ahidhowaga olaleyaga muluwani mwatemwene dhego nde dhatedhene dhamwiirele Yesu. ");
INSERT INTO tke_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu awelagawo, anamwinji yahimwaakelelaga ni ohagalala, mwaha wi ateene yoomujejihaga. ");
INSERT INTO tke_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Vevale mulobwana mmohi aali mpogo a nyuba ya malobelo eeriwa, Zhayiro. Ahidhaaga okokora omanyaloni a Yesu, omuloba wi afiye vade vaaye. ");
INSERT INTO tke_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Anna mwaanaye mmohive, mwana-mwihiyana anna yaaka kumi na biili, ahalilege nenaa ni okwa. Yesu adhowaga, anamwinji yoompinyaminyaga. ");
INSERT INTO tke_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Vahikalaga mwihiyana mmohi arabulile yaaka kumi na biili ni oredda wothathila mwazi ahinoonga dhookalana dhaaye dhatedhene ni anamugu; kaalivo muthu aakwanihile omuyiliha. ");
INSERT INTO tke_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ahidhaaga odduli wa Yesu, okahinya nipiyo na yoowara yaaye, mowaaguva oredda woothathila mwazi ole wahimalaga. ");
INSERT INTO tke_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mbwenye Yesu ahiiraga: “Ogikahinyile baani?” Ateene egarunile. Peduru ahiiraga: “Namasuuziha, anamwinji ehuwaapelelani ni wuupinyaminyani vano muni: ‘Ogikahinyile baani?’ ” ");
INSERT INTO tke_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mwa dhatedhene Yesu ahikalelaga ntidi, eeraga: “Ohukalavo ogikahinyile; mwahaya gihoona wi mwa Miyo owodha ohukumamo.” ");
INSERT INTO tke_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mwihiyana ole, agoonile wi kadhaandeya wiilogoha, ahaaddamelaga osogolo wa Yesu ni ogurumela. Omwaaddelihamo vameentoni va athu ateene, mwahaya wamukanyiheligiiye mowaaguva ayila. ");
INSERT INTO tke_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nuwindo, Yesu omwiirela: “Mwaanaga, nroromelo naawo nihuyiliha! Dhowa ni murenddele.” ");
INSERT INTO tke_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu awogagave, ahifiyaga muthu a vade va Zhayiro, mpogo a nyuba ya malobelo. Omwaaddela, wiira: “Iii, Muhumukukumule Namasuuziha, mwaaninyuya ohukwa.” ");
INSERT INTO tke_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mbwenye Yesu, ageewile nda, ahiiraga: “Kawoove; ororomele baahi, mwaanaawo onovulumuwa.” ");
INSERT INTO tke_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Vafiyiligiiye vade va Zhayiro, kaamwihiyilege muthu bure ovolowa mba vamohi ni Oliye, mbwenye Peduru, Zhuwawu ni Tiyago, babaye ni amaaye a mwaana ole. ");
INSERT INTO tke_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Athu ateene yowunddaga ekuwaga. Vano, Yesu ahawiirelaga: “Kamundde! Ola kakwile mbwenye onoogona.” ");
INSERT INTO tke_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ateene yegi omuteya, vowi yahinonaga pamadhene wi mwaanaya ohukwa. ");
INSERT INTO tke_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Vano, Yesu ahimwihiddeelaga ndada, owoga ni ndhu notaama, wiira: “Mwaana mwihiyana, kavenya!” ");
INSERT INTO tke_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Egumi yahiwelelagamo, ovenya mowaaguva. Yesu ahawiirelaga wi mvaheni yooja. ");
INSERT INTO tke_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ababiinya yahitikiniheyaga, mbwenye Yesu ahasinjeedhaga wi enadha emwaaddele muthu, nde dhapadduwege va. ");
INSERT INTO tke_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nuwindo, Yesu ahawithanelaga vameentoni vaaye anamasuuza kumi ni abiili, ahaavaha owodha ni othongi wowiigara mineba dhabure dhatedhene ni oyiliha dhiredda. ");
INSERT INTO tke_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yesu ahaaruma olaleya Omwene wa Mulugu ni oyiliha dhiredda. ");
INSERT INTO tke_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ahawiirelaga Kumi ni Abiili: “Kamuthukule yego ya voolenddoni; naari mukogodho, naari nthumba na voolenddoni; naari mukaathe, naari korowa, naari kamuthukule malaya meenddi. ");
INSERT INTO tke_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Vade vinafiyedhinyu, mukalege vevo ofiyedha nlabo novenyavo. ");
INSERT INTO tke_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yahuwaakelani, tatani nthubi na manyalo eenyu mwakumaga muluwani mweewa. Okale onamoona wokoodda weewa.” ");
INSERT INTO tke_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Vano, yahimaruwaga, odhowa mudhi ni mudhi, elaleyaga Muselu Wapama, yaayilihaga athu dhipaddi dhatedhene. ");
INSERT INTO tke_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kuminadori Heroddi ahiiwa dhatedhene dheereya mwiilaboni mwaaye oGalileya, ahisimwela, vowi athu amohi yeera Zhuwawu divenyile muukwani; ");
INSERT INTO tke_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","amohi yeera Eliyazi dikumelele; amohi yeera; namavuhulela mmohi awale dhavenyile muukwani. ");
INSERT INTO tke_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mbwenye Heroddi ahiira: “Zhuwawu dulene miyo gimpadhihilimi nikohi. Ki muthu ola gineewimi dhego nda baani?” Oosayela omoona Yesu. ");
INSERT INTO tke_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Egawelilewo arumiwi ale yahimwaaddelagamo Yesu dhatedhene dhende dheeriliwa. Nuwindo, Yesu ahathukulaga arumiwi, odhowa nluwa nimohi, neeriwa Betisayida; ");
INSERT INTO tke_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","mbwenye anamwinji eganonile, yahimuharaga. Oliye ahawaakelelaga, waawogagana anamwinji dha Omwene wa Mulugu, ni wayiliha alene yafunaga oyilihiwa. ");
INSERT INTO tke_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nduwa nigahalile vang'ono okodhowa, anamasuuza Kumi ni Abiili ale yahimwaaddamelaga Yesu, wiira: “Mwaarumihe anamwinji edhowe mmavade wi yesayelele yooja ni vogona, vowi oliihu wuno bu mburo wa mwiddeddereni.” ");
INSERT INTO tke_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu ahawaakulaga: “Mwaavahe nyeene yego wi eje.” Aliwa yahiiraga: “Ninna mikaathe mitanu ni somba biili, baahi. Kaahi nidhowe nagule yooja ya anamwinji ateene alena.” ");
INSERT INTO tke_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Vaaligi alobwana owaakwana vakukuuve macikwi matanu.) Mbwenye Yesu ahawiirelaga anamasuuza aaye: “Waakaratiheni anamwinji mmakuruni a makumi matanu.” ");
INSERT INTO tke_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Anamasuuza yahiiragana ndo, ateene yahikaratigi. ");
INSERT INTO tke_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu ahithukulaga mikaathe mitanu ni somba biili, osugwa odhulu otamala, opadhula moharela, ahawinkaga anamasuuza wi yaagawele athu. ");
INSERT INTO tke_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yahijaga ateene orubala. Anamasuuza yahiddoddelaga dhonyenyeya dhahalilege odhaaliha mittanga kumi na miinddi. ");
INSERT INTO tke_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dhahipadduwa ayi, Yesu ahipothowaga odhowa vowi ivale, egi olobela ni anamasuuza aaye egali vakuukuvi. Oliye waakohaga, eeraga: “Athu eni Miyo Gili aani?” ");
INSERT INTO tke_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aliwa omwaakula, wiira: “Amohi eni Muli Zhuwawu Namabathiza, amohi Eliyazi, amohiwa namavuhulela awale ovenyile.” ");
INSERT INTO tke_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Oliye owelela waakoha: “Ki nyo, muni Gili aani?” Peduru ahimwaakulaga, eeraga: “Nyo Muli Kirixtu a Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu ahakooddihaga vanjinjivene wi enadha emwaaddele muthu. ");
INSERT INTO tke_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Vano ahenjedhaga, wiira: “Enofuneya wi Mwaana a Muthu arabule vajinji, akooddiwe mmadadani mwa anamasogolela a aZhudewu, ni apogo a anamakutha, ni ale anamasuuziha a malamulo; ofiyedha opiwa, ni ovenyihiwa nlabo na nethaaru.” ");
INSERT INTO tke_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ahawaaddelaga ateene: “Onafuna odha wa Miyo, ekoodde yeeka, nlabo ni nlabo athukule muraddi waaye, agiharege. ");
INSERT INTO tke_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mbwenye ole onafuna ovulumusa egumi yaaye, oneere oyelela. Ole onayelela egumi mwaha wa miyo, onowivulumusa. ");
INSERT INTO tke_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Muthu eyugelela dha elabo yateene voodha erimeeliha ni wiitolosa yeeka aaye, onapura ddi? ");
INSERT INTO tke_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Vowi muthu onagikalela manyazo Miyo ni madhu aaga, Mwaana a Muthu onodha amukalele manyazo nlabo nnadhiye munthithimihoni naaye na Ababe ni na angero oweela. ");
INSERT INTO tke_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ebaribareene Ginowuwaaddelani wi nyeene muli veva kamunafiyedhe okwa muhoonile Omwene wa Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Vigavirile malabo matanu na maraaru agawogile madhu ala, Yesu ahimuthukula Peduru, Zhuwawu, ni Tiyago, odhowa omwangoni wi alobele. ");
INSERT INTO tke_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Alobelagave, mooneyelo a kove yaaye yahisadduwaga. Dhoowara dhaaye dhaaligi dhoweela mbuu, dhegi ozherimela. ");
INSERT INTO tke_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mowaaguva egi owoga ni alobwana abiili. Aaligi Mozezi, ni Eliyazi. ");
INSERT INTO tke_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Alobwana ala mooneyelo eewa yaaligi a nthithimiho. Yawogaga dha okwa waaye weeriye aakwanelihe oZheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peduru ni amohiwa yannigiyena, yahinyemeliwaga ni kove dhulubale. Vano egarurumuwe, yahoonaga nthithimiho naaye ni alobwana abiili ale. ");
INSERT INTO tke_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Evenyagavo vale vaaligiisu ni Yesu, Peduru ahiwogaga: “Namasuuziha, eli yapama wi nikale wewuno. Nimage misasa miraaru; mmohi weenyu, mmohi wa Mozezi, mmohiwa wa Eliyazi.” (Oliye kaanonaga dhawogigiye.) ");
INSERT INTO tke_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Awogagave, wahidhaaga murabo waakunela, egali mmuraboni mwemule. Anamasuuza yegi woova. ");
INSERT INTO tke_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mmuraboni mule mwahikuma ndhu, neeraga: “Ola di Mwaanaga, Gimusakulimi. Mmwiiwelelege Oliye!” ");
INSERT INTO tke_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ndhu nigeeweyile, anamasuuza a Yesu yahimoonaga wi Olivo yeeka. Vano aliwa yahimaalaga okuma malabo alene, kayamwaaddelile muthu dhatedhene dhooniligiwa. ");
INSERT INTO tke_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ode ogasile, yahikitaga omwangoni, yahidhowaga anamwinji wi yamugumanena Yesu. ");
INSERT INTO tke_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mulobwana mmohi vari va anamwinji ahikuwaga ni ndhu notaama, eeraga: “Namasuuziha, ginowulobani wi mugoonele mwaanaga, vowi ginna mmohive. ");
INSERT INTO tke_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mowaguva muneba mmohi wamwihidda; muzombwe onokuwa morurumuwa, muneba omuddanddamuwihaga akumaga nipweru muwano. Kunaaguva omwihiya, onofiyedha omvoreya. ");
INSERT INTO tke_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Gahaloba anamasuuza eenyu wi yigaremo muneba ole, mbwenye kiyaakwanihile.” ");
INSERT INTO tke_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu ahaakulaga: “Mulogo wohukanna nroromelo, oovirigana moobuwelelo, ofiyedha alini Gineerimi Givilele ni nyo? Mudhena wuno mwanawo.” ");
INSERT INTO tke_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Muzombwe ole amwaaddamelaga Yesu, muneba wootakala wahidhaaga, omvokedha vati oddanddamuwaga. Mbwenye Yesu ahinyanyuwelaga muneba wabure, omuyiliha muzombwe ole, omwinka babaye. ");
INSERT INTO tke_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ateene yaaligi otikiniheya ni kopolo dhulubale dha Mulugu. Mwadhatedhene nde Yesu dheeriliyena, Oliye ahawiirelaga anamasuuza aaye: ");
INSERT INTO tke_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Muvuruwanesese pama dhendo Ginafunimi Guwaaddeleni: Mwaana a Muthu, oneere ogulihiwa aveleeliwe mmadani mwa athu.” ");
INSERT INTO tke_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mbwenye aliwa kayeewelelagamo madhu ale yatapuleligiwa; yaaligi owipiteya wi enadhe yiwelelemo. Yowoovaga omukoha yotapulela ya madhu ale. ");
INSERT INTO tke_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dhahipadduwa mudhidhi mmohi anamasuuza yegi ovaanyihana wi aakale oofuneya mwa aliwa baani. ");
INSERT INTO tke_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu, voonona moobuwelelo eewa, ahimuthukulaga mwaana omwiimeliha vaaligiye. ");
INSERT INTO tke_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Wawiirela: “Olene onamwaakela mwaana ola mu ndina naaga, onagaakela Miyeene. Vano, ole onagaakela, onamwaakela olene ogirumile. Oli mwa nyo oneyevihe, oyene dinakale pogo.” ");
INSERT INTO tke_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zhuwawu ahiiraga: “Namasuuziha, nihimoona muthu mmohi akumiha mineba dhabure ni ndina neenyu, hiyo nihimwihiha, mwaha wi kanili vamohi.” ");
INSERT INTO tke_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mbwenye, Yesu ahimwiirelaga: “Kammwihihe ole, ohunavanyihana ni nyo, ola deenyu.” ");
INSERT INTO tke_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nuwindo dhahipadduwa, waaddamelaga mudhidhi wowi Yesu athukuleliwe odhulu, ahilibihedha odhowa oZheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Oliye ahaaruma aliba muselu vasogolo. Edhowaga aliwa, yahivolowaga murudda wo oSamariya wi emusasanyedhele mburo; ");
INSERT INTO tke_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","mbwenye athu a murudda ole kayamwaakelile Yesu, vowi yahinona wi onadhowa oZheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Anamasuuza Tiyago ni Zhuwawu vowoona nda, yahimukohaga: “Nabwiya, munofuna niithane munddo woodhulu waapahe?” ");
INSERT INTO tke_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mbwenye Yesu aharugunuwelaga, wasumulula. ");
INSERT INTO tke_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vano, yahidhowaga murudda mmohiwa. ");
INSERT INTO tke_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesu adhowaga mundila ni anamasuuza aaye, mulobwana mmohi ahiiraga: “Gineerege wuharani oli watewene onadhowinyu.” ");
INSERT INTO tke_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ahimwaakulaga: “Akwaddwe ehikanna makungu eewa, balame dho odhulu dhihikanna dhitunji, mbwenye Miyo, Mwaana a Muthu kaginna vosameliha muru.” ");
INSERT INTO tke_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ahiira wa mulobwana mmohiya: “Giharege.” Mbwenye mulobwana ole ahimwaakulaga: “Nabwiya, gihiyeni vowambeela gamutibele Ababaaga.” ");
INSERT INTO tke_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ahimwaakulaga, wiira: “Waahiye anookwa etibelanege anookwave. We odhowe walaleye Omwene wa Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Muthu mmohiya ahiiraga: “Gineere wuharani, Nabwiyani mbwenye vowambeela mugihiye gaapaganye anaamudhi.” ");
INSERT INTO tke_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ahimwaakulaga: “Kalivo muthu oni agahiddelile iba, alimaga aang'anaga mundduli, afwaneelela Omwene wa Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dhigeereye nde, Nabwiya Yesu ahaasakula anamasuuza amohi, makumi matanu nameenddi ni abiili, waaruma abiili-abiili, wi esogole edhowe mmaluwani ni mburo mwafuniiye odhowa. ");
INSERT INTO tke_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ahawaaddela, wiira: “Dhohadda dhihinjiva, anamalaba eli vang'ono. Nyo anamasuuza mmulobe Nabwiya mwiinya a dhohadda wi aarume anamalaba omidda waaye. ");
INSERT INTO tke_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dhowani dhiinoveva! Miyo Ginowurumani woona mabila vaari va miiji ");
INSERT INTO tke_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Muhuthukule thumba na korowa, naari thumba na volenddoni, naari sapatho; muhumulojele muthu mundila. ");
INSERT INTO tke_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nyuba enavolowinyu, vowambeela muwoge, mwiire: ‘Murenddele okale vade va.’ ");
INSERT INTO tke_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akalavo muthu a murenddele, murenddele weenyu omukitele oliye; ahikalavo, murenddeleya owelele wa nyo. ");
INSERT INTO tke_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mukalege vade vevo, mujege mung'wege, eyene enovahigisuni, vowi sofuneya namalaba aakele nlivo naaye. Muhenjedhe mookala. ");
INSERT INTO tke_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Mwafiya valuwani mwaakeliwa pama, mujege eyene enovahigisuni. ");
INSERT INTO tke_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mwaayilihege aredda enakale muluwanimo, mwawaaddelege: ‘Omwene wa Mulugu ohufiya wa nyo.’ ");
INSERT INTO tke_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mbwenye, mwavolowa nluwa nimohiniwa ehuwaakelani, mvenye, mudhowe mmarampani, mweere: ");
INSERT INTO tke_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hiyo nihitata nthubi na nluwa neenyu nombuwelihe manyalo eehu wi ekale yoonihedho wa nyo. Mwa nda, munone wi Omwene wa Mulugu ohufiyedhani.’ ");
INSERT INTO tke_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ginowuwaaddelani wi nlabo na muladdu athu oSoddoma enodha evuguleliwe goyi yeewa ohiya athu a nluwa ndde. ");
INSERT INTO tke_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ooddilu di we, Korazimi! Ooddilu di we, Betisayida! Vowi matikiniho yiireyile mwa nyo yaheereye oTiru ni oSidoni, athuya mudhidhi olena egatthwaruwe mowaaguva, ewaraga masakwi ni wiihela nddora. ");
INSERT INTO tke_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mbwenye mu othongi wa Mulugu onodha avugulele goyi yo oTiru ni Sidoni, ohiyana murudda dha oKorazimi ni Betisayida. ");
INSERT INTO tke_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","We, Kafaranawu, oneesa oneere ogwelihiwa odhowe odhulu? Naari! Onomorihedhiwa mburo wanookwa!” ");
INSERT INTO tke_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu ahiwogaga ni anamasuuza aaye makumi matanu nameenddi ni abiili ale, wiira: “Ole onoovuruwanani, onagivuruwana Miyeene; ole onagikoodda Miyo onamukoodda baba aaga Mulugu ogirumile.” ");
INSERT INTO tke_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vano anamasuuza makumi matanu na meenddi ni abiili ale yahiwelaga ni ohagalala wulubale; yiiraga: “Nabwiyani, mwa ndina neenyu mineba dhabure dhihifiyedha oniiwelela!” ");
INSERT INTO tke_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mbwenye Oliye ahawiirela: “Miyo Gihimoona Sathana amoraga odhulu woona ozherima. ");
INSERT INTO tke_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Onani Miyo guhuvahani owodha woonyingalana nyowa, awalize, ni owodha watewene wa mwiiddani mowindo kilivo enovoreyegeni. ");
INSERT INTO tke_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mwa dhatedhene kamuhagalale mwaha wowi mineba dhabure dhinowiwelelani, mbwenye muhagalale vowi mandina eenyu ehilebiwa odhulu.” ");
INSERT INTO tke_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mudhidhi olene Yesu ahihagalala mwa Muneba Woweela, wiira: “Miyo Ginowutamalani Babani, Nabwiya oodhulu ni elabo ya vati, vowi muhalogohedha dhego nda athu ononelamo ni oosuuza, mwawoonihile ahima. Eee! Babani, wula pufuna weenyu. ");
INSERT INTO tke_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Dhatedhene Gihivahiwa ni Ababaaga. Kalivo omunonile Mwaana ahili Babe, teto kalivo omunonile Babe ahili Mwaana, ni ayene Enaafuniyena waanoniha.” ");
INSERT INTO tke_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Vano aharugunuwelaga anamasuuza aaye, wiira: “Oreelihiwa bi meento enoona dhinooninyu. ");
INSERT INTO tke_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vowi Miyo Ginowuwaaddelani wi anamavuhulela ajinji ni mamwene yahifunesesa woona dhinooninyu mbwenye kayoonile, wiiwa dhinewiinyu mbwenye kayewile.” ");
INSERT INTO tke_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nlabo nimohi, namatapulela a malamulo ahivenya wi amweehe Yesu. Omukoha, wiira: “Namasuuziha, wi gikalena egumi yoohimala, gineere ddi?” ");
INSERT INTO tke_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu ahimwaakulaga, wiira: “Mmalamuloni dhilebiwe avi? Onatapulela avi?” ");
INSERT INTO tke_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Oliye ahaakulaga, wiira: “‘Omudhivelege Mulugu aawo ni murima waawo wateene, ni egumi yaawo yateene, ni kopolo dhaawo dhatedhene, ni moobuwelelo aawo mateene’, ‘omudhivelege mwaaddamani aawo woona vineedhiveliwe wamwiinya.’ ” ");
INSERT INTO tke_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ahimwaakulaga, wiira: “Ohaakula pama. Wiiregena dhendo oneere okalawo.” ");
INSERT INTO tke_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mbwenye namasuuziha a malamulo ole, afunaga wiyaakwanihela yeekaye, ahiiraga: “Ki mwaaddamani aaga baani?” ");
INSERT INTO tke_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ahimwaakulaga, wiira: “Aaligi mulobwana mmohi akitaga oZheruzalemi, adhowaga oZheriko, mundila ahigumana ni mapanga. Omwihidda omwaaka dhoowara dhaaye, omuddwadha omporosa vajinjivene, omwihiya nenaa ni okwa. ");
INSERT INTO tke_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mohujejiheya, namakutha mmohi egi odha dila emohive, agamoonile mulobwana ole ahimuwereweraga. ");
INSERT INTO tke_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dila emohive egi ovira muLevita, agamoonile ni oliyeene, ahimuwereweraga. ");
INSERT INTO tke_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vano muSamariya mmohi adheelaga dila emohive elene, agamoonile, ahifiyaga vakukuuve omweeddiwela thagaraga. ");
INSERT INTO tke_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Omuhuwa makwaddaya, ohelamo makura ni vinyu ompotha. Vano omuthukula, omugweliha vamwaneenyamani aaye, omudhowana nyuba ya aleddo, omukamihedhe. ");
INSERT INTO tke_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ode ogasile, ahiliva korowa biili dha gwingwi wa muliba nyuba yowawaakela aleddo. Oliye wiira: ‘Mmukameele muthu ola, dhinamunoongelinyu dhimohi, gadhaaga ginoliva.’” ");
INSERT INTO tke_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Vano Yesu ahimukohaga namasuuziha a malamulo: “Moobuwelelo aawo, athu ale araaru, aali mwaaddamani duuvi?” ");
INSERT INTO tke_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Oliye ahaakula: “Di ole amukamihedhe.” Yesu ahiira: “Odhowe, weeregena ndo.” ");
INSERT INTO tke_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu eeddaga ni anamasuuza aaye, yahifiyaga murudda mmohi, vano mwihiyana mmohi eeriwa Marata ahimwaakela vade vaaye. ");
INSERT INTO tke_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marata ahikalana ddibile mmohi, eeriwa Mariya, akaratilege omanyaloni a Yesu, omvuruwanaga dhosuuziha dhaaye. ");
INSERT INTO tke_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mbwenye Marata aaligi ookathamiheya vajinji ni mabasa. Nuwindo, ahimwaaddamelaga Yesu, omukoha: “Nabwiyani, kamunapwatha wi ddibilaga ogihiyedhe mabasa menka? Mwaaddeleni wi agikamihedhege!” ");
INSERT INTO tke_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu ahimwaakulaga: “Marata! Marata! We ohusanyeya, vohumaleya ni dhego dhijinji, ");
INSERT INTO tke_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","mbwenye, yoofuneya si yego emohi, baahi. Mariya ohusakula yokwaranya, ela kalivo onamwaake.” ");
INSERT INTO tke_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nlabo nimohi Yesu egi olobela mburo mmoheene. Agamarihile, namasuuza mmohi ahimulobaga, wiira: “Nabwiyani, munisuuzihe olobela woona Zhuwawu asuuzihile anamasuuza aaye.” ");
INSERT INTO tke_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Vano Oliye wasuuziha: “Mwaalobelaga, mwiirege: “Baba weehu, ndina neenyu neelihiwe. Omwene weenyu odhe. ");
INSERT INTO tke_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Munivahe yooja yeehu yowaakwana nlabo ni nlabo. ");
INSERT INTO tke_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Munilevelele dhoothega dheehu, woona hiyo nnalevelela ateene enanthegela. Kamunihiye omorela moweehiwani.” ");
INSERT INTO tke_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu ahawaaddelagave: “Mofwanafwaniha muthu mmohi a mwa nyoovo akalana mukwaaye, adhowa amusayelaga vaari va mahiyu amwiirela: ‘Mukwaaga gibolihe mikaathe miraaru, ");
INSERT INTO tke_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","vowi mukwaaga avolenddoni difiyile vade vaaga, ogisayela, vano kaginna yoomvaha.’ ");
INSERT INTO tke_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Vano mukwaayeya ola aakulaga mba-mba eeraga: ‘Kuginyagule, musiwo bi ofugeene, anaaga ni miyoya nihikonaati. Kaginaakwaniha ovenya wi guuvahe enalobiwe.’ ");
INSERT INTO tke_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ginowaddelani wi oliye kaafuna wi avenye amvahe mikathe, vano ahivenya omvaha dhatedhene dhafuniye, kamvahelege wi di mukwaye, mbwenye mwaha wa ntidi. ");
INSERT INTO tke_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mwa ela Ginowuwaaddelani: Lobani, munovahiwa; sayelani, munofwanya; kokothani, muneere ofuguleliwa. ");
INSERT INTO tke_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vowi ateene enaloba, enovahiwa; onasayela, onofwanya; musiwo onofuguleliwa wa oyene onakokotha. ");
INSERT INTO tke_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Baba baani mwa nyoovo oni mwaana aaye amuloba somba, vamburoniva amvaha nyowa? ");
INSERT INTO tke_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naari amuloba nzayi, onomvaha walize? ");
INSERT INTO tke_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ki nyo, mugalive abure, munonile waavaha dhego dhapama aniinyu. Kahi ebaribari wi Babiinyu oodhulu oli apama, kanaavahe mookwaranya Muneba Woweela ale enamuloba?” ");
INSERT INTO tke_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nlabo nimohi Yesu eegaraga muneba wootakala wohuwoga. Muneba olene ogakumilemo, muliba ohuwoga oowogaga, anamwinji yootikinaga. ");
INSERT INTO tke_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mbwenye amohi mwaaliwa yowiiraga: “Kopolo dhinakumihiyena mineba dhootakala dhinadheela wa Belezebu, pogo a mineba dhootakala.” ");
INSERT INTO tke_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Amohiwa yoofunaga omweeha, yoomulobaga etonyihedho yoodhulu. ");
INSERT INTO tke_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mbwenye, Yesu aganonile dhowubuwela dheewa, ahawiirelaga: “Omwene oli wateene wagawaneya mwa wooka onobwanyuwa. Emudhi yagawaneya murala ni murala dhinotongwa. ");
INSERT INTO tke_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Akala Sathana onogawaneya mwa yeeka, omwene waaye onalibe addi? Giwogele nda mwaha wa nyoovo muneera wi Gineegara mineba dhootakala ni Belezebu. ");
INSERT INTO tke_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Akala Miyo Gineegara mineba dhootakala mwa Belezebu, ki anamasuuza eenyu eneegara ni ddi? Mowi nda aliwa enodha yuthongeni. ");
INSERT INTO tke_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mbwenye, akala Miyo Gineegara mineba dhootakala ni kopolo dha Mulugu, ebaribareene Omwene wa Mulugu ohufiya. ");
INSERT INTO tke_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Muthu a kopolo winna dhowiying'anelana eng'anelaga vade vaaye, dhookalana dhaaye dhinakala dhoohiddeleya pama. ");
INSERT INTO tke_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mbwenye, adhavo mmohiwa a kopolo dhijinji dhoomukwaranya oliye, amugonjiha, onomwaaka dhookalana dhaaye dhatedhene dharoromeliiye, onogawagawa dhoreela dhaniiyena. ");
INSERT INTO tke_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Muthu ohuneewanana ni Miyo dinavanyihana ni Miyo, olene ohunagikamihedha otugumana ni Miyo onoomwadha. ");
INSERT INTO tke_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Muneba wabure wakuma mwa muthu, onoweeddedda mwiddeddereni asayelaga voovuma, waahifwanya, onowiiyirela: ‘Ginawelela vade vaaga, vevale vakumilimi.’ ");
INSERT INTO tke_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Vano afiya onafwanya moozheliwa mwene, moosasanyedha mwene. ");
INSERT INTO tke_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Endo onodhowa othukula mineba dhimohi mitanu namiinddi dhoomukwaranya ole; ovolowamo, okalaga mwemule. Vano mukalelo wogomihedha wa muthu ole onokala woothabwa okwaranya mukalelo wowambeela.” ");
INSERT INTO tke_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Vano dhahipadduwa, Yesu awaaddelaga dhego nda; mwihiyana mmohi a anamwinji ahikuwaga ni ndhu notaama, wiira: “Oreelihiwa di mwihiyana oyene wubalileni, owamwihani.” ");
INSERT INTO tke_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mbwenye Yesu ahiiraga: “Mohiyaniha, oothabwa oreelihiwa bi ale eneewa madhu a Mulugu ni walogolela.” ");
INSERT INTO tke_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Vowi anamwinji yootugumanaga, Yesu ahambeelaga wawaaddela: “Ola bu mulogo wabure! Aliwa enaloba etonyihedho yootikiniha, kinavahiwe etonyihedho emohiwa, ehili ya namavuhulela Zhonasi. ");
INSERT INTO tke_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mowinda woona Zhonasi aali etonyihedho ya akadda oNinive, Mwaana a Muthu teto onaakale etonyihedho ya mulogo olena. ");
INSERT INTO tke_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nlabo noothongiwa wa athu mwene a mwihiyana omadheelo pevo ya kasekase onodha eemelele athonge akone mulogo olena, vowi ahidha okumela ogomele elabo wi eewe ononelamo wa Salomawu. Moone, oli vameentoni veenyu ohumukwaranya Salomawu. ");
INSERT INTO tke_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Teto athu oNinive enodha yimelele ethonge mulogo ola ni waakona; vowi aliwa ehitthwaruwa vowiiwa olaleya wa Zhonasi. Moone, oli vameentoni veenyu ohumukwaranya Zhonasi. ");
INSERT INTO tke_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kalivo onahiddiha panti, alogoha wowipiteya, naari vati va ebale. Mbwenye, onahela vowooneyela, wi enavolowegemo yoonege waara. ");
INSERT INTO tke_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Meento bi panti ya mwiili. Meento aawo yakala apama, mwiili waawo wateene onakala wowaara. Mbwenye yahikala apama, mwiili waawo onakala wa yiihi. ");
INSERT INTO tke_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Osugwe pama, waara oli mmwiilini mwaawo ohukale yiihi. ");
INSERT INTO tke_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Akala mwiili waawo wateene oli wowaara, wahikalena yiihi kukuru emohi, onokala wowaara, woona panti yamoneyelaga vaari va we.” ");
INSERT INTO tke_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu agamalile owoga, mFarizi mmohi ahimwiithanaga wi yaje vamohi, vano Yesu ahivolowaga, okaraati vameeza. ");
INSERT INTO tke_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mbwenye mFarizi ahitikinaga, agamoonile wi Yesu onaja ahihabilemo. ");
INSERT INTO tke_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Vano Nabwiya wiira: “Nyo maFarizi munahuwa ode wa katha ni wa muziwo, mbwenye muwari mweenyu muhudhaala dhowaaka ni dhabure. ");
INSERT INTO tke_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oolodhowa nyo! Ole osasanyile ode kahuwo mmohive osasanyile muwarimwa? ");
INSERT INTO tke_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mbwenye vowambeela mvahe dhamahala wa arabuli ni murima wateene vano dhatedhene dhinakala dhinoweelihiwa wa nyo ");
INSERT INTO tke_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mbwenye ooddilu di nyo, maFarizi mwaha wi munavaha dhaneekumi dha bewu dhoonukwela, ni bewu dhoodhiva ni dha mataba dhatedhene, vano munanyemula ebaribari ni odhivela wa Mulugu. Yoofuneya mwiiregena nda, mwahihiyaga wiirana dhimohi. ");
INSERT INTO tke_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nyo, maFarizi muneere woona vowi munadhiveliwa dhittengu dhowambeela dha nyuba dha malobelo ni malojelo anriiho mmamisika. ");
INSERT INTO tke_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Nyo, maFarizi muneere woona, muli woona masiye ehinooneya, athu eneedda vadhuluva ehinoonaga yego.” ");
INSERT INTO tke_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Namatapulela a malamulo mmohi ahimwaakulaga, wiira: “Namasuuziha, mwawogaga nda, munoninyemula ni hiyeene teto.” ");
INSERT INTO tke_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Vano Yesu, wiira: “Muneere woona nyoovo teto, anamatapulela a malamulo, munaathukuliha athu sapo dhonyemela dhohakwaniha aliwa, dhedho nyo muhunandinyu naari vang'onong'ono okahinya ni embuno yeenyu. ");
INSERT INTO tke_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ooddilu di nyo, munamaga masiye anamavuhulela ayene yapiwe ni makolo eenyu. ");
INSERT INTO tke_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nda dhinooniha wi munorumeedhela mabasa a makolo eenyu. Vowi aliwa yahaapa anamavuhulela. Vano nyo munamaga masiyeya. ");
INSERT INTO tke_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mwa ela teto, ononelamo wa Mulugu wiire: ‘Ginodha gaarumihedhele anamavuhulela ni arumiwi, aliwa enodha yaape, amohiwa yaarabulihe.’ ");
INSERT INTO tke_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Vowindo athu a mudhidhi ola enodha ekalena muladdu mwaha wa anamavuhulela ateene, epiwe wambeela omapaddusiwelo wa elabo: ");
INSERT INTO tke_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mwazi wa Abeli ofiyedha mwazi wa Zakariya, apeliwe vaari va ebuwa ni nyuba ya Mulugu. Eee, Ginowuwaaddelani, mulogo ola onodha okohiwe. ");
INSERT INTO tke_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ooddilu di nyo, anamatapulela a malamulo, mumvenyihilevo cavi oothulana ttotto dha ononelamo dha Mulugu. Nyo kamuvolowilemo nyooka, mwaathiyelele ale yafuna wi evolowege!” ");
INSERT INTO tke_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu avenyaga vevale, anamasuuziha a malamulo ni maFarizi yahambeelaga omusanya valubalevene ni omukoha dhohiyana-hiyana. ");
INSERT INTO tke_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Efunaga omuwaga muwano wi emmagihe. ");
INSERT INTO tke_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mudhidhi olene, yahitugumanaga athu macikwi ni macikwi, ofiyedha onyingalanaga mmohi ni mmohiya. Yesu ahambeela wawaaddela anamasuuza aaye, wiira: “Pole-pole ni emela ya maFarizi weewa oli oleketha. ");
INSERT INTO tke_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kilivo yokuneeliwa ehinaadhe yooneya; naari yologohiwa ehinadhe enoneya. ");
INSERT INTO tke_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dhatedhene dhinawogelinyu wipipini dhinovuweya mutaneene, dhinawogelinyu vati-vati mba dhinodha olaleyiwa vathaddo.” ");
INSERT INTO tke_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Vano nyo, akwaaga, Ginowuwaaddelani: Muhawoovege ale enapa mwiili, mbwenye osogolo kinanda wiirana yego emohiwa. ");
INSERT INTO tke_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mbwenye Miyo Ginowuwaaddelani ofwaneelela omoova; mmoovege Mulugu, onapa, akalana owodha wovokedha omunddoni. Eee. Mmoovege Oliyeene, baahi. ");
INSERT INTO tke_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mwiiwe. Anamanddwi atanu kinagulihiwa korowa biili? Vano dhiyevileve Mulugu kanamuddiwala naari mmohi. ");
INSERT INTO tke_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ofiyedha ni mathitheene a mmuruni mweenyu mateene eheelengiwa. Muhoove, nyo muli oofuneyesesa wakwaranya anamandwi ajinji. ");
INSERT INTO tke_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Miyo Ginowuwaaddelani wi olene onagirumeedha vameentoni va athu, teto Miyo, Mwaana a Muthu ginodha gimurumedhe vameentoni va angero a Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mbwenye ole onagikoodde vameentoni va athu Miyo Ginodha Gimukoodde vameentoni va angero a Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ateene alene enamwaaba Mwaana a Muthu enoleveleliwa, mbwenye wa ale enanyemula Muneba Woweela, kidha eleveleliwa. ");
INSERT INTO tke_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mwathukuliwaga munyuba dha malobelo dha aZhudewu, mudhowiwagana wi mwathongiwe ni anamathonga muladdu, muhukalege ookubanya nnaakule havi, naari nnawoge havi. ");
INSERT INTO tke_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mwaha wi mudhidhi oyene Muneba Woweela onowusuuzihani yowaakula.” ");
INSERT INTO tke_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Muthu mmohi, vaari va anamwinji ahiira: “Namasuuziha, mmwaaddele ddibilaaga wi agigawelewo dhoreela dhoohala dha babihu.” ");
INSERT INTO tke_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mbwenye Yesu ahimwaakulaga, wiira: “Mulobwana we, baani ogisakule okala namathonga naari namagawela dhoohala dheenyu?” ");
INSERT INTO tke_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Vano ahawiirelaga ateene yaaligi vevale: “Pole-pole! Murabele ogonjihiwa nrima mwa dhatedhene, vowi egumi yebaribari ya muthu kinahiddeleya ni mwaha wa dhoreela, naari dhinjiveve.” ");
INSERT INTO tke_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Vano ahawogela musibe, wiira: “Ahikalawo muthu ooreela. Mudda dhaaye dhahivaha dhooja dhinjinji. ");
INSERT INTO tke_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nuwindo wambeela wubuwelela mmurimani mwaaye yeeka, eeraga: ‘Giire havi? Vowi kaginna vohela milimo dhaaga dhi.’ ");
INSERT INTO tke_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ahenjedhave, wiira: ‘Giire ayi, gibwanyule dhiringwi dhaaga, gimage dhiringwi dhimohi dhulubale, wi gihaddelemo milimo dhaaga, ni dhookalana dhaaga. ");
INSERT INTO tke_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Gamala, giyirele miyo menka: “We ohukalana dhoreela dhijinji dhologoleleya, dhowaakwana yaaka dhijinjidhene; ovume, oje, ong'we, ohagalale!” ’ ");
INSERT INTO tke_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Mbwenye Mulugu omwiirela: ‘We olodhowa! Mahiyu alena onowaakiwa egumi yaawo. Ki dhego dhugeliliwe dhinakale dhawani?’ ");
INSERT INTO tke_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Nda dhinompadduwela ole oneyugelela dhoreela yeeka, kahuwo ooreela ni Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu ahiwoga ni anamasuuza aaye, wiira: “Mwa ela Ginowuwaaddelani kamukale osanyeyela egumi yeenyu, mwiiraga: ‘Ninaje ddi, ninaware ddi?’ ");
INSERT INTO tke_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vowi egumi sili yofuneya ohiyana ni yooja, mwiili onokwaranya yowara. ");
INSERT INTO tke_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mwawoone anakugu: kinadhala, kinahadda, naari kinakanna eringwi, Mulugu onowaavaha dhooja; nyo muli ofuneya okwaranya balame! ");
INSERT INTO tke_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kalivo muthu akathamiheyaga, onaakwanihe wenjedhedha nlabo nimohi na egumi yaaye. ");
INSERT INTO tke_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Vano, akala kamunaakwaniha wiirana yego eng'onong'ono munakalela ddi osanyeyela dhimohidha? ");
INSERT INTO tke_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Moone todo dha mukokolani, dhinonnuwa havi. Kadhinalaba, kadhinasona. Ginowuwaaddelani wi naari mwene Salomawene ni nthithimiho noreela naaye, kaafiyedhe owara oliganaana ni todo nda. ");
INSERT INTO tke_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ki akala Mulugu onowaawariha manasi a mukokolani, eliwo peenove, mmenselo-nimwiwa evokedhiwa vamunddoni, kanowariheni nyo athu oyeva nroromelo? ");
INSERT INTO tke_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Muheddege mosanyeya, muubuwelelaga: ‘Ninaje ddi? Ninang'we ddi?’ Kamusanyele ni nda. ");
INSERT INTO tke_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vowi athu a elabo ya vati ehinamuroromela Mulugu, binasanyeyelesesa dhego dhedhi. Mbwenye Babiinyu ohunona wi munorabulela dhedhi. ");
INSERT INTO tke_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vowambeela mwa dhatedhene, musayele Omwene wa Mulugu, vano dhimohi dhiwa muneere wenjedhedhiwa. ");
INSERT INTO tke_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kamoove nyo, nikwedda ning'onong'ono na mabila, vowi Babiinyu ohudhiveliwa wuvahani Omwene waaye. ");
INSERT INTO tke_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gulihani dhatedhene dhiininyuna, korowadha mwaavahe oorabula. Mwisayelele mathumba a korowa ehinataleya ni mudhidhi, mudhugelele dhoreela dheenyu dhohumala odhulu. Vowi wule owiiya kinafiyawo, naari oswa kunanda okwenya. ");
INSERT INTO tke_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vowi vevo vinaakale dhoreela dheenyu, murima weenyu onakale vevo. ");
INSERT INTO tke_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mukalege owimageene mmwiinuni mweenyu, panti dheenyu dhohiddadhene. ");
INSERT INTO tke_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Vano, nyo mukale oofwanafwana ni athu enamujejihedha nabwiya eewa okuma omathangani a matelo. Adhaaga oliye, akokotha, enafugulele mowaaguva. ");
INSERT INTO tke_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oreelihiwa bi alene amwiimeleli enafwanyiwe ying'anelaga nabwiya adhaaga. Ebaribareene, Ginowuwaaddelani wi onodha aakaratihe vameeza, nabwiyeene agawelaga dhooja. ");
INSERT INTO tke_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Akala onaafiye vaari va mahiyu, naari njijiji noomaselo, aafwanya ehigonile, oorelihiwa enakale amwiimeleli alene. ");
INSERT INTO tke_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Teto munone nda: Muliba vade ahanonege mudhidhi onadha mbava, eerege wing'anela kaamwihiyege wiiya vade vaaye. ");
INSERT INTO tke_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Vano, nyoovo muwaraale vowi Mwaana a Muthu onadha mudhidhi ohunoobuwelelinyu.” ");
INSERT INTO tke_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peduru ahimukohaga: “Nabwiya, musibe ola munaniwogela hiyo, naari athu ateene?” ");
INSERT INTO tke_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nabwiya ahiira: “Mwiimeleli oororomeleya, oolageya baani? Ole omuthomile Nabwiya okala pogo ookwaranya, owaagawela dhooja akwaaye mudhidhiya wafiya? ");
INSERT INTO tke_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Oorelihiwa di mwiimeleli oyene nabwiya adhaaga onamfwanyiye eeragana dhedhi. ");
INSERT INTO tke_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ebaribareene ginowuwaaddelani wi nabwiya onomwiira nameeddiha a dhoreela dhaaye dhatedhene. ");
INSERT INTO tke_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mbwenye mwiimeleli ole onoobuwelela mmurimani mwaaye, ‘Nabwiya onoseliwa kanadhawo,’ ambeela waaddwadha anamalaba anaahiyana, ni anaalobwana, vano ajaga, ang'waga, alezelaga. ");
INSERT INTO tke_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Finafiya nabwiinya a mwiimeleli ole nlabo nahajejihiye naari mudhidhi wohunona. Oliye onomooniha goyi vajinji, amvokedhe vaari va athu oohuroromela. ");
INSERT INTO tke_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mwiimeleli ole ononile efunelo ya nabwiya aaye, ahivirihamo efunelo ya nabwiya, onowoonihiwa goyi vajinji yowaxuliwa. ");
INSERT INTO tke_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mwiimeleli ole ohunonile dhinafuna nabwiinya, aviriganiha goyi yaaye enakala vang'ono. Ovahiwe dhijinji, onokohiwa dhijinji; ohiyedhiwe dhothabwa, onolobiwa dhothabwa.” ");
INSERT INTO tke_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Vano Yesu ahiira: “Miyo Gidheele ovoka munddo mwilaboni, Gahifuna ogahiddile! ");
INSERT INTO tke_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Enofuneya wi Gaakele obathizo wa goyi, murima waaga kukarateye ofiyedha wi dhiireye! ");
INSERT INTO tke_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Munoobuwelela wi Gidhilena murenddele elabo ya vati? Naari, mohiyaniha Ginowuwaaddelani wi Gidheele omwalaniha. ");
INSERT INTO tke_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wambeela dhiinoveva odhowa osogolo, athu atanu a nyuba emohive eneerege ofiyedha omwalana. Araaru ewanege ni abiili, abiili ewanege ni araaru. ");
INSERT INTO tke_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baabi oneerege omwalana ni mwaanaye, mwaana oneerege omwalana ni babaye; mmeenya oneerege owana ni mwaanaye a mwaana mwihiyana, mwaana a mwihiyana oneerege owana ni amaaye; nzala oneerege owana ni nzaliyaaye, vano nzaliye oneerege owana ni nzala aaye.” ");
INSERT INTO tke_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ahawiirelaga anamwinji: “Moonaga murabo dhidhelaga onadhowela nduwa, muni: ‘Muzongwe onoodha,’ nda wiireya. ");
INSERT INTO tke_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Vano, yoobaga pevo ya kasekase, muni: ‘Oneere okala oviha,’ nda wiireya. ");
INSERT INTO tke_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Anamaleketha! Muhunona otapulela mukalelo wa elabo ni odhulu. Muhunonele ddi otapulela mukalelo wa mudhidhi ola wa dhiinova? ");
INSERT INTO tke_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ki mwa nyo weekinyu muhunandela ddi onona eli yooharihamo? ");
INSERT INTO tke_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Akala mwiiddani aawo onowudhowana omuthegoni, osayele wiwanana mmarihe muladduya mundila, wi dhinapadduwe oothukulele wa namathonga, namathonga odhowena wa namafugela, namafugela oofugele mukaambura. ");
INSERT INTO tke_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Miyo Ginowuwaaddelani wi kunanda okumamo ohulivile korowa yoogomihedha.” ");
INSERT INTO tke_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mudhidhi olene, yahikalavo athu amohiya yamwaaddelile Yesu dha aGalileya ayene Pilatu yathongiliye wi epiwe ekuthaga mukutho dha aneenyama wa Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Vano Yesu ahawiirelaga: “Munoobuwela wi aGalileya ale yaali othegesesa okwaranya aGalileya amohiwa, mwaha woopiwa ndale? ");
INSERT INTO tke_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ginowuwaaddelani nyo wi naari! Mbwenye munoodha munongeye mwateene mooligana ni aliwa, mwahitthwaruwa. ");
INSERT INTO tke_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Naari kumi ni atanu ni araaru ale yamoreliwe, sanja yoolapa ya oSilowami, yaapa — munoobuwela wi yaali oothega okwaranya athu ateene ookala muZheruzalemi? ");
INSERT INTO tke_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ginowuwaaddelani nyo wi naari! Mbwenye munoodha munongeye mwateene mooligana ni aliwa, mwahitthwaruwa.” ");
INSERT INTO tke_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu ahenjedhedhave, owoga musibe ola: “Muthu mmohiwa ahikanna namutambwi aaye amudhaliliye mmiddani mwa mithanko, ahidha wi ahapemo furuta mwemule, mbwenye kafwanyilemo. ");
INSERT INTO tke_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Vano ahimwaaddela namalaba, wiira: ‘Vihivira yaaka thaaru, gidhaaga osayela furuta munamutambwinimu, gihifwanyagamo. Omukakatte! Onanongela ddi ttheya ahivahaga?’ ");
INSERT INTO tke_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Namalaba ahaakulaga, wiira: ‘Nabwiyani, mwihiye yaaka emohi ofiyedha gitibe mowaapeleliha, gihele manyowe. ");
INSERT INTO tke_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wavaha furuta yaaka elena sapama, mbwenye akala kunavahe, munodha mukakatte.’” ");
INSERT INTO tke_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nlabo nimohi na Sabuddu, Yesu aasuuzihaga athu mu nyumba ya malobelo. ");
INSERT INTO tke_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mwemule mwahikala mwihiyana mmohi, anna muneba wabure, wambulelihe yaaka kumi ni tanu nathaaru. Mutana waaye waali wookoromana, kaanda winuuwa. ");
INSERT INTO tke_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Vano Yesu agamoonile, ahimwithanaga, omwiirela: “Mwihiyana, we ohutapuliwa oredda wanniwena.” ");
INSERT INTO tke_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ahimuhela madada, mwihiyana ole mowaaguva ahoogowaga, omutamalaga Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mpogo a nyuba ya malobelo ahitakaleliwaga vowi Yesu ahiyiliha nlabo na Sabuddu, ahawaaddelaga ateene yaaligi vevale wiira: “Ehikalawo malabo matanu ni nimohi oolaba. Mudheege muyilihiwe malabo ayene, mbwenye Sabuddu, naari.” ");
INSERT INTO tke_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mbwenye Yesu ahimwaakulaga, eeraga: “Anamaleketha nyo! Kalivo muthu onatapula ng'ombe yaaye naari buuru aaye nlabo na Sabuddu, ayana wi dhang'we mahinje? ");
INSERT INTO tke_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ki mwihiyana ola, oli mwaana a Abarahamu, Sathana ammagiliye yaaka kumi ni tanu nathaaru. Kafwaneelele otapuliwa oredda wanniyena nlabo na Sabuddu?” ");
INSERT INTO tke_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Vano Yesu agawogile nda, amwiiddani aaye yahikannaga manyazo, mbwenye athu ateene vevale yahidhiveliwaga ni dhego dhotikiniha dheeriye nde. ");
INSERT INTO tke_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Moharela Yesu ahiiraga: “Omwene wa Mulugu onaligana ni ddi? Ginafwanafwanihe ni ddi? ");
INSERT INTO tke_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Onaligana ni bewu ya mpeza, eyene muthu yathukuliye akuthela mmiddani mwaaye. Omela okala muthanko mulubale, balame dha odhulu odha omagamo dhitunji mmijiddanimwa.” ");
INSERT INTO tke_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ahiiragave: “Ginafwanafwanihe ni ddi Omwene wa Mulugu? ");
INSERT INTO tke_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Onaligana ni emela eyene mwihiyana athukuliliye otaganyiha ni malanta maraaru a asambale, ofiyedha onyakuwa naatenene.” ");
INSERT INTO tke_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Volenddoni waaye, woodhowa oZheruzalemi, Yesu oweedda mmaluwani ni mmiruddani asuuzihaga. ");
INSERT INTO tke_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Muthu mmohiwa ahimukohaga, wiira: “Nabwiyani, enavuluwa boyeva?” ");
INSERT INTO tke_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Mbwenye Yesu ahimwaakula, wiira: “Wiilibihedheni wi nvolowe mulago woopurana, Ginowuwaddelani, ajinji enodha esayelege ovolowa, mbwenye kidha yaakwaniha ovolowa. ");
INSERT INTO tke_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Adha avenya mwiinya a nyuba, afuga omulago, vano nyo munodha mwiimele ode, mukokottege esewo ni owoga, mwiiraga: ‘Nabwiya, nithuleleni hiyo.’ “Oliye onodha owaakuleni: ‘Kagunonileni. Kaginonile onadha nyo, muli awuuvi.’ ");
INSERT INTO tke_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Vevo munodha mwiirege: ‘Hiyo nooja, noong'wa ni nyo, teto muhusuuziha mundila dhowanuhu.’ ");
INSERT INTO tke_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Oliye onodha owiireleni: ‘Kaginonile onadha nyo, muli awuuvi. Venyavoni vameentoni vaaga, mwaatene owiira dhabure!’ ");
INSERT INTO tke_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Vevo munoodha mundde ni owurawura meeno, vomoona Abarahamu, Ezaaki, Yakobo ni anamavuhulela ateene mu oMweneni wa Mulugu, mbwenye nyo munodha mutukumedhiwe ode. ");
INSERT INTO tke_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Athu ajinji enodha edheelege omadheelo wa nduwa ni omadhowelo wa nduwa ni omadheelo wa pevo ya kasekase ni omadhowelo, ekale vamajelo muMweneni wa Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mowindo, ehikalawo oogomihedha enaakale owambeela, teto ehikalawo owambeela enaakale oogomihedha.” ");
INSERT INTO tke_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mudhidhi mmohive yahidhaaga maFarizi omwaaddela Yesu, wiira: “Venyawoni wuno mwaha wi Heroddi onafuna oopeni.” ");
INSERT INTO tke_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Oliye ahawaakulaga, wiira: “Mudhowe mwamwaaddele kwaddwe oyo, ‘Peeno ni menselo Ginakumiha mineba dhabure ni oyiliha dhiredda, nlabo na nethaaru Ginomariha mabasa aaga.’ ");
INSERT INTO tke_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mbwenye enofuneya Geedde olenddo waaga peeno ni menselo ni muroddo, mwaha wi kadhinarumeedheya namavuhulela akwele ode wa Zheruzalemi! ");
INSERT INTO tke_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Zheruzalemi, Zheruzalemi we, onaapa anamavuhulela, onaavonya ni mabwe ale enarumihiwa wa we, aaa! Dila ngaasi Gifunaga waatugumanya anaawo woona nikolo na mwanaku nnaatugumanya anaaye vati va mompelo aaye, we ohufunaga! ");
INSERT INTO tke_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Onani, nyuba yeenyu enodha ekale nddebe. Ebaribareene Miyo Ginowuwaaddelani wi kamudha mugoona ofiyedha mwiire: ‘Oreelihiwa oyene onadha mundina na Nabwiya.’” ");
INSERT INTO tke_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nlabo nimohi na Sabuddu, Yesu ahidhowaga vade va mpogo mmohi a maFarizi wi aje mukaathe, athu yaaligi vevale yegi omusugwesesa. ");
INSERT INTO tke_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Vahikalaga mulobwana mmohi annaga eredda yoodhibelana mwiili wateene. ");
INSERT INTO tke_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu ahaakohaga maFarizi ni ale yatapulela malamulo, eeraga: “Dhinorumedheya naari kadhinarumeedheya oyiliha Sabuddu?” ");
INSERT INTO tke_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aliwa kayawogilege yego. Vano, ahimwihiddaga, omuyiliha, ompaganya. ");
INSERT INTO tke_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Voharela ahaakohaga: “Baani mwa nyo oni mwaanaye, naari ng'ombe yaaye, egamorele vaceelani, ahitavulavo mudhidhi oyene nlabo na Sabuddu?” ");
INSERT INTO tke_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mwa ela kayandilege waakula. ");
INSERT INTO tke_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Vano Oliye egi waasugwa aliba wiithaniwa yasakulaga dhittengu dhosogolo, ahawogelaga musibe ola: ");
INSERT INTO tke_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Muthu eethaneliwa mathanga a matelo, ahikaratelege ettengu yosogolo, vowi dhinodha dhipadduwe ogakaratile, adhe owiithaniwa mmohi othithimiheya oohiyana ni we. ");
INSERT INTO tke_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Adhe ole owiithanile, eerege: ‘We, venya veethenguniva wi akarativo ola.’ Onavenyavo ni manyazo, odhowaga ettengu yoogomihedha. ");
INSERT INTO tke_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mohiyaniha weethaniwa, okaraatigi ettengu yoogomihedha; adha ole owiithanile, eera: ‘Mukwaaga, venya okaraati osogolo wuno.’ Onothithimiheya vameentoni vaaliba wiithaniwa ateene. ");
INSERT INTO tke_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vowi ole oneegweliha, onokitihiwa; oneekitiha, onogwelihiwa.” ");
INSERT INTO tke_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Teto Yesu ahiwogaga ni muliba amwiithanile: “Wafunaga ovaha yooja, naari wiirihedha mathanga, kawawiithanege akwaawo, naari addibilo, naari anaamudhi, naari amwaaddamani oreela, wi dhinadhe dhipadduwe ni aliweene yuwiithane, yuwelihedhe. ");
INSERT INTO tke_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mbwenye we wafunaga wiirihedha mathanga, wawiithanege oorabula, ootopinya, ooragala, ni ohoona. ");
INSERT INTO tke_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Weeraga ndo oneere oreelihiwa, vowi kinaakalena yowuwelihedha; yowelihedhiwa yaawo onaakele omavenyelo wa athu oharihamo” ");
INSERT INTO tke_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mmohi aaligi vevale ni Oliye vameeza, ageewile nda, ahiiraga: “Oreelihiwa duule onaje mathanga muOmweneni wa Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu ahaakulaga, wiira: “Mulobwana mmohi ahisasanyedha mathanga malubale, wawiithana athu ajinjeene. ");
INSERT INTO tke_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mudhidhi ogafiyile ahimuruma mwiimeleli aaye wi awaaddele yawiithaniliye: ‘Dhaani vowi dhatedhene dhihaakwanela.’ ");
INSERT INTO tke_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Mbwenye aliwa yahambeelaga owoga mmohi-mmohi. Owambeela ahiiraga: ‘Gihigula mudda, ginafuna gidhowe goone. Ginaloba wi mugilevelele.’ ");
INSERT INTO tke_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Mmohiya ahiiraga: ‘Gihigula ng'ombe paara tanu. Ginafuna gaxixe olimana. Ginaloba wi mugilevelele.’ ");
INSERT INTO tke_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Mmohiya ahiiraga: ‘Gihitela dhiinoveva, kaginayawo.’ ");
INSERT INTO tke_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mwiimeleli agawelilewo, ahimwaaddelaga nabwiye. Vano, muliba nyuba ahitakaleliwaga, omwaaddela mwiimeleli: ‘Venya mowaaguva, waahare arampa alubale, ni dila dha nluwa, waadhena wuno oorabula, ooragala, ohoona ni ootopinya.’ ");
INSERT INTO tke_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Mwiimeleli ahiiraga: ‘Nabwiyani, gihiirana dhatedhene woona mwawogelinyu. Mbwenye mburo ohukalawove.’ ");
INSERT INTO tke_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Vano, nabwiye ahimwaakulaga, wiira: ‘Venya wahare arampa, ni dila dha mmavade, waawaddihedhe evolowe athu ateene wi nyuba yaaga edhaale. ");
INSERT INTO tke_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ginowuwaaddelani wi ateene alene yeethaniwe vowambeela, kaavo naari mmohi oneere alawihe mathanga aaga.’” ");
INSERT INTO tke_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nuwindo, anamwinji yegi omuhara Yesu; ahaarugunuwelaga, wiira: ");
INSERT INTO tke_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Akala muthu onofuna odha wa miyo, aadhivela ababe, amaaye, mwihiyanaaye, addibilaaye arogoriye naari egumi yaaye vajinji ogihiya miyo, kanakala namasuuza aaga. ");
INSERT INTO tke_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ole ohunathukule muraddi waaye wi agiharege, kanaakale namasuuza aaga. ");
INSERT INTO tke_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Baani mwa nyo, oni afunaga omaga nyuba yulubale, vowambeela ahikarati eelengela korowa dhinafuneyege wi oone akala oneere omariha? ");
INSERT INTO tke_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dhinampadduwele agambelile adhe ahimarihe, mwaha wi keelengele korowadha mowakwanela, ateene enamoonege embeddege, ");
INSERT INTO tke_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","yiirege: ‘Mulobwana ole ahambeela omaga mbwenye kamarihile.’ ");
INSERT INTO tke_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Naari mwene baani, oni adhowaga owana koddo ni mwene mmohiya, vowambeela ahikarati oobuwelela akala ni anyakoddo aaye macikwi kumi onowaakwaniha owanana mwene ole onadha ni anyakoddo macikwi makumi meenddi? ");
INSERT INTO tke_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akala kanaakwaniha, onomuruma omwiimelela alobe mukalelo wa murenddele, mwene mmohiya agali woolapelawene. ");
INSERT INTO tke_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mowindo mwateene mwa nyo ohunahiye dhinniyena, kanaakale namasuuza aaga. ");
INSERT INTO tke_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwiinyu bwapama; ki wakumuwa, ninawelihedhena ddi? ");
INSERT INTO tke_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kunahiddiwana yego, naari okala manyowa, naari vadhuguni; mbwenye onothathiliwa. “Wiina mabaru owiiwana, eewe.” ");
INSERT INTO tke_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anamakoha-musoko ateene ni “anamathega” amohi yoomususedha Yesu wi emwiiwe. ");
INSERT INTO tke_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","MaFarizi ni anamasuuziha a malamulo yegi omwaaba, yiiraga: “Ola onowawaakela anamathega, ajaga vamohi ni aliwa.” ");
INSERT INTO tke_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Vano Yesu ahaawogela musibe ola: ");
INSERT INTO tke_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Baani mwa nyo, oni aganna mabila zana, nirimeelavo nimohi, kanaahiye mukokolani makumi matanu na manayi nuudha matanu ni neenayi adhowa asayelaga nrimeelile ofiyedha ofwanya? ");
INSERT INTO tke_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Agafwanyile, onothukula veefuddi ni odhaaliwa ohagalala. ");
INSERT INTO tke_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Vano nuudhowa vade. Ahawiithana akwaaye ni amwaaddamani, awiirelaga: ‘Agalalani ni miyo, mwaha wowi gihifwanya nibila naaga narimeelile.’ ");
INSERT INTO tke_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ginowuwaaddelani wi ni mukalelo mmohive, onokala ohagalala wulubale odhulu mwaha wa namathega mmohi onatthwaruwa, ohiyana makumi matanu na manayi ni atanu ni anayi ooharihamo ehinafuneya otthwaruwa. ");
INSERT INTO tke_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Naari mwihiyana baani, oni aganna korowa dha gwingwi kumi, arimeeliha emohi, kanahiddiha panti, azhela mba, asayelaga pama ofiyedha afwanya? ");
INSERT INTO tke_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Vano, agafwanyile, onowaatugumanya akwaaye ni amwaaddamani, eeraga: ‘Agalalani ni miyo, mwaha wowi gihiddodda korowa yagirimeele.’ ");
INSERT INTO tke_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Miyo Ginowuwaaddelani wi ni mukalelo ola, onokala ohagalala vameentoni va angero a Mulugu mwaha wa namathega mmohi otthwaruwile.” ");
INSERT INTO tke_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ahiwelelagave: “Mulobwana mmohi anna ahima abiili aalobwana. ");
INSERT INTO tke_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amung'onong'onoya mwa aliwa ahimwaaddela babaye, wiira: ‘Babani, mugigawele epaddi ya dhoreela dhigifwaneele.’ Oliye omugawelawo dhoreeladha. ");
INSERT INTO tke_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Vigavirile malabo ooyeva, muzombwe ole a mung'onong'onoya ahitugumanya dhego dhaaye dhatedhene, omaruwa, odhowa elabo emohiweene yoolapela. Wewo ahinoonga dhookalana dhaaye dhatedhene ni mukalelo wabure woohubuwelana dhoosogolo. ");
INSERT INTO tke_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Agamalile onoonga dhaaye dhatedhene mwiilaboni mule, mwahidha dala yulubale, oliye wambeela okanna goyi. ");
INSERT INTO tke_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Vano ahidhowa okala ni mulobwana mmohi a mwiilaboni mwemule, omuruma omidda waaye wi akameelege kumba dhaaye. ");
INSERT INTO tke_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wewule oofuna agarubalile maddeya yaaja kumba, mbwenye kaalivo amvaha maddeyaya. ");
INSERT INTO tke_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ahubuwelela otthwaruwa, wiyiirela yeeka: ‘Anamalaba ababa enoja erubalaga mowaakwanana, miyo wuno gikwaga dala! ");
INSERT INTO tke_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Baahi, ginovenya gidhowege wa babaga, gineere wawaaddela: Babani, gihittegela odhulu, ni vameentoni veenyu. ");
INSERT INTO tke_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Vano kagifwaneelele wiiriwa mwaaninyu; mugaakele woona namalaba eenyu.’ ");
INSERT INTO tke_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ahivenyaga odhowa wa babaye. “Adheelaga wolapelawene, babaye ahimoonaga, omweeddiwela thagaraga. Ahimuthamagelaga, omukubarela, ombezhari. ");
INSERT INTO tke_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Vano mwaana ahiiraga: ‘Babani, gihittegela odhulu, ni vameentoni veenyu. Vano kagifwaneelele wiiriwa mwaaninyu.’ ");
INSERT INTO tke_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Babaye ahawaaddelaga anamalaba aaye: ‘Dhaanani mowaaguva yoowara yooriyesesa muwariheni, teto pethe mwimbunoni, sapatho omanyaloni. ");
INSERT INTO tke_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mmudhena mwana-ng'ombe ooruva, mumpe. Niirena mathanga, nihagalale. ");
INSERT INTO tke_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mwaha wowi mwaanaga ola ahikwa vano ohukanna egumi, ahirimeela, ohufwanyeya.’ Vano wambeela ohagalala. ");
INSERT INTO tke_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mwaana a mulubale aaligi omidda. Awelagawo, aaddamelaga vade, eewilege wiiba ni wiina. ");
INSERT INTO tke_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Omwiithana namalaba mmohi omukoha eneereya ddi. ");
INSERT INTO tke_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Oliye omwaakula, wiira: ‘Ddibilawo didhiile, ababo waaruma wi epe mwana-ng'ombe yooruva, mwaha wowi ohumwaakela, aganna egumi.’ ");
INSERT INTO tke_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mwaana a mulubale otakaleliwa, kaafunaga ovolowa. Babaye ahikumelaga vade ombebeedhaga wi avolowe. ");
INSERT INTO tke_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mbwenye oliye ahawaakulaga babaye, wiira: ‘Vihivira yaaka dhijinjidhene guwiimelelagani gihilupile malamulo eenyu, mbwenye kamunagivahe naari mbuzi wi giirena mathanga ni akwaaga. ");
INSERT INTO tke_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mbwenye mwaninyu ola onoongile dhoreela dheenyu ni ahiyana oraruwa, muhumpela mwana-ng'ombe ooruva!’ ");
INSERT INTO tke_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Vano babaye ahimwaakulaga: ‘Mwaanaga, we mudhidhi wateene onakala ni miyo, dhatedhene dhili dhaaga saawo. ");
INSERT INTO tke_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mbwenye yaali yoofuneya wi nihagalale, niteyele, mwaha wi ddibilo ola ahikwa vano ohukanna egumi, ahirimeela vano ohufwanyeya.’” ");
INSERT INTO tke_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ahawaaddelaga anamasuuza aaye: “Wahikala mulobwana mmohiwa oreela; ole anna musadoro olene athu yamusumeliwa vameentoni va nabwiye wi ononoonga dhoreela dhaaye. ");
INSERT INTO tke_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Vano nabwiye, ahimwiithana, omukoha: ‘Ginewiimi wa we si ddi? Ogaaddelihemo dha omusadoro waawo, mwaha wi dhiinova kunafwaneelela okala musadoro aaga.’ ");
INSERT INTO tke_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Musadoro wiira mwa yeeka: ‘Gineere ddi? Vowi nabwiya aaga onogiigara mu omusadoroni. Olima mmiddani kaginaakwaniha, oloba teto onogikaliha manyazo... ");
INSERT INTO tke_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Miyo gihinona yowi giire, wihina athu yagaakelele mmavade mweewa geegariwa mu omusadoroni’ ");
INSERT INTO tke_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ahawiithanihaga mmohi ni mmohi alene yamfiyarele nabwiye. Omukoha owambeela, wiira: ‘Mwamfiyaarile nabwiya aaga avi?’ ");
INSERT INTO tke_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Oliye omwaakula: ‘Yoofiyaari yaaga si mino zana dha makura.’ “Nuwindo musadoro wiira: ‘Okaraati, othukule karata ya yoofiyaari yaawo olebevo mowaaguva makumi matanu.’ ");
INSERT INTO tke_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Vano, ahimukohaga anabiili: ‘Ki we, wafiyaare avi?’ “Oliye omwaakula: ‘Masakwi zana a tirigu.’ “Omwiirela: ‘Thukula karata ya yofiyaari yaawo olebevo makumi matanu ni maraaru.’ ");
INSERT INTO tke_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Vano nabwiye a musadoro oonyengetha ole, ahimutamalela mwaha wooxaga waaye wewiliiye. Mwaha wi athu a elabo ya vati booxaga okwaranya mulogo weewa oli mowaara. ");
INSERT INTO tke_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mbwenye Miyo Ginowuwaaddelani: Mulabihe dhoreela dha elabo yoonyengetha ela, wi akwiinyu dhoreeladha dhomalelani enodha yuwaakeleleni mmisasani dhohumala. ");
INSERT INTO tke_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ole oli ororomeleya ni dhooyeva, onororomeleya teto ni dhijinji; ole ohunaharihamo ni dhooyeva kanaharihamo ni dhijinji. ");
INSERT INTO tke_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Vowi, nyo mwahikale eebaribari ni dhoreela dhonyengetha, onororomeleni baani ni oreela wa ebaribari? ");
INSERT INTO tke_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Akala muli ohuroromeleya ni weeddiha dhego dha mmoheene, onoovaheni baani weeddiha dhoreela dheenyu? ");
INSERT INTO tke_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kalivo mwiimeleli onanda wawiimelela anabwiye abiili; vowi onadha amwiidde mmohi, amwandanena mmohiwa; naari oneerege omwiiwelela ola, mmohiwa amunyemulege. Kadhinandeya omwiimelela Mulugu, wiimelela dhoreela.” ");
INSERT INTO tke_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","MaFarizi, ale yaali a nrima, yeewaga dhatedhene dhedhile, yombeddaga. ");
INSERT INTO tke_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu ahawiirelaga: “Nyo munowiihelamo woona owaakwanelesesa vameentoni va athu, mbwenye Mulugu ohunona mirima dheenyu. Vowi dhinarihedheya vameentoni va athu, vameentoni va Mulugu dhinakala dhonyemuwa. ");
INSERT INTO tke_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malamulo ni anamavuhulela yahivuhulela ofiyedha mudhidhi wa Zhuwawu. Okumela vevale odhowa osogolo onolaleyiwa muselu wapama wa Omwene wa Mulugu, vano athu ateene enaakwaniha ovolowa mwemule, ni kopolo, baahi. ");
INSERT INTO tke_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sookweya vajinji ovira odhulu ni elabo ya vati, ohiyana wi omorevo mujebo mmohi wa Malamulo. ");
INSERT INTO tke_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Oli ateene onamwalana ni mwihiyana aaye, amutela mmohi, onomuraruwana; ole onamutela mwihiyana omwalane ni mamune, onomuraruwana. ");
INSERT INTO tke_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ahikalawo mulobwana mmohi oreela; awaresa dhoowara dha mutheengo mulubale dha linyu oofewa, ni owiirihedha mathanga malubale, malabo mateene akala ni mukalelo wa athu oreelesesa. ");
INSERT INTO tke_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ahikalawo teto muliba oolobaloba, eeriwa Lazaro, anna makwadda mwiili wateene. Akalesa vamulago va muliba oreela ole, ");
INSERT INTO tke_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","oofunesa oja dhonyenyeya dhamoresa vameeza a muliba oreela. Vevale anabwa yodheesa, onyangulaga makwadda aaye. ");
INSERT INTO tke_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Dhahipadduwa muliba oolobaloba agakwile. Angero yahimuthukula, omudhowana wakala Abarahamu. Teto muliba oreela agakwile yahimudhowana omulogoha. ");
INSERT INTO tke_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Arabulaga, azhaga omunddoni, mburo wa athu ookwa, ahisugwa odhulu, omoona Abarahamu ni Lazaro agali nikukuru. ");
INSERT INTO tke_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nuwindo, ahikuwaga, wiira: ‘Babani Abarahamu, mugeddiwele thagaraga, mmurume Lazaro anyethihe mmahinjeni otampini wa embuno yaaye adhena addiddilihena nlumi naaga, vowi ginorabula mmunddoni mula.’ ");
INSERT INTO tke_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abarahamu ahimwaakulaga, wiira: ‘Mwaanaga, wubuwele wi wahaakela dhego dhapama dhohagalasa egumi yaawo, wewule Lazaro aakelile dhorabula. Mbwenye dhiinova, oliye onahagalala wuno, we onorabula. ");
INSERT INTO tke_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ohiya dhatedhene, vaari va hiyo ni nyo vihikala jiji, vowi eli wuno enafuna odha wo, kinaakwaniha, naari eli wo, enafuna odha wuno kinaakwaniha.’ ");
INSERT INTO tke_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nuwindo, ahikalelaga ntidi, eeraga: ‘Babani, miyo ginowulobani wi mmurume Lazaro adhowe vade va ababa, ");
INSERT INTO tke_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mwaha wi gihikanna addibilaga atanu. Awaaddele wi ni aliwene enadhe teto mburo olena wa masoso.’ ");
INSERT INTO tke_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abarahamu ahimwaakulaga: ‘Aliwa ehikanna Mozezi ni anamavuhulela, yawiiwelelege aliweene.’ ");
INSERT INTO tke_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“ Mbwenye oliye ahikalelaga ntidi: ‘Naari, babani Abarahamu, akalavo mmohi ovenyile mwa anookwa adhowa awoga ni aliwa, enotthwaruwa.’ ");
INSERT INTO tke_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abarahamu ahimwaakulaga: ‘Akala aliwa kinamwiiwelele Mozezi ni onamavuhulela, nivang'onong'ono kinafunege ogonjihiwa wi ehiye naari muthu mmohi avenye omakwelo.’” ");
INSERT INTO tke_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ahawiirelaga anamasuuza aaye: “Kadhinandeya wi dhoholosa dhihidhe, mbwenye oddilu wa muthu oyene onadhana. ");
INSERT INTO tke_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yaali yoofwanelela amageleliwe mukohi nibwe na nsilo, avokedhiwe munyaza, ohiya omukwakwathusa muthu mmohi mwa athu ohuthithimiheya ala. ");
INSERT INTO tke_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pole-pole. “Akala ddibilawo ohuthega, omusumulule; atthwaruwa, omulevelele. ");
INSERT INTO tke_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Oothegela we dila tanu nabiili vanlaboni, dila tanu nabiili adha wa we, eeraga: ‘Gihitthwaruwa,’ omulevelele.” ");
INSERT INTO tke_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Vano, arumiwi yahimwiirelaga Nabwiya: “Munenjedhedhe nroromelo neehu!” ");
INSERT INTO tke_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nabwiya ahawaakulaga, wiira: “Mwakalana nroromelo woona bewu ya mukwani muneerege wiirela muthanko wa amora ola: ‘Wiiddule, weedhale munyaza,’ vano, oneerege wuwiiwelelani. ");
INSERT INTO tke_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Baani wa nyoovo, onakanna mwiimeleli aaye alabaga omudda, naari ang'anelaga mabila, voweruwa omudda amwiirela: ‘Odhe mowaaguva okaraati, oje’? ");
INSERT INTO tke_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kuneere nda, onomwaaddela: ‘Osasanyedhe yooja, oware guwo dhimohi, ogiimelele. Vano miyo gamala oja ni ong'wa, we fineeriwe oje, ong'we’? ");
INSERT INTO tke_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Munoobuwelela wi oneere omutamalela mwiimeleli ola, mwaha wi ohiirana dharumiwiye? ");
INSERT INTO tke_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ndala teto nyo, mweerana dhaaddeliwinyu, mwiire: ‘Nili eemeleli ebeweene mwaha wi nihiirana dhafwaneelihu wiira.’” ");
INSERT INTO tke_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu adhowaga oZheruzalemi, ahivira mmiganoni mwa Samariya ni Galileya. ");
INSERT INTO tke_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Avolowagawene mmudhini, athu kumi a maredda yahimuharelaga, wiimela wuddeddewene. ");
INSERT INTO tke_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Egeemelile wuddedde wewule yookuwaga, yiiraga: “Yesu, Namasuuziha, muneeddiwele thagaraga!” ");
INSERT INTO tke_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu agawoonile, ahiiraga: “Mudhowe mweyoonihe wa anamakutha.” Dhahipadduwa edhowaga mundila yahiyilihiwaga. ");
INSERT INTO tke_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmohi wa kumi ale, agoonile wi gihiyilihiwa, ahiwelelaga mundduli amutamalaga Mulugu ni ndhu notaama. ");
INSERT INTO tke_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Agafiyile vaaligi Yesu, ahikokoraga oworomihedha kove vati va manyalo a Yesu, atamalelaga. Ola aali muSamariya. ");
INSERT INTO tke_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Vano, Yesu ahimukohaga: “Kamwaali kumi mweelihiwe? Ki atanu ni anayi eli waani? ");
INSERT INTO tke_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kalivo mmohi owelile wi amuthithimihe Mulugu, ahili mwanaweedda ola?” ");
INSERT INTO tke_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Omwiirela: “Venya, odhowege nroromelo naawo nuhuyiliha.” ");
INSERT INTO tke_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dhahipadduwa ayi, maFarizi yahimukohaga Yesu wi Omwene wa Mulugu onadha alini? Yesu ahawaakulaga, wiira: “Omwene wa Mulugu kunadha ni mukalelo wowooneya ni meento, ");
INSERT INTO tke_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","athu kidha ewogaga: ‘Oli veva,’ naari ‘Ole oli vale,’ vowi Omwene wa Mulugu oli muwaari mwa nyo.” ");
INSERT INTO tke_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu ahawaaddela anamasuuza aaye, wiira: “Onofiya mudhidhi onafuniginyu woona nlabo nimohi na Mwaana a Muthu; mwa malabo alene, kamudha moona. ");
INSERT INTO tke_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Athu enodha yuwaaddelegeni: ‘Oli va!’ naari ‘Oli wule!’ Kamuyewo naari kamwahare. ");
INSERT INTO tke_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vowi nlabo nnadha Mwaana a Muthu kanidha naanganyedheya onakale woona ozherima, onadheela odhulu omooneyelaga dhipaddi dhatedhene. ");
INSERT INTO tke_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mbwenye enofuneya wi vowambeela oliye arabulihiwe mwa dhego dhijinji, akooddiwe ni mulogo ola. ");
INSERT INTO tke_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Dhapadduwile malabo a Nowe, teto sinapadduwe malabo a Mwaana a Muthu. ");
INSERT INTO tke_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yooja, yoong'wa, alobwana yootela, ahiyana yooteliwa, ofiyedha nlabo navolowile Nowe mmwanddeyani. Vano odha mutokora waatolosa ateene. ");
INSERT INTO tke_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Dhimohive dhedhi dhahipadduwa malabo a Lothi. Yooja, yoong'wa, yoogula, yooguliha, yoodhala, yoomaga nyuba dhijinji. ");
INSERT INTO tke_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nlabo nendde Lothi navenyigiye oSoddoma, odhulu wahirubwaga munddo, ni mabwe oohidda, waatolosa ateene. ");
INSERT INTO tke_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Dhinadha dhiireye ndala nlabo noodha wiyooneyiha Mwaana a Muthu. ");
INSERT INTO tke_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nlabo nddo, onaakale odhulu wa nyuba, onadhe akite wi akumihemo dhookalana dhaaye dhili mba. Emodha-modhave onakale omudda, ahiwelele mundduli wi athukule yego. ");
INSERT INTO tke_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mubuwelele dha mwadha Lothi! ");
INSERT INTO tke_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ole onafuna wing'anela egumi yaaye, onoyelela, vano ole onayelele onovulumusa. ");
INSERT INTO tke_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ginowuwaaddelani: Mahiyu ayene abiili enodha ekale vakamani; onodha athukuliwevo mmohi, ahiyiwevo mmohiwa. ");
INSERT INTO tke_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ahiyana abiili enodha etidege vamohi, athukuliwevo mmohi, ahiyiwevo mmohiwa.” ");
INSERT INTO tke_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Vano, anamasuuza aaye yahimukohaga: “Dhineereye waani dhedhi, Nabwiyani?” Yesu ahaakulaga, wiira: “Vevo vinaakale muruthu, fivevo teto vinatugumane mibidha.” ");
INSERT INTO tke_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu ahaawogela anamasuuza aaye musibe mmohiwa, vofuna wawaaddela wi elobelege mudhidhi wateene ehigomege. ");
INSERT INTO tke_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Eeraga: “Muluwani nimohi mwahikala namathonga miladdu ahamoova Mulugu, naari kamuriiha muthu. ");
INSERT INTO tke_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ahikalawo teto, maamukwele mmohi muluwani mwemule; adheesa wa oliye, awogaga, eeraga: ‘Mugithongele muladdu oli vaari va miyo ni mwiiddani aaga.’ ");
INSERT INTO tke_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Vahivira mudhidhi ahifunaga owoga. Mbwenye vadduliviwa ahiiraga yeeka: ‘Naari gihimoovaga Mulugu, naari gihimuriihaga muthu, ");
INSERT INTO tke_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","vowi mwihiyana ola onoginyagula, gineere gimuthongele muladdu waaye, wi onaadhe aginyagulegeve.’” ");
INSERT INTO tke_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nabwiya ahenjedhagave, eeraga: “Muhiiwa madhu a namathonga muladdu gwalagwambi ole. ");
INSERT INTO tke_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mulugu kanaathongele mweebaribari oosakuliwa aaye, enamwebedha mahiyu ni mutana; naari viviraga malabo majinji ahinawaakule? ");
INSERT INTO tke_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ginowuwaaddelani: Mulugu mowaaguva onodha athonge muladdu weewa. Mwa dhatedhene dhedhi adha adhaaga Mwaana a Muthu, onodha afwanye nroromelo elabo ya vati?” ");
INSERT INTO tke_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu ahenjedhagave, waawogela musibe ale yeeroromela, wi boharihamo malamulo a Mulugu, yaabeddaga athu amohiwa. ");
INSERT INTO tke_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Yaaligi alobwana abiili yahivolowaga nyuba ya Mulugu wi yalobele; mmohi aali mFarizi, mmohiya aali namakoha-musoko. ");
INSERT INTO tke_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","MFarizi ageemelile, egi olobela mwa oliye yeeka, eeraga: ‘Mulugu, ginowutamalelani vowi kaginaligana ni athu amohi: anameeya, ohuroromeleya, aliba oraruwa, woona namakoha-musoko ola. ");
INSERT INTO tke_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ginothuga dila biili vasumaanani, ginoveleela dhaneekumi mwa dhatedhene dhinapurimi.’ ");
INSERT INTO tke_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mbwenye namakoha-musoko ahiimelaga, volapelavene, naari kaafunaga othukulela meento aaye odhulu addwadhaga vathimarimani vaaye, eeraga: ‘Eee, Nabwiya Mulugu, mugeeddiwele thagaraga vowi gili namathega.’” ");
INSERT INTO tke_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu ahiiraga: “Ginowuwaaddelani wi namakoha-musoko ole ahiwelelaga vade vaaye agaleveleliwe dhoothega dhaaye, mmohiwa ole, naari. Ole oneere eyunuwihe onokitihiwa, oneeyeviha onowunuwihiwa.” ");
INSERT INTO tke_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Athu yegi waadhana ahima ang'onong'ono wa Yesu wi aahidde areelihe. Anamasuuza yawooniligiwa ale, yegi wanyanyuwela. ");
INSERT INTO tke_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mbwenye Yesu ahawithanelaga vaaligi Oliye anahimaya, wiira: “Mwaahiye edhe wa Miyo anaahima. Kamwaahihe, vowi Omwene wa Mulugu anya bi ale enaligana ni aliwa. ");
INSERT INTO tke_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ebaribareene, Ginowuwaaddelani: Ole ohunaakele Omwene wa Mulugu woona mwaana, kadha avolowamo.” ");
INSERT INTO tke_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mulobwana mmohiwa aali namathonga ahimukohaga Yesu: “Namasuuziha apama, gineere ddi wi gikalena egumi yoohumala?” ");
INSERT INTO tke_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ahimwaakulaga: “Onagiirelela ddi apama? Kalivo oli apama, apama di Mulugu, baahi. ");
INSERT INTO tke_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ohaanona malamulo: ‘Kuraruwe, kupe, kawiiye, kumurathele muthu, omurihege babo ni amaayo.’” ");
INSERT INTO tke_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Namathonga ahiiraga: “Wambeela ezombwe yaaga ginowiiresana dhatedhene dhedho.” ");
INSERT INTO tke_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu ageewile, ahimwiirelaga: “Yego emohi ehuuhaleela, ogulihe dhatedhene dhinniwena, waavahe oorabula korowa dha, oneere okanna dhoreela odhulu. Vano odhe, ogiharege.” ");
INSERT INTO tke_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mbwenye oliye ageewile madhu ale, ahikukumuwaga, mwaha wowi aali oreela vajinji. ");
INSERT INTO tke_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu agamoonile wi ohukukumuwa vajinji, ahiiraga: “Dhili dhoorusa vajinji oreela wi evolowe muMweneni wa Mulugu! ");
INSERT INTO tke_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Eli yookweya kamelo ovira mookupula mwa singano, ohiyana athu oreela ovolowa muMweneni wa Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ale yeewilege yahiiraga: “Dheera ndo, ki onavulumusiwe baani?” ");
INSERT INTO tke_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ahawaakulaga: “Dhihinandeya ni athu, dhinandeya ni Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Vano Peduru ahiira: “Hiyo niihiya dhatedhene dhaanihuna wi nuharegeni!” ");
INSERT INTO tke_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ahawaakula, eeraga: “Ebaribareene Ginowuwaaddelani wi kaliwo muthu onahiye nyuba yaaye, mwihiyanaaye, addibilaaye, ababiinya, naari anaaye, mwaha wa Omwene wa Mulugu; ");
INSERT INTO tke_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ohunaakele dhiinoveva vajinjivene mookwaranya dhaaniyena; vano elabo enadha, egumi yoohimala.” ");
INSERT INTO tke_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ahawithanelaga vowihivale kumi na biili, wiira: “Mwiiwe, nnadhowa oZheruzalemi. Wewo onaakwanelihiwe dhatedhene dhilebiwe ni anamavuhulela dhinawoga dha Mwaana a Muthu. ");
INSERT INTO tke_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Oneere opelekiwa mmadadani mwa athu oode. Eneere omunyemula, omuruwana, omutapera mare, ");
INSERT INTO tke_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","omwaxula, empe. Vano nlabo na nethaaru oneere ovenya muukwani.” ");
INSERT INTO tke_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Anamasuuza ale kayeewelelagamo yego mwa dhatedhene. Dhatapulelaga madhu ala yaaligi oowipiteya, kayanonelagamo dhawogigiye. ");
INSERT INTO tke_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dhahipadduwa Yesu aaddamelaga oZheriko, wahikala muliba ohoona akaratilege waaddamela mundila, alobaga wa athu yowikamihedhana. ");
INSERT INTO tke_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ageewile musiddo wa anamwinji yaviraga, ahikohaga eneereya si ddi. ");
INSERT INTO tke_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yahimwaaddelaga: “Yesu oNazareti dinavira.” ");
INSERT INTO tke_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Vano oliye ahikuwaga: “Yesu, Mwaana a Davidi, mugeeddiwele thagaraga!” ");
INSERT INTO tke_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ale yadhowaga osogolo wa Yesu yomwihihaga wi amaale, mbwenye ookuwagave ni ntidi: “Mwaana a Davidi, mugeeddiwele thagaraga!” ");
INSERT INTO tke_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Vano Yesu ahiimelaga, wawiirela wi emudhowena va Oliye. Agafiyile, Yesu ahimukohaga: ");
INSERT INTO tke_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Onafuna Guwiirele ddi?” Oliye waakula: “Nabwiyani, ginafuna giwelele woona.” ");
INSERT INTO tke_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ahimwiirelaga: “Woona waawo owelele! Nuyilihile thi nroromelo naawo.” ");
INSERT INTO tke_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mowaaguva ahambeela woona; omuharaga, amutamalaga Mulugu. Athu ateene egoonile nde, teto yoomutamalaga Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ahifiya oZheriko, aviraga muluwani mule. ");
INSERT INTO tke_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mwahikala muthu mmohi oreela mmohi eeriwa Zakeyu, mpogo a anamakoha-musoko. ");
INSERT INTO tke_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Oofunesesaga omoona Yesu baani, mbwenye kaakwanihilege ni winjiva wa athu, vowi aali ookwiva. ");
INSERT INTO tke_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nuwindo, ahithamagelaga osogolo, ogwela munthazani wi amoone, vowi Yesu aavira vevale vaaligiye. ");
INSERT INTO tke_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu agafiyile mburo olene, ahisugwaga odhulu, omwiirela: “Zakeyu, kita mowaaguva. Vowi soofuneya peeno wi Gikale vade vaawo.” ");
INSERT INTO tke_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Oliye ahikitaga mowaaguva, omwaakela ni ohagalala. ");
INSERT INTO tke_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ateene yoonilege nde, yomwaabaga yiiraga: “Oliye ofiyedhe vade va ‘namathega.’” ");
INSERT INTO tke_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nuwindo Zakeyu ahiimelaga, omwiirela Nabwiya: “Ginogawa vaari dhoreela dhaaga gaavahe oorabula. Akala gihimwiiyela muthu, ginomuwelihedha dila nayi okwaranya dhamwiyelimi.” ");
INSERT INTO tke_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu ahimwiirelaga: “Peeno ovulumusa ohufiya vade va, vowi ola teto di mwaana a Abarahamu. ");
INSERT INTO tke_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vowi, Mwaana a Muthu odheele wasayela ni wavulumusa orimeela.” ");
INSERT INTO tke_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu ahawogelaga musibe mmohi wa alene yamwiiwaga Oliye nde dhawogigiye, vowi aali vakuukuvi ni oZheruzalemi, mwa ela aliwa yoobuwela wi Omwene wa Mulugu weere ofiya mowaaguva. ");
INSERT INTO tke_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nuwindo Yesu wiira: “Muthu mmohi a nlogo noovuweya ahidhowa elabo emohiya woolapa wi avahiwe omwene endo awelewo. ");
INSERT INTO tke_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ahawiithanaga amwiimeleli aaye kumi, waavaha korowa kumi, wiira: ‘Mmwiiregena nagooso ofiyedha ginawelimiwo.’ ");
INSERT INTO tke_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Mbwenye athu a elabo ele yoomugana, yahaaruma mundduli mwaaye arumiwi wi yamwiirele: ‘Hiyo kannafuna wi anithongege.’ ");
INSERT INTO tke_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Vano oliye aweliliyewo, agavahiwe omwene. Ahawiithanaga amwiimeleli alene yaavahiliye korowa, wi anone dhipurilisu. ");
INSERT INTO tke_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ahidhaaga owambeela, wiira: ‘Nabwiyani, korowa dheenyu nde, gipurilemo dhimohi kumi.’ ");
INSERT INTO tke_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nabwiye ahimwaakulaga, wiira: ‘Dhihikala pama, oli mwiimeleli apama; mwaha wi ohooneyiha ororomeleya ni dhooyeva, onodha waathonge maluwa kumi.’ ");
INSERT INTO tke_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ahidhaaga mwiimeleli anabiili, eeraga: ‘Nabwiyani, korowa dheenyu nde, gipurilemo dhimohi tanu.’ ");
INSERT INTO tke_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nabwiye ahimwiirela teto ni olena: ‘Onodha waathonge maluwa matanu.’ ");
INSERT INTO tke_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Odha vevale mwiimeleli mmohiwa, eeraga: ‘Nabwiyani, korowa yeenyu ela, galogohiliimi gamagile mu lesoni. ");
INSERT INTO tke_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Miyo gowuwoovani, vowi nyo muli muthu oorusa. Munovenyihavo elene muhuhelilinyuvo, ni ohadda nde muhudhalilinyu.’ ");
INSERT INTO tke_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Nabwiye ahimwaakulaga, wiira: ‘Mwiimeleli abure! Ni mwaha wa vamulomoni vaawo ginowukona. Wahinona wi miyo gili muthu oorusa, ginovenyihavo gihihelilimivo ni ohadda dhihidhalilimi. ");
INSERT INTO tke_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ki mwahaya bwa ddi odhe ohuhelege obanko korowa yaaga, wi miyo gawelawo gaakele mowenjedhedheya?’ ");
INSERT INTO tke_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Vano ahawiirelaga ale yoonelaga: ‘Mwaakeni korowaya mumvahe olene winna kumi.’ ");
INSERT INTO tke_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aliwa yahimwaakulaga: ‘Nabwiyani, oliye ohukanna dhimohi kumi!’ ");
INSERT INTO tke_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Oliye ahimwaakulaga: ‘Miyo Ginowuwaaddelani wi olene winna, onowenjedhedhiwa; mbwenye ole ohinna, elene yiniyena onowaakiwa. ");
INSERT INTO tke_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mbwenye amwiiddani alene yahafunile wi miyo gaathongege aliwa, mwaadhena wuno mwaape vameentoni vaaga!’” ");
INSERT INTO tke_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Vano Yesu agawogile nde, ahisogolaga odhowa oZheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dhahipadduwa wi yaaddamelaga oBetifazha ni oBetaniya, vakuukuvi ni Mwango wa Olivera, ahaarumaga anamasuuza aaye abiili, ahawiirelaga: ");
INSERT INTO tke_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Dhowani mmavade a mmiganoni mwemule, mwavolowaga, munomfwanya buuru agamageleliwe ohunagweliwege ni muthu. Mmutapule, mmudhena. ");
INSERT INTO tke_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mmohiwa onookoheni, eera: ‘Munamutapulela ddi?’ mmwaakule, mwiire: ‘Nabwiya dinamfuna.’” ");
INSERT INTO tke_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Vano edhowaga ale yarumiwege, yahimfwanyaga woona mwemule mwawaaddelege Yesu. ");
INSERT INTO tke_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Aliwa emutapulaga buuru, anyaya yahiiraga: “Munamutapulela ddi?” ");
INSERT INTO tke_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aliwa yahawaakulaga, wiira: “Mwaha wi Nabwiya dinamfuna.” ");
INSERT INTO tke_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nuwindo yahimudhaagana, otadeela dhoowara vadhulu vabuuru ole, omwiirela Yesu wi amugwele. ");
INSERT INTO tke_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu adhowaga, athu yootadeelaga dhoowara mundila. ");
INSERT INTO tke_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Vano aaddamelaga mukitakita wa Mwango wa Olivera, anamwinji ateene, anamasuuza, yoolupaga mohagalala, ni madhu omutamala Mulugu, mwaha wa dhotikiniha dhatedhene nde dhooniliwa, yiiraga: ");
INSERT INTO tke_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Oreelihiwa di mwene ole onadha mu ndina na Nabwiya!” “Murenddele okale odhulu nthithimiho nikale wa Mulugu Mudhulu-dhulu!” ");
INSERT INTO tke_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Vevale, maFarizi amohiwa yahimwiirelaga vaari va anamwinji: “Namasuuziha, mwamaalihe anamasuuza eenyu!” ");
INSERT INTO tke_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mbwenye Yesu ahawaakulaga: “Ginowuwaaddelani wi aliwa yamaala, mabwe binakuwege.” ");
INSERT INTO tke_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu aaddamelaga oZheruzalemi, agoonile nluwa, ahinddaga, ");
INSERT INTO tke_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","eeraga: “Eee! Peeno akalagahi wahinona mwa we weeka, dhego dhinavaha murenddele. Mbwenye dhiinova nda dhili dhologoheya vameentoni vaawo. ");
INSERT INTO tke_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Vowi enodha malabo amwiiddani aawo enoorijiwa ni miliddi dhothawelamo, ni waapeliha dhipaddi dhatedhene yuthiyelelena. ");
INSERT INTO tke_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Eneere wutolosa we ni anaawo ateene. Vowi kandha nihiyiwa nibwe nimohi vadhulu va nibwe nimohi, mwaha wi kunonile mudhidhi olene wadhiile Mulugu wi oovulumuse.” ");
INSERT INTO tke_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Vano, Yesu avolowaga vathaddo va nyuba ya Mulugu, ahambeelaga wawiigara yagulihaga. ");
INSERT INTO tke_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ahawaaddelaga: “Dhihilebiwa: ‘Nyuba yaaga enakale nyuba ya malobelo.’ Mbwenye nyo muhusaddula okala nikungu na ambava.” ");
INSERT INTO tke_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu oosuuzihesa munyuba ya Mulugu malabo mateene. Mbwenye apogo a anamakutha, anamasuuziha a malamulo, ni asogoleli a athu yoofuna empe. ");
INSERT INTO tke_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mbwenye kayanna yowiira, vowi athu ateene yoodhiveliwa vanjinjivene yavuruwanaga madhu aaye. ");
INSERT INTO tke_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nlabo nimohi mwa mudhidhi, Yesu, asuuzihaga nlogo munyuba ya Mulugu, alaleyaga Muselu Wapama, yahimudheelaga apogo a anamakutha ni anamasuuziha a malamulo, vamohi ni makolo a mutugumano. ");
INSERT INTO tke_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yahimukohaga, wiira: “Onaaddele, odhiilena waani othonga? Wuvahile othonga wula baani?” ");
INSERT INTO tke_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu ahaakulaga, wiira: “Miyo teto Ginowukohani yego emohi. Mugaddele: ");
INSERT INTO tke_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Amvahile owodha Zhuwawu dha obathiza aali Mulugu, yaali athu?” ");
INSERT INTO tke_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Vano aliwa yegi waaddelana mmohi ni mmohiwa, yiiraga “Neera: ‘Mulugu,’ Oliye onowiira: ‘Mwaha mudhe muhumurumeedhege?’ ");
INSERT INTO tke_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Vano nehi niire: ‘Waali wa athu,’ athu ateene enofiyedha onipa ni mabwe, vowi mmurimani mweewa enolibihedha wi Zhuwawu aali namavuhulela.” ");
INSERT INTO tke_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Omamalelowa, yahaakulaga, wiira: “Kannonile.” ");
INSERT INTO tke_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Vano, Yesu ahawaakulaga: “Miyo teto kaginowaaddelani ni othonga baani Gineerimina dhego nda.” ");
INSERT INTO tke_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nuwindo, Yesu ahawogelaga athu ale musibe ola: “Mulobwana mmohi ahilima mudda aaye wa mvidera, ahaahiyedha anamalima, oliye ovenya veelaboni vale odhowa elabo emohiwa, ahikala wewule mudhidhi woolapelene. ");
INSERT INTO tke_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ogafiyile mudhidhi wovaha furuta, ahimuruma mwiimeleli aaye wa anamalima ale wi yamvahewo furuta dha mmuddani mule. Mbwenye anamalima ale yahimuddwadhaga, omuweleliha mundduli ahinna yego. ");
INSERT INTO tke_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nuwindo ala ahimuruma mwiimeleli mmohiwa, mbwenye teto ni olena yahimuddwadha, omwiirela dhabure, omuweleliha mundduli ahinna yego. ");
INSERT INTO tke_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nuwindo ahimuruma anethaaruya, teto ni olena yahimporosa, omvokedha okwibi. ");
INSERT INTO tke_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Vano, muliba mudda ole ahiira: ‘Gineere ddi? Gimurume mwaanaga ginamudhivelimi, mwaagahi ola kimuriiha?’ ");
INSERT INTO tke_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Anamalima ayo egamoonile, yahaddelanaga mmohi ni mmohiwa. Yiiraga: ‘Ola di namavolowa mba, nimpeni, wi dhoreeladha dhidhe dhikale dheehu.’ ");
INSERT INTO tke_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yahimvokedhaga ode, ompa. “Muliba mudda, onawiirena avi? ");
INSERT INTO tke_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Oliye onodha, aatolose anamalima ale, aavahe amoheene muddaya.” Athu egeewile nda, yahiiraga: “Dhi kadhinapadduwa!” ");
INSERT INTO tke_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Vano, Yesu ahaasugwaga, wiira: “Yootapulelaya siddi maleba ala eni: ‘Nibwe nenddo nakooddile anamamaga nyuba, ndda nihidha osadduwa okala nibwe nohiddeela nyuba?’ ");
INSERT INTO tke_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Olene onatongwele nibwe nddi, onogwaddanyeya; vano ole nnammoreliwa nibwe nddi, onotaateleya.” ");
INSERT INTO tke_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wora emohive elene, anamasuuziha a malamulo, ni apogo a anamakutha yoomusayelaga wi emwihidde, vowi yahiiwaga wi musibe ole, aasibaga aliweene. Mbwenye yowawoovaga athu. ");
INSERT INTO tke_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Vano yoomuhara-hara, yahaaruma athu yanna mukalelo woona ooharihamo, wi yamuwage muwano, emwihidde, yampeleke mu othongi wa kuminadori. ");
INSERT INTO tke_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Vano, yahimukohaga, wiira: “Namasuuziha, nihinona wi munowoga, munosuuziha mowogowamwene, kamwinna nsakulo wi ola baani, munosuuziha dila ya Mulugu ni ebaribari. ");
INSERT INTO tke_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dhinorumedheya, naari kadhinarumeedheya wi nipelekege musoko wa Sezari?” ");
INSERT INTO tke_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mbwenye Yesu vonona onaabure weewa, ahawaakulaga: ");
INSERT INTO tke_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mugoonihe korowa ya gwingwi emohi. Kove elivo sa wani? Ki ndina nilebiwevo tha wani?” ");
INSERT INTO tke_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Vano, yahaakulaga: “Ya Sezari.” Yesu ahawiirelaga: “Mumvahege Sezari eli ya Sezari, Mulugu eli ya Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kayoonile yomwihiddana mmadhuni vameentoni va athu. Vano motikiniheya ni dhowaakula dhaaye, yahimaalaga. ");
INSERT INTO tke_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ASaduseyi amohiwa, ayene yaharumeedha wi ohukalawo ovenyihiwa muukwani, yahimwaaddamela Yesu. ");
INSERT INTO tke_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yahimukohaga, wiira: “Namasuuziha, Mozezi ohunilebela nlamulo niiriliye wi akwa ddibila ammohiwa, akala ahitela amwihiya mwihiyana, ahibalana ahima; ddibilaye amutele maamukweleya wi ambalihedhe aana a addibilaye ole. ");
INSERT INTO tke_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vowi yahikalawo addibila atanu ni abiili. Owambeela otela, okwa, ahibalilena ahima. ");
INSERT INTO tke_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Anabiili, ");
INSERT INTO tke_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","anethaaru, emodha-modhave atanu ni abiili ala yahikwa ehimbalihedhe ahima. ");
INSERT INTO tke_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Teto omakuthulowa mwihiyana ole okwa. ");
INSERT INTO tke_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mwihiyana ola nlabo novenyihiwa muukwani, onaakale mwadha wani, vowi atanu ni abiili ala yahimutela?” ");
INSERT INTO tke_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ahawaakulaga, wiira: “Athu eli elabo ya vativano enotela, enoteliwa. ");
INSERT INTO tke_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mbwenye ale enakale oofwanelela ofiya elabo enadha eyo, vovenyihiwa muukwani kawuli otela naari oteliwa. ");
INSERT INTO tke_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Vowi kinaakwege, enaakale woona angero. Vano enakala ahima a Mulugu, mwaha wovenyihiwa muukwani. ");
INSERT INTO tke_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mozezi ahiwoga wi anookwa enovenyihiwa, vawogiliye thalako ya nikupu nahiddaga munddo, veriliiye wi Nabwiya di, ‘Mulugu a Abarahamu, Mulugu a Ezaaki, Mulugu a Yakobo.’ ");
INSERT INTO tke_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mulugu kahuwo Mulugu anookwa, di Mulugu athu ookalawo. Vowi wa Oliye ateene ehikanna egumi.” ");
INSERT INTO tke_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Vano, amohiwa mwa anamasuuziha a malamulo yahiira: “Namasuuziha, muhaakula pama!” ");
INSERT INTO tke_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Egeere ndo, yowoovaga omukoha dhimohidhiwa. ");
INSERT INTO tke_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Vano Yesu ahaakohaga, wiira: “Dhinawogeliwa ddi wi Kirixtu di mwaana a Davidi? ");
INSERT INTO tke_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Vowi mwinyeene Davidi ohuwoga mManiivuruni a Masaalimu wiira: “‘Nabwiya ohuwoga wa Nabwiya aaga: Okaraati omoononi-waaga-wooja, ");
INSERT INTO tke_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ofiyedha Gaasaddule amwiiddani aawo ekale vonyingala manyalo aawo.’ ");
INSERT INTO tke_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ki akala Davidi onowiithana ‘Nabwiya.’ Onadha addi okala mwaanaye?” ");
INSERT INTO tke_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Athu ateene emvuruwanaga, Yesu ahawaaddelaga anamasuuza aaye: ");
INSERT INTO tke_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pole-pole ni anamasuuziha a malamulo. Aliwa enodhiveliwa owara dhoowara dhoolapa, enodhiveliwa vajinjivene olojeliwa mmamisika. Munyuba dha malobelo, enothamagela dhittengu dhowambeela, mburo dhowambeela mmathangani. ");
INSERT INTO tke_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aliwa enowaaka mowaaguva nyuba dha amaamukwele aahiyana, ni wawiiyela dhookalana dheewa mohukalana manyazo, enolobela moolapiha, mowapela malango. Athu ala enodha yoonihiwe goyi yulubale waakwaranya amohi.” ");
INSERT INTO tke_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ahisugwaga, wawoona aliba oreela evokedhaga yoovaha mukaxani mwa korowa ya nyuba ya Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ahimoonaga maamukwele a mwihiyana oorabula, ahivokedhagamo korowa biili dhing'onong'ono. ");
INSERT INTO tke_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Vano ahiiraga: “Ebaribareene, Ginowuwaaddelani wi maamukwele a mwihiyana oorabula ola, ohuvaha vajinji waakwaranya ateene. ");
INSERT INTO tke_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mwaha wi ala ehivaha woona yoovaha moothapa. Mbwenye ola, moorabulani mwaaye, ohuvaha dhatedhene dhanniyena dhafuniye wiikamihedhana.” ");
INSERT INTO tke_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anamasuuza amohiwa yoowogaga dha mukalelo womageya nyuba ya Mulugu, moowomihedhela ni mabwe apama ni mivaho dha nyuba ya Mulugu. Yesu ahiiraga: ");
INSERT INTO tke_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nyo munoona dhego nda? Enofiya malabo oneeriwa ohukale nibwe vadhulu va nibwe, nikwe nihinabidhuliwe.” ");
INSERT INTO tke_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yahimukohaga, wiira: “Namasuuziha, dhinapadduwa alini dhedhi? Ki etonyihedho baani enadhe ekalewo, dhego nda, dhadha dhaakwanelihiwaga?” ");
INSERT INTO tke_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ahawaakulaga, wiira: “Pole-pole wi munadha munyengethiwe. Ajinji enodha edheege mundina naaga, yiiraga: ‘Miyo gili oliyeene,’ teto enodha yiirege: ‘Mudhidhi ohaaddamela.’ Ala, munadha mwahare! ");
INSERT INTO tke_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mudha mwiiwaga dha koddo, ovenyedhana; muhoove. Enofuneya vowambeela dhipadduwe dhego nda, mbwenye omagomelo kunafiye.” ");
INSERT INTO tke_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Vano ahawaaddela: “Mulogo onodha ovenyedhane ni mulogo mmohi, omwene ni omwene omohi. ");
INSERT INTO tke_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Onodha okalewo othikeya wulubale wa elabo, ni dala ni dhiredda woona thoba mburo dhohiyana-hiyana, dhoopadduwa dhowoopiha dhulubale, ni dhitonyihedho dhulubale dhodheela odhulu. ");
INSERT INTO tke_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Dhihineereye dhego dhatedhene nda, enodha yuhiddegeni ni wurabulihani. Yuuthukulelegeni omuladduni munyuba dha malobelo ni wufugelani mukaambura. Munodha mpelekiwege vameentoni va amwene ni makuminadoro, mwaha wa ndina naaga. ");
INSERT INTO tke_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nda dhinodha dhupadduweleni wihina mugiirele onamoona. ");
INSERT INTO tke_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mulibe murima kamukathamiheye yoofuna waakula. ");
INSERT INTO tke_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Vowi Miyo Ginodha Guvaheni madhu ni ononelamo wi amwiiddani eenyu kidha ekoodda naari ovaanya. ");
INSERT INTO tke_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ababiinyu, addibiliinyu, amudhiinyu ni akwiinyu enodha yuupelekegeni. Amohiwa mwa nyo enodha epiwe. ");
INSERT INTO tke_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ateene enodha yuwiiddegeni mwaha wa ndina naaga. ");
INSERT INTO tke_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mbwenye kamudha muyelela naari nthithi nimohi na mmuruni mweenyu. ");
INSERT INTO tke_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mwelibihedhagave, munodha mpure egumi yeenyu. ");
INSERT INTO tke_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Teto, mudha mmoona Zheruzalemi arijiwa ni anyakoddo, munone wi obwanyuliwa waaye ohaaddamela. ");
INSERT INTO tke_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Vano, ale enakale muZhudeya, etthawelege mmwangoni; ale enadha ekale muluwani, ekumemo; ale enadha ekale mmamidda, enadha evolowe muluwani mwa. ");
INSERT INTO tke_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vowi malabo ayo enadhe, ekale malabo agoyi wi dhaakwanele dhatedhene dhilebiwe. ");
INSERT INTO tke_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Malabo ayo enodha ekale owoophia wa ahiyana alene enakalena wari, ni owaamwiha! Vowi onodha okale goyi, okubanya wulubale mwilaboni ya vati, ni owali wa Mulugu wa athu ala. ");
INSERT INTO tke_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Enodha epiwege ni masupadda, amohi enodha ecedheliwege dhilabo dhatedhene. Athu oode enodha emunyingalele Zheruzalemi ofiyedha waakwanela mudhidhi wa athu oode ale. ");
INSERT INTO tke_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Onodha wooneye dhitonyihedho vanduwani, vamweerini, ni vattendderini. Veelaboni ya vati vinodha vikale masoso, ni makattamiho wa athu a milogo, othusiwa ni okukuma wa mahinje a mbara ni kuluzi. ");
INSERT INTO tke_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Athu ateene enodha ehileyege ni woova yubuwelelaga dhinafuna opadduwa mwiilaboni, vowi kopolo dhoodhulu dhinodha dhithikeye. ");
INSERT INTO tke_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Vano, munodha mmoone Mwaana a Muthu adhaaga vamuraboni ni owodha ni nthithimiho nuulubale. ");
INSERT INTO tke_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mwadha moona dhipadduwaga dhego dhedhi libani mirima, muthukule kove dheenyu vowi wooboliwa weenyu ohaaddamela.” ");
INSERT INTO tke_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu ahawaaddela musibe mmohi, wiira: “Mwamoona namutambwi ni mithanko dhimohi. ");
INSERT INTO tke_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Dhambeela opwedheya, nyo munonona wi elimwe ehaaddamela. ");
INSERT INTO tke_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mwadha moona dhego dhedhi dhiireyaga, munone wi Omwene wa Mulugu ohaaddamela. ");
INSERT INTO tke_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ebaribareene dhatedhene dhedhi dhineere opadduwa, athu amohiwa eliwo mudhidhi olena ehinakwe. ");
INSERT INTO tke_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Odhulu ni elabo ya vati dhinodha dhimale, mbwenye madhu aaga kidha emala. ");
INSERT INTO tke_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pole-pole, mirima dheenyu dhihikale dholodhowa ni mathanga, olezela ni ozuzumela dha elabo ya vati, wihina nlabo nenddo nnodheeleni morurumusa woona musapa. ");
INSERT INTO tke_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vowi nnodha nadheele athu enakala elabo yateene ya vati. ");
INSERT INTO tke_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mwiying'anele mudhidhi wateene, ni olobela mwaha wi mukalena kopolo dhorabelana dhego dhatedhene dhineereyege, ni wiimela vameentoni va Mwaana a Muthu.” ");
INSERT INTO tke_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu oosuuziha malabo mateene munyuba ya Mulugu. Mbwenye vakala mahiyu ookuma, odhowa okalaga oMwangoni wa Olivera. ");
INSERT INTO tke_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vano athu ateene yoodhowa bebeheene wi yakale ni Oliye munyuba ya Mulugu wi yamwiiwege. ");
INSERT INTO tke_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mudhidhi wa mathanga a mikaathe dhohukanna emela, yeeriwa Paxkwa waaddamelaga. ");
INSERT INTO tke_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Apogo a anamakutha ni anamasuuziha a malamulo yoosayelaga mukalelo wowi empe Yesu, mbwenye yowawoova athu. ");
INSERT INTO tke_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Vano Sathana ahivolowa mmurimani mwa Zhuda, eeriwa Esikariyothi, mmohi wa kumi ni abiili. ");
INSERT INTO tke_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Oliye ahidhowa wa apogo a anamakutha, ni ale yaang'anela nyuba ya Mulugu wi yeewananele mukalelo wompeleka Yesu. ");
INSERT INTO tke_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aliwa yahidhiveliwa, wiiwananela omvaha korowa. ");
INSERT INTO tke_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Oliye orumeedha, osayelaga mudhidhi wompeleka anamwinji ehilivo. ");
INSERT INTO tke_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Vano nigafiyile nlabo na mathanga a mikaathe dhohukanna emela, vapiwa mwaana nibila a mukutho wa Paxkwa. ");
INSERT INTO tke_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu ahimuruma Peduru ni Zhuwawu, eeraga: “Kaweni mwasasanyedhe dhooja dha Paxkwa wi nije.” ");
INSERT INTO tke_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aliwa yahimukohaga, wiira: “Munafuna nasasanyedhe dhoojadha waani?” ");
INSERT INTO tke_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu ahawaakula, wiira: “Mwavolowaga muluwani, muneere omfwanya mulobwana mmohi agathukulile muno wa mahinje. Mmuharege vade vineeriye avolowe. ");
INSERT INTO tke_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mmukohe mwiinya a vade, mwiire: ‘Namasuuziha wiire: Suubi owi Gijelemo mathanga a Paxkwa ni anamasuuza aaga oli waani?’ ");
INSERT INTO tke_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Oliye onowuwoonihani suubi mulubale a vadhulu, mwemo muli dhatedhene dhoofuneya vamathangani. Musasanyedhemo dhoojadha.” ");
INSERT INTO tke_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aliwa edhowaga yahifwanya dhatedhene woona mwawaaddelege Yesu, osasanyedha mathanga a Paxkwa. ");
INSERT INTO tke_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Vano mudhidhi ogaakwanile, Yesu ahikaratigi vameeza vamohi ni arumiwi aaye. ");
INSERT INTO tke_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ahiwogaga, wiira: “Ginofuna vajinjivene wi nimuje vamohi Paxkwa ola dhihinafiye dhoovoreya dhaaga. ");
INSERT INTO tke_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ginowuwaaddelani wi kagidha Gimuja mmohi ofiyedha aakwanelihiwe muMweneni wa Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ageere ndo, ahithukula nakoma a vinyu, ovahedha mahala, wiira: “Mwaakeleni, mmugawane mwateene mukaleliinyu. ");
INSERT INTO tke_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ginowuwaaddelani wi kagidha Ging'wa, dhoovaha dha muthanko wa uuva dila emohi ofiyedha odha Omwene wa Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Vano ahithukulaga mukaathe, ovahedha mahala, ogwaddanya, waavaha, wiira: “Ola bu mwiili waaga onavahiwa wa nyo; mwiiregena ndo moogubuwelela.” ");
INSERT INTO tke_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ni mukalelo wankeene, egamalile oja, ahimuthukulaga nakoma, wiira: “Ola di nakoma owaandana wuxa wa mwazi waaga, onavuuvela wa nyo. ");
INSERT INTO tke_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Mbwenye moone muthu ole onafuna ogiguliha oli ni miyovano vameeza veva. ");
INSERT INTO tke_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ebaribareene, Mwaana a Muthu, oneere opiwa woona mwafuneyeliwa, mbwenye oneere woona muthu oyene onagigulihe!” ");
INSERT INTO tke_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Vano arumiwi yahambeelaga okohana vakaleligiisu, yiiraga mwa aliwa, wi eerena dhendo baani. ");
INSERT INTO tke_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Teto wahikalaga ovaanyihana vakaleligiisu, yiiraga wi mwa aliwa aali oofuneya baani. ");
INSERT INTO tke_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu ahawaaddela, wiira: “Mamwene a athu oode enowaathonga athu eewa; ale enaathonga eneeriwa anameerana dhapama. ");
INSERT INTO tke_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mbwenye, nyo kamunaakale ndo. Mohiyaniha, mpogo mwa nyo onaakale woona mung'ono. Vano ole onasogolela onakala woona ole oneemelela. ");
INSERT INTO tke_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ki oofuneya baani: di ole oli vameeza naari ole oneemelela? Kahuwo ole onaja vameeza? Mbwenye Miyo Gili vaari va nyo woona ole oneemelela. ");
INSERT INTO tke_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nyo muli alene munakalave ni Miyo moweehiwani mwaaga. ");
INSERT INTO tke_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Woona ababa egisakulele Omwene, Miyo Ginowusakulani; ");
INSERT INTO tke_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","wi muje, mung'we vameeza vaaga muMweneni mwaaga, muneere okaraati mwiittenguni, wi mwaathonge malogo kumi ni meenddi a Ezarayeli.” ");
INSERT INTO tke_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Teto Yesu ahiwogaga, wiira: “Simawu, Simawu, woone, Sathana ohuwaddihedha wi oveetteni woona tirigu. ");
INSERT INTO tke_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mbwenye Miyo Guhuulobelela wi nroromelo naawo nihithime. Wadha otthwaruwa, waalibihe addibilo.” ");
INSERT INTO tke_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mbwenye Peduru ahaakula, wiira: “Gili owimeleene odhowa ofugeliwa ni nyo, ofiyedha okwa.” ");
INSERT INTO tke_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mbwenye Yesu ahaakula, wiira: “Miyo Ginowuwaaddela Peduru, peeno veva, mutubi ahineebe ‘kokoliko,’ onogikoodda dila thaaru wiiraga wi kuginonile.” ");
INSERT INTO tke_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Vano, Yesu ahaakohaga anamasuuza aaye, wiira: “Voorumilimini voolenddoni Giiraga wi kamuthukule thumba na korowa, naari thumba na olenddo, naari sapatho; yahikalavo yohaleeleni?” Aliwa wiira: “Kanahaleeliwe yego.” ");
INSERT INTO tke_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Oliye wawaaddela, wiira: “Mbwenye dhiinova, winna thumba na korowa, athukule; ni thumba na voolenddoni; ole ohinna supadda, agulihe yowiikunelana yaaye wi agulena naaye. ");
INSERT INTO tke_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ginowuwaaddelani, enofuneya dhigipadduwele dhendo dhilebiwe: ‘Wi oliye oneere otaganyihedhiwa ni anameerana dhabure.’ Ebaribareene dhatedhene dhinawoga dha Miyo dhinofuneya dhaakwanelihiwe.” ");
INSERT INTO tke_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aliwa yahimwiirelaga: “Nabwiyani, nihikanna masupadda meenddi ala!” Waakula, wiira: “Baahi, ehaakwana.” ");
INSERT INTO tke_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Vano ahivenyaga odhowa oMwangoni wa Olivera, woona molemeelela, ni anamasuuza aaye vamohi. ");
INSERT INTO tke_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Egafiyile mburo, wasakuliwe, ahiiraga: “Lobelani, mulobaga wi munamorele moweehiwani.” ");
INSERT INTO tke_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ahisusaga vang'ono, olapelawa woona vinamorela nibwe muthu avoka, ahikokoraga, wambeela olobela. ");
INSERT INTO tke_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Alobelagave, ahiiraga: “Babani, mwafuna Girabeliheni nakoma a masoso ola; mbwenye ohiireye ofuna waaga, wiireye ofuna weenyu.” ");
INSERT INTO tke_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Vano mungero oodhulu ahimoneyela wi amulibihe mmurimani. ");
INSERT INTO tke_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu agali mmasosoni, oolobelagave ni kopolo. Nikurumela naaye naaligi woona mathotho a mwazi waddonddelaga vati. ");
INSERT INTO tke_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Agamalile olobela, ahivenyaga, owelawo omburoni waaligi anamasuuza; aafwanyilege egonaga, vowi okubanya weewa wahithabwaga. ");
INSERT INTO tke_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oliye wiira: “Munagonela ddi? Mvenye, mulobele wi munamorele moweehiwani!” ");
INSERT INTO tke_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu awogagave, yahifiyaga athu ajinjeene ni mmohi wa anamasuuza kumi ni abiili, eeriwa Zhuda, aaligi vasogolo. Ahisusedhaga vaaligi Yesu wi amulojele ni bezhu. ");
INSERT INTO tke_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu owoga ni oliye, wiira: “Zhuda, onafuna omugulihe Mwaana a Muthu ni ombezhari?” ");
INSERT INTO tke_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Vano anamasuuza a Yesu yamwapelelege vevale yoonaga dhafunaga opadduwa, yahimukohaga: “Nabwiya, munofuna naaporose ni masupadda eehu athu ala?” ");
INSERT INTO tke_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mmohi ahikumihaga supadda, omporosa mwiimeleli a mpogo a anamakutha. Ompadha nibaru na omoononi wooja. ");
INSERT INTO tke_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu waahiha, wiira: “Baahi! Iyani!” Oliye okahinya nibaru ovoliha. ");
INSERT INTO tke_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Vano Yesu ahiwogaga ni apogo a anamakutha, anamaang'anela a nyuba ya Mulugu ni makolo a mutugumano, yadhiilege wi emwihidde, wiira: “Nyo munadha ni masupadda, ni golomonddo wi mugihidde. Wiirege Gili mbava? ");
INSERT INTO tke_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Malabo mateene Gakala ni nyoovo nyuba ya Mulugu, mbwenye kamugihiddile. Mudhidhi ola bweenyu. Si kopolo dha mwipipini.” ");
INSERT INTO tke_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Vano egamwihiddile Yesu, yahimudhowana vade va mpogo a anamakutha. Peduru egi waahara voolapelavene. ");
INSERT INTO tke_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yahitubaanyaga muunddo vaari vattaddo egakaraatile ateene, Peduru ahifiyaga mburo olene, okeraati ni aliwa. ");
INSERT INTO tke_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mwiimeleli mmohi amwihiyana ahimoonaga Peduru vakaratiligiye vooneyelaga muundd. Omusugwesesa Peduru, wiira: “Mulobwana ola akala ni Oliyeene!” ");
INSERT INTO tke_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mbwenye Peduru okooddaga, eeraga: “Asaa! Mwihiyana we, miyo kagimunonile.” ");
INSERT INTO tke_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Vigavirile mudhidhi vang'onove, mwiimeleli mmohi agamoonile, ahiiraga: “Teto we oli mmohi mwa aliwa.” Peduru wiira: “Mulobwana we miyo kagili.” ");
INSERT INTO tke_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Vigavirile mudhidhi wowaakwana wora emohi, muthu mmohiya ahikalelaga ntidi, eeraga: “Ebaribareene ola aali ni Oliyeene, vowi muGalileya.” ");
INSERT INTO tke_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mbwenye Peduru ahikalelaga ntidi okoodda, eeraga: “Mulobwana we, miyo dhinawogiiwe, kaginonile!” Awogagave ndo, mutubi ahiibaga. ");
INSERT INTO tke_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nabwiya ahirugunuwaga, omusugwesa. Peduru wuubuwela madhu yamwaaddelile Nabwiya: “Owi peeno veva mutubi ahineebe, onogikoodda dila thaaru.” ");
INSERT INTO tke_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Vano Peduru ahivenyagavo, odhowa wuunddaga ni okubanya wulubale. ");
INSERT INTO tke_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Alobwana yamwaang'anelaga Yesu yoombeddaga emuddwadhaga. ");
INSERT INTO tke_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yoomukuneelaga meento, yiiraga: “Ovuhulele! Wuddwadhile baani?” ");
INSERT INTO tke_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yoomuwogelaga dhego dhijinjidhene emunyemulaga. ");
INSERT INTO tke_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ode ogasile bebeheene, makolo a mutugumano a mulogo wa Ezarayeli, apogo a anamakutha, ni ale yasuuziha malamulo yahitugumanaga, omuthukula Yesu omudhowana omuthegoni weewa. ");
INSERT INTO tke_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Omukohaga, yiiraga: “Akala oli Kirixtu, onaaddele.” Oliye wawaakula, eeraga: “Naari Guwaaddeleni, kamunarumeedha. ");
INSERT INTO tke_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Naari Guukohani, kamunagaakula yego. ");
INSERT INTO tke_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Okuma dhiinoveva munomoona Mwaana a Muthu agakaratile omoononi wooja wa Mulugu winna kopolo dhatedhene.” ");
INSERT INTO tke_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Athu ateene wiira: “We oli Mwaana a Mulugu?” Oliye waakula, eeraga: “Nyoovo dinawoga wi Gili.” ");
INSERT INTO tke_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yahiiraga: “Ki ninafunelege ddi onamoona? Vowi nihiiwa weekihu dha muwano mwaaye.” ");
INSERT INTO tke_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nikuru nateene nahivenyaga vamutugumanoni omwihisa Yesu, omudhowana wa Pilatu. ");
INSERT INTO tke_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Vano wewule yahambeelaga omusumela, yiiraga: “Muthu ola nimfwanyile aholosaga nlogo neehu. Ahihaga wi kipelekege musoko wa Sezari, onawoga wi Oliye di Kirixtu, mwene.” ");
INSERT INTO tke_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu ahimukohaga, wiira: “We oli mwene a aZhudewu?” Yesu ahimwaakula, wiira: “Onawoga di nyo.” ");
INSERT INTO tke_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Vano Pilatu ahawaaddela apogo a anamakutha ni anamwinji wiira: “Kagimfwanyilena muladdu.” ");
INSERT INTO tke_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mbwenye aliwa yahikalelaga ntidi, yiiraga: “Onowaadugurula athu asuuzihaga Zhudeya ateene; obaja oGalileya, ofiya wuno.” ");
INSERT INTO tke_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu ageewile nde, ahikohaga akala muthu ole aali muGalileya. ");
INSERT INTO tke_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aganonile wi mwene aaye di Heroddi, ahimusukumela wa Heroddi. Mudhidhi oyene, Heroddi akalaga oZheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroddi agamoonile Yesu, ahihagalala vajinjivene vowi ofunesesa omoona wambeela wale. Mooligana ni dhewiiye dhooliye, oojejihedha wi oneere wiirana ntikiniho. ");
INSERT INTO tke_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ahimukohaga mohiyana-hiyana, mbwenye Yesu kamwaakulilege yego. ");
INSERT INTO tke_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Apogo a anamakutha ni ale yasuuziha malamulo yaaligi vevale, yegi omusumela dhijinji. ");
INSERT INTO tke_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Vano Heroddi ni anyakoddo aaye yegi omvevusa embeddaga. Yahimuwarihaga yowara ya omwene, omuwelihedha wa Pilatu. ");
INSERT INTO tke_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nlabo nenddo Pilatu ni Heroddi, yahandanaga vowi wale yahiiddana. ");
INSERT INTO tke_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Vano Pilatu ahaatugumanyaga apogo a anamakutha ni asogoleli ni nlogo, ");
INSERT INTO tke_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","wawiirela: “Nyo munogidheelana muthu ola woona namaholosa nlogo. Gigamukohile vameentoni veenyu kagimfwanyilena muladdu omusumeleliinyu. ");
INSERT INTO tke_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Naari vang'onong'ono Heroddi, kamfwanyilena muladdu, wofwaneelela opiwa, bu mwahaya omuweliheliye wa hiyo.” ");
INSERT INTO tke_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Vano, miyo ginomuwaxuliha, gendo gimutapule. ");
INSERT INTO tke_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mudhidhi wa Paxkwa ahilemeelela omutapula oomagiwa mmohi. ");
INSERT INTO tke_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Anamwinji ateene yookuwaga: “Muumpe ola, mmutapule Baraba?” ");
INSERT INTO tke_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba ola afugeleliwe ni mwaha woovuruvuru muluwani teto ni ompa muthu.) ");
INSERT INTO tke_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu afunagave wi amutapule Yesu, ahikalelaga ntidi owoga ni aliwa. ");
INSERT INTO tke_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mbwenye aliwa yegi okuwa: “Mukomeleni! Mukomeleni vamuraddini!” ");
INSERT INTO tke_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Vano dila ya nethaaru ahaakohaga, eeraga: “Yabure wiiriliyena ddi? Ebaribareene kagimfwanyilena muladdu wofwaneelela okwa; ginomuwaxuliha, vano gendo gimutapule.” ");
INSERT INTO tke_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aliwa yoolibihedhaga okuwa vajinjivene, wi mukomeleni vamuraddini. Okuwa weewa wahambeela ogonjiha. ");
INSERT INTO tke_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatu orumeedha yooloba yeewa. ");
INSERT INTO tke_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Omutapula ole yamulobigiisu afugeleliwe mwaha woovuruvuru ni ompa muthu, vano ompeleka Yesu moofuna mweewa. ");
INSERT INTO tke_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Emudhowagana Yesu, yahimwihiddaga muSirine, eeriwa Simawu, akumaga mmavade, omuthukuliha muraddi veefuddi, wi amuharegena Yesu. ");
INSERT INTO tke_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yegi omuhara athu ajinjeene, a nlogo ni ahiyana yakukuthaga vathimarimani emunddelaga. ");
INSERT INTO tke_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mbwenye Yesu ahirugunuwaga, wiira: “Ahiyana oZheruzalemi kamugunddele Miyo; Mwiyunddele wekiinyu, vamohi ni aniinyu! ");
INSERT INTO tke_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vowi malabo enodha eneeriwege: ‘Oreelihiwa baale ehinabala, ehibalile, naari ehaamwihile!’ ");
INSERT INTO tke_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Malabo ayene enodha yambeele wiirela mwango: ‘Nibidhuwele hiyo!’ Vano, epathakala: ‘Nikuneele hiyo!’ ");
INSERT INTO tke_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ki akala muthanko mukiiti onowiiriwana ndo, wowuuma onadha wiiriwena havi?” ");
INSERT INTO tke_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yahithukuliwaga amohiwa abiili, yaaligi anameerana dhabure, vamohi ni Yesu wi yoonihiwe goyi yoopiwa. ");
INSERT INTO tke_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Egafiyile mburo weeriwa “Egarigadhi,” vevale yahakomelaga Oliye ni ale abiili, mmohi omoononi wooja, mmohi wung'otoni. ");
INSERT INTO tke_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Vano, Yesu ahiiraga: “Babani, aleveleleni, vowi kinonile dhineeriisu.” Yahombezelaga gari, voogawana dhoowara dhaaye. ");
INSERT INTO tke_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nlogo naaligi vevale negi, woona dhateene. Apogo yegi ombedda, yiiraga: “Mowaavulumusa amohi wiivulumuse weeka, akala ebaribareene oli Kirixtu, oosakuliwa a Mulugu.” ");
INSERT INTO tke_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Teto anyakoddo yoomunyemulaga, yahimwaaddamelaga wi emvahe vinyu onyuunya, yahiiraga: ");
INSERT INTO tke_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Akala We oli mwene a aZhudewu wiivulumuse weeka.” ");
INSERT INTO tke_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Vadhulu vamuraddi vahilebiwa: OLA DI MWENE A AZHUDEWU. ");
INSERT INTO tke_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mmohi wa anameera dhabure yakomeliwigiyena oomunyemulaga Oliye, eeraga: “We kuli Kirixtu? Wiivulumuse weeka, vamohi ni hiyoya.” ");
INSERT INTO tke_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mmohiya ahimwaakulaga, omusumulula, wiira: “Hiyo nigali othongiwa vamohi ni Oliye, we kunamoova Mulugu? ");
INSERT INTO tke_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hiyo nihifwaneelela orabula mwaha wi nnalivela dhabure dheerihu. Vano ola keerile yego yabure.” ");
INSERT INTO tke_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ahenjedhedhaga, eeraga: “Yesu, Mwaguubuwele, Mwavolowa mumweneni mweenyu.” ");
INSERT INTO tke_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ahimwaakula, wiira: “Ebaribareene, Ginowuwaaddela peeno veva onakala vamohi ni Miyo mburo wohagalala.” ");
INSERT INTO tke_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mudhidhi wa kumi na biili waaddamelaga, nduwa nahithimaga, elabo yateene yahikalaga yiihi, ofiyedha mudhidhi wa nethaaru wa ciguwo. ");
INSERT INTO tke_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Guwo yagawa nyuba ya Mulugu, yahitaleyaga vaari ni vaari, ng'eee! ");
INSERT INTO tke_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu ahikuwaga ni ndhu notaama, eeraga: “Babani, Ginopeleka mmadadani mweenyu muneba waaga.” Nuuwoga madhu ala, okwa. ");
INSERT INTO tke_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mpogo anyakoddo a aRoma aaligi vevale vowoona nde, ahimutamalaga Mulugu, eeraga: “Ebaribareene, muthu ola aali ooharihamo.” ");
INSERT INTO tke_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Muthithi wagumanilege woonelaga dhowiireya nde, wahivenyagavo nuwikubanyiha ekukuthaga vathimarimani veewa. ");
INSERT INTO tke_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vano ale yamunonilege Yesu, vamohi ni ahiyana yamuharaga okumela oGalileya, yahikalagave voolapela vene yoonelaga dhowiireya nde. ");
INSERT INTO tke_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ahikalawo mulobwana mmohi, eeriwa Zhuuze. Aali muthu apama, ooharihamo, mmohi a anamathonga a aZhudewu. ");
INSERT INTO tke_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kadhiveliwena dheerile nikuru ndde. Aali mukadda Arimateya mudhi mulubale wo Zhudeya. Oojejihedha Omwene wa Mulugu. ");
INSERT INTO tke_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ahidhowa wa Pilatu, omuloba muruthu wa Yesu. ");
INSERT INTO tke_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ovenyihavo vamuraddini, ohuruwedha ni guwo ya musawo wa linyu. Ohela munsiyeni natopiwe vanibweni woona nikungu. Nsiye ndde mwaali muhunaheliwege muruthu. ");
INSERT INTO tke_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naaligi nlabo noosasanyedha, omambeelelo wa Sabuddu. ");
INSERT INTO tke_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ahiyana yakumilege oGalileya ni Yesu, yahidhowaga woona nsiye ni ovitiwa wa muruthu wa Yesu. ");
INSERT INTO tke_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yahivenyaga, odhowa osasanyedha dhoonukwela ni makura. Nlabo na Sabuddu yahivumaga, mooligana mwa malamulo. ");
INSERT INTO tke_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nlabo nowambeela na sumaana ebembe mbee, ahiyana yahidhowaga onsiyeni. Yahithukulaga dhoonukwela dhasasanyedhigiisu. ");
INSERT INTO tke_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yafwanyilege nibwe nigapigirisiwe vansiyeni. ");
INSERT INTO tke_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Egavolowilemo, kayafwanyilegemo muruthu wa Nabwiya Yesu. ");
INSERT INTO tke_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aliwa kayanonaga dhafunigiisu wiira, yahisimwelaga. Yubuwelagave, yahikumelelaga alobwana abiili, dhoowara dheewa dhegi ozherimela. ");
INSERT INTO tke_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ahiyana ale yahikannaga woova. Yahiworomihedhaga kove vati. Alobwana ale yahawaaddelaga, wiira: “Munamusayelela ddi mugumi vaari va anookwa? ");
INSERT INTO tke_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Oliye mu kalimo! Ohuvenyihiwa! Mubuwelele madhu yowogiliyenani mukalaga oGalileya. ");
INSERT INTO tke_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yeeriliye Mwaana a Muthu oneere opelekiwa mmadadani mwa athu othega, akomeliwe vamuraddini, nlabo na nethaaru avenyihiwe.” ");
INSERT INTO tke_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Vano, yahuubuwelela madhu aaye. ");
INSERT INTO tke_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Egawelilewo onsiyeni, yahisorihaga dhego dhatedhene wa anamasuuza kumi ni mmohi ni wa ale ateene yaaligi ni aliwa. ");
INSERT INTO tke_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ahiyana ala aaligi Mariya Madalina, ni Zhuwana, ni Mariya amaaye a Tiyago, teto ni ahiyana amohi yaaligi ni aliwa yahisorihaga dhego dhatedhene wa arumiwi. ");
INSERT INTO tke_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Madhu ala yaali woona ebeweene, aliwa kayarumeedhilege ahiyana ale. ");
INSERT INTO tke_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mbwenye Peduru ovenya othamagela onsiyeni agafiyile ahiturumelagamo oonilege guwoove baahi dha linyu. Peduru ahiwelelaga vade vaaye otikiniheya mwaha wa dhende dheereyile. ");
INSERT INTO tke_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nlabo nimohive nenddo anamasuuza abiili yaharaga dila ya murudda mung'onong'ono weeriwa Emawu; olapelanawa waali makilometuru kumi na mmohi, ofiya oZheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yegi othapanyedha dhego dhatedhene dheereyile. ");
INSERT INTO tke_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ethapanyagave, Yesu mwiinyene ahawaaddamelaga, othaananaga ni aliwa. ");
INSERT INTO tke_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Meento eewa yahithitheyaga, kayamudidelilege. ");
INSERT INTO tke_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu ahaawogagana, wiira: “Yego ddi yukathamihileni enathapanyedhiinyu mweeddaga?” Aliwa wiimela, ni okubanya. ");
INSERT INTO tke_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Namasuuza mmohi eeriwa Kelopa ahaakulaga, eeraga: “We oli muleddo oZheruzalemi wuno onatikina dhiireyile malabo alena evirile?” ");
INSERT INTO tke_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Oliye ahaakohaga aliwa: “Epadduwile ddi?” Vano, yahimwaaddelagamo dhende: “Dhampadduwele Yesu muNazareti. Oyene aali mulobwana namavuhulela owodha mmabasani ni mmadhuni vameentoni va Mulugu ni vameentoni va athu ateene. ");
INSERT INTO tke_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Vano, woona apogo a anamakutha ni asogoleli eehu yahimpeleka wi akoniwe ni opiwa ni omukomela vamuraddini. ");
INSERT INTO tke_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mbwenye hiyo noojejihedha wi aakale oliyeene oobole nlogo na Ezarayeli teto mwa dhatedhene, ala malabo maraaru dhego nda dhipadduwiwa. ");
INSERT INTO tke_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mbwenye teto ahiyana amohiwa yaali ni hiyo ehintikiniha voomaruwa njijiji nomaselo edhowaga onsiyeni. ");
INSERT INTO tke_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Vano kifwanyilemo muruthu wa Yesu. Owelawo, yiiraga: ‘Nihifwanyiwa maroho a angero, ayene esorihile wi Oliye mugumi.’ ");
INSERT INTO tke_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ebaribareene, amohiwa a mwa hiyo yahidhowa onsiyeni, woona ebaribariya dhawogile ahiyana ale mbwenye kiyamoonile.” ");
INSERT INTO tke_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu ahiwoga, wiira: “Nyo muli woona oolodhowa onyemela mirima, wi muroromele ni orumeedha dhiwogile anamavuhulela! ");
INSERT INTO tke_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kamunonile wi yaali yoofuneya Kirixtu oonihiwe goyi, avolowe munthithimihoni naaye?” ");
INSERT INTO tke_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Vevale ahambeela waatapulela dhilebiwe dha Oliye mmalebani mateene wambeela niivuru na Mozezi ofiyedha mmaniivuru a anamavuhulela ateene. ");
INSERT INTO tke_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yaaddamelaga murudda wadhowigiisu, Yesu eeddaga woona onafuna akwaranye. ");
INSERT INTO tke_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mbwenye aliwa yaiiraga: “Kamukwaranye vowi ohuriba. Nduwa nihidhowa.” Oliye ovolowa okala ni aliwa. ");
INSERT INTO tke_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Egakaratile vameeza, ahithukulaga mukaathe, otamala, opadhula, waagawela. ");
INSERT INTO tke_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mowaaguva meento eewa yahifuguwaga, omudidela wi di Yesu, ahinanelaga vameentoni veewa. ");
INSERT INTO tke_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yegi owoga, mmohi ni mukwaaye yiiraga: “Mirima dheehu, kadhathamaga awogiye mundila antapulelaga Maleba, kahi ndo?” ");
INSERT INTO tke_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mudhidhi mmohive olene, yahimaruwaga, owelela oZheruzalemi. Waafwanya arumiwi kumi ni mmohi egatugumane ni amohiwa. ");
INSERT INTO tke_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yahawaaddelaga, wiira: “Ebaribareene, Nabwiya ohuvenyihiwa ohukumelela wa Simawu.” ");
INSERT INTO tke_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Vano alobwana abiili ale, yahisorihaga dhawiireyele mundila, voomudidela ni vopadhula mukaathe ni wagawela. ");
INSERT INTO tke_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ewogagave dhego nda, Yesu ahikumelelaga vaari veewa, wiira: “Murenddele okale ni nyo.” ");
INSERT INTO tke_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aliwa yahirurumuwaga ni woova, yeesaga enoona ntowa. ");
INSERT INTO tke_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Oliye waakoha, wiira: “Mukalele ddi owukuuwa ni wanganyedha mmirimani? ");
INSERT INTO tke_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Moone madada aaga, ni manyalo aaga. Di Miyeene. Mugaababele, mugoone. Vowi ntowa kannakanna mwiili, naari makuva, munagoneliinyu Miyo Gihikanna.” ");
INSERT INTO tke_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Awogagave nda, ahaawonihaga madada ni manyalo. ");
INSERT INTO tke_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Vano, aliwa kayarumeedhile, mwaha wohagalala ni otikina, Yesu ahiiraga: “Muhukannavo yooja?” ");
INSERT INTO tke_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nuwindo, yahimvahaga epaddi ya somba yowoosa ni nikandda na nwii. ");
INSERT INTO tke_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Waakela oja vameentoni veewa. ");
INSERT INTO tke_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nuwindo, wiira: “Miyo, ngalive ni nyo Gahiwoga wi; dhineere dhaakwanele dhatedhene dhilebiwe dhodheela wa Miyo mmalamuloni a Mozezi, mmaniivuru a anamavuhulela, ni mMasaalimuni.” ");
INSERT INTO tke_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Vano, Yesu ahaafugulaga moobuwelelo eewa wi yiwelelemo Maleba Otaleleya. ");
INSERT INTO tke_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wawaaddela, wiira: “Dhilebiwe sowi; Kirixtu oneere orabulihiwa, ni ovenyihiwa muukwani nlabo na nethaaru. ");
INSERT INTO tke_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wi mwa ndina naaye, nlaleyeliwe wi athu etthwaruwe mwa dhoothega dheewa wi eleveleliwe. Nda, dhineere dhilaleyeliwe milogo dhatedhene wambeela oZheruzalemi. ");
INSERT INTO tke_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nyo muli anamoona a dhego nda. ");
INSERT INTO tke_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Moone, Miyo Ginowurumihedhani nroromeliho na aBaba; mukalegeve muluwani mwemuno ofiyedha muwarihiwe kopolo dhodheela odhulu.” ");
INSERT INTO tke_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nuwindo, Yesu ahasogolela okuma muluwani mule, odhowa oBetaniya. Ahathukulela madada wareeliha. ");
INSERT INTO tke_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Areelihagave, yahimwalanaga, othukuliwa odhowaga odhulu. ");
INSERT INTO tke_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Egamwebedhile, yahiwelelaga oZheruzalemi ni ohagalala wulubale. ");
INSERT INTO tke_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yookalave nyuba ya Mulugu, emutamalaga Mulugu. ");
ALTER TABLE tke_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
