﻿USE sofia;
DROP TABLE IF EXISTS sofia.tiy_vpl;
CREATE TABLE tiy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tiy_vpl WRITE;
INSERT INTO tiy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ay niy de dawét i de katufua Jesu Kristo, sani ségétéwe séfu Datu Dabide séfu Abraham. ");
INSERT INTO tiy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","I Abrahamey boh Isake. Atin i Isakey boh Jakobe. Atin i Jakobey boh Judahe brab de dumo no sétiman boh. ");
INSERT INTO tiy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Atin i Judahey boh Farese brab Sarawe. (Tamar i idéng ruwe.) Atin i Faresey boh Esrome. Atin i Esromey boh Rame. ");
INSERT INTO tiy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Atin i Ramey boh Aminadabe. Atin i Aminadabey boh Nasone. Atin i Nasoney boh Salmone. ");
INSERT INTO tiy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Atin i Salmoney boh Boose. (Rahab i idéng ne.) Atin i Boosey boh Obede. (Rut i idéng ne.) Atin i Obedey boh Jesewe. ");
INSERT INTO tiy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Atin i Jesewey boh Datu Dabide. Atin i Dabidey boh Solomone. (I idéng ne been i bawag Uriase bé do gétah.) ");
INSERT INTO tiy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Atin i Solomoney boh Roboame. Atin i Roboamey boh Abiase. Atin Abias i boh Asawe. ");
INSERT INTO tiy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Atin i Asawey boh Josefate. Atin i Josefatey boh Jorame. Atin i Joramey boh Osiase. ");
INSERT INTO tiy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Atin i Osiasey boh Jotame. Atin i Jotamey boh Akase. Atin i Akasey boh Esekayawe. ");
INSERT INTO tiy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Atin i Esekayawey boh Manasese. Atin i Manasesey boh Amone. Atin i Amoney boh Josiase. ");
INSERT INTO tiy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Atin i Josiasey boh Jekoniase brab de dumo no sétiman boh. Kéluhana ro mén-uwit mangéy dob mérayue ingéd féndawét Babilonia amun ténabanan i karowe ingéd bé girawe. ");
INSERT INTO tiy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Amun diyo ron bati dob Babilonia, i Jekoniase wén i ngaén féndawét Salatiel. Atin i Salatieley boh Sorobabele. ");
INSERT INTO tiy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Atin i Sorobabeley boh Abiude. Atin i Abiudey boh Eliakime. Atin i Eliakimey boh Asore. ");
INSERT INTO tiy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Atin i Asorey boh Sadoke. Atin i Sadokey boh Akime. Atin i Akimey boh Eliude. ");
INSERT INTO tiy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Atin i Eliudey boh Eleasare. Atin i Eleasarey boh Matane. Atin i Mataney boh Jakobe. ");
INSERT INTO tiy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Atin i Jakobey boh Josehe, sani bawag Mariahe. Atin i Mariawey idéng Jesuse féndawét Kristo non Been i fénémili i Tuluse méguléw. ");
INSERT INTO tiy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mélaw folo bra fot gékansad i de katufuan tidéw dob Abrahame taman dob Dabide. Atin tidéw dob Dabide taman dob gaiwe mén-uwit i de Judio mangéy Babilonia folo bra fot so gékansad i de katufuan. Atin tidéw béno taman bé kéumah Kristowe folo bra fot so gékansad i de katufuan. ");
INSERT INTO tiy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ay ni urete fantag bé kéumah Jesu Kristowe. I idéng ne Maria. Atin i Mariahe ténlaana nén fébawagén dob ségétéwe lagéy féndawét Jose. Endob amun énda séna sébawag ro de, ménwaléy obor i Mariahe non fénobor i Rémogor i Tuluse. Enggétiga Mariahey ni. ");
INSERT INTO tiy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Atin i Josehe, métintu étéw, mélaw ménika sébawag bé Mariahe non oborén. Endob fiyo étéw i Josehe, mélaw mika de ké kémalanan i Mariahe. Mélaw ménuyot i Josehe de ké sérontos bé Mariahe sékémén saén. ");
INSERT INTO tiy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dob lala Josehe mégitung fantag bé de ni, méntéfégitoy télakiwe tidéw dob Kadnane dob téginéf ne. Ménbéréh i télakiwe ni mano, “O Jose, séfu Datu Dabid, kago magalang-galang mawag bé Mariahe, non i funa nuwe mén-obor sabaf bé barakat i Rémogor i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mégénga moso i Mariahe ségétéw nga lagéy. Atin fédawétém Jesus, non Been i mémukase bé de étéwén dob de sala ro.” Been i bénréh i télakiwe. ");
INSERT INTO tiy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","I funane ménrigoy kéluhanay de ni inok métuman i fénbéréh i Kadnane bé sénarigo nuwe étéw mano, ");
INSERT INTO tiy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“I kénogone waléy obor, brab mégénga nga lagéy, atin fédawétén Emanuel.” (I atag i dawéte Emanuel “Bati i Tuluse dob betome.”) ");
INSERT INTO tiy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tidéw béno, énggétékénal i Josehe, atin nunuro noy fémandu i télakiwe de, mélaw bénawagén i Mariahe. ");
INSERT INTO tiy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Endob énda ménsétifon ro fidong taman énda séna mumah i nga ne. Brab amun ménumahén, féndawétén Jesus. ");
INSERT INTO tiy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","I Jesuse ménumah dob ingéde féndawét Betlehem dob sakuf i dakéle ingéd féndawét Judea, amun Herod sénay méguléwe de. Atin énda mérugayén tidéw bé kéumah Jesuse, wén i de gétuwan do étéw tidéw dob mérayue ingéd dob sébangan ménagéw ro mangéy dob ingéde Jerusalem. I de ni do lagéy furung gésobut bé de tanda dob de gitoon. ");
INSERT INTO tiy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Atin amun énggumah ro dob Jerusalem, ménénginsa ro maro, “Hon i gonoy Ngae, sani waléye moso Datu i de Judio? Non énggito gey i gitoone dob sébangan tanda i kéumah ne. Atin mélaw angéyé key féngadafén.” ");
INSERT INTO tiy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Atin i Herode méguléw, amun énggélingoo noy fantage bé ni ségiyo datu, toow fo ménbuku, brab beroy de kéluhanay de étéw bati dob Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mélaw lénimud Herodey kéluhanay de odoroy de fadi brab de témoro bé kitab i de Judio, atin ménénginsa dob berowe mano, “Hon i gonoy umaha Kristowe de, sani fénémili i Tuluse méguléw?” ");
INSERT INTO tiy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Atin séménumbul ro maro, “Fatut mumah i Kristowe dob ingéde Betlehem dob sakuf i dakéle ni ingéd Judea. Non been i niy sénulat i sénarigoy Tuluse muret bé kébéréh ne mano, ");
INSERT INTO tiy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘I beeme, o Betlehem, dob dakéle ingéd Judawe, tintu békén go toow na fo gérifantad bé kéluhanay de ingéd dob Juda. Non tidéw dob beeme moso i odorone méguléw bé de étéw gu do Judio.’” ");
INSERT INTO tiy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tidéw béno, féntawag Herodey de ni gétuwan do étéw tidéw dob sébangan mangéy sélimud dob beene énda i ségiyo étéw de gétigan. Atin fénénginsaa no bero ké ati tintuwe gai énggito roy gitoone ni. Amun énggétiga Herode, ");
INSERT INTO tiy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","sénuguén bero mangéy Betlehem mano, “Agéw gom, toow gom fo séléd i Ngao no. Atin buluk gito gom, fégétiga kom begén inok angéyé ku so féngadafén.” ");
INSERT INTO tiy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Tidéw béno, amun énggélingoo roy bénréh Datu Herode, ménagéw ro. Atin énggito ro man i gitoone ni, sani gitoone so énggito ro dob sébangane bé gétahe. Toow ro fo ménoror amun énggito ro. Atin i gitoone ni ménagéw métah bero taman téménrén dob gatagay gonoy Ngae ni. Atin ménfuray ro bé gitoone ni taman dob no lawi. ");
INSERT INTO tiy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Amun énggumah ro diyo, ménahur ro brab énggito roy Ngae ni brab Mariahe idéngén. Atin ménlingkuwéd ro dob adafay Ngae ni méngadaf de. Tidéw béno, bénungkal roy de balilaga tamuk nuwit ro do bélowon, do dukah, brab do fégéféamut féndawét mira. Atin niray ro dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tidéw béno, i Tuluse féningatén bero dob téginéf ruwe bé békénén séfule ro mangéy dob Datu Herode. Mélaw ménule ro mangéy dob karowe ingéd dob ségiyowe aguwon. ");
INSERT INTO tiy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Amun ménagéw i de ni gétuwan do étéw, méntéfégitoy télakiy Kadnane dob Josehe dob téginéf ne. Atin bénréhén dob Josehe mano, “Tek go, brab uwitém i Ngae brab idéng ne méraréy mangéy dob ingéde Egipto. Atin bati gom diyo taman béréhé ku beem ké fakay gomén mule. Non i Datu Herode sélédé noy Ngae ni inok féléhué no.” ");
INSERT INTO tiy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mélaw méntek i Josehe fiyon fo ké kérara kélungonon, atin nuwitén i Ngae ni brab idéng ne mangéy Egipto. ");
INSERT INTO tiy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Atin ménbati ro diyo taman bé kéléhu Herode. Ménrigoy ni inok métuman i fénbéréh i Kadnane bé sénarigo nuwe mano, “Ténawag guy Nga guwe inok mésut tidéw Egipto.” ");
INSERT INTO tiy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Endob i Herode, amun énggétiga noy fénggakaray de gétuwan do étéw tidéw sébangan, toow fo ménkérit. Mélaw sénuguén i de sundalo mangéy Betlehem brab dob de ingéd géliwét de, inok féléhué roy kéluhanay de nga lagéy tidéw ruwo gébélintuwa i idad ne mangéy fantad. I Herode énggétiga noy idad i Ngae ni sabaf bé kébéréh i de gétuwan do étéw bé gaiwe ménsut i gitoono no. ");
INSERT INTO tiy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mélaw méntuman i ménrugayén kébéréh i ségétéwe sénarigoy Tuluse muret bé kébéréh ne féndawét Jeremias mano, ");
INSERT INTO tiy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wén i émbéréhe énggélingoon dob ingéde Rama, kémérew brab rémuung. Non kémérew i Rakele sabaf bé de ngaén. Enda i géféoror de non i kéluhanay de ngaén ménléhu.” ");
INSERT INTO tiy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Amun ménléhu i Datu Herode, i télakiy Kadnane méntéfégito dob Josehe dob Egipto dob téginéf ne. ");
INSERT INTO tiy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Atin ménbéréh i télakiwe ni mano, “Tek go brab uwitém i Ngae ni brab idéng ne mule mangéy dob ingéde Israel. Non ménléhuén i de méméléhu damén bé Ngae ni.” ");
INSERT INTO tiy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mélaw méntek i Josehe atin nuwitén i Ngae brab idéng ne mule mangéy Israel. ");
INSERT INTO tiy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Endob énda ménbati ro dob Judea non ménggilak i Josehe non énggélingoo noy Arkelaowe ménwaléy méguléw amun ménléhu i boh ne Datu Herod. Atin féningatén man i Josehe dob téginéf ne, mélaw méntaus ro mangéy dob sakuf i dakéle ingéd féndawét Galilea. ");
INSERT INTO tiy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Atin ménbati ro diyo dob ingéde féndawét Nasaret. Mélaw méntuman i ménrugayén kébéréh i de sénarigoy Tuluse muret bé kébéréh ne maro, “Fédawétén i Kristowe ‘ségétéw tidéw dob Nasaret.’” ");
INSERT INTO tiy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bé no do gai, amun ménifus i firoye gébélintuwa, i Juan Bautistawe énggumah dob gonone énda i étéw de bati dob sakuf i dakéle ingéd Judea. Atin nuretén mano, ");
INSERT INTO tiy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kailanga kom gésénule bé de sala gom brab témagak bé de tete adat gom non gédétén gumah i gaiwe méguléw i Tuluse dob de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","I Juane ni, been i bénréh i méntélatae sénarigoy Tuluse muret bé kébéréh ne féndawét Isaias mano, “Wén i ségétéwe mékes dob gonone énda i étéw de bati mano, ‘Tafay gom i aguwoy Kadnane. Fééntang gom i aguwo nuwe.’” ");
INSERT INTO tiy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Atin kéménégal i Juane nawél buk dakél binatang féndawét kameliyo, brab kulit binatang i légét ne. Atin i amaé nuwe kasuk brab téné. ");
INSERT INTO tiy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Atin ménangéy dob beeney médoowe do étéw tidéw Jerusalem, brab tidéw dob kéluhanay de ingéd sakuf Judeawe, brab de étéw bati dob de ingéd gédét dob wayége Jordan. ");
INSERT INTO tiy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Atin amun fénayag roy de sala ro, bénautis Juane bero dob wayége Jordan. ");
INSERT INTO tiy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Atin médoo soy de Fariseo brab de Saduseo ménangéy dob Juane inok fébautis ro. Endob amun énggito no bero, ménbéréh i Juane mano, “I begome maak do ulé gom non tete i de rigoné kom. Sedek mangéy gom dini? Enda géféraréy gom tidéw dob kékukum i Tuluse moso ké fébautis gom saén. ");
INSERT INTO tiy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Buluk toow gomén gésénule bé de sala gom brab ténagak gom i de tete adat gom, féténgténg gom i kégésénule gome bé de fiyo ula-ulané kom. ");
INSERT INTO tiy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Atin kagom fégitungén de ké i Tuluse fukasé no begom dob de sala gom sabaf bé begom i de séfu Abraham. Béréhé ku begom, fakay géféwaléyoy Tuluse séfu Abrahamey de batéw ni. ");
INSERT INTO tiy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Béleewe ni, gédétén i kékukum i Tuluse bé de tete étéw. Ségiléw bé falakule méntafayén ménténa dob darir i kayéwe inok i de kayéw énda mégonok ro fiyo, tuwongén atin ibérén dob aféye inok métuwég. ");
INSERT INTO tiy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","I begéne, bautiso ku begom bé wayége inok fégito gom énggésénule gom bé de sala gom. Endob wén nay gégumah gétundug begén brab bautisé no begom bé Rémogor i Tuluse brab aféye. Toow na fo gérotor bé begéne. Fiyon foy safatos ne, énda médaitu de mibit. ");
INSERT INTO tiy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Féganané noy de fiyo étéw bé de tete étéw ségiléw bé ségétéwe métof. I fégéétof ne diyo dob kémér ne inok fégéétofén bé énrek ne brab fégétimuén bé faréye dob kiwot ne. I de ukofén tuwégé no dob aféye énda émfandaén.” ");
INSERT INTO tiy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bé no do gai, ménagéw i Jesuse tidéw Galilea mangéy dob wayége ni Jordan. Atin ménfégédét dob Juane inok fébautis de. ");
INSERT INTO tiy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Endob géléé Juane damén mano, “Begéney fatute bautiso mo, sedek Beem uman i mangéy fébautis begén?” ");
INSERT INTO tiy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Endob séménumbul i Jesuse mano, “Fédayaém saén béleewe ni. Non fatut rigoné toy kéluhanay kétayay Tuluse.” Mélaw ménagayun i Juane. ");
INSERT INTO tiy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Atin amun ménbautisén i Jesuse, géménaun tidéw dob wayége. Sonom béno, ménungka i lawayo, brab énggito noy Rémogor i Tuluse ménlus maak marafati brab méntérimféna dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Atin wén i ménbéréhe tidéw dob lawayo mano, “Been i niy Nga guwe. Toow fo kégédawa ku brab tintu késuwata ku.” ");
INSERT INTO tiy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tidéw béno, i Rémogor i Tuluse fénanangguwitén i Jesuse mangéy dob gonone énda i étéw de bati, inok i odoroy de saitan féndawét Satanas géténgkada noy Jesuse rémigo tete. ");
INSERT INTO tiy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Atin amun diyo i Jesuse, énda ménamaén bé rugay i ménfote folo gétérésangan. Mélaw toow fo ménlayaf. ");
INSERT INTO tiy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Atin énggumah i Satanase dob Beene brab ménbéréh mano, “Amuk Beemey Nga i Tuluse, féwaléyém amaén i de batéw ni.” ");
INSERT INTO tiy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Endob séménumbul i Jesuse mano, “Wén i Ménsulate Kébéréh i Tuluse mano, ‘Békén amaén saén i funay étéwe méuyag. Yamula kailangay étéwey kéluhanay kébéréh i Tuluse.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tidéw béno, nuwit Satanasey Jesuse mangéy dob Jerusalem brab nuwitén mangéy dob toowe fo gérotor bérungoy lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Atin ménsébéréh man bé Jesuse mano, “Amuk Beemey Nga i Tuluse, antéfor go. Non wén i Ménsulate Kébéréh i Tuluse mano, ‘Suguéy Tulusey de télaki no démiyaga Beem. Brab sakémé ro Beem inok énda émfali go bé de batéw, fiyon i de sékéyém.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tidéw béno, séménumbul i Jesuse mano, “Endob wén soy Ménsulate Kébéréh i Tuluse mano, ‘Kago téngkadén i Kadnane Tulusém rémigo bé kétaya muwe rigonén.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tidéw béno, nuwit Satanasey Jesuse mangéy dob uruk i gérotore fo tuduk. Brab fénténgténgén dey kéluhanay de ingéd dob duniyae ni brab kéluhanay de ungangéy de ni. ");
INSERT INTO tiy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Atin ménbéréh man i Satanase mano, “Buluk lingkuwédo mo begén brab féngadafé mo begén, iray gu Beem i kéluhanay de ni.” ");
INSERT INTO tiy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Endob séménumbul i Jesuse mano, “Féraréy gon Satanas! Enda féngadafé ku beem non wén i Ménsulate Kébéréh i Tuluse mano, ‘Lingkuwéd go saén dob adafay Kadnane Tulusém. Been saén i féngadafé muwe.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tidéw béno, i Satanase ténagakén i Jesuse. Atin énggumah i de télaki brab ténalima roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Atin i Herode fénféférisu noy Juan Bautistawe. Atin amun énggélingoo Jesuse, ménule mangéy Galilea. ");
INSERT INTO tiy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Atin téménara saén dob ingéd ne Nasaret, brab ménangéy bati dob Kafernaum dob fédoror i dogote Galilea, fingé dob ingéde Sabuton brab Neftali. ");
INSERT INTO tiy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ménrigoy ni inok métuman i kébéréh i sénarigoy Tuluse féndawét Isaias mano, ");
INSERT INTO tiy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“I de étéw bati dob de ingéd Sabuton brab Neftali, brab fingé dob dogote, brab dob difar i wayége Jordan, brab de étéw békén Judio bati dob Galilea, ");
INSERT INTO tiy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","fiyon fo ké i de ni étéw maak bati ro dob délémone non békén ro do méngintulus, gégito ro dakél solo. Atin fiyon fo ké maak kélungonon dob berowe non mégilak ro bé kéléhue, réméndaw i soloe ni dob berowe.” ");
INSERT INTO tiy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Atin tidéw bé no gai, féngganaya Jesusey kéuret ne mano, “Fatut gésénule gom bé de sala gom brab tagak gom i de tete adat gom, non gédétén i gaiwe féguléwoy Tulusey de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wén i no sébaan fuweh, ménagéw i Jesuse dob doror i dogote Galilea. Atin bé lala ne magéw, énggito noy ruwowe gétéw lagéy sétiman idéng. I dawét ruwe Andres brab Simon (féndawét so Pedro). Nibér roy biyala ruwe dob dogote non fatatugés ro. ");
INSERT INTO tiy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ménbéréh i Jesuse dob berowe mano, “Enggomén, odor gom Begén, atin kagomén séméléd sédo. Tidéw béleewe ni, fésélédé ku begom étéw, inok modor ro so Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sonom béno, ténagak roy de biyala ro atin ménodor ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bé lala ruwe magéw, énggito Jesusey de ségiyo lagéy do sétiman idéng. I dawét ruwe Santiago brab Juan. Diyo ro dob awang ruwe beroy boh ruwe féndawét Sebedeo. Fégimué roy biyala ruwe. Atin ténabar Jesuse bero. ");
INSERT INTO tiy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Atin sonom béno, ténagak roy boh ruwe dob awange atin ménodor ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Atin i Jesuse séménugud mangéy dob kéluhanay de ingéd dob Galilea. Atin téménoro dob de lawi féngadafan kay de Judio, brab nuretén i Fiyowe Uret fantag bé kéféguléw i Tuluse, brab nuwaén i de déméruun do séségiyo-giyo do déruun. ");
INSERT INTO tiy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Atin, ménsélalag i bantuga Jesuse dob kéluhanay de ingéd dob Siria. Mélaw i de étéw nuwit ro mangéy dob Beeney kéluhanay de déméruun bé séségiyo-giyowe do déruun, do démawét, brab do rénahuko saitan, brab do rebengén, brab do kimoyén. Atin énggéféadi-adino Jesuse bero kéluhanan. ");
INSERT INTO tiy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Atin toow fo médooy de étéw ménfuray bé Jesuse, do tidéw Galilea, brab do tidéw Dekapolis (i atag i Dekapolise “Do Folo Ingéd”), brab tidéw Jerusalem, brab tidéw Judea, brab tidéw dob difar i wayége Jordan. ");
INSERT INTO tiy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Atin i Jesuse amun énggito noy médoowe do étéw ménlimud, ménénagé mangéy dob burure, atin ménsar diyo. Atin i de kuyugén ménfégédét ro dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Atin ténoro Jesuse bero mano, ");
INSERT INTO tiy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Moror i de étéw gétiga ro énda gérigo ro fiyo saliyu ké tabangay Tuluse bero, non féguléwoy Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Moror i de étéw rémuung, non i Tuluse féfiyoné noy de fédéw ro. ");
INSERT INTO tiy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Moror i de térifantad étéw non gédoté roy ati fénasad i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Moror i de étéw toow fo méuyot ro rémigo bé kétayay Tuluse, non tabangay Tuluse de bero inok gérigono ro. ");
INSERT INTO tiy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Moror i de étéw mégédaw bé de ségiyo étéw, non mégédaw i Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Moror i de étéw malinis i de fédéw ro dob adafay Tuluse, non gito roy Tuluse moso. ");
INSERT INTO tiy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Moror i de étéw do gémélé bé de sétiboh étéw, non fédawétén ro do nga i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Moror i de étéw férasayén sabaf bé kétintuy adat ruwe dob adafay Tuluse, non féguléwoy Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Moror gom ké féngirasén gom brab férasayén gom brab béréhon gom tete bé kéluhanay tugie sabaf bé kéunur gome Begén. ");
INSERT INTO tiy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Féguyaya gom bé no gai gégumah, non i baras gome toow fo médoo diyo dob lawayo. Non loo so bé niy kéférasay i de étéw bé do énggétah do sénarigoy Tuluse muret bé kébéréh ne.” ");
INSERT INTO tiy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Atin féntaus Jesusey kétoro ne mano, “I begome ségiléw gom bé timuse lénawék dob amaéne inok fiyoy nonom ne. Non sabaf bé begome, waléy fiyoy de étéw dob duniyae ni. Endob amuk mékédan i kétasik i timuse, éndaén géséfule i kétasik ne. Endaén i lagaén, brab fatut ibérén brab gédaay de étéw ké témara ro. ");
INSERT INTO tiy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Atin i begome ségiléw gom bé soloe réméndaw dob délémone ni duniya. Loo so bé ni, i ingéde féntindég dob uruk i burure, énda mébunéyén. ");
INSERT INTO tiy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Atin énda i ségétéw tumumon solo inok ahuré no dob fénléngkébé kuréng. Yamula fédiyoé no dob fédongone de inok réméndaw dob lawie. Mélaw gégitoy kéluhanay de étéw diyo. ");
INSERT INTO tiy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mélaw ségiléw gom bé de solo, non fatut rigo gom i fiyowe sénga tékélid, inok i de étéw gito ro, atin dayéwé ro mélaw i Abay gome Tuluse dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Atin féntaus Jesusey kétoro ne mano, “Kagom fégitungén de ké ménangéyu dini inok kédané kuy kitabé niray Moisese taloo noy de kétoro i de sénarigoy Tuluse muret bé kébéréh ne. Non énda ménangéyu dini inok kédané ku, yamula ménangéyu dini inok tumané ku. ");
INSERT INTO tiy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Béréhé ku begom i toowe, taman énda méalfa i duniyae ni brab lawayo, énda so mékédan i kitabe, fiyon kloh saén, taman énda métuman i kéluhanane. ");
INSERT INTO tiy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mélaw i étéwe mémélis bé kitabé fiyon fo ké toow saén fo kloh sugu, brab toroé no so dob de étéw i éndaén kailanga no odoron, toow na fo gérifantad bé de étéw féguléwoy Tuluse. Endob i étéwe modor bé kitabé brab toroé noy de étéw bé fatut odoro ro, toow fo gérotor bé de étéw féguléwoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Béréhé ku begom, amuk énda toow na fo métintuy de rigoné kom bé de rigonéy de Fariseo brab de témoro bé kitabe, énda géahur gom dob kéféguléw i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Atin féntaus Jesusey kétoro ne mano, “Enggélingoo kom i ténoro i de katufua kom maro, ‘Kagom méméléhu, atin i méméléhue fatut mékukum.’ ");
INSERT INTO tiy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Endob toroé ku begom béleewe ni: I étéwe mékérit bé dumo nuwe, mékukum. Atin amuk wén i étéw béréhé no, ‘Léngléngén go’ dob dumo nuwe, fatut mékukum dob adafay de kéfédéwan. Atin amuk wén i étéw émbéréh dob dumo nuwe mano, ‘Dufang go’, médait mangéy dob gonoy aféye dob uleono emferno. ");
INSERT INTO tiy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mélaw amuk diyo go dob féngadafane témulak dob Tuluse, atin gétédémo mo wén i rénigo mo sala dob dumo muwe, ");
INSERT INTO tiy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tagakém nay tulaké muwe dob adafay ahayane tulakan, atin fagayas go angéy dob dumo muwe brab séfiyo gom inok éndaén tete i de fédéw gom. Tidéw béno, séfule go brab irayém i tulak me dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Atin buluk wén i dumo mo sébanil beem, atin uwité no beem dob kémukume inok sétiyawan gom, buluk diyo gom séna dob de aguwon, béréh go fiyo inok géséfagayun gom, brab éndaén mélaw kailanga kom i, mangéye dob adafay kémukume. Non amuk Enda, atéé no beem dob kémukume, brab i kémukume atéé no beem dob de sundalo, brab i de sundalo férisuné ro beem. ");
INSERT INTO tiy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Atin béréhé kuy toowe, énda moso géésut go tidéw dob férisunone taman énda gébayada moy kéluhanay késalaa muwe.” ");
INSERT INTO tiy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Atin féntaus Jesusey kétoro ne mano, “Enggélingoo kom i kétoroe mano, ‘Kago sétayan saliyu bé bawag me.’ ");
INSERT INTO tiy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Endob toroé ku begom béleewe, bé fiyon fo ké ténéngténg i lagéye saén i libune brab mingar de sétayan, énggésalaén non maak léménamfa i fédéw ne. ");
INSERT INTO tiy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mélaw amuk i funa muwe mésala i moto muwe fingé kuwonon, lésitém atin ibérém. Non mas na fiyo ké kulang i réfa i lowoh me ké ganaf i lowoh me atin géangéy go dob uleono emferno. ");
INSERT INTO tiy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Atin amuk i funa muwe mésala i kuwonone kémérém, kéléngém, atin ibérém. Non mas na fiyo ké kulang i réfa i lowoh me ké ganaf i lowoh me atin géangéy go dob uleono emferno.” ");
INSERT INTO tiy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Atin féntaus Jesusey kétoro ne mano, “Wén soy kétoroe mano, ‘I lagéye gémélak bé bawag ne fatut iraya no bé sulate émbéréh ménségélak ron.’ ");
INSERT INTO tiy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Endob toroé ku begom béleewe, amuk wén i ségétéw lagéy gélaké noy bawag ne éndob énda mon bigaén i ni libun, toow fo ménsala i nan lagéy. Non been i ménfélamfae bé libuno no ké mawag man ségiyo lagéy. Atin énggélamfa soy lagéye ménawag bé libune gélak loo bé nan.” ");
INSERT INTO tiy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Atin féntaus Jesusey kétoro ne mano, “Enggélingoo kom soy ténoro i katufua tome mano, ‘Amuk sémafa go dob Kadnane, tintu kailanga mo tumanén i safa me ni.’ ");
INSERT INTO tiy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Endob toroé ku begom béleewe, amuk rémigo gom fasad, kagom sémafa. Kagom fégésafa i lawayo non been i niy saray Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Atin kagom fégésafa i duniyae ni non been i niy ténaa nuwe bé de sékéyén. Atin kagom fégésafa i ingéde Jerusalem non been i niy gonoy barakatane Datu bati moso. ");
INSERT INTO tiy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Atin kagom sémafa ké makom, ‘Méléhuu na dob ni.’ Non énda géféfuteo kom taloo no géféitama kom i fiyon suwaréw bé de buk gom. ");
INSERT INTO tiy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Béréh gom saén, ‘Hoo’, taloo no ‘Enda.’ Amuk umana kom i nan bé de safa, tidéw dob Satanasey nan kébéréh gom.” ");
INSERT INTO tiy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Atin féntaus Jesusey kétoro ne mano, “Enggélingoo kom i kétoroe mano, ‘Fatut séfésuliém i motowe bé motowe, brab i kiféne bé kiféne.’ ");
INSERT INTO tiy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Endob toroé ku begom béleewe ni, kagom sulion i étéwe réménigo tete dob begome. Ufama, amuk wén i téménamfiling bé fiféy me fingé kuwonon, fédayaém de témamfiling so bé ségébalae de. ");
INSERT INTO tiy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Atin amuk wén i muwit beem dob adafay kémukume inok gédoté noy kégal me irayém soy kamisita muwe de. ");
INSERT INTO tiy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Atin amuk wén i sundalo fégésé no beem mobo bé de uwitén bé ségékilomitrowe saén, oboém taman ruwo gékilomitro. ");
INSERT INTO tiy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Atin iraya moy mongote dob beeme. Atin amuk wén i méuyot mélét dob beeme, fééléto mo.” ");
INSERT INTO tiy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Atin féntaus Jesusey kétoro ne mano, “Atin énggélingoo kom i kétoroe mano, ‘Fégédaw go bé de dumo mo séloyuk, atin férarék go bé de sébanil beem.’ ");
INSERT INTO tiy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Endob ay niy kagéne kétoro begom: Fégédaw gom bé de sébanil begom. Atin dasala kom i de émférasay begom, ");
INSERT INTO tiy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","inok waléy gom do nga i Abay gome Tulus dob lawayo. Non i Tuluse féréndawé no soy térésange dob de fiyo étéw loo so dob de tete étéw. Atin féranaay Tuluse soy de étéw rémigo fiyo loo soy de étéw rémigo tete. ");
INSERT INTO tiy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Amuk mégédaw gom saén bé de étéw mégédaw begom, énda i baras i Tuluse de begom. I de lémiful kémubra buwis rigoné roy nan, fiyon fo ké énda fiyo ro étéw. ");
INSERT INTO tiy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Atin amuk sébéréh gom saén bé de dumo gom séloyuk, énda i funa kom médayéw. Non fiyon i de békén méngintulus rigoné roy nan. ");
INSERT INTO tiy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","I Abay gome Tulus dob lawayo, rigoné no saén i fiyowe. Brab i begome fatut so rigoné kom saén i fiyowe.” ");
INSERT INTO tiy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Atin féntaus Jesusey kétoro ne mano, “Kagom rémigo bé fiyowe émfésuwat bé Tuluse dob téngaangay de étéw saén inok dayéwéy de étéw begom. Non amuk rigoné kom i ni, énda i ségiyo baras gédoté kom tidéw dob Abay gome Tulus dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mélaw amuk tabanga moy ségétéwe méskinan bé kéiraya muwe de limus, kago fégétuwan de dob de ségiyo loo bé de étéw do ubo-ubo saén méngintulus rigoné ro dob de lawi féngadafan brab dob de aguwon. Rigoné roy ni inok dayéwéy de étéw bero. Mélaw béréhé ku begom i toowe, énggédot roy kéluhanay de baras ro, atin énda i baras i Tuluse de bero. ");
INSERT INTO tiy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Endob amuk tabanga moy ségétéwe méskinan, kago fégito-gitoy kérigo muwe de inok fiyon i de dumo mo do séloyuk énda gétiga ro de. Endob fiyon fo ké énda gitoy de étéw de, i Abay me Tulus gito noy rénigo muwe brab Been i marasane beem.” ");
INSERT INTO tiy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Atin féntaus Jesusey kétoro ne mano, “Buluk démasal gom, kagom iringén i de étéw do ubo-ubo saén méngintulus. Méuyot ro témindég démasal dob de lawi féngadafan brab dob de aguwon inok gitoy de étéw bero. Béréhé ku begom i toowe, i gédoté ruwe saén bé nan rigoné roy kédayéw i de dumo étéw bero. ");
INSERT INTO tiy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Endob buluk démasal gom, angéy gom dob sibéy gome brab fintu gom, atin dasal gom dob Tuluse Abay gom dob lawayo énda gito gom de. Amuk rigoné kom i ni, gédoté kom i baras gome tidéw dob Tuluse Abay gom. Beene saén i gégitowe bé kéluhanay rigoné kome. ");
INSERT INTO tiy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Buluk démasal gom, kagom dulién i kédasale énda i atagén. I de étéw énda gétiga roy Tuluse rigoné roy ni non maro ké fégélingoéy Tuluse bero ké mérugay i kédasal ruwe. ");
INSERT INTO tiy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kagom iringén bero. Enda kailanga kom i mérugaye kédasal non gétigay Abay gomey kailanga kome bé énda séna nongot gom de. ");
INSERT INTO tiy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ay niy ufamawe de. Dasal gom loo bé ni, ‘Abay gey dob lawayo, kéluhanay étéwe damén féngadafé ro Beem. ");
INSERT INTO tiy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Féguléwo mo damén i kéluhanay de étéw inok i kétaya muwe mérigo dob fantade ni loo so bé mérigowe dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Irayan gey bé amaé keye bé ni gai. ");
INSERT INTO tiy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fésagada mo begey bé de sala gey loo so bé kéfésagad geye bé de énggésala begey. ");
INSERT INTO tiy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kago fédayaén begey météngkad rémigo sala. Brab diyaga mo begey bé Satanase.’ ");
INSERT INTO tiy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Buluk fésagada kom i de étéw réménigo tete dob begome, i Boh gome dob lawayo fésagada no so begom. ");
INSERT INTO tiy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Endob buluk énda fésagada kom i de ménsala dob begome, i Abay gome Tulus énda so fésagada no begom.” ");
INSERT INTO tiy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Atin féntaus Jesusey kétoro ne mano, “Atin amuk fuwasa gom inok tintu méngintulus, kagom féélumén i falas gome loo bé rigonéy de ubo-ubo saén méngintulus. Féélumé roy falas ruwe inok fégétiga ro bé de étéw bé mélayaf ro non fuwasa ro. Béréhé ku begom i toowe, énda i ségiyo baras gédoté ro saliyu bé kédayéw i de étéw. ");
INSERT INTO tiy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Endob amuk fuwasa gom, furauf gom brab suwat gom, ");
INSERT INTO tiy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","inok i de ségiyo étéw, énda gétiga ro de ké fuwasa gom. Atin mélaw i Abay gome Tulus énda gitono, Been saén i gégitowe bé rigoné kome, atin barasa no begom. ");
INSERT INTO tiy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Atin kagom mitong kurta brab do languntaman dob duniyae ni, non mébinasa ro. Non i de tamuk dob duniyae ni keke i de ifés taloo no tangisén taloo no fénakawén non géahur i de ménakaw dob de lawi gom. ");
INSERT INTO tiy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Endob fatut itong gom i de baras gom dob lawayo non énda i ifés de méminasa taloo no tangisén taloo no fénakawén. ");
INSERT INTO tiy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Non i gonoy de tamuk gom, been soy gulaané kome. ");
INSERT INTO tiy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“I motowe maak solo i lowohe. Buluk fiyoy moto muwe, maak géfékaya i kéluhanay lowoh me non gégito go. ");
INSERT INTO tiy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Endob buluk ménsadil i de moto mo, maak délémon i lowoh me non énda gégito go. Mélaw buluk i solo me waléy délémon, toow fo délémon mon. ");
INSERT INTO tiy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Enda i sugu-suguén fakay galbéko no séréngan i ruwowe gétéw amu. Non amuk mégédaw bé ségétéwe de, mérarék bé ségétéwe de. Taloo no odoro noy kétayay ségétéwe de, brab siyawé noy ségétéwe de. Mélaw énda fakay gom modor bé Tuluse amuk fégitungé kom saén i kurtae. ");
INSERT INTO tiy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mélaw béréhé ku begom, kagom émbuku fantag bé kéuyag gome, bé ati amaé kome look inémé kome, taloo noy lowoh gome, bé ati kégalé kome. Non wén nay labi na fo mélaga bé amaéne funa kom méuyag, brab wén nay labi na mélaga bé kégale kay de lowoh gom. ");
INSERT INTO tiy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Fégitung gom i de kloh manok. Enda mohok ro taloo no kémétéw ro, brab énda mitong ro amaén dob de kiwot. Endob i Abay gome Tulus féamaé no so bero. Atin mas gom na balilaga bé de kloh manok! ");
INSERT INTO tiy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Enda i étéw géfétaah bé umul ne bé kébuku ne, fiyon ségéuras saén. ");
INSERT INTO tiy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Enda soy funa kom émbuku fantag bé kégale. Fégitung gom i de flores. Méruk ro fiyon fo ké énda gémalbék ro taloo no rémigo ro do kégal ro. ");
INSERT INTO tiy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Endob béréhé ku begom, fiyon i Solomone toow fo kawasa datu, énda i kégalén loo bé de fiyo do falasén do flores. ");
INSERT INTO tiy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Endob buluk loo bé nan i kéfékégal i Tuluse bé de kéroon méuyag ro saén singkow, atin bé démoe ibérén ro brab inohén, békén ba fékégalé no so begom? Toow fo kloh i kéféginugut gome. ");
INSERT INTO tiy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mélaw kagom émbuku bé amaé kome brab inémé kome brab kégalé kome. ");
INSERT INTO tiy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Non i de étéw énda méngintulus ro, been i nan i fégitungé ruwe taman émbuku ro. Endob i Abay gome Tulus gétiga noy kéluhanay kailanga kome. ");
INSERT INTO tiy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mélaw kagom émbuku. Yamula fatut kétaya kom ké méguléw i Tuluse dob begome brab kétaya kom rémigo bé métintuwe, atin mélaw irayay Tuluse begom bé kéluhanay de éntingayén kailanga kom. ");
INSERT INTO tiy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Atin mélaw kagom émbuku béleewe ni fantag bé ati mérigowe démo, fégitung gom fo ké gégumahén. Kagomén umanan i kékérégéna kome béleewe bé kébukue fantag bé démoe.” ");
INSERT INTO tiy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Atin féntaus Jesusey kétoro ne mano, “Kagom kukumén i de étéw, inok i Tuluse énda so kukumé no begom. ");
INSERT INTO tiy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Non i kékukum gome bé de ségiyo étéw, iringéy Tuluse so ké kukumé no begom. Atin i kérigo gome bé de ségiyo étéw, rigonéy Tuluse so dob begome. ");
INSERT INTO tiy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Sedek gito moy klohe sala i dumo muwe, éndob énda gito moy kaame sala toow na fo dakél? ");
INSERT INTO tiy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Atin béréhé mo dob dumo muwe mamo, ‘Adih, téréno moy nan salaém.’ Endob wén i kaame sala toow na fo dakél. ");
INSERT INTO tiy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Fédayéw-dayéw go, éndob békén go fiyo étéw. Téréno mo na métah i kaame sala toow na fo dakél, inok gétabanga moy dumo muwe émfétérén bé kaane kloh sala. ");
INSERT INTO tiy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Atin kagom iray i mékétéfuwe dob de itu. Non amuk rigoné kom, kekeé ro saén begom. Atin kagom iray i balilagae fégonoén perlas dob de babuy. Non amuk rigoné kom, daa ro saén. Mélaw kagom témoro bé Fiyowe Uret dob de étéw mika mégélingo.” ");
INSERT INTO tiy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Atin féntaus Jesusey kétoro ne mano, “Ongot gom dob Tuluse atin irayén begom. Séléd gom, atin gito gom. Tawag gom dob béngawane, atin i fintue ungkaén inok géahur gom. ");
INSERT INTO tiy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Non i kéluhanay de mongot dob Tuluse, gédoté ro. Atin i kéluhanay de séméléd, gito ro. Atin i kéluhanay de témawag dob béngawane, géahur ro. ");
INSERT INTO tiy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ufama, ségétéw go boh, atin i nga me mongot fan, énda iraya mo de batéw. ");
INSERT INTO tiy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Taloo no mongot sédo, énda iraya mo de ulé. ");
INSERT INTO tiy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Fiyon fo ké tete gom étéw, gétiga kom soy miraye bé éntingayéne fiyo dob de nga gom. Labi nay Tuluse toow fo fiyo, gétiga noy miraye fiyo na dob begome. Beeney Boh gome dob lawayo, brab irayén i de fiyo do éntingayén dob de étéw mongot dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Buluy kétaya kome rigonéy de étéw dob begome, rigo gom so dob berowe. Non been i atag i kéluhanay de sugu dob kitabé niray Moisese brab de kétoro i de sénarigoy Tuluse muret bé kébéréh ne.” ");
INSERT INTO tiy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Atin féntaus Jesusey kétoro ne mano, “Ahur gom dob mérate béngawan mangey dob lawayo. Non toow fo buka i béngawane mangéy dob uleone emferno atin médooy de étéw muntul de non magad i kéagéw ruwe diyo. ");
INSERT INTO tiy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Endob i mérate béngawan mangéy dob umule magufusa, mérégén i kéuntule de. Mélaw énda médooy étéwe géuntul de. ");
INSERT INTO tiy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Atin ingat gom inok énda géunur gom bé de ubo-ubo sénarigoy Tuluse muret bé kébéréh ne. Non fiyon fo ké ubo-ubo ro mégédaw maak do ménorom ayam, tintu tete i adat ruwe brab binasané ro begom. Non i toowe, ségiléw ro bé de mérayar do binatang. ");
INSERT INTO tiy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","18","Endob gélolo gom bero sabaf bé de rigoné ro. Ufama, énda i fiyo kayéw mégonok bé tetee onok, taloo no tete kayéw mégonok bé fiyowe onok. I sulu-suluwe énda mégonokén bé manggae. Brab i kayéwe suwaran énda mégonokén saging. I fiyowe kayéw mégonok saén fiyo, atin i tetee kayéw mégonok saén tete. ");
INSERT INTO tiy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Atin i kayéwe énda mégonokén fiyo, tuwongén brab ibérén dob aféye inok inohén. ");
INSERT INTO tiy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mélaw gélolo gom i de ubo-ubo sénarigoy Tuluse sabaf bé de tete rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Enda kéluhanay de étéw témawag Begén maro, ‘Kadnan, o Kadnan,’ géangéy ro dob lawayo. Endob i de étéw rémigo bé kétayay Abay guwe Tulus, bero saén i géangéy dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bé gaiwe gégumah i kékukum i Tuluse, médooy de étéw émbéréh dob Begéne maro, ‘Kadnan, o Kadnan, nuret gey i kébéréh i Tuluse nusar gey i dawét me. Atin nusar gey soy dawét me fégédédél bé de saitan tidéw dob de étéw rénahuko ro, brab rénigo gey i de médoo do mékégaif dob dawét me.’ ");
INSERT INTO tiy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Endob béréhé ku bero maku, ‘Enda gélolo gu begom. Férayu gom dob Begéne. Begom i de étéw do rémigo tete.’ ");
INSERT INTO tiy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Béréhé ku begom i fantage bé de mégélingo bé kébéréh guwe brab odoro ro. Berowey ségiléwe bé ségétéwe métilédtéd réménigo lawi brab féntindégén i de liléyén dob émbagére batéw. ");
INSERT INTO tiy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Amun mérégés i ranae brab énggégumah i dunuke brab énggébéla diyo i émbagére réfuruh, énda méntuwongén non féntindég dob rotor i batéwe. ");
INSERT INTO tiy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Endob i étéwe énggélingo bé de kébéréh gu éndob énda odoro no de, ségiléw bé dufange étéw féntindégén i lawi ne dob faréke saén. ");
INSERT INTO tiy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mélaw amun ménrégés i ranae brab énggumah i dunuke brab énggébéla diyo i émbagére réfuruh, méntuwong brab toow fo ménbinasa.” ");
INSERT INTO tiy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Amun énggilid i Jesuse témoro bé de ni, ménggaif i de médoo do étéw bé kétoro ne. ");
INSERT INTO tiy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Non békén ségiléw i kétoro ne bé de maistéroy kitab i de Judio. Non énda saén ténoroén i kéfégitung i de ségiyo étéw. Yamula ténoroén i kaane kéfégitung. ");
INSERT INTO tiy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tidéw béno, léménudug i Jesuse tidéw dob burure ni. Atin ménfuray i de médoo do étéw. ");
INSERT INTO tiy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tidéw béno, wén i ségétéwe étéw fémuteén ménangéy dob Beene brab léméningkuwéd dob adafa nuwe. Atin ménbéréh i fémuteéne ni étéw mano, “Kadnan, buluk méuyot go, géféadi-adino mo begén.” ");
INSERT INTO tiy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Atin i Jesuse béntérén i kémér ne brab kénuwahén, brab ménbéréh mano, “Méuyotu. Adi-adi go.” Sonom béno, ménkédan i fémute ne brab ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Atin bénréh Jesuse dob beene bé békén ureté no dob de ségiyo étéw, brab sénuguén mano, “Ay go dob fadie inok féténgténgém ménadi-adi gon. Tidéw béno, tulak go, loo bé ménbéréhe dob kitabé tidéw dob Moisese inok gétigay kéluhanay de étéw ménadi-adi gon.” ");
INSERT INTO tiy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Amun énggumah i Jesuse dob ingéde Kafernaum, wén i ségétéwe Romano kafitay de sundalo ménangéy dob Beene. Atin ménongot tabang dob Jesuse mano, ");
INSERT INTO tiy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Maistéro, wén i sugu-sugué kuwe toow fo fasang déméruun béni. Diyo dob lawi guwe énda gélékutohén.” ");
INSERT INTO tiy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Atin ménbéréh i Jesuse mano, “Na, mangéyu diyaan atin uwaé ku.” ");
INSERT INTO tiy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Endob bang i kafitane, “Kagonén damén mangéy dob lawi guwe. Non toow go fo gérotor étéw atin mélaw énda médaitu témanggaf Beem dob lawi guwe. Endob toow go fo barakatan, mélaw béréhém saén i sugu me mamo, ‘Adi-adi gon,’ atin gétiga kuy waléy adi-adiy sugu-sugué kuwe. ");
INSERT INTO tiy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gétiga kuy ni non wén i mas gérotor sundalo mémanduon begén. Brab wén soy do sundalo fémanduo ku. Atin buluk béréhé ku dob ségétéwe de, ‘Angéy go diyoo,’ mangéy diyo. Brab buluk maku dob ségétéwe de, ‘Enggon,’ témingé. Brab buluk béréhé ku dob sugu-sugué kuwe, ‘Rigo moy ni,’ rigoné no.” ");
INSERT INTO tiy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Amun énggélingoo Jesusey ni, ménggaif de. Atin ménbéréh dob de étéw furay dob Beene mano, “Béréhé ku begom i toowe, fiyon foy de Judio, énda i ségétéw énggito gu loo bé ni kéféngintoowén étéw. ");
INSERT INTO tiy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Béréhé ku begom, bé gaiwe gégumah méguléw i Tuluse, médooy de étéw gégumah tidéw dob kéluhanay sugud i duniyae, fiyon i de békén Judio. Atin i Tuluse féguléwo no bero beroy de katufua tom ro Abraham, Isak, brab Jakob. ");
INSERT INTO tiy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Endob wén i de Judio diyo ro so damén éndob kénda no bero mangéy dob délémone gonon dob liyuwe. Diyo ro kémérew brab kémigét i de kifé ro.” ");
INSERT INTO tiy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Atin ménbéréh i Jesuse dob kafitane ni mano, “Ule gon, ménadi-adinén i sugu-sugué muwe loo bé kéunur me mérigo.” Atin i sugu-sugué nuwe, ménadi-adi bé no so uras. ");
INSERT INTO tiy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tidéw béno, méntaus i Jesuse mangéy dob lawi Pedrowe. Diyo énggito noy térima Pedrowe libun déméruun gara-gara toow fo méduf. ");
INSERT INTO tiy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Atin i Jesuse kénuwahén i kémér i libune ni. Atin sonom béno, ménkédan i kééduf ne brab ménadi-adi. Atin méntek dénuwoto no bero. ");
INSERT INTO tiy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Amun mélédén i térésange, i de étéw nuwit roy de médoo do sénaitanan ménangéy dob Jesuse. Ménbéréh saén i Jesuse atin fénféraréyén i de saitan. Atin nuwa Jesusey kéluhanay de déméruun diyo. ");
INSERT INTO tiy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Rénigo noy ni inok tumané noy kébéréh i sénarigoy Tuluse muret bé kébéréh ne féndawét Isaias mano, “Uwaé noy de déruu tom, atin kédané noy de tete tom.” ");
INSERT INTO tiy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Atin amun énggito Jesusey de médoo étéw géliwét de, sénuguén i de kuyugén mifar dob dogote. ");
INSERT INTO tiy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tidéw béno, wén i témoroe bé kitabé ménfégédét dob Jesuse brab ménbéréh mano, “Maistéro, modoru Beem fiyon udenén ayo mo.” ");
INSERT INTO tiy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Endob ménbéréh i Jesuse mano, “I de kufés, wén i tosong ahuro ro. Brab i de kloh manok, wén i salag ro. Endob i Nga i Kéilawane, sani Begéne, énda i gono ku témérén taloo no fidong. Mélaw toow go fo kérégénan amuk modor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Atin wén i ségétéwe kuyugén ménbéréh dob Jesuse mano, “Maistéro, modoru Beem. Endob tungkasém na begén métah mangéy lémbéng bé boh guwe.” ");
INSERT INTO tiy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Endob séménumbul i Jesuse mano, “Félébéngém bé de étéw énda munur Begén i de ménléhu ro. Endob i beeme, odor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tidéw béno, i Jesuse brab de kuyugén ménda ro awang mifar dob dogote. ");
INSERT INTO tiy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Atin téménékow ménggumah i émbagére défuk. Atin séndamfa-damfaay de bagél i awange, taman gédét mééléd. Endob i Jesuse énggéfidong. ");
INSERT INTO tiy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Atin ménangéy i de kuyugén dob Beene, brab nulég ro maro, “Kadnan, tabangén gey! Gédét tom méléhu!” ");
INSERT INTO tiy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Séménumbul i Jesuse mano, “Sedek mégilak gom? Toow fo kloh i kéunur gome.” Tidéw béno, téménindég i Jesuse brab ménbéréh dob réfuruhe brab dob de bagél mano, “Térén gom!” Sonom béno, téménrén i défuke brab méntinanék i dogote. ");
INSERT INTO tiy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ménggaif i kéluhanay de kuyug Jesus. Atin ménsébéréh-béréh ro maro, “Ati keeyén i Jesuse ni? Fiyon i réfuruhe brab de bagél modor ro bé sugu ne.” ");
INSERT INTO tiy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Amun énggumah i ro Jesuse dob difar i dogote dob ingéde Gerasa, bénalak i de ruwo gétéw lagéy rénahukoy de saitan. Bati ro dob de takub do lébéng atin toow ro fo émbaraw. Mélaw énda i do étéw gétara diyo. ");
INSERT INTO tiy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Atin ménkes ro maro, “Nga i Tuluse, ati rigoné muwe dob begeye? Aw ménangéy go ba dini inok kukumé mo begey fiyon fo ké énda séna gégumah i fatute gai?” ");
INSERT INTO tiy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Enda mérayuén dob no gonon, diyo i médoowe do babuy témabtab. ");
INSERT INTO tiy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Atin nongot i de saitan dob Jesuse maro, “Amuk féféraréyé mo begey, féahurém begey dob do babuy diyo.” ");
INSERT INTO tiy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Atin bang Jesuse, “Agéw gom.” Mélaw ménsut i de saitan tidéw dob do étéw no brab ménahur ro dob de babuy ni. Sonom béno, i kéluhanay de babuy ni, ménraréy ro mangéy dob fingase brab ménantéfor ro mangéy dob dogote atin ménléné ro. ");
INSERT INTO tiy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Atin i de étéw témalima bé de babuy ni amun énggito roy ni ménrigo, ménségéta ro mangéy dob ingéde brab nuret roy kéluhanay de rénigo Jesus brab ati ménrigowe dob de lagéy sénaitanan bé gétahe. ");
INSERT INTO tiy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mélaw ménangéy diyo i kéluhanay de étéw dob ingéde ni inok malak bé Jesuse. Atin amun énggito ro, nongot roy Jesuse ké tékédan dob no gono ro. ");
INSERT INTO tiy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tidéw béno, ménda i Jesuse dob awange atin ménséfule mifar dob dogote brab ménule mangéy dob ingéd ne. ");
INSERT INTO tiy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Diyo, énggumah i de étéw ménuwit bé ségétéwe kimoyén ténanggung ro mangéy dob Jesuse. Amun énggito Jesusey kéféngintoow ruwe, ménbéréh dob ni étéw kimoyén mano, “Adih, kago émbuku! I de salaém ménfésagadén.” ");
INSERT INTO tiy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tidéw béno, wén i de témoro bé kitabé ménsébéréh ro dob de fédéw ro maro, “Embéréh mékémurka i ni étéw, non réféngé noy Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Edob i Jesuse gésobuto noy de itunga ro. Mélaw ménbéréh mano, “Sedek tete i kéfégitung gome loo bé nan? ");
INSERT INTO tiy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Toow na fo mélému ké béréhén, ‘I de salaém ménfésagadén.’ Non énda gito no ké wén i barakat gu de rémigo. Endob toow fo mérégén ké béréhén. ‘Tindég go brab agéw go.’ Non giton ké wén i barakat gu de rémigo. ");
INSERT INTO tiy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Endob féfégétiga ku begom i fantage bé Nga i Kéilawane, sani Begéne. Wén i barakat gu brab kuwagib gu dob duniyae ni émfésagad bé de sala.” Tidéw béno, bénréhén dob ni kimoyén mano. “Tindég go brab ule go unwitém mule i iroo muwa nan.” ");
INSERT INTO tiy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sonom béno, téménindég i kimoyéne ni brab ménagéw mule. ");
INSERT INTO tiy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","I de médoo do ménlimud do étéw diyo, amun énggito roy ni, ménggilak ro, atin dénayéw roy Tuluse non nirayén dob Jesusey kuwagibé émfésagad bé de sala. ");
INSERT INTO tiy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tidéw béno, méntékédan i Jesuse dob no gonon. Atin i lala ne magéw, énggito noy ségétéwe étéw kémubra buwis féndawét Mateo, ménsar dob de kubranan buwis. Atin ménbéréh i Jesuse mano, “Odor go Begén.” Atin téménindég i Mateowe brab ménodor de. ");
INSERT INTO tiy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tidéw béno, i Jesuse beroy de kuyugén ménama ro dob lawi Mateowe séréngan bé de médoo do kémubra buwis brab de ségiyo so do tete étéw. ");
INSERT INTO tiy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Atin amun énggitoy de Fariseoy ni, ménénginsa ro dob de kuyug Jesus maro, “Sedek ménsélawék i Maistéro gome mama bé de kémubra buwis brab de ségiyo tete étéw?” ");
INSERT INTO tiy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Endob i Jesuse énggélingoo no brab ménbéréh mano, “I de fiyo kégélowoho no, énda kailanga roy muwae, éndob kailangay de wén déruu no. ");
INSERT INTO tiy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Enda ménangéyu dini inok tabaré kuy de métintu étéw, éndob ménangéyu dini inok tabaré kuy de wén salaén inok gésénule ro. Basa gom brab tantu gom fégitung i ni Ménsulat Kébéréh i Tuluse mano, ‘Mas méuyotu de ké ségédaw gom bé kétulak gome.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tidéw béno, wén i de kuyug Juan Bautista ménangéy ro dob Jesuse brab ménénginsa ro maro, “I begeye, sénga tékélid fuwasa gey. Loo so bé de Fariseo. Sedek énda fuwasay de kaam kuyug?” ");
INSERT INTO tiy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Atin sénumbulo Jesuse bero mano, “Ufama, i de kana dob uyote énda waléy tete i de fédéw ro taman énda tékédan i témérimawe lagéy. Endob amuk gégumah i gaiwe ké édotén nén i témérimawe lagéy dob berowe, been nay no fuwasa ro. Ségiléw so bé de kagén kuyug, non amuk diniwu séna, énda fuwasa ro.” ");
INSERT INTO tiy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tidéw béno, nuret Jesusey sébaane binuwaya fantag bé sébidanay mantuwe kétoroén brab tafaye kétoro i de Judio. Ménbéréh mano, “Enda i étéw usaré noy mantuwe safut fégétabungén bé tafaye kégal. Non amuk rigoné no, kéménkén i mantuwe safut, atin méfendet i tafaye kégal, atin minut gétimal i rédet ne. ");
INSERT INTO tiy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Brab énda i étéw mahur bé mantuwe arak dob tafaye ahuron arak rénigo bé kulit i ayame. Non amuk rigoné no, mébétus i mantuwe arak dob tafaye ahuron brab mébinasa brab méitis i mantuwe arak. Yamula fatut i mantuwe arak ahurén dob mantuwe kulit fédéngon de, atin méitong kéluhanan.” ");
INSERT INTO tiy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","I lala Jesuse émbéréh séna, énggégumah i ségétéwe odoroy de Judio, brab ménlingkuwéd dob adafa Jesuse brab ménbéréh mano, “I nga guwe libun mantu séna ménléhu. Endob amuk modor go begén brab angéyé mo gamakén, gétiga kuy tébule.” ");
INSERT INTO tiy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mélaw téménindég i Jesuse brab ménodor bé ni lagéy. Ménodor soy de kuyugén. ");
INSERT INTO tiy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Amun ménagéw ro, ménggéta i ségétéwe libun bero. I ni libun foloén bra ruwo gébélintuwa i kéranas i adat ne. Amun ménfuray bé Jesuse, ménggitung mano, “Amuk gékuwaha ku saén i kégal ne, adi-adiwu.” Mélaw ménangéy dob ségang Jesuse brab kénuwahén i kégal ne. ");
INSERT INTO tiy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tidéw béno, séménling i Jesuse brab amun énggito noy ni libun, sénbérého no mano, “Di, kago émbuku. I kéféngintoow mey funa muwe ménadi-adi.” Sonom beno, i ni libun ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tidéw béno, méntaus i Jesuse mangéy dob lawi i odoroy de Judio ni. Amun énggumah, énggito noy de médoo do étéw diyo. Rémuung ro brab selekén ro brab émbaat ro fo. ");
INSERT INTO tiy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ménbéréh i Jesuse mano, “Tékédan gom! Enda ménléhu i ngae ni. Fidong saén.” Tidéw béno, sénbayat roy Jesuse bé bénréh ne. ");
INSERT INTO tiy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amun ménsut i de étéw dob lawie, ménahur i Jesuse dob sibéy i ngae ni libun, brab génamakén dob kémér ne. Bé béno so, méntek i ngae ni. ");
INSERT INTO tiy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tidéw béno, i urete fantag bé ni rénigo Jesuse ménlégéb dob kéluhanay de ingéd diyo. ");
INSERT INTO tiy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tidéw béno, méntékédan i Jesuse tidéw diyo. Atin bé lala ne magéw, ménfuray i ruwowe gétéw lagéy do langafén. Ménkes ro maro, “Séfu Datu Dabid, fégédaw go begey!” ");
INSERT INTO tiy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Atin amun ménahur i Jesuse dob lawie, ménfégédét i de langafén ni. Atin fénénginsaa Jesuse bero mano, “Aw munur gom ba ké géuwaa ku begom?” Atin séménumbul ro maro, “Hoo Maistéro, munur gey.” ");
INSERT INTO tiy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tidéw béno, i Jesuse kénuwahén i de moto ro brab ménbéréh mano, “Mérigo dob begome loo bé kéunur gome de.” ");
INSERT INTO tiy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Atin sonom béno, énggégito ro. Atin ménégét i kébéréh Jesuse de bero mano, “Kagom uretén i ni dob de étéw.” ");
INSERT INTO tiy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Endob amun ménagéw ro, nuret roy ni rénigo Jesuse. Atin mélaw ménséfélalag i bantuga nuwe dob kéluhanay de ingéd diyo. ");
INSERT INTO tiy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lala ruwe magéw i de ni ruwo gétéw do éndaén do langafén ro, énggumah i de étéw nuwit ro dob Jesusey ségétéwe mow sabaf bé saitane rénahuko no. ");
INSERT INTO tiy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Atin dénédél Jesusey saitane ni. Atin sonom béno, énggébéréh i lagéye ni non éndaén mowén. Atin i kéluhanay de étéw diyo ménggaif ro, brab ménbéréh ro maro, “Enda séna énggégito gey bé mékégaife loo bé ni dob ingéd tome ni Israel.” ");
INSERT INTO tiy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Endob ménbéréh i de Fariseo maro, “I funa nuwe gédédél do saitan non wén i barakatén tidéw dob Satanase sani odoroy de saitan.” ");
INSERT INTO tiy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tidéw béno, ménagéw i Jesuse mangéy sémugud dob kéluhanay de ingéd diyo. Atin téménoro dob de lawi féngadafan kay de Judio, brab nuretén i Fiyowe Uret fantag bé kéféguléw i Tuluse bé de étéwén. Atin nuwaén soy de médoo do étéw bé ségiyo-giyowe do déruun. ");
INSERT INTO tiy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Atin amun énggito noy de médoo do étéw ménlimud dob Beene, ménuray i na nuwe bero, non ménbuku ro brab kailanga roy tabange. Maak do bili-bili énda i mifat bero. ");
INSERT INTO tiy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mélaw ménbéréh dob de kuyugén mano, “I de ni do médoo do étéw méuyot munur dob Begéne, ségiléw ro bé bukae safad fatutén kétéwén. Endob kloh saén i kémétéwe de, sani de témoro bero munur. ");
INSERT INTO tiy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mélaw dasal gom dob Tuluse inok umana noy de gémalbék témabangan betom kémétéw.” ");
INSERT INTO tiy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Atin i Jesuse ténawagén i de folo bra ruwo gétéw kuyugén mangéy dob Beene. Atin niraya no bero barakat inok gédédél ro do saitan brab géuwaa roy de kéluhanay de ségiyo-giyo do déruun. ");
INSERT INTO tiy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ay niy de dawét i de Apostol, sani de sénugu: Simon (féndawétén so Pedro), brab Andres dumo no sétiman idéng, Santiago brab Juan sani de nga Sebedeo, ");
INSERT INTO tiy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","brab Filipi, brab Bartolome, brab Tomas, brab Mateo sani kémubrawe buwis, brab Santiago nga Alfeo, brab Tadeo, ");
INSERT INTO tiy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","brab Simon ségétéw toow fo gulaané noy ingéd ne, brab Judas Iskariot sani ménfékéfoe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Atin sénugu Jesusey de ni folo bra ruwo gétéw kuyugén mano, “Kagom mangéy dob de ingéd i de békén Judio taloo no dob de ingéd sakuf i dakéle ingéd Samaria. ");
INSERT INTO tiy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yamula, agéw gom mangéy dob de étéw dob Israel non ségiléw ro bé de méntadin do bili-bili. ");
INSERT INTO tiy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Agéw gom brab uret gom makom, ‘Gédétén i gaiwe féguléwoy Tulusey de étéwén.’ ");
INSERT INTO tiy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Atin uwa gom i de déméruun, tébule gom i de ménléhu, féadi-adi gom i de fémuteén, féféraréy gom i de saitan. Atin kagom fébayadén i de étéw, non énda fébayadé ku begom bé kéiraya kuwe begom. ");
INSERT INTO tiy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Atin kagom muwit kurta, fiyon bélowon look filak, taloo no do kloh kurta. ");
INSERT INTO tiy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Atin kagom muwit réban, taloo no tugé, taloo no lékasa kom kégal look sinilas. Non i de tabanga kom fatut tabanga ro so begom bé atiy kailanga kome. ");
INSERT INTO tiy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Atin amuk gégumah gom dob sébaane ingéd, séléd gom i ségétéwe méuyot témayakuf begom. Atin bati gom diyo taman tékédan gom tidéw dob no ingéd. ");
INSERT INTO tiy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Atin buluk mahur gom dob lawie, béréh gom bé féfiyonéy Tulusey de étéw bati dob ni lawi. ");
INSERT INTO tiy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Buluk i de étéw dob nan lawi tayakufé ro begom, féfiyonéy Tuluse bero. Endob buluk énda tayakufé ro begom, énda so féfiyonéy Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Atin buluk gégumah gom dob sébaane ingéd énda tayakufé ro begom taloo no énda fégélingoé ro begom, tékédan gom diyo. Atin tag-tag gom i de bubuk sébuwan dob de sékéy gom inok fégétiga kom bero bé kukuméy Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Béréhé ku begom i toowe, bé gaiwe kémukum i Tuluse, toow na fo gétimal i kékukum ne bero bé de tete étéw ménbati dob de ingéd Sodom brab Gomorah bé gétahe. ");
INSERT INTO tiy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Fégélingo gom, féuwit gu begom maak do bili-bili mangéy dob kérara i de itu talun. Mélaw ingat gom brab fatut rigo gom saén i fiyowe. ");
INSERT INTO tiy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ingat gom non wén i de étéw kémfo begom brab uwité ro begom mangéy dob adafay kémukume. Atin badasé ro begom dob de lawi féngadafan kay de Judio. ");
INSERT INTO tiy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Atin uwité ro begom dob adafay de méguléw begom brab de datu inok kukumé ro begom sabaf begom i do kuyug gu. Endob been i niy gaiwe uret gom i Fiyowe Uret dob berowe brab dob de békén Judio. ");
INSERT INTO tiy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Atin amuk kéfoé ro begom brab kukumé ro begom, kagom émbuku fantag bé atiy béréhé kome bero look ati kébéréh gome. Non bé no gai, iray begom i fatute kébéréh fégésumbul gom bero. ");
INSERT INTO tiy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Non i kébéréhe békén tidéw dob itunga kome, yamula i Rémogor i Abay gome Tulus i émfébéréhe begom. ");
INSERT INTO tiy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Atin bé no gai, wén i de étéw atéé roy de dumo ro sétiman idéng inok féléhuén. Loo soy rigonéy de abay dob de nga ro. Atin wén soy de nga waléy sébanil bé de lukés ro brab féféléhu ro. ");
INSERT INTO tiy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Atin i kéluhanay de étéw mérarék ro begom sabaf bé kéunur gome Begén. Endob ati fédaydaye munur taman dob tamfadane, méfukas ro. ");
INSERT INTO tiy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Atin amuk férasayé ro begom dob sébaane ingéd, féraréy gom mangéy dob ségiyowe ingéd. Béréhé ku begom i toowe, énda séna géfégilido kom i galbék gome dob kéluhanay de ingéd dob Israel, séfuleun mangéy dini, sani Nga i Kéilawane. ");
INSERT INTO tiy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“I méganade békén gérotor na bé témoroe de. Atin i sugu-suguéne békén gérotor na bé amu ne. ");
INSERT INTO tiy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mélaw i méganade fatut moror ké iringé noy témoroe de. Atin i sugu-suguéne fatut moror ké iringé noy amu ne. Atin amuk i uléw i ségékurénge féndawét do étéw Beelsebul sani Satanase, labi na fo tete i fédawét ruwe bé kuréngo nuwe. Mélaw amuk féngiras i de étéw Begén, toow na fo gétimal i kéféngiras ruwe begom. ");
INSERT INTO tiy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mélaw kagom mégilak bé étéwe. I kéluhanay rigonéy de étéw do méntéléb, mébukeh so moso. Brab i kéluhanay de méntéléb, mébukeh so moso. Brab i kéluhanay de ménbunéy, giton so moso. ");
INSERT INTO tiy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Atin i béréhé kuwe ni dob begome saén, fatut béréh gom so dob de médoo do étéw. Atin i ségurawé kuwe dob begome, fatut toro gom dob de médoo do étéw. ");
INSERT INTO tiy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Atin kagom mégilak bé de géféléhu bé lowoh gome, éndob énda géféléhuo roy rémogor gome. Yamula fatut gom mégilak bé Tuluse non wén i barakatén méminasa bé de lowoh gom loo soy de rémogor gom dob uleono emferno. ");
INSERT INTO tiy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ufama, i de kloh manok toow fo mélémuy kéfébéléye bero dob fadiyane. Endob énda i sébaan mélawu bero dob fantade ké énda fédayaéy Abay tome de Tulus. ");
INSERT INTO tiy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Atin i begome mas gom na balilaga bé de kloh manok. Mélaw kagom mégilak, non i Tuluse tuganulé no begom. I Tuluse gétiga no fiyon i kédooy de buk gom dob de uléw gom. ");
INSERT INTO tiy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Atin ati murete fantag bé kéunur ne Begén dob de étéw, ureté ku soy fantage bé kéunur ne dob Abay guwe Tulus dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Endob ati démirunge bé kéunur ne Begén dob adafay de étéw, dirungé ku so moso i kéunur ne dob adafay Abay guwe Tulus. ");
INSERT INTO tiy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Atin kagom fégitungén de ké ménangéyu dini inok kédané kuy késétibohe dob duniyae ni. Békén. Yamula ménangéyu dini inok sétiboh i de étéw. Non i de étéw munur Begén brab de étéw énda munur Begén waléy ro sébanil. ");
INSERT INTO tiy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Non ménangéyu dini inok fésébanilé kuy de boh brab de nga ro lagéy. Loo so bé de idéng brab de nga ro libun. Loo soy de libun bé de térima ro libun. ");
INSERT INTO tiy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Atin mélaw i toowe na fo sébanil i de étéw, beroy de dumo no ségékuréng. ");
INSERT INTO tiy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Atin i étéwe mas nay kéimu ne bé de lukésén bé Begéne, énda médaitén waléy kuyug gu. Atin i étéwe mas nay kéimu ne bé de ngaén bé Begéne, énda so médaitén waléy kuyug gu. ");
INSERT INTO tiy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Atin fiyon atiy étéwe énda furayén Begén bé kéfédayday ne bé de mérégén fiyon fo ké féléhuén dob kruse, énda médaitén waléy kuyug gu. ");
INSERT INTO tiy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Atin i étéwe méuyot émféraru bé umul ne dob duniyae ni, méléhu. Endob i étéwe méléhu bé kéfuray ne Begén, gédoté noy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“I étéwe témayakuf begom, tayakufé no so Begén. Atin i étéwe témayakuf Begén, tayakufé no soy Tuluse ménféuwit Begén. ");
INSERT INTO tiy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Atin i étéwe témayakuf bé sénarigoy Tuluse sabaf sénugu i Tuluse, gédoté noy barase ségiléw bé nan sarigon. Atin i étéwe témayakuf bé métintuwe étéw sabaf bé kétintuy adat ne, gédoté noy barase ségiléw bé nan métintu étéw. ");
INSERT INTO tiy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Atin béréhé ku begom i toowe, i étéwe miray fiyon ségétabu saén mélégénéy wayég dob ségétéwe gérifantad kuyug gu sabaf bé been i kuyug gu, tintu gédoté noy barase.” ");
INSERT INTO tiy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Amun énggilid i kétoro Jesuse bé de folo bra ruwo gétéw kuyugén, ménagéw mangéy dob de ingéd diyo inok témoro brab muret diyo. ");
INSERT INTO tiy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bé béno do gai, ménférisuy Juan Bautistawe. Atin amun énggélingoo noy fantage bé de rigoné Kristo, sénuguén i de dumo bé de kuyugén mangéy dob Beene inok ménginsa. ");
INSERT INTO tiy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Atin fénénginsaa ro maro, “Beeme bay no bénréh Juane gégumah ongot-ongoté key, taloo no ongot-ongot gey na ségiyo?” ");
INSERT INTO tiy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Atin séménumbul i Jesuse mano, “Séfule gom mangéy dob Juane brab uret gom i de énggito gom do rénigo gu brab de énggélingoo kom. ");
INSERT INTO tiy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","I de langafén énggégito ro, brab i de fikat énggéagéw ro, brab i de fémuteén ménadi-adi ro, brab i de bokongén énggégélingo ro, brab i de ménléhu méntébule ro. Atin ureté kuy Fiyowe Uret dob de méskinan. ");
INSERT INTO tiy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Atin béréh gom so dob Juane bé toow fo moror i étéwe énda ruwo-ruwoy kéféngintoow ne Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Amun ménséfule i de kuyug Juan, ménbéréh i Jesuse dob de médoo do étéw fantag bé Juane mano, “Ati nangéy gome ténéngténg dob gonone énda i étéw de bati? Ségétéw maak kéroon faniréy réfurehe? Békén, non i kéunur Juane énda méfélukén loo bé kéroone. ");
INSERT INTO tiy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aw ménangéy gom diyo inok angéyé kom téngténgén i ségétéwe lagéy toow fo fiyoy kégal ne? Békén, non i de étéw kémégal ro fiyo bati ro dob de toow fo fiyo lawi kay de datu. ");
INSERT INTO tiy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ati nangéy gome ténéngténg? Ségétéw étéw sénarigoy Tuluse muret? Hoo, éndob béréhé ku begom, i Juane békén saén sénarigon muret bé kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Non been i Juane niy fantage bé Ménsulate Kébéréh i Tuluse mano, ‘Sugué kuy sugu-sugué kuwe métah Beem. Been i témafaye bé kégumah me métah Beem.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Atin féntaus Jesusey kébéréh ne mano, “Béréhé ku begom i toowe, énda i toow na fo gérotor bé Juane bé kéluhanay de étéw ménumah. Endob dob gaiwe féguléwoy Tulusey de étéwén, i kéluhanay de térifantad étéw sakuf i Tuluse, toow ro na fo gérotor bé Juane béleewe ni. ");
INSERT INTO tiy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Bé énda séna témoro i Juane de, i Moisese brab de sénarigoy Tuluse nuret ron i fantage bé kéféguléw i Tuluse bé de étéwén. Atin tidéw dob gaiwe féngganaya Juaney kéuret ne taman so béleewe ni, médooy de étéw sétiboh inok fégésé ro mahur de. ");
INSERT INTO tiy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wén i kébéréh i de énggétah do sénarigoy Tuluse muret bé gégumah Eliase inok ureté noy kégumah Kristowe. Atin Juan i téménumane bé nan kébéréh. Fiyo ké géunur gom bé ni. ");
INSERT INTO tiy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mélaw fétuntay gom fo toow amuk méuyot gom de ké gésobuto kom i de ni. ");
INSERT INTO tiy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ati féségiléwo kuwe bé de étéw méuyag béni? Ségiléw gom bé de nga ménsar dob fadiyane brab mika ro mégérémét. Tabar i de dumo ro bero maro, ");
INSERT INTO tiy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘I begeye ménségagung gey, éndob énda ménsayaw gom. Brab léméninggéng gey linggéng ménléhuon, éndob énda kéménrew gom.’ ");
INSERT INTO tiy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Non ménangéy diniy Juan Bautistawe ménfuwasa brab énda méninémén arak. Brab bénréh i de étéw sénaitanan kun. ");
INSERT INTO tiy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Endob i Nga i Kéilawane, sani Begéne, ménangéyu dini, brab mamau atin minému. Brab ménbéréh i de étéw, ‘Ay niy ségétéwe étéw arumén mama brab miném arak, brab wén i dumo no do lémiful kémubra buwis brab do tete étéw.’ Endob i kégétigay Tuluse, énggiton toow fo métintu sabaf bé de rénigo no.” ");
INSERT INTO tiy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tidéw béno, dénowoy Jesusey de étéw dob de ingéd gono no réménigo médoo do mékégaif. Non énda fo ténagak roy de sala ro fiyon fo ké énggito roy de mékégaif rénigo Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ménbéréh mano, “Mékégédaw-gédaw gom do étéw bati dob Korasin, brab de begom do bati dob Betsaida. Buluk i de mékégaif rénigo gu dob begome ménrigo so dob de ingéd Tiro brab Sidon, ménrugayén damén i de étéw diyo kéménégal do saku brab rénigono ro awéw i de lowoh ro inok fégétiga roy énggésénule ro bé de sala ro. ");
INSERT INTO tiy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mélaw béréhé ku begom, dob gaiwe kémukum i Tuluse, toow na fo gétimal i kékukum ne begom bé kékukum ne bé de étéw dob Tiro brab Sidon. ");
INSERT INTO tiy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Brab begome do étéw bati dob Kafernaum, méuyot gom téfégérotor taman dob lawayo. Endob ibérén gom mangéy dob uleono emferno. Amuk i de mékégaif rénigo gu dob begome ménrigo so dob ingéde Sodom, énda damén ménbinasa no non énggésénule ro damén. ");
INSERT INTO tiy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Béréhé ku begom, dob gaiwe kémukum i Tuluse, toow na fo gétimal i kékukum ne begom bé kékukum ne bé de étéw dob Sodom.” ");
INSERT INTO tiy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bé béno, i Jesuse déménasal mano, “Abay, Kadnay lawayo brab fantade, fésalamata ku Beem non fénggétiga moy toowe dob de étéw énda i féngganad ro, brab bénunéyém i toowe dob de étéw do métilédtéd brab énggéféganad. ");
INSERT INTO tiy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hoo Abay, ménrigoy ni non kaam kétayan brab késuwatan.” ");
INSERT INTO tiy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tidéw béno, ménbéréh man i Jesuse dob de étéw mano, “Sénarig i Abay guwey kéluhanane dob Begéne. Enda i gétigan bé atiy Ngae saliyu bé Abaye. Brab énda i gétigan bé atiy Abaye saliyu bé Ngae, brab fiyon atiy kétayay Ngae fégétiga no de. ");
INSERT INTO tiy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“I kéluhana kome do lugotén gémalbék bé kéfukas gome bé de lowoh gom dob de sala gom, angéy gom dob Begéne atin fétéréné ku begom non fukasé ku begom. ");
INSERT INTO tiy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Unur gom Begén brab iring gom Begén. Non térifantadu mégédaw begom brab fétéréné ku begom. ");
INSERT INTO tiy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Non i de sugu gu begom toow fo magad, brab énda mérégén i de férigo gu begom.” ");
INSERT INTO tiy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Enda mérugayén tidéw béno, wén i no sébaan fuweh gai kétérén, i Jesuse brab de kuyugén téménara ro dob de médoo do faréy. Atin mélayaf i de kuyugén, mélaw méndot ro do faréy atin ménama ro. ");
INSERT INTO tiy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Endob i de Fariseo diyo, amun énggito roy ni rénigo ro, ménbéréh ro dob Jesuse maro, “Téngténgém! I de kuyugém fénlis roy kitab tome fantag bé gaiwe kétérén.” ");
INSERT INTO tiy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Séménumbul i Jesuse mano, “Aw énda ba énggébasana kom i rénigo Datu Dabide? Wén i no gai toow fo ménlayaf beroy de sundalo no. ");
INSERT INTO tiy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Atin ménahur ro dob lawi i Tuluse brab namaén i fane niray dob Tuluse beroy de sundalo no. Rénigo noy ni fiyon fo ké dob kitabe, fadi saén i fakaye mama bé ni fan. ");
INSERT INTO tiy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aw énda séna énggébasana kom i ni dob kitabé niray Moisese? Sénulatén bé fatut gémalbék i de fadi dob lawi i Tuluse sénga gai kétérén. Endob békén sala i ni. ");
INSERT INTO tiy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Béréhé ku begom, wén i ségétéwe étéw dini mas na balilaga bé lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wén i Ménsulate Kébéréh i Tuluse mano, ‘Mas na méuyotu de ké ségédaw gom bé kétulak gome.’ Amuk énggésobuto kom i ni, énda damén kukumé kom i de étéw énda i sala ro. ");
INSERT INTO tiy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Non i Nga i Kéilawane, sani Begéne, wén i kuwagib gu fantag bé ati fakaye dob gaiy kétéréne.” ");
INSERT INTO tiy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tidéw béno, méntékédan i Jesuse diyo atin ménagéw mangéy dob sébaane lawi féngadafan kay de Judio. ");
INSERT INTO tiy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Atin diyo soy ségétéwe lagéy ménsadil i ségébalae bé kémér ne. Atin diyo soy de étéw méuyot témbo bé Jesuse rémigo bé éndae fakay dob kitabe. Mélaw ménénginsa ro dob Jesuse maro, “Aw fakay ba dob kitab tomey muwae ké gai kétérén?” ");
INSERT INTO tiy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Atin séménumbul i Jesuse mano, “Ufama, buluk i bili-bili gome mélawu dob ménaléme kalut bé gai kétéréne, ati rigoné kome? Békén ba abangé kom inok géésut fiyon fo ké gai kétérén? ");
INSERT INTO tiy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Atin i étéwe toow na fo balilaga bé bili-biliwe! Mélaw fakay dob kitab tomey témabange fiyon fo ké gai kétérén.” ");
INSERT INTO tiy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tidéw béno, ménbéréh i Jesuse dob lagéye ni ménsadil i kémér ne mano, “Bétérém i kémér me.” Atin béntérén i kémér ne, atin sonom béno ménadi-adi loo bé ségébalae de. ");
INSERT INTO tiy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tidéw béno, i de Fariseo ménsut ro, atin ménséuret-uret ro bé ati kéféléhu ruwe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Atin énggétiga Jesusey de rigoné ro, mélaw méntékédan diyo. Atin ménfuray dob Beeney de médoo do étéw. Atin nuwaén i kéluhanay de déméruun bero. ");
INSERT INTO tiy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Endob sénuguén bero bé békén ureté roy fantage bé Beene dob de ségiyo étéw, ");
INSERT INTO tiy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","inok métuman i fénbéréh i Tuluse bé sénarigo nuwe muret féndawét Isaias mano, ");
INSERT INTO tiy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Beeney sugu-sugué kuwe fénémili gu. Toow fo kégédawa ku brab késuwata ku. Fédiyoé kuy Rémogor guwe dob Beene, atin ureté noy fantage bé kékukum guwe dob kéluhanay de étéw. ");
INSERT INTO tiy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Enda séédélén taloo no mégeng ké émbéréh, atin énda métanugén ké émbéréh dob de aguwon. ");
INSERT INTO tiy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Enda ikaa noy de étéw do maak fénréku férébong taloo no lémat-lémat solo. Yamula tabanga no bero. Atin fédayday taman géfétabana noy kétintuwe. ");
INSERT INTO tiy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Atin médooy de étéw dob séngae ingéd sémarig dob Beene.” Been i bénréh Isaiase. ");
INSERT INTO tiy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tidéw béno, wén i de étéw nuwit ro dob Jesusey ségétéwe langafén brab mow sabaf bé rénahukoy saitane. Atin nuwa Jesuse inok gégito brab gébéréh. ");
INSERT INTO tiy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Atin i kéluhanay de étéw ménggaif ro brab ménséfénginsa-nginsa ro maro, “Aw Been keeyén i séfu Datu Dabide, sani Kristowe ongot-ongoté tom?” ");
INSERT INTO tiy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Endob i de Fariseo, amun énggélingoo roy kébéréh i de étéw ni, ménbéréh ro maro, “Beelsebul, sani Satanase, odoroy de saitan, i ménirayane de barakat inok gédédél bé de saitan.” ");
INSERT INTO tiy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Endob énggétiga Jesusey de itunga ro, mélaw ménbéréh dob berowe mano, “Ufama, amuk i de étéw dob sébaane ingéd énda géséfagayun ro brab sétiboh ro, mébinasay nan ingéd. Taloo no i ségékurénge étéw dob sébaane lawi énda so géséfagayun ro brab sékérit ro, éndaén séko sétifon ro. ");
INSERT INTO tiy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mélaw buluk i Satanase démédél bé saitane, mésébaad ro brab énda so gétindég i fangangatura nuwe. ");
INSERT INTO tiy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bénréh guy ni non béréhé kom i démédélu saitan bé barakat i Satanase. Atin i fégédédél i de kuyug gom de, énda usaré roy barakat i Satanase. Mélaw fégitoy de kuyug gom békén ka Satanas i barakat guwe. ");
INSERT INTO tiy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Endob démédélu saitan bé barakat i Rémogor i Tuluse. Atin mélaw énggiton énggégumah dob begomey gaiwe méguléw i Tuluse dob de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tidéw béno, fénggétiga Jesuse bero bé toow na fo barakatan i Beene bé Satanase mano, “Ufama, i Satanase ségiléw bé ségétéwe émbagér étéw mantay bé lawi ne. Enda i ségétéw étéw géahur dob lawi i émbagére ni étéw atin tulisé noy tamuk ne taman énda na géikéto no de na métah. Tidéw béno, gétuliso noy kéluhanay tamuk ne. ");
INSERT INTO tiy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“I éndae modor Begén, sébanil Begén. Brab i éndae témabangan Begén, alangé no Begén. ");
INSERT INTO tiy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mélaw béréhé ku begom, i kéluhanay sala i de étéw brab de tete kébéréh ro, géfésagadan. Endob i émbéréhe tete fantag bé Rémogor i Tuluse, énda géfasagada no. ");
INSERT INTO tiy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","I émbéréhe tete fantag bé Nga i Kéilawane, sani Begéne, émfésagadan. Endob i émbéréhe tete fantag bé Rémogor i Tuluse, énda émfésagada no bé de ni gai taloo no dob de gai gégumah moso.” ");
INSERT INTO tiy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Atin ménbéréh man i Jesuse mano, “Ufama, i fiyowe kayéw mégonok bé fiyowe onok, atin i tetee kayéw mégonok bé tetee onok. I de séségiyo-giyo do kayéw gélolon ro dob onok ruwe. ");
INSERT INTO tiy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","I de begom maak do ulé gom. Enda gébéréh gom fiyo non toow gom fo tete. Non ati diyoe dob de fédéw gom, been soy nan i béréhéy de ba gom. ");
INSERT INTO tiy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","I métintuwe étéw rémigo fiyo, non i diyoe dob fédéw ne fiyo. Atin i tetee étéw rémigo tete non i diyoe dob fédéw ne tete. ");
INSERT INTO tiy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Atin béréhé ku begom, dob gaiwe kémukum i Tuluse, i séngae étéw mékukum sabaf bé de kébéréhén énda i lantékén. ");
INSERT INTO tiy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Non i de kébéréh gom, been i nan i fégékukume begom. Amuk i kébéréh gome fiyo, énda mékukum gom. Endob amuk tete, mékukum gom.” ");
INSERT INTO tiy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tidéw béno, wén i de Fariseo brab do témoro bé kitabé ménbéréh dob Jesuse maro, “Maistéro, méuyot gey de ké gito gey Beem rémigo mékégaif.” ");
INSERT INTO tiy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Atin ménbéréh i Jesuse dob berowe mano, “I begome do étéw méuyag béleewe ni, toow gom fo do tete brab békén gom méngintulus. Mongot gom sébaan mékégaif. Endob énda i féténg-téng de begom saliyu bé mékégaife loo bé ménrigowe dob Jonase, sani énggétahe sénarigoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Non i Jonase, ménbati téléw gétérésangan dob sur i toowe fo dakél sédo. Atin loo bé nan i Nga i Kéilawane, sani Begéne, batiu moso téléw gétérésangan dob bukag i fantade. ");
INSERT INTO tiy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Atin dob gaiwe kémukum i Tuluse, i de énggétah do étéw dob Ninibé témindég ro témbo begom do étéw méuyag béni. Non ménunur ro brab énggésénule ro bé uret Jonase. Endob béleewe ni, wén i mas na gérotor bé Jonase ay ni. Gido loo énda gésénule gom. ");
INSERT INTO tiy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Atin dob gaiwe kémukum i Tuluse, témindég i baiwe tidéw dob ingéde Seba, brab téboé no begom. Non séménugud tidéw dob mérayue inok fégélingoé noy kégétigay Datue Solomon. Endob béleewe ni wén i ségétéwe mas na gérotor bé Solomone ay ni.” ");
INSERT INTO tiy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ménbéréh man i Jesuse mano, “Buluk i saitane mésut tidéw dob étéwe rénahuko no, sémugud dob tikare gonon séméléd téréno no. Endob buluk énda i gito no téréno no, ");
INSERT INTO tiy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","émbéréh mano, ‘Séfuleu dob étéwe sungu gono ku ténagak gu.’ Tidéw béno, séfule brab gito noy tafaye ténidéwo no malinis brab métintu nén, non énda i saitan bati diyo. ");
INSERT INTO tiy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tidéw man béno, mésut brab muwit fitéw gétéw mas na tete saitan dumo no mahur dob no étéw brab bati ro diyo. Mélaw i no étéw toow na fo kéfasangan bé énggétahe goho no. Loo so bé nan i mérigowe dob de tete étéw méuyag béni.” ");
INSERT INTO tiy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","I lala Jesuse émbéréh séna dob de étéw, énggumah i idéng ne brab de tuwaréyén lagéy. Atin téménindég ro dob liyuwe brab nongot ro ké géségito ro de. ");
INSERT INTO tiy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mélaw wén i ménbéréhe dob Jesuse mano, “I idéng me brab do tuwaréyém diyo ro dob liyuwe. Méuyot ro géségito Beem.” ");
INSERT INTO tiy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Séménumbul i Jesuse mano, “Béréhé ku begom atiy idéng guwe brab do tuwaréy gu.” ");
INSERT INTO tiy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tidéw béno, ténénduén i de kuyugén brab ménbéréh mano, “Ay niy maake idéng gu brab do tuwaréy gu. ");
INSERT INTO tiy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Non i kéluhanay étéwe rigoné roy kétayay Abay guwe Tulus, beroy maake idéng gu brab do tuwaréy gu.” ");
INSERT INTO tiy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dob béno so gai, méntékédan i Jesuse tidéw dob lawie ni, brab ménangéy dob dogote atin ménsar dob dénsaane. ");
INSERT INTO tiy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Atin toow fo médooy étéwe ménlimud géliwét de. Atin non médoo ro, ménda i Jesuse dob awange ménsar diyo bé lala i de étéw diyo dob dénsaane. ");
INSERT INTO tiy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Atin ténoro Jesuse bero bé médoowe kétoro fén-agéw dob de binuwaya. Ménbéréh mano, “Wén i ségétéwe ménangéy sémabug bé béne ne. ");
INSERT INTO tiy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Atin amun sémanabug, i dumoy de béneén ménbigodoy dob doror i aguwone. Atin énggumah i de kloh manok nama ro. ");
INSERT INTO tiy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Atin i dumoy de béneén ménsawér dob fantade médooy de batéw de, éndob kloh saén i fantade de. Atin magad téménunoh i de béne non énda ménalém i fantade de. ");
INSERT INTO tiy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Endob amun sémbang i térésange, ménlaay i de nohokén brab ménléhu, non énda ménalém i darir ruwe. ");
INSERT INTO tiy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Atin i dumoy de béneén ménsawér dob fantade brab dob de duwaléy suwar énda séna témunoh ro. Ménruk mélaw i de suwar séréngan bé de nohok, atin ménléhu i de nohok non lénimfung i de suwar. ");
INSERT INTO tiy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Endob i dumoy de béneén ménsawér dob fiyowe fantad. Atin i de ni nohok ménggonok ro médoo taman téléw folo takéf, ném folo takéf, brab mératu takéf i séngae sébaan béne.” ");
INSERT INTO tiy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Atin féntaus Jesusey kébéréh ne mano, “Fégitung gom i fantage bé ni bénréh gu begom amuk méuyot gom de ké gésobuto kom.” ");
INSERT INTO tiy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tidéw béno, ménangéy i de kuyugén dob Jesuse atin fénénginsaa ro maro, “Sedek minuwaya go dob de étéw ké ureto mo bero?” ");
INSERT INTO tiy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Séménumbul i Jesuse mano, “Dob begome do kuyug gu, Tulus i émfégétigane begom fantag bé kéféguléw ne bé de étéwén. Endob i de ni éntingayén ménbunéy, énda émfayagén dob de ségiyo étéw. ");
INSERT INTO tiy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Non i étéwe munur bé kétoro guwe, umana kuy kétoro guwe de inok gésobut ro médoo. Endob i étéwe énda munurén bé kétoro guwe, dotén dob beeney kétoroe. ");
INSERT INTO tiy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","I de ségiyo étéw, bérého ku saén bero fén-agéw dob de binuwaya, inok fiyon fo ké téngténgé ro, énda gito ro de. Brab fiyon fo ké fégélingoé ro, énda gélingoo ro de brab énda gésobuto ro de. ");
INSERT INTO tiy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mélaw méntuman i Ménsulate Kébéréh i Tuluse nuret i sénarigo nuwe féndawét Isaias mano, ‘Fiyon fo ké témantu ro mégélingo, énda gésobuto ro de, brab fiyon fo ké témantu ro téméngténg, énda gito ro de. ");
INSERT INTO tiy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Non i de ni étéw, ménwaléy métégas i de fédéw ro, brab méntéléb i de kélingo ro, brab méntéléfédéng i de moto ro. Amuk énda, gégito ro brab gégélingo ro brab gésobuto ro. Atin waléy ro damén do munur dob Begéne atin mélaw fukasé ku damén bero dob de sala ro.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Atin féntaus Jesusey kébéréh ne mano, “Endob i begome, fatut moror gom, non gégitoy de moto gom brab gégélingo i de kélingo gom. Atin mélaw gésobuto kom. ");
INSERT INTO tiy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Non béréhé ku begom i toowe, médooy de sénarigoy Tuluse muret bé kébéréh ne brab de ségiyo métintu étéw toow fo ménuyot gégito bé énggito gome do rénigo gu. Brab ménuyot ro fo gégélingo bé énggélingoo kome do kétoro gu. Endob énda énggito ro de brab énda énggélingoo ro de. ");
INSERT INTO tiy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Fégélingo gom i atag i binuwayae fantag bé sémabuge. I atag i ni béne, been i kébéréh i Tuluse. Atin i de ségiyo-giyo gékélasi do fantad ségiléw bé de ségiyo-giyo gékélasi do étéw. Atin i sémabuge ureté noy kébéréh i Tuluse dob de ségiyo-giyo do étéw. ");
INSERT INTO tiy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Wén i do étéw énggélingoo roy fantage bé kéféguléw i Tuluse, éndob énda gésobuto ro de. Enggumah i Satanase inok kédané noy de kébéréh énggélingoo ro. Fénggiring ro bé de béne ménbigodoy dob doror i aguwone brab nama i de kloh manok. ");
INSERT INTO tiy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Atin ay ni atag i de béne ménsawér dob fantade médooy de batéw de. Fénggiring ro bé de étéw énggélingoo roy kébéréh i Tuluse brab ménoror ro de témayakuf. ");
INSERT INTO tiy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Endob énda méégét i kéunur ruwe. Mélaw amuk kérégénan ro loo ké mérasay ro sabaf bé kébéréhe ni, énda taus ro modor de. Ségiléw ro bé de nohok énda i do darir ro, non mélaay ro ké méduf i térésange. ");
INSERT INTO tiy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Atin ay niy atag i de béne ménsawér dob de duwaléy suwar. Fénggiring ro bé de étéw énggélingoo roy kébéréh i Tuluse éndob ténagak ro non ménangga ro saén bé de kébuku ro bé de kéfaguyag ro brab kéuyot ruwe waléy kawasa dob ni duniya. Ségiléw ro bé de nohok ménléhu non ménéfuk ro bé de suwar. Enda mélaw ménggonok ro. ");
INSERT INTO tiy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Endob ay niy atag i de béne ménsawér dob fiyowe fantad. Fénggiring ro bé de étéw énggélingoo roy kébéréh i Tuluse brab énggésobuto ro. Atin munur ro de, mélaw rénigo roy kétayay Tuluse ségiléw bé kéfégonok i de nohok dob fiyowe fantad médooy de onok ro. I de dumo étéw rénigo roy fiyowe, i de dumo bero rénigo roy médoowe fiyo, brab i de dumo bero rénigo roy toowe fo médoo fiyo.” ");
INSERT INTO tiy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Atin ménuret man i Jesuse sébaan binuwaya mano, “I kéféguléw i Tuluse loo bé ni. Wén i ségétéwe lagéy wén i safadén. Atin sénabugén i fiyowe béneén diyo. ");
INSERT INTO tiy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Endob wén i étéwe sébanil bé ni lagéy. Mélaw wén i no sébaan kélungonon, ménangéy i sébanile de étéw dob safad ne bé lala i kéluhanay de étéw fidong. Atin séménabug so do onok kéroon dob safade ni. Tidéw béno, ménraréy. ");
INSERT INTO tiy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mélaw amun téménunoh i de nohok brab ménggonok téménunoh soy de kéroon séréngan bero. ");
INSERT INTO tiy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Atin i de sugu-suguéy ni lagéy ménangéy ro dob beene brab ménénginsa ro maro, ‘Amu, aw békén ba séménabug go fiyo béne dob safad me? Sedek ménsélawék i de kéroon de?’ ");
INSERT INTO tiy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Atin séménumbul i gefee de mano, ‘Rénigoy ségétéwe sébanil begén.’ Atin ménénginsa man i de sugu-suguén ni maro, ‘Aw méuyot go de ké angéyé key randutén i de kéroon de?’ ");
INSERT INTO tiy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Séménumbul i gefee de mano, ‘Kagom. Non amuk randuté kom i de kéroon de, géranduto kom soy de dumo bé de nohok faréy. ");
INSERT INTO tiy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Fédaya gomén méruk i de kéroon séréngan bé de faréy taman bé gaiy kékétéwe de. Tidéw béno, béréhé ku bé de kémétéw de maku, Randut gom sunguy de kéroon. Tidéw béno, timu gom brab raga gom inok tuwégén dob aféye. Tidéw béno, kétéw gom i faréye brab fédiyo gom dob kiwot guwe.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Atin ménuret man i Jesuse sébaan binuwaya mano, “Ségiléw i kéféguléw i Tuluse bé sébaane toow fo kloh béne, éndot i étéwe brab nohokén dob safad ne. ");
INSERT INTO tiy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Fiyon fo ké toow fo kloh béne, amun téménunoh brab ménruk, ménwaléy toow fo dakél kayéw bé kéluhanay de nohokén. Atin fiyon i de kloh manok sémalag ro dob de fongo no.” ");
INSERT INTO tiy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Atin ménuret man i Jesuse sébaan binuwaya mano, “Atin i kéféguléw i Tuluse ségiléw bé fégéfééruke fan. Endot i libune brab sénlawékén dob téléwe géasad arinah taman ménruk i kéluhana nuwe.” ");
INSERT INTO tiy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","I de ni, téménoro i Jesuse dob de ménsélimud do étéw fén-agéw dob de binuwaya. Enda i sébaan uret bénréhén bero ké békén fén-agéw dob binuwayae. ");
INSERT INTO tiy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Rénigo noy ni inok métuman i Ménsulate Kébéréh i Tuluse nuret i sénarigo nuwe mano, “Ureto kuy de étéw dob de binuwaya. Atin béréhé ku beroy de ménbunéy tidéw féganay bé kélimbag i duniyae.” ");
INSERT INTO tiy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tidéw béno, i Jesuse ténagakén i de ménlimud ni do étéw atin ménahur dob lawie. Tidéw béno, i de kuyugén ménfégédét ro dob Beene brab ménbéréh ro maro, “Béréhém begey i atag i binuwayae fantag bé de kéroon dob safade.” ");
INSERT INTO tiy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Atin séménumbul i Jesuse mano, “I lagéye séménabug bé béne ne dob safad ne, been i Begéne, sani Nga i Kéilawane. ");
INSERT INTO tiy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Atin i safade, been i duniyae ni. Atin i fiyowe do béne, beroy de munur bé Tuluse brab fédayaé roy Tuluse méguléw bero. Atin i de kéroon, beroy de békén méngintulus. Satanas i méguléwone bero. ");
INSERT INTO tiy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Atin i sébanile étéw séménabug bé de kéroon, been i Satanase. Atin i kékétéwe, been i tamfaday duniyae ni. Atin i de kémétéw de, beroy de télaki. ");
INSERT INTO tiy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","I de kéroon timuén brab tuwégén dob aféye. Ségiléw so bé niy mérigowe dob tamfaday duniyae ni. ");
INSERT INTO tiy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","I Nga i Kéilawane, sani Begéne, sugué kuy de télaki gu. Atin timué roy de tete étéw brab de ménfésala bé de dumo ro. Atin féganané no bero tidéw dob de étéw fédayaé roy Tuluse méguléwon bero. ");
INSERT INTO tiy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Atin ibéré ro bero dob uleono emferno. Diyo kémérew ro brab kémigét i de kifé ro. ");
INSERT INTO tiy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tidéw béno, i de métintu do étéw réméndaw ro maak térésang dob kéféguléw i Abay ruwe Tulus. Fétuntay gom i ni ké méuyot gom de ké gésobuto kom.” ");
INSERT INTO tiy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Atin ménuret man i Jesuse do binuwaya mano, “I kéféguléw i Tuluse loo bé ni. Wén i do bélowon ménrugayén ménbunéy lénébéng dob fantade. Atin wén i ségétéwe étéw énggégito de. Tidéw béno, lénébéngén man. Atin toow fo moror, ménule brab fénbéléyén i kéluhanay languntama nuwe. Tidéw béno, ménséfule brab bénléyén i fantado no. ");
INSERT INTO tiy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Atin i kéféguléw i Tuluse loo bé ni. Wén i ségétéwe étéw démagang brab séméléd bé toowe fo balilaga perias. ");
INSERT INTO tiy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Amuk gégito sébaan perlas toow fo balilaga, ménagéw brab fébéléyén i kéluhanay languntama nuwe brab béléyé noy perlaso no. ");
INSERT INTO tiy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Atin i kéféguléw i Tuluse loo bé ni. Wén i fukéte lénawu dob bukag i dogote. Atin médooy de séségiyo-giyo do sédo géahur de. ");
INSERT INTO tiy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Atin amuk ménféno, i de fatatugés bégéngé ro mangéy dob fédoror i dogote. Tidéw béno, mésar ro inok féganané roy de sédo. Ahuré roy de fiyo sédo dob baskete ahuron de. Endob ibéré roy de tete sédo. ");
INSERT INTO tiy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Loo so bé niy mérigowe dob tamfaday duniyae. I de télaki angéyé ro fégananén i de tete étéw bé de métintu étéw. ");
INSERT INTO tiy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Atin ibéré roy de tete étéw dob emfernowe. Diyo ro kémérew brab kémigét i de kifé ro.” ");
INSERT INTO tiy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tidéw béno, ménénginsa i Jesuse dob de kuyugén mano, “Aw gésobuto kom i de ni bénréh gu?” Atin séménumbul ro maro, “Hoo.” ");
INSERT INTO tiy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Atin ménbéréh man i Jesuse mano, “Mélaw i séngae témoro bé Ménsulate Kébéréh i Tuluse, féganadé ro soy kétoro guwe fantag bé kéféguléw i Tuluse, gétoro bé tafaye brab mantuwe kétoro. Ségiléw mélaw bé ségétéwe étéw usaré noy tafaye brab mantuwe insodén.” ");
INSERT INTO tiy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Amun énggilid i Jesuse muret bé de ni binuwaya, méntékédan diyo. ");
INSERT INTO tiy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Atin ménule mangéy dob ingéd ne. Atin diyo téménoro dob lawie féngadafan kay de Judio. Atin i kéluhanay de énggégélingo bé kétoro ne toow ro fo ménggaif. Atin ménséfénginsa ro maro, “Ati tidéwoy kégétigay ni étéw témoro? Ati tidéwoy barakat ne rémigo bé de mékégaif ni? ");
INSERT INTO tiy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aw békén ba, Been i Nga i fandaye rémigo lawi? Aw békén ba Maria i idéng ne? Atin békén ba Santiago brab Jose brab Simon brab Judas i de tuwaréyén? ");
INSERT INTO tiy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Békén ba i de libu no bati so dini? Tidéwoy kégétiga nuwe de, loo soy barakat ne?” ");
INSERT INTO tiy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mélaw ménika ro de. Mélaw ménbéréh i Jesuse dob berowe mano, “I sarigoy Tuluse muret bé kébéréh ne, basanan dob kéluhanay de gonon saliyu saén dob kaane ingéd brab dob de kaan do samung brab dob de kaan do étéw sétifon lawi.” ");
INSERT INTO tiy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Atin énda réménigo no do médoo mékégaif diyo non énda méginugut ro de. ");
INSERT INTO tiy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bé béno, i Herode, sani méguléwe dob Galilea, énggélingoo noy de rénigo Jesus. ");
INSERT INTO tiy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Atin ménbéréh i Herode dob de sarigo no mano, “Been keeyén i Juan Bautistawe méntébule. Been keeyén i funa nuwe wén i barakatén rémigo do mékégaif.” ");
INSERT INTO tiy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bénréhén i ni non fénkéfoén i Juane, brab fénikétén, brab fénahurén dob férisunone. Rénigo noy ni sabaf bé ibo ne féndawét Herodiyas lénamfaén tidéw dob dumo nuwe sétiman idéng féndawét Filipi. ");
INSERT INTO tiy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","I Herode fénférisu noy Juane non dénowoy Juane mano, “Fénlisém i kitabé non énda damén fatut bawagé moy bawag i dumo muwe.” ");
INSERT INTO tiy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mélaw i Herode ménuyot méméléhu bé Juane, éndob ménggilak bé de Judio non kénarang roy Juane ségétéw sénarigoy Tuluse muret. ");
INSERT INTO tiy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Endob amun réménigo karagiya i Herode fégétédémo no bé kéumah ne, ménsayaw i kénogo Herodiyase dob adafay de médoo do étéw diyo. Atin toow fo ménsuwat i Herode de. ");
INSERT INTO tiy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mélaw fénasada noy ni kénogon bé irayén dey atiy kétaya nuwe ongoté no. Atin rénigo noy safae dob beene. ");
INSERT INTO tiy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Atin fénbéréh i idéng i kénogone ni mano, “Uwit gom diniy uléw Juan Bautistawe dob biléwe, atin irayém begén.” ");
INSERT INTO tiy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tidéw béno, i Datu Herode toow fo méntete i fédéw ne non mika damén rémigo bé ni. Endob non bé fasad ne rénigo no dob adafay de kana no, sénuguén bé iray dob kénogone ni. ");
INSERT INTO tiy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mélaw fénkéléngén i uléw Juane dob férisunone. ");
INSERT INTO tiy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Atin wén i ménuwit bé uléw ne dob biléwe brab nirayén dob kénogone ni. Tidéw béno, nuwitén dob idéng ne. ");
INSERT INTO tiy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Atin i de kuyug Juan nangéy roy bangkay ne brab lénébéng ro. Tidéw béno, ménangéy ro dob Jesuse brab fénggétiga ro de. ");
INSERT INTO tiy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Atin amun énggélingoo Jesusey ni uret fantag bé kéléhu Juane, méntékédan diyo brab ménda dob awange mangéy dob géfélébue gonon. Endob amun énggélingooy de étéw i ayo Jesuse, méntékédan ro dob de ingéd ro atin ménémantad ro ménggéta ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Amun téménéfadén i Jesuse, énggito noy de médoo ni do étéw ménlimud. Atin ménuray i na nuwe bero brab nuwaén i de déméruun bero. ");
INSERT INTO tiy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Amun témégénén i de kuyugén ménangéy ro dob Beene brab ménbéréh ro maro, “Enda i lawi dini, atin témégénén béni. Féagéw mon bero inok mangéy ro dob de ingéd gédét dini. Diyo gébéléy ro amaé ro.” ");
INSERT INTO tiy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Endob ménbéréh i Jesuse mano, “Enda kailanga roy magéwe. Iraya kom bero amaé ro.” ");
INSERT INTO tiy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Endob séménumbul i de kuyugén maro, “Enda i amaén dini saliyu bé limowe timan fan brab ruwo timan sédo.” ");
INSERT INTO tiy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Atin bang Jesuse, “Uwit gom dini.” ");
INSERT INTO tiy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Atin sénuguén i de étéw mésar dob de kéroon diyo. Tidéw béno, éndot Jesusey limowe timan fan brab ruwowe timan sédo, atin léménéngag dob lawayo brab ménfésalamat dob Tuluse. Tidéw béno, sénbaad-baadén i de fan brab nirayén dob de kuyugén. Atin sénaar ro dob de étéw. ");
INSERT INTO tiy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Atin i kéluhanay de étéw téménantu ro mama taman ménbésor ro. Tidéw béno, ténimu i de kuyug Jesus i de sama i de amaén brab ménféno i foloe bra ruwo timan dakél biton. ");
INSERT INTO tiy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","I kédooy de étéw ménama limo ngibu ro do lagéy saliyu bé de libun brab do nga. ");
INSERT INTO tiy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tidéw béno, fénéda Jesusey de kuyugén dob awange, atin féntahén bero mangéy fingé difar bé dogote, bé lala ne émféule bé de médoo ni do étéw. ");
INSERT INTO tiy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Atin amun énggéféuleo noy de étéw, ménénagé dob burure énda i dumo no inok démasal. Amun kélungononén, diyo i Jesuse dob burure énda i dumo no. ");
INSERT INTO tiy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bé béno, i awange diyoén dob kérara i dogote. Atin kérégénan i de kuyugén non énggébéla i de bagél dob awang ruwe, non rumfakéy réfuruhe. ");
INSERT INTO tiy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Amun lingkuwog mangéy fuweh, ménangéy i Jesuse dob berowe ménagéw dob rotor i wayége. ");
INSERT INTO tiy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Atin i de kuyugén, amun énggito roy Jesuse magéw dob rotor i wayége, toow ro fo ménggilak. Ménkes ro sabaf bé kégilak ruwe brab maro, “Ménayam!” ");
INSERT INTO tiy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Endob sonom béno, ménbéréh i Jesuse mano, “Kagom mégilak! Begén. Fétana gom i de fédéw gom.” ");
INSERT INTO tiy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tidéw béno, ménbéréh i Pedrowe mano, “Kadnan, amuk tintu Beem, féagéwém so begén dob rotor i dogote mangéy dob Beeme.” ");
INSERT INTO tiy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Atin bang Jesuse, “Enggon.” Mélaw méntéfor i Pedrowe tidéw dob awange atin ménagéw dob rotor i wayége saréw dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Endob amun énggétérédama noy émbagére réfuruh, ménwaléy mégilak, atin minut méléd dob dogote. Atin ménkes mano, “Kadnan, tabangénu.” ");
INSERT INTO tiy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sonom béno, béntér Jesusey kémér ne atin génamakén i Pedrowe. Atin ménbéréh i Jesuse mano, “Toow fo kloh i kéunur me. Sedek ruwo-ruwoy fédéw me?” ");
INSERT INTO tiy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tidéw béno, ménda ro dob awange, atin téménrén i réfuruhe. ");
INSERT INTO tiy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Atin i de kuyugén dob awange fénéngadaf roy Jesuse brab ménbéréh ro maro, “Tintu fo Beem i Nga i Tuluse!” ");
INSERT INTO tiy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Atin méntaus ro mifar dob dogote brab énggumah ro dob ingéde Genesaret. ");
INSERT INTO tiy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","I de étéw diyo énggélolo roy Jesuse. Mélaw fénsamfay roy kébéréhe dob de déméruun dob de ingéd géliwét brab nuwit ro dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Atin nongot roy Jesuse bé tungkasé noy de déméruun fiyon gékuwaha ro saén damén i tamanay kégal ne. Atin i kéluhanay de énggékuwah de, ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tidéw béno, wén i do Fariseo brab do témoro bé kitabé ménangéy dob Jesuse tidéw Jerusalem. Ménénginsa ro maro, ");
INSERT INTO tiy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sedek i de kuyugém énda odoro roy adat tome tidéw dob de katufua tom? Non énda méguse ro ké mama ro loo bé adat tome.” ");
INSERT INTO tiy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Atin séménumbul i Jesuse mano, “Sémuliu ménginsaan begom. Sedek félisé kom i de sugu i Tuluse inok odoro kom i kagome kétoro? ");
INSERT INTO tiy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Non ménbéréh i Tuluse mano, ‘Basana moy abay me brab idéng me.’ Atin ménbéréh so mano, ‘Buluk wén i ségétéw émbéréh tete fantag bé abay ne look idéngén, fatut féléhuén.’ ");
INSERT INTO tiy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Endob i begome, témoro gom bé amuk wén i ségétéw kérégénan i abay ne look idéngén, brab wén i fégétabangén irayén damén, fakay émbéréh mano, ‘Kay Tulusey ni.’ ");
INSERT INTO tiy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mélaw dob kétoro gome, éndaén kailangay de étéw i masanane bé de lukés ro. Mélaw ténagak gom i kébéréh i Tuluse inok odoro kom i kagome kétoro. ");
INSERT INTO tiy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Enda toow i kéunur gome bé Tuluse, ubo-ubo saén. Toow i kébéréh Isaiase, sani ségétéwe sénarigoy Tuluse muret bé kébéréh ne, amun sénulatén i fantage bé begome mano, ");
INSERT INTO tiy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bang i Tuluse, basanay de ni do étéw Begén dob kébéréh ruwe saén. Endob énda munur ro Begén dob de fédéw ro. ");
INSERT INTO tiy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Enda i atag i kéféngadaf ruwe Begén, non toroé roy de sugu rénigoy kéilawane brab béréhé ro tidéw dob Begéne.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tidéw béno, ténawag Jesusey de étéw mangéy dob Beene. Atin ménbéréh dob berowe mano, “Fégélingo gom Begén brab fégésobut gom. ");
INSERT INTO tiy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","I funay de étéw waléy mékérésik dob adafay Tuluse, békén sabaf bé atiy amaé ruwe. Yamula, i de tete kébéréh ro mésut tidéw dob de ba roy funa ruwe waléy mékérésik dob adafay Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tidéw béno, ménfégédét i de kuyugén dob Jesuse, atin ménbéréh ro maro, “Gétiga mo, i de Fariseo méntete i de fédéw ro sabaf bé kébéréh ma nan?” ");
INSERT INTO tiy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Endob séménumbul i Jesuse mano, “Mékédan i de békén katabuwan kétoro ro békén tidéw dob Abay guwe Tulus, ségiléw bé ségétéwe rémandut bé de kéroon géliwét bé de nohokén. ");
INSERT INTO tiy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Fédaya gom bero. Maak do langafén ro marak bé de dumo ro langafén. Atin amuk wén i langafén marak bé ségétéwe so langafén, ruwo ro mélawu dob kalute.” ");
INSERT INTO tiy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Atin ménbéréh i Pedrowe mano, “Fékéntayém dob begeyey nan binuwaya.” ");
INSERT INTO tiy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Atin bang Jesuse, “Aw énda séna wayo gésobuto kom de? ");
INSERT INTO tiy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","I funay Tuluse énda mésuwat bé de étéw békén sabaf bé de amaé ro. Non i amaéy étéwe, mahur dob sur ne brab taus so mésut tidéw dob lowoh ne. ");
INSERT INTO tiy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Endob i de tete kébéréh mésut tidéw dob ba i étéwe, tintu fo tidéw dob fédéw ne. Atin been i niy funay étéwe waléy mékérésik dob adafay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Non tidéw dob tetee fédéwén mésut i de tete kéfégitungén inok méméléhu, brab sétayan bé békéne bawagén, brab sébiga, brab ménakaw, brab témugi, brab témifu. ");
INSERT INTO tiy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Been i niy funay de étéw waléy mékérésik dob adafay Tuluse. Endob fiyon fo ké énda méguse i étéwe loo bé adat tome do Judio ké mama, énda waléyén mékérésik dob adafay Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tidéw béno, méntékédan i Jesuse diyo brab ménangéy dob de ingéd gédét dob Tiro brab Sidon. ");
INSERT INTO tiy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Atin wén i ségétéwe libun békén Judio bati diyo. Been i séfu i de étéw tidéw Kanan. Atin ménfégédét dob Jesuse. Atin ménbéréh métanug mano, “Séfu Datu Dabid, fégédawanu! I kénogo kuwe rénahukoy saitane atin mélaw toow fo kéfasangan.” ");
INSERT INTO tiy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Endob ménantés i Jesuse brab énda sénumbulo noy libune ni. Tidéw béno, i de kuyugén ménangéy ro dob Jesuse brab nongot ro maro, “Féagéwém i ni libun non toow fo selekén furay betom.” ");
INSERT INTO tiy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tidéw béno, bénréh Jesuse mano, “Sénuguu saén mangéy témabang bé de Judio non ségiléw ro bé de méntadin do bili-bili.” ");
INSERT INTO tiy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tidéw béno, i libune ni ménfégédét brab léméningkuwéd dob adafa nuwe. Atin ménfégédaw-gédaw mano, “Maistéro, tabangénu.” ");
INSERT INTO tiy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tidéw béno, nuret Jesusey sébaane binuwaya inok fégétiga no de bé tabangé noy de Judio sungu, atin tidéw béno tabangé noy de békén Judio. Ménbéréh mano, “Enda fatutén ké dotén i amaéy de nga atin ibérén dob de itu.” ");
INSERT INTO tiy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Endob ménbéréh i libune ni mano, “Toow, Maistéro, éndob fiyon foy de itu géamaa roy de mumu mélawu tidéw dob amaéy gefee de.” ");
INSERT INTO tiy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tidéw béno, ménbéréh i Jesuse mano, “Di, méégét i kéunur me fo toow. Mélaw rigoné kuy nan ongoté mo.” Atin bé no so uras i kénogo nuwe ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tidéw béno, ménagéw i Jesuse ménémantad mangéy bé doror i dogote Galilea. Atin ménénagé dob burure brab ménsar diyo. ");
INSERT INTO tiy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Atin médooy de ménlimud do étéw ménangéy ro dob Beene, atin nuwit roy de fikat, brab do langafén, brab do ménsadil i de kémér ro brab de sékéy ro, brab do mow, brab do médoo so étéw do déméruun. Atin féndiyo ro bero dob adafa Jesuse. Atin nuwa Jesuse bero. ");
INSERT INTO tiy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Atin toow fo ménggaif i de étéw amun énggito roy de mow énggébéréh, brab de ménsadil do kémér ro ménadi-adi, brab de fikat énggéagéw, brab de langafén énggégito. Atin dénayéw roy Tuluse féngadaféy de Judio. ");
INSERT INTO tiy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tidéw béno, ténawag Jesusey de kuyugén mangéy dob Beene. Atin ménbéréh dob berowe mano, “Méuray i na guwe bé de étéw ni, non téléwén gétérésangan ro dob Begéne, atin béleewe ni ménétéyén i de amaé ro. Atin mikau émféule bero ké mélayaf ro non mésumba ro keeyén dob de aguwon.” ");
INSERT INTO tiy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Atin ménénginsa i de kuyugén maro, “Ati kéfingé-fingé i kéféama geye bé de médoo ni do étéw dob ni gonon mérayu tidéw dob de lawi?” ");
INSERT INTO tiy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Atin i Jesuse fénénginsaa no bero mano, “Firoy timan i fa koman?” Séménumbul ro maro, “Fitéw timan brab wén soy koy kloh de kloh sédo.” ");
INSERT INTO tiy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tidéw béno, i Jesuse sénuguén i de ménlimud do étéw mésar dob fantade. ");
INSERT INTO tiy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Atin éndotén i fitéwo no timan fan brab do sédo, brab ménfésalamat dob Tuluse. Tidéw béno, sénbaad-baadén, brab nirayén dob de kuyugén. Atin sénaar ro dob de étéw. ");
INSERT INTO tiy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Atin i kéluhanay de étéw téménantu ro mama taman ménbésor ro. Tidéw béno, i de kuyugén ténimu roy de sama i de amaén brab ménféno i de fitéw timan biton. ");
INSERT INTO tiy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","I kédoo ruwe do ménama fot ro ngibu do lagéy saliyu bé de libun brab de nga. ");
INSERT INTO tiy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tidéw béno, fénule Jesusey de ménlimud do étéw. Tidéw man béno, ménda dob awange atin ménagéw mangéy dob ingéde Magadan. ");
INSERT INTO tiy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wén i no sébaan fuweh, wén i do Fariseo brab do Saduseo ménangéy dob Jesuse. Ménuyot ro téméngkad bé Jesuse. Mélaw nongot ro dob Beene rémigo mékégaif inok fégito no tidéw dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Endob séménumbul i Jesuse mano, “Amuk gito gom furoy lawaye ké méléd i térésange, émbéréh gom makom, ‘Enda rémanaén démo.’ ");
INSERT INTO tiy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Atin buluk gito gom furo brab délémon i lawaye ké sémbang i térésange, béréhé kom makom, ‘Rémana séko.’ Mélaw gétiga kom i atag i de tanda dob de rawén. Endob énda gétiga kom i atag i de tanda dob de ni do gai. ");
INSERT INTO tiy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","I begome do étéw méuyag béni, toow gom fo tete brab békén gom méngintulus. Ongoté kom ké rémigowu mékégaif inok gétiga kom Begéney Kristowe. Endob énda i féténgténg gu begom saliyu bé sébaane mékégaif ségiléw bé ménrigowe dob Jonase bé do gétah.” Tidéw béno, ténagak Jesuse bero brab ménagéw. ");
INSERT INTO tiy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tidéw béno, i de kuyug Jesuse ménifar ro dob dogote. Endob énggélifoto roy muwite fan. ");
INSERT INTO tiy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Atin nuret Jesuse beroy sébaane binuwaya fantag bé de tete adatén do étéw. Ménbéréh mano, “Ingat gom brab sénggila gom i fégéfééruke fan kay de Fariseo brab kay de Saduseo.” ");
INSERT INTO tiy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Endob i de kuyugén, énda énggésobuto roy ni binuwaya. Marok bénréh Jesusey fantage bé tintuwe fégéfééruk fan. Mélaw ménségéno-géno ro falan saén bero maro, “Bénréhén i ni non énda i fa tom.” ");
INSERT INTO tiy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Endob i Jesuse énggétiga noy de kébéréh ro. Mélaw ménbéréh mano, “Sedek ségéno-géno gom fantag bé kékulang i fa tome? Toow fo kloh i kéunur gome. ");
INSERT INTO tiy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aw énda séna énggésobuto kom de? Aw énggélifoto kom i rénigo guwe? Amun sénbaad-baad guy de limo timan do fan dob de limo ngibu do lagéy, firoy gébiton i énggétimuo kome samaén? ");
INSERT INTO tiy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Atin amun sénbaad-baad guy de fitéw timan do fan dob de fot ngibu lagéy, firoy gébiton i énggétimuo kome samaén? ");
INSERT INTO tiy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Sedek énda séna énggésobuto kom i békén fantag bé faney bénréh guwe? Ingat gom brab sénggila gom i fégéfééruk i de Fariseo brab de Saduseo.” ");
INSERT INTO tiy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tidéw béno, i de kuyugén énggésobuto ro bé féingaté Jesuse bero bé kétoro i de Fariseo brab de Saduseo. Atin énggétiga ro békén nuretén i fantage bé tintuwe fégéfééruk fan. ");
INSERT INTO tiy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wén i no sébaan fuweh, i Jesuse ménagéw gédét dob ingéde Sesarea Filipo. Diyo fénénginsaa noy de kuyugén mano, “Ati kébéréh i de étéw ké ati Begéne ni, sani Nga i Kéilawane?” ");
INSERT INTO tiy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Séménumbul ro maro, “Wén i do ménbéréh maro, Juan Bautista go kun. I de dumo de maro, Elias go kun. Brab i de dumo de maro, Beemey Jeremiase kun, taloo no ségétéw bé de gétah sénarigoy Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tidéw béno, ménénginsa i Jesuse man mano, “Dob begome, ati kébéréh gome fantag bé Begéne?” ");
INSERT INTO tiy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","I Simon Pedrowe séménumbul mano, “Beemey Kristowe, Nga i méuyage Tulus.” ");
INSERT INTO tiy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Atin bang Jesuse, “Simon, nga Juan, fénfiyoy Tuluse beem. Non békén kéilawan i ménfégétigane beem bé ni. Yamula i Abay guwe Tulus i ménfégétigane de beem. ");
INSERT INTO tiy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Atin béréhé ku beem, beem i Pedrowe, atin dob batéwe ni fétindégé kuy simbaa kuwe. Enda méléhu i de étéw munur Begén loo bé kéunur me. ");
INSERT INTO tiy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Atin iray gu beem i aturane bé de étéw féguléwoy Tuluse. Mélaw ati sugué muwe énda fakayén rigonén dob fantade ni, énda so fakayén dob lawayo. Atin ati sugué muwe fakay rigonén dini dob fantade, fakay so dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tidéw béno, sénugu Jesuse dob de kuyugén bé békén ureté ro dob de ségiyo étéw ké Been i Kristowe. ");
INSERT INTO tiy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tidéw bé no gai, i Jesuse fénkéntayén i kébéréh ne dob de kuyugén mano, “Kailanga kuy mangéye Jerusalem brab diyo i de odoroy de Judio brab de odoroy de fadi brab de témoro bé kitabé, férasayé ro fo Begén toow. Atin wén soy do méméléhu Begén. Endob dob gétéléw ne gétérésangan, tébuleu.” ");
INSERT INTO tiy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sonom béno, i Pedrowe nuwitén i Jesuse mangéy dob géliyu-liyuwe inok bero saén, atin génléén mano, “Kadnan, énda damén fédayaéy Tuluse de mérigo dob Beemey ni bénréhém.” ");
INSERT INTO tiy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Endob sénaréw Jesusey Pedrowe atin ménbéréh mano, “Maak Satanas go! Férayu go Begén. Alangé mo Begén non i kéfégitung me békén tidéw dob Tuluse, yamula tidéw sa dob kéilawane.” ");
INSERT INTO tiy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tidéw béno, bénréh Jesuse dob de kuyugén mano, “Buluk atiy méuyote furay Begén, kailanga no diguré noy kaane kétayan inok odoro noy kétayay Tuluse. Tidéw béno, kailanga no fédayday bé de kérégénon ségiléw bé Begéne, fiyon fo ké féléhuén dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Non atiy méuyote émféraru bé umul ne, méléhu. Endob i méléhue bé kéfuray ne Begén, gédoté noy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ufama, fiyon fo ké i ségétéwe étéw gédoté noy kéluhanay éntingayéne dob duniyae ni, énda i lagaén buluk méléhu atin géangéy dob uleono emferno. Enda i fégébaliway étéwe de inok méuyag man. ");
INSERT INTO tiy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Non i Begéne, sani Nga i Kéilawane, séfuleu moso begey i de télaki gu, réméndawu bé barakat i Abay guwe Tulus. Atin bé béno gai, barasa kuy de étéw loo bé fatute sabaf bé de rénigo ro. ");
INSERT INTO tiy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Béréhé ku begom i toowe, wén i do dumo begom énda méléhu ro taman gito roy késéfule guwe inok méguléw.” ");
INSERT INTO tiy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ném gétérésangan tidéw bé béno, nuwit Jesusey Pedrowe brab Santiagowe brab Juane dumo Santiagowe sétiman idéng dob uruk i gérotore tuduk sébero-bero saén. ");
INSERT INTO tiy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Atin i falas Jesuse ménfégalin dob téngaanga ruwe. Réménéndaw i rangih ne maak térésang. Atin ménwaléy fute i kégal ne maak géfékaya. ");
INSERT INTO tiy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Atin i de ni kuyugén, métékow énggito ro soy Moisese brab Eliase sébéréh-béréh ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ménbéréh i Pedrowe dob Jesuse mano, “Kadnan, toow fo fiyo non dob ni tom. Amuk kétaya mo, rémigowu téléw timan dung-dung. Sébaan i kaame de, sébaan i ka Moisese de, brab sébaan i ka Eliase de.” ");
INSERT INTO tiy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Amun émbéréh sénay Pedrowe, méntégalung dob berowey réméndawe rawén. Atin wén i ménbéréhe tidéw dob rawéne mano, “Been i niy kénimuo kuwe Nga gu, toow fo kénsuwata ku. Fégélingo gom.” ");
INSERT INTO tiy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Amun énggélingooy de kuyugén i ni, toow ro fo ménggilak. Mélaw méntéléngkéb ro tédunsum. ");
INSERT INTO tiy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Endob i Jesuse fénggédéto no bero brab kénuwahén bero. Atin ménbéréh mano, “Tek gom brab kagom mégilak.” ");
INSERT INTO tiy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Amun léménéngag ro téméngténg, énda i saliyu énggito ro bé Jesuse saén. ");
INSERT INTO tiy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Atin bé lala ruwe léménudug tidéw dob tuduko no, sénugu Jesuse bero mano, “Kagom uretén i fantage bé ni énggégito gom taman tébuleu, sani Nga i Kéilawane.” ");
INSERT INTO tiy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tidéw béno, i de ni kuyugén ménénginsa ro dob Jesuse maro, “Sedek bénréh i de témoro bé kitabé bé kailanga Eliasey séfulee, tidéw béno méguléw i Kristowe?” ");
INSERT INTO tiy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Atin séménumbul i Jesuse mano, “Toow i nan bé fatut séfule i Eliase sungu inok tafayé noy kéluhanane. ");
INSERT INTO tiy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Endob béréhé ku begom, énggumahén i Eliase, éndob énda énggéloloy de étéw de. Yamula fénrasay ro loo bé kétaya ruwe. Atin loo so bé nan i kéférasay ruwe moso Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tidéw béno, i de ni kuyugén énggésobuto roy bénréh Jesuse fantag bé Juan Bautistawe. ");
INSERT INTO tiy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Amun ménséfule ro dob de ménlimud étéw, ménfégédét i ségétéwe lagéy dob Jesuse brab léméningkuwéd dob adafa nuwe. ");
INSERT INTO tiy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Atin ménbéréh mano, “Maistéro, fégédaw go bé nga guwe lagéy. Non rebengén brab toow fo kérasayan. Ségamét métuwar dob aféye brab mélawu dob wayége. ");
INSERT INTO tiy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nuwit gu dob de kuyugém, éndob énda géuwaa ro de.” ");
INSERT INTO tiy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Atin ménbéréh i Jesuse dob de ménlimud do étéw mano, “Enda sémarig gom bé Tuluse, brab toow gom fo do tete étéw. Lugoténun sétafik begom. Enda gétuwa ku de ké ati nay kérugay i kétingkél guwe sétafik begom. Uwit gom diniy ngao no.” ");
INSERT INTO tiy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Atin dénédél Jesusey saitane bé kébéréh ne. Mélaw ménraréy i saitane, atin sonom béno, ménadi-adiy ngae ni. ");
INSERT INTO tiy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tidéw béno, i de kuyugén ménangéy ro dob Jesuse sébero-bero saén. Atin ménénginsa ro maro, “Sedek énda géféféraréyo key i no saitan?” ");
INSERT INTO tiy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Séménumbul i Jesuse mano, “Non kulang foy kéunur gome. Béréhé ku begom i toowe, amuk wén saén i kloh kéunur gom ségiléw bé kékloh i oloy sabie, gébéréh gom dob tuduke ni makom, ‘Ay go diyoo.’ Atin magéw ba. Atin mélaw amuk wén i kéunur gom, gérigono kom i kéluhanay éntingayéne. ");
INSERT INTO tiy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Endob i ni klasi saitan, géféféraréyo kom saén bé kédasal gome brab kéfuwasa gome. Endaén i saliyu de fakay.” ");
INSERT INTO tiy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Amun ménlimud i de kuyug Jesus dob Galilea, bénréhén bero mano, “I Nga i Kéilawane, sani Begéne, fékéfo séko bé de étéw sébanil Begén. ");
INSERT INTO tiy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Atin féléhué ro Begén. Endob dob gétéléw ne gétérésangan, tébuleu.” Atin toow fo méntete i de fédéw i de kuyugén amun énggélingoo roy ni. ");
INSERT INTO tiy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Amun énggumah i Jesuse beroy de kuyugén dob Kafernaum, ménangéy dob Pedrowey de kémubra kurta kay lawi i Tuluse dob Jerusalem. Atin ménénginsa ro maro, “Aw mayad ba kurta i Maistéro gome kay lawi i Tuluse?” ");
INSERT INTO tiy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Séménumbul i Pedrowe mano, “Hoo, mayad.” Tidéw béno, amun ménahur i Pedrowe dob lawie, bénréh Jesuse sungu mano, “Simon, ati karang me de? Ati isuwe mayad buwis dob datue, do ngaén taloo no do ségiyo étéw?” ");
INSERT INTO tiy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Séménumbul i Pedrowe mano, “I de ségiyo étéw.” Atin ménbéréh man i Jesuse mano, “Amuk loo, énda kailangay de ngaén i mayade buwis dob datue. Atin mélaw énda so kailanga kuy mayade kurta kay lawi i Abay guwe Tulus. ");
INSERT INTO tiy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Endob énda méuyotu de ké mérarék Betoy de étéw ni. Mélaw ay go dob dogote atin duray go. Edotém i sunguwe sédo géduraya mo. Atin féténganga mo brab gito moy félatahe fakayén fégébayad i ruwowe gétéw dob lawi i Tuluse. Dotém brab bayada moy katowe de.” ");
INSERT INTO tiy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bé béno do gai, ménangéy i de kuyug Jesuse dob Beene brab ménénginsa ro maro, “Ati isuwe begey toow na fo gérotor dob kéféguléw i Tuluse?” ");
INSERT INTO tiy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tidéw béno, ténawag Jesusey ségétéwe nga atin féntindégén dob téngaanga ruwe. ");
INSERT INTO tiy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Atin bénréhén bero mano, “Béréhé ku begom i toowe, amuk énda émfégalin i de fédéw gom inok iringé kom i kétérifantad i de nga, énda géahur gom dob kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Non i toowe na fo gérotor bé de étéw féguléwoy Tuluse, been i gérifantade loo bé ngae. ");
INSERT INTO tiy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Atin atiy étéwe témayakuf bé ngae loo bé ni sabaf bé kéunur ne Begén, tayakufé no so Begén. ");
INSERT INTO tiy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Endob amuk wén i émfésala bé ségétéwe mantu séna munur dob Begéne loo bé ni nga, toow fo mékégédaw-gédaw. Toow fo gétimal ké mékukum, mélaw mas na fiyo dob beene ké ibérén dob dogote nikéton dakél batéw i reer ne. ");
INSERT INTO tiy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mékégédaw-gédaw i de étéw dob duniyae ni non wén i de éntingayén émfésala bero. Démoyun wén i do étéw émfésala bé de dumo ro. Endob mékukum ro fo toow moso. ");
INSERT INTO tiy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mélaw amuk been i kémér me taloo no sékéyém i funa muwe gésala, kéléngém brab ibérém. Non mas na fiyo ké gédoté moy umule magufusa ménkéléng i bala i kémér me taloo no sékéyém, bé géangéy go dob uleono emferno énda i kulang bé lowoh me. Non diyo wén i aféye énda émfandaén taman sa taman. ");
INSERT INTO tiy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Atin amuk i moto muwey funa muwe gésala, lésitém brab ibérém. Non mas na fiyo ké gédoté moy umule magufusa énda i bala moto mo, bé géangéy go dob emfernowe énda i kulang bé lowoh me. ");
INSERT INTO tiy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Atin kagom siyawén i de étéw gérifantad segiléw bé ni nga. Non béréhé ku begom, wén i karo télaki démiyaga bero, atin bati ro dob lawayo beroy Abay guwe Tulus. ");
INSERT INTO tiy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Non i Nga i Kéilawane, sani Begéne, ménangéyu dini inok fukasé kuy de étéw ménsala do maak do méntadin ro. ");
INSERT INTO tiy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Fégitung gom i fantage bé ni ufama. Wén i ségétéwe étéw wén i mératu bili-bili no. Endob méntadin i sébaane de. Ati rigoné nuwe? Tagaké noy siyowe de folo bra siyow dob fétabtabane, atin angéyé no sélédén i sébaane de méntadin. ");
INSERT INTO tiy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tidéw béno, buluk énggito no, toow fo moror. Béréhé ku begom, toow na fo moror sabaf bé nan sébaan méntadin bili-bili énggito no bé de siyow de folo bra siyow énda méntadin ro. ");
INSERT INTO tiy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ségiléw so bé ni, i Abay gome Tulus dob lawayo toow fo mika de ké wén i sébaan bé de ni gérifantad do méngintulus mékukum. ");
INSERT INTO tiy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Amuk wén i ségétéw dumo mo brab ménsala dob beeme, ay go dob beene inok sébegom-begom saén. Tidéw béno, toroém dey sala ne. Amuk gésénule de, tintu fo ténabanga mo séfule dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Endob amuk énda gésénuleén de, uwitém i ségétéwe taloo no ruwo gétéw bé de dumo mo séfule mangéy dob beene. Mélaw wén i dumo mo émbéréh toow i kébéréh me fantag bé sala ne. ");
INSERT INTO tiy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Endob amuk énda fo gésénuleén de, téboém dob kéluhanay de munur dob lawie féngadafan. Atin amuk énda na fo gésénuleén de, fiyon fo ké téboéy kéluhanay munure de, kagom séloyuk de maak ségétéw békén méngintulus look ségétéw lémiful kémubra buwis. ");
INSERT INTO tiy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Atin béréhé ku begom i toowe, amuk wén i sugué kom bé énda fakayén rigonén dob fantade ni, énda so fakayén dob lawayo diyo. Brab amuk wén soy sugué kom fakay rigonén dob fantade ni, fakay so dob lawayo diyo. ");
INSERT INTO tiy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Atin béréhé ku so begom, amuk wén i ruwo gétéw begom dob duniyae ni séfagayun bé kédasal gome, i Abay guwe Tulus dob lawayo rigoné no. ");
INSERT INTO tiy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Non fiyon fo ké wén saén i ruwo taloo no téléw gétéw sélimud méngadaf Begén, diyou so dob berowe.” ");
INSERT INTO tiy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tidéw béno, ménfégédét i Pedrowe brab ménénginsa mano, “Kadnan, amuk wén i dumo gu démoyunén gésala dob begéne, firoy gule fatut fésagada ku? Aw fésagada ku taman fitéw gule?” ");
INSERT INTO tiy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Séménumbul i Jesuse mano, “Médoo na gule tidéw bé nan. Kago térénon i émfésagade. ");
INSERT INTO tiy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ureté ku begom i sébaane binuwaya fantag bé kéféguléw i Tuluse. Wén i ségétéwe datu méguléw, éntukén i de utong i de sugu-sugué no dob beene. ");
INSERT INTO tiy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Atin amun féngganaya no, nuwitén dob beeney ségétéwe bé de sugu-sugué no, laksaén i utong ne. ");
INSERT INTO tiy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","I ni sugu-suguén énda gébayada noy utong ne. Mélaw i datue, fébéléyén i ni sugu-suguén brab bawag ne brab de ngaén, inok waléy ro do rifén. Brab i kéluhanay éntingayéne kaan, fébéléyén so inok gébayada noy utong ne. ");
INSERT INTO tiy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Endob ménlingkuwéd i ni sugu-suguén dob adafay datue, brab ménfégédaw-gédaw mano, ‘Tingkélonu na. Enda sénay kurta gu, éndob bayada ku so beem ké wén i kurta gu.’ ");
INSERT INTO tiy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ménuray i nay datue de. Mélaw fénsagada no, brab éndaén fénbayadén de. Tidéw béno, fénuleén. ");
INSERT INTO tiy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tidéw béno, i sunguwe ni sugu-suguén ménagéw brab énggébalaka noy ségétéwe bé de dumo no sugu-suguén, énggéutong dob beene kloh kurta. I ni sungu sugu-suguén génamakén i dumo nuwe ni dob reer ne brab kénrangén. Atin ménbéréh mano, ‘Bayadanu bé utong me begén!’ ");
INSERT INTO tiy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tidéw béno, ménlingkuwéd i géruwowe ni sugu-suguén, brab ménfégédaw-gédaw mano, ‘Tingkélonu na. Enda sénay kurta gu, éndob bayada ku so beem ké wén i kurta gu.’ ");
INSERT INTO tiy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Endob i sunguwe ni sugu-suguén énda fo fénggélingoén de. Yamula fénférisu no taman énda gébayada noy utong ne. ");
INSERT INTO tiy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Amun i de dumo sugu-suguén énggito roy ni ménrigo, toow fo méntete i fédéw ruwe de. Atin ménangéy ro dob datue ménlolok, brab nuret roy kéluhanay ménrigowe. ");
INSERT INTO tiy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tidéw béno, féntawag i datuey sunguwe ni sugu-suguén brab ménbéréh mano, ‘Toow go fo tete étéw. Fénsagada ku beem bé kéluhanay utong me begén non ménfégédaw-gédaw go. ");
INSERT INTO tiy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Fégédaw go so damén bé dumo muwe sugu-suguén loo bé kégédaw guwe beem.’ ");
INSERT INTO tiy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Toow fo ménkérit i datue, mélaw fénférisu noy ni sugu-suguén taman énda gébayada noy kéluhanay utong ne.” ");
INSERT INTO tiy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Atin féntama Jesusey ni binuwaya bé ni kébéréh mano, “Loo bé nan i kérigoy Boh guwe dob lawayo bé séngae ségétéw begom, buluk énda toow fo fésagada kom i de étéw énggésala dob begome.” ");
INSERT INTO tiy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tidéw béno, amun énggilid i Jesuse témoro bé de ni, ménagéw tidéw Galilea brab ménangéy dob sakuf i dakéle ingéd Judea dob difar i wayége Jordan. ");
INSERT INTO tiy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Atin ménfuray i de médoo do ménlimud do étéw. Atin diyo fén-adi-adi noy de déméruun bero. ");
INSERT INTO tiy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Atin wén i de Fariseo ménangéy dob Beene inok téngkadé ro inok gésumbulo no bero bé békéne damén katabuwan. Ménénginsa ro maro, “Aw fakay dob kitab tome ké gélakéy lagéyey bawag ne sabaf bé de udenén do funa no?” ");
INSERT INTO tiy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Atin séménumbul i Jesuse mano, “Aw énda séna énggébasana kom i Ménsulate Kébéréh i Tuluse mano, ‘Dob féganaye, amun léménimbag i Tuluse, rénigo noy ségétéwe lagéy brab ségétéwe libun.’ ");
INSERT INTO tiy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Atin bang i Tuluse, ‘Been i niy funay lagéye témagak bé boh ne brab idéng ne atin sétifon bé bawag ne. Atin mélaw i ruwowe gétéw waléy ro ségétéw.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Atin féntaus Jesusey kébéréh ne mano, “Mélaw éndaén ruwo ro gétéw non ménwaléy ron maak sébaan. Mélaw békén fatut ké fésésuwayéy kéilawane bero, non Tulus i ménféwaléye bero ségétéw.” ");
INSERT INTO tiy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tidéw béno, ménénginsa man i de Fariseo maro, “Sede mélaw ké niray Moisesey sugue bé fakay gélakéy lagéyey bawag ne amuk iraya no sulat bé kégélak ne de, tidéw béno fakayén féagéwé no?” ");
INSERT INTO tiy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Séménumbul i Jesuse mano, “Niray Moisesey nan sugu non toow fo métégas i de uléw gom. Endob bé gétaho, amun lénimbag i Tulusey de étéw, énda ténungkas i Tulusey de ménsébawag ségélak. ");
INSERT INTO tiy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mélaw béréhé ku begom, ati lagéye gémélak bé bawag ne saliyu bé kébigae funa no de, atin mawag ségiyo libun, énggélamfa.” ");
INSERT INTO tiy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tidéw béno, ménbéréh i de kuyugén maro, “Amuk loo bé nan i késébawage, i ségétéwe étéw mas fiyo ké énda mawagén.” ");
INSERT INTO tiy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Atin bang Jesuse, “I kétoroe ni békén kay kéluhanay de étéw. Yamula kay do étéw saén fénémili i Tuluse inok énda mawag ro. ");
INSERT INTO tiy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wén i de séségiyo-giyo do funay de étéw énda mawag ro. Wén i de étéw énda gébawag ro non ménsadil ro tidéw fanay kéumah ro. Wén soy do kafun de. Atin wén soy do étéw énda mawag ro inok mégéror ro gémalbék témoro fantag bé kéféguléw i Tuluse bé de étéwén. Mélaw amuk fénémili i Tuluse beem inok énda mawag go, odoro mo.” ");
INSERT INTO tiy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wén i no sébaan fuweh, wén i do étéw ménuwit bé de nga ro dob Jesuse inok tégéné no bero bé lala ne démasalan bero. Endob amun énggitoy de kuyugén, génlé roy de étéw ni. ");
INSERT INTO tiy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Endob ménbéréh i Jesuse mano, “Féangéy gom i de kloh nga dob Begéne. Brab kagom alangén bero, non i de étéw sémarig loo bé késarig i de ni do nga, féguléwoy Tuluse bero.” ");
INSERT INTO tiy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Atin ténégé noy de nga ni brab fénfiyo no bero. Tidéw béno, ménagéw i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wén i no sébaan fuweh, i ségétéwe kénogo lagéy ménangéy dob Jesuse atin ménénginsa mano, “Maistéro, ati fiyowe rigoné ku inok gédoté kuy umule magufusa?” ");
INSERT INTO tiy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Séménumbul i Jesuse mano, “Sedek fénginsaa mo Begén fantag bé ati fiyowe? Enda i ségiyo fiyo saliyu saén bé Tuluse. Amuk kétaya mo gédoté moy umule magufusa, odoro moy de sugu tidéw dob Moisese.” ");
INSERT INTO tiy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ménénginsa man i ni lagéy mano, “Ati isuwe de bé de sugu?” Atin séménumbul i Jesuse mano, “Kago méméléhu, kago lémamfa, kago ménakaw, kago uretén i dumo muwe bé békéne toow, ");
INSERT INTO tiy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","fégadata moy boh me brab idéng me, atin fégédaw go bé de dumo mo étéw loo bé kégédaw me bé kaame lowoh.” ");
INSERT INTO tiy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Atin bang i lagéye ni, “I kéluhanay de ni nodoro ku. Ati nay fatute rigoné ku?” ");
INSERT INTO tiy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Atin séménumbul i Jesuse mano, “Amuk kétaya moy waléye fo métintu dob adafay Tuluse, ule go brab fébéléyém i kéluhanay éntingayéne kaam atin irayém i kurtae dob de méskinan. Atin mélaw kawasa go moso dob lawayo. Tidéw béno, énggonén, odor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Amun énggélingooy étéwe niy ni, toow fo méntete i fédéw ne atin ménagéw non toow fo kawasa. ");
INSERT INTO tiy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tidéw béno, ménbéréh i Jesuse dob de kuyugén mano, “Béréhé ku begom i toowe, toow fo mérégén i kéahur i de kawasa dob kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Atin béréhé ku begom, mas mélémuy kéahur i dakéle ayam dob tosong i darume bé kéahur i ségétéwe étéw kawasa dob kéféguléw i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Amun énggélingooy de kuyugén i ni, toow ro fo ménggaif. Atin ménénginsa ro maro, “Ati mélaw i de fakay méfukas?” ");
INSERT INTO tiy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Atin ténéngténg Jesuse bero atin séménumbul mano, “Enda fakayén rigonéy de étéw, éndob i Tuluse fakay gérigono noy kéluhanane.” ");
INSERT INTO tiy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tidéw béno, ménbéréh i Pedrowe mano, “Ténagak gey i kéluhanane atin ménfuray gey Beem. Ati mélaw i gédoté keye de?” ");
INSERT INTO tiy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Séménumbul i Jesuse mano, “Béréhé ku begom i toowe, dob mantuwe duniya amuk mésar i Nga i Kéilawane, sani Begéne, dob gérotore saray méguléwe, i de begom do kuyug gu mésar so dob de folo bra ruwo saray méguléwe inok féguléwo kom i de folo bra ruwo gétribo do Judio. ");
INSERT INTO tiy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Atin atiy étéwe téménagak bé lawi ne taloo no dumo no sétiman idéng, taloo no bohén brab idéngén, taloo no ngaén, taloo no fantadén inok ureté noy fantage bé kéunur ne Begén, gégédot mératuh takéf bé de ténagakén brab gédoté no soy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Endob médooy de étéw gérotor béni waléy do gérifantad moso. Atin médooy de gérifantad béni waléy do gérotor moso.” ");
INSERT INTO tiy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Atin ménbéréh i Jesuse sébaan binuwaya mano, “I kéféguléw i Tuluse bé de étéwén ségiléw bé ni. Wén i ségétéwe étéw, wén i safadén. Wén i no sébaan fuweh ménagéw toow géfuwén séméléd do étéw inok gémalbék dob safad ne. ");
INSERT INTO tiy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Atin ménagayun bayada no bero sébaan félatah loo bé fatute sahud bé ségétérésangane galbék. Tidéw béno, sénuguén bero mangéy gémalbék dob safad ne. ");
INSERT INTO tiy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Amun géraraan lémowot i térésange, ménangéy man i gefee ni safad dob fadiyane. Diyo, énggito noy de étéw téménindég énda i rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mélaw ménbéréh dob berowe mano, ‘Angéy gom so galbék dob safad guwe, atin bayada ku begom bé katabuwane.’ ");
INSERT INTO tiy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mélaw ménagéw ro mangéy gémalbék. Tidéw béno, rénigo noy ni bé géutuhe de, atin rénigo no so man bé géraraan lémudug i térésange de. ");
INSERT INTO tiy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Amun alas singko nén témégénén, ménangéy man dob fadiyane. Atin diyo énggito noy de lagéy téménindég énda i rigoné ro. Atin fénénginsaa no bero mano, ‘Sedek énda gémalbék gom bé ni térésang?’ ");
INSERT INTO tiy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Séménumbul ro maro, ‘Enda i galbék gey non énda i fégalbék begey.’ Tidéw béno, bénréh i gefee ni safad mano, ‘Angéy gom so galbék dob safad guwe.’ Mélaw ménangéy ro gémalbék. ");
INSERT INTO tiy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Amun sémingkufén, i gefee bé safade ni bénréhén dob sarigo nuwe mano, ‘Tabarém i de géménalbék atin sukaya mo bero. Bayada mo sunguy de mantu séna gémalbék taman dob de énggétah de.’ ");
INSERT INTO tiy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tidéw béno, i de géménalbék bé témégéne nén, énggédot roy sébaane félatah sénga ségétéw bero fiyon fo ké géménalbék ro ségéuras saén. ");
INSERT INTO tiy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mélaw i de énggétah do géménalbék tidéw géfuwén taman sémingkuf, marok gégédot ro mas na médoo kurta. Endob amun bénayada no bero, niraya no so bero sébaan félatah. ");
INSERT INTO tiy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tidéw béno, amun éndot roy sahud ruwe, ménbutég-butég ro dob gefee bé safade ni. ");
INSERT INTO tiy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ménbéréh ro maro, ‘I de étéw énggéfuray do géménalbék, ségéuras saén i kégalbék ruwe. Endob sénahudo mo bero ségiléw so bé begeye fiyon fo ké géménalbék gey ségétérésangan tidéw géfuwén taman sémingkuf. Fatut damén bayada mo begey mas gérotor non géménalbék gey ségétérésangan dob kééduf i térésange.’ ");
INSERT INTO tiy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Endob ménbéréh i gefee ni safad dob ségétéwe bero mano, ‘Adih, énda léniful gu begom. Ménagayun tom bé gémalbék gom ségétérésangan atin bayada ku begom sébaan félatah sénga ségétéw. Mélaw rénigo guy ati fénasad guwe. ");
INSERT INTO tiy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mélaw dot gomén i sahud gome atin taus gom ule. I ni ségétéw énggéfuray gémalbék, méuyotu mirayan de ségiléw bé kéiraya kuwe begom. ");
INSERT INTO tiy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Békén ba wén i kuwagib gu rémigo ké udenén i kérigo gu bé kurta guwe loo bé kétaya kuwe de? Médaléw gom keeyén sabaf mégédawu bé de ségiyo étéw.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tidéw béno, fénggilid Jesusey binuwaya ne mano, “Mélaw i de gérifantad béni, waléy ro moso do gérotor. Atin i de gérotor béni, waléy ro moso do gérifantad.” ");
INSERT INTO tiy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tidéw béno, i lala Jesuse ménagé mangéy Jerusalem, nuwitén i de folo bra ruwo gétéw kuyugén inok sébero-bero ro saén. Atin ménbéréh dob berowe bé lala ruwe magéw mano, ");
INSERT INTO tiy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Na, magéw tom mangéy dob Jerusalem, sani Ingéd i Nga i Kílawane, sani Begéne, irayu dob de odoroy do fadi brab dob de témoro bé kitabé. Atin kukumé ro Begén féléhuén. ");
INSERT INTO tiy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Atin atéé ro Begén dob de békén Judio. Atin i de békén Judio, diyangkaé ro Begén, brab tafésé ro Begén, brab féléhué ro Begén dob kruse. Endob amuk méifus i téléwe gétérésangan, tébuleu.” ");
INSERT INTO tiy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tidéw béno, i bawag Sebedeowe ménangéy dob Jesuse beroy de ngaén Juan brab Santiago. Atin léméningkuwéd dob adafa Jesuse atin wén i nongotén dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Atin ménénginsa i Jesuse mano, “Ati kétaya muwe?” Séménumbul i ni libun mano, “Suguém bé amuk Beem i méguléwe moso, i de nga gu ni géésar ro so fingé dob kuwono muwe brab i ségétéwe de fingé dob biwong me.” ");
INSERT INTO tiy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Atin bang Jesuse, “Enda gétiga kom i nan ongoté kom. Aw géfédayday gom bé de kérégénon loo bé mérigowe séko dob Begéne?” Séménumbul ro maro, “Hoo, gagané key.” ");
INSERT INTO tiy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Atin ménbéréh man i Jesuse mano, “Toow mérigo dob begomey de kérégénon mérigowe dob Begéne. Gido loo, békén kagén kuwagib i mémilie bé ati mésare fingé dob kuwono kuwe brab fingé dob biwong guwe. I de ni saran kay de étéw fénémili i Abay guwe Tulus mésar diyo.” ");
INSERT INTO tiy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tidéw béno, i de folo gétéw dumo ro do kuyugén amun énggélingoo roy ni nongot ro, ménkérit ro bé Juane brab Santiagowe. ");
INSERT INTO tiy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mélaw ténawag Jesuse bero kéluhanan mangéy dob Beene, atin ménbéréh dob berowe mano, “Gétiga kom i de méguléw dob de békén Judio, wén i kuwagib ro méguléw bero, atin démoyun sugué ro bero. ");
INSERT INTO tiy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Endob békén fatut loo bé nan dob begome. Amuk wén i ségétéw begom méuyot waléy odoron, fatut waléy sugu-suguéy de dumo no. Atin amuk wén i ségétéw begom méuyot waléy gérotor, fatut térifantad. ");
INSERT INTO tiy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Fatut miring Begén, sani Nga i Kéilawane, non énda ménangéyu dini inok wén i do sugu-sugué ku. Yamula ménangéyu dob duniyae ni inok waléyu sugu-suguén brab inok iray guy umul guwe fégéfukas bé médoowe étéw dob de sala ro.” ");
INSERT INTO tiy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Amun ténagak Jesusey ingéde Jeriko beroy de kuyugén, wén i de médoo do ménlimud do étéw ménfuray de. ");
INSERT INTO tiy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Atin wén i ruwowe gétéw langafén ménsar dob doror i aguwone. Amun énggélingoo roy Jesuse témara, ménkes ro maro, “Séfu Datu Dabid, fégédawan gey!” ");
INSERT INTO tiy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Endob i de ménlimud do étéw génlé ro maro, “Kagom selekén!” Endob taus ro so mékes toow na fo métanug maro, “Séfu Datu Dabid, fégédawan gey!” ");
INSERT INTO tiy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tidéw béno, téménrén i Jesuse atin ténawagén bero. Atin ménénginsa dob berowe mano, “Ati kétaya kome rigoné ku dob begome?” ");
INSERT INTO tiy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Séménumbul ro maro, “Kadnan, méuyot gey de ké féadi-adiné mo begey inok gégito gey damén.” ");
INSERT INTO tiy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Atin ménuray i na Jesuse bero atin kénuwahén i de moto ro. Sonom béno, énggégito ro nén. Atin ménfuray ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Atin méntaus i Jesuse beroy de kuyugén mangéy Jerusalem. Amun gédét ron dob Jerusalem, énggumah ro dob ingéde féndawét Betfage dob tuduke féndawét Olibo. Tidéw béno, sénugu Jesusey ruwowe gétéw bé de kuyugén métah. ");
INSERT INTO tiy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ménbéréh dob berowe mano, “Taus gom agéw mangéy dob nan ingéd gésaréwo kom. Buluk gégumah gom diyo, gito gom i kudae féndawét ‘asno’ ménikét diyo beroy nati nuwe. Ukoh gom bero atin uwit gom bero dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Atin amuk wén i ménginsa dob begome, béréh gom de makom, ‘Kailangay Kadnane bero.’ Atin i ménginsae magad tungkasé no begom.” ");
INSERT INTO tiy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","I ni ménrigo inok métuman i kébéréh i sénarigoy Tuluse muret bé kébéréh ne mano, ");
INSERT INTO tiy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Béréh go dob de étéw bati dob Jerusalem mamo, ‘Téngténg gom, gégumah i datu gome térifantad kémuda dob natiwe asno.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tidéw béno, ménagéw i de ni ruwo gétéw kuyugén brab nodoro roy sugu Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Atin ménséfule ro nuwit roy kudae féndawét asno brab nati nuwe. Tidéw béno, namféno roy natiwe bé de kégal ro brab kéménuda i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Diyo wén i de médoo do étéw ménlimud. Bénékah roy de dumo bé de kégal ro dob aguwo Jesuse. Atin i de dumo bero kéménléng ro do dau bongo brab bénékah ro dob agéwone inok fégito roy kébasana ruwe de. ");
INSERT INTO tiy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Atin i de médoo do étéw magéw ro métah bé Jesuse brab i de médoo de furay ro bé Jesuse, ménkes ro maro, “Dayéwé tom i séfu Datu Dabide! Féfiyonéy Tuluse damén i ni étéw gégumah tidéw dob Kadnane! Dayéwé tom i Tuluse!” ");
INSERT INTO tiy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Amun énggumah i Jesuse dob Jerusalem, kélogoyan i kéluhanay de étéw. Ménsébéréh ro maro, “Ati ni étéw?” ");
INSERT INTO tiy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Atin i de médoo do étéw ménodor bé Jesuse séménumbul ro maro, “Been i niy sarigoy Tuluse muret bé kébéréh ne féndawét Jesus tidéw Galilea.” ");
INSERT INTO tiy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tidéw béno, ménangéy i Jesuse dob lawi i Tuluse. Amun ménahur, dénédélén i de étéw démagang brab do méléy-méléy diyo. Atin bénluweén i de ahayay de lémuluk kurta brab ténuwarén i de saray de émfébéléy do fégétulak do marafati. ");
INSERT INTO tiy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Atin ménbéréh dob berowe mano, “Wén i Ménsulate Kébéréh i Tuluse mano, ‘I lawi guwe fédawétén lawi gonon démasal.’ Endob fénwaléy gom lawi i de ménakaw.” ");
INSERT INTO tiy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tidéw béno, i de langafén brab de fikat ménangéy ro dob Jesuse dob lawi i Tuluse. Atin fén-adi-adi no bero. ");
INSERT INTO tiy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Endob i de odoroy de fadi brab de témoro bé kitabé ménwaléy ro ménkérit amun énggito roy de ni fiyo rénigo Jesuse brab amun énggélingoo roy kéékes i de nga dob lawi i Tuluse maro, “Dayéwé tom i séfu Datu Dabide.” ");
INSERT INTO tiy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mélaw ménbéréh i de ni odoron dob Jesuse maro, “Aw énggélingoo moy de kébéréh i de ni nga? Sedek énda fétéréné mo bero?” Séménumbul i Jesuse mano, “Hoo, énggélingoo ku. Atin fiyo ké dayéwé ro Begén. Aw énda séna énggébasana kom i Ménsulate Kébéréh i Tuluse mano, ‘Fédayéw i Kadnane bé de nga.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tidéw béno, ténagak Jesuse bero atin méntékédan dob Jerusalem mangéy dob ingéde Betania. Diyo ménbati bé no kélungonon. ");
INSERT INTO tiy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bé géfuwéne de, bé lala ne séfule mangéy Jerusalem, ménlayaf i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Atin énggito noy sébaane kayéw féndawét igos dob doror i aguwone. Mélaw fénggédéto no inok médot bé onok ne. Endob amun séménléd de, énda i énggito no onokén saliyu bé de dau no. Tidéw béno, ménbéréh dob kayéwe ni mano, “Endaén damén mégonok go!” Sonom béno ménlaay i kayéwe ni. ");
INSERT INTO tiy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","I de kuyugén, amun énggito roy ni, ménggaif ro. Atin ménénginsa ro maro, “Sedek ménagad ménlaay i kayéwo no?” ");
INSERT INTO tiy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Atin séménumbul i Jesuse mano, “Béréhé ku begom i toowe, amuk tintu gom munur brab énda ruwo-ruwoy fédéw gome, gérigono kom i loowe bé rénigo guwe dob kayéwe. Atin békén saén i ni, non gébérého kom dob tudukey ni makom, ‘Angéy go dob dogote’, atin mérigo ba. ");
INSERT INTO tiy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Non amuk munur gom, gédoté kom i ati ongoté kome ké démasal gom dob Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tidéw béno, ménangéy man i Jesuse dob lawi i Tuluse, atin diyo téménoro. Atin i de odoroy de fadi brab de odoroy de Judio ménangéy ro dob Jesuse atin ménénginsa ro maro, “Ati atura muwe rémigo bé de ni? Ati ménirayane Beem kuwagib bé ni?” ");
INSERT INTO tiy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Séménumbul i Jesuse mano, “Sémuliu ménginsaan begom. Amuk sumbulo kom Begén, sumbulo ku so begom ké ati kuwagib guwe rémigo bé de ni. ");
INSERT INTO tiy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ati séménugue bé Juane inok mautis, Tulus loo ké étéw saén?” Atin séédél ro maro, “Amuk béréh tom ‘Tidéw dob Tuluso’, fénginsaa no betom sedek énda fénéngintoowo tom i Juane. ");
INSERT INTO tiy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Endob buluk béréhé tom, ‘Tidéw dob étéwe,’ kéluhanay de ni étéw mékérit ro betom.” Ménggilak ro bé de étéw non ménunur i de ménlimud bé Juaney ségétéwe sénarigoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mélaw séménumbul ro dob Jesuse maro, “Enda gétiga key de.” Atin mélaw bénréh Jesus mano, “Enda so béréhé ku dob begome ké ati kuwagib guwe rémigo bé de ni rigoné ku.” ");
INSERT INTO tiy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tidéw béno, nuret Jesusey sébaane binuwaya mano, “Fégitung gom i fantage bé ni. Wén i ségétéwe lagéy wén i ruwo gétéw ngaén lagéy. Ménangéy dob ofoe de atin ménbéréh mano, ‘Adu, agéw go mangéy dob safade gémalbék béni.’ ");
INSERT INTO tiy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Endob i ni nga ménbéréh mano, ‘Mikau.’ Endob énda mérugayén tidéw béno, ménagéw non ménfégalin i fédéw ne. ");
INSERT INTO tiy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Atin ménangéy soy boh ne dob tuwaréye bé de ngaén. Atin ménbéréh mano, ‘Adu, angéy go galbék dob safade béleewe ni.’ Atin bang i ni nga, ‘Hoo, magéwu.’ Endob énda fo ménagéwén. ");
INSERT INTO tiy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na, ati karang gome de, ati isuwe bé de ngaén i ménodorone bé kétayay boh ruwe?” Séménumbul ro maro, “I ofoe de.” Atin bang Jesuse man, “Hoo, atin béréhé ku begom i toowe, i de ménsala étéw loo bé de lémiful do kémubra buwis brab de sundal géahur dob kéféguléw i Tuluse géétah na begom. ");
INSERT INTO tiy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Non i Juan Bautistawe ménangéy dob begome fégétiga no begom i métintuwe aguwon, éndob énda ménunur gom de. Endob i de lémiful kémubra buwis brab de sundal énggésénule ro ménunur ro de. Atin fiyon fo ké énggito gom i kégésénule ruwe, énda fo gésénule gom taloo no munur gom de.” ");
INSERT INTO tiy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Atin ménbéréh man i Jesuse mano, “Fégélingo gom nay ni ségiyo binuwaya. Wén i ségétéwe étéw wén i safadén nohoko no do ubas. Atin fénlangkatén i lémiwéte de, atin kénalutén i fédongo nuwe bé fégékérése bé de onokén. Atin réménigo so tambala. Tidéw béno, féntalimaén bé de ségiyo étéw. Tidéw béno, ménagéw mangéy dob mérayue ingéd. ");
INSERT INTO tiy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Amun énggumah i gaiy kékétéwe de, sénuguén i de sugu-sugué no inok doté roy kaane de baad bé de onokén. ");
INSERT INTO tiy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Endob i de témalima bé safade, génamak roy de ni sugu-suguén. Atin lénubag roy ségétéwe de, atin fénléhu roy ségétéwe de, atin nibéro ro batéw i gétéléwe de taman ménléhu. ");
INSERT INTO tiy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tidéw béno, i gefee bé safade ni, sénuguén man i de ségiyo do sugu-sugué no éndob mas na médoo. Endob i de témalima bé safade, ségiléw soy rénigo ruwe dob berowe. ");
INSERT INTO tiy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tidéw béno, i gefee bé safade ni, sénuguén i tintuwe ngaén non fénggitungén mano, ‘Fégadata roy nga guwe.’ ");
INSERT INTO tiy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Endob amun énggitoy de témalima bé safad ne, ménsébéréh-béréh ro maro, ‘Been i niy nga i gefee bé ni safad. Féléhué tom inok gékatom i ni safad.’ ");
INSERT INTO tiy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mélaw génamak ro, atin fénsut ro dob liyuy safade. Tidéw béno, fénléhu ro.” ");
INSERT INTO tiy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Atin féntaus Jesusey kébéréh ne mano, “Amuk gégumah i gefee bé safade ni, ati rigoné nuwe dob de téménalima bé safad ne?” ");
INSERT INTO tiy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Séménumbul ro maro, “Angéyé no féléhuén i de ni tete étéw. Tidéw béno, irayén man dob ségiyowe témalima inok iray ro dey kaane baad bé de nohok ké gégumah i kékétéwe de.” ");
INSERT INTO tiy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Atin ménbéréh i Jesuse dob berowe mano, “Aw énda séna énggébasana kom i Ménsulate Kébéréh i Tuluse mano, ‘I batéwe nikaay de réménigo bé lawie, been i ménwaléye toow na fo balilaga fiyo batéw. I ni rénigoy Kadnane ula-ula, atin mégaif tom de.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Atin féntaus Jesusey kébéréh ne mano, “Mélaw béréhé ku begom i Tuluse éndaén sarigé noy safad ne dob begome. Yamula sarigé no dob de ségiyo étéw rigoné roy kétaya nuwe. I atag i ni, éndaén féguléwoy Tuluse begom. Yamula féguléwo noy de ségiyo étéw munur dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Atin atiy mélawue dob nan batéw toow fo mébinasa. Brab buluk i batéwe ni mélawu dob de étéw, rénahé no bero maak bubuk sébuwan.” ");
INSERT INTO tiy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","I de odoroy de fadi brab de Fariseo, énggélingoo roy de ni binuwaya nuret Jesuse. Atin gétiga ro beroy bénrého nuwe fantag bé de ni. ");
INSERT INTO tiy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mélaw ténlama ro kénéfo i Jesuse, éndob énda gagané ro de non ménggilak ro bé de médoo do ménlimud do étéw diyo. Non i de ni étéw kénarang roy Jesuse ségétéw sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Atin ménuret man i Jesuse binuwaya dob de étéw. ");
INSERT INTO tiy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ménbéréh mano, “I kéféguléw i Tuluse loo bé ni. Wén i ségétéwe datu réménigo karagiya dob uyot i nga ne lagéy fébawagén. ");
INSERT INTO tiy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Amun énggumah i gaiwe, sénuguén i de sugu-sugué no mangéy témawag bé de étéw sénéngkat ro brab émbéréh dob berowe bé énggumahén i gaiy uyote brab fatut magéw ro mangéy dob lawi ne. Endob ménika ro magéw. ");
INSERT INTO tiy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mélaw i datue ni sénuguén man i de ségiyo sugu-sugué no mangéy méréh dob de ni do étéw sénéngkat ro mano, ‘Méntafayén i karagiyae béleewe ni. Ménsumbalién i de bobo ayam atin méntogohén i kéluhanane. Enggomén, angéy gomén dob uyote ni.’ ");
INSERT INTO tiy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Endob i de étéw sénéngkat ro, énda fo nifat ro de brab énda fo ménangéy ro dob uyote ni. Yamula i ségétéwe de ménangéy dob safad ne, atin i ségétéwe de ménangéy dob daganga nuwe. ");
INSERT INTO tiy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Atin i de dumo bé de ni étéw sénéngkat ro génamak roy de sugu-suguéy datue ni. Atin lénubag ro brab fénléhu ro bero. ");
INSERT INTO tiy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mélaw i datue ni toow fo ménkérit. Mélaw sénuguén i de sundalo no atin fénléhu roy de ni étéw ménméléhu, atin ténuwég roy ingéd ruwe. ");
INSERT INTO tiy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tidéw béno, ménbéréh dob de sugu-suguén mano, ‘Méntafayén i uyote, éndob i de sungu do étéw sénéngkat gu énda fo médait ro mangéy dini. ");
INSERT INTO tiy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Agéw gom mangéy dob de dakél aguwon atin séngkat gom médoo do étéw taman atiy gito gome de.’ ");
INSERT INTO tiy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mélaw i de sugu-suguén ménagéw ro dob de aguwon atin lénimud roy de médoo do étéw, sani kéluhanay de énggito ro do fiyo étéw brab do tete étéw. Atin mélaw i gonoy uyote ni toow fo ménféno bé étéwe. ");
INSERT INTO tiy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Endob amun ménahur i datue inok téngténgé noy de kana, énggito noy ségétéwe lagéy énda kéménégalén loo bé fatute dob uyote. ");
INSERT INTO tiy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Atin ménénginsa i datue mano, ‘Adih, sedek ménahur go dob ni uyot énda kéménégal go loo bé fatute?’ Endob énda séménumbul i lagéye ni. ");
INSERT INTO tiy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tidéw béno, bénréh i datue dob de sugu-sugué no mano, ‘Ikét gom i de kémérén brab de sékéyén, atin ibér gom dob liyuy lawie ni mangéy dob délémone. Diyo kémérew brab kémigét i de kifé no.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Atin fénggilid Jesusey binuwayae ni mano, “Non fiyon fo ké médooy de étéw sénéngkat i Tuluse, kloh saén i méfémilie de waléy do étéwén.” ");
INSERT INTO tiy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","I de Fariseo, ménangéy ro sélimud sébero-bero saén. Atin ménsébéréh-béréh ro fantag bé ati kéténgkad ro bé Jesuse inok gébéréh bé békéne damén katabuwan. ");
INSERT INTO tiy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tidéw béno, sénugu roy de dumo bé de kuyug ro brab de dumo bé de kuyug Datu Herod mangéy ménginsa dob Jesuse. Atin ménbéréh i de ni étéw dob Jesuse maro, “Maistéro, gétiga key toow i kétoro me. Brab métintu go, énda i isu ramigo mo bé de étéw. Yamula toroé moy toowe fantag bé kétayay Tuluse toow. ");
INSERT INTO tiy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mélaw béréhém begey, ati karang me de, aw fatut gey ba mayad buwis dob Sesare, sani datue dob Roma taloo no énda?” ");
INSERT INTO tiy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Endob i Jesuse énggétiga noy tetee kétaya ro brab bénréhén bero mano, “I de begom do ubo-ubo gom saén méngintulus. Sedek télamané kom Begén fagakaran? ");
INSERT INTO tiy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Féténgténg gom Begén i félatahe kurta fégébuwis.” Amun niraya ro de, ");
INSERT INTO tiy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ménénginsa i Jesuse dob berowe mano, “Ati gefee dawét brab falas gito gom dob nan?” ");
INSERT INTO tiy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Séménumbul ro maro, “Ka Sesar.” Tidéw béno, bénréh Jesuse mano, “Iray gom dob Sesarey ka Sesare. Brab iray gom dob Tulusey kay Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Amun énggélingoo roy ni, ménggaif ro bé késumbul Jesuse. Atin ménagéw ro ténagak roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bé no so térésang, wén i de Saduseo ménangéy ro dob Jesuse. (Been i berowey de énda méngintoow bé kéfétébule i Tuluse bé de étéw moso.) ");
INSERT INTO tiy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ménbéréh ro dob Jesuse maro, “Maistéro, bénréh Moisese bé buluk i ofo i ménléhue, brab énggéféledo noy bawag ne, énda i nga ro, fatut bawagéy tuwaréy ne inok wén i séfu i ni étéw bé tuwaréy ne. ");
INSERT INTO tiy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, wén i fitéw gétéw sétuwaréy falan lagéy ménbati dini Brab i ofoe de ménawag. Tidéw béno, ménléhu énda i nga ro. Tidéw béno, i gétunduge de bénawagén soy bawage fénled i ofo ne. ");
INSERT INTO tiy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Atin ménléhu so énda i nga ro. Atin i gétéléwe de bénawagén so taman dob géfitéw ruwe. Endob ménléhu ro kéluhanan énda i nga ro. ");
INSERT INTO tiy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tidéw béno, ménléhu soy ni libun. ");
INSERT INTO tiy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mélaw bé gaiy kétébulee moso, ati isuwe bawag i ni libun bé de ni fitéw gétéw sétiman idéng? Non énggébawaga no bero kéluhanan bé méuyag ro de séna.” ");
INSERT INTO tiy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Séménumbul i Jesuse mano, “Tintu békén katabuwan i kéfégitung gome. Non énda gétiga kom i Ménsulate Kébéréh i Tuluse taloo noy barakat ne. ");
INSERT INTO tiy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Non amuk tébule i de étéw, ségiléw ro bé de télaki dob lawayo atin énda sébawag ro. ");
INSERT INTO tiy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Atin fantag bé kétébulee, aw énda séna énggébasana kom i Ménsulate Kébéréh i Tuluse dob begome? ");
INSERT INTO tiy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Fiyon fo ké ménléhu i ro Abrahame, Isak, brab Jakob, bang i Tuluse, ‘Begéney Tuluse féngadafé Abrahame, Isake, brab Jakobe.’ I atag i ni, i Tuluse féngadaféy de méuyag do étéw, békén i de ménléhu.” ");
INSERT INTO tiy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Atin amun énggélingooy de étéw i ni kétoro Jesuse, ménggaif ro. ");
INSERT INTO tiy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","I de Fariseo, amun énggélingoo roy fantage bé kéféantés Jesuse bé de Saduseo, ménsélimud ro. ");
INSERT INTO tiy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Atin i ségétéwe bero témoro bé kitabe, ténéngkadén i Jesuse inok énda damén katabuwan i késumbul ne. ");
INSERT INTO tiy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ménénginsa mano, “Maistéro, ati isuwe toow fo gérotor bé de sugu dob kukumay Tuluse?” ");
INSERT INTO tiy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Séménumbul i Jesuse mano, “Féimu go bé Kadnane Tulusém bé kéluhanay fédéw me, brab kéluhanay kamatu me, brab kéluhanay itunga muwe. ");
INSERT INTO tiy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Been i niy toowe fo gérotor sugu. ");
INSERT INTO tiy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","I géruwowe toow fo gérotor sugu ringon so bé sunguwe de. Féimu go bé dumo muwe ringon so bé kéimu me bé kaame lowoh. ");
INSERT INTO tiy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","I toowe atag i kéluhanay de kukuman niray Moisese betom tidéw dob ni ruwo timan sugu. Tidéw so dob niy kéluhanay ténoro i de sénarigoy Tuluse muret bé kébéréh ne.” ");
INSERT INTO tiy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amun ménlimud sénay de Fariseo, ménénginsa i Jesuse dob berowe mano, ");
INSERT INTO tiy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ati antaf gom bé Kristowe? Ati katufua nuwe?” Séménubul i de Fariseo maro, “Dabid i katufua Kristowe.” ");
INSERT INTO tiy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ménbéréh man i Jesuse mano, “Amuk loo, ati kéfanu-fanu nuwe ké fénbéréh i Rémogor i Tuluse bé Dabide bé fédawétén i Kristowe ‘Kadnan?’ Non ménbéréh i Dabide mano, ");
INSERT INTO tiy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘I Kadnane ménbéréh dob Kadna kuwe, sar go dob kuwono kuwe taman témabanu bé de sébanil Beem.’ ");
INSERT INTO tiy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Amuk féndawét Dabidey Kristowe ‘Kadnan’, ati kéfanu-fanu nuwe ké i Kristowe séfu Dabide saén?” ");
INSERT INTO tiy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Endob énda i ségétéw bero énggésumbul, ménantés ro. Atin tidéw bé no gai, éndaén i étéw émbaraw ménginsa dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tidéw béno, ménbéréh i Jesuse dob de ménsélimud étéw brab dob de kuyugén mano, ");
INSERT INTO tiy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“I de témoro bé kitabe brab de Fariseo, beroy de étéw sénarigon témoro bé kitabé niray Moisese. ");
INSERT INTO tiy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mélaw fatut odoro kom démoyun i kéluhanay kétoro ruwe begom. Endob kagom iringén i de rigoné ro non énda modor ro bé karowe kétoro. ");
INSERT INTO tiy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sugué roy de étéw bé médoowe, maak féobo ro beroy de toow fo émbégat do obo, éndob énda témabang ro de. ");
INSERT INTO tiy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Fédayéw-dayéw ro saén dob téngaangay de étéw. Féndakél roy de fédongo ro bé Ménsulate Kébéréh i Tuluse ténaléy ro bé de kémér ro inok gitoy de étéw. Atin féntaah roy de kégal ro maak do tintu fo méngintulus. ");
INSERT INTO tiy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Atin méuyot ro mésar dob de fiyo saran dob kandulie brab dob de lawi féngadafan. ");
INSERT INTO tiy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Atin méuyot ro fégadatan ségifaén dob de fadiyan brab fédawét i de étéw bero ‘Maistéro.’ ");
INSERT INTO tiy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Endob kagom fédayaén i de étéw fédawét ro begom ‘Maistéro’, non fantay-fantay gom sédumon atin ségétéw saén i Maistéro gome. ");
INSERT INTO tiy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Atin kagom fédawét i de étéw dob duniyae ni ‘Abay’, non ségétéw saén i Abay gome sani Tuluse dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Atin kagom so fédayaén i de étéw fédawét ro begom ‘Uléw’, non ségétéw saén i Uléw gome sani Begéne, Kristo. ");
INSERT INTO tiy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","I toowe na fo gérotor dob begome fatut waléy sugu-suguén. ");
INSERT INTO tiy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Atiy étéwe téfégérotor, fégérifantadén. Atin i étéwe térifantad, fégérotorén. ");
INSERT INTO tiy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“I begome do Fariseo brab do témoro bé kitabé, mékukum gom fo toow. Ubo-ubo saén i kéféngintulus gome. Alangé kom i de étéw méuyot mahur dob kéféguléw i Tuluse. Mika gom mahur atin alangé kom i de étéw méuyot mahur. ");
INSERT INTO tiy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mékukum gom fo toow do témoro bé kitabe brab begome so do Fariseo. Ubo-ubo saén i kéféngintulus gome. Lafisé kom i de libun baléw inok afasé kom i de lawi ro. Tidéw béno, démasal gom bé de métaah kédasal dob téngaangay de étéw non makom ké médirung i de ni tete rigoné kom. Sabaf bé ni toow na fo gétimal ké mékukum gom moso. ");
INSERT INTO tiy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mékukum gom fo toow do témoro bé kitabe brab begome do Fariseo. Ubo-ubo saén i kéféngintulus gome. Mégéror gom magéw émféunur bé ségétéwe étéw dob Tuluse. Endob amuk munur, féwaléyé kom toow na fo tete bé begome, funa no toow na fo fatut mangéy dob uleono emferno. ");
INSERT INTO tiy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mékukum gom fo toow. Maak do langafén gom éndob araké kom i de ségiyo étéw. Ténoro gom bé fiyon fo ké wén i étéw sémafa bé lawi i Tuluse, ulanden ké énda métuma no. Endob amuk wén i rémigo safa bé de bélowon dob lawi i Tuluse, béréhé kom tintu fo fatut tumané noy fasad ne. ");
INSERT INTO tiy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dufang gom brab maak langafén gom. Ati isuwe toow na fo gérotor, i de bélowon dob lawi i Tuluse look i mékétéfuwe lawi i Tuluse funay de bélowon mékétéfu? Toow na fo balilaga i lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Atin témoro gom so bé amuk sémafa i étéwe dob ahayane tulakan dob lawi i Tuluse, ulanden ké métuman i fasad ne. Endob amuk sémafa bé atiy tulake diyo dob no tulakan béréhé kom dob beene bé tintu fo fatut tumané noy fasad ne. ");
INSERT INTO tiy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Toow gom fo maak do langafén! Ati isuwe toow na fo gérotor, i tulake look i mékétéfuwe tulakan funay tulake mékétéfu? Mas gérotor i ahayane tulakan. ");
INSERT INTO tiy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mélaw amuk sémafa i ségétéwe étéw dob ahayane tulakan, énda saén sémafaén dob nan, yamula sémafa so dob kéluhanay de tulak féndiyo dob ahayane. ");
INSERT INTO tiy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Atin amuk sémafa i ségétéwe étéw dob lawi i Tuluse, énda sémafaén saén dob nan, yamula sémafa so dob Tuluse bati diyo. ");
INSERT INTO tiy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Atin amuk sémafa i ségétéwe étéw bé lawayo, sémafa so dob saray Tuluse brab dob Tuluse mésaran de. ");
INSERT INTO tiy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mékukum gom fo toow do témoro bé kitabé brab de begom do Fariseo. Ubo-ubo saén i kéféngintulus gome. Iray gom dob Tulusey géfoloe bé kéluhanay languntama kome fiyon i faninue nohok gom, éndob dénigur gom i de gérotor sugu dob kitabe loo bé kétintuwe, brab kégédawe, brab gésarigone adat. I de ni niray gom fatut rigoné kom éndob kagom digurén i de dumo de. ");
INSERT INTO tiy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Maak do langafén gom marak bé ségiyowe étéw! Modor gom bé de kloh do sugu éndob félisé kom i de gérotor do sugu. Ségiléw gom bé ségétéwe étéw kédané noy liféte tidéw dob wayége inémé no, éndob inémé noy dakéle ayam. ");
INSERT INTO tiy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mékukum gom fo toow do témoro bé kitabe brab begome do Fariseo. Ubo-ubo gom saén métintu éndob i de fédéw gom toow fo tete. Non toow gom fo arumén brab lémiful. Ségiléw gom bé ségétéwe étéw urahé noy tabue look biléwe fingé fuweh saén éndob dungisan fo toow dob bukag ne. ");
INSERT INTO tiy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Maak do langafén gom, begom do Fariseo, non énda gito gom i toowe. Féfiyo gom i de fédéw gom loo bé ségétéwe murah bé bukag i tabue. Tidéw béno, tintu gom fiyo, brab métintuy adat gome so. ");
INSERT INTO tiy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mékukum gom fo toow do témoro bé kitabe brab de begom do Fariseo. Ubo-ubo gom saén fiyo éndob tete i de adat gom. Ségiléw gom bé de lébéng fiyoy de falas ro dob liyuwe, éndob dob bukage wén i do bukal de brab do mérénah do bangkay. ");
INSERT INTO tiy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Non ubo-ubo gom saén métintu inok i de étéw karangé ro begom do fiyo étéw. Endob i de fédéw gom méféno bé tugie brab sala. ");
INSERT INTO tiy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mékukum gom fo toow do témoro bé kitabe brab de begom do Fariseo. Ubo-ubo saén i kéféngintulus gome. Rémigo gom do fiyo lawi lébéngon kay de sénarigoy Tuluse, brab rémigo gom fiyo do lébéngon kay de métintu étéw ménrugayén ménléhu. ");
INSERT INTO tiy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Atin béréhé kom makom, ‘Amuk méuyag gey bé gaiwe méuyag i de ni sénarigoy Tuluse muret bé kébéréh ne, énda mamung gey bé de katufua key méméléhu bero.’ ");
INSERT INTO tiy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Endob bé nan kébéréh gom, fégito gom bé begom i de séfu i de ménméléhu bé de ni sénarigoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mélaw fatut fétaus gom i de tete rénigoy de katufua kom. ");
INSERT INTO tiy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Maak do ulé gom non i de katufua kom maak do ulé ro. Mélaw kagom karangén de ké géséliya gom bé kékukume begom mangéy dob uleono emferno. ");
INSERT INTO tiy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mélaw sugué kuy de sénarigoy Tuluse muret, brab de gétigan étéw, brab de témoro mangéy dob begome. Endob féléhué kom i de dumo bero, brab féléhué kom i de dumo bero dob de krus, brab badasé kom i de dumo bero dob de lawi féngadafan, brab fégétaé kom i de dumo bero dob de ségiyo-giyo ingéd. ");
INSERT INTO tiy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mélaw mékukum gom bé sala i de étéw bé kéféléhu ruwe bé de métintu étéw, tidéw dob sunguwe métintu étéw ménléhu féndawét Abel taman dob Sekariase sani nga Barakiase. Fénléhu dob lawi i Tuluse dob élét i ahayane tulakan brab mékétéfuwe sibéy. ");
INSERT INTO tiy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Béréhé ku begom i toowe, i de begom do étéw méuyag béni mékukum gom sabaf bé de ni sala bé kéféléhue bé kéluhanay de ni.” ");
INSERT INTO tiy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tidéw béno, ménbéréh i Jesuse fantag bé adat i de étéw dob Jerusalem mano, “I Begome do étéw dob Jerusalem, tete i fédéw guwe fantag bé begome. Non fénléhu gom i de sénarigoy Tuluse muret brab nibéro kom batéw i de sénugu dob begome taman ménléhu ro. Firoy gule i kétaya kuwe témimu begom loo bé kétimu i méritone manok télikub-kubo noy de fiyakén bé de fafakén? Endob ménika gom de. ");
INSERT INTO tiy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","I lawi gome métagak brab mébinasa moso. ");
INSERT INTO tiy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Atin béréhé ku begom, tidéw béleewe ni, éndaén gito gom Begén taman énda émbéréh gom moso, ‘Féfiyonéy Tuluse damén i gégumahe tidéw dob Kadnane.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","I lala Jesuse magéw tidéw dob lawi i Tuluse, i de kuyugén ménfégédét ro dob Beene toroé roy de fiyo falasén do lawi bé lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Endob ménbéréh i Jesuse mano, “Gito gom i de ni? Béréhé ku begom i toowe, i kéluhanay de ni mébinasa, brab fiyon i de batéw fénggérigo de émbéragar ro.” ");
INSERT INTO tiy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Amun ménsar i Jesuse dob tuduke féndawét Olibo, ménangéy i de kuyugén dob Beene sébero-bero saén. Atin ménbéréh ro maro, “Béréhém begey kédiron mérigoy de ni. Brab ati fégélolonone de ké gédétén gégumah i késéfule me brab tamfaday de gai?” ");
INSERT INTO tiy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Séménumbul i Jesuse mano, “Ingat gom inok énda méfagakaran gom. ");
INSERT INTO tiy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Non médoo mosoy de étéw gégumah usaré roy dawét guwe, brab béréhé ro maro, ‘Begéney Kristowe.’ Atin médooy de géfagakara ro. ");
INSERT INTO tiy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Atin gélingoo kom i kébéréh i sétibohe brab gélingoo kom soy fantage bé de gira. Endob kagom mégilak de. I de ni kailangan mérigo éndob békén sénay ni tamana nuwe. ");
INSERT INTO tiy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","I de ingéd sétiboh ro bé de ségiyo ingéd. Brab i de sakuf fangangaturan sétiboh ro bé de ségiyo. Atin wén mosoy lénggob brab do luba dob de séségiyo-giyo do ingéd. ");
INSERT INTO tiy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Endob i de ni féganaya no saén loo bé kéféganay i kékédawétay ségétéwe libun obor gédétén mégénga. ");
INSERT INTO tiy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Atin i kéluhanay de étéw mérarék ro begom sabaf bé kéunur gome Begén. Atin mélaw kéfoén gom inok férasayé ro begom brab féléhué ro begom. ");
INSERT INTO tiy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Atin bé béno, wén i médoo do étéw témérén munur. Atin sékéfo ro brab mésérarék ro. ");
INSERT INTO tiy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tidéw béno, médooy de ubo-ubo sarigoy Tuluse muret bé kébéréh ne gégumah brab fégakara roy de médoo do étéw. ");
INSERT INTO tiy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Atin sabaf bé kélégéb i tetee, éndaén ségédaw i de étéw. ");
INSERT INTO tiy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Endob ati géfédaydaye munur taman dob tamfadane, méfukas ro. ");
INSERT INTO tiy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Atin i ni Fiyo Uret fantag bé kéféguléw i Tuluse uretén dob kéluhanay de ingéd dob duniyae ni inok gétigay kéluhanay de étéw. Tidéw béno, gégumah i tamanane. ");
INSERT INTO tiy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Atin gito gom i ‘Mékésirang-sirange Surga’ bénréh i sénarigoy Tuluse féndawét Daniel bé do gétah. Atin témindég dob mékétéfuwe gonon.” (Fégésobutéy masawe.) ");
INSERT INTO tiy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Atin féntaus Jesusey kébéréh ne mano, “Bé béno gai, i de étéw bati dob Judea fatut méraréy ro dob de tuduk. ");
INSERT INTO tiy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Atin i étéwe dob liyuy lawi ne, békénén fatut mahur dob lawi ne inok angéyé noy insod ne. Fatut magayasén méraréy. ");
INSERT INTO tiy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Atin i étéwe diyo dob safad ne, békénén fatut séfule dob lawi ne inok angéyé noy géruwowe lafin kégalén. ");
INSERT INTO tiy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bé do no do gai, toow fo mékégédaw-gédaw i de libun obor brab de mériton do idéng. ");
INSERT INTO tiy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dasal gom dob Tuluse brab ongot gom dob Beene inok dob gaiwe kailanga kom i méraréye bé de gai mélégénéy taloo no gai kétérén. ");
INSERT INTO tiy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Non toow na fo gétimal i kérégéy ni bé kéluhanay de ségiyo do kérégénon dob ségiyowe gai tidéw bé kélimbag i Tuluse bé duniyae taman so béleewe ni. Atin éndaén i kérégénon loo bé ni tidéw bé béno gai. ");
INSERT INTO tiy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Endob i Tuluse fénfokoén i do no gai. Amuk énda rénigo noy ni, énda i ségétéw méuyag. Féfokoé noy de gai non ménuray i na nuwe bé de fénémilién étéw. ");
INSERT INTO tiy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bé béno gai, amuk wén i émbéréh dob begome mano, ‘Téngténg gom, ay niy Kristowe,’ taloo no ‘Diyoo, ay nan,’ kagom munur de. ");
INSERT INTO tiy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Non gégumah i de émbéréh, ‘Begén i Kristowe,’ brab do ubo-ubo sénarigoy Tuluse. Atin gérigono roy de dakél mékégaif inok géfagakara roy de fénémili i Tuluse, amuk fakay. ");
INSERT INTO tiy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Fétuntay gom i de ni. Béréhé ku dob begome lokut énda séna mérigo no. ");
INSERT INTO tiy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Atin amuk wén i émbéréh dob begome mano, ‘Téngténg gom, diyo i Kristowe dob gonone énda i étéw de bati,’ kagom mangéy diyo. Look amuk émbéréh ro maro, ‘Téngténg gom, ay diyoo ménrékunéy,’ kagom munur de. ");
INSERT INTO tiy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Non i Nga i Kéilawane, sani Begéne, giton i késéfule guwe ségiléw bé kégitone bé kilote réméndaw tidéw sébangan mangéy élédon. ");
INSERT INTO tiy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Fiyon atiy gonoy de ménléhu, diyo soy de uwak sétimu. ");
INSERT INTO tiy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Enda mérugayén tidéw bé de mérégén do gai, i térésange waléy délémon, brab i térésang kélungonone éndaén réméndawén, brab i de gitoon mélawu ro tidéw dob lawayo brab i de éntingayén dob lawayo mékuyung. ");
INSERT INTO tiy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tidéw béno, giton dob lawayoy fégélolonone bé kégumah guwe, sani Nga i Kéilawane. Atin i kéluhanay de étéw dob duniyae ni kémérew ro bé kégilak ruwe. Tidéw béno, gito ro Begén dob rawéne gégumah tidéw dob lawayo barakatan brab réméndaw. ");
INSERT INTO tiy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Atin dob métanuge béréh i témburiwe, sugué kuy de télaki gu mangéy dob séngae gonon dob duniyae ni. Atin timué roy de fénémilién étéw gu tidéw dob kéluhanay de ingéd.” ");
INSERT INTO tiy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tidéw béno, nuret Jesusey sébaane binuwaya mano, “Fétuntay gom i ni ufama fantag bé kayéwe. Dini dob betome ni, sonom lémbud i de fongo no brab émféantu daun, gétiga kom gédétén i basa médufe. ");
INSERT INTO tiy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ségiléw so bé béno gai. Amuk gito gomén mérigoy de ni bénréh gu, gétiga kom gédétén i késéfule guwe. ");
INSERT INTO tiy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Atin béréhé ku begom i toowe, i de étéw méuyag béni, énda méléhu ro taman mérigoy de ni. ");
INSERT INTO tiy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","I lawayo diyo brab duniyae ni méalfa, éndob i kébéréh guwe énda méalfaén. ");
INSERT INTO tiy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Endob énda i ségétéw gétigan bé gaiy kégumah i no gai séfuleu. I de télaki dob lawayo énda gétiga ro de, brab fiyon i Begéne, sani Nga i Tuluse, énda so gétiga ku de. I Abay guwe saén Tulus i gétigane bé nan gai. ");
INSERT INTO tiy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","I késéfule guwe ségiléw bé gai Noehe. ");
INSERT INTO tiy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Non bé gai Noehe, amun gédétén gégumah i dunuke, i de étéw énda ménbuku ro. Yamula ménama ro, méniném ro, ménawag ro taman bé gaiy kéahur Noehe dob barkowe. ");
INSERT INTO tiy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Non i de étéw énda énggétiga roy ati mérigowe séko. Endob tékow énggumah i dunuke atin ménléné ro kéluhanan saliyu bé Noehe brab de samungén. Ségiléw so bé niy kétékow i késéfule guwe. ");
INSERT INTO tiy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bé béno gai, wén i ruwo gétéw lagéy diyo gémalbék dob safade, atin i ségétéwe de dotén brab i ségétéwe de méféled. ");
INSERT INTO tiy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Atin wén i ruwo gétéw do libun gémiling, atin i ségétéwe de dotén, brab i ségétéwe de émféled. ");
INSERT INTO tiy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ingat gom mélaw, non énda gétiga kom i gaiy késéfule i Kadna kome, sani Begéne. ");
INSERT INTO tiy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Fétuntay gom i ni ufama. Amuk i gefee bé lawie gétiga noy gaiwe gégumah i ménakawe, énda fo fidongén brab énda fédayaé no mahur i ménakawe. ");
INSERT INTO tiy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mélaw fatut tafay gom sénga tékélid. Non séfuleu bé gaiwe énda karangé kom de. ");
INSERT INTO tiy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ati gésarigone brab gétuwane sugu-suguén? Been i sugu-suguéne sénarigoy amu ne méguléw bé de dumo no sugu-suguén, inok irayén i de amaén bé fatute gai. ");
INSERT INTO tiy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Toow fo moror i ni sugu-suguén ké séfule i amu ne brab gito no rémigo bé kaane galbék loo bé fatute. ");
INSERT INTO tiy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Béréhé ku begom i toowe, i amue ni sarigé noy kéluhanay de kaan do éntingayén dob ni sugu-suguén. ");
INSERT INTO tiy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Endob amuk tete i adat i ni sugu-suguén atin fégitungé no mano, ‘Mérugay sénay késéfule i amu guwe.’ ");
INSERT INTO tiy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Atin féganaya noy lémubage bé de dumo no sugu-suguén, atin mama brab miném séréngan bé de molon. ");
INSERT INTO tiy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tidéw béno, séfule i amu ne bé gaiwe énda gétigay ni de sugu-suguén, atin kétékowan. ");
INSERT INTO tiy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mélaw i amu ne, kukumé noy ni sugu-suguén atin fédiyoé no dob gonoy de ubo-ubo étéw. Diyo kémérew brab kémigét i de kifé no.” ");
INSERT INTO tiy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Atin nuret Jesuse man i sébaane binuwaya fantag bé késéfule ne mano, “I kéféguléw i Tuluse loo bé ni. Wén i do folo gétéw kénogon. Nangéy ro bénalak i ségétéwe témérima lagéy. I séngae kénogon wén i kaan solo nuwit. ");
INSERT INTO tiy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Endob i limowe de gétéw do béngu brab i de limo de gétéw do métilédtéd. ");
INSERT INTO tiy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Non i de limo de do béngu ménuwit ro do solo éndob énda i do wayégén. ");
INSERT INTO tiy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Endob i de limo de gétéw do métilédtéd nuwit roy de solo brab de katiya ménféno fitroliyo. ");
INSERT INTO tiy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tidéw béno, ménlis i témérimawe ni lagéy. Atin mélaw ménwaléy manat i de ni folo gétéw kénogon. Atin énggéfidong ro. ");
INSERT INTO tiy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Amun kérara kélungononén, wén i mékese mano, ‘Ay ni nén i témérimawe lagéy énggumahén! Enggomén, angéy gom balak.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sonom béno, méntek i de folo ni gétéw kénogon, atin ténumo roy de solo ro. ");
INSERT INTO tiy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tidéw béno, i de béngu ni do kénogon bénréh ro dob de métilédtéd do kénogon maro, ‘Irayan gey bé fitroliyo goma nan, non ménfadéng i de solo gey.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Endob séménumbul i de métilédtéd do kénogon maro, ‘Enda fakayén non kulang i fitroliyo geye ké tukido key de begom. Fatut angéy gom de béléy kagom.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mélaw ménagéw i de béngu ni do kénogon inok méléy ro do fitroliyo. Atin amun ménagéw ro, énggumahén i témérimawe lagéy. Atin i limowe de do énggétafay, ménodor ro bé témérimawe ni lagéy ménahur ro dob uyote. Tidéw béno, ménfintuén i béngawane. ");
INSERT INTO tiy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Enda mérugayén tidéw béno, énggumah man i de béngu do kénogon. Atin téménawag ro maro, ‘Maistéro, féahurén gey.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Endob séménumbul i témérimawe ni lagéy mano, ‘Tintu fo énda gélolo gu begom.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Atin fénggilid Jesusey binuwayae ni mano, “Been i funa kome fatut mingat. Non énda gétiga kom i gai guwe séfule.” ");
INSERT INTO tiy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Atin ménuret man i Jesuse sébaan binuwaya fantag bé kéféguléw i Tuluse bé de étéwén mano, “Wén i ségétéwe étéw ménagéw mangéy dob mérayue ingéd. Amun énda séna magéwén de, ténawagén i de sugu-sugué no atin sénarigén i de languntama no dob berowe. ");
INSERT INTO tiy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nirayén dob séngae sugu-suguén loo bé kétilédtéd ruwe. Dob sunguwe de niraya no limo ngibu kurta. Atin dob géruwowe de niraya no ruwo ngibu, atin dob gétéléwe de niraya no séngibu kurta. Tidéw béno, ménagéwén i ni étéw ménangéy dob mérayue ingéd. ");
INSERT INTO tiy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sonom so bé kéagéw i amu ruwe, i sunguwe sugu-suguén méndagang-dagang. Atin énggéinség de limo ngibu kurta. ");
INSERT INTO tiy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Atin loo so bé niy rénigoy géruwowe sugu-suguén, atin énggéinség de ruwo ngibu kurta. ");
INSERT INTO tiy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Endob i gétéléwe sugu-suguén ménagéw brab kéménalut dob fantade, atin lénébéngén i séngibuwe kurta sénarig dob beene. ");
INSERT INTO tiy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tidéw béno, amun ménrugayén, ménséfule i amu ruwe atin ténawagén i de sugu-sugué no inok étuké noy kurta ne. ");
INSERT INTO tiy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Atin i sunguwe sugu-suguén, téméningé brab ménbéréh dob amu ne mano, ‘Amu, ay niy limowe ngibu kurta sénarigém dob begéne. Ay ni soy limowe ngibu kurta inségén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Atin ménbéréh i amu ne mano, ‘Fiyo, mésarigon go brab fiyo go sugu-suguén. Non mésarigon go bé klohe, mésarigon go so bé médoowe. Méuyotu ké moror go séréngan begén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tidéw béno, i géruwowe sugu-suguén téméningé brab ménbéréh mano, ‘Amu, ay niy ruwowe ngibu kurta sénarigém dob begéne. Atin ay ni soy ruwowe ngibu inségén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tidéw béno, ménbéréh i amu ne mano, ‘Fiyo, mésarigon go brab fiyo go sugu-suguén. Non mésarigon go bé klohe, mésarigon go so bé médoowe. Méuyotu ké moror go séréngan begén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tidéw béno, téméningé i gétéléwe sugu-suguén. Atin ménbéréh mano, ‘Amu, gétiga ku beem métégas go fo étéw. Edoté moy békéne kaam, brab kétéwé moy békéne nohokém. ");
INSERT INTO tiy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mélaw mégilaku fo beem. Atin mélaw, ménagéwu brab bénunéy guy kurta me dob fantade inok énda métadino. Atin téngténgém, ay niy séngibuwe kurta sénarigém dob begéne.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tidéw béno, ménkérit i amu ne, atin ménbéréh mano, ‘Tete go fo sugu-suguén brab faukén go fo toow. Aw gétiga mo médotu kun bé békéne kagén, brab kéntéw guy békéne nohok gu? ");
INSERT INTO tiy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Amuk kémarang go loo bé nan, fatut damén féndiyoém i kurtae dob bangkue inok buluk séfuleu, fakay doté ku brab wén i inségén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tidéw béno, bénréh i amue ni dob de étéw dob sékulo ruwe téménindég mano, ‘Dot gom i kurta ne atin iray gom dob ségétéwe wén i folo ngibu kurtaén. ");
INSERT INTO tiy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Non i de étéw mésarigon ro, umanan irayan inok waléy médooy karowe de. Endob i de étéw énda mésarigon ro, fiyon i klohe dob berowe dotén so. ");
INSERT INTO tiy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Atin i ni tete sugu-suguén, ibér gom dob liyuwe dob délémone gonon. Diyo kémérew brab kémigét i de kifé no.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Atin ménuret man i Jesuse ségiyo binuwaya mano, “I Nga i Kéilawane, sani Begéne, amuk séfuleu begey i de télaki gu inok méguléw, mésaru dob sarane kay méguléwe. ");
INSERT INTO tiy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Atin mélimud dob adafa kuwey kéluhanay de étéw. Atin féganané kuy de fiyo étéw bé de tete étéw ségiléw bé kéféganay témalimae bili-bili bé de bili-bili no brab de kambing. ");
INSERT INTO tiy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Atin fédiyoé kuy de fiyo étéw dob kuwono kuwe atin fédiyoé kuy de tete étéw dob biwong guwe. ");
INSERT INTO tiy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Atin i Begéne, sani méguléwe, béréhé ku dob de fiyo étéw dob kuwono kuwe maku, ‘Fénfiyoy Abay guwe Tulus begom. Enggomén, ahur gom dob kéféguléw i Tuluse loo bé kébantak ne de tidéw bé kélimbag ne bé duniyae ni. ");
INSERT INTO tiy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Non amun ménlayafu, fénama gom Begén. Atin amun méntéruménu, féniném gom Begén. Atin amun énda séna gélolo gom Begén, ténayakuf gom Begén dob de lawi gom. ");
INSERT INTO tiy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Atin amun énda i kégal gu, fénkégal gom Begén. Atin amun déménruunu, ténalima gom Begén. Atin amun ménférisuwu, ténukaw gom Begén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tidéw béno, i de ni fiyo étéw émbéréh dob Begéne maro, ‘Kadnan, kédiron i kégito geye Beem mélayaf atin fénama gey Beem, taloo no térumén go atin féniném gey Beem? ");
INSERT INTO tiy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Brab kédiron i kétayakuf geye Beem dob de lawi gey fiyon fo ké énda séna gélolo gey Beem? Brab kédiron i kégito geye Beem félawas atin féngkégal gey Beem? ");
INSERT INTO tiy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Brab kédiron i kégito geye Beem déméruun taloo no ménférisu go atin ténukaw gey Beem?’ ");
INSERT INTO tiy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tidéw béno, béréhé ku bé de fiyo étéw maku, ‘Béréhé ku begom i toowe, amun ménggédaw gom bé ségétéwe gérifantad dumo gu, maak ménggédaw gom so Begén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tidéw béno, béréhé ku dob de étéw dob biwong guwe maku, ‘I begome médait gom mékukum, férayu gom tidéw dob Begéne. Angéy gom dob aféye énda émfandaén taman sa taman méntafayén ka Satanase brab de kaan do kuyug do saitan. ");
INSERT INTO tiy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Non amun ménlayafu, énda fénama gom Begén. Atin amun méntéruménu, énda féniném gom Begén. ");
INSERT INTO tiy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Atin amun énda gélolo gom Begén, énda ténayakuf gom Begén dob de lawi gom. Atin amun énda i kégal gu, énda fénkégal gom Begén. Atin amun déménruunu brab amun ménférisuwu, énda ténalima gom Begén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tidéw béno, i de ni tete étéw émbéréh ro maro, ‘Kadnan, kédiron wayoy kégito geye Beem mélayaf taloo no térumén, taloo no ségétéw go énda gélolo gey de, taloo no énda i kégalém, taloo no déméruun, taloo no ménférisu, atin énda ténabang gey Beem?’ ");
INSERT INTO tiy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Atin i Begéne, sani méguléwe, sumbulo ku bero maku, ‘Béréhé ku begome i toowe, amun énda ténabang gom i ségétéwe toow fo gérifantad kuyug gu, maak énda so ténabang gom Begén.’ ");
INSERT INTO tiy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tidéw béno, i de ni do tete étéw, féangéyé ku bero dob uleono emferno inok mékukum ro taman sa taman. Endob i de métintu do étéw gédoté roy umule magufusa.” ");
INSERT INTO tiy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Amun énggilid i Jesuse témoro bé de ni, ménbéréh dob de kuyugén mano, ");
INSERT INTO tiy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gétiga kom amuk méifus i ruwowe gétérésangan, gégumah i gaiy kanduli tome do Judio féndawét ‘Témara.’ Bé béno, i Begéne sani Nga i Kéilawane, atéénu inok féléhué ro Begén dob kruse.” ");
INSERT INTO tiy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Bé béno so, i de odoroy de fadi brab de odoroy de Judio, ménlimud ro dob lawi i gérotore fadi féndawét Kayafas. ");
INSERT INTO tiy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Diyo ménséfagayun ro kéfoé roy Jesuse inok féléhuén. Endob bénantak ro rigonén ké énda i ségiyo étéw de gétigan. ");
INSERT INTO tiy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ménsébéréh ro maro, “Békén saén bé lala tome kémanduli, kinok wén i mérimbur bé de étéw.” ");
INSERT INTO tiy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Atin diyo i Jesuse dob lawi i ségétéwe ménadi-adinén fémuteén féndawét Simon, dob ingéde Betania. ");
INSERT INTO tiy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Atin bé lala Jesuse mama, énggumah i ségétéwe libun wén i fiyo katiyaén ménféno bé balilagae nor fégéféamut. Atin ménfégédét dob Jesuse, atin lénukaén dob uléw ne. ");
INSERT INTO tiy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Endob i de kuyugén, amun énggito roy ni rénigoy libune ni, ménwaléy ro mékérit. Atin ménbéréh ro maro, “Sedek séninggula saén i nan fégéféamut? ");
INSERT INTO tiy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Non amuk fénbéléy damén i nan nor, wén i médoo kurta gédotén de brab iray damén dob de méskinan.” ");
INSERT INTO tiy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Endob i Jesuse énggétiga noy kébéréh ruwe, atin ménbéréh mano, “Kagom dowoyén i libune ni. Non toow fo fiyoy rénigo nuwe dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","I de méskinan taus ro bati dob begome sénga tékélid, éndob i Begéne énda démoyunu bati dob begome. ");
INSERT INTO tiy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bé kéluka ne bé fégéféamute dob Begéne, fégétafay bé lowoh guwe ké lébéngénu. ");
INSERT INTO tiy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Atin béréhé ku begom i toowe, dob séngae gonon dob duniyae ni uretén i Fiyowe Uret, uretén soy kérigo nuwe Begén. Mélaw i de étéw gétédémo roy ni libun.” ");
INSERT INTO tiy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tidéw béno, i ségétéwe bé de folo bra ruwo kuyugén féndawét Judas Iskariot ménangéy dob de odoroy de fadi. ");
INSERT INTO tiy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Atin ménénginsa dob berowe mano, “Firoy i iray gome begén ké fékéfo guy Jesuse dob begome?” Atin bénayada ro téléw folo félatah. ");
INSERT INTO tiy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tidéw bé no gai, sénléd Judasey fiyowe gai fékéfoén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Amun dob sunguwe fuweh bé kékanduli i de Judio féndawét “Fan énda i Fégéfééruk de” look “Témara”, i de kuyugén ménangéy ro dob Jesuse atin ménénginsa ro maro, “Hon i kétaya muwe gono key témafay bé amaé muwe bé ni kanduli?” ");
INSERT INTO tiy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Atin séménumbul i Jesuse mano, “Angéy gom Jerusalem atin béréh gom dob étéwe diyo makom, ‘Enggumahén kun i uras i Maistérowe. Mélaw mamung bé kékandulie “Témara” begey i de kuyugén dob lawi me.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mélaw i de kuyugén nodoro roy kébéréh Jesuse, atin ténafay roy amaé ruwe kay kandulie féndawét “Témara” dob no lawi. ");
INSERT INTO tiy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Amun kélungononén, i Jesuse ménsar mama séréngan bé de folo bra ruwo gétéw kuyugén. ");
INSERT INTO tiy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bé lala ruwe mama, bénréh Jesuse mano, “Béréhé ku begom i toowe, wén sékoy ségétéwe begom émfékéfo Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tidéw béno, toow fo méntete i de fédéw i de kuyugén, atin ménénginsa i séngae ségétéw bero dob Jesuse maro, “Kadnan, békén begén, hay?” ");
INSERT INTO tiy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Séménumbul i Jesuse mano, “I ségétéwe séréngan Begén mérém fan, beeney émfékéfoe séko Begén. ");
INSERT INTO tiy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","I Nga i Kéilawane, sani Begéne, méléhuu loo bé kébéréh i Ménsulate Kébéréh i Tuluse. Endob toow fo mékégédaw-gédaw i émfékéfoe Begén. Mas na fiyo dob beene ké énda damén ménumah i ni étéw, non mékukum fo toow.” ");
INSERT INTO tiy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tidéw béno, ménbéréh i Judase sani ménfékéfoe de mano, “Maistéro, békén begén, hay?” Atin séménumbul i Jesuse mano, “Hoo, beem.” ");
INSERT INTO tiy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","I lala ruwe mama, éndot Jesusey fane brab ménfésalamat dob Tuluse. Tidéw béno, sénkébeng-kébengén, brab sénaarén dob de kuyugén. Atin ménbéréh mano, “Ay niy lowoh guwe. Dot gom brab ama gom.” ");
INSERT INTO tiy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tidéw béno, éndot Jesusey tabue wén i arak de atin ménfésalamat dob Tuluse. Atin nirayén dob berowe mano, “Iném gom de, kéluhana kom. ");
INSERT INTO tiy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Non been i niy dara guwe, sani tandae bé fasad i Tuluse, réménanas inok méfésagadan i de sala i de médoo do étéw. ");
INSERT INTO tiy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Béréhé ku begom, éndaén minému arak taman dob gaiwe minému mantu arak séréngan begom amuk méguléw i Abay guwe Tulus dob de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tidéw béno, kéménanta ro sébaan kanta démayéw bé Tuluse. Tidéw béno, ménagéw ro mangéy dob tuduke féndawét Olibo. ");
INSERT INTO tiy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Atin ménbéréh i Jesuse dob de kuyugén mano, “Kino séko bé ni kélungonon méraréy gom kéluhanan tagaké kom Begén non wén i Ménsulate Kébéréh i Tuluse mano, ‘Féléhué kuy témalimae bé de bili-bili, atin i de bili-bili no émbéragar ro.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Atin féntaus Jesusey kébéréh me mano, “Endob amuk tébuleu, magéwu métah begom mangéy Galilea.” ");
INSERT INTO tiy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tidéw béno, ménbéréh i Pedrowe dob Jesuse mano, “I begéne, énda fo tagaké ku Beem, fiyon fo ké méraréy i kéluhanay de dumo gu.” ");
INSERT INTO tiy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Endob ménbéréh man i Jesuse mano, “Béréhé ku beem i toowe, bé énda séna ukoro i férufete bé ni kélungonon, dirungé mo Begén téléw gule bé énda gélolo mo Begén.” ");
INSERT INTO tiy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ménbéréh man i Pedrowe mano, “Enda fo dirungé ku Beem, fiyon fo ké méléhuu séréngan Beem.” Atin loo so bé niy kébéréh i de kéluhanay de dumo kuyugén. ");
INSERT INTO tiy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tidéw béno, ménagéw i Jesuse beroy de kuyugén dob gonone féndawét Getsemani. Amun énggumah ro diyo, ménbéréh i Jesuse dob berowe mano, “Sar gom dob ni bé lala guwe mangéy démasal dob diyoo.” ");
INSERT INTO tiy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Atin nuwitén i Pedrowe brab de ruwo gétéw lagéy nga Sebedeowe, sani Santiagowe brab Juane. Atin méntete i fédéw Jesuse brab ménbuku fo toow. ");
INSERT INTO tiy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Atin ménbéréh dob de ni téléw gétéw kuyugén mano, “I fédéw guwe toow fo ménbuku taman toow fo démawét. Bati gom dini, brab tulik gom.” ");
INSERT INTO tiy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tidéw béno, ménagéw i Jesuse gumaha témabar. Atin méntéléngkéb méntédunsum brab déménasal mano, “Abay, amuk fakay saén, kago fédayaén Begén mérasay. Endob i kaame saén kétayan i mérigowe damén, békén kagén kétayan.” ");
INSERT INTO tiy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tidéw béno, ménséfule dob de téléw ni gétéw kuyugén. Atin énggito no bero énggéfidong. Ménbéréh dob Pedrowe mano, “Aw énda wayo gétulik go fiyon ségéuras saén?” ");
INSERT INTO tiy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Atin ménbéréh dob berowe téléw gétéw mano, “Tulik gom, atin dasal gom inok énda métukawan gom. Méuyot gom rémigo bé kétaya kuwe, éndob i de lowoh gom mélubay brab magad géfélis bé de sugu gu.” ");
INSERT INTO tiy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tidéw béno, ténagak Jesuse man bero, atin déménasal mano, “Abay, amuk énda fakayén ké géséliyahu bé ni kérasay, mérigo damén i kétaya muwe.” ");
INSERT INTO tiy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tidéw béno, ménséfule man i Jesuse mangéy dob de téléw ni gétéw kuyugén. Atin énggito no bero énggéfidong non toow ro fo manat. ");
INSERT INTO tiy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tidéw béno, ténagak Jesuse man bero bé gétéléwe gule inok démasal. Atin déménasal ségiléw so bé énggéétahe de. ");
INSERT INTO tiy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tidéw béno, ménséfule man mangéy dob de téléw ni gétéw kuyugén atin ménbéréh dob berowe mano, “Aw tafay gom so fidong brab témérén? Téngténg gom! Enggumahén i urase fékéfo i Nga i Kéilawane, sani Begéne, atin atéénu dob de ménsala étéw. ");
INSERT INTO tiy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na, tek gom, magéw tomén. Téngténg gom, ay nan nén gégumah i émfékéfoe Begén!” ");
INSERT INTO tiy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Amun émbéréh sénay Jesuse, énggumah i Judase sani ségétéwe bé de folo bra ruwo gétéw kuyugén. Atin wén i dakéle ménlimud étéw dob beene énggumah. Non sénugu i de odoroy de fadi brab de odoroy de Judio bero. Atin ménuwit ro do sundang brab do bastun. ");
INSERT INTO tiy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Atin énggétiga roy ati fégélolono ruwe bé Jesuse, non amun énda séna gégumah ro diyo, bénréh Judase bero mano, “I étéwe aréké ku, kéfo gom non Been.” ");
INSERT INTO tiy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mélaw sonom so bé kégumah Judase, ménfégédét dob Jesuse brab ménbéréh mano, “Fiyo kélungonon, Maistéro.” Tidéw béno, narék Judasey Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tidéw béno, ménbéréh i Jesuse dob Judase mano, “Adih, fétausém i kérigo muwe bé rigoné muwe.” Tidéw béno, i de étéw ménodor bé Judase, ménfégédét ro dob Jesuse brab kénéfo ro. ");
INSERT INTO tiy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Atin wén i ségétéwe kuyug Jesuse bénindasén i sundang ne atin ténibohén i ségétéwe riféy gérotore fadi brab ménsilaf i ségébalae bé kélingo ne. ");
INSERT INTO tiy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Endob ménbéréh i Jesuse mano, “Rumaém i sundang ma nan. Non i kéluhanay de témiboh, méléhu ro so bé sundange. ");
INSERT INTO tiy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aw énda ba gétiga mo de? Amuk kétaya ku, gétawagu mongot tabang dob Abay guwe Tulus, atin sugué noy laksaéne do télaki no témabang Begén matuhon bé de ni étéw. ");
INSERT INTO tiy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Endob amuk rigoné kuy nan, énda métuman i de Ménsulat Kébéréh i Tuluse fantag bé ati mérigowe dob Begéne.” ");
INSERT INTO tiy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tidéw béno, ménbéréh i Jesuse dob de ménlimud do étéw mano, “Sedek ménuwit gom do sundang brab do bastun, inok kéfoé kom Begén maak ségétéwu tulisan kéfoé kom? Sénga fuweh diyou dob lawi i Tuluse témoro, éndob énda kénéfo gom Begén. ");
INSERT INTO tiy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Endob ménrigoy kéluhanay de ni inok métuman i Ménsulate Kébéréh i Tuluse sénulat i de sénarigo no.” Tidéw béno, kéluhanay de kuyugén ménraréy ténagak roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Atin i de étéw kéménéfo bé Jesuse nuwit ro dob lawi i gérotore fadi féndawét Kayafas. Diyo ménlimud i de témoro bé kitabé brab de odoroy de Judio. ");
INSERT INTO tiy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Atin i Pedrowe ménfuray ro bero éndob énda ménfégédétén, méntaman saén dob fésayaway lawi i gérotore ni fadi. Atin ménahur dob fésayawane ni brab ménsar diyo beroy de guwardiya inok gétiga noy ati mérigowe dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Atin i odoroy de fadi brab kéluhanay de ménlimud do odoron séménléd ro do tugi kétébo bé Jesuse inok kukumé ro méléhu. ");
INSERT INTO tiy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Endob énda i énggélingoo ro funa ro de méméléhu, fiyon fo ké médooy de téménindég brab ménbéréh do tugién kétébo bé Jesuse. Tidéw béno, wén i ruwowe gétéw lagéy téménindég brab ténébo roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ménbéréh ro maro, “Ménbéréh i ni étéw mano, ‘Gébinasana kuy lawi i Tuluse atin fétindégé ku man bé téléwe gétérésangan.’ ” ");
INSERT INTO tiy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tidéw béno, i gérotore fadi téménindég brab ménbéréh dob Jesuse mano, “Ati késumbul me bé ni kétébo ro Beem?” ");
INSERT INTO tiy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Endob ménantés i Jesuse. Tidéw béno, ménbéréh man i gérotore ni fadi mano, “Sugué ku Beem sémafa dob adafay méuyage Tulus, aw Beeme bay Kristowe Nga i Tuluse?” ");
INSERT INTO tiy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Atin séménumbul i Jesuse mano, “Toow i nan bénréhém bé Nga i Tuluse Begén. Atin béréhé ku begom i toowe, gito gom i Nga i Kéilawane, sani Begéne, mésar moso dob kuwonoy barakatane Tulus brab gito gom Begén dob de rawén séfuleu tidéw dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sonom béno, i gérotore ni fadi amun énggélingoo noy ni kébéréh Jesuse, kénusién i kégal ne inok fégito noy kékérit ne de. Atin ménbéréh mano, “Mékémurka fo toow i kébéréh ne non réféngé noy Tuluse! Endaén kailanga tom i téméboe de dob betome. Non énggélingoo tomén i mékémurkae kébéréhén béleewe ni. ");
INSERT INTO tiy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ati karang gome de fatut rigoné tom?” Atin séménumbul i de odoron maro, “Fatut mékukum méléhu.” ");
INSERT INTO tiy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tidéw béno, dénuraa roy rangih Jesuse atin lénubag ro. Atin wén soy do téménamfiling bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Atin ténléb roy de moto no bé munsalawe brab ménbéréh ro maro, “Amuk Beem i Kristowe, antukém ké ati téménamfilinge Beem.” ");
INSERT INTO tiy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","I lala i de ni mérigo, i Pedrowe diyo ménsar dob fésayawane. Atin ménfégédét i ségétéwe kénogon sugu-suguéy gérotore fadi. Atin ménbéréh dob Pedrowe mano, “Beem soy dumo Jesuse tidéw Galilea.” ");
INSERT INTO tiy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Endob dénirung Pedrowe dob téngaangay de étéw diyo mano, “Enda gétiga kuy nan béréhé mo.” ");
INSERT INTO tiy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tidéw béno, ménangéy i Pedrowe dob béngaway fésayawane. Diyo wén i ségiyowe kénogon sugu-suguén énggito noy Pedrowe. Atin ménbéréh dob de lagéy diyo mano, “Ay niy ségétéwe dumo Jesuse tidéw Nasaret.” ");
INSERT INTO tiy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Atin dénirung Pedrowe man mano, “Méléhuu so dob ni, énda gélolo guy nan lagéy.” ");
INSERT INTO tiy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Enda ménrugayén tidéw béno, i de lagéy téménindég diyo ménfégédét ro dob Pedrowe. Atin ménbéréh ro maro, “Tintu fo beem i ségétéwe bero. Non dob kébéréh me énggélolo gey beem ségétéw go so tidéw Galilea.” ");
INSERT INTO tiy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tidéw béno, séménafa foy Pedrowe dob berowe mano, “Amuk tugio ku begom, kukuméy Tuluse begén. Enda gélolo guy nan étéw!” Sonom béno, ménukoro i férufete. ");
INSERT INTO tiy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Atin énggétédémo Pedrowey kébéréh Jesuse mano, “Bé énda séna ukoro i férufete, dirungé mo Begén téléw gule bé énda gélolo mo Begén.” Mélaw i Pedrowe, ménsut tidéw diyo atin kéménrew fo toow. ");
INSERT INTO tiy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Amun toow géfuwén, i kéluhanay de odoroy de fadi brab de odoroy de Judio, ménlimud ro inok bantaké roy kéféléhu ruwe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Atin nikét roy Jesuse brab nangéy ro naté dob Pilatowe sani méguléwe tidéw Roma. ");
INSERT INTO tiy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","I Judase, sani ménfékéfoe de, amun énggito noy kékukume bé Jesuse, énggésénule. Mélaw nuwitén séfule i téléwe folo félatah mangéy dob de odoroy de fadi brab dob de odoroy de Judio. ");
INSERT INTO tiy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Atin ménbéréh mano, “Ménsalau non fénkéfo gu inok féléhuén i ni ségétéw étéw énda i rénigo no tete.” Endob séménumbul i de odoron maro, “Ulanden dob begeye. Kaam saén sala i nan.” ");
INSERT INTO tiy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tidéw béno, i Judase nibérén i de kurta ni dob lawi i Tuluse, atin ménagéw tidéw diyo. Atin ménfétoyo méntébitin. ");
INSERT INTO tiy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","I de odoroy de fadi ténimu roy de félatah ni brab ménbéréh ro maro, “I ni kurta fénggéféléhu bé étéwe, mélaw énda fakayén dob kitab tome itongén dob tulakane dob lawi i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Atin amun ménagayun ro, nusar roy kurtae ni fégébéléy bé fantad i ségétéwe rémigo binangga, inok wén i fantad lébéngon bé de étéw énda bati ro dob Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Been i funay fantade ni féndawét “Démara Fantad” taman béleewe ni. ");
INSERT INTO tiy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mélaw méntuman i kébéréh i sénarigoy Tuluse muret bé kébéréh ne bé do gétah féndawét Jeremias mano, “Endot roy téléwe folo félatah, sani kurtae ménagayun i de Judio fénggébéléy de. ");
INSERT INTO tiy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Atin nusar roy ni kurta fénggébéléy bé fantad i ségétéwe rémigo do binangga, loo bé sugu i Kadnane Begén.” Been i niy kébéréh Jeremiase bé gétahe. ");
INSERT INTO tiy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Atin i Jesuse téménindég dob adafay méguléwe tidéw Roma féndawét Pilato. Atin fénénginsaa noy Jesuse mano, “Aw Beem i Datu i de Judio?” Atin séménumbul i Jesuse mano, “Beem i ménbéréh de.” ");
INSERT INTO tiy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Endob amun ténébo i de odoroy de fadi brab de odoroy de Judio, ménantés saén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mélaw ménbéréh i Pilatowe dob Jesuse mano, “Sedek énda sumbulo moy kéluhanay de kétobo ro ni Beem?” ");
INSERT INTO tiy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Endob énda séménumbul i Jesuse, ménantés saén. Mélaw ménggaif fo toow i méguléwe. ");
INSERT INTO tiy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I ni ménrigowe bé gaiy kékandulie Témara. Atin i adat i méguléwe, sénga kanduli ro Témara témangéy ségétéw férisu fémiliéy de ménlimud do Judio. ");
INSERT INTO tiy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bé no gai, wén soy ségétéwe bantugén férisu féndawét Barabas. ");
INSERT INTO tiy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mélaw amun ménlimud i de étéw, ménénginsa i Pilatowe dob berowe mano, “Ati isuwe kétaya kom tangéyé ku inok géésut dob begome? Barabas loo ké Jesuse féndawét so Kristo?” ");
INSERT INTO tiy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Rénigo noy ni non énggétiga no i de odoroy de Judio, naté roy Jesuse non méndaléw ro de. ");
INSERT INTO tiy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Amun diyo ménsar i Pilatowe dob saray kémukume, fénsamfay i bawag ney sébaane kébéréh mano, “Kago rigonén i éntingayéne dob ni étéw énda i salaén. Non wén i énggétéginéfo kuwe na kélungonono atin toowu fo ménbuku fantag bé Beene.” ");
INSERT INTO tiy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Endob i de odoroy de fadi brab de odoroy de Judio, fénfagayu roy de ménlimud do étéw bé ongoté ro dob Pilatowey tangéyé noy Barabase, atin féléhuén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Endob i Pilatowe ménénginsa mano, “Aw ati isuwe wayo kétaya kom tangéyén inok géésut dob begome?” Atin séménumbul i de étéw maro, “Barabas.” ");
INSERT INTO tiy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Atin ménénginsa i Pilatowe mano, “Ati mélaw i rigoné kuwe dob Jesuse féndawét so Kristo?” Séménumbul ro kéluhanan maro, “Féléhuén dob kruse!” ");
INSERT INTO tiy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Endob ménénginsa man i Pilatowe mano, “Endob ati tetee rénigo no?” Tidéw béno, ménkes i de étéw minut métanug maro, “Féléhuén dob kruse!” ");
INSERT INTO tiy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Amun énggétiga Pilatowe énda fo magayun i de étéw atin sérimbur ro séko, éndotén i wayége atin méngguse dob téngaangay de étéw. Atin ménbéréh dob berowe mano, “Békén kagén sala i kéléhu i ni étéw énda i salaén. Kagom saén aturan.” ");
INSERT INTO tiy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Atin ménbéréh i kéluhanay de étéw maro, “Kagey aturan i kéléhu ne brab aturay de séfu gey so.” ");
INSERT INTO tiy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tidéw béno, ténangéy Pilatowey Barabase mésut mangéy dob de étéw. Atin féntafésén i Jesuse. Tidéw béno, natéén dob de sundalo inok kélabo ro dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tidéw béno, i de sundalo Pilato nuwit roy Jesuse mahur dob lawi Pilatowe. Atin i kéluhanay de dumo ro sundalo ségébataliyon ménlimud ro géliwét bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Atin lénékas roy de kégalén brab fénkégal ro bé furowe kégal maak datu. ");
INSERT INTO tiy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tidéw béno, lénuku roy suwarane kélég atin fénsayaf ro bé Jesuse, atin féndiyo roy kayéwe dob kuwonone kémérén ubo-ubo maak datu. Tidéw béno, ménlingkuwéd ro dob adafa nuwe brab déniyangka ro. Atin ménbéréh ro maro, “Méraru damén i datu i de Judio.” ");
INSERT INTO tiy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Atin dénuraa ro, brab éndot roy ni kayéw tidéw dob kémér ne brab bénadas roy uléw ne. ");
INSERT INTO tiy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Amun énggilid ro déniyangka, lénékas roy furowe ni kégalén brab fénkégal ro man bé kaane kégal. Tidéw béno, nuwit ro mésut inok kélaboné ro dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","I lala ruwe magéw tidéw Jerusalem, énggébalaka roy étéwe féndawét Simon tidéw dob ingéde Siren. Atin i de sundalo fénégés ro démuwal bé krus Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Atin énggumah ro dob sébaane gonon féndawét Golgota (i atag ne “gonoy kulobong uléwe.”) ");
INSERT INTO tiy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Diyo niray roy arake sénlawék bé uwae fégékédan démawét féniném ro bé Jesuse. Endob amun éngétemtemo no, ménika de miném. ");
INSERT INTO tiy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tidéw béno, kénlabo ro dob kruse. Atin sénbaad roy de kégalén bé késékungkungo ruwe de. ");
INSERT INTO tiy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tidéw béno, ménsar ro diyo ténéngténg roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Atin féndiyo roy sénulat ruwe fingé rotor bé uléw Jesuse bé kétébo ruwe de mano, “Ay niy Jesuse, sani datu i de Judio.” ");
INSERT INTO tiy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tidéw béno, kénlabo ro dob de krus i ruwowe gétéw tulisan, i ségétéwe de fingé dob kuwono nuwe brab i ségétéwe de fingé dob biwong ne. ");
INSERT INTO tiy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Atin i de étéw, téménara ro dob adafa Jesuse atin déniyangka ro brab dénangu-danguo ro inok dowoyé ro. ");
INSERT INTO tiy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Atin ménbéréh ro dob Jesuse maro, “Bénréhém bé binasané moy lawi i Tuluse atin fétindégé mo man bé téléwe gétérésangan. Amuk tintu Nga i Tuluse Beem, tabangém i lowoh me atin lus go tidéw dob krusa nan inok énda méléhu go.” ");
INSERT INTO tiy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Atin ségiléw so bé ni, i de odoroy de fadi brab de témoro bé kitabe brab de odoroy de Judio déniyangka ro. ");
INSERT INTO tiy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ménbéréh ro maro, “Ténabangén i de ségiyo étéw inok énda méléhu ro, éndob énda gétabanga noy lowoh ne inok énda méléhuén. Amuk Beeney datu tome do Judio, fatut mélus tidéw dob krusa nan inok géunur tom de. ");
INSERT INTO tiy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sémarig bé Tuluse brab bénréhén bé Been kun i Nga i Tuluse. Na, énténgé tom ké féimuéy Tuluse brab tabangé no béleewe ni inok énda méléhuén.” ");
INSERT INTO tiy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Atin fiyon i de tulisan séréngan bé Jesuse kénlabo dob de krus, déniyangka ro so. ");
INSERT INTO tiy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Amun géutuhén, ménwaléy délémon i kéluhanay fantade taman ménifus i téléwe géuras. ");
INSERT INTO tiy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Amun géraraan lémudug i térésange de, ménkes i Jesuse mano, “Eli, Eli, lama sabaktani?” I atag ne, “Tulus gu, Tulus gu, sedek ténagakém Begén?” ");
INSERT INTO tiy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Atin i de dumo bé de étéw témindég diyo, énggélingoo roy ni kébéréhén, atin ménbéréh ro maro, “Tawagé noy Eliase.” ");
INSERT INTO tiy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Atin wén i ségétéwe bero ménagayas éndotén i maake gafas, nérémén dob mélémuwe arak, féndiyoén dob kayéwe, brab ténunggulén dob ba Jesuse inok fééséfén de damén. ");
INSERT INTO tiy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Endob i de dumo bé de étéw téméngténg, ménbéréh ro maro, “Fédayaém mon, non méuyot gey de téméngténg ké gégumah i Eliase témabangan de inok énda méléhuén.” ");
INSERT INTO tiy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tidéw béno, ménkes man i Jesuse atin ménléhuén. ");
INSERT INTO tiy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tidéw béno, i rindunge dob lawi i Tuluse ruwoy ménsésédaya nuwe tidéw rotor mangéy fantad. Atin wén i émbagére luba brab wén i de dakél batéw ménséufak. ");
INSERT INTO tiy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Atin wén i de takub do lébéng ménungka brab médooy de ménléhu do étéw i Tuluse méntébule ro. ");
INSERT INTO tiy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ménagéw ro tidéw dob de lébéng ro. Atin amun méntébule i Jesuse, ménangéy ro mahur dob mékétéfuwe ingéd Jerusalem brab méntéfégito dob médoowe do étéw. ");
INSERT INTO tiy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","I odoroy de sundalo brab de sundalo no ténulik roy Jesuse, amun énggito roy ni luba brab kéluhanay de ni ménrigo, toow fo ménggilak ro. Atin ménbéréh ro maro, “Tintu fo Been i Nga i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Diyo soy de médoo do libun, kémulay ro tidéw dob gétangkae. Beroy de libun ménfuray bé Jesuse tidéw Galilea brab ténabang ro. ");
INSERT INTO tiy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bero ro Maria tidéw Magdala, brab Maria idéng Santiagowe brab Jose, brab idéng Juane brab Santiagowe sani de nga Sebedeo. ");
INSERT INTO tiy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Amun témégénén, énggumah i ségétéwe lagéy kawasa tidéw Arimatea. I dawét ne Jose atin been soy ségétéwe kuyug Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ménangéy dob Pilatowe, atin nongotén i bangkay Jesuse. Atin sénuguén i Pilatowe ké fakay ro iray i bangkay Jesuse dob Josehe ni. ");
INSERT INTO tiy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mélaw éndot Josehe, atin bénausén bé mantuwe fute safut. ");
INSERT INTO tiy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tidéw béno, féndiyoén dob kaane lébéng, mantu séna ténosong dob rangih i fingase. Tidéw béno, kénriringén i dakéle batéw fénggétélébén bé béngaway lébénge ni. Atin tidéw béno, ménagéw i Josehe tidéw diyo. ");
INSERT INTO tiy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Atin diyo i Mariahe tidéw Magdala brab dumo nuwe féndawét so Maria. Ménsar ro dob saréwoy lébénge. ");
INSERT INTO tiy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Bé gétunduge de fuweh, Sabado. Atin i de odoroy de fadi brab de Fariseo ménlimud ro bero ro Pilato. ");
INSERT INTO tiy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Atin ménbéréh ro maro, “Datu, gétédémo key bé méuyag sénay nan étéw ubo-ubo datu gey, bénréhén bé tébule kun ké méifus i téléwe gétérésangan. ");
INSERT INTO tiy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mélaw fiyo ké sugu go bé de guwardiya inok tintu bantayan i lébéng ne taman bé gétéléwe gétérésangan, inok i de kuyugén énda géahur ro témulis bé bangkay ne atin béréhé ro dob de étéw bé méntébule. Non toow na fo gétimal i nan tugi bé sunguwe de.” ");
INSERT INTO tiy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Séménumbul i Pilatowe mano, “Dot gom bé de sundalo gu mantay bé lébéng ne inok énda i géahur diyo.” ");
INSERT INTO tiy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mélaw ménagéw ro atin rénigo roy tandae dob béngaway lébénge inok gito ro ké wén i mahur de. Tidéw béno, féndiyo roy de guwardiya mantayan de. ");
INSERT INTO tiy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Amun ménifus i Sabadowe de, toow géfuwén bé Duminggue de, i Mariahe tidéw Magdala ménagéw mangéy dob lébéng Jesuse beroy dumo nuwe libun féndawét so Maria inok angéyé ro téngténgén i lébénge ni. ");
INSERT INTO tiy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Atin méntékow wén i émbagér luba, atin i télakiy Kadnane ménlus tidéw dob lawayo. Kénriringén i dakéle batéw tidéw dob béngaway lébénge, atin ménsar diyo dob batéwo no. ");
INSERT INTO tiy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","I falas ne maak kilot atin toow fo fute i kégal ne. ");
INSERT INTO tiy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sonom béno, i de guwardiya diyo ménwaléy ro toow fo ménggilak, brab léménukub ro. Atin méntéléngkéb ro maak do ménléhu ro. ");
INSERT INTO tiy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Atin i télakiwe ni ménbéréh dob de libun ni mano, “Kagom mégilak, Gétiga ku sélédé kom i Jesuse, sani fénléhu ruwe dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Endob éndaén dini no, non méntébuleén loo bé bénréh ne mérigo. Enggomén ahur gom, téngténg gom i gono nuwe méniro. ");
INSERT INTO tiy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, fagayas gom agéw mangéy dob de kuyugén atin uret gom dob berowe makom, ‘Méntébuleén i Jesuse. Atin mangéy béni Galilea métah begom. Gito gom diyo.’ Na, taus gom brab fégétédém gom i ni bénréh gu begom.” ");
INSERT INTO tiy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mélaw ménagayas ro ménagéw tidéw dob lébénge ni. Atin fiyon fo ké ménggilak ro, ménoror ro so. Atin léménéntu ro mangéy dob de kuyugén inok ureté ro dob berowe. ");
INSERT INTO tiy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Atin tékow bénalak Jesusey de libun ni atin ménbéréh dob berowe mano, “Fiyo térésang.” Tidéw béno, ménfégédét ro dob Beene brab génamak roy sékéy ne atin fénéngadaf ro. ");
INSERT INTO tiy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Atin ménbéréh i Jesuse dob berowe mano, “Kagom mégilak. Agéw gom atin béréh gom dob de kuyug gu bé fatut magéw ro mangéy Galilea, atin gito ro Begén diyo.” ");
INSERT INTO tiy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Amun ménagéw i de ni libun, i de dumo bé de sundalo mantay bé lébénge ni ménséfule ro mangéy Jerusalem atin nuret ro dob de odoroy de fadi i kéluhanay ménrigowe. ");
INSERT INTO tiy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mélaw i de odoroy de fadi brab de odoroy de Judio, ménsélimud ro. Atin ménagayun ro ké ati rigoné ruwe. Niraya ro médoo kurta i de sundalo. ");
INSERT INTO tiy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Atin bénréh ro bero maro, “Béréh gom bé nangéy i de kuyugén i bangkay ne bé kélungonone atin fénénakaw ro bé lala gome fidong. ");
INSERT INTO tiy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Atin amuk énggélingooy méguléwey fantage bé ni, béréhé key dob beene inok énda mékéritén begom atin mélaw énda i funa kom mégilak.” ");
INSERT INTO tiy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tidéw béno, i de guwardiya, éndot roy kurtae ni atin nodoro roy sugu i de odoroy de Judio ni. Atin mélaw, taman so béleewe ni, wén i do Judio muret bé ni uret. ");
INSERT INTO tiy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tidéw béno, i de folo bra sébaan kuyugén ménagéw ro mangéy Galilea dob sébaane tuduk bénréh Jesuse fatut ayo ro. ");
INSERT INTO tiy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Atin amun énggito roy Jesuse, fénéngadaf ro, fiyon fo ké wén i de dumo bero ruwo-ruwoy de fédéw ro munur de. ");
INSERT INTO tiy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Atin ménfégédét i Jesuse dob berowe atin ménbéréh mano, “I kéluhanay kuwagibé méguléw dob lawayo brab dob fantade niray dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mélaw angéy gom dob kéluhanay de ingéd dob duniyae ni atin féunur gom i kéluhanay de étéw bé Begéne. Bautis gom bero dob dawét i Abaye Tulus, brab Nga i Tuluse, brab Rémogor i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Atin toro gom bero bé fatut odoro roy kéluhanay de sugu gu begom. Atin fégétédém gom i ni, diniwu dob begome sénga tékélid taman dob tamfaday duniyae ni.”");
INSERT INTO tiy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ay niy Fiyowe Uret fantag bé Jesu Kristowe, sani Nga i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bé gétaho, wén i ségétéwe sénarigoy Tuluse muret bé kébéréh ne féndawét Isaias. Sénulatén mano, “Bang i Tuluse, ‘Sugué kuy sarigo kuwe métah Beem inok tafayé noy aguwo muwe.’ ");
INSERT INTO tiy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Diyo dob gonone énda i étéw de bati, brab mékes mano, ‘Gégumah i Kadnane! Tafay gom i aguwo nuwe, brab fééntang gom i de aguwo no.’ ” Been i bénréh Isaiase. ");
INSERT INTO tiy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mélaw énggumah i Juane dob gonone énda i étéw de bati. Mautis bé de étéw brab ménuret mano, “Fatut gom gésénule bé de sala gom brab féka gom i de tete adat gom. Tidéw béno, fébautis gom inok fégito gom i kégésénule gome. Atin, i Tuluse fésagadé noy de sala gom.” ");
INSERT INTO tiy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Atin médooy de étéw dob Judea brab dob ingéde Jerusalem ménangéy ro dob Juane. Fénayag roy de sala ro brab bénautisén bero dob lowoh i wayége Jordan. ");
INSERT INTO tiy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","I Juane ni kéménégal nawél buk dakél ayam féndawét kamelyo, brab kulit binatang i légét ne. Atin i amaé nuwe kasuk brab téné. ");
INSERT INTO tiy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Atin ménuret i Juane mano, “Wén i ségétéwe témundug begén. Toow na fo gérotor begén. Fiyon foy ikét i safatos ne, énda métororu de mukoh. ");
INSERT INTO tiy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wayég i fégébautis guwe begom, éndob i Beene, bautisé no moso begom bé Rémogor i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bé no do gai, énggégumah i Jesuse tidéw dob Nasaret dob sakuf i dakéle ingéd Galilea. Atin bénautis Juane so dob wayégo no Jordan. ");
INSERT INTO tiy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Amun géménaunén i Jesuse tidéw dob wayége, sonom béno énggito noy lawaye ménungka brab i Rémogor i Tuluse ménlus maak marafati brab méntérimféna dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Brab wén i ménbéréhe tidéw dob lawayo mano, “Beem i Nga guwe. Toow fo mégédawu de brab mésuwatu de.” ");
INSERT INTO tiy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tidéw béno, fénagéw i Rémogor i Tulusey Jesuse mangéy dob gonone énda i do étéw de bati. ");
INSERT INTO tiy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Atin ménbati diyo fot folo gétérésangan. Bé béno, sénga tékélid ténéngkad Satanasey Jesuse rémigo tete damén. Diyo soy de mérayar do binatang, éndob énggumah i de télaki brab ténabanga ro. ");
INSERT INTO tiy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Amun ménférisunén i Juane, ménséfule i Jesuse mangéy Galilea, brab nuretén i Fiyowe Uret tidéw dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ménbéréh mano, “Enggumahén i fatute gai. Endaén mérugayén taman gégumah i kéféguléw i Tuluse bé de étéwén. Fatut gésénule gom bé de sala gom brab féka gom i de tete adat gom, brab unur gom dob Fiyowe Uret.” ");
INSERT INTO tiy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wén i no sébaan fuweh ménagéw i Jesuse dob doror i dogote féndawét Galilea. Atin énggito noy ruwowe gétéw fatatugés féndawét Simon brab Andrese tuwaréyén. Ibéré roy de biyala ro dob dogote. ");
INSERT INTO tiy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Atin béréh Jesuse bero mano, “Odor gom Begén. Kagomén séméléd sédo. Tidéw béleewe, fésélédé ku begom étéw inok modor ro so Begén.” ");
INSERT INTO tiy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sonom béno, ténagak roy de biyala ro brab ménodor ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Atin amun méntaus magéw i Jesuse kloh, énggito noy Santiagowe brab Juane sani de nga Sebedeo. Diyo ro dob awang ruwe sékafété roy de biyala ro. ");
INSERT INTO tiy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sonom béno, ténawagén bero. Atin ténagak roy boh ruwe Sebedeo dob awange beroy de témabang do sukayan do fatatugés, atin ménodor ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Atin i Jesuse beroy de kuyugén ménangéy ro dob ingéde Kafernaum. Amun gai kétérén, ménahur i Jesuse dob lawie féngadafay de Judio, brab téménoro. ");
INSERT INTO tiy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Atin i de étéw do mégélingo de, toow ro fo ménggaif bé kétoro ne. Non békén ségiléw i kétoro ne bé de Judio témoro bé kitab ruwe. Non i berowe, ténoro ro say de kéfégitung i de ségiyo étéw. Endob ténoro Jesusey kaane kéfégitung. ");
INSERT INTO tiy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Amun téménoro i Jesuse, tékow ménahur dob lawie féngadafan i ségétéwe étéw rénahukoy saitane. ");
INSERT INTO tiy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Amun énggito noy Jesuse, ménkes mano, “Ati amungé muwe begey, Jesus tidéw Nasaret? Ménangéy go ba dini inok binasané mo begey? Enggétiga ku ké ati Beeme. Beem i Mékétéfuwe tidéw dob Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Endob génlé Jesusey saitane ni mano, “Kago selekén, brab tékédan go tidéw dob beena nan!” ");
INSERT INTO tiy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tidéw béno, i saitane, toow fo fénkikilén i étéwo no brab ménkes métanug, atin méntékédan. ");
INSERT INTO tiy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Atin toow fo ménggaif i de étéw bé ni. Ménsébéréh ro maro, “Ati ni? Mantu keey kétoro. I ni étéw wén i kuwagibén sémugu bé de saitan, brab odoro roy késugu ne!” ");
INSERT INTO tiy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mélaw i kéurete fantag bé Jesuse magad ménlégéb dob kéluhanay de gonon dob dakéle ingéd Galilea. ");
INSERT INTO tiy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tidéw béno, ténagak roy lawie ni féngadafan, brab ménagéw ro mangéy dob lawi Simone brab Andrese. Atin ménodor soy Santiagowe brab Juane. ");
INSERT INTO tiy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Atin diyo gara-gara i térima Simone libun non déméruun toow fo méduf. Amun énggumah i Jesuse dob ni lawi, bénréh ro dey fantage bé ni déméruun. ");
INSERT INTO tiy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Atin i Jesuse ménangéy dob tébing ne atin génamakén i kémér ne brab fénétekén. Sonom béno, ménkédan i kééduf ne brab ménadi-adiy libune ni. Tidéw béno, dénuwoto no bero. ");
INSERT INTO tiy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bé no kélungonon, amun ménléd i térésange, i de étéw nuwit ro mangéy dob Jesusey kéluhanay de déméruun brab de étéw rénahukoy de saitan. ");
INSERT INTO tiy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Atin médooy de étéw dob no ingéd ménlimud ro dob fésayaway lawie ni. ");
INSERT INTO tiy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Atin i Jesuse énggéféadi-adino noy médoowe déruunan bé médoowe gékélasi déruun, brab fénféraréyén i médoowe saitan. Atin i de ni saitan, énda fénbéréhén bero non gétiga roy ati Beene. ");
INSERT INTO tiy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Amun lingkuwog mangéy fuweh bé sébaane de géfuwén, méntek i Jesuse brab ménsut dob lawie ménangéy dob géfélébue gonon dob liyuy ingéde. Atin diyo déménasal. ");
INSERT INTO tiy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mélaw i Simone brab de dumo no, nangéy ro sénléd i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Amun énggito ro, ménbéréh ro maro, “Sélédéy kéluhanay de étéw Beem.” ");
INSERT INTO tiy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Endob séménumbul i Jesuse mano, “Fatut taus tom magéw mangéy dob de dumo ingéd gédét dini inok géuretu so diyo, non been i niy funa kuwe ménangéy dini.” ");
INSERT INTO tiy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mélaw lénégébén sénugudon i séngae gonon dob Galilea. Atin ménuret dob de lawi féngadafay de Judio, brab fénféraréyén i de saitan. ");
INSERT INTO tiy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wén i no sébaan fuweh, i ségétéwe fémuteén ménangéy dob Jesuse, brab léméningkuwéd dob adafa nuwe mongot tabang. Ménbéréh mano, “Amuk kétaya mo, géféadi-adino mo begén.” ");
INSERT INTO tiy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Atin toow fo ménuray i na Jesuse de. Mélaw béntér Jesusey kémér ne brab kénuwahén. Atin ménbéréh mano, “Kétaya ku. Adi-adi go.” ");
INSERT INTO tiy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sonom béno, ménkédan i fémute ne, brab ménfiyoy lowoh ne. ");
INSERT INTO tiy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tidéw béno, i Jesuse fénagéwén brab ménbagér i kébéréh ne de mano, ");
INSERT INTO tiy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Fégélingoém, kago béréhén i fantage bé ni rénigo gu dob fiyon udenén étéw. Endob taus go agéw mangéy dob fadie brab féténgténgém i lowoh me inok gétiga no adi-adi gon. Tidéw béno, irayém i tulake loo bé sénugu i kitabe tidéw dob Moisese inok fégito moy kéadi-adi muwe dob kéluhanay de étéw.” ");
INSERT INTO tiy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ménagéw bangnoor i ni étéw, éndob nuretén dob séngae étéw énggébalaka no, tidéw béno ménséfélalag foy ni uret. Mélaw éndaén géréngkay-réngkay i Jesuse rémahur dob kéluhanay de ingéd. Yamula ménbati saén dob de liyu. Atin i de étéw tidéw dob de kéluhanay de gonon ménangéy ro dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Amun ménifus i firoye gétérésangan tidéw béno, ménséfule i Jesuse mangéy Kafernaum. Atin ménlégéb i urete bé ménule mangéy diyo. ");
INSERT INTO tiy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mélaw toow fo médooy de étéw ménangéy sélimud dob lawie batio Jesuse. Atin non toow ro fo médoo, éndaén i gonon de fiyon fo dob fésayawane. Atin nuret Jesuse beroy kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bé lala ne témoro, énggumah i fote gétéw lagéy ténanggung roy ségétéwe kimoyén, uwité ro damén mangéy dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Endob énda i fiyo kélawang ro dob Jesuse, non bé médoowe do étéw. Mélaw ménénik ro dob atéf i lawie. Tidéw béno, ténosong roy atéfe dob gataga Jesuse. Amun méntosongén, ténuntu roy ténanggunge ni kimoyén. ");
INSERT INTO tiy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Amun énggito Jesusey kéféngintoow ruwe, ménbéréh dob ni étéw kimoyén mano, “Adih, i de salaém ménfésagadén.” ");
INSERT INTO tiy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tidéw béno, i de témoro bé kitab i de Judio ménsar diyo, séfénginsa-nginsa i de fédéw ro maro, ");
INSERT INTO tiy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sedek émbéréh mékémurka i ni étéw? Enda i géfésagad bé de sala ké békén i Tuluse saén!” ");
INSERT INTO tiy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Endob bé béno so, énggétiga Jesusey de itunga ro. Mélaw ménbéréh dob berowe mano, “Sedek sébéréh gom loo bé nan dob de fédéw gom? ");
INSERT INTO tiy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Toow na fo mélému béréhén, ‘I de salaém ménfésagadén.’ Non énda gito no ké wén i barakat gu de rémigo. Endob toow fo mérégén béréhén, ‘Tindég go, furutém i iroo muwa nan, brab agéw go.’ Non giton ké wén i barakat gu de rémigo. ");
INSERT INTO tiy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Endob féfégétiga ku begom i fantage bé Nga i Kéilawane, sani Begéne. Wén i barakat gu brab kuwagib gu dob duniyae ni émfésagad bé de sala.” Tidéw béno, bénréhén dob kimoyéne ni mano, ");
INSERT INTO tiy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Béréhé ku beem, tindég go, furutém i iroo muwa nan, brab ule go.” ");
INSERT INTO tiy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sonom béno, téménindég i kimoyéne ni dob téngaanga ruwe, brab fénurutén i iroo nuwe, brab ménagéw. Atin i kéluhanay de étéw diyo, toow ro fo ménggaif brab dénayéw roy Tuluse maro, “Enda nay énggito tom tidéw féganay loo bé ni.” ");
INSERT INTO tiy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tidéw béno, i Jesuse ménangéy man dob fédoror i dogote Galilea. Atin énggumah i de médoo do étéw brab ménlimud ro dob Beene. Atin féngganaya noy témoroe bero. ");
INSERT INTO tiy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tidéw béno, méntaus i Jesuse magéw. Atin énggito noy ségétéwe étéw kémubra buwis féndawét Lebi, nga Alfeo ménsar dob de kubranan buwis. Brab ménbéréh i Jesuse dob beene mano, “Odor go Begén.” Tidéw béno, téménindég brab ménodor bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Enda mérugayén tidéw béno, diyo i Jesuse mama dob lawi Lebiwe. Atin diyo soy médoowe do étéw kémubra buwis brab médoo do ménsala étéw ménsar mama séréngan bé Jesuse brab de kuyugén, non médoo ro ménfuray bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Atin i de témoro bé kitab i de Judio do Fariseo, amun énggito roy Jesuse mama séréngan bé de ménsala étéw brab de kémubra buwis, ménénginsa ro dob de kuyug Jesus maro, “Sedek ménsélawék i Jesuse mama bé de kémubra buwis brab de ségiyo tete étéw?” ");
INSERT INTO tiy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Endob i Jesuse énggélingoo noy ni brab séménumbul mano, “I de fiyo kégélowoho no, énda kailanga roy muwae, éndob kailangay de wén déruu no. Enda ménangéyu dini inok tabaré kuy de métintu étéw, éndob ménangéyu dini inok tabaré kuy de wén salaén inok gésénule ro.” ");
INSERT INTO tiy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wén i no sébaan fuweh, ménfuwasay de kuyug Juan Bautista brab de Fariseo. Atin wén i de étéw ménangéy dob Jesuse brab ménénginsa ro maro, “I de kuyug Juan brab de kuyug i de Fariseo, fuwasa ro. Sedek i de kaam do kuyug énda fuwasa ro?” ");
INSERT INTO tiy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Séménumbul i Jesuse mano, “Ufama, i de kana dob uyote, énda fuwasa ro ké diyo soy témérimawe lagéy. Taman diyo sénay témérimawe lagéy, énda fuwasa ro. ");
INSERT INTO tiy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Endob gégumah i gaiwe, ké méédot dob berowey témérimawe lagéy. Atin been nay noy gaiwe fuwasa ro. Ségiléw so bé de kagén kuyug, non amuk diniwu séna, énda fuwasa ro.” ");
INSERT INTO tiy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tidéw béno, nuret Jesusey sébaane binuwaya fantag bé sébidanay mantuwe kétoroén brab tafaye kétoro i de Judio. Ménbéréh mano, “Enda i ségétéw étéw fégétabungén i mantuwe safut dob tafaye kégal. Non amuk rigoné no, kéménkén i mantuwe safut, atin méfendet i tafaye kégal, atin minut gétimal i rédet ne. ");
INSERT INTO tiy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Brab énda i étéw mérowo bé mantuwe arak dob tafaye ahuron arak rénigo bé kulit i ayame. Non amuk rigoné no, bétus i mantuwe arak i tafaye ahuron brab mébinasa méitis i mantuwe arak. Endob fatut i mantuwe arak ahurén dob mantuwe kulit ayam fédéngon de.” ");
INSERT INTO tiy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wén i no sébaan fuweh gai kétérén, i Jesuse brab de kuyugén téménara ro dob de médoo do faréy. Atin amun ménagéw ro, i de kuyugén méndot ro bé de onok faréy. ");
INSERT INTO tiy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tidéw béno, i de Fariseo ménbéréh ro dob Jesuse maro, “Sedek rigoné roy ni, non dob kitab tome énda fatut i gémalbéke ké gai kétérén?” ");
INSERT INTO tiy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Séménumbul i Jesuse mano, “Aw énda ba énggébasana kom i rénigo Datu Dabide? Wén i no gai toow fo mélayaf beroy de sundalo no. ");
INSERT INTO tiy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mélaw ménahur ro dob lawi i Tuluse brab méndot bé ténulake fan brab namaén, atin niraya no soy de dumo no de. Rénigo noy ni fiyon fo ké dob kitabe fadi saén i fakaye mama bé ni fan. Rénigo noy ni dob gaiwe Abitar sénay gérotore fadi.” ");
INSERT INTO tiy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Atin féntaus Jesusey kébéréh ne mano, “Rénigoy gai kétéréne kay de étéw, békén i étéwey rénigowe kay gai kétéréne. ");
INSERT INTO tiy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mélaw i Nga i Kéilawane, sani Begéne, wén i kuwagib gu fantag bé atiy fakaye rigonén bé gaiwe kétérén.” ");
INSERT INTO tiy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tidéw béno, ménangéy i Jesuse man dob lawie féngadafay de Judio. Diyo soy ségétéwe lagéy ménsadil i kémér ne. ");
INSERT INTO tiy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Endob diyo soy de Fariseo méuyot témbo bé Jesuse. Mélaw ténulik ro, inok gito ro ké muwa bé no gai kétérén. ");
INSERT INTO tiy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Atin ménbéréh i Jesuse dob lagéye ni ménsadil i kémér ne mano, “Ay go dini dob téngaangay de étéw ni.” ");
INSERT INTO tiy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tidéw béno, fénénginsaa noy de étéw mano, “Ati karang gome de, ati isuwe fakay dob kitabe bé gaiwe kétérén? Rémigo fiyo, loo ké tete? Témabang bé étéwe inok énda méléhuén, loo ké féléhuén?” Endob ménantés ro. ");
INSERT INTO tiy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Atin ménkérit i Jesuse bé lala ne téméngténg bé de étéw géliwét de. Endob tete soy fédéw ne non bé de kétégas i de atura ro énda fo méuray i na ruwe bé ni lagéy. Tidéw béno, ménbéréh dob lagéye ni mano, “Bétérém i kémér ma nan.” Atin béntérén i kémér ne atin sonom béno, ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tidéw béno, i de Fariseo toow ro fo ménkérit atin ménsut ro tidéw dob lawie féngadafan. Atin ménsélimud ro bé de étéw do modor bé Datu Herode brab ménséfagayun ro bé féléhué roy Jesuse brab rénigo roy bantak fédéw ruwe. ");
INSERT INTO tiy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Atin i Jesuse brab de kuyugén ménagéw ro man mangéy dob dogote Galilea, brab médooy de étéw ménfuray de. Tidéw ro Galilea brab Judea, ");
INSERT INTO tiy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","brab tidéw Jerusalem, brab Idumea, brab tidéw fingé sébangay wayége Jordan, brab tidéw dob géliwéte bé Tirowe brab Sidone. I de ni do médoo étéw ménangéy ro dob Jesuse non énggélingoo roy kéluhanay de rénigo no do mékégaif. ");
INSERT INTO tiy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Atin non toow fo dakél i de ménlimud do étéw, i Jesuse bénréhén bé de kuyugén bé témafay ro sébaan awang édaa no inok énda mérasékén. ");
INSERT INTO tiy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Non énggéféadi-adino noy de médoo do étéw. Mélaw i kéluhanay de wén do déruuno sédéri ro fégédét dob Jesuse inok gékuwaha ro. ");
INSERT INTO tiy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Atin i kéluhanay de étéw rénahukoy de saitan, amun énggito roy Jesuse, méntéléngkéb ro dob adafa nuwe brab mékes ro maro, “Beemey Nga i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Endob i Jesuse génléén bero bé énda fégétiga ro de dob de ségiyo. ");
INSERT INTO tiy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tidéw béno, i Jesuse ménénagé mangéy dob burure brab ténawagén mangéy dob Beeney de fénémilién do waléy do sarigo no. Atin ménangéy ro dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Atin fénémilién i de folo bra ruwo gétéw, atin féndawétén bero do apostol (i atag ne “do sénugu”). Non fénodorén bero dob Beene, brab sugué no bero muret. ");
INSERT INTO tiy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Atin niraya no bero barakat inok gédédél ro do saitan rémahuk dob de étéw. ");
INSERT INTO tiy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ay niy de dawét i de apostol do fénémilién: Simon (féndawét Jesuse Pedro so), ");
INSERT INTO tiy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago brab Juan, sani de nga Sebedeo. I Jesuse féndawétén so bero Boanerges (i atag ne “do nga dégu”), ");
INSERT INTO tiy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","brab Andres, Filipi, Bartolome, Mateo, Tomas, Santiago nga Alfeo, Tadeo, Simon sani ségétéwe toow fo gulaané noy ingéd ne, ");
INSERT INTO tiy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","brab Judas Iskariot, sani ménfékéfoe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tidéw béno, i Jesuse ménule. Atin ménlimud man i médoowe étéw dob Beene. Mélaw i Jesuse brab de kuyugén, énda i uras ro mama. ");
INSERT INTO tiy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Atin i de samungén, amun énggélingoo roy ni, nangéy ro kénéfo, non bénréh i de étéw bunég kun. ");
INSERT INTO tiy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Atin wén i de témoro bé kitab i de Judio énggumah ro tidéw Jerusalem. Ménbéréh ro maro, “I Jesuse ni rénahuko Beelsebule, sani Satanase, i odoroy de saitan. Been i funa nuwe wén i barakatén démédél bé de saitan.” ");
INSERT INTO tiy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mélaw i Jesuse ténawagén i de ni étéw mangéy dob Beene, brab nuretén beroy de binuwaya mano, “Enda fakayén ké féféraréyé Satanasey de dumo no saitan. ");
INSERT INTO tiy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ufama, amuk wén i ingéd énda géséfagayun ro brab sétiboh ro, mébinasa. ");
INSERT INTO tiy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Taloo no i ségékurénge étéw dob sébaane lawi amuk énda so géséfagayun ro brab sékérit ro, waléy mébinasa. ");
INSERT INTO tiy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ségiléw so bé Satanase. Buluk i de sugu-sugué no mésébaad énda géséfagayun ro, énda so gétindég i fangangatura nuwe, brab mébinasa. ");
INSERT INTO tiy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“I Begéne, ténabana kun i Satanase. Been i niy funa kuwe géféféraréyo kuy de kuyugén sani de saitan. Ufama, énda i ségétéw étéw géahur dob lawi i émbagére étéw atin tulisé noy tamuk ne taman énda na géikéto no de métah. ");
INSERT INTO tiy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Béréhé ku begom i toowe, i kéluhanay de sala brab de tete kébéréh i de étéw fakay émfésagad. ");
INSERT INTO tiy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Endob i émbéréhe tete fantag bé Rémogor i Tuluse énggérigo sala énda émfésagada no non énda mékédan i nan sala taman sa taman.” ");
INSERT INTO tiy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bénréh Jesusey ni non wén i de ménbéréh maro, “Rénahuko saitan i Jesuse, funa no géféféraréy bé de saitan.” Endob i toowe, Rémogor i Tulusey manangguwite bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tidéw béno, énggumah i idéng Jesuse brab de tuwaréyén lagéy. Téménindég ro dob liyuy lawie, brab fén-uwito ro kébéréh bé tawagé roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wén i de médoo do étéw ménlimud ménsar géliwét bé Jesuse, atin ménbéréh ro maro, “I idéng me brab de tuwaréyém diyo ro dob liyuwe. Méuyot ro géségito Beem.” ");
INSERT INTO tiy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Atin séménumbul i Jesuse mano, “Wén i ségiyo idéng gu brab do tuwaréy gu.” ");
INSERT INTO tiy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Atin iling-iling dob de étéw ménsar géliwét de brab ménbéréh mano, “Téngténg gom, ay niy de maak idéng gu brab do tuwaréy gu. ");
INSERT INTO tiy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Non i de étéw rémigo bé kétayay Tuluse, beroy do maak idéng gu brab do tuwaréy gu.” ");
INSERT INTO tiy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wén i no sébaan fuweh, téménoro man i Jesuse diyo dob dogote Galilea. Atin toow fo dakél i ménlimude do étéw géliwét de. Mélaw ménda dob awange brab ménsar diyo gédét dob dénsaane, bé lala i de étéw téménindég dob dénsaane. ");
INSERT INTO tiy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Atin médooy de ténoroén bero fénagéwén dob de binuwaya. ");
INSERT INTO tiy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ménbéréh mano, “Fégélingo gom. Wén i ségétéwe étéw ménangéy sémabug bé béne ne. ");
INSERT INTO tiy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Amun sénabugén i béne ne, i de dumo bé béne ne ménbigodoy dob doror i aguwone. Diyo énggumah i de kloh manok, atin nama ro. ");
INSERT INTO tiy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","I de dumoy de béneén ménsawér dob fantade médooy de batéw de, éndob kloh saén i fantade médooy de batéw de, éndob kloh saén i fantade de. Tidéw béno, ménagad téménunoh non énda ménalém i fantade de. ");
INSERT INTO tiy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Endob amun sémbang i térésange, atin démawét foy médufe, ménlaay i nohoke brab ménléhu, non énda toow ménalém i de kédarir ro. ");
INSERT INTO tiy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","I de dumoy de béneén ménsawér dob fantade wén i do suwar de énda séna téménunoh ro. Atin ménséréngan téménunoh i de suwar brab de nohok. Mélaw ménéfuk i de nohok brab énda énggéfogonok ro. ");
INSERT INTO tiy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Endob i de dumo bé de béne ménsawér dob fiyowe fantad, brab témunoh ro brab ménruk ro brab ménggonok ro médoo taman téléw folo takéf, ném folo takéf brab mératu takéf i séngae sébaan béne.” ");
INSERT INTO tiy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Atin féntaus Jesusey kébéréh ne mano, “Fégitung gom i fantage bé ni bénréh gu begom amuk méuyot gom de ké gésobuto kom.” ");
INSERT INTO tiy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tidéw béno, amun sébaa Jesuse séden, i de dumo bé de étéw énggégélingo bé ni binuwaya, beroy de folo bra ruwo gétéw do kuyugén ménangéy fégédét dob Beene. Atin ménénginsa ro fantag bé atag i de ni binuwaya. ");
INSERT INTO tiy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Atin séménumbul i Jesuse mano, “Dob begome do kuyug gu, fégésobutéy Tuluse begom i de ménbunéy fantag bé kéféguléw i Tuluse bé de étéwén. Endob dob de ségiyo étéw, énggélingoo ro saén i de ni fén-agéw dob de binuwaya, ");
INSERT INTO tiy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","inok fiyon fo ké téngténgé ro fo toow, énda gito ro de. Brab fiyon fo ké gélingoo ro fo toow, énda gésobuto ro de. Non amuk gésobuto ro, gésénule ro bé de tete adat ro brab munur ro bé Tuluse, atin fésagada no bero.” ");
INSERT INTO tiy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Atin féntaus Jesusey kébéréh ne mano, “Aw énda gésobuto kom i ni binuwaya? Ati mélaw i kégésobut gome bé de ségiyo kétoro gu fén-agéw dob de binuwaya? ");
INSERT INTO tiy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ay niy atag i ni binuwaya énggélingoo kom. I atag i ni béne, been i kébéréh i Tuluse. Atin i de séségiyo-giyo gékélasi do fantad ségiléw bé de séségiyo-giyo gékélasi do étéw. Atin i sémabuge ureté noy kébéréh i Tuluse dob de séségiyo-giyo do étéw. ");
INSERT INTO tiy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I de dumo bé de béne ménlawu dob doror i aguwone. Diyo nama i de kloh manok. I atag i ni, wén i do étéw énggélingoo roy uret i Tuluse, éndob énggégumah i Satanase, atin kénda noy ni uret énggélingoo ro. ");
INSERT INTO tiy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","I dumoy de béne ménsawér dob fantade médooy de batéw de. I atag i ni, wén i do étéw énggélingoo roy uret i Tuluse brab ténayakuf ro brab ménoror ro de. ");
INSERT INTO tiy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Endob loo bé de nohok énda ménalém i darir ruwe, énda so méégét i kéunur ruwe. Sémarig ro bé Tuluse singkow saén. Endob amuk kérégénan ron taloo no férasayén ro sabaf bé uret i Tuluse, magad mékédan i késarig ruwe. ");
INSERT INTO tiy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","I de dumoy de béne ménsawér ro dob de duwaléy suwar. I atag i ni, wén i do étéw énggélingoo roy uret i Tuluse, ");
INSERT INTO tiy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","éndob non bé de bukué ro fantag bé de kéuyag ro, brab kéuyot ruwe waléy kawasa, brab kéuyot ruwe bé de ségiyo do languntaman, been i niy funa ruwe gélifoto roy uret i Tuluse brab énda gérigono roy fatute kétayay Tuluse rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Atin i de dumoy de béne ménsawér ro dob fiyowe fantad. I atag i ni, wén i de étéw énggélingoo roy uret i Tuluse brab toow fo nunuro ro. Mélaw rigoné roy kétayay Tuluse rigoné ro. I de dumo bero gérigono roy de fiyo, brab i de dumo bero gérigono ro na foy médoowe do fiyo, brab i de dumo bero toow na fo gérigo ro do médoo do fiyo.” ");
INSERT INTO tiy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Atin ménbéréh man i Jesuse mano, “Enda i témumon solo inok bunéyé no dob bukag i kurénge fénléngkéb, taloo no fédiyoé no dob fantad i katriwe. Yamula fédiyoé no dob fégonone de. ");
INSERT INTO tiy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ségiléw so bé ni, i de kétoro gu ménbunéy béleewe, giton moso. Atin i kéluhanay éndae gésobuton béni, gésobuton moso. ");
INSERT INTO tiy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Komon fégitung gom fantag bé ni bénréh gu begom amuk méuyot gom de ké gésobuto kom.” ");
INSERT INTO tiy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Atin ménbéréh man i Jesuse mano, “Fétuntay gom i gélingoo kome. Non i kékukum gome bé de dumo gom do étéw, iringéy Tuluse so ké kukumé no begom, éndob toow na fo gétimal. ");
INSERT INTO tiy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Atin i étéwe mégélingo brab munur, méumanan nay kégésobut ne. Endob i étéwe énda munurén, fiyon foy klohe fégitungé no gésobuto no, dotén dob beene.” ");
INSERT INTO tiy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Atin ménbéréh man i Jesuse mano, “I kédakél i kéféguléw i Tuluse bé de étéwén ségiléw bé kééruk i de béne sénabug i ségétéwe étéw dob fantade. ");
INSERT INTO tiy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tidéw béno, témunoh i de béne fiyon fo ké énda gésobutoy sémabugey funay de nohok témunoh. Méruk i de nohok fiyon fo ké fuweh ké gémalbék taloo no kélungonon ké fidong. ");
INSERT INTO tiy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Non i fantade fétunohé noy de nohok brab féfégonoké no. Dob sunguwe de, démaun. Tidéw béno, musu. Tidéw man béno, kémifénén. ");
INSERT INTO tiy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Atin amuk lagasén, fakayén kétéwé no non énggumahén i gaiy kékétéwe de.” ");
INSERT INTO tiy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Atin ménbéréh man i Jesuse mano, “Ati fégiringo tom bé kéféguléw i Tuluse bé de étéwén? Ati binuwayae ureté tom? ");
INSERT INTO tiy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ségiléw na bé toowe fo kloh béne, éndot i étéwe brab nohokén dob fantade. ");
INSERT INTO tiy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tidéw béno, téménunoh brab ménruk taman ménwaléy toow fo dakél nohok. Atin ménongo dakél fongo, inok i de kloh manok salaga ro.” ");
INSERT INTO tiy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","I uret i Tuluse nuret Jesuse dob de étéw fén-agéw dob de médoo do binuwaya loo bé ni. Nuretén bero taman énggésobuto ro. ");
INSERT INTO tiy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Enda i no kétoroén bero ké békén binuwaya. Endob amuk beroy de kuyugén saén brab énda i do ségiyo étéw diyo, fégétiga no beroy de atag i de binuwaya. ");
INSERT INTO tiy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bé béno gai, amun sémingkufén, bénréh Jesuse dob de kuyugén mano, “Mifar tom mangéy dob difar i dogote ni.” ");
INSERT INTO tiy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mélaw ténagak roy de ménlimud do étéw, brab i de kuyugén ménda ro dob awange énsara Jesuse. Tidéw béno, ménifar ro. Wén soy do ségiyo awang ménodor bero. ");
INSERT INTO tiy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tidéw béno, amun diyo ron dob kérara i dogote, tékow énggumah i émbagére défuk. Atin nahuroy de bagél i awang ruwe taman gédét ménféno bé wayége. ");
INSERT INTO tiy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Endob i Jesuse diyo dob ulinay awange, ménfidong déménanan. Atin téningé i de kuyugén atin nulég ro maro, “Maistéro, aw énda i ula mé de ké mégra tom?” ");
INSERT INTO tiy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tidéw béno, méntek i Jesuse brab génléén i réfuruhe brab de bagél mano, “Fétinanék gom!” Sonom béno, téménrén i réfuruhe, atin ménlingén-ngén i dogote. ");
INSERT INTO tiy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Atin ménbéréh i Jesuse dob de kuyugén mano, “Sedek mégilak gom? Aw énda séna sémarig gom?” ");
INSERT INTO tiy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Endob toow ro fo ménggilak atin ménsébéréh-béréh ro maro, “Ati nén mon i ni étéw? Fiyon i défuke brab de bagél géfétéréno no!” ");
INSERT INTO tiy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Atin méntaus ro taman énggégumah ro dob difar i dogote, dob ingéde Gerasa. ");
INSERT INTO tiy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Amun téménéfad i Jesuse, bénalak i étéwe rénahukoy saitane. Tidéw dob de takub do lébéng, ");
INSERT INTO tiy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","non bati diyo. Brab éndaén fo méikétén, fiyon fo ké sangkali. ");
INSERT INTO tiy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Non médoonén gule nikét bé sangkaliey de sékéyén brab de kémérén. Endob i de sangkali sékétusé no, brab de futow fénggéfatung bé de sékéyén séfindasé no. Atin énda nay ségétéw étéw émbagér ménggéfifit de. ");
INSERT INTO tiy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Fuweh na kélungonon i kéagéw ne dob de duwaléy lébéng brab dob de tuduk. Diyo mékes brab falié noy lowoh ne bé de batéw. ");
INSERT INTO tiy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Atin amun énggito noy Jesuse dob mérayue, léménéntu mangéy fégédét brab ménlingkuwéd dob adafa nuwe. ");
INSERT INTO tiy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Atin i Jesuse sénuguén i saitane mano, “Saitan, sut go tidéw dob beena nan!” Tidéw béno, ménkes métanug i étéwe rénahukoy saitane ni. Ménbéréh i saitane mano, “Jesus, Nga i toowe fo gérotor Tulus, ati kérigo muwe begén? Ongoté ku Beem, fasad go dob Tuluse bé kago fédawéton begén.” ");
INSERT INTO tiy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Atin fénénginsaa Jesuse mano, “Ati dawét me?” Atin séménumbul mano, “Laksaén i dawét guwe non bé médoo gey do saitan dob ni étéw.” ");
INSERT INTO tiy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Atin féntausén i kéfégédaw-gédaw ne dob Jesuse bé békén damén dédélé Jesuse bero mangéy dob mérayue. ");
INSERT INTO tiy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Enda mérayuén dob no gonon, diyo i médoowe do babuy témabtab dob méngulandige. ");
INSERT INTO tiy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Atin nongot i de saitan dob Jesuse maro, “féangéyén gey dob do babuy diyo, brab fédayaém begey mahur dob berowe.” ");
INSERT INTO tiy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Atin ténungkas Jesuse bero. Mélaw i de saitan ménsut ro dob étéwe ni brab ménahur ro dob de babuy ni. Wén i ruwo ngibu kédooy de ni babuy, brab kéluhana ro ménraréy ro ménangéy dob fingase brab ménantéfor ro mangéy dob dogote, atin ménléné ro. ");
INSERT INTO tiy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","I de étéw témalima bé de babuy ni, amun énggito roy ni ménrigo, ménségéta ro brab nuret roy ni dob ingéde brab dob de ségiyo gonon géliwét. Atin ménangéy diyo i de étéw inok susiné roy ni ménrigo. ");
INSERT INTO tiy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ménfégédét ro dob Jesuse brab énggito roy étéwe ni bé gétaho rénahukoy de médoo do saitan. Ménsar diyo, kéménégal brab métintunén i kéfégitung ne. Atin kéluhana ro mégilak ro de. ");
INSERT INTO tiy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nuret i kéluhanay de énggégito de ké ati ménrigowe dob étéwe ni bé gétaho sénaitanan brab ati ménrigowe dob de babuy. ");
INSERT INTO tiy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mélaw i de étéw nongot roy Jesuse tékédan dob ingéd ruwe ni. ");
INSERT INTO tiy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","I lala Jesuse ménda dob awange, i lagéyo no ténkédanay de saitan nongotén dob Jesuse mano, “Modoru Beem.” ");
INSERT INTO tiy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Endob énda ténungkas Jesuse de. Yamula ménbéréh mano, “Ule go brab uretém dob de samungém i kéluhanay fiyowe rénigoy Kadnane Tulus dob beeme brab kégédaw ne beem.” ");
INSERT INTO tiy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mélaw ménagéw brab ménsugud-sugud dob gonone diyo féndawét “Do Folo Ingéd”, brab nuretén i kéluhanay rénigo Jesuse dob beene. Atin i kéluhanay de étéw énggégélingo de, ménggaif ro de. ");
INSERT INTO tiy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tidéw béno, ménséfule i Jesuse mifar dob dogote. Amun énggumah dob difare, diyo dob fédoror i dogote ménlimud i médoowe étéw géliwét de. ");
INSERT INTO tiy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Atin énggumah i ségétéwe étéw féndawét Jairo, ségétéw odoron dob lawie féngadafan kay de Judio. Amun énggito noy Jesuse, ménfégédét dob Beene brab méntéléngkéb dob adafa nuwe. ");
INSERT INTO tiy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Atin toow fo nongotén dob Jesuse mano, “I klohe kénogo ku toow fo kétimalan déméruun. Enggonén angéyém gamak inok adi-adi brab inok énda méléhuén.” ");
INSERT INTO tiy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mélaw ménodor i Jesuse de. Atin ménodor i médoowe étéw brab mésérasék ro lémiwét bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Diyo soy ségétéwe libun kéfasangan non foloén bra ruwo gébélintuwa i kéranas i adat ne. ");
INSERT INTO tiy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Brab ménétéyén i kurta ne fénggébayadén bé de doktor, éndob énda foy ségétéw géuwa de. Yamula minut gétimal i déruu nuwe. ");
INSERT INTO tiy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Enggélingoo noy de uret fantag bé Jesuse, mélaw ménfuray so bé de médoo ni do étéw ménlimud inok gékuwaha noy kégal Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Non fénggitungén mano, “Amuk gékuwaha ku saén i kégal ne, adi-adiwu.” ");
INSERT INTO tiy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mélaw kénuwahén i kégal Jesuse. Sonom béno, téménrén i kéranas i adat ne, atin énggétérédama no ménadi-adi bé déruu nuwe. ");
INSERT INTO tiy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Endob bé béno so, énggétiga Jesuse bé ménsut i barakat ne tidéw dob Beene. Mélaw méntékélid brab ménénginsa dob de ménlimud do étéw mano, “Ati kéménuwahe bé kégal guwe?” ");
INSERT INTO tiy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Atin séménumbul i de kuyugén maro, “Gito moy médoowe ni étéw géliwét Beem brab séndantélo ro Beem. Sedek fénginsaé moy ati kéménuwahe Beem?” ");
INSERT INTO tiy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Endob i Jesuse féntausén i kéiling-iling ne téméngténg ké atiy kéménuwahe de. ");
INSERT INTO tiy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tidéw béno, i libune ni énggétiga no atiy ménrigowe dob beene. Mélaw ménfégédét lémukub bé kégilak ne, atin méntéléngkéb dob adafa Jesuse. Brab bénréhén i kéluhanay toowe. ");
INSERT INTO tiy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tidéw béno, bénréh Jesuse de mano, “Di, i kéféngintoow mey funa muwe ménadi-adi. Taus go ule brab kagonén émbuku. Endaén déméruun go bé ni déruun.” ");
INSERT INTO tiy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Amun béréhé Jesusey ni, énggumah i de étéw tidéw dob lawi Jairowe. Ménbéréh ro dob Jairowe maro, “Déménigurén i nga me. Endaén kailanga mo féangéyé mo diyo i Maistérowa nan.” ");
INSERT INTO tiy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Endob i Jesuse, énda ténula noy kébéréh ruwe ni, yamula bénréhén dob Jairowe mano, “Kago mégilak. Féginugut go saén.” ");
INSERT INTO tiy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Atin i Jesuse, énda i ségétéw fénodorén saliyu bé ro Pedrowe, Santiagowe, brab Juane dumo Santiagowe sétiman idéng. ");
INSERT INTO tiy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Amun énggumah ro dob lawi i odorono no, énggito Jesusey ménribuke, atin énggélingoo noy de ni médoo étéw toow fo selekén non kémérew ro brab rémuung ro. ");
INSERT INTO tiy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tidéw béno, ménahur i Jesuse brab bénréhén mano, “Sedek ménribuk gom brab selekén gom kémérew? Non i ngae ni énda ménléhuén, éndob ménfidong saén.” ");
INSERT INTO tiy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mélaw sénbayat roy Jesuse. Tidéw béno fénsutén bero kéluhanan, atin nuwitén i abay i ngae ni brab idéng ne brab de téléw gétéw kuyugén ménodor de, atin ménahur ro mangéy dob sibéye gonoy ngae ni méniro. ");
INSERT INTO tiy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tidéw béno, génamak Jesusey kémér ne brab ménbéréh mano, “Talita kumi.” (I atag ne “Di, tek go!”) ");
INSERT INTO tiy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sonom béno, méntek i ngae ni atin ménagéw. Folo bra ruwo gébélintuwa i idad ne. Toow ro fo ménggaif bé ni rénigo Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Endob i Jesuse fénégétén i kébérého nuwe bero bé békén ureté ro dob ségiyowey ni ménrigo. Atin sénuguén bero émféama bé ni nga. ");
INSERT INTO tiy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tidéw béno, ménagéw man i Jesuse tidéw diyo atin ménule mangéy dob kaane ingéd. Atin ménodor i de kuyugén so. ");
INSERT INTO tiy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Atin bé gaiy kétéréne, ménangéy témoro dob lawie féngadafan kay de Judio. Médooy de étéw diyo, atin amun énggélingoo roy kétoro Jesuse, ménggaif ro. Mélaw ménséfénginsa ro maro, “Ati ni dakél kégétuwan, brab tidéwo nuwe de? Sedek gérigono noy mékégaife galbék? ");
INSERT INTO tiy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aw békén ba Beeney fandaye rémigo lawi nga Maria brab ofo Santiago, Jose, Judas brab Simon? Brab aw békén ba dini dob betomey de libu no?” Mélaw ménika ro de. ");
INSERT INTO tiy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Atin ménbéréh i Jesuse dob berowe mano, “I ségétéwe sarigoy Tuluse muret bé kébéréh ne, basanan dob kéluhanay de gonon saliyu saén dob kaane ingéd brab dob de kaan do samung brab dob de kaan do étéw sétifon lawi.” ");
INSERT INTO tiy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Atin énda i gérigono no mékégaif galbék saliyu saén bé gémamake bé firoye déméruun atin géféadi-adino no bero. ");
INSERT INTO tiy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Atin ménggaif i Jesuse non énda ménunur ro dob Beene. Tidéw béno, ménagéw i Jesuse sémugud témoro dob de ingéd gédét diyo. ");
INSERT INTO tiy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Atin ténawag Jesuse mangéy sélimud dob Beeney de folo bra ruwo gétéw do kuyugén. Tidéw béno, sénuguén bero sémugud séruwo-ruwo gétéw. Atin niraya no bero barakat inok géféféraréyo roy de saitan. ");
INSERT INTO tiy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Atin bénréhén bero mano, “Kagom muwit éntingayén saliyu saén bé tugée. Kagom muwit amaén, taloo no réban, taloo no kurta. ");
INSERT INTO tiy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Fatut séminilas gom, éndob kagom muwit lékasa kom kégal.” ");
INSERT INTO tiy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Atin bénréhén so bero mano, “Fiyon atiy lawie témayakuf begom, bati gom diyo taman tagaké kom i nan ingéd. ");
INSERT INTO tiy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Buluk wén i no ingéd énda tayakuféy de étéw begom, tékédan gom diyo, brab tag-tag gom i de bubuk sébuwan dob de sékéy gom émfégétigan bé kukuméy Tuluse bero.” ");
INSERT INTO tiy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tidéw béno, ménagéw i de kuyugén ni brab nuret roy fatut gésénule i de étéw bé de sala ro brab tagaké roy de tete adat ro. ");
INSERT INTO tiy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Atin énggéféféraréy ro do médoo saitan, brab lénulawa ro nor i de médoo do déruunan atin ménadi-adi ro. ");
INSERT INTO tiy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bé béno, i Herode, sani méguléwe dob Galilea, énggélingoo noy de rénigo Jesus non ménbantug dob kéluhanay de gonon. Wén i do étéw ménbéréh ro bé i Juan Bautistawe méntébule non maro ké Juan i Jesuse. Been kun i niy funa nuwe wén i barakatén gérigo do mékégaif. ");
INSERT INTO tiy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Brab i de dumo de béréhé roy Elias kun i Jesuse, sani méntélatae sarigoy Tuluse bé do gétah. Brab i de dumo de béréhé roy Jesus kun i toowe fo énggétah sénarigoy Tuluse muret. ");
INSERT INTO tiy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","I Herode, amun énggélingoo noy de ni, ménbéréh mano, “Beeney Juan Bautistawe fénkéléng guy uléw ne, éndob méntébule.” ");
INSERT INTO tiy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ay niy funa Herode ménfékéléng bé uléw Juane. I Herode lénamfaén i bawag i tuwaréy ne Filipi. I dawét i ni libun Herodiyas. Tidéw béno, bénréh Juane dob Herodey ménsala non énda fakayén dob kitab i de Judio ké bawagén i iboe. Tidéw béno, i Herode fénkéfoén i Juane brab fénférisu no. ");
INSERT INTO tiy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mélaw i Herodiyase ménkérit bé Juane brab ménuyot de méméléhu, éndob énda féndaya Herode de. ");
INSERT INTO tiy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Non i Herode ménggilak bé Juane non gétiga noy métintu étéw i Juane brab fiyoy adat ne. Mélaw déniyaga no. Atin méuyot de mégélingo, fiyon fo ké ménriyarah de ké fégélingoé noy Juane. ");
INSERT INTO tiy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Endob énggumah i gaiwe rigoné Herodiyasey tetee dob Juane. Non réménigo karagiya i Herode fégétédémo no bé kéumah ne. Atin sénéngkatén i médoowe do odoron brab de sarigo datu Herode brab de odoroy de sundalo, brab de gérotor do étéw dob ingéde Galilea. ");
INSERT INTO tiy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Atin i kénogo Herodiyase ménahur dob karagiyae ni, atin ménsayaw. Mélaw ménfiyoy fédéw Herode beroy de kana no. Atin bénréh Herode dob kénogone ni mano, “Ongotém dob begéney atiy kétaya muwe, brab iray gu.” ");
INSERT INTO tiy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Atin séménafa mano, “Fasada ku beem, iray gu dob beemey atiy ongoté muwe dob begéne, fiyon fo ké ségébala bé ni ingéd féguléwo ku.” ");
INSERT INTO tiy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mélaw ménsut brab ménénginsa dob idéng ne mano, “Ati ongoté kuwe?” Atin séménumbul i Herodiyase mano, “Ongotém i uléw Juan Bautistawe.” ");
INSERT INTO tiy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tidéw béno, ménagayas séfule mangéy dob datu Herode brab ménongot mano, “Kétaya ku ké béleewe ni irayém begén i uléw Juan Bautistawe dob biléwe.” ");
INSERT INTO tiy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Atin toow fo méntete i fédéw datu Herode, non mika rémigo bé ni. Endob sabaf bé méégéte fasadén rénigo no dob téngaangay de kana no, ménika ké énda magayun no bé ni ongotén. ");
INSERT INTO tiy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mélaw fénagayasén sénugu i ségétéwe guwardiya mangéy dob férisunone inok kéléngé noy uléw Juane brab uwité no séfule. Tidéw béno, i guwardiyawe ni, ménagéw dob férisunone brab kénléngén i uléw Juane. ");
INSERT INTO tiy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Atin nuwitén i uléw ne dob biléwe, brab nirayén dob ni kénogon. Atin niray i kénogone ni dob idéng ne. ");
INSERT INTO tiy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","I de kuyug Juan, amun énggélingoo roy ni, nangéy roy bangkay ne, atin lénébéng ro. ");
INSERT INTO tiy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Amun ménséfuleén i de apostol mangéy dob Jesuse, bénréh roy kéluhanay de rénigo ro brab de ténoro ro. ");
INSERT INTO tiy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Atin toow fo médooy de étéw ménangéy ségito bé Jesuse, mélaw énda i uras Jesuse brab de kuyugén mama. Mélaw bénréh Jesuse dob de kuyugén mano, “Enggomén, magéw tom dob géfélébue gonon inok gétérén tom singkow.” ");
INSERT INTO tiy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mélaw ménda ro dob awange inok mangéy ro dob géfélébue gonon. ");
INSERT INTO tiy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Endob médooy de étéw énggégito bero magéw, brab énggétiga ro bero. Mélaw ménagayas i de étéw tidéw dob kéluhanay de ingéd léméntu mangéy dob ayo Jesuse beroy de kuyugén. Atin énggétah ro na énggégumah bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Amun déménunggu i awange ni brab ménlus i Jesuse dob dénsaane, énggito noy de médoo do étéw ménlimud. Atin ménuray i na nuwe bero, non géségiléw ro bé de bili-bili énda i témalima bero. Mélaw féngganayén i kétoro ne bero bé médoowe kétoroén. ");
INSERT INTO tiy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Amun témégénén, i de kuyug Jesus ménangéy ro dob Beene brab ménbéréh ro maro, “Témégénén, atin i ni gonon mérayu dob dakéle ingéd. ");
INSERT INTO tiy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mélaw féagéwém i de étéw ni inok mangéy ro dob de ingéd gédét dini. Diyo gébéléy ro amaé ro.” ");
INSERT INTO tiy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Endob i Jesuse ménbéréh dob de kuyugén mano, “Iraya kom bero amaé ro.” Atin ménbéréh ro maro, “Ay aba-aba, aw méuyot go de ké méléy gey amaén kay de médoowe ni étéw? Labi ruwo ngibu filak i nan!” ");
INSERT INTO tiy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Atin fénénginsaa Jesuse bero mano, “Firoy timan i fa tome? Ay gom ta langu.” Amun gétiga ro, séménumbul ro maro, “Limo timan fan brab ruwo timan sédo.” ");
INSERT INTO tiy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tidéw béno, ménbéréh i Jesuse dob de kuyugén mano, “Féésar gom i de étéw sésélumfuk-lumfuk dob de mélunéw kéroon.” ");
INSERT INTO tiy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mélaw i de étéw, ménsar ro ménsélumfuk-lumfuk, sémératuh-ratuh brab sélimo-limo folo. ");
INSERT INTO tiy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tidéw béno, éndot Jesusey limowe timan fan brab ruwowe timan sédo, atin léménéngag saréw dob lawayo brab ménfésalamat dob Tuluse. Tidéw béno, sénbaad-baadén i de fan, brab nirayén dob de kuyugén inok saaré ro dob de étéw. Atin loo so bé niy rénigo nuwe bé ruwowe timan sédo. ");
INSERT INTO tiy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Atin i kéluhanay de étéw, téménantu ro mama taman ménbésor ro. ");
INSERT INTO tiy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tidéw béno, ténimu i de kuyug Jesus i de sama i de fan brab sédo brab ménféno i foloe bra ruwo timan biton. ");
INSERT INTO tiy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","I kédooy de ménama, limo ro ngibu do lagéy saliyu na bé de libun brab de nga. ");
INSERT INTO tiy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tidéw béno, fénda Jesusey de kuyugén dob awange atin fénétahén bero mangéy fingé difar bé dogote dob ingéde Betsaida, bé lala ne émféule bé de étéw ménlimud. ");
INSERT INTO tiy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Atin amun ménggétawén dob berowe, ménangéy i Jesuse dob sébaane burur inok démasal. ");
INSERT INTO tiy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Atin amun sémingkufén, i awange diyoén dob kérara i dogote. Atin i Jesuse ségétéwén saén dob fantade. ");
INSERT INTO tiy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Atin énggito no kérégénan i de kuyugén mémurah bé awang ruwe, non gérumfaka roy réfuruhe. Mélaw amun lingkuwogén mangéy fuweh, ménangéy i Jesuse dob berowe magéw dob rotor i dogote. Géfédéw damén gélamfasa no bero, ");
INSERT INTO tiy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","éndob énggito ro magéw dob rotor i wayége. Atin maro ké ménayam. Mélaw ménkes ro. ");
INSERT INTO tiy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Non kéluhana ro ménggilak amun énggito ro. Endob sonom béno, i Jesuse ménbéréh dob berowe mano, “Kagom mégilak! Begén. Fétana gom i de fédéw gom.” ");
INSERT INTO tiy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tidéw béno, ménda dob awang ruwe. Atin téménrén i réfuruhe. Atin toow fo ménggaif i de kuyugén, ");
INSERT INTO tiy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","non fiyon fo ké énggito roy mékégaife rénigo Jesuse dob de amaén, énda gésobuto ro de non métégas i de atur ro. ");
INSERT INTO tiy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Atin amun énggéifar ro, déménunggu ro dob ingéde Genesaret, atin ménamfil ro fédoror. ");
INSERT INTO tiy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Atin amun téménéfad ron dob awange, sonom béno énggiloloy de étéw bati diyo i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mélaw ménagayas ro léméntu dob séngae ingéd diyo inok fégétiga ro dob de étéw. Tidéw béno, nuwit roy de déméruun ténanggung ro mangéy dob énggélingoo ruwe gono Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Atin dob séngae nayo no, fiyon fo ké kloh ingéd taloo no dakél, nuwit roy de déméruun dob de fadiyan, atin nongot ro dob Beeney kuwahé ro saén i férung-fung i kégal ne. Atin i séngae gékuwah de adi-adi. ");
INSERT INTO tiy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wén i no sébaan fuweh, i de Fariseo brab de témoro bé kitab i de Judio, do tidéw Jerusalem, téningé roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Atin énggito roy dumoy de kuyugén mama énda méngguse ro loo bé adat i de Judio. ");
INSERT INTO tiy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Non i de Fariseo, brab kéluhanay de Judio, énda mama ro taman énda géféguse ro non odoro roy adate tidéw dob de katufua ro bé do gétah. ");
INSERT INTO tiy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Brab buluk méléy ro amaén dob fadiyane, énda amaé ro de taman énda méurahén. Atin médoo nay de dumo adat ro loo bé kéurahe bé de tabu brab de kuréng brab de galang ahur-ahuron brab de katri. ");
INSERT INTO tiy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mélaw i de Fariseo brab de témoro bé kitabe, ménénginsa ro dob Jesuse maro, “Sedek i de kuyugém énda odoro roy adat tome tidéw dob de katufua tom, non énda méguse ro ké mama ro?” ");
INSERT INTO tiy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Atin séménumbul i Jesuse mano, “Enda toow i kéunur gome bé Tuluse, ubo-ubo saén. Toow i kébéréh Isaiase, sani ségétéwe méntélata sénarigoy Tuluse muret bé kébéréh ne, amun sénulatén i fantage bé begome mano, ‘Bang i Tuluse, basanay de ni étéw Begén dob kébéréh ruwe saén. Endob énda munur ro Begén dob de fédéw ro. ");
INSERT INTO tiy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Enda i atag i kéféngadaf ruwe Begén, non toroé roy de sugu rénigoy kéilawane brab béréhé ro tidéw dob Begéne.’ ” ");
INSERT INTO tiy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Atin féntaus Jesusey kébéréh ne mano, “Mélaw ténagak gom i de sugu i Tuluse inok odoro kom i adat i kéilawane saén. ");
INSERT INTO tiy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Furung gom mika bé de sugu i Tuluse inok modor gom bé kagome kétoro. ");
INSERT INTO tiy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Non wén i sugu i Tuluse niray Moisese bé do gétah mano, ‘Basana moy abay me brab idéng me.’ Atin bénréhén so mano, ‘Buluk wén i ségétéw émbéréh tete fantag bé abay ne look idéng ne, fatut féléhuén.’ ");
INSERT INTO tiy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Endob i begome, témoro gom bé amuk wén i ségétéw étéw émfasang i abay ne look idéng ne, brab wén i tabang irayén damén, tungkasé kom de émbéréh ‘Korban’. (I atag i Korbane ‘Kay Tuluse’.) ");
INSERT INTO tiy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mélaw éndaén tungkasé kom de témabang bé de lukésén. ");
INSERT INTO tiy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mélaw ténagak gom i kébéréh i Tuluse inok modor gom bé adate toroé kom. Brab do médoo nay de rigoné kom ula-ula loo bé ni.” ");
INSERT INTO tiy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tidéw béno, ténawag Jesuse man i de étéw mangéy dob Beene. Atin ménbéréh dob berowe mano, “Fégélingo gom Begén, kéluhana kom, brab fégésobut gom. ");
INSERT INTO tiy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","I funay de étéw waléy mékérésik dob adafay Tuluse, békén non bé atiy amaé ruwe. Yamula, i de tete kébéréh mésut tidéw dob de ba ro, been i funay de étéw waléy mékérésik dob adafay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Fétuntay gom i ni bénréh gu.” ");
INSERT INTO tiy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tidéw béno, amun ténagak Jesusey de médoo do étéw ménlimud brab énggérahur dob lawie, ménénginsa i de kuyugén dob Beene fantag bé atag i ni kébéréhén. ");
INSERT INTO tiy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Atin sénumbulo Jesuse bero mano, “Ségiléw gom bé kéluhanay de ségiyo étéw, non énda gésobuto kom i ni kétoro gu. I funay Tuluse énda mésuwatén bé de étéw békén sabaf bé de amaé ro. ");
INSERT INTO tiy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Non i amaéy étéwe, mahur dob sur ne brab mésut so dob lowoh ne. Enda mahurén dob fédéw ne.” Bé ni kébéréh Jesuse, ténoroén bé i kéluhanay amaéne fiyo, fakay amaéy de étéw. ");
INSERT INTO tiy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Atin féntaus Jesusey kébéréh ne mano, “I géésute tidéw dob étéwe, been i funa nuwe mékérésik. ");
INSERT INTO tiy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Non tidéw dob fédéwe, gégumah i tetee kéfégitung, brab sébiga, brab ménakaw, brab méméléhu, ");
INSERT INTO tiy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","brab sétayan bé bawag i ségiyowe, brab arumén, brab lémiful, brab tete i rigonéy de lowoh ro, brab mingar, brab témbo bé éndae toow, brab félangka-langka, brab dufang, brab kéluhanay de tete rigonén. ");
INSERT INTO tiy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","I kéluhanay de ni tete tidéw dob fédéw i étéwe brab funa no mékérésik.” ");
INSERT INTO tiy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tidéw béno, ménagéw i Jesuse tidéw diyo mangéy dob de ingéd gédét dob ingéde Tiro. Diyo réménahur dob lawie, atin ménuyot ké énda gétigay de étéw i gono nuwe. Gido loo, ménsélalag i Jesuse diyo bati. ");
INSERT INTO tiy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Atin diyo i libune wén i klohe kénogo no rénahukoy saitane. Atin énggélingoo noy fantage bé Jesuse. Mélaw ménagayas ménangéy dob Beene brab méntéléngkéb dob adafa nuwe. ");
INSERT INTO tiy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Atin nongotén dob Jesuse bé féféraréyé noy saitane tidéw dob kénogo nuwe ni. Endob i ni libun, békén Judio. Yamula, tidéw dob ségiyowe ingéd féndawét Fenisia dob Siro. ");
INSERT INTO tiy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mélaw nuret Jesusey sébaane binuwaya inok fégétiga no de bé tabangé noy de Judio sungu, atin tidéw béno tabangé noy de békén Judio. Ménbéréh mano, “Féamaén na métah i de nga. Non énda fatutén ké dotén i amaéy de nga atin ibérén dob de itu.” ");
INSERT INTO tiy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Endob ménbéréh i libune ni mano, “Toow, Maistéro, éndob fiyon foy de itu géamaa roy de mumu mélawu tidéw dob amaéy de nga.” ");
INSERT INTO tiy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mélaw séménumbul i Jesuse mano, “Fiyoy nan kébéréhém. Mélaw ule go non ménsutén i saitane tidéw dob nga me.” ");
INSERT INTO tiy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tidéw béno, ménule i ni libun, brab énggito noy nga ne méniro, brab i saitane éndaén rénahuko no de. ");
INSERT INTO tiy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tidéw béno, ménagéw i Jesuse tidéw dob de ingéd gédét dob Tiro brab ménémanték mangéy bé ingéde Sidon atin méntaus dob dogote Galilea. Atin téménara dob gonone féndawét “Do Folo Ingéd”. ");
INSERT INTO tiy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Atin wén i de étéw nuwit ro mangéy dob Jesusey lagéye bokongén brab énda toowén gébéréh fiyo. Atin nongot ro dob Beeney gamaké no inok adi-adi. ");
INSERT INTO tiy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mélaw i Jesuse, nuwitén férayu tidéw dob de ménlimud do étéw. Tidéw béno, féndiyoén i de dau kémérén dob de kélingo i bokongéne ni, brab fénreén i dau kémér ne brab kénuwahén i dila ne. ");
INSERT INTO tiy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tidéw béno, léménéngag i Jesuse saréw dob lawayo, brab fénsénarén i kéférénawa nuwe, atin ménbéréh dob beene mano, “Ifata”. (I atag ne “Méungka go.”) ");
INSERT INTO tiy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sonom béno, i de kélingoén ménadi-adi brab énggégélingo, atin i kébéréh ne ménadi-adi so. Mélaw méngganay ménbéréh fiyo. ");
INSERT INTO tiy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tidéw béno, i Jesuse sénuguén i de étéw diyo bé békén béréhé roy ni rénigo no dob de ségiyo. Endob amun sénuguén bero bé békén ureté ro, ménlabi na foy kéuret ruwe de. ");
INSERT INTO tiy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Atin i kéluhanay de énggégélingo de toow ro fo ménggaif. Ménbéréh ro maro, “Fiyo wayoy kéluhanay de rigoné no ula-ula. Géféfégélingoo noy de bokongén brab géfébérého noy de mow.” ");
INSERT INTO tiy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Enda mérugayén tidéw béno, ménlimud man i de médoo étéw. Amun méntéy i de amaé ro, ténawag Jesusey de kuyugén mangéy dob Beene, brab ménbéréh dob berowe mano, ");
INSERT INTO tiy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Méuray i na guwe bé de ménlimud ni do étéw, non méntéléwén gétérésangan i kédini ruwe ni dob Begéne, atin béleewe méntéy i amaé ruwe. ");
INSERT INTO tiy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Atin amuk féuleé ku bero mélayaf ro, mésumba ro dob de lowoh aguwon, non i de dumo bero mérayu i de kétidéw ro.” ");
INSERT INTO tiy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Atin ménbéréh i de kuyugén mano, “Ati kéfingé-fingé i kéféamae bé de médoo ni étéw dob ni gonon mérayu tidéw dob de lawi?” ");
INSERT INTO tiy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Atin i Jesuse fénénginsaa no bero mano, “Firoy timan i fa koman?” Séménumbul ro maro, “Fitéw timan.” ");
INSERT INTO tiy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tidéw béno, sénuguén i de ménlimud ni do étéw bé mésar ro dob fantade. Atin éndotén i fitéwe timan fan brab ménfésalamat dob Tuluse. Tidéw béno, sénbaad-baadén, brab nirayén dob de kuyugén inok saaré ro dob de étéw. Atin rénigo roy ni. ");
INSERT INTO tiy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Brab wén soy do kloh sédo ro, éndob énda médoo no. Atin ménfésalamatén man dob Tuluse brab bénréhén bé de kuyugén bé saaré ro so. ");
INSERT INTO tiy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Atin i kéluhanay de étéw, téménantu ro mama taman ménbésor ro. Fot ngibuy kédoo ruwe. ");
INSERT INTO tiy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tidéw béno, i de kuyugén ténimu roy de sama ro brab ménféno i fitéwe timan biton. Tidéw béno, fénule Jesusey de ménlimud ni do étéw. ");
INSERT INTO tiy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sonom béno, ménda dob awange beroy de kuyugén, atin ménangéy ro dob ingéde Dalmanuta. ");
INSERT INTO tiy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wén i no sébaan fuweh, i de Fariseo ménangéy ro dob Jesuse brab ménséédél ro de. Ménuyot ro téméngkad bé Jesuse, mélaw nongot ro bé rigono no bero sébaan mékégaif galbék inok fégito no bero tidéw dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Endob i Jesuse fénsénarén i kéférénawa nuwe sabaf bé kétete i fédéw ne. Brab ménbéréh mano, “I de begom do étéw méuyag béleewe ni, sedek ongoté kom i mékégaife? Béréhé ku begom i toowe, énda rigoné kuy mékégaife inok méngintoow gom.” ");
INSERT INTO tiy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tidéw béno, i Jesuse beroy de kuyugén ténagak roy de étéw ni, atin ménda ro man dob awange mifar dob dogote. ");
INSERT INTO tiy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Atin i de kuyugén énggélifoto roy muwite fan saliyu bé sébaane saén fan dob awange. ");
INSERT INTO tiy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Atin nuret Jesuse beroy sébaane binuwaya fantag bé de tete adatén do étéw. Ménbéréh mano, “Ingata kom brab sénggila gom i fégéfééruke fan kay de Fariseo brab datu Herode brab de kuyugén.” ");
INSERT INTO tiy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Endob i de kuyug Jesus, énda énggésobuto roy ni binuwaya. Marok bénréh Jesusey fantage bé tintuwe fégéfééruk fan. Mélaw ménségéno-géno ro maro, “Bénréhén i ni non énda i fa tom.” ");
INSERT INTO tiy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Endob i Jesuse énggétiga noy kéfégitung ruwe. Mélaw ménbéréh mano, “Sedek ségéno-géno gom fantag bé kékulang i fa tome? Aw énda séna gésobuto kom de? Maak do léngléngén gom. ");
INSERT INTO tiy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wén i do moto gom éndob maak do langafén gom. Wén soy do kélingo gom éndob maak do bokongén gom. Aw énggélifoto kom i rénigo guwe? ");
INSERT INTO tiy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Amun sénbaad-baad guy de limo timan fan dob de limo ngibu étéw, firoy gébiton i énggétimuo kome samaén?” Atin séménumbul ro maro, “Folo bra ruwo.” ");
INSERT INTO tiy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Atin ménénginsa i Jesuse man mano, “Atin amun sénbaad-baad guy de fitéw timan fan dob de fot ngibu étéw, firoy gébiton i énggétimuo kome samaén?” Atin séménumbul ro maro, “Fitéw.” ");
INSERT INTO tiy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Atin ménbéréh man i Jesuse mano, “Aw énda séna fo gésobuto kom de?” ");
INSERT INTO tiy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wén i no sébaan fuweh, énggumah i Jesuse beroy de kuyugén dob ingéde Betsaida. Atin wén i de étéw nuwit ro mangéy dob Beeney ségétéwe langafén lagéy, brab nongot roy gamaké no inok adi-adi. ");
INSERT INTO tiy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Atin i Jesuse, narakén i ni langafén brab ménsut ro kloh dob no ingéd. Tidéw béno, dénuraa noy de moto no brab ténégé noy langaféne ni. Tidéw béno, ménénginsa i Jesuse mano, “Aw wén i gito mo?” ");
INSERT INTO tiy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Atin iling-iling i lagéye ni brab séménumbul mano, “Hoo, gégitowu do étéw éndob maak do kayéw magéw.” ");
INSERT INTO tiy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tidéw béno, i Jesuse ténégé no man féruman i de moto no. Sonom béno, téménéngténg i ni lagéye brab énggégitonén fiyo non ménadi-adinén i de moto no. ");
INSERT INTO tiy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Atin i Jesuse sénuguén mule brab bénréhén mano, “Kago mawét dob nan ingéd.” ");
INSERT INTO tiy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tidéw béno, méntaus i Jesuse brab de kuyugén mangéy dob de ingéd gédét dob ingéde Sisarea Filipo. Brab amun diyo ro séna dob de lowoh aguwon, fénénginsaa Jesuse bero mano, “Ati kébéréh i de étéw ké ati Begéne?” ");
INSERT INTO tiy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Séménumbul ro maro, “Wén i de émbéréh maro, Juan Bautista go kun. I de dumo maro, Elias go kun. Brab i de dumo maro, Beem kun i énggétahe sénarigoy Tuluse muret.” ");
INSERT INTO tiy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tidéw béno, ménénginsa i Jesuse man mano, “Dob begome, ati kébéréh gome fantag bé Begéne?” I Pedrowe séménumbul mano, “Beemey Kristowe sénugu i Tuluse inok méguléw go dob de étéw.” ");
INSERT INTO tiy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tidéw béno, bénréh Jesuse bero mano, “Kagom béréhén i ni fantag bé Begéne dob de ségiyo.” ");
INSERT INTO tiy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tidéw béno, i Jesuse féngganayén i kétoro ne bero fantag bé mérigowe dob Beene. Ménbéréh mano, “I Nga i Kéilawane, sani Begéne, médooy rasayé kuwe. Brab i de odoro tom do Judio brab de odoroy de fadi brab de témoro bé kitabe ikaa ro Begén. Atin féléhué ro Begén. Endob dob gétéléwo nuwe gétérésangan tébuleu.” ");
INSERT INTO tiy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ménkéntay i kébéréh ne bé ni dob berowe. Mélaw i Pedrowe nuwitén i Jesuse inok ruwo ro saén, atin génléén. ");
INSERT INTO tiy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Endob séménling i Jesuse brab ténéngténgén i de kuyugén. Atin génléén i Pedrowe mano, “Férayu go dob Begéne, non maak Satanas go. Non énda mégitung go loo bé Tuluse, éndob mégitung go loo bé kéilawane.” ");
INSERT INTO tiy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tidéw béno, ténawag Jesusey de ménlimud do étéw brab de kuyugén inok mangéy ro dob Beene. Atin ménbéréh dob berowe mano, “I étéwe méuyot furay Begén, kailangan diguré noy kaane kétayan inok odoro noy kétayay Tuluse. Tidéw béno, kailanga no gédayday bé de kérégénon ségiléw bé Begéne, fiyon fo ké féléhuén dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Non i étéwe méuyot émféraru bé umul ne, méléhu. Endob i méléhue bé kéfuray ne Begén brab sabaf bé Fiyowe Uret, gédoté noy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ufama, fiyon fo ké i ségétéwe étéw gédoté noy kéluhanay éntingayéne dob duniyae ni, énda i atagén buluk méléhu atin mangéy dob emfernowe. ");
INSERT INTO tiy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Enda i tamuk fakay fégéluluk i étéwe inok gédoté no saén i umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mélaw buluk wén i mémala muret fantag bé kéunur ne Begén brab de kétoro gu dob duniyae ni méféno bé de énda méngintulus béleewe ni, i Begéne, sani Nga i Kéilawane, malané ku so buluk séfuleu moso begey i de télakiy Tuluse. Bé béno, réméndawu loo bé Abay guwe Tulus.” ");
INSERT INTO tiy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Atin féntaus Jesusey kébéréh ne mano, “Béréhé ku begom i toowe, wén i do dumo begom énda méléhu ro taman énda gito roy kéféguléw i Tuluse bé de étéwén, gégumah darabayay barakat ne.” ");
INSERT INTO tiy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Amun ménifus i néme gétérésangan, nuwit Jesusey Pedrowe brab Santiagowe brab Juane, atin ménangéy ro dob uruk i gérotore tuduk, énda i ségiyo étéw diyo. Atin i lala ruwe téméngténg bé Jesuse, i falas ne ménfégalin. ");
INSERT INTO tiy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Brab i kégal ne ménwaléy fute réméndaw. Enda nay étéw dob duniyae ni gétumaka noy kégale inok fute loo bé ni. ");
INSERT INTO tiy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sonom béno, méntéfégitoy Eliase brab Moisese brab ménsébéréh ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Atin i Pedrowe ménbéréh dob Jesuse mano, “Maistéro, toow fo fiyo non dob ni tom. Rémigo gey téléw timan dung-dung. Sébaan i kaame de, sébaan i ka Moisese de, brab sébaan i ka Eliase de.” ");
INSERT INTO tiy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Enda gétiga Pedrowey fiyowe béréhé no non toow ro fo ménggilak. ");
INSERT INTO tiy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tidéw béno, wén i rawéne ténggalungo no bero. Atin wén i ménbéréh tidéw dob rawéne ni mano, “Been i niy toowe fo kénimuo ku Nga gu. Fégélingo gom.” ");
INSERT INTO tiy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sonom béno, méniling-iling i de kuyugén éndob énda i énggito ro saliyu saén bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Amun léménudug ro tidéw dob tuduko no, i Jesuse fénégétén i kébéréh ne dob berowe mano, “Kagom génoén dob ségiyowey ni énggito gom taman i Nga i Kéilawane, sani Begéne tébule.” ");
INSERT INTO tiy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Atin nodoro roy sugu Jesuse ni éndob séfénginsa ro sébero-bero saén maro, “Ati keey i atag i kébéréh ne mano, ‘Tébuleu?’ ” ");
INSERT INTO tiy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Atin fénénginsa ro dob Jesuse maro, “Sedek i de témoro bé kitabe émbéréh ro bé kailangan géétah na gégumah i Eliase, atin tidéw béno gégumah i Kristowe kun?” ");
INSERT INTO tiy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Atin séménumbul i Jesuse mano, “Toow, géétah gégumah i Eliase inok tafayé noy kéluhanane. Endob sedek ménsulat i kébéréh i Tuluse bé i Nga i Kéilawane mérasay médoo brab ikaay de étéw? ");
INSERT INTO tiy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Endob béréhé ku begom, i Eliase énggégumahén, éndob i de étéw fénrasay ro loo bé kétaya ruwe. Been soy ménbéréhe dob Ménsulate Kébéréh i Tuluse mérigo dob beene.” ");
INSERT INTO tiy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Atin amun énggumaha ro Jesusey de ségiyo kuyugén, énggito roy dakéle ménlimud do étéw diyo so. Atin wén i de témoro bé kitab i de Judio séédél bé de kuyugén. ");
INSERT INTO tiy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","I kéluhanay de étéw do ménlimud, amun énggito roy Jesuse, toow fo ménggaif ro, atin ménségéta ro mangéy dob Beene atin sénggifa ro. ");
INSERT INTO tiy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Atin fénénginsaa Jesusey de kuyugén mano, “Ati no funa kom séédél bé do étéw diyo?” ");
INSERT INTO tiy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Atin wén i ségétéwe lagéy dob de étéw ni ménlimud séménumbul mano, “Maistéro, nuwit guy nga guwe lagéy mangéy dob Beeme, non rénahukoy saitane funa no mow. ");
INSERT INTO tiy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Atin wén i no férasayéy saitane, atin tuwaré no dob fantade. Atin rémbéw i ba ne, brab kémigét i de kifé no, brab waléy de témingkog. Nongot gu bé de kuyugém bé féféraréyé roy saitane, éndob énda gagané ro de.” ");
INSERT INTO tiy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Atin ménbéréh i Jesuse dob berowe mano, “Enda sémarig gom bé Tuluse. Lugoténun sétafik begom. Enda gétiga ku ké ati nay kérugay i kétingkél guwe sétafik begom. Uwit gom diniy ngaa nan.” ");
INSERT INTO tiy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mélaw nuwit roy ngae dob Beene. Atin i saitane ni amun énggito noy Jesuse, ténuwarén i ngae ni dob fantade brab ménkériring, rémbéw i ba ne so. ");
INSERT INTO tiy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Atin fénénginsaa Jesusey abay ne mano, “Ménfiroyén i kégédam ne bé ni?” Atin séménumbul mano, “Tidéw na fo kékélohén. ");
INSERT INTO tiy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Brab médoonén gule féléhuéy saitane damén méibér dob aféye brab dob wayége. Mélaw amuk wén i fiyo gérigono mo, fégédawan gey brab tabangén gey.” ");
INSERT INTO tiy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Atin séménumbul i Jesuse mano, “Sedek fénginsaa mo Begén ké wén i fiyo gérigono ku? Fakay i kéluhanane dob étéwe munur dob Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sonom béno, ménbéréh métanug i boh i ngae ni mano, “Munuru, éndob kulang i kéunur guwe. Féégétém i kéunur guwe.” ");
INSERT INTO tiy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tidéw béno, énggito Jesusey médoowe do étéw ségéta fégédét dob berowe. Mélaw sénuguén i saitane mano, “I beeme saitan émfémow brab émfébokong bé étéwe. Sugué ku beem, sut go tidéw dob ni nga, brab kagonén séfuleon de!” ");
INSERT INTO tiy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sonom béno, i saitane ni ménkes, brab gétimal i kéfékikil ne de. Tidéw béno, ménsut i saitane atin i ngae ni maak ménléhuén non éndaén lékutohén. Mélaw médooy de étéw ménbéréh ro maro, “Ménléhuén.” ");
INSERT INTO tiy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Endob i Jesuse génamakén i kémér ne brab féntekén, atin téménindég i ngae ni. ");
INSERT INTO tiy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tidéw béno, i Jesuse brab de kuyugén ménule ro. Atin amun ménahur ro dob lawie, brab énda i ségiyo étéw diyo, ménénginsa i de kuyugén dob Jesuse maro, “Sedek énda gagané key i émféféraréye bé no saitan?” ");
INSERT INTO tiy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Séménumbul i Jesuse mano, “I ni klase saitan, énda médédélén bé fiyon udenén fégédédél de, saliyu saén bé kédasale.” ");
INSERT INTO tiy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tidéw béno, ménagéw ro man tidéw diyo atin téménara ro dob ingéde Galilea. Atin ménika i Jesuse ké gétigay de étéw i gono nuwe. ");
INSERT INTO tiy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Non ténoroén i de kuyugén mano, “I Nga i Kéilawane, sani Begéne, fékéfo dob de étéw moso sani de sébanil Begén. Atin féléhué ro Begén. Endob amuk méifus i téléwe gétérésangan, tébuleu.” ");
INSERT INTO tiy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Endob bé béno gai, i de kuyugén énda énggésobuto roy béréhé Jesuse. Atin mégilak ro de ménginsa ké ati atag ne. ");
INSERT INTO tiy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Atin méntaus ro taman énggumah ro dob ingéde Kafernaum. Atin amun énggérahur ro dob lawie diyo, i Jesuse ménénginsa dob de kuyugén mano, “Ati funa kome séédél dob de lowoh aguwon?” ");
INSERT INTO tiy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Endob mémala ro sémumbul non amun diyo ro séna lowoh aguwon, ménséédél ro ké ati isuwe bero toow fo gérotor. ");
INSERT INTO tiy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tidéw béno, i Jesuse ménsar brab ténawagén i de folo bra ruwo gétéw do kuyugén mangéy dob Beene. Atin ménbéréh dob berowe mano, “Amuk wén i ségétéw témayan toow fo gérotor, ay niy fatute rigoné no. Fatut térifantad brab waléy ségétéw sugu-suguéy kéluhanay de dumo no.” ");
INSERT INTO tiy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tidéw béno, éndot Jesusey ségétéwe nga brab féndiyoén dob adafa ruwe. Atin sénfifi Jesuse brab ménbéréh dob berowe mano, ");
INSERT INTO tiy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Fiyon atiy étéwe témayakuf bé ngae loo bé ni sabaf bé kéunur ne Begén, tayakufé no so Begén. Brab atiy témayakufe Begén, tayakufé no soy Tuluse ménféuwit Begén.” ");
INSERT INTO tiy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Atin ménbéréh i Juane mano, “Maistéro, énggito gey i ségétéwe étéw démédél do saitan nusarén i dawét me. Endob génlé gey non békén dumo tom.” ");
INSERT INTO tiy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bang Jesuse, “Kagom géléén de. Non amuk wén i rémigo mékégaif usaré noy dawét guwe, énda magadén émbéréh tete fantag bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Non i békéne sébanil betom, dumo tom. ");
INSERT INTO tiy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Béréhé ku begom i toowe, buluk wén i témabang begom, fiyon iraya no saén begom ségétabu wayég inémén sabaf begomey de kuyug gu, tintu gédoté noy barase moso. ");
INSERT INTO tiy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Endob amuk wén i émfésala bé ségétéwe loo bé ni nga munur dob Begéne, toow fo gétimal i kékukume de. Mélaw mas na fiyo dob beene ké ibérén dob dogote ikéton dakél batéw i reer ne. ");
INSERT INTO tiy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mélaw amuk sébaan bé kémér mey émfésalae beem, kéléngém. Non mas na fiyo ké gédoté moy umule magufusa ségébala saén i kémér me, bé géangéy go dob uleono emferno ké ruwoy kémér me. Non diyo dob emfernowoy de sofot énda méléhu ro, brab i aféye énda méfandaén. ");
INSERT INTO tiy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Atin amuk i funa muwe mésala i sébaane bé sékéy me, kéléngém. ");
INSERT INTO tiy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Non mas na fiyo ké gédoté moy umule magufusa ségébala saén i sékéy me, bé géangéy go dob emfernowo, ruwoy de sékéyém. ");
INSERT INTO tiy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Atin amuk ségébala bé moto muwey funa muwe mésala, lésitém. Non mas fiyo ké géahur go dob kéféguléw i Tuluse ségébala saén i moto muwe, bé géangéy go dob emfernowo ruwoy de moto mo. ");
INSERT INTO tiy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Non diyo dob emfernowoy de sofot énda méléhu ro, brab i aféye énda méfandaén. ");
INSERT INTO tiy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Atin i aféye fédiyoén moso dob kéluhanane ségiléw bé timuse fédiyoén dob amaéne. ");
INSERT INTO tiy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“I timuse fiyo, non émféfiyo bé amaéne. Endob buluk mékédan i kétasik ne, éndaén i nonomén brab éndaén géséfule i kétasik ne. Atin ségiléw so bé ni, i de rigoné kom fatut géiring bé timuse inok émféfiyo gom bé de étéw. Atin békén fatut sékérit gom.” ");
INSERT INTO tiy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tidéw béno, ménagéw i Jesuse tidéw Kafernaum mangéy dob sakuf i dakéle ingéd Judea brab dob difar i wayége Jordan. Atin diyo médooy de ménangéy sélimud man dob Beene. Atin ténoroén bero loo bé adat ne. ");
INSERT INTO tiy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Atin wén i de Fariseo ménangéy dob Jesuse inok téngkadé ro inok gébérého noy békéne katabuwan. Mélaw fénénginsaa ro maro, “Aw fakay dob kitab tome ké i lagéye gélaké noy bawag ne?” ");
INSERT INTO tiy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Atin séménumbul i Jesuse mano, “Ati sugu Moisese dob kitabe fantag bé késégélake?” ");
INSERT INTO tiy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Atin séménumbul i de Fariseo maro, “Ténungkas Moisesey lagéye gémélak bé bawag ne amuk irayén i sulate bé késégélake.” ");
INSERT INTO tiy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Endob ménbéréh i Jesuse dob berowe mano, “I funa Moisese ténungkasén begom ségélak non métégas i de atur gom. ");
INSERT INTO tiy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Endob dob féganayo bé kélimbage bé kéilawane, rénigoy Tulusey ségétéwe lagéy brab ségétéwe libun. ");
INSERT INTO tiy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Atin been i niy funay lagéye tagaké noy abay ne brab idéng ne atin sétafik bé bawag ne. ");
INSERT INTO tiy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Atin i ruwowe ni gétéw waléy sébaan. Mélaw éndaén ruwo ro gétéw, éndob ségétéw saén. ");
INSERT INTO tiy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mélaw buluy fénwaléy i Tuluse sébaan, énda fakayén séfériyaséy étéwe.” ");
INSERT INTO tiy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Atin i de kuyug Jesus, amun ménule ro ménahur ro dob lawie bero Jesuse, ménénginsa ro dob Beene fantag bé késégélake. ");
INSERT INTO tiy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Atin séménumbul mano, “Fiyon atiy lagéye gémélak bé bawag ne atin mawag man ségiyo libun, léménamfa, brab ménsala dob sunguwe bawagén. ");
INSERT INTO tiy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Atin amuk wén i libun génlakén i bawag ne atin mawag ségiyo lagéy, léménamfa.” ");
INSERT INTO tiy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wén i no sébaan fuweh, wén i do étéw nuwit roy de nga ro dob Jesuse inok féfiyoné no bero. Endob i de kuyugén génlé roy de étéw ni, non marok énda fiyo no ké félugotén i Maistérowe. ");
INSERT INTO tiy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Endob amun énggito noy rénigoy de kuyugén, ménkérit i Jesuse. Atin ménbéréh dob de kuyugén mano, “Fédaya gom i de nga mangéy dob Begéne. Brab kagom alangén bero non i de étéw sémarig loo bé késarig i de ni nga, féguléwoy Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Béréhé ku begom i toowe, buluk i késarig i ségétéwe békén loo bé késarig i ngae, énda féguléwoy Tuluse de.” ");
INSERT INTO tiy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tidéw béno, sénfifi noy de nga brab ténégé noy de uléw ro féfiyoné no bero. ");
INSERT INTO tiy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Atin amun i ro Jesuse méntaus ro magéw, wén i ségétéwe lagéy ménséfégéta mangéy dob Jesuse brab ménlingkuwéd dob adafa nuwe. Atin ménénginsa mano, “Fiyo Maistéro, ati rigoné kuwe inok gédoté kuy umule magufusa?” ");
INSERT INTO tiy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Séménumbul i Jesuse mano, “Sedek fédawété mo Begén fiyo? Enda i ségiyo fiyo saliyu saén bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gétiga moy de sugu. Kago méméléhu, kago lémamfa, kago ménakaw, kago uretén i dumo muwe bé békéne toow, kago lémiful, brab fégadata moy boh me brab idéng me.” ");
INSERT INTO tiy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Séménumbul i lagéye ni mano, “Maistéro, i kéluhanay de ni nodoro ku tidéw féganay klohu de séna.” ");
INSERT INTO tiy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Atin ténéngténg Jesuse brab ménimu de. Atin ménbéréh mano, “Sébaan i kulange beem. Ule go brab fébéléyém i kéluhanay éntingayéne kaam atin irayém i kurtae dob de méskinan. Atin mélaw kawasa go moso dob lawayo. Tidéw béno, énggonén, odor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Amun énggélingooy étéwe niy ni, énggiton ménwaléy tete i fédéw ne. Atin ménagéw loo bé nan, non toow fo kawasa. ");
INSERT INTO tiy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tidéw béno, i Jesuse méniling-iling dob de kuyugén brab ménbéréh dob berowe mano, “Toow fo mérégén i kéahur i de kawasa dob kéféguléw i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Atin i de kuyugén ménggaif ro bé ni bénréh Jesuse. Gido loo, féntaus Jesusey kébéréh ne mano, “Do kuyug gu, toow fo mérégén i kéahure dob kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas na mélémuy kéahur i dakéle ayam dob tosong i darume bé ségétéwe étéw kawasa dob kéféguléw i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tidéw béno, ménumanan i kégaif i de kuyugén brab ménsébéréh ro maro, “Ati mélaw i de fakay méfukas?” ");
INSERT INTO tiy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Atin ténéngténg Jesuse bero brab séménumbul mano, “Amuk dob rigonéy kéilawane saén, énda fo fakayén. Endob i Tuluse gérigono no, non fakay gérigonoy Tulusey kéluhanane.” ");
INSERT INTO tiy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tidéw béno, ménbéréh i Pedrowe mano, “Ténagak gey i kéluhanane atin ménfuray gey Beem.” ");
INSERT INTO tiy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Atin bang Jesuse, “Béréhé ku begom i toowe, i ségétéwe témagak bé lawi ne, taloo no de dumo no sétiman idéng, taloo no do lukésén, taloo no do ngaén, taloo no fantadén inok ureté noy Fiyowe Uret fantag bé Begéne, ");
INSERT INTO tiy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gégédot toow na fo médoo bé de ni do gai. Gégédot mératuh takéf bé de lawi, brab dumo no sétiman idéng, brab do lukésén, brab do ngaén, brab do fantadén. Atin saliyu na bé nan, gédoté noy umule magufusa dob de gai moso. Endob amuk dini séna, férasayén sabaf bé Fiyowe Uret. ");
INSERT INTO tiy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Endob i de médoo do énggéétah béleewe ni, do géfuray moso. Atin i de médoo do énggéfuray béleewe, waléy do géétah moso.” ");
INSERT INTO tiy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Atin i Jesuse beroy de kuyugén, amun diyo ro dob aguwone mangéy dob Jerusalem, ménagéw i Jesuse dob métah ruwe. Atin ménggaif i de kuyugén brab ménggilak i de ménfuray bero, non magéw ro mangéy dob Jerusalem. Atin i Jesuse nuwitén man i de folo bra ruwo gétéw do kuyugén, inok sébero-bero saén, brab bénréhén beroy ati mérigowe moso dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ménbéréh mano, “Fégélingo gom, mangéy tom Jerusalem. Diyo, i Begéne, sani Nga i Kéilawane, irayu dob de odoroy de fadi brab dob de témoro bé kitabe. Atin kukumé ro Begén méléhu. Tidéw béno, atéé ro Begén dob de békén Judio. ");
INSERT INTO tiy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Atin i de békén Judio, diyangkaé ro Begén, brab duraa ro Begén, brab badasé ro Begén, brab féléhué ro Begén. Endob amuk méifus i téléwe gétérésangan, tébuleu.” ");
INSERT INTO tiy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tidéw béno, i Santiagowe brab Juane, sani de nga Sebedeo, téningé roy Jesuse. Atin ménbéréh ro maro, “Maistéro, wén i ongoté keye dob Beeme rigoné mo.” ");
INSERT INTO tiy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Atin bang Jesuse, “Ati kétaya kome rigoné ku begom?” ");
INSERT INTO tiy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Atin séménumbul ro maro, “Amuk Beem i méguléwe moso brab mésar go dob saray méguléwe, tungkasém so begey mésar dob sékulo muwe ségétéw i fingée dob kuwono muwe brab ségétéw i fingée dob biwong me.” ");
INSERT INTO tiy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Endob ménbéréh i Jesuse dob berowe mano, “Enda gétiga kom i ongoté kome. Aw gagané kom i de émfasang mérigo dob Begéne séko? Aw gagané kom i kéléhue loo bé mérigowe dob Begéne?” ");
INSERT INTO tiy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Atin séménumbul ro maro, “Hoo, gagané key.” Atin bang Jesuse bero, “Toow, mérasayu fo séko toow, atin mérasay gom so. Atin féléhuénu, atin féléhuén gom so. ");
INSERT INTO tiy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Endob békén Begén i mémilie bé ati mésare fingé dob kuwono kuwe taloo no fingé dob biwong guwe. I de ni saran kay de étéw fénémili i Abay guwe Tulus mésar diyo.” ");
INSERT INTO tiy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Atin i de folo gétéw dumo do kuyugén, amun énggélingoo roy ni ongoté ro Santiagowe brab Juane, ménkérit ro bero. ");
INSERT INTO tiy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mélaw ténawag Jesusey kéluhana ruwe inok sélimud ro, brab ménbéréh dob berowe mano, “Gétiga kom i de étéw kun odoron, wén i atura ro bé de étéw brab méguléwon bero. ");
INSERT INTO tiy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Endob békén loo bé niy begome. Amuk wén i ségétéw begom méuyot waléy odoron, fatut waléy sugu-suguéy kéluhanay de dumo no. ");
INSERT INTO tiy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Atin amuk wén i ségétéw begom méuyot waléy gérotor, fatut térifantad. ");
INSERT INTO tiy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Non fiyon i Begéne sani Nga i Kéilawane, énda ménangéyu dini inok wén i do sugu-sugué ku. Yamula ménangéyu dob duniyae ni inok waléyu sugu-suguén brab inok iray guy umul guwe fégéfukas bé médoowe étéw dob de sala ro.” ");
INSERT INTO tiy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Atin énggumah i ro Jesuse dob ingéde Jeriko. Atin amun méntaus ro ménagéw tidéw diyo beroy dakéle do ménlimud étéw, ténaraa roy ségétéwe étéw langafén ménsar dob doror i aguwone mongot limus. I dawét ne Bartimeo, nga Timeo. ");
INSERT INTO tiy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Atin amun énggélingoo noy Been i Jesuse tidéw Nasaret témara, téménawag métanug mano, “Jesus, séfu Datu Dabid, fégédaw go begén!” ");
INSERT INTO tiy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Médooy de étéw génlé ro maro, “Kago selekén!” Endob taus so mékes toow na fo métanug mano, “Séfu Datu Dabid, fégédaw go begén!” ");
INSERT INTO tiy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Atin téménrén i Jesuse brab ménbéréh mano, “Tawag gom i étéwa nan.” Mélaw ménbéréh ro dob langaféne ni maro, “Oror go! Tindég go non tawagé Jesuse beem.” ");
INSERT INTO tiy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mélaw kénda noy géruwowe lafin bé kégal ne brab ménagayas téménindég brab ménagéw mangéy dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Atin fénénginsaa Jesuse mano, “Ati kétaya muwe rigoné ku dob beeme?” Séménumbul i langaféne ni mano, “Maistéro, méuyotu ké gégitowu damén.” ");
INSERT INTO tiy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Atin ménbéréh i Jesus mano, “I kéféginugut mey funa muwe ménadi-adi. Na, ule gon.” Sonom béno, énggégito nén i lagéye ni, atin ménfuray bé Jesuse dob aguwone. ");
INSERT INTO tiy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Amun i Jesuse brab de kuyugén gédét ron dob ingéde Jerusalem, énggégumah ro dob sébaane tuduk féndawét Olibo, gédét dob de ingéd féndawét Betfage brab Betania. Atin sénugu Jesusey ruwowe gétéw bé de kuyugén inok métah ro magéw. ");
INSERT INTO tiy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Atin ménbéréh dob berowe mano, “Taus gom agéw mangéy dob nan ingéd gésaréwo kom. Buluk gégumah gom diyo, gito gom i natiwe kuda nikét, énda sénay énggékuda de. Ukoh gom brab uwit gom dini. ");
INSERT INTO tiy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Buluk wén i ménginsa dob begome, ‘Sedek rigoné kom i ni?’ béréh gom de, ‘Kailangay Kadna tome, atin féséfuleén so magad.’ ” ");
INSERT INTO tiy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mélaw ménagéw ro brab énggito roy natiwe ni kuda dob no ingéd, diyo dob aguwone nikét dob béngaway sébaane lawi. Amun nukoh ron, ");
INSERT INTO tiy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","i de étéw diyo ménénginsa ro maro, “Sedek ukohé kom i kudaa nan?” ");
INSERT INTO tiy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Atin séménumbul ro loo bé kébéréh Jesuse de bero. Mélaw fénagéw i de étéw bero muwit bé natiwe ni kuda. ");
INSERT INTO tiy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Atin nuwit ro mangéy dob Jesuse. Brab namféno ro bé de kégal ro. Atin kénudaa Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Atin médooy de étéw bénékah roy de dumo bé de kégal ro dob aguwo Jesuse fégito roy kébasana ruwe de. Atin wén soy de étéw bénékah roy de daun kénléng ro dob de kayéw dob de safad. ");
INSERT INTO tiy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Atin i de méntah do étéw brab de ménfuray, ménkes ro maro, “Dayéwé tom i Tuluse! Féfiyonéy Tuluse damén i ni étéw gégumah tidéw dob Kadnane. ");
INSERT INTO tiy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Féfiyonéy Tuluse damén i kéféguléw ne émfétaus bé kéféguléw i séfu tome Datu Dabid. Dayéwé tom i Tuluse!” ");
INSERT INTO tiy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Atin méntaus i ro Jesuse mangéy Jerusalem. Amun énggumah ro diyo, ménangéy i Jesuse dob lawi i Tuluse. Atin amun énggilidén ténéngténgén i kéluhanay de languntaman diyo, ménsut atin ménséfule mangéy Betania beroy de folo bra ruwo gétéw kuyugén, non témégénén. ");
INSERT INTO tiy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Atin dob sébaane de fuweh, bé lala ruwe magéw tidéw Betania mangéy Jerusalem, mélayaf i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Atin énggékulaya no tidéw mérayu i kayéwe féndawét igos méramfung i dau nuwe. Mélaw nangéyén lénangu kinok wén i onokén. Endob amun énggumah, énda i ségiyo énggito no saliyu bé de dau no, non békén séna gaiy no do kayéw igos mégonok. ");
INSERT INTO tiy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Atin ménbéréh dob ni kayéw mano, “Tidéw béleewe ni, éndaén i géama bé onok me féruman.” Atin énggélingooy de kuyugén. ");
INSERT INTO tiy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Amun énggumah i ro Jesuse dob Jerusalem, méntaus so dob lawi i Tuluse. Amun ménahur, dénédélén i de étéw démagang brab do méléy-méléy diyo. Atin bénluweén i de ahayay de lémuluk kurta brab ténuwarén i de saray de émfébéléy do fégétulak do marafati. ");
INSERT INTO tiy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Atin énda fédayaé no de ké wén i étéw muwit do éntingayén témara dob fésayaway lawi i Tuluse ni. ");
INSERT INTO tiy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Atin ténoroén i de étéw mano, “Ménsulat dob Ménsulate Kébéréh i Tuluse mano, ‘I lawi guwe, fédawétén lawi gonon démasal kay kéluhanay de étéw.’ Endob fénwaléy gom lawi i de ménakaw.” ");
INSERT INTO tiy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Atin i de odoroy de fadi brab de témoro bé kitabe énggélingoo roy ni. Mélaw sénalikél roy fiyowe kéféléhu ro de. Non ménggilak ro bé Jesuse non ménggaif i de ni médoo do étéw bé kétoro ne. ");
INSERT INTO tiy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Atin amun sémingkufén, méntékédan i Jesuse brab de kuyugén tidéw dob Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Atin bé géfuwéne de, bé lala ruwe magéw dob aguwone, énggito roy kayéwo no féndawét igos ménggangu taman dob de darirén. ");
INSERT INTO tiy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Atin i Pedrowe, énggétédémo noy ati ménrigowe. Mélaw ménbéréh dob Jesuse mano, “Maistéro, téngténgém. I kayéwo diyo fénémulaém, ménggangu.” ");
INSERT INTO tiy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Atin bang Jesuse, “Sarig gom dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Béréhé ku begom i toowe, fiyon udenén méréhon bé tuduke ni mano, ‘Angéy go dob dogote’, atin énda ruwo-ruwoy fédéw ne, éndob méginugut bé kébéréh ne méagéwon, méagéwon ba. ");
INSERT INTO tiy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mélaw béréhé ku begom, fiyon udenén ongoté kom ké démasal gom, féginugut gom bé gédoté kom, atin gédoté kom ba. ");
INSERT INTO tiy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Atin amuk démasal gom, fésagada kom i étéwe ménsala dob begome, inok i Abay gome Tulus fésagada no soy de sala gom. ");
INSERT INTO tiy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Non amuk énda fésagada kom i de dumo gom, i Abay gome dob lawayo, énda so mon fésagada no begom bé de sala gom.” ");
INSERT INTO tiy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Atin ménséfule man i ro Jesuse dob Jerusalem. Atin amun diyo séménugud i Jesuse dob lawi i Tuluse, i de odoroy de fadi brab de témoro bé kitabe brab de odoroy de Judio, ménfégédét ro dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Atin fénénginsaa ro maro, “Béréhém begey ké ati atura muwe rémigo bé de ni? Ati méniraye Beem kuwagib?” ");
INSERT INTO tiy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sénumbulo Jesuse bero mano, “Sémuliu ménginsa dob begome. Amuk sémumbul gom, sémumbulu so ké ati tidéwoy kuwagib guwe rémigo bé de ni. ");
INSERT INTO tiy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Béréh gom Begén, ati séménugue bé Juane inok mautis, Tulus loo ké étéw saén?” ");
INSERT INTO tiy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Atin i de odoroy de Judio séédél ro maro, “Amuk béréhé tom ‘Tidéw dob Tuluse’, fénginsaa no betom ké sedek énda fénéngintoowo tom i Juane. ");
INSERT INTO tiy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Endob buluk béréhé tom, ‘Tidéw dob étéwe’, mékérit i de étéw betom.” Non mégilak ro bé de étéw non féngintoowoy de étéw i Juane sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mélaw séménumbul ro dob Jesuse maro, “Enda gétiga key de.” Mélaw bénréh Jesuse mano, “Enda so béréhé ku de begom ké ati ménirayane Begén kuwagib rémigo bé de ni rigoné ku.” ");
INSERT INTO tiy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tidéw béno, téménoro man i Jesuse binuwaya. Ménbéréh mano, “Wén i ségétéwe étéw wén i safadén nohoko no do ubas. Atin bénunsudo no kayéw fénggélangkatén de lémiwét, brab kéménalut fédéngon bé fégékérése bé wayég i de onokén. Brab réménigo tambala. Tidéw béno, féntalimaén bé de ségiyo étéw, brab ménagéw mangéy dob mérayue ingéd. ");
INSERT INTO tiy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Amun énggégumah i gaiy kékétéwe de, séménugu ségétéw sugu-sugué no inok gédoté noy kaane de baad bé de onokén. ");
INSERT INTO tiy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Endob i de témalima bé ni safad génamak ro brab lénubag roy ni sugu-suguén. Brab fénule ro énda i suwaréw nuwitén. ");
INSERT INTO tiy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tidéw béno, i gefee bé safade sénugu non man i géruwowe sugu-sugué no. Endob i de témalima bé safad ne, fénali roy uléw ne brab fénémala ro. ");
INSERT INTO tiy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tidéw béno, i gefee sénugu non man i gétéléwe sugu-sugué no. Endob i de témalima bé safad ne, fénléhu ro. Loo so bé noy kérigo ruwe bé de médoo do sugu-suguéy gefee bé safade ni. Wén i do lénubag ro de, wén soy dob fénléhu ro de. ");
INSERT INTO tiy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tidéw béno, i gefee bé ni safad, wén nay ségétéwe sénuguén, sani kénimuo nuwe ngaén lagéy. Mélaw sénuguén mangéy dob berowe non fénggitungén mano, ‘Fégadata roy nga guwe.’ ");
INSERT INTO tiy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Endob amun énggitoy de témalima bé safad ne, ménsébéréh-béréh ro maro, ‘Been i niy nga i gefee bé ni safad. Féléhu tom inok gékatom i ni safad.’ ");
INSERT INTO tiy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mélaw génamak ro atin fénléhu ro, brab nibér ro dob liyuy safade ni.” ");
INSERT INTO tiy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Atin féntaus Jesusey kébéréh ne mano, “Ati rigonéy gefee bé safade ni dob de ni téménalima bé safad ne? Angéyé no féléhuén bero. Brab irayén man dob ségiyowe témalima. ");
INSERT INTO tiy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aw énggébasana kom i ni Ménsulat Kébéréh i Tuluse mano, ‘I batéwe nikaay de réménigo bé lawie, been i ménwaléye toow na fo balilaga fiyo batéw. ");
INSERT INTO tiy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","I ni rénigoy Kadnane ula-ula, atin mégaif tom de.’ ” ");
INSERT INTO tiy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Atin i de odoroy de Judio, ténulama ro kénéfo i Jesuse non énggébéla dob berowey ni binuwaya. Endob énda fakayén non mégilak ro bé de médoo do étéw. Mélaw ténagak roy Jesuse brab ménagéw ro. ");
INSERT INTO tiy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tidéw béno, i de odoroy de Judio sénugu roy de Fariseo brab de kuyug Herod mangéy dob Jesuse inok téngkadé ro émbéréh bé békéne katabuwan. ");
INSERT INTO tiy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mélaw ménangéy ro dob Jesuse ménginsa maro, “Maistéro, gétiga key toow i kétoro me. Brab métintu go, énda i isu ramigo mo bé de étéw. Endob toroé moy toowe fantag bé kétayay Tuluse toow. Mélaw béréhém begey, aw fatut ba mayad gey buwis dob Sesare sani datue dob Roma taloo no énda?” ");
INSERT INTO tiy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Endob énggétiga Jesusey akar ruwe, mélaw bénréhén bero mano, “Sedek férudio kom Begén? Uwitonu sélafin félatah, brab féténgténg gom Begén.” ");
INSERT INTO tiy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Amun niraya ro de, ménénginsa i Jesuse mano, “Ati gefee dawét brab falas gito gom dob nan?” Séménumbul ro maro, “Ka Sesar.” ");
INSERT INTO tiy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tidéw béno, bénréh Jesuse mano, “Iray gom dob Sesarey ka Sesare. Atin iray gom dob Tulusey kay Tuluse.” Atin toow ro fo ménggaif bé kébéréh Jesuse ni. ");
INSERT INTO tiy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Atin wén i de Saduseo ménangéy ro dob Jesuse. I de Saduseo do étéw énda méngintoow ro bé kéfétébule i Tuluse bé de étéw moso. ");
INSERT INTO tiy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Atin ménénginsa ro dob Jesuse maro, “Maistéro, sénulat Moisese betom i kukumane bé buluk i ofo i étéwe ménléhu, brab énggéféledo noy bawag ne, énda i nga ro, fatut bawagéy tuwaréy ne inok wén i séfu i ni étéw bé tuwaréy ne. ");
INSERT INTO tiy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ufama, wén i fitéw gétéw sétuwaréy falan lagéy. Brab i ofoe de ménawag. Tidéw béno, ménléhu énda i nga ro. ");
INSERT INTO tiy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tidéw béno, i géruwowe de bénawagén soy bawage fénled i ofo ne. Atin ménléhu so énda soy nga ro. Ségiléw soy ménrigowe dob gétéléwo ruwe. ");
INSERT INTO tiy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Atin ségiléw so dob kéluhana ruwe. I fitéwo no gétéw énggébawaga roy ni libun éndob ménléhu ro kéluhanan énda i nga ro. Tidéw béno, ménléhu soy ni libun. ");
INSERT INTO tiy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mélaw bé gaiy kétébule i kéluhanay de étéw moso, ati isuwe bawag i ni libun bé ni fitéw gétéw sétiman idéng? Non énggébawaga no bero kéluhanan bé méuyag ro de séna?” ");
INSERT INTO tiy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Séménumbul i Jesuse mano, “Toow fo békén katabuwan i kéfégitung goma nan, non énda gétiga kom i de Ménsulat Kébéréh i Tuluse taloo noy barakat ne. ");
INSERT INTO tiy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Non amuk tébule i de étéw, éndaén sébawag ro. Non ségiléw ro bé de télaki diyo dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Atin i fantage bé kétébulee, aw énda énggébasana kom de dob librowe sénulat Moisese fantag bé mérinoe kayéw? Non diyo ménsulat i bénréh i Tuluse dob Moisese mano, ‘Begén i Tuluse féngadafé Abrahame, Isake, brab Jakobe.’ ");
INSERT INTO tiy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I atag i ni, i Tuluse féngadaféy de méuyag étéw, békén do ménléhu. Mélaw tintu békén katabuwan i kéfégitung gome.” ");
INSERT INTO tiy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Diyo soy ségétéwe témoro bé kitabe brab énggélingoo noy de ni do étéw séédél bé Jesuse. Atin amun énggétiga noy toow fo fiyoy késumbulo Jesuse bé de Saduseo, ménfégédét dob Jesuse brab ménénginsa mano, “Ati isuwe bé de sugu dob kitabe toow na fo mélaga?” ");
INSERT INTO tiy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Atin séménumbul i Jesuse mano, “Ay niy toowe na fo mélaga sugu: ‘Fégélingo gom do Judio, i Kadna kome Tulus sébaan saén. ");
INSERT INTO tiy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Féimu go bé Kadnane Tulusém bé kéluhanay fédéw me, brab bé kéluhanay kamatu me, brab bé kéluhanay itunga muwe, brab bé kéluhanay bagér me.’ ");
INSERT INTO tiy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Atin ay niy géruwowe sugu: ‘Féimu go bé de dumo mo ringon so bé kéimu me bé kaame lowoh.’ Enda i ségiyo sugu gérotor na bé de ni.” ");
INSERT INTO tiy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Atin ménbéréh i témoroe bé kitabe dob Jesuse mano, “Fiyoy kébéréh ma nan, Maistéro. Toow i no bénréhém sébaan saén i Tuluse brab énda i ségiyo saliyu bé Beene. ");
INSERT INTO tiy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Atin fatut féimu tom bé Tuluse bé kéluhanay fédéw tome, brab bé kéluhanay itunga tome, brab bé kéluhanay bagér tome, brab fatut féimu tom bé de dumo tom ringon so bé kéimu tome bé de katome lowoh. Toow na mélaga i de ni ruwo sugu bé kéluhanay ténuwége ténulak do ayam brab do nirayén dob Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Atin énggétiga Jesusey fiyoy késumbul i ni lagéy. Mélaw ménbéréh dob ni lagéy mano, “Magad saén i kéféguléwoy Tuluse beem.” Atin tidéw béno, énda nay ségétéw ménbaraw ménénginsa dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Amun téménoro i Jesuse dob lawi i Tuluse, ménénginsa mano, “Ati kéfanu-fanu nuwe ké béréh i de témoro bé kitabey Kristowe séfu Dabid saén? ");
INSERT INTO tiy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Non fénbéréh i Rémogor i Tuluse bé Dabide mano, ‘I Kadnane ménbéréh dob Kadna kuwe, sar go dob kuwono kuwe, taman témabanu bé de sébanil Beem.’ ” ");
INSERT INTO tiy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Atin féntaus Jesusey kébéréh ne mano, “Amuk féndawét Dabidey Kristowe ‘Kadnan’, ati kéfanu-fanu Kristowe séfu Dabide saén?” Atin i dakéle ménlimud do étéw ménoror ro mégélingo bé kétoro Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Atin ténoroén bero mano, “Ingat gom bé de témoro bé kitabe non méuyot ro sugud-sugud bé de toow fo fiyo kégal ro, brab méuyot ro fégadatan ségifaén dob de fadiyan. ");
INSERT INTO tiy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Brab méuyot ro mésar dob de fiyo saran dob de lawi féngadafan brab dob de kanduli. ");
INSERT INTO tiy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Endob lafisé roy de libun baléw inok afasé roy de lawi ro. Tidéw béno, démasal ro bé de métaah kédasal dob téngaangay de étéw non marok médirung i de ni tete rigoné ro. Endob i ni do étéw toow na fo gétimal ké mékukum ro moso.” ");
INSERT INTO tiy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wén i no sébaan fuweh, amun diyo i Jesuse dob lawi i Tuluse, ménsar gédét dob ahurone kurta. Atin ténéngténgén i de étéw lémawu bé kurta ruwe. Médooy de kawasa do étéw léménawu ro médoo kurta. ");
INSERT INTO tiy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tidéw béno, énggito no soy ségétéwe libun baléw méskinan. Enggumah i ni baléw brab méniray saén ruwo lafin furo kurta tintu énda balilagaén. ");
INSERT INTO tiy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Atin i Jesuse ténawagén i de kuyugén mangéy dob Beene, brab mano bero, “Béréhé ku begom i toowe, i ni méskinan libun baléw maak mas na médooy niray ne bé kéluhanay de dumo étéw kawasa. ");
INSERT INTO tiy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Non i de ni étéw do kawasa, méniray ro saén kloh tidéw dob de médoo kurta ro. Endob i ni baléw éntéyén i kéluhanay kurta ne fégéfaguyagén.” ");
INSERT INTO tiy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","I lala Jesuse mésut tidéw dob lawi i Tuluse, i ségétéwe bé de kuyugén ménbéréh dob Beene mano, “Téngténgém, Maistéro. Toow fo dakél i de ni batéw fénggérigo bé de lawi i Tuluse ni, mélaw toow fo fiyoy de ni lawi.” ");
INSERT INTO tiy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Endob ménbéréh i Jesuse mano, “I de dakél ni do lawi, gégumah mosoy gaiwe i kéluhanane gito gom mébinasa. Brab fiyon i de batéw fénggérigo de, émbéragar ro.” ");
INSERT INTO tiy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Atin amun diyo i ro Jesuse ménsar dob Tuduke Olibo, dob gatagay lawi i Tuluse, fénénginsaa ro Pedrowe brab Santiagowe brab Juane brab Andrese sébero-bero saén. ");
INSERT INTO tiy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ménénginsa ro dob Jesuse maro, “Kédiron mérigoy de ni, sani kébinasay lawi i Tuluse? Brab ati fégélolonone de bé ni gai ké gédétén gégumah?” ");
INSERT INTO tiy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Atin séménumbul i Jesuse mano, “Ingat gom inok énda i méfagakaran begom. ");
INSERT INTO tiy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Non médoo mosoy de étéw gégumah usaré roy dawét guwe, brab émbéréh ro maro, ‘Begéney Kristowe’. Atin médooy de géfagakara ro. ");
INSERT INTO tiy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Atin kagom mégilak ké gélingoo kom i de sétiboh brab fantag bé de gira. I kéluhanay de ni mérigo, éndob békén sénay niy tamana nuwe. ");
INSERT INTO tiy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","I de ségiyo ingéd sétiboh ro bé de ségiyo ingéd. Brab i de ségiyo sakuf fangangaturan sétiboh ro bé de ségiyo. Atin wén mosoy do luba dob de médoo do gonon, brab lénggob. I de ni mérigo ségiléw bé ségétéwe obor libun kéararan non been sénay niy féganayay rasay ne. ");
INSERT INTO tiy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Endob ingat gom, non kéfoén gom moso brab uwitén gom dob adafay de kémukum. Atin mébadas gom moso dob de lawi féngadafan kay de Judio. Brab uwitén gom dob adafay de datu brab do méguléw inok kukumén gom sabaf begom i do kuyug gu. Endob been i niy gaiy kéuret gome bé Fiyowe Uret dob berowe. ");
INSERT INTO tiy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Atin bé énda séna gégumah i tamanane, i Fiyowe Uret kailangan uretén na métah dob kéluhanay ingéde. ");
INSERT INTO tiy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Atin amuk kéfoé ro begom brab uwitén gom dob adafay kémukume, kagom émbuku fantag bé atiy késumbul gome. Non amuk diyo gomén, béréh gom saén i atiy iraye dob begome fatut késumbul gom. Non i kébéréh gome bé béno, békén tidéw dob de itunga kom. Yamula fébéréh i Rémogor i Tuluse begom. ");
INSERT INTO tiy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Atin bé béno, wén i do étéw iray roy de dumo ro sétiman idéng inok féléhuén. Loo so bé niy rigonéy de lukés, féféléhu roy de nga ro. Loo soy de nga féféléhu roy de lukés ro. ");
INSERT INTO tiy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Atin i kéluhanay de étéw mérarék begom sabaf bé kéunur gome Begén, éndob ati fédaydaye munur taman dob tamfadane, beeney méfukase. ");
INSERT INTO tiy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Atin gito gom i ‘Mékésirang-sirange Surga’ diyo dob mékétéfuwe gonon békén fatut gonon. (Fégésobut i masawe.) Amuk mérigoy ni, i de étéw bati dob Judea, fatut ro méraréy dob de tuduk. ");
INSERT INTO tiy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Atin bé béno, i étéwe diyoén dob liyuy lawi ne, éndaén fatutén séminggula bé urase mahur dob lawie inok uwité noy de tamukén. ");
INSERT INTO tiy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Atin bé béno, i étéwe diyo dob safad ne, éndaén fatutén mule inok angéyé noy géruwowe lafin kégalén. ");
INSERT INTO tiy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bé do no do gai, toow fo mékégédaw-gédaw i de libun obor brab de libun mériton. ");
INSERT INTO tiy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dasala kom inok énda mérigoy de ni dob gaiwe mélégénéy. ");
INSERT INTO tiy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Non bé no do gai, toow na fo gétimal i kérasay i de étéw, sani kérasaye énda sénay énggéagéw de tidéw féganay bé kélimbag i Tuluse bé duniyae taman so béleewe ni. Atin énda na moso i géréféng de. ");
INSERT INTO tiy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Atin amuk énda féfokoéy Kadnaney do no gai, énda nay kéilawan méuyag. Endob sabaf bé de fénémilién do étéwén, féfokoé noy do no gai. ");
INSERT INTO tiy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Atin amuk wén i émbéréh dob begome mano, ‘Téngténg gom, ay niy Kristowe!’ look ‘Téngténg gom, ay diyoo!’ kagom unuron de. ");
INSERT INTO tiy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Non wén i do tugién do étéw gégumah brab béréhé ro bero kun i Kristowe taloo no sarigoy Tuluse. Atin gérigo ro do mékégaif brab do tanda, inok fégakara roy de fénémili i Tuluse do étéw ké fakay. ");
INSERT INTO tiy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mélaw ingat gom. Bénréh gun begom i kéluhanay de ni bé énda séna mérigo no. ");
INSERT INTO tiy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bé do no gai moso, amuk gilid i dakéle ni késélibug, waléy délémon i térésange brab éndaén réméndaw i térésang kélungonone. ");
INSERT INTO tiy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Atin i de gitoon médagdag ro tidéw dob lawayo, brab i de éntingayén dob lawayo mékuyung. ");
INSERT INTO tiy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tidéw béno, i Nga i Kéilawane, sani Begéne, téfégitowu tidéw dob lawayo dob de rawén toow fo barakatan brab réméndaw. ");
INSERT INTO tiy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Atin sugué kuy de télaki gu mangéy dob séngae gonon dob duniyae ni. Atin séfélimudé kuy de fénémili i Tuluse do étéw tidéw dob tamanay fantade brab dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tidéw béno, nuret Jesuse beroy ni binuwaya mano, “Fégitung gom i de kayéw. Dini dob betome ni, sonom lémbud i de fongoy kayéwe brab émféantu daun, gétiga kom gédétén i basa médufe. ");
INSERT INTO tiy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Loo so bé ni amuk gito gom i de ni bénréh gu bé gétahe mérigo, gétiga kom gédétén i késéfule guwe. ");
INSERT INTO tiy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Béréhé ku begom i toowe, i de étéw méuyag béni, énda méléhu ro taman mérigoy de ni. ");
INSERT INTO tiy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","I lawaye brab fantade méalfa, éndob i kébéréh guwe énda méalfaén. ");
INSERT INTO tiy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Endob i gaiwe mérigoy de ni, énda i gétigan de, fiyon foy de télaki dob lawayo, fiyon i Begéne, sani Nga i Tuluse. I Abaye Tulus saén i gétigane de. ");
INSERT INTO tiy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ingat gom, brab tulik gom, non énda gétiga kom de ké kédiron i kégumah i ni gai. ");
INSERT INTO tiy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ségiléw bé ségétéwe ménagéw tidéw dob lawi ne mangéy dob ségiyowe ingéd. Atin sénarigén i lawi ne dob de sugu-sugué no. Mélaw wén i galbék fatut rigonéy de sugu-sugué no. Atin bénréhén dob sugu-sugué nuwe dob béngawane mantay brab békén fidong. ");
INSERT INTO tiy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mélaw ingat gom, non énda gétiga kom i gaiwe séfuleu, ségiléw bé de sugu-suguén énda gétiga roy gaiwe séfule i gefee bé lawie, ké témégén, look kérara kélungonon, look ukoro i de manok, look géfuwén. ");
INSERT INTO tiy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kinok métékow i kégumah ne atin gito no bero fidong. Enda fatut mérigo no dob begome. ");
INSERT INTO tiy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mélaw béréhé ku begom brab dob de kéluhanay de étéw so: Tulik gom.” ");
INSERT INTO tiy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bé béno gai, ruwo séden gétérésangan i méifuse tidéw béno gégumah i kékanduli i de Judio féndawét “Témara”. Bé no kanduli, amaé roy fane énda i fénggéfééruk de. Atin i de odoroy de fadi brab de témoro bé kitabe sélédé roy ati kékéfo ruwe bé Jesuse brab féléhué ro. Endob méuyot ro de rémigo ké énda gétigay de ségiyo de étéw. ");
INSERT INTO tiy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ménsébéréh ro maro, “Enda fakayén ké rigoné tom ké kanduli tom, kinok mésélibug i de étéw.” ");
INSERT INTO tiy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wén i no sébaan fuweh, diyo i Jesuse dob Betania dob lawi i ségétéwe lagéy féndawét Simon. I ni lagéy ménadi-adi bé déruune fémute. Amun mama ro, énggumah i ségétéwe libun nuwitén i fiyowe katiya ménféno bé mamute nor toow fo balilaga féndawét nardo. Atin ménfégédét dob Jesuse brab rénébeén i reer i katiyae ni atin lénukaén i nore ni dob uléw Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Atin i de dumo bé de étéw diyo, amun énggito roy ni, ménkérit ro brab ménsébéréh ro maro, “Sedek séninggula saén i nan fégéféamut? ");
INSERT INTO tiy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Non amuk fénbéléy damén i nan nor, wén i médoo kurta gédotén de brab iray damén dob de méskinan.” Atin nugar roy ni libun. ");
INSERT INTO tiy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Endob ménbéréh i Jesuse mano, “Fédaya gom i ni libun. Sedek dowoyé kom? Toow fo fiyoy ni rénigo no dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Démoyun gom gésébegom i de méskinan, atin fakay gom témabang bero dob gaiwe kétaya kom. Endob i Begéne, éndaén mérugayu bati dini dob begome. ");
INSERT INTO tiy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I ni libun, rénigo noy gagané nuwe. Lénulawa no fégéféamut i lowoh guwe inok métafayan i kélébénge Begén. ");
INSERT INTO tiy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Béréhé ku begom i toowe, fiyon udenén gonon dob duniyae uretén i Fiyowe Uret, i rénigo nuwe dob Begéne méuret so funa no métédém.” ");
INSERT INTO tiy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tidéw béno, i Judas Iskariote, sani ségétéwe bé de folo bra ruwo kuyug Jesuse, ménangéy dob de odoroy de fadi inok sébéréh bero bé ati kéfékéfoe bé Jesuse dob berowe. ");
INSERT INTO tiy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Atin toow ro de fo ménoror, brab fénasada ro iraya ro kurta i Judase. Mélaw sénlédén i fiyowe gai kékéfo de. ");
INSERT INTO tiy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dob sunguwe gai bé kandulie féndawét “Témara” taloo no “Kéama bé Fane Enda i Fénggéfééruk de”, bé béno gai fatut ro sémumbali nati bili-bili fégékanduli ro. Mélaw i de kuyugén ménénginsa ro dob Jesuse maro, “Hon i gonone kétaya mo tafayé key i amaé muwe bé ni kanduli ‘Témara’?” ");
INSERT INTO tiy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tidéw béno, sénugu Jesusey ruwowe bé de kuyugén mano, “Agéw gom mangéy Jerusalem. Diyo wén i ségétéwe lagéy ménuwit ségébinangga wayég gébalaka no begom. Furay gom de. ");
INSERT INTO tiy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Atin amuk mahur dob lawie, ahur gom so. Brab béréh gom dob gefee bé lawie makom, ‘Méuyot i Maistérowe de ké gétiga no hon i sibéye de gono no mama beroy de kuyugén bé ni kékanduli.’ ");
INSERT INTO tiy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Atin i gefee bé lawie toroé no begom i dakéle sibéy wén i do ténafay do kasangkafan dob rotor i lawie. Diyo tafay gom i kéluhanay amaé tome.” ");
INSERT INTO tiy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tidéw béno, ménagéw i de ruwo ni gétéw do kuyugén brab ménahur ro dob Jerusalem. Atin énggito roy kéluhanane loo bé kébéréh Jesuse de bero. Tidéw béno, ténafay roy de amaé ro kay kandulie “Témara”. ");
INSERT INTO tiy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Atin amun sémingkufén, énggumah diyo i Jesuse beroy de folo bra ruwo gétéw kuyugén. ");
INSERT INTO tiy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Amun ménsar ro mama dob doror i ahayane, ménbéréh i Jesuse mano, “Béréhé ku begom i toowe, wén sékoy ségétéw begom émfékéfo Begén, sani ségétéwe séréngan Begén mama.” ");
INSERT INTO tiy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tidéw béno, ménwaléy tete i fédéw i de kuyugén. Atin ménsétundug-tundug i séngae ségétéw bero ménénginsa dob Jesuse mano, “Békén begén, hay?” ");
INSERT INTO tiy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Atin sénumbulo Jesuse bero mano, “I beene ségétéw begom do folo bra ruwo gétéw kuyug gu, sani ségétéwe begom séréngan Begén mérém bé fa nuwe dob biléwe. ");
INSERT INTO tiy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","I Begéne, sani Nga i Kéilawane, méléhuu loo bé Ménsulate Kébéréh i Tuluse fantag bé Begéne. Endob toow fo mékégédaw-gédaw i étéwe ni émfékéfo Begén. I nan étéw, mas na fiyo dob beene ké énda damén ménumahén, non mékukum fo toow.” ");
INSERT INTO tiy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Atin bé lala ruwe mama, éndot Jesusey fane, brab ménfésalamat dob Tuluse, brab sénkébeng-kébengén, brab sénaarén dob de kuyugén. Atin ménbéréh mano, “Ay niy fane. Been i lowoh guwe. Ama gom.” ");
INSERT INTO tiy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tidéw béno, éndotén i tabue, brab ménfésalamat dob Tuluse, brab nirayén bero. Atin kéluhana ro méniném de. ");
INSERT INTO tiy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Atin ménbéréh i Jesuse mano, “I ni arak, been i dara guwe réménanas sabaf bé médoowe étéw. Been i niy tanda i fasad i Tuluse bé de étéwén. ");
INSERT INTO tiy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Béréhé ku begom i toowe, éndaén minému arak taman géinému mantu arak dob gaiwe féguléwoy Tulusey de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tidéw béno, kéménanta ro sébaan kanta démayéw bé Tuluse. Tidéw béno, ménagéw ro mangéy dob tuduke Olibo. ");
INSERT INTO tiy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Atin bang Jesuse dob de kuyugén, “I kéluhana kome méraréy séko tagaké kom Begén. Non wén i Ménsulate Kébéréh i Tuluse mano, ‘Féléhué kuy témalimae bé de bili-bili, atin mélaw mésébéragar i de bili-bili.’ ” ");
INSERT INTO tiy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Atin féntaus Jesusey kébéréh ne mano, “Endob amuk tébuleu, métahu magéw begom mangéy dob Galilea.” ");
INSERT INTO tiy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Atin bang Pedrowe, “Enda fo tagaké ku Beem, fiyon fo ké i kéluhanay de ségiyo kuyugém méraréy ro tagaké ro Beem.” ");
INSERT INTO tiy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Endob ménbéréh i Jesuse dob Pedrowe mano, “Béréhé ku beem i toowe, bé ni kélungonon, bé énda séna ukoro i férufete ruwo gule, dirungé mo Begén téléw gule bé énda gélolo mo Begén.” ");
INSERT INTO tiy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Atin ménbéréh man i Pedrowe toow na fo méégét mano, “Fiyon fo ké géodoru Beem méléhu, énda dirungé ku Beem.” Atin i kéluhanay de dumo no do kuyug ménbéréh loo bé nan dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tidéw béno, ménagéw i ro Jesuse dob gonone féndawét Getsemani. Amun énggumah ro, ménbéréh i Jesuse dob de kuyugén mano, “Sar gom dob ni bé lala guwe démasal.” ");
INSERT INTO tiy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tidéw béno, nuwit Jesusey ro Pedrowe, Santiagowe, brab Juane, atin méntaus ro magéw kloh. Atin ménwaléy toow fo tete i fédéw Jesuse brab ménbuku. ");
INSERT INTO tiy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Atin ménbéréh dob de ni téléw kuyugén mano, “I fédéw guwe toow fo ménbuku taman toow fo démawét. Bati gom dini, brab tulik gom.” ");
INSERT INTO tiy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tidéw béno, ménférayu dob berowe gumaha témabar. Atin méntéléngkéb dob fantade brab déménasal mongot bé amuk fakay saén, énda damén mérigoy ni kérasay dob Beene. ");
INSERT INTO tiy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Déménasal mano, “Abay, fakay gérigono moy kéluhanane. Mélaw kago fédayaén Begén mérasay séko. Endob i kaame kétayan i mérigowe damén, békén i kagéne kétayan.” ");
INSERT INTO tiy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tidéw béno, ménséfule mangéy dob de téléw ni gétéw kuyugén, atin énggito no bero énggéfidong. Atin ménbéréh dob Simon Pedrowe mano, “Simon, géfidong go? Aw énda wayo gétulik go fiyon ségéuras saén?” ");
INSERT INTO tiy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Atin ménbéréh dob berowe téléw gétéw mano, “Tulik gom, brab dasal gom inok énda métukawan gom. Méuyot gom rémigo bé kétaya kuwe, éndob mélubay i de lowoh gom, brab magad géfélis bé de sugu gu.” ");
INSERT INTO tiy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tidéw béno, ménagéw man i Jesuse, brab déménasal so loo bé énggétahe de. ");
INSERT INTO tiy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tidéw béno, ménséfule man, brab énggito no bero énggéfidong man, non toow ro fo manat. Atin énda gétiga roy ati fiyowe kébéréh ro dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Atin ménagéw man i Jesuse atin énda mérugayén tidéw béno, ménséfule dob gétéléw ne gule, brab ménbéréh dob berowe mano, “Aw tafay gom séna fidong brab témérén? Na, énggumahén i urase. Téngténg gom, i Nga i Kéilawane, sani Begéne fékéfo dob de ménsala étéw. ");
INSERT INTO tiy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na tek gom, magéw tomén. Téngténg gom, ay nan nén gégumah i émfékéfoe Begén.” ");
INSERT INTO tiy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Amun émbéréh sénay Jesuse, énggégumah i Judase, sani ségétéwe bé de folo bra ruwo gétéw kuyugén. Atin ménodor i de médoo do étéw sénugu i de odoroy de fadi brab de témoro bé kitabe brab de odoroy de Judio. Ménuwit ro do sundang brab do bastun. ");
INSERT INTO tiy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Atin i ménfékéfoe de, sani Judase, bé gétahe niraya noy de étéw fégétigana ro de non bénréhén bero mano, “I étéwe aréké ku, been i no. Kéfo gom brab toow gom fo bantayan bé lala gome de muwit.” ");
INSERT INTO tiy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mélaw amun énggégumah i Judase, ménfégédét dob Jesuse brab ménbéréh mano, “Maistéro.” Atin narékén. ");
INSERT INTO tiy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mélaw i de étéw kénéfo roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Endob i ségétéwe bé de kuyug Jesus diyo, rénau noy sundang ne brab ténibohén i riféy gérotore fadi brab ménsilaf i ségébalae bé kélingo ne. ");
INSERT INTO tiy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tidéw béno, ménbéréh i Jesuse dob de kéméfo de mano, “Sedek ménuwit gom do sundang brab do bastun, maak ségétéwu tulisan kéfoé kom? ");
INSERT INTO tiy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sénga fuweh diyou dob lawi i Tuluse témoro. Diyo gom so, éndob énda kénéfo gom Begén. Endob mérigoy ni inok métuman i Ménsulate Kébéréh i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tidéw béno, i kéluhanay de kuyugén ténagak roy Jesuse brab ménraréy ro. ");
INSERT INTO tiy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wén i ségétéwe kénogo lagéy ménfuray bé Jesuse. I ni kénogo lagéy énda i kégalén, ménggélimot saén mut. Atin ténlama ro so kénéfo. ");
INSERT INTO tiy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Endob ménraréy ménfélawas non énggétagaka noy mut ne bé kéfagayas ne. ");
INSERT INTO tiy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tidéw béno, nuwit roy Jesuse dob lawi i gérotore fadi. Diyo ménlimud i kéluhanay de odoroy de fadi brab de odoroy de Judio brab de témoro bé kitabe. ");
INSERT INTO tiy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Atin ménfuray i Pedrowe éndob ménférayu kloh. Brab ménahur dob fésayaway lawi i gérotore ni fadi. Diyo ménsar beroy de guwardiya géliwét dob aféye télagang ro. ");
INSERT INTO tiy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Atin i de odoroy de fadi brab kéluhanay de kéfédéwan, salkélé roy gétimale kétébo ro bé Jesuse inok wén i funa ro de méméléhu, éndob énda gérigono ro de. ");
INSERT INTO tiy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Médooy de tugién do étéw téménébo bé Jesuse bé békéne toow, éndob i de kébéréh ro énda géséodorén. ");
INSERT INTO tiy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tidéw béno, wén i do téménindég émbéréh bé ni tugién kétébo maro, ");
INSERT INTO tiy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Enggélingoo key i kébéréh ne mano, ‘Binasané kuy lawi i Tuluse ni rénigoy de kéilawan, brab amuk méifus i téléwe gétérésangan, rémigowu man ségiyo lawi i Tuluse békén rénigoy kéilawane.’ ” ");
INSERT INTO tiy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gido loo, énda géséfagayun i kébéréh i de ni étéw tugién. ");
INSERT INTO tiy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tidéw béno, i gérotore fadi téménindég dob téngaangay de ménlimud do odoron brab ménénginsa dob Jesuse mano, “Ati késumbul me bé ni kétébo ro Beem?” ");
INSERT INTO tiy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Endob énda séménumbul i Jesuse, ménantés saén. Atin ménénginsa man i gérotore fadi mano, “Aw Beemey Kristowe, Nga i ménbantuge Tulus?” ");
INSERT INTO tiy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Atin séménumbul i Jesuse mano, “Hoo, Begén. Atin gito gom moso Begén, sani Nga i Kéilawane, mésar fingé dob kuwonoy barakatane Tulus. Atin gito gom Begén dob de rawén séfuleu tidéw dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tidéw béno, i gérotore ni fadi kénusién i kégal ne émféténgténg bé kékérit ne bé kébéréh Jesuse ni. Atin ménbéréh mano, “Endaén kailanga tom i téméboe de dob betome. ");
INSERT INTO tiy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Non énggélingoo tomén i mékémurkae kébéréhén. Ati karang gome de fatut rigoné tom?” Atin kéluhana ro kénukum ro bé fatut féléhuén. ");
INSERT INTO tiy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tidéw béno, i de dumo bero dénuraa roy Jesuse. Atin ténléb roy de moto no bé munsalawe brab ténafés ro brab fén-antuk ro de ké ati téménafése de. Atin i de guwardiya, génamak ro brab lénubag ro. ");
INSERT INTO tiy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Atin amun diyo sénay Pedrowe dob fésayaway lawie ni, téménara i ségétéwe kénogon sugu-suguéy gérotore fadi. ");
INSERT INTO tiy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Amun énggito noy Pedrowe télagang, fénandangén brab ménbéréh mano, “Beem soy dumo Jesuse tidéw Nasaret.” ");
INSERT INTO tiy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Endob dénirung Pedrowe mano, “Enda gétiga ku de brab énda gésobuto kuy nan béréhé mo.” Amun bénréhén i ni, ménagéw mangéy dob béngawane. Atin sonom béno, ménukoro i férufete. ");
INSERT INTO tiy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Atin i kénogone ni sugu-suguén, amun énggito no man i Pedrowe diyo dob béngawane, bénréhén man dob de étéw diyo mano, “Beeney lagéye dumo Jesuse.” ");
INSERT INTO tiy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Endob dénirung Pedrowe man. Enda mérugayén tidéw béno, i de étéw diyo ténébo roy Pedrowe man maro, “Tintu go dumo no, non ségétéw go so tidéw Galilea.” ");
INSERT INTO tiy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tidéw béno, toow fo séménafa i Pedrowe mano, “Kukuméy Tuluse damén begén ké tugiénu. Toow fo énda gétiga kuy nan étéw béréhé kom.” ");
INSERT INTO tiy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sonom béno, ménukoro i férufete bé géruwo nuwe gule. Bé béno so, énggétédémo Pedrowey bénréh Jesuse dob beene mano, “Enda séna ukoro i manoke bé géruwo nuwe gule, dirungé mo Begén téléw gule bé énda gélolo mo Begén.” Mélaw toow fo kéménrew i Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Atin modor géfuwén, i de odoroy de fadi ménsélimud ro beroy de odoroy de Judio brab de témoro bé kitabe brab kéluhanay de kéfédéway de Judio. Atin ménagayun ro. Mélaw nikét roy Jesuse bé de sangkali brab narak ro nuwit ro mangéy dob Pilatowe, sani méguléwe tidéw Roma, atin naté ro dob beene. ");
INSERT INTO tiy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Atin fénénginsaa Pilatowey Jesuse mano, “Aw Beem i Datu i de Judio?” Atin séménumbul i Jesuse mano, “Beem i ménbéréh de.” ");
INSERT INTO tiy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Atin i de odoroy de fadi ténébo roy Jesuse bé médoowe kétébo ro de. ");
INSERT INTO tiy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mélaw ménénginsa man i Pilatowe mano, “Sedek énda sémumbul go? Non énggélingoo moy de médoo do kétébo ro Beem.” ");
INSERT INTO tiy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Endob énda fo séménumbul i Jesuse. Atin mélaw ménggaif i Pilatowe. ");
INSERT INTO tiy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ménrigoy ni dob gaiwe kanduli ro féndawét Témara. Atin i adat Pilatowe, sénga kanduli Témara, témangéy ségétéw férisu, been i niy ongotéy de étéw de. ");
INSERT INTO tiy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Atin bé béno gai, wén i ségétéwe férisu féndawét Barabas. Ménférisu beroy de dumo no ménsétiboh bé de gémamak kukuman. Ménméléhu étéw bé no késétiboh ro. ");
INSERT INTO tiy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mélaw amun ménlimud i de étéw ménfégédét ro dob Pilatowe ongoté ro ké témangéy ségétéw férisu, ");
INSERT INTO tiy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ménénginsa i Pilatowe mano, “Kétaya kom ké fésuté kuy datu gome do Judio?” ");
INSERT INTO tiy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Rénigo noy ni non énggétiga noy funay de odoroy de fadi ménaté bé Jesuse non méndaléw ro de. ");
INSERT INTO tiy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Endob i de odoroy de fadi fénkérit roy de ménlimud do étéw atin mélaw nongot ro dob Pilatowe ké tangéyé noy Barabase mangéy dob berowe. ");
INSERT INTO tiy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Atin ménbéréh man i Pilatowe dob de étéw mano, “Ati mélaw i kérigo gu bé ni lagéy féndawét gom ‘Datu i de Judio’?” ");
INSERT INTO tiy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Endob i de étéw ménkes ro maro, “Kélabo gom dob kruse!” ");
INSERT INTO tiy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Atin ménénginsa i Pilatowe mano, “Sede? Ati tetee rénigo no ula-ula?” Endob i de étéw ménkes ro man minut fo métanug bé i Jesuse kélabonén dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tidéw béno, ménuyot i Pilatowe ké fiyoy de fédéw i de ménlimud do étéw. Mélaw féntangéyén i Barabase, atin fénbadasén i Jesuse brab fénatéén dob berowe inok kélaboné ro dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tidéw béno, i de sundalo nuwit roy Jesuse mangéy mahur dob fésayaway lawi i odorone tidéw Roma. Atin lénimud roy kéluhanay de dumo ro sundalo ségébataliyon. ");
INSERT INTO tiy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Atin fénkégal roy Jesuse bé furowe métaah kégal maak datu, brab lénuku roy suwarane kélég atin fénsayaf ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tidéw béno, ubo-ubo basana ro maro, “Méraru damén i Datu i de Judio!” ");
INSERT INTO tiy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Atin bénadas roy uléw ne bé kayéwe brab dénuraa ro, brab léningkuwédo ro ubo-ubo basana ro. ");
INSERT INTO tiy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Atin amun énggilid ro déniyangka, kénda roy furowe kégal brab fénkégal ro dey kaane insod. Tidéw béno, nuwit ro mésut dob Jerusalem atin nangéy ro kénlabo dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Atin amun diyo ro séna dob de aguwon, énggébalaka roy étéwe féndawét Simon tidéw dob ingéde Siren, abay Alejandrowe brab Rufo. Béno sénay kégumah ne dob no ingéd tidéw dob de safadén. Atin fénégés ro démuwal bé krus Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Atin nuwit roy Jesuse mangéy dob gonone féndawét Golgota (i atag ne “gonoy kulobong uléwe”). ");
INSERT INTO tiy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Atin niraya roy Jesuse arak lénawékon uwa, éndob énda éndotén de. ");
INSERT INTO tiy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tidéw béno, i de sundalo kénlabo roy Jesuse dob kruse brab sénsaar-saar roy de kégalén, sénkungkungo roy ati gégédote bé séngae de sélafin. ");
INSERT INTO tiy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Géraraan lémowot i térésange bé kékélabo ruwe bé Jesuse dob kruse. ");
INSERT INTO tiy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Atin diyo dob kruse wén i ménténae sulat bé kétébo ruwe de mano, “Datu i de Judio”. ");
INSERT INTO tiy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kénlabo ro soy ruwowe gétéw ménakaw dob de krus. I sébaane de fingé dob kuwono Jesuse, brab i sébaane de fingé dob biwong Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mélaw méntuman i Ménsulate Kébéréh i Tuluse mano, “Kénarang roy Beene ségétéw bé de ménsala étéw.” ");
INSERT INTO tiy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Atin i de témara dob no, déniyangka roy Jesuse brab dangu-danguo ro inok duwoyé ro, brab maro, “Hoy! Aw békén ba Beem i ménbéréhe bé binasané moy lawi i Tuluse brab rigoné mo man bé téléwe gétérésangan? ");
INSERT INTO tiy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Lus go mélaw dob krusa nan brab tabanga moy kaame lowoh.” ");
INSERT INTO tiy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Atin ségiléw so bé niy kédiyangka i de odoroy de fadi de brab de témoro bé kitabe. Ménsébéréh-béréh ro maro, “Ténabangén i de ségiyo étéw inok énda méléhu ro, éndob énda gétabanga noy kaane lowoh inok énda méléhuén. ");
INSERT INTO tiy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Amuk Beeney Kristowe, sani datu tome do Judio, fatut mélus béleewe ni tidéw dob kruse ni inok gito tom brab géféginugut tom de.” Atin i de ruwo gétéw énggéséréngan de ménklabo dob de krus, déniyangka ro soy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Amun géutuhén, ménwaléy délémon i kéluhanay de gonon dob duniyae taman géraraan lémudug i térésange de. ");
INSERT INTO tiy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Atin amun géraraan lémudug i térésange de, téménawag i Jesuse métanug mano, “Eloi, Eloi, lama sabaktani?” I atag ne “Tulus gu, Tulus gu, sedek ténagakém Begén?” ");
INSERT INTO tiy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Atin i de dumoy de étéw diyo énggégélingo de, ménbéréh ro maro, “Fégélingo gom, tawagé noy Eliase.” ");
INSERT INTO tiy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Atin i ségétéwe bero diyo, ménagayas éndotén i maake gafas brab nérémén dob mélémuwe arak. Tidéw béno, féndiyoén dob kayéwe brab féndiyoén dob ba Jesuse inok éséfé no. Atin ménbéréh i ni étéw mano, “Fédaya gomén. Tuliké tom ké gégumah i Eliase émfélus de.” ");
INSERT INTO tiy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tidéw béno, ségule man ménkes i Jesuse, atin ménléhuén. ");
INSERT INTO tiy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sonom béno, i rindunge dob lawi i Tuluse ruwoy ménsésédaya nuwe, ménkusi tidéw rotor mangéy fantad. ");
INSERT INTO tiy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Atin i odoroy de sundalo téménindég dob adafay krus Jesuse, énggélingoo noy kéékes Jesuse brab énggito noy kéléhu ne. Ménbéréh i ni sundalo mano, “Tintu fo Nga i Tulusey ni lagéy.” ");
INSERT INTO tiy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Atin diyo soy de libun kémulay gétangka tidéw dob no, ro Maria Magdalena, brab Maria idéng Jose brab ménguwéde séna Santiago, brab diyo soy libune Salome. ");
INSERT INTO tiy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","I de ni do libun, ménfuray ro bé Jesuse brab ténabang ro amun diyo de séna dob Galilea. Atin diyo soy de médoo na do libun ménodor de mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bé béno gai, témégénén i térésange bé kétafay ruwe bé gétunduge de fuweh, sani gai kétéréne. ");
INSERT INTO tiy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mélaw énggumah i ségétéwe lagéy féndawét Jose, tidéw Arimatea. Beeney ségétéwe bé de kéfédéway de Judio, brab toow fo fégadatan. Brab ongot-ongoté noy kégumah i kéféguléw i Tuluse. Atin i Josehe ménbaraw ménangéy dob Pilatowe nongotén i bangkay Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Atin i Pilatowe, ménggaif non magad i kéléhu Jesuse. Mélaw féntawagén i odoroy de sundalo brab ménénginsa ké ménrugayén i kéléhu Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Amun énggélingoo noy kébéréh i odoroy de sundalo bé tintu fo ménléhuén i Jesuse, ténungkasén i Josehe médot de. ");
INSERT INTO tiy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mélaw i Josehe, bénléyén i futee safut brab amun ménkédanén i bangkay Jesuse dob kruse, bénausén bé safuto no. Atin féndiyoén dob lébénge ténosong dob rangih i fingase. Tidéw béno, kénriringén i dakéle batéw mangéy dob béngaway lébénge ni fénggétélébén de. ");
INSERT INTO tiy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","I Maria Magdalenawe brab Mariahe idéng Josehe ténéngténg ro brab énggito roy lébénge fénggonon bé bangkay Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Amun ménifus i gaiy kétéréne, i Maria Magdalenawe, brab Mariahe idéng Santiagowe, brab Salomewe, ménléy ro do fégéféamut inok fédiyoé ro dob bangkay Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Atin toow séna fo géfuwén bé no Duminggu, amun sémbang i térésange, ménangéy ro dob lébénge. ");
INSERT INTO tiy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Atin amun diyo ro dob de aguwon, ménséuret-uret ro maro, “Ati sékoy kémériringe bé batéwe tidéw dob béngaway lébéngo no inok géahur tom?” Non toow fo dakél i batéwo no. Endob amun énggumah ro, brab ténéngténg ro, énggito roy batéwe fénggétéléb bé béngawane ménkériring. ");
INSERT INTO tiy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Amun ménahur ro dob lébénge ni, énggito roy ségétéwe kénogo lagéy ménsar fingé kuwonon, brab kéménégal fute. Atin toow ro fo ménggaif. ");
INSERT INTO tiy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Atin ménbéréh i ni lagéy mano, “Kagom mégaif. Gétiga ku sélédé kom i Jesuse tidéw Nasaret, sani fénléhue dob kruse. Endob éndaén dini no, non méntébuleén. Téngténg gom, ay ni féniroo ruwe de. ");
INSERT INTO tiy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, agéw gom, brab uret gom i ni kébéréh dob de kuyugén labi na fo dob Pedrowe, bé métah begom i Jesuse mangéy Galilea. Diyo gito gom, loo bé kébéréh ne de dob begome bé do gétah.” ");
INSERT INTO tiy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tidéw béno, i de ni libun, ménsut ro tidéw dob lébénge ni brab léménéntu ro magéw. Non toow ro fo ménggilak brab ménggaif. Atin énda énggéureto roy ni dob de ségiyo non ménggilak ro. ");
INSERT INTO tiy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Amun méntébule i Jesuse bé toowe géfuwén bé no Duminggu, méntéfégito sungu dob Maria Magdalenawe, sani libune fénféraréy Jesusey de fitéw gétéw saitan tidéw dob beene. ");
INSERT INTO tiy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Atin i Mariahe ni, ménangéy dob de kuyug Jesus, bé lala ruwe rémuung brab kémérew fantag bé kéléhu Jesuse. Atin nuretén dob berowey fantage bé kétébule Jesuse. ");
INSERT INTO tiy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Endob amun énggélingoo roy kébéréh ne bé méntébule i Jesuse brab énggito no, énda ménunur ro de. ");
INSERT INTO tiy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Amun énggilid i ni, méntéfégito man i Jesuse bé ségiyowe falasén dob ruwowe gétéw bé de kuyugén bé lala ruwe magéw dob de aguwon mangéy dob de safad. ");
INSERT INTO tiy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Atin ménséfule ro mangéy Jerusalem brab nuret roy ni dob de dumo ro do kuyug. Endob énda ménunur ro bero. ");
INSERT INTO tiy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Atin tidéw béno, méntéfégito man i Jesuse dob de folo bra sébaan gétéw do kuyugén bé lala ruwe mama. Atin nugarén bero sabaf bé kulang i kéunur ruwe, brab sabaf métégas i de uléw ro funa ro énda munur bé kéuret i de énggégito de tidéw bé kétébule ne. ");
INSERT INTO tiy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Atin ménbéréh i Jesuse dob berowe mano, “Angéy gom dob kéluhanay de gonon dob duniyae ni, brab uret gom i Fiyowe Uret dob kéluhanay de étéw. ");
INSERT INTO tiy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Atin i kéluhanay de munur brab mébautis, méfukas ro. Atin i kéluhanay de énda munur, mékukum ro. ");
INSERT INTO tiy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Atin i de munur géféténgténg ro bé de ni do tanda bé barakat guwe: Géféféraréy ro do saitan, usaré roy dawét guwe. Atin gésébéréh ro bé de ségiyo késébéréh énda gétiga ro de. ");
INSERT INTO tiy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Atin amuk géfurut ro do ulé, taloo no géiném ro udenén bisa, énda gésug-sug ro. Atin tégéné roy de uléw i de déméruun brab géféadi-adino ro bero.” ");
INSERT INTO tiy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Atin amun énggilid i Kadnane Jesus bé kébéréh ne dob berowe, féndiyat i Tuluse mangéy dob lawayo brab ménsar fingé dob kuwonoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Atin i de kuyugén ménagéw ro mangéy muret dob kéluhanay de ingéd. Atin i Kadnane ténabanga no bero brab fénggito noy toow i kéuret ruwe bé kéférigo nuwe bero bé de mékégaif galbék.");
INSERT INTO tiy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teofilo, Wénén i médoo séménulat fantag bé kéluhanay ménrigowe fantag bé Jesuse dob kérara geye. ");
INSERT INTO tiy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sénulat roy tintuwe ségiléw bé kéuret i de ménuret de betom fantag bé Jesuse, sani de énggégito de tidéw féganay. ");
INSERT INTO tiy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Atin fiyon i begéne, toow gu féngganad i kéluhanay de ni ménrigo tidéw féganay. Mélaw fatutu so sémulat bé mékéntaye mangéy dob beeme bé urete fantag bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Rigoné kuy ni inok gétiga moy toowe bé ténoroe nén beem. ");
INSERT INTO tiy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Brab i ni sulaté ku beem tafayén tidéw féganay bé Herod i méguléwe séna dob Judea. Bé béno, wén i ségétéwe lagéy féndawét Sakarias, ménamung dob ségéklasiwe fadi féndawét Abias. I Sakariase ni, wén i bawagén féndawét Elisabet. Tidéw so dob katufua Aarone ségétéw fadi. ");
INSERT INTO tiy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Atin i Sakariase brab Elisabete bawagén, métintu ro dob adafay Tuluse. Odoro ro brab tumané roy kéluhanay sugu i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Endob énda i nga ro, non i Elisabete atir, brab do lukés ro nén. ");
INSERT INTO tiy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Amun énggégumah i gaiwe gémalbék i ni ségéklasi fadi féndawét Abias, ménamung soy Sakariase diyo dob lawi i Tuluse beroy de dumo no. ");
INSERT INTO tiy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Atin sénbunuto ro loo bé adat ruwe do fadi ké mémili ro ségétéw dumo ro mangéy témuwég dukah dob lawi i Tuluse. Atin Sakarias i ménfémilie. ");
INSERT INTO tiy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Amun tuwégé Sakariase nén i dukahe dob lawi i Tuluse, i kéluhanay de ménlimud do méngadaf déménasal ro dob liyuwe. ");
INSERT INTO tiy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tidéw béno, i télakiwe tidéw dob Kadnane méntéfégito téménindég fingé dob kuwonoy ahayane féngadafan tuwégon bé dukahe. ");
INSERT INTO tiy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Amun énggito Sakariasey ni, toow fo ménggaif brab ménggilak. ");
INSERT INTO tiy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Endob i télakiwe ménbéréh mano, “Kago mégilak Sakarias. Enggélingooy Tulusey kédasal me. Mélaw i bawag me Elisabet géfégénga ségétéw nga lagéy. Atin fédawétém Juan. ");
INSERT INTO tiy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Atin waléy go méoror brab méoror soy de médoo étéw ké mumah. ");
INSERT INTO tiy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Non waléy moso gérotor dob adafay Tuluse brab énda minémén éntingayén arak mékéolon. Atin énda séna ménfégéngaén, i Rémogor i Tulusey mémanduone de. ");
INSERT INTO tiy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Atin sabaf bé kétoro i nga me, médooy de Judio gésénule brab munur bé Kadnane Tulus ro. ");
INSERT INTO tiy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Beeney géétahe bé Kadnane brab fémanduoy Rémogor i Tuluse brab iraya no barakat rémigo do mékégaif loo bé rénigo Eliase bé do gétah. Brab beeney émféséulite bé de ménsébanil do lukés bé de nga ro. Brab i de étéw énggésala, gésénule ro sabaf bé kétoro ne, brab méginugut ro dob Tuluse, brab waléy ro man métintu. Atin mélaw waléy médooy étéwe géingat ongot-ongot bé kégégumah i Kadnane,” bang i télakiwe ni. ");
INSERT INTO tiy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tidéw béno, ménbéréh i Sakariase mano, “Endob ati kégétiga kuwe de ké toow i ni bénréhém? Non i begéne brab bawag guwe toow geyén fo lukés.” ");
INSERT INTO tiy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Séménumbul i télakiwe mano, “Begéney Gabriele, sugu-suguéy Tuluse démoyun dob adafa nuwe. Sénugu i Tuluse begén inok béréhé ku dob beemey ni fiyo uret. ");
INSERT INTO tiy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Atin béleewe waléy go émow. Enda gébéréh go taman énda métuman i ni bénréh gu, non énda munur go bé de bénréh gu beem, sani kébéréhe métuman dob gaiwe kétayay Tuluse métuman.” ");
INSERT INTO tiy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bé béno, i de étéw dob liyuy lawi i Tuluse, ongot-ongoté roy Sakariase ké mésut, brab ménggaif ro de non ménrugay dob bukag i lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Amun ménsut, énda gésébéréhén bero. Atin énggétiga roy wén i méntéfégito de dob bukag i lawi i Tuluse, non séniniyasa no sa bero bé de kémérén, non émowén. ");
INSERT INTO tiy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Amun énggilidén i galbék Sakariase ni dob lawi i Tuluse, ménule. ");
INSERT INTO tiy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Enda mérugayén tidéw béno, i bawag ne Elisabet ménwaléy obor. Atin ménbati i Elisabete dob bukag i lawie, énda ménsut-sutén bé ménlimowe gétérésang kélungonon. ");
INSERT INTO tiy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Bang Elisabete, “Toow fo mégédaw i Tuluse begén, non géfégéngau. Rénigoy Tulusey ni inok éndaén kémalananu dob de étéw.” ");
INSERT INTO tiy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dob gééném ne gétérésang kélungonon bé kéobor Elisabete, sénugu i Tulusey télakiwe féndawét Gabriel mangéy dob sébaane ingéd dob Galilea féndawét Nasaret. ");
INSERT INTO tiy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wén i nuwitén kébéréh fénsamfayén dob ségétéwe kénogon féndawét Maria. I Mariahe ténlaana nén fébawagén dob ségétéwe lagéy féndawét Jose. Beeney séfu i ségétéwe méntélata datu i de Judio féndawét Dabid. ");
INSERT INTO tiy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ménggégumah i télakiwe dob Mariahe brab ménbéréh mano, “Oror go! I Kadnaney dumo muwe, brab niraya no beem dakél bantugan.” ");
INSERT INTO tiy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Toow fo ménbuku i Mariahe bé bénréh i télakiwe ni, brab fénggitungén ké ati atag i ni bénréhén. ");
INSERT INTO tiy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Atin ménbéréh man i télakiwe mano, “Kago mégilak, Maria. Been i niy dakéle bantugan niray i Tuluse beem. ");
INSERT INTO tiy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Waléy go obor, brab mégénga go ségétéw nga lagéy, atin fédawétém Jesus. ");
INSERT INTO tiy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Waléy mébantug lagéy brab i fédawét i de étéw de Nga i Toowe Gérotor Tulus. Féwaléyéy Kadnane Tulus datu ségiléw bé katufua nuwe Dabid. ");
INSERT INTO tiy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Waléy datu dob de étéw Israel taman sa taman. I kéféguléw ne énda métamano.” ");
INSERT INTO tiy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Atin ménbéréh i Mariahe dob télakiwe mano, “Endob kénogonu séna, énda i bawag gu, non énda séna ménsétifonu bé mawage begén. Ati kéfingé-fingé i ni mérigo?” ");
INSERT INTO tiy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Séménumbul i télakiwe mano, “I Rémogor i Tuluse mangéy dob beeme brab i barakat i Tuluse dob beeme. Been i niy funay mékétéfuwe nga fédawétén Nga i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Fégitungém i Elisabete samungém. Bénréh i de étéw éndaén kun fakayén géfégénga, non toowén fo lukés. Endob fiyon fo ké loo bé nan, mén-énémén gétérésang kélungonon obor. ");
INSERT INTO tiy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Non gérigonoy Tulusey kéluhanay éntingayéne.” ");
INSERT INTO tiy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Atin bang Mariahe, “Begéney sugu-suguéy Tuluse. Mérigo dam i ni kéluhanan loo bé bénréh manan.” Tidéw béno, méntékédan i télakiwe. ");
INSERT INTO tiy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tidéw béno, i Mariahe ménagayas ménagéw ménangéy dob sébaane ingéd dob de tuduk dob de sakuf Juda. ");
INSERT INTO tiy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ménangéy dob lawi Sakariase brab ténukawén i Elisabete. ");
INSERT INTO tiy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Amun i Elisabete énggélingoo noy béréh Mariahe sémégifa, i ngae dob ésur ne énggékédu, atin i Rémogor i Tuluse fénémanduo noy Elisabete. ");
INSERT INTO tiy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Amun toow fo méoror i Elisabete, méntanug i kébéréh ne mano, “Bé kéluhanay de libun, toow fo fénfiyoy Tuluse beem, brab toow so fo féfiyoné noy ngae oboré mo. ");
INSERT INTO tiy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Endob mégaifu non begéne soy fénfiyoy Tuluse, non i idéng i Kadna kuwe nangéyén ténukaw begén ségétéw gérifantad. ");
INSERT INTO tiy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gétiga kuy de ni non amun énggélingoo kuy béréh me sémégifa, i ngae dob ésur guwe ni énggékédu bé kéoror ne. ");
INSERT INTO tiy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Féfiyonéy Kadnane damén beem non nunuro mo métuman i kébéréh ne.” ");
INSERT INTO tiy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tidéw béno, ménbéréh i Mariahe mano, “Dayéwéy rémogor guwey Kadnane, ");
INSERT INTO tiy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","brab toow fo méororu fantag bé Tuluse sani Mémukase begén. ");
INSERT INTO tiy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Non fénggétédémén begén ségétéw térifantad sugu-sugué no. Tidéw béleewe tabaréy de étéw begén fénggédawan. ");
INSERT INTO tiy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Non i barakatane Tulus rénigo noy mékégaife dob begéne. Mékétéfuy dawét ne. ");
INSERT INTO tiy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tidéw féganay taman béleewe, toow fo mégédaw bé de étéw mégadatan de. ");
INSERT INTO tiy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Rénigo noy de mékégaif galbék bé barakat ne. I de étéw téfégérotor, bigodoyéy Tuluse bero inok énda mégulit i de tete bantak ro. ");
INSERT INTO tiy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kédané noy de datu dob de gono ro, brab fégérotoré noy de étéw térifantad. ");
INSERT INTO tiy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I de méskinan fégédét dob Tuluse, fébésoré no bero bé de fiyo. Endob i de kawasa énda fégédétén dob Beene, énda i iray i Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ténabanga no betom do étéwén do Judio, non gétédémo noy fasad ne dob katufua tome Abraham bé mégédaw de brab kéluhanay de séfuén taman sa taman,” bang Mariahe. ");
INSERT INTO tiy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tidéw béno, ménbati i Mariahe dob ro Elisabete téléw gétérésang kélungonon, atin béno na ménule. ");
INSERT INTO tiy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Atin amun énggumahén i gaiwe kéumahan i Elisabete, ménggénga ségétéw nga lagéy. ");
INSERT INTO tiy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I de dumo no ségédét brab do samungén, énggélingoo ro toow fo mégédaw i Tuluse de, atin mélaw kéluhana ro ménoror. ");
INSERT INTO tiy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Atin amun waléwén gétérésangan i ngae ni, ténuma roy adat i de Judio, mélaw ténuli ro. Atin sébéréh-béréh i de étéw bé fédawétén Sakarias, ségiléw bé dawét i boh ne. ");
INSERT INTO tiy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Endob ménbéréh i idéng ne mano, “Békén Sakarias i dawét ne. Fédawété tom Juan.” ");
INSERT INTO tiy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tidéw béno, séménumbul ro maro, “Endob énda i dumo no bé nan dawét.” ");
INSERT INTO tiy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tidéw béno, séniniyasa roy boh ne non énda gégélingoén. Fénénginsaa ro ké ati dawét i ngae kétaya no fédawét de. ");
INSERT INTO tiy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Atin ménongot i Sakariase sulatan brab sénulatén, “I dawét ne Juan.” Tidéw béno ménggaif i de étéw. ");
INSERT INTO tiy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sonom béno, énggébéréh i Sakariase, atin méngganay démayéw bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","I de dumo ro ségédét toow ro fo ménggaif. Brab i urete fantag bé ni ménrigo, ménlégéb dob kéluhanay de ingéd dob de tuduk sakuf i Judeawe. ");
INSERT INTO tiy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Atin i kéluhanay énggégélingoe bé ni uret fégitungé ro brab ménénginsa ro maro, “Ati keeyén i kéwaléyoy ni nga?” Non gétiga ro Kadnan i mémanduone de. ");
INSERT INTO tiy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Atin i boh ne Sakarias fénémanduoy Rémogor i Tuluse, mélaw ménuret bé kébéréh i Tuluse mano, ");
INSERT INTO tiy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayéwé tom i Tuluse Kadna tom do Judio, non énggégumahén inok maun émfésagad bé de étéwén. ");
INSERT INTO tiy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Niraya no betom barakatan Mémukas tidéw dob de séfu i sugu-sugué nuwe Datu Dabid. ");
INSERT INTO tiy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Been i Mémukase bénréh i de sénarigo no muret bé de kébéréhén bé do gétah. ");
INSERT INTO tiy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Réménigo fasadén dob betome bé sugué no dob betomey Mémukase inok témaban tom bé de sébanil betom brab de mérarék betom. ");
INSERT INTO tiy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bé késugu ne de, ténuma noy fasad ne mégédaw bé de katufua tom. Mélaw gétédémo noy fasad ne, ");
INSERT INTO tiy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ténlaa no bé katufua tome Abraham, ");
INSERT INTO tiy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","bé fukasé no betom dob de sébanil betom inok rigoné tom i kétaya nuwe, énda i gilak tom. ");
INSERT INTO tiy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Atin fakay tom méngintulus bé toowe brab fiyowe dob adafa nuwe sénga fuweh taman méuyag tom.” ");
INSERT INTO tiy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tidéw béno, bénréh Sakariase dob nga ne mano, “I beeme nga gu fédawétén go sarigon muret bé kébéréh i Toowe Fo Gérotor Tulus. Métah go bé Kadnane inok tafayé moy aguwo nuwe. ");
INSERT INTO tiy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Embéréh go dob de étéw bé méfukas ro bé kéfésagad i Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Non toow fo mégédaw i Tuluse betom. I kéfukas ne betom ségiléw bé réndaw i térésange dob sébangane. ");
INSERT INTO tiy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Non i kégédaw i Kadnane betom do étéw mégilak méléhu, ségiléw bé kéréndaw i térésange dob délémone, inok fémanduo no betom dob aguwone énda i bukuén de.” Been i bénréh Sakariase. ");
INSERT INTO tiy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Atin i ngae ni ménruk émbagér brab ménwaléy métintu. Atin amun dakélén, ménbati dob sébaane gonon énda i étéw de bati, taman bé gaiwe ménuret dob de étéw Judio. ");
INSERT INTO tiy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dob de gai bé béno, wén i ségétéwe méngguléw dob Roma féndawét Augusto. Méniray sugu dob kéluhanay de étéw félista ro inok iraya ro buwis. ");
INSERT INTO tiy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Been i niy sunguwe kéfélista bé de étéw, atin ménrigoy ni amun Kireniowey méguléwe dob Siria. ");
INSERT INTO tiy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Atin mélaw i kéluhanay étéwe ménule ménangéy dob de karo ingéd, sani de gonoy de katufua ro, inok émfélista ro. ");
INSERT INTO tiy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mélaw i Josehe ménagéw tidéw Nasaret sakuf i dakéle ingéd Galilea, mangéy dob ingéd ne féndawét Betlehem sakuf i dakéle ingéd Judea. I Betleheme ni, been i niy ingéde numahay méntélatae Datu Dabid. Ménangéy diyo i Josehe non beeney séfu Dabide. ");
INSERT INTO tiy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ménangéy diyo bero Mariahe ténlaana no bawagé no moso. Bé béno gai, gédétén kéumahan i Mariahe. ");
INSERT INTO tiy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Amun diyo ron dob Betlehem, ménggégumah i gaiy kékéumaha nuwe. ");
INSERT INTO tiy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Endob éndaén i gono ro dob de lawi kay de kana diyo. Mélaw ménangéy ro dob kayab i de ayam. Atin diyo ménkéumahan i Mariahe bé ngae lagéy sungu ngaén. Atin bénausén bé de safut brab féndiyoén dob amaay de ayam. ");
INSERT INTO tiy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bé no so kélungonon, énda mérayuén tidéw diyo wén i do témalima bé de bili-bili dob de fétabtaban. ");
INSERT INTO tiy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","I télakiwe tidéw dob Kadnane méntéfégito dob berowe. Brab i géfékayae réndaw tidéw dob Kadnane réménéndaw dob berowe. Toow ro fo ménggilak. ");
INSERT INTO tiy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Endob ménbéréh i télakiwe mano, “Kagom mégilak. Wén i fiyowe uret gu funay kéluhanay étéwe méoror. ");
INSERT INTO tiy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Béleewe ni, i Mémukase begom ménumah dob Betlehem. Been i Kristowe Kadnan. ");
INSERT INTO tiy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Gito gom bénaus bé de safut, fén-iro dob amaay de ayam. Been i nan i funa kome gétigan bé uret guwe ni toow.” ");
INSERT INTO tiy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Atin bé béno so, méntékow méntéfégitoy de médoo dumo no télaki brab kémanta ro dayéwé roy Tuluse maro, ");
INSERT INTO tiy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“I kéluhanay de étéw damén démayéw bé Tuluse diyo dob toowe fo gérotor laway. Irayén damén i fiyowe kébati énda i bukuén de, loo bé fasad ne dob de étéw dob duniyae ni mésuwat i Tuluse bero.” ");
INSERT INTO tiy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Amun ménséfule i de télaki mangéy dob lawayo, ménsébéréh-béréh i de témalima bé de bili-bili maro, “Fénggétigay Kadnane betom i fantage bé ménrigowe dob ingéde Betlehem. Magéw tom angéyé tom téngténgén.” ");
INSERT INTO tiy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mélaw ménagayas ro magéw brab énggito roy Mariahe brab Josehe brab énggito roy klohe nga fén-iro dob amaay de ayam. ");
INSERT INTO tiy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Amun énggito ro, bénréh ro dob Mariahe brab Josehey kébéréh i télakiwe fantag bé ni kloh nga. ");
INSERT INTO tiy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Atin nuret i de témalima bé de bili-bili dob de ségiyo étéw gébalaka ro, atin ménggaif i kéluhanay énggégélingoe de. ");
INSERT INTO tiy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Enggétédémo Mariahey kéluhanay ni ménrigo brab sénga tékélid fégitungé no. ");
INSERT INTO tiy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","I de témalima bé de bili-bili ménséfule ro kémanta dayéwé roy Tuluse, non bé de énggito ro brab de énggélingoo ro. Ménrigoy kéluhanane loo bé kébéréh i télakiwe de bero. ");
INSERT INTO tiy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Amun énggégumah i géwaléwe gétérésangan, i ngae ni ténuli, brab niraya ro dawét Jesus, sani dawéte niray i télakiwe de bé énda séna obor i Mariahe de. ");
INSERT INTO tiy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amun énggégumah i gaiwe bé kétuma ruwe bé sugu Moisese fantag bé kéfélinise dob adafay Tuluse amun mégénga, i Josehe brab Mariahe nuwit roy ngae ni dob lawi i Tuluse dob ingéde Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","24","Atin i Mariahe brab Josehe téménulak ro loo bé ménsulate dob Kukumay Tuluse ruwo timan lémugén inok félinis i Mariahe dob adafay Tuluse. I funa ruwe ménuwit bé ngae ni inok odoro roy ménsulate dob Kukumay Tuluse mano, “Fatut iray dob Kadnaney sunguwe nga lagéy.” ");
INSERT INTO tiy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bé béno so, wén i ségétéwe lukés lagéy dob Jerusalem féndawét Simeon. Ségétéw métintu étéw brab toow fo modor bé kukumay Tuluse. Atin sénga tékélid ongot-ongoté noy kéfukase bé de Judio. Brab i Simeone ni sénga tékélid fémanduoy Rémogor i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Fénggétigay Rémogor i Tuluse de bé énda méléhuén taman énda gito noy Kristowe, sani fénasad i Kadnane sugué no Mémukas. ");
INSERT INTO tiy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Fénémanduoy Rémogor i Tulusey Simeone mangéy dob lawi i Tuluse bé kéuwit i de lukés Jesus de inok rigoné roy adate dob Ménsulate Kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tidéw béno, éndot Simeoney Jesuse brab sénfifi no brab ménfésalamat bé Tuluse mano, ");
INSERT INTO tiy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Barakatan Kadnan, ténuma moy fasad me begén, brab fakayén méléhuu. ");
INSERT INTO tiy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Non énggito gun i Mémukase sénuguém, ");
INSERT INTO tiy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","sani ténafay me inok i kéluhanay de étéw gito ro. ");
INSERT INTO tiy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ségétéw maak solo réméndaw dob de étéw békén Judio inok fégétiga no beroy fantag bé Beeme. Brab Been i funay de étéw démayéw so begey do Judio.” ");
INSERT INTO tiy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tidéw béno, ménggaif i de lukés Jesus bé ni kébéréh Simeone fantag bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Atin déménasal i Simeone dob Tuluse inok féfiyoné no bero, brab bénréhén dob Mariahe idéng Jesuse mano, “I ni nga fénémili i Tuluse émféingat bé de étéw dini dob Israel inok i itungay médoowe émfayag. Médooy de étéw mika bé nga me ni moso, brab funa mo tete i fédéw me. Endob mékukum i de énda de munur, brab méfukas i de munur de.” Been i niy bénréh Simeone. ");
INSERT INTO tiy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Atin wén soy ségétéwe libun muret bé kébéréh i Tuluse, féndawét Anah, nga Fanuel tidéw dob katufua ro Asere. Toowén fo lukés brab ménsétifon bé bawag ne fitéw gébélintuwa tidéw fanay ménsébawag ro. ");
INSERT INTO tiy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Endob ménbaléw taman waléw folo bra éfot gébélintuwa i kélukés ne. Brab énda fo méntékéda no dob lawi i Tuluse non fuweh na kélungonon i kéféngadaf ne démasal brab fuwasa. ");
INSERT INTO tiy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Atin amun diyo sénay lukés Jesuse dob lawi i Tuluse, énggégumah i ni lukés libun. Sonom béno, ménfésalamat dob Tuluso, atin nuretén i fantage bé Jesuse bé Beeney ongot-ongoté ruwe tidéw dob Tuluse. Nuretén dob de étéw diyo dob Jerusalem ongot-ongoté ro soy kéfukase bero. ");
INSERT INTO tiy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Atin i Josehe brab Mariahe, amun énggéodoro ron i kéluhanay sénugue dob Kukumay Tuluse, ménule ro mangéy dob Nasaret dob sakuf i Galileawe. ");
INSERT INTO tiy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Atin ménruk i ngae ni, brab ménwaléy émbagér brab toow fo métilédtéd. Atin toow fo mégédaw i Tuluse de. ");
INSERT INTO tiy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sénga bélintuwa i idéng Jesuse brab boh ne mangéy Jerusalem inok mamung ro kanduli féndawét “Témara”. ");
INSERT INTO tiy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Amun folo bra ruwo gébélintuwa i idad Jesuse, ménodor bero, loo bé adat i de Judio. ");
INSERT INTO tiy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Amun gilid i kékanduli ruwe, i de lukés Jesus ménule ro tidéw Jerusalem. Enda gétiga ro de ké méntéféled i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Maro ké ménodor so bé kédoono ruwe ménule. Amun ménségétérésangan ron magéw, sénléd roy Jesuse dob de samung ro brab dob de dumo ro. ");
INSERT INTO tiy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Endob énda énggito ré de. Mélaw dob géruwowe de gai, ménséfule ro mangéy Jerusalem sélédé ro. ");
INSERT INTO tiy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dob gétéléw ne gétérésangan, énggito ro dob lawi i Tuluse. Ménsar beroy de maistéroy de Judio, fégélingoé no bero brab fénginsaa no bero. ");
INSERT INTO tiy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","I kéluhanay de mégélingo de, ménggaif ro bé de fiyo fénginsaé no brab de katabuwan késumbulén. ");
INSERT INTO tiy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Atin i de lukés Jesus ménggaif ro bé kégito ruwe de diyo. I idéng ne ménsébéréh de mano, “Jesus, i boh me brab begéne ménbuku gey fantag bé Beeme. Méntaluwan gey séméléd Beem. Sédék rénigo moy ni?” ");
INSERT INTO tiy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Endob séménumbul i Jesuse mano, “Enda kailanga no sélédé kom Begén. Gétiga kom damén ay niwu dob lawi i Boh guwe.” ");
INSERT INTO tiy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Endob i de lukés Jesus énda énggésobuto roy atag i bénréh Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tidéw béno, ménodor i Jesuse mule bé de lukésén mangéy Nasaret, brab nunuro no bero bé kéluhanay rigoné nuwe ula-ula. Enggétédémoy idéng ney kéluhanay de ni, atin sénga tékélid fégitungé no. ");
INSERT INTO tiy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Amun ménruk i Jesuse, ménwaléy émbagér brab métilédtéd. Atin kéluhanay de étéw méuyot ré de, brab i Tuluse toow fo ménoror de. ");
INSERT INTO tiy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dob géfolo ne bra limo gébélintuwa bé kéféguléw Tiberiowe, atin Ponsio Pilato sénay méguléwe bé Judeawe, brab Herod i méguléwe bé Galileawe, brab i Filipiwe dumo no sétiman idéng i méguléwe bé Itureawe brab Trakanite, brab Lisaniasey méguléwe bé Abiliniawe, ");
INSERT INTO tiy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","atin i de toow do gérotor fadi ro Anas brab Kaifas dob Jerusalem, ménsébéréh i Tuluse bé Juane nga Sakarias. Bé béno gai, ménbati i Juane dob gonone énda i étéw de bati. ");
INSERT INTO tiy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I kéluhanay de ingéd gédét dob wayége Jordan sénugudo no muret mano, “Kailanga kom gésénule bé de sala gom brab fébautis gom. Atin fésagaday Tuluse begom.” ");
INSERT INTO tiy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","I rénigo Juane diyo loo bé sénulat i méntélatae sénarigoy Tuluse muret féndawét Isaias mano, “Wén i ségétéwe mékes dob gonone énda i étéw de bati mano, ‘Tafay gom i aguwoy Kadnane. Fééntang gom i aguwo nuwe. ");
INSERT INTO tiy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tamfurén i kéluhanay de géléna, brab fédatarén i kéluhanay de tuduk brab do buntud fédatarén, brab féntangén i de aguwon bingkug, brab i de kémérih fédosoén. ");
INSERT INTO tiy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Brab i kéluhanay de étéw gégito bé Mémukase tidéw dob Tuluso.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Atin médooy étéwe ménangéy dob Juane inok fébautis ro. Endob i Juane ménbéréh mano, “I begome maak do ulé gom non tete i de rigoné kom. Sedek mangéy gom dini? Enda géféraréy gom tidéw dob kékukum i Tuluse ké fébautis gom saén. ");
INSERT INTO tiy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Buluk toow gomén gésénule bé de sala gom, féténgténg gom i de fiyo ula-ulané kom. Atin kagom fégitungén i Tuluse fukasé no begom dob de sala gom sabaf bé begom i de séfu Abraham. Béréhé ku begom, fakay géféwaléy i Tuluse séfu Abrahame tidéw dob de batéw. ");
INSERT INTO tiy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Béleewe ni, gédétén i kékukum i Tuluse bé de tete étéw. Ségiléw bé falakule méntafayén ménténa dob darir i kayéwe inok i de kayéw énda mégonok ro fiyo, tuwongén atin ibérén dob aféye inok métuwég.” ");
INSERT INTO tiy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Atin i de médoo étéw fénénginsa ro dob beene maro, “Ati fatute rigoné key?” ");
INSERT INTO tiy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Atin séménumbul i Juane mano, “Ati wéne ruwo lafin kégalén, fatut iraya noy éndae de. Brab ati wéne amaé no, fatut témukid de so.” ");
INSERT INTO tiy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Enggégumah soy de kémubra buwis inok fébautis ro. Atin ménbéréh ro maro, “Maistéro, ati fatute rigoné key?” ");
INSERT INTO tiy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Séménumbul i Juane mano, “Amuk kémubra gom, kagom lifulén i de étéw. Yamula édot gom saén i katabuwane.” ");
INSERT INTO tiy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Atin i de sundalo ménénginsa ro so dob beene maro, “I begeye, ati fatute rigoné key?” Atin séménumbul i Juane mano, “Kagomén médot kurta fénagéw dob kéfégése. Taloo no témébo gom bé békéne toow. Kasukudan gomén bé sukay gome.” ");
INSERT INTO tiy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Atin i de médoo étéw amun énggélingoo roy kétoro Juane, kémarang ro brab mégitung ro ké beeney Kristowe ménggumah dob duniyae. ");
INSERT INTO tiy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mélaw i Juane ménbéréh dob bero mano, “I begéne, bautiso ku begom bé wayége, éndob wén nay gégumahe mas na gérotor begén. Fiyon foy ikét i safatos ne, énda métororu de mukoh. Brab bautiso no begom bé Rémogor i Tuluse brab aféy. ");
INSERT INTO tiy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Féganané noy de fiyo étéw bé de tete étéw ségiléw bé ségétéwe métof. I fégéétof ne diyo dob kémér ne inok fégéétofén bé énrek ne brab fégétimuén bé faréye dob kiwot ne. Brab i de ukofén tuwégé no dob aféye énda émfandaén.” ");
INSERT INTO tiy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Brab wén soy médoowe gékélasi kéuret Juane bé de étéw fantag bé Fiyowe Uret. ");
INSERT INTO tiy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Amun médooy de étéw ménbautisén, i Jesuse bénautis Juane so. Amun ménbautis i Jesuse, déménasal, brab i lala ne démasal, ménungka i lawaye. Atin i Rémogor i Tuluse ménlus maak marafati brab méntérimféna dob Jesuse. Atin wén i ménbéréhe tidéw dob lawayo mano, “Beem i Nga guwe. Toow fo kégédawa ku brab késuwata ku.” Atin i Herode datu, dénowoy Juane fantag bé Herodiyase lénamfaén bawag i dumo nuwe sétiman idéng brab fantag bé de médoo na do tete rénigo Herode. Tidéw béno, numana no nay sala ne bé kéféférisu nuwe bé Juane. ");
INSERT INTO tiy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bé kéféganay Jesuse bé galbék ne, téléw folo gébélintuwa i kélukés ne. Brab i de étéw maro ké Jesusey nga Josehe. Been i nga Elihe. ");
INSERT INTO tiy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Been i nga Batate. Been i nga Lebihe. Been i nga Melkihe. Been i nga Janahe. Been i nga Josehe. ");
INSERT INTO tiy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Been i nga Matatiase. Been i nga Amose. Been i nga Nahume. Been i nga Eslihe. Been i nga Nagehe. ");
INSERT INTO tiy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Been i nga Maate. Been i nga Matatiase. Been i nga Semeihe. Been i nga Josehe. Been i nga Judahe. ");
INSERT INTO tiy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Been i nga Joanahe. Been i nga Resahe. Been i nga Sorababele. Been i nga Salatiele. Been i nga Nerihe. ");
INSERT INTO tiy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Been i nga Melkihe. Been i nga Adie. Been i nga Kosame. Been i nga Elmodame. Been i nga Ere. ");
INSERT INTO tiy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Been i nga Josuehe. Been i nga Eliesere. Been i nga Jorime. Been i nga Matate. Been i nga Lebihe. ");
INSERT INTO tiy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Been i nga Simeone. Been i nga Judahe. Been i nga Josehe. Been i nga Jonane. Been i nga Eliakime. ");
INSERT INTO tiy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Been i nga Meleawe. Been i nga Mainane. Been i nga Matatawe. Been i nga Natane. Been i nga Dabide. ");
INSERT INTO tiy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Been i nga Jessehe. Been i nga Obede. Been i nga Boose. Been i nga Salmone. Been i nga Naasone. ");
INSERT INTO tiy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Been i nga Aminadabe. Been i nga Admine. Been i nga Arniwe. Been i nga Esrome. Been i nga Farese. Been i nga Judahe. ");
INSERT INTO tiy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Been i nga Jakobe. Been i nga Isake. Been i nga Abrahame. Been i nga Tarehe. Been i nga Nakore. ");
INSERT INTO tiy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Been i nga Seruge. Been i nga Ragauwe. Been i nga Pelege. Been i nga Hebere. Been i nga Salae. ");
INSERT INTO tiy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Been i nga Kainane. Been i nga Arfakade. Been i nga Seme. Been i nga Noehe. Been i nga Lameke. ");
INSERT INTO tiy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Been i nga Matuseleme. Been i nga Enoke. Been i nga Jarede. Been i nga Mahalaleele. Been i nga Kainane. ");
INSERT INTO tiy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Been i nga Enoke. Been i nga Sete. Been i nga Adame. Been i nga i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Atin i Jesuse fénémanduoy Rémogor i Tuluse, ménule tidéw dob wayége Jordan, brab fénanangguwit i Rémogor i Tuluse mangéy dob de gonon énda i étéw de bati. ");
INSERT INTO tiy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Amun diyoén i Jesuse, ménggégumah i odoroy de saitan féndawét Satanas inok téngkade noy Jesuse rémigo tete. I kérugay i ni éfot folo gétérésangan. Bé do no gai, énda ménama i Jesuse, atin toow fo ménlayaf. ");
INSERT INTO tiy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ménggégumah i Satanase dob Beene brab ménbéréh mano, “Amuk Beemey Nga i Tuluse, féwaléyém amaén i de batéw ni.” ");
INSERT INTO tiy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Endob séménumbul i Jesuse mano, “Wén i Ménsulate Kébéréh i Tuluse mano, ‘Békén amaén saén i funay étéwe méuyag.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tidéw béno, méntékow nuwit Satanasey Jesuse mangéy dob gérotore gonon. Brab fénténgténgén dey kéluhanay de ingéd dob duniyae. ");
INSERT INTO tiy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Atin ménbéréh i Satanase mano, “Buluk lingkuwédo mo begén brab féngadafé mo begén, iray gu beem i kéluhanay ature méguléw bé de ni inok médayéw go. Géiraya ku kuwagib i étéwe fémilié ku magatur bé kéluhanay de ni, non begéney wéne atura no bé de ni béleewe. ");
INSERT INTO tiy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Lingkuwédonu brab féngadafénu, atin kéluhanay de ni gédoté mo.” ");
INSERT INTO tiy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Endob séménumbul i Jesuse mano, “Wén i Ménsulate Kébéréh i Tuluse mano, ‘Lingkuwéd go saén dob adafay Kadnane Tulusém. Been saén i féngadafé muwe.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tidéw béno, nuwit Satanase mangéy dob ingéde Jerusalem, brab nuwitén mangéy dob toowe gérotor bérungoy lawi i Tuluse. Atin ménsébéréh man bé Jesuse mano, “Amuk Beemey Nga i Tuluse, antéfor go. ");
INSERT INTO tiy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Non wén i Ménsulate Kébéréh i Tuluse mano, ‘Suguéy Tulusey de télaki no démiyaga Beem, ");
INSERT INTO tiy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","brab sakémé ro Beem inok énda émfali go bé de batéw dob fantade, fiyon i de sékéyém.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","I Jesuse séménumbul mano, “Endob wén soy Ménsulate Kébéréh i Tulus mano, ‘Kago téngkadén i Kadnane Tulusém rémigo bé kétaya muwe rigonén.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Atin i Satanas ténéngkadén i Jesuse rémigo tete bé médoowe ségiyo-giyo kéténgkadén de. Endob énda génaga né de. Tidéw béno, ténagakén i Jesuse singkow. ");
INSERT INTO tiy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tidéw béno, ménséfule i Jesuse mangéy Galilea, brab i barakat i Rémogor i Tuluse dob Beene. Atin i urete fantag bé Jesuse méraan ménlégéb dob de ingéd diyo. ");
INSERT INTO tiy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Atin téménoro i Jesuse dob de lawi féngadafan kay de Judio brab kéluhanay de étéw dénayéw ro. ");
INSERT INTO tiy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tidéw béno, énggégumah i Jesuse dob Nasaret, sani gono nuwe ménruk. Atin bé gaiwe kétérén, ménahur dob lawie féngadafan loo bé adat ne, atin téménindég inok basané noy Ménsulate Kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Brab wén i niraye de basanén sénulat i Méntélatae sarigoy Tuluse muret féndawét Isaias, brab amun nukabén, énggébasa na noy ménsulate diyo mano, ");
INSERT INTO tiy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“I Rémogor i Tuluse ay ni dob Begéne, non fénémilién Begén inok muret bé Fiyowe Uret dob de méskinan. Sénuguén Begén inok muretu fantag bé kétangéye bé de ménkalabusu, brab émféséfule bé de fiyo kéténgténg i de langafén, brab témabang bé de kéfasangan. ");
INSERT INTO tiy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Atin sénuguén Begén muret fantag bé bélintuwae fégétigay Tulusey kégédaw ne bé de kéilawan.” ");
INSERT INTO tiy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tidéw béno, amun énggilid i kébasa nuwe de, dénili noy ni basanén, atin fénséfuleén dob sugu-suguéne gémalbék dob féngadafane. Atin ménsar i Jesuse inok témoro. Atin ténéngténg i kéluhanay de étéw diyo. ");
INSERT INTO tiy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Atin ménbéréh mano, “Bé ni gai, i ni ménsulat méntuman dob adafa kome.” ");
INSERT INTO tiy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tidéw béno, i kéluhanay de étéw diyo énggédayéwo roy Jesuse, brab ménggaif ro bé kéfiyoy de kébéréhén. Mélaw ménséfénginsa ro maro, “Aw békén bay ni nga Josehe saén?” ");
INSERT INTO tiy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Atin ménbéréh i Jesuse mano, “Béréhé kom sékoy sébaane binuwaya mano, ‘Amuk beemey muwae, uwaém i lowoh me. Non amuk beemey ségétéwe tintu sarigoy Tuluse, rigo moy de mékégaif galbék dini dob kaame ingéd ségiléw bé de rénigo mo kun dob Kafernaum.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Féntaus Jesusey kébéréh ne mano, “I toowe béréhé ku begom, énda i ségétéw sarigoy Tuluse tayakufén dob kaane gonon. ");
INSERT INTO tiy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Endob béréhé ku begom i toowe fantag bé gai Eliase. Enda fénrana i Tuluse de bé téléwe gébélintuwa brab éném gétérésang kélungonon. Atin énggégumah i lénggobé dob de ni gonon. Bé béno gai, médooy de baléw do libun Judio. ");
INSERT INTO tiy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Endob fiyon ségétéw bé no do baléw dumo tom Judio dob Israel, énda fénfégédét i Tulusey Eliase dob berowe. Yamula sénugu i Tuluse mangéy dob ségétéwe libun baléw békén Judio dob sébaane ingéd féndawét Sarepta dob Sidon. ");
INSERT INTO tiy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Loo so bé gai Eliseawe ségétéw so sarigoy Tuluse. Wén i do médoo étéw déméruun fémute bé de dumo tom Judio. Endob énda i ségétéw bero fén-adi-adi saliyu bé ségétéwe étéw békén Judio féndawét Naaman tidéw Siria.” ");
INSERT INTO tiy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Atin i de kéluhanay de étéw diyo dob lawie féngadafan toow ro fo ménkérit bé kégélingo ruwe bé ni bénréh Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mélaw dénédél ro taman dob uruk i tuduke diyo, sani féntindégo ro bé karowe ingéd, inok dérié ro damén dob fingase inok mélawu. ");
INSERT INTO tiy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Endob ménagéw i Jesuse témara dob kérara ruwe atin méntaus magéw ténagakén bero. ");
INSERT INTO tiy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Atin méntaus i Jesuse léménudug mangéy Kafernaum sani sébaane ingéd sakuf i Galileawe. Diyo bé gaiy kétéréne, téménoro dob de étéw dob lawie féngadafan. ");
INSERT INTO tiy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Atin éngkéségiyonan i de étéw bé de kétoroén non énda saén ténoroén i kéfégitung i de ségiyo étéw. Yamula ténoroén i kaane kéfégitung. ");
INSERT INTO tiy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Atin diyo dob lawie féngadafan, wén i étéwe rénahukoy saitane. Brab ménkes toow fo métanug mano, ");
INSERT INTO tiy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Adéhoyoy! Ati amungé muwe begey, Jesus tidéw Nasaret? Ménangéy go ba dini inok binasané mo begey? Enggétiga key ké ati Beeme. Beem i Mékétéfuwe tidéw dob Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Endob génlé Jesusey saitane ni mano, “Kago selekén, brab tékédan go.” Sonom béno, ténuwar i saitaney étéwe ni rénahuko no. Atin méntékédan brab énda ménkaid i étéwe ni. ");
INSERT INTO tiy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Atin éngkéségiyonan ro kéluhanan. Brab ménsébéréh-béréh ro maro, “Ati ni kébéréh? Dob kébéréh ne saén wén i barakatén. Sugué noy saitane tékédan atin modor tékédan.” ");
INSERT INTO tiy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Atin i urete fantag bé Jesuse ménlégéb dob de kéluhanay de ingéd diyo. ");
INSERT INTO tiy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tidéw béno, méntékédan i Jesuse tidéw dob lawie féngadafan brab ménangéy dob lawi Simone, atin diyo i térima Simone libun déméruun toow fo méduf. Atin nongot roy Jesuse bé uwaé no. ");
INSERT INTO tiy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Atin téménindég i Jesuse dob tébing i libune ni, atin féntékéda noy kééduf ne. Sonom béno, ménadi-adiy libune ni. Atin méntek dénuwoto no bero. ");
INSERT INTO tiy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Amun mélédén i térésange, i de médoo do étéw wén i déméruu ro, nuwit ro dob Jesuse inok uwaé no bero. Atin kénuwah Jesuse bero brab ménadi-adi ro kéluhanan. ");
INSERT INTO tiy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Fénféraréyén soy médoowe saitan. Brab ménkes ro maro, “Beemey Nga i Tuluse.” Endob génléén bero inok métanék ro, non énggétiga roy Beeney Kristowe. ");
INSERT INTO tiy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Amun géfuwénén, méntékédan i Jesuse ménangéy dob sébaane gonon énda i étéw de bati. Endob i de étéw sélédé ro brab ménangéy ro dob Beene brab nongot ro ké énda damén tagaké no bero. ");
INSERT INTO tiy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Endob bénréhén bero mano, “I funa kuwe sénugu mangéy dini inok ureté ku dob de dumo ingéd i Fiyowe Uret fantag bé kéféguléw i Tuluse dob de étéwén. Mélaw fatut ureté ku dob de dumo ingéd.” ");
INSERT INTO tiy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Atin i Jesuse ménagéw ménuret dob de féngadafan dob Judea. ");
INSERT INTO tiy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wén i no sébaan fuweh, diyo i Jesuse dob doror i dogote féndawét Genesaret. Ménfégédét i de médoo do étéw sédantélo ro inok mégélingo ro bé kébéréh i Tuluse ureté Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Atin i Jesuse énggito noy ruwowe do awang diyo dob doror i dogote. Brab i de gefe de méntéfor ro non urahé roy de fukét ro. ");
INSERT INTO tiy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Amun i Jesuse ménda dob sébaane bé de awang ni ka Simon, nongotén bé féangéyé no kloh dob ménaléme de. Brab diyo ménsar ménuret bé kébéréh i Tuluse dob de étéw diyo ménribuk dob doror i dogote. ");
INSERT INTO tiy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Amun énggilid témoro i Jesuse, bénréhén bé Simone mano, “Fékérara tom dob ménaléme de brab lawu gom i da fukét goma nan inok gégédot gom do sédo.” ");
INSERT INTO tiy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Endob i Simone séménumbul mano, “Maistéro, méntérasay gey ségékélungonon brab énda foy énggédot gey de. Endob amun bénréhém, lawué key de fukét gey.” ");
INSERT INTO tiy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Amun ménunur ro bé lénawu roy de fukét ro, énggégédot ro toow fo médoo sédo, brab i de fukét ro gédét mékusi. ");
INSERT INTO tiy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tidéw béno, nabit roy de dumo ro dob ségiyowe awang, inok témabang ro médot bé de sédo. Brab amun énggégumah ro, fénéno roy ruwowe timan awang taman gédét ro mééléd. ");
INSERT INTO tiy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Amun énggito Simon Pedrowey ni fénrigo Jesuse ula-ula, ménlingkuwéd dob adafa nuwe brab ménbéréh mano, “Kadnan, kago fégédét begén, non ségétéwu étéw ménsala.” ");
INSERT INTO tiy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","I funa nuwe énggébéréh loo bé ni non toow fo ménggaif i Simone brab de dumo no bé kédooy de sédo énggédot ro. ");
INSERT INTO tiy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Fiyon foy de nga Sebedeo, ro Santiago brab Juan dumo Simone gémalbék, ménggaif ro so. Atin ménbéréh i Jesuse dob Simone mano, “Kago mégilak. Brab éndaén séméléd gom sédo. Tidéw béleewe, fésélédé ku begom étéw inok furay ro so Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Amun féndunggu roy de awang ro, fénled roy kéluhanane, atin ménodor ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wén i no sébaan fuweh dob sébaane ingéd, énggébalaka Jesusey ségétéwe étéw fémuteén. Atin bé kégito nuwe bé Jesuse, méntédunsum dob fantade brab ménfégédaw-gédaw bé Jesuse mano, “Kadnan, buluk méuyot go, géféadi-adino mo begén.” ");
INSERT INTO tiy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Atin i Jesuse béntérén i kémér ne brab kénuwahén, brab ménbéréh mano, “Méuyotu. Adi-adi go!” Sonom béno, ménkédan i fémute ne brab ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Atin bénréh Jesuse bé békén ureté no dob ségiyowe étéw brab sénuguén mano, “Ay go dob fadie inok, féténgténgém i ménadi-adi gon. Tidéw béno, tulak go loo bé ménbéréhe dob Kitabé tidéw dob Moisese inok gétigay kéluhanay de étéw ménadi-adi gon.” ");
INSERT INTO tiy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Endob i urete fantag bé Jesuse ménlégéb mangéy mérayu. Mélaw wén i toow fo médoo étéw ménangéy dob Beene inok mégélingo ro bé uret ne brab féuwa ro bé de déruu ro. ");
INSERT INTO tiy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wén i no do gai, i Jesuse ménangéy dob sébaane gonon énda i étéw de bati inok félébu brab démasal diyo. ");
INSERT INTO tiy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wén i no sébaan fuweh, téménoro i Jesuse. Atin diyo i de odoroy de Judio féndawét Fariseo ménsar beroy de témoro bé kitabe. Tidéw ro dob de sakuf Galilea brab Judea brab tidéw dob ingéde Jerusalem. Atin i barakat i Tuluse méndiyo dob Jesuse inok uwaé noy de déméruun bé de étéw. ");
INSERT INTO tiy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Atin énggumah i de étéw ménuwit bé kimoyéne ténanggung ro. Kétaya ro uwitén mahur inok fédiyoé ro dob téngaanga Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Endob énda i fiyo kéfélawang ro de, non bé médoowe do étéw. Mélaw ménénik ro dob atéf i lawie. Tidéw béno, ténosongo ro féagéwo ro de témuntun mangéy fantad dob kérara i de étéw dob adafa Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Amun énggito Jesusey kéféngintoow ruwe, ménbéréh dob ni étéw kimoyén mano, “Adih, i de salaém ménfésagadén.” ");
INSERT INTO tiy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tidéw béno, i de Fariseo brab de témoro bé kitabé fénggitung ro maro, “Sedek émbéréh mékémurka i ni étéw? Enda i géfésagad bé de sala ké békén i Tuluse saén!” ");
INSERT INTO tiy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Endob i Jesuse gésobuto noy de itunga ro. Mélaw séménumbul mano, “Sedek séfénginsa gom dob de fédéw gom fantag bé kébéréh guwe? ");
INSERT INTO tiy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Toow na fo mélému béréhén, ‘I de salaém ménfésagadén.’ Non énda gito no ké wén i barakat gu de rémigo. Endob toow fo mérégén béréhén, ‘Tindég go brab agéw go.’ Non giton ké wén i barakat gu de rémigo. ");
INSERT INTO tiy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Endob féfégétiga ku begom i fantage bé Nga i Kéilawane, sani Begéne. Wén i barakat gu brab kuwagib gu dob duniyae ni émfésagad bé de sala.” Tidéw béno, bénréhén dob kimoyéne mano, “Béréhé ku beem, tindég go brab agéw go uwitém i iroo muwe mule mangéy dob lawi me.” ");
INSERT INTO tiy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sonom béno, téménindég i kimoyéne ni dob téngaanga ruwe brab ménagéw nuwitén i iroo nuwe brab ménule mangéy dob lawi ne démayéw bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Atin i kéluhanay de étéw diyo, toow ro fo ménkéségiyonan brab ménggilak ro. Atin dénayéw roy Tuluse maro, “Enggégito tom do mékégaif bé ni gai.” ");
INSERT INTO tiy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Amun énggilidén ni de rénigo Jesus, ménagéw brab énggito noy ségétéwe étéw kémubra buwis féndawét Lebi, ménsar dob de kubranan buwis. Brab ménsébéréh i Jesuse de mano, “Odor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tidéw béno, i Lebiwe fénledén i kéluhanane brab téménindég ménodor bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Atin rénigo Lebiwey sébaane dakél karagiya dob lawi ne. Brab diyo i médoowe do étéw kémubra buwis brab médoo na étéw ménsar mama brab miném bero Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Atin i de témoro bé kitabé brab de Fariseo, ménbutég-butég ro brab ménbéréh ro dob de kuyug Jesus maro, “Sedek ménsélawék gom mama bé de kémubra buwis brab de ségiyo tete étéw?” ");
INSERT INTO tiy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Endob séménumbul i Jesuse mano, “I de fiyo kégélowoho no, énda kailanga roy muwae, éndob kailangay de wén déruu no. ");
INSERT INTO tiy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Enda ménangéyu dini inok tabaré kuy de métintu étéw. Yamula ménangéyu dini inok tabaré kuy de wén salaén inok gésénule ro.” ");
INSERT INTO tiy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Atin wén i de ménénginsa dob Jesuse maro, “I de kuyug Juan sénga tékélid démasal ro brab fuwasa. Loo so bé de kuyug i de Fariseo. Endob i de kaam do kuyug mama brab miném ro.” ");
INSERT INTO tiy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Endob i Jesuse sénumbulo no bero mano, “Ufama, i de kana dob uyote énda waléy tete i de fédéw ro taman énda tékédan i témérimawe lagéy. ");
INSERT INTO tiy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Endob gégumah i gaiwe ké édotén nén i témérimawe lagéy dob berowe, brab been nay no fuwasa ro bé do no gai. Ségiléw so bé de kagén kuyug, non amuk diniwu séna, énda fuwasa ro.” ");
INSERT INTO tiy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tidéw béno, nuret Jesusey sébaane binuwaya fantag bé sébidanay mantuwe kétoroén brab tafaye kétoro i de Judio. Ménbéréh mano, “Enda i étéw rémiyas bé mantuwe kégal inok fégétabung bé tafaye kégal. Non amuk rigoné no, mésinggula i mantuwe kégal, brab énda fo médait féséréfaén i mantuwe bé tafaye de. ");
INSERT INTO tiy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Brab énda i étéw mahur bé mantuwe arak dob tafaye ahuron arak rénigo bé kulit ayame, non mébétus i mantuwe arak dob tafaye ahuron brab mébinasa brab méitis i mantuwe arak. ");
INSERT INTO tiy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Endob fatut i mantuwe arak ahurén dob mantuwe kulit fédéngon de. ");
INSERT INTO tiy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Brab énda i étéw buluk géiném bé tafaye arak méuyot bé mantuwe de non mano, ‘I tafaye arak mas na fiyo.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wén i no sébaan fuweh gai kétérén, i Jesuse brab de kuyugén téménara ro dob de médoo do faréy. Atin i de kuyugén méndot ro de brab kénugut ro. Tidéw béno, ménama ro. ");
INSERT INTO tiy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Endob i de Fariseo diyo ménbéréh ro maro, “Sedek rigoné roy ni, non békén fatut rigonén galbék bé gaiwe kétérén?” ");
INSERT INTO tiy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Séménumbul i Jesuse mano, “Aw énda ba énggébasana kom i rénigo Datu Dabide? Wén i no gai toowén fo mélayaf beroy de sundalo no. ");
INSERT INTO tiy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Atin ménahur ro dob lawi i Tuluse brab méndot bé ténulake fan brab namaén, atin niraya no soy de dumo no de. Rénigo noy ni fiyon fo ké dob kitabe, do fadi saén i fakaye mama bé ni fan.” ");
INSERT INTO tiy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Atin féntaus Jesusey kébéréh ne mano, “I Nga i Kéilawane, sani Begéne, wén i kuwagib gu fantag bé ati fakaye bé gaiwe kétérén.” ");
INSERT INTO tiy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bé sébaane man gai kétérén, ménahur i Jesuse dob lawi i de Judio féngadafan inok témoro. Atin diyo soy ségétéwe lagéy ménsadil i kuwonone bé kémér ne. ");
INSERT INTO tiy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Atin i de Fariseo, sani de odoroy de Judio, diyo so beroy de témoro bé de kitab. Atin ténulik roy Jesuse inok gito roy funa ruwe de témbo rémigo énda fakayén dob kitabe. Mélaw ténéngténg ro inok gito ro ké muwa i Jesuse bé gaiwe kétérén. ");
INSERT INTO tiy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Endob i Jesuse, gétuwa noy de itunga ro. Atin ménbéréh dob lagéye ni ménsadil i kémér ne mano, “Ay go dini, tindég go dob adafay kéluhanay de étéw ni.” Mélaw téménindég brab ménagéw mangéy diyo. ");
INSERT INTO tiy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tidéw béno, ménbéréh i Jesuse dob de Fariseo brab dob de maistéro mano, “Ati karang gome de, ati isuwe fakay dob kitabé bé gaiwe kétérén? Rémigo fiyo loo ké tete? Témabang bé étéwe loo ké féléhuén?” ");
INSERT INTO tiy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Atin iling-iling i Jesuse brab ménbéréh dob lagéye ni mano, “Bétérém i kémér me.” Atin bénétérén i kémér ne atin sonom béno ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tidéw béno, toow fo ménkérit i de Fariseo brab de témoro. Atin ménséuret-uret ro bé ati rigoné ruwe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Atin ménagéw i Jesuse bé béno gai ménangéy dob burure inok démasal, atin déménasal diyo dob Tuluse ségékélungonon. ");
INSERT INTO tiy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Amun géfuwénén, ténabarén i de kuyugén, atin ménémili folo bra ruwo féndawét do Apostol, sani de sénugu. ");
INSERT INTO tiy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Fénémilién i Simone (féndawétén so Pedro), brab Andrese dumo no sétiman idéng, brab Santiago, brab Juan, brab Filipi, brab Bartolome, ");
INSERT INTO tiy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","brab Mateo, brab Tomas, brab Santiagowe nga Alfeo, brab Simone ségétéw toow fo gulaané noy ingéd ne, ");
INSERT INTO tiy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","brab Judase nga Santiago, brab Judas Iskariote beeney ménfékéfoe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Atin léménudug i Jesuse beroy de Apostolén, brab téménindég dob sébaane gonon datar. Diyo soy médoowe do étéw do kuyugén brab do étéw tidéw Judea brab Jerusalem brab tidéw dob Tiro brab Sidon gédét dob dogote. ");
INSERT INTO tiy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ménangéy ro diyo inok mégélingo bé kébéréh Jesuse brab féuwa bé de déruu ro. Atin nuwa Jesusey de déméruun brab de rénahukoy saitane, atin ménadi-adi ro. ");
INSERT INTO tiy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Atin i kédoonoy de étéw magafas ro inok gékuwaha ro, non i barakat ne ménsut tidéw dob Beene funay kéluhanane ménfiyo. ");
INSERT INTO tiy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tidéw béno, ténéngténg Jesusey de kuyugén, atin ménbéréh mano, “Méoror gom do méskinan, non féguléwoy Tuluse begom. ");
INSERT INTO tiy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Méoror gom do mélayaf béni, non fébésorén gom moso. Méoror gom do kémérew béni, non gébayat gom moso. ");
INSERT INTO tiy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Méoror gom amuk wén i mérarék begom sabaf bé kéunur gome Begén. Brab méoror gom amuk wén i sémiyaw begom brab bérého ro begom tete fémalanén gom sabaf bé kéunur gome Begén, sani Nga i Kéilawane. ");
INSERT INTO tiy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Féguyaya gom bé béno gai non i baras gome toow fo médoo diyo dob lawayo. Non loo so bé niy rénigoy de katufua tom bé de gétah sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Endob mékégédaw-gédaw gom do kawasa, non énggétéy gomén i de funa kom méguyaya. ");
INSERT INTO tiy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mékégédaw-gédaw gom do bésor béleewe ni, non félayafén gom moso. Brab mékégédaw-gédaw gom do gébayat béleewe, non fébukuén brab fékérewén gom moso. ");
INSERT INTO tiy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mékégédaw-gédaw gom amuk kéluhanay de étéw émbéréh do fiyo fantag bé begome, non loo bé niy kérigoy de katufua tom bé de gétah tugién do ubo-ubo sénarigoy Tuluse muret.” ");
INSERT INTO tiy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Atin féntaus Jesusey kétoro ne mano, “Endob béréhé ku begom, fégédaw gom bé de sébanil begom brab rigo gom i fiyowe dob de mékérit begom. ");
INSERT INTO tiy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Béréh gom i fiyowe dob de mingon begom brab dasala kom i de démufang begom. ");
INSERT INTO tiy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amuk wén i témamfiling bé fiféy me, fédayaém de témamfiling so bé ségébalae de. Brab buluk wén i mafas bé de kégal gom, iray gom soy kamisita gome. ");
INSERT INTO tiy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","I kéluhanay mongote dob begome, iraya kom. Brab i de médot bé de éntingayén kagom, kagom étukén de. ");
INSERT INTO tiy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Brab buluy kétaya kome rigonéy de étéw dob begome, rigo gom so dob berowe. ");
INSERT INTO tiy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Amuk mégédaw gom bé de mégédaw begom saén, énda médait gom médot baras. Non fiyon foy de énda do métintu étéw mégédaw ro so bé de mégédaw bero. ");
INSERT INTO tiy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Brab amuk rémigo gom fiyo dob de rémigo fiyo dob begome saén énda médait gom médot baras. Non fiyon foy de énda métintu do étéw rigoné roy loowe bé nan. ");
INSERT INTO tiy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Atin amuk émféélét gom dob de wén fégébayadén de, énda médait gom médot baras. Non fiyon foy de tete étéw émféutong ro so dob de dumo ro tete étéw inok géséfule so kéluhanan. ");
INSERT INTO tiy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Endob fégédaw gom bé de sébanil begom, brab rigo gom i fiyowe dob berowe. Atin féélét gom brab kagom ongot-ongotén i baliwa nuwe. Atin i baras gome dakél brab waléy gom do nga i Toowe Gérotor Tulus, non ségiléw gom bé Tuluse mégédaw bé de énda gétigan émfésalamat brab de tete étéw. ");
INSERT INTO tiy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Komon fégédaw gom loo bé kégédaw i Boh gome dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kagom kémukum bé de dumo gom, inok i Tuluse énda so kukumé no begom. Atin i de dumo gom ménsala, kagom dusanén bero, inok énda so dusanéy Tuluse begom. Fésagada kom i de dumo gom atin mélaw fésagaday Tuluse begom. ");
INSERT INTO tiy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Iray gom dob de dumo gom étéw, atin irayay Tuluse begom. I kédooy iray gome ségiléw bé kédooy iray i Tuluse begom. Atin toow fo médooy iray i Tuluse taman gaba-gaba.” ");
INSERT INTO tiy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Brab ménbéréh man i Jesuse sébaan binuwaya mano, “Fakay bay langaféne marak bé dumo nuwe so langafén? Békén ba mélawu ro dob kalute? ");
INSERT INTO tiy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","I méganade békén gérotor na bé témoroe de. Endob i ségétéwe étéw amun énggéféganadén fo toow, ségiléwén bé téménoroe de. ");
INSERT INTO tiy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Sedek gito moy klohe sala i dumo muwe, éndob énda gito moy kaame sala toow na fo dakél? ");
INSERT INTO tiy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Atin béréhé mo dob dumo muwe mamo, ‘Adih, téréno moy nan salaém.’ Endob wén i kaame sala toow na fo dakél. Fédayéw-dayéw go, éndob békén go fiyo étéw. Téréno mo na métah i kaame sala toow na fo dakél, inok gétabanga moy dumo muwe témérén bé kaane kloh sala.” ");
INSERT INTO tiy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Féntaus Jesusey kébéréh ne mano, “Enda i fiyo kayéw mégonok bé tetee onok, taloo no tete kayéw mégonok bé fiyowe onok. ");
INSERT INTO tiy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I ségiyo-giyowe kayéw gélolon bé onok ne. Ufama, i sulu-suluwe énda mégonokén bé mangae. Brab i kayéwe suwaran énda mégonokén saging. ");
INSERT INTO tiy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ségiléw so bé étéwe. I métintuwe étéw rémigo fiyo, non tidéw dob fédéw ne fiyo. Atin i tetee étéw rémigo tete, non tidéw dob fédéw ne tete. Non i bae émbéréh bé atiy diyoe dob fédéwe. ");
INSERT INTO tiy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Sedek fédawété kom Begén ‘Kadnan’, éndob énda rigoné kom i de béréhé ku begom? ");
INSERT INTO tiy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Atiy méuyote fégédét Begén brab mégélingo bé béréhé kuwe brab odoro noy de kétoro gu, fégétiga ku begom ké ati kélasi nuwe étéw. ");
INSERT INTO tiy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Beeney ségiléwe bé étéwe réménigo lawi brab féntindégén i liléy ne dob émbagére batéw. Atin énggégumah i dunuke brab énggébéla. Endob énda méntuwongén non féntindég dob rotor i batéwe. ");
INSERT INTO tiy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Endob i étéwe énggégélingo bé de kébéréh gu éndob énda odoro no de, ségiléw bé étéwe émfétindég lawi dob fantade énda i batéw féntindégo no bé de liléyén. Atin énggégumah i dunuke brab énggébéla dob nan lawi. Atin méntuwong brab toow fo ménbinasa.” ");
INSERT INTO tiy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Amun énggilidén i Jesuse témoro bé de étéw, ménagéw mangéy Kafernaum. ");
INSERT INTO tiy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Atin diyo i ségétéwe Romano kafitay de sundalo. Wén i sugu-sugué nuwe déméruun gédétén méléhu. Toow fo mégédaw i kafitane de. ");
INSERT INTO tiy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mélaw amun énggélingoo noy fantage bé Jesuse, séménugu bé de dumo bé de odoroy de Judio mongot bé Jesuse témukaw damén dob lawi ne inok méuwa i sugu-sugué nuwe. ");
INSERT INTO tiy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Amun ménangéy ro dob Jesuse, ménfégédaw-gédaw ro de maro, “I ni étéw médait ké tabanga mo damén. ");
INSERT INTO tiy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Non mégédaw betom do Judio, brab beeney ménférigowe bé lawi geye féngadafan dini.” ");
INSERT INTO tiy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mélaw ménodor i Jesuse bero. Amun éndaén mérayuén dob lawie ni ayo ro, i kafitane ni séménugu bé de dumo no malak bé Jesuse inok méréh de bé éndaén tausén, non énda médait kun i kafitane témanggaf bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Fénbéréh i kafitane mano, “Toow go fo gérotor étéw, atin mélaw énda métororu malak Beem. Toow go fo barakatan, mélaw fiyon fo ké béréhé mo saén, ‘Adi-adi’, gétuwa kuy waléy adi-adiy sugu-sugué kuwe. ");
INSERT INTO tiy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gétuwa kuy ni non wén i mas gérotor sundalo sémugu begén. Brab wén soy do sundalo sugué ku. Atin buluk béréhé ku, ‘Angéy go diyoo’, mangéy diyo. Brab buluk maku, ‘Enggomén’, témingé ro. Brab buluk béréhé ku dob de sugu-sugué ku, ‘Rigo gom i ni’, rigoné ro.” ");
INSERT INTO tiy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Amun énggélingoo Jesusey ni, ménggaif de. Brab séménling dob de étéw furay dob Beene brab ménbéréh mano, “Béréhé ku begom, fiyon fo ké dob de Judio, énda i énggito gu kéféngintoow loo bé ni étéw.” ");
INSERT INTO tiy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tidéw béno, amun ménséfule i de sénugu dob lawi i kafitane, énggito roy sugu-suguéne ni adi-adi nén. ");
INSERT INTO tiy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Enda mérugayén tidéw béno, ménagéw i Jesuse dob ingéde féndawét Nain. Ménodor i de kuyugén brab médoowe do étéw. ");
INSERT INTO tiy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Atin amun ménggumah ro dob béngaway no ingéd, ménggébalaka roy de étéw méntidéw dob no ingéd. Ténanggung roy bangkaye, mangéy ro lémbéng. I bangkaye ni buntung nga lagéy i libune baléw. Wén i médoowe étéw tidéw dob no ingéd ménodor ro may lémbéng bé no kénogo lagéy. ");
INSERT INTO tiy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Atin amun énggitoy Kadnane Jesus i baléwo no, ménuray i éna nuwe de. Atin ménbéréh mano, “Ina, kago kémérew.” ");
INSERT INTO tiy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Atin ménangéy i Jesuse dob niroo nuwe. Tidéw béno, kénuwahén atin méntétudoy i de ménuwit de. Atin ménbéréh i Jesuse mano, “Adih, tek go!” ");
INSERT INTO tiy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sonom béno, méntek i kénogo lagéye brab ménbéréh. Atin niray Jesuse dob idéng ne. ");
INSERT INTO tiy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Toow fo ménggaif i de étéw de diyo atin dénayéw roy Tuluse maro, “Ay niy toowe fo gérotor sarigoy Tuluse muret bé kébéréh ne, ménggumah dob betome. Ménlus i Tuluse mangéy dob begeye inok tabanga no begey do fénémilién.” ");
INSERT INTO tiy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Atin mélaw i urete fantag bé Jesuse ménlégéb dob Judea, brab dob de ségiyo-giyo ingéd géliwét de. ");
INSERT INTO tiy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Brab i de kuyug Juan nuret ro dob beeney kéluhanay ni rénigo Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Atin sénugu Juaney ruwowe bé de kuyugén mangéy ménginsa dob Jesuse maro, “Beeme bay no bénréh Juane gégumah ongot-ongoté key, taloo no fatut ongot-ongot gey na ségiyo?” ");
INSERT INTO tiy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Amun énggumahay de étéw niy Jesuse, fénénginsaa ro maro, “Sénugu Juan Bautistawe begey mangéy ménginsa ké Beeme bay Kristowe bénréh Juane gégumah ongot-ongoté key, taloo no fatut ongot-ongot gey na ségiyo?” ");
INSERT INTO tiy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bé béno so, fén-adi-adi Jesusey de médoo déruunan brab do rénahuko saitan, brab nuwaén soy médoowe do langafén inok gégito ro. ");
INSERT INTO tiy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Atin sénumbulo Jesusey de sénugu Juan mano, “Séfule gom brab uret gom dob Juaney de énggito gom rénigo gu brab de énggélingoo kom. I de langafén énggégito, brab de fikat énggéagéw, brab de bokongén énggégélingo, brab de fémuteén ménadi-adi, brab de ménléhu méntébule. Brab ureté key i Fiyowe Uret dob de méskinan. ");
INSERT INTO tiy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Atin toow fo méoror i étéwe énda ruwo-ruwoy kéféngintoow ne Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Amun ménuleén i de kuyug Juan, ménbéréh i Jesuse dob de médoo étéw fantag bé Juane mano, “Ati nangéy gome ténéngténg dob gonone énda i étéw de bati? Ségétéw maak kéroon faniréy réfuruhe? Békén, non i kéunur Juane énda méfélukén loo bé kéroone. ");
INSERT INTO tiy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aw ménangéy gom diyo inok téméngténg gom ségétéw étéw toow fo fiyoy kégal ne? Békén, non i de étéw kémégal ro fiyo brab do kawasa, énda bati ro dob de gonon énda i étéw de bati. Yamula bati ro dob de toow fo fiyo lawi kay de datu. ");
INSERT INTO tiy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ati nangéy gome ténéngténg? Ségétéw étéw sénarigoy Tuluse muret? Hoo, éndob béréhé ku begom, i Juane békén saén sénarigon muret bé kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","I Juane niy fantage bé ni Ménsulat Kébéréh i Tuluse amun bénréh i Tuluse Begén mano, ‘Sugué kuy sugu-sugué kuwe métah Beem. Been i témafaye bé kégumah me métah Beem.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Atin féntaus Jesusey kébéréh ne mano, “Béréhé ku begom, énda i toow na fo gérotor bé Juane bé kéluhanay de étéw ménumah. Endob bé gaiy kéféguléw i Tuluse bé de étéwén, i kéluhanay de térifantad étéw sakuf i Tuluse, toow ro na fo gérotor bé Juane béleewe ni.” ");
INSERT INTO tiy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Amun énggélingoo roy kébéréh Jesuse, i kéluhanay de étéw fiyon foy de lémiful kémubra do buwis, énggélolo roy aguwoy Tuluse katabuwan. Beroy de bénautiso Juan. ");
INSERT INTO tiy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Endob i de Fariseo brab de témoro bé kitabe, ménika ro rémigo bé kétayay Tuluse. Atin berowey de énda bénautis Juan. ");
INSERT INTO tiy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Atin ménbéréh i Jesuse man mano, “Ati féségiléwo kuwe bé de étéw méuyag béleewe ni? Ati ségiléwo ruwe? ");
INSERT INTO tiy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ségiléw ro bé de nga ménsar dob fadiyane brab mika ro mégérémét. Tabar i de dumo ro bero maro, ‘I begeye ménségagung gey, éndob énda ménsayaw gom. Brab léméninggéng gey linggéng ménléhuon, éndob énda kéménrew gom.’ ");
INSERT INTO tiy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Non ménangéy diniy Juan Bautistawe ménfuwasa brab énda méninémén arak. Brab bénréh gom, ‘Sénaitanan.’ ");
INSERT INTO tiy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Endob i Nga i Kéilawane, sani Begéne, ménangéyu dini, brab mamau atin minému. Brab ménbéréh gom, ‘Ay niy ségétéwe étéw arumén mama brab miném arak, brab wén i dumo no do lémiful kémubra buwis brab do tete étéw.’ ");
INSERT INTO tiy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Endob fégétigay Tulusey métintuwe dob kéluhanay de ngaén.” ");
INSERT INTO tiy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Atin wén i ségétéwe Fariseo, féndawét Simon, séménéngkat bé Jesuse mangéy dob lawi ne mama. Mélaw ménodor i Jesuse ménangéy diyo brab ménsar ro mama. ");
INSERT INTO tiy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Brab wén i ségétéwe tete libun dob no ingéd. Amun énggétiga noy Jesuse ménangéy mama dob no lawi, ménangéy so diyo ménuwit katiya toow fo fiyo, ménféno mamut nor balilaga. ");
INSERT INTO tiy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amun ménfégédét dob Jesuse, téménindég gédét dob de sékéyén kémérew. Atin i de énloén léménuyut dob de sékéy Jesus. Brab ténrafo no bé buk ne brab narékén i de sékéyén. Brab lénulawa no bé mamute nor. ");
INSERT INTO tiy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Amun énggito Simoney ni, ménbéréh dob fédéw ne mano, “Buluk Jesusey ségétéwe sarigoy Tuluse muret bé kébéréh ne, gélolo no damén ké atiy ni libun mémiraw de, ségétéw libun tete.” ");
INSERT INTO tiy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Endob ménbéréh i Jesuse mano, “Simon, wén i béréhé kuwe Beem.” Séménumbul i Simone mano, “Maistéro, béréhém begén.” ");
INSERT INTO tiy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Atin bénréh Jesusey ni binuwaya mano, “Wén i ruwowe étéw énggéutong dob ségétéwe émféélét kurta. I ségétéwe de énggéutong limo ratuh, brab i ségétéwe de limo folo saén. ");
INSERT INTO tiy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Amun énda i fégébayad ro de, fénsagada no bero, inok éndaén kailanga roy mayade. Na fénginsaa ku beem, ati isuwe toow na fo méimu bé étéwe ni ménféutong bero?” ");
INSERT INTO tiy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Séménumbul i Simone mano, “Karangé ku, i toowe de méimu, been i énggéutonge médoo.” Atin bang Jesuse, “Katabuwan i nan sumbulém.” ");
INSERT INTO tiy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tidéw béno, séménling i Jesuse dob libune ni, brab ménbéréh man dob Simone mano, “Enggito moy rénigoy ni libun? Ménahuru dob lawi me, éndob énda méniray go wayég fégéurah gu bé de sékéy gu, loo bé adat tome do Judio fatut rigoné mo damén. Endob i ni libun fénreén i de sékéy gu bé de énloén, brab ténrafo no bé buk ne. ");
INSERT INTO tiy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","I beeme, énda narékém Begén loo bé adat tome témayakuf bé de kana. Endob i ni libun, tidéw fanay kégumah gu, énda téménréno marék bé de sékéy gu. ");
INSERT INTO tiy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Enda so lénulawa moy uléw guwe nor. Endob i ni libun, lénulaw noy sékéy guwe bé mamute nor. ");
INSERT INTO tiy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mélaw béréhé ku beem, giton i dakéle kéimuén non i de médoo do salaén ménfésagadén. Endob i étéwe kloh saén fénsagadan, kloh soy kéimu ne.” ");
INSERT INTO tiy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Atin bénréhén bé libune ni mano, “Di, i kéluhanay de salaém fénsagadanén.” ");
INSERT INTO tiy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Atin i de étéw bero ménama diyo ménsébéréh-béréh i de fédéw ro maro, “Ati keeyén i ni étéw géfésagad do sala?” ");
INSERT INTO tiy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Atin bénréh Jesuse man dob libune ni mano, “I kéféngintoow mey funay Tuluse ménukas beem. Taus go mule, atin kago émbuku.” ");
INSERT INTO tiy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Brab énda ménrugayén tidéw béno, ménangéy i Jesuse dob de ségiyo-giyo ingéd ménuret bé Fiyowe Uret fantag bé kéféguléw i Tuluse bé de étéwén. Brab ménodor i de folo bra ruwo kuyugén. ");
INSERT INTO tiy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ménodor soy de libun fén-adi-adi no rénahukoy de saitan brab do déméruun. Ségétéw beroy Mariahe tidéw Magdala, dob beeney méntékédan i fitéwe timan saitan. ");
INSERT INTO tiy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ménodor soy Juanawe bawag Kusawe sénarigo Datu Herode, brab Susanawe, brab médoo na do dumo libun. I ni do libun, témabang ro miray bé de kailanga ro Jesus. ");
INSERT INTO tiy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wén i no sébaan fuweh, wén i médoowe étéw tidéw dob ségiyo-giyowe ingéd ménangéy ro dob Jesuse mégélingo. Amun médoo ro ménsélimud, nuret Jesusey ni binuwaya mano, ");
INSERT INTO tiy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wén i ségétéwe étéw ménangéy sémabug bé béne ne. Amun sabugé noy béne ne, i de dumo bé béne ne ménbégodoy dob doror i aguwone. Diyo gédaay de étéw taloo no nama i de kloh manok. ");
INSERT INTO tiy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","I de dumoy de béneén ménsawér dob fantade wén i do batéw de. Tidéw béno, amun méganayén témunoh, ménlaay ro non tikar i fantade de. ");
INSERT INTO tiy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","I de dumoy de béneén ménsawér dob fantade wén i do suwar de énda séna témunoh ro. Ménruk mélaw i de suwar séréngan bé de nohok, atin ménléhu i de nohok non lénimfung i de suwar. ");
INSERT INTO tiy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Endob i de dumo bé de béne ménsawér dob fiyowe fantad, brab téménunoh ro brab ménggonok ro médoo taman mératu takéf sénga sébaan béne.” Atin féntaus Jesusey kébéréh ne mano, “Fégitung gom fantag bé ni bénréh gu begom amuk méuyot gom de ké gésobuto kom.” ");
INSERT INTO tiy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tidéw béno, fénénginsaay de kuyugén ké ati atag i nan binuwaya. ");
INSERT INTO tiy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sénumbulo no bero mano, “Dob begome do kuyug gu, Tuluse i émfégétigane de begom fantag bé kéféguléw ne bé de étéwén. Endob i de ni éntingayén ménbunéy, brab énda émfayagén dob ségiyowe. Enggélingoo ro say de ni fén-agéw dob de binuwaya, inok fiyon fo ké téngténgé ro, énda gito ro de. Brab fiyon fo ké gélingoo ro, énda gésobuto ro de. ");
INSERT INTO tiy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ay niy atag i ni binuwaya énggélingoo kom. I atag i ni béne, been i kébéréh i Tuluse. Atin i ségiyo-giyowe klasi fantad ségiléw bé de ségiyo-giyo klasi étéw. ");
INSERT INTO tiy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","I de dumoy de béne ménlawu dob doror i aguwone. I atag i ni, wén i de étéw énggélingoo roy kébéréh i Tuluse, éndob énggégumah i odoroy de saitan brab kénda noy ni kébéréh dob de fédéw ro. Been i nan i funa ruwe énda sémarig ro bé Tuluse. Brab énda mélaw gédoté roy mantuwe umul. ");
INSERT INTO tiy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","I dumoy de béne ménsawér dob fantade, wén i do batéw de. I atag i ni, wén i de étéw énggélingoo roy kébéréh i Tuluse brab ténayakuf ro brab ménoror ro de. Endob énda ménbatién dob fédéw ruwe. Sémarig ro bé Tuluse singkow saén. Endob buluk kérégénan ron, éndaén sémarig ro bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","I dumoy de béne ménsawér ro dob de duwaléy suwar. I atag i ni, wén i de étéw énggélingoo roy kébéréh i Tuluse, éndob sabaf bé de kébuku ro fantag bé de kéuyag ro, brab kéuyot ruwe waléy kawasa, brab de kéuyot ro méguyaya, been i noy funa ruwe énda gérigo ro bé fatute kétayay Tuluse rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Atin i de dumoy de béne ménsawér ro dob fiyowe fantad. I atag i ni, wén i de étéw énggélingoo roy kébéréh i Tuluse, brab toow fo nunuro ro. Féntaus roy késarig ruwe bé Tuluse atin rigoné roy kétayay Tuluse rigoné ro.” ");
INSERT INTO tiy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Atin ménbéréh man i Jesuse mano, “Enda i témumon solo inok bunéyé no dob bukag i kurénge fénléngkéb, taloo no fédiyoé no dob fantad i katriwe. Yamula fédiyoé no dob fégonone de inok atiy mahure gito noy réndaw ne. ");
INSERT INTO tiy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","I kéluhanay bénunéye, giton moso. Brab i kéluhanay dirungéne, gétigan moso. Mélaw atiy éndae gésobuto kom béni, gésobuto kom moso. ");
INSERT INTO tiy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Komon féfiyo gom i kéfégélingo gome. Non i étéwe mégélingo brab munur, méumanan nay kégésobut ne de. Endob i étéwe énda munur, fiyon foy klohe fégitungé no gésobuto no, dotén dob beene.” ");
INSERT INTO tiy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tidéw béno, ménangéy dob Jesusey idéng ne brab de tuwaréyén, éndob énda géfégédét ro non bé médoowe étéw géliwét de. ");
INSERT INTO tiy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Brab wén i ménbéréhe dob Jesuse mano, “I idéng me brab de tuwaréyém diyo ro dob liyuwe. Méuyot ro géségito Beem.” ");
INSERT INTO tiy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Endob séménumbul i Jesuse mano, “Wén i ségiyo idéng gu brab do tuwaréy gu, non bé kéluhanay étéwe mégélingo bé de uret i Tuluse brab munur de, beroy de maak idéng gu brab do tuwaréy gu.” ");
INSERT INTO tiy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sébaane de fuweh, ménda i Jesuse awang beroy de kuyugén atin bénréhén bero mano, “Mifar tom.” Mélaw ménangéy ro dob dogote ni. ");
INSERT INTO tiy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Amun diyo ro dob kérarae, énggéfidong i Jesuse. Atin amun énggéfidong, énggumah i émbagére défuk. Atin ménahuron wayég i awange, brab toow fo ménkakaidan ro. ");
INSERT INTO tiy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tidéw béno, téningé i de kuyugén i Jesuse atin nulég ro maro, “Kadnan, gédét tomén mééléd.” Méntek i Jesuse brab nélénoy défuke atin féntanékén i de bagél. Tidéw béno, ménlingén-ngén. ");
INSERT INTO tiy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Atin ménbéréh i Jesuse dob de kuyugén mano, “Hon i kéféngintoow gome de?” Atin éngkéségiyonan ro brab mégilak ro. Brab ménsébéréh-béréh ro maro, “Ati ni étéw Jesus? Fiyon i défuke brab de bagél géfétéréno no.” ");
INSERT INTO tiy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mélaw méntaus ro mifar démunggu mangéy dob fantade Geraseno, dob difar i Galileawe. ");
INSERT INTO tiy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Amun téménéfad i Jesuse, bénalak i étéwe rénahukoy de saitan tidéw dob sébaane ingéd diyo. I ni étéw énda batién dob lawie, éndob ménrugayén félawas diyo bati dob de takub do lébéng. ");
INSERT INTO tiy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Médoo gule i ni étéw géméndam fiyon fo ké férisunén brab ikétén bé sangkaliey de sékéyén brab de kémérén. Been so ménséfantud brab uwitéy de saitan mangéy dob gonone énda i étéw de. Amun énggito noy Jesuse, ménkes toow fo métanug, brab méntéléngkéb dob téngaanga Jesuse brab ménbéréh toow fo métanug mano, “Jesus, Nga i toowe fo gérotor Tulus, fégédaw-gédawu Beem. Kago fédawéton begén.” Bénréhén i no non féngganaya Jesusey démédéle bé de saitan réménahukon de. ");
INSERT INTO tiy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Fénénginsaa Jesuse mano, “Ati dawét me?” Atin séménumbul mano, “Laksaén i dawét guwe.” Non toow fo médooy de saitan ménahur dob beene. ");
INSERT INTO tiy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tidéw béno, ménfégédaw-gédaw i de saitan bé Jesuse bé békén damén dédélé no bero mangéy dob emfernowe. ");
INSERT INTO tiy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Enda mérayuén dob no gonon, diyo i médoowe do babuy témabtab dob méngulandige. Nongot i de saitan bé Jesuse ké fakay mahur ro dob de babuy. Atin ténungkas Jesuse bero. ");
INSERT INTO tiy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sonom béno, i de saitan ménsut ro dob étéwe brab ménahur ro dob de babuy ni. Atin i kéluhanay de babuy ni, ménraréy ro ménangéy dob fingase brab ménantéfor ro ménangéy dob dogote, atin ménléné ro. ");
INSERT INTO tiy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","I de étéw témalima bé de babuy ni, amun énggito roy ni ménrigo, ménségéta ro brab nuret roy ni dob de dakél ingéd brab dob de ségiyo ingéd géliwét. ");
INSERT INTO tiy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mélaw ménangéy diyo i de étéw inok susiné roy ni ménrigo. Ménfégédét ro dob Jesuse brab énggito roy étéwe bé gétaho félawas sénaitanan, ménsar gédét dob sékéy Jesuse wénén i kégalén, brab métintunén. Atin kéluhana ro mégilak ro de. ");
INSERT INTO tiy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nuret i kéluhanay de énggégito de ké ati kéuwa Jesuse bé étéwe ni gétaho sénaitanan. ");
INSERT INTO tiy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tidéw béno, i kéluhanay de étéw tidéw dob ingéde Geraseno, nongot roy Jesuse tékédan, non toow ro fo mégilak. Mélaw, ménda i Jesuse dob awange, atin méntékédan. ");
INSERT INTO tiy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","I ségétéwe ni étéw ténkédanay de saitan, nongotén bé Jesuse mano, “Modoru Beem.” Endob bénréh Jesuse de mano, ");
INSERT INTO tiy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ule go brab uretém i fiyowe rénigoy Tuluse dob beeme.” Mélaw ménule brab ménsugud-sugud dob kéluhanay gonone dob ni ingéd brab nuretén i kéluhanay rénigo Jesuse dob beene. ");
INSERT INTO tiy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Amun ménséfule i Jesuse mifar, toow fo méoror i de étéw de, non ongot-ongoté ro diyo. ");
INSERT INTO tiy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Brab diyo wén i ségétéwe étéw fédawétén Jairo, ségétéw sarigon dob lawie féngadafan kay de Judio. Méntéléngkéb dob adafa Jesuse bé ongoté noy mangéy i Jesuse dob lawi ne. ");
INSERT INTO tiy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Non i buntunge ngaén libun folo bra ruwo gébélintuwa, gédétén méléhu. Mélaw ménagéw i Jesuse modor de. Amun magéw i Jesuse sénribukoy de médoo étéw. ");
INSERT INTO tiy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Diyo soy ségétéwe libun kéfasangan non foloén bra ruwo gébélintuwa i kéranas i adat ne. Brab méntéy i kurta ne fénggébayadén bé de doktor, éndob énda foy ségétéw géuwa de. ");
INSERT INTO tiy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tidéw béno, ménfégédét dob ségang Jesuse, atin kénuwahén i kégal ne. Sonom béno, téménrén i kéranas i adat ne. ");
INSERT INTO tiy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tidéw béno, ménénginsa i Jesuse mano, “Ati kéménuwahe Begén?” Endob ménggidih i kéluhanane. Atin ménbéréh i Pedrowe mano, “Maistéro, toow fo médooy étéwe géliwét Beem, brab sédantélo ro Beem.” ");
INSERT INTO tiy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Endob ménbéréh man i Jesuse mano, “Wén i kéménuwah Begén, non énggétérédama kuy barakat guwe ménsut tidéw dob Begéne.” ");
INSERT INTO tiy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Amun énggétigay libune ni énggétiga Jesuse, ménfégédét lémukub atin méntéléngkéb dob adafa Jesuse brab dob téngaangay médoowe étéw, brab bénréhén dob Jesuse sedek kénuwahén, brab bé béno so méntékow adi-adi. ");
INSERT INTO tiy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tidéw béno, bénréh Jesuse de mano, “Di, i kéféngintoow mey funa muwe ménadi-adi. Taus go ule, brab kagonén émbuku.” ");
INSERT INTO tiy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Amun béréhé Jesusey ni, énggégumah i sugu-sugué Jairowe. Ménbéréh mano, “Amu, déménigurén i nga me. Endaén kailanga no anggaén i Maistérowa nan.” ");
INSERT INTO tiy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Endob amun énggélingoo Jesusey ni, bénréhén dob Jairowe ni mano, “Kago émbuku. Sarig go saén atin adi-adiy nga me.” ");
INSERT INTO tiy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Amun énggégumah i ro Jesuse dob lawi Jairowe, énda i nuwitén mahur taus saliyu bé Pedrowe, brab Juane, brab Santiagowe, brab de lukés i ngae ni. ");
INSERT INTO tiy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Atin i kéluhanay de étéw ni dob lawie ni kémérew so brab ruungé roy ngae ni. Ménbéréh i Jesuse mano, “Kagom kémérew. Non i ngae ni énda ménléhuén, éndob ménfidong saén.” ");
INSERT INTO tiy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tidéw béno, sénbayat ro saén i Jesuse non gétiga roy ngae ni ménléhuén. ");
INSERT INTO tiy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Endob génamak Jesusey kémér i ngae ni brab ténabarén mano, “Di, tek go!” ");
INSERT INTO tiy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sonom béno, i ngae ni méntébule brab tékow méntek. Atin sénugu Jesuse bero bé iraya ro amaé no. ");
INSERT INTO tiy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Toow fo ménggaif i de lukés i ngae ni. Endob bénréh Jesuse bero bé békén ureté ro dob de étéw i ni ménrigo. ");
INSERT INTO tiy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Fénsélimud Jesusey de folo bra ruwo kuyugén. Atin niraya no bero barakat inok géuwaa roy de déméruun brab géféféraréyo roy de saitan. ");
INSERT INTO tiy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Brab sénugu Jesuse bero muret fantag bé kéféguléw i Tuluse bé de étéwén, brab muwa bé de déméruun. ");
INSERT INTO tiy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Atin bénréhén bero mano, “Kagom muwit éntingayén, fiyon fo ké tugé, taloo no réban, fiyon amaén, brab kurta, taloo no lékasa kom kégal. ");
INSERT INTO tiy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Fiyon atiy lawie témayakuf begom, bati gom diyo taman tagaké kom i nan ingéd. ");
INSERT INTO tiy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Buluk wén no ingéd énda tayakuféy de étéw begom, tékédan gom diyo, brab tag-tag gom i de bubuk sébuwan dob de sékéy gom émfégétigan bé kukuméy Tuluse bero.” ");
INSERT INTO tiy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tidéw béno, ménagéw i de kuyugén ni ménangéy dob de ségiyo-giyo ingéd muret bé Fiyowe Uret, brab muwa ro do déméruun diyo. ");
INSERT INTO tiy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bé béno, i Herode, sani méguléwe dob Galilea, énggélingoo noy de rigoné Jesuse. Toow fo ménggaif brab énda gésobuto no de, non wén i do étéw ménbéréh ro bé Juan Bautistawe méntébule non maro ké Juan i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Brab i de dumo béréhé roy Jesuse Elias méntéfégito. Brab i de dumo béréhé roy Jesusey toowe fo énggétah sénarigoy Tuluse muret méntébule. ");
INSERT INTO tiy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Endob ménbéréh i Herode mano, “Fénkéléng guy uléw Juane. Endob ati ni gélingoo ku fantag bé de ni?” Méuyot de ké gito noy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Amun énggéséfule i de apostol Jesus, bénréh roy de rénigo ro. Tidéw béno, nuwitén bero saén mangéy dob sébaane ingéd féndawét Betsaida. ");
INSERT INTO tiy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Médooy de étéw énggégélingo fantag bé ni brab ménfuray ro bero. Méoror i Jesuse bé kégito nuwe bero, brab nuretén beroy fantage bé kéféguléw i Tuluse bé de étéwén. Fén-adi-adi né soy de déméruun bero. ");
INSERT INTO tiy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Amun sémingkufén, i de folo bra ruwo gétéw kuyug Jesuse ménangéy ro dob Beene brab ménbéréh ro maro, “Enda i batioy de étéw ni dini. Féagéwém bero inok mangéy ro dob de ingéd gédét dini. Diyo gébéléy ro amaé ro brab diyo ro so fidong.” ");
INSERT INTO tiy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Endob ménbéréh i Jesuse dob de kuyugén mano, “Iraya kom bero amaé ro.” Endob séménumbul ro maro, “Enda i amaén dini saliyu bé limowe timan fan brab ruwo timan sédo. Hon i ayo tome de méléy amaén bé ni kédoo étéw?” ");
INSERT INTO tiy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Wén i limo ngibu do lagéy diyo.) Atin bénréh Jesuse bé de kuyugén mano, “Féésar gom i de étéw sélimo folo sénga sélumfuk.” ");
INSERT INTO tiy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Atin nodoroy de kuyugén i bénréh Jesuse bero. ");
INSERT INTO tiy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tidéw béno, éndot Jesusey limowe timan fan brab ruwowe timan sédo, atin léménéngag dob lawayo brab ménfésalamat dob Tuluse. Tidéw béno, sénbaad-baadén i de fan brab de sédo, brab nirayén dob de kuyugén inok saaré ro dob de étéw. ");
INSERT INTO tiy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","I kéluhanay de étéw ménama ro médoo taman ménbésor ro. Tidéw béno, ténimu i de kuyug Jesusey de sama i de amaén brab ménféno i foloe bra ruwo timan dakél biton. ");
INSERT INTO tiy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wén i no, i Jesuse ségétéwén saén démasal ménfélébu. Brab i de kuyugén ménangéy ro dob Beene. Atin fénénginsaa Jesuse bero mano, “Ati kébéréh i de médoo étéw ké ati Begéne ni?” ");
INSERT INTO tiy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Séménumbul ro maro, “Wén i de émbéréh maro, Juan Bautista go kun. I de dumo maro, Elias go kun. Brab i de dumo maro, Beemey énggétahe sénarigoy Tuluse kun méntébule.” ");
INSERT INTO tiy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tidéw béno, ménénginsa i Jesuse man mano, “Dob begome, ati kébéréh gome ‘fantag bé Begéne?’ ” I Pedrowe séménumbul mano, “Beemey Kristowe sénugu i Tuluse inok méguléw go bé de étéw.” ");
INSERT INTO tiy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Atin bénréh Jesuse bero mano, “Kagom béréhén i ni dob ségiyowe.” ");
INSERT INTO tiy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Atin féntaus Jesusey kébéréh ne mano, “I Nga i Kéilawane, sani Begéne, médooy rasayé kuwe. Brab ikaay de odoroy de Judio brab de odoroy de fadi brab de témoro bé kitabe, brab féléhué ro Begén. Endob dob gétéléwo nuwe gétérésangan, tébuleu.” ");
INSERT INTO tiy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Atin ménbéréh man i Jesuse mano, “Buluk atiy méuyote furay Begén, kailangan diguré noy kaane kétayan inok odoro noy kétayay Tuluse. Tidéw béno, kailanga no fédayday bé de kérégénon ségiléw bé Begéne, fiyon fo ké féléhuén dob kruse. ");
INSERT INTO tiy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Non atiy méuyote émféraru bé kéuyag ne, méléhu. Endob i méléhue bé kéfuray ne Begén, gédoté noy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ufama, fiyon fo ké i ségétéwe étéw gédoté noy kéluhanay éntingayéne dob duniyae ni, énda i atagén buluk méléhu atin mangéy dob emfernowe. ");
INSERT INTO tiy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Buluk atiy mémalawe muret fantag bé kéunur ne Begén, brab mémala so fantag bé de kébéréh gu, malané ku so buluk séfuleu moso réméndawu brab réméndaw i Boh guwe brab de télaki no. ");
INSERT INTO tiy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Béréhé ku begom i toowe, wén i do dumo begom énda méléhu ro taman gégito bé kéféguléw i Tuluse bé de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Waléw gétérésangan tidéw bé kébéréh Jesuse bé de ni, nuwitén i Pedrowe, brab Juane, brab Santiagowe, atin ménangéy ro dob rotor i tuduke démasal. ");
INSERT INTO tiy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I lala Jesuse démasal, i falas ne ménfégalin, brab i kégal ne ménwaléy fute réméndaw. ");
INSERT INTO tiy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sonom béno, méntékow méntéfégitoy ruwowe gétéw lagéy ménsébéréh bé Jesuse. I ni do étéw, been i Moisese brab Eliase, sani do méntélataén sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Réméndaw soy de falas ro. Atin sébéréh-béréh ro bé Jesuse fantag bé kéléhu ne dob Jerusalem moso sabaf been i funay Tuluse séménugu de dob duniyae. ");
INSERT INTO tiy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","I Pedrowe brab dumo nuwe énggéfidong. Endob amun énggétékénal ro, énggito roy kéréndaw Jesuse brab de ruwo gétéw dumo no téménindég. ");
INSERT INTO tiy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Amun féganayén tagak i de ruwo gétéw étéw i Jesuse, sénbérého Pedrowe mano, “Maistéro, toow fo fiyo non dob ni tom. Rémigo gey téléw timan dung-dung. Sébaan i kaame de, sébaan i ka Moisese de, brab sébaan i ka Eliase de.” (Enda gétiga noy béréhé nuwe ni.) ");
INSERT INTO tiy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Amun émbéréh sénay Pedrowe, méntékow i rawéne méntégalung dob berowe. Brab ménggilak i de kuyugén ké météléb ro bé rawéne. ");
INSERT INTO tiy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Atin wén i béréhe tidéw dob rawéne ni mano, “Been i niy Nga guwe fénémili gu. Fégélingo gom.” ");
INSERT INTO tiy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Amun téménrén i béréhe ni, énggito roy sébaa Jesuse saén. I de kuyugén méntanék ro fantag bé ni, brab bé béno énda i ségétéw nureto ro bé de énggito ro. ");
INSERT INTO tiy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bé sébaane de fuweh, léménudug ro tidéw dob tuduke, atin bénalak i médoowe étéw i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wén i ségétéwe lagéy dob kérara ruwe téménabar mano, “Maistéro, téngténgém i nga guwe. Been i buntunge nga gu lagéy. Ongoté ku dob Beeme uwaé mo damén. ");
INSERT INTO tiy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wén i no rahukoy saitane, atin tékow gékes. Atin i lowoh ne témingkog brab rémbéw i ba ne. Sénga tékélid gémédam, fédawéto no, brab mérugay na fo tékédanay saitane. ");
INSERT INTO tiy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nongot gu bé de kuyugém ké féféraréyé roy saitane, éndob énda gagané ro de.” ");
INSERT INTO tiy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ménbéréh i Jesuse dob de ménlimud mano, “Enda sémarig gom bé Tuluse, brab toow gom do tete étéw. Lugoténun sétafik begom. Enda gétiga ku ké ati nay kérugay i kétingkél guwe sétafik begom.” Atin bénréh Jesuse dob ni lagéy mano, “Uwitém diniy nga ma nan.” ");
INSERT INTO tiy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Amun fégédét i ngae ni dob Jesuse, rénahukoy saitane man brab méntuwar fulad-fulad. Tidéw béno téméningkog man. Atin fénféraréy Jesusey saitane, brab i ngae ni ménadi-adi. Tidéw béno, fénséfule Jesuse man mangéy dob boh ne. ");
INSERT INTO tiy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ménggaif i kéluhanay de étéw bé barakat i Tuluse. Atin amun kéluhanay de étéw ménggaif ro bé no rénigo Jesuse, ménbéréh dob de kuyugén mano, ");
INSERT INTO tiy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kagom lifotén i béréhé kuwe ni begom. I Nga i Kéilawane, sani Begéne, fékéfo séko bé de étéw sébanil Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Endob bé béno gai, i de kuyugén énda énggésobuto roy béréhé nuwe. Bénunéyén bero inok énda gétiga roy atag ne. Atin mémala ro de ménginsa ké ati atag ne. ");
INSERT INTO tiy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wén i no sébaan fuweh, ménséédél i de kuyugén ké ati isuwe bero toow gérotor. ");
INSERT INTO tiy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Enggésobuto Jesuse ké atiy diyoe dob itunga ruwe. Mélaw éndotén i ségétéwe nga atin féntindégén dob tébing ne. ");
INSERT INTO tiy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Atin bénréhén bero mano, “Fiyon atiy étéwe témayakuf bé ngae loo bé ni sabaf bé kéunur ne Begén, tayakufé no so Begén. Brab atiy témayakufe Begén, tayakufé no soy Tuluse ménféuwit Begén. Non atiy toowe térifantad bé begome, beeney toowe gérotor.” ");
INSERT INTO tiy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tidéw béno, ménbéréh i Juane mano, “Maistéro, énggito gey i ségétéwe étéw démédél do saitan nusarén i dawét me fégéféraréyén. Endob génlé gey non békén dumo tom.” ");
INSERT INTO tiy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bang Jesuse, “Kagom géléén de. Non i békéne sébanil betom, dumo tom.” ");
INSERT INTO tiy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Amun gédétén i Jesuse démiyat dob lawayo, bénabaén fo ménsaréw mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Méntah i Jesuse séménugu bé de kuyugén mangéy dob sébaane ingéd dob sakuf i Samariawe inok tafaya ro gono no diyo. ");
INSERT INTO tiy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Endob i de étéw diyo dob Samaria, énda ténayakuf ro de non gétiga ro ségétéw Judio mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","I Santiagowe brab Juane, amun énggito roy ni, ménbéréh ro maro, “Kadnan, méuyot go de ké mongot gey aféy tidéw dob lawayo inok métuwég ro?” ");
INSERT INTO tiy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Endob séménling i Jesuse atin génléén bero. ");
INSERT INTO tiy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tidéw béno, méntaus ro mangéy dob ségiyowe gonon. ");
INSERT INTO tiy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Amun taus ro nén, i ségétéwe étéw ménsébéréh bé Jesuse mano, “Modoru Beem, fiyon fo ké ati ayo muwe de.” ");
INSERT INTO tiy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Séménumbul i Jesuse mano, “I de kufés, wén i tosong ahuro ro. Brab i de kloh manok, wén i salag ro. Endob i Nga i Kéilawane, sani Begéne, énda i gono ku témérén. Mélaw toow go fo kérégénan amuk modor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Atin bénréhén dob ségiyowe étéw mano, “Furay go Begén.” Endob séménumbul i ni étéw mano, “Kadnan, tungkasém na begén métah mangéy lémbéng bé boh guwe.” ");
INSERT INTO tiy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Séménumbul i Jesuse mano, “Félébéngém bé de étéw énda munur ro Begén i de ménléhu ro. Endob i beeme, agéw go mangéy muret fantag bé kéféguléw i Tuluse bé de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wén man i ségiyowe étéw ménbéréh mano, “Kadnan, modoru Beem. Endob tungkasénu na mangéy mégétaw dob de lukés gu.” ");
INSERT INTO tiy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Séménumbul i Jesuse mano, “Enda i ségétéw étéw démadu atin séméling. Loo so bé de kuyug gu. Buluk séméling ro, énda métoror ro ké féguléwoy Tuluse bero.” ");
INSERT INTO tiy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tidéw béno, ménémili i Jesuse fitéw folo bra ruwo gétéw do lagéy. Atin sénuguén bero séruwo-ruwo métah dob de ingéd ayo no so. ");
INSERT INTO tiy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Atin bénréhén bero mano, “Wén i médoo do étéw méuyot munur bé Fiyowe Uret. Ségiléw ro bé de buka kétéwén. Endob kloh saén i begome do kémétéw. Dasal gom dob Kadnane inok émféuwit médoo na do kémétéw dob kaane ni kétéwén. ");
INSERT INTO tiy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Amuk magéw gom, ingat gom. Non féuwit gu begom maak do bili-bili mangéy dob kérara i de itu talun. ");
INSERT INTO tiy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kagom muwit réban, taloo no talufi, taloo no ségiyo sinilas. Brab kagom mérugay séuret-uret bé atiy étéwe gébalaka kom dob de aguwon. ");
INSERT INTO tiy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Buluk mahur gom dob de lawi, béréh gom féfiyonéy Tulusey de étéw bati dob ni lawi. ");
INSERT INTO tiy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Buluk i de étéw dob no bati fiyo, brab tayakufé ro begom do sénugu gu, féfiyonéy Tuluse bero. Endob buluk énda fiyo ro étéw, brab énda tayakufé ro begom do sénugu gu, énda so féfiyonéy Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bati gom dob no lawi témayakuf begom. Atiy amaéne brab inéméne iray ro begom, tanggaf gom. Non i begome do gémalbék kailanga kom i sukay gome. Brab kagom téfégalin tidéw dob sébaane lawi mangéy dob sébaane de. ");
INSERT INTO tiy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Buluk mahur gom dob sébaane ingéd, brab ténayakuf ro begom, ama gom i éntingayéne iray ro begom. ");
INSERT INTO tiy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Uwa gom i de déméruun dob no ingéd brab béréh gom dob de étéw diyo makom, ‘Endaén mérugayén taman bé gaiwe féguléwoy Tuluse begom.’ ");
INSERT INTO tiy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Endob buluk mangéy gom dob sébaane ingéd brab énda tayakufé ro begom, angéy gom dob de aguwon dob no ingéd brab béréh gom makom, ");
INSERT INTO tiy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Fiyon foy de bubuk sébuwan dob de sékéy gey, tag-tagé key so inok gétuwa kom i kukuméy Tuluse begom non nuret gey dob begomey fantage bé kéféguléw i Tuluse éndob mika gom de.’ ");
INSERT INTO tiy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Atin béréhé ku begom, bé no gai, toow na fo gétimal i kékukum i Tuluse bé de étéw dob no ingéd bé kékukum ne bé de tete étéw dob ingéde Sodom. ");
INSERT INTO tiy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Mékégédaw-gédaw gom do étéw bati dob Korasin, brab begome dob Betsaida. Buluk i de mékégaif rénigo gu dob begome ménrigo so dob de ingéd Tiro brab Sidon, ménrugayén i de étéw diyo mésar ro brab kéménégal ro do saku brab rénigono ro do awéw i de lowoh ro inok fégétuwa ro énggésénule ro bé de sala ro. ");
INSERT INTO tiy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Endob toow na fo gétimal i kékukum i Tuluse begom moso bé kékukum ne bé de étéw dob Tiro brab Sidon. ");
INSERT INTO tiy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Brab i begome do étéw dob Kafernaum, méuyot gom téfégérotor taman dob lawayo. Endob ibérén gom mangéy dob uleone emferno.” ");
INSERT INTO tiy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tidéw béno, bénréh Jesuse dob de kuyugén mano, “Atiy mégélingoe begom, fégélingoé no so Begén. Brab atiy mikae begom, mika so Begén. Brab atiy mikae Begén, mika so bé Ménféuwite Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tidéw béno, i fitéwe folo bra ruwo gétéw ménagéw ro mangéy muret dob de ségiyo-giyo ingéd. Atin ménséfule ro toow fo moror brab ménbéréh ro maro, “Kadnan, fiyon foy de saitan odoro roy de béréhé key buluk labité key i dawét me.” ");
INSERT INTO tiy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Atin bénréh Jesuse bero mano, “Enggito guy Satanase ménlawu tidéw dob lawayo maak kilot. ");
INSERT INTO tiy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Niraya ku begom barakat inok fiyon fo ké gédaa kom i de ulé brab do sifitan, énda i kaid gom de. Brab i kéluhanay barakat Satanase sébanil betom énda i kaid tom de. ");
INSERT INTO tiy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Endob kagom méoror sabaf sa bé i de saitan unuro ro begom. Yamula oror gom sabaf ménsulatén i de dawét gom dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bé béno so, fénoror i Rémogor i Tulusey Jesuse. Déménasal mano, “Abay Kadnay lawayo brab fantade, fésalamata ku Beem non fénggétiga moy ni dob de étéw énda i féngganad ro, éndob bénunéyém dob de métilédtéd brab énggéféganad. Hoo Abay, ménrigoy ni non kaam kétayan brab késuwatan.” ");
INSERT INTO tiy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tidéw béno, ménbéréh man i Jesuse dob de étéw mano, “Sénarig i Abaye Begén i kéluhanane. Enda i gétigan bé atiy Ngae saliyu bé Abaye. Brab énda i gétigan bé atiy Abaye saliyu bé Ngae, brab fiyon atiy kétayay Ngae fégétigan no de.” ");
INSERT INTO tiy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tidéw béno, séménling i Jesuse dob de kuyugén ménsébéréh bero énda i ségiyo dumo ro mano, “Toow fo fénfiyoy Tuluse begom bé énggégito gom. ");
INSERT INTO tiy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Béréhé ku begom, dob gétaho médoo do datu brab do sénarigon muret bé kébéréh i Tuluse ménuyot ké gito roy énggito gome, éndob énda énggito ro de. Brab ménuyot ro mégélingo bé énggélingoo kome, éndob énda énggélingoo ro de.” ");
INSERT INTO tiy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wén i no sébaan fuweh, i ségétéwe témoro bé kitabé ménangéy dob Jesuse. Atin ténukawa no fénénginsaan i Jesus mano, “Maistéro, ati fatute rigoné ku inok gédoté kuy toowe umul magufusa?” ");
INSERT INTO tiy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Séménumbul i Jesuse mano, “Ati énggito muwe dob Ménsulate Kébéréh i Tuluse? Ati kégésobut me de?” ");
INSERT INTO tiy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Séménumbul i ni lagéy mano, “Féimu go bé Kadnane Tulusém bé kéluhanay fédéw me, brab bé kéluhanay kamatu me, brab bé kéluhanay itunga muwe, brab bé kéluhanay bagér me. Brab féimu go bé kéluhanay de dumo mo ringon so bé kéimu me bé kaame lowoh.” ");
INSERT INTO tiy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","I Jesuse ménbéréh mano, “Katabuwan i nan késumbulém. Rigo moy ni inok gédoté moy tintuwe umul.” ");
INSERT INTO tiy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Endob i ni lagéy mika kémalanan. Mélaw ségiyo nén man i fénénginsa ne mano, “Endob ati dumo guwe fatut féimué ku?” ");
INSERT INTO tiy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Atin séménumbul i Jesuse bé ni binuwaya mano, “Wén i no sébaan fuweh, i ségétéwe lagéy bé de Judio ménagéw tidéw Jerusalem léménudug mangéy dob ingéde féndawét Jeriko. Amun diyoén dob de agéwon, ténulis i de tulisan. Lénubag ro, brab éndot roy éntingayéne kaan loo soy kégal ne. Brab ténagak ro gédétén méléhu. ");
INSERT INTO tiy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tidéw béno, ménggumah i ségétéwe fadi bé de Judio. Amun énggito noy ni lagéy, ténaraa no saén, atin méntaus magéw. ");
INSERT INTO tiy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tidéw béno, ménggumah i ségétéwe témabang dob de féngadafan, brab i beene Judio so. Amun énggito noy ni lagéy, fénggédéto no brab ténéngténgén singkow, atin méntaus so magéw. ");
INSERT INTO tiy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tidéw béno, i gétéléwe étéw ménggumah. Endob békén Judioy ni étéw. Beeney étéwe tidéw dob ségiyowe ingéd féndawét Samaria. Amun énggito noy ni lagéy ménfali, ménuray i éna nuwe de. ");
INSERT INTO tiy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Fénggédéto no brab nuwaén i de falién brab bénausén. Atin fénkudaén i ni lagéy dob kuda ne brab nuwitén dob sébaane lawi kay de kana inok diyo fétausé noy kéfagifat ne de. ");
INSERT INTO tiy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dob gétunduge de fuweh, niraya no kurta i gefee bé ni lawi, brab bénréhén de mano, ‘Fagifatém i ni lagéy. Buluk kulang i ni kurta, bayada ku beem ké séfuleu.’ ” Amun énggilid Jesuse nuret i ni binuwaya, fénénginsaa noy ségétéwe ni témoro bé kitabé mano, ");
INSERT INTO tiy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ati karang me de, ati isuwe bé de téléw ni gétéw étéw i tintuwe dumoy ni lagéy ténulis?” ");
INSERT INTO tiy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Séménumbul i ni maistéro mano, “I ségétéwe ménggédaw de.” Atin i Jesuse bénréhén dob ni lagéy mano, “Rigo mo loo bé rénigoy ni étéw ménggédaw.” ");
INSERT INTO tiy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Amun diyo i Jesuse brab de kuyugén dob de aguwo ro, énggégumah ro dob sébaane ingéd. Diyo i ségétéwe libun fédawétén Martah. Atin ténayakufén bero dob lawi ne. ");
INSERT INTO tiy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wén i tuwaréy ne so libun fédawétén Maria. Ménsar gédét dob sékéy Jesuse brab mégélingo bé de toroé no. ");
INSERT INTO tiy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ménbuku i Martahe bé kéluhanay de galbékén témogoh, mélaw ménfégédét dob Jesuse ménbéréh mano, “Kadnan, émbuku go damén non i tuwaréy guwa nan fédayaé no begén gémalbék. Suguém inok tabanga no begén.” ");
INSERT INTO tiy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Séménumbul i Jesuse mano, “Martah, toow fo ménbuku go bé médoowe galbékém. ");
INSERT INTO tiy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Endob sébaan saén i fiyowe kailangan rigonén. Fénémili Mariawey fiyowe de. Brab énda médotén dob beene.” ");
INSERT INTO tiy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wén i no sébaan fuweh, amun énggilid i Jesuse démasal, i ségétéwe bé de kuyugén ménbéréh mano, “Kadnan, i Juan Bautistawe ténoroén i de kuyugén démasal. Toroén gey so démasal.” ");
INSERT INTO tiy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Séménumbul i Jesuse mano, “Amuk démasal gom, dasal gom loo bé ni: ‘Abay, kéluhanay étéwe damén féngadafé ro Beem. Féguléwo mo damén i kéluhanay de étéw. ");
INSERT INTO tiy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Irayan gey amaé key sénga fuweh. ");
INSERT INTO tiy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fésagada mo begey bé de sala gey loo so bé kéfésagada keye bé de énggésala begey. Atin kago fédayaén begey météngkad rémigo sala.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Féntaus Jesusey kébéréh ne mano, “Ufama, i ségétéwe begom wén i dumo no brab ménangéy go diyo bé kérara kélungonone brab ménbéréh go mamo, ‘Adih, fégédawanu. Irayanu téléw timan fan. ");
INSERT INTO tiy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Non wén i kana gu mantu séna ménggumah brab énda i féama gu de.’ ");
INSERT INTO tiy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Atin sémumbul i ni dumo mo mano, ‘Kago anggaén begén. Ménfintuén i de béngawa key, brab fidongén i de nga gey. Enda gééteku brab iray gu beem i nan ongoté mo.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Féntaus Jesusey kébéréh ne mano, “Gétiga ku amuk démayday go mongot, iraya no beem bé ongoté muwe. Békén miray sabaf bé dumo muwe, yamula sabaf bé énda mémala go mongot. ");
INSERT INTO tiy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mélaw béréhé ku begom, ongot gom dob Tuluse, atin irayén begom. Ay gom dob Tuluse amuk wén i kailanga kom, atin tabanga no begom. Dasal gom dob Tuluse atin sumbulo no begom, non buluk wén i mongot dob Tuluse bé éntingayéne, iray i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Buluk wén i fégédét dob Tuluse bé de kailanga no, tabangay Tuluse de. Buluk wén i démasal dob Tuluse, sumbulo no. ");
INSERT INTO tiy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ufama, ségétéw go boh, atin i nga me mongot sédo, énda iraya mo de ulé. ");
INSERT INTO tiy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Taloo no mongot onok manok, énda iraya mo de sifitan. ");
INSERT INTO tiy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Fiyon fo ké tete gom étéw, gétiga kom soy miraye bé éntingayéne fiyo dob de nga gom. Labi nay Tuluse toow fo fiyo, gétiga noy miraye fiyo na begom. Beeney Boh gome dob lawayo, brab irayén i Rémogor ne dob de étéw mongot de.” ");
INSERT INTO tiy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wén i no sébaan fuweh, dénédél Jesusey saitane mow ménahur dob ségétéwe étéw. Amun i saitane ni méntékédan, énggébéréh i étéwe ni rénahuko no. Atin i de ménlimud do étéw ménggaif ro de. ");
INSERT INTO tiy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Endob i de dumo bé de ménlimud ménbéréh ro maro, “Beelsebul, sani Satanase, i odoroy de saitan, i ménirayane de barakat inok tékédan.” ");
INSERT INTO tiy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Brab i de dumo bé de étéw ténukawa roy Jesuse bé kéongot ruwe de bé féténgténgén i fégélolonone de tidéw dob lawayo, inok gétiga ro tidéw dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Endob énggétiga Jesusey de itunga ro, mélaw ménbéréh mano, “Ufama, i ingéde énda séfagayun ro brab sétiboh ro, mébinasa. Taloo no i ségékurénge étéw dob sébaane lawi énda so séfagayun ro brab sékérit ro, waléy mébinasa. ");
INSERT INTO tiy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Buluk i de sugu-sugué Satanas mésébaad énda géséfagayun ro, énda so gétindég i fangangatura nuwe. Bénréh guy ni non béréhé kom i démédélu saitan bé barakat Satanase. ");
INSERT INTO tiy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Atin i fégédédél i de kuyug gom de, énda usaré roy barakat Satanase. Mélaw fégitoy de kuyug gom békén ka Satanas i barakat guwe. ");
INSERT INTO tiy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Endob démédélu saitan bé barakat i Tuluse. Atin mélaw énggiton énggumah dob begomey gaiwe méguléw i Tuluse bé de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tidéw béno, fénggétiga Jesuse bero bé toow na fo barakatan bé Satanase mano, “Ufama, i Satanase ségiléw bé ségétéwe mantay bé lawi ne. Buluk i émbagére étéw bantaya noy lawi ne, brab wén i kulangé no, i de insodén énda i géfénakaw de. ");
INSERT INTO tiy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Endob buluk gégumah i ségiyowe étéw toow na fo émbagér bé gefee lawi, gédoté noy kulangé nuwe sarigoy gefee de. Atin gédoté no soy kéluhanay languntamane dob lawi ne brab baade noy kéluhanay de éndotén. ");
INSERT INTO tiy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“I éndae modor Begén, sébanil Begén. Brab i mikae sétabang Begén, alangé no Begén. ");
INSERT INTO tiy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Buluk i saitane mésut tidéw dob étéwe rénahuko no, sémugud dob tikare gonon séméléd téréno no. Endob buluk énda i gito no téréno no, émbéréh mano, ‘Séfuleu dob étéwe sungu gono ku ténagak gu.’ ");
INSERT INTO tiy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tidéw béno, séfule brab gito noy tafaye ténidéwo no mélinis brab métintu nén. ");
INSERT INTO tiy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tidéw man béno, mésut brab muwit fitéw gétéw mas na tete saitan dumo no mahur dob no étéw. Mélaw i no étéw toow na fo méfasang bé féganaye goho no.” ");
INSERT INTO tiy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Amun bénréh Jesusey ni, i ségétéwe libun tidéw dob de ménsélimud ménbéréh mano, “Toow fo méoror i libune ménggénga Beem brab réméniton Beem.” ");
INSERT INTO tiy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Endob ménbéréh i Jesuse mano, “Toow na fo méoror i de mégélingo bé kébéréh i Tuluse brab odoro ro.” ");
INSERT INTO tiy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amun i de étéw minut ro médoo ménlimud géliwét bé Jesuse, ménbéréh mano, “Toow fo tete i de étéw bé ni gai. Mongot ro do mékégaif inok fégéloloné ro ké Begén i Kristowe, sani fénémili i Tulus méguléw. Endob énda i méiray de bero saliyu bé mékégaife loo bé ménrigowe bé Jonase. ");
INSERT INTO tiy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Loo bé fégélolonone nirayén dob de étéw dob Ninibé amun ménsut i Jonase méuyag tidéw dob sur i dakéle sédo, iraya ku séko fégélolonon i de étéw bé ni gai. ");
INSERT INTO tiy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bé gaiwe kémukum i Tuluse, témbo i baiwe tidéw dob ingéde Séba bé de étéw méuyag béni. Non sénugudén tidéw dob tamanay duniyae mégélingo bé kégétiga Solomone. Endob béleewe ni wén i ségétéwe mas na gétigan bé Solomone ay ni, been i Begéne, éndob énda munur gom Begén. ");
INSERT INTO tiy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Atin bé gaiy kékukum i Tuluse, i de énggétah étéw dob Ninibé témindég ro so témbo bé de étéw méuyag béleewe. Non ménunur ro brab énggésénule ro bé uret Jonase. Endob béleewe wén i mas na gérotor bé Jonase ay ni. ");
INSERT INTO tiy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Enda i ségétéw témumon solo atin fédiyoé no dob énggébunéye taloo no dob fantad i kurénge fénléngkéb. Yamula fédiyoé no dob fégonone de inok atiy gégumahe étéw gito noy réndaw ne. ");
INSERT INTO tiy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","I moto muwe maak solo i lowoh me. Buluk fiyoy moto muwe, maak géfékaya non gégito go. Endob buluk i moto muwe ménsadil, maak délémon non énda gégito go. ");
INSERT INTO tiy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ingat gom mélaw inok i réndawe dob beeme békén waléy délémon. ");
INSERT INTO tiy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mélaw buluk tintu munur go, i lowoh me méféno bé géfékayae, brab énda i délémon de, non maak réméndaw i soloe dob beeme.” ");
INSERT INTO tiy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Amun énggilid i Jesuse émbéréh, i ségétéwe Fariseo sénéngkatén mangéy mama. Mélaw ménodor i Jesuse mangéy dob lawi ne brab ménsar diyo mama. ");
INSERT INTO tiy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Amun énggito noy Jesuse énda méngguseén loo bé adat i de Judio, ménggaif i Fariseowe ni. ");
INSERT INTO tiy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bé béno so, ménbéréh i Jesuse mano, “I de begom do Fariseo, urahé kom i lowoh gome fingé fuweh saén. Endob dob de fédéw gom ménféno bé tetee itungan brab do sala. Ségiléw gom bé de tabu ménlinis fingé fuweh saén, éndob dungisan dob bukag ne. ");
INSERT INTO tiy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Dufang gom do étéw. Békén ba rénigoy Tulusey de fédéw gom loo soy de lowoh gom? ");
INSERT INTO tiy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mélaw iray gom do limus bé éntingayéne kagom atin waléy gom mélinis dob bukage so. ");
INSERT INTO tiy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Endob mékégédaw-gédaw gom do Fariseo non niraya kom i Tuluse fiyon bé géfoloe bé de faninu nohok gom, éndob dénigur gom i métintuwe brab kéimue bé Tuluse. I ni niray gom fatut rigoné kom éndob kagom digurén i sébaane de. ");
INSERT INTO tiy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mékégédaw-gédaw gom do Fariseo non méuyot gom bé fiyowe do saran dob lawie féngadafan. Brab méuyot gom ségifaén fégadatan dob de fadiyan. ");
INSERT INTO tiy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mékégédaw-gédaw gom non i de étéw marok waléy ro fiyo bé kéfuray ruwe begom, éndob been i funa ruwe waléy tete. I begome maak do lébéng énda i tandaén, gédaay de étéw énda gétiga ro de, funa ro géliyén.” ");
INSERT INTO tiy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Atin i ségétéwe bero témoro bé de kukuman ménbéréh mano, “Maistéro, bé kébéréh me bé nan, fénémala mo so begey.” ");
INSERT INTO tiy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Séménumbul i Jesuse mano, “I begome témoro bé kitabe, mékégédaw-gédaw gom, non sugué kom i de étéw bé médoowe. Maak féoboé kom bero do toow fo émbégat, éndob énda témabang gom de. ");
INSERT INTO tiy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mékégédaw-gédaw gom non ségiléw gom bé de katufua kom énda munur ro bé de sénarigoy Tuluse muret. Rémigo gom fiyo do lébéngon kay de fénléhu i de katufua kom. ");
INSERT INTO tiy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mélaw fénggétiga kom i ménagayun gom bé rénigoy de katufua kom non beroy do ménméléhu brab begom i do rémigo do lébéngon. ");
INSERT INTO tiy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Been i funane ménbéréh i Tuluse bé kégétiga nuwe mano, ‘Fén-uwito ku bero do muret fantag Begén, brab i de dumo de fénléhu ro brab i de dumo de fénrasay ro bero.’ ");
INSERT INTO tiy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Been i funa kome mékukum, non ménamung gom bé kéféléhue bé de kéluhanay sénarigoy Tuluse muret tidéw bé kélimbag i duniyae. ");
INSERT INTO tiy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tidéw bé kéléhu Abele taman bé kéléhu Sakariase, fénléhu dob élét i ahayane féngadafan tulakan brab mékétéfuwe sibéy. Hoo, béréhé ku begom i de étéw méuyag béni, mékukum ro sabaf bé de ni. ");
INSERT INTO tiy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mékégédaw-gédaw gom do témoro bé kitabe, non bénunéy gom i toowe dob de méuyot gétigan de. Brab mika gom munur bé toowe, atin anggaé kom i de méuyot munur.” ");
INSERT INTO tiy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Amun énggilid i Jesuse bé kébéréh ne, méntékédan dob no gonon, éndob i de Fariseo brab de témoro bé kitabé nangga ro bé de mékérit kériklamo ro brab médoo éntingayén fénginsaé ro ");
INSERT INTO tiy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tukawa ro téngkadén inok sumbulo no bero bé békéne damén katabuwan. ");
INSERT INTO tiy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Amun i ngibunéne do étéw ménsélimud gésééda ro do sékéy, féngganay Jesusey béréhé nuwe bé de kuyugén sungu mano, “Ingat gom inok énda miring gom bé kéunur i de Fariseo ubo-ubo saén. ");
INSERT INTO tiy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","I kéluhanane rénigoy de étéw maak ténléb, mébukeh séko. Brab i kéluhanane dirungén, émfayag séko. ");
INSERT INTO tiy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Atiy béréhé muwe dob kélungonone, gélingoon so dob fuwehe. Brab atiy ségurawé muwe dob gonone fénintu, been so gélingoon dob médoowe do étéw. ");
INSERT INTO tiy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Béréhé ku begom do dumo gu, kagom mégilak bé géféléhue bé lowoh gome, éndob saliyu bé ni éndaén i gérigono no. ");
INSERT INTO tiy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Béréhé ku begom i ati fatute kégilaka kom. Fégilak gom bé Tuluse non géféléhuo noy lowoh gome brab wén soy barakatén émféangéy begom dob emfernowe. Hoo, béréhé ku begom fégilak gom de.” ");
INSERT INTO tiy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Atin ménbéréh man i Jesuse mano, “Ufama, i de kloh manok toow fo mélémuy kéfébéléye bero dob fadiyane. Endob énda i sébaan de lénifot i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Atin i begome mas gom na balilaga bé de kloh manok. I Tuluse énggétuwa no fiyon firoy i de buk gom dob de uléw gom. Mélaw kagom mégilak. ");
INSERT INTO tiy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Béréhé ku begom, ati murete fantag bé kéunur ne Begén dob de étéw, ureté ku soy fantage bé kéunur ne dob adafay de télakiy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Endob atiy démirunge Begén dob adafay de étéw, dirungé ku so moso dob adafay de télakiy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Atiy émbéréhe tete fantag bé Nga i Kéilawane, sani Begéne, émfésagadan. Endob i émbéréhe tete fantag bé Rémogor i Tuluse énda émfésagada no. ");
INSERT INTO tiy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“I de sébanil Begén, buluk uwité ro begom dob de féngadafan taloo no dob de gémamak kukuman, inok métébo gom sabaf bé kéunur gome Begén, kagom mégilak taloo no émbuku ké ati késumbul gome. ");
INSERT INTO tiy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Non i Rémogor i Tuluse toroé no begom ké atiy fatute béréhé kom.” ");
INSERT INTO tiy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wén i médoowe ménsélimud géliwét bé Jesuse. Ménbéréh i ségétéwe de dob Jesuse mano, “Maistéro, béréhém bé ofo guwe, irayén begén i baad guwe bé de languntaman fénled i boh geye begey bé kéléhu ne.” ");
INSERT INTO tiy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Séménumbul i Jesuse mano, “Enda i atura ku de maad ké ati séfiroy begom.” ");
INSERT INTO tiy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Atin ménbéréh i Jesuse dob de étéw mano, “Kagom arumén! Békén bé kékawasawey funay étéwe fiyoy kéuyag ne.” ");
INSERT INTO tiy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Atin nureto Jesuse bero sébaan binuwaya fantag bé ségétéwe étéw kawasa mano, “Wén i safadén, fiyoy kééruk i de nohok-nohokén. ");
INSERT INTO tiy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I kawasawe étéw ménggitung, ‘Enda i fégono ku bé kéluhanay kéntéw guwe. Ati rigoné kuwe? ");
INSERT INTO tiy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gétuwa ku, ay ni rigoné kuwe. Gébaé kuy kiwot guwe, brab rémigowu bé dakéle de, inok gétimuo kuy de kéntéw gu brab de éntingayén kagén. ");
INSERT INTO tiy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tidéw béno, mégitungu, Ségétéwu bagian. Wén i kagéne bé éntingayéne fiyo kailanga ku bé firoye gébélintuwa. Témérénu. Mamau, minému, brab méguyayau.’ ");
INSERT INTO tiy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Endob i Tuluse bénrého noy ni étéw mano, ‘Dufang go! Bé ni kélungonon, méléhu go. Mélaw békénén kaam i éntingayéne nitongém.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Atin féntama Jesusey ni binuwaya mano, “Ségiléw bé niy aruméne kawasa étéw énda modorén bé kétayay Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Atin bénréh Jesuse dob de kuyugén mano, “Kagom émbuku fantag bé kéuyag gome, bé ati amaé kome, taloo no bé lowoh gome, bé ati kégalé kome. ");
INSERT INTO tiy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wén nay labi mélaga bé amaéne funa kom méuyag, brab wén nay labi mélaga bé kégale kay lowoh gome. ");
INSERT INTO tiy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Fégitung gom i de kloh manok. Enda mohok ro taloo no kémétéw ro, brab énda i kiwot ro. Endob féamaéy Tuluse so bero. Atin mas gom na balilaga bé klohe manok. Mélaw toow na fo féamaé no begom. ");
INSERT INTO tiy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Enda i étéw géfétaah bé kéuyag ne bé kébuku ne, fiyon fo ké ségéuras saén. ");
INSERT INTO tiy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Amun énda gérigono kom i ni kloh éntingayén, sedek émbuku gom bé de ségiyo? ");
INSERT INTO tiy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Fégitung gom i de flores. Méruk ro fiyon fo ké énda gémalbék ro, taloo no rémigo ro do kégal ro. Endob béréhé ku begom, fiyon i Solomone toow fo kawasa datu, énda i kégalén loo bé de fiyo do falasén do flores. ");
INSERT INTO tiy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Endob buluk loo bé nan i kéfékégal i Tuluse bé de kéroon bé singkowe ay nan méuyag, atin bé démoe ibérén inohén, békén ba fékégalé no so begom? Toow fo kloh i kéféginugut gome. ");
INSERT INTO tiy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kagomén démoyun émbuku bé amaé kome brab inémé kome. ");
INSERT INTO tiy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Non i de étéw énda méngintulus ro, been i niy fégitungé ruwe taman émbuku ro. Endob i Abay gome dob lawayo gétiga noy kailanga kome. ");
INSERT INTO tiy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mélaw fédaya gom i Tuluse méguléw begom, atin iraya no begom éntingayén kailanga kom. ");
INSERT INTO tiy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Do kuyug gu, kagom mégilak fiyon fo ké énda médoo gom, non kétayay Abay gome Tulus ké begom soy méguléw beroy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Fébéléy gom i languntama kome, brab iray gom dob de méskinan inok kawasa gom dob lawayo. Non dob lawayo, i de éntingayé kom énda i réménég de, taloo no ménakaw de, brab énda i ifés minasa de. ");
INSERT INTO tiy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Non hon i gonoy tamuk me de, diyo soy itunga muwe brab fédéw me.” ");
INSERT INTO tiy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Atin ménuret man i Jesuse sébaan binuwaya fantag bé késéfule ne mano, “Ingat gom bé késéfule guwe loo bé de sugu-suguén ongot-ongot bé amu ruwe. Iring gom bé de ni sugu-suguén, mingat ro ongot-ongot bé amu ruwe séfule tidéw dob sébaane uyot. Maginsod ro, brab féréndawé roy solo ruwe inok géingat ro. Buluk gégumah, magad saén géungkaa roy béngawane. ");
INSERT INTO tiy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Toow fo moror i de ni sugu-suguén bé kégumah i amu ruwe, non énggéingat ro ongot-ongot bé késéfule ne. Béréhé ku begom, i ni amu kémégal inok kémana brab fésaré noy de sugu-sugué no brab duwoto no bero. ");
INSERT INTO tiy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Toow ro fo moror buluk énggito no bero énggéingat ongot-ongot fiyon fo ké gégumah kérara kélungonon, taloo no ménalém kélungonon. ");
INSERT INTO tiy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Atin fégétédém gom i ni, buluk i gefee bé lawie gétiga noy ati urase gégumah i ménakawe dob lawi ne, ingata no brab énda fédayaé no de ké ahuroy ménakawey lawi ne. ");
INSERT INTO tiy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Brab i begome so, fatut mingat gom non i Nga i Kéilawane gégumah dob gaiwe énda karangé kom de gégumah.” ");
INSERT INTO tiy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ménénginsa i Pedrowe mano, “Kadnan, béréhé moy ni binuwaya dob begeye saén do kuyugém, taloo no kay kéluhanane?” ");
INSERT INTO tiy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Atin i Kadnane séménumbul mano, “Atiy mégérore brab métilédtéde sugu-suguén, been i sénarigoy amu ne méguléw bé kéluhanay galbéke brab iraya noy de dumo no sugu-suguén bé de karo baad bé de amaén bé katabuwane gai. ");
INSERT INTO tiy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Toow fo méoror i nan sugu-suguén ké gitoy amu ne gémalbék bé késéfule ne. ");
INSERT INTO tiy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Béréhé ku begom, i amu i nan sugu-suguén sarigé no dob beeney kéluhanay languntama nuwe. ");
INSERT INTO tiy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Endob mékégédaw-gédaw i ni sugu-suguén buluk mégitung mano, ‘Mérugay nay késéfule i amu guwe.’ Tidéw béno, féganayé no tafésén i de dumo no sugu-suguén do lagéy brab libun, atin mama brab miném taman molon. ");
INSERT INTO tiy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ati keeyén i mérigowe amuk i amu i nan tete sugu-suguén gégumah bé gaiwe békén karangé no, brab énda gétiga no de? I ni amu, amuk gito noy tetee rigoné no, tor-toré noy ni sugu-suguén atin fédiyoé no dob gonone emferno beroy de kéluhanay de énda munur. ");
INSERT INTO tiy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“I ni sugu-suguén gétiga no fo toow i kétayay amu ne rigonén, éndob énda rigoné no de. Mélaw i ni sugu-suguén mékukum moso toow fo gétimal. ");
INSERT INTO tiy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Endob i sugu-suguéne énda gétiga noy kétayay amu ne rigonén, atin réménigo énda fiyo no, mékukum éndob énda toowén gétimal. I sénarigone bé médoowe, médoo soy ongoténe de. Atin i nirayane médoo, médoo soy ongoténe de. ");
INSERT INTO tiy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ménangéyu dini inok muwit maak aféy dob duniyae ni, brab méuyotu de damén ké mérinoén. ");
INSERT INTO tiy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kéfasanganu séko, brab tete i fédéw guwe ni taman gilid mérigoy ni. ");
INSERT INTO tiy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ati karangé kome funa ku ménangéy dini? Inok éndaén i sékérit dob ni duniya? Békén. Ménangéyu dini inok mésébaad i de étéw. ");
INSERT INTO tiy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tidéw béleewe, i de limo gétéw dob ségékurénge, mésébaad ro sabaf bé ati Begéne ni. I téléwe de énda magayun ro bé ruwowe de, taloo no i ruwowe de énda magayun ro bé téléwe de. ");
INSERT INTO tiy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mésébaad ro sabaf bé kéunur ruwe. I bohe brab de ngaén lagéy énda séfagayun ro. Loo so bé idénge brab de ngaén libun, énda séfagayun ro.” ");
INSERT INTO tiy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ménbéréh soy Jesuse dob de médoo étéw mano, “Dob ni gonon, buluk gégito gom bé rawéne dob élédon, magad i kébéréh gome, ‘Rémana séko.’ Atin rémana ba. ");
INSERT INTO tiy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Atin buluk wén i réfuruh tidéw déligdigan, béréhé kom, ‘Méduf sékoy gaiwe ni.’ Atin méduf ba. ");
INSERT INTO tiy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gétiga kom i méréhe bé atag i éntingayéne dob fantade ni brab dob lawayo. Sedek énda gétiga kom i atag i de rigonéy Tuluse bé béleewe? Non mika gom munur. ");
INSERT INTO tiy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Atin sedek énda mégitung gom bé atiy fiyowe rigoné kom inok énda mékukum gom moso? ");
INSERT INTO tiy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Buluk wén i dumo mo sébanil, atin uwité no beem dob de kémukum inok sétiyawan, buluk diyo gom séna dob de agéwon, béréh go fiyo inok séfégayun gom bé énda séna gégumahén dob adafay de kémukum. Non i de kémukum séko irayén beem dob de sundalo, brab i de sundalo férisuné ro séko beem. ");
INSERT INTO tiy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Béréhé ku begom, énda séko géésut go tidéw dob férisunone taman énda gébayada moy kéluhanay késalaa muwe.” ");
INSERT INTO tiy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bé béno so, i médoowe do étéw bénréh ro dob Jesusey fantage bé de étéw tidéw Galilea. Fénféléhu i Datue Pilato bero bé lala ruwe témulak dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Séménumbul i Jesuse mano, “Amun i do no étéw tidéw Galilea fénléhu loo bé no, makom ké toow ro na fo wén i sala ro bé de dumo ro bati dob Galilea, brab been i funa ruwe ménléhu. ");
INSERT INTO tiy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Béréhé ku begom, békén. Endob saliyu ké gésénule gom témagak bé tetee adat gom, méléhu gom so ségiléw bé berowe. ");
INSERT INTO tiy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Atin fantag bé de folo bra waléw ménléhu dob Siloe bé kétuwongoy tambalae bero, makom ké mas na wén i sala ro bé de dumo ro bati dob Jerusalem? ");
INSERT INTO tiy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Béréhé ku begom, békén. Endob saliyu ké gésénule gom témagak bé tetee adat gom, méléhu gom so ségiléw bero.” ");
INSERT INTO tiy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Atin bénréh Jesuse beroy ni binuwaya mano, “Wén i ségétéwe étéw, wén i safadén. Nohokén i sébaane kayéw méama i onok ne. Nangéyén ténéngténg ké wén i onokén, éndob énda i énggito no de. ");
INSERT INTO tiy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tidéw béno, bénréhén dob étéwe témalima bé safad ne ni mano, ‘Bé rugay i téléwe gébélintuwa démoyunu séfule séméléd ké wén i onok i ni kayéw, éndob énda foy énggito gu de. Mélaw tuwongém, non ransiné no saén usarén i ni fantad.’ ");
INSERT INTO tiy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Endob séménumbul i étéwe ni témalima de mano, ‘Fédayaén na bé rugay i ségébélintuwae atin kaluto ku géliwét de. Brab rigono ku abuno funa no bobo. ");
INSERT INTO tiy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Buluk bé sébaano bélintuwa gégumah mégonok, fiyo. Buluk énda, been nay no tuwongén.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wén i no gai kéféngadaf i de Judio, sani gaiwe kétérén. Dob no gai, téménoro i Jesuse dob sébaane lawi féngadafa ro. ");
INSERT INTO tiy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wén i ségétéwe libun diyo békutén non féndéruuy saitane. Been i funa nuwe ménfoloén bra waléw gébélintuwa énda géfééntangén témindég fiyon kloh. ");
INSERT INTO tiy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Amun énggito Jesuse, sénbérého no métanug mano, “Adi-adi gon!” ");
INSERT INTO tiy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Brab nahay Jesusey de kémérén dob libune ni, brab bé béno so énggétindég mééntang. Atin dénayéw i libune niy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Endob i uléwe bé no lawi féngadafan toow fo ménkérit non fén-adi-adi Jesusey ni libun bé gaiwe kétérén. Mélaw ménbéréh i ni lagéy dob de étéw mano, “Wén i ném gétérésangan bé ségéfadiyane gémalbék tom, mélaw ay gom dini féuwa bé ni ném gétérésangan. Endob kagom mangéy dini féuwa bé gaiwe kétérén.” ");
INSERT INTO tiy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Endob ménbéréh i Jesuse mano, “Enda toow gom munur dob Tuluse, ubo-ubo say kéféngintoow gome. Buluk i safi gome taloo noy kuda gome térumén, ukohé kom so dob nikéto kome de brab angéyé kom féinémén fiyon fo ké gai kétérén. ");
INSERT INTO tiy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","I libune ni ségétéw dumo tom Judio non séfu Abraham so, brab féndéruuy saitane foloén bra waléw gébélintuwa. Fatut uwaén fiyon fo ké gai kétérén.” ");
INSERT INTO tiy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","I de étéw diyo énda ménuyot ro bé Jesuse, ménmala ro bé kébéréh ne. Endob i de dumo de, toow ro fo méoror non bé kéluhanay de mékégaif rénigo Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Atin ménbéréh i Jesuse mano, “Ati ségiléwoy kéféguléw i Tuluse bé de étéwén? Ati fégiringo kuwe de? ");
INSERT INTO tiy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ségiléw na bé toowe fo kloh béne, éndot i étéwe brab nohokén. Atin téménunoh brab méruk taman ménwaléy dakél kayéw. Brab salagay de kloh manok i de fongo no.” ");
INSERT INTO tiy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tidéw béno, ménbéréh man i Jesuse mano, “Ati fégiringo kuwe bé kéféguléw i Tuluse bé de étéwén? ");
INSERT INTO tiy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ségiléw bé fégéfééruke fan éndot i libune brab sénlawékén bé téléwe géasad bé arinahe taman ménruk i kéluhanane brab ménwaléy médoo.” ");
INSERT INTO tiy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Atin amun ménagéw i Jesuse mangéy Jerusalem, ménawét dob de ségiyo-giyo do ingéd brab téménoro diyo. ");
INSERT INTO tiy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Atin wén i ségétéwe étéw ménénginsaan de mano, “Kadnan, kloh saén i de étéw fukaséy Tuluse?” Séménumbul i Jesuse manó, ");
INSERT INTO tiy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Rigo moy tamay gagané muwe mahur bé mérate béngawan mangéy dob lawayo, non béréhé ku beem, médoo do étéw i témélamawe mahur, éndob énda gagané ro de. ");
INSERT INTO tiy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Non i gefee de témindég brab fintué noy béngawane. Atin amuk diyo gom dob liyuwe, témuktuk gom, fégédaw-gédaw émbéréh makom, ‘Kadnan, ungkaém i fintue ni inok géahur gey.’ Endob sémumbul mano, ‘Enda gélolo gu begom. Brab énda gétiga kuy tidéwo kome de.’ ");
INSERT INTO tiy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tidéw béno, émbéréh gom makom, ‘Ménama gey brab méniném gey sétifon Beem. Brab téménoro go dob de ingéd gey.’ ");
INSERT INTO tiy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Atin sémumbul mano, ‘Enda gélolo gu begom. Brab énda gétiga kuy tidéwo kome de. Begom i de démoyun rémigo tete. Férayu gom Begén.’ ");
INSERT INTO tiy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Atin i begome moso kémérew gom brab kémigét i de kifé kom buluk gito gom i katufua kome Abraham brab Isake, brab Jakobe, brab i kéluhanay sénarigoy Tuluse muret diyo ron dob lawayo. Endob i begome énda géahur gom diyo. ");
INSERT INTO tiy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wén soy de médoo étéw békén Judio tidéw déligdigan, sébangan, tégénon, brab élédon, diyo ro géésar mama beroy Tuluse ké féguléwo no bero. ");
INSERT INTO tiy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Atin bé béno, i de énggétah béni waléy ro moso do géfuray. Brab i de énggéfuray béni waléy ro moso géétah.” ");
INSERT INTO tiy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bé béno so, i de dumo Fariseo bénréh ro dob Jesuse maro, “Tagakém i ni gonon brab angéy go dob ségiyowe gonon non méuyot i Datue Herod méméléhu Beem.” ");
INSERT INTO tiy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Endob séménumbul i Jesuse mano, “Agéw gom brab béréh gom bé Herode mégakar étéw, fétausé kuy kéféféraréy guwe bé de saitan brab kéuwa guwe bé de étéw béleewe ni brab démo. Atin dob gétéléwo nuwe gai, géfégilido kuy galbék guwe dini. ");
INSERT INTO tiy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Endob i Begéne kailangan tausu béleewe brab démo brab dob téléwe. Non i toowe, énda i sénarigoy Tuluse muret bé de kébéréhén féléhuén saliyu dob Jerusalem.” ");
INSERT INTO tiy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tidéw béno, ménbéréh i Jesuse fantag bé adat i de étéw dob Jerusalem mano, “Do étéw dob Jerusalem, tete i fédéw guwe fantag bé begome non fénléhu gom i de sénarigoy Tuluse muret brab nibéro kom batéw i de sénugu dob begome taman ménléhu ro. Firoy gule i kétaya kuwe témimu begom loo bé kétimu i méritone manok télikub-kubo noy de fiyakén bé de fafakén? Endob ménika gom de. ");
INSERT INTO tiy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","I lawi gome métagak moso. Endaén gito mo Begén taman bé gaiwe gégumah ké béréhé mo moso, ‘Féfiyonéy Tuluse damén i gégumahe tidéw dob Kadnane.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wén i no sébaan fuweh gai kétérén, ménangéy i Jesuse mama dob lawi i ségétéwe odoroy de Fariseo. Atin i de sébanil bé Jesuse ténulik ro inok gito roy funa ruwe de témébo. ");
INSERT INTO tiy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Diyo soy ségétéwe rémambuk. Atin ménfégédét dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Atin fénénginsaa Jesusey de Fariseo brab de témoro bé kitabé mano, “Fakay ba dob kitab tomey muwae bé gaiwe kétérén?” ");
INSERT INTO tiy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Endob ménantés ro. Mélaw génamak Jesusey étéwe déméruun atin nuwaén brab ménadi-adi. Tidéw béno, fénagéwén. ");
INSERT INTO tiy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Atin fénénginsaa Jesusey de étéw témulik mano, “Buluk wén i nga gom taloo no safi gom ménlawu dob kalute ménalém wén i wayég de bé gaiwe kétérén, békén ba fagayasé kom bégéngén mésut dob kalute fiyon fo ké gai kétérén?” ");
INSERT INTO tiy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Endob ménantés ro non énda i éntingayén késumbul ro de. ");
INSERT INTO tiy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Atin wén i de étéw sénéngkat ro mama diyo ménuyot ro mésar dob de fiyo saran kay de gérotor étéw. Amun énggito Jesusey ni, nuretén beroy ni binuwaya mano, ");
INSERT INTO tiy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Amuk wén i séméngkat begom déméngan bé sébaane uyot, kagom mésar dob de fiyo saran, non amuk wén i do étéw toow na fo gérotor sénéngkat, karoy de fiyo saran. ");
INSERT INTO tiy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tidéw béno, i séménéngkate begom fégédét inok kédané no begom dob de sara kom brab fégaliné no begom mangéy dob mase na gérifantad gonon. Atin been i funa kome mémala. ");
INSERT INTO tiy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yamula, buluk sénéngkat gom, angéy gom sar dob de gérifantad saran inok i séménéngkate mangéy fégédét dob begome brab émbéréh mano, ‘Do adih, énggomén, diyo gom dob de fiyo ni saran.’ I ni géiray begom fiyo kéfégadat dob téngaangay de médoo étéw. ");
INSERT INTO tiy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Non i kéluhanay de étéw félangka-langka waléy ro gérifantad. Brab i kéluhanay de étéw térifantad waléy ro gérotor.” ");
INSERT INTO tiy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tidéw béno, ménbéréh i Jesuse dob gefee ni karagiya mano, “Buluk rémigo go karagiya, kago séngkatén say de gélolo mo, do dumo mo, brab do samungém, brab do étéw kawasa dumo mo ségédét. Buluk rigoné moy ni, sémuli ro so séméngkat beem inok gésulio ro beem. ");
INSERT INTO tiy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yamula, amuk rémigo go karagiya, séngkatém i de méskinan, de fikat, de kimoyén, brab do langafén. ");
INSERT INTO tiy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mélaw féfiyonéy Tuluse beem fiyon fo ké énda gésulio ro beem. Sulioy Tuluse beem bé gaiwe kétébule i de métintu étéw.” ");
INSERT INTO tiy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","I ségétéwe bé de ménsar mama, ménbéréh mano, “Toow fo méoror i de étéw mama beroy Tuluse dob kéféguléw ne.” ");
INSERT INTO tiy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Amun énggélingoo Jesusey ni, nuretén i sébaane binuwaya mano, “Wén i ségétéwe étéw lagéy réménigo dakél karagiya brab séménéngkat médoo étéw. ");
INSERT INTO tiy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Amun énggégumah i gaiy ni karagiya, i ni étéw sénuguén i sugu-sugué nuwe mangéy méréh dob de étéw sénéngkat ro, ‘Méntafayén i kéluhanane. Enggomén, angéy gomén dob karagiyae ni.’ ");
INSERT INTO tiy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Endob énda ménangéy ro diyo. Yamula bénréh roy de funa ro énda géangéy diyo. I sébaane de mano, ‘Bukué ku, énda géangéyu diyoan, non mantuwu séna ménléy fantad, angéyé ku téngténgén.’ ");
INSERT INTO tiy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","I géruwowe de ménbéréh mano, ‘Bukué ku, énda géangéyu diyoan, non mantuwu séna ménléy folo timan safi brab magéwu angéyé ku bero langunén.’ ");
INSERT INTO tiy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","I gétéléwe de ménbéréh mano, ‘Bukué ku, énda géangéyu diyoan, non mantuwu séna ménawag.’ ");
INSERT INTO tiy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","I sugu-suguéne ni ménule brab bénréhén dob lagéye gefe karagiya i kéluhanay de ni. Mélaw toow fo ménkérit i ni gefe karagiya. Tidéw béno, bénréhén dob sugu-sugué nuwe mano, ‘Fagayas go, angéy go dob de agéwon brab dob de kalsada, brab uwitém diniy de méskinan do étéw, do kimoyén, do langafén, brab do fikat.’ ");
INSERT INTO tiy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Atin ménagéw i ni sugu-suguén. Tidéw béno, ménséfule mangéy dob gefee ni karagiya, brab bénréhén de mano, ‘Rénigo guy sénugu me begén, éndob énda séna féno i lawie bé étéwe.’ ");
INSERT INTO tiy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Atin i gefee ni karagiya bénréhén dob sugu-sugué nuwe mano, ‘Agéw go mangéy dob de agéwon mangéy dob de kloh ingéd brab fiyon dob de tuduk, brab uwitém i de étéw diyo mangéy dini, méuyotu de ké méféno étéw i lawi guwe ni. ");
INSERT INTO tiy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Endob i de étéw sénéngkat gu sungu, énda gétem-tem ro bé de amaén ténafay gu.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wén i no sébaan fuweh, amun ménagéw i Jesuse, ménodor i de médoo do étéw géliwét de. Atin sénlingén bero mano, ");
INSERT INTO tiy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Fiyon atiy méuyote modor Begén, éndob mas nay kéimu ne bé de lukésén, brab bawag ne, brab de ngaén, brab de dumo no sétiman idéng, brab i kaane lowoh, énda médaitén waléy kuyug gu. ");
INSERT INTO tiy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Atin fiyon atiy étéwe énda fédaydayén bé de kérégénon fiyon fo ké féléhuén dob kruse, énda médaitén waléy kuyug gu. ");
INSERT INTO tiy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ufama, buluk wén i méuyot rémigo lawi, békén ba mésar na métah inok fégitungé no ké firoy i laga i kérigowe de, inok gétiga no ké wén i katabuwan kurtaén fégéfégilidén de? ");
INSERT INTO tiy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Buluk féngganayén saén i kérigo nuwe de, atin énda géfégilidén de, waléy sébayat i de étéw gégito de. ");
INSERT INTO tiy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Maro, ‘Dufang i ni étéw. Féngganayén saén i kérigo nuwe de, éndob énda géfégilidén de.’ ");
INSERT INTO tiy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Taloo no, i ségétéwe datu mangéy sétiboh bé sébanile de datu. Békén ba mésar na métah brab fégitungé no ké gagané no bé foloé ngibu sundalo no kuntra bé ruwowe folo ngibu sundaloy sébanile de? ");
INSERT INTO tiy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Buluk gékarangay datue ni bé énda gégagay kaane sundalo, émféuwit sarigo no mangéy malak bé sébanile de datu amuk mérayu séna inok méréh bé éndaén sétiboh ro.” ");
INSERT INTO tiy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Féntaus Jesusey kébéréh ne mano, “Ségiléw so bé begome. Amuk méuyot gom waléy kuyug gu, kailangan tagak gom i kéluhanay gulaané kome.” ");
INSERT INTO tiy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tidéw béno, nuret Jesusey sébaane binuwaya fantag bé késégiléw i timuse bé de kuyugén mano, “I timuse fiyo. Endob buluk mékédan i kétasik ne, éndaén i nonomén brab éndaén géséfule i kétasik ne. ");
INSERT INTO tiy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Enda fiyo no bé fantade taloo no bé abunowe. Fatut ibérén saén. Tuntay gom i ni énggélingoo kom.” ");
INSERT INTO tiy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wén i no sébaan fuweh, amun ténoro Jesusey de étéw, ménggégumah i de médoo lémiful kubrador brab de tete étéw mangéy mégélingo. ");
INSERT INTO tiy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wén soy do Fariseo brab do témoro bé kitabé diyo. Atin sabaf bé kéika ruwe bé de tete étéw, ménriklamo ro maro, “I ni lagéy méuyot témayakuf bé de tete étéw brab séréngan na bero mama.” ");
INSERT INTO tiy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mélaw nureto Jesuse bero do binuwaya mano, ");
INSERT INTO tiy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Amuk i ségétéwe begom wén i mératu bili-bili no brab méntadin i sébaane de, ati rigoné muwe? Békén ba tagaké moy siyowe de folo bra siyow dob fétabtabane, atin angéyé mo sélédén i sébaane de méntadin taman gito mo? ");
INSERT INTO tiy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tidéw béno, buluk gito mo, duwalé mo mule toow fo méoror. ");
INSERT INTO tiy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Brab tabaré moy de dumo mo brab béréhé mo dob berowe, ‘Toowu fo méoror non énggito guy méntadine bili-bili gu. Enggomén, rémigo tom karagiya.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Atin féntaus Jesusey kébéréh ne mano, “Loo so bé niy Tuluse. Toow fo méoror amuk wén i ségétéw tete étéw gésénule brab tagaké noy tetee adatén, atin rigoné noy kétayay Tuluse. Mas méoror i Tuluse bé ni ségétéw étéw ménggésénule bé kéoror ne bé de siyow folo bra siyow fiyo étéw énda kailanga roy gésénulee.” ");
INSERT INTO tiy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ménuret man i Jesuse ségiyo binuwaya mano, “Wén i ségétéwe libun wén i folo timan balilaga félatahén. Atin méntadin i sébaane de. Ati rigoné nuwe? Témumon solo brab kodosé noy lawi ne sélédé no taman gito noy ni sébaan félata méntadin. ");
INSERT INTO tiy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tidéw béno, tabaré noy de dumo no brab béréhé no bero mano, ‘Toow fo méororu non énggito guy félata guwe méntadin. Enggomén, rémigo tom karagiya.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Féntaus Jesusey kébéréh ne mano, “Béréhé ku begom man, i de télakiy Tuluse toow ro fo méoror amuk wén i ségétéw tete étéw gésénule brab tagaké noy tetee adatén atin rigoné noy kétayay Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Atin nuret Jesusey gétéléwe binuwaya mano, “Wén i ségétéwe étéw lagéy wén i ngaén ruwo gétéw lagéy. ");
INSERT INTO tiy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wén i no sébaan fuweh i tuwaréye bé de ngaén ménangéy dob boh ne mano, ‘Boh, irayém begén i baad guwe bé de languntaman katom.’ Mélaw i boh ne bénaadén i kéluhanay languntama ruwe dob ruwowe gétéw ngaén. ");
INSERT INTO tiy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Enda mérugayén tidéw béno, i tuwaréye bé de ngaén fénbéléyén i kéluhanay kaane baad. Atin ménagéw ménangéy dob mérayue ingéd, brab nuwitén i kurta ne. Diyo séninggulaén i kéluhanay kurta ne bé kédufang ne. ");
INSERT INTO tiy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tidéw béno, ménggumah i dakéle lénggob dob kéluhanay sugud i no dakél ingéd. Atin toow fo mélayaf i dufange ni étéw, non éndaén i kurtaén. ");
INSERT INTO tiy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mélaw ménahur dob sébaane galbék kay ségétéwe bati diyo. Sénuguén dob fantad ne émféama babuy. Non bé toowén fo mélayaf, ");
INSERT INTO tiy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","méningar bé amaéy de babuy. Endob énda i mirayan de kéama. ");
INSERT INTO tiy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tidéw béno, énggétiga noy kédufang ne atin ménggitung mano, ‘I kéluhanay de sugu-suguéy boh guwe, gaba-gabay de amaé ro. Endob ay niwu méléhu mélayaf. ");
INSERT INTO tiy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Séfuleu mangéy dob boh guwe brab béréhé ku diyo, Boh, ménsalau dob Tuluse brab dob beeme. ");
INSERT INTO tiy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Endaén médaitu fédawété mo ngaém. Endob fégédaw go begén. Rigo mo begén sébaan bé de sugu-sugué mo.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Mélaw ménule. Amun mérayu séna dob lawi ruwe, énggitoy boh ne brab mén-uray i éna nuwe de. Léménéntu bénalakén i nga ne nékéfén brab narékén. ");
INSERT INTO tiy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Atin ménbéréh i nga ne mano, ‘Boh, ménsalau dob Tuluse brab dob beeme. Endaén médaitu fédawéto mo ngaém.’ ");
INSERT INTO tiy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Endob i boh ne ténawagén i de sugu-sugué no brab bénréhén bero mano, ‘Féraan gom. Uwit gom i toowe fo fiyo kégal brab fékégal gom de. Fétisingo kom brab fésafatoso kom. ");
INSERT INTO tiy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Atin sumbali gom i kagéne toow fo bobo nati safi. Rémigo tom dakél karagiya. ");
INSERT INTO tiy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Non i nga guwe maak ménléhu, éndob béleewe ni méuyag. Maak méntadin, éndob béleewe ni énggiton.’ Tidéw béno, rénigo roy dakéle karagiya. ");
INSERT INTO tiy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Endob béno so, ménggégumah i ofoe ngaén lagéy tidéw dob de galbéko no. Amun gédétén dob lawie, ménggaif bé énggélingoo noy kantawe brab énggito noy de étéw mésayaw. ");
INSERT INTO tiy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mélaw ténabarén i ségétéwe bé de sugu-sugué ro brab ménénginsa ké ati rigoné ruwe. ");
INSERT INTO tiy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Séménumbul i ni sugu-suguén mano, ‘Ménséfule i tuwaréy me. Sénugu i boh me begey séménumbali bobo nati safi, non i tuwaréy me ménséfule énda i sugsugén.’ ");
INSERT INTO tiy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tidéw béno, toow fo ménkérit i ofo ne lagéy, brab énda méntausén dob lawie. Mélaw i boh ne ménsut brab ménfégédaw-gédaw inok mahur dob lawie. ");
INSERT INTO tiy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Endob bénréhén dob boh ne mano, ‘Géménalbéku bé firoye gébélintuwa brab énda fénlis guy fénrigo muwe begén. Endob énda foy nirayém begén fiyon sébaan kambing inok rémigowu karagiya begey i de dumo gu. ");
INSERT INTO tiy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Endob i ni ngaém ménraréy, brab séninggulaén i éntingayéne nirayém de bé de kédufanga no. Endob amun ménule, sénumbalio mo bé boboe nati safi.’ ");
INSERT INTO tiy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Séménumbul i boh ne mano, ‘Adu, bati go dini sénga tékélid brab i éntingayéne kagén, kaam so. ");
INSERT INTO tiy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Endob fatut rémigo tom karagiya inok féténgténg tom i kéoror tome non i tuwaréy me maak ménléhu, éndob béleewe méuyag. Brab maak méntadin, éndob béleewe énggiton.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Atin nuret Jesuse bé de kuyugén i ni binuwaya mano, “Wén i ségétéwe kawasa étéw, wén i sénarigo nuwe lémiful. ");
INSERT INTO tiy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Amun énggélingooy amu nuwey ni, ténabarén i sénarigo nuwe ni brab ménénginsa mano, ‘Ati ni énggélingoo ku fantag beem? Fénakawa mo begén? Béréhém begén i kéluhanay kérigo muwe bé kagéne kurta. Non éndaén fakayén sarigo ku beem. Mélaw kédané ku beem dob ni galbék.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tidéw béno, i sénarigone ni ménggitung mano, ‘Ati rigoné kuwe, ké kédané no begén dob ni galbék? Enda émbagéru gémalbék mérégén loo bé kémalute. Atin mémalawu mongot limus. ");
INSERT INTO tiy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Gétiga kuy ati rigoné kuwe inok buluk mékédanun dob galbék guwe ni, tayakuféy de étéw so begén dob de lawi ro.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tidéw béno, ténabarén i kéluhanay de étéw énggéutong dob amu nuwe ni. Atin bénréhén dob sunguwe de mano, ‘Firoy i utong me bé amu guwe?’ ");
INSERT INTO tiy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Séménumbul i ni étéw mano, ‘Mératu dakél latah nor.’ Atin ménbéréh i sénarigone ni mano, ‘Ay ni sulate bé utong me. Sar go brab sulatém bé limo folo saén dakél latah nor.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tidéw béno, fénénginsaa noy géruwowe ni étéw énggéutong mano, ‘Firoy i utong me bé amu guwe?’ Séménumbul mano, ‘Séngibu gésaku faréy.’ Atin bang i sénarigone ni, ‘Ay ni sulate bé utong me. Sar go brab sulatém bé waléw ratu gésaku saén.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tidéw béno, amun i amu nuwe ni énggélingoo noy kéluhanay rénigoy sénarigo nuwe ni, dénayéwén mano, ‘Toow fo métilédtéd i ni étéw lémiful.’ ” Atin féntaus Jesusey kébéréh ne mano, “I de étéw dob duniyae ni mas na furung ro maguyag bé de méngintulus. Non tafayé roy kéfaguyag ruwe dob de géfuray gai moso. Atin i de étéw méngintulus fatut so tafayé roy kéfaguyag ruwe dob de géfuray gai moso dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Mélaw béréhé ku begom, usar gom i kurta gome fégétabang bé de étéw méskinan. Atin i Boh gome dob lawayo tayakufé no begom diyo. ");
INSERT INTO tiy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Buluk mésarigon go bé klohe, mésarigon go so bé médoowe. Endob buluk énda mésarigon go bé klohe, énda so mésarigon go bé médoowe. ");
INSERT INTO tiy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Atin amuk énda mésarigon gom bé de funan méungangén dob duniyae, énda so mésarigon gom bé toowe fo funan méungangén dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Buluk énda mésarigon gom bé tamuk i dumo gome étéw béni, énda so sémarig i Tuluse begom bé tamuke dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Atin ménbéréh man i Jesuse mano, “Enda i sugu-suguén fakay galbéko no séréngan i ruwowe gétéw amu. Non amuk mégédaw bé ségétéwe de, mérarék bé ségétéwe de. Taloo no odoro noy kétayay ségétéwe de, siyawé noy ségétéwe de. Mélaw énda fakay go modor bé Tuluse amuk fégitungé mo saén i kurtae.” ");
INSERT INTO tiy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Diyo soy de Fariseo do toow fo méuyot bé kurtae. Amun énggélingoo roy ni kétoro, déniyangka roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mélaw bénrého Jesuse bero mano, “I begome maak métintu do étéw, éndob ubo-ubo saén i de ula-ulané kom dob adafay de étéw. Endob i Tuluse gétiga noy fédéw gome. Ati médayéwe dob de étéw, toow fo mika i Tuluse de. ");
INSERT INTO tiy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Wén i do tafay ménsulat kukuman niray Moisese bé gétahe tidéw dob Tuluse, brab wén soy do sénulat i de sénarigoy Tuluse muret bé kébéréh ne bé gétahe. I de sulat ni fatut nodoron taman sa bé kégumah Juan Bautistawe. Tidéw béno, fatut uretén i Fiyowe Uret fantag bé kéféguléw i Tuluse. Brab kéluhanay de étéw fégésé roy mahure. ");
INSERT INTO tiy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Endob énda fakayén ké wén i mékédan bé kukumane, fiyon kloh saén. Mas na magad mékédan i duniyae brab lawaye, éndob i kukumane énda mékéda no.” ");
INSERT INTO tiy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Atin bang Jesuse man, “Fiyon atiy gémélake bé bawag ne atin mawag man ségiyo libun, énggélamfa. Brab i lagéye bawagé noy libune génlak, énggélamfa so.” ");
INSERT INTO tiy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ménbéréh man i Jesuse mano, “Wén i ségétéwe kawasa étéw kéménégal toow fo fiyo kégal, brab maguyag bé toowe fo fiyo kéfaguyag sénga fuweh. ");
INSERT INTO tiy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wén soy ségétéwe étéw toow fo méskinan féndawét Lasaro. Ménféno békukang i lowoh ne. Sénga fuweh uwitén dob béngaway lawi i étéwe ni kawasa, ");
INSERT INTO tiy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","non ménuyot damén ké géama fiyon do kloh sama saén ménlawu tidéw dob amaéy ségétéwe ni kawasa. Atin fégédét i de itu dob beene inok dilaé roy de békukangén. ");
INSERT INTO tiy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tidéw béno, i Lasarowe ni méskinan ménléhu. Atin nuwit i de télakiy Tuluse mangéy dob tébing i katufuay de Judio féndawét Abraham dob lawayo. Brab i étéwe ni kawasa ménléhu so brab lénébéng. ");
INSERT INTO tiy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I ni étéw kawasa, énggéangéy dob uleone emferno mérasay. Brab amun léménéngag, énggito no dob mérayuey miskinane Lasaro dob tébing Abrahame. ");
INSERT INTO tiy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tidéw béno, téménabar mano, ‘Bebe Abraham, fégédaw go begén. Suguém i Lasarowa nan angéyé no élédén i tuko ténoro ne dob wayége brab féluyuté no dob dila guwe ni inok fégéfélégénéy gu. Non ay niwu dob rinoe ni mérasay.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Endob séménumbul i Abrahame mano, ‘Adu, fégétédémém i kéuyag mo séna, gédoté moy éntingayéne fiyo atin i Lasarowe kérégénan mérasay. Béleewe ay niy Lasarowe mésésaya brab ay nan go mérasay kérégénan. ");
INSERT INTO tiy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Brab saliyu na bé de ni, wén i sébaane léfak toow fo ménalém dob élét tome inok i méuyote mifar mangéy diyoan tidéw dini taloo no tidéw diyoan mangéy dini énda géifarén.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","I kawasawe ni ménbéréh man mano, ‘Bebe, suguém i Lasarowe mangéy dob lawi i boh guwe. ");
INSERT INTO tiy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Non wén i limowe gétéw do dumo gu sétiman idéng diyo. Brab ureté no émféingat bero inok énda mangéy ro dob ni gonon mérasay.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Atin séménumbul i Abrahame mano, ‘Diyo soy de sénulat Moises brab de sénarigoy Tuluse muret bé gétaho. Gébasana roy de ménsulat diyo inok géingat ro.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Endob ménbéréh i kawasawe ni mano, ‘Enda fo munur ro bé de ménsulat. Endob buluk wén i ségétéw tidéw dob de ménléhu tébule mangéy diyo, fakay munur ro, brab gésénule ro bé de sala ro.’ ");
INSERT INTO tiy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Endob séménumbul i Abrahame mano, ‘Buluk énda munur ro bé de sénulat Moises brab de sénarigoy Tuluse muret, énda so munur ro fiyon fo ké wén i ségétéw tébule tidéw dob de ménléhu.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Atin ménbéréh i Jesuse dob de kuyugén mano, “I de éntingayén funay de étéw gésala gégumah, éndob mékégédaw-gédaw i étéwe muwit de. ");
INSERT INTO tiy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Toow fo gétimal ké mékukum, mélaw mas na fiyo ké ibérén dob dogote nikéton bé dakéle batéw i reer ne ké beeney funay ségétéwe mantu séna méngintulus gésala. ");
INSERT INTO tiy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mélaw ingat gom. Atin buluk énggésala i dumo gome, gélé gom. Brab buluk gésénule, fésagada kom. ");
INSERT INTO tiy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Fiyon fo ké énggésala dob beeme fitéw gule bé ségétérésange, atin séfule so fitéw gule mongot fasinsiya, fésagada mo.” ");
INSERT INTO tiy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tidéw béno, i de kuyug Jesus ménbéréh ro maro, “Kadnan, umana moy kéféngintoow geye.” ");
INSERT INTO tiy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Atin séménumbul i Jesuse mano, “Buluk wén i kéféngintoow gom loo bé kédakél i oloy sabie, gébérého kom dob kayéwe ni makom, ‘Térandut go, brab angéy go téohok dob dogoto’, atin unuro no begom.” ");
INSERT INTO tiy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Atin ménbéréh i Jesuse man mano, “Ufama, buluk i ségétéwe begom wén i sugu-sugué no démadu taloo no témalima bé de ayamém, buluk gégumah i ni sugu-suguén tidéw dob de galbéko no, énda béréhé mo de, ‘Enggon, ama go nén.’ ");
INSERT INTO tiy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yamula béréhé mo de, ‘Lékas go, tafayém i amaé kuwe, atin duwoto mo begén, brab ongot-ongotém ké gilidu mama. Tidéw béno, mama go so kaam.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Atin féntaus Jesusey kébéréh ne mano, “I nan ségétéw sugu-suguén, énda fatutén ongot-ongot bé kéfésalamate bé kérigo nuwe bé fatute. ");
INSERT INTO tiy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ségiléw so bé begomey ni sugu-suguén. Buluk énggilid gomén bé galbéke sénugu i Tuluse rigoné kom, fégétédém gom i ni, begom saén i de sugu-suguén, mélaw kagom ongot-ongotén i kéfésalamate. Rénigo gom saén i fatute rigoné kom.” ");
INSERT INTO tiy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Amun i Jesuse ménangéy Jerusalem, ménagéw mangéy bé élét i de sakuf Samaria brab Galilea. ");
INSERT INTO tiy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Amun mahur dob sébaane ingéd, énggébalakay de folo gétéw lagéy. Wén i déruu ro fémute. Atin non fémuteén ro, téménindég ro dob mérayue. ");
INSERT INTO tiy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Brab mékes ro maro, “Jesus! Maistéro! Fégédaw go Begey!” ");
INSERT INTO tiy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Amun énggito Jesuse bero, ménbéréh mano, “Agéw gom mangéy féténgténg dob de fadi inok gétiga ro ménadi-adi gom.” ");
INSERT INTO tiy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Amun ménagéw ro mangéy dob de fadi, ménadi-adi ro dob aguwone. Atin amun i ségétéwe bero énggito noy ménadi-adi, ménséfule ménangéy dob Jesuse, mékes dayéwé noy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Atin méntéléngkéb dob adafa Jesuse fésalamat. I ni lagéy békén Judio, éndob tidéw dob sakuf i ingéde féndawét Samaria. ");
INSERT INTO tiy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ménbéréh i Jesuse dob de étéw mano, “Folo gétéw i ménadi-adiwe. Hon i de siyow de? ");
INSERT INTO tiy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Endob ségétéw saén i ménséfulee mangéy fésalamat bé Tuluse, sani ségétéwe tidéw dob ségiyowe ingéd.” ");
INSERT INTO tiy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Atin sénbérého Jesusey ni lagéy mano, “Tindég go brab taus go dob ayo muwe. Ménadi-adi gon non méngginugut go Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","I de dumo do Fariseo fénénginsa ro dob Jesuse ké kédiron i kégumah i gaiy kéféguléw i Tuluse bé de étéwén. Séménumbul i Jesuse mano, “I kégumah i kéféguléw i Tuluse énda gitono. ");
INSERT INTO tiy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Enda i ségétéw de gébéréh begom, ‘Ay ninén, téngténgém!’ Taloo no, ‘Diyoonén.’ Non i kéféguléw i Tuluse diyo dob de fédéw gom.” ");
INSERT INTO tiy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tidéw béno, bénréh Jesuse dob de kuyugén mano, “Gégumah i gaiwe féngonoyé kom i gito gom i gaiy késéfule i Nga i Kéilawane, sani Begéne. Endob énda gito gom de. ");
INSERT INTO tiy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Atin béréhéy de étéw begom maro, ‘Ay diyoonén.’ Taloo no, ‘Ay ninén.’ Endob kagom munur de taloo no mangéy gom diyo inok téngténgé kom. ");
INSERT INTO tiy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Non i késéfule guwe maak kilot métékow réméndaw brab géfékaya i kéluhanay lawayo. ");
INSERT INTO tiy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Endob bé sunguwe, kamarasayanu, brab i de étéw méuyag béni, ikaa ro Begén. ");
INSERT INTO tiy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Loo so bé gai Noehe, i gaiy késéfule guwe. ");
INSERT INTO tiy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bé gai Noehe, méguyaya i de étéw, mama ro, miném ro, mawag ro taman bé kéahur Noehe dob barkowe. Tidéw béno, i dunuke énggégumah atin ménléné ro kéluhanan saliyu bé Noehe beroy de samungén. ");
INSERT INTO tiy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ségiléw so bé gai Lote bé gétaho. Bé béno, i de étéw mama ro, miném ro, sébéléy ro, mohok ro, brab rémigo ro do lawi. ");
INSERT INTO tiy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Endob bé gai kéféled Lote bé ingéd ne Sodom, i rinoe brab do bara ménlawu maak rana tidéw dob lawayo méninasa bero kéluhanan do ménféled. ");
INSERT INTO tiy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Loo so moso bé niy gai guwe séfule. ");
INSERT INTO tiy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Bé béno gai, i de étéw diyo ro dob liyuy lawi ruwe, éndaén fatut ro mahur angéyé roy de insod ro. Loo so bé niy étéwe diyo dob de galbékono, énda so fatutén séfule mangéy dob lawi ne. ");
INSERT INTO tiy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fégétédém gom i bawag Lote non séménling inok téngténgé noy de insod ro ménféled, mélaw i lowoh ne ménwaléy égas timus. ");
INSERT INTO tiy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Atiy méuyote émféraru bé kéuyag ne, méléhu. Endob i méléhue bé kéfuray ne Begén, gédoté noy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Béréhé ku begom, bé béno kélungonon bé késéfule guwe, wén i ruwo gétéw séurir fidong, atin i ségétéwe de dotén, brab i ségétéwe de émféled. ");
INSERT INTO tiy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Atin wén i ruwowe gétéw do libun gémiling, atin i ségétéwe de dotén, brab i ségétéwe de émféled. ");
INSERT INTO tiy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Atin ruwo gétéw diyo dob galbéko ruwe, atin i ségétéwe de dotén, brab i ségétéwe de émféled.” ");
INSERT INTO tiy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tidéw béno, fénénginsaay de kuyugén maro, “Kadnan, hon i gonoy de ni de mérigo?” Séménumbul i Jesuse mano, “Hon i gonoy wéne de ménléhu, diyo soy de uwak sétimu. Loo so bé toowe tete étéw, gégumah dob berowey kékukum i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tidéw béno, nuret Jesuse bé de kuyugén i ni binuwaya inok démoyun ro démasal brab énda mékédan i inam ruwe. ");
INSERT INTO tiy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ménbéréh mano, “Wén i ségétéwe kémukum dob sébaane ingéd, énda fo mégilakén bé Tuluse taloo no énda fo fégadata noy étéwe. ");
INSERT INTO tiy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Brab wén soy ségétéwe libun baléw dob no ingéd. Démoyun mangéy dob ni étéw kémukum fégédaw-gédaw bé tabanga no bé tiyawa nuwe bé fétabana no damén i sébanile de. ");
INSERT INTO tiy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bé sunguwe de, mika i kémukume témabang. Endob tidéw béno, fénggitungén mano, ‘Fiyon fo ké énda mégilaku bé Tuluse brab énda fégadata kuy de étéw, ");
INSERT INTO tiy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","éndob taluwanu bé késéfule-fule ne mongot tabang. Mélaw tabanga kuy baléwe ni, inok éndaén séfuleén taman kérégénanu.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Atin féntaus Jesusey kébéréh ne mano, “Tuntay gom i béréhéy kémukume ni fiyon fo ké békén métintu étéw. ");
INSERT INTO tiy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Toow na fo tabangay Tuluse begom do fénémilién amuk démasal gom fuweh na kélungonon. Brab énda métana i kétabang ne begom. ");
INSERT INTO tiy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Béréhé ku begom, magad tabangay Tuluse begom. Endob buluk gégumah i gaiwe séfuleu, kloh saén i de munur Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Atin nuret Jesuse man i sébaane binuwaya dob de étéw fégitungé roy métintu ro éndob siyawé roy de dumo étéw. ");
INSERT INTO tiy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Bang Jesuse, “Wén i ruwowe gétéw étéw ménangéy dob lawi i Tuluse inok démasal ro. I ségétéwe de Fariseo brab i ségétéwe de kémubra buwis. ");
INSERT INTO tiy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","I Fariseowe ni téménindég atin déménasal mano, ‘Fésalamata ku Beem Tulus non békén ségiléwu bé de dumo gu étéw, do ménakaw, do arumén ro, do lémamfa ro. Fésalamata ku Beem non békén ségiléwu bé diyoo étéw lémiful kémubra buwis. ");
INSERT INTO tiy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fuwasawu ruwo gule bé ségéfadiyane, brab iray gu dob Beemey géfoloe bé kéluhanay sahudé kuwe.’ ");
INSERT INTO tiy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Endob i ségétéwe ni kémubra buwis téménindég dob mérayue, brab mémala énda géténgangén dob lawayo, brab éntungén i kuméng ne bé kétete i fédéw ne. Atin déménasal mano, ‘Tulus, fégédaw go begén ségétéwu ménsala.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Atin féntaus Jesusey kébéréh ne mano, “Béréhé ku begom, i ni étéw kémubra buwis, amun ménule, fénsagaday Tuluse bé de salaén. Endob i Fariseowe ni, énda fénsagaday Tuluse de. Non i de étéw téfégérotor, fégérifantadén ro. Brab i de étéw térifantad, fégérotorén ro.” ");
INSERT INTO tiy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wén i no sébaan fuweh, wén i médoowe do étéw ménuwit bé de nga ro dob Jesuse inok féfiyoné no bero. Endob amun énggitoy de kuyugén, génlé roy de étéw ni. ");
INSERT INTO tiy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Endob ténabar Jesusey de nga mangéy dob Beene, brab bénréhén dob de kuyugén mano, “Féangéy gom i de nga dob Begéne. Brab kagom alangén bero non i de étéw sémarig loo bé késarig i de ni nga, féguléwoy Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Béréhé ku begom i toowe, buluk i késarig i ségétéwe békén loo bé késarig i ngae, énda so féguléwoy Tuluse de.” ");
INSERT INTO tiy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Atin i ségétéwe uléw i de Judio ménénginsa dob Jesuse mano, “Fiyo maistéro, ati rigoné kuwe inok gédoté kuy umule magufusa?” ");
INSERT INTO tiy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Séménumbul i Jesuse mano, “Sedek fédawété mo Begén fiyo? Enda i ségiyo fiyo saliyu saén bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gétiga moy de sugu. Kago lémamfa, kago méméléhu, kago ménakaw, kago uretén i dumo muwe bé békéne toow, fégadata moy boh me brab idéng me.” ");
INSERT INTO tiy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Séménumbul i uléwe ni mano, “I kéluhanay de ni, nodoro ku tidéw féganay klohu de séna.” ");
INSERT INTO tiy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Amun énggélingoo Jesusey ni, bénréhén de mano, “Sébaan i kulange beem. Fébéléyém i kéluhanay éntingayéne kaam atin irayém i kurtae dob de méskinan. Atin mélaw kawasa go moso dob lawayo. Tidéw béno, énggonén, odor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Amun énggélingooy étéwe niy ni, toow fo tete i fédéw ne, non toow fo kawasa. ");
INSERT INTO tiy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Amun énggito Jesuse ni tete i fédéw ne, bénréhén mano, “Toow fo mérégén i kéahur i de kawasa dob kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas na mélémuy kéahur i dakéle ayam dob tosong i darume bé kéahur i ségétéwe étéw kawasa dob kéféguléw i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","I de énggégélingo bé de ni, fénénginsa ro maro, “Ati mélaw i de fakay méfukas?” ");
INSERT INTO tiy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Séménumbul i Jesuse mano, “I de békén fakay rigonéy étéwe, fakay gérigonoy Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","I Pedrowe ménbéréh mano, “Ténagak gey i de lawi gey inok furay gey Beem.” ");
INSERT INTO tiy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Atin bang Jesuse, “Béréhé ku begom i toowe, i ségétéwe téménagak bé lawi ne, bawag ne, taloo no dumo no sétiman idéng, do lukésén, taloo no do ngaén inok ureté noy fantag bé kéféguléw i Tuluse, ");
INSERT INTO tiy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","gégédot toow na fo médoo dob de ni do gai. Brab dob de gai gégumah, gédoté noy umule magufusa.” ");
INSERT INTO tiy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wén i no sébaan fuweh, ténabar Jesusey de folo bra ruwo gétéw kuyugén sébero-bero saén, atin bénréhén dob berowe mano, “Fégélingo gom, mangéy tom Jerusalem. I Jerusalemey ingéde mérigoy kéluhanay ménsulate bé gétaho sénulat i de étéw sénarigoy Tuluse muret bé kébéréh ne fantag bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","I Begéne sani Nga i Kéilawane, irayu dob de békén Judio. Atin diyangkaé ro Begén brab fémalané ro Begén, brab duraa ro Begén, ");
INSERT INTO tiy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","brab badasé ro Begén, brab féléhué ro Begén. Endob amuk méifus i téléwe gétérésangan, tébuleu.” ");
INSERT INTO tiy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Endob i de kuyug Jesus, énda énggésobuto roy de ni bénréh Jesuse. I atag i de ni kébéréh ménbunéy dob berowe, brab énda gésobuto ro de. ");
INSERT INTO tiy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Amun gégumah i Jesuse dob ingéde Jeriko, diyo i ségétéwe étéw langafén ménsar dob doror i aguwone mongot limus. ");
INSERT INTO tiy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Amun énggélingoo noy médoowe do étéw téménara, ménénginsa ké ati ni gérigonon. ");
INSERT INTO tiy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wén i séménumbule mano, “I Jesuse tidéw Nasaret témara.” ");
INSERT INTO tiy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tidéw béno, téménabar métanug mano, “Jesus, séfu Datu Dabid, fégédaw go begén!” ");
INSERT INTO tiy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","I de étéw métah bé Jesuse géléé ro maro, “Kago selekén!” Endob taus so mékes toow na fo métanug mano, “Jesus, séfu Datu Dabid, fégédaw go begén!” ");
INSERT INTO tiy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Atin téménrén i Jesuse brab nongotén i étéwe ni uwitén mangéy dob Beene. Amun énggéfégédétén, fénénginsaa Jesuse mano, ");
INSERT INTO tiy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ati kétaya muwe rigoné ku dob beeme.” Séménumbul i langaféne ni mano, “Kadnan, méuyotu gégito damén.” ");
INSERT INTO tiy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Atin bénréh Jesuse de mano, “Gégito gon. Adi-adi gon, non méngintoow go.” ");
INSERT INTO tiy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sonom béno, énggégito nén i langaféne ni, atin ménfuray bé Jesuse démayéw bé Tuluse. Amun énggitoy de étéw i ni ménrigo, dénayéw ro soy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Atin méntaus i Jesuse bé kéagéw ne, atin ménahur dob ingéde féndawét Jeriko. ");
INSERT INTO tiy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wén i ségétéwe kawasa féndawét Sakeo diyo bati. Beeney lémifule kémubra buwis dob de dumo no Judio kay de Romano. ");
INSERT INTO tiy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Amun énggélingoo noy Jesuse témara, méuyot i Sakeowe téméngténg inok gétiga no ké ati Jesuse ni étéw. Endob énda gito no de, non bé médoowe étéw géliwét bé Jesuse brab i Sakeowe foko lagéy. ");
INSERT INTO tiy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mélaw léménéntu mangéy dob métaho, brab ménénik dob kayéwe inok gito noy Jesuse témara. ");
INSERT INTO tiy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Amun gédétén i Jesuse dob kayéwe ni, léménéngag brab ménsébéréh bé Sakeowe mano, “Sakeo, fagayas go élus. Fatut mangéyu dob lawi me béleewe ni.” ");
INSERT INTO tiy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Atin ménagayas i Sakeowe mélus tidéw dob kayéwe ni brab méoror ténayakufén i Jesuse dob lawi ne. ");
INSERT INTO tiy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Amun i de étéw énggégito bé ni, ménséguraw ro maro, “I Jesuse ni sugud-sugud mangéy dob tetee étéw.” ");
INSERT INTO tiy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Endob i Sakeowe téménindég brab ménsébéréh bé Jesuse mano, “Kadnan, iray gu dob de méskinan i ténga i éntingayéne kagén. Brab buluk wén i léniful gu, bayada ku fot takéf bé éndot guwe dob berowe.” ");
INSERT INTO tiy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Atin ménbéréh i Jesuse dob beene mano, “Béleewe ni, i Tuluse fénukasén beem brab kéluhana kom dob ni lawi, non munur go ségiléw bé kéunur Abrahame. ");
INSERT INTO tiy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Non i Nga i Kéilawane, sani Begéne, ménangéyu dob ni duniya inok fukasé kuy de étéw ménsala non maak méntadin ro.” ");
INSERT INTO tiy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Amun mégélingo ro séna, féntaus Jesusey kébéréh ne bé sébaane binuwaya non gédét ron dob Jerusalem, atin non i de étéw maro ké béno so gégumah i kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ménbéréh mano, “Wén i ségétéwe gérotor étéw ménangéy dob mérayue ingéd inok rigonén datu diyo. Tidéw béno, bantaké noy séfule. ");
INSERT INTO tiy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Amun énda séna magéwén, ténabarén i foloe gétéw bé de sugu-sugué no brab niraya no dob séngae ségétéw sébaan bélowon félatah. Brab bénréhén bero mano, ‘Féinség gom i ni taman késéfule gu.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Endob i do étéw dob no gonon mika ro de. Mélaw séménugu ro de étéw émbéréh maro, ‘Mika gey bé ni étéw waléy datu gey.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Endob fiyon fo ké loo bé nan, ménwaléy datu. Mélaw ménséfule brab fénsuguo noy de sénarigo no bé de bélowon félatah inok susiné no ké wén i inségén. ");
INSERT INTO tiy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","I sunguwe de ménbéréh mano, ‘Maistéro, i de nirayém begén félatah, énggéinség gu de na folo timan.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tidéw béno, bang i datue, ‘Fiyo, mégéror go sugu-suguén. Non gésarigon go bé klohe, sarigo ku beem méguléw bé foloe do ingéd do sakuf gu.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Atin i géruwowe bé de sugu-suguén ménbéréh mano, ‘Maistéro, i de nirayém begén félatah, énggéinség gu de na limo timan.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tidéw béno, séménumbul i datue ni mano, ‘Féguléw go bé limowe do ingéd do sakuf gu.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tidéw béno, i gétéléwe bé de sugu-sugué no ménbéréh mano, ‘Maistéro, ay niy kurtae nirayém begén. Bénunéy gu brab nitong gu ténaléy dob munsalawe. ");
INSERT INTO tiy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Non mégilaku beem non métégas go étéw. Médot go bé békéne kaam. Brab kémétéw go dob békéne nohokém.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Séménumbul i datue ni mano, ‘Tete go fo sugu-suguén. Kukumé ku beem bé de bénréhém. Gétiga mo kun médotu bé békéne kagén, brab kémétéwu bé békéne nohok gu. ");
INSERT INTO tiy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Amuk kémarang go loo bé nan, sedek énda féndiyoém dob bangkuey kurta guwe inok buluk séfuleu, fakay doté ku brab wén i inségén?’ ");
INSERT INTO tiy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tidéw béno, bénréh i datue ni dob de étéw dob sékulo ruwe téménindég mano, ‘Dot gom i kurta ne ni atin iray gom dob ségétéwe énggéinség folo timan.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Endob séménumbul ro maro, ‘Maistéro, wénén i kaan folo kurta.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ménbéréh man i datue mano, ‘Béréhé ku begom, buluy wéne den médoo, méirayén de na uman. Brab i étéwe de wén i kulang de, fiyon foy klohe dob beene dotén so.’ ");
INSERT INTO tiy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Atin féntaus i datuey ni kébéréh mano, ‘Atin fantag bé de sébanil begén, mika ro de ké waléyu datu ro, uwit gom bero dini brab féléhu gom bero dob téngaanga kuwe ni.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Amun i Jesuse brab de kuyugén gédét ron dob dakéle ingéd Jerusalem, ");
INSERT INTO tiy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","énggégumah ro dob sébaane tuduk féndawét Olibo, gédét dob de ingéd féndawét Betfage brab Betania. Ténabar Jesusey ruwowe bé de kuyugén, ");
INSERT INTO tiy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","brab ménsébéréh bero mano, “Etah gom mangéy dob nan ingéd. Buluk gégumah gom diyo, gito gom i natiwe kuda diyo, énda sénay énggékuda de. Ukoh gom brab uwit gom dini. ");
INSERT INTO tiy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Buluk wén i ménginsa dob begome, ‘Sedek ukohé kom?’ béréh gom de, ‘Kailangay Kadna tome.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nodoroy de ruwo ni gétéw kuyugén i bénréh ne. Atin énggito roy natiwe ni kuda loo bé bénréh Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Amun nukoh ron, énggitoy de gefe de bero brab ménénginsa ro maro, “Sedek ukohé kom i kuda geya nan?” ");
INSERT INTO tiy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Séménumbul ro maro, “Kailangay Kadna tome.” ");
INSERT INTO tiy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Atin nuwit roy kudae mangéy dob Jesuse. Brab namféno ro bé de kégal ro brab fénkuda roy Jesuse diyo. ");
INSERT INTO tiy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Amun méntaus i Jesuse dob Jerusalem, i de étéw bénékah roy de dumo bé de kégal ro dob aguwo Jesuse fégito roy kébasana ruwe de. ");
INSERT INTO tiy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Amun énggégumah i Jesuse dob gonone lémudug dob tuduke Olibo, i kéluhanay de médoo kuyugén ménfésalamat ro dob Tuluse brab ménoror ro démayéw métanug, non bé kéluhanay de mékégaif énggito ro. ");
INSERT INTO tiy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ménkes ro maro, “Dayéwé tom i Tuluse. Féfiyonéy Tuluse damén i ni datu ménggumah tidéw dob Kadnane. Endaén damén i bukuén dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","I de dumo bé de Fariseo diyo do ménribuk, ménbéréh ro dob Jesuse maro, “Maistéro, féantésém i de kuyugém nan.” ");
INSERT INTO tiy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Endob bang Jesuse ni, “Béréhé ku begom, buluk fén-antés ro, i de batéw ni mékes dayéwé ro Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Amun taus ron gédét dob Jerusalem, gékulaya Jesusey ni ingéd. Amun énggito no, kénrewo no bé kéuray i na nuwe de. ");
INSERT INTO tiy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Brab ménbéréh mano, “Méuyotu damén gétiga kom béleewe ni ké atiy kékédane bé bukuéne brab késétibohe, éndob béleewe ni énda gétiga kom de. ");
INSERT INTO tiy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gégumah i gaiwe dob begome, géséliwétoy de sébanil begom brab langkaté ro begom inok énda géléfas gom géliwét. ");
INSERT INTO tiy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Féléhué ro begom kéluhanan fiyon foy de kéluhanay de dumo gom, brab do nga gom. Atin binasané roy de lawi taman énda i sébaan batéw mésama dob rotor i sébaane de. Non énda fénggélolo gom i gaiwe bé kéangéy i Tuluse begom mémukas.” ");
INSERT INTO tiy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Amun énggégumah i Jesuse dob Jerusalem, méntaus dob lawi i Tuluse. Amun ménahur, dénédélén i de étéw démagang diyo. ");
INSERT INTO tiy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Atin bénréhén beroy ni mano, “Wén i Ménsulate Kébéréh i Tuluse mano, ‘I lawi guwe, lawi gonon démasal.’ Endob fénwaléy gom lawi i de ménakaw.” ");
INSERT INTO tiy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Atin sénga fuweh diyo i Jesuse témoro dob Lawi i Tuluse. Endob i de uléw i de fadi, brab de témoro bé kitabe, brab i de méguléw bé de étéw, ténulama ro féléhuén. ");
INSERT INTO tiy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Endob énda gérigono ro de non i de médoo étéw énda fo séféka ro de, non ménuyot ro mégélingo bé kéluhanay de béréhé no. ");
INSERT INTO tiy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wén i no sébaan fuweh, amun diyo i Jesuse témoro dob lawi i Tuluse, brab ureté noy Fiyowe Uret, i de uléw i de fadi brab de témoro bé kitabé brab de odoroy de Judio, ménfégédét ro dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Atin fénénginsaa ro maro, “Béréhém begey ké ati atura muwe rémigo bé de ni? Ati ménirayane Beem kuwagib?” ");
INSERT INTO tiy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sénumbulo Jesuse bero mano, “Sémuliu ménginsaan begom. Béréh gom Begén, ");
INSERT INTO tiy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ati séménugue bé Juane inok mautis, Tulus loo ké étéw saén?” ");
INSERT INTO tiy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Atin séédél ro maro, “Amuk béréhé tom ‘Tidéw dob Tuluso’, fénginsaa no betom ké sedek énda fénéngintoowo tom i Juane. ");
INSERT INTO tiy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Endob buluk béréh tom ‘Tidéw dob étéwe’, kéluhanay de ni étéw ménlimud, ibéro ro betom batéw taman méléhu tom, non féngintoowo roy Juane sénarigoy Tuluse muret bé kébéréh ne.” ");
INSERT INTO tiy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mélaw séménumbul ro maro, “Enda gétiga key ati kétidéw ne de.” ");
INSERT INTO tiy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mélaw bénréh Jesuse mano, “Enda so béréhé ku de begom ati ménirayane Begén kuwagib rémigo bé de ni rigoné ku.” ");
INSERT INTO tiy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Atin nuret Jesusey ni binuwaya mano, “Wén i ségétéwe étéw wén i safadén nohoko no. Brab féntalimaén bé de ségiyo étéw. Tidéw béno, ténagakén ménangéy dob mérayue ingéd bé ménrugaye gai. ");
INSERT INTO tiy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Amun énggégumah i gaiy kékétéwe de, séménugu ségétéw bé de sugu-sugué no inok mongot bé kaane de baad bé de onokén. Endob i ni étéw lénubag i de témalima bé ni safad. Brab fénule ro énda i suwaréw nuwitén. ");
INSERT INTO tiy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tidéw béno, séménugu man bé géruwowe bé de sugu-sugué no. Endob lénubag ro so brab fénémala ro brab fénule ro énda i suwaréw nuwitén. ");
INSERT INTO tiy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tidéw béno, fénuwitén soy gétéléwe bé de sugu-sugué no. Endob féndawéto ro so taman ménfali. Brab dénédél ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tidéw béno, i gefee bé ni safad ménbéréh mano, ‘Ati rigoné kuwe? Gétuwa ku. Féuwit guy tintuwe nga gu kégédawa ku. Fégadata roy nga guwe.’ ");
INSERT INTO tiy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Endob amun énggitoy de témalima, ménsébéréh-béréh ro maro, ‘Been i niy nga i gefee bé ni safad. Féléhué tom inok gékatom i ni safad.’ ");
INSERT INTO tiy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tidéw béno, dénédél ro mésut tidéw dob safade brab fénléhu ro.” Atin féntaus Jesusey kébéréh ne mano, “Ati rigonéy gefee safad dob de ni téménalima bé safad ne? ");
INSERT INTO tiy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Angéyé no féléhuén bero. Brab irayén man dob de ségiyo témalima de.” Amun énggélingooy de étéw i ni kébéréh Jesuse, ménbéréh ro maro, “Békén damén mérigoy nan.” ");
INSERT INTO tiy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tidéw béno, ténéngténg Jesuse bero atin ménénginsa mano, “Amuk békén, ati atag i ni Ménsulat Kébéréh i Tuluse mano ‘I batéwe nikaay de réménigo bé lawie, been i ménwaléye toow na fo balilaga fiyo batéw’? ");
INSERT INTO tiy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Fiyon atiy mélawue dob nan batéw mébinasa. Brab buluk i batéwe ni mélawu dob de étéw, rénahé no bero maak bubuk sébuwan.” ");
INSERT INTO tiy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Atin i de témoro bé kitabé brab do uléw i de fadi, ténulama ro kénéfo i Jesuse bé béno gai, non gébéla dob berowey ni binuwaya. Endob énda fakayén non mégilak ro bé de médoo do étéw. ");
INSERT INTO tiy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mélaw ténulik ro. Atin sénarigo roy de étéw ménginsaan de inok buluk békén katabuwan i késumbul ne, wén i funa ro de témébo brab uwité ro dob de étéw gémamak bé de kukuman. ");
INSERT INTO tiy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tidéw béno, i de étéw ni fénginsaa ro maro, “Maistéro, gétiga key toow i kétoro me. Brab métintu go, énda i isu ramigo mo bé de étéw. Yamula toroé moy toowe fantag bé kétayay Tuluse toow. ");
INSERT INTO tiy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mélaw béréhém begey, aw fatut ba mayad gey buwis dob Sesare sani datue dob Roma taloo no énda?” ");
INSERT INTO tiy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Endob énggétiga Jesusey akar ruwe brab bénréhén bero mano, ");
INSERT INTO tiy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Irayanu félatah.” Amun niraya ro de, ménénginsa i Jesuse mano, “Ati gefee dawét brab falas gito gom dob nan?” Séménumbul ro maro, “Ka Sesar.” ");
INSERT INTO tiy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tidéw béno, bénréh Jesuse mano, “Iray gom dob Sesarey ka Sesare. Brab iray gom dob Tulusey kay Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","I de étéw ténulama ro fégakaran i Jesuse, toow ro fo ménggaif, non toow fo fiyoy késumbul ne de. Mélaw énda i funa ro témébo bé Jesuse. Komon ménantés ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Atin wén i do Saduseo diyo, sani de énda méngintoow bé kéfétébule i Tuluse bé de étéw moso. Mélaw ménfégédét ro dob Jesuse ménginsa maro, ");
INSERT INTO tiy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maistéro, sénulat Moisese betom i kukumane bé buluk i ofo i étéwe ménléhu, brab énggéféledo noy bawag ne, énda i nga ro, fatut bawagéy tuwaréy ne inok wén i séfu i ni étéw bé tuwaréy ne. ");
INSERT INTO tiy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ufama, wén i fitéw gétéw sétuwaréy falan lagéy. Brab i ofoe de ménawag. Tidéw béno, ménléhu énda i nga ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tidéw béno, i gétunduge de bénawagén soy bawage fénled i ofo ne. Atin ménléhu so énda i nga ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Atin i gétéléwe de bénawagén so taman dob géfitéw ruwe. Endob ménléhu ro kéluhanan énda i nga ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tidéw béno, ménléhu soy ni libun. ");
INSERT INTO tiy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mélaw bé gaiy kétébulee moso, ati isuwe bawag i ni libun bé ni fitéw gétéw sétiman idéng? Non énggébawaga ro kéluhanan bé méuyag ro de séna.” ");
INSERT INTO tiy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Séménumbul i Jesuse mano, “I de étéw béleewe, sébawag ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Endob i de étéw métoror tébuleén géangéy dob lawayo, éndaén sébawag ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Non ségiléw ro bé de télaki brab énda méléhu ro. Beroy de nga i Tuluse non méntébule ro. ");
INSERT INTO tiy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Atin fantag bé kétébulee, fiyon i Moisese fénggétuwa noy wén i kétébule. Non dob mérinoe kayéw, féndawétén i Kadnane ‘Tuluse féngadafé Abrahame, Isake, brab Jakobe.’ ");
INSERT INTO tiy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","I atag i ni, i Tuluse féngadaféy de méuyag étéw, békén do ménléhu. Non i kéluhanay ménléhue, méuyag séna dob karang i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Atin i de dumo bé de témoro bé kitabé ménbéréh ro maro, “Fiyoy késumbul me Maistéro.” ");
INSERT INTO tiy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tidéw béno, énda ménbaraw ro de ménginsaan man. ");
INSERT INTO tiy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Atin bénréh Jesuse dob berowe mano, “Ati kéfakay ne ké béréh i de étéw i Kristowe séfu Dabid? ");
INSERT INTO tiy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Non fiyon i Dabide bénréhén dob kaane libro féndawét ‘De Kanta’ mano, ‘I Kadnane ménbéréh dob Kadna kuwe, sar go dob kuwono kuwe, ");
INSERT INTO tiy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","taman témabanu bé de sébanil Beem.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Atin féntaus Jesusey kébéréh ne mano, “Amuk féndawét Dabidey Kristowe ‘Kadnan’, ati kéfakay Kristowe séfu Dabid?” ");
INSERT INTO tiy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Amun dob téngaangay de kéluhanay de étéw mégélingo, bénréh Jesuse dob de kuyugén mano, ");
INSERT INTO tiy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ingat gom bé de maistéroy de kukuman non méuyot ro sugud-sugud bé de toow fo fiyo kégal ro, brab méuyot ro fégadatan ségifaén dob de fadiyan, brab méuyot ro mésar dob de fiyo saran dob de lawi féngadafan brab dob de karagiya. ");
INSERT INTO tiy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Endob lafisé roy de libun baléw inok afasé roy de lawi ro. Tidéw béno, démasal ro bé de métaah kédasal dob téngaangay de étéw non marok médirung i de ni tete rigoné ro. Endob i ni do étéw toow na fo gétimal ké mékukum ro moso.” ");
INSERT INTO tiy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Amun diyo i Jesuse dob lawi i Tuluse, énggito noy de kawasa étéw lémawu ro kurta dob ahurone kurta. ");
INSERT INTO tiy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Atin énggito no soy ségétéwe libun baléw méskinan, méniray saén ruwo lafin furo kurta tintu énda balilagaén. ");
INSERT INTO tiy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Atin bénréh Jesuse mano, “Béréhé ku begom i toowe, i ni méskinan libun baléw maak mas na médooy niray ne bé de dumo étéw kawasa. ");
INSERT INTO tiy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Non i de ni étéw kawasa, méniray ro saén kloh tidéw dob de médoo kurta ro. Endob i ni baléw éntéyén i kéluhanay kurta ne fégéfaguyagén.” ");
INSERT INTO tiy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Atin i de dumo bé de étéw diyo séuret-uret ro fantag bé lawi i Tuluse rénigo bé de batéw toow fo fiyo brab de toow fo fiyo falasén balilaga éntingayén niray i de étéw dob Tuluse. Endob ménbéréh i Jesuse mano, ");
INSERT INTO tiy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gégumah mosoy gaiwe, i kéluhanane gito gom mébinasa. Brab fiyon i de batéw fénggérigo de émbéragar ro.” ");
INSERT INTO tiy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Atin ménénginsa ro maro, “Maistéro, kédiron mérigoy de ni? Brab ati fégélolonone de bé ni gai ké gédétén gumah?” ");
INSERT INTO tiy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Atin séménumbul i Jesuse mano, “Ingat gom inok énda géfagakaran gom. Non médoo mosoy de étéw gégumah usaré roy dawét guwe, brab émbéréh ro maro, ‘Begéney Kristowe, brab i gai guwe ay ni nén.’ Endob kagom unuron bero loo ké furay gom bero. ");
INSERT INTO tiy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Atin kagom mégilak ké gélingoo kom i kébéréh i sétibohe brab gélingoo kom soy fantage bé de gira. I kéluhanay de ni mérigo éndob békén sénay niy tamanane.” ");
INSERT INTO tiy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bénréh Jesuse man mano, “I de ingéd sétiboh ro bé de ségiyo ingéd. Brab i de sakuf fangangaturan sétiboh ro bé de ségiyo. ");
INSERT INTO tiy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Atin wén mosoy do émbagér luba, brab lénggob, brab do médoo mékégilak kérégénon dob de ségiyo-giyo ingéd. Brab wén mosoy téfégito fégélolonon de tidéw dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Endob bé énda séna mérigoy de ni, kéfoén gom brab kérégénan gom sabaf bé kéunur gome. Brab uwitén gom dob de lawi féngadafan inok kukumén gom brab férisunén gom. Brab uwitén gom dob adafay de datu inok kukumén gom sabaf begom i do kuyug gu. ");
INSERT INTO tiy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Endob amuk mérigoy de ni dob begome, been i niy gaiy kéuret gome bé Fiyowe Uret dob berowe. ");
INSERT INTO tiy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Fégétédém gom i ni, amuk mérigoy de ni dob begome, kagom émbuku fantag bé ati késumbul gome. ");
INSERT INTO tiy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Non iraya ku begom kégétigan brab do kébéréh inok i de sébanil begom énda i fiyo késumbulo ro begom. ");
INSERT INTO tiy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Fiyon i de lukés gom brab do dumo gom sétiman idéng brab de samung gom brab do dumo gom, iray ro begom dob de gémamak kukuman inok féléhué roy de dumo begom. ");
INSERT INTO tiy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Atin i kéluhanay de étéw mérarék ro begom sabaf bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Endob fiyon fo ké méléhu gom, maak énda gébinasana roy fiyon sébaan buk dob de uléw gom. ");
INSERT INTO tiy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Fédayday gom munur Begén bé nan gai féfasangén gom non been i funa kome méfukas. ");
INSERT INTO tiy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Atin buluk gito gom i Jerusaleme séliwétoy de sundalo nén, émfégétigan begom bé gédétén i kébinasa nuwe. ");
INSERT INTO tiy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Atin i de étéw bati dob sakuf Judeawe fatut ro méraréy dob de tuduk. Brab de étéw dob Jerusalem fatut ro so méraréy. Brab i de étéw géliyu de, békén fatut ro mahur. ");
INSERT INTO tiy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Non been i niy gaiwe kémukum i Tuluse inok métuman i Ménsulate Kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Toow fo mékégédaw-gédaw i de libun obor brab de libun mériton non gégumah i gaiwe toow fo mékégilak atin i Tuluse kukumé noy de ni do étéw Judio. ");
INSERT INTO tiy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Atin i de dumo étéw féléhuén tibohén bé sundange, brab i de dumo de férisunén dob de ségiyo-giyo ingéd. Brab i de étéw békén Judio daa roy Jerusaleme inok mébinasa taman gilid i karowe gai. ");
INSERT INTO tiy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Wén so mosoy fégélolonon de dob térésange brab térésang kélungonone brab de gitoon, brab dob duniyae niy kéluhanay de ingéd kégilakan non bé késelekéy émbagére bagél dob dogote. ");
INSERT INTO tiy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","I de étéw mésumba ro funowén bé kégilak ruwe ongot-ongot bé ati mérigowe dob duniyae ni, atin non i de éntingayén dob lawayo mékuyung. ");
INSERT INTO tiy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tidéw béno, i Nga i Kéilawane, sani Begéne, téfégitowu tidéw dob lawayo gégumah dob rawéne toow fo barakatan brab réméndaw. ");
INSERT INTO tiy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Buluk mérigoy de ni, tindég gom brab léngag gom non gédétén gumah i gaiwe méfukas gom.” ");
INSERT INTO tiy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tidéw béno, nuret Jesuse beroy ni binuwaya mano, “Fégitung gom i de kayéw. ");
INSERT INTO tiy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Dini dob betome ni, buluk gito gom i de dau ro mégalin, gétiga kom gédétén i gaiwe méduf. ");
INSERT INTO tiy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Loo so bé ni amuk gito gom i de ni mérigo, gétiga kom gédétén i kégumah i kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Béréhé ku begom i toowe, i de étéw méuyag béni, énda méléhu ro taman mérigoy de ni. ");
INSERT INTO tiy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","I lawaye brab duniyae méalfa ro, éndob i kébéréh guwe énda méalfaén. ");
INSERT INTO tiy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ingat gom. Kagom démoyun fégitungén i kéfaguyayae brab téolon-olone, brab kagom toowén fégitungén i kéuyaga kome, non i nan gai séfuleu gégumah bé gaiwe békén karangé kom. ");
INSERT INTO tiy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Non tékow gégumah i ni gai dob kéluhanay de étéw dob duniyae ni. ");
INSERT INTO tiy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ingat gom brab sénga tékélid gom dasal inok émbagér gom énda mékaid gom bé kéluhanay de ni mérigo. Atin gétindég gom dob adafa kuwe énda mémala gom.” ");
INSERT INTO tiy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Bé béno do gai, sénga fuweh mangéy i Jesuse témoro dob lawi i Tuluse, brab sénga kélungonon ménangéy dob tuduke Olibo. ");
INSERT INTO tiy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Brab i kéluhanay de étéw dob no gonon, sénga toow géfuwén mangéy ro dob lawi i Tuluse inok fégélingoé roy Jesuse muret. ");
INSERT INTO tiy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bé béno gai, i kékanduli i de Judio féndawét “Témara” gédétén. Bé no kanduli, amaé roy fane énda fénrukén. ");
INSERT INTO tiy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Atin i de odoroy de fadi brab de témoro bé kitabé séméléd ro bé ati kéféléhu ruwe bé Jesuse. Endob sékémén saén, non mégilak ro bé de étéw. ");
INSERT INTO tiy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tidéw béno, i Satanase rénahuko noy Judas Iskariote ségétéw bé de folo bra ruwo kuyug Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Atin ménangéy i Judase dob de uléw i de fadi brab de méguléw bé lawi i Tuluse brab sénbéréh roy ati kékéfo ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Toow ro de fo ménoror brab ménuyot ro de ké iraya ro kurta i Judase. ");
INSERT INTO tiy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tidéw béno, ménagayun i Judase, brab sénlédén i gaiwe ké énda i dumo Jesuse médoo étéw inok fékéfoén. ");
INSERT INTO tiy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Amun ménifus i firoye gétérésangan, ménggumah i gaiwe fatut i de Judio sémumbali nati bili-bili kay kékandulie féndawét “Témara”. ");
INSERT INTO tiy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mélaw sénugu Jesusey ruwowe bé de kuyugén ro Pedro brab Juan. Brab ménsébéréh bero mano, “Agéw gom brab tafay gom i amaé tome kay kandulie ni ‘Témara’.” ");
INSERT INTO tiy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ménénginsa ro dob Jesuse maro, “Hon i kétaya muwe de gono key témogoh?” ");
INSERT INTO tiy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Séménumbul i Jesuse mano, “Dob Jerusalem. Amuk gumah gomén diyo gébalaka kom i ségétéwe étéw lagéy ménuwit binangga ménféno wayég. Furay gom de mangéy dob lawie ayo no. ");
INSERT INTO tiy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tidéw béno, béréh gom dob gefee bé lawie makom, ‘Méuyot i Maistérowe ké gétiga no hon i sibéye de gono no mama beroy de kuyugén bé ni kékanduli.’ ");
INSERT INTO tiy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Atin i gefee bé lawie toroé no begom i dakéle sibéy wén i de kagamitan de dob rotor i lawie. Diyo i kéluhanay gamité kome. Diyo tafay gom i kéluhanay amaé tome.” ");
INSERT INTO tiy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","I Pedrowe brab Juane ménangéy ro dob no ingéd. Atin énggito roy kéluhanane loo bé kébéréh Jesuse de bero. Tidéw béno, ténafay roy de amaé ro kay kandulie “Témara”. ");
INSERT INTO tiy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Amun ménahur i Jesuse dob lawie, atin amun gumahén i urase, ménsar dob doror i ahayane beroy de kuyugén. ");
INSERT INTO tiy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Atin ménbéréh i Jesuse mano, “Toow fo méuyotu mama séréngan begom bé ni kéama kanduli ‘Témara’ non éndaén mérugayén taman mékukumu. ");
INSERT INTO tiy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Béréhé ku begom i toowe, éndaén mamau bé ni kéama bé kékandulie ‘Témara’ taman gégumah i gaiy kéféguléw i Tuluse bé de étéwén. Bé no gai, wén i mantu atag i ni kanduli.” ");
INSERT INTO tiy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tidéw béno, éndot Jesusey tabu i arake brab ménfésalamat dob Tuluse. Atin nirayén i tabue dob de kuyugén. Atin bénréhén dob berowe mano, “Edot gom i ni brab sétukido kom i arake ni. ");
INSERT INTO tiy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Béréhé ku begom, éndaén minému arak loo bé ni taman gégumah i gaiy kéféguléw i Tuluse bé de étéwén.” ");
INSERT INTO tiy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tidéw béno, éndotén i fane, brab ménfésalamat dob Tuluse brab sénkébeng-kébengén, brab sénaarén dob de kuyugén. Atin ménbéréh mano, “Ay ni fane. Been i lowoh guwe, niray fégéfukas begom. Ama gom i ni inok gétédémo kom Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Amun énggilid i kéama ruwe, éndotén i tabue brab ménbéréh mano, “I tabue ni been i niy dara guwe rémanas, fégéfukas begom, sani tandae bé mantuwe fasad i Tuluse bé de étéwén. ");
INSERT INTO tiy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Endob téngténg gom. I émfékéfoe séko Begén dini dob Begéne ni mama. ");
INSERT INTO tiy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","I Nga i Kéilawane, sani Begéne, féléhuén loo bé kétayay Tuluse mérigo. Endob mékégédaw-gédaw i étéwe ni émfékéfo, non mékukum fo toow.” ");
INSERT INTO tiy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tidéw béno, i de kuyugén séfénginsa ro ké ati isuwe bero rémigo bé ni. ");
INSERT INTO tiy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tidéw béno, ménséédél de kuyugén ké ati isuwe bero toow na fo gérotor. ");
INSERT INTO tiy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Atin bang Jesuse dob berowe, “I de étéw datu dob ni duniya wén i atura ro dob de étéw ro, brab i de uléw tabarén ‘Dumoy de étéw.’ ");
INSERT INTO tiy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Endob békén fatut loo bé ni dob begome. I toowe gérotor bé begomey fatute fénggiring bé toowe tuwaréy begom. Brab i méguléwe géiring bé sugu-suguéne. ");
INSERT INTO tiy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ufama, ati isuwe mas na gérotor, i étéwe duwoton ménsar mama, taloo no i étéwe démuwoton de? Békén ba i étéwe ménsar mama? Endob i Begéne, ay niwu dob kérara gome loo bé ségétéwe sugu-suguén. ");
INSERT INTO tiy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Atin i begome do méntaus ménodor Begén fiyon fo ké bé de gai kérégénanu. ");
INSERT INTO tiy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Atin loo bé kéiray i Boh guwe Begén bé kuwagibé méguléw, iraya ku so begom kuwagib loo bé ni. ");
INSERT INTO tiy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bé gaiwe méguléwu, mama gom brab miném gom séréngan Begén. Brab géésar gom dob de saran kay de datu inok kémukum gom bé foloe brab ruwo do sakuf i de Judio.” ");
INSERT INTO tiy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Atin ménbéréh i Jesuse dob Simon Pedrowe mano, “Simon, fégélingoém. I Satanase méntungkas bé tukawa no begom kéluhanan, loo bé kéfanire bé faréye inok féganané noy fiyowe bégas bé ukofe. ");
INSERT INTO tiy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Endob i Begéne, dénasala ku beem inok i kéféngintoow me méégét. Brab amuk séfule go mangéy dob Begéne, féégétém i kéféngintoow i dumo muwe.” ");
INSERT INTO tiy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Endob bang Pedrowe, “Kadnan, modoru Beem fiyon fo ké dob kalabusuono taloo no fiyon fo ké dob léhuone.” ");
INSERT INTO tiy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Séménumbul i Jesuse mano, “Pedro, énda séna ukoro i férufete béleewe, dirungé mo Begén téléw gule bé énda gélolo mo Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tidéw béno, fénénginsaa Jesuse bero mano, “Bé késugu guwe begom bé kagom muwit kurta taloo no amaén, brab safatos, wén bay kulang dob begome?” Séménumbul ro maro, “Enda.” ");
INSERT INTO tiy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Endob béleewe,” bang Jesuse, “buluy wéne kurtaén brab amaén, uwité no, brab buluy éndae sundangén, fébéléyén i géruwowe lafin kégalén inok fégébéléyén sundang. ");
INSERT INTO tiy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Non béréhé ku begom i ni, métuman i Ménsulate Kébéréh i Tuluse fantag bé Begéne mano, ‘I ni étéw mékukum maak ségétéw énda ménodorén bé kitab i gémamake kukuman.’ Hoo, i ménsulate fantag bé Begéne féganayén métuman béni.” ");
INSERT INTO tiy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tidéw béno, i de kuyugén maro, “Kadnan, wén i ruwo timan sundang dob ni.” Atin séménumbul i Jesuse mano, “Békén tintu sundang i bénréh guwe begom! Témérén tomén séuret-uret!” ");
INSERT INTO tiy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tidéw béno, ménagéw i Jesuse loo bé adat ne rigoné no mangéy dob tuduke Olibo. Atin ménodor i de kuyugén de. ");
INSERT INTO tiy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Amun gégumah ro dob no gonon, bang Jesuse, “Dasal gom inok énda métukawan gom.” ");
INSERT INTO tiy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tidéw béno, ménférayu bero gumaha témabar. Atin ménlingkuwéd brab déménasal, ");
INSERT INTO tiy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","mano, “Abay, buluk méuyot go de, kago fédayaén Begén mérasay. Endob i kaame kétayan i mérigowe damén, békén kagén kétayan.” ");
INSERT INTO tiy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tidéw béno, i télakiwe tidéw dob lawayo méntéfégito dob Beene brab fénbagérén. ");
INSERT INTO tiy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Bé béno uras, toow fo ménbuku i Jesuse. Brab toow fo émbagér i kédasal ne. Atin ménénét fo toow, brab léménuyut i énét ne dob fantade maak dara. ");
INSERT INTO tiy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Amun énggilid démasal, téménindég ménagéw ménangéy dob de kuyugén. Endob énggito no bero énggéfidong ro non lugotén ro non émbuku ro. ");
INSERT INTO tiy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mélaw nulégén bero mano, “Sedek fidong gom? Tek gom brab dasal gom inok énda métukawan gom.” ");
INSERT INTO tiy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Amun émbéréh sénay Jesuse, énggégumah i médoowe étéw, brab Judasey ségétéwe bé de folo bra ruwo gétéw kuyugén i méngguléwe bero. Fénggédéto noy Jesuse inok aréké no. ");
INSERT INTO tiy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Fénénginsaa Jesuse mano, “Judas, fékéfoém i Nga i Kéilawane bé arék me?” ");
INSERT INTO tiy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Amun énggitoy de kuyug Jesus i ni ménrigo, ménbéréh ro maro, “Kadnan, sétiboh gey bé de sundang gey?” ");
INSERT INTO tiy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Atin i ségétéwe bé de kuyugén ténibohén i riféy gérotore fadi brab ménsilaf i kuwonone kélingoén. ");
INSERT INTO tiy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Endob bang Jesuse, “Ngaén i nan!” Brab génamakén i kélingoéne ménfali, atin ménuwa. ");
INSERT INTO tiy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Atin ménbéréh i Jesuse dob de odoroy de fadi, brab de odoroy de mantay bé lawi i Tuluse, brab de odoroy de Judio mangéy de kéméfo mano, “Sedek ménuwit gom do sundang brab do tafés, maak ségétéwu tulisan kéfoé kom? ");
INSERT INTO tiy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sénga fuweh Betom dob lawi i Tuluse, éndob énda kénéfo gom Begén. Endob méuyot gom rigoné kom i ni béni, non délémon, brab énda i gégito begom.” ");
INSERT INTO tiy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tidéw béno, kénéfo roy Jesuse, brab nuwit ro dob lawi i gérotore fadi. Brab i Pedrowe ménfuray bero, éndob ménférayu kloh. ");
INSERT INTO tiy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Atin wén i aféye nuyag diyo dob kérara i fésayawane brab wén i de ménsar géliwét. Ménsar so diyo i Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Enggitoy ségétéwe kénogon sugu-suguén i Pedrowe brab bénréhén mano, “I étéwe ni dumo no.” ");
INSERT INTO tiy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Endob dénirung Pedrowe mano, “Di, énda gélolo guy nan étéw ménkéfo.” ");
INSERT INTO tiy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Enda ménrugayén, ségétéw man i énggégélolowe bé Pedrowe mano, “Beem soy ségétéwe bero.” Endob séménumbul i Pedrowe mano, “Békén! Békén dumo no begén!” ");
INSERT INTO tiy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Amun ségéuras man tidéw béno, ségétéw man i ménbéréhe mano, “I ni étéw tintu dumo no, non ségétéw étéw so tidéw Galilea.” ");
INSERT INTO tiy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Séménumbul man i Pedrowe mano, “Adih, énda gétiga kuy béréhé muwa nan.” Atin sonom béno, i férufete ménukoro bé émbéréh sénay Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Atin i Kadnane Jesus séménling brab ténéngténgén i Pedrowe. Bé béno so énggétédémo Pedrowey bénréh Jesuse mano, “Enda séna ukoro i férufete béleewe, dirungé mo Begén téléw gule bé énda gélolo mo Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tidéw béno, ménsut i Pedrowe ménangéy dob fuwehe brab toow fo kéménrew. ");
INSERT INTO tiy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Atin i de étéw mantayan bé Jesuse féganayé ron tafésén brab diyangkaén. ");
INSERT INTO tiy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tidéw béno, ténléb roy de moto no bé munsalawe brab féantuk ro de ké ati téménafése de. ");
INSERT INTO tiy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Brab toow ro fo fénémalay Jesuse bé tetee kébéréh ro. ");
INSERT INTO tiy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Amun géfuwénén, i de odoroy de Judio, brab de odoroy de fadi, brab do témoro bé kitabe, ménsélimud ro, brab fén-uwit roy Jesuse dob téngaanga ruwe. ");
INSERT INTO tiy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Atin fénénginsaa roy Jesuse maro, “Buluk Beem i Kristowe, sani fénémili i Tuluse méguléw, béréhém begey.” Atin séménumbul i Jesuse mano, “Fiyon fo ké béréhé ku begom, énda méginugut gom de. ");
INSERT INTO tiy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Atin buluk wén i fénginsaé ku begom, énda sumbulo kom de. ");
INSERT INTO tiy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Endob tidéw béleewe, i Nga i Kéilawane fésarén dob kuwonoy barakatane Tulus.” ");
INSERT INTO tiy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mélaw fénénginsaa roy Jesuse maro, “Aw Nga i Tuluse Beem?” Atin séménumbul i Jesuse mano, “Toow i nan bénréh gom bé Nga i Tuluse Begén.” ");
INSERT INTO tiy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tidéw béno, ménbéréh ro maro, “Endaén kailanga tom i témboe de dob betome. Non énggélingoo tomén tidéw dob Beene.” ");
INSERT INTO tiy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tidéw béno, i kéluhana ruwe ménlimud, nuwit roy Jesuse mangéy dob Pilatowe sani méguléwe tidéw Roma. ");
INSERT INTO tiy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nuret ro dob Pilatowey kéluhanay de tete rénigo Jesuse kun. Bénréh ro maro, “Enggito gey i ni étéw fanangguwité noy de étéw inok sébanil ro begom do gémamak kukuman. Enda fébayade no bero buwis dob toowe fo gérotor datu féndawét Sesar dob Roma. Bénréhén so bé Beene kun i Kristowe sani ségétéwe datu.” ");
INSERT INTO tiy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tidéw béno, fénénginsaa Pilatowey Jesus mano, “Aw Beem i Datu i de Judio?” Séménumbul i Jesuse mano, “Beemey ménbéréhe de.” ");
INSERT INTO tiy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Atin bang Pilatowe dob de odoroy de Judio brab dob kéluhanay de étéw diyo, “Karangé ku, énda i funa no fatut mékukum.” ");
INSERT INTO tiy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Endob fétausé ro soy kétébo ruwe de maro, “I ni étéw téménoro dob kéluhanay sugud i de ingéd dob Judea fanangguwité noy de étéw sétiboh begom do gémamak kukuman. Féngganayén rénigoy ni dob Galilea, atin ménangéy dini inok rigoné no so.” ");
INSERT INTO tiy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Amun énggélingoo Pilatowey ni, ménénginsa mano, “Aw tidéw Galilea i ni étéw?” ");
INSERT INTO tiy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Amun énggétiga no tidéw diyo, sénugu Pilatowey Jesuse mangéy dob Herode, sani datue dob Galilea, non diyo dob Jerusalem bé no gai. ");
INSERT INTO tiy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ménoror i Herode bé kégito nuwe bé Jesuse. Non médooy énggélingoo nuwe fantag bé Jesuse, brab ménrugayén i kéuyot ne de géségito. Témayan de damén ké gito noy Jesuse rémigo mékégaif. ");
INSERT INTO tiy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mélaw médooy fénénginsa ne bé Jesuse. Endob énda séménumbul i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Diyo soy de odoroy de fadi brab de témoro bé kitabe. Atin toow ro fo ténébo i Jesuse. Endob énda soy sumbul Jesuse de. ");
INSERT INTO tiy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mélaw i Herode brab de sundalo no, déniyangka ro brab fénémala ro. Tidéw béno, fénkégala roy Jesuse bé toowe fo fiyo métaah kégal maak datu brab fénséfule ro mangéy dob Pilatowe. ");
INSERT INTO tiy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tidéw béno, i Herode brab Pilatowe ménwaléy ro sékélayaman, fiyon fo ké sébanil ro méntaén. ");
INSERT INTO tiy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ténawag Pilatowey de odoroy de Judio, brab de odoroy de fadi, brab de ségiyo-giyo étéw. ");
INSERT INTO tiy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Atin bénréhén bero mano, “Nuwit gom i ni étéw Jesus dob begéne, brab bénréh gom fanangguwité noy de étéw gom sétiboh begey do gémamak kukuman. Endob béleewe fénénginsaa ku dob adafa kome, atin énggétiga ku énda i toow bé kéluhanay bénréh gome. ");
INSERT INTO tiy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","I datu Herode énggétiga no so énda i salaén loo bé de bénréh gom, mélaw fénséfuleén so mangéy dini. I ni étéw énda i rénigo no tete. Békén fatut féléhuén. ");
INSERT INTO tiy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mélaw fébadas gu saén, tidéw béno fétangéy gu.” ");
INSERT INTO tiy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","I ni ménrigo bé gaiy kékandulie “Témara”. Atin i adat i méguléwe tidéw Roma sénga kanduli “Témara” témangéy ségétéw ménkalabusu inok fiyoy fédéw i de Judio de. ");
INSERT INTO tiy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mélaw non énda kukumé Pilatowey Jesuse féléhuén, i de étéw ménsélimud ménkes maro, “Féléhu gom, brab tangéy gom i Barabase.” ");
INSERT INTO tiy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(I Barabase ni étéw ménférisu non ménamung sétiboh dob Jerusalem bé de gémamak kukuman. Ménméléhu so do étéw.) ");
INSERT INTO tiy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","I Pilatowe ménbéréh man ségule dob de étéw ménsélimud bé i kétaya nuwey Jesusey tangéyéne. ");
INSERT INTO tiy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Endob ménkes i de étéw maro, “Féléhu gom! Kélabo gom dob kruse!” ");
INSERT INTO tiy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Endob ménbéréh i Pilatowe bé gétéléw ne gule mano, “Ati rénigoy ni étéw? Enda i gétiga ku funa tom de méméléhu. Fétafés gu sa atin tangéyén.” ");
INSERT INTO tiy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Endob i de étéw ménkes ro man minut métanug i Jesuse kélabonén dob kruse. ");
INSERT INTO tiy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tidéw béno, sabaf bé kéékes ruwe, ménagayun i Pilatowe bé kéongot ruwe kémukum bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Atin loo bé kétaya ruwe, ténangéyén i Barabase, sani étéwe férisu sabaf bé beeney ségétéwe méméléhu brab fénsétibohén i de étéw sébanil bé de gémamak kukuman. Atin i Pilatowe nirayén i Jesuse dob de étéw ménsélimud inok rigoné roy ati kétaya ruwe rigonén dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nuwit i de étéw i Jesuse mésut dob Jerusalem inok kélaboné ro dob kruse. Atin dob de aguwon, énggébalaka roy étéwe féndawét Simon tidéw dob ingéde Siren. Béno sénay kégumah ne dob no ingéd. Fénodor ro inok fégésé ro démuwal bé kruse furay bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","I médoowe étéw furay bé Jesuse. I de dumo bero do libun kémérew ro brab rémuung non bé kérigo ruwe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sénling Jesuse bero mano, “Do libun tidéw Jerusalem, kagom kérewon Begén. Kérewo kom i de lowoh gom brab de nga gom. ");
INSERT INTO tiy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Non gégumah i gaiwe mérégén brab émbéréh i de étéw maro, ‘Méoror i de libun énda mén-obor ro, énda i do nga ro, brab énda i féntutu ro do nga.’ ");
INSERT INTO tiy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bé no gai, émbéréh i de étéw dob de tuduk maro, ‘Tamfurén gey!’ brab dob de burur, ‘Bunéyén gey!’ ");
INSERT INTO tiy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Non buluk rigonéy de étéw i ni dob ségétéwe étéw énda i rénigo no tete, toow na fo mas gétimal dob de étéw réménigo tete.” ");
INSERT INTO tiy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Atin ménuwit ro so ruwo gétéw férisu inok séréngan ro féléhuén bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Amun ménggégumah ro dob no gonon féndawét “kulobong uléw”, kénlabo ro diyo i Jesuse dob kruse ni. Kénlabo ro soy ruwowe gétéw férisu dob de krus. I sébaane de fingé dob kuwono Jesuse, brab i sébaane de dob fingé biwong Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tidéw béno, déménasal i Jesuse mano, “Abay, fésagada mo bero non énda gétiga roy rigoné ruwe.” Atin i de sundalo sénkungkungo roy ati gégédote bé kégal Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","I lala i de étéw téménindég diyo témanud, i de odoroy de Judio déniyangka roy Jesuse maro, “Ténabangén i de ségiyo étéw inok énda méléhu ro. Mélaw, buluk Beeney Kristowe tintu Mémukas fénémili i Tuluse, sedek énda gétabanga noy lowoh ne inok énda méléhuén?” ");
INSERT INTO tiy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Déniyangka i de sundalo so. Atin téningé ro brab niraya ro bé mélémuwe arak brab ménbéréh ro maro, ");
INSERT INTO tiy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Buluk Beemey datu i de Judio, tabangém i lowoh me.” ");
INSERT INTO tiy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Brab wén i ménsulate dob rotor i uléw Jesuse mano, “Ay niy datu i de Judio.” ");
INSERT INTO tiy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Atin i ségétéwe bé de férisu ménbitin diyo bero Jesuse, diyangkaé no soy Jesuse mano, “Aw békén ba Beemey Kristowe Mémukas? Mélaw tabangém begey brab i kaame lowoh.” ");
INSERT INTO tiy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Endob i dumo nuwe férisu ménbéréh dob sunguwe de mano, “Kago émbéréh loo bé nan! Aw énda mégilak go bé Tuluse? I betome téléw gétéw ménkukum féléhuén. ");
INSERT INTO tiy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Atin i betowe fatut féléhuén non bé de tete rénigo to. Endob i ni étéw énda foy tete rénigo no.” ");
INSERT INTO tiy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tidéw béno, ménbéréh dob Jesuse mano, “O Jesus, fégétédéménu amuk Beemén i méguléwe.” ");
INSERT INTO tiy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Séménumbul i Jesuse mano, “Béréhé ku beem i toowe, béleewe séko diyo go dob Begéne dob bélowono fantad.” ");
INSERT INTO tiy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Amun géutuhén, éndaén réméndaw i térésange. Déménlémon i fantade taman ménifus i téléwe géuras. ");
INSERT INTO tiy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tidéw béno, i rindunge bénitin dob mékétéfuwe sibéy dob lawi i Tuluse, ruwoy ménsésédaya nuwe. ");
INSERT INTO tiy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Atin i Jesuse ménkes métanug mano, “Abay, sarigé kuy kamatu guwe dob Beeme.” Amun énggébérého noy ni, ménléhu i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wén i ségétéwe gérotor odoroy de sundalo énggito noy ni ménrigo, atin dénayéwén i Tuluse mano, “Toow fo métintuy ni étéw!” ");
INSERT INTO tiy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","I de étéw ménsélimud diyo, amun énggito roy ni ménrigo, ménule ro ménmala brab tete i de fédéw ro. ");
INSERT INTO tiy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Atin i kéluhanay de étéw énggébalaka roy Jesuse, fiyon i médoowe bé de libun tidéw Galilea ménodor de, téménindég ro dob mérayue téméngténg brab énggito ro soy kéluhanay ni ménrigo. ");
INSERT INTO tiy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Wén i ségétéwe lagéy féndawét Jose tidéw Arimatea sébaan ingéd dob Judea. Ségétéw fiyo étéw brab ménunur bé de kukumay de Judio. ");
INSERT INTO tiy_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Fiyon fo ké beeney ségétéwe bé de kéfédéway de Judio, énda ménagayu no bé rénigo ruwe bé Jesuse. Ongot-ongoté no soy gaiy kéféguléw i Tuluse bé de étéwén. ");
INSERT INTO tiy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ménangéy dob Pilatowe brab nongotén i bangkay Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Atin éndotén i bangkay Jesuse tidéw dob kruse brab bénausén bé fiyowe safut, brab nahurén dob lébénge ténosong dob rangih i fingase. I ni lébéng énda séna ménlébéngo no. ");
INSERT INTO tiy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","I gaiwe béno témégén Biyarnes brab gédétén i gaiwe Sabado sani gaiwe kétéréy de Judio. ");
INSERT INTO tiy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","I de libun ménodor bé Jesuse tidéw Galilea, ménfuray ro bé Josehe brab énggito roy lébénge brab ati kéahure bé bangkay Jesuse diyo. ");
INSERT INTO tiy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tidéw béno, ménule ro brab téménafay ro fégéféamut brab do mamut daun kay bangkay Jesuse. Endob bé gaiwe kétérén, téménrén ro loo bé kébéréh i de kukuman nodoro ro. ");
INSERT INTO tiy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Amun toow fo géfuwén bé no Duminggu, i de libun ménodor bé Jesuse tidéw Galilea, ménangéy ro dob lébéng Jesuse. Nuwit roy mamute daun ténafay ro. ");
INSERT INTO tiy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amun énggégumah ro dob lébéng ne, énggito roy batéwe fénggétéléb bé béngaway lébénge ni ménkériring. ");
INSERT INTO tiy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tidéw béno, ménahur ro, éndob i bangkay Jesuse éndaén diyoén. ");
INSERT INTO tiy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I lala ruwe témindég mégaif, méntékow méntéfégitoy ruwowe gétéw lagéy, sémélinang i de kégal ro. ");
INSERT INTO tiy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Toow fo ménggilak i de ni libun, mélaw déménungul ro. Tidéw béno, ménbéréh i de lagéy ni maro, “Sedek mangéy gom dob lébénge séméléd bé ségétéwe étéw méuyag? ");
INSERT INTO tiy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Endaén dini no, non ténébule i Tuluse nén. Fégétédém gom i de kébéréhén begom diyo de séna dob Galilea mano, ");
INSERT INTO tiy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘I Nga i Kéilawane iray dob de tete étéw atin kélaboné ro dob kruse. Endob dob gétéléw ne gétérésang, tébule.’ ” ");
INSERT INTO tiy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tidéw béno, i de libun ni, énggétédémo roy bénréh Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mélaw ménagéw ro tidéw dob lébénge brab nuret ro dob de folo bra sébaan kuyug Jesuse brab dob kéluhanay de dumo étéw i kéluhanay énggito ruwe brab énggélingoo ruwe. ");
INSERT INTO tiy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(I ni do libun ro Maria Magdalena, Juana, brab Mariawe idéng Santiago, brab de dumo libun, nuret roy de ni dob de apostol.) ");
INSERT INTO tiy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Endob i de kuyug Jesus, énda ménunur ro bé bénréh i de libun ni, non maro ké dufang saén i kébéréh ruwe de. ");
INSERT INTO tiy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Endob i Pedrowe ni ségétéw bé de kuyug Jesus téménindég brab léménéntu mangéy dob lébénge. Amun énggégumah diyo, sénarirén ténéngténg, atin énggito no say de safut fénggébaus bé bangkay Jesuse, ménféled. Mélaw ménule ménggaif bé no ménrigo. ");
INSERT INTO tiy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Atin bé béno gai, wén i ruwo gétéw bé de kuyugén ménangéy dob sébaane ingéd fédawétén Emaus, folo bra ruwo gékilometroy kérayu ne tidéw Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amun diyo ron dob de aguwon, ménséuret-uret ro fantag bé kéluhanay de ménrigo bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","I lala ruwe séuret-uret magéw so, bé béno soy Jesuse ménggégumah séodor béro magéw. ");
INSERT INTO tiy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Endob nalang ro fégéloloné ro ké Been i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Atin fénénginsaa Jesuse bero mano, “Ati nan ureté kom bé lala goma nan magéw?” Tidéw béno, téménrén ro magéw brab ménbuku i falas ruwe. ");
INSERT INTO tiy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ségétéw bero féndawét Kleopas ménbéréh dob Jesuse mano, “Beem saén keeyén i étéwe bati dob Jerusalem, énda gétiga moy atiy ménrigowe diyo bé de ni gai.” ");
INSERT INTO tiy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ménénginsa i Jesus mano, “Ati no ménrigo?” Séménumbul i de kuyugén maro, “Fantag bé Jesuse tidéw Nasaret, ségétéw sénarigoy Tuluse muret. Barakatan i de kébéréhén brab de rénigo no dob téngaangay de étéw brab dob Tuluso. ");
INSERT INTO tiy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","I uléwoy de fadi gey brab de odoro key fénkéfo roy Jesuse inok kukumén brab féléhuén kélabonén dob kruse. ");
INSERT INTO tiy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wénén i inam gey bé Beene damén i mémukase betom do Judio. Atin béleewe niy gétéléwo nuwe gétérésangan tidéw bé no ménrigo. ");
INSERT INTO tiy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Brab wén i de dumo gey do libun, fénggaif ro begey non ménangéy ro dob lébénge toow fo gino géfuwén. ");
INSERT INTO tiy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Endob amun sénléd roy bangkay ne, énda énggito ro de. Atin ménséfule ro, brab bénréh ro bé wén i de télaki méntéfégito émbéréh bé Jesuse méntébule. ");
INSERT INTO tiy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tidéw béno, i de dumo begey do kuyug Jesus ménangéy ro so dob lébéng Jesuse ni, brab énggito roy kéluhanane toow ménrigo loo bé kébéréh i de libun ni, éndob énda gito roy bangkay Jesuse.” ");
INSERT INTO tiy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tidéw béno, bénréh Jesuse bero mano, “Toow gom fo dufang, brab énda munur gom bé bénréh i sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Békén ba kailangan mérasay i Kristowe atin tidéw béno médayéw fo toow?” ");
INSERT INTO tiy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tidéw béno, fénggétiga Jesuse dob berowe ké atiy ménsulate dob libro Moisese brab i sénulat i kéluhanay sénarigoy Tuluse fantag bé Beene. ");
INSERT INTO tiy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Amun gédét ro nén dob ayo ruwe ni, i Jesuse ni fénténgténgén bé maak taus magéw mangéy férayu. ");
INSERT INTO tiy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Endob nongot ro bé Jesuse maro, “Odor go begey témérén non gédétén sémingkuf.” Mélaw ménodor i Jesuse bero mahur dob lawie. ");
INSERT INTO tiy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Amun diyo ron ménsar dob doror i ahayane, méndot i Jesuse fan brab fénsalamata no. Tidéw béno, sénkébeng-kébengén, atin sénaarén dob berowe. ");
INSERT INTO tiy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tidéw béno, énggélolo roy Jesuse, éndob tékow ménalfa dob téngaanga ruwe. ");
INSERT INTO tiy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tidéw béno, ménsébéréh-béréh ro maro, “Been i funa tuwe toow fo fiyoy de fédéw to brab toow fo méoror to bé késébéréh-béréh ne beto amun diyo to dob de aguwon atin bé lala ne mureton beto fantag bé Ménsulate Kébéréh i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bé béno so, téménindég ro brab ménséfule ro mangéy Jerusalem. Diyo énggito roy de folo bra sébaan ménsélimud beroy de dumo kuyugén. ");
INSERT INTO tiy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Atin séuret-uret ro maro, “I Kadna tome toow méntébule, non méntéfégito dob Simone.” ");
INSERT INTO tiy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tidéw béno, nuret i ruwowe gétéw dumo roy ménrigowe dob de aguwon, brab ati kégélolo ruwe de bé de sékébeng-kébengén fan. ");
INSERT INTO tiy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","I lala ruwe séuret-uret, méntéfégitoy Jesuse téménindég dob kérara ruwe ménsébéréh bero. ");
INSERT INTO tiy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Endob toow fo mégilak ro non maro ké ménayam i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mélaw ménbéréh man i Jesuse mano, “Sedek mégilak gom? Aw mérégén i kéunur gome ké méuyagu? ");
INSERT INTO tiy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Téngténg gom i de kémér gu ni brab de sékéy gu ni. Gito gom? Toow, Begén. Gamakénu inok gétuwa kom békénu ménayam. I ménayame énda i ungéén brab énda i bukalén. Endob gito gom, wén i kagén de.” ");
INSERT INTO tiy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tidéw béno, fénténgténg Jesusey de kémérén brab de sékéyén. ");
INSERT INTO tiy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Toow ro fo ménggaif brab énda géféngintoow ro de, non toow fo fiyo damén ké toow. Mélaw i Jesuse fénénginsaa no bero mano, “Wén i féama gom Begén?” ");
INSERT INTO tiy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Atin niraya ro sébaan sédo, ");
INSERT INTO tiy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","atin éndotén brab namaén dob adafa ruwe. ");
INSERT INTO tiy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Atin bénréhén bero mano, “Been soy ni mérigowe bénréh gu begom amun diyou dob begome séna bé énda séna méléhuu. Nuret guy métuman i kéluhanane fantag bé Begéne dob de sénulat Moises brab de sénulat i de sénarigoy Tuluse muret, brab dob de sénulatén kanta dob Ménsulate Kébéréh i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tidéw béno, fénggétiga Jesuse dob berowe inok gésobuto roy Ménsulate Kébéréh i Tulus. ");
INSERT INTO tiy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bénréhén man bero mano, “Wén i Ménsulate Kébéréh i Tuluse bé i Kristowe mékukum, éndob dob gétéléw ne gétérésang tébule. ");
INSERT INTO tiy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Atin sabaf bé atura kuwe fatut ureté kom dob kéluhanay de étéw bé kailanga ro gésénule bé de sala ro brab rigoné roy kétayay Tuluse inok fésagaday Tuluse bero. Uret gom étah dob de étéw dob Jerusalem, tidéw béno dob kéluhanay de étéw dob duniyae ni. ");
INSERT INTO tiy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Fatut ureté kom non begomey de énggégito bé de ni ménrigo. ");
INSERT INTO tiy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sugué ku mangéy dob begomey ati fénasad i Abay guwe. Endob ongot-ongot gom dob Jerusalem taman gégumah i barakate dob begome.” ");
INSERT INTO tiy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tidéw béno, nuwit Jesusey de kuyugén ménsut dob no ingéd taman Betania. Amun ménggumah ro diyo, ténunggulén i de kémérén brab déménasal dob Tuluse inok féfiyoné no bero. ");
INSERT INTO tiy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","I lala ne rémigo bé ni, déméniyat mangéy dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Atin fénéngadaf roy Jesuse, brab ménoror ro séfule mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Atin diyo ménangéy ro sénga tékélid dob lawi i Tuluse fésalamat bé Tuluse.");
INSERT INTO tiy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dob féganaye wénén i féndawéte “Kébéréh i Tuluse”, sani Kristowe. Atin i Beene beroy Tuluse. Brab Beeney Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Beroy Tuluse bé féganaye. ");
INSERT INTO tiy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Atin fénlimbag i Tuluse bé Kristowey kéluhanay éntingayéne. Enda i éntingayén ménlimbag ké békén Kristowey léménimbage de. ");
INSERT INTO tiy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dob Beeney umule brab i nan umul maak Solo réméndaw dob de kéilawan. ");
INSERT INTO tiy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I ni Solo réméndaw dob délémone brab énda géfandaay délémone de. ");
INSERT INTO tiy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wén i ségétéwe étéw sénugu i Tuluse, i dawét ne Juan Bautista. ");
INSERT INTO tiy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ménangéy dini muret fantag bé nan Solo inok i kéluhanane mégélingo de brab munur bé nan Solo sani Kristowe. ");
INSERT INTO tiy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Békén Juaney Soloe, éndob ménangéy saén dini muret fantag bé nan Solo. ");
INSERT INTO tiy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tidéw béno, i toowe Solo énggégumah dob duniyae inok réméndaw dob kéluhanay kéilawane. ");
INSERT INTO tiy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mélaw i Kristowe dininén dob duniyae. Endob fiyon fo ké Beeney léménimbage de, énda géloloy de kéilawan de. ");
INSERT INTO tiy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ménangéy dob kaane ingéd, éndob i de kaan étéw énda ténayakuf ro de. ");
INSERT INTO tiy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Endob i kéluhanay téménayakufe de brab ménunure dob Beene, niraya no bero kuwagib waléy nga i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ménwaléy ro nga i Tuluse békén sabaf bé rénigoy de étéw taloo no aturay kéilawane mumah ro, yamula sabaf bé aturay Tuluse saén. ");
INSERT INTO tiy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I Kristowe ménwaléy kéilawan, ménbati sétifon betom. Enggito gey i barakat ne tidéw dob Abayo Tulus, non been i buntunge Ngaén, toow fo mégédaw brab toow fo toow i kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ménuret i Juan Bautistawe fantag bé Kristowe. Ménbéréh métanug mano, “Been i niy bénréh guwo begom gégumah témundug begén, éndob gérotor na begén, non bé énda séna ménumahu de, ménwénén.” Been i bénréh Juane. ");
INSERT INTO tiy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tidéw dob toowe kégédawén betom, énda téméré no miray do kéfiyonon dob betome kéluhanan. ");
INSERT INTO tiy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Non i Tuluse nirayén i kukumane fén-uwitén bé Moisese, éndob i gédawe brab toowe kétoro fén-uwitén bé Jesu Kristowe. ");
INSERT INTO tiy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Enda i ségétéw énggégito bé Tuluse. Endob i Buntunge Ngaén, fénggétiga noy fantage bé Abay ne non sédumon ro. Brab i Ngae, Tulus so. ");
INSERT INTO tiy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","I de odoroy de Judio dob Jerusalem, séménugu ro do fadi brab do témabang bé de fadi féndawét do Lebita mangéy ménginsa dob Juane, ké ati beene. ");
INSERT INTO tiy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","I Juane, bénréhén i mékéntaye brab toowe mano, “Békén begéney Kristowe, sani fénémili i Tuluse méguléw.” ");
INSERT INTO tiy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Atin fénénginsaa ro man maro, “Ati mélaw i beeme ni? Aw méntélata Elias go?” Séménumbul man i Juane mano, “Békén.” Atin ménénginsa ro man maro, “Aw beemey nan sarigon muret bé kébéréh i Tuluse?” Atin séménumbul man i Juane mano, “Békén.” ");
INSERT INTO tiy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Atin ménbéréh ro man maro, “Béréhém begey ké ati beeme ni, inok gébérého key dob de séménugu begey. Ati gébérého muwe fantag bé beeme?” ");
INSERT INTO tiy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","I Juane séménumbul niringén i kébéréh Isaiase sani méntélatae sénarigoy Tuluse muret bé kébéréh ne mano, “Begéney ségétéwe dob gonone énda i étéw de bati, mékes maku, ‘Fééntang gom i aguwoy Kadnane.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Atin i de sénugu tidéw dob de Fariseo, ménénginsa ro man maro, ");
INSERT INTO tiy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Amuk békén go Kristo, taloo no Elias, taloo no sarigon muret, sedek mautis go?” ");
INSERT INTO tiy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Séménumbul i Juane mano, “Wayég i fégébautis guwe, éndob wén i ségétéwe étéw ménggélawék begom énda gélolo gom de. ");
INSERT INTO tiy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Been i gégumahe témundug begén, éndob toow na fo gérotor begén. Mélaw énda médaitu fiyon mukoh bé ikét i safatos ne.” ");
INSERT INTO tiy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ménrigoy ni dob Betania, diyo dob sébangay wayége féndawét Jordan, gono Juane mautis. ");
INSERT INTO tiy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Dob sébaane de fuweh, énggito Juaney Jesuse mangéy dob beene, brab ménbéréh dob de étéw mano, “Téngténg gom, ay ni nén i maake fégétulak nati bili-bili niray i Tuluse non féléhuén inok mékédan i de sala i de étéw dob duniyae. ");
INSERT INTO tiy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Been i niy bénréh guwo maku, ‘Wén i ségétéwe étéw gégumah témundug begén, éndob gérotor na begén, non bé énda séna ménumahu de, ménwénén.’ ");
INSERT INTO tiy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Bé gétahe de, énda gélolo gu de, éndob i funa kuwe ménangéy dini mautis bé wayége inok émfayag i Beene dob begome do dumo gu Judio.” ");
INSERT INTO tiy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Atin ménbéréh man i Juane mano, “Enggito guy Rémogor i Tuluse ménlus tidéw dob lawayo maak marafati méntérimféna mangéy dob Beene. ");
INSERT INTO tiy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Enda damén gétiga ku de saliyu bé Tuluse, sani séménugue begén mautis bé wayége, ménbéréh dob begéne mano, ‘I étéwe gito mo térimfénaay Rémogor guwe, Beeney mautise bé Rémogor guwe.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Atin féntaus Juaney kébéréh ne mano, “Enggito gu, brab gébérého kuy Beeney Nga i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Dob sébaane de fuweh, diyo man i Juane beroy de ruwo gétéw kuyugén. ");
INSERT INTO tiy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Amun énggito noy Jesuse témara, ménbéréh mano, “Téngténg gom, ay nan i natiwe bili-biliy Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Amun énggélingooy de ruwo gétéw kuyugén i ni bénréhén, ménfuray ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Atin séménling i Jesuse brab énggito no bero furay dob Beene. Atin fénénginsaa no bero mano, “Ati kétaya kome?” Tidéw béno ménbéréh ro maro, “Hon i batio muwe de, Rabi?” (I atag i Rabiwe Maistéro.) ");
INSERT INTO tiy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Enggomén, inok gito gom,” bang Jesuse. Atin ménodor ro, brab énggito roy batio nuwe. I urase béno, témégénén. Mélaw énda ménule ro taman kélungonon. ");
INSERT INTO tiy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","I ségétéwe bé de ruwo ni gétéw lagéy énggégélingo bé bénréh Juane brab ménodor bé Jesuse, sani fédawéténe Andres dumo Simon Pedrowe sétiman idéng. ");
INSERT INTO tiy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","I sungu-sunguwe rénigo Andrese, sénlédén i Pedrowe brab nureto no mano, “Enggito gey i Kristowe.” (I atag i Kristowe fénémili i Tuluse méguléw.) ");
INSERT INTO tiy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tidéw béno, nuwitén i Simone mangéy dob Jesuse. Atin ténéngténg Jesuse brab bénréhén mano, “Beemey Simone, nga Jonas. Fédawété ku beem Sefas.” (I Sefase ségiléw bé dawéte Pedro, atin i atag ne batéw.) ");
INSERT INTO tiy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dob sébaane de fuweh, bénaba Jesusey mangéye Galilea. Brab énggito noy Filipiwe, atin ménbéréh dob beene mano, “Odor go Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","I Filipiwe, ségiléw bé Andrese brab Pedro, tidéw ro dob ingéde féndawét Betsaida. ");
INSERT INTO tiy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Atin i Filipiwe, ménangéy dob Natanaele atin bénréhén dob beene mano, “Enggito gey i étéwe, sani étéwe sénulat Moisesey fantage bé Beene dob kukumane bé do gétah, brab sénulat i de sénarigoy Tuluse so muret bé kébéréh ne. Beeney Jesuse, nga Jose, tidéw Nasaret.” ");
INSERT INTO tiy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Atin ménénginsa i Natanaele dob Filipiwe mano, “Aw wén wayoy éntingayén fiyo tidéw Nasaret?” Bang Filipiwe, “Enggonén, angéyém téngténg.” ");
INSERT INTO tiy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Amun énggito Jesusey Natanaele mangéy dob Beene, ménbéréh mano, “Ay niy métintuwe étéw Judio. Enda i tugi dob adat ne.” ");
INSERT INTO tiy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Ati kégétiga muwe begén?” bang Natanael. Séménumbul i Jesuse mano, “Enggito gu beem dob fantad i kayéwe féndawét igos bé énda séna ténawag Filipiwe beem.” ");
INSERT INTO tiy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tidéw béno, fénayag Natanaele mano, “Maistéro, Beemey Nga i Tuluse brab Datu gey do Judio.” ");
INSERT INTO tiy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ménbéréh i Jesuse mano, “Aw ménunur go saén sabaf bé bénréh guwe beem énggito gu beem dob fantad i kayéwe igos? Gégito go na médoo éntingayén rigoné ku toow fo mékégaif na tidéw bé ni. ");
INSERT INTO tiy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Béréhé ku begom i toowe, gito gom moso i lawaye émbukeh brab i de télakiy Tuluse ménik brab mélus dob Begéne, sani Nga i Kéilawane.” ");
INSERT INTO tiy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ménruwo gétérésangan tidéw béno, wén i uyot dob Kana, sébaan ingéd dob Galilea. Atin i idéng Jesuse diyo dob uyote ni. ");
INSERT INTO tiy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Diyo soy Jesuse brab de kuyugén non sénéngkat ro so bero dob ni uyot. ");
INSERT INTO tiy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Amun ménétéyén i arake, ménbéréh i idéng Jesuse dob Beene mano, “Endaén i arak ro.” ");
INSERT INTO tiy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Endob séménumbul i Jesuse mano, “Iday, kago suguén Begén. Enda séna énggumah i gai guwe émfégito bé barakat guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tidéw béno, i idéng Jesuse ménbéréh dob de sugu-suguén mano, “Rigo gom i kéluhanay béréhé nuwe begom.” ");
INSERT INTO tiy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Wén i ném timan do dakél binangga diyo, usaréy de Judio ahuron wayég fégéféguse ro loo bé adat ruwe. (Labi téléw folo gélaya i kédakél i séngae binangga.) ");
INSERT INTO tiy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Bénréh Jesuse dob de sugu-suguén mano, “Féno gom wayég i de binangga.” Mélaw fénéno ro wayég i de binangga déméngér ké toow fo féno. ");
INSERT INTO tiy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tidéw béno, bénréhén bero mano, “Sakug gom de kloh, brab uwit gom dob méguléwe bé ni uyot.” Atin rénigo ro. ");
INSERT INTO tiy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amun i méguléwe bé uyote ménggétemtem de, békénén wayég, non ménwaléyén arak. Atin énda énggétiga noy ténidéwoy ni de arak. Endob gétigay de sugu-suguén séménakug de. Tidéw béno, i méguléwe ni ténabarén i témérimawe lagéy. ");
INSERT INTO tiy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Brab ménbéréh mano, “Dob de dumo do karagiya, i de étéw duwoté ro métah i fiyowe arak, brab buluk énggéinémén témantuy kéluhanay kanawe, tidéw béno duwoté roy mélémuwe de. Endob i beeme dénuwotém wayoy toowe balilaga arak géfuray béni!” Been i bénréh i uléwe. ");
INSERT INTO tiy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Rénigo Jesusey ni sungu mékégaif dob Kana, ingéd dob Galilea. Fénggito noy barakat ne diyo, atin i de kuyugén ménunur dob Beene. ");
INSERT INTO tiy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Amun énggilidén i uyote, i Jesuse brab idéng ne, brab de tuwaréyén, brab de kuyugén, ménagéw ro mangéy Kapernaum. Atin ménbati ro diyo bé ménfiroye gétérésangan. ");
INSERT INTO tiy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gédétén i kandulie féndawét “Témara” kay de Judio, mélaw ménénagé i Jesuse mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dob fésayaway lawi i Tuluse, énggito noy de étéw émfébéléy do fégétulak safi, bili-bili, marafati. Brab énggito no soy de lémuluk kurta ménsar dob sékuloy de ahaya ro. ");
INSERT INTO tiy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mélaw réménigo fégétafésén taléy brab dénédélén bero tidéw dob lawi i Tuluse. Dénédélén soy de safi brab do bili-bili. Atin bénluweén i de ahayay de lémuluk kurta brab sénawarén i de félatah ro. ");
INSERT INTO tiy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Atin ménbéréh dob de émfébéléy marafati mano, “Uwit gom tékédan i de ni. Kagom rigonén fadiyan i lawi i Boh guwe!” ");
INSERT INTO tiy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Atin énggétédémoy de kuyugén i Ménsulate Kébéréh i Tuluse mano, “O Tulus, i kéimu guwe bé lawi me, maak aféy dob fédéw guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Atin i de odoroy de Judio ménénginsa ro dob Jesuse maro, “Amuk wén i kuwagibém tidéw dob Tuluse bé ni rénigo mo, fégitonon gey mékégaif émféféngintoow de.” ");
INSERT INTO tiy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sénumbulo Jesuse bero mano, “Rundas gom i lawi i Tuluse ni, atin fétindégé ku man bé téléwe gétérésangan.” ");
INSERT INTO tiy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Séménumbul i de Judio maro, “I ni lawi Tulus, mén-fot folo bra ném gébélintuwa i kéfétindége de, atin fétindégé mo man bé téléwe gétérésangan saén?” ");
INSERT INTO tiy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Endob i lawi i Tuluse béréhé Jesuse, been i lowoh ne. ");
INSERT INTO tiy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Amun gilid méntébule i Jesuse, énggétédémoy de kuyugén i bénréh ne. Atin ménunur ro bé Ménsulate Kébéréh i Tuluse brab de bénréh Jesus. ");
INSERT INTO tiy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bé kédiyo Jesuse dob Jerusalem, bé gaiy kékanduli i de Judio féndawét “Témara”, médooy méngginugute bé Jesuse non énggito roy médoowe mékégaif rénigo no. ");
INSERT INTO tiy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Endob énda séménarig i Jesuse bero non gétiga noy kéluhanay étéwe. ");
INSERT INTO tiy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Enda kailanga no ureton fantag bé étéwe non gétiga noy fédéw i kéilawane. ");
INSERT INTO tiy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wén i ségétéwe étéw féndawét Nikodemo, ségétéw bé de Fariseo sani de tintu modor bé adat i de Judio. Brab i Nikodemowe odoroy de Judio. ");
INSERT INTO tiy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wén i no sébaan kélungonon, ménangéy dob Jesuse atin ménbéréh mano, “Maistéro, gétiga key ségétéw go témoro tidéw dob Tuluse. Non énda i ségétéw gérigo bé de rigoné mo mékégaif ké békén tidéw dob Tulusey barakat ne.” ");
INSERT INTO tiy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Séménumbul i Jesuse mano, “Béréhé ku beem i toowe, énda i ségétéw géahur dob féguléwoy Tuluse, saliyu ké mumah na féruman.” ");
INSERT INTO tiy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Endob ménénginsa i Nikodemowe mano, “Ati kéfingé-fingé i kéumah i étéwe féruman ké lukésén? Endaén géahurén séruman dob sur i idéng ne atin mumah man!” ");
INSERT INTO tiy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Séménumbul i Jesuse mano, “Béréhé ku beem i toowe, saliyu ké i étéwe mumah bé wayége brab bé Rémogor i Tuluse, énda géahurén dob féguléwoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","I kéluhanay étéwe mumah dob kéilawane brab gédoté roy lowohe. Endob i de étéw mumah bé Rémogor i Tuluse, bati i Rémogor i Tuluse dob de fédéw ro. ");
INSERT INTO tiy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mélaw kago mégaif bé kébéréh guwe, ‘Fatut go mumah féruman.’ ");
INSERT INTO tiy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Non ségiléw so bé réfuruhe. I réfuruhe mangéy dob kétaya nuwe ayo no. Gélingoo mo éndob énda gétiga moy hon i tidéwo nuwe de taloo no hon i ayo nuwe de. Loo so bé nan, énda gésobuto kom i kéumahe dob Rémogor i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","I Nikodemowe ménénginsa mano, “Ati kérigowe bé ni?” ");
INSERT INTO tiy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Séménumbul i Jesuse mano, “I beeme ménbantug go témoro dob Israel, éndob énda gésobuto moy ni? ");
INSERT INTO tiy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Béréhé ku beem i toowe, béréhé key i gétiga keye, brab ureté key i énggito geye, éndob énda i munur de begom. ");
INSERT INTO tiy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Amuk énda munur go Begén bé ureté kuwe ni beem fantag bé de éntingayén dob duniyae ni, toow na fo énda munur go ké ureté kuy fantage bé de éntingayén dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Atin énda i ségétéw énggéangéy dob lawayo, saliyu bé Begéne, sani Nga i Kéilawane méntidéw diyo.” ");
INSERT INTO tiy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bé gétahe de, amun diyo i de Judio dob gonone énda i étéw de bati, kéneke i de ulé bero. Mélaw réménigoy Moisese kéninontow maak falas ulé brab féndiyoén dob kayéwe brab ténunggulén inok i kéluhanay de téméngténg de, énda méléhu ro. Ségiléw so bé niy Nga i Kéilawane fatut tunggulén dob kayéwe, ");
INSERT INTO tiy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","inok i kéluhanay munure dob Beene énda méléhu ro, yamula gédoté roy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","I Tuluse toow fo mégédaw bé kéluhanay de étéw dob duniyae, mélaw nirayén i buntunge Ngaén inok i kéluhanay munure dob Beene, énda méléhu ro, yamula gédoté roy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Non békén sénugu i Tulusey Nga ne dob duniyae ni inok kukumé noy kéilawane. Yamula inok fukasé noy kéilawane dob de sala ro. ");
INSERT INTO tiy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","I munure dob Jesuse énda mékukumén. Endob i éndae munur dob Beene mékukum non énda munurén bé buntunge Nga i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Been i funay Tuluse kémukum: I Soloe, sani Kristowe, ménangéy dob duniyae, éndob i de étéw méuyot ro bé délémone, brab mika ro bé Soloe non bé de tete rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","I kéluhanay rémigowe tete mika ro bé Soloe brab énda fégédét ro de non mégilak ro ké giton i de tete rigoné ro dob géfékayae. ");
INSERT INTO tiy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Endob i de métintu do étéw fégédét ro dob Soloe inok giton rénigo roy kétayay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tidéw béno, i Jesuse brab de kuyugén ménangéy ro dob ingéde Judea brab ménbati ro diyo bé ménfiroye gétérésangan, brab ménautis ro diyo. ");
INSERT INTO tiy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Atin i Juane ménautis so, éndob dob ingéde Enon, gédét dob ingéde Salim non médooy wayége diyo. Atin i de étéw ménangéy dob beene inok bautiso no bero. ");
INSERT INTO tiy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","I ni ménrigo bé énda séna ménbilanggu i Juane de. ");
INSERT INTO tiy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bé béno, wén i ségétéwe Judio ménséédél bé de dumo kuyug Juan fantag bé kélimfiyowe dob adafay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mélaw i de kuyug Juan, ménangéy ro dob Juane, brab ménbéréh ro maro, “Maistéro, énggétédémo moy dumo muwo ménta dob sébangay wayége Jordan, sani étéwe nuretém? Mautis béni atin kéluhanay étéwe mangéy dob Beene.” ");
INSERT INTO tiy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Endob séménumbul i Juane mano, “I étéwe gédoté no saén i iray i Tuluse dob beene. ");
INSERT INTO tiy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Enggélingoo kom i bénréh guwe bé békén begén i Kristowe, éndob énggétahu sénugu bé Beene. ");
INSERT INTO tiy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","I Kristowe ségiléw bé témérimawe lagéy brab begéney maake sémégunung bé témérimawe lagéy. Atin i de kuyugén ségiléw ro bé térimawe libun. I témérimawe libun kay témérimawe lagéy, békén kay sémégununge. Mélaw i sémégununge ongot-ongot brab fégélingoé no atin méoror de ké gélingoo noy béréh i témérimawe lagéy. Loo bé nan i kagéne kéoror énggumah béleewe, non médooy de étéw furay bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Beeney fatute waléy gérotor, atin i begéne fatut waléy gérifantad.” ");
INSERT INTO tiy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Non i Jesuse tidéw dob lawayo, mélaw gérotor na bé kéluhanane. Endob i de kéilawan, tidéw ro dob fantade ni saén. Mélaw gébéréh ro saén fantag bé duniyae. Endob i tidéwe dob lawayo, toow na fo gérotor bé kéluhanane. ");
INSERT INTO tiy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ureté noy énggito nuwe brab énggélingoo nuwe dob lawayo. Endob kloh saén i munure de. ");
INSERT INTO tiy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Endob i étéwe munur bé uret ne, émfayag bé toow i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Non i sénugu i Tuluse, ureté noy kébéréh i Tuluse, non iray i Tulusey Rémogor ne énda i tamana no. ");
INSERT INTO tiy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Atin i Abaye Tulus mégédaw bé Nga ne brab i kéluhanay ature sénarigén dob Beene. ");
INSERT INTO tiy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","I munure dob Nga i Tuluse, gédoté noy umule magufusa. Endob i éndae munur dob Beene, énda gédoté noy umule magufusa, non énda mékédan i kérit i Tuluse dob beene. ");
INSERT INTO tiy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Enggélingooy de Fariseoy urete bé labi na médooy gédoté Jesuse kuyugén brab toow na médooy bautisé Jesuse étéw bé Juane de. ");
INSERT INTO tiy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Endob i toowe, do kuyug Jesus i mautise, békén Jesus. ");
INSERT INTO tiy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Amun énggélingoo Jesusey ni uret, méntékédan dob Judea, atin ménséfule mangéy Galilea. ");
INSERT INTO tiy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mélaw dob kéagéw ro Jesuse, kailanga roy témarae dob sakuf i ingéde féndawét Samaria. ");
INSERT INTO tiy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Atin, énggégumah ro dob sébaane ingéd dob Samaria féndawét Sikar, gédét dob fantade niray Jakobé bé nga ne Jose bé gétaho. ");
INSERT INTO tiy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Diyo, wén i kalute wén i wayég de, rénigo Jakobe. Atin i Jesuse ménsar diyo dob sékuloy kalute. Non ménlugotén bé kéagéw ne brab géutuh térésang i kégumah ne diyo. ");
INSERT INTO tiy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Bé béno, énda diyo i de kuyug Jesus non ménangéy ro dob fadiyane méléy amaén. Atin i ségétéwe libun tidéw Samaria énggégumah mangéy wayég. Atin ménbéréh i Jesuse dob libune ni mano, “Aw fakay géiraya mo Begén wayég inémén?” ");
INSERT INTO tiy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","I libune ni séménumbul mano, “I Beeme ségétéw go Judio atin i begéne tidéwu Samaria. Sedek mongot go miném dob begéne?” (Bénréhén i ni non i de Judio karangé ro mékérésik i de étéw tidéw Samaria, atin mélaw énda sélawék ro bero.) ");
INSERT INTO tiy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sénumbulo Jesuse mano, “Amuk gétiga mo damén ké ati iray i Tuluse brab gélolo mo Begén sani mongote wayég, i beeme mongot so dob Begéne brab iraya ku beem bé wayége miray umul.” ");
INSERT INTO tiy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Maistéro,” bang i libune ni, “énda i fégésakugém brab i kalute ni ménalém. Hon i gédoto muwe de bé wayége miray umul? ");
INSERT INTO tiy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I katufua tome Jakob i kéménalute bé ni kalut. I beene brab de ngaén dob ni so méniném loo soy de ayamén. Aw toow na gérotor go bé beene?” ");
INSERT INTO tiy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Séménumbul i Jesuse mano, “I minéme bé wayége dob ni kalut waléy so man térumén. ");
INSERT INTO tiy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Endob i minéme bé wayége iray gu, éndaén térumé no. Non i wayége iray gu dob beene waléy séfut wayég dob fédéw ne miray umul magufusa.” ");
INSERT INTO tiy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Atin ménbéréh man i libune ni dob Jesuse mano, “Maistéro, irayanu bé nan wayég, inok éndaén téruménu, brab éndaén kailanga kuy mangéye dini médot wayég.” ");
INSERT INTO tiy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tidéw béno, bénréh Jesuse man dob ni libun mano, “Angéyém i bawag me brab séfule go mangéy dini.” ");
INSERT INTO tiy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","I ni libun séménumbul mano, “Enda i bawag gu.” Atin ménbéréh i Jesuse man mano, “Toow i kébéréh me, énda i bawagém. ");
INSERT INTO tiy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Non wénén i limo gétéw ménawag beem brab i ségétéwe dumo mo sétifon béni békén tintu bawagém. Bénréhém Begén i toowe.” ");
INSERT INTO tiy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Maistéro,” bang i ni libun, “Enggélolo gu béni bé Beemey sarigone muret bé kébéréh i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mélaw ménénginsa dob Jesuse mano, “I de katufua key do tidéw Samaria ménéngadaf ro dob ni tuduk, éndob i begome do Judio, béréhé kom, Jerusalem i fatute ayoy de étéw méngadaf bé Tuluse. Mélaw ati isuwe toow fatut rigonéy de étéw?” ");
INSERT INTO tiy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Séménumbul i Jesuse mano, “Di, féngintoowonu. Gégumah mosoy gaiwe, i kéféngadafe bé Abaye Tulus, békén saén dob ni tuduk taloo no dob Jerusalem saén. ");
INSERT INTO tiy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","I begome tidéw Samaria, féngadafé kom i éndae gétiga kom, éndob i begeye do Judio féngadafé key i gétiga keye, sani Tuluse. Non usaréy Tulusey de Judio mémukas bé de kéilawan. ");
INSERT INTO tiy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Atin gégumah i nan gai brab énggumahén béleewe, i de tintu méngadaf, féngadafé roy Abaye bé de rémogor ro brab fatut munur ro bé toowe fantag bé Tuluse. Non i Abaye, been i niy kétaya nuwe kéféngadaf de. ");
INSERT INTO tiy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","I Tuluse, Rémogor, békén lowoh. Komon i méngadafe de, fatut féngadafé no dob rémogore brab dob toowe.” ");
INSERT INTO tiy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bang i libune ni, “Gétiga ku gégumah i fénémili i Tuluse méguléw féndawét Kristo. Buluk gégumah, féfégétuwa no betom i kéluhanay éntingayéne.” ");
INSERT INTO tiy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Atin ménbéréh i Jesuse mano, “Begéney Kristowe, sani émbéréhe dob beeme.” ");
INSERT INTO tiy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bé béno so, énggumah i de kuyug Jesus, brab ménggaif ro bé kégito ruwe de séuret-uret roy libune ni. Endob énda i ségétéw bero ménénginsa bé ati kétaya nuwe taloo no sedek séuret-uret bé libune ni. ");
INSERT INTO tiy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tidéw béno, i libune ni fénledén i binangga ne, brab ménséfule mangéy dob ingéde. Atin diyo bénréhén dob de étéw mano, ");
INSERT INTO tiy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Enggomén, angéy gom téngténg i étéwe bénréhén begén i kéluhanay rénigo guwe. Békén ba keeyén Been i Kristowe?” ");
INSERT INTO tiy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mélaw i de étéw ménsut ro dob no ingéd ménangéy dob Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Amun énda séna gumah ro, ménongot i de kuyugén mano, “Maistéro, ama go na.” ");
INSERT INTO tiy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Endob sénumbulo no bero mano, “Wén i amaé ku énda gétiga kom de.” ");
INSERT INTO tiy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tidéw béno ménsébéréh-béréh i de kuyugén maro, “Wén bay ménuwiton de amaén?” ");
INSERT INTO tiy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tidéw béno, bénréh Jesuse dob berowe mano, “I kérigo guwe bé kétayay Tuluse ménféuwit Begén, brab bé kéfégilide bé galbéke férigo no Begén, been i maake amaé ku. ");
INSERT INTO tiy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wén i bénréh gom, ‘Fot na gétérésang kélungonon, atin kémétéwén.’ Endob béréhé ku begom, téngténg gom i de ni étéw mangéy dini, non maak do nohok togohén, fakayén kétéwén béleewe. Non ay ninén i gaiwe munur ro Begén. ");
INSERT INTO tiy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","I de étéw kémétéw sémahud brab timué roy de kéntéw ro. Ségiléw ro bé de émféunur bé de dumo étéw inok gédoté roy umule magufusa. Atin i de étéw muret fantag bé Tuluse, maak beroy de mohok. Mélaw i de mohok brab de kémétéw séoror ro. ");
INSERT INTO tiy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Toow i kébéréhe mano, ‘Ségétéw i mohoke, ségiyoy kémétéwe de.’ ");
INSERT INTO tiy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Fénuwit gu begom mangéy kémétéw bé békéne génalbéko kom, ségiyoy géménalbéke de atin ménangéy gom saén kémétéw bé génalbéko ruwe.” ");
INSERT INTO tiy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Médooy de étéw tidéw Samaria dob no ingéd ménunur bé Jesuse non bé kébéréh i libune mano, “Bénréhén begén i kéluhanay rénigo guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mélaw amun ménangéy i de étéw tidéw Samaria dob Jesuse, nongot ro fébatié roy Jesuse dob berowe. Atin ménbati i Jesuse diyo ruwo gétérésangan. ");
INSERT INTO tiy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Atin sabaf bé kéureto nuwe bero, ménuman i kédooy ménunure dob Beene. ");
INSERT INTO tiy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Atin bénréh ro dob libune ni maro, “Munur geyén békén sabaf saén bé bénréh me begey. Béleewe énggélingoo key i kébéréh ne, mélaw gétiga key tintu Beeney mémukase bé kéilawane dob de sala ro.” ");
INSERT INTO tiy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Amun énggilid i ruwowe gétérésangan, i Jesuse ménule ménangéy Galilea. ");
INSERT INTO tiy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wén soy kébéréh Jesuse mano, “I sarigoy Tuluse muret bé kébéréh ne, énda fégadata no dob kaane ingéd.” ");
INSERT INTO tiy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Endob amun énggumah dob Galilea, ténayakuf i de étéw diyo, non énggito roy kéluhanay rénigo nuwe mékégaif dob kékandulie féndawét “Témara” dob Jerusalem, non diyo ro so. ");
INSERT INTO tiy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tidéw béno, ménséfule i Jesuse mangéy Kana, sébaan ingéd dob Galilea, sani ingéde fénwaléyén arak i wayége. Atin wén i ségétéwe gémamak kukuman wén i ngaén lagéy déméruun dob ingéde Kafernaum. ");
INSERT INTO tiy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Amun énggélingoo noy Jesuse énggumah dob Galilea tidéw Judea, ménangéy dob Jesuse brab nongotén dob Jesuse angéyé no uwaén i nga ne gédétén méléhu. ");
INSERT INTO tiy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Atin bénréh Jesuse dob beene mano, “I begome, taman énda gégito gom do mékégaif, énda fo munur gom Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bang i ni odoron, “Maistéro, énggonén, lokut énda séna méléhuén.” ");
INSERT INTO tiy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Atin bénréh Jesuse dob ni odoron mano, “Ule gon, adi-adinén i nga me.” I ni étéw ménunur bé kébéréh Jesuse brab ménule. ");
INSERT INTO tiy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Amun diyo séna lowoh agéwon, bénalak i de sugu-sugué no brab bénréh ro maro, “Ménadi-adinén i nga me.” ");
INSERT INTO tiy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Atin fénénginsaa no bero mano, “Ati urase bé kéadi-adi nuwe?” Atin séménumbul ro maro, “Ménkédan i kééduf ne fuli natémégéno.” ");
INSERT INTO tiy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Brab énggétédémoy boh ne been i noy urase bé kébéréh Jesuse dob beene mano, “I nga me adi-adinén.” Mélaw tidéw béno, kéluhana ro ségékuréng ménunur. ");
INSERT INTO tiy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Been i niy géruwowe mékégaif rénigo Jesuse dob Galilea bé kétidéw ne Judea. ");
INSERT INTO tiy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wén i no sébaan fuweh, ménangéy i Jesuse dob Jerusalem non wén i kanduli diyo kay de Judio. ");
INSERT INTO tiy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Atin diyo dob Jerusalem gédét dob béngawane kay de bili-bili, wén i kérigéwe de féndawét Betesda dob Hebreowe, sani késébéréh i de Judio. Wén i limo timan fésayawa no wén i do atéfén. ");
INSERT INTO tiy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Diyo méniro i médoowe do étéw déméruun, do langafén, do fikat, brab do kimoyén. Atin ongot-ongoté roy késékuyo i wayége ni. ");
INSERT INTO tiy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Non wén i gai gégumah i télakiy Kadnane, angéyé no sékuyoén i wayége ni. Atin i géétahe mangéy tééléd dob ni wayég ké mésékuyo, waléy adi-adi fiyon fo ké atiy déruu nuwe. ");
INSERT INTO tiy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wén i ségétéwe lagéy diyo, méntéléwén folo bra waléw gébélintuwa i kédéruu nuwe. ");
INSERT INTO tiy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Amun énggito Jesusey ni lagéy méniro diyo brab énggétiga noy kérugay i kédéruu nuwe, fénénginsaa no mano, “Aw méuyot go adi-adi?” ");
INSERT INTO tiy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Séménumbul i ni lagéy déméruun mano, “Maistéro, énda i témabangan begén mangéy tééléd dob wayége ké mésékuyo. Buluk féganayu séna fégédét, wénén i gégumah gétah begén.” ");
INSERT INTO tiy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tidéw béno, ménbéréh i Jesuse dob beene mano, “Tindég go, furutém i ikam muwa nan, brab agéw go.” ");
INSERT INTO tiy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sonom béno, ménadi-adiy ni lagéy. Atin fénurutén i ikam ne brab ménagéw. I no gai kéféadi-adi Jesuse bé ni lagéy Sabado, gai kétérén kay de Judio. ");
INSERT INTO tiy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mélaw i de odoroy de Judio ménbéréh ro dob ni lagéy ménadi-adi maro, “Béleewe Sabado, gai kétérén. Enda fakayén dob kitab tome ké uwité moy ikam muwa nan.” ");
INSERT INTO tiy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Endob séménumbul i lagéyé ni ménadi-adi mano, “Endob bénréh i lagéye ni ménféadi-adi begén, furuté kuy ikam guwe brab magéwu.” ");
INSERT INTO tiy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Atin ménénginsa i de odoron maro, “Ati no lagéy ménbéréh de dob beeme, ké furuté moy ikam muwe brab magéw go?” ");
INSERT INTO tiy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Endob énda énggétigay ni lagéy ké ati no étéw ménféadi-adi de, non ménangéy i Jesuse dob de ménribuk do étéw. ");
INSERT INTO tiy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Enda ménrugayén tidéw béno, énggito Jesusey ni lagéy dob lawi i Tuluse. Atin ménbéréh i Jesuse dob beene mano, “Téngténgém, ménadi-adi gon. Kagon rémigo sala inok énda toow gétimal i kékéfasanga muwe.” ");
INSERT INTO tiy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tidéw béno, ménagéw i ni lagéy brab bénréhén dob de odoroy de Judio bé Jesus i ménféadi-adiwe de. ");
INSERT INTO tiy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mélaw i de odoroy de Judio, féngganay roy kéférasay ruwe bé Jesuse, non ménuwa bé gai kétéréne. ");
INSERT INTO tiy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Endob bénréh Jesuse dob berowe mano, “I Abay guwe Tulus énda téméréno gémalbék fiyon fo ké gai kétérén, atin i Begéne fatut gémalbéku so sénga tékélid.” ");
INSERT INTO tiy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Been i niy funay de odoroy de Judio ménuman i kékérit ruwe bé Jesuse, atin toow na fo sarintaé ro féléhuén. Békén saén sabaf bé kégalbék ne ké gai kétérén, éndob sabaf so bé fédawété noy Tuluse Abayén, ula-ula réféngé noy Tuluse béno. ");
INSERT INTO tiy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Atin sénumbulo Jesuse bero mano, “Béréhé ku begom i toowe, i Begéne Ngaén, brab énda i gérigono ku ké tidéw dob Begéne saén. Rigoné kuy gito guwe rigonéy Abay guwe Tulus. Udenén rigonéy Abay guwe, rigoné ku so. ");
INSERT INTO tiy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Non i Abay guwe méimu Begén brab fégétiga no Begén i kéluhanay galbék ne. Atin méuman i férigo nuwe Begén toow na fo mékégaif galbék funa kom mégaif. ");
INSERT INTO tiy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Non loo bé Abay guwe tébuleé noy de ménléhu brab iraya no bero umul, Begéne ni so, iraya ku umul i de étéw kétaya ku iraya ku de. ");
INSERT INTO tiy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Atin békén i Abay guwey kémukume bé de étéw. Yamula niraya no Begén kuwagib kémukum bé kéluhanay étéwe, ");
INSERT INTO tiy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","inok basanay kéluhanay étéwe Begén loo so bé kébasana ruwe bé Abay guwe. I éndae masanan Begén, énda so basana noy Abay guwe séménugu Begén. ");
INSERT INTO tiy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Béréhé ku begom i toowe, i mégélingoe bé kébéréh guwe brab munur bé Tuluse séménugu Begén, wén i umulén magufusa. Atin énda mékukumén moso bé de salaén. Non éndaén méléhuén non fiyon fo ké méléhu i lowoh ne, gédoté noy umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Béréhé ku begom i toowe, gégumah i gaiwe brab ménggumahén béleewe ni, bé gélingooy de ménléhu i béréh guwe, atin i de mégélingo de, gédoté roy umule. ");
INSERT INTO tiy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Non i umule tidéw dob Abaye, brab loo bé ni niraya no Begén, sani Nga ne, barakat inok wén i umul tidéw dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Atin i Abay guwe Tulus, niraya no so Begén kuwagib kémukum bé de kéilawan kagulan Begén i Nga i Kéilawane. ");
INSERT INTO tiy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kagom mégaif bé de ni, non gégumah i gaiwe i kéluhanay de étéw ménléhu dob de lébéng ro, gélingoo roy béréh guwe. ");
INSERT INTO tiy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Atin mésut ro tidéw dob de lébéng ro, atin i de réménigo fiyo métébule inok gédoté roy umule magufusa. Endob i de réménigo tete métébule inok mékukum ro. ");
INSERT INTO tiy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“I Begéne, énda i kagén gérigonon saliyu bé Abay guwe saén. Kémukumu loo bé kéfémandu i Tuluse de Begén. Mélaw i kékukum guwe métintu non békén kagén kétayan éndob kétayay Abay guwe séménugu Begén. ");
INSERT INTO tiy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Amuk ureté ku saén i fantage bé lowoh guwe, énda i géunur de. ");
INSERT INTO tiy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Endob wén i ségiyowe muret fantag bé Begéne brab gétiga kuy uret ne fantag bé Begéne toow fo toow. ");
INSERT INTO tiy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Séménugu gom mangéy dob Juane Mautis atin nuretén i toowe fantag bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Endob énda kailanga kuy kéuret i kéilawane fantag bé Begéne, éndob énggélabito ku émfégétédém begom i uret Juane fantag bé Begéne, inok munur gom Begén funa kom méfukas dob de sala gom. ");
INSERT INTO tiy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","I Juane maak solo, mérino brab réméndaw kagulan ténoroén begom, brab ménoror gom témayakuf bé kétoro ne begom éndob singkow saén. ");
INSERT INTO tiy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Endob wén i labi na fo fiyo funa kom munur Begén bé de nuret Juan. Fégitung gom i galbéke rigoné ku, non been i galbéke niray i Abay guwe Begén. Mélaw i de galbék gu, been i émfégétigane bé sénugu i Abaye Tulus Begén. ");
INSERT INTO tiy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Atin i Abaye séménugu Begén, fégétiga no soy fantage bé Begéne. Enda énggélingoo kom i béréh ne taloo no énggito gom i falas ne. ");
INSERT INTO tiy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Atin énda fénbati gom dob de fédéw gom i kébéréh ne. Gétiga kuy ni non énda munur gom Begén, sani sénugu i Abaye Tulus. ");
INSERT INTO tiy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tantu gom féganad i Ménsulate Kébéréh i Tuluse, non gékaranga kom dob de ni gédoté kom i umule magufusa. Endob been i niy de ménsulat uret fantag bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mélaw amuk munur gom dob Begéne, gédoté kom i umule magufusa, éndob mika gom munur Begén. ");
INSERT INTO tiy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Enda sélédé kuy kédayéw i kéilawane. ");
INSERT INTO tiy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Endob gétiga kuy de fédéw gom, énda méimu gom bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sénugu i Tuluse Begén, atin Begén i sarigo nuwe. Gido loo énda ténayakuf gom Begén. Endob buluk wén i ségétéw gégumah énda sénugu i Tuluse de, tayakufé kom. ");
INSERT INTO tiy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Enda munur gom non sélédé kom i kédayéw i de dumo gom étéw éndob énda sélédé kom i kédayéwe tidéw dob sébaane tintu Tulus. ");
INSERT INTO tiy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Endob kagom fégitungén de ké Begén i témboe begom dob Abay guwe Tulus. Békén Begén. Sénarigo kom i kitabé niray Moisese, éndob been i téméboe begom. ");
INSERT INTO tiy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Endob amuk tintu gom munur bé kétoro Moisese, munur gom so Begén, non sénulatén i fantage bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Endob amun énda munur gom bé sénulat Moisese, énda so géunur gom dob Begéne.” ");
INSERT INTO tiy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tidéw béno, ménifar i Jesuse dob dogote féndawét Galilea taloo no Tiberias. ");
INSERT INTO tiy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Atin toow fo médooy de étéw ménfuray de non énggito roy de mékégaif galbék rénigo no bé kéuwa ne bé de déméruun. ");
INSERT INTO tiy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Atin ménénagé i Jesuse beroy de kuyugén mangéy dob burure atin diyo ro ménsar. ");
INSERT INTO tiy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Bé béno gai, éndaén mérugay i kékanduli i de Judio féndawét ro “Témara”. ");
INSERT INTO tiy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Amun iling-iling i Jesuse, énggito noy médoowe étéw démangkub mangéy dob Beene. Mélaw ménénginsa dob Filipihe mano, “Ayo tome de méléy amaén féama bé de étéw ni?” ");
INSERT INTO tiy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(I funa Jesuse ménénginsa, téngkadé no saén i Filipihe. Endob gétiga Jesuse nén i rigoné nuwe.) ");
INSERT INTO tiy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Atin séménumbul i Filipihe mano, “Fiyon fo ké wén i labi séngibu filak tom, kulang na fégébéléy amaéy médoowe ni étéw, fiyon fo ké sékéloh-kélohén dob séngae ségétéw.” ");
INSERT INTO tiy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Endob ménbéréh i ségiyowe kuyugén féndawét Andres (sani dumo Simon Pedrowe sétiman idéng) mano, ");
INSERT INTO tiy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wén i ségétéw kénogo lagéy dob ni, wén i nuwitén limo timan mélému fan brab ruwo timan sédo. Endob toow fo kulang i ni féama bé médoowe ni étéw.” ");
INSERT INTO tiy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tidéw béno, ménbéréh i Jesuse dob de kuyugén mano, “Féésar gom i de étéw.” Mélaw ménsar i de étéw diyo dob bukae gonon wén i do kéroon de. Wén i limo ngibu do lagéy saliyu na bé de libun brab do nga. ");
INSERT INTO tiy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Atin éndot Jesusey fane brab ménfésalamat dob Tuluse. Tidéw béno, sénaarén dob de médoo étéw ménsar diyo. Loo so bé niy rénigo Jesuse bé de sédo de. Atin téménantu ro mama taman kétaya ro. ");
INSERT INTO tiy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Amun énggéama ro nén taman ménbésor ro kéluhanan, ménbéréh i Jesuse dob de kuyugén mano, “Timu gom i kéluhanay de sama amaén inok énda mésinggulaén.” ");
INSERT INTO tiy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mélaw ténimu roy de sama amaén. Atin ménféno i foloe bra ruwo timan dakél biton bé de sama i de limo timan fan. ");
INSERT INTO tiy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Amun énggitoy de étéw i ni mékégaif galbék rénigo Jesuse, ménbéréh ro maro, “Tintu Been i niy toowe sarigoy Tuluse muret bé kébéréh ne, sani suguéy Tuluse dob duniyae ni.” ");
INSERT INTO tiy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Atin gétiga Jesusey fégésé ro féwaléyé ro datu ro, mélaw ténagakén bero man brab ménangéy félébu dob de burur. ");
INSERT INTO tiy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Amun témégénén, ménangéy i de kuyugén dob dogote. ");
INSERT INTO tiy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Atin ménda ro awang mifar bé dogote mangéy Kafernaum, non kélungononén, atin énda séna énggumah i Jesuse dob berowe. ");
INSERT INTO tiy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bé béno uras, émbagér i réfuruhe brab dakél i bagéle dob dogote. ");
INSERT INTO tiy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Amun ménggéfura ro ném gékilomitro tidéw dob dénsaane, énggito roy Jesuse magéw dob rotor i dogote mangéy dob berowe. Mélaw toow ro fo ménggilak. ");
INSERT INTO tiy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Endob ménbéréh i Jesuse mano, “Begén, kagom mégilak!” ");
INSERT INTO tiy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Atin ménoror ro brab fénéda ro dob awange, brab sonom béno énggégumah ro dob dénsaane ayo ro. ");
INSERT INTO tiy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Amun géfuwénén, i de étéw ménbati séna dob difar i dogote, énggétiga ro sébaan saén i awange diyo béno kélungonon. Atin énggétiga ro énda ménodor i Jesuse bé de kuyugén méda dob awange mifar dob dogote. Brab gétiga ro énda i ségiyo awang diyo. ");
INSERT INTO tiy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tidéw béno, énggumah i de awang tidéw dob ingéde Tiberias, déménunggu gédét dob gonoy de étéw ménama fan amun énggilid fénsalamatay Kadnane Jesus. ");
INSERT INTO tiy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Atin amun gétuway de étéw énda diyo i Jesuse loo soy de kuyugén, ménda ro bé de awang mangéy Kafernaum inok sélédé roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Atin amun énggito roy Jesuse dob difar i dogote, fénénginsaa ro maro, “Maistéro, ménfiroyén i kégumah me dini?” ");
INSERT INTO tiy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Sénumbulo Jesuse bero mano, “Béréhé ku begom i toowe, békén i kégésobut gome bé de mékégaif galbék rénigo guy funa kome séméléd Begén, éndob non bé de fénama gu begom atin ménbésor gom. ");
INSERT INTO tiy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kagom séméléd bé amaéne kay de sur gom saén non waléy waréy i nan amaén. Endob séléd gom bé amaéne kay de fédéw gom funa kom méraru taman sa taman. I Nga i Kéilawane, sani Begéne, iray guy nan amaén non i Abaye Tulus fénggétiga no Been i séménugue Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Atin ménénginsa ro dob Jesuse maro, “Ati fiyowe rigoné key inok rigoné key i kétayay Tuluse?” ");
INSERT INTO tiy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Séménumbul i Jesuse mano, “Ay niy kétayay Tuluse rigoné kom: Unur gom Begén non Begén i sénugu i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Atin ménénginsa ro maro, “Ati mékégaife galbék féténgténgém begey inok munur gey dob Beeme? ");
INSERT INTO tiy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","I de katufua key bé do gétah, ménama ro fan féndawét ‘mana’ dob gonone énda i nohok do témunoh diyo, loo bé Ménsulate Kébéréh i Tuluse mano, ‘Niraya no bero amaén tidéw dob lawayo inok géama ro.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Séménumbul i Jesuse mano, “Béréhé ku begom i toowe, békén Moises i ménféamae bero fan tidéw dob lawayo, éndob i ménféama bero been i Abay guwe Tulus. Atin i Abay guwe, irayén so begom i tintuwe amaén tidéw dob lawayo kay de fédéw gom. ");
INSERT INTO tiy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Non i amaéne iray i Tuluse, been i énggégumahe tidéw dob lawayo inok miray umul dob de kéilawan.” ");
INSERT INTO tiy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ménbéréh ro dob Jesuse maro, “Maistéro, irayan gey démoyun bé nan amaén.” ");
INSERT INTO tiy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Séménumbul i Jesuse mano, “Begéney amaéne miray umul. I kéluhanay étéwe mangéy dob Begéne éndaén mélayaf ro, brab i kéluhanay munure Begén éndaén térumén ro. ");
INSERT INTO tiy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Endob fiyon fo ké énggito gomén Begén, éndob énda séna munur gom Begén. Bénréh gun i nan dob begome bé gétaho. ");
INSERT INTO tiy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mangéy dob Begéney kéluhanay de étéw niray i Abaye Begén. Brab énda dudulé kuy étéwe mangéy dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Non ménlusu tidéw dob lawayo inok rigoné kuy kétayay Tuluse séménugu Begén, békén inok rigoné kuy kagéne kétayan. ");
INSERT INTO tiy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Atin ay niy kétayay Tuluse: énda fédayaé ku métadin i de nirayén Begén étéw, fiyon ségétéw. Yamula tébuleé ku bero kéluhanan dob tamfaday gaiwe. ");
INSERT INTO tiy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Non been i niy kétayay Abay guwe: i kéluhanay gétigane Begén brab munure Begén, gédoté roy umule magufusa. Atin tébuleé ku bero dob tamfaday gaiwe.” ");
INSERT INTO tiy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Atin i de Judio amun énggélingoo roy bénréh Jesuse, mundég-mundég ro non bénréhén bé Beeney amaéne tidéw dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Brab ménbéréh ro maro, “Ati Jesuse ni, aw békén ba Beeney nga Josehe saén? Sedek bénréhén ménlus kun tidéw dob lawayo, non gétiga tom i boh ne brab idéng ne?” ");
INSERT INTO tiy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Endob bénréh Jesuse mano, “Kagom mundég-mundég. ");
INSERT INTO tiy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Enda i ségétéw géangéy dob Begéne, saliyu ké féfégédétéy Abaye séménugu Begén. Atin dob tamfaday gaiwe, tébuleé kuy kéluhanay mangéye dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sénulat i de sénarigoy Tuluse muret bé kébéréh ne maro, ‘I de kéilawan toroéy Tuluse moso.’ Mélaw i séngae mégélingo bé Abaye brab modor bé kétoro ne, mangéy dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Endob énda i ségétéw énggégito bé Abaye, saliyu bé Begéne non tidéwu dob Tuluse. Mélaw Begéne say énggégitowe bé Abaye Tulus. ");
INSERT INTO tiy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Béréhé ku begom i toowe, i de méginugut dob Begéne méuyag ro taman sa taman. ");
INSERT INTO tiy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Begéney maake amaén miray umul. ");
INSERT INTO tiy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I de katufua kom amun diyo ro dob gonone énda i nohok do témunoh diyo, ménama ro amaén féndawét ‘mana’, gido ménléhu ro so. ");
INSERT INTO tiy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Endob Begéney amaéne tidéw dob lawayo. Atin i kéluhanay géamae bé ni amaén, énda méléhu ro. ");
INSERT INTO tiy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Begéney amaéne miray umul ménlus tidéw dob lawayo. Atin amuk i ségétéwe géama de, méuyag taman sa taman. I amaéne iray gu funay de kéilawan méuyag, sani lowoh guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Atin amun énggélingooy de Judioy ni bénréh Jesuse, ménséédél ro maro, “Ati kéfingé-fingé i kéiray i ni étéw bé lowoh ne inok amaé tom?” ");
INSERT INTO tiy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mélaw ménbéréh i Jesuse mano, “Béréhé ku begom i toowe, amuk énda amaé kom i lowoh i Nga i Kéilawane sani lowoh guwe, brab énda inémé kom i dara guwe, énda gédoté kom i umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Endob i de mama bé lowoh guwe brab miném bé dara guwe, wén i umul ro magufusa, atin tébuleé ku bero dob tamfaday de gai. ");
INSERT INTO tiy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Non i lowoh guwe been i nan i tintuwe amaén, atin i dara guwe been i nan i tintuwe inémén. ");
INSERT INTO tiy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","I kéluhanay mamae bé lowoh guwe brab minéme bé dara guwe diyou bati dob berowe atin dini ro bati dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Méuyag i Abaye séménugu Begén, atin i Begéne méuyagu sabaf bé Beene. Mélaw i kéluhanay mamae Begén méuyag so sabaf bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Begéney amaéne tidéw dob lawayo. I de katufua kom ménama ro amaén féndawét ‘mana’, gido ménléhu ro so. Endob i de mama bé ni amaén sani lowoh guwe méuyag ro taman sa taman.” ");
INSERT INTO tiy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Bénréh Jesusey ni bé kétoro ne dob lawie féngadafay de Judio dob ingéde Kafernaum. ");
INSERT INTO tiy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Amun énggélingooy de kuyugén i ni kétoro, ménbéréh i de kédoono ro maro, “Toow fo ménalém i ni kétoro, ati mélaw i géfégélingoe de?” ");
INSERT INTO tiy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Endob énggétiga Jesuse dob fédéw ney funay de kuyugén mundég-mundég. Mélaw bénréhén bero mano, “Aw toow fo mika gom bé bénréh guwe? ");
INSERT INTO tiy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ati béréhé kome ké gito gom Begén, sani Nga i Kéilawane, démiyat mule dob gonone tidéwo ku? ");
INSERT INTO tiy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","I miraye bé umule been i Rémogor i Tuluse. Endob i kéilawane, énda i barakatén miray umul. I nuret guwe begom tidéw dob Rémogor i Tuluse brab miray bé umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Endob gétiga kuy wén i de dumo begom énda munur ro Begén.” (Bénréh Jesusey nan non gétiga non i de énda de munur tidéw féganay brab i étéwe émfékéfo de.) ");
INSERT INTO tiy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Atin sénumfata noy kébéréh ne mano, “Been i nan i funa kuwe ménbéréh bé énda i géangéy dob Begéne saliyu ké féfégédétéy Abaye.” ");
INSERT INTO tiy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tidéw béno, médoo bé de kuyugén i téménagake de brab éndaén ménodor ro de. ");
INSERT INTO tiy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mélaw fénénginsaa Jesusey de folo bra ruwo gétéw kuyugén mano, “Aw méuyot gom so témagak Begén?” ");
INSERT INTO tiy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Séménumbul i Simon Pedrowe mano, “Kadnan ati nay odoro keye? I de kaam saén kébéréh i géiraye bé umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Munur gey brab gétiga key Beemey Mékétéfuwe Etéw tidéw dob Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Atin ménbéréh i Jesuse mano, “Aw békén ba begom i foloe bra ruwo gétéw fénémili gu? Endob saitan i ségétéwe begom!” ");
INSERT INTO tiy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I ténéndu i de kébéréh Jesus, been i Judase nga Simon Iskariot. Been i émfékéfoe de fiyon fo ké been i ségétéwe bé de folo bra ruwo gétéw kuyugén. ");
INSERT INTO tiy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tidéw béno, i Jesuse diyo ménsugud-sugud dob Galilea. Ménika mangéy sugud-sugud dob Judea non méuyot i de odoroy de Judio de méméléhu. ");
INSERT INTO tiy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bé béno, gédétén i kékanduli i de Judio féndawét ro “Dung-dung.” ");
INSERT INTO tiy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mélaw ménbéréh i de tuwaréy Jesus do lagéy dob Beene maro, “Ay go Judea inok gitoy de kuyugém i de mékégaif galbékém. ");
INSERT INTO tiy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Amuk i étéwe méuyot mébangtug, énda bunéyé noy de rigoné no. Amuk gérigono moy de mékégaif, rigoné mo dob adafay médoowe étéw.” ");
INSERT INTO tiy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Loo bé niy kébéréh i de tuwaréyén non fiyon foy berowe énda séna munur ro dob Beene.) ");
INSERT INTO tiy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Séménumbul i Jesuse mano, “Enda séna gumah i fatute gai rigoné kuy galbék guwe. Endob i begome fakay rigoné kom i kagome galbék bé de udenén gai. ");
INSERT INTO tiy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","I de tete étéw énda mérarék ro begom, éndob mérarék ro Begén non dowoyé kuy kéluhanay tetee rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ay gom dob kandulie, éndob i Begéne énda séna mangéyu diyo non békén sénay niy gaiwe fatut mangéyu diyo.” ");
INSERT INTO tiy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Amun énggilid bénréhén i ni, ménbati saén dob Galilea. ");
INSERT INTO tiy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Endob amun ménagéwén i de tuwaréyén mangéy dob kandulie dob Jerusalem, ménfuray soy Jesuse, éndob énda i énggétigan de non ménagéw nékémén saén. ");
INSERT INTO tiy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sélédéy de odoroy de Judioy Jesuse dob kandulie atin fénénginsa ro maro, “Hon i gono Jesuse de?” ");
INSERT INTO tiy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Atin médooy de étéw ménlimud diyo séméguraw séuret-ureté roy fantage bé Jesuse. Embéréh i de dumo de maro, “Fiyo étéw i Jesuse.” Endob bang i de dumo de, “Enda fiyo étéw i Jesuse, fégakara noy de étéw.” ");
INSERT INTO tiy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Endob énda i ségétéw ménfébénsag muret fantag bé Jesuse non mégilak ro bé de odoroy de Judio. ");
INSERT INTO tiy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Amun gékérara ron bé kékanduli ruwe, ménangéy i Jesuse dob lawi i Tuluse brab téménoro. ");
INSERT INTO tiy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ménggaif foy de odoroy de Judio brab ménbéréh ro maro, “Sedek toow fo mon gétigan i ni étéw, énda taén ménrugay i késékuwelah ne?” ");
INSERT INTO tiy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Séménumbul i Jesuse mano, “I kagéne kétoro békén tidéw dob Begéne saén, éndob tidéw dob Tuluse séménugu Begén. ");
INSERT INTO tiy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","I de étéw méuyot ro rémigo bé kétayay Tuluse, gétiga ro ké i kagéne kétoro tidéw dob Tuluse taloo no tidéw saén dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","I étéwe muret saén bé kaane kétoro, méuyot saén mébantug. Endob i étéwe méuyot rémigo bé funay séménugue de émbantug, been i nan i métintuwe étéw brab énda témugién. ");
INSERT INTO tiy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Békén ba niray Moisesey kitabe? Endob énda i ségétéw begom modor de, non amuk odoro kom, énda damén télamané kom féléhuén Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Séménumbul i de étéw maro, “Sénaitanan go! Ati étéwe méuyot méméléhu Beem?” ");
INSERT INTO tiy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ménbéréh man i Jesuse mano, “Amun rénigo guy sébaane saén mékégaif galbék, ménkéségiyonan gom de non gai kétérén béno. ");
INSERT INTO tiy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Endob wén i sébaane kitab fantag bé kétulie niray Moisese bé gétaho. (Endob i toowe, tidéw i ni kitab dob de katufua tom.) No mélawén fiyon fo ké gai kétérén, tulié kom soy de nga gom. ");
INSERT INTO tiy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Amuk tulié kom i ségétéwe nga lagéy fiyon fo ké gai kétérén inok odoro kom i kitabé tidéw dob Moisese, sedek mékérit gom Begén sabaf bé kéféadi-adi guwe bé ségétéwe étéw ké gai kétérén? ");
INSERT INTO tiy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kagom kukumén i de énggito gom saén. Yamula fégitung gom fiyo brab kukum gom métintu.” ");
INSERT INTO tiy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tidéw béno, i de dumo bé de étéw tidéw Jerusalem ménbéréh ro maro, “Aw békén bay niy lagéye sélédéy de odoro tom inok féléhuén? ");
INSERT INTO tiy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Téngténg gom, ay ni émbéréh dob adafa tome brab énda mon i gébérého ro sébanil de. I de odoro key, gélolo ron keey Beeney Kristowe sani ongot-ongoté tome. ");
INSERT INTO tiy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Endob amuk gégumah kun i Kristowe, énda i gétigan de ké hon i tidéwo nuwe de. Endob gétiga tom i tidéwoy ni étéw.” ");
INSERT INTO tiy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tidéw béno, amun diyo téménoro dob lawi i Tuluse ménfébénsag i Jesuse émbéréh mano, “Aw tintu gélolo gom ba Begén brab gétiga kom i tidéwo kuwe? Enda ménangéyu dini ké dob kagéne saén aturan. I toowe Tulus i séménugue Begén, éndob énda gélolo gom de. ");
INSERT INTO tiy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Endob gélolo guy Beene, non tidéwu dob Beene brab Beeney séménugue Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tidéw béno, ténlama ro kénéfo i Jesuse éndob énda i ségétew énggékéfo de non énda séna énggumah i gaiwe fénémili Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Endob médooy de étéw dob de ménlimud ménunur de, brab ménbéréh ro maro, “Beeney Kristowe, sani fénémili i Tuluse méguléw, non énda i ségétéw gérigo bé de mékégaif galbék rénigo no ké békén i Kristowe.” ");
INSERT INTO tiy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Enggélingooy de Fariseoy ni késébéréh-béréh i de étéw séguraw fantag bé Jesuse. Mélaw i berowe brab de odoroy de fadi, séménugu ro do mantay bé lawi i Tuluse inok kémfo bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Atin ménbéréh i Jesuse dob de étéw mano, “Endaén mérugay i kébati guwe dob begome non séfuleu mangéy dob Tuluse séménugu Begén. ");
INSERT INTO tiy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sélédé kom Begén éndob éndaén gito gom Begén, non énda géangéy gom dob batio kuwe.” ");
INSERT INTO tiy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ménsébéréh-béréh i de Judio maro, “Hon keey i ayo nuwe de, ké énda gito tom de? Aw mangéy keey dob mérayue ingéd i de Griego batioy de Judio so, atin toroé noy de Griego? ");
INSERT INTO tiy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ati keey i atag i bénréh ne mano, ‘Sélédé kom Begén, éndob énda gito gom Begén, brab énda géangéy gom dob batio kuwe?’ ” ");
INSERT INTO tiy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Amun dob tamfaday gaiwe bé kékanduli ruwe sani toowe na fo balilaga gai, téménindég i Jesuse brab ménbéréh métanug mano, “Do étéw térumén, ay gom dob Begéne, brab miném. ");
INSERT INTO tiy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Non wén i Ménsulate Kébéréh i Tuluse mano, ‘I étéwe munur dob Begéne, tidéw dob fédéw ne rémégés i wayége miray bé umule magufusa.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I atag i bénréh Jesuse, ay ni: i Rémogor i Tuluse mangéy dob de munur bé Jesuse atin bati dob de fédéw ro. Endob énda séna nirayén i Rémogor i Tuluse non énda séna ménléhu i Jesuse brab tébule atin mule mangéy dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Médooy de étéw énggégélingo de, ménbéréh ro maro, “Tintu Beeney sarigoy Tuluse muret bé kébéréh ne, sani sarigone ongot-ongoté tom.” ");
INSERT INTO tiy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bang i de dumo étéw, “Beeney Kristowe ongot-ongoté tom.” Endob séménumbul i de dumo de maro, “Ati kéfingé-fingé ne ké i Kristowe tidéw Galilea? ");
INSERT INTO tiy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Non bang i Ménsulate Kébéréh i Tuluse, i Kristowe séfu Dabid. Mélaw fatut i Kristowe mumah dob ingéde Betlehem non i Dabide bati dob Betlehem.” ");
INSERT INTO tiy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mélaw énda géséfagayun i de antaf fédéw ro fantag bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Atin ménuyot i de dumo de kémfo, éndob énda i ségétéw réménigo de. ");
INSERT INTO tiy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tidéw béno, i de guwardiya ménséfule ro mangéy dob de odoroy de fadi brab do Fariseo. Atin fénénginsaa roy de guwardiya maro, “Sedek énda kénéfo gom i Jesuse inok géuwito kom mangéy dini?” ");
INSERT INTO tiy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Séménumbul ro maro, “Enda kénéfo gey de non ménggaif gey bé kétoro ne. Non ségiyo bé kéluhanay kétoroe énggélingoo key.” ");
INSERT INTO tiy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Atin ménbéréh i de Fariseo maro, “Aw fiyon i begome, énggéfégakara no begom so? ");
INSERT INTO tiy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Enda sénay ségétéw begey do odoro kom taloo no do Fariseo ménunur de. ");
INSERT INTO tiy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","I de munur dob Beene, beroy de gérifantad étéw saén, sani énda gétiga roy kitab tome. Mélaw kukuméy Tuluse bero.” ");
INSERT INTO tiy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Atin diyo soy Nikodemowe sani ségétéwe so Fariseo. Been i ménangéye dob Jesuse bé gétahe de. Brab ménbéréh mano, ");
INSERT INTO tiy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Enda fakay dob kitab tomey kémukume ké énda séna énggésusinon i rénigo nuwe, brab énggélingoon i kébéréh ne.” ");
INSERT INTO tiy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Séménumbul ro maro, “Aw tidéw go so Galilea? Basa moy Ménsulate Kébéréh i Tuluse, inok gétiga mo énda i sarigoy Tuluse tidéw Galilea.” ");
INSERT INTO tiy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tidéw béno, i kéluhana ruwe ménule. Endob i Jesuse ménangéy dob tuduke féndawét Olibo. ");
INSERT INTO tiy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dob gétunduge de fuweh, amun toow géfuwén, ménangéy man i Jesuse dob lawi i Tuluse. Amun ménangéy i kéluhanay de étéw dob Beene, ménsar i Jesuse brab ténoroén bero. ");
INSERT INTO tiy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bé no gai, i de Fariseo brab do témoro kitab, nuwit roy libune énggétékasan ménbuwah. Atin féntindég ro dob adafa Jesuse brab de médoo ni étéw. ");
INSERT INTO tiy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Atin bénréh ro dob Jesuse maro, “Maistéro, énggétékasan i ni libun ménbuwah. ");
INSERT INTO tiy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Dob kitab tome niray Moisese, fatut ibéron batéw taman méléhu i étéwe ménsala loo bé ni. Ati kébéréh me fantag bé ni?” ");
INSERT INTO tiy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Fénénginsa ro dob Jesusey ni inok tukawa ro saén i Beene inok amuk békén damén katabuwan i késumbul ne, wén i funa ro témbo de. Endob ménkudung-kudung i Jesuse brab séménulat dob fantade bé tuko ténoro ne. ");
INSERT INTO tiy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Amun énda fo témérén ro ménginsa, téménindég i Jesuse brab bénréhén bero mano, “Ati éndae salaén begom, been i sunguwe de mibéron batéw.” ");
INSERT INTO tiy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tidéw béno, ménkudung-kudung man i Jesuse brab féntausén i késulat ne dob fantade. ");
INSERT INTO tiy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tidéw béno, amun énggélingoo roy bénréh Jesuse, ménule ro séségétéw-gétéw, i sunguwe ménule do lukés. Atin énda i ségétéw ménféled ké békén i Jesuse saén brab ni libun. ");
INSERT INTO tiy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Atin téménindég i Jesuse brab ménénginsa mano, “Di, nayo ruwe de? Aw énda i ségétéw témbo beem?” ");
INSERT INTO tiy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Séménumbul i ni libun mano, “Enda, Maistéro.” Atin bénréh Jesuse mano, “Enda so téboé ku beem. Ule go brab kagonén mésala féruman.” ");
INSERT INTO tiy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Atin téménoroén man i Jesuse dob de étéw mano, “Begéney maake solo réméndaw dob kéilawane. I furaye Begén éndaén magéwén dob délémone, yamula magéw dob géfékayae brab gédoté noy umule magufusa.” ");
INSERT INTO tiy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ménbéréh i de Fariseo maro, “Beeme soy murete fantag bé lowoh me, mélaw énda i lantékén.” ");
INSERT INTO tiy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Séménumbul i Jesuse mano, “Fiyon fo ké Begén i murete fantag bé Begéne, toow i béréhé kuwe non gétiga kuy tidéwo kuwe brab ayo kuwe. Endob i begome, énda gétiga kom i tidéwo kuwe taloo no ayo kuwe. ");
INSERT INTO tiy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kukumé kom i énggito gome saén non do kéilawan gom saén. Endob i Begéne, énda kémukumu. ");
INSERT INTO tiy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Endob amuk kémukumu, métintuy kagéne kékukum non békén saén Begén i kémukume, éndob Begey i Abaye Tulus séménugu Begén. ");
INSERT INTO tiy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ménsulat dob kitab gome, amuk ségiléw i uret i ruwowe gétéw, giton toow i urete. ");
INSERT INTO tiy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ruwo gey gétéw muret fantag bé Begéne. Begén brab Abaye séménugu Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tidéw béno, fénénginsaa roy Jesuse maro, “Hon i gonoy Abay me de?” Séménumbul i Jesuse mano, “Enda gétiga kom Begén taloo no Abay guwe. Amuk gétiga kom Begén, gétiga kom soy Abay guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Bénréh Jesusey ni bé kétoro ne dob lawi i Tuluse gédét dob fégono ruwe limus. Endob énda i ségétéw kéménéfo de non énda séna gumah i gaiwe fénémili i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ménbéréh man i Jesuse dob berowe mano, “Tagaké kun begom, atin sélédé kom Begén. Endob méléhu gom énda émfésagad i de sala gom, brab énda géangéy gom dob ayo kuwe.” ");
INSERT INTO tiy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Been i niy funay de odoroy de Judio ménséfénginsa maro, “Aw fétoyo moso? Aw been i nan i funa nuwe ménbéréh mano, ‘Enda géangéy gom dob ayo kuwe?’ ” ");
INSERT INTO tiy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Atin ménbéréh man i Jesuse mano, “I begome, tidéw gom fantad, éndob i Begéne tidéwu rotor. I begome, tidéw gom dob duniyae, éndob i Begéne tidéwu dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Komon bénréh gu begom buluk méléhu gom moso, énda émfésagadan i de sala gom. Toow, amuk énda munur gom de ké Begéney Beene bénréh gu, énda émfésagadan i de sala gom.” ");
INSERT INTO tiy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Atin ménénginsa ro maro, “Ati mélaw i Beeme ni?” Séménumbul i Jesuse mano, “Tidéw bé féganaye de séna bé kétoro guwe, nuret gun begom ké ati Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Atin médoo sénay de béréhé ku fantag bé de rénigo gom do tete funa kom mékukum. Toow i bénréh i séménugue Begén, komon ureté ku dob de étéw i énggélingoo kuwe saén tidéw dob Beene.” ");
INSERT INTO tiy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Endob i de étéw diyo, énda énggésobuto ro de ké ureté noy fantage bé Abaye Tulus. ");
INSERT INTO tiy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mélaw ménbéréh i Jesuse mano, “Buluk tunggulé komén Begén, sani Nga i Kéilawane, béno na gétiga kom Begéney Beene bénréh gu. Atin gétiga kom so bé énda i rigoné ku ké tidéw saén dob Begéne, éndob béréhé ku saén i ténoro i Abaye Begén. ");
INSERT INTO tiy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Brab dumo guy séménugue Begén. Enda ténagakén Begén non démoyun rigoné kuy késuwata nuwe.” ");
INSERT INTO tiy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Atin médooy de étéw énggégélingo bé de ni, ménunur ro dob Beene. ");
INSERT INTO tiy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mélaw bénréh Jesuse dob de Judio ménunur de mano, “Amuk modor gom bé ténoro guwe, begom i de tintu kuyug gu, ");
INSERT INTO tiy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","atin gétiga kom i toowe kétoro, atin i toowe kétoro i témangéye begom.” ");
INSERT INTO tiy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Sénumbulo ro maro, “I begeye ni do séfu Abraham gey brab énda ménrifén gey, atin sede mélaw ké béréhé mo fétangéy gey?” ");
INSERT INTO tiy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Séménumbul i Jesuse mano, “Béréhé ku begom i toowe, i kéluhanay étéwe rémigo tete maak riféy salae. ");
INSERT INTO tiy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I riféne, fakay dédélén tidéw dob lawie. Endob i nga i gefee lawi, gébati dob nan lawi taman sa taman. ");
INSERT INTO tiy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mélaw amuk Nga i Tulusey témangéye begom, tintu gom békénén rifén. ");
INSERT INTO tiy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gétiga ku do onok Abraham gom. Endob méuyot gom méméléhu Begén, non énda tayakufé kom i kétoro guwe. ");
INSERT INTO tiy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Béréhé kuy ati fénggitoy Abay guwe Begén, éndob rigoné kom mon i énggélingoo kome dob kagome abay.” ");
INSERT INTO tiy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Séménumbul ro maro, “Abraham i kageye katufuan.” Atin bénréh Jesuse bero mano, “Amuk do tintu onok Abraham gom damén, rigoné kom soy loo bé rénigo Abrahame. ");
INSERT INTO tiy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bénréh gu begom i toowe énggélingoo ku tidéw dob Tuluse, éndob méuyot gom Begén méméléhu. Endob békén loo bé nan i rénigo Abrahame. ");
INSERT INTO tiy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Rigoné kom i ségiléwe bé rénigoy abay gome.” Endob ménkérit i de Judio maro, “Békén gey nga dob liyuwe, Tulus saén i Abay geye.” ");
INSERT INTO tiy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Atin bénréh Jesuse bero mano, “Amuk toow fo Abay gom i Tuluse, méimu gom damén Begén, non tidéwu dob Tuluse. Enda ménangéyu dini dob kagéne aturan, éndob Tulusey séménugue Begén. ");
INSERT INTO tiy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sedek énda gésobuto kom i béréhé kuwe ni? Non mika gom keeyén munur bé toroé kuwe. ");
INSERT INTO tiy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satanas i abay gome atin rigoné kom i kétayay Satanase. Méméléhu étéw tidéw féganay brab tugién non énda i toow dob beene. Atin amuk témugi, rigoné no say adat ne non beeney bebe i kéluhanay tugiéne. ");
INSERT INTO tiy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Endob toow i kagéne kébéréh, mélaw énda unuro kom Begén. ");
INSERT INTO tiy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ati géféténgténge de begom ké wén i sala gu? Enda. Atin amuk toow i béréhé kuwe, sedek énda munur gom Begén? ");
INSERT INTO tiy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","I tidéwe dob Tuluse fégélingoé noy kébéréh i Tuluse. Endob békén gom tidéw dob Tuluse, mélaw énda fégélingoé kom i kébéréh i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tidéw béno, fénénginsaay de Judio maro, “Aw békén ba toow i bénréh geye ségétéw go tidéw Samaria brab sénaitanan go?” ");
INSERT INTO tiy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Séménumbul i Jesuse mano, “Békénu sénaitanan. I toowe, basana kuy Abay guwe éndob énda basana kom Begén. ");
INSERT INTO tiy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Enda fébantug-bantugu, éndob i Tuluse kétaya no ké basananu, atin Been i gétigane bé ati fatute. ");
INSERT INTO tiy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Béréhé ku begom i toowe, i de modor bé kétoro guwe, énda méléhu ro.” ");
INSERT INTO tiy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Atin ménbéréh i de Judio maro, “Béleewe ni gétiga keyén sénaitanan go. I Abrahame ménléhu, brab do sénarigoy Tuluse muret bé kébéréh ne, ménléhu ro so. Endob bénréhém i modore bé kétoro me énda méléhuén. ");
INSERT INTO tiy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aw toow go na fo gérotor bé Abrahame katufua key? Ménléhu i Abrahame brab de sénarigoy Tuluse so. Ati kéfégitung me bé Beeme?” ");
INSERT INTO tiy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Séménumbul i Jesuse mano, “Amuk bantugé kuy lowoh guwe so, énda i lanték i bantuga kuwe. Endob i Abay guwe Tulus, Been i mirayane Begén bantugan. Béréhé kom féngadafé kom i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Endob énda gélolo gom de. Endob i Begéne, gélolo gu. Amuk béréhé ku énda gélolo gu de, waléyu témugi ségiléw bé begome. Endob i toowe, gélolo guy Beene, brab modoru bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I katufua kome Abraham moror de bé kégito nuwe bé kégumah guwe. Enggito no, komon moror béni.” ");
INSERT INTO tiy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sabaf bé ni, ménbéréh i de Judio maro, “Enda séna ménlimo go folo gébélintuwa, éndob bénréhém bé énggito mon i Abrahame?” ");
INSERT INTO tiy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Séménumbul i Jesuse mano, “Béréhé ku begom i toowe, énda séna ménumah i Abrahame de, i Begéne ménwénén.” ");
INSERT INTO tiy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sonom béno, ménémurut ro batéw inok ibéré ro dob Jesuse damén taman méléhu, éndob ménrékunéy i Jesuse brab méntékédan dob lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Atin amun ménagéw i Jesuse, énggito noy ségétéwe lagéy langafén tidéw fanay kéumahén. ");
INSERT INTO tiy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Atin i de kuyug Jesus ménénginsa ro maro, “Maistéro, ati funa nuwe ménumah langafén? Non bé sala ne loo ké sala i de lukésén?” ");
INSERT INTO tiy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Atin séménumbul i Jesuse mano, “Békén sabaf bé sala ne taloo no sala i de lukésén. Endob i funa nuwe langafén inok giton i barakat i Tuluse mérigo dob beene. ");
INSERT INTO tiy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Fatut rigoné tom i fégalbék i Tuluse séménugu Begén, lokut fuweh séna. Gégumah i kélungonone, bé béno éndaén i ségétéw gégalbék. ");
INSERT INTO tiy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Amun diniwu dob duniyae, maak géfékaya non Begén i Soloe réméndaw dob kéilawane.” ");
INSERT INTO tiy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Amun énggilid i Jesuse émbéréh, déménura dob fantade brab fénlémbuwekén i sébuwane bé dura ne. Tidéw béno, dénuletén dob de motoy ni lagéy langafén. ");
INSERT INTO tiy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Atin ménbéréh i Jesuse mano, “Ay go dob kérigéwe féndawét Siloam, brab furauf go diyo.” (I atag i Siloame “sénugu”.) Mélaw ménagéw i langaféne ni brab rénigo noy férigowe de. Atin amun ménséfule, énggégitonén. ");
INSERT INTO tiy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tidéw béno, i de dumo ro ségédét lawi brab de étéw énggégito de mongot limus, ménséfénginsa ro maro, “Aw békén ba beeney étéwe déménoyun mésar mongot limus?” ");
INSERT INTO tiy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Atin séménumbul i de dumo de maro, “Been bay nan.” Endob bang i de dumo de, “Békén been i nan, ségiléw ro sa keey falas.” Tidéw béno, i ni lagéy ménbéréh mano, “Begén bay no étéw langafén bé gétaho.” ");
INSERT INTO tiy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Atin ménénginsa ro maro, “Sedek énggégito gon béleewe?” ");
INSERT INTO tiy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Atin séménumbul i ni lagéy mano, “I lagéye féndawét Jesus, fénlémbuwekén i sébuwane atin dénuletén dob de moto gu. Atin sénuguén begén mangéy mérauf dob Siloam. Tidéw béno, ménagéwu brab ménuraufu, atin sonom béno énggégitowun.” ");
INSERT INTO tiy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Atin ménénginsa ro maro, “Hon i gonoy nan de lagéy béleewe ni?” Endob séménumbul mano, “Enda gétiga ku de.” ");
INSERT INTO tiy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tidéw béno, nuwit roy ni lagéy éndaén langaféno mangéy dob de Fariseo. ");
INSERT INTO tiy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gai kétérén i kéfélémbuwek Jesuse bé sébuwane brab kéuwa ne bé motoy ni lagéy. ");
INSERT INTO tiy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fénénginsaay de Fariseo ké ati kéfingé-fingé i kégégito nuwe. Atin séménumbul i ni lagéy mano, “I Jesuse, fénlémbuwekén i sébuwane brab dénuletén dob de moto gu. Tidéw béno ménuraufu, atin sonom béno énggégitowu.” ");
INSERT INTO tiy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tidéw béno, i de dumo do Fariseo ménbéréh ro maro, “I Jesuse békén tidéw dob Tuluse non énda modorén bé ménbéréhe dob kitabé bé énda fakay i gémalbéke ké gai kétérén.” Endob i de dumo de ménbéréh ro maro, “Amuk i Jesuse ségétéw ménsala, énda fo gérigo no bé mékégaife.” Mélaw énda géséodor i de antaf fédéw ro. ");
INSERT INTO tiy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mélaw ménénginsa man i de Fariseo dob lagéye ni maro, “Ati karang me bé Jesuse ni étéw, non énggéféadi-adino no kun i de moto mo?” Atin séménumbul i ni lagéy mano, “Beeney sarigoy Tuluse muret bé kébéréh ne.” ");
INSERT INTO tiy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Endob i de odoroy de Judio énda fo munur ro de ké langafén i ni lagéy tidéw bé do gétah, mélaw féntawag roy de lukésén. ");
INSERT INTO tiy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Atin fénénginsaa ro bero maro, “Aw nga gom i ni? Aw langafén ba tidéw fanay kéumahén? Sedek énggégitonén béleewe ni?” ");
INSERT INTO tiy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Séménumbul i de lukésén maro, “Gétiga key beeney nga geye brab langafén tidéw fanay kéumahén. ");
INSERT INTO tiy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Endob énda énggétiga key de ké ati kéfingé-fingé i kégégito nuwe béleewe, taloo no ati ménuwae de. Endob fénginsaa kom i beene, non métuwanén san brab been i sémumbulone begom.” ");
INSERT INTO tiy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ménbéréh i boh ne brab idéng ne loo bé ni non mégilak ro bé de odoroy de Judio. Non sénfagayunoy de odoron éndaén féahurén dob de lawi féngadafan i étéwe ké béréhé noy Jesusey Kristowe tidéw dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Been i niy funay boh i ni lagéy brab idéng ne séménumbul maro, “Métuwanén i nga geye, been i fénginsaa kome.” ");
INSERT INTO tiy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mélaw i de Fariseo féntawag ron man i lagéye ni éndaén langaféno brab ménbéréh ro maro, “Béréhém i toowe dob adafay Tuluse. Gétiga key i Jesuse ni ségétéw ménsala.” ");
INSERT INTO tiy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mélaw séménumbul mano, “Enda gétiga ku de ké i Jesuse wén i salaén loo ké énda. Ni saén i kagéne gétigan, bé gétaho langafénu éndob béleewe énggégitowun.” ");
INSERT INTO tiy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Fénénginsaa ron man maro, “Ati rénigo nuwe dob beeme? Ati kéfingé-fingé i kéféadi-adi nuwe bé de moto mo?” ");
INSERT INTO tiy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Séménumbul mano, “Bénréh gun begom, éndob énda fo fégélingoé kom de. Sede méuyot gom de man mégélingo ségule? Aw méuyot gom de ké waléy gom do kuyugén so?” ");
INSERT INTO tiy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tidéw béno, fénéngiras ro, brab bénrého ro maro, “Beem say kuyugén. Endob i begeye kuyug Moises gey. ");
INSERT INTO tiy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gétiga key ménsébéréh i Tuluse bé Moisese bé do gétah. Endob i ni étéw, énda gétiga key de ké hon i kétidéw ne de.” ");
INSERT INTO tiy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Séménumbul i ni lagéy mano, “Toow fo mékégaif i nan. Enda gétiga kom wayoy tidéwo nuwe de, éndob fén-adi-adi noy de moto gu. ");
INSERT INTO tiy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gétiga tom i Tuluse, énda fégélingoé noy de ménsala. Endob fégélingoé noy de étéw méngintulus, rémigo bé kétaya nuwe. ");
INSERT INTO tiy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tidéw féganay kélimbag bé duniyae ni énda sénay ségétéw géféadi-adi ségétéw langafén tidéw fanay kéumahén inok waléy gégito. ");
INSERT INTO tiy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mélaw i Jesuse, amuk békén tidéw dob Tuluse, énda gérigono no de.” ");
INSERT INTO tiy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tidéw béno, ménkérit ro brab séménumbul ro maro, “I beeme fénggénga go toow fo ménsala, sedek beeme nay témoroe begey?” Tidéw béno éndaén, fénrahur ro de dob lawie féngadafan. ");
INSERT INTO tiy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Amun énggélingoo Jesusey kénrigo ruwe bé ni lagéy, ménangéy dob beene. Amun énggito no, ménsébéréh i Jesuse de mano, “Aw munur go bé Nga i Kéilawane?” ");
INSERT INTO tiy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Séménumbul i ni lagéy mano, “Maistéro, béréhém begén ké ati no étéw inok géunuru de.” ");
INSERT INTO tiy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Séménumbul i Jesuse mano, “Enggito mon, non Been i Begéne sébéréh beem.” ");
INSERT INTO tiy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tidéw béno, ménbéréh i ni lagéy mano, “Kadnan, munuru Beem.” Atin fénéngadafén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Atin ménbéréh i Jesuse mano, “Kékukum i funa kuwe ménangéy dob duniyae ni. I Begéne maak solo i de maak langafén inok waléy ro gégito amuk munur ro Begén. Atin i de gégito, sani de gétigan étéw, waléy ro maak langafén amuk énda munur ro Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wén i de Fariseo énggégélingo bé kébéréh Jesuse, atin ménénginsa ro maro, “Sede? Aw do langafén gey so?” ");
INSERT INTO tiy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Séménumbul i Jesuse mano, “Amuk maak do langafén gom, énda damén i sala gom, éndob béleewe ni makom ké do gégito gomén, non makom ké toow gomén gétigan. Been i nan i funa nuwe i de sala gom énda mékédano.” ");
INSERT INTO tiy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","I Jesuse, ménuret sébaan binuwaya mano, “Béréhé ku begom i toowe, i étéwe mahur dob rugéy de bili-bili énda mangéyén bé béngawane atin mangéy man bé de ségiyo agéwon, i nan étéw ménakaw brab tulisan. ");
INSERT INTO tiy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Endob i étéwe mahur mangéy bé béngaway rugéy de bili-bili, beeney témalimae bé de bili-bili. ");
INSERT INTO tiy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","I mantaye dob fintue ungkaé noy béngaway rugéne inok géahur i témalimae bé de bili-bili. Brab i de bili-bili gélolo roy béréh ne. Brab tawagé noy de kaan do bili-bili bé de dawét ro. Tidéw béno, fanangguwité no bero mésut tidéw dob rugéne mangéy dob de fétabtaban. ");
INSERT INTO tiy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Atin amuk mésut ro, métah bero brab i de bili-bili furay ro de non gélolo roy béréh ne. ");
INSERT INTO tiy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Enda furay ro bé ségiyowe étéw, yamula féraréyo ro non énda gélolo roy béréh ne.” ");
INSERT INTO tiy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Bénréh Jesuse beroy ni binuwaya éndob énda fo énggésobuto ro de. ");
INSERT INTO tiy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mélaw i Jesuse ménbéréh man mano, “Béréhé ku begom i toowe, Begéney maake béngawan ahuroy de bili-bili. ");
INSERT INTO tiy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","I de énggéétah Begén do tugién témoro, beroy maake do ménakaw brab do tulisan. Endob i de kagén do étéw, beroy maake bili-bili, énda fo fénggélingo ro bero. ");
INSERT INTO tiy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Begéney béngawane. I kéluhanay mahure dob Begéne, méfukas ro dob de sala ro. Ségiléw ro bé de bili-bili, mahur ro brab mésut ro atin géagéw ro dob fiyowe tabtabén non talimaé ku bero. ");
INSERT INTO tiy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","I tulisane, sani tugiéne témoro mangéy sa dini inok ménakaw brab méméléhu brab méminasa. Endob i funa kuwe ménangéy dini inok iray gu dob de kéilawan i umule énda i kulang de taman sa taman. ");
INSERT INTO tiy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Begéney fiyowe témalima bé de bili-bili, non iray guy férénawa guwe inok méfukas i de kuyug gu. ");
INSERT INTO tiy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","I ségétéwe étéw témalima bé de bili-bili sukayan saén, békén been i gefee de, méraréy ké gégito itu-talun. Tidéw béno, i itu-talune rambaé noy de bili-bili brab béragaré no bero. ");
INSERT INTO tiy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","I ni étéw sukayan saén tagaké noy de bili-bili non békén kaan brab énda fo méimuén bero. ");
INSERT INTO tiy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Endob Begéney maake fiyo témalima bé de bili-bili. Gélolo guy de kuyug gu, brab i de kuyug gu gélolo ro Begén, ");
INSERT INTO tiy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ségiléw bé kégélolo guwe bé Abay guwe Tulus brab kégélolo nuwe Begén. Atin i Begéne iray guy férénawa guwe inok méfukas i de kuyug gu dob de sala ro. ");
INSERT INTO tiy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wén i de ségiyo do bili-bili gu békén tidéw dob ni rugén. Fatut fanangguwité ku so bero brab fégélingoé roy béréh guwe. Mélaw i de kéluhanay de étéw gu, waléy sébaan i rugé ruwe brab ségétéw i témalimae de. ");
INSERT INTO tiy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“I funay Abay guwe méimu Begén, non énda gulaané kuy férénawa guwe. Endob amuk méléhuu, méuyagu man. ");
INSERT INTO tiy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Atin énda i géafas bé férénawa guwe tidéw dob Begéne, éndob kétaya ku fo iray gu. Wén i kuwagib gu de miray brab wén soy kuwagib gu de médot man ségule. Been i niy sénugu i Abay guwe Begén rigoné ku.” ");
INSERT INTO tiy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Amun énggélingooy de Judio man i kébéréh Jesuse, énda man énggéséodor i de antaf fédéw ro. ");
INSERT INTO tiy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Médooy de étéw, ménbéréh ro maro, “Bunég i ni étéw brab rénahuko saitan. Kagom fégélingoén de.” ");
INSERT INTO tiy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Endob i de dumo de ménbéréh ro maro, “Enda gébéréh loo bé nan i étéwe rénahuko saitan. Atin énda gaganéy ségétéwe sénaitanan i émféadi-adiwe bé de motoy langaféne inok waléy gégito.” ");
INSERT INTO tiy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tidéw béno, énggumah i gaiwe kandulioy de Judioy kéfégétédém ruwe bé kéfélinise bé lawi i Tuluse. Bé béno, gai mélégénéy. ");
INSERT INTO tiy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Atin i Jesuse diyo dob lawi i Tuluse séagéw-agéw dob agéwone wén i atéfén, féndawét bé dawét i méntélatae datu Solomon. ");
INSERT INTO tiy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Atin i de Judio ménsélimud ro dob Jesuse brab ménénginsa ro maro, “Taman kédiron nay kéféongot-ongot me begey? Amuk Beemey Kristowe, san i fénémili i Tuluse méguléw, béréhém begey i mékéntaye.” ");
INSERT INTO tiy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Séménumbul i Jesuse mano, “Bénréh gun begom éndob énda munur gom de. I de mékégaif galbék fénrigoy Abay guwe Tulus Begén, been i da nan i émfégétigane begom fantag bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Endob énda munur gom de non békén gom do bili-bili gu. ");
INSERT INTO tiy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","I kagéne do bili-bili fégélingoé roy kébéréh guwe brab gélolo gu bero, atin furay ro Begén. ");
INSERT INTO tiy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iraya ku bero umul magufusa, brab énda méléhu ro. Atin énda i géafas bero tidéw dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","I Abay guwe Tulus toow na fo gérotor bé kéluhanane. Been i méniraye bero dob Begéne. Atin énda i géafas bé de bili-bili gu tidéw dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","I Begéne brab Abay guwe Tulus, sébaan gey saén.” ");
INSERT INTO tiy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tidéw béno, i de Judio ménurut ro batéw man inok ibéro ro batéw i Jesuse féléhué ro damén. ");
INSERT INTO tiy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Endob ménbéréh i Jesuse mano, “Médoonén i fiyowe galbék fénrigoy Abay guwe Tulus Begén dob téngaanga kome. Ati isuwe bé de ni funa kom Begén méméléhu?” ");
INSERT INTO tiy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Séménumbul i de Judio maro, “Békén bé de fiyo galbék i funa keye Beem méméléhu, éndob sabaf mékémurka dob Tulusoy nan béréhé mo. I Beeme ségétéw go saén kéilawan, sedek béréhé mo Tulus go?” ");
INSERT INTO tiy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tidéw béno, séménumbul i Jesuse mano, “Endob wén i Ménsulate Kébéréh i Tuluse dob Kitab gome mano, ‘Do tulus gom.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Féntaus Jesusey kébéréh ne mano, “Enggétiga tom, i Ménsulate Kébéréh i Tuluse toow fo toow taman sa taman. Mélaw ténawag i Tuluse do tulus i de katufua tom niraya no bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Atin Begéney fénémili i Abaye brab sénuguén mangéy dini dob duniyae. Mélaw sedek béréhé kom mékémurka i bénréh guwe bé Begéney Nga i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Amuk énda rigoné kuy fégalbék i Abay guwe Begén, kagom munur Begén. ");
INSERT INTO tiy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Endob amuk rigoné ku, fatut unur gom bé de génalbék gu, fiyon fo ké énda munur gom bé kébéréh guwe, inok gétiga kom brab gésobuto kom i Abaye dini dob Begéne, atin i Begéne diyou dob Abaye.” ");
INSERT INTO tiy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Amun énggélingoo roy ni kébéréh Jesuse, ténulama ro man i kéméfoe de, éndob énggéséliyah brab ménsut. ");
INSERT INTO tiy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Atin ménséfule i Jesuse mifar dob wayége Jordan dob gono Juane mautis bé gétahe de. Atin diyo ménbati. ");
INSERT INTO tiy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Atin médooy étéwe ménangéy dob Beene. Atin ménsébéréh-béréh ro maro, “Fiyon fo ké i Juane énda i do rénigo no mékégaif, éndob toow i kéluhanay bénréh ne fantag bé Jesuse ni.” ");
INSERT INTO tiy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Atin diyo médooy ménunure bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wén i ségétéwe lagéy déméruun, i dawét ne Lasaro, diyo bati dob Betania. I Mariahe brab Martahe do tuwaréyén libun bati ro so dob no ingéd. ");
INSERT INTO tiy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Been i niy Mariahe léménuka bé fégéféamute dob de sékéy i Kadnane Jesus brab kénayasén bé buk ne. Atin i Lasarowe lagéyén déméruun. ");
INSERT INTO tiy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mélaw i de libuno ménféuwit ro kébéréh mangéy dob Jesuse maro, “Kadnan, i toowe fo kégédawa mo dumo mo séloyuk, déméruun.” ");
INSERT INTO tiy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Amun énggélingoo Jesusey ni, ménbéréh mano, “Enda méléhu i Lasarowe bé nan déruun. Ménrigoy ni inok médayéw i Tuluse, atin tidéw so dob ni médayéw soy Begéne sani Nga i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Toow fo méimu i Jesuse bé de ni sétuwaréy ro Martah, Maria, brab Lasaro. ");
INSERT INTO tiy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Endob fiyon fo ké énggélingoo Jesuse déméruun i Lasarowe, énda na ménagéwén tidéw dob gono nuwe bati taman énda féntibusén nay ruwowe gétérésangan. ");
INSERT INTO tiy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tidéw béno, ménbéréh dob de kuyugén mano, “Séfule tom mangéy Judea.” ");
INSERT INTO tiy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Endob bang i de kuyugén, “Maistéro, békén ba énda séna ménrugay i kétulamay de Judio diyo Beem méméléhu? Mélaw énda fatutén séfule gon man mangéy diyo.” ");
INSERT INTO tiy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Séménumbul i Jesuse mano, “Aw békén ba folo bra ruwo géuras i ségéfuwehe? Atin énda gébangkud i étéwe magéw ké fuweh non gito noy géfékayae dob duniyae. ");
INSERT INTO tiy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Endob i étéwe magéw ké kélungonon gébangkud non délémon.” ");
INSERT INTO tiy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nuret Jesusey binuwayae ni inok fégétiga no bé de kuyugén bé énda gésug-sugén diyo dob Judea non énda séna fénggilidén i galbék ne. Amun énggilid Jesuse bénréh i ni, rénéfaa no mano, “I Lasarowe dumo tom séloyuk, fidong. Mangéyu diyo inok ulégé ku.” ");
INSERT INTO tiy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Atin i de kuyugén ménbéréh ro maro, “Amuk fidong, waléy adi-adi.” ");
INSERT INTO tiy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Endob i atag i bénréh Jesuse, ménléhu i Lasarowe, éndob énda énggésobutoy de kuyugén de. Marok tintu fidong. ");
INSERT INTO tiy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mélaw bénréh Jesuse fénkéntayén dob berowe mano, “Ménléhuén i Lasarowe. ");
INSERT INTO tiy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Endob sabaf bé begome, mororu non énda diyou. Non wén i rigoné kuwe funa kom munur Begén. Enggomén, magéw tomén.” ");
INSERT INTO tiy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Atin ménbéréh i Tomase (féndawét so “Séfing”) dob de dumo no kuyugén mano, “Modor tom de inok méléhu tom so séréngan bé Jesuse.” ");
INSERT INTO tiy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Amun énggégumah ro diyo, énggélingoo Jesuse bé ménfotén gétérésangan i kélébéng ruwe bé Lasarowe. ");
INSERT INTO tiy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I ingéde Betania, gédét saén dob Jerusalem, téléw gékilomitroy kérayu ne. ");
INSERT INTO tiy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Atin médooy de Judio ménangéy diyo inok féfiyoné roy de fédéw ro Martah brab Maria bé kéléhu i lagéy ruwe. ");
INSERT INTO tiy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Amun énggélingoo Martahe gédét gumah i Jesuse, ménagéw bénalakén, éndob i Mariahe ménféled dob lawie. ");
INSERT INTO tiy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Atin ménbéréh i Martahe dob Jesuse mano, “Kadnan, amuk dini go, énda damén ménléhu i lagéy guwe. ");
INSERT INTO tiy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Endob gétiga ku fiyon fo ké béleewe ni, iray i Tuluse Beem i ati ongoté muwe de.” ");
INSERT INTO tiy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Atin ménbéréh i Jesuse mano, “Tébule i lagéy me.” ");
INSERT INTO tiy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Atin bang Martahe, “Gétiga ku tébule moso beroy kéluhanay de étéw dob tamfaday de gai.” ");
INSERT INTO tiy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Séménumbul i Jesuse mano, “Begéney témbulee brab miraye umul. I étéwe munur Begén, fiyon fo ké méléhu, méuyag so. ");
INSERT INTO tiy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Atin i méuyage étéw munur Begén, éndaén méléhuén. Munur go bé ni?” ");
INSERT INTO tiy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Atin séménumbul i Martahe mano, “Hoo Kadnan, munuru Beemey Kristowe, sani nongot-nongot geye Nga i Tuluse ménangéy dob duniyae ni.” ");
INSERT INTO tiy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Amun énggilid Martahe bénréh i ni, ménséfule mangéy dob Mariahe dumo no brab ménséguraw mano, “Enggumah i Maistérowe brab féntawagén beem.” ");
INSERT INTO tiy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Amun énggélingoo Mariahey ni, ménagayas témindég brab ménagéw bénalakén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(I Jesuse énda séna énggumahén dob ingéde, diyo séna dob gonoy bénalaka Martahe de.) ");
INSERT INTO tiy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Atin i de Judio diyo ro dob lawie émféfiyo bé fédéw Mariahe, amun énggito roy Mariahe ménagayas témindég brab ménagéw, ménfuray ro de. Marok mangéy kémérew dob lébénge. ");
INSERT INTO tiy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Amun énggumah i Mariahe dob gono Jesuse, méntéléngkéb dob adafa nuwe brab ménbéréh mano, “Kadnan, amuk dini go, énda damén ménléhu i lagéy guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Amun énggito Jesusey Mariahe kémérew brab de Judio ménodor de kémérew ro so, ménuray i na Jesuse brab toow fo méntete i fédéw ne. ");
INSERT INTO tiy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Atin ménénginsa i Jesuse mano, “Hon i gonoy lénébéngo kome de?” Séménumbul ro maro, “Kadnan, mangéy tom diyo.” ");
INSERT INTO tiy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tidéw béno, kéménrew i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mélaw ménsébéréh-béréh i de étéw maro, “Téngténg gom, toow fo mégédaw i Jesuse bé Lasarowe.” ");
INSERT INTO tiy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Endob bang i de dumo de, “Enggéféadi-adino noy de motoy langaféne. Sedek énda énggéféadi-adino noy Lasarowe inok énda damén ménléhuén?” ");
INSERT INTO tiy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Atin amun énggégumah i Jesuse dob lébénge, toow fo méntete i fédéw ne. I ni lébéng takub, atin ténléb roy béngawa nuwe bé dakéle batéw. ");
INSERT INTO tiy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tidéw béno, ménbéréh i Jesuse mano, “Kéda kom i batéwa nan.” Endob i Martahe, libuy ni ménléhu ménbéréh mano, “Endob mahuén i bangkay ne béleewe ni, non ménfotén gétérésangan i kélébénge de.” ");
INSERT INTO tiy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Atin ménbéréh man i Jesuse mano, “Bénréh gun dob beeme, amuk munur go, gito moy barakat i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mélaw kénda roy batéwe dob béngaway lébénge. Atin i Jesuse léménéngag brab ménbéréh mano, “Abay, toow fo fésalamatu dob Beeme non fénggélingoém Begén. ");
INSERT INTO tiy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Atin gétiga ku fégélingoé mo Begén sénga tékélid. Endob dasala kuy ni béleewe non bé de étéw géliwét Begén inok munur ro Beem i séménugue Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Amun énggilid bénréhén i ni, ménbéréh toow fo métanug mano, “Lasaro, sut go!” ");
INSERT INTO tiy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tidéw béno, méntébule i Lasarowe brab ménsut. Atin méntabéd i de kémérén brab de sékéyén bé de safut fénggébaus bé lowoh ne, brab méntéléb i rangih ne bé munsalawe. Atin ménbéréh i Jesuse mano, “Kéda kom i de fénggébaus de nan inok éndaén méfukétén.” ");
INSERT INTO tiy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Médooy de Judio ménangéy témukaw bé ro Mariahe, amun énggito roy rénigo Jesuse, ménunur ro dob Beene. ");
INSERT INTO tiy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Endob i de dumo bero, ménangéy ro dob de Fariseo brab nuret roy rénigo Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mélaw i de odoroy de fadi brab de Fariseo, ménsélimud ro beroy de kéfédéway de Judio. Atin ménbéréh ro maro, “Ati rigoné tome? Non i Jesuse ni rémigo médoo do mékégaif. ");
INSERT INTO tiy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Amuk fédayaé tom i ni rigoné no, kéluhanay étéwe munur dob Beene. Tidéw béno, waléy datu i de Judio atin mékérit i datu tome tidéw Roma. Tidéw béno, mangéy diniy de sundaloy de Romano inok binasané roy lawi i Tuluse gono tom méngadaf, loo soy ingéd tome.” ");
INSERT INTO tiy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Endob ménbéréh i Kayafase, sani gérotore fadi bé no bélintuwa mano, “Enda i lanték gom. ");
INSERT INTO tiy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aw énda ba gétiga kom de, labi na fiyo ké ségétéw saén i méléhue gémantinon bé kéluhanay Judiowe, inok énda mébinasay ingéd tome?” ");
INSERT INTO tiy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Bénréhén i ni békén tidéw dob kaane saén kéfégitung. Non beeney toowe gérotor fadi bé no bélintuwa, mélaw sénarigoy Tuluse émbéréh bé i Jesuse méléhu inok méuyag i de étéw Judio. ");
INSERT INTO tiy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Atin békén say de Judio, non i funa Jesuse méléhu inok i kéluhanay de nga i Tuluse, sani de munur dob Beene, fiyon atiy gonone tidéwo ro, waléy ro sébaan. ");
INSERT INTO tiy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mélaw tidéw bé no gai, i de odoroy de Judio fégitungé roy ati kéféléhu ruwe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mélaw éndaén féira-iray Jesuse dob Judea ké magéw. Yamula ménangéy Efraim gédét dob gonone énda i étéw de bati. Atin diyo ménbati beroy de kuyugén. ");
INSERT INTO tiy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Amun gédétén i kékanduli i de Judio féndawét “Témara”, médooy de étéw tidéw dob de ségiyo-giyo gonon ménangéy Jerusalem. Diyo ro rénigoy adate féndawét “Félinis” inok géamung ro bé kandulie ni. ");
INSERT INTO tiy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Atin sélédé roy Jesuse non énda énggito ro de diyo. Atin ménséfénginsa ro dob lawi i Tuluse maro, “Ati karang gome de, mangéy keey diniy Jesuse bé ni kékanduli, loo ké énda?” ");
INSERT INTO tiy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Non i de odoroy de fadi brab de Fariseo, bénréh ro dob de étéw buluk wén i ségétéw gégito bé gono Jesuse, béréhé no dob berowe inok gékéfoo ro. ");
INSERT INTO tiy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ném séden kélungonon taman bé gaiy kékanduli ruwe féndawét “Témara”, i Jesuse ménangéy Betania, sani ingéd Lasarowe, i lagéye ténébuleén. ");
INSERT INTO tiy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Diyo ténafay roy kandulie fégébasa bé Jesuse. Bé no témégén, i lala Martahe démuwot, ménsar i ro Jesuse bero Lasaro. ");
INSERT INTO tiy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Atin i Mariahe éndotén i dakéle katiya ménféno fégéféamut féndawét nardo, toow fo balilaga, atin lénukaén dob de sékéy Jesus. Tidéw béno, kénayasén bé buk ney de sékéy Jesus. Atin ménlégéb i duwaléy lawie bé téréhung i ni fégéféamut. ");
INSERT INTO tiy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Endob i ségétéwe bé de kuyugén féndawét Judas Iskariot, sani ménfékéfoe de, ménbéréh mano, ");
INSERT INTO tiy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sedek séninggula saén i nan fégéféamut? Non amuk fénbéléy damén i nan nor, wén i médoo kurta gédotén de brab iray damén dob de méskinan.” ");
INSERT INTO tiy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Endob békén toow i kéuray i na nuwe bé de méskinan. Enggébérého noy no non i beene ségétéw ménakaw. Beeney témimue bé kurta ruwe, brab sénga tékélid médot de. ");
INSERT INTO tiy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Endob séménumbul i Jesuse mano, “Kago élénén i Mariahe. Atin fatut itongé noy sama ne inok wén i fégéféamut bé gaiwe kélébéng bé bangkay guwe. ");
INSERT INTO tiy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","I de méskinan bati dob begome sénga tékélid. Endob i Begéne, éndaén mérugayu bati dini dob begome.” ");
INSERT INTO tiy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Médooy de étéw énggélingoo ro diyo i Jesuse dob Betania. Mélaw ménangéy ro diyo. Békén say Jesusey funa ruwe mangéy diyo, non ménangéy ro diyo inok gito ro soy Lasarowe, sani lagéye ténébuleén. ");
INSERT INTO tiy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mélaw i de odoroy de fadi bénantak fédéw roy féléhué ro soy Lasarowe. ");
INSERT INTO tiy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Non Lasarowey funay médoowe Judio téménrén modor bé kétoro i de odoro ro atin méngganay ro munur bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bé gétunduge de fuweh, médooy de étéw do ménangéy dob Jerusalem inok mamung bé ni kanduli féndawét Témara, énggélingoo roy Jesuse mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mélaw méndot ro do dau bongo brab ménsut ro dob ingéde inok balaké roy Jesuse. Ménbéréh ro métanug maro, “Dayéwé tom i Tuluse! Féfiyonéy Tuluse damén i ni gégumah tidéw dob Kadnane! Beeney datu tome do Judio!” ");
INSERT INTO tiy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Atin éndot Jesusey natiy kudae brab kénudaa no. Mélaw méntuman i Ménsulate Kébéréh i Tuluse mano, ");
INSERT INTO tiy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“I begome do étéw dob Jerusalem, kagom mégilak. Non gégumah i datu gome kémuda dob natiwe.” ");
INSERT INTO tiy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Enda fo énggésobutoy de kuyug Jesus i de ni bé no gai. Endob amun déméniyat i Jesuse, énggétédémo ro brab énggésobuto roy Ménsulate Kébéréh i Tuluse, brab been i niy rénigo ruwe dob Jesuse funan méntuman i Ménsulate Kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bé béni, i de médoo do étéw énggégito bé kétawag ne brab kétébule ne bé Lasarowe, nuret ro dob de dumo roy fantage bé rénigo Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Been i niy funay médoowe étéw ménalak bé Jesuse dob de agéwon non énggélingoo roy rénigo nuwe ni mékégaif. ");
INSERT INTO tiy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mélaw ménsébéréh-béréh i de Fariseo maro, “Endaén i fiyo rigoné tom, énténg gom kéluhanay étéwe modor ro de.” ");
INSERT INTO tiy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Atin diyo soy do étéw tidéw dob ingéde Gris. Ménangéy ro so Jerusalem inok géféngadafa ro bé no kékanduli. ");
INSERT INTO tiy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ménangéy ro dob Filipihe (sani tidéwe Betsaida, sébaan ingéd dob sakuf i Galileawe), brab ménbéréh ro maro, “Maistéro, méuyot gey géségito bé Jesuse.” ");
INSERT INTO tiy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tidéw béno, bénréh Filipihe bé Andrese, brab ruwo ro ménangéy dob Jesuse brab bénréh ro dob Beeney kéuyotoy de étéw. ");
INSERT INTO tiy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Atin ménbéréh i Jesuse mano, “Enggumahén i gaiwe toow fo médayéw i Nga i Kéilawane, sani Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Béréhé ku begom i toowe, amuk i bénee énda mélébéngén dob fantade, énda mégonokén. Endob amuk ménlébéng, mégonok médoo. Ségiléw bé Begéne, non amuk méléhuu, médooy gégédote bé mantuwe umul. ");
INSERT INTO tiy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","I aruméne étéw sani toowe fo gémulaan bé férénawa nuwe, méléhu. Endob i étéwe énda gulaané noy férénawa nuwe dob ni duniya, gédoté noy mantuwe umul magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Atiy méuyote gémalbékon Begén fatut modor Begén, inok fiyon fo ké ati ayo kuwe, diyo soy sugu-sugué kuwe. Atin fébantug i Abay guwey étéwe gémalbékon Begén. ");
INSERT INTO tiy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Toow fo tete i fédéw guwe béleewe ni. Ati fatute béréhé ku? Enda mon gébérého ku de ké maku, ‘Abay, kago fédayaén mérigo séko dob Begéne.’ Non been i niy funa kuwe ménangéy dini inok géagéwo kuy ni kérasay.” ");
INSERT INTO tiy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tidéw béno, déménasal i Jesuse mano, “Abay, fégito moy barakat me.” Tidéw béno, wén i émbéréhe tidéw dob lawayo mano, “Fénggito gun i barakat guwe atin fégito gu man ségule.” ");
INSERT INTO tiy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Atin amun énggélingooy de ménsélimud do étéw diyo i ni, i de dumo de marok léte, atin i de dumo de marok télakiy no ménsébéréh bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Endob bénréh Jesuse mano, “I funay Tuluse ménbéréh békén inok gélingoo ku, yamula inok gélingoo kom so. ");
INSERT INTO tiy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Béleewey gaiwe féganayéy Tulusey kékukum ne bé de tete étéw. Atin fétékédanén i datu i ni duniya, sani Satanase. ");
INSERT INTO tiy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Atin i Begéne, amuk métunggulu, féfégédété kuy kéluhanay étéwe dob Begéne.” ");
INSERT INTO tiy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Bénréh Jesusey ni inok fégétiga no beroy fégéléhu ne, tunggulén dob kruse.) ");
INSERT INTO tiy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Atin ménbéréh i de étéw ménlimud maro, “Ménbéréh dob Ménsulate Kébéréh i Tuluse i Kristowe kun méuyag taman sa taman. Mélaw sedek bénréhém i Nga i Kéilawane fatut tunggulén? Ati ni Nga Kéilawan?” ");
INSERT INTO tiy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mélaw bénréh Jesuse bero mano, “I Begéne maak solo. Atin éndaén mérugay i kébati guwe dob begome. Fétuntay gom béleewe non diniwu séna inok gétiga kom i fiyowe agéwon. Endob amuk délémonén, éndaén gito gom i agéwone. ");
INSERT INTO tiy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mélaw amun diniwu séna, unur gom Begén inok waléy gom so do solo miring Begén.” Amun énggilid i Jesuse ménbéréh, méntékédan brab éndaén méntéfégito no bé de étéw. ");
INSERT INTO tiy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Fiyon fo ké énggito roy de médoo rénigo Jesuse do mékégaif, énda so munur ro de. ");
INSERT INTO tiy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dob ni méntuman i Ménsulate Kébéréh i Tuluse, sénulat Isaiase sani méntélatae sénarigoy Tuluse muret mano, “Kadnan, énda i munur bé uret geye, atin énda i énggétigan bé fénggitono muwe bé barakat me.” ");
INSERT INTO tiy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Atin sénulat Isaiase so mano, “I Tuluse, fénwaléyén bero langafén brab féntégasén i de fédéw ro, inok énda gégito ro brab inok énda gésobut ro brab énda gésénule ro brab munur dob Tuluse inok tabanga no bero.” Atin been i funa ruwe énda géunur ro. ");
INSERT INTO tiy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Bénréh Isaiasey ni non bé gétahe de énggito noy kébarakata Jesuse brab bénréhén i fantage bé Beene. ");
INSERT INTO tiy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Fiyon fo ké loo bé ni, médooy de odoroy de Judio ménunur bé Jesuse. Endob énda fénayag ro de non mégilak ro bé de Fariseo fétékédané ro dob lawie féngadafan inok éndaén géféngadaf ro diyo. ");
INSERT INTO tiy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Enda fénayag roy kéunur ruwe bé Jesuse non toow na fo méuyot ro bé kédayéw i kéilawane bé kédayéw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tidéw béno, méntanug i kébéréh Jesuse mano, “I étéwe munur dob Begéne, énda saén munurén dob Begéne, éndob munur so bé Tuluse séménugu Begén. ");
INSERT INTO tiy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Atin i étéwe énggégito Begén, énggito no soy séménugue Begén. ");
INSERT INTO tiy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Begéney maake solo. Ménangéyu dini dob duniyae inok réméndawu dob de étéw. Mélaw i de munur dob Begéne, éndaén bati ro dob délémone. ");
INSERT INTO tiy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Atin i étéwe énggégélingo bé kétoro guwe éndob énda munurén de, békén Begén i kémukume de, non énda ménangéyu dini inok kukumé kuy de kéilawan, yamula fukasé ku bero dob de sala ro. ");
INSERT INTO tiy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","I étéwe mika Begén brab énda munurén bé kagéne kétoro, mékukum dob tamfaday de gai. Atin i kémukume de, been i kétoro guwe. ");
INSERT INTO tiy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Non i kagéne kétoro békén tidéw dob Begéne, éndob tidéw dob Abay guwe Tulus séménugu Begén. Been i ménfébéréhe Begén. ");
INSERT INTO tiy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Atin gétiga ku, i sugu ne miray bé umule magufusa. Mélaw béréhé ku begom i sénugu i Abay guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bé béno, ségékélungonon séden atin kémanduli i de Judio féndawét “Témara”. Atin énggétiga Jesuse, gédétén i gaiwe tagaké noy duniyae ni atin séfule mangéy dob Abay ne. Toow fo ménimu bé de kuyugén dob duniyae ni, atin fénténgténgén i kédakél i kégédaw ne bero. ");
INSERT INTO tiy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ménama i Jesuse beroy de kuyugén. Atin i Satanase, bé gétahe de fénémanduo noy Judas Iskariote sani nga Simon Iskariote inok fékéfoén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Atin i Jesuse énggétiga noy Abay ne sénarigén dob Beeney kéluhanane. Atin énggétiga noy Beene tidéw dob Tuluse atin séfule mangéy dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mélaw amun ménsar ro séna dob sékuloy ahayane, téménindég i Jesuse brab kénda noy kégal ne brab nikétén i tuwaliyawe dob owok ne. ");
INSERT INTO tiy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tidéw béno, rénigono no wayég i félangganahe atin nurahén i de sékéy i de kuyugén, brab ténrafo no bé tuwaliyawe nikétén dob owok ne. ");
INSERT INTO tiy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Amun fégédét i Jesuse dob Simon Pedrowe, ménbéréh i Pedrowe mano, “Kadnan, aw Beem i murahe bé de sékéy gu?” ");
INSERT INTO tiy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Séménumbul i Jesuse mano, “Enda gésobuto kom i atag i ni rigoné ku béleewe ni, éndob gésobuto kom so moso.” ");
INSERT INTO tiy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Kago”, bang Pedro. “Enda fo méuyotu de ké Beem i murahe bé de sékéy gu.” Endob séménumbul i Jesuse mano, “Amuk énda géuraha ku begom, békén gom do toow kuyug gu.” ");
INSERT INTO tiy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mélaw bang Pedrowe, “Kadnan, békén say de sékéy gu, éndob urahém soy de kémér gu brab uléw guwe de so.” ");
INSERT INTO tiy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Endob ménbéréh i Jesuse mano, “I étéwe énggilidén méndiyoh, kailangan urahé no say de sékéyén, non limfiyonén i lowoh ne. Atin limfiyo gomén saliyu bé ségétéwe énda limfiyo no.” ");
INSERT INTO tiy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bénréh Jesusey ni non gétiga no wén i ségétéwe bero émfékéfo de. Been i niy funa nuwe ménbéréh mano, “Enda kéluhana kom limfiyo.” ");
INSERT INTO tiy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Atin amun énggilidén nurah Jesusey de sékéy i de kuyugén, kéménégal brab ménsar man dob amaane. Tidéw béno, ménénginsa mano, “Aw énggésobuto kom i rénigo guwe dob begome? ");
INSERT INTO tiy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Fédawété kom Begén ‘Maistéro’ brab ‘Kadnan’, atin toow fo fatut i nan non Begéney Kadnane. ");
INSERT INTO tiy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mélaw i Begéne, sani Kadna kome brab Maistéro gom, amun nurah guy de sékéy gom, fatut gom so séurah sékéy. ");
INSERT INTO tiy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ténoro gu begom i fatute adat. Rénigo guy ni inok iringé kom so. ");
INSERT INTO tiy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Béréhé ku begom i toowe, énda nay rifén ké toow na fo gérotor bé gefee de, brab énda nay sugu-suguén ké toow na fo gérotor bé amu ne. ");
INSERT INTO tiy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Amuk énggésobuto kom i de ni, toow gom na fo moror ké rigoné kom. ");
INSERT INTO tiy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Enda béréhé kuy ni dob begome kéluhanan, non gétiga kuy de fédéw gom do fénémili gu. Mélaw gétiga ku wén i ségétéw begom émfékéfo Begén. Mérigoy ni inok métuman i Ménsulate Kébéréh i Tuluse mano, ‘I étéwe dumo gu mama waléy sébanil Begén.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Féntaus Jesusey kébéréh ne mano, “Béréhé ku begom béleewe ni, bé énda séna ménrigo no inok amuk gégumah i gaiwe métuman i ni, géunur gom Begéney Kristowe tidéw dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Béréhé ku begom i toowe, i étéwe témayakuf bé sugué kuwe, témayakuf so Begén. Atin i témayakufe Begén, ténayakufén soy Tuluse séménugu Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Amun énggilid Jesuse bénréh i ni, toow fo ménlidu i na nuwe atin ménbéréh man mano, “Béréhé ku begom i toowe, wén sékoy ségétéwe begom émfékéfo Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tidéw béno, i de kuyugén ménggéséténgténg ro, non énda gétiga roy ati isuwe bé berowey bénréh Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Atin ménsar dob sékulo Jesusey kuyug ne toow fo kégédawa no. ");
INSERT INTO tiy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Atin kénébit Simon Pedrowey ni kuyug brab ménbéréh mano, “Fénginsaém ké ati isuwe de.” ");
INSERT INTO tiy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mélaw ménfégédét i ni kuyug dob Jesuse brab ménénginsa mano, “Kadnan, ati isuwe begey i émfékéfoe Beem?” ");
INSERT INTO tiy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Séménumbul i Jesuse mano, “I étéwe iraya ku bé fane nérém gu, been i nan.” Tidéw béno, amun énggérémo noy fane, nirayén dob Judase nga Simon Iskariote. ");
INSERT INTO tiy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Amun énggédot Judasey fane, ménahur i Satanase dob Beene. Atin ménbéréh i Jesuse mano, “Fagayas gon, rigo mo nén i rigoné muwe.” ");
INSERT INTO tiy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Endob énda i ségétéw bé de kuyugén ménsar dob amaane, énggésobut bé funa Jesuse ménbéréh bé nan. ");
INSERT INTO tiy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Non i Judase beeney témimue bé de kurta ro, brab marok sénugu Jesuse mangéy méléy bé de kailanga ro bé no kékanduli. Atin i de dumo bero marok sénuguén mangéy miray kurta dob de méskinan. ");
INSERT INTO tiy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Amun énggédot Judasey fane ni, ménsut atin ménagéw. Bé béno, kélungonon. ");
INSERT INTO tiy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Amun ménagéw i Judase, ménbéréh i Jesuse mano, “Béleewe gitonén i barakat guwe sani Nga i Kéilawane. Atin bé Begéne, giton soy barakat i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Brab amuk bé Begéne, énggitonén i barakat i Tuluse, tidéw béno fégitoy Tulusey barakat guwe. Atin rigoné noy ni magad. ");
INSERT INTO tiy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Do nga gu, éndaén mérugay i kébati guwe dob begome, brab sélédé kom séko Begén. Endob béréhé ku begom béleewe niy bénréh guwe dob de odoroy de Judio, ‘Enda géodor gom mangéy dob ayo kuwe.’ ");
INSERT INTO tiy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Atin ay niy mantuwe sugu iray gu begom: Ségédaw gom. Ségiléw bé kégédaw guwe begom, ségédaw gom. ");
INSERT INTO tiy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Amuk ségédaw gom, gétigay kéluhanay de étéw mélaw begom i de kuyug gu.” ");
INSERT INTO tiy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tidéw béno, ménénginsa i Simon Pedrowe mano, “Kadnan, ayo muwe de?” Séménumbul i Jesuse mano, “Béleewe ni, énda géodor gom Begén mangéy dob ayo kuwe. Endob gétundug gom so moso may diyo.” ");
INSERT INTO tiy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Atin bang Pedrowe, “Kadnan, sedek énda géodoru Beem béleewe ni? Ulan den ké méléhuu sabaf bé Beeme.” ");
INSERT INTO tiy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Endob ménbéréh man i Jesuse mano, “Aw toow ulan den ké méléhu go sabaf bé Begéne? Béréhé ku beem i toowe, énda séna ukoro i férufete, dirungé mo Begén téléw gule bé énda gélolo mo Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Bang Jesuse, “Kagom émbuku taloo no tete i de fédéw gom. Unur gom bé Tuluse, brab unur gom so Begén. ");
INSERT INTO tiy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wén i médoo do gonon dob lawi i Abay guwe. Atin magéwu angéyé ku tafayén i de gono kom. Enda béréhé ku begom i ni amuk békén toow. ");
INSERT INTO tiy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tidéw béno, amuk énggilidén méntafay i de gono kom, séfuleu mangéy dini brab uwité ku begom mangéy dob batio kuwe inok sétifon tom. ");
INSERT INTO tiy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Atin gétiga kom i agéwone mangéy dob ayo kuwe.” ");
INSERT INTO tiy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Endob ménbéréh i Tomase mano, “Kadnan, énda gétiga key i ayo muwe de. Ati mélaw i kégétiga keye bé agéwone mangéy diyo?” ");
INSERT INTO tiy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Séménumbul i Jesuse mano, “Begéney agéwone, Begéney toowe, brab Begéney umule. Enda i géangéy dob Abaye saliyu bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Amuk toow fo gétiga kom Begén, gétiga kom soy Abay guwe Tulus. Atin tidéw béleewe ni, énggétiga komén brab énggito gomén.” ");
INSERT INTO tiy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Atin bang Filipihe. “Kadnan, fégito mo begey i Abaye Tulus. Been saén i nan i kailanga keye.” ");
INSERT INTO tiy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Séménumbul i Jesuse mano, “Ménrugayén i kébati guwe dob begome. Endob taman so béleewe énda so wayo gélolo mo Begén Filipi? I énggégitowe Begén, énggito no soy Abaye. Sede mélaw ké émbéréh go, ‘Fégito mo begey i Abaye’? ");
INSERT INTO tiy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aw énda fo munur go Begén diyou dob Abaye, atin i Abaye dini dob Begéne? I de béréhé ku begom békén tidéw dob Begéne. Tidéw dob Abaye dini dob Begéne gémalbék. ");
INSERT INTO tiy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Unur gom bé kébéréh guwe, i Begéne diyou dob Abaye, atin i Abaye dini dob Begéne. Taloo no unur gom sabaf bé de mékégaif énggito gom rénigo gu. ");
INSERT INTO tiy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Béréhé ku begom i toowe, i munure Begén gérigono noy de galbék rigoné ku. Atin gérigo na toow fo dakél mékégaif bé de kagén galbék, non mangéyu dob Abay guwe. ");
INSERT INTO tiy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Atin rigoné kuy kéluhanay ongoté kome dob dawét guwe, inok fégito guy kéfiyoy Abay guwe Tulus. ");
INSERT INTO tiy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Udenén éntingayén ongoté kom dob dawét guwe, rigoné ku.” ");
INSERT INTO tiy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Féntaus Jesusey kébéréh ne mano, “Amuk méimu gom Begén, odoro kom i de sugué ku. ");
INSERT INTO tiy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Atin ongoté ku dob Abaye, brab sémugu ségiyo témabang sani Rémogor i Tuluse témoro bé toowe. Atin bati dob begome taman sa taman. I de étéw dob duniyae sébanil bé Tuluse énda tayakufé ro de non énda gito ro de brab énda gétiga ro de. Endob i begome, gétiga kom non bati dob begome brab énda tékéda no dob begome. ");
INSERT INTO tiy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Atin i Begéne, énda tagaké ku begom félébu, non séfuleo ku begom. ");
INSERT INTO tiy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Endaén mérugayén, i de sébanil bé Tuluse éndaén gito ro Begén. Endob i begome, gito gom man Begén. Atin non méuyagu man taman sa taman, méuyag gom so taman sa taman. ");
INSERT INTO tiy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Amuk gégumah i nan gai tébuleu, gétiga kom i Begéne diyo dob Abay guwe, atin i begome dini dob Begéne, loo bé kédiyo guwe dob begome. ");
INSERT INTO tiy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“I témayakufe bé de sugu gu brab rigoné no, beeney méimue Begén. Atin i Abay guwe féimué noy étéwe méimu Begén. Atin i Begéne féimué ku so brab féfégétiga ku dob beeney fantage bé Begéne.” ");
INSERT INTO tiy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tidéw béno, ménbéréh i Judase (békén Judas Iskariot) mano, “Kadnan, sedek féfégétiga mo begey i fantage bé Beeme, éndob énda fayagé mo de dob de étéw sébanil bé Tuluse?” ");
INSERT INTO tiy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Séménumbul i Jesuse mano, “I méimue Begén, odoro noy kétoro guwe. Atin i Abay guwe méimu de so brab i Abay guwe brab Begéne mangéy gey bati dob beene. ");
INSERT INTO tiy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","I étéwe énda méimuén Begén, énda so odoro noy kétoro guwe. I de ni kébéréh gélingoo kom békén kagén, éndob tidéw dob Abaye séménugu Begén. ");
INSERT INTO tiy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Bénréh gu dob begomey de ni lokut diniwu séna dob begome. ");
INSERT INTO tiy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","I témabange sani Rémogor i Tuluse, féuwit i Abaye inok fétausé noy galbék guwe. Atin toroé no begom i kéluhanane brab féfégétédémén begom i kéluhanay bénréh guwe begom. ");
INSERT INTO tiy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Féledé kuy kagéne kétanék dob begome, inok fiyoy de fédéw gom. I kétanéke iray gu begom békén loo bé kétanéke dob duniyae ni. Mélaw kagom émbuku taloo no mégilak gom. ");
INSERT INTO tiy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Enggélingoo kom i bénréh guwe bé tagaké ku begom éndob séfuleo ku so begom. Amu damén ké toow gom méimu Begén, moror gom bé kéangéy guwe dob Abaye non i Abaye toow na fo gérotor Begén. ");
INSERT INTO tiy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Bénréh gu begom i ni lokut énda séna ménrigo no, inok amuk métuman, munur gom de. ");
INSERT INTO tiy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Enda férugayé kuy kébéréh guwe dob begome non gégumah sékoy odoroy duniyae ni sani féndawéte Satanas. Endob énda i barakatén gélawan Begén. ");
INSERT INTO tiy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Endob rigoné kuy kéluhanay sénugu i Abaye inok gétigay de étéw i kéimu guwe bé Abaye. Enggomén, magéw tomén tékédan tom dini.” ");
INSERT INTO tiy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ménbéréh man i Jesuse mano, “I Begéne maak sébaan idéng kayéw atin i Abay guwe Tulus Beeney gefee bé kayéwe. ");
INSERT INTO tiy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Amuk wén i do fongoy kayéwe énda mégonokén, kéléngé no. Atin limfiyoné noy de fongo mégonok inok méuman i kéfégonok ruwe. ");
INSERT INTO tiy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","I begome maak do fongo gu brab ménlimfiyo gomén, non ménunur gomén bé de kétoro gu. ");
INSERT INTO tiy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kagom tékédan dob Begéne atin énda tékédanu dob begome. Enda i fongo géfégonok amuk énda ménsumfatén dob idéng i kayéwe. Ségiléw bé begome non amuk sésuway gom Begén, énda gérigo gom bé fiyowe. ");
INSERT INTO tiy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Non i Begéne maak idéng kayéw atin i begome maak do fongo. I étéwe énda tékédan no dob Begéne, brab énda so tékédanu dob beene, géfégonok médoo do fiyo rigonén. Endob énda i fiyo gérigono kom ké tékédan gom dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Atin i endae ménsumfat dob Begéne ibérén loo bé fongowe. Tidéw béno, waléy mégangu. Atin i kéluhanay de fongo do mégangu, timuén inok ibérén dob aféye brab métuwég. ");
INSERT INTO tiy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Endob i begome, amuk énda tékédan gom dob Begéne atin amuk modor gom bé kétoro guwe, udenén kétaya kom ongoté kom, atin gédoté kom. ");
INSERT INTO tiy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Atin amuk énggéfégonok gom médoo do fiyo rigonén, dayéwéy de étéw i Abay guwe. Atin gétiga ro mélaw do kuyug gu begom. ");
INSERT INTO tiy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Féimué ku begom ségiléw bé kéimu i Abay guwe Begén. Fétaus gom i kétayakuf gome bé gédaw guwe begom. ");
INSERT INTO tiy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Amuk odoro kom i de sugu gu, gétaus gom bé kétayakuf gome bé gédaw guwe begom, ségiléw bé kéodoro ku bé de sugu i Abay guwe atin taus i kétayakuf guwe bé gédaw ne Begén. ");
INSERT INTO tiy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Bénréh gu begom i ni inok méoror gom ségiléw bé Begéne inok toow tom fo séoror. ");
INSERT INTO tiy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ay niy sugu guwe begom: ségédaw gom loo bé kégédaw guwe begom. ");
INSERT INTO tiy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Amuk toow fo mégédaw i ségétéwe étéw bé dumo nuwe, irayén i férénawa nuwe inok tabanga no. Been i niy toowe fo dakél kégédaw. ");
INSERT INTO tiy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Begom i do dumo gu, amuk rigoné kom i sugué kuwe begom. ");
INSERT INTO tiy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Endaén fédawété ku begom do sugu-suguén, non i ségétéwe sugu-suguén, énda gétiga noy rigonéy amu ne. Yamula fédawété ku begom do dumo gu, non bénréh gu begom i kéluhanay énggélingoo kuwe tidéw dob Abay guwe Tulus. ");
INSERT INTO tiy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Békén begom i ménémilie Begén, yamula fénémili gu begom. Ténabar gu begom inok géfégonok gom do fiyo galbék énda mékédano. Atin mélaw i Abaye Tulus, irayén begom i kéluhanay ongoté kome dob dawét guwe. ");
INSERT INTO tiy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ay ni mélaw i sugu guwe begom: ségédaw gom. ");
INSERT INTO tiy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“I de étéw sébanil bé Tuluse dob duniyae ni, amuk mérarék ro begom, fégétédém gom i ni, géétahu na kénraréko ro. ");
INSERT INTO tiy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Amuk mamung gom sébanil bé Tuluse, méimu i de tete étéw begom. Endob fénémili gu begom inok sésuway gom bé de tete étéw dob duniyae ni. Mélaw mérarék ro begom. ");
INSERT INTO tiy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Fégétédém gom i bénréh guwe begom, ‘Enda i sugu-suguén ké gérotor na bé amu ne.’ Mélaw amuk férasayé ro Begén, férasayé ro so begom. Endob amuk wén i do étéw odoro roy kagéne kétoro, odoro ro soy kagome de. ");
INSERT INTO tiy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Endob i funa ruwe begom émférasay non do kuyug gu begom. Non énda gétiga roy Tuluse, sani séménugue Begén. ");
INSERT INTO tiy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Amuk énda ménangéyu dini mureton bero, énda i sala ro. Endob béleewe ni énda géséliyah ro non énggélingoo roy toowe, éndob mika ro de. ");
INSERT INTO tiy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Atin i de étéw mérarék Begén, békén mérarék ro saén Begén non mérarék ro so bé Abay guwe. ");
INSERT INTO tiy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Enggito roy mékégaife galbék rénigo gu, énda gérigonoy ségiyowe de. Amuk énda énggito ro de, énda i sala ro. Endob énggito roy de ni, gido loo mérarék ro Begén brab Abay guwe Tulus. ");
INSERT INTO tiy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Endob fatut mérigoy ni inok métuman i Ménsulate Kébéréh i Tuluse mano, ‘Fiyon fo ké énda i funa ro, mérarék ro so Begén.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Féntaus Jesusey kébéréh ne mano, “Gégumah sékoy témabange tidéw dob Abaye Tulus. Sugué ku mangéy dob begome. I dawét ne Rémogor i Tuluse, atin toroé noy toowe. Amuk gumahén dini, fégétiga no bé de étéw i fantage bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Atin begome soy fatute muret fantag bé Begéne, non énggéséodor gom Begén tidéw féganay bé kétoro guwe.” ");
INSERT INTO tiy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Féntaus Jesusey kébéréh ne mano, “Bénréh gu begom i kéluhanay de ni inok énda mékédan i késarig gome dob Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Non éndaén moso tungkasé ro begom mahur dob de lawi féngadafan. Atin gégumah moso i gaiwe, i de étéw méméléhu begom, marok rigoné roy kétayay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rigoné roy de ni non énda séna gélolo ro Begén taloo no Abay guwe. ");
INSERT INTO tiy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Endob bénréh gu begom i de ni, inok amuk gégumah moso i nan gai kéférasay ro begom, gétédémo kom i bénréh gun begom. “Enda bénréh gu de begom bé de gétah, non diniwu séna séodor begom. ");
INSERT INTO tiy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Endob béleewe ni, muleu mangéy dob Tuluse séménugu Begén. Gido loo, énda i ségétéw begom ménginsa ké hon i ayo kuwe de. ");
INSERT INTO tiy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Atin béleewe, toow fo tete i de fédéw gom non bénréh guy de ni. ");
INSERT INTO tiy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Gido loo, béréhé ku begom i toowe, toow na fo fiyo dob begome ké magéwu, non buluk énda magéwu énda mangéy i témabange dob begome. Endob amuk magéwu, sugué ku mangéy dob begome. ");
INSERT INTO tiy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Atin buluk gégumah, féfégétiga no bé de étéw i de sala ro. Féfégétiga no soy fantage bé fiyowe brab fantag bé kékukum i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Fégétiga no bero ménsala ro sabaf énda méginugut ro Begén. ");
INSERT INTO tiy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Féfégétiga no beroy fantage bé fiyowe non muleu mangéy dob Abaye Tulus, atin éndaén gito gom Begén. ");
INSERT INTO tiy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Atin féfégétiga no soy fantage bé kékukum i Tuluse, non i Satanase, sani odoroy kéluhanay tetee dob duniyae ni, ménkukumén. ");
INSERT INTO tiy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Médoo nay kéuyoto kuwe ureté ku begom, éndob énda séna gésobuto kom de béleewe ni, brab waléy gom émbuku ké béréhé ku. ");
INSERT INTO tiy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Endob i Rémogor i Tuluse, sani témoroe bé toowe, amuk gégumah, féfégétiga no begom i kéluhanay toowe. Enda béréhé noy de kaan saén kéfégitung, yamula toroé noy kéluhanay énggélingoo nuwe tidéw dob Abaye, atin béréhé no begom i fantage bé kéluhanay mérigowe moso. ");
INSERT INTO tiy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dayéwé no Begén, non féfégésobutén begom i kéluhanay de kagén kétoro brab de rénigo gu. ");
INSERT INTO tiy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","I kéluhanay kay Abaye, kagén so. Been i niy funa kuwe ménbéréh bé i Rémogor i Tuluse, féfégésobutén begom i kéluhanay kétoro guwe. ");
INSERT INTO tiy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Endaén mérugayén tidéw béleewe ni, éndaén gito gom Begén. Enda man mérugayén tidéw béno, gito gom man Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Atin i de dumo bé de kuyugén ménsébéréh-béréh ro maro, “Ati atag i bénréh ne mano, ‘Endaén mérugayén tidéw béleewe, éndaén gito gom Begén, brab énda man mérugayén tidéw béno, gito gom man Begén?’ Brab bénréhén so mano, ‘Non muleun mangéy dob Abaye.’ ");
INSERT INTO tiy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Atin ati keey i atag i ni, ‘Endaén mérugayén’? Enda gésobuto tom i no bénréhén.” ");
INSERT INTO tiy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Atin énggétiga Jesuse méuyot ro ménginsa, mélaw bénréhén bero mano, “Aw séfénginsa gom bé ati atag i bénréh guwe begom maku, ‘Endaén mérugayén éndaén gito gom Begén, brab énda man mérugayén tidéw béno gito gom man Begén?’ ");
INSERT INTO tiy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Béréhé ku begom i toowe, i de tete étéw dob duniyae ni, toow ro fo moror bé mérigowe dob Begéne, éndob i begome, kémérew gom non toow fo tete i de fédéw gom. Endob énda man mérugayén waléy gom toow na fo moror. ");
INSERT INTO tiy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ufama, i libune kéararan, démawét non énggumahén i gaiy kékérasaya nuwe. Endob buluk ménkéumahanén, ménlifotén bé kékédawéta nuwe, sabaf bé kéoror ne bé ngae ménumah dob duniyae ni. ");
INSERT INTO tiy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ségiléw bé nan soy begome. Béleewe ni, tete i de fédéw gom. Endob amuk gégumahén sékoy gaiwe géségito tom man, waléy gom toow fo moror. Atin énda i gékédan bé kéoror gome. ");
INSERT INTO tiy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Amuk gégumahén sékoy nan gai, éndaén ongoto kom Begén. Béréhé ku begom i toowe, i Abaye Tulus, irayén begom i kéluhanay ongoté kome dob dawét guwe. ");
INSERT INTO tiy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Taman so béni, énda séna ménongot gom dob dawét guwe. Ongot gom atin gédoté kom, inok toow gom fo moror. ");
INSERT INTO tiy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Bénréh gu begom i de ni fénagéw dob binuwayae. Endob gégumah sékoy gaiwe éndaén binuwayaa ku begom, yamula fékéntayé kuy kéuret guwe fantag bé Abaye. ");
INSERT INTO tiy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Buluk gégumah i nan gai, begom i de mongot dob dawét guwe dob Beene inok iraya no begom. Békén Begén i mongote. ");
INSERT INTO tiy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Non i Abaye toow fo mégédaw begom. Féimué no begom non ménimu gom Begén brab ménunur gom Begén tidéwu dob Beene. ");
INSERT INTO tiy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tidéwu dob Abaye Tulus, brab ménangéyu dob duniyae. Brab béleewe tékédanu dob duniyae ni, atin muleu mangéy dob Abaye.” ");
INSERT INTO tiy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tidéw béno, ménbéréh i de kuyugén maro, “Béleewe mékéntay i kébéréh me, éndaén émbéréh go binuwaya. ");
INSERT INTO tiy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Béleewe ni gétiga key gétiga moy kéluhanane, non fiyon fo ké énda séna ménginsa gey, gétiga mon i de fénginsaé key. Mélaw munur gey Beem, tidéw go dob Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Atin bang Jesuse, “Aw méginugut gomén Begén? ");
INSERT INTO tiy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Endob gégumah i gaiwe brab énggumahén, ké émbéragar gom, mule gom mangéy dob de lawi gom. Atin tagaké kom Begén ségétéw gu saén. Endob fiyon fo ké loo bé nan, wén i dumo gu, non i Abay guwe Tulus i dumo guwe. ");
INSERT INTO tiy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Béréhé kuy de ni begom, inok fiyoy de fédéw gom sabaf bé késarig gome dob Begéne. Férégénoy de tete étéw begom, éndob fébaraw gom non ténabananén Begén i Satanase, sani odoroy duniyae ni.” ");
INSERT INTO tiy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Amun énggilid Jesuse bénréh i de ni, léménéngag saréw dob lawayo brab ménbéréh mano, “Abay, énggumahén i gaiwe. Fégito moy kéfiyo guwe funa ku fatut médayéw inok fégito gu soy kéfiyo muwe funa mo fatut médayéw. ");
INSERT INTO tiy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Non sénarigém Begén i kuwagibé méguléw bé kéluhanay de kéilawan, inok iray guy umule magufusa dob kéluhanay de étéw nirayém Begén. ");
INSERT INTO tiy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Atin ay niy kégédote bé umule magufusa: kailangan gétiga roy Beeme brab Begéne, non Beem saén i tintuwe Tulus brab Begén i sénugu me Jesu Kristo. ");
INSERT INTO tiy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Fénggito guy kéfiyo muwe dob duniyae, funa mo fatut médayéw atin énggilid gun i galbéke sénuguém Begén rigoné ku. ");
INSERT INTO tiy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Abay, béleewe ni ay niwu dob adafa muwe, féséfuleém dob Begéney bantuge loo bé bantug tuwe tidéw féganay bé énda séna ménlimbag i duniyae de. ");
INSERT INTO tiy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Féfégétiga kuy fantage bé Beeme dob de étéw dob ni duniya nirayém Begén. Beem i gefee bero, atin nirayém bero dob Begéne, atin ménunur ro bé kébéréh me. ");
INSERT INTO tiy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Béleewe énggétiga ro tidéw dob Beemey kéluhanane béréhé ku brab rigoné ku. ");
INSERT INTO tiy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Non fénsamfay gu dob berowey de kébéréhém nirayém Begén, atin méngginugut ro de. Enggétiga ro toowu tidéw dob Beeme, brab ménunur ro sénuguém Begén. ");
INSERT INTO tiy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Dasala ku bero dob Beeme. Enda dasala kuy de tete étéw dob duniyae ni, éndob ongoté ku dob Beeme féfiyoné moy de étéw nirayém Begén non kaam so do étéw. ");
INSERT INTO tiy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","I kéluhanay kagéne kaam so, brab i kéluhanay kaame kagén so. Atin dob berowe énggiton i kéfiyo guwe funa ku fatut médayéw. ");
INSERT INTO tiy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Atin muleu séko mangéy dob Beeme, brab éndaén batiu dob duniyae ni. Endob taus i karowe kébati dob duniyae ni. Fiyo Abay, diyaga mo bero bé barakat i dawét me, sani dawét me nirayém Begén, inok waléy ro sébaan, ségiléw bé betowe sébaan. ");
INSERT INTO tiy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Amun diniwu dob berowe, déniyaga gu bero bé barakat i dawét me nirayém Begén. Déniyaga gu bero inok énda i ségétéw métadin bero saliyu bé ségétéwe kailangan mékukum inok métuman i Ménsulate Kébéréhém. ");
INSERT INTO tiy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Atin béleewe séfuleu mangéy dob Beeme. Béréhé kuy de ni lokut diniwu séna inok i de gégélingo de toow ro fo moror séréngan bé Begéne. ");
INSERT INTO tiy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Fénsamfay gu dob berowey de kaam kétoro. Atin i de tete étéw dob duniyae, mérarék ro bero non éndaén mamung ro dob de tete étéw ségiléw bé Begéne énda mamungu de. ");
INSERT INTO tiy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Enda ongoté ku de dob Beeme ké kédané mo bero dob duniyae, éndob ongoté ku dob Beeme diyagané mo bero tidéw dob Satanase. ");
INSERT INTO tiy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Enda mamung ro sébanil Beem ségiléw bé Begéne énda mamungu de. ");
INSERT INTO tiy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","I de ni kato étéw, usarém i toowe féwaléyém bero do malinis dob adafa muwe. Atin i kaame kébéréh, been i toowe. ");
INSERT INTO tiy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sénugu gu bero muret dob de étéw ségiléw bé késugu me Begén mangéy dob duniyae. ");
INSERT INTO tiy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Atin sabaf bé berowe, iray gu Beem i fédéw guwe, inok i berowe so iray roy de fédéw ro dob Beeme. ");
INSERT INTO tiy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Békén saén i berowey dasala kuwe dob Beeme, éndob dasala ku soy de étéw munur ro dob Begéne non bé kéuret i de ni kuyug gu. ");
INSERT INTO tiy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Démasalu dob Beeme Abay inok waléy ro sébaan ségiléw bé Betowe. Atin ségiléw bé kédini muwe dob Begéne brab kédiyo guwe dob Beeme, dini ro so damén dob Betowe. Waléy ro damén sébaan inok i de étéw dob duniyae munur ro bé sénuguém Begén. ");
INSERT INTO tiy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Niray gu beroy barakate nirayém Begén inok i de fédéw ro waléy sébaan loo bé Betowe. ");
INSERT INTO tiy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Non i Begéne diyou dob berowe, atin i Beeme dini go dob Begéne. Mélaw waléy ro damén tintu sébaan inok i de étéw dob duniyae gétiga ro Beem i séménugu Begén brab féimuém bero loo bé kéféimu me Begén. ");
INSERT INTO tiy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Abay, i de étéw nirayém Begén, méuyotu de ké i ayo kuwe begey so inok gito roy bantug guwe, sani bantuge nirayém Begén non fénimuém Begén fiyon fo ké énda séna ménlimbag i duniyae de. ");
INSERT INTO tiy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Métintu Abay gu, i de étéw sébanil Beem, énda gétiga ro Beem. Endob i Begéne énggétiga ku Beem. Atin i de ni kuyug, gétiga ro sénuguém Begén. ");
INSERT INTO tiy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Fénggétiga ku beroy fantage bé Beeme, brab fétausé ku so inok i kégédaw me bero waléy ségiléw bé kégédaw me Begén, atin gédiyou dob berowe.” Been i niy dasal Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Amun énggilid i Jesuse démasal, ménagéw beroy de kuyugén ménifar ro bé wayége féndawét Kidron. Wén i do nohok kayéw diyo atin diyo ro téménrén. ");
INSERT INTO tiy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Atin i Judase sani émfékéfoe de énggétiga noy ni gonon non diyo démoyun sélimud i Jesuse bé de kuyugén. ");
INSERT INTO tiy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mélaw i Judase ménangéy diyo, fénanangguwitén i médoowe sundalo brab de mantay bé lawi i Tuluse sénugu i de odoroy de fadi brab do Fariseo. Ménuwit ro do solo brab do téla-ta brab do kulangén. ");
INSERT INTO tiy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","I Jesuse énggétiga non i kéluhanane mérigo séko dob Beene. Mélaw fénggédéto no bero brab ménbéréh mano, “Ati sélédé kome?” ");
INSERT INTO tiy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Séménumbul ro maro, “Sélédé key i Jesuse tidéw Nasaret.” Atin bang Jesuse, “Begén i no.” Diyo soy Judase brab been i émfékéfoe bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Amun bénréh Jesuse Been i no séléde ro, énggétésunud i de sundalo brab kéluhana ro méntuwar. ");
INSERT INTO tiy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tidéw béno, ménénginsa man i Jesuse mano, “Ati sélédé kome?” Atin séménumbul ro maro, “Jesus tidéw Nasaret.” ");
INSERT INTO tiy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Atin bang Jesuse, “Bénréh gun begom, Begén i Jesuse. Mélaw amuk Begén i sélédé kome féagéw gom i de dumo gu ni.” ");
INSERT INTO tiy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Bénréhén i ni inok métuman i kébéréh ne mano, “Abay, énda i énggétadino ku fiyon ségétéw bé de étéw nirayém Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tidéw béno, i Simon Pedrowe rénau noy sundange tidéw dob ruma ne. Atin ténibohén i ségétéwe rifén kay gérotore fadi brab sénilafén i kélingo ne fingé kuwonon. I dawét i ni rifén Malkus. ");
INSERT INTO tiy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tidéw béno, bénréh Jesuse dob Pedrowe mano, “Rumaém i sundang ma nan. Non i kékérasaya kuwe niray i Tuluse Begén, békén ba kailangan téférasayun mon?” ");
INSERT INTO tiy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tidéw béno, i de sundalo beroy odoro ruwe, brab de mantay bé lawi i Tuluse, kénéfo roy Jesuse brab nikét ro. ");
INSERT INTO tiy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Atin nuwit ro sungu dob Anase, térimay gérotore fadi bé no bélintuwa féndawét Kayafas. ");
INSERT INTO tiy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Atin i Kayafase féngginau noy de odoroy de Judio bé gétahe de mano, “Toow na fo fiyo ké ségétéw saén i méléhue inok énda méléhu i kéluhanay de Judio.” ");
INSERT INTO tiy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Atin i Pedrowe brab ségétéwe dumo no kuyug ménfuray ro bé Jesuse. I ni ségétéw kuyug, énggéloloy gérotore fadi, mélaw énggéodor so bé Jesuse mahur mangéy dob fésayaway lawi i gérotore fadi. ");
INSERT INTO tiy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Endob i Pedrowe méntéféled dob liyuy béngaway fésayawane. Tidéw béno, i dumo nuwe kuyug sani énggéloloy gérotore fadi ménsut brab ménsébéréh bé kénogone mantay dob béngawane, brab fénahurén i Pedrowe dob fésayawane. ");
INSERT INTO tiy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","I kénogone ni ménénginsa dob Pedrowe mano, “Aw békén ba beem i ségétéwe bé de kuyug i lagéye kénéfo?” Séménumbul i Pedrowe mano, “Békén begén.” ");
INSERT INTO tiy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mélégénéy fo bé béno gai. Mélaw i de sugu-suguén brab de guwardiya ménuyag ro aféy atin téménindég diyo méntélagang ro. Atin diyo soy Pedrowe téménindég télagang. ");
INSERT INTO tiy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Atin i gérotore fadi fénénginsaa noy Jesuse fantag bé de kuyugén brab bé de kétoroén. ");
INSERT INTO tiy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Séménumbul i Jesuse mano, “Enda ménbunéy i de kétoro gu. Yamula toroé kuy kéluhanay de étéw non démoyunu témoro dob de lawi féngadafan brab dob lawi i Tuluse dob téngaangay de étéw, non diyo ménlimud i de Judio. Enda foy bénréh gu ké sénkém saén. ");
INSERT INTO tiy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mélaw sedek fénginsaa mo Begén? Fénginsaa moy de étéw énggégélingo Begén non gétiga roy de kétoro gu.” ");
INSERT INTO tiy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Amun bénréh Jesusey ni, i ségétéwe bé de guwardiya ténamfilingén i Jesuse brab ménbéréh mano, “Aw been i nan i késumbulo muwe bé gérotore fadi?” ");
INSERT INTO tiy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Séménumbul i Jesuse mano, “Amuk tete i bénréh guwe, béréhém ati tetee de. Endob amuk toow i bénréh guwe, sedek tamfilingé mo Begén?” ");
INSERT INTO tiy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tidéw béno, i Jesuse tafay so nikét fénuwit Anase mangéy dob toowe gérotor fadi féndawét Kayafas. ");
INSERT INTO tiy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Amun i Pedrowe diyo séna dob aféye télagang, fénénginsaay de étéw diyo maro, “Aw békén ba beem soy ségétéwe bé de kuyugén?” Endob dénirung Pedrowe mano, “Békén begén.” ");
INSERT INTO tiy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Diyo i ségétéwe rifén kay toowe gérotor fadi sani samung i étéwe sénilaf Pedrowey kélingo ne. Ménénginsa mano, “Aw békén ba beem i énggito guwe dumo no bé kékéfo ruwe de dob safade?” ");
INSERT INTO tiy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Atin dénirung Pedrowe man mano, “Békén begén.” Sonom so béno, ménukoro i férufete. ");
INSERT INTO tiy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tidéw béno, nuwit roy Jesuse tidéw dob lawi Kayafase mangéy dob lawi i méguléwe bero tidéw Roma. Toow fo géfuwén bé no uras. Atin i de odoroy de Judio énda ménahur ro dob lawi i méguléwe inok odoro roy adat ruwe fantag bé kékanduli ruwe. Non amuk mahur ro dob lawi i de étéw békén Judio, énda géamung ro bé kandulie féndawét ro “Témara” non marok mékérésik dob adafay Tulusey de lawi i de étéw békén Judio. ");
INSERT INTO tiy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mélaw i méguléwe féndawét Pilato ménsut tidéw dob lawi ne mangéy dob berowe brab ménénginsa mano, “Ati funa kome témébo bé ni étéw?” ");
INSERT INTO tiy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Séménumbul ro maro, “Amuk énda i rénigo no tete, énda uwité key de mangéy dob beeme.” ");
INSERT INTO tiy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Atin bang Pilatowe, “Uwit gom mangéy dob kagome kukuman, brab begom i kémukum de ké ati ménbéréhe dob kitab gome.” Endob séménumbul i de Judio maro, “Endob dob kitab gome do Romano, énda i kuwagib gey kémukum méléhu bé ségétéwe étéw.” ");
INSERT INTO tiy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ménrigoy ni inok métuman i kébéréh Jesuse fantag bé kaane fégéléhu, sani dob kruse. Non i adat i de Romano, féléhué roy de étéw dob de krus. ");
INSERT INTO tiy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Atin i Pilatowe ménahur dob lawi ne brab ténawagén i Jesuse, atin ménénginsa mano, “Aw Beem i datu i de Judio?” ");
INSERT INTO tiy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Séménumbul i Jesuse mano, “Aw kaam sa kéfegitung i nan loo ké énggélingoo mo tidéw dob de ségiyo bénréh roy nan fantag bé Begéne?” ");
INSERT INTO tiy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Atin bang Pilatowe, “Békénu ségétéw Judio! Endob do falan do dumo mo Judio brab de odoroy de fadi gom i ménuwite Beem dini. Ati tetee rénigo mo?” ");
INSERT INTO tiy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Séménumbul i Jesuse mano, “I sakuf i féguléwo kuwe békén dob duniyae ni. Amuk duniyae niy sakuf i féguléwo kuwe, i de kuyug gu métah ro sétiboh inok énda gékéfooy de Judio Begén. I sakuf i kagéne féguléwon békén dini.” ");
INSERT INTO tiy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mélaw i Pilatowe ménénginsa mano, “Amuk loo bé nan, aw ségétéw go datu?” Séménumbul i Jesuse mano, “Toow i kébéréh me, Begén i datue. Atin i funa kuwe ménumah brab ménangéy dob duniyae ni inok féfégésobut guy toowe. Atin i de étéw modor bé toowe, fégélingoé ro Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Atin bang Pilatowe, “Ati keeyén i toowe?” Amun énggébérého Pilatowey ni, ménsut man ménangéy dob de Judio brab bénréhén mano, “Enda i gétiga ku sala i ni étéw. ");
INSERT INTO tiy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Endob i adat gome, sénga kanduli gom féndawét ‘Témara,’ témangéyu ségétéw férisu, sani ati fémilié kome. Aw méuyot gom de ké tangéyé kuy ni étéw datu gom do Judio?” ");
INSERT INTO tiy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Séménumbul ro mékes maro, “Békén Been i tangéyéne. Méuyot gey de ké tangéyé moy Barabase saén.” (I Barabase ni, beeney ségétéwe ménakaw.) ");
INSERT INTO tiy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tidéw béno, i Pilatowe fénbadasén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Atin i de sundalo méndot ro do suwaran kélég brab lénuku ro, atin fénsayaf ro bé Jesuse. Tidéw béno, fénkégal roy Jesuse furo kégal toow fo métaah, maak datu. ");
INSERT INTO tiy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Atin déniyangka ro maro, “Méraru damén i datu i de Judio.” Atin ténamfiling ro médoo gule. ");
INSERT INTO tiy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tidéw béno, ménangéy man i Pilatowe dob de étéw ménribuk brab bénréhén mano, “Uwité ku mangéy dob téngaanga kome inok fégétiga ku begom énda i salaén.” ");
INSERT INTO tiy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Atin ménsut i Jesuse séménayaf do lénuku suwar brab kéménégal furo. Tidéw béno, ménbéréh i Pilatowe mano, “Téngténg gom, ay niy étéwe.” ");
INSERT INTO tiy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Amun énggitoy de odoroy de fadi brab de guwardiya, ménkes ro maro, “Féléhuén, kélabonén dob kruse!” Tidéw béno, ménbéréh i Pilatowe mano, “Uwit gom brab begom i kémélabo de. Endob i begéne, karangé ku énda i salaén.” ");
INSERT INTO tiy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Atin bang i de ménlimud, “Dob kitab geye fatut féléhuén non béréhé no Beene kun i Nga i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Amun énggélingoo Pilatowey de ni, ménuman i kégilak ne. ");
INSERT INTO tiy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mélaw ménséfule man mahur dob lawie brab fénénginsaa noy Jesuse mano, “Hon i tidéwo muwe de?” Endob énda séménumbul i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mélaw bang Pilatowe, “Sedek énda sémumbul go? Aw énda gétiga mo de ké wén i kuwagib gu témangéy Beem, loo so méméléhu Beem dob kruse?” ");
INSERT INTO tiy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Atin séménumbul i Jesuse mano, “Gagané mo rigonén i nan dob Begéne sabaf saén nirayay Tuluse beem kuwagib. Been i funa nuwe i étéwe ménuwit Begén dini toow na fo dakél i sala ne.” ");
INSERT INTO tiy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Amun énggélingoo Pilatowey ni, ménuyot damén témangéy bé Jesuse. Endob ménékes i de Judio maro, “Amuk fétangéyém i nan étéw, sébanil go wayo bé gérotore datu Sesar dob Roma. Non i ségétéwe étéw émbéréh been kun i datue, beeney sébanile bé Sesare.” ");
INSERT INTO tiy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Amun énggélingoo Pilatowey kébéréh ruwe, fénsutén man i Jesuse. Tidéw béno, ménsar dob saray de kémukum dob gonone féndawét Gabata dob késébéréhe Hebreo (i atag ne i suduwe batéw.) ");
INSERT INTO tiy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Gédétén géutuh bé no térésang atin i gétunduge fuweh, kémanduli i de Judio féndawét “Témara”. Tidéw béno, ménbéréh i Pilatowe dob de Judio mano, “Ay ni datu gome.” ");
INSERT INTO tiy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Atin ménékes man i de étéw maro, “Féléhuén, kélabonén dob kruse!” Atin ménénginsa i Pilatowe mano, “Aw méuyot gom de ké kélaboné kuy datu gome dob kruse?” Tidéw béno, séménumbul i de odoroy de fadi maro, “Enda i ségiyo datu gey saliyu bé Sesare dob Roma.” ");
INSERT INTO tiy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tidéw béno, naté Pilatowe dob berowey Jesuse inok kélaboné ro dob kruse. Atin nangéy roy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mélaw nuwit roy Jesuse mésut dob no ingéd brab ménangéy ro dob gonone féndawét Golgota dob gonone féndawét Golgota dob késébéréh i Hebreowe (i atag ne “gonoy kulobong uléwe”). Atin bé kéagéw ruwe fénduwal ro bé Jesusey krus ne. ");
INSERT INTO tiy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Amun énggégumah ron diyo, i de sundalo, kénlabo roy Jesuse dob kruse. Atin kénlabo ro soy de ruwo gétéw lagéy dob de krus. I ségétéwe de fingé dob kuwono Jesuse, brab i ségétéwe de fingé dob biwong Jesuse. Atin diyo i Jesuse ténunggul dob kérara ruwe. ");
INSERT INTO tiy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Atin wén i sénulat Pilatowe, féndiyo ro dob krus Jesuse mano, “I Jesuse tidéw Nasaret, datu i de Judio.” ");
INSERT INTO tiy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Médooy de Judio énggébasa bé no non i ni gonon kénlaboy Jesuse dob kruse énda mérayuén dob Jerusalem. Atin sénulatén dob téléwe timan késébéréh, Hebreo, Latin, brab Griego. ");
INSERT INTO tiy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Endob i de odoroy de fadi i de Judio ménbéréh ro dob Pilatowe maro, “Kago sulatén de ‘Datu i de Judio’. Yamula sulatém loo bé ni, ‘I ni étéw ménbéréh mano, Begén i datu i de Judio.’ ” ");
INSERT INTO tiy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Endob séménumbul i Pilatowe mano, “I sénulat guwe, énda fakayén fégalinén.” ");
INSERT INTO tiy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I de sundalo, amun énggilid ron kénlaboy Jesuse dob kruse, éndot roy de kégalén, sénbaad ro fot gétéw. Atin éndot ro soy lambung ne. Atin non nawél énda i kumbanga no, ");
INSERT INTO tiy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","i de sundalo ménsébéréh ro maro, “Katom riyasén de. Yamula sékung-kungo tom, atin i témabane gékaan.” Ménrigoy ni inok métuman i Ménsulate Kébéréh i Tuluse mano, “Sénbaad roy de kégal gu brab sénkung-kungo roy lambung guwe.” Atin been i nan i rénigoy de sundalo. ");
INSERT INTO tiy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gédét dob krus Jesuse, diyo téménindég i idéng ne, brab tuwaréy idéng ne libun, brab bawag Kleopase féndawét Maria, brab ségétéwe so Maria tidéw Magdala. ");
INSERT INTO tiy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Amun énggito Jesusey idéng ne brab ségétéwe na kuyugén toow fo kégédawa no, ménbéréh dob idéng ne mano, “Iday, béleewe ni beeney nga me.” ");
INSERT INTO tiy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Atin ménbéréh so dob kuyug ne mano, “Béleewe ni beeney idéng me.” Mélaw méntidéw bé no, i kuyug Jesuse ni nuwitén i idéng Jesuse mule brab fénbatién dob lawi ne. ");
INSERT INTO tiy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tidéw béno, amun énggétiga Jesuse ménggilidén i kéluhanane, ménbéréh mano, “Téruménu,” inok métuman i Ménsulate Kébéréh i Tuluse fantag bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wén i katiyae diyo ménféno bé mélémuwe arak. Mélaw nérém roy maake gafas atin ténunggul ro dob métaahe kayéw brab féndiyo ro dob ba Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Atin amun énggéséfo no, ménbéréh mano, “Enggilidén.” Tidéw béno, méntédungul atin ménléhuén. ");
INSERT INTO tiy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tidéw béno, i de odoroy de Judio nongot ro dob Pilatowe ké fétéfoén i sékéy i de étéw dob de krus inok magad méléhu. Non i de Judio méuyot ro ké mékédan i lowoh i de étéw dob de krus bé no so gai, non bé gétunduge de térésang Sabado sani gaiwe témérén ro. Brab been i térésange bé kékanduli ruwe. Mélaw toow fo mékétéfu. ");
INSERT INTO tiy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mélaw i de sundalo ténéfo roy sékéy i de ruwo gétéw lagéy dumo Jesuse énggéséréngan kénlabo dob de krus. ");
INSERT INTO tiy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Endob amun ménfégédét ro dob Jesuse, énggito ro ménléhuén. Mélaw éndaén ténéfo roy de sékéyén. ");
INSERT INTO tiy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Endob i ségétéwe bé de sundalo dénilékén i tébing Jesuse atin réménanas i darae brab wayég. ");
INSERT INTO tiy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Begéney étéwe énggégito bé ni ménrigo. Gétiga ku toow, brab ureté ku toow fo toow inok munur gom de. ");
INSERT INTO tiy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ménrigoy de ni inok métuman i Ménsulate Kébéréh i Tuluse mano, “Fiyon sébaan bé de bukalén, énda i météfo de.” ");
INSERT INTO tiy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Brab wén soy Ménsulate Kébéréh i Tuluse mano, “Téngténgéy de étéw i dénilék ruwe.” ");
INSERT INTO tiy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tidéw béno, wén i ségétéwe lagéy féndawét Jose tidéw Arimatea, ménangéy dob Pilatowe brab nongotén i bangkay Jesuse. I Josehe ni ségétéw so kuyug Jesuse éndob énda ménfayagén non mégilak bé de odoroy de Judio. Tidéw béno, ténungkas Pilatowey bangkay Jesuse, mélaw nangéy Josehe. ");
INSERT INTO tiy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Atin i Nikodemowe sani lagéye téménukaw bé Jesuse bé kélungonone, ménodor bé Josehe brab ménuwit fot folo gékilo fégéféamut. (I ni fégéféamut mira ménsélawék bé aloewe.) ");
INSERT INTO tiy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Atin i de ni lagéy bénaus roy bangkay Jesuse bé futee safut atin sénlawék roy fégéféamute ni. Non been i niy adat i de Judio ké lémbéng ro. ");
INSERT INTO tiy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gédét dob gono Jesuse ménléhu, wén i do nohok kayéw diyo. Atin dob ni gonon wén i mantuwe rénigo lébéng takub énda séna ménlébéngo no. ");
INSERT INTO tiy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Non bé gétunduge de térésang Sabado sani gaiwe témérén ro, fénagayas ro lénébéng i Jesuse dob lébénge ni, non gédét. ");
INSERT INTO tiy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Amun toow fo géfuwén bé Duminggue de, kémélungon séna, ménagéw i libune féndawét Maria Magdalena mangéy dob lébénge. Atin énggito no ménkédan i batéwe dob béngaway lébénge. ");
INSERT INTO tiy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mélaw léménéntu mangéy dob Pedrowe brab ségétéwe ni bé de kuyug Jesus toow fo kégédawa no. Brab bénréhén mano, “Kénda roy bangkay i Kadnane dob lébénge brab énda gétiga key i fénggono ruwe de.” ");
INSERT INTO tiy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tidéw béno, i Pedrowe beroy ségétéwe ni kuyug Jesuse, ménagéw ro mangéy dob lébénge. ");
INSERT INTO tiy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Léménéntu ro atin énggétah énggumah dob lébéngey dumo Pedrowe kuyugén non toow na fo méraan. ");
INSERT INTO tiy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Atin ménkudung-kudung sémarir, éndob énda ménahurén. Enggito no saén i de safut. ");
INSERT INTO tiy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tidéw béno, énggégumah i Pedrowe, atin ménahur i beene dob lébénge brab énggito noy de safut ménumbuk. ");
INSERT INTO tiy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Enggito no soy safute fénggébaus bé uléw Jesuse. Enda ménlawékén dob de dumo safut, éndob méndilin dob ségiyowe gonon. ");
INSERT INTO tiy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tidéw béno, ménahur soy ségétéwe ni kuyug dumo Pedrowe, sani énggétahe énggumah dob lébénge. Atin amun énggito no, ménunur. ");
INSERT INTO tiy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bé ni gai énda séna gésobuto roy Ménsulate Kébéréh i Tuluse fantag bé Jesuse tébule. ");
INSERT INTO tiy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tidéw béno, ménule i de ruwo ni gétéw kuyug. ");
INSERT INTO tiy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Endob i Mariahe kémérew dob liyuy lébénge. Bé lala ne kémérew, ménkudung-kudung sémarir dob bukag i lébénge. ");
INSERT INTO tiy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Atin énggito noy ruwowe gétéw télaki kéménégal fute, ménsar ro dob féniroone bé bangkay Jesuse. I ségétéwe de ménsar fingé dob uléw ne atin i ségétéwe de fingé dob sékéy ne. ");
INSERT INTO tiy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Atin ménbéréh ro maro, “Di, ati funa muwe kémérew?” Atin séménumbul mano, “Nuwit roy Kadna kuwe atin énda gétiga kuy fénggono ruwe de.” ");
INSERT INTO tiy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tidéw béno, séménling brab énggito noy Jesuse téménindég diyo, éndob énda énggélolo no de ké Beeney Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Atin bang Jesuse, “Di, ati funa muwe kémérew? Ati sélédé muwe?” Dob fédéw Mariahe manok beeney magifate bé de nohok diyo. Mélaw ménbéréh mano, “Amuk Beemey ménuwite bé bangkay i Kadna kuwe, béréhém begén i fénggono muwe de inok angéyé ku.” ");
INSERT INTO tiy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tidéw béno, bang Jesuse, “Maria.” Atin méntékélid ténéngténgén i Jesuse brab ménbéréh dob késébéréh i de Judio mano, “Raboni!” (I atag ne Maistéro.) ");
INSERT INTO tiy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Amun énggélolo Mariahe Beeney Jesuse, ménbéréh i Jesuse mano, “Kago gamakén Begén, non énda séna énggéuleu mangéy dob Abay guwe Tulus. Endob ay go dob de tuwaréy gu brab béréhém bero, mangéyu dob Abay guwe sani Tulus guwe. Been soy Abay gome brab Tulus gom.” ");
INSERT INTO tiy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mélaw ménagéw i Maria Magdalenahe nangéyén bénréh dob de kuyug bé énggito noy Kadnane brab ati de bénréhén de. ");
INSERT INTO tiy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Amun kélungononén bé no Duminggu, i de kuyug Jesus ménsélimud ro dob lawie atin kénandado roy de fintu non mégilak ro bé odoroy de Judio. Atin tékow énggito roy Jesuse téménindég dob kérara ruwe. Atin ménbéréh mano, “Fiyoy de fédéw gom damén.” ");
INSERT INTO tiy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tidéw béno, fénténgténgén beroy de fali dob de kémérén brab tébing ne. Atin i de kuyugén toow ro fo ménoror non énggito ro. ");
INSERT INTO tiy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tidéw béno, ménbéréh man i Jesuse mano, “Fiyoy de fédéw gom damén. Sugué ku begom loo bé késugu i Abay guwe Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tidéw béno, niyufén bero brab ménbéréh mano, “Tanggaf gom i Rémogor i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Amuk fésagada kom i ségétéwe bé de salaén, émfésagadan. Buluk énda fésagada kom de, énda émfésagadan no.” ");
INSERT INTO tiy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","I ségétéwe bé de folo bra ruwo kuyug Jesuse féndawét Tomas (féndawét so “Séfing”) énda diyoén bé no gai méntéfégitoy Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mélaw i de dumo no kuyug nuret ro dob beene maro, “Enggito gey i Kadnane”. Endob ménbéréh i Tomase mano, “Enda fo munuru de taman énda gito guy fali i de kélabo dob de kémérén brab taman énda géahuro kuy de dau kémér gu dob de fali dob de kémérén brab dob tébing ne.” ");
INSERT INTO tiy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ménifus i ségéfadiyane tidéw béno, ménsélimud man i de kuyug Jesus brab diyo soy Tomase. Fiyon fo ké i de fintu ménkandado, tékow méntéfégitoy Jesuse téménindég dob kérara ruwe. Atin i Jesuse ménbéréh mano, “Fiyoy de fédéw gom damén.” ");
INSERT INTO tiy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tidéw béno, ménbéréh i Jesuse dob Tomase mano, “Téngténgém i de ni. Fédiyoém i de dau kémérém dob de kémér gu, brab féahurém i kémér me dob tébing guwe ni. Kagonén magalang-galang. Unur go Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tidéw béno, ménbéréh i Tomase mano, “Beemey Kadna kuwe brab Tulus gu.” ");
INSERT INTO tiy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Atin bang Jesuse, “Aw munur go Begén non énggito mo Begén? Toow fo méoror i de munur Begén fiyon fo ké énda séna énggito ro Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Médoo na do mékégaif rénigo Jesuse énggitoy de kuyugén éndob énda ménsulatén dob ni libro. ");
INSERT INTO tiy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ménsulat i de ni inok munur gom bé Jesusey Kristowe, sani Nga i Tuluse. Atin sabaf bé kéunur gome bé Jesuse gédoté kom i umule magufusa. ");
INSERT INTO tiy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tidéw béno, méntéfégito man i Jesuse dob de kuyugén dob dogote féndawét Tiberias. Loo bé niy énggéagéwo nuwe. ");
INSERT INTO tiy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Diyo i Simon Pedrowe bero ro Tomas (féndawét so Séfing) brab Natanael tidéw Kana dob sakuf i Galileawe, brab ruwowe gétéw nga Sebedeo féndawét Juan brab Santiago, brab ruwowe gétéw kuyug Jesuse dumo ro. ");
INSERT INTO tiy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Atin i Pedrowe ménbéréh dob berowe mano, “Mangéyu tugés.” Atin séménumbul ro maro, “Modor gey beem.” Mélaw ménagéw ro ménangéy ro méda dob awange. Endob énda i sébaan énggédot ro sédo bé no ménségékélungonon. ");
INSERT INTO tiy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Amun sémbang i térésange, diyo i Jesuse téménindég dob dénsaane. Endob i de kuyugén énda gétiga ro de ké Beeney Jesuse. ");
INSERT INTO tiy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tidéw béno, ménbéréh i Jesuse mano, “Do adih, wén i énggédot gom sédo loo ké énda?” Séménumbul ro maro, “Enda.” ");
INSERT INTO tiy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Atin ménbéréh man i Jesuse mano, “Lawu gom i fukét gome fingé dob kuwonoy awange atin gégédot gom de sédo.” Mélaw lénawu roy fukét ruwe loo bé kébéréh Jesuse de. Tidéw béno, énggégédot ro toow fo médoo sédo. Atin énda génaga roy mégénge bé fukéte dob awange non toow fo émbégat i de médoo sédo. ");
INSERT INTO tiy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Atin i ségétéwe ni bé de kuyug toow fo ménggédaw i Jesuse de, ménbéréh dob Pedrowe mano, “Beeney Kadnane!” Amun énggélingoo Pedrowe, “Beeney Kadnane”, kéménégal (non kénda noy kégal ne) brab ménagayas ménantéfor dob wayége atin léménangoy mangéy dob dénsaane. ");
INSERT INTO tiy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","I de dumo do kuyugén ménfuray ro dob dénsaane ménda awang, génuyud roy fukéte ménféno sédo. Enda mérayuén tidéw dob dénsaane, wén keey i siyow folo gémitroy kérayu ne. ");
INSERT INTO tiy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Amun déménunggu ron, énggito roy mégébarawe aféy wén i féntanang de sédo. Wén soy fan de. ");
INSERT INTO tiy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Atin bang Jesuse, “Uwit gom diniy dumoy de sédo énggédot gom.” ");
INSERT INTO tiy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mélaw i Pedrowe ménénik dob awange inok gédoté noy fukéte. Tidéw béno, génuyudén mangéy dob dénsaaney fukéte ménféno do dakél sédo. Fiyon fo ké ménféno bé dakéle sédo, mératuh bra limo folo bra téléw, énda ménkusi i fukét ruwe. ");
INSERT INTO tiy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Atin bang Jesuse bero, “Enggomén, mama tom.” Enda i ségétéw bé de kuyugén émbaraw ménénginsa ké ati Beene ni, non énggétiga ron Beeney Jesuse Kadnan. ");
INSERT INTO tiy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mélaw i Jesuse ménfégédét dob fane brab méndot de brab bénaadén dob berowe, loo soy de sédo. ");
INSERT INTO tiy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Been i niy gétéléwe gule méntéfégitoy Jesuse dob de kuyugén tidéw bé kétébule ne. ");
INSERT INTO tiy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Amun énggilid ron mama, ménénginsa i Jesuse dob Simon Pedrowe mano, “Simon, nga Jonas, aw toow na fo méimu go Begén bé kéimu i kéluhanay de ni Begén?” Séménumbul i Pedrowe mano, “Hoo Kadnan, gétiga moy kéimu guwe Beem.” Atin bang Jesuse, “Fagifatém i de bili-bili gu.” ");
INSERT INTO tiy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tidéw béno, ménénginsa man i Jesuse mano, “Simon, nga Jonas, aw toow fo méi mu go Begén?” Séménumbul man i Pedrowe mano, “Hoo Kadnan, gétiga moy kéimu guwe Beem.” Atin bang Jesuse, “Fagifatém i de bili-bili gu.” ");
INSERT INTO tiy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Atin ménénginsa i Jesuse bé gétéléw ne gule mano, “Simon, nga Jonas, aw méimu go Begén?” Méntete i fédéw Pedrowe non fénénginsaa Jesuse gétéléw gule mano, “Aw méimu go Begén?” Mélaw séménumbul i Pedrowe mano, “Kadnan, gétiga moy kéluhanane, gétiga moy kéimu guwe Beem.” Atin bang Jesuse, “Fagifatém i de bili-bili gu. ");
INSERT INTO tiy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Béréhé ku beem i toowe, amun ménguwéd go séna, géikéto moy sintoro muwe, atin mangéy go dob kétaya muwe ayo mo. Endob buluk lukés gon, ségérun go kémawa, atin ségiyoy marake beem atin uwité no beem mangéy dob kéikaa muwe ayo mo.” ");
INSERT INTO tiy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Bénréh Jesusey ni dob Pedrowe nuretén i atiy fégéléhu ne funay Tuluse émbantug.) Tidéw béno, bang Jesuse bé Pedrowe, “Furay go Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Atin séménling i Pedrowe, atin énggito noy toowe ni fo kégédawa Jesuse kuyugén, sani kuyuge ménfégédét dob Jesuse bé kéama ruwe dob kékandulie brab ménénginsa mano, “Kadnan, ati émfékéfoe Beem?” ");
INSERT INTO tiy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","I Pedrowe, amun énggito noy ni ségétéw kuyug, ménénginsa dob Jesuse mano, “Ati mosoy géagéwoy ni étéw?” ");
INSERT INTO tiy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Séménumbul i Jesuse mano, “Amuk méuyotu de ké méuyag taman bé késéfule guwe dob duniyae ni, ati mélaw i kaame de? Furay go Begén.” ");
INSERT INTO tiy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sabaf mélaw bé ni, ménlégéb dob de kuyug Jesuse i urete bé i ni kuyug énda kun méléhuén. Endob békén bénréh Jesuse ké énda méléhuén. I bénréh Jesuse saén mano, “Amuk méuyotu de ké méuyag taman bé késéfule guwe, ati mélaw i kaame de?” ");
INSERT INTO tiy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Begéney nan kuyug Jesuse bénrého no! Enggito guy kéluhanay de ni ménrigo brab sénulat gu dob ni. Atin gétiga key i kéluhanay de ni ménsulat toow fo toow. ");
INSERT INTO tiy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Médoo nay de éntingayén rénigo Jesuse tidéw bé de ni. Endob amuk sulatén kéluhanan, kloh sa keeyén i duniyae fégonon bé kéluhanay librowe ménsulat.");
INSERT INTO tiy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo, Dob sunguwe libro gu, sénulat gu dob beemey fantage bé kéluhanay de rénigo Jesus brab de ténoroén tidéw dob gaiwe féngganayén i kégalbék ne, ");
INSERT INTO tiy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","taman dob gaiwe féndiyat i Tulusey Jesuse mangéy dob lawayo. Amun énda séna déméniyatén de, fénémanduo no bé barakat i Rémogor i Tulusey de fénémilién do kuyugén féndawét do Apostol (i atag i ni do sénugu). ");
INSERT INTO tiy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Méntéfégitoy Jesuse dob berowe médoo gule tidéw bé kéléhu ne taman fot folo gétérésangan inok toow fo gétiga ro méntébule. Dob de ni do gai méntéfégito dob berowe, ténoroén i fantage bé kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Atin amun ménsélimud i Jesuse beroy de kuyugén bénréhén bero mano, “Kagom séna tékédan dob Jerusalem. Endob ongot-ongot gom i fénasad i Abay guwe begom, sani bénréh guwe nén begom. ");
INSERT INTO tiy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","I Juane ménautis bé wayége éndob éndaén mérugayén bautison gom bé Rémogor i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wén i no ségiyo gai ménsélimud i Jesuse beroy de apostol. Atin fénénginsaa ro maro, “Kadnan, aw béleewe ni bay gaiwe féséfuleé moy kuwagibe émfétindég bé ingéd tome Israel?” ");
INSERT INTO tiy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Séménumbul i Jesuse mano, “Békénén fatut gétiga kom i de gai non i Abay guwe saén i wéne aturano bé de gai. ");
INSERT INTO tiy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Endob amuk gégumah i Rémogor i Tuluse dob begome, waléy gom barakatan. Atin mélaw begomey murete fantag bé Begéne dob de étéw dob Jerusalem, brab dob kéluhanay de ingéd dob Judea brab Samaria, brab dob kéluhanay de ingéd dob duniyae ni.” ");
INSERT INTO tiy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Amun énggilid Jesuse bénréh i ni, féndiyat i Tulusey Jesuse mangéy dob lawayo atin ténéngténg ro taman méntéléb bé de rawén. ");
INSERT INTO tiy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Amun déméniyatén i Jesuse, i lala ruwe séna léméngag dob lawayo, tékow méntéfégitoy ruwowe gétéw lagéy kéménégal ro fute téménindég diyo dob sékulo ruwe. ");
INSERT INTO tiy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Brab ménbéréh ro maro, “Do étéw tidéw Galilea, sedek léméngag gom saréw dob lawayo? I Tuluse féndiyatén i Jesuse mangéy dob lawayo, atin séfule so moso loo bé kégito gome de déméniyat.” ");
INSERT INTO tiy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tidéw béno, i de apostol ménséfule ro mangéy Jerusalem tidéw dob tuduke féndawét Olibo, ségékilometroy kérayu ne. ");
INSERT INTO tiy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Amun énggégumah ron dob ayo ruwe ni ingéd, méntaus ro dob sibéye dob rotor i lawie gono ro bati. I de ni ro Pedro, Juan, Santiago, Andres, Filipi, Tomas, Bartolome, Mateo, Santiago nga Alfeo, Simon sani ségétéwe toow fo gulaané noy ingéd ne, brab Judas nga Santiago. ");
INSERT INTO tiy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sénga tékélid sélimud ro inok démasal ro beroy de libun brab Mariahe idéng Jesuse, loo soy de tuwaréy Jesus do lagéy. ");
INSERT INTO tiy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Amun ménifus i firoye gétérésangan, ménsélimud i de munur bé Jesuse, wén i mératuh bra ruwo folo gétéw. Atin téménindég dob téngaanga ruwey Pedrowe brab ménbéréh mano, ");
INSERT INTO tiy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Do dumo gu, énda fakayén ké énda métuman i Ménsulate Kébéréh i Tuluse, fénbéréh i Rémogor i Tuluse bé Datu Dabidey fantage bé Judase, sani ménuwite bé de kéménéfo bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","I Judase, ségétéw betom, brab fénémili ménamung bé galbék tome.” Been i bénréh Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Atin i kurtae énggédotén bé ni tete rénigo no bé Jesuse fénggébéléyén fantad, atin diyo ménlawu brab ménléhu non ménbétus i sur ne atin méntandég i de téneekén. ");
INSERT INTO tiy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Atin énggélingooy kéluhanay de étéw dob Jerusalem i ni ménrigo, mélaw féndawét roy ni fantad “Akeldama”, dob karowe késébéréh. (I atag ne “Démara fantad”.) ");
INSERT INTO tiy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Féntaus Pedrowey kébéréh ne mano, “Sénulat dob de Kanta tidéw dob Ménsulate Kébéréh i Tuluse mano, ‘I lawi ne taus i kétagake de damén atin énda i bati diyo fiyon ségétéw.’ Brab ménsulat so mano, ‘Wén damén i émfétaus bé galbék ne.’ ");
INSERT INTO tiy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Mélaw,” bang Pedrowe, “fatut mémili tom ségétéw mantu dumo tom muret fantag bé kétébule Jesuse. Fatut beeney étéwe dumo tom ménséodor-odor bé kédiniy Kadna tome séna, tidéw bé kéuret Juane bé kébautis ne taman bé kédiyat Jesuse mangéy dob lawayo.” ");
INSERT INTO tiy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mélaw ménémili ro ruwo gétéw lagéy, ro Matias bero Jose Barsabas (féndawét so Justo). ");
INSERT INTO tiy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tidéw béno déménasal ro maro, “Kadnan, gétiga moy fédéw i kéluhanay étéwe. Mélaw féfégétiga mo begey ké ati isuwe fénémiliém bé de ruwo ni gétéw, ");
INSERT INTO tiy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","inok waléy apostol brab mamung émfétaus bé galbéke ténagak Judase amun ménuleén mangéy dob gonone fatut ayono.” ");
INSERT INTO tiy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tidéw béno, sénbunuto ro atin ménfémili i Matiase. Mélaw i Matiase ménwaléy apostol beroy de folo bra sébaan, brab ménamung bero. ");
INSERT INTO tiy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Amun énggumahén i gaiy kékanduli ruwe féndawét Pentekostes, i kéluhanay de méginugut bé Jesuse, ménsélimud ro dob sébaane gonon. ");
INSERT INTO tiy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Atin tékow wén i énggélingoo ro tidéw dob lawayo toow fo métanug maak émbagér réfuruh. Atin ménlégéb dob lawie gono ro ménsar. ");
INSERT INTO tiy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tidéw béno, énggito roy de maak dila rino aféy ménlégéb brab méntégatag dob bumbunay séngae ségétéw bero. ");
INSERT INTO tiy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Atin fénémanduoy Rémogor i Tuluse bero. Atin ménsébéréh-béréh ro do séségiyo-giyo do késébéréh non fénbéréh i Rémogor i Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Dob Jerusalem, wén i do Judio do méngintulus ménbati diyo. Tidéw ro dob de séségiyo-giyo ingéd dob duniyae. ");
INSERT INTO tiy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Amun énggélingoo roy ni démégués, médooy de étéw ménangéy diyo brab ménsélimud ro. Brab ménkéségiyonan ro non amun ménsébéréh i de étéw méginugut bé Jesuse, i séngae étéw énggélingoo noy kaane késébéréh. ");
INSERT INTO tiy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Non toow fo ménkéségiyonan ro, ménséfénginsa ro maro, “Aw ati ni? Aw békén ba kéluhanay de ni do étéw tidéw ro Galilea? ");
INSERT INTO tiy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sedek gélingoo tom bero sébéréh bé kéluhanay de késébéréh dob de ingéd ténidéwo tom? ");
INSERT INTO tiy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tidéw tom dob Partia, dob Media, dob Elam, dob Mesopotamia, dob Judea, dob Kapadosia, dob Ponto, dob Asia. ");
INSERT INTO tiy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Dob Frigia, dob Pamfilia, dob Egipto, dob de ingéd sakuf i ingéde Libia gédét dob Siren, brab dob Roma, ");
INSERT INTO tiy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","do Judio brab do békén do Judio éndob ménwaléy do munur bé kétoro i de Judio. Tidéw tom dob Kreta, brab dob Arabia. Atin i séngae ségétéw betom énggélingoo no bero sébéréh-béréh dob kaane késébéréh fantag bé toowe fo mékégaif rénigoy Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Atin toow fo ménggaif ro brab énda énggésobuto roy ni ménrigo. Mélaw ménséfénginsa ro maro, “Ati atag i ni ménrigo?” ");
INSERT INTO tiy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Endob i de dumo do étéw déniyangka roy de kuyug Jesus brab ménbéréh ro maro, “Molon i de ni do étéw.” ");
INSERT INTO tiy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tidéw béno, téménindég i Pedrowe beroy de folo bra sébaan do dumo no apostol brab ménbéréh métanug dob de ménsélimud étéw mano, “Do dumo gu do Judio brab kéluhanay de étéw bati dob Jerusalem, toow gom fégélingo i béréhé kuwe ni inok gésobuto kom. ");
INSERT INTO tiy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","I de ni do étéw énda molon ro loo bé kéfégitung gome de, non géraraan lémowot sénay térésange ni. ");
INSERT INTO tiy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Endob méntuman béleewe niy bénréh i méntélatae sénarigoy Tuluse muret bé kébéréh ne féndawét Joel mano, ");
INSERT INTO tiy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ay niy rigoné kuwe dob de tamfaday de gai, bang i Tuluse. Iray gu témantuy Rémogor guwe dob kéluhanay étéwe. Brab i de nga gom do lagéy brab libun, béréhé roy de kébéréh gu. Atin i de kénogo lagéy gom gito roy toowe tidéw dob Tuluse, brab i de lukés gom so gito roy toowe tidéw dob Tuluse amuk téméginéf ro. ");
INSERT INTO tiy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Atin fiyon foy de sugu-sugué ku, do lagéy brab do libun, ureté roy kébéréh guwe non tantuno ku bero irayan bé Rémogor guwe. ");
INSERT INTO tiy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Atin rémigowu do mékégaif dob lawayo brab dob fantade. Giton i darae, aféye, brab mégéfole bél. ");
INSERT INTO tiy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Atin i térésange waléy délémon, brab i térésang kélungonone waléy furo maak dara. Been i niy mérigowe ké énda séna gégumah i émbantuge gaiy Kadnane kémukum. ");
INSERT INTO tiy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Atin i kéluhanay mongote tabang dob Kadnane, méfukas ro dob de sala ro.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Atin féntaus Pedrowey kébéréh ne mano, “Do dumo gu do Judio, fégélingo gom i ni! I Jesuse tidéw Nasaret, Beeney fénuwit i Tuluse. Atin i de mékégaif do galbék fénrigoy Tuluse de, been i fégétuwana kome bé i Jesuse, Beeney tidéwe dob Tuluse. Atin énggétuwa komén i ni non i kéluhanay de ni, ménrigo dob kérara gome. ");
INSERT INTO tiy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Enggétigay Tulusey ati mérigowe non bénantak i Tuluse fékéfoén i Jesuse brab nirayén begom atin fénléhu gom fénkélabo bé de tete étéw dob kruse. ");
INSERT INTO tiy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Endob i Tuluse ténébuleén i Jesuse brab ténungkasén tidéw dob kédawét i kéléhue non énda fo fakayén gétaus méléhu i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Loo bé bénréh Dabide bé do gétah fantag bé Jesuse mano, ‘Démoyun gito guy Kadnane dob sékulo kuwe, Beeney dumo guwe dob kuwono kuwe, mélaw énda mégilaku. ");
INSERT INTO tiy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sabaf bé ni, toow fo fiyoy fédéw guwe brab béréhé kuy kéoror guwe. Enda émbukuu bé lowoh guwe non wén i inam gu. ");
INSERT INTO tiy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Non énda tagaké mo Begén dob gonoy de ménléhu. Brab énda fédayaé moy lowoh i fiyowe sugu-sugué mo ké mérénah. ");
INSERT INTO tiy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ténoroém begén i agéwone dob kéuyage. Atin sabaf bé Beem i dumo guwe, féororénu.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Féntaus Pedrowey kébéréh ne mano, “Do dumo gu, toow fo béréhé ku begom i fantage bé katufua tome Dabid. I beene ménléhu brab lénébéng, atin taman béleewe ni ay ni soy lébéng ne. ");
INSERT INTO tiy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Beeney ségétéwe sénarigoy Tuluse muret bé kébéréh ne. Atin énggétiga noy fénasad i Tuluse dob beene bé i ségétéwe bé de séfuén waléy datu loo bé beene. ");
INSERT INTO tiy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Enggétiga Dabide ké ati rigonéy Tuluse, komon énggébérého noy fantage bé kétébule Kristowe mano, ‘Enda méntagakén dob gonoy de ménléhu brab énda mérénah i lowoh ne.’ ");
INSERT INTO tiy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","I Jesuse ni féntébule i Tuluse, brab kéluhana key énggégito bé ni. ");
INSERT INTO tiy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Atin i Abay ne Tulus, féndiyatén i Jesuse mangéy dob kuwono nuwe, sani toowe fo basanan gonon. Atin i Jesuse, éndotén dob Beeney Rémogor i Tuluse loo bé fénasad ne. Mélaw i gito gome brab gélingoo kome bé béniy barakat i Rémogor i Tuluse nirayén begey. ");
INSERT INTO tiy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","I bénréh Dabide, békén fantag bé lowoh ne non énda déméniyat i Dabide mangéy dob lawayo, éndob been i ménbéréh mano, ‘Bénréh i Kadnane dob Kadna kuwe mano, sar go fingé dob kuwono kuwe, ");
INSERT INTO tiy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","taman tabana kuy de sébanil Beem.’ ");
INSERT INTO tiy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mélaw, i de kéluhana tom do Judio, fatut gétuwa tom i Jesuse ni, sani kénlabo gome dob kruse, féndawét i Tulusey Kristowe Kadnan.” Been i niy bénréh Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","I de étéw, amun énggélingoo roy ni, ménbuku i de fédéw ro. Atin ménénginsa ro dob Pedrowe brab dob de dumo no apostol maro, “Do dumo gey, ati fatute rigoné key?” ");
INSERT INTO tiy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Atin séménumbul i Pedrowe mano, “I séngae ségétéw begom fatut gésénule bé de salaén brab fébautis inok fégito noy kéunur ne bé Jesu Kristowe, inok i de salaén émfésagadan. Tidéw béno, i Tuluse irayén i Rémogor ne dob begome. ");
INSERT INTO tiy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Non i ni fasad i Tuluse, katom brab kay de nga tom, brab kay kéluhanay de étéw dob de mérayu, non kay kéluhanay fénémili i Kadna tome Tulus munur dob Beene.” ");
INSERT INTO tiy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Atin médoo nay bénréh Pedrowe bero fantag bé toowe brab fénfagayu no bero mano, “Sésuway gom bé de tete étéw inok énda mékukum gom so.” ");
INSERT INTO tiy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Atin médooy étéwe ménunur bé kébéréh Pedrowe brab ménfébautis ro, brab labi ro téléw ngibu ménuman dob de kuyug Jesus bé béno. ");
INSERT INTO tiy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Atin sénga tékélid fégélingoé roy kétoro i de apostol, atin ménséodor-odor ro maak do sétuwaréy ro. Brab séréngan ro mama brab démasal. ");
INSERT INTO tiy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Atin i de apostol, fénrigoy Tuluse bero do médoo mékégaif galbék, mélaw toow fo ménggaif i kéluhanay de étéw. ");
INSERT INTO tiy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Atin i kéluhanay de munur bé Jesuse, démoyun ro sélimud atin i kéluhanay de languntama ro séntukid-tukid ro. ");
INSERT INTO tiy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Atin fénbéléy roy de fantad ro brab de tamuk ro inok sétukid-tukidé ro loo bé atiy de kailanga ro. ");
INSERT INTO tiy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sénga fuweh sélimud ro dob lawi i Tuluse, brab séréngan ro mama dob de lawi ro. Brab lala ruwe mama, toow ro fo moror brab térifantad. ");
INSERT INTO tiy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Sénga tékélid dayéwé roy Tuluse brab mégédaw i de étéw bero. Atin sénga fuweh umanay Kadnane bero bé de mantu ménfukas étéw. ");
INSERT INTO tiy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wén i no sébaan fuweh, géraraan lémudug i térésange de, sani uras i kédasal i de Judio, i ro Pedrowe brab Juane ménangéy ro dob lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dob béngaway lawi i Tuluse féndawét “Fiyo Fintu”, wén i ségétéwe lagéy fikat tidéw fanay kéumahén. Sénga fuweh uwitéy de dumo no mangéy dob ni béngawan inok mongot limus dob de étéw mahur diyo. ");
INSERT INTO tiy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Amun énggito noy ro Pedrowe brab Juane mahur, ménongot limus dob berowe. ");
INSERT INTO tiy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tidéw béno, ténéngténg ro Pedrowe brab Juaney ni lagéy fikat brab ménbéréh i Pedrowe mano, “Enténgén gey.” ");
INSERT INTO tiy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mélaw ténéngténgén bero, manok iraya ro kurta. ");
INSERT INTO tiy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Endob i Pedrowe ni ménbéréh mano, “Enda i kurta gu taloo no bélowon, éndob iray gu beem i wéne dob begéne. Sabaf bé barakat i dawét Jesu Kristowe tidéw Nasaret, béréhé ku beem, agéw go!” ");
INSERT INTO tiy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Atin génamak Pedrowey kuwonone kémérén brab féntindégén. Sonom béno, tékow ménbagér i de sékéyén. ");
INSERT INTO tiy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Atin méntésongkow témindég brab ménggéagéw. Atin ménahur dob lawi i Tuluse bero ro Pedrowe brab Juane, magéw brab sayaw-sayaw brab dayéwé noy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Atin énggitoy kéluhanay de étéw i ni lagéy magéw brab dayéwé noy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Atin amun énggélolo ron beeney fikate démoyun mésar mongot limus dob “Fiyowe Fintu”, toow ro fo ménggaif bé ni ménrigo dob beene. ");
INSERT INTO tiy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Atin i lala ne géménamak dob ro Pedrowe brab dob Juane dob kuridore féndawét “Kuridor Solomone” ménfégédét léméntu mangéy dob berowey kéluhanay de étéw non ménggaif ro bé ni ménrigo. ");
INSERT INTO tiy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Amun énggito Pedrowey de étéw ni, ménbéréh dob berowe mano, “Do dumo gu do Judio, sedek ménggaif gom bé ni? Sedek téngténgé kom begey loo bé nan? Aw makom ké ménggéagéw i ni lagéy sabaf bé barakat geye taloo no sabaf bé fiyowe kéféngintulus gey? ");
INSERT INTO tiy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Endob Been i Tuluse féngadafé Abrahame, Isak, brab Jakob, brab de katufua tom, i ménirayane toow fo gérotor barakat dob Jesuse, sénuguén. Endob niray gom dob de gémamak kukuman, brab ménika gom de dob adafa Pilatowe inok kukumé no, fiyon fo ké ménuyot de témangéy. ");
INSERT INTO tiy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","I Jesuse ni métintu brab énda i salaén, éndob ménika gom de brab énda féntangéy gom de. Yamula féntangéy gom uman i ségétéwe étéw ménméléhu. ");
INSERT INTO tiy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Atin fénléhu gom i Jesuse sani miraye bé umule magufusa. Endob ténébule i Tuluse brab énggito gey i ni. ");
INSERT INTO tiy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Barakat i dawét Jesusey énggéféadi-adiwe bé ni lagéy fikat gélolo gom. Ménrigoy ni sabaf bé kéunur geye bé Jesuse. Been i funa nuwe énggéagéw dob téngaanga kome. ");
INSERT INTO tiy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Atin béleewe do dumo gu, gétiga ku énda énggétiga kom i rénigo gome brab de odoro tom bé kéféléhu gome bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Endob bé ni rénigo gom, ténumay Tulusey bénréh i de sénarigo no muret bé kébéréh ne bé gétaho, bé i Kristowe fatut férasayén. ");
INSERT INTO tiy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mélaw tagak gom i de tete adat gom brab unur gom bé Tuluse inok fésagada no begom bé de sala gom. ");
INSERT INTO tiy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Atin mélaw wén i do gai féfiyonéy Tulusey de fédéw gom. Atin féuwitén i Jesuse mangéy dob begome. Been i Kristowe, sani fénémili ne méguléw begom. ");
INSERT INTO tiy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Atin béleewe, i Jesuse bati séna dob lawayo taman bé kégumah i gaiwe féantunéy Tulusey kéluhanane. Been i niy bénréh i de sénarigoy Tuluse muret bé kébéréh ne bé gétaho. ");
INSERT INTO tiy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Non i Moisese ménbéréh bé gétaho dob de Judio mano, ‘I Tuluse sémugu moso ségétéw sarigo no loo bé begéne. Been i ségétéwe bé de séfu tom. Unuro kom i kéluhanay béréhé nuwe begom. ");
INSERT INTO tiy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Atin i kéluhanay étéwe énda munur ro de, fégananéy Tuluse bero tidéw dob de étéwén, brab binasané no bero.’ Been i niy kébéréh Moisese. ");
INSERT INTO tiy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bénréh i de dumo so sénarigoy Tulusey fantage bé de mérigo bé de ni do gai, tidéw dob Samuele brab dob kéluhanay de énggétundug dob beene. ");
INSERT INTO tiy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Atin i de fasad i Tuluse bénréh i de sénarigo no bé do gétah, kagom so. Atin kagom soy fasad i Tuluse dob de katufua kom. Non bénréhén dob Abraham mano, ‘Féfiyoné kuy kéluhanay étéwe dob duniyae fénagéw dob de séfuém.’ ");
INSERT INTO tiy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Komon amun fén-uwit i Tulusey Kristowe, sénuguén sungu mangéy dob betome do Judio inok féfiyoné no betom bé kéfésénule ne betom bé de tete rigoné tom.” Been i niy kébéréh Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Amun émbéréh sénay ro Pedrowe brab Juane dob de étéw, énggégumah i de fadi, brab kafitay de mantay bé lawi i Tuluse, brab de Saduseo sani de étéw énda munur ro bé kétébulee. ");
INSERT INTO tiy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Atin ménkérit ro non téménoro i ro Pedrowe brab Juane dob de étéw bé i Jesuse méntébule. Mélaw fénggito ro wén i kétébule. ");
INSERT INTO tiy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mélaw kénéfo ro bero, atin non sémingkufén bé béno, fénrisu ro bero taman bé démoe de. ");
INSERT INTO tiy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Endob médooy ménunure bé de étéw énggégélingo bé kébéréh Pedrowe, atin i de munur énggégumah limo ngibuy kédooy de lagéy de saliyu na bé de libun de. ");
INSERT INTO tiy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Amun bé démoe de, ménsélimud dob Jerusalem i de odoroy de Judio brab de lukés bero brab de témoro kukuman. ");
INSERT INTO tiy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bero soy gérotore fadi féndawét Anas, brab Kaifas, brab Juan, brab Alejandro brab kéluhanay samung i ni gérotor fadi. ");
INSERT INTO tiy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Atin féntindég roy de ruwo ni gétéw apostol dob adafa ruwe brab fénénginsaa ro bero maro, “Ati gefee bé barakate brab ati gefee bé dawéte fénggérigo gom bé ni?” ");
INSERT INTO tiy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tidéw béno, fénémanduoy Rémogor i Tulusey Pedrowe atin mélaw séménumbul mano, “Do odoro key brab do lukés gey. ");
INSERT INTO tiy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Amuk fénginsaa kom begey fantag bé fiyowe rénigo gey dob ni lagéy fikat brab ati kéféadi-adi geye de, ");
INSERT INTO tiy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","fégétiga ku dob kéluhana kome brab dob kéluhanay de Judio. I funay ni lagéy téménindég dob adafa kome ménadi-adi, non bé barakat i dawét Jesu Kristowe tidéw Nasaret. Been i fénléhu gome dob kruse éndob ténébule i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wén i ménsulate fantag bé Jesuse dob Ménsulate Kébéréh i Tuluse mano, ‘I batéwe nikaa kom do rémigo lawi, been i ménwaléye toow fo mélaga batéw.’ I Jesuse, Been i nan batéw nikaa kom. ");
INSERT INTO tiy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Been saén i Mémukase,” bang Pedrowe, “non énda i ségiyo dob duniyae ni géfukas bé étéwe.” ");
INSERT INTO tiy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Toow fo ménggaif i de odoroy de Judio bé kébaraw ro Pedrowe brab Juane muret. Ménlabi na foy kégaif ruwe non énggétuwa roy énda i féngganad ro Pedrowe brab Juane. Atin mélaw énggélolo ro soy beroy de dumo Jesus. ");
INSERT INTO tiy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Endob énda i gébérého ro, non énggito roy lagéye ni fikat ménadi-adi téménindég dob sékulo Pedrowe brab Juane. ");
INSERT INTO tiy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mélaw fénsut ro bero tidéw dob sénlimudo ruwe sibéy. Tidéw béno ménsébéréh-béréh ro maro, ");
INSERT INTO tiy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ati kérigo tome bé de ni étéw? Non kéluhanay de étéw ni dob Jerusaleme ni, énggétiga roy mékégaife ni rénigo ro. Mélaw énda gédirungo tom de. ");
INSERT INTO tiy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Endob géléé tom saén bero bé éndaén béréhé roy fantage bé Jesuse inok énda métarakén.” ");
INSERT INTO tiy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mélaw ténawag ro man bero mahur brab bénrého ro bero bé békénén béréhé roy fantage bé Jesuse taloo no témoro ro labité roy dawét ne. ");
INSERT INTO tiy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Endob i Pedrowe brab Juane séménumbul ro maro, “Fégitung gom ké ati isuwe métintu dob adafay Tuluse, odoro key i kagome sugu loo ké odoro key i sugu i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Non énda fakayén témérén gey muret fantag bé énggito geye brab bé énggélingoo keye.” ");
INSERT INTO tiy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Endob i de odoron toow na fo féningkél roy kégélé ruwe bero bé békénén ureté roy fantage bé Jesuse. Tidéw béno, ténangéy ro bero. Enda gédusana ro bero non bé kédooy de étéw démayéw bé Tuluse sabaf bé mékégaife rénigo ro. ");
INSERT INTO tiy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Non i lagéye ni fén-adi-adi ro fotén folo gébélintuwa i idad ne, brab fikatén tidéw fanay kéumahén. ");
INSERT INTO tiy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Amun méntangéyén i ro Pedrowe brab Juane, ménule ro mangéy dob de dumo ro munur bé Jesu Kristowe. Atin nuret roy kébéréh i odoroy de fadi brab de odoroy de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Amun énggélingoo roy ni, ménséréngan ro démasal dob Tuluso maro, “Kadnan, Beemey léménimbage bé lawaye brab fantade brab dogote brab kéluhanay éntingayéne. ");
INSERT INTO tiy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fénbéréh i Rémogor me bé katufua keye Dabid sugu-sugué mo mano, ‘Sedek ménkérit i de étéw békén Judio? Brab sedek bantakéy de étéw i éndae gérigono ro dob Tuluse? ");
INSERT INTO tiy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","I de datu téménafay ro brab de méguléw dob duniyae ni ménsélimud ro inok sébanil ro bé Kadnane brab Kristowe fénuwitén.’ Been i niy sénulat Dabide.” ");
INSERT INTO tiy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Atin féntaus roy kédasal ruwe maro, “Méntuman i Ménsulate Kébéréhém non ménsélimud i ro Herode brab Ponsio Pilatowe dob ni ingéd beroy de étéw békén Judio brab de dumo gey Judio. Ménsélimud ro sébanil bé Jesuse sani fiyowe sugu-sugué mo fénémiliém méguléw. ");
INSERT INTO tiy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ménsélimud ro rémigo bé kéluhanay éntingayéne fatut mérigo dob kaame kétayan brab dob barakat me mérigo. ");
INSERT INTO tiy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Atin bé béni Kadnan, fégitungém i de tete kébérého ro begey brab tabanga mo begey do sugu-sugué mo inok émbaraw gey muret bé kébéréh me. ");
INSERT INTO tiy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Brab féuwitém i barakat me émféadi-adi brab émférigo begey bé de mékégaif dob dawét i fiyowe sugu-sugué mo Jesus.” ");
INSERT INTO tiy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Amun énggilid ron démasal, ménkuyung i lawie sénlimudo ro brab fénémanduoy Rémogor i Tuluse bero. Tidéw béno, ménbaraw ron muret bé kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Atin i kéluhanay de munur bé Kristowe, ségiléw i de fédéw ro brab itunga ro. Atin énda i isu bero gefe bé de languntama ro, éndob falan karo kéluhanan non séntukid-tukid ro. ");
INSERT INTO tiy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Atin wén i barakat i de apostol féntaus roy kéuret ruwe fantag bé kétébule i Kadnane Jesus. Brab i Tuluse toow fo mégédaw bero. ");
INSERT INTO tiy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Atin énda i ségétéw bero wén i kulang bé kéfaguyag ne non fébéléy roy de fantad ro taloo no do lawi ro atin i kurtae gédoté ro, ");
INSERT INTO tiy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","iray ro dob de apostol. Atin saaré roy kurtae dob katabuwane kailangay kéluhanane. ");
INSERT INTO tiy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Atin wén i ségétéwe bero féndawét Jose. Beeney ségétéwe tidéw Siprus brab séfu i Lebitawe. Féndawét i de apostol so “Bernabe”. (I atag i ni “Ségétéw émféfiyo fédéw”.) ");
INSERT INTO tiy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Fénbéléyén i fantad ne atin nirayén dob de apostol i kurtae de. ");
INSERT INTO tiy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wén i ségétéwe lagéy féndawét Ananias, beroy bawag ne féndawét Safira, fénbéléy roy dumoy fantad ruwe. ");
INSERT INTO tiy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Endob nitongén i dumoy kurtae brab ménagayun soy bawag ne de. Atin nirayén i sama i kurtae dob de apostol. Endob bénréhén bé nirayén i kéluhanane. ");
INSERT INTO tiy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mélaw bénréh Pedrowe dob beene mano, “Ananias, sedek féndayaém i Satanase mémanduon beem? Non téménugi go dob Rémogor i Tuluse, non nitongém i dumoy kurtae énggédotém bé fénbéléy me fantad. ");
INSERT INTO tiy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Amun énda séna fénbéléyém i fantad me, beem i gefee de. Atin amun fénbéléy mon, kaam soy kurtae de. Endob sedek bénantakém rénigoy ni? Békén téménugi go dob étéwe, yamula dob Tuluse téménugi go!” ");
INSERT INTO tiy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Amun énggélingoo Ananiasey ni, méntuwar brab ménléhu. Atin i kéluhanay de énggégélingo fantag bé ni, toow ro fo ménggilak. ");
INSERT INTO tiy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Atin ménahur i de kénogo lagéy brab éndot roy bangkay ne brab bénaus ro atin nangéy ro lénébéng. ");
INSERT INTO tiy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Amun ménifus i téléwe géuras, énggumah i bawag ne, éndob énda séna énggétiga noy ati ménrigowe. ");
INSERT INTO tiy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tidéw béno, fénénginsaa Pedrowe mano, “Béréhém begén, aw been say niy kurtae énggédot i fantad gome?” Atin séménumbul mano, “Hoo, been say nan.” ");
INSERT INTO tiy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mélaw bénréh Pedrowe de mano, “Sedek ténéngkad gom i Rémogor i Tuluse? I bawag me mantu séna ménléhu atin i de ménangéy de lémbéng, ay nan ron dob liyuwan, brab i beeme témundug so.” ");
INSERT INTO tiy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sonom béno, méntuwar so brab ménléhu dob adafa Pedrowe. Amun ménahur i de kénogo lagéy, énggito ro ménléhuén. Mélaw nangéy ro so lénébéng dob doror i bawag ne. ");
INSERT INTO tiy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Atin toow fo méngkégilakan i kéluhanay de munur bé Kristowe, loo soy de kéluhanay de ségiyo étéw énggégélingo bé ni. ");
INSERT INTO tiy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Atin i de apostol, médooy de mékégaif rénigo ro énggitoy de étéw. Brab i kéluhanay de munur bé Kristowe ménsélimud ro diyo dob “Kuridor Solomone” dob lawi i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Enda i ségétéw ménamung bé de énda munur bé Kristowe, fiyon fo ké fiyoy kébéréh i de étéw fantag bé de munur. ");
INSERT INTO tiy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Endob minut médooy de étéw do lagéy brab do libun munur bé Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Atin ménbantug i de mékégaif rénigoy de apostol. Mélaw nuwit i de étéw dob de aguwon i de déméruun. Féniro ro bero dob de katri brab dob de bénékah ikam inok buluk témara i Pedrowe, gébéla i anlung ne dob berowe. ");
INSERT INTO tiy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Atin énggumah soy médoowe étéw tidéw dob de kloh ingéd géliwét dob Jerusalem. Brab nuwit roy de déméruun bero brab de étéw rénahukoy de saitan. Atin kéluhana ro ménadi-adi. ");
INSERT INTO tiy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tidéw béno, i gérotore fadi brab de dumo no sani de Saduseo, méndaléw ro bé de apostol. Mélaw ménséfagayun ro bé rigoné ruwe. ");
INSERT INTO tiy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Atin kénéfo roy de apostol brab fénrisu ro bero. ");
INSERT INTO tiy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Endob bé béno kélungonon, nungka i télakiy Kadnaney de béngaway férisunone. Tidéw béno nuwitén bero mésut brab bénréhén mano, ");
INSERT INTO tiy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Taus gom dob lawi i Tuluse brab uret gom dob de étéw i fantage bé ni mantu umul.” ");
INSERT INTO tiy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tidéw béno, nodoroy de apostol i bénréh i télakiwe ni. Mélaw amun géfuwénén, ménahur ro dob lawi i Tuluse brab téménoro ro. Atin i gérotore fadi brab de dumo no, ténawag roy de odoroy de Judio inok sélimud i de kéfédéway de Judio. Tidéw béno, séménugu ro mangéy dob férisunone inok uwité roy de apostol mangéy dob adafa ruwe. ");
INSERT INTO tiy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Endob amun énggumah i de sénugu dob férisunone, énda énggito roy de apostol. Mélaw ménséfule ro mangéy dob de kéfédéwan do ménlimud brab nuret ro maro, ");
INSERT INTO tiy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Amun énggégumah gey dob férisunone, énggito gey i de béngawan do ménkandado brab diyo soy de guwardiya mantay dob liyuwe. Endob amun nungka gey, énda i énggito gey étéw dob rahure.” ");
INSERT INTO tiy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mélaw i de odoroy de fadi brab kafitane odoroy de guwardiya bé lawi i Tuluse, amun énggélingoo roy ni, toow ro fo ménggaif. Atin fégitungé roy ati énggérigonoy de apostol. ");
INSERT INTO tiy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tidéw béno, wén i énggégumahe ménlolok dob berowe mano, “I de lagéy do fénrisu gom, diyo ro témoro bé de étéw dob lawi i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mélaw ménangéy i kafitane dob lawi i Tuluse beroy de guwardiya no. Atin kénéfo roy de apostol brab nuwit ro séfule. Endob énda féndawéto ro bero non mégilak ro bé de étéw diyo ké ibéro ro bero batéw inok féléhué ro bero. ");
INSERT INTO tiy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nuwit roy de apostol mangéy dob adafay de ménlimud do odoron. Atin i gérotore fadi ménbéréh dob bero mano, ");
INSERT INTO tiy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Génlé geyén begom bé kagomén témoro fantag bé Jesuse, éndob énda nodoro kom de. Téngténg gom, ménlégébén dob Jerusaleme niy kétoro gome, atin bénréh gom, begey i ménméléhue bé Jesuse.” ");
INSERT INTO tiy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Endob séménumbul i Pedrowe brab de dumo no do apostol maro, “Fatut odoro key i Tuluse, békén étéw. ");
INSERT INTO tiy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Amun énggilid gomén fénléhu i Jesuse bé kékélabo gome de dob kruse, i Tulus i de katufua tom i ménfétébulee de. ");
INSERT INTO tiy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Atin féndiyat i Tuluse mangéy dob kuwono nuwe inok Been i Méguléwe brab Mémukase. Mélaw Been i émfésagade bé de sala tom do Judio amuk gésénule tom. ");
INSERT INTO tiy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Géureto key i de ni non énggito gey, loo soy Rémogor i Tuluse muret, sani Rémogore iray i Tuluse dob de étéw munur dob Beene.” ");
INSERT INTO tiy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Atin i de odoron ni ménlimud, amun énggélingoo roy ni, toow ro fo ménkérit brab ménuyot ro ké féléhuén i de apostol ni. ");
INSERT INTO tiy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Endob i ségétéwe bé de Fariseo féndawét Gamaliel téménindég dob kérara ruwe ménlimud. Beeney témoroe bé kitabe brab toow fo fégadatay de étéw. Atin fénfésutén i de apostol. ");
INSERT INTO tiy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tidéw béno ménbéréh mano, “Do dumo gu do Judio, ingata kom ké ati kérigo gome bé de ni do étéw. ");
INSERT INTO tiy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bé do gétah wén i ségétéwe étéw féndawét Teudas, ménbéréh been kun i toowe ménbantug gérotor étéw. Atin fot ratuh gétéw i ménwaléye kuyugén. Endob wén i ménméléhu de atin i de kuyugén ménbéragar ro brab énda i énggérigono ro. ");
INSERT INTO tiy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tidéw béno, dob de gaiy késinsuse bé émfélistay kéluhanay de étéw, énggumah man i ségétéwe étéw féndawét Judas tidéw Galilea. Atin médoo soy ménwaléye kuyugén. Endob amun fénléhu soy Judase, ménbéragar soy de kuyugén. ");
INSERT INTO tiy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ségiléw so keeyén bé kéléhu Jesuse. Mélaw béréhé ku begom, katom kémukum brab fédayaé tomén i de ni do étéw. Non amuk aturay kéilawane saén, énda soy gérigono ro brab énda i rugaya ro. ");
INSERT INTO tiy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Endob amuk aturay Tuluse, énda gégéléo tom bero, non waléy tom saén sébanil bé Tuluse.” Atin i de ménlimud do kéfédéwan, ménagayun ro bé bénréh Gamaliele ni. ");
INSERT INTO tiy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tidéw béno, fénahur ron man i de apostol brab féntafés ro bero. Atin génlé ron man bero bé békénén muret ro fantag bé Jesuse. Tidéw béno, ténangéy ro bero. ");
INSERT INTO tiy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","I de apostol amun ménsut ron tidéw dob de ménlimud do odoron, toow ro fo ménoror non kénarang i Tuluse médait ro kéfasangan brab kémalanan sabaf bé kéunur ruwe bé Jesu Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Atin sénga fuweh ménangéy ro dob lawi i Tuluse brab dob de lawi i de étéw. Atin diyo ro témoro bé Fiyowe Uret fantag bé Jesu Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Bé do no do gai, amun minutén médooy de munur bé Kristowe, wén i de tete kégébaa no bé de munur do Judio do sébéréh Griego dob de munur do Judio do sébéréh Hebreo. Ménbéréh i de Judio do sébéréh Griego bé émfédaya kun i de baléw bero, énda méirayan ro bé de kailanga ro sénga fuweh. ");
INSERT INTO tiy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mélaw i de folo bra ruwo gétéw do apostol ténimu roy kéluhanay de munur bé Kristowe brab bénréh ro dob berowe maro, “Enda fiyo no ké begey i sémaare bé de kailanga kom sénga fuweh, non fatut gey démoyun muret bé kébéréh i Tuluse, brab énda fatut diguré key i galbék geye. ");
INSERT INTO tiy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mélaw do dumo gey, fémili gom fitéw gétéw lagéy, do métilédtéd brab fémanduoy Rémogor i Tuluse. Atin iray gey beroy aturane bé de ni, ");
INSERT INTO tiy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","inok i begeye do apostol fakay gey démasal brab muret fantag bé Tuluse sénga tékélid.” ");
INSERT INTO tiy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Atin ménagayun i kéluhana ruwe bé bénréh i de apostol ni. Mélaw fénémili roy Estebane, ségétéw méégét i kéunur ne brab fémanduoy Rémogor i Tuluse. Fénémili ro soy ro Filipihe, Prokoro, Nikanor, Timon, Parmenas, brab Nikolas tidéw Antiokia ségétéw békén Judio, éndob ménrugayén i kéunur ne bé kukumay de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Atin nuwit ro bero mangéy dob de apostol. Tidéw béno, ténégéy de apostol i de bumbuna ro bé kédasala ruwe bero inok tabangay Tuluse bero bé mantuwe ni aturan. ");
INSERT INTO tiy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Atin mélaw ménlégébén i urete fantag bé Tuluse. Atin minut médooy munure bé Kristowe dob Jerusalem. Atin médoonén i de fadi méganay so munur. ");
INSERT INTO tiy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Atin i Estebane toow fo fénfiyoy Tuluse inok wén i barakatén rémigo do mékégaif dob téngaangay de étéw. ");
INSERT INTO tiy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Endob wén i de étéw ménsébanil bé Estebane. Beroy de étéw dob simbaane féndawét “Méntangéy étéw”. I de dumo bero do Judio tidéw Siren, brab tidéw Alejandria, I de ni do étéw beroy de dumoy de Judio tidéw. Silika brab Asia, méngganay ro séédél bé Estebane. ");
INSERT INTO tiy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Endob toow fo fénggétigay Rémogor i Tulusey Estebane émbéréh. Mélaw énda i ségétéw gésumbul bero. ");
INSERT INTO tiy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mélaw niraya ro kurta i de étéw inok béréhé roy éndae toow fantag bé Estebane maro, “Enggélingoo key i ni étéw ménbéréh tete fantag bé Moisese brab Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mélaw fénkérit roy de étéw brab de odoroy de Judio brab de témoro kitab. Atin kénéfo roy Estebane brab nuwit ro dob adafay de ménlimud do kéfédéwan. ");
INSERT INTO tiy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tidéw béno, nuwit roy de étéw émbéréh bé éndae toow fantag bé Estebane maro, “I Estebane ni démoyun émbéréh tete fantag bé mékétéfuwe lawi i Tuluse brab de kukuman sénulat Moisese. ");
INSERT INTO tiy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Enggélingoo key bénréhén bé i Jesuse tidéw Nasaret, gébaé no kun i lawi i Tuluse brab fégaliné noy adate énggéféganada tom tidéw dob Moisese.” ");
INSERT INTO tiy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tidéw béno, ténéngténg i kéluhanay de odoron i Estebane. Atin énggito roy rangih ne maak falas télaki. ");
INSERT INTO tiy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mélaw i gérotore fadi fénénginsaa noy Estebane mano, “Aw toow i de ni?” ");
INSERT INTO tiy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Atin séménumbul i Estebane mano, “Do dumo gu brab do lukés gu, fégélingo gom i béréhé kuwe ni. I toowe fo ménbantug barakatan Tulus méntéfégito dob katufua tome Abraham amun bati de séna dob Mesopotamia, bé énda séna ménagéwén de mangéy Haran. ");
INSERT INTO tiy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Atin bénréhén de mano, ‘Tagakém i de samungém brab ingéd me atin agéw go mangéy dob gonone toroé ku beem.’ ");
INSERT INTO tiy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mélaw ténagakén i ingéd ne Kaldeo brab ménagéw mangéy Haran, atin diyo ménbati. Atin amun ménléhu i boh Abrahame, fénagéw i Tuluse man mangéy dob ni ingéd gono kom bati béleewe ni. ");
INSERT INTO tiy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Bé do no do gai, énda nirayay Tulusey Abrahame fantad fiyon kloh. Endob fénasad i Tuluse dob Abrahame bé irayén dey ni fantad brab dob de séfuén témundug de, fiyon fo ké énda sénay nga Abrahame de. ");
INSERT INTO tiy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ay niy bénréh i Tuluse bé Abrahame mano, ‘I de séfuém bati ro dob ségiyowe ingéd toow fo mérayu atin waléy ro do rifén diyo. Atin mérasay ro taman fot ratuh gébélintuwa. ");
INSERT INTO tiy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Endob kukumé kuy de étéw rémifén bero. Atin i de séfuém tékédan ro dob nan ingéd atin féngadafé ro Begén dob ni gonon.’ Been i niy bénréh i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Atin féntaus Estebaney kébéréh ne mano, “Tidéw béno, sénugu i Tuluse dob Abrahamey ni adat sani kétulie inok wén i tanda bé ni fasad. Mélaw ténuli Abrahamey nga ne Isak amun ménwaléwén gétérésangan ménumah. Atin i Isake ténulién soy nga ne Jakob. Atin i Jakobe ténulién soy de folo bra ruwo gétéw ngaén. Atin beroy de katufua tom do Judio. ");
INSERT INTO tiy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Endob i de nga Jakob méndaléw ro bé tuwaréy ruwe féndawét Jose. Mélaw fénbéléy ro atin ménwaléy rifén dob ingéde Egipto. Endob Tulus i dumo nuwe. ");
INSERT INTO tiy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Atin ténabangay Tuluse inok énda i sug-sugén fiyon fo ké médooy kérégénone. Atin amun diyo i Josehe dob adafay datue dob Egipto, fénfiyoy Tuluse brab niraya no kégétuwan. Mélaw ménuyot i datue de. Tidéw béno fénwaléy i datuey Josehe odoron dob no ingéd brab beene soy odorone dob lawi i datue ni. ");
INSERT INTO tiy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tidéw béno, énggumah i dakéle lénggob dob ingéde Egipto brab dob Kanaan. Atin toow ro fo ménrasay. Atin i de katufua tom énda i amaé ro. ");
INSERT INTO tiy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mélaw amun énggélingoo Jakobe wén i faréy dob Egipto, sénuguén i de ngaén, sani de katufua tom mangéy diyo bé gésungu nuwe. ");
INSERT INTO tiy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dob géruwo nuwe gule ménangéy ro diyo, méntéfégéloloy Josehe dob de dumo no sétiman boh. Atin énggétuway datuey fantage bé de samung Jose. ");
INSERT INTO tiy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mélaw fénsamfay Josehey kébéréh ne bé féangéyén i boh ne Jakob brab kéluhanay de samungén. Atin fitéw ro folo bra limo kéluhanan. ");
INSERT INTO tiy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tidéw béno, ménagéw i ro Jakobe mangéy Egipto. Atin diyo ménléhu loo soy de ségiyo katufua tom. ");
INSERT INTO tiy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Atin nuwit i de bangkay ro mangéy Sekem, atin lénébéng ro dob lébéngone bénléy Abrahame dob de étéw Hamor.” ");
INSERT INTO tiy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Atin féntaus Estebaney kébéréh ne mano, “Amun gédétén i gaiwe métuman i fasad i Tuluse dob Abrahame, toowén fo médooy de Judio dob Egipto. ");
INSERT INTO tiy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Atin bé béno, ségiyonén i datue dob Egipto, atin énda énggétiga noy fantage bé Josehe. ");
INSERT INTO tiy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Enda fo fiyoy ni datu. Fénggakara noy de katufua tom. Atin fénrasayén fo bero toow. Non fénégésén i de katufua tom bé ibéré roy de nga ro inok méléhu. ");
INSERT INTO tiy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Atin bé no do gai, ménumah i Moisese, toow fo fiyo nga. Rénitoy idéng ne sungu dob lawi ruwe taman téléw gétérésang kélungonon. ");
INSERT INTO tiy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Amun fénliyu roy ngae dob lawie, éndot i libune nga i datue dob Egipto. Atin fénagifatén maak kaan so nga. ");
INSERT INTO tiy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mélaw méntoro i Moisese bé kéluhanay kégétuwane dob Egipto. Atin ménwaléy énggétigan étéw dob de kébéréhén brab dob de rigoné no. ");
INSERT INTO tiy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Amun fotén folo gébélintuwa i Moisese, ménuyot témukaw bé de dumo no do Judio. ");
INSERT INTO tiy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Atin amun énggumah dob de dumo no, énggito noy kédusay ségétéwe tidéw Egipto bé dumo nuwe Judio. Mélaw ténabangén i dumo nuwe ni Judio brab séménuli fénléhuén i étéwe tidéw Egipto. ");
INSERT INTO tiy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Brab mano ké i de dumo no do Judio énggésobuto roy been i usaréy Tuluse témabang bero inok métangéy ro. Endob énda énggésobuto ro de. ");
INSERT INTO tiy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bé gétunduge de fuweh, énggito noy ruwowe gétéw Judio sétiboh. Atin génléén bero mano, ‘Kagom sétiboh! Ségiléw gom falan Judio.’ ");
INSERT INTO tiy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Endob i ségétéwe de férasayé noy dumo nuwe ni, dénrién i Moisese brab ménbéréh mano, ‘Békén beem i odoro keye taloo no kéfédéwa key. ");
INSERT INTO tiy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aw méuyot go méméléhu begén loo bé kéféléhu me bé ségétéwe tidéw Egipto natémégéno?’ ");
INSERT INTO tiy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Amun énggélingoo Moisesey ni, ménraréy tidéw Egipto brab ménangéy bati dob ingéde féndawét Madian. Atin diyo énggébawag brab wén i ngaén ruwo gétéw lagéy.” ");
INSERT INTO tiy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Atin féntaus Estebaney kébéréh ne mano, “Amun ménifus i fote folo gébélintuwa, méntéfégito dob Moisesey télakiwe dob mérinoe kayéw dob gonone énda i étéw de bati, gédét dob tuduke féndawét Sinai. ");
INSERT INTO tiy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Toow fo ménggaif i Moisese bé ni énggito no. Atin amun ménfégédét inok gito no fo toow, énggélingoo noy béréh i Kadnane mano, ");
INSERT INTO tiy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Begéney Tuluse fénéngadaf i de katufua kom, ro Abraham, Isak, brab Jakob.’ Atin i Moisese léménukub bé kégilak ne brab éndaén géténgténgo no de. ");
INSERT INTO tiy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Atin ménbéréh man i Kadnane mano, ‘Kéda moy sinilas me non i gono muwe témindég mékétéfu fantad. ");
INSERT INTO tiy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Enggito guy kéférasaye bé de étéw gu dob Egipto. Brab énggélingoo kuy de dogés ro. Mélaw ménlusu inok fétangéy gu bero. Atin béleewe, sugué ku beem magéw mangéy Egipto.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Atin féntaus Estebaney kébéréh ne mano, “Nikaay de dumo no Judioy Moisese bé kébéréh ruwe maro, ‘Békén beem i odoro key taloo no kéfédéwa key!’ Endob beeney sénugu i Tuluse méguléw bero brab émfétangéye bero. Atin i télakiwe méntéfégito dob beene dob mérinoe kayéw i téménabangane de. ");
INSERT INTO tiy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Atin fénanangguwitén i de étéw mésut tidéw Egipto. Rénigo noy de mékégaif dob Egipto brab dob dogote féndawét ‘Furo Dogot’ brab dob gonone énda i bati diyo amun ménagéw ro diyo bé fote folo gébélintuwa. ");
INSERT INTO tiy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Atin i Moisesey ménbéréh dob de Judio mano, ‘Emféuwit i Tuluse mangéy dob begome ségétéw sarigo no muret bé kébéréh ne ségiléw bé kéféuwit ne begén. Been soy ségétéwe bé de séfu Israele.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Atin féntaus Estebaney kébéréh ne mano, “Moisesey dumoy de Judio ménsélimud dob gonone énda i ségétéw étéw bati diyo, bero soy de katufua tom brab télakiwe ménsébéréh de dob tuduke Sinai. Brab beeney énggégédote bé kébéréh i Tuluse inok irayén so dob betome. I kébéréh i Tuluse ni énda mékéda no taman sa taman. ");
INSERT INTO tiy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Endob i de katufua tom énda ménodor ro bé de sugu Moises. Yamula ménika ro de brab ménuyot ro séfule mangéy Egipto. ");
INSERT INTO tiy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mélaw bénréh ro dob Arone sani ofo Moisese maro, ‘Rigo go do kéninontow inok wén i féngadafé key, brab inok wén i manangguwit betom. Non énda gétiga key ké ati énggérigono Moisese sani ménanangguwite betom tidéw Egipto.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Atin féntaus Estebaney kébéréh ne mano, “Bé no do gai réménigo ro kéninontow maak falas nati safi. Atin téménulak ro dob adafa nuwe brab kénandulio ro inok fégito roy kéoror ruwe bé ni rénigo ro. ");
INSERT INTO tiy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Endob sabaf bé ni, ténagak i Tuluse bero brab féndayaén bero méngadaf bé de gitoon dob lawayo loo bé sénulat i sénarigoy Tuluse féndawét Amos mano, ‘Do étéw Judio, békén Begén i ténulaka kome dob gonone énda i ségétéw de bati bé lala i kédiyo gome bé ménfote folo gébélintuwa. Yamula ségiyoy fénéngadaf gome. ");
INSERT INTO tiy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Non nuwit gom i batioy sébaane tulus féndawét Molok brab sébaane kéninontow maak gitoon tulus féndawét Renfan. Do kéninontow i fénéngadaf gome, mélaw féangeyé ku begom fingé na diyo bé ingéde Babilonia.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Atin féntaus Estebaney kébéréh ne mano, “I de katufua tom wénén i ginise lawi sani tandae énda tagakéy Tuluse bero. Nuwit ro amun ménagéw ro dob gonone énda i étéw de bati. Rénigo roy ni loo bé bénréh i Tuluse bé Moisese, ségiléw bé fénggitoy Tuluse de. ");
INSERT INTO tiy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Amun ménifus i firoye gébélintuwa, i de katufua tom énggédot roy ni tidéw dob de lukés ro. Atin i de katufua tom nuwit ro dob de ingéd ténaba ro bé gaiy kédédél i Tuluse bé de étéw mésut dob do no gonon inok wén i batioy de Judio. Atin i odoro ruwey lagéye féndawét Josue. Atin fénbati roy lawi i Tuluse diyo taman bé gai Datu Dabide. ");
INSERT INTO tiy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Toow fo ménsuwat i Tuluse bé Dabide. Atin nongotén dob Tuluse inok tungkasé no rémigo bé lawi i Tuluse, sani Tuluse fénéngadaf Jakobe. ");
INSERT INTO tiy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Endob i nga Datu Dabide féndawét Solomon i réménigowe bé nan lawi. ");
INSERT INTO tiy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Endob béréhé ku begom, i toowe fo gérotor Tulus énda batién dob de lawi rénigoy kéilawane. Non bénréh i ségétéwe sénarigoy Tuluse féndawét Isias mano, ");
INSERT INTO tiy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bang i Tuluse, laway i sara kuwe, atin i duniyaey ténaa kuwe bé de sékéy gu. Enda i lawi gérigono kom inok batio ku taloo no téréno ku. ");
INSERT INTO tiy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Békén ba Begén i réménigowe bé kéluhanay éntingayéne?’ ” ");
INSERT INTO tiy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Atin féntaus Estebaney kébéréh ne mano, “Toow fo métégas i de uléw gom! Enda séna fo ménfégalin i de fédéw gom loo bé kétayay Tuluse. Brab toow gom fo do énda mégélingo bé kébéréh i Tuluse. Ségiléw gom so bé de katufua kom non atuho kom i Rémogor i Tuluse sénga tékélid. ");
INSERT INTO tiy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I de katufua kom fénrasay roy kéluhanay de sénarigoy Tuluse muret bé kébéréh ne bé do gétah. Fénléhu roy de sénugu i Tuluse muret fantag bé Kristowe sani métintuwe fo Sugu-suguéy Tuluse. Atin i begome, kénéfo gom brab fénléhu gom i Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Enggétanggafa kom i de kukuman féniray i Tuluse bé de télaki, éndob énda nodoro kom de.” Been i niy bénréh Estebane. ");
INSERT INTO tiy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Amun énggélingooy de odoron i kébéréh Estebane, toow ro fo ménkérit. Kémigét i de kifé ro bé kékérit ruwe. ");
INSERT INTO tiy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Endob i Estebane toow fo fénémanduoy Rémogor i Tuluse, brab léménéngag dob lawayo, atin énggito noy kéréndaw i Tuluse brab énggito noy Jesuse témindég dob kuwonoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Atin ménbéréh i Estebane mano, “Téngténg gom! Enggito guy lawayo ménungka, brab i Nga i Kéilawane témindég fingé dob kuwonoy Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Toow fo ménkérit i de odoron ni, mélaw néféng roy de kélingo ro brab ménékes ro. Atin sénréngana roy magayase de gémamak. ");
INSERT INTO tiy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Atin séngguyud ro mésut dob ingéde ni brab nibéro ro batéw. Atin i de témébo de, kénda roy de géruwo lafin bé de kégal ro, atin fénled ro dob kénogo lagéye féndawét Saulo. ");
INSERT INTO tiy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Atin i lala ruwe mibéron batéw bé Estebane, déménasal dob Kadnane mano, “O Kadnan Jesus, tanggafém i rémogor guwe!” ");
INSERT INTO tiy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Atin ménlingkuwéd brab ménbéréh métanug mano, “Kadnan, fésagadém i ni sala ro.” Sonom béno, ménléhu. ");
INSERT INTO tiy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Atin i Saulowe ménagayun bé kéféléhue bé Estebane. Atin i Estebane, lénébéng i de étéw munur bé Kristowe brab toow fo rénuung ro. Atin méntidéwén bé no térésang i kékérasayay de munur bé Kristowe. Brab kéluhana ro, saliyu bé de apostol, ménbéragar ro tidéw Jerusalem mangéy Judia brab Samaria. ");
INSERT INTO tiy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Atin i Saulowe ténulama no binasanén i kéféngintulus i de munur bé Kristowe, ahuro noy séngae lawi brab kéfoé no séguyudén i de étéw munur bé Kristowe. Brab uwité no bero dob férisunone, do lagéy brab do libun. ");
INSERT INTO tiy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Atin amun ménbéragar i de étéw munur bé Kristowe dob de ségiyo ingéd, nuret roy fantage bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Atin i Filipiwe ménangéy dob sébaane ingéd diyo dob Samaria, atin diyo nuretén i Jesuse Been i Kristowe sani fénémili i Tuluse méguléw. ");
INSERT INTO tiy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","I de étéw, amun énggélingoo roy kébéréh ne brab énggito roy kéluhanay de mékégaif rénigo no, toow fo fénggélingo roy kébéréh Filipihe. ");
INSERT INTO tiy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Fénféraréyén i de saitan réménahuk dob de médoo étéw, atin ménékes ro bé lala ruwe tékédan. Brab fén-adi-adi noy médoowe do fikat brab do kimoyén. ");
INSERT INTO tiy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mélaw toow fo ménoror i de étéw dob no ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wén i ségétéwe lagéy dob no ingéd féndawét Simon, ségétéw béliyan. Bé de énggétah do gai, fénggaifén i médoowe do étéw dob Samaria bé de tete kéfagakarén. Ménfébantug-bantug bé beene kun i gérotore étéw. ");
INSERT INTO tiy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Atin i kéluhanay de étéw dob no ingéd do méskinan brab do kawasa, fénggélingo ro. Bénréh ro maro “I ni étéw féndawét Ménbantug Barakatan, sani barakat i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ménrugay i kéfégaif ne bero bé de tete kéfagakarén. Mélaw toow ro fo fénggélingo. ");
INSERT INTO tiy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Endob amun énggélingooy de étéw i Fiyowe Uret nuret Filipiwe fantag bé kéféguléw i Tuluse brab Jesu Kristowe, ménunur ro brab ménfébautis ro, do lagéy brab do libun. ");
INSERT INTO tiy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Atin fiyon i Simone ménunur so bé Kristowe. Brab amun ménbautisén, démoyun ménodor bé Filipiwe. Atin toow fo ménggaif i Simone bé de énggito no rénigo Filipiwe. ");
INSERT INTO tiy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Amun énggélingooy de apostol dob Jerusalem i kétayakuf i de étéw dob Samaria bé kébéréh i Tuluse, fénuwit roy ro Pedrowe brab Juane mangéy diyo. ");
INSERT INTO tiy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Amun énggégumah ro diyo, dénasala roy de étéw munur bé Kristowe inok tayakufé roy Rémogor i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Non i Rémogor i Tuluse, énda séna énggumahén dob berowe fiyon ségétéw. Ménbautison ro saén inok fégito roy kéunur ruwe bé Kadnane Jesus. ");
INSERT INTO tiy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tidéw béno, ténégé Pedrowe brab Juaney de bumbuna ro. Atin ténanggaf roy Rémogor i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Atin énggitoy béliyane ni Simon i kétanggaf ruwe bé Rémogor i Tuluse bé kétégéy de apostol bero. Mélaw bénréhén dob Pedrowe brab Juane bé iraya no bero kurta. ");
INSERT INTO tiy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Brab bénréhén mano, “Irayanu so bé ni barakat inok amuk wén i tégéné ku, gétanggaf so bé Rémogor i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Endob séménumbul i Pedrowe mano, “Mékukum go damén begom i kurta me, non mamo ké gébéléyo mo bé kurtaey niray i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Enda fakay go mamung bé galbék geye non énda séna métintuy fédéw me dob adafay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fatut go gésénule bé ni tete kéfégitungém brab dasal go dob Kadnane inok fésagada no beem bé ni salaém. ");
INSERT INTO tiy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Non énggito guy toow fo mésina go brab bénilanggu i salae beem.” ");
INSERT INTO tiy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tidéw béno, séménumbul i Simone mano, “Dasala kom begén dob Kadnane inok énda i métuman damén bé de bénréh gom dob begéne.” ");
INSERT INTO tiy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Atin i ro Pedrowe brab Juane, amun énggilid ron muret bé gétiga ruwe fantag bé Kristowe, brab bénréh roy kébéréh i Kadnane, ménséfule ro mangéy Jerusalem. Bé késéfule ruwe, ménawét ro dob médoowe do ingéd dob Samaria brab nuret roy Fiyowe Uret diyo. ");
INSERT INTO tiy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Atin i Filipihe, sénugu i télakiy Kadnane mano, “Tafay go brab angéy go déligdigan dob agéwone tidéw Jerusalem mangéy Gasa.” (I ni agéwon éndaén i étéw de magéwon.) ");
INSERT INTO tiy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mélaw ménangéy diyo i Filipihe. Tidéw béno, énggébalaka noy ségétéwe lagéy kafun sarigoy baiwe dob ingéde Etiopia. Beeney ségétéwe gérotor étéw mitong bé kurtae dob no ingéd. I ni étéw séfule bé béno bé kéagéw ne ménangéy méngadaf dob Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Diyo dob kalesah ne brab basané noy librowe sénulat i méntélatae sénarigoy Tuluse féndawét Isaias. ");
INSERT INTO tiy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Atin bénréh i Rémogor i Tuluse dob Filipihe mano, “Ay go fégédét diyo brab odor go bé nan kalesah.” ");
INSERT INTO tiy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mélaw i Filipihe ménségéta mangéy fégédét brab énggélingoo noy kébasa nuwe bé librowe sénulat Isaiase. Atin fénénginsaa Filipihe mano, “Aw gésobuto moy nan basané mo?” ");
INSERT INTO tiy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Séménumbul i ni sarigon mano, “Ati kégésobut guwe de ké énda i témoro de begén?” Tidéw béno, féndaén i Filipihe dob kalesah ne atin ménséfingé ro ménsar. ");
INSERT INTO tiy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ay niy ménsulate dob libro Isaiase, bénasa no, “Beeney maake bili-bili fénléhu. Beeney maake nati bili-bili mantés ké kéléngén i buk ne, non énda fo ménbéréhén fiyon sétaga. ");
INSERT INTO tiy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Toow fo ménfémala brab énda méntintuy kékukume de. Atin énda i gébéréh fantag bé de séfuén non ménléhuén brab éndaén dini ro dob duniyae ni.” ");
INSERT INTO tiy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Atin ménénginsa i ni sarigon dob Filipihe mano, “Ati ni étéw ménsulat dob ni? Aw bénréh i sarigoy Tulusey fantage bé kaane lowoh taloo no ségiyo étéw?” ");
INSERT INTO tiy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tidéw béno, fénggétiga Filipihe dob beeney atag ni bénasa no brab nuretén i Fiyowe Uret fantag bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Atin amun diyo ro séna lowoh aguwon, énggumah ro dob gonone wén i wayég de. Atin ménbéréh i ni odoron mano, “Ay wén i wayég dob ni. Aw fakayu mébautis?” ");
INSERT INTO tiy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Séménumbul i Filipihe mano, “Fakay bautisé ku beem amuk tintu gon munur bé Kristowe dob fédéw me.” Atin séménumbul i ni sarigon mano, “Munuru bé Jesu Kristowe, bé Beeney Nga i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Atin i ni sarigon féntéré noy kalesah ne brab ménlus bero Filipihe ménangéy dob wayége atin bénautis Filipihe. ");
INSERT INTO tiy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Amun géménaun ron tidéw dob wayége ni, nuwit i Rémogor i Kadnaney Filipihe. Endaén énggitoy sarigone niy Filipihe, éndob méntaus magéw toow fo moror. ");
INSERT INTO tiy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Atin i Filipihe méntékow énggégumah dob sébaane ingéd féndawét Asdod. Atin tidéw diyo ménuret bé Fiyowe Uret fantag bé Jesuse dob kéluhanay de ingéd énggétaraa no bé kéagéw ne mangéy dob ingéde féndawét Sesaria. ");
INSERT INTO tiy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Atin i Saulowe bé do no do gai, féntausén soy kérigo nuwe bé de kuyug i Kadnane. Non ménbéréh féléhué no kun bero. Atin ménangéy dob gérotore fadi, ");
INSERT INTO tiy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","brab ménongot sulat dob beene mangéy dob de odoroy de Judio dob de lawi féngadafa ro dob ingéde Damasko inok kéfoé noy kéluhanay étéwe gito no diyo do modor dob Agéwo Jesuse brab uwité no bero mangéy Jerusalem, do lagéy brab do libun. ");
INSERT INTO tiy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Atin ménagéw i Saulowe mangéy Damasko. Amun gédétén dob no ingéd, méntékow wén i réndaw tidéw dob lawayo géliwét de. ");
INSERT INTO tiy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Atin ménggétéléngkéb i Saulowe dob fantade brab énggélingoo noy émbéréhe mano, “Saulo! Sedek férasayé mo Begén?” ");
INSERT INTO tiy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ménénginsa i Saulowe mano, “Ati Beeme, Kadnan?” Atin séménumbul mano, “Begéney Jesuse férasayé mo. ");
INSERT INTO tiy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tindég go brab taus go mangéy Damasko, atin diyo wén i étéwe béréhé no beem i fatute rigoné mo.” ");
INSERT INTO tiy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Atin i de étéw dumo Saulowe magéw, téménrén ro. Ménantés ro non énggélingoo roy émbéréhe ni éndob énda gito ro de. ");
INSERT INTO tiy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Atin i Saulowe téménindég brab bénékahén i de moto no, éndob énda gégito no. Mélaw narak i de dumo no taman Damasko. ");
INSERT INTO tiy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Atin méntéléw gétérésangan énda gégito no, brab énda ménamaén taloo no méniném. ");
INSERT INTO tiy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Atin diyo dob Damasko wén i ségétéwe kuyug Jesuse féndawét Ananias. Atin wén i fénggitoy Tuluse dob beene non ténawag i Kadnane mano, “Ananias!” Séménumbul mano, “Ay niwu so Kadnan.” ");
INSERT INTO tiy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Atin ménbéréh i Kadnane mano, “Angéy go dob agéwone féndawét ‘Mééntang’ brab taus go dob lawi Judase brab fénginsaém diyo i lagéye féndawét Saulo tidéw Tarsus. Démasal sénay ni étéw béni. ");
INSERT INTO tiy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Brab wén i fénggitoy Kadnane, brab dob ni énggito noy ségétéwe lagéy féndawét Ananias énggumah dob beene brab ténégé no inok gégito man.” ");
INSERT INTO tiy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Séménumbul i Ananiase mano, “Kadnan, énggélingoo kuy uret i médoowe étéw fantag bé ni lagéy, brab kéluhanay tetee rénigo no dob de kuyugém dob Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Atin ménangéy dini dob Damaskowe ni non wén i kuwagibe tidéw dob de odoroy de fadi inok kéfoé noy kéluhanay munure Beem brab de lémabit bé dawét me ké démasal ro.” ");
INSERT INTO tiy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Endob ménbéréh i Kadnane mano, “Angéy go diyo non fénémili guy ni étéw inok waléy sugu-sugué ku muret fantag bé Begéne dob de étéw békén Judio brab dob de datu brab dob de Judio so. ");
INSERT INTO tiy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Brab fégétiga ku dob beene bé waléy so toow fo mérasay sabaf bé kéunur ne Begén.” ");
INSERT INTO tiy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mélaw ménagéw i Ananiase mangéy diyo. Amun énggégumah dob lawie ménahur so brab ténégé noy Saulowe ni. Atin bénréhén de mano, “Saulo, dumo gu, sénugu i Kadnane begén mangéy dob beeme. Beeney Jesuse sani méntéfégitowe dob beeme dob aguwone bé kéangéy me dini. Sénuguén begén inok waléy go man gégito brab fémanduoy Rémogor i Tuluse beem.” ");
INSERT INTO tiy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sonom béno, i de maak éner ménlawu tidéw dob de moto Saulo brab énggégito. Atin ménagayas témindég brab ménfébautis. ");
INSERT INTO tiy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Amun énggilid mama, ménséfule i kébagér ne. Atin ménbati i Saulowe dob de kuyug Jesus dob Damasko bé ménfiroye gétérésangan. ");
INSERT INTO tiy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Atin i Saulowe ménagayas ménahur dob de lawi féngadafay de Judio brab nuretén i fantage bé Jesuse. Bénréhén mano, “I Jesuse ni, Beeney Nga i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Atin i kéluhanay de énggégélingo de toow ro fo ménggaif brab ménséfénginsa ro maro, “Aw békén ba beeney étéwe tidéw Jerusalem méméléhu bé de munur bé Jesuse? Aw békén ba ménangéy dini inok kéfoé noy de kuyug Jesus, inok uwité no mangéy dob odoroy de fadi dob Jerusalem?” ");
INSERT INTO tiy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Endob ménwaléy toow fo émbagér muret i Saulowe brab fénggétiga no dob de Judio dob Damasko i Jesuse, Been i Kristowe, sani méguléwe tidéw dob Tuluse ongot-ongoté ro. Atin énda i énggésumbul bero. ");
INSERT INTO tiy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Amun ménifus i firoye gétérésangan, i de Judio ménsélimud ro atin ménséfagayun ro bé féléhué roy Saulowe. ");
INSERT INTO tiy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Fuweh na kélungonon i kébantaya ruwe de dob de béngaway ni ingéd inok féléhué ro. Endob wén i ménlolok dob Saulowe fantag bé ni rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mélaw wén i no kélungonon, i de kuyugén nuwit roy Saulowe dob gérotore diding fénggédiding bé ni ingéd. Atin nahur ro dob dakéle biton brab ténuntu ro mangéy fingé bala dob faliluwangay didinge ni. ");
INSERT INTO tiy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Atin ménule i Saulowe mangéy Jerusalem brab téménlama magiyamongan bé de kuyug Jesus. Endob mégilak ro de brab énda munur ro de ké ménwaléyén kuyug Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tidéw béno, i Bernabewe nuwitén i Saulowe mangéy dob de apostol. Atin i Bernabewe nuretén dob berowey kétéfégitoy Kadnane brab késébéréh ne dob Saulowe dob aguwone. Atin bénréh Bernabewe soy kébaraw Saulowe muret fantag bé Jesuse dob Damasko. ");
INSERT INTO tiy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mélaw i Saulowe ménbati dob berowe dob Jerusalem. Brab séménugud muret fantag bé Kadnane dob kéluhanay de gonon dob Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Atin ménsébéréh brab ménséédél bé de Judio do sébéréh Griego. Mélaw ténlama ro féléhuén i Saulowe. ");
INSERT INTO tiy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Amun énggétigay de dumo no munur bé Jesuse, dénura ro mangéy Sesaria brab fénule ro mangéy Tarsus. ");
INSERT INTO tiy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Atin bé do no gai, énda ménrasay i de munur bé Kristowe dob Judea brab dob Galilea brab dob Samaria. Ménwaléy ro do méégét munur brab méninut ro médoo non ténabangay Rémogor i Tuluse bero, non toow fo féngadafé roy Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Atin i Pedrowe, démoyun ménagéw mangéy dob de médoo do ingéd. Amun nangeyén ténukaw i de dumo no munur bé Kristowe dob Lida, ");
INSERT INTO tiy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","diyo énggébalaka noy ségétéwe lagéy féndawét Eneas. I Enease ni kimoyén brab ménwaléwén gébélintuwa i éndae kégétekén. ");
INSERT INTO tiy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Atin ménbéréh i Pedrowe dob beene mano, “Eneas, uwaé Jesu Kristowe beem. Tek go brab dili moy iroo muwa nan!” Sonom béno énggétek i Enease ni. ");
INSERT INTO tiy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Enggitoy kéluhanay de étéw dob Lida brab dob Saron i ni lagéy ménadi-adi. Mélaw ménunur ro bé Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Atin diyo dob Jopa, wén i ségétéwe libun munur so bé Kristowe féndawét Tabita. (Taloo no Dorkas dob késébéréhe Griego. Atin i atag ne “séladéng”.) Sénga tékélid rémigo fiyo dob de méskinan, brab tabanga no bero. ");
INSERT INTO tiy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bé do no gai, ménwaléy déméruun brab ménléhu. Mélaw i de dumo no, nurah roy bangkay ne brab féndiyo ro dob sibéye dob rotor i lawie. ");
INSERT INTO tiy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Enda mérayu i ingéde Jopa dob ingéde Lida. Mélaw i de kuyug Jesus dob Jopa, amun énggélingoo ro diyo i Pedrowe dob Lida, séménugu ro ruwo gétéw lagéy mangey diyo inok béréhé ro dob Pedrowe bé magayas mangéy dob berowe. ");
INSERT INTO tiy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mélaw ménodor i Pedrowe bero. Amun énggumah ron, nuwit roy Pedrowe mangéy dob sibéye dob rotor i lawie. Atin i kéluhanay de libun do baléw ménfégédét ro dob Pedrowe, kémérew ro brab fénggito roy de kégal rénigo Dorkase bé kéuyag ne séna. ");
INSERT INTO tiy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tidéw béno, fénsut Pedrowe bero dob sibéye atin ménlingkuwéd démasal. Tidéw béno, sénaréwén i bangkaye brab ménbéréh mano, “Tabita, tek go!” Tidéw béno, bénékahén i de moto no brab amun énggito noy Pedrowe, méntek. ");
INSERT INTO tiy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Atin i Pedrowe, génamakén i de kémérén brab féntindégén. Tidéw béno, ténawagén i kéluhanay de munur bé Kristowe brab de libun do baléw, atin fénggito no beroy Dorkase ménuyag. ");
INSERT INTO tiy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Atin i urete fantag bé ni ménlégéb dob ingéde Jopa. Mélaw ménwaléy médooy ménunure bé Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Atin ménrugay i Pedrowe dob Jopa. Ménbati dob lawi i ségétéwe lagéy gémalbék léminis do kulit safi féndawét Simon. ");
INSERT INTO tiy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dob Sesaria, wén i ségétéwe lagéy féndawét Kornelio. Beeney kafitay de sundalo tidéw Roma sani de sundalo féndawét ro “Do tidéw Italiana”. ");
INSERT INTO tiy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I ni kafitan toow fo méngintulus, loo soy kéluhanay de dumo no dob kaane kuréngon. Démoyun miray tabang dob de Judio do méskinan. Brab sénga tékélid démasal dob Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wén i no sébaan fuweh, géraraan lémudug i térésange de, wén i fénggitoy Tuluse dob beene. Tintu fo énggito noy télakiy Tuluse ménahur dob lawi ne. Atin ténawag i télakiwe ni mano, “Kornelio!” ");
INSERT INTO tiy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Atin ténéngténgén i télakiwe ni brab toow fo ménggilak. Atin séménumbul mano, “Ati no?” Atin ménbéréh i télakiwe ni mano, “Mésuwat i Tuluse bé kégédaw me bé de fiyo rénigo mo brab kédasal me. Atin énggétédémo no beem. ");
INSERT INTO tiy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Béleewe ni, sugu go do étéw mangéy Jopa inok angéyé roy ségétéwe lagéy féndawét Simon Pedro. ");
INSERT INTO tiy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Diyo bati dob lawi i lagéye gémalbék léminis do kulit safi féndawét so Simon. I ni lawi gédét dob dogote.” ");
INSERT INTO tiy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tidéw béno, méntékédan i télakiwe ni. Atin i Korneliowe ténawagén i ruwowe gétéw bé de sugu-sugué no, brab ségétéwe bé de sundalo no toow fo méngintulus. Beene soy ségétéwe bé de sarigo no. ");
INSERT INTO tiy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Atin bénréhén beroy ni ménrigo. Tidéw béno, sénuguén bero mangéy dob ingéde Jopa. ");
INSERT INTO tiy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Dob gétunduge de fuweh, amun gédét ron dob Jopa, i Pedrowe ménénik dob datare atéf i lawie batio no brab déménasal. Géutuhén bé béno. ");
INSERT INTO tiy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Atin toowén fo mélayaf brab ménuyot fo mama. Endob i lala i de étéw dob nan lawi témafay séna bé amaé ruwe, wén i fénggitoy Tuluse dob Pedrowe ni. ");
INSERT INTO tiy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Enggito noy lawaye ménungka brab wén i maake dakél safut térimféna mangéy fantad ténutun fot i sugud ne. ");
INSERT INTO tiy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Diyo ménfuyut i kéluhanay séségiyo-giyowe do binatang do magéw brab do rémagaf dob fantade brab do kloh manok. ");
INSERT INTO tiy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Brab énggélingoo noy émbéréhe mano, “Pedro, étek go! Sumbaliém brab amaém.” ");
INSERT INTO tiy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Endob séménumbul i Pedrowe mano, “Aba, énda fo gérigono ku de, Kadnan. Non tidéw féganay, énda séna ménamau bé de amaén liyén dob adat geye do Judio.” ");
INSERT INTO tiy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Atin énggélingoo no man i émbéréhe ni mano, “Kago béréhén liyén taloo no tete i bénréh i Tuluse fiyo.” ");
INSERT INTO tiy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Téléw gule ménrigoy ni. Tidéw béno, i ni méntutun ménbatun séfule mangéy dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","I lala Pedrowe mégitung bé atiy atag i ni énggito no, énggumah i de sénugu Kornelio. Non amun fénénginsa roy hon i lawie gono Pedrowe bati, ménangéy ro diyo. Brab diyo ro dob liyuy béngawane. ");
INSERT INTO tiy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Atin téménawag ro brab fénénginsa ro ké diyo bati i lagéye féndawét Simon Pedro. ");
INSERT INTO tiy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Atin i Pedrowe tafay so fégitungé noy atiy atag i ni énggito no. Tidéw béno, i Rémogor i Tuluse ménbéréh dob Pedrowe mano, “Pedro, wén i téléw gétéw lagéy séméléd beem. ");
INSERT INTO tiy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tek go brab lus go, brab kago magalang-galang modor bero non Begén i séménugu bero.” ");
INSERT INTO tiy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mélaw ménlus i Pedrowe brab bénréhén bero mano, “Begén i nan sélédé kom. Ati funa kome séméléd begén?” ");
INSERT INTO tiy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Séménumbul ro maro, “Sénugu kafitan Korneliowe begey mangéy dini. I ni étéw toow fo métintu brab méngintulus, atin i kéluhanay de Judio fégadata ro. Ménbéréh i télakiwe dob beene bé féangeyé no beem dob lawi ne inok fégélingoé noy ati béréhé muwe.” ");
INSERT INTO tiy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Atin i Pedrowe ténayakufén bero dob lawie ni batio no, brab ménbati ro diyo ségékélungonon. Atin bé démoe de ménodor bero brab wén soy do dumo bé de munur bé Kristowe dob Jopa ménodor de. ");
INSERT INTO tiy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dob gétunduge de fuweh, énggumah ro dob Sesaria. Diyo nongot-nongot Korneliowe bero. Atin ténawagén i kéluhanay de samungén brab do dumo no séloyuk. Mélaw diyo ro so. ");
INSERT INTO tiy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Amun énggumahén i Pedrowe, bénalak Korneliowe brab ménlingkuwéd dob adafa Pedrowe inok féngadafé no. ");
INSERT INTO tiy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Endob féntindég Pedrowe brab ménbéréh mano, “Tindég go, non i begéne kéilawanu so loo bé beema nan.” ");
INSERT INTO tiy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Atin féntaus Pedrowey késébéréh-béréh ruwe bé lala ruwe mahur dob lawie ni, atin énggito noy médoowe étéw ménlimud. ");
INSERT INTO tiy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tidéw béno ménbéréh i Pedrowe mano, “Gétiga komén i adat geye do Judio. Enda fakayén dob kitab geye ké sémugud gey mangéy dob de lawi gom do békén Judio taloo no sélawék gey begom. Endob fénggétigay Tuluse begén bé mantuwe ni séna, bé fiyon fo ké ati no étéw, éndaén fégitungé ku de mékérésik. ");
INSERT INTO tiy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mélaw amun fén-angéy gom begén dini, éndaén ménsédélu de. Mélaw fénginsaa ku begom, ati funa kome ménfétawag begén?” ");
INSERT INTO tiy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Séménumbul i Korneliowe mano, “Amun naméntéléwo, loo so béni géraraan lémudug i térésange de, déménasalu dob lawi guwe ni. Méntékow méntéfégitoy lagéye toow fo sémélinang i kégal ne téménindég dob téngaanga kuwe. ");
INSERT INTO tiy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Atin ménbéréh mano, ‘Kornelio, énggélingooy Tulusey kédasal me brab énggétédémo noy kégédaw me brab de fiyo rénigo mo. ");
INSERT INTO tiy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mélaw sugu go étéw mangéy Jopa témawag bé lagéye féndawét Simon Pedro. Diyo bati dob lawi i lagéye gémalbék léminis do kulit safi féndawét Simon gédét dob dogote.’ ");
INSERT INTO tiy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mélaw ménagayasu séménugu mangéy témawag beem. Atin mégédaw go non ménangéy go dini. Atin ay ni gey ménlimud dob adafay Tuluse inok mégélingo bé fébéréh i Kadnane beem.” ");
INSERT INTO tiy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Atin ménbéréh i Pedrowe mano, “Béleewe ni énggétiga ku, i Tuluse énda i isu ramigo no bé de étéw. ");
INSERT INTO tiy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Non tayakuféy Tulusey étéwe mégadatan de brab rigoné noy fatute kétayay Tuluse, fiyon fo ké ati katufua nuwe taloo no ké ati tidéwo nuwe de. ");
INSERT INTO tiy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gétiga kom i kéiray i Tuluse bé kébéréh ne dob de Judio. Dob berowe fénayagén i Fiyowe Uret fantag bé kéféfiyowe fédéw sabaf bé Jesu Kristowe. Endob Beeney Kadnay kéluhanane. ");
INSERT INTO tiy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gétiga kom ké ati ménrigowe dob kéluhanay de ingéd dob Israel, méngganay dob Galilea amun i Juane nuretén i fantage bé kébautis ne. ");
INSERT INTO tiy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Brab énggétiga kom i fantage bé Jesuse tidéw Nasaret. I Tuluse nirayén témantu dob Beeney Rémogor ne brab barakat ne. Séménugud dob kéluhanay de ingéd, rémigo bé fiyowe brab fén-adi-adi noy de étéw fénrasay Satanase. Enggérigono noy de ni non dob Beeney Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Brab begey i énggégitowe bé de ni rénigo no dob de ingéd i de Judio brab dob Jerusalem. Endob i de étéw fénléhu roy Jesuse dob kruse. ");
INSERT INTO tiy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Endob ténébule i Tuluse dob gétéléw ne gétérésang brab fénggito noy Jesuse ménuyag. ");
INSERT INTO tiy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Enda méntéfégito no dob kéluhanay étéwe éndob dob begeye saén méntéfégito do fénémili i Tuluse. Ménséréngan begey mama brab miném amun méntébuleén. ");
INSERT INTO tiy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atin sénuguén begey mangéy muret bé Fiyowe Uret dob kéluhanay étéwe brab muret bé Beeney fénémili i Tuluse kémukum bé de méuyag brab bé de ménléhu. ");
INSERT INTO tiy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Atin i kéluhanay de énggétah do sénarigoy Tuluse muret bé kébéréh ne, nuret roy fantage bé Jesuse. Atin bénréh ro bé i kéluhanay munure dob Beene, fésagaday Tulusey de sala ro sabaf bé barakat i dawét ne.” Been i niy bénréh Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Amun émbéréh sénay Pedrowe, i Rémogor i Tuluse méntérimféna mangéy dob kéluhanay de mégélingo bé uret ne. ");
INSERT INTO tiy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Atin i de kuyug Jesus do dumo Pedrowe ménodor de tidéw Jopa do Judio ro. Atin toow ro fo ménggaif bé kéiray i Tuluse so témantu bé Rémogor ne dob de étéw békén Judio. ");
INSERT INTO tiy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Enggétiga ro niray i Tulusey Rémogor ne dob de békén Judio non énggélingoo roy késébéréh ruwe bé de ségiyo késébéréh énda gétiga ro de brab dénayéw roy Tuluse. Mélaw bénréh Pedrowe bero mano, ");
INSERT INTO tiy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“I de ni do étéw ténanggaf roy Rémogor i Tuluse, ségiléw so bé betome. Mélaw énda fakayén ké énda bautisén ro bé wayége.” ");
INSERT INTO tiy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Mélaw bénréhén bero fatut fébautis ro inok féténgténg roy kéunur ruwe bé Jesu Kristowe. Tidéw béno, fénbati ro nay Pedrowe dob berowe bé ménfiroye gétérésangan. ");
INSERT INTO tiy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Atin i de apostol brab de dumo ro munur bé Kristowe dob Judea, énggélingoo roy fantage bé de étéw békén do Judio ménwaléy ro munur bé kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mélaw amun ménénagé i Pedrowe mangéy Jerusalem, i de munur bé Kristowe do Judio, dénowoy roy Pedrowe, ");
INSERT INTO tiy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","maro, “Séménugud go mangéy dob lawi i de békén Judio, sani de énda méntuli. Atin ménséréngan go na bero mama.” ");
INSERT INTO tiy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mélaw nuret Pedrowe beroy kéluhanay ménrigowe tidéw féganay. ");
INSERT INTO tiy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ménbéréh i Pedrowe mano, “Amun diyou dob Jopa, déménasalu atin wén i fénggitoy Tuluse begén. Énggito gu tidéw dob lawayoy maake dakél safut ténutun fot i sugud ne. Atin ménténa dob téngaanga kuwe. ");
INSERT INTO tiy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tidéw béno, ténéngténg gu fo toow atin énggito gu diyo ménfuyut i séségiyo-giyowe do ayam brab do mérayar binatang do magéw brab do rémagaf dob fantade, brab do kloh manok. ");
INSERT INTO tiy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tidéw béno énggélingoo kuy émbéréhe mano, ‘Pedro, tindég go, sumbaliém brab amaém.’ ");
INSERT INTO tiy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Endob séménumbulu maku, ‘Aba, énda fo gérigono ku de, Kadnan. Non énda séna énggéamau bé kéluhanay amaéne ménbéréh liyén dob adat geye do Judio.’ ");
INSERT INTO tiy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Endob énggélingoo ku man ségule i ni émbéréh tidéw dob lawayo mano, ‘Kagonén béréhén liyén taloo no tete i bénréh i Tuluse fiyo.’ ");
INSERT INTO tiy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Téléw gule ménrigoy ni. Tidéw béno, ménbatun séfule mangéy dob lawayoy ni maak safut ménféno do binatang. ");
INSERT INTO tiy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bé béno so, énggumah dob lawie gono ku bati i téléwe gétéw lagéy sénugu tidéw dob ingéde Sesaria mangéy témawag begén. ");
INSERT INTO tiy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Atin i Rémogor i Tuluse bénréhén begén bé magéwu brab békénu magalang-galang modor bero. Tidéw béno, ménodor so begén i de ném ni gétéw do munur do dumo gu tidéw Jopa mangéy Sesaria. Amun énggumah geyén dob lawi Korneliowe, ménahur gey. ");
INSERT INTO tiy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Atin bénréhén begey i fantage bé télakiwe énggito no dob lawi ne. Atin bénréh i télakiwe de kun mano, ‘Sugu go étéw mangéy témawag bé lagéye féndawét Simon Pedro dob Jopa. ");
INSERT INTO tiy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ureté no beem i funa muwe méfukas dob de salaém begom i de samungém.’ Been i niy bénréh i télakiwe de kun.” ");
INSERT INTO tiy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Atin féntaus Pedrowey kébéréh ne mano, “Amun méngganayu séna émbéréh dob de étéw ni dob Jopa, i Rémogor i Tuluse ménlus mangéy dob berowe ségiléw bé kéangéy ne dob betome do Judio bé féganayo. ");
INSERT INTO tiy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tidéw béno énggétédémo kuy bénréh i Kadnane mano, ‘I Juane mautis bé wayége éndob bautison gom bé Rémogor i Tuluse.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Atin féntaus Pedrowey kébéréh ne mano, “Enggitonén i kéiray i Tuluse bé Rémogor ne dob de ni étéw békén Judio ségiléw bé kéiray ne de dob betome amun ménunur tom bé Kadnane Jesu Kristo. Mélaw énda i kuwagib gu mélén bé Tuluse miray bé Rémogor ne dob berowe.” ");
INSERT INTO tiy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Amun énggélingoo roy ni kébéréh Pedrowe, téménrén ron bé kédowoy ruwe de. Atin dénayéw roy Tuluse maro, “Mégédaw so wayoy Tuluse bé de étéw békén Judio non amuk gésénule ro, gédoté ro soy umule magufusa.” ");
INSERT INTO tiy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","I de munur bé Kristowe ménbéragar ro non bé kéférasaye bero tidéwén bé kéféléhue bé Estebane. Mélaw énggégumah ro dob de mérayu ingéd. I de dumo de dob Fenisia atin i de dumo de dob Sipri brab dob Antiokia. Atin nuret roy Fiyowe Uret dob de Judio saén. ");
INSERT INTO tiy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Endob wén i de dumo de tidéw Sipri brab do tidéw Sirin, amun énggégumah ro dob Antiokia nuret ro so dob de békén Judioy Fiyowe Uret fantag bé Kadnane Jesus. ");
INSERT INTO tiy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Atin i barakat i Kadnane ténabangén bero funay médoowe do étéw énggésénule brab ménunur bé Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Atin i urete fantag bé de ni énggumah dob de munur bé Kristowe dob Jerusalem. Mélaw fénuwit roy Bernabewe mangéy Antiokia. ");
INSERT INTO tiy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Amun énggumah diyo, énggito noy kégédaw i Tuluse bero. Toow fo ménoror i Bernabewe brab bénréhén bero kéluhanan bé fédayday ro bé kéunur ruwe dob kéluhanay de fédéw ro brab modor ro bé de sugu i Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Toow fo fiyo étéw i Bernabewe ni. Fénémanduoy Rémogor i Tuluse brab méégét i kéunur ne. Mélaw sabaf bé kétoro ne, médooy de énggésénule brab ménunur ro bé Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tidéw béno, ménangéy Tarsus i Bernabewe inok sélédé noy Saulowe. ");
INSERT INTO tiy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Amun énggito no, nuwitén mangéy Antiokia. Atin ménségébélintuwa diyo ro beroy de munur bé Kristowe brab téménoro ro dob de médoo étéw. Atin diyo dob Antiokia, ménféganay i kétawage bé de munur bé Kristowe “Kristiyano”. ");
INSERT INTO tiy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bé do no do gai, wén i de sénarigoy Tuluse muret bé kébéréh ne énggumah dob Antiokia tidéw Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Téménindég i ségétéwe bero féndawét Agabo brab fénbéréh i Rémogor i Tuluse bé wén moso i gégumah dakél lénggob dob kéluhanay de ingéd dob duniyae ni. (Atin énggégumah i ni bé gaiy kéféguléw Klaudiowe dob Roma.) ");
INSERT INTO tiy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Atin i de kuyug, ménséfagayun ro bé émféuwit ro tabang bé atiy tamay gagané ruwe mangéy dob de dumo ro do kuyug bati dob Judea. ");
INSERT INTO tiy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Atin been i niy rénigo ruwe, brab fénuwit ro bé ro Saulowe brab Bernabewey karowe tabang do kurta mangéy dob de odoroy de munur diyo dob Judea. ");
INSERT INTO tiy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bé do no do gai, féngganay i datue féndawét Herod i kéférasay ne bé de dumo bé de munur bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","I Santiagowe dumo Juane sétiman idéng, fénféléhu Herode bé sundange. ");
INSERT INTO tiy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Atin amun énggito no toow fo ménsuwat i de Judio bé ni rénigo no, fénkéfoén i Pedrowe. (Ménrigoy ni bé gaiy kékanduli i de Judio féndawét “Témara”, sani kandulie mama ro fan énda i fégéféruk de.) ");
INSERT INTO tiy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Amun énggékéfoo roy Pedrowe, fénrisu ro brab fénbantaya ro bé fote lumfuk do sundalo. Wén i fot gétéw dob séngae de sétumfuk. Atin bénantak Herode kukumén i Pedrowe dob téngaangay de étéw amuk gilid i kékanduli ruwe. ");
INSERT INTO tiy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mélaw ménbati i Pedrowe dob férisunone. Atin i de dumo no munur bé Kristowe téménantu ro démasal dob Tuluse inok tabanga noy Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Amun ségékélungonon séden i télaa Herode kémukum bé Pedrowe, bé no kélungonon ménfidong i Pedrowe dob kérara i ruwowe gétéw sundalo mantayan de. Brab nikét roy Pedrowe bé ruwowe timan sangkali. Atin wén soy do sundalo mantay dob béngaway férisunone ni. ");
INSERT INTO tiy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Atin tékow méntéfégitoy télakiy Kadnane brab ménggéfékaya i sibéy ne dob férisunone. Atin i télakiwe ni kénuyungén i Pedrowe dob wara nuwe inok ulégé no brab ménbéréh mano, “Fagayas go tek!” Sonom béno ménukoh i de sangkali dob de kémérén. ");
INSERT INTO tiy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","“Sintoro go brab sinilas go”, bang i télakiwe ni. Atin nodoro Pedrowey bénréh i télakiwe ni. Ménbéréh man i télakiwe ni mano, “Kégalém i géruwowe lafin kégalém brab odor go begén.” ");
INSERT INTO tiy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Atin ménodor i Pedrowe bé télakiwe ni brab ménsut. Endob énda gétiga no de ké toow i ni rénigoy télakiwe ni, look fénggitoy Tuluse de dob téginéfe saén. ");
INSERT INTO tiy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ténaraa roy sunguwe brab géruwowe gonoy de sundalo ni do mantay. Tidéw béno, énggumah ro dob béngaway férisunone ni futow i fintu ne. Atin ménungka so fiyon fo ké énda i ménungka de. Atin amun énggésut ron, méntaus ro magéw brab amun énggéliyuno ron i sébaane aguwon, tékow ménalfa i télakiwe ni. ");
INSERT INTO tiy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tidéw béno énggétiga Pedrowe nén i ni ménrigo, mélaw énggébérého no mano, “Béleewe énggétiga kun toow wayoy ni ménrigo! Sénugu i Kadnaney télaki nuwe témangéy begén inok énda gérigono Herode brab de Judioy kétaya ruwe rigoné ro dob begéne.” ");
INSERT INTO tiy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Amun énggétiga noy ni, méntaus mangéy dob lawi Mariahe idéng Juan Markose. Diyo ménlimud i médoowe étéw démasal. ");
INSERT INTO tiy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Amun énggumah i Pedrowe, téménuktuk dob liyuy fintue dob fésayawane. Atin ménfégédét i ségétéwe sugu-suguén kénogon féndawét Roda inok angéyé no susinén. ");
INSERT INTO tiy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Amun énggélolo noy béréh Pedrowe, toow fo ménoror. Endob énda nungkaén i fintue. Yamula sabaf bé kéoror ne ménségéta séfule mangéy dob de étéw brab bénréhén bero i Pedrowe diyo dob liyuwe. ");
INSERT INTO tiy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Endob ménbéréh ro maro, “Bunég go!” Endob énda téméré no émbéréh bé i Pedrowe diyo dob liyuwe. Mélaw bénréh ro maro, “Télaki Pedro keey i no.” ");
INSERT INTO tiy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tafay so témuktuk i Pedrowe ni. Tidéw béno nungka roy fintue ni brab amun énggito roy Pedrowe, toow ro fo ménggaif. ");
INSERT INTO tiy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Endob séniniyasa Pedrowe bero bé féantés ro, brab nuretén beroy kéféésut i Kadnane de tidéw dob férisunone. Atin ménbéréh mano, “Uret gom i ni dob Santiagowe brab dob de dumo tom munur bé Kristowe.” Tidéw béno, ménagéw i Pedrowe mangéy dob ségiyowe gonon. ");
INSERT INTO tiy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Amun géfuwénén, i de sundalo mantayan bé Pedrowe, toow ro fo ménggaif brab ménggilak. Enda énggétiga ro de ké ati énggérigono Pedrowe. ");
INSERT INTO tiy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Atin fénséléd Herodey Pedrowe. Atin amun énda énggito ro de, fénénginsaa Herodey de mantay bé férisunone, atin fénféléhuén bero. Tidéw béno, léménudug i Herode mangéy Sesaria tidéw Judea brab diyo ménrugay bati. ");
INSERT INTO tiy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Bé béno gai, ménkérit i Herode bé de étéw tidéw Tiro brab de étéw tidéw Sidon. Mélaw ménséfagayun ro mangéy ro dob beene. Bé énda séna ménangéy ro dob Herode, ménsébéréh ro bé sarigo nuwe dob lawi ne féndawét Blasto bé odoro no bero mangéy dob Herode inok ongoté ro de ké kédané noy kékérit ne bero. Non énda i ségiyo édoto ro bé amaé ruwe ké békén dob ingéde sakuf Herode. ");
INSERT INTO tiy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Amun énggumahén i télaa ruwe mangéy diyo, i Herode kéménégal kégal datu brab ménsar dob saray datue. Tidéw béno nureto no bero. ");
INSERT INTO tiy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Atin ménkes i de étéw démayéw bé Herod maro, “Tulus i ni émbéréh, békén kéilawan.” ");
INSERT INTO tiy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sonom béno, kénukum i télakiy Kadnaney Herode non ténayakufén i kéféngadaf ruwe de, brab énda féféngadafé no bero bé Tuluse. Mélaw ménsofotén i lowoh ne atin ménléhu. ");
INSERT INTO tiy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Atin bé do no gai, i urete fantag bé Tuluse ménlégéb dob de ingéd atin minut so médooy munure bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Atin i ro Bernabewe brab Saulowe amun énggilid ron i galbék ruwe, ménséfule ro tidéw Jerusalem mangéy Antiokia, brab nuwit roy Juan Markose. ");
INSERT INTO tiy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Diyo dob Antiokia, wén i de sénarigoy Tuluse muret bé kébéréh ne brab do témoro. I de ni, ro Bernabe, Saulo, Simeon (féndawét so mitam lagéy), Lusio (tidéw Sirin), brab Manaen (sani dumo Herode ménggésééruk). ");
INSERT INTO tiy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wén i no sébaan fuweh, amun ménéngadaf ro dob Tuluse brab ménfuwasa ro, i Rémogor i Tuluse ménbéréh mano, “Iray gom Begén i ro Bernabewe brab Saulowe inok rigoné roy galbéke fénémili gu iray gu bero.” ");
INSERT INTO tiy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mélaw ménfuwasa ro brab déménasal ro brab ténégé roy ro Bernabewe brab Saulowe. Tidéw béno sénugu ro bero. ");
INSERT INTO tiy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Atin i Bernabewe brab Saulowe do sénugu i Rémogor i Tuluse, ménagéw ro mangéy Selusia, atin tidéw Selusia ménda ro barko mangéy dob bungéde féndawét Siprus. Ménodor soy Juan Markose. ");
INSERT INTO tiy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Amun téménéfad ro dob ingéde Salamis, nuret roy kébéréh i Tuluse dob de lawi féngadafay de Judio. Atin téménabang soy Juan Markose. ");
INSERT INTO tiy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Atin amun énggéifara ronén i ni bungéd mangéy dob ingéde Pafos, diyo énggébalaka roy béliyane ségétéw Judio féndawét Bar-Jesus. (I dawét ne Elimas dob késébéréhe Griego.) Bénréhén been kun i sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Brab i ni béliyan, been i dumoy ségétéwe gobernador dob no bungéd féndawét Sergio Paulo, toow fo métilédtéd. Atin i ni gobernador féntawagén i ro Bernabewe brab Saulowe non méuyot mégélingo bé kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Endob i béliyane ni Elimas, toow fo ménsébanil bero. Atin ténulama no balengén i fédéw i ni gobernador inok énda munurén. ");
INSERT INTO tiy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tidéw béno, i Saulowe (féndawét so Pablo) toow fo fénémanduoy Rémogor i Tuluse. Atin fénandangén fo toow i ni béliyan. ");
INSERT INTO tiy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Brab ménbéréh i Pablowe mano, “I beema nan, nga Satanas go! Tintu sébanil go bé kéluhanay fiyowe. Ménféno go bé tugie brab akar. Atin télamané mo féwaléyén tugi i toowe tidéw dob Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bé béni so, kukuméy Tuluse beem bé waléy go langafén brab mérugay énda gégito go.” Sonom béno, i Elimase ménlangafén brab séménléd étéw marak de. ");
INSERT INTO tiy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Atin i gobernadore ni ménunur bé Kristowe amun énggito noy ni ménrigo. Toow fo ménggaif bé kétoroe fantag bé Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Atin i Pablowe brab de dumo no ménda ro man barko dob Pafos, brab énggégumah ro dob gonone féndawét Perga sakuf i ingéde féndawét Pamfilia. Endob i Juan Markose ménsésuway bero atin ménséfule mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Atin tidéw Perga, méntaus ro mangéy Antiokia sakuf i ingéde Pisidia. Atin bé gaiwe kétérén, ménahur ro dob lawie féngadafay de Judio brab ménsar ro. ");
INSERT INTO tiy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Amun énggilid i kébasawe bé de kitab sénulat Moisese brab de sénulat i de sénarigoy Tuluse, i de odoron dob lawie féngadafan fénbéréh roy ro Pablowe brab Bernabewe maro, “Do dumo gey, amuk wén i kéuyoto kom béréhé kom dob de étéw ni émféfiyo bé de fédéw ro, kagom séko méangga, béréh gom so bero.” ");
INSERT INTO tiy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mélaw téménindég i Pablowe brab séniniyasa no bero bé de kémérén inok mantés ro. Tidéw béno, ménbéréh mano, “Do dumo gu do Judio, brab begome do étéw békén Judio do méngintulus, toow gom fégélingo. ");
INSERT INTO tiy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I Tuluse féngadafé tom do Judio, i ménémilie bé de katufua tom. Atin fénwaléyén bero médoo amun ménbati ro dob mérayue ingéd Egipto. Endob fénésut i Tuluse so bero tidéw Egipto bé barakat ne. ");
INSERT INTO tiy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Atin téningkéloy Tuluse bero bé ménfote folo gébélintuwa dob gonone énda i étéw de bati. ");
INSERT INTO tiy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Amun énggilid ténaba noy de fitéw timan ingéd dob Kanaan, nirayén i fantade ni dob de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","I kérugay i kéluhanay de ni fot ratuh bra limo folo gébélintuwa. “Atin amun énggilid i ni, nirayay Tuluse bero do kéfédéwan inok wén i méguléw bero taman dob gai Samuele, ségétéw sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tidéw béno, i de Judio ménongot ro dob Tuluse datu ro. Atin fénémili i Tulusey ségétéwe lagéy féndawét Saulo nga Kis tidéw dob katufua Benjamene. Atin ménwaléy datu roy Saulowe bé ménfote folo gébélintuwa. ");
INSERT INTO tiy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Amun kénday Tulusey Saulowe, Dabid i fénwaléy ne datu ro. Bénréh i Tuluse mano, ‘Enggito guy Dabide, nga Jessewe, kénsuwata ku. Rigoné noy kétaya kuwe.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Atin féntaus Pablowey kébéréh ne mano, “Jesusey ségétéwe bé de séfu Datu Dabid. Brab Beeney fénwaléy i Tuluse Mémukas bé de étéw Judio loo bé fénasad ne. ");
INSERT INTO tiy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Amun énda séna féngganay Jesusey galbék ne, i Juan Bautistawe, nuretén dob kéluhanay de étéw do Judio bé fatut ro gésénule bé de sala ro brab fébautis ro. ");
INSERT INTO tiy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Atin amun gédétén gilid i galbék Juane, bénréhén dob de étéw mano, ‘Békén katabuwan i kékarang gome begén. Non békénu Kristo sani ongot-ongoté kome. Endob gégumah gétundug begén. Atin gérotor na begén brab fiyon foy ikét i safatos ne, énda médaitu de mukoh.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Atin féntaus Pablowey kébéréh ne mano, “Do dumo gu do séfu Abraham, brab de begom do békén Judio do méngintulus so, betom i fén-uwitoy Tuluse bé ni Fiyo Uret fantag bé Mémukase. ");
INSERT INTO tiy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","I de étéw dob Jerusalem brab de odoro ro énda énggétiga ro de ké Jesusey Mémukase. Brab énda énggésobuto roy ménsulate kébéréh i de sénarigoy Tuluse muret bé kébéréh ne fiyon fo ké bénasa ro sénga fadiyan bé de gai kétérén. Endob fiyon fo ké loo bé ni, ténuma ro soy ménsulate bé kékukum ro bé Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Atin fiyon fo ké énda i funa ro kémukum bé Jesuse, nongot ro so dob Pilatowe féléhuén i Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Amun énggétumana ron i kéluhanay Ménsulate Kébéréh i Tuluse fantag bé Jesuse, kénda roy bangkay ne dob kruse brab lénébéng ro dob takube. ");
INSERT INTO tiy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Endob ténébule i Tulusey Jesuse. ");
INSERT INTO tiy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Atin dob ménfiroye gétérésangan, médoo gule méntéfégitoy Jesuse dob de étéw ménodor de amun ménagéw mangéy Jerusalem tidéw Galilea bé gétahe. Atin béleewe ni, beroy ménurete dob de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Brab ay ni gey inok ureté key dob begomey ni Fiyo Uret, sani Urete fantag bé fasad i Tuluse dob de katufua tom rigoné no. Atin i fasade ni, méntuman so dob betome do séfu ro non ténébuleén i Jesuse. Ay niy ménsulate dob géruwowe Kanta dob Ménsulate Kébéréh i Tuluse mano, ‘Beemey Nga guwe, béleewe ménwaléyu Bohém.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Atin féntaus Pablowey kébéréh ne mano, “Ay niy bénréh i Tuluse fantag bé kétébule ne bé Jesuse inok énda mérénah i lowoh ne mano, ‘Tintu iray gu begom i kéluhanay kéfiyonone loo bé fénasad guwe dob Dabide.’ ");
INSERT INTO tiy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Atin bénréhén so dob Tuluse mano, ‘Enda fédayaé moy lowoh i fiyowe sugu-sugué mo mérénah.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Atin féntaus Pablowe man i kébéréh ne mano, “I ni sulat békén fantag bé Dabide, non amun énggilid rénigo Dabidey kénsuwatay Tuluse, ménléhu brab lénébéng dob sékuloy de katufua no atin ménrénah i lowoh ne. ");
INSERT INTO tiy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Endob ténébule i Tulusey Jesuse, énda ménrénah i lowoh ne. ");
INSERT INTO tiy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mélaw do dumo gu, fatut gétiga kom i sabaf bé Jesuse saén i géureto keye begom, wén i kéfésagadén bé de sala gom. ");
INSERT INTO tiy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Atin i kéluhanay de méginugut dob Beene émfésagad i de sala ro. Enda émfésagad gom sabaf bé kéodoro kome bé de kitab sénulat Moisese. ");
INSERT INTO tiy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mélaw, ingat gom inok énda mérigo dob begomey bénréh i de sénarigoy Tuluse maro, ");
INSERT INTO tiy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Téngténg gom, begom i de démiyangka bé Tuluse. Mégaif gom bé rigoné kuwe bé béni brab méléhu gom non énda méngginugut gom de, fiyon fo ké wén i téménoro de begom.’ ” Been i niy bénréh Pablowe. ");
INSERT INTO tiy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tidéw béno, ménsutén i Pablowe brab Bernabewe tidéw dob lawie ni féngadafan. Atin bé lala ruwe mésut, rénafit i de étéw man bero séfule bé gétunduge gai kétérén inok ureto ro man bero ségule fantag bé de ni. ");
INSERT INTO tiy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Amun ménsutén i kéluhanane, médooy de Judio brab do békén Judio do ménggéodor bé kéféngintulus i de Judio, ménodor ro bé ro Pablowe brab Bernabewe. Atin i de ni apostol, nureto ro bero bé fétausé roy kétayakuf ruwe bé kégédaw i Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Amun dob gétunduge man gai kétérén, gédét kéluhanay de étéw dob no ingéd ménangéy ro dob lawie féngadafan inok mégélingo ro man bé kébéréh i Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Atin toow fo méndaléw i de Judio amun énggito roy de médoo do étéw. Mélaw ménbéréh ro sébanil bé de béréhé Pablo, brab fénéngiras ro. ");
INSERT INTO tiy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Endob toow na fo ménfébaraw émbéréh i ro Pablowe brab Bernabewe maro, “Fatut ureté key i kébéréh i Tuluse dob begome do Judio sungu. Endob amun ménika gom de, fénggito gom énda médait gom gégédot bé umule magufusa. Mélaw tagaké key begom brab mangéy gey muret dob de békén Judio. ");
INSERT INTO tiy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Non been i niy sugue niray i Kadnane begey mano, ‘Féuwit gu begom maak do solo dob de étéw békén Judio, inok i kéluhanay étéwe dob duniyae ni gélingoo roy kéuret gome brab méfukas ro.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","I de étéw békén Judio, amun énggélingoo roy ni kéuret Pablowe brab Bernabewe, toow ro fo ménoror brab dénayéw roy kébéréh i Kadnane. Atin i de étéw fénémili i Tuluse gégédot bé umule magufusa, ménunur ro bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Atin i kébéréh i Kadnane ménlalag dob kéluhanay de gonon dob no ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Endob i de Judio rénimbur roy de odoron do lagéy dob no ingéd brab de gérotor libun do békén Judio do méngintulus. Atin féngganaya roy kéférasay ruwe bé ro Pablowe brab Bernabewe brab fénféraréy ro bero dob no ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mélaw i de apostol ni, ténagtag roy de bubuk sébuwan dob de sékéy ro inok féfégétiga ro bé de étéw bé kukuméy Tuluse bero. Atin méntaus ro mangéy Ikonium. ");
INSERT INTO tiy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Atin i de munur dob Antiokia dob sakuf i ingéde Pisidia, toow ro fo ménoror brab fénémanduoy Rémogor i Tuluse bero. ");
INSERT INTO tiy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Atin loo so bé ménrigowe dob Antiokia, i ménrigowe dob Ikonium. I Pablowe bero Bernabewe ménahur ro so dob lawie féngadafay de Judio. Atin toow fo fiyoy kétoro ruwe, mélaw médooy de Judio brab do békén Judio ménunur bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Endob wén i de Judio do énda méginugut ro brab rénimbur roy de étéw békén do Judio inok waléy ro mékérit bé de munur. ");
INSERT INTO tiy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Endob i ro Pablowe brab Bernabewe, ménrugay ro na ménbati diyo. Brab ménfébaraw ro muret fantag bé Kadnane. Atin nirayay Kadnane bero barakat inok gérigo ro do mékégaif. Mélaw énggétigay de étéw ni, toow i kéuret ruwe fantag bé kégédaw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Endob énda géséfagayun i de étéw dob no ingéd. I de dumo bé de étéw ménagayun ro dob de Judio. Atin i de dumo bero ménagayun ro dob de apostol. ");
INSERT INTO tiy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tidéw béno, i dumo bé de Judio brab de dumo bé de étéw do békén Judio, beroy de odoro ro, bénantak ro bé dusané ro brab ibéro ro batéw i de apostol inok méléhu ro. ");
INSERT INTO tiy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Endob amun énggélingooy de apostol i ni bantak ro, ménraréy ro mangéy Listra brab Derbe, brab dob de ségiyo gonon dob sakuf i ingéde Lisonia. ");
INSERT INTO tiy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Atin diyo nuret roy Fiyowe Uret. ");
INSERT INTO tiy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Atin diyo dob Listra, wén i ségétéwe lagéy fikat non ménsadil i de sékéyén brab énda géagéwén tidéw fanay kéumahén. ");
INSERT INTO tiy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ménsar brab fénggélingoén i kétoro Pablowe ni. Atin énggito Pablowey kéunur ne funa no fakay waléy adi-adi. Mélaw ténéngténg Pablowe fo toow. ");
INSERT INTO tiy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Atin féntanugén i kébéréh ne mano, “Fééntang go tindég.” Sonom béno, ménagayas tésongkow témindég i ni lagéy brab ménadi-adi, brab ménagéw-agéw. ");
INSERT INTO tiy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Amun énggitoy de étéw i rénigo Pablowe ni, ménkes ro dob karowe késébéréh dob no ingéd Lisonia maro, “Ménlus i de tulus méntéfuwaléy ro do kéilawan mangéy dob betome!” ");
INSERT INTO tiy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mélaw féndawét ro Seus i Bernabewe brab féndawét ro Hermes i Pablowe non beeney murete. Non Seus brab Hermes i ruwowe bé de tulus kun féngadaféy de étéw ni. ");
INSERT INTO tiy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Atin i lawie féngadafa ro bé tulus ruwe féndawét Seus, diyo dob liyuy béngaway ingéd ruwe. Atin amun énggélingooy béliya ruwey ni rénigo Pablowe brab Bernabewe, nuwito no do safi brab do flores inok témulak beroy de étéw dob adafay de apostol. ");
INSERT INTO tiy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amun énggétiga ro Bernabewe brab Pablowey ni rénigo ro, sénkusi roy de kégal ro inok fégito roy kéika ruwe bé ni rigoné ro. Brab léménéntu ro mangéy dob kérara i de étéw ni ménribuk brab ménkes ro maro, ");
INSERT INTO tiy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kagom rigonén i nan! Do kéilawan gey so loo bé begoma nan. Ménangéy gey dini inok ureté key i Fiyowe Uret fantag bé Jesuse inok ikaa komén i de ni do adat énda i do lantékén. Méuyot gey de ké féngadafé kom i tintuwe Tulus sani réménigowe bé lawaye, fantad, dogot, brab kéluhanay éntingayéne. ");
INSERT INTO tiy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bé de énggétah do gai, féndaya i Tuluse rigonéy de étéw i kéluhanay karowe kétayan. ");
INSERT INTO tiy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Endob tidéw féganay, sénga tékélid fénggétiga noy fantage bé Beene dob de kégédaw rénigo no. Iraya no begom rana tidéw dob lawayo inok méruk i de nohok gom ké gai ro. Iraya no begom amaé kom atin féfiyoné noy de fédéw gom.” ");
INSERT INTO tiy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Endob fiyon fo ké loo bé nan i kébéréh ne, ménkérégénan i Pablowe brab Bernabewe gémélé bero bé kétulaka ruwe bero. ");
INSERT INTO tiy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Endob wén i do Judio énggégumah dob no ingéd do tidéw Antiokia sakuf i ingéde Pisidia brab do tidéw Ikonium. Atin bénaleng roy fédéw i de étéw ni inok sébanil ro bé Pablowe. Mélaw nibéro ro batéw i Pablowe ni inok méléhu ro damén. Tidéw béno, génuyud ro mésut i Pablowe tidéw dob ni ingéd, atin ténagak ro non marok ménléhuén. ");
INSERT INTO tiy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Endob amun énggégumah i de dumo no munur bé Kristowe atin sénliwéto ro, téménindég i Pablowe brab ménahur man dob no ingéd. Atin bé démoe de ménagéw i ro Pablowe brab Bernabewe mangéy Derbe. ");
INSERT INTO tiy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Amun énggumah ro dob Derbe, nuret Pablowe brab Bernabewey Fiyowe Uret atin médooy ménunure bé Kristowe. Tidéw béno, ménséfule ro mangéy Listra brab Ikonium brab Antiokia dob sakuf i ingéde Pisidia. ");
INSERT INTO tiy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Brab fénbagér roy fédéw i de munur diyo brab bénrého ro bero bé fétausé roy kéodor ruwe brab késarig ruwe bé Jesuse. Brab ménbéréh ro maro, “Kamarasayan tom na médoo gule sungu atin géahur tom dob kéféguléw i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Atin dob séngae do ménlimud do munur, i de apostol, ménémili ro do étéw inok waléy ro odoroy de munur. Atin démasal ro brab fuwasa ro atin sarigé ro bero dob Kadnane, sani unuro ruwe. ");
INSERT INTO tiy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Atin ménagéw ro témara bé ingéde Pisidia atin énggumah ro dob Pamfilia. ");
INSERT INTO tiy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nuret roy Fiyowe Uret dob ingéde Perga. Tidéw béno léménudug ro mangéy Atalia. ");
INSERT INTO tiy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tidéw Atalia, ménda ro barko séfule mangéy Antiokia, dob sakuf i ingéde Siria sani ingéde gonoy de dumo ro munur séménarig bero dob Tuluse inok tabanga no bero bé galbék ruwe mantu séna fénggilid ro. ");
INSERT INTO tiy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Amun énggumah ro dob Antiokia, lénimud roy de munur bé Kristowe atin nuret roy kéluhanay de rénigoy Tuluse bé kéagéw ruwe brab fantag bé kébéngaw i Tuluse bé agéwone inok i de étéw békén do Judio géunur ro bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Atin ménrugay ro ménbati diyo beroy de dumo ro munur bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bé béno, wén i de étéw ménangéy Antiokia tidéw Judea brab ténoro roy de munur bé Kristowe maro, “Taman énda fétuli gom loo bé ménbéréhe dob kitabe sénulat Moisese, énda méfukas gom dob de sala gom.” ");
INSERT INTO tiy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Endob i Pablowe brab Bernabewe ménika ro bé kétoro ruwe ni brab toow ro fo ménkérit brab ménsédél ro bé de ni do étéw. Atin ménséfagayun ro kéluhanan bé i ro Pablowe brab Bernabewe brab de dumo do munur dob Antiokia, mangéy ro dob de apostol brab dob de odoroy de munur dob Jerusalem inok fénginsaé roy fantage bé ni. ");
INSERT INTO tiy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Atin i de étéw do munur dob Antiokia sénugu ro bero mangéy Jerusalem. Atin bé kéagéw ruwe, énggétara ro dob de ingéd féndawét Fenisia brab Samaria. Atin diyo nuret roy fantage bé de étéw do békén Judio ménwaléy do munur. Mélaw i de munur dob do no ingéd toow ro fo ménoror amun énggélingoo roy de ni. ");
INSERT INTO tiy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Amun énggégumah ro dob Jerusalem, i de munur brab de apostol brab do odoron, ténayakuf ro bero. Atin i Pablowe brab Bernabewe nuret roy kéluhanay rénigoy Tuluse dob berowe. ");
INSERT INTO tiy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Endob i de dumo bé de Fariseo do ménwaléy munur bé Kristowe, téménindég ro brab ménbéréh ro maro, “Fatut tulién i de étéw do békén Judio do ménwaléy munur bé Kristowe brab fatut suguén ro bé odoro roy kéluhanay de kukuman sénulat Moisese.” ");
INSERT INTO tiy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Atin ménsélimud i de apostol brab do odoron inok sétiyawané roy fantage bé ni. ");
INSERT INTO tiy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Amun ménrugay ron ménsébéréh-béréh, téménindég i Pedrowe brab ménbéréh mano, “Do dumo gu, énggétiga kom i ni: Bé i kéluhana tome dini, fénémili i Tuluse begén bé do gétah inok ureté kuy Fiyowe Uret dob de békén Judio inok munur ro so. ");
INSERT INTO tiy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","I Tuluse gétiga noy fédéw i kéluhanay étéwe. Atin fénténgténgén i kétayakuf ne bé de békén Judio bé kéiray ne bé Rémogor ne dob berowe ségiléw so bé kéiray ne de dob betome. ");
INSERT INTO tiy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Enda fénsébida no betom bé berowe non léninisén soy de fédéw ro non ménunur ro bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Aw méuyot gom rémigo bé kéikaay Tuluse funa no kémukum begom? Aw féodoro kom beroy de sugu tidéw dob kitab Moisese fiyon foy de katufua tom brab betome énda énggéodoro tom de? ");
INSERT INTO tiy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Békén i nan! Munur tom bé méfukas tom sabaf bé kégédaw i Kadnane Jesus, betom ségiléw so bé berowe.” ");
INSERT INTO tiy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tidéw béno, ménantés ro kéluhanan amun énggélingoo roy bénréh ro Bernabewe brab Pablowe fantag bé de mékégaif fénrigoy Tuluse bero amun diyo ro dob de étéw békén Judio. ");
INSERT INTO tiy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Amun énggilid ron émbéréh, ménbéréh i Santiagowe mano, “Do dumo gu, fégélingo gom! ");
INSERT INTO tiy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","I Simon Pedrowe, mantu séna nuretén dob betomey sunguwe kégédaw i Tuluse dob de békén Judio amun fénémilién i de dumo bero ménwaléy so do kaan étéw munur bé Beene. ");
INSERT INTO tiy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ségiléw so bé niy bénréh i de méntélata do sénarigoy Tuluse muret bé kébéréh ne. Non sénulat ro mano, ");
INSERT INTO tiy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ménbéréh i Kadnane mano, séfuleu moso dob de séfu Datu Dabid. Brab fétindégé ku man bero non ségiléw ro bé sébaane lawi ménrundas. ");
INSERT INTO tiy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Rigoné kuy ni inok i kéluhanay de étéw munur ro dob Begéne, loo soy de étéw békén Judio do fénémili gu waléy kagén do étéw. ");
INSERT INTO tiy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Been i niy bénréh i Kadnane, sani ménfégétigane bé de ni tidéw féganay.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Atin féntaus Santiagowey kébéréh ne mano, “I kagéne de karang, énda damén férégéno tom i de étéw békén Judio énggésénule ron brab munur ro bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Yamula, sulata tom bero, bé békén ro sa mama bé amaéne ménwaléyén mékérésik dob adafay Tuluse non ténulak dob de kéninontow, brab békén ro bigaén, brab békén amaé roy de binatang énda ménsumbalién, brab békén ro mama dara. ");
INSERT INTO tiy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Fatut rigoné roy ni inok énda mékérit i de Judio non ménrugayén i de kitab sénulat Moisese, ménbasanén dob kéluhanay de lawi féngadafay de Judio sénga gai kétérén, atin ménuretén dob kéluhanay de ingéd.” ");
INSERT INTO tiy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tidéw béno, i de apostol brab de odoron brab kéluhanay de munur bé Kristowe, ménséfagayun ro ménémili bé de dumo bero. Atin fénuwit ro bero mangéy Antiokia ménodor ro bé Pablowe brab Bernabewe. Brab fénémili roy Judase (féndawét so Barsabas) brab Silase sani de ruwo gétéw toow fo basanay de munur. ");
INSERT INTO tiy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Atin fénuwit ro beroy sulate ni émbéréh mano, “I de begey do apostol brab do odoron, sani de dumo gom munur bé Kristowe dob Jerusalem, ségifaé key begom do dumo gey munur bé Kristowe do békén Judio bati dob Antiokia, dob Siria, brab dob Silisia. ");
INSERT INTO tiy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Enggélingoo key wén i do dumo gey ménangéy dob begome brab fénbuku roy de fédéw gom bé de kébéréh ro. Endob énda sénugu gey bero rémigo bé de ni. ");
INSERT INTO tiy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mélaw ménséfagayun gey ménémili do lagéy inok sugué key bero mangéy dob begome. Modor ro bé Pablowe brab Bernabewe sani de kégédawa key do dumo tom. ");
INSERT INTO tiy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Beroy de étéw niray roy férénawa ruwe dob galbék i Kadna tome Jesu Kristo. ");
INSERT INTO tiy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Mélaw sugué key i ro Judase brab Silase inok ureté ro dob begomey ségiléwe bé ni sénulat gey. ");
INSERT INTO tiy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","I Rémogor i Tuluse fénggésobutén begey brab ménagayun gey bé éndaén férégénon gom saliyu bé de ni do sugu: ");
INSERT INTO tiy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kagom mama bé éntingayéne ténulak dob de kéninontow, brab kagom mama dara, brab kagom mama bé de binatang énda ménsumbalién, brab kagom bigaén. Fiyo ké odoro kom i de ni. Been say niy béréhé keye begom. Salamat.” ");
INSERT INTO tiy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tidéw béno, ménagéw i de sénugu ro ni mangéy Antiokia. Amun énggégumah ro diyo, ténawag roy kéluhanay de munur bé Kristowe brab niray roy ni sulat. ");
INSERT INTO tiy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","I de étéw diyo amun énggébasana roy ni sulat, toow ro fo ménoror bé de ni kébéréh funay de fédéw ro ménfiyo. ");
INSERT INTO tiy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Atin i ro Judase brab Silase (beroy de sénarigoy Tuluse muret bé kébéréh ne), ménrugay i kéureto ruwe bé de étéw inok waléy fiyoy de fédéw ro brab inok waléy méégét i kéunur ruwe bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Atin ménbati ro diyo bé ménfiroye géfadiyan. Tidéw béno, fénséfule i de dumo ro munur bero mangéy Jerusalem dob de étéw séménugu bero. Atin ménbéréh ro mano, “Fiyo damén i kéagéw gome.” ");
INSERT INTO tiy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Endob i Silase ménbati dob Antiokia. ");
INSERT INTO tiy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","I Pablowe brab Bernabewe ménbati ro dob Antiokia bé ménfiroye gétérésang kélungonon. I berowe brab de médoo do dumo ro munur bé Kristowe, nuret ro brab ténoro roy kébéréh i Kadnane dob de étéw. ");
INSERT INTO tiy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Enda ménrugayén tidéw béno, i Pablowe bénréhén dob Bernabewe mano, “Séfule to mangéy dob de ingéd nureto to bé kébéréh i Kadnane inok angéyé to tukawén i de dumo tom munur bé Kristowe brab inok gétiga to ké ati falas ruwe diyo.” ");
INSERT INTO tiy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Atin i Bernabewe méuyot de ké uwitén i Juane Markose. ");
INSERT INTO tiy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Endob i Pablowe ménika muwit bé Juan Markose non ténagakén bero dob Pamfilia brab énda ménfédaydayén modor bero dob galbék i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mélaw i Pablowe brab Bernabewe toow ro fo énggésédél fantag bé Juan Markose. Tidéw béno ménsésuway ro. Nuwit Bernabewey Juan Markose ménda bé barkowe mangéy Siprus. ");
INSERT INTO tiy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Atin i Pablowe fénémilién i Silase modor de. Atin i de dumo ro do munur déménasal ro dob Kadnane inok Been i manangguwit bero bé kéagéw ruwe brab mégédaw bero. ");
INSERT INTO tiy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Atin ménagéw ro mangéy Siria brab Silisia, brab fénbagér roy kéunur i de dumo ro munur bé Kristowe dob de ni do ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Atin i Pablowe ménangéy dob de ingéd féndawét Derbe brab Listra. Diyo wén i ségétéwe lagéy munur bé Kristowe féndawét Timoteo. I idéng ne ségétéw libun Judio, munur bé Kristowe. Endob i boh ne békén Judio, i beene ségétéw lagéy Griego. ");
INSERT INTO tiy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Atin i kéluhanay de munur bé Kristowe dob Listra brab Ikonium bénréh roy fiyowe fantag bé Timoteowe. ");
INSERT INTO tiy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Atin i Pablowe ni ménuyot muwit bé Timoteowe ni modor bero. Mélaw ténulién loo bé adat i de Judio. Rénigo noy ni inok énda siyawéy de Judio de, non i kéluhanay de Judio dob de ingéd ayo ro, gétiga roy békén Judioy boh ne. ");
INSERT INTO tiy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Atin ménagéw ro man. Amun ménawét ro dob de ingéd, nuret ro dob de munur bé Kristowey de sugu sénfagayunoy de apostol brab do odoron bé késélimud ruwe dob Jerusalem. Atin bénréh ro bero bé odoro roy de ni do sugu. ");
INSERT INTO tiy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mélaw i de ménlimud do munur bé Kristowe ménwaléy émbagér i kéféginugut ruwe brab méninut ro médoo sénga fuweh. ");
INSERT INTO tiy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ménagéw ro témara bé de sakuf i de gonon féndawét Frigia brab Galasia, non i Rémogor i Tuluse énda ténungkasén bero muret dob Asia. ");
INSERT INTO tiy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Amun énggumah ro dob gonone féndawét Misia, téménlama ro mangéy Bitinia. Endob i Rémogor Jesuse énda ténungkasén bero mangéy diyo. ");
INSERT INTO tiy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mélaw léménudug ro mangéy dob ingéde Troas dob fédoror i dogote, témara bé gonone Misia. ");
INSERT INTO tiy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Amun bé kélungonone de wén i énggétéginéfo Pablowe, non wén i fénggitoy Tuluse de. Atin énggito noy ségétéwe lagéy tidéw Masedonia téménindég brab nongotén dob Pablowe mano, “Ay go dini dob Masedoniawe ni brab tabangén gey.” ");
INSERT INTO tiy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Amun énggilid i ni téginéf, ménagékés gey mangéy Masedonia, non gétiga key ténawag i Tuluse begey dob Masedonia inok toroé key diyo i Fiyowe Uret. ");
INSERT INTO tiy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Dob Troas, ménda gey barko fééntang mangéy dob bungéde Samotrasia. Atin bé gétunduge de fuweh, méntaus gey mangéy Neapolis. ");
INSERT INTO tiy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Atin tidéw man Neapolis, ménagéw gey dob ingéde féndawét Filipos. Been i niy mélagae dakél ingéd dob sakuf i Masedoniawe. Brab médooy de étéw tidéw Roma bati diyo. Atin ménbati gey diyo bé ménfiroye gétérésangan. ");
INSERT INTO tiy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Bé gaiy kétéréne, ménsut gey tidéw dob ingéde ni brab ménangéy gey dob fédoror i dakéle wayég, non makey ké diyo i gonoy de Judio démasal. Amun énggumah gey diyo, ménsar gey brab ménsébéréh-béréh gey i de libun ménlimud diyo. ");
INSERT INTO tiy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","I ségétéwe bé de ni do libun, i dawét ne Lidia, tidéw dob ingéde féndawét Tiatira. I galbék ne émfébéléy bé de balilaga furo safut. Tintu fo méngintulus i ni libun. Atin féntayakuf i Kadnaney fédéw ne atin ménunur bé de kétoro Pablo. ");
INSERT INTO tiy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mélaw ménfébautis i ni libun brab de dumo no sétifon. Tidéw béno bénréhén begey mano, “Amuk gékaranga kom tintuwu fo munur bé Kadnane, ay gom dob lawi guwe atin diyo gom bati.” Mélaw fénodorén begey. ");
INSERT INTO tiy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wén i no sébaan fuweh, bé lala geye magéw mangéy dob gonone démasal, wén i ségétéwe rifén kénogon énggébalaka no begey. Rénahukoy saitane, komon gébérého noy ati mérigowe moso dob de gégumah do gai. Atin dakél i gédotéy de gefe de kurta bé ni galbékén béréhé noy ati mérigowe moso dob de étéw. ");
INSERT INTO tiy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Atin ménfuray begey ro Pablowe brab ménkes mano, “I de ni do étéw, beroy sugu-suguéy toowe fo gérotor Tulus. Ureté ro dob begomey atiy géfukase begom.” ");
INSERT INTO tiy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Beeniy rénigo nuwe bé ménfiroye gétérésangan taman ménrarék i Pablowe. Mélaw sénaréwén ténéngténgén i ni kénogon brab ménbéréh dob saitane mano, “Dob barakat Jesu Kristowe, sugué ku beem tékédan dob ni kénogon!” Sonom béno, méntékédan i saitane dob beene. ");
INSERT INTO tiy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Endob i de gefe bé ni rifén, amun énggito ro éndaén gégédot ro de kurta, ménkérit ro fo toow. Atin kénéfo roy ro Pablowe brab Silase, atin génuyud ro bero mangéy dob de gémamak kukuman dob fadiyane. ");
INSERT INTO tiy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Atin nuwit ro bero mangéy dob adafay de odoron tidéw Roma, brab bénréh ro maro, “I de ni do étéw, do Judio. Rimburé roy katome ni ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Toroé roy adate sébanil bé de kukuma tom. Do Romano tom, brab énda fakayén odoro tom i nan adat toroé ro.” ");
INSERT INTO tiy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Atin médooy de étéw ménamung lémubag bé ro Pablowe brab Silase. Atin i de odoron fénkéda roy de kégal ro Pablo brab Silas brab fénbadas ro bero. ");
INSERT INTO tiy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Amun énggilid ro bénadas fo toow i ro Pablowe brab Silase, fénrisu ro bero, atin bénréh ro dob mantaye bé férisunone bé toow fo bantaya no bero. ");
INSERT INTO tiy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mélaw fénahurén bero dob sibéye dob kérara i férisunone brab fénatungén i de sékéy ro dob toowe fo émbégat do dakél kayéw inok énda géagéw ro. ");
INSERT INTO tiy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Amun kérara kélungononén, i ro Pablowe brab Silase déménasal ro brab kéménanta ro dob Tuluse. Atin fénggélingo i de dumo ro férisu. ");
INSERT INTO tiy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Atin méntékow léménuba toow fo émbagér, atin i férisunone ni ménkuyung fo toow. Brab sonom so béno, ménungka i kéluhanay de fintu. Atin ménukoh i de sangkali fénggéikét bé de sékéy i de férisu. ");
INSERT INTO tiy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Atin ménulég i mantaye bé de férisu. Amun énggito no ménungka i kéluhanay de fintu, manok énggésut i kéluhanay de férisu. Mélaw nawitén i sundang ne dob ruma ne brab fétoyoén damén, non gétiga no féléhuéy de odoron amuk énggésut i de férisu. ");
INSERT INTO tiy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Amun gédétén damén fétoyo, ténawag Pablowe mékes mano, “Kago fétoyo, ay ni gey so kéluhanan!” ");
INSERT INTO tiy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Atin i mantaye ni bé de férisu, téménawag ménongot solo brab ménségéta mahur dob férisunone ni. Toow fo léménukub bé kégilak ne, brab méntéléngkéb dob adafay de sékéy ro Pablo brab Silas. ");
INSERT INTO tiy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tidéw béno, nuwitén bero mésut brab fénénginsaa no bero mano, “Ati fatute rigoné ku inok méfukasu dob de sala gu?” ");
INSERT INTO tiy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Atin séménumbul ro maro, “Unur go bé Kadnane Jesus atin méfukas go. Beeme brab de samungém so.” ");
INSERT INTO tiy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Atin nuret roy kébéréh i Kadnane dob beene brab dob kéluhanay de dumo no sétifon. ");
INSERT INTO tiy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Atin bé béno so kélungonon, i mantaye ni nurahén i de fali ro. Atin tidéw béno, ménagayas ménfébautis beroy de samungén. ");
INSERT INTO tiy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Atin fénlowotén i ro Pablowe brab Silase dob lawi ne brab fénamaén bero. Atin i ni ségékuréng toow fo ménoror non ménunur ron bé Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Atin bé géfuwéne de, i de odoron bé no ingéd, sénugu roy de sarigon mangéy dob férisunone inok tangéyé ro bero. ");
INSERT INTO tiy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mélaw i mantaye bé férisunone bénréhén dob Pablowe mano, “I de méguléw séménugu ro bé féésutén go brab Silase. Mélaw ésut gomén brab kagomén émbuku.” ");
INSERT INTO tiy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Endob ménbéréh i Pablowe dob de sarigon mano, “Enda i funa ro begey kémukum. Gido loo bénadas ro begey dob téngaangay médoowe étéw, brab fénrisu ro begey fiyon fo ké énda méntiyawan gey. Brab i begeye do Romano so! Atin béleewe bunéyé ro saén i kéféésut ruwe begey! Enda fakayén! Béréh gom dob de méguléw tidéw Roma, beroy mangéye dini émféésut begey.” ");
INSERT INTO tiy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Atin i de sarigon ménséfule ro dob de méguléw tidéw Roma brab nuret roy kébéréh Pablowe. Atin amun énggélingoo ro Romano so wayoy ro Pablowe brab Silase, toow ro fo ménggilak. ");
INSERT INTO tiy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mélaw ménagéw ro mangéy dob férisunone brab nongot ro dob Pablowe brab Silase bé fésagadé ro bero. Tidéw béno, nuwit ro bero mésut tidéw dob férisunone brab nongot ro dob berowe bé tékédan ronén dob ni ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Atin i ro Pablowe brab Silase, amun ménsut ronén dob férisunone, méntaus ro mangéy dob lawi Lidiahe. Atin diyo énggito roy de dumo ro munur bé Kristowe. Brab bénréh ro beroy fiyowe inok fiyoy de fédéw ro. Tidéw béno méntékédan ro. ");
INSERT INTO tiy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Atin amun méntaus magéw i ro Pablowe brab Silase, énggétara ro dob de ingéd féndawét Amfipolis brab Apolonia, atin énggégumah ro dob ingéde féndawét Tesalonika. Atin diyo wén i lawie féngadafan kay de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Atin i Pablowe loo bé adat ne ménahur dob lawie ni féngadafan. Méntéléw gé-Sabadoy no, sani gaiy kétéré ruwe, i Pablowe ménsébéréh-béréh bé de étéw atin i kébéréh ne tidéw dob Ménsulate Kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Fénggétiga no bero tidéw dob ni ménsulat bé mérasay i Kristowe brab tébule. Ménbéréh i Pablowe mano, “Béréhé ku begom i toowe fantag bé Jesuse. Beeney Kristowe, sani fénémili i Tuluse méguléw.” ");
INSERT INTO tiy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Atin wén i de ménunur bero brab nodoro roy ro Pablowe brab Silase. Loo soy médoowe do Griego méngintulus brab do gérotor do libun. ");
INSERT INTO tiy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Endob i de Judio méndaléw ro, mélaw lénimud roy de tete étéw do énda i galbék ro tidéw dob de aguwon atin rénimbur roy ingéde ni. Atin dénunsuk roy lawi i ségétéwe lagéy féndawét Jason inok sélédé roy ro Pablowe brab Silase, brab inok uwité ro bero dob adafay de médoo étéw. ");
INSERT INTO tiy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Endob amun énda énggito ro bero, nuwit roy Jasone brab de dumo no munur bé Kristowe mangéy dob de méguléw bé ni ingéd. Atin ménkes ro maro, “Wén i de étéw réménimbur bé kéluhanay de ingéd. Atin béleewe ni, ay ni ro énggégumah dob katome ni ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Atin i Jasone ni, fénbatién bero dob lawi ne. I kéluhana ruwe réménigo ro bé békéne fatut dob kitabe tidéw dob Datu tome dob Roma. Non bénréh roy wén i ségiyo datu, sani féndawéte Jesus.” ");
INSERT INTO tiy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Amun énggélingoo roy ni kébéréh, ménrimbur i de médoo do étéw ménlimud brab de méguléw bé ni ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tidéw béno, i de méguléw fénégés roy Jasone brab de dumo no mayad loo bé adat ruwe inok métangéy ro. Tidéw béno fénsut ro bero. ");
INSERT INTO tiy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Amun kélungononén, i de dumo ro munur bé Kristowe, fénuwit roy Pablowe brab Silase mangéy dob ingéde féndawét Berea. Amun énggégumah ro diyo, ménangéy ro dob lawie féngadafay de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Atin i de étéw dob Berea, toow na fo fiyoy adat ruwe bé de étéw dob Tesalonika. Toow ro fo méuyot mégélingo bé kétoro Pablowe. Atin féganadé roy Ménsulate Kébéréh i Tuluse sénga fuweh inok susiné ro ké toow i kétoro Pablowe. ");
INSERT INTO tiy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Atin médoo ro ménwaléy munur bé Kristowe. Loo soy de Griego, do lagéy brab do libun do gérotor dob no ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Endob i de Judio dob Tesalonika, amun énggélingoo roy Pablowe muret bé kébéréh i Tuluse dob Berea, ménangéy ro diyo brab rénimbur roy de médoo étéw diyo. ");
INSERT INTO tiy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mélaw i de munur bé Kristowe fénagayas ro fénuwit i Pablowe mangéy dob fédoror i dogote, éndob ménbati i Silase brab Timoteowe dob Berea. ");
INSERT INTO tiy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","I de déménuran bé Pablowe ménodor ro de taman Atenas. Tidéw béno ménséfule ro mangéy Berea. Atin nuwit roy kébéréh Pablowe dob ro Silase brab Timoteowe bé furay ro de magad. ");
INSERT INTO tiy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","I lala Pablowe ongot-ongot bero dob Atenas, toow fo ménbuku non médoo foy de kéninontow dob no ingéd. ");
INSERT INTO tiy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mélaw i Pablowe ménsébéréh bé de Judio brab de békén do Judio do méngintulus dob lawie féngadafan. Brab sénga fuweh ménsébéréh-béréh so dob fadiyane bé de étéw témara. ");
INSERT INTO tiy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ménsébéréh soy Pablowe bé de maistéro témoro bé kéfégitung i de Griego diyo féndawét Epikureo brab Estoiko. Atin ménbéréh i de dumo bero maro, “Ati béréhéy nan félangka-langka étéw énda i gétiga-tiga no?” Atin bang i de dumo de, “Béréhé no keeyén i de tulus dob de ségiyo ingéd.” Bénréh roy ni non nuret Pablowey fantage bé Jesuse brab kétébulee. ");
INSERT INTO tiy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mélaw nuwit roy Pablowe mangéy dob adafay de ménlimud do odoron, sani féndawét ruwe Areopayo brab ménbéréh ro maro, “Méuyot gey gétigan fantag bé ni mantu kétoro béréhé mo. ");
INSERT INTO tiy_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Enda gésobuto key i de dumo bé de kébéréhém non toow fo ségiyo bé kageye kéfégitung. Brab méuyot gey de ké gétiga key i atag i de ni.” ");
INSERT INTO tiy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Loo bé niy kébéréh ruwe non i kéluhanay de étéw dob Atenas brab de étéw tidéw dob de ségiyo ingéd bati diyo, méuyot ro mégélingo brab séuret-uret bé de mantu uret sénga tékélid.) ");
INSERT INTO tiy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mélaw téménindég i Pablowe dob téngaangay kéluhanay de odoron diyo ménlimud. Atin ménbéréh mano, “Do étéw dob Atenase ni, énggito gu toow gom fo mégéror méngadaf. ");
INSERT INTO tiy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Non amun ménsugud-sugudu dob kagome ni ingéd brab ténéngténg guy de gono kom méngadaf, énggito guy sébaane gono kom méngadaf témulak. Wén i sénulate de mano, ‘Dob ni, féngadafén i tuluse énda gélolono.’ I nan féngadafé kom fiyon fo ké énda gélolo gom de, Been i ni ureté ku begom. ");
INSERT INTO tiy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","I Tuluse léménimbag bé duniyae ni brab kéluhanay éntingayéne. Been i Kadnay lawaye brab duniyae. Atin énda batién dob de lawi rénigoy kéilawane. ");
INSERT INTO tiy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Atin énda i éntingayén kailanga no géiray i étéwe de tidéw dob de génalbéko no. Non Beeney méniraye bé kéuyage brab férénawawe dob kéluhanay de étéw brab Been soy miraye bé kéluhanay éntingayéne kailanga tom. ");
INSERT INTO tiy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tidéw dob ségétéwe étéw, rénigo noy kéluhanay de séségiyo-giyo do étéw brab bénragarén betom dob duniyae ni. Atin Been i ménémilie bé de gai tom brab de gono tom bati. ");
INSERT INTO tiy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Rénigo noy ni inok i de étéw sélédé roy Tuluse brab dob késéléd ruwe de, gito ro so keeyén. Endob i toowe, énda mérayu i Tuluse dob betome do étéw. ");
INSERT INTO tiy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Non tidéw dob Beeney kéuyag tome brab férénawa tome brab kégéagéw tome.’ Loo so bé niy bénréh i de dumo gom do muret binuwaya maro, ‘Betome soy de ngaén.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Atin féntaus Pablowey kébéréh ne mano, “Non betom i do nga i Tuluse, katom karangén de ké i falas i Tuluse loo bé falas i de kéninontow do bélowon taloo no do filak taloo no do batéw rénigoy kéilawane. ");
INSERT INTO tiy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Féndaya i Tulusey éndae kégéloloy de étéw de bé do gétah, brab énda kénukumén bero. Endob béleewe ni sénuguén i kéluhanay de étéw dob kéluhanay de ingéd bé fatut ro gésénule bé de tete rigoné ro brab fatut tagaké ro. ");
INSERT INTO tiy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Non fénémili i Tuluse nén i gaiwe ké kukumé non i kéluhanay de étéw dob duniyae ni bé toowe fo métintu. Atin i fékukumé nuwe Been i fénémili ne. Atin fénggélolo noy ni dob kéluhanay de étéw bé kéfétébule ne de tidéw bé kéléhu ne.” ");
INSERT INTO tiy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","I de dumo bé de étéw diyo, amun énggélingoo roy kébéréh Pablowe fantag bé kétébulee, déniyangka roy Pablowe. Endob i de dumo de ménbéréh ro maro, “Méuyot gey man mégélingo beem muret féruman fantag bé de ni.” ");
INSERT INTO tiy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mélaw méntékédan i Pablowe tidéw dob de ménlimud ni do étéw. ");
INSERT INTO tiy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Atin i de dumo bé de étéw ni ménwaléy ro munur bé Jesuse brab nodoro roy Pablowe. Ségétéw beroy lagéye féndawét Dionisio, ségétéw kéfédéwan diyo. Brab ségétéw so libun féndawét Damares brab wén soy do ségiyo do étéw do ménunur. ");
INSERT INTO tiy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Amun énggilid i ni, méntékédan i Pablowe dob Atenas brab ménangéy dob ingéde féndawét Korinto. ");
INSERT INTO tiy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Diyo énggébalaka noy ségétéwe Judio féndawét Akila tidéw Ponto. Mantu séna énggumah tidéw Italia beroy bawag ne féndawét Prisila, non i datue féndawét Klaudio, féntékéda noy kéluhanay de Judio diyo dob Roma. Atin nangéy Pablowe bero lénangu. ");
INSERT INTO tiy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Atin ménbati diyo non ségiléw i galbék ruwe Akilawe rémigo tulda. Brab ténabanga no bero gémalbék. ");
INSERT INTO tiy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sénga gai kétérén, ménangéy i Pablowe dob lawie féngadafay de Judio, atin ménsébéréh bé de étéw diyo inok i de Judio brab de békén Judio waléy ro géunur bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Amun énggumah i ro Silase brab Timoteowe tidéw Masedonia, éndaén géménalbék i Pablowe saliyu bé kéuret ne fantag bé Jesuse. Nuretén dob de Judioy Jesusey Kristowe, sani fénémili i Tuluse méguléw. ");
INSERT INTO tiy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amun ménwaléy ro sébanil bé Pablowe brab bénrého ro do tete, ténagtag Pablowey de bubuk sébuwan dob kégal ne, brab ménbéréh mano, “Békénén kagén aturan ké énda méfukas gom. Yamula do begom soy séndito kom de. Tidéw béleewe ni mangéyun muret dob de békén Judio.” ");
INSERT INTO tiy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mélaw méntékédan diyo brab ménangéy bati dob lawi i ségétéwe lagéy békén Judio méngintulus féndawét Titio Justo. Ménsédoror i lawi ne dob lawie féngadafay de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Atin i lagéye féndawét Krispo, beeney méguléwe bé lawie féngadafan. I ni lagéy tintu fo ménunur bé Kadnane, loo soy kéluhanay de samungén. Atin wén i de médoo do ségiyo étéw dob Korinto énggélingoo roy Fiyowe Uret, brab ménunur ro brab ménfébautis ro. ");
INSERT INTO tiy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Wén i no sébaan kélungonon, i Pablowe wén i énggétéginéfo no brab i Kadnane ménsébéréh de mano, “Kago mégilak! Fétausém i kéuret me. Fiyon fo ké ati mérigowe, kago térénon i galbék me. ");
INSERT INTO tiy_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Non démoyunu modor beem. Enda gésug-sug go non médooy de kagén étéw dob ni ingéd.” ");
INSERT INTO tiy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mélaw ménbati diyo bé rugay i ségébélintuwae bra ném gétérésang kélungonon témoro bé kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amun ménwaléy gobernador i lagéye féndawét Galion dob Akaya, ménsélimud i de Judio brab kénéfo roy Pablowe brab nuwit ro dob adafay gobernadore ni inok kukumé no. ");
INSERT INTO tiy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Atin bénréh ro maro, “I ni lagéy, féféngintulusé noy de étéw bé békéne fatut dob kitab geye.” ");
INSERT INTO tiy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Amun émbéréhén damén i Pablowe, ménbéréh i gobernador Galione dob de Judio mano, “Amuk tete i rénigo nuwe taloo no énda nodoro noy kukumay de Romano, fakay gétingkélo ku begom do Judio brab begén i kémukum de. ");
INSERT INTO tiy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Endob i de ni funa kom de sébanil, been say fantage bé de dawét brab de kébéréh dob kagome kitab. Mélaw begom séden i kémukum de, non békén begén i kémukum de.” ");
INSERT INTO tiy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Brab féntékéda no bero dob gonone ni kémukum. ");
INSERT INTO tiy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tidéw béno, kénéfo roy lagéye méguléw bé lawie féngadafay de Judio féndawét Sostenes brab lénubag ro dob téngaangay gonone kémukum. Endob féndaya Galione saén, brab énda méntete i fédéw ne de. ");
INSERT INTO tiy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Amun ménggilid i ni, ménbati nay Pablowe dob Korinto bé ménfiroye gétérésangan. Tidéw béno, ménggétaw dob de dumo no munur bé Kristowe. Amun énggumah dob Senkrea, ménfétébungow non méntumanén i fasade rénigo no. Tidéw béno, ménda barko bero ro Prisila brab Akila mangéy Siria. ");
INSERT INTO tiy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Amun énggumah ro dob Efeso, ténagak Pablowey ro Akilawe brab Prisilawe atin ménangéy dob lawie féngadafay de Judio. Atin diyo ménsébéréh bé de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Atin nongot ro dob beene ké férugay na bati dob berowe. Endob énda ménagayu no. ");
INSERT INTO tiy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Yamula amun mégétawén, bénréhén bero mano, “Amuk kétayay Tuluse, séfuleu so mangéy dini.” Tidéw béno, ménda barko brab méntékédan dob Efeso. ");
INSERT INTO tiy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Amun déménunggu dob Sesaria ménangéy i Pablowe Jerusalem inok angéyé no ségifaén i de munur bé Kristowe diyo. Tidéw béno, méntaus mangéy Antiokia. ");
INSERT INTO tiy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Atin ménbati saén diyo bé ménfiroye géfadiyan. Tidéw béno ménagéwén man. Atin ménawét man dob de gonon dob sakuf i de ingéd féndawét Galasia brab Frigia brab fénégétén i kéunur i kéluhanay de kuyug Jesus diyo. ");
INSERT INTO tiy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Atin wén i ségétéwe Judio féndawét Apolos tidéw Alejandria, énggumah dob Efeso. Toow fo fiyo muret brab tintu fo gétiga noy Ménsulate Kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Méntoro fo bé fantage bé Agéwoy Kadnane. Atin toow fo émbagér i kéuret ne brab kétoro ne fantag bé Jesuse. Katabuwan fo brab toow i kétoro ne, éndob i gétiga nuwe saén i kébautis Juane. ");
INSERT INTO tiy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Atin méngganay fébaraw émbéréh dob lawie féngadafay de Judio diyo, atin énggélingoo ro Akilawe brab Prisilawe. Mélaw nuwit ro mangéy dob lawi ruwe brab nuret ro dob beeney kéluhanay éndae séna gétiga no fantag bé Agéwoy Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tidéw béno, ménuyot i Apolose mangéy Akaya. Mélaw i de dumo no munur bé Kristowe dob Efeso, ténabanga ro atin séménulat ro dob de dumo ro munur bé Kristowe dob Akaya inok tayakufé ro ké gégumah diyo. Atin amun énggégumah i Apolose diyo, toow fo dakél i kétabang ne bé de étéw do ménwaléy munur bé Kristowe sabaf bé kégédaw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Non tabanan i de Judio de ké séédél ro dob téngaangay de médoo étéw. Non tidéw dob Ménsulate Kébéréh i Tuluse fénggélolo noy Jesuse, Beeney Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Amun diyo i Apolose dob Korinto, i Pablowe ménawét dob de ingéd fingé dagé taman énggumah dob Efeso. Atin diyo énggito noy de dumoy de kuyug Jesus. ");
INSERT INTO tiy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Brab fénénginsaa no bero mano, “Amun munur gomén, aw énggumahén i Rémogor i Tuluse dob begome?” Séménumbul ro maro, “Enda gétiga key de ké wén i Rémogor i Tuluse.” ");
INSERT INTO tiy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Atin ménénginsa man i Pablowe mano, “Ati funa kome ménfébautis?” Séménumbul ro maro, “Ménfébautis gey bé Juane inok fégito gey i kéunur geye bé kétoro ne.” ");
INSERT INTO tiy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Atin ménbéréh man Pablowe mano, “I kébautis Juane, been i nan i fégélolonone bé kégésénule i de étéw bé de sala ro. Atin bénréh Juane dob de Judio bé fatut ro munur bé étéwe gégumah gétundug de, sani Jesuse.” ");
INSERT INTO tiy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Amun énggélingoo roy ni, ménfébautis ro inok fégito roy kéunur ruwe bé Kadnane Jesus. ");
INSERT INTO tiy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Atin ténégé Pablowe bero atin énggumah i Rémogor i Tuluse dob berowe. Atin énggésébéréh ro bé de ségiyo késébéréh énda gétiga ro de brab nuret roy kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Gédét ro folo bra ruwo gétéw diyo. ");
INSERT INTO tiy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bé rugay i méntéléwe gétérésang kélungonon diyo, i Pablowe démoyunén mahur dob lawie féngadafay de Judio brab ménsébéréh bé de Judio diyo. Atin toow fo émbaraw muret émféunur bero bé kéféguléw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Endob i de dumo bero toow fo métégas i de uléw ro, mélaw mika ro munur. Atin ménbéréh ro na tete fantag bé Agéwoy Kadnane dob téngaangay kéluhanay de étéw ménlimud. Mélaw méntékédan i Pablowe diyo brab nuwitén i kéluhanay de kuyug Jesus. Atin féntausén i kétoro ne bero dob sékuwelahane ka Tiranowe sénga fuweh. ");
INSERT INTO tiy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Atin téménoro diyo bé ménruwowe gébélintuwa. Mélaw i kéluhanay de étéw bati dob Asia, do Judio brab do békén Judio, énggélingoo roy kébéréh i Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Atin fénrigoy Tuluse do médoo mékégaif i Pablowe. ");
INSERT INTO tiy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Fiyon i de munsala brab do tuwaliya nusar Pablowe, uwitén dob de déméruun atin waléy ro adi-adi brab i de saitan réménahuk dob de étéw, ménraréy ro. ");
INSERT INTO tiy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Atin wén i do Judio démoyun magéw brab do démédél saitan réménahuk dob de étéw. Atin ténulama ro nusar i dawét i Kadnane Jesus fégédédél ro saitan. Ménbéréh ro dob de saitan maro, “Dob dawét Jesuse sani ureté Pablowe, sugué key beem méraréy.” ");
INSERT INTO tiy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","I de dumo bé de ni do lagéy réménigo bé de ni, been i de fitéw gétéw nga i ségétéwe gérotor fadi i de Judio féndawét Eskeba. ");
INSERT INTO tiy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Endob dénawaay saitane bero mano, “Gélolo guy Jesuse brab Pablowe, éndob ati begoma nan?” ");
INSERT INTO tiy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tidéw béno, sénayaway lagéye bero rénahukoy saitane brab énda énggégaga ro bé ni lagéy. Atin lénubagén bero. Mélaw ménraréy ro tidéw dob lawi ne ménfali brab ménlékas ro. ");
INSERT INTO tiy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Atin i kéluhanay de étéw bati dob Efeso, do Judio brab do békén Judio énggélingoo roy fantage bé ni. Mélaw toow ro fo ménggilak. Atin ménumanan i kébantug i dawét i Kadnane Jesus. ");
INSERT INTO tiy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Atin médoo soy de munur bé Kristowe ménangéy dob téngaangay de étéw atin ménémayag bé de tete rigoné ro. ");
INSERT INTO tiy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Atin i de dumo bero do béliyan nuwit roy de nusar ro do libro béliyan. Atin ténambak ro bero brab ténuwég ro dob téngaangay de étéw. Atin bénilang ro ké firoy i laga i de ni do libro, énggégumah limo folo ngibu dob karowe kurta. ");
INSERT INTO tiy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Atin loo bé niy kélalag i kébéréh i Kadnane dob de étéw diyo, brab minut médooy de étéw munur de. ");
INSERT INTO tiy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Amun énggilid i de ni, ménuyot magéw i Pablowe mawét dob de gonon sakuf i de ingéd féndawét Masedonia brab Gresia mangéy Jerusalem. Brab ménbéréh i Pablowe mano, “Amuk gégumahu dob Jerusalem, fatutu so mangéy Roma.” ");
INSERT INTO tiy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Endob fénétah Pablowey de ruwo gétéw témabangan de ro Timoteo brab Erasto mangéy Masedonia. Atin i beene ménbati na dob Asia. ");
INSERT INTO tiy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Bé do no do gai, toow fo mégukét i de étéw dob Efeso sabaf bé Agéwoy Kadnane. ");
INSERT INTO tiy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Diyo wén i ségétéwe lagéy fanday féndawét Demetrio, méndot médoo do étéwén rémigo do kéninontow do filak. Atin i de ni kéninontow rénigo ro loo bé lawie féngadafan bé libune tulus ro féndawét Diana, atin fébéléy ro brab gégédot ro de médoo kurta. ");
INSERT INTO tiy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tidéw béno, i ni fanday féndawét Demetrio ténawagén i kéluhanay de étéwén rémigo do kéninontow beroy de dumo ro na géségiléw galbék brab bénréhén dob berowe mano, “Gétiga kom i funa tome kawasa non bé ni galbék tom do rémigo kéninontow. ");
INSERT INTO tiy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Endob énggito gomén brab énggélingoo komén i rigoné Pablowe ni. Bénréhén dob de étéw, i de tulus do rénigo tom békén kun tintu tulus. Atin médooy de étéw énggéféunurén. Békén saén dob ingéd tome ni Efeso, éndob loo soy kéluhanay de ingéd dob Asia. ");
INSERT INTO tiy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mélaw mébinasa keeyén i katome ni galbék sabaf bé nan kétoro, non émbéréh tete i de étéw fantag bé katome ni galbék. Brab saliyu na bé nan, tagakéy de étéw moso i lawie féngadafa tom bé libune tulus Diana. Atin been i nan i funay ménbantuge tulus Diana mékédan. Beeney féngadaféy kéluhanay de étéw dob ingéde Asia brab dob duniyae ni, éndob éndaén mosoén fégadata ro de.” ");
INSERT INTO tiy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","I de ménlimud do étéw, amun énggélingoo roy ni, toow fo ménkérit ro brab ménkes ro maro, “Toow fo ménbantug i Dianahe sani tulus tome do tidéw Efeso.” ");
INSERT INTO tiy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tidéw béno, rénimbur roy ingéde. Atin kenéfo roy ruwowe gétéw lagéy tidéw Masedonia ménodor bé Pablowe féndawét Gayo brab Aristarko. Atin fénagayas ro nuwit mangéy dob dakéle lawi dob adafay de ménlimud do étéw. ");
INSERT INTO tiy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Atin i Pablowe méuyot damén mangéy so dob adafay de ménlimud ni do étéw. Endob i de dumo no munur énda fénagéw ro de. ");
INSERT INTO tiy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Atin i de dumo bé de méguléw dob Asia sani de dumo Pablo, ménféuwit ro kébéréh nongot ro so bé békén mangéy i Pablowe dob adafay de étéw ni ménlimud. ");
INSERT INTO tiy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Atin toow fo ménrimbur i kéluhanay de étéw ni ménlimud atin kéluhana ro mékes séségiyo-giyoy béréhé ruwe, non i kédoono ruwe énda gétiga roy funa ruwe ménsélimud. ");
INSERT INTO tiy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","I de dumo bero marok Alejandrowey funa ruwe ménsélimud non féntindég i de Judio dob adafay de étéw. Atin i Alejandrowe séniniyasa noy de étéw bé békén ro selekén inok émbéréh bé mamfil so dob berowe. ");
INSERT INTO tiy_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Endob amun énggétiga ro Judio soy beene, ménkes ro séréngan bé ménruwowe géuras maro, “Toow fo ménbantug i Dianahe, sani tulus tome do tidéw Efeso.” ");
INSERT INTO tiy_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tidéw béno, i ségétéwe bé de méguléw bé ni ingéd, féntanékén i de étéw brab ménbéréh mano, “Do dumo gu dob Efesowe ni, i kéluhanay de étéw énggétiga ro dob Efesowe niy gonoy lawie féngadafan bé ménbantuge tulus Diana brab mékétéfuwe batéw ménlawu tidéw dob lawayo. ");
INSERT INTO tiy_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Enda i gédirung de. Mélaw kagomén mékérit taloo no rémigo gom tete bé éndae métayéw funa no. ");
INSERT INTO tiy_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nuwit gom diniy de étéw ni fiyon fo ké énda mon ménénakaw ro dob de lawi féngadafan taloo no ménbéréh ro tete fantag bé tulus tome Diana. ");
INSERT INTO tiy_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mélaw i Demetriowe beroy de dumo no fanday, amuk wén i téboé ro, fatut ro mangéy dob de kémukum bé fatute gai. Atin fakay témbo ro diyo. ");
INSERT INTO tiy_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Endob amuk wén nay ségiyo kétaya kom, fakay fétiyawa kom bé kéluhanay de étéw sélimud begey do odoro kom. ");
INSERT INTO tiy_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Non fakay betom i météboe bé ni késérimbur ménrigo béleewe ni. Brab énda géséliyah tom de non énda foy funa tom mérimbur.” ");
INSERT INTO tiy_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Amun énggilid bénréhén i ni, fénuleén i kéluhanay de étéw. ");
INSERT INTO tiy_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Amun éndaén sérimbur ro, féntawag Pablowey kéluhanay de munur bé Kristowe inok sélimud ro. Atin fénbagérén i de fédéw ro bé kébéréh ne. Tidéw béno, ménggétawén dob berowe brab ménagéw mangéy Masedonia. ");
INSERT INTO tiy_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nangeyén ténukaw i de ingéd diyo brab fénfiyo noy fédéw i de munur bé de kétoroén. Atin méntaus magéw taman énggumah dob Akaya. ");
INSERT INTO tiy_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Atin ménbati diyo téléw gétérésang kélungonon. Amun magéwén damén mangéy Siria, énggélingoo noy bénantak i de Judio diyo féléhué ro. Mélaw ménséfule i Pablowe témara bé Masedoniawe. ");
INSERT INTO tiy_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Atin wén i de lagéy de ménodor ro Sopater nga Piro tidéw Berea, ro Aristarko brab Segundo tidéw Tesalonika, Gayo tidéw Derbe, brab Timoteo, brab Tikiko brab Trofimo do tidéw Asia. ");
INSERT INTO tiy_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","I de ni do lagéy méntah ro mangéy Troas atin nongot-nongot ro begey diyo. ");
INSERT INTO tiy_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Amun énggilid i kékandulione bé kéamae bé fane énda i fénggéfééruk de, ménda gey barko tidéw Filipos mangéy Troas. Ménlimo gétérésangan tidéw bé no, énggumah gey dob Troas atin diyo énggumaha key i de dumo gey. Atin ségéfadiyan gey ménbati diyo. ");
INSERT INTO tiy_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Bé sunguwe fuweh bé no fadiyan, ménsélimud gey mama bé fane émfégétédém bé kéléhu Jesuse. Atin i Pablowe ménuret toow fo mérugay énggumah kérara kélungonon, non magéw so bé démoe de. ");
INSERT INTO tiy_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Atin médooy de solo dob sibéye dob rotor i lawie gono key ménsélimud. ");
INSERT INTO tiy_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","I nan sibéy, been i toowe fo gérotor dob lawie ni téléw géandana i kégérotor ne. Wén i kénogo lagéy diyo féndawét Eutiko, ménsar dob faliluwangay gérotore ni sibéy. Endob énggéfidong i ni kénogo lagéy, non toow fo métaah i uret Pablowe. Tidéw béno, ménlawu mangéy fantad tidéw dob gono nuwe ni ménsar brab ménléhu. Atin amun nangéy ro fénurut, énggito ro ménléhuén. ");
INSERT INTO tiy_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Endob ménlus soy Pablowe brab fénagayasén nangéy nékéf. Brab ménbéréh mano, “Kagom émbuku, méuyag so!” ");
INSERT INTO tiy_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tidéw béno, ménénik man i Pablowe brab sénkébeng-kébengén i fane atin ménama. Atin féntausén i kéureto nuwe bero taman sémbangén i térésange. Tidéw béno, ménagéw i Pablowe. ");
INSERT INTO tiy_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Atin nuwit i de étéw mule i kénogo lagéye ni méuyag. Atin ménfiyoy de fédéw ro non ménuyag so. ");
INSERT INTO tiy_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tidéw béno, ménsésuway gey bé Pablowe dob Troas, atin ménda gey barko mangéy Asos. Diyo nongot-nongot gey i Pablowe loo bé késugu ne begey, non ménuyot mémantad tidéw Troas mangéy Asos. ");
INSERT INTO tiy_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Amun énggéségito gey dob Asos, ménda soy Pablowe dob barkowe, atin kéluhana key méntaus mangéy Mitilin. ");
INSERT INTO tiy_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tidéw béno, ménangéy gey Kios bé démoe de. Atin bé gétunduge de fuweh énggumah gey dob Samos. Dob gétunduge de man fuweh énggumah gey dob Mileto. ");
INSERT INTO tiy_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Atin i Pablowe ménuyot de ké témara gey saén dob Efeso inok énda méanggaén dob Asia non toow fo magayas. Méuyot de ké gégumah dob Jerusalem bé gaiy Pentekostese, amuk fakay. ");
INSERT INTO tiy_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mélaw tidéw Mileto, i Pablowe ménféuwit kébéréh mangéy Efeso brab féntawagén i de odoroy de munur bé Kristowe diyo inok balaké ro. ");
INSERT INTO tiy_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Amun énggumah ronén, ménbéréh i Pablowe mano, “Enggétiga kom i kébati guwe dob begome tidéw fanay kégumah gu dob sakuf i ingéde Asia. ");
INSERT INTO tiy_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Atin gétiga kom rénigo guy galbék i Kadnane bé béno. Atin énda téfégérotoru, yamula kéménrewu sabaf bé kégédaw guwe begom. Atin téméningkélu bé kéluhanay de mérégén énggéagéwo ku bé de tete rénigoy de Judio dob begéne. ");
INSERT INTO tiy_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Enda i sébaan dénigur gu bé funa kome fiyo dob de kétoro gu begom dob adafay médoowe étéw taloo no dob de lawi gom. ");
INSERT INTO tiy_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Méégét i kébéréh guwe dob de Judio loo so dob de békén Judio bé fatut ro gésénule bé de sala ro atin munur ro bé Kadnane Jesus brab rigoné roy kétayay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Atin béleewe ni fénémanduoy Rémogor i Tuluse begén bé mangéyu Jerusalem. Atin énda gétuwa ku de ké ati mérigowe dob begéne diyo. ");
INSERT INTO tiy_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Been say niy gétuwa kuwe, dob séngae ingéd nawéto ku, i Rémogor i Tuluse féningatén begén bé méférisuwu brab mérégén i géagéwo kuwe. ");
INSERT INTO tiy_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Endob énda gulaané kuy umul guwe brab ulan den ké méléhuu, amuk géfégilid gu saén i galbéke niray i Kadnane Jesus begén, sani kéurete bé Fiyowe Uret fantag bé kégédaw i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ménangeyu dob begome kéluhanan muret fantag bé kéféguléw i Tuluse bé de étéwén. Atin gétuwa ku béni, éndaén géségito tom man ségule. ");
INSERT INTO tiy_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mélaw béréhé ku begom béleewe ni, amuk wén i ségétéw begom énda munurén bé Jesuse, békénén atura ku. ");
INSERT INTO tiy_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Non nuret gun begom i kéluhanay kétayay Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ingat gom brab diyaga gom i de lowoh gom loo soy de munur sénarig i Rémogor i Tuluse begom inok énda mékédan i de kéunur gom. Begom i maake témalima bé de bili-bili. Atin i de munur bé Jesuse beroy de maak do bili-bili. Atin i Tulusey gefee bé de bili-bili sabaf bé kéléhu i Nga ne. ");
INSERT INTO tiy_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Gétuwa ku, amuk tékédanun dini, wén i do gégumah do tugién témoro. Atin féteteé roy de fédéw i de munur. ");
INSERT INTO tiy_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Atin wén mosoy do étéw tidéw so dob begome ménlimud, émbéréh bé de tugi inok géuwito roy de munur dob békéne katabuwan agéwon. ");
INSERT INTO tiy_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mélaw ingat gom, brab kagom lifotén i de ténoro gu begom kéluhanan, fuweh na kélungonon bé méntéléwe gébélintuwa. Atin toow fo kénrewo kuy kétoro guwe begom sabaf bé kégédaw guwe begom. ");
INSERT INTO tiy_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Atin béleewe ni, sarigé ku begom dob Tuluse non tabanga no begom. Atin i kéuret guwe fantag bé kégédaw ne tabanga no so begom. Beeney émfébagére bé de kéunur gom, brab Been say miraye bé de kéfiyonon loo bé rigoné nuwe dob kéluhanay de étéwén. ");
INSERT INTO tiy_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Enda méningaru bé éntingayéne kagom, fiyon filak, taloo no bélowon taloo no kégal. ");
INSERT INTO tiy_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gétiga kom i kégalbék guwe inok gédoté kuy kéluhanay kailanga keye begey i de dumo gu. ");
INSERT INTO tiy_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Fénggito gu begom i kéluhanay de rénigo gu bé fatut mégéror tom inok gétabanga tom i de étéw mérasay. Brab katom lifotén i kébéréh i Kadnane Jesus mano, ‘Toow na fo moror i étéwe miray bé étéwe médot.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Amun énggilid i Pablowe émbéréh, ménlingkuwéd ro kéluhanan brab déménasal ro. ");
INSERT INTO tiy_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kéménrew ro kéluhanan brab nékéf roy Pablowe atin narék ro. Tidéw béno ménggétawén. ");
INSERT INTO tiy_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ménlabi foy kétete i fédéw ruwe bé bénréh Pablowe bé éndaén kun gito ro de féruman. Tidéw béno, dénura ro mangéy dob barkowe édaa no. ");
INSERT INTO tiy_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Amun énggéfégétaw geyén dob berowe, ménda gey brab méntaus gey mifar fééntang saréw dob bungéde Kos. Amun bé démoe de énggumah gey dob bungéde Rodas. Tidéw béno méntaus gey mangéy Patara. ");
INSERT INTO tiy_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Diyo énggito gey i sébaane barko mangéy Fenisia, mélaw ménda gey diyo. ");
INSERT INTO tiy_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ménagéw gey taman énggékulaya key i bungéde Siprus, atin téménara gey saén mangéy de fingé déligdigan atin méntaus gey mangéy Siria. Atin déménunggu gey dob ingéde Tiro non féntéfad roy de médoo do uwit diyo. ");
INSERT INTO tiy_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Atin diyo énggito gey i de munur bé Kristowe, mélaw ménbati gey diyo ségéfadiyan. Atin non fénémanduoy Rémogor i Tuluse bero, féngginau roy Pablowe bé békén taus mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Endob amun énggumahén i gaiwe magéw gey, méntékédan gey dob no inged. Atin i kéluhana ruwe dénura ro begey mangéy dob barkowe, bero soy de bawag ro brab de nga ro. Atin amun énggumah gey dob dénsaane, ménlingkuwéd gey kéluhanan brab déménasal gey. ");
INSERT INTO tiy_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Amun énggilid gey démasal, ménggétaw gey. Tidéw béno, ménda geyén man dob barkowe ni, atin ménule ro so kéluhanan. ");
INSERT INTO tiy_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Atin tidéw Tiro méntaus gey magéw taman énggumah gey dob ingéde féndawét Tolemaida. Diyo énggito gey i de dumo gey munur bé Kristowe. Atin téménrén gey diyo ménségétérésangan. ");
INSERT INTO tiy_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Dob gétunduge de fuweh, méntaus gey mangéy Sesaria. Amun énggumah gey diyo, ménbati gey dob lawi i ségétéwe lagéy muret bé Fiyowe Uret fantag bé Jesuse féndawét Filipi. Beeney ségétéwe bé de fitéw gétéw ménrugayén fénémili dob Jerusalem waléy témabang. ");
INSERT INTO tiy_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Atin wén i do fot gétéw do ngaén falan kénogon do muret so bé kébéréh i Tuluse. ");
INSERT INTO tiy_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ménfiroy gétérésang tidéw bé kégumah geye diyo, énggumah i ségétéwe lagéy tidéw Judea féndawét Agabo. Beeney sénarigoy Tuluse muret bé kébéréh ne. ");
INSERT INTO tiy_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Tidéw béno, ménfégédét dob begeye brab éndotén i sintoro Pablowe brab nikétén i de kaan sékéy brab de kémérén brab ménbéréh mano, “Ay niy bénréh i Rémogor i Tuluse mano, ‘I gefee bé ni sintoro ikétéy de Judio dob Jerusalem loo bé ni brab atéé ro dob de étéw békén Judio.’ ” ");
INSERT INTO tiy_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Amun énggélingoo key i ni, i begeye brab de dumo gey munur diyo ménfégédaw-gédaw gey bé Pablowe bé békén damén taus mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Endob i Pablowe séménumbul mano, “Sedek kémérew gom? Kagom fébukuén begén! Fakayun féikét dob Jerusalem brab fakayun méléhu sabaf bé Kadnane Jesus.” ");
INSERT INTO tiy_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Atin énda fo génaga gey i gémélée bé Pablowe. Mélaw téménrén gey gémélé de brab ménbéréh gey makey, “Mérigo damén i kétayay Kadnane.” ");
INSERT INTO tiy_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Amun énggilid i firoye gétérésangan, téménifés gey atin méntaus gey mangéy Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Atin wén i do ménodor begey do munur bé Kristowe do tidéw Sesaria brab nuwit ro begey mangéy dob lawi i lagéye fébatio ro begey. Been i ségétéwe lagéy tidéw Siprus féndawét Mason. Beeney ségétéwe bé de toow fo énggétah do munur bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Atin amun énggumah gey dob Jerusalem, i de dumo gey do munur bé Kristowe ménoror ro témayakuf begey. ");
INSERT INTO tiy_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Atin bé gétunduge de fuweh, i begeye Pablowe nangéy gey ténukaw i Santiagowe, sani odoroy de munur dob Jerusalem. Atin diyo soy kéluhanay de odoroy de munur bé Kristowe. ");
INSERT INTO tiy_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Amun gilid sénggifa Pablowe bero, nuretén i kéluhanay fénrigoy Tuluse de dob de békén Judio. ");
INSERT INTO tiy_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Amun énggélingoo roy ni, dénayéw roy Tuluse. Atin bénréh ro dob Pablowe maro, “Gétiga mo adih, firoy ngibuy Judiowe ménunur bé Kristowe, atin toow fo nodoro roy de kukuman tidéw dob Moisese. ");
INSERT INTO tiy_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Enggélingoo roy fantage bé kétoro me kun dob kéluhanay de Judio bati dob de ségiyo ingéd beroy de békén Judio bé békénén odoro roy de kukuma Moises. Brab bénréhém kun éndaén tulién i de nga ro taloo no odoron i adat i de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ati mélaw i fatute rigoné tom? Non gélingoo ro sékoy fantage bé kégumah me dini. ");
INSERT INTO tiy_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mélaw rigo moy ni béréhé key beem. Wén i do fot gétéw lagéy dini, réménigo ro fasad dob Tuluse loo bé adat tome do Judio. ");
INSERT INTO tiy_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mélaw odor go bero brab amung go bé adat i kéfélinise dob adafay Tuluse. Atin sukaya mo bero bé ni kéfélinis. Tidéw béno, fétébungow ro loo bé adat tome do Judio. Mélaw fégito mo dob kéluhanay étéwe bé odoro moy kukuma Moisese, inok gétiga ro kéluhanan bé békén toow i urete fantag bé beeme. ");
INSERT INTO tiy_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Endob fantag man bé de étéw do békén Judio do ménwaléy munur bé Kristowe, sénulata key bero bé békén ro mama bé éntingayéne ténulak dob de kéninontow, taloo no mama dara, taloo no mama bé éntingayéne énda ménsumbalién, taloo no ké bigaén ro.” Been i niy bénréh ro Santiagowe dob Pablowe. ");
INSERT INTO tiy_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Mélaw dob gétunduge de fuweh, nuwit Pablowey de fot ni gétéw do lagéy brab ménfélinis ro dob adafay Tuluse loo bé adat ruwe do Judio. Tidéw béno ménahur dob lawi i Tuluse, atin fénggétiga no dob de fadi i gaiy kéfégilid i kéfélinise brab kéiray ruwe tulak bé de ni fot gétéw lagéy. ");
INSERT INTO tiy_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Amun gédétén gilid i fitéwe gétérésangan, wén i de Judio tidéw Asia énggito roy Pablowe dob lawi i Tuluse. Atin rénimbur roy de étéw ni ménlimud atin kénéfo roy Pablowe. ");
INSERT INTO tiy_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ménkes ro maro, “Do dumo gey do Judio, tabangan gey! Been i niy étéwe démoyun magéw mangéy témoro dob kéluhanay de étéw dob séngae ingéd bé békén odoro roy kukumane tidéw dob Moisese. Brab sébanil betom do Judio brab lawi i Tuluse. Atin saliyu na bé ni, ménuwit do békén Judio mahur dob lawi i Tuluse ni. Mélaw fénwaléyén mékérésik i mékétéfuwe ni gonon.” ");
INSERT INTO tiy_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Loo bé niy kébéréh ruwe non énggito roy ségétéwe lagéy békén Judio féndawét Trofimo tidéw Efeso ménséodor bé Pablowe mangéy Jerusalem. Atin marok nuwit Pablowe mahur dob lawi i Tuluse ni.) ");
INSERT INTO tiy_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ménrimbur i de étéw dob Jerusalem. Atin maak dunuk i étéwe gégumah tidéw dob kéluhanay de gonon diyo. Kénéfo roy Pablowe brab génuyud ro mésut tidéw dob lawi i Tuluse. Tidéw béno, fénintu roy béngawane. ");
INSERT INTO tiy_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Amun télamané ro damén féléhuén, wén i ménangéye mélolok dob odoroy de sundalo tidéw Roma, bé mérimbur i kéluhanay étéwe dob Jerusalem. ");
INSERT INTO tiy_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Sonom so béno, i odoroy de sundalo ni, nuwitén i de sundalo no ségéta mangéy dob gonoy de étéw ni. Atin amun énggitoy de étéw ni énggumah i de sundalo beroy odoro ruwe, ténréno roy kélubag ruwe bé Pablowe. ");
INSERT INTO tiy_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tidéw béno, i odoroy de sundalo ni, ménfégédét dob Pablowe brab kénéfoén. Atin fénikétén bé de sundalo no bé ruwowe timan sangkali. Tidéw béno fénénginsaa no bero mano, “Ati ni étéw? Ati rénigo nuwe?” ");
INSERT INTO tiy_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Atin ménkes i de étéw ni séségiyo-giyoy késumbul ruwe. Atin i odoroy de sundalo ni énda énggésobuto noy ni ménrigo non toow ro fo selekén. Mélaw fénuwitén i Pablowe bé de sundalo no mangéy dob kutae. ");
INSERT INTO tiy_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Amun énggumah ron dob géday kutae, nénat i de sundaloy Pablowe non bé kékérit i de étéw ni. ");
INSERT INTO tiy_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ménfuray i de étéw ni mékes maro, “Féléhu gom!” ");
INSERT INTO tiy_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Amun gédét ron féahurén dob kuta i de sundalo ni, ménbéréh i Pablowe dob odoroy de sundalo ni mano, “Aw fakay gésébéréhu beem?” Atin séménumbul i odoroy de sundalo ni mano, “Aw gétigan go wayo sébéréh Griego? ");
INSERT INTO tiy_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Makuk beemey étéwe tidéw Egipto méngganay bé késétibohe bé de gémamak kukuman. Atin ménanangguwit fot ngibu do méméléhu do étéwén brab ménangéy ro bati dob gonone énda i do étéw de bati.” ");
INSERT INTO tiy_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Séménumbul i Pablowe mano, “I begéne, ségétéwu Judio tidéw Tarsus dob Silisia, sani ménbantuge ingéd. Aw fakay so dob beeme ké gébéréhu dob de étéw ni?” ");
INSERT INTO tiy_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Atin ténungkas i odoroy de sundalo ni. Mélaw téménindég i Pablowe dob gédane brab séniniyasa noy de étéw bé fétanék ro. Amun méntanék ronén, ménbéréh i Pablowe dob Hebreowe, sani késébéréh i de Judio. ");
INSERT INTO tiy_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Bang Pablowe, “Do dumo gu brab do lukés gu, fégélingo gom i béréhé kuwe ni bé kéamfilo kuwe bé lowoh guwe.” ");
INSERT INTO tiy_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Amun énggélingoo ro ménsébéréh dob karowe késébéréh, toow na fo ménantés ro. Atin féntaus Pablowey kébéréh ne mano, ");
INSERT INTO tiy_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“I begéne, ségétéwu Judio ménumah dob Tarsus dob Silisia. Endob dob Jerusaleme ni ménruku. Atin méngganadu dob toowe fo ménbantug témoro féndawét Gamaliel. Atin toow fo ténoroén begén bé de adat tom do Judio loo bé kukumay de katufua tom. Atin toow fo ménuyotu modor bé kétayay Tuluse ségiléw so bé begome ni béleewe. ");
INSERT INTO tiy_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Fénrasay gu brab fénléhu guy de étéw munur bé Jesuse. Atin kénéfo guy de lagéy brab do libun brab fénrisu gu bero. ");
INSERT INTO tiy_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","I gérotore fadi brab kéluhanay de kéfédéwan, gébéréh ro toow i ni béréhé ku begom. Niraya ro begén sulat mangéy dob de dumo tom Judio dob Damasko. Atin ménangéyu diyo inok kéfoé kuy de munur bé Kristowe diyo, atin uwité ku damén dob Jerusaleme ni ikétén bé sangkalie inok kukumén ro. ");
INSERT INTO tiy_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Endob amun géutuh térésang, diyou dob agéwone gédét dob Damasko. Atin méntékow wén i réndaw tidéw dob lawayo mangéy dob begéne. ");
INSERT INTO tiy_vpl VALUES ("AC22_7","074_22_7"