﻿USE sofia;
DROP TABLE IF EXISTS sofia.tiw_vpl;
CREATE TABLE tiw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tiw_vpl WRITE;
INSERT INTO tiw_vpl VALUES ("MT1_18b","070_1_18b","MAT","1","18b","18b","Awinyirra Mary amintiya nyirra-mantani Joseph awarra ngini ngarra nyirra promise api karri wuta arnuka marriti pirimi nanuwanga api awungarri ngarratuwu awarra ngawa-rringani ngini kuriyuwu yini-pangirri (sent) ngini-ngatawa pukwiyi (Holy Spirit) kapi awinyirra Mary, kiyi ngini-ngatawa power awarra pukwiyi yikirimi awinyirra Mary ngini nyirra papuringanta jiyima. ");
INSERT INTO tiw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Awarra Joseph karluwu yimajawu ngini awarra pukwiyi ngini-ngatawa power yikirimi awinyirra Mary papuringanta api karri yipakuluwunyi awinyirra Mary ngini nyirra waya papuringanta api ngarra amparrimani yuwarimi ngini ngarra nyoni tini yipirrakirayi awinyirra api yimi kangatamiya ngini, “Tani-waya (no matter) nyirra jiyimarrimili nyoni tini api ngiya karluwu ngimata-marruriyi (won't take) awinyirra kapi awuta alawuruwi kapi jurra ngini ngimata-jiyarra awuta ngini nyirra juwuriyi kapi nyoni tini.” Awarra yimi Joseph kangatamiya. Kiyi yimi ngini, “Ngiya karluwu ngimata-kirimi ngiya-mantanga arliranga. Waya juwa nguwutiyarra awinyirra ngini ngiya waya karluwu ngiya-mantanga awinyirra amintiya ngawa wiyi karluwu marriti ngamatami,” yimi Joseph kangatamiya. Ngarra pupuni tini awarra Joseph api ngarra arnuka yuwutimarti ngini arliranga yimata-kirimi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kiyi awarra Joseph yuwuriyi japuja kiyi yipungintayi (thought about) ngarra-mantanga Mary. Api karri ngarra yimajirripi api tirimini yimi (dreamed) ngini yati ngawa-rringani ngini-ngatawa yingumpunila (angel) papi yimi kangatawa api awarra yingumpunila yimi kangatawa, “Aya, Joseph,” yimi. “Ngajiti nimpaja-mwari awinyirra Mary pili awarra ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) waya yini-papirraya (came down) kangi nyitawa api ngini-ngatawa power waya yikirimi awinyirra papuringanta. Yita arnuka tini yipirrakirayi awinyirra Mary,” yimi awarra yingumpunila kapi awarra Joseph. ");
INSERT INTO tiw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kiyi awarra yingumpunila nyoni ngirramini yipangiraga ngini, “Karri awarra kirijini wiyi arimulungurrumi api nginja awungarri yintanga tayakirayi Jesus pili awarra yintanga Jesus meaning arimi ngini ngarra awarra wiyi awunyawu awarra jirti ngini awuta tiwi pirikirim-ani (the wrong they have done), awuta kapi ngawa-rringani wiyi arimamula (call) awuta ngarra-mamirampi api wuta wiyi yiloti wurumuwu kuriyuwu kangatawa japuja. Api nginja tamarruriyi awinyirra Mary kapi nginjila japuja api nginja wiyi nginja-purnayinga awinyirra Mary,” yimi awarra yingumpunila kangatawa awarra Joseph karri ngarra tirimini yimi (dreamed). ");
INSERT INTO tiw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25a","Api karri awarra Joseph yipangipari api kuwa yimi awarra ngirramini ngini awarra yingumpunila yipangiraga api yuwuriyi kapi awinyirra Mary kiyi yimarruriyi awinyirra kapi ngatawa japuja amintiya ngarra yiloti ngarra-purnayinga yimamula (called) awinyirra Mary. Wuta karluwu pirimarrimili nanuwanga. Waya juwa karri nyirra-mwarti wiyi (later on) yimulungurrumi api awungarri wuta pirimarrimili. Awarra ngirramini ngini (about) karri awinyirra Mary nyirra-mwarti yimulungurrumi api ngarra ngawa-rringani parlingarri yuwutiyarra awarra ngirramini kangi awarra prophet Isaiah. Api kiyi awarra Isaiah yikirimi kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) awarra naki ngirramini ngini, “Nyirra natinga murrukupora angi nyirra arnuka jiyimarrimili awurrini api nyirra wiyi papuringanta ampirimi api nyirra wiyi yati kirijini ampurtiyi. Wuta wiyi wupakirayi yintanga awarra kirijini Immanuel.” Awarra Isaiah yikirimi awarra ngirramini kangi awarra punkaringini. Api awarra yintanga Immanuel meaning arimi ngini, “Awarra ngawa-rringani yini-papirraya (came down) kapi ngawa tiwi api ngawa waya ningani ngawa-rringani ngawiyati ngarimuwu kapi awungarra naki murrakupuni (on the earth).” Awarra ngirramini ngini ngarra awarra Isaiah yikirimi kangi awarra punkaringini api awarra wiyi warntirrana yima (later became true) karri ngawa-yuwuni Jesus yimulungurrumi. ");
INSERT INTO tiw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","3","Karri awarra kirijini Jesus yimulungurrumi kapi awarra town Bethlehem kapi awarra murrakupuni Judea api awungarruwu kapi nyoni murrakupuni api yingampa wawurruwi pirripakuluwunyi awuranka japalinga ngirri-ngirri jiyimi. Awuta wawurruwi api ngini-wutawa murrakupuni karrampi. Wuta pungintamuwi (clever) pili wuta pirimajawu ngini (about) awinyirra tayikuwa-nga (lots) japalinga. Api karri awuta wawurruwi pirripakuluwunyi awinyirra awuranka japalinga api wuta nimarra pirimajirri, “Ningani yati kirijini waya yimulungurrumi api karri ngarra arikulani arima api ngarra wiyi king arimi,” pirimajirri awuta wawurruwi. Kiyi wuta pirripakuluwunyi awinyirra japalinga juwuja kangi yuwunka (sky) api kiyi pirripapunya awinyirra japalinga pili purru-wutimarti ngini pimata-kuluwunyi awarra kirijini ngini yimulungurrumi. Kiyi awinyirra japalinga juwuriyi kuriyuwu kapi awarra murrakupuni Judea kiyi awungarruwu nyirra juwunjarli (stopped). Karri awuta wawurruwi papi pirimi kapi awarra murrakupuni Judea api wuta purruwuriyi kapi Jerusalem. Awarra Jerusalem yinkitayi kapi Bethlehem. Awungarruwu kapi Jerusalem wuta nimarra pirimi kapi yingampa tiwi kapi japuja pirimi awungaji, api pirimi ngini, “Awungarruwu kapi ngini-ngawula murrakupuni ngawa nginti-pakuluwunyi awinyirra japalinga angi awuranka. Api karri nginti-pakuluwunyi awinyirra japalinga api nimarra ngintiri-majirri ngini, ‘Yati kirijini waya yimulungurrumi ngini ngarra wiyi king arimi api ngawa kularlaga ngawurrami (let's look for) awarra kirijini pili-ngini ngawa ngamata-kuruwarni (thank) ngarra,’ ngintiri-majirri. Api kiyi ngawa nginti-papunya awinyirra japalinga awungarra api kapi naki murrakupuni awinyirra japalinga juwunjarli (stopped). Api maka awarra kirijini ngini ngarra wiyi king arimi kangi nuwa kapi nuwa Jews?” Awuta wawurruwi awarra nanginta pirimi awuta tiwi kapi wuta japuja pirimi kapi Jerusalem. Ngarratuwu awarra King Herod api ngarra alawura yimi kapi awuta Jews awungarruwu kapi awarra murrakupuni Judea karri awarra kirijini Jesus yimulungurrumi awungaji amintiya ngarra japuja yimi kapi Jerusalem. Kiyi karri awarra King Herod yipitingaya (heard) awarra ngirramini ngini awuta wawurruwi pirripangiraga ngini (about) awarra kirijini ngini ngarra wiyi king arimi kapi awuta Jews api awarra King Herod worry yimi pili yimi kangatamiya ngini, “Karri awarra nayi kirijini wiyi arikulani arima api kapinaki Jews arrami wiyi wutimarti ngini ngarra wiyi king yimatami kangi wuta api wuta karluwu wutimarti ngiya ngini king ngimatami,” yimi awarra Herod kangatamiya. Wutatuwu awuta Jews kapi japuja pirimi kapi Jerusalem api wuta pirimakirri pili pirimajirri, “Ngini awarra kirijini wiyi awutimarti ngini king arimi kapi ngawa Jews api awarra Herod wiyi jirti ngirramini apakirayi ngawa,” pirimajirri awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kiyi awarra Herod jingawu yimi kapi awuta priests kapi wuta alawuruwi amintiya awuta scribes ngini wuta pini-matu-wariyi kangatawa. Karri awuta priests amintiya scribes papi pirimi kangi awarra King Herod api ngarra yimi kangi wutawa ngini, “Awi,” yimi. “Awarra ngini nuwa Jews ngimpiri-mamula (call) nuwa-rringani ngini kuriyuwu api ngarra parlingarri yuwuntiyarra nuwa-ampi ngini ngarra wiyi yini-mata-ngirri (would send) awarra Christ awungarra kapi naki murrakupuni (to this earth), awarra ngini ngarra wiyi king arimi kangi nuwa Jews. Api maka awarra murrakupuni kapi wuta parlingarri pirripangiraga ngini ngarra wiyi awungaji arimulungurrumi awarra kirijini?” yimi awarra King Herod kangi awuta priests amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Api wutatuwu awuta priests amintiya awuta scribes pirimi ngini, “Marri kapi Bethlehem,” pirimi. Kiyi wuta pirimi ngini, “Parlingarri ngawa-rringani ngini kuriyuwu nimarra yimi kangi yati tini ngini ngarra prophet api yimi ngini, ");
INSERT INTO tiw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Awarra town Bethlehem kapi Judea api kirijini town amintiya tayikuwapi arikutumunuwi karluwu wurimajawu awarra town api wiyi parlinginari tayikuwapi arikutumunuwi wiyi wurimajawu awarra town pili awungarruwu yati kirijini wiyi arimulungurrumi ngini ngarra wiyi king arimi. Awarra kirijini ngarra wiyi ngatawa amintiya awuta yingampa alawuruwi kapi awarra murrakupuni Judea api wuta karlu-nara. Ngarra awarra king wiyi apamangi awuta tiwi kapi ngiya ngirimamula (call) awuta ngiya-mamirampi, awuta kapi wutiyati wuta-amini ngini ngarra yintanga Israel,’ yimi ngawa-rringani kapi awarra prophet parlingarri. Api kiyi awarra prophet yikirimi (wrote) awarra ngirramini kapi ngawa-rringani ngini-ngatawa punkaringini (Old Testament),” pirimi awuta priests amintiya awuta scribes kangi awarra King Herod. ");
INSERT INTO tiw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","8","Kiyi awarra King Herod yipangirri (sent) yati tini kangi awuta wawurruwi kapi pirripapunya awinyirra japalinga ngini ngarra awarra tini yini-mata-marruriyi awuta wawurruwi kangatawa. Api awarra tini kuwa yimi kangi awarra King Herod kiyi yiniri-marruriyi awuta wawurruwi kangatawa. Awarra Herod karluwu yuwutimarti yingampa arikutumunuwi ngini wuta pimata-majawu ngini awuta wawurruwi punuwuriyi kangatawa. Kiyi karri wuta papi pirimi kangatawa api awarra Herod nanginta yimi wuta, “Awi,” yimi. “Awungarri nuwa mampara nginti-pakuluwunyi awinyirra japalinga?” yimi awarra Herod kangi wuta. Api kiyi awuta wawurruwi purru-wutiyarra awarra King Herod karri wuta mampara pirripakuluwunyi awinyirra japalinga. Kiyi awarra King Herod yimi kangi wutawa, “Awarra kirijini ngini ngarra ngatawa api ngarra waya yimulungurrumi kapi Bethlehem api nyirru-wariyi awungarruwu kiyi kularlaga nyirrami awarra kirijini,” yimi awarra King Herod kapi awuta wawurruwi. Kiyi yimi ngini, “Karri nuwa wiyi ngumpunyayi awarra kirijini api nuwa wiyi nyirra-kupawurli awungarra kangiya api nyirra-jiyarra ngiya ngini maka japuja arimi awarra kirijini pili ngiya nguwutimarti ngini ngimatu-wariyi kangatawa ngini ngimata-kuruwarni awarra.” Awarra Herod yimi awarra kangi awuta wawurruwi kapi pungintamuwi. Api, awarra King Herod ngarra kunyani yimi ngini yuwutimarti ngini yimata-kuruwarni awarra kirijini. ");
INSERT INTO tiw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiyi awuta wawurruwi kapi pungintamuwi api purrupumwari awarra Herod. Karri wuta papi pirimi kapi turruwuni wuta tuwanga pirripakuluwunyi awinyirra japalinga. Nyirra awinyirra japalinga aringampi juwuja kapi kuriyuwu api wuta tuwanga pirripapunya awinyirra. Karri awinyirra japalinga papi jiyimi kapi awinyirra kurrampali kapi awarra kirijini yimuwu api awungarruwu awinyirra japalinga juwunjarli (stopped). ");
INSERT INTO tiw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Karri awuta wawurruwi pirripakuluwunyi awinyirra japalinga juwunjarli api wuta kukunari pirimi. ");
INSERT INTO tiw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kiyi awuta wawurruwi, karri papi pirimi awungarruwu kapi awinyirra kurrampali api pirripawuriji yilaruwu. Api karri pirripakuluwunyi awarra kirijini amintiya ngarra-naringa api wuta pirripamukuri ngini-wutawa yirrara yimpula kapi yakuluwuni (knelt down) yinkitayi kapi awarra kirijini. Kiyi wuta pirripakirayi awarra kirijini awarra oil ngini pupuni aruwanti amintiya gold amintiya awarra arramu-kamini ngini ngini-ngatawa kumurrupuni aruwanti pupuni (incense). Kiyi wuta purrupumwari awarra kirijini amintiya ngarra-naringa amintiya Joseph. ");
INSERT INTO tiw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Karri japinamini karri awuta wawurruwi pirimajirripi api wuta tirimini pirimi (dreamed) ngini ngawa-rringani yuwuntiyarra awuta ngini karluwu pimata-kupawurli kapi awarra Herod. Kiyi karri japinari awuta wawurruwi pirripangipari api wuta kuwa pirimi awarra ngirramini ngini ngawa-rringani yipangiraga api wuta purruwuriyi angi nyonga jarrumoka karri pirripakupawurli kapi ngini-wutawa murrakupuni. ");
INSERT INTO tiw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Karri awuta wawurruwi kapi pungintamuwi (clever) purrupumwari awarra murrakupuni Judea api karri japinamini awarra Joseph yimajirripi api ngarra tirimini yimi (dreamed) ngini yati yingumpunila (angel) yinuwuriyi kangatawa. Kiyi awarra yingumpunila yimi ngini, “Kutupi tami api tamarruriyi nginja-purnayinga Mary amintiya nyirra-mwarti Jesus karrampi kapi nayi murrakupuni Egypt. Kalikali tamakirrimi awungarruwu pili awarra Herod wiyi kularlaga arimi awarra kirijini ngini pajuwani yimata-kirimi ngarra. Api karri nuwa papi ngimpirimi kapi Egypt api tangarima takirimi awungarruwu. Ngiya wiyi tuwanga nguwunu-wuriyi kanginjila kiyi wiyi nguwujiyarra nginja karri nginja wiyi nimpini-majakupawurli (bring back) nginja-purnayinga amintiya nyirra-mwarti awungarra.” Awarra yingumpunila yimi awarra kangi Joseph. ");
INSERT INTO tiw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kiyi awarra Joseph yipangipari kutupi yimi kiyi yuwunga ngarra-purnayinga amintiya awarra kirijini kiyi wuta yartipili purrupumwari Bethlehem. Kiyi wuta purruwuriyi awungarruwu kapi Egypt. ");
INSERT INTO tiw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Api karri awarra Herod nanuwanga yimpangini yimi (still alive) amintiya yimuwu kapi Jerusalem api awarra Joseph amintiya awinyirra Mary amintiya awarra kirijini Jesus purumuwu awungarruwu kapi Egypt. ");
INSERT INTO tiw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ngarratuwu awarra King Herod api karri ngarra yipitingaya (heard) ngini awuta wawurruwi kapi wuta pungintamuwi pirripakupawurli kapi ngini-wutawa murrakupuni kapi nyonga jarrumoka api jurrumumi jiyimi angatawa yiminga (became angry) pili wuta karluwu pinipakupawurli kangatawa. Kiyi ngarra yipungintayi (thought about) awarra ngirramini ngini awuta wawurruwi kapi wuta pungintamuwi purru-wutiyarra ngarra ngini karri wuta mampara pirripakuluwunyi awinyirra japalinga. Api ngarra yimi kangatamiya ngini, “Arrami ngarra waya yinkitayi yirrara pakitiringa (years old) awarra kirijini ngini ngarra ngatawa,” yimi kangatamiya. Api kiyi ngarra jingawu yimi kapi yingampa soldiers kapi waki pirimi ngini (for) ngarra kiyi yimi kangi wutawa, “Nyirru-wariyi kapi Bethlehem kiyi kularlaga nyirrami awuta tayikuwapi (all) kakirijuwi kapi jajingaruwi awuta kapi wuta yirrara pakitiringa (years old) amintiya awuta jajingaruwi kapi wuta wurimarnuwa amintiya awuta kapi wuta wurimangapa pularti api karri ngumpunyayi awuta kakirijuwi api pajuwani nyirra-kirimi awuta.” Awarra Herod yimi awarra kangi awuta soldiers. Api awuta soldiers kuwa pirimi awarra ngirramini ngini Herod yipangiraga api kiyi purruwuriyi kapi Bethlehem api piripirni awuta kakirijuwi kapi jajingaruwi. ");
INSERT INTO tiw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kiyi awarra Herod ngini ngarra king kapi Judea api ngarra pajuwani yimi. Api awungarri awarra Joseph amintiya awinyirra Mary amintiya awarra kirijini Jesus wuta nanuwanga (still) japuja pirimi awungarruwu kapi Egypt. Kiyi karri japinamini awarra Joseph yimajirripi api tirimini yimi (dreamed) ngini awarra yingumpunila (angel) tuwanga papi yimi kangatawa ");
INSERT INTO tiw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","api yimi ngini, “Aya, Joseph, kutupi tami api tamarruriyi nginja-purnayinga amintiya nyirra-mwarti api tayakupawurli kapi ngini-nginjila murrakupuni Israel, pili awarra Herod ngini ngarra yuwutimarti ngini pajuwani yimata-kirimi awarra niyi kirijini api ngarra waya pajuwani yimi.” Awarra yimi awarra yingumpunila kapi awarra Joseph karri ngarra tirimini yimi. ");
INSERT INTO tiw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Api kiyi ngarra Joseph kuwa yimi kapi awarra yingumpunila yipangiraga kiyi yimaja-kupawurli awinyirra Mary amintiya nyirra-mwarti kapi awarra murrakupuni Israel. ");
INSERT INTO tiw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kiyi karri wuta waya yinkitayi pirripakupawurli kapi Bethlehem kapi awarra murrakupuni Judea api awarra Joseph yipitingaya (heard) ngini awarra Herod ngarra-mirani Archelaus ngarra waya alawura yimi kapi Judea api ngarra awarra Joseph yimakirri. Kiyi awarra yingumpunila (angel) tuwanga papi yimi kangi Joseph karri ngarra tirimini yimi kiyi yimi kangatawa, “Ngajiti nimpaju-wariyi kapi Bethlehem.” Api karri awarra Joseph yipitingaya awarra ngini awarra yingumpunila yipangiraga api ngarra yimarruriyi ngarra-purnayinga amintiya nyirra-mwarti awungarruwu kapi awarra murrakupuni Galilee. ");
INSERT INTO tiw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Awungarruwu kapi Galilee wuta purruwuriyi kapi awarra town Nazareth kiyi awungarruwu wuta yiloti japuja pirimi. Karri ngawa-yuwuni Jesus japuja yimi kapi awarra town Nazareth api awarra ngirramini ngini ngarra ngawa-rringani parlingarri yuwuntiyarra awuta prophets ngini awarra Christ wiyi japuja arimi kapi Nazareth api awarra ngirramini awungarri warntirrana yima (came true). Yingampa tiwi pirimani ngini awuta arikutumunuwi kapi japuja pirimi kapi Nazareth api wuta karluwu wutawa api wiyi yingampa tiwi pirimi ngini ngawa-yuwuni Jesus ngarra karluwu ngatawa. ");
INSERT INTO tiw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Awarra John ngini ngarra-naringa awinyirra Elizabeth karri ngarra arikulani yimi api wuta pirimamula (called) awarra John the Baptist. Kiyi ngarra yuwuriyi kapi awarra murrakupuni Judea awungarruwu kapi karri-kuwapi japuja pirimi. Kiyi tayikuwapi tiwi purruwuriyi kangatawa api ngarra yuwuntiyarra awuta ngini ngarra ngawa-rringani ngirramini ");
INSERT INTO tiw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","api yimi ngini, “Awi, nuwa putuputuwu nyirra-kiray-amiya awarra jirti ngini nuwa ngintiri-kirim-ani (the wrong you've done) ngini karluwu tuwanga nginti-matami awungani pili ngawa-rringani waya yinkitayi ngawa-alawura arimi amintiya wiyi apamangi ngawa arikutumunuwi.” Ngarra awarra yipangiraga awarra John the Baptist kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ngarra parlingarri ngawa-rringani yuwutiyarra awarra prophet Isaiah ngirramini ngini (about) awarra John the Baptist api awarra Isaiah yikirimi (wrote) awarra ngirramini kapi ngawa-rringani ngini-ngatawa punkaringini (Old Testament). Ngarra karluwu awarra Isaiah yimajawu awarra John the Baptist ngarra yintanga api yikirimi (wrote), “Yati tini wiyi japuja arimi awungarruwu kapi karri-kuwapi tiwi japuja wurimi api tayikuwapi tiwi wiyi wuriyi awungarruwu kapi ngarra japuja awarra tini. Kiyi awarra tini wiyi jingawu arimi kangi wutawa api awuntiyarra awuta tiwi ngini, ‘Yati ngini ngarra alawura waya yinkitayi awunu-wuja api ngawa pupuka ngamata-kirimi (should make) awinyirra jarrumoka angi ngarra wiyi apapunya. Tulimiyinga ngamata-kirimi awinyirra jarrumoka.’ Ngarra wiyi awarra tini awarra ngirramini awuntiyarra awuta tiwi,” yikirimi awarra Isaiah kangi awarra punkaringini. ");
INSERT INTO tiw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Awinyirra kuluji angatawa John the Baptist api awinyirra kamuli murrula (camel hair ones) amintiya angatawa wulirrima (belt) api awarra mipurra (leather one). Yinkiti ngini yuwapa api yingwati amintiya grasshoppers. ");
INSERT INTO tiw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tayikuwapi arikutumunuwi purruwuriyi kapi awarra John the Baptist pili wuta purru-wutimarti ngini pimata-pitingaya (hear) ngawa-rringani ngini-ngatawa ngirramini. Yingampa (some) awuta tiwi japuja pirimi awungarruwu kapi Jerusalem. Wutatuwu yingampa japuja pirimi kapi yingampa (other) towns awungarruwu kapi awarra arikulani murrakupuni Judea. Amintiya wutatuwu yingampa japuja pirimi awungarruwu kapi awarra murrakupuni yinkitayi kapi awinyirra makatinga Jordan. Api awuta tayikuwapi purruwuriyi kapi awarra John the Baptist. ");
INSERT INTO tiw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kiyi awuta tiwi karri piri-pitingaya (heard) awarra ngirramini ngini John the Baptist yipangiraga api putuputuwu pirripakiray-amiya awarra jirti ngini wuta pirikirim-ani (the wrong they did) api purru-wutiyarra awarra John the Baptist awarra jirti ngini pirikirim-ani. Karri purru-wutiyarra awarra John the Baptist awarra jirti api wuta awungarri nimarra pirimi makirrana. Api kiyi awarra John the Baptist baptise yikirimi awuta. ");
INSERT INTO tiw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kiyi tayikuwapi alawuruwi purruwuriyi kapi awarra John the Baptist. Wuta pirimamula (called) awuta alawuruwi Pharisees amintiya scribes. Api karri wuta papi pirimi kangi awarra John the Baptist api ngarra yimi kangi wutawa, “Nuwa nginingaji taringuwi,” yimi, “pili awuta taringuwi karri yikwani awunu-wuja api wuta kalikali wurimakirrimi. Api nuwatuwu awanuwanga kalikali ngimpiri-makirrimi kangilawa ngini ngiya baptise ngimata-kirimi nuwa pili nuwa arrami ngimpiri-makirri awarra yikwani kapi ngarra maputiti japuja. ");
INSERT INTO tiw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kayi,” yimi awarra John the Baptist kapi awuta alawuruwi, “Putuputuwu nyirra-kiray-amiya awarra jirti ngini nuwa ngintiri-kirim-ani (the wrong you have done) api ngarra wiyi ngawa-rringani putuputuwu apakirayi (forgive) nuwa. Kiyi nyirra-mwari awarra jirti ngini nuwa ngintiri-kirim-ani (the wrong you have done) api papurajuwi tiwi nyirrama. Api karri ngawa-rringani apakuluwunyi ngini nuwa papurajuwi ngintirima api ngarra awungarri wiyi arimajawu ngini nuwa waya ngimpapunya angatawa pupuka jarrumoka.” ");
INSERT INTO tiw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Amintiya nuwa kapi nuwa alawuruwi manya ngimpirimi ngini, “Ngawa-rringani puranji yimuwu awarra ngawa-amini Abraham ngini parlingarri yimuwu api awarra (for that reason) ngawa waya rayiti (alright). Nuwa alawuruwi awarra manya ngimpirimi api nuwa ngajiti awarra nimarra ngimpajami. Tayakuluwunyi anaki waranga kapi yakuluwuni. Ngini ngawa-rringani awutimarti api ngarra mirrikili (miracle) yimata-kirimi api ngarra yirrija-kirimi (can make) anaki waranga awarra Abraham ngarra-mamirampi. Api nuwa ngajiti ngimpajami ngini nuwa waya rayiti (alright) pili nuwa-amini Abraham.” Ngarra awarra yipangiraga John the Baptist kapi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kiyi yimi kapi awuta alawuruwi, “Awarra ngawa-rringani waya yinkitayi apakirayi jirti ngirramini (trouble) kangi nuwula kapi nuwa jajiruwi. Ngarra awarra ngawa-rringani nginingaji awarra tini ngini apamangi awinyirra purinjirringa angi ampini kuruti (fruit). Api awinyirra purinjirringa angi nyirra jirti kuruti ampini api awarra tini arimajingipa (chops down) awinyirra purinjirringa api kiyi awunyawu awinyirra kangi yikwani. Ngarra awarra ngawa-rringani nginingaji awarra tini ngini awunyawu awinyirra jiringa purinjirringa kangi yikwani pili ngarra wiyi awunyawu nuwa kapi jajiruwi kapi awarra yikwani kapi ngarra maputiti japuja.” Ngarra awarra yipangiraga awarra John the Baptist kapi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kiyi ngawa-yuwuni Jesus yipumwari awarra murrakupuni Galilee api kiyi ngarra yuwuriyi kapi awinyirra makatinga Jordan. Karri ngarra waya awungarruwu api yuwuriyi kapi awarra John the Baptist api yimi kangatawa, “Aya mantani, baptise takirimi ngiya.” ");
INSERT INTO tiw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Api John the Baptist yimi ngini, “Karluwu,” yimi, “pili nginja nginjila api ngiya karluwu ngilawa api nginja baptise jimata-kirimi ngiya,” yimi John the Baptist kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Api ngawa-yuwuni yimi ngini, “Ngawa-rringani awutimarti ngawa tiwi ngini ngamatu-wariyi kanginjila ngini nginja baptise jimata-kirimi ngawa api nginja baptise jimata-kirimi ngiya. Ngarra awarra ngawa-rringani awutimarti ngawa ngini kuwa ngamatami awarra ngini-ngatawa ngirramini. Tayikuwa-ni (all) ngawa-rringani ngirramini kuwa ngawurrami (must obey),” yimi ngawa-yuwuni. Api yimi John the Baptist ngini, “Manya.” Kiyi baptise yikirimi ngawa-yuwuni awungarruwu kapi makatinga Jordan. ");
INSERT INTO tiw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Api awarra ngawa-yuwuni karri yipapurti kapi warta (river bank) api awungarri awarra yirrakunga yimakanya (split open) api ngawa-yuwuni yipakuluwunyi kuriyuwu api awungarruwu yipakuluwunyi ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) ngini yini-papirraya kangarra. Nginingaji mwapurawayi (dove bird) yini-papirraya. ");
INSERT INTO tiw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kiyi ngawa-rringani nimarra yimi kapi kuriyuwu api yimi ngini, “Niyi awarra ngiya-mirani,” yimi ngawa-rringani. Kiyi yimi ngini, “Ngiya puranji ngurumuwu awarra amintiya kukunari ngirimi kangatawa,” yimi ngawa-rringani kapi kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kiyi ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) yimarruriyi ngawa-yuwuni Jesus awungarruwu kapi awarra murrakupuni kapi karri-kuwapi wurumuwu awungaji pili awungarruwu awarra maputiti yuwutimarti ngini nimarra yimatami kapi ngawa-yuwuni ngini jirti yimata-kirimi (to do wrong). ");
INSERT INTO tiw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ngarra awungaji ngawa-yuwuni yimuwu 40 wumunga (days). Ngarra arnuka awungarri yuwapa yinkiti api ngarra wiyi (later on) paruwani yimi. ");
INSERT INTO tiw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kiyi ngarra awarra maputiti yinuwuriyi kapi ngawa-yuwuni yimi ngini, “Aya,” yimi. “Awarra ngatawa ngini ngarra japuja kuriyuwu awarra ngini nginja nimpiri-mamula (call) ngarra nginja-rringani api mirrikili (miracle) takirimi api tajiyarra anaki waranga ngini kirritawuni yimatama (to become).” Ngarra awarra yimi maputiti pili ngarra yimajawu ngini ngawa-yuwuni waya paruwani. ");
INSERT INTO tiw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Api ngawa-yuwuni yimi ngini, “Karluwu,” yimi, “pili ngarra Moses parlingarri yikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) naki ngirramini ngini ngiya-rringani yipangiraga api yimi ngiya-rringani ngini awarra yinkiti ngini ngawa arikutumunuwi ngawapa api ngawa awarra yimpanguwi ngarimuwu. Api ngarra arnuka wangata yinkiti arikirimi ngawa yimpanguwi. Yita ngawa-rringani ngini-ngatawa ngirramini tayikuwa-ni (all) awarra ngirramini api ngini ngawa kuwa ngarimi awarra ngirramini api awarra ngirramini wiyarri yimpanguwi arikirimi ngawa. Ngarra arnuka wangata yinkiti arikirimi ngawa yimpanguwi,” yimi ngawa-yuwuni kapi awarra maputiti. ");
INSERT INTO tiw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kiyi ngarra maputiti yimarruriyi ngawa-yuwuni kapi Jerusalem kapi awinyirra arikulanga jurra (temple) angi-wutawa Jews. Awungarruwu kapi awinyirra jurra awarra maputiti yimarruriyi ngawa-yuwuni kuriyuw-amini kapi awinyirra jurra. ");
INSERT INTO tiw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kiyi maputiti yimi ngini, “Kutupi tami kapi yakuluwuni,” yimi. “Ngajiti nimpaja-makirri pili awarra ngatawa ngini ngarra japuja kuriyuwu awarra ngini nginja nimpiri-mamula (call) ngarra nginja-rringani api ngarra wiyi apamangi nginja. Parlingarri wuta papaluwi pirikirimi (wrote) ngini-ngatawa ngirramini kangi awarra punkaringini ngini, ‘Nuwa kapi kuwa ngimpirimi ngini-ngatawa ngirramini awarra ngatawa ngini ngarra japuja kuriyuwu api ngarra wiyi awuntiyarra awuta angeluwi ngini wupamangi nuwa nginingaji karri nuwa waya yinkitayi pirlamarri (by accident) ngimpiri-pirn-amiya kapi waranga api awuta angeluwi wiyi wupamanipayi (lift you up) nuwa api awinyirra waranga arnuka ampiri-pirni nuwa malapwara.’ Parlingarri awuta papaluwi pirikirimi (wrote) awarra ngirramini kangi punkaringini,” yimi maputiti kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Api yimi ngawa-yuwuni, “Ngiya arnuka kutupi ngimatami kapi yakuluwuni pili awarra Moses nyoni awarra ngirramini parlingarri yikirimi kangi awarra punkaringini, awarra ngirramini ngini ngiya-rringani yuwuntiyarra ngarra ngini, ‘Nuwa arikutumunuwi ngajiti ngimpaja-jiyarra ngiya ngini ngimata-wani nuwa (I have to help you),’ yimi ngiya-rringani. Awarra Moses awarra ngirramini parlingarri yikirimi kapi awarra punkaringini,” yimi ngawa-yuwuni Jesus kapi awarra maputiti. ");
INSERT INTO tiw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kiyi awarra maputiti yimarruriyi ngawa-yuwuni kuriyuwu kapi jupunyini (hill). Kuriyuw-amini awarra jupunyini. Awungarruwu maputiti yimi kangi awarra ngawa-yuwuni, “Tayakuluwunyi nayi tayikuwa-ni (all) murrakupuni. Awungarruwu tayikuwapi arikutumunuwi wurumuwu api yingampa awuta arikutumunuwi wuni yingarti kunawuni amintiya wurumuwu kapi warntirrana pupuka kurrampali,” yimi maputiti. ");
INSERT INTO tiw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Api ngini nginja nimpamukuri ngini-nginjila yirrara yimpula kapi yakuluwuni kangiya amintiya ngini nginja nimpiri-kuruwarni (thank) ngiya api ngiya wiyi ngipakirayi nginja awarra nayi yingarti murrakupuni amintiya awinyirra anayi pupuka kurrampali.” Ngarra awarra yimi maputiti kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kiyi ngawa-yuwuni yimi kapi maputiti, “Tuwariyi. Ngiya arnuka ngimata-kuruwarni (thank) nginja pili ngarra Moses parlingarri yikirimi kapi awarra punkaringini awarra naki ngirramini ngini ngarra ngiya-rringani yipangiraga api yikirimi (wrote) ngini, ‘Nyirra-kuruwarni (thank) ngiya pili ngiya alawura ngirimi kangi nuwa. Amintiya waki nyirrami ngini (for) ngiya. Karri-kuwani nyoni,’ yimi ngiya-rringani. Api nginja tuwariyi maputiti,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kiyi awarra maputiti yuwuriyi api wuta angeluwi pini-papirraya (came down) kangi ngawa-yuwuni api pirripamangi ngarra. ");
INSERT INTO tiw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kiyi ngawa-yuwuni Jesus kularlaga yimi kapi awarra murrakupuni Galilee api awungarruwu ngarra yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Ngarra yimi kapi awuta, “Nyirra-mwari awarra jirti ngini nuwa waya ngintiri-kirim-ani (the wrong you've done) kiyi nyirra-punya ngawa-rringani angatawa jarrumoka. Ngawa-rringani waya yinkitayi alawura arimi kangi nuwa arikutumunuwi kapi nuwa wiyi ngimpapunya angatawa jarrumoka amintiya ngarra wiyi warntirrana apamangi nuwa.” Ngarra awarra yimi ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ninkiyi ngawa-yuwuni Jesus kularlaga yimi kapi awarra arikulani murrakupuni Galilee. Awungarruwu ngarra yipawuriji yilaruwu kapi yingarti kirijinga jurra angi-wutawa Jews (synagogues) api ngarra yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa pupuni ngirramini awarra ngirramini ngini ngawa-rringani yuwutimarti ngini wuta-alawura yimatami amintiya ngini yimata-mangi awuta. Karri ngawa-yuwuni yuwunyayi tiwi kapi wuta purunjuwi api kuta kaminawuti (whatever) jana purruwuni ngarra pupuwi yikirimi awuta. ");
INSERT INTO tiw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Awuta arikutumunuwi kapi piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yipangiraga amintiya pirripakuluwunyi ngarra ngini pupuwi yikirimi awuta tiwi kapi purunjuwi api wuta wiyi (later on) awuta arikutumunuwi purru-wuntiyarra yingampa arikutumunuwi ngini (about) ngawa-yuwuni. Api wiyi tayikuwapi arikutumunuwi kapi awarra nyoni murrakupuni Syria ngini karrampi api wuta wiyarri piri-pitingaya awarra ngirramini ngini (about) ngawa-yuwuni api wuta pirimarruriyi kangatawa wuta-ngirimipi amintiya wuta-mamanta kapi wuta purunjuwi. Awuta tiwi kapi wuta pirimarruriyi kangatawa api wuta yingampa yingarti walawala (pain). Wutatuwu yingampa purruwuni maputirruwi yilaruwu kangi wutawa purnikapa. Yingampa awuta tiwi pirripakupuraj-ani kapi yakuluwuni kiyi yingarti pulingiya amintiya yingampa awuta tiwi api wuta karrawungana amintiya wuta karluwu pirrija-ngulimayi (couldn't walk) amintiya ngini-wutawa kurumuta waya yuwunjarli (stopped). Api karri awuta arikutumunuwi pirimarruriyi kangi ngawa-yuwuni awuta tayikuwapi tiwi kapi wuta jana api ngarra ngawa-yuwuni pupuwi yikirimi awuta. ");
INSERT INTO tiw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tayikuwapi tiwi pirripapunya ngawa-yuwuni. Yingampa awuta japuja pirimi kapi Galilee. Kiyi yingampa japuja pirimi kapi Decapolis amintiya yingampa awuta japuja pirimi kapi Jerusalem kiyi nyoni murrakupuni kapi awarra arikulani murrakupuni Judea amintiya yingampa awuta japuja pirimi kapi awarra murrakupuni maringarruwu kapi awinyirra makatinga Jordan. Awuta tayikuwapi pirripapunya ngawa-yuwuni Jesus. ");
INSERT INTO tiw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kiyi ngawa-yuwuni yipakuluwunyi awuta tayikuwapi arikutumunuwi kapi pirripapunya ngarra awungarruwu kapi Galilee api yimi kangatamiya “Ngiya wiyi ngipapurti kuriyuwu kapi nginaki jupunyini (hill) api awungarruwu nguwuntiyarra ngiya-mamanta ngini-ngilawa ngirramini.” Kiyi ngarra yipapurti kuriyuwu kapi jupunyini kiyi yimuwu awungarruwu. Kiyi awuta tayikuwapi ngarra-mamanta kapi pirripapunya ngawa-yuwuni api punuwuriyi kangatawa ");
INSERT INTO tiw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kiyi ngawa-yuwuni yuwuntiyarra awuta awarra naki ngirramini, yimi ngini. ");
INSERT INTO tiw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Arramukuta yingampa nuwa nimarra ngimpirimi nuwulamiya ngini, ‘Ngiya arnuka pupuni tini api ngiya nguwutimarti ngawa-rringani ngini yimata-wani (to help) ngiya ngini warntirrana kuwa ngimatami ngini-ngatawa ngirramini.’ Api kapi nuwa awarra ngimpangiraga kapi nuwulamiya api ngawa-rringani wiyi amanu-wani nuwa. Ngarra wiyi awanuwanga apamangi nuwa api nuwa wiyi kukunari ngimpirimi.” Ngarra awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kiyi ngawa-yuwuni yimi kangi wutawa, “Karri nuwa putuputuwu apalamiya (are sorry) kangi nuwula ruwuti api ngarra wiyi ngawa-rringani amanu-wani nuwa api nuwa wiyi awungarri kukunari ngimpirimi kangi nuwulamiya nuwa awuta kapi puranji ngumpuru-muwu ngawa-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kiyi ngawa-yuwuni yimi kangi wutawa, “Kapi nuwa arnuka ngimpangirrajamiya amintiya awanuwanga arnuka ngimpakirayi jirti ngirramini (angry talk) kapi nuwa-mamanta api nuwa awuta wiyi kukunari kangi nuwulamiya pili nuwa wiyi ngumpuru-muwu kangiya kapi ngiya murrakupuni.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kiyi ngawa-yuwuni yimi ngini, “Kapi nuwa ngimpitimarti ngini warntirrana pupuwi nginti-mata-ma (to become) api awarra ngawa-rringani wiyi amanu-wani (help) nuwa ngini pupuwi tiwi nginti-mata-ma api kiyi nuwa wiyi awungarri kukunari ngimpirimi kangi nuwulamiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kiyi ngawa-yuwuni yimi ngini, “Kapi nuwa ngimpamangi nuwa-mamanta amintiya putuputuwu ngimpakirayi awuta api nuwa wiyi kukunari ngimpirimi pili ngawa-rringani wiyi amant-amangi nuwa amintiya putuputuwu amant-akirayi nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kiyi yimi ngawa-yuwuni ngini, “Nuwa kapi warntirrana papurajuwi tiwi api karluwu ngimpiri-mamuliya papurajuwi api nuwa awuta wiyi ngimpakuluwunyi ngawa-rringani kapi ngatawa japuja api wiyi nuwiyati tangarima awungarruwu amintiya nuwa wiyi awungarri kukunari ngimpirimi.” Awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kiyi ngawa-yuwuni yimi ngini, “Karri nuwa-mamanta wuru-warr-ajirri (fight) api nuwa kapi ngumpuriyi kapi awuta nuwa-mamanta api kiyi ngumpuru-wani (help) awuta ngini wuta arnuka pimata-warr-ajirri api ngawa-rringani wiyi apangiraga kangi nuwa, ‘Ngiya-mamirampi nuwa.’ Api nuwa wiyi awungarri kukunari kangi nuwulamiya,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kiyi yimi ngawa-yuwuni ngini, “Nuwa kapi wuta yingampa wupakirayi nuwa jirti ngirramini (trouble) amintiya pokayini wurimi kangi nuwula pili nuwa warntirrana ngimpapunya ngawa-rringani jarrumoka api nuwa kukunari nyirrami pili ngawa-rringani wiyi amant-amangi nuwa. ");
INSERT INTO tiw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Wuta yingampa wiyi tongwayi wurimi nuwa amintiya awanuwanga wiyi wuripirni nuwa pili nuwa warntirrana kuwa ngimpirimi ngini-ngilawa ngirramini. Kiyi wuta wiyi kunyani wurimi ngini (about) nuwa. Api karri wuta awarra jirti ngirramini wupakirayi nuwa api ngajiti kuwa ngimpajami awarra. ");
INSERT INTO tiw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Waya juwa kukunari nyirrami pili ngawa-rringani wiyi amant-akirayi nuwa yingarti arramu-kaminawuti ngini pupuni kapi ngatawa tangarima kuriyuwu. Awarra jirti ngirramini (trouble) ngini awuta yingampa tiwi wupakirayi nuwa api nuwa karluwu wangata awarra jirti ngirramini pili awuta prophets kapi parlingarri purumuwu api yingampa tiwi awanuwanga pirripakirayi jirti ngirramini kapi awuta prophets.” Ngarra awarra yimi ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kiyi ngawa-yuwuni Jesus yimi kapi awuta tayikuwapi ngarra-mamanta, “Nyoni nginaki ngirramini nguwutiyarra nuwa ngini karri awuta arikutumunuwi wupamukuri awarra salt kapi kumapora purnikapa api awarra purnikapa arnuka wiyi punipani. Api nuwa awuta kapi kuwa ngimpirimi ngini-ngilawa ngirramini api nuwa nginingaji awarra salt pili nuwa ngumpuru-wani (help) nuwa-mamanta ngini wuta karluwu jajiruwi pimatami. Api awarra salt karri jirti arimi api ngawa karluwu tuwanga pupuni ngamata-kirimi (can't make) awarra salt api ngawa karluwu ngamata-mukuri (shouldn't put) awarra jirti salt kapi awarra kumapora purnikapa pili awarra jirti salt karluwu yimata-kirimi (can't make) awarra purnikapa ngini karluwu punipani yimatami. Waya juwa ngawunyawu awarra jirti salt kapi yakuluwuni api ngaparingina awarra salt karri ngapangulimayi. Api nuwa kapi kuwa ngimpirimi ngini-ngilawa ngirramini api ngini nuwa arnuka ngumpuru-wani (help) nuwa-mamanta ngini pupuwi pimatami api nuwa nginingaji awarra jirti salt.” Ngarra awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kiyi yimi ngawa-yuwuni ngini, “Nyoni nginaki ngirramini nguwutiyarra nuwa ngini (about) awinyirra kurrampali angi tayinti ampirimi kuriyuwu kapi jupunyini (hill). Karri japinamini awarra light ngirri-ngirri arimi yilaruwu kangi awinyirra kurrampali api ngawa arikutumunuwi kapi ngarimuwu kapi yawuni (down) api ngawa ngapakuluwunyi awarra light pili awinyirra kurrampali tayinti ampirimi kuriyuwu kapi awarra jupunyini. Api nuwa kapi kuwa ngimpirimi ngini-ngilawa ngirramini api nuwa nginingaji awarra light pili karri nuwa ngumpuru-wani (help) nuwa-mamanta api wuta tayikuwapi wupakuluwunyi nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kiyi yimi ngawa-yuwuni ngini, “Karri ngawa jurrumumi ngarikirimi light api ngawa karluwu ngaripujirra (cover up) awarra light. Waya juwa ngapamukuri awarra light kuriyuwu yilaruwu kapi angawula kurrampali api awarra light ngirri-ngirri arimi kapi ngawa tiwi kapi ngarimuwu kapi awinyirra kurrampali. ");
INSERT INTO tiw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Api nyirru-wariyi kapi nuwa-mamanta api nyirra-wani (help) awuta api kiyi nuwa wiyi nginingaji awarra light ngimpirimi pili yingampa tiwi wiyi wupakuluwunyi nuwa ngini ngumpuru-wani awuta nuwa-mamanta api awuta yingampa wiyi nimarra wurimi ngini, ‘Ngawa-rringani pupuni pili ngarra awunu-wani awuta papurajuwi tiwi ngini wunu-wani wuta-mamanta.’ Wuta wiyi awuta yingampa tiwi awarra wupangiraga karri wupakuluwunyi nuwa ngini ngumpuru-wani nuwa-mamanta.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta kapi pirripapunya ngarra. ");
INSERT INTO tiw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kiyi ngawa-yuwuni Jesus nyoni nginaki ngirramini yipangiraga kapi awuta tayikuwapi ngarra-mamanta, “Ngini yati kapi nuwa jirti ngirramini (trouble) nimpakirayi nginja-mantani api ngini nginja-mantani angatawa yiminga jurrumumi ampirimi (becomes angry) kangi nginja api nanginta tami awarra nginja-mantani ngini putuputuwu apakirayi (forgive) nginja. Api ngini nginja nimpiri-marruriyi kunawuni kapi angawula jurra ngini nimpakirayi awarra kunawuni kapi ngawa-rringani api ngini karri nginja awungaji kangi jurra api nimpiri-pungintayi (remember) ngini nginja jirti jiyikirimi kapi nginja-mantani api ngajiti nimpaja-marruriyi awarra kunawuni yilaruwu kapi jurra. ");
INSERT INTO tiw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Pakinya tuwariyi kapi awarra nginja-mantani ngini nginja jirti jiyikirimi kangatawa api nanginta tami awarra ngini putuputuwu yimata-kirayi nginja. Api ngini ngarra awarra nginja-mantani arimi ngini, ‘Waya manya’ api tayakupawurli kapi jurra api tamarruriyi awarra kunawuni yilaruwu kapi jurra kiyi tayakirayi awarra kunawuni kapi ngawa-rringani.” Awarra yimi ngawa-yuwuni kapi awuta tiwi. Kiyi yimi kangi wutawa, “Nuwa ngajiti ngimpaja-kirayi kunawuni kapi ngawa-rringani karri awuta nuwa-mamanta nanuwanga wuni jirti ngirramini (trouble) kangi nuwula.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","28","Kiyi ngawa-yuwuni nyoni ngirramini yimi kapi awuta tayikuwapi ngarra-mamanta, “Nuwa ngimpiri-majawu awarra ngawa-rringani ngini-ngatawa ngirramini ngini, ‘Nuwa ngajiti pokayini ngimpajami ngini ngarra nyoni tini ngarra-purnayinga.’ Ngarra ngawa-rringani awarra yipangiraga,” yimi ngawa-yuwuni. Kiyi yipangiraga ngini, “Ngiyatuwu ngirimi ngini karri nuwa ngimpakuluwunyi angi ngarra nyoni tini ngarra-purnayinga api ngini nuwa awungarri ngimpirimi kangi nuwulamiya ngini, ‘Ngiya nguwutimarti awinyirra,’ api jirti awarra pili ngarra awarra nginingaji nuwa warntirrana pokayini ngimpirimi awinyirra tinga angi ngarra nyoni tini ngarra-purnayinga. Amintiya ngini nuwa maminikuwi ngimpakuluwunyi nyonga tinga nyirra-purnayi api ngini nuwa awungarri ngimpirimi kangi nuwulamiya ngini, ‘Ngiya nguwutimarti awarra,’ api jirti awarra pili awarra nginingaji nuwa warntirrana pokayini ngimpirimi awarra tini ngini nyirra nyonga tinga nyirra-purnayi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kiyi yimi ngawa-yuwuni ngini, “Ngini nuwa ngimpakuluwunyi nyoni tini ngarra-purnayinga api ngini nuwa ngimpitimarti awinyirra api yartipili nyirra-jiyarri (put your head down) pili ngini (if) nuwa karluwu ngimpa-jiyarri amintiya ngini nuwa ngimpakuluwunyi-la (keep looking at) awinyirra tinga api nuwa arrami wiyi warntirrana ngimpiri-marrimili awinyirra angi nyoni tini ngarra-purnayinga. Api awarra jirti api nuwa wiyi arrami ngumpuriyi kapi ngarra maputiti japuja (hell). ");
INSERT INTO tiw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Amintiya ngini nuwa ngimpitimarti ngini nginti-mata-wuningiya (touch) nyoni tini ngarra-purnayinga amintiya nyonga tinga nyirra-purnayi api ngajiti awungani ngimpajami. Nyirra-mwari awarra tini ngarra-purnayinga amintiya nyonga tinga nyirra-purnayi pili arrami nuwa wiyi mitaya ngimpirimi awarra tini ngarra-purnayinga amintiya nyonga tinga nyirra-purnayi api ngini nuwa warntirrana mitaya ngimpirimi awinyirra tinga amintiya awarra tini api nuwa wiyi arrami ngumpuriyi kapi ngarra maputiti japuja (hell).” Ngarra awarra yipangiraga ngawa-yuwuni kangi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kiyi ngawa-yuwuni Jesus nyoni nginaki ngirramini yimi kapi awuta tayikuwapi ngarra-mamanta, yimi ngini, “Nuwa ngimpiri-majawu awarra ngirramini (law) ngini-ngatawa Moses ngini (that) awuta wawurruwi kapi wutimarti ngini pimata-mwari wuta-purnayuwi api wuta awuta pakinya pimata-kirimi (should write) kapi punkaringini (paper) ngini wuta waya arnuka wuta-purnayuwi awuta maminikuwi api kiyi wuta pimata-kirayi awarra punkaringini kapi awuta maminikuwi. Ngarra awarra Moses parlingarri yuwuntiyarra awarra ngirramini (law) kapi ngawa-maninguwi ");
INSERT INTO tiw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","api ngiyatuwu ngirimi ngini awinyirra tinga angi nyirra arnuka pokayini jiyimi nyoni tini api nyirra-purnayi arnuka yimata-mwari (should not leave) awinyirra pili ngini (if) ngarra apumwari awinyirra api nyirra wiyi arramukuta nyoni tini arimarrimuwu awinyirra api jirti awarra pili ngarra awarra tini ngini yipumwari ngarra-purnayinga api ngarra awarra yikirimi awinyirra yimpalinya ngini juwunga nyoni tini. Amintiya awarra nyoni tini awanuwanga jirti arikirimi (does wrong) pili ngarra arimarrimuwu nyoni tini ngarra-purnayinga.” Ngarra awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","39","Kiyi ngawa-yuwuni Jesus yipangiraga nyoni nginaki ngirramini kapi awuta tayikuwapi ngarra-mamanta, “Nuwa ngimpiri-majawu ngini papaluwi purru-wuntiyarra awuta tiwi awarra naki ngirramini ngini ngawa-rringani yipangiraga ngini, ‘Ngini nuwa ngimpiri-pirni nyoni tini kangatawa pijara awarra nyoni tini api ngini awarra nyoni tini ngini-ngatawa pijara papi awunirimi (comes out) api nuwa wiyi ngumpuwariyi kapi majatawi angi-wutawa kurrampali api awungarruwu kapi angi-wutawa kurrampali awuta majatawi wiyi papi wuniri-mamiyi (take out) ngini-nuwula pijara,’ yimi ngawa-rringani. Kiyi tuwanga yimi, ‘Awanuwanga ngini nuwa ngimpiri-pirni nyoni tini kangatawa yirruputara api ngini awarra nyoni tini ngini-ngatawa yinkana papi awunirimi api wuta wiyi wuri-marruriyi nuwa kapi majatawi angi-wutawa kurrampali api awungarruwu kapi angi-wutawa kurrampali awuta majatawi wiyi papi wuniri-mamiyi (take it out) ngini-nuwula yinkana.’ Awarra ngirramini yimi ngawa-rringani parlingarri api awuta papaluwi purru-wuntiyarra awuta tiwi awarra ngirramini (law),” yimi ngawa-yuwuni. Kiyi ngawa-yuwuni tuwanga yimi ngini, “Api ngiyatuwu ngirimi, ngini (if) yati tini aripirni nuwa api nyirra-mwari awarra jirti ngirramini (trouble). Api ngini ngarra aripirni nuwa yatuwani (one side) kapi nuwa yirrikilingapa api ngini awutimarti ngini tuwanga yimata-pirni nuwa api nyirra-jiyarra awarra ngini, ‘Tapirni ngiya kurrukola (other side) kapi ngiya yirrikilingapa.’ Nuwa awarra nimarra nyirrami kapi awarra tini,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kiyi nyoni ngirramini yimi ngini, “Awuta tiwi kapi nanginta wurimi nuwa kuta kamini ngini wutimarti api nyirra-kirayi awuta awarra kuta kamini. Amintiya ngini wurimi kangi nuwa, ‘Ngiya pakinya awarra ngini nginja nimpini,’ api nuwa nyirra-kirayi (give) awarra kangi wutawa,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kiyi ngawa-yuwuni Jesus nimarra yimi kapi ngarra-mamanta nyoni nginaki ngirramini, “Nuwa ngimpiri-majawu awarra ngirramini ngini awuta papaluwi parlingarri pirripangiraga kapi awuta arikutumunuwi. Wuta pirlamarruwi awuta papaluwi api pirimi ngini, ‘Awuta tiwi kapi jirti wurumuwu ngawa api ngawa awanuwanga jirti ngawurra-muwu (must hate) awuta api wuta wangata pupuni ngawurra-muwu (must love) kapi pupuni wurumuwu ngawa.’ Awuta papaluwi kapi pirlamarruwi awarra pirripangiraga, ");
INSERT INTO tiw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","api ngiyatuwu nimarra ngiyimami (going to say) ngini ngawa-rringani ngini kuriyuwu puranji arimuwu tayikuwapi (everyone),” yimi ngawa-yuwuni. Kiyi yimi ngini, “Awarra ngawa-rringani parlingarri yikirimi warnarringa api arikirimi awinyirra warnarringa ngini ngirri-ngirri ampirimi kangi awuta tiwi kapi jajiruwi amintiya kapi wuta pupuwi. Awanuwanga arikirimi pakitiringa ngini apawuliyi (come down) kapi awuta tiwi kapi jajiruwi amintiya awuta kapi pupuwi,” yimi ngawa-yuwuni kapi ngarra-mamanta. Kiyi yimi ngini, “Nuwa awanuwanga puranji nyirra-muwu tayikuwapi (everyone). Kapi jirti wurumuwu nuwa api nuwa puranji nyirra-muwu awuta tiwi. Api awuta kapi tongwayi wurimi nuwa api nanginta nyirrami ngawa-rringani ngini yimata-mangi awuta. Api ngini nuwa puranji ngumpuru-muwu tayikuwapi amintiya ngini nanginta ngimpirimi ngawa-rringani ngini yimata-mangi awuta kapi tongwayi wurimi nuwa api ngarra ngawa-rringani wiyi arimi kangi nuwa, ‘Ngiya-mamirampi nuwa,’ arimi.” Ngarra awarra ngawa-yuwuni yipangiraga kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kiyi yimi ngawa-yuwuni kangi wutawa, “Ngini nuwa puranji ngumpurumuwu awuta kapi pupuni wurumuwu nuwa api ngini nuwa waya juwa awuta puranji ngumpuru-muwu api ngarra ngawa-rringani karluwu yimata-mamula (won't call) nuwa papurajuwi. Awuta wawurruwi kapi waki wurimi ngini (for) awuta Roman alawuruwi api nanginta wurimi ngawa Jews awarra kunawuni ngini tax api nuwa ngimpirimi ngini wuta jajiruwi awuta tiwi api wuta awuta waya juwa puranji wurumuwu kapi puranji wurumuwu awuta. Api nuwa ngajiti awungani ngimpajami nginingaji wuta. Nuwa puranji nyirra-muwu tayikuwapi,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kiyi ngawa-yuwuni yimi kangi wutawa ngini, “Ngini nuwa nimarra ngimpirimi kapi nuwa-ngirimipi api ngini karluwu nimarra ngimpirimi kapi yingampa api ngarra awarra jirti. Wuta awungani wurimi (do that) awuta kapi arnuka kuwa wurimi ngawa-rringani. Nuwa ngajiti awungani ngimpajami nginingaji wuta. Yita nuwa nimarra nyirrami kapi tayikuwapi tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nuwa warntirrana pupuwi nyirrami (must be) nginingaji ngawa-rringani ngini kuriyuwu,” yimi ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta kapi pirripapunya ngarra. ");
INSERT INTO tiw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","2","Kiyi awarra ngawa-yuwuni Jesus nyoni ngirramini yipangiraga kapi awuta tayikuwapi ngarra-mamanta api yimi ngini, “Yingampa arikutumunuwi kapi wuri-mamuliya pupuwi api wuta wutimarti wuta-mamanta ngini pimata-kuluwunyi awuta karri wuta wurikirimi ngini pupuni (do good things), nginingaji karri wupakirayi yinkiti amintiya kunawuni kapi awuta kapi paruwani-la. Wuta awuta wupawuriji yilaruwu kapi jurra kapi tayikuwapi tiwi mimpa wurimi amintiya arrami wuriyi kapi jarrumoka pili wutimarti awuta tayikuwapi tiwi ngini pimata-kuluwunyi awuta ngini wupakirayi yinkiti kapi awuta paruwani-la, pili wuta wutimarti awuta tayikuwapi ngini pimata-mamula (call) awuta papurajuwi. Api naki awarra warntirrana ngini ngarra ngawa-rringani karluwu yimata-mamula (won't call) papurajuwi awuta kapi wuri-mamuliya pupuwi pili wuta wupangirrajamiya karri wupakirayi awarra yinkiti kapi awuta kapi paruwani-la. Nuwa ngajiti awungani ngimpajami nginingaji awuta kapi wuri-mamuliya pupuwi. ");
INSERT INTO tiw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Api nuwatuwu karri nuwa ngimpakirayi yinkiti amintiya kunawuni kapi awuta kapi paruwani-la api nyirra-kirayi awarra yinkiti amintiya kunawuni kangi wutawa karri karri-kuwapi wupakuluwunyi nuwa. Ngajiti worry ngimpajami ngini wuta yingampa tiwi karluwu wupakuluwunyi nuwa karri nuwa ngimpakirayi awarra yinkiti amintiya kunawuni kapi wuta paruwani-la pili ngarratuwu ngawa-rringani wiyi apakuluwunyi nuwa api wiyi apakirayi nuwa arramu-kamini ngini pupuni.” Ngarra awarra yimi ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kiyi ngawa-yuwuni nyoni ngirramini yipangiraga kapi awuta tayikuwapi ngarra-mamanta, “Awuta kapi wuri-mamuliya papurajuwi api karri wuta pray wurimi kapi ngawa-rringani api wuta awuta tayinti wurimi yilaruwu kapi jurra amintiya kapi jarrumoka api awungarruwu pray wurimi pili wuta wutimarti ngini tayikuwapi pimata-pitingaya (hear) awuta. Tani-waya (no matter) awuta tayikuwapi tiwi kapi wupakuluwunyi awuta wiyi wurimi ngini wuta awuta papurajuwi api ngarratuwu ngawa-rringani karluwu ari-pitingaya (listen to) awuta kapi wupangirrajamiya karri wuta pray wurimi kangatawa. Api nuwa ngajiti awungani ngimpajami nginingaji awuta kapi wuri-mamuliya papurajuwi. ");
INSERT INTO tiw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Api nuwatuwu karri pray ngimpirimi api nyirra-muwu nuwa wangatamiya kiyi pray nyirrami kapi ngawa-rringani kangi nuwula punyipunyi. Ngawa karluwu ngapakuluwunyi awarra ngawa-rringani api ngarra apakuluwunyi ngawa awungarruwu kapi ngawa pray ngarimi kangatawa api ngarra wiyi ari-pitingaya (hear) ngawa amintiya wiyi warntirrana apamangi ngawa,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kiyi ngawa-yuwuni yimi ngini, “Awuta kapi karluwu kuwa wurimi ngawa-rringani api wuta awuta karri pray wurimi kapi awuta kapi wuta wurimamula (call) kapi-wutawa gods api wuta nimarra wurimi yingarti ngirramini ngini awarra karri-kamini sense. Wuta awuta amparrimani ngini kapi-wutawa gods warntirrana wuri-pitingaya (hears) awuta karri wuta yinukuni (for long time) pray wurimi kangi wutawa. ");
INSERT INTO tiw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Api nuwatuwu karri nuwa pray ngimpirimi kapi ngawa-rringani ngini kuriyuwu api ngajiti yinukuni pray ngimpajami awarra-wanga-la (same) ngirramini nginingaji awuta yingampa (other) arikutumunuwi pray wurimi kangi kapi-wutawa gods. Yita ngarra awarra ngawa-rringani arimajawu awarra kuta kamini ngini ngawa ngawutimarti (need) karri ngawa karluwu nanginta ngarimi ngarra nanuwanga,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kiyi yimi ngini, “Karri nuwa nimarra ngimpirimi kapi ngawa-rringani ngini kuriyuwu api naki awarra ngirramini nyirrami kangatawa, Ngirringani ngini kuriyuwu, takirimi ngajingawula ngari-pungintayi (think about) nginja pili nginja warntirrana nginjila amintiya warntirrana pupuni. ");
INSERT INTO tiw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ngawa ngawutimarti nginja ngini alawura nimpirimi kapi tayikuwapi (all) arikutumunuwi. Amintiya ngawutimarti tayikuwapi ngini kuwa ngarimi nginja nginingaji awuta kapi wurumuwu kuriyuwu kangi nginjila kuwa wurimi nginja. ");
INSERT INTO tiw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amintiya ngawa ningani ngunta-luwapa yinkiti. ");
INSERT INTO tiw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kiyi ngawa putuputuwu nguwunt-akirayi kapi jirti wurumuwu ngawa api nginja awanuwanga ngawaputuputuwu ngunta-luwapa awarra ngini ngawa jirti ngintiri-kirim-ani. ");
INSERT INTO tiw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amintiya ngirringani, karri maputiti awutiyarra ngawa ngini jirti ngarikirimi api tawani ngawa ngini karluwukuwa ngarimi awarra maputiti. Amintiya tayamangi ngawa karri awarra maputiti apakirayi ngawa jirti ngirramini.” Ngarra ngawa-yuwuni awarra yipangiraga kapi awuta ngarra-mamanta karri ngarra yuwuntiyarra awuta ngini wuta awungani (that way) pray pimatami kapi ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kiyi yimi ngawa-yuwuni kangi wutawa, “Ngini nuwa putuputuwu ngimpakirayi awuta tiwi kapi jirti wurikirimi kangi nuwa api ngarratuwu awarra ngawa-rringani wiyi awanuwanga putuputuwu apakirayi nuwa awarra ngini nuwa jirti ngintiri-kirim-ani. ");
INSERT INTO tiw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Api ngini nuwa karluwu putuputuwu ngimpakirayi awuta tiwi kapi jirti wurikirimi kangi nuwa api ngarratuwu ngawa-rringani wiyi karluwu putuputuwu yimata-kirayi (won't forgive) nuwa.” Awarra yimi ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","Kiyi ngawa-yuwuni nyoni ngirramini yuwuntiyarra awuta tayikuwapi ngarra-mamanta, “Karri nuwa nanuwanga ngumpuru-muwu awungarra kapi naki murrakupuni (on this earth) api nuwa ngajiti nuwulamiya jilikari ngimpaja-kirimi yingarti arramu-kaminawuti ngini pupuni amintiya yingarti kunawuni pili awarra arramu-kaminawuti wiyi jirti arima nginingaji ngini wulimirri (iron) api awarra wiyi wawuti arimi (go rusty) amintiya awarra ngini-nuwula yinkiti amintiya kunawuni api wuta yingampa tiwi wiyi mitaya wurimi awarra. Amintiya karri nuwa jilikari ngimpiri-kirimi yingarti kuluji api kuta kamini awarra wiyi arikirimi yangamini kangi awinyirra kuluji. Kayi, ngini nuwa jilikari ngimpiri-kirimi awarra yingarti arramu-kaminawuti kapi awungarra naki murrakupuni api jirti awarra pili nuwa wiyi yimpaja ngimpiri-pungintayi (think about) awarra arramu-kaminawuti. Waya juwa nyirra-wani (help) yingampa (other) arikutumunuwi api karri ngawa-rringani apakuluwunyi nuwa ngini ngimpiri-wani awuta api ngarra wiyi jilikari arikirimi kuriyuwu arramu-kaminawuti ngini pupuni api wiyi apakirayi nuwa awarra arramu-kaminawuti. Api kiyi nuwa wiyi ngimpiri-pungintayi (think about) ngawa-rringani japuja amintiya wiyi ngimpitimarti ngini nginti-matu-wariyi awungaji pili awarra arramu-kaminawuti ngini ngawa-rringani wiyi apakirayi nuwa awungarruwu kapi ngarra japuja.” Ngarra awarra yimi ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kiyi ngawa-yuwuni Jesus nyoni ngirramini yimi kapi awuta tayikuwapi ngarra-mamanta, “Nuwa karluwu waki nginti-matami ngini (for) yuwurrara alawuruwi pili nuwa wiyi puranji ngumpuru-muwu yati amintiya kuwa ngimpirimi awarra. Kiyi ngarratuwu nyoni alawura api nuwa wiyi karluwu puranji nginti-mata-muwu awarra api wiyi karluwu kuwa nginti-matami awarra. Awanuwanga nuwa yingampa manya ngimpirimi ngini nuwa-alawura ngawa-rringani ngini kuriyuwu api nuwa waya juwa ngimpiri-pungintayi (think about) kunawuni. Ngini nuwa warntirrana ngimpitimarti ngawa-rringani ngini alawura yimatami kangi nuwa api nuwa ngajiti puranji ngimpaja-muwu awarra kunawuni,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amintiya ngarra yimi ngini, “Ngajiti yimpaja nimarra ngimpajami kangi nuwulamiya ngini, ‘Ngawa awungana ngamatama pili ngawa karri-kamini yinkiti amintiya kukuni amintiya kuluji.’ Api ngajiti awarra nimarra ngimpirimi nuwulamiya. ");
INSERT INTO tiw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Awuta tiwi kapi karluwu kuwa wurimi ngawa-rringani ngini kuriyuwu api wuta awuta yimpaja yatari wurimi yinkiti amintiya kukuni amintiya kuluji. Api nuwatuwu ngajiti awungani ngimpajami nginingaji awuta pili ngarra ngawa-rringani arimajawu awarra kuta kamini ngini nuwa ngimpitimarti (need) api ngarra wiyi apakirayi nuwa awarra ngini nuwa ngimpitimarti. ");
INSERT INTO tiw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Api nuwa warntirrana kuwa nyirrami ngawa-rringani amintiya nyirra-mamula (call) ngarra nuwa-alawura amintiya awanuwanga warntirrana nyirra-pungintayi (think about) awarra ngawa-rringani api kiyi ngarra wiyi apakirayi nuwa awarra kuta kamini ngini nuwa ngimpitimarti (need),” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kiyi ngawa-yuwuni yimi ngini, “Ngajiti nimarra ngimpajami kangi nuwulamiya ngini, ‘Arrami jirti ngirramini (trouble) wiyi papi arimi kangi ngiya pangarri. Arramukuta wuta wiyi jirti wurikirimi kangiya pangarri. Arrami ngiya wiyi karri-kamini yinkiti pangarri.’ Ngajiti awungani ngimpajami kangi nuwulamiya. Waya juwa karri pangarri karri awarra jirti ngirramini papi arimi api awungarri nyirra-pungintayi (think about) awarra jirti ngirramini. Api ngini ningani papi arimi jirti ngirramini (trouble) kangi nuwula api ningani nyirra-pungintayi awarra jirti ngirramini amintiya nanginta nyirrami ngawa-rringani ngini amanu-wani (help) nuwa, kapi nuwa kuwa ngimpirimi awarra ngawa-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Kiyi yimi ngawa-yuwuni Jesus kapi awuta tayikuwapi ngarra-mamanta, “Nuwa ngajiti ngimpaja-mamula (call) jajiruwi nuwa-mamanta pili ngini (if) nuwa awungani ngimpirimi (do that) api ngarra ngawa-rringani wiyi arimamula (call) nuwa jajiruwi. Api ngini nuwa arnuka ngimpiri-mamula jajiruwi awuta nuwa-mamanta api ngarra awarra ngawa-rringani arnuka wiyi yimata-mamula (won't call) nuwa jajiruwi,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Kiyi yimi ngawa-yuwuni ngini, “Nuwa yingampa amparrimani ngimparimi ngini nuwa warntirrana pupuwi amintiya nuwa ngimpiri-mamula (call) jajiruwi awuta nuwa-mamanta kapi wuta karlu-nara jajiruwi. Api kayi,” yimi ngawa-yuwuni. “Ngini nuwa ngimpitimarti ngini nginti-mata-wani (help) awuta nuwa-mamanta ngini papurajuwi tiwi pimatama api pakinya papurajuwi tiwi nyirrami nuwulamiya kiyi wiyi nyirra-wani awuta nuwa-mamanta ngini pupuwi tiwi pimatama. Awarra nginingaji karri kiyija parruwarti apawuriji yilaruwu kangi wuta pijara nuwa-mamanta api awanuwanga yingarti parruwarti apawuriji yilaruwu kangi nuwa pijara api nuwa karluwu nimarra nginti-matami kapi awuta nuwa-mamanta ngini, ‘Ngiya wiyi nguwunyirri (wash) awarra parruwarti kangi nuwa pijara.’ Nuwa karluwu awarra nimarra nginti-matami kapi awuta nuwa-mamanta pili nuwa arnuka nginti-mata-kuluwunyi (can't see) pupuni pili yingarti parruwarti kangi nuwa pijara. Awanuwanga nuwa karluwu nimarra nginti-matami kapi nuwa-mamanta ngini, ‘Ngiya wiyi ngimanu-wani (help) nuwa ngini pupuwi tiwi nginti-matami.’ Nuwa nginti-mata-kuluwuny-amiya pakinya, kiyi awungarri nuwa nuwa-mamanta,” yimi ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Kiyi ngawa-yuwuni Jesus nyoni ngirramini yipangiraga kapi awuta tayikuwapi ngarra-mamanta, “Karri nuwa nanginta ngimpirimi ngawa-rringani kuta kamini ngini nuwa ngimpitimarti (need) api ngarra wiyi awarra apakirayi nuwa. Api nanginta nyirrami ngawa-rringani awarra kuta kamini ngini nuwa ngimpitimarti amintiya awanuwanga kularlaga nyirrami awarra kuta kamini ngini nuwa ngimpitimarti api ngarra wiyi ngawa-rringani amanu-wani (help) nuwa ngini ngumpunyayi awarra ngini nuwa kularlaga ngimpirimi. Yimpaja nanginta nyirrami awarra ngawa-rringani kuta kamini ngini nuwa ngimpitimarti api ngarra wiyi awarra apakirayi nuwa,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Nuwa wawurruwi awanuwanga ngimpakirayi nuwa-mamirampi awarra ngini wuta wutimarti (need) karri wuta nanginta wurimi nuwa. Karri wuta nanginta wurimi kirritawuni nuwa api nuwa ngimpakirayi awuta awarra kirritawuni api nuwa arnuka ngimpakirayi waranga kangi wutawa. ");
INSERT INTO tiw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Amintiya karri wuta nanginta wurimi muputi api nuwa ngimpakirayi awuta awarra muputi. Nuwa karluwu nginti-mata-kirayi taringa kangi wutawa karri wuta nanginta wurimi muputi. ");
INSERT INTO tiw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nuwa awuta wawurruwi arnuka-nara papurajuwi api nuwa ngimpakirayi nuwa-mamirampi pupuni yinkiti. Api ngarratuwu ngawa-rringani ngini kuriyuwu warntirrana pupuni api ngarra wiyi apakirayi nuwa awarra arramu-kamini ngini warntirrana pupuni karri nuwa nanginta ngimpirimi awarra.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kiyi yimi ngawa-yuwuni ngini, “Moses amintiya awuta prophets parlingarri purru-wuntiyarra awuta arikutumunuwi yingarti ngirramini (laws) api ngiyatuwu waya karuwa ngirikirimi awarra ngirramini api awarra naki karuwa ngirramini ngini, ‘Nuwa ngimpitimarti nuwa-mamanta ngini pimata-pungintayi (think about) nuwa amintiya awanuwanga ngimpitimarti awuta ngini pimata-wani (to help) nuwa api nuwa pakinya nyirra-pungintayi (think about) awuta nuwa-mamanta kiyi wunta-wani awuta.’ Awarra ngirramini warntirrana (most important).” Ngarra awarra yimi ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Kiyi ngawa-yuwuni Jesus awarra naki nyoni ngirramini yimi kapi awuta tayikuwapi ngarra-mamanta, “Nyirra-punya (follow) ngawa-rringani angatawa jarrumoka. Nyirra awinyirra jarrumoka kirijinga (narrow) api waya juwa kiyija arikutumunuwi wunyayi awinyirra jarrumoka angatawa ngawa-rringani api kiyi wupapunya awinyirra jarrumoka. Nyirra awinyirra jarrumoka ampuriyi kapi ngarra ngawa-rringani japuja api awuta tiwi kapi wupapunya awinyirra jarrumoka api wiyi yiloti wurumuwu kuriyuwu kapi awarra ngawa-rringani. Nyirratuwu awinyirra nyonga jarrumoka api nyirra arikulanga. Wuta tayikuwapi tiwi kapi karluwu kuwa wurimi ngawa-rringani api wuta wupapunya awinyirra jarrumoka angi arikulanga. Wuta awuta tiwi karluwu wiyi japuja wurimi kuriyuwu kapi ngawa-rringani pili awinyirra arikulanga jarrumoka ampuriyi kapi ngarra maputiti japuja,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kiyi nyoni ngirramini yipangiraga ngawa-yuwuni Jesus, “Awi,” yimi kapi awuta tayikuwapi ngarra-mamanta. “Yingampa tiwi wuri-mamuliya (call) prophets amintiya awanuwanga kunyani wurimi ngini awarra ngirramini ngini wuta wuruwaluwa (teach) nuwa api ngawa-rringani ngini-ngatawa ngirramini awarra. Awuta kapi wuri-mamuliya (call themselves) prophets api karluwu wutimarti nuwa ngini kuwa nginti-matami awarra ngirramini ngini-ngatawa ngawa-rringani. Waya juwa wutimarti nuwa ngini kuwa nginti-matami ngini-wutawa jirti ngirramini. Api ngajiti kuwa ngimpajami ngini-wutawa ngirramini awuta kapi wuri-mamuliya prophets. ");
INSERT INTO tiw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","18","Karri nuwa wiyi ngimpakuluwunyi awuta tiwi jirti wurikirimi (doing wrong) api nuwa wiyi ngimpiri-majawu ngini awarra ngirramini ngini wuta nimarra wurimi api ngarra karluwu ngini-ngatawa ngawa-rringani ngirramini awarra. Awuta jajiruwi tiwi karluwu wurikirimi ngini pupuni (do good things). Awarra jirti ngini wuta wurikirimi (the wrong they do) api awarra nginingaji jirti kuruti (fruit) kapi purinjirringa angi jiringa. Yingampa jiringa purinjirringa ampini yingarti murrupun-awurti (thorns) api ngawa arnuka ngawunga pupuka kuruti nginingaji pinyama kangi awinyirra jiringa purinjirringa. Api awarra nginingaji awuta tiwi kapi wuri-mamuliya prophets api wuta karluwu, pili wuta arnuka wurikirimi ngini pupuni. Wuta nginingaji awinyirra purinjirringa angi jirti kuruti ampini pili wuta jirti wurikirimi. Api wutatuwu kapi wuta papurajuwi karluwu jirti wurikirimi (don't do wrong) api wuta nginingaji awinyirra purinjirringa angi nyirra pupuka pili awinyirra pupuka purinjirringa karluwu ampini jirti kuruti. ");
INSERT INTO tiw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Awinyirra purinjirringa angi ampini jirti kuruti api awarra tini ngini apamangi awinyirra purinjirringa api ngarra awawurrini (chops down) awinyirra jiringa purinjirringa kiyi awunyawu awinyirra purinjirringa kangi yikwani. Ngarra awanuwanga ngawa-rringani wiyi apangirri (send) awuta jajiruwi tiwi kapi awarra yikwani kapi maputiti japuja awuta kapi wuta kunyani wurimi ngini wuta wutiyarra nuwa ngini-ngatawa ngawa-rringani ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Api nyirra-kuluwunyi awuta kapi wuruwaluwa (teach) nuwa. Ngini nuwa ngimpakuluwunyi awuta ngini jirti wurikirimi (do wrong) api nuwa wiyi ngimpiri-majawu ngini awarra ngirramini ngini wuta wutiyarra nuwa api ngarra awarra ngirramini karluwu ngini-ngatawa ngawa-rringani ngirramini. Api ngajiti kuwa ngimpajami awarra ngirramini ngini-wutawa.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kiyi yimi ngawa-yuwuni Jesus kapi awuta tayikuwapi ngarra-mamanta, “Yingampa tiwi warntirrana wurimamula (call) ngiya wuta-alawura amintiya kuwa wurimi ngawa-rringani ngini-ngatawa ngirramini. Wuta wiyi awuta wurumuwu kuriyuwu kapi ngini-ngatawa ngawa-rringani japuja,” yimi ngawa-yuwuni. Kiyi yimi ngini, “Wutatuwu yingampa tiwi karluwu kuwa wurimi ngawa-rringani amintiya kunyani wurimi ngini ngiya alawura ngirimi kangi wutawa api wuta wiyi karluwu pimata-muwu kuriyuwu kapi ngawa-rringani ngini-ngatawa japuja,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kiyi yimi kangi wutawa, “Tayikuwapi tiwi karri ngiya wiyi judge ngirimi awuta karri naki awarra murrakupuni wiyi apapaya (this earth will finish) api wuta wiyi awungarri manya nimarra wurimi ngini, ‘Ngawa ngintiri-kirim-ani yingarti mirrikili (miracles). Nginja jipakirayi ngawa ngini-nginjila power api ngawa ngintiri-kirimi awarra mirrikili.’ Wuta awarra wiyi wupangiraga kangilawa awuta kapi kunyani wurimi ngini ngiya alawura ngirimi kangi wutawa,” yimi ngawa-yuwuni. Kiyi yimi ngini, “Wuta awuta tiwi wiyi awanuwanga wupangiraga kangi ngiya, ‘Awuta maputirruwi kapi pirripalamiya yilaruwu kapi yingampa tiwi purnikapa api ngawa papi ngintiniri-mamiyi awuta maputirruwi. Nginja jipakirayi ngawa ngini-nginjila power api ngawa papi ngintiri-mamiyi awuta maputirruwi. Amintiya ngawa nguntu-wuntiyarra awuta arikutumunuwi ngini-ngatawa ngawa-rringani ngirramini pili nginja juwutiyarra ngawa ngini ngawutiyarra awuta tiwi ngini-ngatawa ngirramini.’ Manya wiyi awarra wurimi kangilawa awuta kapi kunyani wurimi ngini ngiya alawura ngirimi kangi wutawa,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kiyi yimi ngini, “Karri wuta wiyi wupangiraga awarra ngirramini kangilawa api ngiyatuwu wiyi ngirimi kangi wuta, ‘Ngiya karluwu ngirripakirayi nuwa ngini-ngilawa power ngini nuwa ngintiri-kirimi awarra mirrikili amintiya awanuwanga ngiya karluwu ngirripangirri (send) nuwa ngini nguntu-wuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Ngiya arnuka ngiya-mamanta nuwa pili nuwa karluwu kuwa ngimpirimi ngini-ngilawa ngirramini api pirri nyirru-wariyi.’ Ngiya wiyi awarra ngipangiraga kangi awuta tiwi karri naki murrakupuni wiyi apapaya (this world will finish), awuta tiwi kapi kunyani wurimi ngini ngiya alawura ngirimi kangi wutawa.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","27","Kiyi ngawa-yuwuni Jesus nyoni ngirramini yipangiraga kapi awuta tayikuwapi ngarra-mamanta, “Ngiya nimarra ngiyimami (going to say) kangi nuwa naki ngirramini (story) ngini (about) yati tini ngini ngarra yimuwu parlingarri. Ngarra yingarti punyipunyi yuwuni (had) awarra tini. Kiyi ngarra yikirimi angatawa kurrampali. Yikirimi kangi yuwurumi yakuluwuni. Api ngarratuwu nginaki nyoni tini ngarra karri-kamini punyipunyi yuwuni api yikirimi angatawa kurrampali kangi jipitini tingati yinkitayi kapi kuluwaga. Kiyi yingarti pakitiringa yipungoli api kapi awarra kuluwaga api awarra kukuni yini-papurti (came up) amintiya yingarti wunijaka jinu-wuriyi juwuntipayi (shook) awinyirra yirrara kurrampali. Kiyi awinyirra kurrampali kapi jipitini tingati ngini ngarra yikirimi ngini ngarra karri-kamini punyipunyi api awinyirra kurrampali yartipili jipakupuraji. Api awinyirra kurrampali kapi yuwurumi yakuluwuni ngini ngarra yikirimi ngini ngarra yingarti punyipunyi api awinyirra karluwu jipakupuraji. Api waya awungarruwu yipapaya (finished) awarra ngirramini (story) ngini awuta yuwurrara wawurruwi,” yimi ngawa-yuwuni kapi ngarra-mamanta. Kiyi ngawa-yuwuni yimi kangi wutawa, “Ngiya waya yingarti ngirramini nimarra ngirimi kangi nuwula api kapi nuwa waya ngintiri-pitingaya (heard) awarra ngirramini ngini-ngilawa api kapi nuwa wiyi kuwa ngimpirimi awarra ngirramini api nuwa awuta nginingaji awarra tini ngini ngarra yingarti punyipunyi ngini ngarra yikirimi angatawa kurrampali kapi yuwurumi yakuluwuni. Api nuwatuwu kapi nuwa wiyi karluwu kuwa nginti-matami awarra ngini-ngilawa ngirramini api nuwa awuta nginingaji awarra tini ngini ngarra karluwu yingarti punyipunyi ngini ngarra yikirimi angatawa kurrampali kapi jipitini tingati.” Ngarra awarra ngawa-yuwuni yipangiraga kapi awuta tayikuwapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kiyi karri ngawa-yuwuni yipapaya (finished) ngini nimarra yimi kapi ngarra-mamanta amintiya awuta tayikuwapi tiwi api awuta tiwi pirimi kangi wutamiya ngini, “Pupuni awarra ngirramini ngini ngarra nimarra arimi. ");
INSERT INTO tiw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngarra awarra warntirrana apangiraga. Api wutatuwu yingampa kapi wuruwaluwa (teach) ngawa ngini-ngatawa ngawa-rringani ngirramini api wuta karluwu nimarra wurimi nginingaji nginaki awarra Jesus.” Wuta awarra pirimi awuta tayikuwapi tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kiyi ngawa-yuwuni Jesus yipumwari awarra jupunyini (hill) kiyi yipapirraya kapi yakuluwuni api tayikuwapi arikutumunuwi pirripapunya ngarra. ");
INSERT INTO tiw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kiyi yati tini yinuwuriyi kangi ngawa-yuwuni. Ngarra awarra tini yuwuni (had) awarra jana leprosy api yuwutimarti ngawa-yuwuni ngini pupuni yimata-kirimi ngarra api kiyi ngarra yipamukuri ngini-ngatawa yirrara yimpula kangi yakuluwuni (knelt down) yinkitayi kangi ngawa-yuwuni ngarra malapwara api yimi kapi ngawa-yuwuni, “Aya, mantani, ngini nginja nimpitimarti api nginja pupuni jija-kirimi (can heal) ngiya,” yimi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Api ngarra ngawa-yuwuni yipamukuri ngini-ngatawa yikara kangi awarra tini kiyi yimi kangatawa, “Kuwa. Ngiya nguwutimarti ngini pupuni ngimata-kirimi nginja. Nginja waya pupuni,” yimi ngawa-yuwuni. Api kiyi awarra tini ngini-ngatawa mipurra yartipili pupuni yima. ");
INSERT INTO tiw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kiyi ngawa-yuwuni nyoni nginaki ngirramini yimi kapi awarra tini, “Ngajiti nimpaja-jiyarra yingampa arikutumunuwi ngini ngiya pupuni ngirikirimi nginja. Api kuwa tami awarra ngirramini (law) ngini Moses parlingarri yikirimi kangi ngawa-rringani ngini-ngatawa (Old Testament) api pakinya tuwariyi kapi awarra priest awungarruwu kapi jurra amintiya tayakirayi ngarra yuwurrara tokampuwi kapi kakirijuwi. Api awarra priest wiyi apakuluwunyi nginja ngini nginja waya pupuni api ngarra wiyi arimi kanginjila, ‘Nginja waya pupuni jiyima api tayakupawurli kanginjila japuja.’ Awarra priest wiyi arimi awarra kanginjila. Api awungarri awuta yingampa arikutumunuwi wiyi wurimajawu ngini nginja waya pupuni.” Ngawa-yuwuni yimi awarra kangi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kiyi ngawa-yuwuni Jesus yuwuriyi kapi awarra town Capernaum kiyi karri papi yimi awungarruwu, yati tini ngini ngarra Roman yinuwuriyi kangatawa. Naki awarra tini alawura yimi kapi tayikuwapi Roman soldiers. Kiyi ngarra nanginta yimi ngawa-yuwuni ngini yimata-wani (to help) ngarra, ");
INSERT INTO tiw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","api yimi kangatawa, “Aya, mantani, yati tini ngini ngarra waki arimi ngini (for) ngiya api ngarra jana awujingi-mili kangilawa japuja. Ngarra awarra yingarti walawala (pain) amintiya awanuwanga ngarra arnuka apangulimayi. Ngiya nguwutimarti nginja ngini pupuni jimata-kirimi ngarra,” yimi awarra alawura kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Api ngawa-yuwuni yimi kapi awarra alawura, “Manya, ngiya wiyi nguwuja kanginjila japuja kiyi pupuni ngirikirimi awarra ngini ngarra jana,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Api awarra alawura yimi kangi ngawa-yuwuni, “Karluwu, ngajiti nimpaju-wariyi kangilawa japuja pili ngiya wiyi arliranga pili nginja warntirrana nginjila. Waya juwa awungarra nimarra tami ngini awarra tini ngini ngarra purunjini pupuni yimatama api ngarra wiyi pupuni arima,” yimi awarra alawura kapi ngawa-yuwuni. Kiyi awarra alawura yimi kapi ngawa-yuwuni, “Ngiya alawura nginingaji nginja api ngiya waki ngirimi ngini (for) awarra alawura ngini ngarra ngatawa awarra ngini arimuwu kapi Rome amintiya ngarra yikirimi ngiya ngini ngiya alawura kapi tayikuwapi soldiers. Karri ngiya ngipangiraga kapi yati tini, ‘Tuwariyi nankitawu!’ api ngarra yartipili awuriyi awungarruwu. Kiyi ngipangiraga kapi nyoni tini, ‘Kali tuwaripa!’ api ngarra yartipili awunu-wuriyi. Kiyi ngiya nimarra ngirimi kapi nyoni tini ngini ngarra waki yimatami (should work) api ngarra kuwa arimi yartipili,” yimi awarra alawura kapi ngawa-yuwuni. Kiyi yimi ngini, “Awarra ngatawa ngini ngarra japuja kuriyuwu (God) api ngarra yikirimi nginja alawura kapi tayikuwapi arikutumunuwi amintiya ngarra yipakirayi nginja yingarti power api karri nginja wiyi nimarra nimpirimi ngini awarra tini pupuni yimatama api ngarra wiyi awungarri pupuni arima.” Ngarra awarra alawura yimi awarra kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Karri ngawa-yuwuni yipitingaya (heard) awarra ngirramini ngini awarra alawura yipangiraga api yipakuluwunyi awuta tiwi kapi pirripapunya ngarra api yimi kangi wutawa, “Nayi kama awarra naki alawura ngini ngarra arnuka Jew api ngarra warntirrana kuwa arimi ngini ngiya nguwuni power ngini naki mirrikili (miracle) ngimata-kirimi api nuwa arikutumunuwi kapi nuwa Jews nginingaji ngiya api nuwa waya juwa kiyija kuwa ngimpirimi ngiya,” yimi ngawa-yuwuni kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kiyi ngawa-yuwuni yimi ngini, “Parlinginari (later) tayikuwapi arikutumunuwi kapi wuta arnuka Jews awuta kapi japuja wurimi kapi yingarti murrakupuni api wuta wiyi kuwa wurimi kangilawa. Wuta wiyi awuta arikutumunuwi wuriyi kuriyuwu kapi ngawa-rringani japuja api awungarruwu wuta wiyi wuwapa pupuni yinkiti wutiyati ngawa-ampi Abraham amintiya Isaac amintiya Jacob. Wuta wiyi awungarri warntirrana kukunari wurimi awuta tayikuwapi kapi wuta arnuka Jews awuta kapi kuwa wurimi kangilawa. ");
INSERT INTO tiw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Api nuwatuwu Jews ngawa-rringani pakinya yimamula (called) nuwa ngarra-mamirampi api ngarra yuwutimarti ngini nuwa wiyi nginti-matu-wariyi kuriyuwu kapi ngarra japuja. Api nuwa yingampa kapi nuwa Jews tani-waya (no matter) nuwa ngimpiri-mamula (call) Abraham nuwa-amini api nuwa wiyi arnuka ngumpuriyi kapi ngawa-rringani ngarra japuja pili nuwa arnuka kuwa ngimpirimi kangilawa api ngawa-rringani wiyi awunyawu nuwa kapi awarra murrakupuni ngini yartijanga. Awungarruwu nuwa wiyi yimpaja pirlikiti ngimpirimi amintiya wiyi ‘yakayi, yakayi’ jingawu ngimpirimi pili nuwa wiyi yingarti walawala (pain).” Awarra yimi ngawa-yuwuni kangi awuta arikutumunuwi kapi wuta Jews. ");
INSERT INTO tiw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kiyi ngawa-yuwuni yimi kapi awarra alawura, “Tuwariyi japuja api awarra tini ngini waki arimi ngini (for) nginja api ngarra waya pupuni yima pili nginja kuwa jiyimi kangilawa.” Awarra yimi ngawa-yuwuni kangi awarra alawura. Api karri ngawa-yuwuni nimarra yimi awarra kangi awarra alawura api awarra tini ngini ngarra jana api ngarra awungarri pupuni yima. ");
INSERT INTO tiw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kiyi karri ngawa-yuwuni Jesus yuwujirr-angulimay-ani kangi jarrumoka api yuwurrara wawurruwi kapi wuta yinkilatuwi wuta pirripapunya ngarra. Kiyi wuta jingawu pirimi kangatawa, “Aya,” pirimi, “Nginja nginjila nginingaji awarra King David ngini parlingarri yimuwu api tawani ngawa,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Api ngawa-yuwuni yuwuja-la kiyi yipawuriji yilaruwu kapi kurrampali api awuta yuwurrara kapi yinkilatuwi pirripapunya ngarra yilaruwu kapi awinyirra kurrampali kiyi purruwuriyi kapi ngawa-yuwuni. Kiyi ngawa-yuwuni nanginta yimi awuta yuwurrara, “Nuwa kuwa ngimpirimi ngini ngiya pupuni ngirrija-kirimi (can heal) nuwa pijar-ana?” Awarra ngawa-yuwuni nanginta yimi awuta yuwurrara. Kiyi, “Kuwa,” pirimi. “Ngawa ngarimajawu ngini nginja jija-kirimi (can make) ngawa ngini tuwanga ngapakuluwunyi pili nginja warntirrana nginjila,” pirimi awuta yuwurrara kapi yinkilatuwi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kiyi ngawa-yuwuni yipamukuri ngarra yikara kapi wuta pijara awuta yinkilatuwi kiyi yimi kangi wuta, “Nuwa warntirrana kuwa ngimpirimi kangiya api awarra ngiya pupuni ngirikirimi ngini-nuwula pijara,” yimi ngawa-yuwuni kangi awuta yuwurrara. ");
INSERT INTO tiw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Api karri ngawa-yuwuni awarra yipangiraga api awungarri awuta yuwurrara wuta pijara waya pupuni yima api wuta tuwanga pirripakuluwunyi. Kiyi ngawa-yuwuni tulimiya (straight) yipangiraga kapi awuta, yimi ngini, “Nuwa ngajiti ngimpaja-jiyarra yingampa arikutumunuwi ngini ngiya ngirikirimi nuwa ngini tuwanga ngimpakuluwunyi,” yimi ngawa-yuwuni kangi awuta yuwurrara wawurruwi. ");
INSERT INTO tiw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Awuta wawurruwi karluwu kuwa pirimi (didn't obey) awarra ngirramini ngini ngawa-yuwuni yipangiraga kangi wuta api kularlaga pirimi kapi awarra arikulani murrakupuni kapi ngawa-yuwuni yimuwu. Awungarruwu wuta purru-wuntiyarra awuta tayikuwapi arikutumunuwi ngini ngawa-yuwuni yikirimi wuta ngini tuwanga pirripakuluwunyi. ");
INSERT INTO tiw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Karri awuta yinkilatuwi purrupumwari ngawa-yuwuni Jesus api yingampa arikutumunuwi piniri-marruriyi kangi ngawa-yuwuni yati tini ngini maputiti yipalamiya kangi ngarra purnikapa api awarra maputiti yikirimi awarra tini ngini ngarra karluwu nimarra yirrijami, ");
INSERT INTO tiw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","api ngawa-yuwuni papi yiniri-mamiyi awarra maputiti kapi awarra tini ngarra purnikapa. Api karri awarra maputiti papi yinirimi (came out) kapi ngarra purnikapa api awarra tini awungarri nimarra yimi. Awuta tayikuwapi arikutumunuwi karri wuta piri-pitingaya (heard) awarra tini ngini nimarra yimi api wuta pirimarlingiyi (got a surprise) kiyi nimarra pirimajirri ngini, “Karri-kuwapi arikutumunuwi parlingarri pirikirimi mirrikili (miracle) nginingaji naki mirrikili awungarra kapi ngini-ngawula murrakupuni Israel,” pirimajirri awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yingampa (some) Pharisees awungarruwu purru-wujingi-rritani (were standing) api wuta nimarra pirimajirri, “Ngawa-rringani ngini kuriyuwu ngarra karluwu yipakirayi awarra naki Jesus power ngini papi yini-mata-mamiyi maputirruwi kapi waya pirripalamiya kapi arikutumunuwi ngini-wutawa purnikapa. Yita awarra ngini ngarra alawura kapi awuta tayikuwapi maputirruwi (Satan) api ngarra awarra ngini apakirayi naki awarra Jesus power ngini papi yini-mata-mamiyi awuta maputirruwi kapi waya pirripalamiya kangi arikutumunuwi ngini-wutawa purnikapa,” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kiyi ngawa-yuwuni Jesus yimi kapi awuta wamurrara yuwurrara (12) ngarra-mamanta, “Nyirru-waripa pili ngiya ngimata-ngirri (am sending) nuwa kapi yingarti murrakupuni.” Kiyi wuta punuwuriyi kapi ngawa-yuwuni. Kiyi yimi ngawa-yuwuni kangi wutawa, “Awungarruwu kapi awarra yingarti murrakupuni nuwa wiyi papi nyirra-mamiyi awuta maputirruwi kapi waya pirripalamiya kapi wuta yingampa tiwi purnikapa. Amintiya awanuwanga nuwa wiyi pupuwi nyirra-kirimi awuta kapi wuta jana, tayikuwa-ni (all) awarra jana ngini wuta wuni. Ngiya wiyi ngipakirayi nuwa ngini-ngilawa power ngini pupuwi ngimpiri-kirimi awuta kapi wuta jana amintiya ngini papi ngimpiniri-mamiyi awuta maputirruwi kapi waya pirripalamiya kapi awuta tiwi purnikapa.” Ngarra awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Awuta wamurrara yuwurrara (12) wawurruwi ngawa-yuwuni ngarra-mamanta api ngawa-yuwuni yimamula (called) awuta apostles. Ngini-ngatawa meaning awarra yintanga apostles api awuta wawurruwi kapi ngawa-yuwuni yuwunga ngini awuta amintiya ngawa-yuwuni wutiyati waki pimatami. Wuta yintanga awuta apostles api ngarra pakinya Simon. Api ngarra nyoni yintanga awarra Simon api Peter. Kiyi ngarruwani Andrew. Kiyi James amintiya ngarruwani John. Wuta-rringani Zebedee awuta yuwurrara. ");
INSERT INTO tiw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Kiyi Philip, kiyi Bartholomew, kiyi Thomas, kiyi Matthew. Ngarra awarra Matthew pakinya waki yimani ngini (for) awuta Roman alawuruwi amintiya nanginta yimani ngarra-mamanta awuta Jews awarra kunawuni ngini tax. Kiyi naki nyoni ngawa-yuwuni ngarra-mantani api awarra James ngini ngarra-rringani Alphaeus, kiyi Thaddaeus. ");
INSERT INTO tiw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Kiyi nyoni Simon. Api ngarra nyoni yintanga awarra Simon api Patriot. Wuta pirimamula (called) Patriot awarra Simon amintiya ngarra-mamanta pili wuta jirti purumuwani awuta Romans amintiya jirti ngirramini (trouble) pirripakiray-ani awuta. Kiyi naki nyoni ngarra-mantani ngawa-yuwuni api Judas Iscariot. Ngarra awarra wiyi (later on) traitor yimi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Kiyi ngawa-yuwuni yipangiraga kapi awuta wamurrara yuwurrara (12) ngarra-mamanta api yimi ngini, “Nyirru-wariyi kapi awarra yingarti murrakupuni kapi wuta wurumuwu awuta ngawa-mamanta kapi wuta Jews api nyirra-jiyarra awuta ngawa-rringani ngini-ngatawa ngirramini. Awuta ngawa-mamanta nginingaji sheepuwi kapi wuta waya pirripamulijipa pili wuta waya purrupumwari ngawa-rringani angatawa jarrumoka awuta ngawa-mamanta Jews. Ngajiti ngimpaju-wariyi kapi awuta arikutumunuwi kapi wuta karluwu Jews amintiya awanuwanga ngajiti ngimpaju-wariyi kapi awarra town kapi awarra murrakupuni Samaria.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kiyi yimi ngawa-yuwuni kapi awuta ngarra-mamanta, “Nyirra-jiyarra awuta ngawa-mamanta Jews ngini ngawa-rringani ngini kuriyuwu waya yinkitayi awunt-amangi wuta amintiya ngini ngarra wiyi alawura arimi kangi wutawa,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kiyi yimi ngini, “Pupuwi nyirra-kirimi kapi wuta jana. Amintiya awuta kapi waya pajuwani api nyirra-kirimi awuta ngini wupukularri yimpanguwi wurimi tuwanga. Amintiya awuta kapi wupumari (have bad sores) api pupuni nyirra-kirimi ngini-wutawa mipurra. Amintiya awuta tiwi kapi wuta maputirruwi waya pirripalamiya kangi wuta purnikapa api papi nyirra-mamiyi awuta maputirruwi kapi wuta purnikapa awuta tiwi.” Ngarra awarra yipangiraga ngawa-yuwuni. Kiyi yimi ngini, “Karri nuwa pupuwi ngimpiri-kirimi awuta tiwi kapi purunjuwi api ngajiti nanginta ngimpajami awuta kunawuni. Yita karri ngiya nguruwaluwa (taught) nuwa amintiya karri ngirripakirayi nuwa ngini-ngilawa power api ngiya karluwu nanginta nuwa kunawuni api nuwa wiyarri ngajiti nanginta ngimpajami kunawuni kapi awuta tiwi karri nuwa pupuwi ngimpiri-kirimi awuta.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Kiyi yimi ngawa-yuwuni ngini, “Karri nuwa ngumpuriyi kapi awarra yingarti murrakupuni api nuwa ngajiti ngimpaja-marruriyi kunawuni awungarruwu pili awuta tiwi kapi nuwa wiyi pupuwi ngimpiri-kirimi wuta awuta wiyi pimata-mangi (should look after) nuwa. Amintiya ngajiti ngimpaja-marruriyi awinyirra tunga angi nuwa ngimpalami yinkiti. Amintiya ngajiti nyonga kuluji ngimpaja-marruriyi. Waya juwa natinga kuluji angi nuwa ngimpiri-kuripiya (wear). Amintiya ngajiti nyonga muntamini (shoes) amintiya ngajiti nyoni jitika (walking stick). ");
INSERT INTO tiw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Amintiya karri nuwa wiyi papi ngimpirimi kapi kuta maka awarra murrakupuni api kularlaga nyirrami ngini pupuni tini kiyi nyirra-muwu kangatawa kurrampali. Nuwa ngajiti ngimpaja-mwari awinyirra kurrampali. Waya juwa karri waya ngumpuriyi kapi nyoni murrakupuni. ");
INSERT INTO tiw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Amintiya karri nuwa waya yinkitayi ngimpawuriji yilaruwu angatawa awarra tini kurrampali api nimarra nyirrami kangatawa awarra tini amintiya ngarra-purnayinga ngarra-mamirampi, nyirrami ngini, ‘Ngawa ngawutimarti ngawa-rringani ngini kuriyuwu ngini yimata-mangi nuwa.’ ");
INSERT INTO tiw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Api ngini awuta tiwi kangi awinyirra kurrampali wutimarti nuwa ngini japuja nginti-matami kangi wuta kurrampali api ngarra ngawa-rringani wiyi apamangi awuta nginingaji nuwa nimarra ngintirimi kangi wutawa. Api ngini wuta karluwu wutimarti nuwa ngini japuja nginti-matami kangi wutawa api nyirrami kapi awuta tiwi, ‘Ngawa-rringani ngini kuriyuwu wiyi karluwu yimata-mangi nuwa.’ Nuwa awarra nyirrami kapi awuta tiwi kapi karluwu wutimarti nuwa ngini japuja nginti-matami kangi wutawa. ");
INSERT INTO tiw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amintiya kuta maka awarra murrakupuni kapi nuwa ngumpuriyi api arrami yingampa awuta tiwi kapi awarra murrakupuni wurimi kangi nuwa, ‘Pirri. Nyirru-wariyi. Ngawa arnuka ngawutimarti ngini-nuwula ngirramini.’ Api ngini awuta wupangiraga awarra kangi nuwula api nyirra-mwari awarra murrakupuni. Amintiya awanuwanga ngini nuwa ngimpawuriji yilaruwu kuta anginuwanga kurrampali api ngini awuta tiwi wurimi kangi nuwula, ‘Pirri!’ api nyirra-mwari awinyirra kurrampali. Api karri nuwa waya ngimpija api awarra parruwarti kangi ngini-nuwula muntamini api nyirra-nyawu awarra parruwarti. Api awuta tiwi karri wupakuluwunyi nuwa ngini ngumpunyawu awarra parruwarti kangi nuwa muntamini api wuta wiyi awungarri wurimi kangi wutamiya, ‘Arramukuta awarra ngatawa ngini ngarra japuja kuriyuwu (God), awarra ngini wuta wurimamula (call) wuta-rringani api ngarra arrami wiyi jirti ngirramini (trouble) amant-akirayi ngawa pili ngawa karluwu nguntu-wutimarti ngini-ngatawa ngirramini.’ Wuta awuta tiwi awarra wiyi wupangiraga kangi wutamiya,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kiyi yimi ngawa-yuwuni ngini, “Karri ngiya wiyi ngipakupawurli kuriyuwu kapi ngiya-rringani api yingampa tiwi kapi wuta jirti wurumuwu ngiya wiyi wunga nuwa api wurimarruriyi nuwa kapi awarra courthouse api awuta alawuruwi kapi awarra courthouse wiyi judge wurimi nuwa pili nuwa kuwa ngimpirimi ngiya.” Amintiya yimi ngawa-yuwuni ngini, “Awuta tiwi wiyi awanuwanga wurimarruriyi nuwa kapi angawula jurra api awungarruwu awuta alawuruwi wiyi wunga murrukuni api wuripirni nuwa pili nuwa kuwa ngimpirimi ngiya. ");
INSERT INTO tiw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Amintiya wiyi awanuwanga wunga nuwa api wurimarruriyi nuwa kapi awuta alawuruwi kapi wuta kings amintiya kapmanuwi pili nuwa ngimpapunya angilawa jarrumoka. Api awungarri nuwa wiyi ngumpunt-iyarra awuta alawuruwi ngini-ngilawa ngirramini. Amintiya nuwa wiyi awanuwanga ngumpunt-iyarra awarra ngirramini ngini-ngilawa kapi awuta tiwi kapi wuta karluwu Jews.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Kiyi yimi ngawa-yuwuni ngini, “Karri awuta tiwi wurimarruriyi nuwa kapi awarra courthouse api ngajiti ngimpajami kangi nuwulamiya, ‘Ngawa awungana (what) nimarra ngamatami kangi awuta alawuruwi?’ Ngajiti awarra ngimpajami kangi nuwulamiya pili ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) wiyi awungarri amant-akirayi nuwa awarra ngirramini ngini nuwa nimarra nginti-matami (should say) kapi awuta alawuruwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kiyi nyoni ngirramini yipangiraga ngawa-yuwuni, yimi ngini, “Nuwa kapi ngimpapunya angilawa jarrumoka api yingampa nuwa-ngirimipi wiyi jirti wurumuwu ngini-ngilawa ngirramini api wuta wiyarri wiyi wurimarruriyi nuwa kapi awarra courthouse api awungarruwu awuta alawuruwi wiyi pajuwani wurikirimi nuwa. Wuta yingampa tiwi wiyi traitor wurimi kapi wuta-yupi amintiya wuta-ngilipi kapi wupapunya angilawa jarrumoka api wiyi wurimarruriyi awuta kapi awuta majatawi api awuta majatawi wiyi wuripirni awuta. Amintiya wutatuwu yingampa wiyi awanuwanga traitor wurimi kapi wuta-mamirampi amintiya wutatuwu yingampa tiwi wiyi awanuwanga traitor wurimi kapi wuta-rringanuwi wuta-naruwi api wurimarruriyi awuta kapi awuta majatawi ngini wuripirni awuta. ");
INSERT INTO tiw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tayikuwapi tiwi wiyi jirti wurumuwu nuwa pili nuwa ngimpapunya angilawa jarrumoka. Api nuwa kapi wiyi yiloti ngimpapunya angilawa jarrumoka api nuwa wiyi japuja kuriyuwu kapi ngiya-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kiyi ngawa-yuwuni yipangiraga naki nyoni ngirramini kapi ngarra-mamanta, “Karri nuwa kuta maka awarra murrakupuni ngumpu-wuriyi api ngini awuta tiwi jirti ngirramini (trouble) wupakirayi nuwa api yartipili nyirra-mwari awarra murrakupuni api nyirru-wariyi kapi nyoni murrakupuni api awungarruwu nyirra-jiyarra awuta tiwi ngini-ngilawa ngirramini.” Awarra yimi ngawa-yuwuni kapi ngarra-mamanta. Kiyi ngawa-yuwuni yimi ngini, “Ngiya wiyi ngumpumwari nuwa api nuwa wiyi ngimpiri-marruriyi ngini-ngilawa ngirramini kapi awarra yingarti towns kapi awungarra naki murrakupuni Israel. Api karri ngiya wiyi nguwuni-pakupawurli (come back) kapi nuwa api ngiya wiyi nguwunyayi ngini nuwa karluwu nanuwanga nguntuwuriyi kapi yingampa (some) towns kapi awungarra naki murrakupuni Israel. Ngarra awarra warntirrana. Ngiya nuwa nuwa-yuwuni nuwa tayikuwapi arikutumunuwi. Ngiya-rringani yini-pangirri (sent) ngiya kapi nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kiyi yimi ngawa-yuwuni ngini, “Yingampa tiwi wiyi arrami wutimarti ngini pajuwani pimata-kirimi nuwa api nuwa ngajiti ngimpaja-wanga awuta pili wuta waya juwa pajuwani wurikirimi ngini-nuwula purnikapa. Wuta karluwu pajuwani pimata-kirimi (can't kill) ngini-nuwula yimanka. Api ngajiti ngimpaja-wanga awuta tiwi. Waya juwa nyirra-wanga ngawa-rringani ngini kuriyuwu pili ngini (if) ngarra awutimarti ngarra wiyi apangirri (send) ngini-nuwula purnikapa amintiya yimanka kapi awarra yikwani ngini ngarra ngawa-rringani yikirimi ngini ngarra maputiti wiyi japuja awungaji (hell).” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kiyi tuwanga yimi ngawa-yuwuni ngini, “Nuwa tiwi kapi nimarra ngimpirimi kapi nuwa-mamanta ngini nuwa kuwa ngimpirimi ngiya api karri ngiya-rringani wiyi judge arimi nuwa karri naki awarra murrakupuni wiyi apapaya (when this earth finishes) api ngiya wiyi awungarri nguwutiyarra ngiya-rringani ngini ngiya ngiya-mamanta nuwa. ");
INSERT INTO tiw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Api nuwatuwu yingampa kapi nimarra ngimpirimi kapi nuwa-mamanta ngini nuwa karluwu kuwa ngimpirimi ngiya api ngiya wiyi nguwutiyarra ngiya-rringani ngini nuwa karluwu ngiya-mamanta.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","36","Kiyi ngawa-yuwuni nyoni nginaki ngirramini yipangiraga, “Arramukuta yingampa tiwi nimarra wurimi kangi wutalamiya, ‘Ngarra ngawa-yuwuni yinuwuriyi kapi ngawa arikutumunuwi pili ngarra yuwutimarti ngini yimata-kirimi nginingaji ngawula arikutumunuwi ngini ngawa pupuni ngamata-muwajirri (should like each other).’ Arrami yingampa tiwi nimarra wurimi awarra. Api karluwu. Yita awuta arikutumunuwi kapi wuta waya kuwa wurimi kangi ngiya api ngiya ngunuwuriyi kapi wuta pili-ngini wuta wiyi jirti ngirramini (trouble) wuni pili wuta-ngirimipi kapi karluwu kuwa wurimi kangi ngiya api wuta wiyi jirti wurumuwu awuta amintiya wiyi jirti ngirramini wupakirayi awuta, nginingaji yati tini wiyi jirti arimuwu ngarra-rringani amintiya nyirratuwu natinga tinga wiyi jirti ampirimuwu nyirra-naringa amintiya nyirratuwu nyonga tinga wiyi jirti ampirimuwu nyirra-timitinga. Awuta arikutumunuwi kapi karluwu kuwa wurimi ngiya api wuta wiyi jirti wurumuwu awuta wuta-ngirimipi kapi kuwa wurimi ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kiyi ngawa-yuwuni tuwanga yimi ngini, “Awuta tiwi kapi warntirrana puranji wurumuwu wuta-rringanuwi amintiya wuta-naruwi api karlu-nara puranji wurumuwu ngiya api ngiya karluwu ngiya-mamanta awuta tiwi. Amintiya awanuwanga awuta tiwi kapi warntirrana puranji wurumuwu wuta-mwaruwi wuta-mamirampi api wuta karlu-nara puranji wurumuwu ngiya api ngiya karluwu ngiya-mamanta awuta tiwi,” yimi ngawa-yuwuni. Kiyi yimi ngini, “Nuwa arikutumunuwi nyirra-pungintayi (think about) ngiya pakinya api wutatuwu yintayi (behind) nuwa-ngirimipi pili ngini (if) nuwa karluwu ngimpiri-pungintayi ngiya pakinya api ngiya karluwu ngiya-mamanta nuwa,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","39","Kiyi nyoni ngirramini yimi ngawa-yuwuni kapi ngarra-mamanta, “Wuta yingampa tiwi jirti wurumuwu ngiya api wuta wiyi awuta wupamukuri ngiya kuriyuwu kapi arikitirropurtayi (cross). Wuta wiyi awuta tiwi awanuwanga jirti ngirramini (trouble) wupakirayi nuwa kapi kuwa ngimpirimi ngiya api ngini nuwa wiyi ngumpumwari angilawa jarrumoka karri wuta awarra ngirramini (trouble) wupakirayi nuwa api ngiya wiyi arnuka ngirimamula (call) nuwa ngiya-mamanta amintiya nuwa wiyi karluwu japuja nginti-matami kuriyuwu kapi ngiya-rringani. Api nuwatuwu kapi nuwa wiyi karluwu kuwa nginti-matami awuta tiwi kapi jirti ngirramini wupakirayi nuwa api waya juwa ngimpapunya-la (keep following) angilawa jarrumoka api nuwa awuta wiyi japuja ngimpirimi kuriyuwu kapi ngiya-rringani. Kayi, ngiya karluwu nguru-pungintayi (think about) ngiyalamiya. Ngiya waya juwa nguru-pungintayi awarra waki ngini ngiya-rringani awutimarti ngiya ngini ngimata-kirimi (do). Api nuwa awungani (that way) nyirrami nginingaji ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kiyi ngawa-yuwuni Jesus karri ngarra yipangirri (sent) ngarra-mamanta kapi awarra yingarti murrakupuni api ngarra yuwuriyi kapi nyoni towns awungarruwu kapi awarra murrakupuni Galilee. Ngarra awungaji yuwuntiyarra awuta arikutumunuwi ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Parlingarri ngawa-rringani yuwutiyarra awarra prophet Isaiah ngirramini ngini (about) ngarra ngawa-yuwuni Jesus. Api awarra Isaiah yuwuntiyarra arikutumunuwi awarra ngirramini. Api awarra ngirramini ngini awarra Isaiah yipangiraga ngini (about) ngawa-yuwuni api wiyi parlinginari (later) warntirrana yima (came true). ");
INSERT INTO tiw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ngawa-rringani yuwutiyarra awarra Isaiah awarra naki ngirramini ngini (about) ngawa-yuwuni. Ngarra karluwu tuwa yimi ngarra-mirani ngarra yintanga, api yimi ngini, “Ngarra awarra nayi tini api ngiya parlingarri ngurru-wunga (picked) awarra ngini wiyi waki yimatami ngini (for) ngiya. Ngiya puranji ngurumuwu awarra amintiya kukunari ngirimi kangi ngarra. Ngiya wiyi ngipakirayi awarra ngini-ngilawa pukwiyi (Holy Spirit) api ngarra wiyi awuntiyarra awuta arikutumunuwi ngini-ngilawa ngirramini,” yimi ngawa-rringani. Amintiya nyoni nginaki ngirramini yimi awarra ngawa-rringani ngini (about) ngarra-mirani Jesus, “Awarra tini ngini ngarra wiyi waki arimi ngini (for) ngiya api ngarra wiyi awuntiyarra ngini-ngilawa ngirramini kapi tayikuwapi arikutumunuwi kapi wuta Jews amintiya awanuwanga awuta kapi wuta karluwu Jews api ngarra wiyi awuntiyarra awuta arikutumunuwi ngini awuta tiwi kapi wiyi wunyawu awarra jirti (the badness) ngini apalamiya kangi wuta ruwuti api ngiya wiyi ngirimarruriyi awuta kuriyuwu kapi ngiya japuja.” Ngarra awarra yipangiraga ngawa-rringani ngini (about) ngarra-mirani Jesus. ");
INSERT INTO tiw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Amintiya yimi ngini, “Awarra tini ngini ngarra wiyi waki arimi ngini (for) ngiya ngarra wiyi karluwu yimata-wayatipi (won't argue) kapi awuta arikutumunuwi. Amintiya ngarra arnuka jingawu yimatami. Awanuwanga karluwu nimarra yimatami makirrana kapi jarrumoka. ");
INSERT INTO tiw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Amintiya awuta tiwi kapi mampara kuwa wiyimami (starting to obey) ngini-ngatawa ngirramini api karri awuta tiwi kuta kamini jirti wurikirimi (do wrong thing) ngarra wiyi putuputuwu awunt-akirayi (forgive) awuta. Awanuwanga awuta tiwi kapi wuta waya yinkitayi wupumwari angatawa pupuka jarrumoka api ngarra wiyi awarra tini awunu-wani (help) awuta api wuta wiyi warntirrana wupapunya angatawa jarrumoka. Ngarra karluwu awarra tini yimata-mwari ngini-ngilawa waki. Ngarra wiyi yiloti awunu-wani awuta arikutumunuwi api wuta wiyi awuta tiwi kuwa wurimi ngini-ngilawa ngirramini. Ngarra wiyi awungani (that way) apapaya awarra waki ngini ngarra wiyi arikirimi (do) ngini (for) ngiya amintiya wiyi warntirrana pupuni arikirimi awarra nginaki murrakupuni (earth).” Ngarra awarra yipangiraga ngawa-rringani ngini (about) ngarra-mirani Jesus. ");
INSERT INTO tiw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kiyi yimi ngawa-rringani ngini, “Tayikuwapi tiwi kapi wurumuwu kangi yingarti murrakupuni wiyi kuwa wurimi awarra tini ngini ngarra wiyi putuputuwu apakirayi (forgive) awuta awarra jirti ngini pirikirim-ani (the wrong they've done) amintiya awanuwanga wiyi kuwa wurimi ngini ngarra wiyi awunt-amangi awuta tiwi awarra tini ngini ngarra waki arimi ngini (for) ngiya,” yimi ngawa-rringani. Api awarra ngirramini ngini-ngatawa ngawa-rringani api awarra Isaiah yikirimi (wrote) awarra ngirramini kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament). Awarra tini ngini ngawa-rringani yipangiraga ngini ngarra wiyi waki arimi ngini (for) ngarra api ngarra awarra ngarra-mirani Jesus. ");
INSERT INTO tiw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Natinga wumunga awuta yingampa awuta Pharisees amintiya scribes nanginta pirimi ngawa-yuwuni, “Aya mantani,” pirimi. “Ngawa ngawutimarti ngini nginja arikulani mirrikili (miracle) jimata-kirimi api karri ngawa ngapakuluwunyi awarra mirrikili api ngawa wiyi ngarimajawu ngini ngarra ngawa-rringani ngini kuriyuwu yini-pangirri (sent) nginja kapi ngawa arikutumunuwi.” Wuta awarra pirripangiraga kapi ngawa-yuwuni awuta Pharisees amintiya scribes. ");
INSERT INTO tiw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Api ngawa-yuwuni yimi kangi wutawa, “Nuwa arikutumunuwi kapi nuwa ningani ngumpuru-muwu api nuwa ngimpitimarti ngini nginti-mata-kuluwunyi awarra arikulani mirrikili pili nuwa jajiruwi amintiya nuwa karluwu kuwa ngimpirimi ngawa-rringani ngirramini. Nuwa wiyi waya juwa ngimpakuluwunyi arikulani mirrikili nginingaji ngarra ngawa-rringani parlingarri yikirimi karri ngarra Jonah yimuwu. ");
INSERT INTO tiw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nuwa ngimpiri-majawu ngini awarra Jonah karri ngarra yimuwu api ngarra awarra arikulani muputi yiparungumi (swallowed) awarra Jonah api ngarra yimuwu yirrajirrima wumunga (days) kapi ngarra pitipita awarra arikulani muputi api wiyi (later on) awarra muputi papi yiniri-mamiyi awarra Jonah api kiyi awarra Jonah yipukularri api tuwanga yimpangini. Ngarra awarra mirrikili parlingarri yikirimi ngawa-rringani api ngiya wiyi awanuwanga ngurumuwu yirrajirrima wumunga yilaruwu kapi yakuluwuni (under the earth), karri ngiya pakinya pajuwani ngirimi. Kiyi ngiya-rringani wiyi arikirimi ngiya ngini wiyi yimpangini ngupukularri. Awarra mirrikili nuwa wiyi ngimpakuluwunyi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta Pharisees amintiya scribes. ");
INSERT INTO tiw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","48","Kiyi ngawa-yuwuni Jesus nimarra yimi kapi awuta arikutumunuwi yilaruwu kapi kurrampali. Kiyi ngawa-yuwuni ngarra-naringa amintiya awuta wawurruwi ngawa-yuwuni ngarra-marrikulupi punuwuriyi kapi awinyirra kurrampali pili purru-wutimarti ngini nimarra pimatami kangatawa awarra ngawa-yuwuni. Kiyi yati awuta arikutumunuwi yuwutiyarra ngawa-yuwuni ngini ngarra-naringa amintiya ngarra-marrikulupi purru-wujingi-rritani (were standing) turruwuni api purru-wutimarti ngini nimarra pimatami kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kiyi ngawa-yuwuni yuwurtimini (pointed) kapi ngarra-mamanta api yimi ngini, “Kapinaki awuta ngiya-mamanta api ngiya ngirimamula (call) awuta ngiya-naruwi ngiya-ngilipi ");
INSERT INTO tiw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","pili awuta tiwi kapi kuwa wurimi ngawa-rringani ngini-ngatawa ngirramini api ngiya awuta ngirimamula ngiya-ngilipi amintiya ngiya-naruwi.” Ngarra awarra yipangiraga awarra ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kiyi ngawa-yuwuni yimi ngini, “Amintiya wutatuwu yingampa arikutumunuwi api karri wuta wuri-pitingaya (hear) ngawa-rringani ngini-ngatawa ngirramini api wuta warntirrana kuwa wurimi awarra ngirramini amintiya yingarti waki wurimi ngini (for) ngawa-rringani. Awuta tiwi nginingaji awarra yakuluwuni ngini yarti-puranji amintiya awarra ngirramini ngini wuta wuri-pitingaya api nginingaji awarra kurukura ngini yipakupuraji kapi awarra yakuluwuni ngini yarti-puranji. Api awuta arikutumunuwi karri wuta wuri-pitingaya ngawa-rringani ngini-ngatawa ngirramini api wuta warntirrana wuru-pungintayi (think about) awarra ngirramini amintiya awarra ngirramini api kiyi wuta yingarti waki wurimi ngini (for) ngawa-rringani.” Ngawa-yuwuni awarra yuwuntiyarra ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kiyi ngawa-yuwuni yuwuntiyarra awuta arikutumunuwi ngirramini (story) ngini yati alawura yipamangi garden api yuwunyawu ngini pupuni kurukura (seed) kapi awarra garden. Ngarra karluwu ngawa-yuwuni yuwuntiyarra awuta tiwi ngini-ngatawa meaning awarra ngirramini. Ngarra yuwutimarti awuta tiwi ngini warntirrana pimata-pungintayi (think about) awarra ngirramini ngini pimata-nyayi (to find out) ngini-ngatawa meaning. Kiyi yimi ngini, “Karri ngiya nguwuntiyarra arikutumunuwi ngini-ngatawa ngawa-rringani pupuni ngirramini api awarra nginingaji karri awarra alawura yuwunyawu awarra pupuni kurukura kangi yakuluwuni.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kiyi ngawa-yuwuni yimi ngini, “Awarra garden kapi awarra alawura yuwunyawu kurukura awungaji api karri waya japinamini karri tayikuwapi tiwi purru-wujingi-majirripani api yati tini yuwuriyi kapi awarra alawura ngini-ngatawa garden. Ngarra awarra tini jirti yimuwu awarra alawura api jirti kurukura yiniri-marruriyi kapi awarra garden api yuwunyawu awarra jirti kurukura awungarruwu mimpa-jirri kapi awarra pupuni kurukura. Awarra jirti kurukura api karri wiyi arikulurumi (grow) api jiringa wupunga awinyirra. ");
INSERT INTO tiw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","Kiyi awarra pupuni kurukura ngini ngarra wheat yikulurumi (grew) api kiyi waya yinkitayi kiyana yima awarra wheat. Nyirratuwu awinyirra jiringa wupunga awanuwanga jiyikulurumi. Kiyi awuta tiwi kapi waki pirimi ngini (for) awarra alawura api karri wuta pirripakuluwunyi awarra wheat amintiya awinyirra jiringa wupunga yinkitay-ajirri tayinti pirimi api punuwuriyi kapi awarra alawura api pirimi ngini, ‘Aya,’ pirimi, ‘Kama anaki angi jiringa wupunga tayinti ampirimi kangi awarra wheat pili nginja juwunyawu pupuni kurukura kanginjila garden?’ ");
INSERT INTO tiw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Api yimi ngarratuwu, ‘Arramukuta awarra tini ngini ngarra jirti arimuwu ngiya yuwunyawu jirti kurukura kapi ngini-ngilawa garden.’ Ngarra awarra yipangiraga awarra alawura kapi awuta tiwi kapi waki pirimi ngini (for) ngarra. Api wuta pirimi kangatawa, ‘Arrami nginja nimpitimarti ngawa ngini ngamata-ngoyi (pull out) awinyirra jiringa wupunga amintiya ngini ngamata-mwari awarra wheat?’ ");
INSERT INTO tiw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Api yimi ngarratuwu, ‘Karluwu, pili ngini (if) nuwa ngintija-ngoyi (did pull out) awinyirra jiringa wupunga api wiyi arrami awarra pupuni wheat awanuwanga papi yinija-mi (would come out). ");
INSERT INTO tiw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Waya awungani wutiyati awarra wheat amintiya awinyirra jiringa wupunga. Waya juwa karri waya kiyana awarra wheat api ngiya wiyi awungarri nguwuntiyarra nuwa ngini pakinya nginti-matanga (should get) awinyirra jiringa wupunga kiyi ngini jilikari nginti-mata-kirimi awinyirra wupunga. Amintiya ngiya wiyi nguwutiyarra nuwa ngini pimata-nyawu awinyirra jiringa wupunga kangi yikwani. Api awarra ngini pupuni wheat nuwa nginti-matanga kiyi nginti-mata-mukuri awarra wheat kapi awinyirra kurrampali kapi ngapalami yinkiti,’ yimi awarra alawura kapi awuta tiwi kapi waki pirimi ngini (for) ngarra.” Ngarra awarra ngawa-yuwuni yuwuntiyarra awarra ngirramini (story) kapi awuta tayikuwapi arikutumunuwi. Ngarra karluwu yuwuntiyarra awuta tiwi ngini-ngatawa meaning awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kiyi awarra ngawa-yuwuni yipumwari awuta tayikuwapi arikutumunuwi kiyi yipawuriji yilaruwu kapi awinyirra kurrampali kapi ngarra japuja yimi wutiyati ngarra-mamanta. Kiyi awuta ngarra-mamanta punuwuriyi kapi ngawa-yuwuni kiyi nanginta pirimi ngarra, “Awarra ngirramini (story) ngini awinyirra jiringa wupunga ngini nginja juwutiyarra awuta tayikuwapi tiwi api kamini awarra meaning?” Wuta awarra nanginta pirimi ngawa-yuwuni awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Api yimi ngawa-yuwuni kangi wutawa, “Awarra alawura ngini yuwunyawu awarra pupuni kurukura kapi ngarra garden api ngarra awarra alawura nginingaji ngiya. Nuwa-yuwuni ngiya nuwa tayikuwapi tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Amintiya awarra yakuluwuni ngini awarra alawura yikurungumi (dug) api awarra yakuluwuni nginingaji tayikuwa-ni murrakupuni (the whole world). Amintiya awarra pupuni kurukura api ngarra awarra nginingaji awuta tiwi kapi wupapunya ngawa-rringani angatawa jarrumoka. Api nyirratuwu angi jiringa wupunga nginingaji awuta tiwi kapi wupapunya maputiti angatawa jarrumoka. ");
INSERT INTO tiw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Amintiya awarra tini ngini ngarra yuwunyawu awarra jirti kurukura kapi awarra garden api ngarra awarra nginingaji maputiti. Amintiya awuta tiwi kapi purrupungoyi (pulled out) awarra wheat karri waya kiyana api awuta tiwi nginingaji angeluwi. Amintiya karri awarra wheat kiyana arimi api awarra nginingaji karri nginingaji ngatawa murrakupuni wiyi apapaya (the world will finish).” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","Kiyi ngarra yimi ngini, “Karri nginingaji ngatawa murrakupuni wiyi apapaya api ngiya wiyi nimarra ngirimi kapi awuta kapi-ngilawa angeluwi, ‘Awi, nyirranga (get) awuta tiwi kapi jirti wurikirimi (do wrong) amintiya awuta tiwi kapi wuntiyarra wuta-mamanta ngini jirti wurikirimi api nyirra-mukuri awuta jajiruwi tiwi maringarra (one side) kiyi kapi wuta papurajuwi awanuwanga maringarra (other side).’ Ngiya wiyi awarra ngipajiyarra awuta angeluwi,” yimi ngawa-yuwuni. Kiyi yimi ngini, “Awuta arikutumunuwi kapi wuta jajiruwi api wuta awuta nginingaji awinyirra jiringa wupunga angi awuta tiwi purruwunyawu kapi yikwani pili awuta angeluwi wiyi wunga awuta jajiruwi tiwi api wunyawu awuta kapi awarra yikwani, awarra yikwani ngini ngarra ngawa-rringani wiyi arikirimi ngini (to) wiyi awungaji awunyawu awarra maputiti. Awungarruwu kapi awarra yikwani awuta jajiruwi wiyi pirlikiti wurimi amintiya wurimi ngini, ‘Ngawa awungana ngamatama pili ngawa jirti ngirramini (trouble) ngawuni awungarra naki kapi yikwani,’ wurimi wiyi awuta jajiruwi tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kiyi awuta tiwi kapi wuta papurajuwi api ngarra ngawa-rringani wiyi apamangi awuta kapi ngarra japuja amintiya wiyi alawura arimi kapi wuta. Wuta wiyi ngirri-ngirri wurimi nginingaji warnarringa awuta kapi papurajuwi.” Ngarra awarra yipangiraga ngawa-rringani. Kiyi yimi ngini, “Nuwa kapi waya ngintiri-pitingaya (heard) awarra ngirramini api nuwa kuwa nyirrami awarra.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kiyi karri ngawa-yuwuni Jesus ngarra-mamanta pirripapaya ngini pirripalami awarra yinkiti kangi awinyirra tunga api ngarra ngawa-yuwuni yimi kangi awuta, “Awi, mamanta,” yimi. “Nyirra-lamiya kangi kapala api nyirru-wariyi maringarruwu. Nuwa aringampi ngiyatuwu yintayi pili ngiya pakinya nguwuntiyarra kapinaki arikutumunuwi ngini pimatu-wariyi tangarima,” yimi ngawa-yuwuni. Kiyi ngarra-mamanta pirripalamiya kangi kapala kiyi purruwuriyi aringampi. Ngarratuwu ngawa-yuwuni yuwanjipa yintuwu kapi awarra murrakupuni kiyi yipangirri (sent) awuta tayikuwapi arikutumunuwi kapi ngini-wutawa japuja. ");
INSERT INTO tiw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Karri awuta arikutumunuwi purruwuriyi api ngarra ngawa-yuwuni yipapurti kapi jupunyini (hill) ngarra wangata api awungarruwu pray yimi kapi ngarra-rringani ngini kuriyuwu. Karri yartijanga ngarra nanuwanga wangata yimuwu kuriyuwu kapi jupunyini. ");
INSERT INTO tiw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Api ngarra-mamanta nanuwanga purruwuja kapi kapala api waya kipirla purruwuja. Wuta mamana purruwuja pili wunijakama amintiya mirripakama. ");
INSERT INTO tiw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngarra ngawa-yuwuni yimuwu kiyija awungarruwu kapi jupunyini kiyi yipumwari awarra jupunyini kiyi yipapirraya kapi awarra lake api awungarri nanuwanga (still) yartijanga. Kiyi ngarra yipangulimayi kuriyuwu kangi awarra kukuni nginingaji ngawa ngapangulimayi kapi yakuluwuni kiyi yipapunya ngarra-mamanta kapi wuta tapitapi purru-wujingi-mani kapi awinyirra kapala. ");
INSERT INTO tiw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Karri ngawa-yuwuni ngarra-mamanta pirripakuluwunyi ngarra api wuta pirimakirri pili wuta amparrimani pirrarimi ngini ngarra awarra wurrungorra api jingawu pirimakirrimi, “Oyi!” ");
INSERT INTO tiw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Api karri wuta jingawu pirimi api awungarri ngarra ngawa-yuwuni yimi kangi wutawa, “Awi, ngajiti ngimpaja-wanga pili ngiya waya awarra nginaki,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kiyi awarra Peter yimi kangi ngawa-yuwuni, “Aya, ngini nginja awarra warntirrana ngawa-yuwuni nginja api tajiyarra ngiya ngini ngimata-ngulimayi kanginjila kuriyuwu kapi kukuni,” yimi Peter. ");
INSERT INTO tiw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Api, “Tuwaripa,” yimi ngawa-yuwuni kangi awarra Peter. Kiyi Peter kuwa yimi kangatawa kiyi kutupi yimi kapi kapala kiyi yipangulimayi kuriyuwu kapi awarra kukuni. Kiyi yuwuriyi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Api awarra Peter karri ngarra yuwuja kapi ngawa-yuwuni api ngarra awungarri yipakuluwunyi mirripakama api ngarra yimakirri kiyi yipungarti kiyija kangi kukuni. Kiyi ngarra jingawu yimi kapi ngawa-yuwuni, “Yuwuni, tawani ngiya,” yimi. ");
INSERT INTO tiw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Api yartipili ngawa-yuwuni yuwunga awarra Peter ngini-ngatawa yikara kiyi yipamanipayi (lifted up) ngarra api yimi kangatawa, “Nginja waya juwa kiyija kuwa jiyimi kangilawa. Pilikama nginja karluwu warntirrana kuwa jiyimi ngini ngiya ngimata-wani (can help) nginja ngini jimata-ngulimayi kuriyuwu kangi kukuni,” yimi ngawa-yuwuni kangi awarra Peter. ");
INSERT INTO tiw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kiyi ngawa-yuwuni amintiya awarra Peter karri pirripalamiya kangi kapala api awungarri awinyirra wunijaka juwunjarli. ");
INSERT INTO tiw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kiyi ngawa-yuwuni ngarra-mamanta kapi pirripalamiya kapi awinyirra kapala api wuta puru-kuruwarni (thanked) ngawa-yuwuni api pirimi ngini, “Awarra warntirrana ngini nginja ngawa-rringani ngarra-mirani,” pirimi kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kiyi yingampa Pharisees amintiya yingampa scribes purrupumwari Jerusalem kiyi purruwuriyi kapi ngawa-yuwuni. Kiyi awuta scribes amintiya awuta Pharisees api wuta awuta nanginta pirimi ngawa-yuwuni Jesus, ");
INSERT INTO tiw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pilikama nginja-mamanta karluwu kuwa wurimi awarra ngirramini (law) ngini ngawa mwarliki ngamatami (should wash) ngini-ngawula yikara karri ngawa waya yinkitayi ngawapa yinkiti pili wuta papaluwi puturupura (left for us) awarra ngirramini (law) ngini ngawa awungani ngamatami (should do that).” Awuta Pharisees amintiya scribes awarra nanginta pirimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Api yimi ngawa-yuwuni, “Marri nuwa! Nuwa waya juwa kuwa ngimpirimi ngawa-ampi ngini-wutawa ngirramini api nuwa karluwu warntirrana kuwa ngimpirimi ngawa-rringani, ");
INSERT INTO tiw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","awarra ngirramini ngini ngarra ngawa-rringani ngini kuriyuwu yipangiraga awarra ngirramini ngini, ‘Nuwa kuwa nyirrami kangi nuwa-rringanuwi amintiya nuwa-naruwi amintiya nyirra-mangi awuta. Api awuta tiwi kapi jirti wupangiraga kapi wuta-rringanuwi amintiya wuta-naruwi api pajuwani nyirra-kirimi awuta tiwi.’ Ngarra awarra ngirramini ngawa-rringani ngini kuriyuwu parlingarri yipangiraga api nuwa karluwu kuwa ngimpirimi awarra ngirramini,” yimi ngawa-yuwuni kapi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Kiyi yimi ngawa-yuwuni kangi wutawa, “Awarra warntirrana ngini nuwa karluwu kuwa ngimpirimi awarra ngirramini pilikama nuwa nimarra ngimpirimi kapi awuta arikutumunuwi ngini waya rayiti (alright) ngini wuta wuntiyarra wuta-rringanuwi amintiya wuta-naruwi, ‘Ngawa waya karri-kamini yinkiti amintiya kunawuni pili ngawa waya nginti-pakirayi ngawa-rringani ngini kuriyuwu ngini-ngawula yinkiti amintiya kunawuni.’ Pilikama nuwa Pharisees amintiya nuwa scribes awarra nimarra ngimpirimi kapi awuta arikutumunuwi pili nuwa waya ngimpiri-majawu ngini ngawa ngamata-kirayi (should give) yinkiti amintiya kunawuni kapi ngawa-rringanuwi amintiya ngawa-naruwi. Nuwa awuta Pharisees amintiya nuwa scribes ngumpu-wunu-waluwa (teach) awuta arikutumunuwi awarra jirti ngirramini (law) ngini awuta ngawa-ampi puturupura api nuwa waya nguntu-pumwari (have left) awarra pupuni ngirramini ngini-ngatawa ngawa-rringani ngini kuriyuwu,” yimi ngawa-yuwuni kapi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","9","Kiyi ngawa-yuwuni yipangiraga nyoni nginaki ngirramini kapi awuta Pharisees amintiya scribes, “Nuwa ngimpiri-mamuliya nuwulamiya papurajuwi api nuwa karluwu. Yita ngarra ngawa-rringani parlingarri yuwutiyarra awarra prophet Isaiah awarra naki ngirramini ngini (about) nuwa api yimi ngawa-rringani ngini, ‘Kapinaki arikutumunuwi kunyani wurimamula (call) ngiya pupuni api wuta karluwu wuni ngiya kangi wuta ruwuti. Wuta karluwu warntirrana wuru-kuruwarni (thank) ngiya amintiya awarra ngirramini (law) ngini wuta wunu-waluwa (teach) awuta arikutumunuwi api awuta wuta-ampi pirikirimi awarra ngirramini. Wuta karluwu wunu-waluwa arikutumunuwi ngini-ngilawa ngirramini,’ yimi ngawa-rringani. Ngarra nimarra yimi awarra ngirramini ngini (about) nuwa,” yimi ngawa-yuwuni kapi awuta Pharisees amintiya awuta scribes. Kiyi yimi ngini, “Awarra ngirramini ngini ngarra ngawa-rringani yipangiraga ngini (about) nuwa api awarra warntirrana,” yimi ngawa-yuwuni kapi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kiyi ngawa-yuwuni jingawu yimi kapi awuta tiwi kapi mimpa pirimi yinkitayi kangatawa api yimi ngini, “Awi mamanta. Awarra naki ngirramini ngini ngiya ngipangiraga api nyirra-majawu (understand) awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Karri ngawa ngapalami yinkiti kangawula yirruputara api kiyi ngawapa awarra yinkiti api awarra yinkiti karluwu arikirimi ngawa ngini jajiruwi tiwi ngarima. Waya juwa ngini nuwa jirti ngirramini (bad thoughts) ngimpalami yilaruwu kangi nuwa punyipunyi api kiyi papi ngimpiniri-mamiyi (bring out) awarra jirti ngirramini kangi (through) nuwula yirruputara api awarra jirti ngirramini arikirimi nuwa jajiruwi tiwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tayikuwapi arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kiyi ngawa-yuwuni ngarra-mamanta punuwuriyi kangatawa api pirimi ngini, “Arrami nginja waya nimpirimajawu ngini awuta Pharisees karluwu puranji purumuwu awarra ngirramini ngini nginja jipangiraga kangi wutawa api angi-wutawa yiminga jurrumumi jiyimi (became angry).” Ngawa-yuwuni ngarra-mamanta awarra pirripangiraga kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Api yimi kangi wutawa, “Ngajiti kuwa ngimpajami awarra ngirramini ngini awuta Pharisees pirripangiraga. Kayi, awuta tiwi kapi karluwu wupapunya ngawa-rringani angatawa jarrumoka api wuta awuta nginingaji yinkilatuwi. Amintiya awuta Pharisees api wuta wiyarri nginingaji yinkilatuwi pili wuta arnuka-nara wupapunya awinyirra jarrumoka angatawa ngawa-rringani api wuta karluwu pimata-wani (can't help) awuta yingampa tiwi ngini warntirrana pimata-punya awinyirra jarrumoka. Awarra nginingaji karri yingampa tiwi kapi yinkilatuwi wunu-wani yingampa (others) kapi yinkilatuwi ngini pimata-ngulimayi api wutiyati wiyi wupakupuraji kangi yangamini.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. Kiyi yimi ngini, “Awarra ngirramini ngini wuta Pharisees wuntiyarra awuta tiwi api karluwu ngawa-rringani ngini-ngatawa ngirramini awarra api ngiya wiyi nguwuntiyarra awuta tiwi ngini, ‘Nuwa ngajiti kuwa ngimpajami awuta Pharisees ngini-wutawa ngirramini,’ ngirimi.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kiyi ngarra Peter yipangiraga kapi ngawa-yuwuni, “Awarra ngirramini ngini nginja jipangiraga karri pakinya api kamini awarra meaning arimi,” yimi Peter. ");
INSERT INTO tiw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Api yimi ngawa-yuwuni kapi awarra Peter amintiya awuta yingampa ngarra-mamanta, “Kama nuwa nanuwanga mayorluwi nuwa ngiya-mamanta. Nuwa nginingaji awuta yingampa tiwi kapi karluwu wurimajawu (don't understand) ngini-ngilawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kayi, awarra ngirramini ngini ngiya pakinya ngirripangiraga karri pakinya api ngini-ngatawa meaning ngini karri ngawa ngapalami yinkiti kangawula yirruputara api karri ngawapa awarra yinkiti api ngawa karluwu jajiruwi tiwi ngamatama pili awarra yinkiti. Awarra yinkiti ngini ngawa ngapalami kangawula yirruputara api wiyi apawuriji yilaruwu kangawula wiyika kiyi parlinginari (later) papi awunirimi (come out) kapi ngawa kurruwa. Awarra yinkiti ngini ngapalami kangawula yirruputara api karluwu arikirimi ngawa jajiruwi tiwi. Wayana?” yimi ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kiyi yimi kangi wutawa, “Waya juwa ngini nuwa jirti ngirramini (bad thoughts) ngimpalami yilaruwu kangi nuwa punyipunyi api kiyi papi ngimpiniri-mamiyi awarra jirti ngirramini (bad talk) kangi (through) nuwula yirruputara api awarra jirti ngirramini arikirimi nuwa jajiruwi tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yingarti awarra jirti ngirramini ngini nuwa yingampa ngimpalami yilaruwu kangi nuwula punyipunyi amintiya kangi nuwula ruwuti api kiyi nuwa wiyi jirti ngimpiri-kirimi (do wrong) nginingaji nuwa pajuwani ngimpiri-kirimi yingampa (other) tiwi amintiya awanuwanga wulinjini ngimpirimi kapi nyoni tini ngarra-purnayinga amintiya kapi nyonga tinga nyirra-purnayi. Amintiya nuwa awanuwanga mitaya ngimpirimi yinkiti amintiya kunawuni amintiya tongwayi ngimpirimi yingampa tiwi amintiya nuwa jajiruwi ngimpiri-mamula (call) yingampa (other) tiwi amintiya nuwa jirti ngimpiri-pungintayi (think wrong things). ");
INSERT INTO tiw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Api ngini nuwa awarra jirti ngimpiri-kirimi api nuwa wiyi jajiruwi tiwi ngimpirima (become). Api ngini ngawa karluwu mwarliki ngarimi ngini-ngawula yikara karri ngawa waya yinkitayi ngawapa yinkiti api awarra karluwu arikirimi ngawa jajiruwi tiwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purruwuriyi kapi awarra murrakupuni ngini ngarra yinkitayi kapi Caesarea-Philippi. Awungarruwu ngawa-yuwuni nimarra yimi kapi ngarra-mamanta, “Nuwa waya ngimpiri-majawu ngini ngiya awarra naki nuwa-yuwuni nuwa tayikuwapi (all) arikutumunuwi api wuta yingampa tiwi kamini wurimamula (call) ngiya?” yimi ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Api wuta pirimi, “Wuta yingampa wurimi ngini arrami nginja John the Baptist. Wutatuwu yingampa wurimi ngini arrami nginja awarra prophet Elijah, amintiya arrami awarra prophet Jeremiah amintiya wurimi ngini arrami nginja nyoni prophet ngini parlingarri yimuwu api wurimi ngini nginja waya awarra jini-pakupawurli (came back) api tuwanga yimpangini jiyima,” pirimi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Api yimi ngawa-yuwuni, “Marri nuwa? Nuwa kuwani ngimpiri-mamula (call) ngiya?” ");
INSERT INTO tiw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Api awarra Simon Peter yimi ngini, “Nginja awarra nginaki Christ ngini ngawa-rringani parlingarri yuwuntiyarra papaluwi ngini ngarra wiyi yini-mata-ngirri (would send) nginja kapi ngawa arikutumunuwi. Nginja awarra ngarra-mirani ngawa-rringani ngini kuriyuwu. Ngarra awarra ngawa-rringani wiyi yiloti arimuwu api ngarra awarra ngini yini-pangirri (sent) nginja kapi ngawa.” Ngarra awarra yipangiraga Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Api yimi ngawa-yuwuni kapi Simon Peter, “Aya,” yimi. “Awarra ngirramini ngini nginja jipangiraga ngini (about) ngiya api ngarra awarra warntirrana. Karri-kuwapi purru-wutiyarra nginja ngini ngiya awarra nginaki Christ. Waya juwa ngarra ngawa-rringani. Api ngawa-rringani arimi ngini nginja pupuni.” Ngarra awarra yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kiyi ngawa-yuwuni nyoni ngirramini yipangiraga kapi Simon, “Nginja yintanga Peter api awarra ngini-nginjila yintanga meaning arimi arikulanga waranga api ngiya wiyi ngirikirimi tayikuwapi arikutumunuwi ngini pimatu-wariyi kapi awinyirra waranga api wuta wiyi awuta arikutumunuwi wupapunya angilawa jarrumoka. Api awarra maputiti wiyi karluwu yimata-kirimi awuta arikutumunuwi ngini (to) pimata-mwari angilawa jarrumoka.” Ngarra awarra yimi ngawa-yuwuni kapi awarra Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kiyi ngawa-yuwuni yipangiraga nyoni ngirramini kapi awarra Simon Peter, “Ngiya wiyi ngirikirimi nginja ngini alawura nimpirimi kapi awuta tiwi kapi wupapunya angilawa jarrumoka api awuta tiwi kapi nginja nimpitimarti awuta ngini wiyi pimatu-wariyi kapi ngawa-rringani ngini-ngatawa japuja pili wuta kuwa wurimi ngini-ngilawa ngirramini api ngarra ngawa-rringani ngini kuriyuwu wiyi arimi kangi wutawa, ‘Nyirru-waripa kapi ngiya japuja api nyirra-muwu awungarra.’ Api wutatuwu kapi nginja karluwu nimpitimarti ngini pimatu-wariyi kapi ngawa-rringani japuja pili wuta karluwu kuwa wurimi ngini-ngilawa ngirramini api ngarra ngawa-rringani wiyi arimi kangi wutawa, ‘Nuwa karluwu japuja kangilawa.’ Ngarra wiyi awarra arimi ngawa-rringani kapi awuta tiwi kapi karluwu kuwa wurimi ngini-ngilawa ngirramini.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra Peter. ");
INSERT INTO tiw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Nuwa waya ngimpiri-majawu ngini ngiya awarra Christ ngini ngarra ngawa-rringani parlingarri yuwuntiyarra papaluwi ngini ngarra wiyi yini-mata-ngirri (would send) ngiya kapi nuwa arikutumunuwi. Api ngajiti ngimpaja-jiyarra yingampa tiwi ngini ngiya awarra Christ.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kiyi ngawa-yuwuni Jesus yuwuntiyarra awuta ngarra-mamanta, “Ngiya wiyi ngumpuriyi kapi Jerusalem pili ngiya-rringani awutimarti ngiya ngini ngimatu-wariyi awungarruwu. Api awungaji awuta priests kapi wuta alawuruwi amintiya awuta yingampa alawuruwi amintiya awuta scribes wiyi yingarti ngirramini (trouble) wupakirayi ngiya api kapi-wutawa majatawi wiyi wuripirni ngiya. Api karri yirrajirrima wumunga (on third day) api ngarra ngawa-rringani wiyi arikirimi ngiya ngini ngupukularri api tuwanga yimpangini ngirima.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. Ngarra awungarri mampara karri yuwuntiyarra ngarra-mamanta nayi awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kiyi ngarratuwu Peter yimarruriyi aringampi ngawa-yuwuni ngini nimarra pimata-majirri wuta wangata. Ngarra karluwu awarra Peter pupuni yimuwu awarra ngirramini ngini ngarra ngawa-yuwuni nimarra yimi ngini wuta wiyi wuripirni awarra ngawa-yuwuni api yimi awarra Peter kangi ngawa-yuwuni, “Ngajiti awungani nimpajami pili ngarra ngawa-rringani wiyi apamangi nginja api wuta wiyi karluwu pajuwani pimata-kirimi nginja,” yimi Simon Peter kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Api yimi ngawa-yuwuni kangatawa, “Pirri pili nginja nginingaji maputiti. Ngiya-rringani awutimarti ngiya ngini pajuwani ngimatami ngini awarra jirti (for the wrong) ngini nuwa arikutumunuwi ngintiri-kirim-ani (you've done) api nginja karluwu nimpitimarti ngiya ngini kuwa ngimatami awarra ngiya-rringani. Yita nginja karluwu nimpiri-pungintayi (think) nginingaji ngarra ngiya-rringani aripungintayi. Waya juwa nimpiri-pungintayi nginingaji wuta arikutumunuwi wuru-pungintayi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kiyi yimi ngawa-yuwuni kapi ngarra-mamanta, “Awi,” yimi. “Nuwa tiwi kapi ngimpitimarti ngini nginti-mata-punya angilawa jarrumoka api nuwa awuta karluwu nuwulamiya nginti-mata-pungintayi (shouldn't think about yourselves). Yingampa tiwi wiyi arrami pokayini wurimi kangi nuwula. Arrami wiyi pajuwani wurikirimi nuwa nginingaji wuta wiyi wuripirni ngiya. Arrami wiyi wupamukuri nuwa kangi arikitirropurtayi (cross). ");
INSERT INTO tiw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Api ngini awuta tiwi wutimarti ngini pajuwani pimata-kirimi nuwa pili nuwa kuwa ngimpirimi ngiya api ngajiti kuwa ngimpajami awuta tiwi. Waya juwa nyirra-punya-la (keep following) angilawa jarrumoka api kiyi nuwa wiyi japuja kuriyuwu kapi ngawa-rringani. Api ngini nuwa ngumpumwari angilawa jarrumoka karri awuta tiwi wutimarti ngini pajuwani pimata-kirimi nuwa amintiya karri pokayini wurimi kangi nuwula api nuwa wiyi karluwu japuja kuriyuwu kapi ngawa-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kiyi karri ngawa-yuwuni wangata yimuwu api ngarra-mamanta punuwuriyi kangatawa kiyi pirimi ngini, “Pilikama ngawa karluwu papi ngarrija-mamiyi (couldn't bring out) awarra maputiti ngini yipalamiya kapi awarra kirijini ngarra purnikapa?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Api ngawa-yuwuni yimi kangi wutawa, “Nuwa karluwu warntirrana kuwa ngintirimi ngini ngawa-rringani yimata-kirayi (would give) nuwa ngini-ngatawa power ngini nuwa papi ngintini-mata-mamiyi awarra maputiti api nuwa karluwu ngintija-kirimi (couldn't do) awarra mirrikili (miracle). Ngajiti worry ngini nuwa waya juwa kiyija kuwa ngimpirimi ngini ngawa-rringani wiyi amant-akirayi nuwa ngini-ngatawa power pili nuwa wiyi ngintija-kirimi (can do) mirrikili. Arrami nuwa wiyi ngimpitimarti yati jupunyini (hill) ngini yimatu-wariyi kapi nyoni murrakupuni api ngini nuwa nimarra ngimpirimi kapi awarra jupunyini, ‘Tuwariyi nankitawu!’ api awarra jupunyini wiyi awuriyi awungarruwu. Ngawa-rringani wiyi apakirayi nuwa ngini-ngatawa power ngini arikulani mirrikili nginti-mata-kirimi.” Awarra yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kiyi ngawa-yuwuni nimarra yimi kapi ngarra-mamanta, “Yingampa nuwa-mamanta kapi nuwiyati ngimpapunya angilawa jarrumoka api wuta awuta jirti ngirramini (trouble) wiyi wupakirayi nuwa. Api ngini yati kapi nuwa api nginja-mantani apakirayi nginja jirti ngirramini, nginingaji ngarra jirti tini arimamula (calls) nginja api tuwariyi kapi awarra nginja-mantani api tajiyarra awarra, ‘Nginja jirti ngirramini jipakirayi ngiya.’ Awarra tajiyarra nginja-mantani nuwa wangatamiya. Ngini awarra nginja-mantani putuputuwu apakiray-amiya awarra jirti ngirramini ngini ngarra yipakirayi nginja api nuwa wiyi puranji ngumpuru-muwajirri (be friends). ");
INSERT INTO tiw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngini awarra nginja-mantani karluwu kuwa arimi awarra ngini nginja jipangiraga kangatawa api nginja wiyi tuwariyi kapi yuwurrara nginja-mamanta kapi nuwiyati ngimpapunya angilawa jarrumoka api nimarra tami kangi wutawa, ‘Kali! Ngawurliyi pili nuwa nyirra-pitingaya (listen to) naki awarra ngirramini (trouble) ngini ngiya amintiya ngiya-mantani nimarra ngarimi.’ Api awuta yuwurrara nginja-mamanta wiyi wutiyarra awarra nginja-mantani ngini ngarra jirti yikirimi kanginjila. ");
INSERT INTO tiw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ngini awarra nginja-mantani ngini jirti ngirramini yipakirayi nginja wiyi karluwu kuwa yimatami awuta yuwurrara nginja-mamanta api tuwariyi kapi awuta tayikuwapi nginja-mamanta kapi nuwiyati yimpaja ngumpuru-kuruwarni (thank) ngawa-rringani kapi jurra api tajiyarra awuta nginja-mamanta ngini (about) awarra ngirramini (trouble). Ngini awarra nginja-mantani ngini ngarra jirti ngirramini yipakirayi nginja wiyi karluwu kuwa yimatami awuta nginja-mamanta api nginja amintiya awuta nginja-mamanta nimarra nyirrami kangatawa, ‘Nginja karluwu tuwanga jimata-wuriji (shouldn't go into) angawula jurra.’ Nginja amintiya awuta nginja-mamanta awarra nimarra nyirrami kapi awarra nginja-mantani ngini jirti ngirramini yipakirayi nginja pili ngarra karluwu putuputuwu yipakiray-amiya awarra jirti ngirramini. Ngarra awarra nginja-mantani ngini jirti ngirramini yipakirayi nginja api ngarra awarra nginingaji awuta tiwi kapi karluwu kuwa wurimi ngawa-rringani ngini-ngatawa ngirramini.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kiyi ngawa-yuwuni nyoni ngirramini yipangiraga kapi awuta ngarra-mamanta ngini, “Naki awarra ngirramini warntirrana ngini awuta tiwi kapi nuwa ngimpitimarti ngini wuta wiyi pimatu-wariyi kapi ngawa-rringani ngini-ngatawa japuja pili wuta kuwa wurimi ngini-ngilawa ngirramini api ngarra ngawa-rringani wiyi arimi kangi wutawa, ‘Nyirru-waripa kapi ngiya japuja api nyirra-muwu awungarra.’ Api wutatuwu kapi nuwa karluwu ngimpitimarti ngini pimatu-wariyi kapi ngawa-rringani japuja pili wuta karluwu kuwa wurimi ngini-ngilawa ngirramini api ngarra ngawa-rringani wiyi arimi kangi wutawa, ‘Nuwa karluwu japuja kangilawa.’ Ngarra wiyi awarra arimi ngawa-rringani kapi awuta tiwi kapi karluwu kuwa wurimi ngini-ngatawa ngirramini.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Kiyi ngawa-yuwuni nyoni nginaki ngirramini yipangiraga kapi ngarra-mamanta, “Awi,” yimi. “Ngini nuwa yuwurrara nimarra ngimpiri-majirri ngini (about) kuta kamini awarra ngini nuwa ngimpitimarti ngawa-rringani ngini yimata-kirayi nuwa api kiyi ngini nuwa nanginta ngimpirimi awarra ngawa-rringani kuta kamini awarra ngini nuwa ngimpitimarti (need) api ngarra wiyi ngawa-rringani ari-pitingaya (listen to) nuwa api wiyi apakirayi nuwa awarra kuta kamini ngini nuwa ngimpitimarti amintiya awanuwanga wiyi amanu-wani (help) nuwa karri nuwa awuta yuwurrara tiwi nanginta ngimpirimi awarra ngawa-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni. Kiyi yimi ngini, “Ngarra wiyi awarra ngawa-rringani ari-pitingaya (hear) nuwa pili karri nuwa mimpa ngimpirimi pili-ngini ngimpiri-pungintayi (think about) ngiya api ngiya wiyi awungaji kangi nuwula nuwa yuwurrara tiwi arramukuta nuwa yuwurrajirrima.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kiyi Peter yuwuriyi kapi ngawa-yuwuni Jesus kiyi yimi ngini, “Arrami ngiya-mantani wiyi jirti arikirimi (do wrong) kangi ngiya, nginingaji ngarra wiyi mitaya arimi ngini-ngilawa kunawuni, arramukuta ngarra wiyi kunyani arimi ngini (about) ngiya kangi yingampa arikutumunuwi, arramukuta ngarra wiyi arimarrimili ngiya-purnayinga. Ngini ngarra awarra jirti arikirimi (does that wrong) kangiya api ngiya ngirimajawu ngini ngiya putuputuwu api ngiya ngirimajawu ngini ngiya putuputuwu ngimata-kirayi (should forgive) ngarra. Api ngini ngarra tuwanga jirti arikirimi kangiya api ngiya tuwanga putuputuwu ngimata-kirayi ngarra. Api ngini ngarra awungani-la jirti arikirimi kangi ngiya api ngiya awungan-ari (how many times) ngiya putuputuwu ngimata-kirayi ngarra? Arramukuta walimani (7) times ngiya putuputuwu ngimata-kirayi ngarra. Marri?” yimi awarra Peter kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Api ngawa-yuwuni yimi kangi ngarra, “Karluwu. Yita yimpaja putuputuwu tayakirayi nginja-mantani karri ngarra jirti arikirimi kangi nginja. Ngajiti waya juwa walimani times putuputuwu nimpaja-kirayi ngarra. Putuputuwu tayakirayi ngarra yiloti,” yimi ngawa-yuwuni kangi Peter. ");
INSERT INTO tiw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kiyi ngawa-yuwuni yimi kangi awarra Peter amintiya awuta yingampa ngarra-mamanta, “Ngawa-rringani ngini kuriyuwu awutimarti ngawa ngini putuputuwu ngamata-kiray-ajirri (forgive each other) api ngini ngawa karluwu putuputuwu ngapakiray-ajirri api ngarra wiyi awanuwanga karluwu putuputuwu yimata-kirayi (forgive) ngawa,” yimi ngawa-yuwuni. Kiyi ngawa-yuwuni naki ngirramini (story) yuwuntiyarra awuta ngarra-mamanta, yimi ngini, “Naki ngirramini ngini ngiya nimarra ngiyimami kangi nuwa ngini (about) yati alawura. Kayi, awuta tiwi kapi wuta waki pirimi ngini (for) awarra alawura api yingampini (sometimes) wuta nanginta pirimani kunawuni awarra alawura api ngarra yipakiray-ani (lent) awuta tiwi awarra kunawuni ngini wuta nanginta pirimani ngarra.” Kiyi natinga wumunga (one day) awarra alawura jingawu yimi kapi awuta tiwi kapi waki pirimi ngini (for) ngarra ngini pini-matu-wariyi kangatawa. Api karri wuta punuwuriyi kangatawa api ngarra yimi kangi wuta ngini, “Ngiya nguwutimarti awarra kunawuni ngini ngiya ngirripakirayi nuwa,” yimi awarra alawura. ");
INSERT INTO tiw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","25","Kiyi awuta tiwi kapi waki pirimi ngini (for) awarra alawura api wuta piniri-marruriyi kangatawa yati tini ngini awarra alawura yipakirayi ngarra 10,000 dollars api awarra tini yimi kangi awarra alawura, “Ngiya waya karri-kamini kunawuni api ngiya karluwu ngimata-kiray-awurli (can't give back) awarra kunawuni kanginjila,” yimi awarra tini. Kiyi awarra alawura yipangiraga kapi awuta yingampa wawurruwi kapi waki pirimi ngini ngarra api yimi ngini, “Nyirranga naki tini amintiya ngarra-purnayinga, amintiya ngarra-mamirampi, kiyi nyirra-marruriyi awuta kapi nyoni alawura api sellim nyirrami awuta kangatawa pili-ngini wuta waki pimatami ngini ngarra. Nuwa awanuwanga sellim nyirrami arramu-kaminawuti ngini naki tini awuni. Api karri nuwa wiyi sellim ngimpirimi awuta arikutumunuwi amintiya ngini-wutawa arramu-kaminawuti api awarra yingarti kunawuni ngini nuwa wiyi ngimpanga api nyirra-marruripa awarra kunawuni kangiya pili ngiya yingarti kunawuni ngirripakirayi awarra tini.” Ngarra awarra alawura yimi awarra kangi awuta wawurruwi. ");
INSERT INTO tiw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kiyi awarra tini yipamukuri ngini-ngatawa yirrara yimpula (knelt down) kapi yakuluwuni yinkitayi kapi awarra alawura, kiyi ngarra pirlikiti yimi amintiya yimi kangatawa, “Arnapa. Putuputuwu tayakirayi ngiya api ngiya wiyi ngipakiray-awurl (give back) nginja tayikuwa-ni (all) awarra kunawuni ngini nginja jipakirayi ngiya,” yimi kangi awarra alawura. ");
INSERT INTO tiw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Api kiyi awarra alawura putuputuwu yipakirayi awarra tini, api yimi kangatawa, “Waya ngajiti awungani. Tuwariyi kanginjila japuja,” yimi awarra alawura kapi awarra tini. Kiyi awarra tini yipumwari awarra alawura. ");
INSERT INTO tiw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kiyi karri awarra tini yuwuriyi turruwuni api ngarra yuwunyayi yati ngarra-mantani ngini wutiyati awarra tini waki pirimi ngini (for) awarra alawura. Api puniyarri (before that time) awarra tini yipakirayi ngarra-mantani kiyija kunawuni. Api karri ngarra yipakuluwunyi ngarra-mantani api yuwunga angatawa miraka, yimi ngini, “Ningani tayakiray-awurli (give back) ngiya awarra kunawuni ngini ngiya ngirripakirayi nginja,” yimi kangi ngarra-mantani. ");
INSERT INTO tiw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kiyi ngarra-mantani yipamukuri ngini-ngatawa yirrara yimpula (knelt) kapi yakuluwuni yinkitayi kapi awarra tini kiyi yimi ngini, “Mantani, arnapa. Wiyi pangarri ngiya ngipakirayi nginja awarra kiyija kunawuni ngini nginja jipakirayi ngiya,” yimi ngarra-mantani kangi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Api awarra tini ngarra arnuka kuwa yimi kangi ngarra-mantani amintiya ngarra karluwu putuputuwu yipakirayi awarra api ngarra yimarruriyi ngarra-mantani kapi awuta majatawi pili-ngini wuta pimata-mukuri ngarra yilaruwu kapi jail. Kiyi awarra tini yimi kapi ngarra-mantani, “Nginja wiyi papi nimpinirimi (come out) kapi awarra jail karri nginja nimpakirayi ngiya awarra kunawuni,” yimi awarra tini kapi ngarra-mantani. ");
INSERT INTO tiw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Awuta yingampa wawurruwi kapi waki pirimi ngini (for) awarra alawura, karri wuta pirripakuluwunyi awarra tini ngini yimarruriyi awarra ngarra-mantani kapi jail api jurrumumi jiyimi angi-wutawa yiminga (became angry) api putuputuwu pirripakirayi awarra tini ngarra-mantani. Kiyi wuta purruwuriyi purru-wutiyarra awarra alawura ngini awarra tini yimarruriyi ngarra-mantani kapi jail. ");
INSERT INTO tiw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","34","Karri awarra alawura yipitingaya (heard) awarra ngirramini ngini wuta pirripangiraga awuta kapi waki pirimi ngini ngarra api ngarra awanuwanga jurrumumi jiyimi angatawa yiminga (became angry) pili awarra tini yimarruriyi awarra ngarra-mantani kapi jail. Kiyi awarra alawura yipangirri (sent) awuta tiwi kapi awarra tini ngini wuta pini-mata-marruriyi ngarra kangatawa. Api karri awuta tiwi piniri-marruriyi awarra tini kangi awarra alawura api awarra alawura yimi kangatawa, ‘Nginja jirti tini. Ngiya putuputuwu ngirripakirayi (forgave you) nginja pili nginja nanginta jiyimi ngini putuputuwu ngimata-kirayi nginja api ngiya ngurru-wutiyarra nginja ngini nginja karluwu jimata-kiray-awurli (don't have to give back) ngiya awarra yingarti kunawuni ngini ngiya ngirripakirayi nginja. Nginjatuwu awanuwanga putuputuwu nyimarri-pakirayi (should have forgiven) nginja-mantani awarra kiyija kunawuni ngini nginja jipakirayi ngarra. Api ngiya jurrumumi jiyimi angilawa yiminga (became angry) pili nginja karluwu putuputuwu jipakirayi nginja-mantani. Api kiyi ngiya wiyi ngipangirri (send) nginja kapi jail,’ yimi awarra alawura kangi awarra tini. Kiyi awuta tiwi kapi waki pirimi ngini (for) awarra alawura api pirimarruriyi awarra tini kapi majatawi api purru-wuntiyarra awuta ngini, ‘Nyirra-mukuri naki awarra tini yilaruwu kapi jail. Awungarruwu nyirra-pirni ngarra. Waya juwa karri awarra naki tini wiyi apakiray-awurli (give back) awarra alawura awarra yingarti kunawuni api ngarra wiyi awungarri papi awunirimi kapi awarra jail,’ yimi awarra alawura kangi awuta majatawi.” Awarra ngirramini (story) ngawa-yuwuni yuwuntiyarra Peter amintiya awuta yingampa ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kiyi ngawa-yuwuni yipangiraga kapi awuta ngarra-mamanta, yimi ngini, “Ngiya-rringani ngini kuriyuwu wiyi awanuwanga karluwu putuputuwu apakirayi nuwa kapi karluwu putuputuwu ngimpakirayi yingampa arikutumunuwi,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kiyi karri pangarri ngawa-yuwuni Jesus amintiya ngarra-mamanta wuta pirripakupawurli kapi Jerusalem api purruwuriyi kapi awinyirra arikulanga jurra angi-wutawa Jews. Kiyi karri wuta papi pirimi awungarruwu kapi awinyirra jurra api wuta purruwuriyi kapi awarra yard, api ngawa-yuwuni yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Kiyi awuta priests kapi wuta alawuruwi amintiya awuta yingampa alawuruwi, wuta purruwuriyi kapi ngawa-yuwuni api nanginta pirimi ngatawa, “Aya, mantani, nginja japini jinu-wuriyi awungarra kapi anaki jurra api juwuriyi kapi awuta arikutumunuwi kapi wuta sellim purru-wujingi-mani animuluwi awungarra kapi naki yard api kiyi nginja juwuntiyarra awuta arikutumunuuwi ngini wuta karluwu sellim pimatami awuta animuluwi awungarra kiyi nginja juwuntiyarra awuta ngini pimatu-wariyi kapi nyoni murrakupuni (place). Kuwani yuwutiyarra nginja ngini “Pirri,” jimatami kangi awuta? Kuwani yini-pangirri (sent) nginja awungarra kangi ngawa arikutumunuwi?” pirimi awuta alawuruwi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kiyi ngawa-yuwuni yimi kangi wutawa, “Arnapa. Pakinya ngiya nanginta ngimatami nuwa naki ngirramini (question). Karri nuwa ngimparringa (answer) ngiya api awungarri ngiya wiyi nguwujiyarra nuwa ngini kuwani ngarra yini-pangirri (sent) ngiya awungarra,” yimi ngawa-yuwuni kangi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Api kiyi ngarra nanginta yimi awuta, “Awarra John the Baptist api nayi kuwani awarra ngini yuwutiyarra ngarra ngini ngarra baptise yimata-kirimi arikutumunuwi kapi makatinga? Arramukuta nuwa ngimpirimi ngini ngawa-rringani ngini kuriyuwu yuwutiyarra ngarra ngini awarra waki yimatami. Arramukuta nuwa ngimpirimi ngini nyoni tini awarra yuwutiyarra ngarra. Api nyirra-jiyarra ngiya ngini kuwani yuwutiyarra awarra John the Baptist ngini baptise yimata-kirimi awuta arikutumunuwi,” yimi ngawa-yuwuni kapi awuta alawuruwi. Kiyi awuta alawuruwi jukuta pirimajirri (whispered) ngini, “Awungana ngawa nimarra ngamatami kapi awarra naki Jesus ngini kuwani yuwutiyarra awarra John the Baptist ngini baptise yimata-kirimi awuta arikutumunuwi? Ngini ngawa ngarimi ngini ngarra ngawa-rringani ngini kuriyuwu yuwutiyarra awarra John the Baptist ngini awarra waki yimatami api awarra naki Jesus wiyi nanginta arimi ngawa, ‘Pilikama nuwa arnuka kuwa ngintirimi awarra ngirramini ngini awarra John yuwutiyarra nuwa?’ Api ngawa karluwu ngamatami kangatawa ngini ngarra ngawa-rringani yuwutiyarra awarra John the Baptist ngini baptise yimata-kirimi arikutumunuwi.” Awarra nimarra pirimajirri awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kiyi wuta nimarra pirimajirri ngini, “Ngini ngawa wiyi ngarimi kangi awarra naki Jesus ngini nyoni tini yuwutiyarra awarra John the Baptist ngini baptise yimata-kirimi arikutumunuwi kapi makatinga api kapinaki arikutumunuwi kapi wujingi-rriti (are standing) awungarra api wuta wiyi jirti ngirramini (trouble) wupakirayi ngawa pili wuta manya wurimi ngini ngarra ngawa-rringani yuwutiyarra awarra John the Baptist ngini ngarra yimata-jiyarra arikutumunuwi ngini-ngatawa ngirramini amintiya ngini baptise yimata-kirimi awuta. Api ngawa karluwu ngamatami kangi awarra naki Jesus ngini nyoni tini awarra yuwutiyarra awarra John the Baptist,” pirimajirri awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Api kiyi wuta pirimi kapi ngawa-yuwuni ngini, “Kuta kuwani yuwutiyarra awarra John the Baptist ngini ngarra baptise yimata-kirimi awuta arikutumunuwi,” pirimi awuta alawuruwi. Api ngawa-yuwuni yimi ngini, “Ngiyatuwu awanuwanga karluwu nguwutiyarra nuwa ngini kuwani yini-pangirri (sent) ngiya awungarra kapi nuwa arikutumunuwi amintiya ngini kuwani yuwutiyarra ngiya ngini ngimata-ngirri awuta arikutumunuwi kapi nyoni murrakupuni (place), awuta kapi wuta sellim purru-wujingi-mani awuta animuluwi awungarra kapi anaki jurra.” Awarra yimi ngawa-yuwuni kapi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kiyi ngawa-yuwuni Jesus yuwuntiyarra naki ngirramini (story) kapi awuta priests kapi wuta alawuruwi amintiya awuta yingampa alawuruwi, yimi ngini, “Yati tini yuwuni (had) yuwurrara ngarra-mamirampi kapi wuta wawurruwi. Natinga wumunga (one day) awarra tini yuwuriyi kapi ngarra-mirani ngini ngarra aringamini kiyi yimi kangatawa, ‘Aya, mirani, ningani nginja tuwariyi kapi ngini-ngilawa garden api awungarruwu waki tami,’ yimi awarra tini kapi ngarra-mirani ngini aringamini. ");
INSERT INTO tiw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Api ‘Karluwu,’ yimi awarra malakaninga. ‘Ngiya karluwu waki ngimatami awungaji,’ yimi awarra ngini aringamini kangi ngarra-rringani. Kiyi awinyirra-wanga wumunga ngarra yimi kangatamiya, ‘Ngiya ngimatu-wariyi (should go) kiyi waki ngimatami (should work) kapi ngarra ngiya-rringani garden.’ Api kiyi ngarra yuwuriyi kapi ngarra-rringani garden kiyi awungaji waki yimi. ");
INSERT INTO tiw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kiyi awarra tini yuwuriyi kapi ngarra-mirani ngini ngarra yintinila api yimi kangatawa, ‘Aya, mirani, ningani nginja tuwariyi kapi ngini-ngilawa garden api awungarruwu waki tami,’ yimi. Kiyi awarra ngini ngarra yintinila yimi kangi ngarra-rringani, ‘Manya, ngirringani, ngiya nguwuja waki ngirimi awungarruwu kapi ngini-nginjila garden,’ yimi awarra ngini yintinila api ngarra karluwu yuwuriyi kapi awarra garden ngini waki yimatami.” Awarra ngirramini (story) ngawa-yuwuni yuwuntiyarra awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Kiyi ngawa-yuwuni nanginta yimi awuta alawuruwi, “Nginuwani malakaninga warntirrana kuwa yimi ngarra-rringani?” yimi ngawa-yuwuni kapi awuta alawuruwi. Kiyi awuta alawuruwi purru-wutiyarra ngawa-yuwuni, “Ngarra awarra ngini aringamini warntirrana kuwa yimi ngarra-rringani, karluwu awarra ngini yintinila,” pirimi kapi ngawa-yuwuni. Kiyi ngawa-yuwuni yimi kangi awuta alawuruwi, “Nuwa kapi nuwa alawuruwi api pupuwi ngimpiri-mamuliya amintiya nuwa ngimpirimi ngini yingampa (some) arikutumunuwi api wuta jajiruwi, nginingaji awuta wawurruwi kapi waki wurimi ngini (for) awuta Roman alawuruwi amintiya nanginta wurimi ngawa Jews kunawuni ngini tax api wuta arrami mitaya wurimi yingampa awarra kunawuni. Amintiya awanuwanga nuwa ngimpirimi ngini wuta jajiruwi awuta maminikuwi kapi wurimarrimili tayikuwapi wawurruwi amintiya kapi nanginta wurimi awuta wawurruwi kunawuni. Awarra warntirrana ngini wuta jirti pirikirim-ani (done wrong) awuta maminikuwi amintiya awuta wawurruwi kapi wuta waki wurimi ngini tax api awuta yingampa waya kuwa pirimi awarra ngirramini ngini John the Baptist yuwuntiyarra awuta api wuta waya purrupumwari awarra jirti ngini wuta pakinya pirikirim-ani (the wrong they used to do) api waya wupapunya ngawa-rringani angatawa jarrumoka. Api wuta wiyi wuriyi kuriyuwu kapi ngini-ngatawa japuja api nuwa kapi nuwa alawuruwi api nuwa arrami wiyi karluwu pimatu-wariyi kapi ngawa-rringani ngarra japuja pili nuwa karluwu kuwa ngintirimi awarra ngirramini ngini-ngatawa John the Baptist amintiya karri nuwa nginti-pakuluwunyi awuta wawurruwi amintiya awuta maminikuwi ngini purrupumwari awarra jirti ngini wuta pakinya pirikirim-ani api nuwa karluwu nguntu-pumwari awarra jirti ngini nuwa ngintiri-kirim-ani. Yita nuwa nanuwanga (still) ngimpapunya awinyirra jiringa jarrumoka.” Awarra yimi ngawa-yuwuni kapi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kiyi ngawa-yuwuni Jesus yimi kapi ngarra-mamanta, “Ngiya waya ngurru-wutiyarra nuwa ngini ngiya wiyi ngipakupawurli kuriyuwu kapi ngiya-rringani api wiyi nguwuni-pakupawurli (come back) kapi naki awungarra murrakupuni (to this earth). Karri-kuwapi wurimajawu awinyirra wumunga (day) karri ngiya wiyi nguwuni-pakupawurli awungarra. Awuta angeluwi awanuwanga karluwu wurimajawu karri ngiya wiyi nguwuni-pakupawurli. Ngiya wiyarri karluwu ngirimajawu awinyirra wumunga. Waya juwa ngiya-rringani arimajawu karri ngarra wiyi tuwanga awuni-pangirri (send) ngiya awungarra kapi naki murrakupuni.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kiyi yimi ngawa-yuwuni ngini, “Nuwa nuwa-yuwuni ngiya nuwa tayikuwapi tiwi api karri yinkitayi nguwuni-pakupawurli awungarra api arikutumunuwi wiyi awungarri pirlamarri (not knowing) wurumuwu nginingaji karri ngarra Noah yimuwu api awuta arikutumunuwi pirlamarri purumuwu karri awarra yingarti kukuni waya yinkitayi yipakaluwangi (flooded) murrakupuni. ");
INSERT INTO tiw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Tani-waya (no matter) awarra Noah yuwuntiyarra awuta tiwi ngini waya yinkitayi yingarti pakitiringa apungoli api apukaluwangi (flood) murrakupuni api awuta tiwi karluwu kuwa pirimi awarra ngirramini ngini ngarra yipangiraga. Waya juwa puru-pungintayi (thought about) wutalamiya, nginingaji wuta puru-pungintayi yinkiti amintiya awarra ngini wuta pirimangapa. Amintiya awanuwanga puru-pungintayi ngini marriti pirimi wuta-mantanga amintiya pirripakirayi wuta-mwaruwi kapi wuta-mamirampi pili-ngini marriti pimatami. Tani-waya (no matter) wuta pirripakuluwunyi awarra Noah ngini yikirimi awinyirra miratinga (ark) api kiyi ngini yipawuriji yilaruwu kangi awinyirra miratinga awarra Noah amintiya ngarra-mamirampi api awuta tiwi pirlamarri purumuwu api wiyi (later on) awarra yingarti kukuni yipakaluwangi (flooded) murrakupuni api wuta purrupungarti awuta tiwi. Api awarra yuraparri (is the same) karri ngiya wiyi tuwanga nguwuni-pakupawurli awungarra kapi naki murrakupuni pili awuta tayikuwapi arikutumunuwi wiyi karluwu kuwa pimatami ngini ngiya waya yinkitayi nguwuni-pakupawurli awungarra, ngiya awarra nuwa-yuwuni nuwa tayikuwapi tiwi. Wuta wiyi awungarri pirlamarri (not knowing) wurumuwu awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wiyi awungarri yuwurrara wawurruwi wurukurungumi (dig) kapi garden api ngiya wiyi nguwuntiyarra angeluwi ngini, ‘Nyirru-wariyi kapi awarra garden api yati awarra tini ngini kuwa arimi ngiya api nyirra-marruriyi awarra kuriyuwu kapi ngiya-rringani japuja. Api ngarratuwu nyoni ngini ngarra arnuka kuwa arimi ngiya api nyirra-mwari awarra tini kapi yakuluwuni.’ Ngiya awarra wiyi nguwuntiyarra awuta angeluwi,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kiyi yimi ngini, “Awanuwanga yuwurrara maminikuwi wiyi awungarri jipitini wuji-kirimi awarra wheat kurukura (seed) ngini pimata-kirimi pamantarri api wuta awanuwanga awuta angeluwi wiyi natinga yimpalinya wunga api wurimarruriyi awinyirra kuriyuwu pili nyirra kuwa ampirimi ngiya api awinyirra nyonga wupumwari kapi yakuluwuni. Wuta wiyi awungani-la wurimi (keep doing that) awuta angeluwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kiyi yimi ngawa-yuwuni ngini, “Karri wiyi ngiya ngipapurti kapi ngiya-rringani japuja api nyirra-punya-la (keep following) angilawa pupuka jarrumoka. Ngajiti ngimpaja-mwari awinyirra jarrumoka pili nuwa karluwu ngimpiri-majawu karri wiyi ngiya nguwuni-pakupawurli awungarra kapi naki murrakupuni.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Karri japinari karri warnarringa jini-papurti api awuta tayikuwapi priests kapi wuta alawuruwi amintiya awuta yingampa alawuruwi kapi wuta Jews api wuta mimpa pirimi kiyi nimarra pirimajirri ngini, “Awarra naki Jesus pajuwani yimatami (should die) api awungana ngamatama?” pirimi. Kiyi pirimi ngini, “Ngawa ngawurra-marruriyi ngarra kapi awarra Pilate api ngarra Pilate wiyi awuntiyarra awuta soldiers ngini pajuwani pimata-kirimi ngarra.” Awarra pirimi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kiyi wuta purruwunga arlipurringa api pirikimirna ngawa-yuwuni ngarra yikara ngini pimatu-wariyi ngarra kapi awarra alawura Pilate ngarra japuja. Awarra Pilate api ngini-ngatawa murrakupuni Rome api ngarra alawura kapi awarra murrakupuni Judea. ");
INSERT INTO tiw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kiyi awarra Judas ngini ngarra traitor yimi kapi ngawa-yuwuni Jesus api karri yipitingaya ngini awuta alawuruwi nimarra pirimi ngini wuta wiyi pajuwani wurikirimi awarra ngawa-yuwuni api ngarra arliranga yikirimi api kiyi yuwuriyi yuwunga awarra 30 pwaja (coins) ngini silver ngini awuta alawuruwi pirripakirayi ngarra. Kiyi yimarruriyi awarra pwaja kapi awuta alawuruwi pili ngarra yuwutimarti ngini yimata-kiray-awurli (give back) awarra pwaja kangi wutawa. ");
INSERT INTO tiw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kiyi awarra Judas yimi kangi awuta alawuruwi, “Awi,” yimi. “Ngarra pupuni tini awarra Jesus api jirti awarra ngini ngiya ngurru-wutiyarra nuwa kapi (where) ngarra Jesus yimuwu pili nuwa ngimpitimarti ngini pajuwani nginti-mata-kirimi ngarra.” Ngarra awarra Judas yipangiraga. Api pirimi awuta alawuruwi kapi awarra Judas, “Pilikama awarra juwutiyarra ngawa pili nginja nginjila awarra ngirramini,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Api awarra Judas yuwunyawu awarra pwaja kapi yakuluwuni yilaruwu kangi awinyirra arikulanga jurra api ngarra wiyi (later on) yuwuriyi kapi nyoni murrakupuni kiyi yuwunga arlipurringa api yikimirn-amiya awinyirra arlipurringa kangi ngini-ngatawa miraka api yimatilay-amiya (he hung himself) kangi purinjirringa. Kiyi pajuwani yimi. ");
INSERT INTO tiw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kiyi awungarruwu kapi awinyirra jurra yingampa awuta alawuruwi purruwunga awarra pwaja ngini awarra Judas yuwunyawu kapi yakuluwuni api pirimi ngini, “Ngini-ngawula ngirramini (law) ngini ngawa karluwu ngamatalami kangi jurra naki awarra pwaja pili ngarra awarra pwaja api ngawa nginti-pakirayi awarra pwaja kapi awarra Judas pili ngawa nguntu-wutimarti ngini wuta pajuwani pimata-kirimi awarra nayi Jesus.” Wuta awarra pirripangiraga awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Api kiyi pirimajirri ngini, “Ngawa awungana (what) ngamata-kirimi (do with) nginaki pwaja?” Api awungarruwu kapi awarra murrakupuni yati tini yimuwu ngini ngarra yuwuni (had) ngini-ngatawa kirijini murrakupuni api awungaji kapi awarra kirijini murrakupuni ngarra yuwunga-mini parruwarti ngini yikirim-ani wurika (dishes). Api awuta alawuruwi pirimi kangi wutamiya ngini, “Ngawurliyi ngarimarruriyi naki pwaja kapi awarra tini api nanginta ngarimi awarra tini ngini yimata-kirayi ngawa ngini-ngatawa kirijini murrakupuni api awuta tiwi kapi wuta nyoni murrakupuni api japuja wurikirimi awungarra api karri wuta pajuwani wurimi api ngawa wiyi ngarikijika awuta kapi awarra kirijini murrakupuni.” Wuta awarra pirimi awuta alawuruwi. Kiyi wuta wiyi (later on) pirimarruriyi awarra pwaja kapi awarra tini api nanginta pirimi ngarra ngini yimata-kirayi awuta awarra ngini-ngatawa murrakupuni. Api “Manya,” yimi awarra tini. Kiyi pirripakirayi ngarra awarra pwaja. ");
INSERT INTO tiw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wuta wiyi (later) pirimamula (called) awarra kirijini murrakupuni Majipani (blood land) pili awuta alawuruwi pirripakirayi awarra pwaja kapi awarra Judas pili ngarra traitor yimi kapi ngawa-yuwuni api awuta alawuruwi wiyi (later) pajuwani pirikirimi awarra ngawa-yuwuni api ngarra ngawa-yuwuni ngini-ngatawa majipani awungarri alala yimi. Api wiyi wuta pirimamula (called) awarra murrakupuni Majipani. Wuta nanuwanga wurimamula awarra murrakupuni Majipani. ");
INSERT INTO tiw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Karri pangarri karri Sabbath Day (Saturday) api awungarri awuta priests kapi wuta alawuruwi amintiya awuta Pharisees, wuta purruwuriyi kapi Pilate kiyi nimarra pirimi kangatawa, ");
INSERT INTO tiw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Aya,” pirimi. “Ngawa ngarimajawu ngini awarra Jesus karri ngarra nanuwanga (still) yimpangini api ngarra manya yimi ngini, ‘Karri ngiya wiyi pajuwani ngirimi yirrajirrima wumunga (days) api awungarri ngiya wiyi ngupukularri api tuwanga yimpangini ngirimi.’ Awarra Jesus yimi awarra karri ngarra nanuwanga yimpangini yimi,” pirimi awuta alawuruwi kapi awarra Pilate. ");
INSERT INTO tiw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kiyi wuta pirimi kapi awarra Pilate, “Tajiyarra yingampa soldiers ngini wurru-wariyi kapi awarra cave kapi awarra Jesus ngarra purnikapa apalamiya api ngini wurra-mangi (must watch) awarra cave pili arramukuta ngarra-mamanta wiyi mitaya wurimi Jesus ngarra purnikapa. Ngini wuta mitaya wurimi ngini-ngatawa purnikapa api wuta wiyi wuntiyarra tayikuwapi tiwi ngini awarra Jesus waya yipukularri api ngini tuwanga yimpangini yima. Ngini ngarra-mamanta wiyi wuntiyarra arikutumunuwi ngini awarra Jesus waya yipukularri api tuwanga yimpangini yima api awuta arikutumunuwi wiyi arrami kuwa wurimi awarra ngirramini. Api awarra warntirrana jirti pili awuta ngarra-mantawi wiyi awarra kunyani wurimi. Api awuta soldiers wurra-mangi (must look after) awarra cave.” Wuta awarra pirimi kapi Pilate, awuta priests kapi wuta alawuruwi amintiya awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kiyi awarra Pilate yimi kangi wuta, “Manya! Nyirru-wariyi nyirra-jiyarra awuta soldiers ngini wuta wurra-mangi awarra cave,” yimi. ");
INSERT INTO tiw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Api awuta alawuruwi pirripangirri (sent) yingampa soldiers kapi awarra cave. Awungarruwu kapi awarra cave arikulanga waranga kunji jiyimi ngini-ngatawa yangamini awarra cave amintiya yingampa wawurruwi purruwunga arlipurringa amintiya pirikimirna kapi awinyirra waranga pili-ngini wiyi arramu-kuwapi karluwu pimata-ngirri (push away) awinyirra waranga. Kiyi awuta soldiers tayinti pirimi kapi yakuluwuni yinkitayi kapi awarra cave amintiya pirripamangi awarra cave. ");
INSERT INTO tiw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","4","Kiyi karri awarra Sabbath Day yipapaya api karri japinamini api ngawa-rringani ngini kuriyuwu yini-pangirri (sent) yati yingumpunila (angel) kapi awarra cave. Kiyi awarra yingumpunila yipangirri (pushed away) awinyirra arikulanga waranga angi kunji jiyimi awarra yangamini kapi awarra cave api awungarri yakuluwuni yuwuntipa (shook). Kiyi awarra yingumpunila yimuwu kuriyuwu kangi awinyirra waranga. Awarra yingumpunila ngarra ngirri-ngirri yimi nginingaji warnarringa amintiya angatawa kuluji nginingaji turtiyangini (white). Awuta soldiers kapi pirripamangi awarra cave api karri wuta pirripakuluwunyi awarra yingumpunila api wuta pirimakirri kiyi pulingiya pirimi. Kiyi wuta pirripakupuraji kangi yakuluwuni nginingaji wuta pajuwani pirimi. ");
INSERT INTO tiw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kiyi awuta yingampa maminikuwi, karri pirripawuriji yilaruwu kapi awarra cave, api pirripakuluwunyi awarra yingumpunila (angel) api ngarra yimi kapi wutawa, “Ngajiti ngimpaja-wanga! Ngiya ngirimajawu ngini nuwa kularlaga ngimpirimi awarra Jesus ngini ngarra nangunji pajuwani yimi, ");
INSERT INTO tiw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","api ngarra purnikapa waya arnuka awungarra. Ngarra waya yipukularri api tuwanga yimpangini yimi nginingaji ngarra yuwutiyarra nuwa puniyarri (before) karri ngarra nanuwanga (still) yimpangini. Nyirru-waripa yilaruwu kapi naki cave kiyi nyirra-kuluwunyi kapi ngarra purnikapa yuwujingi-milani karri pakinya,” yimi awarra yingumpunila kapi awuta maminikuwi. ");
INSERT INTO tiw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kiyi awarra yingumpunila tuwanga yimi kangi wutawa, “Nyirru-wariyi nyirra-jiyarra ngarra-mamanta, ‘Nayi awarra Jesus waya yipukularri api tuwanga yimpangini yimi. Ngarra wiyi aringampi awuriyi kapi awarra murrakupuni Galilee api awungarruwu nuwa wiyi ngumpunyayi ngarra.’ Awarra ngirramini nyirra-jiyarra awuta ngarra-mamanta. Ngiya waya juwa awarra ngirramini nginiri-marruriyi kapi nuwa,” yimi awarra yingumpunila kangi awuta yuwurrara maminikuwi. ");
INSERT INTO tiw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Awuta yuwurrara maminikuwi pirimakirri awarra yingumpunila api yartipili purrupumwari awarra cave. Wuta awanuwanga kukunari pirimi pili ngawa-yuwuni waya yimpangini yimi api wuta kalikali pirimi kapi ngawa-yuwuni ngarra-mamanta ngini pimata-jiyarra awuta ngini ngawa-yuwuni waya yimpangini yima. ");
INSERT INTO tiw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Karri awuta maminikuwi purruwuja api ngawa-yuwuni Jesus papi yimi kangi wutawa kiyi ngarra yimi ngini, “Awi, mamanta.” Api wuta punuwuriyi kangatawa kiyi purruwunga ngarra malapwara amintiya puru-kuruwarni (thanked) ngarra. Api ngawa-yuwuni yimi kangi wutawa, “Ngajiti ngimpaja-wanga. Nyirru-wariyi nyirra-jiyarra ngiya-mamanta ngini wuta wurru-wariyi kapi awarra murrakupuni Galilee amintiya ngini awungarruwu wuta wiyi wupakuluwunyi ngiya.” Awarra yimi ngawa-yuwuni kapi awuta maminikuwi. ");
INSERT INTO tiw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Parlinginari (later on) yingampa awuta soldiers kapi pirripamangi awarra cave api wuta pirripakupawurli kapi Jerusalem api purruwuriyi kapi awuta priests kapi wuta alawuruwi kiyi purru-wuntiyarra awuta, “Yati yingumpunila (angel) yinuwuriyi kapi awarra cave kiyi yipangirri (pushed away) awinyirra waranga angi kunji jiyimi awarra yangamini kapi awarra cave api karri ngawa nginti-pakuluwunyi yilaruwu kapi awarra cave api awarra Jesus ngarra purnikapa waya yipamulijipa (disappeared).” Awarra pirimi awuta soldiers kapi awuta priests kapi wuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Karri awuta priests piri-pitingaya (heard) awarra ngini awuta soldiers pirripangiraga api awuta priests amintiya awuta yingampa alawuruwi kapi wuta Jews api wuta mimpa pirimi kiyi nimarra pirimajirri, “Awungana ngamatama?” pirimi. Kiyi pirimi ngini, “Ngawa ngawurra-kirayi (we must give) awuta soldiers kunawuni ngini wuta wiyi karluwu pimata-jiyarra yingampa arikutumunuwi ngini wuta pirripakuluwunyi awarra yingumpunila awungarruwu kapi awarra cave amintiya ngini awarra Jesus ngarra purnikapa waya yipamulijipa (disappeared).” Awarra pirimajirri awuta alawuruwi. Api kiyi wuta pirripakirayi awuta soldiers yingarti kunawuni kiyi pirimi kangi wutawa, “Ani, nuwa kunawuni. ");
INSERT INTO tiw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Api ngini yingampa tiwi nanginta wurimi nuwa ngini, ‘Maka awarra Jesus ngarra purnikapa?’ api nyirra-jiyarra awuta ngini ngarra-mamanta punuwuriyi kapi awarra cave karri japinamini karri nuwa ngintiri-majirripi api wuta mitaya pirimi ngarra purnikapa awarra Jesus. ");
INSERT INTO tiw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Amintiya ngini awarra alawura Pilate wiyi ari-pitingaya (hears) ngini nuwa ngintiri-majirripi amintiya ngini nuwa karluwu warntirrana nginti-pamangi awarra cave api arramukuta ngarra wiyi awutimarti ngini jirti ngirramini (trouble) yimata-kirayi nuwa. Api ngajiti worry ngimpajami pili ngawa alawuruwi wiyi nimarra ngarimi kapi awarra Pilate ngini ngarra karluwu yimata-kirayi jirti ngirramini kangi nuwa,” pirimi awuta alawuruwi kapi awuta soldiers. ");
INSERT INTO tiw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kiyi awuta soldiers purruwunga awarra kunawuni. Kiyi wuta wiyi (later on) purru-wuntiyarra yingampa tiwi ngini ngawa-yuwuni ngarra-mamanta mitaya pirimi ngarra purnikapa. Waya ningani awuta Jews nanuwanga (still) wuntiyarra wuta-mamirampi wuta-mwaruwi awarra-wanga (same) ngirramini ngini ngawa-yuwuni ngarra-mamanta mitaya pirimi ngarra purnikapa. ");
INSERT INTO tiw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kiyi ngawa-yuwuni Jesus ngarra-mamanta awuta wamurrara yati (11) purruwuriyi kapi awarra jupunyini (hill) kapi ngawa-yuwuni yuwuntiyarra awuta ngini wuta pimatu-wariyi. Awarra jupunyini awungarruwu kapi awarra murrakupuni Galilee. ");
INSERT INTO tiw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kiyi awungarruwu ngawa-yuwuni papi yimi kangi wutawa api kiyi wuta puru-kuruwarni (thanked) ngarra. Api yingampa awuta ngarra-mamanta karluwu puru-kuruwarni ngawa-yuwuni pili wuta amparrimani pirrarimi ngini ngarra nyoni tini. ");
INSERT INTO tiw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","19","Kiyi ngawa-yuwuni yinkitayi yuwuriyi kapi awuta ngarra-mamanta api yimi ngini, “Awi, mamanta, ngiya-rringani ngini kuriyuwu waya yikirimi ngiya alawura kangi awuta tayikuwapi (all) arikutumunuwi kapi nginingaji ngatawa murrakupuni (the whole world) amintiya ngiya awanuwanga alawura kapi awuta kapi wurumuwu kuriyuwu kapi ngarra japuja. Api nuwa wiyi nyirru-wariyi kapi nginingaji ngatawa murrakupuni kiyi nyirra-jiyarra awuta arikutumunuwi awarra ngini-ngilawa ngirramini ngini wuta pimata-mwari awarra jirti ngini wuta pakinya pirikirim-ani (the wrong they used to do) amintiya ngini pimata-punya (should follow) angilawa jarrumoka. Api karri awuta arikutumunuwi wiyi kuwa wurimi kangilawa api nuwa baptise nyirra-kirimi awuta amintiya nyirra-jiyarra awuta ngini ngarra ngiya-rringani ngini kuriyuwu ngarra waya ngini-wutawa alawura. Awanuwanga ngiya amintiya ngiya-rringani ngini-ngatawa pukwiyi (Holy Spirit) ngawa wiyarri wiyi kapi-wutawa alawuruwi. Awarra nyirrami kangi awuta arikutumunuwi karri nuwa wiyi baptise ngimpiri-kirimi awuta,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kiyi ngawa-yuwuni yimi kapi awuta ngarra-mamanta, “Karri awuta arikutumunuwi wiyi wupapunya angilawa jarrumoka api nyirra-jiyarra awuta awarra tayikuwa-ni (all) ngirramini ngini ngiya pakinya ngurru-wutiyarra nuwa amintiya awanuwanga nyirra-jiyarra awuta ngini wuta kuwa wurrami (must obey) awarra tayikuwa-ni ngirramini. Naki awarra ngirramini warntirrana ngini ngiya wiyi yiloti ngipamangi nuwa amintiya wiyi nguru-wani (help) nuwa right through karri naki murrakupuni apapaya (the world finishes).” Awarra yimi ngawa-yuwuni Jesus kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kiyi ngarra ngawa-yuwuni yipumori awarra murrakupuni Nazareth api kiyi yuwuriyi awungarruwu kapi awarra John the Baptist baptise yuwujingim-ani arikutumunuwi kapi awinyirra makatinga Jordan. Api karri papi yimi awungarruwu awarra ngawa-yuwuni api yuwuriyi kapi awarra ngarra-mantani api awungarruwu awarra John the Baptist baptise yimi awarra ngawa-yuwuni. Api kiyi awarra ngawa-yuwuni karri yipumori awinyirra makatinga api yipaputi kapi murrakupuni api awungarri yipa-kuluwunyi kuriyuwu kapi yirrokunga api yipa-kuluwunyi awarra yirrokunga ngini split yimi api kiyi awungarruwu papi yinirimi Holy Spirit api yinipa-pirraya. Kiyi kapi ngarra ngawa-yuwuni tuluwa yipa-wulari. Ngarra awarra Holy Spirit nginingaji mopurawayi yima. ");
INSERT INTO tiw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Api kiyi ngawa-rringani yipangiraga makirrana awungarruwu kapi kuriyuwu nimarra yimi kapi ngarra-mirani ngini, “Ngiya ngiya-mirani nginja. Yita ngiya pupuni ngirimuwu nginja amintiya kukunari ngirimi kapi nginja.” Awarra yipangiraga ngawa-rringani awungarruwu kapi kuriyuwu. Waya juwa. ");
INSERT INTO tiw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ninkiyi, wuta matatawi purruwunga awarra John the Baptist, api pirrimarruriyi awarra kapi awarra jail. Karri yimajingolamuwu awarra John the Baptist, api awungarri ngawa-yuwuni yuwuriyi kapi awarra murrakupuni Galilee. Karri ngarra papi yimi awungarruwu, api yuwujiyarra arikutumurnuwi ngini ngarra ngirramini ngawarringani, api yimi ngini, ");
INSERT INTO tiw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Parlingarri ngawa-rringani yimi ngini ngarra wiyi apamangi arikutumurnuwi, amintiya yimi ngini ngarra wiyi alawura arimuwu kangi awuta arikutumurnuwi. Api waya yinkitayi karri ngarra wiyi apamangi awuta, api ngini nuwa pungintaga yimatayajapurnimaya kapi ngawa-rringani, amintiya nuwa kuwa ngintimataami ngini ngarra ngirramini,” yimi ngawa-yuwuni kangi awuta arikutumurnuwi. ");
INSERT INTO tiw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ninkiyi, yuwuriyi kapi awarra yirringarni Galilee. Awungarruwu yintulinga yimi kapi awarra yirringarni. Kiyi, yuwuninyayi yuwurrara wawurruwi wuta ngarruwani. Panapa purruwujingunyawani kapi awarra yirringarni ngini pimatapirni miputi. Ngarratuwu ngini arikulani api ngarra yintanga Simon Peter, ngarratuwu ngini ngarra yipapunya api ngarra yintanga Andrew. ");
INSERT INTO tiw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Karri awarra ngawa-yuwuni yuwuninyayi awuta yuwurrara, api ynipamurnata, yimi ngini, “Nyirruwaripa. Ngiya nyirrayapunya,” yimi ngawa-yuwuni. “Nuwa waya karluwu ngintimatakupawurli ngini ngintimatapirni miputi. Nginta ngiya wiyi ngupangirri nuwa ngini nuwa kularlaga ngintimatami arikutumurnuwi, api nuwa wiyi nuwunirimarruriyi kangilawa api wuta wiyi wupapunya ngiya, awuta arikutumurnuwi,” yimi ngawa-yuwuni. Awarra yuwuntiyarra wuta ngarruwani, Simon wuta Andrew. ");
INSERT INTO tiw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Api wutatuwu pirimi ngini, “Manya, ngawurliyi.” Ninkiyi, pirripumori awinyirra panapa, kiyi pirripapunya ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tingatinga pirriyimamani api kiyi aringompinara purruwunyayi yingompa wawurruwi kapi jupulunga, wuta ngarruwani awuta amintiya wuta-rringani amintiya yingompa kapi pirripamurrumi ngini ngarra. Ngarratuwu wuta-rringani ngarra yintanga Zebedee, api wuta ngarra-mamirampi yintanga James amintiya John. Wuta piripirtawiyamini panapa. ");
INSERT INTO tiw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Api ngawa-yuwuni, karri yipakuluwunyi awuta yuwurrara wuta ngarruwani, api yartipili kuwayi yimi kangi awuta. “Nyirruwaripa, nyirrayapunya ngiya,” yimi. Api kiyi, kutupi pinirimi kapi jupulunga kiyi pirripumori wuta-rringani amintiya awuta kapi pirripamurrumi ngini ngarra. Ninkiyi, pirripapunya ngawa-yuwuni wuta ngarruwani. ");
INSERT INTO tiw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ninkiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purruwuriyi awungarruwu kapi awarra town Capernaum. Karri Sabbath Day (Saturday), karri awuta Jews karluwu waki pirimani api awungarri ngawa-yuwuni amintiya ngarra-mamanta purruwuriyi kapi awinyirra kirijinga jurra angi-wutawa Jews (synagogue) api pirripawuriji yilaruwu. Awungaji ngawa-yuwuni yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Api awuta arikutumunuwi, karri wuta piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yipangiraga api pirimarlingiyi (got a surprise) api pirimajirri ngini, “Awarra ngirramini ngini awarra naki Jesus apangiraga api yita nginingaji ngawa-rringani yipakirayi ngarra awarra ngirramini amintiya ngini yini-pangirri (sent) kangawula awarra Jesus ngini ngarra yimata-jiyarra ngawa awarra ngirramini. Api awuta scribes kapi wuruwaluwa (teach) ngawa ngini-ngawula ngirramini (law) api wuta waya juwa wutiyarra ngawa awarra ngirramini ngini awuta prophets parlingarri pirikirim-ani (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) amintiya wutiyarra ngawa awarra ngirramini ngini awuta papaluwi puturupura (left behind) kapi ngawa. Waya juwa awarra ngirramini wutiyarra ngawa. Api awarra naki Jesus warntirrana apangiraga ngini-ngatawa ngawa-rringani ngirramini,” pirimi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Kiyi yati tini yini-pawuriji yilaruwu kapi awinyirra jurra api awarra tini yuwuni (had) maputiti yilaruwu kangi ngarra purnikapa. Karri awarra tini yuwunyayi ngawa-yuwuni api awarra maputiti ngini yimuwu kapi ngarra purnikapa api ngarra kuwayi yimi kangi ngawa-yuwuni, “Aya. Nginja japuja nimpirimi awungarruwu kapi awarra town Nazareth. Ngiya waya ngirimajawu nginja. Awarra ngatawa ngini ngarra japuja kuriyuwu (God) yini-pangirri (sent) nginja awungarra. Nginja warntirrana pupuni. Pilikama jinu-wuriyi awungarra? Arramukuta nginja nimpitimarti ngini jimata-pirni ngawa kapi maputirruwi,” yimi awarra maputiti ngini yimuwu yilaruwu kangi ngarra purnikapa awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kiyi ngawa-yuwuni yimi kapi awarra maputiti, “Tawunjarli. Papi tamuwa (come out) kapi awarra tini ngarra purnikapa,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kiyi awarra maputiti yikirimi awarra tini ngini pulingiya yimi. Kiyi ngarra awarra maputiti makirrana kuwayi yimi api awungarri papi yinirimi kapi awarra tini ngarra purnikapa. ");
INSERT INTO tiw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Awuta arikutumunuwi karri wuta pirripakuluwunyi ngini awarra maputiti kuwa yimi awarra ngirramini ngini ngawa-yuwuni yipangiraga amintiya karri wuta piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yuwuntiyarra awuta api wuta pirimarlingiyi (got a surprise) api nimarra pirimajirri ngini, “Ngawa mampara ngari-pitingaya awarra naki ngirramini ngini ngarra apangiraga. Yita nginingaji ngawa-rringani yuwutiyarra ngarra awarra ngirramini. Amintiya karri ngarra nimarra arimi kapi awuta maputirruwi api wuta kuwa wurimi ngarra.” Awarra pirimajirri awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kiyi yingampa awuta arikutumunuwi yartipili kularlaga pirimi awungarruwu kapi awarra murrakupuni Galilee api purru-wuntiyarra tayikuwapi arikutumunuwi awarra ngirramini ngini ngarra ngawa-yuwuni yipangiraga amintiya ngini ngarra papi yiniri-mamiyi awarra maputiti kapi awarra tini ngarra purnikapa. ");
INSERT INTO tiw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purrupumwari awinyirra jurra. Kiyi wuta purruwuriyi kapi Simon Peter amintiya Andrew wuta tangarima kiyi ngawa-yuwuni amintiya awuta yukurri ngarra-mamanta, James amintiya John kiyi Simon Peter amintiya Andrew pirripawuriji yilaruwu kapi awinyirra kurrampali. ");
INSERT INTO tiw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon Peter ngarra-ngimpirinyuwa jiyimajirripi kangi palapala pili nyirra jana. Nyirra yikwanari jiyimi. Api kiyi wuta pirimi kapi ngawa-yuwuni, “Yita Simon ngarra-ngimpirinyuwa jana,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kiyi ngarra ngawa-yuwuni yuwuriyi kapi nyirra jiyimajirripi. Api kiyi ngarra yuwunga nyirra yikara api yuwani (helped) awinyirra ngini kutupi jiyimi. Api karri nyirra jipukularri api awungarri awarra jana yipumwari nyirra purnikapa. Kiyi nyirra jipawumi yinkiti kiyi jipakirayi ngawa-yuwuni amintiya ngarra-mamanta awarra yinkiti. ");
INSERT INTO tiw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","34","Kiyi karri waya yiminga jipungarti api tayikuwapi arikutumunuwi purruwuriyi kapi ngawa-yuwuni. Wuta pirimarruriyi kangatawa wuta-mamanta kapi wuta purunjuwi ngini ngarra pupuwi yimata-kirimi awuta. Awuta tiwi wangatajirri jana purruwuni. Amintiya wutatuwu yingampa arikutumunuwi wuta purruwuni maputirruwi yilaruwu kangi wuta purnikapa. Tayikuwapi awuta arikutumunuwi kapi tangarima pirimi awungarruwu kapi awarra town api wuta mimpa pirimi turruwuni kapi awinyirra kurrampali kapi ngawa-yuwuni yimuwu. Api kiyi ngawa-yuwuni pupuwi yikirimi awuta kapi purunjuwi. Amintiya awuta kapi purruwuni maputirruwi yilaruwu kangi wuta purnikapa api ngarra papi yiniri-mamiyi awuta maputirruwi kapi wuta purnikapa. Kiyi ngawa-yuwuni yimi kapi awuta maputirruwi, “Nuwa ngajiti ngimpaja-jiyarra arikutumunuwi ngini (about) ngiya.” Ngarra ngawa-yuwuni nimarra yimi awarra pili awuta maputirruwi pirimajawu ngini ngarra Jesus awarra Christ ngini ngawa-rringani ngini kuriyuwu yini-pangirri (sent) awungarra kapi naki murrakupuni (to this earth). Ngawa-yuwuni arnuka yuwutimarti awuta maputirruwi ngini pimata-jiyarra awuta arikutumunuwi ngini ngarra awarra Christ. ");
INSERT INTO tiw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kiyi nyonga wumunga karri natinga arawunga ngawa-yuwuni Jesus yipangipari kiyi yipukularri. Ngarra yipumwari awinyirra kurrampali kiyi yuwuriyi kapi karri-kuwapi japuja pirimi. Awungarruwu ngarra nimarra yimi kapi ngarra-rringani ngini kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kiyi tayikuwapi arikutumunuwi papi pirimi kapi awinyirra kurrampali, kiyi pirimi kapi ngawa-yuwuni ngarra-mamanta, “Awi, maka yimi nuwa-mantani Jesus?” pirimi. Api awuta ngarra-mamanta pirimi ngini, “Kuta maka yimi.” Kiyi ngawa-yuwuni ngarra-mamanta kularlaga pirimi ngarra. ");
INSERT INTO tiw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Api karri wuta purruwunyayi awarra ngawa-yuwuni api purru-wutiyarra ngini, “Aya, yuwuni, tayikuwapi arikutumunuwi punuwuriyi kangawula pili wuta kularlaga pirimi nginja,” pirimi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Api awarra ngawa-yuwuni yimi ngini, “Ngiya karluwu ngimata-kupawurli kapi awarra town Capernaum. Yita wanga ngawuriyi nyoni murrakupuni pili-ngini ngiya nguwuntiyarra yingampa (other) arikutumunuwi ngiya-rringani ngini-ngatawa ngirramini. Ngiya-rringani yini-pangirri (sent) ngiya kapi tayikuwapi arikutumunuwi pili-ngini nguwuntiyarra awuta ngini-ngatawa ngirramini. Api waya ngawurniyi awungarruwu kapi nyoni murrakupuni pili-ngini ngiya nimarra ngimatami kapi awuta tiwi,” yimi ngawa-yuwuni kapi ngarra-mamanta. Api wutatuwu pirimi ngini, “Manya awarra. Ngawurniyi,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kiyi ngawa-yuwuni amintiya ngarra-mamanta kularlaga pirimi kapi awarra murrakupuni Galilee api awungarruwu wuta pirripawuriji yilaruwu kapi yingarti jurra angi-wutawa Jews kiyi ngawa-yuwuni yuwuntiyarra awuta arikutumunuwi ngini ngawa-rringani ngini-ngatawa ngirramini. Awungarruwu kapi awarra murrakupuni ngawa-yuwuni yuwunyayi yingampa tiwi kapi purruwuni maputirruwi yilaruwu kapi ngini-wutawa purnikapa api papi yiniri-mamiyi awuta maputirruwi kapi wuta purnikapa. ");
INSERT INTO tiw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kiyi ngawa-yuwuni Jesus yipapirraya kapi lake api awungarruwu yimuwu, kiyi tayikuwapi arikutumunuwi punuwuriyi kangatawa. Kiyi ngarra yuwunt-iyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Karri ngarra yipapaya ngini nimarra yimi api yipumwari awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Karri ngawa-yuwuni yuwuja api yipakuluwunyi yati tini ngini ngarra waki yimani ngini (for) awuta Roman alawuruwi amintiya ngarra nanginta yimani ngarra-mamanta awuta Jews awarra kunawuni ngini tax. Awarra tini ngarra yintanga Levi amintiya ngarra-rringani ngarra yintanga Alphaeus. Kiyi ngawa-yuwuni yimi kapi awarra Levi, “Aya, kali tayapunya ngiya,” yimi. Api kiyi awarra Levi yipukularri kiyi yipapunya ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kiyi awarra Levi yimarruriyi ngawa-yuwuni amintiya ngarra-mamanta kangatawa japuja kiyi yuwunt-akirayi awuta yinkiti. Yingampa wawurruwi kapi wuta nanginta pirimani awuta wuta-mamanta kapi Jews awarra kunawuni ngini tax api wuta pirripapunya ngawa-yuwuni wuturiyi yingampa (other) arikutumunuwi kapi wuta Pharisees pirimi ngini wuta jajiruwi. Wuta awuta arikutumunuwi wiyarri purruwapa yinkiti kapi Levi ngarra japuja wutiyati ngawa-yuwuni amintiya ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Awuta yingampa Pharisees kapi purru-wunu-waluwa (taught) arikutumunuwi ngini-ngatawa Moses ngirramini (law) api wuta pirripakuluwunyi ngini wutiyati purruwapa yinkiti kapi Levi ngarra tangarima, ngawa-yuwuni amintiya kapinaki arikutumunuwi kapi awuta Pharisees pirimi ngini wuta jajiruwi. Api awuta Pharisees purruwuriyi kapi ngawa-yuwuni ngarra-mamanta kiyi nanginta pirimi awuta, “Pilikama nuwa-alawura Jesus amintiya kapinaki jajiruwi arikutumunuwi wutiyati wujing-apa yinkiti?” Awarra pirimi awuta Pharisees kangi ngawa-yuwuni ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Api ngawa-yuwuni, karri yipitingaya (heard) awarra ngini awuta Pharisees pirripangiraga api ngarra yimi kangi wutawa, “Awarra tokuta karluwu awuriyi kapi awuta arikutumunuwi kapi yimpanguwi (healthy) ngini pupuwi yimata-kirimi awuta. Waya juwa ngarra awuriyi kapi awuta kapi purunjuwi. Api ngiyatuwu awanuwanga ngunuwuriyi awungarra kapi naki murrakupuni (to this earth) ngini ngimata-jiyarra ngawa-rringani ngini-ngatawa ngirramini kapi awuta tiwi kapi wurimajawu ngini wuta jajiruwi pili-ngini wuta wiyi kuwa pimatami awarra ngirramini. Ngiya karluwu ngunuwuriyi awungarra ngini ngimata-jiyarra ngawa-rringani ngini-ngatawa ngirramini kapi awuta arikutumunuwi kapi wuri-mamuliya pupuwi. Api ngawiyati ngawapa yinkiti ngiya amintiya kapinaki tiwi kapi wuta jajiruwi.” Awarra yimi ngawa-yuwuni kangi awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","2","Karri yati Sabbath Day (Saturday) ngawa-yuwuni Jesus amintiya ngarra-mamanta purruwuriyi kangi awinyirra jurra angi-wutawa Jews kiyi pirripawuriji yilaruwu. Awungaji wuta purruwunyayi yati tini ngini ngarra kirikayini (couldn't use his hand) pili ngarra yikara yimurrarijipa (folded over). Yilaruwu kapi awinyirra jurra yingampa Pharisees wiyarri purru-wujingi-muwani. Wuta karluwu pupuni purumuwu awarra ngawa-yuwuni api purru-wutimarti ngini ngarra yimata-wurrini ngini-wutawa ngirramini (law) awuta Jews pili-ngini wuta pimata-jiyarra awuta alawuruwi kapi wuta Jews ngini (about) ngarra. Api kiyi awuta Pharisees pirripakuluwunyi awarra ngawa-yuwuni pili wuta purru-wutimarti ngini pimata-kuluwunyi ngawa-yuwuni ngini ngarra wiyi waki arimi ngini pupuni yimata-kirimi awarra tini ngini-ngatawa yikara. Wuta awungani pirimi pili ngini-wutawa ngirramini (law) ngini wuta karluwu waki pimatami karri Sabbath Day. Api wuta pirimajirri ngini, “Ngini naki awarra Jesus ningani pupuni arikirimi naki tini ngarra yikara api ngawa wiyi ngarimi ngini ngarra jirti tini.” Awarra pirimajirri awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kiyi ngawa-yuwuni yimi kapi awarra tini ngini ngarra kirikayini, “Aya, tuwaripa yinkitayi pili-ngini kapinaki tayikuwapi arikutumunuwi pimata-kuluwunyi nginja,” yimi awarra ngawa-yuwuni. Api awarra tini yuwuriyi kiyi kuluwuta tayinti yimi. ");
INSERT INTO tiw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kiyi ngarra ngawa-yuwuni yimi kangi awuta Pharisees, “Awi, kamini ngini-ngawula ngirramini (law) ngini (about) anaki awinyirra wumunga Sabbath Day (Saturday)? Ngawa awungana ngamatama karri awinyirra wumunga? Arramukuta ngawa pupuni ngamata-kirimi (do good), arramukuta ngawa jirti ngamata-kirimi (do wrong)? Nuwatuwu awungana? Amintiya arramukuta ngawa pupuwi ngamata-kirimi awuta tiwi kapi wuta purunjuwi pili-ngini wuta wiyi yimpanguwi wurima. Arramukuta ngawa pajuwani ngamata-kirimi awuta. Awungana nuwatuwu?” yimi ngawa-yuwuni kapi awuta Pharisees. Api karri ngarra yipangiraga awarra api awuta Pharisees karri-kamini nimarra pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kiyi ngarra ngawa-yuwuni yipakuluwunyi awuta Pharisees api angatawa yiminga jurrumumi jiyimi (became angry) amintiya ngarra arliranga yimi kangi awuta pili wuta arnuka putuputuwu pirripakirayi awarra tini ngini ngarra kirikayini amintiya karluwu purru-wutimarti ngini ngarra pupuni yimata-kirimi karri Sabbath Day (Saturday) awarra tini ngini ngarra kirikayini. Kiyi ngarra yimi kapi awarra tini ngini ngarra kirikayini, “Aya tayakurupa (hold out) ngini-nginjila yikara,” yimi ngawa-yuwuni. Kiyi awarra tini yipakurupa ngini-ngatawa yikara api awungarri ngini-ngatawa yikara pupuni yima. ");
INSERT INTO tiw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kiyi awuta Pharisees kapi purru-wujingi-muwani awungarruwu kapi awinyirra jurra, karri wuta pirripakuluwunyi ngawa-yuwuni ngini pupuni yikirimi awarra tini api angi-wutawa yiminga jurrumumi jiyimi (became angry) kangi ngawa-yuwuni. Kiyi yingampa awuta Pharisees purrupumwari awinyirra jurra kiyi purruwuriyi kapi wuta-mamanta kapi wuta pirripapunya-mini awarra alawura Herod. Karri awuta Pharisees papi pirimi awungarruwu kapi wuta-mamanta purumuwu api wuta purruwuntiyarra awuta wuta-mamanta ngini ngawa-yuwuni pupuni yikirimi awarra tini karri Sabbath Day api kiyi awuta Pharisees amintiya wuta-mamanta nimarra pirimajirri, “Awungana ngamatama pili ngawa ngawutimarti ngini pajuwani ngamata-kirimi awarra nayi Jesus?” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ninkiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta pirripapirraya kapi awarra lake Galilee. Kiyi tayikuwapi arikutumunuwi kapi wuta tangarima pirimi kapi awarra murrakupuni Galilee api wuta pirripapunya ngawa-yuwuni amintiya ngarra-mamanta api mimpa pirimi awungarruwu kapi awarra lake. Kiyi wutatuwu yingampa arikutumunuwi purruwuriyi kapi ngawa-yuwuni kapi awarra lake pili wuta piri-pitingaya (heard) ngini ngarra yingarti mirrikili (miracle) yikirimi awungaji. Yingampa awuta arikutumunuwi japuja pirimi awungarruwu kapi awarra arikulani murrakupuni Judea kiyi yingampa japuja pirimi kapi Jerusalem amintiya yingampa japuja pirimi kapi awarra murrakupuni Idumea. Kiyi yingampa japuja pirimi kapi awarra murrakupuni ngini maringarruwu kapi awinyirra makatinga Jordan amintiya yingampa japuja pirimi kapi awarra yirrara murrakupuni Tyre amintiya Sidon. Awuta tayikuwapi tiwi purruwuriyi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","12","Kiyi awarra ngawa-yuwuni pupuwi yikirimi tayikuwapi arikutumunuwi kapi wuta purunjuwi. Awuta arikutumunuwi mimpa pirimi kapi ngawa-yuwuni pili wuta purru-wutimarti ngini pimata-mukuri ngini-wutawa yikara kangatawa purnikapa. Amintiya nimarra pirimi kangi wutalamiya, “Ngini ngawa ngapamukuri ngini-ngawula yikara kapi ngarra purnikapa api arrami ngawa wiyi papurajuwi ngarima,” pirimi. Wutatuwu yingampa kapi maputirruwi pirripalamiya kapi wuta purnikapa api karri pirripakuluwunyi ngawa-yuwuni api purru-wunyaw-amiya kangi yakuluwuni yinkitayi kapi ngawa-yuwuni malapwara api awuta maputirruwi kuwayi pirimi kapi ngawa-yuwuni, pirimi ngini, “Awarra ngatawa ngini ngarra japuja kuriyuwu (God) api ngarra awarra ngarra-mirani nginja,” pirimi awuta maputirruwi. Api ngarratuwu ngawa-yuwuni tulimiya (straight) yuwuntiyarra awuta maputirruwi, yimi ngini, “Ngajiti ngimpaja-jiyarra kapinaki tayikuwapi ngini ngiya awarra ngatawa ngini awarra ngini ngarra japuja kuriyuwu api ngarra-mirani ngiya,” yimi ngawa-yuwuni kangi awuta maputirruwi. Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Nyirra-marruripa kapala pili waya tayikuwapi mimpa wurimi kangi ngiya api ngiya wiyi ngipalamiya kangi awinyirra kapala api waya awungaji nimarra ngirimi kapi awuta tayikuwapi arikutumunuwi,” yimi ngawa-yuwuni kangi ngarra-mamanta. Api kiyi ngarra-mamanta wuta piniri-marruriyi awinyirra kapala api ngawa-yuwuni yipalamiya kangi awinyirra kapala kiyi yimuwu. Wutatuwu awuta arikutumunuwi purumuwu kangi yakuluwuni. Kiyi ngawa-yuwuni yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","15","Kiyi ngawa-yuwuni Jesus amintiya tayikuwapi ngarra-mamanta purruwuriyi kapi jupunyini (hill). Ngawa-yuwuni pakinya yipapurti kapi awarra jupunyini kiyi jingawu yimi kangi awuta ngarra-mamanta api ngarra yuwunga (picked) awuta wamurrara yuwurrara (12) ngarra-mamanta kapi ngarra yimamula (called) awuta apostles. Ngini-ngatawa meaning awarra yintanga apostles api awuta wawurruwi amintiya ngawa-yuwuni wutiyati waki pirimani. Api yuwuntiyarra awuta, “Awi, ngiya wiyi ngipangirri (send) nuwa ngini ngumpunt-iyarra arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Amintiya ngiya wiyi ngipakirayi nuwa power ngini nuwa wiyi pupuwi ngimpiri-kirimi awuta arikutumunuwi kapi wuta purunjuwi amintiya ngini nuwa awanuwanga wiyi papi ngimpiniri-mamiyi maputirruwi kapi wupalamiya kangi arikutumunuwi wuta purnikapa.” Awarra yimi ngawa-yuwuni kangi awuta wamurrara yuwurrara (12) ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Awuta wamurrara yuwurrara (12) ngarra-mamanta kapi ngawa-yuwuni yuwunga api ngarra yati Simon. Api ngawa-yuwuni yipakirayi awarra Simon nyoni yintanga Peter. Kiyi yingampa ngawa-yuwuni ngarra-mamanta api James amintiya John. Api awarra James amintiya awarra John api wuta-rringani ngarra yintanga Zebedee. Api wuta awuta yuwurrara, James amintiya John api ngawa-yuwuni yipakirayi awuta nyoni yintanga, Boanerges. Awarra yintanga Boanerges mean arimi ngini wuta yimpaja angi-wutawa yiminga jurrumumi jiyimani (used to become angry) nginingaji pumurali jingawu ampirimi. Kiyi yingampa ngawa-yuwuni ngarra-mamanta api Andrew, kiyi Philip, kiyi Bartholomew, kiyi Matthew, kiyi Thomas, kiyi Thaddaeus. Kiyi naki nyoni ngawa-yuwuni ngarra-mantani api awarra James ngini ngarra-rringani Alphaeus. Kiyi nyoni Simon. Api wuta pirimamula (called) awarra Simon nyoni yintanga Patriot pili awarra Simon amintiya ngarra-mamanta wuta jirti purumuwani awuta arikutumunuwi kapi wuta Romans amintiya jirti ngirramini pirripakiray-ani awuta. Kiyi naki nyoni ngarra-mantani ngawa-yuwuni api Judas Iscariot. Ngarra awarra wiyi (later on) traitor yimi kapi ngawa-yuwuni. Api awuta wamurrara yuwurrara wawurruwi api wuta awuta ngawa-yuwuni yimamula (called) awuta apostles. ");
INSERT INTO tiw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ninkiyi awarra ngawa-yuwuni Jesus yipapirraya kapi awarra lake Galilee api awungarruwu tayikuwapi arikutumunuwi purruwuriyi kangatawa api ngarra yuwuntiyarra awuta ngawa-rringani ngini-ngatawa ngirramini. Api awuta tayikuwapi mimpa pirimi kangatawa api ngarra yipalamiya kangi kapala kiyi yimuwu kiyi awungaji nimarra yimi kangi awuta arikutumunuwi. Awuta arikutumunuwi purumuwu kapi yakuluwuni. ");
INSERT INTO tiw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kiyi ngarra yuwuntiyarra awuta tiwi yingarti ngirramini (stories). Karri ngarra yuwuntiyarra awuta tiwi awarra yingarti ngirramini api ngarra arnuka yuwuntiyarra awuta ngini-ngatawa meaning awarra ngirramini pili ngarra yuwutimarti awuta arikutumunuwi ngini wutalamiya pimata-pungintayi (think about) awarra ngirramini amintiya ngini-ngatawa meaning. ");
INSERT INTO tiw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kiyi ngawa-yuwuni yuwuntiyarra awuta arikutumunuwi naki ngirramini (story) ngini yati tini ngarra yuwunyawu yingarti wheat kurukura (seeds) kapi yakuluwuni ngini awarra yingarti wheat kurukura yimata-kulurumi api kiyi ngini yimatama yingarti wheat plant api kiyi yimata-kirimi yingarti kurukura. Api ngarra ngawa-yuwuni yimi ngini, “Awi, yati tini yuwuriyi kapi ngini-ngatawa garden api ngarra yuwunyawu yingarti wheat kurukura kapi yakuluwuni. ");
INSERT INTO tiw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yingampa (some) awarra kurukura, karri awarra tini yuwunyawu awarra kurukura kapi yakuluwuni api awarra kurukura yipakupuraji kapi kirijinga jarrumoka, kiyi tokampuwi punuwuriyi kiyi purruwapa awarra kurukura. ");
INSERT INTO tiw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Api yingampa (other) kurukura, karri awarra tini yuwunyawu awarra kurukura kapi yakuluwuni api awarra kurukura yipakupuraji kapi yarti-jirti. Api kapi awarra yakuluwuni kiyija parruwarti mura (on top) amintiya yingarti waranguwi yilaruwu. Kiyi awarra wheat yartipili yikulurumi api karluwu arikulani yimi amintiya ngini-ngatawa jikilijipa (root) awanuwanga karuwuni pili waya juwa kiyija parruwarti. Api karri warnarringa jipapurti kuriyuwu api awungarri awarra wheat plant pajuwani yimi pili ngini-ngatawa jikilijipa karuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Api yingampa (other) kurukura yipakupuraji kapi awinyirra wupunga angi murrupun-awurti (thorns) api awarra wheat kurukura yikulurumi wutiyati awinyirra wupunga angi murrupun-awurti. Api awinyirra wupunga angi murrupun-awurti nyirra pakinya arikulanga jiyima api awarra wheat plant waya juwa kiyija yikulurumi pili awinyirra wupunga angi murrupun-awurti api jipujirra awarra wheat plant. Api awarra wheat plant karluwu yikirimi kurukura pili ngarra awarra wheat plant karluwu arikulani yima. ");
INSERT INTO tiw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Api yingampa (other) kurukura yipakupuraji kapi yakuluwuni ngini yarti-puranji api yingarti kurukura pupuni yikulurumi. Karri awarra wheat plant arikulani yima api yikirimi yingarti kurukura.” Awarra ngirramini (story) ngawa-yuwuni yuwuntiyarra awuta tayikuwapi arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kiyi ngawa-yuwuni yimi ngini, “Ngini nuwa warntirrana ngimpitimarti ngini nginti-mata-majawu (understand) awarra yingarti ngirramini (story) ngini ngiya nguwutiyarra nuwa api pupuni nyirra-pitingaya (listen well) amintiya warntirrana nyirra-pungintayi (think about) awarra ngirramini,” yimi ngawa-yuwuni kangi awuta tayikuwapi arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kiyi ngawa-yuwuni amintiya ngarra-mamanta, awuta wamurrara yuwurrara (12) amintiya awuta yingampa ngarra-mamanta, karri wuta wangatamiya purumuwu api awuta ngarra-mamanta nanginta pirimi ngawa-yuwuni ngini (about) awarra ngirramini (story), pirimi ngini, “Manya, tajiyarra ngawa ngini (about) awarra ngirramini ngini nginja juwutiyarra ngawa ngini (about) awarra tini ngini yuwunyawu wheat kurukura kapi yakuluwuni. Api kamini awarra ngirramini mean arimi pili karri nginja juwutiyarra ngawa awarra ngirramini api nginja karluwu juwutiyarra ngawa ngini-ngatawa meaning awarra ngirramini,” pirimi ngarra-mamanta kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kiyi ngawa-yuwuni yimi ngini, “Arnapa. Nuwa kapi kuwa ngimpirimi kangilawa api ngawa-rringani ngarra amanu-wani (helps) nuwa ngini ngimpiri-majawu (understand) awarra ngirramini ngini ngarra wiyi alawura arimi kapi nuwa tayikuwapi kapi kuwa ngimpirimi kangilawa. Wutatuwu awuta arikutumunuwi kapi karluwu wutimarti ngini kuwa pimatami kangilawa api karri ngiya nguwuntiyarra awuta awarra ngirramini ngini (about) ngawa-rringani api ngarra wiyi ngawa-rringani karluwu awunu-wani (won't help) awuta ngini pimata-majawu ngini-ngilawa ngirramini amintiya ngiya karluwu nguwuntiyarra awuta ngini kamini awarra ngirramini mean arimi,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kiyi ngawa-yuwuni yimi ngini, “Awuta arikutumunuwi kapi karluwu kuwa wurimi kangilawa api wuta yimpaja wuri-pitingaya (hear) ngini-ngilawa ngirramini api wuta karluwu wutimarti ngini pimata-majawu (understand) awarra ngirramini. Arramukuta wuta arnuka wutimarti ngini pimata-majawu awarra ngirramini pili wuta karluwu wutimarti ngini pimata-punya ngawa-rringani angatawa jarrumoka. Amintiya arramukuta wuta arnuka wutimarti ngawa-rringani ngini putuputuwu yimata-kirayi (forgive) awuta awarra jirti ngini pirikirim-ani (the wrong they've done),” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kiyi ngarra yimi kangi wutawa, “Nuwa kapi ngiya-mamanta nginti-mata-majawu (should know) ngini awarra ngirramini mean arimi, awarra ngirramini ngini awarra tini ngini yuwunyawu kurukura kapi yakuluwuni. Api karri ngiya wiyi nguwutiyarra nuwa nyoni ngirramini (story) api ngiya wiyi awanuwanga karluwu nguwutiyarra nuwa ngini-ngatawa meaning api nuwa wiyi arrami awanuwanga karluwu ngimpiri-majawu ngini-ngatawa meaning awarra nyoni ngirramini,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kiyi ngawa-yuwuni yimi kangi wutawa, “Awarra nayi ngirramini (story) api ngini-ngatawa meaning ngini awarra kurukura ngini awarra tini yuwunyawu kapi yakuluwuni api awarra kurukura nginingaji ngawa-rringani ngini-ngatawa ngirramini. Amintiya awarra tini ngini yuwunyawu awarra kurukura api ngarra awarra nginingaji awuta tiwi kapi wuntiyarra arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yingampa arikutumunuwi, karri wuta wuri-pitingaya (hear) ngawa-rringani ngini-ngatawa ngirramini api wuta karluwu warntirrana wuri-pitingaya awarra ngirramini api wuta karluwu wurimajawu (don't understand) awarra. Kiyi awarra maputiti yartipili awunu-wuriyi kapi awuta arikutumunuwi kiyi ngarra arikirimi wuta ngini pimata-ngiliparra awarra ngirramini ngini ngawa-rringani. Awarra maputiti api ngarra nginingaji awuta tokampuwi kapi yartipili punuwuriyi kapi awinyirra kirijinga jarrumoka kapi awarra kurukura yipakupuraji awungaji kiyi purruwapa awarra kurukura. Amintiya awuta arikutumunuwi kapi wuta karluwu wurimajawu ngawa-rringani ngini-ngatawa ngirramini api wuta nginingaji awinyirra kirijinga jarrumoka kapi awuta tokampuwi purruwapa awarra kurukura pili awarra maputiti yartipili arikirimi awuta ngini wupangiliparra awarra ngirramini ngini-ngatawa ngawa-rringani ngini wuta piri-pitingaya (heard),” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Kiyi ngawa-yuwuni yimi ngini, “Wutatuwu yingampa (other) arikutumunuwi, karri wuta wuri-pitingaya ngawa-rringani ngini-ngatawa ngirramini api awungarri wuta kukunari wurimi api wuta yartipili kuwa wurimi ngawa-rringani ngini-ngatawa ngirramini. Api pakinya awuta arikutumunuwi nginingaji awuta tiwi kapi warntirrana wupapunya ngawa-rringani angatawa jarrumoka api wuta karluwu warntirrana wupapunya ngawa-rringani angatawa jarrumoka. Karri yingampa arikutumunuwi kapi jajiruwi wupakirayi awuta arikutumunuwi jirti ngirramini (trouble) pili awuta arikutumunuwi kuwa wurimi ngawa-rringani ngini-ngatawa ngirramini api awungarri awuta arikutumunuwi wupumwari ngawa-rringani angatawa jarrumoka. Awuta arikutumunuwi kapi pakinya kuwa wurimi ngawa-rringani ngini-ngatawa ngirramini kiyi yartipili wupumwari angatawa jarrumoka api wuta nginingaji awarra yakuluwuni ngini warangiyanga awungarruwu kapi awarra wheat waya juwa kiyija yikulurumi kiyi pajuwani yimi karri warnarringa jipapurti kuriyuwu. Wuta nginingaji awarra yakuluwuni ngini warangiyanga pili awarra ngirramini ngini-ngatawa ngawa-rringani karluwu yinukuni arimuwu yilaruwu kangi awuta arikutumunuwi wuta punyipunyi api kiyi awuta arikutumunuwi yartipili wupumwari ngawa-rringani angatawa jarrumoka,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Kiyi ngawa-yuwuni yimi ngini, “Wutatuwu yingampa (other) arikutumunuwi api karri wuta wuri-pitingaya (hear) ngawa-rringani ngini-ngatawa ngirramini api wuta awanuwanga yartipili kuwa wurimi awarra ngirramini. Api wiyi parlinginari (later) wuta worry wurimi kuta kamini amintiya wuta wutimarti yingarti kunawuni amintiya arramu-kaminawuti api karlu-nara wuru-pungintayi (don't much think about) ngawa-rringani amintiya ngini-ngatawa ngirramini. Wuta waya juwa wuru-pungintayi awarra kunawuni amintiya arramu-kaminawuti. Awuta arikutumunuwi nginingaji awarra yakuluwuni kapi awinyirra wupunga angi murrupun-awurti amintiya awarra wheat plant wutiyati purukulurumi api awarra wheat plant arnuka pupuni yikulurumi amintiya arnuka yingarti kurukura yikirimi pili awinyirra wupunga angi murrupun-awurti jipujirra awarra plant. Api awuta arikutumunuwi nginingaji awarra yakuluwuni pili wuta worry wurimi kuta kamini amintiya yimpaja wuru-pungintayi ngini-wutawa kunawuni amintiya awarra arramu-kaminawuti api waya juwa kiyija wuru-pungintayi (think about) ngawa-rringani ngini-ngatawa ngirramini amintiya karluwu waki wurimi ngini (for) awarra ngawa-rringani,” yimi ngawa-yuwuni kangi wuta-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kiyi ngawa-yuwuni yimi ngini, “Amintiya wutatuwu yingampa arikutumunuwi api karri wuta wuri-pitingaya (hear) ngawa-rringani ngini-ngatawa ngirramini api wuta warntirrana kuwa wurimi awarra ngirramini amintiya yingarti waki wurimi ngini (for) ngawa-rringani. Awuta tiwi nginingaji awarra yakuluwuni ngini yarti-puranji amintiya awarra ngirramini ngini wuta wuri-pitingaya api nginingaji awarra kurukura ngini yipakupuraji kapi awarra yakuluwuni ngini yarti-puranji. Api awuta arikutumunuwi karri wuta wuri-pitingaya ngawa-rringani ngini-ngatawa ngirramini api wuta warntirrana wuru-pungintayi (think about) awarra ngirramini amintiya awarra ngirramini api kiyi wuta yingarti waki wurimi ngini (for) ngawa-rringani.” Ngawa-yuwuni awarra yuwuntiyarra ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Natinga wumunga (one day) ngawa-yuwuni Jesus yimuwu yinkitayi kapi awarra lake Galilee api awungarruwu nimarra yimi kapi tayikuwapi arikutumunuwi. Kiyi karri waya yinkitayi yartijanga ngarra yipapaya ngini nimarra yimi kangi wuta. Kiyi kuwayi yimi kapi ngarra-mamanta, “Awi,” yimi. “Waya ngawurniyi maringarruwu,” yimi. ");
INSERT INTO tiw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kiyi ngawa-yuwuni amintiya ngarra-mamanta purrupumwari awuta tayikuwapi arikutumunuwi api pirripalamiya kangi awinyirra kapala. Wutatuwu yingampa (some) awuta tiwi pirripalamiya kangi nyonga kapala. ");
INSERT INTO tiw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ngawa-yuwuni amintiya ngarra-mamanta api karri wuta waya purruwuja api awungarri wunijakama amintiya wingama api kukuni yini-pawuriji yilaruwu kangi kapala. Waya yinkitayi jipungarti awinyirra kapala. ");
INSERT INTO tiw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngarra awungarri ngawa-yuwuni yuwujingi-majirripani kapi awinyirra kapala amintiya ngarra pungintaga kangi poluma (pillow). Kiyi awuta ngarra-mamanta jingawu pirimi kangatawa, “Aya, yuwuni, tangipari. Kutupi tami pili wingama amintiya wunijakama. Ngunta-wani ngawa pili ngawa arrami wiyi ngapungarti,” pirimi ngarra-mamanta kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kiyi ngawa-yuwuni yipangipari kiyi kutupi yimi kiyi nimarra yimi kapi wunijaka api “Tawunjarli,” yimi api awinyirra wunijaka juwunjarli (stopped). Kiyi yimi kapi winga, “Tawunjarli,” yimi api awinyirra wingama kiyija jiyima. ");
INSERT INTO tiw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kiyi ngarra nanginta yimi ngarra-mamanta, “Pilikama nuwa ngintiri-makirri? Nuwa karluwu kuwa ngintirimi ngini ngiya ngimata-mangi nuw-ana?” Awarra ngawa-yuwuni yimi kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Api ngarra-mamanta pirimakirri kiyi nimarra pirimajirri ngini, “Awarra nginaki ngawa-mantani karluwu nginingaji ngawa. Yita ngarra warntirrana ngatawa pili karri ngarra nimarra yipangiraga api awinyirra wunijaka kuwa jiyimi kangatawa, awanuwanga awinyirra winga kiyija jiyima,” pirimajirri awuta ngawa-yuwuni ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","6","Karri ngawa-yuwuni Jesus yikirimi awinyirra wingama ngini kiyija jiyima kapi awarra lake api awungarri ngarra amintiya ngarra-mamanta purruwuja-la kapi maringarruwu kapi awarra lake. Kiyi wuta papi pirimi kapi awarra murrakupuni Decapolis kapi awuta arikutumunuwi japuja pirimi kapi wuta yintanga Gerasenes. Awungarruwu kapi awarra murrakupuni yati tini yimuwu ngini maputiti yipalamiya kangi ngarra purnikapa. Awungaji kapi awarra murrakupuni api kapi jupunyini (hills) yingarti cave. Yilaruwu kapi awarra cave wuta pirripalam-ani ngini-wutawa purnikapa awuta arikutumunuwi kapi wuta waya pajuwani pirimi. Api awarra tini japuja yimi ngarra wangatamiya kapi awarra cave. Ngarra awarra yuwurtingirraga (mad) api karri yirrimanuwuni amintiya karri japinamini ngarra kularlaga yimani awungarruwu kapi awarra jupunyini (hill) amintiya kapi awarra yingarti cave. Ngarra wawurruwari kularlaga yimani amintiya ngarra kuwayi yimani amintiya yuwunga-mini waranguwi api yuwawurrin-ani ngatamiya. Yingampa arikutumunuwi purruwunga-mini arlipurringa kiyi pirrari-kimirna-mini (tried to tie up) awarra tini ngarra kurumuta amintiya ngarra yirrikarla api ngarra yuwawurrin-ani (broke) awinyirra arlipurringa pili ngarra yikuturumi (strong). Amintiya awuta arikutumunuwi awanuwanga purruwunga-mini chain ngini arikulani kiyi pirrari-kimirna-mini (tried to tie up) ngarra api awanuwanga ngarra yuwawurrin-ani awarra chain, pili ngarra warntirrana yikuturumi (strong). Karri-kuwani ngarra yikuturumi nginingaji awarra tini api wuta karluwu pirrija-kirimi (couldn't make) ngarra ngini yimata-wunjarli (stop) pili awarra maputiti ngini yipalamiya kangi ngarra purnikapa api ngarra yikirimi awarra tini ngini yikuturumi. Kiyi awarra tini yipakuluwunyi ngawa-yuwuni ngini kutupi yinirimi kapi kapala. Ngarra karrampi yipakuluwunyi ngawa-yuwuni api kalikali yimi kangatawa, kiyi yuwunyaw-amiya kangi yakuluwuni yinkitayi kapi ngawa-yuwuni malapwara. ");
INSERT INTO tiw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Api ngawa-yuwuni nimarra yimi kapi awarra maputiti ngini yipalamiya kangi awarra tini purnikapa api yimi ngini, “Aya, maputiti, papi tamuwa (come out).” Api ngarratuwu awarra maputiti makirrana kuwayi yimi kangi ngawa-yuwuni, “Aya, Jesus, ngiya ngirimajawu ngini nginja-rringani awarra ngatawa ngini ngarra japuja kuriyuwu (God). Tajiyarra ngiya ngini nginja arnuka jimata-pirni ngiya. Ngajiti kunyani nimpajami pili nginja-rringani ngini kuriyuwu wiyi ari-pitingaya (hear) awarra ngirramini ngini nginja nimpangiraga,” yimi awarra maputiti kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kiyi ngawa-yuwuni nimarra yimi kapi awarra maputiti ngini yipalamiya kangi awarra tini ngarra purnikapa api nanginta yimi awarra, “Nginja awungana yintanga?” Api ngarratuwu awarra maputiti yimi ngini, “Karluwu yati maputiti waya yipalamiya kangi naki tini ngarra purnikapa. Yita ngawa tayikuwapi maputirruwi waya nginti-palamiya kangi ngarra purnikapa api ngawa yintanga Legion,” yimi awarra maputiti. Awarra yintanga Legion api mean arimi tayikuwapi. ");
INSERT INTO tiw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","11","Awuta maputirruwi pirimajawu ngini ngawa-yuwuni wiyi papi awuniri-mamiyi awuta kapi awarra tini ngarra purnikapa api awuta maputirruwi pirimi kangatawa, “Karri nginja wiyi papi nimpiri-mamiyi ngawa kapi awarra naki tini ngarra purnikapa api ngajiti nimpaja-ngirri (send) ngawa karrampi,” pirimi. Kiyi awuta maputirruwi pirripakuluwunyi yingarti pikipikuwi kapi jupunyini (hill). Awuta pikipikuwi purru-wujing-apukani yinkiti. ");
INSERT INTO tiw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","13","Api kiyi awuta maputirruwi pirimi kangi ngawa-yuwuni, “Aya, ngawa ngawutimarti nginja ngini jimata-ngirri (send) ngawa kapi awuta pikipikuwi api ngawa wiyi ngapawuriji yilaruwu kapi wuta purnikapa.” Api ngawa-yuwuni yimi ngini, “Manya awarra. Nyirru-wariyi,” yimi ngawa-yuwuni kapi awuta maputirruwi. Kiyi awuta maputirruwi papi pinirimi (came out) kapi awarra tini ngarra purnikapa api purruwuriyi kapi awuta pikipikuwi, kiyi pirripawuriji yilaruwu kangi wuta purnikapa. Kiyi karri awuta maputirruwi pirripawuriji yilaruwu kangi awuta pikipikuwi wuta purnikapa api awungarri awuta pikipikuwi kalikali pirimi api purrupumwari awarra jupunyini kiyi pirripapirraya kapi awarra lake kiyi kiyija mwarliki pirimi api purrupungarti (sank) kapi awarra lake. Api awuta tayikuwapi pikipikuwi pajuwani pirimi. Awuta pikipikuwi wuta tayikuwapi, nginingaji 2000. ");
INSERT INTO tiw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kiyi awuta arikutumunuwi kapi pirripamangi awuta pikipikuwi api karri pirripakuluwunyi awuta pikipikuwi purrupungarti kapi awarra lake api wuta kalikali pirimi kapi awarra town ngini yinkitayi kapi awarra murrakupuni (place) amintiya awanuwanga purruwuriyi kapi warta awungarruwu kapi yingampa arikutumunuwi waki purru-wujingi-mani kapi ngini-wutawa garden. Awungarruwu wuta purru-wuntiyarra awuta arikutumunuwi ngini ngawa-yuwuni yipangirri (sent) awuta maputirruwi yilaruwu kapi awuta pikipikuwi wuta purnikapa amintiya ngini awuta pikipikuwi kalikali pirimi kiyi purrupungarti kapi lake. Kiyi awuta tayikuwapi arikutumunuwi kapi wuta japuja pirimi kapi awarra town amintiya kapi warta amintiya awuta kapi pirripamangi awuta pikipikuwi api purruwuriyi awungarruwu kapi pikipikuwi purrupungarti kapi lake. ");
INSERT INTO tiw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Karri awuta arikutumunuwi papi pirimi kapi awarra murrakupuni (place) api purruwunyayi ngawa-yuwuni amintiya ngarra-mamanta wuturiyi awarra tini ngini pakinya awuta maputirruwi pirripalamiya kapi ngarra purnikapa. Api karri wuta pirripakuluwunyi awarra tini ngini ngarra waya karluwu yuwurtingirraga (mad) amintiya ngini ngarra kuluji yikuripiya (wore clothes) api wuta pirimakirri. ");
INSERT INTO tiw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kiyi awuta arikutumunuwi kapi wuta pirripakuluwunyi ngawa-yuwuni ngini yikirimi awarra mirrikili (miracle) api wuta pirimi kangi awuta yingampa arikutumunuwi, “Awarra naki Jesus api ngarra papi yiniri-mamiyi awuta maputirruwi kapi naki tini ngarra purnikapa. Kiyi ngarra yipangirri (sent) awuta maputirruwi yilaruwu kapi awuta tayikuwapi pikipikuwi wuta purnikapa. Api karri awuta maputirruwi pirripawuriji yilaruwu kapi awuta pikipikuwi awungarruwu kuriyuwu kapi awarra jupunyini (hill) api awuta pikipikuwi pirripapirraya kapi yakuluwuni api kalikali pirimi kapi awarra lake kiyi kiyija mwarliki pirimi api purrupungarti (sank) awungarruwu,” pirimi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Api awuta tayikuwapi arikutumunuwi api kiyija pirimakirri ngawa-yuwuni api pirimi kangatawa, “Tuwariyi kapi nyoni murrakupuni,” pirimi. Kiyi ngawa-yuwuni amintiya ngarra-mamanta purrupumwari awarra murrakupuni kiyi pirripapirraya kapi awarra lake api purruwuriyi kapi angi-wutawa kapala. ");
INSERT INTO tiw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Karri ngawa-yuwuni waya yinkitayi yipawuriji yilaruwu kangi awinyirra kapala api awarra tini ngini pakinya awuta maputirruwi pirripalamiya kangi ngatawa purnikapa api yinuwuriyi kangi ngawa-yuwuni. Kiyi yimi kangatawa, “Aya, mantani, ngiya waya kukunari ngini nginja pupuni jiyikirimi ngiya api ngiya nguwutimarti ngini ngimata-punya nginja,” yimi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Api ngawa-yuwuni yimi ngini, “Karluwu. Tuwariyi kanginjila tangarima api tajiyarra nginja-ngirimipi ngini ngawa-rringani ngini kuriyuwu putuputuwu yipakirayi nginja api ngarra yipakirayi ngiya power ngini ngirikirimi nginja ngini pupuni jiyima. Awarra tajiyarra awuta,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kiyi awarra tini yuwuriyi kangatawa japuja kiyi yuwuntiyarra ngarra-ngirimipi ngini ngawa-yuwuni papi yiniri-mamiyi awuta maputirruwi kapi ngarra purnikapa. Amintiya ngarra kularlaga yimi kapi awarra murrakupuni Decapolis api awanuwanga yuwuntiyarra awuta arikutumunuwi ngini (about) ngawa-yuwuni. Api awuta tayikuwapi arikutumunuwi, karri wuta piri-pitingaya (heard) awarra ngirramini ngini ngarra yipangiraga api wuta pirimarlingiyi (got a surprise) api nanginta pirimajirri, “Naki ngirramini warntirran-ana (is this true)?” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Karri awarra tini yipumwari ngawa-yuwuni Jesus, awarra tini ngini ngarra pakinya awuta yingarti maputirruwi pirripalamiya kangi ngarra purnikapa api ngarra ngawa-yuwuni amintiya ngarra-mamanta pirripalamiya kangi kapala kiyi wuta purruwuriyi maringarruwu kapi awarra lake. Karri wuta papi pirimi awungarruwu tayikuwapi arikutumunuwi punuwuriyi kapi ngawa-yuwuni api mimpa pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kiyi yati tini ngini ngarra alawura kapi awinyirra jurra awungarruwu kapi awarra town api ngarra yuwuriyi kapi awarra ngawa-yuwuni awungarruwu kapi awarra lake. Ngarra awarra yintanga Jairus. Api karri ngarra papi yimi kapi ngarra ngawa-yuwuni tayinti yimi api yuwunyaw-amiya kapi yakuluwuni yinkitayi kapi ngawa-yuwuni ngarra malapwara. ");
INSERT INTO tiw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kiyi ngarra yimi kapi ngawa-yuwuni, “Aya, mantani, ngiya-miraninga angi aliyinga nyirra waya yinkitayi pajuwani ampirimi api ngiya nguwutimarti nginja ngini jimata-mukuri ngini-nginjila yikara kangi nyirra purnikapa ngini nyirra wiyi pupuka jimatama. Api muwurniyi kangilawa tangarima.” Awarra yimi awarra alawura kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Api kiyi ngawa-yuwuni yipapunya awarra alawura kapi ngarra japuja. Tayikuwapi arikutumunuwi pirripapunya ngawa-yuwuni awungarruwu kapi ngarra tangarima awarra alawura. Karri ngawa-yuwuni yuwuja api awuta tayikuwapi arikutumunuwi mimpa pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Awungarruwu kapi awarra town, natinga yimpalinya jiyimuwu api nyirra jana juwuni (had) amintiya majipani alala yinirimi (flowed from) kangi nyirra purnikapa. Nyirra juwuni awarra jana wamurrara yirrara pakitiringa (12 years). ");
INSERT INTO tiw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nyirra juwuriyani kapi tayikuwapi tokutuwi pili awarra jana api wuta karluwu pupuka pirikirim-ani awinyirra. Nyirra jipakirayani awuta tokutuwi yingarti kunawuni api nyirra waya karri-kamini kunawuni. Karri pakinya nyirra juwuni awarra jana kiyija api wiyi (later) nyirra arikulani jana juwuni. ");
INSERT INTO tiw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Kiyi yingampa tiwi purru-wutiyarra awinyirra yimpalinya ngini ngarra ngawa-yuwuni waya pupuwi yikirimi tayikuwapi tiwi kapi purunjuwi api nyirra jiyimi kangi nyitamiya, “Ngiya nguwuja kapi awarra Jesus kiyi ngipamukuri ngiya yikara kangi ngarra kuluji pili-ngini pupuka ngimatama,” jiyimi nyitamiya. Api nyirra jipapunya ngawa-yuwuni kiyi juwuriyi yintuwu kangatawa jukwartanga kiyi jipamukuri nyirra yikara kangi angatawa kuluji. ");
INSERT INTO tiw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Karri jipamukuri nyirra yikara kangi ngarra kuluji api waya awungarri awarra majipani yuwunjarli (stopped) api jiyimi kangi nyitamiya, “Yita ngiya waya pupuka ngirima,” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ngarra ngawa-yuwuni yartipili yimajawu ngini kiyija power waya yipumwari (had left) ngarra purnikapa api ngarra yuwunjarli kiyi yipakuluwunyi awuta tayikuwapi tiwi api yimi kangi wutawa, “Awi, mamanta, kuwani yipamukuri ngarra yikara kangiya kuluji?” yimi kangi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kiyi wutatuwu ngawa-yuwuni ngarra-mamanta pirimi kangatawa, “Pilikama awarra jipangiraga? Arramukuta kapinaki arikutumunuwi pirlamarri (by accident) pirripamukuri wuta yikara kanginjila kuluji pili wuta tayikuwapi mimpa pirimi kanginja,” pirimi ngawa-yuwuni ngarra-mamanta kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Api ngarra ngawa-yuwuni karluwu kuwa yimi awuta ngarra-mamanta pili yimajawu ngini awarra power waya yipumwari ngarra purnikapa api ngarra tuwanga yipakuluwunyi awuta arikutumunuwi. Ngarra yinukuni yipakuluwunyi awuta pili ngarra yuwutimarti ngini kuta kuwani yipamukuri ngarra yikara kangi ngarra kuluji. ");
INSERT INTO tiw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Awinyirra tinga nyirra jiyimajawu ngini ngawa-yuwuni waya pupuka yikirimi nyirra api nyirra pulingiya jiyimi pili jiyimakirri. Nyirra amparrimani juwarimi ngini ngawa-yuwuni amari-kirlimirri (would growl at) nyirra. Api kiyi nyirra juwunyaw-amiya kapi yakuluwuni yinkitayi kapi ngarra malapwara api jiyimi kangatawa, “Ngiya awinyirra angi ngirripamukuri ngiya yikara kanginjila kuluji pili ngiya jana ngurru-wuni. Api awarra jana waya yipumwari ngiya purnikapa.” Awarra jiyimi awinyirra tinga kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Api ngarra yimi ngini, “Mantanga, nginja pupuka jiyima pili nginja kuwa jiyimi ngini ngiya pupuka ngimata-kirimi nginja,” yimi ngawa-yuwuni kangi awinyirra tinga. Kiyi yimi kangi nyitawa, “Awarra jana ngini nginja juwuni (had) api waya yiloti yipumwari nginja purnikapa. Api ngajiti tuwanga worry nimpajami amintiya tuwariyi tangarima,” yimi ngawa-yuwuni kangi nyitawa. ");
INSERT INTO tiw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Karri ngawa-yuwuni nimarra yuwujingi-mani kapi awinyirra tinga api awungarri yingampa arikutumunuwi kapi waki pirimani ngini (for) awarra Jairus wuta papi pirimi awungarruwu. Kiyi wuta pirimi kapi awarra Jairus, “Nginja nguri pili nginja-miraninga waya pajuwani jiyimi api tajiyarra naki awarra Jesus ngini ngajiti awaju-wariyi kanginjila tangarima,” pirimi awuta arikutumunuwi kapi awarra Jairus. ");
INSERT INTO tiw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngarra ngawa-yuwuni karri ngarra yipitingaya (heard) awarra ngini awuta arikutumunuwi nimarra pirimi kapi awarra Jairus api ngarra yimi kangatawa, “Aya, mantani, ngajiti nimpaja-wanga amintiya ngajiti worry nimpajami. Waya juwa kuwa tami ngini ngiya wiyi yimpanga ngirikirimi nginja-miraninga,” yimi ngawa-yuwuni kangi awarra Jairus. ");
INSERT INTO tiw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kiyi ngawa-yuwuni yimi kapi awuta tayikuwapi tiwi kapi pirripapunya ngarra, “Nuwa arnapa awungarra nuwa tayikuwapi,” yimi. Kiyi nimarra yimi kapi awuta yuwurrajirrima ngarra-mamanta, Peter amintiya James kiyi John api yimi ngini, “Nginja Peter kiyi nginja James amintiya nginjuwani John api nuwa wangata nyirra-punya ngiya. Ngawa ngawuja kapi nginaki alawura ngarra tangarima,” yimi. Kiyi awuta yuwurrajirrima ngarra-mamanta pirripapunya ngawa-yuwuni amintiya awarra Jairus awungarruwu kangatawa tangarima. ");
INSERT INTO tiw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Karri wuta papi pirimi awungaji kapi awarra Jairus japuja api purruwunyayi tayikuwapi arikutumunuwi makirrana pirlikiti purru-wujingi-mani. ");
INSERT INTO tiw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kiyi ngawa-yuwuni amintiya awuta yuwurrajirrima ngarra-mamanta amintiya awarra Jairus pirripawuriji yilaruwu kapi awinyirra kurrampali api ngarra ngawa-yuwuni nimarra yimi kangi awuta kapi pirlikiti purru-wujingi-mani, yimi ngini, “Awi, mamanta, pilikama nuwa pirlikiti ngimpijingi-mi? Yita awinyirra aliyinga nyirra arnuka pajuwani jiyimi. Yita nyirra waya juwa ampijingi-majirripi,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Api awuta tiwi pokayini pirimi kangatawa pili wuta pirimajawu ngini awinyirra aliyinga waya pajuwani jiyimi. Kiyi ngawa-yuwuni yimi kangi awuta tiwi, “Nyirru-wariyi turruwuni,” yimi. Kiyi awuta tiwi purruwuriyi turruwuni. Kiyi ngawa-yuwuni yimarruriyi awarra Jairus amintiya ngarra-purnayinga amintiya awuta yuwurrajirrima ngarra-mamanta yilaruwu kapi awinyirra aliyinga juwujingi-milani. ");
INSERT INTO tiw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kiyi ngawa-yuwuni yuwunga awinyirra aliyinga nyirra yikara kiyi yimi kangi nyirra, “Aga, kirijinga, kutupi tami!” yimi ");
INSERT INTO tiw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","api waya awungarri awinyirra aliyinga tuwanga yimpanga jiyima kiyi kutupi jiyimi, jipangulimayi. Awarra Jairus amintiya ngarra-purnayinga api karri pirripakuluwunyi ngini awinyirra aliyinga kutupi jiyimi api wuta pirimarlingiyi (got a surprise). ");
INSERT INTO tiw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kiyi ngawa-yuwuni yuwuntiyarra awarra Jairus amintiya ngarra-purnayinga, “Ngajiti ngimpaja-jiyarra yingampa arikutumunuwi ngini ngiya ngirikirimi anaki aliyinga ngini tuwanga yimpanga jiyima,” yimi. Kiyi yimi ngini, “Tayakirayi awinyirra yinkiti,” yimi. Api kiyi wuta pirripakirayi awinyirra yinkiti. Kiyi ngawa-yuwuni amintiya ngarra-mamanta purrupumwari awinyirra kurrampali. ");
INSERT INTO tiw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ninkiyi, ngawa-yuwuni Jesus kuwayi yimi kapi awuta wamutirrara yirrara ngarra-mamanta, api yuwuntiyarra, yimi ngini, “Awi, nyirruwariyi nyuwuntajiyarra arikutumurnuwi ngini ngarra ngawa-rringani ngirramini. Amintiya nyirrakirimi papurajuwi awuta kapi puruwunjuwi. Yita ngiya wiyi ngirikirimi ngini nuwa ngintimataparirri mapurtirruwi kapi wupalamiya kapi wuta purnikapa arikutumurnuwi,” yimi. Ninkiyi, yimi ngini, “Wangatajirri nyirraami, yuwurrarajirri nyirrayangulimayi. ");
INSERT INTO tiw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Api karri nuwuriyi, api ngajiti yinkiti nimpajamarruriyi. Awunganuwanga ngajiti kuwinawini nimpajamarruriyi. Amintiya nuwa natinga ampirramuwu. Ngajiti nyonga manipurruwa nimpajamarruriyi. Amintiya ngajiti nimpajamarruriyi palaji. Api nuwa militamuni awurramuwu amintiya nyirramarruriyi purinjiti ngini ngintimatapirtaputiya.” Awarra ngawa-yuwuni yuwuntiyarra ngarra-mamanta kapi ngatawa yuwunini, karri yuwuntangirri awuta ngini purruwuntiyarra arikutumurnuwi ngini ngarra ngawa-rringani ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ninkiyi, yimi ngini, “Kuta ngini maka murrakupuni nuwuriyi, api awungarruwu nyirrayawurinji yilaruwu kapi natinga kurrampali kiyi nyirramuwu, api ngajiti awinyirra nimpajamori, waya juwa karri wiyi nupumori awarra murrakupuni. Ngajiti tayikuwanga jampaka nimpajawurinji,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ninkiyi, yimi ngini, “Karri nuwuriyi, kuta maka, api arikutumurnuwi kapi awungarruwu japuja wurikirimi api wiyi arrami wurimi ngini, ‘Pirri. Nyirruwariyi. Nuwa arnuka awungarra ngintimatamuwu. Ngawa arnuka ngintimarti ngini ngapirtangaya ngini nuwa nupangiraga.’ Awarra arrami wiyi wurimi yingompa. Api ngini awarra wurimi, api nyirrumori awarra murrakupuni. Api karri waya nuwuja, api nyirrajirri militamuni api nyirrayakinapagi ngini parruwarti wiyi apawurligi, pili wuta jajiruwi japuja arima awungarruwu, pili wuta karluwu wutimarti ngini pimatapirtangaya ngini nuwa nupangiraga ngini ngarra ngawa-rringani ngirramini. Api karri wiyi wupakurluwunyi nuwunyawu awarra parruwarti, api wuta wiyi wurimi kangi wutilamiya ngini, ‘Arramukuta ngatawa ngini kuriyuwu wiyi ngirramini ngini jirti apakirayi ngawa, pili ngawa arnuka ngintiripirtangaya ngini wuta pirripangiraga awuta kapinayi.’ Awarra wiyi wurimi wutilamiya awuta kapi piriparirri nuwa. Api karri waya nupakinapagi militamuni api nyirruwariyi nyoni murrakupuni. Arramukuta papurajuwi awungarruwu japuja arima,” yimi ngawa-yuwuni. “Api waya nyilipuwariyi,” yimi ngawa-yuwuni kapi awuta wamutirrara yirrara ngarra-mamanta karri yuwuntangirri awuta. ");
INSERT INTO tiw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kiyi ngawa-yuwuni Jesus karri yipapaya ngini yuwuntiyarra awuta wamurrara yuwurrara (12) ngarra-mamanta awarra waki ngini ngarra yuwutimarti ngini wuta pimata-kirimi (do) ngini (for) ngarra api yipangirri (sent) awuta kapi awarra yingarti murrakupuni. Kiyi wuta kularlaga pirimi kapi awarra yingarti murrakupuni kiyi purru-wuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini, pirimani ngini, “Awi, mamanta, nyirra-mwari awarra jirti ngini nuwa ngintiri-kirim-ani (the wrong you have done), kiyi nyirra-punya ngawa-rringani angatawa pupuka jarrumoka.” Awarra pirimi kangi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tayikuwapi arikutumunuwi kapi wuta maputirruwi pirripalamiya kangi wuta purnikapa api awuta ngawa-yuwuni ngarra-mamanta papi piniri-mamiyi awuta maputirruwi kapi ngini-wutawa purnikapa. Amintiya tayikuwapi arikutumunuwi kapi wuta purunjuwi api awuta ngawa-yuwuni ngarra-mamanta pirripamutiyi (poured) oil kapi wuta purnikapa api kiyi awuta tiwi pupuwi pirima. ");
INSERT INTO tiw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Tayikuwapi arikutumunuwi kapi wuta tangarima kapi yingarti murrakupuni api wuta nimarra pirimajirri ngini ngawa-yuwuni yingarti mirrikili (miracle) yikirimi amintiya ngini ngarra yuwuntiyarra arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Kiyi yingampa (other) arikutumunuwi piri-pitingaya (heard) ngini (about) ngawa-yuwuni api wuta pirimajirri ngini, “Kuwani arrami nayi awarra Jesus?” pirimi. Kiyi pirimi ngini, “Awarra John the Baptist ngini ngarra King Herod piripirni api arramukuta ngawa-rringani ngini kuriyuwu waya tuwanga yimpangini yikirimi awarra John the Baptist api ngarra awarra mirrikili arikirimi,” pirimi. Awarra pirripangiraga yingampa arikutumunuwi. Kiyi wutatuwu yingampa pirripangiraga ngini, “Awarra prophet Elijah ngini ngarra parlingarri yimuwu kapi naki murrakupuni (on this earth) api arramukuta ngawa-rringani waya yikirimi awarra ngini yini-pakupawurli (came back) api tuwanga yimpangini yimi api waya ningani ngarra arimamuliya awarra yintanga Jesus.” Awarra pirripangiraga awuta yingampa arikutumunuwi. Amintiya wutatuwu yingampa pirimi ngini, “Karluwu. Yita ngarra nyoni prophet awarra Jesus nginingaji awuta prophets kapi wuta purumuwu parlingarri pili ngarra awanuwanga awuntiyarra arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini.” Awarra pirimi awuta yingampa arikutumunuwi. Api awarra King Herod karri yipitingaya (heard) awarra ngirramini ngini awuta arikutumunuwi pirripangiraga ngini (about) ngawa-yuwuni api ngarra yimi kangatamiya, “Awarra John the Baptist ngini ngiya puniyarri (before) ngurru-wawurrini ngarra pungintaga api ngarra waya tuwanga yimpangini yima amintiya waya arimamuliya awarra yintanga Jesus.” Awarra pirlamarri (not knowing) yipangiraga awarra King Herod. ");
INSERT INTO tiw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Awarra King Herod yuwutimarti ngarra-marrikuluwuni Philip ngarra-purnayinga api ngarra yuwunga awinyirra. Nyirratuwu awinyirra yimpalinya nyirra yintanga Herodias. Awarra King Herod ngarra alawura kapi awarra murrakupuni Galilee. Kiyi ngarra awarra John the Baptist yuwuriyi kapi awarra King Herod, kiyi yimi ngini, “Pilikama nginja juwunga nginja-marrikuluwuni ngarra-purnayinga? Yita nginja waya juwawurrini (broke) awarra Moses ngini-ngatawa ngirramini (law),” yimi awarra John the Baptist kangi awarra King Herod. Karri awarra King Herod yipitingaya (heard) awarra ngirramini ngini John the Baptist yipangiraga api angatawa yiminga jurrumumi jiyimi (became angry) kiyi ngarra jingawu yimi kapi awuta wawurruwi kapi waki pirimani ngini (for) ngarra, yimi ngini, “Nyirra-marruriyi awarra naki John the Baptist kapi majatawi pili-ngini wuta pimata-mukuri ngarra yilaruwu kapi jail,” yimi awarra King Herod kapi awuta wawurruwi kapi waki pirimani ngini ngarra. Kiyi awuta wawurruwi pirimarruriyi awarra John the Baptist kapi awuta majatawi kiyi wuta pirripamukuri ngarra yilaruwu kapi jail. ");
INSERT INTO tiw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Kiyi nyirratuwu awinyirra Herodias jiyipungintayi (thought about) awarra ngirramini ngini awarra John the Baptist yipangiraga karri yikirlimirri (growled at) awarra King Herod pili ngarra yuwunga nyirra. Nyirra juwuni (had) awarra ngirramini kangi nyirra punyipunyi api nyirra juwutimarti awuta majatawi ngini pajuwani pimata-kirimi awarra John the Baptist api awarra King Herod, “Karluwu,” yimi pili ngarra kiyija yimakirri awarra John. Awarra King Herod yimajawu ngini ngarra pupuni tini awarra John the Baptist amintiya ngini ngarra warntirrana kuwa yimani awarra ngawa-rringani ngini kuriyuwu. Yingampini (sometimes) awarra King Herod yuwutimarti ngini yimata-pitingaya (listen to) awarra ngirramini ngini-ngatawa ngawa-rringani ngini John the Baptist yipangiraga api karri awarra King Herod yipitingaya awarra ngirramini ngini ngarra John the Baptist yipangiraga api ngarra worry yimi pili ngarra karluwu yimajawu (didn't understand) awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Karri awarra John the Baptist yimuwu kapi jail api awinyirra Herodias nanuwanga (still) juwuni (had) kangi nyirra punyipunyi awarra ngirramini ngini awarra John the Baptist yipangiraga kapi awarra Herod ngini (about) nyirra api jiyimi kangi nyitamiya ngini, “Kuta awungarri nguwunga (pay back) awarra nayi John the Baptist,” jiyimi. Api nyirra wiyi (later) juwunga (paid back) awarra John the Baptist karri awinyirra wumunga karri awarra King Herod parlingarri yimulungurrumi (on his birthday). Karri awinyirra wumunga awarra King Herod nanginta yimi tayikuwapi tiwi kapi wuta tangarima Galilee ngini pini-matu-wariyi kapi ngarra japuja. Yingampa awuta tiwi api wuta alawuruwi kapi kapmanuwi, wutatuwu yingampa wuta alawuruwi kapi soldiers amintiya wutatuwu yingampa alawuruwi awungarruwu kapi awarra murrakupuni Galilee. Awuta tayikuwapi alawuruwi purruwuriyi kapi Herod ngarra tangarima kiyi King Herod amintiya awuta alawuruwi wutiyati purruwapa yingarti yinkiti amintiya awanuwanga pirimangapa wine. ");
INSERT INTO tiw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kiyi awinyirra Herodias nyirra-mwaringa jipawuriji yilaruwu kapi nyirra-rringani amintiya ngarra-mamanta purru-wujing-apukani yinkiti kiyi nyirra yoyi jiyimi. Api karri wuta pirripakuluwunyi awinyirra ngini yoyi jiyimi api wuta kukunari pirimi. Api kiyi awarra King Herod kuwayi yimi kapi ngarra-miraninga, “Tuwaripa,” yimi. Api nyirra juwuriyi kapi nyirra-rringani kiyi ngarra yuwutiyarra nyirra, “Aga, ngimiraninga, nginja pupuni yoyi jiyimi api kuta kamini awarra ngini nginja nimpitimarti api ngiya wiyi awarra ngipakirayi nginja,” yimi kangi nyitawa. ");
INSERT INTO tiw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kiyi tuwanga yimi ngini, “Ngini nginja nimpitimarti yingarti kunawuni amintiya arramu-kaminawuti api ngiya wiyi awarra ngipakirayi nginja. Amintiya ngini nimpitimarti yingarti murrakupuni api ngiya wiyi ngipakirayi nginja awarra murrakupuni. Api kuta kamini awarra ngini nginja nimpitimarti api ngiya wiyi ngipakirayi nginja awarra. Ngiya karluwu kunyani ngirimi.” Awarra yimi awarra King Herod kangi awinyirra murrukupora ngarra-miraninga. Api nyirratuwu jiyimi ngini, “Arnapa pili ngiya nguwuja nanginta ngirimi ngiya-naringa,” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kiyi awinyirra murrukupora juwuriyi kapi nyirra-naringa Herodias kiyi jiyimi ngini, “Aga, nginari, ngiya-rringani yimi ngini ngarra wiyi apakirayi ngiya kuta kamini ngini ngiya nguwutimarti. Api nayi kamini ngiya nanginta ngirimi ngarra?” jiyimi awinyirra murrukupora kangi nyirra-naringa. Api nyirratuwu nyirra-naringa jiyimi ngini, “Nanginta tami nginja-rringani ngini ngarra yimata-wurrini awarra John the Baptist ngarra pungintaga kiyi ngini yimata-kirayi nginja awarra pungintaga,” jiyimi kangi nyirra-mwaringa. ");
INSERT INTO tiw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Api awinyirra murrukupora yartipili jipakupawurli kapi nyirra-rringani kiyi jiyimi kangatawa, “Ngiya nguwutimarti awarra John the Baptist ngarra pungintaga. Yartipili tajiyarra awuta majatawi ngini wuta wuwawurrini ngarra pungintaga kiyi wupalami awarra pungintaga kapi wurika (dish) amintiya ngini wuniri-marruriyi awarra pungintaga kangi ngiya,” jiyimi awinyirra murrukupora kapi nyirra-rringani. ");
INSERT INTO tiw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Karri awinyirra murrukupora awarra jipangiraga api nyirra-rringani awarra King Herod jirti yimi kangi ngarra ruwuti amintiya ngarra purnikapa pili ngarra karluwu yuwutimarti ngini pajuwani yimata-kirimi awarra John the Baptist. Api ngarra yuwutimarti ngini, ‘Karluwu,’ yimatami kangi ngarra-miraninga api arnuka awarra yipangiraga pili ngarra waya yuwutiyarra nyirra ngini, “Ngiya wiyi ngipakirayi nginja kuta kamini ngini nimpitimarti,” yimi. Amintiya ngarra karluwu yimata-mwari awarra ngirramini ngini ngarra yipangiraga kangi nyitawa pili ngarra-mamanta kapi wutiyati yinkiti purruwapa api wuta piri-pitingaya (heard) awarra ngirramini ngini ngarra yipangiraga. ");
INSERT INTO tiw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Api kiyi awarra King Herod yimi kangi yati tini ngini ngarra waki yimi ngini (for) ngarra, “Aya, tuwariyi kapi awarra John the Baptist kapi jail api tawurrini ngarra pungintaga kiyi tayalami awarra kapi wurika (dish) kiyi tamarruriyi awarra pungintaga kapi ngiya-miraninga,” yimi awarra King Herod. Kiyi awarra tini yuwuriyi awungarruwu kapi jail kiyi yuwawurrini awarra John the Baptist ngarra pungintaga. ");
INSERT INTO tiw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kiyi ngarra yipalami John ngarra pungintaga kangi wurika kiyi ngarra yimarruriyi awarra pungintaga kapi awinyirra murrukupora kiyi yipakirayi awinyirra awarra pungintaga. Nyirratuwu awinyirra murrukupora jiyimarruriyi awarra pungintaga kapi nyirra-naringa. ");
INSERT INTO tiw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kiyi yingampa arikutumunuwi purru-wuntiyarra awarra John the Baptist ngarra-mamanta, “Awi, awarra King Herod waya yuwawurrini nuwa-mantani John the Baptist ngarra pungintaga,” pirimi awuta arikutumunuwi. Api karri ngarra-mamanta piri-pitingaya (heard) awarra ngirramini ngini (about) awarra John the Baptist api wuta purruwuriyi kapi ngarra purnikapa yuwujingi-milani. Kiyi wuta pirimarruriyi awarra purnikapa kapi cave. Wuta purruwunga manipurruwa (material) api pirikimirna awinyirra manipurruwa kapi ngini-ngatawa purnikapa kiyi pirripalami awarra kapi cave. ");
INSERT INTO tiw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kiyi ngawa-yuwuni Jesus ngarra-mamanta karri wuta pirripapaya awarra waki ngini ngawa-yuwuni yuwuntiyarra awuta ngini pimata-kirimi (do) ngini (for) ngarra api wuta pirripakupawurli kapi ngawa-yuwuni. Api karri papi pirimi kangatawa api ngarra nanginta yimi awuta, “Marri?” Api wuta pirimi ngini, “Yita waya ngawa nguntu-wuntiyarra tayikuwapi arikutumunuwi ngawa-rringani ngini kuriyuwu ngini-ngatawa ngirramini amintiya ngawa pupuwi ngintiri-kirimi tayikuwapi arikutumunuwi kapi wuta purunjuwi,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kiyi tayikuwapi arikutumunuwi punuwuriyi kapi ngawa-yuwuni amintiya ngarra-mamanta api ngawa-yuwuni yuwuntiyarra awuta ngawa-rringani ngini-ngatawa ngirramini. Api karri awuta arikutumunuwi purrupumwari ngawa-yuwuni api wutatuwu yingampa punuwuriyi kangatawa. Kiyi karri awuta arikutumunuwi purrupumwari ngawa-yuwuni api wutatuwu yingampa arikutumunuwi punuwuriyi kangatawa. Api ngawa-yuwuni amintiya ngarra-mamanta wuta janawurti pirima amintiya wuta karluwu pirrijapa (couldn't eat) yinkiti pili awuta tayikuwapi arikutumunuwi punu-wuja-la (kept coming) kangi ngawa-yuwuni. Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Ngawurniyi awungarruwu kapi nyoni murrakupuni kapi ngawa wiyi wangatamiya ngarimuwu api awungarruwu ngawa wiyi kiyija ngarimajirripi,” yimi. ");
INSERT INTO tiw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kiyi ngawa-yuwuni amintiya ngarra-mamanta pirripapirraya kapi awarra lake kiyi pirripalamiya kangi kapala ngini pimatu-wariyi kapi awarra murrakupuni kapi karri-kuwapi japuja pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kiyi tayikuwapi arikutumunuwi kapi japuja awungarruwu kapi yingarti town api wuta pirripakuluwunyi ngawa-yuwuni amintiya ngarra-mamanta ngini pirripalamiya kapi kapala api awuta arikutumunuwi nimarra pirimajirri ngini, “Yita wanga awarra Jesus amintiya ngarra-mamanta,” pirimi awuta arikutumunuwi. Kiyi wuta kalikali pirimi wartingala (across the land) api ngawa-yuwuni amintiya ngarra-mamanta purruwuja kangi kapala. Kiyi awuta arikutumunuwi pakinya papi pirimi awungarruwu kapi awarra murrakupuni api ngawa-yuwuni amintiya ngarra-mamanta nanuwanga purruwuja-la kangi kapala. ");
INSERT INTO tiw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kiyi ngawa-yuwuni amintiya ngarra-mamanta papi pirimi awungarruwu kapi awarra murrakupuni kapi karri-kuwapi japuja pirimi kiyi kutupi pirimi kapi awinyirra kapala. Awarra ngawa-yuwuni, karri yipakuluwunyi awuta tayikuwapi arikutumunuwi api ngarra putuputuwu yipakirayi awuta api yimi kangatamiya, “Wuta nguri kapinaki arikutumunuwi. Wuta pirlamarri (without knowing) kularlaga wurimi nginingaji karri-kuwapi wupamangi awuta amintiya awanuwanga karri-kuwapi wuntiyarra awuta kapi maka wuta pimatu-wariyi,” yimi ngawa-yuwuni kangatamiya. Api kiyi ngarra yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Ngarra yuwuntiyarra awuta yingarti ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Awarra ngawa-yuwuni yinukuni yuwunu-waluwa (taught) awuta arikutumunuwi api karri yipapaya ngini nimarra yimi kangi wutawa api awungarri awuta ngarra-mamanta punuwuriyi kangatawa kiyi pirimi ngini, “Aya, yuwuni, waya yinkitayi yartijanga amintiya kapinaki tayikuwapi arikutumunuwi waya paruwani. Karri-kamini yinkiti awungarra kapi naki awarra murrakupuni api tajiyarra kapinaki tiwi ngini pimatu-wariyi kapi nyoni murrakupuni ngini awungarruwu pimatanga yinkiti ngini pimatapa,” pirimi ngarra-mamanta kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Api ngawa-yuwuni yimi ngini, “Karluwu. Nuwa nyirra-kirayi awuta yinkiti ngini wuta pimatapa.” Api wutatuwu pirimi ngini, “Ngawa maka ngamata-nyayi yingarti kunawuni ngini ngawunga yinkiti ngini kapinaki tayikuwapi pimatapa?” pirimi ngawa-yuwuni ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kiyi ngawa-yuwuni yimi kangi wutawa, “Awungan-ari nuwa ngimpini pamantarri? Nyirru-wariyi api nyirra-kirijipaya (count) awarra yinkiti ngini nuwa ngimpini,” yimi ngawa-yuwuni kangi ngarra-mamanta. Kiyi wuta purruwuriyi pirripakuluwunyi awarra yinkiti ngini wuta purruwuni kiyi pirimarruriyi awarra yinkiti kapi ngawa-yuwuni. Api ngarra yimi ngini, “Marri?” Api wutatuwu pirimi ngini, “Yita pinginingita pamantarri amintiya yirrara muputuwi,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Kiyi ngawa-yuwuni yuwuntiyarra ngarra-mamanta, “Nyirru-wariyi nyirra-jiyarra kapinaki tayikuwapi arikutumunuwi ngini mimpa wurrami 100 arikutumunuwi kitawani. Kiyi wutatuwu yingampa 50 arikutumunuwi mimpa wurrami nankitawu. Wuta awungani-la mimpa wurrami nginingaji yingampa 100 arikutumunuwi amintiya wutatuwu yingampa 50 arikutumunuwi. Awarra nyirra-jiyarra awuta arikutumunuwi,” yimi ngawa-yuwuni kapi ngarra-mamanta. Kiyi ngarra-mamanta purruwuriyi purru-wuntiyarra awuta arikutumunuwi awarra ngirramini ngini ngawa-yuwuni yipangiraga api awuta arikutumunuwi awungani (that way) mimpa pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kiyi ngawa-yuwuni yuwunga awarra pinginingita pamantarri amintiya awarra yirrara muputuwi kiyi yipakuluwunyi kuriyuwu api nimarra yimi kapi ngarra-rringani, yimi ngini, “Ngirringani ngiya nguru-kuruwarni (thank) nginja ngini naki yinkiti ngini ngawa wiyi ngawapa,” yimi. Kiyi ngarra kakiyija yuwawurrini (broke) awarra pamantarri kiyi yuwunt-akirayi awarra pamantarri kapi ngarra-mamanta pili-ngini wuta pimata-kirayi awarra pamantarri kapi awuta tayikuwapi arikutumunuwi. Amintiya awanuwanga awarra yirrara muputuwi kakiyija yuwawurrini kiyi yuwunt-akirayi ngarra-mamanta awarra muputuwi. Kiyi awarra pinginingita pamantarri amintiya awarra yirrara muputuwi api ngawa-yuwuni yikirimi awarra ngini yingarti yinkiti yima api awuta ngarra-mamanta pirimarruriyi awarra yinkiti kapi awuta tayikuwapi arikutumunuwi kiyi pirripakirayi awuta awarra yinkiti. ");
INSERT INTO tiw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Kiyi awuta tayikuwapi arikutumunuwi purruwapa awarra yinkiti. Awuta tayikuwapi kapi purruwapa awarra yinkiti api wuta nginingaji 5000 wawurruwi. Amintiya tayikuwapi maminikuwi amintiya kakirijuwi awanuwanga purruwapa awarra yinkiti. Awuta arikutumunuwi karri wuta murlikinya pirimi api purrupumwari yingarti yinkiti api ngawa-yuwuni ngarra-mamanta purruwunga awarra yinkiti kiyi pirripalami awarra kangi wamurrara yirrara (12) tunga. ");
INSERT INTO tiw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purruwuriyi kapi awarra timani Gennesaret. Api karri wuta papi pirimi awungarruwu api awuta arikutumunuwi pirripakuluwunyi ngawa-yuwuni api pirimajirri, “Ngarra naki awarra Jesus ngini ngarra mirrikili (miracle) arikirimi amintiya awuntiyarra tiwi ngawa-rringani ngini-ngatawa ngirramini,” pirimi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kiyi ngawa-yuwuni kularlaga yimi kapi awarra arikulani murrakupuni. Tayikuwapi awuta arikutumunuwi kapi japuja pirimi kapi awarra murrakupuni api wuta piri-pitingaya (heard) ngini ngawa-yuwuni kularlaga yimi awungarruwu api wuta kalikali pirimi kiyi purruwunga wuta-mamanta kapi wuta purunjuwi. Api kuta maka ngawa-yuwuni kularlaga yimi api awuta arikutumunuwi pirimarruriyi awuta wuta-mamanta kapi ngawa-yuwuni awungarruwu kapi awarra murrakupuni. ");
INSERT INTO tiw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Karri ngawa-yuwuni kularlaga yuwujingi-mani kapi awarra arikulani murrakupuni api yingampini (sometimes) ngarra yuwuriyi kapi tayikuwapi arikutumunuwi purumuwu amintiya yingampini yuwuriyi kapi kiyija-nara arikutumunuwi purumuwu amintiya awanuwanga yingampini yuwuriyi kapi yingampa arikutumunuwi waki purru-wujingi-mani kapi ngini-wutawa garden. Api kuta maka kapi ngawa-yuwuni yuwuriyi api awuta tayikuwapi maka kapi ngawa-yuwuni yuwuriyi api awuta tayikuwapi arikutumunuwi pirripakuturruwa kapi palapala wuta-mamanta kapi wuta purunjuwi kiyi pirripamukuri awuta kapi turruwuni awungarruwu kapi wuta sellim pirimani yinkiti. Api karri ngawa-yuwuni yinuwuriyi yinkitayi kapi awuta kapi wuta purunjuwi api awuta purunjuwi pirimi kangatawa, “Aya, mantani, ngawa ngawutimarti ngini ngamata-mukuri ngini-ngawula yikara kangi anginjila kuluji,” pirimi awuta kapi purunjuwi. Api ngawa-yuwuni yimi kangi wutawa ngini, “Manya awarra.” Api kiyi awuta tayikuwapi kapi purunjuwi pirripamukuri ngini-wutawa yikara kangi angatawa kuluji api ngawa-yuwuni ngini-ngatawa power pupuwi yikirimi awuta. ");
INSERT INTO tiw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kiyi ngawa-yuwuni Jesus yipumwari awarra murrakupuni Galilee kiyi yuwuriyi kapi nyoni murrakupuni ngini yinkitayi kapi awarra town Tyre. Karri papi yimi awungarruwu api yipawuriji yilaruwu kangi natinga kurrampali. Api ngarra arnuka yuwutimarti awuta arikutumunuwi ngini pimata-nyayi ngarra awungarruwu kapi awinyirra kurrampali. Api karluwu, pili wuta yingampa tiwi purruwunyayi ngarra awungaji. ");
INSERT INTO tiw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Awungarruwu kapi awarra murrakupuni natinga yimpalinya jiyimuwu angi nyirra arnuka Jew. Yati maputiti yipalamiya kapi nyirra-mwaringa nyirra purnikapa. Kiyi yingampa arikutumunuwi purru-wutiyarra awinyirra yimpalinya ngini ngawa-yuwuni papi yimi awungarruwu kapi awarra murrakupuni api nyirra juwuriyi kapi awinyirra kurrampali kapi ngarra yimuwu. Karri awinyirra yimpalinya papi jiyimi awungarruwu kapi awinyirra kurrampali api jipawuriji yilaruwu kiyi juwuriyi kapi ngawa-yuwuni yuwujingi-muwani kiyi juwunyaw-amiya kapi yakuluwuni yinkitayi kapi ngatawa malapwara. Kiyi jiyimi kangatawa, “Aya, mantani, ngiya-mwaringa api maputiti yipalamiya kangi nyirra purnikapa api ngiya nguwutimarti ngini nginja papi jini-mata-mamiyi (make it come out) awarra maputiti kangi nyirra purnikapa,” jiyimi awinyirra yimpalinya kangatawa. ");
INSERT INTO tiw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Api ngawa-yuwuni yimi kangi nyitawa, “Nginja nimpirimajawu ngini ngawa arikutumunuwi pakinya ngawunt-akirayi kangawula kakirijuwi yinkiti ngini wuta murlikinya pimatami. Api awarra yinkiti ngini ngawunt-akirayi awuta kakirijuwi api ngawa karluwu ngamata-kirayi (shouldn't give) awarra yinkiti kapi awuta pulangumwawi. Waya juwa kapi awuta kakirijuwi,” yimi ngawa-yuwuni kangi awinyirra yimpalinya. Ngawa-yuwuni yimi awarra pili ngarra yuwutimarti ngini yimata-jiyarra awinyirra yimpalinya angi nyirra karluwu Jew ngini ngarra pakinya yimata-wani (should help) awuta arikutumunuwi kapi wuta Jews nginingaji ngarra. ");
INSERT INTO tiw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Api nyirra jiyimi ngini, “Kuwa. Waya awarra pupuni. Awuta kakirijuwi pakinya wuwapa yinkiti. Api karri wuta wujingapa yinkiti api jukurruka (pieces of food) apakupuraji kapi yakuluwuni api awuta pulangumwawi wuwapa awarra jukurruka,” jiyimi awinyirra tinga. Api jiyimi kangi nyitamiya, “Awuta Jews wuta nginingaji awuta kakirijuwi kapi wuta pakinya wuwapa yinkiti api naki Jesus ngarra awutimarti ngini pakinya yimata-wani (to help) awuta Jews. Amintiya ngawa kapi arnuka Jews api ngawa nginingaji awuta pulangumwawi kapi wuta wuwapa jukurruka kapi yakuluwuni api arrami ngarra wiyi aminu-wani ngiya kiyija,” jiyimi kangi nyitamiya. Api kiyi nyirra jiyimi kangi ngawa-yuwuni, “Tawani ngiya kiyija! Marri?” jiyimi awinyirra yimpalinya kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ngawa-yuwuni yimajawu awarra ngini nyirra jiyimi kangi nyitamiya api ngarra yimi kangi nyitawa, “Pupuni awarra ngini nginja jipangiraga api ngiya waya papi nginiri-mamiyi awarra maputiti kapi nyirra purnikapa nginja-mwaringa api nyirra waya pupuka jiyima. Manya waya tipuwariyi kanginjila japuja.” Awarra yimi ngawa-yuwuni kangi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kiyi awinyirra yimpalinya juwuriyi kangi nyitawa japuja. Karri nyirra papi jiyimi awungarruwu api juwunyayi nyirra-mwaringa juwujingi-milani kapi palapala api awarra maputiti waya yipumwari nyirra purnikapa. ");
INSERT INTO tiw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kiyi ngawa-yuwuni Jesus yipumwari awarra town Tyre amintiya Sidon. Kiyi ngarra yipakupawurli kapi awarra lake Galilee. Kiyi yuwuriyi kapi nyoni murrakupuni Decapolis kiyi awungarruwu ngarra kularlaga yimi. ");
INSERT INTO tiw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Awungarruwu kapi awarra murrakupuni Decapolis yingampa arikutumunuwi piniri-marruriyi wuta-mantani kangi ngawa-yuwuni. Ngarra kalanjarrini awarra tini amintiya karluwu pupuni nimarra yirrijami (couldn't talk well). Karri wuta papi pirimi kapi ngawa-yuwuni api pirimi kangatawa, “Aya, mantani. Tawani ngawa-mantani pili ngarra kalanjarrini amintiya karluwu pupuni nimarra arimi. Tayamukuri nginjila yikara kangi ngarra pungintaga pili-ngini ngarra pupuni yimatama,” pirimi awuta tiwi. Api ngarratuwu ngawa-yuwuni yimi ngini, “Manya awarra.” ");
INSERT INTO tiw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kiyi ngawa-yuwuni yimarruriyi awarra tini aringampi-nara kapi wuta wangatamiya pili tayikuwapi arikutumunuwi. Kiyi ngarra yipamukuri ngini-ngatawa wamuta (finger) yilaruwu kapi awarra tini ngarra purrakurninga. Kiyi ngawa-yuwuni juwarti yuwunyawu kangi ngini-ngatawa yikara kiyi yipamukuri ngarra yikara kangi awarra tini ngarra karaliki. ");
INSERT INTO tiw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","35","Kiyi ngarra yipakuluwunyi kuriyuwu kiyi makirrana yiminga yipangirri (sighed) api awungarri yimi kangi awarra tini, “Nginja wiyi nimpiri-pitingaya (hear) amintiya awanuwanga wiyi pupuni nimarra nimpirimi,” yimi ngawa-yuwuni kangi awarra tini. Karri ngawa-yuwuni yipangiraga awarra ngirramini api awungarri awarra tini ngarra purrakurninga amintiya ngarra karaliki pupuni yima api ngarra yipitingaya amintiya pupuni nimarra yimi. ");
INSERT INTO tiw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Kiyi ngawa-yuwuni amintiya awarra tini pirripakupawurli kapi awuta tayikuwapi arikutumunuwi. Kiyi ngawa-yuwuni yuwuntiyarra awuta tayikuwapi tiwi, “Awi, nuwa ngajiti ngimpaja-jiyarra yingampa arikutumunuwi ngini ngiya pupuni ngirikirimi awarra naki tini,” yimi. Api awuta arikutumunuwi arnuka kuwa pirimi awarra ngini ngarra yipangiraga api wiyi (later) purru-wuntiyarra yingampa arikutumunuwi ngini ngawa-yuwuni yikirimi awarra mirrikili (miracle). Api karri awuta yingampa arikutumunuwi piri-pitingaya (heard) ngini ngawa-yuwuni pupuni yikirimi awarra tini api pirimarlingiyi (got a surprise) api nimarra pirimajirri ngini, “Yita ngarra ngatawa awarra naki Jesus. Ngarra warntirrana pupuwi arikirimi awuta kapi purunjuwi amintiya awanuwanga pupuwi arikirimi awuta kapi wuta kalanjarruwi amintiya awuta kapi wuta arnuka pupuni wupangiraga,” pirimi awuta tiwi. Api karri ngawa-yuwuni kularlaga yimi kapi awarra murrakupuni api ngarra awarra-wanga (same) ngirramini yuwuntiyarra-mini awuta arikutumunuwi ngini wuta karluwu pimata-jiyarra (shouldn't tell) yingampa arikutumunuwi ngini (about) awarra yingarti mirrikili (miracle) ngini ngarra yikirim-ani. Api awuta arikutumunuwi awanuwanga karluwu kuwa pirimani ngarra kiyi purru-wuntiyarra yingampa arikutumunuwi ngini ngawa-yuwuni mirrikili yikirim-ani. ");
INSERT INTO tiw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Ninkiyi tayikuwapi arikutumunuwi purruwuriyi kapi ngawa-yuwuni Jesus awungarruwu kapi yartimanyini. Api ngawa-yuwuni yuwuntiyarra awuta ngini ngarra ngawa-rringani ngirramini. Jajirrima wumunga awuta purumuwu awungarrawu amintiya piripirtangaya ngawa-yuwuni ngini ngarra yipangiraga. Api awarra yinkiti ngini wutawa pinimarruriyi, api waya kirriki pirimi. Ninkiyi, ngawa-yuwuni kuwayi yimi kapi ngarra-mamanta, yimi ngini, “Wuta kapinaki tiwi waya kirriki pirimi ngini wutawa yinkiti pinimarruriyi. Wuta nguwuri. Yita waya jajirrima wumunga pirimuwu awungarra naki, api waya paruwani wurimi,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","“Yingompa pinirimi karrampi murrakupuni, api ngawa karrawungana ngipangirri awuta kapi wutawa murrakupuni pili arramukuta wiyi wupakupurungunti pirlima. Api ngawuntayakirayi yinkiti ngini murlikinya pimatama,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wutatuwu ngarra-mamanta pirimi ngini, “Api maka awungarra naki yinkiti ngamatanyayi ngini ngamatakirayi nginingaji wutawa? Yita awungarra naki murrakupuni yartimanyini,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","7","Kiyi, ngarratuwu yimi ngini, “Awunganari niyi nuwuni pamantarrini?” Api wutatuwu pirimi ngini, “Yita waya juwa walimani. Amintiya arnuka-nara miputi.” (Api ngarratuwu yimi ngini, “Waya.”) Ninkiyi yuwuntiyarra awuta tayikuwapi tiwi, yimi ngini, “Awi. Nyirramuwu yakuluwuni, nginingaji nuwula.” Kiyi, pirimiringarra yakuluwuni. Kiyi yuwunga awarra pamantarrini, kiyi yipakuluwunyi kuriyuwu, api yuwurtiyarra ngarra-rringani, yimi ngini, “Nginja nguwuri ngini pamantarrini ngawa wiyi ngawapa.” Kiyi kakiyija yuwawurrini awarra pamantarrini. Kiyi yuwuntakirayi ngarra-mamanta awarra api awungarruwu yingarti yima. Kiyi ngarra-mamanta pirripangulimayi kiyi pirripakirayi awarra pamantarrini kapi awuta arikutumunuwi. Amintiya awarra miputi karri tayikuwaninara, api awarra awanuwanga ngarra yuwunga, api yikuruwarni ngarra-rringani ngini kuriyuwu. Kiyi yuwuntiyarra ngarra-mamanta, yimi ngini, “Nyirrayakirayi naki miputi awanuwanga.” Kiyi, pirripakirayi awarra kapi awuta tayikuwapi. ");
INSERT INTO tiw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Awarra pamantarrini amintiya miputi, api ngawa-yuwuni yikirimi awarra ngini yuwuntakirayi awuta tayikuwapi arikutumurnuwi ngini pimataapa. Nginingaji wutawa api nginingaji 4000 arikutumunuwi. Karri pirripapaya purruwapa, api awarra yinkiti ngini pirripumori, api ngarra-mamanta awarra purruwunga api pirripalami kangi yipajinga. Walimani awinyirra yipajinga pirikirijipaya. Ninkiyi, ngawa-yuwuni yuwuntangirri awuta tiwi kapi wutawa tangarima, yimi ngini, “Nyilipuwariyi kapi nuwula tangarima.” Kiyi purruwuriyi kapi wutawa tangarima. ");
INSERT INTO tiw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ninkiyi, ngawa-yuwuni wuta ngarra-mamanta pirripapirraya kapi yirringarni, kiyi pirripawuriji kapala, kiyi pirripatuwala. Karri pirripapurti maringarruwu, api kutupi pirimi kapi murrakupuni. Awarra murrakupuni Dalmanutha. Waya juwa. ");
INSERT INTO tiw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ninkiyi, ngawa-yuwuni wuta ngarra-mamanta purruwuriyi awarra murrakupuni Bethsaida. Api karri papi pirimi awungarruwu wutatuwu yingompa arikutumunuwi pinirimarruriyi yati arikutumunini ngini yinkirlatini. Wuta pirimi ngini, “Aya. Manya nginja pupuni jimatakirimi naki nginingatawa pijara. Api taningiya ngarra purnikapa ngini pupuni yimataama ngini ngatawa pijara,” pirimi. Api ngarratuwu ngawa-yuwuni yimi ngini, ");
INSERT INTO tiw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","“Manya awarra,” yimi. Kiyi ngawa-yuwuni yuwuriyi yikiringa awarra ngini yinkirlatini, kiyi yimarruriyi yilimpayanga kapi karrikuwapi. Karri waya wuta wangata, api juwarti yuwunyawamiya ngarra yikara amintiya yipapika awarra juwarti kangi nginingatawa pijara awarra tini. Kiyi, yuwayorri awarra tini, “Marri? Kamini waya nimpakuluwunyi?” yimi. ");
INSERT INTO tiw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ngarratuwu ngini yinkirlatini yimi ngini “Yita waya ngipakuluwunyi tiwi api karri ngipakuluwunyi awuta tiwi api wurimi nginingaji purinjirringuwi ampijirrangulimayi,” yimi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tuwanga ngawa-yuwuni yuwuningiya awarra tini pijara, api awungarri awarra tini pupuni pijara yima api waya awungarri pupuni yipakuluwunyi. ");
INSERT INTO tiw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ninkiyi, ngawa-yuwuni yuwurtiyarra awarra tini, yimi ngini, “Manya, tipuwariyi kapi nginjila murrakupuni. Ngajiti nimpajakupawurli kapi awarra murrakupuni kapi juwunyayi ngiya,” yimi ngawa-yuwuni. Kiyi, awarra tini kuwa yimi ngini ngawa-yuwuni yuwurtiyarra, api yuwuriyi kapi ngatawa tangarima. ");
INSERT INTO tiw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kiyi ngawa-yuwuni Jesus yuwutiyarra ngarra-mamanta amintiya awuta tayikuwapi arikutumurnuwi kapi mimpa pirimi kapi awarra murrakupuni, api yimi ngini, “Awi,” yimi. “Nuwa kapi ngimpitimarti ngini ngumpapunya ngiya amintiya ngini ngumpa-mamula ngiyanuwa-mantani api ngajiti nuwalamiya nirra-pungintayi-amiya. Yita ngiyatuwu nirra-pungintayi pakinya amintiya awanuwanga nginingilawa ngirramini nirra-pungintayi amintiya awarra ngirramini nginingilawa nuwuntiyarra nuwa-mamanta.” ");
INSERT INTO tiw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kayi, wuta wiyi jajiruwi tiwi ngirramini wupakirayi nuwa pili nuwa kuwa ngimpirimi nginingilawa ngirramini amintiya wiyi awanuwanga wuripirni nuwa arrami nginingaji wuta wiyi wuripirni ngiya amintiya pajuwani wurikirimi ngiya. Api ngini wuta awungani wurimi kangi nuwula api ngajiti nimarra ngimpajami kangi nuwalamiya ngini, “Ngiya waya arnuka ngumata-punya angatawa ngawa-yuwuni jarrumoka pili wuta ngirramini wupakirayi ngiya. Ngajiti awungani ngimpajami,” yimi ngawa-yuwuni, “pili kapi nuwa awarra ngimpirimi api nuwa awuta wiyi arnuka ngawiyati tangarima ngintimatami kuriyuwu kapi ngiya-rringani. Tani kapi nuwa warntirrana kuwa ngimpirimi ngini ngiya ngirramini amintiya awanuwanga nuwuntiyarra tiwi awarra nginingilawa ngirramini karrawana ngini wuta awuta jajiruwi tiwi ngirramini wupakirayi nuwa api nuwa wiyi ngawiyati tangarima ngimpirimi kuriyuwu kapi ngiya-rringani.” Awarra ngirramini awarra ngawa-yuwuni yuwuntiyarra ngarra-mamanta amintiya awuta tayikuwapi arikutumurnuwi. ");
INSERT INTO tiw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ninkiyi, ngawa-yuwuni Jesus wuta ngarra-mamanta purruwuriyi pirimamiji awungarruwu murrakupuni Galilee. Api ngawa-yuwuni karluwu yuwutimarti ngini yingompa pimatakuluwunyi awuta, ");
INSERT INTO tiw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pili ngarra yuwutimarti ngini wuta wangatamiya ngarra-mamanta. Ngarra yuwutimarti ngini yuwunuwaluwa awarra ngirramini ngini ngatawamiya. Api yilimpayanga pirimi. Ninkiyi, awungarruwu nimarra yimi kangi awuta ngarra-mamanta karri purrupangulimayani, yimi ngini, “Awi. Kapi awuta alawuruwi kapi awarra jurra, api wuta wiyi wuntiyajura awuta kompi ngini pajuwani pimatakirimi ngiya,” yimi ngawa-yuwuni. “Api karri pajuwani wurikirimi ngiya, api ngiya wiyi pajuwani ngirimi nginingaji jajirrima wumunga. Karri awungarri awinyirra jajirrima wumunga, api yimpanga nguwunirima,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Awarra ngini ngarra yuwuntiyarra, api wuta karluwu awarra pirimungumajawa. Arnuka tuwanga piriwayorri, pili wuta arliranga pirikirimi. Api awarra purruwunjarli. ");
INSERT INTO tiw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Kiyi ngawa-yuwuni Jesus amintiya awuta wamurrara yuwurrara (12) ngarra-mamanta purruwuriyi kapi awarra town Capernaum. Karri wuta purruwuja api ngarra-mamanta piriwayatipi (argued) ngini (about) kuwani alawura yimi. Kiyi ngawa-yuwuni amintiya ngarra-mamanta papi pirimi kapi awarra town Capernaum api pirripawuriji yilaruwu kapi natinga kurrampali. Kiyi ngawa-yuwuni nanginta yimi ngarra-mamanta, “Nayi kamini nuwa ngintiri-wayatipi (argued) karri ngawa nginti-pangulimayi kapi jarrumoka?” Api ngarra-mamanta karluwu purru-wutiyarra ngarra pili wuta arliranga pili wuta piriwayatipi ngini (about) kuwani ngarra warntirrana alawura. ");
INSERT INTO tiw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Api ngawa-yuwuni waya yimajawu awarra ngirramini ngini wuta nimarra pirimi karri pirripangulimayi kapi jarrumoka api ngarra yimuwu kiyi yimi kapi awuta ngarra-mamanta, “Nyirru-waripa api nyirra-muwu kangilawa,” yimi. Kiyi wuta punuwuriyi kangatawa. Api yimi ngini, “Kuta kuwani awutimarti ngini alawura yimatami api ngarra karluwu yimata-pungintayi (shouldn't think about) ngatamiya. Waya juwa yimata-mangi tayikuwapi tiwi.” Ngarra awarra yipangiraga kapi ngarra-mamanta ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kiyi ngawa-yuwuni yipamukuri yati kirijini kuluwuta kapi awuta ngarra-mamanta. Kiyi yikutapirri (hugged) awarra kirijini api yimi kapi ngarra-mamanta, ");
INSERT INTO tiw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Awi, awuta arikutumunuwi kapi puranji wurumuwu ngiya api wuta awuta wunu-wani (help them) kakirijuwi. Api karri wuta wunu-wani awuta kakirijuwi api awarra nginingaji wuta wuru-wani ngiya. Amintiya karri wuta wuru-wani ngiya api wuta karluwu ngiya wangata wuru-wani. Yita wuta wuru-wani ngiya-rringani wiyarri pili ngarra yini-pangirri (sent) ngiya kapi nuwa arikutumunuwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ninkiyi, ngawa-yuwuni Jesus wuta ngarra-mamanta kapi ngatawa yuwunini, awungarruwu pirripumori awarra murrakupuni Capernaum. Kiyi, purruwuriyi awarra murrakupuni Judea ngini arikulani. Karri purruwuja wuta papi pirimi kapi awinyirra makatinga Jordan. Kiyi, pirripatuwala maringarruwu. Awungarruwu tayikuwapi purruwuriyi ngini pimatapirtangaya ngawa-yuwuni. Api ngawa-yuwuni yuwuntiyarra awuta tayikuwapi ngini ngarra ngirramini ngawa-rringani. Ngarra awunganila yimani, ngini yuwaluwamini awuta kapi pinuriyani. ");
INSERT INTO tiw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kiyi yingompa awuta Pharisees purruriyi awungarruwu kapi ngawa-yuwuni yuwaluwamini awuta arikutumunuwi. Awungarruwu wutilajirri nimarra pirimajirri ngini, “Ngawurliyi kapi awarra nginayi Jesus. Arramukuta ngawa wiyi ngarikirimi awarra ngini ariwaluwa ngawa ngini jirti ngirramini,” pirimajirri. Api kiyi, purruwuriyi kapi ngawa-yuwuni, purruwurtiyarra, “Aya. Ngini yati apumori ngarra-purnayinga, api awarra pupunana?” pirimi awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Api ngarratuwu ngawa-yuwuni yimi ngini, “Pakinya ngiya nguruwayorri nuwa. Awarra ngirramini ngini parlingarri Moses yikirimi kiyi yuwurimpura, awarra ngirramini ngini nuwa nupapunya, karri nupumori nuwa-purnayuwi, api kamini awarra ngirramini?” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Api wutatuwu pirimi ngini, “Marri ngarratuwu Moses yuwurimpura ngini, ‘Karri yati tini awutimarti ngini apumori ngarra-purnayinga, api ngarra pakinya yimataanga pukaringini, api kiyi, kangi awarra pukaringini ngarra jurra yimatakirimi ngini waya arnuka ngarra-purnayinga, kiyi yimatayakirayi awarra pukaringini kangi awinyirra ngarra-purnayinga, api awungarri yimatamori awinyirra.’ Awarra Moses yuwurimpura awarra ngirramini parlingarri,” pirimi awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Api ngarratuwu yimi ngini, “Yita wanga awarra Moses yuwurimpura awarra ngirramini pili nuwa-ampi nuwa-maninguwi jajiruwi. Wuta paparluwi jirti pungintaga purruwuni. Awanuwanga nuwa wiyarri jirti pungintaga nuwuni,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","9","“Api ngawa-rringani ngini kuriyuwu arnuka awutimarti ngini nuwa ngintimatamori nuwa-purnayuwi. Yita wanga ngarra awutimarti ngini nuwa ngintimatamangi nuwa-purnayuwi yiloti. Parlingarri ngarra yikirimi yati arikutumurnini amintiya natinga arikutumuninga ngini pimatamarrimuwajirri. Pili awarra karri yati tini awutimarti ngini yimatamarrimuwu ngarra-purnayinga, api ngarra apumori ngarra-rringani amintiya ngarra-naringa api waya arimarrimuwu awinyirra ngarra-purnayinga kiyi apamangi awinyirra. Api waya nginingaji punyipunyi ruwuti apamartajirri wuta ngarra-purnayinga. Nginingaji wuta wuni yati punyipunyi amintiya ruwuti,” yimi ngawa-yuwuni. “Ngini ngarra ngawa-rringani ngini kuriyuwu apajuwurlima wuta ngarra-purnayinga, api wuta karluwu pimatamorajirri,” yimi ngawa-yuwuni kangi awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Karri ngawa-yuwuni wuta ngarra-mamanta pirripumori awuta Pharisees kiyi pirripawuriji yilaruwu kangi kurrampali api awungarri wutatuwu ngarra-mamanta purruwurtiyarra ngawa-yuwuni, pirimi ngini, “Aya. Awarra ngirramini ngini ninganinara juwuntiyarra awuta Pharisees ngini karrikuwani yimatumori ngarra-purnayinga, api tuwanga tajiyarra ngawa,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Api ngarratuwu yimi ngini, “Ngini yati tini apumori ngarra-purnayinga kiyi arimarrimuwu nyonga, api jirti awarra, pili awarra yimarratipugi ngini ngarra ngawa-rringani ngirramini,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","“Amintiya nyirratuwu awanuwanga ngarra-purnayinga ngini ampinyayi nyoni, api awarra arimarrimuwu awinyirra, api jirti awarra, pili nyirra jimarratipugi ngini ngarra ngawa-rringani ngirramini,” yimi ngawa-yuwuni kangi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kiyi tayikuwapi tiwi piniri-marruriyi wuta-mwaruwi amintiya wuta-mamirampi kapi ngawa-yuwuni Jesus pili pirimi kangi wutalamiya, “Ngarra wiyi apamukuri ngarra yikara kapi ngawa-mwaruwi wuta pungintaga amintiya ngawa-mamirampi kiyi ngarra wiyi nanginta arimi ngawa-rringani ngini kuriyuwu ngini yimata-mangi awuta kapinaki kakirijuwi,” pirimi awuta arikutumunuwi kangi wutalamiya. Kiyi ngawa-yuwuni ngarra-mamanta karri pirripakuluwunyi awuta arikutumunuwi ngini piniri-marruriyi awuta kakirijuwi kapi ngawa-yuwuni api wuta pirikirlimirri (growled at) awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","15","Kiyi ngarra ngawa-yuwuni karri yipitingaya (heard) awarra ngirramini ngini ngarra-mamanta pirripangiraga kapi awuta arikutumunuwi api ngarra yikirlimirri (growled at) ngarra-mamanta api yimi ngini, “Ngajiti awungani ngimpajami! Nyirra-jiyarra awuta kakirijuwi ngini wurru-waripa kangiya pili yingampa kapinaki kakirijuwi kuwa wurimi ngawa-rringani ngini-ngatawa ngirramini api ngarra wiyi alawura arimi kangi awuta kiyi ngarra wiyi awunt-amangi awuta,” yimi ngawa-yuwuni. Kiyi ngawa-yuwuni yimi kangi ngarra-mamanta amintiya awuta arikutumunuwi, “Awarra naki warntirrana ngini nuwa wawurruwi amintiya maminikuwi api ngini (if) nuwa ngimpitimarti ngini ngawa-rringani wiyi alawura yimatami kangi nuwa amintiya apamangi nuwa api nuwa awanuwanga kuwa nginti-matami ngini-ngatawa ngirramini nginingaji awuta kakirijuwi kapi warntirrana kuwa wurimi awarra ngirramini awarra ngawa-rringani. Ngini nuwa karluwu kuwa ngimpirimi awarra ngirramini ngini-ngatawa ngawa-rringani nginingaji awuta kakirijuwi kuwa wurimi awarra ngirramini api ngarra ngawa-rringani wiyi karluwu alawura yimatami kangi nuwa amintiya karluwu yimata-mangi nuwa. Ngiya karluwu kunyani ngirimi,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kiyi ngawa-yuwuni yimi kangi awuta kakirijuwi ngini, “Awi kakirijuwi, nyirru-waripa,” yimi. Kiyi awuta kakirijuwi purruwuriyi kapi ngawa-yuwuni. Api kiyi ngarra yikutapirri (hugged) awuta kakirijuwi kiyi yipamukuri ngarra yikara kangi wuta pungintaga kiyi nanginta yimi ngarra-rringani ngini ngarra yimata-mangi awuta kakirijuwi. ");
INSERT INTO tiw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta pirripangulimayi kapi jarrumoka angi juwuja kapi Jerusalem api karri wuta purruwuja api yati tini kalikali yimi kapi ngawa-yuwuni api ngarra yipamukuri ngini-ngatawa yirrara yimpula (knelt down) kangi yakuluwuni yinkitayi kapi ngawa-yuwuni ngarra malapwara. Kiyi ngarra yimi kapi ngawa-yuwuni, “Aya, mantani, yita nginja pupuni. Ngiya nguwutimarti ngini wiyi ngimata-muwu yiloti kuriyuwu kangi ngawa-rringani ngarra japuja api tajiyarra ngiya kamini awarra waki ngini ngiya ngimata-kirimi (should do),” yimi awarra tini kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Api ngawa-yuwuni yimi kangatawa, “Arnapa. Pilikama nginja jiyimi ngini ngiya pupuni? Waya juwa ngawa-rringani ngini kuriyuwu ngarra pupuni,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kiyi ngawa-yuwuni tuwanga yimi kapi awarra tini, “Nginja waya nimpirimajawu ngawa-rringani ngini-ngatawa ngirramini (law) nginingaji, Nginja ngajiti pajuwani nimpaja-kirimi yingampa tiwi. Ngajiti nimpaja-marrimili awinyirra tinga angi ngarra nyoni tini ngarra-purnayinga. Ngajiti mitaya nimpajami kuta kamini awarra ngini wuta yingampa tiwi wuni. Ngajiti tongwayi nimpajami awuta tiwi kapi karluwu jirti pirikirim-ani. Ngajiti kunyani nimpajami kapi awuta yingampa tiwi pili nginja nimpitimarti ngini wuta pimata-kirayi nginja kunawuni amintiya yinkiti. Kuwa tami awarra ngirramini ngini nginja-rringani amintiya nginja-naringa wutiyarra nginja. Awarra ngirramini (law) ngini-ngatawa ngawa-rringani api kuwa tami awarra,” yimi ngawa-yuwuni kapi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Api awarra tini yimi kangi ngawa-yuwuni, “Rapayi, yita ngiya waya kuwa ngirimani tayikuwa-ni (all) awarra ngirramini (law). Karri ngiya kirijini api kuwa ngirimani awarra ngirramini amintiya awanuwanga ngiya nanuwanga (still) kuwa ngirimi awarra ngirramini,” yimi awarra tini. Awarra yintanga Rapayi mean arimi awarra tini ngini awunu-waluwa (teaches) arikutumunuwi awarra Moses ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kiyi ngawa-yuwuni yinukuni yipakuluwunyi awarra tini api yimi kangatamiya, “Ngiya puranji ngurumuwu awarra naki tini,” yimi ngawa-yuwuni kangatamiya. Api ngarra yimajawu ngini awarra tini yuwuni (had) yingarti kunawuni amintiya arramu-kaminawuti. Amintiya ngarra awanuwanga yimajawu ngini awarra tini warntirrana puranji yimuwu awarra ngini-ngatawa kunawuni amintiya awarra arramu-kaminawuti amintiya ngini ngarra karlu-nara puranji yimuwu ngawa-rringani api awarra ngawa-yuwuni yimi kangatawa, “Pupuni awarra ngini nginja kuwa nimpirimi ngawa-rringani ngini-ngatawa ngirramini (law) api waya juwa naki nyoni ngini nginja jimata-kirimi (should do) api nginja sellim jimatami awarra yingarti arramu-kaminawuti ngini nginja nimpini. Api awarra kunawuni ngini nginja wiyi nimpanga karri nginja sellim nimpirimi awarra ngini-nginjila arramu-kaminawuti api tamarruriyi awarra kunawuni kapi awuta tiwi kapi karri-kamini kunawuni wuni kiyi tayakirayi awarra kunawuni kangi wutawa. Kiyi karri nginja wiyi nimpakirayi ngini-nginjila kunawuni kapi awuta tiwi kapi karri-kamini kunawuni wuni api awungarri tuwaripa kiyi tayapunya ngiya,” yimi ngawa-yuwuni. Kiyi ngarra tuwanga yimi kapi awarra tini, “Ngini nginja kuwa nimpirimi awarra ngini ngiya waya ngurru-wutiyarra nginja api ngawa-rringani wiyi arimarruriyi nginja kuriyuwu kapi ngatawa tangarima api awungarruwu ngarra wiyi apakirayi nginja arramu-kamini ngini pupuni amintiya nginja wiyi warntirrana kukunari.” Awarra yimi ngawa-yuwuni kangi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Api awarra tini, karri yipitingaya (heard) awarra ngini ngawa-yuwuni yipangiraga api ngarra feel jirti kapi ngarra punyipunyi amintiya ngarra ruwuti. Ngarra yuwutimarti ngini yimata-punya ngawa-yuwuni api karluwu pili ngarra arnuka yuwutimarti ngini yimata-kirayi awarra yingarti ngini-ngatawa kunawuni kapi awuta tiwi kapi karri-kamini kunawuni purruwuni. Api ngarra putuputuwu yipakiray-amiya (felt sorry for himself) api yipumwari ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kiyi ngawa-yuwuni yipakuluwunyi ngarra-mamanta api yimi kangi wutawa, “Tayikuwapi arikutumunuwi kapi wuni yingarti kunawuni amintiya arramu-kaminawuti api arrami wuta wiyi karluwu pimatu-wariyi kuriyuwu kapi ngawa-rringani ngarra tangarima pili wuta karluwu wuru-pungintayi (think about) ngawa-rringani,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","Api ngarra-mamanta karri wuta piri-pitingaya (heard) awarra ngirramini ngini ngarra yipangiraga api pirimarlingiyi (got a surprise) pili wuta amparrimani pirrarimi ngini ngawa-rringani kukunari arimi kangi awuta arikutumunuwi kapi yingarti kunawuni wuni. Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Awarra warntirrana ngini yingampa arikutumunuwi kapi wuni yingarti kunawuni api wuta karluwu wuru-pungintayi ngawa-rringani. Wuta waya juwa wuru-pungintayi ngini-wutawa kunawuni amintiya awarra arramu-kaminawuti ngini wuta wuni api ngawa-rringani wiyi karluwu yimata-marruriyi awuta kapi ngarra tangarima pili wuta karluwu puranji wurumuwu ngarra,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Api awuta ngarra-mamanta karri piri-pitingaya (heard) awarra ngirramini ngini ngarra yipangiraga api wuta tuwanga pirimarlingiyi (got a surprise) api nimarra pirimajirri ngini, “Kuwapi awuta tiwi kapi pirriju-wariyi (can go) kuriyuwu kapi ngawa-rringani ngarra tangarima? Arramukuta karri-kuwapi,” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Api ngawa-yuwuni yipitingaya awarra ngirramini ngini wuta pirripangiraga api yipakuluwunyi awuta api yimi ngini, “Arikutumunuwi karluwu wutalamiya pimatu-wariyi (can't go) kuriyuwu kangi ngawa-rringani ngarra tangarima. Ngarra wangata ngawa-rringani arimarruriyi arikutumunuwi kapi ngini-ngatawa tangarima. Ngarra ngawa-rringani warntirrana ngatawa amintiya ngarra yirrija-kirimi (can do) kuta kaminawuti ngini ngarra awutimarti pili ngarra yingarti power,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kiyi awarra Peter yimi kangi ngawa-yuwuni, “Aya, yuwuni, ngawa kapi waki ngarimi ngini nginja api ngawa waya nguntu-pumwari ngawa-rringanuwi amintiya ngawa-naruwi. Amintiya awanuwanga nguntu-pumwari ngini-ngawula timani pili ngawa nginti-papunya nginja. Amintiya awanuwanga nguntu-pumwari awarra yingarti arramu-kaminawuti ngini ngawa pakinya nguntu-wuni. Api kamini ngawa-rringani wiyi apakirayi ngawa?” yimi Peter kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Api ngawa-yuwuni yimi kangatawa, “Naki awarra warntirrana ngini nuwa kapi ngumpumwari ngini-nuwula tangarima amintiya gardens amintiya awanuwanga nuwa-ngirimipi pili nuwa puranji ngumpuru-muwu ngiya amintiya nuwa ngimpitimarti ngini nginti-mata-jiyarra tayikuwapi arikutumunuwi ngini-ngilawa ngirramini api ngawa-rringani ngini kuriyuwu wiyi warntirrana apamangi nuwa amintiya ngarra wiyi apakirayi nuwa yingarti kurrampali amintiya gardens. Amintiya awanuwanga nuwa awuta kapi ngumpumwari nuwa-ngirimipi api yingampa tiwi wiyi wupamangi nuwa api nuwa wiyi ngimpiri-mamula (call) awuta tiwi nuwa-ngirimipi, nginingaji nuwa-rringanuwi, nuwa-naruwi, nuwa-yupi, nuwa-ngilipi. Amintiya awuta tayikuwapi tiwi wiyi wurimi ngini nuwa awuta api wuta-ngirimipi nuwa,” yimi ngawa-yuwuni. Kiyi ngawa-yuwuni tuwanga yimi kapi ngarra-mamanta, “Awarra warntirrana ngini ngawa-rringani wiyi apakirayi nuwa yingarti arramu-kaminawuti ngini pupuni amintiya yingarti gardens karri nuwa nanuwanga yimpanguwi ngumpuru-muwu kapi naki murrakupuni (on this earth) api wiyi awungarri yingampa jajiruwi arikutumunuwi jirti ngirramini (trouble) wupakirayi nuwa pili nuwa ngimpapunya angilawa jarrumoka. Arramukuta yingampa awuta tiwi wiyi wuripirni nuwa. Api ngajiti worry ngimpajami pili karri nuwa wiyi pajuwani ngimpirimi api nuwa wiyi ngumpuriyi kuriyuwu kiyi yiloti ngumpuru-muwu kapi ngawa-rringani ngarra tangarima.” Awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kiyi ngawa-yuwuni nyoni nginaki ngirramini nimarra yimi ngini, “Tayikuwapi arikutumunuwi kapi wuta wutawa wuri-mamuliya api ngawa-rringani wiyi arikirimi awuta ngini wuta karluwu wutawa. Amintiya awuta arikutumunuwi kapi yingampa (other) tiwi wurimi ngini wuta kuwulingipi api ngawa-rringani wiyi arikirimi awuta ngini wuta wutawa.” Awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purruwuriyi kapi Jerusalem. Karri wuta papi pirimi awungarruwu api wuta purruwuriyi kapi awinyirra arikulanga jurra angi-wutawa Jews. Awungarruwu kapi awarra yard kapi awinyirra jurra api ngawa-yuwuni yuwunyayi yingampa tiwi kapi pirripamangi animuluwi nginingaji pulukuwi amintiya sheepuwi amintiya awanuwanga tokampuwi nginingaji mwapurawayi (dove birds). Awuta tiwi sellim pirimi awuta animuluwi amintiya tokampuwi kapi awuta arikutumunuwi kapi wuta punuwuriyi kapi awinyirra jurra ngini pimata-kuruwarni (thank) ngawa-rringani ngini kuriyuwu. Karri awuta arikutumunuwi purruwunga awuta animuluwi amintiya tokampuwi api wuta pirimarruriyi awuta animuluwi amintiya tokampuwi kangi awarra priest ngini ngarra yimata-pirni awuta amintiya ngini yimatawumi wuta kapi ngawa-rringani ngini-ngatawa altar. Yingampa tiwi kapi wuta pirripamangi kunawuni api wuta wiyarri waki pirimani awungarruwu kapi awarra yard. Kiyi karri ngawa-yuwuni yuwunyayi awuta tiwi kapi sellim pirimi animuluwi awungarruwu kapi awinyirra jurra api angatawa yiminga jurrumumi jiyimi (became angry) kiyi yimi kapi awuta tiwi, “Nyirra-mwari angawula jurra. Pirri! Nyirru-wariyi!” yimi api awuta tiwi purrupumwari awarra yard ngini awungarruwu kapi awinyirra jurra. Ngarra awanuwanga, “Pirri!” yimi kapi awuta tiwi kapi pirripamangi kunawuni kapi awinyirra jurra. Kiyi ngawa-yuwuni yuwunyawu ngini-wutawa tayipuli kangi yakuluwuni. Amintiya awuta kapi sellim pirimi (sold) awarra mwapurawayi api awanuwanga ngarra yuwunyawu ngini-wutawa tayipuli kangi yakuluwuni. ");
INSERT INTO tiw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Amintiya kapi awarra yard ngini awungarruwu kapi awinyirra jurra api wutatuwu yingampa arikutumunuwi purru-wujirr-angulimayani kangi kirijinga jarrumoka api wuta pirripakuturruwa arramu-kaminawuti ngini sellim pimatami awarra arramu-kaminawuti. Api ngawa-yuwuni yuwunjarl-amuwi (stopped) awuta arikutumunuwi kiyi yimi kangi wuta, “Awi. Ngajiti ngimpaja-kuturruwa arramu-kaminawuti awungarra kapi jurra. Nyirra-mwari awarra arramu-kaminawuti karrampi,” yimi ngawa-yuwuni kangi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kiyi ngawa-yuwuni yimi kapi awuta tayikuwapi arikutumunuwi, “Awi, yati prophet parlingarri yikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) awarra naki ngirramini ngini ngarra ngawa-rringani yuwutiyarra ngarra, awarra ngirramini ngini (about) anaki jurra angi awungarra kapi Jerusalem api ngawa-rringani yimi ngini, ‘Anaki jurra api ngiya angilawa kurrampali awinyirra api tayikuwapi arikutumunuwi wiyi wunuwuriyi kangi anaki jurra ngini pray pimatami kangi ngiya. Awuta arikutumunuwi kapi japuja wurimi kapi yingarti murrakupuni api wuta wiyi wunuriyi kapi awinyirra anaki jurra, awuta kapi Jews amintiya awanuwanga awuta kapi arnuka Jews,’ yimi ngawa-rringani kapi awarra prophet parlingarri.” Awarra yimi ngawa-yuwuni kangi awuta arikutumunuwi. Kiyi ngarra yimi ngini, “Nuwa karluwu ngimpiri-pungintayi (respect) anaki jurra, nuwa kapi sellim ngimpirimi animuluwi amintiya tokampuwi awungarra kapi anaki jurra amintiya nuwatuwu awanuwanga nuwa kapi ngimpamangi kunawuni awungarra. Amintiya karri nuwa sellim ngimpirimi awuta animuluwi amintiya tokampuwi api nuwa ngumpunga yingarti kunawuni api awarra nuwa nginingaji mitayuwi,” yimi ngawa-yuwuni kangi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","19","Kiyi karri yartijanga yima ngawa-yuwuni amintiya ngarra-mamanta purrupumwari Jerusalem. Kiyi awuta priests kapi wuta alawuruwi amintiya awuta scribes wuta piri-pitingaya (heard) ngini ngawa-yuwuni yikirlimirri (growled at) awuta tiwi kapi sellim pirimi awuta animuluwi kapi awinyirra arikulanga jurra amintiya ngini ngarra yuwuntiyarra awuta tiwi ngini pimata-marruriyi awuta animuluwi kapi nyoni murrakupuni (place). Api awuta priests amintiya awuta scribes nimarra pirimajirri ngini, “Ngawa awungana ngamatama ngini pajuwani ngamata-kirimi awarra Jesus?” pirimi. Wuta awarra pirripangiraga pili wuta pirimakirri ngawa-yuwuni pili tayikuwapi arikutumunuwi karri wuta piri-pitingaya-mini (used to hear) awarra ngirramini ngini ngawa-yuwuni yipangiraga-mini api wuta kukunari pirimani kangi awarra ngirramini amintiya pirimi, “Ngarra warntirrana pupuni apangiraga awarra naki Jesus,” pirimi awuta tayikuwapi arikutumunuwi. Api awuta priests kapi wuta alawuruwi amintiya awuta scribes pirimajirri ngini, “Arramukuta awuta arikutumunuwi wiyi karluwu kuwa pimatami awarra ngirramini ngini ngawa ngapangiraga amintiya wiyi jirti ngirramini (trouble) wupakirayi ngawa,” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kiyi yingampa Sadducees punuwuriyi kapi ngawa-yuwuni Jesus api wuta pirimajirri. Kiyi yati tini ngini ngarra waki yimi ngini yuwunu-waluwa (taught) awuta tiwi ngini-ngatawa Moses ngirramini (law) api ngarra awarra yinuwuriyi kangi wutawa. Ngarra yipitingaya (heard) ngawa-yuwuni ngini pupuni yipangiraga kapi awuta Sadducees api ngarra yimi kapi ngawa-yuwuni, “Ngawa Jews ngapakuturruwa (hold onto) yingarti ngirramini (laws) api nginuwani warntirrana (most important) ngini ngawa ngamata-kuturruwa awarra ngirramini?” Ngarra awarra yipangiraga awarra tini kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Api ngawa-yuwuni yimi ngini, “Awarra Moses parlingarri yuwuntiyarra ngawa-maninguwi awarra naki ngirramini ngini ngarra (it) warntirrana (most important) api yimi ngini, ‘Awi, awarra naki ngirramini warntirrana ngini ngawa ngawurra-pungintayi (must think about) ngawa-rringani ngini kuriyuwu amintiya puranji ngawurra-muwu (must love) ngatawa. Ngawa warntirrana puranji ngawurra-muwu awarra ngawa-rringani. Awarra ngirramini warntirrana. Ngarra waya yati ngatawa ngawa-rringani. Ngawa-alawura awarra ngawa awuta kapi ngawa murrakupuni Israel.’ Ngarra awarra yipangiraga Moses,” yimi ngawa-yuwuni kangi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kiyi tuwanga yimi ngini, “Naki nyoni ngirramini awanuwanga warntirrana ngini ngawa puranji ngawurra-muwu ngawa-mamanta. Ngawa puranji ngarimuw-amiya amintiya ngapamang-amiya api ngawa awanuwanga puranji ngawurra-muwu ngawa-mamanta amintiya ngawurra-mangi awuta. Awarra yirrara ngirramini warntirrana. Ngarratuwu nyoni ngirramini (other laws) karlu-nara.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra tini ngini yuwunu-waluwa (taught) ngini-ngatawa Moses ngirramini kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purrupumwari awinyirra arikulanga jurra api karri papi pinirimi (came out) kapi awinyirra jurra api yati awarra ngarra-mantani yimi kangatawa, “Aya, mantani,” yimi. “Tayakuluwunyi anaki jurra. Nyirra warntirrana pupuka amintiya awinyirra anaki waranga angi pirikirimi anaki jurra api nyirra warntirrana arikulanga awinyirra waranga.” ");
INSERT INTO tiw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Api ngawa-yuwuni yimi ngini, “Kuwa. Tani-waya (no matter) ngini anaki jurra warntirrana arikulanga amintiya nyirra pupuka awinyirra api awinyirra anaki jurra karluwu yiloti jimata-muwu awungarra. Yita awuta kapi wuta aripi wiyi wupamartuwuni anaki jurra api anaki arikulanga waranga wiyi wangatajirri ampirimuwu kapi yakuluwuni.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kiyi ngawa-yuwuni amintiya ngarra-mamanta purruwuriyi kuriyuwu kapi awarra arikulani jupunyini (mountain). Awarra jupunyini ngarra yintanga Mount of Olives. Awungarruwu wuta purumuwu api pirripakuluwunyi awinyirra jurra. Kiyi karri ngarra ngawa-yuwuni wangata yimuwu api awuta yukurri ngarra-mamanta purruwuriyi kangatawa, awuta Peter amintiya James kiyi John amintiya Andrew api nanginta pirimi awarra ngawa-yuwuni, ");
INSERT INTO tiw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Wuta wiyi awungarri awuta kapi wuta aripi wupakirayi ngawa arikutumunuwi awarra jirti ngirramini (trouble)? Amintiya kamini awarra mirrikili (miracle) ngini ngarra ngawa-rringani wiyi arikirimi api ngawa wiyi awungarri ngarimajawu ngini awarra jirti ngirramini waya yinkitayi papi arimi kangi ngawa murrakupuni?” Wuta awarra nanginta pirimi ngawa-yuwuni awuta yukurri ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Api ngawa-yuwuni yimi ngini, “Arnapa. Pakinya nguwutiyarra nuwa ngini karri ngiya wiyi ngipakupawurli kuriyuwu kapi ngiya-rringani api wuta yingampa tiwi wiyi yatatila wuriyi kangi nuwula api kunyani wurimi kangi nuwa, ‘Nuwa ngimpiri-majawu ngini ngarra ngawa-rringani parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (would send) awarra Christ kapi nuwa arikutumunuwi. Api ngiya awarra Christ.’ Wuta wiyi awarra wurimi, awuta tiwi kapi wiyi wuri-mamuliya wutalamiya Christ. Api tayikuwapi arikutumunuwi wiyi kuwa wurimi awarra ngirramini ngini awuta tiwi wupangiraga. Api nuwatuwu arrana. Ngajiti kuwa ngimpajami awuta.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta yukurri ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kiyi nyoni naki ngirramini yipangiraga ngawa-yuwuni, “Karri ngiya wiyi awungarruwu kapi ngiya-rringani api wiyi yingarti jirti ngirramini (trouble) papi arimi kapi awarra naki murrakupuni (to this earth). Nuwa wiyi ngimpiri-pitingaya (hear) ngini yingampa (some) arikutumunuwi waya wujingi-warri (war) amintiya awanuwanga ngimpiri-pitingaya ngini wuta yingampa (other) arikutumunuwi waya arrami yinkitayi wuruwarri. Api karri nuwa ngimpiri-pitingaya awarra ngirramini api ngajiti ngimpaja-wanga. Awarra warntirrana ngini wuta wiyi wuruwarri api karluwu naki murrakupuni apapaya nanuwanga wutiyati yirrakunga (sky). ");
INSERT INTO tiw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Awuta tiwi kapi wuta wurumuwu kapi yati murrakupuni api wiyi wuruwarri (fight) awuta tiwi kapi wuta nyoni murrakupuni. Amintiya kapi yingampa (some) timani api wiyi awungaji murrakupuni apukinapumiya (earthquake) amintiya awanuwanga kapi yingampa (other) murrakupuni karri-kamini pakitiringa wiyi apungoli api nyirra wiyi wupunga pajuwani ampirimi api awanuwanga animuluwi wiyi pajuwani wurimi api wuta tiwi wiyi paruwani wurimi pili karri-kamini yinkiti.” Ngarra awarra yipangiraga ngawa-yuwuni. Kiyi yimi ngini, “Awarra nayi jirti ngirramini (trouble) ngini wiyi papi arimi kapi nuwa arikutumunuwi api kiyija-nara awarra jirti ngirramini api wiyi parlinginari (later) arikulani ngirramini (trouble) papi arimi kapi nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta yukurri ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kiyi ngawa-yuwuni Jesus nyoni naki ngirramini yipangiraga kapi ngarra-mamanta, api yimi, “Yati tini ngini ngarra arini wiyi awunu-wuriyi kapi Jerusalem. Ngarra wiyi awuriyi kapi angawula arikulanga jurra api awungarruwu arimarruriyi yilaruwu arramu-kamini ngini jirti api awungaji apumwari awarra ngini jirti. Ngarra warntirrana jirti awarra arramu-kamini. Api awuta tiwi kapi wuta japuja kapi awarra naki murrakupuni Judea api karri wiyi wupakuluwunyi awarra arramu-kamini ngini jirti awungarruwu kapi jurra api wuta kalikali wurra-makirrimi (must run) karrampi kapi jupunyini (hills). ");
INSERT INTO tiw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Amintiya awuta tiwi kapi wuta wujingi-muwu kapi wuta japuja kapi turruwuni api wuta ngajiti wupawuriji yilaruwu kangi wuta kurrampali. Ngajiti wunga ngini-wutawa yinkiti amintiya arramu-kaminawuti. Yita wurra-mwari (must leave) kapi japuja awarra ngini-wutawa arramu-kaminawuti. Waya juwa kalikali wurra-makirrimi. ");
INSERT INTO tiw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wutatuwu yingampa tiwi karri wiyi wuri-pitingaya (hear) ngini (about) awarra tini ngini arini api wuta wiyi awungarri waki wujingimi kapi ngini-wutawa garden kapi warta api wuta ngajiti wupakupawurli japuja. Ngajiti wunga ngini-wutawa tawulimutinga (blanket). Waya juwa kalikali wurra-makirrimi kapi jupunyini (hills). ");
INSERT INTO tiw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Api karri awuta tayikuwapi tiwi kalikali wurimakirrimi kapi jupunyini pili awarra arramu-kamini ngini jirti arimuwu kapi jurra api awungarri wuta nguri awuta maminikuwi kapi wuta papuringantuwi amintiya awuta yingampa kapi wuta-mwaruwi nanuwanga (still) pularti wurimangapa pili wuta awuta maminikuwi wiyi karluwu kalikali pimatami (won't be able to run) yirrimala kapi awarra jupunyini.” Awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kiyi ngawa-yuwuni nyoni yimi kapi ngarra-mamanta, “Nanginta nyirrami ngawa-rringani ngini awarra jirti ngirramini (trouble) karluwu papi yimatami (won't come) karri pakitiringa pili arramukuta yingarti pakitiringa wiyi apungoli api kiyi yingarti kukuni wiyi alala arimi kapi makatinga api nuwa awarra karluwu nginti-mat-atuwala (won't be able to cross over) awinyirra makatinga. Api nanginta nyirrami ngawa-rringani ngini putuputuwu apakirayi nuwa ");
INSERT INTO tiw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","pili awarra jirti ngirramini ngini wiyi papi arimi kapi nuwa arikutumunuwi api warntirrana arikulani awarra jirti ngirramini. Awarra ngirramini ngini parlingarri papi yimi karri ngawa-rringani mampara yikirimi murrakupuni right through ningani api karlu-nara awarra arikulani. Api karri awarra naki jirti ngirramini wiyi apapaya (finishes) api wiyi karluwu nyoni jirti ngirramini papi yimatami nginingaji awarra arikulani jirti ngirramini. Yita awarra nyoni ngirramini ngini wiyi yintayi papi arimi api ngarra wiyi kiyija-nara awarra.” Ngarra awarra ngawa-yuwuni yipangiraga kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kiyi yimi ngawa-yuwuni ngini, “Awarra naki jirti ngirramini (trouble) ngini wiyi papi arimi kapi nuwa arikutumunuwi api karluwu yinukuni awarra ngirramini pili ngawa-rringani, awarra ngini ngarra ngawa-alawura, api parlingarri ngarra yimi ngini wiyi karluwu yinukuni yimatama awarra ngirramini pili ngini (if) yinukuni yimatama awarra jirti ngirramini api nuwa tayikuwapi arikutumunuwi wiyi pajuwani nginti-matami (would die). Api ngarra karluwu ngawa-rringani awutimarti ngini awarra ngirramini yinukuni yimatama pili ngarra aripungintayi (thinks about) awuta tiwi kapi ngarra parlingarri yuwunga (picked) awuta api yimi ngini ngarra wiyi yimata-mamula (would call) awuta ngarra-mamirampi. Ngarra ngawa-rringani aripungintayi awuta tiwi api wiyi arikirimi awarra arikulani ngirramini (trouble) ngini yartipili yimata-paya (finish).” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kiyi naki nyoni nimarra yimi ngawa-yuwuni, “Karri ngiya wiyi ngipakupawurli kapi ngiya-rringani api arrami yingampa tiwi wiyi wuriyi kangi nuwula api pirlamarri (not knowing) wurimi ngini, ‘Awi, nyirra-kuluwunyi naki awarra ngini ngarra awunu-wuja api ngarra awarra Christ. Ngawa-rringani yini-pangirri (sent) awarra kapi ngawa,’ wurimi wiyi awuta yingampa. Api nuwa ngajiti kuwa ngimpajami awuta tiwi. Kiyi arrami wiyi wurimamaki (point to) nyoni tini api wurimi ngini, “Nayi awuja api ngarra awarra Christ ngini ngawa-rringani yini-pangirri kapi ngawa.” Ngini awarra wurimi kangi nuwula api ngajiti kuwa ngimpajami awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wutatuwu wiyi yingampa (other) tiwi papi wujingimi (keep coming) kapi nuwa murrakupuni api kunyani wurimi kapi nuwa ngini ngarra ngawa-rringani yini-pangirri awuta kapi nuwa. Amintiya wutatuwu yingampa tiwi wiyi nimarra wurimi kapi nuwa api kunyani wurimi ngini awarra ngirramini ngini wuta wupangiraga api ngini-ngatawa ngawa-rringani ngirramini awarra. Wuta wiyi awuta tiwi mirrikili (miracles) wurikirimi api kunyani wurimi ngini ngarra ngawa-rringani yipakirayi awuta ngini-ngatawa power ngini wurikirimi awarra mirrikili api nuwa kapi ngawa-rringani arimamula (calls) nuwa ngarra-mamirampi api arrami nuwa wiyarri wiyi kuwa ngimpirimi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Api arrana pili ngiya waya ngurru-wutiyarra nuwa ngini (about) awuta tiwi kapi wiyi wuri-mamuliya wutamiya ngini wuta Christ.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Kiyi ngawa-yuwuni Jesus yipangiraga nginaki nyoni ngirramini kapi ngarra-mamanta, “Awarra ngirramini ngini ngurru-wutiyarra nuwa ngini awarra jirti ngirramini (trouble) ngini wiyi papi arimi kangi nuwa arikutumunuwi api ngarra pakinya papi arimi awarra ngirramini api kiyi awinyirra warnarringa amintiya awarra japarra wiyi arnuka ngirri-ngirri api yartijanga kapi awarra naki murrakupuni. Kiyi awinyirra yingarti japalinga wiyi apakupuraji kapi yakuluwuni. ");
INSERT INTO tiw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kiyi ngiya wiyi awungarri papi nguwuniri-mi (come out) kapi yirrakunga (clouds) api nguwuni-papirraya (come down) kapi naki murrakupuni (to this earth) api awuta arikutumunuwi kapi wuta nanuwanga (still) yimpanguwi wurimi karri ngiya wiyi nguwuni-pakupawurli (come back) kapi awarra naki murrakupuni api wuta awuta wiyi wupakuluwunyi ngiya karri ngiya wiyi nguwuni-papirraya. Ngiya wiyi awungarri ngirri-ngirri ngirimi amintiya awanuwanga yingarti power nguwuni, ngiya awarra ngini nuwa-yuwuni nuwa tayikuwapi (all) arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Api kiyi awuta angeluwi kapi wuta waki wurimi ngini (for) ngiya api ngiya wiyi ngipangirri (send) awuta angeluwi kapi tayikuwa-ni (every) murrakupuni api awuta tiwi kapi ngarra ngiya-rringani parlingarri yuwunga (picked) wuta ngini wiyi yimata-mamula (call) awuta ngarra-mamirampi api awuta angeluwi wiyi wuniri-marruriyi (bring) awuta tiwi kapi ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","33","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purruwuriyi kapi awarra murrakupuni (place) kapi awungarruwu yingarti purinjirringuwi. Wuta pirimamula (called) awarra murrakupuni Gethsemane. Karri wuta papi pirimi awungarruwu api ngarra ngawa-yuwuni nimarra yimi kangi ngarra-mamanta, api yimi ngini, “Awi, ngiya aringampi-nara nguwuja ngini pray ngirimi kapi ngiya-rringani. Nuwa yuwurrajirrima Peter amintiya James amintiya John nyirru-waripa api ngawurniyi aringampi-nara. Api nuwatuwu yingampa awungarra nyirra-muwu,” yimi ngawa-yuwuni kangi ngarra-mamanta. Kiyi ngawa-yuwuni amintiya awuta yuwurrajirrima ngarra-mamanta Peter amintiya James amintiya John wutiyati purruwuriyi aringampi-nara. Awungarruwu ngawa-yuwuni worry yimi amintiya ngarra jirti yimi kapi ngarra punyipunyi amintiya ngarra ruwuti. ");
INSERT INTO tiw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Api yimi kangi awuta yuwurrajirrima, “Ngiya waya jirti purnikapa nguwuni. Yita nginingaji ngiya waya yinkitayi pajuwani ngirimi. Nuwa awungarra arnapa nyirra-muwu api ngajiti ngimpaja-majirripi,” yimi kangi awuta yuwurrajirrima ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Kiyi ngawa-yuwuni yipumwari awuta ngarra-mamanta kiyi yuwuriyi karrampi-nara kiyi yuwunyaw-amiya kangi yakuluwuni api yimi kangi ngawa-rringani, “Aya, ngirringani, ngiya ngirimajawu ngini kuta kamini awarra ngini nginja nimpitimarti ngini jimata-kirimi (to do) api nginja awarra warntirrana jimata-kirimi api tawunjarl-amuwi (stop them) awuta jajiruwi tiwi kapi wuta wutimarti ngini pimata-pirni ngiya. Api ngini nginja nimpitimarti awuta jajiruwi tiwi ngini pimata-pirni ngiya api awarra waya rayiti (alright). Nginja manya takirimi (do) kuta kamini awarra ngini nginja nimpitimarti.” Awarra ngawa-yuwuni yuwutiyarra ngarra-rringani ngini kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kiyi ngawa-yuwuni yipukularri kiyi yipakupawurli kapi awuta yuwurrajirrima ngarra-mamanta. Ngarra yuwunyayi awuta purru-wujingi-majirripani. Kiyi ngarra yimi kangi awarra Peter ngini, “Aya, mantani. Pilikama nimpiri-majirripi? Ngiya ngurru-wutiyarra nginja ngini kiyija jimata-muwu (should wait) amintiya ngini arnuka jimata-majirripi,” yimi ngawa-yuwuni kangi awarra Peter. ");
INSERT INTO tiw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kiyi ngawa-yuwuni yimi kangi awuta yuwurrajirrima, “Awi, ngajiti tuwanga ngimpaja-majirripi. Waya juwa nanginta nyirrami ngawa-rringani ngini yimata-wani (help) nuwa ngini karluwu kuwa nginti-matami awarra maputiti. Ngiya ngirimajawu ngini nuwa warntirrana ngimpitimarti ngini kuwa nginti-matami awarra ngirramini ngini ngiya ngurru-wutiyarra nuwa, api waya juwa nuwa warntirrana janawurti. Api arnapa nyirra-muwu awungarra. Ngajiti ngimpaja-majirripi. Waya juwa nanginta nyirrami ngawa-rringani ngini yimata-wani nuwa,” yimi ngawa-yuwuni kangi awuta yuwurrajirrima ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kiyi ngawa-yuwuni tuwanga yuwuriyi karrampi-nara amintiya yipangiraga awarra-wanga (same) ngirramini kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kiyi ngarra tuwanga yipakupawurli kangi awuta yuwurrajirrima api ngarra tuwanga yuwunyayi awuta purru-wujingi-majirripani pili wuta janawurti. Karri ngarra yipangipariyi (woke them up) awuta api wuta arnuka nimarra pirimi kangatawa pili wuta arliranga. Kiyi ngawa-yuwuni tuwanga yuwuriyi karrampi-nara. ");
INSERT INTO tiw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kiyi karri tuwanga yipakupawurli kapi awuta yuwurrajirrima ngarra-mamanta api nanginta yimi awuta, “Pilikama nuwa nanuwanga (still) ngimpijingi-majirripi? Ngajiti tuwanga ngimpaja-majirripi pili awuta jajiruwi tiwi waya yinkitayi wunu-wuja ngini pimatanga ngiya. Ngawa-mantani ngini ngarra wiyi traitor arimi kangiya api ngarra awuni-maja awuta tiwi api wuta wiyi wunga ngiya, ngiya awarra nuwa-yuwuni nuwa awuta tayikuwapi arikutumunuwi. Kiyi awuta tiwi wiyi wurimarruriyi ngiya kapi awuta jajiruwi alawuruwi.” Awarra yimi ngawa-yuwuni kapi awuta yuwurrajirrima ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kiyi tuwanga yimi kangi wutawa, “Kutupi nyirrami pili waya ngawuja ngapapijingi (meet) awarra ngawa-mantani ngini wiyi apakirayi ngiya kapi awuta jajiruwi tiwi,” yimi ngawa-yuwuni kangi wuta. ");
INSERT INTO tiw_vpl VALUES ("MK15_16b","071_15_16b","MRK","15","16b","16b","Kiyi awuta soldiers kuwayi pirimi kangi tayikuwapi wuta-mamanta kapi awuta yingampa soldiers api pirimi kangi wutawa, “Nyirru-waripa,” pirimi. Kiyi awuta tayikuwapi soldiers punuwuriyi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kiyi yingampa awuta soldiers tikimati pirimi ngawa-yuwuni angatawa kuluji kiyi pirripamukuri kangatawa natinga yurruka kuluji angi yaringari. Awinyirra kuluji angi yaringari api nginingaji awinyirra angi wuta alawuruwi purukuripiya (wore) awinyirra. Wuta pirripamukuri awinyirra kuluji angi yaringari kapi ngawa-yuwuni pili wuta pirimi ngini, “Ngarra manya arimamuliya alawura,” pirimi. Kiyi wutatuwu yingampa soldiers purruwunga arlipurringa angi murrupun-awurti (vine with thorns) api pirikirimi awinyirra nginingaji arntuma. Wuta kunyani pirikirimi awarra arntuma nginingaji kapi wuta alawuruwi ngini-wutawa arntuma. Kiyi wuta pirripamukuri awarra arntuma kangi ngawa-yuwuni ngarra pungintaga. ");
INSERT INTO tiw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kiyi awuta soldiers kunyani pirimamula (called) ngawa-yuwuni alawura api pirimi ngini, “Aya, nginja awarra king kapi awuta Jews. Ngawa ngawutimarti nginja ngini yinukuni jimata-muwu,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kiyi awuta soldiers purruwunga tangini kiyi piripirni ngawa-yuwuni kapi ngarra pungintaga. Api wuta yimpaja piripirni ngarra. Kiyi wuta juwarti purruwunyawu kangatawa amintiya pirripamukuri ngini-wutawa yirrara yimpula kangi yakuluwuni (knelt down) kapi ngawa-yuwuni tayinti yimi api pirimi ngini, “Yita nginja warntirrana ngatawa.” Wuta awarra kunyani pirimi. ");
INSERT INTO tiw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kiyi awuta soldiers karri pirripapaya ngini pirripaparri (humbugged) ngawa-yuwuni api awungarri wuta tikimati pirimi awinyirra kuluji angi yaringari kiyi tuwanga pirripamukuri angatawa kuluji kangatawa. Kiyi wuta pirimi kapi ngawa-yuwuni, “Takuturruwa niyi awarra arikitirropurtayi (cross),” pirimi. Kiyi ngawa-yuwuni yipakuturruwa awarra arikitirropurtayi. Kiyi awuta soldiers pirimarruriyi ngarra awungarruwu kapi jupunyini (hill) ngini pajuwani pimata-kirimi ngarra kangi awarra arikitirropurtayi. ");
INSERT INTO tiw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Kiyi karri Sunday karri awinyirra warnarringa mampara jini-papurti api awinyirra Mary Magdalene amintiya awinyirra Salome kiyi awinyirra nyonga Mary angi nyirra-mwarti James wuta purruwuriyi kapi awarra cave pili-ngini pimata-mukuri awarra mirrijini (ointment) kangi ngawa-yuwuni ngarra purnikapa. ");
INSERT INTO tiw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Karri wuta purruwuja api pirimajirri ngini, “Kuwapi wiyi wupangirri (push away) awinyirra arikulanga waranga angi wuta kunji pirikirimi yangamini kapi awarra cave?” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Api karri wuta papi pirimi awungarruwu kapi awarra cave api wuta pirripakuluwunyi ngini awinyirra arikulanga waranga waya karluwu kunji jiyikirimi awarra yangamini kapi awarra cave. ");
INSERT INTO tiw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Karri wiyi naki murrakupuni apapaya (the world will finish) api ngiya-rringani wiyi judge arimi tayikuwapi (all) arikutumunuwi. Api awuta tiwi kapi kuwa wurimi ngini-ngilawa ngirramini api wuta yingampa waya baptise pirikirimi awuta tiwi api awuta tiwi wiyi japuja kuriyuwu kapi ngiya-rringani. Api wutatuwu yingampa kapi karluwu kuwa wurimi awarra pupuni ngirramini ngini-ngilawa api ngiya-rringani wiyi arimamula (call) awuta jajiruwi api wiyi apangirri (send) awuta kapi awarra yikwani kapi awarra maputiti wiyi japuja arimi (hell). ");
INSERT INTO tiw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Awuta tiwi kapi kuwa wurimi ngini-ngilawa ngirramini api wuta awuta wiyi mirrikili (miracle) wurikirimi. Wuta wiyi awuta tiwi papi wuniri-mamiyi (bring out) awuta maputirruwi kapi wuta wupalamiya kapi yingampa tiwi ngini-wutawa purnikapa. Amintiya awuta tiwi kapi kuwa wurimi ngiya wiyi awanuwanga wupamukuri ngini-wutawa yikara kapi wuta pungintaga awuta tiwi kapi wuta jana api wuta wiyi pupuwi wurima awuta tiwi. Amintiya awanuwanga wuta wiyi wupangiraga nyoni langwiji ngini wuta nimarra wurimi awuta tiwi kapi wuta wurumuwu kapi nyoni murrakupuni. Api yingampa tiwi karri wupakuluwunyi awuta tiwi karri wuta wurikirimi awarra mirrikili api wuta awungarri wiyi awuta yingampa tiwi wurimajawu ngini ngarra ngawa-rringani yipakirayi awuta tiwi yingarti power. Awarra ngawa-rringani wiyi awanuwanga apamangi awuta tiwi kapi kuwa wurimi ngini-ngilawa ngirramini api ngini (if) awuta tiwi kapi kuwa wurimi ngini-ngilawa ngirramini wiyi pirlamarri (by accident) wunga taringa api ngini awinyirra taringa awunu-wirri (bites) awuta tiwi api wuta wiyi karluwu jana pimatama. Amintiya ngini wuta pirlamarri wurimangapa ngini pajuwani-kimi (poison) api wuta wiyi karluwu jana.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kiyi awuta ngawa-yuwuni ngarra-mamanta purruwuriyi kapi yingarti murrakupuni api purru-wuntiyarra awuta arikutumunuwi ngini-ngatawa ngawa-yuwuni ngirramini. Api ngawa-yuwuni awarra ngini ngarra alawura kapi ngawa api yipakirayi awuta ngarra-mamanta power api wuta mirrikili (miracle) piri-kirim-ani. Api awuta arikutumunuwi karri pirripakuluwunyi awuta ngawa-yuwuni ngarra-mamanta ngini mirrikili piri-kirim-ani api wuta awungarri kuwa pirimi ngini awarra ngirramini ngini-ngatawa ngawa-yuwuni api ngarra warntirrana awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Parlingarri karri King Herod alawura yimi kapi awuta tayikuwapi arikutumunuwi kapi awarra murrakupuni Judea api kapi awarra timani yati tini yimuwu ngini ngarra yintanga Zechariah. Awarra Zechariah amintiya yingampa (some) ngarra-ngirimipi api wuta priests api wuta yingampini (sometimes) wutiyati waki pirimani kapi awinyirra arikulanga jurra (temple) angi-wutawa Jews awungarruwu kapi Jerusalem. Wuta-amini ngarra priest api awarra yintanga awarra Abijah. Api kapi awinyirra jurra awuta tayikuwapi Jews puru-kuruwarn-ani (thanked) ngawa-rringani ngini kuriyuwu. Ngarra awarra Zechariah api ngarra-purnayinga nyirra yintanga Elizabeth. ");
INSERT INTO tiw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ngarra ngawa-rringani ngini kuriyuwu pupuwi yimamula (called) awarra Zechariah amintiya ngarra-purnayinga Elizabeth, pili wuta warntirrana kuwa pirimani ngini-ngatawa ngirramini (law) ngini ngarra yipakirayi Moses parlingarri. ");
INSERT INTO tiw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Awarra Zechariah amintiya awinyirra Elizabeth api wuta waya wulimawi. Wuta karluwu purruwuni kakirijuwi pili awinyirra Elizabeth nyirra palimaringa. ");
INSERT INTO tiw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","10","Karri awuta priests waki pirimani kapi awinyirra jurra api nginingaji ngatawa wumunga (every day) wuta purruwunga (picked) yati priest ngini ngarra yimata-wuriji yilaruwu kapi awinyirra jurra pili-ngini jurrumumi yimata-kirimi arramu-kamini kapi awarra altar, awarra arramu-kamini ngini-ngatawa kumurrupuni aruwanti pupuni (incense). Karri awarra priest yipawuriji yilaruwu kapi awinyirra jurra api awuta yingampa tiwi wuta mimpa pirimi turruwuni kangi awinyirra jurra amintiya wuta pray pirimi kapi ngawa-rringani. Awarra Zechariah amintiya ngarra-ngirimipi kapi wutiyati wuta-amini awarra Abijah api karri natinga wumunga (one day) karri wuta waki pirimi kapi jurra api wuta purruwunga (picked) awarra Zechariah ngini ngarra yimata-wuriji yilaruwu kapi jurra pili-ngini ngarra jurrumumi yimata-kirimi awarra arramu-kamini. ");
INSERT INTO tiw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Karri awarra Zechariah yipawuriji yilaruwu kapi jurra api ngawa-rringani yini-pangirri (sent) yati yingumpunila (angel) kapi awarra Zechariah. Karri awarra yingumpunila papi yimi awungarruwu kapi awarra Zechariah api ngarra tayinti yimi kapani aripa kapi awarra altar kapi ngarra Zechariah jurrumumi yikirimi awarra arramu-kamini. ");
INSERT INTO tiw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Api karri Zechariah yipakuluwunyi awarra yingumpunila api ngarra yikutupa (got a shock) amintiya yimakirri. ");
INSERT INTO tiw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Api ngarra yingumpunila yimi ngini, “Aya, Zechariah, ngajiti nimpaja-wanga ngiya! Nginja waya yimpaja nanginta jiyimani ngawa-rringani ngini ngarra yimata-kirayi nginja kirijini api ngarra waya yipitingaya (heard) nginja, api nyirra nginja-purnayinga Elizabeth wiyi ampurtiyi kirijini. Nginja wiyi nimpakirayi awarra kirijini yintanga John,” yimi awarra yingumpunila kapi awarra Zechariah. ");
INSERT INTO tiw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Kiyi awarra yingumpunila yimi ngini, “Karri nginja-mirani wiyi arimulungurrumi api ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) wiyi apawuriji yilaruwu kapi awarra kirijini. Nginja amintiya nginja-purnayinga nuwa wiyi kukunari ngimpirimi kangi awarra nginja-mirani karri ngarra wiyi arimulungurrumi amintiya tayikuwapi arikutumunuwi wiyi awanuwanga kukunari wurimi kangi ngarra. Api ngawa-rringani wiyi arimamula (call) ngarra ngatawa awarra nginja-mirani. Ngarra wiyi awarra nginja-mirani arnuka yimata-mangapa mirripaka amintiya wine,” yimi awarra yingumpunila (angel) kangi awarra Zechariah. ");
INSERT INTO tiw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","Kiyi awarra yingumpunila yimi ngini, “Ngarra ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) wiyi apakirayi nginja-mirani power nginingaji ngarra parlingarri yipakirayi power kapi awarra prophet Elijah. Ngarra awarra nginja-mirani wiyi awuntiyarra awuta tiwi kapi wuta Jews ngini pimata-punya ngawa-rringani angatawa pupuka jarrumoka pili ngarra awarra ngini ngarra warntirrana ngatawa awunu-wuja. Api tayikuwapi tiwi wiyi kuwa wurimi ngini-ngatawa ngirramini awarra nginja-mirani,” yimi awarra yingumpunila kapi Zechariah. Kiyi awarra yingumpunila nyoni nginaki yimi ngini, “Awuta tiwi kapi wiyi kuwa wurimi awarra nginja-mirani ngini-ngatawa ngirramini api wuta wiyi warntirrana pupuni wurumuwu kapi-wutawa kakirijuwi. Amintiya awuta tiwi kapi karluwu kuwa wurimi kangi ngawa-rringani api wuta wiyi pupuni punyipunyi wurimi nginingaji awuta kapi pupuwi api wuta wiyi awanuwanga kuwa wurimi kangi ngawa-rringani.” Ngarra awarra yingumpunila yipangiraga awarra ngirramini kapi Zechariah. ");
INSERT INTO tiw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kiyi awarra Zechariah yimi kapi awarra yingumpunila, “Awarra ngirramini ngini nginja jipangiraga ngini ngiya-purnayinga wiyi ampurtiyi ngiya-mirani, api arrami awarra ngirramini wiyi karluwu warntirrana yimatama pili ngawa wulimawi,” yimi Zechariah. ");
INSERT INTO tiw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Api ngarratuwu awarra yingumpunila yimi ngini, “Ngiya yintanga Gabriel. Ngiya waki ngirimi ngini ngawa-rringani ngini kuriyuwu api ngarra yini-pangirri (sent) ngiya awungarra ngini ngiya nguwutiyarra nginja nginaki pupuni ngirramini. ");
INSERT INTO tiw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nginja karluwu kuwa jiyimi awarra ngirramini ngini ngiya ngurru-wutiyarra nginja api nginja waya karluwu nimarra jimatami. Waya juwa karri nginja-mirani wiyi arimulungurrumi api awungarri ngawa-rringani wiyi arikirimi nginja ngini tuwanga nimarra jimatami pili wiyi awungarri awarra ngirramini warntirrana arima (come true) awarra ngirramini ngini ngiya ngurru-wutiyarra nginja,” yimi awarra yingumpunila kangi awarra Zechariah. ");
INSERT INTO tiw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Karri Zechariah nanuwanga (still) yilaruwu kangi jurra, api awuta yingampa arikutumunuwi wuta purru-wujingi-rritani (were standing) turruwuni. Wuta nimarra pirimajirri, “Pilikama ngarra awarra Zechariah karluwu papi awunirimi turruwuni kangi ngawa? Pilikama ngarra yinukuni yilaruwu?” Wuta awarra pirimajirri awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kiyi awarra Zechariah papi yinirimi turruwuni kiyi ngarra nimarra yuwarimi (tried to talk) kapi awuta arikutumunuwi api karluwu. Waya juwa sign yikirimi kangi wutawa. Api awuta arikutumunuwi pirimajirri, “Arrami ngarra yipakuluwunyi yingumpunila (angel) yilaruwu kapi jurra.” ");
INSERT INTO tiw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kiyi karri awarra Zechariah yipapaya ngini-ngatawa waki awungarruwu kapi Jerusalem api ngarra yuwuriyi kangatawa japuja. ");
INSERT INTO tiw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kiyi ngarra-purnayinga Elizabeth nyirra papuringanta jiyima kiyi nyirra pokumora jiyimuwu yinukuni yilaruwu kangi nyirra japuja nginingaji pinginingita wurlini (5 months). ");
INSERT INTO tiw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nyirra jiyimi kangi nyitamiya, “Karri pakinya ngiya palimaringa ngurumuwu api yingampa tiwi nimarra pirimajirri ngini ngiya palimaringa api ngiya arliranga api ningani ngiya waya karluwu arliranga pili ngawa-rringani putuputuwu yipakirayi (felt sorry for) ngiya api ngiya waya ningani karluwu palimaringa pili ngiya waya papuringanta ngirima. Awuta arikutumunuwi karri wiyi wupakuluwunyi ngini ngiya waya papuringanta api wuta wiyi kukunari wurimi kangi ngiya amintiya ngiya wiyi karluwu arliranga.” Awarra jiyimi awinyirra Elizabeth kangi nyitamiya. ");
INSERT INTO tiw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Kapi awarra town Nazareth awungarruwu kapi awarra arikulani murrakupuni Galilee api natinga murrukupora japuja jiyimi awungaji. Nyirra yintanga Mary. Api nyirra karluwu jiyimarrimili tini. Awarra nyirra-purnayi ngini nyirra promise api ngarra yintanga Joseph api wuta karluwu marriti pirimi nanuwanga. Api nyirra karluwu awanuwanga jiyimarrimili ngarra. Ngarra awarra Joseph ngarra-amini King David awarra ngini ngarra parlingarri yimuwu. Awinyirra Mary api nyirra-ngirimuka nyirra awinyirra Elizabeth. Kiyi karri awinyirra Elizabeth waya kiringarra wurlini (six months) papuringanta jiyimuwu api ngarra ngawa-rringani yini-pangirri (sent) awarra yingumpunila (angel) Gabriel kapi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Api awarra yingumpunila yipangiraga kapi awinyirra, “Aga,” yimi. “Ngarra ngawa-rringani ngini kuriyuwu awarra ngini ngarra ngawa-alawura api ngarra kukunari kapi nginja amintiya ngarra wiyi yimpaja aminyu-wani (help) nginja,” yimi awarra yingumpunila kangi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Api nyirra Mary karluwu jiyimajawu (understand) awarra ngini ngarra yipangiraga amintiya nyirra jiyimakirri. Nyirra jiyimi kangi nyitamiya ngini, “Pilikama awarra yimi awarra yingumpunila kangilawa?” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kiyi awarra yingumpunila yimi kapi awinyirra Mary, “Ngajiti nimpaja-wanga pili ngarra ngawa-rringani kukunari kapi nginja ");
INSERT INTO tiw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","api nginja wiyi papuringanta nimpirima kiyi nginja wiyi nimpurtiyi kirijini amintiya nginja wiyi nimpakirayi awarra kirijini yintanga Jesus. ");
INSERT INTO tiw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Awarra nginja-mwarti karri ngarra wiyi arikulani arima api ngarra wiyi ngatawa amintiya tayikuwapi arikutumunuwi wiyi wurimajawu ngini ngarra ngawa-rringani ngini kuriyuwu ngarra-mirani awarra. Amintiya ngawa-rringani yimi ngini awarra ngarra-mirani ngini nginja wiyi nimpurtiyi api ngarra wiyi alawura arimi nginingaji awarra King David,” yimi awarra yingumpunila Gabriel kapi awinyirra Mary. Awarra King David api parlingarri ngarra king yimi kapi awuta arikutumunuwi kapi tangarima pirimi kapi awarra murrakupuni Israel. ");
INSERT INTO tiw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kiyi awarra yingumpunila yimi kapi awinyirra Mary, “Nginja-mwarti wiyi yiloti alawura arimi kapi awuta tiwi kapi wutiyati wuta-amini Jacob, awuta kapi wuta ningani wurumuwu amintiya awuta kapi nanuwanga wunu-wuja.” Awarra yimi awarra yingumpunila kapi awinyirra Mary. Awarra Jacob ngarra nyoni yintanga Israel. ");
INSERT INTO tiw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kiyi Mary nanginta jiyimi awarra yingumpunila, “Awungana (how) ngini ngiya papuringanta ngimatama pili ngiya amintiya ngiya-purnayi karluwu marriti ngintirimi nanuwanga?” jiyimi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kiyi awarra yingumpunila yimi kangi nyitawa, “Ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) wiyi awuni-papirraya (come down) kangi nginja amintiya ngini-ngatawa power wiyi arikirimi nginja ngini papuringanta nimpirima. Api nginja-mwarti ngini wiyi arimulungurrumi api ngarra wiyi pupuni tini amintiya wuta arikutumunuwi wiyi wurimi ngini ngarra ngawa-rringani ngarra-mirani awarra ngini ngarra yatilani,” yimi awarra yingumpunila. ");
INSERT INTO tiw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kiyi ngarra yimi kapi awinyirra Mary, “Nyirratuwu nginja-ngirimuka Elizabeth angi nyirra waya wulikimaka api nyirra waya papuringanta pili ngarra ngawa-rringani waya yikirimi nginja-ngirimuka ngini nyirra waya karluwu palimaringa api karri yirrajirrima wurlini (3 months) nyirra wiyi ampurtiyi nyirra-mwarti. ");
INSERT INTO tiw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngarra ngawa-rringani ngini kuriyuwu ngarra yingarti power awuni (has) api kuta kamini ngini ngarra awutimarti ngini yimata-kirimi (do) api ngarra arikirimi (does) awarra kuta kamini,” yimi awarra yingumpunila (angel) kangi Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kiyi Mary jiyimi kapi awarra yingumpunila, “Ngiya warntirrana kuwa ngirimi ngawa-rringani awarra ngini ngiya-alawura api waya rayiti (alright) ngini ngiya wiyi nguwurtiyi awarra kirijini nginingaji nginja juwutiyarra ngiya,” jiyimi kangi awarra yingumpunila. Kiyi awarra yingumpunila yipumwari Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Kiyi Mary jipumwari nyirra japuja kiyi murruka juwuriyi kapi awarra town kapi awarra murrakupuni Judea awungarruwu kapi yingarti jupunyini (hills). Awungarruwu kapi awarra murrakupuni Zechariah japuja yimi wuturiyi ngarra-purnayinga Elizabeth api awinyirra Mary juwuriyi kapi ngini-wutawa japuja. Karri Mary papi jiyimi kapi ngini-wutawa japuja api jipawuriji yilaruwu kapi awinyirra Elizabeth jiyimuwu api jiyimi kangi nyirra, “Awungana mantanga?” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","44","Api karri awinyirra Elizabeth jiyipitingaya (heard) awarra ngini nyirra Mary jipangiraga api awungarri Elizabeth nyirra-mwarti kutupi yimi yilaruwu kangi nyirra pitipita amintiya ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) yipawuriji yilaruwu kangi Elizabeth nyirra punyipunyi api nyirra kukunari jiyimi api jingawu jiyimi makirrana kapi awinyirra Mary, “Pilikama nginja jinu-wuriyi awungarra kangilawa pili ngiya waya juwa wulikimaka api nginjatuwu awinyirra yimpalinya angi ngawa-rringani ngini kuriyuwu ngarra yuwunga (picked) nginja ngini nginja wiyi nimpurtiyi awarra kirijini ngarra-mirani pili ngarra kukunari kangi nginja,” jiyimi Elizabeth kangi Mary. Kiyi awinyirra Elizabeth jiyimi kapi Mary, “Karri nginja nimarra jiyimi kangilawa api ngiya-mwarti kukunari yimi api ngarra kutupi yimi yilaruwu kangi ngiya pitipita api awungarri ngiya ngirimajawu ngini awarra kirijini ngini nginja wiyi nimpurtiyi api ngiya wiyi ngirimamula (call) awarra nginja-mwarti ngiya-alawura. Awarra kirijini ngarra wiyi warntirrana pupuni, karluwu nginingaji awuta kakirijuwi kapi yingampa maminikuwi wurtiyi, amintiya ngawa-rringani wiyi kukunari arimi kangatawa.” Awarra jiyimi awinyirra Elizabeth kangi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kiyi nyoni nginaki jiyimi awinyirra Elizabeth, “Ngawa-rringani wiyi warntirrana apamangi nginja pili nginja kuwa jiyimi awarra ngirramini ngini ngawa-rringani ngini-ngatawa yingumpunila (angel) yipangiraga kanginjila.” Awarra jiyimi awinyirra Elizabeth kangi Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Awinyirra Mary karri jiyipitingaya (heard) awarra ngini Elizabeth jipangiraga api nyirra jiyimi ngini, “Ngiya nguru-kuruwarni (thank) ngawa-rringani ngini kuriyuwu pili ngarra warntirrana pupuni amintiya ngarra awuni (has) yingarti power. ");
INSERT INTO tiw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Ngarra apamangi ngiya pili-ngini karluwu arramu-kamini yimatapirni ngiya api ngiya kukunari ngirimi kapi ngarra. Numata ngini ngiya karluwu ngilawa api ngawa-rringani yipungintayi (thought about) ngiya. Api awuta arikutumunuwi kapi ningani wurumuwu kapi naki murrakupuni (on this earth) amintiya awuta kapi nanuwanga wunu-wuja api wuta awuta wiyi wurimi ngini, ‘Ngarra ngawa-rringani ngini kuriyuwu warntirrana kukunari kangi awinyirra Mary.’ Wuta wiyi awarra wupangiraga ");
INSERT INTO tiw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","pili ngarra awarra ngawa-rringani waya warntirrana yiminu-wani (helped) ngiya. Ngarra awarra ngawa-rringani karluwu nginingaji ngawa arikutumunuwi. Ngarra awarra warntirrana pupuni,” jiyimi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kiyi awinyirra Mary nyoni ngirramini jipangiraga ngini, “Awarra ngawa-rringani amanu-wani ngawa tiwi kapi ngawa ngarimamula (call) ngarra ngatawa. Karri ngawa jirti ngirramini ngawuni (have trouble) api awungarri ngarra putuputuwu apakirayi (be sorry for) ngawa. Amintiya wiyi putuputuwu apakirayi awuta tiwi kapi nanuwanga wunu-wuja karri wuta wiyi jirti ngirramini (trouble) wuni,” jiyimi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kiyi nyoni nginaki jipangiraga awinyirra Mary, “Ngarra ngawa-rringani waya yikirimi yingarti mirrikili (miracle). Ngarra yingarti power awuni (has) api awuta tiwi kapi wuri-mamuliya pupuwi api ngarra wiyi jirti ngirramini (trouble) awunt-akirayi awuta api wuta wiyi kalikali wurimakirrimi, yingampa nankitawu yingampa nankitawani. ");
INSERT INTO tiw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Amintiya awuta alawuruwi kapi wuta kapmanuwi api ngini wuta wurimi ngini wuta wutawa api ngarra awarra ngawa-rringani arikirimi awuta ngini waya karluwu alawuruwi wurimi. Kiyi wutatuwu kapi karluwu wurimi ngini wuta wutawa api ngarra awarra ngawa-rringani arikirimi awuta ngini wiyi alawuruwi wurimi. ");
INSERT INTO tiw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Amintiya awuta kapi wuta karri-kamini yinkiti amintiya kuluji api ngarra awunt-akirayi awuta yingarti yinkiti amintiya arramu-kaminawuti ngini pupuni. Amintiya wutatuwu awuta kapi yingarti kunawuni wuni amintiya yingarti arramu-kaminawuti wuni api karri wuta nanginta wurimi awarra ngawa-rringani kuta kamini awarra ngini wuta wutimarti api ngarra karluwu apakirayi awuta awarra arramu-kaminawuti,” jiyimi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kiyi awiyirra Mary nyoni nginaki jiyimi ngini, “Ngawa Jews api ngarra ngawa-rringani ngini kuriyuwu api ngarra ngarra-mamirampi ngawa api ngarra ngawa-rringani wiyi yiloti apamangi ngawa pili parlingarri ngarra yuwuntiyarra ngawa-amini Abraham amintiya yingampa ngawa-maninguwi ngini ngarra karluwu yimata-ngiliparra (won't forget) ngawa kapi ngawa ngarra-mawampi awarra Abraham api kuta awungarri ngawa wiyi jirti ngirramini ngawuni (have trouble) api ngarra wiyi yiloti putuputuwu apakirayi ngawa awarra ngawa-rringani.” Nyirra Mary jipangiraga awarra yingarti ngirramini karri jiyikuruwarni (thanked) ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nyirra awinyirra Mary japuja jiyikirimi kapi Elizabeth api nginingaji yirrajirrima wurlini (3 months) jiyimuwu kangi nyitawa. Kiyi awinyirra Mary jipakupawurli kapi nyirra japuja. ");
INSERT INTO tiw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kiyi Elizabeth juwurtiyi nyirra-mwarti. ");
INSERT INTO tiw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nyirra-ngirimipi amintiya awuta arikutumunuwi kapi tangarima pirimi kapi nyirra murrakupuni api karri wuta piri-pitingaya (heard) ngini ngarra ngawa-rringani waya putuputuwu yipakirayi awinyirra Elizabeth amintiya ngini nyirra juwurtiyi nyirra-mwarti api wuta kukunari pirimi kangi wuta-mantanga. ");
INSERT INTO tiw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kiyi karri awarra kirijini nginingaji yati week old api yingampa arikutumunuwi purruwuriyi kapi Elizabeth japuja pili-ngini wuta pimata-wurrini kiyija ngarra mipurra (circumcise) pili wuta awarra ngini-wutawa ngirramini (law) awuta Jews. Awuta tiwi purru-wutimarti ngini awarra kirijini yintanga wutiyati ngarra-rringani Zechariah ");
INSERT INTO tiw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","api awinyirra Elizabeth nimarra jiyimi kapi awuta arikutumunuwi, “Arnapa. Nuwa ngajiti yintanga ngimpaja-kirayi ngarra Zechariah. Waya juwa ngawa ngapakirayi ngarra yintanga John,” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Api wuta pirimi kapi nyirra, “Pilikama ngawa ngarimamula (call) ngarra John pili karri-kuwapi kapi nginja-ngirimipi wuta yintanga awarra?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kiyi awuta tiwi sign pirikirimi kangi Zechariah pili ngarra karluwu nimarra yimi nanuwanga api wuta nanginta pirimi ngarra, “Kamini yintanga nginja wiyi nimpakirayi nginja-mirani?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kiyi Zechariah sign yikirimi kapi awuta arikutumunuwi ngini wuta pimata-kirayi ngarra punkaringini (paper). Karri wuta pirripakirayi ngarra punkaringini api ngarra yikirimi (wrote) kangi awarra punkaringini ngini, “Ngarra yintanga John awarra kirijini.” Api karri awuta arikutumunuwi pirripakuluwunyi awarra yintanga ngini awarra Zechariah yikirimi kangi awarra punkaringini api wuta awungarri nimarra pirimajirri, “Pilikama ngarra yikirimi (wrote) awarra yintanga John?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kiyi karri Zechariah yikirimi (wrote) awarra yintanga John api awungarri ngarra tuwanga nimarra yimi api kiyi ngarra yikuruwarni (thanked) ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Awuta arikutumunuwi kapi japuja pirimi yinkitayi kapi awarra Zechariah amintiya ngarra-purnayinga api karri wuta piri-pitingaya (heard) Zechariah nimarra yimi api pirimajirri, “Ngarra ngawa-rringani waya yati ngatawa,” pirimi. Kiyi wuta pirimarruriyi awarra ngirramini kapi awuta arikutumunuwi kapi tangarima pirimi kapi awarra murrakupuni Judea awungarruwu kapi yingarti jupunyini (hills). ");
INSERT INTO tiw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Api awuta tayikuwapi arikutumunuwi kapi piri-pitingaya awarra ngirramini ngini (about) awarra kirijini John api wuta puru-pungintayi (thought about) awarra ngirramini api pirimajirri, “Awarra naki kirijini karri ngarra wiyi arikulani arima api kamini wiyi waki arimi?” pirimi awuta arikutumunuwi. Wuta awarra nimarra pirimajirri pili wuta pirimajawu ngini ngawa-rringani ngini-ngatawa power yimuwu kangi awarra kirijini John. ");
INSERT INTO tiw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Karri awinyirra Mary amintiya nyirra-purnayi Joseph purumuwu kapi awarra murrakupuni Galilee api kapi awarra murrakupuni Rome yimuwu yati alawura. Ngarra awarra yintanga King Augustus. Ngarra alawura yimi kapi yingarti murrakupuni amintiya ngarra awanuwanga alawura yimi kapi awarra murrakupuni Galilee amintiya Judea. Api ngarra jingawu yimi kapi yingampa tiwi kapi wuta waki pirimi ngini (for) ngarra ngini wuta pini-matu-wariyi kangatawa. Kiyi karri wuta papi pirimi kangatawa api yimi ngini, “Awi, nyirru-wariyi kapi awarra yingarti murrakupuni kapi ngiya alawura awungarruwu api nyirra-jiyarra awuta tiwi ngini pimatu-wariyi kapi wuta-ampi ngini-wutawa murrakupuni. Awungarruwu wuta kapmanuwi wiyi wurikirimi (write) ngini-wutawa yintanga kangi punkaringini (book).” Awarra alawura yimi awarra kapi wuta waki pirimani ngini (for) ngarra. Api kiyi awuta tiwi kapi wuta waki pirimani ngini awarra alawura, wuta pirimarruriyi ngini-ngatawa ngirramini kapi awuta tiwi kapi awarra yingarti murrakupuni. ");
INSERT INTO tiw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kiyi awuta tiwi kapi japuja pirimi kangi awarra yingarti murrakupuni api karri wuta piri-pitingaya (heard) awarra King Augustus ngini-ngatawa ngirramini api wuta purruwuriyi kapi awarra murrakupuni kapi wuta-ampi pakinya purumuwu. Karri papi pirimi awungarruwu api purruwuriyi kapi awuta kapmanuwi api kiyi awuta kapmanuwi pirikirimi (wrote) ngini-wutawa yintanga kapi awarra punkaringini. ");
INSERT INTO tiw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Wutatuwu Joseph amintiya ngarra-purnayinga Mary wuta awungarri japuja pirimi kapi awarra town Nazareth awungarruwu kapi Galilee. Kiyi ngarra awarra Joseph yuwuriyi kapi awarra town Bethlehem awungarruwu kapi awarra murrakupuni Judea pili-ngini awungarruwu awuta kapmanuwi pimata-kirimi (should write) ngini-ngatawa yintanga kapi awarra punkaringini pili parlingarri awarra Joseph ngarra-amini King David yimulungurrumi awungaji. Awarra Joseph yimarruriyi awinyirra Mary awungarruwu. Nyirra awungarri papuringanta. ");
INSERT INTO tiw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Karri awarra Joseph amintiya awinyirra Mary papi pirimi awungaji kapi Bethlehem api awungarri awarra kirijini yinkitayi arimulungurrumi. Wuta kularlaga pirimi kurrampali angi wuta pimata-muwu api karri-kamini, pili tayikuwapi tiwi purru-wujingi-muwani yilaruwu kapi awinyirra tayikuwa-nga (all) kurrampali. Kiyi purruwuriyi kapi wuta pulukuwi japuja pirimi. Kiyi awarra kirijini Mary nyirra-mwarti awungarruwu yimulungurrumi. Nyirra Mary mampara juwurtiyi nyirra-mwarti. Kiyi juwunga tayikuwa-nga manipurruwa (lots of material) kiyi jiyikimirna awinyirra kangi nyirra-mwarti. Kiyi jipalami awarra nyirra-mwarti kangi arikulanga wurika (dish) angi wuta pulukuwi purruwapa yinkiti. ");
INSERT INTO tiw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Karri ngawa-yuwuni Jesus yimulungurrumi karri japinamini api awungarri wutatuwu yingampa wawurruwi pirripamangi awuta sheepuwi kapi warta. ");
INSERT INTO tiw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Api Kiyi ngarra ngawa-rringani ngini kuriyuwu yini-pangirri (sent) yati yingumpunila (angel) kapi awuta wawurruwi. Awarra yingumpunila ngirri-ngirri yimi amintiya yikirimi awarra murrakupuni nginingaji yirrimanuwuni pili ngawa-rringani ngini-ngatawa power yikirimi awarra yingumpunila ngini warntirrana ngirri-ngirri yimi. Api awuta wawurruwi, karri pirripakuluwunyi awarra yingumpunila api wuta pirimakirri. ");
INSERT INTO tiw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kiyi awarra yingumpunila nimarra yimi kangi awuta wawurruwi api yimi ngini, “Awi,” yimi. “Nuwa ngajiti ngimpaja-wanga. Yita wanga ngiya pupuni ngirramini waya nginiri-marruriyi kangi nuwa. Api karri nuwa ngimpiri-pitingaya (hear) awarra naki ngirramini api nuwa wiyi awungarri kukunari ngimpirimi. Amintiya karri tayikuwapi arikutumunuwi wiyi wuri-pitingaya awarra ngirramini api wuta awanuwanga wiyi kukunari wurimi. ");
INSERT INTO tiw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kayi, yati kirijini ningani yimulungurrumi nankitawu kapi Bethlehem kapi ngarra King David yimulungurrumi parlingarri. Ngarra awarra kirijini wiyi alawura arimi kapi nuwa tayikuwapi arikutumunuwi. Awarra kirijini api ngarra awarra Christ ngini ngawa-rringani parlingarri yuwuntiyarra nuwa-maninguwi ngini ngarra wiyi yini-mata-ngirri (would send) awarra kapi nuwa tiwi. Awarra Christ wiyi awunyawu awarra jirti ngini nuwa tiwi ngintiri-kirim-ani (the wrong you have done) api kiyi nuwa wiyi yiloti ngumpuru-muwu kuriyuwu kangi ngawa-rringani ngarra japuja.” Awarra yimi awarra yingumpunila (angel) kapi awuta wawurruwi. ");
INSERT INTO tiw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kiyi yimi ngini, “Nyirru-wariyi kapi Bethlehem kiyi kularlaga nyirrami awarra kirijini. Nuwa wiyi ngumpunyayi awarra kirijini awujingi-mili kangi awinyirra arikulanga wurika (dish) angi pulukuwi wuwapa yinkiti. Api karri nuwa ngumpunyayi awarra kirijini api nuwa wiyi awungarri ngimpiri-majawu ngini awarra ngirramini ngini ngiya ngurru-wutiyarra nuwa api awarra ngirramini warntirrana.” Ngarra awarra yimi awarra yingumpunila kangi awuta wawurruwi kapi pirripamangi awuta sheepuwi. ");
INSERT INTO tiw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Karri awarra yingumpunila yipapaya ngini nimarra yimi api awungarri tayikuwapi awuta angeluwi papi pirimi awungarruwu. Kiyi wuta purukuruwala ngini, ");
INSERT INTO tiw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ngarra ngawa-rringani ngini kuriyuwu ngarra warntirrana ngatawa amintiya ngarra warntirrana pupuni. Amintiya awuta tiwi kapi ngarra puranji arimuwu awuta api wuta wiyi pupuni wurimi kangi wuta ruwuti amintiya wuta punyipunyi api wuta wiyi jirti ngirramini karluwu wupakiray-ajirri.” Wuta purukuruwala awarra ngirramini awuta angeluwi. ");
INSERT INTO tiw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Karri awuta angeluwi purrupumwari awuta wawurruwi api pirripakupawurli kapi wutawa tangarima kuriyuwu api awuta wawurruwi kapi pirripamangi sheepuwi api nimarra pirimajirri ngini, “Awi, ngawa-rringani yini-pangirri (sent) awungarra awuta angeluwi ngini purru-wutiyarra ngawa ngini (about) awarra kirijini api ngawurliyi kapi Bethlehem, ngapakuluwunyi awarra kirijini,” pirimi awuta wawurruwi. ");
INSERT INTO tiw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kiyi wuta purrupumwari awuta sheepuwi api murruka pirimi kapi Bethlehem. Karri papi pirimi awungarruwu api kularlaga pirimi awarra kirijini, kiyi purruwunyayi ngarra amintiya ngarra-naringa kiyi awarra Joseph. Ngarratuwu awarra kirijini yimajirripi kangi awinyirra dish angi wuta pulukuwi purruwapa yinkiti. ");
INSERT INTO tiw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Awuta wawurruwi karri wuta pirripakuluwunyi awarra kirijini api purru-wuntiyarra awinyirra Mary amintiya awarra Joseph awarra ngirramini ngini awarra yingumpunila nimarra yimi kangi wutawa. Kiyi awuta wawurruwi purrupumwari awarra kirijini amintiya ngarra-naringa amintiya Joseph. Kiyi wuta purruwuriyi kularlaga pirimi kangi awarra murrakupuni kiyi purru-wuntiyarra awuta arikutumunuwi awarra ngirramini ngini awarra yingumpunila yipangiraga ngini (about) awarra kirijini. ");
INSERT INTO tiw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Api awuta arikutumunuwi, karri piri-pitingaya (heard) awarra ngirramini ngini awuta wawurruwi pirripangiraga api wuta pirimarlingiyi (got a surprise) api pirimajirri ngini, “Naki awarra ngirramini ngini awuta kapinaki wawurruwi pirripangiraga api arrami warntirrana awarra,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nyirratuwu awinyirra Mary karluwu jipangiliparra awarra ngirramini ngini awuta wawurruwi kapi pirripamangi awuta sheepuwi nimarra pirimi kangi nyitawa. Nanuwanga (still) awarra ngirramini yipalamiya kangi nyirra punyipunyi. ");
INSERT INTO tiw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kiyi awuta wawurruwi pirripakupawurli kapi warta api karri wuta pirripangulimayi kapi jarrumoka api wuta puru-kuruwarni (thanked) ngawa-rringani api pirimi ngini, “Ngirringani, nginja warntirrana pupuni amintiya nginja yati nginjila pili nginja jini-pangirri (sent) awarra yingumpunila (angel) ngini nimarra yimi kangawula ngini (about) awarra kirijini api ngawa nguntuwuriyi kiyi nginti-pakuluwunyi awarra kirijini. Yita awarra ngirramini ngini awarra yingumpunila nimarra yimi kangawula ngini (about) awarra kirijini api warntirrana awarra ngirramini api ngawa ngaru-kuruwarni (thank) nginja pili nginja jini-pangirri (sent) awarra kirijini kangawula arikutumunuwi,” pirimi awuta wawurruwi kangi ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kiyi awarra kirijini, karri ngarra punyipunyinga wumunga (8 days old) api awarra Joseph amintiya awinyirra Mary kuwa pirimi awarra ngirramini (law) ngini-wutawa Jews ngini wuta pimata-wurrini mipurra (circumcise) kapi-wutawa kakirijuwi kapi wuta jajingaruwi. Api awungarri Mary amintiya Joseph yintanga pirripakirayi awarra kirijini Jesus. Wuta awarra yintanga pirripakirayi ngarra pili karri ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) ngini-ngatawa power karluwu yikirimi awinyirra Mary papuringanta nanuwanga api awarra yingumpunila (angel) nimarra yimi kangi awinyirra Mary ngini nyirra wiyi ampakirayi awarra yintanga kapi awarra nyirra-mwarti karri ngarra wiyi arimulungurrumi. ");
INSERT INTO tiw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Parlingarri awarra Moses yikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) awarra ngirramini (laws) ngini awuta tiwi kapi Jews kuwa pimatami. Api yati ngirramini ngini Moses yikirimi ngini, “Karri maminikuwi wurtiyi wuta-mwaruwi kapi jajingaruwi api awuta maminikuwi karluwu pimatu-wariyi kapi awinyirra arikulanga jurra (temple) angi-wutawa Jews. Waya juwa karri yati wurlini (one month) apapaya api awungarri wuta waya rayiti (alright) ngini pimatu-wariyi kangi awinyirra jurra.” Awarra ngirramini Moses yikirimi kangi awarra punkaringini. Nyoni ngirramini (law) ngini Moses yikirimi (wrote) kangi awarra punkaringini ngini, “Awarra kirijini ngini aringamini, karri ngarra nginingaji yati wurlini (about one month old) api awungarri ngarra-rringani amintiya ngarra-naringa wuta pimata-marruriyi awarra kirijini kapi awinyirra jurra amintiya pimata-kirayi ngarra kapi ngawa-rringani ngini kuriyuwu. Karri wuta wurimarruriyi awarra kirijini kapi awinyirra jurra api awungarri wuta wiyi awanuwanga pimata-marruriyi (should take) yirrara mwapurawayi (dove birds) kapi jurra kiyi pimata-kirayi awuta mwapurawayi kapi awarra priest pili-ngini ngarra yimata-pirni awuta mwapurawayi kiyi yimata-wumi awuta mwapurawayi kapi ngawa-rringani ngini-ngatawa altar.” Awarra ngirramini Moses yikirimi kangi punkaringini parlingarri. Awarra kirijini Jesus ngarra-rringani amintiya ngarra-naringa kuwa pirimi awarra yirrara ngirramini (law) ngini awarra Moses yikirimi (wrote) kangi awarra punkaringini api karri awarra kirijini nginingaji yati wurlini (about one month old) api wuta pirimarruriyi ngarra kapi awinyirra arikulanga jurra awungarruwu kapi Jerusalem pili-ngini wuta pimata-kirayi ngarra kangi ngawa-rringani ngini kuriyuwu amintiya awanuwanga pirimarruriyi yirrara mwapurawayi kapi awarra priest ngini yimata-pirni awuta mwapurawayi. ");
INSERT INTO tiw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Awungarruwu kapi Jerusalem yati tini yimuwu ngini ngarra yintanga Simeon. Ngarra awarra Simeon api pupuni tini amintiya ngarra puranji yimuwu awarra ngawa-rringani. Parlingarri awarra ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) yipawuriji yilaruwu kangi awarra Simeon ngarra punyipunyi kiyi yuwutiyarra ngarra, “Awarra Christ ngini ngiya parlingarri ngirripangiraga ngini ngiya wiyi ngipangirri (send) kapi nuwa Jews ngini ngarra wiyi amanu-wani (help) nuwa, api nginja wiyi nimpakuluwunyi awarra Christ pili nginja wiyi nanuwanga yimpangini nimpirimi karri awarra Christ wiyi awunu-wuriyi kapi nuwa Jews,” yimi awarra pukwiyi kapi awarra Simeon. Api kiyi awarra Simeon arnapa yuwujingi-muwani (was waiting) ngini yimata-kuluwunyi awarra Christ. ");
INSERT INTO tiw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kiyi karri awarra Joseph amintiya awinyirra Mary pirimarruriyi awarra kirijini Jesus kapi awinyirra arikulanga jurra api awungarri awarra pukwiyi yuwutiyarra Simeon, “Yartipili tuwariyi kapi awinyirra arikulanga jurra,” yimi. Kiyi Simeon yuwuriyi kapi awinyirra jurra kiyi yipawuriji yilaruwu. ");
INSERT INTO tiw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","31","Ngarra awungarri yipakuluwunyi awarra Joseph amintiya awinyirra Mary api yuwuriyi kangi wutawa api yipakuturruwa awarra kirijini Jesus kangi ngatawa kurumuta. Api awarra Simeon yimi kapi ngawa-rringani ngini kuriyuwu, “Aya, ngirringani, ngiya waya waki ngirimani yinukuni ngini (for) nginja api ngiya waya nguwutimarti ngini pajuwani ngimatami pili ngiya ngirimajawu ngini naki kirijini ngarra awarra Christ ngini nginja jini-pangirri (sent) kangawula. Ngiya kukunari ngirimi pili ngiya waya ngirripakuluwunyi awarra ngini ngarra Christ ngini nginja awarra pakinya juwutiyarra ngiya,” yimi awarra Simeon kapi ngawa-rringani. Kiyi ngarra yimi ngini, “Ngiya ngirimajawu ngini naki kirijini api karri ngarra wiyi arikulani arima api ngarra wiyi amanu-wani (help) ngawa karri jirti ngirramini (trouble) papi arimi kangawula. Ngawa tayikuwapi arikutumunuwi wiyi ngarimajawu ngini (about) awarra Christ,” yimi awarra Simeon kapi ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kiyi tuwanga yimi, “Api awuta arikutumunuwi kapi wuta arnuka Jews api wuta waya yinukuni puru-muwu kapi nginingaji yartijanga pili wuta karluwu pirimajawu ngini (about) nginja ngirringani api waya ningani nginja waya jini-pangirri (sent) nginaki Christ awungarra kapi naki murrakupuni (to this earth) api ngarra wiyi arikirimi awuta kapi wuta arnuka Jews ngini wuta nginingaji wurumuwu kapi yirrimanuwuni, pili wuta wiyi wurimajawu nginja pili ngarra awarra Christ yinuwuriyi kangi wutawa. Api kiyi awuta tiwi kapi wuta arnuka Jews wuta wiyi wurimi ngini ngawa Jews ngawa ngawula pili nginja jini-pangirri (sent) nginaki awarra Christ awungarra kapi ngawa Jews.” Awarra Simeon yipangiraga kapi ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Awinyirra Mary amintiya awarra Joseph karri wuta piri-pitingaya (heard) awarra ngirramini ngini ngarra Simeon yipangiraga api wuta pirimarlingiyi (got a surprise) pili awarra Simeon yimajawu ngini ngawa-rringani yini-pangirri (sent) ngini-wutawa kirijini kapi naki murrakupuni (to earth). ");
INSERT INTO tiw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Kiyi Simeon nanginta yimi ngawa-rringani ngini kuriyuwu ngini yimata-mangi awarra Joseph amintiya awinyirra Mary amintiya awarra kirijini Jesus. Kiyi ngarra yimi kapi Mary, “Ngawa-rringani ngarra waya yini-pangirri nginja-mwarti kangi ngawa tayikuwapi kapi Jews pili-ngini ngarra yimata-jiyarra ngawa awarra ngirramini ngini-ngatawa ngawa-rringani. Karri ngawa Jews wiyi ngari-pitingaya awarra ngirramini ngini nginja-mwarti apangiraga api ngawa yingampa (some) wiyi kuwa ngarimi kangatawa amintiya wuta yingampa (other) kapi Jews wiyi wurimi ngini nginja-mwarti jirti tini api wuta wiyi karluwu kuwa pimatami kangatawa. Nginja-mwarti wiyi arimajawu ngawa kapi warntirrana kuwa ngarimi kangatawa pili ngarra wiyi arimajawu kuta kamini ngini apalamiya kangi ngawa punyipunyi. Ngawa awuta kapi wiyi kuwa ngarimi kangatawa api ngawa-rringani wiyi amant-amangi ngawa api ngawa awuta kapi karluwu kuwa ngamatami kangatawa api ngawa-rringani wiyi amani-pirni ngawa,” yimi awarra Simeon kangi Mary. Kiyi nyoni nginaki ngirramini yimi kapi Mary, “Karri nginja-mwarti ngarra arikulani arima api yingampa awuta tiwi wuta wiyi jirti ngirramini (trouble) wupakirayi ngarra api nginja wiyi jirti purnikapa nimpirimi amintiya wiyi pirlikiti nimpirimi pili ngarra awarra nginja-mwarti wiyi yingarti ngirramini (trouble) awuni (has).” Awarra Simeon yimi kapi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Awungarruwu kangi Jerusalem natinga wulikimaka jiyimuwu angi nyirra yintanga Anna. Nyirra waki jiyimani ngini (for) ngawa-rringani api nyirra juwuntiyarra arikutumunuwi awarra ngirramini ngini ngawa-rringani yuwutiyarra nyirra. Parlingarri karri awinyirra Anna murrukupora jiyima, nyirra marriti jiyimi nyirra-purnayi kiyi jiyimarrimuwu awarra walimani pakitiringa (7 years). Kiyi nyirra-purnayi pajuwani yimi api nyirra amparruwu jiyima. ");
INSERT INTO tiw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nyirra amparruwu jiyimuwani yinukuni amintiya nyirra waya 84 pakitiringa (years old). Nginingaji ngatawa wumunga (every day) nyirra juwuriyani kangi awinyirra arikulanga jurra (temple) kiyi awungaji nyirra pray jiyimani kangi ngawa-rringani ngini kuriyuwu. Karri yirrimanuwuni amintiya karri yartijanga nyirra pray jiyimani kangatawa, kiyi yingampini (sometimes) nyirra karluwu juwapukani yinkiti (fasted) pili nyirra awungarri waya juwa jiyipungintay-ani (used to think about) ngawa-rringani amintiya pray jiyimani kangatawa. ");
INSERT INTO tiw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Karri awarra Simeon nimarra yuwujingi-mani kapi awinyirra Mary amintiya awarra Joseph api awinyirra Anna nyirra awungarri jinu-wuriyi kapi awinyirra arikulanga jurra. Kiyi karri nyirra jipakuluwunyi awarra kirijini nyirra jiyimajawu ngini ngarra awarra Christ api nyirra wiyarri jiyikuruwarni (thanked) ngawa-rringani. Api wiyi (later on) nyirra juwuntiyarra tiwi ngini (about) awarra kirijini, awuta tiwi kapi wuta japuja pirimani kapi Jerusalem amintiya kapi purru-wutimarti ngawa-rringani ngini yini-mata-ngirri (to send) awarra Christ ngini yimata-wani (to help) awuta. ");
INSERT INTO tiw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Awarra kirijini Jesus yikulurumi amintiya yikuturumi yima (became strong). Ngarra waya pungintamini (clever) amintiya ngawa-rringani ngini kuriyuwu puranji yimuwu awarra ngarra-mirani amintiya kukunari yimi kangi ngatawa. ");
INSERT INTO tiw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nginingaji ngatawa pakitiringa (every year) awarra Jesus ngarra-rringani amintiya ngarra-naringa purruwuriyi awungarruwu kapi Jerusalem pili awarra Passover Ceremony. ");
INSERT INTO tiw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Karri ngawa-yuwuni Jesus ngarra wamurrara yirrara pakitiringa (12 years old) api ngarra-naringa amintiya ngarra-rringani pirimarruriyi ngarra awungarruwu kapi Jerusalem kapi awarra Passover Ceremony. ");
INSERT INTO tiw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Api karri pirripapaya awarra Passover api awarra kirijini Jesus ngarra-rringani amintiya ngarra-naringa wuturiyi wuta-ngirimipi amintiya wuta-mamanta purrupumwari Jerusalem kiyi pirripakupawurli kapi wuta japuja kapi Nazareth. Awarra Joseph amintiya Mary wuta amparrimani pirrarimi ngini awarra Jesus yipapunya awuta wuta-ngirimipi amintiya wuta-mamanta api karluwu. Ngarra yuwanjipa awungarruwu kapi Jerusalem. Awarra Joseph amintiya awinyirra Mary pirripangulimayi karri yirrimanuwuni kiyi karri yartijanga wuta purruwunjarli (stopped) ngini pimata-majirripi. Karri wuta kularlaga pirimi ngini-wutawa kirijini Jesus api karluwu purruwunyayi awarra. Kiyi purruwuriyi kapi wuta-ngirimipi amintiya wuta-mamanta api nanginta pirimi wutawa ngini, “Maka awarra kirijini?” Api wuta-ngirimipi amintiya wuta-mamanta pirimi ngini, “Yita karri-kamini awungarra,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Api karri awarra Joseph amintiya awinyirra Mary karluwu purruwunyayi awarra kirijini Jesus api pirripakupawurli kapi Jerusalem ngini wuta kularlaga pimatami ngarra awungarruwu. ");
INSERT INTO tiw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","47","Awungaji kapi Jerusalem wuta kularlaga pirimila awarra kirijini karri yirrara wumunga (2 days) kiyi karri pangarri wuta purruwunyayi ngarra kapi awinyirra arikulanga jurra angi-wutawa Jews. Awungarruwu kapi awinyirra jurra ngarra yuwujingi-muwani wutiyati awuta scribes. Awuta scribes nimarra pirimajirri ngini (about) awarra ngirramini (law) ngini-wutawa Jews api awarra kirijini Jesus yipitingaya (heard) awarra ngirramini ngini awuta scribes pirripangiraga amintiya nanginta yimi awuta ngini (about) awarra ngirramini (law). Amintiya karri awuta scribes nanginta pirimi awarra kirijini Jesus ngini (about) awarra ngirramini (law) api ngarra pupuni nimarra yipangiraga. Awuta scribes amintiya awuta yingampa arikutumunuwi karri piri-pitingaya (heard) awarra ngirramini ngini awarra kirijini yipangiraga kapi awuta scribes api wuta pirimarlingiyi (got a surprise) kiyi nimarra pirimajirri ngini, “Naki kirijini warntirrana arimajawu ngini (about) ngini-ngawula ngirramini (law).” Awarra pirimi awuta scribes amintiya awuta yingampa tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Awarra Joseph amintiya awinyirra Mary karri wuta purruwunyayi awarra kirijini Jesus kapi awinyirra jurra api wuta awanuwanga pirimarlingiyi ngini ngarra warntirrana yipangiraga ngini ngini-wutawa ngirramini (law). Kiyi ngarra-naringa jiyimi kangatawa, “Aya, mwarti, pilikama nginja jipakirayi ngawa nginaki jirti ngirramini (trouble)? Ngawa karluwu ngintiri-majawu ngini maka nginja jiyimi api ngawa worry ngintirimi nginja. Ngawa kularlaga nguntu-wujingi-mani nginja,” jiyimi awinyirra Mary kangi nyirra-mwarti. ");
INSERT INTO tiw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Api awarra kirijini Jesus nanginta yimi nyitawa, “Pilikama nuwa kularlaga ngintirimi ngiya? Pilikama nuwa karluwu ngintiri-majawu ngini ngiya waki ngimatami (should work) ngini (for) ngiya-rringani ngini kuriyuwu?” yimi awarra kirijini Jesus kangi ngarra-naringa. ");
INSERT INTO tiw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Api ngarra-rringani amintiya ngarra-naringa karluwu pirimajawu (understand) awarra ngirramini ngini ngarra yipangiraga. ");
INSERT INTO tiw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kiyi awarra kirijini Jesus yipapunya ngarra-naringa amintiya ngarra-rringani api pirripakupawurli kangi wutawa tangarima kapi Nazareth. Awungarruwu ngarra yimuwu kiyi kuwa yimi kapi ngarra-rringani amintiya ngarra-naringa. Api ngarra-naringa karluwu jipangiliparra ngini nyirra-mwarti yuwuriyi kapi awinyirra arikulanga jurra awungarruwu kapi Jerusalem amintiya ngini ngarra amintiya awuta scribes nimarra pirimajirri. Nyirra yimpaja jiyipungintayi (thought about) awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kiyi awarra kirijini Jesus yikulurumi amintiya ngarra waya pungintamini (clever). Ngawa-rringani ngini kuriyuwu kukunari yimi kangatawa amintiya awanuwanga tayikuwapi arikutumunuwi wuta kukunari pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kiyi wutatuwu yingampa (other) tiwi punuwuriyi kapi awarra John the Baptist. Tayikuwapi awuta. Api wuta pirimi kapi awarra John the Baptist, “Ngawa awungana ngamatama pili ngawa ngawutimarti ngawa-rringani ngini wiyi yimata-marruriyi ngawa kuriyuwu kapi ngarra japuja,” pirimi awuta tayikuwapi tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Api awarra John the Baptist yimi ngini, “Nuwa kapi ngimpini (have) yirrara kuluji api nuwa nyirra-kirayi natinga kapi awarra tini ngini ngarra karri-kamini kuluji awuni (has). Amintiya kapi nuwa ngimpini yinkiti api nyirra-warti (share) kapi nuwa-mamanta kapi wuta arnuka yinkiti wuni,” yimi awarra John the Baptist. ");
INSERT INTO tiw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kiyi wutatuwu yingampa punuwuriyi kapi John the Baptist api nanginta pirimi ngarra ngini baptise yimata-kirimi awuta. Wuta awuta waki pirimani ngini (for) awuta Roman alawuruwi api nanginta pirimani wuta-mamanta awuta Jews awarra kunawuni ngini tax. Wuta awuta awanuwanga nanginta pirimi awarra John the Baptist ngini, “Ngawatuwu awungana ngamatama pili ngawa ngawutimarti ngawa-rringani ngini wiyi yimata-marruriyi ngawa kuriyuwu kapi ngarra japuja,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Api awarra John the Baptist yimi ngini, “Nuwa yingampa nanginta ngimpirimi nuwa-mamanta Jews yingarti kunawuni ngini tax pili nuwa ngimpitimarti ngini nginti-matanga yingampa awarra kunawuni ngini (for) nuwulamiya. Api nuwa ngajiti awungani ngimpajami,” yimi awarra John the Baptist. ");
INSERT INTO tiw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kiyi wutatuwu yingampa kapi wuta soldiers nanginta pirimi awarra John the Baptist ngini, “Marri ngawa? Ngawatuwu awungana ngamatama?” pirimi. Api ngarratuwu yimi John the Baptist, “Nuwa yingampa ngimpiri-pirni tiwi amintiya tongwayi ngimpirimi awuta pili-ngini nuwa mitaya nginti-matami kunawuni kangi wuta. Api nuwa ngajiti awungani ngimpajami. Amintiya awarra kunawuni ngini kapi-nuwula alawuruwi wupakirayi nuwa ngini (for) nuwa waki ngimpirimi ngini (for) wuta api nuwa yingampa manya ngimpirimi ngini kiyija ngumpunga. Api nuwa ngajiti awungani ngimpajami. Nuwa kukunari nyirrami ngini awarra kunawuni ngini nuwa ngumpunga,” yimi awarra John the Baptist kapi awuta soldiers. ");
INSERT INTO tiw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kiyi natinga wumunga (one day) ngawa-yuwuni Jesus yipapirraya kapi awarra lake Galilee api awungarruwu ngarra tayinti yimi kapi tingata api yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Tayikuwapi awuta arikutumunuwi purru-wujingi-rritani (were standing) yinkitayi kangatawa api ngawa-yuwuni ngarra kuluwuta. ");
INSERT INTO tiw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kiyi ngarra ngawa-yuwuni yipakuluwunyi yirrara kapala kangi tingata yinkitayi kapi kukuni. Karri-kuwapi purumuwu yilaruwu kapi awinyirra yirrara kapala pili awuta wawurruwi kapi purruriy-ani muputi kangi awinyirra kapala api wuta waya purrupumwari awinyirra kapala api wuta purru-wujingi-wunyirrani (were washing) angi-wutawa panapa (net) kangi kukuni. ");
INSERT INTO tiw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Natinga awinyirra kapala angatawa Simon api ngawa-yuwuni yipawuriji yilaruwu kangi awinyirra kapala kiyi yimuwu. Kiyi ngarra yimi kapi Simon, “Aya, tayangirri (push) anaki kapala kapi awarra lake kiyi tapitapi tami kiyija-nara karrampi. Api kiyi ngiya wiyi nimarra ngirimi kapi kapinaki tiwi kapi wuta wujingi-rriti (are standing) kapi tingata,” yimi kangi awarra Simon. Kiyi Simon kuwa yimi ngini ngawa-yuwuni yipangiraga kiyi tapitapi yimi kiyija kiyi ngawa-yuwuni nimarra yimi kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kiyi karri ngawa-yuwuni yipapaya ngini nimarra yimi kangi awuta arikutumunuwi api yimi kangi Simon amintiya ngarra-mamanta, “Tapitapi nyirrami kapi kipirla kiyi nyirra-nyawu angi-nuwula panapa (net) pili-ngini nuwa nginti-matanga muputi,” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Api awarra Simon yimi kangatawa, “Ngiya amintiya ngiya-mamanta waya yimpaja nguntu-wunyawani anaki panapa karri japinamini api karri-kamini muputi. Kiyi karri natinga arawunga awanuwanga karri-kamini. Api nginja alawura kangiya amintiya jiyimi ngini ngiya ngimata-nyawu panapa api ngiya kuwa ngirimi kangi nginja,” yimi awarra Simon kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Api Simon amintiya awuta wawurruwi kapi wutiyati waki pirimi wuta purruwuriyi kapi kipirla kiyi purruwunyawu awinyirra panapa. Kiyi purruwunga yingarti muputuwi kiyi awinyirra panapa waya yinkitayi juwawurra. ");
INSERT INTO tiw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Api kiyi awarra Simon jingawu yimi kapi ngarra-mamanta kapi pirripalamiya kapi nyonga kapala kiyi yimi ngini, “Awi, mamanta, kali api nyirra-wani (help) ngawa.” Awuta ngarra-mamanta api wuta yintanga James amintiya John api wuta-rringani Zebedee. Awuta yuwurrara amintiya Simon wutiyati waki pirimani. Api karri Simon ngarra-mamanta punuwuriyi kangatawa api Simon amintiya ngarra-mamanta purruwunga awuta muputuwi kiyi pirripamukuri awuta muputuwi kapi Simon angatawa kapala amintiya kapi awinyirra nyonga kapala. Kiyi yingarti muputuwi kapi awinyirra yirrara kapala api awinyirra kapala waya yinkitayi jipungarti. ");
INSERT INTO tiw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10a","Api karri Simon amintiya ngarra-mamanta pirripakuluwunyi awuta yingarti muputuwi wuta pirimarlingiyi (got a surprise) api Simon yipamukuri ngarra yirrara yimpula kangi yakuluwuni (knelt down) yinkitayi kapi ngawa-yuwuni ngarra malapwara api yimi kapi ngawa-yuwuni, “Aya, mantani, tuwariyi pili nginja warntirrana pupuni amintiya ngiya jirti tini,” yimi Simon kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK5_10b","072_5_10b","LUK","5","10b","10b","Kiyi ngawa-yuwuni yimi kapi Simon, “Ngajiti nimpaja-wanga. Nginja amintiya nginja-mamanta pakinya kularlaga ngintirimani muputuwi api nuwa wiyi kularlaga ngimpirimi tiwi ngini ngintini-mata-marruriyi awuta kangilawa. Api nuwa nyirru-waripa api nyirra-punya ngiya,” yimi ngawa-yuwuni kangi awarra Simon. ");
INSERT INTO tiw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Api kiyi Simon amintiya ngarra-mamanta pirikitikimi (pulled) angi-wutawa kapala kapi tingata kiyi purrupumwari awinyirra kapala amintiya awuta yingarti muputuwi amintiya panapa (net). Kiyi wuta pirripapunya ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kiyi natinga wumunga (one day) ngawa-yuwuni Jesus yipawuriji yilaruwu kangi natinga kurrampali kiyi awungaji yimuwu api yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Kiyi yingampa Pharisees amintiya yingampa scribes purruwuriyi kapi awinyirra kurrampali api pirripawuriji yilaruwu. Yingampa awuta Pharisees amintiya scribes wuta japuja pirimi kapi yingarti town kapi awarra murrakupuni Galilee amintiya yingampa japuja pirimi awungarruwu kapi awarra murrakupuni Judea amintiya kapi awarra town Jerusalem. Wuta punuwuriyi kapi ngawa-yuwuni pili wuta purru-wutimarti ngini pimata-pitingaya (to hear) awarra ngirramini ngini ngarra nimarra yimi. Ngawa-rringani waya yipakirayi ngawa-yuwuni Jesus power ngini pupuwi yimata-kirimi awuta arikutumunuwi kapi wuta jana. ");
INSERT INTO tiw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Api kiyi yingampa wawurruwi kapi wuta tangarima pirimi kapi awarra town api wuta piri-pitingaya (heard) ngini ngawa-yuwuni Jesus pupuwi yikirimi awuta arikutumunuwi kapi jana api pirimarruriyi wuta-mantani kapi awinyirra kurrampali kapi ngawa-yuwuni Jesus yuwunu-waluwa (taught) awuta arikutumunuwi. Api wuta mantani ngini-ngatawa yirrikarla amintiya kurumuta waya yuwunjarli (paralysed) api ngarra karluwu yirrija-ngulimayi (couldn't walk) api wuta pirripamukuri ngarra kapi tawulimutinga (blanket). Kiyi pirripamanipayi (lifted up) awinyirra tawulimutinga angi awarra wuta-mantani yuwujingi-milani kiyi pirimarruriyi awarra wuta-mantani kapi awinyirra kurrampali kapi ngawa-yuwuni yimuwu. Karri wuta papi pirimi kapi awinyirra kurrampali api wuta purru-wutimarti ngini pimata-marruriyi wuta-mantani kapi ngawa-yuwuni api karluwu pili tayikuwapi mimpa pirimi yilaruwu kangi awinyirra kurrampali. Api awuta wawurruwi pirripakuturruwa awarra wuta-mantani kapi awinyirra tawulimutinga api pirripakilinga kuriyuwu kapi awarra step kiyi purruwuriyi kangi awinyirra roof kuriyuwu kapi awinyirra kurampali. Kiyi wuta pirikirimi arikulani yangamini kuriyuwu kangi roof api kiyi pirikimirna arlipurringa kangi awinyirra tawulimutinga angi awarra wuta-mantani yuwujingi-milani api wuta pirripapirray-amuwi (let him down) awarra wuta-mantani yilaruwu kangi kurrampali api ngarra yimiringarriji (landed) yinkitayi kangi ngawa-yuwuni ngarra malapwara. ");
INSERT INTO tiw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Karri ngawa-yuwuni yipakuluwunyi awuta arikutumunuwi ngini wuta pirripapirray-amuwi wuta-mantani kangatawa api yimi kangatamiya, “Naki tini amintiya ngarra-mamanta warntirrana wurimajawu ngini ngiya wiyi pupuni ngirikirimi ngarra,” yimi ngawa-yuwuni kangatamiya. Kiyi yimi kangi awarra tini, “Aya, ngiya waya putuputuwu ngirripakirayi (forgive) nginja awarra jirti ngini jiyikirim-ani (the wrong you have done),” yimi ngawa-yuwuni kangi awarra tini ngini ngarra karluwu yirrija-ngulimayi (couldn't walk). ");
INSERT INTO tiw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Awuta Pharisees amintiya awuta scribes, karri wuta piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yimi kapi awarra tini api wuta pirimi kangi wutalamiya, “Naki awarra Jesus ngajiti awungani nimarra awajami pili ngarra wangata ngawa-rringani ngini kuriyuwu putuputuwu yirrija-kirayi (can forgive) ngawa awarra jirti ngini ngintiri-kirim-ani. Naki awarra Jesus karluwu putuputuwu yimata-kirayi ngawa awarra jirti ngini ngintiri-kirim-ani,” pirimi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ngawa-yuwuni Jesus yimajawu awarra ngini awuta Pharisees amintiya awuta scribes pirripangiraga kangi wutalamiya ngini (about) ngarra api yimi kangi wuta, “Pilikama nuwa awarra nimarra ngimpirimi kangi nuwulamiya ngini (about) ngiya?” yimi ngawa-yuwuni kapi awuta. ");
INSERT INTO tiw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kiyi ngarra yimi ngini, “Nuwa ngimpirimi ngini ngiya kunyani ngirimi kapi awarra tini ngini ngiya putuputuwu ngipakirayi ngarra awarra jirti ngini ngarra yikirim-ani (the wrong he has done). Arramukuta nuwa awarra ngirramini ngimpirimi pili nuwa amparrimani ngimparimi ngini ngiya karluwu pupuni ngimata-kirimi ngarra,” yimi ngawa-yuwuni kapi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kiyi ngarra yimi kangi wutawa, “Kayi, ngiya-rringani ngini kuriyuwu yipakirayi ngiya power ngini ngiya pupuwi ngimata-kirimi awuta arikutumunuwi kapi wuta purunjuwi amintiya ngarra awanuwanga yipakirayi ngiya power ngini ngiya putuputuwu ngimata-kirayi arikutumunuwi awarra jirti ngini wuta pirikirim-ani. Api ngiya wiyi nguwujiyarra naki tini ngini ngarra wiyi pupuni arima api ngarra wiyi apukularri kiyi tuwanga apangulimayi. Api karri nuwa wiyi ngimpakuluwunyi ngarra ngini pupuni arimi api awungarri nuwa wiyi ngimpiri-majawu ngini awarra ngirramini ngini ngiya ngipangiraga api awarra ngirramini warntirrana, awarra ngirramini ngini ngiya nimarra ngirimi ngini ngiya power ngini putuputuwu ngimata-kirayi arikutumunuwi awarra jirti ngini wuta pirikirim-ani. Amintiya nuwa awanuwanga wiyi ngimpiri-majawu ngini nuwa nuwa-yuwuni ngiya nuwa awuta tayikuwapi arikutumunuwi.” Awarra yimi ngawa-yuwuni kangi awuta Pharisees amintiya scribes. Kiyi ngawa-yuwuni Jesus yimi kapi awarra tini ngini ngarra karluwu yirrija-ngulimayi, “Aya, kutupi tami, tanga anginjila tawulimutinga (blanket) api tuwariyi japuja,” yimi ngawa-yuwuni kangi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Api kiyi awarra tini yartipili kutupi yimi kiyi tayinti yimi kuluwuta kangi awuta tayikuwapi arikutumunuwi api yuwunga tawulimutinga kiyi yipakupawurli japuja. Karri ngarra yuwujirr-angulimay-ani api ngarra yikuruwarni ngawa-rringani ngini kuriyuwu pili ngawa-yuwuni pupuni yikirimi ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Awuta tayikuwapi arikutumunuwi, karri wuta pirripakuluwunyi ngawa-yuwuni ngini yikirimi awarra tini ngini yipangulimayi api wuta pirimarlingiyi (got a surprise) api wuta puru-kuruwarni ngawa-rringani. Api wuta pirimajirri, “Ngarra awarra warntirrana pupuni mirrikili (miracle) ngini naki Jesus ninganara yikirimi,” pirimi awuta tayikuwapi arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ninkiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purruwuriyi kapi awarra town Nain. Wutatuwu tayikuwapi arikutumunuwi pirripapunya awuta. ");
INSERT INTO tiw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Karri ngawa-yuwuni amintiya awuta arikutumunuwi purruwuja yinkitayi kapi awarra town Nain api wuta purruwunyayi yingampa arikutumunuwi kapi wuta pirripakuturruwa yati malakaninga ngini ngarra waya pajuwani. Wuta pirripakuturruwa awarra kangi kirijinga palapala. Awarra nayi malakaninga ngini ngarra pajuwani api ngarra-naringa nyirra waya wangatamiya pili nyirra-mwarti yatilani amintiya nyirra amparruwu. Karri nyirra juwujirr-angulimay-ani nyirra pirlikiti jiyimi. ");
INSERT INTO tiw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Karri ngawa-yuwuni yipakuluwunyi awinyirra amparruwu api putuputuwu yipakirayi awinyirra amintiya yimi kangi nyirra, “Ngajiti pirlikiti nimpaja-mi,” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kiyi ngarra yuwuriyi kapi awinyirra kirijinga palapala angi wuta pirripakuturruwa awarra malakaninga ngini ngarra pajuwani yimi api yipamukuri ngarra yikara kangi awinyirra palapala api awungarri awuta arikutumunuwi kapi pirripakuturruwa awinyirra palapala purruwunjarli (stopped). Kiyi ngarra ngawa-yuwuni yipangiraga, “Aya, malakaninga, takularri,” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Api karri ngawa-yuwuni awarra yipangiraga api ngarra awungarri awarra malakaninga yimpangini yima kiyi yimuwu amintiya nimarra yimi. Kiyi ngawa-yuwuni yuwani (helped) awarra malakaninga ngini kutupi yimi kapi yakuluwuni api yimi kangi awinyirra amparruwu, “Ngarra naki nginja-mwarti. Ngarra waya yimpangini,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Awuta tayikuwapi arikutumunuwi karri wuta pirripakuluwunyi awarra malakaninga ngini ngarra yimpangini yima api awungarri pirimarlingiyi (got a surprise) api nimarra pirimajirri, “Naki Jesus ngarra warntirrana prophet api ngawa-rringani ngini kuriyuwu yini-pangirri (sent) ngarra ngini yimata-jiyarra ngawa ngini-ngatawa ngirramini amintiya ngini yimata-wani (to help) ngawa arikutumunuwi kapi awarra ngawa-rringani arimamula (calls) ngawa ngarra-mamirampi,” pirimi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kiyi awuta arikutumunuwi purruwuriyi kapi yingarti murrakupuni ngini-wutawa Jews kiyi awungarruwu purru-wuntiyarra awuta tayikuwapi arikutumunuwi ngini ngawa-yuwuni yikirimi awarra mirrikili (miracle) kapi awarra malakaninga. ");
INSERT INTO tiw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Karri awarra John the Baptist ngarra yimuwu kapi jail api awungarri yingampa ngarra-mamanta purru-wutiyarra awarra John ngini ngarra ngawa-yuwuni Jesus yingarti mirrikili (miracle) yikirimi. Api awarra John the Baptist yimi kapi yuwurrara ngarra-mamanta, “Nyirru-wariyi kapi awarra Jesus api nuwa nanginta nyirrami ngarra, ‘Arrami nginja awarra Christ ngini ngawa-rringani parlingarri yipangiraga ngini ngarra wiyi yini-mata-ngirri (would send) nginja kangawula, arrami nginja karluwu awarra. Marri? Arramukuta ngawa arnapa ngamata-muwu (should wait) karri awarra nyoni wiyi awunu-wuriyi kangawa?’ Awarra nanginta nyirrami awarra Jesus,” yimi awarra John kangi awuta yuwurrara ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Kiyi awuta yuwurrara wawurruwi purruwuriyi kapi ngawa-yuwuni Jesus. Karri wuta papi pirimi kapi ngawa-yuwuni api ngarra awungarri mirrikili yuwuji-kirim-ani. Ngarra pupuwi yikirimi tayikuwapi awuta arikutumunuwi kapi purunjuwi amintiya kapi wuta yinkilatuwi. Amintiya awuta kapi maputirruwi pirripalamiya yilaruwu kangi wuta purnikapa api ngarra papi yiniri-mamiyi awuta maputirruwi. Kiyi awuta yuwurrara wawurruwi kapi John the Baptist ngarra-mamanta api nanginta pirimi ngawa-yuwuni awarra ngirramini (question) ngini awarra John the Baptist yuwuntiyarra awuta. Api ngawa-yuwuni ngarra arnuka yartipili yipangiraga kangi awuta yuwurrara wawurruwi api ngarra tuwanga yikirimi mirrikili (miracle). ");
INSERT INTO tiw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kiyi ngawa-yuwuni wiyi (later on) yipangiraga kapi awuta yuwurrara wawurruwi, “Nyirra-kupawurli kapi awarra John the Baptist kiyi nyirra-jiyarra awarra ngini (what) nuwa ninganara nginti-pakuluwunyi, ngini awuta arikutumunuwi kapi yinkilatuwi api ngiya ngirikirimi awuta ngini waya wupakuluwunyi. Awanuwanga awuta kapi wuta karluwu pirrija-ngulimayi (couldn't walk) pakinya api ngiya waya ngirikirimi awuta ngini wupangulimayi amintiya awuta kapi purruwuni jana kapi wuta mipurra api wuta mipurra waya pupuni. Awanuwanga awuta kapi kalanjarruwi api wuta waya wuri-pitingaya (hear). Amintiya ngiya waya yimpanguwi ngirikirimi awuta kapi wuta pajuwani pirimi. Kiyi ngiya nguwuntiyarra arikutumunuwi ngawa-rringani ngini-ngatawa pupuni ngirramini, awuta arikutumunuwi kapi yingampa tiwi wurimi ngini wuta kuwulingipi. Nyirra-jiyarra awarra nuwa-mantani John the Baptist awarra ngini ngiya nguwuji-kirimi (what I am doing).” Ngawa-yuwuni yimi awarra kangi awuta yuwurrara wawurruwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kiyi ngawa-yuwuni yimi kangi awuta yuwurrara, “Nyirra-jiyarra awarra John ngini awuta arikutumunuwi kapi warntirrana kuwa wurimi ngini-ngilawa ngirramini api wuta kukunari wurimi.” Awarra ngawa-yuwuni yipangiraga kapi awuta yuwurrara wawurruwi kapi ngarra John yini-pangirri (sent) kangatawa. ");
INSERT INTO tiw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Karri awuta yuwurrara wawurruwi purrupumwari ngawa-yuwuni api awungarri ngawa-yuwuni yipangiraga kapi awuta tayikuwapi arikutumunuwi ngini (about) awarra John the Baptist. Api yimi ngini, “Awi, awarra John the Baptist karri ngarra japuja yimi awungarruwu kapi awarra murrakupuni kapi karri-kuwapi tiwi japuja wurimi api nuwa tayikuwapi nguntuwuriyi awungarruwu kapi ngarra pili nuwa nguntu-wutimarti ngini nginti-mata-pitingaya (hear) awarra ngawa-rringani ngirramini ngini awarra John tulimiya (straight) yipangiraga. Ngarra karluwu yimakirri yingampa tiwi.” Ngawa-yuwuni awarra yimi kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kiyi ngawa-yuwuni yimi ngini, “Nuwa karluwu nguntuwuriyi awungarruwu kapi awarra John ngini nginti-mata-kuluwunyi yati tini ngini arikuripiya (wears) pupuka kuluji pili awuta arikutumunuwi kapi wurikuripiya pupuka kuluji amintiya kapi wuni yingarti kunawuni api wuta nginingaji awuta alawuruwi kapi wuta wurumuwu kapi arikulanga kurrampali angi pupuka. Api awarra John ngarra karluwu nginingaji awuta arikutumunuwi. Ngarra arikuripiya kuluji angi animuli mipurra amintiya ngarra karri-kamini kunawuni awuni (has),” yimi ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","27","Api ngarra yimi kangi wutawa, “Yita nuwa nguntuwuriyi awungarruwu ngini nginti-mata-kuluwunyi awarra John pili ngarra prophet ngini yuwutiyarra nuwa ngawa-rringani ngini-ngatawa ngirramini. Awarra John ngarra ngatawa api yingampa prophets karlu-nara. Ngawa-rringani parlingarri yuwutiyarra nyoni prophet ngini (about) awarra John api awarra prophet yikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) awarra ngirramini ngini (about) awarra John, awarra ngirramini ngini ngawa-rringani yimi ngini, ‘Ngiya wiyi ngipangirri (send) awarra Christ kangi nuwa arikutumunuwi api pakinya ngiya wiyi ngipangirri nyoni tini kapi awarra nayi murrakupuni kiyi ngarra wiyi awutiyarra nuwa arikutumunuwi ngini awarra Christ wiyi awunu-wuriyi. Ngarra wiyi awarra nyoni tini awutiyarra nuwa arikutumunuwi ngini-ngilawa ngirramini api kiyi nuwa wiyi ready ngimpirimi karri awarra Christ wiyi awunu-wuriyi kangi nuwa arikutumunuwi.’ Awarra yimi ngawa-rringani parlingarri,” yimi ngawa-yuwuni kapi awuta arikutumunuwi. Kiyi yimi ngini, “Awarra John the Baptist api ngarra awarra nyoni tini ngini ngawa-rringani pakinya yini-pangirri (sent) ngarra awungarra kapi nuwa api ngarra ngawa-rringani yintuwu yini-pangirri ngiya kangi nuwa.” Awarra yimi ngawa-yuwuni kangi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kiyi yimi ngini, “Awarra warntirrana ngini awarra John ngarra ngatawa api yingampa tiwi karlu-nara, awuta kapi wuta parlingarri purumuwu kapi naki murrakupuni (on this earth) amintiya awuta kapi ningani wurumuwu. Api ngiya nguwutiyarra nuwa ngini awuta tiwi kapi kuwa wurimi kangilawa amintiya kapi wurimi ngini ngiya-rringani ngarra alawura kangi wuta api wuta warntirrana wutawa.” Awarra yimi ngawa-yuwuni Jesus kangi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tayikuwapi awuta arikutumunuwi kapi piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yipangiraga api wuta awuta pakinya piri-pitingaya awarra John the Baptist karri ngarra yuwuntiyarra awuta ngawa-rringani ngini-ngatawa ngirramini amintiya wuta kuwa pirimi awarra ngirramini api kiyi awarra John the Baptist baptise yikirimi awuta. Api kiyi wuta pirripapunya ngawa-rringani angatawa pupuka jarrumoka. Awuta wawurruwi kapi waki pirimani ngini (for) awuta Roman alawuruwi amintiya nanginta pirimani wuta-mamanta awuta Jews awarra kunawuni ngini tax api yingampa awuta awanuwanga kuwa pirimi John the Baptist ngini-ngatawa ngirramini. Awuta Pharisees amintiya yingampa arikutumunuwi pirimi ngini wuta jajiruwi awuta tiwi kapi nanginta pirimani kunawuni ngini tax kapi awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Awuta Pharisees amintiya awuta scribes api wuta arnuka purru-wutimarti ngini pimata-punya ngawa-rringani angatawa jarrumoka angi warntirrana api wuta arnuka kuwa pirimi awarra John ngini-ngatawa ngirramini api awarra John arnuka baptise yikirimi awuta. ");
INSERT INTO tiw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Kiyi ngawa-yuwuni yimi kapi awuta arikutumunuwi, “Nuwa arikutumunuwi kapi ningani ngumpuru-muwu api nuwa nginingaji kakirijuwi kapi pokayini wurimi kapi turruwuni api yingampa kakirijuwi wurikirimi jirti yirrikilingapa api wuta-mamanta jingawu wurimi kangi wutawa, ‘Pilikama nuwa karluwu pokayini ngimpirimi kangawa? Yita ngawa pakinya ngintiri-kirimi music api nuwa karluwu kukunari amintiya karluwu yoyi ngintirimi. Kiyi ngawa mamanukuni ngintiri-kuruwala api nuwa karluwu pirlikiti ngintirimi. Nuwa karluwu ngimpiri-majawu awarra ngini nuwa ngimpitimarti.’ Wuta awarra wurimi awuta kakirijuwi kapi awuta yingampa kakirijuwi kapi wuta karluwu wutimarti ngini pokayini pimatami kangi wutawa. Nuwa arikutumunuwi nginingaji awuta kakirijuwi kapi wuta karluwu wutimarti ngini pokayini pimatami kapi wuta-mamanta pili nuwa awanuwanga karluwu ngimpiri-majawu awarra ngini nuwa ngimpitimarti.” Awarra yimi ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kiyi ngarra tuwanga yimi ngini, “Awarra John the Baptist yimuwu wangatamiya kapi awarra murrakupuni kapi karri-kuwapi tiwi japuja wurimi amintiya ngarra karluwu yimangapa wine amintiya karluwu yuwapa kirritawuni. Waya juwa ngarra yuwapa wartiyanginila yinkiti. Api nuwa ngintirimi ngini, ‘Yita awarra John the Baptist api maputiti waya yipalamiya yilaruwu kangi ngarra purnikapa.’ Awarra nuwa ngintirimi,” yimi ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kiyi ngarra tuwanga yimi ngini, “Ngiyatuwu nuwa-yuwuni nuwa tayikuwapi arikutumunuwi api ngiya arnuka nginingaji awarra John the Baptist. Ngiya yimpaja nguwapa kirritawuni amintiya ngirimangapa wine api nuwa arikutumunuwi ngimpirimi ngini ngiya nguwapa yingarti yinkiti amintiya ngini ngiya ngirimangapa wine. Amintiya nuwa ngimpirimi ngini ngiya-mamanta awuta kapi wuta karluwu kuwa wurimi ngini-ngawula ngirramini (law) amintiya nuwa ngimpirimi ngini ngiya-mamanta awuta kapi wuta nanginta wurimi ngawa Jews awarra kunawuni ngini tax. Api awarra nuwa ngimpirimi ngini ngiya karluwu pupuni tini. Nuwa nginingaji awuta kakirijuwi karri nuwa awungani (that way) nimarra ngimpirimi.” Awarra ngawa-yuwuni yimi kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kiyi tuwanga yimi ngini, “Nuwa yingampa (some) arikutumunuwi api nuwa arnuka pungintamuwi (clever) pili nuwa arnuka ngimpitimarti ngini kuwa nginti-matami awarra ngirramini ngini ngiya amintiya awarra John the Baptist nguntu-wutiyarra nuwa, ngini-ngatawa ngirramini ngawa-rringani. Api yingampa (others) kapi nuwa arikutumunuwi api nuwa pungintamuwi pili nuwa ngimpiri-majawu ngini ngawa-rringani ngini-ngatawa ngirramini awarra warntirrana amintiya nuwa kuwa ngimpirimi awarra ngirramini.” Awarra yimi ngawa-yuwuni kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kiyi yati Pharisee ngini ngarra yintanga Simon, yuwuriyi kapi ngawa-yuwuni Jesus api yimi kangatawa, “Kali tuwaripa kangilawa japuja api ngawiyati ngawapa yinkiti muwa yuwurrara amintiya ngiya-mamanta,” yimi. Api ngawa-yuwuni yuwuriyi kangatawa japuja kiyi wutiyati purruwapa yinkiti. ");
INSERT INTO tiw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Awungarruwu kapi awarra town api natinga tinga jiyimuwu angi nyirra yingarti jirti jiyikirim-ani (had done a lot of wrong). Karri nyirra jiyipitingaya (heard) ngini ngawa-yuwuni yuwujing-apukani yinkiti kapi awarra Pharisee ngarra japuja api nyirra juwunga mintini ngini oil ngini pupuni yuwanti (smelt good) api jiyimarruriyi awarra mintini kapi ngarra japuja awarra Pharisee. ");
INSERT INTO tiw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kiyi awinyirra tinga jipawuriji yilaruwu kapi awinyirra kurrampali kiyi juwuriyi kapi ngawa-yuwuni api tayinti jiyimi yinkitayi kapi ngarra malapwara. Nyirra pirlikiti jiyimi kiyi awarra pirlikiti alala yimi kiyi yipakupuraji kapi ngini-ngatawa malapwara. Kiyi nyirra jiyimuwu yinkitayi kapi ngarra malapwara. Nyirra awinyirra tinga juwunyirri (wiped) ngarra malapwara wutuliyi (with) nyirra murrula pili nyirra juwuni (had) yurrukuni murrula. Kiyi nyirra jupukuruwu (kissed) ngarra malapwara kiyi jipamutiyi (poured) awarra oil ngini pupuni yuwanti kangi ngarra malapwara. ");
INSERT INTO tiw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Awarra Pharisee yipakuluwunyi awinyirra tinga ngini jiyikirimi awarra (did that) kangi ngawa-yuwuni api yimi kangatamiya, “Arramukuta awarra naki Jesus karluwu prophet nginingaji awuta prophets kapi ngawa-rringani awuni-pangirri (sends) kapi ngawa arikutumunuwi. Ngini ngarra warntirrana prophet api ngarra amari-majawu (would have known) ngini anaki yimpalinya nyirra jiringa tinga,” yimi kangatamiya awarra Pharisee. ");
INSERT INTO tiw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ngawa-yuwuni yimajawu awarra ngirramini ngini awarra Pharisee yimi kangatamiya api ngarra yimi kangatawa, “Aya, Simon, ngiya nguwutimarti ngini ngimata-ngiraga kanginja,” yimi ngawa-yuwuni. Kiyi awarra Pharisee yimi ngini, “Manya, tangiraga, mantani.” ");
INSERT INTO tiw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Api kiyi ngawa-yuwuni yuwutiyarra awarra Simon naki ngirramini, yimi ngini, “Parlingarri yimuwu yati alawura. Kiyi yuwurrara wawurruwi purruwuriyi kapi awarra alawura kiyi nanginta pirimi ngarra kunawuni. Awarra alawura yipakirayi yati tini yingarti kunawuni amintiya yipakirayi awarra nyoni tini kiyija. ");
INSERT INTO tiw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kiyi wiyi (later on) awarra alawura yimi kangi awuta yuwurrara wawurruwi, ‘Ngunta-luwapa awarra kunawuni ngini ngiya ngirripakirayi nuwa.’ Api awuta yuwurrara pirimi ngini, ‘Ngawa karri-kamini awarra kunawuni.’ Api awarra alawura putuputuwu yipakirayi awuta yuwurrara api ngarra yimi kangi awuta, ‘Waya manya. Ngajiti ngimpaja-kiray-awurli (pay back) ngiya awarra kunawuni,’ yimi kangi awuta.” Awarra ngirramini (story) ngawa-yuwuni yuwutiyarra awarra Pharisee Simon. Kiyi nanginta yimi awarra, “Aya, Simon, awuta wawurruwi puranji purumuwu awarra alawura pili ngarra putuputuwu yipakirayi awuta api nginuwani warntirrana puranji yimuwu (loved him most) awarra alawura? Arramukuta awarra tini ngini awarra alawura yipakirayi ngarra yingarti kunawuni? Arramukuta awarra nyoni tini ngini awarra alawura yipakirayi ngarra kiyija kunawuni? Nginuwani warntirrana puranji yimuwu awarra alawura?” Awarra yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Api awarra Simon yimi ngini, “Awarra tini ngini yuwunga yingarti kunawuni.” Api ngawa-yuwuni yimi ngini, “Awarra ngini nginja jipangiraga api awarra warntirrana, Simon,” yimi ngawa-yuwuni kangi awarra Pharisee Simon. ");
INSERT INTO tiw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kiyi ngawa-yuwuni yipakuluwunyi awinyirra tinga kiyi ngarra yimi kapi Simon, “Aya, Simon. Karri ngiya mampara ngini-pawuriji yilaruwu kanginjila japuja api nginja karluwu jipakirayi ngiya kukuni ngini mwarliki ngimata-kirimi ngini-ngilawa malapwara. Api tayakuluwunyi anaki tinga api karri nyirra pirlikiti jiyimi api awarra pirlikiti alala kangi ngiya malapwara kiyi nyirra juwunyirri (wiped) ngiya malapwara wutuliyi (with) nyirra murrula,” yimi ngawa-yuwuni kangi awarra Simon. ");
INSERT INTO tiw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kiyi tuwanga yimi kangatawa, “Amintiya nginja karluwu jupukuruwu (kissed) ngiya karri ngiya ngini-pawuriji yilaruwu kanginjila japuja api awinyirra tinga yimpaja jupukuruwu ngiya kangilawa malapwara. ");
INSERT INTO tiw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Amintiya nginja karluwu jipamutiyi (didn't pour) oil kangi ngiya pungintaga api anaki tinga jipamutiyi pupuni oil kangi ngiya malapwara.” Awarra ngawa-yuwuni yipangiraga kangi awarra Pharisee Simon. ");
INSERT INTO tiw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kiyi ngawa-yuwuni yimi ngini, “Awuta arikutumunuwi kapi kiyija jirti wurikirimi (do a little wrong) api karri awarra ngiya-rringani putuputuwu apakirayi (forgives) awuta awarra kiyija jirti ngini wuta wurikirimi api awuta arikutumunuwi waya juwa kiyija puranji wurumuwu ngatawa. Api anaki tinga nyirra yingarti jirti jiyikirim-ani api ngiya-rringani waya putuputuwu yipakirayi awinyirra api nyirra warntirrana puranji ampirimuwu ngiya-rringani amintiya awanuwanga ngiya.” Awarra yimi ngawa-yuwuni kangi awarra Pharisee Simon. ");
INSERT INTO tiw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kiyi ngawa-yuwuni yimi kangi awinyirra tinga, “Ngiya waya putuputuwu ngirripakirayi nginja awarra jirti ngini nginja jiyikirim-ani (the wrong you've done),” yimi kangi awinyirra tinga. ");
INSERT INTO tiw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kiyi awarra Pharisee Simon amintiya ngarra-mamanta kapi wutiyati purru-wujing-apukani yinkiti api nimarra pirimajirri, “Yita waya juwa ngawa-rringani ngini kuriyuwu putuputuwu yirrija-kirayi (can forgive) ngawa awarra jirti ngini ngawa ngintiri-kirim-ani (the wrong we've done), karluwu naki awarra Jesus,” pirimi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kiyi ngawa-yuwuni yimi kangi awinyirra tinga, “Nginja waya kuwa jiyimi kangilawa api awarra ngiya putuputuwu ngirripakirayi nginja api kiyi nginja wiyi yiloti nimpirimuwu kuriyuwu kangi ngiya-rringani japuja. Api kukunari tami kiyi tuwariyi kanginjila japuja.” Awarra yimi ngawa-yuwuni kangi awinyirra tinga. ");
INSERT INTO tiw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Karri nyonga wumunga (day) ngawa-yuwuni Jesus yimarruriyi awuta yuwurrajirrima ngarra-mamanta Peter kiyi James amintiya John kuriyuwu kapi jupunyini (hill). Api ngarra ngawa-yuwuni yuwuriyi awungarruwu ngini nimarra yimatami kapi ngarra-rringani ngini kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Karri ngarra nimarra yuwujingi-mani kapi ngarra-rringani api ngarra yirrikilingapa amintiya angatawa kuluji ngirri-ngirri jiyimi nginingaji awinyirra warnarringa. ");
INSERT INTO tiw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kiyi awarra prophet Elijah amintiya awarra Moses kapi wuta parlingarri purumuwu api wuta awungarri papi pirimi awungarruwu kiyi nimarra pirimi kapi ngawa-yuwuni. Ngawa-rringani ngini kuriyuwu yini-pangirri (sent) awuta yuwurrara kapi ngawa-yuwuni. Awarra Elijah amintiya awarra Moses wuta wiyarri ngirri-ngirri pirimi. Awuta yuwurrara amintiya ngawa-yuwuni nimarra pirimajirri ngini (about) ngawa-yuwuni karri ngarra wiyi pajuwani arimi kapi awarra arikitirropurtayi (cross) kapi Jerusalem. ");
INSERT INTO tiw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Karri awuta yuwurrajirrima ngawa-yuwuni amintiya awarra Moses amintiya awarra Elijah nimarra pirimajirri api wuta awungarri awarra Peter, James amintiya John wuta pirimajirripi. Api karri wuta pirripangipari api wuta pirripakuluwunyi ngawa-yuwuni ngini yuwujingi-rritani (standing) wuturiyi awuta yuwurrara jajingaruwi, Elijah amintiya Moses, amintiya wuta pirripakuluwunyi awuta ngini ngirri-ngirri pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Karri Elijah amintiya Moses waya yinkitayi purrupumwari ngawa-yuwuni api Peter yimi kapi ngawa-yuwuni, “Pupuni awarra ngini nginja jiniri-marruriyi ngawa awungarra. Yuwuni, ngini nginja nimpitimarti api ngiya amintiya ngiya-mamanta wiyi ngarikirimi marlani ngini (for) nuwa yuwurrajirrima. Nginjatuwu yati marlani kiyi awanuwanga yati ngini ngarra Moses kiyi yati ngini ngarra Elijah.” Awarra Peter pirlamarri (without thinking) yipangiraga. ");
INSERT INTO tiw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Karri awarra Peter nimarra yuwujingi-mani api awungarri yirrakunga (cloud) yini-papirraya kapi awarra jupunyini (hill) kiyi yipujirra awuta api wuta karluwu pimata-kuluwunyi awarra warnarringa api awuta yuwurrajirrima ngawa-yuwuni ngarra-mamanta wuta pirimakirri. ");
INSERT INTO tiw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kiyi wuta piri-pitingaya (heard) ngawa-rringani ngini-ngatawa yirringa (voice) yilaruwu kapi awarra yirrakunga api ngarra yimi ngini, “Ngiya awarra Jesus ngiya-mirani. Ngiya parlingarri ngurru-wunga (picked) ngarra api waya ngini-pangirri (sent) ngarra kapi awarra naki murrakupuni (to this earth). Nuwa nyirra-pitingaya (listen to) ngini-ngatawa ngirramini.” Awarra yimi ngawa-rringani yilaruwu kapi awarra yirrakunga. ");
INSERT INTO tiw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Api karri ngawa-rringani yipapaya ngini nimarra yimi api awarra Peter amintiya James amintiya John wuta pirripakuluwunyi ngawa-yuwuni ngini ngarra yuwujingi-rritani (standing) wangatamiya. Awuta Elijah amintiya Moses waya karluwu awungaji. Awuta yuwurrajirrima ngawa-yuwuni ngarra-mamanta karluwu purruwuntiyarra yingampa (other) arikutumunuwi awarra ngini wuta pirripakuluwunyi kapi jupunyini. Waya juwa karri ngawa-yuwuni wiyi (later on) pajuwani yimi api awungarri wuta purruwuntiyarra yingampa arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pangarri karri japinari ngawa-yuwuni Jesus amintiya awuta yuwurrajirrima ngarra-mamanta, Peter kiyi James amintiya John, wuta purrupumwari awarra jupunyini (hill). Kiyi awuta yingampa ngarra-mamanta amintiya awuta tayikuwapi arikutumunuwi purruwuriyi kangi wutawa. ");
INSERT INTO tiw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kiyi yati tini jingawu yimi kapi ngawa-yuwuni, “Aya, mantani, tayakuluwunyi ngiya-mirani api tawani ngarra pili ngarra yatilani (only one). ");
INSERT INTO tiw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yingampini (sometimes) yati maputiti apalamiya kangi ngarra purnikapa api ngarra awungarri ngiya-mirani jingawu arimi makirrana. Amintiya yingampini awarra maputiti arikirimi ngarra ngini yimata-nyawu ngatamiya kangi yakuluwuni amintiya awanuwanga arikirimi ngarra ngini yingarti pulingiya arimi. Api kiyi ngarra ngiya-mirani awuni (has) yingarti juwarti nginingaji jikiringa kangi ngarra yirruputara. Awarra maputiti awungani-la jirti ngirramini (trouble) apakirayi ngiya-mirani amintiya karlu-nara apumwari ngarra purnikapa,” yimi awarra tini kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kiyi nyoni nginaki yimi awarra tini kangi ngawa-yuwuni, “Ngiya pakinya nanginta ngirimi kapinaki nginja-mamanta ngini wuta papi pini-mata-mamiyi awarra maputiti ngini apalamiya kapi awarra ngiya-mirani ngarra purnikapa. Wuta purru-wutimarti ngini papi pini-mata-mamiyi awarra maputiti api karluwu.” Awarra tini yimi awarra kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kiyi ngawa-yuwuni yipangiraga kapi awuta arikutumunuwi, “Nuwa jajiruwi api ngiya pirringawini kangi nuwa pili nuwa karluwu warntirrana kuwa ngimpirimi kangilawa,” yimi ngawa-yuwuni kangi awuta arikutumunuwi. Kiyi ngawa-yuwuni yipangiraga kapi awarra tini, “Tamarruripa nginja-mirani kangilawa.” ");
INSERT INTO tiw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kiyi awarra tini yiniri-marruriyi ngarra-mirani kapi ngawa-yuwuni. Api karri awarra kirijini yinu-wuja api awarra maputiti yikirimi ngarra ngini yipakupuraji kapi yakuluwuni amintiya yikirimi ngarra ngini yingarti pulingiya yimi. Kiyi ngawa-yuwuni yuwutiyarra awarra maputiti, “Aya, maputiti, papi tamuwa (come out) api ngajiti tuwanga nimpaja-wuriji yilaruwu kapi ngarra purnikapa naki kirijini,” yimi ngawa-yuwuni kangi awarra maputiti. Api awungarri awarra maputiti papi yinirimi (came out) kiyi awarra kirijini pupuni yima. Kiyi ngawa-yuwuni yimi kangi awarra kirijini ngarra-rringani, “Aya, ngarra naki nginja-mirani,” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Awuta tayikuwapi arikutumunuwi karri wuta pirripakuluwunyi ngawa-yuwuni ngini papi yiniri-mamiyi awarra maputiti kapi awarra kirijini ngarra purnikapa api wuta pirimarlingiyi (got a surprise) api wuta nimarra pirimajirri, “Ngawa-rringani warntirrana yipakirayi awarra naki Jesus ngini-ngatawa power,” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ngawa-yuwuni Jesus yimajawu ngini ngarra waya yinkitayi pajuwani arimi amintiya ngini ngarra wiyi apakupawurli kapi ngarra-rringani ngarra japuja kuriyuwu api yimi kangatamiya, “Ngiya nguwuja kapi Jerusalem,” yimi ngawa-yuwuni. Ngarra karluwu worry yimi ngini awungarruwu kapi Jerusalem ngarra wiyi pajuwani arimi. Kiyi yipumwari awarra murrakupuni Galilee. ");
INSERT INTO tiw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kiyi ngawa-yuwuni yipangirri (sent) yingampa ngarra-mamanta aringampi kapi yati kirijini town awungarruwu kapi awarra murrakupuni Samaria. Kiyi awuta ngarra-mamanta purruwuriyi kapi awarra town api ngawa-yuwuni yintayi yimi. Kiyi ngawa-yuwuni ngarra-mamanta karri wuta papi pirimi awungarruwu api wuta pirimi kapi awuta arikutumunuwi, “Awi, mamanta, ngawa-alawura Jesus waya awunu-wuja awungarra. Ngarra awuja kapi Jerusalem api ngarra pakinya awutimarti ngini kiyija yimata-muwu awungarra,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Api awuta arikutumunuwi kapi japuja pirimi awungarruwu kapi Samaria pirimi kapi ngawa-yuwuni ngarra-mamanta, “Karluwu. Ngawa karluwu ngawutimarti ngarra ngini yimata-muwu awungarra pili ngarra pangarri wiyi awuriyi kapi Jerusalem,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kiyi wutatuwu awuta ngarra-mamanta pirripakupawurli kapi ngawa-yuwuni amintiya awuta yingampa ngarra-mamanta kiyi purru-wutiyarra ngarra ngawa-yuwuni awarra ngirramini ngini awuta arikutumunuwi kapi awarra town pirripangiraga. Karri James amintiya John piri-pitingaya (heard) awarra ngirramini ngini wuta-mamanta purru-wutiyarra ngawa-yuwuni api angi-wutawa yiminga jurrumumi jiyimi (became angry) api wuta pirimi kapi ngarra, “Aya, yuwuni, arramukuta ngawa nanginta ngamatami (should ask) ngawa-rringani ngini kuriyuwu ngini ngarra yimata-kirimi yikwani ngini yini-mata-pirraya kapi awarra town ngini yimata-kuwurratiya (burn up) awuta tiwi kapi awungarruwu japuja wurimi,” pirimi James amintiya John kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Api ngawa-yuwuni yipakuluwunyi awuta yuwurrara James amintiya John api ngarra yikirlimirri (growled at) awuta api yimi ngini, “Ngajiti awungani ngimpaja-ngiraga,” yimi ngawa-yuwuni kapi awuta yuwurrara. ");
INSERT INTO tiw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kiyi ngawa-yuwuni amintiya ngarra-mamanta karluwu purumuwu kapi awarra town api kiyi purruwuriyi kapi nyoni town. ");
INSERT INTO tiw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta karri pirripangulimayi kapi jarrumoka api yati tini yinuwuriyi kapi ngawa-yuwuni kiyi yimi ngini, “Kuta maka wiyi nimpuriyi api ngiya awungarruwu wiyi ngipapunya nginja.” ");
INSERT INTO tiw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Api ngawa-yuwuni yimi kangatawa, “Arrami nginja karluwu nimpirimajawu ngini ngiya karri-kamini kurrampali api ngiya karri-maka (nowhere) ngini ngimata-majirripi. Wuta animuluwi waya rayiti (alright) ngini wuni japuja nginingaji awarra kawarri arimuwu kapi tingiwini amintiya nyirra taringa ampirimuwu kapi yangamini api ngiya karri-kamini japuja ngiya awarra nuwa-yuwuni nuwa tayikuwapi arikutumunuwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kiyi ngawa-yuwuni nimarra yimi kapi nyoni tini, “Tayapunya ngiya.” Api yimi awarra tini, “Arnapa. Ngiya pakinya ngimatu-wariyi kapi ngiya-rringani japuja pili ngarra waya wulimani api karri ngarra wiyi pajuwani arimi api ngiya wiyi ngirikijika awarra ngiya-rringani api kiyi ngiya wiyi awungarri ngipapunya nginja.” ");
INSERT INTO tiw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Api yimi ngawa-yuwuni kangatawa, “Karluwu, pili awuta tiwi kapi ngarra ngawa-rringani ngini kuriyuwu karluwu arimamula (call) awuta ngarra-mamirampi api wuta awuta wurra-kijika (must bury) nginja-rringani karri ngarra pajuwani arimi. Nginja karluwu. Nginja tuwariyi tajiyarra yingampa tiwi ngawa-rringani ngini-ngatawa ngirramini. Tajiyarra awuta ngini awarra ngawa-rringani ngini kuriyuwu awutimarti ngini yimata-mangi awuta amintiya ngini wuta-alawura yimatami.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kiyi nyoni tini yipangiraga kapi ngawa-yuwuni, “Ngiya wiyi ngipapunya nginja api ngiya pakinya ngimata-kupawurli japuja pili ngiya nguwutimarti ngini ‘nimpangi’ ngimatami kapi ngiya-ngirimipi. Marri?” ");
INSERT INTO tiw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Api ngawa-yuwuni yimi kapi awarra tini, “Nuwa kapi ngimpirimi ngini nuwa ngimpitimarti ngini nginti-mata-punya ngiya api nuwa nyirra-pungintayi (think about) ngiya pakinya. Wutatuwu nuwa-ngirimipi api nuwa nyirra-pungintayi awuta yintayi (last) pili ngini (if) nuwa ngimpiri-pungintayi awuta nuwa-ngirimipi pakinya api nuwa wiyi karluwu warntirrana waki nginti-matami ngini (for) ngawa-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Karri nyonga wumunga (day) yati scribe awarra ngini ngarra yuwunu-waluwa (taught) arikutumunuwi Moses ngini-ngatawa ngirramini (law) api ngarra yimi kangatamiya, “Ngiya wiyi nanginta ngirimi awarra naki Jesus ngini (about) ngini-ngawula ngirramini (law). Arramukuta ngarra karluwu warntirrana arimajawu awarra ngirramini ngini-ngawula,” yimi kangatamiya awarra scribe. Api ngarra yuwuriyi kapi ngawa-yuwuni Jesus api ngarra nanginta yimi ngarra, “Aya, mantani. Ngiya nguwutimarti ngini yiloti ngimata-muwu kuriyuwu kapi ngawa-rringani ngarra japuja api awungana ngimatama?” yimi awarra scribe kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kiyi ngawa-yuwuni yimi kangi awarra scribe, “Nginja waya jikirrimiya (have read) ngini-ngatawa Moses ngirramini (law) ngini ngarra parlingarri yikirimi (wrote) kapi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) api kamini jikirrimiya kapi awarra punkaringini ngini nuwa nginti-mata-kirimi (should do), nuwa kapi ngimpitimarti ngini wiyi yiloti nginti-mata-muwu kuriyuwu kapi ngawa-rringani?” yimi ngawa-yuwuni kapi awarra scribe. ");
INSERT INTO tiw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Api ngarratuwu awarra scribe yimi ngini, “Moses yikirimi (wrote) kangi awarra punkaringini ngini, ‘Ngawa ngawurra-pungintayi (must think about) awarra ngatawa ngini ngarra japuja kuriyuwu (God) amintiya puranji ngawurra-muwu awarra. Ngawa warntirrana puranji ngawurra-muwu (must love) awarra ngini ngarra ngatawa. Ngawa awanuwanga puranji ngawurra-muwu yingampa arikutumunuwi nginingaji ngawa puranji ngarimuwu ngawalamiya.’ Awarra Moses yikirimi awarra kangi punkaringini,” yimi awarra scribe kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Api ngawa-yuwuni yimi kangatawa, “Awarra ngirramini ngini nginja jipangiraga api awarra warntirrana. Ngini nginja warntirrana puranji nimpirimuwu ngawa-rringani ngini kuriyuwu amintiya yingampa arikutumunuwi api nginja wiyi yiloti nimpirimuwu kuriyuwu kangi ngawa-rringani,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Api awarra scribe yimi kangatamiya, “Ngiya pupuni tini. Ngiya waya kuwa ngirimi ngini-ngatawa Moses ngirramini (law),” yimi kangatamiya. Api kiyi yimi kapi ngawa-yuwuni ngini, “Kuwapi awuta arikutumunuwi kapi ngawa puranji ngawurra-muwu?” yimi awarra scribe. ");
INSERT INTO tiw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Api ngawa-yuwuni yimi kapi awarra scribe, “Ngiya pakinya nguwutiyarra nginja naki ngirramini (story). Parlingarri yati tini ngini ngarra Jew yipumwari Jerusalem api yuwuriyi kapi awarra town Jericho. Karri ngarra yuwuja kangi jarrumoka yingampa wawurruwi kapi wuta mitayuwi purruwunga ngarra amintiya piripirni ngarra. Kiyi wuta tikimati pirimi angatawa kuluji amintiya mitaya pirimi ngini-ngatawa kunawuni. Kiyi wuta purrupumwari awarra tini kapi jarrumoka. Ngarra waya yinkitayi pajuwani yimi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kiyi ninganara yati priest ngini ngarra Jew api ngarra yipangulimayi kapi awinyirra-wanga jarrumoka. Karri ngarra yipakuluwunyi awarra tini ngini yimajirripi kangi jarrumoka api ngarra yipangulimayi yilipiyanga kiyi yuwuja-la. ");
INSERT INTO tiw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kiyi nyoni tini ngini waki yimani kapi jurra ngarra awanuwanga yipangulimayi kapi awinyirra jarrumoka. Karri ngarra yinuwuriyi yinkitayi kapi awarra tini ngini yimajirripi kangi jarrumoka api yipakuluwunyi ngarra kiyi ngarra awanuwanga yipumwari awarra tini kapi jarrumoka kiyi yuwuja-la. ");
INSERT INTO tiw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Kiyi nyoni tini yinuwuriyi kapi awinyirra-wanga jarrumoka amintiya ngini-ngatawa donkey. Api awarra tini ngini-ngatawa murrakupuni Samaria. Awuta arikutumunuwi kapi Jews amintiya awuta kapi wuta murrakupuni Samaria api wuta jirti purumuw-ajirri. Karri awarra tini ngini ngarra murrakupuni Samaria yipakuluwunyi awarra tini ngini ngarra Jew awarra ngini awuta mitayuwi piripirni api ngarra putuputuwu yipakirayi awarra tini. Kiyi ngarra yuwuriyi kangatawa kiyi yuwunyirri (wiped up) awarra majipani. Kiyi ngarra yipamukuri mirrijini amintiya yikimirna (bandaged) manipurruwa kapi ngarra jana. Kiyi ngarra yipamukuri awarra tini kuriyuwu kangi ngini-ngatawa donkey amintiya yimarruriyi awarra kapi awinyirra kurrampali (hotel) awungarruwu kapi arikutumunuwi purumuwani nginingaji yirrajirrima wumunga (days). Awungaji ngarra yipamangi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Karri pangarri awarra tini ngini ngarra murrakupuni Samaria yuwutimarti ngini yimatu-wariyi kapi nyoni murrakupuni api yipakirayi kunawuni kapi awarra tini ngini ngarra alawura kapi awinyirra kurrampali api yimi kangatawa, ‘Tayamangi naki awurrini pili ngiya waya nguwuja. Ngini ngarra jana yinukuni amintiya ngini nginja nimpitimarti tuwanga kunawuni api ngiya wiyi ngipakirayi nginja kunawuni karri ngiya wiyi nguwuni-pakupawurli (come back) awungarra.’ Api, ‘Manya’ yimi awarra alawura. Kiyi awarra tini ngini ngarra murrakupuni Samaria yipumwari awinyirra kurrampali.” Awarra ngirramini (story) ngawa-yuwuni yipangiraga kapi awarra scribe. ");
INSERT INTO tiw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kiyi ngawa-yuwuni yimi kapi awarra scribe, “Yuwurrajirrima jajingaruwi pirripangulimayi kapi awinyirra jarrumoka amintiya pirripakuluwunyi awarra tini ngini awuta mitayuwi piripirni. Api nginuwani puranji yimuwu awarra tini?” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Api awarra scribe yimi ngini, “Awarra tini ngini ngarra japuja yimi kapi awarra nyoni murrakupuni Samaria api ngarra puranji yimuwu awarra tini ngini awuta mitayuwi piripirni pili ngarra putuputuwu yipakirayi ngarra amintiya yipamangi ngarra,” yimi awarra scribe. Api ngawa-yuwuni yimi kangatawa, “Nginjalatuwu awungani tami (do like that). Putuputuwu tayakirayi tayikuwapi arikutumunuwi,” yimi ngawa-yuwuni kangi awarra scribe. ");
INSERT INTO tiw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Ngawa-yuwuni Jesus amintiya ngarra-mamanta tuwanga pirripapunya awinyirra jarrumoka angi juwuja kapi Jerusalem api karri waya kuluwuta wuta papi pirimi kapi yati town. Awungarruwu kapi awarra town awuta yuwurrara maminikuwi purumuwu. Natinga awinyirra yimpalinya api nyirra yintanga Martha api nyirrupwaka Mary. Kiyi Martha jiyimi kangi ngawa-yuwuni amintiya ngarra-mamanta, “Nyirru-waripa kangilawa japuja api awungaji nyirrapa yinkiti amintiya kiyija nyirra-muwu,” jiyimi Martha. Kiyi ngawa-yuwuni amintiya ngarra-mamanta pirripawuriji yilaruwu kangi Martha amintiya Mary angi-wutawa kurrampali. Api karri ngawa-yuwuni yimuwu awungaji kapi awinyirra kurrampali api ngarra yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. Kiyi nyirratuwu Mary juwuriyi kapi ngawa-yuwuni api jiyimuwu yinkitayi kapi ngarra malapwara pili nyirra juwutimarti ngini jimata-pitingaya (hear) awarra ngirramini ngini ngarra yipangiraga. ");
INSERT INTO tiw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Api nyirratuwu Martha, nyirra wangata jipawumi yingarti yinkiti ngini awuta tayikuwapi tiwi pimatapa. Nyirra karluwu kukunari jiyimi kangi nyirrupwaka Mary pili nyirra Mary karluwu juwani (help) awinyirra api nyirra juwuriyi kapi ngawa-yuwuni kiyi nanginta jiyimi ngarra, “Yuwuni, kama ngiyupwaka ampirimuwu awungarra amintiya ampiri-pitingaya (listen to) ngini nginja nimpangiraga pili ngiya wangatamiya ngipawumi yinkiti ngini nuwa tayikuwapi wiyi ngimpapa. Tajiyarra awinyirra ngini jimata-wani (to help) ngiya,” jiyimi Martha kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kiyi ngawa-yuwuni yimi kangi nyirra, “Martha! Nginja yingarti worry nimpirimi. ");
INSERT INTO tiw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ngiya nguwutimarti arikutumunuwi ngini pimata-pitingaya (listen to) ngini-ngilawa ngirramini api pupuni awarra ngini anaki nginjupwaka ampitimarti ngini jimata-pitingaya ngini-ngilawa ngirramini. Ngiya karluwu ngimata-jiyarra awinyirra ngini nyirra karluwu jimata-pitingaya ngiya!” yimi ngawa-yuwuni kapi awinyirra Martha. ");
INSERT INTO tiw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Karri nyonga wumunga (day) ngawa-yuwuni Jesus naki ngirramini (story) yipangiraga kapi ngarra-mamanta, “Yati kapi nuwa api ngini nginja nimpuriyi kapi nginja-mantani ngarra japuja karri japinamini api ngini nginja nimpirimi kangatawa, ‘Aya, mantani, ngunta-luwapa yinkiti pili ngiya-mantani ngini ngarra japuja arimi kapi karrampi murrakupuni api yinuwuriyi ninganara kapi ngiya japuja api ngiya karri-kamini yinkiti nguwuni ngini ngimata-kirayi ngarra.’ Api ngini nginja awarra nimpirimi kangi nginja-mantani, ");
INSERT INTO tiw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","api arrami awarra nginja-mantani wiyi arimi kapi nginja, ‘Pirri! Ngiya waya kunji ngirikirimi angilawa kurrampali amintiya ngiya-mamirampi waya wuji-majirripi. Ngiya karluwu kutupi ngimatami amintiya karluwu ngimata-kirayi nginja yinkiti.’ Arrami nginja-mantani awarra wiyi arimi kapi nginja. Kiyi arrami nginja wiyi karluwu kuwa jimatami nginja-mantani api wiyi tuwanga nanginta nimpirimi ngarra yinkiti. ");
INSERT INTO tiw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Api kiyi nginja-mantani arrami wiyi nimarra arimi kangatamiya, ‘Tani-waya (no matter) ngiya-mantani awarra naki api ngiya karluwu nguwutimarti ngini kutupi ngimatami ngini ngimata-kirayi ngarra yinkiti. Api ngarra karluwu kuwa arimi ngiya api awujirr-aparri ngiya api ngiya wiyi ngipakirayi ngarra kuta kamini awarra yinkiti ngini ngarra awutimarti (need).’ Awarra arrami nginja-mantani wiyi arimi kangatamiya.” Awarra ngirramini (story) yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Awarra warntirrana ngini ngawa-rringani ngini kuriyuwu awanuwanga apakirayi ngawa kuta kamini awarra ngini ngawa ngawutimarti awarra ngini ngawa nanginta ngarimi ngarra. Api nanginta nyirrami ngawa-rringani kuta kamini ngini nuwa ngimpitimarti (need) api ngarra wiyi awarra apakirayi nuwa. Amintiya kularlaga nyirrami awarra ngini nuwa ngimpitimarti api ngarra wiyi amanu-wani (help) nuwa ngini ngumpunyayi kuta kamini awarra ngini nuwa kularlaga ngimpirimi. Yimpaja nanginta nyirrami awarra ngawa-rringani awarra kuta kamini ngini nuwa ngimpitimarti api ngarra wiyi awarra apakirayi nuwa.” Awarra ngawa-yuwuni yimi kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Karri Sabbath Day (Saturday) ngawa-yuwuni Jesus yipawuriji yilaruwu kapi awinyirra kirijinga jurra angi-wutawa Jews (synagogue) api awungarruwu yuwunu-waluwa (taught) awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Awungaji kapi awinyirra jurra natinga yimpalinya juwujingi-muwani. Nyirra juwuni (had) maputiti kangi nyirra purnikapa. Nyirra jipajiyarri (her back was bent over) yiloti api karluwu tulimiya (straight) tayinti jimatami. Parlingarri awarra maputiti jana yikirimi awinyirra yimpalinya ngini nyirra waya awungani (that way) jipajiyarri. Nginingaji wamurrara punyipunyinga pakitiringa (18 years) nyirra waya awungani. ");
INSERT INTO tiw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Karri ngarra ngawa-yuwuni yipakuluwunyi awinyirra yimpalinya api ngarra awungarri jingawu yimi kangi nyitawa, “Kali. Tuwaripa,” yimi. Kiyi yimi ngini, “Nginja waya karluwu jana,” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Api kiyi yipamukuri ngini-ngatawa yirrara yikara kangi nyirra pungintaga api awungarri ngini-nyitawa purnikapa yartipili tulimiya (straight) yima api nyirra jiyikuruwarni (thanked) ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kiyi awarra tini ngini ngarra alawura kapi awinyirra jurra api jurrumumi yimi angatawa yiminga (became angry) pili karri Sabbath Day (Saturday) ngawa-yuwuni pupuka yikirimi awinyirra yimpalinya api yimi kapi awuta tiwi, “Ngawa waya juwa waki ngarimi kiringarra wumunga (days) api karluwu karri Sabbath Day pili ngawa Jews awungarri ngaru-kuruwarni (thank) ngawa-rringani api ngini nuwa ngimpitimarti awarra naki Jesus ngini pupuwi yimata-kirimi nuwa api ngajiti ngimpaju-wariyi kangatawa karri Sabbath Day. Waya juwa karri nyonga wumunga.” Ngarra awarra yipangiraga awarra alawura kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kiyi ngawa-yuwuni yimi kapi awarra alawura, “Nuwa kapi nuwa alawuruwi pupuwi ngimpiri-mamuliya api nuwa karluwu pupuwi pili nuwa wiyarri waki ngimpirimi karri Sabbath Day (Saturday). Yita karri awinyirra wumunga (day) nuwa ngumpuriyi kapi awuta ngini-nuwula puluka amintiya partita-partita kapi nuwa ngimpiri-kimirna (tie up) wuturiyi (with) arlipurringa api karri nuwa tikimati ngimpirimi arlipurringa api ngimpiri-marruriyi awuta animuluwi kapi kukuni api karri nuwa awungani ngimpirimi (do that) api nuwa awungarri waki ngimpirimi. Karri awinyirra Sabbath Day nuwa ngimpamangi kapi-nuwula animuluwi ");
INSERT INTO tiw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","api awarra ngini ngiya ngirikirimi (did) karri Sabbath Day ngini pupuka ngirikirimi awinyirra yimpalinya api pupuni awarra pili nyirra yinukuni jana. Wamurrara punyipunyinga pakitiringa (18 years) nyirra juwuni (had) awarra jana. Nyirra nguri awinyirra yimpalinya. Nyirra ampiri-mamula (calls) Abraham nyirra-amini nginingaji ngawa api pupuni awarra ngini ngiya pupuka ngirikirimi awinyirra karri Sabbath Day.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra alawura. ");
INSERT INTO tiw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Api karri ngawa-yuwuni awarra ngirramini yipangiraga api awarra alawura arliranga yikirimi. Amintiya awuta yingampa tiwi kapi wuta nimarra pirimi ngini ngawa-yuwuni jirti tini pili ngarra pupuka yikirimi awinyirra yimpalinya karri Sabbath Day api wuta awuta awanuwanga arliranga pirikirimi. Api wutatuwu yingampa awuta tiwi kukunari pirimi pili ngarra ngawa-yuwuni mirrikili (miracles) yikirim-ani ngini pupuwi yikirim-ani awuta kapi purunjuwi. ");
INSERT INTO tiw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kiyi karri Sabbath Day (Saturday) api ngawa-yuwuni Jesus yuwuriyi kapi yati Pharisee angatawa kurrampali kiyi yuwapa yinkiti awungarruwu. Waya awungaji yingampa Pharisees amintiya yingampa scribes purruwapa yinkiti wutiyati ngawa-yuwuni. Wuta awuta purru-wujirr-akuluwuny-ani ngawa-yuwuni pili wuta purru-wutimarti ngini kuta kamini ngarra wiyi arikirimi (do). ");
INSERT INTO tiw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kapi awinyirra kurrampali yati tini yimuwu ngini ngarra purunjini. Ngini-ngatawa yirrara kurumuta amintiya yirrikarla yimarrawuti (swollen). Kiyi awarra tini yipukularri kiyi yuwuriyi kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Karri ngawa-yuwuni yipakuluwunyi awarra tini api ngarra nanginta yimi awuta Pharisees amintiya awuta scribes, “Karri ngawa ngawunyayi tini ngini purunjini karri Sabbath Day (Saturday) api awungana ngawa ngamatama? Arramukuta ngawa pupuni ngarikirimi ngarra. Arramukuta karluwu. Api ngini ngawa pupuwi ngarikirimi awuta kapi purunjuwi karri Sabbath Day api arrami ngawa ngawawurrini (break) ngini-ngawula ngirramini (law). Arrami karluwu. Awungana nuwatuwu?” Awarra ngawa-yuwuni nanginta yimi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Api wuta karluwu nimarra pirimi kapi ngawa-yuwuni. Kiyi ngawa-yuwuni yipamukuri ngini-ngatawa yikara kapi awarra tini ngini ngarra kurumuta amintiya ngarra pakiriparri yimarrawuti api kiyi pupuni yikirimi ngarra. Karri awarra tini pupuni yima api ngawa-yuwuni yuwutiyarra ngarra ngini, “Manya tuwariyi!” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kiyi ngawa-yuwuni nanginta yimi awuta Pharisees amintiya awuta scribes, “Ngini yati tini ngini-ngatawa puluka apakupuraji kapi arikulani yangamini kangi yakuluwuni karri Sabbath Day (Saturday) api ngarra yartipili tikimati arimi awarra puluka. Tami? Amintiya ngini ngarra-mirani awanuwanga apakupuraji kapi arikulani yangamini karri Sabbath Day api ngarra yartipili tikimati arimi awarra. Tami?” Awarra ngawa-yuwuni awarra nanginta yimi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Api awuta Pharisees amintiya awuta scribes karluwu nimarra pirimi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK14_7a","072_14_7a","LUK","14","7a","7a","Ngawa-yuwuni Jesus nanuwanga (still) yuwujingi-muwani yilaruwu kangi awinyirra kurrampali angatawa awarra Pharisee. Yingampa tiwi kapi wuta karluwu alawuruwi purru-wutimarti ngini pimata-muwu yinkitayi kapi awarra Pharisee awungarruwu kapi awuta tiwi kapi wuta alawuruwi mwarimuwu (should have sat). Api ngawa-yuwuni yipakuluwunyi ngini awuta tiwi awungani pirimi (did that) ");
INSERT INTO tiw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","kiyi yimi kapi wuta, “Kuta kuwani awarra ngini arimi kangatamiya, ‘Ngiya ngilawa’ api yingampa tiwi wiyi wurimi kangi ngarra, ‘Nginja karluwu nginjila.’ Api ngarratuwu awarra tini ngini arimi kangatamiya, ‘Ngiya karluwu ngilawa’ api yingampa tiwi wiyi wurimi ngini ngarra ngatawa.” Awarra yimi ngawa-yuwuni kangi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kiyi ngawa-yuwuni yimi kapi awarra Pharisee ngini ngarra nanginta yimi ngarra ngini yimatapa yinkiti kangatawa kurrampali, “Karri nginja nanginta nimpirimi yingampa tiwi ngini wuta pimatapa yingarti yinkiti kangi nginjila japuja api ngajiti waya juwa nanginta nimpajami nginja-mamanta amintiya nginja-ngilipi kiyi nginja-ngirimipi amintiya awuta tiwi kapi wuni yingarti kunawuni pili wuta wiyi parlinginari (later) nanginta wurimi nginja ngini jimatapa yinkiti kangi wutawa tangarima. Api nginja wiyi kukunari nimpirimi karri nginja wiyi nimpapa ngini-wutawa yinkiti. Api ngawa-rringani wiyi karluwu yimatami ngini nginja pupuni ngini nginja waya juwa nanginta nimpirimi awuta tiwi kapi wuta wiyi nanginta wurimi nginja ngini jimatapa yinkiti kangi wutawa japuja. Api ngajiti awungani nimpajami!” Awarra yimi ngawa-yuwuni kapi awarra Pharisee. ");
INSERT INTO tiw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kiyi ngarra yimi ngini, “Karri nginja nanginta nimpirimi yingampa tiwi ngini pimatapa yinkiti kanginjila tangarima api nanginta tami awuta tiwi kapi wuta karri-kamini yinkiti wuni amintiya karri-kamini kunawuni wuni ngini pimatapa awarra yinkiti. Awanuwanga nanginta tami awuta tiwi kapi karrawungana, nginingaji awuta kapi wuta karluwu pimata-ngulimayi (can't walk) amintiya awuta kapi yinkilatuwi,” yimi ngawa-yuwuni kapi awarra Pharisee. ");
INSERT INTO tiw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kiyi tuwanga yimi kangatawa, “Ngini nginja nanginta nimpirimi awuta tiwi kapi karri-kamini wuni ngini wuta pimatapa yinkiti kanginjila japuja api ngawa-rringani wiyi arimi ngini nginja pupuni. Karri naki awarra murrakupuni wiyi apapaya (this earth will finish) api awungarri ngawa-rringani wiyi arikirimi tiwi ngini wupukularri api tuwanga yimpanguwi (alive) wurima. Api awungarri ngarra wiyi apakirayi arramu-kaminawuti ngini pupuni kapi awuta pupuwi tiwi kapi wuta pirripapunya-mini angatawa jarrumoka karri wuta nanuwanga (still) yimpanguwi pirimi. Ngajiti worry nimpajami ngini awuta tiwi kapi karri-kamini wuni wiyi karluwu pimata-kiray-awurli (give back) yinkiti kangi nginja pili ngawa-rringani wiyi apakirayi nginja arramu-kaminawuti ngini pupuni karri awarra naki murrakupuni apapaya.” Awarra yimi ngawa-yuwuni kapi awarra Pharisee. ");
INSERT INTO tiw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Karri ngawa-yuwuni Jesus amintiya awuta yingampa tiwi purru-wujing-apukani yinkiti kangi awarra Pharisee ngarra kurrampali api yati tini yimi kangi ngawa-yuwuni, “Aya, mantani, awuta tiwi kapi ngawa-rringani wiyi nanginta arimi awuta ngini pimatapa yinkiti wutiyati awarra ngawa-rringani awungarruwu kangatawa japuja kuriyuwu api wuta wiyi kukunari wurimi,” yimi awarra tini kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kiyi ngawa-yuwuni yuwuntiyarra awarra tini amintiya awuta yingampa arikutumunuwi naki ngirramini (story), “Yati alawura ngini yimuwu parlingarri api awarra nanginta yimi tayikuwapi (lots) tiwi ngini wiyi (later) pimatapa yingarti yinkiti kapi ngarra japuja. ");
INSERT INTO tiw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","20","Kiyi karri awarra yinkiti waya kiyana yimi awarra alawura yimi kapi yati tini ngini waki yimi ngini (for) ngarra, ‘Tuwariyi tajiyarra awuta tiwi ngini pini-matu-wariyi kangilawa japuja pili waya kiyana yimi awarra yinkiti.’ Kiyi awarra tini ngini waki yimi ngini awarra alawura yuwuriyi kangi awuta tiwi kiyi yimi kangi wutawa, ‘Nyirru-waripa ninganara kangi ngiya-alawura ngini-ngatawa japuja ngini nuwa ngimpapa yinkiti pili awarra yinkiti waya kiyana yimi.’ Awarra yimi awarra tini kapi awuta tiwi. Api awuta tayikuwapi tiwi karluwu purru-wutimarti ngini pimatu-wariyi kangi awarra alawura japuja. Yati awurrini yimi kangi awarra tini ngini ngarra waki yimi ngini awarra alawura, ‘Ngiya waya ngurru-wunga (bought) kirijini timani api ninganara ngiya nguwuja ngipakuluwunyi awarra timani. Api tajiyarra nginja-alawura ngini ngiya karluwu ngimatu-wariyi kangatawa japuja ngini ngimatapa yinkiti awungarruwu,’ yimi awarra awurrini. Kiyi ngarratuwu nyoni awurrini yimi kangi awarra tini ngini ngarra waki yimi ngini awarra alawura, ‘Ngiya waya ngurru-wunga (bought) wamutirrara pulukuwi api ngiya nguwutimarti ngini ngimata-kuluwunyi awuta pulukuwi ngini arrami pupuwi arrami karluwu api ngiya ngirimaja awuta kapi ngiya timani. Awungarruwu awuta pulukuwi wiyi wurikitikimi (pull) awarra arramu-kamini ngini arikurungumi (dig) parruwarti api ngiya wiyi ngipamukuri awarra kurukura (seed) kangi awarra parruwarti. Api tajiyarra nginja-alawura ngini ngiya karluwu ngimatu-wariyi kangatawa japuja ngini ngimatapa yinkiti awungarruwu,’ yimi awarra nyoni awurrini kapi awarra tini ngini waki yimi ngini awarra alawura. Kiyi ngarratuwu awarra nyoni tini yimi ngini, ‘Ngiya karluwu ngimatapa yinkiti kanginjila alawura japuja pili ngiya japini marriti ngirimi yimpalinya api ngiya pokumora ngurumuwu japuja wuturiyi ngiya-purnayinga. Api tajiyarra nginja-alawura ngini ngiya karluwu ngimatu-wariyi kangatawa japuja ngini ngimatapa yinkiti awungarruwu,’ yimi awarra nyoni awurrini kapi awarra tini ngini waki yimi ngini awarra alawura. Kiyi awarra tini ngini ngarra waki yimi ngini awarra alawura api ngarra yuwuriyi kapi awuta yingampa arikutumunuwi kapi awarra alawura pakinya nanginta yimi awuta ngini wuta pimatapa yinkiti kangi ngarra japuja api awuta tayikuwapi awanuwanga pirimi ngini wuta karluwu pimatu-wariyi kapi awarra alawura japuja ngini pimatapa yinkiti awungaji. ");
INSERT INTO tiw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kiyi awarra tini yipakupawurli kapi ngini-ngatawa alawura kiyi yuwutiyarra ngarra awarra ngirramini ngini awuta tiwi pirripangiraga. Kiyi awarra alawura angatawa yiminga jurrumumi jiyimi (became angry) kiyi yimi kapi awarra tini, ‘Murruka tuwariyi kapi tayikuwa-nga (all) jarrumoka kapi awarra naki town kiyi kularlaga tami awuta tiwi kapi wuta karri-kamini wuni kunawuni. Tamarruripa kangilawa japuja awuta tiwi pili-ngini wuta pimatapa yinkiti awungarra. Kiyi awanuwanga tamarruripa awuta tiwi kapi purunjuwi amintiya awuta kapi yinkilatuwi amintiya awuta kapi karluwu pimata-ngulimayi (can't walk),’ yimi awarra alawura kapi awarra tini ngini waki yimi ngini (for) ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ngarratuwu awarra tini kuwa yimi ngarra-alawura kiyi yuwuriyi kapi awuta tiwi kapi purunjuwi amintiya awuta kapi yinkilatuwi amintiya awuta kapi karluwu pirrija-ngulimayi, kiyi yiniri-marruriyi awuta tiwi kangi ngarra alawura japuja. Kiyi awarra tini yuwuriyi kangi ngarra-alawura kiyi yimi ngini, ‘Ngiya waya nginiri-marruriyi awuta kapinaki tiwi ngini pimatapa yinkiti awungarra. Api anaki kurrampali arikulanga api ngiya arrami ngimatu-wariyi ngini ngini-mata-marruriyi yingampa (other) tiwi awungarra pili-ngini wuta awanuwanga pimatapa naki yinkiti. Marri?’ yimi awarra tini kapi ngini-ngatawa alawura. ");
INSERT INTO tiw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","24","Kiyi awarra alawura yimi kangatawa, ‘Tuwariyi karrampi kapi awinyirra jarrumoka awungarruwu kapi warta. Awungarruwu kularlaga tami awuta tiwi kapi wurumuwu turruwuni pili wuta karri-kamini kurrampali api tajiyarra awuta tiwi ngini pini-matu-wariyi awungarra kangilawa japuja. Awarra tajiyarra awuta tiwi pili ngiya nguwutimarti tayikuwapi tiwi ngini pinimata-wuriji yilaruwu kangi ngini-ngilawa japuja amintiya ngini pimatapa naki yinkiti. Api awuta tiwi kapi ngiya pakinya nanginta ngirimi ngini pini-matu-wariyi kangilawa japuja, awuta kapi karluwu pirimi api wuta waya karluwu pimatapa ngini-ngilawa yinkiti.’ Awarra yimi awarra alawura kangi awarra tini ngini ngarra waki yimi ngini ngarra.” Awarra ngirramini (story) ngarra ngawa-yuwuni yuwutiyarra awarra tini amintiya awuta yingampa arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kiyi tayikuwapi arikutumunuwi mimpa pirimi kapi ngawa-yuwuni Jesus ngini wuta pimata-pitingaya (hear) ngini-ngatawa ngirramini. Api yingampa (some) awuta arikutumunuwi waki pirimani ngini (for) awuta Roman alawuruwi amintiya nanginta pirimani wuta-mamanta awuta Jews awarra kunawuni ngini tax. Amintiya yingampa (others) awuta arikutumunuwi karluwu warntirrana kuwa pirimani awarra ngirramini (law) ngini-wutawa Jews api awuta Pharisees pirimi ngini awuta wuta jajiruwi. ");
INSERT INTO tiw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kiyi awuta Pharisees amintiya awuta scribes, karri wuta pirripakuluwunyi ngawa-yuwuni ngini ngarra nimarra yimi kapi awuta tiwi kapi wuta pirimamula (called) awuta jajiruwi api wuta karluwu kukunari kangatawa api wuta jukuta pirimajirri, (whispered) “Naki awarra Jesus nimarra arimi kapi awuta jajiruwi tiwi amintiya awuta wawurruwi kapi waki wurimi ngini (for) awuta Roman alawuruwi amintiya nanginta wurimi ngawa Jews awarra kunawuni ngini tax. Amintiya ngarra awuriyi kangi wutawa japuja kiyi wutiyati wuwapa yinkiti,” pirimajirri awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kiyi ngawa-yuwuni yuwuntiyarra awuta Pharisees amintiya scribes nginaki ngirramini (story). ");
INSERT INTO tiw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ngarra yimi ngini, “Yati tini yuwuni (had) yingarti sheepuwi api yati sheep yipamulijipa api awarra tini yipumwari awuta yingarti sheepuwi awungarruwu kapi turruwuni kapi wuta purru-wujing-apukani wupunga kiyi ngarra kularlaga yimi kitawu kiyi nankitawu ngini awarra sheep ngini yipamulijipa. ");
INSERT INTO tiw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Api karri ngarra yuwunyayi awarra sheep api ngarra awungarri kukunari yimi. Ngarra yuwunga awarra sheep kiyi yipamukuri awarra kangatawa ngimpala kiyi yipakuturruwa awarra kiyi yuwuriyi japuja. Karri ngarra papi yimi kangatawa japuja api jingawu yimi kapi ngarra-ngirimipi amintiya ngarra-mamanta kiyi yimi kapi awuta, ‘Kali nyirru-waripa pili ngiya waya ngurruwunyayi ngini-ngilawa sheep ngini yipamulijipa. Ngawa kukunari ngawurrami pili ngiya ngurruwunyayi awarra sheep,’ yimi awarra tini kapi awuta ngarra-ngirimipi amintiya ngarra-mamanta.” Awarra ngirramini ngawa-yuwuni yuwuntiyarra awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kiyi ngawa-yuwuni yimi ngini, “Awarra tini kukunari yimi karri ngarra yuwunyayi awarra sheep ngini yipamulijipa api ngawa-rringani ngini kuriyuwu amintiya kapi-ngatawa angeluwi awanuwanga kukunari wurimi karri yati tini apumwari awarra jirti (the wrong) ngini ngarra pakinya yikirim-ani (he used to do) api mampara apapunya ngawa-rringani angatawa jarrumoka. Amintiya wuta awanuwanga kukunari wurimi karri natinga tinga ampumwari awarra jirti ngini nyirra jiyikirim-ani. Awarra ngawa-rringani amintiya awuta angeluwi wuta kukunari wurimi kapi awuta tayikuwapi tiwi kapi wuta pupuwi api karluwu jirti wurikirimi api wuta warntirrana kukunari wurimi kapi awuta tiwi kapi wupumwari awarra jirti ngini wuta pakinya pirikirim-ani.” Awarra ngirramini nimarra yimi ngawa-yuwuni kapi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kiyi ngawa-yuwuni nyoni ngirramini (story) yuwuntiyarra awuta Pharisees amintiya awuta scribes, yimi ngini, “Natinga tinga juwuni (had) wamutirrara (10) pwaja (coin) ngini silver api yati pwaja yipakupuraji kuta maka yilaruwu kapi kurrampali api awinyirra tinga pakinya juwunga light kiyi angi-nyitawa broom. Api kiyi nyirra juwunyirri (swept) angi-nyitawa kurrampali api kularlaga jiyimi awarra pwaja. ");
INSERT INTO tiw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Api karri nyirra juwunyayi awarra pwaja api jingawu jiyimi kapi nyirra-ngirimipi amintiya kapi nyirra-mamanta, jiyimi ngini, ‘Nyirru-waripa kangilawa kiyi ngawiyati kukunari ngawurrami pili ngiya waya ngurruwunyayi awarra pwaja ngini yipamulijipa,’ jiyimi.” Awarra ngirramini (story) ngawa-yuwuni yipangiraga kapi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kiyi ngawa-yuwuni yimi ngini, “Awarra nginingaji ngawa-rringani ngini kuriyuwu amintiya ngarra angeluwi api wuta warntirrana kukunari karri yati tini putuputuwu apakiray-amiya awarra jirti ngini ngarra yikirim-ani (he has done) api ngini karluwu tuwanga awungani yimatami.” Awarra ngirramini (story) nimarra yimi ngawa-yuwuni kapi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kiyi ngarra ngawa-yuwuni Jesus yuwuntiyarra awuta Pharisees amintiya awuta scribes naki nyoni ngirramini (story), yimi kangi wutawa, “Awi, yati tini ngarra yuwurrara ngarra-mamirampi. Ngarra-mamirampi awuta yuwurrara jajingaruwi. ");
INSERT INTO tiw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kiyi awarra ngini ngarra yintinila yimi kapi ngarra-rringani, ‘Aya, ngirringani, karri nginja wiyi pajuwani nimpirimi api nginja wiyi nimpumwari yintuwu awarra kunawuni amintiya arramu-kamini ngini nginja nimpini api ngawa yuwurrara nginja-mamirampi wiyi ngawunga awarra kunawuni amintiya arramu-kaminawuti,’ yimi awarra ngini yintinila kapi ngarra-rringani. Kiyi yimi ngini, ‘Ninganara tayakirayi ngiya half awarra ngini-nginjila kunawuni amintiya half awarra arramu-kaminawuti ngini nginja nimpini,’ yimi awarra ngini yintinila. Api ngarra-rringani yipakirayi awarra ngini yintinila half ngini-ngatawa kunawuni amintiya half arramu-kaminawuti ngini ngarra yuwuni (had). ");
INSERT INTO tiw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kiyi awarra ngini yintinila sellim yimi awarra arramu-kaminawuti ngini ngarra-rringani yipakirayi ngarra api yuwunga yingarti kunawuni kiyi ngarra yipumwari ngarra-rringani japuja kiyi yimarruriyi awarra kunawuni karrampi kapi nyoni murrakupuni. Awungarruwu ngarra yartipili yuwunyawu ngini-ngatawa kunawuni pili ngarra yipakirayi awarra kunawuni kapi jajiruwi maminikuwi amintiya ngarra yuwunga yingarti mirripaka amintiya awanuwanga pokayini yimi tupuluwu. Api awarra ngarra waya karri-kamini kunawuni. ");
INSERT INTO tiw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kiyi awungarruwu kapi awarra murrakupuni api karri-kamini pakitiringa yipungoli api awuta tayikuwapi arikutumunuwi purruwuni karri-kamini yinkiti. Api awarra ngini yintinila awanuwanga karri-kamini yinkiti yuwuni (had) api paruwani yimi. ");
INSERT INTO tiw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Api kiyi ngarra kularlaga yimi awungarruwu kapi awarra murrakupuni ngini yimata-nyayi waki pili ngarra yuwutimarti kunawuni. Kiyi yati tini yipakirayi ngarra waki ngini yipamangi pikipikuwi. ");
INSERT INTO tiw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Awarra ngini yintinila, karri yipakirayi awuta pikipikuwi yinkiti api ngarra awungarri yuwutimarti ngini yimatapa awarra yinkiti ngini awuta pikipikuwi purruwapa pili karri-kuwapi pirripakirayi ngarra yinkiti. ");
INSERT INTO tiw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","18","Kiyi awarra ngini yintinila yipungintayi (thought about) ngarra-rringani ngarra japuja api yimi kangatamiya, ‘Wuta kapi waki wurimi ngini (for) ngiya-rringani api wutatuwu awuta wuwapa yingarti yinkiti api ngiyatuwu awungarra paruwani-la,’ yimi. Kiyi yimi kangatamiya, “Ngiya wiyi ngumpuriyi awungarruwu kapi ngiya-rringani japuja. Awungaji ngiya wiyi nguwujiyarra ngiya-rringani, “Aya, ngirringani, ngiya waya jirti ngirikirimi kangi nginja amintiya ngiya awanuwanga jirti ngirikirimi kangi ngawa-rringani ngini kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Api ngiya waya arliranga pili ngiya jirti tini. Api nginja waya ngajiti nimpaja-mamula (call) ngiya nginja-mirani. Waya juwa ngiya wiyi waki ngirimi ngini (for) nginja nginingaji awuta yingampa tiwi kapi waki wurimi ngini nginja.” Awarra ngiya wiyi ngipangiraga kangi ngiya-rringani karri wiyi ngiya papi ngirimi awungarruwu kapi ngarra japuja.’ Awarra yimi kangatamiya awarra ngini yintinila. ");
INSERT INTO tiw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kiyi ngarra yipumwari awarra murrakupuni kiyi yipakupawurli kapi ngarra-rringani ngarra japuja. Karri ngarra yinu-wuja yinkitayi kapi ngarra-rringani japuja api ngarra-rringani yipakuluwunyi ngarra api ngarra putuputuwu yipakirayi ngarra-mirani kiyi kalikali yimi kangatawa kiyi yikutapirri (hugged) ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kiyi awarra ngini yintinila yimi kangi ngarra-rringani, ‘Aya, ngirringani,’ yimi. ‘Ngiya jirti ngirikirimi kangi nginja amintiya ngiya awanuwanga jirti ngirikirimi kangi ngawa-rringani ngini kuriyuwu. Api ngiya waya arliranga pili ngiya jirti tini. Api ngajiti nimpaja-mamula (call) ngiya nginja-mirani. Waya juwa ngiya wiyi waki ngirimi ngini (for) nginja nginingaji awuta yingampa tiwi kapi waki wurimi ngini nginja,’ yimi awarra ngini yintinila. ");
INSERT INTO tiw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Api ngarra-rringani yimi ngini, ‘Karluwu, ngiya nanuwanga (still) ngiya-mirani nginja’. Kiyi ngarra-rringani jingawu yimi kapi awuta kapi waki pirimani ngini (for) ngarra, api yimi ngini, ‘Murruka, nyirra-marruripa awuranka kuluji ngini ngarra wiyi ngiya-mirani arikuripiya (put on). Amintiya nyirra-marruripa yati ring amintiya muntamini (shoes). ");
INSERT INTO tiw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Amintiya nyirranga pupuni puluka api awarra nyirra-pirni pili-ngini ngawiyati ngamatapa awarra pili ngiya kukunari. Ngawa amparrimani nguntu-warimi ngini naki awarra ngiya-mirani pajuwani yimi api ngarra karluwu. Yita ngarra yimpangini. Ngawa amparrimani nguntu-warimi ngini ngarra yipamulijipa api karluwu pili ngarra waya yini-pakupawurli japuja.’ Awarra yimi ngarra-rringani. Kiyi awuta tiwi kapi waki pirimani ngini (for) awarra tini api piripirni puluka kiyi pirripawumi awarra. Kiyi awuta tayikuwapi tiwi wutiyati yinkiti purruwapa. Kiyi yoyi pirimi amintiya purukuruwala pili wuta kukunari pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Awarra alawura awarra ngarra-mirani ngini aringamini api ngarra awungarri waki yimi kangi garden awungarruwu karrampi. Karri ngarra yipapaya ngini-ngatawa waki api yipumwari awarra garden kiyi yipakupawurli japuja. Karri yinu-wuja yinkitayi kapi kurrampali api yipitingaya (heard) awuta tayikuwapi arikutumunuwi ngini purukuruwala amintiya ngini yoyi pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kiyi ngarra jingawu yimi kangi yati tini ngini waki yimi ngini (for) ngarra-rringani api yimi ngini, ‘Aya, pilikama kapinayi yoyi wujingimi amintiya wuji-kuruwala?’ yimi awarra ngini aringamini kapi awarra tini. ");
INSERT INTO tiw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Api awarra tini yimi kangi awarra ngini aringamini, ‘Ngarra nginjuwani waya yini-pakupawurli japuja api ngarra nginja-rringani waya kukunari api ngarra yimi kangawula, “Nyirra-pirni pupuni puluka pili-ngini ngawiyati ngamatapa.” Api ngawa ngintiri-pirni awarra puluka amintiya ngawiyati waya nguntuwapa. Api ngawa waya yoyi ngawujingimi amintiya ngawuji-kuruwala pili ngawa awanuwanga kukunari ngarimi,’ yimi awarra tini kangi awarra ngini aringamini. ");
INSERT INTO tiw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Api kiyi awarra ngini aringamini jurrumumi jiyimi angatawa yiminga (became angry) api karluwu yipawuriji yilaruwu kapi kurrampali. Kiyi ngarra-rringani awarra ngini aringamini yinuwuriyi kapi ngarra, yimi ngini, ‘Kali, mirani. Tuwaripa yilaruwu api kukunari tami pili nginjuwani waya yini-pakupawurli japuja,’ yimi. ");
INSERT INTO tiw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","30","Api awarra ngini aringamini yimi ngini, ‘Pilikama nginja jiyipirni awarra puluka ngini (for) nginja-mirani awarra ngini yintinila amintiya nuwa nuwiyati nguntuwapa? Nginja parlingarri jipakirayi ngiyuwani yingarti kunawuni api ngarra yipakirayi awarra kunawuni kapi jajiruwi maminikuwi amintiya yuwunga yingarti mirripaka amintiya pokayini yimi tupuluwu api ngarra waya karri-kamini kunawuni. Ngarra jirti yikirimi kanginjila awarra ngiyuwani api ngiyatuwu karluwu. Yita ngiya kuwa ngirimani kanginja amintiya yingarti waki ngirimani ngini (for) nginja api kama nginja karluwu jipakirayi ngiya amintiya ngiya-mamanta yinkiti ngini ngawiyati ngamatapa?’ yimi awarra ngini aringamini kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Api awarra ngarra-rringani yimi kangatawa, ‘Yita ngiya ngiya-mirani nginja amintiya muwiyati yiloti murumuwu awungarra. Tayikuwa-ni (all) awarra kunawuni amintiya yinkiti ngini ngiya nguwuni api awarra ngini-nginjila. ");
INSERT INTO tiw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Muwa karluwu worry mumatami ngini ngarra nginjuwani jirti yikirim-ani. Waya juwa muwa kukunari murrami pili ngarra waya yini-pakupawurli (came back) japuja. Ngawa amparrimani nguntu-warimi ngini naki awarra nginjuwani pajuwani yimi api karluwu amintiya ngawa amparrimani nguntu-warimi ngini ngarra yipamulijipa api karluwu pili ngarra waya yini-pakupawurli japuja. Api kiyi muwa awarra kukunari murrami,’ yimi ngarra-rringani kangi awarra aringamini.” Awarra ngirramini (story) ngawa-yuwuni yuwuntiyarra awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kiyi ngawa-yuwuni Jesus yuwuntiyarra awuta Pharisees awarra naki ngirramini (story) api yimi ngini, “Yati tini yimuwu ngini ngarra alawura. Ngarra awarra alawura yingarti pupuka kuluji yuwuni (had) amintiya yingarti yinkiti yuwapukani. ");
INSERT INTO tiw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Awungarruwu kapi ngarra japuja awarra alawura api kapi angatawa gate yati tini yimajirripi. Ngarra yintanga Lazarus awarra tini. Ngarra awarra yipumari (had lots of sores) kangatawa purnikapa awarra Lazarus. Ngarra karri-kamini kunawuni yuwuni (had) api awuta ngarra-ngirimipi yimpaja pirimarruriyi awarra kapi angatawa gate awarra alawura ngini ngarra yingarti kunawuni yuwuni ");
INSERT INTO tiw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","pili awarra Lazarus yuwutimarti ngini yimatapa awarra jukurruka (left-over) yinkiti ngini-ngatawa awarra alawura. Api wutatuwu awuta pulangumwawi punuwuriyi kapi awarra Lazarus api piriwara (licked) ngini-ngatawa jana. ");
INSERT INTO tiw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kiyi awarra Lazarus pajuwani yimi api awuta angeluwi punuwuriyi kangatawa api pirimarruriyi ngarra kuriyuwu kapi ngawa-rringani japuja. Awungarruwu ngarra yimuwu kapi Abraham api awarra Lazarus amintiya awarra Abraham purruwapa yingarti yinkiti ngini pupuni. Kiyi ngarratuwu awarra alawura ngini ngarra yuwuni (had) yingarti kunawuni api ngarra awanuwanga pajuwani yimi api wuta pirikijika awarra. ");
INSERT INTO tiw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ngini-ngatawa yimanka yuwuriyi kapi awarra yikwani ngini ngawa-rringani yikirimi ngini awarra maputiti wiyi japuja awungaji (hell). Awungarruwu kapi awarra yikwani api awarra alawura yingarti walawala (pain) amintiya awanuwanga yingarti jirti ngirramini (trouble) yuwuni (had). Kiyi ngarra yipakuluwunyi kuriyuwu api yipakuluwunyi Abraham amintiya Lazarus. Wuta karrampi-nara purumuwu awarra Abraham amintiya Lazarus. ");
INSERT INTO tiw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kiyi awarra alawura jingawu yimi kapi Abraham, ‘Aya, mantani,’ yimi. ‘Putuputuwu ngunta-luwapa pili awungarra nankitaga kapi awarra naki yikwani api ngiya arntingi kukuni api tajiyarra Lazarus ngini yimatanga kukuni kangarra yikara api ngini yimata-lami awarra kukuni kangilawa karaliki.’ Awarra yipangiraga awarra alawura kapi Abraham. ");
INSERT INTO tiw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Api ngarra Abraham yimi ngini, ‘Karluwu. Nginja waya nimpirimajawu ngini karri nginja jiyimuwu kapi murrakupuni (on the earth) api nginja juwuni (had) yingarti kunawuni amintiya yinkiti api ngarratuwu Lazarus karri-kamini kunawuni amintiya yinkiti. Api ngarralatuwu waya pupuni arimuwu (good life) api nginjatuwu yingarti walawala (pain). ");
INSERT INTO tiw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Amintiya kapi naki kuluwuta (between us and you) api arikulani yangamini api karri-kuwapi kutupi pimatami awungaji kapi nuwa amintiya awanuwanga nuwa karluwu ngintini-matu-wariyi (can't come) awungarra. Wayana?’ ");
INSERT INTO tiw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Api yimi awarra alawura, ‘Kuwa, mantani,’ yimi. ‘Api putuputuwu wunt-akirayi awuta pinginingita ngiya-ngilipi api tayangirri (send) awarra niyi Lazarus kapi ngiya-ngilipi wurumuwu awungarruwu kapi ngiya-rringani murrakupuni. Yita ngiya nguwutimarti awarra Lazarus ngini yimata-jiyarra awuta ngiya-ngilipi ngini karluwu pimata-kirimi (shouldn't do) awarra ngini jirti nginingaji ngiya waya ngirikirim-ani. Ngini wuta wurikirimi ngini pupuni (do good things) nginingaji ngini wuta wunu-wani yingampa (other) arikutumunuwi api karri wuta wiyi pajuwani wurimi api wuta wiyi karluwu pimata-muwu awungarra kapi naki jirti murrakupuni amintiya wuta wiyi karluwu yingarti walawala (pain) pimatani nginingaji ngiya. Api tayangirri (send) awarra niyi Lazarus kapi awuta ngiya-ngilipi.’ Ngarra awarra yipangiraga awarra alawura kapi Abraham. ");
INSERT INTO tiw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Api ngarra Abraham yimi ngini, ‘Karluwu, pili nginja-ngilipi waya piri-pitingaya (have heard) ngawa-rringani ngini-ngatawa ngirramini ngini Moses amintiya awuta prophets pirikirimi (wrote) kapi ngini-ngatawa punkaringini api wuta kuwa pimatami (should obey) awarra ngirramini.’ Ngarra awarra yipangiraga awarra Abraham. ");
INSERT INTO tiw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Api ngarra alawura yimi ngini, ‘Karluwu ngimantani pili arrami wuta karluwu kuwa pimatami (won't obey) awarra ngirramini awuta ngiya-ngilipi. Waya juwa ngini (if) Lazarus yirrija-kularri (did get up) api tuwanga yimpangini yirrijami api ngini yirrija-jiyarra awuta ngiya-ngilipi ngini pimata-mwari awarra jirti ngini wurikirimi (the wrong they do) api wuta wiyi ngiya-ngilipi putuputuwu pirrija-kiray-amiya (would be sorry) ngini (for) awarra jirti ngini wuta pirikirim-ani api wiyi karluwu tuwanga awungani pimatami (do that) awuta ngiya-ngilipi.’ Ngarra awarra yipangiraga awarra alawura. ");
INSERT INTO tiw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kiyi awarra Abraham yimi kangatawa, ‘Ngini nginja-ngilipi karluwu kuwa wurimi awarra ngirramini ngini awarra Moses amintiya awuta prophets parlingarri pirikirimi api ngini (if) Lazarus yirrija-kularri (did get up) api tuwanga yimpangini arimi amintiya ngini ngarra yirrija-jiyarra (did tell) awuta nginja-ngilipi ngawa-rringani ngini-ngatawa ngirramini api wuta wiyi karluwu kuwa pimatami (wouldn't believe) ngini-ngatawa ngirramini awarra Lazarus.’ Ngarra awarra yipangiraga awarra Abraham kapi awarra alawura ngini ngarra yingarti kunawuni yuwuni (had) karri ngarra yimuwu kapi awarra naki murrakupuni (on this earth).” Ngarra ngawa-yuwuni awarra ngirramini (story) yuwuntiyarra awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Kiyi ngawa-yuwuni Jesus nimarra yimi kapi ngarra-mamanta amintiya awuta yingampa tiwi kapi pirripapunya ngarra api yimi ngini, “Yingampa tiwi kapi wuta jajiruwi wiyi wuriyi kapi ngiya-mamanta kapi wuta mampara kuwa wurimi ngini-ngilawa ngirramini api awuta jajiruwi tiwi wiyi wuntiyarra awuta ngiya-mamanta ngini wuta jirti pimata-kirimi (to do wrong things). Api awuta jajiruwi tiwi kapi wuntiyarra ngiya-mamanta ngini jirti pimata-kirimi api ngini wutatuwu yingampa tiwi pirrija-kimirna (if they tied) arlipurringa kangi arikulanga waranga api kiyi ngini pirrija-kimirna awinyirra waranga kapi wuta miraka awuta kapi jajiruwi api kiyi ngini pirrija-nyawu (if they threw) awuta kapi kipirla api ngarra awarra pupuni. Api ngini awuta yingampa tiwi awungani pirrijami (if they did that) kapi awuta jajiruwi tiwi api awuta kapi jajiruwi wiyi karluwu tuwanga nimarra pimatami (couldn't say) kapi ngiya-mamanta ngini wuta jirti pimata-kirimi (to do wrong things).” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta amintiya awuta yingampa tiwi kapi pirripapunya ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Nuwa ngajiti awungani ngimpajami nginingaji awuta jajiruwi tiwi. Ngajiti ngimpaja-jiyarra nuwa-mamanta ngini jirti pimata-kirimi (do wrong things),” yimi ngawa-yuwuni kapi ngarra-mamanta. Kiyi ngawa-yuwuni yipangiraga nyoni nginaki ngirramini kapi ngarra-mamanta, api yimi ngini, “Yati kapi nuwa api ngini ngarra nginja-mantani jirti arikirimi kanginjila api tuwariyi kangatawa api tami ngini, ‘Nginja jirti jiyikirimi kangiya.’ Awarra tami kangatawa. Api ngini nginja-mantani arimi kanginjila, ‘Kuwa. Nginja nguri. Ngiya jirti ngirikirimi (did wrong thing) kanginja api ngiya karluwu tuwanga awungani ngimatami (won't do that).’ Ngini ngarra awarra nimarra arimi kanginjila api putuputuwu tayakirayi (forgive) awarra nginja-mantani. ");
INSERT INTO tiw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Api ngini awarra nginja-mantani jirti arikirimi kanginjila walimani (7) times karri natinga wumunga (one day) api ngini wiyi walimani times awunu-wuriyi kanginjila karri awinyirra-wanga wumunga (same day) api ngini apangiraga kanginjila, ‘Nginja nguri ngimantani ngini ngiya jirti ngirramini (trouble) ngirripakirayi nginja api ngiya karluwu tuwanga ngimatami awungani (won't do that) kanginjila.’ Ngini ngarra apangiraga awarra kanginjila walimani times karri awinyirra-wanga wumunga api walimani times putuputuwu tayakirayi awarra nginja-mantani.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kiyi ngawa-yuwuni Jesus yuwuntiyarra ngirramini (story) kapi awuta tiwi kapi wuta piri-mamuliya wutalamiya papurajuwi amintiya pirimamula (called) yingampa tiwi jajiruwi. Naki awarra ngirramini ngini ngarra ngawa-yuwuni yuwuntiyarra awuta tiwi, ");
INSERT INTO tiw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Yuwurrara wawurruwi purruwuriyi kapi awinyirra arikulanga jurra pili purru-wutimarti ngini pray pimatami kapi ngawa-rringani. Ngarra yati Pharisee. Ngarra awarra yimamuliya ngatamiya pupuni. Kiyi ngarratuwu nyoni tini ngini ngarra waki yimi ngini (for) awuta Roman alawuruwi amintiya nanginta yimani ngarra-mamanta awuta Jews awarra kunawuni ngini tax api ngarra awarra karluwu yimamuliya ngatamiya pupuni. ");
INSERT INTO tiw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kiyi awarra Pharisee kutupi yimi api tayinti yimi kuluwuta kapi awinyirra jurra api nimarra yimi kapi ngawa-rringani, ‘Ngirringani,’ yimi. ‘Ngiya nguru-kuruwarni (thank) nginja ngini (that) ngiya arnuka nginingaji kapinaki yingampa tiwi pili ngiya karluwu jirti tini. Ngiya karluwu punkirini amintiya ngiya karluwu kunyani ngirimi kapi yingampa tiwi pili-ngini ngimata-kirimi awuta tiwi ngini pimata-kirayi ngiya kunawuni. Amintiya ngiya karluwu wulinjini ngirimi kapi nyoni tini ngarra-purnayinga. Ngiya karluwu jirti nginingaji awarra naki tini ngini ngarra nanginta arimi ngawa Jews awarra kunawuni ngini tax amintiya yingampa (some of) awarra kunawuni mitaya arimi.’ Ngarra awarra yipangiraga awarra Pharisee. ");
INSERT INTO tiw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kiyi awarra Pharisee tuwanga yimi kapi ngawa-rringani, ‘Yingampini (sometimes) ngiya karluwu nguwapa yinkiti (I fast) pili waya juwa pray ngirimi kapi nginja ngirringani amintiya nguru-pungintayi (think about) nginja. Karri nginingaji Monday amintiya Thursday ngiya awungani ngirimi (do that). Amintiya ngiya awanuwanga ngipakirayi nginja yingarti kunawuni. Ngini ngiya nguwunga 100 pwaja (coins) api ngiya ngipakirayi nginja 10 pwaja. Ngini nguwunga 200 pwaja api ngiya ngipakirayi nginja 20 pwaja. Ngiya waya awungani (that way) ngirimi. Yita ngiya pupuni tini.’ Ngarra awarra nimarra yimi awarra Pharisee kapi ngawa-rringani awungarruwu kapi awinyirra jurra. ");
INSERT INTO tiw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Api awarra nyoni tini ngini ngarra nanginta yimani awarra kunawuni ngini tax api ngarra karluwu awarra tayinti yimi kuluwuta. Ngarra karrampi-nara tayinti yimi api ngarra karluwu yipakuluwunyi kuriyuwu kapi ngawa-rringani pili ngarra arliranga. Ngarra yipirn-amiya kapi pipwa pili putuputuwu yipakiray-amiya awarra jirti ngini yikirim-ani (the wrong he did) api kiyi yimi kapi ngawa-rringani ngini, ‘Aya, ngirringani,’ yimi. ‘Putuputuwu ngunta-luwapa (forgive me) pili ngiya jirti tini.’ Ngarra awarra nanginta yimi ngawa-rringani awarra tini ngini waki yimi ngini yuwunga kunawuni ngini tax.” Ngarra ngawa-yuwuni awarra ngirramini (story) yuwuntiyarra awuta tiwi kapi wuta piri-mamuliya wutalamiya pupuwi. ");
INSERT INTO tiw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kiyi ngawa-yuwuni yimi kapi awuta tiwi, “Awi,” yimi. “Karri awarra tini pray yimi kangi ngawa-rringani awarra tini ngini ngarra waki yimi ngini yuwunga kunawuni ngini tax api ngawa-rringani putuputuwu yipakirayi (forgave) awarra tini pili awarra tini putuputuwu yipakiray-amiya awarra jirti ngini yikirim-ani (the wrong he did). Api ngarratuwu nyoni awarra tini ngini ngarra Pharisee api ngarra ngawa-rringani karluwu yipitingaya (didn't hear) awarra ngini ngarra yipangiraga kangatawa pili kayi awuta tiwi kapi wuri-mamuliya wutalamiya papurajuwi api ngarra ngawa-rringani wiyi jajiruwi arimamula (call) awuta amintiya karluwu yimata-mamula (wouldn't call) awuta ngarra-mamirampi. Api wutatuwu awuta tiwi kapi putuputuwu wupakiray-amiya awarra jirti ngini wuta pirikirim-ani api wurimi ngini, ‘Ngawa jajiruwi’ api kiyi nanginta wurimi ngawa-rringani ngini putuputuwu yimata-kirayi (forgive) awuta api ngarra ngawa-rringani wiyi arimamula awuta ngarra-mamirampi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","34","Kiyi ngawa-yuwuni Jesus nimarra yimi kapi awuta wamurrara yuwurrara (12) ngarra-mamanta, “Ngawa waya ngawuja kapi Jerusalem. Awuta prophets parlingarri pirikirimi kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) ngini awuta arikutumunuwi kapi wurumuwu kapi Jerusalem wiyi jirti ngirramini (trouble) wupakirayi ngiya. Wuta wiyi wurimarruriyi ngiya kapi awuta tiwi kapi wuta arnuka Jews amintiya wuta wiyi awuta tiwi wupaparri (humbug) ngiya amintiya awanuwanga wuta wiyi tirriki wurimi ngini jirti kangiya amintiya wiyi juwarti wunyawu kangi ngiya. Amintiya wuta wiyi wunga murrukuni (whip) kiyi wuripirni ngiya. Kiyi wuta wiyi pajuwani wurikirimi ngiya. Kiyi karri yirrajirrima wumunga (days) ngiya wiyi ngupukularri api tuwanga yimpangini (alive) ngirima.” Awarra yimi ngawa-yuwuni kangi ngarra-mamanta. Kiyi ngawa-yuwuni ngarra-mamanta karri piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yipangiraga ngini awuta tiwi wiyi pajuwani wurikirimi ngarra amintiya ngini ngarra wiyi apukularri api tuwanga yimpangini arima api awuta ngarra-mamanta karluwu warntirrana pirimajawu (understand) awarra ngirramini. Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Ngawurliyi awungarruwu kapi Jerusalem.” ");
INSERT INTO tiw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta, karri wuta purruwuja kapi Jerusalem api tayikuwapi arikutumunuwi pirripapunya ngawa-yuwuni. Wuta pirripangulimayi kapi awinyirra jarrumoka api karri kuluwuta wuta papi pirimi kapi awarra town Jericho. Awungarruwu yati tini ngini ngarra yinkilatini yuwujingi-muwani yinkitayi kapi awinyirra jarrumoka. Ngarra awarra wankilingini api nanginta yimani kunawuni kapi awuta tiwi kapi pirripangulimayi kapi awinyirra jarrumoka. ");
INSERT INTO tiw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kiyi awarra yinkilatini karri ngarra yipitingaya (heard) awuta tayikuwapi tiwi punu-wuja api nanginta yimi awuta, “Kama nayi?” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Api wuta pirimi kangi awarra yinkilatini, “Awarra naki Jesus ngini ngarra town Nazareth api ngarra awuja kapi Jerusalem amintiya ngawa ngapapunya ngarra awungarruwu,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kiyi awarra tini ngini ngarra yinkilatini jingawu yimi kapi ngawa-yuwuni, “Aya, Jesus, nginja nginjila nginingaji awarra King David ngini ngarra yimuwu parlingarri api tawani ngiya,” yimi awarra yinkilatini. ");
INSERT INTO tiw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Api awuta tiwi kapi punu-wuja pakinya, wuta pirikirlimirri (growled at) awarra yinkilatini, pirimi kangatawa, “Aya, mantani, tawunjarli!” pirimi. Api ngarra karluwu kuwa yimi awuta api yimpaja jingawu yimi makirrana, “Aya, Jesus, nginja nginjila nginingaji awarra King David api tawani ngiya!” yimi awarra yinkilatini. ");
INSERT INTO tiw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Ngawa-yuwuni karri yipitingaya (heard) awarra ngirramini ngini awarra yinkilatini jingawu yimi kangatawa api ngarra yuwunjarli (stopped) kiyi yuwuntiyarra awuta tiwi, “Nyirra-marruripa awarra tini kangi ngiya!” yimi. Kiyi awuta tiwi piniri-marruriyi awarra tini ngini ngarra yinkilatini kapi ngawa-yuwuni. Kiyi ngawa-yuwuni nanginta yimi awarra yinkilatini, “Pilikama nginja nimpitimarti ngiya?” yimi. Api awarra tini ngini ngarra yinkilatini yimi kapi ngawa-yuwuni, “Ngiya nguwutimarti nginja ngini jimata-kirimi ngiya ngini tuwanga ngimata-kuluwunyi,” yimi awarra yinkilatini kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Api ngawa-yuwuni yimi kangatawa, “Manya, nginja wiyi pupuni pijara pili nginja kuwa nimpirimi ngini ngiya wiyi nguru-wani (help) nginja api awarra nginja wiyi tuwanga nimpakuluwunyi,” yimi ngawa-yuwuni kangi awarra yinkilatini. ");
INSERT INTO tiw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Api karri ngawa-yuwuni yipangiraga awarra ngirramini kangatawa api awungarri ngarra pijara pupuni yima api kiyi ngarra yipapunya ngawa-yuwuni kapi awinyirra jarrumoka. Karri ngarra yipangulimayi ngarra yikuruwarni (thanked) ngawa-rringani. Amintiya awuta tiwi karri pirripakuluwunyi awarra mirrikili (miracle) api wuta awanuwanga puru-kuruwarni ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kiyi ngawa-yuwuni Jesus tuwanga yipangulimayi kapi awinyirra jarrumoka api papi yimi kapi awarra murrakupuni Jericho api waya yinkitayi yuwuja kapi nyoni murrakupuni api karluwu pili tayikuwapi tiwi purru-wutimarti ngini pimata-kuluwunyi ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Awungaji kapi Jericho yati tini yimuwu ngini ngarra yintanga awarra Zacchaeus. Ngarra awarra waki yimi ngini (for) awuta Roman alawuruwi amintiya nanginta yimani awuta ngarra-mamanta Jews awarra kunawuni ngini tax. Awarra Zacchaeus alawura kapi awuta Jews kapi nanginta pirimani awarra kunawuni ngini tax. Ngarra yingarti kunawuni yuwuni (had) awarra Zacchaeus. ");
INSERT INTO tiw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ngarra yuwutimarti ngini yimata-kuluwunyi ngawa-yuwuni api karluwu pili awuta tayikuwapi tiwi mimpa pirimi kapi ngawa-yuwuni amintiya awarra Zacchaeus ngarra karuwuni ");
INSERT INTO tiw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","api ngarra kalikali yimi aringampi kiyi yipakilinga kangi awinyirra arikulanga purinjirringa api yimi kangi ngatamiya, “Ngiya arnapa ngurumuwu awungarra api karri awarra nayi Jesus awunu-wuriyi yinkitayi api awungarri ngiya wiyi ngipakuluwunyi ngarra,” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kiyi karri ngawa-yuwuni papi yimi awungarruwu kangi awinyirra purinjirringa api yipakuluwunyi kuriyuwu api yimi kapi awarra Zacchaeus, “Aya, Zacchaeus,” yimi. “Tayapirraya murruka pili ngiya nguwutimarti ngini ngimata-muwu kapi nginja japuja ningani,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Api awarra Zacchaeus kukunari yimi api murruka yipapirraya kiyi yimarruriyi ngawa-yuwuni kangi ngarra japuja. Awungarruwu wuta purumuwu pili wuta wiyi wuwapa yinkiti. Awuta tayikuwapi tiwi pirripapunya awarra Zacchaeus amintiya ngawa-yuwuni awungarruwu kapi ngarra japuja Zacchaeus ");
INSERT INTO tiw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","api karri pirripakuluwunyi awarra ngawa-yuwuni yipawuriji yilaruwu api jukuta pirimajirri (whispered) ngini, “Pilikama ngarra yipawuriji yilaruwu kapi ngarra japuja awarra nayi ngini jirti tini?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kiyi awarra Zacchaeus karri ngarra yipakuluwunyi awuta tiwi jukuta pirimajirri api awungarri kutupi yimi kiyi yuwuriyi kapi turruwuni api ngawa-yuwuni yipapunya ngarra. Kiyi awarra Zacchaeus kuluwuta tayinti yimi kapi awuta tiwi api kiyi yipakuluwunyi ngawa-yuwuni awarra ngini ngawa-alawura Jesus api yimi kangatawa, “Aya,” yimi. “Nginja awarra ngini ngiya-alawura api awarra arramu-kaminawuti ngini ngiya nguwuni api ngiya wiyi ngipakirayi yingarti awarra arramu-kaminawuti kapi awuta tiwi kapi wuta karri-kamini yinkiti amintiya kunawuni. Amintiya karri ngiya nanginta ngirimani kunawuni ngini tax kapi ngiya-mamanta Jews api ngiya yingarti kunawuni nanginta ngirimani api ngurru-wungamini (took) yingampa awarra kunawuni ngini (for) ngiyalamiya api ngiya wiyi ngipakiray-awurli (give back) awuta tiwi yingarti kunawuni, nginingaji ngini ngiya ngurru-wunga 100 pwaja (coins) api ngiya wiyi ngipakiray-awurli 400 pwaja kangi wutawa.” Ngarra awarra yipangiraga awarra Zacchaeus kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kiyi ngawa-yuwuni yimi kangi awarra Zacchaeus, “Nginja amintiya nginja-ngirimipi kapi nuwiyati japuja api nuwa warntirrana ngarra-mawampi Abraham. Ngawa-rringani ngini kuriyuwu waya putuputuwu yipakirayi (has forgiven) nginja amintiya nginja-ngirimipi awarra jirti ngini nuwa ngintiri-kirim-ani (the wrong you've done) pili nginja putuputuwu jipakiray-amiya awarra jirti ngini nginja jiyikirim-ani. ");
INSERT INTO tiw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngiya ngunuwuriyi kapi awarra naki murrakupuni (to this earth) pili ngiya ngurru-wutimarti ngini kularlaga ngimatami nuwa tiwi kapi karluwu ngimpapunya ngawa-rringani angatawa jarrumoka. Yita ngiya nguwutimarti ngini ngarra ngawa-rringani putuputuwu yimata-kirayi (to forgive) nuwa arikutumunuwi awarra jirti ngini nuwa ngintiri-kirim-ani. Ngiya awarra nuwa-yuwuni nuwa tayikuwapi tiwi.” Ngarra awarra ngawa-yuwuni yipangiraga kapi awarra Zacchaeus. Kiyi ngawa-yuwuni yipumwari awarra Zacchaeus, api yipapunya awinyirra jarrumoka angi juwuja kapi Jerusalem, wuturiyi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kiyi ngawa-yuwuni Jesus yuwuja-la kapi Jerusalem wuturiyi ngarra-mamanta amintiya tayikuwapi tiwi pirripapunya ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Kiyi wuta pirripangulimayi kapi awinyirra jarrumoka angi ampuriyi kuriyuwu kapi awarra arikulani jupunyini (mountain) ngini wuta pirimamula (called) ‘Mount of Olives’. Api awarra jupunyini yinkitayi kapi Jerusalem. Awungarruwu kapi awarra jupunyini yirrara town, ngini wuta yintanga Bethphage amintiya Bethany. Karri ngawa-yuwuni amintiya ngarra-mamanta waya yinkitayi purruwuja kapi awarra yirrara town api ngawa-yuwuni nimarra yimi kapi yuwurrara ngarra-mamanta, yimi ngini, “Nuwa aringampi nyirru-wariyi kapi awarra nayi town. Karri nuwa papi ngimpirimi awungarruwu api nuwa wiyi awungarri ngumpunyayi yati donkey ngini wuta arlipurringa pirikimirna awarra. Karri-kuwapi pirripakilinga kapi awarra donkey nanuwanga. Karri ngumpunyayi awarra donkey api tikimati nyirrami arlipurringa amintiya nyirra-marruripa awarra donkey kangiya.” Ngawa-yuwuni yimi awarra kapi awuta yuwurrara ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kiyi ngarra nyoni nginaki yimi kapi awuta yuwurrara ngarra-mamanta, “Ngini wuta nanginta wurimi nuwa, ‘Pilikama nuwa tikimati ngimpijingi-mi awarra arlipurringa kapi awarra donkey?’ api nuwatuwu nyirrami kangi wutawa, ‘Awarra nayi Jesus ngini ngarra ngawa-alawura api ngarra awutimarti naki donkey.’ Awarra nyirrami kapi awuta tiwi,” yimi ngawa-yuwuni kapi awuta yuwurrara ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiyi awuta yuwurrara ngarra-mamanta purruwuriyi kapi awarra town api karri wuta papi pirimi awungarruwu api wuta purruwunyayi awarra donkey nginingaji ngarra ngawa-yuwuni yuwuntiyarra awuta. ");
INSERT INTO tiw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Api karri wuta tikimati purru-wujingi-mani awinyirra arlipurringa kangi awarra donkey ngarra miraka api awuta tiwi kapi wuta purruwuni awarra donkey pirimi kangi wutawa, “Pilikama nuwa tikimati ngimpijingi-mi arlipurringa kapi awarra naki donkey?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Api awuta yuwurrara pirimi kapi awuta, “Awarra nayi Jesus ngini ngarra ngawa-alawura api ngarra awutimarti naki donkey,” pirimi awuta yuwurrara. Api awuta tiwi pirimi, “Manya. Nyirra-marruriyi awarra kapi awarra nayi Jesus,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kiyi awuta yuwurrara pirimarruriyi awarra donkey kapi ngawa-yuwuni. Kiyi ngawa-yuwuni ngarra-mamanta tikimati pirimi angi-wutawa yurruka kuluji kiyi pirripamukuri awinyirra kuluji kapi awarra donkey ngarra jukwartanga, kiyi wuta purruwani (helped) ngawa-yuwuni ngini yipakilinga kapi awarra donkey. ");
INSERT INTO tiw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kiyi ngawa-yuwuni yuwuja-la kapi Jerusalem. Kiyi karri ngawa-yuwuni yuwuja api awuta tayikuwapi arikutumunuwi tikimati pirimi angi-wutawa yurruka kuluji api purruwunyawu awinyirra kuluji kapi jarrumoka api kiyi awarra donkey yipangulimayi kapi awinyirra kuluji. Wuta awungani pirimi pili wuta pirimajawu ngini ngawa-yuwuni ngarra warntirrana ngatawa. ");
INSERT INTO tiw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kiyi ngawa-yuwuni amintiya awuta tayikuwapi tiwi purruwuja-la kapi Jerusalem. Kiyi wuta purrupumwari awarra jupunyini ngini Mount of Olives api pirripapirraya kapi yakuluwuni api awungarri wuta waya yinkitayi kapi Jerusalem. Waya awungaji awuta tayikuwapi ngarra-mamanta ngawa-yuwuni api wuta makirrana puru-kuruwarni (thanked) ngawa-rringani pili wuta kukunari pirimi api kuwayi pirimi ngini, “Ngawa-rringani ngini kuriyuwu api ngarra warntirrana pupuni pili ngarra yipakirayi naki Jesus power ngini awarra yingarti mirrikili (miracle) yikirimi. Ngawa nginti-pakuluwunyi ngarra ngini yikirimi awarra mirrikili,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kiyi pirimi, “Ngawa-rringani yini-pangirri (sent) naki Jesus awungarra kapi naki murrakupuni (to this earth) amintiya yikirimi ngarra ngini king arimi kangawula. Api ngawa-rringani amintiya awuta kapi wurumuwu kuriyuwu kangatawa api wuta kukunari wurimi kangi ngawa-yuwuni api nginingaji ngawula ngawurra-kuruwarni (let us thank) ngawa-rringani ngini kuriyuwu.” Awarra jingawu pirimi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yingampa Pharisees pirripapunya awuta tayikuwapi tiwi api pirimi kapi ngawa-yuwuni, “Aya, Rapayi, tajiyarra nginja-mamanta ngini wuta pimata-wunjarli (be quiet),” pirimi awuta Pharisees. Awarra yintanga Rapayi api awuta Jews wupakirayi awarra yintanga kapi awuta wawurruwi kapi wunu-waluwa (teach) arikutumunuwi ngini-wutawa ngirramini (law). ");
INSERT INTO tiw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Api ngawa-yuwuni yimi kapi awuta Pharisees, “Ngini ngiya-mamanta wuta karluwu jingawu wurimi amintiya wuru-kuruwarni ngiya api kapinaki yingarti waranguwi kapi jarrumoka wuta wiyi jingawu wurimi amintiya wiyi wuru-kuruwarni (thank) ngiya,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purru-wujingi-muwani yilaruwu kapi awinyirra arikulanga jurra (temple). Awungaji kapi awinyirra jurra api awuta tiwi pirripalami kunawuni kangi arikulanga wulijinga, awarra kunawuni ngini wuta pirripakirayi ngawa-rringani ngini kuriyuwu. Api ngawa-yuwuni yipakuluwunyi yingampa tiwi kapi wuta purruwuni yingarti kunawuni api wuta pirripalami yingarti kunawuni kapi awinyirra wulijinga. ");
INSERT INTO tiw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kiyi ngawa-yuwuni yipakuluwunyi natinga amparruwu ngini nyirra jipalami yirrara kirijini pwaja (coin) kangi awinyirra wulijinga. Api nyirra waya juwa juwuni (had) awarra yirrara kirijini pwaja. ");
INSERT INTO tiw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Awuta kapinayi yingampa tiwi waya pirripalami yingarti kunawuni kangi awinyirra wulijinga pili wuta wuni yingarti kunawuni. Api karri awuta tiwi pirripalami awarra yingarti kunawuni kapi awinyirra wulijinga api nginingaji wuta pirripalami kiyija kunawuni pili wuta nanuwanga (still) wuni yingarti kunawuni. Api nyirratuwu anayi amparruwu karri nyirra jipalami awarra kiyija kunawuni kapi awinyirra wulijinga api nginingaji nyirra jipalami yingarti kunawuni pili nyirra jipalami tayikuwa-ni (all) awarra kunawuni ngini nyirra juwuni (had). Nyirra waya karri-kamini kunawuni ampini ngini jimatanga yinkiti. Nyirra warntirrana minimaringa api awuta yingampa tiwi wuta karlu-nara.” Awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kiyi tayikuwapi awuta Jews wuta mimpa pirimi kapi Jerusalem pili waya yinkitayi awarra Passover Ceremony. Wuta pirimamula (called) awarra Passover Ceremony naki nyoni yintanga awarra Ceremony ngini Pamantarri ngini Pwajalini. Wuta awungarri awuta Jews puru-pungintayi (thought about) karri wuta-ampi parlingarri purrupumwari awarra murrakupuni Egypt. ");
INSERT INTO tiw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Karri awarra Passover Ceremony awuta priests kapi wuta alawuruwi amintiya awuta scribes mimpa pirimi. Wuta purru-wutimarti ngini pajuwani pimata-kirimi ngawa-yuwuni Jesus api pirimajirri ngini, “Awungana ngawa ngamatanga awarra Jesus ngini ngamata-pirni ngarra wangiya?” pirimi. Wuta purru-wutimarti ngini pimata-pirni ngawa-yuwuni wangiya pili wuta pirimakirri awuta tayikuwapi arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kiyi awarra ngini ngarra alawura kapi awuta maputirruwi (Satan) api ngarra yipalamiya kangi Judas ngarra purnikapa. Awarra Judas nyoni ngarra yintanga Iscariot. Ngarra awarra Judas yati kapi awuta wamurrara yuwurrara (12) ngawa-yuwuni ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","5","Kiyi awarra Judas yuwuriyi kapi awuta alawuruwi ngini traitor yimatami kapi ngawa-yuwuni Jesus, awuta alawuruwi kapi priests amintiya awuta majatawi kapi wuta alawuruwi. Ngarra yimi kapi awuta, “Ngini nuwa ngimpakirayi ngiya wurrupiya api ngiya wiyi ngirimarruriyi nuwa kangi awarra Jesus ngini nuwa nginti-matanga ngarra,” yimi Judas kangi awuta alawuruwi. Api awuta alawuruwi kukunari pirimi ngini awarra Judas wiyi arimarruriyi awuta kapi ngawa-yuwuni api wuta pirimi kangatawa, “Manya. Ngini nginja awungani nimpami (do that) api ngawa wiyi ngapakirayi nginja yingarti wurrupiya,” pirimi awuta alawuruwi kangi awarra Judas. ");
INSERT INTO tiw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Api awarra Judas yimi ngini, “Manya awarra.” Kiyi awarra Judas yipakupawurli kapi ngawa-yuwuni yimuwu. Awungaji ngarra yimuwu kiyi yimi kangatamiya, “Arnapa. Karri ngawa-yuwuni Jesus apangulimayi kuta maka awungarruwu kapi karluwu tayikuwapi arikutumunuwi api ngiya wiyi nguwuriyi kapi awuta alawuruwi kiyi ngirimarruriyi awuta kapi ngarra pili-ngini awuta alawuruwi awungaji pimatanga ngarra wangiya.” Awarra Judas yimi awarra kangatamiya. ");
INSERT INTO tiw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kiyi waya awarra Passover Ceremony karri awuta Jews piripirn-ani yati lamb api kiyi purruwapukani awarra lamb. Amintiya wuta awungarri purruwapukani pwajalini pamantarri. ");
INSERT INTO tiw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kiyi ngawa-yuwuni Jesus nimarra yimi kapi awuta yuwurrara ngarra-mamanta Peter amintiya John, yimi ngini, “Awi, nyirru-wariyi kapi Jerusalem kiyi awungarruwu jilikari nyirra-kirimi awarra yinkiti ngini ngawa wiyi ngawapa ngini (for) awarra Passover Ceremony,” yimi ngawa-yuwuni kangi awuta yuwurrara. ");
INSERT INTO tiw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kiyi awarra Peter amintiya awarra John nanginta pirimi ngawa-yuwuni, “Maka wiyi ngawuriyi ngini ready ngamata-kirimi awarra yinkiti?” pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Api ngawa-yuwuni yuwuntiyarra awuta, “Nyirru-wariyi kapi Jerusalem kiyi karri nuwa wiyi papi ngimpirimi awungarruwu api nuwa wiyi ngumpunyayi yati tini ngini ngarra apakuturruwa kukuni kangi arikulani mintini. Nyirra-punya awarra tini kiyi karri ngarra apawuriji yilaruwu kangi kurrampali api nuwatuwu awanuwanga nyirra-wuriji yilaruwu kangi awinyirra kurrampali. ");
INSERT INTO tiw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Api awungaji nimarra nyirrami kapi awarra tini ngini angatawa awinyirra kurrampali, ‘Aya, mantani, awarra Jesus yini-pangirri (sent) ngawa awungarra ngini nanginta ngamatami nginja maka awinyirra room kapi ngawa ngawiyati ngawapa awarra Passover yinkiti, awarra Jesus amintiya ngawa kapi ngarra-mamanta.’ Api nuwa yuwurrara awarra nyirrami kangi awarra tini ngini angatawa awinyirra kurrampali,” yimi ngawa-yuwuni kangi awuta yuwurrara Peter amintiya John. ");
INSERT INTO tiw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kiyi ngarra tuwanga yimi kangi awuta yuwurrara ngarra-mamanta, “Awarra tini ngini angatawa awinyirra kurrampali wiyi arimarruriyi nuwa kuriyuwu kapi awinyirra arikulanga room. Awungaji yilaruwu kapi awinyirra room, nuwa wiyi ready nyirra-kirimi awarra yinkiti.” Awarra yimi ngawa-yuwuni kangi awarra Peter amintiya awarra John. ");
INSERT INTO tiw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kiyi awarra Peter amintiya awarra John purruwuriyi kapi Jerusalem. Karri wuta papi pirimi awungaji wuta purruwunyayi awarra tini ngini yipakuturruwa arikulani mintini api wuta pirripapunya awarra kapi awinyirra kurrampali nginingaji ngawa-yuwuni yuwuntiyarra awuta. Api kiyi awungaji wuta ready pirikirimi awarra yinkiti ngini ngawa-yuwuni amintiya ngarra-mamanta wiyi wutiyati wuwapa. ");
INSERT INTO tiw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Karri yiminga jipungarti ngawa-yuwuni Jesus amintiya awuta wamurrara yuwurrara (12) ngarra-mamanta purruwuriyi kapi Jerusalem. Awungaji wutiyati purruwapa awarra Passover yinkiti kapi awinyirra room angi kuriyuwu kapi awinyirra kurrampali. ");
INSERT INTO tiw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Karri wuta purru-wujing-apukani awarra yinkiti api ngawa-yuwuni yimi kangi wuta, “Ngiya waya yinkitayi pajuwani ngirimi api nguwutimarti ngini ngawiyati pakinya ngamatapa nginaki lamb ngini (for) awarra naki Passover Ceremony pili ngiya wiyi karluwu tuwanga ngimatapa Passover yinkiti. Waya juwa karri ngawa-rringani wiyi alawura arimi kapi tayikuwapi (all) arikutumunuwi kapi nginingaji ngatawa murrakupuni (the whole world) api wiyi awungarri ngiya amintiya nuwa tuwanga ngawiyati ngawapa yinkiti kuriyuwu kapi ngawa-rringani ngarra japuja. Api ngiya waya kukunari pili ngawa ningani ngawiyati ngawapa nginaki yinkiti.” Awarra yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Kiyi ngawa-yuwuni yuwunga namuli wuturiyi wine kiyi ngarra yikuruwarni (thanked) ngawa-rringani. Ngarra yimangapa kiyija wine kiyi yipakirayi awinyirra namuli kapi ngarra-mamanta api yimi kangi wutawa, “Nuwa kakiyija-jirri nyirra-mangapa. Ningani ngiya ngirimangapa kiyija wine api ngiya wiyi karluwu tuwanga ngimata-mangapa wine. Waya juwa karri ngawa-rringani ngini kuriyuwu wiyi alawura arimi kapi tayikuwapi (all) arikutumunuwi api awungarri ngiya wiyi tuwanga ngirimangapa wine,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kiyi ngawa-yuwuni yuwunga awarra pamantarri ngini pwajalini kiyi ngarra yikuruwarni (thanked) ngawa-rringani. Kiyi ngarra yuwawurrini (broke) awarra pamantarri kakiyija kiyi karri ngarra waya yinkitayi yipakirayi awarra pamantarri kapi ngarra-mamanta api yimi kangi wutawa, “Awarra nginaki ngiya purnikapa. Ngiya wiyi pajuwani ngirimi ngini (for) nuwa amintiya ngiya wiyi ngumpuriyi kuriyuwu kapi ngiya-rringani japuja. Api karri ngiya wiyi ngumpumwari naki murrakupuni (this earth) api nuwa wiyi yimpaja mimpa nyirrami amintiya nuwiyati nyirrapa pamantarri. Karri nuwa wiyi ngimpapa awarra pamantarri api nyirra-pungintayi (think about) ngiya,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK22_20b","072_22_20b","LUK","22","20b","20b","Kiyi ngawa-yuwuni tuwanga yuwunga awinyirra namuli kiyi ngarra yimi kapi ngarra-mamanta, “Nginaki wine ngini-ngilawa manunguli. Karri ngiya wiyi pajuwani ngirimi api ngini-ngilawa manunguli wiyi alala arimi ngini (for) nuwa. Karri nuwa Jews pajuwani ngintiri-kirim-ani yati lamb api ngini-ngatawa majipani alala yimi api ngawa-rringani ngini kuriyuwu putuputuwu yipakirayi (forgave) nuwa awarra jirti ngini nuwa ngintiri-kirim-ani (the wrong you had done), nuwa awuta kapi Jews. Api karri ngiya wiyi pajuwani ngirimi api ngawa-rringani wiyi putuputuwu apakirayi (forgive) nuwa tayikuwapi arikutumunuwi awarra jirti ngini nuwa ngimpiri-kirimi, nuwa awuta kapi kuwa ngimpirimi ngiya. Naki awarra ngirramini ngini ngiya waya ngirripangiraga kapi nuwa api awurankini ngirramini awarra. Amintiya ngawa-rringani awutimarti ngini nuwa kuwa nginti-matami awarra awurankini ngirramini, nuwa tayikuwapi arikutumunuwi.” Awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","48","Karri ngawa-yuwuni Jesus nimarra yuwujingi-mani kapi ngarra-mamanta Peter amintiya James amintiya John api ngarra Judas yiniri-marruriyi tayikuwapi arikutumunuwi kangatawa. Yingampa awuta api wuta priests kapi wuta alawuruwi amintiya yingampa majatawi kapi wuta alawuruwi amintiya yingampa alawuruwi. Karri wuta papi pirimi kapi ngawa-yuwuni amintiya ngarra-mamanta api awarra Judas yuwuriyi yinkitayi kapi ngawa-yuwuni kiyi yipukuruwu (kissed) ngarra. Kiyi ngawa-yuwuni nanginta yimi awarra Judas, “Ngiya awarra nuwa-yuwuni nuwa tayikuwapi arikutumunuwi, api nginja jupukuruwu (kissed) ngiya pili-ngini kapinaki alawuruwi pimata-majawu ngini ngiya awarra ngini wuta pimatanga ngiy-ana?” yimi ngawa-yuwuni kangi awarra Judas. ");
INSERT INTO tiw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ngawa-yuwuni ngarra-mamanta pirimajawu ngini awuta alawuruwi waya yinkitayi wunga wuta-mantani api nanginta pirimi ngatawa, “Aya, yuwuni,” pirimi. “Ngawa ngawuni arikulani yilati api arrami nginja nimpitimarti ngawa ngini ngamata-pirni awuta kapinaki arikutumunuwi. Marri?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Karri wuta awarra nanginta pirimi ngawa-yuwuni api awungarri yati kapi ngawa-yuwuni ngarra-mantani, ngarra yuwawurrini yati tini ngarra purrakurninga ngini aripa. Awarra tini waki yimi ngini (for) yati priest ngini ngarra alawura. ");
INSERT INTO tiw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Api ngawa-yuwuni yimi kapi ngarra-mamanta, “Ngajiti awungani!” Kiyi ngarra yipamukuri ngarra yikara kangi awarra tini ngarra purrakurninga kiyi pupuni yikirimi awarra ngini-ngatawa purrakurninga. ");
INSERT INTO tiw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kiyi ngawa-yuwuni nimarra yimi kapi awuta alawuruwi kapi punuwuriyi ngini pimatanga ngarra, yimi ngini, “Pilikama nuwa ngintiniri-marruriyi yingarti arikulani yilati amintiya manjanga ngini nginti-matanga ngiya nginingaji ngiya jirti tini?” yimi ngawa-yuwuni kapi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kiyi yimi ngini, “Ngiya yimpaja ngurruwuriyani kapi angawula arikulanga jurra awungarruwu kapi Jerusalem api nuwa nginti-pakuluwunyi ngiya awungaji api nuwa karluwu nguntuwunga ngiya. Api mampara nuwa nguntunu-wuriyi awungarra pili-ngini nuwa nginti-matanga ngiya karri waya yartijanga pili awarra ngini ngarra alawura kapi awuta maputirruwi (Satan) api ngarra nuwa-alawura, awarra ngini ngarra arimuwu kapi yartijanga.” Awarra yimi ngawa-yuwuni kangi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kiyi awuta alawuruwi amintiya awuta majatawi purruwunga ngawa-yuwuni Jesus kiyi pirimarruriyi ngarra kapi awarra Caiaphas angatawa kurrampali. Awarra Caiaphas ngarra awarra priest ngini ngarra alawura kapi awuta yingampa priests. Kiyi wuta pirimarruriyi ngawa-yuwuni yilaruwu kapi angatawa kurrampali. Karri awuta alawuruwi pirimarruriyi ngawa-yuwuni yilaruwu kapi awinyirra kurrampali api ngarra awungarri Peter yipapunya awuta tiwi yintuwu api ngarra wiyarri yipawuriji yilaruwu kapi awarra gate. ");
INSERT INTO tiw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kiyi awarra Peter yipakuluwunyi ngini yingampa tiwi waya purrupumuti yikwani api ngarra yuwuriyi, yimiringarra wuturiyi awuta tiwi yinkitayi kapi awarra yikwani. ");
INSERT INTO tiw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Karri Peter yuwujingi-muwani awungaji kapi awarra yikwani api natinga yimpalinya angi waki jiyimi kapi awinyirra kurrampali, nyirra jipakuluwunyi Peter. Nyirra jipakuluwunyi ngini-ngatawa yirrikilingapa yinukuni kiyi nyirra jiyimi kapi awuta yingampa arikutumunuwi, “Yita nginaki tini yipapunya-mini awarra Jesus,” jiyimi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Api Peter yimi kangi awinyirra yimpalinya, “Karluwu, mantanga, ngiya karluwu ngirimajawu awarra Jesus!” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kiyi yati tini wiyi (later on) awanuwanga yipakuluwunyi Peter kiyi yimi kangatawa, “Yita nginja nginja-mantani Jesus.” Kiyi Peter yimi kapi awarra tini, “Karluwu, ngiya karluwu awarra ngiya-mantani!” yimi Peter. ");
INSERT INTO tiw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kiyi ngarratuwu nyoni tini wiyi (later on) awanuwanga yipakuluwunyi Peter api yimi kapi awuta yingampa tiwi, “Awarra warntirrana ngini naki awarra tini ngarra murrakupuni Galilee api ngarra yipapunya ngarra-mantani Jesus awungarra kapi Jerusalem,” yimi awarra nyoni tini. ");
INSERT INTO tiw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kiyi Peter yimi kangatawa, “Yita ngiya karluwu ngiya-mantani Jesus. Ngiya karluwu ngirimajawu ngini nginja nimpangiraga.” Api karri Peter yipangiraga awarra api yati kakululuwu (rooster) jingawu yimi. ");
INSERT INTO tiw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ngarra awungarri ngawa-yuwuni yinkitayi-nara yuwujingi-rritani api ngarra yipakuluwunyi Peter. Kiyi ngarra Peter yipungintayi (thought about) awarra ngirramini ngini ngawa-yuwuni pakinya yuwutiyarra ngarra, “Ninganara nginja wiyi nimpangiraga yirrajirrima times ngini nginja karluwu nimpirimajawu ngiya api karri nginja nimpangiraga awarra ngirramini api nginja wiyi awungarri nimpiri-pitingaya (hear) kakululuwu (rooster) jingawu arimi.” Awarra yimi ngawa-yuwuni kangi Peter puniyarri (before). ");
INSERT INTO tiw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Api karri Peter yipitingaya (heard) awarra kakululuwu jingawu yimi api awungarri yipungintayi (thought about) awarra ngirramini api kiyi yuwuriyi turruwuni (outside) kiyi pirlikiti yimi makirrana. ");
INSERT INTO tiw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kiyi awuta majatawi pirripaparri (humbugged) ngawa-yuwuni Jesus kiyi piripirni ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kiyi wuta pirikimirna (wrapped) manipurruwa (material) kapi ngarra pijara ngini ngarra karluwu yimata-kuluwunyi awuta. Kiyi tuwanga piripirni ngarra kiyi pirripangiraga kangatawa, “Tajiyarra ngawa ngini kuwani yipirni nginja,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wuta awungani-la pirripaparri (kept humbugging) ngawa-yuwuni amintiya tirriki pirimi kapi ngarra. ");
INSERT INTO tiw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kiyi karri natinga arawunga awuta priests kapi wuta alawuruwi amintiya awuta scribes amintiya awuta yingampa alawuruwi kapi wuta Jews api wuta mimpa pirimi. Kiyi awuta majatawi pirimarruriyi ngawa-yuwuni Jesus kapi wutawa. ");
INSERT INTO tiw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","Kiyi awuta alawuruwi pirimi kangi ngawa-yuwuni, “Ngawa ngawutimarti ngini nginja awarra Christ ngini ngawa-rringani parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (send) ngarra kangi ngawa arikutumunuwi api tajiyarra ngawa,” pirimi awuta alawuruwi. Kiyi ngawa-yuwuni yimi kangi wutawa, “Ngini ngiya nguwutiyarra nuwa ngini ngiya awarra Christ api nuwa wiyi karluwu kuwa nginti-matami awarra ngirramini ngini ngiya ngipangiraga. Amintiya awanuwanga ngini ngiya nanginta ngirimi nuwa ngini (if) nuwa kuwa ngimpirimi ngini ngiya awarra Christ api nuwa wiyi karluwu nimarra nginti-matami kangiya.” Awarra yimi ngawa-yuwuni kapi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kiyi ngawa-yuwuni tuwanga yimi ngini, “Ngiya nuwa nuwa-yuwuni nuwa awuta tayikuwapi arikutumunuwi amintiya ningani ngiya wiyi ngipakupawurli kuriyuwu kapi ngiya-rringani japuja api awungarruwu ngiya wiyi ngurumuwu aripa kangi ngiya-rringani awarra ngini ngarra warntirrana ngatawa.” Awarra yimi ngawa-yuwuni kangi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Api kiyi wuta nanginta pirimi ngarra, “Niyi nginja ngawa-rringani ngarra-miran-ana?” Wuta awarra nanginta pirimi ngawa-yuwuni. Api ngarratuwu ngawa-yuwuni yimi kangi wutawa, “Awarra warntirrana ngini nuwa ngimpangiraga ngini ngiya ngawa-rringani ngarra-mirani ngiya,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kiyi awuta alawuruwi nimarra pirimajirri, “Ngawa waya ngintiri-pitingaya (heard) ngarra ngini yipangiraga ngini ngarra ngawa-rringani ngarra-mirani ngarra api ngawa arnuka kularlaga ngamatami yingampa tiwi ngini tongwayi wurimi ngarra.” Awarra pirimajirri awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ninkiyi awarra Pilate nimarra yimi kapi awuta priests kapi wuta alawuruwi amintiya awuta tayikuwapi arikutumunuwi kapi purru-wujingi-rritani awungarruwu kapi turruwuni api ngarra yimi kangi wutawa, “Ngiya ngirimi ngini awarra naki Jesus karluwu yikirimi ngirramini (trouble) ngini warntirrana jirti api ngarra arnuka pajuwani yimatami,” yimi awarra Pilate. ");
INSERT INTO tiw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Api awuta priests amintiya awuta arikutumunuwi yikwanari nimarra pirimi kapi awarra Pilate api pirimi kangatawa, “Karluwu. Yita naki awarra Jesus ngarra jirti tini pili ngarra jirti ngirramini yuwuntiyarra-mini awuta tiwi kapi naki murrakupuni Judea api kiyi yingampa awuta tiwi jirti ngirramini (trouble) pirikirim-ani. Ngarra pakinya jirti ngirramini yuwuntiyarra-mini awuta tiwi awungarruwu kapi nayi murrakupuni Galilee kiyi ngarra yinuwuriyi awungarra api awanuwanga jirti ngirramini yuwutiyarra ngawa tayikuwapi kapi awungarra naki Jerusalem,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Api karri Pilate yipitingaya (heard) awarra ngirramini ngini wuta pirripangiraga api ngarra nanginta yimi awuta, “Ngarra awarra warntirrana ngini awarra naki Jesus ngini-ngatawa murrakupuni Galilee-ana?” Api wuta pirimi, “Kuwa, ngini-ngatawa murrakupuni Galilee,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Api karri awarra Pilate yipitingaya awarra ngirramini ngini wuta pirripangiraga api ngarra yipangirri (sent) awarra ngawa-yuwuni kapi awarra King Herod pili awarra King Herod alawura kapi awarra murrakupuni Galilee. Api karri awarra Pilate yipangirri ngawa-yuwuni kapi awarra King Herod api awungarri awarra Herod yuwujingi-muw-ani kapi Jerusalem. ");
INSERT INTO tiw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kiyi karri ngawa-yuwuni papi yimi awungarruwu kapi King Herod ngarra tangarima api awarra King Herod kukunari yimi pili ngarra yuwutimarti ngini yimata-kuluwunyi ngawa-yuwuni amintiya ngini yimata-pitingaya (hear) ngini-ngatawa ngirramini. Amintiya awanuwanga yuwutimarti ngini yimata-kuluwunyi awarra ngawa-yuwuni ngini ngarra arikirimi mirrikili (miracle). ");
INSERT INTO tiw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kiyi awarra Herod nanginta yimi ngawa-yuwuni ngini (about) yingarti arramu-kaminawuti api ngarra ngawa-yuwuni karluwu nimarra yimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kiyi awuta priests kapi wuta alawuruwi amintiya awuta scribes api wuta wiyarri purruwuriyi kapi Herod ngarra japuja amintiya wuta purru-wujingi-rritani awungarruwu api wuta yikwanari nimarra pirimi kapi awarra Herod api pirimi ngini ngawa-yuwuni ngarra jirti tini. ");
INSERT INTO tiw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kiyi awarra Herod amintiya ngini-ngatawa soldiers pirripaparri (humbugged) ngawa-yuwuni Jesus amintiya pokayini pirimi kangatawa. Kiyi wuta purruwunga yurruka kuluji angi pupuka api pirripamukuri awinyirra kangi ngawa-yuwuni. Kiyi wuta pirripangirri (sent) ngarra kapi Pilate. ");
INSERT INTO tiw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Parlingarri awarra Pilate amintiya awarra Herod jirti purumuw-ajirri api karri awinyirra wumunga (day) karri awarra Pilate yipangirri ngawa-yuwuni kapi awarra Herod api wuta awungarri wuta-mamanta pirimamul-ajirri (called each other friends). ");
INSERT INTO tiw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Karri ngarra ngawa-yuwuni tuwanga papi yimi awungarruwu kapi awarra Pilate api awarra Pilate jingawu yimi kapi awuta alawuruwi amintiya awuta tayikuwapi arikutumunuwi. Yingampa awuta alawuruwi api wuta priests awuta. Api awarra Pilate yimi kapi awuta alawuruwi amintiya awuta arikutumunuwi, “Kali nyirru-waripa,” yimi. Kiyi punuwuriyi kapi awarra Pilate ");
INSERT INTO tiw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","api ngarra yimi kangi wutawa, “Awi,” yimi. “Awarra naki Jesus ngini nuwa ngintiniri-marruriyi kangi ngiya api nuwa manya nimarra ngintirimi ngini ngarra yuwuntiyarra awuta tiwi ngini wuta jirti pimata-kirimi (to do wrong thing) api ngiya waya nanginta ngirimi awarra naki Jesus ngini (about) awarra ngirramini ngini nuwa tongwayi ngintirimi ngarra api ngiya karluwu kuwa ngirimi awarra ngirramini ngini nuwa nginti-pangiraga. ");
INSERT INTO tiw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ngarra wiyarri awarra Herod karluwu kuwa yimi awarra ngini nuwa tongwayi ngintirimi awarra naki Jesus api ngarra yini-pangirri (sent back) awarra naki Jesus kangi ngiya. Pilikama ngiya ngimata-pirni awarra pili ngarra karri-kamini warntirrana jirti yikirimi (did). ");
INSERT INTO tiw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Api ngiya wiyi nguwuntiyarra awuta soldiers ngini wunga murrukuni (whip) api wuripirni awarra naki Jesus kangi jukwartanga api kiyi ngiya wiyi ngipangirri (send) ngarra kapi ngarra japuja.” Ngarra awarra yipangiraga awarra Pilate kapi awuta alawuruwi amintiya awuta tayikuwapi arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kiyi awuta alawuruwi amintiya awuta arikutumunuwi jingawu pirimi kapi awarra Pilate, “Tapirni awarra naki Jesus amintiya awarra Barabbas awarra ngini ngarra arimuwu kangi jail api papi tamamiyi awarra.” ");
INSERT INTO tiw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Awarra Barabbas ngarra yimuwu kapi jail pili ngarra yuwuntiyarra-mini awuta ngarra-mamanta, “Ngawa ngajiti kuwa ngawajami awuta Roman alawuruwi,” yimani awarra Barabbas kapi ngarra-mamanta api wuta puruwarri (fought) awuta Roman alawuruwi awungarruwu kapi Jerusalem api ngarra awungarri Barabbas pajuwani yikirimi yati tini. ");
INSERT INTO tiw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Awarra Pilate yuwutimarti ngini ngawa-yuwuni yimpangini yimata-muwu api ngarra tuwanga yimi kapi awuta alawuruwi amintiya awuta arikutumunuwi, “Pakinya ngiya wiyi nguwuntiyarra kapinaki soldiers ngini pimatanga murrukuni api pimata-pirni naki awarra Jesus. Kiyi ngiya wiyi ngipangirri (send) ngarra kapi ngarra japuja. Marri?” yimi awarra Pilate kangi wutawa. Api wuta karluwu kuwa pirimi ");
INSERT INTO tiw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","api wuta yinukuni jingawu pirimi, “Tayamukuri awarra naki Jesus kapi arikitirropurtayi (cross),” pirimi awuta alawuruwi amintiya awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kiyi awarra Pilate tuwanga nanginta yimi awuta, “Pilikama? Ngiya ngirimi ngini ngarra karluwu yikirimi (did not do) ngini warntirrana jirti ngirramini api ngawa karluwu pajuwani ngamata-kirimi awarra api ngiya wiyi nguwuntiyarra awuta soldiers ngini wunga murrukuni (whip) api wuripirni awarra naki Jesus kangi ngarra jukwartanga api ngiya wiyi ngipangirri ngarra kapi ngarra japuja.” Ngarra awarra yipangiraga awarra Pilate. ");
INSERT INTO tiw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Api awuta alawuruwi amintiya awuta arikutumunuwi tuwanga jingawu pirimi. Makirrana jingawu pirimi yimpaja, “Tayamukuri awarra naki Jesus kapi arikitirropurtayi (cross),” pirimi. Api kiyi awarra Pilate kuwa yimi awuta alawuruwi amintiya arikutumunuwi ");
INSERT INTO tiw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","api yimi kangi wutawa, “Manya,” yimi. “Ngiya wiyi nguwuntiyarra kapi-ngilawa soldiers ngini pimata-mukuri awarra naki Jesus kapi arikitirropurtayi,” yimi awarra Pilate. Kiyi ngarra papi yiniri-mamiyi (brought out) awarra Barabbas kapi jail pili awuta alawuruwi amintiya awuta arikutumunuwi nanginta pirimi ngarra ngini awungani yimatami (do that). ");
INSERT INTO tiw_vpl VALUES ("LK23_26b","072_23_26b","LUK","23","26b","26b","Karri ngawa-yuwuni amintiya awuta soldiers purrupumwari Jerusalem api wuta pirripapijingi (met) yati tini ngini ngarra yinu-wuja kapi Jerusalem. Api ngarra awarra yintanga Simon amintiya ngini-ngatawa murrakupuni Cyrene. Awuta soldiers pirikirimi awarra Simon ngini yipakuturruwa ngawa-yuwuni ngini-ngatawa arikitirropurtayi (cross). ");
INSERT INTO tiw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tayikuwapi arikutumunuwi wuta pirripapunya ngawa-yuwuni. Awuta kapi maminikuwi wuta pirlikiti pirimi kangi awarra ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kiyi ngawa-yuwuni yipakuluwunyi awuta maminikuwi kiyi yimi kangi wutawa, “Awi, nuwa maminikuwi kapi nuwa japuja awungarra kapi Jerusalem, ngajiti pirlikiti ngimpajami kangi ngiya. Waya juwa putuputuwu nyirra-kiray-amiya amintiya awanuwanga putuputuwu nyirra-kirayi nuwa-mwaruwi ");
INSERT INTO tiw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","pili arikulani jirti ngirramini (trouble) wiyi papi arimi kapi nuwa arikutumunuwi. Wiyi awungarri awuta arikutumunuwi kapi jajiruwi wuripirni kakirijuwi api nuwa wiyi ngimpirimi, ‘Wuta piraya awuta maminikuwi kapi wuta palimaruwi pili wuta karluwu wuni kakirijuwi.’ Nuwa wiyi awarra ngimpirimi nuwa maminikuwi.” Awarra yimi ngawa-yuwuni kapi awuta maminikuwi. ");
INSERT INTO tiw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kiyi ngawa-yuwuni tuwanga yimi kapi awuta maminikuwi, “Karri awarra jirti ngirramini wiyi papi arimi kangi nuwa api awungarri nuwa arikutumunuwi wiyi ngimpitimarti awarra parruwarti kapi awarra jupunyini (hill) ngini yimata-pujirra (cover) nuwa api ngini nuwa yartipili pajuwani nginti-matami pili nuwa wiyi ngimpiri-makirri awuta jajiruwi arikutumunuwi,” yimi ngawa-yuwuni kapi awuta maminikuwi. ");
INSERT INTO tiw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kiyi ngawa-yuwuni yimi ngini, “Tani-waya (no matter) ngiya pupuni tini api wuta jajiruwi tiwi jirti ngirramini pirripakirayi ngiya api wuta wiyi pajuwani wurikirimi ngiya. Api nuwa arikutumunuwi kapi nuwa karluwu pupuwi api awuta jajiruwi tiwi wiyi warntirrana jirti ngirramini wupakirayi nuwa amintiya wiyi wuripirni nuwa. Api ngajiti putuputuwu nyirra-kirayi ngiya. Waya juwa putuputuwu nyirra-kiray-amiya nuwulamiya,” yimi ngawa-yuwuni kangi awuta maminikuwi kapi pirripapunya ngarra amintiya awuta soldiers. ");
INSERT INTO tiw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Kiyi awuta soldiers pirimarruriyi ngawa-yuwuni kapi awarra murrakupuni Golgotha. Awarra yintanga Golgotha mean arimi, ‘namijipi ngarra pungintaga (skull). Awuta soldiers awanuwanga pirimarruriyi awungarruwu yuwurrara jajingaruwi kapi wuta mitayuwi pili-ngini pimata-pirni awuta. Api karri wuta papi pirimi kapi awarra murrakupuni Golgotha api awuta soldiers pirripamukuri ngawa-yuwuni kuriyuwu kapi arikitirropurtayi (cross) ngini ngarra wiyi pajuwani yimatami awungaji. Awanuwanga wuta pirripamukuri awuta yuwurrara mitayuwi kapi nyoni arikitirropurtayi. Wuta pirripamukuri ngawa-yuwuni kuluwuta kapi awarra arikitirropurtayi kiyi wuta pirripamukuri yati mitayini kapi awarra arikitirropurtayi kapi aripa kapi ngawa-yuwuni amintiya ngarratuwu nyoni mitayini pirripamukuri kapi palinganya. ");
INSERT INTO tiw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Karri ngawa-yuwuni yimatilayi kuriyuwu kapi awarra arikitirropurtayi (cross) api ngarra yimi kangi ngawa-rringani ngini kuriyuwu, “Ngirringani, wuta karluwu warntirrana wurimajawu ngiya amintiya wuta karluwu kuwa wurimi ngini nginja jini-pangirri (sent) ngiya awungarra kangi wutawa api ngajiti nimpaja-pirni awuta kapi wujingi-pirni ngiya. Waya juwa putuputuwu tayakirayi awuta,” yimi ngawa-yuwuni kapi ngawa-rringani. Kiyi yinkitayi kapi awarra arikitirropurtayi awuta soldiers wuta purruwunga dice kiyi pokayini pirimi pili purru-wutimarti ngini kuwani awarra soldier pirrarti yimatami api ngini wiyi yimatanga ngawa-yuwuni angatawa yurruka kuluji. ");
INSERT INTO tiw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tayikuwapi arikutumunuwi purru-wujingi-rritani yinkitayi kapi awarra arikitirropurtayi (cross) api wuta pirripakuluwunyi ngawa-yuwuni. Amintiya wutatuwu awuta alawuruwi kapi Jews kapi wuta awungarruwu purru-wujingi-rritani api wuta pirripaparri (humbugged) ngarra amintiya wuta jingawu pirimi kangatawa, “Nginja warntirrana juwunu-wani (helped) awuta yingampa tiwi api kama nginja karluwu jimata-wanamiya (can't help) nginjalamiya? Nginja nimpiri-mamuliya awarra Christ ngini ngawa-rringani parlingarri yipangiraga ngini ngarra wiyi yini-mata-ngirri nginja kangawula api ngini nginja warntirrana awarra Christ api tayapirraya kapi kuluwuni,” pirimi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Amintiya awuta soldiers wuta awanuwanga pirripaparri ngawa-yuwuni. Kiyi wuta pirripakirayi ngarra jirti wine ngini yimata-mangapa awarra. ");
INSERT INTO tiw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kiyi wuta pirimi kangatawa, “Ngini nginja awarra king kapi Jews api tayapirraya kapi kuluwuni pili-ngini nginja wiyi yimpangini nimpirimi!” pirimi awuta soldiers. ");
INSERT INTO tiw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kiyi wuta purruwunga kiyija kartirrikani (piece of wood) kiyi pirikirimi (wrote) naki ngirramini kapi awarra kartirrikani, “Nginaki awarra ngini ngarra king kapi awuta Jews.” Api kiyi wuta pirripamukuri awarra kartirrikani kuriyuwu kapi ngawa-yuwuni ngarra pungintaga kapi awinyirra arikitirropurtayi. ");
INSERT INTO tiw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ngarratuwu yati mitayini ngarra tirriki yimi kangi ngawa-yuwuni amintiya yimi kangi ngarra, “Ngini nginja warntirrana awarra Christ api tayapirraya kapi kuluwuni pili-ngini nginja karluwu pajuwani jimatami. Amintiya nguntuwani ngiya amintiya ngiya-mantani ngini ngawa arnuka pajuwani ngamatami,” yimi yati mitayini kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kiyi ngarratuwu awarra nyoni mitayini ngarra yikirlimirri (growled at) awarra mitayini ngini ngarra tirriki yimi kangi ngawa-yuwuni api yimi kangatawa, “Ngajiti awungani! Nginja jimata-wanga (should be frightened) ngawa-rringani ngini kuriyuwu! Ngawa yuwurrajirrima, ngawa wiyi pajuwani ngarimi kapi nginaki arikitirropurtayi. ");
INSERT INTO tiw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Muwa yuwurrara mitayuwi api waya rayiti (alright) ngini muwa pajuwani murimi pili muwa jajiruwi. Api ngarra nginaki ngarra arnuka jirti yikirim-ani api wuta arnuka pajuwani pimata-kirimi ngarra.” Awarra nyoni mitayini yimi awarra kangi awarra mitayini ngini ngarra tirriki yimi kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kiyi awarra nyoni mitayini yimi kapi ngawa-yuwuni, “Karri nginja wiyi alawura nimpirimi kapi kuriyuwu nuwiyati ngawa-rringani api nginja tapungintayi ngiya,” yimi awarra nyoni mitayini kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kiyi ngawa-yuwuni yimi kangatawa, “Naki awarra warntirrana ngini karri yiminga ampingarti ningani muwiyati wiyi murumuwu kuriyuwu kapi ngiya-rringani japuja,” yimi ngawa-yuwuni kangi awarra nyoni mitayini. ");
INSERT INTO tiw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Karri ngawa-yuwuni Jesus nanuwanga (still) yimatilayi kapi awarra arikitirropurtayi (cross) api karri anjiruwa awarra murrakupuni yartijanga yima api karri-kuwapi pirripakuluwunyi awinyirra warnarringa. Awungarruwu kapi awinyirra arikulanga jurra awungarruwu kapi Jerusalem api natinga arikulanga manipurruwa (curtain) jimatilayi api awinyirra manipurruwa kunji jiyikirimi awinyirra room ngini waya juwa awuta Jews kapi wuta priests pirripawurijani yilaruwu. Api karri awarra murrakupuni yartijanga yima api awinyirra arikulanga manipurruwa juwawurra (tore). Pakinya kapi kuriyuwu right through kiyi kapi yakuluwuni juwawurra awinyirra manipurruwa. Kiyi karri yirrajirrima yiminga (3 o'clock) awungarri tuwanga yirrimanuwuni yima. ");
INSERT INTO tiw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kiyi ngawa-yuwuni kuwayi yimi kangi ngarra-rringani, “Aya, ngirringani, ngiya waya yinkitayi pajuwani ngirimi api tamarruriyi ngini-ngilawa wurrungorra kapi nginja,” yimi. Kiyi ngarra pajuwani yimi. ");
INSERT INTO tiw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Awarra tini ngini ngarra alawura kapi awuta soldiers api ngarra awarra yuwujingi-rritani yinkitayi kangi awarra arikitirropurtayi (cross) api karri ngarra yipakuluwunyi ngawa-yuwuni pajuwani yimi api ngarra yikuruwarni (thanked) ngawa-rringani, yimi ngini, “Awarra naki tini ngarra warntirrana pupuni,” yimi. ");
INSERT INTO tiw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Awuta tayikuwapi arikutumunuwi kapi mimpa pirimi awungarruwu ngini pimata-kuluwunyi awuta soldiers ngini pirripamukuri ngawa-yuwuni amintiya awuta mitayuwi kangi awarra arikitirropurtayi api karri wuta pirripakuluwunyi ngawa-yuwuni pajuwani yimi api wuta pirlikiti pirimi amintiya piripirni wutalamiya kangi wuta pipwa. Kiyi wuta purruwuriyi japuja. ");
INSERT INTO tiw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Api wutatuwu tayikuwapi ngawa-yuwuni ngarra-mamanta purru-wujingi-rritani yilipiyanga api pirripakuluwunyi awarra ngawa-yuwuni. Yingampa awuta ngarra-mamanta kapi purru-wujingi-rritani awungaji api wuta awuta maminikuwi kapi purrupumwari ngini-wutawa murrakupuni Galilee amintiya pirripapunya ngawa-yuwuni karri ngarra yinuwuriyi kapi Jerusalem. ");
INSERT INTO tiw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Awungarruwu kapi Jerusalem yati tini yimuwu ngini ngarra yintanga Joseph api ngini-ngatawa murrakupuni awarra town Arimathea. Ngarra warntirrana pupuni tini amintiya ngarra warntirrana kuwa yimi ngawa-rringani ngini-ngatawa ngirramini (law). Ngarra yimpaja pray yimani kangi ngawa-rringani api ngarra yimani kangatawa, “Aya, ngirringani, ngiya nguwutimarti awuta tayikuwapi arikutumunuwi kapi nginingaji ngatawa murrakupuni (the whole world) ngini wuta wiyi kuwa pimatami nginja.” Awarra Joseph awarra pray yimani kapi ngawa-rringani. Ngarra awarra Joseph ngarra yati kapi awarra council ngini-wutawa Jews api karri ngawa-yuwuni yimpangini nanuwanga (still) api karri awuta yingampa council alawuruwi nimarra pirimajirri ngini pajuwani pimata-kirimi ngawa-yuwuni api awarra Joseph arnuka kuwa yimi kangi wutawa. ");
INSERT INTO tiw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Karri ngawa-yuwuni pajuwani yimi api awarra Joseph yuwuriyi nanginta yimi awarra Pilate, “Ngiya nguwutimarti ngini ngimatanga awarra Jesus ngarra purnikapa kiyi ngipamukuri awarra yilaruwu kapi ngini-ngilawa cave,” yimi awarra Joseph. Api Pilate yimi ngini, “Manya awarra.” ");
INSERT INTO tiw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Api kiyi Joseph yuwuriyi kapi awarra arikitirropurtayi api yuwunga ngawa-yuwuni ngarra purnikapa kiyi ngarra yikimirna (wrapped) ngatawa purnikapa kangi pupuka manipurruwa (material) kiyi yimarruriyi ngarra purnikapa kapi ngini-ngatawa cave. Kapi awarra cave api ngarra pakinya ngawa-yuwuni ngini-ngatawa purnikapa yilaruwu yipalamiya. ");
INSERT INTO tiw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Awinyirra wumunga (day) karri ngawa-yuwuni Jesus pajuwani yimi api awinyirra wumunga waniyati (Friday). Karri waniyati api awuta Jews pirripapaya-mini ngini-wutawa waki karri nanuwanga (still) warnarringa kiyija kuriyuwu pili karri warnarringa jipungarti api awungarri Sabbath Day (Saturday). Api awarra Joseph yartipili yipalami ngawa-yuwuni ngarra purnikapa kapi awarra cave karri nanuwanga (still) warnarringa kiyija kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Awuta maminikuwi kapi purrupumwari ngini-wutawa murrakupuni Galilee api pirripapunya ngawa-yuwuni kapi Jerusalem api wuta awuta pirripapunya awarra Joseph api pirripakuluwunyi kapi maka ngarra yipamukuri ngawa-yuwuni ngarra purnikapa yilaruwu kangi awarra cave. ");
INSERT INTO tiw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kiyi wuta purruwuriyi kapi wuta japuja kiyi wuta ready pirikirimi mirrijini (ointment) ngini pupuni yuwanti (smelt good) ngini pimata-mukuri awarra mirrijini kangi ngawa-yuwuni ngarra mipurra. Api wuta pokumora purumuwu (stayed) japuja karri Sabbath Day (Saturday) pili ngawa-rringani parlingarri yuwutiyarra awarra Moses ngini awuta Jews karluwu kularlaga pimatami (should not walk around) karri Sabbath Day. ");
INSERT INTO tiw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Awinyirra wumunga (day) karri ngawa-yuwuni Jesus yipukularri api tuwanga yimpangini yimi api karri awulinari yuwurrara ngawa-yuwuni ngarra-mamanta purrupumwari Jerusalem kiyi purruwuriyi kapi awarra town Emmaus awarra town ngini yinkitayi kapi Jerusalem. ");
INSERT INTO tiw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Karri wuta pirripangulimayi kapi awinyirra jarrumoka api wuta nimarra pirimi ngini (about) karri ngarra ngawa-yuwuni pajuwani yimi amintiya wuta nimarra pirimi ngini (about) awarra ngirramini ngini awuta maminikuwi pirimi ngini ngawa-yuwuni ngarra waya tuwanga yimpangini yimi. ");
INSERT INTO tiw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kiyi ngawa-yuwuni yinuwuriyi kangi awuta yuwurrara ngarra-mamanta api wutiyati pirripangulimayi. ");
INSERT INTO tiw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Api karri awuta yuwurrara pirripakuluwunyi ngawa-yuwuni api wuta karluwu pirimajawu ngini ngarra awarra ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kiyi ngawa-yuwuni nanginta yimi awuta yuwurrara, “Awi, mamanta, kamini nuwa nimarra ngintiri-majirri karri nuwa nginti-pangulimayi?” yimi. Api kiyi awuta ngarra-mamanta purruwunjarli (stopped). Wuta awungarri putuputuwu pirripakiray-amiya (were sad). ");
INSERT INTO tiw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Api yati awarra ngarra-mantani ngini ngarra yintanga Cleopas api ngarra yimi kapi ngawa-yuwuni, “Arrami nginja karluwu yinukuni jiyimuwu kapi Jerusalem api nginja arnuka nimpirimajawu ngini (about) awarra jirti ngirramini ngini yingampa tiwi pirikirimi awungarruwu nangunji.” Awarra Cleopas yimi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kiyi ngawa-yuwuni nanginta yimi awuta ngarra-mamanta, “Kamini awarra jirti ngirramini ngini wuta pirikirimi awungarruwu kapi Jerusalem?” yimi. Kiyi awuta yuwurrara pirimi, “Wuta jirti ngirramini pirikirimi kangi yati tini ngini ngarra yintanga Jesus. Ngarra awarra ngini-ngatawa murrakupuni Nazareth. Ngawa-rringani yipakirayi ngarra ngini-ngatawa power api ngarra yuwunti-yarra-mini arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini ngini warntirrana amintiya pupuwi yikirim-ani awuta arikutumunuwi kapi wuta purunjuwi. Ngawa-rringani ngini kuriyuwu kukunari yimi kangatawa amintiya tayikuwapi arikutumunuwi awanuwanga kukunari pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ngawa amparrimani nguntu-warimi ngini awarra nayi Jesus amaru-wani (would have helped) ngawa Jews ngini ngamata-kirimi awuta Romans ngini pimata-mwari ngini-ngawula murrakupuni api ngini wuta karluwu alawuruwi pimatami kangawula. Api karluwu pili awuta priests kapi wuta alawuruwi amintiya awuta yingampa alawuruwi api wuta jajiruwi amintiya mantipungari pirimi kangi awarra Jesus api kiyi wuta purruwunga ngarra kiyi pirimarruriyi ngarra kapi awarra Roman alawura kapi Jerusalem. Kiyi awarra Roman alawura yuwuntiyarra awuta soldiers ngini pimata-mukuri ngarra kapi arikitirropurtayi (cross). Api kiyi ngarra pajuwani yimi nangunji api waya yirrajirrima wumunga (3 days),” pirimi awuta yuwurrara kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Kiyi tuwanga pirimi, “Kiyi ningani karri natinga arawunga (early morning) yingampa maminikuwi kapi wuta wiyarri wuta-mantani ngawa-yuwuni api wuta purruwuriyi kangi awarra cave kapi ngawa-yuwuni ngarra purnikapa yipalamiya api wuta karluwu purruwunyayi ngarra. Wuta pirripakuluwunyi angeluwi kiyi awuta angeluwi purru-wuntiyarra awuta maminikuwi ngini ngawa-yuwuni waya yipukularri api tuwanga yimpangini yimi. Kiyi awuta maminikuwi punuwuriyi kapi ngawa api purru-wutiyarra ngawa awarra ngirramini ngini awuta angeluwi pirripangiraga. ");
INSERT INTO tiw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kiyi yingampa ngawa-mamanta awanuwanga purruwuriyi kapi awarra cave api wuta awanuwanga karluwu purruwunyayi ngawa-yuwuni ngarra purnikapa awungaji nginingaji awuta maminikuwi purru-wutiyarra ngawa.” Awarra pirimi awuta yuwurrara ngarra-mamanta kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kiyi ngawa-yuwuni yimi kangi wutawa, “Pilikama nuwa karluwu kuwa ngimpirimi awarra ngirramini ngini awuta prophets parlingarri pirikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament)? Yita nuwa karluwu punyipunyi ngimpini pili nuwa arnuka ngimpiri-majawu awarra ngirramini,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiyi yimi ngini, “Awuta prophets pirikirimi kangi awarra punkaringini ngini awarra Christ pajuwani yimatami (should die) amintiya ngini ngarra wiyi apukularri api tuwanga yimpangini arimi. Amintiya wuta awanuwanga pirikirimi (wrote) kangi awarra punkaringini ngini ngarra wiyi apakupawurli kuriyuwu kapi ngawa-rringani japuja amintiya ngini wiyi awungarruwu ngarra amintiya ngawa-rringani wutiyati alawuruwi wurimi.” Awarra ngawa-yuwuni yimi kangi awuta yuwurrara ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kiyi karri wuta purru-wujirr-angulimay-ani, ngawa-yuwuni yuwuntiyarra awuta ngarra-mamanta awarra ngirramini ngini Moses amintiya awuta tayikuwapi prophets pirikirimi (wrote) kapi awarra punkaringini ngini (about) awarra Christ. ");
INSERT INTO tiw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kiyi ngawa-yuwuni amintiya awuta yuwurrara ngarra-mamanta karri wuta papi pirimi kapi awarra kirijini town Emmaus api ngawa-yuwuni yuwuja-la. ");
INSERT INTO tiw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Api awuta yuwurrara pirimi kangatawa, “Aya, mantani, nginja japuja awungarra pili warnarringa waya yinkitayi ampingarti api waya yinkitayi yartijanga,” pirimi. Kiyi ngawa-yuwuni yimi ngini, “Manya awarra,” api ngarra yipapunya awuta kapi wuta kurrampali. ");
INSERT INTO tiw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kiyi karri ngawa-yuwuni amintiya awuta yuwurrara ngarra-mamanta purumuwu kapi tayipuli ngini pimatapa yinkiti api ngawa-yuwuni yuwunga pamantarri api yikuruwarni (thanked) ngarra-rringani. Kiyi ngarra yuwawurrini (broke) awarra pamantarri kiyi yipakirayi awarra kangi awuta yuwurrara ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Api awungarri awuta ngawa-yuwuni ngarra-mamanta pirimajawu ngini ngarra awarra ngawa-yuwuni. Api ngarra awungarri ngawa-yuwuni yipumwari ngarra-mamanta api yipamulijipa (disappeared). ");
INSERT INTO tiw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kiyi awuta yuwurrara ngawa-yuwuni ngarra-mamanta nimarra pirimajirri, “Karri ngawa amintiya ngawa-yuwuni ngawiyati nginti-pangulimayi kapi jarrumoka api karri ngarra yuwutiyarra ngawa awarra ngirramini ngini Moses amintiya awuta prophets pirikirimi (wrote) parlingarri kangi awarra punkaringini ngini (about) awarra Christ api ngawa awungarri pupuni ngintirimi kangawula ruwuti,” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kiyi awuta yuwurrara ngawa-yuwuni ngarra-mamanta yartipili kutupi pirimi api pirripakupawurli kapi Jerusalem api wuta purruwunyayi awuta wamurrara yati (11) ngawa-yuwuni ngarra-mamanta amintiya yingampa ngarra-mamanta wutiyati mimpa pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kiyi awuta yingampa ngawa-yuwuni ngarra-mamanta pirimi kapi awuta yuwurrara wuta-mamanta, “Yita warntirrana ngini ngawa-yuwuni ngarra waya tuwanga yimpangini yimi amintiya ngarra papi yimi kangi Peter api awarra Peter yipakuluwunyi ngarra ngini waya yimpangini,” pirimi kapi awuta yuwurrara wuta-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kiyi awuta yuwurrara wuta-mamanta purru-wuntiyarra awuta yingampa ngawa-yuwuni ngarra-mamanta ngini ngawa-yuwuni papi yimi kangi wutawa amintiya nimarra yimi kangi wutawa karri wutiyati pirripangulimayi kangi jarrumoka. Amintiya wuta purru-wuntiyarra awuta ngini pakinya wuta karluwu pirimajawu ngarra api waya juwa karri ngarra yuwawurrini (broke) awarra pamantarri api wuta awungarri pirimajawu ngarra. Awarra awuta yuwurrara purru-wuntiyarra awuta yingampa wuta-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kiyi ngawa-yuwuni Jesus yuwuntiyarra awuta ngarra-mamanta, “Puniyarri (before) karri ngawiyati ngunturu-muwu api ngiya ngurru-wutiyarra nuwa ngini ngiya wiyi pajuwani ngirimi amintiya ngini ngiya wiyi tuwanga yimpangini ngirima. Api awarra warntirrana ngini ngiya waya pajuwani ngirimi amintiya ngini ngiya waya ngini-pakupawurli (came back) api tuwanga yimpangini ngirima. Parlingarri Moses amintiya awuta prophets amintiya awuta yingampa tiwi api wuta pirikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) tayikuwa-ni (all) awarra ngirramini ngini (about) ngiya. Api awarra ngirramini ngini wuta pirikirimi ngini (about) ngiya api waya ningani awarra warntirrana yima (came true),” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Api kiyi ngawa-yuwuni yuwani (helped) awuta ngarra-mamanta ngini pimata-majawu (understand) awarra ngirramini ngini awuta prophets amintiya awuta yingampa tiwi parlingarri pirikirimi kangi awarra punkaringini. ");
INSERT INTO tiw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kiyi ngarra yimi kangi wutawa, “Awuta prophets amintiya awuta yingampa tiwi pirikirimi (wrote) kangi awarra punkaringini ngini wuta jajiruwi tiwi wiyi pajuwani pimata-kirimi awarra Christ amintiya ngini karri yirrajirrima wumunga (days) ngarra wiyi apukularri api tuwanga yimpangini arimi. Awuta prophets awarra pirikirimi kangi awarra punkaringini. ");
INSERT INTO tiw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Amintiya awanuwanga wuta pirikirimi ngini awarra Christ wiyi pakinya apangirri (send) ngarra-mamanta kapi Jerusalem kiyi kapi nginingaji ngatawa murrakupuni (the whole world) ngini pimata-jiyarra awuta arikutumunuwi ngini wuta putuputuwu pimata-kiray-amiya awarra jirti ngini wuta pirikirim-ani (the wrong they have done). Amintiya awuta prophets pirikirimi ngini awuta arikutumunuwi kuwa pimatami kangi awarra Christ api kiyi ngawa-rringani wiyi putuputuwu apakirayi (forgive) awuta awarra jirti ngini wuta piri-kirim-ani pili awarra Christ pajuwani yimi ngini (for) wutawa,” yimi ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kiyi ngawa-yuwuni yimi naki nyoni ngirramini kangi awuta ngarra-mamanta, “Nuwa nginti-pakuluwunyi ngiya ngini ngiya pajuwani ngirimi amintiya ngini ngiya ngini-pakupawurli api tuwanga yimpangini ngirima api ngiya wiyi ngipangirri (send) nuwa kapi nginingaji ngatawa murrakupuni (the whole world) ngini nuwa nginti-mata-jiyarra tayikuwapi tiwi awarra pupuni ngirramini ngini (about) ngiya,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kiyi ngarra yimi kangi wutawa, “Parlingarri ngiya-rringani yipangiraga ngini ngarra wiyi yimata-kirayi nuwa ngini-ngatawa pukwiyi (Holy Spirit). Api ngiya wiyi ngipangirri kapi nuwa awarra pukwiyi. Karri ngiya wiyi ngipakupawurli kuriyuwu kapi ngiya-rringani ngarra japuja api nuwa arnapa nyirra-muwu awungarra kangi Jerusalem api karri awarra pukwiyi wiyi awuni-papirraya kangi nuwa api ngarra wiyi awungarri apakirayi nuwa power.” Awarra ngawa-yuwuni yipangiraga kangi ngarra-mamanta. Kiyi ngawa-yuwuni yipumwari ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kiyi ngawa-yuwuni Jesus yimarruriyi awuta ngarra-mamanta kapi awarra murrakupuni yinkitayi kapi awarra town Bethany. Kiyi ngarra yipamanipa ngini-ngatawa yikara kiyi nanginta yimi ngawa-rringani ngini kuriyuwu ngini yimata-mangi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Api karri ngarra nimarra yuwujingi-mani kapi ngawa-rringani api ngarra awungarri yipumwari awuta ngarra-mamanta kiyi ngawa-rringani yimarruriyi ngarra kuriyuwu kangatawa japuja. ");
INSERT INTO tiw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kiyi ngawa-yuwuni ngarra-mamanta puru-kuruwarni (thanked) ngarra kiyi pirimajirri, “Ngarra warntirrana ngatawa ngawa-yuwuni amintiya ngarra warntirrana pupuni,” pirimi. Kiyi wuta pirripakupawurli kapi Jerusalem. Api wuta awungarri kukunari pirimi. ");
INSERT INTO tiw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ninkiyi wuta yimpaja purruwuriyi kapi awinyirra arikulanga jurra (temple) angi-wutawa Jews awungarruwu kapi Jerusalem pili-ngini pimata-kuruwarni (to thank) ngawa-rringani ngini kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kiyi awuta wawurruwi kapi wuta alawuruwi awungarruwu kapi Jerusalem api wuta awuta purru-wutimarti ngini kuwani awarra nayi John the Baptist api nimarra pirimi kapi yingampa priests amintiya yingampa wawurruwi kapi waki pirimani kapi awinyirra arikulanga jurra angi-wutawa Jews, api pirimi ngini, “Ngawa ngawutimarti ngini kuwani awarra John the Baptist api nyirru-wariyi kangatawa api awarra nanginta nyirrami ngarra,” pirimi awuta alawuruwi. Ngarra awungarri awarra John the Baptist baptise yuwuji-kirim-ani arikutumunuwi kapi awarra town Bethany maringarruwu kapi awinyirra makatinga Jordan. Api awuta priests purruwuriyi awungarruwu kiyi nanginta pirimi awarra John the Baptist ngini, “Nginja kuwani awarra?” Api awarra John the Baptist pakinya yuwuntiyarra awuta priests awarra naki ngirramini ngini (about) ngawa-yuwuni Jesus ");
INSERT INTO tiw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","pili ngarra yimajawu ngini wuta yingampa tiwi amparrimani pirrarimi ngini ngarra Christ awarra John the Baptist api ngarra tulimiya (straight) yipangiraga kapi awuta priests api yimi ngini, “Ngiya arnuka awarra Christ ngini ngarra ngawa-rringani parlingarri yimi ngini ngarra wiyi awuni-pangirri (will send here) awarra kapi naki murrakupuni (to this earth). Ngiya karluwu kunyani ngirimi,” yimi awarra John the Baptist kapi awuta priests. ");
INSERT INTO tiw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Api wuta pirimi kapi awarra John the Baptist, “Arrami nginja awarra prophet Elijah ngini parlingarri jiyimuwu api nginja waya jipukularri api yimpangini jiyima tuwanga.” Api John the Baptist yimi ngini, “Ngiya karluwu awarra Elijah.” Api wuta pirimi, “Arrami nginja awarra nyoni prophet ngini ngawa-rringani parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (send) kangawula.” Api ngarra yimi ngini, “Ngiya karluwu awarra prophet,” yimi awarra John the Baptist. ");
INSERT INTO tiw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Api nginja kuwani awarra?” pirimi awuta priests. “Pilikama nginja baptise nimpirikirimi awuta kapinaki arikutumunuwi amintiya pilikama nimpuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini? Ngunt-ajiyarra ngawa pili ngawa wiyi ngari-marruriyi awarra ngirramini kapi awuta alawuruwi.” ");
INSERT INTO tiw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Api awarra John Baptist yimi ngini, “Awarra prophet Isaiah ngini parlingarri yimuwu api ngarra awarra yuwuntiyarra awuta arikutumunuwi ngini (about) ngiya. Ngarra karluwu yimajawu ngini-ngilawa yintanga api yimi ngini, ‘Yati tini wiyi arimuwu kapi awarra murrakupuni kapi karri-kuwapi wuta japuja wurikirimi api wiyi yingampa arikutumunuwi wunuwuriyi kapi awarra tini. Ngarra awarra tini wiyi awuntiyarra awuta tiwi ngini yati alawura waya yinkitayi awunu-wuja api wuta pimata-kirimi pupuka awinyirra jarrumoka angi ngarra wiyi apapunya.’ Ngarra wiyi awarra tini awuntiyarra awuta arikutumunuwi awarra ngirramini, yimi awarra Isaiah parlingarri. Api ngiya awarra naki tini,” yimi awarra John the Baptist. ");
INSERT INTO tiw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yingampa Pharisees kapi pirripapunya awuta priests awungarruwu kapi awarra John the Baptist baptise yikirimi awuta arikutumunuw. ");
INSERT INTO tiw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Api wuta awuta nanginta pirimi awarra John the Baptist ngini, “Kama nginja baptise nimpirikirimi arikutumunuwi ngini nginja arnuka awarra Christ. Awanuwanga nginja arnuka awarra Elijah. Amintiya nginja arnuka awarra nyoni prophet. Api pilikama nginja baptise nimpirikirimi arikutumunuwi?” pirimi kapi awarra John the Baptist. ");
INSERT INTO tiw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Api awarra John the Baptist yimi ngini, “Arnapa. Awarra warntirrana ngini ngiya baptise ngirikirimi arikutumunuwi. Kangi kukuni ngiya baptise ngirikirimi awuta. Api ngarratuwu nyoni tini ngini ngarra arimuwu kangawula murrakupuni awarra ngini ngarra alawura api ngarra wiyi awanuwanga baptise arikirimi arikutumunuwi api ngarra wiyi karluwu baptise yimata-kirimi kangi kukuni awuta arikutumunuwi. Nuwa arnuka ngimpiri-majawu awarra. Ngarra awarra wiyi awunu-wuriyi awungarra. Ngarra warntirrana ngatawa awarra api karri ngiya amintiya awarra tini ngarimuwu ngawiyati api ngiya karluwu nimarra ngirimi. Waya juwa karri ngarra pakinya nimarra arimi awarra ngini ngarra ngatawa api awungarri ngiyatuwu nimarra ngirimi.” ");
INSERT INTO tiw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ngarra awarra John the Baptist yipangiraga kapi awuta priests awungarruwu kapi awarra town Bethany. ");
INSERT INTO tiw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Karri pangarri awarra John the Baptist yipakupawurli kapi awinyirra makatinga. Kiyi yipakuluwunyi ngawa-yuwuni Jesus ngini yinu-wuja kangatawa api yimi awarra John the Baptist kangi wutawa awuta arikutumunuwi, “Awi,” yimi. “Awarra naki tini ngini awunu-wuja api ngawa-rringani yini-pangirri (sent) ngarra kapi ngawa arikutumunuwi. Ngawa ngarimamula (call) awarra ‘Lamb of God’. Ngarra awarra nginingaji lamb pili karri ngawa Jews ngawutimarti ngini nanginta ngamatami ngawa-rringani ngini putuputuwu yimata-kirayi (to forgive) ngawa awarra jirti ngini ngawa ngintiri-kirim-ani (the wrong we've done) api ngawa awungarri ngaripirni lamb. Api awarra nayi Jesus nginingaji awarra lamb ngini ngawa ngaripirni. Ngarra nginingaji lamb pili ngarra wiyi awunyawu awarra jirti ngini ngawa ngintiri-kirim-ani nginingaji ngawula tiwi,” yimi awarra John the Baptist kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kiyi yimi ngini, “Naki awarra ngini awunu-wuja api ngarra awarra ngini ngiya pakinya ngirripangiraga kangi nuwula ngini ngarra wiyi yintuwu awunu-wuriyi. Amintiya ngurru-wutiyarra nuwa ngini, ‘Ngarra awarra ngatawa api ngiya karluwu. Ngarra pakinya yimuwu kuriyuwu kangi ngawa-rringani api ngarra awarra warntirrana ngatawa.’ Ngiya awarra nimarra ngirimi kangi nuwula,” yimi John the Baptist kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kiyi yimi awarra John the Baptist ngini, “Karri pakinya ngiya ngirimi kapi ngiyalamiya ngini, ‘Kuwani awarra tini ngini ngarra ngawa-rringani wiyi awuni-pangirri (send here) kapi ngawa arikutumunuwi?’ Api waya ningani ngiya ngirimajawu ngini awarra naki Jesus api ngarra awarra ngini ngawa-rringani yini-pangirri (sent) kapi ngawa. Ngiya waya awarra ngirimajawu api ngiya nguwutimarti ngini nuwa wiyarri nginti-mata-majawu ngini ngarra ngawa-rringani yini-pangirri awarra naki Jesus kapi ngawa Jews kapi ngawa-amini awarra Israel api awarra ngiya baptise ngirikirimi nuwa kangi kukuni,” yimi awarra John the Baptist kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Kiyi tuwanga awarra John the Baptist yimi kapi awuta arikutumunuwi, “Ngawa-rringani yuwutiyarra ngiya ngini baptise ngirikirimi nuwa arikutumunuwi kangi kukuni api yimi awarra ngawa-rringani kangilawa ngini, ‘Nginja wiyi nimpakuluwunyi ngini-ngilawa pukwiyi (Holy Spirit) awuni-papirraya (come down) kangi yati tini. Ngarra awarra tini wiyi awanuwanga baptise arikirimi awuta arikutumunuwi. Karluwu kangi kukuni baptise arikirimi awuta. Yita ngarra wiyi arikirimi ngini-ngilawa pukwiyi ngini arimuwu kangi wutawa ruwuti. Waya awungani (that way) ngarra wiyi baptise arikirimi awuta arikutumunuwi,’ yimi ngawa-rringani kangilawa.” Ngarra awarra yipangiraga awarra John the Baptist. Kiyi yimi ngini, “Ngiya wiyi (later) ngirri-pakuluwunyi awarra pukwiyi (Holy Spirit) yini-papirraya (came down) kapi awarra naki Jesus api yimuwu kiyija kangatawa. Ngarra awarra pukwiyi japuja arimi kuriyuwu kapi ngawa-rringani. Ngarra yini-papirraya nginingaji ngarra mwapurawayi (dove bird). Api ngiya nguwutiyarra nuwa ngini ngawa-rringani ngarra-mirani awarra naki Jesus. Ngiya awarra ngirimajawu pili ngiya ngirripakuluwunyi awarra pukwiyi yini-papirraya (came down) kangatawa awarra Jesus,” yimi awarra John the Baptist. Kiyi awarra John the Baptist nyoni nginaki yimi ngini, “Ngiya pakinya karluwu ngirimajawu ngini (about) awarra Jesus ngini ngawa-rringani yini-pangirri (sent) ngarra kapi ngawa arikutumunuwi. Waya juwa ngirimajawu karri ngawa-rringani yuwutiyarra ngiya ngini (about) awarra Jesus.” Ngarra awarra yipangiraga John the Baptist kapi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Karri pangarri awarra John the Baptist amintiya yuwurrara ngarra-mamanta tuwanga purruwuriyi kapi awarra murrakupuni ngini yinkitayi kapi Jordan makatinga. ");
INSERT INTO tiw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kiyi John yipakuluwunyi ngawa-yuwuni Jesus yipangulimayi awungarruwu kiyi yipangiraga kapi awuta yuwurrara ngarra-mamanta, yimi ngini, “Nyirra-kuluwunyi awarra nayi Jesus. Ngarra awarra nginayi ngini ngawa ngarimamula (call) ‘Lamb of God’ pili ngarra wiyi pajuwani arimi ngini (for) awarra jirti ngini ngawa ngintiri-kirim-ani (the wrong we've done),” yimi John the Baptist kangi awuta yuwurrara ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Karri awuta yuwurrara John ngarra-mamanta piri-pitingaya (heard) awarra ngini John yipangiraga api wuta purrupumwari ngarra kiyi pirripapunya ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kiyi ngawa-yuwuni yipakuluwunyi awuta yuwurrara wawurruwi kiyi yimi kapi awuta, “Nuwa kamini ngimpitimarti?” yimi. Kiyi awuta yuwurrara wawurruwi pirimi ngini, “Rapayi, nginja maka tangarima?” pirimi. Awarra yintanga Rapayi api awuta Jews wupakirayi awarra yintanga kapi awuta wawurruwi kapi wunu-waluwa (teach) arikutumunuwi ngini-wutawa ngirramini (law). ");
INSERT INTO tiw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kiyi ngawa-yuwuni yimi kangi awuta yuwurrara, “Nyirru-waripa kiyi nyirra-kuluwunyi ngini-ngilawa tangarima,” yimi. Kiyi awuta yuwurrara wawurruwi amintiya ngawa-yuwuni purruwuriyi kapi ngarra japuja. Karri yukurri yiminga (4 o'clock) wuta purruwuriyi. Awungarruwu wuta purumuwu kangatawa kiyi ngarra nimarra yimi kangi wuta. Kiyi wuta purrupumwari ngini-ngatawa japuja. ");
INSERT INTO tiw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Awuta yuwurrara wawurruwi kapi pakinya piri-pitingaya (listened to) awarra John the Baptist ngini-ngatawa ngirramini api kiyi pirripapunya ngawa-yuwuni api yati ngarra awarra yintanga Andrew. Ngarra awarra Andrew api ngarra ngarra-yuwuni Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Karri Andrew yipumwari ngawa-yuwuni Jesus api ngarra yartipili kularlaga yimi ngarra-yuwuni Simon Peter. Karri ngarra yuwunyayi awarra Simon Peter api yipangiraga kangatawa, “Aya, yuwuni, ngiya amintiya ngiya-mantani waya nguntuwunyayi awarra Christ ngini ngawa-rringani yipangiraga parlingarri ngini ngarra wiyi yini-mata-ngirri (would send) ngarra kapi ngawa arikutumunuwi,” yimi awarra Andrew kangi Simon. ");
INSERT INTO tiw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kiyi awarra Andrew yimarruriyi Simon kapi ngawa-yuwuni. Api karri ngawa-yuwuni yipakuluwunyi awarra Simon api ngarra yimi kangatawa, “Ngiya ngirimajawu nginja. Yita nginja yintanga Simon amintiya nginja-rringani ngarra yintanga Jona. Wuta wiyi wurimamula (call) nginja Cephas,” yimi ngawa-yuwuni kangi Simon. Awarra yintanga Cephas api awuta Greeks wurimamula (call) awarra yintanga Peter. ");
INSERT INTO tiw_vpl VALUES ("JN1_43a","073_1_43a","JHN","1","43a","43a","Karri pangarri ngawa-yuwuni yimi kapi awuta ngarra-mamanta, “Ngawurniyi kapi awarra murrakupuni Galilee,” yimi. Kiyi wuta purrupumwari awarra murrakupuni Judea kiyi purruwuriyi kapi Galilee. ");
INSERT INTO tiw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Natinga wumunga (one day) yati tini marriti yimi ngarra-purnayinga kapi awarra town Cana awungarruwu kapi awarra murrakupuni Galilee. Api tayikuwapi wuta-mamanta purruwuriyi kapi awarra wedding ngini wutiyati pimatapa yinkiti awungarruwu amintiya ngawa-yuwuni ngarra-naringa nyirra wiyarri juwuriyi awungaji. ");
INSERT INTO tiw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta awanuwanga purruwuriyi kapi awinyirra kurrampali. ");
INSERT INTO tiw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Awuta arikutumunuwi karri pirimangap-ukinyimi awarra wine api awinyirra Mary nimarra jiyimi kapi nyirra-mwarti Jesus, “Aya, mwarti, waya karri-kamini wine,” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Api ngawa-yuwuni yimi kangi nyitawa, “Nginari, pilikama nginja nimputiyarra ngiya ngini karri-kamini wine? Ngiya nanuwanga karluwu (not yet) waki ngirimi ngini (for) ngiya-rringani ngini kuriyuwu,” yimi ngawa-yuwuni kangi nyitawa. ");
INSERT INTO tiw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Api awinyirra Mary karluwu kuwa jiyimi awarra ngini nyirra-mwarti yipangiraga api juwuriyi kapi awuta arikutumunuwi kapi waki pirimi kapi awinyirra kurrampali api jiyimi kangi wutawa, “Kuwa nyirrami awarra ngini ngiya-mwarti wiyi awutiyarra nuwa,” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kapi awinyirra kurrampali api kiringarra (6) mintini. Api kangi awarra mintini wuta pirripalam-ani (put) kukuni ngini wuta mwarliki pimatami. Api awarra mintini api arikulani. ");
INSERT INTO tiw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Api awuta arikutumunuwi kapi wuta waki pirimi kapi awinyirra kurrampali wuta purruwuriyi kapi ngawa-yuwuni api ngarra yimi kangi wutawa, “Nyirra-lami yingarti kukuni kapi awarra kiringarra mintini,” yimi ngawa-yuwuni kangi awuta arikutumunuwi. Kiyi awuta arikutumunuwi kuwa pirimi kangatawa kiyi pirripalami yingarti kukuni kangi awarra mintini. ");
INSERT INTO tiw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","10","Kiyi ngawa-yuwuni nimarra yimi kapi awuta arikutumunuwi kapi waki pirimi kapi awinyirra kurrampali api yimi ngini, “Nyirranga namuli kiyi nyirra-lami kiyija kukuni kapi awinyirra namuli kiyi nyirra-marruriyi awinyirra namuli kapi awarra ngini ngarra alawura kapi naki wedding,” yimi ngawa-yuwuni. Kiyi wuta pirripalami kiyija kukuni kapi namuli kiyi pirimarruriyi awinyirra namuli kapi awarra alawura. Ngawa-yuwuni waya yikirimi awarra kukuni ngini wine yima api ngarra awarra alawura karri yimangapa awarra wine api ngarra yimi ngini, “Pupuni awarra naki wine.” Ngarra karluwu yimajawu ngini maka wuta purruwunga awarra wine. Waya juwa awuta arikutumunuwi kapi waki pirimi kapi awinyirra kurrampali api wuta wangatamiya pirimajawu. Kiyi awarra alawura nimarra yimi kapi awarra tini ngini marriti yimi awinyirra yimpalinya api yimi kangatawa, “Aya, yita pupuni naki wine. Yingampa arikutumunuwi karri wuta-mamanta wunuwuriyi kangi wutawa tangarima ngini wutiyati wuwapa yinkiti amintiya wurimangapa wine api wuta pakinya wupakirayi awuta wuta-mamanta pupuni wine. Kiyi karri wuta-mamanta kiyija malurani (drunk) api wuta wupakirayi awuta awarra wine ngini ngarra kiyija pupuni. Api nginjatuwu karluwu nginingaji awuta yingampa arikutumunuwi pili nginja pakinya jipakirayi ngawa awarra wine ngini kiyija pupuni kiyi karri ngawa nginti-papaya awarra wine ngini kiyija pupuni api nginja awungarri jipakirayi ngawa awarra wine ngini warntirrana pupuni,” yimi awarra alawura kangi awarra tini ngini marriti yimi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nginaki awarra mirrikili (miracle) ngini ngawa-yuwuni yikirimi kapi awarra town Cana api awarra mampara yikirimi mirrikili. Karri ngarra-mamanta pirripakuluwunyi awarra mirrikili ngini ngawa-yuwuni yikirimi api pirimajawu ngini ngarra yuwuni (had) yingarti power kiyi awuta ngarra-mamanta kuwa pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kiyi ngawa-yuwuni amintiya ngarra-mamanta purruwuriyi kapi awarra town Capernaum wuturiyi ngarra-naringa amintiya ngarra-marrikulupi. Awungarruwu kapi Capernaum wuta purumuwu kiyija. ");
INSERT INTO tiw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Karri awuta Jews waya yinkitayi pirikirimi awarra ngini-wutawa Passover Ceremony api ngarra ngawa-yuwuni yuwuriyi kapi Jerusalem. ");
INSERT INTO tiw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Awungarruwu ngarra yikirimi mirrikili (miracles) api awuta tiwi karri pirripakuluwunyi awarra mirrikili ngini ngarra yikirimi api tayikuwapi awuta tiwi kuwa pirimi kangi awarra ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Awuta tiwi purru-wutimarti awarra ngawa-yuwuni ngini yimpaja mirrikili yimata-kirimi api ngarra karluwu kuwa yimi kangi wutawa pili ngarra arimajawu kuta kamini awarra ngini apalamiya kangi arikutumunuwi wuta punyipunyi amintiya kangi wuta ruwuti. ");
INSERT INTO tiw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ngarra karluwu nanginta yimatami arikutumunuwi ngini, “Arrami tayikuwapi arikutumunuwi jajiruwi, arrami tayikuwapi arikutumunuwi papurajuwi. Api awungana nuwatuwu?” Ngarra karluwu awarra nanginta yimatami awuta pili ngarra arimajawu kuta kamini ngini (that) wuta arikutumunuwi wurikirimi (do) amintiya awanuwanga arimajawu kuta kamini ngini apalamiya kangi wuta punyipunyi. ");
INSERT INTO tiw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Awungarruwu kapi Jerusalem yati tini yimuwu ngini ngarra alawura yimi kangi awuta Jews. Ngarra awarra yintanga Nicodemus. Ngarra Pharisee awarra. ");
INSERT INTO tiw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kiyi ngarra yuwuriyi kangi ngawa-yuwuni Jesus karri yartijanga api yimi ngini, “Aya,” yimi. “Ngawa ngarimajawu ngini ngarra ngawa-rringani yini-pangirri (sent) nginja kapi ngawa arikutumunuwi ngini jimata-waluwa (teach) ngawa. Ngawa awarra ngarimajawu pili awarra mirrikili (miracles) ngini nginja nimpirikirimi api ngarra warntirrana awarra mirrikili. Ngarra wangatamiya ngawa-rringani apakirayi power kapi arikutumunuwi ngini mirrikili pimata-kirimi api ngawa ngarimajawu ngini ngawa-rringani aminyu-wani (helps) nginja ngini mirrikili nimpirikirimi.” Ngarra awarra yimi awarra Nicodemus kapi ngawa-yuwuni. Kiyi awarra Nicodemus nyoni nginaki yimi kapi ngawa-yuwuni, “Ngini ngawa ngawutimarti ngawa-rringani ngini yimata-mangi ngawa amintiya ngini ngawa-alawura yimatami api ngawa awungana ngamatama?” yimi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Api ngawa-yuwuni yimi ngini, “Kapi wuta wiyi tuwanga wuri-mulungurrumi api waya juwa awuta wiyi ngawa-rringani apamangi awuta amintiya ngarra wiyi wuta-alawura arimi. Awarra ngirramini api warntirrana,” yimi ngawa-yuwuni kapi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Api ngarra yimi awarra Nicodemus ngini, “Ngawa kapi ngawa arikulapi ngawa awungana ngamatama ngini tuwanga ngamata-mulungurrumi (be born)? Ngawa karluwu tuwanga ngamata-kupawurli kapi ngawa-naruwi pitipita,” yimi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Api ngarratuwu ngawa-yuwuni yimi ngini, “Awuta tiwi kapi wutimarti ngawa-rringani ngini yimata-mangi awuta amintiya ngini alawura yimatami kangi wutawa api wuta awuta pimata-nyawu awarra jirti ngini apalamiya kangi wutawa ruwuti amintiya nanginta pimatami (should ask) ngini-ngatawa pukwiyi (Holy Spirit) ngini yimata-wani (to help) awuta ngini papurajuwi tiwi pimatama. Awarra naki ngirramini api warntirrana awarra ngirramini,” yimi ngawa-yuwuni kapi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kiyi yimi ngawa-yuwuni, “Karri nuwa arikutumunuwi ngumpuru-mulungurrumi api nuwa warntirrana tiwi ngimpirimi. Api karri awarra pukwiyi apawuriji yilaruwu kangi nuwa ruwuti api awarra nginingaji nuwa tuwanga ngumpuru-mulungurrumi api awungarri ngawa-rringani ngarra-mamirampi nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kiyi yimi ngawa-yuwuni kapi awarra Nicodemus, “Nuwa ngajiti ngimpaja-marlingiyi (get a surprise) ngini ngiya awarra ngirripangiraga kangi nuwula ngini nuwa tuwanga nginti-mata-mulungurrumi (should be born again). ");
INSERT INTO tiw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kayi, awarra pukwiyi (Holy Spirit) ngarra nginingaji wunijaka. Ngawa arnuka ngapakuluwunyi awinyirra wunijaka. Waya juwa yingampini (sometimes) ngari-pitingaya (hear) awinyirra wunijaka api kuta maka nyirra pakinya jiyi-milingarri (was blowing) awinyirra wunijaka amintiya kuta maka nyirra wiyi ampiri-milingarri. Nyirra awinyirra wunijaka ampiri-milingarri kapi nyirra ampitimarti. Api awarra pukwiyi wiyarri awuriyi kapi ngarra awutimarti api apawuriji yilaruwu kapi awuta tiwi ruwuti api awarra nginingaji awuta tiwi tuwanga wuri-mulungurrumi.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kiyi awarra Nicodemus yimi kapi ngawa-yuwuni, “Ngiya karluwu ngirimajawu awarra ngirramini ngini nginja jipangiraga.” ");
INSERT INTO tiw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Api yimi ngawa-yuwuni kangi awarra Nicodemus, “Nginja alawura kangi awuta kapi wuruwaluwa (teach) ngawa Jews api kama arrami nginja karluwu nimpirimajawu awarra ngini ngiya ngirripangiraga?” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Amintiya yimi ngawa-yuwuni kangatawa, “Awarra naki ngirramini api warntirrana awarra ngirramini ngini ngiya amintiya ngiya-mamanta nimarra ngarimi kangi nuwa Jews. Amintiya awanuwanga ngawujiyarra nuwa awarra ngini ngawa waya nginti-pakuluwunyi api nuwa karluwu kuwa ngimpirimi awarra ngirramini,” yimi ngawa-yuwuni kapi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kiyi yimi ngini, “Karri ngiya ngurru-wutiyarra (told) nuwa ngini-ngilawa ngirramini api ngiya nimarra ngirimi kapi nuwa ngini (about) arramu-kaminawuti kapi nginaki murrakupuni (on this earth) api nuwa arnuka kuwa ngintirimi awarra ngirramini. Awarra nayi ngirramini api turruwuni (easy to understand). Api ngini ngiya nguwutiyarra nuwa nyoni awurankini ngirramini ngini ngawa-rringani ngini kuriyuwu api arramukuta nuwa wiyi karluwu nginti-mata-majawu (won't understand) awarra pili awarra ngirramini jumurra (hard to understand) api arrami nuwa wiyi karluwu kuwa nginti-matami awarra ngirramini.” Awarra yimi ngawa-yuwuni kapi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kiyi ngawa-yuwuni yimi ngini, “Karri-kuwapi nanuwanga purruwuriyi awungarruwu kapi ngawa-rringani japuja. Ngiya wangatamiya waya tangarima ngirimi awungarruwu kapi kuriyuwu api ngiya ngini-papirraya awungarra kapi awarra naki murrakupuni (to this earth). Ngiya awarra naki nuwa-yuwuni nuwa tayikuwapi arikutumunuwi,” yimi ngawa-yuwuni kapi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kiyi yipangiraga ngini, “Nuwa ngimpiri-majawu ngini parlingarri awarra Moses karri awuta taringuwi puruwirri awuta nuwa-ampi api ngarra yuwunga wulimirri (iron) api yikirimi ngininganji awinyirra taringa. Kiyi yipamukuri awinyirra taringa kuriyuwu kapi awinyirra purinjirringa (pole) api awuta nuwa-ampi karri pirripakuluwunyi awinyirra taringa api yimpanguwi pirimi,” yimi ngawa-yuwuni. Kiyi yimi ngini, “Wuta wiyarri wiyi wupamukuri ngiya kuriyuwu kapi purinjirringa ");
INSERT INTO tiw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","api awuta kapi kuwa wurimi ngiya wiyi wurumuwu yiloti yimpanguwi kapi ngiya-rringani tangarima.” Waya awungarruwu ngawa-yuwuni yipapaya ngini nimarra yimi kangi awarra Nicodemus. ");
INSERT INTO tiw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Awarra ngawa-rringani ngarra warntirrana puranji yimuwu nginingaji ngawula arikutumunuwi kapi ngarimuwu kapi nginingaji ngatawa (every) murrakupuni api awarra ngarra-mirani ngini ngarra yatilani api awarra ngawa-rringani yini-pangirri (sent) ngarra awungarra kapi naki murrakupuni (to this earth) api awuta arikutumunuwi kapi wuta kuwa wurimi ngarra amintiya kapi wuni ngarra kapi wuta ruwuti api ngawa-yuwuni Jesus ngarra-rringani wiyi arnuka yimata-ngirri awuta arikutumunuwi kapi awarra maputiti japuja arimi (hell). Wuta awuta arikutumunuwi wiyi wurumuwu yiloti kapi kuriyuwu kapi ngawa-rringani japuja. ");
INSERT INTO tiw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ngawa-rringani karri yini-pangirri ngarra-mirani Jesus awungarra kapi naki murrakupuni api ngarra karluwu yuwutiyarra ngarra-mirani ngini, “Tuwariyi kapi awuta tayikuwapi tiwi api wuntiyarra awuta ngini wuta jajiruwi amintiya ngini wuta wiyi wuriyi kapi ngarra maputiti japuja arimi (hell).” Ngarra karluwu ngawa-rringani awarra nimarra yimi kapi ngarra-mirani pili ngarra yuwutimarti awarra ngini yimata-nyawu awarra jirti ngini ngawa ngintiri-kirim-ani (the wrong we have done) nginingaji ngawula arikutumunuwi amintiya ngarra yuwutimarti ngini ngawa awuta tiwi wiyi yiloti japuja ngamatami kuriyuwu kangatawa awarra ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Awuta arikutumunuwi kapi kuwa wurimi ngawa-yuwuni amintiya kapi wuni awarra ngawa-yuwuni kapi wuta ruwuti api ngarra ngawa-rringani karluwu jajiruwi yimata-mamula (won't call them bad) awuta tiwi amintiya karluwu wiyi apangirri (send) awuta kapi ngarra maputiti japuja. Api wutatuwu yingampa tiwi kapi karluwu wutimarti ngini kuwa pimatami ngini-ngatawa ngawa-yuwuni ngirramini api ngarra awarra ngawa-rringani jajiruwi awuni-mamula (calls) awuta tiwi pili wuta karluwu kuwa wurimi ngarra-mirani. Ngarra yatilani awarra ngarra-mirani. ");
INSERT INTO tiw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Awarra ngawa-yuwuni Jesus yini-papirraya awungarra kapi naki murrakupuni api ngarra nginingaji light ngini ngirri-ngirri arimi kapi angatawa jarrumoka angi pupuka. Api yingampa tiwi wuta arnuka wutimarti ngawa-yuwuni ngini-ngatawa light amintiya wuta karluwu wutimarti ngini pimata-punya awinyirra jarrumoka angatawa ngawa-yuwuni. Wuta awuta wutimarti ngini pimata-punya (to follow) awinyirra jarrumoka angi jiringa amintiya wutimarti yimpaja jirti pimata-kirimi (keep doing wrong) api ngawa-rringani jajiruwi arimamula (calls) awuta tiwi api wiyi apangirri (send) awuta kapi ngarra maputiti japuja. ");
INSERT INTO tiw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Awuta tiwi kapi wuta jirti wurikirimi (do wrong) api wuta jirti wurumuwu awarra light ngini-ngatawa ngawa-yuwuni Jesus. Wuta awuta arnuka wuriyi yinkitayi kapi ngawa-yuwuni pili awarra light ngini-ngatawa ngawa-yuwuni wiyi ngirri-ngirri arimi kangi wutawa api awuta yingampa arikutumunuwi wiyi wupakuluwunyi awuta karri wuta jirti wurikirimi. ");
INSERT INTO tiw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Api awuta kapi kuwa wurimi ngawa-rringani ngirramini api wuta awuta wuriyi kapi awarra light ngini-ngatawa ngawa-yuwuni pili wuta wutimarti yingampa tiwi ngini pimata-majawu ngini ngarra ngawa-rringani awunu-wani (helps) awuta ngini pupuni pimata-kirimi (to do good things). ");
INSERT INTO tiw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Karri nyonga wumunga (another day) ngawa-yuwuni Jesus amintiya ngarra-mamanta purrupumwari Jerusalem api purruwuriyi kapi turruwuni awungarruwu kapi awarra murrakupuni Judea. Wuta awungaji japuja pirikirimi arrami yati wurlini (one month) api ngarra ngawa-yuwuni baptise yikirimi awuta arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ngarra John the Baptist awungarri baptise yuwuji-kirim-ani arikutumunuwi kapi nyoni murrakupuni pili yingarti kukuni awungarruwu kapi awarra murrakupuni. Awarra murrakupuni ngarra yintanga Aenon yinkitayi kapi awarra murrakupuni Salim. Tayikuwapi arikutumunuwi purruriy-ani kangi awarra John the Baptist api ngarra baptise yikirim-ani awuta. ");
INSERT INTO tiw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kiyi yingampa tiwi purru-wuntiyarra awuta Pharisees ngini tayikuwapi tiwi waya kuwa pirimi ngawa-yuwuni amintiya pirimi ngini ngarra baptise yikirimi awuta tiwi awarra ngawa-yuwuni. Amintiya awanuwanga purru-wuntiyarra awuta Pharisees ngini waya juwa kiyija tiwi pirripapunya John the Baptist amintiya ngini ngarra baptise yikirimi awuta kiyija tiwi. Ngawa-yuwuni yimajawu ngini awuta Pharisees piri-pitingaya (heard) awarra ngirramini ngini (about) awarra John the Baptist amintiya ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ngarra karluwu ngawa-yuwuni baptise yikirimi awuta tiwi. Waya juwa ngarra-mamanta kapi wutiyati ngawa-yuwuni waki pirimi api awuta ngarra-mamanta baptise pirikirimi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Awarra ngawa-yuwuni karri yipitingaya (heard) ngini awuta tiwi purru-wuntiyarra awuta Pharisees ngini tayikuwapi tiwi kuwa pirimi ngarra api awarra ngawa-yuwuni amintiya ngarra-mamanta purrupumwari awarra murrakupuni Judea api pirripakupawurli kapi Galilee. ");
INSERT INTO tiw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kiyi wuta pakinya pirripapunya awinyirra jarrumoka kapi awarra murrakupuni Samaria pili awarra Samaria kuluwuta. Karri-kamini nyonga jarrumoka angi ampuriyi Galilee. ");
INSERT INTO tiw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kiyi papi pirimi kapi awarra kirijini murrakupuni Sychar. Awarra Jacob ngini ngarra parlingarri yimuwu api awarra yipakirayi ngarra-mirani Joseph kiyija murrakupuni yinkitayi kapi awarra murrakupuni Sychar. ");
INSERT INTO tiw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Awungarruwu awarra Jacob parlingarri yikurungumi (dug) kutunga (a well). Api karri waya anjiruwa awarra ngawa-yuwuni amintiya ngarra-mamanta papi pirimi awungarruwu kapi awinyirra kutunga api ngawa-yuwuni yimuwu awungaji. Ngarra janawurti pili pirripangulimayi karrampi. ");
INSERT INTO tiw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kiyi ngarra-mamanta ngawa-yuwuni purrupumwari awinyirra kutunga api purruwuriyi kapi awarra town ngini yinkitayi kapi awinyirra kutunga pili wuta purru-wutimarti ngini yinkiti pimatanga. Ngarra ngawa-yuwuni yuwanjipa kapi awinyirra kutunga. Kiyi natinga yimpalinya jinu-wuriyi kapi awinyirra kutunga. Nyirra awinyirra yimpalinya api nyirra murrakupuni awarra town ngini yinkitayi kapi awinyirra kutunga. Nyirra jinu-wuriyi kapi awinyirra kutunga ngini jimatanga (to get) kukuni. Api kiyi ngawa-yuwuni yimi kapi awinyirra yimpalinya, “Ngiyatuwu kukuni ngintaluwapa pili ngiya waya arntingi,” yimi. ");
INSERT INTO tiw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Api awinyirra yimpalinya jiyimi ngini, “Nginja awarra naki nginja Jew api ngiya awinyirra anaki Samaritan yimpalinya api nginja arnuka nanginta jimatami ngiya kukuni.” Nyirra awarra jipangiraga pili awuta Jews arnuka purru-wutimarti ngini pimata-mangapa kukuni ngini apalamiya kapi awuta Samaritans angi-wutawa namuli. ");
INSERT INTO tiw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kiyi ngawa-yuwuni yimi kapi awinyirra yimpalinya, “Nginja arnuka nimpirimajawu ngini ngawa-rringani ngini kuriyuwu awutimarti ngini yimata-kirayi nginja awarra arramu-kamini (something) ngini pupuni. Api awarra pupuni arramu-kamini api warntirrana pupuni kukuni awarra api ngawa-rringani yini-pangirri (sent) ngiya ngini ngimata-kirayi nginja awarra pupuni kukuni. Nginja nanginta nyimarimi (should have asked) ngiya ngini ngimata-kirayi nginja awarra kukuni api nginja karluwu jiyimajawu ngini ngawa-rringani yini-pangirri ngiya ngini ngimata-kirayi nginja awarra pupuni kukuni. Awarra pupuni kukuni arikirimi nuwa arikutumunuwi ngini warntirrana yimpanguwi ngimpirimi. Api nginja karluwu nimpirimajawu ngiya api nginja karluwu nanginta jiyimi ngiya awarra kukuni.” Ngawa-yuwuni awarra yipangiraga. ");
INSERT INTO tiw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Api awinyirra yimpalinya jiyimi ngini, “Nginja karri-kamini wulijinga angi arikulanga api awarra naki kukuni yilaru-amini (long way down) api nginja awungana jimatama ngini nimpunga (get) awarra ngini-nginjila kukuni?” jiyimi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kiyi awinyirra yimpalinya jiyimi kapi ngawa-yuwuni, “Nginja manya nimpirimi ngini nginja nimpirimajawu ngini jimata-kirayi ngawa awarra kukuni ngini wiyi arikirimi ngawa yimpanguwi. Arrami nginja nimpiri-mamuliya nginjila. Amintiya arrami nginja nimpirimi ngini ngawa-amini Jacob ngarra arnuka ngatawa. Yita ngarra ngatawa awarra ngawa-amini Jacob awarra ngini ngarra parlingarri yikirimi awarra anaki kutunga. Ngarra yimangapa kukuni kapi anaki kutunga kiyi ngarra-mamirampi amintiya kapi-ngatawa nanukutuwi (goats) amintiya sheepuwi awanuwanga pirimangapa awarra naki kukuni,” jiyimi awinyirra tinga kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kiyi ngawa-yuwuni yimi kapi awinyirra yimpalinya, “Nuwa kapi ngimpiri-mangapa kukuni kapi awinyirra anaki kutunga api nuwa awuta wiyi tuwanga arntingi ngimpirimi kukuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Api wutatuwu kapi wurimangapa ngini-ngilawa kukuni api wuta arnuka tuwanga arntingi wurimi. Awarra kukuni ngini-ngilawa wiyi yiloti alala arimi kangi wuta punyipunyi amintiya ruwuti. Ngarra arnuka awarra ngini-ngilawa kukuni yimata-kulumurri (won't dry up) api awuta kapi wurimangapa ngini-ngilawa kukuni wiyi yiloti wurumuwu kuriyuwu kapi ngarra ngawa-rringani japuja,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Api nyirra jipangiraga, “Ngiyatuwu nginja tayakirayi ngiya awarra ngini-nginjila kukuni pili ngiya wiyi karluwu tuwanga arntingi ngimatami amintiya ngiya karluwu tuwanga ngimatanga kukuni kangi anaki kutunga,” jiyimi. Awinyirra yimpalinya awarra jipangiraga pili nyirra karluwu jiyimajawu ngini-ngatawa meaning awarra ngirramini ngini ngarra ngawa-yuwuni yipangiraga ngini awarra ngini-ngatawa kukuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kiyi yimi ngawa-yuwuni kapi awinyirra yimpalinya, “Tamarruripa nginja-purnayi kangiya.” ");
INSERT INTO tiw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Api nyirratuwu jiyimi ngini, “Ngiya arnuka ngiya-purnayi.” Api ngawa-yuwuni yimi ngini, “Niyi warntirrana nginja jipangiraga ngini nginja karluwu nginja-purnay, ");
INSERT INTO tiw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","pili nginja waya marriti jiyimi pinginingita wawurruwi api nginja jupumwari awuta wawurruwi api ningani nginja nimpiri-marrimili nyoni tini. Api awarra ngini nginja jipangiraga ngini, ‘Ngiya arnuka ngiya-purnayi,’ api ngarra awarra warntirrana,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Api nyirra jiyimi ngini, “Ngiya waya ngirimajawu ngini nginja prophet pili nginja nimpirimajawu ngini ngiya parlingarri ngirikirim-ani (all I've done). ");
INSERT INTO tiw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kiyi awinyirra yimpalinya juwutimarti ngini maka awarra murrakupuni awungarruwu kapi ngawa arikutumunuwi ngamata-kuruwarni (should thank) ngawa-rringani. Api nyirra jiyimi kapi ngawa-yuwuni, “Ngawa-maninguwi kapi ngawiyati murrakupuni Samaria api wuta puru-kuruwarni ngawa-rringani ngini kuriyuwu kapi naki arikulani jupunyini (mountain),” jiyimi awinyirra yimpalinya. Kiyi jiyimi ngini, “Kapi nuwa Jews nuwa ngimpirimi ngini kapi Jerusalem ngawa ngamata-kuruwarni ngawa-rringani. Api maka awungarruwu warntirrana murrakupuni?” jiyimi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Api ngawa-yuwuni yimi ngini, “Awarra ngini ngiya nimarra ngiyimami (going to say) api ngarra warntirrana. Nuwa arikutumunuwi wiyi karluwu nginti-mata-kuruwarni (thank) ngawa-rringani kapi awarra naki jupunyini amintiya kapi Jerusalem awanuwanga nuwa wiyi karluwu nginti-mata-kuruwarni awarra ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","24","Yita nuwa arikutumunuwi kapi ngimpitimarti ngini nginti-mata-kuruwarni ngawa-rringani api nuwa wiyi ngimpakuturruwa awarra ngawa-rringani kangi nuwa ruwuti. Nuwa wiyi awungani (that way) warntirrana ngumpuru-kuruwarni awarra ngawa-rringani. Ngarra awarra ngawa-rringani awutimarti nuwa ngini nuwa awungani nginti-mata-kuruwarni ngarra ngini ngimpakuturruwa ngarra kangi nuwa ruwuti. Ngarra karluwu ngawa-rringani nginingaji nuwa arikutumunuwi. Ngarra awarra nginingaji yimanka api ngarra awutimarti nuwa arikutumunuwi ngini awungani nginti-mata-kuruwarni ngarra.” Ngarra awarra ngawa-yuwuni yimi kapi awinyirra yimpalinya. Kiyi yimi ngawa-yuwuni ngini, “Nuwa awuta Samaritans nuwa arnuka warntirrana ngimpiri-majawu ngawa-rringani ngini-ngatawa ngirramini api nuwa karluwu warntirrana ngumpuru-kuruwarni (thank) awarra ngawa-rringani. Api ngawatuwu Jews warntirrana ngarimajawu awarra ngawa-rringani ngini-ngatawa ngirramini api ngawa warntirrana ngaru-kuruwarni ngarra pili awarra ngawa-rringani parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (would send) tini ngini ngawiyati Jews ngini ngarra wiyi yimata-nyawu awarra jirti (the wrong) ngini wuta arikutumunuwi wurikirimi (do) api ngarra ngawa-rringani wiyi karluwu yimata-ngirri (won't send) awuta arikutumunuwi kapi ngarra maputiti japuja (hell) awuta tiwi kapi kuwa wurimi awarra tini.” Ngawa-yuwuni awarra yipangiraga kapi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kiyi jiyimi awinyirra yimpalinya, “Ngiya waya ngirimajawu ngini ngawa-rringani wiyi awuni-pangirri (will send here) kapi ngawa arikutumunuwi awarra tini ngini ngarra parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (would send) kapi ngawa, awarra ngini ngawa ngarimamula (call) ngarra Christ api karri ngarra awunu-wuriyi api ngarra wiyi amant-iyarra ngawa ngini-ngatawa meaning awarra tayikuwa-ni (all) ngirramini ngini ngawa-rringani yipangiraga.” Awarra jiyimi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Api yimi ngawa-yuwuni ngini, “Ngiya awarra Christ. Ngiya-rringani yini-pangirri (sent) ngiya kapi awarra naki murrakupuni (to this earth),” yimi ngawa-yuwuni kapi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kiyi ngawa-yuwuni ngarra-mamanta pini-pakupawurli (came back) kapi kutunga. Karri pirripakuluwunyi ngawa-yuwuni nimarra yimi kapi awinyirra yimpalinya api wuta pirimarlingiyi (got a surprise) api pirimi kangi wutamiya, “Kamini arrami ngawa-yuwuni yuwutimarti kangi awinyirra yimpalinya. Pilikama ngarra nimarra yimi kangi awinyirra.” Api wuta karluwu nanginta pirimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kiyi awinyirra yimpalinya jipumwari angi-nyitawa arikulanga wulijinga kapi awinyirra kutunga api juwuriyi kapi awarra town. Awungarruwu juwuntiyarra awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kali nyirru-waripa kangi kutunga. Awungarruwu nyirra-kuluwunyi awarra tini ngini ngarra yuwutiyarra ngiya ngini tayikuwa-ni (everything) ngini ngiya parlingarri ngirikirim-ani (what I've done),” jiyimi. “Arramukuta ngarra awarra Christ ngini ngawa-rringani parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (would send) awarra kapi ngawa arikutumunuwi,” jiyimi awinyirra yimpalinya. Api awuta tiwi karri piri-pitingaya (heard) awarra ngirramini ngini awinyirra yimpalinya jipangiraga ");
INSERT INTO tiw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","api purrupukularri api purruwuriyi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Karri awuta tiwi waya punu-wuja api ngawa-yuwuni ngarra-mamanta pirimi kangarra, “Tapa naki nginjila yinkiti.” ");
INSERT INTO tiw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Api ngawa-yuwuni yimi ngini, “Karluwu pili ngiya ngarra nyoni yinkiti. Nuwa arnuka ngimpiri-majawu ngini (about) awarra yinkiti,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Api ngawa-yuwuni ngarra-mamanta nimarra pirimi kangi wutamiya, “Arramukuta karri-kuwapi pirripakirayi ngarra yinkiti api kama ngarra yimi ngini, ‘Ngiya ngarra nyoni yinkiti,’” pirimi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kiyi ngawa-yuwuni yimi ngini, “Ngiya-rringani ngini kuriyuwu yini-pangirri (sent) ngiya kapi nuwa arikutumunuwi. Ngiya waki ngirimi ngini (for) ngarra. Ngiya ngimata-kuriyi (should finish) awarra waki. Karri ngiya waki ngirimi ngini (for) ngiya-rringani api awarra nginingaji awarra waki arikirimi ngiya yimpangini (alive) nginingaji karri ngawa yinkiti ngawapa api ngawa awungarri yimpanguwi ngarimi,” yimi ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tayikuwapi Samaritans kapi wuta japuja pirimi kapi awarra town Sychar api kuwa pirimi ngawa-yuwuni karri awinyirra yimpalinya juwuntiyarra awuta, “Ngarra yuwutiyarra ngiya tayikuwa-ni (everything) ngini ngiya parlingarri ngirikirim-ani (that I've done).” ");
INSERT INTO tiw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Api karri awuta Samaritans punuwuriyi kangatawa ngawa-yuwuni api pirimi ngini, “Ngawa ngawutimarti ngini nginja jimata-muwu kapi ngini-ngawula murrakupuni.” Api ngawa-yuwuni “Kuwa” yimi api yimuwu awungarruwu yirrara wumunga (2 days). ");
INSERT INTO tiw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Waya awungaji ngarra yuwuntiyarra tayikuwapi tiwi ngini-ngatawa ngirramini api yingampa (other) tiwi awanuwanga kuwa pirimi awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kiyi awuta tiwi pirimi kapi awinyirra yimpalinya, “Pupuni awarra ngini nginja juwutiyarra ngawa awarra ngirramini ngini awarra nayi Jesus api ngawa kuwa ngintirimi awarra ngini nginja jipangiraga. Kiyi awarra Jesus ngarralamiya yuwutiyarra ngawa ngini-ngatawa ngirramini api ngawa waya warntirrana kuwa ngarimi awarra ngirramini. Ngawa ngarimajawu ngini ngarra awarra Jesus wiyi awunyawu awarra jirti ngini ngawa tayikuwapi ngintiri-kirim-ani (the wrong we've done) api kiyi ngarra-rringani ngini kuriyuwu wiyi karluwu yimata-ngirri (won't send) ngawa kapi ngarra maputiti japuja (hell).” Wuta awarra pirimi awuta tiwi kapi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta purumuwu purrupumwari awarra murrakupuni Samaria kiyi wuta purruwuriyi kapi awarra murrakupuni Galilee. ");
INSERT INTO tiw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Puniyarri (before that time) yingampa arikutumunuwi kapi tangarima pirimi kapi Galilee api wuta purruwuriyi kapi Jerusalem kapi awarra Passover Ceremony. Awungarruwu kapi Jerusalem wuta pirripakuluwunyi awarra ngawa-yuwuni ngini yikirimi mirrikili (miracle) api karri ngarra papi yimi kapi Galilee api awuta arikutumunuwi kukunari pirimi kiyi pirimi kangatawa, “Awungana, mantani? Ngawa kukunari ngini nginja jinu-wuriyi awungarra,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kiyi ngawa-yuwuni yipakupawurli kapi awarra town Cana awungarruwu kapi ngarra ngawa-yuwuni pakinya mirrikili yikirimi ngini ngarra yikirimi awarra kukuni ngini wine yima. Kapi awarra murrakupuni Galilee api nyoni town Capernaum ngini yinkitayi kapi awarra town Cana. Kapi awarra town Capernaum yati alawura yimuwu. Awarra alawura ngarra-mirani jana yuwunyayi. ");
INSERT INTO tiw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Awarra alawura karri yipitingaya (heard) ngini ngawa-yuwuni yimuwu kapi awarra town Cana api ngarra yuwuriyi awungarruwu kapi Cana. Kiyi awungarruwu ngarra yuwunyayi ngawa-yuwuni kiyi yimi kangatawa, “Aya, mantani,” yimi. “Ngiya-mirani ngarra waya jana amintiya ngarra waya yinkitayi pajuwani api muwurniyi kangilawa japuja kapi Capernaum pili-ngini nginja pupuni jimata-kirimi ngarra,” yimi awarra alawura kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kiyi ngawa-yuwuni yimi kangatawa, “Nuwa arikutumunuwi karluwu kuwa ngimpirimi kangilawa. Waya juwa karri nuwa ngimpakuluwunyi ngiya ngini mirrikili (miracle) ngirikirimi api waya juwa awungarri nuwa kuwa ngimpirimi,” yimi ngawa-yuwuni kangi awarra alawura. ");
INSERT INTO tiw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Awarra alawura yimi kapi ngawa-yuwuni, “Mantani, muwurniyi kangilawa japuja pili ngiya-mirani waya yinkitayi pajuwani arimi. Api aningani muwurniyi,” yimi awarra alawura kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Api ngawa-yuwuni yimi kangatawa, “Ngajiti worry nimpajami pili nginja-mirani ngarra waya pupuni yima amintiya ngarra wiyi karluwu pajuwani yimatami. Tuwariyi japuja kapi nginja-mirani,” yimi ngawa-yuwuni. Kiyi awarra alawura kuwa yimi awarra ngini ngawa-yuwuni yipangiraga kiyi yipakupawurli japuja. ");
INSERT INTO tiw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Karri awarra alawura yuwuja kapi ngarra japuja api yingampa wawurruwi kapi waki pirimi ngini (for) ngarra, wuta punuwuriyi kangatawa kiyi pirripapijingi (met) ngarra kapi jarrumoka kiyi wuta pirimi kangatawa, “Nginja-mirani waya pupuni,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Api awarra alawura yimi kangi wutawa, “Awungarri ngarra ngiya-mirani pupuni yima?” yimi. Kiyi wuta purru-wutiyarra ngarra, “Marri japini karri anjiruwa api awungarri awarra jana yipumwari ngarra kiyi ngarra purnikapa pupuni yima,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Api awarra alawura yimajawu ngini ngarra-mirani pupuni yima karri ngawa-yuwuni yimi kangatawa, “Nginja-mirani waya pupuni yima.” Api kiyi awarra alawura amintiya awuta yingampa tiwi kapi wutiyati japuja awarra alawura api wuta kuwa pirimi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_21b","073_6_21b","JHN","6","21b","21b","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta yartipili papi pirimi maringarruwu kapi awarra lake. ");
INSERT INTO tiw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Tayikuwapi awuta arikutumunuwi puruwanjipa awungarruwu yinkitayi kapi awarra murrakupuni (place) kapi ngawa-yuwuni yikirimi awarra kiyija yinkiti ngini yingarti yima. Wuta awuta natinga wumunga (one night) pirimajirripi awungaji. Api karri japinari awuta arikutumunuwi pirimi, “Maka yimi awarra Jesus pili ngarra-mamanta waya juwa natinga kapala purruwuni (had) api ngarra karluwu yipawuriji yilaruwu kapi awinyirra kapala amintiya karri-kamini nyonga kapala awungarra.” Kiyi kularlaga pirimi ngawa-yuwuni api karluwu purruwunyayi ngarra. Kiyi yingampa tiwi kangi yingarti kapala papi pirimi awungarruwu kapi awarra murrakupuni. Wuta punuwuriyi kangi yingarti kapala. Awuta tiwi japuja pirimi kapi awarra town Tiberias. Kiyi awuta tayikuwapi arikutumunuwi pirripawuriji yilaruwu kapi awinyirra kapala api purruwuriyi kapi awarra town Capernaum pili wuta purru-wutimarti ngini wiyi awungarruwu kularlaga pimatami ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kiyi awuta tiwi karri papi pirimi awungarruwu kapi awarra town Capernaum api awungarruwu purruwunyayi ngawa-yuwuni kapi angi-wutawa awuta Jews kirijinga jurra (synagogue). Api pirimi kangatawa, “Awungarri jinu-wuriyi awungarra?” ");
INSERT INTO tiw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Api awarra ngawa-yuwuni karluwu yuwuntiyarra awuta tiwi. Waya juwa yimi ngini, “Awarra naki ngirramini warntirrana ngini nuwa kularlaga ngintirimi ngiya pili ngiya ngirripakirayi nuwa awarra yinkiti api kiyi nuwa murlikinya ngintirimi. Waya juwa awarra nuwa kularlaga ngintirimi ngiya. Nuwa karluwu ngintiri-majawu (didn't understand) ngini ngawa-rringani yipakirayi ngiya ngini-ngatawa power ngini ngiya ngirikirimi awarra kiyija yinkiti ngini yingarti yima.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kiyi ngawa-yuwuni yimi kapi awuta tiwi, “Wuta yingampa tiwi waya juwa wutimarti yinkiti ngini pimatapa. Nuwa ngajiti awungani ngimpajami pili awarra yinkiti ngarra yartipili punipani arima. Ngarra awarra yinkiti arnuka yinukuni yimata-muwu pupuni. Api kularlaga nyirrami awarra yinkiti ngini yinukuni arimuwu pupuni. Awarra yinkiti wiyi arikirimi nuwa ngini yiloti ngumpuru-muwu yimpanguwi. Ngiya wiyi ngipakirayi nuwa awarra yinkiti. Ngiya nuwa-yuwuni nuwa tayikuwapi tiwi. Ngawa-rringani yini-pangirri (sent) ngiya kapi nuwa api yuwutiyarra ngiya ngini ngipakirayi nuwa awarra yinkiti ngini wiyi arikirimi nuwa ngini wiyi yiloti ngumpuru-muwu.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Api pirimi awuta tiwi, “Ngawa ngawutimarti ngini yiloti ngamata-muwu api tajiyarra ngawa awarra waki ngini ngawa-rringani awutimarti ngawa ngini waki ngamatami ngini (for) ngarra.” ");
INSERT INTO tiw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Api yimi ngawa-yuwuni, “Waya juwa ngawa-rringani awutimarti nuwa ngini kuwa nginti-matami ngiya pili ngiya awarra ngini ngarra yini-pangirri (sent) ngiya kapi nuwa arikutumunuwi,” yimi ngawa-yuwuni kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kiyi awuta tiwi pirimi ngini, “Kamini awarra arikulani mirrikili (miracle) ngini nginja wiyi nimpirikirimi api karri ngawa wiyi ngapakuluwunyi awarra mirrikili api ngawa wiyi kuwa ngarimi awarra ngirramini ngini nginja jipangiraga ngini ngarra ngawa-rringani ngini kuriyuwu yini-pangirri (sent) nginja kapi ngawa arikutumunuwi? Kamini awarra mirrikili ngini nginja wiyi nimpirikirimi ");
INSERT INTO tiw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","nginingaji ngarra Moses yikirimi (did) parlingarri. Ngarra awarra Moses yipakirayi ngawa-maninguwi yingarti yinkiti awungarruwu kapi awarra murrakupuni kapi karri-kuwapi japuja pirimi. Wuta papaluwi pirikirimi (wrote) kapi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) ngini ngarra Moses yipakirayi awuta ngawa-maninguwi awarra yinkiti ngini yini-papirraya kapi yakuluwuni api ngawa-maninguwi purruwapa awarra yinkiti. Awuta papaluwi awarra pirikirimi kapi awarra punkaringini,” pirimi awuta tiwi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Api yimi ngawa-yuwuni kapi awuta tiwi, “Nuwa karluwu ngimpiri-majawu (don't understand) awarra ngirramini ngini awuta papaluwi pirikirimi (wrote) kangi awarra punkaringini pili awarra Moses karluwu yipakirayi ngawa-maninguwi awarra yinkiti. Ngarra awarra ngawa-rringani ngini kuriyuwu yikirimi awarra yinkiti api yini-pangirri (sent) kapi yakuluwuni awarra yinkiti ngini awuta ngawa-maninguwi purruwapa. Api ngarra waya ningani awuni-pangirri (sends) kapi nuwa nyoni yinkiti ngini warntirrana. ");
INSERT INTO tiw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Awarra yinkiti ngini awarra ngawa-rringani ngini kuriyuwu ningani awuni-pangirri kapi nuwa api awarra yinkiti wiyi arikirimi nuwa ngini yiloti ngumpuru-muwu yimpanguwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Api wuta pirimi ngini, “Waya ningani tayakirayi ngawa awarra nayi yinkiti ngini warntirrana.” ");
INSERT INTO tiw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kiyi ngawa-yuwuni yimi ngini, “Ngiya awarra yinkiti ngini (who) warntirrana. Ngiya yimpanguwi ngirikirimi nuwa arikutumunuwi. Awuta tiwi kapi kuwa wurimi ngiya api wuta awuta wiyi kukunari wurimi nginingaji awuta tiwi kapi wuni yingarti yinkiti amintiya kukuni. Wuta awuta wiyi yiloti kukunari wurimi. ");
INSERT INTO tiw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tani-waya (no matter) nuwa nginti-pakuluwunyi awarra mirrikili (miracle) ngini ngiya ngirikirimi api nuwa karluwu kuwa ngimpirimi ngiya nginingaji ngiya waya ngurru-wutiyarra nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","Kiyi ngawa-yuwuni nyoni nginaki yimi ngini, “Awuta tiwi kapi wunuwuriyi kangilawa amintiya wupapunya angilawa jarrumoka api ngiya nimarra ngirimi kangi wutawa ngini, ‘Pupuni awarra ngini nuwa nguntunu-wuriyi kangilawa.’ Ngiya karluwu “Pirri,” ngimatami kangi wutawa pili ngiya-rringani awuni-pangirri (sends) awuta tiwi kapi ngiya amintiya ngiya waki ngirimi ngini (for) awarra ngiya-rringani. Ngiya pakinya japuja ngirimi kuriyuwu kapi ngawa-rringani japuja api ngiya ngini-papirraya kapi awungarra naki murrakupuni (to this earth) ngini waki ngimatami ngini (for) ngarra. Ngiya karluwu alawura ngiyalamiya.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kiyi yimi ngini, “Ngarra awarra ngiya-rringani awutimarti ngiya ngini warntirrana ngimata-mangi tayikuwapi (all) awuta tiwi kapi ngarra awuni-pangirri (sends) kangilawa. Amintiya karri naki murrakupuni wiyi apapaya (the earth will finish) api ngiya-rringani awutimarti ngiya ngini wiyi awungarri ngimata-kirimi awuta tiwi ngini pimata-kularri api tuwanga yimpanguwi wurima awuta tiwi kapi pirripapunya angilawa jarrumoka karri wuta nanuwanga (still) yimpanguwi pirimi.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kiyi yimi ngawa-yuwuni ngini, “Tayikuwapi (all) awuta tiwi kapi wuru-pungintayi (think about) ngini-ngilawa ngirramini api kiyi kuwa wurimi ngiya api ngiya wiyi ngirikirimi awuta ngini wupukularri api tuwanga yimpanguwi wurima karri ngiya wiyi judge ngirimi tayikuwapi (all) tiwi. Api ngarra awarra ngiya-rringani awutimarti awuta tiwi ngini yiloti pimata-muwu kangatawa.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kiyi awuta tiwi jukuta pirimajirri (whispered) ngini (about) awarra naki ngirramini ngini ngarra ngawa-yuwuni yipangiraga ngini ngarra pakinya japuja yimi kuriyuwu kapi ngawa-rringani japuja amintiya ngini ngarra awarra yinkiti ngini yini-papirraya kapi. Wuta karluwu awuta tiwi kuwa pirimi awarra ngirramini ngini ngawa-yuwuni yipangiraga ");
INSERT INTO tiw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","api pirimajirri ngini, “Kama ngarra yimi ngini ngarra yinirimi kapi kuriyuwu pili ngarra-rringani Joseph awarra naki Jesus. Ngawa ngarimajawu awarra Joseph amintiya ngarra-naringa awarra naki Jesus,” pirimajirri awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kiyi yimi ngawa-yuwuni kapi awuta tiwi, “Ngajiti jukuta ngimpaja-majirri.” ");
INSERT INTO tiw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kiyi yimi ngini, “Karri-kuwapi ngini-wutawa punyipunyi (idea) ngini wupapunya angilawa jarrumoka. Yita ngiya-rringani apalamiya kangi wuta punyipunyi ngini pimata-punya angilawa jarrumoka. Api karri naki murrakupuni wiyi apapaya (the earth will finish) api awuta tiwi kapi waya pajuwani pirimi api ngiya wiyi awungarri ngirikirimi awuta tiwi ngini wupukularri api tuwanga yimpanguwi wurima awuta tiwi kapi pirripapunya angilawa jarrumoka karri wuta nanuwanga (still) yimpanguwi pirimi.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kiyi yimi ngawa-yuwuni ngini, “Yati prophet ngini parlingarri yimuwu api ngarra awarra yikirimi (wrote) kapi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) ngini awarra ngawa-rringani wiyi awunu-wani (help) tayikuwapi arikutumunuwi ngini wurimajawu (understand) ngini-ngatawa ngirramini,” yimi ngawa-yuwuni. Kiyi yimi ngini, “Awuta arikutumunuwi kapi wurimajawu awarra ngini-ngatawa ngawa-rringani ngirramini api kiyi kuwa wurimi awarra ngirramini api awuta arikutumunuwi wiyi wunuwuriyi kangilawa,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kiyi nyoni nginaki ngirramini yipangiraga awarra ngawa-yuwuni, “Karri-kuwapi wupakuluwunyi ngawa-rringani ngini kuriyuwu. Ngiya wangata ngirripakuluwunyi ngarra pili ngiya pakinya japuja ngirimi awungarruwu kuriyuwu kapi ngarra ngawa-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kiyi yimi ngawa-yuwuni ngini, “Ngiya waya ngurru-wutiyarra nuwa ngini ngiya pakinya japuja ngirimi kapi kuriyuwu amintiya ngini ngiya ngini-papirraya kapi naki murrakupuni (to the earth). Ngiya awarra yinkiti ngini arikirimi arikutumunuwi warntirrana yimpanguwi wurima. Awuta tiwi kapi wuwapa awarra yinkiti api wiyi yiloti wurumuwu kapi ngiya-rringani. Awarra yinkiti api ngiya ngini-ngilawa purnikapa awarra api ngiya wiyi ngipakirayi awarra ngini-ngilawa purnikapa kapi nuwa tayikuwapi arikutumunuwi pili-ngini nuwa wiyi yiloti ngumpuru-muwu.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kiyi awuta tiwi karri piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yipangiraga api wuta yingampa jurrumumi jiyimi angi-wutawa yiminga (became angry) api piriwayatipi kangi yingampa awuta tiwi, pirimi ngini, “Awungana yirrijama (how can he) ngini ngarra apakirayi ngawa ngini-ngatawa purnikapa ngini ngamatapa?” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kiyi yimi ngawa-yuwuni, “Ngiya nuwa-yuwuni nuwa tayikuwapi arikutumunuwi. Ngini nuwa karluwu ngimpapa ngini-ngilawa purnikapa amintiya ngini karluwu ngimpiri-mangapa ngini-ngilawa majipani api ngarra ngawa-rringani wiyi karluwu yimata-muwu kangi nuwula ruwuti. Ngarra awarra ngirramini warntirrana,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Kiyi yimi ngini, “Awarra ngini-ngilawa purnikapa api warntirrana awarra yinkiti amintiya ngini-ngilawa majipani api warntirrana awarra ngini nuwa ngimpiri-mangapa api awuta kapi wuwapa ngini-ngilawa purnikapa amintiya wurimangapa ngini-ngilawa majipani api wuta wiyi awuta yiloti wurumuwu. Wuta awuta tiwi ngini wuta waya pajuwani karri naki murrakupuni wiyi apapaya (the earth will finish) api ngiya wiyi ngirikirimi awuta ngini wupukularri api tuwanga yimpanguwi wurima,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kiyi yimi ngini, “Awuta tiwi kapi wuwapa ngini-ngilawa purnikapa amintiya wurimangapa ngini-ngilawa majipani api wuta wiyi yiloti wurumuwu kangilawa amintiya ngiya wiyi awanuwanga ngurumuwu yiloti kangi wutawa.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kiyi ngawa-yuwuni nyoni ngirramini yipangiraga, “Ngiya waya ngurru-wutiyarra nuwa ngini ngiya-rringani yini-pangirri (sent) ngiya kapi nuwa arikutumunuwi. Awarra ngiya-rringani yiloti arimuwu yimpangini amintiya ngarra awanuwanga arikirimi ngiya ngini yimpangini ngirimi. Api ngiyatuwu awanuwanga ngirikirimi yimpanguwi awuta tiwi kapi wuwapa ngini-ngilawa purnikapa.” Ngarra awarra yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kiyi yimi ngawa-yuwuni ngini, “Ngiya waya ngurru-wutiyarra nuwa ngini ngiya awarra yinkiti ngini ngawa-rringani ngini kuriyuwu yini-pangirri (sent) ngiya kapi nuwa arikutumunuwi. Ngiya karluwu nginingaji awarra yinkiti ngini nuwa-maninguwi parlingarri purruwapa karri wuta pirripapunya awarra Moses awungarruwu kapi awarra murrakupuni kapi karri-kuwapi japuja pirimi. Awuta nuwa-maninguwi kapi purruwapa awarra yinkiti api wiyi parlinginari (later) pajuwani pirimi karri wuta wulimawi. Api awuta tiwi kapi wuwapa awarra yinkiti ngini ngiya ngipakirayi wuta api wuta awuta wiyi wurumuwu yiloti. Awarra yinkiti api ngiya ngini-ngilawa purnikapa awarra,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Awarra ngirramini ngini ngarra ngawa-yuwuni yuwuntiyarra awuta tiwi awungarruwu kapi angi-wutawa Jews jurra kapi awarra town Capernaum. ");
INSERT INTO tiw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Karri ngarra ngawa-yuwuni yipapaya ngini nimarra yimi api tayikuwapi awuta tiwi kapi pirripapunya awarra ngawa-yuwuni amintiya piri-pitingaya (heard) ngini-ngatawa ngirramini api awuta yingampa jukuta pirimajirri (whispered), “Ngawa karluwu kuwa ngamatami (can't believe) awarra ngirramini ngini-ngatawa. Ngawa karluwu ngarimajawu (don't understand) awarra ngirramini.” Wuta awarra jukuta pirimajirri awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Api ngawa-yuwuni yimajawu ngini wuta jukuta pirimajirri api yimi kangi wutawa, “Arramukuta nuwa karluwu pupuni ngumpuru-muwu ngini-ngilawa ngirramini. Arrami nuwa waya karluwu ngimpitimarti ngini nginti-mata-punya angilawa jarrumoka,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kiyi yimi ngini, “Ngiya nuwa-yuwuni nuwa tayikuwapi (all) tiwi. Karri ngiya wiyi ngipapurti kuriyuwu kapi ngiya pakinya japuja ngurumuwu ngawiyati ngiya-rringani api ngini nuwa ngimpakuluwunyi ngiya karri ngiya ngipapurti api arrami nuwa wiyi awungarri kuwa ngimpirimi ngini ngiya pakinya japuja ngirimi kuriyuwu kapi ngawa-rringani,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kiyi yimi ngawa-yuwuni ngini, “Nuwa karluwu nginti-mata-kirimi (can't make) nuwulamiya ngini yiloti ngumpuru-muwu kapi ngawa-rringani ngarra japuja. Ngarra wangata ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) arikirimi nuwa ngini wiyi ngumpuru-muwu yiloti kapi ngawa-rringani. Awarra ngirramini ngini ngiya ngurru-wutiyarra nuwa api ngini nuwa kuwa ngimpirimi awarra ngirramini api awarra pukwiyi wiyi apawuriji yilaruwu kangi nuwa ruwuti. Amintiya awarra ngirramini wiyi arikirimi nuwa ngini yiloti ngumpuru-muwu yimpanguwi kapi ngawa-rringani kapi kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Api nuwatuwu yingampa karluwu kuwa ngimpirimi ngini-ngilawa ngirramini,” yimi ngawa-yuwuni. Ngarra waya yimajawu awuta tiwi kapi wuta wiyi karluwu kuwa pimatami ngini-ngatawa ngirramini amintiya awanuwanga yimajawu awarra tini ngini ngarra wiyi traitor arimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kiyi ngawa-yuwuni yimi kangi awuta tiwi, “Ngiya ngurru-wutiyarra nuwa ngini wuta wangata wunuwuriyi kangilawa awuta tiwi kapi ngarra ngawa-rringani apalamiya kangi wuta punyipunyi ngini wuta pini-matu-wariyi kangilawa. Awuta tiwi kapi ngawa-rringani awunu-wani (helps) awuta ngini wunuwuriyi kangilawa api wuta wangata wupapunya angilawa jarrumoka. Ngiya awarra ngurru-wutiyarra nuwa pili yingampa tiwi karluwu kuwa wurimi ngini-ngilawa ngirramini.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kiyi tayikuwapi tiwi kapi pirripapunya ngawa-yuwuni api karri piri-pitingaya (heard) awarra ngirramini ngini ngarra yipangiraga api wuta awungarri purrupumwari ngawa-yuwuni. Wuta karluwu tuwanga pirripapunya awarra ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kiyi ngawa-yuwuni nimarra yimi kapi awuta wamurrara yuwurrara (12) ngarra-mamanta api nanginta yimi wutawa, “Marri nuwa? Arrami nuwa wiyarri wiyi ngumpumwari ngiya,” yimi ngawa-yuwuni kapi awuta wamurrara yuwurrara ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Api Simon Peter yimi kangi ngawa-yuwuni, “Karluwu pili nginja ngawa-alawura nginja api ngawa karluwu ngamata-punya (shouldn't follow) nyoni tini pili nginja yati nimputiyarra ngawa pupuni ngirramini api ngini ngawa kuwa ngarimi awarra ngirramini ngini-nginjila api ngawa wiyi yiloti ngarimuwu. ");
INSERT INTO tiw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nginja warntirrana pupuni amintiya ngawa waya ngarimajawu ngini ngawa-rringani yini-pangirri (sent) nginja kapi awungarra naki murrakupuni pili-ngini waki nimpirimi ngini (for) ngarra. Ngawa waya ningani kuwa ngarimi awarra ngirramini.” Ngarra awarra yipangiraga awarra Simon Peter kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kiyi yimi ngawa-yuwuni kapi ngarra-mamanta, “Tani-waya (no matter) ngiya ngurru-wunga (picked) nuwa wamurrara yuwurrara (12) wawurruwi ngini waki nginti-matami ngini (for) ngiya api yati kapi nuwa ngarra maputiti.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ngarra nimarra yimi ngini (about) Judas. Awarra Judas api ngarra-rringani Simon Iscariot. Ngarra awarra Judas api ngarra awarra yati kapi awuta wamurrara yuwurrara (12) wawurruwi api ngarra wiyi (later on) traitor yimi kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kiyi ngawa-yuwuni Jesus yipangulimayi kapi yingarti town kapi awarra murrakupuni Galilee. Ngarra arnuka yuwuriyi awungarruwu kapi awarra nyoni murrakupuni Judea pili awuta alawuruwi kapi Jews kapi japuja pirimi kapi awarra timani api wuta purru-wutimarti ngini pimata-pirni ngarra. ");
INSERT INTO tiw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Awungarruwu kapi Judea awuta Jews waya yinkitayi pirikirimi awarra ceremony ngini wuta pirimamula (called) Feast of Tabernacles. Karri awarra ceremony api wuta pirikirimi yingarti marlani api punyipunyinga wumunga (8 days) purumuwu awungarruwu kapi awarra marlani. Wuta awungarri yingarti yinkiti purruwapa amintiya puru-kuruwarni (thanked) ngawa-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Karri awuta Jews waya yinkitayi pirikirimi awarra ceremony api awuta wawurruwi kapi ngawa-yuwuni ngarra-marrikulupi punuwuriyi kangatawa api pirimi ngini, “Ngajiti awungarra kularlaga nimpajami. Tuwariyi kapi Judea pili nginja-mamanta kapi japuja awungarruwu wuta pimata-kuluwunyi (should see) awarra mirrikili (miracle) ngini nginja nimpirikirimi. Awuta tayikuwapi tiwi awungarruwu kapi Judea wiyi awanuwanga pimata-kuluwunyi awarra mirrikili. Ngini nginja nimpitimarti tayikuwapi tiwi ngini pimata-majawu ngini (about) nginja api ngajiti nimpaja-kirimi awarra mirrikili awungarra naki kapi kiyija tiwi wurumuwu.” Wuta awarra pirripangiraga ngawa-yuwuni ngarra-marrikulupi pili wuta karluwu kuwa pirimi ngini awarra wuta-marrikuluwuni api ngarra ngawa-rringani ngarra-mirani awarra. ");
INSERT INTO tiw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","8","Kiyi ngawa-yuwuni yimi kapi ngarra-marrikulupi, “Ngiya wiyi karluwu ninganara ngimatu-wariyi awungarruwu kapi awarra ceremony pili ngiya-rringani karluwu yuwutiyarra ngiya ngini ngimatu-wariyi awungarruwu. Awuta tayikuwapi tiwi jirti wurumuwu ngiya pili ngiya nguwuntiyarra awuta ngini (that) wuta jirti wurikirimi (do wrong things). Wuta karluwu jirti wurumuwu nuwa api nuwa nyirru-wariyi karri nuwa ngimpitimarti. Nuwa pakinya nyirru-wariyi kapi awarra ceremony. Ngiya wiyi yintayi ngumpuriyi awungaji karri ngiya-rringani awutiyarra ngiya ngini ngimatu-wariyi,” yimi ngawa-yuwuni kapi awuta ngarra-marrikulupi ");
INSERT INTO tiw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","api ngarra arnapa yimuwu (waited) awungarruwu kapi Galilee. ");
INSERT INTO tiw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Api karri ngarra-marrikulupi purruwuriyi api ngarra awungarri yintayi yimi. Ngarra karluwu yuwutimarti tayikuwapi tiwi ngini pimata-kuluwunyi ngarra yirrikilingapa api ngarra karluwu yipapunya awuta tayikuwapi tiwi kapi purruwuriyi kapi awarra ceremony. ");
INSERT INTO tiw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Awungarruwu kapi awarra ceremony awuta alawuruwi kapi wuta Jews pirripakuluwunyi kapi jarrumoka ngini arramukuta ngawa-yuwuni awunu-wuriyi. Api nanginta pirimi tayikuwapi tiwi, “Maka awarra nayi Jesus?” pirimi awuta alawuruwi. Api karri-kuwapi nimarra pirimi kangi wutawa. ");
INSERT INTO tiw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Tayikuwapi tiwi mimpa pirimi kapi awarra ceremony. Wuta nimarra pirimajirri ngini (about) awarra ngawa-yuwuni. Wuta mamana pirripangiraga pili wuta pirimakirri awuta alawuruwi pili ngini wuta pirrijami (if they said) ngini ngawa-yuwuni ngarra pupuni api wiyi awuta alawuruwi pirrija-kirayi (they would give) jirti ngirramini (trouble) kapi wuta api wuta mamana pirripangiraga. Yingampa (some) awuta tiwi pirimi ngini ngarra pupuni tini api wutatuwu yingampa (others) pirimi ngini, “Ngarra karluwu pupuni tini pili ngarra kunyani arimi kangawula,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Karri nginingaji yukurri wumunga (days) jipapaya kapi awarra ceremony api awarra ngawa-yuwuni yuwuriyi kapi awarra yard yinkitayi kapi awinyirra arikulanga jurra api awungarruwu awarra ngawa-yuwuni yuwuntiyarra awuta arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Api awuta alawuruwi karri piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yuwuntiyarra awuta tiwi api pirimi ngini, “Kama awarra naki Jesus pupuni nimarra arimi ngini ngawa-rringani ngini-ngatawa ngirramini? Kuwapi arrami puruwaluwa (taught) awarra pili ngarra arnuka yipawuriji yilaruwu kapi ngini-ngawula jukuli.” Wuta awarra pirripangiraga awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","26","Kiyi yingampa awuta tiwi kapi purumuwu kapi Jerusalem api wuta awuta tiwi karluwu kuwa pirimi ngawa-yuwuni Jesus api wuta pirimi ngini, “Kama awarra naki Jesus nimarra awujingimi kapi ngawa tayikuwapi tiwi pili awuta alawuruwi wutimarti ngini pimata-pirni awarra. Kama awuta alawuruwi karluwu wurikirimi awarra ngini karluwu nimarra yimatami kangawa? Arramukuta wuta waya kuwa wurimi ngini ngarra ngawa-rringani ngini kuriyuwu yini-pangirri (sent) awarra naki Jesus kapi ngawa arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Api ngawatuwu karluwu kuwa ngarimi ngini ngarra ngawa-rringani yini-pangirri awarra Jesus kangawula pili ngawa ngarimajawu awarra naki Jesus ngini-ngatawa murrakupuni api awarra Christ ngini ngarra ngawa-rringani wiyi awuni-pangirri (send) ngarra kapi ngawa arikutumunuwi api karri-kuwapi wiyi wurimajawu ngini-ngatawa murrakupuni.” Wuta awarra pirlamarri (without knowing) pirripangiraga awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Awarra ngawa-yuwuni nanuwanga (still) yuwunu-waluwa (taught) awuta tiwi kapi awarra yard awungarruwu kapi awinyirra arikulanga jurra api makirrana yipangiraga, “Kuwa. Nuwa ngimpiri-majawu ngiya amintiya nuwa amparrimani ngimparimi ngini nuwa ngimpiri-majawu kapi ngiya pakinya nginirimuwu api nuwa karluwu. Amintiya nuwa karluwu ngimpiri-majawu awarra ngini yini-pangirri (sent) ngiya kapi nuwa arikutumunuwi. Ngiya karluwu awarra ngini-ngilawa punyipunyi (idea) ngini (to) ngunuwuriyi kapi nuwa arikutumunuwi. Ngarra awarra ngini yini-pangirri ngiya kapi nuwa api ngarra awarra warntirrana. ");
INSERT INTO tiw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngiya wangata ngirimajawu awarra pili ngiya pakinya japuja ngirimi kangatawa api ngarra awarra ngini yini-pangirri ngiya kapi nuwa arikutumunuwi.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Karri ngawa-yuwuni awarra yipangiraga api yingampa tiwi punuwuriyi kangatawa api waya yinkitayi purruwunga ngarra api karluwu pili ngarra ngawa-rringani yuwunjarl-amuwi (stopped) awuta tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wutatuwu yingampa (others) awuta tiwi kuwa pirimi ngawa-yuwuni. Tayikuwapi awuta. Api mamana pirimajirri ngini, “Awarra Christ ngini ngarra ngawa-rringani ngini kuriyuwu parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (send) ngarra kapi ngawa arikutumunuwi api ngarra wiyi awarra yingarti mirrikili (miracles) arikirimi api ngawa wiyi ngarimajawu ngini ngarra awarra Christ ngini ngarra ngawa-rringani yini-pangirri (sent) kapi ngawa. Awarra naki Jesus arikirimi yingarti mirrikili api arrami ngarra awarra Christ.” Wuta awarra mamana pirripangiraga awuta yingampa tiwi. ");
INSERT INTO tiw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kiyi awuta Pharisees piri-pitingaya (heard) awarra ngirramini ngini yingampa awuta tiwi mamana pirripangiraga ngini (about) ngawa-yuwuni ngini arrami ngarra awarra Christ ngini ngarra ngawa-rringani parlingarri yimi ngini ngarra wiyi yini-mata-ngirri (send) awarra kapi awuta tiwi api awuta Pharisees amintiya awuta priests kapi wuta alawuruwi pirimi kapi awuta majatawi, “Nyirru-wariyi, nyirranga awarra nayi Jesus.” Api awuta majatawi purruwuriyi kapi awarra ngawa-yuwuni api karluwu purruwunga (didn't get) awarra ");
INSERT INTO tiw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kiyi ngawa-yuwuni yimi kapi awuta tiwi, “Ngiya karluwu yinukuni ngimata-muwu awungarra kangi nuwa pili ngiya wiyi ngipakupawurli kapi awarra ngini ngarra yini-pangirri (sent) ngiya awungarra. ");
INSERT INTO tiw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nuwa wiyi kularlaga ngimpirimi ngiya api nuwa karluwu wiyi ngumpunyayi (find) ngiya awungarra. Api kapi ngiya wiyi ngumpuriyi api nuwa arnuka awungarruwu nginti-matu-wariyi (can't go).” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Api awuta alawuruwi nimarra pirimajirri, “Maka arrami ngarra wiyi awuriyi? Maka awarra murrakupuni kapi ngawa arnuka ngamata-punya ngarra? Arramukuta ngarra wiyi awuriyi kapi awuta ngawa-mamanta Jews awungarruwu kapi awarra yingarti murrakupuni kapi awuta tiwi wupangiraga Greek api arramukuta wiyi awungarruwu awuntiyarra awuta Greeks ngini-ngatawa ngirramini.” Wuta awarra pirripangiraga awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kiyi pirimi ngini, “Pilikama ngarra yimi ngini, ‘Nuwa wiyi kularlaga ngimpirimi ngiya api karluwu ngumpunyayi (find) ngiya?’ Amintiya kama yimi ngini ngawa karluwu ngamata-punya ngarra kapi ngarra wiyi awuriyi.” Wuta awarra pirimajirri awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Awuta majatawi wiyi parlinginari (later on) pirripakupawurli kapi awuta Pharisees amintiya wuta-mamanta priests kapi wuta alawuruwi awuta majatawi kapi awuta alawuruwi purru-wuntiyarra awuta ngini pimatanga awarra ngawa-yuwuni Jesus. Wuta awuta majatawi karluwu piniri-marruriyi ngawa-yuwuni Jesus kapi awuta alawuruwi. Api awuta alawuruwi pirimi kangi awuta majatawi, “Pilikama nuwa karluwu ngintiniri-marruriyi kangawa awarra nayi Jesus?” ");
INSERT INTO tiw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Api pirimi awuta majatawi, “Karluwu pili karri-kuwani parlingarri nimarra pirimi nginingaji naki awarra Jesus. Ngawa karluwu nguntuwunga awarra pili ngarra apangiraga ngini warntirrana ngirramini,” pirimi awuta majatawi. ");
INSERT INTO tiw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Api pirimi awuta Pharisees, “Arrami nuwa wiyarri kuwa ngimpirimi awarra ngirramini ngini ngarra kunyani arimi (his lies). ");
INSERT INTO tiw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngawa Pharisees amintiya ngawa-mamanta awuta yingampa (other) alawuruwi api ngawa karri-kuwapi kuwa ngarimi ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Waya juwa awuta kapinaki tayikuwapi kuwa wurimi awarra ngirramini ngini-ngatawa pili wuta karluwu wurimajawu ngini ngarra Moses ngirramini (law) api ngarra ngawa-rringani wiyi awuni-pirni awuta tiwi.” Wuta awarra pirripangiraga awuta Pharisees. ");
INSERT INTO tiw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kiyi karri pangarri api karri natinga arawunga (early morning) ngawa-yuwuni yuwuriyi kapi awarra yard awungarruwu kapi awinyirra arikulanga jurra (temple) angi-wutawa Jews awungarruwu kapi Jerusalem. Waya awungaji tayikuwapi arikutumunuwi mimpa pirimi kangi ngawa-yuwuni kiyi ngarra yimuwu kiyi yuwuntiyarra awuta ngawa-rringani ngini-ngatawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Kiyi awuta Pharisees amintiya awuta scribes piniri-marruriyi natinga yimpalinya kangi awinyirra jurra. Wuta pirikirimi awinyirra ngini tayinti jiyimi kuluwuta kapi awuta tayikuwapi arikutumunuwi kiyi wuta pirimi kapi ngawa-yuwuni, “Aya, Rapayi, ngawa nguntuwunyayi anaki yimpalinya angi jiyimarrimili nyoni tini ngini ngarra karluwu nyirra-purnayi awarra,” pirimi awuta Pharisees amintiya awuta scribes kapi ngawa-yuwuni. Awarra yintanga Rapayi mean arimi ngini awarra tini awunu-waluwa (teaches) arikutumunuwi ngawa-rringani ngini-ngatawa ngirramini (law). ");
INSERT INTO tiw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","6","Kiyi awuta Pharisees amintiya scribes tuwanga pirimi kapi ngawa-yuwuni, “Parlingarri Moses yikirimi (wrote) ngirramini (law) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) ngini ngawa ngamata-nyawu (should throw) waranguwi kapi awuta maminikuwi kapi jajiruwi pili-ngini wuta wiyi pajuwani pimatami (would die) api ngawa ngamata-nyawu waranguwi kangi anaki yimpalinya pili nyirra jiringa. Awungana nginjatuwu?” pirimi kangi ngawa-yuwuni. Wuta awarra nanginta pirimi ngarra pili purru-wutimarti ngini pimata-kiyarri (trick) ngarra. Wuta nimarra pirimajirri, “Arramukuta ngarra wiyi apangiraga ngini ngawa karluwu kuwa ngamatami awarra ngirramini (law). Ngini ngarra wiyi apangiraga awarra api ngawa wiyi ngawuntiyarra awuta priests kapi wuta alawuruwi ngini naki awarra Jesus ngarra jirti pili ngarra awutimarti ngawa ngini karluwu kuwa ngamatami ngini-ngawula ngirramini (law),” pirimajirri awuta Pharisees amintiya awuta scribes. Api ngawa-yuwuni arnuka nimarra yimi kangi wutawa api ngarra yipajiyarri (bent down) kiyi yikirimi (wrote) ngirramini kapi yakuluwuni. ");
INSERT INTO tiw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kiyi awuta Pharisees amintiya awuta scribes tuwanga-la nanginta pirimi ngawa-yuwuni ngini wuta pimata-nyawu waranguwi kangi awinyirra yimpalinya. Kiyi ngawa-yuwuni tayinti yimi kiyi yimi kapi awuta, “Nuwa kapi karluwu jirti ngintiri-kirim-ani (done wrong) api nuwa pakinya nyirra-nyawu waranga kapi anaki yimpalinya,” yimi ngawa-yuwuni kangi awuta Pharisees amintiya awuta scribes. ");
INSERT INTO tiw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kiyi ngawa-yuwuni tuwanga yipajiyarri (bent down) amintiya tuwanga yikirimi ngirramini kapi yakuluwuni. ");
INSERT INTO tiw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Awuta Pharisees amintiya awuta scribes karri wuta piri-pitingaya (heard) awarra ngirramini ngini ngarra ngawa-yuwuni yipangiraga api wuta awungarri arliranga pirimi pili wuta wiyarri jirti pirikirim-ani (did wrong) api wuta purrupumwari ngawa-yuwuni api purruwuriyi yatatila. Awuta kapi wulimawi purruwuriyi pakinya kiyi awuta yingampa purruwuriyi api ngawa-yuwuni amintiya awinyirra yimpalinya wuta wangata. ");
INSERT INTO tiw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kiyi ngawa-yuwuni tuwanga tayinti yimi kiyi nanginta yimi awinyirra yimpalinya, “Maka pirimi awuta wawurruwi? Kuwani yuwunyawu waranga kapi nginja pili nginja awarra jirti jiyikirimi (did that wrong thing)?” yimi ngawa-yuwuni kangi nyirra. ");
INSERT INTO tiw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Api nyirra jiyimi ngini, “Karri-kuwani, mantani.” Kiyi ngawa-yuwuni yimi ngini, “Ngiya awanuwanga karluwu ngimata-nyawu waranga kapi nginja. Api yartipili tuwariyi kanginjila japuja. Tayapunya ngawa-rringani ngarra pupuka jarrumoka api ngajiti tuwanga jirti nimpaja-kirimi (don't do wrong again).” Awarra yimi ngawa-yuwuni kangi awinyirra yimpalinya. ");
INSERT INTO tiw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Karri yirruwunari awuta Jews mimpa pirimi kapi Jerusalem pili awarra Ceremony ngini Feast of Dedication. ");
INSERT INTO tiw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ngarra awungarri ngawa-yuwuni Jesus awungarruwu kapi awarra yard kapi awinyirra jurra api yipangulimayi awungaji kapi awarra marlani (verandah) ngini wuta pirimamula (called) Solomon ngini-ngatawa marlani. ");
INSERT INTO tiw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kiyi yingampa awuta Jews mimpa pirimi kangi ngawa-yuwuni api pirimi kangatawa, “Parlingarri ngawa-rringani yipangiraga ngini ngarra wiyi yini-mata-ngirri (would send) awarra Christ kangi ngawa tayikuwapi kapi Jews. Ngini nginja awarra Christ api tulimiya (straight) tajiyarra ngawa,” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kiyi ngawa-yuwuni yimi ngini, “Ngiya waya ngurru-wutiyarra nuwa yingarti ngirramini ngini (about) ngiyalamiya api nuwa karluwu kuwa ngimpirimi ngini-ngilawa ngirramini. Ngiya-rringani yini-pangirri (sent) ngiya kapi nuwa arikutumunuwi amintiya ngarra yuwutiyarra ngiya ngini ngiya mirrikili (miracle) ngimata-kirimi. Api karri nuwa ngimpakuluwunyi awarra mirrikili ngini ngiya ngirikirimi api nuwa awungarri nginti-mata-majawu ngini ngiya-rringani yini-pangirri ngiya awungarra kapi nginaki murrakupuni (to this earth). ");
INSERT INTO tiw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Api nuwa karluwu kuwa ngimpirimi kangilawa pili nuwa karluwu ngimpiri-majawu ngiya,” yimi ngawa-yuwuni kapi awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kiyi yimi ngawa-yuwuni ngini, “Ngiya ngirimajawu awuta arikutumunuwi kapi ngiya-mamanta awuta. Wuta awuta wuri-pitingaya (hear) awarra ngirramini ngini ngiya ngipangiraga amintiya warntirrana kuwa wurimi awarra ngirramini ngini-ngilawa. ");
INSERT INTO tiw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","29","Awuta kapi wupapunya angilawa jarrumoka api ngiya wiyi ngirikirimi awuta ngini pimata-muwu yiloti kuriyuwu kapi ngiya-rringani amintiya wuta arnuka tuwanga pajuwani wurimi. Ngiya-rringani arikirimi awuta tiwi ngini wuta wupapunya angilawa jarrumoka. Ngarra warntirrana ngatawa api karri-kuwani ngarra ngatawa nginingaji awarra ngiya-rringani api karri-kuwapi wiyi mitaya wurimi kangi ngiya-rringani awuta tiwi kapi wupapunya angilawa jarrumoka amintiya wuta awanuwanga karluwu mitaya pimatami awuta tiwi kangiya. Karri jirti ngirramini (trouble) papi arimi kangi awuta tiwi kapi wupapunya angilawa jarrumoka api ngiya amintiya ngiya-rringani wiyi ngapamangi awuta. ");
INSERT INTO tiw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngiya amintiya ngiya-rringani ngawuni yati punyipunyi,” yimi ngawa-yuwuni kapi awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kiyi awuta Jews purruwunga yingarti waranguwi pili wuta purru-wutimarti ngini pimata-nyawu awinyirra waranguwi kapi ngawa-yuwuni ngini pajuwani pimata-kirimi ngarra. ");
INSERT INTO tiw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Api ngawa-yuwuni yimi kangi wutawa, “Pilikama nuwa ngimpitimarti ngini nginti-mata-nyawu waranguwi kangilawa? Ngiya waya ngirikirim-ani yingarti mirrikili (miracle) ngini pupuni pili ngiya-rringani yuwutiyarra ngiya ngini ngimata-kirimi awarra mirrikili api nuwa tayikuwapi waya nginti-pakuluwunyi awarra mirrikili ngini ngiya ngirikirimi. Api arramukuta nuwa ngimpirimi ngini yati mirrikili ngini ngiya ngirikirimi api jirti awarra api nuwa ngimpitimarti ngini nginti-mata-nyawu waranguwi kangilawa api nginuwani awarra mirrikili ngini nuwa ngimpirimi ngini awarra jirti?” yimi ngawa-yuwuni kangi awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Awuta Jews pirimi kangatawa, “Ngawa arnuka waranguwi ngamata-nyawu kanginjila pili awarra mirrikili ngini nginja jiyikirim-ani. Ngawa ngawutimarti ngini ngamata-nyawu waranguwi kanginjila pili nginja jirti nimarra nimpirimi karri nginja nimpirimi ngini nginja nginingaji ngawa-rringani. Api awarra arnuka warntirrana. Yita nginja tini nginingaji ngawa,” pirimi awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","36","Kiyi ngawa-yuwuni yimi kangi wutawa, “Parlingarri ngawa-rringani ngini kuriyuwu yimi kapi awuta alawuruwi kapi waki pirimi ngini (for) ngarra, ‘Nuwa kapi nuwa alawuruwi api nuwa nginingaji gods pili ngiya waya ngirikirimi nuwa nuwula api yingampa arikutumunuwi wurimamula (call) nuwa wuta-alawuruwi,’ yimi ngawa-rringani. Awarra ngirramini ngini ngawa-rringani yipangiraga parlingarri api yati tini yikirimi (wrote) awarra ngirramini kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament),” yimi ngawa-yuwuni kapi awuta Jews. Kiyi yimi ngini, “Awuta alawuruwi api wuta tiwi nginingaji nuwa api ngawa-rringani yimamula (called) awuta ‘gods’, awuta alawuruwi kapi ngarra parlingarri yuwuntiyarra wuta ngini waki pimatami ngini (for) ngarra. Awarra ngawa-rringani ngini-ngatawa ngirramini ngini awuta papaluwi parlingarri pirikirimi (wrote) kangi ngarra punkaringini api awarra ngirramini warntirrana amintiya ngawa karluwu nimarra ngamatami (shouldn't say) ngini awarra ngirramini arnuka warntirrana pili ngawa-rringani karluwu kunyani arimi,” yimi ngawa-yuwuni kapi awuta Jews. Kiyi yimi ngini, “Awarra warntirrana awarra ngirramini ngini ngawa-rringani parlingarri yipangiraga kapi awuta alawuruwi ngini wuta nginingaji gods api karri ngiya ngirimi ngini ngarra ngawa-rringani ngarra-mirani ngiya api kama nuwa ngimpirimi ngini awarra jirti ngirramini ngini ngiya ngipangiraga. Ngarra awarra ngawa-rringani parlingarri yipangiraga ngini ngarra wiyi yini-mata-ngirri ngiya awungarra kapi naki murrakupuni (to this earth) ngini waki ngimatami ngini (for) ngarra.” Awarra yimi ngawa-yuwuni kapi awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Kiyi ngawa-yuwuni yimi ngini, “Ngini ngiya karluwu waki ngirimi nginingaji ngiya-rringani waki arimi api ngajiti kuwa ngimpajami kangilawa. Api karri ngiya mirrikili (miracle) ngirikirimi api ngiya awungarri waki ngirimi nginingaji ngiya-rringani waki arimi. Ngiya ngirimajawu ngini nuwa karluwu kuwa ngimpirimi ngini-ngilawa ngirramini api kuwa nyirrami kangilawa pili awarra yingarti mirrikili ngini ngiya waya ngirikirimi. Kiyi karri nuwa ngimpiri-pungintayi (think about) awarra mirrikili ngini ngiya ngirikirimi api nuwa nginti-mata-majawu (should know) ngini ngiya-rringani arimuwu kangiya ruwuti amintiya ngini ngiya ngurumuwu kangi ngiya-rringani ngarra ruwuti.” Awarra yimi ngawa-yuwuni kapi awuta Jews. ");
INSERT INTO tiw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kiyi awuta Jews purru-wutimarti ngini tuwanga pimatanga ngawa-yuwuni api karluwu, pili ngarra yipumwari awuta kiyi yuwuriyi kapi nyoni murrakupuni. ");
INSERT INTO tiw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kiyi ngawa-yuwuni Jesus amintiya ngarra-mamanta pirripakupawurli maringarruwu kapi awinyirra makatinga Jordan kiyi purruwuriyi kapi awarra murrakupuni kapi awarra John the Baptist pakinya baptise yikirimi awuta tayikuwapi arikutumunuwi. Awungarruwu wuta kiyija purumuwu. ");
INSERT INTO tiw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kiyi tayikuwapi arikutumunuwi purruwuriyi awungarruwu kapi ngawa-yuwuni. Wuta nimarra pirimajirri, “Awarra John the Baptist karluwu yikirimi mirrikili (miracle) nginingaji awarra naki Jesus arikirimi mirrikili api pupuni awarra ngini ngarra yuwutiyarra ngawa yingarti ngirramini ngini (about) naki awarra Jesus amintiya tayikuwa-ni (all) awarra ngirramini waya warntirrana yima (became true),” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Api kiyi tayikuwapi arikutumunuwi kuwa pirimi kangi ngawa-yuwuni awungarruwu kapi awarra murrakupuni. ");
INSERT INTO tiw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Awungarruwu kapi awarra town Bethany api yati tini yimuwu ngini ngarra yintanga Lazarus. Awarra Lazarus api ngawa-yuwuni ngarra-mantani awarra. Awuta yuwurrara maminikuwi Mary amintiya Martha api wuta wutuwani awarra Lazarus. Awuta Mary amintiya Martha api wuta wiyarri purumuwu awungaji kapi Bethany. Kiyi jana yuwunyayi awarra Lazarus ");
INSERT INTO tiw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","api ngarra-yupi awuta Mary amintiya Martha pirripangirri (sent) yati tini kapi ngawa-yuwuni Jesus kapi ngarra yimuwu. Karri awarra tini papi yimi awungarruwu ngarra yuwutiyarra ngawa-yuwuni, yimi ngini, “Aya, mantani,” yimi. “Nginja-mantani ngini nginja puranji nimpirimuwu ngarra api ngarra waya jana yuwunyayi,” yimi awarra tini kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Karri ngawa-yuwuni yipitingaya (heard) awarra ngirramini (news) api yimi kangi ngarra-mamanta, “Ngarra nguri awarra ngiya-mantani Lazarus ngini waya jana yuwunyayi ngarra api ngarra wiyi yimpangini arima. Ngarra jana pili-ngini tayikuwapi arikutumunuwi wiyi pimata-majawu ngini ngiya amintiya ngiya-rringani ngawuni yingarti power api kiyi wuta wiyi awuta arikutumunuwi wuru-kuruwarni (thank) ngawa.” Awarra ngawa-yuwuni yimi kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","7","Ngawa-yuwuni puranji yimuwu Mary amintiya Martha amintiya wutuwani Lazarus api ngarra karluwu yuwuriyi kapi awarra Lazarus nanuwanga. Karri yirrara wumunga (days) jipapaya api ngarra yipangiraga kapi awuta ngarra-mamanta, yimi ngini, “Awi, ngawurniyi kapi awarra murrakupuni Judea,” yimi. Awarra Judea api awungarruwu awarra town Bethany kapi awarra Lazarus yimuwu. ");
INSERT INTO tiw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kiyi wuta pirimi kangatawa, “Yuwuni, pilikama nginja nimpitimarti ngini jimata-kupawurli awungarruwu kapi Judea pili nangunji awuta arikutumunuwi kapi awungarruwu wurumuwu api wuta purru-wutimarti ngini pimata-nyawu waranguwi kanginjila pili-ngini pajuwani pimata-kirimi nginja,” pirimi awuta ngarra-mamanta kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Kiyi ngawa-yuwuni yimi kangi wutawa, “Ngiya-rringani awutimarti ngiya ngini nanuwanga (still) waki ngimatami kapi awarra naki murrakupuni (on this earth) api awuta wawurruwi kapi wuta alawuruwi kapi Judea api wuta karluwu pajuwani pimata-kirimi ngiya nanuwanga. Ngiya nguwuja kapi Judea pili karri ngiya nanuwanga yimpangini api ngiya waki ngimatami (should work) ngini (for) ngiya-rringani. Waya juwa karri ngarra ngiya-rringani awutimarti ngini ngiya pajuwani ngimatami api awungarri wuta wiyi wuripirni ngiya.” Awarra yimi ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kiyi ngawa-yuwuni tuwanga yimi ngini, “Ngawa-mantani Lazarus ngarra awujingi-majirripi (sleeping) api ngiya waya nguwuja kangatawa kiyi wiyi ngipangipariyi (wake him up) awarra Lazarus,” yimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Api ngarra-mamanta pirimi kangatawa, “Ngini ngarra awujingi-majirripi api ngarra wiyi ngarralamiya apangipari kiyi ngarra wiyi pupuni arima,” pirimi ngawa-yuwuni ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ngawa-yuwuni mean yimi ngini awarra Lazarus ngarra pajuwani yimi api ngawa-yuwuni ngarra-mamanta karluwu pirimajawu awarra ngini ngawa-yuwuni yipangiraga. Wuta amparrimani pirrarimi ngini ngawa-yuwuni mean yimi ngini awarra Lazarus waya juwa yuwujingi-majirripani. ");
INSERT INTO tiw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Kiyi ngawa-yuwuni yipangiraga tulimiya (straight) kapi ngarra-mamanta, yimi ngini, “Lazarus ngarra waya pajuwani yimi. Ngiya kukunari ngirimi ngini ngiya arnuka awungarruwu kapi Bethany nangunji karri awarra Lazarus ngarra arikulani jana yuwunyayi pili nuwa wiyi ngimpakuluwunyi awarra mirrikili ngini ngiya wiyi ngirikirimi amintiya nuwa wiyi warntirrana kuwa ngimpirimi kangilawa. Api ngawurniyi kangatawa,” yimi ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Awarra Thomas ngini ngarra nyoni yintanga Didymus api karluwu kuwa yimi ngawa-yuwuni karri ngarra yimi ngini awungarruwu kapi Judea awuta Jews wiyi karluwu pajuwani pimata-kirimi ngarra nanuwanga api yimi kapi awuta yingampa ngawa-yuwuni ngarra-mamanta, “Awi, ngawa-yuwuni arrami wiyi pajuwani arimi awungarruwu kapi Judea api ngawa ngapapunya ngarra api ngawiyati wiyi pajuwani ngarimi,” yimi Thomas kapi awuta yingampa ngarra-mamanta. Kiyi ngawa-yuwuni amintiya ngarra-mamanta purruwuriyi kapi Bethany. ");
INSERT INTO tiw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Api karri wuta papi pirimi kapi Bethany api awuta arikutumunuwi purru-wuntiyarra awuta ngini awarra Lazarus ngini-ngatawa purnikapa waya yukurri wumunga (days) yipalamiya kapi cave. ");
INSERT INTO tiw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Awarra town Bethany yinkitayi kapi Jerusalem api tayikuwapi arikutumunuwi kapi wuta japuja pirimi awungarruwu kapi Jerusalem api purruwuriyi kapi Bethany api awuta arikutumunuwi wutiyati Mary amintiya Martha pirlikiti pirimi pili wutuwani Lazarus waya pajuwani yimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kiyi Mary amintiya Martha piri-pitingaya (heard) ngini ngawa-yuwuni waya yinu-wuja api kiyi awinyirra Martha juwuriyi kangatawa api nyirratuwu Mary juwanjipa japuja. ");
INSERT INTO tiw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Api karri Martha papi jiyimi kapi ngawa-yuwuni api jiyimi kangatawa, “Aya, yuwuni, pilikama nginja karluwu jinu-wuriyi awungarra karri ngiyuwani nanuwanga (still) yimpangini yimuwu. Ngini nginja awungarri nyimanu-wuriyi (if you had come) api ngarra karluwu pajuwani amarimi pili nginja pupuni nyimari-kirimi ngarra (would have made him better), ");
INSERT INTO tiw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","pili ngiya ngirimajawu ngini karri nginja nanginta nimpirimi ngawa-rringani ngini kuriyuwu ngini yimata-wani (help) nginja api ngarra wiyi aminyu-wani nginja,” jiyimi awinyirra Martha kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kiyi ngawa-yuwuni yimi kangi nyitawa, “Nginjuwani ngarra wiyi yimpangini arima,” yimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Api Martha jiyimi ngini, “Ngiya waya ngirimajawu ngini karri naki murrakupuni (earth) wiyi apapaya api ngawa tayikuwapi (all) kapi ngawa waya pajuwani ngintirimi api ngawa wiyi awungarri tuwanga yimpanguwi ngarima api ngarra wiyarri awarra ngiyuwani wiyi awungarri tuwanga yimpangini arima,” jiyimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Api ngawa-yuwuni yimi kangi nyitawa, “Ngiyatuwu awarra nginaki ngini ngirikirimi arikutumunuwi ngini tuwanga yimpanguwi wurima awuta arikutumunuwi kapi wuta waya pajuwani. Amintiya awuta arikutumunuwi kapi kuwa wurimi kangilawa api karri wuta pajuwani wurimi api wuta wiyi parlinginari tuwanga yimpanguwi wurima. Wuta awuta wiyi yimpanguwi wurumuwu yiloti. Wuta wiyi arnuka tuwanga pajuwani wurimi,” yimi ngawa-yuwuni kangi awinyirra Martha. Kiyi ngawa-yuwuni nanginta yimi awinyirra Martha, “Nginja kuwa nimpirimi awarra ngirramini ngini ngiya ngurru-wutiyarra nginj-ana?” Awarra ngawa-yuwuni nanginta yimi nyitawa. ");
INSERT INTO tiw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","28","Api Martha jiyimi ngini, “Kuwa, yuwuni, ngiya kuwa ngirimi awarra ngirramini amintiya ngiya kuwa ngirimi ngini nginja awarra Christ. Ngiya ngirimajawu ngini ngarra ngawa-rringani api ngarra-mirani nginja amintiya ngini parlingarri ngawa-rringani yipangiraga ngini ngarra wiyi yini-mata-ngirri (would send) nginja kapi nginingaji ngawula kapi awarra naki murrakupuni (on this earth),” jiyimi awinyirra Martha kangi ngawa-yuwuni. Kiyi ngawa-yuwuni yimi kapi awinyirra Martha, “Tajiyarra nginjupwaka ngini jini-matu-wariyi kangilawa.” Kiyi awinyirra Martha jipakupawurli kapi japuja kiyi nimarra jiyimi kapi nyirrupwaka wuta wangata api jiyimi kangi nyitawa, “Muwa-yuwuni Jesus api ngarra awutimarti ngini nimarra yimatami kanginjila,” jiyimi Martha kangi nyirrupwaka. ");
INSERT INTO tiw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Api karri Mary jiyipitingaya (heard) awarra ngirramini ngini Martha jipangiraga api nyirra yartipili jipumwari awuta arikutumunuwi kapi pirlikiti pirimi kangi nyirra kiyi juwuriyi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ngawa-yuwuni ngarra karluwu papi yimi kapi awarra town Bethany nanuwanga api ngarra yimuwu yinkitayi kapi awarra town. ");
INSERT INTO tiw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Karri awinyirra Mary jipumwari angi-nyitawa kurrampali api awuta arikutumunuwi amparrimani pirrarimi ngini nyirra juwuja kapi awarra cave kapi Lazarus ngini-ngatawa purnikapa yipalamiya pili-ngini pirlikiti jimatami awungaji api wuta pirripapunya awinyirra. ");
INSERT INTO tiw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Karri awinyirra Mary papi jiyimi kapi ngawa-yuwuni api nyirra juwunyaw-amiya kangi yakuluwuni yinkitayi kapi ngarra malapwara, kiyi jiyimi ngini, “Aya, yuwuni, ngini nginja nyimanu-wuriyi (if you had come) awungarra nangunji api ngiyuwani nanuwanga (still) yimpangini amarimuwu,” jiyimi awinyirra Mary kangi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Awinyirra Mary amintiya awuta yingampa arikutumunuwi kapi pirripapunya nyirra awungarruwu api wutiyati pirlikiti pirimi. Api ngawa-yuwuni putuputuwu yipakirayi awinyirra Mary amintiya awuta yingampa arikutumunuwi api ngarra jirti yimi kangi ngarra ruwuti. ");
INSERT INTO tiw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kiyi ngarra yimi kapi awuta, “Nuwa maka nginti-pamukuri ngiya-mantani ngini-ngatawa purnikapa?” yimi. Api wuta pirimi kangatawa, “Tayapunya ngawa kiyi tayakuluwunyi kapi ngarra purnikapa awujingi-mili,” pirimi. Api ngarra yipapunya awuta kapi awarra cave. ");
INSERT INTO tiw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kiyi ngawa-yuwuni pirlikiti yimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kiyi yingampa awuta arikutumunuwi nimarra pirimajirri, “Nginaki awarra Jesus warntirrana puranji yimuwu awarra Lazarus,” pirimi awuta yingampa arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Api wutatuwu yingampa awuta arikutumunuwi pirimi, “Ngarra waya yikirimi awuta yinkilatuwi ngini wuta tuwanga pirripakuluwunyi. Awanuwanga ngarra papurajuwi yikirimi awuta kapi wuta jana. Ngini ngarra amanu-wuriyi awungarra karri jana yuwunyayi Lazarus api ngarra pupuni amari-kirimi ngarra api awarra Lazarus nanuwanga (still) yimpangini amarimi (would be alive),” pirimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","39","Kiyi ngawa-yuwuni papi yimi kapi awarra cave kapi awarra Lazarus ngarra purnikapa yimili yilaruwu api ngarra tuwanga jirti yimi kangi ngarra ruwuti. Kapi awarra cave api arikulanga waranga angi wuta kunji pirikirimi awarra yangamini api ngawa-yuwuni yimi kangi awuta arikutumunuwi, “Nyirra-ngirri (push away) awinyirra waranga,” yimi. Api Martha jiyimi ngini, “Ngiyuwani ngini-ngatawa purnikapa waya yukurri wumunga (days) yipalamiya yilaruwu kapi naki cave api ngarra waya jirti aruwanti (smells bad),” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kiyi ngawa-yuwuni yimi kangi awinyirra Martha, “Ngiya waya ngurru-wutiyarra nginja, ‘Ngini nginja kuwa nimpirimi kangilawa api nginja wiyi nimpirimajawu ngini ngiya-rringani awuni (has) yingarti power.’” Awarra ngawa-yuwuni yimi kangi nyitawa. ");
INSERT INTO tiw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kiyi yingampa awuta arikutumunuwi pirripangirri (pushed away) awinyirra waranga kiyi ngawa-yuwuni yipakuluwunyi kuriyuwu kiyi yipangiraga kapi ngarra-rringani, yimi ngini, “Ngirringani ngiya nguru-kuruwarni (thank) nginja pili nginja waya jiyipitingaya (heard) awarra ngirramini ngini ngiya nanginta ngirimi nginja. ");
INSERT INTO tiw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Amintiya ngiya ngirimajawu ngini nginja yimpaja nimpiri-pitingaya (listen to) ngiya. Karri ngiya ninganara nguru-kuruwarni nginja api ngiya makirrana ngirripangiraga awarra ngirramini kanginjila pili-ngini kapinaki arikutumunuwi kapi awungarra wujingi-rriti (are standing) wiyi wurimajawu ngini nginja jini-pangirri (sent) ngiya kapi awungarra naki murrakupuni (to this earth),” yimi ngawa-yuwuni kangi ngarra-rringani ngini kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Karri ngawa-yuwuni yipapaya ngini nimarra yimi kapi ngarra-rringani ngini kuriyuwu api ngarra jingawu yimi makirrana, “Aya, Lazarus, papi tamuwa turruwuni,” yimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kiyi awarra Lazarus ngini ngarra pajuwani yimi api ngarra yimpangini yima kiyi ngarra papi yinirimi (came out) kapi awarra cave. Awinyirra manipurruwa (material) angi wuta pirikimirna kangi ngarra yikara amintiya kangi ngarra malapwara amintiya kangi ngarra yirrikilingapa amintiya kangi ngarra purnikapa api nanuwanga (still) jiyimuwu kangatawa awinyirra manipurruwa. Api ngawa-yuwuni yimi kangi awuta tiwi, “Tikimati nyirrami awinyirra manipurruwa pili-ngini ngarra pupuni wiyi yimata-ngulimayi,” yimi. Kiyi wuta tikimati pirimi awinyirra manipurruwa kiyi awarra Lazarus pupuni yipangulimayi. ");
INSERT INTO tiw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Awuta arikutumunuwi kapi punuwuriyi kapi Mary amintiya Martha japuja ngini wutiyati pirlikiti pirimi kapi Martha amintiya Mary api karri wuta pirripakuluwunyi ngawa-yuwuni Jesus ngini yimpangini yikirimi awarra Lazarus api tayikuwapi kuwa pirimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Api wutatuwu yingampa pirripakupawurli kapi Jerusalem api purruwuriyi kapi awuta Pharisees kiyi purru-wuntiyarra awuta ngini (about) awarra mirrikili (miracle) ngini ngawa-yuwuni yikirimi. ");
INSERT INTO tiw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Api kiyi awuta priests kapi wuta alawuruwi amintiya awuta Pharisees nanginta pirimi awuta yingampa alawuruwi ngini wutiyati mimpa pimatami awuta kapi wuta council. Karri wuta mimpa pirimi api nimarra pirimajirri, “Awungana ngawa ngamatama pili awarra nayi Jesus waya yikirim-ani yingarti mirrikili. ");
INSERT INTO tiw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Api ngini ngarra wiyi yimpaja arikirimi awarra mirrikili api tayikuwapi arikutumunuwi wuta wiyi kuwa wurimi kangatawa. Api kiyi awuta Roman alawuruwi wiyi wuni-pangirri (send) soldiers ngini pimata-martuwuni (knock down) angawula arikulanga jurra awungarra kapi Jerusalem amintiya ngini pimata-pirni ngawa tayikuwapi kapi Jews amintiya awuta Roman alawuruwi wiyi wurikirimi ngawa priests amintiya Pharisees ngini ngawa karluwu alawuruwi ngarimi kapi anaki jurra. Api ngawa awungana ngamatama?” pirimajirri awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Awarra awurrini ngini ngarra alawura kapi awuta yingampa priests kapi wuta alawuruwi api ngarra yintanga Caiaphas. Api ngarra awarra yimi kapi awuta yingampa alawuruwi, “Kayi, awarra pupuni ngini yati tini wiyi pajuwani arimi pili ngini (if) awarra tini karluwu pajuwani arimi api awuta Roman soldiers wiyi wuripirni ngawa tayikuwapi kapi Jews. Nuwa nginti-mata-majawu (should know) awarra.” Awarra Caiaphas yimi awarra kapi awuta yingampa alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Awarra ngirramini ngini awarra Caiaphas yipangiraga api awarra karluwu ngini-ngatawa ngirramini. Yita ngarra ngawa-rringani yipalami awarra ngirramini kangi awarra Caiaphas ngarra punyipunyi pili awarra Caiaphas awungarri alawura kapi awuta yingampa priests. Awarra ngirramini ngini awarra Caiaphas yipangiraga ngini yati tini pajuwani yimatami (should die) api ngarra mean yimi ngini ngawa-yuwuni pajuwani yimatami ngini (for) awuta tayikuwapi Jews. ");
INSERT INTO tiw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Api wuta karluwu wangata awuta kapi Jews pili ngarra wiyi awanuwanga pajuwani arimi ngini (for) tayikuwapi arikutumunuwi kapi nginingaji ngatawa murrakupuni (the whole world). Api awuta arikutumunuwi kapi wuta kuwa wurimi kangi ngawa-yuwuni api wuta awuta ngawa-rringani ngini kuriyuwu wiyi arimamula (call) awuta ngarra-mamirampi api wuta wiyi wutiyati punyipunyi wuni, awuta kapi Jews amintiya awuta kapi arnuka Jews. ");
INSERT INTO tiw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Karri awinyirra wumunga (day) karri awarra Caiaphas yuwuntiyarra awuta yingampa alawuruwi ngini ngawa-yuwuni Jesus pajuwani yimatami ngini awuta tayikuwapi Jews api awarra Caiaphas amintiya awuta yingampa alawuruwi nimarra pirimajirri ngini wuta awungana pimatama ngini pajuwani pimata-kirimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Karri ngawa-yuwuni yipitingaya (heard) ngini awuta alawuruwi purru-wutimarti ngini pajuwani pimata-kirimi ngarra api ngarra arnuka kularlaga yimi kapi turruwuni kapi awarra murrakupuni Judea. Api ngarra amintiya ngarra-mamanta purrupumwari Judea kiyi purruwuriyi kapi awarra kirijini murrakupuni Ephraim. Awarra murrakupuni yinkitayi kapi wulinjirriyanga (desert). Awungarruwu ngawa-yuwuni amintiya ngarra-mamanta purumuwu kiyija. ");
INSERT INTO tiw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kiyi karri waya yinkitayi awarra Passover Ceremony api awuta Jews waya yinkitayi ngini ready wurikirimi wutalamiya api tayikuwapi awuta Jews kapi japuja pirimi awungarruwu kapi yingarti murrakupuni api wuta purruwuriyi kapi Jerusalem kapi awarra ceremony. ");
INSERT INTO tiw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kiyi yingampa awuta Jews mimpa pirimi awungarruwu kapi turruwuni yinkitayi kapi angi-wutawa arikulanga jurra (temple) api wuta pirripakuluwunyi kangi jarrumoka ngini arrami ngawa-yuwuni awunu-wuja api wuta nanginta pirimajirri, “Maka awarra Jesus? Arrami ngarra wiyi arnuka yini-matu-wariyi kapi naki awarra Passover Ceremony,” wuta pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Awuta priests kapi wuta alawuruwi amintiya awuta Pharisees waya purru-wuntiyarra awuta arikutumunuwi, “Ngini nuwa ngimpiri-majawu ngini maka awarra Jesus arimuwu api nyirra-jiyarra ngawa pili-ngini ngawa ngamatanga ngarra,” pirimi awuta alawuruwi. ");
INSERT INTO tiw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ngawa-yuwuni Jesus amintiya awuta wamurrara yuwurrara (12) ngarra-mamanta nanuwanga (still) purruwuja kapi Jerusalem. Awungarruwu kapi Jerusalem wuta purru-wutimarti ngini pimata-kirimi awarra Passover Ceremony. Api nanuwanga (still) kiringarra wumunga (days) karri (until) wuta wiyi awarra Passover Ceremony wurikirimi. Awarra town Bethany kuluwuta api wuta pakinya papi pirimi awungarruwu. Ngarra Lazarus yimuwu awungaji awarra Lazarus ngini nangunji pajuwani yimi api ngawa-yuwuni yikirimi ngarra ngini tuwanga yimpangini yima. ");
INSERT INTO tiw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Awungarruwu kapi Bethany yingampa arikutumunuwi nanginta yimi ngawa-yuwuni ngini ngarra yimatapa yinkiti kangi wutawa kurrampali. Wuta awanuwanga nanginta pirimi awarra Lazarus amintiya yingampa arikutumunuwi ngini pini-matu-wariyi kapi wuta kurrampali pili-ngini wutiyati ngawa-yuwuni pimatapa awarra yinkiti. Karri ngawa-yuwuni amintiya awuta yingampa arikutumunuwi purruwuriyi kapi awinyirra kurrampali api wuta pirripawuriji yilaruwu kiyi purumuwu ngini pimatapa awarra yinkiti. Kiyi Lazarus ngarra-yupunga Martha jipakirayi awarra yinkiti kapi awarra ngawa-yuwuni amintiya awarra Lazarus amintiya awuta yingampa arikutumunuwi. ");
INSERT INTO tiw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kiyi awinyirra Mary angi Martha nyirrupwaka api nyirra juwunga pupuni oil ngini yuwanti pupuni (smelt good) kiyi nyirra jiyimarruriyi awarra oil kapi ngawa-yuwuni. Kiyi nyirra jipamutiyi (poured) awarra oil kapi ngarra malapwara amintiya juwunyirri (wiped) ngarra malapwara wutuliyi (with) ngini-nyitawa murrula pili nyirra juwuni (had) yurrukuni murrula. Api tayikuwapi awuta tiwi kapi purumuwu yilaruwu kapi awinyirra kurrampali wuta wurrinjila pirimi (smelt) awarra pupuni oil. ");
INSERT INTO tiw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kiyi yati ngawa-yuwuni ngarra-mantani, awarra Judas Iscariot api ngarra arnuka yuwutimarti awinyirra Mary ngini jimata-mutiyi awarra pupuni oil kangi ngarra malapwara ngawa-yuwuni. Ngarra awarra Judas ngini wiyi (later on) traitor yimi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Api ngarra yimi ngini, “Pilikama awinyirra Mary karluwu sellim jiyimi awarra oil. Nyirra sellim jimatami (should sell) awarra oil api jimatanga yingarti kunawuni api jimata-kirayi awarra kunawuni kapi awuta arikutumunuwi kapi wuni karri-kamini kunawuni. Yita nyirra waya juwunyawu yingarti kunawuni ngini awarra oil,” yimi awarra Judas. ");
INSERT INTO tiw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Karri awarra Judas yipangiraga awarra api ngarra kunyani yimi pili ngarra karluwu yuwutimarti ngini wuta pimata-kirayi awarra kunawuni kapi awuta arikutumunuwi kapi karri-kamini kunawuni pili ngarra yuwutimarti awarra kunawuni ngatamiya. Awarra Judas yipamang-ani awarra kunawuni ngini-wutawa ngawa-yuwuni amintiya ngarra-mamanta api ngarra arnuka warntirrana yipamang-ani ngini-wutawa kunawuni pili ngarra mitaya yimi kiyija kunawuni ngini ngatamiya. ");
INSERT INTO tiw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kiyi ngawa-yuwuni yimi kangi awarra Judas, “Ngajiti tongwayi nimpajami awinyirra Mary. Nginja nimpirimajawu ngini karri arikutumunuwi pajuwani wurimi api wuta-ngirimipi wupamutiyi (pour) pupuni oil kangi ngini-wutawa purnikapa api awinyirra Mary karri nyirra jipamutiyi nginaki pupuni oil kapi ngilawa malapwara api nyirra jiyipungintayi (thought about) ngiya ngini ngiya waya yinkitayi pajuwani ngirimi. Api pupuni awarra. ");
INSERT INTO tiw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yita awuta tayikuwapi arikutumunuwi kapi karri-kamini kunawuni api wiyi yiloti nuwiyati ngumpuru-muwu awungarra kapi nginaki murrakupuni (on this earth) api arrami nuwa wiyi ngumpuru-wani (help) awuta arikutumunuwi amintiya ngimpakirayi awuta kunawuni. Api ngiyatuwu karluwu awungarra yinukuni ngimata-muwu kapi nginaki murrakupuni,” yimi ngawa-yuwuni kapi awarra Judas. ");
INSERT INTO tiw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kiyi tayikuwapi awuta Jews piri-pitingaya (heard) ngini ngawa-yuwuni yuwujingi-muwani kapi awarra town Bethany kiyi wuta purruwuriyi awungarruwu pili purru-wutimarti ngini pimata-kuluwunyi ngawa-yuwuni. Wuta awanuwanga purru-wutimarti ngini pimata-kuluwunyi Lazarus pili wuta piri-pitingaya ngini ngarra nangunji pajuwani yimi amintiya ngini ngawa-yuwuni yikirimi awarra Lazarus ngini yipukularri api ngini tuwanga yimpangini yima. ");
INSERT INTO tiw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Tayikuwapi Jews pirripapunya ngawa-yuwuni angatawa jarrumoka pili ngarra yimpangini yikirimi awarra Lazarus api wuta purrupumwari awuta priests ngini-wutawa ngirramini, awuta priests kapi wuta alawuruwi. Api kiyi awuta priests kapi wuta alawuruwi purru-wutimarti ngini pajuwani pimata-kirimi ngawa-yuwuni api pirimajirri, “Awarra Lazarus awarra wiyarri pajuwani ngawurra-kirimi (we must kill) ngarra.” Awarra pirimajirri awuta priests. ");
INSERT INTO tiw_vpl VALUES ("JN13_1b","073_13_1b","JHN","13","1b","1b","Ngawa-yuwuni Jesus puranji yimuwu ngarra-mamanta awuta kapi wutiyati waki pirimi. Ngarra yimajawu ngini ngarra waya yinkitayi yimata-mwari (would leave) awungarra nginaki murrakupuni (this earth) api apakupawurli kuriyuwu kapi ngarra-rringani api ngarra yuwutimarti awuta ngarra-mamanta ngini pimata-majawu ngini ngarra warntirrana puranji yimuwu awuta. ");
INSERT INTO tiw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ngawa-yuwuni awanuwanga yimajawu ngini ngarra-rringani waya yipakirayi ngarra yingarti power. Awanuwanga yimajawu ngini awarra ngarra-rringani yini-pangirri (sent) ngarra kapi awungarra nginaki murrakupuni (to this earth) amintiya ngini ngarra wiyi apakupawurli kapi kuriyuwu. ");
INSERT INTO tiw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Api ngarra karluwu ngawa-yuwuni yimamuliya ngarra ngatawa api karri ngarra amintiya ngarra-mamanta nanuwanga (still) purru-wujing-apukani yinkiti api ngarra kutupi yimi kiyi tikimati yimi angatawa yurruka kuluji angi mura jiyimuwu (outside clothes) kiyi yikimirna (wrapped around) yurruka towel kangatamiya. ");
INSERT INTO tiw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kiyi yuwunga kukuni api yipamutiyi (poured) awarra kukuni kapi wurika (dish). Kiyi mwarliki yikirimi awuta ngarra-mamanta ngini-wutawa malapwara. Kiyi yuwunga awinyirra towel api yuwunyirri (wiped) wuta malapwara. ");
INSERT INTO tiw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kiyi karri ngawa-yuwuni waya yinkitayi mwarliki yikirimi Simon Peter ngini-ngatawa malapwara api ngarra Simon Peter nanginta yimi ngawa-yuwuni, “Niyi nginja mwarliki nimpirikirimi ngini-ngilawa malapwar-ana? Nayi kama pili ngiya-alawura nginja,” yimi awarra Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Api ngawa-yuwuni yimi ngini, “Nginja karluwu nimpirimajawu (don't understand) naki ngini (that) ngiya mwarliki ngirikirimi ngini-nginjila malapwara api nginja wiyi parlinginari (later) nimpirimajawu,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Awarra Simon Peter karluwu yuwutimarti ngawa-yuwuni ngini mwarliki yimata-kirimi ngini-ngatawa malapwara api yimi kapi ngawa-yuwuni, “Ngajiti awungani nimpajami.” Kiyi ngawa-yuwuni yimi ngini, “Ngini ngiya karluwu mwarliki ngirikirimi ngini-nginjila malapwara ngiya karluwu wiyi ngiya-mantani nginja.” ");
INSERT INTO tiw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Api Simon Peter yimi ngini, “Manya awarra. Mwarliki takirimi ngini-ngilawa kintanga amintiya yikara kiyi pungintaga awanuwanga mwarliki takirimi,” yimi Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kiyi ngawa-yuwuni yimi kapi awuta ngarra-mamanta, “Karri ngawa mwarliki ngarimi api karri-kamini parruwarti kangi ngawula purnikapa. Waya juwa karri ngawa ngapangulimayi kapi jarrumoka api awungarri ngini-ngawula malapwara parruwarti-la arimi. Amintiya karri pakinya nuwa ruwuti nginingaji parruwarti-la yimi pili nuwa awungarri jajiruwi. Api ngawa-rringani waya pupuwi yikirimi nuwa. Waya juwa yati tini kangi nuwa api ngarra jirti awarra,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ngarra yimi ngini yati ngarra-mantani jirti pili ngarra yimajawu ngini awarra ngarra-mantani wiyi traitor arimi kangatawa. ");
INSERT INTO tiw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kiyi karri ngawa-yuwuni waya yipapaya ngini mwarliki yikirimi ngarra-mamanta ngini-wutawa malapwara api yikuripiya (put on) angatawa yurruka kuluji api yipakupawurli kapi ngarra pakinya yimuwu. Kiyi yimi kangi wutawa, “Arrami nuwa nimarra ngimpirimi nuwulamiya ngini, ‘Kama arrami ngarra mwarliki yikirimi ngini-ngawula malapwara?’ Arrami nuwa awarra nimarra nuwulamiya. Arnapa. Ngiya pakinya nguwutiyarra nuwa naki ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nuwa ngimpirimi ngini ngiya ngini-nuwula alawura amintiya ngini ngiya nguruwaluwa (teach) nuwa. Awarra pupuni ngini nuwa awarra ngimpiri-mamula ngiya pili ngiya warntirrana awarra. ");
INSERT INTO tiw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Awuta arikutumunuwi kapi wuta alawuruwi kapi awarra murrakupuni (on this earth) api wuta karluwu mwarliki wurikirimi ngini-nuwula malapwara api ngiya karluwu nginingaji awuta alawuruwi pili ngiya mwarliki ngirikirimi ngini-nuwula malapwara, ngiya awarra nuwa-alawura, api nuwa mwarliki nyirra-kirim-ajirri ngini-nuwula malapwara. ");
INSERT INTO tiw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngiya mwarliki ngirikirimi ngini-nuwula malapwara api nuwa wiyi nyirrami nginingaji ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kiyi ngawa-yuwuni yimi ngini, “Awarra naki ngirramini warntirrana. Awarra tini ngini awutiyarra nyoni tini kuta kamini ngirramini api kiyi apangirri (sends) awarra nyoni tini ngini yimata-jiyarra (to tell) yingampa tiwi awarra ngirramini api naki nyoni tini ngarra karluwu ngatawa. Ngarra awarra ngini pakinya tini ngini yipangirri (sent) awarra nyoni tini api ngarra wangata ngatawa. Amintiya awarra ngini alawura api ngarra awarra ngatawa. Api ngarratuwu awarra tini ngini waki arimi ngini (for) awarra alawura api ngarra karluwu ngatawa. Api nuwa ngajiti ngimpaja-mamuliya nuwa nuwula pili nuwa waki ngimpirimi ngini (for) ngiya api nuwa-alawura ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kiyi yimi ngawa-yuwuni ngini, “Awarra naki ngirramini ngini ngiya ngurru-wutiyarra nuwa api nuwa waya ngimpiri-majawu (understand) awarra ngirramini api ngini nuwa kuwa ngimpirimi awarra ngini-ngilawa ngirramini api nuwa wiyi kukunari ngimpirimi. ");
INSERT INTO tiw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nuwa karluwu tayikuwapi wiyi kukunari pili yati kapi nuwa karluwu kuwa arimi ngini-ngilawa ngirramini. Tani-waya (no matter) ngiya ngurru-wunga (picked) nuwa tayikuwapi ngiya-mamanta pili-ngini nuwa waki nginti-matami ngawiyati api yati kapi nuwa ngini ngawa ngaruwarti (share) yinkiti api ngarra wiyi traitor arimi kapi ngiya. Wuta parlingarri pirikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) awarra ngirramini ngini awarra ngawa-mantani wiyi traitor arimi kangiya api waya awarra rayiti ngini ngarra wiyi traitor arimi kangilawa pili awarra ngirramini ngini wuta pirikirimi (wrote) kangi awarra punkaringini api awarra ngirramini wiyi warntirrana awurrama (must come true).” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kiyi ngawa-yuwuni yimi ngini, “Ngiya waya ngurru-wutiyarra nuwa awarra ngirramini ngini wuta parlingarri pirikirimi (wrote) kangi awarra punkaringini awarra ngirramini ngini (about) awarra traitor pili ngiya nguwutimarti ngini karri ngarra wiyi traitor arimi kangi ngiya api nuwa wiyi awungarri nginti-mata-majawu ngini ngiya awarra ngini ngarra ngawa-rringani yini-pangirri (sent) kapi nuwa arikutumunuwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kiyi ngarra ngawa-yuwuni yimi kapi awuta ngarra-mamanta nginaki nyoni ngirramini, “Naki awarra ngirramini warntirrana ngini karri ngiya ngipangirri (send) nuwa kapi awuta arikutumunuwi ngini nginti-mata-jiyarra awuta ngini-ngilawa ngirramini api yingampa tiwi wiyi kuwa wurimi awarra ngini-ngilawa ngirramini. Wuta awuta tiwi wiyi wurimamula (call) nuwa wuta-mantawi amintiya wiyi awanuwanga wurimamula ngiya wuta-mantani pili ngiya ngirripangirri (sent) nuwa kapi wutawa. Amintiya wuta awanuwanga wiyi wurimamula (call) wuta-mantani ngiya-rringani pili ngarra yini-pangirri ngiya kapi nuwa arikutumunuwi.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kiyi ngawa-yuwuni karri yipapaya awarra ngini nimarra yimi kapi awuta ngarra-mamanta api ngarra naki nyoni ngirramini yipangiraga kangi wutawa, “Awarra naki warntirrana ngirramini ngini yati kapi nuwa wiyi traitor arimi kangiya.” Karri ngawa-yuwuni awarra yipangiraga api awungarri jirti yimi kangi ngarra punyipunyi amintiya ruwuti. ");
INSERT INTO tiw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kiyi ngawa-yuwuni ngarra-mamanta pirripakuluwuny-ajirri api pirimajirri, “Kuwani awarra tini kapi ngawa ngini (who) wiyi traitor arimi kapi ngawa-yuwuni?” ");
INSERT INTO tiw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Kiyi awarra Simon Peter sign yikirimi kapi awarra John. Awarra John yuwujingi-muwani yinkitayi kapi ngawa-yuwuni api Simon Peter mamana yipangiraga kangatawa, “Aya, nanginta tami awarra ngawa-yuwuni ngini kuwani awarra tini?” Awarra Simon Peter yimi awarra kapi John. ");
INSERT INTO tiw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Api kiyi awarra John wurliyi yimi (bent) yinkitayi kapi ngawa-yuwuni api ngarra yimi mamana kangatawa, “Aya, mantani,” yimi. “Kuwani awarra tini ngini wiyi traitor arimi kapi nginja?” ");
INSERT INTO tiw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Api ngawa-yuwuni yimi ngini, “Karri ngiya ngipalami naki purnikapa kapi naki alaga api ngiya wiyi ngipakirayi awarra purnikapa kapi awarra tini.” Api kiyi yuwunga awarra purnikapa api yipalami awarra kapi awarra alaga api kiyi yipakirayi awarra kapi awarra Judas Iscariot awarra Judas ngini ngarra-rringani Simon Iscariot. ");
INSERT INTO tiw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Karri awarra Judas Iscariot yuwunga awarra purnikapa api ngarra awungarri maputiti tuwanga yipawuriji yilaruwu kangatawa purnikapa. Api kiyi ngawa-yuwuni yimi kapi awarra Judas, “Awarra naki ngini nginja ninganara nimpirikirimi (do) api yartipili takirimi (do) awarra,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","30","Api awarra Judas yartipili papi yimi kapi turruwuni. Waya awungarri yartijanga. Awuta yingampa ngawa-yuwuni ngarra-mamanta kapi wutiyati ngawa-yuwuni purru-wujing-apukani yinkiti api pirimajirri ngini, “Pilikama ngawa-yuwuni awungani (that way) yipangiraga kapi awarra ngawa-mantani Judas?” pirimi awuta ngarra-mamanta. Awarra Judas yipamangi ngawa-yuwuni amintiya ngarra-mamanta kunawuni api awuta yingampa ngarra-mamanta pirimajirri, “Arramukuta ngawa-yuwuni awutimarti awarra ngawa-mantani Judas ngini yimatanga (buy) yinkiti. Arrami ngarra awutimarti ngarra ngini yimata-kirayi kunawuni kapi awuta tiwi kapi wuta karluwu wuni kunawuni amintiya yinkiti,” pirimajirri. ");
INSERT INTO tiw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kiyi ngawa-yuwuni Jesus yimi kapi awuta yingampa ngarra-mamanta, “Nuwa waya ngimpiri-majawu ngini ngiya nuwa-yuwuni nuwa tayikuwapi arikutumunuwi. Nuwa awuta arikutumunuwi pangarri-nara ngimpakuluwunyi ngiya ngini ngiya yingarti power nguwuni amintiya nuwa wiyi awungarri ngumpuru-kuruwarni (thank) ngiya-rringani pili ngarra wiyarri awuni (has) yingarti power. ");
INSERT INTO tiw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Amintiya ngarra ngiya-rringani apakirayi awarra power kangilawa.” Ngarra ngawa-yuwuni awarra yipangiraga kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kiyi ngawa-yuwuni yipangiraga kapi awuta ngarra-mamanta nginaki nyoni ngirramini, “Awi, mamirampi,” yimi. “Ngiya wiyi pangarri-nara (soon) ngupumwari nuwa. Nuwa wiyi kularlaga ngimpirimi ngiya api nuwa karluwu nginti-mata-punya (can't follow) ngiya awungarruwu kapi ngiya wiyi ngumpuriyi. Ngiya waya awarra ngirramini awanuwanga ngurru-wuntiyarra awuta Jews kapi wuta alawuruwi,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kiyi ngawa-yuwuni yimi kapi awuta ngarra-mamanta, “Naki awarra ngirramini (law) awurankini ngini nuwa ngiya-mamanta puranji nyirra-muwajirri nginingaji ngiya puranji ngurumuwu nuwa.” Ngarra awarra ngawa-yuwuni yipangiraga kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kiyi yimi ngini, “Ngini nuwa puranji ngumpuru-muwajirri api kapinayi yingampa karri wupakuluwunyi nuwa ngini pupuwi ngumpuru-muwajirri api wuta wiyi wurimajawu ngini nuwa ngimpapunya angilawa jarrumoka.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kiyi Simon Peter nimarra yimi kapi ngawa-yuwuni Jesus awarra ngini yimamula (called) ngarra-alawura api “Aya,” yimi. “Nginja jiyimi ngini nginja pangarri-nara (soon) nimpumwari ngawa api maka nimpija?” Api ngawa-yuwuni yimi ngini, “Kapi ngiya wiyi ngumpuriyi api awungarruwu nginja wiyi karluwu pangarri-nara jimata-punya ngiya. Wiyi parlinginari (later) nginja nimpapunya ngiya,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Api Peter yimi ngini, “Pilikama awarra jipangiraga ngini ngiya karluwu ngipapunya nginja karri nginja pangarri-nara nimpuriyi pili ngiya puranji ngurumuwu nginja amintiya ngini wuta wutimarti ngini pajuwani pimata-kirimi nginja api ngiya wiyi ngirimi kangi wutawa ngini, ‘Ngajiti pajuwani ngimpaja-kirimi ngiya-mantani. Nyirra-kirimi ngiya pajuwani.’” Ngarra awarra Peter yimi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Api ngawa-yuwuni yimi kapi awarra Peter, “Nginja manya nimpirimi ngini nginja wiyi pajuwani nimpirimi ngini (for) ngiya. Yita karri karluwu nanuwanga kakululuwu (rooster) jingawu arimi japinari-nara api nginja wiyi nimpuntiyarra awuta tiwi yirrajirrima times ngini nginja karluwu nimpirimajawu ngiya. Ngarra awarra warntirrana. Ngiya karluwu kunyani ngipangiraga,” yimi ngawa-yuwuni kapi awarra Peter. ");
INSERT INTO tiw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kiyi ngawa-yuwuni Jesus yimi kapi ngarra-mamanta, “Ngiya waya ngurru-wutiyarra nuwa ngini ngiya waya yinkitayi ngupumwari nuwa api nuwa ngajiti worry ngimpajami. Waya juwa kuwa nyirrami kangi ngawa-rringani amintiya awanuwanga kuwa nyirrami kangi ngiya. ");
INSERT INTO tiw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Awungarruwu kapi ngiya-rringani japuja api yingarti rooms api ngiya wiyi ngumpuriyi awungarruwu api ready ngirikirimi awinyirra rooms angi nuwa wiyi japuja ngimpiri-kirimi awungaji. Awarra warntirrana. Ngiya karluwu kunyani ngipangiraga. ");
INSERT INTO tiw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Api karri ngiya waya ready ngirikirimi angi-nuwula rooms api ngiya awungarri nguwuni-pakupawurli (come back) kangi nuwa api ngirimarruriyi nuwa kuriyuwu kapi ngiya amintiya ngiya-rringani japuja pili ngiya nguwutimarti ngini ngawiyati wiyi ngamata-muwu awungarruwu,” yimi ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kiyi ngawa-yuwuni yimi ngini, “Nuwa ngimpiri-majawu awinyirra jarrumoka angi ampuriyi awungarruwu kuriyuwu kapi ngiya wiyi ngumpuriyi.” Ngarra awarra ngawa-yuwuni yipangiraga kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kiyi Thomas yimi kangi ngawa-yuwuni, “Ngawa karluwu ngarimajawu awarra murrakupuni kapi nginja nimpija api kama nginja jiyimi ngini ngawa ngarimajawu awinyirra jarrumoka angi ampija awungarruwu kapi awarra murrakupuni.” Ngarra awarra Thomas yimi. ");
INSERT INTO tiw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Api ngawa-yuwuni yimi kapi ngarra-mamanta, “Nuwa wiyi ngimpapunya ngiya nginingaji nuwa ngimpapunya jarrumoka. Karri nuwa ngumpuriyi kuta maka kapi naki murrakupuni (on this earth), api nuwa ngimpapunya jarrumoka. Api ngini nuwa ngimpitimarti ngini wiyi nginti-matu-wariyi kapi ngiya-rringani ngini kuriyuwu api nuwa nginti-mata-punya (should follow) ngiya pakinya. Ngiya warntirrana nguwutiyarra nuwa awarra ngirramini ngini (about) ngiya-rringani api nuwa kapi ngumpunu-wuriyi kangiya amintiya kuwa ngimpirimi ngiya api nuwa wiyi warntirrana ngimpiri-majawu (understand) ngiya-rringani ngini-ngatawa ngirramini. Nuwa awuta wiyi yiloti tangarima awungarruwu kapi ngiya-rringani nuwa awuta kapi kuwa ngimpirimi ngiya. Api awuta tiwi kapi karluwu kuwa wurimi ngiya api wuta wiyi karluwu pimatu-wariyi kuriyuwu kapi ngiya-rringani japuja.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kiyi ngawa-yuwuni yimi ngini, “Karri pakinya nuwa karluwu warntirrana ngintiri-majawu (didn't know) ngiya api nuwa karluwu awanuwanga ngintiri-majawu ngiya-rringani. Api waya ningani nuwa ngimpiri-majawu awarra ngiya-rringani pili ngiya nginingaji awarra ngiya-rringani pili ngawiyati ngarikirimi pupuni (do good things). Nuwa ngimpakuluwunyi ngiya api awarra nginingaji nuwa ngimpakuluwunyi awarra ngiya-rringani.” Ngarra ngawa-yuwuni yipangiraga awarra kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kiyi Philip nimarra yimi kapi ngawa-yuwuni api yimi kangatawa, “Ngawa ngawutimarti ngini ngamata-kuluwunyi ngawa-rringani ngini-ngatawa yirrikilingapa api tamarruripa nginja-rringani awungarra. Api karri ngawa ngapakuluwunyi ngini-ngatawa yirrikilingapa api ngawa karluwu tuwanga nanginta ngamatami (won't ask) nginja.” Ngarra Philip awarra yipangiraga. ");
INSERT INTO tiw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Api ngawa-yuwuni yimi kapi awarra Philip, “Pilikama awarra jipangiraga pili nuwa amintiya ngiya ngawiyati waya yinukuni ngunturu-muwu api nginja jimata-majawu (should know) ngini kapi nuwa ngimpakuluwunyi ngiya api awarra nginingaji nuwa ngimpakuluwunyi ngiya-rringani,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kiyi yimi ngawa-yuwuni kapi awarra Philip, “Arramukuta nginja karluwu kuwa nimpirimi ngini ngiya ngurumuwu kangi ngiya-rringani ruwuti amintiya ngini ngarra ngiya-rringani arimuwu kangi ngiya ruwuti. Awarra naki ngirramini ngini ngiya ngipangiraga api karluwu awarra ngini-ngilawa ngirramini. Yita ngarra ngiya-rringani yimintiyarra ngiya awarra ngirramini ngini ngiya nimarra ngirimi. Arrami nuwa ngimpirimi ngini, ‘Awarra ngawa-yuwuni warntirrana waki arimi.’ Arrami nuwa awarra ngimpirimi api ngiya karluwu ngirikirimi awarra waki (do that work). Yita awarra ngiya-rringani ngini arimuwu kapi ngiya ruwuti api ngarra awarra ngini arikirimi awarra waki. Ngarra apakirayi ngiya power ngini waki ngirimi ngini (for) ngarra.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awarra Philip. ");
INSERT INTO tiw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Nuwa kuwa nyirrami awarra ngirramini ngini ngiya ngurru-wutiyarra nuwa awarra ngirramini ngini ngiya ngurumuwu kangi ngiya-rringani ruwuti amintiya ngini ngarra ngiya-rringani arimuwu kangi ngiya ruwuti. Api ngini nuwa karluwu kuwa ngimpirimi awarra ngirramini api nyirra-pungintayi (think about) awarra mirrikili (miracle) ngini ngiya waya ngirikirim-ani api kiyi nuwa wiyi kuwa ngimpirimi awarra ngirramini ngini ngiya ngirripangiraga ngini ngiya ngurumuwu kangi ngiya-rringani ruwuti amintiya ngini ngarra ngiya-rringani arimuwu kangi ngiya ruwuti.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kiyi ngawa-yuwuni nyoni nginaki nimarra yimi, “Naki awarra warntirrana ngini nuwa tiwi kapi warntirrana kuwa ngimpirimi ngiya api nuwa awuta wiyi waki ngimpirimi ngini (for) ngawa-rringani nginingaji ngiya waki ngirimi ngini ngarra. Nuwa awuta tiwi wiyi warntirrana waki ngimpirimi ngini ngawa-rringani pili ngiya wiyi ngumpuriyi kuriyuwu kapi ngiya-rringani api wiyi nguwuni-pangirri (send) ngini-ngatawa pukwiyi (Holy Spirit) kapi nuwa ngini ngarra yimata-wani (to help) nuwa. Ngarra wiyi awarra pukwiyi apakirayi nuwa yingarti power.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Kiyi ngawa-yuwuni yimi ngini, “Karri ngiya wiyi kuriyuwu kapi ngiya-rringani api nuwa kapi kuwa ngimpirimi ngiya api ngini nuwa nanginta ngimpirimi ngiya kuta kamini awarra ngini nuwa ngimpitimarti (need) api ngiya wiyi ngipakirayi nuwa awarra kuta kamini amintiya ngiya wiyi awanuwanga nguru-wani (help) nuwa pili ngiya nguwutimarti nuwa ngini nginti-mata-majawu ngini ngarra ngiya-rringani awuni (has) yingarti power.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kiyi ngawa-yuwuni Jesus nimarra yimi nginaki nyoni ngirramini kapi awuta ngarra-mamanta, “Kapi nuwa warntirrana puranji ngumpuru-muwu ngiya api nuwa wiyi kuwa ngimpirimi ngini-ngilawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Kiyi ngiya wiyi nanginta ngirimi ngiya-rringani ngini wiyi awuni-pangirri (send) kangi nuwa ngini-ngatawa pukwiyi (Holy Spirit) api ngarra wiyi yiloti arimuwu kangi nuwula ruwuti. Ngarra wiyi awarra pukwiyi amanu-wani (help) nuwa nginingaji ngiya waya nguru-wani nuwa amintiya ngarra wiyi warntirrana awunu-waluwa (teach) nuwa ngini-ngilawa ngirramini,” yimi ngawa-yuwuni. Kiyi yimi ngini, “Awuta tiwi kapi karluwu kuwa wurimi ngini-ngilawa ngirramini api wuta awuta karluwu nanginta pimatami (can't ask) awarra pukwiyi (Holy Spirit) ngini yimata-wani (help) awuta pili wuta karluwu wurimajawu ngini (about) awarra pukwiyi. Api nuwa ngimpiri-majawu awarra pukwiyi pili ngarra ningani arimuwu yinkitayi kangi nuwula amintiya wiyi arimuwu kangi nuwula ruwuti.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kiyi ngawa-yuwuni nimarra yimi nginaki nyoni ngirramini kapi awuta ngarra-mamanta, “Karri ngiya wiyi ngumpuriyi api nuwa wiyi karluwu wangatamiya nginti-mata-muwu yinukuni pili ngiya wiyi nguwuni-pakupawurli (come back) kangi nuwula.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kiyi yimi ngawa-yuwuni, “Karri ngiya wiyi ngumpuriyi api awuta tiwi kapi karluwu kuwa wurimi ngiya api wuta awuta karluwu tuwanga wupakuluwunyi ngiya. Waya juwa nuwa kapi ngiya-mamanta nuwa wiyi ngimpakuluwunyi ngiya. Ngiya wiyi pajuwani ngirimi api ngiya wiyi ngupukularri api tuwanga yimpangini ngirimi amintiya wiyi yiloti ngurumuwu api nuwa wiyarri wiyi yiloti ngumpuru-muwu kuriyuwu. Kapi ngiya amintiya ngiya-rringani nuwa wiyi awungaji ngumpuru-muwu.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kiyi yimi ngini, “Karri ngiya wiyi ngupukularri api tuwanga yimpangini api awungarri nuwa wiyi ngimpiri-majawu ngini ngiya ngurumuwu kangi ngiya-rringani ruwuti amintiya ngini nuwa awanuwanga ngumpuru-muwu kangi ngiya ruwuti amintiya ngini ngiya awanuwanga ngurumuwu kangi nuwa ruwuti.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kiyi ngawa-yuwuni nyoni nginaki nimarra yimi, “Nuwa arikutumunuwi kapi nuwa puranji ngumpuru-muwu ngiya api nuwa awuta ngimpiri-pungintayi (think about) ngini-ngilawa ngirramini amintiya kuwa ngimpirimi ngiya. Amintiya nuwa awuta kapi puranji ngumpuru-muwu ngiya api ngarra ngiya-rringani wiyi puranji arimuwu nuwa. Amintiya ngiya awanuwanga wiyi puranji ngurumuwu nuwa amintiya wiyi nguwunu-wuriyi kangi nuwula api wiyi nguwujiyarra nuwa tayikuwa-ni (all) awarra ngirramini ngini (about) ngiya api kiyi nuwa wiyi warntirrana ngimpiri-majawu ngini (about) ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kiyi Judas nimarra yimi kangi ngawa-yuwuni. Karluwu Judas Iscariot. Yita nyoni Judas awarra. Api yimi awarra Judas, “Nginja jiyimi ngini ngawa kapi kuwa ngarimi nginja api nginja wiyi nimpunu-wuriyi kangawula amintiya jiyimi ngini nginja wiyi nimputiyarra ngawa tayikuwa-ni (all) awarra ngirramini ngini (about) nginja api kiyi ngawa wiyi warntirrana ngimpiri-majawu ngini (about) nginja. Amintiya nginja jiyimi ngini nginja wiyi karluwu jimatu-wariyi kapi awuta tiwi kapi karluwu kuwa wurimi nginja amintiya ngini nginja wiyi karluwu jimata-jiyarra awuta tiwi awarra ngirramini ngini (about) nginja. Api kama nginja awarra jipangiraga?” yimi awarra Judas kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Api ngawa-yuwuni yimi ngini, “Nuwa wangata kapi puranji ngumpuru-muwu ngiya api ngiya amintiya ngiya-rringani wiyi ngawuriyi kapi nuwa arikutumunuwi amintiya ngawa japuja ngarikirimi ngawiyati. Amintiya ngiya-rringani wiyi puranji arimuwu nuwa. Kapi nuwa puranji ngumpuru-muwu ngiya api nuwa wiyi kuwa ngimpirimi ngini-ngilawa ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Api awuta tiwi kapi karluwu puranji wurumuwu ngiya api wuta awuta wiyi karluwu kuwa pimatami ngini-ngilawa ngirramini.” Ngarra awarra yipangiraga ngawa-yuwuni. Kiyi yimi ngini, “Awarra ngirramini ngini ngiya ngurru-wutiyarra nuwa api ngarra arnuka ngini-ngilawa ngirramini awarra. Yita ngarra ngiya-rringani yimintiyarra ngiya awarra ngirramini. Awarra ngiya-rringani yini-pangirri (sent) ngiya kapi nuwa,” yimi ngawa-yuwuni kapi awarra nyoni Judas. ");
INSERT INTO tiw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kiyi ngawa-yuwuni yimi kapi ngarra-mamanta, “Awarra nayi yingarti ngirramini api ngiya awarra ngurru-wutiyarra nuwa karri ngiya nanuwanga (still) ngurumuwu kangi awarra naki murrakupuni (on this earth). ");
INSERT INTO tiw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Api karri ngiya wiyi ngumpuriyi kuriyuwu kapi ngiya-rringani api ngiya wiyi nanginta ngirimi awarra ngiya-rringani ngini yini-mata-ngirri (to send) ngini-ngatawa pukwiyi (Holy Spirit) kangi nuwula. Ngarra wiyi awarra pukwiyi awutiyarra nuwa yingarti ngirramini amintiya wiyi awanuwanga tuwanga awutiyarra nuwa tayikuwa-ni (all) awarra ngirramini ngini ngiya ngurru-wutiyarra nuwa api nuwa wiyi karluwu nginti-mata-ngiliparra awarra ngirramini ngini ngiya ngurru-wutiyarra nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. Kiyi yimi ngini, “Ngarra wiyi awarra pukwiyi (Holy Spirit) amanu-wani (help) nuwa.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kiyi nyoni nginaki ngirramini yimi ngawa-yuwuni kapi awuta ngarra-mamanta, “Ngiya waya yinkitayi ngupumwari nuwa api ngiya wiyi ngirikirimi nuwa ngini pupuni ngimpirimi kangi nuwa punyipunyi amintiya ruwuti, api nuwa wiyi karluwu ngimpiri-makirri amintiya ngini karluwu worry ngimpirimi. Nuwa-mamanta karluwu pimata-kirimi (can't make) nuwa ngini pupuni ngimpirimi kangi nuwa punyipunyi amintiya ruwuti. Waya juwa ngiya. Api ngajiti worry ngimpaja-ma amintiya ngajiti ngimpaja-wanga.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kiyi ngawa-yuwuni yipangiraga awarra naki nyoni ngirramini kapi awuta ngarra-mamanta, “Ngiya waya ngurru-wutiyarra nuwa ngini ngiya wiyi ngumpuriyi kapi ngiya-rringani amintiya ngini ngiya wiyi nguwuni-pakupawurli (come back) kangi nuwa. Api ngini nuwa puranji ngumpuru-muwu ngiya api nuwa wiyi kukunari nginti-matami (should be happy) ngini (that) ngiya wiyi ngumpuriyi kapi ngiya-rringani pili awarra ngiya-rringani ngarra ngatawa. Tani ngiya karlu-nara.” Ngarra awarra yipangiraga ngawa-yuwuni kapi awuta ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kiyi yimi ngawa-yuwuni ngini, “Ngiya waya awarra nayi ngirramini ngurru-wutiyarra nuwa karri ngiya nanuwanga (still) ngurumuwu kangi nuwa pili ngiya nguwutimarti ngini karri ngiya wiyi ngumpuriyi kapi ngiya-rringani api kiyi wiyi nguwuni-pakupawurli kangi nuwa api nuwa wiyi awungarri warntirrana kuwa nginti-matami kangi ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kiyi yimi ngawa-yuwuni ngini, “Ngiya waya karluwu nimarra ngimatami yinukuni kangi nuwa pili ngarra maputiti awunu-wuja pili-ngini ngarra jirti ngirramini yimata-kirayi ngiya. Ngarra awarra maputiti alawura kangi tayikuwapi arikutumunuwi api ngarra karluwu alawura kangi ngiya. ");
INSERT INTO tiw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yita ngiya ngirikirimi (do) awarra waki ngini ngarra ngiya-rringani awutimarti ngiya ngini ngimata-kirimi (to do) ngini (for) ngarra, pili ngiya nguwutimarti ngini tayikuwapi (all) arikutumunuwi pimata-majawu ngini ngiya puranji ngurumuwu awarra ngiya-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Kiyi ngawa-yuwuni Jesus yimi kapi ngarra-mamanta, “Karri ngawa-rringani ngini-ngatawa pukwiyi (Holy Spirit) awunu-wuriyi kapi awarra naki murrakupuni api ngarra wiyi arikirimi arikutumunuwi ngini wurimajawu ngini wuta jajiruwi pili wuta karluwu kuwa wurimi kangi ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni. Kiyi yimi ngawa-yuwuni ngini, “Awarra pukwiyi wiyi awanuwanga arikirimi awuta arikutumunuwi ngini wurimajawu ngini ngiya pupuni tini pili ngiya pakinya japuja ngirikirimi kuriyuwu kapi ngiya-rringani amintiya ngiya waya yinkitayi ngipakupawurli kapi ngiya-rringani api nuwa tayikuwapi (all) arikutumunuwi wiyi karluwu tuwanga nginti-mata-kuluwunyi ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni. Kiyi yimi ngini, “Awarra pukwiyi wiyi awanuwanga awuntiyarra awuta arikutumunuwi ngini ngarra ngawa-rringani waya yimi ngini awarra maputiti ngarra jirti api ngarra ngawa-rringani wiyi arikulani ngirramini (big trouble) apakirayi ngarra. Awarra maputiti ngarra alawura kapi awuta tayikuwapi arikutumunuwi kapi karluwu kuwa wurimi ngawa-rringani. Amintiya ngarra wiyi arimi awarra pukwiyi ngini wuta wiyarri jajiruwi awuta tiwi kapi karluwu kuwa wurimi ngawa-rringani.” Ngarra awarra yipangiraga ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kiyi ngawa-yuwuni nyoni nginaki ngirramini yimi kapi ngarra-mamanta, “Ngiya nguwutimarti ngini ngimata-jiyarra nuwa nyoni ngirramini ngini awurankini api karluwu pili jumurra (hard to understand) awarra ngirramini api arrami nuwa wiyi karluwu nginti-mata-majawu (wouldn't understand) awarra ngirramini. ");
INSERT INTO tiw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Api awarra pukwiyi (Holy Spirit) karri ngarra awunu-wuriyi kapi nuwa api ngarra wiyi awujiyarra nuwa awarra nyoni awurankini ngirramini ngini-ngilawa, awarra tayikuwa-ni (all) ngirramini ngini warntirrana. Awarra ngirramini ngini awarra pukwiyi wiyi nimarra arimi api karluwu ngini-ngatawa ngirramini. Yita ngarra ngawa-rringani wiyi awutiyarra awarra pukwiyi awarra ngirramini.” Ngarra awarra ngawa-yuwuni yipangiraga. ");
INSERT INTO tiw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kiyi yimi kapi awuta ngarra-mamanta, “Karri awarra pukwiyi awutiyarra nuwa awarra ngini-ngilawa ngirramini api nuwa wiyi awungarri ngimpirimi ngini, ‘Ngarra ngatawa ngawa-yuwuni.’ Nuwa wiyi awarra ngimpirimi,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kiyi yimi ngawa-yuwuni ngini, “Awarra ngirramini ngini ngarra ngiya-rringani nimarra arimi api ngiya awarra-wanga (same) ngirramini ngipangiraga amintiya awarra ngirramini ngini awarra pukwiyi wiyi awujiyarra nuwa api ngini-ngatawa ngiya-rringani awarra ngirramini.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ngawa-yuwuni Jesus karri ngarra yipapaya ngini nimarra yimi kapi ngarra-mamanta api yipakuluwunyi kuriyuwu api nimarra yimi kapi ngarra-rringani ngini kuriyuwu, “Aya, ngirringani,” yimi. “Ngiya waya yinkitayi pajuwani ngirimi api wiyi awungarri takirimi arikutumunuwi ngini wurimajawu ngini ngiya ngilawa ngiya awarra nginja-mirani pili ngiya nguwutimarti awuta arikutumunuwi ngini wiyi awungarri pimata-majawu ngini nginja wiyarri nginjila. ");
INSERT INTO tiw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngiya ngirripangiraga awarra pili nginja jiyikirimi ngiya ngini alawura ngimatami kapi tayikuwapi (all) arikutumunuwi. Amintiya nginja jiyikirimi yingampa (some) tiwi ngini pimata-punya angilawa jarrumoka pili nginja juwutimarti ngiya ngini wiyi ngimata-kirimi awuta tiwi ngini (to) yiloti wurumuwu.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kiyi ngawa-yuwuni tuwanga yimi kapi ngarra-rringani, “Awuta tiwi kapi warntirrana wurimajawu muwa yuwurrara api wuta awuta wurimajawu ngini nginja waya yati nginjila wuta-rringani ngini kuriyuwu amintiya awanuwanga wurimajawu ngini ngiya Jesus Christ amintiya ngini nginja jini-pangirri (sent) ngiya awungarra kapi naki murrakupuni (to this earth) api wuta awuta tiwi wiyi yiloti wurumuwu kuriyuwu kanginjila. Wuta awuta tiwi puranji wurumuwu muwa amintiya wupapunya angi-muwula jarrumoka.” Ngarra awarra ngawa-yuwuni yipangiraga kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kiyi ngawa-yuwuni tuwanga yimi kapi ngarra-rringani, “Ngiya waya ngirripapaya awarra waki ngini nginja juwutimarti ngiya ngini ngirikirimi (do) ngini (for) nginja api karri awuta arikutumunuwi pirripakuluwunyi ngiya ngini awarra ngini-nginjila waki ngirimi api wuta awungarri pirimamula (called) nginja nginjila.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kiyi yimi ngini, “Ngirringani wiyi tayakirayi ngiya yingarti power awungaji kapi nginja japuja nginingaji parlingarri muwa murruwuni (had) awarra power karri muwa karluwu murikirimi (made) murrakupuni nanuwanga.” Ngarra awarra ngawa-yuwuni yipangiraga kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kiyi ngawa-yuwuni nyoni nginaki nimarra yimi kapi ngarra-rringani, “Ngirringani, kapinaki ngiya-mamanta api nginja juwunga (picked) awuta api jiyimamula (called) awuta nginja-mamirampi api kiyi nginja jipangirri (sent) awuta kapi ngiya. Api ngiya waya ngurru-wuntiyarra kapinaki ngiya-mamanta ngini (about) nginja api wuta waya kuwa pirimi ngini-nginjila ngirramini ");
INSERT INTO tiw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","amintiya wurimajawu ngini nginja jipakirayi ngiya power ngini (to) ngirikirimi awarra mirrikili (miracles) amintiya awanuwanga wurimajawu ngini awarra ngirramini ngini ngiya ngipangiraga api ngini-nginjila ngirramini awarra. ");
INSERT INTO tiw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Wuta awarra wurimajawu pili ngiya ngurru-wuntiyarra awuta awarra ngirramini ngini nginja juwutiyarra ngiya api kiyi wuta kuwa pirimi awarra ngirramini. Amintiya wuta waya warntirrana wurimajawu ngini ngiya pakinya japuja ngirimi kuriyuwu kapi nginja amintiya ngini nginja jini-pangirri (sent) ngiya awungarra kapi naki murrakupuni (to this earth).” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kiyi awarra ngawa-yuwuni tuwanga nimarra yimi kapi ngarra-rringani api yimi ngini, “Ningani ngiya pray ngirimi ngini (for) kapinaki ngiya-mamanta awuta kapi nginja jini-pangirri (sent) kapi ngiya. Ngiya karluwu ningani pray ngirimi ngini awuta arikutumunuwi kapi wuta karluwu kuwa wurimi ngini-nginjila ngirramini. Waya juwa nanginta ngirimi nginja ngini jimata-mangi kapinaki ngiya-mamanta pili nginja nimpiri-mamula (call) awuta nginja-mamirampi. ");
INSERT INTO tiw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tayikuwapi (all) awuta ngiya-mamanta kapi wupapunya angilawa jarrumoka api nginja nimpiri-mamula (call) awuta nginja-mamirampi. Amintiya tayikuwapi awuta kapi nginja nimpiri-mamula awuta nginja-mamirampi api ngiya awuta ngiya-mamanta.” Ngarra ngawa-yuwuni awarra nimarra yimi kapi ngarra-rringani. Kiyi yimi ngini, “Karri wuta yingampa (other) tiwi wupakuluwunyi awuta ngiya-mamanta ngini wurikirimi ngini pupuni (do good things) api awuta yingampa tiwi wurimi ngini ngiya pupuni.” Ngarra awarra yimi ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kiyi ngawa-yuwuni tuwanga pray yimi kapi ngarra-rringani, “Aya, ngirringani,” yimi. “Nginja waya yati nginjila amintiya nginja warntirrana pupuni. Nginja nimpirimajawu ngini ngiya waya yinkitayi ngupumwari naki awarra murrakupuni (earth) api waya yinkitayi ngumpuriyi kuriyuwu kapi nginja. Api kapinaki ngiya-mamanta waya awungarra wurumuwu kapi awarra naki murrakupuni (on this earth). Nginja nimpini yingarti power nginingaji awarra power ngini nginja jimint-akirayi ngiya api ngiya nguwutimarti nginja ngini jimata-mangi (to look after) awuta kapinaki ngiya-mamanta pili ngiya nguwutimarti ngini wuta wiyi wutiyati punyipunyi nginingaji muwiyati punyipunyi.” Ngarra awarra ngawa-yuwuni nimarra yimi kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kiyi yimi kapi ngarra-rringani, “Karri ngiya japuja ngirimani kapi awuta kapinaki ngiya-mamanta api ngiya yimpaja ngirripamangi awuta. Awarra naki power nginja jipakirayi ngiya api ngiya ngirripamangi awuta ngiya-mamanta api karri-kuwapi purrupumwari ngiya. Waya juwa awarra yati tini yipumwari ngiya awarra ngini wiyi apapirraya kapi awarra maputiti wiyi japuja arimi (hell). Nginja parlingarri juwuntiyarra papaluwi ngini wiyi (later) awarra tini yimata-mwari (would leave) ngiya api awarra ngini-nginjila ngirramini warntirrana yima (came true) karri awarra tini yipumwari ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kiyi ngawa-yuwuni tuwanga nimarra yimi kapi ngarra-rringani, “Nginja waya nimpirimajawu ngini ngiya waya yinkitayi ngumpuriyi kapi nginja api karri ngiya nanuwanga (still) japuja kapi awarra naki murrakupuni (on this earth) ngiya pray ngirimi ngini (for) kapinaki ngiya-mamanta pili ngiya nguwutimarti ngini wuta warntirrana kukunari pimatami nginingaji ngiya,” yimi ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","16","Kiyi ngawa-yuwuni tuwanga yimi ngini, “Ngirringani ngiya waya ngurru-wuntiyarra kapinaki awuta ngiya-mamanta ngini-nginjila ngirramini api awuta tiwi kapi karluwu kuwa wurimi nginja api wuta awuta jirti wurumuwu awuta ngiya-mamanta pili awuta ngiya-mamanta karluwu nginingaji awuta kapi karluwu kuwa wurimi nginja nginingaji ngiya awanuwanga karluwu nginingaji awuta kapi karluwu kuwa wurimi nginja. Ngirringani ngiya karluwu nanginta ngimatami nginja ngini ninganara jimata-marruriyi kapinaki awuta ngiya-mamanta kuriyuwu kapi nginja japuja. Waya juwa nanginta ngirimi nginja ngini jimata-wani (help) awuta ngiya-mamanta ngini karluwu pimata-punya awarra maputiti angatawa jarrumoka,” yimi ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kiyi yimi ngini, “Amintiya ngirringani kapinaki ngiya-mamanta wurimajawu ngini-nginjila ngirramini api takirimi awuta ngini wuta waya juwa waki pimatami ngini (for) nginja amintiya ngini warntirrana kuwa pimatami ngini-nginjila pupuni ngirramini. Awarra ngini-nginjila ngirramini api ngarra awarra warntirrana. ");
INSERT INTO tiw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nginja jini-pangirri (sent) ngiya kapi awuta tayikuwapi (all) arikutumunuwi pili-ngini ngimata-jiyarra awuta ngini-nginjila ngirramini api ngiya awanuwanga ngipangirri kapinaki ngiya-mamanta kapi awuta arikutumunuwi ngini wuta awarra-wanga (same) waki pimatami,” yimi ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kiyi ngawa-yuwuni tuwanga yimi ngini, “Ngirringani, ngiya ningani nguwutiyarra nginja ngini kuta kamini awarra waki ngini nginja nimpitimarti ngiya ngini ngimata-kirimi (do) ngini (for) nginja api ngiya wiyi warntirrana ngipakirimi awarra waki pili ngiya nguwutimarti awuta kapinaki ngiya-mamanta ngini wiyi awanuwanga warntirrana pimata-kirimi (do) awarra ngini nginja nimpitimarti.” Ngarra awarra ngawa-yuwuni yipangiraga kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kiyi ngawa-yuwuni nyoni nginaki nimarra yimi kapi ngarra-rringani ngini kuriyuwu, “Ngiya karluwu pray ngirimi ngini (for) wuta wangata kapi ngiya-mamanta pili awuta ngiya-mamanta wiyi wuntiyarra yingampa (other) tiwi ngini (about) ngiya api ngiya pray ngirimi ngini (for) awuta yingampa tiwi kapi wiyi kuwa wurimi ngiya. Ngirringani, kapinaki ngiya-mamanta amintiya awuta tiwi kapi wiyi kuwa wurimi ngiya ");
INSERT INTO tiw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","api ngiya nguwutimarti awuta ngini wiyi awanuwanga wutiyati punyipunyi nginingaji muwa muwiyati punyipunyi. Amintiya nguwutimarti ngini ngawiyati punyipunyi muwa yuwurrara amintiya awuta kapinaki ngiya-mamanta amintiya awuta yingampa tiwi kapi wuta wiyi kuwa wurimi ngiya. Api kiyi awuta tiwi kapi pakinya karluwu kuwa pirimi ngini-ngilawa ngirramini api karri wuta wupakuluwunyi ngini muwa yuwurrara amintiya ngiya-mamanta ngini ngawiyati punyipunyi api wuta wiyi kuwa wurimi ngini nginja jini-pangirri (sent) ngiya awungarra kapi awarra naki murrakupuni (to this earth).” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kiyi ngawa-yuwuni tuwanga nimarra yimi kapi ngarra-rringani api yimi ngini, “Nginja jimint-akirayi ngiya yingarti power api ngiya awanuwanga ngirripakirayi yingarti power kapi ngiya-mamanta pili ngiya ngurru-wutimarti wuta ngini wiyi wutiyati punyipunyi wuni nginingaji muwa yuwurrara muwiyati punyipunyi ");
INSERT INTO tiw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","api kiyi ngiya amintiya kapinaki ngiya-mamanta wiyi ngawiyati punyipunyi nginingaji nginja amintiya ngiya muwiyati punyipunyi. Takirimi kapinaki ngiya-mamanta ngini wuta warntirrana wutiyati punyipunyi api kiyi awuta tiwi kapi wuta karluwu kuwa wurimi ngini-nginjila ngirramini api wiyi wurimajawu ngini nginja jini-pangirri (sent) ngiya awungarra kapi naki murrakupuni (to this earth) amintiya awanuwanga wiyi wurimajawu ngini nginja puranji nimpirimuwu kapinaki ngiya-mamanta nginingaji nginja puranji nimpirimuwu ngiya.” Ngarra awarra yipangiraga ngawa-yuwuni kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Kiyi ngawa-yuwuni tuwanga nimarra yimi kapi ngarra-rringani, “Ngirringani,” yimi, “Karri muwa karluwu murikirimi (made) naki awarra murrakupuni nanuwanga api nginja puranji jiyimuwu ngiya amintiya nginja jimint-akirayi ngiya arikulani power api ngiya nguwutimarti kapinaki ngiya-mamanta kapi nginja jini-pangirri (sent) kapi ngiya api nguwutimarti ngini kapinaki ngiya-mamanta wiyi pimata-muwu kapi ngiya awungarruwu kapi muwa japuja pili ngiya nguwutimarti ngini wuta wiyi awungaji pimata-kuluwunyi ngiya ngini ngiya nguwuni arikulani power.” Ngarra awarra ngawa-yuwuni nimarra yimi kapi ngarra-rringani. ");
INSERT INTO tiw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kiyi karri natinga arawunga (early morning) karri Caiaphas yipapaya ngini nimarra yimi kangi ngawa-yuwuni Jesus api awuta priests kapi wuta alawuruwi amintiya awuta yingampa alawuruwi pirimarruriyi ngawa-yuwuni kapi awarra Pilate angatawa kurrampali. Awarra Pilate japuja yimi kangi arikulanga kurrampali awungarruwu kapi Jerusalem. Karri awuta alawuruwi papi pirimi awungarruwu kapi Pilate japuja api wuta karluwu pirripawuriji yilaruwu pili ngini-wutawa ngirramini (law) ngini awuta kapi wuta Jews arnuka pimata-wuriji yilaruwu kapi awinyirra kurrampali angi-wutawa awuta arikutumunuwi kapi wuta arnuka Jews. Ngini wuta pirrija-wuriji yilaruwu kapi awinyirra kurrampali api wuta arnuka pimatapa (shouldn't eat) awarra Passover yinkiti. ");
INSERT INTO tiw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Api awarra Pilate papi yimi turruwuni kiyi nanginta yimi awuta Jews, “Pilikama nuwa ngintiniri-marruriyi naki tini kangilawa? Kamini awarra jirti ngini ngarra yikirimi (what wrong has he done)?” yimi awarra Pilate kapi awuta. ");
INSERT INTO tiw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Api wuta pirimi, “Naki awarra Jesus api ngarra waya yingarti jirti yikirim-ani api awarra ngawa ngintiniri-marruriyi ngarra kanginjila,” pirimi awuta alawuruwi kapi awarra Pilate. ");
INSERT INTO tiw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kiyi awarra Pilate yimi kangi wutawa, “Nyirra-marruriyi awarra naki Jesus amintiya judge nyirrami ngarra nuwulamiya pili nuwa wangata awarra ngirramini (law) ngini ngarra yuwawurrini (broke),” yimi Pilate. Api wutatuwu awuta alawuruwi pirimi, “Karluwu, pili nuwa Romans api nuwa alawuruwi waya ngintiri-kirimi ngirramini ngini ngawa Jews karluwu pajuwani ngamata-kirimi awuta tiwi kapi wuta wuwawurrini (break) ngini-ngawula ngirramini api ngawa ngintiniri-marruriyi naki awarra Jesus kanginja pili ngawa ngawutimarti nginja ngini judge jimatami ngarra amintiya ngini jimata-mukuri ngarra kapi arikitirropurtayi (cross) ngini ngarra wiyi pajuwani yimatami,” pirimi awuta alawuruwi kapi Pilate. ");
INSERT INTO tiw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Karri awuta alawuruwi awarra pirripangiraga api awarra ngirramini ngini ngawa-yuwuni puniyarri (before) yimi api waya warntirrana yima (came true) awarra ngirramini ngini, “Wuta wiyi wupamukuri ngiya kuriyuwu kapi arikitirropurtayi (cross) api kiyi ngiya wiyi awungarri pajuwani ngirimi.” ");
INSERT INTO tiw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kiyi Pilate yimarruriyi ngawa-yuwuni yilaruwu kangi angatawa kurrampali kiyi nanginta yimi awarra, “Nginja awarra king kapi awuta Jews-ana?” Awarra Pilate awarra nanginta yimi awarra ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Api ngawa-yuwuni yimi kapi Pilate, “Arramukuta yingampa tiwi purru-wutiyarra nginja ngini ngiya king kapi awuta Jews. Arramukuta nginja awarra jiyimi kangi nginjalamiya. Awungana nginjatuwu?” yimi ngawa-yuwuni kapi awarra Pilate. ");
INSERT INTO tiw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Api Pilate yimi ngini, “Ngiya karluwu Jew api ngiya karluwu ngirimajawu ngini nginja king kapi awuta Jews. Wutatuwu awuta priests kapi wuta alawuruwi amintiya awuta yingampa arikutumunuwi kapi wuta Jews nginingaji nginja api wuta piniri-marruriyi nginja kangiya ngini ngiya judge ngirimi nginja. Kamini awarra jirti ngini nginja jiyikirimi?” yimi Pilate. ");
INSERT INTO tiw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kiyi ngawa-yuwuni yimi ngini, “Arnapa. Ngiya karluwu king kapi naki murrakupuni (on this earth). Ngiya waya juwa king ngirimi kapi awarra murrakupuni ngini kuriyuwu. Ngini ngiya king ngirrijami (if I was king) kapi naki murrakupuni (on this earth) api ngiya-mamanta mwariwarri (would have fought) awuta alawuruwi kapi wuta Jews api wutatuwu awuta alawuruwi karluwu mwarruwunga (would not have arrested) ngiya amintiya karluwu mwanuri-marruriyi (would not have brought) ngiya kanginjila,” yimi ngawa-yuwuni kangi Pilate. ");
INSERT INTO tiw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kiyi Pilate yimi kangi ngawa-yuwuni, “Nginja awarra warntirrana king. Tami?” yimi Pilate. Api ngawa-yuwuni yimi ngini, “Nginja warntirrana nimarra jiyimi ngini ngiya king. Ngiya nguru-mulungurrumi kapi naki murrakupuni (on this earth) pili-ngini ngiya wiyi ngimata-jiyarra arikutumunuwi ngirramini ngini warntirrana. Awuta arikutumunuwi kapi wutimarti ngini pimata-majawu awarra ngirramini ngini warntirrana api wuta wuri-pitingaya (listen to) ngiya,” yimi ngawa-yuwuni kapi awarra Pilate. ");
INSERT INTO tiw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Api Pilate yimi ngini, “Kamini awarra ngirramini ngini warntirrana?” Api ngawa-yuwuni karluwu nimarra yimi kangi awarra Pilate. Karri Pilate yipapaya ngini nimarra yimi kangi ngawa-yuwuni api ngarra yuwuriyi turruwuni kiyi tuwanga nimarra yimi kapi awuta Jews, api yimi ngini, “Ngiya amintiya naki Jesus waya nimarra ngintiri-majirri api ngiya ngirimi ngini ngarra karluwu jirti tini.” Awarra Pilate yimi awarra kapi awuta alawuruwi kapi wuta Jews. ");
INSERT INTO tiw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kiyi awarra Pilate yimi kapi awuta soldiers ngini, “Nyirranga murrukuni (whip) api nyirra-pirni naki Jesus kangi ngarra jukwartanga.” Api kiyi awuta soldiers kuwa pirimi awarra Pilate kiyi piripirni ngawa-yuwuni kangi ngarra jukwartanga. ");
INSERT INTO tiw_vpl VALUES ("JN19_25b","073_19_25b","JHN","19","25b","25b","Ngawa-yuwuni Jesus ngarra-naringa amintiya nyirra-marrikuluma tayinti purru-wujingu-mani yinkitayi kapi ngawa-yuwuni yimatilayi kapi awarra arikitirropurtayi (cross). Awinyirra Mary angi nyirra-purnayi Clopas amintiya Mary Magdalene amintiya ngawa-yumuni ngarra-mantani John api wuta wiyarri tayinti purru-wujingi-mani yinkitayi kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Api ngawa-yumuni karri ngarra yi-pakuluwunyi ngarra-naringa amintiya awarra John tayinti purru-wujingi-mani yinkitayi kangatawa api ngarra yimi kangi ngarra-naringa, “Aga nginari awarra naki John api ngarra waya awarra nginja-mwarti,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kiyi ngarra yi-pakuluwunyi awarra John api yimi kangatawa, “Awa mantani, tayamangi anaki ngiya-naringa pili nginja wiyi nginja-naringa awinyirra.” Awarra yimi ngawa-yuwuni kapi awarra John. Api awarra John wiyi yimarruriyi awinyirra Mary kapi ngarra japuja api awungarruwu yi-pamangi awinyirra. ");
INSERT INTO tiw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Karri ngawa-yuwuni Jesus pajuwani yimi api awungarri waniyati (Friday) api pangarri Sabbath Day (Saturday). Api awuta alawuruwi kapi awuta Jews karluwu purru-wutimarti ngini pimata-mwari ngawa-yuwuni amintiya awuta yuwurrara mitayuwi ngini-wutawa purnikapa kapi arikitirropurtayi (cross) karri awinyirra Sabbath Day pili awungarri nanuwanga (still) awarra Passover Ceremony. Api kiyi awuta alawuruwi pirimi kangi awarra Pilate, “Ngawa ngawutimarti awuta soldiers ngini pimata-wurrini (break) pwaja kangi ngini-wutawa yirrikarla awarra Jesus amintiya awuta wawurruwi kapi mitayuwi pili-ngini wuta wiyi yartipili pajuwani pimatami. Api kiyi awuta soldiers wiyi pimatanga wuta purnikapa kapi awarra arikitirropurtayi api wuni-papirray-amuwi (take down) wuta purnikapa,” pirimi awuta alawuruwi kapi Pilate. Api awarra Pilate “Manya” yimi. ");
INSERT INTO tiw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kiyi awuta soldiers purruwuriyi kapi awarra yati tini ngini mitayini kiyi purruwawurrini (broke) pwaja kangi ngarra yirrikarla kiyi awanuwanga wuta purruwawurrini awarra nyoni mitayini ngini-ngatawa yirrikarla. ");
INSERT INTO tiw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Api karri awuta soldiers papi pirimi kapi ngawa-yuwuni api wuta pirripakuluwunyi ngini ngarra waya pajuwani yimi api wuta karluwu purruwawurrini (didn't break) pwaja kangi ngini-ngatawa yirrikarla. ");
INSERT INTO tiw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Api yati soldier yuwunga numwariyaka kiyi turli yimi (speared) ngawa-yuwuni kapi ngarra kulonjiyi (side) kiyi majipani amintiya kukuni alala yimi. ");
INSERT INTO tiw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ngiya ngirripakuluwunyi ngiyalamiya awarra soldier ngini ngarra turli yimi ngawa-yuwuni api ngiya ngirimajawu ngini awarra ngirramini warntirrana. Api ngiya ngirikirimi (write) naki ngirramini kangi punkaringini (book) pili ngiya nguwutimarti ngini karri nuwa wiyi ngimpa-kirrimiya (read) awarra naki ngirramini api nuwa wiyi awungarri kuwa nginti-matami kangi ngawa-yuwuni Jesus. ");
INSERT INTO tiw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Parlingarri awarra Moses yikirimi (wrote) kapi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) awarra naki ngirramini ngini, “Karri wuta pajuwani wurikirimi ngarra api wuta wiyi karluwu pimata-wurrini (break) yati ngini-ngatawa pwaja.” Ngarra awarra Moses yikirimi (wrote) awarra ngirramini ngini (about) awarra lamb ngini wuta pajuwani pirikirim-ani karri awarra Passover Ceremony. Api karri awuta soldiers purrupumwari awarra pwaja kangi ngini-ngatawa yirrikarla ngawa-yuwuni api karluwu purruwawurrini awarra pwaja api awarra ngirramini warntirrana yima (became true) awarra ngirramini ngini awarra Moses yikirimi kangi awarra punkaringini pili awarra ngawa-yuwuni ngarra nginingaji awarra lamb. ");
INSERT INTO tiw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Amintiya nyoni tini parlingarri yikirimi (wrote) kangi ngawa-rringani ngini-ngatawa punkaringini awarra naki ngirramini ngini ngawa-yuwuni, “Awarra tini ngini awuta jajiruwi arikutumunuwi wiyi turli wurimi (will spear) ngarra api tayikuwapi arikutumunuwi wiyi wupakuluwunyi awarra tini.” Awarra yikirimi awarra tini kapi awarra punkaringini. Amintiya awarra naki ngirramini awanuwanga waya warntirrana yima (became true). ");
INSERT INTO tiw_vpl VALUES ("JN20_2a","073_20_2a","JHN","20","2a","2a","Kiyi Mary Magdalene jipumwari awarra cave kiyi kalikali jiyimi kapi wuta japuja awuta yuwurrara ngawa-yuwuni ngarra-mamanta Simon Peter amintiya awarra John. ");
INSERT INTO tiw_vpl VALUES ("JN20_2b","073_20_2b","JHN","20","2b","2b","Karri awinyirra Mary Magdalene papi jiyimi kapi awarra Peter amintiya awarra John api jiyimi kangi wutawa, “Kuta kuwapi pirripawuriji yilaruwu kapi awarra cave api purruwunga ngini-ngawula alawura ngarra purnikapa api kuta maka pirimarruriyi ngarra,” jiyimi. ");
INSERT INTO tiw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kiyi Peter amintiya John purruwuriyi kapi awinyirra cave. ");
INSERT INTO tiw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Awuta yuwurrara kalikali pirimi api awarra John yikumwari Peter kiyi pakinya papi yimi kapi awarra cave. ");
INSERT INTO tiw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kiyi awarra John yipajiyarri (bent down) kiyi yipakuluwunyi yilaruwu kapi awarra cave amintiya yipakuluwunyi awinyirra manipurruwa (material) yilaruwu kapi awarra cave api ngarra karluwu yipawuriji yilaruwu. ");
INSERT INTO tiw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Kiyi Simon Peter awanuwanga papi yimi awungarruwu kapi awarra cave kiyi ngarra yipawuriji yilaruwu. Ngarra awanuwanga yipakuluwunyi awungaji awinyirra manipurruwa. Natinga awinyirra manipurruwa api wuta pirikimirna (wrapped around) ngawa-yuwuni ngarra purnikapa amintiya nyonga manipurruwa angi kirijinga api awinyirra manipurruwa jimurrarijipa (folded up). Awinyirra kirijinga manipurruwa api wuta pirikimirna (wrapped around) ngawa-yuwuni ngini-ngatawa pungintaga. Awinyirra yinjara manipurruwa api wangatajirri jiyimi. ");
INSERT INTO tiw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kiyi awarra John awanuwanga yipawuriji yilaruwu kangi awarra cave. Ngarra awanuwanga yipakuluwunyi awinyirra manipurruwa api ngarra kuwa yimi awarra ngirramini ngini awinyirra Mary Magdalene jipangiraga ngini ngawa-yuwuni ngarra purnikapa waya karluwu yipalamiya yilaruwu kangi awarra cave. ");
INSERT INTO tiw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Parlingarri yingampa papaluwi pirikirimi (wrote) kapi ngawa-rringani ngini-ngatawa punkaringini (Old Testament) awarra ngirramini ngini awarra Jesus wiyi pajuwani yimatami amintiya ngini ngarra wiyi tuwanga yimpangini yimatama. Api awuta yuwurrara ngarra-mamanta nanuwanga arnuka pirimajawu (didn't understand) awarra ngirramini ngini awuta tiwi pirikirimi kapi awarra punkaringini parlingarri. ");
INSERT INTO tiw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kiyi awarra Peter amintiya awarra John pirripakupawurli kapi wuta japuja. ");
INSERT INTO tiw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kiyi Mary Magdalene jipakupawurli kapi awarra cave kiyi tayinti jiyimi turruwuni. Nyirra awungarri pirlikiti juwujingi-mani. Kiyi jipajiyarri (bent down) api jipakuluwunyi yilaruwu kapi awarra cave. ");
INSERT INTO tiw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Awungaji nyirra jipakuluwunyi yuwurrara angeluwi kapi purukuripiya (were wearing) kuluji nginingaji turtiyangini (white). Api wuta purumuwu kapi ngawa-yuwuni purnikapa pakinya yimili. Yati yimuwu yinkitayi kapi ngarra pungintaga pakinya yima amintiya awarra nyoni yimuwu yinkitayi kapi ngarra malapwara pakinya yima. ");
INSERT INTO tiw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kiyi awuta angeluwi nanginta pirimi awinyirra Mary, “Aga, mantanga, pilikama nginja pirlikiti nimpirimi?” pirimi. Kiyi nyirra jiyimi ngini, “Kuta kuwapi purruwunga ngini-ngilawa alawura ngarra purnikapa api kuta maka pirimarruriyi awarra,” jiyimi awinyirra Mary. ");
INSERT INTO tiw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kiyi awinyirra Mary tuwanga tayinti jiyimi kiyi jipakuluwunyi ngawa-yuwuni yuwujingi-rritani yinkitayi kapi nyirra api nyirra arnuka jiyimajawu (did not recognise) awarra. ");
INSERT INTO tiw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kiyi ngarra yimi kangi nyirra, “Aga, mantanga, pilikama nginja pirlikiti nimpirimi? Kuwani awarra ngini nginja kularlaga nimpirimi?” yimi ngawa-yuwuni. Nyirra amparrimani juwarimi ngini ngawa-yuwuni api ngarra awarra tini ngini ngarra waki yimi kapi awarra garden api nyirra jiyimi kangatawa, “Ngini nginja kuta maka jiyimarruriyi ngiya-mantani ngarra purnikapa api tajiyarra ngiya kapi maka nginja jipamukuri awarra purnikapa pili-ngini ngiya ngimatu-wariyi awungarruwu kiyi ngimatanga ngarra purnikapa,” jiyimi Mary. ");
INSERT INTO tiw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Api ngawa-yuwuni tuwa yimi ngini-nyitawa yintanga api yimi ngini, “Mary.” Api nyirra tuwanga jipakuluwunyi awarra ngawa-yuwuni kiyi waya jiyimajawu ngarra api nyirra kuwayi jiyimi makirrana, ‘Raponayi’. Kapi awarra langwiji Aramaic api awarra yintanga mean arimi awarra tini ngini ngarra awunu-waluwa arikutumunuwi (teacher). ");
INSERT INTO tiw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kiyi ngawa-yuwuni yimi kangi nyirra, “Ngajiti nimpaja-mukuri ngini-nginjila yikara kangiya pili ngiya arnuka nanuwanga ngurruwuriyi kuriyuwu kapi ngiya-rringani. Tuwariyi kapi ngiya-mamanta kiyi tajiyarra awuta ngini nginja waya jipakuluwunyi ngiya amintiya ngini ngiya wiyi parlinginari (later) ngumpuriyi kapi ngiya-rringani ngini kuriyuwu, awarra ngini ngiya ngirimi ngini ngarra warntirrana ngatawa. Api awarra ngiya-rringani ngarra awanuwanga nuwa-rringani nginja amintiya awuta yingampa ngiya-mamanta amintiya nuwa wiyarri ngimpirimi ngini ngarra warntirrana ngatawa awarra ngawa-rringani. Api tuwariyi tajiyarra awuta ngiya-mamanta awarra ngirramini.” Awarra yimi ngawa-yuwuni kangi awinyirra Mary Magdalene. ");
INSERT INTO tiw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kiyi awinyirra Mary Magdalene juwuriyi kapi ngawa-yuwuni ngarra-mamanta api nyirra jiyimi kangi wutawa, “Ngiya waya ngirripakuluwunyi ngini-ngawula alawura,” jiyimi. Kiyi juwuntiyarra awuta awarra ngirramini ngini ngawa-yuwuni yipangiraga kangi nyirra. ");
INSERT INTO tiw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Karri awinyirra-wanga wumunga (day) Sunday api karri yartijanga ngawa-yuwuni ngarra-mamanta mimpa pirimi yilaruwu kapi kurrampali. Wuta kunji pirikirimi awinyirra door pili wuta pirimakirri awuta yingampa Jews. Awarra warntirrana ngini awinyirra door kunji api ngawa-yuwuni Jesus papi yimi yilaruwu kapi awinyirra room kiyi ngarra tayinti yimi kuluwuta kapi awuta ngarra-mamanta kiyi yimi kangi wuta, “Awungana mamanta. Ngajiti ngimpaja-wanga!” yimi. ");
INSERT INTO tiw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kiyi ngarra yimi kangi wutawa, “Nyirra-kuluwunyi ngini-ngilawa yikara amintiya ngini-ngilawa kulonjiyi (side),” yimi. Kiyi awuta ngarra-mamanta, karri wuta pirripakuluwunyi ngini-ngatawa yikara amintiya ngini-ngatawa kulonjiyi api wuta kukunari pirimi pili pirimajawu ngini ngarra awarra ngawa-yuwuni, awarra ngini wuta-alawura. ");
INSERT INTO tiw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kiyi ngawa-yuwuni tuwanga nimarra yimi, “Ngajiti ngimpaja-wanga. Nuwa ngimpiri-majawu ngini ngiya-rringani yini-pangirri (sent) ngiya awungarra kapi naki murrakupuni (to this earth) ngini ngiya ngimata-jiyarra arikutumunuwi ngini-ngatawa ngirramini api ngiya awanuwanga wiyi ngipangirri (send) nuwa ngini nginti-mata-jiyarra arikutumunuwi ngini-ngilawa ngirramini,” yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kiyi ngawa-yuwuni yipangirri ngini-ngatawa yiminga (breathed) kangi awuta ngarra-mamanta kiyi yimi ngini, “Ngiya waya ngirripangirri ngini-ngilawa yiminga kangi nuwa api ngiya wiyi awanuwanga ngipangirri ngiya-rringani ngini-ngatawa pukwiyi (Holy Spirit) kapi nuwa. Karri awarra pukwiyi wiyi papi arimi kangi nuwa, api nyirra-lami awarra yilaruwu kangi nuwa ruwuti,” yimi ngawa-yuwuni kangi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kiyi yimi ngini, “Ngini nuwa putuputuwu ngimpakirayi (forgive) arikutumunuwi awarra jirti ngini wuta pirikirim-ani (the wrong they have done) api ngawa-rringani wiyi awanuwanga putuputuwu apakirayi awuta. Ngini nuwa karluwu putuputuwu ngimpakirayi arikutumunuwi awarra jirti ngini wuta pirikirim-ani api ngarra awanuwanga ngawa-rringani wiyi karluwu putuputuwu yimata-kirayi awuta.” Awarra yimi ngawa-yuwuni kapi ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Karri ngawa-yuwuni Jesus mampara papi yimi kapi ngarra-mamanta api awarra Thomas ngarra karluwu yimuwu awungarruwu kapi awinyirra kurrampali. Ngarra awarra Thomas yikirimi wamurrara yuwurrara (12) kapi awuta ngarra-mamanta ngawa-yuwuni kapi ngarra pakinya yuwunga awuta. Ngarra nyoni yintanga Didymus, awarra Thomas. ");
INSERT INTO tiw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kiyi awuta yingampa ngarra-mamanta ngawa-yuwuni api karri wuta pirripakuluwunyi awarra Thomas api purru-wutiyarra, “Ngawa nginti-pakuluwunyi ngawa-yuwuni awarra ngini-ngawula alawura. Ngarra waya tuwanga yimpangini yima,” pirimi. Api awarra Thomas yimi kangi wutawa, “Ngiya arnuka kuwa ngirimi nuwa. Ngini ngiya wiyi ngipakuluwunyi awarra yangamini kapi awarra murumunguni (nail) patingirrupati yikirimi (went through) kangi ngarra yikara ngawa-yuwuni amintiya ngini ngipamukuri ngini-ngilawa wamuta (finger) kapi awarra yangamini kapi ngatawa yikara amintiya ngini ngipamukuri ngiya yikara kapi yangamini kapi numwariyaka turli yimi kapi ngarra kulonjiyi (side) api waya juwa awungarri ngiya wiyi kuwa ngirimi ngini ngarra ngawa-yuwuni waya tuwanga yimpangini yima.” Awarra yimi awarra Thomas kangi awuta yingampa ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Karri nyoni week api ngawa-yuwuni ngarra-mamanta tuwanga purumuwu yilaruwu kapi awinyirra kurrampali. Api awarra Thomas ngarra wiyarri awungaji yimuwu. Wuta tuwanga kunji pirikirimi awinyirra kurrampali. Kiyi ngawa-yuwuni papi yimi kiyi tayinti yimi kuluwuta kapi awuta kiyi yimi ngini, “Awungana mamanta. Ngajiti ngimpaja-wanga!” yimi kangi wuta. ");
INSERT INTO tiw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kiyi ngawa-yuwuni yimi kapi awarra Thomas, “Tayakuluwunyi ngini-ngilawa yikara amintiya tayamukuri ngini-nginjila wamuta (finger) yilaruwu kapi naki yangamini kapi ngini-ngilawa yikara. Amintiya tayamukuri nginjila yikara yilaruwu kapi naki yangamini kapi ngini-ngilawa kulonjiyi (side). Pilikama nginja karluwu kuwa jiyimi awarra ngirramini ngini ngiya-mamanta purru-wutiyarra nginja ngini (about) ngiya. Ngajiti awungani nimpajami. Waya juwa kuwa tami ngini ngiya waya ngurru-pukularri api tuwanga yimpangini ngirima,” yimi ngawa-yuwuni kapi Thomas. ");
INSERT INTO tiw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kiyi awarra Thomas yimi kangatawa, “Nginja awarra nginaki ngiya-alawura amintiya nginja warntirrana nginjila. Ngiya kuwa ngirimi kanginjila,” yimi awarra Thomas kapi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kiyi ngawa-yuwuni yimi kangatawa, “Nginja kuwa nimpirimi kangilawa pili nginja waya jipakuluwunyi ngini ngiya waya ngurru-pukularri api tuwanga yimpangini ngirima. Api wutatuwu yingampa arikutumunuwi wiyi karluwu pimata-kuluwunyi ngiya, yingampa kapi ningani wurimuwu amintiya awuta kapi nanuwanga wunu-wuja. Wuta wiyi karluwu worry pimatami ngini wuta karluwu pirripakuluwunyi ngiya api wuta wiyi kuwa wurimi ngini ngiya ngirripukularri api tuwanga yimpangini ngirima. Api wuta awuta wiyi kukunari wurimi amintiya ngawa-rringani wiyi apamangi awuta.” Awarra ngawa-yuwuni yipangiraga kapi Thomas. Kiyi ngawa-yuwuni yipumwari ngarra-mamanta. ");
INSERT INTO tiw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","3","Karri nyonga wumunga (day) karri awarra Simon Peter amintiya ngarra-mamanta wutiyati purumuwu api awarra Simon Peter yimi kapi awuta ngarra-mamanta, “Ngiya nguwuja ngiripirni muputi.” Api wuta pirimi, “Ngawiyati ngawurliyi.” Wuta yintanga awuta ngarra-mamanta api Thomas amintiya Nathaniel, kiyi James amintiya John amintiya yingampa ngawa-yuwuni ngarra-mamanta. Yuwurrara awuta. Ngarra awarra Simon Peter yikirimi walimani. Ngarra awarra Thomas api wuta pirimamula (called) awarra Thomas Didymus. Ngarra awarra Nathaniel api ngarra japuja yimi kapi awarra town Cana awungarruwu kapi Galilee. Kiyi awuta ngawa-yuwuni ngarra-mamanta kutupi pirimi api purruwuriyi kapi awinyirra lake Galilee. Awungarruwu wuta pirripawuriji yilaruwu kapala. Karluwu karrampi purruwuriyi. Waya japinamini awungarri. Kiyi wuta tikimati pirimi angi-wutawa yurruka kuluji kiyi purruwunyawu angi-wutawa panapa (net). Wuta yimpaja purruwunyawu awinyirra panapa api karri-kamini muputi. Kiyi karri natinga arawunga api nanuwanga (still) karri-kamini muputi. ");
INSERT INTO tiw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kiyi wuta pirripakuluwunyi yati tini kapi tingata. Wuta karluwu pirimajawu ngini ngawa-yuwuni Jesus awarra. ");
INSERT INTO tiw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kiyi ngawa-yuwuni jingawu yimi kapi awuta ngarra-mamanta, “Mamanta,” yimi. “Marri muputi?” Api wuta pirimi, “Karri-kamini.” ");
INSERT INTO tiw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Api ngarra yimi ngini, “Nyirra-nyawu angi-nuwula panapa (net) kangi nuwula aripa api nuwa wiyi awungaji ngimpanga muputi.” Api kiyi wuta purruwunyawu angi-wutawa panapa kapi aripa api yingarti muputuwi purruwunga kapi awinyirra panapa. Api karri wuta pirrari-kitikimi (tried to pull) awinyirra panapa yilaruwu kapi awinyirra kapala api karluwu pili alanyawunga (heavy) pili yingarti muputuwi kapi awinyirra panapa. ");
INSERT INTO tiw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kiyi awarra John yimi kapi Peter, “Yita ngarra ngini-muwula alawura awarra nayi.” Api karri awarra Peter yipitingaya (heard) awarra ngirramini ngini awarra John yipangiraga api ngarra yuwutimarti ngini mwarliki yimatami awungarruwu kapi ngawa-yuwuni yuwujingi-rritani kapi tingata api ngarra yuwunga angatawa yurruka kuluji api kiyi yikuripiya kangatamiya (put it on himself). Kiyi ngarra kutupi yimi kapi winga api mwarliki yimi kapi tingata. ");
INSERT INTO tiw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wutatuwu yingampa api wuta yinkitayi kangi tingata api pirripapunya awarra Peter kangi awinyirra kapala. Wuta pirikitikimi (pulled) awuta yingarti muputuwi kangi awinyirra panapa kiyi purrupumwari awuta muputuwi yinkitayi kapi tingata. ");
INSERT INTO tiw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Api karri papi pirimi kapi tingata wuta awungarri pirripakuluwunyi awarra yikwani amintiya muputi kuriyuwu kapi awarra turna amintiya pamantarri yinkitayi kapi awarra yikwani. ");
INSERT INTO tiw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kiyi ngawa-yuwuni yimi kapi awuta ngarra-mamanta, “Nyirra-marruripa yingampa (some) niyi awarra muputi ngini nuwa nguntuwunga (caught).” ");
INSERT INTO tiw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kiyi ngarra Simon Peter yipakupawurli kapi awinyirra kapala api yuwunga awinyirra panapa kiyi yikitikimi (pulled) awinyirra panapa kangi tingata. Kangi awinyirra panapa yingarti muputuwi ngini arikulani api awinyirra panapa karluwu juwawurra (break). Kangi awinyirra panapa 153 muputuwi. ");
INSERT INTO tiw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kiyi ngawa-yuwuni yimi kangi wutawa, “Kali nyirru-waripa, nyirrapa yinkiti,” yimi. Karri-kuwani nanginta yimi ngawa-yuwuni ngini ngarra kuwani pili wuta arliranga. Wuta waya pirimajawu ngini ngarra wuta-alawura awarra. ");
INSERT INTO tiw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kiyi ngawa-yuwuni yuwuriyi yuwunga awarra pamantarri api yipakirayi awarra kapi awuta ngarra-mamanta. Awanuwanga yipakirayi awuta muputi. Kiyi ngawa-yuwuni amintiya ngarra-mamanta purruwapa awarra yinkiti. ");
INSERT INTO tiw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kiyi karri ngawa-yuwuni Jesus amintiya ngarra-mamanta pirripapaya ngini purruwapa yinkiti api ngawa-yuwuni amintiya Peter purrupumwari awuta yingampa ngawa-yuwuni ngarra-mamanta, api karri wuta pirripangulimayi kapi tingata api ngarra ngawa-yuwuni yimi kapi Simon Peter, “Aya, Simon, arrami awuta kapinaki yingampa ngiya-mamanta kiyija puranji wurumuwu ngiya api nginjatuwu arrami warntirrana puranji nimpirimuwu ngiya. Tami?” Awarra ngawa-yuwuni nanginta yimi Simon Peter. Kiyi awarra Simon Peter yimi ngini, “Kuwa, yuwuni, nginja nimpirimajawu ngini ngiya puranji ngurumuwu nginja. Nginja alawura nimpirimi kangiya,” yimi Simon Peter. Kiyi ngawa-yuwuni yimi kangatawa, “Awuta tiwi kapi kuwa wurimi kangilawa api tayamangi awuta pili-ngini wuta karluwu pimata-mwari angilawa jarrumoka. Tajiyarra awuta arikutumunuwi ngini-ngilawa ngirramini,” yimi ngawa-yuwuni kangi awarra Peter. ");
INSERT INTO tiw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kiyi ngawa-yuwuni tuwanga nanginta yimi ngarra, “Simon Peter, arrami nginja warntirrana puranji nimpirimuwu ngiya. Tami?” Api ngarra Simon Peter yimi ngini, “Kuwa, yuwuni, nginja nimpirimajawu ngini ngiya puranji ngurumuwu nginja,” yimi Simon. Kiyi ngawa-yuwuni tuwanga yimi kangatawa, “Tayamangi awuta kapi kuwa wurimi kangilawa,” yimi ngawa-yuwuni. ");
INSERT INTO tiw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kiyi ngawa-yuwuni tuwanga nanginta yimi Simon, “Aya, Simon, arrami nginja puranji nimpirimuwu ngiya. Tami?” Api ngarratuwu Simon Peter karluwu kukunari yimi pili ngarra ngawa-yuwuni tuwanga nanginta yimi ngarra awarra-wanga (same) ngirramini. Api kiyi Simon Peter yimi kapi ngawa-yuwuni, “Yuwuni, nginja nimpirimajawu tayikuwa-ni arramu-kaminawuti (everything) api nginja nimpirimajawu ngini ngiya puranji ngurumuwu nginja,” yimi Simon. Api ngarra ngawa-yuwuni tuwanga yimi kangatawa, “Tayamangi awuta kapi kuwa wurimi kangilawa,” yimi ngawa-yuwuni kangi Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kiyi ngawa-yuwuni nyoni ngirramini nimarra yimi kapi Simon Peter, “Naki awarra warntirrana ngini karri nginja malakaninga api nginja jipamang-amiya amintiya jipangulimay-ani kuta maka kapi nginja juwutimarti api karri nginja wiyi wulimani api nginja wiyi nimpakurupa (hold out) nginja kurumuta api yingampa arikutumunuwi wiyi wunga arlipurringa kiyi wurikimirna nginja kurumuta kiyi wurimarruriyi nginja kapi nginja karluwu nimpitimarti,” yimi ngawa-yuwuni kapi awarra Peter. ");
INSERT INTO tiw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Karri ngawa-yuwuni Jesus yipangiraga awarra ngirramini kapi awarra Peter api ngarra mean yimi ngini karri Peter wiyi wulimani arimi api yingampa tiwi wiyi pajuwani wurikirimi ngarra pili ngarra kuwa arimi kangi ngawa-yuwuni api kiyi tayikuwapi arikutumunuwi wiyi wuru-pungintayi (think about) awarra Peter amintiya wiyi wuru-kuruwarni (thank) ngawa-rringani ngini kuriyuwu pili awarra Peter warntirrana kuwa yimi ngarra. Kiyi ngawa-yuwuni yimi ngini, “Aya, Simon, ngajiti nimpaja-mwari ngini-ngilawa ngirramini. Yimpaja tayapunya angilawa jarrumoka!” Awarra yimi ngawa-yuwuni kangi awarra Peter. ");
INSERT INTO tiw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","21","Karri ngawa-yuwuni amintiya Peter pirripangulimayi api awarra John yipapunya awuta. Awarra John api ngarra awarra ngini yimuwu yinkitayi kapi ngawa-yuwuni nangunji-nara karri awuta ngawa-yuwuni ngarra-mamanta wutiyati purruwapa yinkiti amintiya awarra John awungarri nanginta yimi ngawa-yuwuni, “Yuwuni, kuwani wiyi traitor arimi kangi nginja?” Awarra John awarra nanginta yimi ngawa-yuwuni nangunji-nara karri wutiyati purruwapa yinkiti. Api karri awarra Peter yipakuluwunyi awarra John ngini yipapunya ngarra amintiya ngawa-yuwuni api Peter yimi kapi ngawa-yuwuni, “Yuwuni, nginja juwutiyarra ngiya ngini karri ngiya wulimani api awungarri yingampa arikutumunuwi wiyi wurimarruriyi ngiya kuta maka awungarruwu kapi ngiya karluwu nguwutimarti. Marri awarra nginaki John?” yimi Peter. ");
INSERT INTO tiw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Api ngawa-yuwuni yimi kangi Peter, “Arramukuta ngiya nguwutimarti ngini ngarra awarra John yinukuni wiyi yimata-muwu awungarra kapi naki murrakupuni (on this earth). Arramukuta ngarra wiyi nanuwanga yimpangini arimi karri ngiya wiyi nguwuni-pakupawurli (come back) kapi naki murrakupuni (to this earth). Ngini ngiya awarra nguwutimarti api nginja karluwu awarra ngirramini. Waya juwa ngini nginjalamiya tayapunya angilawa jarrumoka!” yimi ngawa-yuwuni kangi Simon Peter. ");
INSERT INTO tiw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Karri awuta yingampa ngawa-yuwuni ngarra-mamanta piri-pitingaya (heard) awarra ngirramini ngini ngawa-yuwuni yipangiraga api wuta amparrimani pirrarimi ngini awarra John wiyi arnuka pajuwani arimi. Api ngawa-yuwuni karluwu yimi ngini, “Awarra John ngarra wiyi arnuka pajuwani arimi.” Waya juwa ngarra yimi ngini, “Arramukuta ngiya nguwutimarti ngini ngarra awarra John wiyi yinukuni yimata-muwu awungarra kapi naki murrakupuni (on this earth). Arramukuta ngarra wiyi nanuwanga (still) yimpangini karri ngiya wiyi nguwuni-pakupawurli kapi naki murrakupuni (to this earth). Ngini ngiya awarra nguwutimarti api ngajiti worry nimpajami awarra.” Waya juwa awarra yimi ngawa-yuwuni kangi Peter. ");
ALTER TABLE tiw_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
