﻿USE sofia;
DROP TABLE IF EXISTS sofia.tim_vpl;
CREATE TABLE tim_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tim_vpl WRITE;
INSERT INTO tim_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yuda luâk âmbâle areyeŋgât hakuyeŋe kotŋe Abraham yâkgât bâgiŋe siâ kotŋe Dawidi aregât bâgiŋe siâ kotŋe Yesu Anutuŋe huŋgunaŋdo giep amâ yâkgât hakulupŋe are kotyeŋe hin. ");
INSERT INTO tim_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ulik ulik luâk kotŋe Abrahamŋe nanŋe kotŋe Isaka miep. Isakaŋe humo akmâ âmbâle mendo nanŋe kotŋe Yakobo miep. Yakoboŋe humo akmâ âmbâle mendo nanŋe kotŋe Yuda miep. Akto nanaŋlupŋe siânba meyegep. ");
INSERT INTO tim_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Akto Yudaŋe humo akmâ âmbâle kotŋe Tama erânŋe mendo nanlogâtŋe lâuwâ meyelegep, kotyetŋe Perese akto Sera. Akto Pereseŋe humo akmâ âmbâle mendo nanŋe kotŋe Hesoroŋ miep. Hesoroŋŋe humo akmâ âmbâle mendo nanŋe kotŋe Ram miep. ");
INSERT INTO tim_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramŋe humo akmâ âmbâle mendo nanŋe kotŋe Aminadaba miep. Aminadabaŋe humo akmâ âmbâle mendo nanŋe kotŋe Nasoŋ miep. Nasoŋŋe humo akmâ âmbâle mendo nanŋe kotŋe Salamoŋ miep. ");
INSERT INTO tim_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamoŋŋe humo akmâ âmbâle kotŋe Rahaba mendo nanŋe kotŋe Boasi miep. Boasiŋe humo akmâ âmbâle kotŋe Ruti mendo nanŋe kotŋe Obede miep. Obedeŋe humo akmâ âmbâle mendo nanŋe kotŋe Yese miep. ");
INSERT INTO tim_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yeseŋe humo akmâ âmbâle mendo nanŋe kotŋe Dawidi miep. Dawidiŋe luâk kotdâ akmâ malep. Sop ain Dawidiŋe Urigât âmbâle kambut mendo nanŋe kotŋe Salomo miep. ");
INSERT INTO tim_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoŋe humo akmâ âmbâle mendo nanŋe kotŋe Rehabeam miep. Rehabeamŋe humo akmâ âmbâle mendo nanŋe kotŋe Abia miep. Abiaŋe humo akmâ âmbâle mendo nanŋe kotŋe Asa miep. ");
INSERT INTO tim_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaŋe humo akmâ âmbâle mendo nanŋe kotŋe Yosapata miep. Yosapataŋe humo akmâ âmbâle mendo nanŋe kotŋe Yoram miep. Yoramŋe humo akmâ âmbâle mendo nanŋe kotŋe Usia miep. ");
INSERT INTO tim_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiaŋe humo akmâ âmbâle mendo nanŋe kotŋe Yotam miep. Yotamŋe humo akmâ âmbâle mendo nanŋe kotŋe Ahasi miep. Ahasiŋe humo akmâ âmbâle mendo nanŋe kotŋe Hisikia miep. ");
INSERT INTO tim_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hisikiaŋe humo akmâ âmbâle mendo nanŋe kotŋe Manase miep. Manaseŋe humo akmâ âmbâle mendo nanŋe kotŋe Amoŋ miep. Amoŋŋe humo akmâ âmbâle mendo nanŋe kotŋe Yosia miep. ");
INSERT INTO tim_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiaŋe humo akmâ âmbâle mendo nanŋe kotŋe Yekonia miep. Akto emilupŋe meyegep. Akto sop ain kepia humo kotŋe Babiloŋ aregât ambolupŋande togom Yuda luâk hikom meyegi. Akto luâk âmbâle meyekmâ purik katmâ kewuguyekbiâ Babiloŋ kepian arim hoŋ bawa akyeŋgim mali. ");
INSERT INTO tim_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloŋ hânân mali aregât kakŋân Yekoniaŋe âmbâle mendo nanaŋ kotŋe Salatie miep. Salatieŋe humo akmâ âmbâle mendo nanŋe kotŋe Serubabe miep. ");
INSERT INTO tim_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeŋe humo akmâ âmbâle mendo nanŋe kotŋe Abiudu miep. Abiuduŋe humo akmâ âmbâle mendo nanŋe kotŋe Eliakim miep. Eliakimŋe humo akmâ âmbâle mendo nanŋe kotŋe Aso miep. ");
INSERT INTO tim_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoŋe humo akmâ âmbâle mendo nanŋe kotŋe Sadoko miep. Sadokoŋe humo akmâ âmbâle mendo nanŋe kotŋe Akim miep. Akimŋe humo akmâ âmbâle mendo nanŋe kotŋe Eliudu miep. ");
INSERT INTO tim_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuduŋe humo akmâ âmbâle mendo nanŋe kotŋe Eleasa miep. Eleasaŋe humo akmâ âmbâle mendo nanŋe kotŋe Mataŋ miep. Mataŋŋe humo akmâ âmbâle mendo nanŋe kotŋe Yakobo miep. ");
INSERT INTO tim_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoboŋe humo akmâ âmbâle mendo nanŋe kotŋe Yosepe miep. Are humo akmâ Mariagât dâtâŋe dâmbiâ malep. Akto Mariaŋe Yesu miep yâk âmâ, “Anutuŋe huŋgun aŋdo giep.” hain dâmaen. ");
INSERT INTO tim_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Akto hain miawakmâ gayi, are Abraham yâkgâlânba miawakmâ gam Dawidi miawagep are luâk kâmotŋe kâmotŋe miawakmâ gambiâ gambiâ luâk kâmotŋe 14 agep. Akto luâk kotŋe Dawidi ainba gam Babiloŋ hânân mali are âmâ luâk kâmotŋe kâmotŋe miawakmâ gambiâ gambiâ akai hainâk 14 agep. Akto ainba gam Anutuŋe nanŋe Kristo huŋgun aŋdo gem hânân miawagep are âmâ kâmotŋe kâmotŋe miawakmâ gambiâ gambiâ akai hainâk 14 agep. ");
INSERT INTO tim_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Akto Anutuŋe Yesu Kristo huŋgunaŋdo gem Mariagât tepŋân meawakto Mariaŋe miep aregât keiŋe amâ hin tatâp. Memeŋe Maria amâ Yosepegât dâtâŋe malep. Ikiŋeâk ikiŋeâk manbela âmâ Anutugât Wâtŋande memeŋe agaŋdo luâkŋe olop bo peniaŋgim maliat. Yân potalakmâ manbela âmâ tepŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tepŋe agep aregât Yosepeŋe Anutugât den lokom malepgât biwiŋande hin nâŋgâep, “Nâŋgât dâtâŋe luâk siâŋe miep gârâmâ luâk unduwâk dewunyeŋân watere aŋun aŋgiwop dâm aregât yoŋâk watbe.” hain nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hain akmâ benŋe aregât nâŋgâm mando asiŋân Humogât aŋelo siâŋe hin dâm magaŋep, “Yosepe gâ Dawidigât hakuŋe hin makgiŋdere nâŋgâ. Anutugât Wâtŋande meme agaŋdo Maria tepŋe aktâp aregât memberâm hanâk han lâuwâ bo akben. Hanâk oloŋmâ emetgân katmâ siân memben. ");
INSERT INTO tim_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dâ hinŋe âmâ bo mendâlân Anutugât Wâtŋande meme agaŋdo nanŋe membiap amâ yâkgât kotŋe Yesu dâm konben. Akto kot aregât keiŋe hin. Yâkgât kâmot bâleŋe akmai aregât dosa pulimbo aregât Anutuŋe yekto huraguwiap.” Aŋeloŋe hain dâm magaŋmâ hepulep. ");
INSERT INTO tim_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Hain dâm magaŋmâ hepundo Yosepeŋe agatmâ den are lokom Maria gala agaŋmâ malep. Hain mando nanŋe mendo Yosepeŋe kotŋe Yesu dâm kolep. Akto ainba peniaŋgim maliat. Akto Anutuŋe aregât keiŋe miawagâk dâm ulikŋân makto Propete siâŋe hin kulemgoep, “Âmbâle sigan siâŋe nanŋe siâ membiap aregât kotŋe Imanue dâm konbai.” dâm kulemgoep. Kot aregât keiŋe amâ hin, Anutuŋe nen olop manmap. ");
INSERT INTO tim_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Luâk kotdâ siâ kotŋe Herote are malep sop ain Maria akto Yosepe Betelehem kepia Yudaia hânân talewân ain manbela Mariaŋe Yesu miep. Mendo manbiâ luâk nâŋgâ nâŋgâyeŋe olop diâgât keiŋe nâŋgâyiŋe dewutâ gagaŋângenba togom Yerusalem kepia Yesu miawagep aregen togom ambolupŋe aiyeŋgum hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Nanaŋ siâ Yuda yeŋgât kembu miawagep aregât diâ kâmŋe dewutâ gagaŋângen ain miawakto ekten. Ekmâ kotŋe mem agatne dâm diâ watmâ hân kâlewângenba togoen aregât emet yâten miawaktâp?” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hain dâmbiâ luâk kotdâ Herote arekŋe hamep akto kepia ambolupŋande nâŋgâm sân sân meyi. ");
INSERT INTO tim_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Akto Heroteŋe sumbe kat kat luâk areyeŋgât humomolupyeŋe akto Mosegât den kârikŋe makmâ kepigi are mem mendugu yekmâ hin dâm aiyeŋguep, “Yeŋe Anutuŋe huŋgun aŋdo gewiap arekŋe kepia wânângen miawakbiap dâmai?” hain dâm aiyeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Hain dâm aiyeŋgumbo hin dâyi, “Anutuŋe makto propete siâŋe hin kulemgoep, “Luâk kembu siâ Betelehem kepia bâlensiâ Yudaia hânân talewân ain miawakbiap. Miawakmâ manmâ nâŋgât kâmot Israe luâk âmbâle yeŋgât kautyeŋe manmâ damunyeŋe akbiap aregât Betelehem kepia bâlensiâ aregât nâŋgâmbiâ agatbiap.” den hain kulemgoep aregât Anutuŋe huŋgun aŋdo gewiap yâkgât hin nâŋgâen Betelehem kepian Yudaia hânân miawakbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Den hain dâmbiâ Heroteŋe nanaŋ are hombaŋ amon agep aregât nâŋgâwerâm luâk nâŋgâ nâŋgâyeŋe olop diâ keiŋe nâŋgâyi are yoŋâk mem oloŋyegep. Oloŋyekmâ diâ miawagep aregât sopgât aiyeŋguep. Aiyeŋgumbo sop magaŋbiâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“Betelehem kepia ain ariŋet. Ain arim yeŋe kârikŋe akmâ nanaŋ are undâgâtmâ mem miawakmâ âmâ togom kepia yâgâten miawagep are makniŋbiâ nâkâ hainâk arim âmâ kotŋe mem agatbian.” dâm heyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hain dâm heyeŋgimbo ariyi. Dâwân arim dewutâ gagaŋângen hân yeŋângen diâ kâmŋe are miawakto egi are siâkâ miawakmâ pagaleŋe yeŋgimbo watmâ arimbiâ nanaŋ talep aregât emet kakŋân kârigem talep. ");
INSERT INTO tim_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tato ekmâ aregât kambiamyeŋe heroŋe humo nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Akto emelan âgâm Mariaŋe nanŋe tambogo akmâ tato yelekmâ nanŋe okot âlep agaŋmâ pâwutyeŋe ligim kotŋe mem agali. Mem agatmâ ito lândem katmâ tâwât dewunŋe siâ me siâyeŋe mem togoyi are akto goli akto lâwin hâkŋe âlepŋe are akto lâwin hâkŋe siâ siâ are waŋi. ");
INSERT INTO tim_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Waŋmâ tatmâ asiŋ yem hin egi. Anutuŋe Herotegâlân bo purik katŋet dâm asiŋân miawakyeŋgimbo agatmâ dâp siângenba purik katmâ kepiayeŋângen ariyi. ");
INSERT INTO tim_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Purik katmâ arimbiâ Yosepeŋe asiŋ yendo Kembugât aŋelo siâŋe miawagaŋmâ hin dâm magaŋep, “Nâŋgât. Heroteŋe Mariagât nanŋe moâk dâm komberâm aregât undâgâtmâ mandâp aregât agatmâ nanaŋ meŋâi meyelekmâ Aigita hânân arim nâŋgât dengât lâmgom manben.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hain dâmbo Yosepeŋe agatmâ nanaŋ meŋâi meyelekto hândâkŋânâk Aigita hânângen agatmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akto ulikŋân Humoŋe den siâ propete siâgât biwiŋân kato kulemgoep are hin, “Nâŋe nanne konmâ oloŋdere Aigita hân hepunmâ purik katmâ togowiap.” den are bunŋe agep aregât Yosepeŋe Herote mombiawân âmâ purikatbian dâm Aigita hânân lâmgom malep. ");
INSERT INTO tim_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Akto luâk diâgât keiŋe nâŋgâyiŋe Herote are bo miawagaŋmâ arimbiâ nâŋgâm biwiŋe bâlimbo kuk agep. Akto luâk diâ keiŋe nâŋgâyiŋe Kotdâ Nanŋe miawagep aregât sop dâm miawakmâ magaŋi aregât nâŋgâm tembe luâklupŋe are huŋgun yeŋgimbo Betelehem kepia ain ariyi. Arim are ewumâk ewumâk kepia bâleŋ maleŋ tali ain nanaŋ miawagi are hombaŋ lâuwâ bo akyeŋgiep are hârogâk yeŋgumbiâ moyi. ");
INSERT INTO tim_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Akto emelâk propete Yeremiaŋe den hin kulemgoep are bunŋe agep, ");
INSERT INTO tim_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Siân âmbâle siâ kotŋe Rahe yâkgât hakulupŋe Rama kepian manbai are siânbaŋe nanaŋlupyeŋe yeŋgumbiâ mombai aregât nâŋgâm inde humo indewai. Aregât luâk âmbâle bikŋande kambiamyeŋe sândugeâk dâm okot âlep akyeŋgimbiâ kambiamyeŋe bo sândugewiap.” hain dâm kulemgoep. Den are bunŋe akto Heroteŋe makto nanlupyeŋe yeŋgumbiâ memelupyeŋe Rama kepian Betelehem ginŋân talep ain indeyi. ");
INSERT INTO tim_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Akto Herote mondo, Yosepe Aigita hânân manmâ giwet ekto Humogât aŋelo siâŋe miawakmâ den hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Emelâk gasa akyeŋgim Mariagât nanŋe kone dâm agi are hârok moyigât agatmâ nanaŋ meŋâi meyelekmenâ Yudaia hânân purik katmâ ariŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hain dâm hepundo Yosepeŋe nanaŋ meŋâi are meyelekto Yudaia hânân purik katmâ togoyi. ");
INSERT INTO tim_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Purik katmâ togombiâ den hin dâmbiâ Yosepeŋe nâŋgâep, “Herote are mondo nanŋe kotŋe Akelao are eweŋaet gewâkŋân kinmâ Yudaia yeŋgât luâk kotdâ mandâp.” dâmbiâ nâŋgâep. Den are nâŋgâm hamewakmâ Yudaia hân ain manberâm han lâuwâ agep. Hain akto giwelân Anutuŋe miawagaŋmâ magaŋdo Yudaia hân hepunmâ Galilaia hânân ariyi. ");
INSERT INTO tim_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilaia hânân arim kepia siâ kotŋe Nasarete ain arim mali. Ain arim manbiâ aregât umbuŋân Anutugât propetelupŋande den kulemgoyi aregât bikŋe hin tatâp, “Yâk âmâ Nasarete kepia ain gâtŋe.” hain tatâp. Den are bunŋe akto Yesuŋe Nasarete kepian malep. ");
INSERT INTO tim_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aregât hamiŋân Yohane tu puli puli luâk yâkŋe âi keiŋe katmâ Yudaia hân kamitŋângen arim mando luâk âmbâle ekberâm arimbiâ hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Anutuŋe damunyeŋe akberâm aktâp aregât agak memeyeŋe bâleŋe makmâ miawakmâ panmâ han biwiyeŋe purik katŋet.” hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Akto ain manmâ den dâm makyeŋgimbo aregât emelâk propete kotŋe Yesaiaŋe hin kulemgoep den are bunŋe agep. Hân kamitŋângen luâk siâ hin dâm tatbiap, “Ye kotdâgât dâp are megatŋet. Akto gimbâŋe ukuleŋe me kundet kokoŋe hâgâm kigilikmâ ârândâŋ ketugumbiâ dâp huraguâk.” Den magep are bunŋe miawakto Yohane miawagep. ");
INSERT INTO tim_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Akto Yohaneŋe âmâ hâk pekeŋe siâ soŋgo kamele aregât dumutŋande mendugum paruli are mem luguakmâ malep. Akto himbân tâkŋe siâ lalep. Akto sotŋe âmâ mumak koaŋe akto duki kotŋe kendemuŋ are nem malep. ");
INSERT INTO tim_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hân kamitŋângen are mando Yudaia hân ambolupŋe akto Yerusalem aregât ambolupŋe akto Yodaŋ tu biken biken tatmâ ariyi aregât ambolupŋande kepia ainba denŋe nâŋgâne dâm yâkgâlân togom menduguyi. ");
INSERT INTO tim_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mendugu akmâ tatmâ yeŋaet agak memeyeŋe bâleŋe are makmâ miawakmâ panbiâ meyekmâ Yodaŋ tuân meyekmâ gem tu puliyekminep. ");
INSERT INTO tim_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Akto Parisaio akto Sadukaio are yeŋgât kâmolân gâtŋe luâk âmbâle dondâŋe tu pulinenegâk dâm yâkgâlân togombiâ yekmâ hin dâm makyeŋgiep, “Ye âmâ niambigât kâmot. Bundâk biwiyeŋe purikato togoâi me? ");
INSERT INTO tim_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Agak memeyeŋe bâleŋe are panbiâ âmâ han biwiyeŋe Anutugâlânâk kindo aregât bunŋe hainare âlepŋeâk akmâ biwiyeŋe irakŋeâk manŋet. ");
INSERT INTO tim_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Akto biwiyeŋande hin bo nâŋgâŋet, “Nen Abrahamgât kâmot manden.” hain bo nâŋgâŋet. Aregât maktere nâŋgâŋet. Anutuŋe dâwiap, “Kât irekŋe Abrahamgât kâmot miawakŋet.” dâmbo âmâ âlepŋe miawakbai. ");
INSERT INTO tim_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Akto hâuŋe ye yeŋgiwiap, aregât den ginŋe siâ maktere nâŋgâŋet. Luâk siâŋe unam are emelâk dâtŋe hâwim lâwin keiŋân kalep are lâwin siâ bunŋe bo yendo kârâm pando gembo kâlâwân ombiâ ombiap. ");
INSERT INTO tim_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Akto agak memeyeŋe bâleŋe makmâ miawakmâ hepunbiâ âmâ biwiyeŋe Anutu ikiŋaelân ari kindo aregât nâŋe tuân katyekberân. Hain katyekmâ mandân are âmâ luâk siâ haminângen togom mandâp aregât kârikŋe humo talaŋdâp. Yâk âmâ luâk Kotdâ. Dâ nâmâ luâk yânŋe aregât nâŋe yâkgât ito are mem gâunmâ goliaŋbeangât dopŋe bo. Yâkŋe âmâ Anutugât Heak akto kâlâp puliyekbiap. ");
INSERT INTO tim_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yâk gagap urutbiapgât mem togom sot koko welamŋe ain gagap urutmâ heŋgemgom âmâ sot bunŋeâk kepilâm emelan kato tatbiap. Dâ gagapŋe âmâ urutmâ ondo kâlâwân ombiap.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sop ain Yesuŋe Galilaia hân hepunmâ arim Yodaŋ tuângen ariep. Arim Yohaneŋe tu puli negâk dâm ariep. ");
INSERT INTO tim_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Arim Yohane magaŋdo Yohaneŋe nâŋgâmbo umatŋe akto Yesugât den are mem ge katbe dâm hin dâep, “Gâŋe nâ tu pulinekberâm nâŋgâlân togoât are ârândâŋ bo aktâp. Gâŋe âmâ nâ tu pulinekmenâ dâine ârândâŋ akbop.” ");
INSERT INTO tim_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hain dâmbo dâep, “Uŋak Anutuŋe nâŋgâp aregât nâŋgâmenâ umatŋe bo agâk. Akto netŋe Anutugât den lokoetŋe aregât Anutuŋe nâŋgâmbo ârândâŋ akberâp.” hain dâep. Hain dâmbo Yohaneŋe nâŋgaŋep. ");
INSERT INTO tim_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nâŋgaŋmâ tu pulimbo agatmâ âgâmbo ainâk himbim dâpŋe pâroŋ âgâmbo Anutugât Heak arekŋe lâut kotŋe kembâ hain are akmâ Yesugât kakŋân gembo egep. ");
INSERT INTO tim_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Gembo ainâk himbimânba Anutuŋe den siâ hin dâep, “Ekŋet. Imâ nâŋgât nanne. Kambiamne are yâkgâlâk nâŋgâm manman aregât ekmâ ukenŋe nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Akto sinduk baniara bâleŋe yeŋgât humoyeŋe Hiaŋgi Amboŋe arekŋe Yesu biwiŋe dop kowerâm agep aregât Anutugât Heakŋe Yesu oloŋdo hân kamitŋângen ariep. ");
INSERT INTO tim_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ain arim sot bâlâk mando hilâm hândâk 40 bo akto mopŋe dondâ aguep. ");
INSERT INTO tim_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mopŋe agumbo âmâ Hiaŋgi Amboŋe arekŋe yâkgâlân arim hin magaŋep, “Gâ bunŋe Anutugât nanŋe mandât akto mopge aguâpgât makmenâ kât irekŋe sot akto ne.” hain dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Magaŋdo Yesuŋe hin dâep, “Bo. Anutuŋe den hin makto kulemgoyi are yendâp, “Luâkŋe sotgâlâk dâm mando âmâ manmanŋe bo miawakbiap. Anutugât denŋe mem lokomâk mando manmanŋe ârândâŋ akbiap.” hain kulemgoyi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hain dâmbo Yesu mem Yerusalem kepia humoân sumbe kat kat emetŋe talep aregât bokŋân oloŋdo âgâep. ");
INSERT INTO tim_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Âgâ kato kindo hin dâm magaŋep, “Anutuŋe makto siâ hin kulemgoyi tatâp, “Anutuŋe kâlân gugum keige hârewopgât aŋelolupŋe huŋgun yeŋgimbo meŋgekbiâ bo guguwerâp.” den hain tatâp aregât gâ Anutugât nanŋe mandân dâmat amâ inba sopanmenâ aŋeloŋe meŋgekŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dâmbo Yesuŋe dâep, “Bâe. Hain bo. Anutuŋe makto siâŋe hin kulemgoep, “Anutu Humoge bo dopkowen.” Den hain tatâp aregât lauge bo lokowerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hain dâmbo mem gimbâŋe kâlep siân oloŋdo âgâep. Âgâm kindo ain hânŋe hânŋe luâk kâmotŋe kâmotŋe kotdâlupyeŋe manmâ ariyi are yeŋgât kotŋe egâliaŋ siâ siâ keiŋe keiŋe are hekalaŋmâ hin dâep, ");
INSERT INTO tim_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Nâŋe ire hârok damunyeŋe akman. Aregât gâ ga okotnân kinmâ ulit niŋmâ nâŋgât nâŋgâmenâ agato damunyeŋe kat gektere damunyeŋe akbiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hain dâm magaŋdo Yesuŋe hin dâep, “Bâe. Hain bo. Anutuŋe den siâ hin dâep are tatâp, Anutu Humoge konok gala agaŋmâ hoŋ agaŋmâ akto ikiŋe den lokoaŋmâ kotŋe mem agatben. Den hain tatâp aregât ya maktât are bo lokowerân. Hiaŋgi Amboŋe, gâmâ hepun nekmâ ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dâmbo hepunmâ ariep. Arimbo Yesu hân kamitŋângen tato aŋelolupŋe togom hoŋ agaŋmâ tângoyi. ");
INSERT INTO tim_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Akto aregât kakŋân hân aregât luâk kotdâ Heroteŋe dâmbo Yohane mem lope kâlegen katbiâ talep aregât pat Yesuŋe nâŋgâm Galilaia hânângen ariep. ");
INSERT INTO tim_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ain arim âmâ Nasarete kepia are hepunmâ Kapanaum kepian ain arim tatmâ malep. Akto Kapanaum kepian ain deŋgân humo siâ kotŋe Galilaia deŋgân aregât dâtŋân tatmap. Akto deŋgân are hân lâuwâ kotyetŋe Sebuloŋ akto Naptali are yetgât ginŋân tatmandat. ");
INSERT INTO tim_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Akto Yesuŋe kepia ain ariep aregât emelâk Anutuŋe dâmbo propete Yesaiaŋe den hin kulemgoep are bunŋe agep, ");
INSERT INTO tim_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebuloŋ akto Naptali hân are Galilaia luâk âmbâleŋe Anutu bo nâŋgaŋmai yâk yeŋgâlai deŋgân akto Yodaŋ tu biken tatmandat. ");
INSERT INTO tim_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Areyetgât ambolupŋande Anutugât bonâŋgâm manmai. Hain manbiâ biwiyeŋe gisap agum hândâgân yendo pagaleŋande siliŋ siliŋ dâm ewuyekto biwiyeŋe pâroŋ âgâwiap. Akto ain hilip aguwai aregât pat katyeŋgiep yâk yeŋgâlân pagaleŋe humo miawakto biwiyeŋe pâroŋ âgâwiap.” den are hain tatâp. Den are bunŋe miawakto Yesuŋe ain malep. ");
INSERT INTO tim_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ain manmâ keiŋe katmâ hin dâm makyeŋgiep, “Anutuŋe damunyeŋe akberâm aktâpgât agak memeyeŋe bâleŋe makmâ miawakmâ hepunŋet.” hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Akto sop ain arim Galilaia bâtgum ginŋân arim luâk lâuwâ emi teu iŋan oloŋmâ manbela yelegep. Siâ âmâ kotŋe Simoŋ kotŋe siâ Petoro akto emiŋe âmâ Anderea yâkŋe waŋgan kinmâ ŋalu ŋalu are bâtgumân iŋangât panmâ kiliat. ");
INSERT INTO tim_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Akto Yesuŋe yelekmâ hin dâm makyetkiep, “Yetŋe nâŋgâlân gambela arine. Hinŋe âmâ iŋangât âi mendat. Dâ nâŋe âmâ tânyetkure luâk nâŋgât kâmot akbaigât âi membiandat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hain dâmbo ainâk dowâk wan me wan hârok hepunmâ Yesu olop arimbela mali. ");
INSERT INTO tim_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Akto arim âmâ emiteu lâuwâ mem miawakyelegep kotyetŋe Yakobo akto Yohane yâk Yebedaiogât nanlogâtŋe. Eweyetŋe olowâk waŋgan tatmâ ŋalu ŋalu iŋangât are mem parutmâ heŋgemgom kili. ");
INSERT INTO tim_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kinbiâ Yesuŋe yetkondo dowâk waŋganba gem eweyetŋe hepunbela Yesu olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Akto Yesu Galilaia hân are hâlâŋmâ kepia bâleŋ bâleŋ den emetŋe talewân ain âgâm Anutuŋe damunyeŋe akberâm agep den pat âlepŋe aregât keiŋe dâm makyeŋgiep. Akto luâk âmbâle kundat keiŋe keiŋe agi are hârok heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hain akto den pat arekŋe Siria hânângen sambelem arimbo nâŋgâm âmâ luâk kundat agi akto hâk hilâlâm olop mali are kâmotŋe kâmotŋe mem yâkgâlân oloŋ yekmâ togoyi. Akto sinduk baniaraŋe mem bâliyegi are akto dewun biri akmâ mali akto luâk kei bâtyeŋe bâli bâliŋe are meyekmâ yâkgâlân togombiâ hârok heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Akto Galilaia hân akto kepia bât bip bip hârok ain tali kotyeŋe humo siâ Dekapoli dâm koli are akto Yerusalem akto Yudaia hân akto Yodaŋ tu biken ain luâk âmbâle kâmotŋe kâmotŋe mindugu akmâ Yesugâlân togoyi. ");
INSERT INTO tim_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Akto Yesuŋe luâk âmbâle kâmot humo are yekmâ âmâ gimbâŋe siân âgâep. Âgâ tato âmâ âi luâklupŋe ginŋân gambiâ ");
INSERT INTO tim_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","den hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Biwiyeŋande yeŋaet nâŋgâmbiâ gembo nen luâk yânŋe manden hain nâŋgâmai amâ Anutuŋe are yeŋgât nâŋgâm himbimgât pat emelâk yeŋgiepgât aregât biwiyeŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Akto bâleŋaet nâŋgâmbiâ biwiyeŋe bâlimbo indem manmai are Anutuŋe hâmbâi mem sândukŋân katyekbiap aregât kambiamyeŋe heroŋe akto manbei. ");
INSERT INTO tim_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Luâk lumbeŋe manmai yâk yeŋgât nâŋgâre âlepŋe akmap. Yâkŋe hân hârokgât ambo akbai aregât biwiyeŋe hinŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Akto bikŋande sotgât tugât umburuk akmâ âmâ tu sot aregâlâk nâŋgâmbiâ humo akmap dop hainâk âlepŋe aknegât nâŋgâmbiâ humo akmap yâk âmâ tepyeŋe pikto sândugewiap aregât biwiyeŋe hinŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Akto luâk âmbâleŋe yeŋgumbiâ hâuŋe bo memai amâ akbiâ âlepŋe akmap amâ Anutuŋe hainâk âlepŋe akyeŋgiwiap aregât biwiyeŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Akto biwiyeŋe Anutu gâlânâk kinmâ kau kau akto ikiŋe denŋe lokom biwi lâuwâ bo akmâ manmai are âmâ Anutu dewunyeŋande ekbai aregât biwiyeŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Akto biwiyeŋande gala konok manne dâmai are Anutuŋe meyekmâ, “Nune nanne baratne.” dâmap aregât biwiyeŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Akto Anutugât den lokom manbaen dâmbiâ gasalupyeŋande kuk akyeŋgimai aregât hanâk denŋe lokom manmai are yeŋgât Anutuŋe damun nenŋe akmap aregât biwiyeŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Akto nâŋgât akmâ manmai are hâk hilâlâm yeŋgim den bâleŋe makyeŋgim hâkyeŋe tunmai. ");
INSERT INTO tim_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hain akyeŋgimbiâ âmâ ainâk hin nâŋgâwai, “Ulikŋân Anutugât propetelupŋe are siânbaŋe hanâk bâleŋe akyeŋgiyi dop hainâk hinŋe hainâk bâleŋe aknengimai aregât siân hâuŋe âlepŋe manmâ himbimân membaen.” dâmai aregât biwiyeŋe heroŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Akto aregât den ginŋe makyeŋgire nâŋgâŋet. Nen âmâ kâtembe mem sot kakŋân katenŋe ukenŋe akmap aregât dopŋe hainâk akmâ yeâmâ luâk âmbâle hut yeŋân manmai. Akto kâtembe are ukenŋe. Gârâmâ bo damunŋe akbiâ âmâ pâlâmŋe akto âmâ gain gain lâuwâŋe ketugumbiâ ukenŋe lâuwâŋe akbiap? Are bo agakŋe. Arekŋe hin me hain agakŋe bo tatâp amâ yân kâim panmâ keinenŋande tâlimaen. ");
INSERT INTO tim_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Akto ye luâk âmbâle hânŋe hânŋe manmai are yeŋgât ululunŋe mandâi. Kepia humo siâ gimbâŋe tek tekŋân tatmap are heambukbiapgât dop bo tatâp. ");
INSERT INTO tim_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Akto kemdâ are gauŋmâ katmâ âmâ bo mem heambukmaen are tek tekŋân katenŋe om pagalembo emet ambolupŋande pagaleŋe yeŋgimbo tatmâ manmai. ");
INSERT INTO tim_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aregât kemdâ pagaleŋe omap dop hainâk yeŋe Anutugât den lokom agak memeyeŋe âlepŋeâk akmâ manbiâ luâk âmbâle yânŋande yekbiâ ârândâŋ akto Eweyeŋe himbimân manmap aregât kotŋe nâŋgâmbiâ humo akbiap. ");
INSERT INTO tim_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Akto siâ makbe. Yeŋe âmâ nâŋgâ yâkgât hin dâmai me bo? “Moseŋe den kârikŋe kulemgoep are akto propete yâkŋe den kulemgoyi are komberâm aktâp.” Nâŋgât hain nâŋgâmai me? Nâŋe âmâ propete yeŋgât den are komberâm bo geân. Bo kârikŋe. Nâŋe are yeŋgât den lokore bunŋe agâkgât geân. ");
INSERT INTO tim_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nâ bundâk makyeŋgiwe. Hân himbim yembiandat dopŋânâk den kârikŋe yem âgâwiap. Ulikŋe siâ yem tik panbiapgât dopŋe bo. Are hârok bunŋe olowâk miawakmâ metewiap. ");
INSERT INTO tim_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aregât luâk siâŋe den kârikŋe konok pâŋe siâ are loŋgaim âmâ bikŋande hainâk akŋet dâm yâk yeŋgâlân arim hain dâm hâwât yekbiap yâkŋe âmâ himbimgât kâmolân dewatim luâk gegeŋe manbiap dâwaen. Hain gârâmâ luâk siâŋe den kârikŋe are lokom manmâ bikŋande hainâk akŋet dâm yâk yeŋgâlân arim hain dâm hâwât yekbiap yâkŋe âmâ himbimgât kâmolân dewatim âmâ luâk humo manbiap dâwaen. ");
INSERT INTO tim_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aregât makyeŋgire nâŋgâŋet. Yeŋe âmâ Anutugât den lokom manmâ Mosegât den kârikŋe makmâ kepikmai are akto Parisaioŋe wan me wan âlepŋe akmai are bo ewangim âmâ himbimgât kâmot bo akbai. ");
INSERT INTO tim_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Bâgilupnenŋande den hin dâm kali, “Gâŋe luâk siâ bo komenâ mombiap. Dâ hain akbiat âmâ Anutuŋe denân katgekto dosa membiat.” hain dâm kali. ");
INSERT INTO tim_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hain gârâmâ nâŋe âmâ maktere nâŋgâŋet. Luâk me âmbâle siâŋe galaŋaet kuk nâŋgaŋbiap are Anutuŋe denân katbiap. Akto luâk siâŋe galaŋaet nâŋgâmbo gemap are humomolupyeŋande menduguyekmâ dâm makmâ hâreyeŋgiwai. Akto luâk me âmbâle siâŋe galaŋaet nâŋgâmbo gembo biwi bâle akmâ heŋgân nâŋgaŋmap are âmâ kâlâpgât pat akmâ dosa umatŋe membiap. ");
INSERT INTO tim_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aregât hin dâre nâŋgâŋet. Yeŋgâlân gâtŋe siâ me siâŋe Anutugât sumbe omberâm akmâ âmâ biwiŋe kepik akto hin nâŋgâwiap. Nâŋe galane umatŋe agaŋân aregât kuk akniŋdâp. ");
INSERT INTO tim_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Hain dâm sumbe are hepundo tato galaŋaelân ariwiap. Arim den yetŋe are makmâ ârândâŋ ketugumbela bo akto ainâk purik katmâ arim sumbe are Anutugât pat ketugum onmenâ âlepŋe ombiap. ");
INSERT INTO tim_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Akto gasagande meŋgekmâ kiapgâlân arim denân kat gekmâ dâm hâregiŋdo tembe lokolupŋande meŋgekmâ kala busiân katgekbâi aregât dâwân arim galage makmâ miawagaŋmenâ yetŋeak nâŋgâm gala agaŋgiwiandat. ");
INSERT INTO tim_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Borâm hâre aŋgiwiandat akto âmâ kala busiân katgekbiâ tatmâ âmâ yân bo gewiat. Hâu hârok puligom kutigitbialân âlepŋe ain gewiat. ");
INSERT INTO tim_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Akto siâ makbe. Moseŋe den kârikŋe kulemgoep are hin dâmbiâ nâŋgâmai. Yeŋgâlân gâtŋe siâŋe galaŋaet âmbenŋe ekmâ kakŋe kom bo membiap. Hain dâmai. ");
INSERT INTO tim_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aregât nâŋe âmâ hin dâre nâŋgâŋet. Yeŋgâlân gâtŋe siâŋe âmbâle siâ ekmâ memberâm nâŋgâm âmâ ikiŋe biwiŋande emelâk miep aregât dosa talaŋdâp. Aregât den memeŋe hin dâwe. ");
INSERT INTO tim_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Gâ hememgât pat akbâtgât dewunge bungenŋe bâleŋe membom dâm nâŋgâm âmâ dewunge are ewum limbâpkowen. Hain akmâ dewunge bikŋe siâ are âlepŋe akto manmenâ ârândâŋ akbiap. ");
INSERT INTO tim_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Akto hememgât pat akbâtgât hainâk bâtge bungenŋe bâleŋe akberâm akto âmâ hârem panben. Hain akmenâ bâtge bikŋe are âlepŋe akto manmenâ ârândâŋ akbiap. ");
INSERT INTO tim_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bikŋande amâ hin dâmai, “Luâk siâŋe âmbenŋaet hâkâŋ akmâ hepunbe dâm aregât kulem esenŋe siâ mem âmbâi hepun hepungât kulemgom waŋmâ huŋgun aŋdo yân ariwiap.” hain dâmai. ");
INSERT INTO tim_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aregât nâŋe âmâ hin dâm makyeŋgiwe. Luâk siâŋe âmbenŋe kondarâ bo akbiap are yân hâkâŋ akmâ hepundo âmâ âmbâle arekŋe luâk siâ mendo âmâ luâk âmbâle lâuwâ lâuwâ dosa membiandat. Akto luâk aŋgâŋe âmbâle hepun hepunŋe mem âmâ yâkâ hainâk dosa membiap.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Akto Yesuŋe den siâ hin dâm dewatiep, “Bâgi hakulupyeŋande hin dâm makyeŋgiyi, “Anutugât meteŋân hin me hain dâm makbai amâ hainâk akbei.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dâ nâmâ hin makyeŋgire nâŋgâŋet. Hinŋe âmâ Anutugât meteŋân dâm bo makbei. Akto areâk bo. Himbimân âmâ Anutuŋe ain tatmap aregât himbimân bo horatmâ makbei. ");
INSERT INTO tim_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Akto hângâlân horatmâ bo makbei. Amâ wangât? Hingât. Anutuŋe keiŋande tâlim tatmap aregât. Akto Yerusalemgât meteŋân bo makmâ horatbei. Amâ wangât? Hingât. Yerusalem amâ Anutu Humoyeŋe yâkgât kepia kautŋe aregât. ");
INSERT INTO tim_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aregât ire maktere nâŋgâŋet. Dumutyeŋe bândup are makbiâ heleŋ bo akbiap. Akto heleŋ are makbiâ bândup bo akbiap. Aregât kautyeŋân horatmâ bo makbei. ");
INSERT INTO tim_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Akto siân me siân bo ewum makbai. Are bo agakŋe. Aregât denyeŋe are bunŋe akto âmâ are dâmbiâ bunŋe akbiap. Akto bo dâmbiâ bo hainâk akbiap. Aregât kakŋân makmâ dewatiwai amâ Hiaŋgi Amboŋande hâwâtyekto miawakbai. ");
INSERT INTO tim_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Akto den siâ hin kulemgoyi are makbiâ nâŋgâmai, “Gasagande dewunge ewum hogombo bokto âmâ gâkâ hainâk dewunŋe ewum hogomenâ bokbiap. Akto gasagande dâtge kom bererek kombo âmâ gâkâ hainâk dâtŋe are kom bererek kowen.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aregât âmâ hin dâre nâŋgâŋet. Luâk bâleŋe gala agaŋben. Ondopge biken hogombo âmâ ondopge bikŋe waŋben. ");
INSERT INTO tim_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Akto luâk siâŋe gâ olop ewangiak ewangiak bâleŋe dâm kiapgâlân meŋgekmâ ari denân katgekmâ gâŋgât hâk pekege timoŋân oloŋmâ meŋgiŋdo âmâ kakŋân olowâk are hainâk mem waŋmenâ lâuwâ lâuwâ membiap. ");
INSERT INTO tim_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Akto luâk siâŋe, “Nâŋgât wan me wan dewunŋe siâ siâ lokom kepia indâgen ari.” dâm makgiŋdo âmâ gâŋe kepia magep ain lokom tângom ewangim indâŋân ari katben. ");
INSERT INTO tim_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Akto luâk siâŋe wan me wan siâ siâgât ulit giŋdo âmâ are waŋben. Akto wan me wan are yân yogan mem manbe dâm makgiŋdo âmâ âlepŋe nâŋgaŋben. Ye hârok hain akmâ manbei. ");
INSERT INTO tim_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Akto ye bikŋande den siâ hin dâmbiâ are nâŋgâmai, “Gâŋe galage âlepŋe biwi heroŋe agaŋben. Dâ gasage are âmâ gasa agaŋben.” Hain dâmai. ");
INSERT INTO tim_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dâ nâmâ aregât hin dâre nâŋgâŋet. Yeŋe gasalupyeŋe yekmâ âmâ gala akyeŋgiwai. Akto ye yeŋgum watyekmâ manmai yâk yeŋgât tânyeŋgum Anutu ulilaŋmâ heroŋe nâŋgâ yeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hain akmâ himbim Eweyeŋaet nanŋe baratŋe bunŋe akmâ manbai. Yâkŋe âmâ makto yanep pagaleŋande luâk âlepŋe me bâleŋe hârok pagaleyekmap. Akto tânâkgât makto luâk âlepŋe me bâleŋe hanâk hologoyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Akto luâk siâŋe ye olop gala konok manne dâm aregât akyeŋgimai yâk konok yeŋe gala akyeŋgimbiâ âmâ Anutuŋe wan hâuŋe yeŋgiwiap? Luâk bikŋande gawamangât puli meyeŋgimaiŋe hain akmai aregât yeŋe luâk bikŋe gasa akyeŋgim are gala bo akyeŋgimbiâ âmâ aregât hâuŋe hâmbâi Anutuŋe ye yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Akto galalupyeŋe yâk konok yekmâ gala katyekmai arekŋe ârândâŋ bo akmap. Luâk âmbâle Anutu bo nâŋgaŋmaiŋe hain akmai. Aregât yâkâ hainâk akbai aregât hâuŋe âlepŋe Anutuŋe bo yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aregât himbimân Eweyeŋande wan me wan akmâ mendo huragumap yekâ hainâk akmâ manbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Akto Yesuŋe den siâ hin makyeŋgiep, “Gâŋe Anutu heroŋe agaŋdere ârândâŋ akbiapgât mene dâm âmâ luâk âmbâleŋe nekbiâ huraguâkgât bo nâŋgâm manben. Hâk mem agat agat akmenâ âmâ himbimân Ewegande gekmâ aregât ukenŋe bo nâŋgâ giŋmâ hâuŋe âlep bo giŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aregât gâŋe luâk umburuk manmai are han kalem akyeŋgim âmâ luâk âmbâleŋe nekbiâ huraguâk dâm aregât bo nâŋgâm manben. Wangât? Hingât. Luâk bikŋande nen bâleŋe bo akmaen dâmai arekŋeak dewunyeŋânâk den emetŋân akto kâmot kepian ain hâkyeŋe mem agatmai. Luâk hain arekŋe kâmot humoân kinmâ kalem akyeŋgimai. Aregât maktere nâŋgâŋet. Hain dâmat are Anutuŋe hâuŋe âlepŋe bo giŋbiap. Emelâk hâuyeŋe yendâp. ");
INSERT INTO tim_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aregât luâk umburuk manmai yâk han kalem akyeŋgiwe dâm bâtge bungenŋe wan akbiat aregât kanegenŋe bo nâŋgâwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yoŋâk akmenâ âmâ galalupgande bo gekmâ aregât keiŋe bo nâŋgâmbiâ âmâ Ewege Anutuŋe yoŋâk yekmâ nâŋgâmapŋe ikiŋak gekmâ nâŋgâmbo ârândâŋ akbiap. Akto kalem akyeŋgimatgât hâuŋe giŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gâŋe âmâ heambukmâ kinmâ Anutu âlepŋe dâm ulilaŋben. Dâ luâk bikŋe âmâ hiaŋgi luâk manmaiŋe hain bo akmai. Yâkŋe âmâ Yuda luâk mendugum tatmaiân me kâmolân ari kinmâ âmâ luâk âmbâleŋe nenekmâ egâliaŋŋet aregât nâŋgâm hâkyeŋe mem agatmâ Anutu ulilaŋmai. Aregât âmâ hin dâre nâŋgâŋet. Yeŋe hain akbiâ âmâ aregât hâuŋe emelâk membiâ bo aktâp. Anutuŋe hain dâm hâuŋe siâ bo dewatim yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gâ âmâ Anutu âlepŋe dâm ulilaŋberâm âmâ emetgân âgâm heambukmâ hâŋgi gugum Ewege tikŋân manbiap yâk ulilaŋben. Akto Ewege tikŋân siâ me siâ ekmâ nâŋgâmapŋe bunŋe mem peniaŋmâ giŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Akto aregât hin dâre nâŋgâŋet. Luâk bikŋande Anutugât keiŋe bo nâŋgâmaiŋe âmâ hin nâŋgâm hilipkomai, “Nengât den kâlep hanâk hanâk ulilaŋdenŋe dowâk nâŋgâm bunŋe nengiwerâp.” hain dâm hilipkomai. Aregât gâŋe luâk hain are bo akmâ âmâ den kâlep bo makmâ ulilaŋben. ");
INSERT INTO tim_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Akto gâ amâ Ewege Anutu irawot bo ulilaŋmenân yâkŋe soŋ nâŋgâ giŋmap. Aregât hanâk hanâk bo makmâ ulilaŋben. ");
INSERT INTO tim_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Aregât gâŋe hin dâm âlepŋe dâm ulilaŋben, “Himbimân Ewenenŋe gâŋgât kotge âlepŋe akto kotge are kârikŋe tato nâŋgâenŋe bunŋe akto manbaen. ");
INSERT INTO tim_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Akto hân ârândâŋ Kembu aknengi. Himbimân gâtŋande lauge lokomai hainâgâk hânân gâtŋe nenŋe lauge lokoenŋe ârândâŋ agâk. ");
INSERT INTO tim_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Akto uŋak ire gâŋe sotnenŋe are dopnenŋânâk nengimenâ nene. ");
INSERT INTO tim_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Akto luâk âmbâle bikŋande bâleŋe siâ siâ aknengimbiâ âmâ are yeŋgât dosayeŋe hanâk hepun yeŋgim manmaen dop hainâk gâŋe dosanenŋe are hepun nengiwen. ");
INSERT INTO tim_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nen bo dop nenguwen. Akto bâleŋânba kotgâm menenekben. A bundâk.” Yeŋe hain dâm Anutu ulilaŋbei. ");
INSERT INTO tim_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aregât luâk âmbâle bikŋande bâleŋe siâ siâ akyeŋgimai are yeŋgât dosa hepun yeŋgimbiâ âmâ âlepŋe. Aregât himbimân Eweyeŋande yeŋgât dosa hainâk hepun yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Are âmâ luâk âmbâle bikŋande bâleŋe siâ siâ akyeŋgimai are yâk yeŋgât nâŋgâm âmâ benŋe himbimân Eweyeŋande yeŋgât dosa hainâk bo hepun yeŋgiwiap. Dâ hepun yeŋgimbiâ âmâ benŋe dosayeŋe hepunyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Akto hiaŋgi luâkŋe hin dâmai, “Luâk âmbâle bikŋande nen hâk hilâlâm nâŋgâm Anutu ulilaŋmaen are nâŋgâm nen nenekmâ egâliaŋŋet.” dâm aregât sot hepunmâ hâmeyeŋe oloŋbiâ gembo hewugewai are Anutuŋe yekmâ hâuŋe âlepŋe bo yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aregât ye hain bo akbei. Yeŋe âmâ sot hepunmâ âmâ tu puliakmâ dumutyeŋe kelu ketugu akmâ manbei. ");
INSERT INTO tim_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hain akbiâ yekmâ âmâ sot hepunmâ mandâigât keiyeŋe bo nâŋgâwai. Eweyeŋe Anutuŋe bo egekŋe ekmapŋe keiyeŋe yoŋâk memai are nâŋgâm aregât hâuŋe âlepŋe yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Hângât tâwât dewunŋe siâ siâ tiŋe nemai akto dek saŋ saŋŋe hâreyeŋgimai akto motmot akmap akto kâmbu meyeŋgimai aregât yeŋe dondâ tat nengiâkgât bo undâgâtbei. ");
INSERT INTO tim_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Are âmâ himbimân tiŋe bo neyeŋgimap akto dek saŋ saŋŋe bo igim hâreyeŋgimap akto motmot bo akmap akto kâmbu bo meyeŋgiwai aregât wan me wan bunŋe kârikŋe tat yeŋgiwiap. Aregât Anutuŋe pat katyeŋgiep are himbimân tatâp ain dewatimbiâ bo gulip akyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tâwât dewunŋe siâ siâyeŋe katbiâ tat yeŋgimap ainâk biwiyeŋe kinmap aregât himbimgât nâŋgâmbiâ âgâwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Akto dewunyeŋe âmâ pagaleŋe dop hainare aktâp. Dewunyeŋe âlepŋe tato ain âmâ âlepŋe ekmâ bam gutbai. ");
INSERT INTO tim_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dâ dewunyeŋe bâlimbo âmâ biwiyeŋe hândâk humo dâgâwiap aregât biwiyeŋân pagaleŋe tatâp are bokbiap âmâ biwi nâŋgâ nâŋgâyeŋe pâlâmŋe akbiap. ");
INSERT INTO tim_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nanaŋ konokŋe luâk kotdâ lâuwâ yâk yetgât den lokom âmâ âlepŋe hoŋ bo manyetkiwiap. Siâ gala agaŋmâ siâ âmâ hâkâŋ agaŋbiap. Akto siâgâlângen dewatim siâ âmâ hamiaŋbiap. Puli siâ siâgât ukenŋe nâŋgâmai yâkŋe âmâ gain gain Anutugât den lokom manbai? ");
INSERT INTO tim_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ye manman yeŋaet nâŋgâmâk akmâ hin bo dâwei, “Wan arekŋaet mem nem manbaen? Akto hâknenŋaet nâŋgâm wan mem manmâ luguakbaen.” dâm nâŋgâmâk bo akbei. Amâ hingât. Bâin dâŋet. Manmanyeŋande bunŋe me sotŋe bunŋe? Akto hâkgande bunŋe me hâk pekegande bunŋe? ");
INSERT INTO tim_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aregât siâ maktere nâŋgâŋet. Lâut are ekŋet. Arekŋe âmâ âi bo ketugumai. Akto kalamŋânba sot wan bo mem katmai. Akto sot hapatet bo ketugum âmâ alekŋe bo mem katmai. Hain bo akmai amâ himbimân Eweyeŋande hanâk sot mem miawak yeŋgimap. Ye lâut bo. Ye luâk aregât Anutuŋe dowâk tânyeŋgumap. ");
INSERT INTO tim_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Akto yeŋgâlân gâtŋe siâŋe nâŋgâm hanoko akmâ âmâ manman sopŋaet âlepŋe kâlep mem dewatim manbiapgât dopŋe bo tatâp. ");
INSERT INTO tim_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Akto sâŋgum lâuwâ lâuwâ aregât nâŋgâm han lâuwâ akbiâ bâliwiap. Aregât hin dâre nâŋgâŋet. Lâwin buluŋe are ekŋet. Arekŋe âmâ sâŋgum lâuwâ lâuwâgât âi bo ketugumap. ");
INSERT INTO tim_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Buluŋe are âlep âlep aregât luâk siâ kotŋe Salomo ulikŋân malep yâkŋe sâŋgum lâuwâ lâuwâŋe kulem melem âlep âlep hain are mem malep arekŋe buluŋe are bo ewangiep. ");
INSERT INTO tim_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pâloŋângen siâ me siâ buluŋe uŋak miawakmap akto hole bererek âgâm gembo ombiâ bo akmap aregât Anutuŋe dâmbo hanâk kulemŋe âlepŋe miawakmap aregât Anutu bo nâŋgaŋmâ ketelaŋmâ manmaiŋe yâk yeŋaet gai hainâk dâmbo wan me wan miawakyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Are nâŋgâm heŋgemgowei. Are ekmâ nâŋgâm âmâ bo hanokoakmâ âmâ hin bo dâwei, “Wan nemberen me wan lalakberen?” ");
INSERT INTO tim_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Are âmâ luâk bikŋe Anutu bo nâŋgaŋmai arekŋe âmâ puli me sâŋgum me siâ siâ aregât nâŋgâmbiâ humo akmap. Hain akbiâ bâlimap aregât hain bo akmâ manbei. Are âmâ benŋe himbimân Eweyeŋande nâŋgâ yeŋgimap aregât hâk peke bâlâk bo manmai. ");
INSERT INTO tim_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yeŋe âmâ Anutuŋe damun nenŋe akbiapgât akto yâkgât agak meme ârândâŋ dâp ain han nâŋgâ nâŋgâyeŋe ulikŋân katbiâ yembiâp. Akto aregât kakŋân Anutuŋe siâ me siâ bikŋe are hârok yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aregât yeŋe agatmâ umatŋe gain hin arekŋe miawak nengiwiap hain dâm aregât nâŋgâmbiâ humo bo akbiap. Agatmâ miawakbiap are âmâ agatmâgât pat. Uŋak iregât hain are miawak nengiâp are ârândâŋ agâk dâm aregât kakŋân han lâuwâ bo akŋet.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesuŋe den siâ hin dewatim makyeŋgiep, “Anutuŋe den âiân katyekbopgât yeŋe luâk bikŋe den âiân bo katyekbei. ");
INSERT INTO tim_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dâ yeŋe yâk yeŋgât den dâm hâre yeŋgiwai dop hainâk Anutuŋe ye dâm hâre yeŋgiwiap. Akto yeŋe siâ siâ akyeŋgiwai dop hainâk Anutuŋe mem purik katmâ akyeŋgiwiap aregât siâgât bo dâm hâreyeŋgiwei. ");
INSERT INTO tim_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aregât den dopŋe hin dâre nâŋgâŋet. Gâŋe galagaet dewunŋân gagap bâlensiâ tatâp are ekmâ âmâ guge dewungân gagap humo dondâ tatâp are bo ektât are ârândâŋ bo aktâp. ");
INSERT INTO tim_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gagap humo guge dewungân tatâp are bo ekmâ galagaet dewunŋân tatâp aregât hin dâmenâ ârândâŋ bo akbiap, “Galane kin. Gagap mem pan giŋbe.” dâwiat. ");
INSERT INTO tim_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hiaŋgi luâk gâ. Guge dewungân gagap humo tatâp a soŋ mem panakmâ âmâ ekmâ dewunge hulaŋ akto âmâ ekmâ heŋgemgom âmâ galagaet dewunŋân gagap bâlensiâ tatâp are memenâ ârândâŋ akbiap. ");
INSERT INTO tim_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yeŋe Anutugât sot are dua bo yeŋgiwai. Hain akbiâ âmâ yeŋguwai. Akto puli umatŋe are mem bau kâit bo yeŋgiwai. Hain yeŋgimbiâ âmâ igim hârem purik dâm âmâ yeŋgiwai.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Akto Yesuŋe den siâ hin dâm makyeŋgiep, “Yeŋe hin aregât undâgâtmâ Anutu magaŋbiâ âmâ tân yeŋguwiap. Akto emet ginŋân kinmâ woa dâmbiâ hâŋgi amboŋande meyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aregât Anutu aikomapŋe den hâuŋe nâŋgâmap. Undâgâtmapŋe mem miawakmap. Woa dâmap are âmâ hâŋgi mem kalaŋmap. ");
INSERT INTO tim_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aregât hin dâwe. Yeŋgâlân gâtŋe siâŋe nanŋande sotgât ulilaŋdo âmâ kât bo waŋmap. ");
INSERT INTO tim_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Akto iŋangât ulilaŋdo âmâ gipmaŋ bo waŋmap. Bo. ");
INSERT INTO tim_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Akto ye luâk bâleŋande nanaŋ lepatlupyeŋe damun akyeŋgim hin are yeŋgimai aregât dopŋe are ewangim Anutu himbimân manmapŋe luâk siânbaŋe ulilaŋmai are yeŋgât okot nâŋgâm dowâk wan ulilaŋmai are yeŋgimap. ");
INSERT INTO tim_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Akto den dâm makyeŋgiân aregât keiŋe hin. Yeŋe bikŋande âlepŋe aknengiŋetdâm hârok âlepŋe tân yeŋgum manmâ âgâwei. Aregât âmâ Moseŋe akto propete luâkŋe Anutugât den kârikŋe kulemgoyi aregât keiŋe hainâk tatâp. ");
INSERT INTO tim_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Hilip agu hilip agugât kepia aregât dâp are humo akto pempemâk aregât dâp humo ain âlepŋe ari ari aregât luâk dondâŋe arimai. Yeŋe âmâ ain bo ariwei. Ye dâp gâwikŋânba ariwei. ");
INSERT INTO tim_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Are âmâ manman kârikŋe aregât dâp amâ gâwik gâwikŋe, heambuk heambukŋe akto yoŋâk yemap. Dâp are watmâ luâk âmbâle undup akmâ bo arimai. Dâ konok konokŋe ain arimai. Ye âmâ dâp are watmâ ariwei. ");
INSERT INTO tim_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Propete luâk hiaŋgi arekŋe âmâ hâkyeŋe lama hâk yeukŋe hainare dâ hanyeŋe âmâ dua metŋe han hainare aregât yâk yeŋgât damun agaŋgim manbei. ");
INSERT INTO tim_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Siâ siâ Bunŋe bo aregât nâŋgâm kepilâyekbei. Giat ain kewu bunŋe memaen mon? Me kândenân ham bunŋe miawakto memaen mon? ");
INSERT INTO tim_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lâwin âlepŋân bunŋe âlepŋe miawakmap. Lâwin bâleŋân bunŋe bâleŋeâk. ");
INSERT INTO tim_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Aregât lâwin âlepŋânba bunŋe bâleŋe bo miawakmap akto lâwin bâleŋânba bunŋe âlepŋe bo miawakmap. ");
INSERT INTO tim_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aregât ire maktere nâŋgâŋet. Lâwin siâ bunŋe âlepŋe bo kindo âmâ kârâm ondenŋe ombiap hain. ");
INSERT INTO tim_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yeŋe luâk keiyeŋe ekmâ gain gain akmâ iare akmai aregât nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Akto aregât hin makbe. Luâk âmbâle nogonmâ âmâ kotdâ nenŋe kotdâ nenŋe hain dâm nogonmai yâk hârokŋe himbim kepian bo ariwai. Himbimân Ewenaet denŋe lokom manmaiŋe âmâ ariwai. ");
INSERT INTO tim_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Luâk dondâŋe sop humoân hin dâm makniŋbai, “Kotdâ ire nâŋgâ. Nenŋe gâŋgât kotgaet akmâ denge makmâ miawakmâ makyeŋgiyion. Akto gâŋgât kolân konmâ sinduk baniara bâleŋe watyeŋgienŋe luâk hepun yekmâ ariyi. Akto gâ gogonmâ kulem keiŋe keiŋe are ketuguyion.” ");
INSERT INTO tim_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","hain dâmbiâ âmâ nâŋe hin dâm makyeŋgiwian, “Nâ ye bo nâŋgâ yeŋgiân. Nâŋgâlân bunŋe bo dewatiyigât hepun nekmâ ariŋet. Ye amâ bâleŋe meme luâk.” hain dâwian. ");
INSERT INTO tim_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Aregât den ginŋe ire maktere nâŋgâŋet. Luâk siâŋe denne ire nâŋgâm lokomapŋe âmâ dop hinare aktâp. Luâk nâŋgâ nâŋgâŋe olop yâkŋe emet are gimbâŋe kârikŋân ketugumbo kilep. ");
INSERT INTO tim_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Emet kât kakŋân mâŋgiep aregât tu tânâk humo gembo âmâ ugurup humo gam lokowerâmbo âmâ kârikŋe akmâ ŋâŋâk kilep. Dop hain. ");
INSERT INTO tim_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dâ luâk siâŋe denne ire nâŋgâm laune bo lokomapŋe âmâ dop hin are aktâp. Luâk nâŋgâ nâŋgâŋe bo siâŋe emet nupiânâk ketuguep dop hain are. ");
INSERT INTO tim_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ketugumbo kindo tu seru humo pando ugurup humoŋe togombo emet are gagai akmâ kom bâliep.” Yesuŋe hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesuŋe Anutugât den keiŋânbak nâŋgâm makyeŋgiep. Akto biwiyeŋân kalepgât denŋe nâŋgâmbiâ dâtŋe akto hin dâyi, “Mosegât den kepikmâ maknengimai are hârok ewangi yektâp.” hain dâm yâkgât nâŋgâmbiâ humo agep. ");
INSERT INTO tim_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Akto Yesuŋe den makmâ metem gimbâŋânba gembo luâk âmbâle biwirâŋe watbiâ olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Akto luâk siâ diwi kârikŋe akmâ malep arekŋe Yesu ekmâ enemŋân togom pâwutŋe ligim hin dâm magaŋep, “Humo, kârikŋege tatgiŋdâpgât makmenâ diwine bo akniŋâk mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hain dâmbo Yesuŋe hâkŋe mem howaim kinmâ hin dâep, “Âlepŋe, nâŋgâ giŋdângât diwige are pandak giŋâk.” dâmbo ainâk diwi bo agaŋdo hâkŋe âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Âlepŋe akto ainâk Yesuŋe magaŋmâ hin dâep, “Gâ iregât den pat luâk bo makyeŋgim âmâ yânâk arim sumbe kat kat luâk damun yâkgâlân konok ari. Arimenâ keige gekmâ nâŋgâmbo âmâ benŋe Moseŋe wan me wan iregât den kârikŋe kulemgoep are lokom Anutugât sumbe omben. Sumbe omenâ are ekmâ nâŋgâm heŋgemgowei.” dâm huŋgun aŋep. ");
INSERT INTO tim_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Akto arewa arim kepia siâ kotŋe Kapanaum ain arim âgâmbo Roma yeŋgât tembe loko are yeŋgât humoyeŋe siâŋe yâkgâlân arim den hin dâm ulilaŋep, ");
INSERT INTO tim_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Humo, nâŋgât hoŋ bawane siâ kundat akmâ hâk hilâlâm bâleŋe umatŋe miawagaŋdo kei bâtŋe kâregembo yem tatâp.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","dâep, “Âlepŋe, arim mem heŋgemgowerân.” dâep. Hain dâm magaŋdo ");
INSERT INTO tim_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","hin dâep, “Humo, nâ luâk âlepŋe bo mandân aregât nâŋgât emelan bo âgâwerât. Inâk kinmâ denâk makmenâ âmâ nâŋgât hoŋ bawane are âlepŋe agâk. ");
INSERT INTO tim_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Akto nâ gai luâk kotdâ yâk yeŋgât den lokom manman akto nâ luâk humonande nâŋgâ niŋmâ damunyeŋeak dâm katnegep. Aregât nâŋe tembe lokolupne den makyeŋgire lokomai akto yâk yeŋgâlân siâgât, “Gâŋe siâ ari.” hain dâm magaŋdere âmâ âlepŋe arimap. Akto siâgât, “Gâ ga.” dâre âlepŋe gamap. Akto hoŋ bawane siâ ekmâ, “Âi ire me.” dâre âmâ âi are hainâk memap. Aregât gâ Humo inâk kinmâ denâk makmenâ âlepŋe agâk.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hain dâmbo Yesuŋe den are nâŋgâmbo dâtŋe akto purik dâm hamiŋân togom mali are hin dâm makyeŋgiep, “Den bunŋe maktere nâŋgâŋet. Israe kâmot ire yeŋgât hutyeŋân luâk siâŋe nâŋgât keine nâŋgâm heŋgemgoep hainare siâ bo ekman. Roma luâk irekŋe hârok ewangi yektâp. ");
INSERT INTO tim_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hâmbâi hân tuŋguŋângen biken biken ainba luâk biwirâŋe togom âmâ Abraham, Isaka, Yakopo yâk olop manmâ Anutugât kepian âgâm menduguakmâ ain sot keiŋe keiŋe nem heroŋe akbai. ");
INSERT INTO tim_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dâ emelâk Anutuŋe Yuda luâk damunyeŋe akminep are panyekto yâk âmâ kepia ginŋângen hândâgân gem manmâ indem kamboŋmâ manbai.” ");
INSERT INTO tim_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Hain dâm makyeŋgim purik dâm tembe loko humoyeŋe are ekmâ hin dâm magaŋep, “Gâŋe biwige nâŋgâlân katmâ hain nâŋgât aregât bunŋe miawakgiŋdâp. Gârâmâ bam ari.” hain dâmbo bam arimbo sop ainâk hoŋ bawaŋe are âlepŋe akto egep. ");
INSERT INTO tim_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Akto arewa arim Petorogât emelan âgâmbo Petorogât hewonŋe kundat akmâ hâk kâlâp akmâ yem tato egep. ");
INSERT INTO tim_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bam ekmâ bâtŋân mendo ainâk kundat are bo agaŋep. Bo agaŋdo agatmâ sot om waŋep. ");
INSERT INTO tim_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Waŋdo nem tato emet dâgâwerâm akto âmâ sinduk baniara bâleŋande luâk âmbâle bikŋe kautyeŋân meyegi are meyekmâ yâkgâlân togoyi. Meyekmâ togombiâ Yesuŋe lauŋande makmâ watyekto sinduk baniara bâleŋe arekŋe hepun yekmâ ariyi. Akto kundat agi arekâ hainâk lokoyekmâ togombiâ yekmâ mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hain agep aregât emelâk propete Yesaiaŋe den siâ hin kulemgoep are bunŋe agep amâ hin, “Nen kundat umatŋe miawak nengimbo me wan me wan pâpkom nâŋgâm hilipkomaen aregât yâkŋe bâleŋe are mendo bo agep.” dâm kulemgoep den are bunŋe akto Yesuŋe kundatdâ dondâ heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuŋe hain akmâ tân yeŋgumbo ainâk luâk âmbâle biwirâŋe yâkgâlân togom ândeaŋmâ kinbiâ Yesuŋe are yekmâ, “Bâin, waŋga mem indâgen bam arine.” dâm aposololupŋe makyeŋgiep. Hain dâmbo waŋga mem bâtgum humo are hâtikom ariwerâm agi. ");
INSERT INTO tim_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ariwerâm akbiâ Mosegât den makmâ miawagi are yeŋgâlân gâtŋe siâŋe bam hin dâm magaŋep, “Apo, gâ iregen me aregen ariwerâm âmâ makniŋmenâ olop ariwaet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hain dâmbo Yesuŋe hin dâm magaŋep, “Yo âmâ lâwin timopŋân yemap. Dâ lâut âmâ lâwin bât bâtŋân kelom tatmai. Dâ nâmâ luâk akmâ geân aregât nâŋgât emet âmâ bo tatniŋdâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Akto luâklupŋe yeŋgâlân gâtŋe siâ arekŋe yâkgâlân togom hin dâm magaŋep, “Humo, nâŋgâ niŋmenâ arim ewene soŋ hangom âmâ benŋe purik katmâ togore âmâ olowâk ariwaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hain dâmbo Yesuŋe hin dâm magaŋep, “Hain bo. Luâk âmbâle momoŋandeak momoŋelupyeŋe hangoyekŋet, Dâ gâmâ hinŋe nâ wat nekmenâ olowâk arine.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hain dâm waŋgan âgâmbo aposololupŋe olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Arim manbiâ seru humo sân sânâk pando haru are bâliep. Akto haruŋe waŋga kâlegen gewerâm agep ain Yesu asiŋ yiep. ");
INSERT INTO tim_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Akto aposololupŋande goaŋmâ hin dâm magaŋi, “Humo, haruŋe kawut nenekberâm aktâp aregât agatmâ tân nengu.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hain dâmbiâ hin dâm makyeŋgiep, “Bo nâŋgâniŋmâ kepilânekmai. Ye wangât hamewaktâi?” dâm agatmâ seru pando haru bâliep are den makyetkimbo ainâk nâŋâgâyiat. ");
INSERT INTO tim_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nâŋâgâmbela ekbiâ dâtŋe akto hin dâyi, “Ae, yâkŋe seru akto haru makyetkimbo yâkgât den lokom nâŋgat aregât luâk ire gain hinare?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Akto bâtgum are hâtikom indâŋân bam Gadara hânângen ariyi. Arim manbiâ luâk lâuwâ siâ sumângenba togom manbela yelegi. Yâk yetgât keiyetŋe hin. Sinduk baniara bâleŋande kaut yetŋân mendo metŋe akmâ luâk âmbâle hârok mem bâli yekte dâm manminiat. Akto dâwân togombela âmâ luâk âmbâle hârokŋe hamewakmâ ain bo arimini. Keiyetŋe hain. ");
INSERT INTO tim_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lâuwâ arekŋe togom Yesu peniaŋmâ den hin dâm magaŋiat, “Gâ Anutugât nanŋe, gâ gain gain aknetkiwerâm togoât? Gâŋgât sop bo tâlâgumbo hâk hilâlâm netkiwerâm togoât me?” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akto indâgen bau kâmot humo siâ tâmut nem mali. ");
INSERT INTO tim_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Akto sinduk baniara bâleŋe arekŋe Yesu magaŋmâ hin dâyi, “Gâŋe wat nenekberâm âmâ huŋgun nengimenâ bau biwiyeŋân gene.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hain dâmbiâ Yesuŋe, “Âlepŋe geŋet.” dâep. Hain dâmbo luâk lâuwâ are hepun yelekmâ bau hârok biwiyeŋân geyi. Gembiâ bau arekŋe pârigim arim indâgen bâtgum siân sopanbiâ tuŋe lauyeŋân pikto moyi. ");
INSERT INTO tim_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mombiâ bau damunlupyeŋande arim kepia yeŋângen âgâm Yesuŋe sinduk baniara bâleŋe watyekto bau biwiyeŋân gembiâ moyi aregât den pat are kepia ambolupŋe makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Makyeŋgimbiâ ainâk luâk âmbâle hârokŋe Yesu are ekne dâm kepiayeŋânba geyi. Gem kepia yeŋe hepunmâ ariâkgât wârakmâ magaŋi. ");
INSERT INTO tim_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Magaŋbiâ Yesuŋe hepun yekmâ ariwerâm waŋgan âgâm bâtgum biken hâtikom arim ikiŋe kepia ain ariep. ");
INSERT INTO tim_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Arim kindo luâk bikŋande galayeŋe siâ bâtŋe keiŋe mom kârikŋe akminep are temân katmâ yâkgâlân lokom togombiâ Yesuŋe are biwiyeŋe ekmâ nâŋgâm luâk kundatdâ are hin dâm magaŋep, “Bâleŋe akmâ manmâ gaen aregât dosa puli giŋdân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hain dâmbo Mosegât den kârikŋe makmâ kepikmâ makmini are yeŋgâlân gâtŋe bikŋande biwiyeŋân hin nâŋgâyi, “Anutu ikiŋak âmâ dosayeŋe puli yeŋgimap ina luâk yânŋe irekŋe Anutu ewangiwerâm aktâp imâ bâliâp.” hain dâm nâŋgâmbiâ bâliep. ");
INSERT INTO tim_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Biwiyeŋânâk hain nâŋgâmbiâ Yesuŋe biwiyeŋe ekmâ nâŋgâm hin dâm makyeŋgiep, “Hanyeŋande wangât den bâleŋaet nâŋgâi? ");
INSERT INTO tim_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gain gain arekŋe owâiŋe luâk bâtŋe keiŋe mom kârikŋe akmap ire hin dâm magaŋberân. Anutuŋe dosage hepungiŋdâp hain dâm magaŋberân me hin dâm magaŋberân. Agatmâ temge are lokoakmâ ari? ");
INSERT INTO tim_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aregât maktere nâŋgâŋet. Nâ luâk akmâ geângât dosayeŋe hepun yeŋgiwerâmgât Anutuŋe makmâ niŋep aregât keiŋe ekmâ nâŋgâŋet.” dâm makyeŋgiep. Luâk kundatdâ are hin dâm magaŋep, “Agatmâ temge loko akmâ emetgângen bam ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hain dâmbo agatmâ temŋe lokoakmâ emetŋângen bam ariep. ");
INSERT INTO tim_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Arimbo luâk âmbâleŋe are ekmâ otneyeŋe arimbo hin dâyi, “Yesuŋe Anutugât kârikŋân kinmâ agak meme bo agakŋe aktâp.” dâm Anutu kotŋe mem agatmâ kinmâ maŋganli. ");
INSERT INTO tim_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Akto Yesu ainba arim gawamangât puli meme luâk kotŋe Mataio puli emetŋân tato ekmâ hin dâm magaŋep, “Nâŋgâlân dewatimenâ nâ olop mande.” dâep. Hain dâmbo agato olop ariyiat. ");
INSERT INTO tim_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Arim sot nemberâm âmâ hoŋ bawa olop emetŋân âgâmbiâ Romagât puli meme akto bâleŋe meme luâk biwirâŋe yâk yeŋgâlân arimbiâ Yesu akto luâklupŋe olowâk sot neyi. ");
INSERT INTO tim_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nem tatbiâ Parisaio luâk bikŋande yekmâ Yesugât hoŋ bawalupŋe hin dâm aiyeŋguyi, “Wangât eweyeŋande Romagât puli meme akto bâleŋe meme luâk olop tatmâ sot nendâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hain dâm aiyeŋgumbiâ Yesuŋe den are nâŋgâm hin dâm makyeŋgiep, “Hin nâŋgâm heŋgemgowei. Âlepŋe mandâi yeŋgâlân are doktaŋe âi mene hain bo dâm arimai. Kundat aktâi are yeŋgâlân âi mene hain dâm arimai. ");
INSERT INTO tim_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ulikŋân Anutuŋe makto luâk siâŋe kulemgoep are hin, “Yeŋe dosayeŋaet akmâ âmâ soŋgo wan gâim om nâŋgâlân katmai aregât bo nâŋgâm egâliaŋman. Gala konok akmâ manŋetgât nâŋgâm egâliaŋman.” den hain tatâp aregât keiŋe yeŋe nâŋgâmbiâ huraguâkgât mendugum den âi mem magaŋgi goaŋgi akmâ manŋet. Aregât maktere nâŋgâŋet. Luâk bikŋande, “Nen luâk âlepŋe akmâ yân târârâgâk manmaen.” hain dâmai luâk hain are mem oloŋyekbe dâm bo geân. Bo kârikŋe. Nâmâ luâk bâleŋe meme oloŋ yekbiangât togoân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hain dâmbo Yohane tu puli keiŋe kalep are olop mali arekŋe Yesugâlân togom hin dâm aikoyi, “Nen Anutugâlân okot âlep agakgât akto Parisaio luâk nenŋe âmâ sot hepunmâ manmaen. Dâ luâklupge âmâ wangât sot sapa bo akmai?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hain dâmbiâ hin dâep, “Aregât den ginŋe siâ makbe. Luâk kotdâŋe âmbâle siâ mendo âmâ kâmotlupŋe olop manmâ okot bâle akmâ sapa bo akmai. Hâmbâi bikŋande menekbiâ bo aktere sop ain nâŋgâm indem tatmâ sot sapa akmâ manbai. ");
INSERT INTO tim_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Niŋande sâŋgum tâmbâŋân irakŋande katmâ parutbop? Bo. Irakŋande tâmbâŋe are oloŋdo dondâ torokbopgât hain bo akmaen. ");
INSERT INTO tim_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Me niŋande waiŋ irakŋande hâpu tâmbâŋân kâimbo gewop? Bo. Waiŋ irakŋande hâpuŋe tâmbâŋe tâlim hogombo waiŋ akto hâpu bâliwopgât hain bo akmaen. Waiŋ irakŋande hâpu irakŋân gembo âlepŋe akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuŋe den hain dâm makyeŋgim kindo luâk damun siâŋe togom kâŋgom hânân gem âmâ hin dâm ulilaŋep, “Baratne hinŋe mondâp aregât nâ olop arim momoŋânba goaŋmenâ agalâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hain dâmbo Yesuŋe agatmâ arimbo luâklupŋe olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Arim âmbâle siâ hutyeŋân kilep aregât keiŋe hin. Âmbâi are dewutâyeŋe gam yeŋgumap dop hain bo geminep. Sop kâlep gembo mando hombaŋ bât bip bip hârok keiân lâuwâ bo agep. ");
INSERT INTO tim_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yâkŋe Yesugât hamiŋân arim hin nâŋgâep, “Nâ sâŋgumŋeâk howaim âlepŋe akberân.” nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hain nâŋgâm yoŋâk watmâ sâŋgum kâlep are mem howaimbo Yesuŋe purik dâm ekmâ hin dâep, “Woe, meŋ, gâŋe biwige nâŋgâlân katâtgât Anutuŋe nâŋgâ giŋdo kundat are uŋak bo akgiŋdâp.” dâmbo ainâk âmbâle are âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Akto Yesuŋe arim luâk damun yâkgât emetŋân âgâm âmâ uruwaku waitbiâ nâŋgâep. Uruwaku waitmâ den magaŋgi goaŋgi akbiâ ekmâ nâŋgâm hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Âmbâi sisik ire bo mondâp. Yân asiŋ yendâp aregât gem ariŋet.” dâep. Hain dâmbo nâŋgâm giriŋaŋi. ");
INSERT INTO tim_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Giriŋaŋbiâ den makyeŋgimbo gem sopali. Gem arimbiâ âmâ baratŋe yiep ain bam bâtŋân mem agato âlepŋe akmâ agatmâ kilep. ");
INSERT INTO tim_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Akto kulem miep aregât den pat magaŋgi goaŋgi akbiâ kepiaŋe kepiaŋe arimbo hân humo are ambolupŋande nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Akto Yesuŋe kepia are hepunmâ arimbo luâk lâuwâ dewunyetŋe bokbokŋe arekŋe hamiŋân arim den hin dâm magaŋiat, “Woe Dawidigât kâmolân gâtŋe gâ den makgiŋdetŋe netgât okot nâŋgâ netki.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hain dâm watmâ arimbela emetŋân âgâmbo watmâ âgâm enemŋân kinbela aiyetkum hin dâep, “Biwiyetŋande gain gain nâŋgat? Maktere âlepŋe dewunyetŋe hulaŋ akberâp me bo?” dâmbo dâyiat, “Humo, âo, kârikŋege tat giŋdâpgât nâŋgâgiŋdet.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hain dâmbela dewunyetŋe mem howaim hin dâep, “Han biwiyetŋe nâŋgâlân katat aregât dopŋân bunŋe miawak yetkiâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hain dâmbo dewunyetŋe hulaŋ akto emet egiat. Akto Yesuŋe hin dâm makmâ hâre yetkiep, “Yet bât kulem iregât den pat luâk siâ me siâ bo makyeŋgiwiandat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hain dâm makyetkimbo hepunmâ arim den koaŋmâ aregât den pat are makyeŋgimbela sambelem arimbo luâk âmbâle biwirâŋe nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Akto arimbiâ ainâk luâk siâ Yesugâlân kewugum togoyi aregât keiŋe hin. Are sinduk baniara bâleŋande mâŋgimbo kopa akmâ den bo makmâ yân manmâ gaep. ");
INSERT INTO tim_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Akto luâk are kewugum togombiâ sinduk baniara bâleŋe are wato hepunmâ arimbo nâŋgâ nâŋgâŋe miawakto den agep. Hain akto aregât kâmot humo ain kili arekŋe hin dâyi, “Israe nengât hutnenŋân kulem hinare ulikŋân siâ miawakto bo ekmâ malion.” hain dâm ekmâ nâŋgâm bâtyeŋe dâtyeŋân igim kili. ");
INSERT INTO tim_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dâ Parisaio yâkŋe âmâ Yesugât nâŋgâm bâliaŋmâ hin dâyi, “Sinduk baniara bâleŋe are yeŋgât humoyeŋande memeŋe agaŋdo aregât sinduk baniara bâleŋe are watyekmap.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Akto Yesuŋe kepiaŋe are hepunmâ arim den emetŋe ârândâŋ âgâm Anutuŋe damunyeŋe akberâm agep aregât pat âlep den makyeŋgim malep. Manmâ kundat keiŋe keiŋe agi are mem heŋgem yeŋguep. Hain akmâ malep. ");
INSERT INTO tim_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Akto lama damunlupyeŋe siâ bo manmai dop hainâk akmâ luâk âmbâle arekŋe biwi gulip akmâ wâtyeŋe gembo mali Yesuŋe are yekmâ okot nâŋgâ yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Okot nâŋgâ yeŋgim aregât luâklupŋe den ginŋe siâ hin dâm makyeŋgiep, “Kalamân sot bunŋe dondâ tatâp aregât âi luâk amon siâ manmai yâkgât âi kalam are mem metewaigât dop bo tatâp ");
INSERT INTO tim_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","aregât kalamgât Amboŋe Humo are ulilaŋbiâ âmâ âi luâk siâkâ huŋgunyeŋgiâk.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Akto Yesuŋe luâklupŋe keiân lâuwâ yeŋgonmâ meyekto togoyi are hin dâm makyeŋgiep, “Yeŋe sinduk baniara bâleŋe are luâk âmbâle mâŋgiyekbiâ bâliyi are watyekŋet. Akto kundat keiŋe keiŋe aktâi are mem heŋgem yeŋguŋet.” dâep. Hain dâm aregât memeŋe akyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Akto Aposololupŋe yâk yeŋgât kotyeŋe hin. Luâk siâ kotŋe Simoŋ kotŋe siâ Petoro akto emiŋe Anderea. Akto Yebedaiogât nanlogâtŋe kotyetŋe Yakopo akto Yohane. ");
INSERT INTO tim_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Akto siâ Pilipo, siâ Batolomaio, siâ Toma. Akto siâ kotŋe Mataio gawamangât puli meme luâk manminep akto Yakopo amâ Alipaiogât nanŋe are, akto Tadaio ");
INSERT INTO tim_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","akto Simoŋ siâ Roma damunlupyeŋe yeŋgât hâkâŋ agi are yeŋgâlân gâtŋe. Akto siâ âmâ Yudasi Karioto kepian gâtŋe yâkŋe halop hogom luâk oloŋ yekto Yesu meyi are. ");
INSERT INTO tim_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Akto Yesuŋe aposololupŋe are hin dâm huŋgunyeŋgiep, “Yeŋe âmâ Yuda luâk âmbâle bo yâk yeŋgâlân me Samaria gâtŋe kepia siâ me siâ yâk yeŋgâlân bo ariwei. ");
INSERT INTO tim_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dâ Lama are damunyeŋe bo manmâ ari hilip agumai dop hainâk Israe luâk âmbâle yâkŋe hilip agune dâm aktâigât yâk yeŋgâlânâk tâŋ tâŋâk ariwei. ");
INSERT INTO tim_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Israe yâk yeŋgâlân areâk arim hin dâm makyeŋgiwei, “Anutu himbimân manmapŋe damunnenŋe akberâm aktâp.” ");
INSERT INTO tim_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hain dâm amâ kundat aktâi yâk mem heŋgem yeŋguwei. Akto luâk âmbâle momoŋe areyeŋgât dâmbiâ momoŋânba agatbai. Akto hâk bâle aktâi are mem heŋgem yeŋguwei. Akto sinduk baniaraŋe meyegi are watyekbiâ ariwei. Nâmâ yân kârikŋe yeŋgim huŋgunyeŋgiân aregât ye gai hainâk wan me wan yân yeŋgiwei. ");
INSERT INTO tim_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Akto hin akmâ ariwai. Tâwât dewunŋe âmâ bo mem ariwei. ");
INSERT INTO tim_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Akto ito siâ siâyeŋe bo lugum goliakmâ ito bâlâk ariwei. Akto hâk pekeŋe konogâk lugu akmâ ariwei. Akto kei pekeŋe hainâk konogâk katmâ ariwei. Akto huwan hepunbiâ talâk. Yân arimbiâ âmâ kepia ambolupŋande yekmâ luâk âirâ dâm tânyeŋgumbiâ ârândâŋ akbiap. ");
INSERT INTO tim_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Akto huŋgun yeŋgire arim ulik gulik kepia ambolupŋe yeŋgât keiyeŋaet makmâ aikowei. Akto siâgât nâŋgâmbiâ ârândâŋ akto yâkgât emetŋân âgâm ainâk tatmâ manbei. ");
INSERT INTO tim_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Emetŋân âgâm Anutuŋe damunyeŋe agâkgât makmâ heroŋe akyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Heroŋe akyeŋgimbiâ emet amboŋande ye gala akyeŋgim denyeŋe nâŋgâmbiâ ârândâŋ akto aregât bunŋe miawakyeŋgiwiap. Gârâmâ denyeŋe nâŋgâm hâkâŋ akmâ gala bo akyeŋgimbiâ âmâ hamiyeŋgimbiâ aregât bunŋe bo miawak yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Akto yeŋe kepia siân arim makyeŋgimbiâ hâkâŋ akbiâ aregât kepia are hepunmâ Anutuŋe hâuŋe yeŋgiwiap aregât dop akmâ keiyeŋân hamaŋ siâ tatbiap are paŋ paŋgom tâlim pulimbiâ gewiap. ");
INSERT INTO tim_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aregât maktere nâŋgâŋet. Sop humoân Anutuŋe Sodom akto Gomora kepia ambolupŋande bâleŋe agi aregât hâuŋe yeŋgimbo meyi. Gârâmâ ye kepia yeŋân arimbiâ gala bo akyeŋgiwai âmâ dosa yeŋaet hâuŋe umatŋe membai. ");
INSERT INTO tim_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lama pâlâmŋe are pugaiya yeŋgât hutyeŋân arimbiâ hilip yeŋgune dâm kinmai dop hain are akmâ huŋgun yeŋgire luâk bâleŋe hutyeŋân ari manmâ aregât bo hamep akbei. Akto soŋgo kotŋe hewam are nâŋgâ nâŋgâŋe olop manmâ damun agaŋgimap dop hainâk ye biwi golâk manbei. Akto lâut kotŋe kembâ arekŋe bo kârâ nenekmap kopakom tatmap dop hainâk yeŋe arim yeukŋân manmâ bo mem bâli yekbai. ");
INSERT INTO tim_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ye luâk bikŋe yeŋgât nâŋgâmâk manbei. Yâkŋe yâk yeŋgât den emetŋân katyekmâ luâk kembulupyeŋe yâk yeŋgât dewunyeŋân bugâŋe yeŋguwai. ");
INSERT INTO tim_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Akto areâk bo. Ye nâŋgât akmâ mandâigât kiap me luâk kembu yâk yeŋgâlân meyekmâ arimbiâ den âi membai. Aregât ye yâk yeŋgât meteyeŋân akto Anutu bonâŋgaŋmai yâk yeŋgât meteyeŋân kârikŋeâk kinmâ den bunŋe makmâ hulaŋbei. ");
INSERT INTO tim_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Den âiân katyekbiâ âmâ den gain gain hinare maktenŋe ârândâŋ akbiap aregât nâŋgâm han lâuwâ bo akmâ hanoko bo akbei. Anutuŋe biwiyeŋân Heakŋe kato yâkŋe makmâ miawakyeŋgimbo areâk makbei. ");
INSERT INTO tim_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sop ain âmâ den makbai are Eweyeŋaet Heakŋande biwiyeŋân den kato nâŋgât keine makyeŋgiwai. Are âmâ yeŋeâk bo makbai. Amâ Heakŋande makmâ miawakyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Akto sop ain teulupyeŋande emilupyeŋe moŋet dâm oloŋ yekmâ togo kiap magaŋbiâ yeŋgumbo mombai. Akto ewelupyeŋande nanlupyeŋe yeŋgum gasa akyeŋgim kewugu yekmâ humomolupyeŋaelân arimbiâ âmâ yeŋgumbiâ mombai. Akto nanaŋ lepatlupyeŋande ewe memelupyeŋe gasa akyeŋgim kiapgâlân arimbiâ tembe lokolupyeŋande togom meyekmâ arim yeŋguwai. ");
INSERT INTO tim_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Akto ye kot patnaet akmâ luâk hârok yâkŋe yeŋgât nâŋgâmbiâ bâliwiap. Aregât yeŋgâlân gâtŋe siâ me siâŋe nâŋgât akmâ bo hâkâŋ akbiap âmâ sop humoân himbim kepia membiap. ");
INSERT INTO tim_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Akto ye meyekmâ den âi mem bugâŋe yeŋgune dâm akbiâ ain hepun yekmâ kepia siân arim manbei. Aregât siâ hin maktere nâŋgâŋet. Yeŋe âmâ Israe kepia ârândâŋ tatmâ ariâp ain bo purik katmâ arim âiyeŋe ketugum metembiâ âmâ nâ luâk akmâ geân aregât sopŋe ewumâk akbiap. ");
INSERT INTO tim_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nanaŋŋe humoyeŋe ewangiwaigât dop bo tatâp. Akto hainâk luâk humomolupyeŋe akto hoŋ bawalupyeŋe yâk dop konogâk membai. ");
INSERT INTO tim_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Akto nâŋe âmâ yeŋgât kautŋe mandân. Akto yeŋe âmâ nâŋgât den lokom hoŋ akniŋmâ mandâi. Akto luâk bâleŋe arekŋe âmâ hin dâm nogondâi, “Sinduk baniara bâleŋe yâk yeŋgât amboyeŋe kotŋe Besebulu.” dâm nogondâi hainâk hâmbâi ye hoŋ bawalupne manmâ denne lokom manbiâ âmâ makmâ mem ge katyekmâ mem bâliyekbai. ");
INSERT INTO tim_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Aregât yâk yeŋgât bo hamewakbei. Amâ wan me wan siâ yoŋâk kinmâ akmai are hainâk bo yembiap. Are hâmbâi miawakto ekbai. Akto wan me wan siâ akmâ heambukmai are hainâk bo yembiap. Are hainâk hâmbâi tek tekŋân miawakto ekbaen. ");
INSERT INTO tim_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aregât âmâ nâŋe ye olop yoŋâk yoŋâk tatmâ den makyeŋgim mandân ire luâk âmbâle hârokŋe nâŋgâŋetgât makyeŋgiwei. Akto nâŋe den hilop halowân makyeŋgim mandân ire hâmbâi kâmot humoân kinmâ makyeŋgiwei. ");
INSERT INTO tim_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Akto luâk bâleŋande yeŋgât wâtyeŋe bo akyeŋgiâkgât dâm bugâŋe yeŋguwai. Gârâmâ yeŋgât otne biwiyeŋe hilipkowaigât dopŋe bo tatyeŋgiâp are yeŋgât bo hamewakbei amâ Anutu yâk konokŋe ye yeŋgum aregât kakŋân otne biwiyeŋe hilipkowiapgât kârikŋe talaŋdâp yâkgât konok hamewakbei. ");
INSERT INTO tim_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Lâut sâmbâlilik are gagap amâ bunŋe bo. Are amâ tâwât dewunŋande puligowaengât dopŋe bo tatâp. Hain gârâmâ sâmbâlilik siâ mombiap momo aregât himbimân Eweyeŋande bo ewum pâpkowiap. ");
INSERT INTO tim_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yâkŋe dumutyeŋe aregât yalaŋe nâŋgâm metemap. Aregât ye manbiâ bo nelâm yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dâ ye âmâ sâmbâlilik bo. Ye luâk, aregât Anutuŋe damunyeŋe akmap. Akto yâkŋe keiyeŋe hârok nâŋgâmap. Aregât luâk yeŋgât bo hamewakbei. ");
INSERT INTO tim_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Akto yeŋgâlân gâtŋe siâŋe luâk âmbâle yeŋgât bo hamewakmâ yâk yeŋgât dewunyeŋân kinmâ, “Nâ biwine Yesugâlân katere kinbiap.” dâm makyeŋgiwiap âmâ nâŋe hainâk hâmbâi himbimân Ewenaet dewunŋân kinmâ, “Luâk ire âmâ nâŋgât kâmolân gâtŋe.” dâre Anutuŋe luâk hainare manman âlepŋân katbiap. ");
INSERT INTO tim_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aregât luâk aŋgâŋe âmâ luâk âmbâle yeŋgât hamewakmâ dewunyeŋân kinmâ, “Nâ Yesu are bo nâŋgaŋman.” dâwiap âmâ nâkai hainâk Ewenaet dewunŋân kinmâ, “Bo nâŋgâ giŋdân.” dâwian. ");
INSERT INTO tim_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Akto yeŋe nâŋgâ yâkgât hin bo dâwei, “Yesu âmâ nen gala konok manbaengât giep.” hain bo dâwei. Aregât maktere nâŋgâŋet. Nâŋe miawakmâ geân aregât bugâ miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nâŋe geân aregât eweŋe nanŋe potalakmâ gasa agaŋgiwiandat. Akto memeŋe baratŋe potalakmâ gasa agaŋgiwiandat. Akto erânŋe erânŋe potalakmâ ikiŋeâk ikiŋeâk gasa agaŋgim manbiandat. ");
INSERT INTO tim_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Me yeŋgât ginbailupyeŋande gasa agaŋgiwai. ");
INSERT INTO tim_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Akto siâ ewe meme han kalem humo akyetkim nâ bâlensiâ akniŋbiap âmâ yâk nâŋgât pat bo akbiap. Akto siâ nanŋe baratŋe han kalem humo akyeŋgim nâ bâlensiâ akniŋbiap âmâ yâk hain âgâk nâŋgât pat bo akmâ manbiap. ");
INSERT INTO tim_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Akto luâk siâŋe gasalupnande mem hilip nuguwai dâm aregât hamep akmâ ikiŋe hâkŋaet hanokoak akmâ manbiap âmâ nâŋgât pat bo akbiap. ");
INSERT INTO tim_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Me luâk siâŋe manmanŋe are ikiŋaelâk mem hanokoak akmâ manbiap arekŋe hâmbâi hilip aguwiap. Dâ luâk siâŋe nâŋgât akmâ nâŋgâ niŋmâ manmanŋaet bo hanokoak akmâ manmâ denne lokom manmâ manbiap arekŋe âmâ manman kârikŋân manmâ âgâwiap. ");
INSERT INTO tim_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ye huŋgun yeŋgire arimbiâ gala konok akyeŋgimai yâkŋe nâ gala konok akniŋmai aregât dop aktâp hainâk nâ gala konok akniŋmai yâkŋe âmâ Ewenande huŋgun niŋep yâk gala konok agaŋmai aregât dopŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Akto Anutugât propete siâ mandâp aregât luâk siâŋe nâŋgâm gala konok agaŋdo ain gâtŋande hâmbâi Anutuŋe ikiŋe propetegât hâuŋe waŋbiap. Akto luâk siâ agak meme âlepŋe mem manmap aregât luâk siâŋe yâkgât keiŋe ekmâ nâŋgâm heŋgemgoep aregât gala konok agaŋmap yâk Anutuŋe luâk âlepŋe yâkgât hâuŋe waŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Me luâk âmbâle siâŋe biwiyeŋe nâŋgât katbai yâk yeŋgâlân gâtŋe gegeŋe are luâk siâŋe ekmâ nâŋgâm âmâ tu hâgâm waŋbiap yâkŋe aregât hâuŋe âlepŋe hâmbâi membiap.” dâep. Yesuŋe den hain dâm aposololupŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuŋe hoŋ bawalupŋe keiân lâuwâ are hain dâm makyeŋgiep. Hain makyeŋgim metem kepia are hepunmâ kepiaŋe kepiaŋe arim Anutugât den akto ikiŋe keiŋe are makmâ miawakmâ makyeŋgim malep. ");
INSERT INTO tim_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sop ain âmâ Yohane are kala busi kâlegen katbiâ talep. Kala busi kâlegen katbiâ tatmâ Kristoŋe kulem keiŋe keiŋe mem malep aregât pat nâŋgâep. Nâŋgâm tatmâ galalogâtŋe lâuwâ huŋgun yetkimbo arim ");
INSERT INTO tim_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","hin dâm aikoyiat, “Damun netŋe Yohane are ulikŋân yâk togom damun nenŋe akbiapgât dâyi are gâ me niŋaet lâmgom manbaen? dâm maknetkimbo gutet.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hain dâmbela Yesuŋe hin dâm makyetkiep, “Yet arim âmâ wan me wan ekmâ nâŋgat iregât den pat are Yohane hin dâm magaŋbiandat. ");
INSERT INTO tim_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dewunyeŋe bok bokŋe yâk yeŋgât makto dewunyeŋe hulaŋ akto emet ektâi. Akto luâk kei bâtyeŋe bâli bâliŋe yâk yeŋgât makto âlepŋe akmâ bam gutâi. Akto diwi kârikŋe akmâ manmai yâk yeŋgât makto pandak yeŋgiâp akto ondopyeŋe bok bokŋe yâk yeŋgât makto ondopyeŋe kepik akto den nâŋgâi akto makto momoŋânba agatmâ golâk mandâi. Akto umburuk mamburuk mandâiŋe den pat âlepŋe makyeŋgimbo nâŋgâi. ");
INSERT INTO tim_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Akto luâk siâŋe hâkâŋne bo akbiap âmâ yâkgât nâŋgâre âlepŋe aktâp.” hain dâm huŋgun yetkimbo purik katmâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Huŋgun yetkimbo purik katmâ arimbela Yesuŋe Yohanegât hin dâm luâk âmbâle kili are makyeŋgiep, “Ye Yohane hân kamitŋângen malep yâk wan ekne dâm yâkgâlân ariyi? Seruŋe dakerâ waito bam gutmap are ekne dâm yâkgâlân ariyi me? ");
INSERT INTO tim_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me luâk siâŋe hâk peke kulem melem are mem luguagep. Luâk hainare ekne dâm yâkgâlân ariyi me? Luâk hain arekŋe hâk pekeŋe kulem melem luguakmâ heŋgemgom luâk kotdâ yeŋgât emelan tatmâ manmai. ");
INSERT INTO tim_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ye wan ekne dâm hân kamitŋângen ariyi? Amâ propete siâ ekberâm ariyi mon? Ye Yohane Anutugât den makmâ miawagep are ekne dâm ariyi aregât Yohane egi arekŋe âmâ luâkŋe luâkŋe Anutugât den makmâ miawakmâ manmâ gayi yâk yeŋgât dop bo. Yâk amâ siâ. Yâkŋe âmâ propete hârok ewangi yekmâ kautŋe mandâp. ");
INSERT INTO tim_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yâkgât âmâ ulikŋân Anutuŋe den hin dâep are tatâp, “Nune hoŋ bawane huŋgun aŋdere laune lokom gâŋgât ulikŋân akgiŋmâ dâp heŋgemgo giŋbiap.” den are amâ bunŋe akto Yohane miawagep. ");
INSERT INTO tim_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Akto Yohane yâkgât den siâ maktere nâŋgâŋet. Luâk yânŋande âmâ Yohane bo ewangimap. Dâ Anutu himbimân manmapŋe damunyeŋe akto yeŋgâlân gâtŋe hârokŋe âmâ Yohane ewangimai. ");
INSERT INTO tim_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Akto Yohaneŋe âi keiŋe katmâ den makyeŋgim malep sop arewa luâk âmbâle biwirâŋe Anutuŋe damunnenŋe akberâm aktâp aregât den pat âlepŋe nâŋgâm biwiyeŋe heroŋe maroŋe akto aregât bunŋe mene dâm aktâi. Akto luâk âmbâle kârikŋe akmai yâkŋe himbimgât pat akbai. ");
INSERT INTO tim_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Propete luâk akto Mosegât den kârikŋe yâk hârokŋe Anutugât keiŋe kulemgom manmâ gayi. Akto Yohaneŋe aregât den bâiŋe makmâ miawagep. ");
INSERT INTO tim_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Propete luâk siâ kotŋe Elia are malep luâk hainare hutnenŋân miawakbiap, den are nâŋgâmbiâ ârândâŋ agâkgât tatyeŋgiâp mon? ");
INSERT INTO tim_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ire nâŋgâm biwiyeŋe kepigâkgât den ire mem biwiyeŋân katmâ nâŋgâmâk manbei. ");
INSERT INTO tim_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hinŋe mandâi yeŋgât den gain gain maktere ârândâŋ akberâp? Dop hinare. Nanaŋ lepat hain are kâmot lâuwâ kepia sombeimân tatbai. Tatmâ kâmot siâŋe kâmot siâ are hin dâm makyeŋgiwai, ");
INSERT INTO tim_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Nenŋe han nenŋeâk kep konden hain koŋet dâen. Hain dâm makyeŋgienŋe ye bo kondâi. Umbi mem indiengât yekâ han mem indeŋet dâen. Hain dâm makyeŋgienŋe yekâ hainâk bo indeâi.” dâwai. Akto hainâk nâŋe bo indem okot bâle akmâ sot bâlâk manman aregât nâŋgât hainâk hâkâŋ aktâi. Akto aregât maktere nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohaneŋe sot waiŋ tu bo nem âmâ yân manmâ gambo aregât ye hin dâyi, “Âi luâk ire âmâ sinduk baniara bâleŋande kautŋe mem gulip ketuguâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Akto nâ luâk akmâ gem sot soŋgo nendere hin dâm magaŋgi niŋmai, “Luâk irekŋe sot humo nem mandâp amâ Roma yeŋgât pat akmâ puli meme akto luâk bâleŋe yâk yeŋgât gala.” dâm magaŋgi goaŋgi akmai. Gârâmâ Anutugât nâŋgâ nâŋgâŋe nâŋgâm watmâ manbai âmâ siâ me siâ bunŋeâk akto keiŋe yâk yeŋgâlân bunŋe miawakbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Akto emelâk Yesuŋe kepiaŋe kepiaŋe manmâ kulem keiŋe keiŋe mendo ekmâ kinmâ agak memeyeŋe bâleŋe yeŋe bo makmâ miawakmâ han purikali aregât nâŋgâm bâli yeŋgim sârek yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Bâe, Korasiŋ kepia ambolupŋe, bâe, Besaida kepia ambolupŋe yeŋgâlân kulem hamepŋe olowâk mem manmâ gan hainare Tiro akto Sidoŋ kepian ketugure dâine yâk emelâk agak memeyeŋe bâleŋe hepunmâ kâŋgom kinmâ okot bâle nâŋgâ aŋgim kinmâ Anutugât den nâŋgâwâi. ");
INSERT INTO tim_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dâ ye âmâ hain bo agi aregât hâmbâi sop humoân Tiro akto Sidoŋ kepia ambolupŋande aregât umatŋe membai. Hain gârâmâ ye âmâ agak memeyeŋe bâleŋe bo hepuli aregât hâuŋe umatŋe bâleŋe membai. ");
INSERT INTO tim_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Akto Kapanaum kepia ambolupŋe ye âmâ Anutuŋe meyekto himbimân âgâwai mon? Hain bo. Anutuŋe âmâ ye hepun yekto hememân gewai. Yeŋgâlân kulem keiŋe keiŋe ketuguân are Sodom kepian ketugure dâine kepia aregât ambolupŋe hanyeŋe purik katbiâ Anutuŋe bo yeŋguwop. ");
INSERT INTO tim_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aregât hin makyeŋgiwe. Sop umbuŋân Sodom kepia ambolupŋande bâleŋe agi aregât umatŋe meyi. Dâ ye âmâ sop humoân umatŋe bâleŋe membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sop ain Yesuŋe Eweŋe maŋganmâ hin dâep, “Apo, hân himbim amboŋe gâŋgât okot âlep akgiŋdân. Ewene gâ luâk bikŋande gâŋgât keige nâŋgâne dâm nâŋgâ nâŋgâ emetŋân âgâyi yâk yeŋgât wan me wan ire nâŋgâwâi dâm dâp tigi yeŋgimat. Are nâŋgâre ârândâŋ aktâp. Dâ nanaŋ hinare yânŋande âmâ aregât nâŋgâŋet dâm hekat yeŋgimenâ nâŋgâmai aregât gâ mepaige mendân. ");
INSERT INTO tim_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Apo gâ hain miawakmâ ariâkgât nâŋgâmenâ âlepŋe agep.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Akto den siâ hin dâm makyeŋgiep, “Ewene yâkŋe nâ memeŋe akniŋdo aregât kotŋe siâ siâ akbiangât dopŋe aktâp. Akto Ewenaet keiŋe nâŋgângât luâk âmbâle potat yekmâ biken biken makyeŋgire arekŋe âmâ hainâk keiŋe nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","Akto nâŋe nunak yeukŋân manmâ damunyeŋe akberâm aktângât ye hâk hilâlâm kakŋân manmai me umatŋe miawak yeŋgimbo wâtyeŋe sândugewerâm aktâp ye hârok nâŋgâlân togombiâ âmâ nâŋe welam yeukŋe âlepŋe are mem katyeŋgire âmâ nâŋgât keine nâŋgâm heŋgemgombiâ mem hâk sânduk ketugu yektere wâtyeŋe kârikŋe akbiap. Akto biwiyeŋe sândugembo sân sân bo membai.” hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Âi bo meme sopŋe Sarere ain Yesu akto hoŋ bawalupŋe âi kalam kâlegenba bam ariyi. Arim hoŋ bawalupŋe mopyeŋe agumbo sot mem hâkŋe gagaim neyi. ");
INSERT INTO tim_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Akto Parisaio luâkŋe yekmâ Yesu hin magaŋi, “Hoŋ bawalupgande âi meme sopŋe bo ain ina sot hâkŋe gagaim nendâi are yektenŋe ârândâŋ bo aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Ye Dawidiŋe agep aregât den pat oyaŋmai are bo oyaŋmâ nâŋgâmai mon? Yâk akto tembe lokolupŋe mop humo miawak yeŋgimbo mali. ");
INSERT INTO tim_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hain akmâ Anutugât sumbe kat kat emetŋân âgâyi. Âgâm âmâ Anutugât sumbe dâm sot kâmbokŋe dâtâŋe are om kali are neyi. Are âmâ sumbe kat kat luâkŋeak ne. ");
INSERT INTO tim_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moseŋe den kulemgoep are oyaŋmai dâ amâ bo nâŋgâmai. Sumbe kat katgât âi luâkŋe âi mem Sarere âi bo meme sopŋân sumbegât âi memai amâ dosa bo akmai. ");
INSERT INTO tim_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nâŋe âmâ sumbe kat kat emetŋe are ewangiân. ");
INSERT INTO tim_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Akto ye den ire Anutuŋe makto kulemgoep, “Sumbe ogogât âmâ hâkâŋ aktân. Dâ okot âlep agakgât âmâ egâliaŋdân.” den are nâŋgâmai dâine agak memeyeŋe bâleŋe bo akmai yâk yeŋân den âiân umatŋe bo katyekbâi. ");
INSERT INTO tim_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nâ luâk akmâ geân âmâ âi bo meme sopŋe Sarere aregât damunŋe akman.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Akto Yesuŋe arewa arim yâk yeŋgât den emetŋân âgâep. ");
INSERT INTO tim_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Âgâm ain luâk bâtŋe bâleŋe siâ tato egep. Akto Parisaio luâk arekŋe, “Gain gain akmâ Yesu denân katbaen.” dâm aregât hin dâm magaŋi, “Sarere âi bo meme sopŋân âlepŋe luâk kundatdâ heŋgem yeŋguwerât me bo?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dâmbiâ hin makyeŋgiep, “Hut yeŋân gâtŋe siâŋe lama siâ kinaŋbiap. Akto lama arekŋe Sarere âi bo meme sopŋân lâmân gewiap. Akto luâk arekŋe lâmânba bo hikom oloŋbiap me? ");
INSERT INTO tim_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Hanâk hikom oloŋbiap akto luâkŋe âmâ lama ewangimap. Aregât nen âlepŋe âi bo meme sopŋe Sarere ain luâk heŋgem yeŋguenŋe ârândâŋ akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hain dâm kinmâ luâk bâtŋe bâleŋe are hin dâm magaŋep, “Bâtge panmenâ agalâk.” dâmbo bâtŋe pando âlepŋe akmâ bâtŋe biken aregât dopŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Akto Parisaio luâkŋe agatmâ arim mendugum Yesu kombiâ mombiapgât magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hain akbiâ Yesuŋe den are nâŋgâm kepia are hepunmâ agatmâ ariep. Akto luâk âmbâle dondâŋe olop arimbiâ luâk kundatdâ dondâ heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hain akmâ aregât den pat bo makyeŋgiwei dâm den kârikŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Makyeŋgiepgât Anutuŋe ikiŋe hoŋ bawagât den siâ Yesaia magaŋdo hin kulemgoep, ");
INSERT INTO tim_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hâmbâi nâŋgât hoŋ bawane nâŋe emelâk makmâ hâreaŋân. Nâ yâkgât ukenŋe humo nâŋgân akto yâkgât okot âlep nâŋgân. Akto nâŋe nune Heakne are yâkgâlân katbian akto yâkŋe agak meme âlepŋe aregât den pat are hânŋe hânŋe manmai are makyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Akto yâkŋe kuk heŋgân denŋe bo makbiap. Akto dâp humo watmâ bo kamboŋdo nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Akto hâlâm pelâkŋe kokoŋe are bo hârem kâlâwân panbiap. Akto kâlâp ululunŋe are bo limbâpkombo bokbiap. Nâŋgât hoŋ bawa hain akmâ âi humo mem ârândâŋ den mem hulaŋ golaŋ mâŋgimbo nâŋgâmbiâ âlepŋe miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Akto hânŋe hânŋe manmai arekŋe yâkgât kotŋe nâŋgâmbiâ humo akto biwiyeŋe sândugembo yâkgât lâmgom tatmâ mâruŋe akmâ konmâ manbai.” Yesaiaŋe hain kulemgoep. ");
INSERT INTO tim_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Akto sop ain luâk siâ yâkgâlân kewugum togoyi. Akto luâk are âmâ sinduk baniara bâleŋande kautŋân miep. Dewunŋe akto lauŋe hârok gisap aguep. Akto Yesuŋe luâk are mem âlepŋe ketugumbo denŋe bo arekŋe den hogom emet ekmâ agep. ");
INSERT INTO tim_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Akto luâk âmbâle kâmot humo arekŋe ekmâ otneyeŋe arimbo hin dâm magaŋgi goaŋgi agi, “Luâk ire Dawidigât hakuŋe me aŋgâ?” dâm han lâuwâ agi. ");
INSERT INTO tim_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Akto Parisaio luâkŋe den are nâŋgâm hin dâyi, “Yâkgât keiŋe hingât akmâ kinmâ sinduk baniara bâleŋe watyekmâ kindâp. Sinduk baniara bâleŋe yeŋgât humoyeŋe kotŋe Besebulu yâkgât kârikŋân kinmâ watyekmâ kindâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hain dâmbiâ Yesuŋe biwiyeŋân ekmâ hin dâm makyeŋgiep, “Luâk kâmot siâŋe potalakmâ yeŋeak agumbiâ dâine bo akbop. Me emet me kepia humo siâŋe potalakmâ agumbiâ dâine emet kepia are bo yembop. ");
INSERT INTO tim_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dâ hainâk Hiaŋgi Amboŋande ikiŋak walakto dâine kâmotlupŋe emelâk potalakmâ bo akbâi. ");
INSERT INTO tim_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hiaŋgi Amboŋaet kârikŋân kinmâ âi mem manman dâine bunŋe bo miawakbop. Dâ Anutugât kârikŋân kinman aregât Hiaŋgi Amboŋaet âi luâk watyekman. Akto aregât lâuwâŋe makbe. Ye nâŋgâ yâkgât Besebulugât kârikŋân kinmâ Besebulugât kâmot watyekmap dâi aregât hin dâm makyeŋgiwe. Yeŋgât luâklupyeŋande hainâk Besebulugât kârikŋân kinmâ sinduk baniara bâleŋe watyekmai. Yâkŋe âmâ hâkyeŋe tunmâ keiyeŋe mem miawakmai. ");
INSERT INTO tim_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akto nâ Anutugât Heakŋande wâtŋe niŋdo sinduk baniara watyekman aregât Anutuŋe wan me wan hârok damunyeŋe akbiapgât sopŋe tâlâwâk aktâp. ");
INSERT INTO tim_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Akto nâŋgât keine aregât den dopŋe siâ makyeŋgire nâŋgâŋet. Luâk kârikŋe siâŋe mâron goliakmâ tembe bisârâŋ mem âgâm emet kepiaŋe damungom heŋgemgowiap âmâ yâkgât ito me wan me wan âlepŋe talaŋbiap. Dâ gasa kârikŋe dondâŋe togom emet damunŋe akmap are tâkŋe hikombo yeukŋe akto âlepŋe ito me bau me wan me wan are meakbiap. ");
INSERT INTO tim_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Akto aregât siâ maktere nâŋgâŋet. Luâk âmbâle siâŋe gala bo akniŋmapŋe âmâ gasa akniŋmap. Akto siâŋe âi mendere bo tân nugumapŋe nugum pan nekbiapgât dop aktâp. ");
INSERT INTO tim_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Akto luâk âmbâle bikŋande nugum bâleŋe maleŋe hârok mâŋginekmai dosa are Anutuŋe ikiŋak kutigit yeŋgiwiapgât dopŋe aktâp. Dâ luâk siâŋe Anutugât Heakŋe are pilâkom mem ge katmâ âmâ dosa membiap are Anutuŋe hepunbiapgât dopŋe bo tatâp. ");
INSERT INTO tim_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Akto nâ luâk akmâ geân nâŋgât siâŋe makmâ bâleniŋbiap âmâ dosa are Anutuŋe ikiŋak kutigilaŋbiapgât dopŋe aktâp. Dâ Heak âlepŋe yâkgât makmâ bâliaŋbiap yâkgât dosa âmâ Anutuŋe bo kutigilaŋbiap. Borondâ. Luâk are dosa olop manmâ âgâwiap. ");
INSERT INTO tim_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Lâwingât keiŋe bunŋande mem miapanmap. Aregât ye lâwin siâgât nâŋgâm kepilâm imâ âlepŋe dâm benŋe bunŋeŋaet hainâgâk âlepŋe dâmai. Akto lâwin siâgât nâŋgâm kepilâm imâ bâleŋe dâm âmâ benŋe bunŋeŋaet hainâgâk bâleŋe dâmai. ");
INSERT INTO tim_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wei, mulum nanaŋlupŋe, ye bâleŋe akmai aregât gain gain den âlepŋe siâ makbai. Amâ hanyeŋân wan me wan siâ yendâp hain âgâk lauyeŋânba gamap. ");
INSERT INTO tim_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Luâk âlepŋande han nâŋgâ nâŋgâŋe âlepŋânba siâ me siâ âlepŋe lândemap. Dâ luâk bâleŋande âmâ han nâŋgâ nâŋgâŋe bâleŋânba siâ me siâ bâleŋeâk lândemap. ");
INSERT INTO tim_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aregât hin makyeŋgire nâŋgâŋet. Siân sop humoân luâk âmbâle hârokŋe den keiŋe bo makmai are makmâ miawakbiâ Anutuŋe den âiân katyekbiap. ");
INSERT INTO tim_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Amâ hingât. Den makmat arekŋe keige âlepŋe mem miap pando Anutuŋe hâuŋe âlepŋe akgiŋbiap. Me den makmat arekŋe keige bâleŋe mem miap pando Anutuŋe hâuŋe umatŋe giŋdo umatŋân manmâ âgâwiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yesuŋe hain dâmbo sop ain Mosegât den kârikŋe makmâ kepigi akto Parisaio luâk arekŋe Yesu magaŋmâ hin dâyi, “Apo, gâŋe kulem siâ memenâ ekne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hain dâmbiâ hin makyeŋgiep, “Hain bo. Luâk âmbâle bâleŋe yeŋe Anutugât kotŋe mem bâlimai arekŋe kulem miawakto ekne dâmai. Dâ nâŋe âmâ kulem bo hekat yeŋgiwian. Konok amâ hin. Yonagât kulem are nâŋgâm heŋgemgowei. ");
INSERT INTO tim_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ulikŋân propete kotŋe Yona iŋan humo siâgât tepŋe kâlegen hilâm âlâwu yiep hainâk luâk akmâ geân nâ hilâm âlâwu hân kâlegen yembian. ");
INSERT INTO tim_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dâ Yona arekŋe kepia bâleŋe dondâ kotŋe Niniwe aregât ambolupŋe den makyeŋgimbo hanyeŋe purik kali. Dâ nâ Yonagât Humoŋe nâŋe makyeŋgire hanyeŋe kârikŋe akmai aregât Niniwe ambolupŋande yeŋgât dosa mem miawakyekmâ makbiâ agak memeyeŋe bâleŋe are mem miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aregât den siâkâ makbe. Ulikŋân hakunenŋe Dawidi yâkgât nanŋe Salomoŋe den nâŋgâ nâŋgâŋe makmâ miawagep. Den are sambelem arimbo âmbâle kembu siâ hân bâiŋângen Salomogât den are nâŋgâwerâm togombo magaŋdo nâŋgâmbo dâtŋe agep. Dâ nâŋe âmâ Salomogât Humoŋe aregât yu kindâi ire makyeŋgire nâŋgâmbiâ dâtŋe bo akto aregât âmbâle kembu arekŋe yeŋgât dosa mem miawakmâ hâkyeŋe tun akto agak memeyeŋe bâleŋe are miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ye hain akmaigât hin makyeŋgire nâŋgâm heŋgemgoŋet. Sinduk baniara heleŋ bâleŋe siâŋe luâk siâ hepunmâ hân kamitŋângen luâk memberâm undâgâto bo akbiap. ");
INSERT INTO tim_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Undâgâto bo akto hin dâwiap, “Emelâk nâŋgât luâk are agaŋmâ hepulân aregâlân purik katmâ arim manbian.” hain dâm purik katmâ arim luâk aregât biwiŋân siâ siâ bo kindo ekmâ ârândâŋ aktâpgât ");
INSERT INTO tim_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","âmâ arim galalupŋe bât biken lâuwâ bâleŋe dondâ akmai are âmâ mem miawakyekmâ kewuguyekto togom manbiâ umatŋe bâleŋe dondân manmâ âgâwiap. Akto agak meme hain arekŋe luâk âmbâle bâleŋe hinŋe mandâi are yeŋgâlân miawakbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Den hain dâm makyeŋgimbo ainâk memeŋe emilupŋe togom betgen kinmâ, “Teunenŋe gemenâ makgiŋne.” dâm koli. ");
INSERT INTO tim_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hain dâm konbiâ luâk siâŋe hin dâm magaŋep, “Memege emilupge betgen kinmâ gogonmâ kindâigât gemenâ makgiŋberâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hain dâmbo Yesuŋe luâklupŋe are yekmâ hin dâm magaŋep, “Memene niŋe? Akto emilupne niŋema? ");
INSERT INTO tim_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Memene me emilupne amâ ire. ");
INSERT INTO tim_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ewene himbimân manmap yâkgât lauŋe lokomai yâkŋe amâ nâŋgât memene akto emilupne garilupne aktâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Akto sop ain Yesuŋe emet are hepunmâ sopanmâ arim bâtgum ginŋân talep. ");
INSERT INTO tim_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ain tato luâk âmbâle dondâŋe yâkgâlân togom gam ândeaŋi. Hain agi aregât waŋga siân âgâep. Akto luâk âmbâle togoyi are bâtgum dâtŋân kinbiâ makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Waŋga kâlegen kinmâ den ginŋe dondâ makyeŋgiep are hutŋân den ginŋe siâ ikiŋaet pat hin dâm makyeŋgiep, “Luâk siâŋe seŋgo alekŋe mem âi pâiŋângen ariep. ");
INSERT INTO tim_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Hain akmâ arim mem biken biken pando giep. Dâ seŋgo alekŋe bikŋe âmâ dâwân ge yiep. Are lâutŋe dowâk togo nem meteyi. ");
INSERT INTO tim_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dâ bikŋe âmâ hân kât kâlegen hân dondâ bo ain ge yiep aregât dowâk pâtkombo kâmŋe dowâk gambo ");
INSERT INTO tim_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","dewutâ kârikŋe pando kândârâŋe tâlâwâk aregât dipkom moep. ");
INSERT INTO tim_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dâ bikŋe âmâ hele kândârâŋe kâlegen ain ge yiep arekŋe sopŋân pâtkom kâmŋe gambo hewukŋe âkâ hainâk gam kârikŋe akmâ sot tigimbo bunŋe bo agep. ");
INSERT INTO tim_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Akto seŋgo alekŋe bikŋe âmâ hân kelurâ amboŋande mem bandikoep ain ge yiep are bikŋande pâtkom agatmâ bunŋe âlepŋe agep. Dâ bikŋande amâ pâtkom agatmâ bunŋe âlepŋe dondâ agep. ");
INSERT INTO tim_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gârâmâ ye den ire nâŋgâm biwiyeŋân katmâ heŋgemgom manbiâ bunŋe yeŋgâlân miawakbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hain dâmbo luâk âmbâle dondâ arimbiâ luâklupŋande Yesu hindâm aikoyi, “Amâ wangât den ginŋeâk makyeŋgiât?” dâmbiâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","“Ye Anutuŋe damunyeŋe akmap aregât keiŋe yoŋâk malep are miapŋân makyeŋgiman. Dâ luâk âmbâle bikŋe Anutuŋe bo damunyeŋe akmap are Anutugât den patgât keiŋe miawâk bo makyeŋgiman. ");
INSERT INTO tim_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aregât luâk âmbâle bikŋande siâ me siâ are damun akmâ mem manmai are siâ me siâ siâkâ yeŋgire sambe miawagaŋbiap. Dâ bikŋande âmâ siâ me siâ bâlensiâ are mem manmai are mendere yân manbai. ");
INSERT INTO tim_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aregât den ginŋeâk makyeŋgiman. Amâ yâkŋe âmâ ekmâ âmâ bo ekmâ nâŋgâwai. Akto nâŋgâwerâm hâumgowai arekŋe keiŋe bo nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aregât den siâ Yesaiaŋe ulikŋân kulemgoep bikŋe bunŋe aktâp. Amâ hin, Anutuŋe hin dâep, “Luâk âmbâle yu mandâi amâ ondopyeŋande nâŋgâwai. Dâ hanyeŋande âmâ bo nâŋgâm kotgâwai. Akto dewunyeŋande ekbai. Dâ ekmâ âmâ bo heŋgemgowai. ");
INSERT INTO tim_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Luâk kâmot irekŋe hanyeŋe kârikŋe akto ondopyeŋe bokbokŋe akto dewunyeŋe âmâ bogep. Amâ dewunyeŋande siâ me siâ ekmâ ondopyeŋande nâŋgâm heŋgemgom âmâ han biwiyeŋe purikatmâ heŋgemgombiâ nâŋe mem heŋgemgomyekbomgât wan me wan bo ekmâ nâŋgâm heŋgemgowai.” Anutuŋe hain dâep. Yesaiaŋe den yu kulemgoep are bunŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Den bunŋe makyeŋgiwe. Ulikŋân Anutugât propete akto luâk âmbâle bikŋe Anutugât dewunŋân agak meme âlepŋeâk akmâ mali arekŋe wan me wan uŋak yeŋe ekmâ mandâi hainâk ekberâm ukenŋe humo nâŋgâm mali. Dâ amâ bo egi. Akto den pat âlepŋe makyeŋgire nâŋgâi ire gai nâŋgâwerâm ukenŋe humo nâŋgâm mali. Dâ amâ bo nâŋgâyi. Aregât ye âmâ wan me wan ekmai aregât nâŋgâm heroŋe humo akmai. Akto den pat âlepŋe makyeŋgire nâŋgâmai aregât heroŋe humo nâŋgâm manmai. ");
INSERT INTO tim_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Akto nâŋe luâk siâŋe seŋgo palepgât den ginŋe maktân aregât keiŋe amâ hin. ");
INSERT INTO tim_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Seŋgo palep amâ Anutuŋe damunyeŋe akbiapgât den dopŋe makyeŋgiman. Akto dâwân mesokto ge yiep are amâ den maktere bo nâŋgâmbiâ ainâk Bâleŋe Amboŋande dowâk togom den âlepŋe biwiyeŋân gewop dâm den pat are kondo bo akmap. Hain are. ");
INSERT INTO tim_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dâ seŋgo bikŋe hân kât kâlegen ge yiepgât maktân are amâ luâkŋe hin akmai. Den pat âlepŋe maktere âlepŋe nâŋgâm manmai. Akto ire amâ âlepŋe dâm heroŋe akmâ getek mem manmai. ");
INSERT INTO tim_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Dâ den biwiyeŋân bo gem heŋgemgoep aregât getek manmâ umatŋe siâŋe me nâŋgât dengât Anutugât gasa togombiân hamep akmâ den are hepunbai. ");
INSERT INTO tim_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dâ koaŋe hele hewukŋe kândârâŋân yiep ain palep hân aregât dopŋe amâ luâk âmbâle hin akmai. Luâk âmbâle den makyeŋgire are nâŋgâm kinmâ hin dâmai, “Den ire lokowaen.” dâmai âmâ benŋe sikumgât me puligât me hâkgât ukenŋe aregât nâŋgâm han lâuwâ akbiâ sikumŋe kambiamyeŋe oloŋdo den âlepŋe hepunmâ sikum aregâlâk nâŋgâmai. Hain nâŋgâm agak meme âlepŋe bo akmâ bunŋe bo akmai. ");
INSERT INTO tim_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dâ hân âlepŋân palep hân aregât dop amâ luâkŋe hin akmai. Yâk âmâ den pat âlepŋe nâŋgâm kotgâm heŋgemgom mem manmâ agak meme âlepŋe bunŋe akmai. Dâ bikŋande âmâ hain akmâ agak meme âlepŋe dondâ akmai. Den dopŋe maktân aregât keiŋe amâ hain.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Akto Yesuŋe den dopŋe siâ hin makyeŋgiep, “Himbimân manmap yâkŋe damunyeŋe akbiap aregât den dopŋe hin. Luâk siâŋe seŋgo alekŋe mem âiângen arim kâmelep. ");
INSERT INTO tim_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hain kâmeto bo akto emetŋân âgâmbo emet dâgâep. Emet dâgâmbo ainâk hârok asiŋ yembiâ âmâ gasaŋe togom seŋgo kâit aregât alekŋe mem togom seŋgo hutŋân kâmelep. ");
INSERT INTO tim_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hain akmâ arimbo hilâm siân amâ seŋgo kâmŋe gambo bunŋe miawakto seŋgo kâit bunŋe bo are âkâ pâtkoep. ");
INSERT INTO tim_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pâtkombo luâk aregât hoŋ bawalupŋe arekŋe humoyeŋe hin magaŋi, “Apo, seŋgo alekŋe kâmelen aregât gain gain seŋgo kâit dondâ hutŋân pâtkoâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hain dâmbiâ kalam amboŋe arekŋe hin makyeŋgiep, “Maktâi amâ nâŋgât gasa siâŋe togom seŋgo kâit kalep.” dâep. Hain dâmbo âi luâklupŋande hin magaŋi, “Akto gain gain nâŋgât? Nenŋe ari seŋgo kâit are hindâne me?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Hain dâmbiâ hin makyeŋgiep, “Hain bo. Hepunŋet. Ageine mesokmâ koaŋe âlepŋe hindâ yekbâi. ");
INSERT INTO tim_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gârâmâ hepunbiâ hain yendo titnan bunŋe miawakto âlepŋe ainâk ire seŋgo, ire bo dâm nâŋgâm kepilâwai. Aregât hâre hâre luâklupne hin makyeŋgiwian, Arim hele wan bunŋe bo are hindâm dâgâm mendugum kâlâwânâk panbiâ oâk. Dâ seŋgo bunŋe olop are orem nâŋgât sot emetŋân menduguwei. Hain dâwian.” dâm makyeŋgiep.” ");
INSERT INTO tim_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuŋe den dopŋe siâ hin dâm makyeŋgiep, “Himbimân manmap yâkŋe damunyeŋe akbiap aregât den dopŋe hin. Lâwin koaŋe siâ kotŋe wesem are âi luâk siâŋe koaŋe are mem arim ikiŋe kalamŋân kâmelep. ");
INSERT INTO tim_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Koaŋe amâ bâlensiâ dondâ. Dâ pâtkom âmâ humo akmâ lâwin siânba are hârok ewangiyekmap. Hain akmâ lâwin humo akto lâutŋe togom bât bâtŋân panmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Hain makyeŋgim benŋe den dopŋe siâ hin dâm makyeŋgiep, “Anutuŋe damunyeŋe akberâm aktâp amâ kâtembe dop hinare. Âmbâle siâŋe kâtembe bâlensiâ mem hamân golaŋgoep. Akto kâtembe bâlensiâ arekŋe ham hârok mâŋgimbo ukenŋe agep.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuŋe hain dâm den dopŋânâk luâk âmbâle togoyi are makyeŋgiep. Dâ den miapŋân amâ bo makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Akto den dopŋe siâ makyeŋgiep amâ ulikŋân propete siâŋe kulemgoep are bunŋe miawagep hin kulemgoep, “Nâŋe den ginŋeâk hârok makyeŋgiwian. Akto wan me wan Anutuŋe ulikŋânbak heambukto yem âgâep den are makmâ miawakyeŋgire nâŋgâwai.” Hain kulemgoep den are bunŋe akto Yesuŋe den ginŋeâk makyeŋgim malep. ");
INSERT INTO tim_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Akto Yesuŋe luâk âmbâle kâmot humo are hepun yekmâ emelan âgâep. Akto hoŋ bawalupŋande âgâm magaŋmâ hin dâyi, “Seŋgo kâitŋe kalam kâlegen pâtkoepgât maktât are nenâkâ keiŋe maknengimenâ nâŋgâne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hain dâmbiâ Yesuŋe den ginŋe aregât keiŋe hin makyeŋgiep, “Luâk seŋgo alekŋe kâmelep amâ luâk akmâ geân nâ. ");
INSERT INTO tim_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Dâ kalam amâ kepia hârok. Dâ seŋgo koaŋe âlepŋe amâ luâk âmbâle Anutuŋe damunyeŋe akberâm aktâp are. Dâ hele bâleŋe amâ Bâleŋe Amboŋaet luâk âmbâle. ");
INSERT INTO tim_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dâ gasaŋe togom kalam kâlegen hele bâleŋe koaŋe kâmelepgât maktân amâ Hiaŋgi Amboŋe yâk. Dâ kalamân sot bunŋe memegât maktân amâ hâmbâi sop humoân miawakbiap aregât maktân. Dâ are âmâ aŋeloŋe mendugum kâlâwân ombaigât maktân amâ hâmbâi dop hainâk hân himbim bo akbiandat sop ain miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Dâ hele bâleŋe hindâm kâlâwân ombaigât maktân amâ dop hainâk hâmbâi miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Amâ luâk akmâ geân nâŋe aŋelolupne huŋgun yeŋgire wan me wanŋe luâk biwiyeŋe mem bâlimap are akto luâk agak meme bâleŋe akmai are oloŋyekmâ kâlâwân panyekbiâ gewai. ");
INSERT INTO tim_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gem indem hâk hilâlâm humo nâŋgâm elewetyeŋe igim kinmâ manbai. ");
INSERT INTO tim_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Akto sop ain luâk âmbâle agak meme âlepŋeâk akmâ manmai are âmâ Eweyeŋaet dewunŋân dewutâ dewunŋe hinare akmâ pagalem kinbai. Gârâmâ ye den ire biwiyeŋân katmâ nâŋgâm manbei. ");
INSERT INTO tim_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Akto Anutuŋe damunyeŋe akberâm aktâp are âmâ luâk siâŋe tâwât dewunŋe kalam kâlegen heambukto yiep hainare. Akto luâk siâŋe tâwât dewunŋe are ekmâ benŋe yâkâ hainâk lâuwâŋe heambugep. Hain akmâ aregât mâruŋe dondâ akmâ wan me wan mem arimbo luâk bikŋande puligoyekbiâ puli are mem arim tâwât dewunŋe egep are memberâm kalam are puligoep. ");
INSERT INTO tim_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Anutuŋe damunyeŋe akberâm aktâp are âmâ sikum luâk siâŋe kune âlep âlepgât undâgâtmap hainare. ");
INSERT INTO tim_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Luâk arekŋe kune siâ âlep âlepŋe dondâ ekmâ âmâ ikiŋandeân siâ siâ mem arim yeŋgimbo puli waŋbiâ puli arekŋe kune delem are puligoep. ");
INSERT INTO tim_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Akto siâ gai hainâk Anutuŋe damunyeŋe akberâm aktâp amâ hin. Âi luâk bikŋande ŋalu ŋalu panbiâ haru kâlegen gembo iŋan bâleŋe âlepŋe hârok oloŋyegi. ");
INSERT INTO tim_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Oloŋyekbiâ pikbiâ ginŋângen oloŋbiâ giep. Hain akmâ iŋan âlepŋe âmâ kepilâmbiâ kondo siân giep. Dâ iŋan bâleŋe amâ pali. ");
INSERT INTO tim_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hainâgâk hâmbâi himbim hân ire bo akbiap sop ain âkâ hainâk akbai. Aŋeloŋe gem luâk bâleŋe luâk âlepŋe yeŋgât hutyeŋe tete manmai are mem kepilâ yekbai. ");
INSERT INTO tim_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hain akmâ kâlâp humo om yemap ain panyekbai. Akto sop ain âmâ hâk hilâlâm nâŋgâm elewetyeŋe igim indem kamboŋmâ yembai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Akto Yesuŋe aiyeŋgum hin dâep, “Den keiŋe hârok makyeŋgiân are âlepŋe nâŋgâi me bo?” dâmbo, “Âlepŋe nâŋgâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Akto hin makyeŋgiep, “Mosegât den tâmbâŋe makmâ hulaŋmai areyeŋgâlân gâtŋe siâ himbimân manmap yâkŋe damunyeŋe akbiapgât keiŋe makyeŋgire nâŋgâmap âmâ hin akmap. Itoânba sikum tâwât irakŋe akto wan tâmbâŋe lândem katmap.” ");
INSERT INTO tim_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuŋe den ginŋe are hârok makmâ metem hân are hepulep. ");
INSERT INTO tim_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hepunmâ ikiŋe kepiaŋân arim den emetŋe âgâm den pat âlepŋe makyeŋgiep. Hain akto luâk âmbâle arekŋe otneyeŋe arimbo sân sân mem hin dâyi, “Luâk ire amâ niŋande hekalaŋdo nâŋgâ nâŋgâŋe miawagaŋmap akto kulem keiŋe keiŋe mendo miawakmap? ");
INSERT INTO tim_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Imâ nengâlân gâtŋe, eweŋe Yosepe emet ketugu ketugu âi meminep akto memeŋe amâ ingâtŋe Maria are akto emilupŋe amâ Yakobo siâ akto Yosepe akto Simoŋ siâ akto Yudasi ");
INSERT INTO tim_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","akto garilupŋe amâ in mandâi aregât yâk siâ me siâ hârok are yâgâtenba mem miap palep?” ");
INSERT INTO tim_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","dâm nâŋgâmbiâ bâliep. Hain akbiâ Yesuŋe hin makyeŋgiep, “Anutugât Propete siâŋe hân siân siân arim makyeŋgimbo denŋe nâŋgâm heŋgemgomai. Dâ ikiŋe kepiaŋân âgâm makyeŋgimbo âmâ hâkâŋ akmâ hamiaŋmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hain dâm kepia ambolupŋande biwiyeŋe yâkgâlân bo katmâ âmâ hâkâŋ agi aregât yâk yeŋgâlân gâtŋe konok konok mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Akto sop ain luâk kembu kotŋe Herote arekŋe Yesuŋe âi mem kotŋe siâ siâ akmâ malep aregât den nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nâŋgâm hoŋ bawalupŋe makyeŋgim hin dâep, “Luâk kotŋe Yohane tu puli keiŋe kalep are emelâk moep arekŋe sumânba agatmâ mandâp. Aregât kulem keiŋe keiŋe siâ siâ memap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Dâ Heroteŋe Yohane kondo moep aregât keiŋe hin. Ulikŋân Herote are akto luâk siâ kotŋe Pilipo emi teu tatminiat. Akto Pilipo arekŋe âmbenŋe kotŋe Herodia miep. Mendo âmbâle arekŋe luâkŋe Pilipo are hepunmâ Herote miep. ");
INSERT INTO tim_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hain manbela Yohane tu puli keiŋe kalep arekŋe Herote hin magaŋep, “Den kârikŋe kom kandâge memenâ bâliâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hain dâmbo kondere moâk dâm kala busi kâlegen kato talep. Hain akto âmâ luâk âmbâleŋe Yohane âmâ Anutugât Propete dâmini aregât Heroteŋe hamewakmâ hepulep. ");
INSERT INTO tim_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Akto tatmâ hilâm siân Herote miawagepgât hombaŋ sopŋe akto galalupŋe mendugu yekmâ sot om yeŋgiep. Sot om yeŋgimbo mendugum nem tatbiâ âmbenŋaet baratŋe âmbâi sigan arekŋe hutyeŋân kinmâ keŋgu kom ândiep. Hain akto âmâ kambiamyeŋe âlepŋe akto ");
INSERT INTO tim_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Heroteŋe hin dâep, “Anutugât dewunŋân makbe. Wan me wan ekmâ ulit niŋmenâ âmâ are âmâ âlepŋe giŋbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hain dâmbo arim memeŋe aikombo memeŋande Yohane kombiâ moâk dâm magaŋdo baratŋande bam Herote hin magaŋep, “Yohane tu puli keiŋe kalep aregât kautŋe hârem kondoân katmâ niŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hain dâmbo Heroteŋe nâŋgâmbo umatŋe agep. Gârâmâ magep aregât den koko bo agep. Akto luâk tali are yeŋgât dewun yeŋân denŋe gewopgât magep. ");
INSERT INTO tim_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Akto hoŋ bawaŋe siâ tâwât amboŋe are huŋgun aŋdo tâwât mem arim kala busi kâlegen âgâep. ");
INSERT INTO tim_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Âgâm Yohanegât hanŋe hârem kautŋe kondoân katmâ mem gutmâ âmbâi sigan are waŋep. Waŋdo memeŋaelân lokom ariep. Lokom arim memeŋe waŋep. ");
INSERT INTO tim_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Akto Yohanegât hoŋ bawalupŋande pat are nâŋgâm ari hâkŋe mem hangoyi. Hangom âmâ aregât arim Yesu magaŋi. ");
INSERT INTO tim_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuŋe den are nâŋgâm kepia are hepunmâ luâk âmbâle dondâ are hepun yekmâ waŋga mem hân pumângen ariep. Arimbo luâk âmbâleŋe nâŋgâm kepia humo hepunmâ kei hân watmâ togoyi. ");
INSERT INTO tim_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Akto waŋganba sopanbiâ Yesuŋe luâk âmbâle dondâ yekmâ okot nâŋgâyeŋgim kundatdâ mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hain akmâ mando hoŋ bawalupŋande togom hin magaŋi, “Emet eŋgaiŋe aktâp. Akto hân iren kepia me emet bo tatâi aregât luâk âmbâle ire huŋgun yeŋgimenâ mopyeŋe aguwopgât kepia enemânâk ain arim sot puligom neŋet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hain dâmbiâ hin makyeŋgiep, “Wangât ariŋetgât maktâi? Ye sot om yeŋgiŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hain dâmbo hin dâyi, “Nen âmâ sot bo menden. Sot koaŋe momerâk akto iŋan lâuwâ kindâp.” dâmbiâ hin dâep, ");
INSERT INTO tim_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Sot are niŋŋet.” dâmbo mem ga waŋbiâ ");
INSERT INTO tim_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","luâk âmbâle makyeŋgimbo umiliŋ kakŋe tete tatmâ ariyi. Hain tatbiâ sot are mem kinmâ himbimân ekmâ Anutu mepaiŋe miep. Mepaiŋe mem sot yeŋgimbo luâk âmbâle are yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yeŋgimbiâ nem tepyeŋe pikto sot pipiŋe ge yiep are pitim mendugum haka bât bip bip hârok keiân lâuwâ lugumbiâ pigep. ");
INSERT INTO tim_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Akto luâk sot neyi are yeŋgât yalayeŋe âmâ 5,000. Dâ âmbâle nanaŋ âmâ bo oyaŋyegi. ");
INSERT INTO tim_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ainâk Yesuŋe hoŋ bawalupŋe huŋgun yeŋgim hin dâep, “Yeŋe soŋ waŋgan âgâm haru biken arimbiâ âmâ nâmâ titnan luâk âmbâle ire huŋgun yeŋgire arimbiâ âmâ togowerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hain dâmbo arimbiâ yâk luâk âmbâle are huŋgun yeŋgimbo hârok arim metembiâ ikiŋeâk Anutu ulilaŋberâm gimbâŋe siân âgâep. Âgâ eweŋe ulilaŋmâ kindo emet eŋgaiŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Eŋgaiŋe akto luâklupŋe waŋga mem arim emelâk haru tânâmŋângen ariyi. Arimbiâ waŋga hâmeŋângenba seru gambo waŋga are âgâm gem malep. ");
INSERT INTO tim_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Gem mando emet hauŋberâm akto hândâk pipiŋe tatoâk Yesuŋe haru kakŋân tâlim tâlim yâk yeŋgât enemyeŋân togoep. ");
INSERT INTO tim_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Togombo ekmâ sân sân mem ongâyeŋe hogombo hin dâyi, “Niambi siâ togoâp.” dâm hamewakmâ kamboŋi. ");
INSERT INTO tim_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kamboŋbiâ âmâ dowâk makyeŋgim hin dâep, “Bo hamewakŋet. Biwiyeŋe sândugeâk. Nâŋe togoân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hain dâmbo Petoroŋe hin magaŋep, “Gâŋe togoât aregât nogonmenâ nâkâ haru kakŋân tâlim tâlim gâŋgâlân gutbe.” ");
INSERT INTO tim_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Hain dâmbo Yesuŋe, “Âlepŋe gut.” dâmbo Petoroŋe waŋga hepunmâ gem haru kakŋe tâlim tâlim Yesugâlân baep. ");
INSERT INTO tim_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bam haru are ekto seruŋe waito agatmâ gem agatmâ gem akto ekmâ hamewagep. Hamewakmâ haruân gewerâm agep. Hain akmâ konmâ hin dâep, “Humo tân nugu.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesuŋe dowâk bâtŋe panmâ Petoro mem hin magaŋep, “Gâ nâŋgât biwige bo katmâ heŋgemgomat. Gâ wangât han lâuwâ aktât?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hain magaŋdo waŋgan bam âgâmbela ainâk seru nâŋâgâep. ");
INSERT INTO tim_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Akto luâk waŋgan tali yâkŋe enemŋân kâŋgom hin dâyi, “Gâ Anutugât Nanŋe bunŋe.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Haru are hâtikom kepia siâ kotŋe Genesaret ain ariyi. ");
INSERT INTO tim_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Arimbiâ patŋe nâŋgâm togom ekmâ nâŋgaŋi. Akto luâk arekŋe den katbiâ kepia ewumâk ewumâk ariep. Akto luâk âmbâleŋe kundatdâ meyekmâ yâkgâlân togoyi. ");
INSERT INTO tim_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Togom Yesu konmâ magaŋmâ hin dâyi, “Apo nengâlân gâtŋe kundatdâ irekŋe sâŋgumge howaim âmâ âlepŋe akŋet.” dâmbiâ âlepŋe dâmbo bikŋande howaimbiâ Yesuŋe heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sop ainâk Parisaio luâk akto Yuda luâk yâk hârokŋe bâgilupyeŋe yeŋgât den lokom sot nemberâm akmâ bâtyeŋe pulimâk sot nemini. Luâk arekŋe Yerusalem kepianba togom Yesugâlân mendugum hin dâm aikoyi, ");
INSERT INTO tim_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Hoŋ bawalupgande wangât bâgilupnenŋe yeŋgât den bo lokom bâtyeŋe tuân bo pulim yân sot mem nendâi?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aregât hin makyeŋgiep, “Dâ ye amâ wangât yeŋaet agak memeyeŋe bâliwopgât Anutugât den kârikŋe kalep are loŋgaimai? ");
INSERT INTO tim_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Aregât keiŋe hin. Anutuŋe den kârikŋe makto Moseŋe kulemgoep bikŋe hin tatâp, “Gâ ewege memege amukyetŋân manben.” akto bikŋe hin tatâp, “Luâk âmbâle siâŋe eweŋe memeŋe den bâleŋe makyeŋgiwiap âmâ humomolupŋande kombiâ mombiap.” hain tatâp. ");
INSERT INTO tim_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aregât ye den hamiaŋmai. Hamiaŋmâ hin dâmai, “Luâk âmbâle siâŋe eweŋe memeŋe hin dâm makyetkiwiap, “Meŋ, apo, sot me puli me wan me wan yetkiwiangât are Anutugât sumbe emetŋân katere tatbiap.” ");
INSERT INTO tim_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","dâm puli me wan me wan are ain kato tato ârândâŋ akbiap.” dâmai. Aregât eweŋe memeŋe tânyeŋguwiapgât nâŋgâmbiâ gemap. Akto nengât den bunŋe agâk dâm Anutugât den kombiâ gemap. ");
INSERT INTO tim_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ye hiaŋgi luâk. Ulikŋân propete Yesaiaŋe ye dop yeŋgum hin kulemgoep, ");
INSERT INTO tim_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Anutuŋe hin dâep, “Luâk âmbâle kâmot irekŋe lauyeŋandeak nâŋgât kotne mem agatmai. Dâ han biwi olowâk amâ bo. ");
INSERT INTO tim_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Akto luâk yeŋgât den are nâŋgâmbiâ bunŋe akmap. Hain akmâ hâkŋeak nâŋgât kotne mem agatmai.” hain kulemgoep are bunŋe akto ye Anutugât den kombiâ nâŋgâre dondâ bâliâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Akto Yesuŋe luâk âmbâle yeŋgondo togombiâ hin makyeŋgiep, “Ye den ire nâŋgâm heŋgemgom mem biwiyeŋân katŋet. ");
INSERT INTO tim_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wan me wan luâkŋe lauyeŋân nembiâ gemap arekŋe âmâ luâk mem heleŋ bo ketugu yekmap. Dâ wan me wan luâk biwiyeŋe kâlegen yem lauyeŋânba gamap arekŋe âmâ luâk mem heleŋ ketugu yekmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hain dâmbo hoŋ bawalupŋande togom magaŋmâ aikom hin dâyi, “Parisaio luâk makyeŋgimenâ nâŋgâm bâligiŋdâi are nâŋgât me bo?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hain dâmbiâ hin dâm makyeŋgiep, “Ewenande bo kâmetyegep are hâmbâi hârok hindâm panyekbiap. ");
INSERT INTO tim_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aregât yeŋe hepun yekbei. Luâk dewunyetŋe bok bokŋe arekŋe oloŋakmâ gain gain dâp hekalaŋgiwiandat? Gârâmâ Parisaio luâk âmâ dewunyeŋe bok bokŋe hainâk luâk âmbâle Anutugât dâp hekat yeŋgiweren dâm dâp bâleŋângen oloŋyekmâ arimai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hain dâmbo Petoroŋe magaŋmâ hin dâep, “Apo, den dopŋe maktât aregât keiŋe maknengimenâ nâŋgâne.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hain dâmbo hin dâep, “Woe, yekai hainâk nâŋgâ nâŋgâyeŋe bo me? ");
INSERT INTO tim_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ye den iregât keiŋe nâŋgâŋet. Ye sot nembiâ lauyeŋânba gem tepyeŋân tatmap. Akto tepyeŋânba âmâ gem lâmân arimap. ");
INSERT INTO tim_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dâ luâk âmbâle bâleŋe yeŋgât biwiyeŋân wan me wan yemap are makbiâ den arekŋe luâk âmbâle mem heleŋ ketugu yekmap. ");
INSERT INTO tim_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aregât keiŋe hin. Luâk âmbâle bâleŋe are yeŋgât biwiyeŋân hin yemap. Nâŋgâ nâŋgâ bâleŋe siâ yeŋgumbiâ moŋetgât, luâkdâ âmbendâ mem hepunak hepunak, egâliaŋ bâleŋe, kâmbu, hiaŋgi den akto den hembalik galagât hogo hogo bâleŋe olowâk. ");
INSERT INTO tim_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Arekŋe luâk âmbâle biwiyeŋân gemap. Hain gem miawakto bâleŋe akmai. Dâ luâk âmbâle bâtyeŋe bo pulim sot mem nemai are amâ bâleŋe bo akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu kepia are hepunmâ kepia lâuwâ kotyetŋe Tiro akto Sidoŋ aregen ariep. ");
INSERT INTO tim_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ain arimbo âmbâle siâ Kanaŋ gâtŋe Yuda gâtŋe bo arekŋe togom Yesu hin ulilaŋep, “Humo, Dawidigât hakuŋe nâŋgât akmâ han kalem akniŋ. Sinduk baniara bâleŋe siâŋe baratne mem bâlimbo umatŋânâk manmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hain dâmbo Yesuŋe den hâuŋe bo magaŋep. Hain akto âmbâle arekŋe hoŋ bawalupŋe hâwât yekto Yesu hin magaŋi, “Apo, âmbâle irekŋe hâwât nenekto hâkâŋ akten aregât watmenâ ariâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hain dâmbiâ Yesuŋe aregât hin magep, “Israegât kâmotŋe gulip manmai are heŋgem yeŋguwen dâm Anutuŋe huŋgun niŋdo geân. Dâ kâmot siâ siâ are yeŋgât bo geân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hain dâmbo âmbâle are gutmâ enemŋân kâŋgom kinmâ hin dâep, “Humo, gâŋe nâ tân nugu.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hain dâmbo hin dâep, “Nanaŋ yeŋgât sot are mem dua yeŋgienŋe bo ârândâŋ akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hain dâmbo hin magaŋep, “Kembu, bundâk maktât are nâŋgâre ârândâŋ aktâp gârâmâ nanaŋŋe soŋ sot nem tatbiâ pipiŋe gembo âmâ duaŋe hanâk nemai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hain dâmbo hin magaŋep, “Meŋ, den hain maktât aregât han biwigande nâŋgâ niŋmâ kepilâm kinmâ maktât aregât nâŋgâ giŋdân.” dâep. Hain dâmbo emetŋân arim sinduk baniara arekŋe Yesuŋe magep sop ainâk baratŋe are hepulep. ");
INSERT INTO tim_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Akto Yesu kepia are hepunmâ Galilaia bâtgum ginŋân ariep. Arim gimbâŋe siân âgâ talep. ");
INSERT INTO tim_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Akto luâk âmbâle dondâŋe yâkgâlân mendugum luâk âmbâle keiyeŋe bâleŋe me dewunyeŋe bok bokŋe akto hagityeŋe goŋ goŋ agu aguŋe me den bo makmâ mali akto kundat keiŋe keiŋande meyegep are loko yekmâ togo Yesugât keiŋân menduguyegi. Hain akbiâ Yesuŋe mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Heŋgem yeŋgumbo denyeŋe bo arekŋe den hogoyi akto hagityeŋe kâm kâmŋe are ârândâŋ akyeŋgiep akto keiyeŋe bâleŋe arekŋe bam guli akto dewunyeŋe bok bokŋe arekŋe emet egi. Hain akbiâ luâk âmbâle ain kili arekŋe are yekmâ nâŋgâmbiâ dâtŋe agep. Hain akmâ Israegât Humoyeŋe Anutu aregât kotŋe mem agali. ");
INSERT INTO tim_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuŋe hoŋ bawalupŋe yeŋgondo togoyi. Togombiâ hin makyeŋgiep, “Nâ luâk âmbâle ire yekmâ okotne nâŋgân. Nâ olop tatmâ manbiâ hilâm âlâwu bo akto sot bâlâk tatmâ mandâi. Gârâmâ sot bâlâk âmâ bo huŋgun yeŋgire ariwerâi. Ageine yân huŋgun yeŋgire arim dâwân sotgât dewun biri yeŋguwop.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Akto hoŋ bawalupŋande hin dâyi, “Hân iren âmâ aŋgim nene bo tatâp aregât yâgâtenba sot unduwâk mem luâk âmbâle kâmot humo ire yeŋgiweren?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dâmbiâ Yesuŋe hin makyeŋgiep, “Yeŋgâlân sot wan kindâp?” dâmbo hin dâyi, “Sot koaŋe nâmbulân lâuwâ akto iŋan bâleŋ maleŋ konok konok kinnengiâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hain dâmbiâ Yesuŋe luâk âmbâle are makyeŋgimbo hân tete tatmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akto Yesuŋe sot koaŋe nâmbulân lâuwâ are akto iŋan amon siâ are mem Anutu mepaiŋe mem munditmâ yeŋgiep. Yeŋgimbo potatmâ luâk âmbâle are yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yeŋgimbiâ nem tepyeŋe pikto hoŋ bawalupŋande sot pipiŋe are pitim mendugum haka nâmbulân lâuwâ lugumbiâ pigep. ");
INSERT INTO tim_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Akto luâk sot neyi are âmâ 4,000. Dâ âmbâle nanaŋ âmâ bo oyaŋyegi. ");
INSERT INTO tim_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Akto Yesuŋe luâk âmbâle are huŋgun yeŋgimbo arim meteyi. Arim metembiâ âmâ luâklupŋe olop waŋgan âgâm kepia siâ kotŋe Magadaŋ aregen ariyi. ");
INSERT INTO tim_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Akto Parisaio luâk bikŋe akto Sadukaio luâk bikŋe arekŋe Yesu dop kom hiaŋberâm togom hin magaŋi, “Himbimgât kulem siâ memenâ ekne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hain dâmbiâ hin dâep, “Ye amâ hin akmai. Eŋgaiŋe akto himbim gilâm aktâp are ekmâ hin dâmai, “Woe, hamandat gilâm aktâp aregât emet huraguwerâp.” dâmai. ");
INSERT INTO tim_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dâ hândâgân hamandatŋe tigimbo hin dâmai, “Woe, hamandat hândâk aktâpgât uŋak amâ tânâk seru akberâp.” hain dâmai. Aregât emet kulem keiŋe ekmâ nâŋgâm heŋgemgomai. Dâ sop humo aregât keiŋe amâ bo nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aregât siâkâ makbe. Luâk âmbâle bâleŋe akmâ dâp gulip manmai arekŋe kulem miawakto ekne dâmai. Ulikŋân luâk kotŋe Yona wan miep aregât kulem konok areâk miawakto ekbai.” dâep. Hain dâm Yesuŋe hepun yekmâ luâklupŋe olop waŋgan âgâm ariyi. ");
INSERT INTO tim_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Waŋga mem bâtgum hâtikowerâm akbiâ luâklupŋe nelâm yeŋgimbo sot bo mem bâtgum hâtikoyi. ");
INSERT INTO tim_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Akto Yesuŋe makyeŋgim hin dâep, “Parisaio akto Sadukaio yeŋgât kâtembe aregât biwiyeŋaet damunŋe golâk manbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hain dâmbo magaŋgi goaŋgi akmâ hin dâyi, “Sot bo mem togoen aregât maktâp.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","nâŋgâm hin makyeŋgiep, “Ye sotgât nâŋgâmbiâ humo aktâp aregât nâŋgâlân biwiyeŋe getek katmai. ");
INSERT INTO tim_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nâ siâ me siâ agân aregât nelâmyeŋgiep mon? Luâk 5 tausen akmâ sot koaŋe momerâk nembiâ pipiŋe gembo haka dondâ lugumbiâ pigep. ");
INSERT INTO tim_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Akto luâk 4 tausen akmâ sot nâmbulân lâuwâ nembiâ tepyeŋe pigep. Pikto pipiŋe gembo haka dondâ lugumbiâ pigep. ");
INSERT INTO tim_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aregât sotgât bo nâŋgâmbiâ humo akbiap akto kâtembe gât maktân are âmâ sotgât bo maktân. Maktân are lâuwâŋe maktere nâŋgâŋet. Parisaio akto Sadukaio yeŋgât kâtembe hâkŋe hâkŋe arekŋe yeŋgâlân hâtikombo bâliwâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hain dâm makyeŋgimbo hin magaŋgi goaŋgi agi, “Sotgât hanokoak bo akŋet dâm maknengiâp. Parisaio akto Sadukaio yâk yeŋgât den nâŋgâwâi dâm maknengiâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Akto ainba arim hân kotŋe Kaisarea kotŋe siâ Pilipi aregen ariyi. Ain arimbiâ Yesuŋe hin aiyeŋguep, “Luâk âmbâleŋe nâ luâk akmâ geân nâŋgât gain gain dâmai?” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","hin dâyi, “Bikŋande âmâ Yohane tu puli luâk arekŋe mandât dâmai. Dâ bikŋande âmâ Eliaŋe gem mandât dâmai. Dâ bikŋande âmâ propete siâ kotŋe Yeremia me propete siâ me siâŋe mandât dâmai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hain dâmbiâ hin aiyeŋguep, “Dâ yeŋe âmâ nâŋgât gain gain dâm nâŋgâ niŋmai?” dâmbo Petoro kotŋe siâ Simoŋ arekŋe hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","“Anutuŋe huŋgunaŋdo miawakbiapgât dâtâŋe Anutu manman kârikŋe yâkgât nanŋe gem mandât.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hain dâmbo hin dâep, “Simoŋ Yonagât nanŋe luâk âmbâle siâŋe den ire makgiŋdo bo maktât. Ewene himbimân mandâp arekŋe den ire makgiŋdâp aregât heroŋe ak. ");
INSERT INTO tim_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gâŋgât kotge Petoro den aregât keiŋe amâ kât aregât dopŋe hainâk yu maktât den arekŋe nune emet ketuguwian ain Hememgât ambolupŋande nâŋgât kâmot are mem ge katyekberâm âi humo mem kinmâ pâpkowai. ");
INSERT INTO tim_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Akto nâ himbim kâleŋaet hâŋgigât tâkŋe giŋbian aregât gâ hânân wan hikowiatgât âi memenâ himbimân gai hikowiapgât miawakbiat. Dâ hânân hulaŋbiatgât âi memenâ himbimân gai hulaŋbiapgât miawakbiap.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Akto Yesuŋe hoŋ bawalupŋe makyeŋgim hin dâep, “Nâ Anutuŋe huŋgun niŋdo geân iregât den siâ me siâ bo makyeŋgiwei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Akto sop ain Yesuŋe keiŋe katmâ Yerusalem kepian âgâmbo Israe yeŋgât humomolupyeŋe akto Mosegât den kârikŋe makmâ kepigi akto sumbe kat kat luâk arekŋe mem siâ siâ mâŋgim hâk hilâlâm waŋmâ kombiâ mom benŋe hilâm âlâwu bo akto momoŋânba agatbiap aregât den hoŋ bawalupŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Akto Petoroŋe Yesu kewugum ginŋângen bam den kugâk kugâk mâŋgim hin magaŋep, “Humo, gâ hain bo akbiat. Wan me wan akgiŋbaigât maktât are gâŋgâlân bo miawakbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hain dâmbo Yesuŋe purik dâm Petoro magaŋmâ hin dâep, “Gâ Hiaŋgi Amboŋe aregât hepunnek. Gâmâ nâ peŋ panmâ nuguâkgât dâp tiginiŋdât. Gâ Anutugât nâŋgâ nâŋgâ are bo nâŋgât. Gâ luâk yeŋgât nâŋgâ nâŋgâ are nâŋgâm maktât aregât heniŋdât.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hain dâm hârok hin dâm makyeŋgiep, “Luâk âmbâle bikŋande biwiyeŋe nâŋgâlân katmâ nâ olop ariwerâm âmâ wan me wanŋe hilipyeŋguwiap aregât bo hamewakmâ hanâk watnekmâ manbei. ");
INSERT INTO tim_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dâ siâŋe ikiŋe hâkŋe gangerâwiap are âmâ yâk manman âlepŋe bo peniaŋbiap. Akto siâŋe nâŋgât den âi aregâlâk nâŋgâm mando kombiâ âmâ momoŋân ba agatbiap. ");
INSERT INTO tim_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Luâk siâ hângât wan me wan hârok mem mando manmanŋe gulip akto gain gain manmanŋe miawagaŋbiap? Akto manmanŋaet den dâtâŋe are gain mendo ârândâŋ akbiap? ");
INSERT INTO tim_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aregât keiŋe hin. Sop humoân Ewenaet pagaleŋe olop akto aŋelolupŋe âkâ olowâk Ewenande luâk akmâ geân nâ lâuwâŋe huŋgun niŋdo gewian, sop ain âmâ luâk âmbâle agak meme akmai aregât hâuŋe hainâk yeŋgiwian. ");
INSERT INTO tim_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Akto aregât makyeŋgire nâŋgâŋet. Luâk bikŋe yu kindâi ire hâmbâi boâk mombiân nâ emelâk luâk akmâ geângât togom damunyeŋe aktere nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Akto hilâm nâmbulân konok bo akto Yesuŋe Petoro Yakobo akto emiŋe Yohane kewugu yekto gimbâŋe siâ ain âgâyi. Âgâm ain yeŋeâk kili. ");
INSERT INTO tim_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ekmâ kinbiâ Yesugât hâkŋe purik âgâmbo aŋgâ agep. Hain akto enem dewunŋe arekŋe dewutâ dewunŋe hinare akmâ pakpak dâep. Pakpak dâmbo sâŋgumŋe wan arekŋe kau kau dondâ agep. ");
INSERT INTO tim_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Akto ainâk Mose akto Elia miawakbela Yesu olop den magaŋgi goaŋgi akbiâ yegi. ");
INSERT INTO tim_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Akto Petoroŋe yekmâ Yesu magaŋmâ hin dâep, “Humo wan siâ hekat nengimenâ ekten aregât ukenŋe nâŋgâen. Gârâmâ gâŋe âlepŋe dâmenâ âmâ nâŋe uligi âlâwu in ketuguwerân. Gâŋgât siâ akto Mosegât siâ akto Eliagât siâ.” ");
INSERT INTO tim_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hain dâm makmâ kindo are olowâk hamandat kau kau arekŋe tigiyegep. Akto hamandat are kâlegenbak den siâ hin miawagep, “Ire âmâ nâŋgât nanne akto biwinande mem heŋgemgoman. Akto yâkgât agak meme aregât ukenŋe akman gârâmâ ye yâkgât den nâŋgâwei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Akto hoŋ bawalupŋande den are nâŋgâm hamewakmâ enem dewunyeŋe hânângen gembo kâŋgom tali. ");
INSERT INTO tim_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Akto Yesuŋe enemyeŋân gutmâ mem goaŋ yekmâ hin makyeŋgiep, “Agatŋet. Ye hamep bo akŋet.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","agatmâ luâk lâuwâ are bo yelegi. Yesuŋe konok ikiŋak kindo egi. ");
INSERT INTO tim_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Akto gimbâŋe are hepunmâ pelepŋe gem gem Yesuŋe den kârikŋe makyeŋgim hin dâep, “Wan me wan âuren ye ektâi aregât den luâk siâ me siâ bo magaŋbei. Titnan luâk akmâ geân nâ momoŋânba agatbian ain âmâ âlepŋe makyeŋgiwei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Akto hoŋ bawalupŋe olop kili arekŋe aikom hin dâyi, “Mosegât den kârikŋe makmâ kepikmai arekŋe hin dâmai, “Eliaŋe lâuwâŋe togombo âmâ hamiŋân Anutugât hoŋ bawa togowiap.” dâmai. Amâ gain gain?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hain dâmbiâ hin makyeŋgiep, “Amâ bundâk, Eliaŋe âmâ togom wan me wan are hârok heŋgemgowiap. ");
INSERT INTO tim_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gârâmâ aregât hin makyeŋgiwe. Elia âmâ lâuwâŋe emelâk togoep gârâmâ luâk bikŋande bo ekmâ nâŋgâm heŋgemgom ukenyeŋe watmâ agak meme keiŋe keiŋe agaŋbiâ moep. Aregât hainâk akmâ luâk akmâ geân nâ hâk hilâlâm niŋbiâ mombian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesuŋe hain dâmbo hoŋ bawalupŋande hin nâŋgâyi, “Eliagât maktâp amâ Yohane tu puli keiŋe kalep aregât maktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Akto arewa gembiâ luâk âmbâle dondâ yâkgâlân togoyi. Akto luâk siâŋe Yesugât enemŋân togom pâwutŋe ligim hânân tatmâ kâŋgom hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Humo, gâ hanâk nannaet okotge nâŋgâ. Nâ nune nanne biwi gulip akmâ manmap. Akto kâlâwân me tuân gembo sop unduwâk aktâp. ");
INSERT INTO tim_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Akto gâŋgât hoŋ bawalupgande mem heŋgemgoŋet dâm mem togore heŋgemgowerâm âsimbiâ bo agep.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hain dâmbo Yesuŋe hin dâep, “Ye wangât nâŋgâlân biwiyeŋe bo katmâ âmâ yeŋgaelâk nâŋgâm kautyeŋe oremai. Nâ ye olop sop kâlep bo manbaen aregât arire âmâ ye gain gain akmâ manbai? Akto sokom katyektere sop kâlep akbiap mon? Bâin, nanaŋ are kewugum nâŋgâlân gaŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hain dâmbo kewugum yâkgâlân âgâmbiâ sinduk baniara bâleŋe are den kugâk kugâk mâŋgimbo luâk sigan are hepunmâ ariep. Akto ainâk kundat are bo agaŋep. ");
INSERT INTO tim_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Akto hoŋ bawalupŋande ikiŋeâk yoŋâk tatoân Yesugâlân togom magaŋmâ hin dâyi, “Keiŋe gain gaingât nenŋe sinduk baniara bâleŋe are watberâm mem âsienŋe bo aktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Hain dâmbiâ yâkŋe hin makyeŋgiep, “Ye nâŋgâlân biwiyeŋe kârikŋe bo katmâ heŋgemgomai aregât walaŋberâm âsiâi. Dâ yeŋe biwiyeŋe nâŋgâlân getek katmâ âmâ âlepŋe borâŋe ire magaŋmâ hin dâwai, “Gâ agatmâ indâgen ari.” dâmbiâ ariwerâp. Akto wan me wan miawagâk dâmbiâ âlepŋe miawakbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Akto Yesu Aposololupŋe olop Galilaia hânân ariyi. Arim Yesuŋe hin makyeŋgiep, “Nâ luâk akmâ geân nâ luâk bikŋande nugumbiâ mombian. ");
INSERT INTO tim_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Akto nugumbiâ mom benŋe hilâm âlâwuŋân momoŋânba agatbian.” Hain dâmbo biwiyeŋe umatŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Akto arewa Kapanaum kepian ariyi. Akto sumbe kat kat emetŋaet puli dâtâŋe memini arekŋe Petorogâlân togom aikom hin dâyi, “Yeŋgât tiksayeŋande sumbe kat kat emetŋaet puli siâ katmap me bo?” dâm magaŋi. ");
INSERT INTO tim_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hain dâmbiâ Petoroŋe, “Âo.” dâep. Hain dâm ikiŋak emet kâlegen âgâmbo Yesuŋe soŋ magaŋmâ hin dâep, “Simoŋ gâ gain gain nâŋgât? Hângât luâk kembuŋe yeŋe nanlupyeŋe yeŋgâlânba puli dâtâŋe memai me luâk aŋgâ yeŋgâlânba memai?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hain dâmbo Petoroŋe magaŋmâ dâep, “Luâk aŋgâ yeŋgâlânba memai.” dâmbo Yesuŋe hin magaŋep, “Bundâk maktât. Gârâmâ nanlupyeŋande puli dâtâŋe kat katgât âi bo memai. ");
INSERT INTO tim_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gârâmâ bo katenŋe nâŋgâmbiâ bâliwopgât hanâk netgât puli dâtâŋe kat. Gâŋe haruângen arim tâk panmâ iŋan ulik gulik oloŋberât are tepŋe gâimenâ puli koaŋe siâ miawakto mem netgât katberât.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Akto sop ain hoŋ bawalupŋande Yesugâlân togom hin magaŋi, “Anutuŋe damun nenŋe akmap nengâlân gâtŋe niŋande bikŋe ewangi nenekmâ damun nenŋe akbiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hain dâmbiâ nanaŋ siâ kondo gambo hutyeŋân kato kindo ");
INSERT INTO tim_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","hin dâm makyeŋgiep, “Den ai nuguâi aregât makyeŋgire nâŋgâŋet. Nanaŋlupyeŋande akmai are yeŋe hain akbiâ âmâ Anutuŋe meyekbiap. Dâ hain bo akbai amâ Anutugât kâmolân bo dewati nenekbai. ");
INSERT INTO tim_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Akto nanaŋ ire hainare akmâ amâ ikiŋaet nâŋgâmbo gewiap aregât yeŋgâlân gâtŋe siâŋe hainâk akmâ ikiŋaet nâŋgâmbo gembo âmâ Anutugât kâmot damunyeŋe akbiap. ");
INSERT INTO tim_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Akto luâk âmbâle siâŋe âmâ nanaŋ ire hinare tângomap arekŋe amâ nâ tân nugumap aregât dop akmap. ");
INSERT INTO tim_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dâ luâk siâŋe nanaŋ biwiyeŋe nâŋgâlân katmai are yeŋgâlânba konok bâliwerâm hâkŋe hâkŋe hain akto âmâ gâuk, siâŋe kât humo dondâ hanŋân imbogoaŋmâ haru bâtgumân hâkokombo dâine arekŋe âmâ siâ me siâ owâiŋe miawagaŋdâp akbop. ");
INSERT INTO tim_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Akto dop yeŋgumapŋe ye hârok dop yeŋguwerâm biwiyeŋân gewiapgât dop tatâp aregât hân hârokgât okotne nâŋgân. Gârâmâ luâk âmbâle siâŋe bikŋe bâleŋe akŋet dâm hilip yeŋgumbo Anutuŋe hâuŋe humo waŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Akto hememgât pat akbâigât bâtyeŋe me keiyeŋe bikŋande bâleŋe akbâigât hârem panbei. Hain akmâ keiyeŋe me bâtyeŋe bikŋe are âlepŋe akto manbiâ ârândâŋ akbiâp. Dâ bâtyeŋe keiyeŋe biken biken âlepŋe tatbiap âmâ arekŋe oloŋyekto kâlâwânâk manmâ âgâwâi. ");
INSERT INTO tim_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Akto dewunyeŋande bâleŋe akŋet dâm oloŋ yekto dosa akbâen dâm dewunyeŋe are kâwutmâ panbei. Akto dewunyeŋe konogâk tatyeŋgiwiap amâ âlepŋeâk manbai. Dâ dewunyeŋe lâuwâ lâuwâ tatbiap amâ arekŋe oloŋ yekto hememgât kâlâp humo yemap ain gewâi. ");
INSERT INTO tim_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Akto himbimân aŋeloŋe nanaŋ damunyeŋe akmai arekŋe âmâ hokboâk hokboâk Ewene ekmai. Aregât nanaŋ sisik ire hut nenŋân hinare yeŋgât nâŋgâmbiâ gewop. ");
INSERT INTO tim_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Akto luâk âmbâle hilip aguwâigât nâ luâk akmâ geân nâ heŋgemgo yekbian aregât hin makbe. ");
INSERT INTO tim_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Luâk siâ lama 100 kinaŋbiap. Akto hutyeŋânba konokŋe heambukto amboŋande lama bikŋe are gimbâŋân hepun yekmâ siâ heambugep aregât undâgâtbiap. ");
INSERT INTO tim_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Undâgâtmâ mem miawakmâ okot âlep akbiap. Dâ lama bo heambukmâ âlepŋeâk kinbai aregât amâ heroŋe hain bo akbiap. ");
INSERT INTO tim_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hainâk Ewene himbimân mandâp arekŋe nanaŋ itik matik bâliwâi dâm damunyeŋe akmap. ");
INSERT INTO tim_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Akto den siâ hin makbe. Galage siâŋe gâŋgâlân dosa akto âmâ bâleŋe aregât keiŋe pumân magaŋben. Hain akmenâ yâkŋe gâŋgât den nâŋgâmbo âmâ gala konok manbiandat. ");
INSERT INTO tim_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dâ yâkŋe gâŋgât den bo nâŋgâmbo âmâ luâk âmbâle amon siâ yeŋgonmenâ gutmâ den yetŋe ârândâŋ ketugune dâwai. ");
INSERT INTO tim_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Dâ yâk yeŋgât den are bo nâŋgâmbo nâŋgât kâmolân gâtŋe arim makyeŋgiwen. Akto are âkâ hainâk yâk yeŋgât den are bo nâŋgâmbo âmâ gâŋe yâk hin magaŋben, “Gâmâ luâk bâleŋe akmai are yeŋgât dop aktât.” dâwen. ");
INSERT INTO tim_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Akto aregât bunŋe maktere nâŋgâŋet. Ye hânân wan hikowaigât âi membiâ himbimân gai hikowiapgât miawakbiap. Dâ hânân hulaŋbaigât âi membiâ himbimân gai hulaŋbiapgât miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Gârâmâ siân nâŋgât kâmolân gâtŋe lâuwâ me âlâwu Anutu ulilaŋberâm mendugum kinbiâ ainâk nâ hutyeŋân manbian aregât wan me wan ulilaŋberâm han konok katmâ Anutu ulilaŋbai amâ ainâk Ewene himbimân manmap arekŋe wan me wan âlepŋe yeŋgiwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Akto sop ain Petoroŋe Yesugâlân togom magaŋmâ hin dâep, “Humo, galanande sop amon nâŋgâlân dosa akto âmâ nâŋe dosa are hepun aŋbian? Nâmbulân lâuwâ akto hepun aŋbian me kakŋân siâkâ aktoân hepun aŋbian?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hain dâmbo Yesuŋe magaŋmâ hin dâep, “Hain bo. Hanâk luâk are dosaŋe hepunaŋmâ âgâwiat. ");
INSERT INTO tim_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aregât den dopŋe siâ hin makbe. Anutuŋe damunyeŋe akbiap amâ luâk kembu hinare yâkŋe ikiŋe luâklupŋe hâuyeŋaet akmâ heŋgem yeŋguwerâm agep. ");
INSERT INTO tim_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yâkŋe hâu are heŋgemgowerâm âi miep. Akto yâkŋe luâk siâ yâkgâlân mem ari âi luâk aregât hâu âmâ 13 milion kina hainare. ");
INSERT INTO tim_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akto luâk arekŋe hâu are kutigitbiapgât puli dop hainare bo talaŋep. Aregât akmâ luâk kembu arekŋe makyeŋgimbo luâk are ikiŋe akto âmbenŋe nanaŋlupŋe meyekmâ yeŋgâlân kotŋe siâ siâŋe are hârok puligom benŋe puli are mem luâk aregât hâu kutigitberâm agi. ");
INSERT INTO tim_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hain akto âi luâk arekŋe luâk kembu aregât enemŋân kâŋgom hin magaŋep, “Gâmâ hanâk nâŋgât okot nâŋgâm lâmnugu. Hâmbâi âlepŋe hâu are gâŋgâlân kutigitbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Akto âi luâk aregât humoŋande luâk aregât okotŋe akmâ dosaŋe hepunaŋep. ");
INSERT INTO tim_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Akto âi luâk arekŋe hâkŋângen gem benŋe ikiŋe âi luâk siâ hanŋân mem metawolep. Amâ luâk aregât hâu amâ 100 kina. Akto âi luâk are mem hin magaŋep, “Gâŋe hâu are hârok kutigitmâ meteniŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hain dâmbo ikiŋe âi luâk arekŋe enemŋân kâŋgom ulilaŋmâ hin dâep, “Gâ nâŋgât okotge nâŋgâm lâmnugu. Hâu are âlepŋe gâŋgâlân kutigitbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hain dâmbo yâkŋe yâkgât den are bo nâŋgâm lope kâlegen katmâ hin dâm magaŋep, “Inâk tatmenâ hâu are ârândâŋ akto âlepŋe ariwiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Akto hoŋ bawa aregât galalupŋande den are nâŋgâm bâliaŋi. Hain akmâ arim den are humoyeŋe magaŋi. ");
INSERT INTO tim_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Akto humoyeŋe arekŋe damun are kondo guto hin magaŋep, “Gâ luâk bâleŋe. Gâŋe ulit niŋmenâ aregât hâuge yiep ina hanâk yân hepun gektân. ");
INSERT INTO tim_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nâŋe gâŋgât okot nâŋgâ giŋdân ina gâkâ âi luâkge aregât okot bo nâŋgaŋdât are nâŋgâre umatŋe dondâ aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Humoŋe hain dâm biwiŋe kâlâp akto tembe loko yeŋgâlân kato membiâ hin makyeŋgiep, “Âi luâk bâleŋe ire hâk hilâlâm agaŋbiâ hâu are ârândâŋ akbiap.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aregât keiŋe hin. Yeŋe galalupyeŋe yeŋgât dosa are biwiyeŋân makmâ manbiâ âmâ Ewene himbimân mandâp yâkŋe yeŋgât dosa bo kutigitbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuŋe den are hârok makmâ metem Galilaia kepia are hepunmâ hân humo kotŋe Yudaia tu kotŋe Yodaŋ biken ain ariep. ");
INSERT INTO tim_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Arimbo luâk âmbâle dondâŋe olop ariyi. Akto ain luâk âmbâle kundatdâ dondâ mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Akto Parisaio luâkŋe yâkgâlân togom dop komberâm hiaŋgim hin dâyi, “Gain gain luâkŋe âmbenlupyeŋe watyekbaigât dâp tatâp me bo?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","yâkŋe hin makyeŋgiep, “Ye den ire oyaŋmâ nâŋgâmai, “Anutuŋe hân himbim ketuguyelegep sop ain âmâ luâk âmbâle ketugu yelegep. ");
INSERT INTO tim_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ketugu yelekmâ hin dâep, “Luâkŋe eweŋe memeŋe hepun yelekto âmbenŋe olop dewati akbiandat. Hain akmâ yâk hâkyetŋe konok hainare akto manbiandat.” dâep.” den hain tatâp. ");
INSERT INTO tim_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hain gârâmâ yâk siâkâ ikiŋeâk ikiŋeâk bo akbiandat. Yâk hâkyetŋe konok hainare akbiandat. Hain gârâmâ Anutuŋe mem mendugu yelegep are luâk siâŋe luâk âmbâi lâuwâ are potatyelekbiapgât dop bo tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yesuŋe hain dâmbo Parisaio luâkŋe magaŋmâ hin dâyi, “Maktât are gain gain maktât? Wangât Moseŋe den kârikŋe katnengim hin dâep, “Luâk siâŋe âmbenŋe watberâm âmâ âmbâle hepun hepungât kulem esenŋe kulemgom âmbenŋe waŋmâ wato ârândâŋ akbiap.” dâep?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Akto Yesuŋe hin makyeŋgiep, “Moseŋe amâ yeŋaet agak meme bâleŋe akbiâ biwiyeŋe kârikŋe akmap aregât akmâ kulemgoep amâ yeŋe agat agatŋe akbiâ dâp katyeŋgiep. Dâ ulikŋân âmâ agak meme ire hain bo yiep. ");
INSERT INTO tim_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aregât ye hin makyeŋgiwe. Luâk siâgât âmbenŋande dâp gulip bo mando âmâ yân luâk arekŋe watmâ âmbâle siâ membiap âmâ luâk arekŋe luâkdâ âmbendâ yeŋgât dâp are mem bâlimbo dosa miawagaŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesuŋe hain dâmbo hoŋ bawalupŋande hin magaŋi, “Luâk yeŋgât agak meme hain tato âmâ luâkŋe hanâk âmbâle bo membiâ ârândâŋ aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hain dâmbiâ hin makyeŋgiep, “Luâk hârokŋe den ire membaigât dop bo. Anutuŋe luâk bikŋeâk kârikŋe yeŋgiep. Luâk arekŋeak âmâ den ire âlepŋe membai. ");
INSERT INTO tim_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hin. Luâk bikŋe memelupyeŋande meyegiân âmbâle bo meyekbaigât dop tatâp. Dâ luâk bikŋe âmâ gasalupyeŋande gâiyeŋgimbiâ âmbâle meyekbaigât dâp bo tatâp. Hainâk luâk bikŋande amâ himbimgât akmâ âi humo mem manmai yâk âmbâle bo menegât nâŋgâmai are ârândâŋ akbiap. Gârâmâ den ire amâ Anutuŋe memeŋe akyeŋgimbo aregât kârikŋe manmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Akto sop ain luâk âmbâle bikŋande Yesuŋe nanaŋlupyeŋe bâtŋande kautyeŋân mem Anutu ulilaŋâkgât yâkgâlân meyekmâ togoyi. Hain akbiâ hoŋ bawalupŋande den kugâk kugâk akyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hain akyeŋgimbiâ Yesuŋe hin makyeŋgiep, “Ye hepunbiâ nanaŋ are nâŋgâlân togoŋet. Ye bo mem ganyeŋe dâŋet. Anutuŋe damunyeŋe akbiap amâ nanaŋ hainare yeŋgât.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hain dâm bâtŋande kautyeŋân kalep. Katmâ âmâ kepia are hepunmâ ariep. ");
INSERT INTO tim_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Akto luâk siâŋe Yesugâlân togom hin magaŋep, “Tiksa. Nâ agak meme gain hinare akmâ âlepŋe akmâ âmâ manman kârikŋeâk manmâ âgâwian?” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","hin magaŋep, “Gâ wan me wan âlepŋeâk makniŋdât keiŋe âmâ âlepŋe Anutu konok. Gârâmâ gâ manman âlepŋe manberâm âmâ Mosegât den kârikŋe kat katŋe are hârok watben.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","luâk arekŋe hin dâep, “Wan den kârikŋe?” dâmbo hin magaŋep, “Den kârikŋe amâ hin. Gâ luâk bo yeŋgumenâ mombai. Gâ luâkdâ âmbendâ yeŋgât dâp are bo mem hilipkowen. Kâmbu bo akben. Gâ luâk siâgât den bo hiaŋgiwen. ");
INSERT INTO tim_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gâ ewege memege yetgât amukyetŋân manben. Akto gugaet akmat hainâk galalupge are akyeŋgiwen.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hain magaŋdo hin magaŋep, “Den kârikŋe kat katŋe ire hârok emelâk akmâ meteân. Gârâmâ wan bâiŋe mendere âmâ manman kârikŋe miawakniŋbiap?” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuŋe hin magaŋep, “Gâ âlepŋe dondâ akberâm nâŋgâm âmâ ari kotŋe siâ siâŋe are hârok yeŋgimenâ puligombiâ puli are mem ari luâk umburuk yeŋgiwen. Hain akmenâ âmâ Anutuŋe gâŋgât wan me wan âlepŋe are himbimân kat giŋbiap. Gârâmâ gâ nâ watnekmâ gamenâ arire.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hain dâmbo luâk sigan arekŋe nâŋgâm kotŋe siâ siâ dondâ talaŋep aregât nâŋgâmbo humo akto aregât Yesuŋe tâwât dewunge panben dâm magaŋep aregât biwiŋe umatŋe akto gem yân ariep. ");
INSERT INTO tim_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Akto Yesuŋe hoŋ bawalupŋe hin makyeŋgiep, “Makyeŋgire nâŋgâŋet. Luâk pulirâ sikumdâŋe Anutugât kâmolân dewatiwerâm amâ âi humo membai. ");
INSERT INTO tim_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Soŋgo pike dâpŋânba gawerâm âmâ âi humo membiap. Dop hainâk luâk pulirâ sikumdâŋe Anutuŋe damunyeŋe akbiap ain ariwerâm âi humo membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hain dâmbo den are nâŋgâm sân sân mem hin magi, “Bâe, niŋande manman âlepŋân ariwiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dâmbiâ Yesuŋe tâŋ tâŋâk yekmâ kinmâ hin makyeŋgiep, “Anutugât manman âlepŋân ariwaigât nâŋgâ nâŋgâyeŋe watbiâ bo akmap. Dâ Anutuŋe konok âmâ wan me wan miawakbiapgât bo pâpkomap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hain dâmbo Petoroŋe magaŋmâ hin dâep, “Woe, nen âmâ kotŋe siâ siâ hârok hepunmâ gâ olop malion aregât hâuŋe nen wan membaen?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Akto Yesuŋe hin makyeŋgiep, “Hâmbâi kotŋe siâ siâ ire hârok irakŋe akmâ metewiap. Sop ain âmâ luâk akmâ geân nâ lâuwâŋe gem âmâ luâk kembu yeŋgât tat talân tatbian. Akto nâ watnekmâ manmai yekâ hainâk tat tat keiân lâuwâ ain tatbai. Tatmâ Israe luâk âmbâle kâmot keiân lâuwâ are mem potat yekbai. ");
INSERT INTO tim_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Akto luâk âmbâle nâŋgât nâŋgâm emetyeŋe me emi teulupyeŋe me meme ewelupyeŋe me nanaŋ me âi kalam me wan me wan nâŋgât akmâ hepunmai amâ hâmbâi aregât hâuŋe kotŋe siâ siâ dondâ membai. Hain akmâ manman kârikŋân manmâ âgâwai. ");
INSERT INTO tim_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aregât siâkâ makbe. Luâk âmbâle bikŋe hinŋe hâkyeŋe mem agatbai are âmâ hâmbâi Anutuŋe hamiŋângen katyekbiap. Dâ bikŋe âmâ hinŋe hâkyeŋe mem gewai are âmâ Anutuŋe hâmbâi tânyeŋgumbo ulik gulik akbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Akto Yesuŋe hin dâm makyeŋgiep, “Anutuŋe damunyeŋe akbiap amâ luâk siâgât hân humo yeaŋmap dop hainare akto hândâktâk dondâ agatmâ âiângen âi meaŋetgât âi luâk bikŋe meyekberâm ariep. ");
INSERT INTO tim_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Akto âi luâk bikŋe olop den akmâ hilâm konokgât hâu dâtâŋe aregât puliŋe membaigât makyeŋgimbo âlepŋe dâmbiâ huŋgun yeŋgimbo âi memberâm ariyi. ");
INSERT INTO tim_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Arimbiâ âmâ 9 kilok wan hainare kepian arim luâk bikŋe yekto kepia tete yân tali. ");
INSERT INTO tim_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yân taligât luâk arekŋe makyeŋgim hin dâep, “Ye arim nâŋgât waiŋ âiângen âi membiâ aregât puliŋe âi aregât dopŋânâk yeŋgiwerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hain dâmbo arimbiâ benŋe 12 kilok akto 3 kilok ain âkâ hainâk agep. ");
INSERT INTO tim_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hain akmâ âmâ eŋgaiŋe 5 kilok wan hainare arim yekto luâk bikŋe yân tatmâ manbiâ yekmâ hin makyeŋgiep, “Ye gain gain akmâ hilâm humo ire yân tatmâ mandâi?” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","yâkŋe hin magaŋi, “Luâk siâ me siâŋe âi siâ bo nengimbo aregât yân tatmâ manden.” dâmbiâ yâkŋe hin makyeŋgiep, “Ye arim nâŋgât waiŋ âiângen âi meŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Akto emet dâgâmbo âmâ luâk arekŋe âi luâklupŋe yeŋgât damun are magaŋmâ hin dâep, “Âi luâk yeŋgonmenâ togombiâ hilâm konokgât hâu dâtâŋe yeŋgi. Akto âi luâk hami togoâi are yeŋgâlânba keiŋe katmâ yeŋgim maleine âi luâk ulik gulik togoâi are âmâ bâiŋe yeŋgiwen.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hain dâmbo âi luâk 5 kilok âi meyi are âmâ hilâm konokgât hâu dâtâŋe konok yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Akto luâk ulik gulik togom âi keiŋe katmâ meyi are togom, “Nenŋe âmâ hilâm konokgât puli aregât kakŋân memberen.” dâm nâŋgâyi. Dâ ina yâkâ hainâk hilâm konokgât hâu dâtâŋe yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yeŋgimbo mem kalam amboŋe aregât dondâ nâŋgâm bâliaŋi. ");
INSERT INTO tim_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hain akmâ magaŋmâ hin dâyi, “Luâk ire âmâ hinŋeâk togom âi getegâk mendâi ina gâŋe hilâm konokgât yeŋgiât. Akto nenŋe âmâ dewutâ kârikŋân âi humo menden akto dewutâŋe dondâ nenektâp ina hainâk nengiât are ârândâŋ bo aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hain dâmbiâ yâkŋe luâk hutyeŋân kilep siâ magaŋmâ hin dâep, “Gala, nâ bâleŋe bo akgiŋdân. Nâŋe hilâm konokgât hâu dâtâŋe memberât dâm makgiŋdere gâŋe âlepŋe dâm nâŋgâmenâ ârândâŋ aktâp aregât ");
INSERT INTO tim_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","gâ pulige are meakmâ ari. Puli ya giŋdân hainâk luâk hami dondâ togom âi getek mendâi are nunaet ukennaet akmâ yeŋgiân. ");
INSERT INTO tim_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nâŋe nune puli ire mem siâ me siâ akbiangât amâ nunaet pat. Gâŋe damunne akmat me? Nâŋe agak meme âlepŋe akgiŋdere aregât gâŋe wangât nâŋgâm bâli niŋdât? Nâŋgâm bâli niŋmenâ ârândâŋ bo aktâp.” ");
INSERT INTO tim_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Luâk âmbâle bikŋande hinŋe hâkyeŋe mem agatbai are amâ hâmbâi Anutuŋe hamiŋângen katyekbiap. Dâ bikŋe hâkyeŋe mem gewai are âmâ Anutuŋe hâmbâi mem ulik gulik katyekbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuŋe Yerusalem kepia âgâwerâm akmâ hoŋ bawalupŋe keiân lâuwâ are meyekto ariyi. Arim manmâ Yesuŋe dâwân makyeŋgim hin dâep, ");
INSERT INTO tim_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ye nâŋgâŋet. Bâin. Nen Yerusalem kepian âgâne. Akto ain sumbe kat kat luâk akto Mosegât den kârikŋe makmâ kepikmai ain tatmai yâk yeŋgâlân gâtŋande luâk akmâ geân nâ bâleŋe akniŋmâ sumbe kat kat luâk akto Mosegât den kârikŋe makmai yâk yeŋgâlân makyeŋgimbiâ menekbai. Akto den âiân katnekmâ nugumbiâ mombian aregât den magaŋgi goaŋgi akbai. ");
INSERT INTO tim_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Akto den hembalik mâŋgi nekmâ lâwinân nugumbiâ mombiangât Roma luâk are yeŋgâlân oloŋ nekbiâ bâleŋe mâŋgi nekmâ lâwinân nugumbiâ mombian. Mondere han nugumbiâ hilâm âlâwu akto momoŋânba agatbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Akto sop ain Yebedaiogât âmbenŋande nanlogâtŋe Yakobo akto Yohane are kewugu yelekmâ Yesugâlân togom kâŋgom ulilaŋep. ");
INSERT INTO tim_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ulilaŋdo hin magaŋep, “Gâ wangât nâŋgât?” dâmbo hin dâep, “Sop siân gâŋe togom luâk âmbâle hârok damunyeŋe akbialân sop ain nanlogâtnande gasomge bikŋe bikŋe tatmâ kembu akbiandat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hain dâm ulilaŋdo Yakobo akto Yohane hin dâm makyetkiep, “Yet aregât keiŋe pâpkom maktat. Nâ wan me wan umatŋe miawak niŋbiap are hârok yet âlepŋe miawakyetkiwiap me?” dâep. Hain dâmbo hin dâyiat, “Maktât are miawak netkiwiap aregât nâŋgâetŋe ârândâŋ akbiap.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hain dâmbela hin dâep, “Wan me wan umatŋe miawak niŋbiap arekŋe âlepŋe hainâgâk miawak yetkiwiap. Dâ Anutu Ewene yâkŋe konok nâŋgât amuknân manmâ damunyeŋe akbai aregât emelâk kotyeŋe dâm hâriep. Amâ nâŋgât âi bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hain dâm makyetkimbo hoŋ bawaŋe bât bip bip hârok yâkŋe den are nâŋgâmbiâ umatŋe akto Yohane akto Yakobo peiyelegi. ");
INSERT INTO tim_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Peiyelekbiâ Yesuŋe yeŋgondo bambiâ hin dâm makyeŋgiep, “Hângât luâk kembuŋe luâk damunyeŋe akmâ âmâ hoŋ bawalupyeŋe meyekbiâ manmai are âmâ nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dâ yeŋe âmâ hângât luâk kembu are yeŋgât agak meme are hain bo akbei. Yeŋgâlânba siâŋe Anutuŋe nekto ârândâŋ agâk dâwiap âmâ benŋe galalupŋe yâk yeŋgât hoŋ bawa akmâ manbiâp. ");
INSERT INTO tim_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Akto yeŋgâlânba siâŋe Anutuŋe nekmâ, “Woe, damunyeŋe akbiapgât dop tatâp dâwiap.” dâm aregât galalupŋe yeŋgât âi luâk manbiâp. ");
INSERT INTO tim_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nâ hainâk hoŋ bawalupnande tân nuguŋet dâm aregât bo geân. Âi humo mem hâk hilâlâm nâŋgâm luâk âmbâle dondâ are yeŋgât dosa bo akyeŋgiwiapgât mombian aregât luâk akmâ geân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu akto hoŋ bawalupŋe Yeriko kepia hepunmâ ariyi. Arimbiâ hami yeŋân luâk âmbâle dondâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Akto dâp ginŋân luâk dewunyetŋe bok bokŋe lâuwâ taliat. Yesu togoep aregât den nâŋgâm kârikŋeâk konmâ hin dâyiat, “Humo, gâ Dawidigât hakuŋe gâ hanâk netgât okotge nâŋgâ.” ");
INSERT INTO tim_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hain dâm konbela luâk âmbâle ain kili arekŋe nâŋgâm hin dâyi, “Woe, den hepulet.” dâyi. Hain dâmbiâ denyeŋe bo nâŋgâm âmâ lâuwâŋe koliat, “Humo, gâ Dawidigât hakuŋe gâ hanâk netgât okotge nâŋgâ.” ");
INSERT INTO tim_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","konbela nâŋgâm dâwân kinmâ yetkondo gutbela hin aiyetkuep, “Gain gain akyetkiwegât nâŋgat?” dâmbo hin dâyiat, ");
INSERT INTO tim_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Humo âlepŋe eget dâmenâ dewunnetŋe hulaŋagâkgât ulit giŋdet.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Hain dâmbela okotŋe nâŋgâm dewunyetŋe howaimbo hulaŋ akto Yesu olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Akto arewa arim Yerusalem kepia ewumâk Betepage kepia akto gimbâŋe kotŋe Oliwa ain togoyi. Togo Yesuŋe hoŋ bawalogâtŋe lâuwâ huŋgun yetkiep. ");
INSERT INTO tim_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Huŋgun yetkim hin makyetkiep, “Yet kepia bâlensiâ tato ektat âuren âgâet. Âgâm âmâ doŋgi siâ hikombiâ kindâp nanŋe olowâk are dowâk mem miawak yeleget. Meyelekmâ mem âmâ nâŋgâlân togoet. ");
INSERT INTO tim_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dâ luâk siâ me siâŋe den wan siâ makyetkimbo âmâ hin magaŋberat, “Iregât âi miawakto Humonetŋande maknetkiâp gârâmâ mem arietŋe âi bo akto âmâ dowâk mem purik katberâp.” dâm magaŋberat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wan me wan ya miawagep are amâ Propete siâŋe den kulemgoep aregât bikŋe bunŋe miawagep den are hin tatâp, ");
INSERT INTO tim_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sioŋ gimbâŋe ambolupŋe nâŋgâŋet. Yeŋgât kembuyeŋe amâ hâkŋe mem gemap. Hain akmâ yoŋâk ariwerâm âmâ doŋgigât kakŋân tatmâ togowiap. Doŋgi aregât nanŋe are olop togowiap.” ");
INSERT INTO tim_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesuŋe hain dâm huŋgunyetkimbo arim hain agiat. ");
INSERT INTO tim_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Doŋgi akto nanŋe lâuwâ mem oloŋyelekmâ togombela sâŋgum kakŋân luguakmini are oloŋmâ doŋgi kakŋân katbiâ yâkŋe âgâ talep. ");
INSERT INTO tim_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Âgâ tato luâk âmbâle dondâŋe Humonenŋe togoâp aregât dâp heŋgemgone dâm sâŋgum kakŋân luguakmini are oloŋmâ dâwân leŋgaim ariyi. Dâ bikŋande âmâ esenŋe siâ siâ ligim dâwân katmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Akto luâk âmbâle dondâ enemŋân akto hamiŋân olop ariyi arekŋe âmâ hin koli, “Woe, hakunenŋe Dawidi yâkgât kâmolân gâtŋe gâŋe damun nenŋe ak. Anutu Humoŋe wâtŋe giŋmâ huŋgun giŋdo togoât aregât heroŋe akgiŋne. Akto kembunenŋe yu togoât iregât Anutu himbimân manmap yâk nâŋgaŋdenŋe kotŋe humo agâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Akto Yesuŋe Yerusalem kepian âgâmbo kepia humo ain luâk âmbâle tali arekŋe sân sân mem hin dâyi, “Luâk ire niŋe?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hain dâmbiâ luâk âmbâle yâk olop ariyi arekŋe makyeŋgiyi, “Imâ Anutugât Propete siâ kotŋe Yesu, Galilaia hân aregât kepia Nasarete ain gâtŋe.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hain dâmbiâ Yesu Yerusalem kepian âgâm sumbe kat kat opmânŋân âgâm luâk âmbâleŋe siâ me siâ katmâ aŋgim kili are wat yekmâ siâ me siâ yeŋe me kembâ welamŋe me puli tat tat welamŋe mem kâwulep. ");
INSERT INTO tim_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kâwutmâ watyekmâ hin makyeŋgiep, “Anutuŋe makto kulemgoyi bikŋe hin tatâp, “Nâŋgât emet âmâ luâk âmbâle hârokŋe ulitniŋbaigât emet kindâp.” Den kulem hainâk yendâp are hâkâŋ akmâ mâŋgimbiâ luâk kâmburâ yeŋgât emet hainare aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hain dâm sumbe kat kat opmânŋân luâk dewunyeŋe bok bokŋe akto keiyeŋe pâwutyeŋe bâleŋe are togombiâ mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Akto nanaŋ lepat ain âgâm Yesugât hin dâyi, “Dawidigât hakuŋe kotŋe mem agatne.” dâyi. Hain dâmbiâ sumbe kat kat luâk akto Mosegât den kârikŋe makmâ kepigi arekŋe Yesuŋe kulem keiŋe keiŋe miep are ekmâ akto nanaŋ lepat are yeŋgât den nâŋgâmbiâ bâlimbo kuk bâleŋe agi. ");
INSERT INTO tim_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hain akmâ Yesu hin magaŋi, “Nanaŋ lepat irekŋe kotge konmâ mem agatbiâ nâŋgât mon?” dâm magaŋi. Hain dâmbiâ hin makyeŋgiep, “O nâŋgân gârâmâ aregât Anutuŋe makto kulemgoyi bikŋe aregât hin tatâp, “Anutuŋe nanaŋ lepat memeŋe akyeŋgimbo kotŋe mem agatbai.” den are oyaŋmâ nâŋgâm meteyi mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Akto ainba hepun yekmâ kepia humo are ginŋângen gem hândâk ain Betania kepian yiep. ");
INSERT INTO tim_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yem kindo hauŋdo hândâktâk purik katmâ kepia humoân âgâm sotgât mopŋe aguep. ");
INSERT INTO tim_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akto dâwân lowot hainare siâ kindo ekmâ bunŋe yendâp dâm keiŋân baep. Bam ekto bunŋe siâ bo yendo esenŋandeâk kilep. Akto lowot are magaŋmâ hin dâep, “Lâwin iregât koaŋe siâkâ bo yembiâp. Boâk tiŋ.” dâmbo ainâk lowot arekŋe ululun kârâep. ");
INSERT INTO tim_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hain akto hoŋ bawalupŋande are ekmâ otneyeŋe arimbo sân sân mem hin dâyi, “Gain gain akmâ lowot ire dowâk ululun kârâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hain dâmbiâ Yesuŋe makyeŋgim hin dâep, “Nâ iregât keiŋe makyeŋgire nâŋgâŋet. Ye nâŋgâlân biwiyeŋe katmâ heŋgemgom han lâuwâ âlâwu bo akbai âmâ nâŋe lowotgâlân aktere ektâi hainâk âlepŋe akbai. Akto are konok bo akbai. Gimbâŋe ire magaŋmâ hin dâwai, “Gâ kâwulakmâ haruân umbure ge.” dâmbiâ âlepŋe hain akbiap. ");
INSERT INTO tim_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Akto yeŋe nâŋgâlân biwiyeŋe katmâ heŋgemgom kinmâ wan me wan memberâm ulilaŋbai amâ wan me wan are âlepŋe membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Akto Yesuŋe sumbe kat katgât opmânŋân âgâm luâk âmbâle den pat âlepŋe are makyeŋgiep. Akto sumbe kat kat luâk akto Israe yeŋgât kembu yâkgâlân togom magaŋmâ hin dâyi, “Gâ wan me wan akmat are niŋaet lau lokom akmat? Akto niŋande memeŋe akgiŋdo memat?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Nâkai hainâk wan siâgât ai yeŋguwerân. Gârâmâ yeŋe den hâuŋe makniŋbiâ âmâ benŋe nâkâ wan kârikŋe tatniŋdo âi meman iregât keiŋe makyeŋgiwerân. ");
INSERT INTO tim_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohaneŋe tu puli keiŋe kalep are niŋande meme agaŋdo âi are meminep? Anutuŋe me luâk yânŋande?” dâep. Hain dâmbo den are nâŋgâm are yeŋeâk magaŋgi goaŋgi akmâ hin dâyi, “Nenŋe Anutuŋe meme agaŋep dâweren âmâ yâkŋe hin maknengiwerâp, “Ye wangât yâkgât den bo nâŋgâm heŋgemgoyi?” dâwerâp. ");
INSERT INTO tim_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dâ nenŋe are luâk yânŋande memeŋe agaŋmini dâweren âmâ luâk âmbâle yu kindâi irekŋe Yohane âmâ Propete dâm kuk aknengiwâi aregât gain gain magaŋberen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hain dâm kinmâ Yesu hin magaŋi, “Yohane niŋande memeŋe agaŋdo akminep are bo nâŋgâen.” dâyi. Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Nâkai hainâk niŋaet laugât kinmâ âi meman aregât bo makyeŋgiwerân. ");
INSERT INTO tim_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aregât den ginŋe makyeŋgiwe. Luâk siâgât nanlogâtŋe lâuwâ maliat. Akto teuŋe aregâlân arim hin magaŋep, “Nan, gâ uŋak arim waiŋ âiângen âi me.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hain dâmbo nanŋe arekŋe magaŋmâ dâep, “Nâ borân.” dâep. Hain dâm tatmâ benŋe beirâŋângen hanŋe siâ akto arim âi miep. ");
INSERT INTO tim_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Akto eweyetŋande emiŋe aregâlân arim arekâ hainâk magaŋep. Akto nanŋe arekŋe magaŋmâ dâep, “Apo, âlepŋe ariwerân.” dâm hiaŋgim bo ariep. ");
INSERT INTO tim_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gârâmâ nanlogâtŋe lâuwâ arekŋe niŋande âmâ eweŋaet den lokoep?” dâmbo dâyi, “Teuŋe arekŋe.” dâyi. Hain dâmbiâ Yesuŋe makyeŋgim hin dâep, “Aregât den bunŋe hin makyeŋgire nâŋgâŋet. Puli dâtâŋe meme luâk akto âmbâle dâp gulip manmai yâkŋe ye ewangiyekmâ Anutugât kâmolân dewatiyi. ");
INSERT INTO tim_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Amâ yeŋe Yohaneŋe agak meme âlepŋe hekat yeŋgimbo hâkâŋŋe akmâ denŋe bo lokoyi. Dâ gawamangât puli meme luâk akto âmbâle dâp gulip manmaiŋe âmâ denŋe nâŋgâm hanyeŋande nâŋgaŋi. Dâ ye âmâ are ekmâ hanyeŋe bo purik kato denŋe bo nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Akto den dopŋe siâkâ makyeŋgire nâŋgâŋet. Luâk siâŋe hân siân tâk kotŋe waiŋ are kâmetmâ metem lope dâgâep. Akto waiŋ tuŋe pipikowaengât dâm kondo ketugum heŋgemgom damun yeŋaet emet mem âi kalam hârok ketugum metem hoŋ bawalupŋe hin makyeŋgiep, “Kalam ire damunŋe akmâ sot bunŋe akto mem niŋbai.” dâm hân siângen ariep. ");
INSERT INTO tim_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Arim manmâ manmâ mando sot bunŋe akto âi luâk siâ sot bunŋe bikŋe meyekŋet dâm huŋgun yeŋgimbo ariyi. ");
INSERT INTO tim_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Arimbiâ damun luâklupŋe arekŋe hoŋ luâk are kât mem pitim panmâ yeŋgumbiâ bikŋe arimbiâ bikŋe moyi. ");
INSERT INTO tim_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hain akto amboŋe arekŋe âi luâk dondâ huŋgun yeŋgimbo arimbiâ a hainâk kalam damunlupŋe arekŋe hoŋ luâk are hainâk yeŋgum watyegi. ");
INSERT INTO tim_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Amboŋande pat are nâŋgâm hin dâep, “Nune nanne huŋgun aŋdere arimbo yâkgât amukŋân manbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hain dâm huŋgun aŋdo arimbo âi damunlupŋande nanaŋ are ekmâ magaŋgi goaŋgi akmâ hin dâyi, “Woe, humonenŋaet nanŋe togoâp. Eweŋe mondo yâkŋe hârok membopgât kondenŋe moâk. Hain aktenŋe bât bâiŋe hârok nengât akbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hain dâm mem oloŋmâ hâkŋângen kombiâ moep. ");
INSERT INTO tim_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Hain akbiâ âi amboŋe are gain gain akbiap?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hain dâmbo hin dâyi, “Âi amboŋe arekŋe togom hoŋ bawa are yeŋgumbo mombiâ âmâ benŋe dumyeŋân hoŋ bawa siânbaŋe sot yendoân niŋbai dâm katyekbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hain dâmbiâ Yesuŋe hin dâep, “Anutuŋe makto luâk siâŋe hin kulemgoep, “Emetŋe ketuguwerân âmâ luâkŋe kât siâ ekmâ hâkŋe hâkŋe dâm panbiâ yendo Anutuŋe kât are mendo emetgât kun kun kârikŋe agep. Are ekmâ, “Imâ Humoŋe mem miawaktâp.” dâm ektenŋe humo aktâp.” Siâŋe ulikŋân hain kulemgoep. Aregât ye âmâ nanaŋyeŋânbak oyaŋmâ nâŋgâyi amâ wangât hilipkoyi? ");
INSERT INTO tim_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aregât makyeŋgire nâŋgâŋet. Anutuŋe damunyeŋe akberâm aktâp yâkŋe yekto ârândâŋ bo akto luâk âmbâle aŋgâ damunyeŋe akbiap are yâk Anutuŋe damunyeŋe akbiap aregât bunŋe membai. ");
INSERT INTO tim_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dâ luâk siâŋe kât tetembeŋe kârikŋe are ekto ârândâŋ bo akto âmâ hâkŋe hilipkowiap. Akto kât arekŋe amâ luâk siâ kakŋân ge kom hambumbo hogoakbiap.” ");
INSERT INTO tim_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hain dâmbo Parisaio luâk akto sumbe kat kat luâk areyeŋgât humomolupyeŋande den are nâŋgâm hin dâyi, “Imâ nengât dop maktâp.” dâm nâŋgâmbiâ bâliep. ");
INSERT INTO tim_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hain akto aregât Yesu mem kala busi kâlegen katberâm agi. Hain akmâ memberâmbiâ luâk âmbâle dondâŋe ain kili arekŋe Yesu amâ Propete luâk dâm nâŋgâyi aregât, “Mendenŋe nenguwâi.” dâm hamewakmâ yânâk hepuli. ");
INSERT INTO tim_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Akto Yesuŋe den ginŋe siâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anutuŋe damunyeŋe akbiap amâ hângât luâk kembu siâgât agak meme hainare. Luâk kembu aregât nanŋande âmbâle memberâm akto luâk kembu arekŋe sot soŋgo dondâ om hâwuruep. ");
INSERT INTO tim_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akto ulikŋân luâk bikŋe nanŋande âmbâle mendoân togombiâ sot om yeŋgiwiapgât makyeŋgiep. Akto nanŋande âmbâle memberâm akto ain âi luâklupŋe bikŋe huŋgun yeŋgim, “Ari luâk are kewugu yekmâ togoŋet.” dâep. Akto âi luâklupŋande ari makyeŋgimbiâ yâkŋe borâm bo togoyi. ");
INSERT INTO tim_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Akto lâuwâŋe âi luâklupŋe bikŋe huŋgun yeŋgim hin makyeŋgiep, “Ye arim nâŋe ulikŋân luâk makyeŋgiân are hin makyeŋgiwei. Ye nâŋgâŋet. Sot akto bau akto soŋgo humomo emelâk kom om katân akto kotŋe siâ siâ hârok emelâk mem ârândâŋ ketuguân. Gârâmâ ye togom nannande âmbâle memberâp iregât sot neŋet.” dâm âi luâklupŋe are makyeŋgim huŋgun yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Akto âi luâklupŋande arim den are luâk âmbâle makyeŋgiyi. Makyeŋgimbiâ den a bonâŋgâm hansumbu akmâ ariyi. Siânbaŋe gem kalam yeŋângen ariyi. Dâ bikŋande âmâ puli âi memberâm gem ariyi. ");
INSERT INTO tim_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dâ bikŋande âmâ luâk kembugât âi luâk are hilip yeŋgumbiâ mom meteyi. ");
INSERT INTO tim_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hain akbiâ luâk kembu are biwiŋe kâlâp akto tembe lokolupŋe huŋgun yeŋgimbo arim luâk koko yeŋgumbiâ mom meteyi. Mom metembiâ kepiayeŋe arekâ ombiâ om bo akyegep. ");
INSERT INTO tim_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Akto luâk kembu arekŋe âi luâklupŋe makyeŋgim hin dâep, “Nannande âmbâle mendâp iregât sot soŋgo emelâk mem ârândâŋ ketugure yendâp. Dâ nâŋe luâk togoweigât makyeŋgiân are yeŋgât agak memeyeŋe ârândâŋ bo. ");
INSERT INTO tim_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gârâmâ ye arim dâp kautŋe ârândâŋ kinmâ âmâ luâk âmbâle arim togombiâ yekmâ âmâ makyeŋgimbiâ togom sot ire neŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hain dâm huŋgun yeŋgimbo âi luâklupŋe arekŋe dâp kautŋe ârândâŋ kinmâ arimbiâ luâk âmbâle âlepŋe me bâleŋe togombiâ hârok mendugu yegi. Akto luâk âmbâle arekŋe togom luâk âmbâi lâuwâ meagiat are yetgât emet are pikmâ teŋ teŋ dâm tali. ");
INSERT INTO tim_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Akto luâk kembu arekŋe luâk âmbâle are yekberâm emet are kâlegen bam âgâep. Âgâm luâk siâ hombaŋ tat tatgât sâŋgum are bo lalakmâ togoep. ");
INSERT INTO tim_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Togom ekmâ luâk kembu arekŋe magaŋmâ hin dâep, “Gala, gâ gain gain akmâ luâk âmbâle meak meak aregât sâŋgum bo latmâ in togoât?” dâep. Luâk kembu arekŋe hain dâmbo yâkŋe denŋe nâŋâk kinmâ aŋun aŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aŋun aŋgimbo luâk kembu arekŋe âi luâklupŋe makyeŋgim hin dâep, “Ye luâk are mem keiŋe bâtŋe mem mendugum dâgâm ge hândâkŋângen ain panbiâ yeâk. Yem âmâ hâk hilâlâm dondâŋe nâŋgâm indem kamboŋmâ yem âgâwiâp.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Aregât den ginŋe purikŋe hin makbe. Anutuŋe luâk âmbâle dondâ makmâ yeŋgonmap. Dâ luâk âmbâle konok konok potatmâ yeŋgondo Anutugât kâmolân dewatimai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Akto Parisaio luâk arim hin dâyi, “Hiaŋdenŋe Yesuŋe den siâ makmâ hilipkombo mene.” dâm magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hain akmâ hoŋ bawalupyeŋe akto Herotegât âi luâklupŋe huŋgun yeŋgimbiâ Yesugâlân togom lau tu agaŋmâ hin dâyi, “Humo, gâŋgât keige nâŋgâen. Gâ hiaŋgi den bo makmat. Bunŋeâk makmat. Gâ luâk hârok Anutugât dâp âlepŋe makmâ makyeŋgimat. Akto luâk yeŋgât nâŋgâ nâŋgâyeŋaet bo watmat. Akto luâk âgâ âgâŋe me gegeŋe areyeŋgât hamep bâlâk akmâ ârândâŋâk makmâ hekatnengimat aregât ire makmenâ nâŋgâne. ");
INSERT INTO tim_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nen Roma luâk siâ damun nenŋe kotŋe Sisa are gawamangât puli waŋmaen are âlepŋe me bo? Aregât gain nâŋgâmat? Puli waŋbaen me bo?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hain dâmbiâ biwiyeŋaet keiŋe ekmâ nâŋgâm hin makyeŋgiep, “Ye hiaŋniŋdâi. Denŋe hami kom katniŋdâi. ");
INSERT INTO tim_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Romagât puli koaŋe siâ mem niŋbiâ ekbe.” dâep. Hain dâmbo mem waŋbiâ mem agatmâ hekat yeŋgim hin dâep, ");
INSERT INTO tim_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Puli ire ekŋet. Iregât otneŋe akto kot ire niŋaet?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hain dâmbo hin dâyi, “Damun nenŋe Roma luâk kotŋe Sisa yâkgât otneŋe.” dâyi. Hain dâmbiâ hin dâep, “Wan me wan Roma luâk humogât dâtâŋe amâ yâk waŋbei. Dâ wan me wan Anutugât dâtâŋe are amâ Anutu waŋbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hain dâmbo nâŋgâmbiâ humo akto yân hepunmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Akto hilâm ainâk Sadukaio luâk are togoyi. Luâk arekŋe momoŋânba luâk bo agatbai dâmini. Yâkâ hainâk togom lau tu agaŋmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tiksa, Moseŋe ulikŋân hin dâm kulemgoep, “Luâk siâŋe âmbâle mendo nanaŋ bo miawakto mondo emiŋande kambut mem teuŋaet kâmot bo akbopgât membiap.” Moseŋe hain kulemgoep aregât hin makgiŋne. ");
INSERT INTO tim_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Emi teu nâmbulân lâuwâ nen hutnenŋân mali. Hain manmâ ulikŋân teuyeŋande âmbâle mem nanaŋ bâlâk manmâ moep. ");
INSERT INTO tim_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mondo emiŋande kambut are mem hainâk nanaŋ bâlâk manmâ mondo emiŋe siâŋe âmbâle kambut are miep. Hain akmâ mondo emi teu nâmbulân lâuwâ arekŋe âmbâle konok are mem nanaŋ bâlâk manmâ mom meteyi. ");
INSERT INTO tim_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bâiŋe kambutyeŋe are hainâk moep. ");
INSERT INTO tim_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Akto luâk nâmbulân lâuwâ are hârogâk âmbâle konok areâk mem mom meteyi. Aregât sop bâiŋân agatmâ metembiâ âmâ âmbâle are niŋaet âmbenŋe akbiap?” dâm hiaŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Ye Anutuŋe makto kulemgoyi are akto Anutugât kârikŋeŋe bonâŋgâmai are nâŋgâm hilipkom hain dâm maktâi. ");
INSERT INTO tim_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Luâk me âmbâle momoŋânba agatmai yâk himbimân aŋelo mandâi hainare akmâ luâk âmbâle meak meak are hepunmâ yân manbai. ");
INSERT INTO tim_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dâ momoŋânba agat agatgât keiŋe hin maktere nâŋgâŋet. Anutugât den aregât keiŋe makyeŋgire nâŋgâm heŋgemgoŋet. ");
INSERT INTO tim_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Anutuŋe hin magep, “Nâ Abraham akto Isaka akto Yakobo yâk yeŋgât damunyeŋe akman.” dâep aregât yâk âmâ momoŋe yâk yeŋgât Anutu bo. Golâ manmanŋe yâk yeŋgât Anutu akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hain dâm Sadukaio gâtŋe makyeŋgimbo luâk âmbâle yânŋe ain kili arekŋe den are nâŋgâmbiâ umatŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Akto Yesuŋe den magep are Sadukaio gâtŋande nâŋgâm den hâuŋe gain gain magaŋne dâm pâpkoyi aregât aŋun aŋgim hepuli, parisaioŋe aregât nâŋgâm âmâ Yesugâlân menduguyi. ");
INSERT INTO tim_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mendugumbiâ hutyeŋân Mosegât den kârikŋe makmâ kepigi ain gâtŋe konok Yesu hiaŋberâm aikom hin dop koep, ");
INSERT INTO tim_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tiksa, Anutuŋe den kârikŋe kalep ain gâtŋe wan soŋ lokowaen.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","hin dâep, “Anutuŋe makto Moseŋe kulemgoep are bikŋe hin tatâp, “Gâŋe Humoge Anutu yâkgâlân biwi kambiamge me nâŋgâ nâŋgâge katmâ manben. Yâkgât âi akto den lau aregâlâk nâŋgâm kârikŋe akmâ hange konogâk manben.” ");
INSERT INTO tim_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Den are soŋ lokombiâ huraguwiâp. ");
INSERT INTO tim_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Akto hamiŋân den ire lokombiâ huraguwiâp, “Gâ gugaet agakmat hainâk luâk siâ agaŋben.” ");
INSERT INTO tim_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Anutugât den kârikŋe lâuwâ irekŋe amâ den kârikŋe are hârokgât keiŋe aktâp. Akto Anutugât Propete luâk den ire nâŋgâm aregât keiŋe kulemgoyi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hain dâm Parisaio luâk menduguyi aregât Yesuŋe aiyeŋgum hin dâep, ");
INSERT INTO tim_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ye Anutuŋe huŋgun aŋdo gewiap aregât gain gain nâŋgâi? Yâk âmâ niŋaet nanŋe nâŋgâi?” dâmbo Parisaio luâk bikŋe arekŋe hin dâyi, “Dawidigât hakuŋe.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hain dâmbiâ hin dâep, “Bâin, Anutugât Heakŋande Dawidigât biwiŋe mem agato hin dâep, ");
INSERT INTO tim_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Anutu Humoŋe nâŋgât Humone hin magaŋep, “Gâ enemnân togom bâtne bungen tatmenâ gasalupge keigaet amukŋân kâmot katere tâliyekbiat.” ");
INSERT INTO tim_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aregât keiŋe hin. Dawidiŋe Anutuŋe huŋgun aŋdo gewiap are amâ nâŋgât Humone dâm konminep. Aregât gain gain yâk âmâ Dawidigât nanŋe dâmai?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hain dâmbo luâk ain kili arekŋe Yesuŋe den magep are hâuŋe bo magaŋi. Hain akmâ are hamiŋângen den siâ me siâgât lâuwâŋe bo aikoyi. ");
INSERT INTO tim_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesuŋe luâk âmbâle dondâ akto ikiŋe hoŋ bawalupŋe hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Luâk Mosegât den kârikŋe makmâ kepikmai akto Parisaio luâk yâk âmâ Mosegât welamŋân tatmai. ");
INSERT INTO tim_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aregât den makmâ hekatyeŋgimbiâ nâŋgâm lokowei. Dâ yâkŋe yâk yeŋgât den bo lokomai aregât agak memeyeŋe bo watbei. ");
INSERT INTO tim_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yâk yeŋgât agak meme are hin. Luâk âmbâle den kârikŋe wârakmâ hin makyeŋgimai, “Âi humo mem hâk hilâlâm nâŋgâm manmâ âgâŋet.” dâm makyeŋgimai âmâ bo tân yeŋgumai. Denâk akmai. ");
INSERT INTO tim_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Akto wan me wan hârok akmai are âmâ luâkŋe nenekŋet dâm aregât akmai. Akto nenekŋet dâm manmâ âmâ mitigât siâ me siâ wan me wan mem manmâ kâlewâk mâŋgim manmai. ");
INSERT INTO tim_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Akto luâk âmbâle mendugum kinmaiân me den opmânŋân âgâmaiân âmâ yâkŋe nenŋe soŋ dâm tat tatŋe egon tatmai. ");
INSERT INTO tim_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Akto yâkŋe luâk âmbâle kepian tiksa humonenŋe dâm nengonŋet dâm aregât ukenŋe nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Dâ ye amâ tiksayeŋe konok akto ye hârok gala konogâk akmai aregât tiksa humonenŋe dâm nengonŋet aregât bo nâŋgâwei. ");
INSERT INTO tim_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Akto Eweyeŋe konok mandâp amâ Anutu himbimân manmap yâk aregât iren hânân gâtŋe siâgât ewenenŋe bo dâwei. ");
INSERT INTO tim_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Akto humoyeŋe konok mandâp amâ Anutuŋe huŋgun niŋdo geân aregât humonenŋe dâm nengonŋetgât ukenŋe bo nâŋgâwei. ");
INSERT INTO tim_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Akto yeŋgâlân gâtŋe bikŋe tân yeŋgum âi yeŋgât mem manmap are âmâ Anutuŋe ekto huragumap. ");
INSERT INTO tim_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aregât yeŋgâlân gâtŋe siâŋe ikiŋe kotŋe mem agato âmâ Anutuŋe mem gewiap. Dâ kotŋe mem gembo âmâ Anutuŋe mem agatbiap. ");
INSERT INTO tim_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Gâuk Mosegât den makmâ kepikmai akto Parisaio ye hârok hiaŋgi luâk. Luâk âmbâle himbimgât kâmolân ariwerân akbiâ âmâ yeŋe dâp gisapko yeŋgimai. Yeŋe âmâ ain bo ariwaen dâm âmâ ariwaen dâmai yâk yeŋgât dâp gisapko yeŋgimai. ");
INSERT INTO tim_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Gâuk Mosegât den makmâ kepikmai akto Parisaio hiaŋgi luâk yeŋe mându kambut yeŋgât emet me wan me wan kâmbu memai. Dâ nenekbiâ huraguâk dâm Anutu sop kâlep ulilaŋmai. Aregât Anutuŋe hâuŋe umatŋe bâleŋe akyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Gâuk Mosegât den makmâ kepikmai akto Parisaio ye luâk konok yeŋgât pat agâkgât âi humo mem haru akto hân hâtikom arimai. Arim hâwâtyekbiâ dewatiyekmâ âmâ benŋe hemem kâlâpgât pat akmâ ewangiyekbiap. ");
INSERT INTO tim_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Gâuk Mosegât den makmâ kepikmai akto Parisaio yeŋe luâk âmbâle manman âlepŋân kewuguyektenŋe ariwai dâmai gârâmâ ye âmâ dewunyeŋe bokbokŋe. Aregât hin dâmai, “Luâk âmbâle siâŋe sumbe aregât meteŋân dâm makbiâ âmâ yânŋe akbiap. Dâ sumbe kat kat opmângât goli aregât meteŋân dâm makbiâ âmâ âlepŋe akbiap.” dâmai. ");
INSERT INTO tim_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hain dâmai amâ dewunyeŋe nâŋgâ nâŋgâ yeŋe hândâk akmap. Anutuŋe wan ekto humo akmap? Goli me sumbe emetŋe? Sumbe kat katŋaet emetŋande goli are ewangimap. Sumbe emetŋe bo tatâp dâine puli are yânŋe akbop. ");
INSERT INTO tim_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Akto ye hin dâmai, “Luâk âmbâle siâŋe sumbe kat katgât alata kotŋe konmâ den kârikŋe makbiâ yânŋe akbiap. Dâ yâkŋe sumbe om alata kakŋân katmai are konmâ den kârikŋe makbiâ amâ kârikŋe akto areâk membei.” dâmai. ");
INSERT INTO tim_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hain dâmaigât âmâ dewunyeŋe hândâkŋe akmap. Wan me wan Anutu waŋmai arekŋe alata bo ewangimap. Alata bo tatâp dâine sumbe yânŋe akbop. ");
INSERT INTO tim_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aregât luâk âmbâle alata aregât kotŋe konmâ den kârikŋe makbai arekŋe alatagât kotŋe areâk bo konbai. Alata akto sumbe me wan kakŋân katmai are olop konmâ makbai. ");
INSERT INTO tim_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Akto luâk âmbâle sumbe kat kat opmân aregât kotŋe konmâ den kârikŋe makbai arekŋe opmân aregât kotŋe areâk bo konbai. Opmân akto aregât Amboŋe Anutu yâkgât kotŋe konbai. ");
INSERT INTO tim_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Akto himbim kotŋe konmâ den kârikŋe makbai arekŋe Anutu tat tat akto tat tat Amboŋe lâuwâ lâuwâ yetkonbai. ");
INSERT INTO tim_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Gâuk Mosegât den makmâ kepikmai akto Parisaio ye hiaŋgi luâk. Ye metâ akto lombo akto sot siâ siâ are dopŋân potatmâ Kembugât pat dâm bikŋe katmai. Dâ Moseŋe kulemgoep den bikŋe umatŋe are hepunbiâ bâlimap. Aregât den amâ hin. Wan me wan âlepŋe membiâ ârândâŋâk akto okot nâŋgâ nengim gala akmai akto Humogâlân biwi kat kat aregât agak meme are âkâ hamiaŋmai aregât siân hâuŋe humo bunewâk yeŋgiwiap. Ye Mosegât den owâiŋe akto umatŋe are lâuwâ lâuwâ lokomai dâine ârândâŋ akbop. ");
INSERT INTO tim_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ye, “Nen kewuguyekmaen.” dâm âmâ luâk dewunyeŋe bok bokŋe are yeŋgât dop hainâk akmai. Wan me wan bâlensiâ aregâlâk nâŋgâmai. Dâ wan me wan umatŋe Anutuŋe egâliaŋmap are amâ yânŋe dâm hepunmai. ");
INSERT INTO tim_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Gâuk Mosegât den makmâ kepikmai akto Parisaio ye hiaŋgi luâk. Ye hâk akto hângât aregâlâk nâŋgâmai. Âmbâle siâŋe kondo akto umbâ hâkŋeâk pulim kâlegen bo pulim akmap aregât dop hainâk yâk hâkyeŋe âlepŋe akmai. Dâ biwiyeŋân âmâ kâmbugât akto hâkgâlâk egâliaŋ aregâlâk nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Woe, Parisaio luâk, ye âmâ dewunyeŋe bokbokŋe hainare akmai. Kâlegen biwiyeŋe soŋ heŋgemgombiâ âmâ huraguwiap benŋe hâkyeŋe gai hainâk salek salek akbiap. ");
INSERT INTO tim_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Gâuk Mosegât den makmâ kepikmai akto Parisaio ye hiaŋgi luâk. Lâmân luâk âmbâle han yeŋgumai are buluŋe me wan me wan âlepŋe agâk dâm kâmetmai. Dâ kâlegen âmâ hagitŋe akto hâkŋe hambuŋe are yemap aregât dop hainâk ");
INSERT INTO tim_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","luâk âmbâle bikŋande hâkyeŋe yekbiâ ârândâŋ akmap. Dâ biwiyeŋân âmâ den hiaŋgim agak meme bâleŋe akto Anutugât den kârikŋe hamiaŋmâ nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Gâuk Mosegât den makmâ kepikmai akto Parisaio ye hiaŋgi luâk. Ye hin nâŋgâm hilipkomai. Hokboâk hokboâk propete luâk akto luâk agak meme âlepŋe akmâ manmini are yeŋgât sum are buluŋande hâk meaŋmâ kotyeŋe lauyeŋande mem agatmai. Are nâŋgâre bâliâp. ");
INSERT INTO tim_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Buluŋande meaŋmâ hin dâmai, “Woe, nen ulikŋân bâgilupnenŋe mali dop hainâk malion dâine yâk tân yeŋguenŋe Propete luâk bo yeŋguwâen.” dâm lauyeŋande makmai. ");
INSERT INTO tim_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hain akmâ keiyeŋe mem miawakmai. Ulikŋân akmini areyeŋgât dop ye hainâk akmai. Aregât ye ain manmini dâine Propete luâk are yeŋgumbiâ mombâi. ");
INSERT INTO tim_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Akto humomolupyeŋe dosa kakŋân manmâ gayi, ye gai hainâk dosa kakŋân manbiâ dosayeŋe pikmâ yembiap. ");
INSERT INTO tim_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ye niambigât kâmot, ye Anutuŋe dosa yeŋaet hâuŋe yeŋgimboân âmâ gain gain akmâ âlepŋân ariwai? ");
INSERT INTO tim_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aregât hoŋ bawalupne propete luâk akto nâŋgâ nâŋgâ luâk akto den makmâ kepikmai luâk are huŋgun yeŋgire yeŋgâlân togom makyeŋgimbiâ bikŋe yeŋgum siâ siâ ketugu yekbiâ bikŋe mombai. Dâ bikŋe amâ lâwinân yeŋgumbiâ mombai. Dâ bikŋe amâ yeŋe den opmânân bugâŋe yeŋgumbiâ hâk hilâlâm akbai. Hain akmâ bikŋe kepia siânba watyekbiâ kepia siân ariwai. ");
INSERT INTO tim_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aregât ulikŋân Anutuŋe keiŋe katmâ luâk âmbâle ketuguyekto mali sop ain Anutugât hoŋ bawalupŋe hilip yeŋgum gayi are yeŋgât nâŋgâmbiâ âlepŋe akmap aregât yeŋe hainâk akmâ dosa hainâk membai. Akto hakulupnenŋande bugâŋe Abe kom ainba keiŋe katmâ yeŋgum gam gam bâiŋe Berekia nanŋe Sakaria sumbe emetŋaet hâŋgi akto alatagât keiŋe aregât hutŋân gam ariwerâm akto ain kombiâ moep. Akto hakulupnenŋande Anutugât Propete hârok yeŋgumbiâ moyi. ");
INSERT INTO tim_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aregât hin makyeŋgire nâŋgâŋet. Yu mandâi irekŋe Anutugât luâk âi membiâ ârândâŋ agep are hilipyeŋgumbiâ moyi aregât hâuŋe amâ yeŋgâlân miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bâe, Yerusalem kepia ambolupŋe areyeŋgât keiyeŋe hin. Yâkŋe Anutuŋe hoŋlupŋe akto propetelupŋe huŋgun yeŋgimbo yeŋgâlân togombiâ kâtŋe mem panbiâ yeŋgumbo momai. Puiŋe nanaŋlupŋe damunyeŋe akmâ mem mendugu yekmâ korat yeŋgumap aregât dop hainâk mendugu yekmâ okotnân katyekmâ damunyeŋe akberâre hâkâŋne akmâ arimai. ");
INSERT INTO tim_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aregât Anutuŋe damunyeŋe bo akmap kepiayeŋe hepundo bugâ miawak yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aregât nâ bo nekmâ âgâmbiâ hilâm siân miawaktere nekmâ hin dâm makniŋbai, “Wei, Gâŋe Anutugât laugât togonengiât aregât âlepŋe akgiŋne.” hain dâwai.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuŋe sumbe kat kat emetŋânba sopando luâklupŋe emet are ekbiâ humo akto hin dâyi, “Humo, sumbe kat kat emetŋe ire ek.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","hin makyeŋgiep, “Emet humo ire ektâi are hâmbâi gasalupyeŋande kârikŋe akmâ kât me wan me wan ire gagaim itiŋ gulam mem patakowai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hain dâm makyeŋgimbo gimbâŋe kotŋe Oliwa ain âgâyi. Ain tatmâ luâklupŋe yâkŋeak yoŋâk Yesu hin aikoyi, “Gâ maknengiât are amuten miawakbiap? Akto sop humo miawakbiap akto gâŋe purik katmâ lâuwâŋe in manmenâ hân hârok bo akbiap aregât dâp gain gain nâŋgâwaen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Hain dâmbiâ hin makyeŋgiep, “Luâk dondâ miawakmâ nâŋgât kolân hâk tunaŋgim hin dâwai, “Nâmâ Anutuŋe huŋgun niŋdo geân.” hain dâmbiâ luâk âmbâle dondâŋe han gulip akbai. Gârâmâ ye han gulip akbâigât den yu maktân ire nâŋgâm biwiyeŋe damunŋe kârikŋe agaŋgim manbei. ");
INSERT INTO tim_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Akto bugâgât warapŋe me bugâgât denŋe nâŋgâm ainâk hin nâŋgâwei, “Anutuŋe are miawakbiapgât nâŋgâmbo miawaktâp.” dâm aregât bo hamep akbei. Dâ sop bâiŋe âmâ irawot miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bugâ akto kuk me wan me wan umatŋe are miawakbiap dâm Anutuŋe den makmâ kalep. Are miawakto hân bikŋande gasa agaŋgim ariwai. Akto mop humo miawakbiap. Akto wâriŋ humo mem wan me wan hârok mendo duwuŋ humo akbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hinŋe maktere nâŋgâi are amâ umatŋe. Aregât keiŋeâk miawakto hamiŋân umatŋe dondâ miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yeŋgât gasalupyeŋande den âiân katyekmâ den opmânŋân bugâŋe yeŋguwai. Akto yeŋgâlân gâtŋe bikŋande mombai. Dâ bikŋe âmâ nâŋgât den lokowai aregât hân hârok aregât ambolupŋande kuk bâleŋe akyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aregât, “Nen Yesugâlân gâtŋe.” dâmai are yeŋgâlân gâtŋe dondâŋe hepun nekmâ ikiŋeâk ikiŋeâk akmâ gasa agaŋgiwai. Akto yeŋgâlân gâtŋe bikŋande bikŋe kewugu yekmâ kiapgâlân arim makyeŋgimbiâ yeŋguwai. ");
INSERT INTO tim_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Akto sop ain luâk dondâ agatmâ, “Nen Anutugât Propetelupŋe.” dâm heyeŋgimbiâ luâk âmbâle dondâ han undup akbai. ");
INSERT INTO tim_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Akto agak meme bâleŋe are miawakmâ humo akbiap aregât luâk âmbâle dondâŋe nâŋgât akto galagât okot nâŋgâ nâŋgâ aregât agak meme are âmâ hepunbai. ");
INSERT INTO tim_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dâ bikŋande âmâ kârikŋe akmâ tatmâ âgâmbiâ sop humoân âmâ Anutuŋe meyekbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Akto Anutuŋe damunyeŋe akbiap aregât den pat are luâk âmbâle hânŋe hânŋe hârok nâŋgâmbiâ Anutugât keiŋe humo agâk dâm hân hârok manmâ makyeŋgim manbai. Hain akbiâ hamiŋân sop humo miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aregât propete Daniel arekŋe kulemgoep are yaiwâk oyaŋmâ nâŋgâm heŋgemgowei. Den are kârigembo siâ me siâ bâleŋe hilip agu aguŋe olowâk âgâm kinmâ sumbe kat katŋân ain bo kin kinŋân kinbiap amâ ye nâŋgâm heŋgemgowei. ");
INSERT INTO tim_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hain akmâ nenguwâi dâm Yudaia hânângenba pârigim gimbâŋe siân âgâwai. ");
INSERT INTO tim_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Akto kepia ewumâk manbiap arekŋe emetŋe kâlegen purik katmâ âgâ ito sikumŋe bo membiap. ");
INSERT INTO tim_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Akto âiângenba manbiapŋe kepian âgâm sâŋgum dâgâmŋe bo membiap. ");
INSERT INTO tim_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Akto sop ain âmbâi tepdâŋe me namân gâtŋe olowâkŋe âmâ gain gain akbai? Umatŋe olowâk akbai sop ain âmâ umatŋe humo dondâ miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Amâ Anutuŋe luâk mem miawak yegewânbak hainâk bo miawagep. Akto hân himbim liunyelegewânbak umatŋe hainâk bo miawagep. Akto hamiŋân umatŋe hainâk bo miawakbiap aregât Anutu hin ulilaŋbei, “Humonenŋe umatŋe are tânâk kâlegen me âi bo meme sopŋân bo miawak nengiwiap.” dâwei. ");
INSERT INTO tim_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aregât Kembuŋe sop are bo dâm hârembo dâine luâk me âmbâle siâ me siâ bo manmâ kârikŋe manbop. Dâ Anutuŋe ikiŋe kâmotlupŋe yâk yeŋgât akmâ âmâ sop aregât makto tâlâwâk akbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Akto Anutuŋe huŋgunaŋdo iregen miawaktâp akto Anutuŋe huŋgunaŋdo indâgen miawaktâp den hain makmâ bam gamâk akbiâ bo nâŋgâyeŋgiwei. ");
INSERT INTO tim_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Amâ hingât. Sop ain hiaŋgi luâk akto Propete yânŋe togom nâŋgât kâmot potatmâ kepilâyegân are han biwiyeŋe mem gâlikowaigât kulem siâ siâ akto tirip keiŋe keiŋe mem âi humo membai. Gârâmâ hanyeŋe mem gâlikowaigât dâp bo tatâp aregât ewum hâumgowai. ");
INSERT INTO tim_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Akto ye gulip akbâi dâm irawotŋân yu makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Akto ain hiaŋgi luâkŋe hin makyeŋgiwai, “Wei, Anutuŋe huŋgunaŋdo gewiap dâmai âmâ hân kamitŋângen ain miawaktâp.” dâmbiâ yâk yeŋgât den bo nâŋgâm ekberâm ariwei. Akto hiaŋgi luâkŋe hin makyeŋgiwai, “Woe, hoŋ bawa arekŋe purik katmâ gem emet kâlegen miawaktâp.” dâmbiâ arekâ hainâk bo nâŋgâwei. ");
INSERT INTO tim_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aregât lâuwâŋe makbe. Himbim belek akmâ dowâk sop konok miawakmap dop are hainâk luâk akmâ geân nâ hân siângen miawakbianân âmâ hân hârok mem belekŋe memap dop hainâk nâŋe hânân gem miawakbian. ");
INSERT INTO tim_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Siâ siâ mom yembiâ liplipŋe nemberâm mendugumai. ");
INSERT INTO tim_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Akto areâk bo. Umatŋe humo are bo akto sop ain âmâ dewutâ lâuwâ lâuwâk pagaleŋe bo akbiandat. Akto diâ himbimânba bererek kârâm hânân gewai. Akto wan me wan himbimân yendâp are hârok duwuŋ akbai. ");
INSERT INTO tim_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Akto sop ain luâk akmâ geân nâŋgât kulem are himbimân miawakbiap, aregât luâk âmbâle hânŋe hânŋe manmai are hârok indem tâgâiak akbai. Ainâk nâ hamandat kakŋân tatmâ pagaleŋe humo olop agat agatne akmâ gere ekbai. ");
INSERT INTO tim_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Gârâmâ lâmun kârikŋe kondere munŋe humo miawakto aŋelolupne mendugumbiâ huŋgun yeŋgire nâŋgât kâmot nune dâtâŋe dâman are hân hârok ainba mem kewuguyekmâ ariwai. ");
INSERT INTO tim_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Akto den ginŋe siâkâ makbe. Ye lâwin kotŋe solom are esenŋe bererek dâmbo hin dâmai, “Wei, emelâk sot kâmetberengât sopŋe aktâp.” dâmai. ");
INSERT INTO tim_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aregât dop hainâk hâmbâi wan me wan maktân are hârok miawakto ye hin nâŋgâwai, “Emelâk togowiapgât sop ewumâk aktâp.” dâwai. ");
INSERT INTO tim_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Luâk âmbâle yu mandâi arekŋe ire hârok miawakto ekbai. ");
INSERT INTO tim_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Aregât hin makbe. Wan me wan yu maktân ire âmâ bunewâk miawakbiap. Hân akto himbim âmâ bo akbiandat. Dâ nâŋgât den âmâ bo boakbiap. Amâ yem âgâwiap. ");
INSERT INTO tim_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Akto sop aregât hin makbe. Luâk me âmbâle aregât sop bo nâŋgâmai. Dâ aŋelo himbimân manmai arekŋe âkâ bo nâŋgâmai. Akto nâkâ hainâk bo nâŋgân. Dâ Ewene konokŋe aregât sopŋe nâŋgâmap. ");
INSERT INTO tim_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Amâ hin akbiap. Ulikŋân Noa malep ain ugurup miawagewân sop ain luâk âmbâle hanâk hanâk manmâ, “Nen âlepŋe manbaen.” dâm sot tu nem luâk âmbâle meagi. Hain akmâ manmâ âgâmbiâ Noaŋe waŋga kâlegen âgâep. Âgâmbo âlepŋe manden dâmbiâ umatŋe miawak yeŋgiep. Are bo nâŋgâm hanâk hanâk manbiâ tânâk humo momoŋe gembo ugurupŋe humo togom luâk âmbâle hârok mem kawut yekto mom meteyi. Aregât dop hainâk siân âmâ luâk âmbâle aregât sop bonâŋgâmbiâ luâk akmâ geân nâ gere umatŋe humo miawak yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sop ain âmâ luâk lâuwâ âiângen manbela ainâk Anutuŋe luâk konok mem konok âmâ hepunbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akto sop ain âmbâle lâuwâ âi membela ainâk Anutuŋe âmbâle konok mem konok hepunbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Akto Humoyeŋe nâ togowiangât sop bo nâŋgâmai aregât ye damun kârikŋe akmâ manbei. ");
INSERT INTO tim_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aregât den ginŋe siâ makbe. Kepia amboŋande gasa hândâgân togowiap aregât sop nâŋgâm âmâ ain biwi golâk tatmâ emet kepiaŋe damungombo âmâ bo bâliaŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dop hainâk luâk akmâ geân nâ lâuwâŋe gewian aregât sopŋe bo nâŋgâmai aregât yeâmâ biwi pâlâmŋe akmâ bo nâŋgâ niŋbâigât nâŋgâmâk biwi golâk damun nugum manbei. ");
INSERT INTO tim_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Aregât den ginŋe siâkâ maktere nâŋgâŋet. Luâk kotdâ siâŋe hoŋ bawalupŋe yeŋgât damun siâ katmâ hin dâm magaŋbiap, “Arim mandere gâŋe damunyeŋe akmâ sopŋânâk sot me soŋgo are dop yeŋânâk yeŋgim manben.” ");
INSERT INTO tim_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hain dâm hepun yekmâ arimbo damunyeŋe arekŋe âi aregât biwiŋande mem heŋgemgom humoŋande purik katmâ togom ekmâ okot âlep nâŋgâ aŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Hain akbiap aregât hângât sikum siâ siâ are hârok damungoâk dâm magaŋbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dâ humoyeŋande damunyeŋe akmâ manben dâm arimbo âmâ damunyeŋande biwiŋande hin nâŋgâwiap, “Kotdânande hepun nekmâ arim sop kâlep mandâp imâ dowâk bo togowiap.” ");
INSERT INTO tim_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Hain nâŋgâm âmâ luâklupŋe are bugâ yeŋgum âmâ tu kârikŋe nem biwi gulip akmai yâk olop hain akmâ manbiap. ");
INSERT INTO tim_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hain akmâ hilipkom biwi pâlâmŋe akmâ mando humoŋande ainâk togowiap. Are bo nâŋgâm mando humoŋande dowâk sân sânâk togom ");
INSERT INTO tim_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ekmâ yeŋgum bâleŋe akyeŋgiep aregât mem kom gâimbo itik matik akto hiaŋgi luâk âmbâle yâk olowâk hemem kâlâpgât pat akbai. Akmâ indem kamboŋmâ hâk hilâlâm nâŋgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Akto Yesuŋe den ginŋe siâ hin magep, “Sop humoân Anutuŋe damunyeŋe akbiap amâ âmbâi kâmŋe bât bip bip hârok yâkŋe agi dop hain akbai. Amâ luâk siâŋe âmbâle siâ miep arekŋe yâk yeŋgâlân togowerâm agep. ");
INSERT INTO tim_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Akto âmbâle momerâk âmâ biwi golâk damun agaŋgim manmini aregât manmâ pagaleŋe akto pagaleŋe tuŋe kâlegen kâim âmâ tu bikŋe hâpuŋân kâimbiâ gembo mem ariyi. Akto âmbâle bikŋe momerâk are âmâ hanâk hanâk manmini aregât pagaleŋe akto pagaleŋe tuŋe kâlegen mem âmâ tu hâpuŋân bo kâimbiâ gembo mem ariyi. ");
INSERT INTO tim_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hain manmâ tatbiâ luâk âmbâle miep arekŋe titnan togombo etemŋe tatmâ asiŋ yem mali. ");
INSERT INTO tim_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hain akbiâ hândâk timoŋân luâk siâŋe hin dâep, “Luâk âmbâle mendâp ina togoâp gârâmâ ari dâwân peniaŋmâ kewugumbiâ togoŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Akto âmbâi kâmŋe arekŋe agatmâ pagaleŋeyeŋe are membiâ ululunŋe humo oep. ");
INSERT INTO tim_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hain akto âmbâle hanâk hanâk manmai arekŋe âmbâle nâŋgâ nâŋgâyeŋe âlepŋe are hin makyeŋgiyi, “Pagaleŋenenŋe bokberâm aktâp gârâmâ yeŋe tu siâ potatmâ kâim nengiŋet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Hain dâmbiâ âmbâle nâŋgâ nâŋgâyeŋe âlepŋe arekŋe hin makyeŋgiyi, “Bo. Tu irekŋe nengât dop bo. Gârâmâ bo akbopgât ye arim aŋgim nene emetŋângen arim yeŋeak puligoŋet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hain dâmbiâ yâk tu are puligowerâm aŋgim nene emetŋângen arim manbiâ luâk âmbâle miep are togoep. Akto âmbâle wan me wan mem dunŋân ketugum tali yâk luâk are olop sot soŋgo nemberâm emet kâlegen âgâm hâŋgi gisapkom tali. ");
INSERT INTO tim_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Akto âmbâle bikŋe are hami togom hin magi, “Humonenŋe gâ hâŋgi mem katnengi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hain dâmbiâ luâk arekŋe hin makyeŋgiep, “Nâ ye bo nâŋgâyeŋgiân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aregât keiŋe hin. Nâ sop humoân togowian aregât bo nâŋgâi aregât biwiyeŋaet damun kârikŋe akmâ manbei. ");
INSERT INTO tim_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Akto aregât den ginŋe siâkâ makbe. Luâk siâŋe kâlewângen ariwerâm hin agep. Luâk arekŋe âi luâklupŋe yeŋgondo togombiâ hin makyeŋgiep, “Wan me wan tatniŋdâp iregât damun kârikŋe akbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akto âi luâklupŋe are yeŋgât agak memeyeŋe akto âi memeyeŋe aregât keiŋe nâŋgâm kinmâ âi luâk siâ ikiŋeâk ikiŋeâk âi dopyeŋân puli hin yeŋgiep. Siâ ito momerâk akto siâ ito lâuwâ akto siâ ito konok puli lugumbo giep. Hain yeŋgim ikiŋe gem ariep. ");
INSERT INTO tim_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Akto luâk ito momerâk miep arekŋe aŋgi goaŋgi âi mendo puli arekŋe puli oloŋdo ito momerâk siâkâ miawakto 10 agep. ");
INSERT INTO tim_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Akto luâk ito lâuwâ miep arekâ hainâk aŋgi goaŋgi âi mem ito lâuwâkâ oloŋdo ito imbât miawagep. ");
INSERT INTO tim_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dâ luâk puli ito konok miep arekŋe âmâ humoŋaet puli are mem ari lâm kendâm ain heambukto yiep. ");
INSERT INTO tim_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Akto manmâ manmâ sop kâlewâk akto âi luâk yeŋgât humoyeŋe are purik katmâ togoep. Togom âi luâklupŋe puli meyi are olop den heŋgemgowerâm agi. ");
INSERT INTO tim_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Akto luâk ito momerâk miep arekŋe puli siâkâ mem togo humoŋe are hin magaŋep, “Luâk humo ulikŋân gâŋe ito momerâk niŋen arekŋe âiŋe mem ito momerâk siâkâ yu meân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hain dâmbo humoŋe arekŋe hin magaŋep, “Gâ âi luâk âlepŋe. Gâŋe âlepŋe dondâ agen. Gâŋe âi mem heŋgemgom wan me wan bâlensiâ ire damunŋe akmâ heŋgemgoen aregât nâŋe wan me wan ire hârokgât damunŋe kat gektere kambiamne âlepŋe aktâp aregât heroŋe ak.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Akto luâk ito lâuwâ miep arekŋe togom humoŋe are hin magaŋep, “Ulikŋân gâŋe puli niŋen arekŋe âiŋe mem ito lâuwâ siâkâ meân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hain dâmbo humoŋe arekŋe hin magaŋep, “Gâ âi luâk âlepŋe. Gâŋe âlepŋe dondâ agen. Gâŋe âi mem heŋgemgom wan me wan bâlensiâ ire damunŋe akmâ heŋgemgoen. Aregât nâŋe gâ wan me wan dondâ iregât damunŋe kat gektere kambiamne âlepŋe aktâp aregât gâ hainâk kambiamge heroŋe agâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Akto luâk ito konok miep arekŋe togom humoŋe hin magaŋep, “Luâk humo nâ gâŋgât keige nâŋgân. Gâ luâk kârikŋe. Luâk siâŋe âi kâmetmap are gâŋe hindâm om nemat. Akto hân siâ luâk siâŋe sot koaŋe panmap ain gâŋe seŋgo orem om nemat. ");
INSERT INTO tim_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hain akmat aregât gâŋgât hamewakmâ puli niŋen ire mem arim lâm kendâm ain heambuktere yemap. Wan me wan ire gâŋgât aregât meak.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hain dâmbo humoŋe arekŋe hin magaŋep, “Gâ âi luâk bâleŋe. Gâ luâk konam. Akto luâk siâŋe kalam kâmelep ainba sot mem om nemat dât. Akto luâk siâŋe sot koaŋe panmap ainba seŋgo orem om nemat dât. ");
INSERT INTO tim_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aregât puli ire siâ waŋmenâ âi mendo puli siâkâ mendât dâine togomân âmâ are mendere ârândâŋ akbop.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","Akto damunyeŋande tembe lokolupŋe hin makyeŋgiep, “Luâk bikŋande wan me wan dondâ memai amâ nâŋe dondâ siâkâ yeŋgiwian. Dâ luâk siâŋe wan me wan getek memai amâ wan me wan bâlensiâ kinaŋbiap are meman aregât ito konok are mem luâk ito momerâk miep are waŋŋet. ");
INSERT INTO tim_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Akto âi luâk konam are âmâ watbiâ ginŋângen hândâkŋân are geâk. Ain gembo luâk âmbâle bâleŋe indem kamboŋmâ manbai are olop manbai.” Luâk kembu arekŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aregât lâuwâŋe makbe. Luâk akmâ geân nâ purik katbian sop ain pagaleŋân aŋelolupne olop togom luâk âmbâle damunyeŋe akbian. ");
INSERT INTO tim_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Akto lama damunŋande lama potatmâ biken katyekmâ nâniŋ biken katyekmâ akmap. Hain akmâ luâk âmbâle hârok enemnân mendugumbiâ mem potatmâ kâmot lâuwâ katyekbian. ");
INSERT INTO tim_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Lama are âmâ bâtne biken bungen katyekbian. Dâ nâniŋ are âmâ kanegen katyekbian. ");
INSERT INTO tim_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hain akmâ damunyeŋe nâŋe luâk âmbâle bâtne bungen kinbai are hin dâm makyeŋgiwian, “Ewene damun akmap arekŋe ulikŋân hân himbim liunyelegewân bâtŋe bâiŋe manman âlepŋe katyeŋgiep are yeŋgimbo mem manmâ âgâm heroŋe akbai. ");
INSERT INTO tim_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nâŋe sotgât mop agu agu mandere yeŋe sot om niŋi. Akto tugât nâŋgâm mandere yeŋe tu niŋbiâ neân. Akto nâ kepia siân gâtŋe ina yeŋe kewugu nekmâ emetyeŋân katnegi. ");
INSERT INTO tim_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Akto sâŋgum bâlâk mandere yeŋe sâŋgum niŋi. Akto kundat akmâ mandere togom nekmâ tân nuguyi. Akto humomolupnande kala busi kâlegen katnekbiâ tatere togom okotyeŋe nâŋgâm tân nuguyi.” ");
INSERT INTO tim_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hain dâre luâk âmbâle agak meme âlepŋeâk akmâ manmai arekŋe den hâuŋe hin makniŋbai, “Humo, gâ maktât amâ bo nâŋgâen. Amuten gâŋe sotgât me tugât nâŋgâmenâ giŋion? ");
INSERT INTO tim_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Akto amuten gâ luâk kepia siân gâtŋe me sâŋgum bâlâk manmenâ ");
INSERT INTO tim_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","me kala busi kâlegen tatmenâ me kundat akmâ manmenâ tân guguyion? Nen amâ hain siâ bo akgiŋion.” dâwai. ");
INSERT INTO tim_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hain dâmbiâ damunyeŋe nâŋe hin makyeŋgiwian, “Nâŋgât kâmolân gâtŋe siâ yâkgât kotŋe bo tatâp are yeŋe tângoyi are amâ nâ tân nuguyi dop aktâp.” dâwian. ");
INSERT INTO tim_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hain dâm makyeŋgim benŋe luâk âmbâle bâtŋe kanegen tatbai are âmâ hin makyeŋgiwian, “Ye luâk bâleŋe. Ekeŋet. Anutuŋe Niambi akto yâkgât aŋelolupŋe kâlâwân katyekbian dâm kâlâp kalep ain manŋet. ");
INSERT INTO tim_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nâŋe sotgât mop agu agu mandere yeŋe siâ bo om niŋi. Akto tugât nâŋgâm mandere tu siâ bo hâgâm gutmâ niŋi. ");
INSERT INTO tim_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Akto nâ kepia siân gâtŋe ina yeŋe kewugu nekmâ emetyeŋân bo âgâ katnegi. Akto sâŋgum bâlâk mandere yeŋe sâŋgum siâ bo niŋi. Akto nâ kundat agân me kala busi kâlegen katnekbiâ talân sop ain bo togom negi.” ");
INSERT INTO tim_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hain dâre hin makniŋbai, “Woe, amuten gâŋe sotgât me tugât nâŋgâen me luâk kepia siân gâtŋe me sâŋgum bâlâk manmenâ me kala busi kâlegen tatmenâ me kundat akmâ manmenâ âmâ bo tân guguyion?” dâwai. ");
INSERT INTO tim_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hain dâmbiâ hin dâwian, “Yeŋe nâŋgât kâmolân gâtŋe gegeŋe are bo tânyeŋguyi âmâ yeŋe nâ hainâk bo tân nuguyi dop aktâp.” dâwian. ");
INSERT INTO tim_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hain dâm watyektere kâlâwân arim hâk hilâlâm dondâŋe nâŋgâm âgâwai. Dâ luâk âmbâle âlepŋe amâ kewugu yektere manman âlepŋân manmâ âgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuŋe den are hârok makmâ metem sop ain hoŋ bawalupŋe hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nâŋgâi. Hombaŋ kotŋe Pasowa aregât sop amâ hilâm lâuwâ akto miawakbiap. Ain luâk akmâ geân nâ lâwinân nuguwaigât mem miawak nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Akto sop ain sumbe kat kat luâk akto Israe yeŋgât humomolupyeŋe arekŋe sumbe kat kat yeŋgât humoyeŋe siâ kotŋe Kaipa aregât emelan mendugum ");
INSERT INTO tim_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu hiaŋgim mem kondenŋe moâk dâm aregât yoŋâk magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hain akmâ benŋe hin magaŋgiyi, “Hombaŋ kâmbokŋân ire hain bo akberen. Ageine luâk âmbâle dondâ kuk akbiâ bugâ humo miawakbopgât.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuŋe Betania kepian luâk siâ diwi bâleŋe agep kotŋe Simoŋ aregât emelan talep. ");
INSERT INTO tim_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Emelan tato âmbâle siâŋe tu higenŋe ukenŋe hâpurâ puliŋe âgâ âgâŋe are mem yâkgâlân togoep. Togom tu higenŋe ukenŋe are Yesu sot nem tato ain yâkgât kautŋân kâiep. ");
INSERT INTO tim_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Akto Yesugât hoŋ bawalupŋande are ekmâ nâŋgâmbiâ ârândâŋ bo akto hin magaŋgi goaŋgi agi, “Wangât tu higenŋe ukenŋe ire yân kâiâp? ");
INSERT INTO tim_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nenŋe ire mem arim yeŋgienŋe dâine luâk bikŋande puli humoŋe puligombiâ puli are mem arim luâk umburuk yeŋgiwâen ina.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hain dâmbiâ Yesuŋe den are nâŋgâm hin makyeŋgiep, “Wangât ye âmbâle iregât kakŋân umatŋe katâi? Hepunŋet. Agak meme âlepŋe dondâ akniŋdâp are nâŋgaŋdere âlepŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Luâk umburuk âmâ ye olop sop kâlep manbai. Dâ nâmâ ye olop sop kâlep bo manbian. ");
INSERT INTO tim_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Âmbâle irekŋe tu higenŋe hâknân kâiâp ire âmâ sumân katnekbai aregât dopŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nâ den bunŋe makyeŋgire nâŋgâŋet. Hânŋe hânŋe âmâ den pat âlepŋe ire makyeŋgiwai akto âmbâle irekŋe wan me wan akniŋdâp irekŋe âkâ olowâk makbiâ yâkgât nâŋgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Akto sop ain hoŋ bawalupŋe keiân lâuwâ are yeŋgât hut yeŋân gâtŋe siâ kotŋe Yudasi Karioto gâtŋe yâkŋe sumbe kat kat luâk yeŋgât humomolupŋe yeŋgâlân ariep. ");
INSERT INTO tim_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Arim hin makyeŋgiep, “Yeŋe wan niŋbiâ âmâ nâŋe Yesu yâgâten tatberâp ain kewugu yekmâ arim ire dâm hekat yeŋgire membai?” dâep. Hain dâmbo puli koaŋe 30 waŋi. ");
INSERT INTO tim_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Akto sop ain âmâ yâkŋe keiŋe katmâ gain gain aktere Yesu meŋet dâm aregât âi mem malep. ");
INSERT INTO tim_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Akto Pasowa hombaŋ aregât sop are miawakto hoŋ bawalupŋande Yesu hin magaŋi, “Emet wanân sot om katenŋe nemberen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hain dâmbiâ yâkŋe hin makyeŋgiep, “Ye Yerusalem âgâm âmâ ain luâk siâ ekmâ âmâ hin magaŋbei, “Tiksaŋe hin maktâp, “Emelâk nâŋgât sop ewumâk aktâp gârâmâ nâ hoŋ bawalupne olop gâŋgât emelan sot nemberen.” tiksa hain dâp.” dâwei.” Yesuŋe hain dâm makyeŋgim huŋgunyeŋgimbo ariyi. ");
INSERT INTO tim_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Arim Yesuŋe magep hain akmâ sot soŋgo are mem dumŋân dumŋân ketuguyi. ");
INSERT INTO tim_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Akto emet eŋgaiŋe akto Yesu akto hoŋ bawalupŋe keiân lâuwâ olop sot nem tatmâ ");
INSERT INTO tim_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","yâkŋe hin makyeŋgiep, “Nâ makyeŋgire nâŋgâŋet. Yeŋgât hutyeŋân gâtŋe siâŋe nâŋgât gasa kewugu yekto menekberâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hain dâmbo nâŋgâm biwiyeŋe umatŋe akto siâkâ ikiŋeâk ikiŋeâk hin magaŋi, “Amâ nâ mon?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Dâmbiâ hin makyeŋgiep, “Luâk yu kondo konogân sot olop nemberet irekŋe nâ mem miawak nekberâp. ");
INSERT INTO tim_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anutuŋe makto kulemgoyi aregât den bunŋe akberâpgât âlepŋe luâk akmâ geân nâ momberân. Gârâmâ luâk nâ mem miawak nekberâp are memeŋande bo miep dâine owâiŋe agaŋbop. Amâ umatŋe humo miawagaŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hain dâmbo luâk kotŋe Yudasi Yesu mem miawagep arekŋe hin magaŋep, “Apo, nâmâ bo me?” dâmbo Yesuŋe hin magaŋep, “Amâ ya gugak maktât are.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Akto sot nem tatmâ Yesuŋe sot siâ mem Anutu mepaiŋe mem âmâ munditmâ hoŋ bawalupŋe yeŋgim hin makyeŋgiep, “Ire mem neŋet. Ire âmâ nâŋgât sunumne aregât dop.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akto waiŋ hâpurâ siâ mem Anutu mepaiŋe mem âlepŋe dâm magaŋmâ kâim yeŋgim hin makyeŋgiep, “Ye hârok tu ire mem neŋet. ");
INSERT INTO tim_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ire amâ Anutu olop irakŋe dewatiakbaigât hepne amâ luâk âmbâle dondâ yâk yeŋgât dosa bo agâkgât kâiwerân. ");
INSERT INTO tim_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nâ hinŋe waiŋ koaŋe bunŋe bo nemberân gârâmâ yân manmâ hâmbâi Anutuŋe lâuwâŋe damunyeŋe akberâm keiŋe kato ain ye olop nem agak meme irakŋe akmâ heroŋe akbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hain dâm makyeŋgimbo Anutugât kot mem agatmâ kep siâ membiâ bo akto arewa sopanmâ Oliwa gimbâŋân âgâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Âgâm ain hoŋ bawalupŋe hin makyeŋgiep, “Anutuŋe makyeŋgimbo kulemgoyi bikŋe hin tatâp. Anutuŋe hin dâep, “Nâŋe lama damunyeŋe kondere mondo lama are awam akmâ kâit akmâ metewai.” Den pat bunŋe miawakto menekberâm togombiâ ye hamep akmâ hârok gem awam akmâ hanâk hanâk ariwerâi. ");
INSERT INTO tim_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Akto nugumbiâ mondere han nugumbiâ momoŋânba agatmâ arim Galilaia hânân lâmyeŋgure Galilaia hânângen menduguwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hain dâmbo Petoroŋe hin magaŋep, “Gâŋgât gasa togombiâ hamewakmâ ariwerâi me bo. Bo nâŋgân. Dâ nâmâ bo hepun gekberân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hain dâmbo Yesuŋe hin magaŋep, “Makgiŋdere nâŋgâ. Hândâk uŋak gâŋe nâŋgâ yâkgât kotŋe bo nâŋgâman dâm makyeŋgimenâ âlâwu akto ainâk gokorok indewerâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hain dâmbo Petoroŋe kârikŋe akmâ hin dâep, “Bo. Nâ gâ olowâk mombaet aregât hamep bo aktân. Akto nâ gâŋgât kotge bo mem heambukberân.” dâep. Akto luâklupŋe hârok hain dâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Akto arewa arim kalam siâ kotŋe Gesemane ain ariyi. Ain arim Yesuŋe hin makyeŋgiep, “Ye in tatbiâ indâgen kinmâ Apo olop den magaŋgiweret.” dâmbo ain tali. ");
INSERT INTO tim_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hain tatbiâ hutyeŋânba Petoro akto Sebedaiogât nanlogâtŋe meyekto bayi. Ba kinmâ biwiŋe umatŋe akto hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Ye âmâ iren damun tatŋet. Biwine umatŋe dondâ akto gain gain akberân aregât tân nugum tatŋet.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Makyeŋgim hepun yekmâ getek indâŋânba hânân ge tatmâ Anutu hin magaŋep, “Ewene uŋak umatŋe miawak niŋberâm aktâp aregât bo niŋ dâm ulit giŋdân. Gârâmâ gâŋe âmâ nâŋgât han nâŋgâ nâŋgâne bo watben. Guge hange nâŋgâ nâŋgâge watben.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hain dâm gutmâ yem tatbiâ yekmâ Petoro goaŋmâ hin magaŋep, “Ye wangât asiŋ yendâi? Hinŋe hepun yektân ina pâlâmŋe yendâi. ");
INSERT INTO tim_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Biwiyeŋande âmâ laune lokowerâm aktâp. Dâ hâkyeŋe âmâ konam aktâp aregât agak meme bâleŋe arekŋe togom dop yeŋguwerâm akbopgât damun kinmâ Anutu ulilaŋŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hain dâm makyeŋgim purik katmâ bam lâuwâŋe hainâk Anutu magaŋep, “Ewene, gain gain nâŋgât? Uŋak âi niŋen aregât makmenâ umatŋe miawak niŋâkgât nâŋgât me? Hain nâŋgâmenâ âlepŋe agâk.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Magaŋmâ purik katmâ hoŋ bawa âlâwu asiŋgât dondâ nâŋgâyi aregât asiŋ yembiâ yegep. ");
INSERT INTO tim_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Akto hepun yekmâ bam âlâwuŋe Anutu hainâk magaŋep. ");
INSERT INTO tim_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Magaŋmâ metem purik katmâ yâk yeŋgâlân gutmâ hin makyeŋgiep, “Woe, wangât asiŋ yendâi? Bâin. Emelâk Anutuŋe ire miawak niŋbiapgât huŋgun niŋdo luâk akmâ geân aregât galanande heniŋmâ gasalupne kewuguyekmâ togombo menekberâigât sop ewumâk aktâp. ");
INSERT INTO tim_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gârâmâ bâin agatmâ indâre yekŋet. Nâŋgât halop hogoâi ina togoâi. Agatbiâ arim penâyeŋgine.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Hain dâmbo kinbiâ ainâk indâgenba Yudasiŋe luâk dondâ sumbe kat kat luâk are yeŋgât humomolupyeŋe yeŋgât kâmiti arekŋe huŋgun yeŋgimbiâ bugâ soŋ soŋ membiâ Yudasiŋe kewugu yekto togoyi. ");
INSERT INTO tim_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Akto luâk gasa kewugu yekto togoyi are âmâ Yudasi Karioto gâtŋe luâk arekŋe gasa tirip katyeŋgim hin makyeŋgiep, “Yesu are âmâ lokom maŋgandere ekmâ âmâ hikom mem ariŋet.” dâm makyeŋgim kewugu yekto tâwât bugâ me soŋ soŋ mem togoyi. ");
INSERT INTO tim_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Togom gasa are iŋgon kinbiâ Yudasiŋe Yesugât enemŋân âgâm Humone dâm lokom maŋganlep. ");
INSERT INTO tim_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Maŋgando Yesuŋe hin magaŋep, “Gala, gâ wan me wan akniŋberâm togoât are akniŋmenâ miawagâk.” dâmbo gasa Yudasi olowâk togoyi arekŋe âgâ Yesu mem hikoyi. ");
INSERT INTO tim_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mem hikombiâ luâklupŋe yeŋgâlân gâtŋe siâŋe tâwât mem oloŋmâ sumbe kat kat yeŋgât humoyeŋaet hoŋ bawaŋe siâ ondopŋeâk kârâm hârembo giep. ");
INSERT INTO tim_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hain akto Yesuŋe hin magaŋep, “Luâk siâŋe tâwâtŋe kuk akberâm mandâp amâ siâŋe tâwâtŋeak kârâmbo mombiap. ");
INSERT INTO tim_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gâ bo nâŋgât. Nâŋe âlepŋe Ewene magaŋdere dâine âlepŋe yâkŋe aŋelolupŋe dondâ niŋdo tân nuguwâi. ");
INSERT INTO tim_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gârâmâ nâŋe hain aktân dâine Anutuŋe nune mombian dâm makyeŋgimbo kulemgoyi denŋe are bunŋe bo akbop.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Akto sop ainâk Yesuŋe luâk kâmot togoyi are hin makyeŋgiep, “Ye tâwât bugâ lokom togoâi ire nâ me luâk kâmburâ siâ agaŋberâm togoâi? Nâ hilâmŋe hilâmŋe sumbe kat kat emetŋân kinmâ den pat makyeŋgiman. Sop ain menekbâi gâten. ");
INSERT INTO tim_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Anutuŋe hârok nâŋgâm makyeŋgimbo kulemgoyi are yendâp are bunŋe miawagâkgât hinŋe menekŋet.” dâmbo hoŋ bawalupŋande hamep akmâ hepunmâ gem awam agi. ");
INSERT INTO tim_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Akto Yesu mem sumbe kat kat are yeŋgât humoyeŋe kotŋe Kaipa yâkgâlân ariyi. Ain arimbiâ Mosegât den kepikmâ hekatyeŋgimini are akto Yuda yeŋgât kâmiti hainâk ain mendugum kili. ");
INSERT INTO tim_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Luâklupŋe hamewakmâ arimbiâ Petoroŋe konok purik katmâ yoŋâk hamiŋângen yoŋâk watyekmâ togom emet kili aregât ginŋânba ba sombeimân kilep. Bam âmâ luâk humo aregât tembe lokolupŋe yeŋgât hutyeŋân tatmâ wan me wan agaŋberâi are ekberâm talep. ");
INSERT INTO tim_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tato sumbe kat kat luâk yâk yeŋgât humoyeŋe akto Yudagât humomolupyeŋe arekŋe luâk niŋande Yesugât agak meme are nâŋgâp are makto kone dâm lâmgom kili. ");
INSERT INTO tim_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hain akmâ luâk dondâŋe hiaŋgim den aŋgâ hogom togo hâkŋân hâkŋân agi. Akto denyeŋe aregât keiŋe nâŋgâmbiâ Yesu kombiâ mombiapgât dop bo agep. ");
INSERT INTO tim_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Akto bâiŋe luâk lâuwâ siâ togom hin dâm hiaŋiat, “Luâk irekŋe hin makto nâŋgâyiot, “Nâŋe Anutugât sumbe kat kat emetŋe ire gagaim patakore awam akmâ yendo hilâm âlâwu kâlegen nunak mem metewom.” dâep.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Akto sumbe kat katyeŋgât kautŋande hutyeŋânba agatmâ kinmâ Yesu hin magaŋep, “Gâ wangât den hâuŋe siâ bo maknengiât? Den aŋgâ aŋgâ hogom togo hâkgân hâkgân aktâi iregât nâŋgâmenâ ârândâŋ aktâp me bo? Gain gain maknengimenâ nâŋgâne?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Hain dâm magaŋdo Yesuŋe den hâuŋe bo magaŋmâ denŋe nâŋâk kilep. Akto humoyeŋe arekŋe totokomâk hin magaŋep, “Bâin, Anutu manman kârikŋe amboŋe yâkgât meteŋân kinden aregât makgiŋdere maknengi. Gâ Anutuŋe nanŋe huŋgun aŋdo gewiap dâmaen are me siâ?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hain dâmbo Yesuŋe hin dâep, “Amâ gâŋe ya maktât are. Aregât ye hârok hin makyeŋgiwe. Ewenaet enemŋân manman aregât luâk akmâ geân nâ himbimânba hamandat kakŋân gem âmâ hârok damunyeŋe akbian. Ain âmâ nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hain dâmbo humoyeŋe arekŋe den are nâŋgâm biwiŋe kâlâp akto aregât ikiŋe sâŋgumŋe mem duwatmâ galalupŋe hin makyeŋgiep, “Bâin, siâŋe siâ siârâm akbiâ den âi humo membâen. ");
INSERT INTO tim_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Luâk ire âmâ Anutugât kotŋe mem bâlimbo nâŋgâen aregât ye gain gain nâŋgâi?” dâep. Hain dâmbo luâk âmbâle mendugum kili arekŋe Yesugât hin dâyi, “Emelâk bugâgât pat aktâp aregât moâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hain dâm enemŋân tâwutkoyi. Akto bikŋande ondopŋe kom hogom hin magaŋi, ");
INSERT INTO tim_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Anutuŋe huŋgun niŋdo geân dâmat aregât bunŋe akto amâ aregât kârikŋân konmâ ondopge hogoâp aregât kotŋe kon.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Akto Petoro iŋgon emet aregât ginŋân tato ainâk hoŋ âmbâle siâŋe ekmâ hin dâm magaŋep, “Gâ Yesu olop Galilaia hânân maliat are me?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hain dâmbo luâk hârok dewunyeŋân are bo nâŋgân dâm hin magep, “Nâ luâk kondât are bo nâŋgaŋdân. Akto den maktât aregât keiŋe bo nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hain dâm arim âmâ sombeim ginŋân kindo âmbâle siâŋe ekmâ luâk âmbâle ain kili are hin makyeŋgiep, “Woe, luâk ire amâ Yesu Nasarete gâtŋe yâk olop manmandat are.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hain dâmbo hin magep, “Nâ Anutugât meteŋân den bunŋe makgiŋdere nâŋgâ. Nâ luâk are bo nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hain dâm getek ba kindo luâk enemŋân kili arekŋe Petoro hin magaŋi, “Yesu âmâ Galilaia hânân gâtŋe. Gâ den maktât are âmâ Galilaiaŋe makmai han hainângen maktât aregât gâmâ Yesu olop mali areyeŋgâlân gâtŋe.” dâm magaŋi. ");
INSERT INTO tim_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hain dâmbiâ Petoroŋe kârikŋe akmâ hin dâep, “Woe, hinŋe heyeŋgiwerân âmâ benŋe Anutuŋe nugumbo momberân aregât makyeŋgire nâŋgâŋet. Nâ yeŋe luâk kotŋe kondâi are bo ekman.” dâep. Hain dâmbo arekŋeak gokorok indiep. ");
INSERT INTO tim_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Indembo nâŋgâm Yesuŋe den hin magaŋep are hanŋân ga miawagep, “Gâ gokorok bo indemboâk nâŋgâ yâk bo nâŋgâ aŋman dâmenâ âlâwu akbiap.” dâep are hanŋân ga togombo nâŋgâm dondâ indiep. ");
INSERT INTO tim_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Akto emet hauŋdo sumbe kat kat yeŋgât humoyeŋe akto Israe yeŋgât kâmiti arekŋe Yesu kombiâ mombiapgât den magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hain akmâ tâkŋe hikom mem kiap kotŋe Pilatogâlân ariyi. Ain arim waŋbiâ tembe lokolupŋande kala busi kâlegen kali. ");
INSERT INTO tim_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Akto luâk kotŋe Yudasi Yesugât gasa kewugu yekto meyi arekŋe Yesu kondenŋe moâk dâm kili are yekmâ hanŋe purik kato puli koaŋe 30 waŋi are mem purik katmâ arim sumbe kat kat yeŋgât humomo akto kâmiti hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nâŋe Yesu dosaŋe bo ina bâleŋe agaŋdere mem kombiâ momberâp aregât dosa humo aktân.” dâmbo hin magaŋi, “Maktât are amâ gâŋgât dosa aregât guge heŋgem guguwiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hain dâmbiâ biwiŋe bâlimbo puli koaŋe are sumbe kat kat emetŋân ain pando hânân gembo sopanmâ ari ikiŋe hikoagep. ");
INSERT INTO tim_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Akto sumbe kat kat luâk yeŋgât humomolupyeŋande puli koaŋe are pitim mem hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","“Puli ire amâ luâk moâkgât puli kat katŋe ina emet iregât katenŋe bo ârândâŋ akberâp. Aregât gain gain akberen?” dâm magaŋgi goaŋgi akmâ puli arekŋe luâk siâ umbâ ketugumap yâkgât kalam siâ puligoyi. Hân are puligom hin dâyi, “Hân ire amâ hin akbiap. Luâk kâlewângenba togom manmâ mombai are in hanyeŋguwaen.” dâmbiâ hain arekŋe bunŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hain akmâ hân aregât kotŋe Hepgât hân koli. Akto kot are hinŋe hainâk yendâp. ");
INSERT INTO tim_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hain aregât benŋe Anutuŋe ulikŋân makto Propete siâ kotŋe Yeremiaŋe hin kulemgoep, “Israe luâk siâ moâkgât puli koaŋe 30 gasaŋe waŋbai. ");
INSERT INTO tim_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Hain katbiâ puli are purik kato mem luâk siâ umbâ ketugumap yâkgât kalam puligowai. Are âmâ Humoŋe makniŋep.” dâm kulemgoep. Den are bunŋe miawakto sumbe kat kat luâk akto kâmiti arekŋe kalam are puligoyi. ");
INSERT INTO tim_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Akto sop ain Yesuŋe kiap kotŋe Pilato yâkgât enemŋân kindo hin aikoep, “Yuda yeŋgât luâk humoyeŋe are gâ me?” dâmbo hin dâep, “Amâ gâŋe ya maktât are.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Akto luâkŋe Yesu meyi arekŋe den aŋgâ aŋgâ hogom hâkŋân hâkŋân agi. Hain akbiâ den hâuŋe siâ bo makmâ yânâk kilep. ");
INSERT INTO tim_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hain akto Pilatoŋe Yesu hin magaŋep, “Nâŋgâ. Den aŋgâ aŋgâ hogom togo hâkgân hâkgân aktâi aregât gâ den hâuŋe siâ wangât bo makmâ kindât?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hain dâmbo Yesuŋe den hâuŋe bo makmâ yânâk kilep. Kindo Pilatoŋe den hâuŋe bo magep aregât nâŋgâmbo bimbiâk agep. ");
INSERT INTO tim_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Akto sop ain Pasowa hombaŋ aregât kala busi kâlegen gâtŋe aregât ukenyeŋaet akmâ kotŋe konbiâ are watmâ akminep. ");
INSERT INTO tim_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aregât Pilatoŋe nâŋgâm Yesu me bâleŋe luâk siâ kotŋe Baraba are watere yânŋângen ariâk dâm malep. ");
INSERT INTO tim_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Akto Pilatoŋe hingât nâŋgâm, “Sumbe kat kat are yeŋgât humomolupyeŋande, “Luâk âmbâle hârokŋe Yesugât kotŋe mem agatbiâ nengât kotnenŋe gewop.” dâm nâŋgâmbiâ bâlimbo aregât mem nâŋgâlân togoâi.” dâm nâŋgâm aregât hin makyeŋgiep, “Niŋe Baraba me Yesu Anutuŋe huŋgun aŋdo giep dâmai are watere yeŋgâlân geâkgât nâŋgâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Akto Pilatoŋe ainâk tatmâ den siâ siâ nâŋgâm heŋgemgom kilep ainâk âmbenŋande yâkgât den katmâ hin magep, “Nâ asiŋân giwet siâ Yesu ekmâ heŋgemgom hanoko aktân aregât Yesu dosaŋe bo are bâleŋe bo agaŋben.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A hârok nâŋgâm heŋgemgom tato âmâ sumbe kat kat are yeŋgât humomolupyeŋe kâmiti luâk âmbâle are hanyeŋân gem wâragi. Akto hin makyeŋgiyi, “Konmâ wârakbiâkâ Pilatoŋe Baraba hepundo gembo âkâ tembe lokolupŋande Yesu kombiâ moâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hain dâmbiâ Pilatoŋe lâuwâŋe hin makyeŋgiep, “Ye luâk lâuwâ ire yâk hutyetŋân niŋe hepundere geâkgât nâŋgâi?” dâmbo hin dâyi, “Baraba.” dâmbiâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Dâ Yesu Anutuŋe huŋgun aŋdo giep dâmai ire amâ gain agaŋberângât nâŋgâi?” dâmbo hârokŋe hin dâyi, “Lâwinân kombiâ moâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hain dâmbiâ hin makyeŋgiep, “Woe, keiŋe wangât akto bâleŋe wan agep aregât kombiâ moâk dâi.” dâep. Hain dâmbo hin dâyi, “Hanâk lâwinân kombiâ moâk.” dâm wâragi. ");
INSERT INTO tim_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoŋe mem mulunyekto den gulip milip dondâ akbiâ ekmâ nâŋgâm dâmbo tu hâgâm waŋbiâ yâk yeŋgât dewunyeŋân bâtŋe pulim hin magep, “Luâk dosa bâlâk manmap iregât dosaŋe nâŋgâlân bo hâtikowiap. Yeŋeak heŋgemgoŋet.” ");
INSERT INTO tim_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hain dâmbo dâyi, “Kombiâ momberâp aregât dosa amâ nengâlân akto nengât nan baratlupnenŋe yeŋgâlân miawakmâ âgâwiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hain dâmbiâ Pilatoŋe Baraba hepundo yâk yeŋgâlân giep. Dâ tembe loko makyeŋgimbo Yesu âmâ bugâŋe kombiâ hâk hilâlâm nâŋgâmbo lâwinân kondenŋe moâk dâm mem ariyi. ");
INSERT INTO tim_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Akto tembe lokoŋe Yesu mem kiap humogât kala busi kâlegen mem âgâyi. Mem âgâm tembe loko hârogâk yeŋgonbiâ togoyi. ");
INSERT INTO tim_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Togombiâ den hembalik mâŋgim hin dâyi, “Woe, luâk humo.” dâm giriŋaŋmâ sâŋgum gilâm siâ luâk kembuŋe lalakmai hain are lalaŋmâ ");
INSERT INTO tim_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","tâk dâtâ dâtâ siâŋe irimut ketugum kautŋân kauŋaŋi. Akto kâro siâ bâtŋe bungen katbiâ miep. Hain mendo togo enemŋân pâwutyeŋe ligim katmâ hin dâyi, “Woe, Yuda yeŋgât luâk kembuyeŋe.” dâm hiaŋgim giriŋaŋi. ");
INSERT INTO tim_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hain dâm tâwutkom kâro arekŋe kautŋân oreyi. ");
INSERT INTO tim_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hain akmâ sâŋgum gilâm are hiloŋmâ ikiŋe sâŋgum lalaŋmâ lâwinân komberâm mem ariyi. ");
INSERT INTO tim_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mem arim dâwân luâk siâ egi are kotŋe Simoŋ Kirene hânân gâtŋe wârakmâ tatbiâ Yesugât lâwin are lokombo ariyi. ");
INSERT INTO tim_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Arim hân siâ kotŋe Goligata aregât den purikŋe âmâ kaut hagitŋe ain ariyi. ");
INSERT INTO tim_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Arim âmâ waiŋ akto biwi gulip tu kâim mendugum waŋbiâ getek nem nâŋgâm borâep. ");
INSERT INTO tim_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Akto lâwinân kom mem anuŋbiâ kindo sâŋgumŋe memberâm kotyeŋe kulemgom kotyeŋe umbân panbiâ gembo bâtyeŋe panbiâ gembo kot siâ mem oloŋbiâ luâk kotŋe miawagep arekŋe Yesugât sâŋgum are meyi. ");
INSERT INTO tim_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Akto ain tatmâ Yesugât damun kili. ");
INSERT INTO tim_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Akto kom kautŋân lâwin ulikŋân kulem kulemgoyi aregât keiŋe hin, “Ire âmâ Yuda yeŋgât luâk kembu.” ");
INSERT INTO tim_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Akto bugâ koko kâmburâ lâuwâ siâ Yesugât gasomŋe biken biken lâwinân yetkuyi. ");
INSERT INTO tim_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Akto luâk âmbâle gam ariyi arekŋe Yesugât den hilit balit agaŋmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Woe, gâŋe hin dâmat, “Sumbe emetŋe gagaim hilâm âlâwu kâlegen lâuwâŋe ketuguwian.” dâmat aregât kârikŋe akmâ lâwinânba ge. Gemenâ benŋe gâ bunŋe Anutugât nanŋe dâweren.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Akto sumbe kat kat are yeŋgât humomolupyeŋe akto Mosegât den kârikŋe makyeŋgimini arekŋe hainâk den hilit balit agaŋmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Luâk aŋgâ âmâ tân yeŋgumap. Dâ ikiŋe âmâ wangât bo tânaguâp? Akto Israe nengât kembu dâmap inarekŋe lâwinânba gembo ekmâ amâ den are bunŋe dâm nâŋgâweren. ");
INSERT INTO tim_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Akto, “Nâmâ Anutugât nanŋe aregât tân nuguwiap nâŋgân.” dâmap aregât Anutuŋe tângombo lâwinânba gembo bunŋe dâweren.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hain dâmbiâ luâk bâleŋe lâuwâ biken biken lâwinân yetkum hikoyelegi areâkâ hainâk den bâleŋe magaŋiat. ");
INSERT INTO tim_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Akto hilâm tânâmŋân ainâk hândâk humo dâgâm yendo eŋgaiŋe agep. ");
INSERT INTO tim_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Eŋgaiŋe akto Yesuŋe ikiŋaet denân kot hin kolep, “Eli Eli lama sabaktani?” dâep. Aregât purikŋe amâ, Humone wangât hepun nektât? ");
INSERT INTO tim_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Akto luâk kili bikŋande den are nâŋgâm hilip koyi aregât hin dâyi, “Âure nâŋgâŋet. Elia kondâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hain dâmbiâ siâŋe pârigim arim sâŋgum papaŋe siâ kâroân bigeim bigeim waiŋ ŋasukŋân panmâ mem neâk dâm Yesugât lauŋân katmâ kilep. ");
INSERT INTO tim_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hain akto galalupŋande hin magaŋi, “Hepun. Eliaŋe bunŋe himbimânba gem tângombo lâwinânba gewerâp me bo aregât ekmâ kinne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hain dâmbiâ Yesuŋe lâuwâŋe kârikŋeâk kamboŋmâ ainâk moep. ");
INSERT INTO tim_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mondo ainâk sâŋgum sumbe kat kat emetŋân kinminep ina tânâmŋânba duwalakmâ hâreagep. Hain akto wâriŋ humo mendo kât humomo hogo agep. ");
INSERT INTO tim_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Akto sum bikŋe kepik akto Anutugât luâk âmbâle ulikŋân moyi are yeŋgâlânba dondâŋe agatmâ bam guli. ");
INSERT INTO tim_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sum hepunmâ agatmâ âmâ benŋe Yesu agalep sop ain Yerusalem kepian arimbiâ luâk âmbâle dondâŋe yegi. ");
INSERT INTO tim_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Akto Yesu moep sop ain tembe loko humoyeŋe siâ akto Yesu damunŋe akmâ kili arekŋe wâriŋ humo are nâŋgâm akto wan me wan miawagep are ekmâ hamep keirâk akmâ hin magi, “Woe, luâk ire amâ Anutugât nanŋe bundâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Akto âmbâle bikŋe ain kili arekŋe getek kâlewânâk kinmâ egi arekŋe Galilaia hânânba Yesugât hoŋ bawa akbiâ olop mali. ");
INSERT INTO tim_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Areyeŋgât hutyeŋân gâtŋe amâ kotyeŋe hin, Maria Madala kepian gâtŋe akto Maria siâ âmâ Yakobo siâ akto Yose yâk yetgât memeyetŋe akto âmbâle siâ Sebedaiogât nanlogâtŋe yetgât memeyetŋe. ");
INSERT INTO tim_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Akto emet dâgâwerâm akto puli sikumdâ luâk siâ Yesu nâŋgaŋmai yeŋgâlân gâtŋe Arimataia kepian gâtŋe kotŋe Yosepe are togoep. ");
INSERT INTO tim_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Arekŋe togom Pilato hin aikoep, “Gain nâŋgât? Yesugât hâkŋe mem arim hangowerân. Âlepŋe me?” dâmbo Pilatoŋe âlepŋe dâm tembe loko makyeŋgimbo bam Yesugât hâkŋe lâwinân ba mem gutmâ Yosepe waŋi. ");
INSERT INTO tim_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Waŋbiâ mem bam sâŋgumŋe kau kau siâ mem Yesugât hâkŋe are katipkoep. ");
INSERT INTO tim_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Hain akmâ mem ari kât dâpŋe parâ parâ siân Yosepeŋe mondere in han nuguwai dâm kendâep ain katmâ kât humo siâŋe hâkokombo tigiep. Hain hâkokombo tigimbo Yosepe Arimataia gâtŋe ariep. ");
INSERT INTO tim_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Akto Maria Madala gâtŋe akto Maria siâ are olop Yosepeŋe Yesu kât dâpŋân kato talep ain taliat. ");
INSERT INTO tim_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Akto emet hauŋdo Sarere akto sumbe kat kat are yeŋgât humomolupyeŋe akto Parisaio luâk arekŋe Pilatogâlân ariyi. ");
INSERT INTO tim_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Arim hin magaŋi, “Humonenŋe, Yesugât ulit giŋdenŋe gain nâŋgât? Yesu hiaŋgi luâk arekŋe malep sop ain den siâ hin magep, “Nugumbiâ mondere han nugumbiâ hilâm âlâwu akto ain âmâ momoŋânba golâ akmâ agatbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hain gârâmâ gâŋe tembe lokolupge bikŋe makyeŋgimenâ sum dâpŋe are gisapkom heŋgemgombiâ kindo hilâm âlâwu bo akbiap. Ageine hoŋ bawalupŋande togo hâkŋe are lokom ari siângen hangom luâk âmbâle makyeŋgim, “Emelâk sumânba agalep.” dâmbiâ sum pum are ekmâ bunŋe dâmbiâ hiaŋgi den arekŋe sambelem arim âmâ ulik gulik ewangiwop.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hain dâmbiâ Pilatoŋe hin makyeŋgiep, “Yeŋe nâŋgât tembe lokolupne bikŋe meyekbiâ arim yeŋeak maktâi hain akmâ sum dâpŋe are tigim golâk tatmâ damunŋe akmâ kinbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Akto arim sum dâpŋe are tigim heŋgemgombiâ tembe loko bikŋe kât aregât damun kili. ");
INSERT INTO tim_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Akto Sarere bo akto emet hauŋdo Sonda hândâktâk Maria Madala gâtŋe akto Maria siâ arekŋe sumângen ariyiat. ");
INSERT INTO tim_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Akto ainâk wâriŋ humo miep. Akto Humogât aŋelo siâŋe himbimânba gem kât humo are hâkokombo arimbo âgâ kakŋân talep. ");
INSERT INTO tim_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Akto aŋelo aregât enem dewunŋe pagaleŋe akto sâŋgumŋe kau kau hainare agep. ");
INSERT INTO tim_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hain akto tembe loko ain kili arekŋe yâkgât hamewakmâ ongâyeŋe hogombo sân sân mem ge hân tete luâk momoŋande yemai hain yeyi. ");
INSERT INTO tim_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Akto aŋelo arekŋe âmbâle lâuwâ are hin makyetkiep, “Yet âmâ bo hamep aget. Yet Yesu lâwinân koyi are ekberâm togoatgât nâŋgân. ");
INSERT INTO tim_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yâk in bo yendâp. Yâk ulikŋân magep hain akmâ emelâk agatâp. Yet gutmâ gewâkŋe ire eget. ");
INSERT INTO tim_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ire ekmâ nâŋgâm heŋgemgom âmâ benŋe dowâk arim hoŋ bawalupŋe iregât makyeŋgiet. Akto siâ hin makyetkire nâŋgâet. Yâk emelâk Galilaia hânân yâkŋe soŋ ariwerâm ariâp gârâmâ ye aregen arim ekbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hain dâmbo âmbâle lâuwâ arekŋe hamep agiat. Dâ biwiyetŋande heroŋe humo agiat. Hain akmâ sum are hepunmâ hoŋ bawalupŋe makyeŋgiwerâm pârigim kepiangen ariyiat. ");
INSERT INTO tim_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Akto Yesuŋe dâwân yelekmâ hin makyetkiep, “Âmbâi lâuwâ.” dâep. Akto âmbâi lâuwâ arekŋe enemŋân bam ge hânân tatmâ keiŋân mem heroŋe agiat. ");
INSERT INTO tim_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hain akbela Yesuŋe hin makyetkiep, “Yet bo hamewakmâ âmâ arim nâŋgât galalupne are makyeŋgimbela Galilaia hânân ariwei. Arimbiâ nâmâ ain arire nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akto âmbâi lâuwâ are dâwân arim manbela tembe loko sum damunŋe kili arekŋe kepia humoân ariyi. Arim wan me wan miawagep aregât den pat are sumbe kat kat luâk yeŋgât humomolupyeŋe are makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Akto sumbe kat kat yeŋgât luâk humomolupyeŋe akto kâmiti luâk arekŋe yeŋeâk mendugum den magaŋgi goaŋgi akmâ tembe loko are puli dondâ yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hain akmâ hin makyeŋgiyi, “Ye âmâ hin makbei, “Nen asiŋ pâlâmŋe yem mandenŋe Yesugât hoŋ bawalupŋande hândâgân togom hâkŋe are petâm lokom ari siângen hangoyi.” dâwei. ");
INSERT INTO tim_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dâ kiap Pilato arekŋe den ire nâŋgâmbo âmâ nenŋe den siâ magaŋdenŋe ye hin me hain bo akyeŋgiwiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hain dâmbiâ tembe loko arekŋe puli mem yâkŋe den makyeŋgiyi are watmâ hain agi. Akto den pat hiaŋgi arekŋe Yuda luâk yeŋgâlân sambelem metiep. Aregât Yuda luâkŋe den are hinŋe hainâk makmâ manmai. ");
INSERT INTO tim_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Akto hoŋ bawalupŋe keiân konok yeŋeâk Galilaia hânân ariyi. Arim gimbâŋe siâ ain togowei dâm Yesuŋe tirip katyeŋgiep gimbâŋe ain togoyi. ");
INSERT INTO tim_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Togom Yesu ekmâ heroŋe agi. Bikŋande nâŋgaŋmâ âmâ kotŋe konmâ nâŋgâmbiâ humo agep. Dâ yâk yeŋgât bikŋande âmâ nâŋgâ nâŋgâyeŋe lâuwâ âlâwu agep. ");
INSERT INTO tim_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Akto Yesu enem yeŋân gutmâ kinmâ hin makyeŋgiep, “Anutu Ewenande meme akniŋdo hân himbim me wan me wan hârok damunyeŋe akmâ manmâ âgâwian. ");
INSERT INTO tim_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aregât ye arim luâk âmbâle hârok hânŋe hânŋe manbai are makyeŋgimbiâ bikŋande biwiyeŋe nâŋgâlân katbai are mem tuân katyekbei. Ewene akto nâ akto Heak nen konokgât akten aregât kotnenŋe konok are konmâ tuân katyekbei. ");
INSERT INTO tim_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hain akmâ benŋe wan me wan den kârikŋe makyeŋgiân are hârok makmâ miawakmâ metewei. Dâ âi ire âlepŋe agâkgât nâŋe hokboâk hokboâk tânyeŋguwian. Hain akmâ tân yeŋgum manmâ âgâre sop bo akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kristo Anutugât nanŋe yâkgât den pat âlepŋe aregât keiŋe amâ hin. ");
INSERT INTO tim_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Propete siâ kotŋe Yesaia, yâkŋe den hinâk kulemgoep, Nune hoŋ bawane magaŋmâ huŋgun aŋdere laune lokom gâŋgât ulikŋân akgiŋmâ dâp heŋgemgo giŋbiap. ");
INSERT INTO tim_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hân pumângen manmâ luâk hin makyeŋgim manbiap, “Kembu Humo togowiapgât dâp megatbei. Gimbâŋe ukuleŋe me kundet kokoŋe hâgâm kigilikmâ ârândâŋ ketugumbiâ dâp huraguâk.” Yesaiaŋe hain kulemgoep aregât bunŋe akto Yohane togoep. ");
INSERT INTO tim_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Togom tuân katyekberâm keiŋe katmâ hân pumângen arimbo luâk âmbâle togombiâ hin makyeŋgiep, “Bâleŋeyeŋe makmâ miawakbiâ âmâ Humoŋe are ekmâ dosayeŋe bo akyeŋgiâk dâmbo bo akyeŋgimbo tu puli yeŋgiwe.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hain dâmbo hân humo siâ kotŋe Yudaia aregât ambolupŋe dondâ akto kepia siâ kotŋe Yerusalem are ambolupŋe dondâ arekŋe yâkgâlân togom bâleŋeyeŋe makmâ miawakbiâ Yohaneŋe Yodaŋ tuân katyegep. ");
INSERT INTO tim_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane hâk pekeŋe yo hâkŋe akto tâkŋe pâŋân lalagep akto sotŋe kendemuŋ akto mumak koaŋe neminep. ");
INSERT INTO tim_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hain akmâ hin dâminep, “Hâmbâi luâk siâ togom penâniŋdo nâ yânŋe akmâ yâkgât ito goliaŋdere ârândâŋ bo akbop. ");
INSERT INTO tim_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Akto nâŋe âmâ tu yânŋe puli yektân. Dâ yâkŋe âmâ Heakŋe magaŋdo kaut yeŋân meyekbiap.” Yohaneŋe Humogât hain dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sop ainâk Yesu Nasarete kepianba Galilaia hânân togombo Yohaneŋe Yodaŋ tuân mem puliep. ");
INSERT INTO tim_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hain akto Yesuŋe tu hepunmâ gambo âmâ ainâk himbim dâpŋe pâroŋ âgâmbo Anutugât Heakŋe arekŋe kembâ akmâ gem gem Yesugât kautŋân mendo egep. ");
INSERT INTO tim_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Akto himbimânba Anutuŋe hin magaŋep, “Gâ nâŋgât nanne, nâŋe gekmâ ukenŋe aktân. Akto biwine heroŋe aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Himbimânba den hain dâmbo ainâk Anutugât Heakŋande Yesu kewugumbo hân kamitŋângen ariep. ");
INSERT INTO tim_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Arimbo ain hândâk hilâm 40 mando sinduk baniara bâleŋe areyeŋgât humo yeŋe arekŋe bâliâk dâm magaŋmâ biwiŋe dop kom hiaŋgiep. Hiaŋgim mando Yesuŋe kârikŋe akmâ malep. Kârikŋe akmâ halângen yo yeŋgât hânân mando aŋelo arekŋe tângoyi. ");
INSERT INTO tim_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Akto Yohane kala busi katbiâ mando âmâ Yesuŋe Galilaia hânân togom Anutugât den pat âlepŋe are makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Anutuŋe damunyeŋe akbiapgât sop tâlâguâp aregât bâleŋeyeŋe makmâ miawakmâ hamiaŋmâ den pat âlepŋe ire nâŋgâŋet.” hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Den heroŋe are makmâ bam arim Galilaia bâtgum ginŋân arim luâk emi teu lâuwâ Anderea akto Simoŋ yelegep. Yâk iŋan âi meme luâk aregât bâtgumân ŋalu ŋalu yetŋe panmâ kiliat. ");
INSERT INTO tim_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Âi are mem kinbela Yesuŋe hin dâm makyetkiep, “Gaet. Gambela nâ olop manne. Iŋangât âi mem mandat are hepunbela nâŋe luâk yeŋgâlân âi membiandatgât âi hekat yetkiwe.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ainâk âi are hepunbela Yesu olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Akto Yesuŋe baine luâk kotŋe Yeweri aregât nanlogâtŋe Yakobo akto Yohane kinbela yelegep. Yelekto yâk waŋgan tatmâ iŋangât ito yetŋe hâreagep are parutmâ heŋgemgom tatbela yelekmâ yetkolep. ");
INSERT INTO tim_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yetkondo nâŋgâm eweyetŋe Sebedaio are akto âi luâklupŋe waŋgan tatbiâ hepun yekmâ Yesu olop manbaet dâmbela Yesu olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Akto yâkŋe Kapanaum kepian arimbiâ hilâm âi bo meme sopŋe Sarere akto Yesuŋe kepia aregât den opmânŋân âgâmbo hoŋ bawalupŋe akto kepia ambolupŋe âgâmbiâ den pat âlepŋe are makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Makyeŋgimbo luâk âmbâle arekŋe nâŋgâm bâtyeŋe dâtyeŋân igim kinmâ hin dâyi, “Nengâlân gâtŋe den kârikŋe hekat nengi nengi luâkŋe maknengimbiâ âmâ nâŋgâenŋe porap porap akmap. Dâ den amboŋe irekŋe âmâ maknengimbo nâŋgâenŋe ârândâŋ aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hain dâm kinbiâ den opmânân are luâk siâ sinduk baniara bâleŋande mâŋgiep siâŋe kamboŋmâ hin dâep, ");
INSERT INTO tim_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu Nasarete kepian gâtŋe gâŋgât patge nâŋgân. Gâ Anutugât luâk âlepŋe manmat. Anutuŋe huŋgun giŋdo togoen gârâmâ hilip nenguwerâm togoen mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hain dâmbo Yesuŋe sinduk baniara bâleŋe are hin magaŋep, “Den bo ak. Luâk ire hepunmâ ari.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","sinduk baniara arekŋe kamboŋmâ luâk are hâkŋe humoâk mem duwuŋ ketugum panmâ hepunmâ ariep. ");
INSERT INTO tim_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Arimbo luâk âmbâle den opmânŋân tali arekŋe ongâyeŋe hogombo magaŋgi goaŋgi akmâ hin dâyi, “Yei, imâ wan arekŋaet siâ? Imâ pat âlep den keiŋe aŋgâ. Luâk irekŋe kârikŋeŋe olop sinduk baniara bâleŋe makyeŋgimbo arekŋe gai lauŋe lokomai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hain dâm aregât luâk âmbâle hârokŋe magaŋgim arimbiâ Yesugât pat arekŋe sambelem Galilaia hân hârok ârândâŋ agep. ");
INSERT INTO tim_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Akto den opmânŋânba gem Yakobo akto Yohane olop arim âmâ ainâk Simoŋ akto Anderea yetgât emelan âgâyi. ");
INSERT INTO tim_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Akto Simoŋgât hewonŋe hâkŋe kâlâp akto kundat humo akmâ yiep. Hain akmâ yendo ainâk Yesu aregât magaŋi. ");
INSERT INTO tim_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Magaŋbiâ Yesuŋe ba bâtŋân mem agalep. Hain akto ainâk hâkŋe sândugembo kundat hepundo sot om yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Emet dâgâmbo kepia ambolupŋande kundatdâ me sinduk baniara bâleŋande meyegi are meyekmâ arim ");
INSERT INTO tim_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yesuŋe emet talep aregât hâŋgi ginŋân mendugu yekmâ kili. ");
INSERT INTO tim_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Akto Yesuŋe kundatdâ keiŋe keiŋe mem âlepŋe ketuguyegep. Akto luâk sinduk baniara bâleŋande meyekmai are sinduk yeŋe watyekto ariyi. Sinduk baniaraŋe yâkgât keiŋe nâŋgâyigât makbâi aregât makmâ hâreyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Akto emet boâk hauŋdo hândâkŋân Yesu agatmâ kepia are hepunmâ hân pumângen arim Anutu magaŋep. ");
INSERT INTO tim_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Magaŋdo Simoŋ galarâŋe agatmâ ekbiâ bo akto yâgâten ariâp dâm undâgâlaŋmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Arim ekmâ, “Luâk âmbâle biwirâŋe undâgât giŋdâi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hain dâmbiâ hin makyeŋgiep, “Nâŋe den âlepŋe makyeŋgiwerâm aktere kepia siâ siâ ewumâk ewumâk ariwaen. Nâ âi ire memberâm togoân aregât kepia ewumâk ewumâk ariwaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Akto Galilaia hân humo aregât kepia hârok manmâ den opmânŋe ârândâŋ âgâm den pat âlepŋe are mem makyeŋgim malep. Hain manmâ sinduk baniara bâleŋe watyekmâ malep. ");
INSERT INTO tim_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Luâk diwi kârikŋe miawagaŋdo malep siâŋe Yesugâlân arim pâwutŋe ligim katmâ ulilaŋmâ hin dâep, “Yesu gâŋe kundatdâ yekmâ âlepŋe akŋet dâmenâ âlepŋe akmai. Aregât nâŋgât gain gain nâŋgât?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Hain dâmbo Yesuŋe han kalem bâtgumŋaet akmâ okotŋe nâŋgâm bâtŋe hâkŋân katmâ hin magaŋep, “Nâŋgâ giŋdân aregât diwige pandagâk.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ainâk diwiŋe pandakto hâkŋe âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Akto ainâk luâk are huŋgunaŋmâ hin magaŋep, “Nâŋgât? Gâŋe iregât pat bo makyeŋgiwen. ");
INSERT INTO tim_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Dâ Moseŋe hin dâep, “Gâŋgât kundat bo akto sumbe kat kat luâk gâlân arimenâ gekmâ diwige emelâk pandak giŋdâp aregât sumbe o dâm makgiŋdo soŋgo waŋmenâ ombiap. Akto ainba luâk âmbâle hârok sumbe kat kat luâk arekŋe makyeŋgimbo nâŋgâmbiâ âmâ hutyeŋân âlepŋe manben.” Moseŋe hain dâep aregât den are lokowen. Akto diwi bo akgiŋdâp aregât pat bo makyeŋgiwen.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hain dâep are bonâŋgâm arim makyeŋgim malep. Makyeŋgimbo den arekŋe sambelem ariep. Ariepgât Yesuŋe kepia humoân arimbo luâk âmbâle dondâ gam turuŋ aŋbiâ, “Gain gain akbian.” dâm aregât kepia tuŋguŋângen malep. Akto ain luâk âmbâle bikenba bikenba Yesugâlân togoyi. ");
INSERT INTO tim_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesuŋe hilâm siân purik katmâ Kapanaum kepian arim emetŋân âgâep. Akto yâkgât den pat arekŋe sambelem arimbo kepia aregât ambolupŋande nâŋgâm yâkgâlân togoyi. ");
INSERT INTO tim_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Togom luâk âmbâle dondâŋe emet kâlegen tatmâ hâŋgi gisapkoyi. Hain akbiâ den pat âlepŋe are makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Akto luâk imbât akmâ luâk siâ kei bâtŋe kârigem agep are lokom luâk bikŋe olop togoyi. ");
INSERT INTO tim_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lokom togo luâk âmbâle dondâŋe enemŋân kinbiâ yekmâ lokom tirekŋânba emet bokŋân gam âgâyi. Âgâm Yesuŋe emet talep are bokŋe gagaimbiâ dâpŋe miawakto arewa temdâk katbiâ giep. ");
INSERT INTO tim_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Enemŋân gembo biwiyeŋe yâkgâlân kali aregât nâŋgâm hin magaŋep, “Gala gâŋgât dosa bo aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hain dâmbo luâk Mosegât den kârikŋe makmâ kepigi arekŋe magaŋgi goaŋgi akmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Luâk ire wangât hain maktâp? Anutuŋe konok âmâ dosa pulimap. Anutugât kot bâliwopgât den are hepulâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hain dâmbiâ den are nâŋgâm âmâ hin makyeŋgiep, “Wangât biwiyeŋân hain nâŋgâi? ");
INSERT INTO tim_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gain gain arekŋe owâiŋe? Luâk bâleŋe hin dâm magaŋberân, “Dosage puligiŋdere Anutuŋe hâuŋe bo giŋbiap.” hain dâm me hin dâm magaŋberân, “Agatmâ tem tâkge are hulaŋmâ loko akmâ ari.” ");
INSERT INTO tim_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aregât maktere nâŋgâŋet. Nâ luâk akmâ geângât dosayeŋe hepunyeŋgiwiangât Anutuŋe dâm niŋep aregât keiŋe ekmâ nâŋgâŋet.” dâep. Hain dâm benŋe luâk miwindik akmâ yiep are hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nâ makgiŋdere nâŋgâ. Gâ agatmâ tem tâkge are hulaŋmâ loko akmâ emetgân ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hain dâmbo tem tâk are lokoakmâ emetŋân ariep. Akto luâk âmbâle ain kili arekŋe ekmâ bâtyeŋe dâtyeŋân igim hin dâyi, “Wei, Anutu konok âlep âlepŋe dondâ akmap. Nen ire bo ekmaen ina uŋak konok pup pup ekten.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuŋe bâtgum humo ginŋân giep. Gembo luâk âmbâle hârok Yesu ekberâm gembiâ Anutugât den pat âlepŋe are makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Benŋe ainba arim luâk siâ kotŋe Lewi Alipaiogât nanŋe arekŋe gawaman yeŋgât puli emetŋân tato Yesuŋe magaŋmâ hin dâep, “Nâ olop manbaetgât gamenâ arire.” dâep. Akto Lewiŋe puligât âi hepunmâ puli emetŋânba gembo Yesu olop ariyiat. ");
INSERT INTO tim_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuŋe kewuguyekto arim Lewigât emelan tatmâ Yesu akto hoŋ bawalupŋe sot neyi. Akto sop ain puli meme luâk bikŋe akto luâk bâleŋe meme siâ hainâk olop Yesu olop tatmâ sot neyi. Amâ luâk âmbâle biwirâ watmâ maligât. ");
INSERT INTO tim_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Akto Anutugât den hekat yeŋgi yeŋgi luâk bikŋe kotyeŋe Parisaio bikŋande Yesuŋe puli meme luâk akto luâk bâleŋe hutyeŋân tatmâ sot nendo ekmâ Yesugât hoŋ bawalupŋe hin dâm makyeŋgiyi, “Wangât humoyeŋande dosa luâk akto puli meme luâk are yeŋgât hutyeŋân tatmâ sot nendâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hain dâmbiâ Yesuŋe den are nâŋgâm Parisaio luâk are hin makyeŋgiep, “Luâk âlepŋande dokta yeŋgâlân bo arimai. Luâk kundatdâŋe amâ dokta yeŋgâlân arimbiâ heŋgem yeŋgumbiâ âlepŋe akmai. Akto nâ hainâk luâk nen dosanenŋe bo dâm mandâi are âmâ hepunyekman. Dâ luâk bâleŋe meme akto dosayeŋe olop are âmâ heŋgem yeŋguwerâm geân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Akto sop ain Yohanegât hoŋ bawalupŋe akto Parisaio luâk yâkŋe Anutu maŋganminigât sot bâlâk yân mali. Akto luâk bikŋande Yesugâlân togom hin dâm magaŋi, “Yohanegât hoŋ bawalupŋe akto Parisaio luâk yâkŋe Anutu kambiamŋe âlepŋe agâkgât sot bâlâk manmai. Dâ gâŋgât hoŋ bawalupgande âmâ hilâm ârândâŋâk sot nemâk manmai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Luâk siâ âmbâle membiapŋe galalupŋe olop hero âlepŋe manmai aregât galalupŋe okot âlep akyeŋgim sot ondo nemai. ");
INSERT INTO tim_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sot om nem heroŋe akmâ manbiâ gasalupŋande galayeŋe are membiâ kulâgâlaŋbiâ bo akto âmâ galalupŋande biwi bâle akmâ sot bâlâk manmai. ");
INSERT INTO tim_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nen sâŋgum tâmbâŋe tokto dâpŋe humo akbop dâm sâŋgum irakŋe bo puli puliŋe are katmâ bo parutmaen. Hain akmâ dâine tuân pulienŋe irakŋande gâwigem tâmbâŋe are oloŋdo tokto dâpŋe humo dondâ miawakbop. ");
INSERT INTO tim_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Akto nen âmâ waiŋ tu irakŋe yo hâkŋe tâmbâŋân bo kâienŋe gemap. Hain akmaen dâine waiŋ tuŋe arekŋe yo hâkŋe tâmbâŋe are mendo bim âgâm hogoakbop. Akto waiŋ akto soŋgo hâkŋe lâuwâ lâuwâ bâliwat. Aregât waiŋ irakŋande yo hâkŋe irakŋân gembo âlepŋe akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Âi bo meme sopŋe Sarere siân Yesu akto hoŋ bawalupŋe âi kalam hutŋânba ariyi. Arim hoŋ bawalupŋande seŋgo konok konok mem nem arim manbiâ ");
INSERT INTO tim_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisaio luâkŋe yekmâ Yesu hin magaŋi, “Ek, hoŋ bawalupgande âi bo meme sopŋân siâ me siâ bo agakgât âi are akbiâ ârândâŋ bo aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hain dâm hâwâtbiâ Yesuŋe hin makyeŋgiep, “Anutuŋe makto kulemgoyi yendâp are siâ oyaŋmâ nâŋgâmai me bo? Ulikŋân sumbe kat kat luâk areyeŋgât humoyeŋe kotŋe Ambiata malep, ");
INSERT INTO tim_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","sop ain Dawidiŋe Anutugât sumbe kat kat emetŋân âgâm sotgât momberâm akto Abiataŋe sot kâmbokŋe waŋdo niep. Akto bikŋe hoŋ bawalupŋe yeŋgimbo neyi. Akto sot are âmâ sumbe kat kat luâk arekŋeak nemini. Dâ luâk yânŋe me Anutugât opmânân bo âgâmini arekŋe âmâ sot are bo nemini. ");
INSERT INTO tim_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aregât hin nâŋgâŋet. Anutuŋe hilâm iregât luâk ketugum hilâm ire tângoŋet bo dâep. Anutuŋe luâk heroŋe akŋet dâm aregât hilâm ire makmâ kalep. ");
INSERT INTO tim_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Akto luâk akmâ geân nâŋe Sarere âi bo meme sopŋe aregât kautŋe akmâ mandân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuŋe Sarereân den opmânŋân âgâm luâk bâtŋe bâleŋe siâ ain tato egep. ");
INSERT INTO tim_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Âgâmbo luâk kotyeŋe Parisaio arekŋe ekmâ magaŋgi goaŋgi akmâ hin dâyi, “Yesu denân katbaengât gain gain akmâ keiŋe ekne. Dâ luâk bâtŋe bâleŋe indâre magaŋdo âlepŋe akto ekmâ âmâ Sarereân âi mendâpgât dâm denân katbaen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dâmbiâ âmâ Yesuŋe luâk bâtŋe bâleŋe are hin dâm magaŋep, “Agatmâ dewunyeŋân kin.” dâmbo agatmâ kindo ");
INSERT INTO tim_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Parisaio are hin makyeŋgiep, “Moseŋe den kulemgoep are gain gain tatâp? Hombaŋ sopŋân âlepŋe akbei dâep me bâleŋe akbei dâep? Me luâk mem heŋgem yeŋguwaen dâep me hilip yeŋguwaen dâep?” dâm makyeŋgimbo denyeŋe nâŋâk kili. ");
INSERT INTO tim_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kinbiâ hanyeŋe kârikŋe agep aregât biwiŋe umatŋe akto purik gurik akmâ luâk are yekmâ peiyekmâ luâk bâtŋe bâleŋe are hin magaŋep, “Bâtge panmenâ agalâk.” dâmbo pando âlepŋe akmâ agalep. ");
INSERT INTO tim_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Agato Parisaio luâkŋe arim humoyeŋe kotŋe Herote yâkgât tembe lokolupŋe olop mendugum hin magaŋgiyi, “Nen gain gain akmâ Yesu kondenŋe mombiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuŋe hoŋ bawalupŋe meyekto Galilaia bâtgum dâtŋângen ariyi. Arimbiâ Galilaia hânângenba luâk dondâ Yesugât den nâŋgâyigât eknerâm togoyi. ");
INSERT INTO tim_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Togom luâk dondâ siâ siâ Yudaia hânângenba akto Yerusalem kepianba akto Idumaia hânângenba akto Yodaŋ tu bikenba akto kepia lâuwâ kotyetŋe Tiro akto Sidoŋ aregenba luâk âmbâle dondâ yâkgâlân togoyi. ");
INSERT INTO tim_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Hârok togom mendugum kinbiâ Yesuŋe emelâk luâk âmbâle dondâ heŋgem yeŋguep aregât luâk âmbâle dondâŋe howaim âlepŋe akberâm togoyi. Togom papalakmâ kombâigât waŋga are membiâ gutmâ enemŋânâk kilâkgât hoŋ bawalupŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Makyeŋgimbo sop ain sinduk baniara arekŋe togo ekmâ hânân gem kârikŋeâk konmâ hin dâyi, “Gâ Anutugât nanŋe.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ainâk kârikŋeâk konmâ den yeŋguep. Den yeŋgum hin makyeŋgiep, “Ya maktâi are lâuwâŋe bo makbei. Patnande sambelewopgât bo makyeŋgiwei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Akto Yesuŋe gimbâŋân âgâwerâm akto luâk âmbâle dondâ olop âgâyi. Akto Yesuŋe hoŋ bawalupŋe bikŋe nunaet dâtâŋe dâm yeŋgonlep. Yeŋgondo enemŋân ba tali. ");
INSERT INTO tim_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ba tatbiâ âmâ ikiŋe olop manbaigât akto huŋgunyeŋgimbo den patŋe makyeŋgimbiâ nâŋgâwaigât yeŋgonlep. ");
INSERT INTO tim_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Akto sinduk baniara bâleŋe watyeŋgiwerâm manbaigât luâk keiân lâuwâ meyegep. ");
INSERT INTO tim_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Amâ kotyeŋe hin. Simoŋ kotge irakŋe gogonbe dâm Petoro dâm kolep. ");
INSERT INTO tim_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Akto Sebedaio nanlogâtŋe kotyetŋe Yakobo akto Yohane, kârikŋe akmandatgât kotyetŋe Boanerges yetkolep aregât purikŋe amâ himbim kururuŋdâp. ");
INSERT INTO tim_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderea, Pilipo, Batolomaio, Mataio, Toma, akto Alipaiogât nanŋe kotŋe Yakobo, Tandio, akto luâk siâ Roma yeŋgât hâkâŋ agi areyeŋgâlân gâtŋe siâ kotŋe Simoŋ ");
INSERT INTO tim_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","akto kepia siâ kotŋe Karioto ain gâtŋe siâ aregât kotŋe âmâ Yudasi arekŋe manmâ beirâŋângen Yesu gasa agaŋep. ");
INSERT INTO tim_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Gimbâŋânba gem Yesu olop emelan âgâmbiâ luâk âmbâle dondâ arekŋe togo turuŋyekbiâ Yesugât hoŋ bawalupŋande hin dâyi, “Luâk âmbâle dondâ irekŋe emet pikbiâ âmâ gain gain sot nemberen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hain dâmbiâ Yesugât ginbailupŋande den are nâŋgâm hin dâyi, “Yesu nâŋgâ nâŋgâŋe gulip akto aregât arim mene.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Akto Mosegât den kepikmâ makyeŋgimini are Yerusalem kepianba togoyi arekŋe hin dâyi, “Sinduk baniara bâleŋe yeŋgât humoyeŋe kotŋe Besebulu arekŋe Yesu kautŋân mendo yâkgât kârikŋân kinmâ sinduk baniara bâleŋe watyekmap. Akto sinduk humoyeŋande tângombo sinduk baniara bâleŋe watyekmap.” dâmbiâ nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aregât yeŋgondo togombiâ den ginŋe ginŋe siâ siâ makyeŋgiep, “Sinduk baniara humoyeŋe Niambi arekŋe ikiŋe kâmotlupŋe watyekmap dâine yâk akto ikiŋe kâmotlupŋe bo akbâi. ");
INSERT INTO tim_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Akto luâk kepia konokŋe potalakmâ hanâk hanâk agumbiâ kepia are pum yembop. ");
INSERT INTO tim_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Me kâmot siâ aregât luâkŋe potalakmâ gasa hanâk agaŋgimbiâ âmâ kâmot are bo akbiap. ");
INSERT INTO tim_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Me Niambigât sinduk baniaralupŋande potalakmâ agumbiâ dâine Niambi kârikŋe bo miawagaŋbop. Akto Niambi akto kâmotlupŋe bo akbâi. ");
INSERT INTO tim_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Me luâk siâŋe luâk kârikŋe siâgât emelan âgâm wan me wan kâmbu meaŋberâm akbiap. Hain akmâ gain gain memberâm yoŋâk âgâmbo amboŋe asiŋ yendo tâkŋe keiŋe bâtŋe hikom pando yendo âmâ âlepŋe wan me wan ekmâ pitiwiap. ");
INSERT INTO tim_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aregât den bunŋe hin makyeŋgire nâŋgâŋet. Luâk siâ bâleŋe mem manmai bâleŋe me Anutugât kot mem bâliaŋmâ sârek konmai aregât dosa Anutuŋe kutigitbiapgât dop tatâp. ");
INSERT INTO tim_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gârâmâ luâk siâŋe Anutugât Heakŋe amâ bâleŋe dâm makmâ bâliaŋmâ sârek konbiap âmâ luâk aregât dosa Anutuŋe puliaŋbiapgât dop bo yendâp. Anutugât Heakŋe amâ bâleŋe dondâ dâmbo âmâ dosa are ekmâ hainâk yeaŋâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuŋe Anutugât Heakŋe aregât kârikŋân kinmâ âi mendo ekmâ yâkŋe nâŋgâm hilip koyi aregât den hain makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Den hain dâm makyeŋgimbo memeŋe emilupŋe togom betgen kinmâ, “Teunenŋe ge.” dâm siâ huŋgunaŋi. ");
INSERT INTO tim_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Huŋgunaŋbiâ gambo luâk âmbâle Yesu ketokmâ emelan tali arekŋe Yesu hin magaŋi, “Memege emilupge betgen kinmâ kulâgât giŋdâi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Niŋema memene me emilupne aktâi?” ");
INSERT INTO tim_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hain dâm turuŋaŋmâ tali are yekmâ hin dâep, “Nâŋgât memene akto emilupne garilupne amâ ire. ");
INSERT INTO tim_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Akto Anutugât lau lokomai yeŋe âmâ nâŋgât memene akto emilupne akto garilupne aktâi.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuŋe hilâm siân bâtgum ginŋân gem den pat âlepŋe makyeŋgiep. Makyeŋgim âmâ luâk âmbâle dondâ togo mendugumbiâ âmâ waŋgan âgâep. Luâk âmbâle togoyi are bâtgum dâtŋân kinbiâ makyeŋgiwerâm waŋga siân âgâm getek baep. ");
INSERT INTO tim_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bam bâtgum ginŋân kinmâ den ginŋe dondâ makyeŋgiep. Are hutŋân den ginŋe siâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Luâk siâŋe seŋgo alekŋe are hânân urutmâ âiângen ariep. ");
INSERT INTO tim_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hain akmâ arim uruto alekŋe bikŋe âmâ dâwân ge yiep are âmâ lâutŋe dowâk togo nem meteyi. ");
INSERT INTO tim_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dâ bikŋe âmâ hân bawalawân ain ge yiep arekŋe pâtkombo kâmŋe dowâk gambo ");
INSERT INTO tim_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","dewutâ kârikŋe pando kândârâŋe tâlâwâkgât dipkom moep. ");
INSERT INTO tim_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dâ bikŋe âmâ hele hewukŋe humo yiep are hutŋân ge yiep arekŋe sopŋân pâtkom kâmŋe gambo hewukŋe âkâ hainâk gam kârikŋe akmâ sot tigimbo bunŋe bo agep. ");
INSERT INTO tim_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Akto seŋgo alekŋe bikŋe âmâ hân kelurâ ain ge yiep are bikŋande pâtkom agatmâ bunŋe âlepŋe agep. Dâ bikŋande âmâ pâtkom agatmâ bunŋe âlepŋe dondâ agep. Akto bikŋande âmâ pâtkom agatmâ bunŋe humomo âlepŋe dondâ akmâ bikŋe hârok ewangiyegep. ");
INSERT INTO tim_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gârâmâ ye den ire nâŋgâm biwiyeŋân katmâ heŋgemgom manbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Akto luâk âmbâle hârok arim metembiâ bikŋe konok konok kili are akto hoŋ bawalupŋe keiân lâuwâ arekŋe Yesu hin aikoyi, “Den ginŋe maknengiât are keiŋe gain gain?” dâyi. Hain dâmbiâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“Anutuŋe damunyeŋe akmap aregât keiŋe makyeŋgiân. Gârâmâ luâk bikŋe Anutuŋe damunyeŋe akmap aregât keiŋe bo nâŋgâm heŋgemgomai aregât den ginŋe ire makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Anutuŋe makto siâŋe kulemgoep are bikŋe hin tatâp, “Luâk bikŋe ondopyeŋe mem gisapkom âmâ bo nâŋgâmai. Akto dewunyeŋe mem tigim âmâ bo ekmai. Amâ hingât. Biwiyeŋe nâŋgâlân katbiâ dosayeŋe puliyeŋgiwomgât den bo heŋgemgomai.” Anutuŋe hain dâep are bunŋe agâk dâm luâk hainare yâk den ginŋeâk makyeŋgiman. ");
INSERT INTO tim_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Akto yeŋe âmâ den ginŋe nâŋgâm heŋgemgomai dâre bo nâŋgâm heŋgemgomai aregât gain gain maktere âmâ âlepŋe nâŋgâwai? Den ginŋe maktân aregât keiŋe hin makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Luâk sot koaŋe urutmâ manmap arekŋe âmâ Anutugât den pat are makyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dâ koaŋe dâwân giep are âmâ wan? Hân are âmâ luâk manmai ire. Gârâmâ luâk siâ den âlepŋe aregât nâŋgâmbo amâ ainâk sinduk baniara yeŋgât humoyeŋe kotŋe Niambi arekŋe dowâk togo den âlepŋe biwiŋân kinmap are kondo momap hainare. Akto hanyeŋe purik katbop dâm den âlepŋe are mem heambukmâ gem arimap. ");
INSERT INTO tim_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dâ koaŋe kât kakŋân palepgât maktân are âmâ luâkŋe hin akmai. Luâk are âmâ hân aregât dop hainare yâkŋe âmâ Anutugât den âlepŋe nâŋgâm manmâ heroŋe akmai. ");
INSERT INTO tim_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Akto hanyeŋân kândârâŋe bo yeyeŋgimapgât sop pâŋ konok mem manbai gârâmâ Anutugât dengât gasa akto bugâ miawakto ainâk hamep akmâ den are hepunmai. ");
INSERT INTO tim_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dâ koaŋe hele hewukŋe yiep are hutŋân palep. Hân aregât dopŋe âmâ luâkŋe akmai. Luâkŋe den nâŋgâm kinmâ manmâ âmâ ");
INSERT INTO tim_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","benŋe manman iregât hanokoakmâ âmâ hângât siâ me siâ aregât egâliaŋ gogâleaŋ akmâ puli sikumgât ukenŋe akmâ aregât egâliaŋmai. Arekŋe gem biwiyeŋân den aregât hanyeŋân tigimbo bunŋe bo miawakmap. ");
INSERT INTO tim_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dâ hân âlepŋân urulep hân aregât dop âmâ luâkŋe aktâi. Yâk âmâ luâk âmbâleŋe Anutugât den pat âlepŋe mem manmâ agak meme âlepŋe akmâ manbiâ Anutuŋe yekto ârândâŋ akmap. Dâ bikŋande nâŋgât den lokomai are âmâ agak meme âlepŋe akmai. Dâ bikŋande hain akmâ agak meme âlepŋe dondâ akmai. Dâ bikŋande âmâ agak meme âlepŋe hârok penâyeŋgimap.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuŋe luâklupŋe den ginŋe siâ hin makyeŋgiep, “Kâlâp ululunŋe emet kâlegen mem âgâm kau kakŋân katmaen. Amâ emet kâleŋe pagaleâk dâm âmâ kau kakŋân katmaen. Akto hândâk akbop dâm âmâ umbâ kâlegen bo katmaen. Me dâgâmŋe bo tigimaen. ");
INSERT INTO tim_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Siâ me siâ tiwâk yemap are yem bo yembiap. Are Anutuŋe mem miap panbiap. Dâ siâ me siâ akmâ totokom heambukmai are gai hainâk yem bo yembiap. Are mem hulaŋmâ metewiap. ");
INSERT INTO tim_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gârâmâ ye den ire nâŋgâm biwiyeŋân katmâ heŋgemgom manbei. ");
INSERT INTO tim_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Amâ den siâ me siâ hokboâk hokboâk nâŋgâm potatmâ manbei. Yeŋeak siâ me siâ akmâ mem yeŋgiwai âmâ dop hainâk Anutuŋe gai hainagâk purikatyeŋgiwiap. Akto areâk bo. Umatdâk yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Akto luâk siâ wan me wan lokomap me nâŋgâmap are damun akmâ mando âmâ hâmbâi Anutuŋe humoâk waŋbiap. Dâ luâk siâŋe wan me wan bâlensiâ mem manmap are Anutuŋe bâtŋânba keŋgoŋmâ membiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hain dâm kinmâ siâ hin makyeŋgiep, “Anutuŋe damunyeŋe akberâm akmap aregât dopŋe hin. Luâk siâŋe arim wan me wan koaŋe kâmetmap. ");
INSERT INTO tim_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Akto golâ manmâ me yem mando koaŋe arekŋe hogoakmâ kâmŋe gamap. Akto luâkŋe aregât keiŋe bo ekmap. ");
INSERT INTO tim_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hân arekŋeak tângombo hogoakmâ ulik gulik kâmŋe gamap. Hamiŋân esenŋe katmap. Hamiŋân bunŋe miawakmap. Akto bâiŋe âmâ bunŋe humo miawakmâ âlim yemap. ");
INSERT INTO tim_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Âlim yendo âmâ ainâk luâk arekŋe, “Emelâk bunŋe akmâ âlim yendâp.” dâm âmâ tâwât mem arim oremap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hain dâm siâ hin makyeŋgiep, “Anutuŋe damunyeŋe akmapgât dâpŋe gain gain makyeŋgire nâŋgâwerâi? Anutuŋe damunyeŋe akmap aregât keiŋe âmâ hin. ");
INSERT INTO tim_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lâwin koaŋe bâlensiâ lâwin bikŋe koaŋyeŋe aregât bikŋân gegeŋe akmap. ");
INSERT INTO tim_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Gârâmâ koaŋe ire âmâ kâmetenŋe humo akmâ siânba ewangiyekmâ lâwin humomo akmap. Akto aregât bât bâtŋân lâutŋe togo tatmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yâkŋe den keiŋe keiŋe hârok makmâ den âlepŋe are luâk âmbâle hârok togombiâ den ginŋân makyeŋgim malep. Akto luâk âmbâle bikŋe nâŋgâ nâŋgâyeŋe dopŋân makyeŋgim malep. ");
INSERT INTO tim_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dâ den miawâk âmâ bo makyeŋgiep. Gârâmâ hoŋ bawalupŋe olop yeŋeâk manmâ âmâ Anutugât den aregât keiŋe are makmâ miawak yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sop ainâk emet dâgâmbo hoŋ bawalupŋe hin makyeŋgiep, “Nen bâtgum biken arine.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","luâk âmbâle dondâ are hepun yekmâ waŋgan âgâm ariyi. Waŋgan arimbiâ waŋga siânba watyekbiâ olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bâtgum biken ariwerâm akbiâ âmâ seru humo togombo bâtgumŋe kaulem waŋga kâlegen gembo pikberâm agep. ");
INSERT INTO tim_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Akto Yesu âmâ waŋga hamiŋângen dâgâmŋe kautŋe korânŋe katmâ asiŋ yem tato hoŋ bawalupŋande goaŋbiâ agato hin dâyi, “Haruân gewerâm akten aregât nengât okotge nâŋgât me bo?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hain dâmbiâ agatmâ kinmâ seru hin magaŋep, “Nâŋâgâ.” dâmbo nâŋâgâep, “Seru nâŋâgâ.” dâmbo nâŋâgâmbo harugât magep, “Bâin nâŋâgâm yeâk.” dâmbo haru nâŋâgâm yiep. ");
INSERT INTO tim_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Seru akto haru nâŋâgâm yembela hoŋ bawalupŋe hin makyeŋgiep, “Wangât hamep aktâi? Bo nâŋgâniŋmâ kepilâm manmâ gayi mon?” hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hain dâmbo hamep dondâ akmâ ongâyeŋe hogombo magaŋgi goaŋgi akmâ hin dâyi, “Ire luâk me wano? Seru akto bâtgum yetgât makto lauŋe lokoat ire gain gain aktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu akto hoŋ bawalupŋe waŋgan arim bâtgum hâtikom kepia siâ kotŋe Gerasene ain togoyi. ");
INSERT INTO tim_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Togom waŋganba sopanmâ âgâmbiâ luâk siâ sinduk baniara bâleŋande kautŋân miep arekŋe Yesu egep. ");
INSERT INTO tim_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Luâk are sum kâlegen manminep. Akto hân dâpŋân manminep. Hain akmâ manmâ metŋe akto kepia aregât ambolupŋande tâkŋe keiŋe bâtŋe hikom mendugumini. Hain akbiâ bo akminep. ");
INSERT INTO tim_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Luâkŋe hilâmŋe hilâmŋe keiŋe bâtŋe dâgâm mendugumbiâ tâk hâreminep. Akto tâk kârikŋe kotŋe sein arekŋe dâgâmbiâ oloŋ akmâ âi humo mem hâreminep. Akto siânbaŋe gala katberâm togombiâ kârikŋe akto hepunmini. ");
INSERT INTO tim_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Luâk sinduk baniara bâleŋande kautŋân miep arekŋe hilâm hândâk ârândâŋ sumân me tâumŋân yem agatmâ kamboŋmâ manminep. Akto kât pitim ikiŋe aguminep. ");
INSERT INTO tim_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Akto Yesu togombo luâk arekŋe Yesu kâlewângen togom mando ekmâ yâkgâlân pârigim togom enemŋân kâŋgoep. ");
INSERT INTO tim_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Kâŋgom kindo Yesuŋe sinduk baniara bâleŋe aregât hin dâep, “Gâ luâk iregât biwiŋânba hepunmâ ari.” dâmbo luâk arekŋe kamboŋmâ indem hin dâep, “Yesu, gâmâ Anutu Humogât nanŋe. Anutuŋe nâŋgâmbo ârândâŋ agâkgât nâŋgât den loko. Gâ hâk hilâlâm âi bo niŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hain dâmbo hin magaŋep, “Kotge niŋe.” dâm aikombo, “Nâ kotne dondâ. Nen dondâ manden aregât kotne dondâ.” dâep. Hain dâm kârikŋe akmâ hin ulilaŋep, ");
INSERT INTO tim_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","“Sinduk baniara bâleŋe are watyekmenâ kâlewângen bo ariwerâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akto hân are pelepŋân bau dondâ siâ hemem kautŋe tete tâmut nem mali. ");
INSERT INTO tim_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Akto sinduk baniara dondâ arekŋe hin magaŋi, “Maknengimenâ nen bau yeŋgât biwiyeŋân gene.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hain dâmbiâ nâŋgâ yeŋgim, “Hepunŋet.” dâmbo luâk aregât kautŋânba hepunmâ âgâm bau yeŋgât biwiyeŋân geyi. Gembiâ bau arekŋe sân sân mem hemem kautŋânba tu bâtgum humoân gem tu nem metem moyi. Akto bau are getek bo. Dondâ 2,000 hain are geyi. ");
INSERT INTO tim_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gembiâ yekmâ damunlupyeŋande arim kepia ewumâk ewumâk talep aregât ambolupŋe makyeŋgiyi. Makyeŋgimbiâ ekberâm togoyi. ");
INSERT INTO tim_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesugâlân togo ekberâmbiâ luâk sinduk baniara bâleŋe dondâŋe kautŋân memini are nâŋgâ nâŋgâŋe hulaŋ akto hâk peke lalakmâ âlepŋe tato togom egi. Hain akmâ tato luâk âmbâle togoyi arekŋe ekmâ hamep akmâ bâtyeŋe dâtyeŋân igim kili. ");
INSERT INTO tim_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ulik gulik egi arekŋe Yesuŋe luâk are wan agaŋep akto baugât pat are makyeŋgimbiâ nâŋgâm Yesu hin magaŋi, ");
INSERT INTO tim_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","“Arimân in nengât hânân ire bo manben.” dâm wârakmâ hâwâtbiâ ariep. ");
INSERT INTO tim_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Arim waŋgan âgâmbo luâk sinduk baniaraŋe mem hepuli arekŋe hin dâep, “Nâ gâ olop arire.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hain dâm magaŋdo Yesuŋe hin magaŋep, “Bo. Kepiagângen arim ginbailupge olop manmâ Anutuŋe okot nâŋgâ giŋdâp iregât makyeŋgiwen. Akto Anutuŋe gâŋgâlân kulem humo mem heŋgem guguâp iregât pat luâklupge makyeŋgiwen.” dâm dengoep. ");
INSERT INTO tim_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hain dâmbo purik katmâ arim Yesuŋe wan agaŋep aregât denŋe kepia bât biken hârok ain makyeŋgim malep. Makyeŋgimbo nâŋgâmbiâ dâtŋe akto bâtyeŋe dâtyeŋân igim kili. ");
INSERT INTO tim_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu akto hoŋ bawalupŋe purik katmâ togom waŋganba sopanmâ gem nupiân kinbiâ luâk âmbâle dondâŋe ekberâm togo menduguyi. ");
INSERT INTO tim_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hain akmâ kinbiâ den opmânŋaet damun siâ kotŋe Yairo, arekŋe togom ekmâ enemŋân tatmâ kâŋgoep. ");
INSERT INTO tim_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Hain akmâ kârikŋe akmâ hin magaŋep, “Baratne momberâm aktâp. Gâŋe gutmâ bâtgande howaimenâ âlepŋe agâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hain dâm magaŋdo nâŋgâm olop ariyiat. Arimbela luâk âmbâle biwirâ Yesu ekberâm togo ewumâk kinmâ olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yesu watmâ arimbiâ are yeŋgât hutyeŋân âmbâle siâ ariep. Yâkgât keiŋe hin. Âmbâle yeŋgât dewutâ gambo kundat akmai dop hain bo akminep. Hilâm ârândâŋ gembo mando hombaŋ keiân lâuwâ bo agep. ");
INSERT INTO tim_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hain akmâ manmâ dokta yeŋgâlân arimbo kundatŋe bo agâkgât âi membiâ bo akto kundat humo akto malep. Akto kundatŋe bo agâkgât puli are dokta yeŋgimbo puli bo akto kundat hainâgâk yendo hombaŋ keiân lâuwâ akto humo akmâ hainâk yiep. ");
INSERT INTO tim_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hainâk manmâ Yesugât patŋe nâŋgâm luâk âmbâle arimbiâ are hutyeŋân arim Yesu howaiwerâm agep. ");
INSERT INTO tim_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Arim hin nâŋgâep, “Nâ sâŋgumŋeâk howaim âlepŋe akberân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hain nâŋgâm howaim ainâk âlepŋe akto nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Âlepŋe akto Yesuŋe hin nâŋgâep, “Siâŋe togom nâŋgât kârikŋene mem âlepŋe aktâp.” dâm nâŋgâm purik katmâ hin aiyeŋguep, “Nâŋgât sâŋgum niŋande howaiâp?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Hain dâmbo hoŋ bawalupŋande hin magaŋi, “Luâk âmbâle dondâ howai gekbiâ nâŋgât are konokŋe bo howai gektâp. Wangât hain maktât?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hain dâm magaŋbiâ yâkŋe purikatmâ âmbâle are ekberâm wâragep. ");
INSERT INTO tim_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Akto âmbâle kundat bo agaŋep arekŋe nâŋgâm hamewakmâ hâkŋe sân sân mendo togom enemŋân kâŋgom ikiŋe keiŋe hârok magaŋep. ");
INSERT INTO tim_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hain akmâ magaŋdo nâŋgâm hin magaŋep, “Meŋ, nâŋgâniŋdâtgât nâ hin makgiŋbe. Kambiamge sândugembo arim hâk hilâlâm bo nâŋgâm manben.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hain dâm magaŋmâ kindo luâk bikŋande Yairo aregât emelanba togom hin dâyi, “Baratge mondâp aregât Humonenŋe bo hâwâtmenâ inâk talâk.” ");
INSERT INTO tim_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hain dâmbiâ nâŋgâm Yesuŋe den opmânŋaet damun are hin magaŋep, “Biwige nâŋgâlân katmâ âmâ bo hamewak.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hain dâm siânba hepun yekmâ Petoro, Yakobo, akto Yakobogât emiŋe Yohane, areâk meyekto ariyi. ");
INSERT INTO tim_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Arim den opmânŋaet damun aregât emelan peniaŋi. Emelan togombiâ luâk âmbâi gulip tatmâ umbi mem âgâ indem tali. ");
INSERT INTO tim_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hain akmâ tatbiâ emet kâlegen âgâm yekmâ hin makyeŋgiep, “Ye wangât togo indem tatâi? Âmbâi sitnan ire bo mondâp âmâ yân asiŋ yendâp.” ");
INSERT INTO tim_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hain dâmbo nâŋgâm giriŋaŋi. Giriŋbiâ âmâ Yesuŋe, “Ekeŋet.” dâm watyekto betgen ge kili. Kinbiâ âmbâi sitnan aregât memeŋe eweŋe akto hoŋ bawalupŋe âlâwu oloŋyekto âmbâi sitnan aregât ginŋân guli. ");
INSERT INTO tim_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gutmâ âmbâi sitnan aregât enemŋân kinbiâ bâtŋân mem ikiŋe denân hin dâep, “Talita kumi.” dâep. Amâ den purikŋe hin, “Âmbâi sitnan makgiŋdere agat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hain dâmbo ainâk agatmâ bam gulep. Âmbâi sisik are âmâ hombaŋŋe keiân lâuwâ. Akto luâk âmbâle arekŋe ekmâ bâtyeŋe dâtyeŋân igiyi. Akto âmbâi sisik arekŋe âlepŋe akmâ bam guto aregât hin dâep, ");
INSERT INTO tim_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","“Iregât bo makyeŋgiwei.” dâm kârikŋe makmâ hâreyeŋgiep. Hain akmâ âmbâi sitnan aregât hin dâep, “Sot om waŋbiâ neâk.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ainba Yesuŋe ikiŋaet kepian ariwerâmbo hoŋ bawalupŋe olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Arim manbiâ âmâ âi bo mem sopŋe miawakto den opmânŋân âgâm den makyeŋgiep. Makyeŋgimbo âmâ luâk âmbâle dondâŋe nâŋgâmbiâ dâtŋe akto hin dâyi, “Luâk ire amâ in gâtŋe. Ulikŋân emet ketugum manminep akto memeŋe âmâ Maria, akto emilupŋe âmâ kotyeŋe Yakobo, Yose, Yudasi, akto Simoŋ, akto garilupŋe nen olop in manmaen aregât yâkgât keiŋe nâŋgâmaen ina niŋande kulem keiŋe ire hekalaŋep. Nâŋgâ nâŋgâŋe humo akmap ire yâgâtenba mem togoep. Kulem mendo nen ekmâ kambiamnenŋe agatâp.” dâm bâtyeŋe igim kili. Hain dâm nâŋgâmbiâ kambiamyeŋe bâliep. Hain akmâ Yesu ingâtŋe dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","aregât hin makyeŋgiep, “Luâk siâŋe kepia biken biken arim Anutugât keiŋe makyeŋgimbo nâŋgâmbiâ humo akmap. Dâ ikiŋaet kepia me emetŋân arim ginbailupŋe makyeŋgimbo nâŋgâmbiâ gemap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hain dâm âmâ kundatdâ konok konok meyekto âlepŋe agi. ");
INSERT INTO tim_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akto Yesugât nâŋgâmbiâ giep aregât Yesuŋe nâŋgâmbo dâtŋe agep. Hain akmâ ikiŋaet kepia hepunmâ kepia siân siân arim kepia are ambolupŋe den pat âlepŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kepia siân siân arim hoŋ bawalupŋe keiân lâuwâ are lâuwâk lâuwâk huŋgunyeŋgim hin makyeŋgiep, “Makyeŋgire nâŋgâŋet. Kepia siân siân arim nâŋe meme akyeŋgire nâŋgât kâriknân kinbai. Aregât huŋgun yeŋgire lâuwâk lâuwâk akmâ kepia siân siân arim âmâ sinduk baniara bâleŋe watyeŋgiŋet. ");
INSERT INTO tim_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akto ariwaiân âmâ sot me ito me puli sâŋgum dondâ bo mem ariwei. ");
INSERT INTO tim_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Akto kei peke luguakbai are akto sâŋgum luguakbai arekŋe konok hâkyeŋân tatbiap akto tânagum ariwaigât huwan konokŋeâk panmâ tânagum sâŋgum konogâk lugu akmâ ariwei. ");
INSERT INTO tim_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Akto ariwaiân kepian arim âmâ emet konogân asiŋ yembei. Akto emet hanâk hanâgân bo âgâm manbei. ");
INSERT INTO tim_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dâ kepia siân arimbiâ wan me wan denŋe makyeŋgimbiâ âmâ nâŋgâmâk bo akmâ gasa akyeŋgimbiâ âmâ ariwerâmân Anutuŋe hâuŋe yeŋgiwiap aregât dop akmâ keiyeŋân hamaŋ siâ tatbiap are tâlim pulimbiâ gewiap.” dâm lâuwâk lâuwâk huŋgunyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hain dâm huŋgun yeŋgimbo lâuwâk lâuwâk akmâ arim luâk âmbâle hin makyeŋgiyi, “Bâleyeŋe makmâ miawakmâ âmâ hepunŋet.” dâm makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Akto sinduk baniara bâleŋe watyeŋgim mali. Arim hain akmâ manmâ makyeŋgimbiâ luâk kundatdâ togombiâ lâwin hâŋemŋe puliyekmâ âlepŋe akŋet dâmbiâ âlepŋe agi. ");
INSERT INTO tim_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesugât hoŋ bawalupŋande hain akbiâ pat arekŋe sambelembo luâk dondâŋe nâŋgâyi. Nâŋgâm âmâ bikŋande Yesugât hin dâyi, “Yohane tu puli yeŋgiep are luâk kembu nenŋe Herote, yâkŋe kondo moep arekŋe sumânba agatmâ mandâp. Luâk ire Yohane moep arekŋe golâ akmâ agatmâ yu mandâp ire.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hain dâmbiâ bikŋande Yesugât patŋe nâŋgâm hin dâyi, “Propete luâk kotŋe Elia arekŋe purik katmâ gem mandâp.” dâyi. Dâ bikŋande âmâ hin dâyi, “Propete luâk ulikŋân moyi are yeŋgâlân gâtŋande mandâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Akto Heroteŋe hin dâep, “Yohane hanŋe hâreân arekŋe momoŋânba agatmâ mandâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Aregât keiŋe hin. Herote are akto luâk siâ Pilipo, emiteu are tatminiat. Akto ulikŋân Pilipo arekŋe âmbenŋe kotŋe Herodia miep. Mendo âmâ âmbâle arekŋe luâkŋe Pilipo hepundo kandâŋe Herote, are olop meakbela aregât Yohaneŋe nâŋgâm hin dâep, “Den kârikŋe kom kandâge memenâ bâliâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hain dâmbo aregât âmbâle Herodia arekŋe âmâ Yohanegât nâŋgâm bâlim gain gain akmâ kombe dâm âsim manminep. Komberâm nâŋgâm kinmâ luâkŋe hâwâto kala busi kâlegen kato talep. ");
INSERT INTO tim_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Dâ luâkŋe Herote arekŋe âmâ Yohanegât den are nâŋgâm han lâuwâ akmâ hin nâŋgâep, “Luâk ire âmâ Anutugât lauŋe lokom agak meme âlepŋeâk mem manmap.” dâm denŋe nâŋgâm heroŋe akmâ benŋe han lâuwâ agep. Hain akmâ luâk âlepŋe dâm damunŋe agep. ");
INSERT INTO tim_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hain akmâ Herote miawagepgât sopŋe akto luâk kembu akto tembe lokolupŋe yeŋgât humomolupyeŋe akto luâk kautŋe kautŋe me Galilaia yeŋgât humoyeŋe mendugu yekmâ sot om yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sot om yeŋgimbo mendugum nem tatbiâ âmbenŋaet baratŋe âmbâi sigan arekŋe hutyeŋân kinmâ kep keŋgu koep. Hain akto âmâ kambiam yeŋe âlepŋe akto aregât Heroteŋe hin dâep, “Barat, wan me wangât nâŋgâm makniŋmenâ nâ âlepŋe giŋbian. ");
INSERT INTO tim_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Anutugât dewunŋân makgiŋdere nâŋgâ. Wan me wan ekmâ ulitniŋmenâ are âlepŋe giŋbian. Amâ nâŋgâ yâkŋe hân niŋâk dâm ulit niŋmenâ are âkâ bikŋe potatmâ giŋbian.” ");
INSERT INTO tim_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hain dâm magaŋdo âmbâle arekŋe arim memeŋe hin magaŋep, “Luâkgande wan me wan hârok niŋberâm aktâp aregât wangât ulilaŋbe?” dâmbo memeŋande hin dâep, “Luâk tu puli keiŋe kalep kotŋe Yohane, aregât kautŋe hârem niŋ dâmenâ hârem giŋâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hain dâm magaŋdo âmbâle sigan arekŋe pârigim luâk kembugâlae arim ulilaŋmâ hin dâep, “Gâ Yohane hanŋe hârem kautŋe kondoân katmâ niŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dâmbo âmâ luâk kembu are biwiŋe dondâ bâliep. Dâ magep are Anutuŋe nâŋgâep aregât nâŋgâm den koko bo agep. Akto luâk tali are yeŋgât dewunyeŋân denŋe gewopgât magep hain agep. ");
INSERT INTO tim_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hoŋ bawaŋe siâ tâwât amboŋe are huŋgunaŋdo tâwât mem arim kala busi kâlegen âgâep. ");
INSERT INTO tim_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Âgâm Yohanegât hanŋe hârembo mondo kautŋe kondoân katmâ mem gutmâ âmbâi sigan are waŋep. Waŋdo mem memeŋalae lokom ariep. Lokom arim memeŋe waŋdo miep. ");
INSERT INTO tim_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mendo âmâ Yohanegât hoŋ bawalupŋande pat are nâŋgâm ari hâkŋe mem hangoyi. ");
INSERT INTO tim_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesugât hoŋ bawalupŋe kepiaŋe kepiaŋe arim den pat âlepŋe are makyeŋgim manmâ purik katmâ Yesugâlân togoyi. Yâkgâlân mendugum kinmâ wan me wan agi me den makyeŋgiyi aregât pat hârok mem magaŋi. ");
INSERT INTO tim_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Akto sop ain luâk âmbâle dondâŋe Yesu ekberâm togom ekmâ purik katmâ ariyi. Hain akbiâ aregât hoŋ bawalupŋande hin magaŋgi goaŋgi agi, “Gulip nengumbiâ gain gain sot nemberen.” dâyi. Hain dâmbiâ Yesuŋe hin dâep, “Bâin pumângen arine. Luâk dondâŋe togombiâ aregât pumângen nenŋeâk ari manmâ hâk mem biwiyeŋe sândugeâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hain dâmbo yeŋeâk waŋgan âgâm pumângen ariwerâm akmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Arimbiâ luâk âmbâle kepia siânba siânba togoyi arekŋe yekmâ nâŋgâm yâkŋe soŋ dowâk pârigim bâtgum ginŋân togoyi. ");
INSERT INTO tim_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Togom kinbiâ waŋganba sopanmâ gem yekmâ hin dâep, “Luâk âmbâi dondâ ire yeŋgât damun bo mandâi.” dâm okotŋe nâŋgâep. Hain akmâ den pat âlepŋe are makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Makyeŋgim kindo emet dâgâwerâm akto hoŋ bawalupŋande hin dâm magaŋi, “Ire âmâ pumângen mandenŋe dewutâ gewerâm aktâp ");
INSERT INTO tim_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","aregât huŋgun yeŋgimenâ ariŋet. Hân iren aŋgim nene emetŋe bo kindâp aregât huŋgun yeŋgimenâ kepia siân siân arim ain sot puligom neŋet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Yeŋeak sot yeŋgiŋet.” dâmbo hin dâyi, “Nen gain gain lauge lokoweren? Luâk âmbâle kâmot ire yeŋgât sot âmâ 2,000 kina hainŋe puligoenŋe ârândâŋ bo akyeŋgiwerâp aregât gain gain lauge lokoweren?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hain dâmbiâ hin makyeŋgiep, “Yeŋgât sot amon tatyeŋgiâp? Ba ekmâ gutmâ makniŋŋet.” dâmbo bam oyaŋmâ ekmâ gutmâ hin magaŋi, “Nengât sot momerâk akto iŋan lâuwâ tatâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hain dâmbiâ, “Hârok kâmot ikiŋeâk ikiŋeâk umiliŋ kakŋân ain ge tatŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hain dâmbo hainâk kâmot 50 âk hârok ain ain tatmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hain akbiâ sot are mem himbimân dewunŋe panmâ Anutu mepaiŋe miep. Hain makmâ sot are munditmâ hoŋ bawalupŋe yeŋgimbo potatmâ lokom bam luâk âmbâle tali are yeŋgiyi. Akto iŋan hainâk yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yeŋgimbo nem tepyeŋe pigep. ");
INSERT INTO tim_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nem tepyeŋe pikto hoŋ bawalupŋande pipiŋe haka keiân lâuwâ lugumbiâ pigep. ");
INSERT INTO tim_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Akto luâk 5,000 hain arekŋe sot neyi. ");
INSERT INTO tim_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Akto Yesuŋe hoŋ bawalupŋe hin makyeŋgiep, “Yeŋe soŋ waŋgan âgâm Besaida kepian arimbiâ âkâ nâŋe luâk âmbâle ire huŋgun yeŋgire ariŋet.” dâep. Hain dâmbo hoŋ bawalupŋe waŋgan âgâm bâtgum biken kepia kotŋe Besaida ain ariwerâm akbiâ Yesuŋe luâk âmbâle ain kili are hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","“Bâin ariŋet.” dâmbo arimbiâ gimbâŋân âgâm ikiŋak Anutu magaŋmâ talep. ");
INSERT INTO tim_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hain akmâ tato emet dâgâmbo hoŋ bawalupŋe emelâk haru tânâmŋângen arim manbiâ Yesu ikiŋak gimbâŋânba gem bâtgum ginŋân kinmâ yegep. ");
INSERT INTO tim_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yekto seru humoŋe meyekto gain gain akmâ arine dâm âi humo mem tatbiâ emet hauŋberâm agep. Hain akto hândâk pipiŋe tatoâk bâtgum kakŋân tâlim tâlim ari ewangiyekberâm agep. ");
INSERT INTO tim_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Hain akto hoŋ bawalupŋande ekmâ, “Hat sinduk togoâp.” dâm hamewakmâ dâtyeŋe igim ongâyeŋe hogombo kamboŋi. ");
INSERT INTO tim_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Hain akbiâ nâŋgâm ainâk hin dâep, “Nâŋe togoân. Bo hamewakŋet. Kambiamyeŋe sândugeâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hain dâm waŋgan âgâmbo ainâk seru nâŋâgâmbo ekbiâ bimbiâk agep. ");
INSERT INTO tim_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Akto sot munditmâ yeŋgiep aregât keiŋe nâŋgâm heŋgemgoyi dâine wan me wan aregât nâŋgâmbiâ dâtŋe bo akbop. ");
INSERT INTO tim_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bâtgum hâtikom metem Genesaret hânân togom waŋga hikombiâ kilep. ");
INSERT INTO tim_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kindo luâk âmbâle togom ainâk Yesu ekmâ nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ekmâ nâŋgâyi aregât kepia ewumâk ewumâk ain purik katmâ pârigim arim kundatdâ temân katmâ lokoyekmâ togoyi. Hain akmâ kundatdâ yâgâten tatâi dâm undâgât yeŋgim arewa temân katmâ lokoyekmâ Yesugâlân togoyi. ");
INSERT INTO tim_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Togom âmâ Yesuŋe kepia humo me bâlensiâ me pâloŋângen ain togom kilep aregen kundatdâ kâmotdâk katbiâ yembiâ Yesu ulilaŋmâ hin dâyi, “Gâŋgât sâŋgumge howaim âmâ âlepŋe akŋet.” dâmbiâ, “Âlepŋe.” dâep. Hain dâm kindo bikŋande howaimbiâ heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Akto Parisaio akto Mosegât den kârikŋe makmâ miawagi are bikŋe Yerusalem kepianba togo Yesugâlân menduguyi. ");
INSERT INTO tim_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mendugum tatbiâ Yesugât hoŋ bawalupŋande bâtyeŋe bo pulim sot nembiâ yekbiâ ârândâŋ bo agep. ");
INSERT INTO tim_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Amâ Parisaio luâk akto Yuda luâk yâk hârokŋe bâgilupyeŋe yeŋgât den lokom sot nemberâm akmâ bâtyeŋe pulimâk sot nemini. ");
INSERT INTO tim_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Akto aŋgim nene emetŋânba purik katmâ togom hainâk tu puliak puliak bâlâk sot bo nem manmini. Akto areâk bo. Bâgilupyeŋe yeŋgât den lokom umbâ akto kondo me sot kat katgât are tu pulimini. ");
INSERT INTO tim_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Akto Yesugât hoŋ bawalupŋe yekbiâ ârândâŋ bo agepgât Parisaio akto Mosegât den kârikŋe makmâ miawagi arekŋe Yesu hin magaŋi, “Wei, hoŋ bawalupgande wangât bâgilupnenŋe yeŋgât den bo lokom bâtyeŋe tuân bo pulim yân sot mem nendâi?” dâm magaŋi. ");
INSERT INTO tim_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hain magaŋbiâ Yesuŋe hin makyeŋgiep, “Ulikŋân Yesaia arekŋe yeŋgât keiyeŋe nâŋgâm hin kulemgoep are tatâp. Anutuŋe hin dâep, “Luâk kâmot irekŋe lauyeŋandeak gangerânekmâ maŋgannekmai. Dâ han biwiyeŋande âmâ hepun nekmâ sârekonekmai. ");
INSERT INTO tim_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nâŋgât den kârikŋe panmâ aregât dumŋân luâkgât den yânŋe are bunŋerâm makmâ kepikmai are nâŋgâm hâkŋeak nâŋgât kotne mem agatbiâ ektere yânŋe akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesaiaŋe hiaŋgi luâk yeŋgât hain kulemgoep aregât dopŋe akmâ ye Anutugât den are panmâ luâk yeŋgât den are lokom manmai. ");
INSERT INTO tim_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yeŋe yeŋgât dengât nâŋgâmbiâ humo aktâp. Dâ Anutugât den nâŋgâmbiâ geâp. ");
INSERT INTO tim_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aregât Moseŋe hin dâep, “Gâ memege ewege amukyetŋân manmâ den bâleŋe makyetkimenâ âmâ humomolupgande gugumbiâ mombiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Gârâmâ yeŋe âmâ aregât den panmâ hin makmai, “Luâk siâŋe eweŋe memeŋe amukyetŋân tatmâ manmâ eweŋe memeŋe hin makyetkiwiap, Emelâk tânyetkuân gârâmâ hepun yelekmâ wan me wan yu yetkiwerân ire âmâ Anutugât pat katberân. ");
INSERT INTO tim_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","dâmbo nengât denŋe are mem kârikŋe ketugumbo memeŋe eweŋe bo tânyetkumbo ârândâŋ akbiap.” ye hain dâmai. ");
INSERT INTO tim_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ye hain dâm Anutugât den kombiâ gembo yeŋaet den makyeŋgimbiâ sambelem arimap are ârândâŋ bo akmap. Akto areâk bo. Siâ siâgât hainâk Anutugât den kom âmâ yeŋe den mem manmai.” Yesuŋe Parisaio akto Mosegât den kârikŋe makmâ miawakmini are hain makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuŋe hain dâm luâk âmbâle yekmâ siâkâ togoŋet dâmbo togombiâ hinâk makyeŋgiep, “Nâ makyeŋgire luâk âmbâle ye hârok nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wan me wan tepyeŋân gemap are âmâ kâmbokŋe bo akto bâleŋe bo akmap. Dâ den bâleŋe makmai arekŋe âmâ luâk mem bâliyekmap. ");
INSERT INTO tim_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Gârâmâ ye den ire nâŋgâm biwiyeŋân katmâ heŋgemgom manbei.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hain dâm luâk âmbâle hepunyekmâ emelan âgâmbo hoŋ bawalupŋande den ginŋe magep aregât aikoyi, “Hinŋe maktât are keiŋe gain gaingât maktât?” dâyi. Hain dâmbiâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Woe, ye nâŋgâ nâŋgâyeŋe bâlâk mandâi hainare me? Wan me wan nembiâ tepyeŋân gemap arekŋe bâleŋe bo akmap. A bonâŋgâi mon? ");
INSERT INTO tim_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Akto wan me wan nembiâ arekŋe nâŋgâ nâŋgâyeŋe bo tângomap, are yân tepyeŋân gem potalakto panmai.” dâep. Akto magep aregât keiŋe âmâ hin. Sot hârok âlepŋe akto nendenŋe bâleŋe bo akmap. ");
INSERT INTO tim_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akto Yesuŋe lâuwâŋe hin dâep, “Wan me wan bâleŋaet nâŋgâm makmai arekŋe âmâ heleŋ bâleŋe akyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Luâkgât kambiamŋânba me hanŋânba hinâk gamap. Nâŋgâ nâŋgâ bâleŋe me egâliaŋ keiŋe keiŋe me âiân kâmbu, me kuk heŋgân me âmbâle mem hepun hepun akmai. ");
INSERT INTO tim_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Akto ukenŋe kotŋe siâ siâ bâleŋe hiaŋgi, âgâ âgâŋe bâleŋe me galagât hogo hogo me hâk mem agat agat me kopa agak meme. ");
INSERT INTO tim_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Are hârok yu maktân irekŋe âmâ nâŋgâ nâŋgâyeŋânba heleŋ bâleŋe akmâ luâk âmbâle hilip yeŋgumap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hain dâm kepia are hepunmâ Tiro akto Sidoŋ ginŋân are yeŋgât hânân togoep. Togom siânbaŋe nâŋgât pat nâŋgâwâi dâm yoŋâk emet siân âgâep. Âgâmbo patŋande sambelem ariep. ");
INSERT INTO tim_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Akto ainâk âmbâle siâ Girik âmbâle Siria hân aregât amboŋe arekŋe patŋe nâŋgâm togoep. Âmbâle aregât baratŋe sinduk baniara bâleŋe siâŋe kautŋân mendo tato aregât togoep. Âmbâle kepia siân gâtŋe arekŋe togom enemŋân kâŋgom ulilaŋmâ hin dâep, “Sinduk baniara bâleŋe watmenâ baratnaet kautŋânba hepunmâ ariâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hain dâmbo hin magaŋep, “Nenŋe âmâ nanaŋ soŋ sot om yeŋgimaen. Nanaŋ sot bâlâk tatbâi dâm dua soŋ bo yeŋgimaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hain dâmbo âmbâle arekŋe hin magep, “Kembu, bundâk maktât are nâŋgân amâ nanaŋlupnenŋande soŋ sot nem tatbiâ sot pipiŋe gembo âmâ duaŋe hanâk nemai.” ");
INSERT INTO tim_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","dâmbo Yesuŋe hin magaŋep, “Den hain maktât aregât nâŋgâ giŋdân. Gârâmâ gâ emetgân ari. Sinduk baniara bâleŋe arekŋe baratge emelâk hepundâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hain dâmbo emetŋân arim sinduk baniara arekŋe baratŋe emelâk hepundo welamŋân yendo egep. ");
INSERT INTO tim_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuŋe Tiro kepianba purik katmâ Sidoŋ kepia ewangim togo Galilaia bâtgum hâlâŋmâ kepia bât bip bip hârok tali are yeŋgâlân togoep. ");
INSERT INTO tim_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ain togombo luâk ondopŋe bokbokŋe kopa den bo makminep siâ tatminep are mem yâkgâlân kewugum arim bâtgande mem howai dâm ulilaŋi. ");
INSERT INTO tim_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hain dâm ulilaŋbiâ nâŋgâm kâmot humo hepun yekmâ kewugumbo ariyiat. Arimbela bâtŋande ondopŋân katmâ benŋe bâtŋân tâwutkom elewetŋân miep. ");
INSERT INTO tim_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hain akmâ âmâ himbimân ekmâ herâm, “Epata.” dâep amâ den purikŋe ondopge pâroŋ âgâk hain dâep. ");
INSERT INTO tim_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hain dâmbo ondopŋe pâroŋ âgâm elewetŋe purik âgâmbo den agep. ");
INSERT INTO tim_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Den akto bikŋande nâŋgâyi aregât, “Iregât pat bo makyeŋgiwei.” dâep. Hain dâm makyeŋgimbo yâkŋe kârikŋe akmâ makbiâ sambelembo luâk âmbâle hârokŋe nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Akto ekbiâ dâtŋe akto magaŋgi goaŋgi akmâ hin dâyi, “Wan me wan mendo ârândâŋâk hârok akmap. Ondopyeŋe bok bokŋe pâroŋ âgâk dâmbo pâroŋ âgâmap. Akto luâk denyeŋe bo yeŋgât makto den âlepŋe akmai. Akto kotŋe siâ siâ hârokgât makto âlepŋeâk hârok akmai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sop ain luâk kâmot humo arekŋe lâuwâŋe Yesugâlân mendugum sot bâlâk tatbiâ hoŋ bawalupŋe hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gutŋet. Nâ luâk âmbâle ire yekmâ okot nâŋgân. Yâkŋe nâ olop mandenŋe hilâm âlâwu akto sot bâlâk mandâi. ");
INSERT INTO tim_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Siânbaŋe hân kâlewângenba togoyi aregât huŋgun yeŋgire arim sotgât dâwân dewun biri yeŋguwop.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hain dâmbo hoŋ bawalupŋande hin magaŋi, “Hân pumân ire aŋgim nene emetŋe bo tatâp aregât sot humo wanânba mem miawakmâ yeŋgiweren?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Yeŋgâlân sot koaŋe amon kindâp?” dâmbo, “Nâmbulân lâuwâ.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Akto “Luâk âmbâle hârok hânân tatŋet.” dâmbo tatbiâ sot nâmbulân lâuwâ are mem Anutu mepaiŋe miep. Mepaiŋe mem sot are munditmâ hoŋ bawalupŋe yeŋgimbo kalem katmâ luâk âmbâle yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Akto iŋan amonsiâ talep arekâ mem hainâk Anutu magaŋmâ gâim potatmâ hoŋ bawalupŋe hin makyeŋgiep, “Ire yeŋgiŋet.” dâmbo hain agi. ");
INSERT INTO tim_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Luâk âmbâle arekŋe nem tepyeŋe pikto sot pipiŋe hânân giep are pitim haka nâmbulân lâuwâ lugumbiâ pigep. ");
INSERT INTO tim_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Luâk 4,000 hain are sot are neyi. Akto huŋgun yeŋgimbo purik kali. ");
INSERT INTO tim_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Luâk âmbâle arekŋe arimbiâ ainâk hoŋ bawalupŋe olop waŋgan âgâm arim Dalimanuta kepian togoyi. ");
INSERT INTO tim_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ain togom waŋganba sopanmâ gembiâ Parisaio luâkŋe togom hin dâyi, “Makmenâ himbimânba kulem siâ miawakto ekne.” dâm magaŋmâ dop koyi. ");
INSERT INTO tim_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hain dâm hiaŋbiâ biwi umatŋe akto nâŋgâm herâm hin makyeŋgiep, “Kulem miawagâkgât egâliaŋmai amâ nâŋgâre ârândâŋ bo aktâp. Luâk âmbâle hârokŋe kulem gâlâk nâŋgâmai gârâmâ kulem siâ bo hekat yeŋgiwian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hain dâm hepun yekto waŋgan âgâm bâtgum biken arim mali. ");
INSERT INTO tim_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waŋgan âgâm arim sotgât nelâm yeŋgimbo sot koaŋe konok waŋgan yiep. ");
INSERT INTO tim_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yendo hin makyeŋgiep, “Ye Parisaio akto Herote yâkŋe yeŋgât matuk pipikom nemai are nâŋgâm hanokoak akbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Hain dâmbo yâkŋe den aregât keiŋaet pâpkom magaŋgi goaŋgi akmâ hin dâyi, “Ire âmâ sotgât nelâm nengimbo togoen aregât maknengiâp me gain?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hain dâmbiâ nâŋgâm hin makyeŋgiep, “Ye wangât hain dâi? Ye iregât keiŋe bo nâŋgâm heŋgemgoâi me? Hanyeŋe kârikŋe aktâp mon? ");
INSERT INTO tim_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ye âmâ ekmai amâ bo ekmâ nâŋgâmai. Akto nâŋgâmai amâ bo nâŋgâm heŋgemgomai. Ye wan me wan ekmâ nâŋgâm âmâ benŋe wangât dowâk nelâm yeŋgimbo manmai? ");
INSERT INTO tim_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nâŋe sot momerâk potatmâ luâk 5,000 yeŋgire nembiâ pipiŋe yendo membiâ haka amon ge pigep?” dâep. Hain dâm aiyeŋgumbo, “Keiân lâuwâ.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Dâ sot nâmbulân lâuwâ kalem katmâ luâk 4,000 yeŋgire nembiâ pipiŋe yendo membiâ haka amon ge pigep?” dâmbo, “Nâmbulân lâuwâ.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hain dâmbiâ hin makyeŋgiep, “Aregât keiŋe boâk nâŋgâm heŋgemgoâi mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hain dâmbo Besaida kepian togoyi. Togombiâ kepia ambolupŋande luâk dewunŋe bokbokŋe siâ mem Yesugâlân togom bâtŋande howaiâkgât ulilaŋi. ");
INSERT INTO tim_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ulilaŋbiâ luâk dewunŋe bokbokŋe are bâtŋân mem kepia ginŋângen ge kinmâ dewunŋân tâwutkom puliaŋmâ bâtŋe katmâ hin aikoep, “Wan me wan siâ ektât me bo?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hain dâmbo dewunŋe panmâ ekmâ hin dâep, “Nâ luâk yektere lâwin hinare akmâ arim togom tatâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hain dâmbo bâtŋande dewunŋân lâuwâŋe howaimbo luâk arekŋe âlepŋe akmâ dewunŋe pagalembo tâlâwâgân me kâlewân siâ siâ hârok ekmâ metiep. Hain akto Yesuŋe hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","“Gâ arim âmâ kepia humoân bo âgâm yoŋâk emetgân ariwen.” dâm magaŋmâ huŋgun aŋdo ariep. ");
INSERT INTO tim_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Arimbo yâk hoŋ bawalupŋe olop Kaisarea Pilipo hân aregât kepia siâ siâ ewangiyekmâ ariyi. Arim manmâ hoŋ bawalupŋe aiyeŋgum hin dâep, “Luâkŋe nâŋgât keine gain gain dâm magaŋgi goaŋgi akbiâ nâŋgâmai?” dâmbo hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Siânbaŋe âmâ Yohane tu puli luâk are dâmai. Dâ siânbaŋe âmâ Elia dâmai. Dâ bikŋande âmâ propete siâ dâmai.” dâyi. Hain dâmbiâ hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Dâ yeŋeak âmâ nâŋgât niŋe dâmai?” dâmbo Petoroŋe hin magaŋep, “Anutuŋe hoŋ bawaŋe huŋgun aŋdo gewiap dâmai are amâ gâ.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hain dâmbo den kârikŋe hin makyeŋgiep, “Luâk bikŋe ire bo makmâ miawak yeŋgiwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Akto hilâm ain keiŋe katmâ den hinâk makyeŋgiep, “Luâk humomolupyeŋe akto sumbe kat kat luâk akto Mosegât den makmâ kepigi yâkŋe mendugum luâk akmâ geân nâ haminiŋmâ mem hâk hilâlâm niŋbiâ mondere hilâm âlâwu akto momoŋânba agatbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Den are makmâ miawak yeŋgimbo nâŋgâm Petoroŋe kuk akmâ Yesu ginŋângen kewugum gem den kârikŋe kugâk kugâk magaŋep. ");
INSERT INTO tim_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hain magaŋdo purik katmâ hoŋ bawalupŋe yeŋgâlân dewunŋe panmâ Petoro den kârikŋe agaŋmâ hin dâep, “Gâ Niambi aregât eke. Akto maktât are âmâ luâk nâŋgâ nâŋgâ hainare aktâp. Anutugât den bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hain magaŋmâ Yesuŋe luâk dondâ mali are akto hoŋ bawalupŋe yekmâ, yeŋgondo togom mendugumbiâ hin makyeŋgiep, “Luâk siâŋe nâ watnekberâm âmâ han hâkŋaet siâ me siâ are hamiaŋmâ lâwin parâŋe lokom watnekbiâp. ");
INSERT INTO tim_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Luâk siâŋe manmanŋe gangerâmbo âmâ gulip agaŋbiap. Dâ luâk siâŋe nâŋgât akmâ pat âlep dengât hâk biwiŋe kondo âmâ miawagaŋbiap. ");
INSERT INTO tim_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dâ luâk siâŋe hângât egâliaŋ delem me ito mem manmâ âmâ manmanŋe mesokto gulip koaŋbiap. Amâ wan âlepŋe miawagaŋbiap? ");
INSERT INTO tim_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Akto luâk siâ Anutu hamiaŋmâ manmap aregât hâmbâi Anutu manmawân ariwiapgât dop bo tatâp. ");
INSERT INTO tim_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Akto kâmot agak meme bâleŋe akmai are yeŋgât hutyeŋân siâŋe manmâ hin dâwiap, “Yesu akto ikiŋe dengât hâkâŋ akmâ mandân.” dâm haminiŋdo âmâ benŋe hainâk luâk akmâ geân nâ lâuwâŋe gem ewenaet himbim pagaleŋe olop aŋelo olop togom luâk aregât hin dâwian, “Nâkâ hainâk bo nâŋgâ giŋdân.” dâm hamiaŋbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuŋe hin makyeŋgiep, “Makyeŋgire nâŋgâŋet. Anutuŋe damunyeŋe akbiap aregât sop tâlâguâp gârâmâ yu kindâi ire yeŋgât hutyeŋân gâtŋe bikŋande bo mom âmâ golâ manbaiân kulem pagaleŋe are olop miawakto ekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Akto arewa hilâm nâmbulân konok bo akto ain Yesuŋe Petoro Yakobo akto Yohane areâk kewuguyekto gimbâŋe siân âgâyi. Âgâm Yesuŋe hâk siâ mendo egi. ");
INSERT INTO tim_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yâkgât sâŋgumŋânba pagalem kau kau akto egi. ");
INSERT INTO tim_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hain akto Mose akto Elia ulikŋân maliat are ainâk miawakmâ kinbela yelekbiâ Yesu olop den magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Hain akbiâ hoŋ bawalupŋande hamewakmâ aregât Petoro nâŋgâ nâŋgâŋe guliwakto gain dâm hin magaŋep, “Humonenŋe wan siâ hekat nengimenâ ekten aregât ukenŋe nâŋgâen. Gârâmâ iren uligi âlâwu meyeŋgine. Gâŋgât siâ Mosegât siâ akto Eliagât siâ.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hain dâmbo ainâk hamandat humo siâŋe gem tigiyegep. Tigiyekto âmâ are kâlegenba den siâ hin miawagep, “Yâk âmâ nâŋgât nanne âlepŋe yâkgât okot âlep nâŋgân. Yeŋe âmâ yâkgât denŋe nâŋgâwei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hain dâmbo den are nâŋgâm ainâk purik gurik akmâ ekbiâ Yesuŋe konok kindo egi. ");
INSERT INTO tim_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Akto ainba gimbâŋe hepunmâ gem gem Yesuŋe hin makyeŋgiep, “Âuren kulem ektâi aregât luâk bo makyeŋgim manbei. Nâmâ luâk akmâ geân nâ momoŋânba agatbian ain âmâ âlepŋe makyeŋgiwei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hain dâmbo den are nâŋgâm kinmâ magaŋgi goaŋgi akmâ hin dâyi, “Wangât golâ akmâ momoŋânba agatbian dâp.” dâm ");
INSERT INTO tim_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yesu hin aikoyi, “Mosegât den kârikŋe makmâ miawakmai arekŋe hin dâmai, “Elia togowiap.” dâmai are wangât hainâk dâmai?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","hin makyeŋgiep, “Elia bundâk togom siâ me siâ mem hulaŋ gulaŋ akbiap. Aregât Anutuŋe makto kulemgoep hin tatâp, nâ luâk akmâ geân nâŋgât akmâ bikŋande hâkâŋ nekbiâ hâk hilâlâm manbian kulemgoep. ");
INSERT INTO tim_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ulikŋân Anutuŋe propete makyeŋgimbo kulem kulemgoyi tatâp are den bunŋe. Elia emelâk lâuwâŋe togoep gârâmâ luâk in manmai irekŋe ukenyeŋaet akmâ bâleŋe agaŋi. Anutuŋe makto kulemgoyi are hain agaŋi.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gimbâŋânba gem metem hoŋ bawalupŋe bikŋe yeŋgâlân togom yegi. Akto luâk âmbâle dondâŋe turuŋyekmâ kinbiâ Mosegât den kârikŋe makmâ miawagi arekŋe Yesugât hoŋ bawalupŋe olop den bao guto magaŋgim peiyekmâ kinbiâ Yesu akto hoŋ bawalupŋe bikŋe yâkŋe gem yegi. ");
INSERT INTO tim_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gem yekbiâ luâk âmbâle dondâ turuŋyekmâ kili arekŋe Yesu ge kindo ekmâ sân sân mem pârigim togom Yesu maŋganli. ");
INSERT INTO tim_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Maŋganbiâ Yesuŋe hin dâep, “Ye wan den magaŋgi goaŋgi aktâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hain dâmbo yâk yeŋgâlânba siâŋe hin dâep, “Kembu, nâŋgât nanne sinduk baniara bâleŋande lauŋe mem gisapkombo tatmap. ");
INSERT INTO tim_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hain akmâ tatmâ hilâm ârândâŋ sinduk baniara bâleŋe arekŋe mem kârikŋe ketugumbo yendo lauŋânba tâwut gambo nekamŋe kândiŋ akmâ keiŋe bâtŋe kârikŋe akto yemap. Nâŋgât nanaŋ hain akmap aregât kewugum togom hoŋ bawalupge ulityeŋgiân, “Sinduk baniara bâleŋe ire walaŋŋet.” dâre walaŋberâm âsimbiâ bo aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hain dâmbo Yesuŋe hin makyeŋgiep, “Ye wangât hanyeŋande bo nâŋgâniŋmâ kepilâmai? Nâ ye olop sopŋe sopŋe manmâ sokom katyekbian mon? Bâin. Nanaŋ are mem nâŋgâlân ga.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hain dâmbo luâk sigan are Yesugâlân mem âgâmbiâ sinduk baniara bâleŋe arekŋe Yesu ekmâ dowâk luâk sigan are mem hâkokombo hânân ge purik gurik akmâ yendo lauŋânba tâwut gem yiep. ");
INSERT INTO tim_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Hain akmâ yendo Yesuŋe eweŋe hin aikoep, “Sop amuten miawagaŋep.” dâmbo hin dâep, “Nanaŋânbak miawagaŋdo hinâk akmâ gaep. ");
INSERT INTO tim_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Akto sinduk baniara bâleŋe irekŋe nanne hilip aguâk dâm kâlâwân me tuân hâkokombo gewerâm akmap aregât Yesu gâ kârikge tatgiŋdâp me bo? Tatgiŋdâp akto netgât okot nâŋgâm tânnetku.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Hain dâmbo hin magaŋep, “Wangât kârikŋe tatgiŋdâp me bo dâm han lâuwâ akmâ ainuguât? Aregât makgiŋdere nâŋgâ. Luâk siâ nâŋgâniŋmâ kepilâmap are tângore bunŋe miawagaŋmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hain dâmbo ainâk luâk sigan aregât eweŋande humoâk konmâ hin dâep, “Biwine getek gâŋgâlân katân gârâmâ tânnugumenâ gâŋgâlân bunewâk kârikŋe katberân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hain dâmbo luâk âmbâle dondâ togom mendugumbiâ yekmâ aregât dowâk sinduk baniara bâleŋe walaŋberâm hin magaŋep, “Sinduk baniara bâleŋe gâŋe luâk ondopyeŋe akto elewetyeŋe mem bâlimat aregât makgiŋdere nâŋgâ. Agatmâ ari. Siâkâ purik katmâ lâuwâŋe luâk iregât kautŋe bo mem gulipkowen.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hain dâmbo sinduk baniara bâleŋe arekŋe kârikŋeâk kamboŋmâ luâk sigan are tâlim pando mom hin pâlâmŋe yendo ariep. Hain akmâ arimbo luâk âmbâleŋe are ekmâ hin dâyi, “Bunŋe mondâp.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesuŋe luâk sigan are bâtŋân mem oloŋdo agatmâ kilep. ");
INSERT INTO tim_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nanaŋ are agatmâ kindo arewa emelan âgâmbo hoŋ bawalupŋande pumân aikom hin dâyi, “Nen wangât watberâm âsienŋe bo aktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hain dâmbiâ hin makyeŋgiep, “Walaŋberâm âmâ kinmâ ain Anutu ulilaŋmâ âmâ âlepŋe walaŋbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Akto arewa arim Galilaia hân ewangim ain âmâ hoŋ bawalupŋe ikiŋaet pat makyeŋgiwerâmbo aregât yoŋâk ariyi. ");
INSERT INTO tim_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Arim manmâ dâwân makyeŋgim hin dâep, “Siân âmâ luâk siâŋe gasalupne kewuguyekto luâk akmâ geân nâ mem nugumbiâ mombian. Akto hilâm âi meme âlâwu akto ain momoŋânba agatbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hain dâmbo den keiŋaet pâpkom aikowerâm hamewagi. ");
INSERT INTO tim_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Hain akmâ Kapanaum arim arim hutŋe siân hoŋ bawalupŋande yeŋeâk magaŋgi goaŋgi akmâ hin dâyi, “Nengât humonenŋe âmâ niŋande akbiap?” hain dâm yeŋeâk papalagi. Hain akbiâ âmâ emetŋân tatmâ hin aiyeŋguep, “Dâwân wangât dâm magaŋgiâi?” dâmbo aŋun aŋgim yân kamilem tali. ");
INSERT INTO tim_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hain akmâ tatbiâ ge tatmâ hoŋ bawalupŋe mendugu yekmâ hin makyeŋgiep, “Siâŋe Anutugât dewunŋân luâk kautŋe manberân dâm âmâ hârok yeŋgât amukyeŋân manmâ hâkŋe mendo gembo hoŋ bawayeŋe akto Anutuŋe ekto ârândâŋ akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hain dâm nanaŋ bâlensiâ siâ hutyeŋân katmâ bâtŋande mem kinmâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Luâk siâŋe nanaŋ ire hinare ekmâ tângowiap âmâ nâ tânnuguwiap aktâp. Dâ areâk bo. Yâkŋe nâ akto huŋgun niŋep net tân netkumap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Akto Yohaneŋe Yesu hin magaŋep, “Humo, nen luâk siâŋe gâŋgât kotge konmâ sinduk baniara bâleŋe watyekto ekmâ nen olop bo manmapgât makmâ hâreyion.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Hain dâmbo Yesuŋe hin dâep, “Hain bo akbei. Siâŋe nâŋgât kotne konmâ kulem membiap hain arekŋe gain gain akmâ nâŋgât owâiŋeâk makmâ bâliwiap? ");
INSERT INTO tim_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Akto âinenŋe bo mem bâliwiap arekŋe gala tân nenguwiap. ");
INSERT INTO tim_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amâ luâk siâŋe Anutuŋe huŋgun niŋep nâŋgât hoŋ bawa mandâi ye tân yeŋguwerân dâm tu hâgâm yeŋgiwiap amâ lau loko loko ya akbiap aregât Anutuŋe hâuŋe waŋbiap. ");
INSERT INTO tim_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Akto luâk siâŋe nanaŋ biwiyeŋe nâŋgâlân katmai are yeŋgâlânba konokŋe bâliwerâm hâkŋe hâkŋe hain akto gâuk, siâŋe kât humo dondâ hanŋân imbogoaŋmâ haru bâtgumân hâkokombo dâine arekŋe âmâ siâ me siâ owâiŋe miawagaŋbop. ");
INSERT INTO tim_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Dâ bâtge arekŋe kambiamge oloŋdo bâleŋe akbiat âmâ bâtge hârem panben. Dâ wan âlepŋe? Bâtge konok umatŋân manmâ manman âlepŋân ariwai me bâtge lâuwâ âlepŋeâk manmâ mom âmâ kâlâwân manbiat? ");
INSERT INTO tim_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Amâ hemem kâlâp bo bokmâ âgâwiap ain naneyeŋe bo mombiap. Dâ kâlâp bo bokbiap. ");
INSERT INTO tim_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Akto keigande kambiamge oloŋdo bâleŋe akbian dâwiat gârâmâ aregât keige hârem panben. Wan âlepŋe? Keige konogâk manmâ manman âlepŋân ariwai me keige lâuwâ lâuwâ âlepŋe manmâ mom âmâ kâlâwân manbiat? ");
INSERT INTO tim_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Amâ hemem kâlâwân naneyeŋe bo mombiap. Dâ kâlâp amâ bo bokbiap. ");
INSERT INTO tim_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dâ dewungande bâleŋaet paŋgoŋân kat gekberâmbo âmâ mem hârem panben. Gâ dewunge konok manbiat âmâ Anutugât amukŋân ariwen amâ âlepŋe. Dâ dewunge lâuwâ lâuwâ âlepŋe manmâ mom âmâ kâlâwân manbiat amâ bâleŋe. ");
INSERT INTO tim_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Amâ hemem kâlâwân naneyeŋe bo mombiap. Dâ kâlâp bo bokbiap. ");
INSERT INTO tim_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Luâk hârok kâlâp kâtembe olowâk miawakyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Akto kâtembe are ukenŋe gârâmâ bâlimbo âmâ gain gain aktenŋe kârikŋeŋe lâuwâŋe miawakbiap? Amâ bo. Aregât ye kâtembe ukenŋe hinare akmâ manmâ galagât agaŋgi goaŋgi akbiâ biwiyeŋe sândugewiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu arewa togom Yudaia hânân Yodaŋ tu biken togoep. Togom ain mando luâk âmbâle dondâ yâkgâlân togombiâ akmâ malep hainâgâk den totokom makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hain akto Parisaio luâkŋe dop koaŋberâm aregât hin magaŋi, “Luâk siâŋe âmbenŋe hepundo nengât den bâliwiap me bo?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hain dâmbiâ den hâuŋe hin makyeŋgiep, “Moseŋe ulikŋân aregât den gain gain makmâ miawak yeŋgiep?” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","hin dâyi, “Siâŋe âmbenŋe hepunberâm âmâ kulem esenŋe kulemgom waŋmâ watbiap. Moseŋe aregât nâŋgâ nengiep.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hain dâmbiâ Yesuŋe hin dâep, “Moseŋe ye hanyeŋe kârikŋaet akmâ den kârikŋe ire kulemgoep. ");
INSERT INTO tim_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dâ Anutuŋe ulikŋân hân me himbim me wan me wan kotŋe hârok ketugum luâk âmbâle katyelegep ");
INSERT INTO tim_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","aregât luâk siâŋe memeŋe eweŋe hepun yelekmâ âmbenŋe olop manbiandat. ");
INSERT INTO tim_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Hain akmâ hâk me biwiyetŋe konogâk akmâ manbiandat. Den hain yendâpgât yâk lâuwâ bo konogâk akmâ mandat. ");
INSERT INTO tim_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutuŋe mem mendugu yelegepgât luâkŋe bo mem potat yelekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hain dâmbo arim metembiâ purik katmâ togom emelan âgâmbo hoŋ bawalupŋande hin magaŋi, “Hinŋe makyeŋgiât are den keiŋe gain gaingât?” dâmbiâ hin dâep, ");
INSERT INTO tim_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","“Luâk siâŋe âmbenŋe hepunmâ siâ membiap âmâ yâk âmbâle aregât hâkâŋ agaŋmâ mem bâlim dosa humo akbiap. ");
INSERT INTO tim_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dâ âmbâle siâŋe luâkŋe hepunmâ siâ membiap âmâ yâkŋe dewati dewatiyetŋe hârewiap aregât dosa humo membiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Akto luâk âmbâle bikŋande Yesugâlân nanaŋlupyeŋe meyekmâ arimbiâ bâtŋande mem howaiyegâk gât lokoyekmâ ariyi. Hain akbiâ hoŋ bawalupŋande watyekberâm akbiâ Yesuŋe nâŋgâmbo bâlimbo hin dâep, ");
INSERT INTO tim_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","“Ye hepunbiâ nanaŋ are nâŋgâlân togoŋet. Ye bo gangerâ yekŋet dâŋet. Nanaŋ hain arekŋe âmâ Anutugât amukŋân manmai. ");
INSERT INTO tim_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aregât makyeŋgire nâŋgâŋet. Nanaŋ hin arekŋe akmai âmâ luâk siâŋe areyeŋgât dop hainare akmâ Anutugât welam bo gangerâwiap âmâ Anutuŋe damunŋe bo akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hain dâm nanaŋ are mem menduguyekmâ yâk yeŋgât Anutu ulilaŋep. ");
INSERT INTO tim_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Akto arewa arim mando dâwân luâk siâŋe pârigim togom kâŋgom tatmâ hin aikoep, “Humone, gâmâ âlepŋe amboŋe. Nâ agak meme gain hinare akmâ âlepŋe aktere Anutuŋe makto âmâ kârikŋe manmâ âgâwian?” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","hin magaŋep, “Âlepŋe amboŋe âmâ Anutu konok. Gârâmâ gâŋe âlepŋe amboŋe dâm makniŋdât aregât den makmakgaet damun akben. ");
INSERT INTO tim_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Akto gâŋe den ainuguât aregât hâuŋe hin makgiŋdere nâŋgâ. Gâ Anutuŋe den kârikŋe kalep are nâŋgâmat me bo? Gâ kuk bo akben. Âmbenge bo hepunben. Kâmbu bo akben. Gâ siâgât hiaŋgi den bo makben. Siâŋe wan me wan giŋdo dop hainâk waŋmenâ ârândâŋ akbiap. Akto memege ewege yetgât lau lokowen.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hain dâmbo luâk arekŋe hin dâep, “Humo, nâ are nanaŋânbak akmâ gaman.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hain dâmbo Yesuŋe ekmâ yâkgât okotŋe nâŋgâ aŋmâ hin magaŋep, “Konok tatâp are akben. Amâ hin. Gâ arim âmâ ito sikum tatgiŋdâp are potatmâ luâk umburuk yeŋgimenâ nâ olop ariwaet. Gârâmâ aregât hâuŋe hâmbâi Anutuŋe giŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hain dâmbo den are nâŋgâm siâ siâ dondâ yeaŋep aregât nâŋgâm biwiŋe umatŋe akto gem ariep. ");
INSERT INTO tim_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Arimbo purik katmâ hoŋ bawalupŋe yekmâ hin makyeŋgiep, “Luâk sikumdâŋe Anutugâlân arienŋe damun nenŋe agâk dâm ariwerâm âi humo membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Hain dâmbo nâŋgâm sân sân membiâ totokom hin makyeŋgiep, “Luâklupne makyeŋgire nâŋgâŋet. Luâk siâŋe Anutuŋe damunne agâk dâm âmâ biwiŋe Anutugâlân katberâm akmâ âi humo membiap. ");
INSERT INTO tim_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bau siâŋe piŋgi dâpŋânba gewopgât âmâ dâp bo yendâp. Hainâk luâk ito sikumyeŋe humo olopŋe Anutugât pat nâŋgâwerâm akbai amâ dâp bo miawakyeŋgiwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hain dâmbo nâŋgâm sân sân mem hin magaŋgi goaŋgi akmâ dâyi, “Ya maktâp aregât niŋande âmâ âlepŋe Anutugât manman âlepŋân ariwiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hain dâmbiâ yekmâ hin makyeŋgiep, “Anutugât manman âlepŋân ariwaigât luâk nâŋgâ nâŋgâyeŋe watbiâ bo meawakmap. Anutu konokŋe wan me wan mem miawakbiapgât bo pâpkomap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hain dâmbo Petoroŋe den are nâŋgâm hin dâep, “Nâŋgât? Nen âmâ siâ siâ nenŋe hârok hepunmâ metem âmâ gâ olop manmaen.” ");
INSERT INTO tim_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Hain dâmbo hin magaŋep, “Nâ bundâk makbe. Siâŋe emet me emiteu me mama gari me meme ewe nanaŋ me âi kalam me wan me wan are nâŋgât dennaet aregât akmâ hepun yekbiap aregât hâuŋe hâmbâi Anutuŋe waŋbiap. ");
INSERT INTO tim_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Waŋdo sambe humo dondâŋe membiap. In hânân emet opmân emi teu akto mama gari meme ewe nan barat me âi kalam siâ me siâ are hâk hilâlâm kakŋân miawagaŋbiap. Dâ beirâ maleine âmâ manman kârikŋe mem manbiap. ");
INSERT INTO tim_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dâ siâŋe hinŋe hâkŋe mem agatbiap are âmâ hâmbâi Anutuŋe mem hamiŋângen katbiap. Dâ siâŋe hinŋe hâkŋe mem gewiap are âmâ Anutuŋe hâmbâi tângombo ulik gulik akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuŋe Yerusalem kepian âgâwerâm akmâ yâkŋe soŋ akmâ arimbo hoŋ bawalupŋande are ekbiâ dâtŋe agep. Dâ hamiŋângenba luâk âmbâle watmâ togoyi arekŋe âkâ hamewagi. Hain akmâ arimbiâ Yesuŋe hoŋ bawalupŋe keiân lâuwâ are yoŋâk mendugu yekmâ wan me wan miawak aŋbiap aregât den hekat yeŋgim hin dâep, ");
INSERT INTO tim_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nen Yerusalem kepian âgâenŋe ain mandenŋe âmâ luâk akmâ geân nâ siâŋe sumbe kat kat luâk areyeŋgât humomolupyeŋe akto Mosegât den kârikŋe makmâ miawakmai are kewuguyekto arekŋe togom menekmâ kondenŋe moâk dâm Roma yeŋgâlân katnekbai. ");
INSERT INTO tim_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hain akmâ den hembalik akniŋmâ tâwut nugum lâwinân nugumbiâ hâk hilâlâm nâŋgâm mombian. Hain akniŋbiâ mondere hannugumbiâ hilâm âlâwu akto golâ akmâ agatbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Akto sop ain Sebedaio nanlogâtŋe Yakopo akto Yohane, yâkŋe Yesugâlân arim hin dâyiat, “Humonetŋe, net wan siâgât ulit giŋberâm aktet are netkiwerât me bo?” dâmbela hin makyetkiep, ");
INSERT INTO tim_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Aregât keiŋe makniŋbela nâŋgâwe.” dâmbo hin dâm magaŋiat, ");
INSERT INTO tim_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Sop siân pagaleŋe olop togom luâk âmbâle hârok damunyeŋe akbialân net menelekmenâ netŋe luâk âmbâle hârok damunyeŋe aktetŋe gâŋe âmâ nen hârok damun nenŋe akbiat.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hain dâm ulilaŋbela hin makyetkiep, “Yet aregât keiŋe pâpkom hain maktat. Nâ tu nembian are yet âlepŋe nembiandat mon? Me tu utunŋande puliakbian are yet âlepŋe puliakbiandat mon?” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","hin magaŋiat, “Âlepŋe aktetŋe miawaknetkiwiap.” dâmbela hin makyetkiep, “Nâ tu nembian are yet bundâk nembiandat. Akto tu puli puli are miawakniŋbiap arekŋe yet gai miawakyetkiwiap. ");
INSERT INTO tim_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gârâmâ biken biken ginnân tatbiandatgât amâ nâŋgât pat bo. Anutuŋe nâŋgâm kepilâm yetkiep. Irawot Humoŋe damunyeŋe akbiap sop ain Anutuŋe luâk lâuwâ nâŋgâm kârikŋe yetkimbo nâŋgât amuknân kinmâ wan me wangât damun akbiandat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hain dâm makyetkimbo hoŋ bawalupŋe bikŋande yâk yetgât den are nâŋgâmbiâ ârândâŋ bo agep. ");
INSERT INTO tim_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Akto Yesuŋe hoŋ bawalupŋe mendugu yekmâ hin makyeŋgiep, “Hângât luâk kembuŋe luâk damunyeŋe akmâ âmâ hoŋ bawalupŋe meyekbiâ manmai are âmâ nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dâ yeŋgâlân âmâ hain bo miawakbiâp. Yeŋgâlânba siâŋe luâk kotdâ akberân dâm galalupŋe yâk yeŋgât hoŋ bawa manbiâp. ");
INSERT INTO tim_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Gârâmâ yeŋgâlânba siâŋe Anutuŋe nekto ârândâŋ agâk dâwiap âmâ galalupŋe yeŋgât hoŋ bawa akmâ manbiâp. ");
INSERT INTO tim_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hoŋ bawalupnande tân nuguŋet dâm aregât bo geân. Hoŋ bawa âi mem luâk âmbâle dondâ are yeŋgât dosa bo akyeŋgiwiapgât mombian aregât Ewenande huŋgun niŋdo geân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu akto hoŋ bawalupŋe Yeriko kepian âgâyi. Âgâm arewa arimbiâ hami yeŋângenba luâk âmbâle dondâ ariyi. Arimbiâ dâp ginŋân luâk dewunŋe bokbokŋe puligât ulityeŋgim talep. Luâk are kotŋe Batimaio yâkgât eweŋe kotŋe Timaio, yâkŋe dâp ginŋân tatmâ ulityeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Akto Yesu Nasarete gâtŋe arekŋe togoepgât den are nâŋgâm konmâ hin dâep, “Yesu, gâ Dawidigât hakuŋe nâŋgât okotge agâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hain dâm kondo luâk âmbâle togoyi arekŋe nâŋgâm hâkâŋ akmâ den yoŋâk dâyi. Hain dâmbiâ yâkŋe denyeŋe bo nâŋgâm hainâk kolep, “Dawidigât hakuŋe nâŋgât okotge agâk.” ");
INSERT INTO tim_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","dâmbo nâŋgâm dâwân kinmâ hin dâep, “Magaŋbiâ gulâk.” dâmbo dewunŋe bokbokŋe are konmâ hin dâyi, “Gogondâp gârâmâ kambiamge sândugembo agatmâ ari.” ");
INSERT INTO tim_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hain dâmbiâ nâŋgâm ainâk sâŋgum kakŋân gâtŋe are hulaŋmâ katmâ agatmâ yâkgâlân gulep. ");
INSERT INTO tim_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Guto hin dâm aikoep, “Gain gain akgiŋbegât nâŋgât?” dâmbo dewunŋe bok bokŋe arekŋe hin dâep, “Humo, âlepŋe ek dâmenâ dewunne hulaŋ akniŋdo âlepŋe ekbe dâm aregât ulitgiŋdân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Hain dâmbo hin magaŋep, “Gâŋe biwige nâŋgâlân katât aregât heŋgem guguwerân.” dâep. Hain dâmbo ainâk dewunŋe hulaŋ akto Yesu olop ariyi. ");
INSERT INTO tim_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Arim kepia kotŋe Betepage akto Betania ewangi yelekmâ arewa arim Yerusalem ewumâk akto Oliwa gimbâŋân togoyi. Ain togom Yesuŋe hoŋ bawalogâtŋe lâuwâ huŋgun yetkim hin dâep, ");
INSERT INTO tim_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Kepia ewumâk tatâp âuren âgâm arim ain doŋgi nanŋe hikombiâ kindâp are ekberat. Amâ doŋgi nanŋe are luâkŋe kakŋân bo tatmai irakŋe are ekmâ hulaŋmâ mem togoet. ");
INSERT INTO tim_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Hulaŋbela âmâ luâk siâŋe, “Wangât hulaŋdat?” dâmbo hin dâm magaŋet, “Humonetŋande iregât dâm huŋgun netkiâp. Gârâmâ mem arietŋe âi bo akto benŋe mem purikatbaet.” yet hain dâwerat.” ");
INSERT INTO tim_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesuŋe hain dâm huŋgun yetkimbo hoŋ bawalogâtŋe lâuwâ arekŋe arim doŋgi nanŋe emet siâgât hâŋgiân hikombiâ kindo ekmâ hulaŋiat. ");
INSERT INTO tim_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tâk hulaŋbela âmâ luâk kili arekŋe yelekmâ hin dâyi, “Woe, niŋande dâmbo hulaŋdat?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesuŋe den makyetkiep a makbela nâŋgâm âlepŋe mem ariet dâmbiâ mem ariyiat. ");
INSERT INTO tim_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hain akto Yesugâlân mem arim sâŋgum kakŋân luguakmini are kakŋân katbiâ yâkŋe âgâ talep. ");
INSERT INTO tim_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Âgâ tato luâk dondâŋe sâŋgum kakŋân luguakmini are dâwân leŋgaim ariyi. Dâ bikŋande âmâ kalamânba siâ siâ esenŋe ligim katmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Luâk âmbâle dondâ olop ariyi arekŋe âmâ hin koli, “Woe, heŋgemnengumapŋe kembugât laugât togonengiât aregât dâm âlepŋe akgiŋne. ");
INSERT INTO tim_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hakunenŋe Dawidi yâkŋe âmâ hân humo akto luâk âmbâle dondâ damunyeŋe agep are hainâk gâŋe damunnenŋe akbiat. Gâŋe damunnenŋe akbiatgât mâruŋe akten. Anutu kotŋe mem agatne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Hain agaŋbiâ Yerusalem kepian togom sumbe kat kat emetŋân âgâep. Âgâm siâ siâ hârok yekmâ metem emet eŋgaiŋe akto gem hoŋ bawalupŋe keiân lâuwâ meyekto Betania kepian âgâyi. ");
INSERT INTO tim_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Betania kepian âgâm yem kinbiâ hauŋdo yâk olop gem Yesuŋe sotgât mopŋe agumbo ");
INSERT INTO tim_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","lâwin siâ lowot hainare esenŋe olop kâlewângen ekmâ koaŋe yendâp me bo dâm ari ekto bo agep. Bunŋe sopŋe boâk akto esenŋeâk kilep. ");
INSERT INTO tim_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hain ekmâ lâwin aregât hin dâep, “Lâwin iregât koaŋe lâuwâŋe bo yembiap.” dâmbo hoŋ bawalupŋande nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Akto Yesu olop Yerusalem kepian âgâyi. Âgâmbiâ Yesuŋe sumbe kat kat opmânŋân âgâm luâk âmbâleŋe kotŋe siâ siâ katmâ aŋgim kili are watyekmâ siâ siâyeŋe me kembâ welamŋe me puli kat kat welamŋe mem kâwulep. ");
INSERT INTO tim_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Opmânân siâ me siâ agaŋgiyi are watyekmâ hin makyeŋgiep, “Sumbe kat kat opmânân inba wan me wan bo mem aŋgi goaŋgi akmâ bam gutŋet. Ye ariŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hain dâm âmâ wan me wan hekat yeŋgiwerâm hin dâep, “Anutuŋe makyeŋgimbo kulemgoyi are hin tatâp, “Nâŋgât emet amâ wangât kindâp? Luâk âmbâle hân hârok nâ olop tatmâ magaŋgi goaŋgi akbaengât kindâp.” Miti kulem hainâk yendâp are hâkâŋ akmâ hepunbiâ bâleŋe akmai are yeŋgât emet hainare aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hain dâmbo sumbe kat kat luâk akto Mosegât den makmâ miawagi luâk arekŋe ekmâ, “Gain gain akmâ kondenŋe mombiap.” dâm magaŋgiyi. Luâk âmbâle hârok Yesugât den âlepŋe aregât nâŋgâmbiâ dâtŋe akto aregât sumbe kat kat luâk me Mosegât den kârikŋe makmini are luâk âmbâle dondâ Yesugât den âlepŋe nâŋgâm hamewakmai. Aregât, “Gain gain akmâ kondenŋe mombiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Emet dâgâmbo Yesu kepia humo hepunmâ ariep. ");
INSERT INTO tim_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yem kinbiâ hauŋdo âmâ dâwân ariyi. Akto arim arim lâwin magep are momberâm kândârâŋân bak âgâm ululun kârân kindo egi. ");
INSERT INTO tim_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Hain kindo ekmâ Petoroŋe Yesuŋe magep are nâŋgâm Yesu hin magaŋep, “Wei, Apo ek. Lâwin den umatŋe kakŋân kalen ina ululun dâm kindâp.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","hoŋ bawalupŋe hin makyeŋgiep, “Ye den bunŋe hin makyeŋgire nâŋgâŋet. Ye biwiyeŋe Anutugâlân katŋet. ");
INSERT INTO tim_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Luâk siâŋe hân gimbâŋe ekmâ hin dâwiap, “Gimbâŋe are hogoakmâ haruân geâk.” dâm âmâ biwiŋe Anutugâlân katmâ han lâuwâ bo akmâ nâŋgâm heŋgemgom makto âmâ are bunŋe miawakto gimbâŋe are hogoakmâ gewiap. ");
INSERT INTO tim_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aregât hin makyeŋgiwe. Yeŋe siâ me siâgât nâŋgâm Anutu ulilaŋmâ are emelâk miawaknengiâp dâm han lâuwâ bo akbiâ âmâ are âmâ Anutuŋe yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dâ yeŋe ulilaŋberâm kinmâ, luâk siâŋe bâleŋe akgiŋep aregât dosa kutigitân dâmbiâ âmâ Eweyeŋande hainâk yeŋgât dosa hepunbiap. ");
INSERT INTO tim_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Dâ yeŋe luâk yeŋgât dosa mem gangerâwai âmâ hainâk yeŋgât dosa mem gangerâwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hain dâm arewa Yesu akto hoŋ bawalupŋe arim Yerusalem kepian togom sumbe opmânŋân âgâmbiâ sumbe kat kat luâk areyeŋgât humomolupyeŋe akto Mosegât den kârikŋe magi luâk are akto Yuda yeŋgât damun yâkŋe yâkgâlân togom hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Gâ wan me wan akmat are niŋaet lau lokom kinmâ akmat? Niŋande hain akdâm makgiŋdo akmat?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","hin dâm makyeŋgiep, “Nâ den konok aiyeŋgure makniŋbiâ âmâ nâkâ hainâk niŋaet laugât wan me wan akman aregât hâuŋe makyeŋgiwerân. ");
INSERT INTO tim_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohaneŋe tu puli âi miep a niŋaet laugât hain akminep. Anutugât laugât me luâk yeŋgât laugât akminep aregât makbiâ nâŋgâwe.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hain makyeŋgimbo yâkŋe hin dâm magaŋgi goaŋgi agi, “Nen Anutugât lau lokominep dâenŋe âmâ yâkŋe hin maknengiwerâp, “Woe, aregât wangât denŋe bo nâŋgâm lokoyi.” dâmbo aŋun aŋgiwâen. ");
INSERT INTO tim_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dâ, “Luâk yeŋgât lau lokominep.” dâenŋe luâk yu kindâi irekŋe Yohane propete dâm kuk nengiwâi. Aregât gain gain magaŋberen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hain nâŋgâm kinmâ Yesu hin magaŋi, “Yohane niŋaet laugât hain akminep nen bo nâŋgâen.” dâmbiâ yâkâ hainâk dâep, “Nâkâ hainâk niŋaet laugât iren wan me wan agân aregât hâuŋe bo makyeŋgiwerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuŋe den ginŋe siâ hin makyeŋgiep, “Luâk siâŋe hân siân tâk kotŋe waiŋ are kâmetmâ metem lope dâgâep. Akto waiŋ tuŋe pipikowaengât dâm kondo ketugum heŋgemgom damun yeŋgât emet mem âi kalam hârok ketugum metem hoŋ bawalupŋe hin makyeŋgiep, “Kalam ire damunŋe akŋet.” dâm hân siângen ariep. ");
INSERT INTO tim_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Arim manmâ sop kâlep mando sot bunŋe akto âi luâk siâ sot bunŋe bikŋe meâkgât huŋgun aŋdo ariep. ");
INSERT INTO tim_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Arimbo damun luâkŋe mem kom watbiâ yân purik kalep. ");
INSERT INTO tim_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Purik kato benŋe amboŋande âi luâk siâ huŋgun aŋdo arimbo kautŋe kom hioŋmâ mem bâliyi. ");
INSERT INTO tim_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Benŋe amboŋande totokom hoŋ bawa siâ huŋgun aŋdo yâk yeŋgâlân arimbo kombiâ moep. Kombiâ mondo amboŋande luâk dondâ huŋgun yeŋgimbo arimbiâ âi damunŋande kuk akmâ bikŋe sâwâ yeŋgum bikŋe momoŋe yeŋguyi. ");
INSERT INTO tim_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Akto kalam amboŋe aregât nanŋe konok malep. Akto amboŋande hin dâep, “Nune nanne okotne nâŋgaŋman aregât huŋgun aŋberân. Huŋgun aŋdere arimbo yâkgât amukŋân manbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hain dâm amboŋande nanŋe huŋgun aŋdo arimbo âi damunŋe nanŋe are ekmâ magaŋgi goaŋgi akmâ dâyi, “Humo nenŋaet nanŋe togoâp. Eweŋe mondo âi hân ire yâkŋe membopgât kondenŋe moâk. Hain aktenŋe âi ire nengât akbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hain dâm mem kombiâ mondo kalam ginŋângen panbiâ yiep. ");
INSERT INTO tim_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Hain akbiâ âi amboŋe are gain gain akbiap? Yâk togom damun are momoŋe yeŋgum damun âlepŋe siânba katyekbiap. Aregât keiŋe makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Anutuŋe propete makyeŋgimbo kulemgoyi yendâp are oyaŋmâ nâŋgâmai me bo? Den are hin tatâp. Emet ketugu ketuguân luâkŋe lâwin siâ ekmâ hâkŋe hâkŋe dâm panbiâ yendo Anutuŋe lâwin are mendo emetgât kunkun kârikŋe agep. ");
INSERT INTO tim_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Are dewunnenŋande ekmâ ire âmâ Humoŋe mem miawaktâp dâm kambiamnenŋe agatmap.” ");
INSERT INTO tim_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuŋe Anutugât den tâmbâŋe dâmbo Yuda yeŋgât humomolupyeŋande magaŋgi goaŋgi akmâ hin dâyi, “Den ire nen dop nenguwerâm maktâp.” dâm kambiamyeŋe bâlimbo aregât mem kala busi kâlegen ain katberâm agi. Hain agi arekŋe luâk âmbâle dondâ yeŋgât hamewakmâ hâumgom yân hepunmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hepunmâ arim Parisaio luâk bikŋe akto Herotegât hoŋ bawalupŋe bikŋe Yesugât denŋe hami kom mâŋgi agaŋŋetgât huŋgun yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Huŋgun yeŋgimbiâ togom hin magaŋi, “Humo, gâŋgât keige nâŋgâen. Gâ hiaŋgi den bo makmat. Bunŋeâk makmat. Akto horat gorat bo akmat. Gâ luâk hârok Anutugât dâp âlepŋe makmâ hekat yeŋgimat aregât makmenâ nâŋgâne. Nen Roma luâk siâ damun nenŋe kotŋe Sisa are puli waŋmaen are âlepŋe me bo? ");
INSERT INTO tim_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Puli waŋbaen me bo?” dâyi. Hain dop kombiâ biwiyeŋe keiŋe ekmâ nâŋgâm hin makyeŋgiep, “Ye nâ denne hami kom katmâ dop nuguâi me? Puli koaŋe siâ mem niŋbiâ ekbe.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hain dâmbo waŋbiâ mem agatmâ hekatyeŋgim hin dâep, “Puli ire ekŋet. Iregât otneŋe akto kot ire niŋaet?” dâmbo yâkŋe dâyi, “Romagât damun nenŋe kotŋe Sisa yâkgât otneŋe.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","hin makyeŋgiep, “Wan me wan Sisagât are âmâ humo purik katmâ Sisa waŋbei. Dâ wan me wan Anutugât are âmâ purik katmâ Anutu waŋbei.” dâep. Hain dâm makyeŋgimbo den are nâŋgâmbiâ dâtŋe akto bâtyeŋe dâtyeŋân igim kinbiâ hanyeŋe undup agep. ");
INSERT INTO tim_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Akto den makmak luâk siânba kotyeŋe Sadukaio luâk are togoyi. Luâk arekŋe momoŋânba luâk bo agatmai dâmini. Yâkŋe togom hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Humo, Moseŋe ulikŋân hin dâm kulemgoep are oyaŋmaen, “Luâk siâŋe âmbâle mendo nanaŋ bo miawakto mondo emiŋande kambut mem teuŋaet pat nanaŋ mem miawakbiap.” Moseŋe hain kulemgoep aregât hin dâne. ");
INSERT INTO tim_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Emi teu nâmbulân lâuwâ mali. Hain manmâ ulikŋân teuyeŋande âmbâle mem nanaŋ bâlâk manmâ moep. ");
INSERT INTO tim_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mondo emiŋande kambut are mem hainâgâk nanaŋ bâlâk manmâ manmâ mondo emiŋe siâŋe âmbâle kambut areâk miep. ");
INSERT INTO tim_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Emiteu nâmbulân lâuwâ arekŋe âmbâle konok are mem nanaŋ bâlâk manmâ mom meteyi. Bâiŋe kambutyeŋe are hainâgâk moep. Akto luâk nâmbulân lâuwâ are hârogâk âmbâle konok areâk mem mom meteyi. ");
INSERT INTO tim_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gârâmâ sop bâiŋân agatbaiân âmbâle are niŋaet âmbenŋe akbiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hain aikombiâ yâkŋe hin makyeŋgiep, “Ye Anutuŋe makyeŋgimbo kulemgoyi are akto Anutugât kârikŋeŋaet pâpkomai aregât nâŋgâm hilipkom hain dâmai. ");
INSERT INTO tim_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Luâk me âmbâle momoŋânba agatmâ yâk himbimân aŋelo mandâi hainare akmâ luâk âmbâle meak meak are hepunmâ yân manbai. ");
INSERT INTO tim_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gârâmâ Anutugât denân momoŋânba agat agat aregât keiŋe makyeŋgire nâŋgâm heŋgemgoŋet. Den ire Moseŋe hin kulemgoep. Mose yâk lâwinân kâlâp ululunŋe miawakto ekmâ arimbo Anutuŋe hin magaŋep, “Nâ Abraham akto Isaka akto Yakopo yâk yeŋgât damunyeŋe akman.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anutuŋe hain dâep aregât ye wangât, “Luâk mom âmâ hâkŋe akto otneŋe hârok momo yânŋe akmap.” dâmai? A bo. Luâk âmbâle ulikŋân manmâ biwiyeŋe Anutugâlân katmâ manmâ moyi. Dâ otneyeŋe âmâ golâk mandâi.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Akto den nâŋgâ nâŋgâ luâk siâŋe togom yekmâ kindo Sadukaio luâkŋe aikombiâ Yesuŋe den hâuŋe âlepŋe makyeŋgimbo ekmâ Yesu hin aikoep, “Anutuŋe den kârikŋe kalep ain gâtŋe wan soŋ lokowaen.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","hin dâep, “Anutuŋe makto kulemgoyi are bikŋe hin tatâp. Israe yeŋgât hakulupyeŋe ye makyeŋgire nâŋgâŋet. Kembu Anutunenŋe kembu bunŋe yâk konok mandâp. ");
INSERT INTO tim_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yeŋe yâkgâlân biwi kambiamyeŋe me nâŋgâ nâŋgâyeŋe katbei. Yâkgât âi akto den me lau aregâlâk nâŋgâm kârikŋe akmâ hanyeŋe konogâk manbei. ");
INSERT INTO tim_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Akto den siâ hin yendâp. Ye yeŋaet agaŋgimai hainâk luâk siâ agaŋbei. Anutugât den kârikŋe ire kakŋân siâ bo tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hain dâmbo Mosegât den kârikŋe makyeŋgimini areyeŋgâlân gâtŋande hin dâep, “Humo, gâŋe den dâmenâ nâŋgâre ârândâŋ aktâp. Anutu yâk bundâk kembu bunŋe. Yâk konok. Yâk hainare siâ bo mandâp. ");
INSERT INTO tim_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gârâmâ nâ han nâŋgâ nâŋgâ kârikŋe yâkgâlân katbian. Akto nenŋe agaŋgimaen are hainâk siânba akyeŋgienŋe ârândâŋ akbiap. Akto Anutugât sumbe me wan me wan siâ agaŋdenŋe den lâuwâ are bo ewangimap.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hain dâmbo Yesuŋe nâŋgâmbo ârândâŋ akto hin magaŋep, “Gâ Anutugât amukŋân manberâm ewumâk aktât.” dâep. Sop ain luâkŋe Yesu aikowerâm akmâ Yesuŋe den hâuŋe âlepŋe makyeŋgiep are nâŋgâmbiâ umatŋe akto hamewakmâ hepuli. ");
INSERT INTO tim_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuŋe sumbe opmânŋân kinmâ hin dâm aikoep, “Mosegât den kârikŋe makmai are wangât hin dâmai, “Anutuŋe huŋgun aŋdo gewiap are âmâ Dawidigât kâmot are yeŋgât hutyeŋân miawakbiap.” dâmai? Amâ hiaŋgimai. ");
INSERT INTO tim_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Akto ulikŋân Anutugât Heakŋande Dawidi kautŋân mendo hin dâep, Anutu Humoŋe nâŋgât Humone hin magaŋep, “Gâ enemnân togom bâtne bungen tatmenâ gasalupge keigaet amukŋân kâmot katere tâliyekbiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Aregât den keiŋe hin. Dawidiŋe ikiŋe Humo dâm kolep. Aregât âmâ gain gain akmâ yâk âmâ Dawidigât kâmolân gâtŋe miawakbiap dâwai?” dâep. Hain dâmbo kâmot humo arekŋe denŋe nâŋgâmbiâ dâtŋe akto heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sop ain Yesuŋe den dewatim hin makyeŋgiep, “Ye Mosegât den kârikŋe maknengimai are hepun yekbei. Yâkŋe hâkyeŋe mem agat agat akmai. Hain akmâ luâkŋe dâwân nenekmâ, “Woe nâŋgâ nâŋgâ luâk yeŋgât agak meme âlepŋe akmai.” dâŋet dâm aregât sâŋgum kâlep lalakmai. ");
INSERT INTO tim_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Akto areâk bo. Hâkyeŋe mem agatmâ hin akmai. Den opmânŋân me mendugu mendugu opmânŋân luâk âmbâle arekŋe tatmâ nenekmâ egâliaŋ nenekŋet dâm aregât enemyeŋân tatmâ yeŋaet nâŋgâmbiâ âgâmap. ");
INSERT INTO tim_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hain akmâ âmbâi kambut yeŋgât emet akto kotŋe siâ siâ kâmbu memai. Hain akmâ luâk âmbâle bikŋe yeŋgât dewunyeŋân kinmâ den kâkâlep Anutugâlân makmai aregât Anutuŋe hâuŋe bâleŋe yeŋgimbo dowâk hamep akbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuŋe sumbe emetŋân âgâmbo luâk âmbâle dondâ togom puli kat kat kondoân puli katbiâ gembo yegep. ");
INSERT INTO tim_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Hain akbiâ yekmâ tato sikum luâkŋe puli katbiâ giep. Hain akbiâ âmâ âmbâi kambut siâŋe âmâ togom puli gutŋe gilâmŋe lâuwâk kalep. ");
INSERT INTO tim_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Akto Yesuŋe are ekmâ hoŋ bawalupŋe yeŋgondo gutbiâ hin makyeŋgiep, “Imâ bunŋe makbe. Âmbâi kambut umburuk irekŋe âmâ yeaŋdâp are hârogâk katmâ meteâp aregât bikŋe yeŋgât dop ewangiâp. ");
INSERT INTO tim_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bikŋande âmâ humo yeyeŋgimbo bikŋeâk katâi. Dâ âmbâi kambut umburuk ire âmâ talaŋdâp dopŋân hârok katmâ meteâp. Siâ bo talaŋdâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hain dâm sumbe emetŋânba gem ariwerâmbo hoŋ bawaŋe siâŋe hin dâep, “Humo ek. Sumbe emetŋe âlepŋe dondâ kât hamepŋe olowâkŋe ketugum heŋgemgoyi.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","hin magaŋep, “Sumbe emetŋe yu ektâi ire hâmbâi gasalupyeŋande togom hârem gagaim itiŋ gulam ketuguwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu akto hoŋ bawalupŋe gimbâŋe kotŋe Oliwa ain âgâyi. Âgâm âmâ sumbe emetŋe humo are gimbâŋe biken tato egi. Ain tatmâ Petoro, Yakopo, Yohane akto Anderea yâkŋe Yesu ikiŋaet aikom hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Maktât are amuten miawakbiap? Akto den are bunŋe miawakberâm akto ain kulem gain gain hinare miawakbiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hain dâmbiâ hin makyeŋgiep, “Siâŋe nâŋgâ nâŋgâyeŋe hilip kowopgât nâŋgâm manbei. ");
INSERT INTO tim_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Luâk dondâ miawakmâ nâŋgât kolân hâk tunaŋgim hin dâwai, “Nâmâ Anutuŋe huŋgun niŋdo geân.” hain dâmbiâ luâk dondâŋe han gulip akbai. ");
INSERT INTO tim_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Akto den o hilo kot kamboŋ miawakto kukgât pat nâŋgâm hanyeŋe bo bâlim yeugewiap. Hain are miawagâkgât mak makŋe miawakto sop humo dowâk bo miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Akto hânŋe hânŋe kâmot humo bâleŋe akmâ arekŋe gasa akmâ agum walakmâ ariwai. Akto hainâk wâriŋ mendo duwuŋ humo akbiap. Hain akmâ mop humo miawakmâ yembiap amâ hâk hilâlâm nâŋgâwai. Hinŋe maktere nâŋgâi are âmâ umatŋe aregât keiŋeâk miawakto hamiŋân umatŋe dondâ miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ye heŋgem agum manbei. Yeŋgât gasalupyeŋande denân katyekmâ den opmânŋân bugâŋe yeŋguwai. Akto areâk bo. Nâŋgât akmâ luâk humomo yâk yeŋgâlân meyekmâ arimbiâ yâk yeŋgât dewunyeŋân kinmâ nâŋgât den makyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Akto denne hânŋe hânŋe sambelem arim metembo hârok nâŋgâwaiân âmâ sop humo miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Akto gasalupyeŋande hâkyeŋe tunmâ damunlupyeŋe yâk yeŋgâlân me kiap yeŋgâlân meyekmâ ariwaiân âmâ luâk yeŋaet den gain gain den hâuŋe dâwaen dâm nâŋgâmâk bo akbei. Sop ain âmâ den makbai are Anutugât Heakŋande dâm miawakmâ makyeŋgimbo âlepŋe dâwai. ");
INSERT INTO tim_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sop ain âmâ luâk âmbâleŋe hin akbai. Teuŋande emiŋe kiapgâlân katmâ hiaŋdo kombiâ mombiap. Akto eweŋande nanŋe kiapgâlân katmâ hiaŋdo kombiâ mombiap. Luâk âmbâi sisikŋe ewe memelupyeŋe kiapgâlân katmâ hiaŋbiâ nâŋgâmbo yeŋgumbiâ mombai. ");
INSERT INTO tim_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Akto patne lokom manmai aregât luâk hârokŋe yekmâ nâŋgâmbiâ âmâ kukŋe olowâk umatŋe olop manbai. Gârâmâ bikŋande nâŋgât pat mem manbai âmâ Anutuŋe tânyeŋgumbo biwiyeŋe agato ârândâŋâk manmâ âgâwai are âmâ Anutuŋe meyekbiap. ");
INSERT INTO tim_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ye kulem ire oyaŋmâ nâŋgâm heŋgemgowei. Ye manmâ hâkŋe hâkŋe kautŋe bâli bâliŋe olop are bo kin kinŋân kinbiap âmâ ye den ire nâŋgâmbiâ hain miawakto ekmâ nenguwâirâm Yudaia hânângenba pârigim gimbâŋe siân âgâwai. ");
INSERT INTO tim_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Akto kepia ginŋân manbiapŋe emetŋe kâlegen purik katmâ âgâm ito sikumŋe bo membiap. ");
INSERT INTO tim_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Akto âiângenba manbiapŋe kepian arim sâŋgum dâgâmŋe bo membiap. Nuguwâirâm pârigim dowâk gimbâŋe siân ariwiap. ");
INSERT INTO tim_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Akto sop ain âmbâi tepdâŋe me namân gâtŋe olowâkŋe âmâ gain gain akbai? Umatŋe olowâk akbai. ");
INSERT INTO tim_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aregât Anutu hin ulilaŋbei, “Humo umatŋe are tânâk kâlegen bo miawakbiap.” dâwai. ");
INSERT INTO tim_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Akto sop ain siâ me siâ hârok wilâgem poyagem metewiap, dop hainare Anutuŋe luâk liunmâ mâŋgiewân bak bo miawagep. Dâ manmâ gai bo miawakbiap. ");
INSERT INTO tim_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aregât kembuŋe sop are bo dâm hârembo dâine luâk me âmbâle siâ me siâ bo manmâ kârikŋe kinbop. Dâ Anutuŋe ikiŋe kâmotlupŋe yâk yeŋgât akmâ âmâ sop aregât makto tâlâwâk akbiap. ");
INSERT INTO tim_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Anutuŋe hain dâwiap aregât nâŋgâm siâŋe Anutugât hoŋ bawa gewiap are, “Iren nengâlân miawaktâp me yâk indâgen yeŋgâlân miawaktâp.” dâmbiâ âmâ bo nâŋgâwei. ");
INSERT INTO tim_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sop ain hiaŋgi propete siâ me luâk siâ miawakmâ âmâ, “Anutuŋe huŋgun nengimbo damunyeŋe akberâm geyion.” dâm nâŋgât kâmotlupŋe heyeŋgim yeŋgâlân dewatiwaigât âi humo membai. Akto siâŋe miawakmâ nâŋgât kolân hâk tunaŋgim nâŋgât kâmotlupne hilipyeŋguwaigât kulem humo memberâm aregât âi humo membai gârâmâ Anutuŋe ye yekmâ nâŋgât dâtâŋe dâm tânyeŋgumbo aregât hanyeŋe hilipyeŋguwaigât dop bo tatbiap. ");
INSERT INTO tim_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Are boâk miawakto hinŋe makyeŋgiân are nâŋgâm heŋgemgom manbei. ");
INSERT INTO tim_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Umatŋe humo are bo akto sop ain âmâ hândâk humo arekŋe dewutâ hilâm gâtŋe dâgâm yembiap. Akto dewutâ hândâkŋân gâtŋe bo pagalewiap. ");
INSERT INTO tim_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Akto diâ hânân pekmâ gewai. Wan me wan kârikŋe himbimân yendâi are duwuŋ akbai. ");
INSERT INTO tim_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sop ain nâ luâk akmâ geân aregât lâuwâŋe hamandat kakŋân gem pagaleŋe olop kârikŋe akmâ gere nekbai. ");
INSERT INTO tim_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nâŋe aŋelolupne huŋgunyeŋgim hin dâwian, “Hân himbim bâiŋângen arim luâk âmbâlelupne nune dâtâŋe dâman are meyekŋet.” dâm huŋgunyeŋgire ariwai. ");
INSERT INTO tim_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ye lâut kotŋe kâli kak kak are nâŋgâi. Indembo âmâ, “Woe, dewutâ âlepŋe komberâm aktâp.” dâmai. ");
INSERT INTO tim_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hainâk hâmbâi wan siâ miawakbiap are ekmâ nâŋgâwai, are emelâk ewumâk akmâ Kristo togowerâm aktâp dâwai. ");
INSERT INTO tim_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nâ makyeŋgire nâŋgâŋet. Luâk âmbâle yu mandâi ire manbiâk den maktân ire bikŋande ekbai. ");
INSERT INTO tim_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Akto hân himbim âmâ bo akbiandat. Dâ denne irekŋe âmâ yem âgâwiap. ");
INSERT INTO tim_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Akto maktân iregât sopŋe luâk siâŋe bo nâŋgâp. Akto aŋelo himbimân mandâi arekŋe bo nâŋgâi. Akto Anutugât nanŋe nâ bo nâŋgân. Ewene konok yâkŋe nâŋgâp. ");
INSERT INTO tim_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sop amuten wan me wan siâ miawakbiap dâm aregât nâŋgâm heŋgemgom manbei. Ye purik katbian sopŋe bo nâŋgâi. ");
INSERT INTO tim_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Luâk siâŋe emetŋe hepunmâ kâlewângen ariwerâm akbiap. Hain akmâ âi luâklupŋe hin makyeŋgiwiap, “Siâ siâ ire lâmgoŋet.” dâm âi are potatmâ ikiŋeâk ikiŋeâk yeŋgiwiap. Yeŋgim âi luâk siâ magaŋmâ hin dâwiap, “Gâ hâŋgiân ire damun kinben.” dâm ariwiap. ");
INSERT INTO tim_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Aregât biwi golâk manbei. Gârâmâ emet damunŋande âi are mem âmâ purik katbiap aregât sopŋe bo nâŋgâmai aregât damun kârikŋe kinmâ manbei. “Eŋgaiŋe me hândâktâk, me gokorok indemboân me emet hauŋdo me ");
INSERT INTO tim_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","asiŋ yendere togom nekmâ watnekbop.” dâm hilâm ârândâŋ damun kârikŋe kinbei. ");
INSERT INTO tim_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Den ire yeâk bo makyeŋgiân. Luâk âmbâle hârok yeŋgât maktân. Amâ biwi golâk manbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Akto hombaŋ siâ aregât kotŋe Pasowa are âi meme sopŋe lâuwâ bo akto miawakbiapgât ain sumbe kat kat luâk aregât humomolupyeŋe akto Mosegât den kârikŋe makmâ kepigi arekŋe âmâ hin dâyi, “Gain gain akmâ Yesu hiaŋdenŋe den bâleŋe makto aregât kondenŋe moâk. ");
INSERT INTO tim_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akto hinŋe Yesu mendenŋe luâk âmbâle dondâ hombaŋgât togoyi irekŋe nâŋgâmbiâ kuk miawakbopgât hinŋe bo memberen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Akto Yesu Betania kepian âgâep. Âgâm luâk hâk bâle siâ agep kotŋe Simon aregât emelan âgâ tatmâ sot niep. Akto ain âmbâle siâ togoep. Arekŋe tu higenŋe ukenŋe siâ umbâ bâlensiân mem togoep. Tu are akto umbâ are puliŋe âgâ âgâŋe dondâ are hogom Yesugât kautŋân kâiep. ");
INSERT INTO tim_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kâimbo luâk bikŋe ain kili are biwiyeŋe bâlimbo hin dâyi, “Wangât tu ire yân kâiâp? ");
INSERT INTO tim_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nenŋe ire luâk yeŋgâlân mem arim dâine âlepŋe puli dondâ mem âmâ luâk umburuk yeŋgiwâen.” dâyi. Hain dâm âmbâle are peiyi. ");
INSERT INTO tim_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Peimbiâ Yesuŋe hin dâm makyeŋgiep, “Ye âmbâle ire bo peiŋet. Wangât umatŋe waŋdâi? Âmbâle irekŋe okot âlep akniŋdâp. ");
INSERT INTO tim_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sop kâlep luâk umburuk ye olop tatmâ manbai are tânyeŋguwerâm aregât aktâi. A âlepŋe hain akŋet. Dâ nâmâ ye olop sop kâlep bo manbaen. ");
INSERT INTO tim_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dâ âmbâle irekŋe aktâp ire âmâ âlepŋe akniŋdâp. Tu hâknân kâiâp ire âmâ mombian aregât nâŋgâm akniŋdâp. ");
INSERT INTO tim_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gârâmâ bunŋe makyeŋgire nâŋgâŋet. Hânŋe hânŋe nâŋgât pat ire makyeŋgim manbai ain âmbâle ire aktâp yâkgât pat nelâmyeŋgiwopgât gai makyeŋgimbiâ nâŋgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yesugât aposololupŋe keiân lâuwâ mali are yeŋgât hutyeŋân gâtŋe siâ kotŋe Yudasi arekŋe sumbe kat kat luâk areyeŋgât humomolupyeŋe are yeŋgâlân arim hin makyeŋgiep, “Nâŋe Yesu yâgâten me yâgâten mando ain hekatyeŋgire meaŋbai.” dâm makyeŋgimbo ");
INSERT INTO tim_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","nâŋgâm biwiyeŋe heroŋe akto puli waŋbaigât magaŋi. Akto aregât den dâpŋe gain gain makyeŋgire Yesu mem miawakŋet dâm dâpgât undâgâlep. ");
INSERT INTO tim_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Akto hombaŋ kotŋe Pasowa are keiŋe katmâ sot bo kauliep are nemini. Akto sop ain lama gâim om nemini. Aregât hoŋ bawalupŋande Yesu magaŋmâ hin dâyi, “Sot soŋgo emet wanân ondenŋe nemberen?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesuŋe aposolologâtŋe lâuwâ huŋgun yetkim hin dâep, “Yet âmâ Yerusalem kepian ariet. Arim luâk siâ ain umbâ heleŋ heleŋân tu hâgâm lokom manmâ yelekto aikombela kewugu yelekmâ emet are hekat yetkiwerâp. ");
INSERT INTO tim_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hekatyetkimbo emet amboŋe hin dâm magaŋberat, “Humo netŋande hin dâp, “Nâŋgât emet kom hâre hâreŋe are yâgâten hoŋ bawalupne olop sot nemberen?” hain dâp.” dâmbela ");
INSERT INTO tim_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","kom hâre hâreŋe humoâk egon kakŋângen are hekatyetkiwerâp. Emet kâlegen are âmâ dâgâm me kondo bunewâk heŋgemgoyi, ain arim sot wan kalet.” Hain dâm huŋgunyetkimbo ariyiat. ");
INSERT INTO tim_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Arim Yesuŋe makyetkiep are mem miawakmâ sot are mem hombaŋgât wan me wan heŋgemgoyiat. ");
INSERT INTO tim_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hain akbela eŋgaiŋe akto Yesu togom aposololupŋe keiân lâuwâ olop sot soŋgo are neyi. ");
INSERT INTO tim_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nem tatmâ hin dâep, “Makyeŋgire nâŋgâŋet. Yu tatâi yeŋgât hutyeŋânba siâŋe nâŋgât gasa akmai are yeŋgâlân arim nâ mem nuguwerâi aregât keiŋe hekatyeŋgiwerâp are nâ olop tatmâ sot nenden ire.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hain dâmbo aposololupŋande biwiyeŋe umatŋe akto siâkâ ikiŋeâk ikiŋeâk hin magaŋi, “Maktât amâ nâ mon?” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Amâ luâk keiân lâuwâ tatâi yeŋgâlân gâtŋe konok luâk are âmâ yu nâ olop sot nemberen kondo kâlegen bâtnetŋe pandetŋe geâp yâkgât den umatŋe makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Anutugât den bunŋe miawakto luâk akmâ geân nâ mombian gârâmâ nâŋgât gasa yeŋgâlân katnekberâp arekŋe umatŋe humo mem manbiap. Luâk are memeŋande bo miep dâine owâiŋe agaŋbop.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Akto aposololupŋe sot nem tali akto Yesuŋe sot siâ mem munditmâ Anutu mepaiŋe mem hin makyeŋgiep, “Ire âmâ nâŋgât sunumne aregât dop.” hain dâm yeŋgimbo neyi. ");
INSERT INTO tim_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Akto waiŋ hâpu siâ mem kinmâ âkâ hainâk Anutu mepaiŋe mem yeŋgimbo neyi. ");
INSERT INTO tim_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nembiâ den hin makyeŋgiep, “Tu ire âmâ nâŋgât gilâmne aregât dop. Tu yu kâim yeŋgire nendâi gârâmâ hâmbâi Anutuŋe den pat kârikŋe kalep are miawakto nugumbiâ gilâmne gembo luâk âmbâle dondâ areyeŋgât dosa bo akbiap. ");
INSERT INTO tim_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nâ hinŋe waiŋ koaŋe tuŋe bo nembian arekŋe maleine bunewâk Anutuŋe damunyeŋe akberâm keiŋe kato ain tu irakŋe nembian.” hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hain dâm makyeŋgimbo Anutugât kotŋe mem agatmâ kep siâ membiâ bo akto arewa sopanmâ Oliwa gimbâŋân âgâyi. ");
INSERT INTO tim_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Âgâm ain aposololupŋe hin makyeŋgiep, “Anutuŋe makyeŋgimbo kulemgoyi aregât bikŋe hin tatâp, “Nâŋe bau damunyeŋe kondere mondo bau are awam akmâ kâit akmâ metewai.” Den pat are bunŋe miawakto menekberâm togombiâ ye hârok gem awam akmâ hanâk hanâk ariwerâi. ");
INSERT INTO tim_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Gârâmâ nugumbiâ mondere han nugumbiâ momoŋânba agatmâ arim Galilaia hânân lâm yeŋguwian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hain dâmbo Petoroŋe hin magaŋep, “Gâŋgât gasa togombiâ hamewakmâ ariwerâi me bo. Bo nâŋgân. Dâ nâmâ bo hepun gekberân. Gâ olop tatmâ tân gugum âgâwian.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hain dâmbo Yesuŋe hin magaŋep, “Makgiŋdere nâŋgâ. Hândâk uŋak gâŋe nâŋgâ yâkgât kotŋe bo nâŋgâman dâm makyeŋgimenâ sop âlâwu akto ainâk gokorok lâuwâŋe indewerâp.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","kârikŋe akmâ hin dâep, “Bo. Nâ gâ olowâk mombaet aregât hamep bo aktân. Akto nâ gâŋgât kotge bo mem heambukberân.” hain dâep. Dâmbo galalupŋe hârok hainâk dâyi. ");
INSERT INTO tim_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Arewa ari kalam siâ kotŋe Gesemane ain ariyi. Ain arim Yesuŋe aposololupŋe makyeŋgim hin dâep, “Ye ge tatbiâ indâgen ba kinmâ Apo maŋganmâ ulilaŋberân.” dâmbo ge tali. ");
INSERT INTO tim_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hain akmâ arewa Petoro, Yakopo akto Yohane meyekto bayi. Ba kinmâ biwiŋe umatŋe akto hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Ye âmâ iren damun tatŋet. Biwine umatŋe dondâ akto gain gain manberân aregât tân nugum iren damun tatŋet.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Makyeŋgim hepun yekmâ getek indâŋân ba hânân ge tatmâ Anutuŋe umatŋe ire hepunniŋâk dâm hin ulilaŋep, ");
INSERT INTO tim_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“O Apo, gugak âmâ siâ me siâ hârok miawakbiapgât bo pâpkomat aregât uŋak umatŋe miawak niŋberâm aktâp iregât bo niŋ dâm ulit giŋdân. Gârâmâ gâŋe âmâ nâŋgât nâŋgâ nâŋgâne bo watben. Guge nâŋgâ nâŋgâge watben.” dâm ulilaŋep. ");
INSERT INTO tim_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hain akmâ purik katmâ bam yekto aposololupŋe âlâwu are asiŋ yeyi. Yembiâ yekmâ Petoro goaŋmâ hin magaŋep, “Simoŋ gâ asiŋ yendât me? Hinŋe hepun yektân ina pâlâmŋe yendât.” dâm ");
INSERT INTO tim_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","aposololupŋe âlâwu are hin dâm makyeŋgiep, “Biwiyeŋande âmâ laune lokowerâm aktâp. Dâ hâkyeŋe âmâ konam aktâp aregât hâkŋe hâkŋe arekŋe togom dop yeŋguwerâm akbopgât damun kinmâ Anutu ulilaŋŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hain dâm makyeŋgim purik katmâ bam lâuwâŋe hainâk Anutu ulilaŋep. ");
INSERT INTO tim_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ulilaŋmâ metem purik katmâ gutmâ yekto asiŋgât dondâ nâŋgâyigât asiŋâk yem tali. Hain akbiâ hainâk aiyeŋgumbo dengât pâpkom aŋun aŋgim tali. ");
INSERT INTO tim_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hain akmâ kinbiâ hepunyekmâ bam hainâk âlâwuŋe akmâ guto asiŋ yembiâ hin dâm makyeŋgiep, “Ye asiŋ yem mandâi mon? Bâin. Uŋak âmâ nâ luâk akmâ geân aregât dosa luâk yeŋgâlân katnekto menekmâ hilip nuguwerâigât sop ewumâk aktâp. ");
INSERT INTO tim_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gârâmâ bâin agatmâ indâre yekŋet. Nâŋgât halop hogoâp ina togoâp. Ye agatbiâ arim peniaŋne.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Den are hain dâm makyeŋgimbo kinbiâ ainâk indâgenba Yudasiŋe luâk dondâ sumbe kat kat luâk areyeŋgât humomolupyeŋe akto Mosegât den kârikŋe makyeŋgimini akto Yuda yeŋgât damunlupyeŋande huŋgun yeŋgimbiâ Yudasiŋe kewugu yekto togoyi. ");
INSERT INTO tim_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Akto luâk gasa kewugu yekto togoyi are âmâ Yudasi Karioto gâtŋe luâk are Yesu ikiŋe hoŋ bawa inarekŋe ari gasa tirip katyeŋgim hin makyeŋgiep, “Yesu are âmâ lokom maŋgandere ekmâ âmâ hikom mem ariwei.” dâm makyeŋgim kewugu yekto tâwât bugâ me soŋ soŋ lokom togoyi. ");
INSERT INTO tim_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Togom gasa are iŋgon kinbiâ Yudasiŋe Yesugât enemŋân âgâm, “Humone.” dâm lokom maŋgando ");
INSERT INTO tim_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","olowâk togoyi arekŋe âgâ Yesu mem hikoyi. ");
INSERT INTO tim_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Akto luâk kili are hutyeŋânba siâŋe tâwât mem oloŋmâ sumbe kat kat humo yeŋaet hoŋ bawa siâ kârâmbo oloŋ akto ondopŋeâk kârâm hâriep. ");
INSERT INTO tim_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hain akto Yesuŋe hin makyeŋgiep, “Ye nâŋgât nâŋgâm âmâ bugâ luâk dondâ hanyeŋân ge mandere teŋgâ soŋ soŋ lokoakbiâ bugâ humo miawakbopgât togoâi mon? ");
INSERT INTO tim_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nâ hilâmŋe hilâmŋe sumbe emetŋân Anutugât den pat makyeŋgiman sop ain menekbâi gâten. Anutuŋe hârok nâŋgâm makyeŋgimbo kulemgoyi are yendâp are bunŋe miawagâkgât hinŋe menekŋet.” dâmbo ");
INSERT INTO tim_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","aposololupŋande hepunmâ gem awam agi. ");
INSERT INTO tim_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Akto Yesu hamiŋân togombiâ yâkgât kâmolân gâtŋe luâk sigan siâ sâŋgum kau kau konok lalakmâ togoep. ");
INSERT INTO tim_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Togombo memberâm akbiâ pârigimbo sâŋgum kau kau areâk mem hulaŋbiâ sâŋgum bâlâk pârigim ariep. ");
INSERT INTO tim_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Akto Yesu mem sumbe kat kat areyeŋgât humogâlân ariyi. Yâkgât emelan âgâmbiâ sumbe kat kat luâk areyeŋgât humomolupyeŋe akto Mosegât den kârikŋe makyeŋgiyi are akto Yuda luâk areyeŋgât humomolupyeŋe arekŋe âgâmbiâ mendugum kili. ");
INSERT INTO tim_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Akto Petoro purik katmâ yoŋâk hamiyeŋângen yoŋâk watyekmâ togom emet kili aregât ginŋân ba sombeimân kilep. Bam ain luâk humo aregât tembe lokolupŋe yeŋgât hutyeŋân tatmâ kâlâp nâŋgâm talep. ");
INSERT INTO tim_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tato emet ain âgâyi arekŋe luâk niŋande Yesugât agak meme are nâŋgâp are makto kone dâm ai aguyi. Ai pei agum keiŋe undâgâli. ");
INSERT INTO tim_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hain akmâ luâk dondâŋe den aŋgâ aŋgâ hogom togo hâkgân hâkgân agi. Akto den are dopŋe konogâk bo magi. ");
INSERT INTO tim_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Siânbaŋe siâ dâmbiâ dâmbiâ agi. Akto luâk siânbaŋe Yesugât hiaŋgi den hin magi, ");
INSERT INTO tim_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Den siâ hin makto nâŋgâyion, “Sumbe emetŋe humo meyi ire gagaim patakore awam akmâ yendo hilâm âlâwu kâlegen nunak bâtnandeak mem metewian.” dâep.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hain dâmbiâ den yu dâyi ire gai den ulik gulik magi are olop dop konok bo agep. ");
INSERT INTO tim_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Akto sumbe kat kat yeŋgât kautŋande hutyeŋânba agatmâ kinmâ Yesu hin magaŋep, “Gâ wangât den hâuŋe siâ bo maknengiât. Den aŋgâ aŋgâ hogom togo hâkgân hâkgân aktâi iregât nâŋgâmenâ ârândâŋ aktâp me bo? Gain gain maknengimenâ nâŋgâne.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Hain dâm magaŋdo Yesuŋe den hâuŋe bo magaŋmâ denŋe nâŋâk kilep. Akto sumbe emetŋaet luâk humo arekŋe totokomâk hin magaŋep, “Gâ Anutuŋe huŋgun giŋdo gien are me siâ? Humo kotŋe mem agatmaen aregât nanŋe gâ me?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Hain dâm magaŋdo Yesuŋe hin dâep, “Gâŋe ya maktât are amâ nâ. Nâ luâk akmâ geân aregât nâmâ kârikŋe amboŋe Anutugât enemŋân manman aregât Anutuŋe kârikŋe niŋmâ huŋgun niŋdo himbimânba hamandat olop gem âmâ hârok damunyeŋe akbian ain âmâ nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hain dâmbo sumbe kat kat luâk humo arekŋe den are nâŋgâm biwiŋe kâlâp akto aregât ikiŋe sâŋgumŋe mem duwatmâ galalupŋe hin makyeŋgiep, “Siâŋe siârâm siârâm akbiâ âmâ den âi humo membâen. ");
INSERT INTO tim_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Luâk ire âmâ Anutugât kotŋe mem bâlimbo nâŋgâen aregât ye gain gain nâŋgâi?” dâmbo luâk âmbâle mendugum kili arekŋe Yesugât hin dâyi, “Moâkgât dâp miawaktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hain dâm arewa keiŋe katmâ tâwutkoyi. Akto bikŋande sâŋgumŋe dewunŋe dâgâm tigim koyi. Kom kinmâ hin dâm magaŋi, “Ondopge hogoâp aregât kotŋe kon.” dâmbiâ tembe lokoŋe ondopŋe hogoyi. ");
INSERT INTO tim_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Akto Petoro iŋgon emet aregât ginŋân tatmâ kâlâp nâŋgâm talep. Tato ainâk emet aregât amboŋe luâk humo aregât sumbe kat kat yeŋgât kautŋe yâkgât hoŋ bawa âmbâle siâ togoep. ");
INSERT INTO tim_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Togom ekto Petoro kâlâp nâŋgâm tato âmbâle arekŋe ekmâ totokomâk totokomâk egep. Ekmâ hin magaŋep, “Gâ Yesu Nasarete kepian gâtŋe are olop manmandat.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hain magaŋdo Petoroŋe muneŋ akmâ magaŋep, “Nâ luâk are bo nâŋgaŋdân akto den maktât aregât keiŋe bo nâŋgân.” dâep. Dâm âmâ dâwângen ariwerâm gembo gokorok indiep. ");
INSERT INTO tim_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gokorok indembo âmbâle arekŋe Petoro yoŋâk egep. Ekmâ kinmâ arekŋeâk hin dâep, “Luâk ire âmâ Yesugâlân gâtŋe.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Makyeŋgimbo Petoroŋe lâuwâŋe hainâk magep, “Bunŋe dondâ nâ luâk are bo nâŋgaŋdân.” dâep. Akto getek kinmâ luâk enemŋân kili arekŋe Petoro hin magaŋi, “Gâ maktât aregât den amâ Galilaiaŋe makmai han hainângen maktât aregât gâmâ Galilaia areyeŋgâlân gâtŋe.” dâm magaŋi. ");
INSERT INTO tim_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hain magaŋbiâ makmâ bâleŋeâk magep, “Anutugât meteŋân makmâ kârigem makberân. Nâ yeŋe luâk kotŋe kondâi are bo ekmâ heŋgemgoman.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hain dâmbo ainâk gokorok lâuwâŋe indiep. Indembo nâŋgâm Yesuŋe den hin magaŋep are hanŋân ga togoep, “Gâ gokorok lâuwâŋe bo indemboâk nâŋgâ yâkgât bo nâŋgâ aŋman dâmenâ âlâwu akbiap.” dâep are hanŋân ga togombo nâŋgâm okotŋe akto indiep. ");
INSERT INTO tim_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Akto emet hauŋdo ain sumbe kat kat areyeŋgât humomolupyeŋe akto Mosegât den kârikŋe makyeŋgimini akto damun hârok menduguyi. Mendugum Yesu hikom mem kiap kotŋe Pilato gâlân arine dâm den âi meyi. ");
INSERT INTO tim_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hain akmâ mem Pilato gâlân arimbiâ hin magaŋep, “Yuda yeŋgât luâk humoyeŋe are gâ me?” dâmbo Yesuŋe hin dâep, “Amâ gâŋe ya maktât are.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Akto sumbe kat kat yeŋgât humomolupyeŋe arekŋe den aŋgâ aŋgâ hogom togo hâkŋân hâkŋân agi. ");
INSERT INTO tim_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hain akbiâ Pilatoŋe Yesu hin magaŋep, “Gâ den hâuŋe siâ wangât bo makmâ kindât? Nâŋgâ. Den aŋgâ aŋgâ hogom togo hâkgân hâkgân aktâi.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hain dâmbo Yesuŋe den hâuŋe bo makberâm aregât yânâk kilep. Kindo Pilatoŋe nâŋgâm han lâuwâ agep. ");
INSERT INTO tim_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Akto Pasowa hombaŋ sop ain âmâ kala busiânba luâk ikiŋak siâ bo watyekminep. Luâk âmbâleŋe togo luâk siâ konbiâ watmâ watmâ akminep aregât nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sop ain âmâ luâk siâ kala busiân talep kotŋe Baraba arekŋe ulikŋân kukgât dâtŋe mendo agum luâk siâ kombiâ moep aregât akmâ kala busiân katbiâ talep. ");
INSERT INTO tim_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Akto luâk âmbâle mendugum kili arekŋe ulikŋân akminen hainâk ak dâm Pilato konmâ tali. ");
INSERT INTO tim_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Akto Pilatoŋe hingât nâŋgâm, “Sumbe kat kat areyeŋgât humomolupyeŋande, “Luâk âmbâle hârokŋe Yesugât kotŋe mem agatbiâ nengât gewop.” dâm nâŋgâmbiâ bâlimbo aregât Yesu mem nâŋgâlân togoâi.” dâm nâŋgâm hin makyeŋgiep, “Ye Yuda yeŋgât luâk kembuyeŋe ire hepundere yeŋgâlân gulâkgât nâŋgâi me wan?” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hain dâm makyeŋgimbo sumbe kat kat luâk arekŋe luâk âmbâle hin makyeŋgiyi, “Ye konmâ wârakbiâkâ Baraba konok hepundo geâk.” dâm makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hain dâm makyeŋgimbiâ hainâk konmâ wârakbiâ Pilatoŋe lâuwâŋe hin makyeŋgiep, “Ye nâŋgâi. Yuda yeŋgât luâk kembuyeŋe dâmai ire gain mâŋgiwegât nâŋgâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hain dâm makyeŋgimbo luâk âmbâle arekŋe konmâ hin dâyi, “Lâwinân kombiâ moâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hain dâmbiâ Pilatoŋe hin makyeŋgiep, “Wan akmâ hilipkoâp?” dâmbo luâk âmbâle arekŋe konmâ wârakmâ, “Lâwinân kombiâ moâk.” dâm wâragi. ");
INSERT INTO tim_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Akto Pilatoŋe luâk âmbâle dondâ wâragi aregât okotyeŋe âlepŋe agâk dâm tembe lokolupŋe hin dâm makyeŋgiep, “Baraba kala busiânba huŋgun aŋbiâ ariâk.” dâmbo arim huŋgun aŋbiâ ariep. Akto tembe lokolupŋande Yesu handomŋe orem lâwinân kondenŋe moâkgât mem ariyi. ");
INSERT INTO tim_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Akto tembe lokoŋe Yesu mem kiap humogât emetŋe ain mem âgâyi. Mem âgâm tembe loko hârogâk yeŋgonbiâ togoyi. ");
INSERT INTO tim_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Togom âmâ sâŋgum gilâm siâ lalaŋmâ tâk dâtâ dâtâ siâŋe irimut ketugum kautŋân kauŋaŋi. ");
INSERT INTO tim_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hain akmâ siânbaŋe lau elek agaŋmâ hin magaŋi, “Wei, Yuda yeŋgât luâk kembuyeŋe.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hain dâm kâroŋe mem kom tâwutkom togo enemŋân pâwutyeŋe ligiaŋmâ giriŋaŋi. ");
INSERT INTO tim_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hain akmâ sâŋgum gilâm are higotmâ ikiŋe sâŋgum lalaŋmâ lâwinân komberâm mem ariyi. ");
INSERT INTO tim_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mem arim dâwân luâk siâ egi are kotŋe Simoŋ Kirene hânân gâtŋe Alesande akto Rupu eweyetŋe are halângenba togom mando dâwân egi. Ekmâ wârakmâ tatbiâ Yesugât lâwin are lokombo ariyi. ");
INSERT INTO tim_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Arim hân siâ kotŋe Goligata den purikŋe amâ kaut hagitŋe ain ariyi. ");
INSERT INTO tim_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Akto hâk hilâlâm humo nâŋgâwop dâm waiŋ akto biwi gulip tu kâim mendugum waŋbiâ borâep. ");
INSERT INTO tim_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Akto dewutâ gambo lâwinân koyi. Kom mem anuŋbiâ kindo sâŋgum memberâm kotyeŋe kulemgom are umbâ kâlegen panbiâ gembo luâk kotyeŋe miawakto arekŋe sâŋgum are meyi. ");
INSERT INTO tim_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Akto kom kautŋân lâwin ulikŋân kulem kulemgoyi aregât keiŋe hin, “Ire Yuda yeŋgât luâk kembu.” ");
INSERT INTO tim_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Akto bugâ koko kâmburâ lâuwâ siâ Yesugât gasomŋe biken biken lâwinân yetkuyi. ");
INSERT INTO tim_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Akto Anutuŋe makyeŋgimbo kulemgoyi âmâ hin yendâp are bunŋe miawagep, “Nâŋgât hoŋ bawane yâk luâk bâleŋe hâkŋe hâkŋe yeŋgât hutyeŋân katbai.” dâep. Are bunŋe miawakto aregât luâk kâmburâ lâuwâ olop yetkuyi. ");
INSERT INTO tim_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Akto luâk âmbâle gam ariyi arekŋe Yesu den hembalik mâŋgim hin dâyi, “Sumbe kat kat emetŋe gagaim hilâm âlâwu kâlegen ketuguwian dâmat aregât ");
INSERT INTO tim_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","bâin kârikŋe akmâ lâwinânba ge.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Akto sumbe kat kat luâk areyeŋgât humomolupyeŋe akto Mosegât den kârikŋe makyeŋgimini arekŋe hainâk den hembalik mâŋgim magaŋgi goaŋgi akmâ hin dâyi, “Luâk aŋgâ âmâ tân yeŋgumap. Dâ ikiŋe âmâ wangât bo tânaguâp? ");
INSERT INTO tim_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Anutuŋe huŋgun aŋdo togom Yuda luâk nengât luâk kembu mandâp dâmai inarekŋe lâwinânba gembo ekmâ âmâ den are bunŋe dâm nâŋgâweren.” dâyi. Hain dâmbiâ Yesugât enemŋe bip bip yetkuyi lâuwâ arekâ hainâk den bâleŋe magaŋiat. ");
INSERT INTO tim_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Akto hilâm tânâmŋân ain hândâk humo dâgâm yendo eŋgaiŋe agep. ");
INSERT INTO tim_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Eŋgaiŋe akto ain are Yesuŋe kot hin kolep, “Eli Eli lama sabaktani?” dâep. Den purikŋe âmâ, “Anutuŋe, Anutuŋe wangât hepun nektât.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akto luâk ain kili ainba siânbaŋe nâŋgâm hin dâyi, “Âure nâŋgâŋet, Elia kondâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Akto luâk siâŋe pârigim arim sâŋgum papaŋe siâ kâroân bigeim waiŋ ŋasukŋân panmâ mem agatmâ Yesugât lauŋân katmâ kinmâ galalupŋe hin makyeŋgiep, “Eliaŋe bunŋe gem tângombo lâwinânba gewerâp me bo aregât ekmâ kinne.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hain akto Yesu kârikŋeâk kamboŋmân ainâk panagep. ");
INSERT INTO tim_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Akto sâŋgum humo sumbe emetŋân kilep are tânâmŋânba duwalakmâ giep. ");
INSERT INTO tim_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Akto tembe loko humoyeŋe siâ Yesugât enemŋân kilepgât ekmâ kindo mondo hin dâep, “Ire amâ Anutugât nanŋe bunŋe.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akto âmbâle bikŋe ain kili arekâ getek kâlewânâk kinmâ ekmâ kili are hutyeŋân kilep siâ kotŋe Maria Madala kepian gâtŋe akto Maria siâ Yakopo bâlensiâ akto Yose areyetgât memeyetŋe, akto Solome. ");
INSERT INTO tim_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Are âmâ Galilaia hânân Yesugât hoŋ bawa akbiâ olop mali. Akto yâk konok bo. Âmbâle bikŋe Yesu olop Yerusalem kepiangenba togoyi are olowâk kili. ");
INSERT INTO tim_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Âi bo meme sopŋe irawot akto emet dâgâwerâm akto ain Arimataia kepian gâtŋe luâk siâ kotŋe Yosepe are togoep. ");
INSERT INTO tim_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Luâk are âmâ damun akto kaunsoli yeŋgât hutyeŋân mando ekmâ luâk âlepŋe dâmini. Are Anutuŋe hoŋ bawaŋe huŋgun aŋdo gem damun agâk dâm ulilaŋep. Hain akmâ yâkŋe hamep bo akmâ Pilatogât emet kâlegen âgâm ba enemŋân kilep. Kinmâ, “Yesugât hâkŋe mem arim hangowerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dâmbo Pilatoŋe hanŋe undup akto tembe lokoŋe siâ hin magaŋep, “Emelâk mondâp me? Bam ek.” dâmbo bam ekmâ gutmâ emelâk mondâp dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hain dâmbo Pilatoŋe Yosepe magaŋmâ, “Âlepŋe Yesugât hâkŋe mem ari hango.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Akto Yosepeŋe bam sâŋgum kau kau siâ puligom mem ari Yesugât hâkŋe are mem ge sâŋgumân are katmâ katipkoep. Hain akmâ mem ari kât dâpŋe siân ulikŋân parâ parâ kendâyi ain katmâ kât humo siâ hâkokombo tigiep. ");
INSERT INTO tim_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Akto Maria Madala gâtŋe akto Yose memeŋe are Yosepeŋe Yesu kât dâpŋân kalep sum are ekmâ kiliat. ");
INSERT INTO tim_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Âi bo meme sopŋe are bo akto hândâk pipiŋe tatoâk Maria Madala gâtŋe akto Maria siâ Yakopo memeŋe akto Solome Yesugât hâkŋe hambuwopgât dâm tu higenŋe ukenŋe puligom mem togoyi. ");
INSERT INTO tim_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sonda hândâktâk dewutâ gambo ain sumângen arim dâwân yeŋeâk magaŋgim hin dâyi, ");
INSERT INTO tim_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“Niŋande tân nengumbo kât humo are hâkokoweren.” dâyi. ");
INSERT INTO tim_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hain dâm togom kinmâ ekbiâ kât humo sum dâpŋe tigiep are bo yiep. ");
INSERT INTO tim_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Are ekmâ kât kâlegen âgâyi. Âgâm ekbiâ luâk sigan siâ sâŋgum kau kau humo luguakmâ bâtŋe bungen kindo ekmâ sân sân mem hamewagi. ");
INSERT INTO tim_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akto luâk arekŋe hin dâm makyeŋgiep, “Bo hamewakŋet. Ye Yesu Nasarete gâtŋe lâwinân koyi are ekberâm togoâi amâ emelâk agatmâ ariâp. In bo yendâp. Gutmâ in kali aregât gewâkŋe ekŋet. ");
INSERT INTO tim_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yeâmâ arim Petoro akto hoŋ bawalupŋe aposololupŋe bikŋe are makyeŋgiŋet amâ Yesu âmâ ulikŋân makyeŋgiep hain aktâp. Emelâk Galilaia hânân ariâp. Gârâmâ ye ari makyeŋgimbiâ Galilaiagen ari ekŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Akto âmbâle are kât kâlegenba gam hamewakmâ biwiyeŋe gulip agepgât luâk siâ aregât den pat bo makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Akto Sondan emet hauŋdo hândâktâk Yesu momoŋânba agatmâ arim Maria Madala kepian gâtŋe ulikŋân ikiŋak sinduk baniara bâleŋe nâmbulân lâuwâ watyeŋgiep yâkgâlân arim miawagaŋep. ");
INSERT INTO tim_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Miawagaŋdo arim Yesu hamiŋângen olop manmâ indeaŋmâ mali are arim makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Makyeŋgim hin dâep, “Yesu âmâ togo miawakniŋdo ekmâ yu togoân.” dâmbo den are bo nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Akto arewa luâk lâuwâ siâ kepia are hepunmâ arim manbela dâwân Yesuŋe enem dewunŋe siâ akto miawak yetkiep. ");
INSERT INTO tim_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Akto luâk lâuwâ arekŋe Yesu egiat aregât purik katmâ arim galalupyetŋe makyeŋgiyiat. Akto yâkŋe, “Den are hiaŋgiat.” dâm nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Akto sop siân aposololupŋe keiân konok arekŋe sot nem tatbiâ Yesuŋe hutyeŋân togo kilep. Kinmâ hin makyeŋgiep, “Wangât biwiyeŋe nâŋgâlân bo kali? Akto momoŋânba agatere âmbâleŋe nekmâ togom makyeŋgimbiâ, “Hiaŋgiâi.” dâyi are wangât hain agi.” dâm kugâk kugâk akyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Akto hin dâm makyeŋgiep, “Yeâmâ arim hânŋe hânŋe nâŋgât den pat âlepŋe ire makyeŋgiwei. ");
INSERT INTO tim_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Luâk siâ bunŋe maktâi dâm biwiŋe nâŋgâlân kato tu puli aŋbai are âmâ sop humoân dosa bâlâk kinbiap. Dâ siâ nâŋgâm hiaŋgiâi dâm nâŋgâlân biwiŋe bo katbiap akto bo nâŋgâniŋmâ kepilâniŋbiap are âmâ dosa mem manmâ kâlâpgât pat akbiap. ");
INSERT INTO tim_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nâŋgâlân biwiyeŋe katmâ manbai arekŋe âmâ kulem keiŋe keiŋe membiâ yekmâ, “Ire Yesugât kârikŋân kindâi.” dâwai. Kulem are âmâ hin. Nâŋgât kolân sinduk baniara bâleŋe watyekbai. Akto denyeŋe irakŋe membai. ");
INSERT INTO tim_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Akto hâme hewuk niambi sâmbâ bo ekmâ tâlimbiâ yeŋgimbo bo mombai. Akto wan me wan sait kâmbokŋe nem âmâ bo mombai. Akto luâk kundatdâ areyeŋgât hâkyeŋân bâtyeŋe katbiâ âlepŋe akbai.” Yesuŋe hain makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Makyeŋgimbo Anutuŋe oloŋdo hepunyekmâ himbimân purik katmâ âgâep. Âgâm Anutugât bâtŋe bungen ain talep. ");
INSERT INTO tim_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Akto aposololupŋe arim kepiaŋe kepiaŋe Yesugât den pat makyeŋgim mali. Manbiâ ain ikiŋak kârikŋe yeŋgimbo kulem keiŋe keiŋe membiâ luâk hârokŋe are ekmâ, “Luâk ire âmâ den bunŋe makmâ manmai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Apo Teopilo, Luâk âmbâle bikŋande Yesu olowâk maliŋe wan me wan bunŋe nengât tânâmnenŋân miawagep are ekmâ keiŋânbak dâm luâk hârok maknengiyi. ");
INSERT INTO tim_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dâm maknengimbiâ luâk unduwâkŋe den pat are heŋgemgowerâm kulemgoyi. ");
INSERT INTO tim_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Akto gâŋe keiŋânbak den pat are nâŋgâen gârâmâ kulem esenŋe ire oyaŋmâ keiŋe nâŋgâm heŋgemgowiatgât den pat are hârogâk heŋgemgom tâŋ tâŋâk kulemgom katgiŋdân. Den pat are hin. ");
INSERT INTO tim_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Uŋguŋân Heroteŋe Yudaia yeŋgât luâk humo malep. Mando âmâ yâk yeŋgât sumbe kat kat luâk siâ malep kotŋe Sakaria, yâk Abia yâkgât kâmolân gâtŋe akto yâkŋe âmbâle siâ kotŋe Elisabete are âmâ Aroŋ yâkgât kâmolân gâtŋe are miep. ");
INSERT INTO tim_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Akto Anutugât dewunŋân manmâ bâleŋe bo akminiat. Âlepŋe manmâ Anutugât den are lokom manmâ gayiat. ");
INSERT INTO tim_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Akto luâk âmbâi lâuwâ are gupin akmâ manmâ gam sâmbâ agiat. ");
INSERT INTO tim_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Akto sumbe kat kat luâk yâkŋe amboŋân amboŋân akmâ Anutugât sumbe omini. ");
INSERT INTO tim_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Akto omini aregât sop tâlâgumbo âmâ humomolupŋande hin dâyi, “Sakaria Anutugât biwiŋe geâkgât wan me wan omenâ higenŋe agalâk.” dâmbiâ, sumbe kat kat emetŋe ain âgâep. Âgâm sumbe ondo âmâ ");
INSERT INTO tim_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","luâk âmbâle bikŋande sumbe kat kat emetŋe aregât kâlegen gam Anutu ulilaŋmâ kili. ");
INSERT INTO tim_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ulilaŋmâ kinbiâ âmâ Anutugât aŋelo siâŋe Sakaria miawagaŋmâ ombiâ higenŋe agep aregât alata bungen kilep. ");
INSERT INTO tim_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Miawagaŋmâ kindo luâk sâmbâ arekŋe ekmâ sân sân mem hamep akmâ kilep. ");
INSERT INTO tim_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hamewakmâ kindo aŋeloŋe hin dâm magaŋep, “Sakaria bo hamewak. Âmbengande nanaŋ luâk membiapgât Anutu ulilaŋmâ gamat aregât bunŋe Anutuŋe nâŋgâ aŋdo âmbengande nanaŋ siâ membiap aregât kotŋe Yohane dâm konbiat. ");
INSERT INTO tim_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Akto miawakbiawân kambiamge heroŋe akbiap. Akto miawakto ainâk luâk unduwâkŋe aregât heroŋe nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Akto nanaŋânbak Anutugât Heakŋande memeŋe agaŋbiap. Akto yâk âmâ Anutugât dewunŋân luâk humo akmâ manbiap. Akto tu kârikŋe bo nem manbiap. ");
INSERT INTO tim_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Akto miawakmâ manmâ âgâm Israe luâk mem hâwât yekto âmâ biwiyeŋe Kotdâ Anutugâlân katmâ manbai. ");
INSERT INTO tim_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Akto emelâk Eliaŋe Anutugât bâtŋân manmâ kârikŋe mem malep hainâk nangande manmâ âgâm Anutuŋe hoŋ bawaŋe huŋgun aŋdo gewiap yâkgâlân luâk âmbâleŋe biwiyeŋe katŋetdâm aregât arim den pat makyeŋgiwiap. Akto hain dâm arim nanaŋ akto ewelupyeŋande kuk akyeŋgiwai are makyeŋgimbo gala akyeŋgiwai. Dâ den koko yâk makyeŋgimbo ârândâŋ manmai yâk yeŋgât nâŋgâ nâŋgâgât dâp watbai. Akto Kembuŋe ikiŋe kâmot oloŋyegep yâk yeŋgât biwiyeŋe agalâkgât nangande makyeŋgim âgâwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Anutugât aŋeloŋe hain dâmbo Sakariaŋe hin aikoep, “Net luâk âmbâi sâmbâ agiotgât gâŋe nanaŋgât dâmenâ nâŋgâre bunŋe bo aktâp hain dâm aktân. Gain gain nâŋgâre bunŋe akbiap?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hain dâmbo aŋeloŋe hin dâm magaŋep, “Agon aktere nâŋgâ. Nâ Gabirie, nâ Anutugât hoŋ bawa manman. Ire nek. Huŋgun niŋdo gem den bunŋe makgiŋdân. ");
INSERT INTO tim_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gârâmâ heniŋdât dât aregât dosa amâ hin akbiat. Gâŋe kopa akmâ den bâlâk manmâ âgâmenâ den yu makgiŋdân ire bunŋe akbiap sop ain âmâ âlepŋe akbiat.” Hain dâm ainâk heambukto Sakaria ikiŋeâk kilep. ");
INSERT INTO tim_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sakariaŋe sumbe emetŋân âgâm sop kâlep mando luâk âmbâleŋe gain gain akmâ sop kâlep mandâp dâm aregât han lâuwâ agi. ");
INSERT INTO tim_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hain akbiâ emelâk yâk yeŋgâlân gem âmâ den makyeŋgiwerâm akto âmâ lauŋe tigiakto kopa agep. Kopa akto aregât hin dâyi, “Yâk âmâ sumbe emetŋân âgâmbo biwiŋe purik kato kulem siâ miawaktâp are ektâp.” Hain dâmbiâ yâkŋe bâtŋandeak kulem akmâ den makberâm hâumgoep. ");
INSERT INTO tim_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hain akmâ tato âmâ âi sopŋe bo agep. Âi sopŋe bo akto kepian purik katmâ ariep. ");
INSERT INTO tim_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Purik katmâ arimbo manbela emelâk âmbenŋande tepŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tepŋe akmâ âmâ hin dâep, “Anutu Kotdâŋe nâŋgâ niŋdo tepne aktân aregât luâk âmbâle dewunyeŋân aŋun hulaŋ akniŋdâp.” dâep. Hain dâm emetŋânâk tato dewutâ momerâk bo agep. ");
INSERT INTO tim_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dewutâ momerâk bo akto âmâ Anutuŋe aŋelo kotŋe Gabirie are lâuwâŋe huŋgun aŋep. Huŋgun aŋdo Nasarete kepia are Galilaia hânân talep ain âmbâle sigan siâ malep yâkgâlân giep. ");
INSERT INTO tim_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Akto âmbâle sigan are kotŋe Maria are Dawidigât kâmolân gâtŋe luâk siâ kotŋe Yosepe yâkgât dâtâŋe malep. ");
INSERT INTO tim_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Akto aŋelo arekŋe magaŋmâ kinmâ hin dâep, “Anutuŋe gekmâ âmbâle âlepŋe aktât nâŋgâm memeŋe akgiŋdâp aregât heroŋe ak.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aŋeloŋe hain dâmbo nâŋgâmbo biwiŋe umatŋe akto biwiŋande hin nâŋgâep, “Den makniŋdât aregât keiŋe gain gain?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hain dâmbo aŋeloŋe hin magaŋep, “Maria, gâ bo hamewak. Anutuŋe gekmâ âlepŋe manmat nâŋgâp. ");
INSERT INTO tim_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aregât gâŋe nanaŋ mem kotŋe Yesu dâm konbiat. ");
INSERT INTO tim_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yâkŋe âmâ luâk humo tâmbâ mando âmâ Anutu Humo dondâ yâkgât nanŋe dâwai. Akto Humo Anutuŋe bâginenŋe Dawidi yâkgât gewâkŋân kato ");
INSERT INTO tim_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yakobogât kâmot nengât luâk kotdâ manbiap. Akto luâk damunyeŋe akmâ âi mem kârikŋe manmâ âgâwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hain dâmbo Mariaŋe hin dâm magaŋep, “Nâ luâk bâlâk mandângât den are âmâ gain gain akmâ kârikŋe akbiap?” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","aŋeloŋe hin magaŋep, “Anutugât Heakŋande tigi gekto Anutu Humo yâkgât bâtŋân kinmenâ meme akgiŋdo ain gâtŋe nanaŋ membiat aregât kotŋe siâ kau salek salek are Anutugât nanŋe konbai. ");
INSERT INTO tim_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Akto den siâ makgiŋdere nâŋgâ. Anutuŋe hain akberâm aregât bo ewum pâpkomap. Lâuge Elisabete are gupinâk manmâ âmbâi sâmbâ aktâp yâk Anutuŋe meme agaŋdo tepŋe akmâ nanaŋ luâk membiap. Akto dewutâ nâmbulân konok bo akto aregât kakŋân âmbâi gupin dâmai are hain miawagaŋbiap.” ");
INSERT INTO tim_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aŋeloŋe hain dâmbo Mariaŋe hin dâm magaŋep, “Nâ Humogât hoŋ bawa âmbâle aregât den maktât are hanâgâk akniŋbiap. Hanâgâk akniŋdo âmâ âlepŋe dâwian.” dâmbo aŋelo are purik katmâ ariep. ");
INSERT INTO tim_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Akto Maria manmâ âgâmbo kâlep bo akto âgâm arim Yudaia hân gimbâŋân kepia siâ talep ain ariep. ");
INSERT INTO tim_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ain arim Sakariagât emelan âgâm Elisabete ekmâ magaŋmâ heroŋe agaŋep. ");
INSERT INTO tim_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Heroŋe agaŋdo nâŋgâmbo ainâk tepŋe kâlegen nanaŋ arekŋe piriŋ piriŋ kalep. Hain akto Anutugât Heakŋe Elisabete kautŋân mendo hin dâm magaŋep, ");
INSERT INTO tim_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“Lâune Anutuŋe meme akgiŋdo gâŋgât heroŋe maroŋe arekŋe âmbâle hârok yeŋgât ewangiyekbiap. Akto Anutuŋe nanaŋ membiat aregât tângowiapgât heroŋe akbiap. ");
INSERT INTO tim_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Gâŋe Kembunenŋe membiat are nâŋgâm hin nâŋgân. Nâmâ âmbâle yânŋe mandân aregât nâŋgâlân togomenâ ârândâŋ bo aktâp. ");
INSERT INTO tim_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Togom nogonmenâ ainâk nanaŋ tepnân heroŋe akmâ bam guto nâŋgân. ");
INSERT INTO tim_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Akto den siâ makbe. Emelâk Anutuŋe makgiŋep are bunŋe akbiap aregât biwige heroŋe aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hain dâmbo Mariaŋe hin magep, “Nâŋe Anutugât kotŋe mem agatmâ hin dâwe. ");
INSERT INTO tim_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Nâ Anutugât hoŋ bawa manmâ âmbâle yânŋe mandân. Aregât Anutu Humoŋe nâŋgât okot nâŋgâ niŋmâ mem agat nektâp. Mem agat nekto luâk kâmotŋe kâmotŋe nâŋgât nâŋgâm Anutuŋe tângombo heroŋe akmap dâmai. ");
INSERT INTO tim_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Anutu Humo dondâ arekŋe damunne akmap arekŋe wan me wan âlepŋe akniŋep aregât kotŋe mem agatmâ âmâ Anutugât biwine heroŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Akto luâk âmbâle bikŋe nenŋe Anutugât hamewakmâ denŋe lokoenŋe nengât biwinenŋe nâŋgâm yaiwâk aknengim âmâ bâgilupnenŋe miawakbai are hainâk hainâk akyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anutuŋe wan me wan mem miawak yeŋgiwerâm akto aregât niŋande luâk âmbâle hâkyeŋe mem bâliwiap? Akto agatmâ, “Nenŋeak humo akten.” dâmbiâ are mem biwiyeŋe gulip yeŋgumbo awam akmai. ");
INSERT INTO tim_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Akto bikŋande luâk humo akmâ mem damunyeŋe akberâmbiâ hain are mem gulip yeŋgumap. Hain akbiâ âmâ luâk yânŋe me luâk gegeŋe are mem agat yekmap. ");
INSERT INTO tim_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Akto mop yeŋgimap yâk yeŋgât damunyeŋe akmâ sot yeŋgimap. Akto luâk sikum olop manbiâ yâk mem gulip akyeŋgimbo yân manmai. ");
INSERT INTO tim_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Akto ulikŋân âmâ den dâm bâgilupnenŋe yeŋgât pat dâtâŋe makyeŋgiep aregâlâk nâŋgâm manmap, aregât Israe luâk âmbâle nengât han kalem akmâ damun akmap. ");
INSERT INTO tim_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Akto bâgilupnenŋe Abrahamgât kâmot okotŋe nâŋgâ nengimbo nen Abrahamgât kâmot akmâ manmâ âgâwaen nengât dâtâŋe aregât bunŋe miawaktâp. Aregât kotŋe mem agatbe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariaŋe hain dâm Elisabete olop malep. Akto yâk olop manmâ dewutâ âlâwu bo akto kepiaŋân purik katmâ ariep. ");
INSERT INTO tim_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Purik katmâ arimbo Elisabete sopŋe miawakto manmâ nanaŋ miep. ");
INSERT INTO tim_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mendo âmâ lâulupŋe kepia ambolupŋande Anutu Humoŋe Elisabete okotŋe nâŋgâepgât nâŋgâm yâk olowâk kambiamyeŋe heroŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hain akbiâ hilâm nâmbulân âlâwu bo akto âmâ mendugum nanaŋ aregât hâkŋe gâiwerâm âmâ eweŋaet kot nambe Sakaria are konberâm agi. ");
INSERT INTO tim_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hain akbiâ memeŋande hin makyeŋgiep, “Bo. Kotŋe Yohane konberen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hain dâmbo hin magaŋi, “Are âmâ tâulupge yâk yeŋgâlân gâtŋe siâ kot nambe hain are siâ bo tatâp.” dâm magaŋgi goaŋgi akmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","“Eweŋe luâk kopa are gain gain nâŋgâp?” dâm bâtyeŋandeak kulem akbiâ ");
INSERT INTO tim_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tapegât ulityeŋgimbo tape papaŋe siâ mem waŋi. Waŋbiâ gâwu mem hin kulemgoep, “Kotŋe Yohane konberen.” hain kulemgoep. ");
INSERT INTO tim_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kulemgombo oyaŋmâ nâŋgâmbiâ ainâk den miawagaŋep aregât Anutugât kotŋe mem agalep. Kulem are miawakto ");
INSERT INTO tim_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","kepia ambolupŋande nâŋgâmbiâ dâtŋe akto kulem aregât hanyeŋe lâuwâ akto den arekŋe heroŋe akmâ sambelem kepia ewumâk ewumâk hârok ariep. ");
INSERT INTO tim_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Luâk âmbâle Yuda gimbâŋe tete kepiaŋe kepiaŋe maliŋe den are nâŋgâm hin dâyi, “Nanaŋ hain arekŋe humo akmâ gain gain akbiap?” hain dâm hanyeŋeâk akmâ nâŋgâyi. Akto Humoŋe tângombo malep. ");
INSERT INTO tim_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Akto Anutugât Wâtgât memeŋande nanaŋ aregât eweŋe Sakaria kautŋân mendo den kârikŋe hin dâep, ");
INSERT INTO tim_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israe luâk nen Kembunenŋe Anutu mepaiŋe mene. Yâkŋe âmâ luâklupŋe mete katnengim gannenŋe dâmap. ");
INSERT INTO tim_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Hain akmâ âmâ Dawidi yâkgât tepŋân gâtŋe konok miawagaŋmâ heŋgemgo nengiwiapgât hambo kunkun akbiapgât anuŋep. ");
INSERT INTO tim_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Amâ tâmbâŋe dondâ hân miawagewânba ain propetelupŋe makyeŋgimbo den makmâ mali dopŋân hainâgâk miawaktâp. ");
INSERT INTO tim_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Akto siâŋe gasa aknengiwiap. Aknengim âmâ hilipnenguwerâm akbiâ âmâ tân nengumbo âlepŋe manbaen. ");
INSERT INTO tim_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Akto ulikŋân Anutuŋe bâgilupnenŋe yeŋgât okotŋe nâŋgâm den kârikŋe katyeŋgiep are kambiamyeŋân kato tato bo nelâm aŋep. ");
INSERT INTO tim_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Akto tân nengumbo ainâk gasalupnenŋande bo hilip nenguwai aregât pat Abraham are makmâ hâreaŋep. ");
INSERT INTO tim_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Aregât Israe nen hârogâkŋe Humonenŋe Anutugât âlepŋe dâm ikiŋe den lokom bo hamep akmâ ");
INSERT INTO tim_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","wan me wan bâleŋe bo akmâ gala konok akmâ biwi irakŋeâk manbaen. ");
INSERT INTO tim_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nanne gâ irekŋe sigan akmâ Humonenŋe ulik gulik agaŋbiat. Gâŋe soŋ akmâ aregât hin dâm makyeŋgiwiat, “Humonenŋe irawot togom heŋgem nenguwiap aregât nâŋgâ nâŋgâyeŋe bâleŋe hepunbiâ biwiyeŋe Anutugâlân ari kindo Anutuŋe kambiamŋe nâŋgâm dosayeŋe hepun yeŋgiwiâp.” dâm makyeŋgimenâ nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gâ hain akmâ kembu luâklupŋe âlepŋaet den potatmâ yeŋgimenâ nâŋgâm heŋgemgombiâ dosayeŋe bo akbiâp. ");
INSERT INTO tim_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutunenŋe han kalemŋe humo yendâpgât dâmbo egonba hândâktâk pagalem arekŋe ");
INSERT INTO tim_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","hândâkŋân akto momo bâlâpŋân talion nen mem hauŋ nenekmap. Akto oloŋnenekmâ dâp sândukŋân katnenekmap.” Sakaria hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Akto nanaŋ are hagitŋe tiŋ tiŋ dâmbo hâk biwi olowâk humo agep. Humo akmâ manmâ eweŋe memeŋe hepun yelekmâ hân kamitŋângen luâk bo manmaiângen arim malep. Manmâ manmâ makyeŋgiwiapgât sop tâlâgumbo âmâ purik katmâ Israe luâk âmbâle hutyeŋân arim miawakmâ malep. ");
INSERT INTO tim_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Akto ulikŋân kiap humo siâ kotŋe Kuirinio yâk Siria yeŋgât kiap humo malep sop ain âmâ Roma luâk kotdâ siâ malep kotŋe Augusto yâkŋe den kârikŋe hin dâep, “Luâk hânŋe hânŋe areyeŋgât kotyeŋe oyaŋyekbiâ yekbian.” dâep. Are âmâ agak meme hain are umbuŋân bo agi. Irakŋe keiŋe katmâ kulemgoyi. ");
INSERT INTO tim_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Keiŋe katmâ hârogâk oyaŋ yekberâm akto aregât kepia yeŋângenba hârogâk purik katmâ arim meteyi. ");
INSERT INTO tim_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Arimbiâ Nasarete kepia are Galilaia hânân talep ain gâtŋe luâk siâ kotŋe Yosepe, are Dawidigât kâlegen gâtŋe are hainâk Yudaia hânân Dawidigât kepia kotŋe Betelehem ain ariwerâm âmbâle ikiŋe dâtâŋe are kewugumbo olop ariyiat. ");
INSERT INTO tim_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yosepe akto âmbâi patŋe dâtâŋe kotŋe Maria tepdâk malep are kewugumbo kotyetŋe kulemgowerâm ariyiat. ");
INSERT INTO tim_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Arim luâk yâkŋe menduguak menduguak emetŋe are pikbiâ aregât makao emetŋân âgâ taliat. ");
INSERT INTO tim_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tatbela Mariaŋe nanaŋ memberâm hâk hilâlâm nâŋgâmbo nanaŋ ulik gulikŋe miawagep. Miawakto sâŋgumŋe mem katipkom makaoŋe sot nemai ain kondoân katbela ge talep. ");
INSERT INTO tim_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Akto kepia ewumâk ain luâk bikŋande hândâgân umiliŋân lamalupyeŋe damunyeŋe akmâ kili. ");
INSERT INTO tim_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kinbiâ âmâ Anutugât aŋelo siâŋe yâk yeŋgâlân miawakto Anutugât pagaleŋande erâmbo ekmâ ongâyeŋe hogoep. ");
INSERT INTO tim_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Akto aŋelo arekŋe hin dâm makyeŋgiep, “Bo hamep akŋet. Nâŋgâi. Nâŋe den pat âlepŋe siâ mem togoân ire makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Uŋak ire âmâ heŋgemgo yekbiapgât luâk arekŋe âmâ Dawidigât kepia kautŋân ain miawaktâp. Yâkŋe âmâ damunyeŋe akbiap. Aregât den ire sambelem arimbo luâk âmbâle hârokŋe nâŋgâm heroŋe akbai. ");
INSERT INTO tim_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Akto nanaŋ are sâŋgumŋeak katipkom makaoŋe sot nemai kondo are kâlegen katbela tatâp gârâmâ arim âmâ mem miawakbi. Akto nâŋgât den bunŋe nâŋgâŋetgât arim mem miawakmâ nâŋgâm heŋgemgoŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aŋeloŋe den hain dâm makyeŋgimbo ainâk aŋelo kâmot humo togom galayeŋe peniaŋbiâ menduguakmâ kinmâ Anutugât kotŋe mem agatmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anutuŋe luâk âmbâle bikŋe nâŋgât dâtâŋe dâm potatyegep are yeŋgât heroŋe akyeŋgimbo yeŋgâlân gala konok miawak yeŋgiâp. Aregât nen hârogâk heroŋe akmâ himbimân egon Anutugât kotŋe mem agaten.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hain dâm himbimân purik katmâ âgâmbiâ lama damunyeŋe yâkŋe hin dâm magaŋgi goaŋgi agi, “Nen Betelehem kepian arim Anutuŋe aŋeloŋe huŋgun aŋdo gem den maknengiâp are bunŋe mem miawakne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hain dâm dowâk pârigim arim Maria akto Yosepe yâk yetgâlân arim mem miawakyelekmâ âmâ nanaŋ makaogât kondoân katbela ge talep are egi. ");
INSERT INTO tim_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ekmâ nanaŋ aregât den pat are luâk âmbâle makyeŋgim mali. ");
INSERT INTO tim_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Makmâ miawakbiâ nâŋgâm hin dâyi, “Yae, nanaŋ arekŋe hâmbâi gain gain akbiap?” dâmbiâ biwiyeŋe agalep. ");
INSERT INTO tim_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Akto Mariaŋe den are biwiŋân kato kindo malep. ");
INSERT INTO tim_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Akto lama damunyeŋe are purik katmâ arim wan me wan egi aregât den pat are nâŋgâm aŋeloŋe makyeŋgiep are miawagepgât Anutu mepaiŋe mem kotŋe mem agatmâ kinmâ heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Akto ainba hilâm nâmbulân âlâwu bo akto hâkŋe gâim kotŋe Yesu koli. Nanaŋ are bo miawaktoân aŋeloŋe Mariagâlân miawakmâ, “Kotŋe Yesu konbiat.” dâepgât aregât lauŋe lokom kotŋe Yesu dâm koli. ");
INSERT INTO tim_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Akto ulikŋân Moseŋe hin kulemgoep are tatâp, “Âmbenlupyeŋande nanaŋ membiâ âlepŋe akto âmâ Anutugât den pat lokombiâ yekto ârândâŋ akbiâp.” dâm den kârikŋe kulemgoep den are lokom kinmâ âmâ Maria akto Yosepeŋe Yesu mem Yerusalem kepian mem âgâyiat. ");
INSERT INTO tim_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Âgâm âmâ ulikŋân Anutuŋe den hin dâep are lokoyiat, “Nanaŋ luâk ulik gulik miawakto are âmâ Humogât pat konbai.” Den are lokom kinmâ agiat. ");
INSERT INTO tim_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Akto Humogât den kârikŋe siâ talep are hin, “Eweŋe memeŋe kembâ lâuwâ me gâmut lâuwâ mem huit oyelekmâ Anutu waŋbiandat.” Den are lokom kinmâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Akto sop ain Yerusalem kepian luâk siâ malep kotŋe Simeoŋ, yâkŋe âmâ Anutugât den lokom luâk âlepŋe manmâ Anutuŋe heŋgemgo nenekbiapgât huŋgun aŋdo miawakbiap aregât lâmgom malep. Akto Anutugât Heakŋande biwiŋân hutgombo malep. ");
INSERT INTO tim_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Akto emelâk Anutugât Heakŋande den siâ hin magaŋep, “Gâ boâk mombialân Anutu Humoyeŋande damunyeŋe agâkgât huŋgun aŋdo gewiap are miawakto ekbiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Akto Anutugât Heakŋande memeŋe agaŋdo owâiŋe akmâ Israe yeŋgât sumbe kat kat emetŋân âgâep. Âgâmbo âmâ Maria akto Yosepe Anutugât den lokowerâm nanyetŋe mem âgâmbela ");
INSERT INTO tim_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoŋŋe nanaŋ are lokom hin dâm Anutu magaŋep, ");
INSERT INTO tim_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Humo dondâ, hinŋe Israe damun nenŋe akbiap yâk miawakto ektângât biwine heroŋe aktâp. Den are emelâk magen ina are bunŋe aktâp. Hain gârâmâ mombiangât sop miawaktâp. ");
INSERT INTO tim_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Akto nanaŋ ire guge huŋgunaŋmenâ humo akmâ luâk âmbâle heŋgem nenguwiap ina ektân. ");
INSERT INTO tim_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Amâ gâ hân ârândâŋ luâk âmbâle hârokŋe ekŋetgât mem miawaktât. ");
INSERT INTO tim_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Arekŋe Anutu bo nâŋgaŋmai yâk yeŋgât han ewum pagalewiap. Akto luâklupge Israe nengât egâliaŋ pagaleŋe aknengiwiap.” ");
INSERT INTO tim_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nanaŋ aregât hain dâmbo eweŋe memeŋande nâŋgâmbela biwiyetŋe agatmâ hogoep. ");
INSERT INTO tim_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Akto Simeoŋŋe Anutuŋe tân yetkuâk dâm Anutu ulilaŋmâ nanaŋ aregât memeŋe are hin dâm magaŋep, “Nâŋgât. Israe potalakmâ bikŋe biwinenŋe yâkgâlân katenŋe kindo manbaen. Dâ bikŋe âmâ yâkgât hâkâŋ akbiâ biwiyeŋe pâlâmŋe akto bâliwai. ");
INSERT INTO tim_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Akto siân kambiamge dondâ bâliwiap. Hain are miawakto ain luâk dondâŋe agak memenenŋe ekmâ keinenŋe mem miawakbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Akto âmbâle siâ Anutugât den makmâ miawakmâ malep are kotŋe Hana are Panuegât baratŋe Asa kâmolân gâtŋe akto âmbâle arekŋe ulikŋân luâk mendo manbela hombaŋ nâmbulân lâuwâ bo akto luâkŋe moep. ");
INSERT INTO tim_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mondo aregât kakŋân ikiŋak kambut manmâ âgâmbo hombaŋ 84 are bo akto âmbâi kambut akmâ malep. Akto âmbâle arekŋe hilâmŋe ârândâŋ sumbe kat kat emetŋân âgâm Anutu ulilaŋminep. Akto sopŋe sopŋe sot bâlâk manmâ ulilaŋep. ");
INSERT INTO tim_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Akto yâkŋe sop ain sumbe kat kat emetŋân âgâm nanaŋ are egep. Ekmâ âmâ Anutu heroŋe agaŋmâ magaŋep. Magaŋmâ Yerusalem kepia ambolupŋande Anutuŋe damunyeŋe are huŋgun aŋbiap aregât lâmgom mali yâk Yesugât keiŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Akto Maria akto Yosepe den kârikŋe lokowerâm nanyetŋaet sot dâtâŋe are Anutu waŋmâ metem kepia yetŋângen Nasarete are Galilaia hânân talewân ain purik katmâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Arim manbela nanyetŋaet hagitŋe kârigembo nâŋgâ nâŋgâŋe humo akto Anutuŋe memeŋe agaŋep are nâŋgâm kinmâ agak meme âlepŋeâk akminep. ");
INSERT INTO tim_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Akto ulikŋân aŋelo siâŋe Israe luâk damunyeŋe akmâ Aigita are yeŋgât nanaŋ ulik gulik miawagi are yeŋguep aregât nâŋgâm hombaŋ kotŋe Pasowa ain serâ omini. Serâ omberâmbiâ sop miawakto aregât Yosepe akto Mariaŋe kepiayetŋe hepunmâ Yerusalem kepian âgâyiat. ");
INSERT INTO tim_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Akto Yesu nanaŋ are hombaŋŋe 12 akto luâk sisik akto serâ are omberâm kewugumbela olowâk âgâyi. ");
INSERT INTO tim_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Âgâm manbiâ hombaŋ are bo akto luâk âmbâle awam akbiâ âmâ Maria akto Yosepe yâkŋe nanyetŋe bo ekbela tato Yerusalem kepia are hepunmâ yetŋeâk purik kaliat. ");
INSERT INTO tim_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Purik katmâ arim hin nâŋgâyiat, “Nannetŋe kâmot humo yâk olop emelâk ariâp mon?” dâyiat. Hain dâm dâwân arim galalupyetŋe yeŋgât hutyeŋân undâgâtbela bo akto manbela hândâk agep. ");
INSERT INTO tim_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Akto galalupyetŋe aiyeŋgum undâgâtbela bo akto purik dâm Yerusalem kepian purik katmâ arim undâgâlaŋiat. ");
INSERT INTO tim_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Undâgâlaŋbela hilâm âlâwu bo akto âmâ sumbe emetŋe ain âgâyiat. Âgâmbela âmâ Yuda luâk den makyeŋgimini are yeŋgât hutyeŋân tatmâ amâ denyeŋe nâŋgâm aregât keiŋaet aiyeŋgumbo tali. ");
INSERT INTO tim_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hain tatmâ yâk hârogâkŋe nâŋgâ nâŋgâŋaet akto denŋaet nâŋgâm ekbiâ biwiyeŋe agatmâ hogoep. ");
INSERT INTO tim_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Akto yâk yeŋgât hutyeŋân tato mem miawakmâ âmâ han undup akmâ kiliat. Akto memeŋande hin dâm magaŋep, “Ewege olop net gâŋgât undâgât giŋdetŋe bo akto kuknetkimbo togoet. Aregât gâ wangât hain aktât?” ");
INSERT INTO tim_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hain dâmbo hin makyetkiep, “Gain gain akmâ kulâgâtniŋmâ mandat? Nâ Ewenaet âiân memberâm akman are bo nâŋgât me?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hain dâmbo denŋe are nâŋgâmbela hâumgoep. ");
INSERT INTO tim_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Are âmâ memeŋande denŋe are biwiŋân katmâ nâŋgâm gaep. Hain akto yâk olop Nasarete kepian purik katmâ arim yâk yetgât den lokom malep. ");
INSERT INTO tim_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Akto nâŋgâ nâŋgâŋe humo akto manmâ gambo Anutu akto luâk âmbâle hârokŋe ekbiâ ârândâŋ agep. ");
INSERT INTO tim_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roma luâk siâ kotŋe Tiberio Sisa are Roma yeŋgât luâk humo manmâ gambo hombaŋ 15 bo agep. Bo akto âmâ Yohaneŋe âi keiŋe katmâ miep. Sop ain luâk siâ kotŋe Pontio Pilato yâk Yudaia yeŋgât kiap humo malep. Akto luâk siâ kotŋe Herote yâk âmâ Galilaia luâk âmbâle yeŋgât damunyeŋe akmâ malep. Akto emiŋe kotŋe Pilipo yâkŋe âmâ Ituraia akto Trakoniti yâk yeŋgât luâk humo malep. Akto luâk siâ kotŋe Lisania, yâkŋe Abilene yeŋgât luâk humo malep. ");
INSERT INTO tim_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Akto sumbe kat kat luâk are yeŋgât kautŋe lâuwâ maliat kotyetŋe Anasi akto Kaipa luâk lâuwâ are luâk humo akmâ manmâ gayiat. Sop ain Sakariagât nanŋe kotŋe Yohane are hân kamitŋângen mando âmâ Anutuŋe den dâm waŋep. ");
INSERT INTO tim_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Den dâm waŋdo Yodaŋ tu biken biken manmâ hin dâm makyeŋgiep, “Agak memeyeŋe bâleŋe are makmâ miawakmâ biwiyeŋe Anutugâlân katbiâ kindo togombiâ tuân katyektere dosayeŋe bo agâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Akto ulikŋân Anutuŋe dâmbo propeteŋe Yesaia yâkŋe den hin kulemgoep aregât bikŋe hin tatâp, “Luâk siâŋe hân kamitŋângen manmâ hin dâm tatâp, Humogât dâp megatŋet. ");
INSERT INTO tim_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mem gimbâŋe mambâŋe are kârâmbiâ dâp konogâk agâk. Akto hân hutaguâk akto huruŋ dâmbo âmâ totokombiâ dâp ârândâŋâk agâk. Akto dâp goŋgoŋ meŋgoŋ are tâŋ tâŋâk heŋgemgowai. Akto dâp bâleŋe are mem âlepŋe ketuguŋet. ");
INSERT INTO tim_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Akto luâk âmbâle hârok Anutuŋe heŋgem nenguwerâm aktâp aregât keiŋe nâŋgâwai.” Yesaiaŋe hain kulemgoep are bunŋe akto Yohane miawagep. ");
INSERT INTO tim_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Akto luâk dondâ yâkŋe Yohanegâlân togom tuân kat nenegâk dâmbiâ aregât hin dâm makyeŋgiep, “Niambigât kâmot ye bâleŋaet hâuŋe togowerâm aktâp are hamewakmâ awam akmâ ariŋetgât niŋande makyeŋgiep? ");
INSERT INTO tim_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ye hanyeŋe purikatmâ manbaigât dopŋe bunŋe peniaŋmâ ariwai. Dâ hin bo makŋet, “Nen Abrahamgât kâmot manden.” Nâ makyeŋgire nâŋgâŋet. Anutuŋe kât ire makto luâk akmâ Abrahamgât kâmotlupŋe irakŋe yeŋgât dumyeŋân miawakbai. ");
INSERT INTO tim_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Akto den ginŋe siâ makyeŋgiwe. Unam are emelâk dâtŋe hâwim lâwin keiŋân kato tatâp. Arekŋe lâwin siâ bunŋe bo kindâp are kârâm kâlâwân ombiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hain dâm makyeŋgimbo âmâ hin dâm aikoyi, “Wei, aregât gain gain akbaen?” dâmbiâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Luâk siâŋe hâk pekeŋe lâuwâ talaŋdo galaŋe umburuk mandâp are ekmâ âmâ âlepŋe waŋbiâp. Akto sot potatmâ waŋbiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Akto gawaman puli meme luâk yâkŋe hainâk tuân katnenegâk dâm togoyi. Togom aikom hin dâyi, “Ewenenŋe, nen gain gain akbaengât nâŋgât?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hain dâmbiâ hin makyeŋgiep, “Damunlupyeŋande gawaman puli dop hainâk meŋet dâm makyeŋgimbiâ aregât yeŋe siâ bo dewatim membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Akto tembe loko yâkŋe hainâk yâkgâlân togom dâyi, “Nenŋe âmâ gain gain akbaengât nâŋgât?” dâmbiâ hin dâm makyeŋgiep, “Siâgât wan me wan ekmâ kukyeŋgimbiâ yeukŋe akbiâ are bo membai. Akto wan me wan memberâm akmâ âmâ bo hiaŋgim ire nengât dâwai are borondâ membai. Agak meme ire akbai âmâ âigât puliŋe yeŋgimai are ârândâŋ akto areâk membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Akto luâk arekŋe Yohanegât nâŋgâm biwiyeŋe hikom hin dâyi, “Anutuŋe huŋgun aŋdo togom damun nenŋe akbiap aregât biwinenŋân katmâ manmaen are ire me aŋgâ?” dâm nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nâŋgâm aikombiâ hin dâm makyeŋgiep, “Nâ tu yân puliyektân. Dâ siâ haminângen togom mandâp yâk âmâ kârikŋeŋe dop siâ yeaŋdâp. Yâk nâ hin arekŋe sikumgât ito goliaŋdere ârândâŋ bo akbop. Yâkŋe âmâ Heakgât kâlâp are puliyekbiap. ");
INSERT INTO tim_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Akto yâkgât den ginŋe siâ makyeŋgiwe. Sot pipiŋe urutmâ kâlâwân panmaen dop hainâk yâkŋe gagap mem urutmâ kâlâwân katbiap. Dâ sot neneŋe kitalân katmaen dop hainâk sot âlepŋe potatmâ katbiap.” ");
INSERT INTO tim_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohaneŋe hainâk dâm pat âlepŋe are kârikŋeâk makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Akto sop ain luâk humo Herote yâkŋe âmâ kandâŋe kotŋe Herodia are emiŋaet âmbâle are kâmbu miep. Mem âmâ aregât kakŋân agak meme bâleŋe dondâ mendo dosaŋe humo miawagep. Hain akto Yohaneŋe, “Bo agakŋe aktât.” dâm den kârikŋe magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Magaŋdo nâŋgâmbo bâlimbo aregât Yohane mem lope kâlegen kato talep, aregât Heroteŋe dosa siâ miep. ");
INSERT INTO tim_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ulikŋân luâk dondâŋe Yohanegâlân arim tuân katyegâkgât magaŋi. Magaŋbiâ tuân katyegep. Katyekto âmâ Yesu yâkâ hainâk arim magaŋep. Magaŋdo tuân kato sopanmâ Anutu ulilaŋdo ainâk himbim pâroŋ âgâmbo ");
INSERT INTO tim_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Anutugât Wâtgât memeŋe Heakŋande himbimânba lâut kotŋe kembâ hainare akmâ Yesugât kakŋân giep. Gembo himbimânba Anutuŋe den siâ hin dâm Yesu magaŋep, “Gâ nanne kambiamnân gâtŋe aregât gekmâ ukenŋe nâŋgân.” Anutuŋe den hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Yesu bâgilupŋaet kotyeŋe âmâ hin. Keiŋe katmâ Anutuŋe Adam akto Ewa kat yelegep. Akto Adamŋe Ewa mendo Sete miep. Seteŋe humo akmâ âmbâle mendo nanŋe kotŋe Enosi miep. Enosiŋe humo akmâ âmbâle mendo nanŋe kotŋe Kenaŋ miep. Kenaŋŋe humo akmâ âmbâle mendo nanŋe kotŋe Mahalale miep. Mahalaleŋe humo akmâ âmbâle mendo nanŋe kotŋe Yarede miep. Yaredeŋe humo akmâ âmbâle mendo Enoko miep. Enokoŋe humo akmâ âmbâle mendo Metusala miep. Metusalaŋe humo akmâ âmbâle mendo Lamek miep. Lamekŋe humo akmâ âmbâle mendo Noa miep. Noaŋe humo akmâ âmbâle mendo Sem miep. Semŋe humo akmâ âmbâle mendo Arpasada miep. Arpasadaŋe humo akmâ âmbâle mendo Kenaŋ miep. Kenaŋŋe humo akmâ âmbâle mendo Sela miep. Selaŋe humo akmâ âmbâle mendo Ebe miep. Ebeŋe humo akmâ âmbâle mendo Pelege miep. Pelegeŋe humo akmâ âmbâle mendo Ragau miep. Ragauŋe humo akmâ âmbâle mendo Serugu miep. Seruguŋe humo akmâ âmbâle mendo Naho miep. Nahoŋe humo akmâ âmbâle mendo Tara miep. Taraŋe humo akmâ âmbâle mendo Abraham miep. Abrahamŋe humo akmâ âmbâle mendo Isaka miep. Isakaŋe humo akmâ âmbâle mendo Yakobo miep. Yakoboŋe humo akmâ âmbâle mendo Yuda miep. Yudaŋe humo akmâ âmbâle mendo Perese miep. Pereseŋe humo akmâ âmbâle mendo Hesoroŋ miep. Hesoroŋŋe humo akmâ âmbâle mendo Arani miep. Araniŋe humo akmâ âmbâle mendo Adamin miep. Adaminŋe humo akmâ âmbâle mendo Aminadaba miep. Aminadabaŋe humo akmâ âmbâle mendo Nasoŋ miep. Nasoŋŋe humo akmâ âmbâle mendo Sala miep. Salaŋe humo akmâ âmbâle mendo Boasi miep. Boasiŋe humo akmâ âmbâle mendo Obede miep. Obedeŋe humo akmâ âmbâle mendo Isai miep. Isaiŋe humo akmâ âmbâle mendo Dawidi miep. Dawidiŋe humo akmâ âmbâle mendo Nataŋ miep. Nataŋŋe humo akmâ âmbâle mendo Matata miep. Matataŋe humo akmâ âmbâle mendo Mena miep. Menaŋe humo akmâ âmbâle mendo Melea miep. Meleaŋe humo akmâ âmbâle mendo Eliakim miep. Eliakimŋe humo akmâ âmbâle mendo Yonam miep. Yonamŋe humo akmâ âmbâle mendo Yosepe miep. Yosepeŋe humo akmâ âmbâle mendo Yuda miep. Yudaŋe humo akmâ âmbâle mendo Simeoŋ miep. Simeoŋŋe humo akmâ âmbâle mendo Lewi miep. Lewiŋe humo akmâ âmbâle mendo Matata miep. Matataŋe humo akmâ âmbâle mendo Yorim miep. Yorimŋe humo akmâ âmbâle mendo Eliese miep. Elieseŋe humo akmâ âmbâle mendo Yosua miep. Yosuaŋe humo akmâ âmbâle mendo Ere miep. Ereŋe humo akmâ âmbâle mendo Elimadam miep. Elimadamŋe humo akmâ âmbâle mendo Kosam miep. Kosamŋe humo akmâ âmbâle mendo Adi miep. Adiŋe humo akmâ âmbâle mendo Meliki miep. Melikiŋe humo akmâ âmbâle mendo Neri miep. Neriŋe humo akmâ âmbâle mendo Sealitie miep. Sealitieŋe humo akmâ âmbâle mendo Serubabe miep. Serubabeŋe humo akmâ âmbâle mendo Resa miep. Resaŋe humo akmâ âmbâle mendo Yoanan miep. Yoananŋe humo akmâ âmbâle mendo Yoda miep. Yodaŋe humo akmâ âmbâle mendo Yosek miep. Yosekŋe humo akmâ âmbâle mendo Semeiŋ miep. Semeiŋŋe humo akmâ âmbâle mendo Matatia miep. Matatiaŋe humo akmâ âmbâle mendo Mata miep. Mataŋe humo akmâ âmbâle mendo Nagai miep. Nagaiŋe humo akmâ âmbâle mendo Esili miep. Esiliŋe humo akmâ âmbâle mendo Nahum miep. Nahumŋe humo akmâ âmbâle mendo Amosi miep. Amosiŋe humo akmâ âmbâle mendo Matatia miep. Matatiaŋe humo akmâ âmbâle mendo Yosepe miep. Yosepeŋe humo akmâ âmbâle mendo Yanai miep, Yanaiŋe humo akmâ âmbâle mendo Meliki miep. Melikiŋe humo akmâ âmbâle mendo Lewi miep. Lewiŋe humo akmâ âmbâle mendo Matata miep. Matataŋe humo akmâ âmbâle mendo Eli miep. Eliŋe humo akmâ âmbâle mendo Yosepe miep. Akto Yosepegât hin nâŋgâm hilipkoyi, “Yosepeŋe âmâ Yesugât eweŋe.” hain dâyi. Dâ Yesu amâ Anutugât nanŋe are himbimân gâtŋe. Akto Yesuŋe mando hombaŋ 30 are bo akto âmâ âi keiŋe kalep. ");
INSERT INTO tim_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Anutugât Heakŋande Yesu huŋgun aŋdo Yodaŋ tu are hepunmâ hân kamitŋe siân ariep. ");
INSERT INTO tim_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Arim âmâ sot bâlâk manmâ gambo hândâk hilâm 40 bo agep. Sop ain mopŋe dondâ aguep. Hain akto Niambiŋe yâk dop komberâm hin dâm magaŋep, ");
INSERT INTO tim_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","“Mopge aguâpgât gâ Anutugât nanŋe akto âmâ kât ire makmenâ sot akto ne.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dâmbo hin magaŋep, “Bo, Anutuŋe den hin dâmbo kulemgoyi are hin tatâp, Anutuŋe damun nenŋe akmap aregât nenŋe sotgâlâk nâŋgâm mandenŋe ârândâŋ bo akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hain dâmbo Niambiŋe hân gimbâŋe siân oloŋmâ âgâm âmâ luâk hânŋe hânŋe manmâ ariyi are yeŋgât sikum me ito siâ siâ hekalaŋep. ");
INSERT INTO tim_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hekalaŋmâ hin magaŋep, “Nâŋe ire hârok damunyeŋe aktân. Akto ire hârok niŋande damunyeŋe agâk dâm nunagâk damunyeŋe akman. Akto niŋande nâŋgât okotnân malâk dâm nunak hain akman. ");
INSERT INTO tim_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aregât kotne mem agatmenâ âmâ sikum me wan me wan ire hârok damunyeŋe katgekmâ giŋbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hain dâmbo den hâuŋe hin magaŋep, “Anutuŋe den hin dâmbo kulemgoyi are tatâp. Kembu Anutu konok hoŋ bawa agaŋmâ kotŋe mem agatben.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Hain dâmbo âmâ Niambiŋe Yesu mem sumbe kat kat emetŋe Yerusalem kepian talep aregât bokŋân oloŋmâ âgâm katmâ hin dâm magaŋep, “Anutuŋe den siâ hin dâmbo kulemgoyi are tatâp, “Nâŋe aŋelolupne huŋgun yeŋgire meŋgekmâ tân gugum damunge akŋet. Kâlân gugum keige hârewopgât aŋelolupnande bâtgân meŋgekŋet.” aregât gâ Anutugât nanŋe mandât aregât gâ inba sopanmenâ aŋeloŋe damunge akbiâ kâlân me wan me wanân bo guguwerâp âlepŋe sopanberât.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Hain dâmbo hin magaŋep, “Anutugât den siâ hin tatâp, Anutuŋe damunge aktâpgât keiŋe ekberâm dop komenâ ârândâŋ bo aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hain dâmbo Niambiŋe hepunmâ sop siângât lâmgom malep. ");
INSERT INTO tim_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Anutugât Heakŋande Yesu memeŋe agaŋdo Galilaia hânân purik katmâ ariep. Purik kato aregât den patŋe sambelem arimbo kepia ambolupŋe hârogâk nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Akto ain den emetŋe ârândâŋ arim den potatmâ yeŋgimbo kâŋgoaŋmâ kotŋe makmâ egâliaŋi. ");
INSERT INTO tim_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hain akmâ arim nanaŋânbak manmâ gaep ikiŋaet kepia Nasarete ain arim âi bo meme sopŋân Sarere ârândâŋâk den emetŋân âgâminep. Hainâk âgâm malep. Âgâm manmâ Anutugât den emelâk kulemgoyi are oyaŋberâm âgâmbo ");
INSERT INTO tim_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","propete luâk Yesaiaŋe kulem kulemgoep are waŋi. Waŋbiâ mem kelalakom ekmâ den hin kulemgoep talep are oyaŋmâ makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Humogât Heakŋande meme akniŋdo kinmâ den hin dâm makniŋep, “Luâk biwiyeŋe umat bâleŋân mandâi are yeŋgâlân arim den pat âlepŋe makyeŋgiwen. Akto hikoyekto mandâi amâ hulaŋyekben. Akto luâk dewunyeŋe bok bokŋe yâk yeŋgâlân arim makyeŋgimenâ dewunyeŋe hulaŋ akto âlepŋe ekbai. ");
INSERT INTO tim_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Akto Anutuŋe tân yeŋguwiapgât sop tâlâguâp aregât den pat makyeŋgiwen.” hain dâm makniŋep.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Den hain dâm oyaŋmâ kulem esenŋe are mem bigeim hoŋ bawa siâ waŋmâ âmâ ge talep. Ge tato den emetŋân tali yâkŋe hârogâk hewugem ekmâ tali. ");
INSERT INTO tim_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ekbiâ den hin dâm makyeŋgiep, “Den ya oyaŋdere nâŋgâi are uŋak yu dewunyeŋân bunŋe miawaktâp.” ");
INSERT INTO tim_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hain dâmbo nâŋgâmbiâ den are ukenŋe akto hin dâyi, “O, ire Yosepegât nanŋe arekŋe gain gain uŋak den bunŋe akto âlepŋe miawaktâp dâp.” ");
INSERT INTO tim_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hain dâmbiâ aregât hin dâm makyeŋgiep, “Yeŋe hin dâm makniŋmai, “Gâŋe siâ heŋgemgoen aregât hinŋe guge heŋgemgoak. Akto Kapanaum kepian âi ketugumenâ den patge nâŋgâmaen hainâk kepia iren ketugumenâ ekne.” hain dâm makniŋmai. ");
INSERT INTO tim_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aregât den bunŋe makyeŋgire nâŋgâŋet. Anutuŋe propetelupŋe makyeŋgimbo are makmâ miawakbiâ areyeŋgât ginbailupyeŋande denyeŋe bo nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ulikŋân Israe luâk siâ kotŋe Elia malep sop ain dewutâ kârikŋe kondo hombaŋ âlâwu dewutâ nâmbulân konok hain bo akto âmâ mop humo miawakto luâk âmbâle hârok sot bâlâk mali. ");
INSERT INTO tim_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Akto sop ain Israe yeŋgât âmbâle kambut dondâ manmâ gambiâ âmâ Anutuŋe Elia huŋgun aŋdo ikiŋe kepia hepunmâ Yuda luâk bo manmaiân Sareta kepia are Sidoŋ hânân talep, ain âmbâle kambut siâ yâkgâlân arimbo Anutuŋe tângombo sot waŋdo niep. ");
INSERT INTO tim_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Israe luâk siâ kotŋe Elisa malep sop ain Israe kepia ambolupŋe dondâŋe hâk bâle agi. Akto yâk yeŋgâlân gâtŋe siâ bo âlepŋe akbiâ luâk siâ kotŋe Naemaŋ are Yuda luâk bo manmaiân Siria hânân gâtŋe konokŋe âlepŋe agep.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hain dâm makyeŋgimbo den emetŋân taliŋe den are nâŋgâmbiâ bâliepgât kuk dondâ akmâ ");
INSERT INTO tim_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","agatmâ kepia hamiŋângen mem bam borâŋe siân âgâm katmâ ainba hemem dâtŋân mem, “Pandenŋe geâk.” ");
INSERT INTO tim_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","dâmbiâ bo menekŋet dâm hut yeŋânba hepun yekmâ gem ariep. ");
INSERT INTO tim_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Akto arim kepia siâ kotŋe Kapanaum are Galilaia hânân talewân ain arimbo âi bo meme sopŋân Sarere akto den makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Makyeŋgimbo are nâŋgâm hin dâyi, “Oe, luâk irekŋe den maknengim tatâp are nâŋgâenŋe dâtŋe kârikŋe aktâp.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hain dâmbiâ den emetŋân ain luâk siâ kinmâ sinduk baniara bâleŋande kautŋân mendo den humo akmâ hin dâep, ");
INSERT INTO tim_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Woe, Yesu Nasarete kepia amboŋe gâ wangât nengâlân togoât? Keige nâŋgân. Gâ Anutugât nanŋe bunŋe mandâtgât hilip nenguwerâm togoât.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesuŋe magaŋmâ hin dâep, “Den bo ak. Luâk ire hepunmâ ari.” dâep. Hain dâmbo sinduk baniaraŋe hepunmâ pando ge hutyeŋân yem âlepŋe akto ariep. ");
INSERT INTO tim_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hain manmâ arimbo ekbiâ hanyeŋe undup akto hin magaŋgi goaŋgi agi, “Wâe, ire âmâ gain gain? Sinduk baniara bâleŋe magaŋdo hepunmâ ariâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hain dâmbiâ aregât den pat sambelem arim kepia biken biken ârândâŋ akmâ arimbo yâkgât magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Akto Yesuŋe agatmâ den emetŋânba gem ariep. Arim luâk siâ malep kotŋe Simoŋ Petoro yâkgât emelan âgâep. Âgâmbo âmâ Simoŋgât hewonŋe kundat akmâ hâkŋe kâlâp akto yem kilep. Aregât ginbailupŋande Yesu ulilaŋi. ");
INSERT INTO tim_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ulilaŋbiâ yâkgât enemŋân ba kinmâ kundatgât makto âlepŋe agep. Âlepŋe akmâ agatmâ sot om yeŋgimbo neyi. ");
INSERT INTO tim_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Akto dewutâ kulukberâmbo âmâ galalupyeŋande kundat agi are meyekmâ Yesugâlân togombiâ bâtŋandeak meyekto kundat ainâk bo akyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Akto sinduk baniara bâleŋe are watyeŋgimbo âmâ hepunyekmâ bam arim hin dâyi, “Gâ Anutugât nanŋe huŋgun giŋdo togoen.” dâmbiâ Yesuŋe mem iratyeŋgum hin dâm makyeŋgiep, “Den bo ak.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Akto yem kinbiâ hauŋdo emelanba gem hân siâ luâk bo manmaiângen ariep. Pumângen arim mando luâk dondâ undâgâtmâ manmâ mem miawakmâ hin dâm magaŋi, “Gâ nen olop in manbaengât nâŋgâen.” dâmbiâ hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","“Bo, kepia ârândâŋ arim Anutugât den âlepŋe makyeŋgire lokom manbai aregât huŋgun niŋdo geân.” ");
INSERT INTO tim_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hain dâm Yuda yeŋgât den emetŋe ârândâŋ arim manmâ den makyeŋgim malep. ");
INSERT INTO tim_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hilâm siân Yesuŋe Genesaret bâtgum dâtŋân kindo Anutugât den are nâŋgâwerâm gam ândeaŋmâ kinbiâ ");
INSERT INTO tim_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","waŋga lâuwâ yelegep. Aregât ambolupŋande waŋganba sopanmâ iŋan ito pulim kili. Akto iŋangât ito pulim kinbiâ ");
INSERT INTO tim_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesuŋe Simoŋgât waŋgan âgâm hin magaŋep, “Den makyeŋgiwerân aregât waŋga ire memenâ getek bam indâŋân kilâk.” dâmbo mendo indâŋângen ariyi. Arim tatbiâ Yesuŋe kâmot nupiân kili are den makyeŋgim malep. ");
INSERT INTO tim_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Makyeŋgimbo bo akto Simoŋ hin dâm magaŋep, “Bâtgum tânâmŋân arim âmâ iŋan ito panmâ iŋan oloŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Hain dâmbo Simoŋŋe hin dâm magaŋep, “Apo, hândâkŋân sop kâlep manmâ iŋan itoŋe are pandenŋe gembo iŋan siâ bo menden. Bo dondâ. Gârâmâ gâŋgât den are lokom arim iŋan ito panmâ ekberen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hain dâmbo âmâ iŋan ito are panbiâ gembo iŋan dondâ kâlegen kulukbiâ aregât umatŋân tâk hâre akberâm agep. ");
INSERT INTO tim_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hain akto hâk hilâlâm nâŋgâm âmâ galalupyeŋe waŋga siân mali are yeŋgonbiâ gam tân yeŋguyi. Tân yeŋgum iŋan are bikŋe membiâ waŋga lâuwâ lâuwâ pikto âmâ kumbuŋe kawut yekberâm agep. ");
INSERT INTO tim_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Hain akto Petorogât galalupŋe akto emi teulogâtŋe lâuwâ kotyetŋe Yakobo akto Yohane are Sebedaio nanlogâtŋe yâkŋe iŋan dondâ are ekmâ sân sân meyi. Sân sân membiâ Simoŋ Petoroŋe Yesugât keiŋân kâŋgom gem hin dâep, “Woe, Humo, dosane humo mem luâk bâleŋe manman aregât hepun nekmâ ari.” dâep. Hain dâmbo Yesuŋe hin dâep, “Gâ bo hamewak. Iŋangât âi memat dop hainâk hâmbâi luâk mem oloŋ yekmenâ nâŋgât kâmot akbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hain dâmbo waŋga are membiâ nupiân âgâmbo âmâ wan me wan are hepunmâ Yesu olop arim mali. ");
INSERT INTO tim_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuŋe manmâ kepia are hepunmâ siângen ariep. Arimbo luâk siâ hâk bâle kârikŋe malep arekŋe Yesu ekmâ âmâ enemŋân gam hin dâm ulilaŋep, “Kotdâ, gâŋe diwi bâle aktân ire mem howai nekmenâ âlepŋe akberân aregât kârikŋe tatgiŋdâp aregât gugak mem howai nekmenâ âlepŋe akberân me bo?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hain dâmbo Yesuŋe hâkŋe mem howaiep. Howaim hin dâm magaŋep, “Nâŋgâ giŋdângât pandagâk.” dâmbo ainâk hâk bâle are pandakto ârândâŋ agep. ");
INSERT INTO tim_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Akto Yesuŋe den hin magaŋep, “Gâŋe iregât pat luâk bo makyeŋgim yânâk arim âmâ sumbe kat kat luâk are yeŋgâlân arimenâ gekbi. Akto diwi pandak giŋdâp iregât Moseŋe den kulemgoep are lokom Anutugât pat soŋgo huit omenâ are ekmâ hin dâwai, “Âo, luâk iregât diwi bâle emelâk pandakto ârândâŋ aktâp.” dâwai.” dâep. Yesuŋe hain dâm magaŋdo ariep. ");
INSERT INTO tim_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hain magaŋdo luâk âlepŋe agep aregât den pat arekŋe sambelem kepia ârândâŋ arimbo hin dâm magaŋgi goaŋgi akmini, “Yesuŋe den makto nâŋgâenŋe bunŋe akbiap, are âmâ kundatnenŋe bo aknengiwiapgât yâkgâlân arine.” Hain dâm hârogâkŋe yâkgâlân arimini. ");
INSERT INTO tim_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Arim mendugum kinbiâ hepun yekmâ hân pumângen arimbo Anutu olop den akminiat. ");
INSERT INTO tim_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Akto hilâm siân Yesuŋe den makmâ hulaŋmâ potatmâ yeŋgim malep. Mando âmâ Parisaio luâk akto Mosegât den kârikŋe oyaŋmâ makyeŋgiyi are Galilaia hânân gâtŋe akto Yudaia hânân gâtŋe akto Yerusalem kepian gâtŋe arekŋe togom tali. Tatbiâ Anutuŋe Yesu memeŋe agaŋdo âmâ luâk heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Heŋgem yeŋgumbo ainâk luâk bâtŋe keiŋe kârigiep siâ galalupŋande temân katmâ lokom togoyi. Togom âmâ emelan mem âgâm Yesugât enemŋân katberâm ");
INSERT INTO tim_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","âmâ luâk gam turuŋ panmâ kili. Aregât gain gain akmâ katne dâm tirekŋânba âgâm emet bokŋân kinmâ ainba bok gagaimbiâ dâpŋe miawakto ainba luâk are temdâk tâgân panbiâ gem gem luâk âmbâle hutyeŋân Yesugât enemŋân giep. ");
INSERT INTO tim_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Gembo Yesuŋe biwiyeŋe ekmâ nâŋgâm âmâ luâk kundatdâ are hin dâm magaŋep, “Dosage puligiŋdângât Anutuŋe hâuŋe bo giŋbiap.” ");
INSERT INTO tim_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hain dâmbo Mosegât den makyeŋgiyi akto Parisaio luâk yâkŋe den are nâŋgâm âmâ biwiyeŋân hin nâŋgâyi, “Anutuŋe ikiŋak âmâ dosayeŋe hepun yeŋgimap ina luâk irekŋe yâkgât dop akberâmbo bâliâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hain nâŋgâm kinbiâ Yesuŋe yekmâ nâŋgâm âmâ hin dâm makyeŋgiep, “Biwiyeŋân hain nâŋgâi are âmâ ârândâŋ bo aktâp. ");
INSERT INTO tim_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gain gain arekŋe owâiŋe luâk bâleŋe ire hin dâm magaŋberân, “Anutuŋe dosage hepundâp.” hain dâm magaŋberân me hin dâm magaŋberân, “Agatmâ ari.” ");
INSERT INTO tim_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aregât maktere nâŋgâŋet. Nâ Anutuŋe dosayeŋe puliwiangât huŋgun niŋdo geân aregât Anutuŋe nâ kârikŋe niŋep aregât keiŋe ekmâ nâŋgâŋet.” dâep. Hain dâm makyeŋgim aregât luâk bâtŋe keiŋe kârigiep are hin dâm magaŋep, “Agatmâ tem tâkge meakmâ emetgân ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hain dâm magaŋdo ainâk tem tâkŋe meakmâ Anutu kotŋe mem agatmâ kepiaŋângen ariep. ");
INSERT INTO tim_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Arimbo ekmâ nâŋgâm bâtyeŋe dâtyeŋân igim kinmâ Anutu kotŋe mem agatmâ hin dâyi, “Uŋak iren agak meme irakŋe pup pup ekten.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Akto Yesuŋe emelanba gem ariep. Arimbo puli meme luâk siâ kotŋe Lewi yâkŋe gawamangât puli emetŋân tato ekmâ hin dâm magaŋep, “Gâ nâ penâniŋmenâ olowâk manbaet.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewiŋe wan me wan are hârok hepunmâ agato Yesu olop ariyiat. ");
INSERT INTO tim_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Akto Lewiŋe Yesu ikiŋe emelan talâk dâm kewugum âgâm Yesugât heroŋe nâŋgâm sot oep. Om puli meme luâk akto luâk bikŋe meyekto gambiâ olop sot neyi. ");
INSERT INTO tim_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nem tatbiâ Parisaio luâk akto Mosegât den makyeŋgiyi yâkŋe yekmâ nâŋgâmbiâ bâlimbo Yesu olop mali are hin dâm makyeŋgiyi, “Yeŋe Roma yeŋgât gawaman puli meme luâk akto luâk bâleŋe yâk olop tatmâ sot nembiâ ârândâŋ bo aktâp.” ");
INSERT INTO tim_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hain dâmbiâ Yesuŋe nâŋgâm hin dâm makyeŋgiep, “Âlepŋe manmai are yeŋgâlân doktaŋe âi bo ketugumai. Kundatdâ areyeŋgâlân âi ketugumai. ");
INSERT INTO tim_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aregât keiŋe hin. Nâŋe luâk âlepŋeâk bo meyekman. Luâk bâleŋe olowâk mem oloŋ yektere aregât bâleŋe yeŋe makmâ miawakbiâ biwiyeŋe Anutugâlân ari kilâkgât dâm yeŋgât geân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yesuŋe hain dâmbo Parisaio akto Mosegât den makyeŋgiyi are yeŋgâlân gâtŋe bikŋande hin dâm magaŋi, “Yohane olop manmai arekŋe âmâ hilâm ârândâŋ sot hepunmâ manmâ Anutu ulilaŋmai. Akto nengâlân gâtŋe hainâk akmâ manmai. Gârâmâ gâ olop mandâiŋe sot hanâk nem manmai are nâŋgâenŋe ârândâŋ bo aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Luâk humo siâŋe âmbâle mendo âmâ sot ombiâ kâmotlupŋe yâk olop heroŋe akmai sop ain âmâ bikŋande sot bo nem yân tatberen dâmbiâ aregât ârândâŋ bo akmap. ");
INSERT INTO tim_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bo kârikŋe. Hâmbâi luâk humo nâ menekmâ kewugunekbiâ bo aktere âmâ undâgât niŋmâ okotyeŋe nâŋgâm sop ain âmâ sot bâlâk manbai.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hain dâm âmâ ikiŋaet den ginŋe siâ hin dâm makyeŋgiep, “Luâk siâŋe sâŋgum irakŋe hârem arekŋe mem hâk katipŋe duwalak duwalakŋe tâmbâŋe are bo parutmap. Sâŋgum irakŋe tâmbâŋe hut bit parutmap dâine sâŋgum irakŋe are bâliwop akto sâŋgum lâuwâ are dopŋe konok bo akbop. ");
INSERT INTO tim_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Akto nen âmâ waiŋ tu irakŋe yo hâkŋe tâmbâŋân bo kâienŋe gemap. Hain akmaen dâine waiŋ tuŋe arekŋe yo hâkŋe are mendo âmâ bim âgâm hogoakbop. Akto waiŋ akto yo hâkŋe lâuwâ lâuwâ bâlewat. ");
INSERT INTO tim_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aregât waiŋ irakŋande yo hâkŋe irakŋân gembo âlepŋe akmap. ");
INSERT INTO tim_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dâ siâ waiŋ tâmbâŋe nem hanŋe agepŋe waiŋ irakŋe aregât hâkâŋ akmâ hin dâwiap, “Tâmbâŋe are nendere ukenŋe aktâp.” dâwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Akto Sarere âi bo meme sop siân Yesu olop maliŋe kalam ginŋângen ariyi. Arim olop mali yâkŋe kalamânba sot bâikŋe konok konok are mem hâkŋe digim neyi. ");
INSERT INTO tim_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hain akbiâ Parisaio luâk arekŋe yekmâ hin dâyi, “Ye wangât hain aktâi? Uŋak âi meme sopŋe bo aregât âi membiâ ârândâŋ bo aktâp.” ");
INSERT INTO tim_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hain dâmbiâ Yesuŋe hin dâm makyeŋgiep, “Ye bo nâŋgâi me? Dawidi akto luâklupŋe mop miawak yeŋgimbo agi are nâŋgâi me bo? ");
INSERT INTO tim_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yâkŋe hin agi. Dawidiŋe Anutugât sumbe kat kat emetŋân âgâm sot Anutugât pat dâm kali are mem nem bikŋe luâklupŋe yeŋgimbo olowâk neyi. Sot are luâk aŋgâ yeŋgât pat borâm sumbe kat kat luâk are yeŋgâlâk dâm magi. Ainba yâkŋe hanâk mem neyi. ");
INSERT INTO tim_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aregât keiŋe makmâ miawaktere nâŋgâŋet. Nâ Anutuŋe huŋgun niŋdo luâk akmâ geân Sarereân âi bo meme aregât kautŋe akmâ mandân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Akto Sarere siân den emetŋân âgâm den makyeŋgiep. Makyeŋgimbo luâk siâ talep aregât bâtŋe bungen âmâ kamunŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hain akto Mosegât den kârikŋe makyeŋgimini akto Parisaio luâk arekŋe, “Yesuŋe luâk ire mem heŋgemgowerâp me bo?” dâm aregât ekmâ âmâ denân katbaen dâm aregât damungom tali. ");
INSERT INTO tim_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Akto Yesuŋe yekmâ nâŋgâm âmâ luâk bâtŋe kamunŋe are hin magaŋep, “Agatmâ kin.” dâmbo agatmâ kilep. ");
INSERT INTO tim_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kindo damungom kili are hin makyeŋgiep, “Sarere âi bo meme sopŋân wan me wan âlepŋe me bâleŋe akbaen are luâk heŋgem yeŋgumaen me hilip yeŋgumaen aregât makniŋbiâ nâŋgâwe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hain dâm tâŋâk yekto den hâuŋe bo magaŋi. Yân kinbiâ bâtŋe kamunŋe are ekmâ hin magaŋep, “Bâtge mem agat.” dâmbo bâtŋe mem agato âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Akto are ekmâ hin magaŋgi goaŋgi agi, “Sarere âi meme sopŋe boân ina âi ire mendo ârândâŋ bo aktâp. Aregât gain gain akne.” dâm Yesugât kuk bâleŋe akmâ kili. ");
INSERT INTO tim_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Akto sop siân emet dâgâwerâm akto Yesuŋe gimbâŋe siân Anutu magaŋberâm âgâep. Âgâmbo Anutu olop den akbela emet hauŋdo ");
INSERT INTO tim_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","luâk olop mali hutyeŋânba keiân lâuwâ are mem oloŋ yegep. Oloŋyekmâ âmâ Aposolo yeŋgonlep. ");
INSERT INTO tim_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Dâ kotyeŋe ikiŋeâk ikiŋeâk âmâ hin. Simoŋ kotŋe siâ Petoro emiŋe Anderea, Yakobo, Yohane, Pilipo, Batolomaio, ");
INSERT INTO tim_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio, Toma, Yakobo siâ are Alipaiogât nanŋe akto Simoŋ siâ Roma yeŋgât hâkâŋ agi are yeŋgâlân gâtŋe akto ");
INSERT INTO tim_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudasi are Yakobogât nanŋe akto Yudasi siâ Karioto kepian gâtŋe arekŋe âmâ beirâ Yesugât gasalupŋe makyeŋgimbo kombiâ moep. ");
INSERT INTO tim_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yâk meyekmâ gimbâŋe kautŋângenba gem hân ukuleŋân arim luâk âmbâle dondâ penâyeŋgiyi. Penâyeŋgimbiâ luâk dondâ yâk yeŋgâlân togom menduguyi. Akto Yudaia hânângenba akto Yerusalem kepiangenba akto Tiro akto Sidoŋ kepia are haru dâtŋân talewângenba togom mendugu akbiâ den potatmâ yeŋgiep. Akto kundat agi are yeŋgât makto âlepŋe agi. ");
INSERT INTO tim_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Akto sinduk baniara bâleŋande kautyeŋân miep are watyekto arimbiâ âlepŋe agi. ");
INSERT INTO tim_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hain akmâ Yesugât kârikŋeŋande heŋgemnengumbo howaim âlepŋe akne dâm kili. ");
INSERT INTO tim_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Akto Yesuŋe ikiŋe hamiŋân gâtŋe yekmâ hin dâep, “Ye puligât umburuk akmâ manmai aregât Anutuŋe damunyeŋe akberâm aktâp. Aregât yeŋgât nâŋgâre âlepŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sop hinŋeâk iregât âmâ mop mandâi. Dâ hâmbâi âmâ Anutuŋe wan me wangât egâliaŋ akmai are yeŋgimbo ârândâŋ akbiap. Aregât yeŋgât nâŋgâre âlepŋe aktâp. Sop hinŋe âmâ okotyeŋe nâŋgâm indem mandâi yeŋe âmâ hâmbâi biwiyeŋe heroŋe akbiap aregât yeŋgât nâŋgâre âlepŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Luâk âmbâle bikŋande luâk akmâ geân nâŋgât hâkâŋ akmai aregât ye yekbiâ gembiâ hogom nâŋgâyeŋgim watyekmai ");
INSERT INTO tim_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","aregât yeŋgât hâu âlepŋe hâmbâi Humoŋe himbimân wan katyeŋgiep are tatâp aregât biwiyeŋe heroŋe humo nâŋgâm manbi. Amâ bâgilupyeŋande yeŋe aktâi dop hainâk akmâ Anutugât hoŋ bawa agaŋmâ mali. ");
INSERT INTO tim_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Woe, niŋemaŋe puli siâ siâ tat yeŋgiâp aregât emelâk âlepŋe yeŋaet hâu meyi. Ye hâmbâi âmâ bâleŋân arim âi girâp akbai. ");
INSERT INTO tim_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Woe, uŋak âmâ sot humo nem unsambe manmâ heroŋe aktâi. Dâ hâmbâi âmâ bâleŋân arim mop manmâ âi girâp akbai. Akto uŋak âmâ giriŋmâ heroŋe maroŋe kakŋân mandâi. Dâ hâmbâi âmâ indem umatŋân manbai. ");
INSERT INTO tim_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Woe, ulikŋân luâk bikŋande agatmâ den mem hin hiaŋgim dâyi, “Nen Anutuŋe den dâm maknengiâp are makmâ miawaktenŋe nâŋgâm lokoŋet.” dâmbiâ âmâ bâgilupyeŋande heroŋe akyeŋgiyi. Heroŋe akyeŋgimbiâ Anutuŋe bo huŋgun yeŋgiep, yânâk agatmâ hiaŋgi den dâyi aregât dosayeŋe yeŋgiep. Aregât uŋak iregât âmâ luâk âmbâle kâmot humo arekŋe yeŋgât nâŋgâm heroŋe akyeŋgimbiâ âmâ hanoko akbi. ");
INSERT INTO tim_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Gârâmâ nâ hin maktere nâŋgâŋet. Yeŋe gasalupyeŋe yeŋgât nâŋgâm gala akyeŋgiwi. Akto yeŋgât hâkâŋ akmai are mem gala katyekbi. ");
INSERT INTO tim_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Akto ye bâleŋe akyeŋgimai are heroŋe akyeŋgiwi. Akto makmâ hâkâŋ yekmai yâk yeŋgât akmâ Anutu ulilaŋbi. ");
INSERT INTO tim_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Luâk siâŋe ondopge hogombo are ondopge bikŋe waŋben. Luâk siâŋe gâŋgât ito meŋgiŋberâm kârikŋe akto âmâ iripânge biken are waŋben. ");
INSERT INTO tim_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Luâk siâŋe puli siâ siâgât ulit giŋdo are waŋbiat. Akto luâk siâŋe puli siâ siâ are meŋgiŋdo aregât purik katmâ niŋ bo dâwiat. ");
INSERT INTO tim_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yeŋe wan me wan siâ siâ aknengiŋet dâm aregât ukenŋe akmai dop hainâk akyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Luâk âmbâle bikŋande ye han kalem akyeŋgimai yâk han kalem purikatmâ akyeŋgiwai amâ hâu gain gain miawakyeŋgiwiap? Amâ luâk bâleŋande galalupyeŋe han kalem akyeŋgimai gai. ");
INSERT INTO tim_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Akto bikŋande gala akyeŋgimai yâk gala akyeŋgiwai amâ hâu gain gain miawakyeŋgiwiap? Amâ luâk bâleŋande hain akmai aten. ");
INSERT INTO tim_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Akto hâuŋe purikatmâ nengiŋetdâm wan me wan yeŋgiwai amâ Anutuŋe hâu wan hinan purikatmâ yeŋgiwiap? Amâ Anutugât den bâlâk manmai yâkŋe galalupŋe hin dâm siâ me siâ yeŋgimai, “Maleine yekâ hainâgâk hâuŋe nengiwi.” dâmai. ");
INSERT INTO tim_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bo. Ye hain bo akbi. Ye gasalupyeŋe gala akyeŋgiwi. Hâuŋe bo yeŋgiwai yâk hanâk heŋgemyeŋgum siâ me siâ yeŋgiwi. Hain akmâ maleine hâuŋe umatŋe membai. Hain akmâ Humo yâkgât nan barat akmâ manbai. Yâkŋe âmâ luâk gulip akto metŋe yâk hanâk han kalem akyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Eweyeŋande han kalem manmapgât yeŋe hainâk han kalem olop manbi. ");
INSERT INTO tim_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Akto yeŋe yâk yeŋgât den borâm hâre yeŋgimbiâ âmâ hainâk Anutuŋe dosayeŋe bo kat yeŋgiwiap. Dâ dosayeŋe hepun yeŋgimbiâ âmâ hainâk Anutuŋe dosayeŋe hepun yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Puli me wan me wan akyeŋgimbiâ âmâ Anutuŋe hainâk akyeŋgiwiap. Gârâmâ Anutuŋe lugum totokombo humo akto yeŋgiwiap. Are âmâ yeŋe yeŋgimai dop hainâk Anutuŋe yeŋgiwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesuŋe den hain dâm makyeŋgim den ginŋe hin dâm makyeŋgiep, “Dewunyetŋe bok bokŋe lâuwâ siâŋe yetŋeâk oloŋ akmâ dâp mesokmâ siângen arim hememân hâkoko akbiandat. ");
INSERT INTO tim_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Akto den siâ makbe. Nanaŋ âmâ tiksaŋe bo ewangimap. Nanaŋ are wan me wan nâŋgâm heŋgemgom âmâ tiksa aregât dop akmap. ");
INSERT INTO tim_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Akto den siâ makbe. Gâŋe galagaet dewunŋân lâwin uneŋe tatâp are ekmâ guge dewungân lâwin papaŋe tatâp aregât bo nâŋgaŋgim galagaet dewunŋân tatâp aregâlâk hin dâmenâ ârândâŋ bo akbiap, ");
INSERT INTO tim_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Gala, dewungân gagap tatâp are meŋgiŋbe.” Gâ hiaŋgi luâk. Guge dewungân lâwin papaŋe tatâp are soŋ meakmenâ âlepŋe akto âmâ galagaet dewunŋân lâwin uneŋe tatâp are memenâ ârândâŋ akbiâp. ");
INSERT INTO tim_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Akto den siâ makbe. Lâwin keiŋe keiŋe aregât koaŋe ikiŋeâk ikiŋeâk kinmap. Lâwin koaŋe âlepŋande lâwin bâleŋân bo kinmap. Akto hainâk lâwin koaŋe bâleŋande lâwin âlepŋân bo kinmap. ");
INSERT INTO tim_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Giat bunŋande kewu bo akmap. Akto kânden bunŋande ham bo akmap. Bunŋaet keiŋe ya ekmâ nâŋgâmai are. ");
INSERT INTO tim_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Luâk siâgât biwiŋân wan me wan bâleŋe me âlepŋe pikmâ yendâp aregât lauŋânba âlepŋe me bâleŋe miawakmap. Aregât luâk âlepŋe siâ biwi irakŋe manmapgât bunŋe biwiŋânba agak meme âlepŋeâk miawakmap. Dâ luâk bâleŋe siâ biwi heleŋ manmapgât bunŋe biwiŋânba agak meme bâleŋeâk makmap. ");
INSERT INTO tim_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yeŋe lau yeŋandeâk, “Humonenŋe, Humonenŋe.” dâm nogonmâ âmâ nâŋe den makyeŋgiman are bo lokomai are amâ ârândâŋ bo akmap. ");
INSERT INTO tim_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Siâŋe nâŋgât denne nâŋgâm lokom manmap are âmâ dop hin dâre nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Luâk siâŋe emetŋe ketugum tetembeŋe kâlep anuŋdo gembo totokombo kârikŋe agep. Kârikŋe akto âmâ emetŋe are ketugumbo ârândâŋ akmâ tato âmâ wâriŋ humo mendo tu seru kârikŋe akto emet are kârikŋe akmâ bo kâwulakmâ kilep. Luâk hain arekŋe dop hain aktâp. ");
INSERT INTO tim_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dâ siâŋe denne ire nâŋgâm âmâ hepulep aregât dop âmâ luâk siâ emet ketugum âmâ tetembeŋe yân hanâk yogan yogan kakŋân anuŋdo kilep. Ain âmâ tu seru humo pando âmâ yogan yogan akmâ kâwulakmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuŋe den bunŋe are makyeŋgim metem âmâ Kapanaum kepian ariep. ");
INSERT INTO tim_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Arimbo Roma tembe loko yeŋgât kautŋe siâŋe ikiŋe hoŋ bawa nâŋgâ aŋdo humo agep are momberâm agep. ");
INSERT INTO tim_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hain akto luâk kotdâ arekŋe Yesugât pat nâŋgâm âmâ Yuda damunyeŋe mali are arim Yesu kewugumbiâ togom hoŋ bawa magaŋdo kundat hepulâkgât makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Makmâ huŋgunyeŋgimbo arim hin dâm ulilaŋi, “Roma tembe loko yeŋgât kautŋe siâ hutnenŋân mando luâk âlepŋe dâmaen. ");
INSERT INTO tim_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Akto nengât den emetŋaet puli kato ketugu nengiyi aregât denŋe nâŋgâmenâ ârândâŋ agâk.” dâm magaŋi. ");
INSERT INTO tim_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hain magaŋbiâ nâŋgâm yâk olop ariyi. Arim emetŋe are ewumâk akbiâ galalupŋe den hin dâm makyeŋgim huŋgun yeŋgimbo Yesugâlân arim magaŋi, “O Humo, damun nenŋande hin dâp, “Nâ luâk yânŋe mandân aregât nâŋgâlân bo togowen. Akto nunaet nâŋgâre ârândâŋ bo aktâp. ");
INSERT INTO tim_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Akto nâ gâŋgâlân bo togoman. Aregât gâ yân denâk makmenâ hoŋ bawane ire âlepŋe agâk. ");
INSERT INTO tim_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akto nâ luâk humomo yeŋgât den lokoman. Dâ tembe lokolupnande âmâ nâŋgât den lokomai. Hain akbiâ hutyeŋân gâtŋe siâ magaŋmâ, “Gâ ari” dâre âlepŋe arimap. Akto siâgât, “Gâ ga” dâre âlepŋe gamap. Akto siâgât, “Âi me” dâre âi memap.” hain dâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hain dâmbiâ Yesuŋe tembe loko yeŋgât den are nâŋgâmbo dâtŋe akto aregât purik katmâ hamiŋân dondâ kili are hin dâm makyeŋgiep, “Makyeŋgire nâŋgâŋet. Israe luâk yeŋgât hut yeŋânba luâk siâŋe nâŋgâniŋmap âlepŋe hinare bo mem miawagân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hain dâmbo tembe loko galalupŋande purik katmâ arim emelan âgâm hoŋ bawa âlepŋe agep are egi. ");
INSERT INTO tim_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Akto Yesu Aposololupŋe olowâk kepia siâ kotŋe Naiŋ ain arimbiâ luâk kâmot humoŋe hamiyeŋân kinbiâ olowâk ariyi. ");
INSERT INTO tim_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Akto kepia are tâlâgumbo luâk âmbâle kâmot humo siâŋe âmbâle kambut siâgât nanŋe konok moep are lokom hangowerâm togoyi. ");
INSERT INTO tim_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Togombiâ Humoŋe âmbâi kambut are ekmâ okot nâŋgâm hin dâep, “Bo inde.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hain dâm temân dâgâm lokom togoyi are mendo yân kinbiâ hin dâep, “Luâk sigan agat.” ");
INSERT INTO tim_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","dâm magaŋdo luâk momoŋe are agatmâ den agep. Den akto Yesuŋe magaŋmâ, “Memege olop malet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hain dâmbo luâk âmbâle arekŋe ekmâ ongâyeŋe hogombo bâtyeŋe dâtyeŋân igim kinmâ Anutu magaŋmâ hin dâyi, “Anutu gâŋe hoŋ bawage humo siâ huŋgunaŋen are hutnenŋân mandâp.” dâyi. Dâm âmâ hin dewatim dâyi, “Anutuŋe luâk âmbâle damun nenŋe akberâm huŋgun aŋdo togoep.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Akto Yesuŋe agep aregât pat are sambelem arim Yudaia hân akto hân biken biken arimbo hârokŋe nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohane tu puliyeŋgiep yâkgât galalupŋande Yesuŋe wan me wan miep aregât den pat magaŋi. ");
INSERT INTO tim_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Magaŋbiâ galalogâtŋe lâuwâ siâ yetkondo togombela den hin makyetkim huŋgun yetkiep, “Humogâlân arim den hin dâm magaŋlet, Luâk togowiapgât dâyi are gâ me? Nen niŋande togoâk dâm lâmgom manden?” hain dâm magaŋlet.” ");
INSERT INTO tim_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hain dâm huŋgun yetkimbo Yesugâlân togom hin dâm magaŋiat, “Yohane tuân katyegep arekŋe hin dâm huŋgun netkiâp. Luâk togowiapgât dâyi are gâ me? Me siâgât lâmgom manbaen?” dâyiat. ");
INSERT INTO tim_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Akto sop ain Yesuŋe luâk kundatyeŋe olop are makyeŋgimbo bo akyeŋgiep. Akto sinduk baniara bâleŋande kautyeŋân meyegi are watyegep. Akto dewunyeŋe bok bokŋe makyeŋgimbo dewunyeŋe hâreakto egi. ");
INSERT INTO tim_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aregât Yesuŋe Yohanegât galalogâtŋe hin dâm makyetkiep, “Yet arim âmâ wan me wan yetŋe dewunyetŋande ektat akto ondopyetŋande nâŋgat nâŋgâ yâkgât den pat Yohane hin dâm magaŋlet, “Dewunyeŋe bok bokŋe yâk yeŋgât dâmbo dewunyeŋe hâreakto ektâi. Keiyeŋe goŋgoŋe yâk yeŋgât dâmbo âlepŋe akmâ bam gutâi. Hâk bâle miawak yeŋgimbo manmai yâk yeŋgât dâmbo âlepŋe aktâi. Ondopyeŋe bok bokŋe yâk yeŋgât dâmbo ondopyeŋe pâroŋ âgâmbo den âlepŋe nâŋgâi. Momoŋe yeŋgât makto golâ akmâ mandâi. Akto umburuk mandâi are den pat âlepŋe makyeŋgimbo nâŋgâi.” ");
INSERT INTO tim_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Akto luâk siâ nâŋgât akmâ bo bâleniŋmâ hâkâŋ akniŋbiap amâ yâkgât nâŋgâre âlepŋe humo akbiap.” Hain dâm huŋgun yetkiep. ");
INSERT INTO tim_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Huŋgun yetkimbo purik katmâ arimbela Yesuŋe luâk âmbâle kili are Yohanegât hin makyeŋgiep, “Ye hân kamitŋângen wan ekberâm ariyi? Seruŋe kâro waito duwuŋ akto are ekberâm ariyi me? ");
INSERT INTO tim_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yohane âmâ haingât dopŋe bo. Me luâk siâŋe hâk pekeŋe kulem melem agakŋe luguakmâ kei pekeŋe âlepŋe dondâ kalep are ekberâm ariyi me? Amâ bo. Luâk hain arekŋande luâk humomo yeŋgât emelan tatmâ sot âlepŋe nembiâ tepyeŋe pikto gemai. ");
INSERT INTO tim_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yohane âmâ hainare yeŋgât dopŋe bo. Aregât ye wan ekberâm ariyi? Ye Anutugât den dâm miawagep siâ ekberâm ariyi. Aregât makyeŋgire nâŋgâŋet. Yohane egi are âmâ Anutugât den makmâ miawakmâ gayi yâk hainare bo. ");
INSERT INTO tim_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yâk âmâ siâ. Yâkŋe âmâ hârok ewangiyektâp. Hain gârâmâ Anutuŋe yâkgât den hin dâep are tatâp, “Nune hoŋ bawane magaŋmâ huŋgunaŋdere laune lokom gâŋgât ulikŋân akgiŋmâ dâp heŋgemgo giŋbiap.” Akto den kulemgoep are bunŋe akto Yohane togoep. ");
INSERT INTO tim_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Akto luâk siâŋe Yohane ewangiwiapgât dop bo tatâp. Are âmâ Yohaneŋe ulik gulik akmâ âinaet keiŋe bo ekmâ nâŋgâwiap aregât luâk yânŋe biwiyeŋe Anutugâlân katbiâ arim kinbiap yâk hârokŋe Yohane ewangiwai.” ");
INSERT INTO tim_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hain dâm makyeŋgimbo luâk âmbâle dondâŋe gawamangât puli meme luâk olowâk yâkŋe emelâk Anutugât den lokom manbiâ Yohaneŋe tuân mem katyegep yâkŋe Anutugât den are tângombiâ bunŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dâ Parisaio luâk akto Mosegât den makyeŋgimini yâkŋe âmâ Anutugât dâp are hâkâŋ akmâ Yohaneŋe tuân bo kat nenegâk dâm manmâ gayi. Hain agigât yâkŋe âmâ nâŋgâmbiâ bunŋe bo agep. ");
INSERT INTO tim_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Akto den siâ hin dâm lâuwâŋe makyeŋgiep, “Luâk kâmot ire yâk yeŋgât wanân dop katmâ makbe? Yâk wan hinare? ");
INSERT INTO tim_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nanaŋ kâmot lâuwâ kepia sombeimân tatbai. Akto kâmot siâŋe kâmot siâ are hin dâm makyeŋgiwai, “Nenŋe heroŋe akmâ bâtâ kondenŋe yeŋe kep bo kondâi. Akto nenŋe âi girâp akmâ indien hain indeŋet dâm makyeŋgienŋe bo indeâi.” dâwai. ");
INSERT INTO tim_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Akto aregât maktere nâŋgâŋet. Yohaneŋe tuân katyegep yâkŋe âi keiŋe katmâ tu sot bo nem manmâ âmâ yân âi mem manmâ gambo hin dâyi, “O, luâk ire sinduk baniara bâleŋande meme agaŋdâp.” ");
INSERT INTO tim_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Akto nâ luâk akmâ geân nâŋe sot soŋgo nendere nekmâ hin dâmai, “Luâk ire âmâ sot humo nem mandâp are gawamangât puli meme luâk akto luâk bâleŋe yeŋgât gala.” dâmai. ");
INSERT INTO tim_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Anutugât nâŋgâ nâŋgâ kâmot are âmâ ginbailupŋe yâkŋe yâkgât keiŋe mem golâ katbiâ bunŋe kârikŋe agep.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisaio luâk siâŋe Yesu kewugumbo emetŋân âgâmbo mendugu akmâ sot neyi. ");
INSERT INTO tim_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sot nem tatbiâ ain gâtŋe âmbâle dâp gulip malep siâŋe Yesu Parisaio luâk yâkgât emetŋân âgâm talep are nâŋgâm tu higenŋe are mem âgâep. ");
INSERT INTO tim_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mem âgâm hamiŋân kinmâ indembo dewunŋe tuŋe târâŋ dâm keiŋân giep. Gembo dumutŋe yeukŋe arekŋe keiŋe pulim metiep. Pulim metem âmâ keiŋe mem maŋganmâ tu higenŋe are keiŋân kâim puliep. ");
INSERT INTO tim_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hain akto Parisaio Yesu kewugumbo âgâyiat arekŋe ekmâ biwiŋânâk hin nâŋgâep, “Dâp gulip manmap irekŋe aktâp ire bo agakŋe. Gârâmâ bundâk Yesu Anutugât hoŋ bawa manmap dâine âmbâle iregât keiŋe nâŋgâwop.” dâm nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hain nâŋgâmbo Yesuŋe ekmâ nâŋgâm âmâ hin magaŋep, “Simoŋ, den siâ maktere nâŋgâ.” dâmbo hin magaŋep, “Tiksa, makniŋmenâ nâŋgâwe.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","hin magaŋep, “Luâk siâŋe luâk lâuwâ puli yetkiep siâ 50 kina siâ 5 kina. ");
INSERT INTO tim_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akto siân aregât hâuŋe niŋlet dâmbo puli are panbela bo agep. Bo akto bo mem miawagiat aregât yâkgâlân arim kinmâ hin dâyiat, “Puli bo tat netkiâp.” dâmbela hin makyetkiep, “Hanâk, misiget, âlepŋe ariet.” dâmbo ariyiat. Hain akto âmâ niŋande dosa hepunaŋep aregât nâŋgâmbo huraguep? 50 kina miep arekŋe me 5 kina miep? Aregât makniŋmenâ nâŋgâwe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hain dâmbo hin dâep, “Puli dondâ miep arekŋe ukenŋe nâŋgâep.” dâep. Hain dâmbo Yesuŋe hin dâm magaŋep, “Gâ âlepŋe maktât.” ");
INSERT INTO tim_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hain dâm âmbâle are ekmâ hin dâm Simoŋ magaŋep, “Âmbâle ire ek. Nâ gâŋgât emelan gare tu bo kâim niŋmenâ puliaktân. Akto âmbâle irekŋe âmâ indembo dewunŋe tuŋe keinân gembo dumutŋande puli nektâp. ");
INSERT INTO tim_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gâŋe âmâ bo maŋgan nektât. Dâ âmbâle irekŋe âmâ keine mem maŋgan nekmâ heroŋe akniŋdâp. ");
INSERT INTO tim_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Akto gare gâŋe âmâ tu higen suk suk siâ kautnân bo kâiât aregât âmbâle irekŋe âmâ tu higenŋe olop kâimbo keinân gembo puli nektâp. ");
INSERT INTO tim_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Âmbâle irekŋe âmâ gala konok akniŋdâpgât nâ yâkgât patŋe hin maktere nâŋgâ. Luâk siâŋe galaŋaet dosa umatŋe puliaŋdo aregât heroŋe humo nâŋgâ aŋbiap. Dâ luâk siâŋe galaŋaet dosa bikŋeâk puliaŋdo aregât heroŋe kakŋeâk nâŋgâ aŋbiap. Aregât keiŋe hin dâre nâŋgâ. Anutuŋe âmbâle iregât dosaŋe umatŋe are emelâk hepun aŋdo heroŋe humo nâŋgâ niŋdâp hain.” ");
INSERT INTO tim_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hain dâm âmbâle are hin dâm magaŋep, “Dosage emelâk hepun giŋdân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hain dâmbo olowâk tatmâ sot neyi arekŋe biwi yeŋân hin nâŋgâyi, “Luâk iregât keiŋe gain gain hinare? Gain gain akmâ dosage emelâk hepun giŋdân dâp?” ");
INSERT INTO tim_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Biwiyeŋande hain nâŋgâmbiâ Yesuŋe âmbâle are hin dâm magaŋep, “Biwige Anutugâlân arim kindâp aregât kambiamge sândugembo manbiat.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sop aregât kakŋân Yesuŋe kepia hârogâk ândeaŋmâ arim Anutuŋe damunyeŋe akberâm aktâp aregât den pat âlepŋe makyeŋgim malep. Akto Aposololupŋe keiân lâuwâ are oloŋ yekto olowâk ariyi. ");
INSERT INTO tim_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Akto âmbâle bikŋe olop ariyi are yeŋgât keiyeŋe hin. Bikŋe âmâ sinduk baniara bâleŋande meyekbiâ are watyeŋgimbo âlepŋe agi are. Akto bikŋe âmâ heŋgem yeŋguep yâk olop ariyi. Akto yâk yeŋgâlân gâtŋe siâ kotŋe Maria Madala kepian gâtŋe, yâkgât âmâ sinduk baniara bâleŋe nâmbulân lâuwâ walaŋep. ");
INSERT INTO tim_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Akto siâ kotŋe Yohana are Herotegât hoŋ bawa luâk kotŋe Kusa yâkgât âmbenŋe. Akto siâ kotŋe Susana. Akto âmbâle bikŋe puli oyaŋmâ Yesu akto aposololupŋe yeŋgiyi are olowâk ariyi. ");
INSERT INTO tim_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Luâk âmbâle dondâŋe kepiayeŋe hepunmâ Yesugâlân togom mendugumbiâ yekmâ âmâ den ginŋe hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Luâk siâŋe seŋgo alekŋe are panberâm âiângen mem ariep. Akto alekŋe bikŋe dâwân gembo luâkŋe tâlim hogombiâ lâutŋe togom nem meteyi. ");
INSERT INTO tim_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dâ seŋgo alekŋe bikŋe âmâ hân yam yamân gembo kâmŋe gam âmâ tu bogât ainâk moep. ");
INSERT INTO tim_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Akto alekŋe bikŋe hele kâlegen giep. Gem kâmŋe gambo are âmâ hele humoŋe gam âgâm lokom gunduŋaŋdo moep. ");
INSERT INTO tim_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Akto alekŋe bikŋe âmâ hân keluŋe olowân gembo miawakmâ kâmŋe bususuk dâm gam bunŋe dondâ miawagep.” Hain are makmâ âmâ benŋe kârikŋeâk makmâ hin magep, “Luâk ondopdâŋe den ire nâŋgâwi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Akto hoŋ bawalupŋande den memeŋe aregât keiŋe gain gaingât maktât dâm aikoyi. ");
INSERT INTO tim_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aikombiâ hin dâm makyeŋgiep, “Anutuŋe ye emelâk nâŋgâ nâŋgâyeŋe mem pâroŋ kalep. Kato Anutuŋe damunyeŋe akmapgât keiŋe nâŋgâi. Dâ bikŋe amâ ekmâ âmâ bo ekmâ nâŋgâm heŋgemgomai. Amâ Anutuŋe makto dewunyeŋande âmâ ekmai. Dâ biwiyeŋân bo gemap. Akto ondop yeŋande nâŋgâmai. Dâ nâŋgâ nâŋgâ yeŋân bo gemap. Aregât den dopŋân maktere keiŋe bo nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hain. Akto den ginŋe makyeŋgiân aregât keiŋe hin. Anutugât denŋe seŋgo alekŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Seŋgo alekŋande dâwân giep. Hân dop are âmâ hinare manbai arekŋe Anutugât den nâŋgâmbiâ biwiyeŋân ewuwiap. Ewumbo Niambiŋe ekmâ den are nâŋgâm biwiyeŋe nâŋgâlân katbiâ Anutuŋe damunyeŋe akbopgât hâreyeŋgim ariwiap. ");
INSERT INTO tim_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dâ seŋgo koaŋe kât heregân giep dop hainare manbai yâkŋe den pat âlepŋe nâŋgâm arekŋeak ukenŋe akbai. Dâ hanyeŋân kândârâŋe bo giepgât sop pâŋ konok dondâ mem âmâ dopko dopko miawakto den pat âlepŋe hamiaŋmai. ");
INSERT INTO tim_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Akto seŋgo alekŋe bikŋe hele kâlegen giep dop hinare manbaiŋe amâ Anutugât den nâŋgâwai. Nâŋgâm âmâ hâkgât siâ me siâgât nâŋgâm heŋgemgom puli me sâŋgum lâuwâ lâuwâ me ito sikum aregât ukenŋe nâŋgâm hanokoakmâ âmâ den are hepunbiâ âmâ bunŋe bo akmap. ");
INSERT INTO tim_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dâ koaŋe hân kelurâ ain giep dop hainare manbai yâkŋe den pat âlepŋe nâŋgâm han yeŋe heŋgemgom yeukŋân mem manmai. Hain akmâ kârikŋe akmâ bunŋe peniaŋmai. ");
INSERT INTO tim_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Luâk siâŋe pagaleŋe sagom âmâ umbâ kâlegen me yeye amukŋân kato bo tatmap. Tek tekŋân kato emet kâleŋe pagalembo ekmâ gem âgâmai. ");
INSERT INTO tim_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aregât keiŋe âmâ hin. Wan me wan tip yemap are mem miapanbai. Dâ siâ me siâ ekbiâ bo akto are pagaleŋân miawakto hârokŋe ekbai. ");
INSERT INTO tim_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Siâ siâ me siâ talaŋdo âmâ Anutuŋe siâ waŋdo sambeleaŋbiap. Dâ siâ siâ me siâ bo talaŋmap are bâtnân tatniŋdâp dâm nâŋgâm hilipkombo are Anutuŋe bâtŋânba oloŋmâ pando yân tatbiap. Aregât den makmâ tatân ire nâŋgâm gangerâm manbi.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sop ain luâk kâmot humoŋe Yesu ândeaŋmâ kinbiâ memeŋe emilupŋe togom imbiaŋmâ ekberâm ewum hâumgom kâlewânâk kili. ");
INSERT INTO tim_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kâlewânâk kinbiâ luâk siâŋe hin dâm magaŋep, “Memege emilupgande gekberâm togo iŋgon betgen kinmâ gemenâ gekne dâm gogondâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hain dâmbo Yesuŋe hin dâm magaŋep, “Anutugât den nâŋgâm lokomai ire âmâ nâŋgât memene emilupne are yeŋgât dop aktâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hilâm siân Yesuŋe hin dâm makyeŋgiep, “Bâtgum ire hâtikom biken arine.” dâmbo olop waŋgan âgâm ariyi. ");
INSERT INTO tim_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Arimbiâ Yesu asiŋ yiep. Yem tato seru humo pando âmâ haru are bâliep. Bâlimbo âmâ waŋga are kâi akberâm agep. ");
INSERT INTO tim_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kâi akberâm akto Humo are goaŋmâ hin dâyi, “Wâe, luâk Humo, nen ire haruân bâliweren.” dâmbiâ agatmâ makto seru akto haru nâŋgâm nâŋâgâyiat. ");
INSERT INTO tim_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nâŋâgâmbela hin dâm makyeŋgiep, “Nâŋgâm kepilâniŋmai are yâgâte?” dâmbo yâkŋe âmâ wan me wan akmâ miep are ekmâ otneyeŋe ariep. Arimbo kinmâ hin dâm magaŋgi goaŋgi agi, “Ae, luâk irekŋe âmâ seru akto haru ina den makto nâŋgaŋdat aregât keiŋe gain gain?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Akto bâtgum are hâtikom Galilaia hân bikŋângen Gerasene are yeŋgâlân ariyi. ");
INSERT INTO tim_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ain arim waŋgaŋe haru dâtŋân kindo sopanmâ ge kindo âmâ luâk siâ kepiangenba togom peniaŋep. Aregât keiŋe hin. Sinduk baniara bâleŋe kugâkŋe memeŋe agaŋbiâ malep. Agaŋbiâ hâk pekeŋe bâlâk manmâ aŋun bo aŋgim sop kâlep hainâk malep. Manmâ emetŋân bo manmâ âmâ sumângen hilâm ârândâŋ arim togominep. ");
INSERT INTO tim_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Hain akto tembe lokoŋe bâtŋe bikŋe bikŋe dâgâmbiâ âmâ piriŋ piriŋ kato hâreakto sinduk baniara arekŋe hâwâlaŋdo hân kamitŋângen ariminep. Keiŋe hain. Akto luâk are togom Yesu ekto sinduk baniara bâleŋe are wat yekberâm akto aregât enemŋân ge yiep. Yem âmâ hin magaŋep, “Yesu gâ Anutu Humo dondâ yâkgât nanŋe wangât nâŋgâlân togoât? Nâ hâk hilâlâm bo niŋ.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ekmâ magaŋep, “Kotge niŋe?” dâm aikombo sinduk baniara dondâŋe memeŋe agaŋbiâ malep aregât agonakmâ hin dâep, “Kotne kâmot humo.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hain dâmbo sinduk baniara dondâ arekŋe Yesu hin dâm ulilaŋi, “Âlepŋe huŋgun nengimenâ hememân bo gienŋe nenguwerâp.” dâm ulilaŋi. ");
INSERT INTO tim_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akto hân ain bau dondâ tâmut nem mali aregât sinduk baniara bâleŋe arekŋe magaŋi, “Nâŋgâ nengimenâ luâk ire hepunmâ bau yeŋgât biwiyeŋân gene.” ");
INSERT INTO tim_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","dâmbiâ, “Âlepŋe.” dâmbo arekŋeak luâk are hepunmâ bauyeŋgât biwiyeŋân geyi. Gembiâ bauŋe gem tu deŋgânân gembiâ lauyeŋân pikto moyi. ");
INSERT INTO tim_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Akto bau damunyeŋe arekŋe are ekmâ pârigim arim luâk âmbâle dondâŋe kalam yeŋângen me kepia yeŋângen ari den pat are makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Makyeŋgimbiâ luâk âmbâle hamepŋe olowâk wan me wan agep are ekberâm Yesugâlân togoyi. Togombiâ sinduk baniaraŋe memeŋe agaŋi yâkŋe âmâ nâŋgâ nâŋgâŋe hulaŋ akto hâk pekeŋe lugu akmâ Yesugât keiŋân talep. Are ekmâ hamep akmâ kili. ");
INSERT INTO tim_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kinbiâ âmâ wan me wan are ekmâ nâŋgâyiŋe sinduk baniara watyekto âlepŋe agep yâkgât den pat makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Makyeŋgimbiâ Gerasene hân ambolupŋande hamep akmâ Yesuŋe hân are hepunmâ siângen ariâk dâm aregât magaŋi. Magaŋbiâ ariwerâm waŋgan âgâmbo ");
INSERT INTO tim_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","luâk sinduk baniara walaŋep arekŋe olop arire dâm magaŋep. Magaŋdo Yesuŋe hin magaŋep, “Gâ tat. ");
INSERT INTO tim_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Anutuŋe heŋgem guguâp aregât den pat ewege memege akto ginbailupge makyeŋgiwen.” dâm magaŋep. Hain dâmbo purik katmâ arim Yesuŋe heŋgemgoep aregât den pat hârogâk makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Akto Yesuŋe kepia are hepunmâ bâtgum biken ariep. Arimbo lâmgom tali arekŋe dondâŋe heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Heroŋe agaŋbiâ den emetŋe damunŋe siâ kotŋe Yairo arekŋe keiŋân kâŋgom âmâ togom hin dâm magaŋep, ");
INSERT INTO tim_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","“Baratne konok dondâ hombaŋŋe 12 are momberâm aktâpgât gâ kewugu gekmâ emetnân ariwerâm aktân.” Hain dâm magaŋdo olowâk ariyiat. Arimbela luâk âmbâle dondâŋe watmâ arim ândeaŋ gondeaŋ agi. ");
INSERT INTO tim_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Akto hutyeŋân âmbâle siâ kilep yâkgât keiŋe hin. Âmbâle yeŋgât dewutâ gambo akmai dop hain bo akminep. Hokboâk hokboâk gambo mando hombaŋ 12 bo agep. Hain akmâ manmâ gambo doktaŋe tângowerâm ewum hâumgom hepunmini. ");
INSERT INTO tim_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Akto âmbâle arekŋe Yesugât hamiŋân arim luguak luguakŋe mem walip koaŋep. Walip kom arekŋeak âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Âlepŋe akto ainâk Yesuŋe hin dâm aiyeŋguep, “Niŋande mem walip nuguâp?” dâep. Hain dâmbo hârogâkŋe ândeaŋ gondeaŋ agi arekŋe nen bonâŋgâen dâmbiâ aregât Petoroŋe hin dâep, “Apo, luâk dondâ ândeaŋ gondeaŋ ketugu gektâi.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","hin dâep, “Wâtne gembo aregât maktân. Siâŋe walip nuguâpgât nâŋgân.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","âmbâle arekŋe bundâk howaire nâŋgâp dâm ongâŋe hogombo Yesugât enemŋân bam âmâ walip kom âlepŋe agep aregât keiŋe hârogâk ain kili yeŋgât dewunyeŋân makmâ miawakmâ magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Magaŋdo nâŋgâm hin magaŋep, “Meŋ, biwige nâŋgâlân katât aregât Anutuŋe nâŋgâ giŋdo âlepŋe aktât. Yeukŋân bam ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Hain dâm kindo ainâk Yairogât hoŋ bawa siâŋe emelanba gam hin dâm magaŋep, “Baratge emelâk mondâp aregât luâk Humo ire inâk talâk. Umatŋe siâkâ bo agaŋ. Bo hâwâlaŋ.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuŋe nâŋgâm Yairo hin dâm magaŋep, “Nâŋgâmâk bo ak. Biwige nâŋgâlân katmenâ baratge âlepŋe akberâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hain dâm oloŋmâ arim Yairogât emet ewumâk kinmâ bikŋe yeŋgât dâmbo kili. Kinbiâ Petoro, Yohane, Yakobo akto âmbâi sisik aregât eweŋe memeŋe meyekto emelan olowâk âgâyi. ");
INSERT INTO tim_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Akto luâk âmbâleŋe indem kambiam bâle agi are hin dâm makyeŋgiep, “Baratyetŋe ire bo mondâp. Yân asiŋ yendâp aregât ye bo indeŋet.” dâmbo nâŋgâm giriŋ aŋi. ");
INSERT INTO tim_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Giriŋ aŋmâ hin dâyi, “Wangât hain dât? Are bunŋe mondâp.” ");
INSERT INTO tim_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","dâmbiâ baratyetŋe mem magaŋep, “Barat agatmâ kin.” ");
INSERT INTO tim_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","dâmbo tepŋân tuk tuk dâmbo ainâk agalep. Agato sot om waŋbiâ neâk dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hain akto aregât eweŋe memeŋande ekbela dâtŋe agep. Akto Yesuŋe hin dâm makyetkiep, “Iregât den pat bo makyeŋgiwiandat.” dâm makmâ hâre yetkiep. ");
INSERT INTO tim_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuŋe Aposolo 12 mem oloŋyekto togombiâ sinduk baniara bâleŋande meme akyeŋgimini are watyeŋgiwaigât akto kundatdâ mem âlepŋe ketugu yekbaigât aregât makmâ kârikŋe yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Akto Anutuŋe damunyeŋe akto den pat makyeŋgim kundatdâ mem âlepŋe ketugu yekbai aregât huŋgun yeŋgim hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Ariwerâm âmâ huwan, ito, sot, puli akto hâk pekeŋe dondâ bo mem ariwai. ");
INSERT INTO tim_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kepia siân arimbiâ emelan oloŋ yekmâ âgâmbiâ ainâk tatmâ gem ariwai. ");
INSERT INTO tim_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Akto siân arimbiâ âmâ gala bo akyeŋgimbiâ âmâ kepia are hepunmâ keiyeŋân nukum tatbiap are paŋ paŋgom panmâ den kârikŋe makyeŋgim arimbiâ âmâ yeŋgât keiyeŋe nâŋgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hain dâm makyeŋgim huŋgun yeŋgimbo kepiaŋe kepiaŋe arim manmâ Anutu damunyeŋe akbiap aregât den pat makyeŋgiyi. Akto kundatdâ mem âlepŋe ketugu yegi. ");
INSERT INTO tim_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Akto Yesuŋe ya agep aregât bikŋande hin magaŋgi goaŋgi agi, “Yohaneŋe momoŋânba agatmâ mandâp mon?” dâyi. Dâ bikŋande âmâ hin dâyi, “Eliaŋe lâuwâŋe miawakmâ mandâp mon?” dâyi. Dâ bikŋande âmâ hin dâyi, “Anutugât hoŋ bawa emelâk gâtŋe siâŋe momoŋânba agatmâ mandâp mon?” hain dâyi. Hain dâmbiâ Heroteŋe nâŋgâmbo ârândâŋ bo akto han lâuwâ akmâ hin dâep, “Emelâk maktere Yohane hanŋe hâreyi. Dâ ire âmâ niŋande hainare akmâ mandâp aregât den pat ire nâŋgân?” hain dâm Yesu ekberâm agep. ");
INSERT INTO tim_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Akto aposololupŋande âi ketugum mali. Manmâ purik katmâ aregât den pat Yesu magaŋi. Den pat dâm magaŋbiâ Yesuŋe meyekmâ, “Nenŋeak ari manmâ biwiyeŋe sândugeâk.” dâmbo Besaida kepiangen ariyi. ");
INSERT INTO tim_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Arimbiâ luâk bikŋande yekmâ âmâ hamiyeŋân ariyi. Akto Yesugâlân togombiâ gala akyeŋgimbo mali. Manmâ Anutuŋe damunyeŋe akberâm agep aregât den pat makyeŋgiep. Akto kundat agi are mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hain akmâ kindo emet dâgâ yeŋgiwop dâm aposololupŋe bât biken lâuwâ arekŋe togom hin magaŋi, “Iren hân kamitŋângen manden aregât luâk âmbâle huŋgun yeŋgimenâ kepiayeŋângen arim sot mem neŋet.” dâm magaŋi. ");
INSERT INTO tim_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hain dâmbiâ hin dâm makyeŋgiep, “Yeŋe sot siâ yeŋgiŋet.” dâmbo hin dâm magaŋi, “Nen sot momerâk akto iŋan lâuwâ areâk tat nengiâp. Aregât gain gain akberen? Kepiangen arim luâk kâmot humo ire yeŋgât sot puligonegât maktât me?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Amâ luâk 5,000 maligât. Dâ Yesuŋe hin dâm makyeŋgiep, “Makyeŋgimbiâ kâmot 50 âk hârok ain ain tatmâ ariŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hain dâmbo makyeŋgimbiâ hainâk tatbiâ ");
INSERT INTO tim_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","sot akto iŋan are mem himbimân dewunŋe panmâ Anutugât mepaiŋe mem agatmâ iŋan are munditmâ ligiep. Ligim sot are mem munditmâ hoŋ bawalupŋe ârândâŋ yeŋgimbo luâk âmbâle kâmot tali are oyaŋ yekmâ yeŋgimbiâ neyi. ");
INSERT INTO tim_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nembiâ tepyeŋe pikto bikŋe talep are âmâ hakan lugumbiâ haka 12 pigep. ");
INSERT INTO tim_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Akto hilâm siân Yesu ikiŋeâk manmâ Anutu olop den magaŋgiyiat. Hain akbela Aposoloŋe yâkgâlân arimbiâ aiyeŋgum hin dâep, “Luâk âmbâleŋe nâŋgât niŋe dâmai?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hain dâmbo yâkŋe hin dâm magaŋi, “Bikŋande âmâ Yohane tuân katyegep are hain dâmai. Dâ bikŋande âmâ Elia hain dâmai. Akto bikŋande âmâ Anutugât hoŋ bawa propete siâ emelâk moep arekŋe momoŋânba agatmâ mandâp hain dâmai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hain dâmbiâ hin aiyeŋguep, “Dâ yeŋe âmâ nâŋgât niŋe dâmai?” dâmbo Petoroŋe hin magaŋep, “Gâmâ Anutuŋe huŋgun giŋdo damun nenŋe akberâm gien are bunŋe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hain dâmbo aregât bo makmâ miawakmâ makyeŋgiwi dâm makmâ hâreyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Akto lâuwâŋe hin dâm makyeŋgiep, “Nâ luâk akmâ geângât nâ wan me wan akniŋbiâ nâ hâk hilâlâm nâŋgâwian. Ain âmâ sumbe kat kat luâk akto Mosegât den kârikŋe makmâ miawakmai akto kepia ambolupŋe yeŋgât damunlupyeŋande gasa akniŋmâ nugumbiâ mondere hilâm âlâwu bo akto momoŋânba agatmâ manbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuŋe luâk âmbâle hin dâm makyeŋgiep, “Luâk bikŋande biwiyeŋe nâŋgâlân katmâ nâ olop ariwerâm âmâ wan me wan akmâ hilipkowai aregât bo hamep akmâ manbai. Akto yeŋe hâkyeŋaet bo nâŋgâm hilâmŋe hilâmŋe nâŋgât den lokom manbai. ");
INSERT INTO tim_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dâ siâŋe ikiŋe manmanŋe gangerâwiap are âmâ hilip aguwiap. Akto siâŋe nâŋgât den âi aregâlâk nâŋgâm mando kombiâ âmâ momoŋânba agatbiap. ");
INSERT INTO tim_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dâ siâŋe manmâ siâ siâ mem lokom aregât ukenŋe âlepŋe akbiapŋe mombiap sop ain wan me wangât ya ukenŋe akbiap arekŋe bo tângombo momo kârikŋânba bo agatbiap. ");
INSERT INTO tim_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Akto siâŋe nâŋgât hâkâŋ akmâ nâŋgât den bo lokom manbiap aregât keiŋe hin. Nâ luâk akmâ geân akto ewene netgât pagaleŋe netŋande panmâ ŋirik ŋirik dâmbo âmâ himbimân aŋelolupnetŋande nâ olop gienŋe luâk ya akmai are nâkâ hainâk hami yeŋgiwian. ");
INSERT INTO tim_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Maktere nâŋgâŋet. Yu kindâi ire bikŋe bo mom golâ manbaiân Anutuŋe damunyeŋe akbiapgât are ekbai.” Hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuŋe den hain dâm makyeŋgimbo hilâm 8 mon bo akto Anutu olop den akberâm Petoro, Yohane, Yakobo, meyekto gimbâŋe siân âgâyi. ");
INSERT INTO tim_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Âgâmbiâ Anutu olop den akbela Petoro akto galalogâtŋe yâk asiŋgât akmâ tali. Hain akbiâ Yesugât enem dewunŋe siâ akto hâk pekeŋe lugu agep are kau timan timan agep. ");
INSERT INTO tim_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hain akto himbim pagaleŋe belek belek dâm yendo luâk lâuwâ Mose akto Elia ainâk miawagiat. ");
INSERT INTO tim_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yâk miawakmâ Yesu Yerusalem kepian arim Anutuŋe yâkgât makmâ hâreaŋep are watmâ mombiap aregât yâk olop den magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Den aregât magaŋgim kâlâkom agatbiâ Petoro akto galalogâtŋe asiŋgât dondâ akyetkimbo dewunyeŋe panmâ Yesu pagaleŋe kulemŋe akto luâk lâuwâ yâk olop kinbela yelegi. ");
INSERT INTO tim_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Akto Mose akto Elia ariwerâm akbela Petoroŋe tirip aregât keiŋe bo nâŋgâm Yesu hin dâm magaŋep, “Luâk Humo, âlepŋe dondâ nen in manden aregât gâ nâŋgâmenâ uligi gâŋgât siâ Mosegât siâ Eliagât siâ hain ketugune.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hain dâmbo ainâk hamandat akmâ dâgâm bup panmâ tigi yekto Petoro, Yohane akto Yakobo yâkŋe ongâyeŋe hogombo kili. ");
INSERT INTO tim_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hain akbiâ hamandat kâlegenba Anutuŋe hin dâm makyeŋgiep, “Are ekŋet. Luâk ire nâŋgât nanne okotne nâŋgâ aŋdere nâŋgât lau lokom manmap yâkgât denŋe nâŋgâm lokom manbai.” ");
INSERT INTO tim_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Anutuŋe den hain dâm kondo Yesuŋe ikiŋeâk kindo egi. Akto wan me wan egi are sop ain luâk siânba bo makyeŋgim yân biwiyeŋânâk katmâ nâŋgâm mali. ");
INSERT INTO tim_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Emet hauŋdo gimbâŋânba gembiâ luâk kâmot humoŋe togom Yesu peniaŋi. ");
INSERT INTO tim_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Togom peniaŋi yâk yeŋgât hutyeŋânba siâŋe Yesu hin dâm magaŋep, “Luâk Humo, iregât yu ulitgiŋbe. Nanne konok ire gam ek. ");
INSERT INTO tim_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Keiŋe hin. Sinduk baniara bâleŋe siâŋe hilâm ârândâŋ kautŋân mendo dewunŋe gâwâŋ gâwâŋ dâmbo ge yendo lauŋân barak pâtkombo den kârikŋe makmap. Akto sinduk baniara bâleŋe arekŋe hilâm ârândâŋ hainâk hilipkom hâk hilâlâm waŋmap. ");
INSERT INTO tim_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Haingât aposololupgande watŋet dâm ulit yeŋgire ewum hâumgom hepuli.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hain dâmbo Yesuŋe hin dâm magaŋep, “Yei, luâk kâmot bo nâŋgâniŋmai ye hanyeŋe kârikŋe. Nâ ye olop sopŋe sopŋe manmâ sokom katyekbian mon? Nange are mem ga.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hain dâmbo Yesugâlân mem âgâmbo sinduk baniaraŋe bâleŋe agaŋdo dewunŋe gâwâŋ gâwâŋ dâmbo ge yiep. Hain akto Yesuŋe sinduk baniara bâleŋe are watmâ pando arimbo âlepŋe akmâ eweŋaelân ariep. ");
INSERT INTO tim_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Arimbo luâk âmbâleŋe Anutuŋe memeŋe agaŋdo kulem miep are ekmâ nâŋgâm bâtyeŋe dâtyeŋân igim kinmâ han lâuwâ agi. ");
INSERT INTO tim_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Hain akmâ dât yeŋân igim kinbiâ Yesuŋe hoŋ bawalupŋe oloŋ yekmâ makyeŋgim hin dâep, “Den ire makyeŋgire nâŋgâm mem biwiyeŋân katmâ manbi. Nâ luâk akmâ geân nâ hilip nuguwerâm luâkŋe menekbai aregât sop tâlâguâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hain dâm makyeŋgimbo nâŋgâmbiâ den keiŋe yeŋaelân Anutuŋe bo kalep aregât akmâ aikowerâm agi are nâŋgâm hamep akmâ hepuli. ");
INSERT INTO tim_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Akto hoŋ bawalupŋe, “Nengâlân gâtŋe niŋande humonenŋe akmâ manbiap?” dâm magaŋgi goaŋgi akmâ papalagi. ");
INSERT INTO tim_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hain akbiâ Yesuŋe biwiyeŋaet keiŋe ekmâ nâŋgâm âmâ nanaŋ bâlensiâ siâ mem hutyeŋân kato kindo hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Siâŋe nanaŋ bâlensiâ ire hinare tângomap are âmâ nâ tân nugumap aregât dop akmap. Akto siâŋe nâ tân nuguâp aregât dop akmap arekŋe Anutuŋe huŋgun niŋep nâ tân nugumap. Akto yeŋgâlân gâtŋe siâŋe, “Nâ luâk yânŋe mandân.” dâm biwiŋande ikiŋaet nâŋgâmbo gemapŋe emelâk ewangi yektâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hain dâmbo Yohaneŋe Yesu hin dâm magaŋep, “Luâk humo aŋgâ yeŋgâlân gâtŋe siâŋe gâ gogonmâ sinduk baniara bâleŋe watyekto are ekmâ, “Gâ nengâlân gâtŋe bo. Hain bo ak.” dâm koaŋion.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hain dâmbo Yesuŋe hin dâm magaŋep, “Luâk siâŋe gasa bo akyeŋgimapŋe amâ ye tân yeŋgum gala akyeŋgiwiap. Gârâmâ siâŋe hain akto âmâ bo koaŋbi.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuŋe himbimân purik katmâ âgâwiap aregât sop tâlâgumbo Yerusalem kepian ariwerâm aregât biwiŋe humo kalep. ");
INSERT INTO tim_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hain akmâ hoŋ bawalupŋe huŋgun yeŋgimbo den mem ariyi. Arim Samaria yeŋgât kepia siân arim Yesu ain ariwiap aregât, “Emet siâ yogan nengimbiâ heŋgemgone.” dâm aregât kepia ambolupŋe makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Makyeŋgimbiâ Yesu Yerusalem kepian ariwiap aregât kautŋe oriepgât nâŋgâm bo dâyi. ");
INSERT INTO tim_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hain dâm emet gangerâmbiâ Aposolo lâuwâ Yohane akto Yakobo yâkŋe nâŋgâmbela ârândâŋ bo akto peiyekmâ Yesu aikom hin dâyiat, “Humo gâ nâŋgâmenâ netŋe dâetŋe himbimânba kâlâp siâ gem oyegâk.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hain dâmbela purik dâm yelekmâ, “Hepulet.” dâm den are koyetkiep. ");
INSERT INTO tim_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Koyetkimbo kepia siângen ariyi. ");
INSERT INTO tim_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Arimbiâ luâk siâŋe mem miawakyekmâ Yesu hin dâm magaŋep, “Gâ iregen me aregen ariwerâm akmenâ nâ watgekmâ manbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hain dâmbo Yesuŋe hin dâm magaŋep, “Soŋgo âmâ emetyeŋe âlepŋân yemai akto lâut âmâ kelomyeŋe âlepŋân tatmai. Dâ nâmâ luâk akmâ geân nâmâ emetne bo tatniŋdâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Akto sop siân Yesuŋe luâk siâ mem miawakmâ hin dâm magaŋep, “Gâ nâ wat nekmenâ olop mande.” dâmbo hin dâep, “Humo, nâŋgâmenâ nâŋe soŋ arim apone hangom âkâ purik katmâ togore gâ olop ariwaet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hain dâmbo hin dâep, “Momoŋe manmai arekŋe momolupyeŋe hangoyekŋet. Dâ gâmâ arim Anutuŋe luâk âmbâle damunyeŋe akbiap aregât den pat makyeŋgiwen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hain dâmbo luâk siâŋe Yesu hin dâm magaŋep, “Humo gâ olop ariwaetgât nâŋgân. Gârâmâ nâŋgâmenâ nâ purik katmâ arim ginbailupne yekmâ indem katyekmâ purikatmâ togore âmâ gâ olop ariwaet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hain dâmbo Yesuŋe hin dâep, “Maktât aregât hin maktere nâŋgâ. Luâk siâŋe âiân ariwerâm âmâ pâŋân hepunbiapŋe amâ Anutugât kepian ariwiap gât dop bo talaŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Manmâ Yesuŋe luâk 70 siâ mem oloŋ yekmâ âi den dâm yeŋgiep. Akto ikiŋak kepiaŋe kepiaŋe ariwerâm nâŋgâep ain âmâ luâk lâuwâk lâuwâk mem katyekmâ, “Yeŋe soŋ ariŋet.” dâm huŋgun yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Huŋgun yeŋgiwerâm kinmâ den hin dâm makyeŋgiep, “Kalamân sot bunŋe dondâ miawaktâp aregât âi amâ humo. Dâ âi luâk amâ amon siâ. Aregât sotgât Amboŋe magaŋbiâ Amboŋande ikiŋe kalamângen luâk siâkâ lâuwâŋe katyegâk. ");
INSERT INTO tim_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Akto siâ makbe. Lama pâlâmŋe are dua metŋe hut yeŋân arimbiâ hilip yeŋgumai dop hainare akmâ luâk metŋe tânâmyeŋân huŋgun yeŋgire arim manbai. ");
INSERT INTO tim_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Huŋgun yeŋgire ariwerâm âmâ delem me puli me kei pekeŋe himbân lâuwâ bo meakmâ ariwai. Akto kepiangen ariwerâm dâwângen luâk olop den kâlep bo akbai. ");
INSERT INTO tim_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yânâk tâŋ tâŋâk kepian ariwai. Akto emet siân âgâwerâm âmâ emet aregât ambolupŋe heroŋe akyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Heroŋe akyeŋgimbiâ emet ambolupŋe bikŋande heroŋe akmâ, “Gambiâ biwi konok akne.” dâmbiâ âmâ gala akyeŋgiwai. Dâ emet ambolupŋande gala bo akyeŋgimbiâ âmâ hepun yekmâ ariwi. ");
INSERT INTO tim_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Âi luâk âi meyeŋgimai are âlepŋe puli yeŋgimbiâ ârândâŋ akmap. Aregât nâŋgât âi ketuguwai aregât ");
INSERT INTO tim_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","kepia siâ me siân âgâmbiâ sot om yeŋgimbiâ âmâ nem ain tatbi. Tatmâ emet ain ba bam emet aŋgân hanâk hanâk bo âgâwi. ");
INSERT INTO tim_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gala hain akyeŋgimbiâ ainâk tatmâ kundat akbai are heŋgem yeŋguwai. Heŋgem yeŋgum âmâ hin dâm makyeŋgiwi, “Anutuŋe damunyeŋe akberâm aktâp aregât ire akyeŋgien.” ");
INSERT INTO tim_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hain dâm makyeŋgim arewa kepia siân arimbiâ hâkâŋyeŋe akbai âmâ sombeimân kinmâ hin dâm makyeŋgiwi, ");
INSERT INTO tim_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kepia in gâtŋe gagap pipiŋe siâ bo membaen aregât keinenŋân nukum me gagap tatâp ire paŋ paŋgom pandenŋe amâ hin ekmâ nâŋgâŋet. Anutuŋe damunyeŋe akberâm aktâp aregât miawakbiapgât sop tâlâguâk.” Hain dâm makyeŋgim hepun yekmâ ariwi. ");
INSERT INTO tim_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Akto aregât keiŋe maktere nâŋgâŋet. Sop humoân Sodom kepia ambolupŋe agak meme bâleŋe agi aregât hâu membai. Dâ kepia ambolupŋande yeŋgât hâkâŋ akbai aregât hâu bâleŋe humo membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesuŋe hain dâm kepia bikŋe yeŋgâlân katmâ hin magep, “Woe, Korasiŋ kepia ambolupŋe, woe, Besaida kepia ambolupŋe, nâŋe yeŋgâlân kulem hamepŋe olowâk ketugum manmâ gan hain are Tiro Sidoŋ kepian ketuguân dâine yâkŋe emelâk agak memeyeŋe bâleŋe are hepunmâ kâŋgom kinmâ yeŋaet okot bâle nâŋgâ aŋgim manmâ Anutugât den nâŋgâwâi. ");
INSERT INTO tim_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ye hain akbai aregât siân sop humoân Tiro Sidoŋ kepia ambolupŋande dosa membai. Hain membiâ yeâmâ dosa umatŋe bâleŋe membai. ");
INSERT INTO tim_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Akto Kapanaum ambolupŋe ye hilâm ârândâŋ kotyeŋe mem agatmâ hin dâmai, “Nen emelâk himbimgât pat akmâ manden.” Hain dâm mandâi. Aregât ye âmâ hememân gewai. ");
INSERT INTO tim_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yeŋe den ire luâk âmbâle bikŋe makmâ miawakyeŋgimbiâ âmâ Anutugât den tâŋâk nâŋgâwai. Akto den ire makyeŋgim miawakyeŋgimbiâ hâkâŋ akmâ bo lokowai are âmâ ye bo hâkâŋyeŋgiwai. Are âmâ nâ hâkâŋniŋmâ akbai. Akto huŋgun niŋep yâk gai hâkâŋ agaŋbai.” dâep. Hain dâm huŋgun yeŋgimbo ariyi. ");
INSERT INTO tim_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Luâk 70 arekŋe manmâ purik katmâ togom biwiyeŋe heroŋe humo akto aregât Yesu magaŋmâ hin dâyi, “Humo gâ gogonmâ kepia ain ain sinduk baniara watyeŋgienŋe dennenŋe lokoyi.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","yâkŋe hin dâep, “Ye arim sinduk baniara bâleŋe watyekbiâ âmâ Niambiŋe âmâ mem belek katmap dop hainâk akmâ himbimân ba ge kondo egân. ");
INSERT INTO tim_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nâŋgâi. Niambi sâmbâ metŋe me dek kakŋân tâlimbiâ hilip yeŋguwop akto sinduk bâleŋande mem siâ me siâ yeŋgiwop dâm aregât kârikŋe yeŋgiân. Gârâmâ wâtnân kinbiâ memeŋe akyeŋgire manbai. ");
INSERT INTO tim_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gârâmâ sinduk baniara bâleŋande denyeŋe lokombiâ aregât heroŋe bo akŋet. Himbimân manbaigât Anutuŋe kotyeŋe kulemgoep aregât nâŋgâm heroŋe akŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Akto sop ain Anutugât Heakŋande memeŋe agaŋdo Yesuŋe biwiŋe heroŋe humo nâŋgâm Anutu hin dâm magaŋep, “Apone, himbim haru hân amboŋe gâŋe luâk bikŋe nâŋgâ nâŋgâyeŋaet nâŋgâmbiâ humo akmap are âmâ gâŋgât denge are mem heambukyeŋgimat. Dâ nanaŋ âmâ makmâ miawakyeŋgimat. Aregât nâ mepaige mendân. Gâ hain miawagâkgât makmâ kârigien. ");
INSERT INTO tim_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ewene yâkŋe nâ meme akniŋdo aregât kotŋe siâ siâ akman. Akto Ewenaet keiŋe nâŋgângât luâk âmbâle potatyekmâ biken biken makyeŋgire arekŋe âmâ hainâk keine nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Hain dâm hoŋ bawalupŋe yoŋâk hin dâm makyeŋgiep, “Den bunŋe makyeŋgiwe. Ulikŋân Anutugât propete akto luâk kotdâ dondâŋe wan me wan uŋak yeŋe ekmâ mandâi hainâk ekberâm ukenŋe humo nâŋgâm mali. Dâ amâ bo egi. Akto den pat âlepŋe makyeŋgire nâŋgâi ire gai nâŋgâwerâm ukenŋe humo nâŋgâm mali. Dâ amâ bo nâŋgâyi. Aregât ye âmâ wan me wan ekmai aregât nâŋgâm heroŋe humo akmai. Akto den pat âlepŋe makyeŋgire nâŋgâmai aregât heroŋe humo nâŋgâm manmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Akto Mosegât den makmâ kepigi siâŋe Yesu dop komberâm den hin dâm aikoep, “Luâk humo, gain gain akmâ âmâ manman kârikŋaet pat aktere ârândâŋ akbiap?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hain dâmbo hin dâep, “Moseŋe den gain gain kulemgoep? Akto wan oyaŋmat?” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","hin magep, “Den kulemgoep are hin tatâp, “Anutugâlâk nâŋgâm denŋe lokom biwige yâkgâlân katmâ yâkgât wâtŋân kinmâ manben.” Akto siâ hin tatâp, “Gâ gugaet akmat hainâk galagaet agaŋben.” hain tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dâmbo hin dâm magaŋep, “Âlepŋe den are lokom kinmâ manman kârikŋaet pat akbiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hain dâmbo luâk arekŋe ikiŋe agak memeŋe are mem agatberâm akmâ kârikŋaet kulâgâtmâ hin dâm magaŋep, “Gâ niŋaet nâŋgâmenâ gala aktâp?” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesuŋe den ginŋe siâ hin dâm magaŋep, “Yuda luâk siâŋe Yerusalem kepia hepunmâ Yeriko kepiangen arimbo gasalupŋande teŋgâ kinmâ kombiâ gilâmŋe gem yiep. Ge yendo hâk pekeŋe me puli me wan me wan meaŋmâ ariyi. Arimbiâ âmâ momberâm akmâ yiep. ");
INSERT INTO tim_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hain akmâ yendo Yuda gâtŋe sumbe kat kat luâk siâŋe dâp hainâk togom yendo egep. Dâ egep amâ hâkâŋ akmâ yân hanâk ewangiep. ");
INSERT INTO tim_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Akto sumbe emetŋe aregât hoŋ bawa siâ Lewigât kâmolân gâtŋe siâŋe âkâ hainâk togom yendo ekmâ enemŋânâk bam tâŋâk egep arekŋe benŋe biwiŋe pâlâmŋe akto yânâk ewangim ariep. ");
INSERT INTO tim_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hain akto benŋe gasaŋe siâ Samaria hânân gâtŋe arekŋe togom âmâ egep. ");
INSERT INTO tim_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ekmâ okotŋe nâŋgâm enemŋânâk bam ekmâ âmâ gilâmŋe puliaŋmâ keluŋe mem pulim diwiŋe are katip koaŋep. Hain akmâ doŋgiŋe kakŋân mem kato âgâmbo mem kepia siân arim luâk lombo togo yemai are yeŋgât emet yeŋân kato tato gala agaŋmâ damunŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hain akto emet hauŋdo ariwerâm âmâ emet aregât amboŋe puli waŋmâ hin magaŋep, “Damunŋe akmâ manmenâ puli giŋdân ire bo akto âmâ siân lâuwâŋe giŋbian.” dâm ariep. ");
INSERT INTO tim_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hain agep aregât aigugure makniŋ. Gâŋe nâŋgâmenâ luâk âlâwu are yeŋgâlân gâtŋe niŋaet âmâ nâŋgâmenâ âlepŋe aktâp?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hain aikombo hin dâep, “Han kalem agaŋep luâk arekŋe keiŋe nâŋgâm damunŋe agep are.” dâep. Aregât Yesuŋe hin magaŋep, “Gâŋe dop hainâk akyeŋgiwen.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Akto Yesu Aposololupŋe kepia siângen arimbiâ âmbâle siâ kotŋe Mata yâkŋe Yesu kewugumbo emetŋân âgâyiat. ");
INSERT INTO tim_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Âgâmbela gariŋe kotŋe Maria, yâkŋe âmâ Humogât enemŋân bam tato magaŋdo nâŋgâm talep. ");
INSERT INTO tim_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Den nâŋgâm tato Mataŋe ikiŋak sot om âi miep aregât, “Garinande siâ bo tân nuguâp.” dâm nâŋgâm bâliaŋmâ hin dâep, “Humo, garinande yân tato nunagâk sot om tatân aregât nâŋgâre bâliâp. Magaŋmenâ tân nuguâk.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesuŋe hin dâm magaŋep, “Mata, gâ wan me wan yânŋe aregât hanoko akmâ hâk hilâlâm kakŋân kindât. ");
INSERT INTO tim_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Garige âmâ nâŋgât den nâŋgâwerâm akto ârândâŋ aktâp aregât siâŋe bo gulipkowiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesuŋe siângen arimbo Anutu olop den agiat. Akmâ metembela âmâ hoŋ bawa siâŋe hin dâep, “Humo, Yohaneŋe galalupŋe Anutu olop den agi aregât keiŋe makyeŋgiep aregât hainâk maknengimenâ nâŋgâne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hain dâmbiâ hin dâm makyeŋgiep, “Anutu magaŋberâm âmâ hin dâm magaŋbi. Ewenenŋe kotge agat agatŋe are hainâk âlepŋe tatmâ âgâwiâp. Damun nenŋe akmenâ wâtgân kinmâ mandenŋe hânân humo aknengiwen. ");
INSERT INTO tim_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Akto hilâmŋe hilâmŋe sot dop nenŋânâk ârândâŋ nengiwen. ");
INSERT INTO tim_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Akto luâk siânbaŋe bâleŋe aknengim aregât dosa memai are hepun yeŋgim malion dop hainâk dosanenŋe kutigit nengiwen. Akto gâŋe bo dop nenguwen.” ");
INSERT INTO tim_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesuŋe hain dâm den ginŋe siâ hin dâm makyeŋgiep, “Yeŋgâlân gâtŋe siâŋe hândâk tânâmŋân arim galaŋe siâ hin dâm magaŋbiap, ");
INSERT INTO tim_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“O galane, makgiŋdere nâŋgâ. Galane siâ dâp manmâ nâŋgâlân togombo sot bo akto wan waŋberâm aregât sot siâ niŋmenâ waŋdere neâk dâm aregât gâŋgâlân togoân.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","galaŋe arekŋe emelanâk tatmâ hin dâwiap, “Galane, gain akmâ hândâk timoŋân togom nogondât? Emelâk emet hâŋgiŋe gugure nan baratlupne asiŋ yendâi aregât agatmâ giŋberângât dop âlepŋe bo.” ");
INSERT INTO tim_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aregât hin makyeŋgire nâŋgâŋet. Galaŋande hain dâm emelanâk tatmâ gala bo agaŋbiap. Dâ kârikŋe akmâ hâwâtmâ ulilaŋdo aregât hanâk waŋbiap. ");
INSERT INTO tim_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aregât maktere nâŋgâŋet. Yeŋe hain are aregât undâgâtmâ manmaen dâm Anutu magaŋbiâ tân yeŋgumap. Akto kulâgâtmâ manmaiŋe mem miawakbai. Akto emet hâŋgiân “Woa” dâmbiâ wan me wan magaŋmai dop hainâk Anutuŋe wan me wangât makbiâ hainâk yeŋgimap. ");
INSERT INTO tim_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aregât Anutu aikomapŋe den hâuŋe nâŋgâmap. Akto undâgâtmapŋe mem miawakmap. Emet hâŋgiân konmai yâkŋe wan me wan ulilaŋbiâ hainâk miawak yeŋgimap. ");
INSERT INTO tim_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Akto yeŋgâlân gâtŋe siâgât nanŋande sotgât ulilaŋdo kât waŋbiap mon? Akto yeŋgâlân gâtŋe siâgât nanŋande iŋangât ulilaŋdo niambi sâmbâ bo waŋbiap. ");
INSERT INTO tim_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Akto pui koaŋaet ulilaŋdo kendemuŋ are bo waŋbiap. ");
INSERT INTO tim_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Akto ye luâk bâleŋande nan baratlupyeŋe damunyeŋe akmâ wan me wan âlepŋeâk akyeŋgimai hainâgâk Eweyeŋe Anutu himbimân mandâp arekŋe dopŋe are ewangim luâk siâŋe aikombo yâkgât nâŋgâm ikiŋe Heakŋe dowâk huŋgun aŋdo gewiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Akto sop siân sinduk baniara bâleŋande luâk siâ oloŋmâ hanŋe dâpŋe tigimbo den bo makmâ malep. Den bo makmâ mando Yesuŋe sinduk baniara are wato arimbo hanŋe pâroŋ âgâmbo den agep. Den makto luâk âmbâleŋe ekmâ bâtyeŋe dâtyeŋân igim kili. ");
INSERT INTO tim_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Akto Parisaio luâk bikŋande hin dâyi, “Niambi kotŋe Besebulu sinduk baniara bâleŋe are yeŋgât humoyeŋe arekŋe meme agaŋdo sinduk baniara watâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dâ luâk bikŋande âmâ hiaŋmâ hin dâm ulilaŋi, “Makmenâ kulem siâ himbimânba miawakto ekmâ keige nâŋgâwaengât dopŋe agâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hain dâmbiâ yekmâ nâŋgâm den ginŋe hin dâm makyeŋgiep, “Hân siâgât ambolupŋande potalakmâ agumbiâ âmâ kotyeŋe humo bo akbiap. Bo kârikŋe. Are hilip aguwai. Akto hainâk luâk âmbâleŋe hain akmâ nanaŋ lepatlupyeŋe hilip yeŋgumbiâ dâine kâmot are gulip akbop. ");
INSERT INTO tim_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dop hainâk Niambigât kâmotŋe potalakmâ galalupyeŋe watyekmai dâine Niambi âi kârikŋe bo ketuguwop. Aregât yeŋe âmâ nâŋgât hin dâi, “Besebuluŋe memeŋe agaŋdo sinduk baniara are watâp.” dâmbiâ ârândâŋ bo aktâp. ");
INSERT INTO tim_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hain dâmbiâ aregât yeŋgât hoŋ bawalupyeŋande sinduk baniara bâleŋe watyektâiân niŋaet wâtŋân kinmâ watyektâi? Yâkŋe âmâ keiyeŋe makmâ miawakbiâ âmâ yeŋgât den are nâŋgâm heŋgemgowi. ");
INSERT INTO tim_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nâŋe âmâ Anutugât wâtŋân kinmâ sinduk baniara bâleŋe are watyektângât Anutuŋe damunyeŋe akmap aregât keiŋe uŋak yu ektâi. ");
INSERT INTO tim_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Aregât den ginŋe siâ maktere nâŋgâŋet. Luâk kârikŋe siâŋe mâron goliakmâ tembe bisârâŋ me nandup me kândâm meakmâ ikiŋe kârikŋeŋaet nâŋgâmbo humo agep are mem âgâm emet kepiaŋe damungom heŋgemgowiap âmâ yâkgât ito me wan me wan âlepŋe talaŋbiap. ");
INSERT INTO tim_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hain akto gasa kârikŋe dondâŋe togom bugâ mâron aregâlâk nâŋgâwiap are kom watmâ gulip kom aregât tembe bugâ kemuŋ puli me wan me wan dua baulupŋe are meaŋmâ arim galalupŋe oyaŋmâ yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Aregât luâk siâŋe gala bo akniŋmapŋe âmâ gasa akniŋmap. Akto siâŋe âine ekmâ bo tân nugumapŋe nugum pan nekbiapgât dop aktâp. ");
INSERT INTO tim_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sinduk baniara siâ walaŋdo âmâ hân pumângen are luâk niŋaet undâgâtmâ manbiap. Undâgâtmâ mando bo akto hin dâwiap, “Emelâk nâŋgât luâk are agaŋmâ hepulân aregâlân purik katmâ arim manbian.” ");
INSERT INTO tim_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hain dâm purik katmâ arim emetnenŋe pulim mem âlepŋe ketugumaen dop hainâk luâk arekŋe ekmâ hin dâwiap, ");
INSERT INTO tim_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","“Sinduk baniara galalupne dondâ bâleŋe are meyekmâ togom luâk are mem manmâ nâŋgâwian.” dâm arim galalupŋe nâmbulân lâuwâ bâleŋe dondâ akmai are mem miawakyekto togom membiâ emelâk bâleŋe agaŋep are ewangim umatŋe agaŋbai.” ");
INSERT INTO tim_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuŋe hain dâm makyeŋgimbo kinbiâ hutyeŋânba âmbâle siâŋe hin dâm magaŋep, “Memegande meŋgekmâ nam giŋep yâkgât nâŋgâre âlepŋe aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hain dâmbo Yesuŋe nâŋgâm hin dâep, “Âlepŋe maktât gârâmâ nâŋe Anutugât den nâŋgâm lokom manmai are yeŋgât nâŋgâre âlepŋe humo aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Luâk dondâŋe Yesugâlân togom mem ândeaŋ gondeaŋ ketugum kinbiâ hin dâm makyeŋgiep, “Kâmotyeŋe bâleŋe, yeŋe kulem siâ miawakto ekberâm makniŋmâ manmâ gai are ektere bâliâp. Hain aktâi aregât hinŋeâk âmâ kulem siâ bo mem miawaktere ekbai. Aregât ulikŋân âmâ Anutuŋe luâk kotŋe Yona aregâlân kulemgoep are uŋak kulem dop hainâk mendere ekmâ nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ulikŋân âmâ Yonaŋe kulem siâ agep are Niniwe kepia ambolupŋande egi kulem hain are hâmbâi luâk akmâ gewiap dâmai are nâ yu ge mandân hâmbâi siâ bo nekbai. ");
INSERT INTO tim_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Akto âmbâle kotdâ siâŋe ulikŋân Salomo yâkgât nâŋgâ nâŋgâŋe ekberâm kepia kâlewângenba togoep. Nâŋgât nâŋgâ nâŋgâne irekŋe Salomogât nâŋgâ nâŋgâŋe are ewangiâp ina yeŋe nâŋgât den bo lokomai aregât sop humoân keiyeŋe makmâ miawakbiâ ekbianân âmbâle kotdâ arekŋe hutyeŋân agatmâ kinmâ biwiyeŋaet den dopyeŋân dâm keiyeŋe makmâ miawakto dosa membai. ");
INSERT INTO tim_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Akto Yonaŋe Niniwe kepian arim kepia ambolupŋe den kârikŋe makyeŋgimbo hamep akmâ agak memeyeŋe bâleŋe makmâ miawakmâ mali. Aregât hin maktere nâŋgâŋet. Nâŋe âmâ Yona ewangiân ina yeŋe nâŋgât den bo nâŋgâm lokomai. Aregât sop humoân Niniwe kepia ambolupŋande agatmâ kinmâ yeŋe nekamyeŋân tângom kinbiâ hârokŋe hâuŋe membai.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Akto Yesuŋe den ginŋe siâ hin dâm makyeŋgiep, “Luâk siâŋe pagaleŋe sagom gauŋmâ umbâ kâlegen katmap dâine pagaleŋe bo miawakbop. Gârâmâ tek tekŋân kato âmâ emet kâlegen ululunŋe arekŋe pagalembo ekmâ gem âgâmai. ");
INSERT INTO tim_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hâkgaet pagaleŋe amâ dewunge. Dewunge âlepŋe tato âmâ hâkge mem pagalewiap. Dâ dewunge bâlimbo hâkgande hândâk akbiap. ");
INSERT INTO tim_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Akto biwiyeŋân pagaleŋe tatâp are bo akbopgât nâŋgâm kinmâ biwi golâ manmâ âgâwi. ");
INSERT INTO tim_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Akto biwiyeŋande agak memeyeŋe irakŋeâk akmâ pagaleŋe olowâk tatbiawân hainâk wan me wan âlepŋe are tek tekŋân ekbai. Pagaleŋe mem tek tekŋân katmai aregât dop hain tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Den are makyeŋgim mando Parisaio luâk siâŋe Yesu sot neâk dâm mem oloŋep. Mem oloŋdo emetŋân âgâm bâtŋe bo pulim yânâk sot mem nemângen ge talep. ");
INSERT INTO tim_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hain akto bâtŋe puliâkgât soŋ bo magaŋepgât Parisaioŋe nâŋgâmbo bo ârândâŋ agep. ");
INSERT INTO tim_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hain akto Humoŋe hin dâm magaŋep, “Bâe, Parisaio ye hin aktâi. Yeŋe âmâ kondo, umbâ tuân pulim hâkgâlâk nâŋgâm manmai aregât biwiyeŋe âmâ heleŋ akmâ ŋasukŋe agep aregât bo nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ye âmâ luâk ulikŋân Anutuŋe Adam ketugum hâk biwi nâŋgâ nâŋgâŋe olop kalep aregât Anutuŋe hâkgât akto biwigât lâuwâ lâuwâ nâŋgâm manmap. Gârâmâ ye âmâ hâkgâlâk nâŋgâm manmai. ");
INSERT INTO tim_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Akto aregât hin makyeŋgiwe. Biwiyeŋe damunŋe akmâ Anutugât den nâŋgâm heŋgemgom lokowai âmâ ârândâŋ akto Anutuŋe yekmâ âlepŋe dâwiap. ");
INSERT INTO tim_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bâe, Parisaio ye wan me wan usak lombo me hemi me kârik hainare amâ Humogât pat dâm katmai. Hain akmâ siâ me siâ Anutuŋe ekto ârândâŋ akmap me Anutugât han kalemŋe are bo lokomai. Gârâmâ wan me wan umatŋe me owâiŋe lâuwâ lâuwâ akmâ manbiâ âmâ ârândâŋ akbiap. Hain akmâ manmai dâine ârândâŋ akbop. ");
INSERT INTO tim_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bâe, Parisaio yeâmâ den emetŋân âgâm luâk kembu yeŋgât tat talân tatberâm aregâlâk nâŋgâmai. Akto dâwân luâk âmbâleŋe yekmâ nâŋgâ yeŋgimbiâ humo agâkgât bam gane dâm aregâlâk biwiyeŋe humo yemap. ");
INSERT INTO tim_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bâe, Parisaio yeŋgât dop siâ hin. Luâk siâ mondo yoŋâk lokom hangombiâ hambuep dop hain. Akto luâk âmbâleŋe kakŋân bam gutmâ aregât bo nâŋgâmai. Ye dop hain akmâ manmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesuŋe hain dâmbo Mosegât den kârikŋe makmâ kepigi areyeŋgât hutyeŋân gâtŋe siâŋe hin dâm magaŋep, “Luâk humo, hain dâm makyeŋgim nen olowâk hâkâŋ nenekmenâ nâŋgâenŋe bâliâp.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","hin dâm magaŋep, “Bâe, Mosegât den kârikŋe makmâ makyeŋgimai yeŋe den siâ siâ umatŋe are luâk kakyeŋân katbiâ lokombiâ yeŋe âmâ bo tânyeŋgum âmâ owâiŋân manmai aregât aŋun bo aŋgimai. ");
INSERT INTO tim_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bâe, ulikŋân bâgilupnenŋande Anutugât den makmâ miawagi are yeŋgum mem siâ siâ ketugu yekbiâ mombiâ are yeŋgât sum kakŋân siâ siâ buluŋe mem togom katmâ mem âlepŋe ketugu yekbiâ kepia sombeim hain are miawagep. ");
INSERT INTO tim_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hain akmâ âmâ bâgilupnenŋande yeŋgâlân lâuwâŋe bugâ yeŋaet nâŋgâmbiâ âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Aregât Anutugât nâŋgâ nâŋgâŋe humo arekŋe den hin dâep, “Hoŋ bawalupne propetelupne akto aposololupne âi makmâ yeŋgim huŋgun yeŋgire yeŋgâlân togom makmâ miawakbiâ yeŋgum hâk hilâlâm siâ siâ ketugu yekbiâ bikŋe mombai.” Anutuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Akto aregât ulikŋân Anutuŋe keiŋe katmâ luâk âmbâle ketugu yekto mali sop ain Anutugât hoŋ bawalupŋe hilip yeŋgum gayi are yeŋgât nâŋgâmbiâ âlepŋe akmap aregât yeŋe hainâk akmâ dosa hainâk membiâ Anutuŋe yekâ hainâk akyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ulikŋân hakulupnenŋande bugâŋe luâk kotŋe Abe kom ainba keiŋe katmâ yeŋgum gam gam bâiŋe Sakaria sumbe emetŋaet hâŋgi akto alatagât keiŋe aregât hutŋânba gam ariwerâm akto ain kombiâ moep. Aregât hin makyeŋgire nâŋgâŋet. Yu mandâi irekŋe Anutugât luâk âi membiâ ârândâŋ agep are hilipyeŋgumbiâ moyi aregât hâuŋe amâ yeŋgâlân miawakbiap. ");
INSERT INTO tim_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bâe, Mosegât den kârikŋe makyeŋgimai yeŋe luâk âmbâle arekŋe Anutugât keiŋe nâŋgâm denŋe lokoyi aregât dâp tigi yeŋgim gamai. Tigi yeŋgimbiâ bikŋande ariwerâmbiâ dâp katyeŋgim âmâ yeŋeak âmâ hâkâŋ akmâ dâp ainba bo arimai.” Hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Akto kepia are hepunmâ siângen ariwerâmbo Mosegât den kârikŋe makmâ kepigi arekŋe akto Parisaio yeŋgât biwiyeŋe kâlâp akto den kakŋân hogo aŋberâm agi. ");
INSERT INTO tim_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hain akmâ Yesuŋe den hilipkom dosa meâk aregât lâmgom kinmâ mali. ");
INSERT INTO tim_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Akto luâk âmbâle dondâŋe togom pikmâ kondan agum kinmâ keiyeŋande tâliagi. Hain akmâ kinbiâ hoŋ bawalupŋe are hin dâm makyeŋgiep, “Ye Parisaio yeŋgât kalak arekŋe yeŋgâlân hâtikowopgât ekmâk manbi. Nâ Parisaioŋe biwi hiaŋgi akmâ manmâ keiyeŋe bo nâŋgâmai aregât maktân. ");
INSERT INTO tim_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wan me wan muneŋ akmai are hainâk bo tatbiap are siân tek tekŋân miawakbiap. Akto wan me wan siâ tik tikŋân tatmap are hainâk bo tatbiap, are siân mem miawakbai. ");
INSERT INTO tim_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ye hândâkŋân heambukmâ kinmâ den dâmai are siân dewutâ humoân âmâ ekmâ nâŋgâm hârogâk ekmâ mem miawakbai. Akto den yoŋâk makmai are siân sombeimân kinmâ makmâ miawakbiâ nâŋgâm metewai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Akto Yesuŋe den siâ hin dâm makyeŋgiep, “Galalupne ire maktere nâŋgâŋet. Luâk siâŋe hâkyeŋe yeŋgum benŋe aregât kakŋân lâuwâŋe bâleŋe siâ akyeŋgiwaigât kârikŋe bo tatyeŋgiâp aregât hamep bo akbi. ");
INSERT INTO tim_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Akto hamep akŋetgât makyeŋgire nâŋgâŋet. Yeŋgum metem âmâ hamiŋân kâlâp kârikŋân panyekto manbai yâkgât hamep akŋet. Gârâmâ yâkgât konok âmâ nâŋgâm hamep akŋet dâm aregât makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Lâut siâ kotŋe sâmbâlilik are âmâ lâut yânŋe dâm aregât puli gegeŋande puligomaen. Hain gârâmâ Anutuŋe sâmbâlilik are yeŋgât hârogâk nâŋgâmbo tatâp. ");
INSERT INTO tim_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dâ Anutuŋe yeŋgât kautyeŋe dumutŋe oyaŋmâ metemap. Aregât hamep bâlâk manbi. Ye sâmbâlilik bo. Ye luâk. ");
INSERT INTO tim_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Akto siâ maktere nâŋgâŋet. Luâk siâŋe biwiŋe nâŋgâlân katmâ luâk âmbâle hutyeŋân agatmâ, “Biwine Yesugâlân katere kindâp.” hain dâm makyeŋgiwiap yâkgât akmâ luâk akmâ geân nâ hainâk Anutuŋe huŋgun niŋdo gewianân âmâ Anutugât aŋelolupŋe makyeŋgire bunŋe membai. ");
INSERT INTO tim_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dâ luâk siâŋe, “Yesu are bo nâŋgaŋdân.” dâm makyeŋgiwiap yâk hainâk nâ Anutuŋe huŋgun niŋdo geân aregât Anutugât aŋelolupŋe yeŋgât dewunyeŋân kinmâ, “Luâk are bo nâŋgaŋdân.” dâwian. ");
INSERT INTO tim_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Akto luâk siâŋe nâ luâk akmâ geân bâleŋe akniŋmâ mem ge katnekmâ âmâ dosa membiap are Anutuŋe dosa hepun aŋbiapgât dopŋe tatâp. Dâ luâk siâŋe Anutugât Heakŋe are mem ge katmâ âmâ dosa membiap are Anutuŋe hepun aŋbiapgât dopŋe bo tatâp. Borondâ. ");
INSERT INTO tim_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Akto siâ maktere nâŋgâŋet. Denân kat yekberâm meyekmâ den emetŋaet damunŋe yeŋgâlân me kiap yeŋgâlân meyekmâ ariwaiân âmâ, “Den hâuŋe gain gain dâwaen.” dâm nâŋgâmâk bo akbi. ");
INSERT INTO tim_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sop ain den akbai are Anutugât Heakŋande den dâpŋe meyeŋgim makyeŋgimbo âlepŋe dâwai.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Akto kinbiâ hutyeŋânba luâk siâŋe agatmâ hin dâm Yesu magaŋep, “Luâk Humo, maktere nâŋgâ. Ewenetŋe mondo teunande ito sikum ikiŋeâk mem mandâp. Mem mandâp aregât magaŋmenâ bikŋe potatmâ niŋâk.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","hin dâm magaŋep, “Luâk kotdâ siâŋe nâ yeŋgât damunyeŋe dâm bo kat negep aregât gâ wangât nâŋgâlân aregât maktât?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hain magaŋmâ purik katmâ kâmot kili are yekmâ hin dâm makyeŋgiep, “Sikum me kalam humo are biwiyeŋaet bo. Are âmâ hâk yeŋaelâk. Haingât galalupyeŋande hainare mem manmai are yekmâ aregât ukenŋe nâŋgâmbiâ biwiyeŋe bâlimap are bo agakŋe.” ");
INSERT INTO tim_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hain dâm den ginŋe hin dâm makyeŋgiep, “Luâk kotdâ siâŋe sot kâmeto bunŋe dondâ miawakmâ unsambe agep. ");
INSERT INTO tim_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akto biwiŋande hin nâŋgâep, “Gain gain akbe? Sot dondâ ire mem emet gain hinan katbe? ");
INSERT INTO tim_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nâ hin akbe. Nâŋe sot emetŋe bâlensiâ are patakom humoâk ketugum âmâ katere tatbiâp. ");
INSERT INTO tim_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tato unsambe humo yeniŋdâpgât tatmâ nâŋgâm sop kâlep aregât sot tu nem ukenŋe nâŋgâm heroŋe maroŋe manmâ âgâwian.” hain nâŋgâmbo ");
INSERT INTO tim_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Anutuŋe hin dâm magaŋep, “Gâ kopa. Emet dâgâmbo momberât. Momenâ âmâ wan me wan siâ siâ are katmâ mem konok ketuguen are luâk niŋande membiap?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Den ginŋe are keiŋe hin dâm makyeŋgire nâŋgâŋet. Siâ yâk Anutugâlân han unsambe bo yeaŋdo âmâ ikiŋaet pat dâtâŋe sot sikum mem oloŋmâ mem manbiap dopŋe hainâk hâmbâi miawagaŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Akto Yesuŋe aposololupŋe hin dâm makyeŋgiep, “Aregât maktere nâŋgâŋet. Manmanyeŋaet hanokoak bo akbi. Akto hin bo dâwi, “Wan nem manbaen?” Akto hâkyeŋaet nâŋgâmâk bo akmâ hin bo dâwi, “Wan mem luguakmâ manbaen?” ");
INSERT INTO tim_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sotŋe amâ bunŋe bo. Manmanyeŋande amâ bunŋe. Akto sâŋgumŋe amâ bunŋe bo. Hâkyeŋande amâ bunŋe. ");
INSERT INTO tim_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ye lâut are yekŋet. Are âmâ âi bo ketugumai, akto kalam yeŋânba sot wan bo mem mendugumai. Akto kâmbum bo ketugum alekŋe katmai. Hain bo akmai aregât Anutuŋe irawotŋân sot mem miawak yeŋgiep. Ye lâut hainare bo. Lâut amâ gegeŋe. Dâ ye amâ âgâ âgâŋe aregât nâŋgâm heŋgemgom âmâ bo hanokoakmâ manbi. ");
INSERT INTO tim_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Akto yeŋgâlân gâtŋe siâŋe ikiŋe nâŋgâ nâŋgâ watmâ manman kâlep manbiapgât dop bo tatâp. ");
INSERT INTO tim_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Arekŋe wan me wan yânŋe hain are akmâ ewum pâpkomai aregât wan me wan umatŋe aregât nâŋgâm hanokoakbiâ ârândâŋ bo akmap. ");
INSERT INTO tim_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Akto aregât siâ makbe. Dem dem surandem are ekŋet. Sâŋgum lâuwâ lâuwâ yeŋaet âi bo ketugumai. Akto Salomo yâkŋe sâŋgum kulem melem âlepŋe dondâ mem malep arekŋe tâk buluŋe are bo ewangiâp. ");
INSERT INTO tim_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Akto pâloŋângen siâ me siâ buluŋe yeukŋe uŋak hainare miawaktâp dâ hole hainare bererek âgâm gembo ombiâ omap amâ Anutuŋe hanâk makto kulemŋe âlepŋe miawakmap. Aregât yeŋgât sâŋgum wan me wan mem miawakmâ yeŋgiwiap aregât nâŋgâ nâŋgâ yeukŋe bo nâŋgâm heŋgemgowi. ");
INSERT INTO tim_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Akto wan me wan nembaen me tugât gain gain membaen dâm aregât bo hanokoakbi. ");
INSERT INTO tim_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Are âmâ luâk âmbâle hânŋe hânŋe manmâ Anutu bo nâŋgaŋmai yâkŋe hanoko akmâ kulâgâtmâ manmai. Dâ ye siâ me siâ are bâlâk âlepŋe bo manbai are Eweyeŋande nâŋgâmap. ");
INSERT INTO tim_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dâ ye âmâ, “Anutuŋe damun nenŋe akberâm aktâp.” hain nâŋgâm denŋe lokombiâ âmâ damunyeŋe akmâ wan me wan are yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Aregât nâŋgâm biwiyeŋân katmâ hamep bo akmâ manbi. Eweyeŋe Anutuŋe yeŋgât nâŋgâmbo heroŋe akto, “Nâŋgâlân gambiâ olowâk manbaen.” dâm makyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aregât kotŋe siâ siâ tat yeŋgiâp are mem arim yeŋgimbiâ yâkŋe puli yeŋgimbiâ mem arim luâk umburuk manmai are yeŋgiwai. Hain akbiâ himbimân katyeŋgiep are bo gulip akyeŋgiwiap. Akto himbimân are luâk kâmburâŋe bo meyeŋgiwai me saŋ saŋ siâŋe bo nem hilipko yeŋgiwiap. Hain akbiâ are kârikŋeâk tat yeŋgiwiâp. ");
INSERT INTO tim_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Egâliaŋ yeŋe yembiap hainâgâk hanyeŋe yembiâp. ");
INSERT INTO tim_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Hoŋ bawalupyeŋande luâk humoyeŋe siâŋe âmbâi mendo aregât sot om taliânba purik katmâ togom emet kâlegen gambo, “Woa” dâm den hogo aŋberâm hâŋgiân lâmgom tatmai dop hainare akmâ biwi golâk tatmâ manbi. Tatmâ manmâ, “Humonenŋe amuten purik katmâ togowiap.” dâm biwiyeŋaet damun kârikŋe akbi. ");
INSERT INTO tim_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Luâk kotdâŋe hoŋ bawalupŋe biwiyeŋe golâ akto tatbiâ âmâ purik katmâ togom mem miawak yekmâ âmâ nâŋgâ yeŋgimbo âlepŋe akbiap. Hain akmâ biwi hero nâŋgâm itoŋe lândem katmâ sot om oyaŋmâ yeŋgim neŋet dâm yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Akto hândâk timoŋân yendo hoŋ bawalupŋe biwi golâ tatmâ damungombiâ purik katmâ gam mem miawakyekmâ biwi hero humo nâŋgâ yeŋgiwiap. Hain nâŋgâm heroŋe akŋet dâm nâŋgâ yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Akto siâ maktere nâŋgâŋet. Kepia ambolupŋande gasalupyeŋe hândâkŋân togowai sop are nâŋgâm dâine âmâ biwi golâ tatmâ kepiayeŋe damungombiâ âmâ bo bâliyeŋgiwop. ");
INSERT INTO tim_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aregât nâ luâk akmâ geân nâmâ hâmbâi lâuwâŋe purik katmâ gewian aregât sopŋe bonâŋgâmai. Aregât yeâmâ biwi golâk damun nugum manbi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesuŋe den ginŋe hain dâmbo Petoroŋe aikom hin magaŋep, “Humo, den ginŋe are Aposolo nengâlâk maktât me luâk hârok nengât maktât?” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","hin makyeŋgiep, “Den umatŋe siâ maktere nâŋgâŋet. Luâk kotdâ siâŋe hoŋ bawalupŋe yeŋgât damun siâ katmâ hin dâm magaŋbiap, “Arim mandere gâŋe damunyeŋe akmâ sowânâk sot me soŋgo are dop yeŋânâk yeŋgim manben.” ");
INSERT INTO tim_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hain dâm hepunyekmâ arimbo damunyeŋe arekŋe âi aregât biwiŋande mem heŋgemgom mando humoŋande purik katmâ togom ekmâ okot âlep nâŋgâ aŋbiap. ");
INSERT INTO tim_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aregât den bunŋe hin makyeŋgiwe. Hângât sikum siâ siâ are hârok damungowen dâm magaŋbiap. ");
INSERT INTO tim_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dâ humoyeŋande damunyeŋe akmâ manben dâm arimbo âmâ damunyeŋande biwiŋande hin nâŋgâwiap, “Kotdânande hepun nekmâ arim sop kâlep mandâp imâ dowâk bo togowiap.” nâŋgâm âmâ damunyeŋe akmâ âmâ gala bo akyeŋgim tu kârikŋe nem biwi gulip akto ");
INSERT INTO tim_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","humoŋande dowâk sân sânâk bo nâŋgâwiap ain togom ekmâ aregât hâuŋe waŋmâ mem kom gâimbo itik matik akto den bo lokomai ain hâkokombo hememgât pat akbiap. ");
INSERT INTO tim_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Akto aregât siâ makbe. Hoŋ bawa arekŋe den are nâŋgâm heŋgemgom âmâ bo lokomaiŋe aregât hâuŋe umatŋe membai. ");
INSERT INTO tim_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dâ hoŋ bawa siâŋe âmâ humoŋaet den pâpkom âmâ âi mem hilipkomap amâ bugâŋe owâiŋe igiwiap. Hain aregât den dâtŋe âmâ hin. Luâk siâŋe umatŋe are waŋdere memapŋe âi ketugum manmâ bunŋe umatŋeâk mem miawakto âmâ ârândâŋ akbiap. Dâ luâk siâ âi humo makmâ waŋdere memapŋe aregât hâuŋe bunŋe umatŋe dondâ bo mem miawakto âmâ are ârândâŋ bo akbiap. ");
INSERT INTO tim_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kâlâp punduŋ panmâ loŋgaim siângen arim om metemap dop hainâk agak meme bâleŋe akbiâ aregât hâuŋe yeŋgiwian aregâlâk nâŋgân. Are emelâk miawakto dâine heroŋe akbom. ");
INSERT INTO tim_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Akto hâk hilâlâm nâŋgâre aregât kakŋân nâŋgât den pat âlepŋande miawakmâ ariwiap. Aregât hâk hilâlâm are miawakto bo akbiap aregât biwine umatŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Akto maktere nâŋgâŋet. Nâŋgât âmâ hin bo dâwi, “Gala konok manŋet dâm aregât maktâp.” Hain bo. Nâ geân aregât hioŋakmâ me potalakmâ kâmot lâuwâ akmâ mandâi. Akto hainâk akmâ manbai. ");
INSERT INTO tim_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Emet siâ aregât kâlegen luâk âmbâle nan baratlupyetŋe momerâk manmaiŋe potalakmâ kâmot lâuwâ akbai. Biken lâuwâ biken âlâwu hain potalakbai. ");
INSERT INTO tim_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Akto eweŋe nanŋâi arekŋe potalakmâ yetŋe gasa agaŋgiwiandat. Akto memeŋe baratŋâi âkâ hainâk potalakmâ yetŋe gasa agaŋgiwiandat. Akto erânŋe erânŋe arekâ hainâk potalakmâ gasa agaŋgiwiandat. Amâ hainâk nâ geân aregât gasa agaŋgiwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuŋe luâk âmbâle kâmot humo are hin dâm makyeŋgiep, “Hamandat dâgâmbo âmâ ye hin dâmai, “Woe, tânâk hologowerâm aktâp.” hain dâmbiâ hainâk akmap. ");
INSERT INTO tim_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Akto hamandat tokberâmbo âmâ ye hin dâmai, “Emelâk dewutâ komberâp.” dâmbiâ hainâk akmap. ");
INSERT INTO tim_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ye hiaŋgi luâk. Yeŋe hamandat kulewoŋwoŋ aregât keiŋe nâŋgâmai. Dâ sop iregât keiŋe wangât bo nâŋgâm heŋgemgomai? ");
INSERT INTO tim_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aregât gain gaingât âmâ hanyeŋeâk akmâ dâp âlepŋe bâleŋe are bo ekmâ nâŋgâmai? ");
INSERT INTO tim_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gasagande meŋgekmâ kiapgâlân arim denân kat gekmâ dâm hâre giŋdo tembe lokolupŋande meŋgekmâ kala busiân kat gekbâi aregât dâwân arim galage makmâ miawagaŋmenâ yetŋeâk dâm gala agaŋgiwiandat. ");
INSERT INTO tim_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Borâm hâre aŋgiwiandat akto âmâ kala busiân kat gekbiâ tatmâ âmâ yân bo gewiat. Hâu hârok puligom kutigitbialân âlepŋe ain gewiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sop ain luâk bikŋande Yesugâlân togom den pat hin magaŋi, “Pilatoŋe dâmbo tembe lokolupŋande Galilaia hânân gâtŋande lama akto makao kom gâim Anutugât sumbe higenŋe oyi yâk yeŋgumbiâ gilâmyeŋe gembo makao gilâmyeŋe olop mendugum katmâ oyi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hain dâm magaŋbiâ hin dâm makyeŋgiep, “Pilatoŋe dâmbo yeŋguyi areyeŋgât gain dâmai? Moyi yeŋgât dosa bâleŋe arekŋe âmâ Galilaia siânba yeŋgât dosa are ewangiâp dâmai me? ");
INSERT INTO tim_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hain bo. Akto yeŋgât dosa keiŋe aregât agak memeyeŋe bâleŋe dondâ bo hepunmâ âmâ Anutugât den bo nâŋgâ aŋmai are hâuŋe yeŋgiwiap ain hainâk ye yeŋgiwiap. Akto aregâlâk siâ makbe. ");
INSERT INTO tim_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yerusalem luâk 18 kinbiâ Siloam kepiagât emet kâkâlep arekŋe kâwulakmâ tigiyegep are yeŋgât hin bo dâwi, “Dosayeŋe bâleŋe âmâ Yerusalem kepia ambolupŋande aŋgâ yeŋgât dosa ewangiâp aregât moyi.” ");
INSERT INTO tim_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hain bo dâwi. Aregât maktere nâŋgâŋet. Yeŋgât dosa tatâp aregât agak memeyeŋe bâleŋe are bo hepunmai, biwiyeŋe Anutugâlân bo katmai akto âmâ yekâ hainâk hilip aguwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Den aregât dop siâ makyeŋgiwerâm aregât hin makyeŋgiep, “Luâk siâŋe lowot siâ kâmeto humo agep. Akto amboŋande koaŋe hârewerâm akmâ arim ekto koaŋe siâ bo yiep. ");
INSERT INTO tim_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hain akto aregât kalam damunŋe hin magaŋep, “Nâ lâwin iregât bunŋaet kulâgâtmâ lâmgom mandere hombaŋ âlâwu aktâp lâwin ire wangât yân kinbiap? Kârâmenâ geâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hain dâmbo yâkŋe hin dâep, “Luâk humo, hanâk hepunmenâ hombaŋ irekâ kilâk. Hâmbâi nâŋe keiŋân ire une lokom togo katere hambumbo âmâ bunŋe siâ yembiap me bo are ekbaet. ");
INSERT INTO tim_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sop siân bunŋe miawakbiap amâ âlepŋe. Dâ arekâ hainâk bo akto âmâ makmenâ kârâm panbaen.” hain dâep.” ");
INSERT INTO tim_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu Sarere âi bo meme sopŋe siân den emetŋân âgâm den potatmâ makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Den makyeŋgimbo âmbâle siâ ain talep. Are âmâ sinduk baniara bâleŋande memeŋe agaŋmâ hamiŋe hagitŋe mem goŋ goŋgombo kâŋgomâk manmâ gambo hombaŋ 18 bo agep. ");
INSERT INTO tim_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Akto Yesuŋe âmbâle are ekmâ hin dâm magaŋep, “Meŋ, hinŋe âmâ kundat bo akgiŋdo âlepŋe ak.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hain dâm bâtŋande mendo hamiŋe miwindik akto tâŋâk kinmâ Anutuŋe okot âlep akniŋdâp dâm heroŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hain akto Yesuŋe âi meme sopŋe boân heŋgemgoep aregât den emetŋaet damunŋe nâŋgâmbo bâlimbo luâk âmbâle hin dâm makyeŋgiep, “Âi ketugu ketugu sopŋe tatâp ain togombiâ âmâ heŋgem yeŋguwiap. Dâ uŋak Sarereân heŋgem yeŋguâp ire amâ bo agakŋe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hain dâmbo Yesuŋe aregât den hâuŋe hin magep, “Bâe, hiaŋgi luâk. Ye Sarere âi meme sopŋe boân yeŋe doŋgi me bulimakao pekeyeŋe hindâm meyekmâ arim tu yeŋgimaigât dâp tatâp. ");
INSERT INTO tim_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dâ âmbâle hamiŋe tâŋâk bo ire âmâ Abrahamgât hakuŋe siâ Niambi arekŋe memeŋe agaŋdo kopa akmâ manmâ gambo hombaŋ 18 bo agep. Haingât Sarereân mem heŋgemgore ârândâŋ aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hain dâmbo gasa agaŋi arekŋe aŋun aŋgiyi. Akto luâk âmbâle kâmot humo arekŋe kulem âlepŋe miep are egi aregât heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuŋe den siâ lâuwâŋe hin dâep, “Anutugât kâmot manmai are yeŋgât dop wanân katmâ maktere ârândâŋ akberâp? ");
INSERT INTO tim_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aregât hin dâwe. Kapok koaŋe âmâ bâleŋ siâ gârâmâ luâk siâŋe mem arim âi kâlegen kâmeto kâmŋe gam miawakmâ lâwin humo akmâ kinmap. Akto lâutŋe togom aregât bât bâtŋân panmâ tatmai. ");
INSERT INTO tim_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Akto siâ makbe. Anutugât kâmot manmai areyeŋgât wanân dop katbe? ");
INSERT INTO tim_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Are âmâ matuk keluŋe hain are âmbâle siâŋe matuk keluŋe are mem pipikom ondo sot hârok ukenŋe akmap dop hain are.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Akto Yesuŋe Yerusalem kepian purik katberâm arim kepiaŋe kepiaŋe den potatmâ yeŋgim malep. ");
INSERT INTO tim_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hain akto luâk siâŋe aikoep, “Anutuŋe luâk amon bâleŋânba mem oloŋyekto âlepŋân gamai? Amon siâ mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Hain dâmbo hin dâep, “Himbimân âgâwerâm âmâ dâp gâwikŋân hâk hilâlâm nâŋgâm ariwai. Akto luâk âmbâle dondâ ain ariwerâm âmâ hâk hilâlâm humo nâŋgâm ewum hâumgowai. ");
INSERT INTO tim_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Emet amboŋe akmâ manmâ dawalauŋe tigimbo luâk âmbâle dondâŋe âgâwerâm ewum hâumgom betgen kinmâ hin dâwai, “Humo, hâŋgi mem katnengi.” dâmbiâ hin dâwiap, “Ye wânân gâtŋe?” ");
INSERT INTO tim_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hain dâm aiyeŋgumbo aregât hin dâm magaŋbai, “Nen âmâ gâ olop kondo konogân sot neyion. Akto kepia nenŋân manmâ den potatmâ nengimenâ nâŋgâyion aregât hâŋgi mem katnengi.” ");
INSERT INTO tim_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hain dâmbiâ hin dâm makyeŋgiwiap, “Ye wânân gâtŋe? Nâ bo nâŋgâ yeŋgiân. Ye bâleŋe meme aregât ariŋet.” hain dâm wat yekbiap. ");
INSERT INTO tim_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hâmbâi ye Anutuŋe wat yekto purik katberâm kinmâ hamiyeŋângen Abraham akto Isaka akto Yakobo akto Anutugât den makmâ miawakmâ gayi are hârogâk Anutugât kâmolân purik katmâ mandâi are yekmâ biwiyeŋe bâlimbo kuk nâŋgâm han kalak akmâ manbai hain. ");
INSERT INTO tim_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Sop ain dewutâ gagaŋângenba akto gegeŋângenba akto bikenba bikenba areâk gam menduguakmâ sot nem heroŋe akbiâ Anutuŋe damunyeŋe akbiap. ");
INSERT INTO tim_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nâŋgâi. Yeŋgâlân gâtŋe siâŋe, “Nâ luâk humo.” dâm ikiŋe kotŋe mem agatbiap are âmâ hami togowiap. Dâ siâŋe, “Nâ luâk gegeŋe.” dâm manbiap are âmâ Anutuŋe mem âgâm ulik gulik katbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sop ainâk Parisaio luâk bikŋande togom hin dâm magaŋi, “Heroteŋe guguwerâm aktâp aregât hân ire hepunmâ siângen ari.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","hin dâep, “Nâŋgâi. Sinduk baniara bâleŋe watyekmâ mandân. Akto luâk kundatdâ areyeŋgât maktere bo akyeŋgiâp. Âine ketugum mandere hilâm âlâwu bo akto ârândâŋ akbiap. Aregât ye arim dua metŋe Herote are nâŋe wan me wan aktân mendân iregât den pat magaŋbi. ");
INSERT INTO tim_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Akto ire maktere nâŋgâŋet. Yerusalem kepia ambolupŋande Anutugât den makmâ miawagi are Yerusalem kepian yeŋgumbiâ moyi aregât nâkâ kepia siân mombomgât Yerusalem kepian arire hilâm âlâwu akto ewangiwian. ");
INSERT INTO tim_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalem kepia ambolupŋe, yeŋe Anutugât den makmâ miawagi are bugâŋe yeŋgumai. Akto Anutuŋe hoŋ bawalupŋe huŋgun yeŋgimbo yeŋgâlân togombiâ kâtŋe mem yeŋgumai. Puiŋe nanaŋlupŋe damunyeŋe akmâ mem mendugu yekmâ korat yeŋgumap dop hainâk mendugu yekmâ okotnân katyekmâ damunyeŋe akberâre hâkâŋne akmâ arimai. ");
INSERT INTO tim_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aregât Anutuŋe damunyeŋe bo akmap aregât kepiayeŋe hepundo bugâ yembiap. Hain gârâmâ siâ hin maktere nâŋgâŋet. Hâmene bo nekmâ âgâwai aregât hilâm siân miawaktere nekmâ âmâ hin dâwai, “Anutu Humoŋe wâtŋe giŋmâ huŋgun giŋdo togoât aregât heroŋe akgiŋne” hain dâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sarere siân Parisaio are yeŋgât damun kautŋande sot nemberâm Yesu kewugumbo emetŋân âgâyiat. Âgâmbela luâk bikŋande yelekmâ Yesuŋe akmâ hilipkombo eknerâm aregât damun kili. ");
INSERT INTO tim_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Damun kinbiâ luâk siâŋe hâkŋânba diwi metŋe humo miawagaŋep arekŋe Yesu ekberâm âgâep. ");
INSERT INTO tim_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Âgâmbo Yesuŋe ekmâ Mosegât den kârikŋe makmâ kepigi are akto Parisaio hin dâm makyeŋgiep, “Mosegât den kârikŋe are gain gain tatâp? Âi bo meme sopŋân luâk âmbâle heŋgem yeŋguwiangât dopŋe tatâp me bo? Makniŋbiâ nâŋgâwe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hain dâmbo den hâuŋe bo magaŋi. Hain akmâ aŋun aŋgim kinbiâ makto diwi metŋe are bo agaŋdo huŋgunaŋdo ariep. ");
INSERT INTO tim_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Arimbo emelan tali are hin makyeŋgiep, “Lamayeŋe me bulimakao yeŋe siâ âi bo meme sopŋân lâmân gembo âmâ aregât undâgâtmâ mem miawakmâ hikom oloŋmâ gamai me bo?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hain dâm makyeŋgimbo hâuŋe bo magaŋmâ hanyeŋeâk aŋun aŋgim tali. ");
INSERT INTO tim_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Akto sop ain luâk bikŋe togom emet ain gam âgâyi arekŋe yeŋe hanyeŋân âgâ kau dewunŋân tatberâm akbiâ yekmâ aregât hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Luâk siâŋe âmbâle membiapgât sot humo omberâm oloŋ gekto arim âmâ gâŋe hangeâk âgâ kau dewunŋân bo tatben. ");
INSERT INTO tim_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Dâ gâŋe hain akbiat âmâ luâk oloŋ gekbiap arekŋe hin dâm makgiŋbiap, “Ire gâŋgât welam bo. Ekemenâ âkâ luâk irekŋe talâk.” Hain dâm makgiŋdo aŋun aŋgim hami hami gem arim tuŋguŋângen tatbiat. ");
INSERT INTO tim_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hain gârâmâ gâ hin akben. Luâk tatbiâ ain âmâ gugaet nâŋgâmenâ gembo tatmenâ emet amboŋande gekmâ hin dâm makgiŋbiap, “Galane tuŋguŋângen tatât uŋgure gam âgâ dakegen tat.” dâm makgiŋdo âmâ ain tatbai arekŋe gekmâ okot âlep akbai. ");
INSERT INTO tim_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aregât keiŋe hin. Luâk siâŋe ikiŋe kotŋe mem agatbiap are âmâ hâmbâi Anutuŋe mem ge katbiap. Dâ luâk siâŋe ikiŋe kotŋe bo mem agatbiap are âmâ hâmbâi Anutuŋe mem agatbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hain dâm makyeŋgim benŋe luâk oloŋep are hin dâm magaŋep, “Sot omberâm âmâ emi teulupge me nan baratlupge me ginbailupge me luâk puli me ito sikumyeŋe olowâk mandâi are bo oloŋ yekben. Dâ hain akbiat âmâ hâmbâi yâkâ aregât hainâk hâuŋe mem oloŋ gekbiâ aregât dosa bo akbiap. ");
INSERT INTO tim_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aregât hain bo akben. Sot omberâm âmâ kopa me umburuk me dewunyeŋe bok bokŋe me keiŋe bâleŋe hain are oloŋ yekben. ");
INSERT INTO tim_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hain are oloŋ yekmâ hâu bo giŋbaigât heroŋe maroŋe kakŋân sot om yeŋgimenâ nembai. Gârâmâ hâmbâi sop humoân agatbaiân Anutu ikiŋak hâuŋe giŋbiap aregât nâŋgâm biwige heroŋe agâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hain dâmbo sot nem tali are hut yeŋânba siâŋe den are nâŋgâm hin dâep, “Anutugât kâmot manden aregât sop humoân Anutu olowâk sot nembaen aregât nâŋgâre heroŋe aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hain dâmbo Yesuŋe den ginŋe siâ hin dâm magaŋep, “Luâk humo siâŋe sot ombian dâmbo aregât sot mem mendugumbiâ kindo luâk dondâ yeŋgât sop kalep. ");
INSERT INTO tim_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Akto arim arim emelâk sop are miawakto sot om katbiâ ekto ârândâŋ akto hoŋ bawa siâ huŋgun aŋdo arim âmâ hin dâm makyeŋgiep, “Sot hârok om katmâ lâm yeŋguengât togoŋet.” dâm makyeŋgimbo hâkâŋ agi. ");
INSERT INTO tim_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hâkâŋ akmâ luâkŋe luâkŋe hârok hin dâyi, “Hân puligoân arekŋe oloŋ nektâpgât are ekberâm ariwerân aregât luâk humoge are magaŋmenâ nâŋgâmbo bo bâliwiâp.” ");
INSERT INTO tim_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Akto siâŋe hin dâep, “Bulimakaolupne 10 puligoân are meyekmâ togowerângât luâk humoge are magaŋmenâ nâŋgât nâŋgâmbo bo bâliwiâp.” ");
INSERT INTO tim_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Siâŋe hin dâep, “Hinŋeâk âmbâle meângât bo togowerân. Gain gain akmâ togowerân?” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Akto hoŋ bawa arekŋe purik katmâ arim luâk humoŋe den dâyi are magaŋdo nâŋgâmbo bâliep. Nâŋgâmbo bâlimbo hoŋ bawa are hin dâm magaŋep, “Gâŋe dowâk arim emetŋe emetŋe luâk umburuk mandâi are akto luâk kopa akto ondopyeŋe bok bokŋe me dewunyeŋe bok bokŋe luâk hainare meyekmenâ togoŋet” dâmbo hin dâm magaŋep, ");
INSERT INTO tim_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Luâk humo. Den maktât are akmâ meteân. Gârâmâ emetge ire boâk piktâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hain dâmbo hin magaŋep, “Hanâk siâkâ arim kepia ginŋângen akto halângen yoŋâk yoŋâk mandâi are undâgât yeŋgim mem miawak yekmenâ togoŋet. Togom emetne pikŋet. ");
INSERT INTO tim_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Dâ emelâk mem oloŋyekberâm aktere bo dâyi are âmâ yânâk tatbai.” dâep.” Yesuŋe den ginŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Akto luâk dondâŋe Yesu hamiŋângen watmâ arimbiâ purik dâm hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Luâk siâŋe nâŋgâlân dewatiwerâm akmâ âmâ ewe memelupŋe me âmben nanaŋlupŋe me emiŋe gariŋe hepun yekbiâp. Akto ikiŋe manman aregât ukenŋe bo nâŋgâm gangerâwiâp. Dâ luâk siâŋe hain akbiap are âmâ nâŋgât hoŋ bawa akmâ manbiap. ");
INSERT INTO tim_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Luâk siâ gasalupŋande wan me wan siâ akmâ hilipkowai aregât hamep akmâ ikiŋe hâkŋe gangerâm manbiap arekŋe nâŋgâlân bo dewatiwiap. ");
INSERT INTO tim_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yeŋgâlân gâtŋe siâŋe emet ketuguwerâm âmâ ulik gulik puli soŋ oyaŋmâ ekto ârândâŋ akto âmâ emet are ketugumap. ");
INSERT INTO tim_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dâ hain bo akmâ yân emetŋe are ketugumbo puli bo akto pâŋân hepundo emet are yân kindo ekmâ aregât den pat magaŋgi goaŋgi akmâ dewunŋân gem giriŋ aŋmâ hin dâwai, ");
INSERT INTO tim_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Luâk irekŋe luâk hanŋeâk nâŋgâm tetembeŋe anuŋdo giep ina gain gain akmâ benŋe yân hepundo kindâp.” hain dâmai. ");
INSERT INTO tim_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Akto siâ hin. Luâk humo siâŋe luâk humo siâgât gasa agaŋmâ ligim ainâk agatmâ bo arimap. Tatmâ nâŋgâ nâŋgâ hin soŋ nâŋgâwiap, “Nen ire amâ amon siâ manden dâ indâgen âmâ yâk biwirâ hain mandâi. Aregât nenŋe âlepŋe yeŋguwaengât dop bo.” ");
INSERT INTO tim_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hain dâm ikiŋaet nâŋgâmbo gembo gasalupŋe kâlewângen manbai ainâk hoŋ bawa siâ huŋgun aŋdo arim hin dâm makyeŋgiwiap, “Ye olop gala konok manberâm huŋgun niŋdâp” hain dâwiap. ");
INSERT INTO tim_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Akto aregât keiŋe hin. Yeŋgâlân gâtŋe siâŋe hainâk kotŋe siâ siâ mem gangerâm hârogâk bo hepunmâ nâŋgâlân dewatiwiap are âmâ maktere nâ olop âlepŋe bo manbaet. ");
INSERT INTO tim_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kâtembe siâ ukenŋe bo heŋgemgom kotŋe gulip katbiat âmâ dowâk pâlâmŋe akbiap. Hain akbiap aregât siân gain gain akmâ âmâ lâuwâŋe ukenŋe akbiap? Are bo agakŋe. ");
INSERT INTO tim_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Hain akmap aregât yân kâienŋe gemap. Gârâmâ ye den ire nâŋgâm biwiyeŋân katmâ heŋgemgom manbi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Akto luâk bikŋande gawaman yeŋgât puli meme luâk akto luâk agak meme bâleŋe akmini arekŋe sop siân Yesugâlân den nâŋgâwerâm togoyi. ");
INSERT INTO tim_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Togombiâ Mosegât den kârikŋe makmâ kepigi akto Parisaio luâk arekŋe nâŋgâmbiâ bâlimbo Yesugât hin dâyi, “Yesuŋe puli meme luâk akto luâk agak meme bâleŋe akmai are meyekto yâk olop sot nendâi imâ bâliâp.” ");
INSERT INTO tim_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hain dâmbiâ aregât Yesuŋe den ginŋe hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yeŋgâlân gâtŋe siâgât lama 100 kinaŋbiap. Akto hutyeŋânba konokŋe heambukto amboŋande hepunbiap me bo hepunbiap? Amâ bo hepunbiap. Bikŋe are hân haŋaŋân katyekto kinbiâ siâ heambukbiap aregât undâgâtbiap. ");
INSERT INTO tim_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Undâgâtmâ mem miawakmâ okot âlep akmâ oloŋmâ kepian togowiap. ");
INSERT INTO tim_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kepian togom galalupŋe yeŋgonmâ hin makyeŋgiwiap, “Lama siâ heambugep ina mem miawaktân aregât heroŋe akne.” dâwiap. ");
INSERT INTO tim_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aregât maktere nâŋgâŋet. Luâk 99 yâkŋe âmâ dosa nenŋe bo dâmai are yeŋgât Anutuŋe okot âlep humo bo akyeŋgimap. Gârâmâ bâleŋe meme luâk konokŋe agak memeŋe akto dosaŋe are nâŋgâmbo bâlimbo hanŋe purikato Anutuŋe ekto ârândâŋ akto dosaŋe hepun aŋbiap. Hain akmâ hulaŋdo himbimân manmai arekŋe heroŋe humo akbai. ");
INSERT INTO tim_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Akto den siâ hin. Âmbâle siâŋe puli koaŋe 10 membiap. Akto puli koaŋe siâ heambukto hepunbiap me undâgâtbiap? Bo hepunbiap. Are kemdâ sagom gauŋmâ gagap urutmâ undâgâtmâ manbiap. ");
INSERT INTO tim_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Undâgâtmâ manmâ mem miawakmâ aregât emi tâulupŋe akto ginbailupŋe yeŋgonmâ hin makyeŋgiwiap, “Puli koaŋe heambugep are ina mem miawaktân aregât heroŋe akne.” dâwiap. ");
INSERT INTO tim_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aregât maktere nâŋgâŋet. Himbimân Anutugât aŋelolupŋande hainâk bâleŋe meme luâk siâŋe agak meme bâleŋe makmâ miawakmâ, “Anutu dosane hepun niŋ.” dâwiap aregât okot âlep nâŋgâ aŋbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Akto Yesuŋe den ginŋe siâ hin dâm makyeŋgiep, “Luâk siâgât nanlogâtŋe lâuwâ maliat. ");
INSERT INTO tim_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Manmâ nanŋe bâiŋande eweŋe hin dâm magaŋep, “Tâk puli are teune olop potatmâ netki.” dâep. Hain dâmbo tâk puli are ewe yetŋande potatmâ teuŋe olop yetkiep. ");
INSERT INTO tim_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Akto emiŋe are âi ketugum getek manmâ tâk puliŋe are meakmâ dâp kâlewângen ariep. Arim manmâ sot soŋgoân puligom kotŋe gulip gulip akmâ puli are hârok panmâ metiep. ");
INSERT INTO tim_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Panmâ metembo hân ain mop humo miawagep. Miawakto nanaŋ are tâwât dewunŋe siâ siâgât umburuk akmâ ");
INSERT INTO tim_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","hân amboŋe siâgâlân arim mando yâkŋe yâkgât bau damunŋe akmâ manben dâm huŋgunaŋep. Huŋgunaŋdo arim bau damungom mando mopŋe dondâ agumbo siâ me siâ sot bo waŋdo âmâ ");
INSERT INTO tim_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","bau yeŋgât goka hâkŋe nemberâm agep. ");
INSERT INTO tim_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Hain akmâ nâŋgâ nâŋgâŋe miawakto hin dâep, “Apogât âi luâklupŋande âmâ sot dondâ nemai. Dâ nâ âmâ sotgât akmâ hilip aguwerâm aktân. ");
INSERT INTO tim_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aregât agatmâ kepian purik katmâ apogâlân arim hin dâm magaŋbian. Apo, bâleŋe aktere dosanande Anutugâlân akto gâŋgâlân umatŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Akmâ hilipkoân aregât nange bo nogonben. Yân hoŋ bawage akbiangât menekmenâ manbe.” ");
INSERT INTO tim_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hain nâŋgâm agatmâ arim aŋgângen togombo eweŋande dewunŋe panmâ egep. Ekmâ okotŋe nâŋgâm pârigim arim nanŋe lokom maŋganlep. ");
INSERT INTO tim_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Akto nanŋande hin dâm magaŋep, “Apo, bâleŋe aktere dosanande gâŋgâlân akto Anutugâlân umatŋe miawagep aregât nekmâ nanne bo dâwen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hain dâmbo eweŋande âmâ âi luâklupŋe hin dâm makyeŋgiep, “Dowâk sâŋgum kâlep are mem ga luguaŋbiâ geâk. Akto donet siâ baraganŋân katŋet. Akto kei pekeŋe luguaŋet. ");
INSERT INTO tim_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Akto bulimakao nanŋe keluŋe olowâk are gâim ombiâ ondo nem heroŋe akne. ");
INSERT INTO tim_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nanne emelâk moep dân ina togoâp. Emelâk gulip aguep dân ina miawakmâ togoâp.” dâmbo heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Hain akmâ tatbiâ nanŋe ulik gulik arekŋe âiângen malepgât purik katmâ togom kepia ginŋân kinmâ heroŋe maroŋe giriŋ gegek kep keŋgu akbiâ nâŋgâm ");
INSERT INTO tim_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","âi luâk siâ kondo gembo hin dâm aikoep, “Heroŋe maroŋe âure wangât akmâ tatâi?” ");
INSERT INTO tim_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","dâm aikombo hin dâep, “Emige gulip aguep dâyion ina togombo aregât eweyetŋande dâmbo bulimakao nanŋe kelurâk are kom ondenŋe om kindo heroŋe aktâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hain dâm magaŋdo nanŋe ulik gulik arekŋe kuk akmâ kepia ain âgâwerâm hâkâŋ agep. Akto eweŋande kepia ginŋângen gem, “Gâ ga.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Magaŋdo nâŋgâm hansumbu akmâ hin magep, “Nâŋe âi luâkgande hin hombaŋ dondâ âi ketugu giŋmâ den bo koŋgiŋmâ gan. Akto nâniŋ nanŋe siâ bo niŋmenâ galalupne olop nem heroŋe agion. ");
INSERT INTO tim_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Akto nangande gâŋgât tâk puli aregât ukenŋe nâŋgâm mem arim âmbâle kondarâ olop manmâ panmâ metiep ina togoâp yâkgât makmenâ makao nanŋe kelurâ are kom gâim ombiâ nâŋgâre bâliâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hain dâmbo eweŋande hin dâm magaŋep, “Nanne, gâmâ nâ olop sop kâlep manmâ gamat aregât nâŋeân kotŋe siâ siâ tatâp are hârok gâŋgât pat aktâp. ");
INSERT INTO tim_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dâ emige emelâk moep dâman ina togoâp. Akto emelâk gulip aguep dâman ina togoâp. Aregât heroŋe akmâ okot âlep agaŋdenŋe ârândâŋ aktâp.” dâep.” ");
INSERT INTO tim_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuŋe Aposololupŋe den ginŋe siâ hin dâm makyeŋgiep, “Luâk humo sikumdâ siâ malep yâkgât tâwât dewunŋe akto sâŋgum me kotŋe siâ siâ aregât damunŋe malep. Aregât den hâkŋe tunmâ hin dâm magaŋi, “Gâŋgât hoŋ bawa âige damunŋe akmap arekŋe tâwât dewunŋe siâ siâ mem hanâk hanâk ketugumap.” ");
INSERT INTO tim_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hain dâmbiâ mem oloŋmâ dâep, “Gâŋgât hâkge tunbiâ nâŋgân. Hainâk damun lâuwâŋe bo meŋgektere hepunbiat aregât puligo puligo kulem esenŋe are mem gamenâ tâwât dewunŋe siâ siâ yeŋgât keiŋe mem miawakbe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hain dâmbo arim damunŋe biwiŋân hin nâŋgâep, “O luâk humonande wat nekbiap aregât gain akbe? Âi ketugum kâmetbiangât hâkâŋ aktân. Akto hokboâk hokboâk ulilaŋdere nekbiâ aŋun aŋgiman. ");
INSERT INTO tim_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hinŋe nâŋgân. Galalupne mem gala katyekmâ mem heroŋe maroŋe katyektere luâk humonande watnekto âmâ emetyeŋân oloŋnekbiâ olowâk manbaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hain nâŋgâm luâk humoŋaet tâwât dewunŋe siâ siâ dosa agaŋmâ mem mali aregât ikiŋeâk ikiŋeâk mem oloŋyegep. Hain akto togombiâ aiyeŋgum dâep, ");
INSERT INTO tim_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Gâŋgât dosa humogâlân amon tatâp?” dâmbo lâwin keluŋaet dop 100 dâep. Hain dâmbo hin dâep, “Âlepŋe 50 âk niŋben.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hain dâm siâkâ aikoep, “Luâk humogâlân dosa amon tatâp?” dâmbo, “Saŋ saŋ koaŋe are ito 100.” dâmbo dâep, “Âlepŋe 80 âk niŋben.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hain dâmbo luâk humoŋande nâŋgâm damunŋe are hin magaŋep, “Gâŋgât nâŋgâ nâŋgâge humo aregât nâŋgâre biwine âlepŋe aktâp.” humoŋe hain dâep. Wangât? Hingât. Anutugât den bo lokomai bikŋande tâk puliyeŋe damungom galalupyeŋe heyeŋgimai aregât nâŋgâ nâŋgâyeŋe humo tatâp yeŋe âmâ Anutugât den lokomai ewangi yektâi. ");
INSERT INTO tim_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Haingât ire maktere nâŋgâŋet. Yeŋe hainâk tâk puli me wan me wan mem manmâ are gala akyeŋgim âmâ hâmbâi umatŋe miawak yeŋgiwiap sop ain yâk yeŋgâlân arim kepia tatmâ âgâwiap ain manbai. ");
INSERT INTO tim_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Luâk siâŋe wan me wan owâiŋe damungom biwiŋande lokom manmapŋe âmâ tâwât dewunŋe wan me wan bunŋe are hainâk biwiŋande lokom damungomap. Gârâmâ luâk siâŋe wan me wan hanâk damungom hilipkomapŋe âmâ tâwât dewunŋe wan me wan bunŋe are hainâk hanâk damungom hilipkowiap. ");
INSERT INTO tim_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Haingât yeŋe tâwât dewunŋe me wan me wan hângât egâliaŋ are biwiyeŋande bo lokom manbiâ âmâ wan me wan bunŋe hâmbâi bo yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Akto humo yeŋaet puli me wan me wan bo damun akmâ heŋgemgombiâ aregât âigât hâuŋe bo yeŋgim heŋgemgowiap. ");
INSERT INTO tim_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Akto aregât siâ makbe. Nanaŋ konokŋe luâk kembu lâuwâ yetgât hoŋ âlepŋe bo akyetkiwiap. Wangât? Hingât. Siâgât lau lokoaŋmâ benŋe siâgât lau bo lokoaŋbiap. Akto siâgâlân purik katmâ siâgâlân hâkâŋ akmâ hamiaŋbiap. Aregât Anutugât lau lokowerâm âmâ puligât nâŋgâmbiâ humo bo akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesuŋe hain dâmbo Parisaioŋe tâwât dewunŋe aregât ukenŋe nâŋgâmbiâ âgâep aregât Yesuŋe den magep are nâŋgâm âmâ hâkâŋ akmâ dewunŋân geyi. ");
INSERT INTO tim_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dewunŋân gembiâ makyeŋgiep, “Yeŋe âmâ tek tekŋân manmâ luâk âmbâleŋe nenekmâ egâliaŋŋet dâmai. Dâ Anutuŋe âmâ biwiyeŋaet keiŋe nâŋgâp. Wan me wan siâ siâ ekbiâ âlepŋe akmap are âmâ Anutuŋe ekto bâlimap. ");
INSERT INTO tim_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Akto siâ maktere nâŋgâŋet. Mosegât den kârikŋe akto Anutugât den kulemgom gayi den are kârikŋe tatmâ gam gam Yohanegâlân bunŋe miawagep. Miawakto aregât kakŋân Anutuŋe damun nenŋe akberâm aktâp aregât den pat âlepŋe hauŋmâ arimbo nâŋgâmbiâ biwiyeŋe pagalembo aregât bunŋe memberâm akmâ âi humo mem wârakmâ âgâwai. ");
INSERT INTO tim_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Himbim hân haru are âmâ gulip akbiandatgât dopŋe tatâp. Gârâmâ Mosegât den kârikŋe are dowâk gulip akbiapgât dopŋe bo tatâp. ");
INSERT INTO tim_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Akto siâ maktere nâŋgâŋet. Luâk siâŋe âmbenŋe hepunmâ aŋgâ membiapŋe âmâ dosa umatŋe membiap. Akto luâk siâŋe âmbenŋe wato bam mando siâŋe mem âmâ dosa olowâk manbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Akto Yesuŋe den siâ hin makyeŋgiep, “Luâk humo siâ malepŋe tâwât dewunŋe humo mem hâk pekeŋe âlep âlep puligom mem malep. Manmâ hilâmŋe hilâmŋe sot keiŋe keiŋe om nem unsambe malep. ");
INSERT INTO tim_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hain manmâ luâk siâ umburuk malep kotŋe Lasaro mando diwi kârikŋe miawagaŋdo hâkŋe diwiâk hârok agep. Hain akmâ betgen yem manminep. ");
INSERT INTO tim_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Hain akmâ luâk humoŋe emelanba manmâ sot nendo gagapŋe gembo are nemberâm akminep. Hain akto duaŋe togom diwiŋe elewelaŋmâ mali. ");
INSERT INTO tim_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Akto manmâ umburuk are mondo aŋeloŋe oloŋmâ âgâm Abrahamgât okotŋân katbiâ malep. Akto kakŋân luâk kotdâ are mondo hangoyi. ");
INSERT INTO tim_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hangombiâ mom kâlâwân gem âmâ hâk hilâlâm humo nâŋgâm manmâ hâkŋângen Abraham akto Lasaro yelegep. ");
INSERT INTO tim_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yelekmâ hin dâm Abraham magaŋep, “Apo, kâlâp bâleŋân tatmâ hâk hilâlâm bâleŋe nâŋgâm mandân aregât okot nâŋgâm Lasaro magaŋmenâ bâtŋe pikŋân tu katmâ gutmâ elewetnân howaimbo getek sândugeâk.” Hain dâmbo ");
INSERT INTO tim_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamŋe dâep, “Gala, gâ nâŋgât. Hânân ukenŋe akto heroŋe humo kakŋân malen aregât sop bo agep. Lasaro yâgâmâ okot bâle kakŋân malep are hainâk bo agaŋep. Aregât biwiŋe heroŋe mandâp. Dâ gâmâ hâk hilâlâm humo nâŋgâmâk mandât. ");
INSERT INTO tim_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Akto hut nenŋân hemem humo kindâp aregât in gâtŋande yeŋgâlân gewaigât dopŋe bo. Akto yeŋgâlân gâtŋande nengâlân gawerâm hainâk ewum pâpkowiap.” ");
INSERT INTO tim_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hain dâmbo luâk kâlâwân talep arekŋe hin dâep, “Apo, siâ maktere nâŋgâ. ");
INSERT INTO tim_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Lasaro huŋgunaŋmenâ ewenaet emelan ariâk. Kepianân emilupne momerâk mandâiŋe hâk hilâlâm iren togowâigât Lasaro huŋgun aŋmenâ aregât den kârikŋe makyeŋgimbo nâŋgâ nâŋgâyeŋe pâroŋ dâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hain dâm makto Abrahamŋe hin magaŋep, “Bo, Moseŋe den kârikŋe kulemgoep are tatâp. Akto Anutuŋe den makyeŋgimbo propetelupŋande kulemgoyi are tatâp are oyaŋmâ nâŋgâŋet.” ");
INSERT INTO tim_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","dâmbo dâep, “Apo, hain bo. Moyi yâk yeŋgâlân gâtŋe siâŋe arim makyeŋgimbo âmâ agak memeyeŋe bâleŋe Anutugâlân makmâ âmâ han biwiyeŋe purik katmâ manbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Hain dâmbo hin dâep, “Mosegât akto propete yeŋgât den are oyaŋmâ nâŋgâm hâkâŋ akmai aregât moyi yâk yeŋgâlân gâtŋande arim makyeŋgimbo hainâk den are hâkâŋ akbai.” dâep.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuŋe hoŋ bawalupŋe den siâ hin dâm makyeŋgiep, “Niambiŋe ye hârok dop yeŋguwerâm biwiyeŋân gemap aregât dop tatâp. Gârâmâ luâk siâŋe Niambi gala agaŋmâ luâk siâ ekmâ bâleŋe ak dâmap are Anutuŋe hâuŋe humo waŋbiap. ");
INSERT INTO tim_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gârâmâ luâk siâŋe nanaŋ siâ ekmâ bâleŋe ak dâmbo are siâŋe kât humo dondâ hanŋân imbogoaŋmâ haru bâtgumân hâkokombo dâine arekŋe âmâ siâ me siâ owâiŋe miawagaŋbop. ");
INSERT INTO tim_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aregât biwiyeŋe pâlâmŋe bo agâk. Akto siâ makbe. Galage siâŋe bâleŋe akto âmâ sami magaŋbiat, “Bâleŋe akniŋdât aregât dâm makniŋmenâ dosage are bo akberâp.” dâmenâ hain akto gala konok akbiandat. ");
INSERT INTO tim_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Akto hilâm konok aregât kâlegen bâleŋe akgiŋmâ dosa are makmâ miawakmâ arim nâmbulân lâuwâŋe hain dâm miawakmâ âmâ hin dâm makgiŋbiap, “Gala hain akgiŋdângât biwine bâliâp.” Hain makgiŋdo gâkâ hainâk, “Âlepŋe, are bo aktâp.” dâm gala agaŋbiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hain dâmbo aposololupŋande hin dâm ulilaŋi, “Humo, gâ nâŋgâ nâŋgânenŋe mem sambelem nengiwen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hain dâmbiâ Kembuŋe hin dâm makyeŋgiep, “Nâŋgâ nâŋgâyeŋe bunŋe bâlensiâ dondâ dâwok koaŋe hinare yeyeŋgimbo dâine âmâ lâwin indâre petakmâ haruân gem kilâkgât magaŋbiâ âmâ lauyeŋe lokom hain akbop. ");
INSERT INTO tim_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yeŋgâlân gâtŋe siâŋe hoŋ bawa âi ketugum bulimakao damunŋe mando emet dâgâmbo guto âmâ ain hin dâm magaŋbiat me? “Emetgân âgâ tatmenâ sot om giŋbe.” ");
INSERT INTO tim_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hain bo dâwiat. Hin dâm magaŋbiat, “Letge konok areâk latmâ tatmâ sot om niŋmenâ nendere hâmbâi âmâ guge om nembiat.” dâwiat. ");
INSERT INTO tim_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Haingât keiŋe hin. Gâŋe hoŋ bawa âi dâm waŋen are ketugumbo gâŋe bo mepaiŋe membiat. Yân nâŋgaŋmenâ ârândâŋ akbiap. Akto aregât hin maktere nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yeŋgât keiyeŋe âkâ hainâk tatâp. Âi makmâ yeŋgire are ketugum metem âmâ hin dâwi, “Nen hoŋ bawa yânŋe akmâ manden. Âi makmâ nengiep are konok mem metien.” dâmbiâ ârândâŋ akbiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuŋe Yerusalem kipian ariwerâm âmâ Galilaia hân ewangim Samaria hân hâlâŋmâ kipia bâiŋângenba ariep. ");
INSERT INTO tim_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Arim kipia ginŋân âgâmbo luâk 10 hâk bâle miawak yeŋgiep arekŋe ekmâ âmâ kâlewângen kinmâ hin dâm konmâ magaŋi, ");
INSERT INTO tim_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Woa, luâk humo Yesu, gâ nengât okot nâŋgâ.” ");
INSERT INTO tim_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","dâm konmâ magaŋbiâ yekmâ âmâ hin makyeŋgiep, “Sumbe kat kat luâk are yeŋgât damunŋande yekbaigât yâk yeŋgâlân ariŋet.” dâm makyeŋgimbo arim manbiâ hâkyeŋe are dâwân âlepŋe akmâ metiep. ");
INSERT INTO tim_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hain akto yâk yeŋgâlân gâtŋe konokŋe egakto hâkŋe âlepŋe akto aregât purik katmâ togoep. Togom kârikŋe akmâ Anutu maŋganlep. ");
INSERT INTO tim_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Maŋganmâ Yesugât enemŋân togo keiŋân ge yem âmâ heroŋe akmâ maŋganlep. ");
INSERT INTO tim_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Akto luâk are Samaria hânân gâtŋe aregât Yesuŋe hin dâep, “Luâk 10 âlepŋe aktâi are 9 âmâ yâgâten? ");
INSERT INTO tim_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yâkŋe âmâ arim nâŋgâm ondop kârik akmâ yân manbiâ luâk lombo konokŋe togom Anutugât mepaiŋe mendâp.” ");
INSERT INTO tim_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hain dâm luâk are hin dâm magaŋep, “Biwige nâŋgâlân katâp aregât Anutuŋe nâŋgâ giŋdo âlepŋe aktât aregât arim biwige sândugeâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sop hain Parisaio luâk bikŋande Yesu aikom hin dâyi, “Sop amuten Anutuŋe miawakmâ damun nenŋe akbiap?” dâyi. Hain dâmbiâ hin makyeŋgiep, “Anutuŋe damunyeŋe akbiap ain kulem keiŋe keiŋe bo miawakto ekbai. ");
INSERT INTO tim_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aregât hin bo dâŋet, “In miawaktâp, me indâgen miawaktâp.” hain bo dâŋet. Nâŋgâi. Anutuŋe damunyeŋe emelâk akberâm aktâpgât pat âmâ hutyeŋân mandâp ire.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hain dâm kinmâ Aposololupŋe hin dâm makyeŋgiep, “Hâmbâi sop siân umatŋe miawak yeŋgimbo ain ye hin dâwai, “Wei, luâk akmâ giep yâkgât sop siâ ekne.” dâm nâŋgâmbiâ humo akbiap. Ain bo miawakto ekbai. ");
INSERT INTO tim_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Akto sop ain luâk bikŋande nâŋgâ yâkgât hin dâm makyeŋgiwai, “Aregen miawaktâp me iregen nengâlân miawaktâp.” dâmbiâ aregen bo ariwi. Akto are nâŋgâmbiâ bunŋe bo akbiâp. ");
INSERT INTO tim_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","25","Akto hâk hilâlâm humo nâŋgâre âmâ luâk dondâŋe haminiŋmâ hâk hilâlâm niŋbai. Hain akbiâ aregât hamiŋân mem belek akmâ himbim bikŋe belek dâmbo âmâ bikŋe bikŋe arimap, aregât dop akmâ luâk akmâ geân lâuwâŋe gem miawaktere luâk âmbâle hârokŋe nekbai. ");
INSERT INTO tim_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Akto ire maktere nâŋgâŋet. Ulikŋân luâk siâ kotŋe Noa, yâk malep sop ain âmâ hin areâk akmâ mali hainâk nâŋgât sop humo tâlâgumbo ain hainâk akbai. ");
INSERT INTO tim_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Emelâk âmâ sot soŋgo neyi. Akto âmbâle mem luâk mem agi. Hain akmâ manbiâ aregât purikŋe Noaŋe yekmâ waŋgan âgâmbo tânâk humo giep. Tânâk humo gembo ugurupŋe humo togom âmâ luâk âmbâle hânân mali are hârok kawut yekmâ metiep. ");
INSERT INTO tim_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Akto aregât hamiŋân luâk siâ kotŋe Loti, yâk malep sop ain âkâ hainâk agi. Sot soŋgo akto tu neyi. Akto kotŋe siâ siâ are mem aŋgi goaŋgi agi. Akto âi kalam kâmetmâ siâ siâ agi. Akto emet opmân ketuguyi. ");
INSERT INTO tim_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hain akmâ manbiâ sop ain Lotiŋe Sodom kipia hepundo himbimânba kâlâp humo gem kipia ambolupŋe hârogâk om meteyegep. ");
INSERT INTO tim_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Gârâmâ nâ luâk akmâ geân purik katbian sop ain âkâ dop hainâk miawakbiap. ");
INSERT INTO tim_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Akto sop humoân luâk siâ kipia sombeimân kinbiap arekŋe emetŋân âgâm kotŋe siâ siâ bo meakbiap. Akto siâ âiângen manbiap arekŋe kipian bo purik katbiap. Hain bo akbi. Dowâk pârigim ariwi. ");
INSERT INTO tim_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotigât âmbenŋaet pat nâŋgâm heŋgemgowi. ");
INSERT INTO tim_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aregât keiŋe hin. Luâk siâŋe manmanŋe gangerâwiap arekŋe âmâ hilip aguwiap. Dâ siâ manmanŋe hepunbiap arekŋe âmâ âlepŋe tatbiap. ");
INSERT INTO tim_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Maktere nâŋgâŋet. Sop ain luâk lâuwâ akmâ opmân konogân yembiandat. Yembela are siâ mem siâ âmâ hepunbiap. ");
INSERT INTO tim_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akto âmbâle lâuwâŋe sot gâim tatbiandat. Tatbela siâ mem siâ âmâ bo membiap. ");
INSERT INTO tim_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Akto luâk lâuwâ âiân kinbela âmâ siâ mem siâ âmâ hepunbiap.” Yesuŋe den hain dâmbo aposololupŋande aikom hin dâyi, ");
INSERT INTO tim_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“Humo, yâgâten miawakbiap?” dâmbiâ hin makyeŋgiep, “Siâ siâ momoŋe yembiâ ain liplipŋe neyekberâm togomai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuŋe konam bo akmâ âmâ hilâm ârândâŋ Anutu olop den akmâ manŋet dâm aregât den ginŋe siâ hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Kiap siâŋe den âiân katyekmâ malep. Hain akmâ manmâ Anutugât den bo lokom âmâ bo hamewagep arekŋe luâk âmbâle yekmâ yâk yeŋgât nâŋgâmbo gegeŋe akto malep. ");
INSERT INTO tim_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hain akmâ mando kipia ain âmbâle kambut siâ malep. Manmâ hilâmŋe hilâmŋe kiap aregâlân arim hin dâm magaŋmâ malep, “Gasanande hilip nuguwerâm aktâp aregât gala akniŋmâ tân nugu.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Hain dâmbo kiap arekŋe âmbâle kambut aregât den are hâkâŋ akmâ nâŋgâm pâlâmŋe akmâ malep. Mando sop kâlep akto biwiŋande hin nâŋgâep, “Nâŋe Anutugât den bo lokom bo hamewaktân luâk âmbâle are yeŋgât nâŋgâre gemap are bunŋe. ");
INSERT INTO tim_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Gârâmâ âmbâle kambut arekŋe hilâm ârândâŋ den makniŋmap aregât biwinande hâkâŋ akmap. Dâ uŋak âmâ hanâk tângowe.” dâep.” ");
INSERT INTO tim_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aregât Yesu Humoŋe den dewatim hin dâep, “Kiap den kokoŋe hain dâepgât nâŋgâm heŋgemgowi. ");
INSERT INTO tim_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gârâmâ Anutuŋe âmâ luâk bikŋe oloŋyekto hilâm ârândâŋ ulilaŋbiâ dowâk tân yeŋgum gasalupyeŋe den âiân katyekbiap. Hâkâŋ akmâ bo tân yeŋguwiapgât dopŋe bo tatâp. Bo kârikŋe. ");
INSERT INTO tim_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Manmâ kâlep bo akto dowâk tân yeŋgum gasalupyeŋe den âiân katyekbiap. Hain gârâmâ Anutuŋe huŋgun niŋdo geân nâŋe hâmbâi lâuwâŋe gem luâk âmbâle siâŋe biwiyeŋe nâŋgâlân katmâ manmai are mem miawakyekbian mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Luâk bikŋande yeŋaet nâŋgâmbiâ âlepŋe akto galalupyeŋe yeŋgât nâŋgâmbiâ gemap are yeŋgât nâŋgâm Yesuŋe den ginŋe siâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Luâk lâuwâ siâ sumbe emetŋân âgâm Anutu den dâm magaŋiat siâ âmâ Parisaio, dâ siâ âmâ puli meme luâk. ");
INSERT INTO tim_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Akto Parisaio luâk arekŋe âmâ ikiŋaet nâŋgâmbo agato bin binâk kinmâ hin dâep, “O Anutu, âlepŋân kat nekmenâ ârândâŋ agep. Akto luâk bikŋande kâmbu akmâ bâleŋe siâ siâ akmai. Dâ nâmâ hainare bo. Akto nâ puli meme luâk iŋgon yu kindâp arekŋe bâleŋe akmap hainare bo akman. Nâ mandere nekmenâ ârândâŋ akmap aregât gâŋe âlepŋe akniŋdât dâm mepaige mendân. ");
INSERT INTO tim_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Akto hilâm lâuwâ kâlegen gâŋgât kambiamge âlepŋe agâk dâm sot bâlâk manman. Akto tâk puli kotŋe siâ siâ are hutŋânba konok âmâ gâŋgât pat dâm katman.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hain dâmbo puli meme luâk are iŋgon aŋgângen kinmâ aŋun aŋgim kâŋgom hin dâep, “O Anutu, nâ luâk bâleŋe mandân gârâmâ hanâk bo hepun nekben.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aregât keiŋe hin makyeŋgire nâŋgâŋet. Anutuŋe puli meme aregât âmâ dosaŋe puliaŋdo purik katmâ ariep. Dâ Parisaio are âmâ dosaŋe hainâk talaŋep. Akto aregât hin nâŋgâŋet. Luâk siâŋe ikiŋe kotŋe mem agato Anutuŋe mem ge katbiap. Dâ luâk siâŋe ikiŋe kotŋe mem gembo âmâ Anutuŋe mem agatbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Luâk âmbâle bikŋande nanaŋlupyeŋe kewuguyekmâ Yesugâlân togom meyegâk dâmbiâ hoŋ bawalupŋande sârek yeŋguyi. ");
INSERT INTO tim_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sârek yeŋgumbiâ Yesuŋe mem oloŋyekmâ hin dâep, “Hepunbiâ nanaŋlupyeŋe are nâŋgâlân gaŋet. Hain arekŋe Anutugât kâmolân gâtŋe aregât bo mem gangerâ yekŋet. ");
INSERT INTO tim_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aregât bunŋe maktere nâŋgâŋet. Nanaŋlupyeŋande dowâk Anutugât den lokom biwiyeŋe yâkgâlân katmai. Gârâmâ siâŋe hain bo akbiap âmâ Anutuŋe bo meyekbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Akto damun siâŋe Yesu aikom hin dâep, “Luâk humo âlepŋe amboŋe aktât. Aregât maktere nâŋgâ. Kârikŋe manmâ âgâwiangât gain gain akbian nâŋgât?” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","hin magaŋep, “Âlepŋe amboŋe âmâ Anutu konok. Gârâmâ âlepŋe amboŋe dâm makniŋdât aregât nâŋgâm mak makgaet damun akmâ manben. ");
INSERT INTO tim_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Akto ainuguât aregât keiŋe makgiŋbe. Den kârikŋe nâŋgâmat amâ hin. Âmbâle siâ ekmâ egâliaŋ bo akben. Akto luâk siâ moâk dâm bo komben. Kâmbu bo memben. Den bo hiaŋgiwen. Ewege memegande den makbela loko yetkiwen.” ");
INSERT INTO tim_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hain dâmbo hin magaŋep, “Ya maktât are âmâ nanaŋânbak den kârikŋe âlepŋeâk lokom gam yu mandân.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuŋe den are nâŋgâepgât hin magaŋep, “Konok tatâp are âmâ hin akben. Arim âmâ puli me ito sikum me wan me wan are oyaŋmâ luâk umburuk mandâi are yeŋgiwen. Hain akmâ âmâ nâŋgâlân lâuwâŋe togomenâ nâ olop âi ketugum manbaet. Hain akbiat âmâ himbimân aregât hâuŋe miawak giŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hain dâmbo puli me ito sikum siâ siâŋe dondâ talaŋep aregât den are dâmbo nâŋgâmbo umatŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hain akmâ kambiamŋe bâlimbo Yesuŋe ekmâ hin dâm magep, “Luâk âmbâle puli me ito sikum me wan me wan olowâkŋe Anutugât den lokom manberâm akbiâ âmâ umatŋe miawak yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Akto aregât hin makbe. Soŋgo piki dâpŋânba ariwiapgât dop bo tatâp. Are âmâ luâk kotŋe siâ siâ talaŋdâp arekŋe Anutuŋe damunŋe akbiawân ain ariwerâm akmâ hainâk hâumgowiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hain dâmbo âmâ nâŋgâm kiliŋe hin dâyi, “Niŋe himbimân âgâwiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hain dâmbiâ hin makyeŋgiep, “Are âmâ han yeŋeâk âgâwerâm aregât ewum hâumgomai. Anutuŋe âmâ dâp hainare mem miawakberâm aregât bo pâpkomap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hain dâmbo Petoroŋe agatmâ hin magaŋep, “Nâŋgât, kotŋe siâ siâ hârok hepunmâ metem nen gâŋgâlân purik katmâ malion akto manmâ gaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hain dâmbo Yesuŋe hin makyeŋgiep, “Luâk siâŋe Anutugât âi ketuguwerâm akmâ âmâ emetŋe me âmbenŋe me emiŋe gariŋe me eweŋe memeŋe, me ginbailupŋe hanâk hepun yekbiap ");
INSERT INTO tim_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","are âmâ sop uŋak ire gala agaŋmâ tângowerân. Tângore âmâ hinŋe wan me wan dondâ miawakberâp. Akto titnan sop humoân âmâ tângore dondâ sambelem âgâwiap akto manman kârikŋân manmâ âgâwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuŋe Aposololupŋe mem oloŋyekmâ hin dâm makyeŋgiep, “Maktere nâŋgâŋet. Yerusalem kipian âgâwerâm akten. Gârâmâ âgâenŋe âmâ luâk akmâ geân nâŋgât den makmâ miawakto kulemgoyi are bunŋe akberâp. ");
INSERT INTO tim_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Roma luâkŋe menekmâ nugum mem ge katnekmâ siâ siâ akniŋmâ âmâ tâwut nuguwai. ");
INSERT INTO tim_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Akto tâk metŋe arekŋe mem orenekmâ nugumbiâ mombian. Mondere hilâm âlâwu bo akto âmâ momoŋânba agatbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hain dâmbo nâŋgâmbiâ ârândâŋ bo akto keiŋe nâŋgâwerâm akbiâ dâp bo akto âmâ bo nâŋgâm heŋgemgoyi. ");
INSERT INTO tim_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu arimbo Yeriko kipia are tâlâguep. Hain akmâ dâp ginŋân luâk siâ dewunŋe bokbokŋe siâ puligât ulit yeŋgim talep. ");
INSERT INTO tim_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hain akmâ tato luâk kâmot humoŋe dâp hainâk arimbiâ keiyeŋe munŋe nâŋgâm aregât aiyeŋgumbo hin dâyi, ");
INSERT INTO tim_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Yesu Nasarete kipian gâtŋe togoâp.” ");
INSERT INTO tim_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","dâmbiâ nâŋgâm kârikŋeâk konmâ hin dâep, “Woa, Yesu, gâ Dawidigât kâmolân gâtŋe, aregât okot nâŋgâ niŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hain dâmbo luâk ulik gulik ariyi arekŋe den are nâŋgâm den hepun dâm magaŋi. Hain magaŋbiâ den are koyeŋgim kârikŋeâk dondâ konmâ hin dâep, “Dawidigât kâmolân gâtŋe, aregât okot nâŋgâ niŋ.” dâm kolep. ");
INSERT INTO tim_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hain dâmbo Yesuŋe nâŋgâm âmâ dâwân kinmâ hin dâep, “Kewugum nâŋgâlân gaŋet.” dâep. Hain dâmbo dewunŋe bok bokŋe arekŋe yâkgâlân gambo ");
INSERT INTO tim_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","aikom hin dâep, “Gain gain akgiŋbegât nâŋgâm aregât nogondât?” dâmbo hin dâep, “O humo, dewunne hulaŋ akto emet ekbegât nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hain dâmbo Yesuŋe hin magaŋep, “Biwige nâŋgâlân katât aregât âlepŋe ek.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ainâk dewunŋe hulaŋ akto emet egep. Ekmâ âmâ Yesugât hamiŋân arim Anutu maŋganlep. Akto luâk bikŋe are egi aregât hainâk Anutugât kotŋe mem agali. ");
INSERT INTO tim_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu Yeriko kipian arim ewangiwerâm agep. ");
INSERT INTO tim_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hain akto kipia ain luâk tâlâwâk siâ malep kotŋe Sakaio. Arekŋe puli meme yeŋgât luâk humo agep aregât yâkgât puli me ito sikum dondâ talaŋep. ");
INSERT INTO tim_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Akto Sakaioŋe Yesu ekberâm agep. Ekberâm akmâ âmâ luâk tâlâwâkgât luâk hutyeŋân kinmâ gain gain akmâ ekbe dâm kâleleim agato bo agep. ");
INSERT INTO tim_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hain akmâ pârigim ewangiyekmâ arim lâwin siâ lokom lokom âgâm kinmâ hin nâŋgâep, “Yesu in gutmâ arimbo ekberân.” ");
INSERT INTO tim_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hain nâŋgâm kindo Yesuŋe ain togom dewunŋe panmâ egon ekmâ hin dâm magaŋep, “Sakaio, nâ gâŋgât emelan âgâ tatberâm nâŋgân aregât dowâk sopanmâ ge.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hain dâmbo ainâk sopanmâ gem biwiŋe heroŋe agep. Hain akmâ emetŋân oloŋmâ âgâep. ");
INSERT INTO tim_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oloŋmâ âgâmbo luâk hârokŋe ekmâ nâŋgâmbiâ bâlimbo hin dâyi, “Gain gaingât luâk bâleŋaet emelan âgâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Akto Sakaioŋe Yesugât enemŋân ba kinmâ hin dâep, “Humo, nâŋgât puli me kotŋe siâ siâ are dopŋe konogâk mem potatmâ luâk umburuk mandâi are yeŋgiwian. Akto luâk âmbâle yeŋgât puli are heyeŋgim meyeŋgiân hainâk mem agatmâ emelâk konok yeŋgiân aregât hâuŋe imbât yeŋgim metewian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hain dâmbo Yesuŋe hin magaŋep, “Gâ Abrahamgât kâmolân gâtŋe bunŋe. Anutuŋe gala akgiŋmâ damunge aktâp are nâŋgâm ektân. ");
INSERT INTO tim_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Akto nâ luâk akmâ gem miawakmâ luâk bâleŋande hilip yeŋguwâigât meyekmâ himbimgât pat katyekberâm aregât geân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu olowâk arimbiâ Yerusalem kipia are tâlâgumbo âmâ denŋe nâŋgâyiŋe hin dâyi, “Anutuŋe damun nenŋe akbiap aregât sopŋe tâlâguâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hain dâmbiâ aregât Yesuŋe den ginŋe siâ hin dâm makyeŋgiep, “Luâk kotdâ siâŋe luâk kotdâ siâgâlân ariwerâm âmâ ikiŋaet hin nâŋgâep, “Damunyeŋe katnekbiap aregât arim benŋe togowian.” hain nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akto ariwerâm âmâ hoŋ bawalupŋe bât bip bip hârok yeŋgondo togombiâ puli koaŋe humo konok konok yeŋgim hin dâm makyeŋgiep, “Puli irekŋe âi ketugum puli mem sambe ketugumbiâ hâmbâi purik katmâ togom ekbian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hain dâm kâlewângen arimbo luâk âmbâle bikŋande hâkâŋ akmâ âmâ luâk hoŋ bawa siâ huŋgun aŋbiâ luâk kotdâ aregâlân arim hin magaŋep, “Gâŋe damun nenŋe bo manbiat dâmbiâ aregât togoân.” ");
INSERT INTO tim_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hain dâmbo yâkgât luâk kotdâ arekŋe hân damunŋe malâkgât kato purik katmâ togoep. Togom âmâ hoŋ bawalupŋe puli yeŋgiep are yeŋgondo gembiâ hin dâm makyeŋgiep, “Puli yeŋgiân arekŋe âi ketugumbiâ amon miawagep?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hain dâmbo hoŋ bawa siâŋe hin dâep, “Luâk kotdâ, gâŋe puli konok niŋen arekŋe âi ketugure puli koaŋe 10 hain miawagep.” ");
INSERT INTO tim_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","dâmbo hin dâep, “Âlepŋe hoŋ bawane kotŋe siâ siâ âiŋe âlepŋeâk ketuguengât nâŋe kipia bât bip bip hârok are yeŋgât damun kat gektere manbiat.” ");
INSERT INTO tim_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hain dâmbo benŋe hoŋ bawa siâŋe gam hin dâep, “Luâk kotdâ, gâŋe puli koaŋe konok niŋen arekŋe âi ketugure koaŋe momerâk miawagep.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","hin dâep, “Âlepŋe arim âmâ kipia momerâk are yeŋgât damun manben.” ");
INSERT INTO tim_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hain dâmbo benŋe hoŋ bawa siâŋe âmâ gam hin dâep, “Gâŋe puli koaŋe konok ire niŋen a ainâk sâŋgumnande katipkom katere tatmap. ");
INSERT INTO tim_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gâ luâk heŋgân gugak kotŋe siâ siâ bo mem oloŋmenâ âmâ bikŋande mem miawakmai are yeŋgât memberâm aregât ukenŋe akmat. Akto gugak âi bo kâmetmat. Bikŋande âi kalam ketugumbiâ bunŋe miawakto nemberâm aregâlâk mârum tatmat. Hain akmat aregât puli niŋen ire heambukbop dâm sâŋgumnande katipkom katere tatmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Hain dâmbo hin dâep, “Gâmâ hoŋ bawa bâleŋe dondâ. Gugak den maktât aregât keige mem miawakbe. Nunak kotŋe siâ siâ bo mem oloŋdere âmâ bikŋande mem miawakbiâ are membe dâman. Akto nunak are bo kâmetmâ bikŋande kâmetbiâ bunŋe miawakto âmâ nembe dâman a nâŋgât. ");
INSERT INTO tim_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Keine hain nâŋgâm puli giŋân are luâk yeŋgâlân kalen dâine âi ketugumbiâ sambelembo membom ina gâŋe are bo agen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hain dâm magaŋmâ luâk âmbâle kili are hin makyeŋgiep, “Puli waŋân are bâtŋânba mem âgâ luâk 10 mendâp are waŋŋet.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","hin dâyi, “Hain bo. Yâk emelâk 10 mendâp aten.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aregât hin makyeŋgire nâŋgâŋet. Luâk siâ kotŋe siâ siâ talaŋdâp are mem humo ketugumbo are âmâ purik katmâ waŋbian. Akto luâk siâ kotŋe siâ siâ talaŋbiap are biwiŋande bo lokom manbiap are âmâ keŋgoŋmâ membian. Mendere yân manbiap. ");
INSERT INTO tim_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Akto gasalupnande nâŋgâ yâkgât luâk kotdânenŋe bo malâk dâm magi yâk meyekmâ nâŋgâlân gambiâ yektere yeŋgumbiâ moŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuŋe den are makmâ metem luâk âmbâle kâmot humo are hepun yekmâ Yerusalem kipian âgâwerâm ariep. ");
INSERT INTO tim_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Arim Oliwa gimbâŋân âgâm âmâ Betepage akto Betania kipia lâuwâ are talewân ariep. Arim Aposolo lâuwâ hin dâm huŋgun yetkiep, ");
INSERT INTO tim_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kipia indâre tatâp ain ariet. Arim âmâ doŋgi kâmŋe siâ luâkŋe kakŋân bo tatmai are tâkŋe hikombiâ kindâp are mem miawakberat. Mem miawakmâ hulaŋmâ mem oloŋmâ togoet. ");
INSERT INTO tim_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Hulaŋbela âmâ luâk siâŋe, “Wangât hulaŋdat?” dâm aiyetkumbo âmâ hin dâm magaŋberat, Humoŋe iregât maktâp. dâwerat.” dâm huŋgun yetkiep. ");
INSERT INTO tim_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hain dâm makmâ metembo Aposolologâtŋe lâuwâ arekŋe arim gain dâm makyetkiep hainâk mem miawagiat. ");
INSERT INTO tim_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mem miawakmâ doŋgi kâmŋe are hulaŋbela amboŋande dâyi, “Niŋande makto hulaŋdat.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","hin dâyiat, “Humoŋe iregât dâmbo togoet.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hain dâm Yesugâlân mem togombela bâlâpŋaet hâk pekeŋe kâlep are oloŋmâ doŋgi kakŋân kali. Katbiâ Yesuŋe âgâ talep. ");
INSERT INTO tim_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Katbiâ âgâmbo luâk âmbâle dondâŋe hâk pekeyeŋe oloŋmâ dâwân mem melalakom dâp watmâ leŋgaim arimbiâ hamiyeŋân doŋgi kakŋân watyekmâ ariep. ");
INSERT INTO tim_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Arim Oliwa gimbâŋe ewangim gembo âmâ luâk âmbâle kâmot humo Yesu olop manmini arekŋe Yesuŋe kulem siâ siâ ketugumbo ekmâ gayi aregât nâŋgâm âmâ heroŋe akmâ Anutugât kotŋe mem agatmâ âmâ Yesugât hin dâyi, ");
INSERT INTO tim_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Luâk kembunenŋe Kembugât laugât togoâp yâk mepaiŋe mene. Egon himbimân biwi sânduk humo miawaktâp. Dâ egon egâliaŋ gogâleaŋ miawaktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hain dâmbiâ Parisaio konok konok hutyeŋân kili arekŋe hin dâm magaŋi, “Tiksa, gâŋgât maktâi are sami den makyeŋgimenâ den yoŋâk kinmâ den hepunŋet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hain dâmbiâ hin makyeŋgiep, “Makyeŋgire nâŋgâŋet. Den hepunbiâ âmâ kât irekŋe yâk yeŋgât dumyeŋân kinmâ heroŋe maroŋe akbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Akto Yesuŋe Yerusalem kipia ginŋân arim tatmâ âmâ ekmâ biwiŋe umatŋe akto indem hin dâep, ");
INSERT INTO tim_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Yae, kipia ambolupŋe, âlepŋân manberâm aregât dâpŋe emelâk miawagep are egi. Are hinŋe miawaktâp ina dewunyeŋe boktâpgât bo ekmâ nâŋgâi. ");
INSERT INTO tim_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sop siân ain gasalupyeŋande kipiayeŋe awam mewam ketugum dâp tigi yeŋgiwai. Tigi yeŋgim âmâ watyekbiâ bo akbai. ");
INSERT INTO tim_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bo akbiâ âmâ âmben nanaŋlupyeŋe akto âiângen me kipiangen hârogâk hilip yeŋgum itiŋ gulam ketugu yekmâ yeŋgum om meteyekbiâ kawum yeŋeâk kinbiap. Amâ Anutuŋe togom meyekbiap aregât sopŋe hâkâŋ agigât.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Den are makmâ metem sumbe emetŋân âgâep. Âgâm âmâ kotŋe siâ siâ aŋgi goaŋgi akmâ tatbiâ yekmâ kuk akmâ watyekmâ hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Anutugât denŋande hin dâep, “Anutugât emet amâ Anutu olop den makbaigât opmân.” Den hain tatâp ina yeŋe akbiâ âmâ luâk kâmburâ yeŋgât emet hainare aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Akto hilâmŋe hilâmŋe sumbe emetŋân âgâm den potatmâ yeŋgim malep. Hain akmâ mando sumbe kat kat luâk aregât damun akto Mosegât den kârikŋe makmâ kepigi akto humomolupyeŋe hârokŋe Yesu kondenŋe bo agâk dâm aregât den magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hain akbiâ luâk âmbâle yânŋe bikŋande âmâ denŋe nâŋgâmbiâ âlepŋe dondâ akmap aregât nâŋgâmbi umatŋe akto hepuli. ");
INSERT INTO tim_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Hilâm siân Yesuŋe sumbe emetŋân kinmâ ikiŋe den pat âlepŋe dâm potatmâ yeŋgimbo âmâ sumbe kat kat luâk kautŋe Mosegât den kârikŋe makmâ kepigi akto humomolupyeŋande yâkgâlân togom hin dâm aikoyi, ");
INSERT INTO tim_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Makmenâ nâŋgâne. Kulem hinare akmat are niŋaet kârikŋân kinmâ akmat? Niŋande hain akben dâm kârikŋe giŋepgât akmat?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","hin makyeŋgiep, “Akto nâkâ aiyeŋguwe. ");
INSERT INTO tim_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohaneŋe meyekmâ tuân katyegep aregât keiŋe gain gain? Anutuŋe dâmbo agep me luâk yânŋande makbiâ agep aregât makbiâ nâŋgâwe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hain dâmbo yeŋeak hin dâm magaŋgi goaŋgi agi, “Anutuŋe dâep hain dâenŋe âmâ dâwerâp, “Dâ wangât denŋe bo nâŋgâm lokoyi?” ");
INSERT INTO tim_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Gârâmâ nenŋe, “Luâk yânŋande tângoyi.” dâenŋe luâk âmbâle Yohaneŋe Anutugât den maknengiminep dâm aregât kâtŋe mem nenguwâi.” ");
INSERT INTO tim_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hain dâm magaŋgi goaŋgi akmâ benŋe Yesu hin dâm magaŋi, “O Yohanegât keiŋe bo nâŋgâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hain dâmbiâ hin makyeŋgiep, “Akto nâkai hainâk niŋaet kârikŋân kinmâ kulem hin are akman aregât keiŋe bo makyeŋgiwerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuŋe den ginŋe siâ hin makyeŋgiep, “Luâk siâŋe tâk waiŋ aregât âi kâmelep. Kâmetmâ damun katyekmâ hân siângen arim sop kâlep malep. ");
INSERT INTO tim_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Akto bunŋe miawaktâp me bo aregât sop tâlâgumbo hoŋ bawaŋe siâ bunŋe bikŋe meâk dâm aregât huŋgun aŋdo damun yeŋgâlân togombo kom watbiâ yânâk purik kalep. ");
INSERT INTO tim_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Purik kato amboŋande kârikŋe akmâ hoŋ bawaŋe siâ huŋgun aŋdo hainâk arim damun yeŋgâlân togombo kom watbiâ âmâ yânâk purik kalep. ");
INSERT INTO tim_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Purik kato amboŋande hoŋ bawa âlâwuŋe are huŋgun aŋdo yâk yeŋgâlân togombo hâk hilâlâm waŋmâ kom watbiâ purik kalep. ");
INSERT INTO tim_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Purik kato amboŋande, “Gain gain akbe?” dâm hin nâŋgâm dâep, “Nune nanne okotne nâŋgaŋman are huŋgun aŋdere arimbo yâkgât den lokom sot âlem yendâp are bikŋe waŋbiâ mem togowiap mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hain dâm huŋgun aŋdo yâk yeŋgâlân togombo âmâ damunlupŋande magaŋgi goaŋgi akmâ hin dâyi, “O, yâkŋe âmâ âi ire amboŋe akbiap haingât kondenŋe âi ire nengât akbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hain dâm watmâ hewukŋângen panbiâ gembo aregen kombiâ moep. Mondo arekŋeak âi amboŋande gain gain akyeŋgiwiap? ");
INSERT INTO tim_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aregât maktere nâŋgâŋet. Amboŋande togom âi damunlupŋe hainâk yeŋgum damun aŋgâ katyekbiap.” dâmbo hin dâyi, “Bo. Hain akto ârândâŋ bo aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hain dâmbiâ Yesuŋe tâŋâk yekmâ hin dâep, “Ye pâpkoâi. Anutuŋe hain akmap aregât makyeŋgimbo kulemgoyi are hin, “Emet ketuguwerâm âmâ tetembeŋe ekmâ bâleŋe dâm hepuli are tetembeŋe kârikŋe aregât dopŋe aktâp.” ");
INSERT INTO tim_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Den are bunŋe akto luâk siâŋe tetembeŋe are kâwutmâ hilipkowiap. Akto tetembeŋe arekŋe kâwulakmâ ge kondo mombiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Akto Yesuŋe Mosegât den kârikŋe makmâ kepigi akto yâk yeŋgât keiyeŋe nâŋgâm den ginŋe are dop yeŋgum makyeŋgimbo nâŋgâm biwiyeŋe bâlimbo ainâk kala busiân katne dâm agi. Hain akberâm agi arekŋe luâk âmbâle kâmot humo are yeŋgât hamep akmâ hepuli. ");
INSERT INTO tim_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hepunmâ hin dâyi, “Hâmbâi Yesuŋe den makmâ hilip kombo âmâ kiapgâlân mem ariwaen.” dâm aregât damun agaŋi. Hain akmâ luâk konok konok meyekmâ hin dâm makyeŋgiyi, “Yesu yoŋâk hiaŋgim aikombiâ den makmâ hilip kombo aregât kiapgâlân mem arim kombaen.” hain dâm huŋgun yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Huŋgun yeŋgimbiâ Yesugâlân togom lau tu hin dâm magaŋi, “Luâk humo, keige nâŋgâen. Den makmat are bunŋe âlepŋe. Akto luâk kotdâ are yeŋgât bo hamep akmâ kinmâ Anutugât dâp bunŋânâk maknengimat. ");
INSERT INTO tim_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aregât makmenâ nâŋgâne. Roma luâk kotdâ yeŋgât puli katenŋe ârândâŋ akmap me bo?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hain dâmbiâ hiaŋgigât keiŋe biwiyeŋân ekmâ nâŋgâm hin dâep, ");
INSERT INTO tim_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Puli koaŋe mem hekat niŋbiâ ekbe.” dâmbo mem hekalaŋbiâ hin dâep, “Ire ekŋet. Niŋaet otneŋe katbiâ tatâp?” ");
INSERT INTO tim_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","dâmbo dâyi, “Roma luâk kotdâgât otneŋe tatâp.” dâmbiâ hin makyeŋgiep, “Roma luâk kotdâ yeŋgât pat are âmâ luâk kotdâ waŋbi. Dâ Anutugât pat are âmâ Anutu waŋbi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hain dâmbo denŋe are nâŋgâmbiâ humo akto luâk âmbâle dondâ kiligât gain gain aknerâm ewum pâpkoyi. ");
INSERT INTO tim_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Akto Sadukaio luâk bikŋande Yesugâlân togoyi. Sadukaio yâkŋe âmâ momoŋânba agatbaengât dopŋe bo tatâp dâm mali. Bo kârikŋe hain nâŋgâm mali. Akto Yesugâlân togom hin dâm magaŋi, ");
INSERT INTO tim_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Luâk humo, Moseŋe den kârikŋe siâ hin dâm kulemgoep are tatâp. Luâk siâŋe âmbâle siâ mendo manmâ luâk are mondo âmâ emiŋande kambut mendo nanaŋ membiap are âmâ teuŋaet pat akbiap. Den kârikŋe hain tatâp aregât den pat siâ maktenŋe nâŋgâ. ");
INSERT INTO tim_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Emelâk emi teu nâmbulân lâuwâ manmâ teuyeŋande âmbâle mem nanaŋ bâlâk manmâ moep. ");
INSERT INTO tim_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mondo emiŋande kambut areâk mem yâkâ hainâk nanaŋ bâlâk manmâ moep. ");
INSERT INTO tim_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mondo benŋe emiŋe siâŋe kambut areâk mem yâkâ hainâk nanaŋ bâlâk manmâ moep. Hainâk akmâ manmâ gam âmâ emi teu nâmbulân lâuwâ arekŋe âmbâle konok areâk mem nanaŋ bâlâk manmâ mom meteyi. ");
INSERT INTO tim_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hain akmâ mom metembiâ âmbâle kambut are bâiŋângen moep. ");
INSERT INTO tim_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akto luâk nâmbulân lâuwâ arekŋe âmbâle konok areâk meyi aregât hâmbâi momoŋânba agatbaiân âmbâle are niŋaet pat akbiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hain dâmbiâ Yesuŋe hin dâep, “Uŋak âmâ âmbâle aŋgi goaŋgi akmâ mandâi. ");
INSERT INTO tim_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Dâ titnan sop humoân âmâ Anutuŋe nâŋgâmbo âmâ dop konogâk manmâ âgâwai. Anutuŋe makyeŋgimbo momoŋânba agatbai. Agatmâ aŋelo yeŋgât dop hainare akbai. Haingât luâk âmbâle aŋgi goaŋgi akbaigât dopŋe bo tatâp. Bo kârikŋe. Akto ain âmâ Anutuŋe dâmbo lâuwâŋe bo mombai. ");
INSERT INTO tim_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Akto momoŋânba agatbai aregât Moseŋe den kulemgoep are hin tatâp. Lâwin keiŋân kâlâp punduŋ katmâ oep aregât kulem âmâ luâk âmbâle hârokŋe moyi aregât Anutuŋe den siâ hin kalep, “Nâmâ Abraham Isaka akto Yakobo yâk yeŋgât damun.” Den hain dâm kulemgoep tatâp aregât keiŋe hin. ");
INSERT INTO tim_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutu hâk heambuk are damunyeŋe akmap, akto luâk golâ manmai are yeŋgât damunyeŋe akmap aregât Abraham, Isaka, akto Yakobo, âmâ golâ mandâi.” ");
INSERT INTO tim_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesuŋe hain dâm makyeŋgimbo Mosegât den kârikŋe makmâ kepigi bikŋande hin dâyi, “Luâk humo âlepŋe maktât.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hain dâm siâkâ aikowerâm akmâ nâŋgâmbiâ umatŋe akto hepuli. ");
INSERT INTO tim_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","43","Hain gârâmâ Yesuŋe den hin dâm makyeŋgiep, “Dawidiŋe kep keŋgugât kulem hin kulemgoep, Anutuŋe nâŋgât Humone are hin magaŋep, “Gâ bâtne bungen tatmenâ gasalupge keigaet amukŋân kâmot katere tâliyekbiat.” dâep. Hain gârâmâ Anutuŋe huŋgun aŋdo gem damun nenŋe akbiap are Dawidigât hakuŋe dâmai hain bo. ");
INSERT INTO tim_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawidiŋe humoŋaet nâŋgâm nâŋgât Humone, hain dâm kolep aregât yeŋe âmâ gain gain akmâ Dawidigât tepŋân gâtŋe dâmai?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Den are makmâ metem purik dâm luâklupŋe makyeŋgimbo luâk âmbâle kili arekŋe hin nâŋgâyi, ");
INSERT INTO tim_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mosegât den kârikŋe makmâ kepikmâ manmai dop hain bo manbi. Yâkŋe âmâ hâk pekeŋe kâlep are kulem melem are luguakmâ dâp arim luâk âmbâle yekmâ heroŋe aknengiŋet dâm aregâlâk nâŋgâmai. Akto den emetŋân âgâm luâk hutyeŋân tatmâ âmâ luâk humomo yeŋgât welam pat dâm yeŋgiyi ainâk nenŋe soŋ tatne dâm aregât akmai. ");
INSERT INTO tim_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Akto âmbâle kambut yâk yeŋgât kotŋe siâ siâ meyeŋgimai. Akto luâk âmbâleŋe nenekbiâ humo agâk dâm aregât miapŋân kinmâ Anutu magaŋberâm kinmai. Luâk hain arekŋe aregât dosa dondâ memai. Aregât ye yâk yeŋgât dop bo akmâ manbi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Hain dâm sumbe kat kat emetŋân tatmâ Yesuŋe dewunŋe panmâ yekto puli siâ siâ humo tatyeŋgiep arekŋe Anutugât pat dâm puli katbiâ gembo yegep. ");
INSERT INTO tim_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Katmâ arimbiâ âmbâle kambut siâŋe ikiŋe puli gilâm lâuwâk kato giep. ");
INSERT INTO tim_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kato gembo Yesuŋe ekmâ Aposololupŋe hin dâm makyeŋgiep, “Bundâk makyeŋgiwe. Âmbâle kambut ire umburuk mamburuk manmap irekŋe puli gilâmŋe lâuwâk katâp irekŋe âmâ puli humo katâi are hârok ewangi yektâp. ");
INSERT INTO tim_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Puli humo tatyeŋgiâp arekŋe âmâ oyaŋmâ bikŋeâk mem ga katâi. Dâ âmbâle kambut ire âmâ hain bo. Yâk âmâ puli gilâmŋe lâuwâk talaŋdâp are hârok katmâ âmâ yân manberâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hain dâmbo Yesugât kâmot bikŋande sumbe emetŋaet hin dâyi, “Emet iregât ambolupŋande Anutugât opmân aregât dâm kotŋe siâ siâ katbiâ humomoŋe are mem sumbe emetŋe ketuguyi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Hain dâmbiâ Yesuŋe hin dâm makyeŋgiep, “Opmân yu ektâi ire hâmbâi togom hârem gagaim itiŋ gulam ketuguwai.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","hin dâyi, “Luâk Humo, den yu maktât ire âmâ sop amuten miawakbiap? Akto sop are tâlâgumbo âmâ kulem gain gain hinare miawakbiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hain dâmbiâ hin magep, “Bikŋande oloŋyekbiâ han gulip akbâigât keiŋe makmâ miawaktere biwiyeŋân katmâ manbi. Keiŋe hin. Luâk dondâŋe togom nâŋgât kolân agonakmâ, “Nâ Anutuŋe huŋgun niŋdo geân.” hain dâwai. Akto bikŋande âmâ, “Sop tâlâguâp.” hain dâwai. Gârâmâ ye luâk hainare yeŋgâlân bo dewatiwi. ");
INSERT INTO tim_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Akto bugâ hanâk hanâk miawakto aguwai aregât den pat akbai are âmâ nâŋgâm ain bo hamewakbi. Are soŋ miawakbiapgât Anutuŋe magep. Dâ dowâk bo miawakbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hain dâm den dewatim hin dâep, “Hângât luâk kotdâŋe makbiâ tembe lokolupyeŋande hân siâgât amboŋe yeŋguwai. ");
INSERT INTO tim_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Akto mop humo miawakbiap. Akto wan me wan bâleŋe miawak yeŋgiwiap. Akto wâriŋ humo ain membiap. Akto wan me wan hamepŋe olowâkŋe miawakyeŋgiwiap. Akto sop ain kulem bâleŋe aregât emelâk bo egion dâwai, hain arekŋe himbimân miawakto ekbai. ");
INSERT INTO tim_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Hainare bo miawakto âmâ âi keiŋe katmâ meyekmâ yeŋgum wat yekmâ mem siâ siâ ketugu yekbai. Akto ye nâŋgât kotne mem manmai aregât yâkŋe denân kat yekmâ kala busi kâlegen kat yekbai. Luâk humo akto kiap are yeŋgâlân meyekmâ ariwai. ");
INSERT INTO tim_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hain akyeŋgimbiâ âmâ nâŋgât den pat âlepŋe aregât keiŋe makmâ miawakbiâ nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Akto are yeŋgâlân kinmâ âmâ den gain gain maktere ârândâŋ akbiap aregât nâŋgâm bo hanokoakmâ umale akbi. ");
INSERT INTO tim_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nâŋe nunak memeŋe akyeŋgire lauyeŋe owâiŋe akto den makbai amâ gasalupyeŋande denyeŋe are mem ge katberâm ewum hâumgowai. ");
INSERT INTO tim_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Akto sop ain ewe memelupyeŋe me emi teulupyeŋe tâulupyeŋe akto galalupyeŋe yâkŋeak gasa akyeŋgim meyekmâ yeŋgumbiâ yeŋgâlân gâtŋe bikŋande mombai. ");
INSERT INTO tim_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Akto sop ain âmâ ye nâŋgât kotnaet akmâ manmai aregât yeŋgât nâŋgâm bâli yeŋgim luâk kâmot humoŋe gasa akyeŋgim manmâ âgâwai. ");
INSERT INTO tim_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Siâ me siâ hain akyeŋgimbiâ nâŋe tânyeŋgure kautyeŋe dumutŋe siâ bo gulip akbiap. ");
INSERT INTO tim_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aregât kârikŋe kinmâ âmâ bo hâkâŋ akbiâ manmanyeŋe bunŋe miawakyeŋgiwiâp. ");
INSERT INTO tim_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Akto gasalupyeŋe yeŋgât tembe loko kâmotŋe kâmotŋe togom Yerusalem kipia ire awam ketugumbiâ âmâ yekmâ hin dâwai, “Hilip nengumbiâ kipia kawum akberâm aktâp.” hain dâwai. ");
INSERT INTO tim_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Akto sop ain âmâ Yudaia hân ambolupŋe kipiayeŋe hepunmâ hewukŋângen pârigim heambukmâ ariwai. Akto Yerusalem kipia kâlegen manbai yâkâ hainâk pârigim ariwai. Akto kipia ginŋângen manbai arekŋe wan me wan memberâm purik katmâ kipian bo gawai. ");
INSERT INTO tim_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sop ain dosa membai aregât emelâk kulemgoyi are Anutuŋe bunŋe agâk dâm dosa aregât hâuŋe yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yai, âmbâle tepdâ me nanaŋ nam yeŋgim tatbai arekŋe gain gain akbai? Yâk ariwerâm hâk hilâlâm nâŋgâm umatŋe akmâ ewum hâumgowai. Hain akbai aregât hâuŋe âmâ Anutuŋe purikŋe yeŋgimbo hân ambolupŋande yae dâm agatmâ sopanmâ hâk hilâlâm nâŋgâm manbai. ");
INSERT INTO tim_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Are tembe lokoŋe bikŋe oloŋ yekmâ hânŋe hânŋe meyekmâ arimbiâ hoŋ bawalupyeŋe akmâ manbai. Ain âmâ Anutu bo nâŋgaŋmai arekŋe gasa akyeŋgim Yerusalem kipia itiŋ gulam ketuguwai. Ketugumbiâ kawum akto âmâ manmâ âgâmbiâ âmâ Anutuŋe hin dâwiap, “Nâŋgât bo nâŋgâ niŋmai are yeŋgât sop bo aktâp.” dâwiawân ain hilip aguwai. ");
INSERT INTO tim_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Akto siân âmâ dewutâ hilâmgât akto hândâkgât me pituŋ me hân akto haru bâliwiapgât kulem keiŋe keiŋe miawakto ekbai. Ekmâ âmâ luâk âmbâle hârokŋe biwiyeŋe agatbiap. ");
INSERT INTO tim_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Akto dewutâ me pituŋ arekŋe duwuŋ akmâ kotŋe hanâk hanâk bam gutbai. Hain akbiâ kulem are ekmâ hamewakmâ hin dâwai, “Gain gain akne? Yâgâten arim heambukne?” dâmbiâ okotyeŋân tuk tuk erâmbo âmâ biwiyeŋe gulip akbiap. ");
INSERT INTO tim_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hain akbiâ pagaleŋe pakpak dâmbo âmâ luâk akmâ geân nâ kârikŋe akmâ hamandat kulewoŋwoŋ kakŋânba gere âmâ nekbai. ");
INSERT INTO tim_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kulem hain miawakto ekmâ dewunyeŋe egon panmâ ekmâ hin dâwai, “O nen bâleŋânba mem oloŋ nenekberâm geâp.” dâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesuŋe hain dâm den ginŋe siâ hin dâm makyeŋgiep, “Ye hâpugât keiŋe ya nâŋgâmai are. ");
INSERT INTO tim_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hâpu tataŋgaiŋe gagai akto aregât hin dâmai, “O imâ dewutâ komberâm aktâp.” dâmai. ");
INSERT INTO tim_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hainâk kulem hainare miawakto ekmâ âmâ hin dâwi, “Emelâk humo miawakmâ nen olop mando Anutuŋe damun nenŋe akbiap aregât sop tâlâguâp.” hain dâwi. ");
INSERT INTO tim_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Den ire maktere nâŋgâm biwiyeŋân katŋet. Luâk kâmot yu tatâi irekŋe bo mom golâ manbiâk hainare miawakto ekbai. ");
INSERT INTO tim_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Himbim hân haru kârikŋe yembiap dâmai are hârok gulip aguwiap. Dâ nâŋgât den yu maktân ire âmâ kârikŋe akmâ yem âgâwiap. Gulip akbiapgât dop bo tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Akto Yesuŋe hin dâm makyeŋgiep, “Iren hânân kotŋe siâ siâ keiŋe keiŋe mem aregâlâk nâŋgâwâigât biwi golâ manŋet. Akto tu kârikŋe nembiâ wâtyeŋe bo akto nâŋgât nelâm yeŋgiwopgât aregât âkâ hainâk biwi golâ manŋet. Wangât? Hingât. Nâŋe dowâk miawakmâ togowian ain âmâ luâk hârokŋe dosayeŋaet hâuŋe membai. Bo nâŋgâm pâlâmŋe manbiâ hami komŋe sân sânâk meyekmap dop hainâk togowian. ");
INSERT INTO tim_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anutugât den konok lokom manmâ biwiyeŋe yâkgâlân kârikŋe tatbiâp aregât nâŋgâm hokboâk hokboâk Anutu ulilaŋmâ biwi golâ manmâ âgâmbiâ kulem hainare miawakbiap. Hain akmâ manbiâ nâ miawakmâ kinbian ain bo aŋun aŋgiwai.” Yesuŋe hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Akto hilâm ârândâŋ sumbe emetŋân âgâm kinmâ den potatmâ makyeŋgim malep. Hain akmâ manmâ âmâ emet dâgâmbo âmâ Oliwa gimbâŋân âgâm ain tatminep. ");
INSERT INTO tim_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hain akminepgât emet hauŋdo luâk âmbâle hamepŋe olowâkŋe denŋe nâŋgâwerâm sumbe emetŋân âgâm mendugum lâmgoyi. ");
INSERT INTO tim_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Akto hombaŋ siâ aregât kotŋe Pasowa dâmini ain sot bo kaulemap omini are tâlâguep. ");
INSERT INTO tim_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Akto sop ain sumbe kat kat luâk akto Mosegât den kârikŋe makmâ kepigi yâkŋe luâk âmbâle dondâ are yeŋgât nâŋgâm hamep akmâ aregât Yesu gain gain agaŋdenŋe moâk dâm magaŋgi goaŋgi agi. Hain akmâ dâpgât undâgâtmâ mali. ");
INSERT INTO tim_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hain akmâ manbiâ Niambiŋe Aposolo siâ Karioto kipian gâtŋe kotŋe Yudasi are kautŋân mendo ");
INSERT INTO tim_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","sumbe kat kat luâk are yeŋgât damunlupyeŋe akto tembe loko kautŋe arekŋe magaŋgi goaŋgi akmâ, “Yesu gain gain aktenŋe koŋet.” dâmbiâ Yudasiŋe arim aregât keiŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Den makyeŋgimbo biwiyeŋe âlepŋe akto puli waŋberâm agi. ");
INSERT INTO tim_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hain akbiâ denyeŋe are lokom luâk âmbâleŋe aregât keiŋe nâŋgâwâi dâm aregât yoŋâgângen mem miawakmâ âmâ kombai aregât ekmâ watmâ malep. ");
INSERT INTO tim_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Akto hombaŋ are miawakto hilâm siân lama gâim om nemberâm agi ain ");
INSERT INTO tim_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","âmâ Yesuŋe Petoro akto Yohane hin dâm makyetkim huŋgun yetkiep, “Yet arim âmâ hombaŋ Pasowa aregât lama gâim âmâ om lâm nengum tatbela togoenŋe nemberen.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hain dâmbo hin dâm aikoyiat, “Emet wanân gâim om lâm yeŋguweret?” dâmbela ");
INSERT INTO tim_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","hin dâep, “Kipian âgâm âmâ luâk siâŋe asap lokoakmâ arimbo ekmâ âmâ are hamiŋân watmâ arimbela emelan kewugu yelekmâ âgâmbo âgâwerat. ");
INSERT INTO tim_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Âgâm emet amboŋe mem miawakmâ hin dâm magaŋberat, “Luâk humonetŋande gâŋgât hin dâm maktâp. Emet kâleŋe gain hinan luâklupne olop Pasowagât pat om nemberen? ");
INSERT INTO tim_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hain dâm maknetkiâp.” dâm magaŋbela emet kâleŋe humo siâ mem âlepŋe dondâ ketuguyi are hekat yetkimbo âmâ âgâm sot wan om lâm nenguwerat.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hain dâm huŋgun yetkimbo ariyiat. Arim magep hainâk mem miawakmâ magaŋbela emet are hekat yetkimbo siâ siâgât magep hainâk hainâk mem heŋgemgoyiat. ");
INSERT INTO tim_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mem heŋgemgombela kindo sop akto âmâ aposololupŋe olop penâyetkimbiâ sot neyi. ");
INSERT INTO tim_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nem tatbiâ âmâ hin dâm makyeŋgiep, “Nugumbiâ hâk hilâlâm nâŋgâwerângât sop tâlâguâpgât ye olop sot ire nemberengât ukenŋe nâŋgân. ");
INSERT INTO tim_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Akto maktere nâŋgâŋet. Nâ hinŋe ye olop sot yu nenden hainâk lâuwâŋe bo nembian arekŋe maleine bunewâk Anutuŋe damunyeŋe akberâm keiŋe katbiap âmâ lâuwâŋe nembian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hain dâm waiŋ are nemberâm hâpurâ mem Anutu maŋganmâ mepaiŋe mem hin makyeŋgiep, “Ire mem potatmâ neŋet. ");
INSERT INTO tim_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Akto ire maktere nâŋgâŋet. Nâ hinŋe waiŋ tu ire bo nem mandere Anutuŋe bâin dâm damunyeŋe akberâm keiŋe kato âmâ tu irakŋe nembian.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hain dâm sot siâ mem Anutu maŋganmâ mepaiŋe mem munditmâ Aposololupŋe yeŋgiep. Yeŋgim hin dâm makyeŋgiep, “Imâ nâŋgât sunumnaet dop. Nâŋgât pat nelâm yeŋgiwopgât sot ire nem manmâ âgâwi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hain dâmbo nembiâ bo akto waiŋ hâpurâ siâ mem hin makyeŋgiep, “Waiŋ irekŋe Anutugât dâp irakŋe miawakto dosayeŋe hepun yeŋgiwiap aregât nugumbiâ gilâmne gewiap aregât dopŋe aktâp. Are yeŋgât pat dâm makmâ hâreân aregât mem neŋet. ");
INSERT INTO tim_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Akto den siâ ire maktere nâŋgâŋet. Yeŋgâlân gâtŋe siâŋe nâŋgât nâŋgâm bâli niŋmâ moâk dâm gasalupne makyeŋgimbo menekmâ nuguwai. ");
INSERT INTO tim_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aregât Anutuŋe hin dâm makniŋep, “Dâp hainâk arim manbiat.” hain dâm huŋgun niŋdo aregât dâp hainâk arim mombian. Are âmâ nugumbiâ mombiangât luâk siâŋe heniŋmâ dâp hainâk oloŋnekmâ ariwiap aregât dosa umatŋe bâleŋe membiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hain dâmbo hin dâyi, “Nengâlân gâtŋe niŋande akbiap?” dâm magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Akto Aposololupŋande magaŋgi goaŋgi akmâ papalakmâ hin dâyi, “Nengâlân gâtŋe niŋande humonenŋe mandâp?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","hin dâm makyeŋgiep, “Hân siâ siâ yâk yeŋgât luâk humo yâkŋe âmâ hoŋ bawalupŋe meyekto hoŋ bawa agaŋmai akto hoŋ bawa arekŋe luâk aŋgâŋe luâk humo yeŋgonmâ kotyeŋe mem agatmai. ");
INSERT INTO tim_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dâ yeŋe âmâ hângât luâk kembu are yeŋgât agak meme hain bo akbi. Gârâmâ yeŋgâlân gâtŋe siâŋe humo akbian dâm âmâ gegeŋe manbiâp. Akto Anutuŋe nekmâ luâk humo dâwiap dâm manmâ âmâ ye hârok yeŋgât hoŋ bawa akyeŋgiwiâp. ");
INSERT INTO tim_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Akto luâk siâŋe sot om katyeŋgim tân yeŋgumap are âmâ luâk yânŋe dâmai. Dâ luâk siâ âi bo mem yân tato hoŋ bawaŋande sot om kalaŋdo nemap aregât âmâ luâk humo dâmai. Gârâmâ ye hain bo akbi. Aregât nâkai hain nâŋgâm hoŋ bawa akyeŋgim tân yeŋgum malân. ");
INSERT INTO tim_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Akto nâ hâk hilâlâm kakŋân manmâ gan amâ yeŋe bo hepun nekbiâ biwiyeŋe nâŋgâlânâk kindo olowâk manmâ gayion. ");
INSERT INTO tim_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hain akbiâ aregât Ewenande damunyeŋe kat negep hainâk nâŋe âmâ damunyeŋe dâm katyekbian. ");
INSERT INTO tim_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hâmbâi lâuwâŋe miawakmâ gere âmâ olowâk manmâ nembaen aregât pat kat yeŋgiân. Akto ain âmâ luâk kotdâ yeŋgât tat talân tatmâ Israe luâk kâmot keiân lâuwâ tatbai are yeŋgât den makmâ hâre yeŋgiwai aregât pat katyeŋgiân.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesuŋe hain dâm Petoro hin dâm magaŋep, “Simoŋ, Simoŋ, matuk helekŋe are mem pipikoenŋe tuŋe iŋgoen gembo helekŋe are mem pandenŋe arimap dop hainâk Niambiŋe keige ekberâm aregât aktâp. ");
INSERT INTO tim_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Niambiŋe hain dâmbo nâŋe âmâ biwige bâliwop dâm gâŋgât Ewene ulilaŋdân. Ulilaŋdere aregât ulik gulik nâŋgât hâkâŋ akmâ hamiŋân biwigande nâŋgâ niŋmâ âmâ galalupge are tân yeŋguwiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hain dâmbo Petoroŋe hin dâep, “Humo, gâ kala busi kâlegen kat gekbiâ tatbiat me bugâ mem mombiat âmâ nâ gâ bo hepun gekbian. Nâkâ hainâk akbian.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","hin dâm magaŋep, “Petoro maktere nâŋgâ. Gokorok bo indemboân gâŋe nâŋgâ yâkgât bo nâŋgaŋman dâm muneŋ akmenâ sop âlâwu akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hain dâm benŋe luâklupŋe hinâk makyeŋgiep, “Emelâk puli bo ito bo kei pekeŋe bo, hain huŋgun yeŋgire arim umburuk akmâ mali me bo?” dâmbo hin dâyi, “Nen umburuk bo malion.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","hin makyeŋgiep, “Nâŋgât den kulemgoyi are hârogâk bunŋe akbiapgât sopŋe tâlâguâp. Akto Anutuŋe nâŋgât den siâ dâmbo kulemgoyi are hin, “Bâleŋe meme yâk yeŋgât kâmolân katbai.” den are nâŋgâlân bunŋe akberâp aregât ito me iripân me wan me wan tatyeŋgiâp are mem ariwerâi. Dâ yeŋgâlân gâtŋe bikŋande puli me wan me wan bo tat yeŋgiâp yeŋe âmâ yeŋandeân hâk pekeŋe mem yâk yeŋgimbiâ puli yeŋgimbiâ puli are mem arim bugâ puligowai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hain dâmbo hin dâm magaŋi, “Humo ire ek. Nengâlân tâwât lâuwâ tatâp.” dâmbiâ hin dâep, “Bâin. Hain talâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hain dâm Yesuŋe hândâk ârândâŋâk kipia are hepunmâ Oliwa gimbâŋân âgâm manminep hainâk kipia hepunmâ Oliwa gimbâŋân âgâwerâm hoŋ bawalupŋe kewugu yekto âgâyi. ");
INSERT INTO tim_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Âgâm malewân arim hin dâm makyeŋgiep, “Bâleŋande mem katyekbopgât in tatmâ Anutu ulilaŋŋet.” ");
INSERT INTO tim_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hain dâm kat yekmâ getek bam ge tatmâ hin dâm ulilaŋep, ");
INSERT INTO tim_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Apo, gâ nâŋgâmenâ ârândâŋ akto makmenâ âmâ hâk hilâlâm irekŋe gam ewanginegâk gârâmâ nâŋgât den bo. Gâŋgât den kârikŋe agâk.” dâm ulilaŋep. ");
INSERT INTO tim_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hain dâmbo aŋelo siâŋe himbimânba gem memeŋe agaŋep. ");
INSERT INTO tim_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hain akto biwiŋe umatŋe akto nâŋgâm kârikŋe akmâ lâuwâŋe hainâk dâm ulilaŋep. Ulilaŋdo âmâ ogowak biririk dâm gem gilâm tiriŋ târâŋ gemap dop hainâk akmâ tiriŋ târâŋ dâm hânân giep. ");
INSERT INTO tim_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hain akto ulilaŋmâ metem Aposololupŋe bam yegep. Akto okot yeŋe nâŋgâm wâtyeŋe hutuk âgâmbo asiŋ yeyi. ");
INSERT INTO tim_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Asiŋ yembiâ yekmâ hin dâep, “Gain akmâ asiŋ yendâi? Agatmâ kinŋet. Hâwâtyekto bâleŋe akbâigât Anutu ulilaŋŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hain dâm kindo ainâk dondâ togoyi. Togombiâ âmâ Aposolo siâ kotŋe Yudasi yâkŋe sumbe kat kat luâk are yeŋgât humomolupyeŋe akto areyeŋgât tembe loko akto Yuda yeŋgât kaunsoli are olop halop hogoaŋmâ den hikoyi are watmâ gasa makyeŋgim kewugu yekmâ togo katyekto kinbiâ ba Yesu lokom maŋganlep. ");
INSERT INTO tim_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Maŋgando Yesuŋe hin dâep, “Yudasi, luâk akmâ gewiap dâmai are âmâ nâ menekŋetgât wangât maŋgan nektât?” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hain dâmbo Aposololupŋande siâ siâ akyeŋgiwai aregât nâŋgâm hin dâyi, “O humo nâŋgâmenâ tâwâtŋe kârâ yekne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dâmbiâ are hutyeŋân gâtŋe siâŋe tâwât mem sumbe kat kat luâk humoyeŋe siâ yâkgât hoŋ bawa siâgât ondopŋe bikŋe tâwâtŋe kârâm hâriep. ");
INSERT INTO tim_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kârâm hârembo Yesuŋe ekmâ hin dâep, “Hepunŋet.” dâm luâk aregât ondopŋe are mendo âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hain akmâ sumbe kat kat humomolupyeŋe akto yâk yeŋgât tembe lokolupyeŋe hin dâm makyeŋgiep, “Yeŋe âmâ nâŋgât nâŋgâmbiâ bugâ koko luâk akman aregât bugâyeŋe loko akmâ menekberâm togoâi mon? ");
INSERT INTO tim_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nâ sop ârândâŋ sumbe kat kat emetŋân ye olop manmâ gayion sop ain wangât bo menegi? Dâ uŋak ire âmâ Hândâk Amboŋe arekŋe memeŋe akyeŋgiâp aregât togoâi.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hain dâmbo mem arim sumbe kat kat luâk yeŋgât humoyeŋe aregât emelangen mem ariyi. Mem arimbiâ Aposolo awam akmâ arim meteyi. Akto Petoroŋe purik katmâ yoŋâk yoŋâk hamiyeŋângen watyekmâ togoep. ");
INSERT INTO tim_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Akto emelan mem âgâmbiâ tembe loko bikŋe âmâ sombeimân kâlâp om nâŋgâm tatbiâ Petoro âkâ hainâk kâlâp nâŋgâwerâm yâk yeŋgât hut yeŋân ge talep. ");
INSERT INTO tim_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hain tatbiâ hoŋ bawa âmbâle siâŋe ekmâ nâŋgâm hin dâep, “O luâk ire âmâ Yesugât kâmolân gâtŋe.” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","muneŋ akmâ hin dâep, “Nâ luâk are bo nâŋgân. Akto bo ekman.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hain dâmbo sop kâlewâk bo aktoâk luâk siâŋe ekmâ hainâk dâep, “Âo gâ yâk yeŋgâlân gâtŋe.” dâmbo hin dâep, “Nâ yâk yeŋgât kâmolân gâtŋe bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hain dâm getek sop kâlewâk hin tato luâk siâŋe ekmâ wârakmâ hin dâep, “Bundâk gâ yâk olop manmai. Akto gâ Galilaia denân makmenâ nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hain dâmbo hin dâep, “Nâ gâŋgât den are pâpkoân.” dâmbo ainâk gokorok indiep. ");
INSERT INTO tim_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Indembo âmâ Yesu Humoŋe purik dâm Petoro tâŋâk egep. Ekto âmâ Humoŋe den hin dâm magaŋep are nâŋgâep, “Gokorok bo indemboâk gâŋe nâŋgât keine tigimenâ sop âlâwu akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Den are nâŋgâm biwiŋe umatŋe akto arim indiep. ");
INSERT INTO tim_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Akto Yesu damungom kili arekŋe dewunŋân gem den magaŋmâ sâŋgumŋe dewunŋe hikom tigim ondopŋe hogoyi. ");
INSERT INTO tim_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ondopŋe hogom hin dâyi, “Ondopge hogoâp aregât kotŋe kon.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hain dâm den are magaŋmâ den bâleŋe magaŋmâ kili. ");
INSERT INTO tim_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hain akmâ kinbiâ emet hauŋdo sumbe kat kat luâk akto Mosegât den kârikŋe makmâ kepigi, akto Israe yeŋgât damunlupyeŋe dondâ mendugu akmâ Yesu kâmot yeŋân mem âgâ katmâ hin dâm magaŋi, ");
INSERT INTO tim_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Gâŋe Anutuŋe huŋgunniŋdo geân maktât aregât âmâ keige makmâ miawak.” dâmbiâ hin dâep, “Den ire hâkâŋ akberâigât nâŋgân aregât hepunbe. ");
INSERT INTO tim_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Akto den siâ aiyeŋgure bo makniŋberâi. ");
INSERT INTO tim_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gârâmâ sop iregât luâk akmâ geân nâ Anutu kârikŋe amboŋe yâkgât bâtŋe bungen tatere nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hain dâmbo hârokŋe nâŋgâm hin dâm magaŋi, “Gâŋe hin dâmat, “Nâ Anutugât nanŋe mandân.” dâmat are bunŋe me bo?” dâmbiâ, “Âo, ya maktâi are.” dâmbo hin dâyi, ");
INSERT INTO tim_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Siâŋe siârâm siârâm akbiâ âmâ den âi humo membâen. Emelâk maktâp areâk bugâ neâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Akto Yesu meyi arekŋe hârogâk agatmâ Yesu mem Pilatogâlân ariyi. ");
INSERT INTO tim_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yâkgâlân arim kinmâ hin dâm yâkgât den dâm hiaŋgiyi, “Luâk iregât keiŋe hin. Luâk hârok yeŋgât biwiyeŋân nâŋgâ nâŋgâ bâleŋe lugumap are hin. Roma luâk kotdâgât puli bo katŋet dâm aregât makmâ nâ Anutuŋe huŋgunniŋdo geângât damunyeŋe akman dâmap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hain dâmbiâ Pilatoŋe aikom hin dâep, “Gâ Yuda yeŋgât luâk humo me?” dâmbo hin dâep, “Gâŋe maktât are bunŋe.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hain dâmbo Pilatoŋe sumbe kat kat luâk are yeŋgât humomolupyeŋe akto luâk dondâ ain kili are hin dâm makyeŋgiep, “Luâk iregât dosa siâ bo tatâp nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hain dâmbo kârikŋeâk konmâ hin dâyi, “Bunŋe luâk mem hanâk hanâk ketugu yekmâ biwiyeŋân gem denne hânŋe hânŋe ariâk dâm aregât makmap. Akto Galilaia hânân bam keiŋe makmâ ainba Yudaia hânân togom hainâk akmap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hain dâmbiâ Pilatoŋe hin aiyeŋguep, “Luâk ire Galilaia hânân gâtŋe me?” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","hin dâyi, “Âo ain gâtŋe.” dâmbiâ Pilatoŋe hin nâŋgâep, “Galilaia hân are Heroteŋe damunŋe akmap ain gâtŋe.” are nâŋgâm yâkgâlân mem ariŋet dâm huŋgun yeŋgiep. Akto sop ain Heroteŋe Galilaia hân hepunmâ Yerusalem kipian malep aregât huŋgun yeŋgimbo Herotegâlân mem ariyi. ");
INSERT INTO tim_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yâkgâlân mem arimbiâ Heroteŋe Yesugât den pat are nâŋgâm ekbeâk nâŋgâm malepgât Yesu ekmâ âmâ biwiŋe heroŋe agep. Hain akmâ kulem siâ ketugumbo ekberâm aregât ukenŋe nâŋgâm malep. ");
INSERT INTO tim_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Akto Heroteŋe den keiŋe keiŋe aregât aikombo hâuŋe bo magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hain akto sumbe kat kat luâk akto Mosegât den kârikŋe makmâ kepigi arekŋe hâkŋe tunmâ den umatŋe siâ siâ magi. ");
INSERT INTO tim_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hain akbiâ Herote akto tembe lokolupŋe yâkŋe Yesu dewunŋân gem betorok panaŋi. Betorok panaŋmâ den hembalik mâŋgiyi. Hain akmâ Heroteŋe dâmbo hâk pekeŋe kulemŋe âlepŋe dondâ siâ mem lugu aŋbiâ gembo Pilatogâlân mem purik katmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dâ ulikŋân Pilato akto Herote gasaŋe gasaŋe maliat. Akto mem arimbiân âmâ ainâk gala agiat. ");
INSERT INTO tim_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Akto Pilatoŋe sumbe kat kat luâk akto Israe yeŋgât damunlupyeŋe akto luâk âmbâle yânŋe are yeŋgondo togom menduguyi. ");
INSERT INTO tim_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Mendugumbiâ hin dâep, “Yeŋe luâk ire nâŋgâlân mem togom yâkgât hin dâm makniŋdâi, “Luâk irekŋe luâk mem kotŋe hanâk hanâk ketuguyekmâ biwiyeŋân gemap.” dâi aregât nâŋe yeŋgât dewunyeŋân keiŋe mem miawaktere dosaŋe bo aktâp. ");
INSERT INTO tim_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Emelâk Heroteŋe makmâ hâreaŋâk dâm huŋgun yeŋgire bo akto nâŋgâlân lâuwâŋe mem togoâi. Nâŋgâi. Luâk ire mombiapgât dosaŋe siâ bo ektân aregât hin aktere ârândâŋ akberâp. ");
INSERT INTO tim_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tembe lokolupne makyeŋgire tâkŋeak orem hâk hilâlâm waŋmâ huŋgun aŋbiâ yân gem ariâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hain dâm kinmâ sop ain Pasowa hombaŋ ârândâŋ nâŋgâ yeŋgim kala busi kâlegen kat yekbiâ tatmini are yeŋgâlân gâtŋe konok wato ariminep. ");
INSERT INTO tim_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hain akminep aregât luâk âmbâle arekŋe moâkgât konmâ kârikŋe akmâ hin magaŋi, “Are âmâ moâk. Dâ yâkgât dumŋân Baraba are watmenâ geâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Akto Barabagât keiŋe hin. Yâkŋe luâk dondâ mem mendugu yekmâ hin dâm makyeŋgiep, “Kiap tembe loko hârok yeŋgum wat yektenŋe ariŋet.” dâm bugâ mem luâk siâ kondo mondo aregât kala busi kâlegen katbiâ talep. Keiŋe hain. ");
INSERT INTO tim_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Akto Pilatoŋe lâuwâŋe hin dâep, “Nâmâ Yesu watere gewerâpgât nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hain dâmbo den kârikŋe konmâ magaŋi, “Yesu lâwinân kombiâ moâk. Lâwinân kombiâ moâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hain dâmbiâ Pilatoŋe den koyeŋgim âlâwuŋe hin makyeŋgiep, “Bâleŋe bo agepgât nâŋgâre dosaŋe bo tatâp aregât maktere bugâŋe yânâk kom mem hulaŋbiâ yân arim manbiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hain dâmbo kautyeŋe orem kârikŋe akmâ den dâyi hainâk dâyi, “Lâwinân kombiâ moâk” dâmbiâ arim denyeŋande gewe âgâwe akmâ yendo âmâ Pilatogât den are mem ge kali. ");
INSERT INTO tim_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mem ge katbiâ Pilatoŋe den dâyi aregât bunŋe miawagâkgât dâm aregât makmâ hâre yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hain akmâ denyeŋe lokom Baraba luâk koko akto den koko luâk are hulaŋmâ yâkgât dumŋân Yesu moâk dâm makmâ hâreaŋep. ");
INSERT INTO tim_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hain dâmbo arim luâk siâ dâwân gembo egi kotŋe Simoŋ, Kirene kipian gâtŋe yâk âiângenba togombo lâwin ire loko dâm magaŋi. Magaŋmâ Yesugât lâwin are kambeŋân katbiâ lokom hamiŋân arimbo luâk kâmot humo hamiyeŋân ariyi. ");
INSERT INTO tim_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Arimbiâ hutyeŋân âmbâle bikŋande okot dondâ nâŋgâ aŋmâ indem ariyi. ");
INSERT INTO tim_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Akto Yesuŋe purik katmâ yekmâ hin dâep, “Yerusalem âmbâle nâŋgât bo indeŋet. Yeŋaet akto nanaŋlupyeŋe yeŋgât indeŋet. Maktere nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hâmbâi yeŋe hin dâwai, “Bâe, âmbâle gupin, âmbâle sigan yânâk nanaŋ bo meyigât nâŋgâenŋe âlepŋe aktâp.” ");
INSERT INTO tim_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hain dâm ain gimbâŋe iregât hin dâwai, “Hogoakmâ gem tigi nenegâk.” dâwai. Akto hemem keiŋân kinmâ, “Gem nenguâk.” dâwai. ");
INSERT INTO tim_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aregât hin dâre nâŋgâŋet. Lâwin golâ ombiâ âmâ bo omap. Dâ lâwin momoŋe âmâ ombiâ dondâ omap. Aregât gain gain akbai.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Akto bâleŋe meme luâk lâuwâ biken biken yâk olowâk yeŋguwerâm meyelekmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Arim hân siâ kotŋe kaut hagit ain arim lâwinân koyi. Kom âmâ bâleŋe meme luâk lâuwâ are biken biken kat yelekmâ yetkuyi. ");
INSERT INTO tim_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Olowâk yeŋgumbiâ Yesuŋe hin dâm Anutu magaŋep, “Apo yu akniŋdâi ire âmâ keine bo nâŋgâm kinmâ akniŋdâi aregât dosayeŋe hepun yeŋgiwen.” dâep. Hain dâmbo tembe loko arekŋe Yesugât hâk pekeŋe memberâm aregât kulem esenŋe bâleŋ maleŋ oyaŋmâ puli memai dop hain akmâ aŋgiyi. ");
INSERT INTO tim_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Akto luâk âmbâle kâmot humo kinmâ tâŋâk ekbiâ Israe yeŋgât damunlupyeŋe arekŋe dewunŋân gem den hin dâm magaŋi, “Emelâk luâk dondâ tân yeŋgumbo âlepŋe agi. Akto ikiŋaet hin dâmap, “Nâ Anutugât nanŋande ewenande huŋgunniŋdo gem damunyeŋe akmâ mandân.” dâmap aregât lâwinânba sopanmâ geâk.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hain dâmbiâ tembe loko yâkŋe hainâk dewunŋân gem waiŋ tu ŋasukŋe bâleŋe are mem waŋmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Gâ Yuda yeŋgât luâk humo mandât akto âmâ pekmâ sopanmâ ge.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hain dâm Yesugât lâwin ulikŋân hin dâm kulemgom kali, “Ire Yuda yeŋgât luâk kembu.” ");
INSERT INTO tim_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Akto bâleŋe meme siâ Yesugât enemŋe biken lâwinân kombiâ kilep arekŋe hainâk Yesu dewunŋân gem hin dâep, “Bundâk, gâ Anutuŋe huŋgun giŋdo damun nenŋe akberâm gien akto âmâ tân netkumenâ nen hârok sopanmâ gene.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hain dâmbo galaŋe siâ Yesugât enemŋe biken kombiâ kilep arekŋe hin dâm galaŋe are magaŋep, “Gâ bugâgât pat aktât arekŋe gain gain akmâ Anutugât hamep bo akmâ hain dât? Amâ bo agakŋe aktât. ");
INSERT INTO tim_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Net âmâ dosanetŋe tat netkiâp aregât wan me wan aknetkimbiâ âmâ ârândâŋ aktâp. Dâ luâk ire âmâ dosaŋe bo ina hanâk agaŋdâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hain dâm magaŋmâ benŋe Yesu hin magaŋep, “Yesu, lâuwâŋe damun nenŋe akberâm miawakmâ gewiat sop ain nâŋgât nâŋgâ niŋben.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hain dâmbo Yesuŋe hin magaŋep, “Bunŋe makgiŋdere nâŋgâ. Hinŋe emet boâk dâgâmbo mom Anutuŋe tatmawân arim tatberet.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hain dâmbo hilâm tânâmŋe akto ain dewutâ are heambukto hândâk agep. Hândâk akmâ yendo eŋgaiŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Akto hândâk agep ain sumbe kat kat emetŋaet dawalauŋe aregât sâŋgum kâlep humo tigiyi arekŋe tânâmŋânba hioŋakmâ bikŋe bikŋe agep. ");
INSERT INTO tim_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hain akto Yesuŋe hin dâep, “Apo, otnene gâŋgâlân purik kalâkgât nâŋgân.” hain bâin dâm manmanŋe palep. ");
INSERT INTO tim_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Panakto tembe loko yeŋgât humoŋe ekmâ nâŋgâm âmâ Anutu maŋganmâ hin dâep, “Bundâk, luâk iregât dosaŋe bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hain dâmbo luâk kâmot humo are ekberâm togo kili arekŋe kulem miawagep are ekmâ biwiyeŋe bâlimbo nâŋgâm bâlim ariyi. ");
INSERT INTO tim_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Akto Yesugât nâŋgâm âmbâle bikŋande Galilaia hân hepunmâ Yesu watmâ togoyi yâk olowâk kâlewângen kinmâ kulem miawagep are ekmâ nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Akto luâk siâ malep kotŋe Yosepe, are Arimataia kipia Yudaia hânân talep ain gâtŋe. Akto yâk Yuda yeŋgât kaunsoli mali yâk yeŋgâlân gâtŋe. Akto luâk are âmâ âlepŋe gala konok malep. ");
INSERT INTO tim_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hain gârâmâ galalupŋande Yesugât den makmâ hâreaŋmâ kombiâ moâk dâmbiâ âmâ biwiŋande nâŋgâmbo ârândâŋ bo agep. Hain akmâ Anutuŋe damun nenŋe akbiap aregât ukenŋe nâŋgâm lâmgom malep. ");
INSERT INTO tim_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Luâk arekŋe Pilatogâlân arim Yesugât hâkŋe mem arim hangowerâm aregât magaŋep. ");
INSERT INTO tim_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Magaŋdo âlepŋe dâmbo arim lâwinânba mem gem sâŋgum kau kau siâŋe katipkom lokom arim kât dâpŋe siâ sumgât dâm kepikmâ hepunbiâ yân kilep ain kalep. ");
INSERT INTO tim_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ain âmâ hole amâ âi meme sopŋe bo dâm aregât Yesugât hâkŋe ain kalep. ");
INSERT INTO tim_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akto emet dâgâmbo âmâ âmbâle bikŋe Galilaia hân hepunmâ Yesu watmâ togoyi arekŋe Yosepe olop arim Yesu sumân kalep are egi. ");
INSERT INTO tim_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ekmâ tu higenŋe âlepŋe are puligowerâm aregât kipiangen purik katmâ ariyi. Akto Moseŋe den kârikŋe siâ kulemgoep are hin, “Sarere akto ain âi bo ketugum yân tatmâ nâŋgâwi.” den are lokom kipian yân tatmâ nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Akto sonda hândâk pipiŋe tatoâk âmbâle arekŋe tu higenŋe pindindiŋ dâm yendo are mem sumângen ariyi. ");
INSERT INTO tim_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Arim ekbiâ kât humo siâŋe lâm dâpŋe tigiyi are hindakmâ siângen arimbo lauŋe miawâk kilep. ");
INSERT INTO tim_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hain akmâ kindo gem Yesugât undâgâli. ");
INSERT INTO tim_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Undâgâtbiâ bo akto kinbiâ ainâk aŋelo lâuwâ hâk pekeyetŋe kau kau dondâ arekŋe miawakmâ kiliat. ");
INSERT INTO tim_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kinbela yelekmâ hamep akmâ kâŋgom kinbiâ hin dâm makyeŋgiyiat, “Ye wangât golâ mandâp aregât undâgâtmâ sumân togo kindâi? ");
INSERT INTO tim_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yâk iren bo yendâp. Emelâk agatmâ ariâp. Akto ulikŋân Galilaia hânân manmâ den makyeŋgiep are nelâm yeŋgiep mon? Emelâk hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Luâk akmâ geân nâ menekmâ makbiâ luâk bâleŋande nugumbiâ mombian. Mondere hilâm âlâwu bo akto sumânba agatbian.” ");
INSERT INTO tim_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","hain dâm makyeŋgiminep.” dâyiat. Hain dâm makyeŋgimbela biwiyeŋe pâroŋ dâmbo den are nâŋgâm heŋgemgoyi. ");
INSERT INTO tim_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nâŋgâm heŋgemgom sum are hepunmâ purik katmâ arim Aposololupŋe bât bip bip hârok keiân konok are akto olowâk mali yâk den pat are makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akto âmbâle are kotyeŋe âmâ hin. Maria Madala kipian gâtŋe akto siâ Yohana, akto siâ Maria Yakobogât memeŋe. ");
INSERT INTO tim_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yâkŋe âmâ lâulupyeŋe bikŋe olop arim Aposolo den pat are makyeŋgiyi. Makyeŋgimbiâ nâŋgâmbiâ bunŋe bo agep. ");
INSERT INTO tim_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hain akmâ Petoroŋe agatmâ sumângen pârigim arim sâŋgum lâuwâ arekŋe konok talep are ekmâ nâŋgâ nâŋgâŋe gulip akto emetŋân purik kalep. ");
INSERT INTO tim_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Akto hilâm ainâk Yesugât kâmot are yeŋgâlân gâtŋe lâuwâ siâŋe Emausi kipia Yerusalem kipia okotŋângen talep ain ariwerâm ariyiat. ");
INSERT INTO tim_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Arim dâwân wan me wan miawagep aregât magaŋgi goaŋgi akmâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Arim magaŋgim ai agum bao guto manbela dâwân Yesuŋe penâyetkimbo olowâk ariyi. ");
INSERT INTO tim_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Arimbiâ Anutuŋe nâŋgâ nâŋgâyetŋe mem gisapkombo yâk bo ekmâ nâŋgâyiat. ");
INSERT INTO tim_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hain akbela aiyetkum hin dâep, “Gain gain? Niŋaet magaŋgi goaŋgi aktat?” dâmbo hâme yetŋe bâlimbo kiliat. ");
INSERT INTO tim_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hain akmâ kinmâ luâk siâ kotŋe Keleopa arekŋe aikom hin dâep, “Yerusalem kipiangenba Sarereân togoyi arekŋe den pat ire makbiâ luâk âmbâle hârokŋe nâŋgâm mandâi. Dâ gâmâ gain gain akmâ bo nâŋgâm mandât?” dâep. ");
INSERT INTO tim_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hain dâmbela aiyetkum hin dâep, “Wan denŋe?” dâmbo dâyiat, “Yesu Nasarete kipian gâtŋande hin agep aregât den pat. Yâkŋe âmâ Anutugât hoŋ bawa humo malep. Manmâ Anutugât dewunŋân akto luâk âmbâle yeŋgât dewunyeŋân den âlepŋe magep akto âi kârikŋe ketugum malep. ");
INSERT INTO tim_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hain akmâ mando sumbe kat kat luâk humomolupyeŋe akto humomolupnenŋande moâk dâm makmâ hâreaŋmâ kiapgâlân katbiâ makto lâwinân kombiâ moep aregât den pat magaŋgi goaŋgi akmâ mandet. ");
INSERT INTO tim_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Akto nengât gasalupnenŋe yeŋgum watyekto ariwai hain nâŋgâyion ina kombiâ mondo mandenŋe emelâk hilâm âlâwu bo aktâp. ");
INSERT INTO tim_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Akto uŋak nengâlân gâtŋe âmbâle bikŋande den siâ maknetkimbiâ nâŋgâm han lâuwâ aktet. Amâ hândâktâk âmbâle arekŋe Yesu hâkŋe ekberâm sumângen arim ");
INSERT INTO tim_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","undâgâtbiâ bo akto purik katmâ togom hin dâi, “Aŋelo lâuwâ siâŋe miawak nengim Yesu momoŋânba agatâp.” dâm maknengiâi. Hain maknengimbiâ nâŋgâenŋe dâtŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aregât nengâlân gâtŋande den maktâi hainâk arim mem miawaktâi. Akto ikiŋe âmâ bo ektâi.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hain dâm magaŋbela hin dâep, “Han biwiyetŋe pâlâmŋe akto nâŋgâ nâŋgâyetŋe umatŋe. Emelâk Anutuŋe den dâmbo kulemgoyi are nâŋgâm ewum hâumgombela ârândâŋ bo aktâp. Haingât hin maktere nâŋgâet. ");
INSERT INTO tim_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bundâk Anutuŋe huŋgun aŋdo giep are hâk hilâlâm kakŋân manmâ mom agatmâ himbimân âgâwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hain dâm ulik gulik Mose akto propete bikŋande Anutuŋe huŋgun aŋdo gewiap aregât den kulemgoyi aregât keiŋe makyetkim ikiŋaet pat makmâ miawakmâ metiep. ");
INSERT INTO tim_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hain akto arimbiâ Emausi kipia are tâlâguep. Tâlâgumbo hepun yelekmâ ariwerâm agep. ");
INSERT INTO tim_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hain akto âmâ hin dâyiat, “Emet dâgâwerâm aktâp aregât olowâk tatne.” dâmbela emelan olowâk âgâyi. ");
INSERT INTO tim_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Âgâm sot nemberâm akmâ ge tatmâ sot ogoŋe siâ mem munditmâ Anutu mepaiŋe mem sot yetkiep. ");
INSERT INTO tim_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yetkimbo ainâk biwiyetŋe pâroŋ âgâmbo ekmâ nâŋgâyiat. Ekmâ nâŋgâmbela benŋe ainâk heambugep. ");
INSERT INTO tim_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Heambukto makmâ magaŋgi goaŋgi akmâ hin dâyiat, “Âo, dâwân togoetŋe Anutuŋe makto kulemgoyi aregât keiŋe siâ siâ dâm maknetkimbo biwinetŋe agatâp.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hain dâm dowâk agatmâ kipia are hepunmâ Yerusalem kipian ariyiat. Arimbela hoŋ bawa bât biken konok are akto luâk âmbâle bikŋe olop mali arekŋe yelekmâ hin dâm makyetkiyi, ");
INSERT INTO tim_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Humo are bunŋe agatmâ Simoŋ miawagaŋep.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Humoŋe dâwân penâyetkim sot ogoŋe siâ mem munditmâ yetkimbo âmâ ekmâ nâŋgâyiat aregât den pat are makyeŋgiyiat. ");
INSERT INTO tim_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Den hain makyeŋgimbela tatbiâ Yesu ikiŋak hutyeŋân miawakmâ kilep. ");
INSERT INTO tim_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Miawakmâ kindo ekmâ sân sân mem hamep akmâ hin dâyi, “Otne siâ togoâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hain dâmbiâ hin makyeŋgiep, “Wangât biwiyeŋe agatmâ hogoâp? Nâ nunak togoân. ");
INSERT INTO tim_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Keine bâtne ire ekŋet. Howai nekmâ nâŋgâm heŋgemgoŋet. Nâ otne bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Den hain makyeŋgim bâtŋe keiŋe koyi are hekat yeŋgimbo ");
INSERT INTO tim_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","benŋe biwiyeŋe heroŋe nâŋgâm han lâuwâ agi. Hain akmâ, “Ire bo agakŋe” dâyi. Hain dâmbiâ aregât hin dâep, “Sot siâ tatâp me bo?” dâmbo ");
INSERT INTO tim_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","iŋan siâ oyi are waŋi. ");
INSERT INTO tim_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Waŋbiâ nendo egi. ");
INSERT INTO tim_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nem metem hin makyeŋgiep, “Emelâk ye olowâk manmâ âmâ den makyeŋgiân Mose akto propete luâk bikŋe akto Dawidi yâkŋe nâŋgât nâŋgâm den kulemgoyi are hârogâk bunŋe akberâm aktâp.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hain dâm makyeŋgim Anutugât den ulikŋân kulemgoyi aregât nâŋgâŋet dâm nâŋgâ nâŋgâyeŋe mem hulaŋdo den are nâŋgâm heŋgemgoyi. ");
INSERT INTO tim_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akto hin dâm makyeŋgiep, “Propeteŋe nâŋgât hin kulemgoyi, “Anutuŋe huŋgunaŋdo gewiap are hâk hilâlâm nâŋgâm mondo hilâm âlâwu bo akto ain momoŋânba agatbiap.” ");
INSERT INTO tim_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Akto aregât den pat âlepŋe arekŋe sambelem hân hârok arimbo âmâ agak meme bâleŋe yâkgâlânâk panbiâ arim kindo bâleyeŋe makmâ miawakbiâ dosayeŋe hepun yeŋgiwiap. Akto maktere nâŋgâŋet. Ulikŋân nâŋgât den pat arekŋe Yerusalem kipia ainba ");
INSERT INTO tim_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","arim hânŋe hânŋe ariwiap. Akto âi mendere miawakto egi are makyeŋgiwi. ");
INSERT INTO tim_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Akto Ewenande ikiŋe Heakŋe âlepŋe are yeŋgât huŋgun aŋbiap aregât pat kat yeŋgiep are huŋgun aŋdere gewiap. Aregât kipia ire bo hepunmâ yân lâmgom manbiâ indâgen miawakmâ gem memeŋe akyeŋgimbo wâtŋân kinbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hain dâm oloŋ yekmâ Betania kipia ewumâk arim âmâ bâtŋe panmâ mem kârikŋe ketugu yegep. ");
INSERT INTO tim_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mem kârikŋe ketugu yekmâ hepunyekmâ himbimân âgâep. ");
INSERT INTO tim_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Âgâmbo biwiyeŋe heroŋe humo akto nâŋgâm purik katmâ Yerusalem kipian ariyi. ");
INSERT INTO tim_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Purik katmâ arim sumbe emetŋân âgâm Anutugât kotŋe mem agali. ");
INSERT INTO tim_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Anutugât den âmâ hân himbim bo yiewân Anutu olop manmâ gaep. Akto Anutugât den âmâ Anutu dâp hainare manmâ gaep. ");
INSERT INTO tim_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","3","Akto Anutugât den arekŋe hân himbim kârikŋe mâŋgiep. Akto siâ siâ miawagep are âmâ denŋe olowâk miawagep. Dâ den arekŋe wan me wan bo mâŋgiep dâine hân himbim bo miawakbop. Akto luâk nen bo miawakbâen. ");
INSERT INTO tim_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Akto yâk âmâ manman amboŋaet akmâ kârikŋe manmâ gaep, aregât yâkŋe luâk âmbâle manman are kârikŋe yeŋgimbo âmâ manmâ gambiân gam gam nen yu manden. ");
INSERT INTO tim_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Akto den arekŋe pagalem hândâgân kinmâ hândâk kondo pagaleŋe miawagep. Dâ hândâkŋe arekŋe pagaleŋe mem bokberâmbo pagaleŋe arekŋe kârikŋe akto hândâkŋe bo agep. ");
INSERT INTO tim_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Akto Anutuŋe huŋgun aŋdo gewiapgât pagaleŋaet keiŋe nâŋgâŋetgât luâk siâ kotŋe Yohane, tu puli keiŋe kalep, yâkŋe miawakmâ Anutugât den makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Akto Anutu pagaleŋe amboŋe luâk hârokŋe nâŋgaŋmâ heŋgemgoŋetgât Yohane yâkŋe âi keiŋe katmâ makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohane ikiŋe amâ Pagaleŋe Amboŋe bo. Yâkŋe âmâ Pagaleŋe Amboŋaet pat magep. ");
INSERT INTO tim_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pagaleŋe Amboŋe yâkŋe hânŋe hânŋe pagaleŋe yeŋgiwerâm hânân miawakmâ malep. ");
INSERT INTO tim_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Akto yâkŋe hân mem miawagep. Dâ hânân miawakmâ mando luâk âmbâle hânân manmai arekŋe hanyeŋande bo nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akto yâkŋe ikiŋe kepiaŋân togombo kâmotlupŋande gala bo agaŋi. ");
INSERT INTO tim_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dâ luâk âmbâle bikŋe nâŋgaŋmâ han biwiyeŋe yâkgâlân kali amâ yâkŋe Anutugât nan baratlupŋe akŋetgât memeŋe akyeŋgimbo hain manmâ gayi. ");
INSERT INTO tim_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Akto ire amâ Anutugât kârikŋaet nen âlepŋe agion. Dâ memelupnenŋande menenegiân ainâk amâ nen âmâ Anutugât nan baratlupŋe miawakbaengât kârikŋe bo miawaknengimap. Are gam gam kaulem âgâenŋe hainâk bo miawaknengimap. Akto uken nenŋaet akmâ agak meme âlepŋe mem âi humo mendenŋe hainâk bo miawaknengimap. Akto luâkgât kârikŋe bo. Bo dondâ. Amâ emelâk Anutuŋe ikiŋe hanŋaet akmâ potat nenekto yâkgât nan baratlupŋe akmâ manden. ");
INSERT INTO tim_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Akto areâk bo. Den arekŋe gem luâk akmâ kinmâ hutnenŋân miawagep. Miawakmâ mando ekmâ nâŋgâm heŋgemgoyion. Akto yâkŋe bâleŋe agion aregât bo oyaŋmâ luâk lumbe akmâ damun nenŋe akmâ okot âlep aknengiep. Akto den bunŋe kato nâŋgâyion. Akto keiŋe ekmâ hin nâŋgâyion, “Kulem ire amâ Anutuŋeâk mâŋgimap aregât yâk amâ Anutugât nanŋe konok.” hain nâŋgâyion. ");
INSERT INTO tim_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Akto Yohane hainâk yâkgât keiŋe makmâ miawakmâ hin dâep, “Haminân togowiap arekŋe amâ nâ boâk miawagân ainbak manmâ gaep aregât ewanginekmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yohaneŋe yâkgât dâep yâkŋe lumbe akmap aregât tân nengum damun nenŋe akmap. Hain akmâ gam gam bo hepun nenekmap. ");
INSERT INTO tim_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Akto ulikŋân Moseŋe den kârikŋe kulemgombo miawagep. Dâ Yesu Kristoŋe âmâ kârikŋe nengim damun nenŋe akmâ okot âlep aknengim tân nengumap. Akto Anutugât keiŋe bunŋe maknengimbo mem nâŋgâm manden. ");
INSERT INTO tim_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Akto Anutu amâ luâk hârokŋe bo egion. Anutu konok Eweŋaet okotŋân tatmapŋe konok Eweŋaet keiŋe nâŋgâm makmâ hekat nengiep. ");
INSERT INTO tim_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Akto ire amâ Yohane tu puli keiŋe kalep yâkgât den pat. Yerusalem ambolupŋande sumbe kat kat luâk akto sumbe emetgât hoŋ bawa huŋgun yeŋgimbiâ Yohane Yodaŋ biken Betania kepian kinmâ tuân katyegep ain arim hin aikoyi, “Niŋande makgiŋdo âi ire mendât?” dâm aikoyi. ");
INSERT INTO tim_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aikombiâ ikiŋe keiŋe bo heambukmâ makmâ miawakmâ hin makyeŋgiep, “Anutuŋe huŋgun aŋdo giep are nâ bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hain dâmbo hin aikoyi, “Agonak. Gâ Elia me?” dâmbiâ hin makyeŋgiep, “Nâ Elia bo.” dâmbo hin magaŋi, “Hain aregât Anutuŋe propete siâ huŋgun aŋdo gewiap aregât arekŋe amâ enem nenŋân gutmâ maknengiwiap. Gâ yâk me aŋgâ?” dâmbiâ, “Nâ yâk bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hain dâmbo hin dâyi, “Humomolupnenŋande huŋgun nengimbiâ togoen. Dâ keige bo maknengimenâ âmâ arim gain gain dâm makyeŋgiweren? Aregât gâ gugaet keige niŋe are maknengi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hain dâm aikombiâ hin dâep, “Propete Yesaiaŋe ulikŋân hin kulemgoep, “Luâk siâ hân kamitŋângen manmâ hin dâwiap, “Humonenŋe togowiap aregât dâp megatŋet dâwiap.” hain dâm kulemgoep.” den are bunŋe miawakto nâ yu miawaktân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Parisaioŋe huŋgunyeŋgiyigât hin aikoyi, ");
INSERT INTO tim_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Woe, gâmâ Kristo bo, akto Elia bo, akto propete siâ bo. Aregât wangât tuân kat yekmat?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Hain dâmbiâ hin dâep, “Nâŋe amâ luâk tu yânŋe puliyekman. Dâ haminân siâ titnan togom mandâp are amâ bo nâŋgâi. ");
INSERT INTO tim_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Are amâ haminângen togom mandâp yâk humo hainare nâ hin arekŋande hoŋ bawa agaŋdere bo huraguwiap.” dâm makyeŋgimbo hepunmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Imâ Yodaŋ tu biken Betania kepian kinmâ tu puli yekmâ kilep ain togom aikoyi. ");
INSERT INTO tim_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Akto emet hauŋdo Yesuŋe Yohanegâlân togombo Yohaneŋe akŋângen ekmâ hin makyeŋgiep, “Ekŋet. Indâre hân luâk âmbâle nengât dosanenŋe bo agâkgât Anutugât lama togoâp. ");
INSERT INTO tim_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Akto nâ emelâk hin makyeŋgiân, haminân togowiap amâ nâ boâk miawaktere ulikŋân manmâ gaep. Aregât nâ ewangi nekmap ulikŋân hain makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Akto Israe luâk âmbâle arekŋe yâkgât keiŋe nâŋgâŋetgât tuân katyekman. Nunak yâk bo ekmâ nâŋgâm gare Anutuŋe nâ tuân kat yekbiangât huŋgun niŋep arekŋe hin makniŋep, ");
INSERT INTO tim_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","“Gâ luâk âmbâle tuân katyekmenâ are yeŋgât hutyeŋân gâtŋe siâ Heaknande gem kautŋân tatmâ membiap yâkŋe amâ luâk âmbâle bikŋe nâŋgât Heakne yeŋgiwiap.” dâm makniŋep. Hain dâm makniŋdo lauŋe lokom luâk âmbâle tuân katyektere luâk iregât kautŋân Anutugât Heakŋande himbimânba gem kembâ hainare akmâ tâliep. Tâlimbo ya miawagep. ");
INSERT INTO tim_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nâ are egângât keiŋe hin makmâ gan. Yâk Anutugât nanŋe dâm makman.” dâep. Yohaneŋe Yesu togombo ekmâ hain dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Akto emet hauŋdo Yohane hoŋ bawalogâtŋe olop kili. ");
INSERT INTO tim_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kinbiâ ainâk Yesuŋe togombo ekmâ Yohaneŋe hin makyetkiep, “Eget, Anutugât lama togoâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hain dâmbo den are nâŋgâm âmâ Yesu waliat. Watbela yâk olop ariyi. ");
INSERT INTO tim_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuŋe purik katmâ yelekmâ hin makyetkiep, “Yet wangât watnektat?” dâmbo hin magaŋiat, “Tiksa, yâgâten ariwerât?” dâmbela ");
INSERT INTO tim_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","hin dâm makyetkiep, “Gambela olowâk arine.” dâmbo âgâmbela ariyi. Arim emet dewunŋe ge kulukberâm akto yâk olop tali. ");
INSERT INTO tim_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Akto gala bikŋe Yohanegât den nâŋgâm tali amâ Anderea Simoŋgât emiŋe. ");
INSERT INTO tim_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yâkŋe dowâk arim teuŋe Simoŋ mem miawakmâ hin magaŋep, “Netŋe Mesaia ektet.” dâep. Akto Mesaia kot aregât purikŋe amâ Anutuŋe huŋgunaŋdo giep. ");
INSERT INTO tim_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hain dâm Yesugâlân kewugum arimbo Yesuŋe Simoŋ ekmâ hin magaŋep, “Gâ Yohane siâ yâkgât nanŋe hinŋe kotge siâ Petoro gogondân.” dâep. Kot aregât purikŋe amâ kât. ");
INSERT INTO tim_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Akto agatmâŋân Yesuŋe Galilaia hânân ariwerâm kinmâ Pilipo miawagaŋmâ kinmâ hin magaŋep, “Gâ gutmenâ nâ olop mande.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo akto Anderea akto teuŋe Petoro akto yâk hârok kepia yeŋe konok kotŋe Besaida ain manmini. ");
INSERT INTO tim_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Akto Pilipoŋe hepun yekmâ Natanae miawagaŋmâ hin magaŋep, “Moseŋe den kârikŋe kulemgoep akto Propete gai kulemgoyi. Luâk are emelâk miawakto ekten. Yâk amâ Yosepegât nanŋe dâmaen Nasarete kepian gâtŋe.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Hain dâmbo hin dâep, “Nasarete kepian kembu humo âlepŋe siâ miawakbiap me?” dâep. Hain dâmbo Pilipoŋe hin magaŋep, “Maktât are bâin togom ek.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hain dâmbo Natanaeŋe Yesugâlân togombo Yesuŋe yâkgât hin makyeŋgiep, “Imâ Israe luâk bunŋe biwiŋân den hiaŋgi siâ bo tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hain dâm makto Natanaeŋe aikom hin dâep, “Gâ wânângen mandere nektâtgât maktât?” dâmbo Yesuŋe hin magaŋep, “Pilipoŋe bo gogondoân lâwin keiŋân tatmenâ gektân.” ");
INSERT INTO tim_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","dâmbo Natanaeŋe hin magaŋep, “Apo, gâ bundâk Anutugât nanŋe Israe nengât luâk Humo.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Hain dâmbo Yesuŋe hin magaŋep, “Lâwin keiŋân tatâtgât makmâ miawak giŋdân are amâ ekmâ nâŋgât imâ keiŋeâk. Dâ bunŋaet keiŋe hâmbâi ekmâ nâŋgâm manbiat. ");
INSERT INTO tim_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nâ den bunŋe makyeŋgire nâŋgâŋet. Yeŋe himbim pâroŋ âgâmbo Anutugât aŋelolupŋande nâ luâk akmâ mandân nâŋgât kautnân âgâm gembiâ yekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Akto âi meme lâuwâ bo akto Kana kepian Galilaia hânân luâk siâ âmbenŋâi bâtyetŋe mem menduguwerâm aregât sot om nemberâm agi. ");
INSERT INTO tim_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Akto sot amboŋande makto Yesu memeŋe akto ikiŋe hoŋ bawalupŋe oloŋyekto ariyi. ");
INSERT INTO tim_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Akto mendugum waiŋ nembiâ bo akto Yesu memeŋande magaŋmâ hin dâep. ");
INSERT INTO tim_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Waiŋ bo aknengiâp.” dâmbo hin magaŋep, “Meŋ, nâmâ âi keiŋe katmâ membiangât sop irawot miawakbiap. Aregât wangât hain maktât?” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","memeŋande emet amboŋaet hoŋ bawa are hin makyeŋgiep, “Nannande wan me wangât makyeŋgimbo amâ hain akŋet.” dâep. Akto emet ain umbâ bât biken konok tali. ");
INSERT INTO tim_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuda luâk âmbâle bâtyeŋe me hâkyeŋe hokboâk pulim maligât emet ain umbâ 6 hainâk tatyeŋgiep. Umbâ amâ bâlensiâ bo. Humomo tatyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Akto Yesuŋe emet aregât hoŋ luâk hin makyeŋgiep, “Ye tu hâgâm kâimbiâ umbâ pigâk.” dâm makyeŋgimbo hâgâm kâimbiâ pigep. ");
INSERT INTO tim_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hain akbiâ hin makyeŋgiep, “Ye tu bikŋe hâgâm sot damunŋe yâkgâlae mem arim waŋŋet.” dâep. Hain dâmbo hâgâm mem ariyi. ");
INSERT INTO tim_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Akto sot amboŋande nem ekmâ pâpkoep. Dâ hoŋ luâk hâgâm kâimbiâ giep arekŋe amâ waiŋgât keiŋe nâŋgâyi. Akto sot amboŋe arekŋe âmâ luâkŋe âmbâle memberâm agep are oloŋmâ hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Nen hin akmaen. Ulik gulik waiŋ ukenŋe yeŋgienŋe nem tepyeŋe pikto hamiŋân waiŋ pâlâmŋe yeŋgimaen. Dâp nenŋe hain yendâp. Dâ gâŋe âmâ mem purikmâ ukenŋe are heambukmenâ tato tu yânŋe bo akto waiŋ âlepŋe dondâ mem miawaktât.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Imâ Yesu Kana kepian Galilaia hânân kulem memeŋe are keiŋe katmâ ikiŋaet kulem mem miawagep. Akto hoŋ bawalupŋande are ekmâ Yesu nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Akto Yesu Kana kepianba Kapanaum kepian ariep. Ain emilupŋe akto hoŋlupŋe olop ariyi. Akto ain hilâm amon siâ mali. ");
INSERT INTO tim_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Akto sop ain Yuda luâk âmbâle hârok hombaŋ kotŋe Pasowa are tâlâgumbo âmâ Yesu Yerusalem kepian âgâm ariep. ");
INSERT INTO tim_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akto sumbe kat kat emetŋe ain sumbegât lama bulimakao akto lâut mem kinmâ aŋgimini. Akto puli mem aŋgi goaŋgi akmâ tali. ");
INSERT INTO tim_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hain akmâ kinbiâ Yesuŋe tâk kârikŋe siâ mem bigeim arekŋe luâk me lama me bulimakao are hârok orem watyekto ariyi. Akto puli kat katgât are mem agatmâ pando kâwulagep. ");
INSERT INTO tim_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akto lâut kembâ mem kili are hin makyeŋgiep, “Ye Ewenaet emelan kotŋe hârok siâ siâ akbiâ aŋgim nene emetŋe aktâp. Ye hain bo akbei.” ");
INSERT INTO tim_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesuŋe hain akto âmâ Anutugât denŋande magepgât hin nâŋgâyi, “O Anutu luâk âmbâle bikŋande gâŋgât emelan akbiâ bâlimbo kambiamne kâlâp dondâ aktâp. Akto hilâlâm niŋmap.” ");
INSERT INTO tim_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Akto Yuda humomolupyeŋande Yesuŋe den magep are nâŋgâm aikom dâyi, “Gâ wan me wan ire memat aregât kulem memeŋe wan memenâ keige ekne?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","hin dâep, “Yeŋe sumbe kat kat emetŋe ire patakombiâ nâŋe âlepŋe hilâm âlâwu kâlegen ketuguwom.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hain dâm makyeŋgimbo hin dâyi, “Bâe, humomolupnenŋande sumbe emetŋe ire hombaŋ 46 kâlegen mem meteyi. Dâ gâŋe amâ hilâm âlâwu kâlegen metewâtgât maktât amâ nâŋgâenŋe bâliâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesuŋe amâ ikiŋe hâkŋaet magep. ");
INSERT INTO tim_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Manmâ siân kombiâ mom golâ akmâ agatbiap aregât magep. Aregât sop ain hoŋ bawalupŋande den magep aregât nâŋgâyi. Akto areâk bo. Anutuŋe makto kulemgoyi a hainâkgât hârok nâŋgâmbiâ bunŋe agep. ");
INSERT INTO tim_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Akto Yesu hombaŋ kotŋe Pasowa tatalân Yerusalem kepian manmâ kulem keiŋe keiŋe memeŋe siâ mendo luâk âmbâle undupŋe ekmâ kotŋe makmâ nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dâ Yesu ikiŋak âmâ luâk biwiyeŋe ekmâ nâŋgâm metiepgât yâk yeŋgât den bo nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Akto luâk hain biwiyeŋe yekmâ nâŋgânlep aregât akmâ âmâ luâk siâgât keiŋe nâŋgâwerâm gât bo makmâ aiyeŋguep. ");
INSERT INTO tim_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Akto Parisaio yâk yeŋgâlân gâtŋe siâ malep kotŋe Nikodemo yâk Yuda yeŋgât luâk kembuyeŋe yeŋgât humo malep. ");
INSERT INTO tim_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Luâk arekŋe Yesugâlân hândâgân togom hin magaŋep, “Apo, nen gâŋgât keige nâŋgâen. Gâŋe âi memat are luâk siâŋe Anutuŋe bo tângombo âmâ âi hainare bo memap. Aregât gâ Anutuŋe kârikŋe giŋdo âi memâk kindât nâŋgâen.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Hain dâmbo hin magaŋep, “Nâ hin makgiŋdere nâŋgâ. Nanaŋ gurukŋe akmai dop hainâk lâuwâŋe bo miawakbai âmâ Anutuŋe bo damunyeŋe akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Hain dâmbo hin dâep, “Yae, nen emelâk kaulem meteyion aregât gain gain nanaŋ hinare akmâ lâuwâŋe miawakbaen? Gain gain akmâ memelupnenŋaet tepyeŋân lâuwâŋe yendenŋe menenekbai?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Hain dâmbo hin dâm magaŋep, “Hin makgiŋdere nâŋgâ. Memelupyeŋande meyekbiâ manmanyeŋe miawagep. Dâ Anutugât Heakŋande meyekto âmâ irakŋe akmâ nanŋe baratŋe irakŋe miawakbiâ Anutuŋe damunyeŋe akbiap. Dâ benŋe siâŋe hain bo nâŋgâwiap âmâ bo miawagaŋbiap. ");
INSERT INTO tim_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Aregât hin makbe. Memelupyeŋande luâk hâgâk meyekmai. Dâ Anutugât Heakŋande memeŋe akyeŋgimbo âmâ Anutugât pat akbai. ");
INSERT INTO tim_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Luâk âmbâle irakŋe miawakŋetgât makgiŋdere nâŋgâmenâ bo hâumgoâk. ");
INSERT INTO tim_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Akto seru amâ hanâk hanâk waitmap. Akto gâ munŋeâk amâ nâŋgâmat. Dâ keiŋe wanânba miawakmâ togomap me wanân ari bo akmap amâ bo nâŋgâmat. Dop hainâk Anutugât Heakŋande han kalem akmâ luâk âmbâle bikŋe potat yekmâ kaut yeŋân mendo Anutugât pat akbai. Aregât keiŋe hainâk bo nâŋgâmat.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Hain dâmbo hin magaŋep, “Woe, hain maktât are amâ gain gain hain akbiap?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hain dâm aikombo hin dâm magaŋep, “Gâŋe amâ Israe luâk âmbâle Anutugât keiŋe makyeŋgimat. Akto maktân aregât keiŋe bo nâŋgât aregât âmâ gain gain den makyeŋgiwiat? ");
INSERT INTO tim_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aregât hin makgiŋdere nâŋgâ. Nenŋe wan me wan nâŋgâm ekmaen areâk makmâ makgiŋden gârâmâ dengât hâkâŋ akbai. ");
INSERT INTO tim_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Akto nâ hângât wan me wan owâiŋe aregât makgiŋdere are hanâk bo nâŋgâm heŋgemgoât. Aregât wan me wan umatŋe himbimânba miawakmap aregât makgiŋdere âmâ nâŋgâmenâ umatŋe humo akto gain gain nâŋgâm heŋgemgowerât? ");
INSERT INTO tim_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Anutuŋe huŋgun niŋdo himbimânba hânân gem luâk akmâ manmâ gan nune konok himbimân âgân. ");
INSERT INTO tim_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Akto Moseŋe ulikŋân hân yânŋângen niambi sâmbâ otneŋe lâwinân hikom mem agalep. Dop hainâk âmâ luâk akmâ mandân nâ lâwinân hikonekmâ mem agat nekbai. ");
INSERT INTO tim_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Aregât niŋemaŋe nâ nâŋgâ niŋmâ biwiyeŋe nâŋgâlân katbiâ manman kârikŋân manmâ âgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anutuŋe luâk âmbâle hânân manmai okot dondâ nâŋgâ yeŋgimap. Aregât nanŋe konok are bo gangerâm hanâk luâk âmbâle bikŋe are nâŋgaŋbai arekŋe siâ bo hilip agum âmâ manman kârikŋe peniaŋmâ manbai aregât huŋgun aŋdo hânân ge manmâ dumyeŋân kilep. ");
INSERT INTO tim_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anutuŋe nanŋe huŋgun aŋep amâ luâk âmbâle den âiân bo kat yekbiapgât huŋgun aŋep. Amâ luâk âmbâle dosayeŋe bo akto heŋgem yeŋguâkgât huŋgunaŋdo giep. ");
INSERT INTO tim_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Akto yeŋe yâkgât nâŋgaŋmâ hanyeŋande hikom biwiyeŋe yâkgâlân katbiâ amâ sop bâiŋân den âiân bo katyekmâ den sami bo makyeŋgiwiap. Dâ bikŋande Anutugât nanŋe konok aregât kotŋe nâŋgâm biwiyeŋân bo katmai aregât emelâk den âiân manmâ gambiâ dosayeŋaet hâuŋe miawakbiap aregât pat aktâp. ");
INSERT INTO tim_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Akto hâuŋaet keiŋe hin yendâp. Yesuŋe Anutugât pagaleŋe yâkŋe hânân miawakto luâk âmbâle bikŋe, “Agak memenenŋe ekbâi.” dâm hândâk kâlegen nâŋgâmbiâ humo agep aregât heambukmâ pagaleŋaet hâkâŋ akmai. ");
INSERT INTO tim_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Aregât bâleŋe memapŋe pagaleŋe hamiaŋmap. Akto bikŋande agak memenenŋe ekbâi dâm pagaleŋân bo kinmai. ");
INSERT INTO tim_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dâ den bunŋe lokomapŋe âmâ Anutuŋe ikiŋe âi keiŋe hutyeŋân ketugumap are luâk âmbâle ekŋet dâm pagaleŋân manmap. ");
INSERT INTO tim_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu akto hoŋ bawalupŋe Yerusalem kepia hepunmâ Yudaia hânân arim mali. Ain manbiâ Yesuŋe makto luâk âmbâle bikŋe tuân mem katyegi. ");
INSERT INTO tim_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Akto sop ain amâ Heroteŋe bo makto âmâ Yohane kala busi kâlegen boâk katbiâ malep. Aregât Yohaneŋe hân kotŋe Ainoŋ ain ariep. Ainoŋ amâ Salim ginŋân. Akto tu dondâ ain yiepgât ain arim luâk âmbâle yâkgâlân arimbiâ tu puliyegep. ");
INSERT INTO tim_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Akto Yohane tu puli luâk hoŋ bawalupŋande Yuda luâk siâ Anutugât dewunŋân dosayeŋe bo miawakbiapgât aikoyi. Aikombiâ magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hain akmâ aregât Yohane gâlân togom Yesugât magi, “Apo, gâ Yodaŋ tu biken manmenâ luâk siâ gâŋgâlân togombo keiŋe makmâ miawak nengien yâkŋe hinŋe luâk âmbâle dondâ tu puliyektâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Hain dâmbiâ hin dâm makyeŋgiep, “Anutuŋe bo hekat nengimbo dâine amâ gain gain akmâ nâŋgâwâen? Bo. ");
INSERT INTO tim_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Akto nâ Anutuŋe huŋgun aŋdo gewiap dâmai are bo. Dâ yâkgât enemŋân âmâ emelâk togoân dâre emelâk nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aregât den ginŋe hin makyeŋgire nâŋgâŋet. Âmbâle yâkgât dâtâŋe arekŋe âmbâle mendo galaŋande galagât den are nâŋgâm heroŋe humo nâŋgâmap. Dop hainâk Anutuŋe nanŋe huŋgun aŋdo giep yâkgât pat nâŋgâm heroŋe humo nâŋgân. ");
INSERT INTO tim_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yâkŋe miawakmâ humo akmâ âgâwiap. Dâ nâŋe âmâ yâkgât amukŋân manbian. ");
INSERT INTO tim_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Luâk âmbâle hânân manmai arekŋe hângât pat areâk makmai. Dâ yâk âmâ himbimgât patŋe aregât hârok ewangi nenekmap. ");
INSERT INTO tim_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yâkŋe siâ siâ ekmâ nâŋgâep aregât den patŋe makmap. Dâ luâk âmbâle hârokŋe yâkgât denŋe bo nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Luâk siâ Anutugât nanŋaet den nâŋgâmbo dâtŋe akto hin dâmap, “Anutu bunŋe amboŋe.” dâmap. ");
INSERT INTO tim_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aregât keiŋe hin. Anutuŋe nanŋe huŋgun aŋdo giep arekŋe amâ Anutugât denâk makmap are Anutuŋe ikiŋe Heakŋe bo gangerâm âmâ hârok waŋmap. Dâ getek bo. ");
INSERT INTO tim_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Akto areâk bo. Anutuŋe ikiŋe nanŋe ekmâ heŋgemgom okot âlep agaŋmâ wan me wan hârok waŋep. ");
INSERT INTO tim_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aregât Anutugât nâŋgâ aŋbiâ âgâwiap. Dâ luâk âmbâle bikŋe Yesugât den bo nâŋgâm manmaiŋe manman kârikŋe âlepŋe bo membai. Akto Anutugât kambiam bâle arekŋe yâk yeŋgâlân emelâk miawaktâp. Akto miawakmâ âgâwiap.” ");
INSERT INTO tim_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Akto sop ain parisaio luâk âmâ hin nâŋgâyi, “Yesuŋe luâk âmbâle dondâ mem tuân katyegep. Haingât Yesugât kâmotŋande amâ Yohane tu puli luâk yâkgât kâmot ewangiyegep.” nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Den are yân magi. Yesu ikiŋak âmâ tu bo puliyegep, hoŋ bawalupŋe yâk yeŋgât makto yâkŋe puliyegi. Yesuŋe Parisaioŋe magi are nâŋgâm âmâ ");
INSERT INTO tim_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","hân kotŋe Yudaia hepunmâ Galilaia hân ain ariwerâm agep. ");
INSERT INTO tim_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ain ariwerâm akmâ benŋe Samaria hânân hâtikowerâm kârikŋe akmâ ariep. ");
INSERT INTO tim_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Arim arim hilâm siân kepia siâ kotŋe Sika ain togoep. Akto ulikŋân dondâ Yuda yeŋgât hakuyeŋe Yakobo arekŋe nanŋe Yosepe hân are waŋep. ");
INSERT INTO tim_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Akto ain amâ Yakoboŋe tu lâmŋe kendâep ain togombiâ Yesu hilâm tânâmŋân hâkŋe kâlâp akto dâp togoyigât ongâ aŋdo tu lâmŋe aregât ginŋân talep. ");
INSERT INTO tim_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ain tato luâklupŋe hepunmâ sot puligowerâm kepiangen âgâyi. Âgâmbiâ Samaria gâtŋe âmbâle siâ tu hâgâwerâm togoep. Togombo Yesuŋe hin magaŋep, “Tu siâ hâgâm niŋmenâ nembe.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Akto Yuda luâk âmbâle arekŋe Samaria gâtŋe hâkâŋ yekmâ hami yeŋgimai aregât âmbâle arekŋe hin dâep, “Yae, gâ Yuda luâk arekŋe wangât nâ Samaria âmbâle tugât makniŋdât?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Hain dâmbo hin magaŋep, “Nâmâ tugât makgiŋdân. Nâŋgât keine bo nâŋgât. Nâmâ Anutu wan me wan yeŋgiwiapgât keiŋe amâ nâ aregât bo nâŋgâniŋdât. Nâŋgâniŋdât dâine ulit niŋmenâ manmangât tu bunŋe giŋbom.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hain dâmbo âmbâle arekŋe hin magaŋep, “Apo, tu lâmŋe ire amâ kâlep akto gâ tu hâgâ hâgâge bo mendât aregât tu bunŋe wanânba hâgâwerât? ");
INSERT INTO tim_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Akto bâginenŋe Yakobo yâkŋe lâm ire kendâm ikiŋe akto nanlupŋe akto lama bulimakao akto soŋgo baulupŋe ireâk nem manmini. Akto hakulupnenŋe tu iren hâgâm nem gambiâ gambiâ lâm ire hainâk kindo hâgâmaen. Aregât gâŋe Yakobogât dâp gain gain ewangiwât?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Hain dâmbo Yesuŋe hin dâep, “Tu iren nembai âmâ tugât lâuwâŋe nâŋgâwai aregât hokboâk hokboâk nem nem manbai. ");
INSERT INTO tim_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dâ tu yeŋgire are nembiâ âmâ biwiyeŋân tu dewunŋe hainare miawakmâ manman kârikŋe aregât dâp miawakbiap. Aregât tugât lâuwâŋe bo nâŋgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Hain dâmbo hin dâep, “Apo, hokboâk hokboâk togo hâgâm kinbomgât gâŋe tu are niŋmenâ tugât lâuwâŋe bo nâŋgâwian.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hain dâmbo Yesuŋe hin magaŋep, “Bâin, arim luâkge oloŋmenâ togoet.” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","âmbâle are hin dâep, “Nâ luâkne bo.” dâmbo magaŋep, “Gâ luâkne bo maktât amâ bundâk maktât. ");
INSERT INTO tim_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gâ luâk momerâk mem hepun yekmâ gaen. Dâ hinŋe mem mandât amâ gâŋgât luâkge bo aregât gâ den bunŋe maktât.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hain dâmbo hin magaŋep, “Yae, apo, gâmâ propete are yeŋgâlân gâtŋe nâŋgân. ");
INSERT INTO tim_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Humomolupnenŋande borâŋe iren Anutugât kotŋe mem agali. Dâ Yuda luâk yeŋe amâ Yerusalem kepian Anutugât kotŋe mem agatne dâmai.” dâm magaŋep. ");
INSERT INTO tim_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Hain dâmbo hin magaŋep, “Barat, nâ makgiŋdere nâŋgâ. Sop siâ tâlâguâp are miawakto yeŋe Apogât kotŋe mem agatbai amâ borâŋe iren bo. Akto Yerusalem kepian hainâk bo akbai. ");
INSERT INTO tim_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Dâ hinŋe ye Samaria gâtŋe âmâ Anutugât kotŋe pâpkomai. Gârâmâ Yuda nengâlânba heŋgemgo heŋgemgogât dâp miawakbiap dâmaen aregât nen âmâ Anutugât kotŋe mem agatbaengât dâp nâŋgâm heŋgemgomaen. ");
INSERT INTO tim_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hinŋe Apoŋe kotŋe mem agatŋetgât dâm egâliaŋ yekmap yâkŋe han biwiyeŋân den bunŋaet makmâ kotne mem agatŋet dâwiapgât sop emelâk miawaktâp. ");
INSERT INTO tim_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu amâ luâk hinare bo. Yâk amâ Heakŋe hainâk miawakmap. Aregât Heakŋe huŋgunaŋdo owâiŋe ketuguyekto Anutugât den nâŋgâmbiâ humo akto âlepŋe kotŋe mem agatbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Hain dâmbo hin magaŋep, “Hain gârâmâ Anutuŋe huŋgunaŋdo gewiap Kristo arekŋe miawakmâ wan me wan akmaen are âlepŋe makmâ miawak nengiwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hain dâmbo Yesuŋe hin dâep, “Hain dâm maktât amâ nâ iregâten, yu makgiŋdân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Akto luâklupŋe sot hâukom togom Yesuŋe âmbâle den magaŋep aregât ekbiâ hâumgoep. Aregât Yesu, “Gâ wan aktât.” hain dâm bo aikom magaŋi. Akto, “Wangât den magaŋdât?” hain dâm magaŋberâm nâŋgâmbiâ umatŋe akto bo aikom magaŋi. ");
INSERT INTO tim_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Akto âmbâle are tu asap are hepunmâ kepiangen pârigim ariep. Arim kepia ambolupŋe yeŋgondo togombiâ hin dâm makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Yae, luâk siâ nâŋe ulikŋân wan me wan akmâ manmâ gan aregât keiŋe hârok nâŋgâm makniŋdâp. Yâk amâ Anutuŋe huŋgun aŋdo gewiap dâmai are me aŋgâ aregât pârigim ari hekat yeŋgire ekŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hain dâm makyeŋgimbo ekberâm togoyi. ");
INSERT INTO tim_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dâwân togom manbiâ ain luâklupŋande Yesu hin magaŋi, “Apo, sot ne.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","hin dâep, “Nâ bo nemberân. Sot siâŋaet yeniŋdâp are yeŋe bo nâŋgâmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hain dâmbo aregât yâkŋe magaŋgi goaŋgi akmâ hin dâyi, “Siânbaŋe sot mem togo waŋdâi me?” hain nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hain dâmbiâ, Yesuŋe hin dâep, “Apo huŋgun niŋep yâkgât lauŋe lokom âiŋe mem metewian aregât ukenŋe nâŋgân. Lauŋe lokom âi emelâk mendân aregât tepne pâlâmŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Akto dewutâ imbât akto sot bunŋe miawaktâp are dâmai. Ye âmâ miwindik akmâ dewunyeŋe panmâ âiyeŋe ekŋet. Manman kârikŋân ariwaigât âiyeŋe emelâk bunŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Luâk sot bunŋe akto orem mem mendugum katmapŋe âmâ âigât hâu memap. Akto bunŋande âmâ manman kârikŋaet pat akbiap. Hain akmâ âmâ luâk siâŋe alekŋe kâmelep are olop heroŋe maroŋe akbiandatgât. ");
INSERT INTO tim_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aregât keiŋe den ire bunŋe miawakmâ kârigemap, “Siâŋe alekŋe kâmetmap. Dâ siâŋe sot bunŋe memap.” ");
INSERT INTO tim_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Akto nâŋe ye alekŋe bo kâmeligât sot bunŋe orem mem mendugum katŋet dâm huŋgunyeŋgiân. Aregât âi amâ yeŋe luâk bikŋande âi mem maligât bunŋe miawakto membai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Akto Samaria âmbâle arekŋe kepia aregât ambolupŋe hin makyeŋgiep, “Wan me wan meân amâ hârok makmâ metem makniŋdâp.” dâep. Amâ luâk âmbâle dondâŋe den are magepgât Yesu nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bâin, togom âmâ Yesu hin wârakmâ magaŋi, “Gâ nen olop man.” dâm magaŋi. Magaŋbiâ Yesuŋe den nâŋgâ yeŋgim yâk yeŋgâlai âi meme hilâm lâuwâ malep. ");
INSERT INTO tim_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Akto Yesuŋe ikiŋe keiŋe makyeŋgimbo dondâŋe nâŋgâm biwiyeŋe Yesugâlân katmâ nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aregât âmbâle are hin magaŋi, “Ulik gulik gâŋgât dengât akmâ Yesu nâŋgâ aŋion. Dâ hinŋe amâ nenŋeak lauŋânba den nâŋgâm hin nâŋgâen. Luâk imâ bundâk hân hârok nen heŋgemgo nenekbiapgât kârikŋe talaŋdâp.” dâm magaŋi. ");
INSERT INTO tim_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Akto Yesuŋe âi meme hilâm lâuwâ bo akto Samaria hân hepunmâ Galilaia hân ariep. ");
INSERT INTO tim_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Akto Yesuŋe ikiŋaet ulik gulik hin magep, “Propete siâ ikiŋaet kepiaŋân mando kepia ambolupŋande denŋe bo nâŋgâ aŋbai.” hain dâep. Aregât ain ariep. ");
INSERT INTO tim_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Akto Galilaia luâkŋe hombaŋ tatalân Yerusalem kepian manbiâ Yesuŋe kulem siâ siâ miep are egigât Yesuŋe togombo gala agaŋi. ");
INSERT INTO tim_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Akto Kana Galilaia hânân emelâk tu makto waiŋ agep ain lâuwâŋe ariep. Ain arim Kapanaum ain kiap siâ talep aregât nanŋe kundat humo dondâ agep. ");
INSERT INTO tim_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aregât Yesuŋe Yudaia hân hepunmâ Galilaia hân togoep dâmbiâ nâŋgâm kiap are Kapanaum kepia hepunmâ gem togoep. Togom Yesu hin magaŋep, “Nanne momberâm aktâp aregât nâ olop arim heŋgemgowen.” dâm wâragep. ");
INSERT INTO tim_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Akto Yesuŋe hin magaŋep, “Woe, yeŋe kulem me wan me wan ekbiâ dâtŋe akmap aregât ukenŋe nâŋgâmai. Dâ ekmâ âmâ biwiyeŋe nâŋgâlân bo katmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hain dâmbo hin dâep, “Apo, nanne mombopgât dowâk arim heŋgemgowen.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hain dâmbo hin magaŋep, “Bâin, ari. Nange âlepŋe aktâp.” dâmbo Yesugât den are biwiŋân katmâ yânâk pârigim ariep. ");
INSERT INTO tim_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dâwân arimbo hoŋ bawalupŋande togom peniaŋmâ hin dâm magaŋi, “Nange âlepŋe agep.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hain dâmbiâ hin aiyeŋguep, “Amuten âlepŋe agep?” dâmbo, “Uran hilâm tânâmŋe akto kundatŋe hepulep.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hain dâmbiâ kiap arekŋe hin nâŋgâep, “Woe, Yesuŋe sop magep ainâk nanne âlepŋe agep.” are nâŋgâep. Aregât biwiŋe Yesugâlân kalep. Akto ikiŋe kâmotlupŋe ainâk biwiyeŋe Yesugâlân kali. ");
INSERT INTO tim_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Akto Yesu emelâk Yuda hânânba Galilaia hânân togom tatmâ kulem keiŋe mendo lâuwâŋe are agep. ");
INSERT INTO tim_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aregât hamiŋân Yuda yeŋgât hombaŋ humo miawakto Yesu Yerusalem kepian âgâep. Sop ain amâ âi meme sopŋe bo. ");
INSERT INTO tim_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Akto Yerusalem kepia aregât hâŋgi siâ kotŋe amâ Lama hâŋgi aregât giŋân amâ tu bâtgum siâ talep kotŋe Betesida. Akto bâtgum aregât dâtŋe amâ momerâk talep. ");
INSERT INTO tim_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Akto dâp ain amâ luâk kundatdâ akto dewunyeŋe bok bokŋe akto keiyeŋe bâleŋe hainare dondâ yem tali. ");
INSERT INTO tim_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Akto Humogât aŋelo siâŋe tu bâtgumŋân aren sopanmâ lawagumbo munŋe akminep. Akto tu munŋe nâŋgâm kundatdâ siâŋe soŋ geminep arekŋe soŋ âlepŋe akminep aregât kundatdâ dondâ are tu duwuŋ agâk dâm lâmgom kinmini. ");
INSERT INTO tim_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Akto kundatdâ are yeŋgât hutyeŋân gâtŋe siâ amâ tato hombaŋ 38 bo agep. ");
INSERT INTO tim_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yâk âmâ tu bâtgum aregât ginŋân tatmâ tu duwuŋ agâk dâm lâmgoep. Akto Yesuŋe luâk sop kâlep yeminep are ekmâ hin dâm aikoep, “Gâ âlepŋe akberâtgât nâŋgât me?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hain dâmbo hin dâep, “Apo, âlepŋe akberâm nâŋgân amâ siâŋe bo tân nugumbo tu duwuŋ akto bâtgumân kat nekto âlepŋe akbom. Aregât nunak gewerâre âmâ siâŋe soŋ ulikŋân akmâ gemap arekŋe soŋ âlepŋe akmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hain dâmbo hin magaŋep, “Gâ agatmâ âkâ tem tâkge lokoakmâ ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hain dâmbo ainâk hâkŋe âlepŋe akto agatmâ tem tâkŋe are lokoakmâ ariep. Akto Yesu amâ luâk âmbâle dondâ kili are yeŋgât hut yeŋân ainâk tik palep. Akto sop ain amâ âi meme sopŋe bo. ");
INSERT INTO tim_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Aregât Yuda humomolupyeŋande luâk âlepŋe agep are ekmâ hin dâyi, “Uŋak amâ âi meme sopŋe boân tem tâkge lokom âmâ den kârikŋe tatmap are wangât ewangiât? Âi memenâ gektenŋe bo ârândâŋ aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hain dâmbiâ hin makyeŋgiep, “Nâ sop kâlep kundat akmâ yem gan. Ina uŋak âmâ luâk siâŋe makto yu âlepŋe aktân. Akto metip nuguâp arekŋe hin dâm makniŋdâp, “Tem tâkge lokoakmâ ari.” dâm makniŋdâp. Aregât âlepŋe aktân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hain dâmbo hin dâyi, “Wei, luâk are kotŋe konmenâ nâŋgâne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hain dâmbiâ luâk âlepŋe agep arekŋe Yesu luâk âmbâle dondâ kili are yeŋgât hutyeŋân dowâk tik palep aregât Yesugât kotŋe bo nâŋgâepgât. Akto kotŋe bo konmâ makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Manmâ Yesuŋe luâk aregât âsim kinmâ sumbe emetŋân ekmâ hin magaŋep, “Gâ emelâk âlepŋe aktât. Gârâmâ benŋe wansiâ umatŋe miawak giŋbopgât bâleŋe lâuwâŋe bo akben.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hain dâmbo luâk arekŋe Yesu ekmâ nâŋgâep. Ekmâ nâŋgâm âmâ arim Yuda humomolupyeŋe hin makyeŋgiep, “Luâk metip nuguâp amâ kotŋe Yesu.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesuŋe âi sopŋe boân âi are miepgât Yuda luâk humomolupyeŋande Yesu gasa agaŋi. ");
INSERT INTO tim_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hain akbiâ Yesuŋe togom hin makyeŋgiep, “Ewene amâ âi hilâmŋe hilâmŋe memap aregât nâkai hainâk meman.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesuŋe âi meme sopŋe boân âi miep aregât gasa agaŋi. Dâ hamiŋân Anutu Ewene dâm âmâ Anutu olop dop konok agep aregât nâŋgâmbiâ umatŋe dondâ akto gasa humo nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hain akbiâ Yesuŋe hin makyeŋgiep, “Nâ bunŋe dondâŋe makyeŋgire nâŋgâŋet. Nanŋande ikiŋe hanŋe watmâ âlepŋe âi bo memap. Eweŋande âi memap are ekmâ hainâk memap. Yâkŋe memap hainâgâk Nanŋande gai akmap. ");
INSERT INTO tim_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Akto areâk bo. Ewenande okot dondâ nâŋgâ niŋmap aregât âi memap are hârok hekat niŋmâ metiep. Akto âi emelâk mendere ektâi are konok bo. Anutuŋe ye âi humo tâmbâ ekbiâ dâtŋe humo akto han undup akŋetgât âi siâ humo tâmbâ hekat niŋdo membian. ");
INSERT INTO tim_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Amâ âi humo tâmbâ aregât keiŋe hin. Ewenande amâ momoŋe yeŋgonmâ goaŋ yekmap hainâk nâkai nâŋgâ nâŋgânaet watmâ luâk âmbâle bikŋe potatmâ manman âlepŋe yeŋgiman. ");
INSERT INTO tim_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Akto Ewene ikiŋe konok amâ luâk âmbâle bâleŋe akbai aregât hâuŋe den bo makmâ mete yeŋgiwiap âi are amâ nâ niŋdo dosayeŋe miawagâkgât den âiân katyekbian. ");
INSERT INTO tim_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Akto hinŋe luâk âmbâle bikŋande Ewene konmâ nâŋgaŋmai hainâk nâ nogonmâ nâŋgâ niŋbaigât âi are amâ niŋdo luâk âmbâle den âiân kat yektere nekmâ nâŋgâ niŋbai. Aregât luâk âmbâle siâŋe bo nogonmâ kotne mem agatmâ âmâ Ewene huŋgun niŋep are hainâk bo nâŋgaŋmai. ");
INSERT INTO tim_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Aregât hin makyeŋgire nâŋgâŋet. Luâk bikŋande nâŋgât den nâŋgâm biwiyeŋân katmâ Anutuŋe huŋgun niŋep aregât den bunŋe dâmai are amâ manman kârikŋe yeŋgiwian. Akto momogât dâp hepunmâ manmangât dâwân manbai aregât den âiân hâk tun aktere momogât dâp lâuwâŋe bo ekbai. ");
INSERT INTO tim_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Akto siâkâ makyeŋgire nâŋgâm heŋgemgombiâ âmâ humo akberâp. Sop siâ miawakbiap akto hinŋe miawaktâp amâ luâk âmbâle momoŋe sumân yemai arekŋe Anutugât nanŋe nâŋe yeŋgondere den are nâŋgâm agatmâ manbai. ");
INSERT INTO tim_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aregât keiŋe hin. Ewene amâ Manmangât Amboŋe dâm makniŋmâ memeŋe akniŋdo ");
INSERT INTO tim_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","gem luâk akmâ manmâ gan aregât kembu akmâ luâk âmbâle hâuyeŋaet makmâ miawakyeŋgiwian. ");
INSERT INTO tim_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Maktere nâŋgâmbiâ hâumgoâp me? Woe, siâ hin maktere nâŋgâmbiâ humo hâumgowerâp amâ hin. Sop siâ miawakto luâk âmbâle mom sumân yemai are yeŋgondere nâŋgât den nâŋgâm agatbai. ");
INSERT INTO tim_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Akto âlepŋe mali amâ manman kârikgât agatbai. Dâ manman bâleŋe akmâ mali hârok agatmâ dosa yeŋaet hâuŋe membai. ");
INSERT INTO tim_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nune nâŋgâ nâŋgânaet âi memegât bo yeniŋdâp. Akto Anutuŋe wan me wan makniŋmap den are lokom luâk âmbâle den âiân kat yekbian aregât nune nâŋgâ nâŋgâne bo watman. Ewene huŋgun niŋep yâkgât nâŋgâ nâŋgâŋe watmâ gan aregât den âiân katyekbiangât kârikŋe tatniŋdâp. ");
INSERT INTO tim_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nâ nune keine makman dâine bunŋe bo dâwâi. ");
INSERT INTO tim_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Siâŋe bunŋe mandâp aregât keine makmâ miawakto ârândâŋ akmap. ");
INSERT INTO tim_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Dâ ye âgâlân Yohane tu puli luâk are makmâ aikombiâ den bunŋe dondâ makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Amâ luâk nâŋgât keine makyeŋgimap yâkgât den nâŋgâre yânŋe aktâp. Gârâmâ yeŋe nâŋgât keine nâŋgâm heŋgemgombiâ heŋgem yeŋgure manman kârikgât pat miawak yeŋgiâkgât maktân. ");
INSERT INTO tim_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanegât keiŋe makyeŋgire nâŋgâŋet. Yohane amâ bundâk pagaleŋe humo akmâ pagaleŋe yeŋgiep aregât ye amâ yâkgât den nâŋgâm heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dâ Yohaneŋe nâŋgât keine makmâ miawagep den are amâ agak memenande ewangimap. Ewenande âi makmâ niŋep are hârok yu mendere nekbiâ Ewenande huŋgun niŋdo geân aregât keiŋe miawaktâp aregât den patŋe arekŋe Yohaneŋe magep are ewangiâp. ");
INSERT INTO tim_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dâ areâk bo. Ewenande huŋgun niŋep arekŋe keine makmâ miawagep. Dâ yeŋe amâ yâkgât lauŋânba den bo nâŋgâyi akto hâkŋe bo egi. ");
INSERT INTO tim_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Akto yâkgât den biwiyeŋân bo katbiâ tatâp. Denŋe biwiyeŋân katbiâ tatâp dâine Ewenande huŋgun niŋdo geân nâŋgât den nâŋgâm biwiyeŋe nâŋgâlân katbiâ âlepŋe akbop. ");
INSERT INTO tim_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ye hin nâŋgâmai, “Anutuŋe makto kulemgoyi are oyaŋmâ manman kârikŋe aregât keiŋe nâŋgâne.” dâmai aregât sopŋe sopŋe oyaŋmâ manmai. Dâ Anutuŋe makto kulemgoyi arekŋe nâŋgât keiŋe mem miawakmap. ");
INSERT INTO tim_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gârâmâ nâŋgâlân bo togom nâŋgâ niŋbiâ âmâ manman kârikŋe bo yeŋgiwian. ");
INSERT INTO tim_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Akto luâkŋe kotne mem agatŋetgât bo maktân. ");
INSERT INTO tim_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gârâmâ yeŋgât keiyeŋe âmâ nâ bundâk nâŋgân. Han biwiyeŋande ain Anutugât han kalamŋaet bo kinmap. ");
INSERT INTO tim_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nâ Ewenaet laugât yeŋgâlân geân. Akto ye hanâk gala bo akniŋmai. Dâ luâk siâ ikiŋe hanŋe watmâ togombo âmâ gala agaŋbai. ");
INSERT INTO tim_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Akto areâk bo. Keiyeŋe amâ hin nâŋgân. Yeŋaelâk heroŋe agaŋgimai. Akto yeŋaelâk kotyeŋe mem agalaŋgimai. Dâ Anutuŋe yekto huraguâkgât dâp bo heŋgemgomai. Aregât Anutu bo nâŋgâ aŋmai. ");
INSERT INTO tim_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","47","Akto yeŋe, “Moseŋe den kârikŋe kulemgoep are lokoenŋe huraguâk.” dâm nâŋgâmai amâ benŋe pâpkomai. Moseŋe nâŋgât keine ulikŋân ekmâ nâŋgâm heŋgemgom kulemgoep are lokomai dâine biwiyeŋe nâŋgâlân katbâi. Dâ Moseŋe kulemgoep aregât hâkâŋ akmai aregât nâŋgât den bo nâŋgâm heŋgemgomai. Aregât keiŋe hin. Moseŋe kulemgoep arekŋe agak memeyeŋe mem miawakmâ den âiân kat yekbiap aregât nâmâ Ewenaelân makmâ den âiân katyekbiangât âi bo tatniŋdâp. Emelâk Moseŋe makyeŋgiep aregât wangât lâuwâŋe nâŋe makyeŋgiwian?” dâep. Amâ Yesuŋe Yuda luâk humomolupyeŋande kuk agaŋbiâ den hâuŋe hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Akto aregât hamiŋân Yuda luâk âmbâle yeŋgât hombaŋ kotŋe Pasowa tâlâgumbo ain Yesuŋe Galilaia bâtgum kotŋe siâ Tiweria bâtgum are biken hâtikom ariep. Arimbiâ luâk âmbâle diwirâ kundatdâ dondâ heŋgem yeŋgumbo egigât hamiyeŋân togoyi. Akto Yesuŋe luâklupŋe kewuguyekto borâŋân âgâ tali. ");
INSERT INTO tim_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Akto Yesuŋe luâk âmbâle dondâ togombiâ yekmâ Pilipo biwiŋe dop komberâm hin magaŋep, “Pilipo wanânba sot mem puligom ire yeŋgienŋe nembiâ tepyeŋe pikberâp?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Dâ yâk amâ wan me wan akberâp aregât nâŋgâep. Amâ biwiŋe dop koep. ");
INSERT INTO tim_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Akto Pilipoŋe hin dâm magaŋep, “Woe, puli dondâ panmâ sot puligom mem yeŋgienŋe amâ bikŋandeâk sot mem nembiâ bikŋande yân tatberâi aten.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hain dâmbo yeŋgâlân gâtŋe siâ Petorogât emiŋe Anderea yâkŋe hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nanaŋ bâlensiâ yu kindâp yâkŋe sot momerâk akto iŋan lâuwâ mem kindâp. Dâ luâk kâmot dondâgât sot ire mem yeŋgienŋe bo ârândâŋ akyeŋgiwerâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hain dâmbo Yesuŋe makyeŋgiep, “Ye luâk âmbâle makyeŋgimbiâ mendugum ge tatŋet.” dâep. Akto hân ain umiliŋ yiep ain luâk 5,000 are hârok ge tali. ");
INSERT INTO tim_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Akto Yesuŋe sot mem Anutu mepaim aŋmâ luâk tatmâ ariyi yâk dopyeŋânâk yeŋgiep. Akto soŋgo hainâgâk makmâ dopyeŋân yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yeŋgimbo nem tepyeŋe pikto hoŋ bawalupŋe hin makyeŋgiep, “Sot pipiŋe yem bâliwopgât are pitim menduguŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hain dâmbo arim sot bikŋe bo neyi are mem haka kâlegen pitim lugumbiâ haka 12 pigep. ");
INSERT INTO tim_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Akto luâk âmbâle arekŋe kulem keiŋe are ekmâ nâŋgâm hin magaŋgi goaŋgi agi, “Propete humo hânân miawakbiap yâk lâmgomaen amâ ire emelâk miawaktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hain akmâ, “Hâwâtenŋe damun nenŋe akbiapgât akne.” dâm magaŋgi goaŋgi akbiâ yekmâ hepun yekmâ ikiŋeâk gimbâŋe siân âgâep. ");
INSERT INTO tim_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Akto emet dâgâmbo Yesu boâk togo penâyeŋgiepgât Kapanaum kepiangen purik katberâm bâtgum ginŋângen geyi. Ge kinmâ waŋgan âgâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Waŋgan âgâm hâtikombiâ seru kârikŋe panmâ kondo ariyi. ");
INSERT INTO tim_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yâkŋe dopŋe 4 me 5 kilomita aregât dopŋe bâtgum tânâmŋân arimbiâ Yesu haru kakŋân togom ewumâk akto ekmâ hamep akmâ sân sân meyi. ");
INSERT INTO tim_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Hain akbiâ yekmâ hin makyeŋgiep, “Nuneâk togoân aregât bo hamep akŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hain dâm waŋgan gawerâmbo âlepŋe dâmbiâ âgâep. Âgâmbo heroŋe akbiâ ainâk kepia ariwerâm agi are ewumâk akto ainâk waŋga are hânân hikoep. Hikombo hânân sopanmâ tali. ");
INSERT INTO tim_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tatmâ yem kinbiâ emet hauŋdo luâk âmbâle bâtgum biken tali are Yesugât undâgâtmâ hin dâyi, “Uran waŋga konok kindo egion ain hoŋ bawalupŋe yeŋeak Yesu hepunmâ âgâm ariyi.” hain nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hain nâŋgâm tatbiâ Tiweria kepianba waŋga siâ Humoŋe sot mem Anutu mepaiŋe miep ain togo kilep. ");
INSERT INTO tim_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Akto kâmot humo arekŋe Yesu akto luâklupŋe kulâgât yeŋgim waŋgan âgâm Kapanaum kepian purik katmâ arim Yesugât kulâgât aŋi. ");
INSERT INTO tim_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hain manmâ bâtgum iregen kulâgâtmâ ekmâ hin dâyi, “Apo, amuten togoen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Hain dâmbiâ hin makyeŋgiep, “Nâ bundâk makyeŋgire nâŋgâŋet. Nâ kulem keiŋe keiŋe mendere nekmâ agi aregât bo kulâgât niŋdâi. Akto keine ekmâ bo heŋgemgoâi. Sot yeŋgire nem tepyeŋe pigep aregât kulâgât niŋdâi. ");
INSERT INTO tim_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aregât hin makbe. Sot yoganŋe mem nembai aregât bo kulâgâtmâ âi mem manbei. Manman kârikŋe are miawak yeŋgiâkgât âi kârikŋe mem manbei. Akto Anutu Ewene arekŋe meme akniŋdo âi mendere negi aregât luâk akmâ geân nâ ulit niŋbiâ manman kârikŋaet sot âlepŋe yeŋgiwian.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hain dâmbo hin magaŋi, “Anutugât âi mem kulâgâtbei dât ina gain gain akmâ mem manbaen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hain dâmbiâ hin dâep, “Anutuŋe huŋgun niŋdo geân aregât biwiyeŋe nâŋgâlân katmâ âi are membiâ Anutuŋe yekto ârândâŋ akbiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hain dâmbo hin magaŋi, “Hain aregât benŋe kulem keiŋe keiŋe siâ memenâ âmâ ekmâ nâŋgâ giŋne. Akto gain gain memenâ ekmâ heŋgemgogiŋne? ");
INSERT INTO tim_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Akto Anutuŋe makto kulemgoyi aregât bikŋe hin yendâp, “Anutuŋe himbimânba sot yeŋgimbo nem mali.” hain yendâp aregât bâgilupnenŋande hân pumân manbiâ Moseŋe sot yeŋgimbo nemini.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hain dâmbiâ hin dâep, “Anutuŋe sot bunŋe yeŋgiep aregât keiŋe makyeŋgire nâŋgâŋet. Moseŋe himbimânba sot bo mem miawakmâ yeŋgiep. Bo. Himbimgât sot bunŋe amâ hinŋe Ewenande ye yeŋgimap. ");
INSERT INTO tim_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sot bunŋe are Anutuŋe himbimânba hânân pando gem luâk âmbâle hânân manmai manman kârikŋe mem miawak yeŋgimap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hain dâmbo hin dâyi, “Woe, apo, gâ sotgât maktât are hokboâk nengiwen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hain dâmbiâ hin makyeŋgiep, “Manmangât sot nâ ire yu miawaktân aregât ye nâŋgâlân gutmâ nâŋgâ niŋmâ biwiyeŋe nâŋgâlân katbiâ âmâ meme wâtŋe akyeŋgire himbimgât sot me tu aregât lâuwâŋe bo mopyeŋe aguwiap. ");
INSERT INTO tim_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nâ emelâk makyeŋgiân. Yeŋe nâ nekmâ heŋgemgom âmâ hanâk bo nâŋgâniŋdâi. ");
INSERT INTO tim_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Apoŋe niŋep yâkŋe hârok nâŋgâlân togom metewai. Akto nâŋgâlân togowiap yâk bo watmâ hâkokowian. ");
INSERT INTO tim_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Himbimânba geân amâ nâ nune ukenne watberâm bo geân. Huŋgun niŋep yâkgât ukenŋaet akmâ metewiangât geân. ");
INSERT INTO tim_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ewenande luâk âmbâle bikŋe nâŋgâlân katyekmap luâk are hilip aguwâigât yekmâ menduguyekmâ sop humoân ârândâŋ goaŋyektere agatbai. Are âmâ huŋgun niŋepgât han. Lau hain tatâp. ");
INSERT INTO tim_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Luâk âmbâleŋe nanŋe nâ nekmâ nâŋgâm kârigeniŋmâ nâŋgâniŋbai dopŋân manman kârikŋe ambo akbai. Are amâ Ewenaet den lau hainare tatâp. Akto nâŋe sop humoân golâ katyekbian.” ");
INSERT INTO tim_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hain dâmbo Yuda luâk âmbâle ain kili arekŋe Yesu himbimgât sot nâ ire dâepgât nâŋgâm bâliaŋmâ den agi. ");
INSERT INTO tim_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Akto hin magaŋgi goaŋgi agi, “Yâk, “Nâ himbimânba geân.” dâp are nâŋgâenŋe bâliâp. Yâk amâ Yesu mon? Nenŋe amâ eweŋe Yosepe akto memeŋe yelekmaen aregât himbimânba bo giep nâŋgâmaen aregât himbimânba geân dâmbo bo ârândâŋ aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hain dâmbiâ Yesuŋe are nâŋgâm hin makyeŋgiep, “Ye bo nâŋgâmbiâ bâliâk. ");
INSERT INTO tim_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ewene huŋgun niŋep arekŋe luâk âmbâle siâ oloŋdo hanŋeâk nâŋgâlân togowiap. Togombo âmâ sop humoân goaŋdere agatmâ manmâ âgâwiap. ");
INSERT INTO tim_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Akto Propete luâk den kulemgoyi are yeŋgâlân gâtŋe siâŋe hin kulemgoep, “Anutuŋe luâk âmbâle bikŋe ikiŋaet pat hekat yeŋgiwiap.” dâm kulemgoep aregât luâk âmbâle bikŋe Ewenande makyeŋgimbo âmâ benŋe nâŋgâm nâŋgâlân togowai. ");
INSERT INTO tim_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dâ luâk âmbâle hânân manmai yeŋe Ewene bo egi. Akto bo ekmai gârâmâ nâ konok Anutugât enem dewunŋânba geân nâŋe egân. ");
INSERT INTO tim_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","Aregât bunŋe makyeŋgiwe. Luâk âmbâle bikŋande nâŋgâ niŋbai amâ nâ amâ manman kârikŋaet sot aregât manman kârikŋe yeŋgire manmâ âgâwai. ");
INSERT INTO tim_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Manmangât sot aregât lâuwâŋe makbe. Bâgilupyeŋande hân pumân manbiâ Anutuŋe himbimânba sot pando gembo mem neyi. Akto manmâ âmâ mom meteyi. ");
INSERT INTO tim_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dâ sot himbimânba gemap amâ nâ ire. Aregât sot ire luâk âmbâleŋe nem âmâ bo mom metewai. ");
INSERT INTO tim_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aregât nâ manmangât sot himbimânba geângât luâk âmbâle bikŋe nâŋgâlânba sot nembai amâ dondâŋe manmâ âgâwai. Akto luâk âmbâle hânŋe hânŋe manmai are manman mem miawakŋetgât sunumnande sot aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hain dâmbo Yuda luâk âmbâle ain kili arekŋe magaŋgi goaŋgi akmâ hin dâyi, “Yâk gain gain akmâ sunumŋe nengimbo nembaengât maktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Aregât hin makyeŋgire nâŋgâŋet. Nâŋgât gilâm akto sunumne bo nembai amâ biwiyeŋân manman bo miawak yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Dâ yeŋgâlân gâtŋe bikŋande sunumne akto gilâmne nembiâ âmâ nâŋgât sunumne arekŋe sot bunŋe akto nâŋgât gilâmne are tu bunŋe akmap aregât manman kârikŋe yeŋgire manbai. Manmâ âgâmbiâ sop humoân goaŋ yektere manmâ âgâwai. ");
INSERT INTO tim_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Akto gilâmne sunumne nembaiŋe amâ nâŋgâ niŋmâ nâ olop manbai. Akto nâkai yâkgâlân manbian. ");
INSERT INTO tim_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Akto Ewene manman amboŋande huŋgun niŋdo geângât Apogât akmâ manman. Aregât yeŋgâlân gâtŋe sunumne akto gilâmne nembai amâ hainâk nâŋgât pat akmâ manbai. ");
INSERT INTO tim_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Akto bâgilupyeŋande sot nem manmâ âmâ moyi. Dâ nâŋgât sot ire himbimân gâtŋe sot bunŋe nembai amâ dondâŋe manmâ âgâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuŋe Kapanaum kepian manmâ den emetŋân kinmâ den ire makmâ ligim yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Akto Yesuŋe hain makto hoŋ bawalupŋe bikŋande magaŋgi goaŋgi akmâ hin dâyi, “Wei, imâ nâŋgâenŋe hâumgoâp aregât niŋande nâŋgâm metewerâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hain makmâ hâkâŋ agi are Yesuŋe biwiyeŋân ekmâ hin dâep, “Den are nâŋgâmbiâ bâliâp me? ");
INSERT INTO tim_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Gârâmâ ina benŋe nâ luâk akmâ geân ainâk purik katmâ âgâre nekbai amâ gain gain akbai? ");
INSERT INTO tim_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Akto nâŋgâ nâŋgâyeŋe akto han biwiyeŋande den nâŋgâm lokowaigât kârikŋe bo tatyeŋgimap. Akto Anutugât Heak yâkŋe konok manman mem miawakyeŋgimap aregât yâk den makyeŋgimap ina denne biwiyeŋân totokombo manman âlepŋe miawak yeŋgiwiap. Dennande tânyeŋgumbo Heakŋe akto manman kârikŋe miawakyeŋgiwiandat. ");
INSERT INTO tim_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dâ yeŋgâlân bikŋe amâ nâŋgâm biwiyeŋân bo katâi.” dâep. Amâ Yesuŋe yâkgât hâkâŋ agaŋmai are emelâk yekmâ nâŋgâep. Akto gasalupŋe kewugu yekbiap are gai emelâk nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akto den siâ hin dewatim makyeŋgiep, “Nâ aregât hin makyeŋgiân. Ewenande bo oloŋ yekto amâ nâŋgâlân bo togowai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yâkŋe hain dâep aregât luâklupŋe bikŋande den are nâŋgâm âmâ hâkâŋ akmâ hepunmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Arimbiâ Yesuŋe hoŋ bawalupŋe ulikŋân oloŋ yegep 12 are hin aiyeŋguep, “Ye hainâk hepun nekberâi me?” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Petoroŋe hin dâm magaŋep, “Humo, gâ hepun gekmâ âmâ niŋaelân arim manman âlepŋe me den kârikŋe nâŋgâwaen? Gâ guge konok manmangât den bunŋe maknengimat. ");
INSERT INTO tim_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Siâgâlânba bo aregât nen gâŋgâlân hokatmâ gâ Anutugât nanŋe bunŋe aregât nâŋgâ giŋmaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hain dâmbo hin dâm makyeŋgiep, “Aregât hin makbe. Nâŋe konok oloŋ yegân. Dâ yeŋgâlân gâtŋe konok amâ Hiaŋgi Amboŋande biwiŋân gemap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Amâ Yesuŋe ikiŋe luâklupŋe 12 are yeŋgâlân gâtŋe Yudasi Simoŋ siâgât nanŋe Karioto kepian gâtŋe yâkŋe gasalupŋe hekat yeŋgimbo membai aregât nâŋgâm magep. ");
INSERT INTO tim_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Akto Yuda gâtŋe bikŋande Yesu komberâm akbiâ aregât Yerusalem kepia hepunmâ Galilaia hânân togo malep. ");
INSERT INTO tim_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ain mando Yuda mâron emetŋaet hombaŋ ewumâk agep. ");
INSERT INTO tim_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ewumâk akto emilupŋande Yesu bo nâŋgaŋmâ hin magaŋi, “Luâk siâŋe keine mem miawakbian dâm yoŋâk bo manmâ âi memap. ");
INSERT INTO tim_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Amâ tektekŋân âi memap. Aregât kâmot bikŋande gâ kulem memat are ekbaigât gâ purik katmâ Yudaia hânân arim kulem memben. Akto âi in memat gârâmâ gâ ari luâk kâmot humoân miawakmâ tek tekŋân kinmâ âi memenâ gekmâ keige nâŋgâm heŋgemgowei.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Emilupŋande amâ bo nâŋgaŋmâ hain dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Ye hanâk wan me wan akberâm âmâ âlepŋe akbei. Dâ nâmâ hain bo akman. Sopŋânâk wan me wan meman. Miawakmâ tek tekŋân kinbiangât sop boâk miawaktâp. ");
INSERT INTO tim_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Haingât luâk âmbâle ye dopyeŋe konok. Akto gala katyekmai aregât kuk bo akyeŋgiwai. Dâ nâmâ luâk âmbâle agak memeyeŋe bâleŋe are makmâ miawakmâ yeŋgire nâŋgâmai aregât kuk bâleŋe akniŋmai. ");
INSERT INTO tim_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Akto nâ tek tekŋân miawakbiangât sop boâk miawaktâp aregât nâ hinŋeâk bo ariwerân. Dâ yeŋe amâ hombaŋgât ariŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","Hain dâmbo emilupŋande ulik gulik yâkŋe soŋ arimbiâ Galilaia hânân malep. Akto hilâm siân heambukmâ yoŋâk ariep. ");
INSERT INTO tim_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Akto hombaŋ miawakto Yuda luâk humomolupyeŋande Yesugât kulâgâtmâ aikom magi, “Yâk yâgâten mandâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dâ luâk dondâ arekŋe amâ yoŋâk yâkgât den dondâ magaŋgi goaŋgi agi. Akto bikŋande hin dâyi, “Yâk âmâ luâk âlepŋe.” dâyi. Dâ bikŋande âmâ den kom hin dâyi, “Bo, yâkŋe âmâ nen biwi gulip akŋet dâm den maknengimap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Akto Yuda luâk kembu are yeŋgât hamep akmâ den yoŋâk magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Akto hombaŋ hutŋân Yesuŋe Sumbe emetŋân âgâm den makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Makto Yuda luâk humomolupyeŋe arekŋe Yesu ekmâ hin dâyi, “Yâk âmâ nengât nâŋgâ nâŋgâ emetŋân bo malep. Ina ire gain gain akmâ nâŋgâmap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Nâ makyeŋgiân imâ nunaet den bo. Huŋgun niŋep arekŋe makniŋdo makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Akto luâk âmbâle Anutugât lau lokowerâm âmâ nâŋgât akto Anutugât den makmangât nâŋgâm heŋgemgomai. Dâ luâk âmbâle Anutugât lau bo lokomaiŋe âmâ nâŋgâ yâkgât hin nâŋgâmai, “Ikiŋaelânba den maknengimap.” dâmai. Amâ nâŋgâm hilip komai. ");
INSERT INTO tim_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Siâ ikiŋaelânba nâŋgâm makmap amâ ikiŋaet nâŋgâmbo humo akmap akto hâkŋe mem agatberâm akmap. Dâ nâmâ hain bo akman. Anutuŋe huŋgun niŋep yâkgât kotŋe mem agatman. Aregât âmâ kotne bo mem agatman. Akto bo hiaŋgiman. ");
INSERT INTO tim_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Akto Anutuŋe makto Moseŋe den kârikŋe kulemgoep. Ye den are bo lokomai aregât nuguwerâm aktâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hain dâmbo, “Woe, nen âmâ bo guguwerâm akten. Gâŋe are maktât amâ sinduk bâleŋande mem gulip guguâp.” ");
INSERT INTO tim_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hain dâmbiâ hin makyeŋgiep, “Nâmâ âi mendere luâk âlepŋe agep are nâŋgâmbiâ humo aktâp. ");
INSERT INTO tim_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Aregât hin makyeŋgire nâŋgâm heŋgemgoŋet. Moseŋe nanlupyeŋe hâkyeŋân kulem meŋetgât makyeŋgiep. Dâ are âmâ Mose ikiŋak keiŋe bo kalep. Hakulupyeŋe yâkŋe keiŋe kali. Akto âi are menegât âi bo meme sopŋân gai memai. ");
INSERT INTO tim_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yeŋe amâ Mosegât den bâliwop dâm nanaŋlupyeŋe âi bo meme sopŋân hâkyeŋe gâimai aregât âi meme sopŋe boân âi memai. Dâ nâmâ luâk kundatdâ âi bo meme sopŋân heŋgemgoân aregât nâŋgâm bâli niŋi. Ye amâ hiaŋgi luâk. ");
INSERT INTO tim_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ye amâ den hanâk hâkne tunmâ makmai. Hain bo akbei. Den bunŋe nâŋgâm makbei.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hain dâmbo Yerusalem ambolupŋe arekŋe hin dâyi, “Luâk kombaen dâyi amâ ire. ");
INSERT INTO tim_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dâ amâ wangât den miawagân makto humomolupnenŋande den bo koaŋmâ âmâ bo mem kondâi? Yâkŋe keiŋe nâŋgâm heŋgemgom hin dâi me? “Yâk Anutuŋe huŋgun aŋdo giep.” hain dâi aregât bo mem kondâi me gain? ");
INSERT INTO tim_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Akto luâk ire amâ miawagep aregât kepiaŋe nâŋgâen. Dâ Anutuŋe huŋgun aŋdo gewiap aregât keiŋe amâ pâpkom metewaen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hain dâmbiâ Yesuŋe sumbe emetŋân kinmâ den hin dâm makyeŋgiep, “Ye amâ hin dâi, “Yesugât kepiaŋe miawagep aregât keiŋe nâŋgâen.” dâi. Dâ bunŋe amboŋe konok mandâp yâkŋe huŋgun niŋdo yâkgât enemŋânba geân. Dâ ye âmâ yâkgât keiŋe bo nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nâmâ ikiŋaelânba huŋgun niŋdo geân gârâmâ nâŋgâm heŋgemgoân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aregât mem kala busi kâlegen katberâm agi. Dâ amâ sop boâk miawakto aregât akmâ hepuli. ");
INSERT INTO tim_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Akto luâk âmbâle bikŋande hin dâyi, “Anutuŋe huŋgun aŋdo gewiap arekŋe kulem keiŋe keiŋe membiap nâŋgâmaen ina togom kulem keiŋe keiŋe mem miawaktâp, aregât amâ Yesu amâ yâk me?” dâm nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Akto luâk âmbâle bikŋande yâkgât hain magaŋgi goaŋgi akbiâ Parisaioŋe a nâŋgâmbiâ bâlimbo âmâ aregât sumbe kat kat humomolupyeŋe olop tembe lokolupyeŋe Yesu kala busi kâlegen katŋetgât huŋgun yeŋgimbiâ togoyi. ");
INSERT INTO tim_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Togombiâ Yesuŋe hin makyeŋgiep, “Nâ ye olop bâlensiâ manmâ huŋgun niŋep yâkgâlae purik katbian. ");
INSERT INTO tim_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Purik katere yeŋe nâŋgât kulâgât niŋmâ bo nekbai. Amâ nâ arim manbian ain bo ariwai. Akto ariwaigât dâp bo tatyeŋgiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hain dâmbo hin dâm magaŋgi goaŋgi agi, “Yâk yâgâten ari mando kulâgâlaŋbaengât maktâp? Nen bikŋande hepun nenekmâ Girik yâk yeŋgâlân ari manmai ain arim makyeŋgiwiapgât maktâp me? ");
INSERT INTO tim_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yâk hin maktâp. Kulâgât niŋmâ bo nekbai. Akto nâ arim manbian ain bo ariwai, dâm maktâp amâ gain gain maktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Akto manmâ hombaŋ are bo akberâm akto Yesuŋe agatmâ kinmâ kâmot humo kili are den hin kârikŋeâk kamboŋmâ makyeŋgiep, “Siâ tugât nâŋgâm âmâ âlepŋe nâŋgâlân togom nembiâp. Nâŋgâlân togom âmâ nâŋgâ niŋmâ biwiŋânba tu dewunŋe hainare gam togomâk yembiap. Are amâ Anutugât denŋande hain magep.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesuŋe amâ tugât bo magep. Amâ Anutugât Heakŋe aregât magep. Akto Yesu amâ himbimân boâk purik katmâ âgâepgât Anutugâlânba Heak kârikŋe boâk giep. Aregât biwiyeŋe Yesugâlân kali amâ sop ain Heakŋande boâk meyegep aregât magep. ");
INSERT INTO tim_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Akto yâkŋe hain dâmbo aregât kâmot ain kili arekŋe potalakmâ bikŋande hin dâyi, “Imâ Propete togowiap dâmaen in amâ ire.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dâ bikŋande hin dâyi, “Imâ Anutuŋe huŋgunaŋdo gewiap yâk.” dâyi. Dâ bikŋande hârem hin dâyi, “Woe, bo. Kristo amâ Galilaia hânân bo miawakbiap me? ");
INSERT INTO tim_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dâ Anutuŋe makto kulemgoyi keiŋe hin yendâp, “Anutuŋe huŋgun aŋdo gewiap amâ Dawidigât kâmolân gâtŋe miawakbiap. Akto Dawidigât kepia kautŋe Betelehem ain gâtŋe miawakbiap.” Aregât Yesu Galilaia hânân miawakbiapgât amâ Anutuŋe huŋgun aŋdo gewiapgât bo.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Akto kâmot arekŋe Yesugât hain makmâ potalagi. ");
INSERT INTO tim_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Akto bikŋande kala busi kâlegen katne dâmbiâ dâp bo miawakto hepuli. ");
INSERT INTO tim_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Akto tembe loko arekŋe sumbe kat kat humomolupyeŋe akto Parisaio yeŋgâlân purik katbiâ ai yeŋgum hin dâyi, “Ye wangât Yesu bo mem togoâi?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","hin dâyi, “Yâkŋe makmap amâ luâk bikŋande hain are bo makbâi.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisaio luâkŋe hin dâyi, “Woe, yâkŋe hâwâtyekmâ biwi gulip akyeŋgiâp mon? ");
INSERT INTO tim_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Damun humomolupyeŋe me Parisaio nengâlân gâtŋe bikŋande bo nâŋgaŋmaen. ");
INSERT INTO tim_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amâ luâk âmbâle yânŋe den kârikŋe bo nâŋgâmaiŋe nâŋgâ aŋbiâ Anutuŋe hememângen panyekto hememângen gem manbai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Akto galayeŋe siâ kotŋe Nikodemo emelâk hândâkŋân Yesu togom egep yâkŋe hin dâep, ");
INSERT INTO tim_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nengât den kârikŋe hin bo yendâp, “Luâk siâ ikiŋe keiŋe bo makto nâŋgâwai me dosaŋe bo ekmâ yân hâuŋaet den âiân katbai.” hain bo yendâp. Akto yâk hanâk konbaen aregât dopŋe bo tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hain dâmbo galalupŋande kuk agaŋmâ hin dâm magaŋi, “Woe, gâŋe âmâ biwige Galilaia gâtŋe yâkgâlân kalen me? Gâ ari Anutuŋe makto kulemgoyi are hârok oyaŋmâ nâŋgâm hin nâŋgâwiat. Propete siâ amâ Galilaia hânân bo miawakbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hain dâm awam akmâ gem emetyeŋân ariyi. ");
INSERT INTO tim_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Akto Yesu Oliwa gimbâŋân âgâep. ");
INSERT INTO tim_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Emet hauŋdo arewa Sumbe kat kat emetŋân âgâmbo luâk âmbâle dondâŋe ain togombiâ tatmâ den makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Makyeŋgimbo Parisaio akto Mosegât den makmâ kepikmai aren gâtŋande âmbâle siâ dâp gulip akmâ mando egi are kewugum Yesugâlân togom hutyeŋân katbiâ kilep. ");
INSERT INTO tim_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Katbiâ kindo hin dâyi, “Apo, âmbâle ire âmâ dâp gulip akmâ mando ekten. ");
INSERT INTO tim_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Akto Mose amâ den kârikŋe hin kulemgoep, “Âmbâle bâleŋe akmâ manbiâ âmâ kâtŋe yeŋgumbiâ mombai.” dâm den kârikŋe kulemgoep. Dâ gugak amâ gain gain nâŋgâmat?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Amâ yân hiaŋbiâ den hin me hain makto ekmâ âkâ den âiân katnerâm hiaŋgim dop koyi. Hain makbiâ Yesuŋe kâŋgom hânân bâtŋande kulemgoep. ");
INSERT INTO tim_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kulemgombo aikom aikom akbiâ bin bin kinmâ hin makyeŋgiep, “Yeŋgâlân gâtŋe siâ dosa bâlâk manmap arekŋe soŋ keiŋe katmâ kâtŋe kondo âmâ kombei.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hain dâm lâuwâŋe hânân kâŋgom kulemgoep. ");
INSERT INTO tim_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Akto ain kili arekŋe den are nâŋgâm ulikŋân gâtŋande hami kinmâ ainba ainba gem arim meteyi. Akto âmbâle are Yesugât enemŋân ikiŋeâk kilep. ");
INSERT INTO tim_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kindo Yesuŋe agatmâ kinmâ âmbâle are ŋâŋâk ekmâ aikom hin magaŋep, “Barat, den amâ yân hâkge tunberâm aktâi. Siâ me siâŋe den hâuŋe bo makgiŋdâi me?” dâmbo, ");
INSERT INTO tim_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Humone, siâŋe bo makniŋdâp.” dâmbo hin magaŋep, “Nâŋe hainâk hâuŋaet den bo makgiŋberân. Gâ yân arim bâleŋe lâuwâŋe bo akben.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Akto Yesu sumbe emetŋe kom hâre hâreŋe siân ain kinmâ hin makyeŋgiep, “Nâ hân hârok yeŋgât pagaleŋe. Aregât siâŋe nâ wat nekbiap âmâ hândâkŋân bo arim manbiap. Bo. Yâk amâ manmangât pagaleŋân manbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hain dâmbo Parisaio luâkŋe hin magaŋi, “Gâ ire gugaet keige maktât amâ nâŋgâenŋe bunŋe bo aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hain dâmbiâ hin dâep, “Nâmâ yâgâtenba togoân akto yâgâten ariwian aregât hârok nâŋgâman aregât nune keine maktere bunŋe akmap. Dâ ye âmâ wânânba togoân akto wânân ariwiangât bo nâŋgâmai aregât maktere bunŋe bo dâmai. ");
INSERT INTO tim_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ye hângât nâŋgâ nâŋgâ watmai. Dâ nâmâ hinŋe den âiân bo katyektân. ");
INSERT INTO tim_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Akto siân dosaŋe miawagâkgât âi membian amâ Ewenande huŋgun niŋep arekŋe tân nugumbo olop âi membaetgât âine bunŋe mendere miawakbiap. ");
INSERT INTO tim_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Akto den kârikŋe bikŋe hin yendâp, “Luâk konokgât den bo nâŋgâwei. Luâk lâuwâ akmâ siâgât keiŋe bâleŋe makbela bunŋe dâwei.” ");
INSERT INTO tim_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aregât nâ nune konok keine bo makmâ miawakman. Ewene huŋgun niŋep arekŋe hainâk makmâ miawakmap amâ net lâuwâ. Aregât imâ den bunŋe dâm nâŋgâŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hain dâmbo hin dâm magaŋi, “Ewege yâgâten? Hekat nengimenâ ekne.” dâmbiâ hin makyeŋgiep, “Ye Ewene bo nâŋgâ aŋmai. Akto hainâk nâ bo nâŋgâ niŋdâi. Nâ nâŋgâ niŋmâ dâine Ewene hainâk nâŋgaŋbâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuŋe sumbe kat kat puli katmini aregât kom hâre hâreŋe ain den ire magep. Hain dâmbo mem kombaigât sopŋe boâk miawagepgât kala busi kâlegen katbaigât dâp bo miawakyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Akto Yesuŋe lâuwâŋe hin makyeŋgiep, “Nâ hepun yekmâ arire kulâgât niŋmâ bo nekbai. Manmâ mom âmâ dosayeŋaet hâu bâlâk bo âgâwai. Akto nâ ari manbian ain ariwaigât dâp bo tatyeŋgiwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hain dâmbo hin magaŋgi goaŋgi agi, “Nâ arim manbian ain bo ariwai dâp amâ gain gaingât maktâp. Ikiŋe hanŋe hâreakmâ mombiapgât me gain gain maktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dâmbiâ hin dâep, “Ye amâ iŋgon gâtŋe. Dâ nâmâ egon gâtŋe. Ye amâ hân iren gâtŋe. Dâ nâmâ hânân gâtŋe bo. ");
INSERT INTO tim_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aregât emelâk hin makyeŋgiân. Ye manmâ mom âmâ dosa akmai aregât hâuŋe bâlâk bo âgâwai. Akto aregât keiŋe hin. Nâ mandân ire keine hain dâre nâŋgâmai amâ bâleŋeyeŋe yeyeŋgimbo mombai aten.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hain dâmbo hin dâyi, “Keige maknengimenâ nâŋgâne.” dâmbiâ hin makyeŋgiep, “Ulikŋânbak makyeŋgim gan are. ");
INSERT INTO tim_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nâ yeŋgât keiyeŋe makmâ miawakmâ den âiân kat yekbiangât âi humo tatniŋdâp. Dâ hinŋe amâ Bunŋe Amboŋe arekŋe huŋgun niŋdo yâkgât den ire hânân makyeŋgiman.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Eweŋaet hain makyeŋgimbo yâkŋe bo nâŋgâm kotgâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aregât Yesuŋe den siâ hin makyeŋgiep, “Yeŋe nâ mem agat nekbai ain nâ manmâ gan aregât nâŋgâwai. Akto nunaet nâŋgâ nâŋgânaet wan me wan bo akman. Ewenande den makniŋep areâk makyeŋgiman. ");
INSERT INTO tim_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Huŋgun niŋep yâkgât lauŋe lokom âiŋe hokboâk hokboâk mendere nekto huragumap aregât yâk nâ olop mandâp. Akto bo hepun nekmap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hain dâmbo luâk âmbâle dondâŋe nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Akto Yesu nâŋgaŋi Yuda luâk are hin makyeŋgiep, “Ye nâŋgât denân manmâ âmâ nanlupne bunŋe tiŋtiŋ akbai. ");
INSERT INTO tim_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Akto nâŋgât den bunŋe nâŋgâm kotgâmbiâ arekŋe mem kotgâ yekto tâk bâlâk âlepŋeâk manbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hain dâmbo den hin purikalaŋi, “Nen amâ Abrahamgât hakulupŋe aregât luâk siâ bo hoŋ agaŋmaen. Dâ nen tâk bâlâk âlepŋe manbaengât maktât amâ gain gain?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hain dâmbiâ hin makyeŋgiep, “Nâ keiyeŋe hin makyeŋgire nâŋgâŋet. Luâk me âmbâle siâŋe bâleŋe akbiap amâ bâleŋe arekŋe damunŋe akto hoŋ bawa agaŋdo ari arigât dop bo tatbiap. ");
INSERT INTO tim_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hoŋ bawaŋe humoŋaet emelan hokboâk hokboâk bo manmâ âgâwiap. Dâ Nanŋande Eweŋe olop hokboâk hokboâk manmâ âgâwiap. ");
INSERT INTO tim_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dâ aregât nanŋande oloŋ yekbiap âmâ siâgât hoŋ bawa bo manbai. ");
INSERT INTO tim_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Akto ye âmâ Abrahamgât bâgilupŋe amâ bunŋe. Dâ den laune bo lokomai aregât nugumbiâ mombiangât nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nâ ewenaelân wan me wan ekmâ malân areâk makman. Dâ yeŋe âmâ ambo yeŋaelân wan me wan egi areâk memai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hain dâmbo hin magaŋi, “Nen ambonenŋe amâ Abraham.” dâmbiâ Yesuŋe hin makyeŋgiep, “Ye Abrahamgât bâgilupŋe manmai dâine âmâ yâkgât dop akbâi. ");
INSERT INTO tim_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anutugâlânba den bunŋe nâŋgân are makyeŋgiân aregât ye âmâ nuguwerâm maktâi siâ siâ hainare Abrahamŋe bo agep. ");
INSERT INTO tim_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ye amâ amboyeŋaet lau lokom manmai.” dâep. Hain dâmbo hin magaŋi, “Nengât memelupnenŋande dâp gulip bo manbiâ miawagion. Ambonenŋe amâ Anutu konok.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","hin makyeŋgiep, “Anutuŋe amboyeŋe akmap dâine nâ gala akniŋbâi. Nâ Anutugâlânba geân. Nune ukennaet bo geân. Yâkŋe huŋgun niŋdo geân ");
INSERT INTO tim_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","aregât gain akmâ manbiâ nâŋgât denne biwiyeŋân bo yendâp? Nâ den makyeŋgire ondopyeŋe katmâ bo nâŋgâi aregât denne hâkâŋ akmai. ");
INSERT INTO tim_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ye eweyeŋe Hiaŋgi Amboŋe akto yâkgât nâŋgâ nâŋgâŋe akto egâliaŋ bâleŋande makto siâ me siâ akmai. Akto Bâleŋe Amboŋande amâ hâŋgeiŋe luâk hilip yeŋgum gaep akto hinŋe hainâk manmâ gap. Yâk den bunŋe hepulepgât nâŋgâ nâŋgâŋân den bunŋe siâ bo yendâp. Yâk amâ Hiaŋgi Amboŋe akmapgât heyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yâkŋe amboyeŋe akmap aregât nâmâ den bunŋe makyeŋgire bo nâŋgâ niŋdâi. ");
INSERT INTO tim_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yeŋgâlânba siâŋe âlepŋe nâŋgât dosa siâ makbop. Akto nâ dop hain arekŋe den bunŋe makyeŋgire wangât bo nâŋgâm heŋgemgomai? ");
INSERT INTO tim_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Siâ Anutugât pat manmapŋe denŋe nâŋgâmap. Ye amâ Anutugât pat bo manmaigât denŋe hâkâŋ akmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hain dâmbo hin magaŋi, “Woe, gâmâ Samaria luâk. Sinduk baniara bâleŋande hut gugumbo aregât wan me wan akmâ memat mon?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hain dâmbiâ hin makyeŋgiep, “Sinduk baniara bâleŋande bo hut nuguep. Nâmâ Ewenaet lau lokoman. Dâ yeŋe âmâ nâŋgât hâkâŋ akmâ denne mem ge katmai. ");
INSERT INTO tim_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nâ kotne bo mem agatân. Humoŋe konok kotne mem agatmap. Yâkŋe amâ dosayeŋe miawagâkgât âi membiap. ");
INSERT INTO tim_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Bunŋe makyeŋgire nâŋgâm heŋgemgowei. Niŋemaŋe nâŋgât den mem manbai amâ momo kârikŋe bo mem âgâwai.” hain dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hain dâmbo hin dâm magaŋi, “Woe, sinduk aktât. Abraham hâŋgeiŋe moep. Akto Propete hârok mom meteyi. Dâ gâŋe amâ hin dât, “Nâŋgât den mem manbai amâ manman kârikŋe manmâ âgâwai.” dât amâ gâ sinduk aktât nâŋgâen. ");
INSERT INTO tim_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Akto gâ Abraham moep yâkgât dop ewangim maktât mon? Akto propete hainâk moyi are ewangi yekmâ hâkge mem agatmenâ bo ârândâŋ aktâp aregât gâ gain gain nâŋgâ aŋgiât.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hain dâmbiâ Yesuŋe hin makyeŋgiep, “Nunak konok hâkne mem akman dâine bo ârândâŋ akbop. Dâ Ewene are amâ ye damun nenŋe dâmai yâkŋe amâ denne nâŋgâm hâkne mem agatmap. ");
INSERT INTO tim_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Dâ yeŋe Anutu amâ damun nenŋe dâmai amâ hiaŋgimai. Ye amâ yâk bo nâŋgaŋmâ metemai. Dâ nâŋe âmâ nâŋgaŋmâ meteân aregât nâ bo nâŋgaŋman dân dâine hiaŋgim ye hainare akbom. Dâ nâmâ nâŋgaŋmâ metem denŋe lokom manman. ");
INSERT INTO tim_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ye bâginenŋe Abraham ulikŋân moep dâi aregât hin makbe. Abrahamŋe nâŋgât âi miawakto ekberâm ukenŋe humo nâŋgâm malep. Akto manmâ nâŋgât âi miawakto ekmâ heroŋe humo agep.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hain dâmbo hin dâm magaŋi, “Woe, Abraham âmâ ulikŋân malep. Dâ gâmâ sigan aregât gâŋe gain gain Abraham egen?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hain dâmbiâ hin makyeŋgiep, “Nâ den bunŋe hin makbe. Abraham boâk miawakto nâ ulikŋânbak malânŋeak manmâ gan.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hain dâmbo Yesugât nâŋgâmbiâ bâliep aregât kât mem komberâmbiâ yoŋâk sumbe emetŋânba sopanmâ gem ariep. ");
INSERT INTO tim_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Akto âi bo meme sopŋe siân Yesu dâwân ari luâk siâ dewunŋe bok bokŋe memeŋande hainâk miep are egep. ");
INSERT INTO tim_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Akto hoŋ bawalupŋande aikom hin dâyi, “Humo, niŋaet dosagât dewunŋe bok bokŋe miawagep ikiŋaet me memeŋe eweŋe yetgât?” ");
INSERT INTO tim_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","hain makbiâ hin dâm makyeŋgiep, “Amâ ikiŋaet dosagât bo, akto memeŋe eweŋe yetgât dosagât bo. Anutugât kârikŋe ain miawagâkgât hainâk miawagep. ");
INSERT INTO tim_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nâ huŋgun niŋep yâkgât âi dewutân mem manbian. Akto hâmbâi hândâk miawakto ain mendenŋe bo akbop. ");
INSERT INTO tim_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nâ hânân manbian amâ pagaleŋe dewutâ hainare aktere pagaleŋande erâm pagale yekbiap.” ");
INSERT INTO tim_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hain dâm hânân tâwutkom hân olop golaŋgom luâk aregât dewunŋân puliep. ");
INSERT INTO tim_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pulim hin dâm huŋgun aŋep, “Gâ ari Siloam bâtgumân dewunge puli.” dâep. Siloam amâ den purikŋe âmâ huŋgun aŋep. Akto luâk are arim dewunŋe pulim emet egep. Emet ekmâ âmâ emetŋân ariep. ");
INSERT INTO tim_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hain akmâ purik katmâ emetŋân âgâmbo galalupŋe sotgât ulit yeŋgim malep are ekmâ luâk arekŋe hin magaŋgi goaŋgi akmâ hin dâyi, “Ulit nengim tatmâ manmap amâ ire me gain?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hain dâmbiâ bikŋande hin dâyi, “Amâ ire.” dâyi. Dâ bikŋande amâ, “Bo hinare siâ.” dâyi. Hain dâmbiâ ikiŋak magep, “Maktâi amâ nâ ire.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hain dâmbo hin aikom dâyi, “Gâ gain gain akmâ dewunge hulaŋ aktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hain dâmbiâ makyeŋgiep, “Luâk siâ kotŋe Yesu arekŋe hân golaŋgom dewunne pulim hin dâm makniŋdâp, “Gâ arim Siloam bâtgumân hâkge puli.” dâp. Akto nâ arim hâkne pulim arekŋeak emet ektân.” dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hain makyeŋgimbo aikom hin dâyi, “Luâk are yâgâten mandâp?” dâmbiâ, “Bo nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Akto luâk dewunŋe bok bokŋe are âlepŋe agep are Parisaio yeŋgâlân oloŋmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Akto Yesuŋe luâk dewunŋe bok bokŋe hân golaŋgom arekŋe heŋgemgoep amâ âi bo meme sopŋân agep. ");
INSERT INTO tim_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Akto Parisaio luâkŋe hinâk aikom dâyi, “Gâ gain gain akmâ dewunge miawaktâp?” dâmbiâ hin makyeŋgiep, “Yesuŋe hân golaŋgom dewunne pulimbo nâ arim Siloam bâtgumân hâkne pulim dewunne hulaŋnektâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Akto Parisaio yeŋgâlân gâtŋe bikŋande magi, “Luâk are amâ Anutugâlân gâtŋe bo. Yâk âi meme sopŋe boân âi mem hilipkoâp.” dâyi. Dâ bikŋande amâ hin dâyi, “Yâk bâleŋe luâk manmâ dâine âi hainare gain gain membop?” hain dâm potalagi. ");
INSERT INTO tim_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Akto luâk dewunŋe bok bokŋe agep are lâuwâŋe magaŋmâ, “Dewunge mem hulaŋdâp aregât amâ gugak gain gain nâŋgaŋdât?” dâm magaŋbiâ dâep, “Yâk amâ propete siâ.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Akto Yuda luâkŋe bundâk luâk are amâ dewunŋe bok bokŋe manmâ dewunŋe hulaŋagep hain dâm aregât han lâuwâ akmâ memeŋe eweŋe oloŋ yelekbiâ togombela ");
INSERT INTO tim_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","hin ai yetkuyi, “Nan yetŋe ire dewunŋe bok bokŋe miawagep dâyiat are amâ gain gain akmâ dewunŋe âlepŋe miawaktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Hain dâmbiâ humomolupyeŋe emelâk hin dâyi, “Siâŋe me siâŋe Yesu amâ Anutuŋe huŋgun aŋdo giep dâwai amâ den emetŋânba akto kâmolânba watyektenŋe yânŋângen manbai.” dâyi aregât yân manbâet dâm hin dâyiat, “Imâ nan netŋe. Akto dewunŋe bok bokŋe miawagep are nâŋgâet. Dâ gain gain akmâ dewunŋe hulaŋ aktâp akto niŋande dewunŋe hulaŋdâp amâ bo nâŋgâet. Dâ emelâk handâ agep aregât ikiŋe aikombiâ keiŋe makyeŋgiâk.” dâyiat. Eweŋe memeŋe hamewakmâ hain dâyiat. ");
INSERT INTO tim_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Akto luâk dewunŋe bok bokŋe âlepŋe agep are lâuwâŋe oloŋmâ hin aikoyi, “Nen luâk aregât amâ luâk bâleŋe dâmaen aregât yâkgât kotŋe amâ bo mem agat. Anutu konok yâkgât kotŋe mem agat.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hain dâmbiâ hin dâep, “Woe, luâk bâleŋe dâi amâ bo nâŋgân. Hingât nâŋgân. Ulikŋânbak dewunne bok bokŋe manmâ gan. Dâ uŋak wan me wan ektân are amâ nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hain dâmbo hâwâtmâ hin dâyi, “Gain gain akgiŋdo dewunge hulaŋ akto ektât?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hain dâmbiâ hin makyeŋgiep, “Nâmâ emelâk makyeŋgiân are bo nâŋgâi. Wangât hâwâtmâ makniŋdâi? Ye hoŋ bawa agaŋberâm maktâi me?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hain dâmbo nâŋgâm bâlim hin dâyi, “Gâmâ yâkgât hoŋ bawa agaŋmat. Dâ nen âmâ Mosegât hoŋ bawa agaŋmaen. ");
INSERT INTO tim_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anutuŋe Mose magaŋep a nâŋgâen. Dâ luâk are niŋaet wâtŋân kinmâ kulem memap amâ bo nâŋgâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hain dâmbiâ nâŋgâmbo umatŋe akto hin dâep, “Woe, luâk dewunne hulaŋdâp aregât kârikŋe wanânba memapgât pâpkom bo nâŋgâen dâi? Imâ nâŋgâm hanokoak akyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nen hârok âmâ hin nâŋgâmaen. Anutuŋe âmâ luâk bâleŋe memai yâk yeŋgât den bo nâŋgâmap. Dâ luâk âmbâle lauŋe lokom kotŋe mem agatmai amâ Anutuŋe nâŋgâyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dâ luâk siâ dewunŋe bok bokŋe mem hulaŋep pat hainare hân miawagewânba siâ bo nâŋgâm gambiâ gambiâ uŋak yu miawaktâp. ");
INSERT INTO tim_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aregât luâk ire amâ Anutugât wâtŋân kinmâ kulem memap. Dâ Anutuŋe bo huŋgun aŋdo giep dâine hinare bo membop.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hain dâmbo hin magaŋi, “Woe, gâmâ bâleŋe higenŋe miawakmâ gaen amâ gain gain maknengiwerât amâ bo.” dâm hâkokombiâ giep. ");
INSERT INTO tim_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Akto Yesuŋe luâk hâkokom panbiâ giep aregât pat nâŋgâm mem miawakmâ hin magaŋep, “Gâ luâk akmâ gewiap dâyi yâk nâŋgaŋdât me?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hain dâmbo hin dâep, “Apo, gâ maktât amâ niŋe? Hekat niŋmenâ ekmâ nâŋgâm heŋgemgoaŋbe.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Hain dâmbo hin magaŋep, “Makgiŋdere nektât nâ amâ ire.” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","hin magaŋep, “Humone, nâ nâŋgâ giŋdân.” dâm keiŋân kâŋgom kotŋe mem agalep. ");
INSERT INTO tim_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Akto Yesuŋe hin magaŋep, “Nâ luâk âmbâle dosayeŋe mem miawakbiangât keiyeŋe mem makyeŋgiwerâm hânân geân aregât dewunyeŋe bok bokŋe hinare heŋgem yeŋgure ekbai. Dâ dewunyeŋe âlepŋe are hainare amâ makyeŋgire dewunyeŋe bokbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Akto Parisaio luâk olowâk kili arekŋe nâŋgâm hin aikoyi, “Maktât amâ nen dewun nenŋe bok bokŋe hainare me?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Hain dâmbiâ hin dâep, “Ye dewunyeŋe bok bokŋe hainare manmai dâine dosayeŋe bo tatyeŋgiwop. Dâ ye, “Nen âlepŋe ekmaen.” dâi aregât dosayeŋe tatyeŋgiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuŋe Yuda luâk âmbâle kili are hin makyeŋgiep, “Nâ den bunŋe yu makyeŋgiwe. Luâk siâ lama yeŋgât hâŋgiân bo âgâm âmâ lope loŋgaim aŋgânba âgâmai are amâ luâk kâmburâ dâmai. ");
INSERT INTO tim_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dâ luâk siâŋe hâŋgiânba âgâmap are amâ lama amboyeŋe dâmai. ");
INSERT INTO tim_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yâkŋe togombo âmâ hâŋgi damunŋe arekŋe ekmâ hâŋgi mem kalaŋdo âgâm lama yeŋgondo denŋe nâŋgâm agatbiâ kewugu yekmâ arimap. ");
INSERT INTO tim_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Akto lama damunyeŋaet den nâŋgâm agatmai aregât luâk are ikiŋaet lama yeŋgondo sopanmai. Sopanmâ amboyeŋe watmâ arimai. ");
INSERT INTO tim_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dâ luâk aŋgâŋe âgâm yeŋgondo bo nâŋgaŋmâ âmâ bo watmai. Den aŋgâ nâŋgâm hamep akmâ bo watmâ siângen arimai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuŋe den dopŋe are makto âmâ bo nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Akto Yesuŋe den ginŋe siâ hin dâep, “Nâ bundâk makyeŋgiwe. Nâmâ lama yeŋgât hâŋgi damunŋe hainare. ");
INSERT INTO tim_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nâ ulikŋân hânân boâk geân amâ luâk bikŋe Anutugât keiŋe makyeŋgine dâm makmâ hiaŋgiyi. Luâk hain arekŋe amâ luâk kâmburâ hainare agi. Aregât nâŋgât lama arekŋe denyeŋe bo nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nâmâ hâŋgi hinare. Siâ nâŋgâlân togombo âmâ Anutuŋe heŋgemgowiap. Amâ âlepŋe gam gem gem akmâ sot me wan me wan sambe mem manbiap. ");
INSERT INTO tim_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dâ kâmburâ amâ lama hilip yeŋgum kâmbu mem ariwerâm togomai. Dâ nâmâ lamalupne heroŋe maroŋe manbaigât hânân geân. Heroŋe maroŋe getek bo. Heroŋe maroŋe humo nâŋgâm manbaigât geân. ");
INSERT INTO tim_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nâmâ lama damunyeŋe âlepŋe aregât lamalupne dâm nuguŋet dâm kindere nugumbiâ mombian aregât hamep bo akman. ");
INSERT INTO tim_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dâ damun yânŋe âigât hâugâlâk nâŋgâm âmâ lama amboyeŋe bo manmapŋe dua metŋe togombo ekmâ hamewakmâ lama hepunyekmâ arimap. Arimbo âmâ dua metŋe arekŋe lama yiŋgim itiŋ gulam akyeŋgimbo awam akmâ arimai. ");
INSERT INTO tim_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Amâ damun yânŋe puligâlâkgât âi memap aregât lama damunyeŋe bo manmap aregât lama hepuyekmâ pirâm arimap. ");
INSERT INTO tim_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Akto Anutuŋe nâŋgâ niŋdo nâkâ nâŋgâ aŋman dop hainâk lamalupne nâŋgâ yeŋgire nâŋgâ niŋmâ metemai. Aregât lamalupne âlepŋân manbai dâm nuguŋet dâm kindere nugumbiâ mombian. Hain akbiangât nâŋe konok lama damunyeŋe mandân. ");
INSERT INTO tim_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Akto nâŋgât lamalupne amâ kâmot siâ mandâi akto siân manbai are gai nâ kewuguyekmâ nune konokŋe damunyeŋe akbiangât nâŋgân. Aregât yeŋgondere denne nâŋgâm togom kâmot konok akbai. ");
INSERT INTO tim_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Akto nâ lamalupne yeŋgât akmâ manmanne hepunmâ mom âmâ lâuwâŋe manbian. Aregât Apone konok nâŋgâ niŋmap. ");
INSERT INTO tim_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ewenande mombiangât nâŋgâ niŋmâ lamagât âi niŋep aregât siâŋe ikiŋaet ukenŋe watmâ nuguwiapgât dâp bo talaŋmap. Bo dondâ. Siân nugumbiâ mombian amâ nunaet hanne watmâ maktere hain akbai. Akto lâuwâŋe membiangât hainâk nunaet hanne watmâ membiangât kârikŋe yeniŋdâp. Hain akbiangât Ewenande nâŋgâ niŋep.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesuŋe den hain dâmbo ain kili arekŋe lâuwâŋe makmâ potalagi. ");
INSERT INTO tim_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Potalakmâ bikŋe hin dâyi, “Sinduk baniara bâleŋande hutgombo biwi gulip akmap aregât bo nâŋgaŋne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dâ bikŋande amâ hin dâm makyeŋgiyi, “Sinduk baniara bâleŋe arekŋe luâk dewunyeŋe bok bokŋe heŋgem yeŋguwiapgât kârikŋe bo tatyeŋgiâp. Aregât Yesu amâ sinduk baniara bâleŋande bo tângombo kulem keiŋe keiŋe mem amâ den âlepŋe maknengimap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Akto hamiŋân âmâ Yuda yeŋgât sumbe emetŋe meyi aregât hombaŋ miawagep. ");
INSERT INTO tim_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Akto bâlâpŋe sopŋe miawagep ain Yesu Sumbe emetŋe aregât hâŋgi siâ kotŋe Salomo ain âgâep. ");
INSERT INTO tim_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ain âgâmbo Yuda yeŋgât humomolupyeŋe arekŋe ândeaŋmâ kinmâ hin aikoyi, “Gâ wangât keige heambukmenâ han lâuwâ akten? Gâmâ Anutuŋe huŋgun aŋdo gewiap dâmaen amâ gâ me? Keige maknengimenâ nâŋgâm heŋgemgone.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dâmbiâ hin dâm makyeŋgiep, “Nâ emelâk dondâ makyeŋgire bo nâŋgâm heŋgemgomai. Apogât laugât âi meman arekŋe makmâ miawak nekmap. ");
INSERT INTO tim_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dâ ye amâ lamalupne bo akmâ manmaigât denŋe bo nâŋgâm heŋgemgomai. ");
INSERT INTO tim_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Akto nâŋe lamalupne nâŋgâm meteyekman are yeŋgondere denne nâŋgâm watnekmai. ");
INSERT INTO tim_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Watnekmai are âmâ wâtŋe akyeŋgire manman kepian manmâ âgâwai. Akto bo hilip agum dondâŋe manmâ âgâwai. Akto siâŋe nâŋgât kârikŋenânba mem hâre yekbiapgât kârikŋe bo talaŋdâp. ");
INSERT INTO tim_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Akto Ewenande lamalupne are niŋdo meyekmâ mandân. Ewene âmâ siâ me siâ hârok ewangiyekmap aregât siâŋe Ewenaet kârikŋânba mem bâli yekbiapgât dop bo tatâp. ");
INSERT INTO tim_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Akto nâ Ewene net amâ dop konok.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesuŋe hain dâmbo Yuda luâk kili arekŋe nâŋgâmbiâ bâliep aregât kât pitim komberâm agi. ");
INSERT INTO tim_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Hain akbiâ Yesuŋe hin dâm makyeŋgiep, “Apone âigât kârikŋe niŋdo âi âlepŋe keiŋe keiŋe mendere egi aregât wan bâleŋe aktere ekbiâ bâliepgât kâtŋe nuguwerâm aktâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hain dâmbo hin dâyi, “Âi âlepŋe memat aregât bo guguweren. Dâ gâ luâk manmatŋe Anutu ewangiwerâm sârekomat are nâŋgâm Anutugât kotŋe bâliwopgât guguweren.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Hain magaŋbiâ hin dâep, “Woe, Anutuŋe makto Dawidiŋe luâk kembu yeŋgât hin kulemgoep, “Ye amâ hângât kembulupyeŋe.” dâm kulemgoep. ");
INSERT INTO tim_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anutugât den kulemŋe amâ hilip agu agugât dop bo. Aregât Anutuŋe den makmâ miawakyeŋgim malep yâk âmâ kembulupyeŋe dâep. ");
INSERT INTO tim_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aregât nâ Ewenande den dâtânerâm makmâ huŋgun niŋdo geân nâŋe nâ Anutugât nanŋe mandân dâre yeŋe wangât gâŋe Anutu ewangiwerâm sârekom maktât dâm makniŋdâi? Amâ makbiâ bâliâp. ");
INSERT INTO tim_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Âi meman are ekbiâ Ewenaet dop bo manman dâine denne hâkâŋ akbiâ ârândâŋ akbop. ");
INSERT INTO tim_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gârâmâ âi meman are ekmâ imâ Anutugât âi hainare dâmai âmâ âlepŋe nâŋgâniŋbei. Nâŋgâniŋbiâ âmâ benŋe Anutuŋe biwiŋân kat nekmap akto nâŋe biwinân katman are gai nâŋgâm metewai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hain dâmbo nâŋgâmbiâ bâlimbo hikowerâm akmâ mem mesokbiâ hut yeŋânba yoŋâk gem ariep. ");
INSERT INTO tim_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Akto arewa Yesuŋe Yodaŋ tu hâtikoep. Hâtikom hâŋgeiŋe Yohaneŋe keiŋe katmâ tu puli yekmâ malewân ain ari malep. ");
INSERT INTO tim_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ain mando luâk âmbâle dondâŋe yâkgâlân togom hin magaŋgi goaŋgi agi, “Yohaneŋe âmâ kulem meme imâ bo miep. Dâ Yohaneŋe Yesugât den magep amâ bunŋe akmâ metiep.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hain dâm are yeŋgâlân gâtŋe dondâŋe Yesu nâŋgaŋmâ biwiyeŋe Yesugâlân kali. ");
INSERT INTO tim_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania kepian luâk siâ kotŋe Lasaro are kundat dondâ yiep. Akto Mata gariŋâi Maria lâuwâ amâ kepia ain gâtŋeâk. ");
INSERT INTO tim_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria arekŋe Yesu tu higenŋe âlepŋe puliaŋmâ dumutŋande keiŋe puliaŋdo kamiliep yâkgât emiŋe Lasaro are kundat dondâ yiep. ");
INSERT INTO tim_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Akto mamaŋâi Yesugât den makmâ katbela ariep, “Humo gâ nâŋgâ. Galage kundat dondâ akmâ yendâp.” dâmbela ");
INSERT INTO tim_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuŋe pat are nâŋgâm hin dâep, “Lasaro âmâ kundat akmâ yem âmâ momo kârikŋe bo mombiap. Nâ Anutugât nanŋe nâ kulem mendere kotne akto Anutugât kotŋe mem agatbaigât kundat are miawaktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Akto Yesuŋe Mata akto gariŋe Maria akto Lasaro are yeŋgât okotŋe dondâ nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesuŋe kundat aregât pat nâŋgâm hilâm lâuwâ bo akto ");
INSERT INTO tim_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","hoŋ bawalupŋe hin makyeŋgiep, “Gambiâ Yudaia hânân purik katmâ arine.” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","hoŋ bawalupŋe hin dâm magaŋi, “Humo, nengât humomolupnenŋande âgâlânâk kâtŋe guguwerâm agi aregât wangât ariwerât?” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","hin makyeŋgiep, “Âi meme sop amâ 12 awa yendâp aregât âi meme sopŋân siâ yâk hân iregât pagaleŋân arimbo wanŋe me wanŋe bo ewuwiap. ");
INSERT INTO tim_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dâ hândâkŋân siâ pagaleŋe kulâgâtmâ arimbo âmâ wan me wan arekŋe ewum hioŋbiap.” dâep ");
INSERT INTO tim_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hain dâm âmâ den hin dâm dewatiep, “Dâ galanenŋe Lasaro asiŋ yendâp. Nâ arim goaŋberân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Hain dâm Yesuŋe Lasaro moepgât den ginŋeâk makyeŋgimbo âmâ yân asiŋgât maktâp dâm bo nâŋgâm heŋgemgoyi aregât hin dâm magaŋi, “Humonenŋe, asiŋ yem amâ âlepŋe akbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hain dâmbiâ Yesuŋe makmâ miawakmâ hin makyeŋgiep, “Lasaro moep. ");
INSERT INTO tim_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nâ ain manmâ galane heŋgemgoân dâine gain gain kulem humo ekmâ biwiyeŋe nâŋgâlânâk katmâ manbâi? Dâ yeŋe kulem humo ekmâ keine nâŋgâm heŋgemgowaigât bo ari heŋgemgoân aregât kambiamne heroŋe aktâp. Gârâmâ moepgât arine.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hain dâmbo Toma kotŋe siâ Didimo yâkŋe hin dâm makyeŋgiep, “Nen mombaengât bo hamep akmaen aregât nen yâk olop arine.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasaro sumân hilâm imbât yendo Yesuŋe arim miawagep. ");
INSERT INTO tim_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania amâ Yerusalem kepia ginŋân ewumâk talep. ");
INSERT INTO tim_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Arewa Yuda luâk dondâŋe arim Maria akto Mata emiyetŋe moepgât âi girâp akberâm ariyi. ");
INSERT INTO tim_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Akto Mata Yesu dâwân togom mandâp dâmbiâ nâŋgâm gariŋe emelan tato are hepunmâ dâwân arim peniaŋep. ");
INSERT INTO tim_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Peniaŋmâ hin magaŋep, “Humo gâ in malen dâine emine bo mombop. ");
INSERT INTO tim_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Akto hinŋeâk gâŋgât gai nâŋgâm wan me wangât Anutu ulilaŋmenâ dowâk nâŋgâ giŋberâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Akto Yesuŋe hin magaŋep, “Emige golâ akmâ agatberâp.” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mataŋe hin magaŋep, “Manmâ hâmbâi sop humoân golâ akmâ agatbiap amâ nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Hain dâmbo hin magaŋep, “Golâ akmâ manbaigât Amboŋe amâ nâ. Aregât niŋemaŋe nâ nâŋgâ niŋbai âmâ manmâ mom amâ âlepŋe lâuwâŋe golâ akmâ manmâ âgâwai. ");
INSERT INTO tim_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dâ luâk siâ golâ manmâ nâŋgâniŋbiapŋe amâ momo bâlâk manmâ kârikŋe manmâ âgâwiap. Gâ den are nâŋgâm heŋgemgoât me?” dâm aikoep. ");
INSERT INTO tim_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aikombo hin magaŋep, “Humone maktât are amâ nâŋgâm heŋgemgoân. Akto areâk bo. Anutuŋe nanŋe huŋgunaŋdo gewiap dâm lâmgom gamaen amâ gâ.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hain dâm âmâ pârigim ari gariŋe Maria are konmâ yoŋâk hin magaŋep, “Ewenenŋe dâwân togom gâ gogondâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Akto Mariaŋe nâŋgâm areâk agatmâ Yesugâlai ariep. ");
INSERT INTO tim_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ariwerâmbo âmâ Yesu indâgen kepia ginŋân Mata den magaŋep ainâk kilep. ");
INSERT INTO tim_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Gârâmâ Maria dowâk agatmâ arimbo Yuda luâk âmbâle Maria biwiŋe sândugeâkgât âi mem emelan tali arekŋe sumângen indewerâm ariâp dâm hamiŋân ariyi. ");
INSERT INTO tim_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Dâ Mariaŋe arim peniaŋmâ ekmâ Yesugât keiŋân kâŋgom yem hin magaŋep, “Humo, gâ in malen dâine amâ emine bo mombop.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hain dâm indembo Yuda luâk âmbâle olop togoyi are olowâk indeyi. Indembiâ yekmâ Yesu kambiamŋe bâliep. ");
INSERT INTO tim_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hain akmâ aiyeŋguep, “Yâgâten hangoyi.” dâmbo hin dâyi, “Humo, togom ek.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hain dâmbiâ Yesuŋe indiep. ");
INSERT INTO tim_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Akto kili arekŋe ekmâ hin dâyi, “Ekŋet. Nâŋgâ nâŋgâŋe amâ yâkgât dondâ nâŋgâmap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dâ bikŋande hin dâyi, “Dewunŋe bok bokŋe siâ makto dewunŋe hulaŋ agep aregât âlepŋe Lasaro heŋgemgombo dâine golâ akbop.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Akto Yesuŋe kambiamŋe bâlimbo sumângen ariep. Lasaro hâkŋe amâ kât dâpŋângen yiep. Dâ hâŋgi amâ kât humo siâŋe hâkokombiâ ge tigiep. ");
INSERT INTO tim_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aregât Yesuŋe hin dâep, “Kât hâkokoŋet.” dâmbo Lasarogât mamaŋe Mataŋe hin dâep, “Humo, hilâm imbât yiepgât higenŋe aktâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Hain dâmbo hin magaŋep, “Den makgiŋdere a bo nâŋgât. Hin. Gâ nâŋgâniŋmenâ Anutu kârikŋaet kulem miawakto ekberât.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Akto kât hâkokombiâ Yesuŋe dewunŋe egon panmâ hin ulilaŋep, “Apo, gâ ulit giŋdere nâŋgât aregât mepaige akgiŋdân. ");
INSERT INTO tim_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Akto ulit giŋdere ainâk dowâk nâŋgâmat aregât nâŋgâre âlepŋe aktâp. Dâ nâ luâk âmbâle yân yu kinmâ ariâi irekŋe gâŋe huŋgun niŋmenâ geân aregât biwiyeŋande nâŋgâm heŋgemgoŋetgât hain makgiŋdân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hain dâm kârikŋeâk konmâ, “Lasaro agatmâ gut.” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","momoŋe arekŋe agatmâ gulep. Keiŋe bâtŋe sâŋgum duwatmâ dâgâm menduguyi akto enem dewunŋe sâŋgumŋe katipkoyi aregât Yesuŋe hin makyeŋgiep, “Sâŋgum gagaim panbiâ ariâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Akto Yuda luâk dondâ Mariagâlân togoyi are yeŋgâlân gâtŋe dondâŋe Yesuŋe kulem mendo keiŋe ekmâ nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dâ bikŋande âmâ Yesuŋe kulem mendo egi aregât Parisaio yeŋgâlân arim wan me wan agep aregât den pat makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Akto sumbe kat kat yeŋgât luâk humomolupyeŋe akto Parisaio luâk arekŋe nâŋgâm humomo oloŋ yekmâ hin makyeŋgiyi, “Luâk are kulem dondâ memapgât wanân gain gain agaŋbaen? ");
INSERT INTO tim_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nen ekmâ hansumbu akmâ mandenŋe âmâ luâk âmbâle dondâŋe yâkgâlân dewati metembiâ âmâ Roma luâkŋe gasa aknengim hân me sumbe emetŋe me wan me wan hârok hilipkom nengim watnenekbâi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Akto yâk yeŋgât galayeŋe siâ kotŋe Kaipa hombaŋ ain sumbe kat kat yeŋgât humo malep arekŋe hin dâep, “Ye han nâŋgâ nâŋgâyeŋe bâlâk mandâi. ");
INSERT INTO tim_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aregât hin makyeŋgire nâŋgâm akberâi. Nen hârok bâlim metewâengât luâk konok arekŋe dumnenŋân kinmâ moâkgât nâŋgâm heŋgemgone.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Den are ikiŋe nâŋgâ nâŋgâŋaet bo magep. Yâk âmâ hombaŋ sop ain sumbe kat katgât humo malep aregât den are bunŋe miawakbiapgât magep. Yesu amâ bunŋe dondâ luâk yeŋgât akmâ moâkgât makmâ hâreaŋi. Dâ keiŋe âmâ bo nâŋgâep hain. ");
INSERT INTO tim_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hain akto Yuda luâk âmbâle yâkgâlâk bo. Anutuŋe ikiŋe dâtâŋe hânŋe hânŋe hârok manmâ arimai hârok mendugu yekmâ kâmot konok akmâ manŋet dâm agaŋdo sumbe kat kat luâk Kaipa are hain makmâ hâreaŋep. ");
INSERT INTO tim_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Akto Kaipaŋe hain dâep ainba Yesu komberâm den âi keiŋe kali. ");
INSERT INTO tim_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aregât Yesuŋe Yuda luâk yeŋgâlân lâuwâŋe bo miawakmâ malep. Gârâmâ kepia siâ hân kamitŋe aregât ginŋân talep kotŋe Epraim ain hoŋ bawalupŋe meyekto ari mali. ");
INSERT INTO tim_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Akto aregât hamiŋân hombaŋ kotŋe Pasowa are tâlâgumbo kepia ginŋe ginŋe ainba luâk âmbâle dondâŋe Yerusalem kepia ain hombaŋ miawakbiapgât aregât Anutugât emetŋân kinbiâ huraguâkgât âgâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Âgâm sumbe emetŋân kinmâ Yesugât kulâgâtmâ hin dâm magaŋgi goaŋgi agi, “Ye gain gain nâŋgâi? Yesu hombaŋgât in togowerâp me bo?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Akto Sumbe kat kat humomolupyeŋe akto Parisaio luâkŋe âmâ den kârikŋe hin dâyi, “Yesu togom mando âmâ siâŋe ekmâ togom maknengimbo kala busi kâlegen katbaen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Akto hombaŋ kotŋe Pasowa akto hilâm 6 irawot akberâmbo ainâk Yesuŋe Betania kepian togoep. Akto Betania kepia amâ Lasaro moep ain Yesuŋe magaŋdo agatmâ golâ malep yâkgât kepia. ");
INSERT INTO tim_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesuŋe ain togombo ainâk Lasaroma Yesu togoâp aregât heroŋe maroŋe aknerâm sot oyi. Yesu akto Lasaro olop tatbiâ Mata Lasarogât mamaŋe yâkŋe sot mem gutmâ yeŋgimbo neyi. ");
INSERT INTO tim_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nembiâ ainâk Maria Lasarogât mamaŋe siâŋe umbâ konok tu higenŋe siâ âlepŋe puliŋe humo arekŋe Yesugât keiŋân kâiep. Akto dumutŋande pulimbo kamiliep akto higenŋe arekŋe emet kâleŋe ârândâŋ akto hârok nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Akto yâkgâlân gâtŋe siâ Yudasi Karioto kepian gâtŋe luâk arekŋe hâmbâi Yesugât gasa kewugu yekto Yesu meyi yâkŋe hin magep, ");
INSERT INTO tim_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Woe, âmbâle ire wangât hain aktâp nâŋgâre bo huraguâp. Dâ tu higenŋe ire luâk yeŋgienŋe hâukombiâ dâine nenŋe puli dondâ mem luâk âmbâle umburuk yeŋgiwâen ina.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Akto yâk amâ luâk umburuk yeŋgât nâŋgâm bo magep. Yâk âmâ puli damunŋe akmâ puli bikŋe kâmbu meminep aregât puligât dondâ nâŋgâm magep. ");
INSERT INTO tim_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","Hain dâmbo Yesuŋe hin dâm magaŋep, “Âmbâle iregât nâŋgâmbiâ bo bâliâk. Luâk âmbâle umburuk ire âmâ ye olop sop kâlep tatmâ âgâwai are tân yeŋguwerâm akbai amâ âlepŋe tân yeŋguwaigât sop tatbiap. Dâ nâmâ ye olop sop kâlep bo manbian aregât luâk âmbâle bikŋande tân nuguwerâm akberâi are âmâ sop bo akbopgât hinŋe dowâk tân nuguâkgât nâŋgân. Aregât âmbâle ire han nuguwaigât tu ire puli niŋdâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Akto Yuda kâmolân gâtŋe dondâ Yesu ain talep are nâŋgâm ekberâm yâkgâlân togoyi. Akto emelâk Yesuŋe makto Lasaro moep arekŋe sumânba agatmâ golâ malep akai ekberâm togoyi. ");
INSERT INTO tim_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lasaro golâk agep are togom ekmâ nâŋgâmbiâ humo akto biwiyeŋe Yesugâlân kali. Hain akbâigât sumbe kat kat humomolupyeŋande luâk âmbâle hârok hepun nenektâi dâm aregât Yesu akto Lasaro lâuwâ lâuwâ bugâŋe yetkuenŋe moet dâm aregât den âi meyi. ");
INSERT INTO tim_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Akto agatmâŋân luâk âmbâle dondâ hombaŋ aregât Yerusalem kepian togoyi arekŋe Yesu Yerusalem togom âgâwerâm agep pat are nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Akto Yesu dâwân peniaŋberâm matuk esenŋe mem dâwân arim hin dâm koli, “Luâk ire Humonenŋande huŋgun aŋdo giep. Akto nen Israe gâtŋe damun nenŋe togoâpgât aregât heroŋe akne.” dâm koli. ");
INSERT INTO tim_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Akto Yesuŋe doŋgi nanŋe siâ mem miawakmâ kakŋân tatmâ mem mâŋgimbo Yerusalem dâwân togoep. Amâ Anutugât Propete siâŋe hin kulemgoep, ");
INSERT INTO tim_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sioŋ ambolupŋe hin makyeŋgire nâŋgâŋet. Yeŋgât Humoyeŋe togowiap yâkŋe doŋgi nanŋe kakŋân togombo ekbai aregât hamep bo akŋet.” dâm kulemgoep. Den are bunŋe akto Yesuŋe doŋgi nanŋe siâ kakŋân tato Yerusalem âgâep. ");
INSERT INTO tim_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Akto sop ain hoŋ bawalupŋe âmâ Yesuŋe siâ siâ miep aregât keiŋe bo nâŋgâm heŋgemgoyi. Dâ hamiŋân Yesu himbimân âgâmbo ainâk nâŋgâ nâŋgâyeŋe hulaŋ akto kulem esenŋe tâmbâŋân Yesuŋe wan me wan akbiapgât kulemgoyi are hârok nâŋgâm meteyi. Akto ainâk luâk âmbâleŋe wan agaŋbaigât kulem esenŋân tatâp are bunŋe akto sop ain âmâ aregât keiŋe boâk nâŋgâm heŋgemgoyi. ");
INSERT INTO tim_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Akto luâk âmbâle undup Yesu olop togoyi arekŋe Yesuŋe Lasaro konmâ goaŋdo momoŋânba agalep are egi aregât pat ain kili are makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hain dâm makyeŋgimbiâ ainâk kâmot humo arekŋe Yesuŋe kulem miep are dâwân peniaŋne dâm ariyi. ");
INSERT INTO tim_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ari peniaŋbiâ aregât Parisaio ain kili arekŋe hin magaŋgi goaŋgi akmâ dâyi, “Woe, luâk âmbâle dondâ Yesugâlân dewatiwerâm aktâi aregât gain gain aktenŋe Yesu hepunŋet aregât dâp bo tatâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Akto sop ain luâk âmbâle dondâ hombaŋ kotŋe Pasowa are tatmâ Anutugât kotŋe mem agatne dâm aregât Yerusalem togom mali. Are yeŋgâlân gâtŋe bikŋe amâ Girik luâk âmbâle. ");
INSERT INTO tim_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Akto Girik luâk irekŋe âmâ Pilipo Besaida kepia Galilaia hânân talep aregen gâtŋe yâkgâlân togom aikom hin dâm magaŋi, “Gala, nen Yesu ekberâm togoen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Akto Pilipoŋe gain gain aknerâm galaŋe Anderea magaŋep. Magaŋdo nâŋgâmbo lâuwâ lâuwâ Yesugâlân arim magaŋiat. ");
INSERT INTO tim_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Magaŋbela nâŋgâm den hâuŋe hin magep, “Bâin. Luâk akmâ geân nâ luâk âmbâle dondâŋe nekmâ kotne mem agatbai aregât sopŋe ewumâk aktâp. ");
INSERT INTO tim_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Den umatŋe ire makyeŋgire nâŋgâŋet. Seŋgo koaŋe hânân bo gem âmâ yân yembiap. Dâ hânân gewiap amâ hambum pâtkom bunŋe dondâ yembiap. ");
INSERT INTO tim_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Akto luâk âmbâle bikŋe are manmanyeŋe aregâlâk nâŋgâwai âmâ wan me wan arekŋe bâliyeŋgiwiap. Dâ luâk âmbâle bikŋe hâkyeŋe me wan me wan yeŋaet bo nâŋgâmai arekŋe âmâ hâmbâi manman kârikŋân manmâ âgâwai. ");
INSERT INTO tim_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yeŋgâlân gâtŋande nâ tân nuguwerâm akmâ âmâ âlepŋe nâŋgâlân togombiâ nâ olop manbaen. Akto nâŋe manbian ain hoŋ bawalupne arekai ain manbai. Akto niŋemaŋe tân nuguwai amâ Ewene Anutu arekŋe memeŋe akyeŋgimbo manman âlepŋân manbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Akto Yesuŋe Anutu hin dâm magaŋep, “Woe, kambiamne umatŋe dondâ akto aregât gain gain akbe? Apo, uŋak siâ siâ nâŋgâlân togowerâp aregât makmenâ bo agâk gârâmâ hain bo ak. Nâ iregât sop miawagâk dâm togom manmâ gan. ");
INSERT INTO tim_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aregât Apo gâ makmenâ kot patgaet kulem agat agatŋe miawakto luâk âmbâle dondâ ekmâ kotge mem agatbai.” dâep. Hain dâmbo ainâk den siâ himbimânba hin giep, “Nâ emelâk kot patnaet maktere miawaktâp. Akmâ kulem agat agatne areâk maktere miawakmâ âgâwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Akto kâmot kili arekŋe nâŋgâm bikŋande hin dâyi, “Himbim kururuŋdâp.” dâyi. Dâ bikŋande âmâ hin dâyi, “Aŋelo siâŋe den magaŋdâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Hain dâmbiâ Yesuŋe hin dâep, “Den amâ nâ nune tân nuguwerâpgât bo miawaktâp. Yeŋgât akmâ miawaktâp. ");
INSERT INTO tim_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Uŋak âmâ Anutuŋe hân iregât luâk âmbâle potat yekberâp. Akto Anutuŋe hân iregât Amboŋe hâkokombo yeukŋe akbiapgât sop irawot akbiap. ");
INSERT INTO tim_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Luâk bikŋande nâ lâwinân hokat nekmâ mem agatbiâ âmâ ainâk luâk âmbâle hânŋe hânŋe manmai are bikŋe oloŋyektere nâŋgâlân togowai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesuŋe hain magep amâ ikiŋe mombiapgât dopŋe katmâ makmâ makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hain makto aregât luâk âmbâle ain kili arekŋe den are nâŋgâmbiâ bâlimbo hin dâm magaŋi, “Woe, hain bo. Nen Mosegât denân oyaŋmâ hin nâŋgâmaen. Anutuŋe huŋgun aŋdo gewiap yâkŋe âmâ bo mombiap. Akto manman kârikŋân manmâ âgâwiap. Akto gâ hin dâmat, “Luâk akmâ geân.” dâmat aregât gain gain, “Lâwinân hokat nekbiâ mombian.” dât? Aregât niŋande luâk akmâ giep?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Hain dâmbiâ Yesuŋe hin dâm makyeŋgiep, “Sop tâlâwâk Anutugât pagaleŋe erâm âgâwerâp. Hâmbâi yâk hân iregât pagaleŋe hinare yeŋgâlânba agatmâ ariwiap aregât hândâkŋe katip yeŋguwopgât ye pagaleŋânâk bam gutŋet. Akto siâŋe hândâkŋân bam gutmap arekŋe yâgâten ariwiap amâ bo nâŋgâp. ");
INSERT INTO tim_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aregât uŋak âmâ ye pagaleŋânâk tatâiânâk hainâgâk pagaleŋaet nâŋgaŋbei. Yâk pagaleŋe hinare aregât pagaleŋân manberâmbiâ âmâ âlepŋe manman kârikŋân kat yekto pagaleŋân manmâ âgâwai.” dâep. Yesuŋe den ire makmâ metem âmâ hepun yekmâ gem heambugep. ");
INSERT INTO tim_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Akto emelâk Yesuŋe kulem hârok mendo egi amâ yâkgât keiŋe bo nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Haingât Propete Yesaiaŋe hin kulemgoep, “Humo, Propetelupge nenŋe âmâ arim gâŋgât den pat are arim makyeŋgienŋe luâk hârokŋe nâŋgâm hiaŋgim dâm bo nâŋgânengimai. Akto Kembugât bât are niŋaelân miawakmap?” dâm kulemgoep. ");
INSERT INTO tim_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Den are bunŋe akto luâk âmbâle dondâŋe Yesugât hâkâŋ akmâ yâkgât keiŋe bo nâŋgâm heŋgemgoyi. Akto Yesaiaŋe den siâ hin kulemgoep, ");
INSERT INTO tim_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anutuŋe dewunyeŋe mem bukom hanyeŋe gisapkoep. Amâ luâk âmbâle dewunyeŋande siâ me siâ ekmâ nâŋgâwâigât, akto hanyeŋân nâŋgâm kotgâwâigât, akto hanyeŋe purikatbiâ heŋgemyeŋguwomgât Anutuŋe hain dâm akyeŋgiep.” ");
INSERT INTO tim_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Akto Yesaiaŋe Yesugât keiŋe pagaleŋe hârok nâŋgâm metem âmâ aregât hain kulemgoep. ");
INSERT INTO tim_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dâ luâk âmbâle kotdâ bikŋe akto luâk âmbâle yânŋe bikŋe Yesugât keiŋe nâŋgâyi. Amâ Parisaio luâkŋe hin dâyi, “Luâk âmbâle bikŋande Yesu amâ Humonenŋe dâwai are den emetŋânba akto kepia yeŋânba wat yektenŋe hâkŋângen manbai.” dâyi. Aregât Parisaioŋe wat nenekbâi dâm aregât Yesugât keiŋe bo makmâ miawagi. ");
INSERT INTO tim_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Akto luâk âmbâle arekŋe Anutuŋe kotnenŋe mem agalâk dâm aregât ukenŋe bo nâŋgâmai. Dâ luâkŋeak kotnenŋe mem agatŋet dâm aregât ukenŋe nâŋgâmai. Hain akmâ Yesugât keiŋe bo makmâ miawagi. ");
INSERT INTO tim_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Akto Yesuŋe konmâ hin dâep, “Luâk âmbâle bikŋe nâŋgât nâŋgâi amâ nâŋgâlâk bo nâŋgâmai amâ Ewene huŋgun niŋdo togoân yâk hainâk nâŋgaŋdâi. ");
INSERT INTO tim_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Akto nâ nekmapŋe huŋgunniŋep yâk olowâk ekbiap. ");
INSERT INTO tim_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nâmâ hân iren pagaleŋe hainare togoân amâ luâk âmbâle biwiyeŋe nâŋgâlân katbai âmâ hândâkŋân bo manbai. ");
INSERT INTO tim_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Dâ luâk âmbâle bikŋe nâŋgât den nâŋgâm bo lokowai âmâ nâ hinŋe den âiân bo katyekberân. Nâmâ hânân luâk âmbâle ire potatyekbiangât bo togoân. Bo. Nâ luâk âmbâle heŋgem yeŋgum meyekberâm geân. ");
INSERT INTO tim_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Akto luâk âmbâleŋe haminiŋmâ nâŋgât den bo nâŋgâwai are amâ nâŋgât den arekŋe sop bâiŋân potatyekbiap. ");
INSERT INTO tim_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nâmâ den ire âmâ nune nâŋgâ nâŋgânân bo makmâ gan. Apo huŋgun niŋdo geân arekŋe nâ wan makman aregât âmâ makmâ hekat niŋep. ");
INSERT INTO tim_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aregât keiŋe amâ hin. Ewenande manman kârikŋaet keiŋe hekat yeŋgiwen dâm makniŋep areâk lokom Aponande makniŋewâk makman.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Akto hombaŋ kotŋe Pasowa are boâk miawakto Yesu hân ire hepunmâ Eweŋalae ariwiapgât sop miawakto nâŋgâep. Hain nâŋgâm âmâ ikiŋaet kâmot yeŋgât okotŋe dondâ nâŋgâep. Akto hainâk hainâk okotŋe dondâ nâŋgâm âgâwiap. ");
INSERT INTO tim_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Akto eŋgaiŋe sot nem tatbiâ emelâk Hiaŋgi Amboŋande Yudasi Karioto gâtŋe luâk siâ Simoŋgât nanŋe yâk Yesugât gasa hekat yeŋgiâkgât hâwâlep. ");
INSERT INTO tim_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Hâwâto lauŋe lokowerâmbo ainâk Yesuŋe Eweŋande siâ me siâ emelâk waŋep are nâŋgâep. Akto Anutuŋe huŋgun aŋdo gem manmâ benŋe purik katmâ Anutugâlai âgâwiap are gai nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Haingât sot hepunmâ agatmâ sâŋgum kakŋân luguagep are oloŋmâ pando gembo puliak puliak pâŋân dâgâep. ");
INSERT INTO tim_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hain akmâ kondo humoân tu kâim keiŋe katmâ Aposololupŋe yeŋgât keiyeŋe tu pulim âmâ pâŋân dâgâep arekŋe keiyeŋe pulimbo kamiliep. ");
INSERT INTO tim_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hain akmâ bam bam Petoro gâlân togoep. Akto Petoroŋe Yesuŋe wan akyeŋgiep aregât nâŋgâmbo umatŋe akto hin magaŋep, “Humo, nâŋgât keine bo puli. Hepun.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Akto Yesuŋe hin dâep, “Siâ siâ nâŋe uŋak aktân amâ gâŋe bo nâŋgât. Gârâmâ hâmbâi âmâ aregât keiŋe nâŋgâwiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dâmbo magaŋep, “Gâ keine bo puliwerât. Bo dondâ.” dâmbo hin magaŋep, “Dâ nâŋe bo puli gekberân âmâ gâ nâŋgâlân gâtŋe bo akberât.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Dâmbo magaŋep, “Humo, aregât nâŋgât hâkne hârok kautne bâtne me wan me wan puliniŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dâmbo dâep, “Luâk siâŋe hâkŋe hârok puliep yâk âmâ lâuwâŋe bo puliakbiap yâk âmâ keiŋeâk puliwiap aregât ye emelâk ye puliyektere biwiyeŋe salek aktâp. Dâ ye hârok bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Amâ Yesuŋe Yudasiŋe gasalupne makyeŋgimbo menekberâi nâŋgâm ye hârok bo dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Emelâk keiyeŋe pulim metem âmâ benŋe sâŋgum kâlep are lâuwâŋe mem luguakmâ tatmâ hin makyeŋgiep, “Nâ siâ siâ yu akyeŋgiân aregât keiŋe a nâŋgâi mon? ");
INSERT INTO tim_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yeŋe hin nogonmai, “Humonenŋe akto Tiksa.” dâmai amâ âlepŋe makmai. Nâmâ Humoyeŋe akto tiksayeŋe akman. ");
INSERT INTO tim_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Akto nâ Humoyeŋe akto tiksayeŋe nâŋe keiyeŋe puliân aregât hainâk galalupyeŋe keiyeŋe puliwei. ");
INSERT INTO tim_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nâŋe agak meme âlepŋe hekat yeŋgiân gârâmâ yekâ hainâk agak meme âlepŋe hekat yeŋgim hainâk akbei. ");
INSERT INTO tim_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nâ den bundâk makyeŋgire nâŋgâŋet. Âi luâk amâ damunŋe bo ewangimap. Akto luâk siâŋe luâk huŋgun aŋmap are bo ewangimap. ");
INSERT INTO tim_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Akto ye aregât nâŋgâi amâ siâ me siâ ire akbei. Akto hain akbai âmâ Anutuŋe meme akyeŋgimbo heroŋe humo akbai. ");
INSERT INTO tim_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nâmâ ye hârok yeŋgât bo maktân. Nâŋe nâŋgât kâmot hârok oloŋ yektere nâŋgâlân togoyi ye nâŋgâyekman. Dâ yeŋgâlân gâtŋe konok âmâ heroŋe bo akbiap. Amâ Anutuŋe makto siâŋe hin kulemgoep, “Nâŋgât gala nâ olop sot nendâp ire âmâ gasane akmâ bâleŋe akniŋbiap.” kulemgoep den are bunŋe akto yeŋgâlân gâtŋe siâ nâŋgât kâmolân gâtŋe bo akbiap. ");
INSERT INTO tim_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nâ ya maktân amâ boâk miawaktâp. Haingât hâmbâi ire miawakberâp âmâ âlepŋe yeŋe nâŋgât hin nâŋgâwai, nâmâ yâk, hain nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Den bunŋe hin makyeŋgire nâŋgâŋet. Luâk siâ nâŋgât âi meâkgât huŋgun aŋdere arimbo âmâ benŋe siâŋe tângowiap nâkai dop hainâk tân nuguwiap. Akto tân nuguwiapŋe Ewene huŋgun niŋep are dop hainâk tângowiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Akto Yesuŋe hain dâm biwiŋe umatŋe agep aregât den hin dâep, “Woe, yeŋgât hutyeŋân gâtŋe siâŋe nâŋgât gasalupne hekat yeŋgimbo menekberâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hain dâmbo yeŋeak âmâ konok konok niŋe me niŋe dâm luâk yeŋeâk ai aguyi. Niŋaet magep amâ bo nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Akto Yesuŋe okotŋe dondâ nâŋgaŋmap are Yesugât ginŋânâk talep. ");
INSERT INTO tim_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Haingât Petoroŋe yoŋâk bâtŋandeak konmâ hin dâm magaŋep, “Gâŋe aikomenâ nâŋgâne.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hain dâm magaŋdo Yesugât ginŋânâk talepgât are hin magaŋep, “Humo niŋaet maktât.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Akto Yesuŋe den hâuŋe hin magaŋep, “Sot bikŋe ire tuân panmâ waŋdere ekberâi amâ luâk are konok.” dâep. Hain dâm sot tuân pando gembo mem oloŋmâ Simoŋ Karioto kepian gâtŋe malep yâkgât nanŋe kotŋe Yudasi are waŋep. ");
INSERT INTO tim_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudasiŋe sot are mem nendo ainâk Hiaŋgi Amboŋande biwiŋân giep. Hain akto Yesuŋe magaŋep, “Wan me wan akberâm dowâk akben.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Hain dâm magaŋep aregât keiŋe ain tali arekŋe bo nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Siânbaŋe amâ hin nâŋgâyi. Amâ Yudasiŋe puli itoŋe memap aregât Yesuŋe hombaŋ iregât siâ siâ hâukoâkgât magaŋdâp me siâ siâ luâk umburuk yeŋgiwiapgât magaŋdâp hain nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Akto Yudasiŋe sot are mem nem âmâ dowâk gem hâkŋângen sopando emelâk emet dâgâep. ");
INSERT INTO tim_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasi arimbo âmâ ainâk Yesuŋe hin makyeŋgiep, “Hinŋe Anutuŋe huŋgun niŋdo geân aregât keiŋe luâk âmbâle dondâŋe nâŋgâm kotne mem agatbai aregât dâp miawaktâp. Akto wan membian aregât akai Anutugât kotŋe mem agatbai. ");
INSERT INTO tim_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Akto nâ wan akberân aregât Anutugât keiŋe miawakto ekmâ kotŋe mem agatbai amâ benŋe uŋak Anutu nâŋgât keine mem miawagân katberâp. ");
INSERT INTO tim_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hoŋ bawalupne, nâ ye olop sop pâŋ konok tatberen. Hâmbâi arire undâgât nekbiâ bo akberâp. Akto nâ ulikŋân Yuda humomolupyeŋe akto sumbe kat kat luâk akto Parisaio luâk hin makyeŋgiân. Nâ ariwian ain yeŋe bo ariwai. Akto benŋe hainâk hinŋe ye makyeŋgiân yâgâten ariwerân aregen ye bo ariwerâi. ");
INSERT INTO tim_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Akto nâ den kârikŋe aŋgâ makyeŋgiân hin. Ye hanâk gala okot akmâ tân aguwei. Nâŋe ye okot âlep akmâ gala akyeŋgiân hainâk gala agaŋgiwei. ");
INSERT INTO tim_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hain agaŋgiwai âmâ luâk âmbâleŋe yekmâ hin dâwai, “Âo imâ Yesugât hoŋ bawalupŋe.” dâwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesuŋe hain dâmbo Petoroŋe aikoep, “Humo gâ yâgâten ariwerât?” dâmbo Yesuŋe den hâuŋe hin magaŋep, “Nâŋe kepia uŋak ariwerân aregen amâ watnekmâ bo ariwerât. Dâ hâmbâi âmâ watnekmâ togom nekbiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Hain dâmbo hin aikoep, “Humo, wangât gâ olop bo ariweretgât maktât. Amâ nâŋgâre bo huraguâp. Gasalupgande gugumbiâ âmâ tân gugure nugumbiâ mombian aregât ukenŋe nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Hain dâmbo hin dâep, “Hain akberât me? Galane aregât den bunŋe hin makgiŋdere nâŋgâ. Gâŋe nâŋgâ yâk bo nâŋgâ aŋman dâm muneŋ akmenâ âmâ sop âlâwu akto gokorok ainâk indewerâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuŋe hin dâm makyeŋgiep, “Kambiamyeŋe bo umatŋe agâk. Ye Anutugât nâŋgaŋmai aregât hainâk nâŋgât nâŋgâ niŋbei. ");
INSERT INTO tim_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ewenaet emet kepia amâ kom hâre hâreŋe dondâ. Dâ hain bo dâine aregât emelâk makyeŋgiwom. Nâ ariwerân imâ yeŋgât gewâk heŋgemgowian. ");
INSERT INTO tim_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Akto gewâkyeŋe heŋgemgom metem âmâ benŋe purik katmâ togom kewugu yektere arim nâ olop ain manbaen. ");
INSERT INTO tim_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Akto nâŋe kepia ain ariwerân aregât ye nâŋgâi. Akto ye ariwaigât dâp nâŋgâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Hain dâmbo Tomaŋe hin aikoep, “Humo, gâ yâgâten ariwerât? Nen bo nâŋgâen aregât nen gain gain akmâ dâp aregât keiŋe nâŋgâweren?” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuŋe hin magaŋep, “Nâ nunak konok dâp bunŋe akto nâ nunak konok den bunŋaet keiŋe akto nâŋeak manmangât keiŋe. Aregât luâk âmbâle bikŋande Anutu nâŋgaŋberâm âmâ nâ nâŋgâ niŋmâ âmâ âlepŋe Anutu nâŋgaŋbai. Dâ haminiŋmâ âmâ Anutu bo nâŋgaŋbai. ");
INSERT INTO tim_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Akto yeŋe ulikŋân nâ nekmâ nâŋgâniŋmai dâine Ewene hainâk ekmâ nâŋgaŋbâi. Uŋak nâ wan memberân aregât akmâ âmâ Anutugât keiŋe ekmâ nâŋgâm heŋgemgoâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Hain dâmbo Pilipoŋe hin magaŋep, “Humo, Ewege are hekatnengimenâ ekmâ biwinenŋe sândugeâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dâmbo hin magaŋep, “Pilipo, nâ ye olop tatmâ mandenŋe sop kâlep bo agep aregât wangât boâk nâŋgât? Nâŋgâ niŋmat maine Apogât nâŋgâwât. Luâk siâ nâ nekmap amâ Apo ekmap aregât gain gain akmâ, “Ewege hekatnengi.” dât? ");
INSERT INTO tim_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Akto nâmâ Apogâlân tatân akto Apo yâkŋe nâŋgâlân tatâp aregât net dop konok aktet aregât keiŋe bo nâŋgâm âmâ hain maktât. Akto den makyeŋgiman amâ nune nâŋgâ nâŋgânân gâtŋe bo. Apo nâŋgâlân tatmap arekŋe âiŋe ketugumbo yâkgât den makyeŋgiman. ");
INSERT INTO tim_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ye den ire nâŋgâm heŋgemgowei. Nâŋe Apogâlân tatân akto Apo yâkŋe nâŋgâlân tatâp. Dâ den are nâŋgâmbiâ umatŋe akto âmâ âlepŋe nâŋe âi meman are ekmâ nâŋgât akto Apogât keinetŋe nâŋgâm heŋgemgowei. ");
INSERT INTO tim_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Galalupne, bunŋe makyeŋgire nâŋgâŋet. Luâk âmbâle bikŋe nâŋgât nâŋgâniŋbai amâ nâŋe âi meman hainâk yekâ âi membai. Akto nâ Apogâlân ariwerângât wan me wan meman are ewangim membai. ");
INSERT INTO tim_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Akto siâ siâ hârokgât yeŋe kotne mem manmâ ulilaŋbiâ âmâ dowâk Ewene kotŋe mem agatbaigât maktere miawakyeŋgiwiap. Miawakyeŋgimbo nâŋgât akto Apogât kotŋe agatbiap. ");
INSERT INTO tim_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dâ yeŋe wan me wangât nâŋgât kotne konmâ Apo ulilaŋbai âmâ nâŋe âlepŋe yeŋgiwian. ");
INSERT INTO tim_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Dâ yeŋe biwiyeŋân menekmâ âmâ âlepŋe nâŋgât den kârikŋe denyeŋguân are mem manbai. ");
INSERT INTO tim_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Akto nâŋe Apogâlân ulilaŋdere tângo tângo siâ nâ hinare yeŋgiwiap. Yeŋgimbo gem ye olop dondâŋe tatmâ tân yeŋgum âgâwiap. ");
INSERT INTO tim_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Amâ hingât maktân. Anutugât den bunŋe kautŋaet Heakŋe âlepŋe aregât maktân. Akto hângât luâk âmbâle arekŋe yâk bo membai. Akto bo ekmâ nâŋgâwai aregât bo nâŋgaŋbai. Dâ Anutugât Wâtŋe âlepŋe are emelâk ye olop tatâp gârâmâ hâmbâi kautyeŋân membiap. ");
INSERT INTO tim_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Akto nâŋe hinŋe ye hepun yektere âmâ nanaŋ mându hinare tatbâigât nâ yeŋgâlân purikatmâ togowian. ");
INSERT INTO tim_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Akto sop bâlensiâ âmâ hân luâk âmbâleŋe lâuwâŋe bo nekbai. Dâ yeŋe âmâ hâmbâi nekbai. Nâ mandân aregât yekâ hainâk manbai. ");
INSERT INTO tim_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Akto sop ain âmâ ye olop mandere ye hin nâŋgâwai. Nâ Ewenaelân tatân akto yeŋe âmâ nâŋgâlân tatâi. Akto nâkâ yeŋgâlân tatmâ âgâwian are nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Luâk âmbâle bikŋande nâŋgât lau lokomai âmâ âlepŋe okot âlep nâŋgâ niŋbei. Akto okot âlep nâŋgâ niŋbai amâ Ewenande okot nâŋgâ yeŋgiwiap akto nâkâ hainâk okot nâŋgâ yeŋgim âgâwian. Akto yeŋgâlân miawaktere nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hain dâmbo Yudasi siâ amâ Karioto gâtŋe bo arekŋe hin magaŋep, “Humo, gain gain dewun nenŋân miawakbiat amâ hân luâk âmbâle yeŋgât dewun yeŋân gain gain bo miawakbiat?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dâmbo magaŋep, “Dâ luâk âmbâle bikŋe biwiyeŋe nâŋgâlân katbiâ âmâ âlepŋe nâŋgât laune lokowai. Hain lokombiâ âmâ âlepŋe Ewenande âmâ are yeŋgât okotŋe akmâ nâŋgâ yeŋgim meme akyeŋgimbo heroŋe akbai. Akto nâ Ewene netŋe âmâ hilâmŋe hilâmŋe hokboâk togoetŋe olop tatmâ âgâwaen. ");
INSERT INTO tim_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Dâ luâk âmbâle bikŋe âmâ biwiyeŋe nâŋgâlân bo katbai amâ yâk nâŋgât laune bo lokowai. Akto den ire maktere nâŋgâi amâ nunandeân bo. Amâ Apogât den emelâk yâkŋe huŋgun niŋdo geân yâkgât den. ");
INSERT INTO tim_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nâ hinŋe ye olowâk tatân aregât nâŋe wan me wan iregât hârogâk makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dâ Apone ikiŋandeân Heak âlepŋe arekŋe yeŋgim tân yeŋguwiapgât nâŋgât kotnaet akmâ huŋgun aŋdo gewiap arekŋe âmâ siâ siâgât âlepŋe hârok hekat yeŋgiwiap. Akto arekŋe âmâ nâŋgâ nâŋgâyeŋe goaŋbiap. Hain akto âmâ nâŋe ulikŋân den makyeŋgiân are hârok nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Akto nâŋe kambiamyeŋe sândugeâkgât meme akyeŋgiwian. Akto hângât wan me wan yeŋgimai hain are bo yeŋgiman. Aregât nunak wâtne yeŋgire kambiamyeŋe bo sân sân mendo bo hamep akbai. ");
INSERT INTO tim_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Akto den imâ ye emelâk nâŋgâi, nâ hepun yekmâ ariwerân. Akto purik katmâ togowian. Aregât emelâk yeŋe kambiam âlep akniŋmai dâine nâŋe âlepŋe Apogâlân ariwian dâre nâŋgâmbiâ âlepŋe akbop. Akto Apo âmâ Humo nâ ewangi nektâp yâkgâlân ariwian dâre nâŋgâmbiâ âlepŋe akbop. ");
INSERT INTO tim_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ire boâk miawaktoân nâŋe aregât makyeŋgiân. Haingât hâmbâi wan me wan maktân ire miawakto amâ âlepŋe ye are ekmâ nâŋgâm nâŋgât keine nâŋgâm heŋgemgom kambiam âlep akbai. ");
INSERT INTO tim_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Akto hân iregât damunŋe uŋak togowerâp aregât nâ âmâ den dondâ siâ amâ bo makyeŋgiwerân. Dâ yâkŋe togom bâleŋe siâ siâ akniŋbiapgât kârikŋe bo talaŋmap. ");
INSERT INTO tim_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Gârâmâ Apogât okot âlep agaŋman aregât pat hârokŋe nâŋgâŋetgât Apoŋe wan makmâ hâre niŋep den are lokowerân. Bâin sopanmâ arine.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Akto Yesuŋe hoŋ bawalupŋe hin dâm makyeŋgiep, “Nâmâ waiŋ tâk dopŋe hainare. Dâ Ewene amâ waiŋ kalam amboŋe hainare. ");
INSERT INTO tim_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nâŋgât bât bâtne bikŋe âmâ bunŋe bo memai amâ Ewenande liŋgâtmâ panyekbiap. Dâ nâŋgât bât bâtne bikŋe bunŋe membai are âmâ bunŋe dondâ yeâkgât Ewenande hârem heŋgemgowiap. ");
INSERT INTO tim_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Akto ye âmâ nâŋgât den makyeŋgiman are nâŋgâmbiâ biwiyeŋân gembo biwiyeŋe salek salek agep aregât nâŋgâlân tatbei. ");
INSERT INTO tim_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ye nâŋgâlân tatbei. Akto nâ gai yeŋgâlân tatbian. Akto waiŋ bât bâtŋe arekŋe konŋân bo dewatimbo amâ bunŋe bo yembiap. Dop hainâk ye nâŋgâlân bo dewatim âmâ agak meme âlepŋe bo memai. ");
INSERT INTO tim_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nâmâ waiŋ tâkŋe dâ ye amâ bât bâtne. Ye nâŋgâlân tatbiâ nâ yeŋgâlân tatbian amâ bunŋe dondâ yembiap. Aregât ye nâ bâlâk manbai âmâ yeŋe wan me wan siâ âlepŋe bo akbai. ");
INSERT INTO tim_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Akto waiŋ bât bâtŋe siâ bunŋe bo yendo âmâ hârem panbiâ mondo ombai dop hainâk luâk âmbâle siâŋe nâŋgâlân tatmâ agak meme âlepŋe bo membai âmâ Ewenande hârem pan yekto momo kâlâwân ariwai. ");
INSERT INTO tim_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dâ yeŋe nâŋgâlân tatmâ nâŋgât den lokom manmâ âgâwai âmâ âlepŋe yeŋe ukenyeŋaet ulit niŋbiâ are hainâk yeŋgiwian. ");
INSERT INTO tim_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yeŋe bunŋe dondâ mem manbiâ âmâ nâŋgât hoŋ bawa bunŋe dâm yeŋgonbian. Hain yeŋgondere Ewenaet kotŋe humo sambelem ariwiap. Akto ye hain akbiâ âmâ luâk âmbâleŋe yekmâ, “Ire amâ Yesugât kâmot.” dâwai. ");
INSERT INTO tim_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Akto Ewenande nâ okot âlep akniŋmap dop hainâk nâkâ ye emelâk okot âlep akyeŋgiman aregât hilâmŋe hilâmŋe amâ nâŋe okot nâŋgâ yeŋgiman aregâlâk nâŋgâm manmâ âgâwei. ");
INSERT INTO tim_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Akto nâŋe Ewenaet lauŋe lokom yâkŋe han kalemŋaet okot nâŋgâ niŋmap aregât nâŋgâm gan. Ye dop hainâk nâŋgât laune lokom manbei. Hain manbiâ âmâ okot nâŋgâ yeŋgiman are nâŋgâŋet dâm meme akyeŋgire aregâlâk nâŋgâm manbai. ");
INSERT INTO tim_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Akto nâmâ yeŋgât heroŋe humo akman aregât nâŋgâm yekâ hainâk heroŋe humo akŋetgât akto biwiyeŋe sândugewiapgât yu makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nâŋgât den kârikŋe hin. Nâŋe okot âlep akyeŋgiân dop hainâk yekâ gala okot âlep agaŋgi goaŋgi akyeŋgiwei. ");
INSERT INTO tim_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dâ luâk siâŋe galaŋe tângowerâm âi humo mem mombiap amâ okot âlep tângo tângo irekŋe agak meme siânba hârok ewangiyekmap. ");
INSERT INTO tim_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aregât hin makbe. Ye âmâ nâŋgât den lokowai âmâ âlepŋe nâŋgât galalupne akbai. ");
INSERT INTO tim_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Akto luâk humo âmâ ikiŋe hoŋ bawalupŋe are ikiŋe nâŋgâ nâŋgâŋe bo hekat yeŋgimap. Yân âi yeŋgimbo memai. Haingât nâ âi luâk lâuwâŋe bo yeŋgonberân. Den hârok Apo gâlânba nâŋgâman amâ emelâk ye makyeŋgiminiân. Haingât galalupne dâm yeŋgonberân. ");
INSERT INTO tim_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dâ yeŋe hanyeŋaet akmâ nâ bo nâŋgâ niŋi. Bo. Nâŋe ye bo nâŋgâ niŋiân han kalemnaet akmâ oloŋyektere nâŋgât kâmot agi. Akto nâŋe âi yeŋgiân amâ yeŋe arim bunŋe mem lokoŋet dâm akto yeŋgât bunŋe are âlepŋe tatbiapgât oloŋyegân. Haingât âmâ yeŋe nâŋgât kolân Apogât ulit akbiâ âlepŋe yâkŋe wan me wan siâ yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Akto nâŋe den umatŋe are lâuwâŋe yu makberân. Ye gala okot âlep agaŋgiwei. ");
INSERT INTO tim_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Dâ hân luâk âmbâleŋe gasa akyeŋgimbiâ âmâ hin nâŋgâwei. Yâkŋe ulik gulik nâŋgât gasa akniŋi. ");
INSERT INTO tim_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dâ ye hân iregât kâmolân gâtŋe dâine hân luâk âmbâleŋe, “Woe, ire âmâ nengât kâmolân gâtŋe.” dâm tân yeŋguwâi. Dâ ye âmâ hân iregât kâmolân gâtŋe bo. Emelâk nâŋe han kalemnaet akmâ hân iregât agak meme hepunŋet dâm oloŋ yegân aregât pat hekat yeŋgiân amâ haingât hân luâk âmbâleŋe ye gasa akyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nâŋe hin makyeŋgiân are bo nelâm yeŋgiâk. Âi luâk amâ humoŋe bo ewangimap aregât hin nâŋgâwei. Hân iregât ambolupŋande kuk akniŋmai âmâ benŋe hainâk kuk akyeŋgiwai. Dâ gala akniŋmâ denne lokoyi dâine gala akyeŋgim den yeŋe lokowâi. ");
INSERT INTO tim_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dâ amâ Ewenande huŋgun niŋdo geân yâk hân iren gâtŋande bo nâŋgâ aŋmai. Haingât yekmâ ire amâ Yesugât kâmolân gâtŋe dâm yekmâ kuk bâleŋe akyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Akto nâŋe bo gem hân iregât ambolupŋe makyeŋgiân dâine dosayeŋe bo miawakbop. Dâ amâ gem makyeŋgiân gârâmâ dosayeŋe akto bâleŋeyeŋe heambukbaigât dop bo tatyeŋgiâp. ");
INSERT INTO tim_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Akto areâk bo. Luâk âmbâle hain arekŋe nâŋgât gasa akniŋbai amâ Ewene gai hainâk gasa agaŋbai. ");
INSERT INTO tim_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Are lâuwâŋe makbe. Nâŋe gem âi keiŋe keiŋe ulikŋân luâk siânbaŋe hain bo meyi are yeŋgât hut yeŋân bo meman dâine dosayeŋe bo miawakbop. Dâ emelâk kulem hârok mendere ekmâ âmâ nâ akto Ewene gasa aknetkimai. ");
INSERT INTO tim_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Akto Anutuŋe makto siâŋe hin kulemgoep are kârikŋe aktâp, “Luâk dondâŋe yân gasa akniŋdâi.” are bunŋe miawakto nâŋgât gasa undup miawakmâ gasa akniŋdâi. ");
INSERT INTO tim_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Akto hâmbâi Ewene ulilaŋdere ikiŋe Heak kârikŋe tân yeŋgumap are huŋgun aŋdo wan me wan bunŋe hekat yeŋgim nâŋgât keine hekat yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hain hekat yeŋgimbo nâŋe âi keiŋe kalân ainba nâ olop manmâ nekmâ gayigât nâŋgât keine makmâ miawakbiâ sambelem ariwiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesuŋe hin dâm makyeŋgiep, “Nâmâ yeŋe wan me wan miawak yeŋgimbo nâŋgâm gulip akbâi dâm yu makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nâŋgât gasalupnande amâ den emetŋânba watyekbiâ yânŋângen manbai. Akto areâk bo. Hâmbâi amâ yâkŋe hin dâwai, “Yesugâlân gâtŋe yeŋguenŋe mombai amâ Anutuŋe nenekto âlepŋe akbiap.” hain nâŋgâm yeŋgumbiâ mombai amâ akmâ hilipkowai. ");
INSERT INTO tim_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yâkŋe âmâ Apo akto nâ bo nâŋgâ netkimai. Haingât yeŋguwaigât ukenŋe nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dâ hâmbâi siâ siâ ire miawakbiap arekŋe yeŋgumbo nâŋgâ nâŋgâyeŋe hulaŋ akbiapgât den siâ siâ ire emelâk makyeŋgiân. Dâ ulikŋân bak âmâ nâ ye olop talân aregât ire bo makyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dâ uŋak amâ huŋgun niŋdo geân aregâlân ariwerân. Akto yeŋgât hutyeŋânba siâŋe bo ainuguwerâp, “Gâ yâgâten ariwerât?” ");
INSERT INTO tim_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nâ yu makyeŋgiângât nâŋgâmbiâ biwiyeŋe umatŋe dondâ aktâp. ");
INSERT INTO tim_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Galalupne, nâ bundâk makyeŋgire nâŋgâŋet. Nâ hepun yekmâ ariwerân amâ ye tânyeŋguwiangât. Dâ bo arire maine Anutuŋe Heak âlepŋe bo huŋgunaŋdo âmâ bo gem tânyeŋguwop. Dâ ariwian âmâ nâŋe âlepŋe huŋgun aŋdere togowiap. ");
INSERT INTO tim_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Gem luâk âmbâle hârok areyeŋgât keiyeŋe mem miawakbiap. Mem miawakmâ heŋgemgombo hin nâŋgâwai. Yeŋgât agak meme bâleŋe akbai aregât keiŋe nâŋgâmbiâ dosayeŋe miawakbiap. Akto Ewene agak meme ârândâŋ akmapŋe dosayeŋaet hâu membiap aregât amâ hâmbâi den âiân kat yekbiap are hârok nâŋgâiwai. ");
INSERT INTO tim_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aregât keiŋe lâuwâŋe makbe. Bâleŋaet keiŋe amâ hin hekat yeŋgiwiap. Yâk nâŋgât hâkâŋ akmâ biwiyeŋe nâŋgâlân bo katbai. ");
INSERT INTO tim_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Akto Ewenaet agak meme ârândâŋ are hekat yeŋgiwiap amâ hin. Apogâlân ariwian. Arire ye hinŋe yu kindâiŋe hinŋe nâ bo nekberâi. ");
INSERT INTO tim_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dâ Anutuŋe luâk âmbâle ire den âigât keiŋe hin hekat yeŋgiwiap. Hân iregât Amboŋe amâ emelâk Anutuŋe den âiân kato yâkgât bâleŋeŋe keiŋe miawaktâp. ");
INSERT INTO tim_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nâŋe den siâ siâ dondâ makyeŋgiwerâm aktân. Dâ yeŋe amâ uŋak memberâigât dopŋe bo. ");
INSERT INTO tim_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gârâmâ hâmbâi Anutuŋe ikiŋe Heak âlepŋe huŋgunaŋdo gem den bunŋaelâk hârok biwiyeŋân totokowiap. Arekŋe amâ ikiŋaet hanŋaet den bo makyeŋgiwiap. Anutuŋe wan me wan miawakbiap aregât keiŋe hekalaŋmâ huŋgun aŋdo makyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Akto nâŋgât keine nâŋgâmap aregât makyeŋgimbo nâŋgâmbiâ nâŋgât kot humo miawakbiap. ");
INSERT INTO tim_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Akto Apoŋe ikiŋaet nâŋgâ nâŋgâŋe are niŋdo aregât hin maktân. Anutugât Heakŋe arekŋe nâŋgât keine hekat yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Akto sop bâlensiâ aktoân amâ heambuktere bo nekberâi. Akto hâmbâi sop bâlensiâ siâ aktoân âmâ miawaktere nekbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesuŋe hain dâmbo hoŋ bawalupŋe bikŋande den are nâŋgâm pâpkoyi aregât nâŋgâm hin ai aguyi, “Amâ wangât maktâp? Apogâlân ariwerân aregât sop bâlensiâ heambuktere bo nekberâi akto hâmbâi nekbai dâm maktâp. ");
INSERT INTO tim_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Akto hin maktâp. Sop bâlensiâ ain nekbai dâm maktâp den are keiŋe gain gaingât maktâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Hain dâm amâ bo aikoyi. Akto Yesu aikowerâm agi aregât nâŋgâm hin makyeŋgiep, “Yeŋe nâ sopgât maktân aregât ainuguwerâi me? Sop bâlensiâ bo nekberâi. Dâ hâmbâi nekbai dâm maktân aregât keiŋe ainuguwerâm aktâi aregât hin makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Den bunŋe makyeŋgiwe. Hâmbâi inde humo indem okot nâŋgâ niŋbai. Akto sop ainâk hân iregât ambolupŋe heroŋe humo nâŋgâwai. Akto ye kambiamyeŋe umatŋe akbiap amâ benŋe siân purik âgâm okot âlep humo nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aregât den dopŋe siâ hin makbe. Âmbâle siâŋe nanaŋ meakberâm hâk hilâlâm humo nâŋgâmap. Gârâmâ benŋe nanaŋ miawakto sop ain amâ benŋe hâk hilâlâm lâuwâŋe bo nâŋgâmap. Bo. Amâ emelâk nanaŋ gurukŋe miawakto aregât okot âlep humo nâŋgâmbo hâk hilâlâm are emelâk nelâm aŋmap. ");
INSERT INTO tim_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Dop hainâk âmâ ye nâ ariwerân aregât okot bâle nâŋgâi. Gârâmâ nâŋe lâuwâŋe yektere nekmâ kambiamyeŋe heroŋe akbiap. Hain akbiâ luâk siâŋe kambiamyeŋe umatŋe agâkgât heyeŋgimbo dâp bo miawakbiap. ");
INSERT INTO tim_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Akto hâmbâi âmâ benŋe ai nuguwai aregât âi bo tatbiap. Akto den bunŋe hin makyeŋgire nâŋgâŋet. Yeŋe Apo siâ me siâgât ulilaŋbiâ kotnaet akmâ yeŋgiwiap aten. ");
INSERT INTO tim_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Akto keiŋân bak amâ siâ siâ memberâm nâŋgâm amâ nâŋgât kolân bo ulilaŋi. Akto hinŋe nâŋgât kolân Apo ulilaŋbiâ âmâ yeŋgât kambiamyeŋe heroŋe agâkgât dowâk Apoŋe yeŋgiwiap. Aregât kotne konmâ ulilaŋbei. ");
INSERT INTO tim_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Akto nâŋe wan me wan emelâk makyeŋgiân amâ den dopŋânâk makyeŋgiân. Hâmbâi âmâ Apogât keiŋe miapŋânâk makyeŋgiwian. Dâ den ginŋe amâ bo. ");
INSERT INTO tim_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Sop ain âmâ yeŋe nâŋgât kolân konmâ ulilaŋbai. Gârâmâ nâŋgât Ewenande okot âlep akyeŋgimap aregât kambiamŋe purik âgâkgât bo ulilaŋbian. ");
INSERT INTO tim_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bo. Ewene ikiŋak emelâk yeŋgât okot âlep akyeŋgimap. Akto yeŋe nâŋgât okot nâŋgâ niŋmâ Anutuŋe nanŋe huŋgun aŋdo luâk akmâ giep amâ Yesu dâm nâŋgâ niŋbai aregât Ewenande ikiŋak yeŋgât okot âlep akyeŋgimap. ");
INSERT INTO tim_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Akto nâ keiŋânbak Apo olop tatminiân. Akto sop akto hepunmâ hânân geân. Akto uŋak âmâ hân hepunmâ Apogâlân ariwerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesuŋe hain dâmbo hin magaŋi, “Woe, âlepŋe maknengiât. Den ginŋe bo maknengiâtgât dowâk âlepŋe nâŋgâen. ");
INSERT INTO tim_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Akto luâk bikŋande ai pei bo akgiŋbiâ hinŋe wan me wangât keiŋe hârok nâŋgâmat aregât nâŋgâen. Akto Anutugâlânba gien are gai nâŋgâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Hain dâmbiâ hin makyeŋgiep, “Âlepŋe nâŋgât keine hârok nâŋgâi me? Gârâmâ bunewâk bo nâŋgâniŋmai. ");
INSERT INTO tim_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aregât sop tâlâgumbo hepun nekmâ siâkâ emetŋân emetŋân arimbiâ âmâ nuneak tatberân. Dâ amâ nuneak bo tatberân. Amâ Apo olop tatberet. ");
INSERT INTO tim_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nâmâ nâŋgâ nâŋgâyeŋe nâŋgâlân tato biwiyeŋe sândugeâkgât nâŋgân haingât nâŋe den hain makyeŋgiân. Hânân ire âmâ umatŋe siâ siâ tatyeŋgim âgâwiap. Dâ nâŋe hângât dâtŋe metŋe ligiân aregât keiŋe nâŋgâm heroŋe akbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuŋe hain makyeŋgim metem âmâ dewunŋe egon panmâ Eweŋe hin magaŋep, “Apo, emelâk sop tâlâguâp aregât tek tekŋân katnekmâ nâŋgât kotne mem agat. Akto nâ lauge lokom âi ire mendere kotge humo akmâ sambelem ariwiap. ");
INSERT INTO tim_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Akto aregât hin makbe. Gâŋe emelâk hânân manbai areyeŋgât damunyeŋe akbiangât kârikŋe niŋen. Akto nâŋgât kâmot niŋen are manman kârikŋe yeŋgiwiangât makmâ hâreniŋen. ");
INSERT INTO tim_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Akto manman kârikŋe aregât keiŋe hin. Gâ konok amâ Anutu Humoyeŋe bunŋe amboŋe gâ. Akto gâŋe huŋgun niŋmenâ geân Yesu Kristo nâ akto gâ net lâuwâ nâŋgâ netkimbiâ âmâ tânyeŋguetŋe manman kârikŋe miawak yeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nâŋe gâŋgât kotge sambelem ariâkgât âi niŋen are emelâk mem metere hânân kotge humo akmâ sambelem ariep. ");
INSERT INTO tim_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Apo, hân bo miawagewân gâ olop himbim pagaleŋe olop malân. Areâk ire gaetŋe manmâ purikatmâ niŋmenâ mem manbiâm. ");
INSERT INTO tim_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Apo, ulikŋân nâŋgât kâmot yeŋgât kotyeŋe katmâ nâŋgâm nâŋgât dâtâŋe dâen. Akto hân miawakto nâŋgât kâmot kinbiâ luâk âmbâle bâleŋe akmai are yeŋgâlânba oloŋyekmâ nâ niŋmenâ nâŋgât dâtâŋe agi. Hain akmâ lauge hârok lokom meteyi. ");
INSERT INTO tim_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Gâŋe den makniŋen amâ hârok makyeŋgiân. Hain makyeŋgire nâŋgâm ire âmâ Anutugât den bunŋe dâm nâŋgâmai. Akto areâk bo. Gâŋe huŋgun niŋmenâ geân a hainâk nâŋgâm heŋgemgom âmâ nâŋgâniŋmai. Aregât hinŋe wâtgân kinmâ manman are hainâk nâŋgâm hârokgât keiŋe siâ siâ akai hainâk nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nâ tân yeŋguwerâm ulit giŋdân. Dâ luâk âmbâle hânân manmai areyeŋgât hârok bo ulit giŋdân. Gâ guge dâtâŋe are niŋen areyeŋgât ulit giŋdân. Dâ luâk âmbâle bikŋe bo. ");
INSERT INTO tim_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Akto gâŋgât patge amâ nâŋgât patne. Dop konok akmâ kotne mem agatmai. ");
INSERT INTO tim_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dâ uŋak âmâ hân ire hepunmâ gâŋgâlân togowerân. Akto nâŋgât kâmot âmâ hânân tatbai aregât gâŋe damunyeŋe akben. Akto Apo Humo, guge kotge wâtge emelâk niŋen arekŋe kârikŋe tân yeŋgumbo hânân manbaiân âmâ gulip bo akbai. Akto net han netŋe konok akmaet dop hainâk nâŋgât kâmot amâ hanyeŋe konok akŋetgât wâtge akyeŋgiwen. Akyeŋgimenâ hanyeŋe konok akbai. ");
INSERT INTO tim_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Akto nâŋgât kâmot ire olop gaen aregât gâŋgât kotge wâtgân kinmâ damunyeŋe aktere siâ me siâŋe bo hilip yeŋguep. Gârâmâ gâŋe makmenâ kulemgoyi are bunŋe agâkgât hinŋe makmenâ luâk bâleŋaet amboŋe are konok bâliâp. ");
INSERT INTO tim_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bâin. Nâ gâŋgâlai togowerâm aktân aregât nâŋgât kâmot yu kindâi ire nâŋgât okot âlep arekŋe yâk yeŋgâlân kilâkgât yu maktân. ");
INSERT INTO tim_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Denge emelâk makyeŋgiân. Akto hângât agak meme bo watman aregât ye hainâk hângât agak meme bo watmai. Hain akmai aregât hângât luâk âmbâleŋe gasa akyeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Haingât hin ulit giŋbe. Gâŋe damunyeŋe akmenâ Bâleŋe Amboŋe arekŋe bo hilip yeŋguwiâp. Nâmâ hânânba ire meyekmenâ himbimânâk hinŋe âgâwerâi aregât bo ulit giŋdân. Bo. Hânân manbaiân sop ain damunyeŋe akmenâ bo hilip aguwai aregât ulitgiŋdân. ");
INSERT INTO tim_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Akto nâ hân iregât agak meme bo watman aregât ye amâ hainâk hân iregât ambolupŋe bo. ");
INSERT INTO tim_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gâŋe den bunŋande hanyeŋe mendugumenâ agak meme âlepŋe aregâlâk nâŋgâm watbai. Gâŋgât pat âlep den arekŋe amâ den bunŋe. ");
INSERT INTO tim_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Gâŋe ulikŋân huŋgun niŋmenâ hânân luâk âmbâle hut yeŋân talân. Hainâk amâ nâŋe huŋgun yeŋgire arim hân luâk âmbâle hut yeŋân manbai. ");
INSERT INTO tim_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Akto nâŋgât kâmot ire den bunŋande hanyeŋe mem mendugumbo agak meme âlepŋe mem manŋetgât nâ gai yâk yeŋgât akmâ han hâkŋe mem mendugum âmâ den lauge lokom mandân. ");
INSERT INTO tim_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Apo, nâmâ gâŋe ire konok tân yeŋguwengât konok bo ulit giŋdân. Hâmbâi luâk âmbâle dondâ hânŋe hânŋe manbai arekŋe nâŋgât kâmot ire yeŋgât den nâŋgâm biwiyeŋe nâŋgâlân katbai are yeŋgât ulit giŋdân. ");
INSERT INTO tim_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yâk hârok han biwi konok tatbaigât nâŋgân. Apo, gâŋe nâŋgâlân tatât akto nâŋe gâŋgâlân tatân aregât han netŋe konok dop hainâk yâk netgâlân tatmâ manbiâ luâk âmbâle hârok tatmâ manbai arekŋe gâŋe huŋgun niŋmenâ geân aregât keine nâŋgâwai. Are miawakbiapgât ulit giŋdân. ");
INSERT INTO tim_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Akto gâŋe keige hârok hekatniŋmenâ nâŋgân aregât emelâk hekatyeŋgim meteân. Akto netŋe gala konok tatmaet dop hainâk akŋet dâm hekatyeŋgiân. ");
INSERT INTO tim_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Akto areâk bo. Gâŋe nâŋgâlân tatmâ keige hekatniŋen are akto nâŋe yâk yeŋgâlân tatmâ keine hekatyeŋgiân a hârok nâŋgâm yâk gala konok dondâ akbaigât nâŋgân. Hain gârâmâ luâk âmbâle hânŋe hânŋe manmaiŋe gâŋe huŋgun niŋen are akto okot nâŋgâ niŋmat hainâk nâŋgât kâmot okot nâŋgâ yeŋgimat are nâŋgâwaigât ulit giŋdân. ");
INSERT INTO tim_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Apo, gâŋe luâk âmbâle emelâk niŋen are nâ olop tatbaengât nâŋgân. Nâ olop tatmâ âmâ gâŋe hân bo talewân okot nâŋgâ niŋmâ pagaleŋe niŋen are ekmâ nâŋgâwai aregât nâŋgân. ");
INSERT INTO tim_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Apo, wan me wan memenâ ârândâŋâk akmap gâ hân luâk âmbâle arekŋe gâŋgât keige bo nâŋgâgiŋdâi. Dâ nâŋe âmâ nâŋgân. Akto nâŋgât kâmot yu kindâi irekŋe gâŋe huŋgun niŋen aregât keine nâŋgâi. ");
INSERT INTO tim_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nâŋe gâŋgât kotge denge hekat yeŋgiân. Akto nâ hâmbâi kotge hârok dondâ hekat yeŋgiwian. Amâ gâŋe han kalem okot âlep dondâ akniŋmâ tân nugumat han kalem arekŋe biwi yeŋân gembo nâŋgât keine nâŋgâwai, aregât ulit giŋdân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuŋe den are makmâ metem âmâ hoŋ bawalupŋe olop kepianba tu kotŋe Kindoroŋ hâtikoyi. Hâtikom kalam siâ lâwin oliwa kinbiâ ain ariyi. ");
INSERT INTO tim_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Akto Yudasi Yesugât gasa arekŋe Yesu akto hoŋ bawalupŋe ain âgâmini aregât kalam are nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Haingât Yudasiŋe Parisaio akto sumbe kat kat luâk are yeŋgât tembe lokolupyeŋe kewugu yekto aregen togom kemdâ akto tembe akto bugâ mem togoyi. ");
INSERT INTO tim_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kalam ain togom penâyeŋgimbiâ Yesu amâ wan me wan ikiŋaelân miawakberâp aregât âmâ bunewâk nâŋgâep aregât bam enem yeŋân kinmâ hin makyeŋgiep, “Ye niŋaet kulâgâtâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hain dâmbo hin dâyi, “Nen âmâ Yesu Nasarete gâtŋe yâkgât kulâgâten.” dâyi. Hain dâmbiâ hin makyeŋgiep, “Amâ nâ ire.” dâep. Akto Yudasi halop hogogo luâk hutyeŋân kilep. ");
INSERT INTO tim_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuŋe “Amâ nâ ire.” dâmbo ainâk kuŋ kâruŋ ge hânân ge yeyi. ");
INSERT INTO tim_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hânân ge yembiâ lâuwâŋe ai yeŋguep, “Ye niŋaet kulâgâtâi?” dâmbo, “Yesu Nasarete gâtŋe.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","hin makyeŋgiep, “Nâ emelâk makyeŋgiân. Nâ amâ ire. Akto ye nâŋgât kulâgât niŋdâi aregât âlepŋe luâk ire hepun yekbiâ ariŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hain dâep amâ den emelâk Yesuŋe Anutu hin magaŋep, “Luâk ire hârok imâ gâŋe emelâk niŋen amâ damunyeŋe akmâ gan aregât siâ bo hilip aguyi.” dâep. Den are bunŋe agâkgât, “Luâk ire hepun yekbiâ ariŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Akto Petoro amâ tâwât kâlep meagep arekŋe Sumbe kat katyeŋgât humoyeŋe yâkgât hoŋ bawa siâ kotŋe Maiko orem ondopŋe bungen hâriep. ");
INSERT INTO tim_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Petoroŋe hain akto âmâ Yesuŋe hin dâm magaŋep, “Tâwât are katmenâ itoŋânâk geâk. Apoŋe hâk hilâlâmgât makmâ hâreniŋep are miawak niŋâkgât nâŋgân are bo miawakniŋâkgât aktât mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yesuŋe hain dâmbo damunyeŋande makto Yuda luâk yeŋgât tembe lokolupyeŋande Yesu mem hikoyi. ");
INSERT INTO tim_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hain akmâ Anasigât emelan soŋ mem ariyi. Akto Anasi amâ luâk siâ kotŋe Kaipa yâkgât laumatŋe. Akto Kaipa amâ hombaŋ aregât Sumbe kat kat luâk are yeŋgât humoyeŋe. ");
INSERT INTO tim_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Akto Kaipasiŋe âmâ emelâk Yuda luâk humomolupyeŋe hin makyeŋgiep, “Nen hârok bo akbâengât âlepŋe luâk konok kondenŋe moâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Akto bugâ luâkŋe Yesu mem Anasigât emelan arimbiâ Petoro akto Yesugât galaŋe siâ yâk yetŋeâk watyegiat. Akto Anasiŋe Yesugât gala nâŋgaŋmap aregât Yesu ain âgâmbo hainâk Yesu olop arim Anasigât hetagân âgâep. ");
INSERT INTO tim_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Âgâmbo Petoro amâ iŋgon hâkŋângen kilep. Hain akto luâk are Anasigât nâŋgâep aregât sopanmâ hoŋ bawa âmbâle hâŋgi damunŋe are magaŋdo hâŋgi mem kato Petoro hetagân âgâep. ");
INSERT INTO tim_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Âgâmbo hoŋ bawa âmbâle arekŋe Petoro hin aikoep, “Dâ gâ amâ Yesugât hoŋ bawa siâ me gain?” dâmbo hin dâep, “Nâmâ bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Akto sop ain seru agep aregât bugâ luâk akto hoŋ bawa luâk kâlâp oyi. Kâlâp om nâŋgâm kinbiâ Petoro gai yâk olop kâlâp nâŋgâm kilep. ");
INSERT INTO tim_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Akto Sumbe kat kat humoyeŋe Anasi arekŋe Yesu ikiŋaet den akto hoŋ bawalupŋe yeŋgât keiyeŋe nâŋgâwerâm aikoep. ");
INSERT INTO tim_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aikombo hin magaŋep, “Wangât ainuguât? Nâmâ emelâk luâk âmbâle tek tekŋân den makyeŋgiman. Akto sumbe kat kat emetŋân me den emetŋân âgâm tek tekŋân makyeŋgiman. Me yâgâten me yâgâten Yuda luâk mendugum kinmai ain âgâm makyeŋgiman. ");
INSERT INTO tim_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nâmâ den yoŋâk siâ bo makyeŋgiman aregât wangât ainuguât? Luâk âmbâle den are nâŋgâmai are aiyeŋgu.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hain dâm magaŋdo bugâ luâk siâ ain kilep arekŋe Yesu ondopŋe hogom magaŋep, “Gâŋe amâ Sumbe kat kat luâk humoyeŋe hain bo magaŋ.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dâmbo hin magaŋep, “Gâ nâŋe den bâleŋe maktân aregât keiŋe mak. Akto nâŋe den âlepŋe maktân aregât wangât nuguât?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hain dâmbo Anasiŋe makto tâkŋe bâtŋe dâgâm mendugum sumbe kat kat humoyeŋe siâ kotŋe Kaipa yâkgâlân kewugum ariyi. ");
INSERT INTO tim_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Akto Petoro âmâ ain kinmâ kâlâp nâŋgâmâk kilep. Ain kindo olowâk kili arekŋe hin magaŋi, “Gâ gai yâkgât hoŋ bawa me gain?” dâmbiâ muneŋ akmâ hin magep, “Nâ bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Hain dâmbo âmâ Sumbe kat katgât hoŋ bawa siâ emelâk Petoroŋe ondopŋe kom hâriep aregât kâmolân gâtŋe arekŋe Petoro hin magaŋep, “Bundâk, gâ yâk olop kalamân kinbiâ yektân mon?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Akto Petoroŋe hainâk muneŋ akmâ, “Nâ bo.” dâmbo âmâ ainâk gokorok indiep. ");
INSERT INTO tim_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Akto emet hauŋ hauŋgât tembe loko arekŋe Kaipagât emelanba kewugum Roma gawaman humo aregât emelan âgâyi. Âgâm âmâ hin nâŋgâyi, “Nen hâmbâi hombaŋ Pasowa aregât sot nemberen. Aregât Anutuŋe nenekto huraguâkgât Yuda luâk bo manmai areyeŋgât emelan bo âgâweren.” nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Haingât hâkŋângen kili. Kinbiâ Pilato Roma gâtŋe arekŋe yâk yeŋgâlân gem makyeŋgiep, “Luâk ire keiŋe wangât den âiân katberâm aktâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hain dâmbo hin dâm magaŋi, “Dâ luâk ire agak meme bâleŋe bo akmap dâine amâ gâŋgâlân bo mem togowâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dâmbiâ hin makyeŋgiep, “Yeŋe agak meme dop yeŋân agaŋŋet.” dâep. Hain dâmbo Yuda humomolupyeŋande hin dâm magaŋi, “Roma luâk yeŋe luâk siâ kondenŋe moâkgât hain bo akŋet dâm makmâ hâre nengimai. ");
INSERT INTO tim_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yuda luâk hain akbiâ amâ Yesu ikiŋe mombiapgât den magep dâp are miawagep. ");
INSERT INTO tim_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Haingât Pilato gawaman emelan âgâ tatmâ Yesu kondo âgâep. Âgâmbo aikom magaŋep, “Gâ Yuda yeŋgât humo me?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Hain dâmbo hin dâep, “Gugak den are nâŋgâmat me gaingât maktât me luâk siâŋe nâŋgât hain dâm makgiŋep me?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dâmbo hin magaŋep, “Nâmâ Yuda gâtŋe bo aregât yeŋgât keiyeŋe bo nâŋgâ yeŋgiman. Guge kâmot akto bugâ lokolupgande meŋgekmâ nâŋgâlân togoâi ire gain gain agengât?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dâmbo hin magaŋep, “Nâmâ hân iregât luâk kembu bo. Dâ nâ hângât luâk kembu dâine âlepŋe âi luâklupnande bugâ mem kuk akbâi. Akto hoŋ bawalupnande Yuda gâtŋande menekbâigât bugâ mem kuk akyeŋgiwâi. Gârâmâ nâmâ hângât luâk kembu bo.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hain dâmbo hin magaŋep, “Hain gârâmâ gâ luâk kembu me?” dâmbo hin magaŋep, “Gugak ya maktât are. Nâmâ den bunŋe mak makgât keiŋe miawagâkgât himbimânba luâk akmâ hânân geân. Aregât luâk âmbâle bikŋe den bunŋe aregât ukenŋe nâŋgâne dâmbiâ makyeŋgire den bunŋe dondâ nâŋgâmai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Hain dâmbo hin magaŋep, “Den bunŋe amâ wan?” dâep. Hain dâm hâkŋângen Yuda luâk yeŋgâlâk gem hin makyeŋgiep, “Yâkgâlân bâleŋe siâ bo ektân. ");
INSERT INTO tim_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dâ amâ yeŋgât agak meme are watmâ hombaŋ iregât nâŋe luâk siâ hepundere yeŋgâlai geâk. Nâŋe Yuda yeŋgât kembu ire hepundere geâk me luâk siâgât nâŋgâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dâmbo yâkŋe kârikŋe konmâ hin dâyi, “Amâ bo. Gâmâ Baraba kala busi kâlegenba hepunmenâ betgen geâk.” dâyi. Amâ Barabaŋe âmâ luâk yeŋgum siâ siâ kâmbu meyeŋgiminep aregât. ");
INSERT INTO tim_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Akto Pilatoŋe makto tembe lokolupŋande Yesu mem tâk metŋande orem metem âmâ ");
INSERT INTO tim_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","benŋe tâk dâtâ dâtâŋe irimut ketugum kauŋaŋi. Hain akmâ sâŋgum luguak luguak gilâm are luguaŋi. ");
INSERT INTO tim_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Akto enemŋân togom kâŋgom hiaŋgim hin dâyi, “Woe, Yuda yeŋgât kembu.” dâm enem dewunŋân bâtyeŋande hogoyi. ");
INSERT INTO tim_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Akto Pilatoŋe hâkŋângen gem Yuda luâk humomolupyeŋe hin dâm makyeŋgiep, “Woe, luâk ire kewugum geân. Amâ yâkgâlân bâleŋe siâ bo ektân aregât hepundere ariâkgât nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hain dâmbo Yesu tembe lokoŋe irimut dâtâ dâtâ akto sâŋgum gilâm luguaŋi akto kautŋân kauŋaŋi are olop ge kindo Pilatoŋe hin makyeŋgiep, “Luâk ire ekŋet.” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","sumbe kat kat humoyeŋe akto bugâ luâk humomolupyeŋande konmâ hin dâyi, “Lâwinân koŋet. Lâwinân koŋet.” dâmbiâ makyeŋgiep, “Nâmâ yâkgâlân bâleŋe siâ bo ektân aregât yeŋeak mem ari lâwinân koŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Hain dâmbo hin dâyi, “Nengât den kârikŋe siâ hin tatâp. Luâk irekŋe, “Nâ Anutugât nanŋe.” dâep aregât kombiâ moâkgât nâŋgâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dâmbiâ Pilatoŋe den are nâŋgâm hamep dondâ agep. ");
INSERT INTO tim_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nâŋgâm hamep dondâ akmâ âmâ purik katmâ Yesu kewugum Gawaman emelan âgâep. Âgâm Yesu magaŋep, “Gâ wânân gâtŋe?” dâmbo den hâuŋe bo magaŋep. ");
INSERT INTO tim_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bo magaŋdo Pilatoŋe hin magaŋep, “Gain gain? Gâ nâŋgâlân den bo maktât. Nâŋe maktere âlepŋe hepun gekbai akto maktere guguwai aregât kârikŋe tatniŋdâp. Dâ iregât keiŋe bo nâŋgât me gain?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hain dâmbo hin magaŋep, “Gâ Anutu Humo âurekŋe kârikŋe bo giŋdo dâine gâŋe mem ge katnekbâtgât dopŋe bo. Hain gârâmâ emelâk luâkŋe gasalupne kewugu yekto menektâi yâkgât dosa arekŋe gâŋgât dosa ewangiâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hain dâmbo Pilatoŋe hepundo âlepŋe ariâkgât nâŋgâm den dâpŋaet kulâgâlep. Dâ benŋe Yuda luâk âmbâleŋe konmâ hin dâyi, “Dâ gâŋe Yesu hepunmenâ ariwerâp âmâ gâ Sisa humonenŋe aregât galaŋe bo. Siâŋe nâmâ luâk kembu dâm âmâ Sisa dumŋân kinbiap aregât gâŋe guge nâŋgâ nâŋgâge watberâm luâk ire yân hepunmenâ gewerâp âmâ Sisaŋe nâŋgâm âmâ gâ gasa akgiŋbiapgât nâŋgâwiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatoŋe den are nâŋgâm Yesu mem hâkŋângen giep. Mem gembo kindo Pilato purik katmâ âgâm kembu tat talân talep. Akto tat tat ain hin konmini “Kât dâpŋe.” Aregât kotŋe Yuda yeŋgât denân amâ Gabata dâm konmini. ");
INSERT INTO tim_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sop ain amâ Pasowagât heŋgemgo heŋgemgo hilâmŋe. Akto Pilato ain tato hilâm tânâmŋe akto Yuda luâk hin makyeŋgiep, “Ekŋet. Luâk ire âmâ yeŋgât kembuyeŋe.” dâmbo konmâ hin dâyi, ");
INSERT INTO tim_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","“Moâkgât nâŋgâen aregât lâwinân ko.” dâyi. Hain dâmbiâ makyeŋgiep, “Nâŋe kembuyeŋe ire lâwinân kombegât nâŋgâi me?” dâmbo sumbe kat kat humomoŋe hin dâyi, “Nengât kembu siâ bo tatâp. Sisa a konok.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hain dâmbiâ Pilatoŋe Yesu lâwinân koŋet dâm wato yâk yeŋgâlân giep. ");
INSERT INTO tim_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Haingât Yesu ikiŋe membiâ ikiŋak lâwinŋe lokoagep. Akto kepia humo hepunmâ hân siâ hin konmai, “Hân hagitŋaet kautŋe.” Amâ Yuda denân Goligata ain mem ariyi. ");
INSERT INTO tim_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hân aregen Yesu akto luâk lâuwâ olop lâwinân yeŋguyi. Akto luâk lâuwâ are biken biken yetkuyi. ");
INSERT INTO tim_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yetkumbiâ Pilatoŋe den siâ hin kulemgoep, “Yesu Nasarete gâtŋe amâ Yuda yeŋgât luâk kembu.” hain kulemgom lâwinân kondo talep. ");
INSERT INTO tim_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Akto kulem are amâ Yuda yeŋgât denân akto Roma yeŋgât denân akto Girik yeŋgât denân hain kulemgoep are akto Yesu lâwinân koyi amâ kepia humo Yerusalem ginŋân aregât Yuda luâk âmbâle dondâŋe den are oyaŋmini. ");
INSERT INTO tim_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Oyaŋmâ âmâ Yuda yeŋgât Sumbe kat kat humomolupyeŋande Pilato hin magaŋi, “Yuda yeŋgât kembu hain bo kulemgo. Bo. Gâ hanâk den hin kulemgo. Luâk irekŋe hin dâmap, “Nâ Yuda yeŋgât kembu.” dâmap hain kulemgo.” dâm hâwâli. ");
INSERT INTO tim_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hain dâm hâwâtbiâ hin makyeŋgiep, “Den kulemgoân amâ emelâk kulemgoân are hainâk talâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Akto tembe lokoŋe emelâk Yesu lâwinân kombiâ kindo himbân siâ siâŋe meaŋi. Akto kâmot katmâ potatbiâ kâmot imbât agep. Akto sâŋgum luguak luguak gai meyi. Dâ amâ sâŋgum are bo parut parutŋe hin ketuguyi. Egonba iŋgon amâ bunewâk paruli. ");
INSERT INTO tim_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Haingât tembe lokoŋe magaŋgi goaŋgi akmâ hin dâyi, “Ire amâ bo duwatberen. Sâŋgum iregât kotnenŋe esenŋân ikiŋeâk ikiŋeâk kulemgom umbân pandenŋe gembo are mendenŋe ikiŋe kotŋe miawakberâp luâk arekŋe meakberâp.” dâyi. Hain akbiâ amâ benŋe Anutuŋe magep arekŋe bunŋe miawagep amâ hin, “Yâkŋe sâŋgum siâ siâŋe potatmâ membai akto kotyeŋe katbiâ kotŋe konok miawakto yâkŋe nâŋgât sâŋgum membiap.” Den are bunŋe akto tembe lokoŋe hain agi. ");
INSERT INTO tim_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Akto Yesugât lâwin ginŋân amâ Yesu memeŋe akto Yesu memeŋaet gariŋe are akto Maria siâ Kelopa âmbenŋe akto Maria Madala gâtŋe are hârok kili. ");
INSERT INTO tim_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Akto âmbâle are hârok Yesugât lâwin ginŋân kili. Yesu memeŋe akto okotŋe dondâ nâŋgâ aŋep are olop enemŋân kinbela Yesuŋe memeŋe magaŋep, “Meŋ, imâ gâŋgât nange hinare akmâ damunge akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Akto luâk are hin magaŋep, “Gala, imâ memege akmâ mando damunŋe akben.” dâep. Akto sop ain luâk arekŋe Maria are emetŋân ari katmâ damunŋe akmâ talep. ");
INSERT INTO tim_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Are bo akto Yesu hin nâŋgâep, “Âi siâ siâ uŋak bo aktâp. Bâin. Anutugât kulem esenŋe are âlepŋe bunŋe miawagâk.” dâm kârikŋe hin kolep, “Nâ tugât nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hain dâmbo umbâ siâ talep ain waiŋ ŋasukŋe pikmâ yiep. Akto ain kili arekŋe sâŋgum siâ mem umbân waiŋ higenŋe pikmâ yiep ain katbiâ giep. Gembo are mem oloŋmâ kâro kâlewân katmâ dâgâm Yesugât lauŋân kali. ");
INSERT INTO tim_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Katbiâ Yesuŋe are nem hin dâep, “Nâŋgât âi hârok bo aktâp.” dâm makmâ kâŋgom moep. ");
INSERT INTO tim_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Akto sop ain âmâ hombaŋ agatmâŋân miawakbiap aregât siâ siâ heŋgemgoyi. Akto Yuda gâtŋe are nâŋgâm hombaŋ bâliwop dâm aregât hâkyeŋe lâwinân sop kâlep tatbâi dâm Pilato hin magaŋi, “Luâk bâleŋe are yeŋgât keiyeŋe ligimbiâ dowâk mombiâ hâkyeŋe pandenŋe agatmâ hombaŋ are âlepŋe akbiap. Hombaŋ bâliwopgât makmenâ tembe lokolupgande keiyeŋe kom ligiŋet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hain dâmbiâ âlepŋe dâmbo tembe lokolupŋande gutmâ luâk lâuwâ Yesu olop yetkuyi are yetgât keiyetŋe kom ligimbiâ dowâk moyiat. ");
INSERT INTO tim_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Akto Yesu âmâ ekbiâ emelâk moep aregât keiŋe bo kom ligiyi. ");
INSERT INTO tim_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Dâ tembe loko siâŋe soŋ soŋŋe gasomŋân ewumbo dowâk arewa gilâm akto tu sopalep. ");
INSERT INTO tim_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Siâ me siâ are dewunŋe bunŋande egep yâkŋe makmâ miawakto bundâk miawaktâp. Akto ye den ire oyaŋbai âmâ den amâ bunŋe dâm biwiyeŋe Yesugâlân katbaigât magep. ");
INSERT INTO tim_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Amâ Anutuŋe makto luâk siâ kulemgoep amâ hin, “Nâŋgât hoŋ bawa aregât hagitŋe siâ bo kom ligiwai.” dâm kulemgoep den are bunŋe akto keiŋe bo kom ligiyi. ");
INSERT INTO tim_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Amâ Anutuŋe makto luâk siâŋe hin kulemgoep, “Nâŋgât hoŋ bawa ewumbiâ mombiap yâkgât hâkŋe tâŋâk ekbai.” are kulemgoep. ");
INSERT INTO tim_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Are bo akto Yosepe Arimataia gâtŋe Yesugât hoŋ bawa are yeŋgât hutyeŋân gâtŋe arekŋe yoŋâk togoep. Amâ Yuda luâk yeŋgât hamep akmâ han biwiyeŋe Yesugâlân kalep aregât keiŋe heambugep yâkŋe Yesugât hâkŋe memberâm Pilato magaŋdo, “Âlepŋe mem lokom ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Dâmbo Nikodemo ulikŋân hândâgân Yesugâlân togoep arekŋe Yesugât hâkŋe hambuwopgât dâm siâ siâ mem togoep amâ umatŋe dondâ amâ luâk lâuwâ lokowatgât dopŋe hainare mem togoep. ");
INSERT INTO tim_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Akto lâuwâ arekŋe Yesugât hâkŋe mem sâŋgumân katmâ siâ siâ hambuwopgât are olop dâgâyiat. Imâ Yuda luâk âmbâle areyeŋgât pat meyiat. ");
INSERT INTO tim_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu lâwinân koyi aregât ginŋân amâ kalam siâ tatâp. Akto kalam are amâ kât dâpŋe irakŋe ain hâŋgeiŋe luâk siâ bo hangoyi. ");
INSERT INTO tim_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Amâ agatmâ hombaŋ sopŋe tâlâguâk akto sum ewumâkgât sum are ginŋân tatmap ain kaliat. ");
INSERT INTO tim_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Akto Sonda ulik gulikgât sowân ain Maria Madala gâtŋe arekŋe sumângen hândâktâk dondâ togoep. Akto hândâk dâgâmâk yendo kât are sum dâtŋân bo talep are egep. ");
INSERT INTO tim_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ekmâ benŋe purik katmâ Petoro akto luâk Yesuŋe nâŋgaŋmap yâk yetgâlân togom miawak yetkim hin makyetkiep, “Humogât hâkŋe sumânba mem ariâi. Mem arim âmâ yâgâten katâi nâ bo nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hain dâmbo kepia hepunmâ sumângen pârigim ariyiat. ");
INSERT INTO tim_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dâ amâ galaŋe Petoro ewangim yâkŋe soŋ ariep. ");
INSERT INTO tim_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sum dâpŋân gutmâ kinmâ katmâ kâŋgom sâŋgumŋeâk yendo egep. Dâ kâlegen âmâ bo âgâep. ");
INSERT INTO tim_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Akto Petoro âmâ hamiŋân togoep yâkŋe ewangim kât kâlegen âgâep. Âgâm sâŋgumŋandeak konok yiep are egep. ");
INSERT INTO tim_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Akto sâŋgum siâ egep arekŋe amâ Yesugât kautŋe katipkoep sâŋgum are amâ sâŋgum bikŋe are olop bo talep. Sâŋgum are ligim siângen kato talep arekŋe siângen talep. ");
INSERT INTO tim_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bâin, galaŋe ulik gulik pârigim sumân togoep areâkâ hainâk kâlegen âgâep. Akto are ekmâ âmâ Yesu nâŋgaŋep. ");
INSERT INTO tim_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Dâ ulikŋân amâ Anutuŋe makto kulemgoyi are âmâ bo nâŋgâm heŋgemgoyiat. Amâ Yesu amâ momoŋânba agatbiap bo nâŋgâm ");
INSERT INTO tim_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","yâk purik katmâ kepiangen ariyiat. ");
INSERT INTO tim_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Akto Mariaŋe togom sum are hâkŋângen kinmâ indem kilep. Indemâk kinmâ kâŋgom kât kâlegen egep. ");
INSERT INTO tim_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Egeine aŋelo lâuwâ tatbela yelegep amâ sâŋgum kau kau luguagiat arekŋe ulikŋân Yesugât hâkŋe yiep haingen taliat. Siâŋe âmâ kautŋângen dâ siâŋe amâ keiŋaet gewâkŋângen taliat. ");
INSERT INTO tim_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tatbela yelekto Maria magaŋiat, “Barat, wangât indeât?” dâmbela hin dâep, “Siânbaŋe nâŋgât Humonaet hâkŋe mem lokom ariâi. Are yâgâten katâi are bo nâŋgân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hain dâm makmâ purik kaleine Yesu kindo egep. Dâ âmâ bo ekmâ nâŋgaŋep. ");
INSERT INTO tim_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuŋe magaŋmâ, “Barat, wangât indeât? Gâ niŋaet kulâgâtât?” dâmbo âmâ Mariaŋe luâk ire âmâ kalam amboŋe dâm hin magaŋep, “Apo, gâŋe Yesugât hâkŋe mem arim siângen katât aregât makniŋmenâ ain arim hâkŋe are lokom ariwerân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Hain dâm purik katmâ kindo Yesuŋe, “Maria.” dâmbo purik katmâ ekmâ hin magaŋep, “Raboni.” dâep amâ den purikŋe amâ Tiksa. ");
INSERT INTO tim_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dâmbo magaŋep, “Gâ paŋâk bo menek. Nâ egon boâk âgân. Apogâlae boâk ariân. Gârâmâ gâ arim galalupne hin makyeŋgiwen, “Yesuŋe hin makniŋdâp, Nâ egon âgâm nâ Ewene akto ye eweyeŋe yâkgâlae âgâwian. Akto yeŋgât damun akto nâŋgât damun yâkgâlae âgâwian.” hain dâp dâm makyeŋgiwen.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hain dâmbo ariep. Arim Aposolo makyeŋgim hin dâep, “Nâŋe emelâk Humo ektân.” dâm Yesuŋe den magaŋep are makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sonda ulik gulik aregât hilâm are dewutâ ge kulukberâm agep. Ain hoŋ bawalupŋe Yuda yeŋgât hamep agi aregât emet kâlegenâk hâŋgi tigim tali. Ainâk Yesuŋe togom hutyeŋân kilep. Kinmâ hin makyeŋgiep, “Bo hamep akŋet. Kambiamyeŋe yeukŋe talâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hain dâm bâtŋe akto gasomŋe hekatyeŋgiep. Hekatyeŋgimbo ekmâ kambiamyeŋe heroŋe agep. ");
INSERT INTO tim_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Akto Yesuŋe lâuwâŋe hin makyeŋgiep, “Kambiamyeŋe yeukŋe talâk. Apone emelâk huŋgun niŋdo geân. Hain akmâ nâkâ ye hainâk huŋgunyeŋgire ariwai.” dâm he dâmbo ");
INSERT INTO tim_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","heakŋe biwiyeŋân gembo hin dâm makyeŋgiep, “Ye Anutugât Heak âlepŋande gem kautyeŋân mendo wâtŋân kinmâ ");
INSERT INTO tim_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","luâk bikŋe yeŋgât dosa makmâ pulimbiâ âmâ bo akyeŋgiwiâp. Dâ bo makmâ pulimbiâ âmâ tatyeŋgiwiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesuŋe Aposolo yâk yeŋgâlai togoep sop ain âmâ Aposolo siâ kotŋe amâ Toma kotŋe siâ Didimo yâkŋe konok bo talep. ");
INSERT INTO tim_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Gârâmâ galalupŋe Aposolo bikŋande magaŋi, “Nen Humo emelâk ekten.” hain dâm magaŋbiâ Tomaŋe hin makyeŋgiep, “Bo. Nunak koyi gewâkŋe are bâtŋân ekberân me bâtnande ire gewâkŋân howaiwerân me bâtne ire ewuyiângen ain howaim âmâ nâŋgaŋberân.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hamiŋân hilâm 8 are bo akto Yesugât Aposololupŋe emet are kâlegen lâuwâŋe tali. Akto Toma âmâ olop tali. Akto hâŋgi âmâ hârok tigim tatbiâ ainâk Yesuŋe togom hutyeŋân kilep. Kinmâ hin dâep, “Kambiamyeŋe yeukŋe talâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hain dâm makyeŋgim purik katmâ Toma magaŋmâ hin dâep, “Gut. Bâtge bâtnân in katmenâ gulâk. Akto bâtne ek. Akto bâtge are gasomne ewunegi ire kâlegen katmenâ geâk. Gembo âmâ aregât han lâuwâ gaetŋe bo akmâ biwige nâŋgâlân katben.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hain dâmbo hin magaŋep, “Gâ Humone akto gâ Anutune.” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","magaŋep, “Gâ nekmânâk nâ nâŋgâ niŋdât me? Luâk âmbâleŋe bo nekmâ yân nâŋgâ niŋbai arekŋe amâ kambiamyeŋe heroŋe humo akbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuŋe kulem keiŋe aŋgâ aŋgâ hârok dewun nenŋân dondâ miep. Akto are hârok iren bo kulemgoân. Bikŋeâk kulemgoân. ");
INSERT INTO tim_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Dâ ire âmâ emelâk kulemgoân. Imâ Yesu amâ Anutugât nanŋe huŋgun aŋdo giep aregât keiŋe nâŋgâŋetgât kulemgoân. Dâ yeŋe ire oyaŋmâ Yesugât keiŋe nâŋgâm heŋgemgom nâŋgaŋmâ âmâ âlepŋe biwiyeŋe yâkgâlân katbiâ manman âlepŋe miawak yeŋgiâkgât akto dosayeŋe bo agâkgât yu kulemgoân. ");
INSERT INTO tim_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Benŋe are hamiŋân Yesuŋe Aposolo bikŋe are Galilaia bâtgum ginŋân manbiâ miawak yeŋgiep. Amâ luâk ire, ");
INSERT INTO tim_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoŋ akto Toma kotŋe siâ Didimo akto Natanae amâ Galilaia hânân talep Kana kepia ain gâtŋe. Akto luâk lâuwâ Sebedaiogât nanlogâtŋe akto Yesugât Aposolo lâuwâ siâ olop tali. ");
INSERT INTO tim_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Akto Petoroŋe hin makyeŋgiep, “Nâ gem iŋan oloŋberân.” dâmbo âkâ, “Nen olowâk arine.” dâm arim waŋgan âgâyi. Dâ amâ hândâk ain iŋangât âi humo mem âmâ iŋan bo meyi. ");
INSERT INTO tim_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Akto dewutâ gawerâm akto ain Yesu haru dâtŋân togo kilep. Dâ amâ Aposolo Yesuŋe kilep amâ bo ekmâ nâŋgaŋi. ");
INSERT INTO tim_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuŋe hin makyeŋgiep, “Galama, ye iŋan bikŋe siâ mendâi me?” dâmbo hin magaŋi, “Bo.” dâmbiâ ");
INSERT INTO tim_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","hin makyeŋgiep, “Bâin, ŋalu ŋaluyeŋe are waŋga aregât gasomŋe bâtŋe bungen hin panbiâ gembo iŋan bikŋe ain meyekŋet.” dâmbo ŋalu ŋalu panbiâ giep. Gembo ŋalu ŋalu kâlegen iŋan unduwâk pigi aregât oloŋbiâ umatŋe agep. ");
INSERT INTO tim_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Akto Yesuŋe okotŋe dondâ nâŋgaŋmap arekŋe Petoro magaŋmâ hin dâep, “Imâ Humo nenŋe.” dâmbo Petoroŋe nâŋgâm âmâ emelâk mâronŋe âi ketuguepgât oloŋmâ kalep are mem luguakmâ gem peniaŋberâm iŋgon tu kâlegen sopalep. ");
INSERT INTO tim_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Akto Aposolo bikŋande waŋga siâ mem togoyi. Togom ŋalu ŋaluân iŋan pikmâ yiep are tân yeŋgum oloŋmâ âmâ waŋga are haru ginŋângenâk talep aregât ŋalu ŋalu tu kâlegen talâk dâm oloŋmâ tu ginŋân âgâm kili. ");
INSERT INTO tim_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hain âgâm kâlâp siâ om yendo egi. Akto kâlâwân are iŋan siâ akto sot siâ kindo egi. ");
INSERT INTO tim_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ekbiâ âmâ Yesuŋe hin makyeŋgiep, “Iŋan uŋak mendâi are bikŋe mem gaŋet.” ");
INSERT INTO tim_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hain dâmbo Petoroŋe bam iŋan ŋalu ŋaluân are mem oloŋmâ ginŋângen gulep. Akto ŋalu ŋalu are kâlegen iŋan humomo yeyi are yeŋgât oyaŋyegi amâ 153 hain are egi. Dâ ŋalu ŋalu are âmâ bo hâre agep. ");
INSERT INTO tim_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ain kinbiâ Yesuŋe hin makyeŋgiep, “Yekâ gutmâ sot ire mem neŋet.” dâep. Dâ amâ Humoyeŋe aregât nâŋgâm bo aikoyi, “Gâ niŋe?” ");
INSERT INTO tim_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","bo aikombiâ gârâmâ Yesuŋe sot mem yeŋgiep. Akto iŋan gai olowâk mem yeŋgimbo neyi. ");
INSERT INTO tim_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Amâ Yesuŋe sumânba agatmâ miawakyeŋgimbo âlâwuŋe are akto Aposoloŋe egi. ");
INSERT INTO tim_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Sot nem metem tatmâ Petoro hin magaŋep, “Simoŋ Yohanegât nanŋe. Gâŋe âmâ luâk ire ewangiyekmâ nâŋgât okot âlep akmat me gain?” dâep. Hain dâmbo hin dâep, “Âo, Humo, gâ nâŋgât are nâmâ gala akgiŋman.” dâep. Hain dâmbo hin dâep, “Gâ nâŋgât kâmot damunyeŋe akben.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hain dâm lâuwâŋe aikoep, “Simoŋ, Yohanegât nanŋe, gâ nâŋgât okot âlep akmat me bo?” dâmbo, “Âo. Humo, gâ nâŋgât. Nâ gâŋgât gala akman.” dâmbo hin dâep, “Gâ nâŋgât kâmot damunyeŋe akben.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hain dâm âlâwuŋe hin aikoep, “Simoŋ, Yohanegât nanŋe, gâmâ nâŋgât gala me gain?” dâmbo âlâwuŋe aikoepgât nâŋgâmbo umatŋe akto magaŋmâ hin dâep, “Humo, gâŋe âmâ siâ siâ hârok nâŋgât. Nâmâ gâŋgât galage.” dâmbo magaŋep, “Gâ nâŋgât kâmot damunyeŋe akben. ");
INSERT INTO tim_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Akto wan miawak giŋbiap aregât makgiŋbe. Ulikŋân sigan talen sop ain egâliaŋgaet ariwerâm âmâ sâŋgum luguakmâ ain ariminen. Dâ hâmbâi sâmbâ akbialân sop ain âmâ yân kinmenâ gasalupgande keige dâgâm mendugum meŋgekmâ ain bo ariwian dâm makbiat ain meŋgekmâ ariwai.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Amâ Yesuŋe hin aregât magaŋep. Hâmbâi luâk siâŋe Petoro mem oloŋmâ kondo mombiap sop ain Anutugât kotŋe humo sambelem ariwiap. Haingât Yesuŋe dopkom den ire magaŋep. Hain akmâ Petoro magaŋep, “Gâ gam haminângen watnek.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petoroŋe purik dâm Yesuŋe okotŋe nâŋgâ aŋmap arekŋe watyelekmâ togombo egep. Akto yâk ulikŋân Yesugât Aposololupŋe olop konogân tatmâ sot neyi sop ain Yesugât enemŋânâk tatmâ hin magaŋep, “Humo, niŋande hâmbâi gasalupge kewugu yekberâp?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Akto Petoroŋe yâk ekmâ Yesu hin magaŋep, “Humo, luâk ire âmâ gain gain?” dâmbo ");
INSERT INTO tim_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuŋe magaŋep, “Yâk mandoân nâ purikatbian aregât yâkgât wangât maktât? Gâ yân gam watnek.” dâep. ");
INSERT INTO tim_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hain dâmbo den are Kembugât kâmot yeŋgâlân hanâk ariep, “Yohane âmâ bo mombiap.” dâep. Dâ Yesuŋe, “Yohane bo mombiap.” bo magep. Amâ, “Yânâk tatoâk nâ purik katmâ togowian me bo amâ gâŋgât pat bo aregât wangât maktât?” dâep. ");
INSERT INTO tim_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Akto yu kulemgoân ire hârok egân amâ den bunŋe akto nen amâ hainâk, “Den kulemgoân ire amâ bunŋeâk hârok.” dâyion. ");
INSERT INTO tim_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Akto siâ siâ ire hârok Yesuŋe agewâk. Dâ luâkŋe Yesuŋe wan ketuguep are kulemgowerâm âmâ âi humo membiâ dâp bo tatyeŋgiwop. Akto nâŋe hin nâŋgân. Kulemgombiâ dâine hân ire hârok amâ kulem esenŋe iregât dopŋe bo tatbop. Hain. ");
INSERT INTO tim_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O galane Teopilo, nâ emelâk den kulemgo giŋân are âmâ Yesuŋe hin dâm luâk âmbâle makyeŋgim makmâ malep aregât den pat hârogâk makgiŋmâ meteân. ");
INSERT INTO tim_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Aregât keiŋe âmâ hin. Anutugât Heakŋande Yesu tângombo âi keiŋe katmâ arim Aposolo luâk are mem oloŋyekmâ lauŋe bâiŋe makyeŋgim himbimân âgâwerâm agep. Aregât den pat kulemgom meteân. ");
INSERT INTO tim_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Akto aregât nengât akmâ hâk hilâlâm nâŋgâm mondo sumân katbiâ golâ akmâ momoŋânba agatmâ mando hilâm 40 akto ain miawak yeŋgim Anutuŋe damunyeŋe akbiap aregât keiŋe makyeŋgim mando ekmâ nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Akto mendugum yâk olop tatmâ manbiâ den hin dâm makyeŋgiep, “Yerusalem kepia hinŋe dowâk bo hepunbi. Ulikŋân hin makyeŋgiân. Ewenande ikiŋe Heakŋe are huŋgunaŋdo gewiapgât manbiâ gem tân yeŋgumbo ariwi. ");
INSERT INTO tim_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Luâk kotŋe Yohane yâkŋe tu mem puliyegep. Hain akto sop kâlep bo akto Anutuŋe ikiŋe Heakŋe are huŋgun aŋdo gem meme akyeŋgiwiap.” Yesuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Akto hilâm siân Aposololupŋe mendugum mali ain hin dâm aikoyi, “Humonenŋe, ulikŋân bâgilupnenŋande kepiaŋe kepiaŋe damun akyeŋgimini hainâk gâŋe hain akŋet dâm hinŋe maknengimenâ miawakbiap me siân dâmenâ miawakbiap?” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hain dâmbiâ hin makyeŋgiep, “Are miawakbiapgât sopŋe ye bo nâŋgâi. Ewenande nâŋgâm miawagâk dâmbo ain miawakbiap. ");
INSERT INTO tim_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hin konok makyeŋgire nâŋgâŋet. Anutugât Heakŋande gem kârikŋe akyeŋgimbo âmâ nâŋgât den âlepŋe makyeŋgiwaigât dop akbiap. Akto Yerusalem kepia ain manmâ keiŋe katmâ nâŋgât pat sambelem biken biken arimbo nâŋgâm metembiâ Yudaia hânângen me Samaria hânângen makmâ arimbiâ nâŋgâmbiâ hân bâiŋângen ârândâŋ akmâ ariwiâp.” ");
INSERT INTO tim_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hain dâm makyeŋgimbo ekmâ kinbiâ dewunyeŋân owâiŋe akmâ âgâep. Âgâmbo hamandatŋe mem tigimbo undâgâli. ");
INSERT INTO tim_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Undâgâtmâ himbimân tâŋâk ekmâ kinbiâ ainâk luâk lâuwâ mâronyetŋe kau golâ golâ arekŋe yâk yeŋgâlân dowâk miawagiat. ");
INSERT INTO tim_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Miawakmâ hin dâm makyeŋgiyiat, “Galilaia hânân gâtŋe, ye wangât dewunyeŋe egon panmâ tâŋâk ekmâ kindâi? Yesuŋe hepunyekmâ himbimân âgâmbo ektâi ina benŋe hainâk himbimângenba purik katmâ gewiap.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hain dâm hepunyekmâ arimbela Aposololupŋe Oliwa gimbâŋânba geyi. Akto Oliwa gimbâŋe amâ Yerusalem kepia ewumâk tatâp arewa purik katmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Arim Yerusalem kepian âgâm emet tali ain âgâyi. Akto Aposolo mali are âmâ kotyeŋe hin, Petoro, Yohane, Yakobo, Anderea, Pilipo, Toma, Batolomaio, Yakobo siâ Alipaiogât nanŋe, Roma yeŋgât hâkâŋ agi are yeŋgâlân gâtŋe siâ kotŋe Simoŋ akto Mataio. Akto Yudasi siâ Yakobogât nanŋe. ");
INSERT INTO tim_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aposololupŋe, Yesugât memeŋe, emilupŋe akto âmbâle bikŋe menduguyekbiâ olop tatmâ biwi konok akmâ tatmâ Anutu den magaŋi. ");
INSERT INTO tim_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sop ain biwiyeŋe Yesugâlân katmini are yeŋgât galalupyeŋe 120 arekŋe mendugum kinbiâ Petoroŋe tânâmyeŋân agatmâ kinmâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Galalupne, Yudasigât makyeŋgire nâŋgâŋet. Yesugât hoŋ bawa kotŋe Yudasi yâkŋe nen olop manmâ âi miep ina gasa ulik gulik akmâ hekat yeŋgimbo Yesu meyi. Amâ Anutugât Heakŋe Dawidi den magaŋdo den dâm kulemgoep are bunŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Akto Yudasiŋe Yesu bâleŋe agaŋbiap aregât puli waŋbiâ mem hamewakmâ palep. Hain akto kautŋande purik dâmbo tepŋe okotŋe hârogâk hindakmâ hânân giep. ");
INSERT INTO tim_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hain akto Yerusalem kepia ambolupŋande puli are mem yâkgât pat are nâŋgâm metem âmâ hân aregât kotŋe Akedama dâm koli. Kot aregât purikŋe amâ, “Hepŋaet hân” are puligoyi. ");
INSERT INTO tim_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Akto Anutugât kepŋe siâ hin yendâp, “Luâk iregât emet hewukŋe akbiap. Akto luâk siâŋe togom yâkgât dumŋân âi membiap.” akto Anutugât kepŋe siâ hin, “Luâk siâŋe yâkgât dumŋân miawakmâ welamŋân kinmâ yâkgât âi damunŋe akbiap.” ");
INSERT INTO tim_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aregât Yesu hutnenŋân olowâk malion nengâlân gâtŋe siâ mem miawakberen. ");
INSERT INTO tim_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Akto ulik gulik Yohaneŋe âi keiŋe katmâ tu puli yeŋgiep are egion. Sop ainba Yesuŋe maknengim manmâ himbimân âgâep are egion. Nengât hut nenŋânba luâk siâ mem miawakberen.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petoroŋe hain dâm makyeŋgimbo luâk lâuwâ mem miawakyelegi. Luâk siâ kotŋe Matia, akto siâ kotŋe Yosepe. Yosepegât kotŋe irakŋe Yusito akto kotŋe siâ Basaba dâm koli. ");
INSERT INTO tim_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hain mem miawakyelekmâ hin dâm Anutu magaŋi, “O Kembu nenŋe, gâ luâk hârok yâk yeŋgât biwiyeŋe ekmâ nen hârok keinenŋe nâŋgâmat aregât luâk lâuwâ yu kindat ire siâ me siâ gugak mem miawakmâ maknengimenâ ekberen. ");
INSERT INTO tim_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yudasiŋe Yesugât Aposolo malep ina âi are hepunmâ âmâ manman bâleŋân ariep aregât yâkgât welamŋân kinmâ âgâwiap yâkgât kotŋe maknengimenâ nâŋgâne.” dâm ulilaŋi. ");
INSERT INTO tim_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hain ulilaŋbiâ kulem esenŋe mem kotyetŋe lâuwâ lâuwâ kulemgoep. Kulem esenŋe lâuwâ kulemgom umbâ kâlegen kato giep. Gembo mem oloŋdo Matiagât kotŋe kulemgoep are miawagep. Mem miawakto benŋe Aposolo keiân konok yâk yeŋgâlân dewatimbo keiân lâuwâ agi. ");
INSERT INTO tim_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hilâm kotŋe Pendekosi hombaŋ dâm koli sop are ewumâk akto luâk âmbâle biwiyeŋe Yesugâlân kali yâk hârogâk emet siân âgâm menduguakmâ tali. ");
INSERT INTO tim_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tatbiâ himbimânba mun humo siâ seru munŋe panmap mun hainâk dowâk sân sânâk giep. Gembo emelan tali luâk âmbâle are hârogâk nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Akto yâk yeŋgâlân wan siâ kâlâp ululunŋe hain arekŋe miawakmâ hogoakmâ kautyeŋân ârândâŋ giep. ");
INSERT INTO tim_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hain akto Anutugât Heakŋande humo akmâ tânyeŋgumbo denyeŋe siâ siâ magi. ");
INSERT INTO tim_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hain agi sop ain Yuda luâk Anutugât den lokom bikenba bikenba mendugum mali are togom Yerusalem kepian âgâm mali. ");
INSERT INTO tim_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ain manbiâ siâkâ denyeŋân denyeŋân makmâ manbiâ nâŋgâyi. Are nâŋgâm togom mendugum sân sân mem bâtyeŋe dâtyeŋân igim kili. Hain akbiâ luâk âmbâle Yesugâlân biwiyeŋe kali arekŋe siâkâ denyeŋân denyeŋân makmâ mali. ");
INSERT INTO tim_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Akto are nâŋgâm aregât biwiyeŋe agato bâtyeŋe dâtyeŋân igim hin dâyi, “Luâk den aktâi ire Galilaia hânân manmai ");
INSERT INTO tim_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","arekŋe gain gain akmâ nengât den hain are makbiâ nâŋgâen? ");
INSERT INTO tim_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nen togom yu mendugum kinden ire nengât keinenŋe hin. Nen Pata hânân gâtŋe, Mede hânân gâtŋe, Elam hânân gâtŋe, Mesopotamia hânân gâtŋe, Yudaia hânân gâtŋe, Kapadokia hânân gâtŋe, Ponto hânân gâtŋe, Asia hânân gâtŋe, ");
INSERT INTO tim_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigia hânân gâtŋe, Pampilia hânân gâtŋe, Aigita hânân gâtŋe, Afrika hânân gâtŋe, Kirene hânân gâtŋe, akto Roma kepian gâtŋe. Nen kepia ya yeŋgonden ain gâtŋe. ");
INSERT INTO tim_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Akto bikŋe Kreta ain gâtŋe akto Arabia hânân gâtŋe. Akto nen kepia ya yeŋgonden are bikŋe kâlewângen akto bikŋe ewumâk nen ain gâtŋe. Nen âmâ bikŋe Anutugât den nanaŋ nenŋânbak nâŋgâyion akto bikŋe Yuda yeŋgâlân dewatiyion hain arekŋe manden. Akto Anutuŋe kulem siâ siâ âlepŋe akmap aregât nengât dennenŋân dennenŋân dâm maktâi are nâŋgâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hain dâm nâŋgâmbiâ dâtŋe akto kautyeŋe gulip akto hin magaŋgi goaŋgi agi, “Iregât keiŋe gain gain?” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Hain dâmbiâ bikŋande Aposolo yekbiâ yânŋe akto giriŋyeŋgim hin dâyi, “Luâk ire waiŋ tu are nembiâ biwiyeŋe gulip akto hain aktâi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hain dâmbiâ Petoroŋe Aposololupŋe keiân konok are hutyeŋânba kinmâ den humo hin dâm makyeŋgiep, “Galalupne, akto Yerusalem kepian togom mandâi ye kulem iregât keiŋe makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yu nenektâi nen âmâ waiŋ tu are bo nenden akto biwi bo gulip akten. Hinŋe âmâ hândâktâgâk waiŋ tu are bo nenden. ");
INSERT INTO tim_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nen yu aktenŋe nenektâi ire propete kotŋe Yoeleŋe kulem ire miawakbiapgât den ire kulemgoep are kârikŋe aktâp. ");
INSERT INTO tim_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Anutuŋe hin dâep, “Hâmbâi humogât sop are tâlâgumbo âmâ nâŋe nunaet Heakne are huŋgun aŋdere gem luâk hârok ârândâŋ akyeŋgiwiap. Huŋgun aŋdere gembo âmâ luâk âmbâle biwiyeŋe nâŋgâlân katmâ manbai arekŋe nâŋgât den dâm makyeŋgiwai. Akto luâk wan siganlupyeŋe yeŋgât biwiyeŋe purik âgâmbo giwelân siâ me siâ ekbai. Akto luâk âmbâle sâmbâŋe asiŋ yem âmâ giwet ekmâ nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Akto sop ain nâŋgât Heakŋande nâŋgât hoŋ akto âi âmbâle ârândâŋ meme akyeŋgimbo nâŋgât den dâm magaŋgiwai. ");
INSERT INTO tim_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Akto Kembu togowiap aregât hamep hâwâliŋe humo sopŋe tâlâguwiap ain maktere âuren himbimânba kulem siâ siâ miawakbiap. Dewutâ golaŋe hândâk akbiap. Akto hândâkgât dewutâ arekŋe gilâm miawakbiap. Akto hânân hin miawakbiap. Kâlâp dâwokŋande gilâm akmâ emet me hân hârok tigim om derewiap. ");
INSERT INTO tim_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sop ain luâk bikŋe Kotdâgât kotŋe konmai are âmâ Anutuŋe bo hilip yeŋguwiap.” ");
INSERT INTO tim_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israe luâk, den siâ makyeŋgire nâŋgâŋet. Anutuŋe Yesu Nasarete kepian gâtŋe are ekto ârândâŋ agepgât humo agaŋdo hut yeŋân manmâ kulem keiŋe keiŋe mendo ekmâ nâŋgâyi. Yesugât keiŋe hain agâkgât Anutuŋe makmâ hâriep. ");
INSERT INTO tim_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hain dâm hârembo wan me wan are agaŋi. Agaŋmâ luâk Anutu kotŋe bo konmai are yeŋgimbiâ mem hâk hilâlâm waŋmâ lâwinân kombiâ moep. ");
INSERT INTO tim_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hâk hilâlâm nâŋgâm mondo sumân kali. Dâ sumânâk tatbiapgât dopŋe bo agep aregât Anutuŋe nâŋgaŋdo golâ akmâ sumânba agalep. ");
INSERT INTO tim_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Akto aregât keiŋe Dawidiŋe kulemgoep are kârikŋe aktâp amâ hin, “Nâŋe kotdâ bâtne bungen tatmap yâk dewunnande ekmâ tatmâ mandân aregât bo hepun nekmap. Wan me wan nâŋgâre umatŋe akbopgât yâkŋe tân nugumap. Tân nugumbo kârikŋe akman. ");
INSERT INTO tim_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Aregât biwine âlepŋe akto gâŋgât heroŋe aktân. Akto kep keŋgu mendân. Akto siân agatbiangât biwine owâiâp. ");
INSERT INTO tim_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Dâ mombian âmâ momoŋe yeŋgât manmanân tatbomgât bo hepun nekbiat. Akto nâmâ gâŋgât akmâ huragumangât aregât hâkne hagitne sumân tatmâ hambuwomgât menekmenâ agatbian aregât momogât bo hamep akman. ");
INSERT INTO tim_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gârâmâ gâŋe manmangât dâp katniŋen. Akto gâ olop manmâ kambiamne âlepŋe akto manmâ âgâman.” Den are Dawidiŋe kulemgoep. ");
INSERT INTO tim_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Galalupne hakunenŋe kotŋe Dawidi miawagep yâkgât keiŋe makyeŋgire nâŋgâŋet. Yâk mondo hangoyi yâkgât sumŋe are ekmaen. Are ekmâ hin nâŋgâmaen. Dawidi hambuep dâmaen aregât Dawidiŋe ikiŋaet bo magep. Dawidi âmâ Propete luâk siâ mando Anutuŋe den kârikŋe magaŋep aregât ");
INSERT INTO tim_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","yâkŋe âmâ hin dâep, “Anutuŋe hakulupne yâk yeŋgâlân gâtŋe siâ mem kato luâk kotdâ akmâ manmâ nâŋgât dumnân kinbiapgât makmâ hâreniŋep.” ");
INSERT INTO tim_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Are nâŋgâm kinmâ Anutuŋe huŋgunaŋdo gewiap are momoŋânba agatbiap aregât hin dâm magep, “Nâ mondereân otnene sumânâk tato hâkne higenŋe akbopgât dâm menekto agatbian.” dâep. Dawidi hain magep. ");
INSERT INTO tim_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Haingât Anutuŋe Yesu are mem agatmâ kindo Aposolo nenŋe egion. ");
INSERT INTO tim_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Anutuŋe Yesu mem agato ikiŋe bâtŋe bungen âgâ kindo eweŋande ikiŋe Heakŋe katmâ yâkgât nâŋgâm den kârikŋe magep are miep. Hain akmâ benŋe huŋgun aŋdo gem tân nengumap aregât kulemŋe yu ektâi. ");
INSERT INTO tim_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawidi âmâ ikiŋe himbimân bo âgâep aregât hin dâep, Anutu kotdâŋe nâŋgât kotdâ hin dâm magaŋep, “Gâ togo bâtne bungen tatmenâ ");
INSERT INTO tim_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","gasalupge mem ge katyektere tâliyekbiat.” ");
INSERT INTO tim_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Israe luâk âmbâle hârokŋe hain nâŋgâmbiâ biwiyeŋe kau akbiap. Yeŋe Yesu moâk dâm lâwinân kombiâ moep are Anutuŋe nanŋe are mem agatmâ, “Kotdâ yeŋe ak.” dâm damun nenŋe kalep.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Petoroŋe den hain dâm makyeŋgimbo den arekŋe biwiyeŋân ewumbo Aposolo bikŋe hin aiyeŋguyi, “Galalupnenŋe wan aktenŋe ârândâŋ agâkgât maknengiŋet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hain dâmbiâ Petoroŋe hin dâep, “Ye hanyeŋe purikatmâ biwiyeŋe Yesugâlân katbiâ tu puliyektenŋe bâleŋeyeŋe bo akbiap. Bo akto Anutuŋe wâtgât memeŋe yeŋgimbo manbai. ");
INSERT INTO tim_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Akto Anutu Humonenŋe arekŋe ye akto nanlupyeŋe akto hânŋe hânŋe manmâ ariâi are oloŋyekbiap areyeŋgât den makmâ kalep.” ");
INSERT INTO tim_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petoroŋe hain makyeŋgim benŋe dewatim hin makyeŋgiep, “Luâk yu mandâi imâ pâit pâitŋe aregât yeŋgât hâu âmâ Anutuŋe makto bâleŋân manbai. Ye hain akyeŋgiwopgât hepunyekmâ biwiyeŋe Yesugâlân katbiâ Anutuŋe meyekbiap.” ");
INSERT INTO tim_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Hain dâmbo sop ain luâk âmbâle 3,000 yâkŋe Petorogât den are nâŋgâmbiâ humo akto are tu puli yeŋgimbiâ Yesugât kâmot are yeŋgâlân dewatiyi. ");
INSERT INTO tim_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hain akbiâ aregât Aposoloŋe Yesugât keiŋe makyeŋgim potatmâ yeŋgimbiâ nâŋgâm kârikŋe akmâ mali. Hain akmâ biwi konok manmâ Anutugât kotŋe konmâ sot mendugum katmâ Yesugât pat nelâm nengiwop dâm nem heroŋe akmini. Heroŋe akmâ Anutu ulilaŋmini. ");
INSERT INTO tim_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hain akbiâ Aposoloŋe kulem keiŋe keiŋe kenuŋmâ mali are luâk âmbâle hârokŋe ekmâ hamep akmâ sân sân meyi. ");
INSERT INTO tim_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Akto biwiyeŋe Yesugâlân kaliŋe biwi konok akmâ manmâ yeŋaet puli me wan me wan hârok mem mendugum kâmot konogân katmâ mali. ");
INSERT INTO tim_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Akto bikŋande wan me wan hârogâk are bo gangerâmbiâ siâŋe puligombiâ puli are potatmâ galalupyeŋe yân manmâ puligât umburuk agi are bikŋe potatmâ yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hilâm ain sumbe emetŋân âgâm biwi konogâk akmâ mendugum den magaŋgi goaŋgi akmâ mali. Akto sot bikŋe emetyeŋân âgâm âmâ menduguakmâ nem mali. Akto ain kambiamyeŋe heroŋe akto Anutu âlepŋe dâm kotŋe konmâ mali. ");
INSERT INTO tim_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hain akbiâ luâk hârokŋe yekmâ heroŋe agi. Akto Humoŋe hilâmŋe hilâmŋe luâk âmbâle bikŋe memeŋe akyeŋgimbo biwiyeŋe Yesugâlân katmâ manmâ Yesugât kâmolân dewatiyi. ");
INSERT INTO tim_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Hilâm siân eŋgaiŋe akto Anutugât kotŋe konminigât sopŋe ain Petoro akto Yohaneŋe sumbe emetŋân âgâwerâm agiat. ");
INSERT INTO tim_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hain akbela âmâ luâk siâ memeŋaet tepŋânbak keiŋe bâleŋe miawagep luâk are galalupŋande sumbe emetŋaet hâŋgi siâ kotŋe âlep âlepŋe dâmini ain katbiâ talep. Katbiâ tatmâ hilâmŋe hilâmŋe luâk sumbe emetŋân âgâm gemini are puli siâ siâ ekmâ egâliaŋmâ aregât ulityeŋgim tatminep. ");
INSERT INTO tim_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hain akmâ mando Petoro akto Yohane yâkŋe sumbe emetŋân are âgâmbela yelekmâ âmâ wan me wan siâ niŋlet dâm aregât ulityetkiep. ");
INSERT INTO tim_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ulityetkimbo ekmâ âmâ Petoroŋe hin dâep, “Gâ net nelek.” dâmbo ");
INSERT INTO tim_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","luâk keiŋe bâliep arekŋe puli siâ siâ niŋberâm aktat dâm biwiŋe heroŋe akto enem dewunyetŋân yelegep. ");
INSERT INTO tim_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yelekto Petoroŋe hin dâm magaŋep, “Sikum siâ siâ me puli me ito are bo tatniŋdâp gârâmâ konok tatniŋmap are giŋberângât maktere nâŋgâ. Yesu Anutuŋe huŋgun aŋdo giep Nasarete kepian gâtŋe, yâkgât kârikŋân makgiŋbe. Agatmâ bam ari.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hain dâm bâtŋe bungen mem agalep. Mem agato ainâk keiŋe âlepŋe akto bin bin kinmâ agatmâ sopanmâ agatmâ sopanmâ agep. Hain akmâ Anutu nâŋgaŋep. ");
INSERT INTO tim_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hain akmâ agatmâ kindo yâk olowâk sumbe emetŋân âgâyi. Âgâm luâk arekŋe heroŋe akmâ agatmâ sopanmâ agatmâ sopanmâ bam gutmâ Anutugât kotŋe mem agalep. ");
INSERT INTO tim_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hain akto luâk âmbâle hârokŋe yâk bam gutmâ Anutu mepaiŋe miep are egi. ");
INSERT INTO tim_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ekmâ hin dâyi, “Sumbe emetŋân luâk keiŋe bâle bâleŋe tatmap ina bin bin kindâp. Luâk are ulikŋân bo arim togominep. Sumbe emetŋaet hâŋgiân kotŋe âlep âlep dâmini ain tatmâ puli me sikumgât ulitnengim tato ekminion are ina hinŋe âlepŋe akmâ bin bin kindâp.” dâm nâŋgâmbiâ bimbiâk agep. Bimbiâk akto gain gain aktâp dâm âmâ nâŋgâm bâtyeŋe dâtyeŋân igiyi. ");
INSERT INTO tim_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Akto luâk arekŋe Petoro akto Yohane yetgâlân dewatim meyelekto hetakŋe siâ kotŋe Salomo ain kinbiâ hârogâk ekmâ biwiyeŋe agato aregât magaŋgi goaŋgi akmâ kili. ");
INSERT INTO tim_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hain akbiâ Petoroŋe yekmâ hin dâm makyeŋgiep, “Israe luâk, ye wangât luâk ire ekmâ bâtyeŋe dâtyeŋân igim kindâi? Yu miawaktâp ire netŋaet kârikŋân bo mem âlepŋe ketuguet. Akto netŋaet nâŋgâ nâŋgân bo. Bo kârikŋe aregât wangât net tâŋâk nelektâi? ");
INSERT INTO tim_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Keiŋe hin tatâp. Abraham, Isaka, Yakobo yâk yeŋgât Anutu akto nengât hakulupnenŋe yeŋgât Anutu, yâkŋe hoŋ bawaŋe Yesu ekmâ yâkgât kotŋe mem agatŋet dâm yâkgât kulem are luâk iregâlân mem miawakto kindo ektâi. Yeŋe Yesu are hâkâŋe akmâ Anutugât kotŋe bo konmai yeŋgâlân kali. Katbiâ Pilatoŋe, “Yesu huŋgun aŋdere yânŋângen geâk.” dâmbo âmâ yeŋe kârikŋe akmâ, “Borâen. Luâk aregât hâkâŋ akten.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Akto Yesuŋe bâleŋe siâ bo akminep are ina hâkâŋe akmâ kuk agaŋi. Akto luâk koko kotŋe Baraba yâkgât ukenŋe nâŋgâmbiâ Pilatoŋe wato hâkŋângen gembo yâkgât dumŋân Yesu are koyi. ");
INSERT INTO tim_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hain akmâ luâk âmbâle yeŋe manman kârikŋe aregât amboŋe ina koyi. Kombiâ mondo hangombiâ âmâ Anutuŋe momoŋânba mem agato kinmâ mando egion. ");
INSERT INTO tim_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Luâk irekŋe âlepŋe aktâp aregât keiŋe makyeŋgire nâŋgâŋet. Yesu yâkgât kolân dâetŋe Yesuŋe meme agaŋdo biwiŋe yâkgâlân hikom âlepŋe aktâp. Âlepŋe akto ektâi. ");
INSERT INTO tim_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Akto galalupne nâ hin nâŋgân. Ye akto humomolupyeŋande Yesugât keiŋe pâpkom aregât hain agaŋi. ");
INSERT INTO tim_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Akto emelâk Anutuŋe Yesugât den hin dâm Propetelupŋe yeŋgât biwiyeŋân kato kulemgoyi are kârikŋe agep. Den are âmâ hin. Anutuŋe huŋgunaŋdo gewiap arekŋe hâk hilâlâm nâŋgâm mombiap. ");
INSERT INTO tim_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hain akto benŋe Anutuŋe dosayeŋe puli yeŋgimbo bo agâkgât biwiyeŋe hulaŋ akmâ Anutugâlângen arimbo agak memeyeŋe bâleŋe are hepunmâ manbai. ");
INSERT INTO tim_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hain akbiâ Kembu Yesu yâk olowâk manmâ Anutugât kârikŋân kinbiâ âmâ Humoŋe memeŋe akyeŋgimbo biwiyeŋân ârândâŋ akbiap. Akto hâmbâi Yesuŋe damunyeŋe akbiap aregât huŋgun aŋdo gewiap. ");
INSERT INTO tim_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Uŋak âmâ Kembu Yesu yâk himbimân mandâp. Anutuŋe propetelupŋe den biwiyeŋân kato kulemgoyi are bunŋe agâk dâm wan me wan are heŋgemgom mem hulaŋ nenekbiap. Aregât sop tâlâguwiap ain Yesu purik katmâ lâuwâŋe gewiap. ");
INSERT INTO tim_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Aregât Moseŋe Israegât kâmot den hin dâm makyeŋgiep, “Kembu Anutuŋe galalupyeŋe yeŋgât hutyeŋân propete luâk siâ nâ hinare mem miawakto arekŋe den makyeŋgimbo are bo hepunmâ âmâ nâŋgâmâk manbi. ");
INSERT INTO tim_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Gârâmâ siâŋe yâkgât denŋe are hâkâŋ akbiap are âmâ yeŋe mem siângen katmâ watbiâ hâkŋângen gem manbiap.” ");
INSERT INTO tim_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Are Mose ikiŋak akbiapgât bo magep. Propete luâk hârok Samue malep sop ainba kulemgom gayi benŋe hinŋe âkâ den areâk makmâ kulemgoyi. ");
INSERT INTO tim_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Akto Anutuŋe propete mali yâk yeŋgât makmâ katyeŋgiep. Are nengât pat agep. Akto Anutu yâk olop den akbiâ biwiyeŋe kepik agep. Aregât bunŋe hainâk nengât agep. Haingât Anutuŋe Abraham hin magaŋep, “Siân gâŋgât kâmot sambelem ariwai areyeŋgâlân gâtŋe konok arekŋe luâk âmbâle hân biken biken manbai are hârok tân yeŋgumbo heroŋe akbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Den aregât bunŋe miawak nengimbo Anutuŋe Yesu Anutu ikiŋe hoŋ bawa manmâ bâleŋaet dâp are hepunŋetgât huŋgunaŋdo Israe luâk âmbâle nen soŋ mem oloŋnenekberâm giep.” dâep. Petoroŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petoro akto Yohane yâkŋe den hain dâm makyeŋgim kinbela sumbe kat kat luâk akto tembe loko yeŋgât humomolupyeŋe akto luâk kâmot siâ kotyeŋe Sadukaio arekŋe yâk yetgâlân togoyi. ");
INSERT INTO tim_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Togombiâ den makyeŋgim kinmâ Yesu are momoŋânba agalep hainâk nenâkâ agatbaen dâm aregât den âlepŋe makyeŋgimbela are nâŋgâm hin dâyi, “Are bo agakŋe” dâm nâŋgâmbiâ bâlimbo ");
INSERT INTO tim_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","aregât emet eŋgaiŋe agepgât hole aknerâm meyelekmâ arim kala busi kâlegen katyelekbiâ yeyiat. ");
INSERT INTO tim_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Akto Petoroŋe den potatmâ yeŋgimbo nâŋgâyi are yeŋgâlân gâtŋe oyaŋyeŋe 5,000 arekŋe nâŋgâm agatmâ Kembugât kâmot yâk yeŋgâlân dewatim mali. ");
INSERT INTO tim_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Emet hauŋdo Israe yeŋgât humomolupyeŋe akto sumbe emetŋaet damun akto Mosegât den kârikŋe makmâ kepigi yâkŋe Yerusalem kepian âgâm ");
INSERT INTO tim_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","sumbe kat kat yeŋgât luâk kautŋe kotŋe Anasi akto laumatŋe kotŋe Kaipa akto galalogâtŋe Yohane siâ akto Alesande akto kâmotlupyeŋe olowâk den emetŋân âgâm menduguyi. ");
INSERT INTO tim_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mendugum tatmâ Aposolo lâuwâ are yetgât dâmbiâ meyelekmâ gambiâ den âiân katyelegi. Hain akmâ aiyetkum hin dâyi, “Niŋande kârikŋe yetkimbo uran kulem are membela egion? Akto niŋaet kotŋe konmâ kinmâ hain agiat?” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hain dâmbiâ Anutugât Heakŋande Petoro kârikŋe waŋdo kinmâ hin dâm makyeŋgiep, “Israe, nengât humomolupnenŋe hin dâre nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Netŋe luâk keiŋe bâliep are magaŋdetŋe âlepŋe agep aregât yeŋe hin dâm ainetkuâi, “Niŋande kârikŋe yetkimbo mem kinmâ luâk are heŋgemgoyiat.” dâi, ");
INSERT INTO tim_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","aregât keiŋe hin dâm makyeŋgire yeŋe nâŋgâm Israe luâk hârok ari makyeŋgiwi. Akto aregât keiŋe hin. Anutuŋe huŋgun aŋep Nasarete kepian gâtŋe kotŋe Yesu are lâwinân kombiâ moep. Mondo Anutuŋe momoŋânba mem agalep are golâk mandâp yâkgât kârikŋân kinmâ dâetŋe luâk keiŋe bâliep arekŋe âlepŋe agep are dewunnenŋân yu kindâp ire. ");
INSERT INTO tim_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Akto Dawidiŋe Yesugât nâŋgâm den siâ hin dâm kulemgoep are kârikŋe agep, “Emet kenuŋmai arekŋe kun kun ire bâleŋe dâm hepuli arekŋe agatmâ kun kun kârikŋe akmâ kindâp.” dop hainâk yeŋe âmâ emet kenuŋmai hainâk akmâ Yesu ina bâleŋe dâm hepuli. ");
INSERT INTO tim_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ire nâŋgâŋet. Luâk siâŋe kârikŋe nengimbo himbimân âgâwaengât dopŋe bo tatâp. Bo kârikŋe. Anutuŋe Yesu nengât dâm huŋgunaŋdo giep yâkŋe ikiŋe wâtŋe nengimbo bâli bâligât pat boân manmaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hain dâmbo ain kili arekŋe Petoro akto Yohane yâk luâk yânŋe nâŋgâ nâŋgâgât emetŋân bo maliat aregât bo hamep akmâ den kârikŋe magiat are nâŋgâmbiâ dâtŋe akto hin dâyi, “O luâk ire âmâ Yesu olop mali.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Akto luâk âlepŋe agep are yâk yetgât hutyetŋân kindo ekmâ hin dâyi, “Den hâuŋe gain gain makne?” dâm yân kili. ");
INSERT INTO tim_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hain akmâ aregât huŋgun yetkimbiâ emet kâlegenba betgen ge kinbela yâk yetgât hin dâm magaŋgi goaŋgi agi, ");
INSERT INTO tim_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nen luâk lâuwâ ire gain gain akyetkine? Yâkŋe makbela kulem humo miawakto luâk ire âlepŋe agep. Akto aregât den pat Yerusalem kepia ambolupŋande emelâk nâŋgâm meteâi aregât gain gain akne? Denŋe bo agâkgât dop bo tatnengiâp? ");
INSERT INTO tim_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Akto den arekŋe sambelembo kepiaŋe kepiaŋe nâŋgâm metewâigât Yesugât kotŋe lâuwâŋe bo konbiandatgât kârikŋe makyetkiweren.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hain dâm kinmâ gaet dâm yetkonbiâ âgâmbela hin dâm makyetkiyi, “Yetŋe Yesugât kotŋe bo konmâ yâkgât keiŋe lâuwâŋe bo makyeŋgiwiandat.” ");
INSERT INTO tim_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hain dâmbiâ Petoro akto Yohane yâkŋe hin dâm makyeŋgiyiat, “Yeŋeak nâŋgâŋet. Netŋe Anutugât den are hepunmâ yeŋgât den lokom kindetŋe Anutuŋe nâŋgâmbo bo ârândâŋ akbiap. Aregât yeŋgât den bo lokoweret. ");
INSERT INTO tim_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Net Yesuŋe âi mem hekat netkimbo ekmâ nâŋgâyiot are yeŋe makmâ hâre netkiwaigât dop bo tatâp.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hain dâmbela yâkŋe wârakmâ den kârikŋe lâuwâŋe makyetkim benŋe yeŋaet hin dâm magaŋgiyi, “Luâk âmbâle kâmot humo arekŋe ");
INSERT INTO tim_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","luâk âlepŋe agep are kopa akmâ manmâ gambo hombaŋ 40 agep aregât nâŋgâmbiâ humo agep aregât nenŋe gain gain akmâ hâre yetkiweren?” dâm nâŋgâmbiâ umatŋe akto hepuli. ");
INSERT INTO tim_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petoro akto Yohane yâkŋe arewa gam galalupyetŋe yeŋgâlân arim sumbe kat kat luâk yeŋgât humomolupyeŋe akto Israe yeŋgât humomolupyeŋe yâkŋe den makyetkiyi aregât den pat are hârok makyeŋgiyiat. ");
INSERT INTO tim_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Makyeŋgimbela nâŋgâm biwiyeŋe heroŋe akto nâŋgâ nâŋgâ mendugum Anutugât kotŋe mem agatmâ hin dâyi, “Kembu Humo, himbim hân haru akto hângât wan me wan keiŋe keiŋe kalen aregât amboŋe gâ. ");
INSERT INTO tim_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gâŋgât Heakgande hakunenŋe Dawidi gâŋgât den lokom malep yâkgât biwiŋân kato Dawidiŋe Anutugât hin dâep, “Anutugâlân biwiyeŋe bo katmaiŋe Anutu ewangim kinmâ yâk mem ge katbaigât dop bo tatâp aregât wangât gasa agaŋdâi? ");
INSERT INTO tim_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Akto hânân luâk kembu akto humomolupyeŋe yâkŋe menduguakmâ hin dâmai, “Anutu kembu yâkŋe damunyeŋe ak dâm huŋgunaŋdo giep are gasa agaŋmâ siângen katne.” hain dâmai.” ");
INSERT INTO tim_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dawidiŋe den hain dâep aregât bunŋe miawakto Herote akto Pilato kotŋe siâ Ponto yâkŋe galalupŋe akto Israe luâk bikŋe yâk olop kepia ain mendugum magaŋgi goaŋgi agi aregât âmâ damun nenŋe akberâm aregât nange hoŋ bawage âlepŋe are huŋgunaŋmenâ giep yâkgât hâkâŋ akmâ wan me wan bâleŋe agaŋberâm menduguyi. ");
INSERT INTO tim_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Are âmâ yeŋe hanyeŋaet bo agi. Gâŋe emelâk nâŋgâm kalen are miawakbiap dâmenâ miawagep. ");
INSERT INTO tim_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kepia iregât ambolupŋande den kârikŋe maknengimbiâ hamep akbâengât den are nâŋgâm nen hoŋ bawalupge kârikŋe aknengimenâ denge makberâm hamep bo akbaen. ");
INSERT INTO tim_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Akto nange Yesu hoŋ bawage âlepŋe yâkgât wâtŋân kinmâ luâk kundatdâ âlepŋe akbiâ kulem keiŋe keiŋe miawagâkgât tân nenguwen.” ");
INSERT INTO tim_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hain dâm ulilaŋbiâ emet mendugum tali are duwuŋ agep. Hain akto Anutugât Heakŋe arekŋe kârikŋe akyeŋgimbo hamep hepunmâ arim Anutugât den are owâiŋeâk makyeŋgim mali. ");
INSERT INTO tim_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Hain akmâ sop ain sikum me puli me wan me wan tatyeŋgiep aregât, “Ire nâŋgât are gâŋgât.” hain bo dâm konogâk mendugum katbiâ tânyeŋguep. Biwiyeŋe Yesugâlân katmini arekŋe biwiyeŋe konogâk akto nâŋgâ nâŋgâyeŋe konok akto agak memeyeŋe konogâk akmini. ");
INSERT INTO tim_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Akto Aposolo yâkŋe Yesu Humo momoŋânba agalep aregât den pat âlepŋe are makyeŋgimbiâ kârikŋe akto hamep bâlâk makyeŋgim mali. Hain akmâ manbiâ Anutuŋe damunyeŋe akto luâk âmbâle hârokŋe heroŋe akyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Akto hutyeŋân siâŋe umburuk me mop bo mali. Akto hân me kalamân gâtŋe me emet me kotŋe siâ siâ are luâk bikŋe togombiâ are yeŋgiyi. Yeŋgimbiâ aregât hâuŋe puliyeŋgimbiâ puli are kâmot humo yâk yeŋgât pat Aposolo yeŋgâlân katbiâ talep. ");
INSERT INTO tim_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Akto luâk bikŋe puli me kotŋe siâ siâ umburuk manbiâ arewa mem potatmâ yâk yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Hain akmâ manbiâ hutyeŋân luâk siâ kotŋe Yosepe are malep. Akto Aposoloŋe yâkgât kotŋe irakŋe Banaba dâm koli. Kot aregât purikŋe amâ hin, “Luâk siâ wan me wanŋe hâkŋân âgâmbo dowâk tângomap.” Akto yâk âmâ Lewigât kâmolân gâtŋe kepia siâ haru tânâmŋân talep kotŋe Kipiro ain gâtŋe. ");
INSERT INTO tim_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Akto luâk arekŋe ikiŋe hân are luâk siâ waŋdo puligombo puli are mem aposolo yeŋgâlân togom ârândâŋâk katmâ metiep. ");
INSERT INTO tim_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Akto luâk siâ malep kotŋe Anania akto âmbenŋe kotŋe Sapira yâkŋe magaŋgi goaŋgi akmâ hânyetŋe are puligât yeŋgimbela hângât puli me sikum dondâ yetkimbiâ kalakbela tatyetkiep. ");
INSERT INTO tim_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Akto bikŋe âmâ mem netŋe dâtâŋe dâm katbela tato luâkŋande bikŋeâk mem arim Aposolo yeŋgâlân katmâ, “Hârok mem togoân.” dâm heyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hain dâmbo Petoroŋe hin magaŋep, “Anania gain gain akmâ Niambiŋe biwige mem gulip ketugumbo Anutugât Heakŋe hiaŋmâ hângaet puliŋe are bikŋe mem heambuktât? ");
INSERT INTO tim_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Akto hânyetŋe bo yeŋgiyiat sop ain âmâ yetŋaet tatyetkiep. Gârâmâ yeŋgimbela puli yetkimbiâ puli are hanyetŋaet ukenŋe waliat amâ ârândâŋâk yiep. Akto puli ire netŋeâk hârok dâm togombela umatŋe aktâp. Aregât gâŋe luâk henengiât are bâliâp amâ Anutu hiaŋdât amâ dondâ bâliâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Hain dâmbo Ananiaŋe den are nâŋgâm ainâk kuŋ kâruŋ ge yiep. Ge mom yendo luâk sigan ain mali arekŋe sâŋgumŋe katipkom lokom arim hangoyi. Akto Anania moep aregât den pat nâŋgâyi arekŋe hamep agi. ");
INSERT INTO tim_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Akto sop ainâk âmbenŋande luâkŋaet pat bo nâŋgâm pâlâmŋe togoep. ");
INSERT INTO tim_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Togombo Petoroŋe hin dâm aikoep, “Hânyetŋaet puliŋe luâkge hârogâk mem togoâp me?” dâmbo hin dâep, “Âo, are hârogâk mem togoâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Hain dâmbo Petoroŋe hin aikoep, “Wangât yet biwi konok akmâ Humogât Heakŋe are hiaŋiat aregât luâkge mondo lokom arim hangoâigât togom betgen ya kindâi. Arekŋeak gâ betgen kat gekberâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hain dâmbo ainâk keiŋe pindiŋ âgâmbo ge mom yiep. Akto luâk siganŋe luâkŋe lokom arim hangoyi arekŋe emet kâlegen âgâm momoŋe are lokom arim luâkŋaet sum ginŋânâk hangoyi. ");
INSERT INTO tim_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Akto luâk bikŋe Yesugâlân dewatiyi arekŋe patyetŋe are nâŋgâm hamep humo agi. ");
INSERT INTO tim_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Akto sop ain Aposoloŋe luâk âmbâle hutyeŋân manmâ kulem keiŋe keiŋe membiâ egi. Akto Yesugât kâmot yâkŋe sumbe emetŋaet sombeim humo siâ kotŋe Salomo ain âgâm biwi konok akmâ hilâmŋe hilâmŋe mendugum Anutu maŋganmâ den agi. ");
INSERT INTO tim_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Menduguakbiâ luâk bikŋande nâŋgâm aregât hamep akmâ are yeŋgâlân bo togoyi. ");
INSERT INTO tim_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dâ luâk âmbâle bikŋande biwiyeŋe Yesugâlân katmâ Yesugât kâmolân dewatiyi. ");
INSERT INTO tim_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Akto Aposoloŋe kulem keiŋe keiŋe akbiâ aregât galalupyeŋe kundatdâ are tem dâgâm katmâ lokoakmâ arim dâwân katyegi. Katyekmâ hin dâyi, “Petoroŋe togombo âmâ otneŋande galalupnenŋe yendâi ire loŋgaiyekto âlepŋe akberâi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hain dâm Yerusalem kepia ewumâk ewumâk ainba galalupyeŋe kundat agi me sinduk baniara bâleŋande meme akyeŋgimini are kewuguyekmâ Aposolo yeŋgâlân togombiâ kundatdâ akto sinduk baniara bâleŋande meme akyeŋgimini are watyekbiâ âlepŋe agi. ");
INSERT INTO tim_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Akto Aposoloŋe kulem keiŋe keiŋe meyi are nâŋgâm Anutugât sumbe kat kat luâk areyeŋgât humoyeŋe akto galalupŋe Sadukaio kâmolân gâtŋe arekŋe nâŋgâm Aposolo yeŋgât kot agato nengât kotnenŋe gewop dâm aregât biwiyeŋe bâlimbo humoyeŋande kinmâ hin dâep, ");
INSERT INTO tim_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","“Aposolo are meyekmâ kala busi kâlegen katyekŋet.” dâmbo mem kala busi kâlegen katyegi. ");
INSERT INTO tim_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Katyekbiâ hândâk akto âmâ yembiâ hândâgân Humogât aŋelo siâŋe hâŋgi hindâm kâlegen âgâm kewugu yekmâ ge betgen katyekmâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ye sumbe emetŋân âgâm luâk hârokŋe manman âlepŋe aregât den pat makyeŋgim kinbi.” ");
INSERT INTO tim_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hain dâmbo emet hauŋdo sumbe emetŋân âgâm Yesugât den makyeŋgim kili. Akto Anutugât sumbe kat kat areyeŋgât humo arekŋe galalupŋe oloŋyekto den emetŋân âgâyi. Âgâmbiâ tembe loko hin makyeŋgiep, “Kala busi kâlegen uran katyegi are oloŋ yekbiâ gaŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Hain dâmbo sopanmâ gem kala busi kâlegen âgâm undâgât yeŋgimbiâ bo akto purik katmâ gam hin dâyi, ");
INSERT INTO tim_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nen arim kala busi emetŋe kâlegen are âgâm ektenŋe hâŋgi tigiyi are hainâk hârok kârikŋeâk kindâp akto hâŋgi ârândâŋ tembe lokoŋe ariwâirâm kinbiâ yekten. Akto Aposolo meyekberâm arim hâŋgi hindâm âgâm undâgât yeŋgienŋe bo aktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Den hain dâmbiâ Anutugât sumbe kat kat areyeŋgât humomolupyeŋe akto tembe loko yeŋgât kautŋe arekŋe nâŋgâm hin dâyi, “Are bo agakŋe, aregât wan miawakberâp.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hain dâmbiâ ainâk luâk siâŋe togom hin makyeŋgiep “Nâŋgâi. Luâk kala busi kâlegen katyegi ina arim sumbe emetŋân âgâm den makyeŋgim kindâi.” ");
INSERT INTO tim_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","dâmbo sumbe emetŋaet tembe loko arekŋe arim luâk âmbâle kâmot humo arekŋe nenguwâirâm aregât hamep akmâ yeukŋân Aposolo are hin me hain bo akyeŋgim yeukŋân meyekmâ purik katmâ den emetŋân âgâyi. ");
INSERT INTO tim_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Âgâm dewunyeŋân katyekbiâ kinbiâ âmâ sumbe kat kat luâk are yeŋgât den emetŋaet humo arekŋe hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Uran Yesugât keiŋe bo makyeŋgiwi dâm den kârikŋe makyeŋgiyion ina yeŋe yâkgât den are makyeŋgimbiâ Yerusalem kepian mandâi hârokŋe nâŋgâyi. Akto yeŋe nengât Yesu kombiâ moep aregât dosa nengâlân katnengiwerâm aktâi.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hain dâmbiâ Petoro akto Aposolo bikŋe yâkŋe den kakŋân hin makyeŋgiyi, “Nenŋe luâkgât den lokom âmâ Anutugât den hâkâŋ akmâ manbaengât amâ bo ârândâŋ akbiap. ");
INSERT INTO tim_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yeŋe dâmbiâ Yesu lâwinân kombiâ mondo hangombiâ hakulupnenŋaet damunyeŋe Anutu arekŋe momoŋânba mem agato mandâp. ");
INSERT INTO tim_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Akto yâkŋe Israe luâk nenŋe biwinenŋe yâkgâlân katenŋe dosanenŋe hepun nengiwiapgât Anutuŋe mem agato himbimân âgâm Anutugât bâtŋe bungen mandâp. ");
INSERT INTO tim_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Akto luâk âmbâleŋe biwiyeŋe Yesugâlân katmâ Anutugât den lokomai yâk yeŋgât dâm Anutuŋe Heakŋe are huŋgunaŋdo nengâlân dewatim Yesugât keiŋe maknengim tân nengumbo olowâk manmâ Yesuŋe wan me wan akmâ miep are ekmâ nâŋgâyion aregât keiŋe makyeŋgim manden.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hain dâm makyeŋgimbiâ nâŋgâm biwiyeŋe bâlimbo Aposolo are yeŋguwerâm agi. ");
INSERT INTO tim_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yeŋguwerân akbiâ Parisaio yeŋgâlân gâtŋe luâk siâ luâk âmbâle hârokŋe ekmâ luâk âlepŋe dâmini are kotŋe Gamalie yâkŋe hutyeŋânba agatmâ kilep. Agatmâ kinmâ, “Aposolo are yogan betgen ge kinŋet.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Hain dâmbo meyekmâ betgen gembiâ galalupŋe are hin makyeŋgiep, “Israe gâtŋe, ye luâk ire gain gain yeŋgiwerâi? Ye siâ me siâ akyeŋgiwerâm âmâ nâŋgâm heŋgemgom kinmâ akyeŋgimbiâ ârândâŋ akbiâp. ");
INSERT INTO tim_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ulikŋân luâk siâ kotŋe Teuda yâkŋe, “Nâŋe luâk kembu aktân.” dâmbo luâk 400 akmâ yâkgâlân dewatiyi. Hain akbiâ tembe lokoŋe humo akbop dâm kombiâ mondo galalupŋe are awam akmâ ariyi. Akto yâkgât âi are yân gem bo agep. ");
INSERT INTO tim_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Akto aregât hamiŋân kiapŋe luâk âmbâle oyaŋyeŋe nâŋgâwerâm oyaŋ yekto sop ain luâk siâ Galilaia hânân gâtŋe kotŋe Yudasi yâkŋe ikiŋe kotŋe mem agato luâk bikŋande yâkgâlân dewatiyi. Akto areâkâ hainâk kombiâ mondo luâklupŋe are hârok yeŋgum watyekbiâ hanâk hanâk awam akmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Aregât den hin makyeŋgire nâŋgâŋet. Yeŋe aposolo are hepunyekbiâ arim manŋet. Manmâ yeŋeak nâŋgâm âmâ siâ me siâ akbiâ âmâ bo akbiâp. ");
INSERT INTO tim_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dâ Anutuŋe tânyeŋgumbo âi are memai akto âmâ yeŋe gain gain akmâ hilip yeŋguwai? Dâ hilip yeŋguwai âmâ Anutu gasa agaŋbai.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hain dâm makyeŋgimbo nâŋgâmbiâ ârândâŋ akto Aposolo gaŋet dâmbiâ meyekmâ hutyeŋân âgâmbiâ tâk dâtâ dâtâŋe oreyegi. Oreyekmâ pat âlepŋe are bo makyeŋgiwi dâm makmâ hâreyeŋgim watyegi. ");
INSERT INTO tim_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Watyekbiâ arim Yesugât pat âlepŋe are makyeŋgimbiâ aregât hâuŋe tâk dâtâ dâtâŋe arekŋe oreyegi aregât Anutuŋe ekto ârândâŋ akto nâŋgâm biwiyeŋe âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hain akto hilâmŋe hilâmŋe sumbe emetŋân akto luâk âmbâle yeŋgât emelan âgâm Anutuŋe Yesu huŋgun aŋdo giep aregât pat âlepŋe den makyeŋgim mali. ");
INSERT INTO tim_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sop aregât kakŋân luâk âmbâle dondâŋe biwiyeŋe Yesugâlân katmâ yâkgât kâmolân dewatimbiâ dondâ agi. Dondâ akmâ yâk yeŋgât sikum siâ siâyeŋe mem konogân katbiâ tatyeŋgiep ainba mem potatmâ yeŋgim mali. Hain akmâ manbiâ Girik den nâŋgâmai areyeŋgât hutyeŋân umatŋe siâ miawagep. Amâ hin. Puli damunŋande Yuda yâk yeŋgât kambut yeŋgim âmâ Girik yâk yeŋgât bo yeŋgimbiâ Girik luâkŋe ekbiâ ârândâŋ bo akto nâŋgâm bâliaŋi. ");
INSERT INTO tim_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hain dâmbiâ aregât Aposolo keiân lâuwâ arekŋe Yesugât kâmolân dewatiyi are hârok mem menduguyekmâ hin makyeŋgiyi, “Nenŋe sot me kotŋe siâ siâ ire mem potatmâ yeŋgim manmâ aregât Anutugât den ire hepundenŋe ârândâŋ bo akbiap. ");
INSERT INTO tim_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aregât Anutugât Heakŋande tân yeŋgumbo kâmot arewa luâk bât biken lâuwâ nâŋgâ nâŋgâyeŋe olop are mem katyekbiâ nenŋe âi yeŋgienŋe sot me kotŋe siâ siâ are yâkŋe potatmâ yeŋgiwai. ");
INSERT INTO tim_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yâkŋe hain akbiâ benŋe nenŋeak âmâ Yesugât keiŋe makyeŋgim Anutu olop magaŋgi goaŋgi akmâ manbaen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Den hain dâmbiâ dondâ kili arekŋe nâŋgâmbiâ ârândâŋ agep. Akto luâk mem miawakyegi are yeŋgât kotyeŋe hin. Stepano, yâk biwiŋe hanŋe hârok Yesugâlân katmâ malep. Hain akmâ mando Anutugât Heakŋande tângombo malep. Akto Pilipo, Porokoro, Nikano, Timoŋ, Pamena, akto Nikolao. Nikolao âmâ Antiokia kepian gâtŋe ulikŋân Yuda luâk yeŋgâlân dewatim Anutu nâŋgâ aŋmâ malep. ");
INSERT INTO tim_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Luâk are mem miawakyekbiâ Aposolo olop mendugum tatbiâ kautyeŋân mem âmâ Anutu magaŋmâ mem kârikŋe ketuguyegi. ");
INSERT INTO tim_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Akto Yerusalem kepian Anutugât den pat are makyeŋgim arimbiâ luâk âmbâle dondâŋe sambelem biwiyeŋe Yesugât katmâ yâk yeŋgâlân dewatim ariyi. Akto sumbe kat kat luâk yeŋgât humomo mali are yeŋgâlân gâtŋe dondâŋe denyeŋe are nâŋgâm hainâk biwiyeŋe Yesugât kali. ");
INSERT INTO tim_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stepanoŋe luâk âmbâle gala akyeŋgim mando Anutuŋe ekto ârândâŋ akto tângombo kulem keiŋe keiŋe ketugumbo egi. ");
INSERT INTO tim_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Akto ainâk Yuda gâtŋe bikŋande Stepanogât den mem ge katberâm Stepano olop den magaŋgi goaŋgi agi. Are âmâ nâŋgâmbiâ âgâep yâk yeŋgât den emetŋân mendugum mali yâk yeŋgâlân biken biken gâtŋe amâ hin, bikŋe Kirene hânân gâtŋe akto bikŋe Alesandria kepian gâtŋe arekŋe mendugum tali, aregât bikŋande kot konmâ hin dâmini, “Wan siâŋe bo dâgâ nenekmap.” dâmini. Luâk hainare akto Yuda luâk Kilikia kepian gâtŋe bikŋe akto bikŋe Asia hânân gâtŋe arekŋe mendugum kinmâ Stepanogât den mem ge katberâm âi humo meyi. ");
INSERT INTO tim_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Hain akmâ magaŋgi goaŋgi akmâ tatbiâ Anutugât Heakŋande Stepano tângoep aregât gain gain akmâ den hâuŋe magaŋne dâm umaleyi. ");
INSERT INTO tim_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hain akmâ âmâ den halowân luâk bikŋe makyeŋgimbiâ luâk arekŋe miawakmâ kinmâ hiaŋgim hin dâyi, “Stepanoŋe Mosegât den kârikŋe akto Anutugât kot pat are makmâ hilipkombo nâŋgâyion.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hain dâm hanân gege akbiâ Israe yeŋgât humomolupyeŋe akto Mosegât den kârikŋe kepikmâ makyeŋgiyi are akto kepia ambolupŋe yeŋgât humomolupyeŋe yeŋgât hanyeŋân gembiâ biwiyeŋe kâlâp akto kuk agi. Hain akmâ gam Stepano are mem den emetŋân âgâm luâk dondâ kili areyeŋgât hutyeŋân katbiâ kilep. ");
INSERT INTO tim_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ain katbiâ kindo ulikŋân galalupyeŋe hanyeŋân gege agi are yeŋgonbiâ Stepanogât hiaŋgim hin dâyi, “Luâk irekŋe nengât sumbe emetŋe aregât bâleŋe dâm Mosegât den kârikŋe are hepunmâ manmap. ");
INSERT INTO tim_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Akto hin dâmbo nâŋgâyion, “Yesu Nasarete kepian gâtŋe arekŋe nengât sumbe emetŋe are mem patakom Moseŋe den kârikŋe makmâ nengiep are akto agak memenenŋe are mem bâliwiap.” dâmbo nâŋgâyion.” dâm hiaŋgim hain dâyi. ");
INSERT INTO tim_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Den hiaŋgim hain dâmbiâ luâk âmbâle ain mendugum kili arekŋe Stepanogât enem dewunŋân ekbiâ aŋelo yeŋgât pagaleŋe hainare agep. ");
INSERT INTO tim_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Akto Anutugât sumbe kat kat luâk areyeŋgât humoyeŋe arekŋe Stepano hin aikoep, “Den maktâi are bundâk me hiaŋgiâi?” dâmbo ");
INSERT INTO tim_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stepanoŋe agatmâ kinmâ hin dâep, “Humomolupne akto galalupne makyeŋgire nâŋgâŋet. Hakunenŋe kotŋe Abrahamŋe Haraŋ kepian bo arim âmâ Mesopotamia hânân mando Anutu pagaleŋe olop manmapŋe miawagaŋmâ hin dâm magaŋep, ");
INSERT INTO tim_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Gâŋe hânge tâmbâŋe akto ginbailupge me galalupge hepunyekmâ nâŋe hân siâ hekat giŋbian ainâk arim manben.” ");
INSERT INTO tim_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hain dâmbo den are nâŋgâm Kairaia hânŋe are hepunmâ Haraŋ kepian arim malep. Ain mando eweŋe mondo âmâ Anutuŋe hin magaŋep, “Hân ire hepunmâ siân arim manbiat.” dâmbo hân nenŋe yu taten iren togo malep. ");
INSERT INTO tim_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Iren togo malep amâ Anutuŋe sop ain bo waŋdo âmâ bunewâk bo miep. Yogan mendo Anutuŋe siân Abrahamgât kâmot in manbai dâm makmâ hâriep. Amâ Abraham gupin mandoân Anutuŋe hain magaŋep. ");
INSERT INTO tim_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Akto Anutuŋe den siâ hin magaŋep, “Kâmotlupge hân siângen arim ain manmâ hoŋ bawa akmâ yân manbiâ hân aregât ambolupŋande umatŋe keiŋe keiŋe akyeŋgim manbiâ hombaŋ 400 hain bo akbiap. ");
INSERT INTO tim_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Hoŋ bawa akyeŋgim manbiâ hâk hilâlâm yeŋgiwai aregât dosa yeŋgire hân ambolupŋande bâgilupge watyekbiâ âmâ hân in togom manmâ nâŋgât den lokom kotne mem agatmâ manbai.” Anutuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Anutuŋe Abraham ikiŋaet kâmotlupŋe hâkyeŋe gâi gâi akmâ mem manbaigât magaŋep. Akto manmâ âgâm âgâm Abraham nanŋe Isaka miawakto hilâm bât biken âlâwu bo akto eweŋande hâkŋe gâiaŋep. Akto Isaka manmâ humo akmâ nanŋe kotŋe Yakobo miep. Akto hamiŋân Yakoboŋe hakulupnenŋe keiân lâuwâ meyegep. ");
INSERT INTO tim_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Akto teulupŋande Yosepe yâkgât hâkâŋ akmâ mem siâ siâ mâŋgim puligât yeŋgimbiâ puli yeŋgim emiyeŋe are mem Aigita hânângen ariyi. Akto Aigita hânân mando Anutuŋe ain tângom heŋgemgoep. ");
INSERT INTO tim_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tângombo wan me wan umatŋe miawagaŋdo âmâ Anutuŋe tângombo Yosepeŋe heroŋe kakŋân malep. Hain mando Anutuŋe kârikŋe waŋdo nâŋgâ nâŋgâŋe humo akto aregât Aigita yeŋgât luâk humo kotŋe Parao yâkŋe ekmâ luâk âlepŋe dâm âi waŋep. Âi waŋmâ ikiŋe emetŋe me Aigita hân ambolupŋe are damunyeŋe agâkgât magep. Hain dâm âi waŋmâ hutyeŋân kato damunyeŋe akmâ malep. ");
INSERT INTO tim_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mando Aigita akto Kanaŋ hân ain mop humo miawakto sot bo agep. Hain akto sot bo akto momberâm agi. ");
INSERT INTO tim_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hain akmâ manbiâ Aigita hânân sot yendâp dâmbiâ Yakoboŋe nâŋgâm nanlupŋe huŋgunyeŋgimbo aregen ariyi. ");
INSERT INTO tim_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Arim puligom togom nem manbiâ bo akto benŋe lâuwâŋe huŋgunyeŋgimbo arimbiâ Yosepeŋe teulupŋe yekmâ ikiŋaet pat makmâ miawakyeŋgiep. Makyeŋgimbo Paraogâlân arimbiâ keiyeŋe hârok nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Akto Yosepeŋe den kato arimbo eweŋe Yakoboŋe ginbailupŋe luâk âmbâle 75 meyekto Aigita hânân ariyi. ");
INSERT INTO tim_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Arimbiâ âmâ manmâ manmâ Yakobo moep. Mondo ainba nanlupŋe âkâ hainâk manmâ mom meteyi. ");
INSERT INTO tim_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hain akbiâ hanyeŋgumbiâ hakulupyeŋande hagityeŋe are mem hakuyeŋe Abrahamŋe Sikem kepian gâtŋe luâk siâ kotŋe Hemo yâkgât nanlupŋe yeŋgâlân hân puligoep ain hagityeŋe are mem arim hanyeŋguyi. ");
INSERT INTO tim_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Akto bâgilupnenŋe Aigita hânân sambelem manmâ dondâ akmâ mali. Hain akmâ manbiâ Anutuŋe Abraham den magaŋep are kârikŋe agâkgât sop are tâlâguep. ");
INSERT INTO tim_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Akto Aigita yeŋgât luâk humo siâ miawagep arekŋe Yosepegât pat bo nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Akto luâk humo arekŋe bâgilupnenŋe mem ge katyekberâm aregât hâk hilâlâm yeŋgiep. Hâk hilâlâm yeŋgim hin dâep, “Sambelewâi dâm nanlupyeŋe miawakbiâ mem ge hâkŋângen panyekŋet.” dâmbo mem yeŋgumbiâ moyi. ");
INSERT INTO tim_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sop ain âmbâle siâŋe nanaŋ kotŋe Mose are miep. Mezdo Anutuhe Mose ekmâ nanaŋ âlepŋe dâep. Mose hain miawakto eweŋande emetŋân yoŋâk mem tato dewutâ âlâwu bo akto mem ge hâkŋângen kato yiep. ");
INSERT INTO tim_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Akto Parao baratŋande nanaŋ are ekmâ mem nâŋgât nanne dâm damunŋe akmâ malep. ");
INSERT INTO tim_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mando getek kaulem Paraogât luâklupŋe nâŋgâ nâŋgâyeŋe olop are yeŋgât hutyeŋân kulem emetŋân âgâmbo nâŋgâ nâŋgâ potatmâ waŋbiâ nâŋgâ nâŋgâŋe humo akto agak memeŋe me den makmakŋe me nâŋgâ nâŋgâŋe humo agep. ");
INSERT INTO tim_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Hain akmâ manmâ hombaŋŋe 40 bo akto âmâ hin nâŋgâep, “Galalupne Israe luâk are gain gain akmâ mandâi aregât arim yekbe.” dâep. Hain nâŋgâm kambiamŋe owâiŋe akto ariep. ");
INSERT INTO tim_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Arimbo Aigita gâtŋe luâk siâŋe Israe luâk siâ kondo ekmâ galaŋe are tângom Aigita luâk are kondo moep. ");
INSERT INTO tim_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kondo mondo hin nâŋgâep, “Galalupnande iregât pat nâŋgâm Anutuŋe tânnugumbo hâmbâi gasalupnenŋe hilip yeŋguwiangât nâŋgâwai.” dâm nâŋgâep. Dâ galalupŋande âmâ hain bo nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Luâk are kondo mondo emet hauŋdo lâuwâŋe arimbo Israe luâk lâuwâ akmâ agum tatbela mem potatyelekmâ hin makyetkiep, “Yet âmâ gala konokŋe wangât akmâ gasa kalaktat?” ");
INSERT INTO tim_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Hain dâmbo bugâ keiŋe katmâ galaŋe koep arekŋe Mose hâkokom âmâ hin magaŋep, “Gâ netgât kiap me? Niŋande damunnenŋe akben dâm kat gegep? ");
INSERT INTO tim_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Uran Aigita luâk siâ koen hainâk nâ nuguwerâm aktât me?” ");
INSERT INTO tim_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Hain dâmbo Moseŋe den are nâŋgâm hamep akmâ heambukmâ Midiaŋ hânângen arim lombo tatmâ malep. Manmâ âmbâle mendo nanaŋ luâk lâuwâ meyelegep. ");
INSERT INTO tim_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Manmâ gambo hombaŋ 40 siâkâ bo akto arewa hân are hepunmâ hân tuŋe boângen Sinai gimbâŋe aregât keiŋân arimbo Anutugât aŋelo siâŋe lâwin keiŋe siân kâlâp ululunŋe om kilep ain miawakmâ kindo egep. ");
INSERT INTO tim_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ekmâ Moseŋe sân sân mem âmâ ekmâ heŋgemgowerâm ginŋân âgâ kindo Humoŋe den hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nâ hakulupge Abraham akto Isaka akto Yakobo yâk yeŋgât Anutu.” dâep. Hain dâmbo Moseŋe den are nâŋgâm sân sân mem ongâŋe hogombo hamep akmâ ekbom dâm dewunŋe hânângen panmâ kâŋgom kilep. ");
INSERT INTO tim_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Hain akmâ kindo Humoŋe hin dâm magaŋep, “Nâŋe yu kindân iregât hân tâliât ire amâ kâmbokŋe. Gârâmâ gâŋe kei pekege are oloŋmâ pan. ");
INSERT INTO tim_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Akto ire nâŋgâ. Kâmotlupge Aigita hânân manbiâ kepia ambolupŋande bugâ yeŋgum mem siâ siâ akyeŋgim hâk hilâlâm yeŋgim manmâ gambiâ yekman. Yekmâ indem tâgâiakyeŋe nâŋgâm bâin dâm geân gârâmâ gasalupyeŋe hilip yeŋguwian. Akto gasalupyeŋe yeŋguwian aregât gâ Aigita hânângen huŋgun giŋdere ariwiat.” Anutuŋe hain magaŋmâ huŋgunaŋdo ariep. ");
INSERT INTO tim_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Arim mando Israe luâk arekŋe Mosegât hâkâŋ akmâ hin magaŋi, “Niŋande gâ kiap dâm kârikŋe giŋep.” dâyi. Dâ Anutuŋe âmâ Moseŋe Israe luâk damunyeŋe akmâ gasalupyeŋe watyegâk dâm aregât aŋelo huŋgun aŋdo kâlâp ululunŋe kâlegen ge kinmâ âi are waŋep. ");
INSERT INTO tim_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Akto Anutuŋe Mose huŋgun aŋdo Aigita hânângen arim kulem keiŋe keiŋe ketugumbo egi. Akto arewa togom haru gilâm ain hâtikom arewa hân kamitŋângen togom kulem keiŋe keiŋe kenuŋmâ gam manmâ kewuguyekto hombaŋ 40 agep. ");
INSERT INTO tim_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Akto Moseŋe Israe luâk hin makyeŋgiep, “Yeŋgât hutyeŋânba Anutuŋe propete luâk siâ nâ hinare mem miawakbiap.” ");
INSERT INTO tim_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moseŋe hain dâm bâgilupŋe olop hân kamitŋângen tatmâ Sinai gimbâŋân âgâm aŋelo arekŋe Anutugât manmangât den magaŋdo gem makyeŋgiep. Amâ yâk yeŋgâlâk bo. Gam gam yu manden nen maknengiwiapgât makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Moseŋe bâgilupnenŋe makyeŋgimbo denŋe are hâkâŋ akmâ Mosegât den are hâkokom Aigita hânângen purik katberâm aregât ukenŋe humo agi. ");
INSERT INTO tim_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hain akmâ Aroŋ hin magaŋi, “Gâ lâpio ketugum katmenâ arekŋe ulikŋân akmâ kewugu nenekto ariwaen. Moseŋe Aigita hânângenba kewugu nenekmâ togoep ina yâk gulip agep me gain gain agep nen bo nâŋgâen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hain dâmbiâ bulimakao otneŋe siâ mâŋgim kato tato wan me wan otneŋe aregât nâŋgâmbiâ humo akminep aregât sumbe omberâm heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hain akbiâ aregât Anutuŋe hepun yekto biwiyeŋe gulip akto dewutâ akto diâ are ekmâ hin dâyi, “Dewutâ diâ ire âmâ nengât Humonenŋe.” dâm ulityeŋgiyi. Hain akbai aregât Anutuŋe dâmbo propeteŋe kulemgoyi aregât bikŋe hin tatâp, Anutuŋe hin dâep, Israe ambolupŋe ye hân kamitŋângen manmâ soŋgo bau gâim nâŋgât bo, siâgât sumbe higenŋe om manbiâ hombaŋ 40 agep. ");
INSERT INTO tim_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Akto diâ aregât nâŋgâm ulikŋân lâpiologâtyeŋe kotyetŋe Molok akto Rapaŋ are yetgât emet kenuŋmâ katyelekmâ ain âgâm kot yetŋe mem agali. Hain akmâ aregât dosa akbiâ nâŋgâm hân kotŋe Babiloŋ ain katyekbian. ");
INSERT INTO tim_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Akto bâgilupnenŋande Aigita hân are hepunmâ hân kamitŋângen arim manbiâ Anutu yâkgât sumbe emetŋe mâronŋe ketuguyi are tatmâ ariep aregât keiŋe Mose magaŋep. Hain dâm magaŋdo ainâk mâron are mem gagaim lâuwâŋe kenuŋmâ kenuŋmâ âgâyi. ");
INSERT INTO tim_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Akto bâgilupnenŋande sumbe emetŋe mâronŋe ketugum âgâmbiâ Yosuaŋe ulik gulik akmâ kewugu yekto Anutu bo nâŋgâyi are yeŋgât hânân togoyi. Togombiâ Anutuŋe luâk gasalupŋe are yeŋgum watyekto âmâ bâgilupnenŋande hân are mem gangerâm âmâ Anutugât sumbe emetŋe mâronŋe kenuŋbiâ kinmâ âgâep sop ain Dawidi miawagaŋep. ");
INSERT INTO tim_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Miawagaŋdo âlepŋe mando Anutuŋe ekto ârândâŋ akto âmâ Dawidiŋe Anutugât sumbe emetŋe humo kenuŋberâm akmâ aregât Anutu ulilaŋep. ");
INSERT INTO tim_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ulilaŋdo ikiŋe nanŋe siâ kotŋe Salomo yâkŋe Anutugât sumbe emetŋe are kenuŋguep. ");
INSERT INTO tim_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Hain gârâmâ Anutu Humo âlepŋe dondâŋe luâk nenŋe emet me opmân kenuŋmaen ain bo tatmâ manmap. Aregât Anutuŋe dâmbo propete siâŋe hin kulemgoep are tatâp, ");
INSERT INTO tim_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kembuŋe hin maktâp, “Himbim amâ tat tatne dâ hânŋe amâ tâli tâline. Aregât emet gain hinare siâ mâŋginiŋbiâ ârândâŋ akbop? Me welam yeyene âlepŋe yâten tatniŋdo ârândâŋ akbop? ");
INSERT INTO tim_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nâ bâtnande siâ me siâ hârok are bo mem mâŋgiân mon?” Anutuŋe hain magaŋdo propete siâŋe kulemgoep are tatâp. ");
INSERT INTO tim_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ye hanyeŋe kârikŋe bâleŋe. Biwi nâŋgâ nâŋgâyeŋe bo kepigagep. Bâgilupnenŋande Anutugât Heakŋe are hâkâŋ akmâ mem hami pali. Hainâk akmâ yekâ are yeŋgât agak meme are bo hepunmai. ");
INSERT INTO tim_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bâgilupnenŋande propete luâk hârogâk bâleŋe akyeŋgim hâk hilâlâm yeŋgiyi. Akto Anutugât hoŋ bawaŋe miawakmâ luâk ârândâŋ akyeŋgim togom manbiap aregât propete luâkŋe makmâ kulemgoyi yâk hârogâk yeŋgum meteyi. Akto yâkgâlân Yesu miawagep ain hiaŋgim den bâleŋe makmâ kuk agaŋmâ lâwinân kombiâ moep. ");
INSERT INTO tim_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Akto Anutugât aŋelolupŋande yâkgât den kârikŋe makyeŋgimbiâ kulemgoyi are bo mem mandâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stepanoŋe den hain dâm makyeŋgimbo Yuda luâk humomolupyeŋande biwiyeŋe kâlâp akto kuk humo nâŋgâm nekamyeŋe kândiŋ egep. ");
INSERT INTO tim_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Hain akbiâ Anutugât Heakŋande tângombo himbimân dewunŋe panmâ ekto Yesu Anutugât bâtŋe bungen ain kindo ekmâ Anutugât pagaleŋe ekmâ hin dâep, ");
INSERT INTO tim_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Nâŋgâi. Himbim hâreakto luâk akmâ giep are Anutugât bâtŋe bungen kindo ektân.” ");
INSERT INTO tim_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hain dâmbo den are nâŋgâm bâin dâm hârokŋe watmâ mem kom hâkokom ariyi. ");
INSERT INTO tim_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mem kepia ginŋângen gem kâtŋe koyi. Kâtŋe komberâm akbiâ luâk sigan siâ kotŋe Saulo yâkŋe nâŋgâ yeŋgimbo âlepŋe akto mâronyeŋe kâkâlep are oloŋmâ Saulogât enemŋân katbiâ tato kâtŋe Stepano kombiâ ");
INSERT INTO tim_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yesu magaŋmâ hin dâep, “Kembu Yesu, otnene me.” ");
INSERT INTO tim_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hain dâm pâwutŋe ligim hânân ge tatmâ hin dâep, “Kembu, yu akniŋdâi iregât hâuŋe gâŋe bo yeŋgiwen.” dâep. Hain dâm ainâk moep. ");
INSERT INTO tim_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Akto Anutugât den lokom mali arekŋe Stepanogât hâkŋe mem lokom indem biwi bâle nâŋgâm sumângen lokom arim hangoyi. Akto sop ain Yerusalem kepia ambolupŋe luâk âmbâle biwiyeŋe Yesugâlân katmâ mali are yeŋgât gasalupyeŋande keiŋe katmâ bâleŋe keiŋe keiŋe yeŋgim gasa akyeŋgiyi. Hain akyeŋgimbiâ âmâ Saulo yâkŋe âmâ Yesugât kâmot are hilip yeŋguwerâm undâgât yeŋgim emetŋe emetŋe âgâm mem miawakyekmâ tembe loko makyeŋgimbo mem oloŋyekmâ arim kala busi emet kâlegen katyekbiâ tali. Hain akyeŋgim hâk hilâlâm yeŋgimbiâ aregât luâk âmbâle bikŋe hamep akmâ gem heambukmâ Yudaia akto Samaria hânângen ariyi. Arim manbiâ aposoloŋe konok Yerusalem kepian mali. ");
INSERT INTO tim_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Akto biwiyeŋe Yesugâlân kali arekŋe Yerusalem kepia hepunmâ awam akmâ kepiaŋe kepiaŋe manmâ Yesugât keiŋe makyeŋgim ariyi. ");
INSERT INTO tim_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Hain akbiâ yâk yeŋgâlân gâtŋe luâk siâ kotŋe Pilipo yâkŋe Samaria luâk are yeŋgât kepia humo ain arim Anutuŋe Yesu huŋgun aŋdo giep aregât keiŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Makyeŋgim kulem keiŋe keiŋe kenuŋdo luâk âmbâle dondâ ekmâ denŋe nâŋgâm mali. ");
INSERT INTO tim_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Akto sinduk baniara bâleŋande kautyeŋân meyegi are watyekto kamboŋmâ hepun yekmâ arim meteyi. Hain akbiâ keiyeŋe kârigiep are mem heŋgem yeŋguep. ");
INSERT INTO tim_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Heŋgem yeŋgumbo kepia ambolupŋande Pilipoŋe kulem keiŋe keiŋe miep are ekmâ biwiyeŋe âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Akto kepia ain luâk kâmbokŋe siâ malep kotŋe Simon arekŋe ikiŋe hâkŋe mem agatmâ bâleŋe sait keiŋe keiŋe mendo ekmâ ongâyeŋe hogom nâŋgaŋbiâ humo akto mali. ");
INSERT INTO tim_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Akto luâk âmbâle gegeŋe âgâ âgâŋe hârokŋe yâkgât hin dâm mali, “Nâŋgâ nâŋgâŋe kârikŋe talaŋdâpgât den nâŋgâwerâm kârikŋe aktâp.” dâyi. Hain dâmbiâ sait keiŋe keiŋe mem manmâ gaep aregât bâtyeŋe dâtyeŋân igim kinmâ biwiyeŋe yâkgâlân katmâ mali. Biwiyeŋe yâkgâlân katmâ, “Simon konok yâkŋe Anutugât kârikŋe mem miawakmap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Hain akmâ manbiâ âmâ Pilipoŋe Anutuŋe damunyeŋe akberâm agep aregât akto Yesu huŋgunaŋdo gem malep aregât kot pat âlepŋe dâm makyeŋgimbo are nâŋgâm mem manmâ biwiyeŋe Yesugâlân katmâ manbiâ tu puli yeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hain akbiâ Simon yâkŋe hainâk biwiŋe Yesugâlân katmâ mando tu puli aŋi. Hain akbiâ Simonŋe Pilipo peniaŋdo olowâk maliat. Manmâ Pilipoŋe kulem keiŋe keiŋe ketugumbo Simonŋe sân sân mem ekto dâtŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Akto Samaria kepia ambolupŋande Anutugât den are nâŋgâm lokom mali. Aregât pat are magaŋgi goaŋgi akbiâ Yerusalem kepian arimbo Aposoloŋe nâŋgâyi. Nâŋgâm Petoro akto Yohane huŋgun yetkimbiâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Arimbela yâkŋe keiyeŋe hin makyetkiyi, “Emelâk biwinenŋe Yesugâlân katenŋe Pilipoŋe Yesugât kolân tu puli nengiep.” dâyi. Hain dâmbiâ Petoro akto Yohaneŋe Anutugât Heakŋe yâk yeŋgâlân bo giep aregât nâŋgâm kautyeŋân meyekmâ Anutu ulilaŋiat. Kautyeŋân mem kinmâ ulilaŋbela gem tân yeŋguep. ");
INSERT INTO tim_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Akto Petoro akto Yohaneŋe kautyeŋân meyekbela Anutugât Heakŋande gem kârikŋe akyeŋgimbo Simon are egep. ");
INSERT INTO tim_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ekmâ ukenŋe nâŋgâm aregât puli mem togom hin dâm makyeŋgiep, “Nâŋe kautyeŋân hainâk mendere âmâ Anutugât Heakŋande gem kârikŋe akyeŋgiwiapgât puli ire yetkiwerân. Yetkire mem aregât hâuŋe nâŋgâ nâŋgâ niŋbela yetgât kârikŋe tatyetkimap are mendere kârikŋe niŋâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hain dâmbo Petoroŋe hin magaŋep, “Anutuŋe ikiŋe Heakŋe huŋgun aŋdo gemap are gâŋe puligande puligowerâm aktât are bâliâp akto arekŋe hememgât pat miawakgiŋdâp. ");
INSERT INTO tim_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hain akmenâ bâlimbo Anutuŋe biwige ekto ârândâŋ bo aktâp aregât net bo penânetkiwiat. ");
INSERT INTO tim_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Akto siâ makgiŋdere nâŋgâ. Biwigaet keiŋe hin ekmâ nâŋgân. Netŋe kulem mendetŋe ulitnetkimenâ biwige bâliâp. Akto hainâk biwi bâle manmâ hain aregât ukenŋe nâŋgâm manmenâ biwige hândâk akmapgât Anutuŋe dâmbo akmâ hilipkoât aregât dosa bo akgiŋâkgât nâŋgâ nâŋgâ bâleŋe hepunmâ biwige Yesugâlân katmâ ulilaŋ.” ");
INSERT INTO tim_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hain dâm magaŋdo Simonŋe hin dâm makyetkiep, “Hainare miawak niŋbopgât Anutu ulilaŋlet.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hain dâmbo âmâ Petoro akto Yohaneŋe purik katmâ arim âmâ kepiaŋe kepiaŋe Samaria hânân tatmâ ariep ain arim Yesugât den pat âlepŋe are makyeŋgim ariyiat. Arim manmâ dâp ginŋe tete kepiaŋe kepiaŋe âgâm Yesugât den pat âlepŋe are makyeŋgim makyeŋgim Yerusalem kepian purik katmâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Petoro akto Yohane Yerusalem kepian purik katmâ arim manbela sop ain Anutugât aŋelo siâŋe miawakmâ Pilipo hin dâm magaŋep, “Gâ ire hepunmâ dâp siâ ewangim gem dâp tu tânâk bo gemawân Yerusalemba Gaya arimai dâp are watmâ ariwen.” ");
INSERT INTO tim_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hain dâm magaŋdo Pilipoŋe hân kamitŋângen ariep. Akto Aitiopia hânân âmbâle humo siâ malep kotŋe Kandake yâkgât puliŋaet damun akto âmbâle damun akminep yâkŋe Yerusalem kepian arim sumbe emetŋân âgâm Anutu kotŋe mem agalep. Mem agato bo akto hân tâmbâŋângen ");
INSERT INTO tim_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","purik katmâ ariwerâm akmâ âmâ ikiŋe bau luâk soko arekŋe hân waŋgaŋe siâ oloŋep ain âgâm tatmâ kepia aregen purik katmâ ariep. Dâwân arim emelâk Anutuŋe den dâmbo propete luâk siâ kotŋe Yesaia yâkŋe kulemgoep are oyaŋep. Oyaŋmâ arimbo Pilipoŋe egep. ");
INSERT INTO tim_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ekto âmâ Anutugât Heakŋande Pilipo hin magaŋep, “Woe, gâŋe hân waŋgaŋe indâgenba togoâp ain arimenâ penigiŋâk.” ");
INSERT INTO tim_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hain dâmbo Pilipoŋe dowâk arimbo luâk arekŋe emelâk Yesaiaŋe Anutugât den are kulemgoep are oyaŋdo nâŋgâm hin dâm aikoep, “Den ya oyaŋdât aregât keiŋe nâŋgât me bo?” dâep. ");
INSERT INTO tim_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Hain dâmbo âmâ bau luâk soko are siâ siâ waŋdo yeukŋe akmâ kindo hin magaŋep, “Luâk siâŋe bo makniŋdâpgât nâ nunak oyaŋmâ keiŋe nâŋgâwerângât dâp bo tatâp, aregât gâŋe hân waŋgan âgâmenâ olowâk tatmâ âmâ keiŋe makniŋ.” ");
INSERT INTO tim_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Hain dâmbo hân waŋgan âgâmbo olowâk tatmâ ariyiat. Akto emelâk Anutuŋe den makto Yesaiaŋe kulemgoep are hin, “Lama are kom gâiwerâmbiâ yân tatmap. Akto lama dumutŋe hârembiâ âmâ pâlâmŋe kinmap dop hainâk nâŋgât hoŋ bawa pâlâmŋe yekmâ kindo den âiân katmâ ikiŋaet pat âlepŋe makyeŋgiwopgât dâp gisapkom kombiâ moep. Akto kombiâ mondo ainba kâmotlupŋe biwiyeŋe yâkgâlân katmâ manbai yâk yeŋgât oyaŋ yekbaigât dâp bo tatâp.” ");
INSERT INTO tim_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Akto luâk kotdâŋe den are oyaŋmâ aregât Pilipo hin aikoep, “Propete luâk arekŋe ikiŋaet me siâgât kulemgoep?” dâep. ");
INSERT INTO tim_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hain dâmbo Pilipoŋe Yesaiaŋe den kulemgoep are oyaŋmâ arewa Yesugât den pat âlepŋe are magaŋdo tatmâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Arim tu siâ hâlâŋmâ arimbela luâk kotdâ arekŋe hin dâm magaŋep, “Indâre ek. Tu tatâp. Nâ tu puli niŋberâtgât nâŋgân aregât gain aktere ârândâŋ akberâp?” dâep. ");
INSERT INTO tim_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Hain dâmbo hin dâm magaŋep, “Gâŋe biwige Yesugâlân katmenâ âmâ âlepŋe mem tu puli giŋberân.” dâm magaŋdo hin dâep, “Yesu are âmâ Anutugât nanŋe aregât biwine yâkgât emelâk katân.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hain dâmbo âlepŋe dâmbo aregât bau luâk soko are mem yeukŋe ketugumbo kindo Pilipo akto luâk kotdâ arekŋe hân waŋgaŋânba gem tuân geyiat. Gem âmâ Pilipoŋe tu puli aŋep. ");
INSERT INTO tim_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Puli aŋdo tuânba gambela âmâ Anutugât Heakŋande Pilipo mem oloŋdo arimbo luâk kotdâŋe Pilipo undâgâto bo akto biwi heroŋe nâŋgâm hân waŋgan âgâm mem ariep. ");
INSERT INTO tim_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Akto Anutugât Heakŋande Pilipo mem Asido kepian kato kindo egi. Ekbiâ kepiaŋe kepiaŋe arim Yesugât den pat âlepŋe makyeŋgim arim Kaisarea kepian ariep. ");
INSERT INTO tim_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Akto sop ain Sauloŋe Kembugât kâmot gasa akyeŋgim hilip yeŋguwerâm akto biwiŋe kâlâp agep. Biwiŋe kâlâp akto Sauloŋe Anutugât sumbe kat kat areyeŋgât humoyeŋaelân arim kulem esenŋe niŋŋetgât ariep. ");
INSERT INTO tim_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Amâ den emetŋe Damasko ain tatâp aregât humomolupŋe hekatyeŋgim dâp irakŋân manmai luâk me âmbâle mem miawakyekmâ bâtyeŋân hikom Yerusalem kepian meyekmâ togoâkgât kulem esenŋaet ulityeŋgiep. Ulityeŋgimbo waŋbiâ mem ariep. ");
INSERT INTO tim_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Akto kulem esenŋe are mem Yerusalem kepia hepunmâ Damasko kepia ewumâk akto âmâ himbimânba dewutâ pagaleŋe humo gem belek belek akmâ miawagep. Belek belek dâm miawakto hânân ge yiep. ");
INSERT INTO tim_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ge yendo ainâk den siâ hin dâmbo nâŋgâep, “Saulo, Saulo, gâ wangât nugum watnekmâ mandât?” dâep. ");
INSERT INTO tim_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Hain dâmbo Sauloŋe hin dâep, “Kembu gâ niŋe.” dâmbo hin dâep, “Nâ nugum watnekmâ manmat ire. Nâ Yesu. ");
INSERT INTO tim_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Agatmâ gâŋe kepian arimenâ âmâ siâŋe gain gain akbiatgât miawâk makgiŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hain dâmbo olop mali arekŋe den are nâŋgâm kinmâ etem metem agi. ");
INSERT INTO tim_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Hain akmâ kinbiâ Saulo âkâ agatmâ ekberâm akto ainâk dewunŋe hândâk agep. Hain akto aregât galalupŋande mem oloŋmâ Damasko kepian ariyi. ");
INSERT INTO tim_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mem oloŋmâ arim manbiâ dewunŋe hândâk akto sot me tu me wan me wan bo nem mando hilâm âlâwu bo agep. ");
INSERT INTO tim_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Akto Damasko kepia ain gâtŋe luâk siâ Yesu kâmolân gâtŋe kotŋe Anania. Manmâ biwiŋe purik dâmbo giwelân Humoŋe miawagaŋmâ kolep. Kondo hin dâep, “Humone, wan den makniŋberâm aktât?” dâmbo ");
INSERT INTO tim_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Humoŋe hin dâm magaŋep, “Agatmâ ari. Dâp siâ aregât kotŋe dâp tâŋâk dâm konmai ain Yudasi siâgât emet tatâp ain arim âgâm luâk siâ kotŋe Saulo are Taso kepian gâtŋe are mem miawakben. Nâŋgât. Yâkŋe nâ ulitniŋmâk mandâp. ");
INSERT INTO tim_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Uran ulitniŋmâ âmâ giwelân hin egep. Luâk siâŋe kotŋe Anania yâkgâlân arim âmâ dewunŋe hulaŋ akbiapgât kautŋân membiap are egep.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Humoŋe hain dâm magaŋdo Ananiaŋe hin dâep, “Humo, Saulogât hin dâmbiâ nâŋgân. Yâkŋe âmâ Yerusalem kepia ambolupŋe gâŋgât kâmolân mandâi are hilip yeŋgum hâk hilâlâm yeŋgim mandâp. ");
INSERT INTO tim_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Akto yâkŋe kotge konmâ manmaen nen mem oloŋnenekto Yerusalem kepian purik katmâ ariŋetgât Anutugât sumbe kat kat areyeŋgât humomolupyeŋande magaŋgim kinmâ huŋgunaŋbiâ togoâp.” ");
INSERT INTO tim_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananiaŋe hain dâmbo hin dâep, “Gâ hanâk yâkgâlân ari. Luâk âmbâle hârokŋe nâŋgât keiŋe nâŋgâŋetgât Saulo oloŋdere hoŋ akniŋmâ luâk âmbâle bikŋe Anutu bo nâŋgaŋmai are akto luâk humomolupyeŋe akto Yuda luâk bikŋe areyeŋgâlân arim keine makmâ miawakmâ makyeŋgiwiap. ");
INSERT INTO tim_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Makyeŋgimbo bikŋande âmâ nâŋgâmbiâ bâlimbo aregât siâ siâ agaŋbiâ hâk hilâlâm kakŋân manbiap aregât keine magaŋbian. Aregât agatmâ ari.” ");
INSERT INTO tim_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hain dâmbo Ananiaŋe âmâ emet tirip kalaŋep ain arim âgâm Saulogât kautŋân mem hin dâep, “Galane Saulo, makgiŋdere nâŋgâ. Yesu Humoŋe dâwân miawakgiŋdo egen yâkŋe dewunge âlepŋe akberâpgât akto Anutugât Heakŋande kârikŋe akgiŋâkgât huŋgun niŋdo gutân.” ");
INSERT INTO tim_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hain dâm magaŋdo hainâk dewunŋe henepŋe gagai akmâ gembo emelâk hârok ektân dâmbo tu puli aŋep. ");
INSERT INTO tim_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Hain akto sot om waŋbiâ nendo hagitŋe kârikŋe agep. Akto tatmâ Yesugât kâmot Damasko kepian mali yâk olowâk mali. ");
INSERT INTO tim_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Manmâ âmâ ainâk keiŋe katmâ Sauloŋe Yuda yeŋgât den emetŋân âgâm Yesugât keiŋe hin makyeŋgiep, “Yesu are amâ Anutugât nanŋe mandâp.” ");
INSERT INTO tim_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Hain makyeŋgimbo nâŋgâmbiâ dâtŋe akto den hin dâm magaŋgi goaŋgi agi, “Amâ yâkŋe âgâlân Yerusalem kepian manmâ luâk âmbâle Yesu kotŋe konmâ manmai are hilip yeŋguwerâm akmâ hâk hilâlâm yeŋgiep. Akto Yesugât kâmot in mandâi yâk mem oloŋ yekmâ purik katmâ sumbe kat kat luâk arekŋe hilip yeŋguŋet dâm Yerusalem kepianba iren togoep.” Hain dâm magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Akto Sauloŋe ain manmâ nâŋgâ nâŋgâŋe kârikŋe akto Yesu amâ Anutuŋe huŋgunaŋdo giep aregât keiŋe dâm miawakmâ makyeŋgimbo nâŋgâmbiâ han lâuwâ agep. ");
INSERT INTO tim_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yuda gâtŋande Damasko kepian manmini arekŋe nâŋgâm manmâ biwiyeŋe kâlâp akto Saulo komberâm agi. ");
INSERT INTO tim_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Den akmâ Saulo komberâm kepia ginŋânâk kinmâ hin dâyi, “Saulo in gembo âmâ kondenŋe momberâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Hain dâmbiâ Sauloŋe nâŋgâm galalupŋe makyeŋgimbo hândâgânâk haka humo kâlegen lugum tâkŋe hikom giâkom kâtŋe haot humo ketugumini are dâtŋânba panbiâ gem hânân kinmâ haka kâlegenba yoŋâk agatmâ ariep. ");
INSERT INTO tim_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Akto Saulo Damasko kepia hepunmâ Yerusalem kepian ariep. Ain arim Yesugât kâmolân gâtŋe penâyeŋgiwerâm agep. Penâyeŋgiwerâm akto imâ Yesu gâlân gâtŋe bo dâm hamep akmâ gala bo agaŋi. ");
INSERT INTO tim_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Gala bo agaŋbiâ aregât Aposolo siâ kotŋe Banaba yâkŋe Saulogât denŋe makberâm akmâ Aposolo yeŋgâlân oloŋmâ arim hin dâm makyeŋgiep, “Humonenŋande Saulo dâwân mem miawakmâ âmâ den magaŋep. Magaŋdo Damasko kepian arim ain Yesugât kot den hamep bâlâk makyeŋgiep.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabaŋe hain dâm makyeŋgimbo gala agaŋbiâ olop manmâ Yerusalem kepia are gam ândeaŋmâ arim Humogât kotŋe dâm miawakmâ makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hain dâm makyeŋgim Yuda luâk ulikŋân Girik hânân ariyi arekŋe purik katmâ togoyi yâk yeŋgâlân gâtŋe bikŋe makyeŋgimbo denyeŋe gembo âgâmbo akmâ kondenŋe moâk dâm magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Akto Yesugât kâmotlupŋe yâkŋe yâkgât den pat nâŋgâm Saulo mem oloŋmâ Yerusalem kepia are hepunmâ gem Kaisarea kepia arim katbiâ waŋgan âgâmbo mem ikiŋe kepia kotŋe Taso ain are kato ariep. ");
INSERT INTO tim_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Akto Anutugât Heakŋande Yuda ambolupŋe akto Galilaia ambolupŋe akto Samaria ambolupŋe biwiyeŋe Yesugâlân kali are memeŋe akyeŋgimbo aregât luâk dondâ yâk yeŋgâlân mendugum dewatiyekbiâ dondâ agi aregât biwiyeŋe sândugiep. ");
INSERT INTO tim_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petoro hân ain arim togom hâtikom âmâ Yesugât kâmot Lida kepian mali are yeŋgâlân ariep. ");
INSERT INTO tim_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Arim luâk siâ kotŋe Ainea egep. Yâk âmâ kei bâtŋe kârigem yiep. Hain mando hombaŋ nâmbulân âlâwu bo agep. Are Petoroŋe hin dâm magaŋep, ");
INSERT INTO tim_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","“Ainea Yesu Kristo yâkŋe heŋgem guguâpgât agatmâ gugak tem tâkge loko.” dâmbo ainâk agalep. ");
INSERT INTO tim_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Âlepŋe akmâ agato Lida akto Sadoŋ ambolupŋande ekbiâ dâtŋe akto biwiyeŋe Yesugâlân kali. ");
INSERT INTO tim_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Akto Yope kepian âmbâle siâ Yesugât kâmolân dewatiep are kotŋe Tabita den purikŋe amâ hânângen. Yâkŋe luâk âmbâle umburuk mali are gala akyeŋgim tânyeŋguep. Hain akmâ manmâ kundat miawagaŋdo moep. ");
INSERT INTO tim_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mondo lokom âgâm emet kâleŋe siân tu pulim katbiâ yiep. ");
INSERT INTO tim_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yope kepia are akto Lida kepia are olop kereregâk taliatgât Yesugât kâmolân mendugu ageine Petoro togoâp nâŋgâm luâk lâuwâ huŋgun yetkiyi. Huŋgun yetkimbiâ arim hin dâm magaŋiat, “Kewugu gektetŋe olowâk hinŋe arine.” dâmbela âlepŋe dâmbo kewugumbela ariyi. ");
INSERT INTO tim_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Arimbiâ âmbâle momoŋe talewân are kewugumbela âgâyi. Âgâmbiâ âmbâle kambutŋe ândeaŋmâ tatmâ okot nâŋgâ aŋmâ indem tatmâ Tabitaŋe golâ malewân ain sâŋgum parutmâ yeŋgiep are hârok hekalaŋi. ");
INSERT INTO tim_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Hekalaŋbiâ Petoroŋe, “Sopanŋet.” dâmbo hârok sopanmâ ge betgen kinbiâ enemŋân bam kâŋgom Anutu ulilaŋep. Ulilaŋmâ âmbâle momoŋe yiep are ekmâ hin dâm magaŋep, “Tabita agatmâ kin.” dâmbo ainâk dewunŋe hulaŋ akto Petoro egep. ");
INSERT INTO tim_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ekto Petoroŋe bâtŋân mendo agatmâ kilep. Kindo Petoroŋe yeŋgondo âmbâle kambut akto luâk âmbâle bikŋe Yesugât kâmolân dewatiyi are hârok âgâm Tabita momoŋânba mem agalep are egi. ");
INSERT INTO tim_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ekmâ Tabita momoŋânba agalep aregât den pat are magaŋgi goaŋgi akbiâ Yope kepian gâtŋe biwirâŋe Yesugâlân biwiyeŋe kali. ");
INSERT INTO tim_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Akto Yope kepian malep luâk siâ kotŋe Simoŋ yâk makao hâkŋe gagaim kau hekom parutmâ kato puligomini yâkgât emelan ain Petoroŋe sop kâlep tatmâ malep. ");
INSERT INTO tim_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisarea kepian luâk siâ malep kotŋe Konelio Italiagât tembe loko yeŋgât damun kautŋe malep. ");
INSERT INTO tim_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yâk akto kâmotlupŋe arekŋe Anutugât den lokom ulilaŋmâ mali. Hain manbiâ damunyeŋe arekŋe Yuda luâk âmbâle umburuk mali are yeŋgât okotŋe nâŋgâm kotŋe siâ siâ yeŋgim malep. Akto yâkŋe Anutu yâkgât heroŋe nâŋgâm hilâm ârândâŋ mepaiŋe miep. ");
INSERT INTO tim_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Hain akmâ manmâ hilâm siân eŋgaiŋe biwiŋe mem purik kato Anutugât aŋelo siâŋe kolep. ");
INSERT INTO tim_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kondo tâŋâk ekmâ sân sân mem hin dâep, “Kotdâ gain gain?” dâmbo hin dâep, “Gâŋe Anutu magaŋmâ denŋe lokom manmâ luâk umburuk manmai are gala akyeŋgimat are Anutuŋe nâŋgâmbo âlepŋe akmap. ");
INSERT INTO tim_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gârâmâ gâ uŋak hoŋ bawalupge huŋgunyeŋgimenâ Yope kepian arim luâk siâ kotŋe Simoŋ, Petoro are kewugum togowi. ");
INSERT INTO tim_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yâk nambeŋe Simoŋ makao hâkŋe gagaim kau hekom parutmâ kato puligomai aregât emelan tatâp. Akto emet are amâ haru ginŋân tatâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aŋeloŋe hain dâm arimbo Konelioŋe dâmbo hoŋ bawa lâuwâ akto tembe loko yâk yeŋgâlân gâtŋe siâŋe Anutugât denŋe lokominep yâk gambiâ ");
INSERT INTO tim_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","aŋeloŋe den magaŋep are makyeŋgim huŋgun yeŋgimbo Yope kepian ariyi. ");
INSERT INTO tim_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Arim dâwân yem kinbiâ hauŋdo âgâm arimbiâ kepia are tâlâgumbo âmâ dewutâ kârikŋe akto Petoroŋe Anutu den magaŋberâm emet kakŋân âgâep. ");
INSERT INTO tim_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Âgâm Anutu magaŋmâ kinmâ mopŋe agumbo sot nemberâm aregât, “Sot oŋet.” dâmbo sot om tatbiâ ain biwiŋe purik âgâmbo hin egep. ");
INSERT INTO tim_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Himbim hâreakto aŋeloŋe wan siâ mâron humo tuŋguŋe biken biken hikom mem giâkom katbiâ hânân giep. ");
INSERT INTO tim_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Akto aregât kâlegen soŋgo lâut toŋga keiŋe keiŋe Yuda luâkŋe bo nemini arekŋeak ain yiep. ");
INSERT INTO tim_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Are gembo âmâ himbimânba den hin magaŋep, “O Petoro, are gâim om ne.” dâmbo ");
INSERT INTO tim_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petoroŋe hin dâep, “Kotdâ, nâ hain bo akman. Soŋgo kâmbokŋe bo nene dâmaen hinare bo neman.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hain dâmbo lâuwâŋe hainâk dâep, “Are gâim ne, Anutuŋe makto âlepŋe aktâp are bo neneŋe hain bo dâm hepunbiat.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lâuwâŋe âlâwuŋe hainâk dâmbo mem oloŋbiâ himbimân âgâep. ");
INSERT INTO tim_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Himbimân âgâmbo Petoroŋe are ekto biwiŋân kulem mendo nâŋgâmbo ârândâŋ bo akto âmâ Konelioŋe hoŋ bawalupŋe huŋgunyeŋgiep arekŋe togom Simoŋgât emetŋe mem miawakmâ betgen kinmâ den hin dâm koli, ");
INSERT INTO tim_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“Simoŋ kotŋe siâ Petoro gâ ain tatât me?” dâm koli. ");
INSERT INTO tim_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Hain konbiâ Petoroŋe wan siâ egep aregât nâŋgâm heŋgemgom kindo Anutugât Heakŋande hin magaŋep, “Nâŋgât. Luâk âlâwu akmâ yâkŋe undâgât giŋdâi ");
INSERT INTO tim_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","aregât yâk olop gem ariwerâm âmâ nâŋgâmâk bo ak. Luâk are nâŋe makyeŋgire togoâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hain dâmbo Petoroŋe yâk yeŋgâlân gem hin aiyeŋguep, “Kulâgâtâi amâ nâ ire. Wangât togom nogondâi?” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hain makyeŋgimbo hin dâyi, “Tembe loko yeŋgât humoyeŋe kotŋe Konelio yâkŋe Anutugât hamep akmâ gala agaŋmâ yâkgât dewunŋân âlepŋe manmap yâkgât Yuda kepia ambolupŋande nâŋgâmbiâ ârândâŋ akmap. Akto Anutugât aŋelo siâ huŋgunaŋdo Konelio miawagaŋmâ gâŋe arim emetŋân magaŋbiatgât magep.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hain dâmbiâ gala akyeŋgimbo emetŋân âgâm yeyi. Yem kinbiâ hauŋdo agatmâ Yope kepian bikŋe biwiyeŋe Yesugâlân katmâ mali yâk olop ariyi. ");
INSERT INTO tim_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Arim dâwân yeyi. Yem kinbiâ hauŋdo agatmâ Kaisarea kepian ariyi. Arimbiâ Konelioŋe galalupŋe akto ginbailupŋe oloŋyekto mendugum lâmyeŋgum tatbiâ togoyi. ");
INSERT INTO tim_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Togom Petoroŋe emetŋân âgâwerâm akto Konelioŋe kambiamŋe âlepŋe akto gem enemŋân kâŋgom kotŋe mem agalep. ");
INSERT INTO tim_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Hain akto Petoroŋe mem agatmâ hin magaŋep, “Hepun. Nâmâ gâ hinare luâgâk.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Hain dâmbo Konelioŋe kewugu yekmâ emelan âgâmbo Petoroŋe mendugum tali are yekmâ hin makyeŋgiep, ");
INSERT INTO tim_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","“Ye Yuda luâk nengât agak meme nâŋgâmai. Nenŋe Yuda luâk bo are gala akyeŋgim yâk olop tatbaengât dâp bo tatmap. Nâmâ luâk den siân gâtŋe luâk ire âmâ bâleŋerâm nâŋgâre gemap. Hain akmâ gala bo akyeŋgiwerâm aktere Anutuŋe hain bo akben dâm aregât keiŋe makniŋep. ");
INSERT INTO tim_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Aregât kewugu nekberâm togombiâ âmâ den bo koyeŋgiân. Gârâmâ wangât nâ kewugu nekberâm undâgât niŋi aregât keiŋe makniŋbiâ nâŋgâwe.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Hain dâmbo Konelioŋe hin magaŋep. “Nâŋe kulem siâ ekmâ manmâ gare sop uŋak hilâm imbâtŋe bo aktâp aregât den pat makgiŋbe. Nâ emet eŋgaiŋe Anutu magaŋberâm aktere âmâ luâk siâ pagaleŋe olop arekŋe nâŋgâlân togom nogonmâ hin makniŋep, ");
INSERT INTO tim_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Konelio, Anutu magaŋmenâ nâŋgâmbo âlepŋe agep. Akto siâ siâ kalem akmenâ gekmâ nâŋgâ giŋdo âlepŋe akmap. ");
INSERT INTO tim_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Aregât gâŋe hoŋ bawalupge huŋgunyeŋgimenâ Yope kepian arim ain luâk siâ kotŋe Simoŋ kotŋe siâ Petoro are kewugum togowai. Yâk ikiŋe nambeŋe Simoŋ makao hâkŋe kau hekom parutmâ kato puligomai aregât emet haru ginŋân tatâp ain yâk olop mandat.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aŋeloŋe hain makniŋdo ainâk hoŋ bawalupne gâŋgâlân huŋgunyeŋgire den mem togombiâ togoât aregât kambiamne âlepŋe aktâp. Akto togom Anutugât dewunŋân yu taten imâ Humoŋe den potatmâ giŋep are maknengimenâ nâŋgâne. Gâ aregât togoât gârâmâ maknengi.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Hain dâmbo Petoroŋe hin makyeŋgiep, “Anutuŋe luâk nengât agak meme nenŋaet nâŋgâm hin dâmap, “Luâk hârok dopyeŋe konogâk akmai.” dâmap are hinŋe nâŋgâm heŋgemgoân. ");
INSERT INTO tim_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Luâk kâmotŋe kâmotŋe yâk yeŋgâlân gâtŋe bikŋande Anutu gala agaŋmâ agak meme âlepŋeâk akyeŋgimai aregât meyekbiapgât dopŋe tatâp. ");
INSERT INTO tim_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Akto Anutuŋe propete luâklupŋe huŋgunyeŋgimbo Israe nengât hutnenŋân togom Anutuŋe hoŋ bawaŋe huŋgunaŋdo gem damunyeŋe akbiap dâmini are Israe luâk nengâlâk bo. Luâk kâmotŋe kâmotŋe nen hârok damun nenŋe akbiap aregât den pat âlepŋe are biwiyeŋe sândugeâkgât makyeŋgim gayi are âmâ Yesu yâkgât keiŋe ye nâŋgâmai. ");
INSERT INTO tim_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Akto Yohaneŋe biwiyeŋe Anutugât katbiâ tu puli yeŋgiwe dâmbo ain gâtŋande Galilaia akto Yudaia hân tânâmŋân kulem keiŋe keiŋe miawakto ekbiâ dâtŋe agep aregât patŋe nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Akto Anutuŋe ikiŋe Heakŋe huŋgunaŋdo Yesu Nasarete kepian gâtŋe are memeŋe agaŋdo aregât wâtŋân manmâ hân biken biken arim togom gala akyeŋgim malep. Akto Niambi bâleŋande luâk mem hilip yeŋguep are mem heŋgemyeŋgum metiep. Akto Anutuŋe tângombo âi hain miep aregât ye nâŋgâi. ");
INSERT INTO tim_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Akto Yerusalem kepian akto Yuda luâk nen manmaenân ain nen olop manmâ kulem keiŋe keiŋe mendo are ekmâ meteyion. Akto lâwinân kombiâ moep. ");
INSERT INTO tim_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mondo hilâm âlâwuŋe bo akto Anutuŋe memeŋe agaŋdo momoŋânba agato egion. ");
INSERT INTO tim_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Agatmâ luâk hanâk hanâk yeŋgâlân bo miawagep. Nengâlânâk miawakto egion. Anutuŋe nune pat dâm menenekto malion nengâlânâk miawagâk dâmbo hainâk miawagep. Momoŋânba agato yâk olop sot nem aŋgi goaŋgi akmâ den magaŋgi goaŋgi agion. ");
INSERT INTO tim_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Akto Anutuŋe golâ manden me emelâk moyi nen hârogâk Yesuŋe den dâm hârenengiwiap aregât luâk kautŋe kalep. Akto Anutuŋe Yesugât den pat âlepŋe ire luâk kâmotŋe kâmotŋe makyeŋgiŋet dâm aregât makmâ nengiep. ");
INSERT INTO tim_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Akto ulikŋân propete luâklupŋande Yesugât den hin dâyi, siâŋe biwiŋe Anutuŋe huŋgunaŋdo gewiap yâkgâlân kato Anutuŋe nanŋaet kotŋaet akmâ luâk aregât dosa hepunaŋbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petoroŋe den hain dâm makyeŋgimbo nâŋgâm tali are yeŋgâlân Anutugât Heakŋe giep. ");
INSERT INTO tim_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Gem kautyeŋân mendo elewetyeŋe purik âgâmbo den siâ siâ makmâ Anutu magaŋmâ kotŋe mem agatbiâ aregât Yope kepian gâtŋe Yuda luâk Petoro olop togoyi arekŋe yekbiâ dâtŋe akto han undup agi. ");
INSERT INTO tim_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Hain akbiâ Petoroŋe hin dâep, “Ulikŋân Anutuŋe Heakŋe huŋgunaŋdo nengât kaknenŋân giep. Akto hainâk uŋak kepia ambolupŋe yeŋgât kakyeŋân geâp, aregât niŋande tu puli yeŋgiwerengât makmâ hârewiap?” ");
INSERT INTO tim_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","hain dâm luâk âmbâle bikŋe tu puli yeŋgim Yesu kotŋe konŋet dâm makyeŋgimbo hain agi. Hain akmâ Petoro mem gangerâmbiâ âmâ yâk olowâk manbiâ hilâm amon siâ bo akto ariep. ");
INSERT INTO tim_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposolo akto Yuda luâk âmbâle bikŋe Yudaia hânân manmâ biwiyeŋe Yesugâlân katmâ mali arekŋe Yuda luâk bo manmai are Anutugât den nâŋgâm lokoyi are yeŋgât pat nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nâŋgâmbiâ Petoroŋe Yerusalem kepian purik katmâ arim âgâmbo Yuda luâkŋe Petoroŋe hain agepgât nâŋgâmbiâ ârândâŋ bo akto hin magaŋi, ");
INSERT INTO tim_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Gâŋe âgâlân hâkyeŋe bo gâi yeŋgiyi are yeŋgât hutyeŋân arim bâtyeŋânba sot mem nien are nâŋgâenŋe bâliep.” ");
INSERT INTO tim_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hain dâmbiâ aregât Petoroŋe wan me wan miawagep aregât keiŋânbak den pat makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Makyeŋgim hin dâep, “Nâŋe âgâlân Yope kepian manmâ Anutu magaŋmâ âmâ biwine purik kato humoŋe biwinân den kato hin egân. Mâron humo hainare himbimânba gem gem keinân giep. ");
INSERT INTO tim_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gembo âmâ are ekmâ heŋgemgoân. Katip are kâlegen soŋgo lâut toŋga keiŋe keiŋe Yuda nen bo nemaen hain arekŋeâk yiep. ");
INSERT INTO tim_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yendo ektere âmâ himbimânba den siâ hin dâmbo nâŋgân, “Petoro are gâim om ne.” dâmbo nâŋe hin dân, ");
INSERT INTO tim_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Humo, nâ bo. Hainare kâmbokŋe bo neman.” ");
INSERT INTO tim_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Hain dâre himbimânba den lâuwâŋe hainâk dâm makniŋep, “Anutuŋe imâ neneŋe dâmap are amâ bâleŋe bo dâwen.” hain dâm makniŋep. ");
INSERT INTO tim_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hain akto lâuwâŋe âlâwuŋe hainâk dâmbo himbimân âgâep. ");
INSERT INTO tim_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Âgâmbo ainâk Kaisarea kepian gâtŋe luâk âlâwu akmâ Konelioŋe huŋgun yeŋgimbo togoyi. ");
INSERT INTO tim_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Togom mem miawaknekbiâ Anutugât Heakŋande hin makniŋep, “Gâ yâk olop ari. Nâŋgâmâk bo akben.” hain dâmbo arienŋe Yesugât kâmolân gâtŋe luâk nâmbulân konok ire olowâk ariyion. Arim tembe loko yeŋgât humoyeŋe siâgât emelan âgâenŋe den hin dâm maknengiep, ");
INSERT INTO tim_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Nâ emelan âgâre aŋelo siâŋe miawak niŋmâ hoŋ bawalupne huŋgun yeŋgire Yope kepian arim luâk siâ kotŋe Simoŋ Petoro are kewugum togowi. ");
INSERT INTO tim_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Togombiâ den makto âmâ nâ akto nâŋgât ginbailupne âlepŋe akmâ manbaigât aŋeloŋe hain dâm makniŋep.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Konelioŋe hain dâmbo nâŋe den hâuŋe makyeŋgim kindere sop ainâk Anutugât Heakŋande kakyeŋân giep. Ulikŋân nengâlân Anutugât Heakŋande kaknenŋân giep hainâk sop ain kakyeŋân giep. ");
INSERT INTO tim_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Gembo ekmâ âmâ ulikŋân Yesuŋe den maknengiep are nâŋgâm heŋgemgoân, “Yohaneŋe tu puli yeŋgiep gârâmâ nune Heakŋe are huŋgunaŋdere kakyeŋân gewiap.” Yesuŋe den hain dâep are nâŋgâm heŋgemgoân. ");
INSERT INTO tim_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Akto nenŋe biwinenŋe Yesu humo Anutuŋe huŋgunaŋdo giep aregâlân katmâ mandenŋe âmâ Anutuŋe ikiŋe Heakŋe nengât huŋgunaŋep hainâk yeŋgâlân huŋgunaŋep. Aregât nâŋe Anutu hamiaŋbiangât dopŋe bo tatâp.” ");
INSERT INTO tim_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Petoroŋe hain dâm makyeŋgimbo nâŋgâm biwiyeŋe heroŋe akto hin dâyi, “Anutuŋe ulikŋân nengât biwinenŋe kârikŋe agep are goaŋnengiep. Goaŋnengimbo biwinenŋe Yesugâlân katenŋe hilip nenguwiapgât dop bo agep. Dâ uŋak âmâ Anutuŋe Yuda luâk bo manmai are oloŋ yekto Yesugâlân biwiyeŋe kali aregât bâleŋande hilip yeŋgu yeŋgugât dop bo agep.” dâyi. Dâm nâŋgâm Anutugât kotŋe mem agatmâ kambiamyeŋe âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Akto emelâk luâk kotŋe Stepano kombiâ moep ainâk Yesugât kâmotlupŋe bikŋe yeŋgum watyekbiâ potalakmâ bikŋande Poinike hânân ariyi. Akto bikŋande Antiokia akto Kipiro ariyi. Arim manmâ Yesugât den pat âlepŋe are Yuda luâk makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Hain akbiâ hutyeŋân gâtŋe luâk bikŋe Kipiro kepian gâtŋe akto Kirene hânân gâtŋe luâk arekŋe Antiokia kepian arim Yesu Humogât den âlepŋe are kepia ambolupŋe Girik gâtŋe are makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Makyeŋgimbiâ Anutuŋe meme akyeŋgiep aregât luâk âmbâle dondâŋe Yesugât kâmolân dewatiyi. ");
INSERT INTO tim_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Hain akbiâ aregât den pat arekŋe sambelem Yerusalem kepian Yesugât kâmot mali are yeŋgâlân arimbo nâŋgâm Banaba huŋgun aŋbiâ Antiokia kepian ariep. ");
INSERT INTO tim_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Arim Anutuŋe ukenŋe nâŋgâyeŋgim damunyeŋe agep are ekmâ kambiamŋe âlepŋe agep. Akto luâk âmbâleŋe biwiyeŋe Humogâlân katmâ mali hainâk akŋet dâm aregât den kârikŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabaŋe biwiŋe Yesugâlânâk katmâ mando aregât Anutugât Heakŋande meme agaŋdo âlepŋeâk malep. Akto den pat makyeŋgimbo nâŋgâm luâk âmbâle dondâŋe Yesugâlân biwiyeŋe katmâ mali. ");
INSERT INTO tim_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Akto Banabaŋe Saulo ekberâm Taso kepian ariep. ");
INSERT INTO tim_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Arim mem miawakmâ kewugumbo Antiokia kepian togoyiat. Togombela Yesugât kâmot olop mali. Manmâ Yesugât den pat âlepŋe are makyeŋgim manbela hombaŋ konok bo agep. Akto Antiokia kepian Yesugât kâmot are yekmâ okot âlep akmâ kotyeŋe Kristogât kâmot yeŋgonli. ");
INSERT INTO tim_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sop ain Anutugât den makmâ miawagi areyeŋgât hutyeŋânba bikŋande Yerusalem kepianba gem Antiokia kepian ariyi. ");
INSERT INTO tim_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Akto areyeŋgâlân gâtŋe siâ kotŋe Agabo are Anutugât Heakŋande hân ain mop humo miawakbiapgât magaŋdo aregât den kârikŋe siâ makyeŋgiep. Makyeŋgimbo luâk kotdâ siâ kotŋe Klaudio Roma kepian malep sop ain mop humo are miawagep. ");
INSERT INTO tim_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Akto biwiyeŋe Yesugâlân kaliŋe den are nâŋgâm puli me wan me wan tatyeŋgiep are mendugum katbiâ galalupyeŋe Yuda hânân mali are yeŋgâlân ariâk dâm kali. ");
INSERT INTO tim_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hain akmâ puli mem menduguyi are Banaba akto Saulo yâk yetkimbiâ mem arim Yesugât kâmot Yuda hânân mali are yeŋgât galalupyeŋe yeŋgiyiat. ");
INSERT INTO tim_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sop ain luâk kotdâ siâ kotŋe Herote yâkŋe, “Yesugât kâmotlupŋe yeŋguwe.” dâep. Dâmbo Herotegât kâmotlupŋande Yesugât kâmotlupŋe luâk âmbâle yeŋgum hâk hilâlâm yeŋgim mem kala busi emet kâlegen katyekbiâ tali. ");
INSERT INTO tim_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Hain akbiâ Yohanegât teuŋe Yakobo yâkgât dâmbo tâwâtŋe ewumbiâ moep. ");
INSERT INTO tim_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hain akto Yuda luâkŋe yâkgât ukenŋe akbiâ yekmâ tembe loko hin makyeŋgiep, “Petoro yâkâ hainâk agaŋŋet.” dâmbo mem kala busi emet kâlegen katbiâ talep. Akto sot bo kaulemap aregât sopŋe miawakto sumbe omberâmbiâ âmâ ainâk kala busi kâlegen katbiâ talep. ");
INSERT INTO tim_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Katbiâ tato sumbe om nembiâ bo akto Heroteŋe Petoro den âiân katberâm aregât hoŋ bawalupŋe makyeŋgimbo lâuwâŋe mem kala busi kâlegen katbiâ tato tembe loko 16 tatmâ Petoro ariwop dâm damunŋe kârikŋe agi. ");
INSERT INTO tim_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ariwop dâm tembe loko humoyeŋande âi hârem yeŋgimbo kâmot imbât siâkâ lâmgombiâ lâmgombiâ akmini. Akto Yesugât kâmotlupŋande den are nâŋgâm Petorogât hilâm ârândâŋ Anutu ulilaŋi. ");
INSERT INTO tim_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Akto Heroteŋe Petoro mem den âiân katberâm agep aregât sopŋe tâlâguep. Akto emet bo hauŋdo hândâkŋân tembe loko damun lâuwâŋe Petoro mem tâk kârikŋe kotŋe sein arekŋe hikom katbela hutyetŋân asiŋ yiep. Akto tembe loko bikŋande betgen kinmâ damungoyi. ");
INSERT INTO tim_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Damungom kinbiâ Humogât aŋelo siâŋe yâkgâlân pagaleŋe olowâk miawakmâ kindo âmâ pagaleŋe arekŋe emet kâlegen pagalembo aŋeloŋe Petoro goaŋmâ hin dâep, “Agatmâ kin.” dâmbo tâk kârikŋe are hulaŋ akto Petoroŋe agalep. ");
INSERT INTO tim_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Agato aŋeloŋe hin magaŋep, “Hâk pekeŋege lalakmâ kei pekeŋege mem lugu akmenâ nâ olop arire.” dâep. Hain dâmbo lauŋe lokoep. ");
INSERT INTO tim_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Lauŋe lokom âmâ lope kâlegenba gem Petoroŋe han lâuwâ akmâ aŋeloŋe wan agep are giwelân ekmâ bunŋe bo dâm nâŋgâep. ");
INSERT INTO tim_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hain nâŋgâm kindo betgen tembe loko kili are ewangi yekmâ arewa arim tembe loko kili arekâ hainâk ewangi yekmâ arim haot bâiŋângen arim hâŋgi kârikŋe pali ain arimbela ikiŋak lewulakto arewa gem ariyiat. Akto gem dâwân aŋelo are ainâk heambugep. ");
INSERT INTO tim_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Heambukto Petoro ainâk biwiŋe hulaŋ akto hin dâep, “Hinŋeâk âmâ bunŋe nâŋgâm heŋgemgoân. Humoŋe aŋelo huŋgunaŋdo gem Herotegât tâk kârikŋânba akto Yuda luâk bikŋe yeŋgâlânba mem oloŋnektâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hain dâm arim Yohane kotŋe siâ Mareko memeŋe kotŋe Maria yâkgât emelan ariep. Arimbo âmâ luâk âmbâle dondâ mendugum tatmâ Anutu ulilaŋmâ tali emet ain âgâep. ");
INSERT INTO tim_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ulilaŋmâ tatbiâ Petoroŋe âgâm emet dawalauŋân kinmâ, “Woa” dâep. Hain dâmbo hoŋ bawa âmbâle siâ kotŋe Rode togom hâŋgiân talep. ");
INSERT INTO tim_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ain tatmâ nâŋgâm hin dâep, “Mâ, Petorogât den hin.” dâm mârum biwiŋe heroŋe akmâ hâŋgi bo mem katmâ âmâ emet kâlegen âgâm hin makyeŋgiep, “Petoro ina togo hâŋgiân kindâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hain dâm makyeŋgimbo nâŋgâm, “Biwige gulip aktâp.” dâyi. Hain dâm magaŋbiâ kârikŋe akmâ dâep, “Bo. Bundâk togo yu hâŋgiân kindâp.” dâep. Hain dâmbo hin dâyi, “Otneŋande mon togo kindâp?” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hain dâm magaŋgi goaŋgi akbiâ Petoroŋe hainâk kârikŋeâk, “Woe” dâmbo hâŋgi mem katmâ Petoro ekmâ sân sân membiâ dâtŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dâtŋe akto bâtŋande koratyeŋgum, “Den yoŋâk” dâmbo den yoŋâk tatbiâ Humoŋe kala busi emet kâlegenba mem hulaŋep aregât den pat makyeŋgiep. Hain makyeŋgimbo nâŋgâm heroŋe akbiâ hin dâm makyeŋgiep, “Den pat ire Yakobo akto galalupŋe makyeŋgiŋet.” dâm hepun yekmâ gem siângen ariep. ");
INSERT INTO tim_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Emet hauŋdo tembe loko arekŋe Petoro undâgâtmâ gain gain aktâp dâm han lâuwâ agi. ");
INSERT INTO tim_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hain akbiâ Heroteŋe hâwât yekmâ, “Mem miawakŋet.” dâm makyeŋgimbo undâgâtmâ arim tembe loko bikŋande Petorogât makyeŋgimbiâ pâpkom kinbiâ aregât tembe loko moŋetgât dâep. Akto Herote Yuda hân hepunmâ Kaisarea kepian ge malep. ");
INSERT INTO tim_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Akto sop ain Heroteŋe Tiro akto Sidoŋ kepia ambolupŋe are gasa akyeŋgiep. Gasa akyeŋgimbo aregât kepia ambolupŋande mendugum den are makmâ heŋgemgowerâm akmâ luâk kotdâ siâ kotŋe Bilasto Herotegât hoŋ bawalupŋe yeŋgât humoyeŋe malep yâkgât dâmbiâ tân yeŋguep. Tân yeŋgumbo benŋe wan me wangât magaŋgi goaŋgi akmâ Herotegât hân arewa sot meyigât gala agaŋberâm Heroteŋe den are purik katyeŋgiwiapgât den kalep, ");
INSERT INTO tim_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","are tâlâgumbo aregât luâk kotdâgât sâŋgum mendo âgâmbo dewun yeŋân kinmâ luâk kotdâ yeŋgât tatalân tatmâ den makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Makyeŋgimbo luâk hârokŋe den humo akmâ hin magi, “Den ire luâk denŋe bo. Den ire âmâ Anutugât denŋe hinare.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hain dâmbiâ Heroteŋe den are nâŋgâm Anutugât nâŋgâmbo giep aregât Anutuŋe aŋelo siâ huŋgunaŋdo gem kondo nane bâleŋande tepŋe igim hârembo moep. ");
INSERT INTO tim_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Gârâmâ luâk âmbâle dondâŋe Anutugât den nâŋgâm biwiyeŋe Yesugâlân katmâ mali. ");
INSERT INTO tim_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Akto Banaba akto Saulo yâk âi yetkiyi are mem metem Yerusalem kepia hepunmâ Antiokia kepian purik katmâ ariwerâm Yohane kotŋe siâ Mareko kewugumbela olowâk ariyi. ");
INSERT INTO tim_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Yesugât kâmotlupŋe Antiokia kepian gâtŋe Anutugât den makmâ miawagi akto den makyeŋgimini are yeŋgât kotyeŋe hin. Banaba akto hâk heleŋ siâ kotŋe Simeoŋ akto Lukio Kirene hânân gâtŋe akto Manaeŋ are luâk kotdâ Herote olop nanaŋânbak manmâ gala konok akmâ maliat. Akto siâ kotŋe Saulo. ");
INSERT INTO tim_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yâkŋe Anutu magaŋberâm aregât sot bâlâk manmâ âmâ hilâm siân tatbiâ âmâ Anutugât Heakŋande den hin makyeŋgiep, “Banaba akto Saulo âi dâm hârem yetkiân are membiandatgât katyelekbi.” ");
INSERT INTO tim_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hain dâmbo aregât den lokom Anutu ulilaŋmâ sot bâlâk manmâ âmâ kautyetŋân mem âiân ariet dâm huŋgun yetkimbiâ Yohane kotŋe siâ Mareko are kewugumbela olop ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Arimbiâ Anutugât Heakŋande huŋgun yeŋgimbo Seleukia kepian ariyi. Ain arimbiâ waŋga siâŋe meyekmâ Kipiro hân haru tânâmŋân talep ain ariep. ");
INSERT INTO tim_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ain arim katyekto waŋganba sopanmâ gem Salami kepian ain ariyi. Ain arim Yuda yeŋgât den emetŋân âgâm Anutugât den pat âlepŋe are makyeŋgiyiat. Makyeŋgimbela Yohane kotŋe siâ Mareko arekŋe tânyetkuep. ");
INSERT INTO tim_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Arewa hân biken ariwerâm akmâ kepia kotŋe Papo ain tali. Ain tatmâ Yuda yeŋgât luâk kâmbokŋe siâ kotŋe Barayesu akto kotŋe siâ Elima are egiat. Yâkŋe âmâ galalupŋe heyeŋgim hin dâep, “Nâ Anutugât den bunŋe makyeŋgiman. Akto nâ Anutugât hoŋ bawa mandân.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hain dâm âmâ kiap siâ Seregio kotŋe siâ Paulosi yâkgât gala malep. Seregio yâk âmâ nâŋgâ nâŋgâŋe olop malep. Akto Anutugât den are nâŋgâwerâm akmâ Banaba akto Saulo mem oloŋyelegep. ");
INSERT INTO tim_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mem oloŋyelekto ainâk luâk kâmbokŋe Elima arekŋe, “Galane Seregioŋe biwiŋe Yesugâlân katbop.” dâm denyetŋe kakŋân makmâ koyetkiep. ");
INSERT INTO tim_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Den koyetkimbo aregât Saulo kotŋe siâ Paulo yâkŋe Anutugât Heakŋande meme agaŋepgât owâiŋeâk Elima tâŋâk ekmâ kinmâ hin magaŋep, ");
INSERT INTO tim_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Gâ Hiaŋgi amboŋe yâkgât nanŋe aregât luâk agak meme bâleŋe mem manmai yâk yeŋgât gala aktât. Akto wan me wan âlepŋe aregât gasa aktât. Akto hiaŋgi luâk manmat. Aregât Humogât den bunŋe are bo nâŋgâŋet dâm aregât heyeŋgimat. Gâ biwige bâleŋe. ");
INSERT INTO tim_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Aregât hâuŋe Humoŋe giŋberâpgât dewunge hândâk akto yânâk man.” dâep. Hain dâmbo ainâk dewunge hândâk akto luâkŋe bâtnân menekbiâ ariwerâm luâk yeŋgât undâgâtmâ gem ariep. ");
INSERT INTO tim_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gem arimbo Seregioŋe are ekto dâtŋe akto Anutugât den are nâŋgâmbo âlepŋe akto biwiŋe Yesugâlân katmâ den lokom malep. ");
INSERT INTO tim_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo galalogâtŋe olowâk Papo kepia are hepunmâ waŋgan âgâmbiâ meyekmâ arim Pampilia hân are ginŋân Perege kepia haru ginŋân talep ain arim katyegep. Katyekto arewa Yohane kotŋe siâ Mareko yâk hepunyelekmâ Yerusalem kepian purik katmâ ariep. ");
INSERT INTO tim_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Arimbo yâk yetŋeâk âmâ Perege kepia are hepunmâ arim Pisidia hân tânâmŋân Antiokia kepia ain ariyiat. Ain arim Sarereân Yuda luâk yeŋgât den emetŋân âgâm mendugum taliân ain âgâmbela olop tali. ");
INSERT INTO tim_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Akto yâk yeŋgât damun siâŋe agatmâ Mosegât den kârikŋe are akto Anutuŋe makto kulemgoyi are oyaŋdo nâŋgâmbiâ âmâ damunŋande Paulo akto Banaba hin dâm makyetkiep, “Galalogâtne, luâk âmbâle nen biwinenŋe mem kârikŋe ketuguâkgât den siâ âlepŋe maknengimbela nâŋgâweren me bo?” dâep. ");
INSERT INTO tim_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hain dâmbo Pauloŋe agatmâ bâtŋande koratyeŋgum hin makyeŋgiep, “Israe luâk galalupnetŋe akto Israe luâk bo yeŋgâlân gâtŋe biwiyeŋe Anutugât hamewakmâ mandâi. Akto ye hârok makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israe luâk nengât Anutu yâkŋe bâgilupnenŋe mem katyekto Aigita hânân manbiâ âmâ tânyeŋgumbo miawakmâ dondâ agi. Akto Anutugât kârikŋân kinbiâ ainba kewuguyekmâ togoyi. ");
INSERT INTO tim_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Togom hân kamitŋân katyekto manbiâ gala akyeŋgimbo manbiâ âmâ hombaŋ 40 agep. ");
INSERT INTO tim_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Akto Kanaŋ hânân luâk kâmot 7 are Anutuŋe hilipyeŋgumbo bâgilupnenŋande hân are mem amboŋe akmâ manmâ gayi. ");
INSERT INTO tim_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Manmâ gambiâ gambiâ hombaŋ 450 bo agep. Akto sop ain damunlupyeŋe katyekto siâkâ sopŋân sopŋân damunyeŋe agi. Damunyeŋe akmâ gambiâ Propete luâk siâ kotŋe Samue are miawagep. ");
INSERT INTO tim_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Miawakto âmâ luâk humogât dâmbiâ Anutuŋe Bensamiŋgât kâmolân gâtŋe kotŋe Saulo miep. Saulo amâ Kisigât nanŋe yâkŋe damunyeŋe akto hombaŋ 40 bo agep. ");
INSERT INTO tim_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bo akto are watmâ yâkgât gewâkŋân Dawidi are katmâ Anutuŋe hin dâep, “Nâŋe Yesegât nanŋe Dawidi yâkgât nâŋgâre ârândâŋ aktâp. Wan me wangât dâre are lokom manbiap.” dâep. Hain dâm damunyeŋe ak dâm kalep. ");
INSERT INTO tim_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Aregât bunŋe Dawidigât kâmolân gâtŋe Yesu Israe luâk nengâlân miawagep. Nengâlân miawakmâ damun nenŋe agâk dâm yâkgât pat maknengiep are bunŋe agâk dâm ");
INSERT INTO tim_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Anutuŋe Yohane soŋ huŋgun aŋdo miawagep. Miawakmâ Israe luâk hârok hanyeŋe purik kato Anutugâlân ariŋet dâm tu puli yeŋgiwerâm den kârikŋe makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Akto Yohane âi miep are bo akberâm akto âmâ luâk hin dâm makyeŋgiep, “Nâŋgât niŋe dâmai? Togom damun nenŋe akbiap are nâ hinare bo. Ikiŋak hâmbâi togowiap. Yâkgât ito goliaŋdere bo ârândâŋ akbiap.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Galalupne Abrahamgât kâmot ye akto Yuda gâtŋe bo manmai yeŋgâlân gâtŋe Anutugât hamewakmâ manmai, ye makyeŋgire nâŋgâŋet. Anutuŋe nen hememgât dop akmâ hilip aguwâengât nenekmâ Yesu huŋgun aŋdo giep. ");
INSERT INTO tim_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusalem kepia ambolupŋe akto damunlupyeŋande Yesugât keiŋe akto propeteŋe kulemgoyi aregât keiŋe bo nâŋgâm heŋgemgom bugâ neâk dâm aregât makmâ hâreaŋi. Makmâ hâreaŋbiâ mondo ainâk Propete luâk are yeŋgât den kârikŋe are Sarere ârândâŋ oyaŋmâ manmaen are bunŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Akto Yesuŋe dosa siâ bo agepgât yâkgât dosaŋaet undâgâtbiâ bo akto hanâk kârikŋe akmâ kautyeŋe orem lâwinân moâk dâm Pilato magaŋmâ hâwâtbiâ denyeŋe nâŋgâmbo kombiâ moep. ");
INSERT INTO tim_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Anutuŋe huŋgunaŋdo gewiapgât den kulemgoyi are amâ miawakto lâwinân kombiâ mondo lokom arim sumân katbiâ yiep. ");
INSERT INTO tim_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Yendo arewa Anutuŋe momoŋânba mem agalep. ");
INSERT INTO tim_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mem agato emelâk Galilaia hân hepunmâ Yerusalem kepian olowâk ariyi yâk yeŋgâlân hilâmŋe hilâmŋe miawak yeŋgimbo den magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Miawak yeŋgimbo âmâ Anutuŋe bâgilupnenŋe yeŋgât makmâ hâriep are bunŋe agâk dâm Yesu goaŋdo momoŋânba agalep, aregât pat âlepŋe dâm makyeŋgimaen. ");
INSERT INTO tim_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Akto Yuda yeŋgât kep keŋgu lâuwâŋe agi aregât den kulemgoyi are tatâp. Anutuŋe nanŋaet hin dâep, “Gâmâ nâŋgât nanne gârâmâ nâŋe uŋak meŋgektân.” ");
INSERT INTO tim_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Akto Yesuŋe momoŋânba agalep are âmâ hâmbâi lâuwâŋe bo mombiap, aregât Anutuŋe nanŋaet den hin dâep, “Ulikŋân nâŋe Dawidi agaŋân aregât nâŋgâm heroŋe akmâ agak meme ârândâŋ agep. Akto hainâk gâŋgât dâm akgiŋbian.” ");
INSERT INTO tim_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Akto Yuda yeŋgât kep keŋgu siâ Dawidiŋe hin kulemgoep are tatâp, “Anutu humo gâŋe hoŋ bawage âlepŋe nâ hepun nekmenâ mom âmâ bo hambuwian.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dawidiŋe den kulemgoep amâ ikiŋaet bo kulemgoep are nâŋgâmaen are Anutuŋe âi makmâ hârem waŋep. Are luâklupŋe yeŋgâlân âi mem metem âmâ moep. Mondo bâgilupŋaet sumân hangombiâ hambuep. ");
INSERT INTO tim_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Akto Anutuŋe Yesu mem agalep are âmâ bo hambuep. ");
INSERT INTO tim_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Galalupne nâŋe makyeŋgire nâŋgâŋet. Dosa bâleŋe hepun yeŋgiwiap aregât âmâ Yesu miawagepgât denŋe dâm makyeŋgiwerâm aktân. ");
INSERT INTO tim_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosegât den kârikŋe arekŋe dosanenŋe hepun nengiâk dâm aregât ewum hâumgoyi. Yeŋe Yesugâlân biwiyeŋe katbiâ yâkŋe âmâ âlepŋe dosayeŋe hepunbiap. ");
INSERT INTO tim_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Akto ulikŋân Propete siâŋe den siâ kulemgoep are tatâp. Anutuŋe den hin dâep, “Wangât den hâkâŋ akmâ mandâi? Yeŋe ire nâŋgâmbiâ dâtŋe akto ain mombai. Haingât yeŋgâlân wan me wan irakŋe siâ uŋak ketuguwerân aregât pat makyeŋgimbiâ yeŋe hiaŋgiâi dâmbiâ biwiyeŋe kârikŋe akbiap.” Anutuŋe hain dâep. Ye aregât dopŋe akbâigât den are heŋgemgom nâŋgâwi.” Pauloŋe hain dâm makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Hain dâm dewunyeŋânba gembo Banaba olop sopanberâm akbela ain kili arekŋe togom hin makyetkiyi, “Sarere siân iren âgâenŋe purik katmâ iregâlâk togom maknengimbela nâŋgâm heŋgemgowaen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hain dâm gembiâ kâmot kili are yeŋgâlân gâtŋe bikŋe akto Yuda luâk bikŋe akto Yuda luâk bo manmai arekŋe Yuda yeŋgâlân dewatiyi yâkŋe âmâ Paulo akto Banaba hamiyetŋân arim mem watyelekbiâ hin dâm makyeŋgiyiat, “Anutuŋe ikiŋe hanŋaet akmâ yeŋgât okotŋe nâŋgâep aregât pat hâkâŋe bo akŋet. Biwiyeŋe yâkgâlânâk katŋet.” dâm makyeŋgiyiat. ");
INSERT INTO tim_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Akto Sarere siân Anutugât den nâŋgâwerâm ukenŋe agi arekŋe hamepŋe olowâk togoyi. ");
INSERT INTO tim_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Togombiâ Yuda luâkŋe yekmâ hin dâyi, “Hepun nenekbiâ kotnenŋe gewop.” dâm nâŋgâm aregât Paulogât denŋe are hâkâŋ akmâ yâkgât den are mem geyi. ");
INSERT INTO tim_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hain akbiâ aregât Paulo akto Banaba yâkŋe kârikŋe akmâ hin dâm makyeŋgiyiat, “Yuda luâk ye makyeŋgietŋe nâŋgâŋet. Anutugât den yeŋgâlân soŋ togoâk Anutuŋe hain dâm kalep. Den aregât hâkâŋ akmâ manman kârikŋaet den pat are hâkâŋ akberâm borâi aregât ye hepun yekmâ Yuda luâk bo manmai yâk yeŋgâlân ariweret. ");
INSERT INTO tim_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Haingât Anutuŋe hin dâep, “Nâŋe gâ pagaleŋe aregât dop hainare kat gektere Yuda luâk bo manmai yeŋgâlân arim nâŋgât den makmâ miawakyeŋgiwen. Akto luâk âmbâle hârokŋe biwiyeŋe nâŋgâlân katbiâ meyekbiangât kat gektere hân bâiŋângen arim makben.” dâep. Anutuŋe hain dâmbo propete siâŋe kulemgombo oyaŋmâ den ire netgât kulemgoep dâetŋe huŋgun netkimbo ariweret.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hain dâmbela Yuda luâk âmbâle bo manmai den are nâŋgâm hin dâyi, “Amâ Humogât den.” dâmbiâ aregât biwiyeŋe heroŋe agep. Akto Anutuŋe ikiŋe ukenŋaet akmâ luâk âmbâle tân yeŋgumbo biwiyeŋe Yesugâlân kali. ");
INSERT INTO tim_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Akto Humogât den are makmâ magaŋgi goaŋgi akbiâ den arekŋe sambelem arimbo luâk âmbâle ain mali are hârokŋe nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Haingât Yuda luâk arekŋe âmâ kepia aregât luâk humo akto âmbâle humo Anutugât den lokonerâm Yuda yeŋgât kâmolân dewatim mali, are hanyeŋân gembiâ biwiyeŋe kâlâp akto Paulo akto Banaba hanâk gasa akyetkiyi. Hain akmâ watyelekbiâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ariwerâm kinmâ Yuda luâk dewunyeŋân yeŋaet agak meme bâleŋe are dop kom keiyetŋân gagap talep are paŋ paŋgom panmâ hepunyekmâ gem Ikonioŋ kepian ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Arimbela Antiokia kepia ambolupŋe biwiyeŋe Yesugâlân kali arekŋe heroŋe akbiâ Anutugât Heakŋande dondâ tânyeŋguep. ");
INSERT INTO tim_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Akto hainâk Ikonioŋ kepian arim âmâ Yuda luâk yeŋgât den emetŋân âgâm Yesugât keiŋe makyeŋgimbela nâŋgâyi. Nâŋgâm Yuda luâk âmbâle akto Yuda luâk âmbâle bo manmai dondâŋe biwiyeŋe Yesugâlân kali. ");
INSERT INTO tim_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Akto Yuda luâk bikŋande Yesugât den are hâkâŋ akmâ mem ge katberâm agi arekŋe Yuda bo manmaiân gâtŋe areyeŋgât hanyeŋân gembiâ biwiyeŋe kâlâp akto aregât Paulo akto Banaba gasa akyetkiyi. ");
INSERT INTO tim_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Gasa akyetkimbiâ kepia ainâk manmâ Humogât den are makyeŋgim manbela sop kâlep agep. Akto Anutuŋe luâk âmbâle gala akyeŋgim damunyeŋe akberâm agep aregât keiŋe makyeŋgimbela are bunŋe agâk dâm Anutuŋe meme akyetkimbo kulem keiŋe keiŋe mem hamep bâlâk maliat. ");
INSERT INTO tim_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Hain akbela yelekmâ Yuda bo manmaiân gâtŋande potalakmâ bikŋande yâk yetgâlân dewatiyi. Akto bikŋande Yuda luâk yeŋgâlân dewatiyi. ");
INSERT INTO tim_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Hain akbiâ hamiŋângen kepia ambolupŋe akto Yuda luâk bikŋande damunyeŋe olowâk agatmâ Paulo akto Banaba bâleŋe akyeŋgim kâtŋe yetkuwerâm agi. ");
INSERT INTO tim_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Aregât kepia are hepunmâ Likionia hân ain Listera akto Derebe kepia lâuwâ are talialân ain arim ândeaŋmâ âi mem maliat. ");
INSERT INTO tim_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kepia ain arim Yesugât den pat âlepŋe are makyeŋgim maliat. ");
INSERT INTO tim_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Akto Listera kepian luâk siâ malep aregât keiŋe bâliep. Are memeŋaet tepŋânbak hainâk miawakmâ yân tatmâ gaep. ");
INSERT INTO tim_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hain tatmâ gaminep are Pauloŋe ekmâ Yesugât dâmbo nâŋgâm tato âmâ Pauloŋe luâk aregât biwiŋaet keiŋe ekmâ nâŋgâep. Ekmâ hin nâŋgâep, “Luâk irekŋe biwiŋe Yesugâlân katâpgât Anutuŋe heŋgemgowerâp.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Hain dâm konmâ hin dâm magaŋep, “Agatmâ kin.” dâmbo ainâk luâk arekŋe agatmâ sopanmâ bam gulep. ");
INSERT INTO tim_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Hain akto luâk kâmot humo kili arekŋe Pauloŋe kulem ketuguep are ekmâ yeŋe denyeŋân hin dâyi, “Hat sinduk siâŋe luâk akmâ hutnenŋân miawakmâ mandat.” hain dâyi. ");
INSERT INTO tim_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dâ Banabagât âmâ, “Hat sinduk humoyeŋe siâ kotŋe Dia aregât nambeŋe.” konmâ dâyi. Dâ Pauloŋe âmâ den makmâ malepgât, “Hat sinduk siâ kotŋe Hemesi are âmâ Paulogât nambeŋe yâkŋe den maknengiminep.” dâm âmâ Hemesi konmâ dâyi. ");
INSERT INTO tim_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Paulo akto Banaba yâkŋe âi are mem manbela yelekmâ aregât hat sinduk kotŋe Dia yâkgât luâk kâmbokŋe siâŋe ikiŋe sumbe emetŋe kepia ginŋângen talep ain makto buluŋe pitim bulimakao hikom oloŋmâ arim opmân kâmbokŋe siân kepia ginŋân talep ain arim Paulo akto Banaba yetgât sumbe omberâm ariyi. ");
INSERT INTO tim_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Arimbiâ Paulo akto Banaba yâkŋe den are nâŋgâmbela bo ârândâŋ akto aregât pârigim arim hutyeŋân kinmâ bâleŋe akberâm agi aregât makyeŋgim hepunŋet dâm sâŋgum yetŋe mem duwalagiat. ");
INSERT INTO tim_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Mem duwalakmâ kamboŋmâ hin dâyiat, “Wei luâkma, wangât ire akberâm aktâi? Net gai luâk, yeŋgât dop aregât net amâ hat sinduk bo. Net luâk bunŋe gârâmâ netgât sumbe bo oŋet. Yeŋe âmâ hat sinduk wan me wan membiâ bunŋe bo miawakmap aregât hepunmâ biwiyeŋe Anutugâlân katŋet dâm den pat âlepŋe are makyeŋgiwerâm togoyiot. Amâ Anutu Humoŋe hân haru himbim akto aregât kâlegen wan me wan hârok kalep yâkgât akmâ togoyiot. ");
INSERT INTO tim_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Akto ulikŋân bâgilupnenŋe yâk yeŋgât agak meme nâŋgâm miawakbiâ hanâk dâm denân bo katyegep. ");
INSERT INTO tim_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Akto hain dâm bo hepun yegep. Anutuŋe nâŋgât keine nâŋgâŋet dâm gala akyeŋgim makto tânâk gembo âi kalam yeŋân unsambe miawakmâ yendo nem heroŋe akmâ mali.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Den hain dâm makyeŋgim, “Netgât sumbe are bo oŋet.” dâm luâk âmbâle are mulunyekmâ âi humo meyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Akto sop ain Yuda luâk bikŋande Antiokia akto Ikonioŋ kepianba togom kepia ambolupŋe hanyeŋân gembiâ biwiyeŋe kâlâp akto Paulo mem kâtŋe kom âmâ, “O kondenŋe mondâp.” dâm kepia ginŋângen mem oloŋmâ gem panbiâ yiep. ");
INSERT INTO tim_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ain yendo Yesugât kâmotŋe gem ândeaŋmâ kinbiâ agatmâ kepian âgâep. Âgâm yem kindo emet hauŋdo Banaba olowâk kepia are hepunmâ Derebe kepian ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Arim âmâ Yesugât den pat âlepŋe are makyeŋgimbela luâk dondâŋe den are nâŋgâmbiâ bunŋe akto biwiyeŋe Yesugâlân katmâ mali. Akto dâp areâk purik katmâ arim Listera Ikonioŋ akto Antiokia kepian togoyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kepia ârândâŋ togom biwiyeŋe Yesugâlânâk kaligât mem kârikŋe ketugu yekmâ hin dâm makyeŋgiyiat, “Nen bugâ akto hâk hilâlâm kakŋân manmâ Anutugât manman kârikŋân ariwaengât dopŋe tatâp.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Akto biwiyeŋe Yesugât kali kâmotŋe kâmotŋe yâk yeŋgât damun katyekmâ ainâk manmâ den kârikŋe are makmâ makyeŋgim Anutu magaŋberâm aregât sot bâlâk manmâ Anutu ulilaŋiat. Akto damunlupyeŋande emelâk biwiyeŋe Humogâlân kaligât Humoŋe meme akyeŋgim damunyeŋe agâkgât ulilaŋiat. ");
INSERT INTO tim_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Akto Pisidia hân are ewangim biken arim Pampilia hânân ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Arim Perege kepian âgâm Yesugât keiŋe makyeŋgim kepia are hepunmâ gem Atalia kepian ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Arewa arimbela waŋgaŋe meyelekmâ arim Antiokia kepian arim ain katyelegep. Antiokia ain âmâ ulikŋân âi keiŋe katbela Yesugât kâmot arekŋe Humoŋe tânyetkuâkgât ulilaŋmâ huŋgunyetkimbiâ keiŋe katmâ mem ariyiat ain purik katmâ âi bo aktâp dâm togoyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ain togom kâmot are mendugu yegiat. Mendugu yekmâ Anutuŋe Yuda luâk âmbâle bo areyeŋgât biwiyeŋe mem owâimbo biwiyeŋe Yesugâlân kali aregât keiŋe makyeŋgiyiat. ");
INSERT INTO tim_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Akto Yesugât kâmot olop sop kâlep mali. ");
INSERT INTO tim_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Luâk bikŋande Yudaia hânângenba togom Yesugât kâmot Antiokia kepian mali yeŋgâlân arim hin dâm makyeŋgiyi, “Moseŋe den kârikŋe hin kulemgoep are tatâp, “Ye âmâ hâkyeŋe gâiwai.” Dâ den are bo lokom manbiâ âmâ aregât Anutuŋe bo meyekbiap.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Hain dâmbiâ Paulo akto Banaba yâkŋe den are koyeŋgim mem ge katyeŋgiwerâm akbela âmâ papalakmâ den humo agi. Hain akbiâ humomolupyeŋande den aregât hin dâm makyetkiyi, “Paulo akto Banaba yetŋe irewa Yesugât kâmot luâk bikŋe olop arim Aposolo akto Yesugât kâmotŋe kâmotŋe Yerusalem kepian mandâi are yeŋgâlân arim damunlupyeŋe olop den iregât keiŋaet makyeŋgiwai.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Hain dâm huŋgun yeŋgimbiâ Paulo akto luâk bikŋe olop ariyi. Arim Poinike akto Samaria hân are ewangim arim Yesugât kâmot siâ mali are hin dâm makyeŋgiyi, “Yuda bo manmaiân gâtŋe kugâkŋe biwiyeŋe Anutugât kali.” hain dâm makyeŋgimbiâ yâkŋe nâŋgâmbiâ biwiyeŋe heroŋe humo agep. ");
INSERT INTO tim_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Akto Yerusalem kepian arimbiâ Yesugât kâmot akto Aposolo akto yâk yeŋgât humomolupyeŋe yâk olop egakmâ heroŋe agi. Heroŋe akbiâ Anutuŋe meme akyeŋgimbo âmâ Yesugât keiŋe makyeŋgiwerâm hamep bâlâk kinmâ makyeŋgimbiâ âmâ bunŋe agep, aregât den pat are makyeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Makyeŋgimbiâ Parisaio luâk yâkŋe biwiyeŋe Yesugâlân kali yâk yeŋgâlân gâtŋe bikŋande den siâ hin dâyi, “Moseŋe hin dâep, “Hâkyeŋe gâiyeŋgim Anutugât pat kat yekŋet.” dâep, den are lokom kinmâ hâkyeŋe gâiyeŋgiŋet dâm makten. Hain maktenŋe Yuda luâk bo manmai are âmâ Mosegât den are watbiâ ârândâŋ akbiâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hain dâmbiâ aregât Aposolo akto damunlupyeŋe yâkŋe yeŋeâk ire nâŋgâm heŋgemgone dâm menduguyi. ");
INSERT INTO tim_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mendugum den are makyeŋgiwerâm akmâ manbiâ den bambo guto akmâ âmâ Petoroŋe agatmâ kinmâ hin dâm makyeŋgiep, “Galalupŋe emelâk Anutuŋe mem kepilâ nenekmâ âi makmâ hârem niŋep. Akto Yuda luâk bo manmai are yeŋgâlân arim Yesugât keiŋe makyeŋgire nâŋgâm biwiyeŋe Yesugâlân katbai aregât âi Anutuŋe makmâ hârem niŋep are nâŋgâi. ");
INSERT INTO tim_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Akto Anutuŋe luâk nen hârok biwinenŋân ekmap arekŋe ikiŋe Heakŋe huŋgun aŋdo Yuda luâk nengâlân giep. Hainâk Yuda luâk bo manmai are yeŋgâlân giep aregât Anutuŋe gala akyeŋgimbo ârândâŋ aktâp. ");
INSERT INTO tim_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yuda luâk bo manmai arekŋe biwiyeŋe Yesugâlân katbiâ ârândâŋ akto nen aknengiep dop hainâk yâk akyeŋgim biwiyeŋe pulimbo salek salek agep. ");
INSERT INTO tim_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yeŋe are nâŋgâm Anutugât dop are ewangim kinmâ wan me wan umatŋe are hakulupnenŋande akto nenŋe hainâk lokowerâm ewum hâumgom gain gain akmâ malion. Aregât dop hainâk Yuda luâk bo arekŋe biwiyeŋe Yesugât katmâ mandâi are yeŋgât kautyeŋân umatŋe siâ bo katberâm akten. ");
INSERT INTO tim_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nenŋe hin nâŋgâen. Yesu Humoŋe Yuda luâk bo manmai are yeŋgâlân gâtŋe bikŋe ikiŋe hanŋaet akmâ okot nâŋgâ yeŋgim oloŋyekto dosayeŋaet hâuŋe ârândâŋ agep. Aregât dop akmâ nen hainâk oloŋnenekto dosanenŋaet hâuŋe ârândâŋ akbiap. Nenŋe hain nâŋgâm biwinenŋe aregâlâk katmaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Hain dâmbo nâŋgâmâk tali. Tatbiâ Paulo akto Banaba Anutuŋe meme akyetkimbo Yuda luâk bo manmai are yeŋgâlân arim kulem keiŋe keiŋe meyiat aregât den pat makyeŋgiyiat. Makyeŋgimbela hâligâk nâŋgâm tali. ");
INSERT INTO tim_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Makmâ metembela nâŋgâm tatbiâ Yakoboŋe agatmâ kinmâ den hin makyeŋgiep, “Galalupne, makyeŋgire nâŋgâet. ");
INSERT INTO tim_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Anutuŋe ulikŋân Yuda luâk bo are damunyeŋe akberâm aregât nâŋgât kotne mem agatŋet dâm Yuda luâk bo manmai are bikŋe oloŋyekto biwiyeŋe ikiŋaelân kali, den pat are Petoroŋe dâmbo nâŋgâen. ");
INSERT INTO tim_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Akto ulikŋân Anutuŋe makto propete luâkŋe kulemgoyi arekŋe âmâ den pat are olop dopŋe konok aktâp are hin tatâp, “Humoŋe keiŋânbak hin dâmbo miawagep, ");
INSERT INTO tim_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Nâŋe hâmbâi purik katbianân Dawidigât kâmotŋe awam akmâ arimbiâ kepia kawum akbiap are heŋgemgowian dâre purik katmâ togom kinbiâ kepia kautŋe miawakbiap. ");
INSERT INTO tim_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Akto aregât luâk kâmot bikŋe bo nâŋgâ niŋmai are mem potatyekmâ oloŋyektere nâŋgâlân togom kinbai.” Anutuŋe hain dâep. ");
INSERT INTO tim_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Akto den ire uŋagâk bo miawaktâp. Keiŋânbak Anutuŋe hain dâm makmâ gambo bunŋe akto miawaktâp.” den hain tatâp. ");
INSERT INTO tim_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","21","Aregât biwinande nen hin akbaengât nâŋgân. Bâgilupnenŋande keiŋe katmâ manmâ gayi amâ kepia ârândâŋ Mosegât den kârikŋe ire akmâ manmâ gayi. Akto uŋak ire Sarere ârândâŋ den emetŋe ârândâŋ âgâm den are oyaŋmâ nâŋgâm manmaen. Akto Yuda luâk bo manmai arekŋe hainâk âgâm are oyaŋmâ nâŋgâm manmai. Aregât Yuda luâk bo manmai are yeŋgâlân den kârikŋaet âi humo bo yeŋgiweren. Akto bikŋande biwiyeŋe Yesugâlân katmâ Anutugât den lokowerâm akbiâ kulem esenŋe bo katyeŋgim hainâk makmâ hâreyeŋgiwaen. Lâpio yeŋgât sumbe ombiâ ain gâtŋe sot bo nembi. Akto soŋgo mem hanŋe hâremai are akto soŋgo gilâmŋe hainâk bo nembi. Akto âmbâle mem hepun hepun bo akbi. Hainâk makmâ hâreyeŋgim kulem esenŋe kulemgom yeŋgiwaen.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hain dâmbo Aposolo akto tiksalupyeŋande luâk kâmot humo menduguyekmâ, “Luâk nengâlân gâtŋe lâuwâ meyelekbaen.” dâm makyeŋgimbiâ Yesugât kâmot bikŋande nâŋgâmbiâ ârândâŋ agep. Akto luâk siâ kotŋe Yudasi kotŋe siâ Basaba akto luâk siâ aregât kotŋe Sila are meyelekmâ okot âlep nâŋgâ yetkiyi. Luâk lâuwâ arekŋe Paulo akto Banaba olop Antiokia kepian ariŋet dâm kulem esenŋe kulemgowerâm agi. ");
INSERT INTO tim_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Akto kulem esenŋe siâ are hin dâm kulemgom yetkiyi, “O galalupnenŋe, Aposolo akto Yesugât kâmotlupŋe yâk yeŋgât tiksalupyeŋande Antiokia, Siria akto Kilikia Yuda bo manmai yeŋe biwiyeŋe Yesugâlân katmâ mandâi aregât okot âlep akmâ kulem esenŋe ire kulemgom katyeŋgien. ");
INSERT INTO tim_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nenŋe bo nâŋgâenŋe aregât nengâlânba bikŋande yeŋgâlân togom den makyeŋgimbiâ nâŋgâm hanyeŋe lâuwâ agep. Are âmâ luâk are yeŋe hanyeŋân agi. Nenŋe bo huŋgun yeŋgiyion. ");
INSERT INTO tim_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Aregât âmâ nenŋe hannenŋe konok akmâ mendugum kinmâ galalogâtnenŋe Banaba akto Paulo yâk olop ariet dâm huŋgun yetkien. ");
INSERT INTO tim_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paulo akto Banaba yâkŋe Yesu Humo Anutuŋe huŋgun aŋdo giep yâkgât hoŋ bawa manmâ hâk hilâlâm kakŋân arimbela yetkumbiâ bâsok moyiat. ");
INSERT INTO tim_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Akto luâk meyelekten ire yetgât kotyetŋe âmâ Yudasi akto Sila yâk olop togowerâm aregât yâkŋe kulem esenŋe ire keiŋe makmâ miawakbela nâŋgâwai. ");
INSERT INTO tim_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Akto Anutugât Heakŋaet nâŋgâ nâŋgâŋe akto nengât nâŋgâ nâŋgânenŋe dop konogâk yendâp aregât umatŋe siâ me siâ aregât bo maktenŋe miawakbiap. Hin akbiâ ârândâŋ akbiâp. ");
INSERT INTO tim_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Lâpio yeŋgât sumbe omberâm sot wan katbiâ are bo nembi. Akto soŋgo hanŋe hâremai are akto soŋgo gilâmŋe hainâk bo nembi. Akto âmbâle mem hepun hepun bo akbi. Are bo akmâ âlepŋeâk manbiâ âmâ ârândâŋ akbiâp. Âlepŋeâk manbi. Den pat areâk.” Hain dâm kulemgom yeŋgim Antiokia kepian hekat yeŋgiŋet dâm huŋgun yeŋgimbiâ ariyi. ");
INSERT INTO tim_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ainba huŋgun yeŋgimbiâ kulem esenŋe are mem ariyi. Arim Antiokia kepian arim Yesugât kâmot mendugu yekmâ kulem esenŋe are yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Yeŋgimbiâ biwiyeŋe agalâk dâm den kulemgoyi are oyaŋmâ nâŋgâm heroŋe agi. ");
INSERT INTO tim_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasi akto Sila yâkŋe Anutugât keiŋe makmâ miawakminiat arekŋe biwiyeŋe Yesugâlânâk kilâk dâm den kârikŋe makyeŋgimbela biwiyeŋe heroŋe akmâ owâimbo yâk olop sop kâlep mali. ");
INSERT INTO tim_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Akto Yerusalem kepia arewa huŋgun yetkim yâk yeŋgâlân purik katmâ ariet dâm okot âlep kakŋân kinmâ huŋgun yetkiyi. ");
INSERT INTO tim_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Huŋgun yetkimbiâ arim Silaŋe âmâ lâuwâŋe bo manberân dâm Antiokia kepian talep akto Yudasi ikiŋak ariep. ");
INSERT INTO tim_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo akto Banaba yâkŋe Antiokia yeŋgâlân âi hokboâk mem maliat. Manbela galalupyetŋe olowâk Humogât den are makmâ makyeŋgim mali. ");
INSERT INTO tim_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Manmâ hilâm siân Pauloŋe Banaba hin dâm magaŋep, “Net ulikŋân arim kepiaŋe kepiaŋe manmâ Humogât den makyeŋgietŋe biwiyeŋe Yesugâlân kali are gain gain mandâi, are keiyeŋe ekmâ manbaet.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Hain dâmbo Banabaŋe “Mareko olop arine.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Are âmâ ulikŋân Mareko kotŋe siâ Yohane are emelâk yâk olowâk arim Pampilia hânân hepunyelekmâ purik kato yâk yetŋeâk Yesugât keiŋe makyeŋgim maliat. Aregât Pauloŋe Banabagât den are nâŋgâmbo ârândâŋ bo agep. ");
INSERT INTO tim_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ârândâŋ bo akto Paulo akto Banaba hanyetŋe konogâk bo agep aregât papalakmâ hepun agiat. Hepun akmâ Banabaŋe Yohane kotŋe siâ Mareko mendo ariyiat. Arimbela waŋgaŋe meyelekmâ Kipiro gimbâŋe haru tânâmŋân talep ain ariep. ");
INSERT INTO tim_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Dâ Pauloŋe âmâ Sila mendo Yesugât kâmotlupŋande Humo ulilaŋmâ damunyetŋe agâk dâm huŋgun yetkimbiâ ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Arim Siria akto Kilikia hânân manmâ Yesugât kâmot luâk âmbâle mali are yeŋgât biwiyeŋe mem kârikŋe ketugum han biwiyeŋe Yesugâlân katŋet dâm makyeŋgim maliat. ");
INSERT INTO tim_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo akto Sila yâkŋe Derebe akto Listera kepian ariyiat. Arim Listera kepian luâk siâ biwiŋe Yesugât katmâ malep, are mem miawagiat luâk aregât kotŋe Timoteo. Yâkgât memeŋe âmâ Yuda yeŋgâlân gâtŋe akto yâkâ hainâk biwiŋe Yesugâlân katmâ malep. Dâ eweŋe âmâ Girik luâk. ");
INSERT INTO tim_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listera akto Ikonioŋ kepia ambolupŋe bikŋe biwiyeŋe Yesugâlân kali arekŋe Timoteogât keiŋe Paulo magaŋmâ heroŋe maroŋe agi. ");
INSERT INTO tim_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo magaŋbiâ luâk are kewugumbo olop ariwerâm okot âlep agep. Akto Yuda luâk hân ain manmâ ariyi arekŋe Timoteogât eweŋe Girik luâk are nâŋgâm meteyi. Aregât Pauloŋe Timoteogât hâkŋe bo gâiyi aregât nâŋgâm Yuda luâk biwiyeŋe bâliwopdâm Timoteogât hâkŋe gâiep. ");
INSERT INTO tim_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Akto kepia ârândâŋ manmâ Aposolo akto Yesugât kâmot Yerusalem kepian mali areyeŋgât tiksalupyeŋande den kârikŋe magi are lokoŋet dâm Yesugât kâmot are makyeŋgim ariyi. ");
INSERT INTO tim_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hain akbiâ Yesugât kâmotŋe biwiyeŋe Yesugâlânâk kindo Anutugât den nâŋgâmâk mali. Hain akbiâ hilâmŋe hilâmŋe Yuda luâk bo manmai are yeŋgâlân gâtŋe bikŋe âkâ hainâk biwiyeŋe Yesugât katmâ yâk yeŋgâlân dewatimbiâ sambeleyi. ");
INSERT INTO tim_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Akto Asia hânân Yesugât keiŋe makyeŋgim ariwerâm akbiâ Anutugât Heakŋande dâp tigiyeŋgimbo Prigia akto Galatia hânân bam ariyi. ");
INSERT INTO tim_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Arim Misia hân ginŋânâk hâlâŋmâ ariyi. Arewa Bitinia hânân ariwerâm akbiâ Yesugât Heakŋande hanyeŋe mem pâlâmŋe ketugumbo hân aregen bo ariyi. ");
INSERT INTO tim_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hanyeŋe mem pâlâmŋe ketugumbo Misia hân are hepunmâ haru ginŋân kepia siâ talep are kotŋe Troa ain ariyi. ");
INSERT INTO tim_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Aregen arim manbiâ nâ Luka nâŋe penâyeŋgire emet dâgâmbo hândâkŋân Paulo biwiŋe owâimbo hin miawagaŋdo egep. Amâ Makedonia luâk siâŋe togo kinmâ ulilaŋmâ hin dâep, “Gâ Makedonia hânângen togo nen tân nenguwen.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Hain dâm makmâ metem arimbo emet hauŋdo Paulo luâk arekŋe miawagaŋep aregât hin dâyion, “Makedonia hânân arim Yesugât den pat âlepŋe are makyeŋgiwaen aregât Anutuŋe maknengiâp.” dâyion. Hain dâm magaŋgim kinmâ Makedonia hânân haru hâtikom ariwerâm dâpgât hâumgom kilion. ");
INSERT INTO tim_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kindenŋe waŋga siâŋe togom menenekmâ Troa kepia hepunmâ haru tânâmŋe târârâk arim Samotrake kepia haru tânâmŋân talep ain kat nenekto talion. Tatmâ yem kindenŋe hauŋdo arewa menenekmâ arim Neapoli kepian kat nenegep. ");
INSERT INTO tim_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kat nenekto arewa âgâm Pilipi kepian ariyion. Akto kepia are âmâ Roma luâkŋe ulikŋân hân amboŋe akmâ tali. Kepia are âmâ Makedonia hân aregât kepia kautŋe. Ain tatmâ mandenŋe hilâm amon siâ bo agep. ");
INSERT INTO tim_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Akto Sarereân kepia are ginŋân tu siâ talep ain gewerâm hin dâyion, “Yuda luâkŋe Humonenŋe ulilaŋmâ manmai yâk ain togomai me bo? Gem ekne.” hain dâm gem âmbâle bikŋe siânba mendugum tatbiâ are mem miawakyekmâ gem enemyeŋân tatmâ makyeŋgiyion. ");
INSERT INTO tim_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Makyeŋgienŋe âmâ Tiatira kepian gâtŋe âmbâle siâ Anutu humo nâŋgaŋmâ manminep, kotŋe Lidia arekŋe âmâ sâŋgum parutmâ mâŋot gilâm pulim âi are mem puli meminep. Akto Humoŋe âmbâle aregât biwiŋe mem agato ondopŋe katmâ Pauloŋe den magep are nâŋgâm ukenŋe akmâ den are mem biwiŋân katmâ heŋgemgoep. ");
INSERT INTO tim_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Akto âmbâle aregât lâulupŋe hârokŋe biwiyeŋe Yesugâlân katbiâ tu puli yeŋgiyion. Tu puli yeŋgienŋe âmbâle arekŋe hin magep, “Nâ mem Humogât pat kat nekbiâ nâŋgaŋdân aregât nâŋgâmbiâ ârândâŋ akto âmâ nâŋgât emelan âgâmbiâ nâ olop tatberen.” dâep. Hain dâmbo yâkgât emelan âgâyion. ");
INSERT INTO tim_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Hilâm siân gem welam siâ Anutu ulilaŋmini ain gem mandenŋe hoŋ bawa âmbâle kâmbokŋe siâŋe mem miawaknenegep. Akto sinduk baniara bâleŋande kautŋân mendo luâk yeŋgâlân arim hâmbâi wan me wan miawakbiap aregât makyeŋgiminep. Hain akto aregât puli waŋbiâ are mem arim damunlupŋe yeŋgim malep. ");
INSERT INTO tim_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Akto âmbâle kâmbokŋe arekŋe Paulo ekmâ hami nenŋânâk gam hin dâm kamboŋep, “Luâk irekŋe Anutu Humogât hoŋ bawa agaŋmâ manmai aregât Anutuŋe heŋgem nenguwiapgât dâp maknengiwerâm togoâi.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hain dâm hilâmŋe hilâmŋe kamboŋmâ haminenŋân gam mando aregât Pauloŋe hâkâŋ akmâ purik katmâ sinduk baniara are hin dâm magaŋep, “Nâŋe Yesu Humo Anutuŋe huŋgun aŋdo giep aregât den makgiŋdere nâŋgâ. Âmbâle are hepunmâ eke.” dâep. Hain dâmbo ainâk hepunmâ ariep. ");
INSERT INTO tim_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Hepunmâ arimbo âmbâle aregât damunlupŋande hin dâyi, “Sinduk baniara bâleŋande hepundâp aregât gain gain hâmbâigât pat makmâ miawak yeŋgiwiap? Hain bo akbiap are âmâ nengât puli bo akbiap.” dâm nâŋgâm bâliyi. Hain nâŋgâm Paulo akto Sila meyelekmâ kepia sombeim humoân arim ");
INSERT INTO tim_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Roma luâk yeŋgât kiap taliân meyelekmâ âgâm hâkyetŋe tunmâ hin dâm makyeŋgiyi, “Yuda luâk lâuwâ irekŋe kepianenŋân togom bo agakŋe are akŋet dâm maknengimbela den are nâŋgâm biwinenŋe bâlimbo kepianenŋe kukŋe agatâp. ");
INSERT INTO tim_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Akto agak meme irakŋe siâ Roma luâk nenŋe bo akmaen are akŋet dâm maknengim mandat.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Hain dâmbiâ luâk humo kili arekŋe kuk akmâ nâŋgâ yetkimbiâ kiaplupyeŋande sâŋgum yetŋe oloŋmâ hoŋ bawalupyeŋe makyeŋgimbiâ bugâŋe oreyelekmâ mem kala busi emet kâlegen kat yelekbiâ tatbela aregât damunŋe hin dâm magaŋi, ");
INSERT INTO tim_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","“Luâk lâuwâ ire ariwandatgât kei bâtyetŋe mem kârikŋe ketugum hiko yelekmâ damun kinben.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Hain dâm magaŋbiâ emet kârikŋe aregât bâiŋângen kat yelekmâ lâwin siâ hioŋmâ keiyetŋe kapiŋmâ hiko yelekto taliat. ");
INSERT INTO tim_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Akto hândâk tânâmŋân Paulo akto Silaŋe Anutu mepaiŋe kep keŋgu akmâ tatbela luâk bikŋe kala busi kâlegen kat yekbiâ tali arekŋe nâŋgâyi. ");
INSERT INTO tim_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Akto kep keŋgu are mem tatbela ainâk wâriŋ humo mendo emet are duwuŋ akto emet aregât hâŋgi hârok lewulagep. Lewulakmâ kindo luâk hârok kala busi kâlegen tali are yeŋgât tâk kârikŋe kotŋe sein are hulaŋ akmâ kiŋ pârândâŋ âgâm metiep. ");
INSERT INTO tim_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Akto emet aregât damun kilep arekŋe asiŋânba agatmâ ekto hâŋgi are hârok lewulakmâ kindo ekmâ hin dâep, “Wei, luâk bâleŋe iren kat yektenŋe tatâi ina hârok arim meteâi.” dâep. Hain dâm aregât hamep akmâ tiŋgiŋânba tâwât siâ mem oloŋmâ ikiŋe hanŋe hâreakberâm agep. ");
INSERT INTO tim_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Hain akto Pauloŋe hin dâm konmâ magaŋep, “Nen hârogâk yu kinden aregât hange bo hâreak.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hain dâmbo tembe loko arekŋe galalupŋe makyeŋgimbo kemdâ waŋbiâ kala busi kâlegen mem âgâm ongâŋe hogombo Paulo akto Sila yelekmâ hânân kâŋgom hin dâm makyetkiep, ");
INSERT INTO tim_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","“Agatbela arine.” dâmbo agatbela kewugu yelekmâ den hin makyetkiep, “Luâk lâuwâ nâ gain gain aktere Anutuŋe bo hilip nugumbo yâkgât pat akbian?” dâm makyetkiep. ");
INSERT INTO tim_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hain dâmbo hin dâm magaŋiat, “Biwige Yesu Humogâlân katmenâ Anutuŋe guge akto ginbailupge meyekbiap.” dâyiat. ");
INSERT INTO tim_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Hain dâm Humogât dengât keiŋe yâk akto ginbailupŋe makyeŋgimbela ");
INSERT INTO tim_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ainâk damun arekŋe meyelekmâ arim bugâ gewâkŋe diwi are puliyetkiep. Akto ikiŋe akto ginbailupŋe hârogâk tu puli yeŋgiyiat. Hain akbela Paulo akto Sila kewugu yelekmâ ariep. ");
INSERT INTO tim_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Arim ikiŋe emelan sot om yetkimbo neyiat. Ikiŋe akto ginbailupŋe hârok biwiyeŋe Yesugâlân katmâ Anutugât pat agigât biwiyeŋe âlepŋe agep. ");
INSERT INTO tim_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yem kinbiâ hauŋdo Roma luâk yeŋgât kiaplupyeŋande tembe loko hin dâm makyeŋgim huŋgun yeŋgiyi, “Ye arim luâk lâuwâ are tâk hulaŋmâ huŋgun yetkimbiâ ariet.” dâm tembe loko huŋgun yeŋgiyi. ");
INSERT INTO tim_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Akto damunŋe den nâŋgâm Paulo hin magaŋep, “Kiaplupnenŋande den katbiâ togoâp. Aregât huŋgun yetkienŋe biwiyetŋe sândugembo ariet.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Hain dâmbo Pauloŋe tembe loko are yekmâ hin dâm makyeŋgiep, “Net âmâ Roma luâk mandetgât yeŋe gain gaingât net denân kat nelekmâ bugâŋe orenelekmâ mem kala busi kâlegen kat nelegi? Dâ uŋak âmâ yoŋâk huŋgun netkiwerâm akbiâ bo ârândâŋ aktâp. Gârâmâ ye arim kiaplupyeŋe makyeŋgimbiâ yâk yeŋeak togom huŋgun netkimbiâ ariweret.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pauloŋe den hain dâmbo tembe lokoŋe purik katmâ kiapyeŋgâlân arim Pauloŋe den makyeŋgiep are makyeŋgim Paulo akto Sila yâk Roma luâk mandat dâm makyeŋgimbiâ nâŋgâm sân sân meyi. ");
INSERT INTO tim_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Sân sân mem ongâyeŋe hogombo arim den yeukŋe makyetkim kala busi kâlegenba kewugu yelekmâ kepia ginŋângen ge kinmâ huŋgun yetkimbiâ gem ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Akto kepia are hepunmâ gem Tiatira kepian arim Lidiagât emelan âgâm Yesugât kâmot ain tatbiâ yekmâ biwiyeŋe Yesugâlânâk kilâkgât den makyeŋgim gem ariyiat. ");
INSERT INTO tim_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo akto Sila kepia are hepunmâ Ampipoli akto Apolonia kepia ewangim Tesalonike kepian ariyiat. Ain âmâ Yuda yeŋgât den emetŋe siâ tatâp. ");
INSERT INTO tim_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ain arim Pauloŋe Yuda luâk yeŋgât den emetŋe kepiaŋe kepiaŋe talep ain âgâm den makyeŋgiminep aregât akmâ den emetŋân âgâm âmâ Anutugât den kulem esenŋe âlepŋe aregât keiŋe makyeŋgimbo sonda âlâwu bo agep. ");
INSERT INTO tim_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Yesugât keiŋe magaŋgi goaŋgi akbiâ aregât Pauloŋe hin dâm makyeŋgiep, “Beirâ Anutuŋe huŋgun aŋdo gem hâk hilâlâm nâŋgâm momoŋânba agatbiap aregât ulikŋân propete luâk mali are makyeŋgimbo kulemgoyi. Kulemgombiâ talep are Yesuŋe watmâ hâk hilâlâm nâŋgâep. Anutuŋe Yesu hin dâm huŋgunaŋep, “Gâ arim luâk âmbâle damunyeŋe akmâ tânyeŋguwen.” hain dâep are Yesugât.” dâep. ");
INSERT INTO tim_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pauloŋe hain dâm makyeŋgimbo luâk âmbâle bikŋande den are nâŋgâm tatmâ biwiyeŋe Yesugât katmâ Paulo akto Sila yâk yetgâlân dewatiyi. Akto Girik luâk Anutu ulilaŋmâ mali are dondâŋe hainâk biwiyeŋe Yesugâlân katmâ yâk yeŋgâlân dewatiyi. Akto luâk âmbâle kotdâ hainâk agi. ");
INSERT INTO tim_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Hain akbiâ benŋe Yuda luâk bikŋande are nâŋgâm biwiyeŋe bâlimbo dâwân arim luâk konam mem mendugu yekmâ kukgât hanyeŋân gembiâ kuk akmâ kepia are hanâk hanâk akbiâ kepia ambolupŋe âkâ hainâk kuk akbiâ kepia are kuk agalep. Kepia are kuk agato Yuda luâk akto kepia ambolupŋe bikŋande Yasoŋgât emelan Paulo akto Sila talialân ain mendugum tali. Mendugum tatmâ, “Paulo akto Sila meyelekmâ hutnenŋân kat yelektenŋe kilet.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hain dâm undâgât yetkimbiâ bo akto aregât kuk dâm Yasoŋ akto Yesugât kâmolân gâtŋe bikŋe meyekmâ humomolupyeŋe yeŋgâlân arim denân katyekmâ hin dâyi, “Luâk lâuwâ siâ kotyetŋe Paulo akto Sila yâkŋe hânŋe hânŋe manmâ luâk âmbâle den makyeŋgimbela han lâuwâ akmâ gulip manbiâ ârândâŋ bo aktâp. Akto uŋak nengâlân togombela Yasoŋŋe gala akyetkimbo olowâk mandâi. ");
INSERT INTO tim_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Akto humonenŋe Sisa aregât den kom luâk humo irakŋe kotŋe Yesu yâkgât den makbela nâŋgâm luâk ire meyekmâ togoen.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Hain dâmbiâ kepia ambolupŋe akto humomolupyeŋe arekŋe nâŋgâm sân sân mem den humo akmâ magaŋgi goaŋgi agi. ");
INSERT INTO tim_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Hain akbiâ humomolupyeŋande Yasoŋ akto galalupŋe hin makyeŋgiyi, “Puli katŋet. Puli katmâ uŋak aktâi ire lâuwâŋe hainâk bo akbiâ âmâ puli ire purik katmâ yeŋgiwaen. Dâ hainâk akbiâ âmâ puli ire bo yeŋgiwaen.” dâyi. Hain dâmbiâ puli katmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Akto hândâk ainâk Yesugât kâmotŋe Paulo akto Sila yoŋâk huŋgun yetkimbiâ Berea kepian ariyiat. Ain arim Yuda luâk yeŋgât den emetŋân âgâm Yesugât keiŋe makyeŋgiyiat. ");
INSERT INTO tim_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Akto kepia ain luâk âmbâle bikŋande emelâk biwiyeŋe owâiŋe akto mali arekŋe Tesalonike kepia ambolupŋe ewangiyegi. Hain aregât Paulo akto Silaŋe kinmâ Yesugât keiŋe makyeŋgimbela ondopyeŋe dowâk katmâ den are nâŋgâm heŋgemgoyi. Hain akmâ hilâmŋe hilâmŋe aregât magaŋgi goaŋgi akmâ Anutugât den kârikŋe ulikŋân kulemgoyi are oyaŋmâ nâŋgâyi, “Luâk Paulo yu kindâp irekŋe bunŋe me hiaŋgim maktâp.” dâm Anutugât kulem oyaŋmâ nâŋgâm heŋgemgom mali. ");
INSERT INTO tim_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Aregât yâk yeŋgâlân gâtŋe dondâŋe Yesugâlân biwiyeŋe kali. Akto Girik âmbâle humomolupyeŋe bikŋande hainâk agi. Akto Girik luâk bikŋande hainâk agi. ");
INSERT INTO tim_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Gârâmâ benŋe Pauloŋe Berea kepian arim Anutugât den makyeŋgim malep aregât den pat arimbo Yuda luâk bikŋande Tesalonike kepian mali arekŋe nâŋgâmbiâ bâliep. Nâŋgâmbiâ bâlimbo Berea kepian togom kinmâ kepia ambolupŋe hanyeŋân gembiâ kepia areâkâ hainâk kuk agi. ");
INSERT INTO tim_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hain akbiâ Yesugât kâmotŋe Paulo huŋgun aŋbiâ dowâk hepunyekmâ haru dâtŋân ariep. Dâ Sila akto Timoteo yâkŋe âmâ kepia ainâk maliat. ");
INSERT INTO tim_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Akto Yesugât kâmotŋe Paulo dâwân katberâm arim Ateŋ kepian katmâ purik katberâm akbiâ hin dâm makyeŋgiep, “Ye purik katmâ arim âmâ Sila akto Timoteo makyetkimbiâ dowâk Berea kepia hepunmâ togom penâniŋbiandat.” dâep. Hain dâm makyeŋgimbo hepunmâ purik katmâ ariyi. ");
INSERT INTO tim_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Akto Paulo Ateŋ kepian manmâ Sila akto Timoteo yâk yetgât lâmyetkum tatmâ hambo kotdâ keiŋe keiŋe hâwim katbiâ talep are ekmâ biwiŋe kâlâp agep. ");
INSERT INTO tim_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Haingât yâk yeŋgât den emetŋân âgâm Yuda luâk bikŋe akto Girik luâk bikŋe Anutugât keiŋe nâŋgâwerâm mali yâk olop tatmâ Yesugât keiŋe magaŋgi goaŋgi agi. Akto hilâmŋe hilâmŋe kepia sombeimân arim kinmâ luâk âmbâle gam ariyi are hainâk makyeŋgiep. ");
INSERT INTO tim_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Akto kepia ain luâk nâŋgâ nâŋgâyeŋe siâ siâ mali kotyeŋe Epikue luâk akto siâ Stoike luâk arekŋe Pauloŋe Yesu momoŋânba agalep aregât den pat magep aregât kakŋân magaŋgi goaŋgi agi. Akto bikŋande hin dâyi, “Luâk ire nâŋgâ nâŋgâŋe gulip akto den kotŋe hanâk hanâk are gain gain dâwerâm aktâp.” dâyi. Dâ bikŋande âmâ hin dâyi, “Luâk arekŋe kepia bikŋe bikŋe yeŋgât lâpio aregât den maktâp.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Hain dâm sombeim humo siâ kotŋe Areo ain oloŋmâ âgâm hin dâyi, “Gâŋe den irakŋe maktât are gain gaingât maktât? ");
INSERT INTO tim_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Den are uŋguŋân siâ bo nâŋgâyion aregât keiŋe maknengimenâ nâŋgâne.” dâyi. ");
INSERT INTO tim_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Amâ Ateŋ kepia ambolupŋe akto luâk bikŋande kâlewângenba togom mali yâkŋe den irakŋe miawagep dâm aregât magaŋgi goaŋgi akmâ nâŋgâmbiâ humo akminep aregât akmâ Paulo oloŋmâ hain aikoyi. ");
INSERT INTO tim_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Hain dâmbiâ Pauloŋe Areo sombeimân dewunyeŋân agatmâ kinmâ hin dâm makyeŋgiep, “Ateŋ kepia ambolupŋe yeŋgât keiyeŋe hin nâŋgân. Ye lâpio keiŋe keiŋe yeŋgât hoŋ bawa akmai. ");
INSERT INTO tim_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nâ kepia yeŋân togom kepia ândeaŋmâ arim togom âmâ yeŋgât lâpiolupyeŋe sambe are yekmâ âmâ lâpio siâgât welamŋe ekmâ âmâ den kulemgombiâ tatâp are oyaŋdân, “Humo yeŋe siâgât nen bo nâŋgâmaen yâkgât welamŋe ire.” oyaŋdân aregât ye nâŋgâm hilipkom yâkgât hoŋ bawa manberâm akmai aregât keiŋe makyeŋgire nâŋgâŋet. ");
INSERT INTO tim_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Kotŋe âmâ Anutu. Anutuŋe âmâ hân himbim haru are mem miawakmâ aregât kâlegen wan me wan keiŋe keiŋe katmâ metiep. Yâkŋe âmâ hân himbim akto haru amboŋe aktâp aregât den emetŋe ketugumai ain bo manmap. Bo. ");
INSERT INTO tim_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Akto wan me wan hârok manmanyeŋe me heakyeŋe yeŋgimap aregât luâk siâŋe âi ketugu aŋgimapgât dop bo talaŋdâp. Amâ yâkŋe âmâ siâ me siâgât umburuk bo manmap. ");
INSERT INTO tim_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Akto keiŋe katmâ ulikŋân yâkŋe luâk konok siâ are ketugumbo yâkgâlânba luâk keiŋe keiŋe miawakmâ Anutugât den lokom sambelem potalakmâ ariyion. Akto arim tatberâm aktenŋe sop aregât dop katmâ aregât hân horatŋe makmâ nengiep. ");
INSERT INTO tim_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Akto biwinenŋe kepik akto âmâ Anutuŋe, “Nâŋgâlân togom nâŋgâ niŋŋe