﻿USE sofia;
DROP TABLE IF EXISTS sofia.tif_vpl;
CREATE TABLE tif_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tif_vpl WRITE;
INSERT INTO tif_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus ami awil-fakal win namti kaldak bombe kemin, Yesus ali King Devit ami man loop ale; Devit ata Abraham ami man loop kelin kemin. ");
INSERT INTO tif_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ali Aisak ami aalap ale; Aisak ali Jekop ami aalap ale; Jekop ali Juda so almi kiim anung maakup nikil imi aalap kesa. ");
INSERT INTO tif_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kemin, Juda ali Peres so, Sera so, awaang man imi aalap ale; Tama uli awaang man alep imi awak ko. Ale, Peres kaali, Hesron ami aalap kesa; Hesron ali Ram ami aalap. ");
INSERT INTO tif_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Yak Ram kaali, Aminadap ami aalap kesa; Aminadap kaata, Nason ami aalap. Nason ali Salmon ami aalap. ");
INSERT INTO tif_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon kaali, Boas ami aalap ale; Rahap uta Boas almi awak aa, Boas ali Obet ami aalap, mep Rut kuuta Obet ami awak; kanolin kemin, Obet kaali, Jesi ami aalap kesa. Ale, ");
INSERT INTO tif_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi kaali, King Devit ami aalap kesa. Kemin, King Devit kaali, Solomon ami aalap kesale, Baseba uta Solomon ami awak namti kabuu. Yak kamasi kaali, Baseba kuuli, tunum kusnum Uria ami kalel; la ilom ale, kulaali, King Devit ata kuluulaya ami kalel kesu no. ");
INSERT INTO tif_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ayo Rehoboam ami aalap kesa; Rehoboam kaali, Abiya ami aalap; Abiya kaali Asa ami aalap. ");
INSERT INTO tif_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kaali, Jehosafat ami aalap ale; Jehosafat ali Joram ami aalap. Joram ali Usia ami aalap ale, ");
INSERT INTO tif_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia kaa Jotam ami aalap ale; Jotam kaa Ahas ami aalap ale; Ahas ali Hesekia ami aalap. ");
INSERT INTO tif_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia kaa Manase ami aalap: Manase kaali, Amos ami aalap; Amos kaali, Josaya ami aalap. ");
INSERT INTO tif_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya kaali, Jekonia so almi ilem anung maakup nikil imi aalap kesip. Kemin, Jekonia asole, almi muuk maakup inin so, nikil kiili bom-biliwa, Israel tunum imi waasi Babilon kayaak tunum iyo, baa tal Israel-miin yemum o, kalalip baa tal daalip din-bomdipla, Babilon ita ita ke Israel-miin iyo kabaak baniwa, fuku tibii sok de-yim-tama bilin Babilon ilmi abip ma ma kaptam daa-daa-kemsip ko. ");
INSERT INTO tif_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kanola, Babilon kasel ili Israel-miin imi sok de-yimu imbilin ilmi abip tiiliwa, Jekonia ayo Sealtiel ayo duulaya, Sealtiel ayo Serubabel ami aalap kelale; ");
INSERT INTO tif_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel kaali, Abiut ami aalap kelale; Abiut kaata, Eliakim ami aalap; Eliakim ali Aso ami aalap. ");
INSERT INTO tif_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso kaali, Sadok ami aalap; Sadok kaata, Akim ami aalap; Akim kaali, Eliut ami aalap; ");
INSERT INTO tif_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut kaata, Eleasa ami aalap kesa; Eleasa kaali, Matan ami aalap; Matan kaali, Jekop akal alik awasekim ami aalap. ");
INSERT INTO tif_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop kaali, Josep ami aalap; Josep ami kalel Maria uta Yesus kaa duusu. Kemin, Yesus kaali, God ata uldaa-dabuula tiltam Kamokim kesa tunum Kraist o, akan-kaan-umbip kaata ko. ");
INSERT INTO tif_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham ami loop tap-tiisa kaali, man loop ayo tiila yak aba umbital Devit ami diim kuyaku dilit kalasuu kaalile, man loop tap-tiimin almi-kup tal aba tam mitkal kemin, ulultap, kanola Devit ami loop tap-tiise kaakal man loop tiila yak aba toop Babilon kasel imi tilsip kuyaku ditang kalasuu kaa man loop tap-tiimin ulmi-kup tal aba tam mitkal kaltoop ata ukosu. Kemin, Babilon kayaak ita taba Israel-miin imi waasi keyinsip. Kemin, iyo tal sok iluu imbi bilin Babilon ilmi abip ma ma kawu yim-tiibi keyiliwa, bom-biisip ulultap kemin, abip Babilon unsip kaali, kabaku man loop tiptin yakyak umbital God ami uldaa-dabuula tiltam Kamokim kesa tunum Kraist ami duusu diim kuyaku dilit kalsu kaali, man loop ukamin ulmi-kup tal aba tam mitkal uku no, kesu ko. ");
INSERT INTO tif_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kamosinim Yesus Kraist duusu namti kalano-som ko. Awak Maria kuuli, Josep ami weng-kup baaliwa bombu. La, atin kuluu kuyak tabep mola uso bomdip sin-yaamakin disa; bom-iliple, kulaa God ami Sinik Tambal ayo tal Maria umi iipyak tem unaya, ukol utamu yi, Kaa kumunbi kala kalale, ");
INSERT INTO tif_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","umi imak Josep kayi kala weng tik-daanbip ayo, ti tunum tambalim kemin, ayo mep weng kaluuta boko ku-fatap-daalila, alik iyo weng saniwale, Maria uyo suu duk-duulamu no, kala duluuma ilomdi bamyaal tap unang kuu kewon i! ");
INSERT INTO tif_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","kalala, kanolin aket kaata fuku-daka-bam ilale, Dukum ami ensel ma dabaala tal lom dulun weng bokola ko: Devit ami man loop Josep kapyo, kapni kalel o, kala weng baap-ta-silip Maria uyo man so kebu te! Katale, man mat tem kabak bombe kaali, God ami Sinik Tangbal alta tal umi iipyak tem unala kumun so kebu. Kemin, kabi suunin disa; kalel uyo kuluulan aa! ");
INSERT INTO tif_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bom bii man kaa duulokomu kaata, almi unang tunum alik imi kukup mafak uyo takan-tiiyila yak banula, yim-buulokoma. Kabi ami win kaa bokola-lomdap ata dong dokoyilala yim-buu-laamin tunum o, kala-lomdap Yesus o, akan o, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Siin sawaayak kaptoowu Dukum ayo almi weng ku-fatap-dakamin tunum profet o, kala-laabip Aisaya ami weng ma bokolaya ata God ami Sukon Tem kabaku dolsa namti kulu tituun-kup tiltam tabasu. ");
INSERT INTO tif_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kemin, sawaayak kaali boko-lomda: Ti kaa utamin! Bii am ma daanula unang ma, tunum so ma sin-laamin disa, bom-ilomdula kawu, man kum-alomdu man tunum kemin, man duulokomu kaami win kaa Emanuel o, akokomip o, kalala kanum bokosa. Kemin, win kabak-ami miit kaali, God ayo nuso bombe no, kalsu ko. ");
INSERT INTO tif_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kemin, Josep ayo akan-bom ilala, Kamokim ami ensel ami lom dulun weng bokola kaata, weng san-somdala, dakela tam-tiin yak kalel uyo kuluula katale, ");
INSERT INTO tif_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kalel uso ma sin-laamin dinim, bom-ilom man ayo duluula, Josep ayo man ami win ayo bokola-lom: Yesus o, ansa ko. ");
INSERT INTO tif_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herot ayo Provins Judiya kaptam-ami kamokim king ke-bom biisa diim kawu, Maria uyo Yesus ali Provins Judiya umi abip Betleam kawu duulula bom-ilale, wakalkan uta utamsip tunum malo ma atan talebu lo kasel imi kukuya yakyak umbital Jerusalam tal abale, bokolip ko: ");
INSERT INTO tif_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kipyo, kama man ma duulu tiltam Juda imi kamokim keba kaa doku bombe ni? Nuli atan tiltam tabebu kawu bom-ilupla, wakalkan ta ami duulu bombe kaayo, kukuyila yakyak tala-bulu, talabup o. Uyo utamdupya tal fet dola ami fiyaap ayo duumum o, kalalupla tulup o, yikiwa, ");
INSERT INTO tif_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herot ayo kamokim king kusnum ami sang uyo weng san-ilomda kaata taba, Nami abiin ayo kuluulokoma nema yo? kala-lomda aket yaapkan fukun-balale, kuno Jerusalam kaptam kayaak alik yakal ti aket yaapkan fukun-bala kemip. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herot ayo taba tunum awem imi kamok kamok sole, Juda imi lo utamsip tunum iso, iyo alik afeta yim-tiile, dik-daaya: Kipni God ami uldaa-dabuula tiltam Kamokim ke-lokoma tunum kaami fen-tabasip kaali, doku duulokomu? yakale, ");
INSERT INTO tif_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","bokolip: I! Provins Judiya kaltam-ami abip katip ma Betleam kawu duulokomu kayi! Kemin, siin sawaayak kaptoowu God ami weng ku-fatap-dakamin tunum profet ma asiik taba ami sang kaa dola kutii boko-lomda: ");
INSERT INTO tif_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betleam kasel aa! ibi Judiya bokon kala bom-bilip kemin, ilom kaali, kipni tunum ma ata tiltam kamokim ke-lomda nami unang tunum Israel kii alik tiin molokoma. Kemin, kanolaya Betleam kayaak kipta win so ke-lomdip Judiya kayaak kusnum ita kabaak banip keyokomip kayi! kalalaya dolsa no, kala kanum bokolip ko. ");
INSERT INTO tif_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot ayo weng san-somdaya, ayo utamsip tunum tilip iyo maak lo sawaanin weng kuyila, tal atamiple, dik-daayila ko: Kibi kamasi kaali, dok kanumin diim kawu wakalkan kuu tiltam tamalu utamdipla, ibi man ma duubu kalaliwa dikiwa tal-bilip bii kayoop kaa kanim kal ma duk-duulip bital tilip i? Yakale, isiik maan tela bokoliwa, ");
INSERT INTO tif_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ayo bokola: Ibi Betleam uyo din ilomdip man kaali, talalu fen-tal-une-bamdip atamip namti, weng kulii-tal bokop-niwa, nakal din-ilomdi ami fiyaap uyo duu-bam ale, fet ayo dolon o, kal-bomda kasen-fakaya ko. ");
INSERT INTO tif_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kulaa, nikil iyo King ami weng uyo weng sandiwa, kulaa kambola ti kamasi atan tiltam talemin lo kawu bom-bilipla, wakalkan tiltam molu utam-silip usiik dusiin daa-lom una-bulule, ita mafiing tem kaltoowu utam-utam una-bilip bii wakalkan uyo yakaba bilin man ami am bombe umi dubim diim kutamu tolnula, ");
INSERT INTO tif_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tilin daa wakalkan uyo utam ale, fiyaap duulip ko. ");
INSERT INTO tif_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kemin, nikil am tam uliwa yi, Man so, awak Maria so, awaat iyo bom-bilip kala kalale, tam itamiple, kamok kamok imi weng umkaayin kaa kanumin kemin, imi katuun duung ayo fakela daak tiin dabuuna man ami fiyaap dukum ayo disa akal ma ke-bam fiyaap duu-bam, fet-dakaan-bamdip ilmi men tem mafek mafek tangbal tangbal abu kulii-tilip kaayo, man ami kola kola ke-bam ale, tuum gol sole, as dan kuyak daalip kiin-taba tang tambal tabemin ma kaaso, yak ok tang tangbal tabemin so, uyo kuluu man ami kukaalip ko. ");
INSERT INTO tif_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kemin, God ali mep tunum kiimi lom dulun weng tildaak bokoya-lomda: Ibi asuk din Herot kaa atam-laamin disa yo, yakala, kulaali fan kulaa kela liip kusnum abalip ilmi abip unip ko. ");
INSERT INTO tif_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tambaniwa kulaa, God ami ensel ma tildaak Josep ami lom dulun weng bokola ko: Kapyo, Herot ayo tal man kulaa fen-tal-bomdi atam aalon o, kala-somda fen-tal-une-mokoma. Kemin, baan kawang-alap abil yak man awaat kiili, foko kulii waka-daalap umbilin Isip kawu bom-biliwa, bombii asuk nalta maso ma bokop-tolon o, akaya, fan kulaali, ");
INSERT INTO tif_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep ayo kutamiip kuyaku abiltap tam tiin man awaat iyo foko kuliila, ");
INSERT INTO tif_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","umbilin Isip kawu bom-balaya bii, Herot ayo taana kawu, kulaata asuk foko kuliila tala ko. Siin sawaayak kawu, God ayo boko-lomda: Nami Man tunum ayo Isip bokon kawu bom-balaya bii, nalta naan-daaliya asuk talak kalalaya, God ayo almi profet ma ami bokolaya, ata unang tunum imi bokoyale, kuno Sukon Tem uyo dola kutii kesa. Kemin, Yesus so, awak Maria so, Josep alimal kiimi am bokon Isip kela tilsip kaami sang kaata, dolsa namti kulu duuk-kup dakat tiltam talsuu ko. ");
INSERT INTO tif_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kanola Josep alimal iyo din Isip kawu bom-biliwa, Herot ayo utama yi, Utamsip tunum iyo kasen-fokop-na-lomdip asuk weng uyo kulii-tal bokop-na-lomdip kawu, unin disa kebip o, kala-lomda, aket atul kelula, Herot ayo almi kamasi utamsip tunum imi dik-daa bokoya-lomda: Dok kanumin diim kawu, man kaa duulu wakalkan kuu tiltam tamalula utam-silip yoko? yakala, iyo bokola-silip umi aket kabak-ata-kup fuku-daa-lomda: Awu, man kulaa ti, kayoop kunolin kal dakan-tiila kulaali ti tiltam fasula kala kalale, almi tunum iyo yim-baala din abip Betleam kaptam asole, kaptam-ami abip mep mep so, uyo din aba tal une-bamdip, man tunum man unaak so man katip katip so, imulip wasital alep dakan-tii-bala ital alep dakan-tiilin disa bom-bilip iso, kebip iyo alik an-tal-unemip ko. ");
INSERT INTO tif_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Abip Rama kaa Betleam kaptam-ami mepso kulu bombuu kemin, sawaayak kawu God almi profet Jeremaya ami weng ma bokolaya ata abip kaptam-ami sang boko-lomda: Rama kayaak kaptam-ali aket uluum dukum tabeyila-buluya, dukum-kup aman duluum-biliwa, alik weng sanip. Kemin, unang Resel umi man loop o, kala Israel-miin iyo ilmi man kalan kaa, ama-bilipla, ap-tunum kusal iyo dong dokoyup iyo asuk tiltam fiyaap duumik o, kalip. Katale, numi man kii disa kebip o, kalaliwa, abiltap-siik aman duluumin uyo disa ke-laamin disa; man kiimi tibi dooban uta ukdaa bomdiwa amabip o, kalsu. Kemin, Herot ami tunum fokola din man yan-tal-unemsip kaami sang kaata bokosa namti kulu fan tiltam tabasu ko. ");
INSERT INTO tif_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kemin, Josep alimal iyo Isip bokon kawu bom-bilipya, Herot ayo bombii taanaya kulaali, Dukum ami ensel ma tildaak Josep ami lom dulun weng bokola ko: ");
INSERT INTO tif_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kapyo, tunum kaami tam-taba man unaak kaa aalila, taanak o, kemsa tunum ayo taanba. Kemin, kulaa kela man awaat iyo foko kuliilap yak aba umbilin Israel bokon kawu unin o, akaya kulaali, ");
INSERT INTO tif_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep ayo tam tiin-ilom man awaat iyo foko kuliila Israel bokon una. Lale, ");
INSERT INTO tif_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herot ami man Akelaus asiik tiltam aalap ami abiin uyo kuluu-lomda Provins Judiya kayaak imi kamokim king kela bomdala be no, kalip weng san-ilomda suun daa-lom Provins Judiya unon o, kalba uyo kela. Lale, God ayo asuk lom dulun weng tildaak Josep ami bokolala: ");
INSERT INTO tif_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Alimal yak aba umbilin Provins Galili, Nasaret abip kawu ilipla yo. Sawaayak kawu profet ita God ami uldaa-dabuula tiltam Kamokim kesa tunum ami sang uyo bokoya-lomdip: Bombii kaali, ami win kaa Nasaret kayaak o, akokomip kayi! kalsip namti kulu fan tiltam talsuu ko. ");
INSERT INTO tif_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yesus aso, awak-aalap so, alimal ili kawu laabipla bombii, man ayo tal aba tam fasu tunum aalap dukum kelale, kulu oksam ukayin tunum Jon ayo tal Provins Judiya kaptam-ami tunum dinim bokon kawu bom-balala, unang tunum iyo tal-tal ke-bilipla, God ami weng uyo bakayim-bamda bokola: ");
INSERT INTO tif_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","God ami unang tunum imbii tam almi abip daa tiin molokoma kaali, mepso tulu, kemin (ibi God kaa numi ban-wakan-umbup uyo yam-kukulokoma kayu,) kipni ban ayo kulaa kela aket fanang uyo fal-sikiliwa yo, kal-bomda bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Siin sawaayak sawaayak kawu profet Aisaya ayo Jon ami sang kalaa Sukon Tem kabaku dolale bokola: Tunum ma, tunum dinim bokon kawu, naan-bamda bokola ko: Liip tambal ma talalmiwa, Kamokim ayo baan abiltap-kup talak o, kalala naanba kayi! kala Aisaya ata kanum boko dola kuyinsa. (Kemin, kabak-ami miit kaali, unang tunum kipni aket fanang ayo fal-siki talal-bam dota-silipla, Yesus ayo talak o, kala-lomdu kanum bokosu) no. ");
INSERT INTO tif_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ali (sawaayak profet o, kala God ami weng ku-fatap-daa bakayin tunum Elaija ami kukup kanumsa ultap kaata kuluu-lomda) ali ilim tambal kaa mikimsa disa; ami ilim mafak kaali, taloop kamel o kala-laabip umi kon kaata, bakelip mikilale, kang kau umi ipnaal uta ukduu ol tiil o kala dotu kutii, kuyang diila nek molule, ima waan tangbal uyo falala le, kupluum so, as tem umi mumu wok so, kiita-kup in-bom biisa. ");
INSERT INTO tif_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Unang tunum yaapkan abip dukum Jerusalam ilin isole, Provins Judiya bokon alik kaptam-ami abip ma ma bom ilin iso, Ok Jodan balang diim ilin iso, iyo tal Jon ami weng kaata weng san-kaamum o, kalalipla, ");
INSERT INTO tif_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","tala-tala-ke Jon ami weng ayo weng san-kaa-bamdip, imi aket uyo fal-kela-lomdip le, God so, unang tunum so, imi tiin diim kawu ilmi ban kemin uyo ku-fatap-daka-bam ke-bilipla, Jon ayo taba imbii daak Ok Jodan kumun tem im-baak daa oksam wakaya ko. ");
INSERT INTO tif_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juda imi kamok kamok Falosi so, Sadusi yaapkan so, iyo tal Jon ata numi oksam ukayilak o, kalalip ami fanang tal-tal kebip. Lale, Jon ali utamala, Imi aket kaa fal-sikilin disa ke-lomdip tilip kala, kala-lomda, itam bokoyila ko: God ata taba-lomda kipni kukup mafak kaami kalan kaata, yam-mafak fuulokoma. Kemin, ibi kanta bokoyipla, ipkal aket fukun-daa-lomdipla, Din Jon atamup ami oksam ukuyokoma kaata, fan God ami aket atul kuyokoma uyo uktayokomu te! kalalip tale-bam ale, ibi inap imi tikiin kiin-bala, suun daa-lom ukadaa sak funbi unebip ililtap kelipla, nami fanang tale-bam kebip yoko? Katale, kaali, ibi uktayokomu disa yo. ");
INSERT INTO tif_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ti kukup tambal kaata ti kanu-bilipla, kabak-ali utamila, kipni aket fal-siki-lomdip ipni kukup mafak kaa, kulaabip kala kalon o. ");
INSERT INTO tif_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ibi nami weng kala bokoyokomi kaali, weng san iliwa, ibi Nuli ti Abraham ami man loop kemin uktayokomu no, kala-lom fiyaap duubip. Lale, God ata tuum kalawiili fal-sikila tiltam Abraham ami man loop ke-lomdipla, ipni abiin uyo kuluulamip kemin, ibi dotu utamdiwa! ");
INSERT INTO tif_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kemin, God ayo as miit tem kawu kaabaak ma kutii-lomda as ayo duulmon o keba. Kemin, as alik ibi dok kanolin kiita, as lap tambal ma abuulin disa kesip namti, duula-lom as kuyak daala kiin-taba unokomu no. Kemin ultap o, ipkal kukup tambal kaali, tabuulin dinim ke-lokomip kaali, God ata taba-lomda yam-kan tiilokoma no. ");
INSERT INTO tif_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kipni tunum talokoma no, kal-bom fenbip kaa, nita disa; kemin, kaali nasiik tilila, akal mulo kawu nami daang tem kawu talokoma. Kemin, ali kamokim dukum ke ata ata kela, nali kulaak banila, ata tam banin kala-somdiya fatom kep-nambu. Kemin, nali ti fan tunum kemin, nali taang-kalali yang ami miit tem kaa yang ilomdi ami yaan ilom kaa kulii-unomi dinim o. Ibi aket fal-sikilip kulaali, nali disa ok kulaata-kup kuluu-lomdi oksam ukayimbi. Nali disa ok kulaata-kup oksam ukayimbi. Katale, tunum kaa talokoma kaami almi Sinik Tambal ata dabaala taba-lomda kipni iipyak tem aket mafak fanang mafak dakabip uyo, as kuyak daala kiin abamnula, alik ibi tambal ke-lokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yak tunum imi yeng kuluu-lomdip wiit o kalalip kaali, bobi kutal tii-lomdip talal-bilip bii, umi ipnaal ayo takan-tii-lomdip wiit tiil ata-kup, kuu am tiile, ipnaal kaata-kup abul-daalip kiin-tabemin o. Kemin, ultap o; tunum kaa talokoma kaa tunum unang ami lak duusip iyo afeta yim-tii foko kutam almi abip tiiba-kup, ale yak tunum unang ami lak duulin disa ita, atin ti as kiinin-kup ilin ten-yaamin disa; ti kano kiinin-kup ilin kaami tem kabaaku abul-daala kiin-bam ilokomip o, kala bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jon ayo kanu-bamda bom-balaya kulaali, Yesus ayo Provins Galili uyo kulaa kambola din Jodan dal din atamiya, Jon ayo oksam ukop-nak o, kalala din atamala, ");
INSERT INTO tif_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon ayo bokoliya oksam woko-laamin kaayo kambolak o, kala-lomda bokolala: Yi, kabi God ali uldaa-tam-buula tiltam Kamokim kesap tunum ale, nita atin tunum kemin, nali oksam kaa ukop-tokomi disa; kapta taba-lom nami oksam okop-nan o. Kanimin o, kalalapla bokop-na-lomdap: Oksam ukop-nan o, kalbap i? akale, ");
INSERT INTO tif_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus asiik bokola: Nak-tunum kapyo, kabi nali oksam ukop-nokomap kaali, God ami weng kuka-daasa uyo tiltam tituun-kup ke-lokomu kalalila kemin, umi fanang kaata tili. Kemin, kapyo oksam ukop-nan o, kalala, Jon ayo fan, weng san-ilomda, Ayo, kala yak oksam ukola ko. ");
INSERT INTO tif_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon ayo taba Yesus ami oksam ukola kem-salale, maak fak-daalin tap Yesus ayo ok tem kambola tiltam aba abiil tikiin uyo tem kalulu titam daalaya, God ami Sinik ayo awon Abim tap kela tildaak nami diim ayo abamna kala, kala-somdala, ");
INSERT INTO tif_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","alep iyo weng seliwa yi! abiil tikiin lo kawu, God ami weng ma tal bokolu kabak-ali boko-lomdu: Mep kaali ti nalmi Man aket-iip kemin, nami aket fanang uyo nali ami fiyaap-kup duubi no, kala bokoya weng sanip ko. ");
INSERT INTO tif_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jon ayo oksam ukola disa kelule, mulo kawu God ami Sinik ata Yesus ayo dibiila bilin unang tunum dinim bokon kawu dip-din daalaya, Tunum Mafak Setaan o kala-laabip ayo tal Yesus ami dap-kukulak o, kala dibii una. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus ayo ima kaa inam-nomi dinim o, kala kela bomdala, bii am sin-yaamin almi-kup 40 kiita disa kelala, Yesus ali ima tinap bom-balaya, ");
INSERT INTO tif_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","kulaali, Setaan ayo talaba-lomda bokola ko: Kabi fan God ami Man o, kalap namti, daak tuum kalawiili kuluu fal-sikilap ima bret kelula inamnap, titam-somdi, Awu, kabi fan God almi Man tituun kala tokon o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesus ayo asiik maan tela ko: Daa, God ami Sukon Tem kabak-ali boko-lomdu: Ima bret kulaami inam-nokomap kulaali, tiil umi kup ifamin ale, kaali kapni aket fukunin kabak dong dokop-tokomu disa; kabi God ami weng uta alik weng san kutal-fukulokomap kaata, fan kapni aket fukunin uyo dong dokop-tokomu no, kalsu. Kemin, kaa kano-lomdila ima bret kaa, inam-nokomi dinim o, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kanum bokolale, Setaan ayo Yesus dap-tamala ti umbitam Abip Tangbal Dukum Jerusalam o kala-laabip daale, dibii tam lotu am awak dukum win sokan kaami liip kutal-fuku umbitam asal am desip umi dubim diim daale, bokola ko: ");
INSERT INTO tif_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kabi tifan God ami Man namti, mafek mafek ma kaata taba-lomdu telokomu dinim; kemin, asal kalawu uunfoko umbalaak tawaal diim abamnan aa! akale God ami Sukon Tem kabak boko-lomdu: God almi ensel imi bokoyilala, tal tiin-molipya, kabi telokomu disa yo, kala-somale, ma kaata boko-lom: Ensel ilta iip kawu, tim-tal fuku tam-fukulokomip. Kemin, tuum daang inang ayo ma ata taba-lomdu kapni yaan kaa, lop-tokomu disa yo, kala-som kesu. Kemin, kabi weng san-ilomdap uunfoko daak tawaal diim abamnawa, unang tunum kabaak bom-bilip iyo titamiwa yi, Awu, fan kabi God almi Man o, tokolip o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","kulaali, Yesus asiik bokola: Daa yo! God ami Sukon Tem weng ma uyo boko-lomdu: Dukum kaali, kapni God kemin, kaa dap-kuku-bam boko-lomdap: God kabi ti nami weng bokop-ti kaata-kup, weng sandap kanolawa, kayak kayak iyo utamiwa, U, God kabi, nami aket kaata duu-bomdawa, dong dakaap-nambap kala tiki no, kemin daa yo, kalsu te! kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kanum bokolala, Setaan ayo Yesus dap-tamala umbitam amdu fiil diim tam kabale, yak tawaal alik kala bombe umi tunum miit kusnum kusnum kiiso, yak unang tunum imi mafek mafek talalusip iso, iyo kukola utamale, ");
INSERT INTO tif_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","bokola ko: Kabi nalmi tibi diim kulu katuun duung fekela daak tiin-ilomdap bokopna-lom: Kabi nalmi kamokim o, kalap namti, nayo tawaal kalawaaso, tunum miit kaaso, mafek mafek iso, alik iyo kup-tila kapta tiin molokomap o, akale, ");
INSERT INTO tif_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesus asiik bokola ko: Setaan kapyo, kambop-nalalap tabanan o. God ami Sukon Tem kabak-ali boko-lomdu: God maakup ata-kup kapni tunum Dukum kemin, kabi katuun duung fakela-lomdap, ami win kaata-kup kufon-bam ale, ami weng kaata-kup weng san-kaaman o, kalsu. Kemin, nali katuun duung fekela daak kapni win kufop-tokomi disa te! aka ko. ");
INSERT INTO tif_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Setaan ayo kanum bokola weng san-somdala kulu dap-kukumin uyo kambola tabanale, ensel iyo tal Yesus dong dokola tiin-mo-bomdip ima kulela talemip ko. ");
INSERT INTO tif_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesus ami bilin saak disanang kawu laaba uyo, kulaa kelala umbital Provins Judiya kawu bom-balaya, Herot ami soldiya iyo Jon ayo dap-tal fuku dibii din kalabus am daalip bom-balaya, Yesus ayo Jon ami sang ayo weng san-somdala, Provins Judiya uyo kulaa kelala Provins Galili una. ");
INSERT INTO tif_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Lale, din almi abip Nasaret kaa iloma dinim; kulaa yak aba din abip Kapeneam kawu ila. Abip Kapeneam kaptam-ali Ok Galili kumun ami mepso kulu bombuu kemin, abip kaptam-ali Sebulun so, Naptali so, imi man loop imi tawaal namti kawu bombuu ko. ");
INSERT INTO tif_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Siin sawaayak Aisaya Yesus ami din Kapeneam kawu ilokoma kaami sang uyo God ami Sukon Tem dolsa namti kulu tituun-kup tiltam tuluya, Yesus ayo din kawu bom-biisa. Kabak-ali Aisaya ayo boko-lom: ");
INSERT INTO tif_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun so, Naptali so, alep imi man loop imi bokon ayo yak Ok Jodan malii kulu tela kulii unu ti, kulii umbilin yol ok balang diim kulu dilit kalsu. Imi tawaal kaami win kaa Galili o, ke-bisip. Lale, unang tunum miit kusnum yaapkan ita tal kaptam bom-bilip ko. ");
INSERT INTO tif_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tawaal kaptam-ami kasel iyo kutamiip o, kala ban umi diim kawu bomdiwa, taan maaklo ke imi win ayo disa kelakin. Lale, falala-kalin dukum uyo tulu utamdiwa, iyo falala-kalin dukum umi diim kawu bisip o, kala Aisaya ata Yesus ami sang uyo dolsa ko. ");
INSERT INTO tif_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kulu Yesus ayo God ami weng uyo kufo-lomda unang tunum imi bakayim-bam bokola ko: God ami unang tunum imi im-taltam almi miit tem daa-lom tiin molokoma uyo mep dikiwa tulu kemin, ibi God kaa numi ban ken-yaabup kaa im-kuku-mokoma, kalaliwa ban ayo kambola aket fal-sikiliwa yo, kala bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Am ma daanale, Yesus ayo Galili kumun ami balang diim kaa liip un-bomdala tiyak daala yi, Aniing aabi kulii din tiilip saanin tunum alep ma ok fuku-bomdip aniing abuumin men dukum ayo binalip daak ok tem unu aniing fenipla itama ko. Ma kaami win kaali alep, Saimon o, akan-kaa-bam ale, Pita yo, akan-kaa-bam ken-laabip, akal almi niing Andru alep kiita itama ko. ");
INSERT INTO tif_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus ayo bokoya ko: Nak-tunum kusal kipyo, kipni okok kebip kulaali kela tilipla, naso nikil un-bom ok kusnum ma kuya-lom yim-baali aniing abun-unbip ultap ken-tal-une-bam, unang tunum iyo afet daa yim-bii tildang God ami miit tem kawu dakamin o! yakale, ");
INSERT INTO tif_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","fan, alep iyo weng sandip, ilmi aniing abuumin men uyo abiltap-kup kano kelalip, yak Yesus ami daang bakaalipla nikil unip ko. ");
INSERT INTO tif_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesus ayo alep iyo imbii soop taba yang ulip, Sebedi ami man tunum man alep Jems sole, almi niing Jon so, alep iyo bom-bilip kala itama, kemin, alep yakal ti kuno aniing abuumin tunum. Alep imi aalap Sebedi aso, alimal maakup ilmi bot tem kabaaku bomdip alimal ilmi aniing abuumin men balat tababa ayo bikibip kala kalale, itama. Ale, Yesus ayo bokoya ko: Nak-tunum kusal kipyo, kipni okok kebip kulaa kela tiliwa, naso, nikil tal-une-bam nami ok kasiik ma kuyilila okokmin o, yakaya, ");
INSERT INTO tif_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","weng sandip abiltap-siik aalap ayo bot tem kulaaku kelalip tildak Yesus ami daang bakaaliwa tabanip ko. ");
INSERT INTO tif_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus ayo Galili bokon kaptam-ami abip ma ma kawu, tal-une-bamda yak aba tam lotu am tam une-bamda, God ami weng tambal uyo unang tunum bakayin-bamda bokola ko: God kanola ibi iltipni ban umi aket uluum ayo kuluu ban wakamin ayo kambolip namti, God ata kipni ban uyo keya-lomda imbii tam alami abip daa-lomda, tiin molokoma no, yakan-kaa-bam ale, unang tunum mafak-alin disa yakal ilmi kusnum e kala kuluu-kuluu unsip imi yam-talal-bam kem-tal-unema ko. ");
INSERT INTO tif_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kanu-balaya, unang so, tunum so, iyo ami kanuba kaami sang kaata weng kulii-una-tala-ke-bilip, dukum-nula unang tunum am bokon samaan kasel Siria kayaak yakal weng san ilmi abip ma ma kawu, kambolalip ilmi ap-tunum kusal angtiil mafak umkan-unsip iyo yim-tamalip Yesus fanang talemip. Kemin, unang tunum imi angtiil umu-laamin kaali, kalanolin angtiil umu-laamin kaata ko: angtiil mamin; tiling tem atul tabemin; sinik mafak ta yam-mafak-daasa; yak angtiil banbin-kup; tilik tilik yela daak tawaal aben-umbip aye, yaan sikil dibim tem dakan-unsip, kalanolin kiita kulii-tale-biliwa, Yesus ayo alik yam-talal-bala, tiltam yaap tem dakamip ko. ");
INSERT INTO tif_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ayo kanu-balaya, unang tunum yaapkan iyo Yesus ami fanang Provins Galili lo kawu tale-bala, Provins Dekapolis lo kawu tale-bala, abip dukum Jerusalam lo kawu tale-bala, Provins Judiya bokon abip ma kawu tale-bala, Ok Jodan malii kayaak abip ma ma kasel imi tale-bilip, kem-silom ang dinamsi kaliwa, Yesus aso unip ko. ");
INSERT INTO tif_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus ayo itam talaala yi, Unang tunum yaapkan iyo tal ang-delip kaa kalale, tam amdu tikiin tam aba daak tiin-ilomda almi miining tunum yaapkan iyo tal almi mepso kulu tiin kelipla, ");
INSERT INTO tif_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesus ayo weng kukaayim-bamda bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kamosinim diildiil ayo kanum bokoyila ko: Unang tunum iip maakup maakup iyo utamipla, Nuli titil-foko God ami kukup tangbal uyo kutal-fukulokomup disa yu, kalip. Lale, God alta im-taltam almi abip daalon o, keba. Kemin, almi titil kaata kuyilala ili God ami kukup tangbal kaata fuku-bomdiwa, tangbal-kup tiin-bom ale, fiyaap duu-bam ke-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kuno unang tunum malo ma yakal utamiwa yi, Ap-tunum kusal iyo ban kemip kalbip-kup, imi aket tem uyo mafak ilula amamip. Katale, God akal dong dokoyila asuk tiltam aket bilili kalokomip, ale fiyaap duu-bam ke-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kemin, unang tunum malo ma nuta ti kanolin o, kal-bomdip ilmi tong uyo bakamin dinim dak-diiba bom-ilip namti, ili God ami tiin diim ayo win so ke-lokomip kalalaya, almi weng kutiisa uyo kipni kuyokomi no, kalsa kaayo, yakal kuyila fiyaap duu-mokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kuno unang tunum malo ma kukup tangbal kaata-kup nuu-bulupla, God ayo fiyaap duumak i! kemip namti, God akal dong dakaayin-bala, tituun-kup tabin unang tunum ke-bomdip fiyaap duu-mokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Unang tunum malo ma ita ifan o, kal-bomdip ap-tunum kusal imi olen-dakaayin-bamdip kukup tambal tambal kamayip namti, God akal olen-in-bamda kukup tambal tambal kamayim-bala, fiyaap duu-bam ilokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kemin, unang tunum malo ma, imi aket kaa aket alep kemin daa; imi aket fukunin ayo ti maakup ke tituun-kup kelip namti, ili din God aso suunkup ilin abip kawu ilokomip. Kemin, kaami fiyaap ayo duu-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dok kanolin unang tunum ita ma weng diki-bam ale, din-bom kemipla, ap-tunum kusal malo ma ita tal kanubip imi iipyak tem kabaaku tola-lom fakayin-bilip, kulaa kela mulo kawu weng talalu una-tala-ke-mokomip tunum kiita, God ayo boko-lomda: Aptum kusal imi fakel-ilin tunum kiili, nami Man o, kalala, fiyaap duu-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aa ti kuno unang tunum malo ma iyo kukup tangbal-kup tabasu kaata-kup kutal-fukusip. La, umi kalan kaata tunum mafak iyo itam fanan-bam ale, yam-mafak-daka-bam ken-tabasip. Lale, kukup tangbal tabuulin tunum ili, God ayo im-taltam almi daam tem kawu daalon o, kalba kemin, tangbal-kup bom ale, fiyaap duu-bam ke-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kipyo, kibi nalmi daang bakaalin tunum kemin, unang tunum kii kawanta nali nitam fananip namti, kuliita taba weng mafak dap-kaayim-bam ale, disa kukup mafak mafak uyo kukaayim-bam ale, disa kasen-fakayin weng ayo kukaayim-bam kipni win ayo dap-mafak-dakaayim-bam kem-laabip. Lale, ibi fiyaap-kup duu-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kemin, sawaayak God ami weng ku-fatap-dakamin tunum ili kipni ok kaa kanubip kaaltap kanu-bamdiwa, God ami ok ayo tabumsip. Lale, yak tunum kukup mafak tabuulin ita taba-lomdip kanolin kukup mafak ata profet imi kukaayinsip. Lale, ili ma daal-daal-kemin daa; talalu yikik titil-biki-bom ilsip. (Kemin, ibi kabak-ami aket uyo fanang daka-bamdiwa, daal tabemin daa; ti titil-foko tola bom ilin ko.) Ilom am ma daanokomu kaali, God alalta imbii tam abiil tikiin daale, kukup tangbal kaata-kup kukaayokoma. Kemin, ti fiyaap duumin sakbaalim dukum-kup duu-bamdiwa kayi! kala Yesus ayo almi miining daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesus ayo faldak-tiimin weng alep ma boko-lomda: Yol ami titil o, kala abaal kaa disa kelu namti, kaa kalok nola talalulup asuk yol ami abaal ayo tabokoma ni? Kabak-ali atin disa te! Kanola unang uyo ima ket abuu fuulon o, kalu namti, utamula, yol kalawa mafakba nu, kalu kaa, yol kuluu balaalokomu disa; binalu tam daak abip abamnala unang tunum iyo ami tip diim kawu une-tale-ke-mokomip o. God ami unang tunum ibi yol abaal tabasu altap ke kukup tangbal kaata-kup kaptum kusal iyo kukuyin-bilipla, ima yol balaalip abaal taba-yaabu tap ke tiltam tambal-kup ke-lokomip ko. Ale, ibi kukup tangbal kaa kutal-fukulin disa ke-lokomip kaali, ibi God ami ok fukulin tunum ke-lokomip disa ibi yol mafaknuya binalip uneba tap ke-lokomip o. ");
INSERT INTO tif_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Aa, kano ti, kanolin God ami unang tunum ibi yokon dawang alaltap keliwa, kukup tangbal ayo nuu-biliwa, kap-tunum kusal kayak kayak iyo ita-mokomip o. Ipni abip kaami amdu fiil tolsa alaltap o. Unang tunum unbip samaanlo kawu bom-bilip ili, ibi ita-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dok kanolin tunum ata ilaam iilfo kulaak baket tem kabaaku kuwaalokoma disa; ti iilfo kutam ulmi baan diim diilala, am ayo alik iilfo falala-kup kala bom-buluya, unang tunum kaptam bom-bilip iyo mafek mafek ayo tambal-kup utafii-mokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ibi yokon dawang yang uul tem kulaaso falala-kup kala-laabu ultap ke kukup tangbal kaata-kup kap-tunum kusal kusnum imi tiin diim ayo kukuyin-bilip utam-sinomdipla, imi aket fukunin uyo bam-daayilu kipni kaalap abiil kayaak God ami win ayo kufumin o, kala Yesus ayo kanolin weng do alep iyo almi kalaan tunum imi bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesus ayo weng maso bokoya ko. Kipkal aket fukuniwa: Ali tal God ami Lo Moses ami dolsa so, God ami profet imi weng dolsip so, uta kukan-tiin talse no, nokolip i! Nali kabak-ata kukan-tiilon o, kalali talsii daa; nali tal imi weng kaata kutal-fukulila, tiknuk o, kalaliya talsii. ");
INSERT INTO tif_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nami weng bakayokomi uyo talalu weng san iliwa! Tawaal diim so, abiil tikiin so, kiimi ilokomip kaa, God ami Lo Moses dolsa umi anung anung ayo alik ti kano ilokomu. Kemin, alik ibi kaa ti suunkup kutal-fuku-bomdiwa ko. Bom ilom God ami boko-lomda: Kabak kanolokomi kayi! kalsa uyo nola alik dinim ke-lokomu kawu, God ami Lo kukal ti disa ke-lokomu ko. ");
INSERT INTO tif_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kabak-ali ti faneng kemin, dok nolin tunum ata God ami weng anung kaami sang kaa boko-lomda: God ami sang anung kuluuli win dinim o, kala-som aa, ap-tunum kusal imi kanolin kukup uyo kukuyim-bam ke-balaya, yakal ti weng kuyang saak tiimi namti, ami tam God ami abip ilokoma kaa, God ami tiin diim kaa win dinim ke ilokoma; ale, dok nolin tunum ata God ami weng uyo alik weng san-kaa-bamda ap-tunum kusal imi kanumin kukup uyo kukuyim-balaya, yakal kutal-fukulip namti, Ko! kaata fan tam God ami abip tiinokoma uyo, God ami tiin diim kaa, ti tambal-kup fatap diim kawu bom-balaya, God ali ami win ayo kufolokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nami weng kala weng selin! Lo utamsip tunum sole, Falosi so, ili God ami weng kulaa utam kaal kesip ili tunum imi tiin diim kulaa win so kesip. Lale, ili God ami Lo kaata-kup ti tabuulalip dinim; kambola kukup tangbal kutal-fukule, kukup mafak kutal-fuku-som ken-umbip kaa, God ali imi fiyaap dukum kaa ma duun-umba disa. Kibi God ami abip unum o, kalip kaali, God ami bokoya-lomda: Kaata kanumin o, yakan-kaaba kaata, talalu yikik-kutal-fukulokomip uta, fan imi God ami Lo kutal-fukusip uyo kabaak banuya, kipni God ami weng kutal-fukulokomip uta uta keluya, God imbii tam almi miit tem daalak o, kalala Yesus ayo weng tem almi okok-kemin imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesus ayo asuk bokoya ko: Sawaayak Moses ami awil-fakal imi bokoyinsa kaami sang kulaa bakayin-bilila, weng san kan-tabasip kabak boko-lomdu: Kabi kaptum kusal kaa aalap, taan-yaamin daa kalsu. Kemin, dok nolin tunum ata ap-tunum ma aala taana namti, dibii din weng talalmin tunum ami diim daaliwa, akal alta saanin uyo kolama no, kalsu. ");
INSERT INTO tif_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lale, nata weng kusnum ma bokolokomi kemin, weng san-iliwa! Dok nolin tunum ata ap-tunum ami aket atul kola namti, ali ap-tunum ayo dibii din kamokim ami diim daala kot ke-mokoma kemin, ibi kaa kanumin dinim o. Kano tunum kanta aptum ami weng mafak ma kola namti, almi kukup mafak kanuba uta dibii yang kot dukum diim daaluya, im-bak saanin tunum ata taba-lomda dabak molokoma no. Kemin, ibi kabak kanumin dinim kayi! Kuno tunum kaa kanta aptum ami bokola-lomda: Kabi ti fuut tabin tunum o, aka namti, God ata ali dabaala din as mafak suunkup ti kano kiinin-kup ilin abip unoma. Kemin, kibi kaa kanumin daa yo. ");
INSERT INTO tif_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kemin, kabi mafek mafek ma kulii-tal aba tam God ami lotu am un-ilomdi yaap ke yo kemin, uyo God ami kolon o, kalap namti, kabi aket kabak dotu fuku-daa-somdapla yo. Kapni kap-tunum ayo dok nolin kukup mafak ma ami konbi ni, kalap namti, ");
INSERT INTO tif_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","baan asuk kapni mafek mafek God ami kolon o, kalbap ayo kutiilawa, bina din kap-tunum ayo dap-talang daalap alep weng uyo dotule, aket maakup kelup kalbap-kup kawu, asuk tal-ilomdap kapni yaap ke yo, kalin kaami mafek mafek uyo God kaa kolan o, kala-somya ko. ");
INSERT INTO tif_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kanola kap-tunum ayo bokop-ta-lomda: Kukup mafak kep-nap kemin, tam-bii din weng talalmin tunum ami diim daalon o, kala namti, baan alep yang weng talalmin tunum ami diim unin disa; ilom kabi abiltap kap-tunum ami diim unap, alep weng ayo dotu aket maakup ke-lomdiwa, kelin o, kala-somla ko. Ale, kabi kamosinim kawu dotulin disa kelap namti, kap-tunum ayo timbi yang tam-baala yak weng talalmin tunum ami diim abamnapla, ata lekbi tam-baala yak bolis man imi sikil diim abamnap ita sok de-dap kalabus am daalokomip. ");
INSERT INTO tif_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kemin, kaptamu bom-balap bii kapni ban ke-salap uyo alik ti disa kelula kawu, tildaa tam-baalip tiltamba talokomap. Kemin, tituun weng bokop-ti: Kabi nami weng kaa dotu weng sandawa kayi! kala Yesus ayo almi aso maakup tal-unemin imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kulaa Yesus ayo asuk weng kusnum ma bokola ko: Sawaayak Moses ami sang bokosa kaami sang ayo bakayim-bilip weng san kan-umbip kabak-ali boko-lomdu: Unang din tunum din kiili, sadikimin daa yo, kalsu. ");
INSERT INTO tif_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kalsu kemin, nata weng kusnum ma bokoyokomi kemin, weng san iliwa, Dok nolin tunum ata unang ma uyo utam-ilomda: Kwin! kuuta nami sidikimon o kala namti, ami aket kaa fukunba uyo unang tunum imi tiin kuwaka-yin-bam sadikimin kukup namti kaa bombuu. ");
INSERT INTO tif_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kemin, kapni tiin malii uta kukup mafak ayo kukup-tuya nuumon o, kem-tabap namti, kaltapni tiin malii tiingtup, uyo wal binalap unu. Tiin malii maakup kaa, kukup mafak kemin, kulaa kela bombi taan-ilomdap, tam God ami abip kawu suunkup ilokomap kaata, tambal. Lale, kabi tiin malii kaa ulduu kukan-tiili daa yo, kalalap, kukup mafak-kup nuubi saaknap kalale, God ami ensel ita taba-lom tam-baalip yang wing suunkup kiin-bam ilin abip unokomap kaali, tangbal disa. ");
INSERT INTO tif_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kanolin kemin, kapni sikil tiingtup uta bokop-ta-lomdu: Yang kukup mafak nuumon o, kali kalbap namti, sikil ayo wak binalap una. Sikil malii ukdin kelap kaa, kukup mafak kemin, kela bombii taandap tam God ami abip kawu suunkup ilokomap kaata, tambal dukum. Lale, kabi sikil malii ayo ukduu kukan-tiilokomi disa yo, kalalap, kukup mafak ata-kup ti kanumsi, saaknap kaa timbip-kup, God ami ensel ita tam-baalip yang wing tiil suunkup kiinin abip unokomap kaali, tambal disa yo, kala Yesus almi kalaan tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesus ayo asuk boko-lomda: Ipni kukuyin ita boko-lom: Ali kanta almi kalel uyo kambowi no, kala namti, kuyak fiitmin disa. Imak kapta sukon ma dola kalel umi kuwapla, kuliilu unokomu no, kalsip. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","nata weng kusnum akal ma kaata, bokolokomi kemin, weng selin! Dok nolin tunum ata ma kalel uli sadikimin dinim tangbal-kup bombuu. Lale, alta taba kalel kuluuli kewi te! kala, kewa uyo yang tunum kusnum ma dabuulu namti, God ami tiin diim ami kalel uso, tunum kusnum dabuulu aso, alep kiimi kanolip uyo sadiki-bamdiwa, unang umi diil imak ayo tiin kuwakan-bamdip dap-mafak-dakabip o, kalokomip ko. Yale, kaa mulo kawu, imak so, unang kuso, imi san-kup disa; diil imak ata taba-lomda im-baala yak sadikimin umi diim abamnip. Kemin, ban kemin, umi uluum ayo akmal asuumano kanolin kuluulip o, kala Yesus ayo almi kalaan tunum imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesus ali weng akal alik ma boko-lomda: Sawaayak Moses ata awil-fakal imi bokoyinsa kaami sang bakayin-bilipla, weng san kan-tabasip kabak-ali boko-lomdu: Kabi kaptum ami diim kawu weng ma kuka-daala-lomdap, kanolokomi kayi! kalalap God ami win awem kaata kufole, kapni weng uyo ku-titil-diilap namti, weng kaa lo-laamin daa yo, kalsu. Kemin ale, ");
INSERT INTO tif_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","weng san iliwa! Nata weng kusnum ma bokoyilila: Kabi weng kaa kuka-daalon kalap namti, weng kutal aba yak God ami win diim aye, mafek mafek umi win diim kaa tik-tii-bamdap kapni weng ayo ku-titil saanin disa yo. Tam abiil tikiin kaa God ami abip ale, ");
INSERT INTO tif_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","tawaal diim kaldaak-ali God alalta talalu-lom tiin mo kesa. Kemin, kanola Jerusalam kaali, King dukum God ami abip tawaal diim kala buu namti kabuu, kabi mafek mafek alik imi win diim kabak kufon-bamdap kapni weng kaa ku-titil saanin dinim. ");
INSERT INTO tif_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kemin, kabi taang-kala-somdap kaltapni dabom kon maakup maakup ayo fal-sikilap tiltam namaal ke-bala, duut ke-bala, kelama disa; God maakup ata-kup yaap kanolama; kabi kaltapni dabom kaa tii kufo-lomdap kaltapni weng kaa ku-titil saanin disa yo. ");
INSERT INTO tif_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kemin, kabi kalok nolin umi win uta ma boko-lomdi weng kutiilokomi uyo, titil-fokolu kewon kalap namti, kaa tunum mafakim Setaan ata bokop-taya, kasen-fakamin weng ayo baka-mokomap. Kemin, tituun weng kaata-kup baka-bamdap kaata kanolokomi kalap, ata-kup kanu-bam ale, Yi! kaa ke-lokomi no, kalap uyo atin kulaka-bam keman o, kala Yesus ayo almi kalaan tunum imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesus ayo weng ma bokola ko: Sawaayak Moses ami weng bokosa kaami sang uyo bakayin-bilip weng san-kan-tabasip kabak-ali boko-lomdu: Tunum ata taba-lomda kapni tiin uyo fela kutiip-ta namti, kapkal tiin umi maan kaa tii-lomdap ami tiin ayo fela kutelamap o, kala-som ale, te-bamda kapni kiil ayo malduu kutiip-ta namti, kapkal kaltapni kiil uyo maan kaa tii-lomdap ami kiil ayo malduu kutelamap o, kala kanum bokosu no. ");
INSERT INTO tif_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nata weng kusnum ma bokoyokomi. Kemin, weng san iliwa! Kanola tunum ami kukup mafak kup-ta kaa, kapkal ami kukup mafak kup-ta uyo kapsiik maan tiimin daa; le, ayo kukup mafak kup-ton o, kala namti, kabi daa yo, kemin daa; mep kanuba tunum ata taba kapni akalap malii tiingtuplo ayo tangafap ta bina daala namti, kabi falmek akalap malii ayo kolap bina-daa kelama no. ");
INSERT INTO tif_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kanola kap-tunum ami mafek mafek maan kup-ta, maan soyim kebap kaa, kapyo, telin disa ilawa, kap-tunum ayo tam-tama din weng talalmin tunum ami diim daaliya, kapni siyot ayo alta kuluu kup-nak i! kemaya, atamap namti, yak kapni siyot ayo konbap-kup, kuno diil katip saket ayo dilduu kola kemin ko. ");
INSERT INTO tif_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bolis ma mamdet kuyak daa, Kapta nami bung kuliilap din iip ma daap-na tal o, tokokoma kaa, aket atul tabemin daa; ti tambal o, kala kuliilap umbilin ami kulu no, kala bokop-ta uyo kukan-tii akaala yak aba umbilin samaan kababap-kup kawu, kutela talokomap o. ");
INSERT INTO tif_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kuno tunum ma kapni mafek mafek sang nen-daap-ta uyo kukaalin o. Tunum ali kapni mafek mafek ayo ma kup-napla, kulii umbili asuk kulip-ta talon o, kala kaa kabi daa yo, kemin daa kayi! kala Yesus ayo almi miining imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesus ayo asuk bokola: Ko! Siin diil weng uyo bakayin-bilip weng san-kan-tabasip. Kemin ale, Moses ami weng uta boko-lomdu: Ibi iltipni kayaak imi aket uta kukaayin o, kalsu. Ale, awil-fakal imi weng uta boko-lom: Ibi ti waasi iyo tit-kup itam ilin o, kalsu. ");
INSERT INTO tif_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lale, nata weng kusnum ma kaata bokoyokomi. Kemin, weng san iliwa! Kibi waasi imi aket kaata kukaayim-bamdiple, dok kanolin tunum kaata ma ibi kukup mafak kaa kukaayimba kalip namti, ibi beten kaa kamaan-biliwa, God akal dong dakaalak o. ");
INSERT INTO tif_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kemin, kaltipni Kaalap God abiil tikiin bombe ami atan ayo iilfo kulaala tildaak tunum tambal so, tunum mafak so, imi al uyo abale; om ayo kulaala tildaak tunum tituun so, tunum tituun dinim so, alep maakup imi diim kawu aben-umbu. Kemin, kanola ibi iltipni kayaak imi aket kuuyin tap ke waasi imi aket uyo kuyip namti, Kaalap God akal ibi talalu-yimula almi man ke-lokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kanola ibi tunum kusnum kayak kayak iyo kamboya-lomdip ipni aket ayo kaptum kusal imi aket ipni kuyimbip imi kup kuyip namti, kuuta dong dokop-tokomu disa. Kaa dok ata naa kalolip: Takis kaamin tunum mafak yakal kuno ap-tunum kusal kiita-kup imi kukaayila-yaabip kemin, kiimi kukup kaa kulaak banule, kapni kukup kaata uta uta ke-lokomu dinim te! Kapso, iso, ipni kukup kaa maakup kemin, kuuta dong dokoyokomu dinim o. ");
INSERT INTO tif_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ibi ti iltipni kayaak ita-kup weng fakayip namti, kaa dok kano-som tunum kusnum iyo kabaak banipla, kipta kipta ke-mokomip i? Daa, unang tunum Juda kasel ami lak duulin disa yakal ti, ilmi kayaak-kup weng fakaya-yaabip. Kemin ale, kipkal ti imi kukup kaa kanun-umbip kabak-ata kaa kanun-yaabip. ");
INSERT INTO tif_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kanolin kemin, iltipni Kaalap abiil kayaak ami kukup tangbal uta ti suun kanun-umba tap ke-bamdiwa, iltipni kayaak imi ti tambal tambal ma kamayim-bam ale, kipni waasi yakal kuno tambal tambal ma kamayim-bam ke-bamdiwa yo! kal-bomda Yesus ami weng uyo kanu-bam almi daang bakaalin man imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus ayo weng ma bokola ko: Ibi kala nuu-bulupya, unang tunum kiita numi itam-somdiwa, numi win uta bakayin o, kalaliwa, iltipni kukup tambal tangbal ayo imi tiin diim kaa, kanumin disa ko. Utafii-bamdiwa kayi! Ibi kanu-mokomip kaali, kipni Kaalap abiil tikiin kayaak ayo taba-lomda kipni win kufuyim-bamda mafek mafek tambal kaa ma kuyokoma disa te! ");
INSERT INTO tif_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kabak-ami bokosu kaali, kipkal tunum iyo mafek mafek ma duluu-lom iipnip kalalip dong dokoyum o, kala kipni mafek mafek bung ayo kuluubip-kup, kukaayokomip kaali ti, nuyo kanu-bulup kayak kayak ita itam numi win ayo kufuyik i! kalin tunum ililtap kaa kanumin disa ko. Yak kukup alep tabuulin tunum ili kayak kayak ita itamik o, kal-bomdiwa tunum asiik dabaalip din-ilomda fong ket naan-balaya, unang tunum alik imi tiin diim mafek mafek dulubip imi bung kukaayila-yaabip. Kemin, lotu am aye, abip iip kawu kanun-umbip kaa fan bokoyokomi. Unang tunum imi tong bakan-umbip kaali, imi sisol namti kaa bombuu kemin, kaata-kup kuluulokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Kipni tunum mafek mafek iipnip imi kukaayokomip kaali, kayak kayak imi tiin kuwaya-lomdip mafek mafek uyo baan tap maaklo masiim kukaayokomip kaata, fan kipni Kaalap God ayo atam-somdala, akal mafek mafek tambal ayo kipni kuyokoma no, kala Yesus ayo almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesus ayo asuk bokoya ko: Kipni God ami beten kamalokomip kaali, kanu-buluwa, kayak kayak ita numi win kufuyik o, kalalip kanun-umbip ulultap kaa, kanumin disa yo. Kukup alep fukumin tunum ili kanu-buluwa, unang tunum iyo itamik o, kalaliwa, suunkup lotu am aa, abip iip kawu tola-bomdip God ami beten kamalin-kup laabip kabak tifan bokoyokomi, unang tunum ta kipni tong bakan-unbip uyo imi sisol namti kulu bombe kemin, kaata-kup kuluulokomip. ");
INSERT INTO tif_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lale, kipni God ami beten kamalum o, kalokomip kaali, iltipni am kaptam ban saal lii-lom ipni Kaalap God abiil kayaak bombe ayo maaklo beten kamalalip kayi! Kaalap ali kipni maaklo beten kamanbip ayo utam-ilomda mafek mafek sang dik-dakaanbip kaa kuyokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kipni God ami beten kamalokomip kaali, ibi Juda unang tunum disa imi babon-bamdip weng yamyam bakan-umbip ulultap uyo kanu-bam beten kemin disa. Kiimi aket fukunin kaali, weng yamyam baka-buluwa, salap men ita numi weng uyo weng sanokomip o, kala-lomdip uyo kanun-umbip. ");
INSERT INTO tif_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lale, Kaalap God ali ipni mafek mafek dulu-lom naan-daalin dinim bom-bilip uyo utamsa. Kemin, Juda unang tunum disa imi kukup kanubip ulultap kaa kanumin disa. ");
INSERT INTO tif_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kemin, ibi God ami beten kelum o, kalokomip kaa kala nuu-bamdip bakamalip ko: Numi Aatumen abiil tikin kayaak kapyo, kapni win kaali, sakbaalim dukum kemin, unang tunum alik nuli dong dakaayin-balawa, ata tambal-kup tabasa no, takan-kaa-bamduwa yo. ");
INSERT INTO tif_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kabi alik nuli imbii tam kaltapni miit tem daa tiin molap bomduwa yo. Kabi dong dakaayim-balap, alik nuli abiil tikiin kayaak imi kapni aket fukunbap kaata-kup talala-laabip tap kanu-bamduwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kamala kulaali numi am kamala ima inin ayo kuyap in-buluwa yo. ");
INSERT INTO tif_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kabi numi ban uyo kamboya numi nak-tunum kusal imi numi ban kamayim-bilip, kamboyila-yaabup ulultap keyan o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kabi mafek mafek mafak tal numi diim aba yam-kukulon o, kalbu uyo dukum-kup dong dokoyawa, kuno kamboyap nuli yang ban ukduu-laamin disa yo. Setaan ata numi yam-mafak-daalon o, kalokoma uyo dong dokoyawa kamboyak o, kal-bomdiwa, God ayo kaa beten kaman-biliwa yo. ");
INSERT INTO tif_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kemin, kanola kibi unang tunum imi ban kamayimbip kuno kela-lom asuk fanang dakamin disa kemip namti, kipni Kaalap abiil tikiin kayaak akal ti kipni ban uyo kuno keya-lom asuk fanang dakamin disa keyokoma ko. Lale, ");
INSERT INTO tif_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ili fan kibi ban wakayimbip ayo kuno kela-lom asuk fanang dakamin dinim ke-mokomip disa namti, kipni Kaalap akal kipni ban kebip ayo kuno kela-lom asuk fanang dakamin dinim keyokoma disa kayi! kala Yesus ayo almi daang bakaalin imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesus ayo weng ma bokoya-lomda: Ibi God ami beten kemum o, kalalip ima falamip namti, ibi kukup alep fukumin tunum imi aket fukunin kaa, Nuli unang tunum imi ibakayim-bam tunum ami aket uluum kuluu-bomda tibi mafak diyaku bomda be alaltap keluwa, kayak kayak ili itamdiwa, numi beten kemin kaami win uyo bakayik o, kalalip tibi mafak duu-bomdip kanubip tap uyo, kanumin disa; imi aket fukunin uyo kayak kayak ita itamiwa yi, Beten ke-bam ima falabip o, yikin o, kal-bomdiwa, ok iluu-lom tibi kun ayo diingmin disa ke-bomdiwa, ima kaa falan-umbip. Kemin, nali ti tituun weng kaata bokoyokomi. Kayak kayak ita unang tunum ima fala tibi mafak diyaku-yaabip imi win kufoya-yaabip, imi sisol namti kulube kemin, kaata-kup kuluulokomip. ");
INSERT INTO tif_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Kemin ale, kipkal ima ayo falamip namti, kipni ima fala-mokomip kaali, unang tunum ili disa; numi Atok God sawaan bom ilin ata-kup numi ima falabup uyo utamak o, kalaliwa kemin, daal tiin kaa talakamin daa; tibi kun ayo diing-bam ale, dabom kon ayo deng-bam ke-bamdiwa yo. Kaalap God ali sawaanin diim kawu laaba ata asiik ima falabip iyo itam-somdala, mafek mafek tangbal kuyokoma no, kala Yesus almi kalaan tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Asuk Yesus ayo boko-lomda: Ibi tawaal diim kaldaak-ami mafek mafek tambal tambal diilip tal am abe-mokoma kaali, keng tinom sole, ol fuku-som ke ku-mafak-daalokomu aa, yukut inin tunum ta tal am kaa balata-lom tiltam duk-duulokomip ko. Ibi tawaal diim kaldaak-ami mafek mafek tangbal tangbal kutookso kiiyo, kulii-tal kuyaku kuyaku ke sikip fik-tiimin dinim o. ");
INSERT INTO tif_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ibi God ami kukup tangbal tangbal ata-kup talalu yikik-kutal-fukulip namti, God akal kipni mafek mafek tangbal ayo abiil tikiin kawu afetu kutiiyila bom-buluya bii, tam atamiwale, kuyokoma. Kemin, abiil tikiin kaptam-ami mafek mafek kaali, tinom sole, ol fukusa so, ita ku-mafak daalokomip disa; aa, yukut inin tunum ayo tal balata kulii tam duk-duulokoma disa yo. ");
INSERT INTO tif_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kemin, ipni mafek mafek tangbal kaa, tawaal diim kaldaak bom buu namti, ibi tawaal kaami aket-kup fukun-bam ilokomip. Ale, ipni mafek mafek ayo abiil tikiin kawu bom ilu namti, aa ti abiil tikiin kaami aket-kup fukun-bam ilokomip o, kala Yesus ayo almi kalaan tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yesus ayo faldak-tiimin weng ma boko-lomda: Ipni tiin kuuli angtiil umi yokon ultap kemin, tiin ayo tambal-kup ilu namti, kaata ibi mafek mafek mafak uyo kukaayak daka-bamdiwa, mafek mafek ayo tangbal-kup num-tal-une-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ale, kanola kipni tiin ayo atin mafak ilu namti, mafek mafek ayo utam, Awu, kuuta mafak e? kuuta tambal e? kal-bomdiwa tangbal-kup num-tal une-mokomip disa. God almi aket fukunin tambal kipni kuyokoma ayo kuuta yokon ultap ke kukuyim-buluya, utamiwa yi, Kanola tal-unebup kaa ti tangbal tal-unemup u, ke-mokomip. Kemin, mafek mafek uta taba-lomdu kanolin yokon kaa tenalu namti, kipni aket fukunin so, tal-unemin, tiin-yaamin so, uyo mafak ilokomu kayi! yakan-kaama ko. ");
INSERT INTO tif_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kulaata, Yesus ayo weng sawaa imi bokoya-lomda: Tunum maakup ma kaa taang-kala-somdala kamok alep imi ok ayo tabuu-mokoma disa. Kanola mep tunum kaali kanuma namti, ali ma ami atam fanan daa daang ukola-somdaya, ma ami aket ata kolokomale, ma kaami lak ata duuba-kup; ma ata kuno maas kela daang ukolokoma no. Kanolin kemin, ibi taang-kala God ami aket sole, moni kaamin kaami aket so, iyo alep alep kano imi aket uyo yan-bulu ilin disa yo, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Asuk Yesus ayo weng ma boko-lomda: Nali weng ma bokoyon o, kali kemin, weng san iliwa! Ibi taang-kala-somdiwa, God ami aket so, moni kaamin kaami aket so, iyo alep alep kano imi aket kaa yan-bulula ilokomup disa yo, kala-lomdiwa, kipni kaa unip umi aket dukum uyo fukun-bamdip boko-lom: Ima so, wok so, kii dok liip ma tilipla kuluu inum e? kal-bomdip ila faka-bam aket dukum uyo fukun-bam ale, iltipni angtiil lak ayo duu-lom bokolip: Kwin! ilim kaa doku ma tuluya kuluu mikilokomup i? kala ukol ila faka-bam aket yaapkan kaa fukun-bam kemin daa yo. God ata mafek mafek sakbaalim dukum o, kala kipni mam so, tiil so, kuyilaya bom-bilip. Kemin ale, kanola mafek mafek katip sakap inin so, ilim kaal mikimin so, kikal God alta kuyokoma. Kemin, kaami aket kaa suunkup aket yaapkan kaa fukunin disa yo. ");
INSERT INTO tif_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ibi awon imi asal asal kawu tal-unen-umbip kii itamin! Ili ima lang kaa imi dikimin disa; ale ili ima kaa dabuumin disa. Ima afetbi kulii-tal am kutiimin disa. Yale, kipni Kaalap abiil tikiin kayaak alalta ima uyo kukaayin-balaya, inan-yaabip. Lale, God ami aket fanang kaa, atin ti dukum uyo unang tunum kipni kuyimba-kup, awon ita imtal balang tem daa ke-somdaya, ipta ima uyo kukaayim-balaya ima ayo ti yaap inan-yaabip. ");
INSERT INTO tif_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kemin, ibi aket dukum fukun-bamdip iltipni angtiil lak dakaamin uta taba-lomdu dong dokoyilula, ipni ilin ayo kayoop aye, wasital aa, uyo maso til-daalip tooplo so keluya, tawaal diim kala bombii luk-daalokomip ema? Kwin, disa kawi! God ali boko-lomda: Kulaata taanan taka namti, kuyaku taanokomap ko. ");
INSERT INTO tif_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ibi kanimin o, kala-somdiwa ilim kiimi aket dukum kaa fukunbip yoko? Ibi saak yang aba saak saak kulaami mafek mafek tes kaa utamin! Kaa tunum nulultap keluya, ulmi ilim talal-bam faamin disa; uli ti disa kulu tiltam taba-lomdu umi tes tangbal ayo abun-umbu. ");
INSERT INTO tif_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Siin sawaayak, tunum win tibin kamokim Solomon ami bom-biisa kaa, ali bung kayaakim ke-bomdala, ilim kutookso tangbal tangbal ata-kup kaata falatam tii-bam biisa. Lale, ami ilim sikil tuup baken-bilip miki-bam bom-biisa umi ilim dawang kulaali kulaak banula, as tes umi dawang tangbal ata ata kesu. ");
INSERT INTO tif_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kemin, tes kaali, tikiinal kawu bom ilin aye, tes tangbal uyo tes falaa ilana datnule, tunum ta tikiin kuyak-daalipla, ami tes kulaaso kiin abe-bam ke-laaba. Lale, kaa God alalta talalu kutii tiin molaya, tangbal-kup tes ayo fala-kan-umba. Kemin, nikil ibi aket alep kaa taka-bam God kaa nuli ilim kaal kaa ma kuyokoma ne? daa ye? kem-tabasip. Ipkal talalu utamin! God ami tiin diim kaali ibi tikiin tes ayo kabaak-banaya, kipta kipta kesip. Kemin, God akal kanola ibi talalu tiin molokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kanu-mokoma kemin, ibi aket yaapkan fukun-bamdip ami ima aye, ok aa, ilim kaal ayo, kaa doku tulu kuluu-somduwa, in-bom ale, miki-bam ke-bam ilokomup i? kemin, disa yo. ");
INSERT INTO tif_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","God ami lak duulin disa ili mafek mafek alik kanolin kaata fen-bomdiwa ken-umbip. Kemin, ipni Kaalap abiil tikiin kayaak ali kipso, iso, itamala ili mafek mafek alik kaali dal-kaabip kala kem-tabasa. ");
INSERT INTO tif_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lale, mafek mafek diil dukum kipni dal-kaa-mokomip namti kala bombe. Ibi God ami miit tem un-ilom almi tituun alik-daap kelupla, almi tituun-kup kukup ata-kup kutal-fukulum o, kala God ami aket ata ti kwin! disa akal ma kemin o. Kanumip namti, God akal dong dakaayim-bam ale, kipni mafek mafek duluu-bom-bilip kaakal kusnum ima aye, ilim kaal aye, uyo kukaayim-bam ke-mokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ultap kemin, kamala kaa ibi am sibi kaami mafek mafek fiitmin kaami aket kaa, aket yamyam ke-bam fukunin disa. Kemin, kulaa sindip kaami aket uyo fanang daka-biliwa kayi! Am kamala kalawaami mafek mafek fiitmin tiltam tulu umi aket namti kula kaa fukunbip kemin ti kulaata-kup taa! kal-bomdiwa yo, kala Yesus ayo weng tem kalaali almi kalaan tunum imi kanum bakayim-bisa ko. ");
INSERT INTO tif_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Asuk Yesus ayo bokola: Kabi God ami abiin kaata, kuluu-lomdap ami okok keba uta nasiik kuluulila okok kemon i, kemin daa yo. Kabi kap-tunum kusal kii itafii-bamdap boko-lom: Ibi kukup mafak kebip te! kemin disa, kambolap namti, God akal win bakap-tam-bamda bokop-ta-lom: Kabi kukup mafak nuubap o, tokokoma disa. ");
INSERT INTO tif_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aa, kabi kaptum kusal kii ibi kanubip te! kal-bomdap win bakayap namti, aa ti God akal kapni kanubap kaakal, tam-kayaku-lom ale, kapni kaptum kusal imi dok kanolin kukup kaata, kukaayim-bam ilolap namti, God akal ti kanolin kukup kulaata ti, kapkal kukup-tokoma. Kemin, kaptum kusal kii weng mafak kaa kukaayin dinim kayi! ");
INSERT INTO tif_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kaptum kusal imi kukup mafak katip katip kuuli, sung ilol tal tiin uneba tap ale, kapni kukup mafak sakbaalim dukum kanubap kaata as daang tiin fuk-duup-ta-yaaba tap. La, kapni kap-tunum ami bokola-lomdap: Tiin sung tal aba yak unan i! ken-umbap. Katale, aket fukun-ilom as daang tiin faka-tanip-na kulaa laap bombu kemin, am ma daanula disa ke-lokomu. Kemin, aket uluum kep-nokomu disa yo, kem-laabap. Kemin, kabi kaltapni kap-tunum kusal imi kukup mafak katip katip kulaa utamsap. Katale, mep kaltapni kukup mafak awak sakbaalkan dukum kanubap kabak-ali kabi utabap e? disa? ");
INSERT INTO tif_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kanimin o, kalalapla kap-tunum kaa bokola-lomdap: Nak-tunum kapyo, dong dokop-ta-lomdi tiin sung ayo kukan-tiip-ton o, kalbap i? Daa! As daang ta tiin faka-tanip-ta tiin bokol ke-salap kalaali, kabi dok kano-somdawa dong dokolokomap i? ");
INSERT INTO tif_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kabi kukup alep fukumin tunum kapya! Kamosinim as daang uyo kaltapni tiin diim bombe kaali, kukan-tii-somdawa kawu, yak kap-tunum ami tiin sung uyo talalu utam-ilomdap kukan-telamap ko. ");
INSERT INTO tif_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kulaata weng kusnum ma bokop-ton o, kala-somdila ko. Kemin, kabi dok nolin unang tunum ita God ami weng kaa weng sanamup disa yo, kemip namti, kabi kiili God ami weng kaali, maso bakayin disa yo. Kemin, kapkal utaman! Man ma miyaan ami samsamala namti, miyaan ayo fal-siki-taba man kaayo, aalokoma. Ultap kemin, dok-nolin tunum ata God ami weng kaa unang tunum daal-dap-tiiyimba imi kukaayin-kup kema namti, kiili aket atul dap-tiiyule, tam taba dap-mafak-daalokomip. Kemin ale, kanumin siim o, kanola kap kayuum kiit ayo kulaalap daak tawaal diim abam-nokoma ayo kang iyo tal yaan biil tap-tap-kelip maaklo ke-lokoma. Kemin, kanolin o. Tunum unang iyo kanta God ami weng kaa, weng sanamup disa yo, kalbip kiili, suunkup kukaayokomap kaali, ili God ami win ayo ku-mafak-daalokomip o, kala Yesus ayo almi kalaan tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kuno asuk Yesus ayo weng kusnum ma boko-lomda: Kabi dok kanolin mafek mafek ma dululap namti, suunkup God ami dik-dakaan-balapla, ayo kup-tokoma ko. Mafek mafek ma utamon kalalap fenbap namti, God ata dong dokop-tala uta-mokomap. Kuno kabi, tunum ami din ap-tunum ami am saal suunkup dok-dok-ke-balala, aptum ayo am saal baskaanba tap ke, ti suunkup God ayo dik-dakaalin-kup kemapla, kaata God akal, kapyo dong dokop-tokoma. Kemin, suunkup God ayo dik-dakaalin-kup ke-balawa yo. ");
INSERT INTO tif_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kawanta dik-dakamin ma dik-daalokoma namti, mafek mafek uyo kuluulokoma. Ale, kawanta mafek mafek ma uyo kuluulon o, kala din fenokoma namti, ata-mokoma. Aa, kawanta din saal dok-dok-ke-mokoma namti, saal uyo busolokoma no. ");
INSERT INTO tif_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Awak-aalap kipyo, kapni man ayo ma dik-daap-ta-lomda: Ima ma kup-nap inamnon o, tokokoma kaa, yak tuum kaata kolokomap o? Disa ti! Ima kaata kolap inam-nokoma te! ");
INSERT INTO tif_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kemin ultap o. Asuk dik-daap-ta-lomda: Aniing ma kup-nalap inamnon o, kala kaali, kuno kela yak inap mafak kaata kolap inam-nokoma nema? Disa ti! Aniing kaata-kup kolap inam-nokoma. ");
INSERT INTO tif_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ti kapkal utaman! Kabi ban wakamin tunum kemin, mafek mafek mafak kaayo, kapni man imi ma kuyilalap. Kata, kapni man ayo mafek mafek tangbal ayo man kukaayin-bam ilolap. La, Kaalap abiil tikiin kayaak God akal fan ban kemin disa tambal-kup tabasa. Kemin, almi man ipkal dik-daalip kaali, akal mafek mafek mafak kaali ma kuyokoma disa. Tifan mafek mafek tambal kaata-kup kukaayim-bam iloma no. ");
INSERT INTO tif_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kuno ti kapni aket fukunin ayo, nami nak-tunum kusal ita kukup tambal kukaap-nam-biliwa, yaap tambal-kup ilon o, kemap namti, kamosinim kawu kapsiik kanolin kukup tangbal kaata, kukaayim-balawa yo, kala-somla kemin; weng kalawaali, asiin sawaayak Moses aso le, weng ku-fatap-dakamin tunum iso, imi weng God ami Sukon Tem dola kutii-silip kaami miit namti kalabu. Kemin, kaata kanu-balawa yo, kala Yesus ayo almi kalaan tunum imi bakayinsa ko. ");
INSERT INTO tif_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Yesus ayo weng kusnum ma bokola: Suunkup as kiinin abip ami amitom liip kaali, sakbaalim dukum ale, liip kaa unsa kabang-ali fiitmin dinim o, kalaliwa, tunum unang deng yaapkan iyo liip kabang-ali tambal kawo! kalale, de kulii kabang balip unem-laabip. Katale, ili God kaa kambola biyang samaan kabang ban-ilomdiwa, maaklo ke-lokomip. Lale, God ami abip liip kaptam unemin amitom kaatale, atin liip katip kaptam bansa uyo ti fiitmin liip unsa kalaliwa, tunum unang yaapkan iyo kabang-ali fiitmin liip o, kalaliwa, kulaka-biliwa, unang tunum iip maakup maakup kiita-kup kabang liip unem-yaabip. Kemin, God ami suunkup ilin abip uyo kiita-kup ilokomip o, kala ko. ");
INSERT INTO tif_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesus ayo bokola ko: Tunum malo ma tal baka-bamdip: Nuli God ami weng ku-fatap-dakamin tunum o, ken-umbip. Lale, ili fan kasen-fakan-umbip. La, saak miyaan apliip tal sipsip ipnaal ayo kuluu kulaak tikila namti, kabi kaali sipsip atul dinim faluum ata no, kalokomap. Lale, kaa tifan siip miyaan atulim namti kulube. Kemin, telokoma te! Tunum kasen-fakamin tunum ili iltap, ita taba-lom tam-mafak daalokomip kanolin o. Kemin, utafii-bamdiwa yi! ");
INSERT INTO tif_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nuli yang ulup as tiyup diim kaa titam-daalupla, yet lap abuubu kalalup duk-duulokomup ema? Aa, yang ulup, misiil sok diim damaang abuuba kalalup duk-duulokomup o? Disa, nuli as kaa ma tabamna atafiimup tal aba tam lap ayo abuulu utam talaalupya, Lap tangbal abuubu ne? lap mafak abuubu ne? kebup tap, kasen-fakamin tunum imi kukup ayo dotu utafii-mokomap. Ayo ilmi kukup mafak uta kukup-tuya imi aket fukunin ayo mafak kayi! tukuya uta-mokomap ko. ");
INSERT INTO tif_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kanum bokosu kemin, ti kapkal as lap abuumin umi kukup uyo utam tam! As lap tambal abuumin uyo ukol ulmi lap tambal kaata-kup abuulokomu. Ale, as lap mafak abuumin ukol kuno ti as lap mafak kaata-kup abuulokomu kalin o. ");
INSERT INTO tif_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kemin, as tambal uyo mulo kawu, asuk as lap mafak ayo abuulokomu disa; as mafak abuumin ukol mulo kaa asuk as lap tambal kaa abuulokomu dinim; ti tituun ulmi abuu-bulu abuu-bulu ke-mokomu no. ");
INSERT INTO tif_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","As uyo ma lap tambal abuumin disa kemu namti, as kayaakim ayo tam aba-lom as uyo an-duula kuyak daala, as kiin-abam-nokoma. Ultap kemin, ilom am ma daanokomu kaali, kasen-fakamin tunum kiili, God alalta fokola yang as kiinin abip unokomip. ");
INSERT INTO tif_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kemin kabi mep profet ilmi kukup mafak kabak-ata utamdawa, kiili kasen-fakamin tunum namti kulu-bom-bilip o, kalokomap kayi! kala Yesus ayo almi daang bakaalin tunum imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kulaa, Yesus ayo titil tibin weng ma bokoyila ko: Tunum unang yaapkan yam iyo bakap-nam-bamdip: Kabi numi kamokim kemin, Nuli kapni ok kaata-kup kutal-fukup-tokomup o, kem-yaabip. Lale, disa; ilmi weng baka-bamdip: Nami Aatumen abiil tikiin kayaak ami weng uyo weng san-kaamin disa, kem-yaabip. Kemin, kiili imbii tam God almi abip daalokoma disale, atin ti disa. Dok nolin tunum kipta God ami weng uyo kutal-fukusip namti, kiita-kup im-tam God almi abip kaa daalokoma no. ");
INSERT INTO tif_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Am mafiing diim tiltam tabamnula, unang tunum lii-bam afet-mokomi diim kaali, unang tunum yaapkan ili tal nami tiin diim mepso kuluba bokop-na-lomdip: Kamokim kapyo, Nuli kapni win diim God ami weng ayo kukaayinsup. Kapni win diim sinik mafak iyo fotabamnup yak bane-bam ale, kukup kusnum akal alik akal alik iyo kuyim-bam kem-yaabup te! Kulaa, kapkal utamsap kemin, nuli kapni tunum unang te! ke-mokomip. Katale, ");
INSERT INTO tif_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","nali bokoya-lomdi: Ibi God ami weng uyo kutal-fuku-tabuulalip dinim ke-lom kukup mafak kaata-kup kutal-fukusip. Kemin, ibi nami unang tunum disale, ibi nali ma itamsi disa. Kemin, kuno kep-na unin aa, yokokomi no, kala Yesus ayo almi daang bakaalin tunum imi kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesus ayo asuk faldak-tiimin sang ma bokola ko: Dok nolin tunum ata nami weng kala bakabi kaayo, weng san-kaa-bamda nami kukup tangbal uyo kutal-fukula namti, ali kanolin weng kala bokolokomi umi kukup tabuulin tunum alaltap namti kulube. Am tangbal dinamin tunum ma ayo din am kun bobi kulii-tal tii kelale, afun tem ayo kala-bala umbilaak unu kela, am kun ayo kumola daak daak keba, kambola am ayo de kulaa kela, tam am un-ilomdip alimal sin-yaa-biliwa, ");
INSERT INTO tif_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","kulaata om so, ati so, tiltam taba-lom ok fakan tiltoop ilomda am ayo balata kulii-unokin. Yale, am ayo tangbal ma kela dese kemin, disa tiltoop dik-yak saanbi kewa ko. ");
INSERT INTO tif_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ale, dok nolin tunum ata nami weng kala bakabi kalaayo, disa tinang-kup umu-bomda nami kukup tangbal ayo kutal-fukulin dinim kema namti, kalanolin sang kala bokoyokomi umi kukup tabuulin tunum alaltap namti kulube. Tunum ayo aket tangbal ma fukunin disa ke-lomda daal-kup tibin tunum ma ayo taang-kala titil foko am tangbal kaa delokoma disa. Am kun tem ayo kala-somdala disa ti. Disa kulu kuyak tip kulu tii delaya, ");
INSERT INTO tif_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","kulaata om so, ati so, tiltam taba-lom ok namti fakan-tiltoop ilomdu am uyo wela daak abamnuya, ok ta balata kuliila unsa no, kala Yesus ayo weng do kala bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus ami weng uyo bakayinsi alik dinim nu, kelale kulu, tunum unang yaapkan weng, weng san-kaabip iyo tiin alik tambanu aket fukun-bam, ");
INSERT INTO tif_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ap-tunum kusal bokola una-tala-ke-bamdip bokolip ko: Kwin! kaami weng kukuyin kukup kaali ti akal almi kusnum ti! God ami aket fukunin uta utam kaal ke-somdaya, numi dotu kukuyimba. Lale, numi lo utamsip tunum kalawiita nuli kanola dotu kukuyilalip dinim o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kulaa, Yesus ayo amdu tikiin kulaa kela tildaak aba una-balala, unang tunum yaapkan iyo yak Yesus daang bakaalip aso, maakup unip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Una-biliwa, kulaa tunum angtiil mafaksa ma aptum kusal ita fotabamnip yang saak kawu tiinsa ayo, Yesus ami fanang taldang ilomda tilik duung fakela daak tiin-ilomda bokola ko: Kamokim kapyo, kabi ti yaap kemin, dong dokop-non o, kalap namti, nami angtiil kulaa mafaksu kuluwa dotu-namulan o, akale, ");
INSERT INTO tif_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","kulaa, fan Yesus almi sikil ayo kulii yak tunum kaami angtiil diim kawu kuyak tii bokola-lomda: Ayo, nali dong dokop-ton o, kalaliya kemin, kulu talalu-tamuli yaap-namap, aka kem-salale, kulu tunum kaami angtiil mafak ayo kasentap-siik tambal-kup ke tunum kasaa kelaya, ");
INSERT INTO tif_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesus ayo bokola ko: Kabi din ilomdap nami dotu-tamuli kaami sang uyo tunum kusnum imi bakayin disa taa! Kuno keya din lotu am dukum kaptam ban-ilomdap kapni angtiil ayo awem tunum pris ami diim kawu kukolap atam-somdala, U! fan kaali disa kep-tu no, kala bokop-tale kawu, Moses ami sawaayak weng kuka-daasa kaata-kup kutal-fuku-somdapla, kapni mafek mafek ma God ami kola-lomdap yaap ke yo, kalawa, unang tunum iyo titamiwa, U! fan kulu kabi yaapnap kala kala-somdiwa kawu, asuk tam-taldang daalin o, takak o, aka ko. ");
INSERT INTO tif_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kemin, kulaali Yesus yak aba din abip Kapeneam kaptam banala, Rom kasel imi waasi dinin tunum wan handret (100) imi kamokim kesa ayo atam ale, bokola ko: ");
INSERT INTO tif_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nak-tunum kapyo, dong dokop-nan. Nami ok fukulin tunum ayo olduuk fuk-dola-balaya yaan-yaan kulaaso, niil-alomda angtiil atul dukum-kup daka-bamdala am abiin kawu tiinba no, akale, ");
INSERT INTO tif_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","kulaa, Yesus asiik bokola: Ayo, nali kapso din ilomdi dap-talalulokomi taa! akala, ");
INSERT INTO tif_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","waasi dinin kamokim asiik bokola ko: Daa, nali tunum tambal disa; nali ti ban kemin tunum kemin, kamokim kabi timbi din nami am kaa unokomi disa; nakal nalmi dabom ami weng-kup weng san-kaamin tunum ale, nali waasi dinin tunum ilmi-kup deng 100 kalawiimi kamokim tiin molin kemin, nali tunum ma ami bokola-lomdi: Unan aa! akokomi, ayo unokoma le, tal aa! akokomi, ayo talokoma; aa, kuno nali okok kemin tunum ami bokola-lomdi: Yak kanolin ok kaata kanuman o, akokomi, ayo yak nuu-mokoma. Kanolin kemin ale, kabi yaap titil so yaap kemin, kuno kela weng kulaata-kup bokolapya kulu nami ok fukulin tunum ayo tambalnak o, aka ko. ");
INSERT INTO tif_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus ayo kanolin weng uyo weng sanba-kup, aket kong-mo fal-siki titoop daa unang tunum almi mepso kulu tiinaabip imi bokoyila ko: Nali tituun weng bokoyokomi kemin, weng san iliwa! Nali Israel-miin kipni iipyak tem kulu tal-unen-umbi uyo Juda kipni aket ayo fukun-bamdip: Nuli God ami man namti kala bom-bulup kayi! kem-yaabip. Lale, nali ma atamila, ali ma nitam, U, Yesus ali ti yaap kukup alik kanolokoma keba, kaa ma atamsi disa. Rom tunum kalaami aket fukunba uyo, utamaya, Yesus ali daa; weng kulaata-kup bokolaya nami okokmin tunum mafak bomda yang am bombe ayo yaap-nokoma no, kalalaya, ali tal bokop-na. Kemin, ami nami lak duula uyo sakbaalim dukum keluya, alik Juda kipta nami lak duup-na-laamin uyo daak banin ko. ");
INSERT INTO tif_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nali weng ma bokoyokomi kemin, weng san iliwa! Alik am bokon kala be kaami unang tunum balang balang yaapkan iyo tala-tala-ke ang-de-lom (Juda iip maakup maakup iso, imi bak-duu-lom kuyaku-diyaku-ke-lom) din God ami abip kawu God almi man alik-daap keliwa, numi awaalik Abraham so, almi man Aisak so, alim imi man loop Jekop aso, tiin-bomdiwa, ima ina faka-bam fiyaap duu-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yale, Juda yaapkan nuli God ami man namti kula bulup o, ken-umbip ili din God ami abip unokin la, ili din God ami abip kaa unokomip dinim; uktakan kuu-lomdip God ayo tam taba nuli daang ukuya-lomda im-baala tiltam saak kaltamu bom-bulup kalaliwa, Kwin kalaaso kawi! kalokomip. Kemin, kiili angtiil yol dap-tiiya bom-balaya, ilmi angtiil kalan uyo ama-mokomip kayi! yimba-kup, ");
INSERT INTO tif_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","fal-siki-taba waasi dinan tal-unemin imi kamokim ami bokola ko: Kabi utamapla, faneng ali yaap dap-talalulokoma no, nambap kalaliya, dap-talaluli kemin, dindapla am kawu utaman a! aka ko. Akan-kaa-bamda kama weng kulaata bakaala unan-salale, waasi dinin imi kamokim ami ok fukolin tunum ayo tambalna ko. ");
INSERT INTO tif_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ayo yaapnale, kulaa Yesus ayo yak aba din Pita ami am din ula, Pita ami imnon uyo angtiil mamin dukum kutiiwa-bala, mafak umu bomdu abiin tem kabaaku bombu kala kalale, ");
INSERT INTO tif_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ami sikil ayo kuyak tii malewa kem-salale, umi angtiil mamin ayo disa kelula, tiltam tiindu Yesus nikil imi ima uyo talalu ku-mikil daayu ko. ");
INSERT INTO tif_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kanola wam-talalula bombii am atan ayo tilbanon e, ke-bulule, abip kasel iyo unang tunum yaapkan sinik mafak ta yam-mafak-daasa iyo dii dibii tal Yesus atamipla, Yesus ayo sinik mafak iyo weng bokoya fotabamna tabaniple, unang tunum mafak umkaan-unsip iyo alik talalu-yimula yaawa-yaa-bala kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Siin sawaayak kawu, Yesus kaa tilin disa bom-balaya, profet Aisaya ata Yesus ami sang kaali, God ami Sukon Tem kabaku dola boko-lomda: Nuli mafak umu baluus-kup taba keluwa, ata taba-lomda talalu-yimuse no, kalala dola kutiisa. Kemin, Yesus ali kanolaya, fan Aisaya ami kanum bokosa uyo tituun tiltam tabasu no. ");
INSERT INTO tif_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesus ayo itamala, Unang tunum yaapkan iyo falala-namulip kala kalale, almi ap-tunum kusal kalaan tunum imi bokoya-lom: Uniwa, nikil tam bot tem abalup umbiyak ok kumun umi malii kabak banum i! yakale, fan ");
INSERT INTO tif_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","unum o, kala taba kem-siliple, lo utamsa tunum ma tal Yesus ami bokola ko: God ami weng kukuyin tunum kapyo, kapni dok kanolin kawu tal-unemap kaa, nali ti kapso naso maakup tal-une-mokomup o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus asiik ami weng maan tela bokola ko: Sinokim ali tawaal tem kabaaku tem kalabi kuu-tiile, iim de sin-laabala le, awon yakal kuno ilmi iim tem kawu sin-yaa-bala, ken-umbip. Lale, Dukum Ami Man Nata, sin-yaamin am kaa disa; ti kapkal talalu aket kaa fanang daalawa, naso tal-unemon o, kalbap elile? disa? aka ko. ");
INSERT INTO tif_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kulaa, tunum kusnum ma Yesus ami daang tem talaba ata bokola: Kamasi kaa kuno kep-napla, asuk din-ilomdila, abip kawu nalmi atok ayo tiin mo-bom ilila, saaknala kawu, dibii din dawaalila, asuk kapni fanang talokomi kayi! akale, ");
INSERT INTO tif_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesus asiik ami weng maan tela bokola: Daa yo. Kabi unemin daa yo, kela tildang nami daang bakaalin tunum ke-lomdawa yo. Tunum kanta nami daang bakep-tokomup disa yo, kalbip ilta-kup aptum kusal taanip iyo imbi din ima-laamik. (Ale kabile, din God ami weng kaata kulii-din unang tunum imi bakayim-balawa, iyo God ami lak duu-lomdiwa, tiltam God ami man ke-lomdip suunkup ilin unang tunum kelin o,) aka ko. ");
INSERT INTO tif_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus so, almi ap-tunum kusal iso, nikil iyo bot tem tam aba-lom tabanip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nikil iyo una-biliwa, wok kumun aalap dukum kemin, umbilip umbiyak wok daang iip iip kabaniwa, inim dukum ma abiltap tabamnala, ok uyo fola kulaala tiltam bot tem ayo talebu. Kata, Yesus ayo ti kano akan-bom-balala kemin, ");
INSERT INTO tif_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ami aptum kusal iyo yak dap-kafang ale, bokolip ko: Kamokim a! Nuli mepso saak daalum o, kalup kemin, baan tam tiindap dong dokoyilap yaap kelum o! akiwa, ");
INSERT INTO tif_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","fan Yesus asiik bokoyila ko: Ipkal utamiwa, Awu, Kamokim ali nuso bombe kemin, nuli kaal dinim; abiin tangbal tiinbup kalolip disa. Ibi kanimin o, kalaliwa, wok ami atul kaata, suunbip yoko? yinba-kup, kulaali tam tiin tola inim so, wok so, iyo bokola ko: Mep inim so, wok so, kunuubip kulaa, ditang kalin! yaka-kem-salale, kulaata inim dukum so, wok so, ditang kala dinimnip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nikil alik iyo utamiwa yi, Inim so, wok so, iyo ami weng kaata-kup weng san-ilomdip dulumnip kala-somdipla kawu, imi fanang maaklo keyilule, bokola una-tala-ke-bam bokolip ko: Kwin! kalawaata dok kanolin tunum ata taba-bomda weng kulaata-kup bakam-salale, inim dukum so, wok so, kii ami weng-kup weng san-ilomdiwa disa kelip i? kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesus inang iyo bot tem umbilip umbiyak ok balang malii Gadara kasel imi bokon kaptam baniple, Nikil iyo yak itamipla, kulaa tunum alep ma iyo tunum taanip imaasip imi kom tem kawu bom-laabipla, iyo tal Yesus ami diim abamnipya, itama kaali, siin sawaayak kaptoowu sinik mafak ita tunum alep imi yam-mafak-daasip. Kemin, alep ili ban boko-bilipla, unang tunum iyo imi atul kaata, itam suun-bilipla kemin, kom tem unemin kaami liip mepso ayo yang unemin disa ken-umbip. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tunum alep iyo Yesus kaa atam-ilomdip atin atul fuut-bam disa akal ma ke-bam iyo bokolip ko: God Ami Man kapyo, Kabi tal-ilom kanimin ma numi nuuyon o, kalalapla, talbap i? God ami im-bak saan-bam lek ilin am kaa kama daan tiltam tabin disa bombuu kaldaku talap kaa, numi angtiil yol awak kaa kuyon o, kalalapla talap ema? Kwin! kaa kano-laamin disa yu! kala kanum bokolip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akiwa, nikil ilmi tola-bom-bilip, ami du kabang lo kawu, kang yam ma bomdip bak-fakaneng tababip kala itamiple, ");
INSERT INTO tif_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kulaata, tunum alep sinik mafak imi iipyak tem tiinsip iyo Yesus ami bokola-lomdip: Nuli fotabamnon o, kalap namti, fotabamnap yak kang imi tiling tem un-ilom mep tunum alep kalawiiyo kamboyila unum o, akiwa, fan, ");
INSERT INTO tif_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus ayo bokola: Na, kamboyila unin a! yaka kem-salale kulu sinik mafak iyo abiltap tunum alep iyo kamboyila yang kang imi tiling tem uniwa, kulu kang namti alik aket fanang dinim keyila abiltap bina dilila diim dap-kuldaak-mo yak aba umbilaak ok Galili kumun tem din daa-lom wok ta yan dong dokola taanip ko. ");
INSERT INTO tif_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kanoliwa, kulaa kang tiin molin tunum yakal utamiwa yi, Kwin! kang namti kanola taan kuliila tabamnip kalale, bina yak aba din abip un-ilomdip abip kasel unang tunum imi kang kanolip kaami sang uyo bokoyila-som ale, mep tunum alep sinik mafak ita yam-mafak-daasip imi sang uyo bokoyila no, kelipla, ");
INSERT INTO tif_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","kawu unang tunum iyo kanolin sang ayo weng san-somdiwa abip kambolaliwa, yak aba din Yesus ami fanang din atamum i! kalalip din atam weng dukum-kup kola-lomdip: Kabi numi bokon kalawaali kulaa kelalap tabanan o, kala-lomdip fotabamnip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kanoyiwa, Yesus nikil iyo asuk tam bot tem abalip tildak ok kumun malii kaldaku bom-bilip ayo kulaa asuk yak malii abaliwa, kulaa kela asuk ilmi abip unip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Din uniwa, tunum nikil ma aptum angtiil taan dikiksa ayo abiin diim una dalaa dibii tal Yesus ami fanang dap-tal daaliwa, Yesus akal itamala yi, Tunum nikil iyo atamipla, Yesus ali ti faneng nak-tunum kulaali, dap-talalulokoma kala, kal-bomdip kanubip kala, kalba-kup tunum angtiil alik dibim-ansa ami bokola-lomda: Nak-tunum aa, nali kapni ban uyo alik takan-tiip-ti disa kelu kemin, fiyaap duuman a! aka ko. ");
INSERT INTO tif_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kanum bakamala, lo utamsip tunum malo ma iyo weng sandiwa, aptum kusal imi bokola una-tala-ke-bamdip bokolip ko: Kwin! fan mep tawaal diim tunum kalawaali kasen-foko God ami okok kema kawo! kala-lomda God ami win ayo ku-mafak-dakaanba kawi! akan-kaamiwa, ");
INSERT INTO tif_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus ayo imi kanolin aket fukunbip iyo uteya-lomda bokoyila ko: Ibi kanimin o, kala kanolin aket mafak kaa fukunbip i? ");
INSERT INTO tif_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nali kalok nolin mafek mafek kanu-biliya, ibi abiltap nitam-ilomdip Kaa faneng bakaba nu nokokomip i? Nali bokoya-lomdi: Kapni ban kaali, takan-tiip-tili kayi! kalokomi kaa, ibi utamin disa ke-somdipla, ibakaba no, nokokomip. Kemin ale, aa bokoya-lomdi tam tola unan o, kalokomi kaata, utamdipla, Kuuli faneng bakaba nu, nokokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ipkal utamin! Nali God Ami Man kemin, nami titil dukum kaata kukuyim-bilila, ibi utamiwa, Ali ibakaba disa; ali tawaal diim kala tal bombe kaali, yaap unang tunum imi ban takan-tiiyokoma no nokokomip o, ke-bamdale, kulaa, tunum angtiil dibim ansa ami bokola ko: Kabi tolalap kaltapni abiin kabaaku tim-bilip tilip uyo, kuluu kutamalap kalapni am unan o, aka-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","kulaa, fan tunum ayo tam tola almi am una ko. ");
INSERT INTO tif_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kanolaya kawu, uyo utam-somdiwa kemin, unang tunum kii utamdiwa atin aket kufoyilu suun-bam God ami win ayo kufon-bam ale, ami win uyo bokola una-tala-ke-bam ale, God alalta taba-lomda tunum kaa titil kolaya, yak kanolin kukup akal kusnum kaa kanola no, kal-bomdip awolmip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus ayo tunum angtiil dibimnin ayo dap-talalula unaya, am ayo kambola yakyak din takis kaamin am ofis din ula, takis kan-umba tunum Matyu nayo tiinbi kaa kala din nitam ale, bokop-na ko: Nak-tunum a! kabi nami daang bakaalin tunum kelawa, naso nikil um-bomduwa, nami okok kaasiik ma kup-tiya, keman o, kalale, fan nayo tola yak Yesus ami daang abila unsup ko. ");
INSERT INTO tif_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tabamnila, Yesus nikil iso, naso, nikil ofis ayo kamboli din nami am kawu ima im-buluwa, takis kaamin tunum yaapkan malo iso, aa kukup mafak kutal-fukulin unang tunum malo iso, tala-tala-kelip Yesus akal ami ap-tunum kusal iso, kuyaku nikil ang-de ima im-bom iluple, ");
INSERT INTO tif_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Falosi malii ma ita utamiwa yi, Yesus ali kanumin tunum iso, ima imba kalaliwa, Yesus almi daang bakaalin tunum imi dik-daayip: Kipni kukuyilin tunum kaa kanimin o, kalala tal itamala takis kaamin tunum iso, kukup mafak fukulin tunum malo iso, nikil tiin-bomdip ima dakaap kaa inbip yoko? Kaami kaa kanuba kaali mafak o, kemipya, ");
INSERT INTO tif_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus ayo weng bakabip uyo weng san-somdala asiik bokoyila ko: Nayo faldak-tiimin weng ma bokoya-lomdi: Dokta ali tal tunum mafak-umulin dinim, ili yam-talalulokoma disa; ali tal tunum mafak-umulin ita-kup, yam-talalulokoma. ");
INSERT INTO tif_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kanolin kemin, nali taldila tunum unang iyo boko-lomdip: Nuli ban kemin dinim ale, nuli ti tituun-kup tabin unang tunum o, kebip kiita, nali tal kiimi dong dakaayin-bilila, imi aket kaata fal-kela-lomdip God ami lak kaata duulin o, kalalila talsi disa; unang tunum kanta boko-lomdip: Nuli ti ban kemin unang tunum o, kebip kiita, nali taldi dong dakaayin-bilila, imi aket uyo fal-siki-lomdip God ami lak kaata duulin o, kalalila, talsi no. Weng kala bakayimbi ayo, kipkal God ami Sukon Tem uyo fan tik-tii-bam mep weng kaa bakabi kaami miit uyo soko utamin a! Weng anung uyo boko-lomdu: Nami tiin diim uyo kipni taloop kulii-tal anu God ami kola, numi ban wakamin ayo molum o, kala kukaap-nin kulaali, katip so ale, ap-tunum kusal imi kukup tangbal kukaayin kaata, nami tiin diim uyo sakbaalim dukum kemin, ibi ti kanu-mokomip kaata, nali kipni fiyaap dukum ayo duu-mokomi no, kalsa no, Yesus ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oksam ukayin tunum Jon Baptis ami kalaan tunum iyo tal Yesus atam dik-daalip ko: Nuso, Falosi so, numi kukup ayo iip maakup maakup kaami beten kemum o, kalokomup kaali, Nuli inin kaa kela fala-bomduwa, beten ken-umbup. Yale, kapni kalaan tunum ilile, inin kaa falamin disa, beten ken-umbip kaata, kanimin o, kalaliwa ili inin kaa falamin disa ken-umbip yoko? kaliwa, ");
INSERT INTO tif_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus asiik imi weng maan tiiya ko. Almi saak-nokoma kaami sang kaata faldak unang tunum fokolokoma imi diim tii bokoya-lomda: Tunum ayo unang kuluulokoma ayo tunum iyo ima fuu-bam in-bom fiyaap duu-mokomip ko. Kanu-mokomip kaata, tunum kusnum ma ayo yaap o kala bokoya-lomda: Ibi fiyaap duu-bam inin daa, kemin, aket uluum tabe-bam inin kaa falamin o, yokokoma nema? Disa. Tunum maaklo ili utamipya, Nak-tunum ali nuso bombe kalalip fiyaap duu-bamdiwa, ima inokomip. Lale, bombii kaptoowu, waasi ita tal imi aptum ayo dap-tal fukulip kalokomip kaa, aptum kusal iyo aket uluum dap-tiiyilaya, inin ayo falaalokomip o, kala Yesus ayo faldak-tiimin weng bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kanum bokoyilale, Yesus ayo (Juda kayaak imi itam ale, ilmi siin kukup kaata dukum-kup kutal-fukusip. Lale, nami kama kukup uyo kutal-fukulup disa yo, kalbip kalalaya,) asuk do eng alep ma bokoya-lom: Unang uli falewala kama alokso ilim fulduu kulii-tal diingnin disa buu, kaa ma ukduu kutal aba yak siin ilim balata-tababu umi diim tii bikilokomu no? Disa. Kanolokomu kaalile, diing-nokomu kaa alokso ilim uta taba-lomdu aluula kutiilokomu. Kemin, kulin diilu fongnu asuk mikilokomu ayo nakat-moluya, siin ilim disap uta abiltap biki taba-lom tem dukum ke-lokomu. ");
INSERT INTO tif_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aa, ti kalawaakal kanolin o. Tunum ayo meme ipnaal siin kawu dilduu kutiila fongbu umi tem kaptoowu kama alokso wain ok ayo iluula dongna kalale, sok ta kuluu tem ayo de katii kutama tal am tiila namti, ok ayo bombile, fasun-um-bom ale, meme ipnaal filit disa ayo fasu fasu um-bom abiltap-siik bikin-ilom ok ayo tiltamba talokoma. Aa, ipnaal ayo atin mafak-alomdu balata tabam-nokomu. Kemin, tunum alokso wain ok ayo iluulon o, kala namti, meme ipnaal kaa kama dilduu kutiila tootnin dinim, bombe ata-kup kuluu-lomdala, wain ok ayo iluu kulii-tal tiilokoma kaata, meme ipnaal so, wain so, alep kano yaap ilokoma no, kala Yesus ayo weng do alep kii bakaya ko. Kemin, weng do kabak-ali boko-lomdu: Nali kama kukup kulii-tal kipni siin kukup umi anung til-daayon o, kalali talsi disa; nali kama kukup kaata-kup kulii tiliya kaata dotu kutal-fukulin o, kala kulii-talsi no, kalsa ko. ");
INSERT INTO tif_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus ayo kanum baka-bam bakayin-salale, Juda imi kamokim ma Yesus ami fanang tal katuun duung fakela daak tiinda bokola ko: Nami man unang uyo ti kamala kulu taanula, utam kewa tili. Kemin, baan talap alep din ilom kapni sikil kaata, kuyak tiilapla, tam tiinuk o, kalaya ");
INSERT INTO tif_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","kulaali Yesus aye almi aptum kusal aye, iyo kamokim aso, unip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kuno unang ma bombuu kuuli, suunkup ulmi am unemin-kup kebii wasital talangkal dakan-tiisu. Kemin, uyo tal Yesus ami daang tem kulu tal bomale, aket fukunu ko: Nali yak Yesus ilim mikiba kulaata maaklo yak malelila nam-talalulala, tangbal kelon i! kala kanolin aket ayo fuku-daabu-kup, umi sikil ayo maaklo kuyak Yesus ami ilim matum diim kulaata-kup kutal-fuku kemula, ");
INSERT INTO tif_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus akal utamala, Ma tildak malep-na kala kalale, fal-siki titoop daa, utam bokowa ko: Nafalop kupyo, nali utamila, Kubi fan ali yaap nam-talalulokoma no, kalbap kalalila tam-talalulila, tambalnap kemin, fiyaap duulan a! waka-kem-salale, maak fak-daalin tap tambalnu ko. ");
INSERT INTO tif_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kanola Yesus yak aba tal kamokim ami am uyo tal ula, Tunum saakna kuwakamin umi olenin fongket dakaamin tunum iyo fongket ayo dakaa-bam ale, unang tunum alik yaapkan iyo tal dukum-kup ama-bam tulu tale-bamdip kebip kala tal itam ale, ");
INSERT INTO tif_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","bokoya ko: Kipyo, unang man kuuli taanbu disa; uli akan-umbu kemin, ibi amamin disa; kuno kewa tambanin a! Yakan-kaamale, unang tunum yaapkan ili kulaa kasen-fakaba no, kalalip aban kulil-telip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kulaa, Yesus ayo unang tunum yaapkan iyo yan-bak mola tambaniwa, Yesus ayo unang man ulmi sin-yaabu abiin tam-ilomda sikil um-tal fuku kem-salale, kulaa man unang uyo tam tiinula, ");
INSERT INTO tif_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","uyo kanowaya unang tunum iyo yak aba din abip ma ma un-ilomdip Yesus ami kanola kaami sang kaata, bakayila-tal-une-bilip dukumnu ko. ");
INSERT INTO tif_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus ayo mep am kaptam kuno kela una-balaya, kulaa tunum tiin fiim alep ma Yesus ami fanang yaan tem dikela tal bokolip ko: Kamokim kapyo, kabi King Devit Dukum alaltap kemin, kabi numi olen-daaya-lomdap kapni titil ata kuluu-lom dong dokoyan o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kemipla, Yesus ayo tam am banaya, tunum tiin fiim alep yakal ti Yesus ami daang tem tam uniwale, Yesus ayo alep imi dik-daaya: Alep ibi fanang daaliwa, titil ata yaap alep numi tiin kiiyo, dotuya dong dokoyama kalbip ema? yakala, Yesus ami weng bokoya uyo alep isiik bokolip: Ayo, kapta titil soyap kemin ale, dong dokoyokomap kala kalup te! kaliwa, ");
INSERT INTO tif_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","kulaa, Yesus ami sikil ayo kuyak tunum alep imi tiin diim tiiyale, bokola: Ibi utamipla, Ali ti almi titil ta dong dokoyokoma nikip kemin, kulu dong dokoyi no, yakaya, ");
INSERT INTO tif_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","tunum alep imi tiin ayo tambal-kup keyilula kulu, mafek mafek namti atamiwale, Yesus ayo dukum-kup bokoya-lomda: Talalu-yimuli kaami sang uyo kulii-din tunum malo imi bakayin disa kayi! yaka. Katale, ");
INSERT INTO tif_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","tunum alep iyo Yesus ami weng kanum bokoyila uyo weng sanamip dinim. Kuno kela din abip kusnum kusnum uyo tal-une-bamdip imi tiin dotuyila kaami sang uyo bakayila-tal-une-bilip dukumnu ko. ");
INSERT INTO tif_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tunum alep iyo Yesus kelalip uniwa, tunum kusnum ma asuk Yesus ami fanang dibii tilip kemin, tunum kaali sawaayak kawu sinik mafak ata dap-mafak-daalaya, weng abat kesa. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus ayo sinik mafak ayo fotabamna tabanala, tunum ayo kulu weng namti bakan-tabamna atamdipla, unang tunum iyo weng san-ilomdip tiin alik tam baneyulu bakamip ko: Kwin! kanolin kukup kaali kaa akal alik i! Israel-miin nuli kanolin kukup kaa siin kaa ma utamsup disa yo, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kanumip. Lale, Falosi ita bokolip ko: Daa, kulaa sinik mafak imi kamokim Setaan ata titil kaluung kola-balaya, sinik mafak kii fotabamna wakadaa unen-umbip o, kalip ko. ");
INSERT INTO tif_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus ami abip ma ma tal-unen-umba kaali, yak aba din lotu am tam-ilomda unang tunum imi kukuyim-bam ale, God ami weng tangbal kaata, bakayim-bam bokola: Ibi aket fal-sikilokomip kaa, God ali kipni ban wakamin ayo takan-tiiya-lomda im-tama tam almi miit tem daale tiin molokoma no, kala bakayim-bamda unang tunum imi angtiil umulin akal alik akal alik kan-unsip imi talala yam-kaa-bam kem-tal-unema ko. ");
INSERT INTO tif_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesus ayo unang tunum yaapkan kalawiili itama yi, Sipsip tiin saanin tunum kamboyip ilifin bomdip liip kelalip babon-babon-kem-tal-unebip ililtap ke-bam God ami tituun-kup tabin liip uyo utamin disa, kelipla, kawanta nuli dong dokoyokoma ni, kal-bomdipla aket yamyam takan-tabasip kalalaya, atin ti ol mokop dukum kukaayim-bamdala, ");
INSERT INTO tif_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","almi kalaan tunum imi faldak-tiimin weng ma bokoyila ko: Tunum unang yam iyo God ami weng uyo, weng san-kaamum o, kalip kiili, wiit yakaana-yaaba altap. La, wiit dakamin tunum kiili, mep iip maakup maakup alep ma kiita. (Mep wiit dakamin tunum kiili, God ami weng kulii-din unang tunum imi kukaayin ita kemin,) ");
INSERT INTO tif_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ibi God ami beten kaman-bilipla, akal okok kemin tunum yaapkan ulela-lomda im-baala tal kipni diim abamnipla, kipso maakup din unang tunum imi God ami weng uyo bakayin o, kala faldak-tiimin sang uyo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus ayo ap-tunum kusal talangkal imi naan-daayila tildang tiliwale, almi titil kuya-lom bokola: Kibi nami win diim kaata, sinik mafak iyo fotabe-bam ale, unang tunum alik angtiil mafak umulin akal kusnum kusnum fakan-unsip imi yam-talala tal-une-biliwa yo, kala kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Almi kalaan tunum talangkal ulelsa imi win namti kalawiita ulelsa ko. Diildiil kulaali Saimon so, almi niing Andru so, ita ko. Yesus ali Saimon ami kanum bokola ko: Kapni win ma kaali Pita kayi! aka ko. Ale, alep ma imi win kiita, Sebedi ami man Jems so, almi niing Jon so, alep yakal; ");
INSERT INTO tif_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Batolomyu yakal, Tomas, Matyu, nakal nali takis kaamin tunum kemin, sukon kalawaali dolbi ko. Alfius man awasekim Jems aso, Tadius so, yakal, ");
INSERT INTO tif_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kuno Rom kasel imi itam fananin tunum awasekim Saimon akal, Yesus dap-fatap-daalokoma tunum abip Keriot kayaak Judas akal, ita-kup ulelna ko. ");
INSERT INTO tif_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesus ayo almi aptum kusal iyo fokoli din nami ok kaata, okoknala unin o, kalalaya weng ayo bokoyale, Israel ili God ami kukup uyo kela-lomdip kiili, sipsip babon babon ke-bam maaklo kesip tap kesip. Kemin, ipta din yal-mokomip. Kemin, ibi din Sameria kasel imi abip kawu tal-unemin daa; aa, tunum kusnum imi abip aye, uyo tal-unemin daa; ibi ti yak aba din Israel imi abip kiita-kup tal-une-bamdiwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ibi din abip kaptam kayaak ita-mokomip uyo bokoyilalip ko. God ami unang tunum im-tama tam almi abip unemin uyo mepso dikiwa tulu kayi! yimbip-kup; ");
INSERT INTO tif_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","mafak-alin umu umu umkan-unsip iyo yam-talal-bam ale, saaknip aye, iyo asuk imfu-bam aa, angtiil mafaksip imi yam-talal-bam, sinik mafak imi fotabamnip unang tunum iyo baa tukuya yak bane-bam kemin o. Sawaalak kaali, God ali ibi masiim kawu yam-talalula tiltam ami lak duubip. Kemin, ti ipkal kap-tunum kusal iyo disa masiim talal-yim-biliwa yo. ");
INSERT INTO tif_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Unokomip kaa, moni so ma abu kulii-unemin daa; ");
INSERT INTO tif_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","aa, ima men, ilim alep, yaan ilom, katil kiiso, kii ma kulii-tal unokomip daa; bung foko diliilip unokomip kiili, ti iltipni ilim mikibip kuliita-kup kano mikibip ti tal-unemalip ko. Ibi ti kukup tambal kaata-kup kutal-fuku-bomdiwa, unang tunum imi kukaayim-bam dong dakaayokomip uyo yakal ti kanola kukup tambal kaata-kup kukaayokomip. Kemin, ibi bung mafek mafek uyo ma iip-nokomip dinim o. ");
INSERT INTO tif_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ibi din abip ma kabanokomip uyo fen-bam tunum ayo ma atamip ayo bokoya-lomda: Ti yaap ke tilip o, yaka atamip namti, ami am kawu aso bomdipla, unang tunum imi dong dakaayin-sile, kawu abip kaptam kulaa kela ti kanumin-kup yakyak kem-tal-une-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ipni din am unokomip ayo am kaptam kayaak iyo weng umuuya, Nak-tunum kusal kaa tambal-kup bom-bilip o? kalalip kanum bokoyin o. ");
INSERT INTO tif_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Unang tunum iyo bokoya-lomdip: Ti yaap ke tilip kalalip im-tam ilmi am daalip namti, ilom keyila unum o, kalokomip uyo bokoya-lomdip: Dukum alalta-kup ibi alik tiin molaya tambal-kup bom-biliwa yi! yakale keyila unokomip. Ale, ti yaap ke tilip kalalip im-tam ilmi am daalin disa kelip kaa, ibi weng tambal-kup umuuyila unemin daa. Kuno kamboyila unemin o. ");
INSERT INTO tif_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Am kaptam bom-bilip aa, abip kasel aa, iyo im-tam daa tiin mo-bom kipni weng ayo weng san-kaamin dinim kelip namti, Juda nulmi kukup ma kaata, kuluu-lomdipla, abip kaptam ayo kambola unolip ko. Nulmi kukup kaali, sung ilol tal aba yak kipni yaan diim tabuuba uyo diliit-mo kulaalip yak abip kasel imi diim kabamnula kawu, abip kaptam-ami unang tunum iyo utamiwa yi, Asuk ilom kaa maso tal abip kaltam nuli dong dokoyokomip disa yo, kalalip utamik o. ");
INSERT INTO tif_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kipyo, nami weng kala bokoyokomi uyo talalu weng san iliwa! Sawaalak kawu abip Sodom kayaak so, Gomora kasel so, ili kukup mafak kuuta ti nuumin-kup kem-unipla, God ayo yam-mafak fuula taansip. Kemin ale, bii am mafiing am daan tiltam abokomu kawu kanola God akal unang tunum iyo im-bak-saan-bamda Gomora kasel so, Sodom kasel so, ili angtiil yol ayo kuyokoma. Yale, am kamala kalawaali God ami weng kuluuli fatap diim kalawu bom buu kemin, ipkal yak aba din abip ma kaptam banokomip kaali, din uniwa, dok nolin ita ma God ami weng uyo kuyang saak tiiyip namti, God ami tam imi angtiil atul kuyokoma uta ti, uta uta ke-lomdu Sodom kasel so, Gomora so, imi nami weng tangbal weng san-kaamin disa ke-bam bom ilsip angtiil yol awak kuyokoma kuluuli, kulaak banokomu kayi! kala Yesus ayo weng sawaa uyo kal-bomda almi kalaan tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesus ami kukup mafak tal almi aptum kusal imi diim abokomu kaami sang kaata bokoyila ko: Ibi nami weng kala weng san iliwa! Ibi im-baali din abip ma abip ma kem yakyak unokomip uyo, miyaan mafak apliip imi tal sipsip yam-mafak-dakan-umbip tap ke abip tunum iyo taba-lom yam-mafak-daka-mokomip. Lale, kibi sipsip ililtap ke fuluum-kup taba-bomdipla ko. Inap kiimi liip tal-unemin uyo aket fukun-bamdipla, Misii tunum itam yelalip o, kalalip akolkup duluula tal-unen-umbip tap ke kipni tal-unemip tiin bom ilip ayo ti aket fanang tangbal kaata-kup fukun-bam kukup yaap-kup tabuu-biliwa yo, kala-somla kemin, dinan-tal-unemin disa; unang tunum ili kukup tangbal tangbal kaata-kup kukaayim-bam awon abim ami duluum-kup taba tiin-yaabip ililtap ke balili kala bomdiwa yo. ");
INSERT INTO tif_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ibi nami ok kala tabuu kulii-tabokomip kabaku kaami kalan kaata, nami waasi ita ipni yim-tal fuku sok de-yimbii din Juda imi kamok kamok ang dinabip imi diim daaliwale, kamok kamok ita im-bak-saanokomip aye, lotu am unokomip kaali, waasi ita ye-bam ke-mokomip utafii-bamdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ipkal nami ok tabuulokomip ayo, kaami kalan kaata, nami waasi ita ibi imbiilip umbilin Rom kasel imi kamok kamok imi diim tiiliwa ita lek-im-bam imbak-saanokomip kawu, kipkal kabaku utamiwa, God ami weng umi liip namti kabuu kala kalalipla, ipyo, Juda imi kamok kamok so, bokon kusnum imi kamok kamok so, imi diim kawu God ami weng namti bakayokomip o. ");
INSERT INTO tif_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ita ipni im-buu-im-bii din kamok kamok imi tibi diim daalokomip kaa, ipkal aket dukum kaa fukun-bam, Kwin! weng ma kaa binalip tildaak numi al abam-nokomu kaata, kanimin o, kalokomup yiki? Kaa dok kanolin weng kaata nokol kuluu weng an-anung-daa tiiyokomup i? kemin disa; ti bilili-kala bom-bilipla, God alalta, weng baka-mokomip uyo kukuyim-bala, tambal-kup baka-mokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iltipni aket fukunin kaata-kup weng kaa baka-mokomip disa; iltipni Kaalap God ami Sinik Tangbal ata kipso suunkup ilokoma akal, almi weng kaata kukuyim-balaya, bakayokomip o. ");
INSERT INTO tif_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tunum ili natam suun-bam ilmi nakal-fakal nami lak duulin iyo yam-fatap-daa im-baalip yak kamok kamok imi sikil diim abamnipla, ita anulip taan-laa-biliple, kuno awil-fakal taba ilmi man iyo fokolip yak waasi imi sikil abamnip anulip taan-laa-biliple, man ilta awak-aalap imi tit-moya waasi keyimbip-kup, im-baalip yak kamok kamok imi sikil diim abamnip anulip taan-yaa-bam ke-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kanolin kemin, God ami lak duulin disa bilip tunum alik iyo natam suun-umbip kemin ale, ili nami lak duu-bom okok kemin tunum maakup ita aket atul kukaayim-bam itam suunokomip. Lale, nami lak duu-ilin unang tunum ili kanta angtiil yol ayo utafii-bamdip yang banemin disa, suunkup yak nami lak duu-bilip diim kawu bom bii taanip namti, kiita fan God akal yim-tama tam almi abip daalaya, suunkup ilin unang tunum ke-lokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ipyo, din abip ma kawu bom talaaliwa, mafak bakayim-bamdip itafiimip namti, baan abip kanuyimbip kaptam kambolalip din abip kusnum kaptam banemin o. Nali tituun weng kaata bokoyokomi kemin, weng selin! Ibi nami weng kaata, kulii bomdip kulii yak aba din Israel-miin imi abip dukum dukum kawu tal-une-bam bakayila-tal-une-bilipla, kuno ti disa kelin disa bom ilule, Dukum ami Man Niyo, din abalila asuk talokomi no. ");
INSERT INTO tif_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sukul man ata ata kela almi kukolin tunum ayo dabaak tabiilokoma disa le, kuno okok kemin tunum akal taba-lom almi kamokim ayo akaala tam tip kaltoop banokoma disa. ");
INSERT INTO tif_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kemin, sukul man akal talaba tam almi kukolin tunum alaltap kela kaali, ti yaap ke-lokoma; kuno ok tabuulin tunum akal tal aba tam almi kamokim alaltap kela namti, kaali ti tambal. Kemin, waasi-miin ili kasen fokop-na-lomdip: Yi, ali sinik mafak imi kamokim Belsebul o, kala Setaan ata kayi! nambipla, kanola ili nami daang bakaalin tunum ipkal ibakayim-bamdip kipni win ayo atin ti ku-mafak-dakaayim-bam ke-mokomip o, kala Yesus ayo almi miining imi bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Asuk Yesus ayo bokola ko: Kanum bokosu no. Tunum unang nami lak duulin disa kiimi atul kaa suunin disa yo. Kamala kaa ibi nami kukup tangbal ata ti kanu-bam ale, nami weng tambal kaata-kup kuno ti bakayin-bam kebip. La, nami lak duulin disa ili utam, Awu, kuuli kukup tangbal e? weng tangbal e? kalalip utamsip dinim kemin, bom bii kaptoowu unang tunum yaapkan iyo utamiwa, Awu, kuuli ti weng tangbal ale, kukup tambal, kalaliwa kawu, talalu uta-mokomip. Kemin, ibi ti suun-bamdiwa nami ok uyo kuno kela-laamin daa; kuno ti yikik-kutal-fuku tala-biliwa ko. ");
INSERT INTO tif_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nami kama alokso weng kala bakayimbi kaali, ipta weng sandip kuyak aket tem daalipla, ilom kawu ibi weng kalawaali kutamalip bilin abip ma ma ayo dukum-kup bakayila-tal-une-bilipla, alik iyo weng san-kaamalip ko. ");
INSERT INTO tif_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tunum malo ma ita bokoya-lomdip: Ibi Yesus ami weng ayo kuluu bakayila uniwa yelokomup o, yaka-lomdipla ili kipni angtiil kulaa welip taanokomu. Lale, kipni sinik suunkup ilin kaali, aalip taan maaklo ke-lokomu disa. Kiimi atul kaa suunin disa; ti God maakup ami atul kaata-kup suunin o. Kaata-kup titil soyim kemin, ata taba-lom kipni tiil uyo wela taanule, ipni sinik ayo an-bina yang wing tiil suunkup kiinin-kup ilin abip kabanokomu. Kemin, God maakup ami atul kaata-kup suunin o. ");
INSERT INTO tif_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mep awon katip katip kuliili win dinim kemin, tunum ili moni kiin abin kulaata dabuu-lom awon katip katip alep iyo molokoma. Lale, awon katip tiyok maakup ma kaami dap-taldaak tawaal diim abam-nokoma kaa, God ali ata-mokoma. God ali daak abokomap disa yo, kala namti, awon katip sakap ayo tildaak abam-nokoma disa. ");
INSERT INTO tif_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kanolin kemin ale, God ali kipni aket ayo ti suunkup fukun-umba ali alik kipni dabom kon maakup maakup iyo tik-tii utamaya, Kanolin kal u, kala utam kuno mafek mafek alik tildak kipni diim aben-umbu uyo utam kesa. Kemin, ibi ti tangbal-kup tiin mo-bomda dong dakaaya tabase ko. ");
INSERT INTO tif_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","God kaami tiin diim kaa awon katip katip kiili, kulii kulaak baniwa, tunum kipta kipta kelin kemin, God ali kipni aket kaa fukun-bam ale, tambal-kup tiin mo-bom ken-umba. Kemin, ibi tawaal diim kayaak ita ipni anulum o, kebip imi atul kaa suunin dinim o, kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesus ayo almi kalaan tunum imi bokoyila ko: Kipyo, dok nolin kapta din unang tunum imi tiin diim kaa boko-lomdap: Nali Yesus ami daang bakaalin tunum o, kemap namti, God ami lek-im-bam angtiil yol kukaayokoma kaami am daanokoma kabaku nakal Atok abiil tikiin kayaak ami tiin diim ayo bokola-lomdi: Ali nalmi kalaan tunum o, aka ke-lokomi no. ");
INSERT INTO tif_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kalok nolin tunum kapta boko-lomdap: Yi, nali Yesus ami daang bakaalin tunum disa yo, kalap namti, aa ti nakal nalmi Atok abiil kayaak ami tiin diim kaali bokola-lomdi: Ali nami daang bakaalin tunum disa yo, takali, kapni win kaa kuwaap-ta ke-lokomi kayi! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesus ayo asuk bokola: Kipni aket fukunbip kaa, nali taldi unang tunum imi weng kukaayim-bili tiltam aket maakup kelin o, kalaliya talsii no, kalbip ema? Disa. Nali tal unang tunum bikilon o, kalali talsii. Nami weng uyo yeng man ta mafek mafek bikilu malii alep ke-laaba ulultap. Tunum unang ili nami weng uyo, weng sanokomip uyo, malo ma weng san-kaa-balale, malo ma weng san-kaamin disa ke daang ukuwa-bala ke-mokomip. Kemin, iyo biki-kutii miit alep ke-lomdiwa, waasi kela antap-daa una-tala-ke-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nami weng kala kukuyinbi kaami kalan kaata, man tunum ma tiltam awil-fakal imi waasi kamayim-bilip, unang man ukol tam awak kasel imi waasi kamayim-bilip, kuno man imi unang tan yakal abimuwak kusal imi waasi kamayim-bilip ke-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kabak-ami kanu-mokomip kaami miit kaa, unang tunum yak-saak-tildak-saak ita tal kanuyokomip disa; ti ilmi aptum kusal maak ilin ililta tiltam waasi kela una-tala-ke-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kemin, dok nolin tunum ata almi awak-aalap imi aket kaata-kup an-bulu kuya bomda nami aket uta le, katip ma kup-na namti, ali fan taang-kala-somda tal aba tam nami ok tabuulin man ke-lokoma disa. Aa, dok nolin tunum ata almi man unang aye, man tunum man aa, imi aket-kup an-buluya, imi aket-kup kuyale, nami aket kulaata katip sakap-kup kup-na kela namti, ali fan taang-kala-somdaya taltam nami ok fukulin man kep-nokoma disa yo. ");
INSERT INTO tif_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kuno kalok nolin tunum kapta nami man kelon o, kalap. Katale, nami as diim kawu angtiil yol kuluulokomi ultap kuno kuluulami uyo kuno kuluulami kalokin disa, kal-bom ale, nami daang bakaap-na bokop-ta-lomdi: Kaata kanuman o, takan-kaabi kaa tabuulin disa ke kanumap namti, kabi dok kano-lom nami tunum ke-lokomap disa ko. ");
INSERT INTO tif_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kabi kaltapni angtiil lak-kup duu-bomdap kaltapni aket fukunin kaata-kup kanum tal-unemon o, kemap namti, kabi naso suunkup ilokomup disa; ti kabi maaklo win dinim ke-lokomap. Ale, kapni aket fukun-bam kanubap uyo kulaalap tildang kanu-biliya waasi ita nelik o, kalolip kulaali, kuno nelalip o, kalalap tildang nami lak-kup duu-bom nami kukup ata dukum-kup tabuu kulii tabap namti, kabi naso suunkup ilokomup kayi! kala Yesus ayo almi aptum kusal imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Asuk Yesus ayo almi maakup ilin imi bokoyila ko: Tunum kaa kanta nami daang bakaap-nin tunum, kabi din atamawa, ti yaap ke talap, taka-lomda kapni weng uyo weng san-kaama namti, ali nami weng uyo, weng san-kaamin tunum ali namti kabe. Ale, tunum kanta God Nam-baala Talsii nami weng kaata, weng san-kaama namti, ali God ami weng so weng san-kaamin tunum namti kaa bombe ko. ");
INSERT INTO tif_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dok nolin tunum ata utamaya, Kabi God ami weng ku-fatap-dakamin tunum o, takalaya, kabi yaap ke talap o, taka-lom kapni weng uyo, weng san-kaama namti, God akal utam talaala, Awu, tunum kulaata dong dokop-ta kala-somdala kawu, akal kapni okok kem-laabap uyo maan tiip-ta-som ale, kap-tunum ami dong dakaap-tamba akal kuno tela ke-lokoma te! Ultap kemin, dok nolin tunum ata utamaya, Nak-tunum kaali ti tituun-kup tabin tunum kalalaya, ti yaap ke talap o, kal-bomda kukup tangbal-kup kukaala namti, God ali atama yi, Tambal-kup kukaaya kala kalalaya akal tituun-kup tabin tunum ayo maan tela-som aa, aptum ami kukup tangbal kukaanba akal ti kuno maan tela-som ke-lokoma no. ");
INSERT INTO tif_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nami tituun-kup tabin weng kala bokoyokomi kalaayo, talalu weng san bom iliwa! Dok kanolin tunum ata tunum kusnum ayo ma tala atamala, ali win dinim Yesus ami daang bakaalin tunum o, kalala bokola ko: Yak tunum kalawaali win dinim kemin, nali kaa dong dokolokomi dinim o, kalokoma dinim. Ayo boko-lomda, mep tunum kalawaali, Yesus ami man kemin, nali ami dong dokolokomi no, kalala dis ok uyo ilola inamna namti, God akal mep tunum kaami kukup kanuba uyo utam bokola-lomda: Kaptum dis ok ilolap kaami kukup kulaa katip. Yale, kaa ti yaap ma kanolap kemin, nali fiyaap duubi no, kal-bom ale, akal kukup tambal uyo maan telokoma kayi! kalala, Yesus ayo mep weng tem ayo almi miining imi kanum bakayinsi disa kelule, kamboyila im-baala almi okok kamala kem-unip ko. ");
INSERT INTO tif_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus ayo kanola almi kalaan tunum talangkal iyo kanumin sang uyo bakayim-bii disa kelule, kulaa abip uyo kulaa kela bilin abip kusnum abip kusnum imi mepso kaptam-ami tunum unang imi God ami weng kaata bakayim-bamda kukuyila ko. ");
INSERT INTO tif_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kanu-balaya, im-baak ok tem dakamin tunum Jon ali kalabus am kawu bom-balaya, almi kalaan tunum iyo fokola tal God ami uldaa-dabuula tiltam Kamokim kesa tunum Kraist ami atam iliwa, kalok nolin okok keba kalaliwa, tal Jon ayo bokoliwa, Jon ayo utam aket alep fukun ale, bokola: Kwin! Yesus kaata God ami ulduula tiltam Kamokim kesa tunum namti kulu be nelile? kusnum e? kemsile, kulaa almi kalaan tunum malo ma ulela foko yim-baala din ilom Yesus ami dik-daalip ko: ");
INSERT INTO tif_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Oksam ukayin tunum Jon ali weng ma kuya-lomda, yim-baala tulup. Kemin, ali boko-lomda: Kabi tifaneng God ata uldaa-tam-buu-lomda, tam-baala tal-salap e, tunum kusnum ata ne? kalalup fenupla talak e? kala Jon ayo kanum boko-lom dik-daala no, kalba kemin, kaltapta bokoyilap utamum o, ");
INSERT INTO tif_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","kala dik-daaliwa, Yesus asiik bokoyila ko: Ibi din kanolin mafek mafek utamip so, weng sanip so, imi sang kaali, kulii-din Jon ayo bokolin aa! Tiin mafak ayo tiin baa atafii-balale, yawiit daam ayo tam tola tal-une-bilip, angtiil mafaksip iyo asuk tambal ke-biliple, talang abat iyo baa asuk weng san-kaa-bilip, tunum unang saakbip iyo asuk tam tiin laa-bilip, ale, tunum unang iiwaan iyo God ami weng tambal bakayinbi kaali, weng san-kaa-bilip, kebip kaali, ibi atamip kemin, ibi din-ilomdip Jon ami diim kawu ipni kanolin itamip so, weng sanip so, kaami sang kaali, bokolipla, ayo weng san-ilom kaal kela, nili kanta kala, naka ko kala ko. ");
INSERT INTO tif_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kemin, tunum ayo nami kanolin kala kanubi kaami aket fukun-bam ale, bokola: Yesus kaata-kup God ayo uldaa-dabuula talse no, keba ayo fiyaap duuma. Kemin, ibi dindipla, Jon ayo sang alik kaayo, bokola-lomdip: Jon kabi aket alep fukunbap kemin, ti aket ma uyo kelalap aket maakup ma ke-lom Yesus ami fiyaap kaata ti duu-bam bom-balawa yo! akin o, kala, Yesus ayo Jon ami kalaan tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kanum bokoyilala, Jon ami daang bakaalin iyo Yesus kelalip kaami weng bokoyila uyo kulii Jon bakaala uniwa kulaali, Yesus akal unang tunum yaapkan bom-bilip imi Jon kaami sang kaata bokoya ko: Ibi siin kaa din tunum dinim bokon kawu bom-balala, Jon ami fanang unemsip kaa, kanimin ma atamum o, kalalip unemsip i? Kipni aket kaa fuku-daaliwa: Yi! Awu, daal tibin tunum ma inim ta taba fuun-balala, mokol falduu dibii une-taleba alaltap u, kalalip kaami din atamum o kalalip un-silip ema? Daa te! Jon ali daal tabin tunum disa; ali titil tibin tunum te! ");
INSERT INTO tif_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aa, ibi kanimin ma atamum o kalaliwa, un-silip i? Ibi fanang daatamin: Awu, tunum ma ilim tambal tambal ata-kup miki-balala, kaata din atamum o, kalalip un-silip ema? Disa te! Jon ali ilim tambal mikimin tunum kanolin disa; ilim tangbal mikimin tunum kiita, king ami am tambal kaptamu bomdiwa yaap-kup ilolip ale, Jon ali le saak unang tunum disanang kawu suunkup bom iloma kemin, ali disa. ");
INSERT INTO tif_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aa, ibi kanimin ma atamum o, kalaliwa unemsip i? Ibi din God ami weng ku-fatap-dakamin tunum ma atamum o, kalalip un-silip ema? Kaali fan, Jon ata weng ku-fatap-dakamin tunum kusnum alik kuliili kabaak baniwa, ata ata kelala yam-kan-tiise te! ");
INSERT INTO tif_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kemin kaali dok kata naa kalolip: God ami Sukon Tem kabak-ali Jon ami sang kaata, sawaalak kawu boko-lomdu: God ali almi Man kaami bokolaya: Tunum kulaata-kup ti nalmi kalaan tunum ke-lokoma te! Kemin kaali, nalta uldaa-dabuulila, ali dusiin daa din tawaal diim kalawaami unang tunum imi bokoya-lomda: Kibi iltipni aket tem kaa talalu bam-daka-bam kem-siliwa, kamokim ayo talak o, kem ale, kapta, mafiing kawu talokomap kayi! kala, God kaa almi Man ayo kanum bakaala no, kala God ami Sukon Tem kabak-ali kanum bokosu. ");
INSERT INTO tif_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kemin, weng kala bokoyokomi kaali, tifan, tituun weng kemin, weng selin! (Siin kaali, God ami profet kiili, God ami weng uyo kulii-tal bokola bokola kem-tabasip. La,) tawaal diim tunum alik kala tiltam tiltam kem-tabasip imi tunum maakup ata ma tiltam aba-lomda, Jon ata nami sang kulii-tal bakayimba alaltap so ma kanu-bamda kulii-tal bakayila-tabasa disa. La, unang tunum tiltam God ami miit tem talokomip kiilile, saak man mafak, man tambal yaapkan iyo tiltam God ami mafek mafek so, kukup so, uyo talalu utam-somdiwa kawu, Jon ata God ami kukup utamsa uyo kukan-tela-lomdip ita ita ke-lokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Siin kawu, Jon ata God ami sang uyo unang tunum imi bakayinsa. Kemin, kuluu kulii yakyak kulii umbital kala diilu kaali, unang tunum yaapkan imi aket fukunin kaayo, God ami miit tem ayo titil-fak-daa tam unum o, kalaliwa diimaan-daasip. ");
INSERT INTO tif_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sawaayak kaali, Moses aso, malo God ami weng ku-fatap-dakamin kusnum kiiso, ili boko-lomdip: Am ma daanokomu kaali, God alalta unang tunum iyo foko im-taldang alami miit tem daa tiin molokoma no, kem yakyak tabasip. La, kamala kulaakal ti Jon akal weng yaan tem fanang maakup kaata-kup kanum bokose. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","weng ma sawaayak kawu bokosip kaali, Elaija ayo asuk talokoma no, kalsip. Lale, Elaija ami sang bakamsip kulaali faldak Jon ami diim tii bakamsip. Kemin, Jon ali kulu tiltam tabamnala imi weng ayo duuk-kup dakat ke-lom tiilasu. ");
INSERT INTO tif_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kemin, alik kipkal talang tem so kemin yaap-kup weng sanamip te! Sining kala duluum-alom dotu tinang umu weng san-iliwa. ");
INSERT INTO tif_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Unang tunum kamala kula bom-bilip, kibi dok nolin tunum unang i? Ibi unang tunum dukum ke fasuu-silip. Lale, ibi ti man katip katip ililtap ke-bom-bilip te! Man katip katip ili abip daal iip kawu tiin-bomdiwa, man malii ma aptum kusal dukum-kup weng umuuya-lomdip bokolip ko: ");
INSERT INTO tif_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nuli was samanin tap kemum i, kalalip baal wii-bam ale, was daka-bam kebup. Katale, malii ma kiptale, nuso was wiimin disa; ale, nuyo tunum taana dawakamin tap kemum aa! kalalup amabup. Katale, kipta tal nuso amamin disa kebup ko. Kalok nolin kukup akal alik akal alik ma kabak-ami kukup kanu-mokomup kaali, ibi daa yo, kalalip kela kela kebip o, ken-umbip ko. ");
INSERT INTO tif_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ulultap o. (Ibi man katip katip fuut-kup tabin iltap ke-bamdiwa, Jon ami weng bakayimba kuluuli weng sanup disa yo, kal-bom ale, kuno nami weng uyo weng sanup disa yo, kal-bom kanu-bamdiwa, ibi disa kaami kalan kaata alep numi weng mafak kaata kukaayim-bam itafiin-umbip.) Kemin, Jon ami aket fukunin kaali, God alalta bokop-na-lomda: Yak kanolin inin-inin kaali inolap dinim o, nakase no, kalala, fala-biliya, God ali nami fiyaap kaata duumak i, kala-somdala, inin-inin akal kusnum kiiso, wain ok so, iyo suunkup falamin-kup ke-bam biisa. La, tal kaa kanu-balaya, ibi atam-ilomdiwa boko-lom: Fan, mep tunum kalawaali sinik mafak ta dap-mafak-daalaya, inin-inin kaa suunkup falan-umba no, kem-tabasip. ");
INSERT INTO tif_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kemin ale, Dukum Ami Man Nali taldila, ima so, wain ok so, kaa ma awem o, kalalila uyo ma kulaasii disa; ipni ima alik inan-umbip kulaa inan-yaabi. Lale, ipta bakap-nam-bamdip: Kipyo! mep abuuyap kaayo, soko talalu atamin i! (Juda numi kukup kaa ima mafek mafek fala-fala-ke-bam God ami beten kaata-kup kamalin. Lale, Yesus ali ti ma kanumin dinim.) Ali takis moni kaamin tunum so, kukup mafak tabuulin tunum kusnum malo iso, imi kayaak o, kem-yaabip. Kemin, dok nolin tunum ata God ami kukup tambal kaata-kup nuuma namti, kuuta kukoluya kayak kayak iyo atamiwa yi: Kaali God kaa talalu atamsa. Kemin, nuli yaap tal aba yak ami kukup tambal ma tabuulokomup o, kalokomip kayi! kala Yesus ayo kanum baka-bam bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesus ayo kukup akol almi kusnum ma kusnum ma yaapkan uyo abip malo abip ma ma imi kukuyila katale, unang tunum kuluwu bom-bilip ili imi aket fukunin ayo fal-siki-lomdip ban wakamin kaa kelalip disa, ke-biliwa, Yesus ayo im-bak-saan-bamda bokoya ko: ");
INSERT INTO tif_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iifan, Korasin kasel sole, Betsaida kasel so, kipyo ibi mokop soyal u! Nali kukup akal kusnum uyo kipni abip alep kaptamu kanumsi. Lale, ipni aket fanang uyo ma fal-siki-lom ban uyo ma kulaasip dinim. Nali yak aba din kanolin kukup akal akal alik uyo God ami lak duulin disa bilip imi abip Taya so, Saidon so, kaptamu kanumsi dinam, abip kasel ili utam-somdiwa, ili ban wakamin kaami aket uluum tabeyula ilmi aket uluum umi kukup kaata-kup kuluu-lomdip yek kutap ata kuluu ilmi angtiil diim ayo fokobip-kup, kuno ilim mafak ayo miki tiin bom ama-bam ale, ilmi ban uyo kuno kela-silip. Lale, nayo din kukuyin-biliya, uyo utamsip dinim o. ");
INSERT INTO tif_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mep nami weng kala bokoyokomi kalawuuli, kuyak aket tem daa-lom fukun-biliwa yo. Am mafiing diim tiltam tabokoma kaali, God ali Taya kasel so, Saidon kasel so, iyo im-bak-saan-bam angtiil yol ayo kuyokoma. Lale, ipni ban wakamin ayo kelin disa kelip kala kalalaya, God ayo kipni angtiil yol kukaayokoma uta ti atin awak sakbaalkan kukaayokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapeneam kayaak kipyo, kibi boko-lomdip: Alik nuli din God ami abip kawu ilokomup o, kalbip. Lale, atin disa. Ibi nami weng ayo weng san-kaamin disa. Kemin, God ata fokola daak abip mafak unokomip. Kanola nali kanolin kukup akal alami kusnum kusnum num-tabasi ayo sawaayak abip mafak Sodom kasel kaptam-ami kukuyinsi dinam, Sodom kasel ili God ami ma atamsip dinam, ili aket kaa fal-siki-lom ban kemin ayo kamboliwa, God ata imi ban kamboya abip ayo tambal-kup bom-bulu, kulii yakyak kutal kala diilu. Lale, imi aket ayo fal-sikilin disa kala-lomdala yam-mafak-daalaya dinimsip. ");
INSERT INTO tif_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kemin, nami weng ma bokoyokomi kalawaali kuyak aket tem daa, fukun-biliwa yo, kala-somya kemin, am mafiing diim tiltam tabokoma kaa, God ali Sodom kasel imi im-bak-saan-bam angtiil yol kaa kuyokoma. Yale, Kapeneam kayaak kipni ban uta kulaalin disa kelip kala kalalaya kemin, God ata kipni angtiil atul dap-kaayokoma uta ti atin sakbaalim dukum kayi! kala Yesus ayo abip asuumano kalawiimi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesus ayo abip kasel imi bakayinsi disa kelule, kulaa kela almi Aalap God ami bokola ko: Nami Aatumen kapyo, kabi Kamokim kemin ale, tawaal diim kalaaso, abiil kaaso tiin mosap. (Kemin, kapni kukup kaata taba unang tunum imi kukup kuluuli kabaak banula ata ata kesa. Kemin, yaap ke yo, kalbi.) Kemin, unang tunum iip maakup maakup ili aket fuku-daa utam: God ata kukuyim-balaya, Nuli utamsup disa. Kemin, nulmi aket fukunin kaata-kup kukuyim-buluya, nokol God ami mafek mafek uyo utamsup o, ken-umbip kalalawa kapni aket fukunin tambal uyo kuwaalapla, kiili ma utafiin-umbip disa. Kemin ale, unang tunum malo ma ili boko-lom: God kabi kukuyim-balap utamum o, ken-umbip o, kalalapla, kiita kukuyim-balawa utafiibip. (Kemin, ili nami weng kaa ti weng san-kaamin-kup kemum o, ken-umbip.) Kemin, kaali Atok kabi yaap ke yo, takan-kaabi ko. ");
INSERT INTO tif_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kapkal kanolin kukup uli kanumi no, kalalawa, kapni aket fukunin tambal uyo utamsup dinim o, kalin tunum imi kukaayim-bam kukuyim-balapla utafii-bam kaal kebip o, kala Yesus ayo God ami kanum bakaala ko. ");
INSERT INTO tif_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesus ami beten kamaanba uyo disa kelule, umi anung ditat kaptoowu unang tunum yaapkan tem kawu bomdala bokola ko: Nami Atok ali mafek mafek iyo alik kulaap-na tildak nami sikil diim abasip. Kemin, nali almi Man tituun. Yale, unang tunum ili ma nitamiwa yi, Awu, ali fan God almi Man u, kalsip disa. Nalmi Aatumen maakup kaata-kup nitamsa. Kunolin kemin ale, unang tunum yakal nami Aatumen ali ma atam, Awu, ali kalok nolin tunum i? kala ma kalsip dinim; ti almi Man nata-kup atamsi. Kemin, nakal tunum unang ulela-lomdi nami Aatumen ami sang uta kukuyi namti, kiita Atok namti atam ke-lokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kipyo, Juda imi kamok kamok ilmi weng katip katip yaapkan uyo kulii-tal aba yak God ami lo diim kabak-ali anung til-dakaaya-tabasip. Kemin, dok nolin tunum ata mep weng katip katip uyo fiit-bam kutal-fukulup kalalip, aket uluum dap-tiiyu namti, baan ibi nami fanang tildang tiliwa, nita dong dokoyila kipni aket fukunbip uyo talalu kutiiyilila, tambal-kup bilili-kala bomdiwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nali nalmi lo uyo kipni kuyili kutal-fukulokomip kaali, nalmi kukup kaata kukuyim-biliya, kipkal dik-daa kuluu kaal ke kutal-fukule, bilili-kup kalokomip ko. Nali balili-kup kala dik-diibin tunum kemin, ipkal kanola nalaltap ke-somdiwa, balili-kup kala bomdiwa yo. ");
INSERT INTO tif_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nami lo kaa fiitmin disa; fongso kemin, tildang nalmi miit tem kulawu bomdip nami lo kulaali, kutal-fuku-bom-biliwa yo, kal-bomda Yesus ayo almi kalaan tunum imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","God ami iintang am ma daanule, Yesus ayo almi aptum kusal iso, wiit lang iip-iip kaptoop liip nikil de kulii-unip. Un-bomdiwa almi aptum kusal iyo ol-tinap keyilala, wiit san uyo dikela-lomdip inan inan una-biliwa, ");
INSERT INTO tif_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Falosi malo iyo itam-ilomdip Yesus ami bokolip ko: Kapyo, kabi weng selan! Numi lo kuuli boko-lomdu: Ibi God ami iintang am daanbu kaali, ima dabuubi kulii-talemin daa yo, kalsu. Lale, yak kapni kaptum kusal kii kanimin o, kalaliwa wiit kaa daka-bamdip sikil ipyup-bamdip inan-talabip yoko? Kiili numi lo namti kulu ku-mafak-dakabip kala kaliwa, ");
INSERT INTO tif_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus asiik bokola: Ibi God ami Sukon Tem tik-tiin-umbip kaa dik-daa-kuluusip disa nema? Sawaayak Devit asole, almi ap-tunum kusel iso, nikil ima tinap keyilala bomdipla, Devit ali kabak-ayo kanimin nosa ni? ");
INSERT INTO tif_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Lotu umi lo uyo boko-lomdu: Unang tunum ibi pris awem tunum imi bret fuu kulii-tal God ami kolum o, kala God ami am tiin-umbip kaali, inin dinim awem o. Kaali awem kemin, awem tunum ita-kup inin o, kalsu. Lale, Devit ali God ami am tam-ilomda awem tunum imi ima awem kaami sang uyo dik-daalale, tunum awem ayo olen-daala-lomda ima awem ayo kolaya, Devit ayo ma inaba-kup, malo kiita almi soldiya imi kuyila inasip. Lale, ibi boko-lomdip: Kaali kukup mafak ke-bisip o, ken-umbip disa. Kemin, kanimin o, kalaliwa nami nak-tunum kusal iyo ima tinap keyilala kanolip ibi bokoya-lomdip: Kaali kukup mafak kanubip o, yakan-kaabip i? ");
INSERT INTO tif_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ultap kemin, God ami Sukon Tem uyo boko-lomdu: Ibi God ami iintang am uyo okok kemin daa yo, kala-som ale, awem tunum imi bokoya-lomdu: God ami iintang am uyo ok kusnum kusnum akal alik kaa nuumin daa; iltipni awem tunum ke-bam umi okok kemin kaata-kup kanu-biliwa yo, kala kanum bokosu. Kemin ale, God ami iintang am daanula, awem tunum imi lotu ami okok ken-unbip kaa, ili iintang am o, kala ok kulaa-laamin umi lo duula-yaabip. Lale, ibi boko-lomdip: Kaali, kukup mafak nolip o, ken-umbip disa. ");
INSERT INTO tif_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kemin, ibi kulaa tambal o, kala-laabip. Lale, mep nami weng kala bokoyokomi kaluuta weng san iliwa! God Ami Tunum Nam-baala Talsii Nata lotu am diilim dukum uyo kulaak banula, nata nata kesi. Kemin, nami daang bakaalin tunum imi bokoyila iintang am umi lo uyo lo-lomdip nami okok ke-mokomip kakal ti, tangbal o. ");
INSERT INTO tif_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","God ali almi Sukon Tem kabak boko-lomda: Nami tiin diim uyo kipni taloop kulii-tal anu God ami kola, numi ban wakamin ayo molum o, kala kukaap-nin kulaali, katip so ale, ap-tunum kusal imi kukup tangbal kukaayin kaata, nami tiin diim uyo sakbaalim dukum kemin, ibi ti kanu-mokomip kaata, nali kipni fiyaap dukum ayo duu-mokomi no, kalsa. Kemin, ibi God ami weng umi miit kuluu atin ti talalu utamsip dinam, tunum kukup mafak fukusip disa, ti tangbal-kup bilip ita ibi lek yim-bak molalipla yo. ");
INSERT INTO tif_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dukum Ami Man Nali God almi iintang am umi tiin molin tunum ali kalabi kemin, nali ti yaap nami unang tunum imi bakayim-bamdi: God ami iintang am diim kulawu ibi kaa kanumin o, kalomi kaali, ili ti nolamip te! kala Yesus ayo Falosi imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus ayo kanum bakayinsi keyila, nikil wiit lang kaptam kambolalip din Juda kasel imi lotu am unipla ");
INSERT INTO tif_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tunum ma sikil malii dibimsa ma lotu am kutamu balaya, Falosi yakal kaptam tiinbip. Kemin, Yesus ayo talalu atafii-bam ilupla, numi lo kaali, lo-lomda God ami iintang am daanu kaami diim kawu, tunum kaayo, dap-talalula kala kalup namti, dabii din weng talalmin baan diim daa-lom dap-fatap-daalum o, kala-lom Yesus ami bokolip ko: Tunum ma God ami iintang am daanbu diim kawu, tunum mafak-alin ma dap-talalula namti, kaami kanola kaali, God ami lo lo-laamin kukup namti bom be nelile? Kapni aket fukunbap kaali i? Kemin ti kaltapta bokoya taman akipla, ");
INSERT INTO tif_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus asiik maan tiiya-lom bokoyila ko: Dok nolin tunum kapni sipsip tiin molap, bombe ayo ma God ami iintang am daanbu diim kulu kulii daak afun tem una kalokomap kaali, kuno kelap kulaaku sokoma nelile? kuno asuk dabuu dap-taltam daalokomap? Kwin! dabuu dap-taltam daalokomap kawi! ");
INSERT INTO tif_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Katale, God ami tiin daaba kaali, sipsip kuliili, taloop kemin, ali kiimi aket kulaa katip katip ken-umba ale, unang tunum iltale, win so kemin, kiimi aket kaata ti suunkup fanang dakan-umba God ami aket fukunin kaa kipni kaptum kusal imi suunkup kukup tangbal kukaayimbip tap ke, nami iintang am daanbu uyo kaptum kusal kii kukup tangbal kukaayokomip kaali ti tangbal o, kem-yaaba kayi! kala Yesus ayo imi kanum bakayinsi kamboya, ");
INSERT INTO tif_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","fal-siki-taba talaala, tunum sikil malii dibimsa ami bokola ko: Kapni sikil kaa ifilan a! Aka-kem-salale, tunum ayo almi sikil ayo ifilale kulu, ami sikil uyo tangbal-alom sikil malii yaap ultap kelula, ");
INSERT INTO tif_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","kulaali, Falosi namti kulu tam tol ale, lotu am uyo kambolalip yak aba din am kusnum kawu tala-tala ang de-lomdip liip ayo ma fen daa atam-somdupla Yesus ayo aalupla taanak o! kala nikil weng takenip ko. ");
INSERT INTO tif_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Falosi iyo weng taken-bam liip ma fen-daa Yesus ayo aalum o, kemiwa, Yesus asiik asiik ke utama yi, U kanup-nambip kala kalalaya, abip kutam kambolala una ko. Kanola unang tunum yaapkan iyo yaan tem din atamdiwa, imi unang tunum mafak-alin umkan-unsip iyo alik yam-talal-bamda titil tabin weng bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nita taba-lomdi kipni mafak umusip imi talal-yimbi kaami sang uyo kulii dindip kaptum kusal imi diim kaa bakayin disa kayi! yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kaa dok kata naa kalolip: Sawaayak, God ami weng ku-fatap-dakamin tunum Aisaya ata God ami Sukon Tem uyo Yesus ami kanola kaami sang kaata, dolsa namti kula fan taltam talsu. Kemin, Aisaya ayo boko-lomda: ");
INSERT INTO tif_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","God ayo boko-lom: Kipyo, mep kaali nalta uldaa-dabuuli tiltam Kamokim kesa tunum tituun keba-kup nalmi ok tabuulin tunum ke kesa. Kemin, kaa nalmi aket dukum kaali, ami fiyaap kaata-kup duubi. Nali nalmi sinik ata dabaali daak ami diim aba bomdaya dong dakaan-balala, weng dotu kukaayin tunum kelaya, am bokon kala dik-daa kulaasu kalawaami unang tunum alik imi bokoya-lom: Kanolin kukup tambal kaata-kup nuu-bamdiwa yo, yakan-kaa-mokoma. Lale, ");
INSERT INTO tif_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","kaalile, weng diki-bam ilin titil weng bakamin aa, yak abip daal iip aye, kawu tola-bomdaya dukum-kup naan-bam ke-mokoma dinim o. ");
INSERT INTO tif_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mep kaali, unang tunum titil fokolin dinim bulus kebip iyo aket filit so, kukup tambal so, kiita kukaayokoma. Kemin, ali almi ok kaata dukum-kup kutal-fuku bombi le, tam kukup mafak uyo ku-mafak-daala dinimnula kukup tambal kaata-kup, uta uta ke-lokomu. ");
INSERT INTO tif_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kemin, tawaal alik kaa dik-daa kulaasu kalawaami tunum miit ma miit ma kaami unang tunum malo ma iyo almi lak kaata-kup duu-bom ale, fen-biliwa din unokoma no, kala, God kaa kanum bokosa kayi! kala Aisaya ayo kanum boko-lom dolsa ko. ");
INSERT INTO tif_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sinik mafak ata tunum ma dap-mafak-daalaya, ali tiin dakamin dinim ale, weng bakamin dinim kesala, kanosa tunum ayo Yesus ami fanang dibii tal daalipla, kulaa ata dap-talalula tiltam tiin baa weng boko kelaya, ");
INSERT INTO tif_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","kawu unang tunum alik iyo utamdip fanang alik tambaneyilula, aptum kusal iyo bokola una-tala-ke-bam bokolip: Kipni aket fukunin kaali, mep tunum kaa God ami uldaa-dabuusa tunum Devit ami man loop ata no, kebip ema? Aa, kipni aket fukunbip kaali yi? yikipla, ");
INSERT INTO tif_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Falosi iyo weng san isiik bokolip: Sinik mafak imi kamokim Belsebul o, kala Setaan ayo Yesus ami diim kawu bomdala, dong dakaan-balala, kaami unang tunum sinik mafak ta yim-buusu ata fotabe-bala kemin, yak banebip o, iyo kemip. ");
INSERT INTO tif_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kulaa, Yesus ayo Falosi imi aket kaa fukunbip uyo uteyimba-kup, bokoyila ko: Kipyo, weng do kala bokoyokomi uyo talalu weng san bom ilipla! Abip maakup ma kaptam kasel iyo biki-kutii miit alep ke-lomdip ilmi dinin kulii-tabamnip namti, imi titil-foko yaap-kup ilolip uyo kuyaku imi titil kaali disa ke-lokomu. Aa kuno, unang tunum am maakup bom-bilip iyo suunkup weng aal faka-bamdip dinin-kup kemip namti, yakal ti kano maakup ilokomip disa; yakal ti kuno biki-kutii sakela una-tala-ke-lokomip. ");
INSERT INTO tif_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kemin, ultap, Setaan akal almi kayaak sinik mafak so alimal yakal kutii waasi kela una-tala-ke biki-kutii alimal kii titil-foko tangbal bom-bilip disa. Imi titil ayo disa keyon o, kalbu. Kemin, kibi nali bokop-na-lomdip: Belsebul kaa Yesus ami diim kawu bomdala dong dakaan-bala, unang tunum sinik mafak ta im-buu im-buu unsa kiili fotaba no, kalbip. Lale, Setaan ali almi sinik mafak iyo fotabamna yak banolip disa yo. ");
INSERT INTO tif_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nali sinik mafak kuliili fotaben-umbi kemin, kanola kipni daang bakaalin tunum kiikal ti sinik mafak iyo fotaben-umbip. Ibi boko-lomdip: Setaan ata Yesus ayo dong dokolaya, sinik mafak kii fotabeba kayi! kalbip. Katale, Falosi kibi boko-lomdip: God alalta numi ok tabuulin man imi dong dokoyilala, sinik mafak iyo fotabebip o, kalbip i? Kanimin o, kalaliwa weng alep kaa akal almi bokola bokola kebip yoko? Kipni kanubip uta taba-lomdu ipni kalaan tunum iyo kukuyila utamiwa yi, Nami sang bakap-nambip kaali, kasen-fakap-nambip o, kalbip ko. Setaan ata taba-lomda titil kaa kup-ninsa disa; God alalta titil kaayo kukaap-nam-balaya, sinik mafak kii fotabebi. Kemin, ibi babon-bam weng kala bakabip o. ");
INSERT INTO tif_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","God almi Sinik Tambal ata dong dokop-nam-balaya, nali sinik mafak kii fotaben-umbi kemin, siin God ami kipni bokoya-lomda: Nami tunum ulduuli tiltam Kamokim kesa ayo dabaali tal ipni diim kawu aba dong dakaayim-balaya, ibi tiltam nami miit tem talokomip kayi! kalaya fen-tabasip ayo nalta talbi kemin, kibi nami kukup kala kanubi uyo utamiwa yi, fan o, kalin. ");
INSERT INTO tif_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kemin, nami faldak-tiimin weng kala bokolokomi kalawuuli weng san iliwa! Dok nolin tunum ata kun soyap tunum ami am undala ami bung mafek mafek uyo duk-duulon i, kala namti, yukut inipyaap ayo kamasi kawu tunum titil soyap ayo sok de dap-tiile, kaal dinim ke kawu tam ilomda ami mafek mafek uyo duk-duulokoma no, kala Yesus ayo kanum bokola ko. (Kanum boko faldak-tiimin weng kaami miit kaalile, Yesus ami titil kaa Setaan ami titil uyo kabaak banu kensa. Unang tunum Setaan sikil baan diim bom-bilip iyo, Yesus ami sikil uyo tik-daa kukan-tela-lomda im-taldang almi miit tem dakan-umba. Kemin, kaami sang kaata faldak kulu tii-lomdaya, do weng kala bokoyila ko.) ");
INSERT INTO tif_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yesus ayo asuk boko-lomda: Tunum unang kanta nami okokmin uyo kamap-nin dinim aa, yang aptum kusal iyo dong dakaayin-bilip tildang nami miit tem talemin dinim kemip namti, kiili nami waasi tap ke unang tunum wakat tokola kep-na yang banebip ultap ke-bam kanun-umbip. ");
INSERT INTO tif_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kemin, ibi kabak-ali talalu utafii-bamdiwa yi! Tunum kaa kanta kukup mafak ke-bamda weng mafak baka-bam ken-um-bala ami aket fanang saanin uyo fal-siki-lom ami kukup mafak keba uyo kulaala namti, God ayo ami kukup mafak kaa kanum-yaaba uyo tak-daa-lom kukan-telokoma. Ale, tunum kanta God ami Sinik Tambal ami sang bokola-lomda: Belsebul sinik mafak imi kamokim ata Yesus ayo dong dakaanba no, kalokoma kaata, God ami Sinik Tambal ami win kaa ku-mafak-daawalak i, kala-somdaya, God ayo ami ban uyo tik-daawala yak banokomu dinim. ");
INSERT INTO tif_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kemin, dok nolin tunum ata Dukum Ami Man ami win uyo ku-mafak-daawali no, kalala, asuk ami aket fanang uyo fal-siki-lom nami kup-nokoma, kaata, fan God akal taba ami kanola uyo takan-telokoma no. Ale, dok nolin tunum ata God ami Sinik Tambal ami win kaa ku-mafak-daawala namti, kamala kulu ti kulii yak aba kaptoop unokomu kaalile, God ayo ami kanola uyo atin ti tik-daa-lom kukan-telokoma disa yo, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesus ayo asuk Falosi imi bokoyila ko: Ibi as lap abuumin umi kukup uyo ti utamin! As lap tambal abuumin uli ukol ulmi yaap ma abuulokomu. Ale, as lap mafak abuumin ukol kuno ulmi lap mafak kaata-kup abuulokomu. Kemin, nokol utamuwa yi, Kanolin as lap abuulu kalup namti, utam, Awu, kaata as tambal ale, kaata as mafak o, kalokomup. ");
INSERT INTO tif_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Ultap, kemin ale, Nuli tunum kii itamupla, dok nolin dok nolin kukup kiita kanun-yaabip kalup kulaa nokol utamupla, imi aket fukunin uyo kanolin kaata utamdula kemin, kaa kanun-umbip kalokomup. Tunum tambal ili aket fukunin tambal so ili ti kukup tambal-kup nuu-bam ale, weng tambal-kup baka-bam ken-umbip. Ale, tunum mafak itale, aket fukunin mafak-kup nuu-bam, weng mafak baka-bam, kukup mafak-kup kem-yaabip. Kemin, Falosi ibi ti aket mafak-kup fukun-umbip. Kemin, ibi taang-kala nami ok sang uyo tambal ma bokolokomip dinim o. Ibi inap mafak ta kiil daang tup tunum unang imi yam-mafak-dakan-umba ultap ke, iltipni weng mafak kaata baka-bamdiwa, unang tunum iyo yam-mafak-dakan-tabasip ko. ");
INSERT INTO tif_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tinang umu iliwa! Weng kalawaali bokoyon. Am mafiing diim kabaku God alta unang tunum kii alik maakup talalu itam liip-mokoma kaali, alalta unang tunum maakup maakup imi aket tambal fukunin dinim ke weng yaapkan bakamin-kup ken-tabasip kaami sang kaata, alik dik-daalaya, ili God ami tiin diim kawu, God ami weng maan ten-bam alik ifi-lom bakaalokomip. ");
INSERT INTO tif_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kanola God ali kipni weng, weng sanokoma uyo, malo ma ipni bokoya-lomda: Ibi ti kukup tambal nuumsip kayi! kala-lomda im-tama tam almi abip daalokoma. Ale, malo ma kipta bokoya-lomda: Yi, ibi kukup mafak num-tabasip te! yak-alomda im-baala yang abip mafak unip keyokoma no, kala Yesus ayo Falosi imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kulaata lo utamsip tunum malo iso, Falosi malo iso, iyo Yesus ami bokolip ko: Kukuyin tunum kapyo, numi aket kaali, kapta mirakel o, kala kukup akal kusnum ma kukuyilawa, utamuwa yi, Kabi ti fan God alalta tam-baala tal-salap tukum o, akipla, ");
INSERT INTO tif_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesus asiik imi weng maan tiiyila ko: Ibi God ami weng kaa ma weng san-kaabip disa; ibi aket mafak fukunbip. Kemin, ibi bokop-na-lom: Kabi kukup akal almi kusnum kaata ma kukuyapla, Nuli utamuwa yi, Fan, God alta tam-baala tal-salap o, tukum kebip. Lale, kanolin kukup kaali ma kukuyokomi dinim. Kemin, nali sawaayak God ami profet Jona ami kukup kanosa kaata-kup kukuyokomi. ");
INSERT INTO tif_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona ayo sawaayak kawu toop aniing sakbaalkan dukum umi mat tem kawu, bom bii am asuumano kelala, tiltamba talsa. Kemin, ultap o. Dukum Ami Man Nayo tawaal iipyak tem kabaaku bom bii am asuumalo keliya, am asuum diim kulu tam tiindi tiltamba talokomi ko. ");
INSERT INTO tif_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Am mafiing daan tiltam tabokomu kaali, God ayo unang tunum alik imbii din weng talalmin baan diim daa im-bak-saanokoma uyo, Niniva kasel iyo tam tola Juda unang tunum kamala bom-bilip kipni sang kaata boko-lomdip: Nuli Jona ami weng tambal kaata weng san-somdupla, aket fal-siki-lom numi ban kemin ayo kambola-sulup. Lale, Jona ami weng tambal uyo kabaak banula, Yesus ami weng tambal uta uta kesu. Kemin, unang tunum kiili, Yesus ami weng kulaa weng san-silip. Lale, kiili boko-lomdip: Nuli aket fal-siki-lom numi ban wakamin kaa kulaalokomup dinim o, kalsip o, kala Niniva kasel ita ipni sang uyo God ami bokolokomip. ");
INSERT INTO tif_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kanolakin kemin, sawaayak kaali, Seba kasel imi tiin molin unang o, kala Kwin uli Solomon ami weng tambal uta ma weng sanon o, kala-lomdula ulmi abip uyo kambola talbu umbital Israel-miin numi bokon kalaba talsuu. Kemin, ilom am ma daanu am mafiing diim tiltam tabokomu kaa, God ata unang tunum alik imbii din weng talalmin baan diim tii-lom yim-bak saanokowa kawu, unang kuuta tola-lomdu Juda unang tinum kamala bom-bilip kipni sang ayo boko-lom: Solomon ami weng tambal ayo kulaak banula Yesus ami weng tambal ata ata kesa. Lale, unang tunum kiili, weng san-silip disa kayi! kala-lomdu God ami bokolokomu no, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesus ayo asuk bokoya-lom bokola: Sinik mafak ayo tunum ma kaami diim kawu tiinsila, kulaa kela umbilin ok dinim bokon kawu yang tildang ke-bamdi baan diim ayo ma atam-somdila tiinon o, kalala, fen-tal-tal-ke-bamda baan diim kaa ma utamin dinim keli no, kalale, ");
INSERT INTO tif_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kulaa bokola ko: Nami am kaa dinim kela kemin, asuk umbilin nalmi tunum kela talsii ami diim kawu ilokomi no, kalale, kulaa asuk umbilin ulala, Ami tunum ami iipyak tem uyo am kaptam-ami sung ayo mafek mafek alik diliit mo dotu fokola tambanip disa bom buu tap kebu kala kalale, kulaa ");
INSERT INTO tif_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","din sinik mafak fetkal kusnum ma kii itama. La, kiimi kukup mafak uyo nami kukup kulaa nam-baak tabii ita ita kesip kalale, asuk foko imtal tunum ami diim tii kelaya, alik maakup bomdiwa kamosinim kaami sinik mafak alafin tiinsa ayo kulaak banala, mafiing tem kawu, sinik fetkal ita tiltam tilip ita ita ke-lomdip kamala mep tunum ami aket mafak fukunin uyo atin mafak-alom uta uta ke-lomdu kamasi kaami aket fukunin mafak kanun-yaaba uyo kabaak banula kewu. Kanolin o. Kamala Juda kipni kukup mafak kebip kulaali, katip so kebip. Lale, bom bii kipni kukup mafak nuu-mokomip kaali, atin sakbaalim dukum nuu-mokomip o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kal-bomda, Yesus ayo unang tunum imi bakayim-bam bom ilale, kulaa Yesus almi awak sole, nakal-fakal iso, aptil iyo tal abip kaptamu tolale, unang tunum bom-bilip imi bokoyip: Nuli Yesus aso, weng ma bokolum o, kalup yikiwa, ");
INSERT INTO tif_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tunum ma kaptamu bombe ata Yesus ami bokola ko: Naktum kapyo, kapni kawak so, nakal-fakal nikil iso, aptil iyo tal kapso weng ma bokolum o, kalalip tal abip daal kawu tola bom-bilip o, kalala, ");
INSERT INTO tif_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus ayo unang tunum iyo kukuyim-biliya, tiltam nami unang tunum kelin o, kalala bokoyila ko: Kii kanta nami akamen so, nakal-fakal iso ni? kala-lomda ");
INSERT INTO tif_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","almi kalaan tunum imi sikil diil tuuyila unang tunum imi bokoyila-lom: Kalawiita itamin o! Kalawiita nalmi akamen sole, nakal-fakal tap namti kala bom-bilip. ");
INSERT INTO tif_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kemin, unang tunum kii kanta nami Aatumen abiil tikiin kayaak ami boko-lomda: Kaata kanumin o, keba, kaata-kup kutal-fukulip namti, kiita fan nami nakal-fakal so, akamen so, ililtap o, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Am daanba kulu Yesus ayo am kaptam kelala yak aba toop Ok Galili balang diim kawu tiin-bomda unang tunum imi bakayim-bam kukuyila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kukuyim-bam itama yi, Tunum unang deng-kup tala-tala-ke de-falala nam-bak molip kala kalale, bot ma ok daang diim kawu bombuu umi tem kabaaku tiinale, unang tunum ita ok balang akiim kawu tolnip kelipla, (kulaa ami weng kaata bakayim-bala alik iyo weng san-kaamip ko.) ");
INSERT INTO tif_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Weng yaapkan uyo faldak-tii-bamda do eng kaata, baka-bom kukuyim-bam bokola ko: Kulaali, tunum ma ayo wiit o kala-laabip kaami san kaali, kulii-din langabip kawu sekela dabaalon o kalala, una kemin, ");
INSERT INTO tif_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","san kiili, kulii-din sekela tal-une-balale, san malo ma kiili, daak langabip kaami liip fatap diim abamnule, awon-miin ita tal inamnip. ");
INSERT INTO tif_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ale, langabip kaami tawaal anung ma kaali, tuum yaapkan kiita-kup kelula, tawaal uta katip sakap kemin, san malo ma kaali, daak kanolin tawaal kaami diim abamnu. Lale, tuum kaami tip diim kaali, tawaal katip kemin, abiltap-kup bikin-tabamnula, ");
INSERT INTO tif_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","timtim kaali, dukum-kup tawaal bikilin dinim kemin, atan mamin taba wiit san kaa, fuula kiin-ilomdu datnu. ");
INSERT INTO tif_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ale, san malo ma kaali, daak al mafak tem kaami iipyak tem abamnula, balaasaal mafak uta uta kelu, wiit iyo dutuluwa-lom mafaknip. ");
INSERT INTO tif_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","San malo ma ita, sakela daak tawaal tambal diim aba tambal-kup tiltam aba-lomdu abuu-lomdu tang yuun maakup diim kuyaku lap 100 abuu-bulule, tang malo uta 60 abuulu, malo ma ata 30 abuulu kelip. ");
INSERT INTO tif_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ipkal talang tem so kemin, mep weng kala bokoyi uyo talalu weng san-ilomdip atamin o! kala bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesus ayo weng bakayim-bala bii, disa kelule, almi daang bakaalin tunum iyo tal Yesus ami bokola-lomdip: Kamokim kapyo, kabi kanimin o, kalalawa unang tunum weng bakayimbap kaali, faldak kulu tii ke-bam suunkup faldak-tiimin weng-kup bakayila-yaabap yoko? kala dik-daaliwa, ");
INSERT INTO tif_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus asiik bokoya ko: Siin kaali, God ami unang tunum almi miit tem tiltam tilip tiin molokoma kaami sang ayo alik bakayinsa disa, anung-anung-kup. Kamala kalawaa God alta kipni aket tem uyo bam-daayilala kawu, ipkal utamiwa yi, Yesus ami faldak-tiimin weng kala bakayimba kaami miit tam God ami miit tem unup tiin molokoma kaami sang kaata nu, kalalip utabip. Lale, yak tunum kusnum itale kaa utafiin-umbip dinim o. ");
INSERT INTO tif_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kalok nolin tunum ata nami weng uyo, weng sanda kutal-fukula namti, ali God ata dong dakaan-balala, ayo utam kaal ken yakyak um-bomdala kawu tal aba tam atin uta-mokoma no. Tunum ali kanata nami weng uyo dotu weng san kuluulami disa yo, kala namti, kamasi kaptoop ami katip ma utamse kaata-kup bombiile, lokolu kulaalokoma. ");
INSERT INTO tif_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kemin, kanolin unang tunum kiili, nami okok kala talalbi kaali, ilmi tiin tituun kaata, utafiin-umbip. Lale, kii utamipla, U kabak faneng o, ken-umbip dinim; ale ilmi talang tem alep ayo nami weng kulaa weng san-kan-umbipla ili utamiwa, Weng umi miit namti kabuu nu, kem-yaabip disa, kalalila nakal do weng uyo, kanolin unang tunum kiimi bakayin-kup ken-umbi. ");
INSERT INTO tif_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Siin sawaayak profet Aisaya ata God ami Sukon Tem kabaku kanolin unang tunum imi sang kaayo dola boko-lom: God ali boko-lomda: Unang tunum kipni aket fukunin kaa ibi talalu fukunin dinim kemin, ibi weng sanup daa yo, kala kipni talang tem ayo katii-som ale, tiin baa utamalup daa yo, kala kipni tiin ayo kabii kesip. Kemin, kunuubip uta ibi weng kaa ma weng sanup kalaliwa, weng san dik-daa kuluu-yaamin dinim; ale, dok nolin kaata ma utamup kalaliwa, talalu ma utafiimin dinim o. Lale, kipni aket fukunin uyo fal-sikibip dinam, ibi mafek mafek utafiibip kaami miit uyo kaal kelamip. Ale weng, weng san-kaabip kaami miit kuu talalu utam-som ke-lokomip. Kemin, kipni aket fukunin kaali tambal-kup keyilula, ibi nami fanang tiliwa, talalu-yimulokomi no, kala God kaa kanum bokoba kayi! kala Aisaya ami dolsa namti kuluwaami weng namti kaa tiltam tulu. ");
INSERT INTO tif_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Kemin, nali tituun weng kaa bokoyokomi: Sawaayak sawaayak kaali, God ami weng ku-fatap-dakamin tunum profet o, ken-umbip iso, God ami unang tunum tituun-kup tabin yaapkan malo ma iso, ili nami okok kala ke-bilila, kipni utafiibip kaluuli atamum o, kalaliwa, kalaami sang baka-bisip. Lale, ibi utamiwa yi, Mep kulu tiltam tulu kalsip dinim. Ale, nimi weng kala bakayimbi kalawuuli kukal ti weng sanum o, kemsip. Lale, ili weng uyo weng san-kaa-bisip dinim o. Kemin, nami daang bakaalin tunum ibi, Yaap ke, God ayo aket fukunin tambal kuyase. Kemin, mafek mafek utafiibip kaa dotu utam-som mep weng, weng san-kaabip uyo dotu weng ma san-kaabip o, kala Yesus ayo alami daang bakaalin tunum imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kemin kulaata, Yesus ayo almi daang bakaalin tunum imi bokoyila ko: Ti weng san iliwa! Nami weng do faldak wiit san kawu dikimin tunum ami diim tii bokoyili kaami miit kaata ku-fatap-daa bokoyokomi. ");
INSERT INTO tif_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kaali, tunum unang malo ma ili wiit san sekela daak liip fatap diim abebu tap. Kemin, ili tiltam God ami diim talemin kaami sang kulaa, fan weng san-kan-umbip. Lale, ili dotu ma utam-laamin disa ken-umbip. Kemin, tunum mafak Setaan ayo awon alaltap ke tal-ilomda God ami weng aket tem bombuu uyo, dik-daa kukan-tiiyilala, tunum unang ili weng kaa lukuuyokomu no. ");
INSERT INTO tif_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Unang tunum malo ili wiit san sekela kulaala daak tawaal tuum yaapkan kaami diim abebu tap ke kiili, God ami weng uyo weng san-ilom ale, weng ayo abiltap fan o, kala fiyaap duu-mokomip. Lale, ");
INSERT INTO tif_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","weng uyo dukum-kup yikik kuyak ilmi aket tem daalin dinim kelip keliwa kemin, da luuknin tap ke mafek mafek mafak tal imi diim abam-nokomu aye, tunum kusnum ita God ami weng kaami kalan kaata, kiiyo bon diiyin-bamdip iyo abiltap kela yang banokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kuno unang tunum iip malo ma ili tunum wiit san sekela kulaala daak al mafak umi tem abeba ultap. Ili God ami weng ayo weng sanokomip. Lale, tawaal diim kalawaami mafek mafek iip-nokomip kaami aket dukum fuku-dakamin aye, moni kaa-bam fiyaap duumin kaata kemin, kanolin aket fukunin kaata dukum-nule, God ami weng kaami aket kuuta kulaak banu. Kemin, wiit umi tiil dinim, fuut-kup kebu ultap ke-lomdip God ami weng ayo titil-fak-daa dukum-kup kutal-fukulamip dinim ke-lokomip o. ");
INSERT INTO tif_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Unang tunum malo ma ita wiit san sekela kulaala daak tawaal tambal diim abeba ultap kemin, ili God ami weng uyo weng san-ilom ale, talalu utam ke-lokomip kaa God ami weng ayo suunkup kutal-fuku kanu-mokomip. Kemin, malo ma iyo wiit kabak-ali 100 abuu-bulule, ultap kelale, malo ma ita 60 abuubu ultap ke-balale, iip malo uta 30 abuubu ultap ke-bala ke-lokomip o, kala Yesus ayo weng do kaami miit uyo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus ayo unang tunum imi kukup mafak kutal-fuku ilin umi diim tii weng do ma faldak kulu tii unang tunum imi bokoya-lomda: God ami unang tunum im-taldang almi miit tem tii tiin molokoma kaali, ultap o. Langabip kayaak asiik wiit san tambal ayo kulii-din almi okok kamaalin imi kuyilala dabakabi unipla, ");
INSERT INTO tif_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","kutamiip kuyaku tunum unang iyo alik akan-uniple, imi waasi ayo maaklo ma tal-ilomda al mafak imi san iyo kulii-tal biil tangbal kawu wiit san dabakabi kulaa kela unip umi iipyak tem kulu dabakabi kulaa kela tabanala, ");
INSERT INTO tif_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","wiit san ayo tam taba-lomdu abuumon e, kem-sulule, kulaa ok tabuulin tunum iyo utamiwa yi, Wiit abuumon o, kebu umi iipyak tem kabaak-ali al mafak wiit alaltap ayo tiltam aben-umba kala, kala-lomdip ");
INSERT INTO tif_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","kulaa, din imi kamokim wiit lang kayaak ami bokolip ko: Kamokim a! kapni wiit san tambal kaata-kup kuyilap kulii-din biil dakamsup lale, mep al mafak kaa kalok nolin wiit san umi iipyak tem kabaaku tiltam tababu ni? akiwa, ");
INSERT INTO tif_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ayo bokoyila ko: Numi waasi tunum ema? tal-ilomda al mafak san ma kulii-tal dabaala umba te! akale, kamokim ami okok kemin tunum iyo bokolip: Yak kanoba kulaali, nuyo din-ilomdup al mafak kii bitalamup ema? kala dik-daaliwa, ");
INSERT INTO tif_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","asiik bokola: E,e din ilom al mafak bita-bamdiwa wiit san tangbal kaaso dola kuyak tii-mokomip. Kemin, al mafak kaa bitamin daa. ");
INSERT INTO tif_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kuno kulaalip bom-bala bii wiit kaso, al mafak kaso, tiltam ilom abuu-lom yakaanula, wiit bomin am daan tiltam tabokomu kawu, ibi bokoyilila, kamosinim kaali, al mafak asiik dolbi de-kutii-kutii-ke-lomdip as kuyak-daalip kiin unale, mafiing kawu wiit kaata-kup bobi kulii-tal nalmi am kaltam tiimin o, kalokomi no, kala wiit lang kayaakim ayo almi ok tabuulin tunum imi kanum bokoyase no, kala Yesus ayo unang tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Yesus ayo do weng ma asuk bokola ko: Unang tunum God ami miit tem bom-bilip kiili, mastat san iltap kemin, mastat san kaali, atin ti fan katip tiyok. Lale, kanola tunum ayo ma dip-tama yang dulaya, ami talaba tam dukum ke-lokoma ayo as alaltap kelale, awon iyo tal aba tam ami tang diim kaptamu imi iim ayo dina-mokomip o, kala Yesus ayo kanum bokola ko. (Kemin, faldak-tiimin weng kuumi miit kabak-ali boko-lomdu: Mastat san kaaltap kanola God ami unang tunum iyo kamosinim kulaali iip maakup maakup ke-lokomip. Yale, mulo kawu taltam taltam kem yak aba butoop yaapkan ke-lokomip o, kalsu ko.) ");
INSERT INTO tif_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus ayo asuk do weng ma boko-lomda: Unang tunum God ami daam tem kawu bom-bilip kiili yiis o, kala-laabip bret fik-tiimin mafek mafek ulultap kemin, unang ma yiis katip sakap ma tak-daalu daak flawa dukum tem unu fal-siki-bulu bii maakup ma kela kala kalbu-kup, kela ilanin tap ke flawa kaali, fusuu-lomdu akal alik ma ke-lokomu ulultap o, kala-lom Yesus ayo kanum bokola ko. (Kemin, do weng kaali boko-lomdu: God ami lak duulin unang tunum iyo unang tunum ikal alik ma imi iipyak tem kawu bom-bilip namti, aptum kusal God ami lak duulin dinim bom-laabip kiili, ikal alik kebip-kup, kuno God ami lak uyo duu-lomdip, iyo yaapkan ke-lokomip o, kalsu ko.) ");
INSERT INTO tif_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kemin, faldak-tiimin weng kaali, kela-lomda, weng fatap kaata, kuluu-lomda unang tunum kiili, bakayila disa; ali ti faldak-tiimin weng kaata-kup imi bakayinsa ko. ");
INSERT INTO tif_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kaali kanola bakayin-balala, God ami profet ami weng sawaayak God ami Sukon Tem dolsa uyo fan tiltam tabasuu. Kemin, profet ami weng ayo boko-lomda: Sawaayak God ami tawaal so, abiil so, talalusa diim kuyaku kulii yakyak kulii umbital kala diilu kaali, dok kanolin tunum ata God ami kukup uyo ma utamsa disa. Kemin, kamala kalawaali God ami kukup ami sang uta faldak weng do diim tii bakayim-bamdi bam-dakaayim-biliya, weng san-kaa-mokomip o, kala God ami weng bakayin tunum ata Yesus ami sang uyo kanum boko-lomdala, siin sawaayak kaptoowu kanum bokosa ko. ");
INSERT INTO tif_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesus ayo unang tunum yaapkan iyo ok kumun ami daang diim kamboyilala, yak aba tam am unala, ami daang bakaalin tunum iyo tal-ilomdip dik-daalip ko: Yak kapni wiit lang umi al mafak kaami sang faldak-tii weng do kaa bakayimbap kaami miit kaata nuyo bokoyilapla, kaal kelum o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","kulaa Yesus ayo bokoya-lomda: Dukum Ami Man Nali tunum wiit san tangbal kuyila dabakamsip kaaltap ale, ");
INSERT INTO tif_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","mep tawaal kala dik-daa kulaasu kalawaami unang tunum kiili, nami lang abip ultap kemin, unang tunum tiltam God ami miit tem ba tilin ita, wiit san tambal kiiltap ale, tunum mafakim Setaan ami unang tunum ita al mafak iltap o. ");
INSERT INTO tif_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kemin, Setaan kaali, waasi tunum al mafak san biil tangbal kawu, dabakamsa alalta kemin, am mafiing diim tiltam tabam-nokoma uyo wiit yakaana bobi kulii-tal am tiimin umi am daan-yaabu tap ale, God ami ok tabuulin tunum ensel kiita, wiit bobi kulii-tal am tiimin tunum ililtap o. ");
INSERT INTO tif_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kemin, okokmin tunum ta al mafak iyo dolbi sikip fak-daa-fak-daa kebi kulii-din as kuyak daalip kiin-tabaneba tap ke am mafiing diim tiltam tabokomu uyo, ");
INSERT INTO tif_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dukum Ami Man Nalta taba nalmi ensel iyo fokoli tildaak ilomdip tunum mafak ta taba aptum kusal imi aket fukunin ku-mafak-daayip yang ban kemin tunum iso, le tunum unang kukup mafak tabuulin iso, kiilile ensel iyo itam-ilomdip unang tunum mafak kii yakal ilmi foko kulii-din ");
INSERT INTO tif_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","fokolip yak wing tiil mafak almi suunkup kiin-bam ilin kaami tem un-ilom kawu angtiil yol awak-kup dap-tiiyila-balaya, Kwin, kaluuso kanimin o, kalalupla kaldang liip talbup yoko? kal-bomdip dukum-kup fuut-bam ama-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kemin, God ami unang tunum itale, ilmi Aalap God ami abip kawu bomdipla talaba tam God alaltap ke ban wakamin dinim tituun-kup ke-lomdiwa, atan tik-daalin tap ke-lokomip. Ibi nami weng uyo weng sanip kaali, lukuuyulu kulaalalip kemin, ti dotu dukum-kup kutal-fukulin o kala, Yesus ayo almi daang bakaalin tunum imi kanolin weng tem ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus ayo asuk weng do kusnum ma faldak-tii bokoyila ko: Siin sawaayak kawu tunum ma moni yaapkan ayo fakamsi ket tem kawu abumsile, kuliila ti kulii-din langabip kawu tawaal dikil-alom kuwala-laaba. La, bii taanala tuumon ket ayo ukol ti tawaal tem kabaaku maaklo tiinsula kulaa, am ma daanule, tunum kusnum ma din-ilomda tawaal fakan-tal-bomdala tuumon ket ayo utama ko. Mep tawaal kaali, ami tawaal disa. Lale, tuumon ket kaami fiyaap kaali, Kwin disa akal ma ke-bamda ami aket ayo fukuna ko: Ti yaap ke mep tuumon kala nalmi ma ke-lokomi no! kalale, asuk tawaal ayo kulii-tal aba yak moni ket ayo katii kambola din almi mafek mafek am kaptam bombuu uta alik fakabi kulii-din tiila molip kaami moni ayo kulii-din tawaal kaa mo-lomdala, aptum taansa ami tuumon yaapkan yam kuwaasa namti kulu alami alik-daap kensu no, kala Yesus ayo bokoyila ko. (Kemin, do weng kaami miit uyo boko-lomdu: Dok kanolin unang tunum kiita God ami miit tem unemin kaami aket ayo dukum-kup yeluya, ti yaap ke tam unokomip no, kemip namti, iyo kabak-ami fiyaap kaata-kup tabe-bamdip imi mafek mafek aket yesu uyo alik kela-lomdip tiltam God ami abip unokomip o, kala faldak-tiimin weng uyo kanum bokosu ko.) ");
INSERT INTO tif_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Yesus ayo faldak kulu tiimin weng ma bokoya-lomda bokola ko: Siin kawu sisol bonang amiit ayo saanbi kulii-tal fik-tiibi kutiilaya, tal saan-bisip. Kemin, akal bonang ayo fen-tal-une-bam utamala, Ti tambal kaata-kup bombe kala-lomda saansa. Kemin, ilom am ma daanule, fen-tal aba yang ulayi, Tunum ma ata ti bonang tambal ma kutal-fukuba kala kalale, kaata molon o, kala, katale, uyo utama yi, Kaami tuumon saanin uyo dukum o, kalale, kambola almi tuumon bombu ami kuluu bonang kaami molakin kalin uyo iipnu kala kalale, kulaa kela din almi mafek mafek am tem kaptam bombuu uyo alik kulii-din tiila alik molipla, umi tuumon uta kuluu kulii-tal-ilomda bonang tambal ayo mose no, kala Yesus ayo kanum bokoyila ko. (Kemin, faldak-tiimin kaami weng miit uyo boko-lomdu: Kanola tunum unang kii kanta atin tiltam God ami miit tem uyo tam unon o, kalala, aket aalu namti, kamasi uyo ami mafek mafek aket-kup suun fukun-bam iloma uyo kela-somdaya tiltam God ami miit tem tildang talokoma no, kala do weng uyo kanum bokosu ko.) ");
INSERT INTO tif_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus ayo unang tunum God ami abip unokomip kaami sang kaata faldak kulu tii boko-lomda: Tunum malo ma kiili, aniing men abuumin sakbaalim dukum uyo binalip umbalaak ok tem un-ilomdu aniing yaapkan akal alik akal alik iyo afetbi kutiilule, ");
INSERT INTO tif_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tunum iyo utamiwa yi, Aniing men uyo dongna kala kalale, kulaa men ayo sisii kulii umbiyak ok balang diim daa-lomdip daak ok dinin diim kawu tiin-bomdiwa, aniing iyo kutaltam tii-tii ke-bam tambal tambal kiita-kup foko ket tem abuu-bam ale, yak mafak kiita asuk fokolip daak ok kumun tem une-bulu kemip. ");
INSERT INTO tif_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kanolin kemin ale, am mafiing diim kaali, God ami ensel iyo tal-ilomdip unang tunum iyo bik-kutii-lomdip mafak ita yaap imi iipyak tem kaptamu ulelbi kutii kulii-tal yakal ilmi baan ma fak-daa-lom ale, mafak ita, ");
INSERT INTO tif_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","fokolip yak as mafak suunkup kiin-bam ilin umi tem un-ilomdip angtiil yol awak-kup tabeya-bulula, Kwin kaluso kanimin o, kala kaldang liip tale-yimbup yoko? kal-bomdip dukum-kup ama-mokomip o, kala Yesus ayo faldak-tiimin weng uyo bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus ayo faldak-tiimin weng uyo bokoyila disa kelule, dik-daayila ko: Ibi nami faldak-tiimin weng bokoli kaami miit kabak talalu utam kaal kelip elile disa? yakala isiik bokolip: Ayo, utamup o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesus ayo bokoyila: Ibi utam kaal kelip namti, lo utamsip tunum tiltam nami man ke-lomdip God ami miit tem talbip ibi ti tambal-kup tiinip ko. Lo utamsip tunum ibi tunum imi siin kaami mafek mafek tangbal so, kama umi mafek mafek tambal so, kuyaku-diyaku kutiimin tunum ililtap o. Kemin, unang tunum iyo tal bokola-lomdip: Nuli dong dokoyan o, kalokomip uyo ali mafek mafek uyo tangbal-kup dong dokoyokoma. Kanolin tap kemin, siin kaa ibi God ami sawaayak ami weng uyo talalu utamsip. Kemin, kamala kalaali God ami kama weng umi kuluu bakayila-tabasi uyo, utam kaal ke kelip. Kemin, ibi weng alep kalawuuli kulii tulu tulu ke kuyak-mim-daalokomip kaali, kibi God ami weng kaa unang tunum kii tambal-kup bakayokomip o, kala Yesus ayo lo utamsip tunum imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus ayo faldak-tiimin malo ma uyo bakayinbi dinim kelula, kulaa kela abip kaptam-ali kulaa kela ");
INSERT INTO tif_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","asuk tal almi abip diil Nasaret tala kemin, ayo tal-bomdala yak aba din lotu am kawu unang tunum iyo God ami weng uyo kukuyim-bala, tunum unang iyo weng san-ilomdip aket fanang alik tambanuya, iyo dik-daa una-tala-ke-bamdip bokolip: Kwin, weng kala kukuyimba kalawaata, dok liip utam dik-daa kuluu utamse ni? E, kawanta kukon-balaya, kanolin talalmin akal almi kusnum kaa kanuba ni? ");
INSERT INTO tif_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ali abip kaltam-ami as kom bakel-bamda mafek mafek talalmin tunum ami man ata ale, ami awak kuluuli Maria, nakal-fakal nikil kiitale, Jems, Josep, Saimon, Judas, kelin ale, ");
INSERT INTO tif_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ami nakal-unang ita abip kalawu bom-bilip kemin, ali win tibin tunum disa. Kulaa disa abip tunum. Kemin, kulaami weng kulaa, weng sanokomup disa! kala-lomdip ");
INSERT INTO tif_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","daang ukolip, itam-ilomda Yesus ayo bokoya ko: God ami profet o, kala weng tem bakayilin tunum ayo din abip malo ma kaami tam unokoma kaata, abip kaptam kasel iyo boko-lomdip: Tunum kalawaayo, win tabin tunum o, kala ami weng baka-mokoma kaali ti, talalu weng san-kaamum o kalokomip. Lale, din almi abip tituun kaptamu unokoma kaata, almi abip kasel so, almi aptum kasel so, iyo ami weng kaali ma, weng sanokomup dinim o, yaka-lomda, ");
INSERT INTO tif_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","abip kasel iyo aket fanang daa-lom: Ali God ami titil kutal-fukusa disa yo, nakan-kaabip kala kalalaya, Yesus ayo mirakel o, kala talalmin akal kusnum akal kusnum yaapkan iyo almi abip kaptam-ali ma kanolama dinim; alep-kup kiita no. ");
INSERT INTO tif_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kemin, kulaata Yesus ami sang uyo, uu kalale kalaa Provins Galili kayaak imi tunum King Herot ayo weng san-ilomda ");
INSERT INTO tif_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","almi okok kemin tunum imi bokoyila ko: Daa. Kulaali oksam ukayin tunum Jon taanse alta tam tiin-ilomda kanolin titil kaali, kuluu-lomda, mirakel o kala kukup almi kusnum kusnum kaali kanuba no, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kemin, Herot ami weng kaali, siin kawu ali Herot almi abokonim Filip ali taanin dinim bom-balaya, Herot ayo Filip ami kalel Herodias uyo tik-daa kuluula kala, kala-lomda kawu, Jon namti suunkup bakaan-bamda: Uyo kapkal utamsap kemin, unang kuumi kuluu-lomdap uso laabip kaali, God ayo boko-lom: Kukup kaa kanumin daa yo, kalsa namti kulu lobap te! akan-kaabi kela kela kemala, Herodias uyo Jon ami aket atul ayo kola-lomdu Herot ami oko-takaan-buluya, almi soldiya iyo bokoyilaya din-ilomdip Jon ayo sok de dibii din kalabus am daa-silip. ");
INSERT INTO tif_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kanola Herot ayo, Jon ayo aalon o, kala katale, ayo utama yi, Tunum unang ili utamipla, Jon kaali God ami profet weng kukaayin tunum o, kalbip kala kala-lomda utama, Awu, aalokomi namti, kiisiik balaap-nalalip o, kala itam suun-daa-lomdala aasa disa. Kuno kelaya, dibii din kalabus am kawu daasip ko. ");
INSERT INTO tif_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Am ma daanule, Herot almi awak duusu umi aket fukunin am uyo daanule, kulaa Herot ayo unang tunum yaapkan iyo naan-daayila, tal Herot ami am kaptam kumup daa kulaa, ima in-bom fiyaap duu-bilipla, kulu Herodias umi man unang sii uyo tal kiimi tiin diim kuluwu was tambal ayo disa akal ma ke-bam saman-buluya, Herot ayo umi was samanbu uyo atam-ilomda fiyaap duu-bam ale, bokola ko: ");
INSERT INTO tif_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kaali ti tambal kemin, nali mafek mafek tambal ma kup-ton o, kebi kemin, kupkal bokop-na-lomdap dok nolin mafek mafek kaata ma kup-nan o, kalap uyo atin ti faneng kup-tokomi no, kala kanum bokowa le, ");
INSERT INTO tif_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","kulaata, unang man uyo din awak bokowa-lomdu: Akamen o. Nali din-ilomdi awakim ami diim kaa dok nolin mafek mafek uta ma kup-nan o, akokomi yoko? kalula, kulaa awak uyo bokolu: Dindap Herot ami bokola-lomdap: Nami aket fukunbi kaali, kabi din oksam ukayin tunum Jon kaami dabom kaata ukduu kuu falet diim tii kulii-tal kup-nan o, kalbi no, kala kanum bokolan o, kala awak uyo kanum bokowu ko. ");
INSERT INTO tif_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kanum bokowuya, uyo din Herot ayo bokolu weng san-somdala utama yi, Kabak-ali ti kukup mafak kala kala-lomdaya ayo ti aket uluum dukum-kup dap-teluya, daa yo, kalokin. Yale, ayo aket fukunaya, Tunum unang yaapkan bom-bilip kalawiita, nami weng kutiili uyo, weng sanip kala kala-lomdaya, kiimi tiin diim kaa ke-lokomi disa yo, kalalaya kulaata ayo kanoli no, kalaya kulaa almi soldiya ");
INSERT INTO tif_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ma dabaala din kalabus am din-ilomda Jon ami dabom kaa ukduu-lom ");
INSERT INTO tif_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","kuyak falet diim tii-lom kulii-tal unang man umi kuwalala, uta kuluubu-kup, kulii din awak umi kuuwu ko. ");
INSERT INTO tif_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Uyo kanowulula, Jon ami daang bakaalin tunum iyo Jon ami sang uyo weng sandiwa, tal Jon ami as kulii uyo dibii din dawaa-lomdip mulo kawu din Yesus, Jon sang uyo din bokolip ko. ");
INSERT INTO tif_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Am bombe kawu, Yesus ayo Jon ami sang uyo weng san-somdala, aket uluum-kup dap-telule, almi daang bakaalip tal-unemin tunum kiita foko kulii-tal aba tam bot tem tiila nikil tam tiindip abip kaptam kambolalip Ok Galili kumun diim liip yakyak biyak malii aba din tunum dinim, disanang ma kaba unum o, kalalip unip ko. Unang tunum iyo weng saniwa yi, Yesus ali bot tem liip yak malii unon o, kalala unaba no, kalaliwa, ilmi abip ayo kela-lomdiwa, yakal tawaal liip Yesus fanang unip ko. ");
INSERT INTO tif_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus nikil iyo yak balang diim yak ilom, Yesus ayo talaala yi, Kwin! unang tunum yaapkan namti tala-tala-kebip kala, kala-lomda ti ayo talalu dukum-kup olen-daayila-lomda, unang tunum mafak umusip iyo yam-talal kaama ko. ");
INSERT INTO tif_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Uyo kanu-bala bom bii mepso am tiin tala-bulule, ami daang bakaalin tunum iyo tal Yesus bokolip ko: Kamokim aa, am kala am tiin-som ale, unang tunum dinim bokon kemin ale, kalawaali ima dinim. Kemin, unang tunum kii yim-baalap din abip ma ma un-ilomdip kawu, ima ayo ma mo-lom inalipla siin o, kala kanum bokolipla, ");
INSERT INTO tif_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesus ayo bokoyila: Nali yim-baali unokomip disa; ti kalawu bom-ilipla, Nikil kipni inin-inin ma kuyilipla yo! yakale, ");
INSERT INTO tif_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","nikil isiik bokolip: Nuli ima kaa tiknalup daa. Kemin, bret awakal ma le, aniing alep ma kalawiita-kup bom-bilip o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus asiik bokola: Kulii-tal nami kup-niwa yo, yakale, fan, ");
INSERT INTO tif_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","kulii-tildang koliwa, Yesus ayo unang tunum imi bokoyila, daak tikiin kon diim kulu tiinaaliwa, bret awakal ale, aniing alep ma iyo foko-lomda titam abiil daa, God ami yaap ke yo, anba-kup, bret so, aniing so, iyo bakela kutii-lomda almi daang bakaalin tunum imi kukaaya-tal-unemsi kulaalipla, ");
INSERT INTO tif_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","alik iyo kuluu inbi-lom tiknipya kulaata, Yesus ami daang bakaalin tunum iyo yak ima tinan-bamdip kutiibip daam daam kiiyo, fakan-tal-unemsi basket almi-kup tal aba tam talangkal kiita, abuu-bilip dongniwale, ");
INSERT INTO tif_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ti tunum deng ilmi-kup faiv tausin (5,000) ema le, ilmi man sole, unang tan iso, kuyaku-diyaku ke-lomdip ima kala inip ko. ");
INSERT INTO tif_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kemin, Yesus almi daang bakaalin tunum imi bokoya-lomda: Nak-tunum kusal kipyo, kipsiik tam bot tem tiindip kalaali kelalip umbiyak ok kumun malii kaba kemiwa, nata unang tunum kalawiiyo, yim-baali uniwa yo, yakala uniwa, akal bomda tunum unang iyo yim-baala unaaliwa kulaa, ");
INSERT INTO tif_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","akal alafin God ami beten kamaalon o, kalala, kulaa yak aba tam amdu tikiin kawu tam ilomda beten ke-bala bom bii am tiinu. ");
INSERT INTO tif_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Am tiinule, bot uyo yakyak umbiyak ok kumun iip-iip kulu un-laam-siliple, kulu inim aalap dukum ma tiltam aba-lom fu-fu-balaya, ok ayo iin-balaya une-bulu tale-bulu ke-bamdu bot namti kuluu kulaalu umbu talbu ke-bulula bom bii ");
INSERT INTO tif_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","am daan daan tala-balale, kuluwu Yesus namti daang bakaalin imi fanang ok daang tip diim liip tol-tol tala-balala, ");
INSERT INTO tif_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","almi daang bakaalin tunum iyo Yesus ayo atamiwa yi, Ok daang kun diim liip talaba kala, atam-ilomdip imi fanang maaklo keyilu suun-bam ol-bamdip bokolip: Naka yi! Kaali sakbal i! kalalip suun-daa-laam-siliple, ");
INSERT INTO tif_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","kulaali, Yesus ayo abiltap-siik bokoyila ko: Nak-tunum kusal kipyo! Nalta kemin ale, ibi suunin daa yo; kela-somdiwa titil-fak-daalin a! yakala, ");
INSERT INTO tif_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita ayo bokola ko: Kamokim kapyo, kabi kaltapta namti, nayo bokop-nawa ok daang diim kaami liip kapni balap ayo yak unon o, kalale, ");
INSERT INTO tif_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus asiik bokola: Ayo, tal a! akaya, Pita ayo bot tem tiinba uyo kelala, daak ok kumun diim liip Yesus ami be unaba; katale, ");
INSERT INTO tif_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","inim ati so, ok so, uta utam suun-daa kem-salale, kulaali abiltap-kup bakat mo ok kumun tem unon o, kalbi kala, kala-lomda Yesus ami naan-daala ko: Kamokim kapyo, dong dokop-napla, yaap kelon o, aka kem-salale, ");
INSERT INTO tif_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","kulu Yesus ayo taba maak fak-daalin tap ami sikil ayo dabaa yak Pita ayo dap-tal fuku-lomda bokola ko: Kabi kanimin o, kalalawa kapni aket fukunin uyo Yesus kaa titil-foko dong dokop-nokoma ne? dong dokop-nokoma disa ye? kalalawa suun-daalap i? Yak kanolin aket kaa fukunin daa; kabi utam, Awu, ali ti yaap dong dokop-nama no, naka-yaamin o, aka ko. ");
INSERT INTO tif_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Akale, kulaa alep tam bot tem tiinipla, kulu inim ati namti kulu ditang-kala disa kelule, ");
INSERT INTO tif_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","daang bakaalin tunum iyo bot tem tiinaabip yakal atam-ilomdip Yesus ami win uyo kufon-bam ale, bokolip: Yi, kabi ti faneng God ami Man alik-daap o, akip ko. ");
INSERT INTO tif_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kemin, ok kumun iip-iip bilip ayo kulaa kelalip yak abip Genesaret umi mepso ok balang diim kawu yak unipla, ");
INSERT INTO tif_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","abip kasel iyo atamiwa yi, Kaa Yesus alta tala kala, kalbip-kup, weng binalip yak abip ma ma unule, tunum unang mafak umkan-unsip iyo Yesus ami be kulii-talemip kemin, ");
INSERT INTO tif_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yesus ami dukum-kup nen-bam bokolip ko: Kamokim kapyo, kuno kamboyawa yakal yak kapni ilim matum kulaata-kup malep-tiwa kulaali yaawa-yaamik o, kala bokoliwa, Yesus namti, Ayo! yakaya, unang tunum kawanta yak Yesus ami ilim matum diim malelip iyo yaawa-yaamip ko. ");
INSERT INTO tif_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kemin, Falosi so, lo utamsip tunum so, alep iyo Jerusalam lo tal Yesus ami dik-daala bokolip ko: ");
INSERT INTO tif_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kapyo, sawaayak numi awil-fakal ili boko-lomdip: Kabi ima inamnon o, kalap uyo, sikil kaa talalu diinga-somdapla kayi! kalsip. Awil-fakal ili suunkup ti ilmi man iyo kukuyin-kup kem-laabip. Kemin, nuli kanolin kukup uta kano tabuulup bombuu. Lale, kapni daang bakaalin tunum ili kanimin o, kalalip numi awil-fakal imi kukup kaa kenbip-kup, imi sikil uyo talalu diingmin dinim ke-bamdiwa, ima uyo inan-umbip yoko? akiwa, ");
INSERT INTO tif_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus asiik bokoya-lomda: Aa, ibi yi? Kanimin o, kalaliwa iltipni kawil-fakal imi weng sawaa kaata-kup weng san-kaa-bamale, God ami weng uta kuyang saak tela-laabip i? ");
INSERT INTO tif_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kemin, God ali boko-lomda: Kipni kaalap so, kawak so, iyo talalu tiin mo-lom ale, imi weng ayo weng san-kaa-bam dong dakaayim-bam ke-bamdiwa yo, kala-som ale, aa kawanita ami aalap so, awak so, kiimi weng mafak bakayila namti, ayo aalip taan-yaamin o, kala kanum bokosa. ");
INSERT INTO tif_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yale, ipkal iltipni weng kusnum ma boko-lomdip: Kanola tunum ayo moni bombe ayo God ami kolon o, kala-lom aalap so, awak so, imi bokoya-lomda: Nami moni kutal-fukubi kalawaali, God ami kolokomi no, kalbi kemin, asuk ulduu-lomdila akam ibi talalu tiin mo dong dakaayokomi dinim o, kala namti, ");
INSERT INTO tif_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ami awak-aalap tiin molokoma disa kaa yaap ke-lokomu no, ken-umbip. Kemin, kabak-ali fan, iltipni sawaa weng kaata-kup kanum baka-bamdipla, God ami weng uyo kuyang saak tiilala tabasip te! ");
INSERT INTO tif_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ibi kasen-foko weng alep bakamin tunum yam kemin, sawaayak kaali, God ami profet Aisaya ali tifan kipni kukup kaami sang kaali, God ami Sukon Tem uyo dola kutii boko-lomda: ");
INSERT INTO tif_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God kaa boko-lom: Kanolin unang tunum iyo disa nami tong kaata-kup bakan-unbip; kemin ale, nami aket kup-na-lomdip tildang nalmi miit tem uyo tololup o, kala-lomdipla, yang samaan bokon kawu laabip. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ililta unang tunum kii ilmi weng sawaa kaata kukuyim-bamdip bokoya-lom: Kalawuuli God ami weng sawaa kemin, dotu kutal-fuku-bomdiwa kayi! kem-laabip. Yale, nali imi kasen-faka-bamdip tong bakan-yaabip kaa weng sanokomi dinim o, kalala, God kaa kanum bokosa kayi! kala Aisaya ata dolsa no, kala Yesus ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesus ayo unang tunum imi naan-daayila tal atamiple, bokoya-lomda: Nali sikil ninak kaami sang kaata ma bokoyokomi dinim; mafek mafek umi taba kipni iipyak tem kaami fanang saanin uyo fan atin ti ku-mafak-dakaayin kaami sang kaata ma bokoyokomi. Kemin, weng san-ilomdip talalu utamin o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","God ami tiin diim kaa, tunum ali taba-lomda, sikil ninak tabemin kukup aye, saak yak mafek mafek awem o, kalsip aye, uta inamnala, daak mat tem un-ilomdu, uta taba atin dap-mafak-daalokomu dinim; aket mafak fukun-bam, weng mafak bakayokoma kuuta taba dap-mafak-daalokomu no, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mulo kawu, Yesus almi daang bakaalin tunum iyo tal bokolip ko: Kamokim kapyo, kapni weng kaa bokoyilap uyo Falosi ili weng san-ilomdip aket mafak ke aket atul tabeyu kemin, kabi kabak utabap e disa? akiwale, ");
INSERT INTO tif_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","kulaa Yesus ayo do weng katip ma faldak-tii bokoyila ko: Unang tunum ili mafek mafek nami Atok abiil kayaak ami langabip ultap kemin, mep mafek mafek san iip maakup maakup iyo alalta ultiila tabamniple, mep al kaata alalta disa, iip kulu tabe-bulu, kesu. Kemin, ayo tam taba-lomda al ayo bita kulaala unokomu. Kemin ale, mep kamok kamok kiili ti al kiiltap kesip. ");
INSERT INTO tif_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kemin, kiimi weng kaa weng san-kaamin daa. Kanola kamok kamok kiili tiin fiim ililtap tam tunum tiin fiim ali ma taba-lomda aptum tiin fiim ma ami liip ayo kukola namti, kulaali ti alep maakup fukulin kulii afun tem unokomip o. Ultap o. Falosi ili liip din God ami abip unemin uyo ma utamsip dinim. Ili dok kano-somdiwa, unang tunum kusnum iyo God ami liip kaa kukuyokomip disa yo, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ayo Yesus ami bokola ko: Kamokim, kapyo, mafek mafek awem o, kalip inin umi faldak-tiimin weng miit ayo ma bokoyan o, akale, ");
INSERT INTO tif_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus asiik bokola-lomda: Kamok kamok kiili, bam-daalin dinim kemin ale, kuno ti kipkal ti bam-daa kaal kelin dinim bom-bilip ema? ");
INSERT INTO tif_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ibi nami weng kaami miit kuu ma talalu utamin disa kelip kanolin kemin, nami weng kala bokoyokomi uyo talalu weng san-iliwa yi! Tunum ayo mafek mafek inam-nokoma ayo daak mat tem kabaku bombiile, imaan dabaalokoma kawu, tiil-ban-ilom disa ke-lokomu. Kemin, kuuta taba ami aket tem uyo ku-mafak-daalokomu disa. Kemin ale, ");
INSERT INTO tif_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","tunum ayo aket mafak suunkup fukunokoma namti, kawu weng mafak namti baka-mokoma. Kemin, almi aket mafak fukunokoma kuuta, taba-lomdu ayo tunum dap-mafak-daalokomu no. ");
INSERT INTO tif_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kanola, tunum ayo kukup mafak kaa nolin dinim ilomdaya, aket mafak usiik fanang daaba-kup, mulo kawu yang kukup mafak ayo nolokoma. Kemin, kukup mafak nolon o, kalokoma kaali, kala-nuumin kaata ko: Aket mafek fukunin; aptum aala taan-yaamin; aptum tiin kuwaala-lomda ami kalel uyo sadikimin; sadiki-bam aptum dap-mafak-dakamin; yukut inin; aptum ami ban kelin disa, bom ila kasen-foko din kiyap ami bakaalin; saak yak aptum ami daang tem weng bakayin uta kanu-mokoma. ");
INSERT INTO tif_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kemin, kanolin aket mafak uta taba-lomdu tunum ayo dap-mafak-dakan-umbu. Kemin, God ali kanumin tunum kaami fiyaap uyo duun-umba dinim o. Kanola, tunum ayo awil-fakal imi kukup uyo kutal-fuku-lomda kamasi uyo sikil diinga-lomda ima inin inam-nokoma disa kaali, kuuta taba God ami tiin diim uyo ma dap-mafak-daalokomu dinim o, kala-lomda Yesus ayo almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus nikil iyo Juda kasel imi tawaal ayo kelalip yak aba bilin kusnum imi tawaal ma unip ko. Kusnum kayak kayak kiimi abip dukum alep kaptam-ami win kaali, Taya so, Saidon so ko. ");
INSERT INTO tif_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kemin, tunum unang kawu ilin iyo Juda kayaak daa; kiili Kenan bokon kasel ita ko. Kaptam-ami unang ma tal Yesus ami naan-bam bokolu ko: Kamokim kapyo, kabi King Devit ami man loop kapta nami olen-daap-na-lomdap kapni titil kaata, kuluu-lom dong dokop-nan o. Nami man unang uyo sinik mafak ta taba-lomda um-mafak-daalaya, atin ti mafak-kup utamsu. Kemin, sinik mafak kulaa fotabamnap yak banaya, man uyo yaapnuk o, aku. Katale, ");
INSERT INTO tif_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesus ali mep unang kuumi weng ayo ma mowin dinim kewale, almi aptum kusal ita tal Yesus ayo dukum-kup bokola-lomdip: Kamokim kapyo, unang kuuli numi daang tem kawu tal-bomdula, dukum-kup naan-talabu. Kemin, uyo fotabamnap banuk o! akiwa, ");
INSERT INTO tif_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","kulaali Yesus asiik imi weng an-anung daa bokola: God ali kusnum kayak kayak unang tunum yakal kanola kaa kanum talabu tap ke imi dong dakaayan o, kala-lomdala, nam-baala talsii disa; God ali utamala, Israel kayaak kiili, sipsip iyo babon tal-une-bam maaklo ke-silip ililtap u, kala-somdala kiita, dong dakaayan o, kala-somdaya, nam-baala talsii no, kala kanum bokolaya, ");
INSERT INTO tif_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","unang uyo weng san-ilomdu beten kemin kukup uta kuluu-lomdu katuun duung fakela daak tiin ale, bokolu: Kamokim kapyo, dong dokop-nan a! aku ko. ");
INSERT INTO tif_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kemin, (Juda kayaak ili fakaaniing unang tunum imi win uyo bokoya-lomdip: Miyaan o, yakan-kaa-bam ale, ilmi unang tunum kiitale, man o, yakan-kaa-bam ken-umbip.) Kemin, Yesus ayo faldak-tiimin weng ma boko-lomda: Man katip katip imi ima duk-duu kulii-din miyaan imi kuyokomip kaali, yaap tambal ma keyokomu dinim o. Kanolin o, kupni dong dokop-tokomi kaali, yaap kep-nokomu disa yo, wakale, ");
INSERT INTO tif_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","unang usiik ami weng bokola uyo bokolu: Kamokim kapyo, kaali ti faneng bokolap. Katale, miyaan imi aalap ayo ima in-balala, daam sekela daak tebol kaami minlo tem abam-nokoma kaali, miyaan iyo tebol kaami minlo tem kabaaku tiinaabip ita taba-lom inan-laabip. Kanolin tap kemin, kabi dong dokop-nokomap kaali, yaap kep-tokomu no, akule, ");
INSERT INTO tif_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","kulaa, Yesus asiik bokowa-lomda: Kupyo, tambal kemin ale, kubi nitamawa yi, Ali ti yaap dong dokop-nokoma nu! nakap kemin, kupni bokop-na-lomdap dong dokop-nan o, nakap uyo dong dokop-tokomi no, waka-lomda weng kaata-kup bakam-salale, abiltap-siik umi man unang uyo yaapnu ko. ");
INSERT INTO tif_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kulaa, Yesus nikil iyo Taya kasel so, Saidon kasel so, imi am bokon ayo kulaa kambola yak aba umbiling Ok Kumun Galili dal umi balang diim umi liip kawu kutal-fuku yak aba bitam amdu tikiin kawu tam tiin-bomdiwa, ");
INSERT INTO tif_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","unang tunum yaapkan iyo aptum kusal yawiit fuku tiinaasip so, sikil yaan mafak so, tiin fiim so, talang abat ke weng bakamin daa kesip kiiso, mafak-alin akal alik umkan-unsip iso, iyo dii dibii tal Yesus ami miit tem tii-bilipla, Yesus ata alik talalma ko. ");
INSERT INTO tif_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kanu-balaya, unang tunum yaapkan iyo atamiwa yi, Tunum yawiit iyo tola tal-une-bala, sikil yaan mafak iyo tangbal ke-bala, tiin fiim imi tiin iyo baa-lom mafek mafek atafii-balale, weng abat iyo weng baka-bala, kem-tiibip kala, kala-lomdip unang tunum iyo utam aket fanang alik tam baneyuluya, Israel kayaak numi God ami win ayo kufolum o, kala-lomdip fiyaap duumip ko. ");
INSERT INTO tif_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kanola, Yesus ayo utama yi, Unang tunum yaapkan iyo bom-bilip kala, kala-somdaya, almi daang bakaalin tunum iyo naan-daaya tal atamipla bokoya-lomda: Tunum unang kalawiili naso bombii am asuumano kelip kalaali, iyo ima kaa disa keyila, ima tinap keyimba kemin, nali olen-dakaayinbi. Lale, nali ima tinap kaa yim-baali abip unokomip namti, un-bomdiwa, ima tinap liip tiinokomip. Kemin, yak disa kanolin kaa, yim-baali unokomip dinim o, yakale, ");
INSERT INTO tif_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","daang bakaalin tunum isiik Yesus ami dik-daalip: Unang tunum kalawiili yaapkan deng saak kaa tunum dinim bokon kalaali, dok liip ima ayo kuluu-lomdup alik iyo ifalup ina tiik-nokomip? akiwa, ");
INSERT INTO tif_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus asiik nikil imi dik-daayila: Aa, ibi ima bret kaa kanim kal ma kulii-talbip i? yakale, Yesus ami weng bokolip: Nuli bret fetkal ale, kuno aniing katip katip malo ma kiita-kup o, akipla ");
INSERT INTO tif_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","kulaata, Yesus asiin unang tunum imi bokoyila, daak tawaal kulu tiinaaliple, ");
INSERT INTO tif_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","bret fetkal kiiso, aniing so, iyo foko-lomda God ami yaap ke yo, anba-kup, kulaa bret so, aniing so, iyo bakela kutii-lomda kuluu almi daang bakaalin tunum imi kuyilala, ita kulii-taba-lomdip unang tunum imi kabaanuyip ");
INSERT INTO tif_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","alik iyo imbi-lomdip tiikniple, kulaali daang bakaalin tunum ita taba ima yelbip anung anung ayo foko-lomdipla, basket almi-kup fetkal kiiyo, abuulipla dongnip ko. ");
INSERT INTO tif_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kanola tunum almi-kup fo tausin (4,000) ale, ilmi unang tan so, man so, iyo kuyaku-diyaku ke-lomdipla, ima kalawaali inamnip ko. ");
INSERT INTO tif_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kanoliwa, Yesus ayo unang tunum kiili, im-baala ilmi abip unaalipla, Yesus nikil iyo amdu tikiin ayo kulaa kela tildaak aba talaba tam bot tem tiindip umbilip, bilin abip Magadan umi tawaal mepso kabanip ko. ");
INSERT INTO tif_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Falosi sole, Sadusi so, iyo tal Yesus ayo dap-kuku-bam dik-daa-lom: Kapyo, kabi mirakel o, kala kukup akal kusnum inang ma kukuyilawa, nuli utamupya yi, Kabi God alalta tam-baala tal-salap kala, takum o, akiwale, ");
INSERT INTO tif_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesus asiik bokola: Tam atan uyo tem unula utamiwa yi, Am kel isak fokola kalokomip uyo ibi utam boko-lom: Atan tem un-ilomda am tiinu kel isak fulut fokola kemin, am sabi ayo am tangbalim daan bom ilokoma no, kal-bom ale, ");
INSERT INTO tif_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","kutim kaata am atam talaaliwa, Abiil ayo ok alala-lom malang tini tal-una kala atam ale kawu, ibi boko-lomdip: Am titak foko tal-unu. Lale, am ayo matikba kemin, wom talokomu no, kal-bom kem-yaabip o. Abiil kaptam-ami uta-mokomip kaa utamiwa yi, Am ayo kanolokomu kala kem-yaabip. Yale, ibi nami kukup kala kanubi uyo ma talalu utam-ilom, God alalta taba dong dakaan-balaya, kabak-ali kanuba nu ma nakan-kaabip dinim o. ");
INSERT INTO tif_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ibi God ami weng uyo ma weng san-kaabip dinim. Ibi ti aket mafak-kup fukun-bamdipla, bokop-na-lomdip: Mirakel o, kala, ukol ulmi kukup akal kusnum ata ma kukuyilawa, nuli utamupla yi, U, fan God alalta tam-baala tal-salap kala tukum o, kebip. Katale, uyo ma kanolin kukup ayo ma kanolokomi disa; ti maakup ma kaata-kup kukuyokomi kaali, Jona ami kano-lomda toop aniing dukum sakbaalkan umi mat tem kaptoowu bombii am asuumalo kelaya, asuk tiltam talsa ultap uta ma kukuyokomi kayi! yaka-lom Yesus ayo kanum bokoya kamboya tabana ko. ");
INSERT INTO tif_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus nikil iyo tam bot tem abalip yak aba umbiyak ok kumun malii yak abaliwa, Yesus ami daang bakaalin iyo aket fukuniwa yi, Numi bret ayo lukuuyulu kutii kela tulup kawi! kala-lomdip aket tambaneyilu, fanang daalip ko. ");
INSERT INTO tif_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus ayo faldak-tiimin sang ma faldak-tii bokoya-lomda: Nak-tunum kusal kipyo, ibi Falosi so, Sadusi so, imi yiis uyo talalu utafii-bam tal-une-bamdiwa yi! yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kanum bokoyilala, daang bakaalin tunum iyo weng sanbip-kup, bokola bokola ke-bam taken-una-tala-ke-bam bokolip: Kwin! bret ma kulii tilin daa, kelup kaata, yiis sang kaa bakaba nema yo? kemip. ");
INSERT INTO tif_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kemin, Yesus ayo almi daang bakaalin tunum imi weng kanum bakabip uyo utam-ilomda, ayo bokoyila ko: Ibi kanimin o, kalaliwa, bret kaa ma kulii-tilin dinim kelup o, kalaliwa, aket kabak ti suunkup fukunbip i? Ibi utam: Awu, ali ti yaap nuli tiin molokoma disa ema yo? kalaliwa aket yaapkan kaa fukunbip o? ");
INSERT INTO tif_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Ti ipkal utam-tamin! Siin kaali, lukuuyase nema? Kibi nitam iliwa, bret awakal ma kuliita-kup foko tunum almi-kup faiv tausin (5,000) kalawiimi fakela kutii kabaanuyi im-bomdip yel-biliwa, ima anung anung ayo ket kanim kal abuu-silip? Kuno mulo kawu ibi nitam iliwa, bret fetkal ma kuluu-lomdi tunum ilmi-kup fo tausen (4,000) kalawiimi fakela kutiiyili im-bom kemsip umi ima anung daam daam ayo ket kaa kanim kal kaata abuu-silip? Kabak kanoli utam-silip kaali, kanimin o, kalalip nami titil kabak talalu utamin disa ke-silipla, ibi aket yaapkan fukunbip yoko? ");
INSERT INTO tif_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ipkal utamiwa yi, Kabak-ali faneng yiis so, flawa so, kuyak-mim-daa fuulipla, faskaamin umi mafek mafek kaami sang bakaba disa. Kaa Falosi so, Sadusi so, imi yiis uta taba ipni yam-mafak-dakamin kaami sang uta bakaba no, nikin o, kalaliya yo, kala Yesus ayo kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kanum bokolala, Yesus alami daang bakaalin tunum iyo utamipla, Yesus ali bokoya-lomda: Bret faskaamin umi mafek mafek uta talalu utafii-bam tal-une-bamdiwa yo! keba disa. Ami weng bakaba kaali, Falosi so, Sadusi so, imi kukup mafak kukuyila-yaabip kuuta, talalu utafii-bam tal-une-bamdiwa yo! kal-bomda kaami sang uta bakaba nu, kalip ko. ");
INSERT INTO tif_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kulaata Yesus so, almi daang bakaalin tunum iso, yak aba umbilin abip ma Sisaria Filipai umi mepso kulu um-bom ale, Yesus atam almi daang bakaalin tunum imi dik-daayila ko: Unang tunum ili Dukum Ami Man Nami sang kaa boko-lomdip: Kaali kawanta no, nakan-kaabip i? yakale, ");
INSERT INTO tif_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","kulaa daang bakaalin tunum isiik Yesus ami weng an-anung-daa bokolip ko: Unang tunum malo ma ili boko-lom: Kaali oksam ukayin tunum, Jon Baptis ata no, ke-biliple, malo ma ita boko-lom: Yi, kaali God ami weng ku-fatap-dakamin tunum sawaayak biisa Elaija ata no, takan-kaa-bilip, malo ma ita bokop-ta-lomdip: Kaali God ami profet sawaayak bom-biisa Jeremaya ata no, takan-kaa-bilip, malo ma ita boko-lomdip: Ali God ami profet akal kusnum ema yo? takan-kaa-bala kebip te! akiwa, ");
INSERT INTO tif_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesus ayo bokola: Aa, ibi yi? Ibi kaa kawanta no? nakan-kaabip i? yakale, ");
INSERT INTO tif_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita ata Yesus ami weng uyo maan tela-lomda: Kabi fan ti God almi Man uldaa-tam-buusa Kraist namti kulu-balap ale, God ami dabaali din unokoma no, kal-bomda Israel-miin numi bokoyila fen-tabasup tunum namti kulu balap o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","kulaa, Yesus ayo Pita ami bokola-lomda: Jona ami man Saimon, kabi ti, kaa faneng bokolap kemin, tawaal diim kalawaami tunum ata ma tituun weng kala bokop-tin dinim; ti yaap ke nami Aatumen abiil tikiin kayaak alalta tituun-kup bokop-tala utamdawa kemin, kaa bokolap. ");
INSERT INTO tif_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kemin, kulaata weng ma bokop-ton o, kali kemin, nali talalu-tamulila, kabi maman tuum tap titil bikilawa kep-tokomi. Kemin, kulaata kapni win kusnum ma kaali Pita yo, tiki kaami miit kaali, tuum maman o, tiki. Kemin, nami okok ke-mokomap uyo, asuk nalmi titil uta kuluu-lomdawa, unang tunum yaapkan iyo foko kutal-dang nalmi miit tem tiilawa, nalmi unang tunum ke-lomdiwa, yakal maman tuum ulultap ke titil-kup fokoliwa kamboyokomi. Kemin, sinik mafak alik ita taba-lomdip im-baak moliwa, taan-ilom maaklo ke-lokomip disa. Kemin, ti suunkup ilokomip. ");
INSERT INTO tif_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nami titil kala kup-tokomi kalaali, kabi ti yaap unang tunum iyo bakayin-balawa, tiltam God ami miit tem kaa tiltam talokomip o. Kanola kabi utamapla, Dok nolin dok nolin kukup uyo mafak o, kalalap God ami tunum unang imi bokoya-lomdap: Kaali kanumin dinim o, kalokomap kaa, God abiil tikiin kayaak akal ti bokoya-lomda: Kaa kanumin daa yu, yokokoma. Kanolin tap kemin, kapkal utamapla, Kukup kaa tambal u, kalalap God ami unang tunum iyo bokoya-lom: Kaa kanumin o, kalokomap kaali, God abiil tikiin kayaak akal bokoya-lom: Kulaa kanumin o, yokokoma no, kala Yesus ayo Pita ami kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","kulaa, almi daang bakaalin tunum alik iyo bokoya-lomda: Kipyo, kibi tunum kusnum imi bokoya-lomdip: Yesus kaali God ami uldaa-dabuula tiltam Kamokim kesa tunum Kraist kayi, kalalip bakayila-tal-unemin disa yo, kala dil-moya ko. ");
INSERT INTO tif_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kemin, am daanba kulu, Yesus ayo weng kufo almi daang bakaalin tunum ku-fatap-daa bokoya-lomda: Ilom am ma daanuya kawu, niyo din abip win finin Jerusalam kaptam banila, Juda kayaak imi kamok kamok so, pris awem tunum imi kamok kamok isole, kuno lo utamsip tunum iso, ita taba-lomdip nayo kukup mafak angtiil yol kukaap-nam-bamdip nam-baalip yak Juda imi waasi imi sikil diim abamniya, nelip saakni namaalip bii am alep keliya, am asuum diim kawu God ayo nam-fola, asuk tam tiinokomi no, kal-bom bakaya yakyak kema ko. ");
INSERT INTO tif_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kulaa, Pita ayo alafin dibii yang kabangu dabak saan-bamda bokola ko: Kamokim kapyo, kabi kanolin aket kaa fukun-bamdapla bakamin dinim o. God ali kaa kewa tildak kapni diim kaa abam-nokomu dinim o kalale, ");
INSERT INTO tif_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus ayo fal-siki taba tiyak Pita kaa talalu atafii-bamda dabak-saan-bam bokola: Kabi nami God ami aket fukunba ultap uta fukunbap disa; waasi Setaan ami kukup altap kaata kukaap-nambap ale, tawaal diim kalawaami tunum imi aket fukunbip tap uta fanang dakabap kemin, kep-na-somdapla tabanan! Kabi tuum liip kawu kumo-bulula, tunum yang umi diim kawu yaan kuyak mo bang-baang-daa yang aba laabip tap ke umi tuum kanolin tap ke-bamdap kabi nami liip ukdaap-non o, kalalapla kanum bokolap. Kemin, kabi nami waasi tunum Setaan ami kukup tap uta kukup-nambap kemin, kulaalan o, anba-kup, ");
INSERT INTO tif_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","fal-siki titaldak daa almi daang bakaalin tunum imi bokoya-lomda: Dok nolin tunum kapta, naso din nami okok kemin kaata, okok kemon o, kalap namti, yak kaltapni aket fukunin kaata-kup kanumin kaali, kambola-lomdap nami aket kaata, dukum-kup kup-na-lomdap, nami as diim angtiil yol kuluulokomi ultap ke-lom taanami kulaali, kunola taanami no, kal-bomdapla, kanolin kukup kaata kuluu-bomdapla, tiltamdap nami okok kemin kaali, kutal-fuku kulii-taba balapla yo! kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kanolin kemin, tunum iyo kawanta ma almi angtiil kalan kaata, suunkup aket kuwa-bom, almi aket fukunin kaata-kup kanum tal-unemon o, kema namti, kaata taan-ilomda maaklo ke-lokoma; kemin ale, tunum ayo kawanta, kuno yang kunu-bili waasi iyo taba-lomdip nelamip kulaa, kuno nelamip o, kala-lomda tildang nami lak kaata-kup dukum-kup kutal-fuku kulii-taba namti, kanolin tunum kaata ti suunkup ilokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kano tunum ma am bokon kala dik-daa kulaasu kaami mafek mafek uta ti alik kaa-bam ale, suunkup ilin umi liip uyo ma dotulin dinim kema namti, almi bung mafek mafek yaapkan kaa kan-umba uta taba-lomdu dong dokolokomu nema? Disa te! Kuu dong dokolokomu disa kawi! Ali ti mafek mafek tambal-kup tabasu uyo ma God ami kolaya, God ayo bokola-lom: Yi, kabi suunkup ilokomap te! akokoma nema? Daa; suunkup ilin kaali, sisol ta kuluu mo kuluu-laamin umi mafek mafek disa te! ");
INSERT INTO tif_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kano am ma daanokomu kaali, Dukum Ami Man Nayo, nalami Aatumen God almi falala-kalin diim kawu, ensel iso, talokomup kawu, tal-ilomdi unang tunum alik maakup maakup imi dok nolin kukup kanum unsip uta tiiyokomi kayi! ");
INSERT INTO tif_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kemin, tituun weng kala bokoyokomi uyo, dotu weng san iliwa! Iip maakup maakup kula tola-bilip, ibi saaknin disa, bom ilom utamiwa yi, Dukum Ami Man Ayo titil tabin kuluu-lom Kamokim King kelaya, unang tunum tiin mola kala kalokomip kayi! kal-bomda Yesus ayo almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kemin, am bukupkal uyo disa kelale, kulaa Yesus ayo taba-lomda Pita so, Jems so, almi niing Jon aso, nikil asuumano, ita-kup foko imbiila yak aba umbitam amdu tikiin aalap batbat ma kawu tam unip ko. ");
INSERT INTO tif_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nikil tam abale, tunum asuumano kiili, Yesus kaa atamipla, Kwin! kaa akal almi kusnum ke-lomda ami tibi kun kaali ti, falala-kalin dukum atan kiinin tap ke-lomdu ami ilim uyo ibin namaal tap ke kelu kala kala-lomdip, ");
INSERT INTO tif_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","itamipla, tunum alep ma sawaayak kawu bom-biisip Moses sole, Elaija so, alep ili asuk abiil tikiin kela taldaak tilip Yesus so weng bakabip kala, kala-somdipla, iyo itamip ko. ");
INSERT INTO tif_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kanoliwa, Pita ayo itam-ilom Yesus ami bokola-lomda: Kamokim, kapyo, ti yaap ke kapso tal kalawu bom-bulup kemin, nuli am kiin-laap asuumano aye ma ema de-lomduwa, ma kaata kapni, ma Moses ami, tam ma kaata Elaija ami, ke deyiliya yo, kemale, kulaali ");
INSERT INTO tif_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","tam ibin uyo tildaak tilnong mo-imaalule, ibin tem kaptam liip weng ma boko-lomda: Kiwe! kulaali nalmi Man aket-iip kemin, nali ami fiyaap-kup duubi. Kemin, ami weng bakama uyo ti weng san-kaa-bamdiwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kemin, aptum kusal iyo weng kaa weng sandiwa, suunin dukum ta akal ma ke-lomdip tilik duung fakela daak tibi ukdaalip tawaal lo un-ilom ale, ");
INSERT INTO tif_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesus ayo tal bitaleya, yak bokoya-lom: Kipyo suunin daa kemin, tam tiinin a! yakala, ");
INSERT INTO tif_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","fan tam tiin tiyak daaliwa yi, Yesus kaata-kup bombe kala, kalalip atamip ko. ");
INSERT INTO tif_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Atamipla kulaa, Yesus nikil iyo amdu tikiin ayo kulaa kela tal-bom ale, Yesus ayo almi daang bakaalin tunum nikil asuumano iyo weng kukuya-lomda bokoya-lom: Nak-tunum kusal kipyo, weng san iliwa! Ibi din tunum kusnum kayak kayak kiimi diim ayo kanolin kaa atamip, kaami sang uyo ma bakayin dinim o! Kano ti bom-bilipla bii, Dukum Ami Man Nayo taanila nam-bii din namaalip bii, tam tiindi tambani kala, kala-somdiwa kabaku yaap, unang tunum kayak kayak iyo bakayin o, kalala kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kanum bokoyilaya, daang bakaalin tunum iyo weng kusnum ma Yesus ami dik-daalip ko: Lo utamsip ili kanimin o, kalalipla boko-lomdip: God ami profet weng ku-fatap-daa bakayin tunum Elaija sawaayak bombii taansa asiik talale, kulaali, God ami uldaa-dabuula tiltam Kamokim kesa tunum ata mafiing tem kawu talokoma no, ken-umbip i? akaliwa, ");
INSERT INTO tif_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus asiik imi weng maan tiiya bokola ko: Kabak-ali fan kemin, Elaija asiik dusiin daa tal-ilomda kanolin ok kaata kanu-mokoma ko. Tal unang tunum iyo dong dokoyilaya, aket dot kaamipla, God ami uldaa-dabuula Kamokim kesa tunum ayo mulo kawu talokoma. Kata, ");
INSERT INTO tif_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","weng ma uyo bokoyokomi: Elaija ali ti talse. Yale, tunum iyo utamiwa yi, U, kulaata kala-silip dinim; ilmi aket-kup fukun-ilomdipya, aalip taanse ko. Ulultap kanola unang tunum iyo taba-lomdip Dukum Ami Man Nakal ti kanola kukup mafak ayo kup-nokomip o, kala bokoyila kelale, ");
INSERT INTO tif_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","kulaali daang bakaalin tunum yakal utamiwa yi, Yesus ali fan Elaija ami sang uta bakaba disa; oksam ukayin tunum Jon ami sang kaata bakaba kala kalip ko. ");
INSERT INTO tif_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kemin, Yesus, Pita, Jems, Jon, nikil kanolin iyo tildaak amdu tawap tem tildaak uliwa, Kwin! unang tunum yaapkan tala-tala-ke-lomdip, Yesus ami liip fenbip kala, kalalip tal itamiple, tunum ma Yesus ami be tal tilik duung fakela daak tiin ale, ");
INSERT INTO tif_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ayo bokola ko: Kamokim kapyo, nami man ayo olen-daala-lomdap dong dokolan o. Kaali nuukaal daam kesa kemin, dabuu dap banala wing tiil une-bam ale, wok tem une-bam ke-balala bii, angtiil yol daka-bamda utamsa kala kala-somdila, ");
INSERT INTO tif_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","kapni daang bakaalin tunum ita dap-talalulin o, kalaliya dap-tama tal daalila, ili dok kano dap-talalulalip dinim kebip o, kalale, ");
INSERT INTO tif_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus ayo almi daang bakaalin tunum iso, unang tunum bom-bilip kiiso, iyo bokoya-lomda: Kwin i! Ipni aket fukunin uyo atin fan tituun kelin disa kawi! Nali kipso bom bii kayoop yaapkan dakan-tiisi. Kata, ibi nitamiwa yi, Kaali God ami titil kaata kuluu-lomda sinik mafak iyo fotabeba yak banen-umbip kala, naka-laabip disa yo. Nali ipso bii, am kanim kal kelila, ibi natamiwa yi, Ali ti God ami titil kaali, nokol ti kuyama no, nokokomip i? Nali ipni aket mafak fukunbip kaali, daal tabep-nu no, kala-lomda fal-siki taba man ami aalap ayo bokola ko: Tunum man ayo dibii tilin a! yakale, kulaali, ");
INSERT INTO tif_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","man tunum ayo dibii tal daalipla, Yesus ayo dukum-kup sinik mafak ami bokola kem-salale, kulaata man ayo kela yak banaya, kulu man ayo abiltap tambalna ko. ");
INSERT INTO tif_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kanola kawu alami daang bakaalin tunum nikil iyo utamipla, Unang tunum iyo alik tabanaalip kala kalale, tal Yesus ami bokolip ko: Nuli kanimin o, kala titil fak-daa sinik mafak kaa fotabamnup yak banin dinim kela ni? akiwa, ");
INSERT INTO tif_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus ayo bokola: Ibi fan atamipla, Ayo ti God ami titil kaata, nuli kuyama kala, kalolip dinim kebip. Kemin, utamdula ibi taang-kala-lomdip fotabamnip yak banin disa keba. Nami weng kala bokoyokomi uyo talalu weng san bom-iliwa. Tunum ayo mastat san katip tiyok kaa diki-laaba alaltap kemin, kabi mafek mafek katip ami aket ayo ma fanang daa-lomdap, God ali ti yaap dong dokop-nala kanolokomi kala, kalokomap namti, ali dong dokop-tokoma. Kemin, bii mafek mafek dukum tiltam tabokomu uyo God ami dik-daalawa, ata dong dokop-taya, kanolokomap ko. Amdu kabi kaltapni baan diim kabaak tolsap uyo kela-somdawa, umbilap umbilin bokon kusnum kawu tolnan o, kalokomap uyo, fan kanolokoma. Dok nolin dok nolin kukup ayo God ami no, kalokomap kaa kabi titil-foko kanolokomap te! ");
INSERT INTO tif_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kemin, sinik mafak imi fotabamnon o, kalap namti, kamasi kaali ima fala-lomdap God ami beten kamaalokomap kaata, sinik mafak iyo yak banemin ale, kaami kanumin disa ke-mokomap kaa, sinik mafak iyo yak banokomip dinim o, kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kemin, Yesus ami daang bakaalin tunum nikil iyo alik din Provins Galili kaptamu din ang-delipla, Yesus ayo boko-lom: Kipyo, mepso kulu nami nak-tunum ma ayo aket fal-siki-lom Dukum Ami Man Nayo, nam-fatap-daa-lomda nam-baala yak waasi tunum imi sikil diim abamnila, ");
INSERT INTO tif_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nelip saaknile, iyo nim-bii din namaalip bii am alep ke am asuum diim kawu, asuk tam tiin baalokomi no, kalaya almi daang bakaalin tunum iyo weng san-somdipya, atin ti aket uluum kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus aye, almi daang bakaalin tunum aa, iyo nikil din abip Kapeneam din itamiple, lotu am dukum kaami takis kaamin tunum iyo Pita ami dik-daalip ko: Kapni kukuyin tunum ali lotu am diildiil talalmin kaami takis ali ma saanin so ken-umba ne disa? akalipya, ");
INSERT INTO tif_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita ayo weng maan tiiya: Ayo, ali saan-umba te! kala kela bom bii yak aba tam am un-ilom kaami sang uyo ma bokolama dinim kulaa bom ilale, Yesus ayo Pita ayo dik-daa bokola ko: Saimon aa, kaa kawanta takis ayo tawaal diim kalawaami kamokim king ami kukaan-bam saan-umbip i? Fan ti alami man kiita-kup saan-umbip e? malo kayak kayak ita-kup saan-umbip yoko? Aa, kapni aket fukunin kaali yi? akaya, ");
INSERT INTO tif_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita asiik bokola: Yi, kayak kayak ita-kup saan-umbip o, akaya Yesus ayo bokola ko: Faneng bokolap. Kemin, lotu am diildiil uyo nalmi Aatumen ami am kemin, lo kuuli nami bokop-na-lomdu: Kanola man kabi takis uyo kuno saanan o, nansu dinim. Lale, ");
INSERT INTO tif_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tunum kiili utamiwa yi, Kaa God ami man u, ninsip dinim. Kemin, nali takis molin dinim ke-lokomi kaa, ili boko-lom: Yi, ali kukup mafak keba no, nokokomip aye kemin, kapyo din wok kumun tem kawu aniing din tal-une-bamdap, kamasi diildiil ami aalokomap uyo kuluu-lomdap, umi bon-toko kaptoop ali utamawa yi, Tuumon dukum uyo buu kala, kalokomap uyo kulaata tikna kemin, kuliilap kulii-tal kapsole, naso, alep maakup numi takis moni ayo kulii-tal tunum kiimi kuya molan o, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kemin, kanola Pita so, Yesus so, alep iyo weng bakam-silipla, daang bakaalin tunum iyo tal Yesus ami bokola-lomdip: Kamokim kapyo, bom bii-lom tam God ami abip ilokomup kaali, kaa kanta ata ata kela aptum kusal nuli kabaak banup ata kamokim ke-lokoma ni? akiwa, ");
INSERT INTO tif_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus ayo man katip ma naan-daala tal atama dap-tal fuku dap ilimi miit tem kulu tii, ");
INSERT INTO tif_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ayo almi daang bakaalin tunum imi bokoyila ko: Ibi man katip kuluwaa atamin! Weng uyo tifan bokoyokomi kemin, kipni kanolin aket mafak fukunbip ayo kuno kela fal-siki-lomdip man katip katip kalawiimi aket fukunin tangbal ultap kelin disa kelip namti, God ali ibi keyila ami abip kaa unokomip disa yo. ");
INSERT INTO tif_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kemin, man ili fiyaap duu-bam ilmi win kaa kufuumin dinim; imi aket ali ti tangbal-kup ma fukun-bam laabip. Kanolin kemin, dok nolin tunum ata almi aket-kup fukun-bam alami win kufuumin dinim, aket tangbal fukuna namti, kaata aptum kusal kii kabaak banip keyila, God ami abip tangbal uyo kamokim ke-lokoma. ");
INSERT INTO tif_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kemin, dok nolin tunum ata kalanolin man altap ayo ma atamaya, Yesus nami win diim uyo man kalanolin kaali, dong dokola namti, kaata nami dong dakaap-nin kukup namti kabe no, kal-bomda Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesus ayo asuk bokoya-lomda: Kusnum kayak kayak iyo utamiwa yi! Tunum ayo taba unang tunum God ami lak duu-yilin katip katip kebip imi yam-mafak-daalon o, kem-tabon o, kala ata-mokomip namti, kiili tam-ilom tuum dukum ata ma kuluu kuyak tunum kaami kum kun diim kabaku sok de kuu dabaalip daak yol ok kumun tem una namti, wok ta an-dong-dokola taanala, bi-lom God ayo yol katip uyo kolokoma. Ale, kanola kayak kayak iyo tunum kaa kanolin dinim ke kambolip, taba unang tunum God ami lak duu-yilin katip katip kebip iyo yam-mafak-daala kela yang kukup mafak uyo nuumip namti, God asiik taba atin ti kaami yam-mafak-daala kaami du kaa kolaya, tunum ayo atin ti angtiil yol awak dukum uyo dakan-unokoma. ");
INSERT INTO tif_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tawaal diim kasel unang tunum yaapkan ili ti tawaal diim kaldaak-ami mafek mafek aket kaata-kup yan-bulula, fukun-bam yang kukup mafak ayo num-yaabip. Kemin, God ali kaami kalan kaata im-bak-saan-bamda, imi kukup mafak kaata, du tiiya-laa-mokoma kalaliya, kemin, dukum-kup olen-yimbi no. Kukup mafak uyo suunkup tabanang tunum imi aket fukunin uyo ku-mafak-daayiluya, iyo yang kulaak tildang kulaak ke-bamdip ban ken-umbip. Lale, dok kanolin tunum ata kukup mafak uyo kanu-bamda almi aptum kusal oko-tokoya aye, kukuya kela, yakal yang kanolin kukup uyo kanumip namti, God akal taba-lom tunum kaa dabak saan-bam, kaami aptum kusal foko kulii yang banemin uyo tela-laa-mokoma. Kemin, ibi kabak talalu utafii-bamdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kabi kanola utamapla, Nalmi yaan aye sikil aa uta nam-bii yang daalu kukup mafak uyo kemon o, kalbi kala, kalap namti, kaltapni yaan sikil ayo ukelnap unip malii maakup ma ke-lomdawa, kukup mafak ayo kambola bombii taan-somdapya, tam God ami abip kawu suunkup ilokomap kaata, atin ti tangbal; kemin ale, kabi yaan sikil kii bo-kukan-tiilokomi dinim o, kalalap kukup mafak-kup nuubi taanap takalip, God ami ensel ita tam-baalip din suunkup as kiinin abip unokomap kaali, atin ti tambal disa yo. ");
INSERT INTO tif_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aa ti, kanola utamapla, Nalmi tiin kaali, kukup mafak ayo kukup-nam-bulula kanumon o, kalbi kalap namti, kaltapni tiin malii uyo ulduu kulaalap unu, tiin milii maakup ke-lomdap kukup mafak ayo kambola bombii taan-ilomdap tam God ami abip kawu suunkup bom ilokomap kaata ti tambal. Lale, kabi tiin malii uyo ulduu kukan-tiilokomi dinim o, kalalap kukup mafak kaata-kup nuumsi, bii saaknap kala kala-lomdip, God ami ensel ita tam-baalip din suunkup as kiin-bam ilin abip unokomap uyo, tambal disa yo, kala Yesus ayo kanum bokose. (Kemin, kaami weng kaa kanum bokose kabak-ami miit kaali boko-lomdu: Kabi utamapla, dok nolin dok nolin mafek mafek uta taba-lomdu sasii tam-bii yang kukup mafak tem tiinilon o, kem-tabu kalap namti, yak kanolin mafek mafek kulu daang ukuwa-lom kukup mafak uyo kuno kewa ti tangbal-kup bomdawa yo, kalsu ko.) ");
INSERT INTO tif_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kemin, Yesus ayo bokoya-lomda: Nak-tunum kasel kipyo, nami weng kala bokoyokomi uyo weng san iliwa! Kipni aket ayo fukun-ilom unang tunum God ami lak katip duulin bom-bilip win dinim o, kalokomip. Lale, ti ipkal utamin! Kiimi tiin molin tunum o, kala ensel ili nami Aatumen God ami miit tem kulu bomdipya, unang tunum God ami lak katip duubip imi sang uyo suunkup God ayo bakaala-yaabip. Kemin, ipni aket uyo fuku-daa, Kiili win dinim o, kemin daa; ibi talalu utafii-bamdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Dukum Ami Man Nali, tal unang tunum yang Setaan ami miit tem un-ilom maaklo kesip kiita, foko kulii tildang God ami miit tem tiilon o, kalalila talsii no. ");
INSERT INTO tif_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nami faldak-tiimin weng kala bokoyokomi kaali, daa weng san iliwa! Tunum ma sipsip almi-kup wan handret (100) kalawiita tiin mo-laaba. La, maakup ma maaklo ke-lokoma kaali, ali dok kanolokoma? Sipsip tiin molin tunum ayo sipsip ilmi-kup nainti nain (99) ita-kup kamboyila amdu tikiin kawu bilipla, din sipsip maaklo keba ata fen-tal-une-mokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Din fen-tal-une-bamda ata-mokoma uyo, sipsip tiin molin ayo fiyaapmin dukum duu-mokoma. Kemin, ami sipsip maakup kaami fiyaap ayo aptum kusal 99 maaklo kelin disa bom-bilip, kiimi fiyaap kanolin disa. Kwin! disa akal ma ke-bamda fiyaap duu-mokoma. ");
INSERT INTO tif_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ultap kemin, nami Aatumen abiil tikiin kayaak almi aket fukunin uyo unang tunum almi lak duu-yilin katip katip kebip iyo maaklo kemin o, kala, ken-umba disa! kala Yesus almi daang bakaalin tunum iyo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus ayo asuk boko-lomda: God ami unang tunum kipyo, kanola God ami lak duulin ali ma taba kapni kukup mafak ayo kep-ta namti, kabi kayak kayak kii bakayin disa; ti alafin bombe kala, kala-somdapla kawu, din atamapya, ami kukup mafak kaa kanop-timba kaami sang uyo bokolapla, ayo kapni weng uyo weng sandala, almi kukup mafak kanuba uyo kulaala namti, kaata asuk alep maakup ibi kuyak dii una-tala-ke-lom ale, fiyaap duu-bamdip ilokomip. ");
INSERT INTO tif_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kemin, kapni weng uyo weng selin dinim kela namti, kaltapni kaptum ayo maakup aa, alep aa, ita ma im-tal tiilapla, alep kiita taba-lomdip alep kipni weng bokola una-tala-ke-mokomip kaali, weng sanokomip kaata, ti tambal o, kala God ami Sukon Tem uyo kanum bokosu. Kemin, alep imi weng so, kapni weng uso, uyo weng sanokoma kaata ilom am ma daanokomu uyo tunum ban keba ali maso kukup mafak uyo kanup-tokoma dinim o. ");
INSERT INTO tif_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lale, tunum ban keba ayo nikil asuumano kipni weng uyo weng selin dinim kela namti, din sios tunum unang iyo afet-daa-lomdip alik kaami sang uyo bokoyipla, weng uyo talaluliwa, tunum ban keba ayo alik kipni weng uyo weng selin dinim kela namti, kipni iipyak tem be ayo fotaba dabaalip tam banokoma kaata, ti tambal kayi! Ale, ibi kusnum tunum so, takis kaamin tunum mafak so, imi itam suun-bam yang itamip iso, tal-unemin dinim kem-yaabip tap keliwa, tunum ban keba ayo fotabip yang banemin o, kala ko. ");
INSERT INTO tif_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yesus ayo asuk bokola ko: Kulaa nali alik God ami lak duulin unang tunum tawaal diim kala bom-bilip ipni bokoyon o, kalaliya kemin, weng san iliwa! Alik ibi utamipla, dok nolin dok nolin kukup uyo mafak o, kalalup God ami unang tunum imi bokoya-lomdup: Kaali kanumin dinim o, kalokomup kaayo, God akal ti bokoya-lomda: Kaali kanumin daa yo, kalokoma. Aa ti kuno alik ipkal utamiwa, Kukup kaa tambal u, kalalip God ami unang tunum iyo bokoya-lom: Kaa kanumin o, kalokomip kaali, God abiil tikiin kayaak akal bokoya-lom: Kulaa kanumin o, yokokoma no. ");
INSERT INTO tif_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kemin, nali asuk weng kusnum ma bokoyokomi: God ami lak duulin tunum alep tap asuumano tap ibi aket maakup ke-lomdip nami Aatumen abiil tikiin bombe ami beten kamaan-bam dik-dakalokomip kaayo, ali weng san-ilomdaya ipni beten kebip kaa maan tiiya-lomda kanolokoma. ");
INSERT INTO tif_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kemin kaali ti, God ami lak duulin tunum alep tap, asuumano tap, Yesus nami win diim kawu afet-mokomip kaa, nali tal ipso ilokomi ko. ");
INSERT INTO tif_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kemin, Pita ayo tal Yesus ami dik-daala ko: Kamokim kapyo, nami nak-tunum ayo kukup mafak kukaap-nala, uyo ami kukup mafak kukaap-namba uyo kukan-tela-tela kemsi bii liip kanim kal ma fak-daalon o, nakan-kaabap i? Kuno kambola lukup-na yakyak kebi liip fetkal fak-daalokomi kabak kaata-kup ti yema? aka-lomda dik-daale, ");
INSERT INTO tif_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","kulaa Yesus asiik bokola: Daa, fetkal kaa ti disa. Kabi kaptum kaami kukup mafak kukaap-tamba kaali, tiimin daa. Kanola kaptum ayo kukup mafak yaapkan kaa kukaap-tin-kup keba. Yale, kabi suunkup kaa kela kela ke-mokomap kaali ti tambal o. ");
INSERT INTO tif_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kanolin kemin ale, God ami unang tunum tiin saanin kukup kaali, kamokim king ma ami kukup ultap kemin, kamokim ali aket fukun-ilom: Nalmi okok kemin tunum ta nami uluum kukaap-nip dolasii uyo, tik-tiili utam-somdipla umi maan uyo kup-nin o, aka-lomdaya, ");
INSERT INTO tif_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","alami dong dakaalin tunum ma ayo bokola ko: Kapta din tunum uluum kup-na-silip iyo im-tama tal o, akaya din maakup e kala dibii tal-tal kema. Kemin, tunum ma dap-tama tala kaami uluum ayo sakbaalim dukum kemin, ");
INSERT INTO tif_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","kaali moni dukum kaa ma kutal-fukulin dinim. Ali dok kano taang-kala-somdala, kaa molama disa yo, kalalaya, ami kamokim ayo soldiya imi bokoya-lomda: Kibi nami ok tabuulin tunum kalaaso, ami kalel man iso, imi bung alik kiiso, iyo kulii-din mafek mafek saanin baan diim tiilip molipla, umi sisol uyo kulii-tal tiilip, nata kuluu-lomdi alimal kiita, tunum kusnum ta foko kulii-din tiilaya, ami disa ok fokolin unang tunum ke-lokomip kaata, nami uluum namti kulu molokomip kayi! kema ko. ");
INSERT INTO tif_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ali kanolaya kawu, ami okok kemin tunum ayo weng sandaya, tilik duung fakela daak almi kamokim ami miit tem kulu dakela daak tiin-ilomda dukum-kup bokola ko: Kamokim kapyo, ata-bom ilawa molokomi kemin, olen-daap-na kep-napla, kapni uluum kaa alik molon o, akale, ");
INSERT INTO tif_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","kulaa ami kamokim ayo utamala kanum bokola kalale, kulaali olen-daala-lom ami uluum uyo maas kuno kelale, kulaa masiim kuno kambowala tabana ko. ");
INSERT INTO tif_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ok fukulin tunum ayo kamokim kambola tam abip tam ulale, Alami ap-tunum okok kemin tunum ma siin kawu, uluum katip ma nonsa ayo tal bombe kala kalale, almi aptum ayo yak del kalum kuyaku dap-tal fuku bokola ko: Baan kamala kulu ti kapsiik nami maan ayo baan tii kup-na-somdawa ya! akale, ");
INSERT INTO tif_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","aptum ayo tilik duung fakela daak tiin dukum-kup bokola ko: Daa kuno kep-nawa kaa molokomi kemin, olen-daap-nawa kawu, kapni maan katip kulaa molon o, akan-kaaba. Katale, ");
INSERT INTO tif_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","aptum ami weng uyo weng sanin disa ke-lomda yak aba din bolis bokoyilaya, kulaa bolisman ita tal dibii din kalabus am daa bokolip ko: Kabi ti kultamu bom-balap bii, kaptum ami maan ayo telokomap kawu, fan kabi tildaa tam-baalup tam-baa unokomap o, akiwale, ");
INSERT INTO tif_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","kulaa aptum kusal yakal utamiwa yi, Nak-tunum kaa dibiilip kalabus am daalip kala kalaliwa, iyo aket atul dip-tiiyu din ilmi kamokim ayo alik kaami sang uyo bokoliwa kulaali, ");
INSERT INTO tif_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","kamokim ayo weng san-somdala, soldiya ami bokola ko: Din nami okok kemin tunum mafak ayo dap-tama tal o, akale, din dabuu dap-tal daalaya kamokim ayo bokola ko: Kabi kukup mafak tunum kemin, kapni dik-daabap kaata nali olen-daap-ta-lomdila, kapni maan dukum ayo kuno kep-tambi no. ");
INSERT INTO tif_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kabi nami olen-daap-ti ulultap ke-lomdap kapsiik taba kap-tunum kaayo, olen-daalakin kaali, tambal. Yale, kabi kaali olen-daalin disa kebap. Kemin, kaata nakal kanola kabi olen-daap-tokomi disa yo, akale, ");
INSERT INTO tif_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","atin aket atul dap-telule, kulaali soldiya imi bokoyilaya, ita tunum mafak ayo de dibii din kalabus am daa bokolip ko: Kabi ti kultamu bom-balap bii kamokim king ami maan dukum uyo alik telokomap kuyaku tildaa tam-baalup tam banokomap kayi! kala kanum bokola-silip o, kala Yesus ayo faldak-tiimin weng uyo bokoyimba-kup kulaa, ");
INSERT INTO tif_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","asuk maso bokola ko: Kiwe, faldak-tiimin weng kaami miit uyo aket fukun-ilom utamin! Kaptum kusal kukup mafak kapni kukaap-tambip uyo kanubip kayi! kala, kapsiik kukup mafak ayo kukaayin daa; lukup-talala, kabi umi aket uyo maso ma fukunin daa. Kanola kaptum kusal imi maan uyo kukan-tiiyin disa ke-lokomap uyo, nami Aatumen abiil tikiin kayaak alalta kapni uluum kuu kukan-tiip-tokoma disa; angtiil yol kaata kup-tokoma kayi! kala Yesus ayo Pita ami kanum bakaan-bisa ko. ");
INSERT INTO tif_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus ami weng ayo bakayinbi alik dinimnu kulaaba-kup, Provins Galili kaptam kulaa kela Ok Jodan ayo yakan yak malii abala yak aba din Provins Judiya anung kaptam banale, ");
INSERT INTO tif_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","kulaa unang tunum yaapkan iyo dik-daa dabii tal Yesus ami daang tem lo kawu yak aba tal Yesus almi bombe kaltam banipla, Yesus ayo unang tunum mafak umulin ma tawaal kuluwu bom-bilip iyo yam-talal kaama ko. ");
INSERT INTO tif_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Falosi malo ma iyo tal Yesus ami kasenolupla, Ayo weng mafak so ma bokola kala kala-lomdup dibii din weng talalmin baan diim daalum o, kala-lomdip, tal dap-kuku-bamdipla bokolip ko: Kapyo, Moses ami Lo numi kuyinsa kabak-ali tunum ayo unang kuluu kewa-yaamin sang uyo kanimin o kalsu ni? Kabak-ali boko-lomdu: Tunum ayo almi kalel uyo kewon o, kala uyo yak alik kalok nolin kalok nolin kukup ma nuu-mokomu kaami kalan uyo fotabam-nokoma kaata tambal o, kalsu nema? akiwale, ");
INSERT INTO tif_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus asiik imi weng ayo an-anung daa bokoyila ko: Ibi God ami Sukon Tem kaami sang kulaa tik-tiibi utamsip. Yale, kanimin o, kalaliwa nami dik-dakaap-ninbip i? Anung uyo boko-lomdu: Kamasi kawu, God ami mafek mafek alik talalu kutiiba-kup ayo imak so, ikis so, iyo talalu-yimula akam maakup ke-bom biisip. ");
INSERT INTO tif_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kanolin kemin, God ali boko-lomda: Akam maakup kesip diim kabaku tunum ayo unang kuluulokoma kawu, tunum ayo almi awak so, aalap so, iyo kamboyimba-kup, yak almi kalel umi diim kabaku fep-nala kawu, akam maakup angtiil maakup tap ke-lokomip o, kalsu. ");
INSERT INTO tif_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kemin, asuk maso alep ke-lokomip disa; atin akam ili ti maakup ke-lokomip. God ami tunum so, unang so, kulii-tala-tala kelaya, akam maakup kebip uyo, tunum ma ata taba akam imi angtiil maakup kebip uyo lolala kela yang-bana tildang-bana kemin disa yo, kala Yesus ayo kanum bokoyilale, ");
INSERT INTO tif_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","kulaa Falosi iyo Yesus ami dik-daalip ko: Kapni kanum bokolap uyo tituun namti, Moses ali kanimin o, kala-lomda God ami Sukon Tem uyo weng kusnum kaa dola kutii boko-lomda: Tunum kabi kalel kuu kewi no, kalap namti, kabak-ali fiitmin disa. Imakim kapta sukon ma dola kuu kalel umi kuwapla, kuluu-lomdu kep-ta unokomu kayi! kalsu no, akiwale, ");
INSERT INTO tif_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus ayo kiimi weng an-anung daa bokoya-lomda: God ata unang kuluula tunum dabuulu kemin umi lo kutiisa ayo ibi weng sanamup daa yo, kala kala-somdala Moses ayo, Ayo, kalala ibi iltipni unang tan iyo kamboyila-yaabip. Katale, kamasi God ami unang tunum talalu-yimusa kaali, God alalta tunum so, unang so, iyo kanolin kukup mafak kaata kanumin o, kalala, kuyinsa disa yo. ");
INSERT INTO tif_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kemin, nami weng ma kala bokoyokomi uyo talalu weng san iliwa! Kanola tunum ma ayo almi kalel uyo sadikimin dinim tambal-kup bombuu. Yale, alalta taba kewi no, kalala kewa-lomda, unang kusnum uta kuluula namti, God ami tiin diim kaami kanola kaali, fan sadiki-bamdala, alami kalel umi um-mafak-dakan-umba no, akokoma no, kala Yesus ayo Falosi imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kemin, almi daang bakaalin tunum iyo weng kaa weng san-ilomdip Yesus ami bokolip ko: Tunum ayo utamaya, Unang kuluu kulaakamin kaali, fiitmin o, kala namti, ayo unang dan-kaamin uyo kulaa-lomdala, kapkes ilokoma ayo, tambal o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","kulaa Yesus asiik bokoyila ko: Tunum yaapkan iyo fan titil-foko kapkes ilokomip dinim; ili unang dan-kaa-mokomip. La, God ayo tunum malo iip maakup maakup ita-kup titil kuyilaya, ita-kup titil-biki-lom kapkes ilokomip o. ");
INSERT INTO tif_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tunum ili unang dan-kaamin disa ke kapkes-kup ilin kaami miit kaa yaapkan o. Tunum malo ma kamasi awak kasal iyo imulip imi angtiil kaa mafaksip kii kalok no taang-kala unang iyo im-buulokomip dinim. Ale, tunum malo ma waasi ita taba imi angtiil ku-mafak-daayinsip iyo kalok no unang kii dunulokomip dinim. Kuno tunum malo ma yakal angtiil kulaa tambal yale, God alalta titil kuyilaya kii kapkes bomdipla God ami weng ayo tambal-kup kulii-din aptum kusal iyo bakayum o, kalaliwa, unang kii dunulokomip dinim. Kemin, tunum ali ma God ami lak kaata dukum-kup duulon o, kalala, titil-foko kapkes-kup ila namti, God ali tunum kaami fiyaap ayo duu-mokoma kayi! kala kanum bokoyinsa ko. ");
INSERT INTO tif_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Unang tunum iip maakup maakup iyo Yesus ata numi man katip katip sikil kuyak tii-lomda, God ami dik-daala dong dokoyila tambal-kup fasuulin o, kala-lomdip ilmi man iyo kulii-tal Yesus ami be tilip. Lale, Yesus ami daang bakaalin tunum iyo taba awil-fakal imi fotabamnup tabanik o, kemiwa, ");
INSERT INTO tif_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kulaa Yesus ayo bokoyila ko: Ibi fotabemin daa yo. Kii fotabemin daa kemin, kamboyiwa, imi man iyo imbiilip nami bii tilin o. Tunum unang ili fanang daaliwa yi, God ali nuli dong dokoyokoma kala kalalipla, tiltam God ami miit tem talebip iyo, mep man katip katip ililtap kemin, ibi man katip katip kii fotaba dil-saanin disa; kamboyip nami fanang tilin o, kalalala, ");
INSERT INTO tif_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","man katip katip iyo sikil kuyak tii God ayo dik-daala ko: Aatumen, kabi mep man katip katip kalawiili dong dokoyan o, kalba-kup kulaa kamboyila una ko. ");
INSERT INTO tif_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Am ma daanale, tunum kasaa ma tal Yesus ami dik-daala bokola ko: God ami weng kukuyin tunum kapyo, nali suunkup ilin tunum kelon o, kebi kemin, kaata dok kanolin kukup tambal kaata tabuuliya kawu, nali suunkup ilin tunum kelan o, nambap yoko? akaya, ");
INSERT INTO tif_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus asiik bokola ko: Kabi kanimin o, kalalap tal kukup tambal umi sang uyo nami dik-dakaap-ninbap? God maakup kaata-kup kukup tangbal uyo nuumin kemin, God ami Lo uyo Moses ata God ami Sukon Tem kawu dola kutiisa. Kemin, God ami weng kuuta tabuu-bomdawa kawu, kabi tiltam suunkup ilin tunum ke-lokomap o, akale, ");
INSERT INTO tif_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","kulaa tunum asiik dik-daa bokola ko: God ami dok nolin weng lo kuuta ti kutal-fukulin-kup ilan o, nambap? kalale, Yesus asiik bokola ko: Lo uyo boko-lomdu: Kabi tunum unang kii anulap taan-yaamin disa; kalapni kalel kuu, kewa unang kusnum so sadikimin daa; kabi yukut inin daa; kabi disa ibaka-balap, soldiya iyo kaptum kusal kii sok dinayin disa. ");
INSERT INTO tif_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kabi kaltapni kawak-aalap imi weng uyo saak kuyang tiimin daa; ti imi weng kaata weng san-kaa-bam ale, kukup tambal kiita-kup kukuyilan o, kala-som ale, kuno kaltapni angtiil umi mok im-bom yaap-kup tiin saanbap tap ke kaptum kusal kayak kayak imi aket uyo kuyan o, kala kanum boko kesu uta te! akaya, ");
INSERT INTO tif_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","tunum kasaa ayo Yesus ami bokola ko: Nali God ami weng sawaa ayo alik kuno ti suunkup kutal-fukulin-kup bom-laabi. Katale, nali utamila, Kukup tangbal uyo ma iibi nema yo? kalbi. Kemin, kalok nolin kukup uta maso kutal-fukulan o, nambap yoko? akala, ");
INSERT INTO tif_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus asiik bokola-lom: Kukup tambal ayo ti alik tabuulon o, kalbap kala kalaliya, tabuulin disa bom-balap kaami sang namti kala bokop-tokomi. Kemin, kabi daa weng san ilawa! Kabi din-ilomdap kaltapni mafek mafek alik iyo kaptum kusal imi kuyilawa, ita moliwa umi moni kuluulokomap kaata, mep unang tunum mafek mafek dinimal imi kuyap namti, kaata din God ami abip kawu suunkup yaap ilokomap. Kemin, kano-lomdapla, kabi talawa, naso tal-une-bam, God ami okok kem-tal-unemum o, akale, ");
INSERT INTO tif_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","kulaa, tunum man kasaa ayo mafek mafek kayaakim kemin, Yesus ami weng bokola uyo weng san-somdala, ami aket ayo fanang-daala yi, Kwin, ti suunkup ilin tunum kelon o, kalbi. Yale, yak nami mafek mafek kiili, yaapkan kemin, kuno keyokomi disa yo, kala-lomda aket uluum dap-teluya, Yesus ayo kela una ko. ");
INSERT INTO tif_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tunum kasaa kanola unaya, Yesus ayo tunum kaami aket ayo fukun-bamdala, almi aptum kusal imi bokoyila ko: Nali tituun weng bokoyokomi. Yak mafek mafek soyal unang tunum kii, atin ti fiit-bamdip, (imi mafek mafek sikip fak-dakan-unsip iyo kulaalokomip kemin, malo ma kiita-kup God ami aket kola-lomdip,) tiltam God ami be kawu, tam unokomip. ");
INSERT INTO tif_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nali weng bokoli kaptoop maso tifili tooplo so unokomu. Kemin, olti dukum ma kamel uyo tam men sil ami tem kaa tam unon o kalokomu kaa, fiit-bi-somdula kawu tam unokomu. Ulultap kemin, yak tunum bung kayaak ali atin ti fiit-bi-somdala kawu, tam God ami miit tem kaa tam unokoma kayi! kala ayo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kanum bokolala, daang bakaalin tunum iyo weng san-somdipya, Kwin! fanang aket alik tam baneyiluya iyo dik-daalip: Kapni kanum boko-lom: Bung kayaakim ayo fiit-bam tiltam God ami miit tem kaa tiltam talokoma no, kalap kaali, faneng namti, mafek mafek dinimal nuli dok kano-somdupya, tam God ami miit tem uyo tam unokomup i? Kaa fan taang-kala tam unolup daa, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus ayo ilmi tiin diim tiyak daa itam bokola ko: God maakup kaata-kup yaap mafek mafek alik iyo kanolama. Yale, tunum alik kuliili taang-kala-lomdip tiltam God ami abip ayo tiltam talokomip dinim; God alalta dong dokolokoma kaata, fan tiltam God ami daam tem ayo tiltam talokoma no, yakale, ");
INSERT INTO tif_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita asiik bokola ko: Kapyo, weng selan! Kapni daang bakaalin tunum nikil nuli nulmi abip so, nulmi mafek mafek so, alik iyo kulaa kela-lomdup kapni okok kaata, ke-bam kapso tal-unebup kemin, kanubup kaali ilom God ami abip ayo din atamuwa, kabi kalok nolin kukup tangbal ata ma nuli kuyokomap i? akaya, ");
INSERT INTO tif_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Nali tituun weng kaata bokoyokomi. Ilom am mafiing diim daanula kawu, God taba-lom asuk abiil so, tawaal so, imi kusnum dotulokoma kabaku, Dukum Ami Man Nata tiltam Kamokim diil ke-lomdila, alik kiili tiin molokomi. Kemin, kulu nami daang bakaalin tunum talangkal ibi nami titil kaata kuyilila, nami win diim Israel imi man loop imi miit talangkal kalawiili iltipta taba-lom miit maakup e kala tiin mola tiin mola ke-lokomip. ");
INSERT INTO tif_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kemin, dok nolin unang tunum ita nami lak uyo duu-lomdip imi am aye, nakal-fakal afalop kusal, awak aa, aalap, man, ima waan lang aye, iyo maas kuno keya-lomdip, nami ok kaata-kup kutal-fukulip namti, am mafiing diim daanokomu kabaku, God ayo kukup tangbal-kup kuyimba-kup, kanolin mafek mafek yel yak daa keya talsip uyo, ulmi-kup tiiyuk 100 kiita kuyila kelaya iyo suunkup ilokomip. ");
INSERT INTO tif_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kemin, unang tunum yaapkan kamala kaami win so ke-bom-bilip iyo, kaptoop kaptoop kaali, isiik win dinim keliple, win dinim ke-laabip isiik am ma daanokoma kaali, kiita win so ke-bom ilokomip o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kulaa, Yesus ayo faldak-tiimin weng ma boko-lomda: God ami unang tunum tiin mo-bomda mafek mafek kukaayila-yaaba kaami kukup uyo sok lap lang kayaak ma taba okok kemin tunum imi kuyase kukup tap o. Langabip kayaak ami wain lang uyo dukum kemin, kutim atan tik-daalon e! kem-sulule, langabip kayaak ayo yak aba din yawolam aba tunum ma ulelnila, din nami okok kamap-nam-bamdip moni kaamin o, kalalaya, ");
INSERT INTO tif_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","yak aba din tunum malo ma itam ale, bokoyila ko: Kibi okok ke bi kalum o, kala-silip am maakup kemin kaami sisol kaata-kup tiiyuk kuya kuya ke-mokomi no, kala-lomda fokola din ami wain lang kawu tabuulip ko. ");
INSERT INTO tif_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kemin, am ma daanala ami kutim kawu, langabip kayaak ayo asuk tunum fen-talaba din yawolam ula, Kuno tunum malo ma iyo disa kulu bom-bilip kala kalba-kup, ");
INSERT INTO tif_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","bokoyila ko: Kipyo, ibi din nami wain lang kawu okok ke-bilip bii am tiinula, okok kebip ulmi sisol tiiyuk-kup kuyon o, yakale, ");
INSERT INTO tif_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","weng sandip yak aba din okok kemip ko. Din okok ke-bilip, bii atan uyo tal dibimnala, langabip kayaak ayo asuk tunum malo ma iyo fokola okok kem-uniple, bii luuka-somdala, atan ayo ansiki tal aba yak abamnala, tunum malo ma iyo kuno tam asuk im-baala okok kem unip ko. ");
INSERT INTO tif_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bom bii am tiinula, ok ayo disa kelon e! kem-sulule, ayo din yawolam din ulaya, Tunum malo ma iyo asuk kawu bom-bilip kala kalale, ayo bokoyila ko: Kipya! kibi kanimin o, kala am daanbu kaa disa kulu tiinaabip yoko? yakale, ");
INSERT INTO tif_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","isiik bokolip ko: Yi, nuli tunum ata ma ok ayo ma kuyin dinim kelaya, kemin disa am kulawu bom-bulup te! akiwa, bokoyila ko: Ok ayo ma kuyin dinim namti, kibi tal din nami wain lang kaata okok kemin a! yakala yak aba din okok kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kulaa atan uyo tem banon e! kem-sulule, wain lang kayaakim ayo okok kemin imi tiin molin ayo bokola ko: Ok fukulin tunum kii alik weng umbaayilap tala-tala-keliwa, imi sisol uyo kukaayilan o, kala-somla kemin, kamosinim kaali mep ma mulo tal okok kemip am tiinu isiik kuya-somdaple, kiimi daang tem kaata aptum kusal iip ma am taapnu tal okok kebip iyo kuyila kelapla kawu, kamasi diildiil kutim tal okok ke-bilip bii am tiina ita mafiing mafiing kulu ukuya kelan o, akaya, ");
INSERT INTO tif_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","kulaa tiin molin tunum ayo okok kemin tunum imi naan-daayila, tal atamiple, ayo sisol uyo akal almi ne, kala kola-kola kemsa disa. Kamasi kaali, okok kebi am maakup kebi am maakup kemin kaami sisol uyo tunum mafiing tal okok kebip isiik kuyimba-kup, taap tilip yakal iyo kuno ti ok fukubi am maakup kemin kaami sisol uyo kuyila kelala, ");
INSERT INTO tif_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","mafiing mafiing kaata, tunum kutim tal okok ke-bilip bii am tiina yakal tal sisol kaamum o, kalalip tal aba aket fukuniwa: Awu, nuli kutim kawu tal okok kem tala-bulup kulii yak aba umbital kala diilup kemin, nuli sisol dukum so kuluulokomup ema yo, kalip. Katale, tikip alik maakup ti tunum mafiing tilip imi sisol kuluulip tap okok kebi am maakup kemin kaami sisol kaata-kup kuluu-lomdipla, ");
INSERT INTO tif_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","utamiwa yi, Numi sisol kalawaali, nak-tunum kusal imi mep am tiina tal okok kem-silip am tiina imi sisol kuluulip ultap kuluulup kala kalaliwa, kamokim ami aket atul kukaan-bam balaan-bamdip bokolip ko: ");
INSERT INTO tif_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kamokim a! Ok tabuulin tunum kalawiili ok kaali ok ayo disa kelon o, kem-sulula, ayo talda ok katip ma kuya iyo nolip ale, nutale kutim kawu tal atan aalap dukum ami diim kalawu okok kem kulii umbital am tiinin diim kala diilup. Lale, kanimin o, kalalapla kabi sisol kaali imi sisol kuyilap kaaltap nokol kanoya kuyap yoko? Kabak-ali yaap keyin disa yo, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","wain lang kayaak asiik taba imi tunum maakup ma ami weng uyo tela-lomda bokola ko: Nak-tunum kapyo, duluuma weng san ilawa! Nali bokop-ta-lomdi: Okok kebi am taap maakup kemin kaami sisol kaata kup-tokomi no, kaliya, kabi okok ke-bili bii am maakup ke-lokomi kayi! nambap kemin, nali kapni kukup mafak kup-ta-somdila disa. Kemin, nulmi weng bokobup kaata-kup kutal-fukulila kemin, kaa kuyili ko. ");
INSERT INTO tif_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Kaa nalmi aket fukunin uta tunum mulo tilip kaliili kukup tangbal ayo ma kuyon o, kalalila kapni sisol kup-ti ultap kuno yakal kanola kuyi no. Alik ibi okok kemsi bii am atan maakup kemin umi sisol kaata kuluulip, kemin ale, kaali ti yaap kelip te! Nali nalmi aket fukunin uta nalmi tuumon kaata kuluu-lomdi tunum iip maakup maakup imi mafek mafek iibip imi masiim dong dakaayimbi. Lale, kabi kanimin o, kalalawa aket mafak kuuta, kuyak tiip-tulala aket atul kuyak daa bom kanubap yoko? Kapni sisol uyo kuliilap tabanan a! kala-lomda wain lang kayaak ata okok kemin tunum imi kanum bakayinsa ko. ");
INSERT INTO tif_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Faldak-tiimin sang kaami miit ayo dok nolin unang tunum ita mafiing talan-umbip kiita, bi-lom kawu dusiin daalokomip. Ale, dok nolin unang tunum ita isiik dusiin daa unip kiita, bi-lom kawu mafiing diim talokomip o, kala Yesus ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kulaa, Yesus so, daang bakaalin tunum iso, nikil iyo met abip dukum Jerusalam unum o, kalalip, un-bom ale, almi daang bakaalin tunum talangkal iyo tunum unang iipyak tem kabaku foko kulii yang kabang tiila nikil ilifin um-bomdip bokoya ko: ");
INSERT INTO tif_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Kipyo, Jerusalam kaptam banum o, kalolup talabup kemin, yak aba din kawu bom ilupya, nak-tunum ma kaata, taba-lomda Dukum Ami Man Nayo, nam-bii din pris awem tunum imi kamok kamok iso, lo utamsip tunum iso, imi diim daayilala kawu, ililta weng taken-una-tala-ke-bamdip, Mep tunum kuluwaali, aalip taanak o, naka-lomdipla kawu, ");
INSERT INTO tif_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","nam-baalip yak Rom kayaak imi sikil diim abamniya, ita tam-ilomdip titul weng so, atafiimin weng mafak so, kiili bakap-nam-bamdiple, sok faklet ta kuluu lakatal kaap-nam-bam kebi-sinomdipla kawu, nam-bii din as diim kawu nam-tam diilip saaknila, nam-buu nam-bii din namaalip bombii am alep keliya, am asuumano diim kawu God alalta nam-folaya asuk tam tiin baalokomi no, kala Yesus ayo almi daang bakaalin tunum ilmi-kup kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi ami kalel umi man iyo alep kemin, Jems so, Jon so, alep iyo imbii tal Yesus be tal-ilomdu katuun duung fakela daak tiin-ilom bokolu ko: Kamokim kapyo! Nali nami man kalawiili mafek mafek tangbal uta ma noyan o, kalbi akule, ");
INSERT INTO tif_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus ayo dik-daawa ko: Kubi nali kanimin kaata ma nop-nak o, nakan-kaabap yoko? wakale, awak usiik Yesus ami bokolu: Bom bii-lom kapni tiltam kamokim king ke-lomdap unang tunum alik imi tiin moyokomap kawu, kabi nami man tunum alep kalawiita ulelnawa, ma tal kapni tiing tuuplo tiina, ma tal awaanlo kaldangu tiina ke-lom ita dong dakaap-tam-bilipla, nikil kibi unang tunum kii tiin molin o, akule, ");
INSERT INTO tif_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus ayo fal-siki titalak daa tunum alap iyo itamale, almi angtiil yol kuluulokoma kaami sang uyo imi bokoyila ko: Alap kipyo! Kipni dik-dakabip kaami miit kaali, ibi talalu bam-daalin dinim; kemin, kukup mafak kayak kayak imi taba nami kup-nokomip kaali, kipkal saak nuso kuno kuluu kanolamup o, kalbip ema? yakale, boko-lomdip: Ayo, alap nuli ti kulaali kanolamup o, akipla, ");
INSERT INTO tif_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus ayo bokoya: Faneng kemin, ibi nami kukup mafak kaa kup-nokomip ulultap ke-lokomip. Yale, kaa nami ok tabuulin tunum ulela-lomdi kamokim ami abiin baan nami mepso bombuu uyo yim-tiilokomi dinim; kaali nami Atok God ami ok kemin alalta tunum iyo ulelsa. Kemin, im-tiilaya ita dong dakaap-nam-biliwa, unang tunum kii tiin molokomup o, kala ko. ");
INSERT INTO tif_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kanum bokoyilaya, Yesus ami daang bakaalin tunum nakalkal iyo weng sandiwa, daang bakaalin tunum alep kiimi aket atul kuyipya, aket atul dap-tiiyula, ");
INSERT INTO tif_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus ayo nikil iyo naan-daaya alik tal atamipla bokoya-lom: Kipyo! kipkal utamipla, Tawaal diim kalawu God ami aket kolin disa unang tunum imi kamok kamok iyo unang tunum kalaang weng kukaayim-bam ale, ilmi aket fukunin weng kaata-kup kukup mafak ayo kukaayim-bam ken-tabasip u, kalsip. ");
INSERT INTO tif_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lale, nami lak duulin ibi, kiimi kukup kaa kanun-umbip kaali, kipsiik dik-daa kuluu-lom kanumin dinim; kipni tunum ayo dok ata nita nak-tunum kusal imi tiin diim kaali, tiltam win tabin kelon o, kala namti, ali almi win kaali, kufumin dinim; balilii-kup kala-bom kaptum kusal imi minlo tem un-bom ilokoma kaata tangbal; kemin ale, ");
INSERT INTO tif_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","kipni tunum ayo kanta nita nita ke-lom tiltam naktum kusal imi kamokim kelila yo, kala namti, ali alik kipni unang tunum dong dakaayin tunum ke-lokoma kaata, tangbal o. ");
INSERT INTO tif_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dukum Ami Man Nali tal tawaal diim kalawu disa tal tiin bom-biliya, tunum kiita nami okok uyo kamap-nin o, kalali talsii disa; nali taldila kiita ti dukum-kup okok ke-bomdiya, unang tunum imi dong dakaayon o, kalalila talsii. Kaali, nali tal-ilomdi kuno kamboyi waasi ita nelip taanokomi kawu, unang tunum yaapkan imi iliim boyilile, kiiyo tiltam God ami man kela suunkup ilin o, kalalila talsii. Kemin, ibi nami unang tunum dong dakaayimbi ultap ke-bamdiwa yo, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus so, almi daang bakaalin tunum iso, iyo abip Jeriko uyo kela una-bilipla, unang tunum yaapkan iyo yak nikil imi daang baka kelip unip ko. ");
INSERT INTO tif_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Una-bilipla, tunum tiin mafaknin alep ma liip balang diim kawu tiin bom-bilip iyo weng saniwa yi, Unang tunum iyo bakabip i! Yesus ayo tal-unaba no, kalbip kala kala-lomdip naan-tabamnip ko: Kamokim kapyo! Kabi kaltapni kawaalik King Devit ami man loop kemin, kabi numi olen-daaya-lom dong dokoyan o! kemiple, ");
INSERT INTO tif_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tunum unang iyo taba alep imi balaayim-bam bokolip ko: Ibi duluumnin o, yakan-kaamip. Katale, tunum tiin mafaknin alep iyo ti iluut asuk dukum-kup naan-bamdip: King Devit ami man loop kamokim kapyo! kabi alep nuli olen-daaya-lom dong dokoyan o! kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kanumipla, Yesus ayo duluuma kawu tola-lomda naan-daayila: Ibi nali kanimin ma noyilak o, kala naap-nambip i? yakala, ");
INSERT INTO tif_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","alep isiik ami bokolip: Kamokim kapyo! Dong dokoyilawa, alep numi tiin kalawiiyo, baayilapla yak mafek mafek kiili, itafiimum o, kalalup naanbup o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus ayo alep imi olen-daaya-lomda, yak imi tiin ayo sikil kuyak daa maleya kem-salale, mak fak-daalin tap alep imi tiin iyo tambal-kup keyilule kulaa, mafek mafek iyo itam Yesus aso unip ko. ");
INSERT INTO tif_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus daang bakaalin tunum nikil iyo tal abip dukum Jerusalam mepso tal Oliv Tikiin umi abip ma Betfage kaba talom ale, Yesus ayo almi daang bakaalin alep ma isiik fokoli uniwa yo, kala-lomda, ");
INSERT INTO tif_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","3","weng asiik duuya bokola: Ibi yak aba tam abip utafiibup kaptam tam ulip, Dongki man kasaa so, awak so, awaat iyo sok im-diilip bilip kala itam-ilom, abiltap ita-mokomip ko. Dongki awaat imi sok ayo, baa-lomdip awaat imbiilip nami bi tilip yo! Alep kanum umbaa-silipla tunum ma itama yi, Kanum talabip kalala itam dik-daaya namti, ipsiik bokola-lom: I, numi kamokim alalta kulii tilin o yakaya tulup. Kemin, kabi abiltap-siik dongki awaat kamboyilap imbi unum o, kala bokolalip kulii tilin o, kala kanum bokoya im-baala unip ko. ");
INSERT INTO tif_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Kemin, sawaayak kawu God ami profet ma ayo God ami Sukon Tem kabaku dola kutii boko-lom: Ibi din abip dukum Saiyon o, kala Jerusalam kaptam ban-ilomdip abip kasel imi bokoya-lom: Di utamin a! kipni kamokim king ali kipni fanang talaba kemin ale, ali win soyap ami talemin tap ke-lomda talaba dinim. Ali dik-diiba bomdala dongki man kasaa ami daang kun diim tiinda talaba no, kalin o, kalsa. Namti kulaa ami weng bokosa uyo fan tiltam tabon e, kem-talabu ko. ");
INSERT INTO tif_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kulaa, Yesus ami daang bakaalin tunum alep iyo Yesus ami weng kaata-kup weng sandipya, ");
INSERT INTO tif_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","yak aba din dongki awak umi sok uyo baawa-lom, man awaat imbii tal Yesus koliwa, ilmi ilim saket ayo dilduu kutam dongki man kasaa ami daang kun diim kabaaku tabeliple, Yesus ayo tam dongki daang kun diim kabaaku tiinda una-balala, ");
INSERT INTO tif_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","unang tunum yaapkan imi aket fukunin uyo, king ami tala-bala fiyaap duumin kaami kukup ayo kanumin kemin, Yesus ayo kala liip talaba kemin, liip ayo tambal-kup ma dotuluwa tal-unak o, kala-lomdip ilimi ilim malo ayo dilela kulaak liip kawu taben-balale, malo ma ita liip mepso ami as tang kon bapliim so fakela kulii-talaba daak Yesus ami tal-unokoma taben-bala kebi kuteliwa, dongki ayo ilim so, as bapliim so, ami tip diim liip unak. ");
INSERT INTO tif_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kanum una-balala, unang tunum yaapkan iyo biki-kutii bon tem una-balale, unang tunum yaapkan malo ma ita daang tem lo kaptoowu kelip Yesus ata iipyak tem kawu una-bala ke-bamdiwa, fiyaap duumin dukum ke-bam ale, dukum-kup naan-bamdip: Nuli King Devit ami man loop kalaami win uyo kuluu kufolum o, kal-bom ale, Yesus kalawaali God Dukum ami win diim o, kalala talaba kemin, God ata kukup tangbal-kup kukaayim-balaya yo, kal-bomdip God ami win sakbaalim dukum ayo kuluu kufon-bamdup fiyaap duumum o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kanum una-biliwa, Yesus ayo yak aba din Jerusalam kaptam banale, abip kasel iyo alik atam-ilomdip alik maakup fanang alik tam baneyilula, fiyaap duu-bamdip yakal taba dik-daala una-tala-ke-bamdiwa bokolip ko: Kaa kawanta ni? kemipla, ");
INSERT INTO tif_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","unang tunum Yesus aso talabip ita aptum kusal imi bokoyip ko: Kaaye? kaali God ami profet o kala, God ami weng ku-fatap-dakamin tunum Yesus, ali Provins Galili umi abip Nasaret kaptam kayak tunum o, yikip ko. ");
INSERT INTO tif_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kemin, Yesus ayo yak aba din lotu am diilim din ula, Tunum iyo mafek mafek God ami kukaalin uyo kutal aba tam lotu am tiilip uyo kukaayim-biliple, saanbip kala kala-lom tam-ilomda, tunum alik mafek mafek kulii-talaba tam tiilip so, tunum kusnum tal saanbip so, iyo alik fotabamna sak funbi, tuumon kola una-tala-kemin tunum imi tebol ayo dak-siki ku kabaak moyale, awon abim God ami kukaalin umi kulii-tal tiilip saanin tunum imi abiin baan uyo dikela kulaaya yang aba kebi kutiiya-lom ");
INSERT INTO tif_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","bokoya ko: Sawaayak kawu God ayo Sukon Tem dolsip kabak boko-lomda: Nami am kaltam-ali beten kemin am o, kalokomip o, kalsa kaa, ibi God ami weng kulaa utamsip o kalsu. Yale, ibi ami weng kuuli, kuyang saak tela-lom God ami am uyo ku-mafak-dakanbip o. Am kaltam-ali ipni wan saan-bam kaptum kusal imi moni yukut inin am kelu kewinsip o, kala kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus ayo kano lotu am diilim kaptamu bom-balaya, unang tunum tiin mafak so, yawiit so, iyo Yesus ami bombe kawu din atam-yaa-bilip, yam-talal kaa-balala, ");
INSERT INTO tif_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","awem tunum pris o kebip imi kamok kamok so, lo utamsip tunum so, iyo Yesus ami kukup kusnum kanuba uyo utabip-kup, weng saniwa yi, Man katip katip iyo lotu am diilim kaltamu naan-bamdip bokolip ko: Kalawaali King Devit ami man loop. Kemin, ami win uta kufolum o, kalbip kala kala-lomdip tunum awem imi kamok kamok so, lo utamsip tunum so, ili Yesus ami aket atul kukaan-bam ale, ");
INSERT INTO tif_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","bokolip ko: Kapyo, kabi kanolin weng mafak bakabip uyo weng selap yoko? akipla Yesus ayo bokoya-lom: Kiimi weng ayo weng seli. Kemin, ili kukup mafak kebip disa. Ili God ami Sukon Tem bokosu kaata nuubip kaa boko-lomdu: God kapta man katip katip so, man unaak so, iyo kukuyilapla, kapni fiyaap duu-bam ale, kapni win uyo kufup-tan-bam ken-umbip o, kalsu. Kemin, ibi God ami weng kaa lukuuyinsu yoko? kala bokoyilala, ");
INSERT INTO tif_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","kamok kamok iyo lotu am diilim dukum kaptamu kamboyila tiltam daak abip abale, yak aba din abip Betani kaptamu akana ko. ");
INSERT INTO tif_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesus aye, daang bakaalin tunum aa, nikil iyo Betani silip sintam kutim malang tem Betani ayo kela Jerusalam unum o, kalalip un-bom ale, Yesus ayo ol-tinap kelula, ");
INSERT INTO tif_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","utama yi, As fik al ma liip balang tem kawu tolsu kalale, yak aba yang fik lap ayo ma duk-duu ina-somdila yo, kala yang ulaya, Fik lap ayo ma abuulin dinim kon-kup be kalale, bokola ko: As kalawaali lap ayo ma asuk abuu-mokomu dinim o, kem-salale, kuyaku as fik miit ayo maak fak-daalin tap datnu ko. ");
INSERT INTO tif_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kanolaya, daang bakaalin tunum iyo utamdiwa aket alik tam baneyilula, bokolip ko: Nakayi! fik miit kaali, dok kano-lom abiltap-siik datnu ni? kemiwa, ");
INSERT INTO tif_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus ayo imi weng uyo bokoyila ko: Nami weng kalawuuli lukuuya-yaamin daa; ti kuyak iltipni aket tem daalalip kayi! God ami aket fukunap uyo aket alep fukunin daa. Talalu aket fukun daa; God ami kaata kanuman o, kalba, ayo yaap dong dokop-na kanu-mokomi kalokomap uyo kapkal yaap yak nami as kanoli ultap kaa kanolokomap. Kanola ti kalbi boko-lomdap: God, kabi yak amdu kulaa bildaa dabaalap yol ok kumun tem unak a! kalokomap uyo, fan kapni dik-daalap kaa God ali kanop-tokoma no. ");
INSERT INTO tif_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kapkal aket fukunawa, God ali ti dong dokop-na ami kukup kaa kanolokomi no! kalokomap namti, kabi beten ke dik-daalokomap kaata, ali fan kanop-tokoma no, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus ayo yak aba tam Jerusalam aba-lom lotu am diilim kaami daam tem kawu tam-ilomda God ami weng kaata, unang tunum imi kukuyin-balaya, pris awem tunum imi kamok kamok sole, Juda kayaak imi kamok kamok iso, iyo tal Yesus ayo dik-daalip ko: Kapyo, kabi kawanami win diim kaata, kufo-bamdap yak kanolin kukup kala kanun-umbap i? Kabi kanta tam-baala tal-ilomdap kanolin kukup kala kanum-solap yoko? Nuyo bokoyawa, utamum o, akiwale, ");
INSERT INTO tif_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus asiik imi weng an-anung-daa bokoya-lomda: Na, nasiik weng ma kipni dik-daayokomi. Kemin, ibi nami weng kalu maan tiip-nip namti, aa nakal kipni weng uyo maan tiiyokomi. ");
INSERT INTO tif_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Oksam ukayin tunum Jon Baptis ali kawanami win diim kaata, unang tunum iyo oksam ukayinsa ni? God ami win diim kanum-soma ne? tawaal diim kaldaak-ami tunum imi win diim kanumsa yoko? Nami weng kala dik-daayi kaata, maan tiip-niwa yo, kalale, ilmi-kup bokola una-tala-ke-bam bokolip: Kwin! nokol kaa kanimin o, kalokomup i? kemsile, Nuli boko-lom: God ami win diim kaata, kanumsa no, kalokomup namti, ali bokoya-lomda: Ibi utamiwa, God ami win diim kanumsa kalip namti, ibi kanimin o, kala, Jon ali fan God ami weng kaata tituun bakayimba, kemsip disa ema? kalokoma. Kemin, kela boko-lomdup: ");
INSERT INTO tif_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tawaal diim kalawaami tunum ami win diim kanumsa no, kalokomup kaata, unang tunum yaapkan kalawii aket fukuniwa yi, Kaa fan Jon ali God ami profet o, kala weng ku-fatap-daa bakayin tunum o, kalalip nuyo aket atul kuya yelalip o, kala nuli suunbup o, kala-lom ");
INSERT INTO tif_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yesus ami ibokola-lomdip: Kaa kanta Jon kaa bokolaya, ali taba-lom unang tunum kii oksam ukayinsa kalalup utabup dinim o, akiwale, Yesus asiik bokoya-lomda: Nakal ti kanolin kemin kawanami win diim kaata, kanolin kukup kaa kanun-umbi uyo bokoyokomi disa yo! yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus ayo kamok kamok imi bokoyila ko: Nami faldak-tiimin weng kala bokolokomi kalaali, talalu weng san-ilom ale, kawu kalok nolin aket fukunin uta ma tildang tulu kala-somdiwa kawu, kipkal bokop-nin o. Tunum ma ayo man tunum man alep kemin am ma daanule, man diil ami bokola ko: Nalmi man diil kapyo, kamala uyo din wain lang kaata dikiman o, kala bokolale, ");
INSERT INTO tif_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","man asiik aalap ami bokola: Nali keli no, kala biile, asuk aket fal-sikiba-kup; din wain lang dikima ko. ");
INSERT INTO tif_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kulaa, aalap ayo din man niing afung ayo atamda asuk ti fik ami bokola tap ke bokola ko. Bokolale, man asiik aalap ami weng bokola uyo bokola ko: Nata din dikimon o kala; katale, ali unoma disa, kelase no. ");
INSERT INTO tif_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kulaata nali weng ma dik-daayokomi kemin, weng san ilawa! Alap kiili niing ata ne? fik ata ne? ilmi aalap ami weng kaa weng san-silip yoko? yakala, kamok kamok isiik bokola-lomdip: Daa, fik ata aalap ami weng ayo weng selase no, akiwa, Yesus ayo bokoya ko: Nami weng kala bokoyokomi kalaali, dotu weng san iliwa! Tunum unang mafak ili fik ami kanose tap kanolokomip kaayo, takis kaamin tunum mafak iso, yak sadikimin unang so, ili ilmi aket kaata fal-siki-lomdip ita ita keliwa, kamok kamok ipta kulaak banipya, abiltap tiltam God ami miit tem talokomip. Kemin ale, aa ibi yi? Ibi tiltam God ami miit tem kaa tiltam talokomip e disa? ");
INSERT INTO tif_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kanolin kemin, siin kaali oksam ukayin tunum Jon Baptis ali tal ipni kukuyin-bam bokoya-lom: Ibi tiltam God ami miit tem talemin kaami liip kaa kano-somdiwa yo, kemsa. Lale, ibi ami weng kaa ma weng san-kaamsip dinim te! Takis kaamin tunum mafak kiiso, sadikimin unang so, ita Jon ami weng uyo weng san-somdiwa, imi aket ayo fal-siki-lomdip ilmi kukup mafak nuubip kulu kewa-lom tildang God ami lak kaata duulip kala, kalalip ibi itam-silip. Katale, ibi Jon ami weng uyo weng san kipni aket ayo fal-siki-lom ililtap kelin disa ke-lomdip, ipni kukup mafak nuubip uyo kela-lomdip, God ami lak kaata duulin dinim o, kala Yesus ayo kamok kamok imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus ayo asuk kamok kamok imi bokoyila ko: Nali weng kusnum ma bokoyokomi kemin, ibi talalu weng san iliwa! Tunum ma almi wain lang ma talalu kutii-lomda uti foko kela wain san ayo dikiba-kup; tuum tem kala-lomdipla, ok liip unemin dotu sok lap iyo fokolip daak uniple, yaan ta talela kutiibip-kup, ok bina-unemin uyo dotu kutii kela, lang kaptam tiin mo bom ilin tunum ami am ayo bitam asal kaptamu de kambolale, tunum wain lang tiin molokomip iyo ulela-lom bokoyila ko: Wain lap abuu tii-mokoma kaali, dakabi kutii kela tak-nuubi ok ayo laabi kutiiliwa, kaptum kusal ita tal molipla, kipta sisol ayo kuluu-lom anung ma iltipni kuluubip-kup; nakal anung kuluu kulaap-nip din unemak o, kala kamboya bilin samaan kawu una. ");
INSERT INTO tif_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kemin, wain lap abuumin umi am uyo daanula, tiin-saanin tunum iyo wain lap iyo dakamsi kutii kela yak ok ayo tuk-nuu-bam ok kaa laabi kutiilipla, aptum kusal iyo kuyip ita moliwa, kulaa wain lang kayaak ayo almi ok fukulin tunum iyo yim-baala tal wain lang tiin molin tunum imi bokoya-lom: Numi kamokim ami wain lap imi ok kaami sisol anung ata kuyilipla, nulmi kamokim ami kulela unum o, yikiwale, ");
INSERT INTO tif_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kulaa wain lang tiin molin tunum iyo weng sandiwa, yak kamokim ami okok kemin tunum iyo yim-tal-fuku-lomdip, ma ata disa kiin waal biwakabi kelale, ma ata olso aalip taan-som, ma ata tuum ta binalip yak tunum ami dabom baken-bilip bom bii saakna keyip ko. ");
INSERT INTO tif_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kanolip kala kalalaya, kamokim ayo ok fukulin tunum iyo yaapkan iyo im-baala din wain lang tiin saanin tunum imi fanang din itamiwale, tiin molin iyo asuk kamasi okok kemin tunum imi tal itamip kanola yan-silip tap kuno yakal anulip taan kelip kala-somdala, ");
INSERT INTO tif_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","kamokim ayo weng sandala aket fukuna ko: Nali nalmi Man kalawaali dabaali din una namti, ali aalip taanokoma dinim. Ami win kaata kufon-bam ale, ami weng kaata-kup weng sanokomip o, kala kalale, mafiing diim kulaata, almi man ayo dabaala din wain lang tiin mo ilin imi bilip una. ");
INSERT INTO tif_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lale, din una wain lang tiin molin tunum iyo atam-ilomdip kulaa nikil iyo ilmi bokola una-tala-ke-lomdip bokolip: Kulawaali ti wain lang kayaak almi man kemin, bom bii-lom aalap ami taanokoma ayo, alalta aalap ami mafek mafek kaali, alik tiin mo-lom almi alik ke-lokoma kemin, aalupla taanala, wain lang kaltam ayo nulmi alik keyuk o, kala-lomdip, ");
INSERT INTO tif_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","yak man ayo dap-tal fuku-lom sisii dilili dibii tam uti yal foko tam daak saaklo kabaaku aalip taana kayi! kala Yesus ayo weng do ayo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kemin, Yesus ayo dik-daaya-lomda: Kipyo, wain lang kayaak ami asuk talokoma kaa, ali wain lang tiin molin kii, kanimin ma noyokoma ni? Kipni aket fukunbip kaali kanimin o, kalbip? yaka-lomda Yesus ayo dik-daayilale, ");
INSERT INTO tif_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","kulaa kamok kamok iyo Yesus ami weng uyo maan telip ko: Kamokim ayo taba tunum mafak yam iyo yebi angtiil yol daka-bam saaknipla kawu, tiin saanin tunum kusnum iyo ulelnala ita tiltam ami wain lang kaa tiin mo-biliwa bii suunkup wain ayo abuulu kalale, wain lap wok ayo laabi aptum kusal imi kuyip ita molipla, kulaa wain lang kayaak ata imi sisol anung ayo suunkup tambal kukaalokomip o, kala kamok kamok iyo kanum bokolip ko. ");
INSERT INTO tif_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kemin, Yesus ayo bokoyila ko: Tiin molin tunum taba lang abip kayaak ami man ayo aalip taanba kiili, siin sawaayak tunum kusnum imi kukup kanu-bisip ililtap te! kala God ami Sukon Tem kaali, imi sang kaata kanum boko-lomdu: Ok fukulin tunum ili am kaa dina-bam tiyak daaliwa, Am kun ma kaali mafak kala, kala-lomdip kuluu kulaalip yak balang diim kabang abamna. Katale, kamokim ali am kun kaa atam-ilomda, Kwin! kaali ti tambal kemin am duwokop kelak o, kala-lomda am kun kaali, asuk dibii tildak dap-molaya ayo tangbal mokso ke tolnu ko. Kemin, kamokim ami kanola kulaa God alalta kemin, nuli utamuwa yi, Ami kanola kaa fan tangbal kela kayi! kala-sulup o, kalsu. Kemin, ibi kuyak tik-tii-bam utamsip. Yale, kanimin o, kalaliwa kaami miit uyo talalu utamsip disa yoko? ");
INSERT INTO tif_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kibi nami weng kala bokolokomi uyo talalu weng san iliwa. Siin kaali, God ali Juda kayaak kipni win kaa nami unang tunum o, kala-lomda, imbii tiltam nalmi miit tem daalon o, kemsa. Lale, kamala kalaali, God ali utamala, Ibi daang ukup-nip kalalaya, God asiik ibi daang ukuya-lomda, yak unang tunum kusnum kayak kayak ita ulelba-kup bokoyila ko: Ibi ti titil-fak-daa nami weng kuu weng san kutal-fukulip namti, nasiik ibi imbii tiltam nalmi miit tem daalokomi no, keba no. ");
INSERT INTO tif_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aa, kuno ti am kun awak dukum ma bombuu. La, dok nolin tunum ata kutal daak am kun diim kaa daala namti, ayo dap-mafak-daalokoma le, am kun uyo dik-tam-daa tildaak tunum kaami angtiil diim abam-nokomu ayo, atin tunum dabuu dabaak molula, atin ti dap-mafak-daalokoma no, kala Yesus ayo almi sang kaata, faldak am kun umi diim kabak tii-lomda bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kanola pris o, kala awem tunum imi kamok kamok so, Falosi so, iyo Yesus ami faldak-tiimin weng alep kiili, weng san-somdipla utamiwa yi, Kuyak nulmi sang kaata bakayimba kala kalalipla, ");
INSERT INTO tif_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","sok delum o, kalip. Lale, utamipla, Unang tunum yaapkan ili aket fukun-bamdip, Yi, Yesus kaali God ami profet o, kalaliwa, fiyaap don-bilip kala kalalipya, kamok kamok iyo unang tunum imi atul uta itam-suun-daa-lom sok dedulin dinim kelip ko. ");
INSERT INTO tif_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus ayo asuk unang tunum imi weng ma faldak-tii bokola ko: ");
INSERT INTO tif_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ilom am ma daanula, God ayo almi unang tunum tiin molokoma kawu kamokim king kaami sang bokolon o, kalbi kalawaami kanumsa ultap kanu-mokoma no. Mep kamokim ami man ayo unang kuluulon o, kalale, ami aalap ayo: Ima kawol tapduu-bilipya, man ayo unang kuluulak o, kala-lomda, almi ok tabuulin tunum imi bokoya-lom: Unang tunum iyo naan-daayi kemin, ibi ima kaa fuu-lomdip, unang tunum iyo bokoyip tala-tala-kelipya, nuso tiin-bom ima kaa inum o, yakaya weng sanip ko. ");
INSERT INTO tif_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ima ayo fuu dotuliwa, kamokim ayo almi ok fukulin tunum imi bokoyila: Yak aba din tunum unang kamasi naan-daa-yimbip kiita bokoya-lom: Kulaata tiliwa ima inum o, kalip. Katale, unang tunum iyo tulum o, kalsip disa. ");
INSERT INTO tif_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kulaaliwa kemin, kamokim ayo asuk okok kemin tunum kusnum ma im-baala weng kulii din unang tunum iyo bokoya-lom: Nak-tunum kusal kipyo, numi kamokim ami weng kala bokoyokomup uyo weng selin! Ali boko-lomda: Nami ok fukulin tunum ita bulumaki aalap dukum dukum so, bulumaki man tambal yaapkan iso, anu duulbi kutii-lom tawobi kutal tiile, inin-inin alik iyo talalbi mikil-kup kutiilip. Kemin, kulaata tiliwa, nuso ima im-bomdup nami man ami unang kuluula ayo fiyaap duumum o, kalaya, weng ayo dibii tulup te! yikip. Katale, ");
INSERT INTO tif_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","tunum unang ili ti kuno kamokim ami weng kuuya uyo kuyang saak tela-lomdip kela akal almi okok e kala nuu-bala nuu-bala kemipla, tunum weng umuuyimba, ili ma ima lang uta diki-balale, ma ali din almi stuwa kawu okok ke-bala kemipla, ");
INSERT INTO tif_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","aptum kusal malo ita kamokim ami ok tabuulin tunum imi imtal fuku yebi anulip saaknip ko. ");
INSERT INTO tif_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kanoliwa, kamokim ayo weng sandala, ayo aket atul dukum-kup dap-telula, almi waasi dinin tunum imi im-baala din, tunum taba almi okok kamaalin tunum anubip iyo, waasi dinin isiik din aabi anubip-kup, imi abip ayo wing takayak daaya keliwale, ");
INSERT INTO tif_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","kulaa, almi ok fukulin tunum malii ma iyo naan-daaya tal atamip bokola: Nami ima ayo fuubi ku-mikil kebip. Yale, tunum unang ili kukup mafak kuluu-lomdip tilin disa kelip. Kemin, kiili nami ima kaa tal inam-nokomip dinim. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ibi din abip ma ma kawu tal-une-bam unang tunum yaapkan iyo itam-ilomdip alik iyo foko kulii-tiliwa, ima ayo im-bom fiyaap duumum o, kala-lom im-baala unip. ");
INSERT INTO tif_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Okok kemin tunum iyo din aba abip ma ma kawu, tal-une-bam tunum unang itamip, ayo ti mafak so, yaap so, alik kulii-tal kamokim ami am tii-tii-ke-bilip bii am alik muup-daalip ko. ");
INSERT INTO tif_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kanolipla, kamokim ayo tal, unang tunum im-taltam daalip tiinbip iyo, itafiin tal aba yang ulayi, Tunum ma ima ina-faka-bam fiyaap duumin ilim tangbal kolip uyo mikilama disa ke-lom, almi ilim mafak kaata-kup mikila tal tiinba kala kala-lomda, ");
INSERT INTO tif_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","kamokim ayo bokola-lomda: Naktum a! Kabi kanimin o, kala nami ilim tambal kup-ti kaa mikilin disa ke-lom tiltam talap yoko? akale, tunum kaayo, fatom-dap-telu ayo weng so ma bokolama dinim kelaya, ");
INSERT INTO tif_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","kamokim ayo almi okok kemin tunum imi bokoya-lomda: Kipyo, tal tunum kalawaali sikil-ang yaan-ang sok dela-lomdip, sisii dap-tama tam abip malang tikiba tem kaptam daaliwa, bomda, Kwin! kaluuso kanimin o, kala kalaba talbi yoko we? kal-bomda almi angtiil kalan amamak o, kala kamok bokoyilala kanola-silip o. ");
INSERT INTO tif_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ultap kemin, God ali unang tunum yaapkan deng saak imi bakayim-bamda: Kibi tiltam nami abip bii kalaba tiliwa yo, keba. Katale, tunum unang yaapkan ili ami weng kaa kuyang saak tii-bilipla, God ayo unang tunum iip maakup maakup ita-kup ulelnala kawu, tiltam God ami miit tem talen-tabasip o, kala Yesus ayo faldak-tiimin weng kaami miit ayo ku-fatap-daa bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kemin, Falosi iyo Yesus ami weng kaa weng san-ilomdip Yesus ayo sok dedulum o, kala-lomdip takas yang kabangu tiin, weng dil mo kasen-foko-lom weng ma dik-daalupya, weng mafak so ma bokola kala, kala-lomdup dap-tal fuku dibii din weng bakamin baan diim daalum o, kala-lomdip, ");
INSERT INTO tif_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","kulaali ilmi daang bakaalin tunum sole, King Herot ami ap-tunum kusal iso, iyo im-baalip din Yesus ami dik-daala bokolip ko: Kukuyin tunum kapyo, nuli titamsup, Kabi win tibin tunum so, win dinim tunum iso, ili kukup tangbal maakup uyo kukuyim-bamdaple, kabi tunum ma ami atul kaali ma suun-daa-laabap disa; kabi ti suunkup tituun-kup tabin weng kaata-kup bakayim-bam ale, God ami weng so, ami kukup kanumin o, kalba so, iyo kuluu-bomdawa, fan ti tituun weng kaata-kup unang tunum iyo kukuyim-bam kem-yaabap. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","nuli mafek mafek ma kaami sang kaata ma, dik-daap-tum o, kala-somdupla kemin (Rom kasel imi lo maakup ma uyo boko-lomdu: Ipni takis moni kaa numi King Sisa alami gavman ami kukaalin o, kalsu ale, Juda kayaak numi lo uta boko-lomdu: Ipni moni kaali, God ami kukaalin o, kala kanum boko-som kesu.) Kemin, numi takis moni kaa Sisa ami kukaalum e? God ami kukaalum e? Kapni aket fukunbap kaata bokoyilapla, nuyo utamum o, kala kanum bokolip. ");
INSERT INTO tif_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lale, Yesus ali imi aket mafak fukunbip uyo uteyila yi! Kanoluwa weng mafak ayo ma bokola kala akum o, kalbip kala kala-lomda bokoya ko: kasen-fakamin, ibi kanimin o, kalaliwa dap-kukulupla, ayo weng mafak ma bokolak i! nanbip yoko? ");
INSERT INTO tif_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis mo-laamin moni ayo ma kulii-tiliwa, nita utam tamon o, yakaya, fan kulaa moni ayo koliwa, ");
INSERT INTO tif_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","utam ale, dik-daaya ko: Yak tuumon diim kabak-ali sinik so, win so kala bom-bilip kii, kawanmi sinik sole, win so, kiita bom-bilip i? yakale, ");
INSERT INTO tif_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","isiik Yesus weng maan telip. Kaye? Sisa ami sinik so, win so, kiita no, kaliwa, Yesus asiik bokola: Uyo kanolin kemin, tuumon kalawaali Rom kasel King Sisa ami tuumon kemin, Rom kasel imi gavman almi kukaan-bam ale, God ami mafek mafek kaata, kuno God ami kukaan-bam kemin o, yakale, ");
INSERT INTO tif_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","isiik weng san-ilomdip Yesus ami weng kaali, akal alik ma bokola no, kala-lomdip, imi aket fanang alik tambaneyu, Yesus ayo kambola tabanip ko. ");
INSERT INTO tif_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Juda imi kamok kamok malo ma kiili, Sadusi yo, ken-umbip iyo boko-lomdip: Unang tunum taansip kiili, asuk tam tiinokomip disa yo, ken-umbip. Kemin, Sadusi malo ma iyo (din Yesus ami dik-dakamin kaa fiitmin dukum ma dik-daaluwa, ami miit kaali talalu daka-daa bokoyin disa kela namti, unang tunum iyo aban-delik i! kalalipla) tal Yesus ami bokolip: ");
INSERT INTO tif_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kukuyin tunum, kapyo! Nuli weng ma dik-daap-tum o, kalup. Kemin ale, sawaayak kawu, Moses ata God ami lo ayo numi kuyinsa umi anung kaa boko-lomdu: Tunum ali tunum man ma foko tiilin dinim ke ilomda saaka-lom kalel kutiila namti, niing alta asuk fik ami kaluun uta kuluula akam imi tunum man kuulokomip kaali ali boko-lomda: Kabi nami abaap ami man kayi! aka-lomda kamasi fik taanse ami bung mafek mafek uyo mep man kuula ami kukaalak o, kalsu. Kemin ale, ");
INSERT INTO tif_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","uyo weng san bom-ilawa, sawaayak kawu tunum ma nuso bom biisa ata, man tunum man fetkal foko tiilaya, nikil ti alik maakup tal aba tam fasuu tiile, kulaa fik diil asiik unang kuluula, ilom man so ma foko tiilama dinim ke, taanale, fik almi tamon ata taba fik kalel kaluun uyo kuluula. Katale, ");
INSERT INTO tif_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","akal ti kuno man so ma foko tiilama dinim, kela taanale, imi nakal kuno niing iip ma ata fakal imi kaluun uyo kuluula. Kata ti kanumin-kup kem-umbi-lom imi nakal kiiso nikil alik maakup maakup iyo man so ma foko tiilin dinim ke-lom, ");
INSERT INTO tif_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","alik kuliila tabiwa, atin mafiing mafiing kulaa unang ukol kuno taan kesu no. ");
INSERT INTO tif_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na! kapni aket fukunbap kaa bokoyan aa! Tunum nikil fetkal alik kiili, unang maakup kuuta-kup kuluu biile, taan-taan-kesip. Kemin, bom-bi-lom tunum taansip imi tam tiin kawang ke-lokomip kaali, unang kuuta kawanmi kalel ke-lokomu ni? kala, Sadusi iyo Yesus ami dik-daaliple, ");
INSERT INTO tif_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus asiik imi weng maan tiiya bokoya-lom: Ibi God ami Sukon Tem Weng kaali, talalu ma kaal kelin disa kesip kemin, God kaali, titil soyim o, kaa kalin dinim kesip. Kemin, ibi ti aket mafak-kup fukun-unbip o. ");
INSERT INTO tif_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Weng san bom iliwa! Ilom am ma daanokomu kaali, unang tunum taansip kiili asuk tam tiin tam God ami abip suunkup ilokomip uyo, unang dan kaa-bala, tunum dan kaa-bala, ke-mokomip disa; kiili tiltam akal alik ke-lomdip abiil kayaak ensel ililtap ke-lokomip te! ");
INSERT INTO tif_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kemin, kipni weng kaa boko-lomdip: Tunum unang taansip iyo atin taan maaklo kesip kemin, God ali ma iyo im-fola tam tiinokomip disa yo, ken-umbip kaami sang kaata bokoyon o, kalaliya kemin, tunum taansip imi asuk tam tiin-yaa-mokomip kaami sang kaali, God alta bokoya, yak almi Sukon Tem kabak dola kutiiliwa ibi tik-tiin-umbip. La, ibi talalu ma utamsip disa. Ali boko-lomda: ");
INSERT INTO tif_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nali Abraham so, almi man Aisak so, almi man loop Jekop inang alimal imi God namti kalabi no, kala sawaayak tunum taansip imi sang kaa kanum bokosa. Kemin, unang tunum iyo taan-ilom maaklo kelip namti, God ayo imi tiin molama disa. La, unang tunum iyo taan-ilom maaklo kemin dinim. Kemin ti, tunum taandip din God ami diim kawu suunkup laabip isole, tunum tiin kawang bom-bilip iso, kiita tiin mosa. (God ami weng kaa Moses ami bokonsa kaami miit kaa dok ata naa kalolip: Abraham alimal ili sawaayak kawu saaksip. La, fan God ami tiin diim ayo ti bom-bilip kala kalalaya, alimal kii tiin mo-bomdaya, boko-lom: Nali alimal imi God namti kalabi no, kalsa) kayi kala Yesus ayo imi weng uyo maan tiiya ko. ");
INSERT INTO tif_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Unang tunum yaapkan iyo Yesus ami weng kukuyim-bam bakayimba uyo weng sandiwa, fanang alik tambanula aket dukum fukunip ko. ");
INSERT INTO tif_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadusi iyo Yesus ami kanum bokola uyo weng san-somdiwa, ami weng kaa maan telokomup dinim o, kalalip weng so ma bokolalip dinim. Duluuma tiinip kala, kalale, kulaa Falosi yakal tala-tala-ke weng dil mo kutii kulaa kela ");
INSERT INTO tif_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","nikil ilmi iipyak tem kulu lo utamsa tunum ma tiltam bokola: Nita iboko kasen-fakamin weng ma Yesus ami dik-daala utami ya, Ayo weng mafak aye ma bokola kala kalon o, kala-lomda, ");
INSERT INTO tif_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yesus ami dik-daala ko: Kukuyin tunum kapyo, God ami Sukon Tem Lo bombuu kabak-ali kalok nolin kaata ti diildiil dukum buu ni? akale, ");
INSERT INTO tif_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus asiik bokola: Kabi ti ami aket kaali, atuk atuk ke-laamin disa; kapni aket aa, fanang aa, tiin aa, kiili, alik kulaalap yak God Dukum ami diim abamnip, ami aket-kup kolan o, kalsu namti kaa bombuu. ");
INSERT INTO tif_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","God ami lo kuuli, win sokan dukum kemin, uta uta ke-lom lo malo kuliili, kulaak banip keyinsa no. ");
INSERT INTO tif_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aa, God ami lo ma ukol ti ultap uli boko-lomdu: Kabi kaltapni angtiil aket duu-lom, tiin saan-umbap tap ke, kaptum kusal so, kayak kayak so, imi aket kuyale, tiin saanin o, kalsu kemin, ");
INSERT INTO tif_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","lo alep kalawiita diildiil dukum o. God ami Lo alik Moses ata dolsa so, God ami weng ku-fatap-daa bakamin almi profet kuyila dolsip iso, kaami miit kaali, lo alep kiita kayi! yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yesus ayo utamaya, Falosi yaapkan iyo tal tiinaabip kala kalale, dik-daayila ko: ");
INSERT INTO tif_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ibi God ami uldaa-dabuula tiltam kamokim kesa tunum Kraist o, kalbip kaa kawanta ni? Ali kawanmi man loop tip-tiila kaptoop bansu umi tunum i? kalale, isiik bokolip ko: Kaali King Devit ami man loop o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Yesus asiik bokoya-lomda: Siin sawaayak, God ulduula tiltam kamokim kesa tunum ayo dabaala tal tawaal diim kalawaali tilin dinim ilala, God ami Sinik Tambal kaata, almi aket fukunin kaayo, King Devit ami kolaya, akal boko-lomda: God Dukum ata nami Kamokim ami bokola-lomda: Kapyo, tal aba yang nalmi sikil ting tuuplo kamokim ami tiin-yaamin baan diim kaldaaku tiin-balapla, bii-lom nata nata kelila kawu, kapni waasi iyo kabaak banip kamboyi kalalawa kawu, kii kapta tiin molokomap o, kala God ayo bokonsa no, kala Devit ata bokosa. Devit ali kanimin o, kalalaya, kaali nami Kamokim o, kalsa yoko? ");
INSERT INTO tif_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kiwe, God ami uldaa-dabuula tiltam kamokim kesa kaa kawanmi man i? Devit ami aket kaa fanang daalaya, Am ma daanokomu kaali, ilom kaptoowu nalmi man loop ata ma tiltam tabokoma kala, kalalala kaami aket kaata fanang daalaya, bokosa dinam kabak boko-lomda: Kaa nami Kamokim o, kaloma disa yo. Devit ali kalok nolin aket kaaso, fanang-daa boko-lomda: Kaa nami Kamokim o, kalsa ni? kala Yesus ayo Falosi imi dik-daaya ko. ");
INSERT INTO tif_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kanolin kemin, tunum ayo ma taang-kala-somdala, Yesus ami kanum bokola uyo nusiik maan telokomup dinim o, kala-lomdip weng so ma bokolin dinim kelip. Ti am kulu daanba kuyaku kamok kamok alik iyo Yesus ami weng kun tabin kaata suun-daa-lomdip maso ma dik-daalum o kalolip dinim kela unip ko. ");
INSERT INTO tif_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesus ayo almi daang bakaalin tunum iso, unang tunum yaapkan iso, imi bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Lo utamsip tunum so, Falosi iso, ita God ami Lo Moses ata dola kutiisa uta kukuyila-yaabip ");
INSERT INTO tif_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","kiimi taba, ipni kukuyin-bam ale, weng bakayim-bam kem-laabip uyo ti tangbal-kup weng san-kaa-bam kutal-fuku-biliwa yo, kala-somla ko. Lale, ili God ami Lo ipni kukuyila-yaabip uyo, yakal weng san-kaa-bam kanun-umbip disa. Weng kuyang saak tiin-tabasip kemin, ibi imi kukup kanubip kaaltap kaa kuuta fukumin daa yo. ");
INSERT INTO tif_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kanola iyo mafek mafek uluum tabin kaali, kuluu kuyak tunum imi nakal kun diim kawu tiiya-lomdip imi dong dokoyum o, kala-aamin disa yo. ");
INSERT INTO tif_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kiilile, numi kukup uta kanu-bulupla, tunum unang ita itamdiwa numi win ayo kufuyik o, kalalipla, kanun-umbip o. Imi kukup kanun-umbip kaali, God ami Sukon Tem weng uyo boko-lomdu: Ibi God ami weng anung ma sukon diim kabaku dola kutii-lom ang-de-lom kuyak iltipni dabal kun diim so, biti kun diim so, kabaku kuyak daa bom tal-une-bamdip yo, kalsu. Lale, kamok kamok iyo ang aalap dukum dinabi kuyak ilmi dabal kun diim so, biti kun diim so, kawu dinabi kulii-tal-une-bam laabip aa, ti kuno ilmi ilim matum-matum ayo kiit kon yaapkan kuyak dakabi tal-unen-umbip o. ");
INSERT INTO tif_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kamok kamok kiimi din tunum kamokim ma aso ima inum o, kalokomip kaa, ili yak aba din ti abiin tangbal kamokim ami mepso kulu tiin-yaamum o, kal-bom ale, yak aba din lotu am unokomip kakal ti, kanola kamok kamok imi abiin baan tambal kawu tiinupla, unang tunum ita nuyo itafii-bamdipla, numi win ayo kufuyik o, kala kanu-bam kem-yaabip o. ");
INSERT INTO tif_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kanu-bam ale ma kaali, yak aba din ima saanin maket baan diim kaba unupla, unang tunum ita kamok kamok imi kanolin kukup kaata kuluu-lomdip weng umkaayim-bam, imi bakayim-bamdip: Kibi God ami Lo kukuyin tunum namti kaa bilip o, kemik o, kal-bomdiwa, kanu-bam ken-umbip o. ");
INSERT INTO tif_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nimi daang bakaalin ibi, kamok kamok imi kukup kanubip kaaltap kaa kutal-fukumin daa yo. Nami daang bakaalin tunum kipni kukuyin tunum kii yaapkan disa; ti maakup nata-kup kemin, ibi ma ata win tibin ke tam bana, ma ata win dinim ke kabaak bana kelin disa. Nikil tikip alik maakup kunolin altap altap ke-bomdip bom-bilip kemin, unang tunum iyo itam-ilom, U, kiili fan kukuyin tunum o, kal-bom kipni win kaa kufuyokomip daa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kanolin tap kemin, kipni God kaali yaapkan disa. Ipni Kaalap abiil tikiin kayaak God kulaa ti maakup kaata-kup kemin, tawaal diim kalawaali ipkal tunum ma ata kamokim o, kalalip, kaali numi atok o, kal-bom ami win kaa kufolin daa yo. ");
INSERT INTO tif_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ultap kemin, ti nata-kup, God ata uldaa-nam-buula tiltam kamokim kesi tunum kaali ti nalta-kup kemin, kabi kaptum kusal iyo bokop-ta-lomdip: Kamokim o, takan-kaa-bam kapni win uyo kufup-tin disa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kabak-ali ti atin kanumin dinim ko. Kipni iipyak tem kaptam-ali kanta ma kamokim namti, ali disa kipni masiim dong dakaayin tunum namti kaa bombe. ");
INSERT INTO tif_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dok nolin tunum ita ilmi win ayo kufu-bamdip: Nuli win tabin dukum o, kemip namti, kiilile bom bii-lom God ayo bokoya-lomda: Kanumin tunum ibi nami tiin diim kaali, ibi kabaak banipla ibi win dinim o, yokokoma. Ale, tunum kawanta ilmi win ayo kufumin dinim, ti aptum kusal imi disa kulu dong dakaayip namti, bii-lom kaptoop ali God ayo kanolin tunum kiimi win ayo kufoya bokoya-lomda: Nami tiin diim uyo ibi win dukum o, yokokoma no, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesus ayo asuk lo utamsip tunum so, Falosi iso, imi bokoya-lomda: Lo utamsip tunum aa, Falosi ipyo, weng selin! Ibi ti kasen kasenmin kukup kaata-kup kutal-fukulin tunum kipyo! Unang tunum ili tiltam God ami miit tem tulum o, kal-bilipya ipta bokoya-lomdip: Daa, kamasi ibi kaa numi weng sawaa yaapkan kalawasiik kutal-fuku-somdiwa yo, yakan-kan-tabasip. Ipkal tam God ami miit tem ayo yang unemin disa bomdiwa, kemin ale, kipkal unang tunum God ami miit tem unum o, kalbip imi liip uyo bak-daaya-yaabip. Kemin, am ma daanokomu uyo kaami kalan kaata God ayo ibi angtiil yol awak uyo kukaayokoma kayi! Kemin, kabak ali talalu utafii-bamdiwa yo! ");
INSERT INTO tif_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lo utamsip tunum so, Falosi so, ibi kasen-fakamin kukup kutal fukulin tunum yam kemin, ibi unang kaluun imi kasen-fakayin-bamdipla imi am sin-yaamin uyo bukuuyipla, iyo am dinim mafek mafek dinim ke-bam ken-umbip o. Kanolin kukup mafak mafak kulaa kanubip. Katale, ibi unang tunum imi tiin diim ayo kasen-foko God ami beten kaman-bulupla, unang tunum kiita, itam-ilomdip numi tong uta bakamin o, kalalip beten batbat ayo ken-laabip. Kata, ilom am am daanokomu kawu, kaami kalan kaata, God ayo ibi atin ti angtiil yol dukum kaa kukaayokoma te! ");
INSERT INTO tif_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kemin, lo utamsip tunum so, Falosi so, ibi kasen-fakamin kukup kaata, kutal-fukulin tunum kemin, ibi boko-lomdip: Tunum unang kusnum kayak kayak ili aket fal-siki-lom Juda kasel numi kukup uta kutal-fuku tabuulin o, kalalipla, ibi tawaal liip e bot tem liip e unbilin abip kusnum kusnum kawu, weng kalawaali bakayila-tal-unen-umbip. Tunum ayo ma kipni weng kaata, weng san ami aket ayo fal-siki-lom ipni daang bakaalin tunum kela namti, kipta kukon-biliwa, akal ti kukup mafak ayo kanu-bala, bii kipni kukup mafak uyo kulaak banu, ami kukup mafak uta tam kaltoop ban-ilom dukum ke-lokomu no. Am ma daanokomu kaali, kabak-ami kalan kaata ipso, aso, alik ibi din abip mafak unipla, God ayo angtiil yol dukum uyo kukaayokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ibi tiin fiim ililtap. Ibi taang-kala liip din God ami abip unemin uyo tunum unang kii kukuya-yaabip disa. Kamok kamok ibi boko-lom: Kabi kaptum ami diim kawu weng kuku-daala-lomdi kanolokomi no, akokomap kaali, God ami lotu am diildiil win diim uta kufo-lomdap, kapni weng uyo ku-titil molap namti, kapni weng kuka-daalap kuumi lolokomap kulaali weng dinim o, kalokomip. Lale, kapni kaptum ami diim weng kuka-daalokomap kaali, gol kuluu kabas talalu kutii-lom God ami lotu am tiisip umi win diim tii kufo-lomdap kapni weng ayo ku-titil molap namti, kapni weng kutiilap umi lolokomap, kaali atin mafak o kalokomip. Kapkal kuu kutal fukulokomap o, kal-bom kukuyila-yaabip. Ilom kaali, ipni kanumin kukup mafak kaa kukuya-tabasip kaami kalan kaata, God alalta angtiil yol awak uyo kukaayokoma. ");
INSERT INTO tif_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lale, ibi kanolin umi weng miit dinim kaa kanimin o, kala bakabip? Lotu am diildiil kaa God ami am awem uta win sokan ale, am uta uta ke-lomdula, kabas aye, bung am kaptam bombe kiili, win katip kemin, iyo kulaak banin ko. Ibi tiin fiim tap ke babon bi tiinaasip utamdula kemin, kanolin weng kala bakan-umbip te! ");
INSERT INTO tif_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aa ti ma kaa, ibi boko-lom: Kabi kaptum ami diim kawu weng dap-tii kanolokomi no, kalokomap uyo fuumin baan diim mafek mafek fuubi God ami kukaalin umi win diim uta kufo-lomdap kapni weng ayo ku-titil molap namti, kapni weng kuka-daalap umi lolokomap kulaa weng dinim o, kalokomip. Lale, yak kapni kaptum ami diim kawu weng kuka-daalokomap kaata, mafek mafek olti tuum kom diim kabaaku as kiinba umi win diim ata kufo-lomdap kapni weng ku-titil molap namti, kapni weng kuka-daabap umi lolokomap kaa mafak o kalokomip. Kapkal kuu kutal-fukulokomap kayi! kal-bom kukuyila-yaabap. Kemin, ilom am ma daanokomu kaali, ipni kanumin kukup mafak kaa kukuyila-tabasip kuumi kalan kaata, God kaa angtiil yol dukum kukaayokoma. ");
INSERT INTO tif_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kata, ibi kanolin weng miit dinim weng kaa kanimin o, kalalip bakabip yoko? Fuumin baan kulaali, mafek mafek God ami kukaalin umi baan diim ale, win so kemin, akuum kabaak-ata uta uta ke-lomdula, mafek mafek olti tuum kom diim as kiinba umi win katip kemin, ita kulaak banu kewunsu. Ibi tiin bokol tap kesip. Kemin, utamdula mep kanolin weng kaa bakan-yaabip. ");
INSERT INTO tif_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Lotu am diildiil umi fuumin baan diim so, mafek mafek olti fuumin baan diim bombuu so, iyo alep kano ti God ami no. Tunum ayo taba nalmi weng uyo ku-titil molon o, kala-lom fuumin baan diim umi win uta kufolokoma namti, kaali mafek mafek olti tuum kom diim as kiinba umi win kaaso, kufolala, ami weng uyo ku-titil molokomu no. ");
INSERT INTO tif_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ultap kemin, lotu am diildiil kaali, God ami am kemin, tunum ayo ma lotu am diildiil umi win uta kufola namti, God ali kaptam bombe kemin, ami win kaaso kufolokoma namti kabak buu no. ");
INSERT INTO tif_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","God kaali abiil tikiin kayaak kemin, tunum ali abiil tikiin umi win uta kufola namti, kaa God ami abiin tiinba kaami win kaaso, God almi win awem so, dafolokoma namti kaabuu. ");
INSERT INTO tif_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kemin, lo utamsip tunum so, Falosi so, ibi kasen-fakamin kukup kaata kutal-fukulin tunum kemin, ibi inin-inin atul katip katip aye, kuut aa, maang aa iyo bakela kutii kutii kebi sikip nakalkal ma keliple, baan maakup kulaata, God ami kukaala-yaabip. Ultap kemin, ibi God ami Lo kutal-fuku mafek mafek win dinim umi aket kiita-kup yan-bulula kanum-laabip. Katale, Lo umi mafek mafek win sokan dukum umi aket utale, lukuuyila kela-laabip. Kemin, ibi kaptum kusal kii alik maakup kukup tambal kaata-kup kukaayim-bam ale, aptum kusal iyo olen-daaya dong dakaayin-bam, kaptum kusal iyo ti tituun-weng-kup bakayim-bam kemin, ibi umi aket kaa lukuuyila kela-laabip. Kemin, God ali ipni fiyaap kaa duuba dinim kemin, ilom am ma daanula kawu, kaami kalan kaata, God ayo angtiil yol kukaayokoma. Kipni mafek mafek sikip fak-tiimsi sikip nakalkal kelule, sikip ma kaata God ami kukaala-laabip kulaa, tambal. Ya, yak kukup tangbal win so kaso kanu-mokomap kaata, yaap. ");
INSERT INTO tif_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kemin, ibi ti tiin fiim ililtap kemin, aptum ami liip ayo kukolokomip dinim o. Kanolin kemin, kamok kamok ibi tunum unang iyo kukup tangbal so ma kukuyila-yaabip disa; ibi weng sawaa katip katip uta kutal-fuku-lom ale, yak Lo dukum utale, kutal-fukumin dinim. Ibi tunum kalawaami sang bokoyokomi kaali, kalanolin o. Tunum ayo ok inamnon o, kala titoop daalaya, ami ok ket tem kaptoop ali wol balang ma tal aba toop saakba kala, kala-lomda kulaa kela ok ayo sing daala tiil-banu kela-somdala, kuno kamel kaa kang dukum kemin tal ok ket tem kabaaku daak ilom taanba ayo atamin disa ke-lomda, ok ku-mafak-daaba kulaaso maaklo inase no. ");
INSERT INTO tif_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kanola lo utamsip tunum so, Falosi so, ibi kukup alep fukumin tunum kemin, ibi kabas so, kap so, iyo disa tiltam saaklo kuliita-kup, diinga-laabip. Ya, am lo kabaak-ali diinga-laabip disa; kabaak-ali ninak so kela-laabip. Aa kuno ti, ibi mafek mafek kaa ti nulmi-kup kelum o, kal-bomdipla, aptum kusal imi mafek mafek uta yukut dakaayim-bam ale, saak-kup dik-dakaayim-bilip, aptum kusal imi mafek mafek uyo kukaayim-bam, kem-laabip. Ipni iipyak tem kabak-ali ninak ta taba yam-mafak-daasu. Kemin, am ma daanokomu uyo, kaami kalan kaata, God ayo angtiil yol uyo kukaayokoma. ");
INSERT INTO tif_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falosi ibi tunum tiin fiim ililtap kemin, ibi kap so, kabas so, imi tem kabaak asiik diingbip-kup, tiltam saaklo kaakal kuno ninak dinim tangbal-kup ke-lokomu no. Ultap kemin, ipni aket fukunin mafak uyo kela-lomdip aket fal-kel-nokomip kaata, kipni kukup kaakal ti tambal-kup ke-lokomu no. ");
INSERT INTO tif_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yak lo utamsip tunum so, Falosi iso, kibi kukup alep kiita-kup kutal-fukulin tunum kemin, ibi kom tem ultap o. Tip kultam-ata atin ti tambal-kup dotusip. La, iipyak tem kabaak-ali tunum imi tiil so, kun so, kiili foma-lomdu tang mafak kutam dakaba, kabaak-ali tunum unang kii talalu utam-laabip dinim o. ");
INSERT INTO tif_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kanolin ultap kemin, tunum unang ili kibi itamipya, Ibi tituun-kup tunum o, kala-laabip. Yale, ipni iipyak tem kabak-ali iltipni kukup alep fukumin so, kukup mafak kusnum so uta taba-lomdu yam-mafak-daasu. Kemin, bom bii kaali, kaami kalan kaata, God ayo angtiil yol kukaayokoma kayi! kala Yesus ayo lo utamsip tunum so, Falosi so, imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yesus ayo kamok kamok imi asuk bokoyila ko: Lo utamsip tunum so, Falosi iso, ibi kukup alep kiita kutal-fukulin tunum kemin, kipni kawil-fakal ita God ami weng ku-fatap-dakamin tunum profet iso, tituun-kup tabasip tunum kusnum iso, ili yan fakabi imbii din bal-kaamsip imi dabom diim ayo kipta tambal-nuk o, kala-lomdip, tuum ayo kulii-tal maltii-bam ale, ilakan-tal-une-bam as tes san ayo diki-yin-bam ke-bamdipla, ");
INSERT INTO tif_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","boko-lom: Nuli sawaayak ayo nuso, numi awil-fakal iso, maakup bom ilomduwa dinam, numi awal imi God ami weng ku-fatap-dakamin tunum profet anulip taansip tap nokol kanola dinam kano-sulup dinim o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kipni kanum bakabip kaali boko-lom: Nuli God ami profet anulip saaksip imi man loop ali kala-bulup o, kebip kaali, tifaneng ibi ililtap. ");
INSERT INTO tif_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kamosinim kaptoop ali kipni kawil-fakal ili kanolin kukup mafak kiita kutal-fukulipla, tiknuk o. Kemin, ilom kaami kalan kaata, God ayo angtiil yol ayo kukaayokoma. ");
INSERT INTO tif_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Inap mafak ta taba tunum iyo ye-bam yam-mafak-dakan-umbip ililtap ipsole, iltipni kawil-fakal iso, ipta taba-bom tunum iyo yam-mafak-dakan-umbip. Kemin, ilom am ma daanokomu kaali, kaami kalan kaata God ayo fokola din as kiinin abip mafak suunkup kiin-bam ilin kawu kiin-bam ilokomip. Kipni aket ayo wakadaa din tangbal ilokomup aa, kemin daa. Tifan ti ibi din as kiinin abip une-mokomip te! ");
INSERT INTO tif_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nami weng kala bokoyokomi kalawaali weng san iliwa. Nami profet so, weng miit utamsip tunum so, mep kukuyin tunum iso, iyo im-baali din ipni bilip kawu unokomip. Lale, nami utabi uyo, kipta taba malo ma anulip taaniple, kuno malo ma ita anu im-bak as diim kawu im-dii-lom ye-bam ale, malo iyo imbii din lotu am kawu biwaka-bam ale, malo ma dabak tiiya yak aba din abip ma ma kawu, une-bam ke-mokomip o, kebi. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","kanu-mokomip kabaku God namti kawu angtiil yol uyo kuyokoma. Sawaayak kamasi kaptoowu kulii umbital kala diilu kaa kipni kawil-fakal ita taba-lomdip tituun-kup tabin tunum kii, yem-tabasip. Kamosinim diildiil kaali, Ken asiik almi niing tangbal Ebel ayo aala taanala, kuyaku iluu-lomdu, God ami okok kemin tunum iyo kuyaku yan yakyak kulii umbital kulaa diila iltipni kawil-fakal ita Berekia ami man Sekaraya ayo din God ami am diildiil kaldak ale, mafek mafek fuu-bilip kiin tabemin baan diim kabak umi iip iip kabaaku tolnaya aaliwa, taansa. Kemin, God alalta kipni kawil-fakal imi ban wakamin kaaso, mep iltipni ban wakamin so, kaami kalan kaata kuyak-kuyak ke-lomdala, God ayo angtiil yol kaa ibi kuyokoma ko. ");
INSERT INTO tif_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nali tituun weng asuk bokoyokomi. God alalta alik kipni kawil-fakal imi ban wakamin kaami kalan kaata, tunum kamala kulu bom-bilip kipni kuyokoma no, kala, Yesus ayo lo utamsip tunum so, Falosi iso, imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesus ayo Jerusalam kasel imi aket fanang daa-lomda aket uluum kelula, unang tunum imi bokoya-lomda: Jerusalam kasel kipyo, God ami profet iyo ye-bilip taan-yaa-bam ale, God almi daang bakaalin tunum yim-baala tal-tal ken-umbip iyo tuum-ta-kup binalip yak aba ye-bilip taan-laa-bala kem-tabasip. Lale, nali awon awak umi man foko-lom ulmi bal kun tem tii katii-yimbu tap o. Am yaapkan daa n tiltam taba tal-unum kemu kaali, nali alik ibi imbii tildang daa nalmi sikil ta uti foko yam am daalon o, kala-laabi. Lale, kep-na-laabip kemin, kanun-umbi dinim o. ");
INSERT INTO tif_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kipyo, kanola daang ukup-nip kemin, God asiik ipni daang ukuyale, waasi iyo kuno kamboya taldip kipni abip so, lotu am diildiil so, iyo yam-mafak-daaliwa, unang tunum alik iyo ilmi abip ayo kambolalip wakadaa sak funbi una-tala-ke-lokomip. Kemin, maso kaptam ilokomip dinim o. ");
INSERT INTO tif_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nali ti fan tituun weng kaata bokoyokomi kaali, ibi maso ma nitamin daa; bom-bilip bii iltipta boko-lomdip: Numi kamokim kalawaali God kapni win diim tala kemin, kabi kukup tambal kaata-kup kukaan-balapla yo, ke-mokomip kawu nita-mokomip kayi! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus ayo lotu am diildiil ayo kela unon o, kemale, kulaa almi daang bakaalin iyo tal bokolip ko: Kamokim kapyo, tiyak am tambal kala atam taman o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesus asiik bokoya-lomda: Kamala kulaata, tiyak daa tuum kuyak tip-tip ke-lom am tangbal desip kaa utafiibip. Yale, nami weng kala bokoyokomi kaali, talalu weng selin! Bom bii-lom kaali, waasi tunum ita tal am kalawaali alik balata kutii-lom tuum kuyak tip tip-bam miltiin-unsip uyo dekela dabuulip daak abamnu bii disa ke, disa akal almi kulu bala bala ke-lokomu no, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus so, almi daang bakaalin tunum iso, ilakis yak aba tam Oliv Tikiin kawu Yesus ayo tiinale, almi daang bakaalin tunum iyo tala-tala-ke-lom dik-daalip: Kamokim kapyo, dok kanumin diim kawu waasi iyo tal lotu am diildiil ayo balat-nokomip i? Kalok nolin kukup kaasiik tiltam tuluya utam, Awu, kulaali kapni asuk talapla, tawaal disa ke-lokomu namti kulu mep tulu kala uta-mokomup yoko? akiwale, ");
INSERT INTO tif_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus asiik nikil imi bokoyila ko: Talalu utafii-bamdiwa yi! Kasen-fakayin tunum kiimi weng kaa, weng san-kaamin daa yo. ");
INSERT INTO tif_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tunum yaapkan iyo tal-ilomdip, nami win uta kuluu-lom boko-lomdip: Nali God ami uldaa-nam-buula tiltam kamokim kesi tunum Kraist o, tal kala una-una-ke-bilipla, unang tunum yaapkan iyo imi weng kaali tifan o, kala weng san yang banokomip. Kata, ibi imi weng kaali, Fan o, kala weng san-kaamin daa yo. ");
INSERT INTO tif_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ibi weng seliwa! Tunum miit ma iyo kaa din daalip, tunum miit ma iso waasi din-biliple, am waasi umi ukduu dinan-tal-une-bala kemip uyo dukum-nokomip kawu, ibi am mafiing daan tiltam tulu no, kalalip aket kufoyu kaa suunin daa; kanolin kukup kusiik tiltam tabokomu. Yale, uyo kanum tala-buluya, kuyaku abiltap am mafiing diim ayo daan tiltam tabokomu disa kayi! ");
INSERT INTO tif_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Am bokon ma kaptam kasel iyo bokon kusnum ma kasel iso din-biliwale, kuno king kusnum ma ami tunum tiin moba ita taba-lomdip yak king kusnum ma ami tunum tiin mosa iso, din-biliple, kuno am bokon yaapkan kawu ima tinap, ol fut am daan tiltam aba-tala-bulule, bim ayo taltam taba-taba balala ke-mokoma. Lale, ");
INSERT INTO tif_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","angtiil yol kaa kaa-mokomip kaata-kup, kuluu-laa-mokomip disa; uyo tal-unula, asuk mafiing kaptoowu angtiil yol yaapkan yaapkan tiltam aba talun-talun kebii, disa kelula, kawu am mafiing am uyo tiltam talokomu ko. ");
INSERT INTO tif_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ibi nami lak duu-bomdip nami ok kaata fuku-bom-bilip kemin, kaami kalan kaata abip ma ma kiimi tunum yaapkan ita ibi aket atul kukaayim-bam ale, iyo itam suun-bamdip yim-tal fukule, sok de-yimbii din kamok kamok imi diim daayiwa kamok kamok ilmi tunum ita anulip taan-yaa-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kanum tiltam tabam-nokomu kuyaku, nami lak duulin tunum yaapkan iyo nami daang bakaalin iyo kep-na-lomdip, daang ukup-na ilmi kayaak nami lak suunkup duu-bom-bilip imi waasi keyila itam fanan-bam yim-baalip din waasi imi sikil diim abe-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bom bii-lom kaali, ibakamin tunum yaapkan iyo tal boko-lom: Yi, nuli God ami profet o, yakan-kaabip. Kemin, tunum unang yaapkan iyo imi kasen-fakamin weng kaata weng san ale yang aba une-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kemin, kanolin kukup kanu-mokomip kabaku, tunum unang yaapkan imi kukup mafak uyo sakbaalim dukum ke-bilipla, Kristen unang tunum yaapkan iyo imi aptum kusal aket kukaayin uta da katip katip kem toop dinim-nokomu. ");
INSERT INTO tif_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lale, nami lak duulin unang tunum ili, kanta angtiil yol uyo daka-bamdip kulaa yang banemin dinim; suunkup nami lak kaata, dukum-kup titil-biki-bom bilip taaniwa kawu, kiita God alalta yim-tama tam almi suunkup ilin abip kawu daalala, suunkup ilokomip. ");
INSERT INTO tif_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kemin, nami unang tunum ibi yak aba din tawaal kala bombu kaami abip ma ma uyo tal-une-bamdip unang tunum alik imi bakayim-bamdip: Yesus ali taan-ilomda kipni iliim boyase. Kemin, ipni aket kaa fal-siki Yesus ami lak duuliwa, God akal im-tama tam almi abip tangbal daalokoma no, kala bakayila-tal-unemin o. Kanolip disa ke-lokomu kabaku am mafiing diim namti, tiltam talokomu no, kala Yesus ayo almi daang bakaalin imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Matyu nata, unang tunum nami sukon dol-yimbi umi tik-tiibip kipyo! Yesus ami weng bokose umi dol-nokomi kaluu dotu utamin! Yesus ayo alami daang bakaalin iyo asuk bokoyila-lomda: Siin sawaayak ayo profet tunum Daniel ata God ami Sukon Tem uyo dola kutiisa kabak-ali boko-lomdu: Bii-lom kaptoop ali Jerusalam imi waasi ita taba-lomdip mafek mafek atin mafakan dukum ma kuuta kutam God ami lotu am diilim kaptam tiilipla, uta tiltam ilomdu God ami am diilim ayo ku-mafak-daalu mafak-nokomu no, kalsa. Kemin ale, ibi utamiwa, Mafek mafek mafak uyo kutam God ami am diilim tiiliwa tiltam tolnu kala kalokomip uyo, ");
INSERT INTO tif_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ibi Provins Judiya kawu bom-bilip kiili, abip ayo kela wakadaa bitam amdu tikiin tikiin kawu, sawaan-laa-malip ko. ");
INSERT INTO tif_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kuno am abal akiim kawu bilip namti, asuk tam aba bung ayo ma fokolupla yo, kala tam unemin disa; kulaa kuno maas kela abiltap-siik wakadaa din sawaan-laa-malip kayi! ");
INSERT INTO tif_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aa, iltipni langabip kawu bom-bilip namti, asuk din abip aba ilim ma foko kuluuluwa yo, kalalip asuk abip unemin daa; langabip kuluwu ti kela abiltap din sawaan-laa-malip o. ");
INSERT INTO tif_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kanumin kukup tiltam tabokomu uyo, unang kumun sole, manuuk so, imi ukadaa unokomip uyo fiit-bamdip tal-une-bam ale, angtiil yol awak uyo kaa-bam ke-mokomip. Kemin, kwin! kiiso kawe! kebi no. ");
INSERT INTO tif_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wom ati taba-lom am mafak daana aye, God ami iintang am daanu naa, uyo kanolin mafek mafek mafak ayo tiltam tulu namti, ibi taang-kala abiltap unolip dinim. Kemin, ibi God ami bokola-lomdip: Kapyo, am mafak am daan tiltam tulu kemin, mafek mafek mafak uyo kewap tiltam talemin daa yo, aka-lomdip beten kaman-biliwa yo, kala-somya ko. ");
INSERT INTO tif_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Siin sawaayak kawu, God ata kamosinim tawaal talalusa kuyaku, kulii yakyak bital kula diilu kaali, atin kukup mafak dukum kala tiltam tabokomu ulultap kaa ma tiltam tabasu dinim. Kemin, kanumsi tal-unuya, maso mafiing ayo ma alaltap kanolin kukup mafak dukum kaayo, maso asuk tiltam tabokomu disa. ");
INSERT INTO tif_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kata, God ali almi unang tunum kii ulelnala almi lak duulin imi olen-daayila, boko-lomda: Angtiil yol dakamin am daan tiltam talokomu ayo am mafak kanolin daan talokomu kaali, abiltap-kup tal aba toop banuk o, kalala bokosa. Kemin ale, kanolin weng ayo bokolin disa kesa dinam, almi tunum unang iyo alik kuliila taba disa kelalip. Lale, weng kuuta kutiisa kemin. ");
INSERT INTO tif_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Am kanumin am daanokomu kuyaku, tunum ali ma kipni bokoya-lomda: God ata ulduula Kamokim kesa tunum Kraist ali kulabe kemin, atamin a! kalba aye, yang kabe kemin atamin o, kalba kaa, ibi fan o, kala-laamin daa yo. ");
INSERT INTO tif_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nami weng kala bokoyi kaa dok ata naa kalolip: Kasen-fakayin tunum iyo taba-lom God ami tunum unang ulelna almi lak duusip kipni kasen-fokoya-lomdup, kipni aket fukunin ayo ku-mafak-daayupla, yang banin o, kalaliwa, kipni fanang tale-mokomip. Ma kaata, tal bokoya-lomda: Nali God ami uldaa-nam-buula tiltam Kamokim kesi tunum Kraist o, kalale, kuno ma ata tal bokoya-lom: Nali God ami profet weng ku-fatap-dakamin tunum o, ke-bam mirakel o kala kukup akal almi kusnum kaa kukuyokomip. Lale, God ata ipni ulelsa kemin, ibi yim-buulokomip disa. ");
INSERT INTO tif_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kemin, nami aket fukunin kaali, mep kanolin kukup tiltam talokomu uyo ibi kanolin kasen-fakamin tunum kiimi weng kuu weng sanamip o, kalalila, tiltam tabin dinim, bombuu umi sang kaa bokoyi nami weng kaluuli dotu weng san utafii-bamdiwa ko. ");
INSERT INTO tif_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kuno ti, tunum malo ma tal bokoya-lomdip: God ami ulduula tiltam Kamokim kesa tunum Kraist ali umbilin unang tunum dinim bokon kawu bombe kemin, din ilom atamum o, kalip namti, fan o kala, din unemin daa. Aa kuno ti tunum malo ma bokoya-lom: God ami ulduula tiltam Kamokim kesa tunum Kraist ali yak am kaptamu aptum kusal so bombe no, kalip namti, ibi imi weng kaa weng san-kaamin dinim. ");
INSERT INTO tif_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kamokim Sakbaalim Dukum Ami Man Nami asuk talokomi kaali, baabaa falala-kup kala abiil so, tawaal so, alik falala-kup kala-yaaba alaltap keli tildang fatap-nila, tawaal diim kayaak unang tunum alik iyo nita-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kibi utamipla, Awon mafek mafek fom iniwal yaapkan iyo tam abiil kawu tal-unebip kala kalip namti, kabak ipkal utamiwa yi, Awu, awon ili kaldaak daaliwa, ilimi inin-inin ma ayo taana atamdiwa kala tala-tala-ke-lokomip o. Ultap kemin, nami mafek mafek sang kaa kanum bokoyi umi tiltam tulu namti, utamiwa yi, Nimi talokomi uyo kulu mep dikiwa tulu kalokomip o, kala Yesus ayo almi daang bakaalin imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesus ayo almi daang bakaalin imi bokoyila ko: Yak kanolin kukup mafak mafak uyo tiltam aba tal-unemsi disa keluya, kuyaku tam atan uyo simit-kup daa-lom malang tinilule, kuno kayoop ami dawang akal disa ke-som, wakalkan ukol ti kano abiil tikiin kawu bom-bilip kiiyo, kambola dikela tildaak abe-biliple, tam abiil kun diim mafek mafek titil-kup tabasip yikil kuno alik ilmi liip ayo kelalip sak funbi liip kusnum liip tal-une-bala, tal-une-bala, ke-mokomip ko. ");
INSERT INTO tif_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kanum tala-buluya, tawaal diim kalawaami tunum miit ma ma nami lak kaa duulin disa kesip iyo titam abiil tikiin daaliwa, Dukum Ami Man Nayo ibin tem kabaku tilila, nami titil uyo kuluu-somdila, atan alaltap ke tiin buluusi-kup sikin-bulula, talaba kala, kala-lomdip suunin aalap dukum ke-bamdipla ama-mokomip. ");
INSERT INTO tif_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kanolila, fong ket weng aalap dukum ayo naan-tabamnule, nalmi ensel iyo yim-baali unbilin am bokon alik kaa dik-daa kulaasu kaami balang tem atalingkal God ami unang tunum ulelna almi aket-kup konsip iyo afetu-lom yim-bii talokomip kayi! kala Yesus ayo almi daang bakaalin imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesus ayo asuk weng ma faldak-tii boko-lomda: As kaami kukup kaa fanang daalin! Ipkal as fik umi kukup kuu utamipla, umi kon duul ayo bam-daa kalaangnu namti, kuuli umi lap abuumin ayo mepso dikiwa tulu kala kalokomip o. ");
INSERT INTO tif_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kanolin kemin ale, nami kanolin kukup tiltam tabokomu umi bakayila-tabasi uyo fan kulu tiltam tulu kala kalokomip kuyaku utamipla, Kaa nami talokomi kaami am namti kulu mepso tulu kala, kalokomip o. ");
INSERT INTO tif_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nami weng kala bokoyokomi kaali, ibi weng san iliwa. Tunum unang malo ma tiin kawang bom-bilip kiili, taanin disa kano bom ilipla, nami weng bokoya-lomdi: Ilom kaali, mafek mafek mafak alik iyo tiltam abokomu no, kalbi kaali, atin ti tiltam talokomu. ");
INSERT INTO tif_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Am ma daanokomu kuyaku, abiil so, tawaal so, kulii maaklo disa ke-lokomip. Yale, nami weng kuluuta ti disa ke-lokomu dinim; kano ti suunkup ilokomu no, kala Yesus ayo faldak-tiimin sang ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesus ayo almi daang bakaalin imi bokoya-lomda: Ali dok kanumin diim kawu talokoma no, nakan-kaabip i? Tawaal diim kaldaak-ami tunum ali ma atamsa disa; aa, abiil tikiin kasel ensel ili babon; aa, God ami Man nakal kano ma kaal kesi disa; ti nalmi Aatumen God maakup ata-kup atamsa. ");
INSERT INTO tif_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sakbaalim Dukum Ami Man Nali tilin disa kama bom ilila kaali, unang tunum kukup kaa kanu-mokomip kaalile, sawaayak Noa ami sip dina-balaya, unang tunum imi kukup mafak kanu-bisip ultap o. ");
INSERT INTO tif_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Siin sawaayak Noa ami bom-balaya ok foko tiltam tibin dinim ilsa kaa, unang tunum ili (God ami lak uyo duulin dinim ke-bomdiwa,) ima so, ok so, in-bomdip ale, tunum iyo unang dan kaa-balale, unang yakal tunum dan kaa-bala ke-bilipla, bom bi Noa ayo sip dukum ayo dinan-umbi-lomda dinimnu kewa-lomda, kulaa almi kalel so, almi tunum man asuumano le, imi unang tan so, alimal kalawiita-kup tam sip tem tam uniwale ");
INSERT INTO tif_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","unang tunum kusnum kii utamiwa yi, Ok foko tiltam abokoma no, kalin dinim babonipya kulaali, ok ayo fakan tiltam aba-lomda unang tunum iyo alik yan dong doko-lom alik anula taansip o. Ultap kemin, unang tunum ili God ami lak kaa duulin disa bom iliwa, bii Dukum Ami Man Nayo talokomi. ");
INSERT INTO tif_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nami talokomi kuyaku, tunum alep ma ima lang dikimiwale, ensel ayo tal ma ata dabuuba-kup, ma ata kambola unokoma. ");
INSERT INTO tif_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kano ti nami talokomi ayo unang alep ma ima dotmipya, ensel ayo tal ma uta umbuuba-kup, ma uta kuno kewa unokoma. ");
INSERT INTO tif_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kemin, ibi utamdiwa: Awu, kipni Kamokim ali dok kanumin diim kawu talokoma kala nambip disa. Kemin, kipkal suunkup liip fen-bam biliwa yo. ");
INSERT INTO tif_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nami weng do katip ma kala bokoyokomi uyo, talalu weng san aket fukun-iliwa. Tunum am kayaakim ali utama yi, Kutamiip kaali, dok kanumin diim kawu yukut inin tunum ayo talokoma kala kalba dinam, ali kawang-bomda kutii ilaya, yukut inin tunum ayo kalok no-somdala, tal am kaa balata kutii-lomdaya, tam ami bung kaayo, duk-duu kuliila unoma disa. ");
INSERT INTO tif_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ultap kemin o. Ipkal utamiwa yi! Dukum Sakbaalim Ami Man Nali dok kanolin diim kawu ma talokoma no, nakan-kaabip disa. Maaklo tem o. Kano ti suunkup fen-bamdiwa kayi! kal-bomda, Yesus ali alami daang bakaalin imi kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesus ali almi daang bakaalin imi faldak-tiimin sang ma bokoyila ko: Nali tunum ok dukum-kup ti kanu-bamda aket tangbal fukun-bam kemin tunum, ami sang kaata bokoyon o, kala-somla kemin, kanolin ok tabuumin tunum almi kamokim alta ulduu-lomda bokola ko: Kabi mep nalmi okok kemin tunum kalawiili, dotu yaap-kup tiin molapla, tambal-kup kanu-biliwa, nami mafek mafek ayo dotu yaap-kup bom-bulula, bii ima dan kaayin ulmi am daanokomu kabaku, ima uyo okok kemin tunum imi dan kaayan o, aka bokolala kela unokoma. ");
INSERT INTO tif_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kulaa ok fukulin tunum ayo kamokim ami weng kaata-kup, weng san kutal-fuku-bomdala, ami ok ayo ti kano kutal-fukulin-kup bom ale, okok kema namti, bii kamokim ayo asuk tal ulala yi, Yaap-kup okok kem-tabasa kala kalala, tal fiyaap duulokoma. ");
INSERT INTO tif_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kemin, kamokim ayo tal bokola-lomda: Nali utamila kulawu bomdi titamin disa bom-bilila, ok tangbal nun-umbap kemin, kuluwaata ok awak dukum kaata kapni kup-tila, kapta nami bung mafek mafek iyo alik tiin molokomap o, akokoma. ");
INSERT INTO tif_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yale, tam okok kemin tunum mafak ma fanang daaliya yi! Nami kamokim ayo mafek mafek ma taba-lom dabaak molu kemin, abiltap talokoma disa yo kala, kala-lomda, ");
INSERT INTO tif_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ap-tunum kusal ok maak fukulin tunum iyo ye-bamda, ok mafak im-bom babon-babon kemin tunum iso, tiin-bomda ima aa, ok mafak aa, iso inan-tal une-bamda, ");
INSERT INTO tif_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kamokim kaa dok kanumin diim kawu talokoma ni, ke-bamda fenin disa; kemama daa; ti kuno ila namti, bom-balaya, bii tam am ma daanale, kamokim ayo tal ulaya, Kwin! Kukup mafak nuum-tabasa kala atamale kulu, ami kukup mafak nun-tabasa namti, maan tii-lomda ");
INSERT INTO tif_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","dukum-kup biwaka-bam angtiil yol kukaalokoma kaali, tunum weng weng kuyang saak tii-bamda kukup alep tabuumin tunum ami angtiil yol kukaayin ultap ke, akal kanola angtiil yol ayo kukaan-balaya, ok mafak tabuulin tunum ayo fuut-bamda bokola ko: Kwin! kalawuso kawi! kal-bomda dukum-kup iin-bam ama-mokoma kayi! kala Yesus ayo almi daang bakaalin imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kulaali, Yesus ayo asuk faldak-tiimin weng ma boko-lomda: Am ma daanokomu kaali, nami tiliya, God ata unang tunum alik imi tiin molokoma kaami sang kaata faldak kaami diim tii-lom bokoyon o, kalalila kemin, ipyo weng selin! Tunum ma unang kuluulon o, kalala, unang umi awak-aalap iyo yaap o, kaliwa uyo sintam dabuulu umbuula kemin umi am uyo daan tiltam abale, kuluwu unang umi dong dakaawin unang sii nakalkal kiili, ilmi ilaam iyo kutamalipla, afalop umi aalap ami am ayo kambola tiltam saaklo abal akiim kawu, tiin-bom tunum talda unang kuluulokoma ami liip-kup fenip ko. ");
INSERT INTO tif_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Unang awakal ma kiita, aket fukunin tambal kemin, imi mafek mafek ayo dotuliple, kuno unang awakal ma kiita aket tambal so ma fukunin dinim. Kemin, imi mafek mafek ayo dotuulin disa ke-lomdip ");
INSERT INTO tif_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ilimi ilaam ayo iilfo kuliilip unip. Katale, ilaam umi ok so ma iluu kulii-unolip daa le, ");
INSERT INTO tif_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","afalop kusal aket tambal fukunin ita, ilmi ilaam ayo ok ling abuu kulii-som ale, kalasin ayo ket kusnum kawu abuu kulii, kelipla, nikil unip. ");
INSERT INTO tif_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kano-lomdip unang nikil iyo tiin-bom-biliwa bii, ayo tilin dinim kela kala kalbip-kup, tiin yak dap-tiiyu akan-unipla, ");
INSERT INTO tif_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","nikil akan-bilip bom bii, am iipyak fokolale kulu, tunum ma naan-tabale bokola ko: Tunum unang kuluulon o, kalba ayo kulaata tala kemin, baan kamala kulawu tal dibiilip am unin a! kal-bomda, naan-daaya, ");
INSERT INTO tif_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","unang nakalkal iyo weng sandiwa dikela tam tiin ilaam ayo dotulip, ");
INSERT INTO tif_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","unang aket tambal fukunin dinim yakal utamipla, Numi ilaam kii kiin-tabokin ok kalawaali mepso dinimnum o, kalbip kawi! kalbip-kup, afalop kusal aket tambal fukunin imi bokoyip ko: Numi ilaam ayo ok disa kela tenum o, kalip kemin, ipni ilaam ok kaata, ma ling abuuyiwa, numi ilaam ayo ling-abuulup kiin-tabuya nikil unum o, yikiwa, ");
INSERT INTO tif_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","unang aket tambal fukunin isiik taba aket tambal fukunin dinim unang imi kanum bokoyip ko: Daa. Numi ilaam ok ayo katip sakap kemin, ipni anung ling-abuuyila ke-lokomup kaali, numi ilaam alik iyo abiltap tenokomip. Kemin, kipkal din stuwa un-ilom ilaam wok ma mo-somdipla kawu, ling-abuu kuliilip tilin a! yikiwa, ");
INSERT INTO tif_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","kulaali, aket tangbal fukunin dinim unang iyo yak aba din stuwa ilaam ok fen uniwa, kulu tunum unang kuluulon o, kalba ayo tal mepso kuluba tala kala-lomdip unang nikil awakal dotu ku-mikil kebip iyo, yak aba din unip; tunum ayo tala ke dak-duule dabuu dap-tam am daalip bom alik iyo ima ina faka-bam bom-iliwa, okok kemin tunum ita taba yak am saal ayo kuyak mo liilip ko. ");
INSERT INTO tif_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Da ilanin tap keliwa, unang awakal ma iyo tal naan-bamdip bokolip ko: Nulmi nak-tunum kapyo, mep okok kemin tunum kuliili, bokoyilap saal basuuyiwa, nikil nuso tam unuwa yo, akipla, ");
INSERT INTO tif_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","tunum kama unang kuluula asiik unang nikil awakal imi weng uyo maan tiiya: Disa! Ibi nami kayaak disa. Nali ok tabuulin tunum kii bokoyili saal kaa busuu-yokomip dinim te! kala-lom unang aket tangbal fukunin dinim imi kanum bakayinsa no, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Asuk Yesus almi daang bakaalin imi bokoya-lomda: Faldak-tiimin weng kaami miit ayo talalu aket fuku daalin o! Ibi utamipla, Nali dok kanolin diim kawu talokoma ni, ma kalbip disa; kemin, ibi ti suunkup talalu fen-bamdiwa kayi! yaka, kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kemin, Yesus ayo faldak-tiimin weng akal kusnum ma bokoya: Ilom am ma daanula, talokomi kabaku God ami taba tunum ma kaami dabak-saanin tap ke, unang tunum iyo im-bak-saanokoma no. Tunum kaa umbila umbilin abip samaan ma kawu bombii talokomi no, kalala almi okokmin tunum iyo weng umuuyila, tal atamiple, almi moni aye, bung mafek mafek alik iyo kulaayila yak imi sikil diim abamnipla ");
INSERT INTO tif_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ali utamala, Ma ayo aket tambal fukunin, malo ma ita daa; aket tangbal fukunin tap so, kala-lomda, moni sakbalim dukum kaata kulaayila yak aket tangbal fukunin ami sikil diim aba-som ale, yak moni katip so kulaata, kulaayila yak aptum kusal imi sikil diim abamniple, ma ata K5,000 kolale, ma ata K2,000 kola-som, kuno ma ata K1,000 kola kelala, kalawiita kuluu-somdipla, wan siki-bamdip moni kaap-nam-biliwa yo, kala kambola una. ");
INSERT INTO tif_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kanoyila, kamokim ayo keya unale, kulaa ok fukulin tunum K5,000 kuluula ayo wan siki-bala bom bii moni yaapkan kela K10,000 kelale, ");
INSERT INTO tif_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","kuno okok kemin tunum ma ami K2,000 kuluuba, akal moni ayo kuluu bisnis ke-balaya, bii moni ayo sakbaalim dukum ke-lom K4,000 ke no, kelu. Katale, ");
INSERT INTO tif_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","okok kemin tunum mafiing ma K1,000 kuluuba ayo, kutal-fukule, wan sikimama dinim, kuno kela-lomda, kulii yang tawaal tem kala-lomda almi kamokim ami moni ayo kuwaala ko. ");
INSERT INTO tif_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bom biile, kulaa ok tabuulin imi kamokim ayo asuk umbital abip tal aba-lomda ami moni kanolin ayo dok kanu-bamdiwa bisnis ken-umbip yokon o, kala-lomda almi ok fokolin tunum asuumano iyo naan-daayila tal-ilomdip, ");
INSERT INTO tif_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","kamasi okok kemin tunum K5,000 kuluuse asiik tal-ilomda asuk K5,000 kusnum kuluuba kaami kulii-som, kuno K5,000 kola unse ami kulii ke tal kola bokola ko: Kamokim, kapyo, kalaa ataman! Nali kapni K5,000 kup-na un-salap ayo, kuluu bisnis ke-bamdila K5,000 kusnum ma kalawaayo kuluu-som kelila, kuyang mim-daa daalila K10,000 keba no, kala kola ko. ");
INSERT INTO tif_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kola utam-ilomda kamokim asiik bokola: Ti yaap ke kabi ok kaa kup-ta unsii kaali kela-salap disa; kabi ti talalu titil-foko yikik-tabuusap. Kemin, mafek mafek katip ayo kup-ta uni tambal-kup tiin-mo-salap. Kemin, nali kulaata mafek mafek sakbaalim dukum kaata ma kulaap-ti yak kapni sikil diim abamnula, kutal-fuku-lom tiin molokomap o. Kemin, tiltam talapya, nikil maakup fiyaap duumum a! aka kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kuno ok fukulin tunum K2,000 kuluuse ayo tal kamokim ami bokola-lomda: Yi! kamokim kapyo, kalaa ataman! Nali kapni K2,000 kup-na un-salap uyo kuluu-lom bisnis ke-bamdila, kuno asuk K2,000 akal alik ma kuluu kelila, kuyang mim-daa daalila K4,000 keba no, kala kola. ");
INSERT INTO tif_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kemin, kamokim ayo utam boko-lom: Ti yaap ke, kabi ok kaa kup-ta unsii kalawa kela-salap disa; kabi ti kano titil-foko yaap-kup tiin mo-salap. Kemin, mafek mafek katip sakap namti kaa kup-ti tambal-kup tiin mo-salap. Kemin, nali kulaata mafek mafek dukum ata, kulaap-ti yak kapni sikil diim abamnula tabuu-lomdap, tiin molokomap. Kemin, tiltam talawa, nikil maakup fiyaap duumum o, aka kela ko. ");
INSERT INTO tif_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kanoliwa, mafiing mafiing kulaata ok fukulin tunum K1,000 kuluuse ayo tal bokola-lomda: Yi! kamokim kapyo, nali titamsii, kabi tiin ma baalin tunum balap titamsii. Kemin, kabi tunum kusnum ulela fokolap din kaltapni langabip ayo okok tala-laabip. Yale, ima aye, inin-inin fakan-umbip iyo kaltapni-kup ke-bam ale, aa kabi tunum kusnum iyo fokolap din kapni mafek mafek iyo kaptum kusal imi kuyip san-umbip. Lale, kabi kaltapni moni-kup ayo faka-bam ke-balap titamsii kalaliya kemin, ");
INSERT INTO tif_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","nali kapni atul kaata suun-daa-som ale, bisnis kemin umi kukup kaali, babon kemin ma utamin disa. Kanolin kemin, nali kapni moni kalawaali kulii-din-ilomdi tawaal foko-lom kuwaap-tila, tambal-kup laabu kemin ale, kula kaltapni moni kalayo, kuluulan o, kala-lomda kolala, ");
INSERT INTO tif_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","kulaa, kamokim ayo ok tabuulin tunum ami bokola-lomda: Kabi ok fukulin tunum mafak ale, daal-kup tabasap tunum kemin, kabi bokop-na-lomdap: Kabi tunum kusnum ulela fokolap din kaltapni langabip ayo okok tala-laabip. Yale, ima aye, inin-inin fakan-umbip iyo kaltapni-kup ke-bam ale, kabi tunum kusnum iyo fokolap din kapni mafek mafek iyo kaptum kusal imi kuyip saan-umbip. Lale, kabi kaltapni-kup moni-kup ayo faka-bam ken-umbap o, nakap. ");
INSERT INTO tif_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kemin, kabi kanolin aket uyo fuku-daali no, kalap kaali, kabi kanimin o, kala-somdawa, nami moni kaali, kulii-din beng tiilawa, nami moni kaa dukumnin disa kesu yoko? Dinam, ti kano-salap dinam, yaap nali asuk taldi moni dukum ayo kuluuliya kaa! Kaa kambolawa nali taldi nami moni anung uyo kuluulin dinim ke-lomdila, asuk ti nalmi K1,000 kup-ta-unsii ita-kup tal im-buuli no, aka-lom ale, ");
INSERT INTO tif_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","kulaa, almi dong dakaalin tunum iyo bokoya-lomda: Kipyo, yak ami sikil diim kawu moni kutal-fukuba kulaa kuluu-lomdip, yak tunum K10,000 kuluuba ami kola kelin a! yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nami kanum bokoli kabak-ami miit kaali, tunum ayo kanta ok tambal fuku-bamale, kamokim ami weng ayo weng san-kaa-bam ke-mokoma kaata, ami kamokim ayo ok maso ma kolaya, okok kemin dukum ayo kuluu nuu-mokoma. Aa, moni yaapkan ayo kaa-bam ke-mokomu no. Kanolin tunum ata okok mafak ke-bam ale, almi kamokim ami weng ayo kuyang saak ten-bam ke-mokoma kaali, almi kamokim ata tam-ilom ami ok ayo kukan-telaya, ami okok kemin sisol kaa maso ma kaa-mokoma disa yo. ");
INSERT INTO tif_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kalo, ok tabuulin tunum ibi mep okok kemin dinim daal-kup tibin kulaa, dabuu dabaalip tam kutamiip tem ilin abip kaptam ban-ilomda, boko-lom: Kwin, kalaaso kanimin o, kalaliya kaldang liip tale-yimbi yoko? Kal-bom dukum-kup amamak o, kala, kamokim ayo okok kemin tunum imi tiin molin imi kanum bokoyase no, kala Yesus ayo kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesus ayo bokoya-lomda: Bii-lom kawu, Dukum Ami Man Nali taba-lom God ami ensel iyo alik foko-kutal-tiiliya, nami win ayo kufup-nam-bilip, nakal kamokim king ke-lomdila, titil dukum ayo kuluu-lomdi, unang tunum alik iyo tiin molokomi. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ensel ita taba-lomdip, tawaal diim kalawaami tunum miit ma miit ma iyo alik foko kulii-tal nami diim tiiliwa, nalta afetuli sikip alep ke-lokomip o. Nali sipsip tiin molin tunum imi kanubip tap kang baan alep kalawaali sipsip tituun ili yakal baan ma fak-daa, meme ili yakal baan ma fak-daa ke-bamda afetba tap ke-bamdiya, ");
INSERT INTO tif_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","sipsip ita foko kutal aba yang nalmi sikil tiingtuplo kaldangu fik-tiibi-kup ale, yak meme ita kutal aba yang sikil awaanlo kaldang fak-daa ke-lokomi no. ");
INSERT INTO tif_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kanoyi iliwale, Kamokim king nayo, unang tunum tal nami tiingtuplo kaldang tolbip imi bokoya-lomdi kanum bokoyokomi ko: Nalmi Aatumen God tawaal dotusa kawu, God ali abip tambal ayo unang tunum tuluun-kup tabasip imi no, kala-lomda talalu kutiiyinsa. Kemin, God ali ipni fiyaap-kup duuba. Kemin, ibi tiltam suunkup bom-biliwa yo, kala-lomdi, kanum bokoyokomi. ");
INSERT INTO tif_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nami Atok ami kipni fiyaap duuba kaami miit kaali, dok kata naa kalolip: Siin kawu nali ima tinap kep-nula ilsi kawu, ipta ima ayo kutal daap-nip inasii. Aa, nali ok del tabep-nu bom-bili, kipta ok iluu kutal-daap-nip inasii. Nali fatal tunum tiliya, ipta bokop-na-lom: Ti yaap ke talap o, naka-lom nam-tam am daa-silip. ");
INSERT INTO tif_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kuno, nali ilim dinim kelila, kipta ilim kup-nip mikisii; nali dubana-bamdi mafak bom-biliya, kipta dong dakaap-nin-silip. Aa, nali sok de-namulip ilila, kawu ipta tal dong dakaap-nin weng uyo bakap-nam-biliwa, nami aket ayo yaap ma kep-na kesuu no, kala-lomdala, kaata God ayo ipni fiyaap duumin dukum ayo duu-yinba no, kalile, ");
INSERT INTO tif_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","kulaa, tituun-kup tabin tunum unang isiik nami weng bakayimbi uyo ti bokolip: Kamokim a! Nuyo utamuwa yi, Kukup tangbal kaali ma kabi kukaap-tupla, kabi itam-salap i? Nuli doku ma titamuwa yi, Kabi ima tinap tabep-tambu kala kalalupla, ima kaa ma kup-tup ina-salap i? Aa, nuli doku titamupla, kabi ok del tabep-tambu kalalupla, ok kaa iluu kup-tup ina-salap? ");
INSERT INTO tif_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kabi kalok nolin diim kawu fatal tunum o, kala talawa bokop-ta-lomdup: Ti yaap ke talap o, kala tim tiltam am daa-sulup i? Aa, nuli kaloku titamup kabi ilim dinim balap takalup, ilim kaa kup-tup miki-salap? ");
INSERT INTO tif_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nuli kalok nolin diim kawu titamup dubana-bam mafak tiinbap taka-lomdup, dong dokop-ta-sulup? Kuno nuli doku titamup kabi sok de-tamulip bom-balap takalup, tal dong dakaap-tin weng tangbal kaata bakap-tam-bulupya, kapni aket uyo yaap ma kep-ta kesuu yoko? akiwale, ");
INSERT INTO tif_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","kulaa Kamokim nasiik imi weng ayo maan tiiyila bokoya-lom: Nali ti atin fan tituun weng kaata kipni bokoyon o, kali kemin, weng san bom-ilipla! Kipni tawaal diim bom-ilsip kaa, ibi kanolin kukup tangbal kalawaata unang tunum win dinim tiltam nami lak duulin kiimi kukaayinsip. Yale, ipni kaa imi kanuyinsip kaalile, nami kukaap-nansip o, kalokomi ko. ");
INSERT INTO tif_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kanubi kulaa keyimbi-kup, fal-siki taba ti awaanlo kawu tiyang daa, unang tunum mafak imi bokoya-lom: Yi! ibi sawaayak kawu, God ayo abip ma ti suunkup as kiinin kaaso talalu-kutii bokoya-lomda: Setaan aso, ensel mafak almi ok tabolin tunum kesip iso, iyo foko im-baali din wing tiil kano suunkup kiin-bam ilin kawu ilokomip o, kalsa. Kemin ale, kaali iltipni kukup mafak kaata kanu-biliwa, God kaa daang ukuyinsa. Kemin, kep-na din suunkup as kiinin abip unin a! ");
INSERT INTO tif_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","God ali taba-lom kipni daang ukuyinsa kabak-ami miit kaali, dok kabak-ata naa. Nali ima tinap bom ilila, ibi ima ma kup-nip inamnin disa kesii. Aa, nali ok del kep-nu ilsii ayo ibi ok ma iluu kup-nip inamnin disa kesii. ");
INSERT INTO tif_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nali fatal tilin tunum kesi uyo ibi bokop-na-lom: Yi! ti yaap ke talap o, naka-lom nayo nam-tam am daalin dinim ke-silip. Aa, ilim dinim bom ilsi kaali, ibi ilim ayo ma kup-nip mikisii dinim. Nali angtiil dubana-bam mafak ilsi kawu, ibi dong dokop-nin disa ke-silip. Kuno nali sok de-namulip bom ilsi kawu, ibi taldip weng tangbal kaa bakap-nam-bilip, nami aket ayo ma tangbal kep-namu dinim kesuu no, kalalaya kemin, God ali kabak-ata ibi daang ukuyase no, yikiya, ");
INSERT INTO tif_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","kulaa, unang tunum mafak isiik bokolip: Kamokim kapyo, nuli kabi ma talap maas kep-ta-sulup disa te! Kaa kaloku nuli titamupla, Awu, kabi ima tanap tabep-tambu? aa, ok del dap-tiip-tamba? aa, fatal tilin tunum kelap? aye, yak ilim dinim aye, angtiil dubana-bamdap mafak ilsap. Aa, sok de-tamulip bom-balap kala-lomdup, nuli dong dokop-tin dinim, kuno kambop-ta-sulup yoko? kala kanum bokoliwale, ");
INSERT INTO tif_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kamokim nasiik imi weng an-anung-daa bokoya-lomdi: Nali tituun weng kaata-kup bokoyokomi. Kemin, weng san iliwa! Ibi unang tunum iwaan win dinim tiltam nami lak duulin iyo daang ukuya-lomdip dong dakaayin dinim kemsip. La, ipni kanu-bamdip imi kanuyinsip kaali, nami daang ukup-na bom ale, dong akaap-nin dinim kemsip. Kemin, uyo kaa bom buu te! yokokomi. ");
INSERT INTO tif_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kabak-ami kalan kaata, unang tunum iyo kawanita aptum kusal kii dong dakaayin dinim kemip namti, kiili fokoli din abip mafak kawu bomdip angtiil yol dukum ayo suunkup daka-mokomip. Ale, tituun-kup tabin unang tunum ita foko kulii tam God ami abip kaa tiilila, iyo ti suunkup bom-ilokomip o, kala Yesus almi daang bakaalin imi bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus almi daang bakaalin imi weng bakayinba uyo alik disa kelule, kulaa bokoya ko: ");
INSERT INTO tif_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nak-tunum kusal kipyo, utamipla yi, Am alep ma disa keluya, kuyaku Juda kayaak numi ima Pasova uyo inokomup kala kalbip. Kemin, kuluwu Dukum Ami Man Nayo, nam-baalip yak waasi imi sikil diim abamnila, nam-bak as diim daa nelip taanokomi kayi! kala kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kemin, kulaa pris o, kala awem tunum imi kamok kamok isole, Juda kayaak imi kamok kamok iso, iyo din awem tunum imi dabom Kayafas ami am dukum kaptamu tala-tala-ke-lomdiwa, ");
INSERT INTO tif_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","weng taken-una-tala-ke bile bokolip: Dok kano-somdupla kawu, Yesus ayo maaklo dap-tal fuku aalup taanak i? kala-lomdip ");
INSERT INTO tif_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","bokolip: Nulta unang tunum tala-tala-ke-bamdip ima inokomip Pasova yo kebip kaami tem kabaku aalokomup kaali, unang tunum yaapkan iyo ban boko-lomdip iyo taba nuyo mafak o, yakan-kaa-bamdip yemalip. Kemin, ilom ima ayo alik inamnip dinimnal una-tala-kelip kala, kala-somdupla kawu, aalum o, kala weng kutiilip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus nikil iyo Oliv Tikiin kaptam-ali kambolalip yak aba umbital abip ma Betani kaptam ba tilip ko. Kamasi kawu Yesus ayo Betani tunum ma abang daam Saimon ami dap-talaluse. Kemin, kaata tal Yesus nikil imi bokoya-lomda: Tiliwa, nami am kawu tiin-ilomdup ima inamnum o, kalaya, kulaa fan din ami am kaptamu tiin-bom ima iniwale, ");
INSERT INTO tif_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","unang ma taba tal tang tangbal fuunin ok ayo kulii-tal Yesus ami dabom diim kawu sing daawalu ok kaali, tuum alabasta ket dotulin kabaaku abuusip. Kemin, unang uyo moni dukum uyo kuluu-lomdu mo kutal tiibu. Kemin, kaata kanoluya, ");
INSERT INTO tif_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesus ami daang bakaalin tunum iyo utamiwa, Unang kuuli, kanubu kala kala-somdipla, aket atul tabeyu kulaa ilmi dik-daalip ko: Uli kanimin o, kalalula, tang tangbal fuunin ok kalawaali tinan-daalu disa kela ni? ");
INSERT INTO tif_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tang tangbal fuunin ok kalawaali kela-lomdu, kulii-din aptum kusal imi kuyilu ita molipya, atin ti moni dukum ayo kuluu-lom, kulii-din mafek mafek dinim ilin unang tunum imi kuyikinla yo, kalip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kanumipla, Yesus ayo utama yi, Kanolin weng bakabip kala kalba-kup, kulaali almi daang bakaalin tunum imi bokoyila: Ibi kanimin o, kalaliwa, weng mafak kaa unang bakawipla, uyo aket dukum fukunbu yoko? Kaali kukup tangbal nami kanop-nu kemin, kulaalin a! ");
INSERT INTO tif_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Unang tunum mafek mafek dinim iyo ipso suunkup ilokomip kemin, ibi yaap dong dakaayilalip. Lale, nali kipso suunkup kalawu ilokomi disa. ");
INSERT INTO tif_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Unang uli utamu yi! Yesus ayo mepso aalip saaknaya, dibii din tuum tem kawu dawaalokomip kala kalaluya, Juda kayaak numi as kuli dotu kulii-din kuwakamin kukup kuuta kuluu-somdula, nayo saaknin disa iliya, tang tangbal-kup tabin ok ayo nami dabom diim kawu sing daap-nu. ");
INSERT INTO tif_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kemin, kaali ti fan tituun-kup bokoyokomi. Ilom kaptoop ali unang tunum kiimi am bokon alik kula dik-daa kulaasu iyo tal-une-bam nami weng tangbal kukaaya-tal-une-mokomip ayo, unang kuumi kukup tangbal kala kup-nu kaami sang kaa bakayila-tal-une-bamdiwa, umi win ayo suunkup kufuwokomip kayi! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yesus ami kalaan tunum talangkal la, maakup ma ali abip Keriot kasel Judas ata din pris awem tunum imi kamok kamok imi itam ale, ");
INSERT INTO tif_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ayo dik-daaya-lomda: Kipyo, nali Yesus ayo dabaali yak kipni sikil diim abamna namti, moni kaa kanim kal ma kup-nokomip i? yakaya, ami weng bokoyila ayo weng san-ilom, tuumon dukum almi-kup 30 kiita koliwale, ");
INSERT INTO tif_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judas ayo tuumon dukum ayo kuluuba-kup, Kwin! kaa dok no-somdila, dap-fatap-daalon o, kal-bomda liip fen-tal-unema ko. ");
INSERT INTO tif_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kemin, bret fuulip faskaamin dinim inin umi am o, kala am maakup diim kawu iintang am uyo daanula, Yesus almi daang bakaalin tunum iyo tal Yesus dik-daala-lomdip: Kabi nuli kaloku ima Pasova ayo dotuliwa yo, kalbap yoko? akiwa, ");
INSERT INTO tif_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus asiik bokola: Siin kawu Jerusalam kayaak tunum ma kipni kukuyasii. Kemin, kamala kuluwu din Jerusalam kaba tunum kulaa atamip namti ayo bokola-lomdip: Kapyo, numi kukuyin tunum ami weng bokoyila kulii-tulup kaali, bokop-ta-lom: Nami nak-tunum kapyo, nami taan-laamin am ayo mepso tulu kemin, nami daang bakaalin tunum iso, nikil nuli tal kapni am kaptamu ima Pasova ayo in-bomdup fiyaap duu-bamduwa yo, kala Yesus ayo kanum bokop-tala, tulup o, aki no, kala Yesus ayo kanum bokoyilala, daang bakaalin tunum iyo im-baala din-ilomdip, ");
INSERT INTO tif_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ami weng-kup weng san-ilom ima uyo dotulip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bom bii, am tiinu atan ayo yak tem unaya, Yesus so, almi daang bakaalin tunum talangkal iso, iyo tal am kaptam tiin-bom ima ayo in-bom ale, ");
INSERT INTO tif_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yesus ayo daang bakaalin tunum imi bokoyila ko: Nami weng kalawaali ti tifaneng bokoyokomi: Nikil iltipni tunum maakup ma ata nak-tunum ayo taba-lomda, nam-fatap-daalaya nelokomip o, yakale, ");
INSERT INTO tif_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","kulaa, daang bakaalin tunum iyo Yesus ami weng bokola uyo weng san fanang alik tam baneyula aket yaapkan fukun-bam ale, aket uluum dukum ke-lomdip ma asiik dik-daala dik-daala kem-una-tala ke-bam ale, bokolip: Kamokim kapyo, nata nelile, ni disa yi? kal-bom dik-daala dik-daala ke-bam aket yaapkan fukunipla, ");
INSERT INTO tif_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus asiik bokola: Nak-tunum ma naso sikil kutaldaak falet diim kabaaku daa inamnup namti, kulaata nam-fatap-daalaya nelokomip. ");
INSERT INTO tif_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sawaayak kawu God ami Sukon Tem nami kanola taanokomi kaami sang bokosu kaali, fan kamala kulu kaami sang ayo tiltam tuluya, Dukum Ami Man Nami nelip taanokomi. La, tunum nami nam-fatap-daalokoma ali atin ti angtiil yol awak dukum kuluulokoma. Kemin, awak kuu mep man kaa kuulin dinim nosu dinam, ali angtiil yol awak dukum uyo kuluulama dinim kaali tambal o, kalaya, ");
INSERT INTO tif_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ami dap-fatap-daalon o, kalba tunum Judas ayo Yesus ami bokola-lomda: Kukuyin tunum kapyo, kabi nami sang bakap-nambap yoko? akala, Yesus asiik ami weng uyo maan tela bokola-lomda: Fan taa! Ti kaa bokolap kalapta te! aka ko. ");
INSERT INTO tif_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nikil ima in-bom ale, kulaa Yesus ayo bret maakup ma kuluuba-kup, God ami yaap ke yo, aka yak lo kutii daang bakaalin tunum ima kabaanuya-lom bokoya ko: Kalawaali nami tiil kemin, kuluu inamnin o, yakale, kuluu inamnip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Inamniwa, ata wain ok ma iluu kutal-fuku, God ami yaap ke yo, aka almi daang bakaalin tunum imi kukaayim-bam ale, bokoya ko: Nikil alik kuluwa kuluu-lomdipla inamnin a! ");
INSERT INTO tif_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kalawaali nami kiim kemin, nami nelipla nami kiim ayo sing daa-lomdu God ami kama weng umi de-kutiiluya, ibi nami kiim kaa atam, Wu faneng, God ali unang tunum yaapkan numi ban wakamin kaali, takan-tiiyase no, kalokomip. ");
INSERT INTO tif_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kemin, nali weng kusnum ma bokoyokomi. Asuk nali wain wok kala maso ma inam-nokomi daa, kela bom-bili bii din nami Atok God ami abip kawu ipso bomduwa, alik maakup wain ok alokso kaata inokomup kayi! yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nikil ima inamnip disa kelale, kulaa alik iyo God ami Sukon Tem baal maakup ma uluubip-kup, abip kela yak aba tam Oliv Tikiin unip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesus nikil iyo liip un-bom ale, Yesus ayo bokola: Am kamala kutamiip kulaayo, alik ibi kep-nalalip ukadaa unokomip. Kemin, God ami Sukon Tem sawaayak dolsip kaami sang kaali, boko-lomdu: God nalta, waasi iyo kamboyila ita taba-lomdip sipsip tiin molin tunum ami aalipla, sipsip alik iyo ukadaa une-bala tale-bala ke-lokomip kayi! kalsu namti fan kulu ipta kunolokomip. ");
INSERT INTO tif_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","La, nili kanola taani, namaalip ilana asuk tam tiiniya, Provins Galili unokomi kawu, ibi din kawu nitamin o, yakale, ");
INSERT INTO tif_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ayo weng sanba-kup, Yesus ami bokola ko: Kamokim, kapyo! Kapni daang bakaalin tunum malo ma ita kapni kanop-tip kaata, kambop-ta wakadaa unokomip. La, nali kuno kep-ta wakadaa unokomi disa. ");
INSERT INTO tif_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kulaa, Yesus asiik Pita ami bokola ko: Naktum kapyo! Nami weng kala bokop-tokomi uyo aket fukunapya! Kamala kutamiip kuyaku, awon kakaruk aalap ayo naan-tabin dinim kama ilaya, kabi nami sang ayo bokop-na-lomdap: Yi! Kaali ma atamsi dinim o, nakan-kaamsi, liip asuumano fak-daalokomap o, akale, ");
INSERT INTO tif_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita asiik weng dukum-kup bokola-lomda: Atin ti disa yo! Kapso naso yelum o, kalip kaa, nali boko-lomdi: Yi! Kaali ma atamsi dinim o, tokokomi disa yo, kalale, kuno Yesus alami daang bakaalin iyo nikil alik ti Pita ami weng bakaba weng yaan tem kulaata iso, maakup kanum bokolip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus so, almi daang bakaalin iso, iyo yak aba din langabip Getsemani abale, Yesus ayo bokoya ko: Nali mep yang kalawu beten kemi kemin, nikil ibi kulawu tiin-bom iliwa yo, kala, ");
INSERT INTO tif_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","kamboyila Yesus ayo Pita, Sabedi ami man tunum man alap Jems so, Jon so, nikil ita-kup foko-yim-bii yang abale, Kwin! Yesus ami aket tem uyo ti uluum dukum ke-lomda aket mafak kelu, nikil imi bokoyila ko: ");
INSERT INTO tif_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kipyo, nali utamila, Kulaata ti nelip taanokomi kala, kalalila, nami aket tem ayo atin ti uluum dukum kep-nu kemin, nali yang kawu God ami beten kamaali. Kemin, ipkal kuldaaku fen-bam ale, talalu kutii-bomdiwa yo, yaka-lom ");
INSERT INTO tif_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","kamboya alakis mep yang kulubale, katuun duung fakela daak tiin dabuuna God ami beten kamaan-bam bokola ko: Atok kapyo, kukup mafak uta tildang nam-mafak-daalon o, kem-talabu kaa, kabi dil molap kuno keluk o, kalap kulaali, kabi yaap titil-foko-lom kanop-nalalap. Yale, nami aket fukunin ayo, kabi nami aket fukun-bam kaata kanop-nan o, kalbi kuu daa: kemin, ti kaltapni fanang daa, kanolon o, kalbap kaata-kup kanolan o, kal-bomda kanuma ko. ");
INSERT INTO tif_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesus ayo beten kemsi kenba-kup, tildang ulaya, Tunum nikil asuumano iyo akan-fak-liibip kala kalale, yam-kafala-lomda bokoya ko: Nikil ibi akanbip yoko? Kibi titil-fak-daa kawang bom kutii ilanin tap kelalip daa; abiltap-siik akanbip o? ");
INSERT INTO tif_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Setaan ayo ipni oko-takayim-bilila, yang ban ukduulip kala yokon o, kal-bomda ibi yam-kukuba kemin, kipni aket fukunin ayo ti kukup tambal-kup nuumum o, kalbip. Lale, ipni titil ayo katip; yang kukup mafak kaa nuu-mokomip. Kemin, asuk akan-unemin disa kelalip kawong-bomdip God ami beten kamaan-bilip, dong dakaayim-bala yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kanum boko kulaa kamboyila, asuk yang olang diim yang abale, God ami beten kamaan-bam bokola: Atok kapyo, kuluu kalapni san, kabi kuno waasi iyo kamboyili ita taba-lom angtiil yol ayo kolik o, nakap kulaali, nali daa yo, kalokomi disa. Nali kapni weng bokolap uyo, ayo kalokomi no, kala beten kemsi, kulaa kelale, ");
INSERT INTO tif_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","asuk tildang ulala yi, Aptum kusal asuumano iyo asuk ti kuno tiin yak dap-tiiyu akan diisa kulaabip kala itam kamboyila ");
INSERT INTO tif_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","tildang kamasi kanola beten kebi, una tap, ti kuno God ami asuk kunolin beten kulaata-kup kema ko. ");
INSERT INTO tif_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kanumsi kulaa kela asuk tildang ula, Akanbip kala tal yam-kafala bokoya ko: Ibi asuk akan-bom fan-kaabip o? Ipni akan-unemin kulaali ti kutoop kulu diilip disa kelu kemin, tam tiin ibi atam-tamin! Kulaata nak-tunum maakup ma ata taba-lomda Dukum Ami Man Nayo nam-fatap-daa nam-baala yak tunum mafak imi sikil diim abam-nokomi namti kaa tiltam tabu kemin, ");
INSERT INTO tif_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","tiltam tolnip unum a! Nak-tunum nami nam-fatap-daalala, nelokomip ayo din atamdi yo, kalala talaba kemin, tilip una-tala dak-duulum o, kala Yesus ayo almi daang bakaalin tunum iyo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","48","Kulu Yesus ayo weng bakam-salale, almi daang bakaalin tunum talangkal, la talang kaata tala kemin, ali Judas ata. Kamasi kaa, pris awem tunum imi kamok kamok so, Juda kayaak imi kamok kamok iso, ita taba-lom tunum yaapkan iyo im-baalip wan kong so, ulin so, kuliiliple, Yesus ami dap-fatap-daalokoma tunum Judas aso tal-bom ale, Judas ayo bokoya-lomda: Kipyo! Kano ata-bom iliwa, nita din tunum kaali, kuluwaata kayi! kala dap-tal miki-lom fiil buluk tokoli namti, kulu be kemin, ipyo dap-tal fukulin o, yakale, baa kutama tala-bilip, ");
INSERT INTO tif_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas asiik Yesus almi dik-yak-dela abiltap umbital weng umonba-kup: Kukuyin tunum kaa balap o? kala yak dap-tal miki-bam fiil buluk tokola-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus ayo bokola ko: Nak-tunum, kabi kanimin ma nolon o, kala talap uyo bii-bii kemin daa yo, abiltap nolan o, akan-kaamale, kulu tunum iyo tal Yesus namti dukum-kup dap-tal-fukulip. ");
INSERT INTO tif_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesus ami daang bakaalin tunum ma ata bainat almi iim tem kawu bombe kaata, kuluu-lomda, pris awem tunum imi dabom ami ok tabola bom ilin tunum ami talang kaal malii tik-daa kulaawala tildaak abale, ");
INSERT INTO tif_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","kulaali, Yesus ayo almi daang bakaalin tunum ami bokola: Dok kanolin tunum kaata taba-lomda, bainat ta kuluu aptum kusnum iyo yelip taanip namti, imi kayaak isiik bainat ta ti yelip taanokomip kemin, dinin daa. Baan kapni bainat kaa asuk kulaak almi iim tem unak o, aka ko. ");
INSERT INTO tif_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nali nalmi Aatumen God ami dik-daali ayo abiltap almi ensel yaapkan yam iyo bokoyila, tal nayo dong dokop-nipla tangbal unon o, kali kaali, yaap kanolami. Kabi kabak utabap disa ema? ");
INSERT INTO tif_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ya, nali Atok ami dik-daalila ayo kanolokoma disa. Siin sawaayak kaptoowu God alalta almi Sukon Tem kabaku kutii boko-lomda: Nami Man kaali, waasi ita taba-lom aalipla saaknak o, kalala alta kanum bokosa. Kemin, nalmi Aatumen God ami bokola-lomdi: Atok kabi dong dokop-nawa tangbal unon o, kalokomi kabak-ali ami weng kutiisa kaa, lo kutii-lom kutoop saak telokomi namti, ami weng kutiisa uyo tiltam tituun ke-lokomu dinim o. Nali kabak dik-daalokomi disa kayi! kala Yesus ayo daang bakaalin tunum imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kaata Yesus ayo tunum tal dap-tal-fululip imi bokoyila ko: Ibi, nali din lotu am diilim kaptamu tiin-bomdila unang tunum imi suunkup kukuya-laabi kawu, tal nam-tal fukulakin kaa, kanimin o, kalalip kulaasip. La, ibi kamala kalawuuta, aptum kusal ye-bam, mafek mafek yukut dakaayin tunum ami dap-tal fuku dedu-laabip tap ke-lom kanaat bal, asukum bal, bainat aye kiita til akiip-na-lom de-namulum o, kala tiltam tilip yoko? ");
INSERT INTO tif_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mep kipni kukup kaa kano tiltam tilip kaali, yaap ma ke tiltam tilip disa. Lale, ipni kaa kanolip uyo, God ami profet weng ku-fatap-dakamin tunum kiimi weng, God ami Sukon Tem dolsip uyo kula fan tiknu ko, kala Yesus ayo tunum baa taldip sok dedulip imi kanum bokoyila ko. Kemin kulaa, Yesus alami daang bakaalin tunum iyo weng san-ilomdip, Yesus ayo kelalip abiltap wakadaa una-tala-kelip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kayafas kaali, tunum awem imi kamokim diildiil pris kemin, lo utamsip tunum iso, Juda kayaak imi kamok kamok iso, iyo tal kaami am kawu tiin-bom iliwa, tunum Yesus dap-tal fuku-lomdip iyo ililta dibiilip tal kamokim Kayafas ami be kawu daalipya, ");
INSERT INTO tif_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yesus ayo dafuku dibiilip una-biliple, Pita ayo Yesus ami mafiing tem da samaan so kaltoowu akola tap-tal tap-tal yak aba din hetpris Kayafas ami am kaami daam tem una. Lale, tam am unoma disa. Kalo abip daal uti daam tem kabaaku bom ilomdila kamok kamok iyo Yesus kaa dok nonbip i, kalon o, kala-lomda tiltam daak siip lo kawu soldiya iso, nikil tiinip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kemin, pris o, kala awem tunum imi kamok kamok so, alik imi kamok kamok iso, iyo Yesus aalum o, kala-lomdip, tunum kawanta Yesus ata-bilip, kukup mafak so ma nola atabip kala, kala-somdupya, kiita fokoluwa weng talalmin umi baan diim kawu, ibokoliwa yo, kala-lom iyo fen-bam iliwale, ");
INSERT INTO tif_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kulaa, tunum yaapkan iyo kamok kamok imi bilip kawu, tal-ilom Yesus ami sang ayo kasen-fakalip. Katale, kamok kamok iyo ma utamiwa yi, Awu, kabak-ata, mafek mafek ban dukum keba kemin, kaami kalan kaata talola aalokomup daa yo, kemipya, kulaa tunum alep ma ita tal boko-lomdip: Kipyo, ");
INSERT INTO tif_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tunum kalawaali boko-lomda: Nali ti, God ami lotu am diildiil uyo balata kutiili bii am alep keluya, am asuumano diim kula asuk delami no, kalaya nulmi talang tem alep alep iyo weng san iluwa, kanum bokose no, kala kanum bokoliple, ");
INSERT INTO tif_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","kulaa, awem tunum imi kamokim diildiil Kayafas ayo tam tola Yesus ami dik-daala ko: Mep tunum alep kalawiimi kaa, bakap-tambip uyo kanimin o, kala weng an-anung-daa bokoyin disa, kebap i? Kii kanimin o, timbip i? aka. Kata, ");
INSERT INTO tif_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesus ayo kano duluuma ilale, Kayafas ayo asuk bokola-lomda bokola: Kapyo, nali weng ma dik-daap-ton o. Kabi disa kawu bakap-nin disa suunkup ilin tunum God ami win awem kaata-kup dafo-lomdap tituun-kup maan tiip-napya utamon o, kala-somla kemin, kabi God ami uldaa tam-buula tiltam Kamokim kesap tunum Kraist o kebip kaa, kapta ema? akala ");
INSERT INTO tif_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus asiik bokola: Tifaneng kaa bokolap; alik ibi weng san iliwa, nami weng kala bokolon o. Bom ilom kaptoop ali natamipla, Dukum ami Man, Nali abiil tikiin kawu ilin titil-kup tabasa God ami sikil tiingtup diim o, kala Kamokim ami baan diim kawu tiinbi kala nikip ilom ale, kaata utamiwa yi, Abiil tikiin umi ibin umi tip diim kabaaku tiindala tala kalalip nita-mokomip o, kala kala-lom Yesus ayo kamok kamok imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kanum bokoyilaya, Kayafas tunum awem diildiil ayo weng san-ilomda Juda kayaak imi aket uluum tabemin umi kukup uyo kanumin kemin, almi ilim mikiba uyo balata kutii-lomda, tunum alik tiinbip imi bokoya-lomda: Kipya! kaami weng mafak bokola kalawaali, God ami win ku-mafak-daala, ipkal weng selip. Kemin, almi sang bokola kaa, nuli tunum ma fen-bam atamupla, kaata Yesus ami sang uyo maso ma bokoyokoma disa! ");
INSERT INTO tif_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kemin, kipni aket fukunin kaali, tunum kalawa kalok nolum o, kalbip i? yakale, isiik bokola-lomdip: Kulaaye? Atin ti kukup mafak ke-lom God ami weng mafak bokola kemin, kuno kambolap aalip saaknak o, aka-lomdip ");
INSERT INTO tif_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","kulu mok tak-binalip yak Yesus ami tiin matum diim abe-bam ale, sikil tangafap ta biwaka-balale, malo ma sikil amim tup biwaka-bala, ke-bam ");
INSERT INTO tif_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","atafiimin weng bakan-bamdip: Kabi boko-lomdap: Nali God ata nami uldaa-nam-buula tiltam Kamokim kesi tunum namti kalabii no, kala-laabap kaali, kabi alik utamsap. Kemin, kabi nitaman! Awu, kaa kanta tal neba no, kalbap namti, bokoyapla, weng selum o, kala atafiimin weng bakaalip ko. ");
INSERT INTO tif_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kanon-bilipla, Pita ayo abip uti daam tem kawu bom ilale, awem tunum imi kamokim diildiil Kayafas ami ok fukulin unang ma uyo tal Pita ami bokola-lomdu: Kapso ti Provins Galili kayaak Yesus aso tal-unen-umbip o, akuya, ");
INSERT INTO tif_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","tunum yaapkan imi tiin diim kawu, Pita ayo yawaal daa-lom bokola: I, daa! nali kupni weng bakabap kabak-ali dotu ma kaal kelin dinim bii no, wunba-kup, ");
INSERT INTO tif_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","kamboya yang abip uti daam tem umi amitom mepso kawu tola ilale, kuno ok tabuulin unang kusnum ma uyo tal Pita ayo atam kenbu-kup, uyo mep tunum malo ma tolbip imi bokoyu ko: Tunum kalawaali abip Nasaret tunum Yesus ami daang bakaalin tunum namti kulube, aka kemula, ");
INSERT INTO tif_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita ayo asuk atin ti yawaal daa-lomda: I, ti disa te! Ti tifaneng nali tunum kaali ma talalu atamsi disa yo, kala kanum bokowa ko. ");
INSERT INTO tif_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kulaa, kuno ilanin tap ke tunum kulu tolbip iyo din Pita ayo bokolip ko: Kabi nuli weng seluwa yi, Kabi Provins Galili kayaak imi weng tap bakabap kala tukup kemin, fan ti kapso Provins Galili kayaak kemin, kabi fan Yesus ami daang bakaalin tunum o, tambup te! aka kemiwa, ");
INSERT INTO tif_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita asiik weng dukum-kup bokoya-lomda: Ee, nali atin ti tunum kaa ma atamsi disa! Nali kasen-fakamin weng ma bokoyi namti, God ata taba-lom angtiil yol kup-nak o, yakan-kaam-salale, kulu awon kakaruk aalap namti naan-tabamnale, ");
INSERT INTO tif_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kulaa Pita namti weng sandaya, asuk aket fanang daala yi, Awu, Yesus ami kamasi bokop-na-lomda: Awon kakaruk aalap ayo naan-tabin dinim kama bom ilala, Pita kabi nami sang ayo bokop-na-lom: Ni kaa ma atamsi disa yo, nakan-kaabi liip asuumano fak-daalokomap o, namba kaali, faneng kaa kanoli kala aket fuku-daale, tunum kulu aso, nikil tolbip iyo kamboya tam daak uti daam tem kabaaku aba-lom dukum-kup iin-bam amama ko. ");
INSERT INTO tif_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kemin, am daan-ilom kutim kuluwu awem tunum alik imi kamok kamok sole, Juda imi kamok kamok iso, iyo weng talalulipla, kulaa Yesus ayo kuno kelup aalip taanak o, kala-lomdip ilmi soldiya iyo bokoyilipla, ");
INSERT INTO tif_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ita Yesus ayo sok de dibii din dabaalip yak Rom kasel imi kiyap Pailat ami sikil diim abamna ko. ");
INSERT INTO tif_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kanolipla, Yesus ami dap-fatap-daase tunum Judas ayo dulul eng ma weng sana yi, Yesus kaa aalum o, kalip kala, kala-lomdala, ami aket tem ayo mafak-kup kelule, aket fasuubiile, aket fanang daa mep tuumon pris awem tunum sole, Juda imi kamok kamok iso, imi konbip uyo asuk kulii-din ilmi daayon o, ");
INSERT INTO tif_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","kalala, kulii-din bokoyala ko: Tunum kaa kukup mafak so ma nolin dinim keba. Yale, kaa nalta dabaali yak ami waasi kipni sikil diim ababa kemin, kamala kuyaku, aaliwa taanokoma. Kemin, kaali ti nalta kukup mafak kenbi no, kalala, kamok kamok isiik bokolip ko: Kapni kanobap uyo kaa numi san daa; kaltapni san te! akiwa, ");
INSERT INTO tif_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas ayo imi weng ayo weng sandaya, tuumon ayo sekela kulaala daak lotu am diildiil umi abiin kabamna, kambola abiltap tam daak abip abala bina din binang an-kutiilu ko. ");
INSERT INTO tif_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pris tunum awem imi kamok kamok iyo utamipla, Tuumon ayo sekela fokola daak abiin kabamna kala, kala-lom, daak tuumon kiiyo kumup-daa-lom nikil bokolip ko: Nuli tuumon kulawiili kuluu-lomdupla, tunum aalip saak-nokoma ami kun mobup. Kemin, kaali moni mafak kela ko. Sawaayak Moses ami Lo uyo boko-lomdu: Ibi tunum aamin umi kun moni ayo kuluu God ami kola-lom lotu ami diildiil kaa tiimin daa yo, kalsu kemin, moni kalaali kuluu kalok nolokomup i? kala ");
INSERT INTO tif_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","8","weng taken-bam tawaal ma molum o, kala-lomdip tuumon ayo kulii-din tawaal kayaak kola ami tawaal uyo moliple, tawaal kayaak ata tawaal fakel-bam ok ket talala-yaaba kemin, kamosinim kaali tawaal kaptam-ami win kaali boko-lomdip: Ok ket talalmin imi tawaal o, kem-laabip. La, ilom pris tunum awem iyo mo-lomdip tunum kusnum kayak kayak imi taanip kulii-din kaptamu imakamsip. Kemin, kaptam-ata kom tem kelula, umi win ayo tuk-duu-lom: Tunum an-silip ami kun kaata, kuluu-lom tawaal mo-silip o, kemsip kemin, yak aba tal kamala kakal ti kuno bakabip o. ");
INSERT INTO tif_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Sawaayak kawu, God ami profet Jeremaya ata kaami sang uyo boko-lomda: Siin kaali, Israel malo ma ita weng talalu kutii boko-lomdip: Numi tuumon dukum ulmi-kup 30 kiita kuluu-lom tunum kaami kun ayo molokomup o, kala-lomdip molip sulula kulaa, ilom asuk tuumon kola mo-silip kaa kuluu-lomdip, ok ket talalmin tunum ami tawaal kun mobip. Kemin, siin kawu kanolin daa. Bom iliwa, God Dukum ata bokop-na-lomda: Kapta bokoyilapya iyo kanolin o, nakala, kii nasiik bokoyilila kanobip o, kala Jeremaya ata kanum bokosa kemin, Jeremaya ami boko-lomda: Siin mobip o, kalsa kaami miit uyo bom ilom molokomip kayi! kalsu. Kemin, kamala kulu fan fatapnu. ");
INSERT INTO tif_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Juda-miin imi kamok kamok iyo Yesus dap-tama tal Rom kayaak imi kiyap Pailat ami diim daaliwa, Pailat ayo Yesus ami dik-daala ko: Kabi Juda-miin imi kamokim king namti kulu-balap ema? akale, Yesus ayo Pailat ami weng ayo maan tela bokola: Nali kaa ma bokolin disa; la, kabak kaltapta kanum bokolap o, akaya, ");
INSERT INTO tif_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","kulaa, Juda-miin so, awem tunum pris so, imi kamok kamok iso, iyo kasen-foko-lom: Yi, tunum kalawaali ti fan kanola kukup mafak keba te! kalbip uyo, maan tiiyama disa. Kano tiin-kup itam keya duluuma tolna. ");
INSERT INTO tif_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kemin, Pailat ayo Yesus ami bokola-lomda: Kabi kapni win ku-mafak-dakaap-tambip kaa weng sebap e? disa? Kabi kanimin o, kalalawa imi weng kaa maan tiiyikin disa kelap, kulaa duluumbap yoko? akale, ");
INSERT INTO tif_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pailat akal utamaya, Yesus kaali, kamok kamok imi weng ayo maan tiiyin disa kela kala, kala-lomda, aket fanang alik tambanelu aket dukum fukuna ko. ");
INSERT INTO tif_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Juda-miin imi kukup ayo kanumin kemin, utamipya, Wasital tiltam tulu ayo Juda-miin imi iintang am o, kala Pasova umi ima tini-bam ina fakamin am daan tiltam tulu kala, kalalip tala-tala-kelipla, Rom kasel imi kiyap ayo bokoya-lomda: Tunum sok deduusup ayo iltipta boko-lom: Kanuminok kulaata til daa dabaalin o, kaliple bokoyi: Ata din til daali no, yakaya, ilta kulaata ko, kalum kala-silip; almi soldiya iyo din til daa-lom win tolola kelip un-un ken-umbip. ");
INSERT INTO tif_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kemin, sawaayak kawu tunum ma ami win kaali, Barabas ali kukup mafak mafak kaata nuu-balaya, win fikyak dela-yaabipla, dap-tal fuku sok de dibii tal kalabus am kaa daalip tiinsa. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","kulaali Pailat ayo utama yi, Yesus ali kukup mafak kaata ma kanolaya, kamok kamok iyo dabaalip tildak nami sikil diim ababa daa, kalba-kup ale, kuno unang tunum iyo Yesus ami weng ayo baka-balaya, weng san-ilomdip ami win ayo kufon-bamdip fiyaap duu-biliwa kemin, kaata kamok kamok kiita, almi kanuba kaata, tolola-lomdiwa kemin, dabaalip tildak nami al abamna kala utama ko. Unang tunum yaapkan iyo talaaliple, Pailat ami aket fukunin ayo, Tunum unang imi aket fukunbip kaata, Yesus ata uldaa dabuulipya, nakal soldiya imi bokoyi, taldaa dabaalip unokoma nema yo? kala-lomda, unang tunum imi bokoyila ko: Kaata yak Barabas kalawaata, tildaa dabaalip unak elile? Yak God ami uldaa-dabuula tiltam Kamokim kesa tunum Kraist ayo, akan-kaan-umbip Yesus kalawaata, tildaa dabaalip unak e? Kaa dok kata tildaa dabaalum o, kalbip? yaka ko. ");
INSERT INTO tif_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat ayo weng talalmin am kaptamu tiin-bom Yesus ami sang baka-bilip weng san-kaa-bam ilale, kalel uyo sukon ma dola kulaawalu tam utamala, kulaa bokola-lomdu: Kapyo, nali kamala kutamiip kulu lom duu-lom Yesus kaa atamdila suunin-kup kebi. Kemin, weng sanilap bokop-ton. Kaali kukup mafak so ma noba disa; ali ti tunum tangbalim kemin, kabi num-som kukup mafak so ma kolalawi! kala-lomdu dola kulaawalu tiltam tulu utama ko. ");
INSERT INTO tif_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Awem tunum imi kamok kamok sole, Juda-miin imi kamok kamok iso, iyo Pailat ami weng dik-daala uyo, weng san-ilomdip tunum alik kulu tolbip iyo moyin-bam bokolip: Ibi Pailat ami dik-daaliwa, almi soldiya imi bokoyilaya, ita din ilom Barabas sok baa tildaa dabaalip unak. Tabanala, Yesus ata aalin o, kalipla, ");
INSERT INTO tif_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","kiyap Pailat ayo asuk maso ma dik-daaya-lomda: Kipni aket fukunbip kaali, tunum alep kii dok nolin tunum ata sok baa dabaalup unak o, kalbip namti, kaata tildaa dabaalup unak eli? yakala, asuk isiik boko-lom: Barabas ata tildaa dabaalip unak o, kalbup o, akiple, ");
INSERT INTO tif_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","kulaa Pailat ayo dik-daaya: Yak kunolip kulaali, God ami ulduula tiltam Kamokim kesa tunum Kraist o, kem-yaabip Yesus ali kalok nolan o, nambip i? kalale, alik dukum-kup naan-bam bokolip ko: Dabak as diim daa-lom aalin o, kal-bom kanumip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kanumipla, Pailat ayo bokoyila ko: Aa, kabak kanimin o, kalalipla kanubip i? Kaali kalok nolin ban ma ukduuba no kalalip kaami kalan o, kala-lom aalokomup i? yaka. Katale, iyo alik weng san-ilomdip dukum-kup fuut-bam boko-lomdip: Dabak as diim daa-lom aaliwa, taanak o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kulaa, Pailat ayo utama yi, Nami weng bakayimbi uyo weng sep-nin disa kelip kutoop saak tiip-nanbip kala, kala-lomda, nali imi weng kaakal kutoop kot tiiya ke-lokomi kaali, dinan kulii-tabokomip o, kala-lomda almi okok kemin tunum ma bokola-lomda: Ok ma iluu kulip-na tal o, kala bokola ayo din ok iluu kutal-daalaya, Pailat ayo alik imi tiin diim kulu almi sikil diing-bam ale, bokoyila ko: Nami sikil kala diingni kaami miit kaali boko-lomdi: Tunum kalawaali aalin a! kalbi disa; ami taanokoma kaali, nami san disa, kaa iltipni san o, yakala, ");
INSERT INTO tif_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","alik tal tolbip iyo bokolip: Ayo, nuli utamuwa, Ami saak-nokoma kaa, nulmi mafek mafek o, kalup. Kemin, kaa kukup mafak kelup namti, God alalta nusole, numi man loop kaptoop iso, numi angtiil yol uyo kuno kuyama no, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kanu-biliwa kemin, Pailat ayo almi soldiya iyo bokoya din Barabas ata sok tildaa dabaalip unale, Yesus kaata, sok faklet ta kuluu langatal kaansi kambolale, soldiya imi bokoya ko: Ibi dabak as diim daa aaliwa, taanak o, kala kabak-ali Juda-miin imi aket fukun-bamdip: Pailat kapyo, kabak-ata kanolan o, kebip uyo Pailat ata kanoya ko. ");
INSERT INTO tif_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kemin, kiyap Pailat ami soldiya iyo Yesus ami dibii tam kiyap ami am dukum anung kaptoop ali almi sin-laamin am kemin, dap-tam daa-lomdip, soldiya alik iyo tala-tala-ke falala dap iip kabaak daa-lom ");
INSERT INTO tif_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","kasen-foko king imi ilim batbat mikin-umbip tap kela makelum o, kala-lomdip, almi ilim ayo dilduu kukan-tela-lomdip, ilimi ilim fiingim ma kuluu dildaak tinela-lomdip, ");
INSERT INTO tif_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","sok lingliing soyim kaata, ukduu-lom king imi nafalum tap ke faa-lom kutam dabom diim dildaak tinenbip-kup, tam malal ma kuluu kasen-foko kaa king imi asukum kasaa altap o, kala almi sikil tiingtup diim kuyaku amela kabi kamokim o, kala king imi kukup uta kanola-lomdip, katuun duung fakela daak tiin, tituleng bakan-bamdip: Juda kayaak imi kamokim king balap yoko? akan-kaa-bam ale, ");
INSERT INTO tif_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","mok tak-saala tal-une-bamdip le, malal ta kuyak dabom ayo dakaan-bam ke-lom ");
INSERT INTO tif_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","iyo itafiimin weng bakanbip ayo disa kelula, iyo ilim fiingim kulaak tinelip ayo dalduu kukan-tela-lomdip asuk almi ilim kaata, kuluu makela dabii tam saaklo abalup dibii din as diim kawu dabak as diim daa aalum o, kala-lom dibii unip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Waasi dinin tunum iyo abip dukum Jerusalam uyo kamboya Yesus ayo dap-tamalip un-bomdiwa utamipla, Saimon ali Provins Sairini kayaak ayo liip kulu tal taba kaa kalale, disa kawu ami aba mola-lom fotabipla, Yesus ami as tiim aalap dukum dabak daa aalokomip uyo, kolip Saimon asiik kuliila yakyak tam ");
INSERT INTO tif_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golgota muk kun o, kala kaami miit kaali, Tunum Dabom Kun tap o, kem-yaabip kawu din abale, ");
INSERT INTO tif_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kulaali, wain ok sole, marasin atul tabasu kaaso, kiiyo kulii-tal Yesus ami kuyak delup ina-lomda ami yol angtiil ayo katip so, ma keluk o, kala kolip. Lale, Yesus ayo: Da mep katip ma lutmo atam, daa yo, kala kambola ko. ");
INSERT INTO tif_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kulaali, Yesus ayo dabak as diim daabip-kup, kawu tuum katip katip saatu kiita foko-lomdip kulaalup tam aba daak aba ke-bam, kanta ata ata ke Yesus ami ilim ayo kuluula kala kalalup utamum o, kala-lomdip Yesus ami ilim namti abaanulip disa kelaya, ");
INSERT INTO tif_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","tiin-bomdip Yesus ami atafii-bam bom iliwa, ");
INSERT INTO tif_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pailat ami okok kemin tunum ma ata as kom ma kuluu-lomda, dok ami kalan kaata Yesus kaa aalip, kala-lomda kaami sang uyo kabaku dola-lomda kanum boko-lom dolna ko: Tunum kalawaali, Yesus kaa Juda kayaak imi king o, kala-lom as kom diim kabaku dola kuyak tam Yesus ami dabom mepso as matum diim kabaku kutiilale ");
INSERT INTO tif_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","kulaa, waasi dinin soldiya iyo, Yesus dabak as diim daa sil bikibip-kup, kuno asuk tunum yem-tal-une-bamdip, imi bung mafek mafek yukut dakaayin tunum alep yakal, yim-bital yim-bak as diim daa-lomdip, ma ata dap Yesus ami tiingtup lo dip-tam diibip-kup, ma ata dibii-tal aba yang awaanlo kawu dip-tam dii keya-lomdip yim-tam diilip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tunum mepso kulu tal-unebip iyo aban-den-bamdip Yesus, ami atafiimin weng uyo bakaan-bamdip: ");
INSERT INTO tif_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kapya! kabi kaltapni bon tem weng baka-bamdap: Nali lotu am diilim ayo balata kutiili bombii am alep keluya, am asuum diim uyo, asuk delokomi no, kala kaltapni tong bakamsap kemin, kabi fan God almi man alik-daap namti, kano-lom, kaltapni angtiil lak uta duulawa, as diim tam diibip ayo kela tildaak tawaal abamnan a! ke-bam atafiimin weng bakaaliwale, kuno ");
INSERT INTO tif_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","pris awem tunum imi kamok kamok so, lo utamsip tunum imi kamok kamok so, aa, Juda imi kamok iso, yakal ti tong fakaan-bamdip atafiimin weng bakaan-bam bokolip ko: ");
INSERT INTO tif_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kaa unang tunum kayak kayak imi angtiil lak uta duu imi dong dakaayin-bala, yaawa-yaabip. Lale, ali kalok kano-lomda almi angtiil lak kaata duu-lom yaap-nama dinim keba ni? Kulaa, fan Israel-miin numi kamokim king dinam, fan as diim ayo kelala tildaak tawaal diim abamnala nokol atamupla, U, fan kaali God almi man tituun uu, kalupla yo. ");
INSERT INTO tif_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kemin, akal boko-lomda: Nali God ami Man o, kem-yaaba ami aket fukunin uyo: God alalta, nayo dong dokop-na-lomda nam-buulaya, yaap ilokomi no, keba. Kemin, atam iluwa kano dong dokola namti, fan bakaba no kalum o, kala-somla ko. God ayo ti faneng dong dokola yaap-nokoma kaata utam, Awu, kaali fan God almi man alik-daap kalum o, kala atafiimin weng bakalip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kanum bakaan-biliwa kawu, kuno tam tunum yan-tal-une-bamdip imi mafek mafek yukut dakaayin tunum nikil im-diibip alep yakal ti atafiimin weng uyo Yesus ami bakaan-bam kemip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kanolip bom bii atan tal dibimnule, kulu am namti malang tini-lom am bokon alik kulu dik-daa kulaasu uyo malang tini-lom tilnong molu bom bii, am atan tal dayak abamna 3 kilok o, kala-laabip kelala, ");
INSERT INTO tif_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","malang tinilin ayo disa kelon e, kem-sulule, kuyaku Yesus namti Hibru ilmi weng dukum-kup bakan-taba toop aba boko-lom: Eli, Eli, lama sabaktani yo, kala kabak-ami miit kaa boko-lomdu: Nami God kapyo, nami God kapyo, kanimin o, kala kuno kep-nanbap yoko? kal-bomda Hibru ilmi weng kaata kuluu bakamale, ");
INSERT INTO tif_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tunum mep kulu tolbip imi tunum malo ma iyo weng san-ilom bokolip ko: Sawaayak God ami profet weng ku-fatap-daa bakayin tunum bom biisa Elaija ami naala-taba ko, kala-lomdip, ");
INSERT INTO tif_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","tunum maakup ma ata abiltap bina yang mafek mafek tiiyup kon altap kaata, kuluu kulaak wain ok atul tabin kabaak mo-lom, as daang tiila kulii-tal koli inamnak o, kala kulii-tal aba tam kukaalale, ");
INSERT INTO tif_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","tunum malii ma ita bokolip: Ka! kuno bom ilawa, atam ilup Elaija ata talda dong dokola tildaak aba ne? kalum o, kala iliwa, ");
INSERT INTO tif_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus ayo boko-lomda, Kwin kaluso kawi! kala-lomda dukum-kup asuk Aalap ami naan-daanba-kup kulu saakna ko. ");
INSERT INTO tif_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Saaknaya, lotu am diildiil kaptamu ilim aalap ma ku diiliwa tildaak God ami abiin awem uyo akiisu. La, Yesus ayo taan-laam-salale, kulu ilim aalap dukum ayo bitam mutum diim kulu, tela tikip-kup biki tala ti kulii bitaldaa matum daa-lom, malii na malii na ke-lomda kulaalaya, God ami abiin awem dukum kaptam ayo fatapna ko. Kulaa, bim aalap ma kutaltam daa am bokon kulaaso, kuu kukula saan-bam filifili-bamdu tuum dukum dukum iyo iip kuyak duula une-bulu, tale-bulu, kem tiltam abuya, ");
INSERT INTO tif_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","God ami unang tunum saaknip imbii din tuum tem bal-kaan-unsip imi kom tem imi amitom tuum kuyak katii katii kesip uyo, ulta-kup busuu kutii kuno kelula, unang tunum saaksip iyo tam tiin bom-iliple, am alep disa kela am asuum diim kawu, ");
INSERT INTO tif_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesus akal ti kuno tam tiin baalale, yakal kuno tuum tem kaptamu tiltam abalip yak aba din God ami abip Jerusalam kaptam banaaliwa, unang tunum yaapkan kulu tiinaabip iyo itafiimip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kanu-buluya, soldiya iso, soldiya 100 tiin molin tunum kamokim o, kalin so, iyo Yesus ami tiin mobip yakal utamiwa yi, Yesus ayo taan-laam-salale, bim tale-bulu, saak kukup kusnum akal alik akal alik iyo tabe-bulu kemip kala, kala-somdipla, alik iyo suunin sakbaalim dukum ke kun dinim keyula bokolip ko: U faneng, kalaali God almi man tituun o, kalip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Siin kawu, Yesus ali Provins Galili ayo kambola unala, unang yaapkan yakal kuno kelalip iso, din imi ima fuuyim-bam ale, dong dakaayin-bulup yo, kala iso, yakyak tal Jerusalam tal-silip. Kemin, unang iip maakup maakup iyo abip Makdala kayaak unang Maria ukol aa; Jems, Josep alap imi awak Maria ukol, Sebedi man alep imi awak, nikil kanolin kiita-kup. Unang yaapkan iyo yak aba yang samaan so kawu tola ata-bom-sulupla, waasi tunum kiita taba-lom Yesus kaa kalok kanolip kala kalum o, kalalip nikil din atafiimip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Awasekim Josep kalawaali, Provins Judiya kaptam-ami abip Arimatea kayaak ali win tibin dukum ale, ali Yesus almi lak duulin tunum kemin, bii am tiinale yak aba din kiyap ami am abale, ");
INSERT INTO tif_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rom kayaak imi kiyap Pailat ami atam dik-daa-lomda tal, dik-daaliya, Ayo, yaap o, kalap namti, Yesus ami as kuli kaali, ayo yo, kalapla kulii-din kuwaalon o, kalalila tili no aka dik-daalaya, Pailat ayo, kulaa yaap o, kala-lomda almi waasi dinin tunum iyo weng umuuya tal atamipla, bokoyila din Yesus ami as kuli ayo til-daalip tildaak abamnala, dabaalip yak Josep ami sikil diim abamna ko. ");
INSERT INTO tif_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Kamasi kawu Josep almi ok fukulin tunum imi bokoyilala, ita taba-lom Josep ayo ilomda saaknala, dawaalokomup almi no, kala kama tuum tem ma kalolipla bombe kemin, Josep ayo Yesus ami as kuli ayo dibii din ilomda alokso ilim namaal tambal ma kuluu de falala-lomda dibii din almi tuum tem kalola-silip kaptamu dawa-lom tuum tem kaami saal ayo tuum dukum ma taa-bi-lom talalusip. Kemin, kuuta buplun-baplun kutama tildang amitom ti saal kuyak katela unaya, ");
INSERT INTO tif_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makdala kayaak unang Maria usole, awasekan Maria ma uso, alep iyo tiin-bom tiyak daa ilipya, tuum ayo kanola liiba kala kal-bom atafiimip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yesus ayo taanale, dibii din dawaa kela tal bii silip sintam iintang am daanule, pris o, kala awem tunum imi kamok kamok so, Falosi iso, iyo yak aba din Pailat ayo atam bokolip ko: ");
INSERT INTO tif_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kamokim a! Yesus ibakamin tunum ayo saaknin disa ilomdala kawu boko-lomda: Bii nelip saak-nokomi kaali, bom bii am asuumano keliya, asuk tam tiinokomi no, kalase. Kemin, ami weng kaa bokose kabak-ali ti aket dukum fukunbup. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","numi aket fukunbup kaali, almi daang bakaalin tunum ita din tuum tem un-ilomdip, ami as kuli ayo maaklo yukut kuluu kulii-din tuum tem kusnum kawu buluubip-kup, tunum unang iyo bokoya-lomdip: Yi! atin tifan taanba. Yale, God alalta asuk dafola tam tiinba te! kalokomip ema yo? kemin, kano-lom ilom ale, almi daang bakaalin tunum iyo kasen-fokoya-lomdip Yesus kaali, tam tiin baaba no, yakan-kaa-mokomip kaata dukum-alom uta uta ke-lom ale, siin kamosinim Yesus almi kasen-foko bokoya-lomda: Nali God alta uldaa-nam-buula tiltam Kamokim kesi tunum nali kalabii no, kem-tal-unemsa uyo, kulaak banule, ke-wokomip kala, kala-somdupla kabak-ami aket dukum fukunbup o. Ami daang bakaalin tunum ita din ami as kuli ayo kuluu kuliilip unokomip. Kemin, baan kapni soldiya iyo ma fokolap din tuum tem dawaabip ayo kamala so, sabi so, uyo kutii-bam iliwa yo, kala Pailat ayo bokoliwa, ");
INSERT INTO tif_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat ayo almi waasi dinin tunum iyo ulelna yak kamok kamok imi sikil diim abamniple bokoya ko: Kibi mep soldiya kala foko kulii-unabip iyo im-tama din ababip-kup iltipta yak tuum tem saal ayo dukum-kup nek kala liilipla waasi dinin tunum kii kutiilalip ko. ");
INSERT INTO tif_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Awem tunum imi kamok kamok iyo Pailat kambola as dan ma kulii-din-ilomdip, tuum tem saal balang diim ayo taploop daa kela, kaa ti nek kalu kayi, kala-lom waasi dinin tunum iyo yam kom tem ami amitom tiile, bokoyip ko: Ti kuldaaku kutiilin o, yaka kano keya tabanip ko. ");
INSERT INTO tif_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","God ami iintang am daanbu uyo disa kelule, Sande kutim mepso atan tiltam tabon e, kem-sulule, Makdala kayaak unang Maria sole, awasekan Maria so, alep yakal yak aba din tuum tem Yesus dawaabip uyo utamum o, kalalip unip ko. ");
INSERT INTO tif_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Alep yak aba din tuum tem mepso kulu banipya, Kwin! bim aalap dukum ma tabamnala, tawaal ayo kukula-saan-balaya, God ami ensel ma abiil tikiin kawu tildaak-ilomda kom tem ami tuum kom ta kuyak mo saal liibip ayo baplun kulaala yak banu, kela tam tuum dibim diim kabaaku tiin bom ilala, ");
INSERT INTO tif_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","unang alep iyo tal uliwa, Kwin! ami tiin matum ayo mafek mafek namaal lamlaam sokan dukum ultap an-tii-lom tiin buluusi so, keba kala atam ale, kuno ami ilim kakal ti abiil matak ultap kaata mikiba kala atamip. Kata, ");
INSERT INTO tif_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","soldiya yakal ensel kaa kanola kala atam-ilomdip suunin dukum ke-lom wulwaal-kup tap-tap um-bom ale, tiin buluusi anu-fokola daak tawaal aba-lom atin tunum anu-kutiilap saaka-yaabip tap kelip ko. ");
INSERT INTO tif_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kanolipla kemin, ensel ayo unang alep imi bokoyila ko: Kiwe, kibi nami nitam suunin daa. Nali utamila, ibi Yesus dabak as diim daa aalip saakba ami fanang fen-talabip kala kalbi. Yale, ");
INSERT INTO tif_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ali kalawu bombe disa; ali tam tiinda tuum tem kaltam kelala tam bana. Ali siin kaa ipni bokoyase kaayo, Asuk tam tiinokomi no, kalase uyo kibi lukuuyimbu no? Ti ipkal tal-ilomdiwa, ami dibii tal dawaabip abiin-kup kela uyo utamiwa yi, U, ali faneng tuum tem kaltam-ali kelala tambana kaa kalin a! ");
INSERT INTO tif_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tal utamip kemin, baan bina din-ilomdip ami daang bakaalin tunum iyo bokoya-lomdip: Kaali ti faneng Yesus ali fan taanba. La, ali asuk tam tiinda tuum tem ayo kambolala tambana. Kemin, ali asiik dusiin daa Provins Galili unaya, kipyo din atamin o, kala-lom din kanum bokoyin. Weng tifan bokoyi ko, kala ensel ayo bokoyalale, ");
INSERT INTO tif_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","kulaali, unang alep iyo weng sanip kaata da suunin so, ke-bam ale, fiyaap duu-bamdip kom tem kaali, kambola abiltap-siik daak aba din Jerusalam dindip daang bakaalin tunum iyo mafek mafek tambal ami sang kaata bakaya unip ko. ");
INSERT INTO tif_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Unang alep iyo abiltap-siik binan bom ale, iyo Yesus namti liip kawu atamipla ayo bokola: Kasalep kaa silip o? yakale, alep ili king weng umuuyila-yaamin kukup kaata kano-lom tal almi diim kulu katuun duung fakela daak tiin ami yaan ayo kutal-fukulip itam ale, ");
INSERT INTO tif_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesus ayo bokoya: Kibi suunin daa yo. Baan alep bina din nami naktum kusal kii bokoyiwa, Nikil ibi din Provins Galili kawu, Yesus nayo nitamin o, kala kanum bokoyin o, kala Yesus ayo alep imi kanum bokoya unip ko. ");
INSERT INTO tif_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Unang alep iyo tuum tem kambola unan-siliple, kuno waasi dinin tunum yakal tuum tem ayo kela bina din Jerusalam aba pris o, kala awem tunum imi kamok kamok imi kanolin mafek mafek kanum tiltam tulu utamip umi sang alik uyo bokoyipla, ");
INSERT INTO tif_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","iyo weng san-ilomdip weng kulaalip din Juda-miin imi kamok kamok imi diim unula, kulaa iyo tala-tala-ke-lomdip weng ayo dotu kutii kela tam moni dukum ayo ukduu-lom soldiya imi kuya dil moyimbip-kup, bokoyip ko: ");
INSERT INTO tif_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kipyo, weng kalawaali kulii-din unang tunum imi bokoya-lom: Yi, kutamiip kawu alik nuyo akan faklii iluwa, Yesus almi daang bakaalin tunum ita tal-ilom ami as kuli ayo yukut kuluu kuliilip umbip kayi! yakan-kan tal-une-bilipla, fan o, kalik o. ");
INSERT INTO tif_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kanola Rom kayaak imi kiyap Pailat ali weng sanda kipni aket atul uyo kuya namti, nuta taba-lom weng tangbal tangbal ata dukum-kup bakalupla, utama yi, Awu, fan kaa ipta ban kebip disa kala kala-somdaya, kukup mafak so ma kuyin disa ke kamboyokoma. Kemin, aket dukum fukunin daa yo, kala kamok kamok iyo soldiya imi kanum bokoyip ko. ");
INSERT INTO tif_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Waasi dinin tunum iyo moni ayo kuluu-somdiwa, awem tunum imi kamok kamok weng kuyip uta kulii-din kanumin sang kaata-kup bakayim-biliwa, Juda kasel unang tunum iyo weng san-somdiwa, weng kulu bokolip kuluuta kuno ti kutal-fuku bakan yakyak kulii umbital kamala kula diilu ko. Weng kaali, tifaneng ko. Kem-tabasip o. ");
INSERT INTO tif_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kamosinim kawu Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Din Provins Galili kanolin amdu tikiin kawu nitamin o, yinsa. Kemin, fan almi daang bakaalin tunum kumkal iyo yakaba tam amdu tikiin ayo tam uliwa yi, ");
INSERT INTO tif_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yesus ayo bombe kala kalip. Lale, daang bakaalin tunum malo ma iyo aket fuku-daa: Naka kalawaali Yesus taanda asuk tam tiinse ata ne disa ye? kemip. Katale, asuk king imi weng umkaayin kaata, kuluu-lom katuun duung fakela daak tiinipya, ");
INSERT INTO tif_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus ayo tal imi mepso kuluba talabale bokoya: Naktum kusal a! God alta uldaa-nam-buu-lom almi titil kaata alik kup-nala, tawaal diim so, abiil tikiin so, umi mafek mafek alik uyo tiin molon o, kem-tabi. Kemin, ");
INSERT INTO tif_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ibi nami okok kemin tunum kelin o, kalalila ibi ulelni. Kemin, ibi din am bokon kala dik-daa kulaasu kaami tunum miit kusnum kusnum iyo alik nami weng kaata kulii umbilin bakayila-tal-une-biliwa, iyo tiltamdip nami daang baka-bam ale, nami lak uyo dukum-kup dakan-unip kala-somdipla, ibi Atok God so, almi man naso, almi Sinik Tambal aso, alimal maakup numi win diim kaata baka-bam oksam kaa wakayim-bam ale, ");
INSERT INTO tif_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nami weng kukuyila-tabasi uyo alik talalu kukuyim-biliwa, kulaa yakal weng sandiwa, dotu yikik-kutal-fukulin o, kala kanum bakaya. Kemin, ibi nami weng kala bokoyokomi kaluuli soko weng san iliwa, nali maas kamboyokomi disa; Nali ti ipso suunkup bom-bili bii, am mafiing diim tulule, am bokon kula dik-daa kulaasa kalawaami dinim-nokomu kutoop kuyaku dilit kalokomi no, kala Yesus ayo almi daang bakaalin tunum imi kanum bakayinsa ko. ");
INSERT INTO tif_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kalawaali ti God ami tunum Man Yesus Kraist ami weng tangbal so, kukup tangbal so, ami kanum tal-unemsa kaami sang kaata bokoyokomi kemin, weng san iliwa! ");
INSERT INTO tif_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kemin, Profet Aisaya ayo sawaayak kawu, God ami Sukon Tem Weng ma dola kutiisa kaali, boko-lomda: God ali almi Man ami bokola-lomda: Nakal tawaal diim tunum ayo uldaa-dabuulila, ata nami kalaan tunum kelala, asiik dabaali din unang tunum imi bokoya-lomda: Kamokim ali talokoma kemin, ibi kiltipni aket tem kaali, dot-kaamipla yo, kal-bomda, ");
INSERT INTO tif_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","unang tunum dinim disanang bokon kawu ayo naan-bam boko-lomda: Liip tangbal inang ma dot-kaamipla kawu, Kamokim ayo abiltap talak o, kala bokoyak, ilimi aket dot-kaamin diim kawu ti bakam-salale, kapta mulo mafiing tem unokomap o, kala God ayo almi Man ami kanum bokolase no, kala Aisaya ata dola kutiila laabula, kaa faneng tiltam talsu. Kemin, kaami sang kaata weng san iliwa! ");
INSERT INTO tif_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kaali, oksam wakayin tunum Jon Baptis ami sang kaata kemin, ali din disanang bokon kawu bom unang tunum iyo bakayin-bamda: Kipni ban kemin kaali, kela-lomdip aket fal-siki tildang oksam wokolipla, God ayo kipni ban kemin uyo takan-tiiya disa keluk o, ke-balale, ");
INSERT INTO tif_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Provins Judiya ami abip ma ma imi kayaak alik iso, ale abip diildiil Jerusalam kayaak alik iso, ili Jon ami weng kaali weng san-kaamum o kalalipla, iyo tala-tala-ke Jon ami weng ayo weng san-kaa-bamdip, ilmi aket uyo fal-kela-lomdip le, God so, unang tunum malo iso, imi tiin diim kawu, ilmi ban kemin uyo ku-fatap-daka-bam ke-bilipla, Jon ayo taba imbii daak Ok Jodan kumun tem im-baak daa oksam wakaya. ");
INSERT INTO tif_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kemin, Jon ayo (sawaayak kawu God ami profet o, kala weng tem bakayin tunum ma ali Elaija ami kukup kanu-bisa kaata kuluu-lomda) ali ilim tangbal ma mikimin dinim kemin, ami ilim mafak kaa taloop kamel o, kala-laabip umi kon kaata, bakelip mikilale, kang kau umi ipnaal uta ukduu ol tiil o kala ilet dotu kutii kakam kun kawu, kuyang diila nek molule, ima waan tangbal uyo falala le, kupluum so, as tem umi mumu wok so, kaata-kup in-bom biisa. ");
INSERT INTO tif_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kemin, Jon ayo unang tunum iyo bokoya-lomda: Kipni tunum ma talokoma no, kal-bom fenbip kaali, nita disa; kemin, kaali nasiik tilila, akal mulo kawu nami daang tem kawu talokoma. Kemin, ali ti kamok imi diilim ke-lom, ata ata ke nali kabaak bani kep-ninsa no kalalila, fatom kep-nala kemin, nali faneng ti tunum kemin, nali dok no-lom titil-foko yang ami miit tem kaali, din-ilomdi ami yaan-alom sok kaa baawalami disa. ");
INSERT INTO tif_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kemin, nali wok uta kuluu-lomdila, kipni oksam uyo wakayinbi. Kata, tunum ma talokoma ami wok-sam wakayokoma kaali ti fan wok daa; almi Sinik Tangbal dabaala tal kipni iipyak tem aket mafak fukunin kaata dotu yim-tiilala, kibi atin ti tangbal-nokomip o, kal-bom Jon ayo kanum bakayinsa ko. ");
INSERT INTO tif_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kemin, Jon ayo kanum-salale, kulaa Yesus ayo Provins Galili kaami abip Nasaret kap-din liip ayo tal atamala, Jodan kumun tem kawu, Jon ata Yesus ami oksam ayo ukolale kulaa ");
INSERT INTO tif_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","wok tem ayo sak butmo kela tiltam aba abiltap titam daala yi, Abiil tikiin uyo tem kaluulu kala kem-salale, God ami Sinik ayo awon abim altap ke-lomda taldaak Yesus ami diim ayo aba kala, kala-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","kulaa, abiil iip-iip kawu weng ma bokola ko: Kabi nalmi Man nami aket-iip kemin, nali kapni fiyaap-kup duup-ta-laabi kayi! kala ko. ");
INSERT INTO tif_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Da kem-salale, God ami Sinik ayo maak fak-daalin tap tal aba-lom Yesus ayo maaklo dabaala unbilin disanang bokon kabale, ");
INSERT INTO tif_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","saak kawu bombii am sin-laamin almi-kup 40 kelala, Setaan ayo tal-ilom Yesus ami dap-kukulila, Yesus ayo kukup mafak ma kela kala, akon o kala-lomda dap-kukum-tal-unema. Kemin, Yesus ayo siip wolti atul-kup tabasip iso bom-balala, ensel iyo taldip Yesus ayo dong dokola tiin molip o. ");
INSERT INTO tif_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kulaa, oksam wakayin tunum Jon ayo (taba King Herot ami kukup mafak sang uyo bakaan-balala, Herot ayo taba unuk tabuulin iyo fokola tal Jon ayo) sok delip bom-balale, Yesus ata tal Provins Galili kawu tal-ilomda God ami weng tangbal kaami sang ayo unang tunum iyo bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","God ami taba unang tunum imi yim-taldang almi miit tem daa tiin molokoma kaali, mep tulu kemin, ibi utamipla, God ayo numi ban ke-laabup uyo yam-kuku-mokoma no kalbip kemin, kipni ban kemin uyo kela aket fal-siki-lomdip God ami weng tangbal uyo faneng o kala, ami lak kaata duu-bomdipla yo, kala bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kemin, am ma daanale, kula Yesus ayo Galili Ok Kumun kaami balang diim kawu, liip un-bomda Saimon so, almi niing Andru aso, alep imi itama, Kiili aniing abuubi kulii-din tii-bom saanin tunum kemin, imi aniing abuumin men kaali, kulaalip daak wok tem abamnula aniing fenbip kaa, kalale, ");
INSERT INTO tif_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","kulaa, Yesus ayo din alep imi bokoya-lomda: Nak-tunum kusal kipyo, kipni okok kebip kulaali kela tilipla, naso nikil un-bom ok kusnum ma kuya-lom yim-baali din aniing abun-unbip ultap ken-tal-une-bam, unang tunum iyo afet daa yim-bii tildang God ami miit tem kawu dakamin o, yakale, ");
INSERT INTO tif_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","kulaa fan, alep iyo weng sandip, ilmi aniing abuumin men uyo abiltap-kup bisat mo kelalip, yak Yesus ami daang bakaalipla nikil unip. ");
INSERT INTO tif_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kemin, Yesus ayo alep iyo yim-bii yang mep kuluba talaala yi, Tunum alep ma iyo ilmi bot tem kaptamu ilmi aniing abuumin kaami men balata tabasu uyo bikibip kala, kalale, ayo itama. Kemin, alep kiili, Sebedi ami miining Jems sole, almi niing Jon so, ita kemin ");
INSERT INTO tif_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","abiltap-siik alep iyo bokoya-lomda: Nak-tunum kusal kipyo, kipni okok kebip uyo kela-lomdip tilipla, nikil un-bom nami ok asiik ma kuyilila kawu, okok kemin o, yakale, kulaali alep iyo weng sandip aalap Sebedi so, Sebedi almi ok tabolin tunum iso, ita bot tem kaptamu keyilalip, alap iyo din Yesus ami daang bakaalip unip ko. ");
INSERT INTO tif_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kemin, Yesus nikil iyo din Kapeneam abip kawu iliwa, God ami iintang am kawu, Yesus ayo din Juda kasel imi lotu am tam ilomda unang tunum imi kukuyin-balala, ");
INSERT INTO tif_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","iyo fanan-bam boko-lomdip: Kaami weng kukuyin kukup kaali, faneng atin ti akal kusnum kemin, God ami aket fukunin kaata dik-daa-kuluu-lomdala kemin, ali titil-kup taba-bom nuli kukuyinba. Lale, numi lo utamsip tunum yakal ti kano-lom titil-kup taba-bom nuyo kukuyamip dinim o, kemip. ");
INSERT INTO tif_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kemin, lotu am kaptam ayo tunum ma sinik mafak ta dap-mafak-daasa ayo aso kaptamu bombe kemin, kulaa sinik mafak ayo tunum kaami diim kawu bombe ayo naan-bamda ");
INSERT INTO tif_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","boko-lom: Wo, Nasaret kayaak Yesus, kapyo! Kabi nuli kanimin ma noyon o, kalalapla talap i? Kabi kano tal nuli yam-mafak-daali win dinim kelin o, kalalapla talap o? Nali titamila yi, Kabi God ami tunum uldaa-tam-buu-lom tam-baala tal-salap namti kaltapta kala tiinbi no, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","kulaa, Yesus asiik sinik mafak ayo diil saan-bam bokola-lomda: Kabi dulumnapla yo! tunum kaa kewalalap yak banan o, aka-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","kulaa sinik mafak ayo kela-lomda tunum kaayo ilela dabaala unba-talba-ke-bam dukum-kup fuutmale, kulaa kela yak banale, ");
INSERT INTO tif_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","kulaa, unang tunum alik iyo fanan-bamdip aptum kusal kusnum iyo dak-daa una-tala-ke-bam boko-lomdip: Kala dok nolin ma taltam taba ni? Kaali kukup akal alik ma kulii-tal numi kukuyila kemin, kulaa fan tunum la, ami titil uyo tiiksa kemin, sinik mafak iyo titil tabin weng ayo bokoya-lomda: Yak banin o, kalala, ami weng kaata-kup weng san-kaabip kayi! kal-bom kemip. ");
INSERT INTO tif_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kemin, Yesus ami kanola kaami sang kaali, abiltap yak Provins Galili kaami abip ma ma alik iyo yak aba tildak aba ke-lom atin dukumnu ko. ");
INSERT INTO tif_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kemin, kulaa Yesus so, Jems so, Jon sole, okok kemin tunum kusnum kusnum iso, nikil iyo lotu am uyo kela-lomdip kulaa daak aba din Saimon so, Andru so, alep imi am uyo tam uliple, ");
INSERT INTO tif_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon ami imnon uyo angtiil mamin dap-tiiwa mafak-alin kuluu-bomdu sin-laamin baan diim kabaaku akanbu kala, kala-lomdiple, Yesus ayo abiltap bokolipla, ");
INSERT INTO tif_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus ayo tal unang kuumi sikil ayo kutal-fuku umfola tam tiinule, kuyaku umi angtiil mamin uyo disa kewala-laam-salale, asuk uta taba-lomdu imi ima waan uyo talalu kutiiyu ko. ");
INSERT INTO tif_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kulaa, bom-bilip atan uyo daak tem unon e, kem-sulule, (God ami iintang am uyo disa kelu kala, kala-somdipla), abip kasel iyo unang tunum mafak-alin so, unang tunum sinik mafak ita taba yam-mafak-dakan-unsip so, alik iyo fakabi kulii Yesus ami fanang talemip. ");
INSERT INTO tif_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kemin, abip kasel unang tunum yaapkan iyo Yesus ami bombe kaptam-ami amitom ayo muup-daalip. ");
INSERT INTO tif_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kemin, Yesus ayo taba-lomda unang tunum yaapkan iyo kanolin mafak-alin umkan-unsip iyo yam-talal-yim-bamda sinik mafak iyo fotabe-bala yak bane-bamdip kemipla, Yesus ayo atamala yi, Sinik mafak iyo nitamipla, Kaali God ami uldaa-dabuula tiltam Kamokim kesa tunum namti kapta kala, nikip o, kala-lomda ayo bokoya-lomda: Ibi nami sang kaali, bakamin daa yo, yakale, sinik mafak iyo weng fakel-yila ko. ");
INSERT INTO tif_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Am ayo daan-daan kem-talan-sulule, kulaa Yesus ayo tam tiinda din tunum dinim bokon kawu, God ami naan-bamda ke-balale, ");
INSERT INTO tif_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon so, almi aptum kusal iso, nikil iyo tam tiin talaaliwa yi, Kwin! Yesus ayo keya unba kala, kalalipla, yakal iyo Yesus ami yaan tem din ");
INSERT INTO tif_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","uliwa yi, Tiinba kala, kalbip-kup, iyo Yesus ami bokola-lomdip: Kapyo! Unang tunum yaapkan iyo dong dakaayilan o, kalaliwa iyo tal-ilomdip kapni fenbip te! akiwale, ");
INSERT INTO tif_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","kulaa Yesus asiik bokoya-lomda: Nali abip malo ma alik imi weng kukaayilon o, kalalila talbi kemin, unang tunum kaa tal nami fenbip kiili, weng kulaa kukaayila-somi. Kemin, keyilaluwa, din abip kusnum kusnum isiik nami weng ayo kukaayin-bilila, nikil unum o, yaka. ");
INSERT INTO tif_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kemin, Provins Galili bokon alik kawu ayo yakyak ke-bamda ilmi lotu am kaptamu weng ayo bakayin-bamda, sinik mafak unang tunum imi diim kawu bom-bilip iyo fotabe-bamda kem-tal-unemsa ko. ");
INSERT INTO tif_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kemin, tunum angtiil mafaksa ma aptum kusal ita taba fotabamnip yang saak kawu laaba ayo Yesus ami fanang tal-ilomda kamokim king ami weng umola-laabip tap kaami kukup kaata-kup kanola fanang daa-lomda tal tilik duung fakela daak tiin Yesus ayo dukum-kup bokola-lomda: Kabi ti yaap kemin, dong dokop-non o, kalap namti, nami angtiil kula mafaksu kuluwa dotu-namulan o, aka. ");
INSERT INTO tif_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kemin, Yesus ayo tunum kaami dukum-kup olen-daala-lomda almi sikil ayo kulii yak tunum kaami angtiil diim kawu kuyak tii bokola-lomda: Aa, nali dong dokop-ton o, kalalila kemin, kulu talalu-tamuli yaap-namap, aka kem-salale, ");
INSERT INTO tif_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","tunum kaami angtiil mafak uyo maak fak-daalin tap disa kewalule, kulaa tunum ayo tambalim kelale, ");
INSERT INTO tif_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","kulaa Yesus ayo weng uyo dukum-kup bokola-lomda: Kabi din unang tunum imi diim kawu, nami dotu-tamuli kaami sang uyo bakayin daa kayi! Kuno, keyila unap ti din pris o, kala-laabip tunum awem ami diim kawu, angtiil uyo kukolap titamala, Kabi atin ti tangbalnap o, takalala, Kabi Moses ami sawaayak kawu weng dap-tiisa kaata, kutal-fuku-lomdap mafek mafek ma God ayo kola-lom, Yaap ke yo, kalapla kawu, unang tunum iyo titamiwa yi, Faneng kaa tangbalnap u, kala-lomdip asuk tam tildang daalin o, tikin o, kanum bokola-lomda dabaala una. ");
INSERT INTO tif_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lale, tunum kaali un-bomdale, Yesus ata angtiil mafak kaami dap-taleluba kaami sang uyo dap-fatap-daka-bamda, weng uyo kulaala unu-tulu-ke-balala, Yesus ayo utamala yi, Unang tunum yaapkan iyo talemip kala, kala-lomda, ayo abip malo ma imi tam itamama dinim; kela tunum dinim bokon kawu din bombe. Katale, abip kusnum kusnum alik imi unang tunum iyo Yesus ami fanang kabang-tale-bala, kaldang-tale-bala, kaptoop-tale-bala, kamet-tale-bala kemip ko. ");
INSERT INTO tif_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesus ayo kawu bomda sin-sin-bala, kulaa asuk kela yakaba din Kapeneam abip din abala, am kawu bom-balala, abip kasel iyo weng saniwa yi, Yesus ayo tal am kawu bombe kala kalbip-kup, kulaali, ");
INSERT INTO tif_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","unang tunum yaapkan iyo tal aba-lomdip am uyo abiin tem dinim kelipla, tunum maakup ayo ma dok no-lomda amitom liip ayo ma tiltam taloma dinim kelale, Yesus ayo God ami weng uyo bakayilale, ");
INSERT INTO tif_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","kulaa, tunum atalingkal ma iyo aptum ma ali angtiil dibimsa kemin, dap-tamalip tii Yesus ami fanang unum o, kala as de kuliilip tilip. ");
INSERT INTO tif_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","La, talaalipla yi, Kwin! unang tunum ita taba-lom abiin uyo alik bukubip kala, dok no-lomdup nuyo dibii-din Yesus ami miit tem mepso kawu unomup dinim o, kala-lomdipla, yakaba dibii tam am kon al kawu tamdiple, am kon uyo fakela kutii-lomdip tunum ayo almi bet diim kabaaku akan-unba. Kemin, almi abiin tiinba kulaaso, akolkup sok ta dap-dii-lomdip dabaalip unbalaak Yesus almi miit tem abamnale, ");
INSERT INTO tif_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","kulaa Yesus akal itamala yi, Tunum nikil iyo atamipla, Yesus ali ti faneng nak-tunum kulaali, dap-talalulokoma kala, kal-bomdip kanubip kala, kalba-kup tunum angtiil alik dibim-ansa ami bokola-lomda: Nak-tunum kapyo! nali kapni ban kemin kaali, alik takan-tiip-tilila, disa kelu no, aka ko. ");
INSERT INTO tif_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lo utamsip tunum malo ma iyo kaptamu tiinbip kemin, ilmi aket kaata-kup fukun-ilomdip: ");
INSERT INTO tif_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Kanimin o, kalala tunum kaali, weng kaayo kanum baka-bam God ami win ayo ku-mafak-dakaanba ni? Tawaal diim tunum ayo ma taba-lomda unang tunum imi ban wakamin uyo ma takan-tiiyama dinim kemin, God maakup ata-kup ti unang tunum imi ban kemin kaali, takan-tiiya disa kelamu no, ke-bam fanang dakamip. ");
INSERT INTO tif_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kemin, Yesus ayo almi aket fukunin kaata utamala yi, Kanolin tunum iyo kanolin aket kaata fukunbip kala, kala-lomdala, ayo bokoya-lomda: Kanimin o, kala kibi kanumin aket kaa fukunbip i? ");
INSERT INTO tif_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nali dok nolin mafek mafek kiita ma kanolila kawu, kibi abiltang nitamipla, Ali fan bakaba kala, nokokomip i? Nali tunum kalawaami bokola-lomdi: Kapni ban kemin kaali, takan-tiip-ti no, kalokomi kaa, ibi bokop-na-lomdip: Nuli kaa nulmi tiin daa atamin dinim kelup kemin, kabi ibakabap o, kalokomip. Kemin ale, nali tunum angtiil alik dibim-ansa kaami bokola-lomdi: Tam tiindap kapni abiin dotup-ta-lomdip timbi tilip kaa, kuliilap unan o, akila, tam tol-nokoma kaata, ibi atamipla, Kaa ti fan bakaba kemin, ali ti ban kemin kaakal ti takan-tiiyama kala, nokokomip. ");
INSERT INTO tif_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kemin, kipkal utamin! Nali Dukum ami Man kemin, nami titil dukum kaali, kuyilila, kipyo utamdipla, Kaayo ibakaba disa kemin, tawaal diim bombe ali ti unang tunum imi ban wakamin iyo takan-tiiyama no, nokokomip o, ke-bamdale, kulaali, ");
INSERT INTO tif_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","tunum angtiil alik dibim-ansa ami bokola-lomda: Kapyo! Kabi tolalap kaltapni abiin dalaa tim-bilip tilip uyo, kuluu kutamalap kalapni am unan o, aka-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","kulaali alik kulu tiinabip imi tiin diim kuluwu tunum kulaayo abiltap tam tolba-kup, almi bet uyo kulii tam banala, unang tunum iyo atam-ilomdip aket kufoyilu suun-bam ke-bamdip God ami tong kaata baka-bam fiyaap-kup duu-bam boko-lomdip: Nuli kanolin kukup kaayo, sawaayak kaali ma atamsup dinim o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kemin, Yesus ayo asuk tam abip ababa-kup din ok kumun ami balang diim kawu din unala, kulaa unang tunum yaapkan iyo asuk tal ami bombe kawu, tal atamiple, ayo kukuyinsi keyinba-kup kawu ");
INSERT INTO tif_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ayo yakyak un-bomda Alfius ami man Livai ata atamala, Kaali takis moni fakamin tunum kemin, ali almi am katipkan ofis o, kala-laabip kaptamu tiinba kala, kalale, kulaa Yesus ayo bokola-lomda: Nak-tunum a! kabi nami daang bakaalin tunum kelawa, naso nikil um-bomduwa, nami okok kaasiik ma kup-tiya, okok keman o, akale, kulaali tam tolba-kup yak Yesus ami daang bakaala unip. ");
INSERT INTO tif_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kemin, Yesus nikil iso, Livai aso, iyo ofis uyo kelalip din Livai ami am kawu ima im-bilipla, takis moni fakamin tunum yaapkan sole, kukup mafak kutal-fukulin unang tunum kusnum iso yaapkan iyo suunkup Yesus ami daang bakaalipla tal-banemip kiili, Yesus so, almi okok kemin tunum iso, tiin-bom ima im-biliwa kawu, ");
INSERT INTO tif_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","lo utamsip tunum malo ma ili Falosi kemin, kiili Yesus ayo atamipla yi, Yesus ayo moni fakamin tunum sole, kukup mafak fukulin unang tunum kusnum iso, ima inbip kala, kalbip-kup, kulaa Yesus almi okok kemin tunum imi dik-daaya-lomdip: Kaa kanimin o, kalala ayo tal itamala takis kaamin tunum iso, kukup mafak fukulin tunum malo iso, nikil tiin-bomdip ima dakaap kaa inbip yoko? Kaami kaa kanuba kaali mafak o, kemipya, ");
INSERT INTO tif_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus ayo weng sanba-kup, kulaali Falosi tunum imi faldak-tiimin weng ma kaata-kup bokoya-lomda: Dokta ali tal tunum mafak-umulin dinim, ili yam-talalulokoma disa; ali ti tal tunum mafak-umulin ita-kup, yam-talalulokoma no. Ultap kemin, unang tunum iyo boko-lomdip: Nuli ban kemin dinim; nuli ti tituun-kup tabin unang tunum o, kebip kiita, nali tal kiimi dong dakaayin-bilila, imi aket kaata fal-kela-lomdip God ami lak kaata duulin o, kalalila talsi disa; unang tunum kanta boko-lomdip: Nuli ti ban kemin unang tunum o, kebip kiita, nali tal dong dakaayin-bilila, imi aket uyo fal-siki-lomdip God ami lak kaata duulin o, kalalila, talsi no, ke-bam bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kemin, am ma daanale, oksam wakayin tunum Jon Baptis ami okok kemin tunum so, Falosi tunum iso, iyo inin-inin kaali, fala-bomdip beten ke-bilipla, unang tunum ma iyo tal Yesus ami dik-daala-lomdip: Jon Baptis ami okok kemin tunum so, Falosi imi okok kemin tunum iso imi kukup kaali, liip ma kaami beten kemum o, kalokomip kaali, kiimi inin-inin kaa falaa-bomdipla, dukum-kup beten ken-unbip. Lale, kapni okok kemin tunum itale, inin-inin kaali ma falaalamip dinim; beten kulaa ken-unbip. La, kanimin o kalalipla iyo inin-inin kaa falamin disa ke-laabip yoko? akipla, ");
INSERT INTO tif_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus ayo bom-bilip imi weng kaali, maan tiiya-lom almi taanokoma kaami sang uyo faldak-tiiya boko-lomda: Tunum kaa unang ma kuluulokoma ayo tunum iyo ima fuu-bam in-bom fiyaap duu-mokomip. Kanu-mokomip kaata, tunum kusnum ata yaap ma kela bokoya-lomda: Ibi fiyaap duu-bam inin daa, kemin, aket uluum tabe-bam inin kaa falamin o, yokokoma ema? Disa yo! Tunum kayaak iyo atamipla, nuso bombe kala, kalbip-kup fiyaap-kup duu-bamdip ima waan uyo inokomip. ");
INSERT INTO tif_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lale, ilom kaptoop ayo waasi iyo tal-ilomdip aptum ayo dap-tal-fuku dibii unip kala, kalbip-kup kawu, aptum kusal iyo aket uluum tabeyilula, ima waan kaali, falaalokomip o, kala Yesus ayo weng faldak-tiimin weng uyo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kemin, Yesus ayo (Juda kasel iyo itamala yi, Ilmi siin kukup kaata dukum-kup kutal-fukusip. La, nami alokso kukup kaali, kutal-fukulamup disa yo, kebip kala, kalalala), asuk ayo faldak-tiimin weng alep ma bokoya-lomda: Unang uyo yaap kewula alokso ilim daam ayo kulii-tal diingnin dinim bombu kaali, ma ukduu kulii yak siin ilim balata tabu kaami diim tii bikilokomu no? Disa te! Kanolokomu kulaali, diing-nokomu kawu, alokso ilim kaata siin ilim umi aluula, kutiilule, kulaa ilim kulin baan diim diilu koknu asuk mikilokomu kaali, aluula kutii-lom nakat mobu. Kemin, siin ilim kaata abiltap balata taba-lom tem dukum uyo kalulokomu. ");
INSERT INTO tif_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aa ti, kanumin ultap kemin, tunum ayo meme ipnaal daa siin kawu dilduu kutiila koksu kaami tem kawu alokso kaami wain ok o kala sok lap wok uyo iluula dongnu kala, kalale sok ta kuluu-lom wok bon ayo de kutiiba-kup, kulii-tal am kawu kutiila namti, ilomdula ok kaali, fusun-un-bomdula, meme ipnaal totnin kaa abiltap nakat mo-lom bikin-ilomdu ok uyo sing-tam-daa tiil bun-ilom disa ke-lokomu le, ipnaal kaali, mafak-alomdula falela tabokomu. Kemin, tunum ayo kama wain ok uyo iluulon o, kala namti, meme ipnaal alokso dulduu kutiila totnin dinim bombu kaata-kup kuluu-lomda, wain ok kaa iluu kulii-tal am tiilokoma kaata, tangbal-kup ilokomu no, kala Yesus ayo weng faldak-tiimin weng alep uyo bakayila ko. (Kemin, weng faldak-tiimin alep kaali bokoya-lomdu: Nali alokso kaami kukup uyo kulii-tal kipni siin kukup kaami anung til-daayon o, kalalila talsi disa; nali ti alokso kaami kukup kaata kulii-tilila kuuta, talalu kutal-fukulin o, kalalila kulii-talsi no, kalsu ko.) ");
INSERT INTO tif_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kulaa, God ami iintang am o, kala lotu kemin am ma daanule, Yesus so, almi okok kemin tunum iso, iyo wiit lang kaami iip-iip kaptoop liip nikil kii yakyak unip. Kemin, almi okok kemin tunum iyo un-bomdip ima tinap keyulala, wiit lap ayo dikela-lomdip inan inan una-biliwa, ");
INSERT INTO tif_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Falosi malo ma iyo Yesus ami bokola-lomdip: Kapyo! Weng san ilawa. Numi lo kaali bokoya-lomdu: Ibi God ami iintang am kaali, ima fakabi kulii-talemin dinim o, kalsu. Lale, kanimin o kalaliwa kapni okok kemin tunum ili wiit kaali, ukel-bamdip inbip yoko? Kuliili numi lo uyo ku-mafak-dakabip o, akan-kaamiple, ");
INSERT INTO tif_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus asiik bokoya-lomda: Ibi God ami Sukon Tem weng tik-tiin-umbip kaali ma dotu kaal kelin dinim kesip ema? Sawaayak Devit asole, almi ap-tunum iso, nikil iyo ima tinap keyilala bomdipla, Devit ali kabak kanimin ma nosa ni? ");
INSERT INTO tif_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Lotu kaami lo kaali boko-lomdu: Unang tunum ibi pris o kala tunum awem imi bret fuu kulii-din God ami kolum o, kala-lomdip kulii tam God ami am kaptamu kutam tiin-unbip kaali, inin dinim. Kaa awem kemin ti, tunum awem ita-kup inin o, kalsu. Lale, Abayata ami tiltam tunum awem imi kamokim diilim o kala, hetpris ke-bom balala, kulaali Devit ayo God ami am kaptamu din-ilomda tunum awem ami ima awem kaami sang kaata, dik-daalala tunum awem ayo olen-daala-lomda ima awem ayo kolala, Devit ayo anung fuk-duu inaba-kup anung ma kaata kuluu-lom almi waasi dinin tunum imi kuyalala inasip. Kemin, nikil kuliili lo kaa lo kutiisip. Kata, ibi boko-lomdip: Kaali kukup mafak kanosip o, ken-umbip dinim kayi! Kemin, kanimin o kalaliwa nami okok kemin tunum iyo ima tinap-tabeyu kanu-bilipla, ibi bokoya-lomdip: Kaali kukup mafak kanubip o, yakan-kaabip i? ");
INSERT INTO tif_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sawaayak kawu God ami unang tunum dotu-yim-tiisa kaali ti almi iintang am kaami aket kaata-kup fukun-bomdala, talalu-yim-tiisa dinim kemin, God ami aket fukunin kaali, iintang am kaata taba unang tunum imi dong dakaayuk o, kalalala, almi iintang am kaali, dotu kutiiyinsa. ");
INSERT INTO tif_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kemin, Dukum Ami Man Nayo, mafek mafek alik kaami tiin molin ale, God ami iintang am kiimi tiin molin tunum namti kala bombi. Kemin, nali ti yaap unang tunum iyo bakayim-bamdi: God ami iintang am diim kulawu ibi kaa kanumin o, kalomi kaali, ili ti nolamip te! Yesus ayo Falosi imi kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kulaa, Yesus ayo asuk din Juda kasel imi lotu am ma tam una kaali, tunum ma sikil malii famsa ayo kawu bombe. ");
INSERT INTO tif_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kemin, Falosi tunum ili kaptam bom-bilip iyo aket fukun-bamdip: Yesus ayo talalu atafii-bam ilupla, numi lo kaali, lo-lomda God ami iintang am daanu kaami diim kawu tunum kaayo, dap-talalula kala kalup namti, dibii-din weng talalmin baan diim kawu daa-lom dap-fatap daalum o, kemip. ");
INSERT INTO tif_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kemin, Yesus ayo tunum sikil malii famsa ami bokola-lomda: Kabi tam tola tal iip dikis kaldaak tolnan o, aka-lom ");
INSERT INTO tif_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesus ayo Falosi imi dik-daaya-lomda: Numi lo kaali boko-lom: Kabi God ami iintang am daanu kaali, unang tunum iyo dong dakaayan o, kalsu ne, yam-mafak-dakaman o, kalsu ne? Aa, boko-lomdu: Kabi unang tunum mafak-alin imi yam-talal-balapla, yaawa-laamin o, kalsu nelile, kuno kamboyawa taan-laamin o, kalsu yoko? ke-bam bakayin-balale, iyo weng dulumnip. ");
INSERT INTO tif_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kemin, Yesus ayo kawu tola-bom unang tunum alik iyo itafiin-tal-une-bam talaala yi, Kuliili God ami weng kaali, weng san-namup dinim o, kalbip kala, kalale, kulaa Yesus ami aket uyo ti mafak-ala-lom aket atul dap-tela kelula, Yesus ayo tunum sikil malii famsa kaami bokola-lomda: Kapni sikil kaa ifilan a! aka-kem-salale, tunum ayo almi sikil ayo ifilale, tangbal ma kelule, ");
INSERT INTO tif_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","kulaa, Falosi iyo abiltap din King Herot ami tunum iso, nikil weng taken-bamdip, Yesus kaali dok no-lomdupla, ayo aalup taanak o, kal-bom takenip ko. ");
INSERT INTO tif_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lale, Yesus so, almi okok kemin tunum iso, nikil iyo keyilalip yakaba toop Galili Ok Kumun unipla, kulaa Provins Galili kaptam-ami unang tunum yaapkan iyo Yesus ami daang bakaalipla, kulaa Provins Judiya kasel so, ");
INSERT INTO tif_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalam kasel so, Provins Idumea kasel so, yak Jodan wok malii kasel so, abip Taya so, abip Saidon kayaak so imi mepso kulu ilin unang tunum yaapkan iyo Yesus ami kukup alik kaa kanuba kaami sang kaata weng sandip dak-daa kulii ami fanang tilip ale, ");
INSERT INTO tif_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","kulaa, tal atamipla, unang tunum yaapkan iyo yam-talal-bala unang tunum mafak-alin fuku-laabip iyo sikil kulii yak melelupla, nuyo yam-talalulak o, kala-lomdipla, tala-tala-ke-lomdip tal buku kulaalipla, Yesus ayo itama yi, Unang tunum mafak-alin kuluusip ita taba nim-bak molokomip kala, kalalala, kulaa almi okok kemin tunum imi bokoya-lomda: Kipyo! Din bot ma fen fen kulii-tal mepso kulu ma kutal tiilipla yo, kala ko. ");
INSERT INTO tif_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kemin, sinik mafak mafak-miin iyo Yesus ami atamip kaali, kamok kamok imi weng umkaayin kaami kukup kaata-kup kuluu-lomdipla, ilmi tilik duung uyo fakela daak tiin-ilom Yesus ami miit tem kuluwu dabuuna-lom wol-bamdip bokola-lom: Kabi ti God ami Man o, akipla kulaali, ");
INSERT INTO tif_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesus ayo dukum-kup bokoya-lomda: Kipyo! Kaali God ami Man o, kal-bomdip nam-fatap-dakamin disa yo, kalba-kup, kulaa sinik mafak mafak-miin iyo fotabe-balala yak banemip ko. ");
INSERT INTO tif_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Kemin, Yesus ayo yak aba tam amdu tikiin ma tam una, kaali tunum talangkal ma ita, ulela-lomdala, kiita naan-daaya unipla bokoya-lomda: Kibi nami kalaan tunum kelip kemin, ibi naso ilup kaa, kipta ulelnila, God ami weng tambal kaata unang tunum iyo bakayin-bamdiple, ");
INSERT INTO tif_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","titil kuyilila kaata, kuluu sinik mafak taba unang tunum imi yam-mafak-dakan-unsip iyo fotabe-bam kemin o, kala-lomda ulelna. ");
INSERT INTO tif_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tunum talangkal kiimi win kiili, kala bom-bilip: Saimon ami win kusnum kaali Yesus ata Pita yo, anba akal, ");
INSERT INTO tif_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ale, Sebedi ami miining Jems so, almi niing Jon so, alap imi win kusnum kaali, Yesus ata bokoya-lom: Boaneges o kala taman fakabu ultap o, yika alap yakal, ");
INSERT INTO tif_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ale, Andru akal, Filip akal, Batolomyu akal, Matyu akal, Tomas akal, ale, asekim Jems kaali, Alfius ami man kemin akal, Tadius akal, asekim Saimon ali Rom kayaak imi itam fananin tunum akal, ");
INSERT INTO tif_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ale Yesus almi dap-fatap-daala aalokomip tunum Keriot kayaak Judas akal kela, nikil kiita ulelna ko. ");
INSERT INTO tif_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kemin, Yesus nikil iyo tam am unipla, unang tunum yaapkan iyo tal falala yim-tiiliwa, nikil iyo dok no-somdiwa ima kaali, inam-namip dinim keliwale ");
INSERT INTO tif_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","kulaa, Yesus almi ap-tunum kusal iyo, kaami sang uyo weng san boko-lomdip: Ali abat-alom tiinsa kemin, kulaa din Yesus ayo ulduu dibii tulum o, kala-lomdipla tilip. ");
INSERT INTO tif_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kemin, lotu kaal ke-laamin tunum abip diil Jerusalam kaa liip tal-bom-bilip iyo boko-lomdip: Sinik mafak imi kamokim Belsebul o, kala Setaan ayo Yesus ami diim kawu bomdala, ata dong dakaan-balala, kaami unang tunum sinik mafak ta yim-buusu ata fotabe-bala kemin, yak banebip o, iyo kemip. ");
INSERT INTO tif_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kemin, Yesus ayo unang tunum tal ami liip bolip iyo weng umuuya tal almi mepso tiliple, weng faldak kulu tii taldak kulu tii ke-bam bokoya-lomda: Setaan ayo dok kano-somda sinik mafak kusnum almi okok kemin iyo fotabam-nala yak banoma dinim. ");
INSERT INTO tif_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Abip maakup kaali, biki-kutii miit alep ke-lomdip ilmi waasi dinip namti, kiimi titil-foko tangbal-kup laabip kaali, kulaata imi titil namti disa ke-lokomu. ");
INSERT INTO tif_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kanolin kemin, unang tunum am maakup laabip iyo suunkup weng aal diki-bam waasi dinin-kup kemip namti, ili tangbal-kup ma ilokomip dinim; kemin, yakal ti biki-kutii waasi kela una-tala-ke-bam kanu-mokomip. ");
INSERT INTO tif_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kanolin alaltap, Setaan so, almi sinik mafak iso, alimal yakal waasi kewala una-tala-ke biki-kutii, miit alep ke-lomdip dinip namti, alimal kuliili, titil-fak-daa-lomdip tangbal-kup ma laabip dinim; ale, kulaa imi titil kaali, disa keyilon o, kebu. ");
INSERT INTO tif_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Dok nolin tunum ata taba kun soyim tunum ami am undala ami bung mafek mafek uyo duk-duulon i, kala namti, yukut inipyaap ayo kamasi kawu tunum titil soyim ayo sok de-dap-tiile, kaal dinim ke kawu tam ilomda ami mafek mafek uyo duk-duulokoma no, kala Yesus ayo kanum bokola. ");
INSERT INTO tif_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kemin, nali weng kalawaali, tituun weng kaata bakayinbi kemin, weng san iliwa! Tunum kaa kanta kukup mafak ke-bamda, weng mafak baka-bam ken-um-bala ami aket fanang dakamin uyo fal-siki-lom ami kukup mafak keba uyo kulaala namti, God ayo ami kukup mafak kaa kanum-yaaba uyo tak-daa-lom kukan-telokoma. Kemin ale, ");
INSERT INTO tif_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","tunum kanta God ami Sinik Tambal ami sang bokola-lomda: Belsebul sinik mafak imi kamokim ata Yesus ayo dong dakaanba no, kalokoma kaata, God ami Sinik Tambal ami win kaa ku-mafak-daawala kala-somdaya, God ayo ami ban uyo tik-daawala yak banokomu dinim. Suunkup ilokomu. ");
INSERT INTO tif_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kemin, kaali dok ami miit kaata daa kemin, kiili boko-lomdip: Kaali sinik mafak ayo ami diim kawu bombe no, kalip kaami sang kaata, Yesus asiik weng maan tiiya-lom kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kulaa, Yesus ami awak so, nakal-fakal nikil iso, iyo tal-ilomdip abip kaptamu tola-lom weng kulaalip am kaptam unula, iyo boko-lom: Numi fanang talan o, kemipla, ");
INSERT INTO tif_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","unang tunum yaapkan iyo tiin-bom bii Yesus ayo falala dabak mobip kemin, bokola-lomdip: Nak-tunum kapyo! Kapni kawak so, nakal iso, aptil iyo taldip kapni weng ma bokop-tum o, kalalip tal abip kaptamu tolbip o, akiple, ");
INSERT INTO tif_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","kulaa Yesus asiik unang tunum imi dik-daaya-lomda bokola: Kii kanta nami akamen so, nami nakal-fakal so ni? yinba-kup, ");
INSERT INTO tif_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","tiinbip iyo itafiin-tal-une-bam ayo bokoya-lomda: Kalawiita nami akamen so, nami nakal so kemin, ");
INSERT INTO tif_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","unang tunum iyo kawanata God ami boko-lomda: Kaata kanumin o! keba kaata-kup kutal-fukulip namti, ita nami niik-kusal, nami nakal-kusal ale, nami akamen aptil iltap namti kaa bom-bilip ko, yaka ko. ");
INSERT INTO tif_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kemin, Yesus ali yang aba toop Ok Galili balang diim kawu unang tunum iyo kukuyin-bomda utama yi, Unang tunum yaapkan iyo tala-tala-ke-lomdip falala nam-bak molip kala, kalba-kup, kulaa bot ma ok daang diim kawu bombu kuumi tem kaptamu tiinba-kup, unang tunum yaapkan itale, tildak ok daang diim kawu tolnipla, ");
INSERT INTO tif_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","weng yaapkan kaali, faldak-kulu-tii taldak-kulu-tii-ke-bam kukuyin-bam bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ibi weng san iliwa! Kulaa tunum ma ayo wiit o kala-laabip kaami san kaali, kulii din langabip kawu sekelmon o kalala, una kemin, ");
INSERT INTO tif_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","san kaali, kulii-din sekela tal-une-balale, san malo ma kiili, daak langabip kaami liip fatap diim kulu abamniple, awon-miin ita tal inamnip. ");
INSERT INTO tif_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ale, langabip kaami tawaal anung kaali, tuum yaapkan kiita-kup kelula, tawaal kaata katip sakap kemin, san malo ma kiili, daak kanolin tawaal kaami diim abamnip. Lale, tuum kaami tip diim kaali, tawaal katip kemin, abiltap-kup bikin-tabamnipla, ");
INSERT INTO tif_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","timtim kaali, dukum-kup daak tawaal bikilin dinim kemin, atan mamin ta wiit san kii, fuula kiin-ilom datnip. ");
INSERT INTO tif_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ale, san malo ma kiili, daak al mafak tem kiimi iipyak tem abamnipla, balaasaal mafak uta uta kelu, wiit iyo dutuluwa-lom mafaknip kemin, ili dok no-somdipla tangbal-kup abuumamip dinim kelip. ");
INSERT INTO tif_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ale, san malo ma ita, sakela daak tawaal tambal diim aba tambal-kup tiltam aba-lomdip abuu-bilip kaami asal maakup asal maakup kaami diim kaali, 30 abuu-biliple, malo ma ita 60 abuu-biliple, malo ma ita 100 abuu-bilip kelip. ");
INSERT INTO tif_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kemin, ibi abat disa; ipkal talang tem tangbal kemin, mep weng kala bokoyili uyo, talalu weng san-ilomdip, atamin a! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kulaa ilana, Yesus alakis kelala, almi daang bakaalin tunum talangkal sole, tunum malo ma Yesus aso maakup tiinbip iso, iyo taba-lomdip weng miit weng malo ma kaami sang kaata ami dik-daalipla, ");
INSERT INTO tif_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesus asiik bokoya-lomda: Siin kaali, God ayo unang tunum iyo tam almi miit tem unipla, ayo tiin molokoma kaami sang kaali, alik ma bakayinsa dinim; anung katip kaata-kup kemin, kamala kulaayo, God akal kipni aket tem kaali, bam-daayilala, kipkal utamipla yi, Yesus ami faldak-tiimin weng kaa bakayinba kaami miit kaali, God ami miit tem unupla, tiin molokoma kaami sang o kala atabip. Katale, unang tunum God ami lak ma duulin dinim kesip iyo nali taba-lom faldak-tiimin weng kaata-kup bakaya-laabi. ");
INSERT INTO tif_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kata, unang tunum kanta God ami lak ma duulin dinim kesip iyo ti nami okok kemin kaami dot-kaabi kaali, ilmi tiin kaata talaa utam-laabip. Lale, ilmi aket tem kaali ma bam-daa-yinsu dinim; ale ilmi talang tem alep kiili, nami weng kaa weng san-laabip. La, ili utamipla, Weng kaami miit kaali, kalabu no, kalalipla kiiyo, aket fal-sikilipla, God ayo imi ban kemin takan-tiiyalala, disa kelamu dinim kelip kala, kala-somdila, kulaa faldak-tiimin weng kaata-kup, kanolin unang tunum kiimi bakayin-kup ken-unbi no, kema ko. ");
INSERT INTO tif_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kemin, Yesus ayo asuk bokoya-lomda: Kibi nami faldak wiit san kaami diim tii bokoyili kaami miit kaali, atamin dinim kelip o? Kemin, atamin disa kelip kulaa, ibi dok no-somdip faldak-tiimin weng kusnum alik kiimi miit kaali, ata-mokomip i? Kemin, dotu weng san iliwa, bokoyon. ");
INSERT INTO tif_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wiit san dikimin tunum kaali, God ami weng bakayin tunum ata kemin, ");
INSERT INTO tif_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tunum malo ma iyo wiit san sekela fokolip daak liip fatap diim aba-laabu kanolin ultap kemin, iyo tildang God ami miit tem talemin kaami sang kaali, weng sanokomip. Lale, ili ma dotu utamin dinim kem-laabip. Kemin, Setaan ayo awon altap ke-lom abiltap tal-ilomda God ami weng imi aket tem kabak bombu kaali, yak kuluu-yilala, unang tunum iyo weng kaa lukuuyilokomu. ");
INSERT INTO tif_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ale, unang tunum malo ma iyo tunum ami wiit san sekela fokola daak tuum yaapkan tem kiimi diim aba-laabip kaaltap kemin, kiili God ami weng kaali, weng sandip, weng kaa abiltap, Faneng o, kal-bom fiyaap duu-mokomip. Lale, ");
INSERT INTO tif_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","weng kaali dotu kuyak ilmi aket tem daalin dinim kesipla; da luuknin tap ke mafek mafek mafak uyo tal kiimi diim abam-nokomu aye, tunum kusnum ita taba God ami weng kaami kalan kaata, kiiyo bon diiyin-bamdip abiltap kela yang banokomip. ");
INSERT INTO tif_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kulaa, unang tunum malo ma iyo tunum ami wiit san sekelna daak balaasaal mafak kiimi iipyak tem abebip ultap kemin, kanolin kiiyo, God ami weng kaali, weng sanokomip. ");
INSERT INTO tif_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Lale, tawaal diim kaami mafek mafek kiimi uluum kiita aket dukum-kup fukun-ilom aye, moni faka-bam fiyaap duumin aye, mafek mafek kulaali nalmi alik kuluulon o, kala aket-kup dakat ke-laamin kaata sakbaalim dukum kelula, God ami weng kaami aket kaata kabaak banu ke-lokomu. Kemin, wiit kaami tiil dinim ol-kup ke-laabu ulultap ke-lomdipla, God ami weng kaali, dukum-kup titil-fak-daa fukulokomip disa. ");
INSERT INTO tif_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kemin ale, unang tunum iip maakup maakup ita tunum ami wiit san sekela kulaala daak tawaal tambal diim abebu ulultap kemin, iyo God ami weng uyo weng sandip, Faneng o, kala suunkup kutal-fuku kanu-mokomip kaali, malo ma iyo wiit kabak-ami 30 abuu-laabu ultap kelale, malo ma iyo 60 abuu-laabu ultap kelale, malo ma ita 100 abuu-laabu ulultap ke-bala ke-lokomip o, kala Yesus ayo faldak-tiimin weng kaami miit kaali, kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kemin, Yesus ayo bokoya-lomda: Nuli ilaam kaali, iilfo kulii daak baket tem kabaaku kuwaalokomup dinim; ale iilfo kulii daak bet tawap tem kabaaku kuwaalokomup dinim; (kemin, iilfo kulii tiltam ulmi baan diim kawu tiilupla, am uyo falala-kala-bulula, unang tunum am kaptam bom-bilip iyo mafek mafek kiili, tangbal-kup ita-mokomip). ");
INSERT INTO tif_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kemin, bombii am mafiing am daanokomu kulaa, nami mafek mafek sang so, weng miit so, iyo maaklo kuwaa-bomdi faldak-tiimin weng kaata-kup bakaya-tabasi kaali, God akal kulii tam ku-fatap-daalala, unang tunum alik iyo ata-mokomip. ");
INSERT INTO tif_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kemin, kibi ti abat disa; kibi ti talang tem tangbal kemin, weng kaa bokoyili kaali, talalu weng sandip, dotu kuluulin o, kal-bomda bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kemin, Yesus ayo weng ma kaali bokoya-lomda: Weng kaali, kipni bokoyokomi kaa, talalu weng san iliwa! Kapni kaptum kusal iyo dok nolin kukup ma kukuya-laabap namti, God akal ti kanolin kukup kaata-kup kukup-ta-somdale, aa anung kaali maso ma ifiiya ke-lokoma. Kemin, kaptum kusal iyo kukup mafak kaali, kukaayin dinim. ");
INSERT INTO tif_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kemin ale, tunum kanta ma nami weng kaali, weng san bam-daalokoma namti, kaali God ata dong dakaan-balala, kaal ke yakyak kem-unokoma. Kemin ale, tunum kanta nami weng kaali, weng sanin daa ke-lomda, Nali utamsi no, kala namti, kaami weng katip ma kaa utamsa kaali, abiltap lokolokomu no, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kemin, Yesus ayo asuk bokoya-lomda: Unang tunum kanta tiltam God ami miit tem tilip tiin molokoma kaali, tunum mafek mafek san ultiila taba-laabu ultap kemin, ");
INSERT INTO tif_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ayo ultii kela din bom kutamiip kaata, akan-une-bam ale, am daanokoma kaata, okok ken-tal-une-bam ke-balala, mafek mafek san kiili ukol bikin-taba dukum-alaabu. Lale, ayo utamala, Mafek mafek san kaali, dok no-lom bikin-tabokomu ma? kala-laaba dinim kemin, (ultap kanolin ibi utamipla, Unang tunum iyo dok no-somdip tiltam kusnum ke-lomdipla, God ami miit tem kaali tam unokomip o, kemikin dinim). ");
INSERT INTO tif_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kemin, mafek mafek san kaali, tawaal tem kabaaku ultiilip bombii, bikin-taba-lomdula, tiltam abuu-laabu kemin, kamosinim kaali, kon asiik tiltam bam-daa-lomdu kulaali tes falaa-lomdula kawu, tiil-nokomu. ");
INSERT INTO tif_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kemin, utamapla, Yakaanu kaali, ulmi dakamin am uyo kulu tiltam tulu kala, kalokoma kaali, abiltap din dakabi kulii-talokoma no, kal-bomda Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kemin, Yesus ayo asuk boko-lomda: Nali unang tunum tildang God ami miit tem tilipla, tiin molokoma kaali, faldak dok ami diim tii-lomdi kaami miit kaali, dong dokoyilila ibi ata-mokomip ma? ");
INSERT INTO tif_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kaali, unang tunum God ami miit tem bom-bilip iyo mastat kaami san ililtap kemin, tawaal kala dik-daa kulaasu kaami mafek mafek kiimi san malo ma kaali, katip sakap. Lale, mastat san dikilokomap kaata, fan atin ti lap katip sakap. ");
INSERT INTO tif_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lale, tunum ma ata kulii-din dikila, kaami taba-lom tiltam sakbaalim dukum ke-lokoma kaali, umi tang uyo sakbaalim dukum ke-lomdu tiltam as ulultap kelula, awon iyo tiltam as kaami tang akiip tem kaptamu imi iim kaali dina-mokomip o, kala Yesus ayo kanum bokoya ko. (Kemin, faldak-tiimin weng kaami miit kaali, boko-lom: Mastat kaami san ultap kanolin kaali, God ami unang tunum iyo kamala kulaayo, alep-kup kebip. Lale, am ma daanokomu kaali, ti tiltam tiltam ke-lom yaapkan ke-lokomip o, kalsu ko.) ");
INSERT INTO tif_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kemin, Yesus ayo utamala yi, Dok nolin kaami faldak-tiimin weng kaata, unang tunum iyo ti uta-mokomip o, kala-lomdala, kaata-kup yaapkan iyo bakayin-bam, God almi kukup kaami sang uyo faldak kawu tii-lomdala, bakaya-laaba. ");
INSERT INTO tif_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kemin, faldak-tiimin weng kaali, kela-lomda, tituun weng kaata kuluu-lomda unang tunum kiili, bakaya-laaba disa; almi okok kemin tunum kiita-kup Yesus aso bom-bilipla, faldak-tiimin weng alik kiimi miit kaali, tituun-kup ku-fatap-daa bokoya-laaba ko. ");
INSERT INTO tif_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kemin, am kula daanokoma kulaata, atan uyo talaba daayak tem unule, almi daang bakaalin tunum iyo bokoya-lomda: Tilipla, nikil kulawa kela bot tem liip yak ok kumun dukum kaami malii kaptam unum o, yakale, ");
INSERT INTO tif_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","kulaa fan nikil iyo unang tunum yaapkan kawu bom-bilip iyo keyilalip, ilmi bot tem tiinip kemin, tam tiinbip-kup, dibiilip uniple, unang tunum malo ma iyo bot kusnum ma kaptamu iso unip. ");
INSERT INTO tif_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kulaa, umba-biliple, inim sakbaalim dukum ma tiltam tulula, ok uyo fola kulaala tiltam bot tem ayo tale-bamdule, kulaa, bot uyo ok ta taba-lom tiltam dongnon o, kalbu. ");
INSERT INTO tif_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lale, Yesus ayo bot tem umi ol duuk tem kaptoowu bomda ami dabom kaayo, kulii yak dabom-fap diim daa-lomda akan-unba. Kemin, almi okok kemin tunum iyo met dafo-lom bokola-lomdip: Numi kukuyin tunum kapyo! Mepso wok ta yelu taanum o, kalbup kalaali, kabi numi aket kaali, fukunbap elile daa? kemiple, ");
INSERT INTO tif_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus ayo fan, tiin baaba-kup, tam inim kaayo dil mo-lomda bokola dinimnale, kulaa ok ami bokola-lomda: Kulaata, bilili-kalalap dulumnan o! akalala, atin duluma-lomda dinimnu kelule, ");
INSERT INTO tif_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","almi okok kemin tunum imi bokoya-lomda: Ibi kanimin o, kala-lomdip ok kaami atul kaali, suunbip i? Kibi nitamipla, Kamokim kaa nuso bombe kaali, suunin disa yo, kebip e disa? kemale, ");
INSERT INTO tif_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","nikil iyo kwin! suunbi boko una-tala-ke-bamdip, Kalawaali dok nolin tunum ata taba-lomdala, weng kaata-kup bakam-salale, inim so, ok so kiili, ami weng kaata-kup weng san-ilomdiwa disa kelip i? kemip ko. ");
INSERT INTO tif_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kemin, Yesus so, almi daang bakaalin tunum iso, iyo bot tem liip umbiyak ok kumun sakbaalim dukum kaami malii Gerasa kasel imi bokon yakdiple, ");
INSERT INTO tif_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus ayo bot tem kaali, kela daak tawaal abamnale, tunum ma sinik mafak ata dap-mafak-daasa ayo tal Yesus ami atama kemin, tunum kaali kom tem liip tiltam abala tala. ");
INSERT INTO tif_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kemin, ali suunkup kom tem kawu laaba kemin, tunum iyo dok ata ma titil-foko-lomda dap-tal-fukulama dinim. ");
INSERT INTO tif_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kemin, aptum kusal iyo kela-sulupla, ayo yemama no, kala-lomdipla, suunkup ami yaan so, ami sikil so, kiili sen ta kuluu-lom dinabii kutelipla, sen kaayo, ukela-ukela-ken-umba kemin, tunum dok ata ma taang-kala titil-foko-lomda, tunum kaayo, dap-tal-fukulama dinim ken-umbip. ");
INSERT INTO tif_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kemin, suunkup kutamiip so, taap so, kawu amdu tikiin so, taansip imi kom tem kawu, tal-une-bam dukum-kup ol-bam naan-tal-une-bam le, almi angtiil kaali, tuum bal ta ukelbi kutela tal-unen-umba. ");
INSERT INTO tif_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tunum kaali tal am mepso ma tilin dinim, samaan kawu, Yesus ayo atam-ilomda kamok kamok imi weng umkaayin kaami kukup kaali, kanumin kemin, abiltap din Yesus almi miit tem kawu daak tilik duung fakela dabuuna-lom ti kabaak daalale, ");
INSERT INTO tif_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus ayo sinik mafak ami bokola-lomda: Sinik mafak kapyo! Tunum kaali, kambola yak banan o! akale, tunum ayo dukum-kup wol-bamdale, boko-lom: Yesus kabi Atin Win Tabin God ami Man alik-daap kemin, kabi tal-ilom dok nop-non o kalalapla talap i? Nali God ami tiin diim kawu weng kaali bakap-tinbi kemin, kabi nali angtiil yol awak kaa ma kup-na-laamin daa yo; kambop-nan o, akale, kulaa ");
INSERT INTO tif_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus asiik tunum kaayo, dik-daala-lomda: Kapni win kaali kanim tinepyap yoko? akale, kula tunum kulaayo atamala yi, Sinik mafak yaapkan iyo nami iipyak tem kabaku bom-bilip kala kalba-kup, ayo boko-lomda: Nuli 6,000 bom-bulup kemin, nami win kaali Yaapkan o, aka-lomda, ");
INSERT INTO tif_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yesus ayo dukum-kup ami bokola-lomda: Kapyo! Sinik nuli fotabamnap yak bokon kusnum kawu unemin disa yo, akale, ");
INSERT INTO tif_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","kang atin ti yaapkan kiili, tam yak amdu tikiin kawu bomdip bak-fakabip ");
INSERT INTO tif_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kemin, sinik mafak kiili, Yesus ami dukum-kup dik-daala-lomdip: Kabi nuli fotabam-napla, tunum kalawaayo kambola yak kang imi tiling tem unum o, kalipla, ");
INSERT INTO tif_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus ali, Ayo, kalala, kulaa sinik mafak namti tunum kaali kambolalip tiltam ababip-kup yak kang imi tiling tem uniple, kulaa kang yakal babonbi kulaa-lomdip diimal dap-kuldaak mo umbalaak Galili Kumun tem kabaak un-ilomdip kang ilmi-kup 2,000 kiiyo, ok taba yan dong dokola alik taanip. ");
INSERT INTO tif_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kemin, kang tiin molin tunum yakal kabak utamiwa yi, Kang iyo kano-lomdip taanip kala, kala-somdipla, iyo uka-daalip bina bilin abip unang tunum imi bakaya-tal-une-bilipla, unang tunum iyo dindupla kanolu uyo atamum o, kalalipla, yak aba tal ");
INSERT INTO tif_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesus ami diim tal ulipla yi, Tunum siin kawu, sinik mafak yaapkan ita dap-mafak-daalip laaba ami aket fukunin kaali, daa tangbal ma kewalula, ilim miki tiin-bombe kala, kalbip-kup kulaa, Yesus ami atul ayo suunip. ");
INSERT INTO tif_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kemin, unang tunum Yesus ami kukup kanola atamip kaata, aptum kusal iyo tunum sinik mafak ta taba-lomdip dap-mafak-daalip laaba. La, Yesus ata dap-talalulala, ami sang ayo bakaan-bamdiple, kulaa kang kanolip imi sang uyo bakayin-bam kemipla kemin, ");
INSERT INTO tif_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","kulaa abip kasel iyo Yesus ayo dukum-kup bokola-lomdip: Gerasa kasel numi am bokon kalawaali, kela-lomdap unan o, akan-kaamip ko. ");
INSERT INTO tif_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kula kanum bokoliple, kulaa Yesus ayo asuk tam bot tem tiinba-kup unum o, ke-balale, tunum siin kawu sinik mafak ta dap-mafak-daalip laaba kaali, Yesus ami dukum-kup bokola-lomda: Kep-napla, nali kapso unum o, akale, kulaa ");
INSERT INTO tif_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesus asiik bokola-lomda: I daa; kabi kaltapni abip kaali, asuk dindapla, Dukum ami kapni olen-daap-ta-lomda, mafek mafek sakbaalim dukum kanop-ta kaami sang kaali, kaptum kusal unang tunum iyo bakaya yakyak ken unan o, akale, kulaa ");
INSERT INTO tif_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","tunum kaayo, ababa-kup dap-talalulala, tangbal keba kaami sang uyo bakaya-tal-une-balale, unang tunum alik iyo awal-bamdip weng kulii-una-tala-kelip ko. ");
INSERT INTO tif_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kemin, Yesus nikil iyo bot tem yak wok kumun malii yak unip unang tunum yaapkan iyo tala-tala-kelipla, ali ok balang diim kawu bomda, kukuya-salale, ");
INSERT INTO tif_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","kulaa Juda kasel imi lotu tiin molin tunum ma tala kaami win kaali, Jarius kemin, ali tal Yesus ayo ataba-kup, kamokim imi weng umkaayilin kaami kukup kaali, kanumin kemin tilik duung fakela daak Yesus ami miit tem aba dabuuna-lomda ");
INSERT INTO tif_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dukum-kup nen-bam bokola-lomda: Nami unang man sii kulii mepso taanon o, kem-sulula, kewa tili kemin, talap alep dindupla, kapni sikil kaata kuyak tii-lom um-talalulapla, asuk tiltam tiin-ilom tangbal keluk o, kalale, ");
INSERT INTO tif_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesus aso nikil unip. Yesus nikil iyo unba-bilipla, unang tunum yaapkan ita Yesus ayo falala dap iipyak tem kabaak daa unabip. Kemin, ");
INSERT INTO tif_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","kiimi iipyak tem kaali, unang ma bombu kuuli, suunkup ulmi am unemin-kup kebii, wasital talangkal dakan-tiisu kaali ti, ");
INSERT INTO tif_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","dokta ita nam-talalulamip o, kala-lomdula, suunkup dokta yaapkan imi fanang kaali, din itamu talalmup o, kala angtiil yol dukum kaali, kukaa-ulin-kup ke-bilipla, umi sisol kaali, kukaayin-bam saan-bulula, bombii, umi moni kaali, disa kesa. Lale, umi mafak-alin kaali, ma daaklo so, kewalamu dinim kemin, atin mafak-kup laabula, ");
INSERT INTO tif_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","kulaa, Yesus ami sang kaali, weng san-ilomdu tal unang tunum imi iipyak tem kawu tal-ilom, Yesus ami daang tem kawu tola umi aket fukunin kaali, Nayo yak Yesus ami ilim-kaal kaata-kup bamaaltap yak malelila, nam-talalulala tangbal ke-lokomi ni, kala-lomdu, umi sikil kaali maaklo kulii yak Yesus ami ilim balang kaata-kup malelule, ");
INSERT INTO tif_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","kulaa maak fak-daalin tap umi mafak-alin uyo dinim kelula, kulaa utamula yi, Nalmi am unemin-kup ken-unbi kaali, disa kep-nulu kala, kem-sulule, ");
INSERT INTO tif_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus akal atamala yi, Nami titil kaali maaklo dong dokowa no kala-lomda, abiltap fal-siki talaka-bam unang tunum almi daang tem bom-bilip imi bokoya-lomda: Kalaali kawanta nimi ilim kaali, melep-nala ni? yakale, ");
INSERT INTO tif_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","almi daang bakaalin tunum iyo bokola-lomdip: Kapkal utaman! Unang tunum yaapkan iyo tola-lomdip tam-bak iipyak tem daa falala namulip kala kala-lom utabap kemin, kanimin o kala boko-lomdap: Kanta malep-nala no, kalbap i? akipla, ");
INSERT INTO tif_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesus ayo talakan-tal-une-bam kawanta kaali kanop-nala ni? kalon o, kala-lomda, talakamale, ");
INSERT INTO tif_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","unang ukol utamula yi, Nam-talalula kala, kala-lomdu suun-daa walwaal-kup tap-tap-ke-bamdu, kulaa kamokim imi weng umkaayin kukup kaali, kanumin kemin, tal Yesus almi miit tem kawu tilik duung fakela daak tiin dabuuna-lomdu, ulmi mafak-alin sang so ulumi kanolu kaami sang so kiili, faneng fatap-kup bakayule, kulaa ");
INSERT INTO tif_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesus asiik weng ayo akolkup bokowa-lomda: Nafalop kupyo! Nali utamila, Kubi, fanang daalapla, Kulaali fan nam-talalulokoma no, kalbap kala, taka-lomdila kemin, talalu-tamuli kemin, kupni aket tem kaali balili-kup kalapla, din tangbal-kup bom-balapla yo, kalala kewa una. ");
INSERT INTO tif_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kemin, unang kuuli, unokin dinim bom ilula, Yesus ayo weng kukaaya-salala, kulaa lotu tiin molin tunum Jairus ami am okok kemin tunum ma iyo tal Jairus ami bokola-lomdip: Kapni man unang kuuli, taanu kemin, kabi God ami weng kukuyin tunum kaayo, disa iip kawu dibii-talemin daa yo, kemipla, ");
INSERT INTO tif_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus ayo weng kaali, weng sanba-kup lotu tiin molin tunum ami bokola-lomda: Kabi suunin disa kela, Ali ti yaap kanolokoma no! nakalapla yo. ");
INSERT INTO tif_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kulaa, unang tunum imi bokoya-lomda: Nami uni kaali, alik kibi tal aba din unemin daa yo, kalba-kup, Pita so, Jems so, Jems almi niing Jon aso, imi weng umuuyilala, ita-kup aso nikil unip. ");
INSERT INTO tif_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kemin, Yesus ayo kela din lotu tiin molin tunum ami am kawu din aba, Jairus ami aptum kusal iyo babon-bam atul fak-daa-bamdip, dukum-kup amabip kala, kalale, ");
INSERT INTO tif_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tam am aba-lom bokoyila ko: Kipya! Kanimin o, kalalip dukum-kup aman dulum weng kalaabip i? Man unang kuluuli, taanbu disa; uli akan-umbu kemin, kibi dukum-kup amamin daa yo, yakan-kaama le ");
INSERT INTO tif_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","unang tunum iyo boko-lomdip: Ali ibakaba no, kalbip-kup aban-kulil-teliple, Yesus ayo unang tunum iyo alik fotabamna abip unaalipla, Yesus ayo man ulmi awak-aalap so, almi okok kemin tunum asuumano iso, ita-kup foko-yim-bii tam abiin ma unang man umi bombu uyo, tam ababa-kup kulaa, ");
INSERT INTO tif_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","man unang umi sikil kaali kutal-fukuba-kup bokowa-lomda: Talita kumi yo, kala bokowala kaami miit kaali, man unang sii kupyo tam tiinan o, ukale, ");
INSERT INTO tif_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","uyo kasentap tam tiin-ilomdu tal-banen-tabu. Man kuumi wasital kaali, talangkal-kup dak-duulin kemin, kulaa awak-aalap iyo atam-ilomdip aket akal ma kemiple, ");
INSERT INTO tif_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesus ayo weng kaali, dukum-kup imi bokoya-lomda: Kipni man umi umfoli tam tiinu kaami sang kaali, unang tunum kusnum imi diim kawu, kaa bakamin daa yo, kala-lomda bokoyale, inin-inin inang ma man kuluuli kuwip inamnuk o, kal-bomda bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kemin, Yesus so, almi daang bakaalin tunum iso, nikil iyo abip kaa kela-lomdip din Yesus almi abip Nasaret kawu din unip. ");
INSERT INTO tif_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kemin, ayo tal bom ilale, God ami iintang am kaayo daanule, tam lotu am kaptamu God ami weng kaali, kufo-lomda unang tunum iyo bakayin-bam kukuyin-balala, unang tunum yaapkan iyo weng san: Kwin! kalaso kanum bakama kawi! kala-lomdip bokolip ko. Faneng, tunum kaami weng tangbal kaa kukuyinba kaata, doku ma kuluuse ni? Dok no-lom Yesus ayo aket fukunin tangbal kaali, dok no-lomda dik-daa-kuluuse ni? Kanta ma kukon-balala kanolin mirakel o kala kukup ulmi kusnum kusnum kaali kanuba ni? ");
INSERT INTO tif_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kemin, siin kaayo tunum kaali, abip kaltam-ami as kom bakela kutii-bam mafek mafek talalmin tunum ke-bamda bom ilsa kemin, kaali Maria umi man ale, kaali Jems so, Josis so, Judas so, Saimon aso, nikil imi fik kemin ale, alami nakal-unang yakal ti kuno abip kalawu bom-bilip, (kemin kaali, win finin tunum disa, kaali ti disa abip tunum kemin, kaami weng kaali weng sanalup dinim) o, kala-lomdipla daang ukolipla itaba-kup ");
INSERT INTO tif_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus akal bokoya-lomda: God ami profet o, kala weng tem bakayilin tunum ayo din abip malo ma kaami tam unokoma kaata, abip kaptam-ami kasel iyo boko-lomdip: Tunum kalawaayo, win finin o, kala ami weng baka-mokoma kaali ti, talalu weng san-kaa-mokomip. Lale, din almi abip tituun kaptamu unokoma kaata, almi abip kasel aye, almi aptum kusal aye, aa yak almi kiim anung aye, iyo ami weng kaali ma, weng sanokomip dinim o, yakale, ");
INSERT INTO tif_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","abip kasel iyo aket fuku-daa-lomdip, Kaali God ami titil kaa ma kutal-fukusa dinim o, kebip kemin, aket tam banelule fanang-daaba-kup, Yesus ayo kukup almi kusnum ma almi abip kaptamu kano-laaba disa. La, unang tunum mafak-alin malo ma ita-kup sikil kulii yak daa-lom yam-talalula, tangbal kelip ko. Kemin, Yesus ayo Nasaret kela una kaami abip ma abip ma imi kukuya yakyak kem-tal-unema. ");
INSERT INTO tif_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesus ayo okok kemin tunum talangkal iyo yim-baali alep e kala una-una-kelin o, kala-lomda naan-daaya tal mepso tiliple, almi titil kaali, kuya-lomda bokoya-lom: Kibi nami win diim kaata sinik mafak mafak kiili fotabam-nipla, yak banemik o, kalba-kup kulaa ");
INSERT INTO tif_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","kipni yak abip ma ma kaami kanun-tal-une-mokomip kaali, (abip unang tunum iyo taba ibi dong dakaayokomip kemin,) kibi ima aye, men dukum aye, aa tuumon anang aye, kaali ma kulii-unemin daa; malal kaata-kup kulii-tal-une-mokomip. ");
INSERT INTO tif_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kemin, yaan-ilom kulaa, kuno diltoop tine unolip. Lale, siyot kaal kaali alep daa; maakup kaata-kup kulaak tinila kulaak tinila ke-lomdipla, unokomip. ");
INSERT INTO tif_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kemin, ibi din abip ma din unip kaali, am maakup kaptamu bomdip abip unang tunum iyo kukuyinbi keyinbip-kup aa, yak abip ma ma ken-tal-unemalip. ");
INSERT INTO tif_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kanolin kemin, am kaptam bom-bilip aa, abip kasel aa, iyo im-tam daa tiin mo-bom kipni weng ayo weng san-kaamin dinim kelip namti, Juda nulmi kukup ma kaata, kuluu-lomdipla, abip kaptam ayo kambola unolip o. Nulmi kukup kaali, sung ilol tal aba yak kipni yaan diim tabuuba uyo diliit-mo kulaalip yak abip kasel imi lo kabamnula kawu, abip kaptam-ami unang tunum iyo utamiwa yi, Asuk ilom kaa maso tal nuli dong dokoyokomip dinim o, kalin o, kala Yesus ayo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Okok kemin tunum nikil iyo yakyak din unang tunum iyo bakayin-bamdip: Ibi aket fal-siki-lom kiltipni kukup mafak kaa kanubip kaata, kela-lomdipla yo! ke-bamdiple, ");
INSERT INTO tif_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","nikil iyo sinik mafak yaapkan iyo fotabe-bilip yak bane-biliple, kulaa angtiil diim ilikmin kaami marasin kaali, kuluu-lom unang tunum mafak-alin imi angtiil diim kaa ilik daaya-lomdip beten keya yam-talalulip taltam tangbal ke-bam kemip ko. ");
INSERT INTO tif_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kemin, Yesus ami win kaali, tiltam dukum-nule, King Herot akal kuno weng san kela kemin, malo ma iyo boko-lomdip: Yesus ali oksam ukaayin tunum Jon Baptis taanse ata kemin, kulu God ata dafola asuk tam tiin-ilomdala, kanolin titil kaali, kuluu-lomda mirakel o kala kukup almi kusnum kusnum kaali kanuba no, kemiple, ");
INSERT INTO tif_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","malo ma iyo boko-lomdip: Daa ya! Kaali sawaalak God ami profet o kala weng sawaa bakayin tunum Elaija biisa ata kulu tiltam talda kulu kanuba no, kemiple, malo ma ita boko-lomdip: Daa ya! Kaali Elaija disa, kaali ti God ami weng sawaa bakayin tunum kusnum kemin, sawaayak kaami weng sawaa bakayin-bisip iltap o, ke-bam, weng aal diki-bam una-tala-ke-bilipla, ");
INSERT INTO tif_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot ayo weng sanba-kup bokola: Siin kaali, nami waasi dinin tunum ayo dabaali din-ilomda Jon ami dabom kaali, buk-dola-lom anse. Lale, kaata God ayo asuk dafolala, faneng tam tiinba no, kala ko. ");
INSERT INTO tif_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kanola Herot ami kanose kaali ti, siin kaa Herot almi abokonim Filip ayo taanin dinim bom ilala, Herot ayo Filip ami kalel Herodias uyo tak-daa kuluulala, kaata ti suunkup Jon ayo bakaan-bamda: Kapkal utamsap kemin, kap-kabelim ami kalel kuumi tak-daa kuluu-lomdap uso laabip kaali, God ayo boko-lomda: Kukup kaa kanumin daa yo! kalsa namti kulu lo kutiibap o, kala bakaalin-kup ke-balala, Herodias kuuli ti, Jon ayo aket atul-kup kola-lomdu Herot ayo waka-takaan-bulula, almi unuk tabuulin tunum iyo bokoyilala, iyo dindip Jon ayo sok de dibii-din kalabus am kawu daa-silip. ");
INSERT INTO tif_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herodias uyo aket atul dap-tiiwale, Jon ayo dok nola-lomdi aali taanak o, kemin-kup kemu. Lale, Herot ayo Jon ayo atamala yi, Ali tunum tangbalim, ban kemin dinim kala, kala-lomdala, Jon ayo atam suun-bamda tangbal-kup tiin mo-bom balala kemin, Herodias ukol dok no-somdula taang-kala-lomdu, aalu taanama dinim. Kemin, Herot ayo Jon ami weng tangbal kaa weng saan-kaa-bamda aket yaapkan fukuni kala, kala-lom kelakin. Kata, ali ti suunkup Jon ami weng kaata-kup weng san-kaamon o, kema ko. ");
INSERT INTO tif_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias ukol Jon ayo dok no-lomdi aali taanak o, kem-laabu kemin, Herot ami awak duusu kaami aket fukunin am kaali, daanula, Herot ayo almi dong dakaalin tunum so, almi waasi dinim tunum imi tiin molin so, Provins Galili kasel imi kamok kamok iso, iyo naan-daayilala, tal Herot am kaptamu ima waan in-bom fiyaap duu-bilipla, ");
INSERT INTO tif_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias umi man unang uyo tiltam am taldu danis tangbal ayo ke-bulula, Herot so, tunum ima inbip iso, iyo utam-ilomdip unang man kuumi fiyaap kaali duu-un-bamdip king ayo unang man sii kuumi bokowa-lom: Kaali tangbal kemin, nali mafek mafek tangbal ma kup-ton o kebi kemin, kultupta bokop-na-lomdap, dok nolin kaami mafek mafek kaata ma kup-nan o nakap kala, kalalila, kulaata-kup kup-tokomi. ");
INSERT INTO tif_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kemin, nami weng kaali ti, faneng bokop-ti kemin, dok nolin mafek mafek katip aye, dukum aye, ale, mafek mafek sisol dukum kuluu-lom saanin aye, inang kaata kanola kubi kaami sang dik-daalap kaali, ti maaklo kup-tokomi no, ukale, ");
INSERT INTO tif_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","kulaa, unang man uyo abiltap tam-ilomdu awak uyo dik-daawulu: Akamen o. Nali awakim ami diim kaali, kanamin mafek mafek kaata ma kup-nan o, akokomi ni? ukule, kulaa awak uyo bokowa-lomdu: Tam ilom Herot ayo bokola-lomdap: Nami aket fukunin kaali, kapni waasi dinin tunum ayo ma dabaalap dindala, oksam wakayin tunum Jon Baptis kaami dabom uyo ukduu kulii-tal kup-nan o, kalbi no, kala kanum bokolapla yo, kala awak uyo kanum bokowulule, ");
INSERT INTO tif_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","kulaa man uyo abiltap tiltam am taldu king ami bokola-lomdu: Nami aket fukunin kaali, ti kamala kulawu kapni waasi dinin tunum ayo ma dabaalap dindala oksam wakayin tunum Jon Baptis kaami dabom ayo ukduu-lom ku kabas diim tii kulii-tal kup-nak o, kalbi no, akule, ");
INSERT INTO tif_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","kulaa king ayo weng san-ilomda, utama yi, Kaali atin ti kukup mafak kala, kalba-kup kulaa ami aket tem kaali ti mafakalule, Disa yo, kalokin. Katale, fanang daalala, Unang tunum yaapkan bom-bilip kalawiiyo, nami weng kutiili kaali, weng sanip kala, kalba-kup, Ayo, unba-kup, ");
INSERT INTO tif_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","king ayo almi waasi dinin tunum ayo bokola-lomda: Din Jon ami dabom kaali, ukduu kulii-talan o, akala din kalabus am un-ilomda Jon ami dabom kaali, ukduu-lomda kuu kabas diim tii ");
INSERT INTO tif_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kulii-tal-ilomda unang man sii umi kuwa, uta kuluu-lomdu kulii-din awak umi kuuwu ko. ");
INSERT INTO tif_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kemin, Jon ami daang bakaalin tunum iyo kaami sang kaali, weng sanbip-kup, iyo tal Jon ami as kuli kaali, kulii-din buluusip ko. ");
INSERT INTO tif_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kulaa, Yesus almi kalaan tunum yim-baala alep e kala un-un-kesip iyo asuk tala-tala-ke-lom Yesus ayo bokola-lomdip: Kamokim kapyo! Weng alik kulu kuyap kulii-un-sulup kaali, yaan tem kanola talal-bamdup, yak kapni weng tangbal kaali, kukuyin-bam kem-solupla kala, tulup o, akip. ");
INSERT INTO tif_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kemin, unang tunum yaapkan iyo tal aba unbip-unbip-ke-bilipla, bii-lom Yesus so almi kalaan tunum iso, nikil iyo kalawaali dok no-lomdup ima kaali, inam-nolup dinim kelup kala, kalba-kup Yesus ayo bokoya-lomda: Na! Unip nikil nulukis din tunum dinim disanang bokon kawu kun fan-kaamin katip ma funulin tap kelupla yo, yakale, ");
INSERT INTO tif_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","kulaa nikil ilakis tam bot tem tiinbip-kup, abip kaali kela ok kumun kaami daang kun diim liip yakyak din tunum dinim, disanang bokon ma unum o, kala-lomdipla, unip ko. ");
INSERT INTO tif_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kemin, ok kumun balang diim kaami abip ma ma kawu, kasel yaapkan iyo itamdip, Yesus nikil namti kulu bot tem liip tal-unbabip o, kala, itabip-kup, isiik abiltap tawaal liip dak-daa dibii-din tunum dinim disanang bokon kaali din bom iliwa, ");
INSERT INTO tif_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus nikil iyo yak balang tem yak ilom, Yesus ayo talaala yi, Kwin, unang tunum yaapkan tala-tala-kebip kala, kala-lomda ti talalu dukum-kup olen-daayila-lomda: Kiili, sipsip imi tiin molin tunum iyo keyilala, ilikis bomdip, liip kaali, kela babon tal-unebip iltap ke-bam God ami tituun-kup liip kaali, atamin dinim ke-lomdip, kanta ma nuli dong dokoyokoma ni? kal-bom aket yaapkan fukun-unbip kala, kala-lomda, weng yaapkan kaali, bakayin-bamda kukuya ko. ");
INSERT INTO tif_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kulaa, kukuyin-bala atan kaa tem unon e kem-sulule, Yesus almi okok kemin tunum iyo tal bokola-lomdip: Bokon kalawaali, unang tunum dinim ale, atin am tiin daa kela kemin, ");
INSERT INTO tif_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","unang tunum kalawiiyo, fokolap din abip ma aye, bokon mep aye, iyo din un-ilomdipla kawu, ilmi inin-inin ma mo-lomdip inalipla siin o, kemiple, ");
INSERT INTO tif_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesus asiik bokoya-lomda: Nikil kipni inin-inin kiita ma kuyilipla yo, yakala kulaa, nikil isiik bokola-lomdip: Nuli moni almi-kup tu handret (200) inang ma kuliilip din bret kaali, mo-lom kulii-tal kuyupla, ina-lomdip siin o kalbap elile, kanimin o, kebap i? akiple, kulaa, ");
INSERT INTO tif_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","asiik bokoya-lomda: Ibi bret kaali, kanim kal ma bombe namti din atamin o, yakale, ding bokobip-kup tal bokola-lomdip: Bret katip katip kiita, awakal ale, aniing kiita alep-kup bom-bilip o, akipla, ataba-kup ");
INSERT INTO tif_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","unang tunum imi bokoya-lomda: Alik daak balaasaal kon tangbal diim kawu afetu kutii tiina tiina kelipla yo, yakale, ");
INSERT INTO tif_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","alik daak tiinip kaali, ma 100 kabaak tiinaala, ma kabaak-ata 50 tiinaaliple, ");
INSERT INTO tif_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","bret awakal ale, aniing alep ma iyo foko-lomda titam abiil daa, God ami yaap ke yo, anba-kup, bret so, aniing so, iyo bakela kutii-lomda almi daang bakaalin tunum imi kukaaya-tal-unemsi kulaalipla, ");
INSERT INTO tif_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","alik iyo kuluu inbi-lom tiiknip kemin, ");
INSERT INTO tif_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","daang bakaalin tunum iyo bret so, aniing so, tanan-tanan-kebip kaali, afeta-tal-une-bi-lomdip basket almi-kup talangkal abuubi kutiilip kemin, ");
INSERT INTO tif_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","tunum deng ilmi-kup faiv tausin (5,000) iyo bret so, aniing so, kiiyo, inip ko. ");
INSERT INTO tif_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kemin, Yesus almi daang bakaalin tunum iyo bokoya-lomda: Nak-tunum kusal kipyo! Kipsiik tam bot tem kaali, tam tiin ok daang kun liip yak malii ababip-kup, abip Betsaida unipla kawu, nita unang tunum kalawiiyo, yim-baali unipla yo, yakala nikil unaalipla, ");
INSERT INTO tif_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","akal unang tunum iyo bokoyilala, unaaliple, akal yak aba tam amdu tikiin ma tam-ilomda God ayo beten kamaala ko. ");
INSERT INTO tif_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kulaa, beten kaman-bala am malang tinilule, bot kaali umbiyak ok kumun iip-iip unula, kulaa akal alafin tildak tawaal diim kawu bomda, ");
INSERT INTO tif_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","tilii biyak daalala, Inim ta nikil iyo bot kuuso, yim-baala yak aba tildak aba ke-bilipla, titil-kup taba-lom as kom kuluu ok kaali dabela yakyak unabip kala, kem-salale, am daan daan talba salale, kuluwu daang bakaalin tunum imi fanang ok daang tip diim liip tol-tol-ke-lom akaaya-tal-unon o kalba. Lale, ");
INSERT INTO tif_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","nikil iyo alik atamipla yi, Ali bot dinim ok daang kun diim liip kawu talaba kala, atam-ilomdip iyo suun-daa-lom, Kaali sakbal i! kal-bom atin suunin dukum ke-bam olmiple, Yesus ayo abiltap-siik bokoyila ko: Naktum kusal kipyo! Nalta kemin, ibi suunin daa yo; kela-somdiwa titil-fak-daalin a! yaka-lomda, ");
INSERT INTO tif_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","din ilmi bot tem tiinipla, kulu inim ati namti kulu ditang-kala disa kelu. Kemin, nikil imi aket fukunin kaali, dok no-lom abiltap bam-daa-lomdip Yesus kaali, dok nolin titil kaata ma kuluu-bomda kanuba no, ma kalolip dinim. Kemin, kamosinim kaali, nikil iyo atamipla yi, Yesus ayo bret katip kaali, unang tunum yaapkan iyo dan-kaayin-balala, inbi-lom tiikbip kala, kalbip-kup Yesus ayo dok nolin tunum i! kala-lom bam-daalin dinim kebip-kup, kamosinim kawu, nikil iyo atamipla, Yesus kaali, ok daang kun liip talaba kala, kalbip. Lale, kaali dok nolin tunum i? kalin dinim ke-lomdipla, atin suunip ko. ");
INSERT INTO tif_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kemin, ok kumun iip-iip kaali, kela yak abip Genesaret umi mepso ok balang tem kawu yak ababip-kup, bot kaali kulii yak ok balang diim kawu tii-lomdipla sok ta buku kuk-diibip-kup, ");
INSERT INTO tif_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","kela din itamiple, abip kayaak iyo abiltap din atamipla, Kaa Yesus alta tala kala, kalalipla ");
INSERT INTO tif_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","iyo abiltap yang abip mepso kaali, tal-une-bamdip unang tunum mafak-alin kuluusip iyo biin de yim-bital ulipla, Yesus ayo yak abip ma abip ma bombe no, kalipla, ita yim-tal Yesus ami be kawu daalip. ");
INSERT INTO tif_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kemin, Yesus ami tal-uneba kaali, abip dukum so, abip katip so, yak maket abip aye kaaso din-une-bam, kem-tal-une-balala, unang tunum iyo aptum kusal mafak-alin kuluusip iyo kulii tiltam abip daal kawu yim-tiilipla, Yesus ami dukum-kup nen-bam bokolip ko: Kamokim kapyo! Kabi kuno kamboyawa yakal yak kapni ilim matum kulaata-kup malep-tiwa yaawa-yaamik o, kala bokoliwa, Yesus namti, Ayo! yakaya, unang tunum kawanta yak Yesus ami ilim matum diim malelip iyo yaawa-yaamip ko. ");
INSERT INTO tif_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Falosi so, Jerusalam kaptam-ami lo utamsip tunum malo ma iso, iyo tal Yesus almi diim kawu tala-tala-ke-lomdip, ");
INSERT INTO tif_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesus almi daang bakaalin tunum malo ma iyo itamipla yi, Awil-fakal imi sikil fiit-bam diingmin kaami kukup kaata kela-lomdip, ilmi sikil kaali disa mep kulu diingnup o, kala kela ima inbip kala, kalbip-kup, daang-tem weng uyo bakayip. ");
INSERT INTO tif_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kemin, daang tem weng bakayinbip kaali ti, Falosi la ili Juda kayaak kaa bom-bilip sole, Juda kayaak alik iso, iyo ilmi awil-fakal imi kukup kaata kutal-fukusip. Kemin, (kiimi aket fukunin kaali, awil-fakal imi kukup kaa lolup namti, kaata taba nuli yam-mafak-daalokomu kala, kalbip-kup) kamosinim kaali sikil diingmin dinim kelip kaali, ima kaa ina-laabip disa; ");
INSERT INTO tif_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ale din maket kemin baan diim din aba tilip inang kaali, iyo sikil diingnin disa kelip namti, ima kaali ma, ina-laabip disa. Kemin, sawaayak awil-fakal imi kukup kusnum kusnum yaapkan kiita kuluu-lomdip saak yak kaap aye, sosben aye, dis aye, bet inang kaali, diing-bamdip kukup kusnum kusnum kiili, kanu-bamdip kanumin-kup kemip. ");
INSERT INTO tif_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kemin, Falosi so, lo utamsip tunum iso, iyo Yesus ami dik-daala-lomdip: Kapyo! Sawaayak kaali numi awil-fakal iyo boko-lomdip: Ima inamnon o, kalap uyo sikil kaali, kanola talalu diing daa-lomdapla yo, kalsip. Kemin, awil-fakal ili suunkup ilmi man iyo kukuyin-kup ken-laabip. Kemin, nuli kanolin kukup kaali ti, kutal-fuku-bom-bulup. Lale, kapni okok kemin tunum ili kanamin o, kala numi awil-fakal imi kukup kaali, kutal-fukulamup dinim o, kal-bomdip imi sikil kaali, talalu diingnin dinim ke-lomdip ima uyo inbip i? akipla, ");
INSERT INTO tif_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus asiik bokoya-lomda: Kibi disa weng alep bakamin tunum kemin, sawaayak kaali, God ami profet Aisaya ali tifan kipni kukup kaami sang kaali, God ami Sukon Tem uyo dola kutii boko-lomda: God ayo boko-lom: Kanolin unang tunum iyo disa nami tong kaata-kup bakaan-unbip; kemin ale, nami aket fukun-ilomdip tildang nalmi miit tem uyo tololup o, kala-lomdipla, yang samaan bokon kawu laabip. Kemin, ");
INSERT INTO tif_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ililta unang tunum kii, ilmi weng sawaa kaata-kup kukuyim-bamdip bokoya-lom: Kalawuuli God ami weng sawaa kemin, dotu kutal-fuku-bomdiwa kayi! kem-laabip. Yale, nali imi kasen-faka-bamdip nami tong kaata bakan-yaabip kaa weng sanokomi dinim o, kala God ayo kanum bokosa kayi! kala Aisaya ata weng kaa dola kutiisa. ");
INSERT INTO tif_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kemin, ibi God ami weng kutiisa kaali, kela-lomdipla, sawaayak tunum saaka tam bansip imi kukup kaata ti, kano kutal-fukusip te! ");
INSERT INTO tif_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kipni titil-kup taba kawil-fakal imi weng kutiiyinsip kaata-kup kutal-fukulum o, kala-lomdip God ami weng kutiisa kaali, daang-ukonsip kaali ti tangbal disa; kaali ti mafak kemin, kaami sang kaata bokoyon o, kalbi kemin, weng san-iliwa! ");
INSERT INTO tif_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sawaayak kaali, Moses ayo God ami Lo uyo unang tunum imi kuya bokoya-lomda: Kipni kawak-aalap, iyo talalu tiin mo-somale, imi weng ayo weng san-kaa-bam dong dakaayim-bam, ke-bamdiwa yo, kala-som ale, aa kawanita ami awak-aalap, kiimi weng mafak bakayila namti, aalip taan-yaamin o, kala kanum bokosa. ");
INSERT INTO tif_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kata, ipkal iltipni weng kusnum ma boko-lomdip: Kanola tunum ami moni bombe ayo, God ami kolon o, kalalala awak-aalap iyo bokoya-lomda: Nami moni kutal-fukubi kalawaali, God ami kolokomi no, kebi kemin, kaami win kaali, Koban o, kala-laabip. Kemin, kaali asuk ulduu-lomdila, akam ibi talalu tiin mo dong dakaayokomi dinim o, kala namti, ");
INSERT INTO tif_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","almi awak-aalap imi dong dokoyin dinim kela kaali, yaap ke-lokomu no, kala-laabip. ");
INSERT INTO tif_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kanumin kemin, kaali ibi iltipni kawil-fakal imi kukup kaata, kuluu-lomdipla unang tunum iyo kukuya-laabip. Kemin, kaata ibi God ami weng uyo kuyang saak tiilala tabasip te! Kemin, kanolin kukup yaapkan kiita, ibi kanun-umbip o, kalba-kup, Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus ayo asuk unang tunum imi naan-daaya tal atamipla bokoya-lomda: Alik ipyo! Nali weng ma bokoyon o, kalbi kemin, dotu weng san-ilom kaal kelin! ");
INSERT INTO tif_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","God ami tiin diim kawu, tunum ayo ma sikil ninak soyim aye, mafek mafek, Awem o, kala-laabip aye, uyo inamna daak almi mat tem unokomu kaata taba-lom dap-mafak-daalokomu disa; kata, tunum ayo aket mafak fukun-bamda, kukup mafak ke-mokoma kaata ti dap-mafak-daalokomu. ");
INSERT INTO tif_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kemin, ibi abat daa; ibi weng kaa sanilip kemin, weng kala bokoyili kaali, talalu weng sandipla, atam kaal kelin o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus ayo unang tunum iyo kamboya tam am unale, alami daang bakaalin tunum iyo dik-daala-lomdip: Weng faldak-tiimin weng kaa bokobap kaami miit kaali, dotu ifiiyalawa nuyo utamum o, akipla, ");
INSERT INTO tif_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesus asiik bokoya-lomda: Kamok kamok kiili, miit kaali bam-daalin dinim kemin ale, kano ti kipkal ti bam-daa kaal kelin dinim bom-bilip ema? Ibi utamsip dinim kemin, weng san-iliwa bokoyon o, kala-somla ko. Kulaa, tunum ma ayo mafek mafek tiltam saaklo kawu bombu kaami inam-nokoma kaali, tituun-kup daak mat tem kawu ilana-lomdu din imaan dabaalokoma kawu, tiil bun-ilom disa ke-lokomu. Kemin, kaata taba-lom kaami aket kaali, dap-mafak-daalokomu dinim o, kala kanum bokoya ko. Yesus ami weng kanum bokola kaami iipyak tem kabak-ali ti, mafek mafek alik inin o, kalsa kaa, awem dinim o, kala ko. ");
INSERT INTO tif_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kanolin kemin, Yesus ayo bokoya-lomda: Kukup mafak uyo tunum ami aket tem kabaku bombu kaami tiltam saaklo tulu ayo kanu-mokoma kaata, fan tunum ayo dap-mafak-daalokomu. ");
INSERT INTO tif_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tunum ayo kukup mafak kaali, kanolin dinim ke-lom aket mafak kasiik fanang daa-lom mulo kawu yangda kukup mafak uyo kanolokoma. Kemin, kukup mafak kanolon o, kalokoma kaali, aket mafak fukunin aye, sadiki-bam aptum dap-mafak-dakamin aye, yukut-inin aye, aptum aala taan-laamin aye, aptum ami tiin kuwaala-lomda ami kalel uyo sadikimin aye, ");
INSERT INTO tif_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aptum ami mafek mafek tiin nenin aye, kukup mafak mafak nuumin aye, iiweng bakamin aye, fatom dinim ke-bam ban kemin aye, saak yak aptum ami daang tem weng bakayin aye, weng mafak bakayin aye, almi win kufumin aye, maaklo babon-bam fuut-kup kuyak daa ilin aye, kiita kanu-mokoma. ");
INSERT INTO tif_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kemin, kukup mafak alik kiimi miit kaali, tunum imi aket tem kabaku ilomdula, tiltam saaklo tulula ban kelala namti, kaata fan tunum ayo dap-mafak-daalokomu no, kala, Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kemin, Yesus nikil iyo Juda kasel imi bokon kaali, kela din abip kusnum kayak kayak imi bokon kawu unip. Kemin, imi abip dabom alep kiimi win kiili, Taiya so, Saidon so, kemin Yesus ami fanang-dakamin kaali, Tunum iyo ma nitamin dinim kelipla, maaklo din kun funulon o, kala-lomdala, din am ma kaptamu ilanin tap kela. Katale, dok no-lomda ayo sawaanama dinim; ");
INSERT INTO tif_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","unang ma uyo weng sanula, Yesus ayo tala no, kalbip kala, kalbu-kup, unang kuuli man unang ma la, sinik mafak ta taba-lom uyo um-mafak-daasa. Kemin, unang kuuli, Juda kayaak disa; uli Fonisia kayaak unang. Lale, uli Yesus ami fanang tal-ilomdu, kamok kamok imi weng umkaayin kukup kaali, kanumin kemin uli tal Yesus ami miit tem kawu tal-ilom tilik duung fakela tiin-ilomdu dabom falat kalomu dinim ke-lom dukum-kup boko-lomdu: Nami man unang uyo sinik mafak ta taba-lom um-mafak-daasa. Kemin, kaata fotabamnap yak banala, man uyo tangbal keluk o, aku. ");
INSERT INTO tif_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kemin, (Juda kasel iyo unang tunum kusnum kayak kayak imi win kaali, bokoya-lomdip: Ibi miyaan yam o, yakan-kaa-bamdiple, ilmi unang tunum itale, Fan tunum imi man o, kal-bom ken-umbip. Kemin, Yesus ayo aket fuku-daala yi, Unang umi aket fukunin kaali, um-kukulila, Yesus kulaali ti kunolama no, kalbu ne, kulaa kanolama dinim o, kalbu ne kala, utamon o, kala-lomdala) faldak-tiimin weng ma bokowa-lomda: Man katip katip imi ima duk-duu kulii-din miyaan imi kuyokomip kaali, tambal keyokomu dinim; kemin, kamosinim kaali, man katip katip isiik ifamin (kemin, kupni dong dokop-tokomi kaali, tambal kep-nokomu dinim) o, wakale, ");
INSERT INTO tif_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","unang usiik boko-lomdu: Kamokim kapni weng kaali, faneng bakabap. Kata, man imi ima in-bilipla, daam sekela daak tebol kaami minlo tem abam-nokomu kaali, miyaan yam tebol minlo tem kabaak tiinaabip ita taba-lom inan-laabip, kanolin tap kemin, kabi dong dokop-nokomap kaali, yaap kep-tokomu no, akule, ");
INSERT INTO tif_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus asiik bokowa-lomda: Weng kaali, tangbal ma bokolap kemin, sinik mafak ayo fotabamni, kupni man uyo kambowa yak bana. Kemin, nafalop kupyo! Kambola kultupni am unan o, wakale, ");
INSERT INTO tif_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","daak aba din ulmi am ulula yi, Sinik mafak ali man uyo kambowa yak banale, uyo tangbal-kup akan-umbu kala, kalbu-kup, utamu ko. ");
INSERT INTO tif_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kemin, Yesus ayo asuk abip Taiya kaa kela din abip Saidon aba daak aba yang Distrik Dekapolis kaami liip din aba akaala daak aba tal Galili wok dal abale, ");
INSERT INTO tif_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tunum ma ali talang tem abat ale, weng bakamin kaali, mafak-kensu ayo almi aptum kusal iyo dibii-tal ababip-kup, Yesus ami dukum-kup bokola-lomdip: Tunum kalawaayo, kapta atabap-kup dap-talalulan o, akiple, ");
INSERT INTO tif_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus ayo unang tunum iyo kamboya dap-tama yang saak lo kabangu alep ilakis-kup ke-lom, Yesus ayo sikil diil kiiyo kulii yak tunum ami talang tem alep kiili, dibiila toop un-un-kelale, mok tak-daa kulaala daak sikil duung diim abamnule, kulii yak tunum kaami falang diim tenba-kup, ");
INSERT INTO tif_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","God ayo beten kaman-bamda ti abiil tikiin daa ilanin tap keba-kup olen-an-bam tibitap-tibitap-ke-bam bokola-lomda: Efata yo, kala kaami miit kaali, Talang tem kipyo! Tangbalnin o, yaka-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tunum kaami talang tem sole, bon tem so, kiili tangbal kewalip weng kaa tangbal-kup baka-bamdale, aptum kusal imi weng kaali, weng san-kaa-bam kema. ");
INSERT INTO tif_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kemin, Yesus ayo unang tunum malo ma bom-bilip iyo kanola atamip imi bokoya-lomda: Kibi yang kaptum kusal iyo nami kaa kanoli atamip kaami sang kaali, bakayin dinim o, kala, titil tabin weng kaayo, bokoya. Katale, ili ti yang aptum kusal iyo suunkup bakaya yakyak kem-tal-unemip. ");
INSERT INTO tif_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kemin, unang tunum kaa bom-bilip ili atin fanang alik tam baneyulula, una-tala-tala-ke-bam boko-lomdip: Tunum kalawaata, mafek mafek kaa kanuba kaali, alik tangbal-kup ke-bamda, talang tem abat iyo yam-talalulala, weng san-kaa-bam ale, weng bakamin dinim iyo yam-talalulala, weng tangbal baka-bam ken-umbip o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kanumsa kaata kemin, unang tunum yaapkan iyo Yesus ami weng kaali, asuk weng sanum o, kala-lomdip iyo tala-tala-kemiple, imi ima kaali, disa yo kalba-kup Yesus almi daang bakaalin tunum imi naan-daaya tal atamipla ayo bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Unang tunum kalawiili naso bombii am asuumano kelip kalaali, imi ima kaa disa keyila, iyo ima tinap ke-yimba kemin, nali olen-dakayinbi no. ");
INSERT INTO tif_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lale, malo ma kala bom-bilip kiili, samaan bokon kawu talbip kemin, kanola nali ima tinap yim-baali abip unokomip namti, un-bomdiwa, ima tinap liip tiinokomip o, kalale, ");
INSERT INTO tif_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","daang bakaalin tunum isiik Yesus ami dik-daalip: Unang tunum kalawiili yaapkan kemin, tunum dinim bokon kala, dok liip ima ayo kuluu-lomdup alik ifalup ina tiik-nokomip yoko? akiwa, ");
INSERT INTO tif_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","asiik nikil imi dik-daaya-lomda: Kipni ima bret kanim kal ma kulii-talbip i? yakale, iyo bokolip. Nuli bret fetkal-kup o, akipla, ");
INSERT INTO tif_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesus asiik unang tunum iyo bokoyila, daak tawaal kulu tiinaaliple, bret fetkal kiiyo, foko-lomda, God ami yaap ke yo, anba-kup, bret iyo bakela kutii-lomda kuluu almi daang bakaalin tunum imi kuyilala, ita kulii-taba-lomdip unang tunum iyo kukaaya-tal-une-biliple, ");
INSERT INTO tif_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","nikil iyo aniing katip katip malo ma iyo bom-bilip kano Yesus ayo kuluu God ayo yaap ke yo kala, almi daang bakaalin tunum iyo bokoya-lomda: Aniing kaaso kuya-kuya-kelin o! yakala kabaan-yila tal-unemip. ");
INSERT INTO tif_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kemin, unang tunum iyo imbi-lomdip tiikniple, kulaali daang bakaalin tunum iyo ima in-bomdipla yelbip anung anung kiiyo foko-lomdip basket almi-kup fetkal kiiyo, abuulip dongnip. ");
INSERT INTO tif_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kemin, unang tunum iyo bret so, aniing so, inamnip kiili, fo tausin (4,000) kanolin ita inamnip dinim kelule, kulaali Yesus ayo taba yim-baala unipla, ");
INSERT INTO tif_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","almi daang bakaalin tunum so nikil iyo tiltam bot tem tiiniple, yak Distrik Dalmanuta kaami malii kabak unip ko. ");
INSERT INTO tif_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kemin, Falosi malo ma iyo tal Yesus ami dap-kuku-bam bokola-lomdip: Kapyo, kabi mirakel o, kala kukup almi kusnum kaata ma kukuyilawa, nuli atamupla yi, Fan, kabi God alta tam-baala tal-salap kala, takum o, akipla ");
INSERT INTO tif_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ali aket uluum kela baplelula bokoya-lomda: Ibi bokop-na-lomdip mirakel o, kala akal almi kukup kusnum ma kanolapla atamum o, kala dik-dakap-nin daa yo! Kemin, nali ibi weng kaa faneng bokoyokomi kemin, kanolin fanang dakabip tunum ibi nali mirakel o, kala kukup almi kusnum fenbip kaali ma kanoli ata-mokomip disa yo, kalba-kup ");
INSERT INTO tif_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesus ayo asiik unang tunum iyo kulu keyila almi daang bakaalin tunum iso, nikil iyo tam bot tem tiinbip-kup, yak wok kumun malii kawu unip ko. ");
INSERT INTO tif_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kemin, Yesus ami daang bakaalin tunum nikil iyo bret kaa lukuuya kutiibip-kup bret maakup kaata-kup bot tem kaptamu kulii-tilip kemin, ");
INSERT INTO tif_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus ayo weng fatap kaata, faldak-tii-lom weng ma bokoya-lomda: Naktum kusal kipyo! Kibi Falosi so, Herot so, imi yiis kaali, dotu utafii-bam dap-kayak dap-kayak-ke-bam bomdipla yo! yakale ");
INSERT INTO tif_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","nikil ili Yesus ami faldak-tiimin weng bokola kaami miit kaali, kaal kelin dinim ke-lom-dipla kemin, nikil ikal teken-bam boko-lomdip: Kwin, bret malo kaa dinim kemin, yiis kaami sang kaata bakaba neli ye? ke-bam bakamiple, kulaa ");
INSERT INTO tif_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus ayo almi daang bakaalin tunum imi weng kanum bakabip uyo utam bokoya-lomda: Ibi kanimin o, kala-lomdipla ibi boko-lom: Nuli bret dinim kemin, kanum bakaba no, kebip ema? Kipni fanang saanin kaali, duk-duu kuwayilu ibi utamipla, Yiis kaami sang kaata disa kemin, mafek mafek kusnum kaami sang kaata bakaba no, kala utam kaal kelin dinim kelip o? ");
INSERT INTO tif_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Kibi tiin so, talang tem so, kemin lale, atafii-bam ale, weng san-kaa-bam bam-daalin dinim kelip o? Siin kaali, bret awakal fakela-lom kuyili kipkal kuluu tunum ilmi-kup faiv tausin (5,000) kiimi kuyilip ina-lom tiika yela kutiilipla asuk basket abumsip kaali, kanim kal ma abuu-silip i? Kibi lukuuyase no? yakale, isiik bokola-lomdip: Basket kiili talangkal abuu-sulup o, akipla, ");
INSERT INTO tif_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","nikil iyo asuk ma dik-daaya-lomda: Asuk kamosinim kaami bret fetkal fekela kuyili iltipta kuluu-lomdip unang tunum ilmi-kup fo tausin (4,000) kiimi kuyilip in-bom tanan-tanan-kemsip kaali, ibi basket kaa kanim kal ma abuu-silip i? yakale, iyo boko-lomdip: Basket fetkal abuu-sulup o, akipla ");
INSERT INTO tif_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesus asiik bokoya-lomda: Kibi kamali kaa, dotu utamin disa bilip o? ");
INSERT INTO tif_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kemin, Yesus nikil iyo yak aba din abip Betsaida kawu, din unipla, abip kasel iyo tiin bikilin tunum ayo dibii-tal Yesus ami bokola-lomdip: Tunum kalaayo, kapta atamdap dong dokolawa, ami tiin ayo tangbal kelak o, akiple, ");
INSERT INTO tif_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus ayo tunum tiin bikensu ali abip kaali, kambola dap-tal-fuku dibii yang tikiin tem kabang un-ilomda, mok tik-daala, yak ami tiin diim aba sikil ta yak dap-tal-fuku ayo dik-daala-lomdip: Kapyo! Ti kaldak mafek mafek inang ma atamap elile disa ye? akale ");
INSERT INTO tif_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","tiin baaba-kup bokola ko: Nali mafek mafek ma talalu atamin dinim kebi lale, tunum malo ma iyo itafiibi. Lale, kuliili as ema yo? yakan-kaa-bilila, tal-unebip. Katale, tunum namti kulu tal-unebip kala, kalbi no. ");
INSERT INTO tif_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus almi sikil alep kiita asuk ti kano kulii yak tunum ami tiin diim telala, kulaata tiin dak-daa dotu atam talaalale, Nami tiin kaali, asuk tangbal kep-nulu no, kalba-kup, kulaali mafek mafek alik kiili, tangbal ma itam-kem-salale, ");
INSERT INTO tif_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus ayo tunum kaayo, Dabaali asuk almi am unak o! kala bokola-lomda: Kabi yang abip kaali, Nali tangbal keli no, kala, unang tunum alik iyo kukuyilap titam-laamin daa yo! akale, am una ko. ");
INSERT INTO tif_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kemin, Yesus sole, almi daang bakaalin tunum iso, iyo din Sisaria Filipai abip kaami mepso kaami abip malo ma kaali, yakyak ken-un-bomda almi daang bakaalin tunum imi dik-daaya-lomda: Unang tunum kiili, boko-lom: Kaali kawanta no nakan-kaabip i? kalala imi dik-daayale, ");
INSERT INTO tif_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","isiik bokola-lomdip: Unang tunum ma iyo boko-lomdip: Kaali, oksam ukayin tunum Jon Baptis ata no, ke-biliple, malo ma ita boko-lomdip: Kaali God ami weng ku-fatap-dakamin tunum profet o, kala sawaayak kawu biisa Elaija ata no, takan-kaa-biliple, malo ma ita bokop-ta-lomdip: Kaali, siin sawaalak God ami weng ku-fatap-dakamin tunum ma sawaayak kawu biisa ata no, takan-kaa-bam ke-bam bilip o, akiple ");
INSERT INTO tif_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","nikil ilmi dik-daaya-lomda: Aa, ibi yi? Ibi kaa kawanta no nakan-kaabip i? yakale, Pita ata Yesus ami weng uyo, maan tela-lomda: Kabi fan ti God almi man uldaa-tam-buusa Kraist namti kulu-balap ale, God ami dabaali din unokoma no, kal-bomda Israel-miin numi bokoyila fen-tabasup tunum namti kulu balap o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","nikil imi dukum-kup bokoya-lomda: Ibi tunum maakup ayo ma bokola-lom: Yesus kaali, God ami uldaa-dabuula tiltam Kamokim kesa tunum namti kulu bombe no, kala bakayila-tal-unemin disa kayi! kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kemin, weng kaali, kufo kukuyin-bamda boko-lom: Am ma daanokoma kaali, Dukum Ami Man Nayo, kukup mafak mafak yaapkan angtiil yol kukaap-nin-bilip bombii um-tal daalile, Juda kasel imi kamok kamok so, awem tunum o, kala pris imi kamok kamok so, lo utamsip tunum iso, ita daang ukup-na-lom nitam suun-bamdipla, iyo nam-baalip yak nulmi waasi Rom kayaak imi sikil diim abamnila, ita nelip saaka bombii am alep kelila, am asuum diim kawu asuk tam tiinokomi no, kala-lomda ");
INSERT INTO tif_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ayo weng fatap bokolale, Pita ayo Yesus alakis dibii yang kabangu aba-lom almi taanokoma kaami sang bokoyila kaami kalan kaata, dip-yak saan-bam bakaan-balala, ");
INSERT INTO tif_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesus akal fal-siki ti kaltam daa almi daang bakaalin tunum iyo itafii-bamda, Pita ayo dip-yak saan-bam bokola ko: Kabi nami God ami aket fukunba ultap uta fukunbap disa; waasi Setaan ami kukup altap kaata, kukaap-nambap ale, tawaal diim kalawaami tunum imi aket fukunbip tap uta fanang dakabap kemin, kep-na unan o! aka ko. ");
INSERT INTO tif_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kemin, almi daang bakaalin tunum so, unang tunum tal kulu tekel falabip iso, iyo weng umuuya tal atamipla bokoya-lomda: Dok nolin tunum kapta, naso din nami okok kemin kaata, okok kemon o, kalap namti, yak kaltapni aket fukunin kaata-kup kanumin kaali, kambola-lomdap nami aket kaata, dukum-kup kup-na-lomdap, nami as tiim kawu angtiil yol kuluulokomi ultap ke-lom taanami kulaali, kunola taanami no, kal-bomdapla, kanolin kukup kaata kuluu-bomdapla, tiltamdap nami okok kemin kaali, kutal-fuku kulii-taba balapla yo! kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kanolin kemin, tunum iyo kawanta ma almi angtiil lak kaata suunkup aket uyo kuwa-bom, almi aket fukunin kaata-kup kanum tal-unemon o, kema namti, kaata taan-ilomda maaklo ke-lokoma; kemin ale, tunum ayo kawanta, kuno yang kunu-bili waasi iyo taba-lomdip nelamip, kuno nelamip o, kala-lomda tildang nami lak kaata-kup duu-bom, nami weng tangbal kaata, dukum-kup kutal-fuku kulii-taba namti, kanolin tunum kaata ti suunkup ilokoma. ");
INSERT INTO tif_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ale, tunum ayo ma tawaal kala dik-daa kulaasu kaami mafek mafek kiita, alik faka-bamdale, suunkup bom ilin kaami liip kaali ma kemin dinim kema namti, almi mafek mafek yaapkan kuluu fakaba kaata, taba-lomdip dong dokolokomip ema? Disa! Kaali taba dong dokolokomu dinim te! ");
INSERT INTO tif_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iyo mafek mafek tangbal-kup tabasu inang ma God ami kolala, God ayo bokola-lomda: Kabi suunkup ilokomap o, akokoma nema? Disa! Suunkup ilin kaali, sisol ta kuluu mo-laamin kaami mafek mafek disa! ");
INSERT INTO tif_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Unang tunum yaapkan iyo kukup mafak kaata, kutal-fuku-bamdipla, God ayo daang ukola kela yang banen-umbip kemin, kanta unang tunum imi diim kawu fatom-duk-duu-bom, nami win kaali, bakayin dinim kema namti, am ma daanokoma kaali, Dukum Ami Man Nayo nalmi Aatumen God ami falala-kalin so, ensel atin tangbal tangbal iso, nikil numi talokomup kaali, nasiik tunum kaami win kaali, kufolokomi disa; ali ti disa kayi! aka-lomdi ali dap-kan-tiilokomi no. ");
INSERT INTO tif_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kemin, weng kalawaali tituun-kup tabin weng bokoyokomi kemin, kibi weng san-iliwa! Malo ma ibi taanin dinim bom ilom utamipla yi, Ali tiltam king ke-lomda unang tunum iyo tiin mola kala, kalokomip kayi! kal-bomda Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kemin, am bukupkal uyo talaba toop banule, Yesus ayo taba-lomda Pita so, Jems so, Jon aso, nikil asuumano, ita-kup foko imbiila yak aba tam amdu tikiin aalap batbat ma kawu, nikil ilifin bomdiple, kulaali tunum asuumano kuliiyo, Yesus ayo atamipla yi, Kwin! kaa akal almi kusnum ke-lomda ");
INSERT INTO tif_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ami ilim kaali, atin ti ibin namaal tap, tiin buluusi so, kelala atamip. Kemin, tawaal diim unang kalawiiyo, dok no-lom ilim ma diing daa-lomdip ilim kaa namaalim tiin buluusi so kelamu dinim. ");
INSERT INTO tif_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kemin, nikil iyo atamipla, tunum alep ma sawaayak bom-biisip kiili, Elaija so, Moses aso iyo asuk abiil tikiin kela tildaak tilip Yesus aso, weng bakabip kala, itabip-kup, ");
INSERT INTO tif_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pita nikil iyo suunin dukum ke-bamdipla kemin, Pita ata fanang daa-lomda, Kaata kanimin weng ma bokolokomi ni? ke-bamda kulaata Yesus ami bokola-lomda: Numi kukuyin kapyo! Yaap ke kapso tal kalawu bom-bulup kemin, nikil nuli kiin-laap am asuumano aye ma ema de-lomduwa, ma kaata kapni, ma kaata Moses ami ale, ma kaata Elaija ami ke-lom de-yum o, kal-bom kemale, ");
INSERT INTO tif_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","tam ibin uyo tildaak tilnong mo-imaalule, ibin tem kaptam weng ma boko-lomda: Kipyo! Kaali ti nami aket-iip Man kemin, ibi ami weng bakama uyo ti weng san-kaa-bamdipla yo! kalale, ");
INSERT INTO tif_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","iyo suunbii abiltap-kup tiyak daalipla yi, Tunum alep iyo maaklo kelipla Yesus ata-kup bom ila atamip ko. ");
INSERT INTO tif_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Atamipla, Yesus nikil iyo amdu tikiin ayo, kela tal-bom ale, Yesus ayo almi daang bakaalin tunum nikil asuumano iyo weng kaali, dukum-kup bokoya-lomda: Nak-tunum kusal kipyo! weng san iliwa! Ibi din tunum kusnum kayak kayak kiimi diim ayo, kanolin atamip kaami sang uyo ma bakayin dinim kayi! Kano ti bom-bilipla bii, Dukum Ami Man Nayo, taanila, nam-bii din namaalip bii, tam tiindi tambani kala, kala-somdiwa kabaku yaap, unang tunum kayak kayak iyo bakayin o, kala kanum bokoyale, ");
INSERT INTO tif_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","nikil iyo kanola atamip kaami sang kaali, bokolamip dinim; ti yawaal daa-lomdip Yesus ami weng, Saakni namaalip sindi asuk tam tiinokomi no, kala kaami miit kaata fen-bam atamum o, kal-bomdipla fenip ko. ");
INSERT INTO tif_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kemin, nikil asuumano iyo weng kusnum ma Yesus ami dik-daala-lomdip: Lo utamsip tunum ili kanimin o, kala boko-lomdip: God ami profet o, kala weng ku-fatap-daa bakayin tunum Elaija sawaayak kawu bombii taansa asiik talale, God ami uldaa-dabuula tiltam Kamokim kesa tunum ata mafiing tem kawu talokoma no, ken-umbip i? akiple, ");
INSERT INTO tif_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Yesus asiik bokoya-lomda: Kiimi weng ma boko-lomdip: God ami uldaa-dabuula tiltam Kamokim kesa tunum ayo tilin dinim bom ilala, Elaija asiik tal unang tunum iyo dong dokoyilala, imi aket tem kaali, dotmipla, talokoma no, ken-umbip. Kaali tifan bakan-umbip kemin, ibi weng san iliwa! Kaami miit kaali, dotu bokoyon. Elaija ayo ti talse. Katale, tunum ilmi aket kaata-kup fukun-bamdiwa, aalip taanse. Kemin, sawaayak God ami Sukon Tem dola kutiisip kaali, kulu tifan tiltam talsu. Kata, God ami uldaa-nam-buula tiltam Kamokim kesi nami sang kaali, sawaayak kawu, weng ma kaa dola kutii-lom, Ita kukup mafak mafak kiili Dukum Ami Man ayo, kolip angtiil yol awak dukum ale, mok baan kamaalokomip o kala, dola kutiisip. Kemin, kanimin o, kala ibi kaami aket kaali, fukunbip dinim i? kala Yesus ayo Jon Baptis ami sang kaata kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kemin, Yesus nikil iyo yakyak taldaak daang bakaalin tunum malii ma keyila umbip imi diim taldaak abom e; unang tunum yaapkan iyo nikil imi diim kaptamu tala-tala-keliple, lo utamsip tunum malo ma ita daang bakaalin tunum malii ma iso, weng aal dikibip kala, kala tildaak itamiple, ");
INSERT INTO tif_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","unang tunum kuliiyo, talaalipla, kwin! Yesus ayo kala tala kala, kala-lom fanan-bi-lomdip abiltap din weng fakaliple, ");
INSERT INTO tif_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","asiik almi daang bakaalin tunum iyo dik-daaya-lomda: Ibi kanim kalan ma iso weng aal dikibip i? yakale ");
INSERT INTO tif_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","unang tunum kulu tiinaabip imi tunum ma asiik boko-lomda: God ami weng kukuyin kapyo! Nami man tunum ayo sinik mafak ta del bak-daansa. Kemin, asuk dok nolin diim kawu, sinik mafak kaali tal nami man kaami tal faalna kaali, dap-tal-fuku dabaala daak tawaal aba-lom mok daban-kup baktam-baktam-bamda, kiil eng-kup dilit-dalat-bamda, ami angtiil kaali kaluung alik dip-yak tela-lomda kanun-umba kala, kalalila dibii-tal uliyi, Kabi disa kelap kala, kalalila, kapni daang bakaalin tunum imi bokoya-lomdi: Kipta, sinik mafak kulaa fotabamnip yak banak o, yakan-kaabi. Katale, faneng titil-foko fotabamnip yak banoma dinim kelip o, kala ko. ");
INSERT INTO tif_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kemin, Yesus asiik almi daang bakaalin tunum so, unang tunum kulu tiinaabip iso, imi bokoya-lomda: Kwin i! Ipni aket fukunin uyo atin fan tituun kelin disa kawi! Nali kipso bom bii kayoop yaapkan dak-duusi. Kata, ibi nitamiwa yi, Kaali God ami titil kaata kuluu-lomda sinik mafak iyo fotabamna yak banen-umbip kala, naka-laabip disa. Nali ipso bii, am kanim kal kelila natamiwa yi, Ali ti God ami titil kaali, nokol ti kuyama no, nokokomip i? Nali kipni aket mafak fukunbip kaali, daal kep-namba kemin, man tunum ayo dibii-tilin o, yakale, ");
INSERT INTO tif_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","iyo dibii-tal atamipla, sinik mafak ayo Yesus ayo atam-ilomda abiltap man ayo dap-kula mo dabaala unba talba kemsi, dabaala daak tawaal diim aba fal-siki-du-siki-ke-bamda mok daban-kup baktam-baktam ma ko. ");
INSERT INTO tif_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kemin, Yesus ayo man kaami aalap ayo dik-daala-lomda: Man kalawaali kanu bi-lomda kayoop kaali, kanim kal ma duk-duusa ni? akale ");
INSERT INTO tif_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","asiik bokola-lomda: Sawaayak man katip kabaku kanum talan-umba kemin, suunkup sinik mafak kaali, taba man kaayo dap-mafak-daalon o, ke-bamdala an-kulaala yak wing tiil une-bam ale, wok kumun tem une-bam ken-umba. Kemin, kanola kapyo! Ti dong dokolamap namti, nuyo olen-daaya-lom dong dokoyan o, kala, ayo kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus asiik bokoya-lomda: Kapyo, kapni bokop-na-lom: Kabi tifan dong dokolamap o? nakap kaali yi? Dok nolin tunum ata ma fanang daala yi, God ayo ti kulaali, kunolama no, kema namti, yak mafek mafek alik dik-daala kulaali, God ayo ti kunolama no yakale, ");
INSERT INTO tif_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","man kaami aalap ayo wol-bamda boko-lom: Nili God ayo kalawaali kunolama no, kalbi. Lale, da katip ma fanang-dakabi kemin, dong dokop-napla, sakbaalkan keluk o, kalale ");
INSERT INTO tif_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus ayo talaala yi, Unang tunum iyo tunum kaami fuutba kaali, weng sanbip-kup abiltap tala-tala-kemip itaba-kup, sinik mafak ayo fuut kaan-bamda bokola ko: Sinik mafak taba-lomdap kabi man kalawaayo del kola kutenbap-kup ale, sikil ta talang tem akensap kemin, nali titil tabin weng ma bokop-ton o, kali kemin, weng san ilawa! Man kaayo, kambola yak banan o, kala-somla kemin, asuk maso ma talaba yak ami tiling tem kaali, unemin dinim o, aka-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","sinik mafak ayo fuut-bamda, man ayo dukum-kup dabaala unba-talba-ke-bamda kambola tiltam banale, man ayo tiin tip-daa kelale, unang tunum yaapkan iyo boko-lomdip: Daak man kulaa, taana te! ke-bam bakamiple, ");
INSERT INTO tif_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesus ayo daak sikil kabaku dap-tal-fuku kufola tam tiina ko. ");
INSERT INTO tif_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kemin, ilanin tap ke, Yesus so, almi daang bakaalin tunum iso, ilifin tam am tiin-ilomdip, Yesus ayo dik-daalip: Kanimin o, kala nuli titil-fak-daa sinik mafak kaa fotabamnup yak banin dinim kela ni? kala, kanum bokolipla, ");
INSERT INTO tif_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus asiik bokoya-lomda: Yak mafek mafek kusnum kaali, kanola-lomdip God ami beten kamalin dinim kelip kaali, kanolin sinik kaa dok kano-lom fotabamnip yak banokoma dinim o, kala kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Kemin, Yesus nikil iyo bokon kaa kambonbip-kup, daak aba unbiyang Provins Galili kaami liip kawu yang ababip-kup, Yesus ayo unang tunum iyo weng sandip nitamum o, kala, tala-tala-kemin dinim ke-lom nikil nulufin bomdupla, nalmi daang bakaalin tunum iyo kukuyon o, kala-lomda daa kasen-kasen tal-une-bomda almi daang bakaalin tunum iyo kukuyin-bam bokoya-lomda: Kipyo, mepso kelu kemin, nak-tunum ma ayo aket fal-siki-lomda Dukum Ami Man Nayo, nam-fatap-daa-lomda nam-baala yak waasi imi sikil diim abamnila, ita nelip taanila, nim-bii din namaalip bom bii, am alep ke-lomdi, am asuum diim kawu, asuk tam tiinokomi no, kal-bom kukuyin-bam bakaya. Kata, ");
INSERT INTO tif_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","nikil iyo ami weng bakayinba kabak-ali talalu bam-daa utamin dinim ke-lom suun-bamdipla, kaami miit kaali ma dik-daalin dinim kelip ko. ");
INSERT INTO tif_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kemin, Yesus nikil iyo dak-daa kulii-daak aba toop Kapeneam din aba-lomdip, tam am kawu tiin-bom, nikil imi dik-daaya-lomda: Kibi liip tilip kaali, kanimin sang kaata bokola-sala bokola-sala-ken-tilip itami ni? kal-bom dik-dakaya. Lale, ");
INSERT INTO tif_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","yikil fanang daalipla, Numi liip tulup kaali, nikil nokol kawanta ma numi kamokim ke-lokoma ni? kala-sala kala-sala-ke-bam weng aal dikin-talabup kala, kalbip-kup, nikil iyo fatom-dap-tiiyulala weng dulumnip. ");
INSERT INTO tif_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kemin, Yesus ayo daak tiinba-kup, daang bakaalin tunum talangkal iyo weng umuuyila tal atamipla bokoya-lomda: Kanola tunum iyo, nita God ami tiin diim kaali, kamokim kelon o kala namti, kaali almi aket fukunin kaa kambola-somdala, unang tunum alik imi dong dakaayin tunum keba-kup ale, ami bon tem tii kaltam daa ilin tunum ke-lomdala yo, kalba-kup ");
INSERT INTO tif_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","man katip ma dabii tildang nikil imi iipyak tem kabaaku dap-tal miki-lom nikil imi bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Dok nolin tunum ata man kala-waaltap ayo ma atam-ilomda, Yesus ami win diim kawu, man kalanolin man kaali win sono, kala-lomda dong dokola namti, kaali nami dong dakaap-nin kukup namti kulubu. Ale, God akal nam-baala talsii kemin, kanta nami dong dokop-na namti, kaali nami dong dakaap-nin kukup kaata-kup disa; kemin, kaali tifan, God ami dong dakaalin kukup namti kaa bombu no, kala, Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kemin, Jon ata Yesus ami bokola-lomda: Numi kukuyin tunum kapyo! Nikil nuli tunum ma atamupla, Ali kapni win kaata, kufo-lomda sinik mafak iyo fotabamna yak bane-bilip kawu, nuli atamupla, Ali kapni daang bakaalin tunum kelin dinim bomda kanolin kaali, kanuba kala, kala-lom nuyo bokola-lomdup: Kapni disa kawu Yesus ami win kufon-bam kanubap kaali kambolan o, kala dil molup o, akiple, ");
INSERT INTO tif_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesus asiik bokoya-lomda: Kanola tunum ayo ma nami win kaata kufo-lom mafek mafek akal alik kusnum ma dotula namti, ali ilomda dok no-lomda weng mafak kaa kup-nokoma dinim; kemin, kibi kaa kulaalan o, akan-kaamin disa yo. ");
INSERT INTO tif_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kemin, dok kanolin tunum ata, nulmi waasi kamayin dinim kela namti, numi nak-tunum kela kemin, kibi kaa kulaalan o akan-kaamin disa yo. ");
INSERT INTO tif_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ale, dok nolin tunum ata ma itam-ilomda, Awu, ibi Kraist ami tunum o, kala-lomda dong dokoyon o, kala, wok kaali iluya inamnip namti, God akal tunum kaami kukup kaa kanola kaali, utam boko-lomda: Kaptum wok ilolap kaami kukup kaali, katip sakap lale, kaali tangbal ma kanowalap kemin, nali fiyaap duubi no kala-lomda, akal kukup tangbal kaali, fan maan telokoma no kala, Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kemin, Yesus ayo asuk bokoya-lomda: Kusnum kayak kayak iyo utamiwa yi! Tunum ayo unang tunum God ami lak duu-yilin katip katip kebip imi yam-mafak-daalon o, kem-tabon o, kala ata-mokomip namti, tuum dukum ata ma kuluu kuyak tunum kaami kum kun diim kabaku sok de-lom dabaalip daak yol ok kumun tem una namti, wok ta an-dong-dokola taanala, bi-lom God ayo yol katip ma uyo kolokoma. Ale, kanola kayak kayak iyo tunum kaa kanolin dinim ke kambolip, unang tunum God ami lak duu-yilin katip katip kebip iyo yam-mafak-daa kela yang kukup mafak uyo nuumip namti, God asiik atin ti kaami yam-mafak-daala kaami maan uyo kolaya, tunum ayo atin angtiil yol awak dukum uyo daka-mokoma. ");
INSERT INTO tif_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ale, fanang daalawa yi, Nalmi sikil ta nim-bii yang daalu, kukup mafak kaali kemon o, kalbi kala, kalap namti, kaltapni sikil malii kaali, ukduu kulaalap una. Sikil malii maakup ma ke-lom, kukup mafak uyo kambola bombii taandapla tam God ami abip kawu suunkup ilokomap kaata, atin ti tangbal; kemin ale, kabi sikil malii kaayo, ukduu-lom kukan-tiilami dinim o, kala kukup mafak kaata-kup kanubi taanaple, God ami ensel iyo tam-baalip din wing suunkup kiinin abip unokomap kaali, tangbal disa; kemin ");
INSERT INTO tif_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","abip kaali wing kaa ten-laamin dinim; ale angtiil diim amnom-miin kiili, disa ke-laamin dinim kemin kanolin abip kaata. ");
INSERT INTO tif_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ale, kanola fanang daalawa yi, Nalmi yaan uyo nam-bii din daalula, kukup mafak kaali, kemon o, kalbi kalap namti, kaltapni yaan malii kaali, buk-duu kulaalap unula, yaan malii ma maakup ke-lom kukup mafak uyo kambola bombii taan-ilomdap tam God ami abip kawu suunkup ilokomap kaata, atin ti tangbal; kemin ale, kabi yaan malii kaayo, buk-duu kukan-tiilami dinim o, kala kukup mafak kaata-kup kunubi taanaple, God ami ensel iyo tam-baalip din wing kiinin abip unokomap kaali, tangbal disa; kemin ");
INSERT INTO tif_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","abip kaali, wing kaa ten-laamin dinim; ale, angtiil diim amnom-miin kiili, disa ke-laamin dinim kemin kanolin abip kaata. ");
INSERT INTO tif_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kanolin ultap kemin, kanola fanang daalapla yi, Nalmi tiin kaali, kukup mafak uyo kukup-nam-bulula, kanumon o, kalbi kalap namti, kaltapni tiin malii kaali, ulduu kulaalap unula kewa-lomdap, tiin malii ma maakup ke-lomdap kukup mafak uyo kambola bombii taan-ilomdap tam God ami abip kawu suunkup bom ilokomap kaata ti tangbal; kemin ale, kabi tiin malii kaali, ulduu kukan-tiilami dinim o, kala kukup mafak kaata-kup kanubi taanaple, God ami ensel iyo tam-baalip din abip mafak unokomap kaali, tangbal disa; kemin, ");
INSERT INTO tif_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","abip kaali, wing kaa ten-laamin dinim; ale angtiil diim amnom-miin kiili, disa ke-laamin dinim kemin, kanolin abip kaata. ");
INSERT INTO tif_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kemin, ibi nami weng kaa kukaayinbi kaali, weng san iliwa! Titil weng o, kala kibi suunbip. Lale, faneng weng kaali, tituun kemin, alik kawanta nami lak duulip namti, God ami aket fukunin kaali, Tangbal-kup kukuyin-bilila, nalmi weng kaata-kup weng san-kaa-bamdip, tiltam titil-fak-daalin o, kala-lomda awak-aalap imi man babon-bilip ye-bam aye, ke-bilip kukuyinbip ultap ken-umba ko. ");
INSERT INTO tif_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yol kaali abaal-kup tabin kemin, balaalapla, ima iyo abaal tabokomu. Lale, kanola yol uyo abaal tabin dinim kelu kaali, kabi dok kano-lomdap dotulapla, kaami abaal kaali tabokomu ni? Kaali atin dinim o. Ibi yol ultap kemin, kanola ibi weng aal diki-bam, nikil nuli kawanta nulmi kamokim ke-lokoma yoko? kala-sala kala-sala-ke-bam weng aal dikimip namti, kaata taba kipni kaptum kusal dong dakaayin kukup tangbal kaali, dik-daa kulaalu daak aba disa ke-lokomu. Kemin, kanola weng aal dikimin dinim ke-lom, kiltipni kaptum kusal iyo aket balili-kalin kukup kaata-kup kukaayin-bamdipla yo, kalba-kup, Yesus ata almi daang bakaalin tunum iyo bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kemin, Yesus ali bokon kaali, kambola wok Jodan kawu yakan yak malii ababa-kup, daak aba din Provins Judiya kaami anung kawu din abale, unang tunum yaapkan iyo asuk Yesus ami fanang tala-tala-kemiple, almi kanola unang tunum suunkup kukuyin-bam laaba ultap kaata kano kukuyin-balala ilip. ");
INSERT INTO tif_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kemin, Falosi malo ma iyo tal Yesus ami kasenolupla, weng mafak so ma bokola kala kala-lomdup dibii-din weng talalmin baan diim daalum o, kala-lomdip iyo tal dap-kuku-bamdipla dik-daalip ko: Kapyo, Moses ami lo numi kuyinsa kaali kanimin o, kalsu ni? Uyo boko-lomdu: Tunum iyo almi kalel uyo kambowon o, kala kaali, fotabokoma kaa tambal o, kalsu nema? akiple, ");
INSERT INTO tif_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus asiik bokoya-lomda: Moses ali dok kanolin lo kaata kipni kuyinsa ni? yakale, ");
INSERT INTO tif_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","isiik bokolip ko: Moses ayo tunum kaali, kambolala akal kalel kambo-wa-laamin kaami sukon kaali, dola-lomda ami kalel uyo kuwa-lom kawu fotabemin o, akipla ");
INSERT INTO tif_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus ayo bokoya-lomda: God ata tunum dabuulu unang kuluula kemin, kaami lo kutiisa kaali, kipni kawil-fakal so, kipso, ibi weng sanup dinim o, kalbip kala, kala-lomdala kemin, Moses ayo kanola kipni lo kaali dola kutiiyinsa. ");
INSERT INTO tif_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lale, kamosinim God ami mafek mafek alik talalu kutiisa kawu, imak so, ikis so, talalu-yim-tiila akam maakup ke-bom biisip. ");
INSERT INTO tif_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kanolin kemin, God ami Sukon Tem uyo kaami sang kaa boko-lomdu: Akam maakup kesip kabaku tunum ayo unang kuluulokoma kawu, tunum ayo almi awak-aalap iyo kamboyimba-kup, akal almi kalel umi diim kabaku fep-nala kawu, akam maakup ke-lokomip o kalale, ");
INSERT INTO tif_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","akam iyo angtiil maakup tap ke-lokomip o, kalsu. Kemin, asuk maso ma alep ke-lokomip disa; atin akam ili ti maakup ke-lokomip. ");
INSERT INTO tif_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kemin, God ami tunum so, unang so, kulii-tala-tala-kelaya, akam maakup kebip uyo, tunum ayo ma akam imi angtiil maakup kebip uyo, lolala, kela yang-bana tildang-bana kemin disa yo, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kemin, Yesus nikil iyo asuk tam am aba-lomdip almi daang bakaalin tunum iyo weng kaami sang kaali, dik-daaliple, ");
INSERT INTO tif_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus asiik bokoya-lom: Kanola tunum ayo ma almi kalel uyo kewa yang unang kusnum ma kuluula namti, God ami tiin diim kawu, kaami kanola kaali, sadiki-bamda almi kalel uyo ti daang ukuwa-bom ku-mafak-dakaba kala kalokomale, ");
INSERT INTO tif_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","unang ukol kanola ulmi imak ayo kela yang tunum kusnum ma dabuulu namti, God ami tiin diim kawu, kuumi kanolu kaali, sadiki-bamdula, ulmi imak ayo ti dap-mafak-dakabu kala kalokoma no, kala, Yesus almi daang bakaalin tunum iyo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kemin, awil-fakal unang tunum malo ma iyo Yesus ata taba-lom sikil kulii yak numi man imi angtiil diim kawu tiiya dong dokoyala, tangbal-kup fusuulin o, kala-lomdipla, kulii-tilip. Lale, Yesus ami daang bakaalin tunum iyo awil-fakal iyo fotabamnup tabanik o, kala katiiyiple, ");
INSERT INTO tif_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus ayo talaalala, Iyo kanubip kala kalba-kup, aket atul kelule, daang bakaalin tunum imi bokoya-lomda: Unang tunum ili fanang daaliwa yi, God ali, nuli dong dokoyokoma kala kalalip tiltam God ami miit tem talebip iyo, man katip katip kala bilip ililtap kemin, ibi man kiili fotabemin dinim; kamboyip nami fanang tilin o. ");
INSERT INTO tif_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nami weng kala bokoyili kaami miit kaali, tifan bokoyokomi kemin, weng san iliwa! Man iyo katip katip bom-bilip kiita, awil-fakal iyo mafek mafek ma kuyum o, kalokomip kaali, man kiili maaklo yak awil-fakal imi sikil diim kaali, kuluulokomip dinim; kanolin ultap, unang tunum kawanta God ami miit tem kawu unum o, kalip kaali, kamboyiwa, God akal dong dokoyalala, God ami miit tem kawu tildang talokomip; kemin ale, unang tunum kawanta ilmi aket kaata-kup fukun-bam kukup mafak nuumum o, kalip kaali, ilmi san kemin, atin ti God ami miit tem kaali, tildang talokomip dinim o kala-lomda, ");
INSERT INTO tif_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","yak man katip katip iyo yim-tal miki-lomda, sikil umkaayin-bam bokoya-lom: God ayo kibi ti kukup tangbal-kup kukaayilak o, kala bokoya yakyak kema ko. ");
INSERT INTO tif_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kemin, Yesus nikil iyo daak aba yang liip kulu uniple, tunum ma abiltap tal Yesus ami miit tem kawu tal-ilom, kamok kamok imi weng umkaayin kaali, kanumin kemin, tilik duung fakela daak tiin-ilom dik-daala-lomda: God ami weng kukuyin tunum tambal kapyo, kabi nali weng ma kemin, dik-daap-tila, kapyo bokop-napla, nali ti utamon. Nali dok kano-somdila, tiltam suunkup ilin tunum ke-lokomi ni? kala dik-daalale, ");
INSERT INTO tif_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus asiik bokoya-lomda: Kabi kanamin o, kala bokop-na-lomdap: Kabi tunum tangbal o, nakap i? Tunum tangbal ayo ma bombe dinim; ti God maakup ata-kup tambal-kup tabin kemin, kabi kanimin o, kalalap: Kabi tunum tambal o, nakap yoko? ");
INSERT INTO tif_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kapkal kabak utamsap kemin, lo uyo boko-lomdu: Kabi tunum unang kii, anulap taan-yaamin disa; kalapni kalel kuu, kewa unang kusnum so, sidikimin disa; kabi yukut inin dinim; kabi disa ibaka-balap, soldiya iyo kaptum kusal kii sok dinayin disa; kabi ibaka-bam kaptum ami mafek mafek kaali, fakamin dinim; kabi kaltapni kawil-fakal imi weng uyo kuyang saak tiimin daa; ti imi weng kaata, weng san-kaa-bam ale, kukup tangbal kaata-kup kukaayin-bam keman o, kala lo uyo kanum bokosu no, kala kanum bokoyale, ");
INSERT INTO tif_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tunum kasiik bokola-lomda: Kwin, nali sawaalak man katip sakap kaptoowu, yakyak kulii umbital tunum aalap dukum keli kaali, God ami weng kaa kutiiyinsa alik kiili, weng san kan-tabasi no, akale, ");
INSERT INTO tif_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus ayo tunum ami atam-ilom atin ti aket kola bokola-lomda: Kulaali kanun-umbap. Lale, kabi kukup maakup ma kaata-kup kanun-umbap disa; kemin, kabi dindap kaltapni mafek mafek kiili, kaptum kusal imi kuyilapla, ita moliwale, kaami moni kaali, kuluu-lom kulii-din unang tunum iiwaan imi kuyokomap kaata, din God ami abip kawu suunkup tangbal ilokomap. Kemin, kano-lomdapla, kabi talawa, naso tal-une-bam, God ami okok kem-tal-unemum o, akale, ");
INSERT INTO tif_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","tunum kaali, mafek mafek soyim kemin, Yesus ami weng bokoya kaali, weng san-ilomdala, aket fuku daalala yi, Atin suunkup ilin tunum kelon o, kalbi. Lale, nami mafek mafek kiili, yaapkan kemin, kuno keyokomi disa yo, kala-lomda aket uluum dap-teluya, Yesus ayo kambola una. ");
INSERT INTO tif_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kemin, Yesus ayo fal-siki-lomda almi daang bakaalin tunum imi bokoya-lomda: Kwin! yak mafek mafek soyal unang tunum kii, ti fiit-bamdip, (imi mafek mafek sikip fak-dakan-unsip iyo kulaalokomip kemin, malo ma kiita-kup God ami aket kola-lomdip,) tiltam God ami miit tem tam unokomip o yakale, ");
INSERT INTO tif_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","daang bakaalin tunum iyo Yesus ami weng kaali, weng san-ilom fanang alik uneyu kala, kalba-kup, Yesus ayo weng kaali, asuk bokoya-lomda: Man kipyo, unang tunum iyo tiltam God ami miit tem tiltam tulum o, kalbip kaali, fiitmin kayi! ");
INSERT INTO tif_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ale, olti dukum ma kamel uyo tam men sil ami tem kaa tam unon o kalu kaa, fiit-bi-somdula tam unokomu. Ultap kemin, yak tunum bung kayaak ali atin ti fiit-bi-somdala kawu, tam God ami miit tem tam unokoma kayi! kala bokoyilale, ");
INSERT INTO tif_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","nikil iyo atin fanang alik uneyule, Yesus ami bokola-lomdip: Kapni kanum boko-lom: Bung kayaakim ayo fiit-bi-somdala, tiltam God ami miit tem kaa tiltam talokoma no, kalap kaali, faneng namti, mafek mafek dinimal nuli dok kano-somdupla, tam God ami miit tem uyo tam unokomup i? Kaa fan taang-kala tam unolup daa yo, akiwale, ");
INSERT INTO tif_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus ayo ilmi tiin diim kulu tiin dik-yak diiya-lom bokoya ko: God ata ti mafek mafek alik kiili, kanolama. Lale, tunum alafin kela kaali, taang-kala-somdala tiltam God ami miit tem kaayo, tiltam talokoma dinim; kemin, God ata taba-lomda dong dokolokoma kawu, ayo tiltam God ami miit tem tiltam talokoma no yakale, ");
INSERT INTO tif_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita asiik boko-lomda: Kapyo, weng san-ilawa! Kapni daang bakaalin tunum, nikil nuli nulmi abip so, nulmi mafek mafek so, kiili alik kela-lomdupla, kapni okok kemin kaata, ke-bam kapso tal-unebup o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus ayo bokola-lomda: Weng kalawaali tifan bokoyokomi kemin, dok nolin unang tunum kiita nami lak kaali duu-lomdip, nami weng tangbal kaali, kulii-din unang tunum iyo bakayon o kala-lomdip, imi am aye, fik aye, nakal aye, almi unang aye, awak-aalap aye, man aye, ima lang aye, kaali, kambola-lomdip tal nami okok kemin kaata, kutal-fukulip namti, ");
INSERT INTO tif_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kamala tawaal diim kalawu bom-bilip kawu, nami okok kebip kaami kalan kaata, tunum kusnum ita fuut-kaayin-bam aye, ye-bam aye, ke-mokomip. Lale, kibi am kusnum aye, fakal-nakal aye, unang aye, awil-fakal aye, man aye, ima lang aye, almi-kup wan handret (100) kiita-kup kuluulokomip. Kemin, am ma daanala, tam abiil tikiin ilokomip kaali, kawu suunkup bom ilokomip. ");
INSERT INTO tif_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kemin, unang tunum yaapkan kamala kaami win soyal bom-bilip iyo kaptoop kaptoop kawu, isiik win dinim keliple, win dinim ke-laabip isiik am ma daanokoma kaali, win so ke-bom ilokomip o, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kemin, Yesus so, almi daang bakaalin tunum iso, nikil iyo din abip diil Jerusalam met unum o, kala un-bomdip, Yesus asiik dusiin daa umbabale, almi daang bakaalin tunum ita daang tem un-bomdip bokolip: Kwin! kaa din itamupla nuyo yelokomip kawe! kal-bomdip ilmi aket tem-kup fanang daa umba-biliple, tunum kusnum nikil imi daang tem tababip iyo suunip. Kemin, Yesus almi tunum talangkal ita-kup ulduu kulii yang kabangu almi am ma daanokomu kaali, tunum ita taba-lomdip kanuyokomip kaami sang kaata asuk bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kipyo, Jerusalam kamet banum o, kala talabup kemin, din kawu bom-bulupla, nak-tunum ma taba-lomda, Dukum Ami Man Nayo, nim-bii din tunum awem o, kala-laabip pris imi kamok kamok so, lo utamsip tunum iso, imi diim daalale, yikal weng taken-bamdipla, tunum kaayo aalip taanak o, naka-lomdipla, nam-baalip yak Rom kasel imi sikil diim abamnila, ");
INSERT INTO tif_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ita taba-lomdip, atafiimin weng mafak bakaap-nan-bamdip, mok kaali, nami angtiil diim kawu, tik-tiip-nam-bam, sok faklet ta kuluu ne-bilip bii taani, namaalip bombii am alep ke-lomdi, am asuumano diim kawu asuk tam tiinokomi no, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kemin, Sebedi ami man alap Jems so, Jon so, iyo tal Yesus ayo bokola-lomdip: Numi kukuyin kapyo, alep numi aket fukunin kaali, mafek mafek sang ma kaa bokop-tokomup kalawaali kalanolan o, kebup o, akiple, ");
INSERT INTO tif_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","asiik alap imi bokoya-lomda: Alap ibi nali kanamin kaata ma kanolan o, nakan-kaabip i? kala, kanum bokoyale, ");
INSERT INTO tif_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","alap isiik bokola-lomdip: Ilom kabi tiltam king ke-lokomap kawu, alap nuta keyapla, ma ata tal kaltapni tingtuplo kabangu tiina, ale ma ata tal kaltapni awaanlo kaldangu tiina ke-bam kabi dong dakaap-tin-bam ke-bulupla, nikil nuta unang tunum iyo tiin molum o, akiple, ");
INSERT INTO tif_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus asiik almi angtiil yol kuluulokoma kaami sang kaali, alep imi bokoya-lomda: Alap kipni dik-dakabip kaami miit kaali, ibi talalu bam-daalin dinim kebip kemin, kukup mafak ma kayak kayak ita taba nami kup-nokomip kaali, kipkal saak nuso kuno kuluu kanolamup o, kalbip ema? Ale, nami angtiil yol awak kuluu-lomdi taanokomi kaali, kipkal ti kaali kuluu um-tal daa-lomdip saak-namip o? kala kanum bokoyale, ");
INSERT INTO tif_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","alap isiik bokola-lomdip: Aa, alap nuli ti kanolamup o akiple, Yesus asiik bokoya-lomda: Fan kemin, kibi nami kukup mafak kaa kup-nip um-tal daa-lomdi taanokomi ultap kanolokomip. ");
INSERT INTO tif_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lale, kaa nami ok tabukla tunum ulela-lomdi kamokim ami abiin baan nami mepso bombuu uyo yim-tiilokomi dinim; kemin, kaali God almi mafek mafek kemin, akal tunum kii ulelsa. Kemin, ita yim-tam tiilala, ita taba dong dakaap-nim-bilipla, unang tunum iyo tiin molokomup o, kala kanum bokoya. ");
INSERT INTO tif_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kemin, Yesus ami okok kemin tunum nakalkal iyo Jems so, Jon so, alap imi weng kaa bokolip kaami sang kaata weng san-ilomdip, nikil iyo alap imi aket atul kuyipla, aket atul dap-tiiyule, ");
INSERT INTO tif_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus ayo nikil iyo naan-daaya alik tal atamipla ayo bokoya-lomda: Kipyo, kipkal atamsip kemin, tawaal diim kaami God ami lak duulin dinim unang tunum imi kamok kamok ita, unang tunum iyo kalaang weng kaali, kukaayin-bam ale, ilmi aket fukunin weng kaata-kup, kukup mafak ayo kukaayim-bam ken-tabasip u, kalsip. ");
INSERT INTO tif_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lale, nami lak duulin ipyo, kiimi kukup kaa kanun-umbip kaali, kipsiik dik-daa kuluu-lom kanumin dinim; kipni tunum iyo dok ata nita nak-tunum kusal imi tiin diim kaali, tiltam win tabin kelon o, kala namti, ali almi win kaali, kufumin dinim; balili-kup kala-lom kaptum kusal imi minlo tem un-bom ilokoma kaata, tangbal; kemin ale, ");
INSERT INTO tif_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","kipni tunum ayo kanta nata nata ke tiltam naktum kusal imi kamokim kelila yo, kala namti, ali alik kipni dong dakaayin tunum ke-lokoma kaata, tangbal o. ");
INSERT INTO tif_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kemin, Dukum Ami Man Nali, tawaal diim kalawaali disa kawu tal tiin-bom-bilila, tunum ita nami okok kamaap-nin o, kalalila talsii disa; nali taldila dukum-kup okok-bam unang tunum iyo dong dakaayon o, kalalila talsii. Kaali, nali tal-ilomdila kuno, keyilila waasi ita nelip taanokomi kawu, unang tunum yaapkan imi iliim kaali, boyilile, kiiyo tiltam God ami man kelip suunkup ilin o, kalalila talsii. Kemin, kibi nami unang tunum dong dakaayinbi ultap ke-bamdipla yo, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kemin, Yesus nikil iyo dak-daa dabii-din abip Jeriko din ababip-kup, Yesus sole, almi daang bakaalin tunum so, unang tunum yaapkan iso, iyo Jeriko kaali, kambola unum o, kemiple, Timeas ami man Batimeus ayo tiin bikensu kemin, mafek mafek uyo naan-bam ken-umba ayo liip balang diim kabaaku tiinba. ");
INSERT INTO tif_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kemin, weng ma weng sanala yi, Abip Nasaret kayaak Yesus ata talaba no kalbip kala, kalba-kup, naan-bamda boko-lom: King Devit ami man loop Yesus kapyo, kabi nali olen-daap-na-lom dong dokop-nan o! ke-bam naan-balala, ");
INSERT INTO tif_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tunum yaapkan iyo, Dulumnan o, kal-bom fuut-kaanbip. Lale, ali ti kano dukum-kup ti naan-bam bokola: King Devit ami man loop kamokim kapyo, kabi olen-daap-na-lom dong dokop-nan o, ke-bamda naanin-kup ke-balale, ");
INSERT INTO tif_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus ayo kawu duluuma tola-lomda, kayak kayak imi bokoya ko: Bokolipla talak o! yakale, tiin bikilin ayo naan-daala bokola-lomdip: Balili-kalbap-kup tola talan o, akiple, ");
INSERT INTO tif_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ilim sakbaalim dukum ma kuluu mikiba uyo dulduu kukulu tii abiltap-kup tola-lomda, Yesus ami fanang din atamale, ");
INSERT INTO tif_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus ayo dik-daala-lomda: Kabi kanamin ma nop-nak o, kal-bomdap naap-nanbap i? kala kanum bokolale, tunum tiin bikensu asiik bokola-lomda: God ami weng kukuyin tunum kapyo, nami tiin ayo baap-nalapla, mafek mafek kiili, itafiimon o, kal-bomdi naap-timbi no, akale, ");
INSERT INTO tif_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus asiik boko-lomda: Nali utamila, Kabi, fan nam-talalulama no! nakap kala, kalalila kemin, tam-talaluli asuk tangbalnap kemin tiin baa mafek mafek iyo talalu itaman o, aka-laam-salale, abiltap-siik ami tiin uyo tangbal ma kewalule, Yesus ami daang tem yakaba, nikil liip-kup unip ko. ");
INSERT INTO tif_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kemin, Yesus nikil iyo tal abip diil Jerusalam kaami mepso tal Oliv Tikiin kaami abip alep ma Betfage so, Betani so, kiimi mepso kawu tal-ilomdip, Yesus ayo almi daang bakaalin tunum alep ma isiik yim-baali unipla yo, yaka-lom, ");
INSERT INTO tif_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","alep imi bokoya-lomda: Alep kibi yakaba din abip atafiibup kaali, tam-ilomdip dongki man kasaa ma sok kuk-diilip bombe kalip namti kaalile, siin kaa tunum so dap-tama tal-unemakin dinim; disa kama man bombe kemin, alep yak sok baa dibiilip tal nami bi kala talokomip. Kemin ale, ");
INSERT INTO tif_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kanumipla, tunum ayo ma alep kipni dik-daaya-lomda: Kanimin o kala-lomdip kaa kanubip i? yaka namti, kipkal bokola-lomdip: Yi, numi Kamokim ayo ok so kemin, din kulii-tilin o, yakala tulup kayi! kalale, nuli kiin dibii-din daalupla, Kamokim ayo asuk abiltap yim-baala din dibii-talokomup o, kala bokonbip-kup dibii-tilin o kala kanum bokoyilale, kulaa, ");
INSERT INTO tif_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","alep iyo din uliwa, Dongki man kasaa ayo liip balang diim amitom kawu bukulip bombe kala, kalbip-kup din sok baa kemiple, ");
INSERT INTO tif_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tunum kawu tolbip iyo alep imi dak-daaya-lomdip: Alep kibi kanamin o, kala-lomdipla, dongki kasaa kaali sok baabip i? kala kanum bokoyiple, ");
INSERT INTO tif_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","alep yikal Yesus almi weng bokoya tilip kaata kanola bokoyipla, alep kamboyiple, ");
INSERT INTO tif_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","alep iyo dongki man kasaa kaayo, dibii-tal Yesus ami kutal-daaliple, ilmi ilim batbat ta, kutam dongki ami daang kun diim kabaaku tabeliwa, Yesus ayo tam tiinale, ");
INSERT INTO tif_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","unang tunum yaapkan imi fanang dakamin kaali, king ami tala-bala fiyaap duumin kukup kaali, kanumin kemin, Yesus ami liip kawu talaba kaali, nuli liip kalawaali atin tangbal-kup dot kaamupla tal-banak o, kala-lomdipla, ilmi ilim batbat malo ma kiili, dalela-lomdip kulaak liip kawu tii-balale, malo ma itale, yang aba langabip as tang kiiyo, as kon bapliim so, fakabi kulii-tildaak Yesus ami liip tal-unokoma kaayo, tabii-bala kem-yakyak-ke-bilipla, dongki kaali, ilim so, as bapliim so, kiimi tip diim kaptoop liip unak. ");
INSERT INTO tif_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kanum una-balala, unang tunum yaapkan iyo biki-kutii dusiin daalale, unang tunum yaapkan malo ma ita daang tem lo kaptoowu kelip Yesus ata iipyak tem kawu una-bala-ke-bamdiwa, fiyaap duumin dukum ke-bam ale, dukum-kup naan-bamdip: God ami win kaali, Kufolum o, kal-bomdip: Yesus kalawaali God Dukum ami win diim talaba no; God ata kukup tangbal kaata-kup ami kukaan-balala yo, kal-bomdip, ");
INSERT INTO tif_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","kalawaali numi awaalik King Devit ami unang tunum tiin mo-bisa altap ke-lokoma kemin, God ata kukup tangbal kaata-kup kukaan-balala yo, kala-lomdip, God ami win sakbaalim dukum kaali, kutam asal tela kufon-bam fiyaap duumum o, kemip. ");
INSERT INTO tif_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kemin, Yesus nikil iyo din Jerusalam aba, Yesus ayo tam lotu am diilim kaami mafek mafek alik kiiyo, itafiin-tal-une-bala, atan tem unon o, kem-sulule, kelala almi daang bakaalin tunum talangkal iso, nikil maakup asuk Betani abip unip ko. ");
INSERT INTO tif_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kemin, Yesus nikil iyo din Betani abip sinbip-kup, kambola yakyak un-bomdipla, Yesus ayo ol-tinap kelula, ");
INSERT INTO tif_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tiyang daalala yi, Fik miit ma yang samaan so kawu tola-lomdu as kon yaapkan bombe kala kalba-kup, daak aba yang fik uyo ma duk-duu inalila yo kala-lomda, yang ulala, Fik kaami abuumin am kaali, kama kemin fik kalawaali kon-kup bombe no, kala-lom, ");
INSERT INTO tif_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","as kuumi bokowa-lomda: As kupyo, as lap ma abuulapla, tunum iyo ma kupni lap uyo maso ma duk-duu inam-nokomip dinim o, kal-bom bakamale, almi daang bakaalin tunum iyo weng sanip ko. ");
INSERT INTO tif_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kemin, Yesus nikil iyo yakyak umbital Jerusalam tal-ilomdip, Yesus ayo tal aba tam lotu am diilim tam aba-lom, tunum iyo mafek mafek God ami kukaalin uyo kutal aba tam lotu am tiilip uyo kukaayim-biliple, saanbip kala-lom tam-ilomda, tunum alik mafek mafek kulii-talaba tam tiilip so, tunum kusnum tal saanbip iso, iyo alik fotabamna sak funbi, tuumon kola-una-tala-kemin tunum imi tebol ayo dak-siki-lom kabaak mole, awon abim God ami kukaalin umi kulii-tal tiilip saanin tunum imi abiin baan uyo dikela kulaaya yang aba kebi kutiiya-lom ");
INSERT INTO tif_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","bokoya-lomda: Kibi mafek mafek kiili, foko-dibii-tal God ami lotu am diildiil kaami daam tem amitom liip kaali, talaba yang malii kaami amitom uyo yang aba tam banemin dinim o, kala-lomda iyo fakel-yila. ");
INSERT INTO tif_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kemin, Yesus ayo unang tunum lotu am diilim kaptamu bom-bilip imi kukuyin-bam bokoya-lomda: Sawaayak kawu God ami weng Sukon Tem ma dola kutiisip kaali, boko-lomdu: Nami am kaltam-ali tunum miit alik imi beten kamaap-nin kaami am o, ke-mokomip o, kalsu. Kemin, kibi God ami weng kaali kaal kesip. Lale, ibi ami weng kuuli, kuyang saak tela-lom God ami am uyo ku-mafak-dakan-tabasip o. Am kaltam-ali ipni wan saan-bam kaptum kusal imi moni yukut inin am kelu kewinsip o, kala kanum bokoya. ");
INSERT INTO tif_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kemin, awem tunum o, kal-bom Pris o, yaka-laabip imi kamok kamok so, lo utamsip tunum iso, iyo Yesus ami weng kaa kanum bokola kaami sang uyo weng san-ilomdip, (fanang daaliwa yi, Unang tunum alik iyo ami weng bakayin-bam kukuyinba kaali, weng san-ilom fanan-taba fiyaap duubip kala kala-lomdip, Yesus ayo tili-dela-bomdip), kala nolu kaali, dok no-lom aalup taanak i? kem-una-tala-kemip. ");
INSERT INTO tif_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kemin, bombii am tiinule, Yesus nikil iyo Jerusalam kaayo, kela unip o. ");
INSERT INTO tif_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sinbip-kup kutim kawu, Yesus nikil iyo asuk tal ulipla yi, As fik namti kon so, timtim so, kiili alik datbip kala kalbip-kup, ");
INSERT INTO tif_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ata kaami aket kaa fanang daa-lomda bokola-lomda: Numi kukuyin kapyo, as fik miit kuumi katii-wunbi kambowa-unbap kaali, yak kaa datbu kaataman! akale, ");
INSERT INTO tif_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus asiik nikil imi bokoya-lomda: Kibi utamipla, God ayo dik-daalupla, kaali ti weng san kanolama no, kal-bom dik-dakaan-bam bom-bilipla yo, kala-somla kemin, ");
INSERT INTO tif_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","nami weng kalawuuli lukuuya-yaamin disa; ti kuyak aket tem daalalip kayi! Kanola dok nolin tunum ata God ami bokola-lomda: God kapyo, yak amdu kaali, baldaa dabaalap yak yol wok kumun tem unak o, kala-lomda ami aket tem kaali, aket alep fukunin dinim kela atamala yi, Nami kaa dik-daali kaali, tifaneng tabokoma no kala namti, kaami dik-daala kaa, God ayo taba-lomda kanolokoma. ");
INSERT INTO tif_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kemin, asuk kaami sang kaali, maso ma bokoyon o kali kemin, kabi dok nolin kukup kaami aket fuku-daka-bamdap, Nali God ayo dik-daalila ayo ti kanop-nama no kala kala-lomdap God ayo beten kamalap namti, kapni kaa dik-dakabap kaali ti, faneng kanop-tokoma. ");
INSERT INTO tif_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kemin, kanola kabi tiltam tola-lomdap, God ami beten kamaan-bamdaple, kaptum taba-lom kapni ban kep-tinba kaami aket kaali, fanang daalap namti, kaami ban kep-tinba kaali, kambolap dinim keluk o, kala-somla kemin, kanolap namti, kapni Kaalap abiil tikiin kayaak ayo kapni ban kemin sang dik-daala-lom: Lukuup-ta kep-nan o, kalokomap kaali, kanola kambop-ta dinim ke-lokomu. Lale, ");
INSERT INTO tif_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","faneng kabi kaami ban kep-timba kaali, lukuup-ta kelin dinim kelap namti, kapni Kaalap abiil tikiin kayaak akal kanola kapni ban kemin kaali, lokola kep-tokoma dinim o, kal-bom Yesus ayo Pita ami kanum bakaala ko. ");
INSERT INTO tif_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kemin, Yesus nikil iyo asuk umbital Jerusalam tal aba-lomdip Yesus ayo tam lotu am diilim kaami daam tem kaptamu tal-banemale, tunum awem o, kala-laabip pris imi kamok kamok sole, lo utamsip tunum so, Juda kayaak imi kamok kamok iso, iyo tal ");
INSERT INTO tif_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","dik-daala-lomdip: Kapyo! Kabi kawanami win diim kaata, kufo-bamdap yak kanolin kukup kala kanun-umbap i? Kabi kawanta tam-baala tal-ilomdap, kanolin kukup kaali, kanum-solap yoko? akiple, ");
INSERT INTO tif_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus asiik bokoya-lomda: Na, nasiik kipni weng ma dik-daayokomi kemin kibi nami weng kaali, maan tiip-nip namti, kaa nakal kanola kipni weng kaali, maan tiiyokomi. ");
INSERT INTO tif_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oksam wakayin tunum Jon Baptis ayo kanami win diim kawu unang tunum iyo oksam wakayinsa ni? God ami win diim kawu kanum-soma ne? tawaal diim kaldaak-ami tunum imi win diim kawu kanumsa ni? Nami weng kala dik-daayili kaata, maan tiip-nipla yo kala, dik-daayale, ");
INSERT INTO tif_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","kamok kamok iyo weng aal diki-bam bokola una-tala-ke-bamdip bokolip: Nuli kanamin o, kalokomup i? Nuyo boko-lomdup: God ami win diim kawu kanumsa no kalokomup kaali, ali nuli bokoya-lomda: Kibi fanang daalipla, God ami win diim kawu kanumsa no, kalip namti, kanamin o, kala kibi Jon kaali, faneng God ami weng kaata bakayinsa no kemsip dinim o, yokokoma; kemin ale, ");
INSERT INTO tif_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","nuyo bokola-lomdupla: Tawaal diim kaami tunum ami win diim kawu kanumsa no, kalokomup elile? daa ye? Kaa kanolokomup daa yo, kalip. Kanum bakabip kaami miit kaali, dok kata naa kalolip: Kamok kamok ili unang tunum yaapkan imi itamipla, Jon kaali ti faneng God ami profet o, kala weng ku-fatap-daa bakayin tunum o, kala-lom bakabip o, kalipla, nuli boko-lomdup: Kaali God ami profet daa yo, kalup namti, unang tunum ili aket atul numi kuya-lomdip yelamip o, kala-lom suun-daa-lomdipla ");
INSERT INTO tif_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","kemin, Yesus ami weng kaali, ibokola-lomdip: Kaa kanta Jon kaa bokolaya, ali taba-lom unang tunum kii oksam ukayinsa no kalalup utabup dinim o, akiwale, Yesus asiik bokoya-lomda: Nakal ti kanolin kawanmi win diim kawu, kanolin kukup kaa kanun-umbi uyo bokoyokomi disa yo, kala Yesus ayo kamok kamok imi kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kemin, Yesus ayo weng faldak-tiimin weng iip maakup maakup ayo bakayin-bam ale, tunum ma wain langabip ma talalu kutii-lomda, tam uti foko kela wain san ayo dikiba-kup; tuum tem kala-lomdipla, ok liip unemin dotu sok lap iyo fokolip daak unule, yaan ta talela kutiilipla, ok bana-unemin ok bon uyo dotu kutii kela, langabip kaptam tiin mo-bom ilin tunum ami am ayo bitam asal kaptamu de kamolale, tunum wain lang tiin molokomip iyo, ulela bokoyila ko: Wain lap abu tii-mokoma kaali, dakabi kutii kela tak-nuubi ok ayo laabi kutiiliwa, kaptum kusal ita tal molipla, kipta sisol ayo kuluu-lom anung ma iltipni kuluubip-kup, nakal anung ma kuluu kulaap-nip din unemak o, kala kamboya bilin samaan kawu una. ");
INSERT INTO tif_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kawu bom-balala, wain lap abuumin umi am uyo daan tiltam tabamnula kawu, tiin-saanin tunum iyo wain lap dakamsi kutii kutii kela ok ayo tuk-nuu-bam ok laabi kutiilipla, aptum kusal imi kuyip ita tal moliwa, wain lang kayaak ayo almi okok kemin tunum ayo ma dabaala tal wain lang tiin molin imi bokoya-lomda: Nimi kamokim ami wain lap kaami ok kaami sisol anung ata kup-nipla, nulmi kamokim kulela unon o, yinba. ");
INSERT INTO tif_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lale, ili biwaka-bi-lomdip, disa kulu dabaalip alami kamokim ami be una. ");
INSERT INTO tif_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kemin, asuk tal atama yi, Kamokim ayo asuk okok kemin tunum kusnum ma ami weng ayo bokola-lom dabaala din wain lang tiin molin tunum imi diim unale, ami kamokim ami weng kola kulii-tilba kaayo, bokoya. Katale, iyo dabom bakela-lomdip, kukup mafak kaayo, kukaan-bi-lom dabaalip unale, ");
INSERT INTO tif_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","kamokim ayo asuk ma dabaala din itamale, atin aalip saakna. Kemin, kanu-bam tunum yaapkan kiili, fokola din itamum e, malo ma ye-bilip tale-bam ale, malo ma kiita, yelip atin saaka-laa-bilip kelip. ");
INSERT INTO tif_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kemin, kamokim almi man aket-iip maakup alafin kelale, kamokim ayo aket fukunbi talaala yi, Awu, nali nalmi man aket-kup kola-laabi kulaata, dabaali din una namti, ami weng kaali, kuyang saak telalip disa yo, kala kala-lomdaya almi man mafiing diim kawu, dabaala din wain lang tiin molin tunum imi fanang una. ");
INSERT INTO tif_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lale, tiin molin tunum kiiyo, atamiwale, ili weng boko una-tala-ke-bam bokolip: Kulaali ti wain langabip kayaakim almi man kemin, bom bii-lom almi aalap ami taanokoma kawu, alalta aalap ami mafek mafek alik kiili tiin mo-lom almi alik ke-lokoma kemin, baan aalupla taanala, wain langabip kaltam ayo nulmi alik keyuk o, kala-lomdip, ");
INSERT INTO tif_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","yak man ayo dap-tal fuku-lom aalipla taanale, tunum man kaayo, sisii dilili dibii tam uti yal foko dabaalip tamdaak saaklo kawu abamna no, kala-lom Yesus ayo faldak-tiimin weng kaayo, kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kemin, Yesus ayo weng ma dik-daaya-lomda: Kipyo, wain langabip kayaak ami asuk talokoma kaa, ali wain langabip tiin molin kasel kii, kanimin ma noyokoma ni? Ali taldaya, tiin molin tunum kiili, atin ti anula taaniple, asuk tunum kusnum ma ulela-lomda, wain langabip kaayo, kuyak kiimi sikil diim tiiyala, ita taltam wain langabip kaayo, tiin molokomip o, kala bakayin-bam ");
INSERT INTO tif_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","asuk bokoya-lomda: Tiin molin tunum ita taba-lomdip wain langabip kayak ami man aalip taanba kiili, sawaayak kaptoop ami tunum kusnum imi kukup kanu-bisip iltap te! kala God ami Sukon Tem kaali, kanum boko-lomdu: Ok fukulin tunum ili am kaa dina-bam tiyak daaliwa, Am kun ma kaali, mafak o, kala-lomdip faldang mo binalip yak balang diim kabang abamna. Katale, kamokim ali am kun kaa atam-ilomda: Kwin! kaali ti tambal kemin am dubim ami duwokop kelak o, kala-lomda am kun kaali, asuk dibii tildak dap-molaya ayo tangbal mokso ke tolnu. Kemin, kamokim ami kanola kulaa God alalta kemin, nuli utamuwa yi, Ami kanola kaa fan tangbal kela kayi! kala-sulup o, kalsu. Kemin, ipkal kuuli, tik-tii-bam atam-laabip. Katale, kibi kanimin o kalalipla kuumi miit kaayo, dotu atamin disa kesip i? kala Yesus ayo kamok kamok imi kanum bakayale, kulaa ");
INSERT INTO tif_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","yakal utamiwa yi, Ee, Yesus ayo nulmi sang kulaata, faldak numi diim tii bakayinba kala, kala-lomdip, Kulaa yak dafukulum o, kalip. Katale, unang tunum Yesus ami weng, weng san-kaabip imi itam-suun-daa-lomdipla kemin, ayo sok dedulin disa, kela unip ko. ");
INSERT INTO tif_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kemin, Falosi tunum iip maakup maakup so, Herot ami tunum iip maakup maakup iso, kiili fokolip din Yesus ami fanang din-ilomdip, kasen-foko-lom weng ma dik-daalipla, Ayo weng mafak aye ma bokola kala, kalalipla, tal bokoyipla, nuyo din dafuku dibii-din weng bakamin baan diim daalum o, kala-lomdip yim-baalip unip. ");
INSERT INTO tif_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kemin, Falosi nikil kiiyo, tal Yesus ami bokola-lomdip: Kukuyin tunum kapyo! Nuli titamsup kemin, kabi win soyal tunum iso, win dinim tunum iso kiili, kukup tambal kaali, maakup kukaayim-bom ale, kabi tunum ma ami atul kaali, ma suun-daalamap disa le; kabi suunkup tituun-kup tabin weng kaata-kup bakayim-bam ale, God ami weng kaata-kup kanumin o, kalba kaata kuluu-lomdapla, fan, tituun-kup tabin weng kaata-kup unang tunum kiiyo, kukuyim-bam ken-umbap. Lale, mafek mafek ma kaami sang kaata dik-daap-tum o kalup. Kemin, (Rom kasel imi lo ma kaa boko-lomdu: Ipni takis moni kaali, nulmi King Sisa almi gavman ami kukaalin o, kalsu. Kemin ale, Juda kasel numi lo kaata boko-lomdu: Ipni moni kaali, God ami kulaalin o, kalsu. Kemin,) numi moni kaali, Sisa ami kukaalum e? God ami kukaalum e? ");
INSERT INTO tif_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sisa ami kukaalokomup elile, kela God ami kukaalum e? kemin, kapni aket fukunbap kaata, bokoyapla kawu, nuli utamum o, akiple, Yesus ayo imi aket mafak fukunbip kaali, akal kaal kela yi, Ali weng mafak ma bokoya kala kalum o kala-lomdip kanubip kala, ayo bokoya ko: Kibi kanimin o kala nali kasen-faka-bam nam-kukubip i? Tuumon maakup ma kulii-tilipla, nali atamon o, yakale, ");
INSERT INTO tif_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","fan, tuumon maakup ma kulii-din daalipla kawu, imi dik-daaya-lomda: Yak tuumon diim kabak-ali sinik so, win so, kala bom-bilip kii, kawanmi sinik sole, win so, kiita bom-bilip i? yakale, iyo bokolip: Sisa ami sinik so, win so, kiita no, akipla, ");
INSERT INTO tif_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesus asiik bokoya-lomda: Uyo kanolin kemin, tuumon kalawaali Rom kasel imi King Sisa ami tuumon kemin, Rom kasel imi gavman almi kukaan-bam ale, God ami mafek mafek kiita, kuno God ami kukaan-bam kemin o, yakale, isiik weng san-ilomdip Yesus ami weng kaali, akal alik ma bokola no, kala-lomdip, aket fanang alik tabaneyu ko. ");
INSERT INTO tif_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Juda kasel imi kamok kamok malo ma kiili, Sadusi yo, ken-umbip iyo boko-lomdip: Unang tunum taansip kiili, asuk tam tiinokomip disa yo, ken-umbip. Kemin, Sadusi malo ma iyo (din Yesus ami dik-dakamin kaa fiitmin dukum ma dik-daaluwa, ami miit kaali, talalu daka-daa bokoyin disa kela namti, unang tunum iyo aban-delik i! kalalip) tal Yesus ami bokola-lomdip: ");
INSERT INTO tif_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kukuyin tunum kapyo! Nuli weng ma dik-daalum o, kalup. Kemin ale, sawaayak kawu, Moses ata God ami Lo ayo numi kuyinsa umi anung uyo boko-lomdu: Tunum ali tunum man ma foko tiilin dinim ke ilomda saaka-lom kalel kutiila namti, niing alta asuk fik ami kaluun uta kuluula akam imi tunum man kuulokomip kaali, ali boko-lomda: Kabi nami abaap ami man kayi! aka-lomda, kamasi fik taanse ami bung mafek mafek uyo man kuula ami kukaalak o, kalsu. ");
INSERT INTO tif_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kemin, weng san-bom ilapya! Siin kaali, tunum ma ami man tunum nikil kiili fetkal kemin, nikil alik taltam fusuulipla, fik diil asiik unang ma kuluu bii, man ma kuulin disa ke, taanale, ");
INSERT INTO tif_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","almi tamon asiik asuk fik ami kalel kaluun kuuyo, kuluula. Kata, akal man ma kuulin disa ke-lom taanale, niing iip akal asuk ti kuluuta kuluula, ");
INSERT INTO tif_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","nikil alik kanumin-kup ke-bi-lomdip man aye ma kuulin disa ke-lomdip taanipla, atin mafiing mafiing kulaata unang ukol kano taan kesu no. ");
INSERT INTO tif_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kemin, tunum nikil fetkal alik kiili, unang maakup kuuta-kup kuluu biile, taan-taan-kesip. Kemin, bom-bi-lom tunum taansip imi tam tiin kawang ke-lokomip kaali, unang kuuta, kawanmi kalel ke-lokomu ni? Kemin, kapni aket fukunbap kaata, bokoyap, weng selum o, akiwale, ");
INSERT INTO tif_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus asiik imi weng maan tiiya bokoya-lomda: Ibi God ami Sukon Tem Weng kaali, talalu ma kaal kelin disa kesip kemin, God kaali, titil soyim o, kalin dinim kesip. Kemin, ibi ti aket mafak-kup fukun-unbip o. ");
INSERT INTO tif_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Weng san bom iliwa! Ilom am ma daanokomu kaali, unang tunum taansip imi asuk tam tiin tam God ami abip suunkup ilokomip uyo, unang dan kaa-bala, tunum dan kaa-bala, ke-mokomip disa; kiili, tiltam akal alik ke-lomdip abiil tikiin kayaak ensel iltap ke-lokomip te! ");
INSERT INTO tif_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kemin, ipni weng kaa boko-lomdip: Unang tunum taansip kiiyo, taan-ilom atin maaklo kesip o, kala-laabip. Yale, bii God ata asuk yim-folala tam tiin baalokomip o, kala-laabip kaami sang kaayo, bokoyan o, akipla, Moses ami buk tem weng kaayo, boko-lomdu: Moses ayo as katip ma tolsa kaami diim kabaku wing kaali, kiin-tabamnala ayo atamala, God ayo Moses ami weng bokola-lomda: Nali Abraham so, almi man Aisak so, ilmi man loop Jekop so, alimal ilmi God namti kala bombi no, ansa no, kalsu. Kemin, ibi Sukon Tem Weng kuuli, tik-tiin-unbip lale, talalu ma kaal kesip disa. ");
INSERT INTO tif_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kemin, tunum taan-ilom din God aso suunkup laabip isole, tunum tiin kawong bom-bilip iso, ita tiin mosa. (Kemin, altap, God ami weng Moses ami bokonsa kaami miit kuuli dok kata naa kalolip: Kemin, Abraham alimal kiili, sawaayak kawu taansip. Lale, God ami tiin diim kaali, ili bom-bilip o, kalalala, Nali alimal imi God ti kalabi no, kala bokonsa.) Kemin, ibi boko-lomdip: Unang tunum taansip kiili, atin disa kesip. Kemin, asuk iyo taltam tiinokomip disa yo, kala-laabip kaali, fan daa yo, kala, Yesus ayo Sadusi imi kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kemin, lo utam-laamin tunum ma tal tola weng san-balaya, weng takenbip e kala, utamala yi, Yesus ayo kiimi weng kaali, maan tela weng tambal kaata-kup bakaba no kalalaya, akal Yesus ami dik-daala-lomda: God ami weng bokoyinsa kaayo, dok kanolin kaata diildiil i? akale, Yesus asiik bokola-lom: ");
INSERT INTO tif_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","God ami weng diildiil kaali ti Moses ami bokola-lomda: Israel unang tunum ibi talalu weng san iliwa! Dukum kaali, numi God kemin, maakup kulaata-kup numi Kamokim kayu! ");
INSERT INTO tif_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kabi ti ami aket kaali, atuk-atuk-ke-laamin daa yo. Kapni aket aa, fanang aa, tiin aa, titil aa, kiili, alik kulaalap yak God Dukum ami diim abamnip ami aket-kup kolan o, kalsa kaata, diildiil o. ");
INSERT INTO tif_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aa, weng fatap ma kaa boko-lomda: Kabi kaltapni angtiil aket duu-lom tiin mo-laabap tap ke, kaptum kusal so, kayak kayak so, imi aket kuyale, tiin saanin o, kalsa. Kemin, weng kalu kusnum ma uta taba-lomdu weng alep kiili, yim-baak molokomu disa yo, kalale, ");
INSERT INTO tif_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","lo utamsa tunum asiik Yesus ami bokola-lomda: Kukuyin tunum kapyo! Kaali faneng te. God alaltap kaayo, ma bombe disa; kemin, maakup ata-kup numi kamokim kemin, kaali faneng tituun weng kaata bakayinbap. ");
INSERT INTO tif_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kemin, kanola tunum ayo anung-anung-kemin daa ke-bam, almi aket aa, fanang aa, tiin aa, titil aa, kiiyo alik kulaala yak God ami diim abamnipla, atin dukum ami aket-kup kola-bomdala, almi angtiil kaami aket uyo tambal-kup tiin mo-laaba; kanolin kaata kaptum kusal kayak kayak imi aket kuya-laabap namti, tunum kaami kanuba kukup kaata, atin ti ata ata ke-lom, taloop aye, ima aa kiili fuulip kiin-bala God ami kukaalin kaali, kabaak banokomu no, kalale, ");
INSERT INTO tif_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus ayo atamaya, Tunum kaali, aket tambal fukun-ilomda kanum bakaba kala, ayo bokola-lomda: Kabi mepso taltam God ami miit tem talapla, God akal kabi tiin molon o, kalba no, akale, kamok kamok ili suun-daa-lomdip ili maso ma bakamamip dinim kela unip ko. ");
INSERT INTO tif_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kemin, Yesus ali lotu am diilim kaptamu bomdala, unang tunum kiiyo, weng bakayim-bam kukuyim-bamdala, weng ma kaayo, bokoya-lomda: Kanimin o kala lo utamsip tunum ili boko-lomdip: God ami uldaa-dabuusa tunum Kraist o kebip kaali, King Devit ami man loop ayo taltam tabasa kaptoop ami tunum o, kala-laabip i? ");
INSERT INTO tif_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kemin, sawaayak kaali, God ami Sinik Tambal kaata, almi aket fukunin kaayo, King Devit ami kolala, akal boko-lomda: God Dukum ata nami Kamokim ayo bokola-lomda: Kapyo! Tal aba yang nalmi ting tuuplo kamokim ami tiin-yaamin baan kabaaku tiin-balapla, bii-lom nata nata kelila kawu, kapni waasi iyo dimiili kabaak banip kamboyi kala kalalawa kawu, kii kapta tiin molokomap o, kala God ayo kanum bokonsa no, kala Devit ayo kanum bokosa. ");
INSERT INTO tif_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kemin, God ami uldaa-dabuula tiltam Kamokim kesa kaa, kawanami man i? Kanola Devit ayo fuku-daala yi, Am ma daanokomu kaa, ilom kaptoowu nalmi man loop ata ma tiltam tabokoma kala kalala kaami aket kaata-kup fanang daa-lom bokosa dinam, kabak boko-lom: Kaa nami Kamokim o, kaloma disa yo. Devit ali kalok nolin aket kaaso, fanang-daa ke boko-lomda: Kaa nami Kamokim o, kalsa ni? kala Yesus ayo kanum bokoya ko. Kemin, unang tunum yaapkan tal tiinip iyo fiyaap duu-bamdip Yesus ami weng uyo weng san-kaamip. ");
INSERT INTO tif_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kemin, Yesus ayo kukuyin-bam ale, weng ma bokola ko: Ibi mep lo utamsip tunum iyo talalu itafii-bamdiwa yo! Imi aket fukubip kaalile, ti ilim batbat kaata-kup miki-bi-lomdipla abip kawu tal-une-buluwa, unang tunum iyo numi itafiimik o! kala-lomdip tal-une-bam ale, iyo din maket saanin baan diim unokomip kaali, unang tunum iyo tal bakayin-bamdip: Kamokim, kaa balap o? Kukuyin tunum kaa balap o? yakan-kaamin o, kalaliwa, unang tunum imi tiin diim kawu tal-une-bam ale, ");
INSERT INTO tif_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","iyo din lotu am aye, ima inin am aye kawu, din unokomip kaa, ti abiin tambal-kup kuluu tiinupla, tunum unang iyo itafii-bamdip numi win ayo kufuyik o, kal-bom kanun-umbip. ");
INSERT INTO tif_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lale, lo utamsip tunum iyo unang kaluun imi kasen-fokoya-lomdip imi sin-laamin am ayo bak-daayiple, iyo am dinim, mafek mafek dinim ke-bam kanun-umbip o. Kanolin kukup mafak kaata kanubip. Lale, ili unang tunum imi tiin diim kawu, God ami beten kamaalup kawo kala, bakan kaptoop kaptoop-ke-bulupla, unang tunum iyo itam-somdipla, numi tong kaata-kup bakayik o, kal-bomdipla, beten batbat-kup ken-umbip o. Kanola, ibi imi talalu itafii-bamdiwa kayi! Kukup mafak awak sakbaalim dukum kaali ken-umbip kemin, God ali angtiil yol awak sakbaalim dukum kaata, kuyokoma te! kala, Yesus ayo lo utamsip tunum imi sang kaata, unang tunum imi kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus ali lotu am diilim kaptamu God ami moni kulii-tal abuumin kaami ket mepso kulu tiin-bomda, unang tunum imi kukup kaata, itafiimala, moni ayo kulii-tal ket abuumipla, mafek mafek soyal ili ti moni yaapkan-kup kulii-tal ket abuu-bilipla, ");
INSERT INTO tif_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","unang kaluun atin mafek mafek dinim ma ukol tal tuumon kiin-abin katip katip alep kiita-kup yim-bital ket abuulu utama. ");
INSERT INTO tif_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Kemin, Yesus ami daang bakaalin tunum imi weng umuuya tal atamipla ayo bokoya-lomda: Ibi unang kaluun kuu utamip o? Unang tunum malo ili bung yaapkan so la, tuumon anung katip kuliita kulii-tal God ami kukaanbip; kemin ale, mafek mafek dinim unang kaluun umi tuumon katip ma ima saan-bam inokin kuliita alik dilii-tal God ami alik kolu kemin, atin ti weng tifan eng ma bokoyokomi kemin, ibi weng san bom iliwa! God ami tiin diim kaa, unang kaluun mafek mafek dinim umi kukup kanolu kaali ti, uta uta ke-lomdu unang tunum imi kukup ayo kabaak bana no, kala Yesus almi daang bakaalin tunum iyo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus ayo lotu am diilim ayo kela tiltam abip daal abale, almi daang bakaalin tunum ma tal bokola-lomda: Numi kukuyin kapyo! Lotu am kaltam-ali ti, atin am tambalkan ale, ili tuum tangbal tangbal kiita dikela kulii-tal maltiin-tal-une-bi-lom tuum am kaptam tangbal-kup desip. Kemin, ti utam-taman! akalale, ");
INSERT INTO tif_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus asiik bokola-lomda: Am sakbaalkan kulaa utafiibap kaami sang kaata bokop-ton o, kali kemin, weng san ilap! Bii-lom kawu, waasi iyo tal am uyo alik olso balata-lomdip, tuum kuyak tip-tip-bam maltiin-unsip iyo dekela dabuulip daak abamnu bii disa ke, disa akal almi kulu bala-bala-ke-lokomu no, ansa. ");
INSERT INTO tif_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus ayo tam Oliv Tikiin kawu tiin-bomda tiin kulaala yak malii lotu am diildiil uyo utafiimale, Pita, Jems, Jon, Andru kanolin nikil ita-kup aso tam tiinip kemin, tildang dik-daala-lomdip: ");
INSERT INTO tif_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kamokim kapyo! Kalok kanolin diim kawu, waasi iyo tal-ilomdip lotu am diildiil kaptam balat-nokomip i? elile, Dok kanolin kukup kabak asiik tiltam tabu utam talaaluwa yi, Awu, kukup mafak namti kulu tiltam tabon o, kalu kalokomup yoko? akiwale, ");
INSERT INTO tif_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus asiik nikil imi bokoya-lomda: Talalu utafii-bamdiwa! Kasen-fakayin tunum kiimi weng kaa, weng san-kaamin daa kayi! ");
INSERT INTO tif_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tunum yaapkan iyo tal nami win ayo kufu-bamdip boko-lom: Nali God ata uldaa-nam-buula tiltam Kamokim kesi tunum o, ke-bala ke-bala-ke-biliwa, unang tunum yaapkan iyo imi weng kaa, Fan o, kala weng san yang banokomip. Kemin, imi weng bakan-talabip ayo, weng san-kaamin disa yo. ");
INSERT INTO tif_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kano, ibi weng saniwa! Tunum miit ma iyo baa kulii-din daalip, tunum miit ma iso, waasi din-biliple, am waasi ayo ukduu dinan-tal-une-bala-kemip uyo dukum-nokomip kawu, ibi kaa am mafiing diim daan tiltam tulu no, kalalip aket kufoyu suunin daa. Kanolin kukup kaasiik tiltam tabokomu. La, kanum tala-bulula, kanumin diim kawu am mafiing uyo abiltap-siik tiltam tabokomu disa kayi! ");
INSERT INTO tif_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Am bokon ma kaptam kasel iyo bokon kusnum ma kasel iso din-biliwale, kuno king kusnum ma ami tunum tiin moba ita taba-lomdip, yak king kusnum ma ami tunum tiin mosa iso, din-biliple, aa, am bokon yaapkan kawu bim ayo tiltam tabe-bala, ol futam ayo tiltam tabe-bala ke-mokomu. Kemin, angtiil yol kaa kaa-mokomip kaata-kup, kuluu-laa-mokomip disa; uyo tal-unula, asuk mafiing kaptoowu angtiil yol yaapkan yaapkan iyo tiltam aba talun-talun kebii, disa kelula, kawu am mafiing am uyo tiltam talokomu ko. ");
INSERT INTO tif_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kanolin kemin, kipni kukup ayo yaap-kup tiin mo-bomdiwa kayi! Ibi nami wok kala tabu-unokomip kaami kalan uyo, nami waasi ita taba-lom yim-tal-fuku de-yim-tama din Juda kasel imi kamok kamok yaapkan imi diim kawu tiiliwa, ita lii-bam yim-bak-saan-bam ale, ibi lotu am unipla waasi iyo tal ye-bam, kuno nami wok fukulokomip kabak-ami kalan kaata, nami waasi ita tal yim-tama din tawaal diim imi kiyap so, kamok kamok iso, imi diim daalipla, ita lii-bam yim-bak saanokomip kabaku utamiwa yi, God almi weng kaami kalan namti kabuu no, kaliwa imi diim kawu nami sang namti bakayokomip o. ");
INSERT INTO tif_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Am mafiing diim kaali, tilin disa kama ilaya, nami lak duulin ili God ami weng tangbal ayo kulii-din tunum miit kusnum alik imi diim kawu bakayila-tal-unemik o. ");
INSERT INTO tif_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kemin, ita taba-lom ibi yim-bii din weng bakamin baan diim daalokomip kaali, ibi aket yaapkan kii fukun-bamdip: Kwin! kaaso weng binalip tildak numi diim abe-mokoma kaata, kanimin weng ma bokoyokomup i? kemin daa; fanang daa-bomdipla ipni weng baka-mokomip disa; kipni weng baka-mokomip kaali, God ami Sinik Tambal alta kipni aket tem bombe ata kukuyim-balala, weng yaap-kup baka-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tunum nitam suun-bam ilmi nakal nami lak duulin iyo yim-buu yim-baalip yak kamok kamok imi sikil diim abamnipla, ita taba-lom anulip saaka-laa-biliple; awil-fakal yakal kuno man iyo yim-baalip yak waasi imi sikil diim abamnip iyo anulip taan-laa-biliple; kuno man yakal ilmi awol imi waasi keya-lomdip fokolip yak kamok kamok imi sikil diim abamnipla, iyo yelip saaka-laa-bilip ke-mokomip. ");
INSERT INTO tif_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kemin, ibi nami lak kaata-kup, duu-bom nami okok kaata ken-umbip o, kala-lomdipla, unang tunum yaapkan ita taba-lom ibi aket atul kukaayin-bam, itafii-mokomip. Lale, nami lak duulin unang tunum ili, kanta angtiil yol uyo daka-bamdip kulaa yang banemin dinim; suunkup nami lak kaata, dukum-kup titil-faka-bam bombii taaniwa kawu, kiita God alalta yim-tama tam almi suunkup ilin abip kawu daalala suunkup ilokomip o, kal-bomda Yesus ayo almi daang bakaalin tunum atalingkal imi kanum bakayin-bisa. ");
INSERT INTO tif_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Unang tunum nami sukon dol-yinbi umi tik-tiibip kipyo! Yesus ami weng bokosa kaata, dol-nokomi kulawaayo talalu utamalip ko! Kemin, Yesus ali asuk almi daang bakaalin tunum imi bokoya-lomda: Ilom am ma daanokomu kaa, ipkal utamipla, Jerusalam kaptamu waasi ita taba-lom mafek mafek atin mafakan dukum ma kulii-talaba tam ulmi baan ayo kela kutam God ami lotu am awem kaptam tiiliwa, uta taba-lomdu atin God ami am ayo ku-mafak-daalu mafaknula kalokomip kaami diim kawu, ibi Provins Judiya kalawu bom-bilip namti, abip kalawaali, kelalip wakadaa bitam amdu tikiin-tikiin kawu, sawaan-laa-malip ko! ");
INSERT INTO tif_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ale, ibi abal akiim kawu bilip namti, asuk tam am un-ilomdip bung ma foko-kuliiluwa yo kala tam unemin daa; kuno kela abiltap-siik ukadaa din sawaan-laa-malip kayi! ");
INSERT INTO tif_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aa, kuno ibi iltipni langabip kawu bilip namti, asuk din abip aba ilim ma foko-kuliiluwa yo, kalalip abip unemin daa; langabip kuluwu kela abiltap-siik din sawaan-laa-malip ko. ");
INSERT INTO tif_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kabak-ami tiltam talokomu kaali, unang kumun sole, unang manuuk so, kiimi ukadaa unokomip uyo fiit-bamdip tal-une-bam ale, angtiil yol awak uyo kaa-bam ke-mokomip kemin, kwin! kiiso kawe! kebi no. ");
INSERT INTO tif_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Wom ati taba-lom am mafak daana uyo, kanolin mafek mafek mafak kiiyo, tiltam tilip namti, ibi taang-kala abiltap ukadaa unolip disa; kemin, ibi God ami bokola-lomdip: Kapyo, am mafak am daan tiltam tulu kemin, kabi mafek mafek mafak kiiyo, kewap tiltam talemin disa yo, aka-lomdip beten kaman-biliwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kemin, siin sawaayak diildiil diim kawu, God ami tawaal talalusa kawu kulii yakyak kutal kamala kala diilu kaali, kanolin atin kukup mafak dukum kaa kanum tiltam talokomu ultap kaa ma tiltam tabasu dinim. Kemin, kanumsi tal-unuya, maso mafiing ayo ma alaltap kanolin kukup mafak dukum kaayo, maso asuk tiltam tabokomu disa. ");
INSERT INTO tif_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kata, God ali almi unang tunum kii, ulelnala almi lak duulin imi olen-daayila, boko-lomda: angtiil yol dakamin am daan tiltam talokomu ayo am mafak kanolin daan talokomu kaali, abiltap-kup tal aba toop unuk o, kalala bokosa. Kemin ale, kanolin weng ayo bokolin disa kesa dinam, almi tunum unang iyo alik kuliila taba disa kelalip. Lale, weng kuuta kutii bokosa ko. ");
INSERT INTO tif_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Am kanumin am daanokomu kuyaku, tunum ali ma tal bokoya-lomda: God ami ulduulala, Kamokim kesa tunum Kraist ali kulube kemin, kaa atamin o kalba aye, yang kabe kemin, tal atamin o! kalba kaa, ibi, Fan o kalin daa yo. ");
INSERT INTO tif_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nami weng kala bokoli kaali, dok kata naa kalolip: kasen-fakayin tunum iyo God ayo ulelnala almi lak duusip kipni kasen-fokoya-lomdup, kipni aket fukunin ayo ku-mafak-daayupla, yang banin o, kala-lomdip kipni fanang tale-mokomip. Ma kaata tal bokoya-lomda: Nali God ami uldaa-nam-buula Kamokim kesi tunum Kraist o, kalale, kuno ma ata tal boko-lom: Nali God ami profet weng ku-fatap-dakamin tunum o, ke-bam mirakel o, kala kukup akal almi kusnum kaa kukuyokomip. Lale, God ata ipni ulelsa kemin, ibi yim-buulokomip disa. ");
INSERT INTO tif_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kemin, nasiik mafek mafek mafak mafak ma kaa tiltam tabokomu kaa tiltam tabin dinim, bom buu ti kaptoowu kama iluya, kalawu umi sang kaa bokoyi nami weng kaluuli dotu weng san utafii-bamdiwa yo, kala-lomda Yesus almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesus ayo asuk almi daang bakaalin tunum imi bokoya-lomda: Yak kanolin kukup mafak mafak ayo tiltam aba tal-unemsi disa keluya, kuyaku tam atan uyo simit-kup kala-lom malang tinilule, kuno kayoop akal ami falala-kalin disa ke-som ale, ");
INSERT INTO tif_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wakalkan yakal ti kano abiil tikiin kawu bom-bilip kiiyo, kambola dikela tildaak abe-biliple, tam abiil kun diim mafek mafek titil-kup tabasip yikil kuno ilmi liip ayo kelalip sak funbi liip kusnum liip tal-une-bala tal-une-bala ke-mokomip o. ");
INSERT INTO tif_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kemin, uyo kanumsi tal-banen-sulule kawu, unang tunum alik iyo titam daa, nitamipla, tam Dukum Ami Man Nayo, ibin tem kabaku tilila, nami titil uyo kuluu-lomdila, atan alaltap ke tiin buluusi-kup sikin-bulula, talaba no kalalip nita-mokomip. ");
INSERT INTO tif_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kemin, nalmi ensel iyo yim-baali unbilin am bokon alik kala dik-daa kulaasu kaami balang tem atalingkal God ami unang tunum ulelna almi aket-kup konsip iyo afetu-lom yim-bii talokomip o, kema ko. ");
INSERT INTO tif_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus ayo asuk weng ma faldak-tii bokoya-lomda: As ami aket kaa fanang daalin! Ipkal as fik umi kukup kuu utamipla, umi duul ayo bam-daala kalaangnu namti, kuuli umi lap abuumin ayo mepso dikiwa tulu kala kalokomip. ");
INSERT INTO tif_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kanolin kemin ale, nami kanolin kukup tiltam tabokomu umi bakayila-tabasi uyo fan kulu tiltam tulu kala, kalokomip kuyaku utamipla, Kaa nami talokomi kaami am namti kulu mepso tulu kala, kalokomip o. ");
INSERT INTO tif_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kipyo! Nami weng kala bokoyokomi kaali, weng san iliwa! Tunum unang malo ma tiin kawang bom-bilip kiili, taanin disa kano bom ilipla, nami weng bokoya-lomdi: Ilom kaali, mafek mafek mafak alik iyo tiltam abokomip o, kalbi kaali, tiltam talokomip. ");
INSERT INTO tif_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kemin, am ma daanokoma kuyaku, abiil so, tawaal so, kulii maaklo disa ke-lokomip. Yale, nami weng kuuta ti disa ke-lokomu dinim; kano ti suunkup ilokomu no, kala Yesus ayo faldak-tiimin sang ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Ali dok kanumin diim kawu talokoma no, nakan-kaabip i? Tawaal diim kaldaak-ami tunum ali ma utamsa disa; aa, abiil tikiin kasel ensel ili babon; aa God ami Man nakal kano ma kaal kesi disa; ti nalmi Aatumen God maakup ata-kup utamsa. ");
INSERT INTO tif_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ibi utamiwa, Ali kalok kanumin diim kawu talokoma no, kalbip disa kemin, ibi ti suunkup liip fen-bam bom-biliwa kayi! ");
INSERT INTO tif_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nami din abali asuk talokomi kaali, tunum bilin abip samaan uneba tap, tunum ayo umbilin abip samaan ma kawu ilanali asuk talokomi no, kalala, almi okok kemin tunum iyo naan-daaya tal atamiple, almi moni aye, mafek mafek kiiyo, alik kulaaya yak imi sikil diim abiple, akal almi wok e kala kola kola keba-kup, amitom tiin molin tunum ami bokola-lomda: Kabi dotu fen-bam balawa, biili talon o, kalala una. ");
INSERT INTO tif_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Kemin, kipta utamiwa yi, Awu kalok nuumin diim kawu am kayaakim ayo talokoma no kalbip disa; maaklo kemin, atan tem bana taloma ne? bii kutamiip-nala taloma ne? ali maaklo abiltap tal ula yi, Akanbip kala kalokoma kaali mafak. Ultap kemin, ibi kaal ke kalok nuumin diim kawu, nali talokomi ma? nambip disa; ipkal talalu bomdip liip fenipla talomi no. ");
INSERT INTO tif_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nami weng kala daang bakaalin tunum kipni bokoyi kaata, unang tunum alik kipni bokoyin o, kali kemin, alik ibi talalu fen-bam bom-biliwa yo! kala Yesus almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kemin, sabi bii sintam Pasova tiltam tulu, toloop so, bret fusuu-laamin disa so, inokomup kayi! kalale, kulaa tunum awem o kala pris imi kamok kamok so, lo utamsip tunum iso, iyo Yesus ami disa iip kulu kasen-fokola-lom dap-tal-fuku, sok dedu-lom aalup saaknak o, kala-lom bokolip: ");
INSERT INTO tif_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nuyo yak unang tunum tala-tala-ke-bam ima inokomip kaami diim Pasova yo kebip kawu aalokomup kaali, unang tunum yaapkan iyo, Kaa ban kelip o, kala-lomdip, Numi mafak o, yakan-kaa-bam yemalip kemin, kelup ilom ima ayo alik inamnip dinimnala una-tala-kelip kala, kala-somdupla kawu, aalum o, kala weng dap-tiilip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus nikil iyo Oliv Tikiin ayo kela din abip Betani kawu bomdiwa, din tunum ma angtiil mafaknala, alta dap-talalula yawase Saimon ami am kawu ima im-bom bom ilala, unang ma tang tambal-kup tabin ok ket ma kulii-tulu kaami ket kaali, tuum alabasta ta tem kalu dotusip. Kemin, tang tangbal-kup tabin ok naat o ken-umbip ayo kaptoowu be kemin, kaali ti sisol dukum ta saan-umbip. Kemin, unang uyo ket kaayo, lo-lomdu tang tambal-kup tabin ok ayo kulii yak Yesus ami dabom diim kawu sing daalula, ");
INSERT INTO tif_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tunum malo ma aso tiin-bilip imi aket tem ayo aket atul keyilula, nikil ilmi-kup weng boko una-tala-ke-bam bokolip: Kwin! unang kalawuuli tang tambal-kup tabin ok kalawaaso tinan-daalu kawi! ");
INSERT INTO tif_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kaa kano kela-lomdu, tang tambal-kup tabin ket ayo kulii-din aptum kusal imi kuyilu ita mo-lomdip moni almi-kup 300 ayo akaala tam lo anang ma kuluu-lom, kulii-din mafek mafek dinim ilin unang tunum imi masiim kuyilakin o! kela-lomdu disa kawu tinan daalu disa kela no, kal-bomdip mafak o, wakan-kaamip. ");
INSERT INTO tif_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lale, Yesus ayo tunum imi bokoya-lomda: Ibi kanimin o kalaliwa, weng mafak kaa unang kuu kukaa-un-bilipla, uyo aket dukum fukunbu yoko? Kewin o! Uli kukup tangbal nami kanop-nu kemin, kulaalin a! ");
INSERT INTO tif_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Unang tunum mafek mafek dinimal kiili, kipso suunkup laabip ale, ipkal kano dong dokoyum o, kalip, kuno ipkal yaap kukup tambal kaa kuyilalip. Lale, nali kipso suunkup kala ilokomi disa; ");
INSERT INTO tif_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","unang uyo utamula yi, Dok kanolin ata yaap nola nami no kalu uyo kaa kanolu, kaa utamula, Yesus ayo mepso aalip saaknaya, dibii-din tuum tem kawu, kuwaalokomip kala, kalalula, Juda kayaak numi as kuli dotu dibii-din kuwakamin kukup kuuta, kuluu-lomdula, nayo saaknin disa iliya, tang tambal-kup tabin ok ayo nami dabom diim sing daap-nu. ");
INSERT INTO tif_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kemin, kaali ti fan tituun weng bokoyokomi. Ilom kaptoop ali unang tunum kiimi am bokon alik kula dik-daa kulaasu iyo tal-une-bam nami weng tangbal kukaaya-tal-une-mokomip ayo, unang kuumi kukup tangbal kala kup-nu kaami sang kaa bakayila-tal-une-bamdiwa, umi win ayo suunkup kufuwokomip kayi! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yesus ami daang bakaalin tunum kiili, talangkal, la ma kaali abip Keriot kasel Judas kemin, ata din-ilomda tunum awem imi kamok kamok imi bilip kawu, Yesus ayo dap-fatap-daalon o kala, din awem tunum imi kamok kamok imi bokoyilala ");
INSERT INTO tif_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","iyo weng sandiwa, imi aket tem kaayo, atin tangbal ma keyilula, moni ayo tik-tii-lomdip weng kutii, Sin ilom kanolap kala kalalupla kawu, kup-tokomup o, akiwa, ayo bomda kalok kano-lomdi dap-fatap-daalon o, kala-lomda akola liip fen-tal-unema ko. ");
INSERT INTO tif_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kulaa, bret fusuu-laamin disa ami inin am maakup diim kawu Juda kayaak iyo sipsip man kasaa iyo aabi kutii Pasova kaayo, inan-laabip kemin, kulaa almi daang bakaalin tunum iyo Yesus ami dik-daala-lomdip: Kapyo! nuli din kaloku ima Pasova kaa kawu ma dotuliwa yo kalbap yoko? akiwa, ");
INSERT INTO tif_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesus ayo almi daang bakaalin tunum alep ma yim-baali din unin o, kala-lom imi bokoya ko: Din Jerusalam abip dukum unokomip ayo okok kemin tunum ma tal kipni ita-mokoma kemin, atamipla, Ali unang imi liip ke-lom ok ket aalap dukum ma tawaal ta fak-duu talalusip kaptoowu ok iluu kutam dabom diim tii kulii-talaba kala kalalipla, yak ami daang abamnipla, ");
INSERT INTO tif_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ayo am kaptam banan-salale, alep ipkal tunum kaami kamokim am kayaak ami bokola-lomdip: Yi, numi kukuyin tunum ayo weng ma kup-ta kulii-tulup kemin, ali bokop-ta-lomda: Kapni am kaltamu am anung ma kiiin ukuyilawa, nami daang bakaalin tunum iso, naso, kaltamu bomdup nokol Pasova kaa inamnum o, kalaya tulup o, kala kanum bokola tulup te! kala bokolipla, ");
INSERT INTO tif_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","kulaa, am kayaakim ayo kipni weng uyo weng sanba-kup, yim-tama tam am tip kaptam daa am anung dukum ma kukuyila utamipla, ima fuumin kaami mafek mafek alik kiita ti kaptamu bom-bilip kala, kalalipla, kaptamu inin-inin ayo talal-bam nuumiwa yo, kala alep yim-baala unip. ");
INSERT INTO tif_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Daang bakaalin tunum alep iyo din abip dukum Jerusalam din uliwa, Yesus ami weng bokoya tulup ayo, tifan tituun-kup kelu kala, kalale, tal Pasova inin ayo talal-bam fuumip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bom bii, am tiindu atan yak tem unaya, Yesus almi daang bakaalin tunum talangkal iyo tal ");
INSERT INTO tif_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","am ukuyimba kaptamu tiin-bom nikil iyo ima ina faka-bam ale, Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Nami weng kalawaali ti tifaneng bokoyokomi: Nikil iltipni tunum maakup ma ata naso inbup kulaata, taba-lomda nam-fatap-daalala, nelokomip te! yakala, ");
INSERT INTO tif_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","daang bakaalin tunum iyo Yesus ami weng bokola uyo weng san fanang alik tam baneyula aket yaapkan fukun-bam ale, aket uluum dukum ke-lomdip ma asiik dik-daala dik-daala ken-una-tala-ke-bam ale, bokolip: Kamokim kapyo! Nata nelile, ni disa yi? kal-bom dik-daala dik-daala ke-bam aket yaapkan fukunipla, ");
INSERT INTO tif_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus asiik bokoya-lomda: Ibi talangkal la, ipni tunum ma naso sikil kulaak falet tem kabaaku daa inamnup namti, kulaata, nam-fatap-daalaya, nelokomip o. ");
INSERT INTO tif_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sawaayak kawu, God ami Sukon Tem kabaku nami kanola taanokomi kaami sang bokosu uyo, fan kamala kulu kaami sang ayo tiltam tuluya, Dukum Ami Man Nami nelip taanokomi. La, tunum nami nam-fatap-daalokoma ali atin ti angtiil yol awak dukum kuluulokoma. Kemin, awak kuuli mep tunum kaa kuulin dinim nosu dinam, ali angtiil atul awak dukum uyo kuluulama dinim, kaali tambal o, kema ko. ");
INSERT INTO tif_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yesus nikil iyo ima in-bomdip Yesus ayo bret ma kuluuba-kup God ami yaap ke yo, aka-lom lo kutii almi daang bakaalin tunum imi kuya-lomda bokoya: Kalawaali nami tiil kemin, kuluu inamnin o, yakale, kuluu ");
INSERT INTO tif_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","inamniwa kawu, ali wain wok ayo iluu kutal-fuku, God ami yaap ke yo, akale, almi daang bakaalin tunum imi kukaayila, inam-niple, ");
INSERT INTO tif_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ayo bokoya-lomda: Kalawaali, nami kiim kemin, nami nelipla, nami kiim ayo sing-daa-lomdu God ami kama weng umi de-kutiiluya, ibi kiim kaa atam, Awu faneng, God ali unang tunum yaapkan numi ban wakamin kiili, takan-tiiyase kala, kalokomip o. ");
INSERT INTO tif_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nali tifan bokoyomi: Nali kamala kaali, asuk wain ok kalawaali, maso ma inam-nokomi disa; kela bom-biili bii din God ami abip kawu, wain ok alokso kaata ma inokomi no, yaka-lomdala kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nikil ima kaa inamnip disa kelale, kulaa iyo God ami baal maakup ma uluubip-kup, Oliv Tikiin unip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus nikil iyo liip kawu un-bomdiwa, Yesus ayo bokoya ko: Ilana alik ibi kep-nalalip ukadaa unokomip. Kemin, God ami Sukon Tem sawaayak dolsip kaami sang kaali, boko-lomdu: God nalta, waasi iyo kamboyi ita taba-lomdip sipsip tiin molin tunum ami aalipla, sipsip alik iyo ukadaa une-bala tale-bala-ke-lokomip kayi! kalsu kemin, fan kulu ipta kanolokomip. ");
INSERT INTO tif_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","La, nata kanola taani, namaalip ilana asuk tam tiiniya, Provins Galili unokomi kawu, ibi din kawu nitamin o, kemala, ");
INSERT INTO tif_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ayo weng sanba-kup Yesus ami bokola-lomda: Kamokim kapyo! Kapni daang bakaalin tunum malo ita kambop-ta wakadaa unokomip. La, nali kuno kep-ta wakadaa unokomi disa yo, akala, ");
INSERT INTO tif_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus asiik Pita ami bokola-lomda: Naktum kapyo! Nami weng kala bokop-tokomi uyo aket fukun-salapya! Kamala kutamiip kuyaku, awon kakaruk aalap ayo naanbi du alep fak-daalin disa, ilala, kabi nami sang ayo bokop-na-lomdap: Yi! Kaali ma atamsi dinim o, nakan-kaamsi liip asuumano fak-daalokomap o, akala, ");
INSERT INTO tif_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita asiik weng dukum-kup bokola-lomda: Atin disa yo! Kapso naso maakup yelum o, kalip kaa, nali boko-lomdi, Yi! Kaali ma atamsi dinim o, tokokomi daa yo, akale, kuno Yesus alami daang bakaalin iyo tikip alik ti Pita ami weng bakaba weng yaan tem kulaata iso, maakup kanum bokolip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kulaa, Yesus so, almi daang bakaalin tunum iso, iyo yak aba din langabip Getsemani abale, Yesus ayo bokoya ko: Nali God beten kamali kemin, nikil ibi kulawu tiin-bom iliwa yo, yaka-lomda, ");
INSERT INTO tif_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","keyila Pita, Jems, Jon nikil asuumalo ita-kup foko-yim-bii yang aba Yesus ami aket tem uyo atin mafakalule, aket uluum dukum-kup kelu, ");
INSERT INTO tif_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nikil imi bokoya-lomda: Kipyo! nali utamila, Kulaata nelip saak-nokomi no, kalalila, nami aket tem ayo atin ti uluum dukum kep-nu kemin, yang kawu God ami beten kemi kemin, kaa ipkal kuldaaku fen-bam ale, talalu kutii-bom iliwa yo! yaka-lomda, ");
INSERT INTO tif_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","keyila akal sop-taba yang lo kabale, tilik duung fal-kela daak tiin dabuunale, kulaa God ami beten kaman-bamdala: Aatumen kapyo! kabi ayo kalap namti, kamala mafek mafek mafak tildak nami diim abokomu uyo kuluu kulaap-nap yak banuk o. ");
INSERT INTO tif_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Atok kapyo! Kabi ti alik yaap-kup nolalap kemin, kabi kukup mafak tildang nam-mafak-daalon o, kebu uyo dil molawa kep-nuk o, kalbi. Lale, nami fanang daka-bamdi Aatumen kabi kabak-ata dil moyawa kep-nuk o kebi kaali, kabi kuluu kanumin disa; kaltapni aket fukunbap kaata-kup kuluu kanumon o kalolap kaali, ti yaap o, kal-bomda beten kema ko. ");
INSERT INTO tif_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesus ayo kanola beten kemsile, kulaa kela tildang ulala, Tunum nikil asuumalo iyo akanbip kala, kalale, yam-kafala-lom Pita ami bokola-lomda: Saimon, kabi akan-umbap o? Kabi titil-fak-daa kutii bom ilanin tap kelalap daa; abiltap-siik akanbap o? ");
INSERT INTO tif_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Setaan ata ipni oko-takayim-bilila, yang ban ukduulip kala yokon o, kal-bomda ibi yam-kukuba kemin, kipni aket fukunin ayo ti kukup tambal-kup nuumum o kalbip. Lale, ipni titil ayo katip; yang kukup mafak nuu-mokomip. Kemin, asuk akan-unemin daa; kelalip kawong-bomdip God ami beten kamaan-bilip, ayo dong dakaayim-bala yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kanum boko keyila Yesus ayo asuk yang olang diim aba almi kamosinim beten kemsi kulaa tala tap kulaata, asuk beten kemsi kulaa kela, ");
INSERT INTO tif_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","asuk tildang ulala yi: Aptum kusal asuumano iyo asuk ti kuno tiin yak keyu akan diisbip kala-lomda yam-kafalnala, fatom keya weng babon daalip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kanum boko keyila Yesus ayo asuk yang-ilom beten kemsi liip duum asuumalo diim asuk tal ulala, Daang bakaalin iyo yam-kafala-lom bokoya: Ibi asuk akan-bomdip fan-kaabip o? Ipni akan-unemin kulaa ti kutoop kulu diilip disa kelu kemin, tam tiin atam-tamin! Kulaata nak-tunum maakup ma ata taba-lomda Dukum Ami Man, Nayo nam-fatap-daa nam-baala yak tunum mafak imi sikil diim abam-nokomi namti kaa tiltam tulu. ");
INSERT INTO tif_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kemin, kibi tiltam tolnip unum a! Nak-tunum nami nam-fatap-daalala, nelokomip ayo din atamdi yo, kalala talaba kemin, tilip una-tala duk-duulum o, kala Yesus almi daang bakaalin tunum iyo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","44","Yesus ayo weng bakaya-salale, almi daang bakaalin tunum kiili talangkal, la talang kaata tala kemin, ali Judas ata. Ali kamosinim kaali, awem tunum o, kala pris imi kamok kamok so, lo utamsip tunum so, Juda kasel imi kamok kamok iso, ita tunum yaapkan iyo yim-baalip din iyo bainat so, wan kong aye, saak yak asukum so, kiiyo fokola-fokola-kelipla, Yesus ami dap-fatap-daalokoma tunum Judas aso tal-bom ale, Judas ayo bokoya-lomda: Kipyo! kano ata-bom iliwa, nita din tunum kaali, kuluwaata kayi! kala dap-tal miki-lom fiil buluk tokoli namti, kulu bombe kemin, ipta dap-tal-fuku dibii-unolip kayi! yakaya, iyo baa kutal daa-lomdipla, ");
INSERT INTO tif_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas asiik Yesus ami tiin dik-yak-dela-lom abiltap tal weng umola bokola-lomda: Nalmi kukup-nin tunum kaa bom-balap o? aka dap-tal miki fiil buluk tokola-laam-salale, ");
INSERT INTO tif_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","kulu tunum iyo tal Yesus namti dukum-kup dap-tal-fukulip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kanolipla, tunum maakup ma Yesus aso bom-bilip ata taba-lomda, bainat almi iim tem kawu bombe kaata, kuluu-lomda, pris awem tunum imi dabom ami ok tabola bom ilin tunum ma ami talangkal kaal malii kaata tik-daa kulaawala tiil abale, ");
INSERT INTO tif_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","kulaa Yesus ayo tunum tal dap-tal-fukulip imi bokoya-lomda: Ibi nali din lotu am diilim kaptamu tiin-bomdi unang tunum imi suunkup kukuya-laabi kawu, kano tal nam-tal-fuku sok de-namulakin kaa, kanimin o kalaliwa kaa, kulaasip. La, ibi kamala kalawuuta, aptum kusal ye-bam, mafek mafek yukut dakayin tunum ami dap-tal-fuku dedu-laabip tap ke-lomdip kanaat bal, asukum bal, bainat aye kiita, kulii tiltam akiip-na-lom de-namulum o, kala tiltam tilip i? Kaali ti, sawaayak kawu God ami Sukon Tem nami sang dolsip namti kulu tiltam tulu kemin, kulaa yaap o, yakala, ");
INSERT INTO tif_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","kulu Yesus almi daang bakaalin tunum iyo weng sandiple, Yesus ayo alik kelalip abiltap wakadaa una-tala-kelip o. ");
INSERT INTO tif_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kulaa, tunum man kasaa ma ata yak Yesus dibii-unip imi daang bakaala unabip kemin, ali ilim namaal kaata miki unala, waasi ita taba-lomdip, sok deduulum o, kala yak dap-tal-fukuliple, ");
INSERT INTO tif_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","almi ilim ayo dilduu ku kulu tii kela ilim dinim angtiil fatap ukadaa tabana ko. ");
INSERT INTO tif_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Awem tunum o kala pris imi kamok kamok alik isole, Juda kayaak imi kamok kamok aye, lo utamsip iyo tal awem tunum imi kamokim diilim hetpris ami am kaptamu tala-tala-keliple, kulaa tunum Yesus de dibii-tilip iyo dap-tama tal hetpris ami be daalip. ");
INSERT INTO tif_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kanum tala-biliwa, Pita ayo Yesus ami daang-tem samaan so kaptoowu akola dip-tal-dip-tal yakaba din hetpris Kayafas ami am kaami daam tem tam una. Lale, tam am unoma dinim; tiltam daak uti tem kaptamu, bomdaya, soldiya iso tiin-bomdip diil fuumip. ");
INSERT INTO tif_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kemin, pris o, kala awem tunum imi kamok kamok sole, alik imi kamok kamok so, iyo Yesus aalum o, kala-lomdip, tunum kawanta Yesus ata-bilip, kukup mafak so ma nola atabip kala, kala-somdupla, kiita fokoluwa weng talalmin umi baan diim kawu, bokoliwa yo, kala-lom imi fenip. La, ma atamalip disa keliwa, ");
INSERT INTO tif_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","kemin kawu, tunum yaapkan iyo Yesus ami sang ayo kasen-faka-bamdip: Ye, ali kanoba kanoba kayi kalbip. Lale, kamok kamok iyo utamipla, Imi weng ayo akal almi baka-bala baka-bala-kebip kala kalalipla, ");
INSERT INTO tif_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","tunum iip maakup maakup ma ita tiltam tola bomdiwa, ibakamin weng kaa bakaan-bamdiwa bokolip ko: ");
INSERT INTO tif_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ayo, fan nokol weng san-buluwa ayo boko-lomda: Ilom am ma daanula kawu, nalalta lotu am diilim awem kaayo, tunum ilta desip kaa, balatni bi am alep kelule, am asuum kulaa asuk kusnum ma delokomi. Yale, nali tunum dinan-umbip tap ke-lokomi disa yo, kalase no, kalbip. ");
INSERT INTO tif_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lale, weng kaa bakabip kakal ti, akal almi baka-bala baka-bala kebip kala, kalalip itamip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Awem tunum imi kamok kamok o kala hetpris ayo tiltam imi iipyak tem kulu tola Yesus ami dik-daala-lomda: Mep tunum kaa, bakap-tambip uyo kanimin o, kala weng an-anung-daa bokoyin disa, kebap yoko? Kii kanimin o, timbip aka. ");
INSERT INTO tif_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kata, Yesus ayo kano duluuma ilale, hetpris ayo asuk dik-daala-lomda: Unang tunum alik ili God ami win kufola-laabip kemin, kabi God ami uldaa-tam-buula tiltam Kamokim kesap tunum Kraist o kebip kaa, kapta ema? akaya, ");
INSERT INTO tif_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus asiik bokola-lomda: Kanum bakabap kaa, nita kemin, bom ilom kaptoop ali nitamipla, Dukum ami Man Nali abiil tikiin kawu, ilin titil-kup tabasa God ami sikil tiingtup diim o, kala kamokim ami baan diim kawu, tiinbi kala, nikip ilom ale, kaata utamiwa yi, Abiil tikiin umi ibin umi tip diim kabaaku tiindala tala, kalalip nita-mokomip o, kala Yesus ayo imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kanum bokoyilala kawu, Kayafas tunum awem diildiil ayo weng sandala, Juda kayaak imi aket uluum tabemin umi kukup uyo kanumin kemin, almi ilim mikiba kaayo, balata kutii kela tunum alik tiinbip imi bokoyila ko: Kipyo! Almi sang bokola kaa, nuli tunum ma fen-bam atamupla, kaata Yesus ami sang ayo maso ma numi bokoyokoma disa! ");
INSERT INTO tif_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kemin, ami weng mafak bokola kalawaali, God ami win ku-mafak-daalala, ibi weng sanip kemin, kipni aket fukunbip kaa, mep tunum kalawaali, kalok nolum o, kalbip i? yakale, alik iyo bokoyip ko: Ali ti atin kukup mafak kela kemin, dabaalup yak Rom kasel imi sikil diim abamnala aalip taanak o, kalip. ");
INSERT INTO tif_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tunum iip maakup maakup bom-bilip iyo kulu mok tik-ten-bamdip ilim ta kuluule, Yesus ami tiin matum ayo katela-lomdip, tangafap ta biiwaka-bam, titul saan-bam atafiimin weng uyo bakaan-bam: Kabi boko-lom: God ata nam-baala talsi kemin, nali mafek mafek kulaa alik utamsi no, ken-laabap kemin, kapkal nitamdap, Awu kaa ata neba kalap namti, nami win ayo bokolawa, titamon o, kala biiwakabi, yakbana-yakbana-kemsi keliwa kawu, bolis isiik Yesus namti biiwakamip ko. ");
INSERT INTO tif_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ayo abip uti daam tem kawu bom ilale, awem tunum imi kamokim dabom ami wok fukulin unang ma taldu, ");
INSERT INTO tif_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita ayo diil fuuba kala atam tal bokola-lomdu: Kapso ti, Nasaret kayaak Yesus aso tal-unen-laabap o, akuya, ");
INSERT INTO tif_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pita ayo yawaal daa-lom bokowa-lomda: Daa yo! Nali kupni weng bakabap kabak-ali dotu ma utamin disa yo, waka-lomda kulaali yang am daang kaami amitom mepso diim kulu tola bom ilale, ");
INSERT INTO tif_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","okok kemin unang kuuyo, Pita kaa atamdula asuk tunum ma kawu tolbip imi bokoya-lomdu: Kipyo! mep tunum kalawaali, Yesus ami tunum ma namti kalabe no, yakan-kaamule, ");
INSERT INTO tif_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita ayo asuk atin ti yawaal daa-lomda: I, ti disa te! yakale, ilanin tap tunum malo ma iyo Pita aso tola bom-bilip iyo Pita ami bokola-lomdip: Kabi nuli weng seluwa yi, Kabi Provins Galili kayaak imi weng tap bakabap kala tukup kemin, fan ti kapso Provins Galili kayaak kemin, kabi fan Yesus ami daang bakaalin tunum o, tambup te! aka kemiwa, ");
INSERT INTO tif_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita asiik weng dukum-kup bokola-lomda: Ee, kipni tunum kaami sang bakabip kaa, nali ma atamsi disa; nali kasen-fakamin weng ma bokoyi namti, God ata taba-lomda nayo angtiil yol kup-nak o, yakan-kaam-salale, ");
INSERT INTO tif_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","kulu awon kakaruk aalap ayo naan-tabamnale, Pita namti, weng san-ilomda, asuk aket fanang daala yi, Awu, Yesus ami kamasi bokop-na-lomda: Awon kakaruk aalap ayo naanbi liip alep fak-daalin disa, kama bom ilala, Pita kabi nami sang ayo bokop-na-lomdap: Ni kaa ma atamsi disa yo, naka naka kemsi liip asuumano fak-daalokomap o, nakase namba kaa, fan kulu kanoli no, kala kabak-ami aket kaata, fuku-daa-lomda dukum-kup amama ko. ");
INSERT INTO tif_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Am daan-ilom am takas tiil-banala, kutim kawu, awem tunum pris o, kala-laabip imi kamok kamok aye, Juda kayaak imi kamok kamok aye, lo utamsip imi kamok so, kamok kamok kusnum iso, iyo weng talalu-lomdip ilmi bolis imi bokoyip ita Yesus ayo sok de dibii-din dabaalip yak Rom kasel imi kiyap Pailat ami sikil diim abamnala, ");
INSERT INTO tif_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yesus ayo Pailat ami tiin diim kawu tolnaya, Pailat ayo dik-daala-lomda: Kabi Juda-miin imi kamokim king namti kulu bom-balap ema? akaya, Yesus asiik bokola ko: Nali kaa ma bokolin disa la, kabak kaltapta bokolap o, aka ko. ");
INSERT INTO tif_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kulaa, awem tunum imi kamok kamok iyo mafek mafek yaapkan ami sang ayo kasen-fokola-lomdip, tunum kalawaali faneng kanola ban keba keba kayi! kal-biliwa, ");
INSERT INTO tif_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailat ayo asuk Yesus ami dik-daala-lomda: Kabi mafek mafek sang yaapkan iyo kulii yak kapni win diim tii-bom bakabip kaali, weng sanap o? Kabi kanimin o kala imi weng kalawaali, maan tiiyin disa ke-lomdapla dulumbap i? aka. ");
INSERT INTO tif_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kata, Yesus kaali, kamok kamok imi weng uyo maan tiiyin disa kela kala, kala-lomda Pailat ayo fanang disa kelula, ayo aket yaapkan fukuna ko. ");
INSERT INTO tif_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Juda imi Pasova kaami diim kawu, kukup ma kaali, kanumin kemin, utamiwa yi, Wasital uyo tiltam tulu kaali, Juda kasel imi iintang am o kala Pasova inin am ayo daanu kaa kalale, kulaa iyo tala-tala-keliwale, Rom kasel imi kiyap ayo bokoya ko: Tunum sok deduusup ayo iltipta boko-lom: Kanuminok kulaata tildaa dabaalin o, kalip kala, kalaliya bokoyi: Ata din tildaali no, yakaya, ilta kulaata ko, kalum o, kala-silip; almi soldiya iyo din til-daa-lom win tolola kelip un-un-ken-umbip. ");
INSERT INTO tif_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kemin, sawaayak kawu tunum malo ma gavman so, waasi din-bomdiwa tunum iyo ye-bilip saaka-laa-biliwa kawu, gavman ayo taba-lom sok laabi yim-tii kutal kalabus am daalip tiinsip. Kemin, kaptam bilip imi tunum ma ami win kaali Barabas. ");
INSERT INTO tif_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kemin, tunum tal ang-delip iyo tildang Pailat ami bokola-lomdip: Pasova ima inan-talan-umbup kaami kukup kanuyila-laabup alaltap keyan o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pailat ayo utamaya yi, Yesus ali kukup mafak kaata ma kanolaya, kamok kamok iyo dabaalip tildak nami sikil diim ababa daa kala-som ale, kuno unang tunum iyo Yesus ami weng ayo baka-balaya, weng san-ilomdip ami win ayo kufon-bamdip fiyaap duu-biliwa kemin, kaata kamok kamok kiita, almi kanuba kaata, tolola-lomdiwa kemin, dabaalip tildak nami diim abamna kala, kala-lomda, Pailat asiik unang tunum imi dik-daaya-lomda: Ipni aket fukunin kaa, nali nalmi soldiya imi bokoyilila, Juda kasel kipni kamokim king ata tildaa dabaalin o, kebip ema yo? yaka. ");
INSERT INTO tif_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kata, awem tunum imi kamok kamok iyo taba-lom tunum tal debip imi wiis moyiwa, iso, Pailat ami weng kaayo, maan tela-lomdip: Kapni soldiya imi bokoyawa, Barabas ata-kup sok baalin o, akiwa, ");
INSERT INTO tif_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","asuk Pailat ayo bokoya-lomda: Yak kanum bokolip kulaali, Juda kasel kipni king kamokim o, ken-umbip kalawaayo, kalok noyan o, nambip i? yakale, ");
INSERT INTO tif_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","isiik naan-bamdip boko-lom: Dabak as diim daa-lom aaliwa, taanak o, kemipla, ");
INSERT INTO tif_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat ayo bokoya-lomda: Aa, kabak kanimin o, kalalip kanubip yoko? Kaali, kalok nolin ban ma ukduuba no, kalalip kaami kalan o, kalalup aalokomup yoko? yakan-kaaba. Lale, weng san-ilom ili dukum-kup fuut-bam boko-lomdip: Dabak as diim daa-lom aaliwa, taanak o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat ayo kanoliya, tunum tal debip imi aket ayo yaap ma keyuk o, kala-lomda imi weng kaata weng san-ilomda almi soldiya imi bokoyilaya ita din Barabas ata sok tildaa dabaalip unang tunum imi iipyak tem kawu unale, Yesus kaata, sok faklet kuluu-lom lakatal kaan-bam biwakabi, keliwa kawu, soldiya imi bokoya-lomda: Dabak as diim daa aaliwa, taanak o, yaka-lomda dabaaya yak soldiya imi diim abamna ko. ");
INSERT INTO tif_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kemin, kiyap Pailat ami soldiya iyo Yesus ami dibii-tam kiyap am dukum anung kaptoop ali almi siin-laamin am kemin, dap-tam kaptam daa-lom soldiya malo ma iyo naan-daayilipla, iyo alik tala-tala-ke-lomdip, ");
INSERT INTO tif_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","kasen-foko king imi ilim miki-laabip tap kelum o, kala-lomdip ilmi ilim isak fulut ma kaata, kuluu kulaak tinela-lomdip sok langliing so kaata, ukduu-lom king imi nafalum tap ke faa-lom, kutam ami dabom diim dildaak tinela-lomdip, ");
INSERT INTO tif_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","iyo atafiimin weng ma ami bokola-lomdip: Juda kayaak imi kamokim king kabi balap yoko? an-bomdip, ");
INSERT INTO tif_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","malal ta kuyak dabom dakan-bam ale, mok tak-saala tal-une-bamdip, king imi weng umkaayin kukup kaata kuluu katuun duung fakela daak almi diim kulu tiin-ilom weng tangbal kaayo bakaalip. Lale, kulaa fan disa; kasen-foko atafiimin weng kaata, bakaan-bilipla, ");
INSERT INTO tif_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","kanon-bamdip atafiimin weng bakaanbip uyo disa kelale, kulu iyo ilim isak fulut dildak tinelip ayo dilduu kukan-tela-lomdip asuk almi ilim kaata, kuluu makela dibii tam saaklo abalup, dibii-din dabak as diim daa aalum o, kala-lom dibii-unip ko. ");
INSERT INTO tif_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Soldiya iyo Jerusalam kaptam kelaliwa, Yesus ayo dibii un-bomdip iyo atam talaaliwa yi, Aleksanda so, Rufus so alap imi aalap Saimon kaa, Provins Sairini kayaak ayo saaklo kawu, talaba kala, kala-lomdip maaklo aso dabaalip tal kabak bana Yesus aalokomip kaami as tiim ayo kuyak telip kuliila aso yakyak ");
INSERT INTO tif_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","bilin Golgota Mukun o, kala kaami miit kaali, Tunum Dabaal Kun Mukun o, ken-laabip kaba unip. ");
INSERT INTO tif_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Soldiya iyo wain wok sole, marasin atul tabasu meya yo kebip kaaso, kuyak mim-daa-lomdip fal-siki-lom Yesus ami kolup, inamnaya kawu, dabak as diim daa sil bikilup ami angtiil yol ayo katip so kelak o, kala kolip. Lale, Yesus ayo inam-noma daa, kelala, ");
INSERT INTO tif_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","kulaa Yesus ayo dabak as diim daa-lomdipla kawu, iyo Yesus ami ilim kaali, ku kuluu ti kutii-bomdip tuum katip katip saatu iyo kulaalup tam aba daak aba ke-bam, kanta ata ata kela namti, Yesus ami ilim ayo kuluulala, atamum o, kala-lomdip, Yesus ami ilim namti dalela-lomdip kabanulip ko. ");
INSERT INTO tif_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesus ami dabak tam as diim daa, sil bikilip kaali, atan tal dibimnin disa kama ilula, dabak tam as diim daalip. ");
INSERT INTO tif_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kemin, Pailat ami okok kemin tunum ma as kom ma kuluu-lomda kalok ami kalan kaata ma aalip kala-lomda sang ayo ami diim kabaku dola-lomda kanum bokola ko: Tunum kalawaali Juda kasel imi kamokim king o kala as kom diim kabaku dola-lomda kuyak tam Yesus as dabom diim tip kabaku kutam diila ko. ");
INSERT INTO tif_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Soldiya iyo taba-lom Yesus dabak as diim daabip-kup, kuno tunum alep ma yem-tal-une-bamdip, imi bung mafek mafek yukut dakaayin tunum alep yakal, yim-bital yim-bak as diim daa-lomdip, ma ata dap Yesus ami tiingtuplo kawu dip-tam diibip-kup, ma ata dibii-tal aba yang awaanlo kawu dip-tam dii keya-lomdip yim-tiilip. ");
INSERT INTO tif_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kanolip kaali, siin sawaayak kaptoowu God ami Sukon Tem uyo boko-lomdu: Ili kukup mafak ayo soldiya ita taba-lom fuut-tabin imi kukaayila-laabip tap ke, mep tunum kakal kanola kolip o, kalsu. Kemin, kulu tiltam fatapnu. ");
INSERT INTO tif_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tunum mep kulu tal-unebip iyo aban-den-bam Yesus ami atafiimin weng uyo bakaan-bamdip: Kapyo! kaltapni bon tem weng boko-lomdap: Nali lotu am diilim dukum ayo balata kutiili bombii am alep keluya, am asuum diim kawu, asuk delokomi no, kalalap, kaltapni tong bakamsap kemin, ");
INSERT INTO tif_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","baan kaltapni angtiil lak kaata duu-lomdap tam-bak as diim daabip ayo, kulaa kelalap tildaak abamnan o! akan-kaa-bamdip atafiimin weng bakaan-bilipla, ");
INSERT INTO tif_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","awem tunum o kala-laabip pris imi kamok kamok so, lo utamsip iso, yakal ti kuno Yesus ami atafiimin weng bakaan-bamdip, nikil iyo bokola una-tala-ke-bam bokolip: Kaali unang tunum kayaak kayaak imi angtiil lak kaata, duu imi dong dakaayim-bala yaawa-laabip. Lale, ali kalok kano-lomda almi angtiil lak kaata ma duu-lom yaap-nama dinim keba ni? ");
INSERT INTO tif_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aa, ti tifan God ami uldaa-dabuula tiltam Kamokim ke-lomda, Israel numi kamokim king kesa namti, alta as diim ayo kulaa kela tildaak abamnala, nokol atam-somdupla, Awu, fan kaali ti God almi man u! kalum o, kala atafiimin weng bakaalipla, tunum alep Yesus aso nikil maakup yam-bak as diim daabip yakal kuno atafiimin weng uyo bakaayim-bam kemip ko. ");
INSERT INTO tif_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Atan tal dibimnule, kutamiip dukum tiltam-ilomdu, am bokon alik kala dik-daa kulaasu uyo tilnong molu bombii, atan ayo an-fal-kela tal aba dayak 3 kilok kela kawu, kutamiipba namti asuk disa kelula, ");
INSERT INTO tif_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","malang tinilin ayo disa kelon e, kem-sulule, kuyaku Yesus namti Hibru ilmi weng dukum-kup baka-bam boko-lom: Eli, Eli, lama sabaktani yo, kala kabak-ami miit kaa boko-lomdu: Nami God kapyo, nami God kapyo, kanimin o, kala kuno kep-nanbap yoko? kal-bomda Hibru ilmi weng kaata kuluu bakamale, ");
INSERT INTO tif_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tunum mep kulu tolbip imi tunum malo ma iyo weng san-ilom bokolip ko: Aa, ayo sawaayak kawu God ami weng ku-fatap-dakamin tunum profet biisa Elaija ami naala-taba no, kala-lomdip ");
INSERT INTO tif_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tunum ma abiltap yang mafek mafek as abum altap kaata, kuluu kulaak wain ok atul tabin kabaak mo-lomda, as daang ta tiila kulii-tal koli inamnak o kala, kulii-tal aba tam kukaalale, aptum ayo bokola-lomda: Kelap titam daa atam iluwa, Elaija ata tal tildaa dabaala tildak tala ne? disa ye? kalum o, akale, ");
INSERT INTO tif_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","kulaa, Yesus ayo asuk Aalap ami dukum-kup naan-daala-lomda, kulu mam dakat kala saakna ko. ");
INSERT INTO tif_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kanolala, mep lotu am awem diilim kaptamu ilim aalap dukum ma ku-dii-lom God ami abiin awem ayo katiisu. Kemin, Yesus ayo saaka kem-salale, kulu ilim aalap dukum ayo bitam mutum diim kulu, tela tikip-kup biki tala ti kulii bital-daak daa-lom, malii na malii na ke-lomda kulaalaya, God ami abiin awem namti ku-fatap-daalala, ");
INSERT INTO tif_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","100 soldiya imi kamokim ayo, Yesus almi mepso kulu tolba kemin, almi tiin matum kaayo, atama yi, Yesus ali kanola taana kala kalale, bokola ko: U faneng, ali ti God almi Man o, kala ko. ");
INSERT INTO tif_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kemin, unang yaapkan yakal kuno Golgota Tikiin kawu tiinaabip kemin, iyo takas yang samaan so kabangu tola atam ilupla, soldiya iyo Yesus kaa kalok nolip kala yukum o, kala-lomdip nikil iyo yang bom atafiimip ko. Unang nikil kaa tolbip kiili, Makdala kayaak unang Maria ukol, Jems so, Josep so, alap imi awak Maria ukol, Salomi ukol, imi afalop kusal yakal nikil kanolin kiita tolbip. Kemin, ");
INSERT INTO tif_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","siin kawu, Yesus ami Provins Galili kaptamu bomda tal-unem-soma kaali, unang asuumano kalawiili, Yesus anang tal-une-bamdip imi ima fuuyim-bam ale, imi tik-daayip tal-une-bam kemsip. Kemin isole, imi afalop kusal unang yaapkan iso, nikil iyo maakup Yesus aso tal Jerusalam tal-silip kiili, tal tola-bomdip, Yesus ayo atafiimip ko. ");
INSERT INTO tif_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Tunum ma Josep awasekim kaali, abip Arimatea kayaak ali kamokim tangbalim o akan-kan-umbip. Kemin, ali God ami unang tunum tiin molokoma kaami am daan tiltam tabokomu kaami liip-kup fen-tabasa. Kemin, ali utamaya, Sabi kaa, God ami iintang am daanula, kanu-mokomip ami mafek mafek ayo dot-bilip bii am tiinu kala, kala-lomda suun-daalama disa kuno din Pailat ami dik-daala ko: Kapyo, yaap o, kalap namti, Yesus ami as kuli kaali, kup-napla, kulii-unon o, kalalila tili no, aka dik-daalaya, ");
INSERT INTO tif_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ayo fanang alik tam banelu fanang dakamsile, Kwin, kaata fan taana ne? daa ye? kemsi 100 soldiya imi kamokim ami weng naan-daalala tildang tala, Pailat ayo dik-daala-lomda: Fan, Yesus kaa abiltap saakna ema? akala, ");
INSERT INTO tif_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ayo, faneng ali sawaayak kawu taanba te! akale, 100 soldiya imi kamokim ami weng kaata-kup, weng san-ilomda Josep ami bokola-lomda: Yaap kemin, din-ilomdap kuluu-kulii-din bululan o, akaya una ko. ");
INSERT INTO tif_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","47","Makdala kayaak unang Maria uso, aa awasekim Josep awak Maria uso, alep iyo talalu atafiimupla, ayo dibii-din doku bulula kala kalum o, kala-lomdip talalu atafii-bam iliwa, Josep ayo din ilim namaal ma molaya, aptum ma aso alep din-ilomdip Yesus kaayo, taldaa dabuu-lomdip ilim ta falala-lomdip dibii-din kom tem tunum ilta tuum tem kaayo, kaluusip kaptamu dawaa-lom tuum tem kaami saal ayo tuum dukum ma taa-bi-lom talalu-silip. Kemin, kuuta baplun baplun kulii daang tem ayo akii kela uniwa kawu, unang alep kiili, kanubip kaayo, alik atamip ko. ");
INSERT INTO tif_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kulaa God ami iintang am ayo disa kelule, Makdala kayaak unang Maria ukol, Jems ami awak Maria ukol, kano Salomi ukol, nikil iyo tang tangbal-kup tabin ok ayo saanbi kuliilip tii kulii umbital Yesus ami angtiil ilik daalupla yo, kala nikil saanbi. ");
INSERT INTO tif_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kutiilip se sintam Sande am maakup kaami kutim malang tem atan uyo kama tik-daa kulaalu tal asal asal kem-sulule, nikil iyo Yesus tuum tem dap-tiibip ayo din atamum o, kalalip tal-bom ale, ");
INSERT INTO tif_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","nikil ilmi baka-bamdip bokolip: Tuum dukum ma baplun baplun kulii yang saal lela-silip kaali, dukum kemin, kaa kanta dik-daa kulaayila yak banula, tam atam unokomup i? kem-tal bom tiyang daalipla, amitom saal kaa busuuba kala, kala-lomdip, ");
INSERT INTO tif_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","nikil iyo yak aba tam tuum tem tam ulip, Tunum kasaa ma ilim namaal-kup tabasa ma dildaak tini-lomda, tal aba yak tingtuplo kaldangu tiinba kala, atam suuniple, ");
INSERT INTO tif_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ayo nikil imi bokoya-lomda: Nikil kipyo! kibi nami nitam suunin daa; Nasaret kayaak dabak as diim daa aalip saakba ami fanang fen-talabip. Yale, ali kalawu bombe disa; ali tam tiinda, tuum tem kaltam kelala, tam bana te! Yesus kulaa dibii-tal kultamu buluu-silip. La, tii kala abiin-kup kela umba kemin, atamdiwa, ");
INSERT INTO tif_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","nikil kipta din Pita so, Yesus almi aptum kusal malo iso, imi bokoya-lomdip: Yesus ali siin kawu bokoya-lomda: Nasiik wak-toloya unila, din Provins Galili kawu nita-mokomip o, yakase. Kemin, kaa fan, asiik wak-toloya umbaba. Kemin, din atamin o! kala kanum bokoyin o! kala ko. ");
INSERT INTO tif_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kemin, nikil iyo atam suun-daa wulwaal-kup tap-tap-sile, kulaa tuum tem kaayo, kela tiltam saaklo aba, uka-daalip unip. Lale, iyo suun-daabip kemin, tunum so ma bokoyilalip dinim kelip ko. ");
INSERT INTO tif_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus ayo Sande kutim malang tem tam tiindala, diildiil din Makdala kayaak unang Maria umi diim din fatapna atamule, siin kawu, sinik mafak fetkal ita unang kuumi diim kawu bom ililipla, Yesus ata fotabamna unaasip kuuta. ");
INSERT INTO tif_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kemin, unang kuu Yesus atam-ilomdu, uyo din tunum nikil Yesus aso ilsip imi bilip kawu din ulu, nikil ili aket uluum keya-bulu bomdip amabip kala, din itam-ilomdu ");
INSERT INTO tif_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","bokoyu: Kipyo! Yesus kaali, asuk tam tiin kawong kela ilaya, atamdi tili no, yuku. Katale, ili unang umi weng kaali, ma weng sanalip disa kewip ko. ");
INSERT INTO tif_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mulo kawu kuno, tunum alep ma abip dukum Jerusalam ayo kulaa kela nulmi abip unum o, kala unba-bilipla, Yesus ayo tiltam tunum kusnum alaltap ke din alep imi itamala, alep iyo atam-ilomdip, ");
INSERT INTO tif_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","asuk ilmi abip ayo kelalip tal Jerusalam tal-ilom Yesus atam tilip kaami sang kaata, tal aptum kusal bokoyip. Iyo aa ti kuno, aptum kusal imi weng kaa weng seyilin disa kelip ko. ");
INSERT INTO tif_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kuno, Yesus ami daang bakaalin tunum kumkal iyo biile, ima inan-silipla, Yesus ayo imi diim kawu fatapna atamipla, ayo itama yi, Nikil imi aket ayo fanang daa, Yesus ayo tam tiin kawang ke-lokoma kebip disa le, aa unang tunum tal bokoya-lomdip, Yi, ali tam tiina atam tulup o, kalbip kaa ili fan o, kalolip disa ke-lom, kaa weng sanokomup disa yo, kal-bom kebip kala, kala-lomda, kaami kalan kabak-ata nikil iyo katii-yimbi keyale, ");
INSERT INTO tif_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","kulaa, Yesus ayo nikil imi bokoya-lomda: Ibi nami weng tambal ayo kulii-din am bokon alik kala dik-daa kulaasu kaami unang tunum imi bakayila-tal-une-bilipla, ");
INSERT INTO tif_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","kanola unang tunum kawanta tal aba nami lak duulipla, oksam okoyip namti, God ayo taba-lom kiili, dong dokoyala, ilmi ban kemin kukup ayo, kela-lom tambal-kup ilokomip. Kemin ale, kanta nami lak kaayo, duulin disa kelip namti, God ata taba-lomda unang tunum iyo dukum-kup yim-bak saan-bi-lomda angtiil yol kaa kuyokoma. ");
INSERT INTO tif_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nami aket kup-nin kiili, God ata dong dakaayin-balala, mirakel o, kala kukup akal almi kusnum kusnum iyo nuu-mokomip. Kemin, kanu-mokomip kaali, ti nami win kaata-kup kufo-lomdipla, sinik mafak kii fotabamnip yak bane-biliple, kuno weng kusnum ma utamsip disa kaayo baka-bamdip, ");
INSERT INTO tif_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kanola inap mafak atul-kup tabasa ayo dabuu dap-tal-fukulip aye, wok ina saaka-laamin ami inamnip aye, kiili yela saaka-laamin daa; kuno, sikil kuyak unang tunum mafak-alin imi dabom diim tiiyipla, unang tunum iyo yawaa-laa-bam ke-mokomip o, kala Yesus ayo almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kamokim Yesus ayo weng bakayimbi disa kelu kamboya kem-salale kulu, God ayo Yesus dabuu dibii tam abiil tikiin daalaya, God ami sikil tiingtuplo kawu kamokim ami baan diim kabaaku tiina. ");
INSERT INTO tif_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kemin, kanolaya kawu, almi daang bakaalin tunum namti kawu, yak abip ma ma alik kiiyo, bakayila-tal-une-bilipla, Kamokim Yesus ami Sinik Tambal ata taba-lom iyo dong dakaayim-balaya, almi siin weng bokoyase kaali ti kanu-bamdip unang tunum iyo nikil imi mirakel kanubip ayo utamipla yi, Kiimi weng kaali, ti faneng kala, kemsip ko. ");
INSERT INTO tif_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nak-tunum kamokim Tiofilus kaa tiinsap o? Nali Luk nata sukon kalawaali dola kup-ton o kalalila ko. Kapkal utamsap, siin sawaalak kaali, tunum yaapkan ili God ayo taba-lomda mafek mafek yaapkan kiili numi iipyak tem kaptam-ami kanumsa kaami sang kaali, weng san kaa-bam ale, dik-dakaya-tal-une-bam ifii-bam dolsip. ");
INSERT INTO tif_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tunum ilmi tiin alep alep Yesus kaa atafiimsip iyo ata-bom-iliple, Yesus ayo, kamasi kaptoowu kanum yakyak kulii umbital kula diila kala, kalbip-kup; kulaali yikal Yesus ami weng kuu nuli bakayin-bilipla, weng san-kan-tabasup. Kemin ale, tunum kawanta sukon kaa tunum dola-silip ili Yesus ilmi tiin alep alep atam-silip, ilimi bon tem weng kaata, weng san-ilomdipla dola-dola-kemsip. ");
INSERT INTO tif_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kulaa, nakal kamosinim kaptoowu sukon kala dola-silip umi diim ayo tik-tii-bamdila utafii-bam ale, unang tunum imi bon tem kawu kuluu laa-bam kanu-bomdila, weng anung anung kiili, kuluu kuyak-kuyak-ke-lomdi tambal-kup afetusii. Kemin ale, Tiofilus kapni dola kup-tila, ");
INSERT INTO tif_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","utam-somdapla, weng dola-lom kup-ta-silip kabak-ami miit kaali, bam-daa utam-ilomdap atin ti kaal kelan o kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot kaali, Provins Judiya kaptam-ami kamokim o kala king ke bom-balaya, tunum awem ma bombe ami win kaali Sekaraya. Ali awem tunum Abiya ami man loop kaptoop ata kemin, ami kalel umi win kaali, Elisabet uli awem tunum Aron ami manum kaptoop ami man loop. ");
INSERT INTO tif_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kemin, God ami tiin diim kaali ti akam kiimi kukup kaa ti tambal-kup kutal-fuku kulii-taba-lom ale, God Dukum ami weng kuka-daasa kaali, alik tambal-kup tabuu kutama taba kesipla, ");
INSERT INTO tif_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","kulaa, Elisabet uyo man dinim kelu akam laabipla, biile kulaa unang sawalnule, imak akal kuno sawalna kelipla, ");
INSERT INTO tif_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","kulaa, Sekaraya kaami tunum miit imi okok kemin am kaali daanule, kulaali tunum iyo Jerusalam tam lotu am awak diilim kawu okok ke-biliple, Sekaraya akal God ami am awem kaptamu tam bomda awem tunum ke ilin imi ok kaali, okok kema. ");
INSERT INTO tif_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kemin, awem tunum imi uldaa-dabuu-laamin kaami kukup kaata kuluu-lomdip Sekaraya ayo uldaa-dabuuliwa, tam God ami atin ti am awak awem kaptamu tam-ilomda, as ma kaami dan kaata kuluu-lom, as kaa kuyak daala kiin-balala, as lak so, tang tambal so, kiita God ayo ataba-kup, tang tabe-balala, fiyaap duu-mokoma no kala as kuyak daala kiina ko. ");
INSERT INTO tif_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","As dan kaami as ayo kuyak daala kiin-bulu bom-ilale, unang tunum yaapkan iyo ilmi kukup kaata kuluu-lomdipla, tam lotu am diilim ami mepso kulu bomdip beten kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Beten kemiple, God ami ensel ma kasentap-kup tal as dan ami as kuyak dakamin umi baan diim kabaak-ami balang diim, tingtuplo kulu tolnale, ");
INSERT INTO tif_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","kulaali Sekaraya ayo atam-ilomda, kwin! fanan taal-bi-lomda atam suunale, ");
INSERT INTO tif_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ensel ayo Sekaraya ami bokola: Sekaraya kapyo, kabi suunin disa yo! Kapni beten kebap kulaali, God ayo weng sanba kemin, kapni kalel Elisabet uyo man tunum man ma kuulokomu. Kemin, ami win kaali, Jon o akan. ");
INSERT INTO tif_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kuulokomu kaali, akam ipni aket tem kabak-ali atin ti akal tambal ma keyilule, fiyaap duu-bam ale, unang tunum yaapkan yakal ti kanola ami fiyaap duu-mokomip o. ");
INSERT INTO tif_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Dukum ami tiin diim ayo, ali win tabin keba-kup, God ami ok awak dukum uyo kutal-fuku ke-lokoma no. Ali wain ok mafak atul-kup tibin so kaali, ayo inokoma disa yo; kuulokomu kawu, God ami Sinik Tambal ayo tal ami aket tem kabaku donga-lom suunkup ilokoma ko. ");
INSERT INTO tif_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jon ata, Israel-miin imi bakayin-balaya, yaapkan imi aket fukunin uyo fal-siki-lomdip, Tunum Dukum God ami lak uyo duulokomip. ");
INSERT INTO tif_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kemin, God ami Sinik Tambal ata Jon ayo dong dakaan-balala ami kukup sole, titil so, ayo God ami weng ku-fatap-daa bakayin tunum Elaija ami kukup sole, titil so, ultap kelaya, asiik Kamokim ami bon tem tunum ke taldala, awil-fakal imi kukup mafak mafak ilmi man imi kukaayilin uyo takan-tiiyilale, awil-fakal imi aket uyo, man imi kuyipla, alimal iyo abiin tambal-kup tiinokomip o. God ami weng kuyang saak tiimin tunum imi dong dakaayin-balala, imi aket fukunin mafak so, kukup mafak so, uyo kulaale kukup tambal so, aket fukunin tambal so, kaata-kup kutal-fukulipla, ayo tunum so, unang so, iyo Kamokim ami sang kaata bakayin-balale, kiimi aket fukunin uyo dong dakaayin-balala, yakal ilmi aket uyo fal-siki talalulip kala, kala-somdala Kamokim ayo talokoma kayi! kala ensel ayo kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kanum bokolale, Sekaraya asiik ensel ami bokola ko: Nali dok kano-somdila, weng kaluuli utam, Awu, faneng u kalokomi ni? Nakal tunum sawolnile, nami kalel wokol kano sawalnu kesup kaali yoko? akale, ");
INSERT INTO tif_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ensel asiik ami weng uyo maan-tela bokola: Nali God ami okok kemin tunum diildiil Gebriel nata, God alta nam-baala tal-ilomdi, God ami kalaan weng tambal uyo bokop-ton o kalali tili te! ");
INSERT INTO tif_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kemin, kabi weng kala weng selan aa! Kabi kamala kaali, nami weng uyo weng selin disa kelap kala, kala-somdala God ali kapni del tem weng uyo dal mop-ta kemin, weng kaa baka-mokomap disa ke-bom bii nami weng bokop-ti uyo, tiltam ilom tituun kem-sulule, kapni kalel uyo man kuulula kuyaku, kapni del tem uyo, asuk weng kaa baka-mokomap o, aka ko. ");
INSERT INTO tif_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kemin, ensel ayo bakaan-bala, bom ilale, unang tunum iyo Sekaraya ami fen-bam ale, aket fukun-bam bokolip: Kwin! Sekaraya kaa, kanimin ma tiltam tulula, ma nuu-bamda am awem kaptamu tiinba ni? kal-bomdip aket yaapkan fukun-bamdip kanumip. ");
INSERT INTO tif_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sekaraya ayo kulu tiltam abip talale, unang tunum iyo atamipla, weng bakamin dinim kela tiltam abip tala kala, kalbip-kup atam ale, Kaali God ami am awem kaptamu mafek mafek akal kusnum ma atama nema yo? kalalip kanumipla, Sekaraya akal utama yi, Nami del tem ayo God ata dal-mop-na kala, kalalaya, sikil ata-kup unang tunum imi kukuyin-bamda kanolin kanolin o kema ko. ");
INSERT INTO tif_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kemin, Sekaraya ayo lotu am diilim umi okok kebi disa kelule, kulaa ayo Jerusalam kaptam ayo kelala almi abip unala ");
INSERT INTO tif_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","kemin, kulaa din bombii luuka le, kulu ami kalel Elisabet namti unang sawal diim kulu man kumni! kala, kalbu-kup, kulaa am kaptamu bom-bulu bii, kayoop awakal kiita duk-duulu. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet uyo boko-lomdu: God dukum alta olen daap-na-lomda nami man dinim bom-laabi kaami fatom uyo kukan-tiip-namba kemin, kamala kuluwaata unang tunum imi tiin tem uyo fatom dinim kep-nu no. ");
INSERT INTO tif_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kemin, Elisabet uyo man kum ke-bom bii kayoop bukupkal kiita dakan-tii kem-sulule kawu, God ami ensel Gebriel ayo dabaala tal Provins Galili kaptam-ami abip ma bombu kaali, Nasaret kawu tal-ilomda, ");
INSERT INTO tif_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","unang sii ma bombuu umi win kuuli, Maria kemin, Josep ami weng bak-daalip bom-ilule, ali King Devit ami manum kaptoop ami loop kemin, ");
INSERT INTO tif_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ensel ayo tal bokowa-lomda: Nafalop kaa laabap o? Tunum Dukum ali mafek mafek sakbaalim dukum ma kup-ton o kalalaya, uldaa-tam-buuba. Kemin, kupni diim kulu tiinba no, wakale, ");
INSERT INTO tif_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria uyo weng kaa weng sandula, aket dukum-kup fukun-bulula, kulaa yak kanolin weng kaata, kanimin sang ma bokop-na ni? kemule, ");
INSERT INTO tif_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ensel ayo bokowa: Maria kupyo, suunin disa yo; God ali ti kupni fiyaap uyo duu-bamdala uldaa-tam-buuba kemin ale, ");
INSERT INTO tif_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","kubi man kum ke-lomdap tunum man ma kuulokomap ami win kaali Yesus o, akolap ko. ");
INSERT INTO tif_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kemin, ali bom bii-lom kaata kamokim kelaya, ami win kulaa fan Sakbaalim Dukum God almi Man o kala God ayo kanum bokolokoma. Kemin, siin sawaayak kaa Man kaami awaalik Devit ali kamokim king ke-bomda bom ilsa altap kelaya, God Dukum ayo Man kalawaasiik uldaa-dabuula tiltam kamokim ke-lokoma. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","kaata taba-lomda Jekop ami man loop Juda kayaak kaptoop unip kipni suunkup suunkup tiin molokoma. Kemin, ami tiin molokoma kaptoop ali disa ke-lokomu disa te! Kanolin-kup ilokomu no, kala kanum bokowa ko. ");
INSERT INTO tif_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kala kanum bokowale, Maria usiik ensel ami bokola-lomdu: Kaa fan bokop-nap lale, nali sii bombii kaa dok kano-lomdila, man kaa kuulokomi ni? akule, ");
INSERT INTO tif_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ensel asiik bokowa-lomda: Kuwe, God almi Sinik Tambal alta tal kupni iipyak tem unale, God Dukum alta dukum-kup tam-titil-diilokoma no! Kemin, man kuulokomap kaali, fan atin ti ban kemin dinim ale, Man kaali God almi Man o akan-kaa-mokomip te! ");
INSERT INTO tif_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","God ali titil tibin kemin, yak mafek mafek alik kiili, kanolama. Kemin, kupni kokneng Elisabet uyo, sawalsu. Katale, kuno ti man kum kebu. Kemin, uli man tunum ma kuulokomu. Kemin, siin kaa, uli man dinim kesuu no, ken-umbip. Yale, man kumun-alomdu bom bii kayoop bukupkal duk-duubu no, wakale, ");
INSERT INTO tif_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria usiik bokolu: Nali Dukum almi bon tem ti kultam daalin unang kemin, mafek mafek sang kulu bakap-nimbap kulaa, kuno kunop-nama no, akule, kulaali ensel ayo kambowa tabana ko. ");
INSERT INTO tif_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kewa unale, kulaali Maria abiltap bung ayo webi kuliilu tam aba yakyak bilin Provins Judiya bokon kaami amdu tem kawu abip ma bombe kaptam banu kemin, ");
INSERT INTO tif_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","yakyak din Sekaraya ami am tam ilomdu, Elisabet umi weng fokowa-laam-sulule, ");
INSERT INTO tif_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","kulaa Elisabet umi man unaak mat tem kawu bombe namti uunfoko tam aba daak aba keba kala, kalale kulu, God ami Sinik Tambal ata Elisabet umi dongnu kewala ");
INSERT INTO tif_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","dukum-kup Maria umi bokowa-lomdu: Dukum ami dong dakaap-tin kup-timba kaa, unang alik imi dong dakaayila-laaba ultap disa; kupni dong dokop-tamba kaali, sakbaalim dukum ale, man kupni mat tem kabaku bombe kaa Dukum ami dong dakaalin ayo kola keba ko. ");
INSERT INTO tif_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kwin i! nali win dinim kaa, kupta Kamokim ami awak ke-lokomap kawi! Kanimin o kalalap nami fanang kala talbap? ");
INSERT INTO tif_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kupni weng umuup-nap weng seli kaata, nami man mat tem kuldaku bombe ayo weng sandala, fiyaap duu-bamda uunfoko tam aba daak aba kema atami. ");
INSERT INTO tif_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kulaa tambal kemin, Maria kupni Dukum ami ensel weng kutiip-timba kaa fan tituun u kalap kemin, kulu Dukum ami weng kuka-daaba uyo kup-ta, atam-ilomdap atin ti fiyaap duulokomap o, kala Elisabet uyo Maria umi kanum bokowu ko. ");
INSERT INTO tif_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria uyo Elisabet umi weng kaata, weng san-ilom baal wii-bamdu bokolu: Nami aket tem kaldaak-ali fiyaap dukum kep-nu kemin, Dukum almi-kup dap-fiil tii-bomdi bakamon o kalalila kemin, ");
INSERT INTO tif_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","God ali nalmi iliim bomin tunum kemin, nami aket tem kaldak-ali fiyaapmin dukum kep-nimba kaali, ");
INSERT INTO tif_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","dok kata naa kalolip: Nali win dinim unang katale, God alta nami aket tem uyo atam-ilomda uldaa-nam-buuse. Kemin, kaptoop kaptoop unip kaali, unang tunum alik iso, Man iso, ili nitamiwa yi, God ata mafek mafek tangbal ma kup-na kala, kala-lomdip, atin ti uli fiyaap duumin unang i! kalokomip o. God alalta titil miit kayaakim kemin, ami titil kaata taba-lomda dong dokaap-nin sakbaalim dukum uyo kup-nimba. Kemin, utamila, God ami win uyo atin ti ban kemin dinim; atin tambalim dukum bombuu kala, kala-somdila ami tong kaata kano bakamon o, kalbi ko. ");
INSERT INTO tif_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dok kanolin kiita God ami suun-bamdip ami win uyo kufola-lom ami weng uyo kutal-fukulip namti, God ali kiili olenin-kup kamayin-bamdale, imi man loop tap-tiila unip kaptoop ayo olen-dakaayin ayo ti kanolin-kup kanun-una. ");
INSERT INTO tif_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kemin, God ami titil dukum kaata kuluu-lomda unang tunum God ami weng, weng san-kaamin dinim; kuyang saak tiimin iyo fotabam-nala abiltap ukadaa unaa-silip. ");
INSERT INTO tif_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kemin, God ayo taba-lom tawaal diim kaldaak-ami tunum win tibin iyo yam-baak tabiile aa, tawaal diim kaldaak-ami win dinim tunum ita yim-buu yim-fosa no. ");
INSERT INTO tif_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","God ali taba tunum mafek mafek dulu iipnip kiimi men tem uyo dongnu keyinba-kup ale, tunum win soyal kelip iyo mafek mafek kayaak kiimi men tem kaata disa; kamboyim-bam kem-tabasa. ");
INSERT INTO tif_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kemin, siin sawaayak kawu, God ali numi awil-fakal imi bokoya-lomda: Nali ti dong dakaayokomi no, kalba-kup ale, asuk Abraham asole, ami man loop iso, imi bokoya-lomda: Nali alik ibi suunkup kaptoop kaptoop unip uyo dong dakaayokomi kayi! kalalaya ami weng kutiisa uyo lokonsu dinim; kano aket fukun-bamdala, almi miining Israel nuyo, olen-daaya-lomda, suunkup dong dakaayila-tabasa no, kala-lom Maria uyo baal wiimu ko. ");
INSERT INTO tif_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kanola Maria uyo Elisabet uso, awaat kawu bomdula bombii kayoop asuumano iyo dakan-tiiluya asuk ulmi abip unsu ko. ");
INSERT INTO tif_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bombii luuka le, kulaa Elisabet uyo man ayo fuk-duulale, ilana man tunum kuulula, ");
INSERT INTO tif_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","kulaali Elisabet ulmi abip kasel so, aptum kusal so, yakal weng saniwa, Dukum alta olenin sakbaalim dukum uyo akam imi kuya-lomda, man tunum man kala kuuya kala, kala-lomdip uso maakup fiyaap dukum uyo duumipla kemin, ");
INSERT INTO tif_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","man unaak kaa kuulula, bombii am oklungkal kelale, awil-fakal iyo tal man unaak ami ipnaal kaayo, bo-wakan-tela-somla yo, kalalipla, nikil iyo tal-ilomdip nulmi kukup kanun-umbip kaata-kup kuluuluwa, almi aalap win Sekaraya kaata bokolum o, kemiple, ");
INSERT INTO tif_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","awak uyo boko-lomdu: Daa yo! Man almi win kaa Jon o kala akolup te! kala kanum bokoyula, ");
INSERT INTO tif_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","kulaali awil-fakal iyo bokolip: Kanum bokolap. Katale, akam kipni lo kaa kanolin win kaali, ma bom-bilip disa yo, kalbip-kup, ");
INSERT INTO tif_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","iyo utamiwa yi, Aalap kaa weng bakamama disa kala, kalalipla, ilmi sikil kaata-kup kukaan-bamdip Sekaraya ami dik-daalip: Kapyo, kapni man unaak ami win kaa, kantanep yaap o akokomup i? akiple, ");
INSERT INTO tif_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraya asiik sikil iksi-bam kukuya-lomda: Dolmin kaami mafek mafek ma kup-nip dolnon o, yaka, kolipla, Man ami win ayo Jon o kala dolnale, awil-fakal iyo fananbile, aket fukunip ko. ");
INSERT INTO tif_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kulu maak-fak-daalin tap Sekaraya ami bon tem ayo baa-som ale, ami falang ayo bam-daala kelula, kulaali God ami win kaali, kufu-bamda fiyaap duumin dukum uyo don-bam kema. ");
INSERT INTO tif_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","Kemin, almi abip kasel iso, awil-fakal iso, iyo fanan-bam weng iin una-tala-ke yak abip ma ma kelula, Provins Judiya kaami amdu tem kasel iyo alik weng san-ilomdip utamipla, Man ayo fusun tam-tam una-balale, God ami titil kaali, aso bombe kala, kalaliwa, aket dukum kaali, fukun-bam bokolip: Ilomda man kaami tiltam fasuulokoma kaali, dok kanolin tunum tap ma ke-lokoma yaki? kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","God almi Sinik Tambal ata Jon ami aalap Sekaraya ayo tal dongna kela tiin mo bom-balaya, Sekaraya akal God ami weng kaali, bakayin-bamda ila ko. ");
INSERT INTO tif_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kalo, Israel-miin nulmi God Dukum ami win kufon-bam, kanumin sok aa, kaa akal talda almi unang tunum nuyo dong dokoyimba-kup ale, sok kaali, til-daa-yimba kelaya, ti yaap-kup tiinsup ko. ");
INSERT INTO tif_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God alalta sawaalak almi okok kemin man Devit ami man loop ma ata uldaa-dabuulala, kaata dabaali unokoma no, kalsa. Kemin, kaa almi titil dukum kaata, kano-lomda tildaa yim-baalala, nuli kaal dinim ke-lokomup o. ");
INSERT INTO tif_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sawaalak kawu, God ayo tunum malo ma iyo ulelnala, almi tiipmin weng o kala profet tituun-kup tabin iyo weng ku-fatap-dakamin tunum kalawiita, almi weng kaali, kutiiya unang tunum imi bokoya-lomdip: ");
INSERT INTO tif_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kipyo, God ali numi yam-kasenu-lomda: I, kipni waasi so, tunum kanta ipni tit-kup bom ilin iso, ita taba ibi yam-mafak-dakamum o, ke-mokomip. Kata, nalta kanolin tunum, imi sikil diim bom-bilip, ibi yam-kan-tii im-buu im-taldang daali, nalami unang tunum alik-daap ke-lokomip te! kala God ayo yam-kasenusa no, kala God ami weng tem bakayin tunum iyo unang tunum imi bakayinsip ko. ");
INSERT INTO tif_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","God ayo numi awil-fakal imi bokoya-lomda: Kipni olen-daayila-somdila, nalmi weng, atin ti tambal-kup tibin kuka-daayili, kaami aket kaata kutal-fukulokomi no, kalsa. ");
INSERT INTO tif_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ultap kemin, God ali numi awaalik Abraham sole, almi man loop nuso, numi dukum-kup weng kutii bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ibi nami lak uyo duule, suunin disa kemin o, kalalila, nalta kipni waasi imi sikil diim bom-bilip, ibi yim-bu-lomdila im-taldang nalmi miit tem kulu daalokomi. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tawaal diim kala-bomdip suunkup ilip kaa, Nali ibi atin ti tambal-kup bom ale, nami tiin diim kuluwu tituun-kup tibin kukup kaata-kup kutal-fuku kulii-una-biliwa yo, kalalila, ulela im-taldang daalokomi no, kala God ayo Abraham so, almi man loop nuso, numi bakayinsa no, kala Sekaraya ayo kanum bokoya-lomda, ");
INSERT INTO tif_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","almi man unaak Jon ayo bokola ko: Man unak kapyo, bom-bi-lom kaali, Abiil Tikiin God ayo bokop-ta-lomda: Kabi ti nalmi weng bon tem weng bakamin tunum o, kalokomi. Kemin ale, kapta kapsiik dusiin daa un-bomdap Kamokim almi liip uyo, talalu ku-mikil dakala una-balapla, talokoma no. ");
INSERT INTO tif_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kapta, tunum unang iyo afet daa im-tii bokoya-lomdap: God akal kipni uluum uyo takan-tiiya-lomda, talalu-yimulokoma no, kal-bom bakayilapla, kaal ke-lokomip. ");
INSERT INTO tif_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Kemin, God ami aket aa, fanang uyo, alik numi kuyale, aa olen-daayila ke-somdala utama yi, Numi aket fukunin kaali, malang tinilule, nuli saaka-yaamin kaami atul kaata, suun-bam ken-umbup kala, kalalaya alta tunum ma tam abiil tikiin kawu aso maakup ilin kaata, uldaa-dabuula talokoma. Kemin, kaami talokoma kaali, kutim atan tiltam taba-lomdu tak-daalu una-talaba kebu ultap ke numi aket fukunin kaali, bam-daa imuba-kup; malang tinibu uyo iilfoya, alta balili-kup kala dik-diiba bom ilin kaami kukup tambal kaata-kup kukuyin-balala kanu-mokomup o, kal-bomda Sekaraya ayo tiipmin weng tap kela bakayin-bamda baal uyo wiima ko. ");
INSERT INTO tif_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kemin, man ayo bom-bii-lom fasun-um-bom ale, almi angtiil so, sinik so, iyo titil kuluu-lom, kulaali bilin unang tunum dinim bokon kawu bom-bala, bom bii almi okok kemin am uyo daan tiltam tulu kala, kalale, kulaata tal fatawa-lomda Israel-miin iyo kukuyin-bisa ko. ");
INSERT INTO tif_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kemin, Jon ami kuusu diim kuyaku, King Ogastas ayo lo ma kutii, almi kiyap imi bokoya ko: Ibi din-ilomdip unang tunum alik nata tiin mosi imi win kaali, dolmin o! yakala, ");
INSERT INTO tif_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","kulaali kamosinim win dol-yila-silip kabak-ata kemin ale, Kwirinius ali Provins Siria kaptam-ami kiyap ke-bom balaya, imi win uyo dol-bisip. ");
INSERT INTO tif_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kemin, unang tunum alik iyo, Din bokolupla, numi win uyo dol-yilak o, kalalipla, kelalip ilmi atin abip unemip. ");
INSERT INTO tif_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kemin, Josep ali King Devit ami man loop kemin ale, Provins Galili abip ma kaali, Nasaret kawu laaba kaa kambolala, yak aba bital almi abip miit o kala ami awaalik Devit ami abip kaba tala kemin, abip kaa tala kaptam-ali Betleam o ken-umbip kaa, Provins Judiya kaptamu bombuu. ");
INSERT INTO tif_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kemin, Josep sole, Maria weng bak-daalip bombu la, uli man kum kemin uso, alep iyo, Din bokolupla numi win ayo dol-yilak o kalale, alep unip. ");
INSERT INTO tif_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","akam iyo yak aba bilin Betleam kaptam bom iliwa, Maria uyo kulaata man namti fuk-duula kala kalu. Lale, ");
INSERT INTO tif_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","unang tunum fatal kalo talemin imi tal sin una-tala-kemin am uyo utamiwa yi, Unang tunum yaapkan iyo tal-ilom, am uyo alik muup-daabip kala, kalalip, akam iyo bulumaki imi am kutamu ilomdip, Maria uyo Man tunum Man diil ayo kuulule, kulaa ilim falala dibii daak bulumaki imi ima inin kabas tem kabaaku dabaak tiilu ko. ");
INSERT INTO tif_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kutamiip kuyaku, abip umi saaklo mepso tikiinal kulu sipsip tiin molin tunum iyo kulu bomdipla, ilmi sipsip tiin bom iliple, ");
INSERT INTO tif_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","God Dukum ami ensel ma kasentap talala, Dukum ami yokon dukum ma imi diim kawu falala-kup kalula utam-ilomdip, walwaal-kup tap-tap-ke-bam suunipla, ");
INSERT INTO tif_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ensel ayo tal bokoya-lomda: Kipyo, fanan-bam suunalip kemin, nali God ami kalaan weng tambal kaata, kuliili talabi kemin, uta kanoyula unang tunum alik iyo fiyaap duu-mokomip o. ");
INSERT INTO tif_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kanola am daanbu kulu din Devit ami abip kawu unang ma Man kuulu kemin, Man kaali kipni Talalu-yimu-laamin tunum ale, God ami uldaa-dabuusa tunum Kraist kaali, Kamokim o. ");
INSERT INTO tif_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kamala-kup kulu ibi din-ilomdip, Man kaa fen yak aba din ata-mokomip kaali, awak uyo ilim ta falala-lomdu dabaak bulumaki imi ima inin kabas tem kabaak tiilu bombe kala, kalalip atamip namti, Awu, Man namti kulube no! kalokomip o, kal-bomda, ");
INSERT INTO tif_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","bakam-salale, maak fak-daalin tap abiil tikiin kayaak ensel atin yaapkan iyo tal atamipla nikil iyo, God ami win uyo kufu-bamdip bokolip ko: ");
INSERT INTO tif_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kaali tunum unang ili tam abiil tikiin kayaak God ami tong kaata-kup baka-mokomip. Kemin, God ayo dok kanolin unang tunum ma tawaal diim kalawu bom-bilip imi aket falit ayo kuyon o, kalokoma kaali, kuyilala, kiimi aket tem kaali, bilili-kup keyulula, ilokomip o, kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ensel iyo kanum bokoyilalip kamboyila asuk abiil tikiin uniple, sipsip tiin saanin tunum iyo bokola una-tala-kemsile, bokolip: Kalo, uniwa nikil dindup Betleam kawu, mafek mafek akal alik ma tiltam tabula, Dukum ata numi kukuyila kaayo, nikil din-ilom atamum aa! kalale, ");
INSERT INTO tif_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","kulaali nikil abiltap fen yakyak aba bilin ulip, Awak Maria sole, Josep so, akam iyo bomdipla, bulumaki imi ima inin kabas tem kabaaku Man ayo akanba kala kalalipla, ");
INSERT INTO tif_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","kulaa nikil iyo ensel tal Man kaami sang bokoya unba kaa tal unang tunum imi bakayila-tal-une-bilipla, ");
INSERT INTO tif_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","alik iyo weng san-ilomdip kanumip kaa, sipsip tiin molin tunum tal bokoyip kaata aket yaapkan fuku-dakamip. Katale, ");
INSERT INTO tif_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria uli weng alik kiili, kuyak aket tem daa, aket fukun-bam ilu ko. ");
INSERT INTO tif_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsip tiin molin tunum iyo asuk kela yakyak un-bomdip, God ami win kaata-kup dap-fiil tii-bamdiwa, ilmi utabip so, weng sanbip so, kaami aket uyo fukuniwa yi, Ensel imi weng bokoyinbip kabak-ali ti fan tituun weng tiltam tababu kala kalalipla, God ami mafek mafek akal alik ma kukuyila itamip kaami fiyaap kaata duumip ko. ");
INSERT INTO tif_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Am oklungkal kelala, Man unaak imi ipnaal bomin kaami am kaali, daan tiltam tulule, kulu Man ami win ayo Yesus o aka, awil-fakal iyo bokolip kemin, win kaali, siin kawu, awak man kum kelin disa bom ilula, ensel ami tildaak win kaa bokowase kaata-kup bokolip ko. ");
INSERT INTO tif_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Awil-fakal yakal atamipla, Kayoop maakup kelu awak umi iintang am disa kelu man im-taltam dakamin diim o, kala Moses ami Lo kutiisa uyo daanu no kalalipla, man ayo dip-tamalip bilin Jerusalam kaptamu Dukum ami kolum o kalalip iyo dibiilip unip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dukum ami weng kuka-daala Moses ata Sukon Tem dola kutiisa uyo boko-lomdu: Tunum man diil kuulip kiili, Dukum ami kukaalin o, kala-som ale, ");
INSERT INTO tif_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","kanolin am uyo daanon o kalule, awon abim alep tap aye, awon abim atin aket iip kama awon alep imtal-fuku imbii tal Dukum ami kukaalin o! kalsu. Kemin ti, kanum unip. ");
INSERT INTO tif_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kalsu kemin, kulaata abip Jerusalam kayaak ma ami win kaali, Simeon ali tunum tambal-kup tabasa le, ali God ami lak-kup duu-bomda God ami kukup-kup fuku-bom ilin tunum kemin, ali bom-laaba, God ayo Israel imi uluum uyo kukan-tiiya kala, kalon o kal-bomda fen-laaba, God ami Sinik Tambal ayo aso bomda laaba kemin, ");
INSERT INTO tif_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","bokola-lomda: Faneng, kabi saaknin disa ilomdapla Dukum ami weng kutiisa kaa, nami uldaa-dabuusi tunum ayo dabaayi din unokoma no, kalsa ayo talala, atamdapla taanokomap o, ansa. ");
INSERT INTO tif_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kemin, Simeon ayo God ami Sinik ata dap-titil-diilala, din lotu am awak diilim kaptamu bom-balala, Yesus ami awil-fakal iyo Man kaa dibiilip tam lotu am kawu lo kuka-daasa uyo kutal-fuku-somdupla, Man ayo Dukum ami kolum o, kala, ");
INSERT INTO tif_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","dibii tam daaliple, Simeon ayo Man kaa dabuu dap-mikile, God ayo yaap ke yo, anba-kup bokola ko: ");
INSERT INTO tif_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Kulaali, Dukum almi weng kutiisap namti kula tiltam tulu utami no. Kemin, nali ti kaltapni bon tem-kup daa-yilin nayo, fiyaap duuli kemin, kulaata kam-bop-nap taanon o kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Numi iliim boyokoma tunum kalawaali, fatapna nalmi tiin tituun atami kemin, ");
INSERT INTO tif_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kuluwaata unang tunum alik iyo atamin o kalalala, uldaa-dabuu dabaala talba te! ");
INSERT INTO tif_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kalawaali yokon dawang alaltap o. Israel-miin imi aket fukunin kaata-kup daa; unang tunum kusnum imi aket fukunin kakal ti iilfo ifiyimulala, kapni tituun-kup tabin weng kaali, uta-mokomip ale, ali kaltapni tunum unang Israel-miin iso, imi yim-tama taldang kapni miit tem tiilala ilokomip kayi! kala Simeon ayo kanum bakama ko. ");
INSERT INTO tif_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon ayo Yesus ami sang kaali, God ami kanum bakaan-balala, awak-aalap iyo aket yaapkan fukuniple, ");
INSERT INTO tif_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","kulaali Simeon ayo God ami dik daala-lom bokola ko: Alimal kiili tambal-kup dong dakaayin-balawa yo, kala-som ale aa, Yesus ami awak Maria umi bokowa ko: Kupyo, weng selan, God ali Man kalawaali uldaa-dabuulaya tiltam fatapnala kawu Israel unang tunum yaapkan iyo ami weng kuluuli, weng san-kaamin dinim ke-bamdip God ami liip uyo kela yang bane-bam, ali ilmi uluum tem diin-yaa-bam ale, Israel unang tunum kusnum yaapkan ita ami weng kuuli, weng san kaa-bam ke-bilipla, alta talalu-yimu-lomdaya, yim-bitam almi abip unokoma. Kemin, God alta dabaala tal-ilomda kukuyilala, utamiwa yi, Ali kanolin tunum o, kalokomip. Katale, unang tunum yaapkan ili baka-bamdip: Daa yo! kanolin tunum kaa tambal disa yo, kalokomip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kaali kayak kayak kii utamiwa yi, Kamosinim kaali, ilmi aket kaa kuwaa-bisip la kamala kawu ku-fatap-daayu no, kalokomip. Kemin, ilom am ma daanula, kupni Man kaami kukup kaa kanolokomip kaali, yeng man tela yol tabebu alaltap ke, kupni aket tem uyo bikip-tu, uluum awak dukum kaali, tam-bak molokomu no, kala Simeon ayo Maria umi kanum bokowa ko. ");
INSERT INTO tif_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","God ami weng tem bakamin unang Ana umi aalap Fanuel ayo Asa ami miit kayaak tunum kemin, Ana uyo unang sii bom-ilom tunum din ke bom bii wasital fetkal dakan tiile, ");
INSERT INTO tif_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kulaa imakim ayo saaknale, kuno ulufin ilom wasital 77 ma duk-duu kaaso kaaso kuyaku-diyaku-ke, wasital almi-kup 84 kiita disa keliple, kulu sawalsu. Kanolu kata, Ana uli ti suunkup lotu am awem kaptamu, taap so, kutamiip so, uyo ti kawu kup bomdula God ami lak kaa ti yikik-duu-bam ale, beten uyo kanumin-kup kemu. Kemin, am malo ma imi diim uyo ima inin disa kela, ima fala lotu am diilim kaptamu beten kaata-kup ke-bam ilu ko. ");
INSERT INTO tif_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kemin, Simeon ayo Yesus ami sang kaali, awak-aalap imi bakayin-balaya, Ana ukol tal lotu am tal ulula, Man ayo bombe kala, kalbu-kup, kulaali atamu yi, Kulaata nu! kalale, God ami yaap ke yo, aku. Kemin, Jerusalam kasel alep tap maakup tap ili God ami fen-bilipla, alta taldala numi waasi imi sok kaali, baayila, nokol nulta-kup kelum o, kal-bomdipla, God ami fen-tabasip. Kemin, Ana uyo alik imi bokoyulu ko: Kipyo, Man kalawaali kipni fen-tabasip kuluwaata te! yuku ko. ");
INSERT INTO tif_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kemin, Josep so, kalel Maria so, alimal iyo Dukum ami weng kutiisa kaali, kayoop maakup kelu awak umi iintang am dinim kelula, Man imbii tiltam am talemin umi kukup kaali, alik nolip disa kelule, alimal iyo Jerusalam uyo kambola asuk nulmi abip unum o, kalalip, Provins Galili umi abip Nasaret kawu unip. ");
INSERT INTO tif_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Man ayo fasuu-lom titil kutoop tinilale, aket fukunin tambal ayo kuluu kaal kemin dukum kelaya, God ayo tiin mo aket balili-kalin ayo kola ko. ");
INSERT INTO tif_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wasital maakup maakup ami diim kaali, Yesus so, ami awak-aalap so, alimal yakal God ami iintang am o kala, Pasova ima inin am uyo daanon o kem-sulule, kulaali Jerusalam kawu din imbi tal-tal-ken-umbip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","kulaa Yesus ami wasital ayo talaba tam talangkal kelale, Pasova kaami am kaali daanule, kulaa asuk imi Pasova ami kukup uyo fukulum o, kalalip alimal iyo Jerusalam unip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","kulaa Pasova ami am ayo disa kelula, asuk alimal unum o, kalip. Katale, man Yesus ayo Jerusalam kaptamu ilala, maak lo kela unip kaali, ma kaal kebip disa; ");
INSERT INTO tif_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ili kaa aptum kusal so talaba no, kalalip, bom bii am tiinule, kulu ami kayaak so, almi aptum kusal imi diim kaali, fen-tal-unebi; ");
INSERT INTO tif_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","man Yesus ayo atamin disa kelup kala, kalaliwa, kulaali asuk alep iyo fen yakyak Jerusalam unip ko. ");
INSERT INTO tif_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kemin, kanola akam fen-tal-unebi bii am alep kele, am asuum diim kulu fen din uliwa, Kwin! man Yesus ayo tal lotu am awak dukum kaltamu bomda God ami Lo kukuyin tunum imi iipyak tem kabaaku bomdala, imi weng kaata, weng san-kaa-bam ale, ayo dik-dakaayin-bam ke-balaya, ");
INSERT INTO tif_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tunum alik aso bomdip, Yesus ami weng, weng san-kaabip iyo utamiwa yi, Ami aket fukunin sole, kukuyin tunum imi weng ayo akal weng an-anung daka-bam keba so, kaa disa akal kusnum u! kalaliwa, kwin! iyo atam-ilomdipla fanan taalbile, awak-aalap iyo fen-tal atam-ilomdip ");
INSERT INTO tif_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","yakal fanan taalbile, awak uyo bokolu ko: Nami man kabi dok kanolon o, kalalawa, kawak-aalap nuli kamboya-lomdapla, taldap kalawu tiinbap i? Kawak-aalap nuli fen-tal-une-bi-lom titamin disa kelup kala, kalalupla, aket mafak keyulula, aket uluum kuluu bomdupla, fen-talabup te! akule, ");
INSERT INTO tif_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","kulaa Yesus asiik awak-aalap imi bokoya-lomda: Kanimin o kalalipla nami fen-tal-unebip i? Nali utamiya, Nali Atok God ami lotu am diilim kaltamu bom ilon o, kalbi kaali, ibi ma kaal kebip ema? kala-lomda kanum ");
INSERT INTO tif_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","bokoya. Katale, awak-aalap ili ami weng kaa talalu bam-daalin disa kelip. ");
INSERT INTO tif_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kemin, Yesus ayo asuk awak-aalap so alimal yakyak abip Nasaret unip. Kemin, din bomdala, awak-aalap imi weng uyo, weng san-kaa-bam, bilili-kup kala bom-balale, awak ukol dok kanolin dok kanolin tal ami diim abebu kaali, aket fukun-bamdu, kuyak ulmi aket tem daka-bam ilu. ");
INSERT INTO tif_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus ali fasuu-lomda, ami aket fukunin kaali, bam-daa-lomda tambal kelule, kulaali unang tunum sole, God so, iyo, ami fiyaap kaata-kup duumip ko. ");
INSERT INTO tif_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiberius ali Rom kayaak imi king kebi bom bii wasital tiin milii foko (15) kelale, Pontius Pailat ata Provins Judiya kaptam-ami tiin mola kesip. Kemin, kulaali Herot akal Provins Galili kaami tiin molale, kuno Herot ami fik Filip ata, Provins Ituria so, Provins Trakonitis so, kiimi tiin mo kelale, Lisenias akal Provins Abilene kaami tiin mola aa, ");
INSERT INTO tif_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas so, almi imnon Kayafas so, amdim ita, Juda kayaak imi awem tunum imi kamok kamok kelip ke-bomdiwa tiin mo ilsip. Kemin, kulaa Sekaraya ami man Jon ayo tunum dinim bokon kawu bom-balaya, God ayo Jon kaa uldaa-dabuu bokola-lomda: Kabi nami weng kaali, kutama din unang tunum imi bakayan o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon ayo yak aba din abip abip alik iyo Ok Jodan balang mepso kawu bom-bilip kiita, ayo God ami weng uyo bakayim-bam bokoya-lomda: Kipni ban kemin kaali, kela-lomdip aket fal-siki-lom tildang oksam wokolipla, God ayo kipni ban kemin uyo takan-tiiya disa keluk o, kal-bomda bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kemin, kanu-bisa kaali, siin sawaayak kawu, God ami weng ku-fatap-daa bakayin tunum profet Aisaya ayo Sukon Tem uyo dola boko-lomda: Tunum ma ayo tunum dinim bokon kawu bomda weng dukum-kup bakayin-bamda: Dukum ami liip kaa ku-mikil daa dot-bam kem-silipla, ilanalala talak o. ");
INSERT INTO tif_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Biil alik tiinaasip kiili, tawaal ta kuluu abuula tiltam tulu kewale, muuk so, amdu so, alik kiili, balela-lom ifi duule aa, liip dikil-dakal-kesip kiiso, talalula tituun-kup keliple, tuum tem liip mafaksip kiiso, talalula tambalna kelik o. ");
INSERT INTO tif_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Unang tunum alik iyo God ami tunum uldaa-dabuula tal numi iliim bo-yimulokoma tunum ayo, tala atamin o kalba-kup ale, tunum kaali, weng dukum-kup bakayinba kayi! kala Aisaya ayo kanum bokosa ko. ");
INSERT INTO tif_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kemin, unang tunum yaapkan ili tal atamuple, ata oksam ukoyak o kala tal atamiple, Jon ayo bokoya ko: God ata kipni kukup mafak kaami kalan kaata, yam-mafak fuulokoma. Kemin, ibi kanta bokoyipla, ipkal aket fukun-daa-lomdipla, Din Jon atamupla, oksam ukuyokoma kaata, fan God ami aket atul kuyokoma uyo uktayokomu te! kalalip tale-bam ale, ibi inap imi tikiin kiin-bala, suun daa-lom ukadaa sak funbi unebip ulultap kelipla, nami fanang tale-bam kebip yoko? Katale, kaali, ibi uktayokomu disa yo. ");
INSERT INTO tif_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kukup tambal kaata ti kanu-bilipla, kabak-ali utamila, Kipni aket fal-siki-lomdip ipni kukup mafak kaa, kulaabip kala kalon o. Ibi nami weng kala bokoyokomi kaali, weng san iliwa: ibi, Nuli ti Abraham ami man loop kemin uktayokomu no, kala fiyaap duubip. Lale, God ata tuum kalawiili fal-sikila tiltam Abraham ami man loop ke-lomdipla, ipni abiin uyo kuluulamip kemin, ibi dotu utamdiwa! ");
INSERT INTO tif_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kemin, God ayo as miit tem kawu kaabaak ma kutii-lomda as ayo duulmon o keba. Kemin, as alik kiili dok kanolin kiita, as lap tambal ma abuulin disa kesu namti, ayo duula-lom as kuyak daala kiin-abam-nokomu. Kemin ultap o, ipkal kukup tambal kaali, kutal-fukulin dinim ke-lokomip kaali, God ata taba-lomda yam-kan-tiii-lom fokola yak kiin-abokomip o, kala Jon ayo unang tunum imi kanu-bam bakayilale, ");
INSERT INTO tif_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","kulaali isiik dik-daalip: Katale, nuli kalok kanu-mokomup i? akipla, ");
INSERT INTO tif_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon ayo bokola: Dok kanolin kapta siyot alep namti, ma kaata dilduu tunum ma disa kulu bombe ami kolan aa! Ale, dok kanolin kapta ima so namti, baan-im-bamdawa yo, kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kemin, takis kaamin tunum iyo, Tal atamupla, Jon ata oksam ukuyak o, kalalip, tal Jon ami dik-daalip ko: Kukuyin tunum kapyo, Nuli kanimin kaata no-somduwa i? akiwale, ");
INSERT INTO tif_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","asiik bokoyila: Ibi moni yaapkan kaa kaamin daale; gavman imi weng kuka-daa-lomdip: Moni kanolin kal o kalbip kiita-kup, kuluu-yaamin o! yakale, ");
INSERT INTO tif_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","aa soldiya yakal asuk Jon ami dik-daala-lom bokolip: Aa nuli yi? Kalok nuu-mokomup i? akiple, Jon asiik bokoya-lomda: Ibi tunum unang ili suunin weng kaali, bokoya-lomdip: Yelokomup o. Nuli yim-tama din weng talalmin tunum imi diim daa disa ibakamin weng kaata bokolupla de-yimulokomip o, kaliple, kipni atul kaata, itam suun-bamdiwa, imi moni kaali, kukaayila-yaabip. Kemin, kanumin ayo kela-somdiwa, iltipni okok kemin kaami kun kaata-kup kuluu-lomdip fiyaap duubip-kup, ale maso ma kaamin dinim o, yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kulaa, unang tunum iyo Jon ami kukup kanola kaata, utam-ilomdip aket dakat kalalipla, Jon ami aket yaapkan fukun-bam ale, Kaali Kraist kaa God ami tunum, uldaa-dabuula Kamokim kesa, dabaala talokoma no, kalsa ata nema yo? kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kanumiple, Jon ayo alik imi bokoya ko: Kipni tunum talokoma no kal-bom fenbip kaa, nita disa; ata kamokim diildiil kemin, ata ata kelaya, nali kabaak banin kemin, fatom kep-nala, nali ami yaan-alom sok kaali, baalami disa. Nali disa ok kulaata-kup oksam ukayimbi. Katale, tunum kaa talokoma kaami almi Sinik Tambal ata dabaala taba-lomda kipni iipyak tem aket mafak fanang mafak-dakabip uyo, as kuyak daala kiin-abamnula, alik ibi tambal ke-lokomip o. ");
INSERT INTO tif_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tunum imi yeng kuluu-lomdip wiit kiita bobi kutal tii-lomdip dot-bilip bii, umi ipnaal ayo takan-tii-lomdip wiit tiil ata-kup, kuu am tiile, ipnaal kaata-kup abul-daalip kiin-tabemin o. Kemin, ultap o; tunum kaa talokoma kaa tunum unang ami lak duusip iyo afeta yim-tii foko kutam almi abip tiiba-kup, ale yak tunum unang ami lak duulin disa ita, atin ti as kiinin-kup ke-bam ten-yaamin disa; ti kano kiinin-kup ke-bam ilin kaami tem kabaaku abul-daala kiin-bam ilokomip o. ");
INSERT INTO tif_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon ayo kanum bakayinba kuyaku, God ami weng tambal uyo bakayim-bamda, unang tunum imi aket uyo kufuyim-balaya, imi aket aa fanang aa kiiyo fal-sikilin o, kala bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herot kaali, Provins Galili bokon kaptam-ami king kamokim dukum kemin, almi fik ayo taanin disa bom-salale, ayo fik kalel Herodias uyo tak-daa kuluuba-kup, kukup mafak mafak yaapkan malo iyo kuyaku kanu-bam ke-balala kemin, Jon ayo Herot ami kukup mafak uyo kanuma kala, kala-somdala, ku-fatap-daawalala kawu, Herot ayo aket atul dap-telula kulaali, ");
INSERT INTO tif_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","asuk kukup mafak yaapkan iyo kanu-bam ale, almi okok kemin tunum imi bokoyilala, tal-ilomdip Jon ayo sok de dibii-din kalabus am daalip bom-biisa no. ");
INSERT INTO tif_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon ali kama sok de duulin disa, bom ilipla, unang tunum yaapkan iyo alik tal Jon ami diim tiliple, Jon ata oksam ukayin-bamda bom-balala, Yesus akal mafiing kawu tal Jon ami bokola-lomda: Oksam ukop-nan o! akale, Jon ayo fan Yesus ayo oksam ukolala, Yesus ayo beten kem-salale kulu, abiil tikiin namti saal busuulule, ");
INSERT INTO tif_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","God ami Sinik Tambal ayo awon abim tilin tap ke, tal Yesus ami diim aba kem-salale, kulaa abiil iip-iip kawu weng ma bokola ko: Kabi ti nalmi Man ale, nali suunkup kapni mok-kup inap-tin-bam, kapni fiyaap-kup duup-ta-laabi kayi! kala ko. ");
INSERT INTO tif_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus ayo bombii wasital 30 kiita duk-duulale kulu, almi okok kemin kaali, ilu-lomda okok kemsa. Kemin, unang tunum alik iyo Yesus kaa Josep almi man o, ken-umbip. Lale, kaa God almi man tituun kemin, Josep ali Heli ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ayo Matat ami man, aa Matat kaa Livai ami man, Livai ayo Melki ami man, Melki ayo Janai ami man, Janai ayo kaa awasekim Josep ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ayo Matatias ami man, Matatias ayo Amos ami man, Amos ayo Naham ami man, Naham ayo Esli ami man, Esli ayo Nagai ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ayo Mat ami man, Mat ayo awasekim Matatias ami man, Matatias ayo Semen ami man, Semen ayo Josek ami man, Josek ayo Joda ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ayo Joanan ami man, Joanan ayo Resa ami man, Resa ayo Serubabel ami man, Serubabel ayo Sealtiel ami man, Sealtiel ayo Neri ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri kaa awasekim Melki ami man, Melki kaa Adi ami man, Adi kaa Kosam ami man, Kosam kaa Elmadam ami man, Elmadam kaa El ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El kaa Josua ami man, Josua kaa Eliesa ami man, Eliesa kaa Jorim ami man, Jorim kaa awasekim Matat ami man, Matat kaa awasekim Livai ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai kaa awasekim Simeon ami man, Simeon kaa awasekim Juda ami man, Juda kaa awasekim Josep ami man, Josep kaa Jonam ami man, Jonam kaa Eliakim ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim kaa Melea ami man, Melea kaa Mena ami man, Mena kaa Matata ami man, Matata kaa Natan ami man, Natan kaa Devit ami man. ");
INSERT INTO tif_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit kaa Jesi ami man, Jesi kaa Obet ami man, Obet kaa Boas ami man, Boas kaa Salmon ami man, Salmon kaa Nason ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason kaa Aminadap ami man, Aminadap kaa Atmin ami man, Atmin kaa Ani ami man, Ani kaa Hesron ami man, Hesron kaa Peres ami man, Peres kaa awasekim Juda ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda kaa Jekop ami man, Jekop kaa Aisak ami man, Aisak kaa Abraham ami man, Abraham kaa Tera ami man, Tera kaa Naho ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho kaa Seruk ami man, Seruk kaa Reu ami man, Reu kaa Pelek ami man, Pelek kaa Ebe ami man, Ebe kaa Sela ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela kaa Kainan ami man, Kainan kaa Apaksat ami man, Apaksat kaa Siem ami man, Siem kaa Noa ami man, Noa kaa Lamek ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek kaa Metusela ami man, Metusela kaa Enok ami man, Enok kaa Jaret ami man, Jaret kaa Mahalalel ami man, Mahalalel kaa awasekim Kainan ami man, ");
INSERT INTO tif_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan kaa Enos ami man, Enos kaa Set ami man, Set kaa Adam ami man, Adam kulaatale, God ami man. Tunum miit namti kano-lom tunum miit ukusa ko. ");
INSERT INTO tif_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","God ami Sinik Tambal ayo Yesus ami diim kawu dongna kelala, Yesus ayo Ok Jodan Dal kela una-balaya, Sinik ayo dibii bidin tunum dinim bokon kabanala ");
INSERT INTO tif_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus ayo tunum dinim bokon kawu bom-balaya, Tunum Mafak Setaan o kala-laabip ayo tal Yesus ami dap-kukuliya, yak kukup mafak kaali ma kanola kala kalon i, kala-lomda, dap-kukubi yakyak kema ko. Am sin-laamin almi-kup 40 iyo yak baniple, Yesus ayo ima uyo ma inam-noma disa kelale, am kunolin tal unula ima tinap uyo tabelule, ");
INSERT INTO tif_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Setaan ayo Yesus ami bokola-lomda: Kabi ti God almi Man tituun namti, kabi daak tuum kulaali kuluu fal-sikilapla, bret keluya, inamnap titamila, Awu, kabi fan God almi Man tituun kala tokon o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus asiik maan tela ko: Daa. God ami Sukon Tem weng kabak-ali boko-lomdu: Ima kulaami inam-nokomap kulaali, tiil umi kup ifamin ale, kaali kapni aket fukunin kabak dong dokop-tokomu disa yo, kala-lomdula kanum bokosu kemin, kaa kano-lomdila ima bret kaa inam-nokomi dinim o, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kanolale, kulaa Setaan ayo Yesus ami dap-tamala tii umbitam iip ma kawu daale, kulaali abiltap-siik tawaal diim kaami tunum miit ma tunum miit ma iyo alik kukolale bokola ko: ");
INSERT INTO tif_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","God ali bokop-na-lomda: Am bokon alik kala dik-daa kulaasu sole, tunum miit akal alik ma akal alik ma bom-bilip iso, kii kapni no, nansa. Kemin, nata-kup kii tiin mobi kemin, nalta tunum ayo ma kuluwaata no, kali namti, kaata ulduu-lomdi kup-tila, kapta tiin molan aa! akokomi. Kemin, kanola nali tunum miit ma ma kii yim-baali yak kaltapni sikil diim abamnipla, kapta taba, kiili tiin molalap. ");
INSERT INTO tif_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kemin, kabi nalmi tiin diim kulawu bokop-na-lomdap: Kabi nami kamokim o, kalap namti, tunum miit ma tunum miit ma iyo alik kup-tile, kii ti kaltapni no, aka kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","kulaali Yesus asiik bokola ko: Daa te! God ami Sukon Tem uyo boko-lomdu: God maakup ata-kup kapni tunum Dukum kemin, kabi tilik duung fakela-lomdap, ami win kaata-kup kufon-bam ale, ami weng kaata-kup weng san-kaaman o kalsu te! aka ko. ");
INSERT INTO tif_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aka kanum bokolale, kulaali Setaan ayo Yesus dap-tamala tii umbitam Jerusalam kawu daale, dibii tam lotu am awak dukum win sokan kaami liip kutal-fuku umbitam asal am desip umi dibim diim kawu daale, bokola ko: Kabi tifan God ami Man namti, mafek mafek ma kaata taba-lomdu telokomu dinim; kemin, asal kalawu uunfoko umbalaak tawaal diim abamnan aa! akale, ");
INSERT INTO tif_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","God ami Sukon Tem uyo boko-lomdu: God ali almi ensel imi bokoyilala, iyo tal tiin-molipya kabi telokomu disa yo, kala-somale, ma kaata boko-lomdu: ");
INSERT INTO tif_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ensel ita tal tam-tal-fukulokomip. Kemin, tuum daang inang ayo ma ata taba-lomdu kapni yaan kaa, lop-tokomu disa yo, kala-lom kanum bokosu. Kanolin kemin, kabi weng san-ilomdap uunfoko daak abamnawa, unang tunum iyo titamiwa yi, Awu, fan kabi God almi Man o, tokolip o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","kulaali Yesus asiik bokola: Daa yo! God ami Sukon Tem kabak-ali boko-lomdu: Dukum kaali, kapni God kemin, kaa dap-kuku-bam boko-lomdap: God kabi ti nami weng bokop-ti kaata-kup, weng sandap kanolawa, kayak kayak iyo utamiwa yi, U, God kabi, nami aket kaata duu-bomdawa, dong dakaap-nambap kala tiki no, kemin daa yo, kalsu te! kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kulaa, kanumsi Setaan ayo Yesus ami dap-kukumin kaali, dap-kuku-balala, dinim kelale, Yesus ayo titil-fak-daala kala, kala-lomda, kela liip kusnum ma fena ko. ");
INSERT INTO tif_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus ayo asuk almi bokon Provins Galili unale, God ami Sinik ata aso bomdala, dong dakaan-balala, Yesus ayo titil-foko okok ke-balaya, kayak kayak iyo Yesus ami tong kaata, kulii yak Provins Galili bokon kaami abip ma ma kawu, bakayila-tal-une-bilip, dukum-nule, ");
INSERT INTO tif_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","kanola Yesus ayo God ami weng kaayo, kulii yak Provins Galili kaami lotu am, am-ma am-ma uyo kukuyin-balaya, alik ami weng uyo weng san-kaa-bam ale, ami win ayo kufu-bam kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus ami abip diilim kaali, Nasaret kaptamu kemin, kawu almi awil-fakal iso bomdaya, fasuuse. Kemin, yakyak din almi abip unale, God ami iintang am daanule, alami kukup kanun-umba kaata-kup, fukula lotu am unen-umba. Kulaa, lotu tiin molin tunum ayo Yesus bokolale, tam tola-lomda, unang tunum imi tiin diim kawu God ami Sukon Tem uyo tik-tiimon o, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","God ami Sukon anung ma uyo God ami weng tem bakayin tunum Aisaya ata dolsa kuuli, lotu tiin molin tunum ayo Yesus ami kolala, sukon uyo baa-lomda, anung ma uyo utaba-kup, tik-tii-bam bakan-tabamna: ");
INSERT INTO tif_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","God ami Sukon Tem weng uyo boko-lomdu: God Dukum alta uldaa-nam-buulala, ami okok kemin uyo, kutama taba-bilila yo, kalalaya, nam-baala talsii. Kemin, Dukum almi Sinik ayo dabaala tal nami diim aba-lomda dong dakaap-nam-balaya, okok kaa kebi te! Kemin, God ami bokop-na-lomda: Kanolin ok kalaata kanuman o, kalase namti kalabuu. Nalta God ami weng tambal uyo mokop soyal kiimi bakayon o kala-somdila ko. Nalta unang tunum sok de-yimusip imi bokoya-lomdi: Sok til-daa-yim-baalip uluum dinim tabanin o, yokon o kala-somdila kemin, nalta tunum unang tiin fiim ken-unsip kiimi bokoyi, Tiin baalin o, kalon o. Nalta waasi dinin tunum ita ita kesip kiimi yam-kan-tiile, tunum kabaak bansip kiita, til-daa-yim-baali uluum dinim kelik o. ");
INSERT INTO tif_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nalta unang tunum imi bokoya-lomdi: Kulaata God Dukum ami am uyo daan tulu kemin, almi tunum unang iyo yam-talal-kaa-mokoma no, yokon o, kala God ami Sukon Tem kabak-ami weng kaldak kanum bokosu no, kala Yesus ayo tik-tii-bamda bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kemin, Yesus ayo sukon kabak-ali tik-tiila disa kelule, asuk sukon uyo falala de-lomda, lotu tiin molin tunum ami kola tiinba-kup, unang tunum imi kukuyon o, kalalaya, ilmi tiin diim kulu tiinale, unang tunum alik lotu am kutam bom-bilip iyo, Yesus ami tiin dik-yak-dela atafiimiple, ami weng bakayokoma kaata ti weng san-kaamum o, kalip ko. ");
INSERT INTO tif_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kulaa, ayo alik imi bokoya-lomda: Kamala kulaa God ami weng kaa tik-tii-bili weng senip kaa, weng kalawaali, God ali nalmi sang kaata bokolaya, God ami weng tem bakayin tunum Aisaya ata dolsa. Kemin, uli kulaa tiltam tabamnu no kalale, ");
INSERT INTO tif_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","kulaa, iyo weng sanipla, weng tambal kuu tiltam tabebu kala, kalale, iyo aket fanang alik tam baneyule, ami win kaali, kufon-bam bokolip: Kipyo, kaali kawanami man daa; ali Josep ami man. Yale, kaa kanolin weng tambal kuu dok kanolin liip kabangu tildang tulu kuluu-somda, bakayinba ni? kem una-tala-kemiple, ");
INSERT INTO tif_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","kulaa, Yesus asiik bokoyila ko: Ibi weng saniwa, Yesus ali unang tunum mafak umkan-unsip ili toop abip Kapeneam kaptamu talalu-yimuba no nikip o kalbip. Kemin ale, kamala-kup kulawu ipkal sawaayak awil-fakal imi faldak-tiimin weng ma boko-lomdip: Dokta kapyo, yak kaltapni mafak-alin kaa, talalulan o! kalalip baka-bisip kaa, asuk bokop-niple, Kapni toop Kapeneam okok kemin tambal kanobap kaali, asuk kaltapni abip Nasaret kaltamu kanolan o, nokokomip kala, kalbi te! ");
INSERT INTO tif_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Lale, nali weng tituun weng kaata-kup bokoyokomi kaali, God ami weng tem bakayin tunum ili almi abip kasel imi bakayokoma kaa, yakal boko-lomdip: Ee, kabi disa; ti nultap te! kalbip-kup ale, iyo weng sanokomip disa yo. ");
INSERT INTO tif_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Weng tituun weng uyo ma so bokoyokomi kemin, weng san bom ilipla, siin sawaayak kawu, God ami weng ku-fatap-dakamin tunum Elaija ami bom ilsa kaami diim kawu, wom manim dinim bom bii wasital asuumano le, kayoop bukupkal kiita disa kelipla, abip ma ma kaptam iyo ol fut am uyo tiltam tabamnula, unang kaluun yaapkan iyo am bokon Israel umi abip kaptam ilip. Lale, ");
INSERT INTO tif_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Elaija kaa Israel tunum la, God ayo Elaija ayo ma dabaala talda Israel unang kaluun yaapkan imi dong dokoyinsa disa; dabaala tal bokon kusnum ma Saidon umi abip Sarefat kaptam-ami unang maakup uta-kup dong dokowunsa ko. ");
INSERT INTO tif_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kuno ilom kawu, God ami weng ku-fatap-daa bakayin tunum ma ali Elaisa ami bom ilsa diim kulu, tunum angtiil dibim mafak-umulin yaapkan iyo am bokon Israel umi abip kaptamu ilip. Katale, Elaisa ali tunum kiili ma dong dakaayin-bisa disa te! Am bokon kusnum Siria kayaak tunum Naman ata-kup dong dokonsa no, kala Yesus ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tunum alik lotu am kutam tiinbip iyo Yesus ami weng kaata weng san-ilomdip utamipla, Yesus ayo kanola numi sang kaata bakayimba kayi! Kala kala-lomdip iyo aket atul tabeyulule, an-tokonbi kela, ");
INSERT INTO tif_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","tam tola yak dap-tal-fuku sisii dilili dibii tam daak abip aba-lomdip abip kela sisii dilili dibii-unip. Kemin, ilmi abip kaali, amdu umi tawoop tem kawu ilin kemin, dilili dibii tam amdu ami dabom diim aba-lom, dabuu dabaalup koot unak o kemip. Katale, ");
INSERT INTO tif_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yesus ayo ilmi bak-biik tem kulu-bala tabana ko. ");
INSERT INTO tif_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesus ayo abip Nasaret kaali, kelala, daak Provins Galili kaptam-ami abip ma kaa Kapeneam kaptam unale, God ami iintang am uyo daanuya, Yesus ayo lotu am tam-ilomda, God ami weng uyo unang tunum imi bakayin-bam kukuyin-balala, ");
INSERT INTO tif_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","iyo utamiwa yi, Yesus ami kukuyin kukup kaali, atin tifan ukol kusnum ma kala, kala-lomdipla, God ami aket fukunin kaata, dik-daa-kuluu-lomdala kemin, ali titil-kup taba-bom nuli kukuyinba no, kala-lomdipla, awal-bam una-tala-kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kemin, lotu am kaptam-ali tunum ma bombe kaali, sinik mafak ata dap-tal-fukusa kemin, dukum-kup naan-bamda ");
INSERT INTO tif_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","boko-lom: Wo, Nasaret kayaak Yesus, kapyo! Kabi nuli kanimin ma noyon o, kalalapla talap i? Nali titamila yi, Kabi God ami tunum uldaa-tam-buu-lom tam-baala tal-salap namti kaltapta kala tiinbi no, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kanumale, Yesus asiik sinik mafak ayo katen-bam bokola-lomda: Kabi duluma-lomdapla, tunum kaa kewalalap yak banan o, aka-laam-salale, kulaa sinik mafak ayo taba-lomda, tunum kaali, dabaala daak tunum tiinbip imi iipyak tem kabaaku abamna kata, dap-mafak-daalama dinim; kambola yak banala, ");
INSERT INTO tif_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","kanola atam-ilomdip, unang tunum alik iyo fanang alik tam banu fanan-bamdip weng bokola una-tala-ke-bam ale, bokolip: Kwin! kaa dok kanolin weng ma bokola ni? Tunum kala titil-kup tibin dukum kemin, sinik mafak imi dukum-kup bokoya-lomda: Yak banin o! yakala, yak banip te! kalip. ");
INSERT INTO tif_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kemin, Yesus ami kanola kaami sang kaali, yak Provins Galili kaami abip alik ma ma iyo yak aba tildak aba ke-lom atin dukumnu ko. ");
INSERT INTO tif_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus ayo tam tolale, lotu am uyo kambola Saimon ami am unale, Saimon ami imnon uyo angtiil mamin dukum ke-umba kala, kalbip-kup, kulaali Saimon alimal iyo dik-daala-lomdip: Kapta dong dokowan o! akipla, ");
INSERT INTO tif_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus ayo unang ulmi mepso kuluba-lomda dukum-kup angtiil mamin umfukuba ami bokolalala, angtiil mamin ayo disa kelale, maak fak-daalin tap uyo tam tiinbu-kup, kulaa yak ima ayo kuluu fuu kutii atin tambal ma ke-lomdu imi kuyu inip ko. ");
INSERT INTO tif_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Am tiin tiin tala-bulule, God ami iintang am uyo disa kelule, unang tunum imi aptum kusal kanolin kanolin mafak-alin umusip iyo, kulii-tal Yesus ami fanang tiliwa, Yesus ayo sikil kutam tunum unang alik mafak-alin kuluusip imi diim tii-lomda talalu-yimula, tambal-kup kemip. ");
INSERT INTO tif_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kemin, sinik mafak ita taba-lomdip unang tunum yaapkan de-yimusip. La, Yesus ayo sinik mafak iyo fotabam-nala, tiltamba tal-ilomdip bokolip ko: Kabi ti God ami Man kapta nu, kala-lomdip ola una-tala-kemiple, Yesus ayo itama yi, Sinik mafak yakal nitamiwa kaali, God ami uldaa-dabuusa tunum Kraist ata no, nikip kaa kala-somdaya, weng dukum-kup bokoya-lomda: Maso ma bakamin dinim o! kala kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kanubi silip sintam kutim malang tem Yesus ayo abip Kapeneam uyo kelalala, (God ami beten kamaalon o kalala,) bilin unang tunum dinim bokon kawu unale, unang tunum iyo fen yak aba din atam-ilomdip, ayo dal molum o kemipla, ");
INSERT INTO tif_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yesus ayo bokoya-lomda: Aatumen God ali boko-lomda: Kabi nami weng kaata, kutamalap din abip ma abip ma iyo bakayim-balawa, tildang nami miit tem talemin o kalala nam-baala talsii. Kemin, ami kalaan eng tambal kaata, kulii-din abip ma ma kawu bakaya-tal-une-mokomi no, kala-lomdaya, ");
INSERT INTO tif_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","keyilala din Juda bokon kaami abip ma ma kaami lotu am kawu God ami weng uyo bakayila-tal-unema ko. ");
INSERT INTO tif_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Am ma daanule, Yesus ayo Ok Kumun Genesaret ami balang diim kawu bom-balaya, unang tunum ili God ami weng kaata weng san-kaamum o, kalalip tal falala-dabak-moliple, ");
INSERT INTO tif_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus ayo utamala yi, Aniing abuumin tunum iyo bot alep sisii kutal-dang ok balang diim tiilip kela, yang aniing men uyo diingbip kala itamale, ");
INSERT INTO tif_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","bot kiili alep kemin, ma kuuli Saimon ami bot la, Yesus ayo Saimon ami bot tem tam tiin-ilom bokola-lomda: Bot uyo dibiiwap yakyak ok balang diim mepso unuk o, akale, kulaa Saimon ayo fan bot uyo dibiiwa yakyak wok balang mepso abule, ayo God weng kaata, unang tunum imi kukuyila ko. ");
INSERT INTO tif_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesus ami weng ayo bakayimbi dinimnule kulaali, Saimon ami bokola ko: Kapso, kap-tunum kusal iso, ibi bot kalawuuli dibiiwa kulaalip yak ok kumun iipyak tem unula, kipni aniing abuumin men kaayo, binalip daak ok tem unula aniing iyo ma abuulin o! yakale, ");
INSERT INTO tif_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","fan Saimon ayo bokola: Kamokim kapyo, kutamiip dukum kaayo nikil nuli aniing fenbi sulup. Lale, atin ti aniing katip so ma fokobup disa; kemin, kuno kelamup. Lale, yak kapni weng bokolap kunolin kemin, aniing abuumin men ayo binalup daak ok tem unokomu no, akale, kulaa ");
INSERT INTO tif_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","kulu nikil imi aniing abuumin men uyo binalip daak ok tem una bombii yak sisii kulaalip tiltam talak o, kaliwa yi, Uluum kaata, disa akal ma kelu kala kaliple, aniing kalaata disa yaapkan kelula, kaami uluum kaata, taba-lomdu aniing men ayo balata tabon o kalula kemin, ");
INSERT INTO tif_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","aptum kusal bot tem ma bom-bilip imi weng umuuyip tal dong dokoyipla yo, kala-lomdip, nikil imi sikil so tal tukuya kelipla, dong dakaayip nikil alik ke-lomdip, aniing abuumin men uyo kulii tiltam daa, aniing iyo bot tem kutiilip; bot alep iyo dongnipla, aniing imi uluum ta tabamnuya, bot alep kiiyo, kulii ok kumun tem unum o, kalipla, ");
INSERT INTO tif_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita akal utamala yi, Kaa kanolu kala, kala-somdala, tilik duung fakela daak Yesus almi miit tem kulaak abale bokola: Kamokim kapyo, nali ban kemin tunum; nami aket kaa fukunin daa; kemin kuno kambop-nan o, aka ko. ");
INSERT INTO tif_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Kanola Saimon nikil iyo tam bot ma umi tem tiiniple, kuno Saimon ami ap-tunum kusal malo ma yak bot ma kaami tem unip ke-lomdip, aptum kusal malo kiili, Sebedi ami man alap Jems so, Jon so, kanolin alik iyo aniing sikip aalap dukum kaali, atam-ilomdip walwaal dakamsile, kulaa Yesus ayo Saimon ami bokola ko: Suun-daa-laamin daa; siin sawaayak am kala daan talan-umbu kaali, aniing fakan-umbip. Kemin ale, am kala daana kaali, tunum kiita, faka-bam im-taldang nalmi miit tem tii-mokomap o, akaya, ");
INSERT INTO tif_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","nikil iyo bot sisii kuyak ok balang diim kuyak tii kela imi tawaal diim kaami mafek mafek aket fukunin uyo kela-somdipla, Yesus ami weng, weng san-somdipla, aso maakup unip ko. ");
INSERT INTO tif_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kulaa ilom am ma daanule, Yesus ayo abip ma kaptamu bomdala utama yi, Angtiil mafak-ansu tunum ma bombe kala, kala atama. Kemin, tunum kaa tal Yesus atam ale, tilik duung fakela daak almi mepso kulu tiinba-kup, ayo dukum-kup Yesus ami dik-daala-lom bokola: Kamokim kapyo, kabi ti yaap kemin, dong dokop-non o, kalap namti, nami angtiil kula mafaksu kuluwa dotu-namulan o, aka kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus almi sikil ayo kulii yak tunum kaami angtiil diim kawu kuyak tii bokola-lomda: Ayo, niyo dong dokop-ton o, kalaliya kemin, kulu talalu-tamuli yaap-nokomap o, aka kem-salale, tunum ami angtiil mafak uyo maak fak-daalin tap disa kelule, tunum ayo tambal kela, ");
INSERT INTO tif_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesus ayo dukum-kup bokola-lomda: Kabi din tunum imi diim kaali, nami dotu-tamuli kaami sang uyo bakayin daa kayi! Kabi din-ilomdap awem tunum pris ami diim kawu kapni angtiil uyo kukolap, ayo titamala, U fan kapni angtiil uyo tambal kebap o! tamba-kup, kulaali Moses ami weng kutiisa kaata, kutal-fuku-lomdap mafek mafek ma God ami kolale, yaap ke yo, kalapla, unang tunum alik iyo titamiwa yi, Faneng kaa tambalnap o! kala-lomdip asuk tam tildang daalin o, tikin o, aka. ");
INSERT INTO tif_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Katale, unang tunum iyo Yesus ami kanonba kaami sang kaali, weng san-ilomdip, weng kulii-una-tala-kelipla, tunum unang yaapkan iyo weng san-ilomdip, nokol din Yesus ami weng kaata, weng sanum o, ke-bamale, nulmi tunum unang mafak-alin kuluusip, iyo yim-tama din daalupla ata talalu-yimulak o, kal-bomdip talen-umbip. Katale, ");
INSERT INTO tif_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","am yaapkan kiili, Yesus ayo keya din tunum dinim bokon kawu din-bomda almi Aalap God ami beten kamala-umba no. ");
INSERT INTO tif_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Falosi so, lo utamsip tunum iso, iyo tal Yesus ami weng uyo weng selum o, kalalip tal Provins Galili so, Provins Judiya so, kaptam-ami abip ma ma iso, abip win finin Jerusalam so, kaali kulaa kela tal Yesus ami fanang tala-tala-keliwa, kulaali am ma daanule, Yesus ayo am kaptamu bomda unang tunum imi God ami weng ayo bakayin-balaya, Falosi sole, lo utamsip tunum malo ma iso, iyo tam tiindip weng sanip, God ami titil kaa Yesus ami diim kawu bom-buluya, unang tunum mafak-umusip iyo yam-talal kaa-balaya, ");
INSERT INTO tif_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","tunum malo ma ita tunum angtiil taan dikiksa ayo dabaalip abiin tem una dibii-tal abip ababip-kup, kulaa dibii tam am Yesus ami bombe almi miit tem mepso kuluu daalupla dap-talalulak o, kalalip kanumip. ");
INSERT INTO tif_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kata, iyo utamiwa yi, Kwin! am kaptam-ali muup-daabip kala, kalbip-kup iyo liip fen-tal-tal-kemip, liip dinim kelu kalbip-kup, kulaa nikil dibii tam am konal tii kela yak am kon ayo tak-duu kuyak-tii kelale, kulaali tunum angtiil dibim-alom taanin tap kesa ayo biin tem kabaaku kanola bom ilale, sok buku-lom akola dabaalip yakyak umbilaak unang tunum tiinaabip imi iipyak tem aba bilaak tii, Yesus almi be miit tem kulaak abale, ");
INSERT INTO tif_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","kulaa Yesus ayo itamala yi, Tunum nikil iyo atamipla, Yesus ali ti faneng nak-tunum kulaali, dap-talalulokoma kala, kal-bomdip kanubip kala, kalba-kup tunum angtiil alik dibim-ansa ami bokola-lomda: Nak-tunum kapyo, ban kemin kaali, alik takan-tiip-ti no, aka ko. ");
INSERT INTO tif_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kemin, kulaa lo utamsip tunum so, Falosi tunum iso, iyo aket fukun-bam kanumip ko: Kwin! tawaal diim tunum kii dok kano-somdipla tunum unang imi ban wakamin kaa takan-telama disa yo! Ti God maakup ata-kup te! Tunum kalawaali dok kanolin tunum ma kalaata taba-lomda God kaa weng mafak bakaan-bamda kanum bakaba ni? ke-bam kanum bakamiple, ");
INSERT INTO tif_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus asiik imi aket kanolin aket fukunbip uyo uteyinba-kup, bokoya ko: Ibi kanimin o kalalipla, kanolin aket kaa fukunbip i? ");
INSERT INTO tif_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nali kalok nolin mafek mafek kanu-biliya, ibi abiltap nitam-ilomdip Kaa faneng bakaba nu nokokomip i? Nali bokoya-lomdi: Kapni ban kaali, takan-tiip-tili kayi! kalokomi kaa, ibi utamin disa ke-somdipla kaali, ibakaba no, nokokomip. Kemin ale, aa bokoya-lomdi: Tam tola unan o, akokomi kaata, utamdipla, Kuuli faneng bakaba nu, nokokomip. ");
INSERT INTO tif_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ipkal utamin o. Nali Dukum Ami Man kemin, nali nalmi titil dukum uyo kukuyili ipyo utam-somdipla, Kaali ibakan-umba disa; kemin, tawaal diim kalawu bombe kaali, ali ti unang tunum imi ban kemin uyo takan-tiiyokoma no nokokomip o, ke-bam ale, tunum angtiil dikiiknin ami bokola-lomda: Kabi tolalap kaltapni abiin dalaa tim-bilip tilip uyo, kuluu kutamalap kalapni am unan o! aka-laam-salale, ");
INSERT INTO tif_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","kulaa, tunum ayo maak fak-daalin tap unang tunum tal tiinaabip imi tiin tem kulu tam tola daak almi akan-unen-umba abiin uyo kuluu kutamala tam abip abala almi am din-ilomda, God ami win kaata-kup kufu-bamda fiyaap duuma ko. ");
INSERT INTO tif_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kanolala atamdiwa kawu, unang tunum alik iyo fanang alik tam baneyulala bokolip ko: Siin sawaayak kaa, kanolin kukup kaa ma atamsup disa yo! Kamala kulu kalanolin kukup kalawaata, Yesus ata kukuyila utamup o, kal-bomdip God ami win kaata-kup kufuumip ko. ");
INSERT INTO tif_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesus ayo tunum angtiil dibim-alom taanin tap kesa ayo dap-talalula, yak aba din takis kaamin tunum imi am o kala, din takis kaamin tunum Livai ayo tiin bombe kala, kalale kulaa bokola ko: Nak-tunum a! kabi nami daang bakaalin tunum kelawa, naso nikil um-bomduwa, nami ok kaasiik ma kup-tiya, okok keman o! akale, ");
INSERT INTO tif_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yesus ayo Livai ami kanum bokola kem-salale, fan ayo tam tola bung alik kiiyo, keyimba-kup, yak Yesus ami daang bakaalala, alep unip ko. ");
INSERT INTO tif_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bombiile, Livai ayo Yesus ami fiyaap dukum-kup don-bamda ima fuu-bam, inum o! kalale, almi ok tabolin tunum imi bokoyilala, din ima fuu-bamdip, talal-bilipla, aptum kusal sole, takis kaamin tunum malo yaapkan iso, iyo tal Livai ami am tiliwa, tiin-aa-bomdip fiyaap duu-bam ima ina fakamipla, ");
INSERT INTO tif_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","kulaa Falosi kamok kamok so, kuno lo utamsip tunum ili yakal Falosi tunum kemin kiiso, iyo tal-ilomdip, Yesus ami daang bakaalin tunum imi itafii-bam ale, bokolip ko: Ibi kanimin o, kalaliwa, tal tunum mafak takis kaamin tunum isole, kukup mafak kutal-fukumin tunum iso, iyo tiin-bomdip ima so, ok so, kaa inaneng tababip i? kal-bomdip kanum bakamiple, ");
INSERT INTO tif_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus asiik bokoya-lomda: Weng ma faldak-tii bokoyokomi kemin, weng sanin! Dokta ali tal tunum mafak-umulin dinim, ili yam-talalulokoma disa; ali tal tunum mafak-umulin ita-kup, yam-talalulokoma no. ");
INSERT INTO tif_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kanolin kemin, nali taldila tunum iyo boko-lomdip: Nuli tituun-kup tabasup tunum kemin, aket fal-sikilokomup dinim o, kebip kiimi yam-talalulon o, kalalila, talsii disa; nali taldi tunum iyo boko-lomdip: Nuli ban kemin tunum kemin, aket fal-sikilum o, kalbip kiimi yam-talalulon o kalalila, talsi te! kala kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tunum iip maakup maakup ma iyo tal Yesus ami bokola-lomdip: Kapyo, Jon Baptis ami kalaan tunum ili beten kemum o, kalip namti, ima fala-bom, beten ke-biliple, kuno Falosi yakal ilmi daang bakaalin tunum yakal ti kanolin kukup ultap uta kanu-bilip ken-umbip te! Lale, kapni daang bakaalin tunum itale, kanolin kukup uta kutal-fuku kanumin dinim ke-bamdiwa, ima inin-kup ken-umbip kaali, dok kano-lomdipla kanun-umbip i? akipla, ");
INSERT INTO tif_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus ayo almi sang kaata, faldak-tii-lomda bokoya ko: Tunum ma ayo unang kuluulale, tunum ami kayaak iyo ima fuu-bam imbile, alik maakup fiyaap dukum duu-mokomip. Kemin, fan yaap keyilu ili aptum kusal kii kasen-fokoya-lomdip: Ibi ima kala inin disa yo, yokokomip ema? Daa te; tunum ami kayaak kiili, ima kaa falaalokomip disa; tikip alik maakup inam-nokomip te! ");
INSERT INTO tif_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lale, bombii kaptoowu, waasi ita tal imi aptum ayo dap-tal-fuku dibiilip kalokomip kaa, aptum kusal iyo aket uluum keyula inin ayo falaalokomip o, kala Yesus ayo faldak-tiimin weng kanum bakayin-bam ale, ");
INSERT INTO tif_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesus ayo Juda kii (itamala, Kii ilmi siin kukup kaata ti dukum-kup yikik-fukusip. Kemin, ami kama kukup uyo, kutal-fukulalup dinim o, kalbip kala, kalalaya,) faldak-tiimin weng alep ma boko-lomda: Yaap keyilula, unang uli ulmi saket alokso kaa anung ayo ma falduu dibii yak saket disapnin ami diim tii bikiilokomu nema? Daa te! Ulmi saket alokso kaata-kup, falduu kanolokomu kaali, mafak-nokomu. Kemin ale, saket daam alokso ma falduu kuyak saket disapnin ami diim tii bikiilokomu namti, saket daam alokso sole, saket disapnin kaaso, alep kii fanang maakup ke-lokomip disa yo. ");
INSERT INTO tif_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ultap kanolin kemin ale, tunum ayo meme ipnaal siin kawu dilduu kutiilala, fongbu umi tem kaptoowu kama alokso wain ok ayo iluula dongnale, sok ta kuluu tem ayo de-lom kulii-tal am tiila namti, ok ayo bomsile, fasun-um-bom ale, meme ipnaal filit disa ayo fasu-fasu um-bom abiltap-siik bikin-ilom ok ayo bisel-unokomu. Aa, ipnaal ayo atin mafak-alomdu balata tabam-nokomu. ");
INSERT INTO tif_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kemin, tunum ayo kama ami wain ok kaa iluulon o kala namti, meme ipnaal alokso dilduu kutiila bombuu kaata-kup, wain ok ayo iluu kulii-tal tiilokoma kaata, ti tambal-kup ilokomu no. ");
INSERT INTO tif_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tunum kaa kanta sawaalak kaami wain ok inamna kaa, yak wain ok kusnum kaa inam-nokoma dinim o kaali, dok kata bokola naa kalolip: siin kaami wain ok inamni umi abaal kaali, tambal dukum ale, alokso wain ok kaata, abaal dinim o, kalokoma no, kala Yesus ayo faldak-tiimin weng kaata bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","God ami iintang am ma daanule, Yesus ayo almi daang bakaalin tunum iso, nikil wiit lang iip-iip kaptoop liip un-bomdipla, almi daang bakaalin tunum iyo un-bomdiwa, ima tinap keyule, wiit lap kiiyo, dikela fuku-lomdip lap kiita ulel-bam inan yakyak una-biliwa, ");
INSERT INTO tif_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","kulaa Falosi malo ma ita itam-ilomdip bokoyip ko: Kiwe! Numi lo kaa boko-lomdu: Ibi God ami iintang am kaa okok kemin dinim o, kalsu te! Yale, ibi kanimin o kalaliwa, wiit lap kaa dikel-bam inan talabip i? Kibi numi lo kaa, ku-mafak-dakan-tababip te! ");
INSERT INTO tif_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kemipla, Yesus asiik bokoya-lomda: Ibi God ami Sukon Tem uyo tik-tiin-umbip kaa ma kaal kesip disa ema? Sawaayak Devit aso, almi ap-tunum iso, nikil iyo ima tinap keyilala bomdipla, Devit ali kabak kanimin nosa ni? ");
INSERT INTO tif_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Lotu umi lo uyo boko-lomdu: Unang tunum ibi bret fuu kulii-tal awem tunum pris imi kuyiwa, God ami kolum o, kala God ami am kufun-umbip kaali, inin dinim, awem kemin awem tunum ita-kup inin o. kalsu. Yale, Devit ali God ami am kaptam-ali din-ilomda, awem tunum imi ima awem sang uyo dik-daayilale, awem tunum ita ima awem duung ima tap kaali, kolale, Devit ayo lo-lomda anung ma inale, anung ma kaata, kuluu kuu almi ap-tunum imi kuyilala inasip o. Katale, ibi boko-lomdip: Kaali kukup mafak kesip o, ken-umbip disa. Kemin, ibi kanimin ma nolum o kalaliwa, nami daang bakaalin tunum kalawiili, ima tinap keyu kanu-bilipla, ibi bokoya-lomdip: Kuu ti kukup mafak kanubip o, kebip i? ");
INSERT INTO tif_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dukum Ami Man Nali, God almi iintang am umi tiin molin tunum ali kalabi kemin, nali ti yaap nami unang tunum imi bakayim-bamdi: God ami iintang am kulawu, Ibi kaa kanumin o kalomi kaali, ili ti kanolamip te! kala Yesus ayo Falosi imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kulaa asuk God ami iintang am ma daanule, Yesus ayo lotu am kaptamu God ami weng ayo unang tunum imi bakayin-bamda tunum ma atamala, ami sikil tingtup ayo famsa kala, kalala atamale, ");
INSERT INTO tif_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","lo utamsip kasel so, Falosi iso, am kaptam tiinaabip iyo aket fukun-bamdip kanumip ko: Yesus ayo talalu atafii-bam ilupla, numi lo kali, lo-lomda God ami iintang am daanu kaami diim kawu tunum kaayo, dap-talalulala atamup namti, dabii-din weng talalmin baan diim daa-lom dap-fatap-daalum o! kemip. ");
INSERT INTO tif_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Katale, Yesus ali imi aket kanolin aket fukunbip uyo utam-ilomda tunum sikil famsa ami kanum bokola-lomda: Kabi tam tola tal iip dikis kaldaaku tolnan o! aka-laam-salale, tunum ayo tola tal iip kulu tolnale, ");
INSERT INTO tif_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesus ayo tunum unang imi bokoya-lomda: Ibi numi lo kaami sang ma dik-daalokomi namti kalabuu no. Lo kuuli boko-lomdu: Kabi God ami iintang am daanu kaa, unang tunum imi dong dakaayan o, kalsu ne? yam-mafak-dakaman o, kalsu ne? Aa, boko-lomdu: Kabi unang tunum mafak-alin imi yam-talal-balapla, yaawa-laamin o, kalsu nelile, kuno kamboyawa, taan-laamin o, kalsu yoko? kala kanum boko-lomda, ");
INSERT INTO tif_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus ayo fal-siki tunum alik iyo talalu itafiin tal-unemsile, tunum yawiit ami bokola-lomda kanum bokola ko: Kapni sikil kaa ifilan a! aka-kem-salale, tunum ayo almi sikil ayo ifilale kulu, ami sikil uyo tangbal mokso-kup kelu. ");
INSERT INTO tif_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kata, lo utamsip so, Falosi iso, iyo alik aket atul dukum tabeyule, Yesus kaa dok kanolokomup i? kal-bomdip weng takenip ko. ");
INSERT INTO tif_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kemin, kulu Yesus keya yak aba tam amdu tikiin kawu beten ke-bam God ami naan-bala bom bii, ");
INSERT INTO tif_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","am daanule, kulaa almi daang bakaalin tunum iyo naan-daayala tilipla, tunum talangkal kuliita-kup ulelale, bokoya-lomda: Kibi nalmi kalaan tunum kelip te! kala kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kalaan tunum kelip o, kalase namti kalawiita ko. Ma ali Saimon sole, ami niing Andru so, ita kemin, Yesus ali Saimon ami bokola-lomda: Kapni win kusnum ma kaali, Pita yo, kala kanum bokolale; kuno ali Jems so, Jon so, alap yakal, aa Filip so, Batolomyu so alep yakal, ");
INSERT INTO tif_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu so, Tomas so, Alfius ami man awasekim Jems, awasekim Saimon kaali, tunum ma iyo baka-bamdip: Rom kasel numi tiin mosip ili waasi din-bom la fotabamnup tabanik o, ken-umba tunum, ");
INSERT INTO tif_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","awasekim Jems ma kaami man Judas ayo ulduu-som, Yesus ami bombii dap-fatap-daalokoma tunum Keriot kayaak Judas akal, kanolin kiita ulela yim-tiila ko. ");
INSERT INTO tif_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus ayo kanola amdu tikiin kaptamu tunum nikil talangkal iso amdu kulaa kela yakyak tildaak biil bokon tiliple, almi daang bakaalin tunum yaapkan iyo tala-tala-kelipla, (kulaa Yesus ayo tam tolba-kup, weng uyo bakaya) ko. Bakayin-balaya, unang tunum yaapkan tal debip iyo Provins Judiya kaptam-ami abip ma ma kasel iso, abip diildiil win finin Jerusalam kasel so, aa, yol ok balang diim abip alep Taya so, Saidon so kiimi ");
INSERT INTO tif_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","aket fukunin kaali, din Yesus ami weng kaata weng san-kaa-buluwa kawu, numi mafak-alin kaali, yam-talal-kaa-bam kemak o! kalalip tala-tala-kelipla, kuno sinik mafak im-buulin iso, tal atamiwa iso, iyo talalu-yimulala, tambal keliple, ");
INSERT INTO tif_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","tunum unang iyo utamiwa yi, Nak-tunum kusal iyo maleliwa, Yesus ami titil ayo yak imi diim aba-lom iyo talalu-yimulu tambal-namip kala, kalalipla alik iyo dok kano-lom Yesus ayo malelum o, kem una-tala-kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus ayo fal-siki ti almi daang bakaalin tunum itafii-bam ale, bokoya ko: Mafek mafek iiwa-yaamin unang tunum kipyaa! Kibi God ami miit tem bom-bilip kemin, alalta tiin molaya, ibi talalu tambal-kup tiin-bom ale, kano ti fiyaap duumin-kup bom-biliwa yo. ");
INSERT INTO tif_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ol-tinap ilin unang tunum kipyaa! Ibi kamala kalawaali ima tinap tiinip. Katale, God alalta ima kaa kukaayim-balala inbi-lomdip, ti inamnup kala, kalbip-kup, fiyaap duumalip ko! Aket uluum-kup tabeya-bulula ilin ipkal, ibi kamala kalaali amabip. Katale, God akal tambal-kup talalu-yokoma kawu, aban dii-bamdiple, fiyaap dukum duu-bam kemalip ko! ");
INSERT INTO tif_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Dukum Ami Man Nalmi kalaan tunum kipkal, ibi nami daang bakaalin kemin, nami waasi kii kipni itam suun-bamdip yam kayak daka-bam talalu itafiimin-kup ke-bam, kipni win kaa mafak bakayim-bam kem-laabip. Katale, kanolin kukup mafak kuu kanuyokomip kaata, fan ibi aket fukuniwa, God ali mafek mafek tambal kaata-kup abiil tikiin kawu bomda talal-yimba nu kalale, fiyaap awak dukum kaata-kup duu-bam, was daka-bam kemin o, kala-somla ko. Kemin, kanolin kukup mafak kutal-fukulin tunum kiimi awil-fakal kiili, kanolin kukup ultap kaata, God ami weng tem bakayin tunum ili kanuyin-biliwa, titil-fak-daka-bam ilsip. (Kemin ale, kipkal aket fukun-ilomdip titil-fak-daa-somdiwa yo, kala-somla ko.) ");
INSERT INTO tif_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bung kiimi aket-kup yelu ilin, kipkal! Ibi mafek mafek tambal ayo kuluulipla, kipni aket tem kuyak tambal ke-yimbu. Katale, kipni kanolin fiyaap duubip ayo kabak-ata-kup utabip. Kemin, fiyaap duumin kusnum ayo ma kuluulokomip disa; ibi ti angtiil yol dukum kaata-kup kuluulokomip. ");
INSERT INTO tif_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aa, kuno kamala kulu unang tunum ima imbi-lomdip, tiknup o, kala fiyaap sakbaalim dukum duubip kipyo, ilom am ma daanokomu kaali, ibi ima tinap dukum uyo uta-mokomip kayi! Tunum unang aban dii-bamdip fiyaap duumin dukum kebip kipyo! Ilom am ma daanokomu kaa, ibi aket uluum tabe-bam ama-bam ke-bamdiwa, yol dukum uyo kuluulokomip te! ");
INSERT INTO tif_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kibi unang tunum tal numi win uyo kufuyik o kala kaami aket-kup yelu ilin kipyo, God alta kipni uluum kuya-lomda, angtiil yol kukaayin-balaya, angtiil yol dukum ayo kuluulokomip. Ultap kemin, siin sawaayak kaa, ku-fatap-daka-bam ibakamin tunum malo ili numi win kaata kufuyik o kala-lomdip ilmi weng-kup God ami weng disa kemin, bakayin-biliwa, kipni kawil-fakal ili imi tong kaata bakamsip o, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesus ayo asuk bokola ko: Kibi nami weng bokoyi kaa, weng sanokomup disa yo kalbip disa; ibi weng sanip kemin, kamala nami weng bakayokomi kaa, talalu weng san bom-ilipla! Kanola kipni waasi kii mok inayin-bam ale, unang tunum kawanta ipni itam-suunbip iyo, tambal-kup ma kamayin-bam kemalip kayi! ");
INSERT INTO tif_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kemin, kanola kipkal ti, God ami bakaan-bilipla, ata taba-lom kipni yokoop ukayin tunum iyo dong dakaayin-bam ale, kawanta kasen-faka-bam tituleng kaa kipni bakayin-bilip, ilmi aket ayo talal-yim-bam kemak o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Dok kanolin tunum ata, kapni akalap malii kaali, tang afap dabaa-lom tela namti, ati kuno malii so fal-siki kolapla telak o. Kemin, ultap o. Kanola dok kanolin tunum kaata, kapni ilim saket ayo dildaa kuluula namti, kuno kenbap-kup, yak kapni siyot ayo dil dolan o. ");
INSERT INTO tif_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dok kanolin tunum ata tal kapni mafek mafek sang ma dik-daala namti, kuno kolan aa! Aa, dok kanolin ata kapni mafek mafek kulii-unse namti, ayo dukum-kup bokola-lomdap: Asuk kup-nan aa! kemin daa yo. ");
INSERT INTO tif_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kuno ti kapni aket fukunin ayo, nami nak-tunum kusal ita kukup tambal kukaap-nam-biliwa, yaap tambal-kup ilon o, kemap namti, kamosinim kawu kapsiik kanolin kukup tangbal kaata kukaayim-balawa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kanola kabi tunum kusnum kayak kayak iyo kamboya-lomdap kapni aket ayo kaptum kusal imi aket kapni kup-tambip kaata-kup imi kuyap namti, kuuta dong dokop-tokomu disa. Kaa dok ata naa kalolip: God ami lak duulin disa kikal imi aket kaa ilmi aptum kusal kiita-kup imi kukaayila-yaabip kemin, kiimi kukup kaa kulaak banule, kapni kukup kaata uta uta ke-lokomu dinim te! Kapso, iso, ipni kukup kaa maakup kemin, kuuta dong dokoyokomu dinim o. ");
INSERT INTO tif_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kanola kabi kayak kayak iyo kamboya kaltapni unang tunum imi kukup tambal kamap-tambip kiita-kup, tambal-kup kuyap namti, kuuta dong dokop-tokomu disa; le God ami lak duulin disa tunum unang yakal ti kanun-umbip o! ");
INSERT INTO tif_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kanola kabi mafek mafek ma kuluu kaptum kusal kiita-kup imi kuyale, aket fukunap yi, Salaya asiik maan tiip-nak o, kalap namti, kukup kanolap kulaa yaap lale, kuuta dong dokop-tokomu disa; God ami lak duulin disa yakal ti, kanola mafek mafek ayo ma kuluu aptum kusal imi kuyinbip-kup ale, ayo aket fanang daa, Ayo salaya asiik maan tiip-nokomip o, kem-tabasip kiiso imi dokoyokomu disa. Kemin, kiimi kukup kuu kabaak banula, kapni kukup kuuta uta uta ke-lokomu dinim. ");
INSERT INTO tif_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kemin, God ali unang tunum iyo God ami lak duulin disa isole, aa tunum unang iyo mafek mafek kuluubip-kup yaap ke yo kalin dinim so, kiili ti mok inayin-bamda aket bilili-kalin kaata ti kukaayila-tabasa. Kemin, God ami lak duulin disa imi kukup kaata kabaak banu nami kukup kaata uta uta kemon o, kalap namti, waasi iyo mok inayimbap-kup ale, kukup tambal-kup kamayim-bamdaple, mafek mafek kaptum kusal kuyale, boko-lomdap: Nak-tunum kusal kipsiik kuluulip, salala, kipsiik maan-tiip-nin o, kemin disa; keman o, kala-somla ko. Kanumin-kup ke-mokomap kaata, dong dokop-tulula, fan God akal maan dukum tiip-ta-lomda kukup tambal-kup kup-tale, kulaali kabi Sakbaalim Dukum God ami man ke-bom ilokomap o. ");
INSERT INTO tif_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kapso, unang tunum alik iso, iyo ban kemin unang tunum kemin God ayo ipni yam kot baan diim tii-lomda yam-mafak-daka-mokoma. Lale, kapni Kaalap God ali mok inap-tim-bam aket bilili-kalin kukaap-tam-bam kem-tabasa. Kemin ale, ultap o. Asuk kapkal unang tunum iyo mok inayin-bam, aket bilili-kalin kukaayin-bam keman o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus ayo asuk boko-lomda: Kabi God ami abiin ayo kuluu-lomdap ami okok keba kaali nasiik kuluu-lom, okok kemon o, kemin disa; kabi kap-tunum kusal aye, malo ma kaa bom-bilip kii yam kot baan diim daa-lom bokoya-lomdap: Ibi kukup mafak nuubip o, kemin daa. Kanumin kukup kaali kelap namti, God akal mafak kamap-tam-bam bokop-ta-lomda: Yi, kabi kukup mafak kebap o, tokokoma dinim te! Aa kanola kapkal utamapla, Kap-tum kusal aye, malo ma kaa bom-bilip, iyo ban kelip o, kalokomap kaa boko-lomdap: God alta umi du kaali, tiiyale, angtiil yol kaali, kuyak aa! kemin disa yo. Uyo kuno kelap namti, God akal du tii-lomda angtiil yol ayo kup-tokoma disa. Kemin, kanola kaptum ami ban ayo takan-telap dinimnuk o, kanolap namti, God akal ti kapni uluum ayo takan-tiip-ta, atin ti dinim-nokomu. ");
INSERT INTO tif_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kabi kaltapni mafek mafek ayo kaptum kusal aye, malo ma kaa bom-bilip, kii masiim kukaayokomap kaata, God akal mafek mafek uyo kuno masiim kukaap-tokoma. Kemin, God ami mafek mafek tambal kukaayin kaali, men ima waan abuumin ultap kemin, akal dukum-kup abuu-lomda, dibiila daak nek kalule, asuk maso ma kulii yak abuulala, donga-lom sekela tabu kala, kala-lomda kukaayokoma. Kemin, God ami mafek mafek kukaayokoma kaali, God akal kaptum kusal aye, malo ma kaa bom-bilip, imi mafek mafek kukaaya-laabap akal kano ulmi maan-kup tiip-ta-lomda kukaap-tokoma. Kemin, God ayo kukup tambal kup-ton o, keba kemin, aa ultap kapkal kukup tangbal uyo kaptum kusal aye, malo ma kaa bom-bilip, imi kukaayim-balawa yo, kala Yesus ayo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kulaa faldak-tiimin weng ma bokoyila ko: Tunum tiin fiim ma ata aptum tiin fiim ma ami liip kaa kukola unokoma nema? Disa kawi! Kanu-mokoma namti, alep maakup kulii afun tem unokomip. ");
INSERT INTO tif_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kemin, man katip katip kiili, sukul kukuyin mafek mafek kaali, talalu ma atabip disa; kemin, ilmi tiin molin o, kala kukuyin tunum kiita, talalu utamsip kemin, ita kukuyin-biliwa, man katip katip iyo utam dik-daa kuluu-yaabip. Kemin, bom bii man katip katip yakal utamiwa yi, Nokol dik-daa kuluulup kala, kalbip-kup, yakal ilmi kukuyin tunum iltap ke-lokomip. ");
INSERT INTO tif_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kap-tunum kusal imi kukup mafak katip katip kuuli, sung ilol tal aba yak tiin tem uneba tap ale, kapni kukup mafak sakbaalim dukum kanuubap kaata, as daang ta tiin fuk-duup-ta-yaaba tap. La, kabi kap-tunum ami bokola-lomdap: Naktum kapyo, tiin sung tal aba yak unan o! Ken-umbap. Katale, aket fukun-ilom as daang tiin faka-tanip-na kulaa laap bombu kemin, am ma daanula disa ke-lokomu no. Kemin, aket uluum kep-nokomu disa yo, kem-laabap. Kemin, kabi kaltapni kap-tunum kusal imi kukup mafak katip katip kulaa utamsap. Katale, kaltapni kukup mafak awak sakbaalkan dukum kanuubap kabak-ali kabi utabap e? disa? ");
INSERT INTO tif_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kanimin o, kalalapla kap-tunum kaa bokola-lomdap: Nak-tunum kapyo, dong dokop-ta-lomdi tiin sung ayo kukan-tiip-ton o, kalbap i? Daa! As daang ta tiin faka-tanip-ta tiin bokol ke-salap kalaali, dok kano-somdawa dong dokolokomap i? Kabi kukup alep fukumin tunum kapya! Kamosinim as daang uyo kaltapni tiin diim bombe kaali, kukan-tii-somdawa kawu, yak kap-tunum ami tiin sung uyo talalu utam-ilomdap kukan-telamap ko. ");
INSERT INTO tif_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus ami weng faldak-tiimin weng ma bakaya-lomda: As tambal kaali, as lap mafak ma abuulokomu disa; ale as mafak ayo ma as lap tambal abuulokomu disa. ");
INSERT INTO tif_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kemin, nokol utamupla, Kanolin as lap uyo abuubu no, kalup namti, utam, Awu, kanolin as kaali ti tambalim aa, yak kanolin as kaata mafak o, kalokomup. Uyo kanolin kemin, nuli as tiyup miit tem yang-ilomdup as fik lap uyo ma duk-duu inam-nokomup disa; ti tiyup lap ulmi-kup abuu-laamin o. Ultap kemin, nuli yang sok masiil ami diim kawu dalap ayo abuuba no, kalalup duk-duulokomup disa. ");
INSERT INTO tif_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ultap kemin, nuli tunum kunolin iyo kukup kanun-umbip kalup kulaa nokol utam, Ami aket fukunin kaa kanu-bam kanun-umbip o, kalokomup. Kemin, tunum tambal ili aket tambal fukun-bam ale kukup tambal kaata-kup ke-bam ale, weng tambal uyo baka-bam ken-umbip ale, tunum mafak itale, aket fukunin mafak-kup ke-bamdip, weng mafak baka-bam kukup mafak nuu-bam ken-umbip o, kala, Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesus ayo bokola: Ibi nami win kaa suunkup bakap-nam-bamdip Kamokim o, nakan-kaamin-kup laabip. Lale, kibi kanimin o kala, nami weng kaa weng san-kaamin dinim i? ");
INSERT INTO tif_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tunum nami fanang tildang nami weng uyo weng san-kaa-bam ale, nami weng kala bakabi kaayo, weng san-kaa-bamda nami kukup tangbal uyo kutal-fukula namti, ali kanolin weng kala bokolokomi kaami kukup fukulin tunum alaltap namti kulube. ");
INSERT INTO tif_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kanola tunum ayo am tambal dinamin tunum alaltap kemin, din am kun iyo bobi kulii-tal tii kelale, yak am kun tem iyo tuuptuup-kup dikila-dikila-ke-lomda, am ayo dela, alimal am un-ilomdip sin-yaa-bam bom-iliple, ok ayo fakan tiltoop-ilomda, am ayo balata kulii-unon e, kalbu. La, am kaa tambal-kup talalu dese. Kemin, am uyo, talalu yikik tawaal kaali, fuku tolasu. ");
INSERT INTO tif_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ale, dok nolin tunum ata nami weng kala bakabi kalaayo, disa tinang-kup umu-bomda, nami kukup tangbal ayo kutal-fukulin dinim kema namti, kalanolin sang kala bokoyokomi umi kukup fukulin tunum alaltap namti kulube. Tunum ayo am kun kaa tawaal tem uyo talalu kala-lomdala disa; kemin disa laap loklok delaya, ok ayo fakan tiltoop-ilomdu am kaali, abiltap-siik bal daala daak abamnule, kulaali ok ta taba balala kulii-unsuu no, kala Yesus ayo faldak-tiimin weng uyo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus ami weng alik kaali, unang tunum imi bakayila disa kelule, kulaa kela daak abip Kapeneam una. ");
INSERT INTO tif_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kemin, Rom kaptam-ami waasi dinin tunum wan handret (100) imi kamokim kawu ilin ayo ok tabuulin tunum yaapkan kemin, almi okok kemin tunum maakup ma ami aket dukum konsa ayo mafak-alin dukum kuluu-lomda, ti taanon e kalale, ");
INSERT INTO tif_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ami kamokim ayo weng sanaya, Unang tunum iyo Yesus ami sang kaali, bakabip kala, ayo weng san-ilomda, Juda kayaak tunum kamok kamok malo ma imi bokoya-lomda: Ibi din-ilomdip, Yesus atam bokolipla: Tal-ilomdap waasi dinin tunum imi kamokim ami ok fokolin tunum ayo dap-talalulan o, akin o! kala-lomda, iyo yim-baala din-ilomdip, ");
INSERT INTO tif_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Yesus ami diim aba-lom dukum-kup Yesus ami bokola-lomdip: Waasi dinim tunum kamokim ali Juda kayaak numi aket kaata kukaayin-bamda alami moni kaata, kuluu-lomda, lotu am ayo numi deyase. Kemin, ali tunum tangbal-kup tabasa. Kemin, kabi din kaa dong dokolan o, akiwale, ");
INSERT INTO tif_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus ayo tunum mep kulu bom-bilip iso yakyak din abale, Yesus ayo tal am mepso abale, waasi dinim tunum imi kamokim ami kayaak iyo yim-baala din Yesus ami bokola-lomdip: Kamokim kapyo, waasi dinim tunum kamokim ali boko-lomda: Daa! Nali tunum tambal disa; nali ti ban kemin tunum kemin, kamokim kabi timbi din nami am kaa unokomi disale, ");
INSERT INTO tif_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","aa, tunum tambal keluya, kapni fanang uyo din unokomi dinim. Kemin, kabi kulu tola-lomdap, weng kaata-kup bokolawa, nami ok tabuulin kaltamu bombe ayo asuk yaap-nak o, aka-lomda ");
INSERT INTO tif_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","bokola ko: Nakal nalmi dabom ami weng-kup weng san-kaamin tunum ale, nali waasi dinin tunum ilmi-kup 100 kalawiimi kamokim tiin molin kemin, nali tunum ma ami bokola-lomdi: Unan aa! akokomi, ayo unokoma le, Tal o! akokomi, ayo talokoma; aa, kuno nali okok kemin tunum ami bokola-lomdi: Yak kanolin ok kaata kanuman o, akokomi, ayo yak nuu-mokoma. Kanolin kemin ale, kabi yaap titil so yaap kemin, kuno kela weng kulaata-kup bokolapya kulu nami ok fukulin tunum ayo tambalnak o, kala waasi dinin tunum ayo kanum bakaba kaali, ili Yesus ami kanum bokolip ko. ");
INSERT INTO tif_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kemin, Yesus ayo kanolin weng uyo weng sanba-kup, aket kong-mo fal-siki titoop daa unang tunum almi daang tem kulu talebip imi bokoya-lomda: Nali weng ma bokoyokomi kaali, weng san iliwa! Nali Israel-miin kipni iipyak tem kulu tal-unen-umbi uyo Juda kipni aket ayo fukun-bamdip: Nuli God ami man namti kala bom-bulup kayi! kem-yaabip. Lale, nali ma atamila, ali ma nitam, U, Yesus ali ti yaap kukup alik kanolokoma no, keba, kaa ma atamsi disa; Rom tunum kalaami aket fukunba uyo, utamaya, Yesus ali daa; weng kulaata-kup bokolaya, nami okokmin tunum mafak bomda yang am bombe ayo yaap-nokoma no, kalba kemin, ami nami lak dakaamin uyo sakbaalim dukum keluya, alik Juda kipta nami lak dakaamin uyo daak banin ko. ");
INSERT INTO tif_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mep waasi dinim tunum kamokim yim-baala tilip tunum iyo asuk din kamokim ami am din-ilomdip, kamokim ami ok fokolin tunum ami mafak-alin ayo yaaba kala, kalip ko. ");
INSERT INTO tif_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesus ayo kanumsi bom-ilom, ayo abip ma Nain kaptam banon o, kalala, alami daang bakaalin tunum iso, aa unang tunum yaapkan iso, maakup yakyak unip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus nikil iyo yak aba unbilin abip kaptam-ami uti daam tem umi saal mepso din unipla, Nain kayaak yakal tunum ma saakba. Kemin, dibii-din dawaalum o, kala dibiilip tilipla, din itamiple, tunum saakba ami awak uyo unang kaluun mafak kemin, ulmi man tunum man yaan maak kemin, awak ukol biin tem una as de dibii-talabip imi daang tem kawu tala-bulule, kuno unang tunum yaapkan yakal umi daang tem kamet tala-bilip kemip. ");
INSERT INTO tif_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kemin, Kamokim Yesus ayo unang kuu utam-ilomda, dukum-kup olen-daawa-lomda, bokowa ko: Awak kupyo, amamin daa yo! wakale, ");
INSERT INTO tif_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","kulaa, yang tunum biin kaami mepso kawu un-ilomda akola sikil kuyak tunum man saakba ami biin diim kawu malelale, mep tunum as de dip-tama talabip yakal kulu tolniwa, kulaa Yesus ayo tunum taanba ami bokola-lomda: Man tunum man kapyo, kabi tam tiinan aa! aka, kem-salale, ");
INSERT INTO tif_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","kulaa, tunum man taanba ayo tiltam tiin-ilomda, weng bakan-tabale, Yesus ayo awak umi bokowa-lomda: Awak kupyo, kupni man kala tam tiina kalaatam! waka-lom, awak ulmi kuuwa ko. ");
INSERT INTO tif_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kanolaya, unang tunum alik iyo Yesus ami kanola kaali, atam-ilomdip alik iyo suunin dukum kaa ke-bamdipla, God ami win uyo kufon-biliple, kuno malo ma ita bokolip: God ami weng tem bakayin win tabin tunum o, kebip profet ayo tal nulmi iipyak tem kulawu tolna atamum i, kemiple, kuno malo ma ita boko-lomdip: God ata tal alami tunum unang talalu-yimulon o, kalalaya alta tala no, ke-bilip kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Unang tunum alik iyo Yesus kanola kaami sang kaata-kup baka-bala baka-bala ke-biliwa, weng yakyak din Provins Judiya kaptam-ami abip ma ma sole, aa yak aba umbilin kusnum kusnum imi abip ma uyo weng yakyak din unu weng san-san-kelip ko. ");
INSERT INTO tif_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Oksam ukayin tunum Jon ayo sok de-dap am daalip bom-balaya, Jon almi kalaan tunum iyo tal Yesus ami kanun-tabasa kaami sang kaata, Jon ayo bokolipla, Jon ayo almi kalaan tunum alep ma ulduu-yim-baalala ");
INSERT INTO tif_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","20","tal Yesus bokolip ko: Oksam ukayin tunum Jon ali weng ma kuya-lomda, yim-baala tulup. Kemin, ali boko-lomda: Kabi tifaneng God ata uldaa-tam-buu-lomda, tam-baala tal-salap e, tunum kusnum ata ne? kalalup fenupla talak e? kala Jon ayo kanum boko dik-daala no, kala tal kanum bokolipla, ");
INSERT INTO tif_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ayo alep imi tiin diim kulu, Yesus ayo angtiil mamin kaabip tunum unang iyo yam-talal-bam ale, angtiil mafak-alin kan-tabasip unang tunum imi yam-talal-bam ale, sinik mafak kan-unsip iyo takan-tiiyim-bam, tiin mafak ken-unsip iyo yam-talal-bam ke-balala, ");
INSERT INTO tif_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jon ami kalaan tunum alep iyo atafiimiple, Yesus ayo bokoya-lomda: Alep ibi din kanolin mafek mafek atamip so, weng sanip so, kiimi sang kaali, kulii-din Jon ayo bokolin o! Tiin mafak ayo tiin baa mafek mafek itafii-balale, yawiit daam ayo tam tola tal-une-bilip, angtiil mafaksip iyo asuk tambal ke-biliple, talang abat iyo asuk weng san-kaa-bilip, tunum unang saakbip iyo asuk tam tiin laa-bilip, ale, tunum unang iiwaan iyo God ami weng tambal bakayinbi kaali, weng san-kaa-bilip, kebip kaali, ibi atamip kemin, alep ibi din-ilomdip Jon ami diim kawu ipni kanolin atamip so, weng sanip so, kaami sang kaali, bokolipla, ayo weng san-ilom kaal kela, nili kanta kala, nakak o kala. ");
INSERT INTO tif_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kemin, tunum ayo nami kanolin kala kanubi kaami aket fukun-bam ale, bokola: Yesus kaata-kup God ayo uldaa-dabuula talse no, keba ayo fiyaap duuma. Kemin, alep ibi dindipla, Jon ayo sang alik kaayo, bokola-lomdip: Jon kabi aket alep fukunbap kemin, ti aket ma uyo kelalap aket maakup ke Yesus ami fiyaap kaata ti duu-bam bom-balawa yo! akin o, kala, Yesus ayo alep imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon ami kalaan tunum iyo tabaniple, kulaali Yesus ayo tunum unang yaapkan tiinbip imi Jon ami sang kaata, bakayim-bamda bokoyila: Ibi siin kaa din tunum dinim bokon kawu bom-balala, Jon ami fanang unemsip kaa, kanimin ma atamum o, kalalip unemsip i? Kipni aket kaa fuku-daaliwa yi, Awu, daal tibin tunum ma inim ta taba fuun-balala, mokol falduu dibii-une-taleba alaltap o, kalalip kaami din atamum o kalalip un-silip ema? Daa te; Jon ali daal tabin tunum disa; ali titil tibin tunum te! ");
INSERT INTO tif_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aa, ibi kanimin ma atamum o kalaliwa, un-silip i? Ibi fanang daatamin: Awu, tunum ma ilim tambal tambal ata-kup miki-balala, kaata din atamum o, kalalip un-silip ema? Disa kawi! Jon ali kaaltap disa; ali tunum dinim bokon kawu ilin tunum kemin ale, tunum ilim tambal tambal mikimin ili king ami am kawu bomdipla tambal-kup laabip. ");
INSERT INTO tif_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kemin, ibi kanimin ma atamum o, kalaliwa unemsip i? Ibi din God ami weng ku-fatap-dakamin tunum ma atamum o, kalalip un-silip ema? Kaali fan, Jon ata weng ku-fatap-dakamin tunum kusnum alik kuliili kabaak baniwa, ata ata kelala akayinsa te! ");
INSERT INTO tif_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kemin kaali dok kata naa kalolip: God ami Sukon Tem kabak-ali Jon ami sang kaata, sawaalak kawu boko-lomdu: God ali almi man kaami bokolaya: Tunum kulaata-kup ti nalmi kalaan tunum ke-lokoma te! Kemin kaali, nalta uldaa-dabuulila, ali dusiin daa din tawaal diim kalawaami unang tunum imi bokoya-lomda: Kibi iltipni aket tem kaa talalu bam-daka-bam kemiwa, kamokim ayo talak o, kem ale, kapta, mafiing kawu talokomap kayi! kala, God kaa almi Man ayo kanum bakaala no, kala God ami Sukon Tem kabak-ali kanum bokosu. ");
INSERT INTO tif_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kemin, weng kala bokoyokomi kaali, weng selin! (Siin kaali, God ami profet kiili God ami weng uyo kulii-tal bokola bokola kem-tabasip. La,) tawaal diim tunum alik kala tiltam tiltam kem-tabasip imi tunum maakup ata ma tiltam aba-lomda, Jon ata nami sang kulii-tal bakayimba alaltap so ma kanu-bamda kulii-tal bakayila-tabasa disa. La, unang tunum tiltam God ami miit tem talokomip kiilile, saak man mafak, man tambal yaapkan iyo tiltam God ami mafek mafek so, kukup so, iyo talalu utam-somdiwa kawu, Jon ata God ami kukup utamsa uyo kukan-tela-lomdip ita ita ke-lokomip o ");
INSERT INTO tif_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Siin sawaalak kaali, unang tunum alik ili Jon ami weng kaa weng san-silip. Kemin, unang tunum win dinim so, takis kaamin tunum iso, imi aket fukunin kaa, ti tambal keyu bokolip: God ami weng kaa ti faneng kayi! kalale, yak aba tal Jon ami diim tale-biliwa, ayo oksam ukayinsa. Yale, ");
INSERT INTO tif_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","yak Falosi so, lo utamsip tunum iso, iyo aket fukunin tambal dinim kemin, Jon ami miit tem un-ilom Jon ami kamboliwa, ali oksam ukuyinsa disa; kemin, iyo God ami mafek mafek ma ipni dong dokoyon o, kala-lomda kutiiyinsa kaali, umkayak dakan-umbip o. ");
INSERT INTO tif_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus ayo asuk bokoya-lomda: Aa, unang tunum kamala kula bom-bilip kibi dok kanolin unang tunum i? Kibi unang tunum dukum ke fasuu-silip. Lale, ibi ti man katip katip ililtap ke bom-bilip te! ");
INSERT INTO tif_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Man katip katip iyo abip daal iip kawu tiin-bomdipla, malo ma bak-duu aptum kusal iyo weng naan-daayilale, bokolip: Nuli was samanin tap kemum i, kalalip baal wii-bam ale, was daka-bam kebup. Katale, malo ma kiptale, nuso was wiimin disa; ale, nuyo tunum taana dawakamin tap kemum o! kalalup amabup. Katale, kipta tal nuso amamin disa kebup o. Kalok nolin akal alik akal alik kabak-ami kukup kanu-mokomup kaali, ibi daa yo, kalalip kela kela kebip o, ken-umbip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ultap o. (Ibi man katip katip fuut-kup tabin iltap ke-bamdiwa, Jon ami weng kuluuli weng sanup disa yo, kal-bom ale, kuno nami weng uyo weng sanup disa yo, kal-bom kanu-bamdiwa, ibi disa kaami kalan kaata alep numi weng mafak kaata kukaayim-bam itafiin-umbip.) Kemin, Jon ami aket fukunin kaali, God alalta bokop-na-lomda: Yak kanolin inin-inin kaali inolap dinim o, nakase no, kalala, fala-biliya, God ali nami fiyaap ata duumak i, kala-lomdala, inin-inin kusnum kiiso, wain ok so, iyo suunkup falamin-kup ke-bam biisa. La, tal kaa kanu-balaya, ibi atam-ilomdiwa boko-lom: Fan, mep tunum kalawaali sinik mafak ta dap-mafak-daalaya, inin-inin kaa suunkup falan-umba no, kem-tabasip. ");
INSERT INTO tif_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kemin ale, Dukum Ami Man Nali taldila, ima so, wain ok so, kiili awem o, kalalila uyo ma kulaasii disa; ipni ima alik inan-umbip kulaa inan-yaabi. Lale, ipta bakap-nam-bamdip: Kipyo! mep abuuyap ayo soko talalu atamin i! (Juda numi kukup kaa ima mafek mafek fala-fala-ke-bam God ami beten kaata-kup kamaalin. Lale, Yesus ali ti ma kanumin dinim.) Ali takis moni kaamin tunum so, kukup mafak fukulin tunum kusnum malo ma iso, imi kayaak o, kem-yaabip. ");
INSERT INTO tif_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","God ami kaal kemin kaali, atin tambal kaayu, kawanta ma ami kaal kemin kukup uyo kutal-fukulokoma namti, ali utama ya, Awu, kaali ti faneng o, kalokoma no, kal-bomda Yesus ayo kanum baka-bamda bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Falosi tunum ma ayo Yesus ami bokola-lomda: Kabi tal nami am kawu naso alep ima inum o akale, Yesus ayo din Falosi ami am kawu tiin bomdip ima in-bom iliple, ");
INSERT INTO tif_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","sadikimin unang ma abip kaptamu bombuu kemin, weng selula, Yesus ayo tal Falosi tunum ami am kaptamu bomda ima inba no, kalip itabu-kup, kulaa uyo yak tuum ket talalusip ket tem tang tambal-kup tabin wok ayo kuluu ");
INSERT INTO tif_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","kulii-tal Yesus almi miit tem mepso kulu uyo tilik duung fakela daak tiin-ilomdu akolkup ama-bulula, umi tiinok ayo foko daak Yesus ami yaan diim abe-balala, uyo yak ulmi dabom kon batbat kiita daak Yesus ami yaan diim tiin ok kaayo, diliit molule, kulaali king imi win kufuyin kukup kaata-kup kuluu-lomdu, Yesus ami yaan ayo fiil-buluk takaan-bamdu: Yaap ke; nalmi kamokim e, kal-bomdu kanu-bam ale, kulu wok ket tang tambal-kup tibin wok namti sang daalula, daak Yesus ami yaan diim namti abamnu ko. ");
INSERT INTO tif_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Falosi tunum ata Yesus ami bokola-lomda: Talawa ima inum o aka ata, unang umi kukup kanubu kaali utaba-kup, akal aket fukuna yi, Yak kanolin unang kuuli, sadikimin unang kemin, fan tunum kalawaali, God almi weng tem bakayin tunum kelama kaali, akal utam: Awu, kaa dok kanolin unang kuuta, tal malep-nalamu disa yo, kalba. Katale, ali utamin disa keba kemin, atin ti ali weng tem bakayin tunum disa kala, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesus ayo utam talaala yi, Falosi ami aket fukunin ayo kanu-bam fukunba kala, kalba-kup, bokola-lomda: Saimon kabi nali weng ma bokop-tokomi no, kalale, Saimon asiik bokola: Ayo, kukuyin tunum kuno bokop-nan o! akale, ");
INSERT INTO tif_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus asiik faldak-tiimin weng ma bokola-lomda: Tunum moni kayaak ma ata tunum alep ma imi, Moni kii asuk maan-tiip-nin o kala, ma ata 100 kina le, ma ata 10 kina keyilale, ");
INSERT INTO tif_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tunum alep iyo maan ayo tiilalip disa, kelip. Katale, tunum moni kayaak kaa mep tunum alep imi maan ayo kuno kamboya ko. Kamboyilale, tunum alep kiili, ma ata moni kayaak ami aket-kup kola kaali, ata ata kelaya, ma ata kabaak bana yoko? kala kanum bokoyilala, ");
INSERT INTO tif_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","kulaa Saimon asiik bokola: Nami aket fukunbi kaali, tunum kaami uluum dukum 100 kina iyo molin disa kaata no. Moni kayaak kaata, kaami uluum uyo kuno kambola kemin, tunum ayo moni kayaak ami aket-kup kola no, kalbi no, akala, Yesus ayo ami bokola: Kulaa, kapni aket fukunin kaali, tituun-kup kep-tu no, aka-lomda ");
INSERT INTO tif_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","fal-siki tiyak daa, unang uyo sikil diil tuwale, Saimon ami bokola-lomda: Kabi unang kalawuuli kulu utamap ema? Nali tiltam kapni am tiltam talbi. Yale, kabi numi kukup kaa kutal-fuku kaltapni okok kemin tunum ayo dabaalap taldala, ok ayo ma kuluu-lomda nami yaan ayo ma diing daap-nin dinim; kata unang kulawuuta, ulmi tiin wok ta taba nami yaan kalaali diing-nambu-kup, ulmi dabom kon batbat kiita yak nami yaan diim tiin ok ayo dilit mop-na kelu. ");
INSERT INTO tif_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tal am kaltam ba talbi kaa, kabi kanola fatal tunum tala ayo weng umkaan-bam ale, tiin matum fiil-buluk takaalin kukup kaa ma kanop-nin disa kelap. Kemin ale, mep unang kuluwuuta, nami yaan ayo fiil-buluk takaala yakyak kutal kala diilu. ");
INSERT INTO tif_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kemin, kabi nulmi kukup kaa ma kutal-fuku-lomdap yak tang tambal-kup tabin wok ayo kuluu nami dabom ayo diliit mop-nin disa kelapla, mep unang kalawuuta, tang tambal-kup tabasa ok ata kulii-taldu, nami yaan kaa diliit mop-nu te! ");
INSERT INTO tif_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kanolu kemin, ti weng san-ilapla, bokop-ton: Unang kuuli utamula, Nali kukup mafak kaa kanun-umbi no kalalula, Yesus kaata nami uluum sakbaalim dukum kaali, takan-tiip-nama no, kalalula, uyo nami aket dukum kaa kup-na-lomdula, yak kanolin kukup kaali, kanop-nu no. Lale, kanola tunum ali ma aket fukuna yi, Nali uluum katip sakap kaal fong so kebi no, kala namti, ayo takan-telokomi. Yale, yak kanolin tunum kaa nami aket katip kaata-kup, kup-nokoma no, kal-bomda Yesus ayo Saimon almi sang kaata, bokola. ");
INSERT INTO tif_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kemin, Yesus ayo unang umi bokowa-lomda: Nali tifan tituun weng bokop-tokomi: Kupni ban kaali, takan-tiip-ti no, ukale, ");
INSERT INTO tif_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","kulaa yak tildak tiinbip tunum iyo, weng san bakan-una-tala-ke-bam atafiimin weng uyo boko-lomdip: Dok kanolin tunum kaata, ban wakamin ayo takan-tiip-ti no, keba ni? Kem-una-tala-kemipla, ");
INSERT INTO tif_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus ayo unang umi kanum bokowa-lomda: Kubi nami lak duubap kemin, God ata talalu-tamulala, kubi tambal-kup bomdawa yo, waka ko. ");
INSERT INTO tif_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ilom ale, Yesus ayo din abip dukum dukum so, abip katip katip so, kawu tal-une-bamda God ami weng tambal uyo bakayila-tal-une-bam ale bokola: Kiwe, kipni yang kabangu tiinaasip kaa kulaa-somdipla, tildang God ami miit tem tilin o! yakan-kaa-bam bakayin-balaya, almi kalaan tunum talangkal isole, ");
INSERT INTO tif_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","unang malo ma iso, nikil iyo Yesus aso, abip ma ma kaba unip. Kemin, unang kaa-bilip kiilile, siin kaali malo ma ili mafak-alin ta yim-tal-fukulin ale, malo ma kiita, sinik mafak kan-unsip. La, Yesus ata talalu-yimulala, yaawa-silip nikil kiita, ili ilmi moni ta kulii-din-ilomdip, ima kaa saanbi kulii-tal fuu-bamdipla, Yesus aso, almi kalaan tunum iso, imi kukaayin-bilipla, nikil iyo inan yaksip. Kemin, unang ma uyo abip Makdala kayaak unang Maria kuuli, Yesus ata sinik mafak ilmi-kup fetkal iyo kukan-tiiwase. Ale, ma kuumi win kaali, Joana kemin, umi imak kaami win kaa Kusa ayo King Herot ami am awak dukum kaptam-ami soldiya imi tiin molin tunum kesa. Ale, afalop ma umi win kaali, Susana kanolin kemin, unang yaapkan ma iso, Yesus ami daang bakaalip ko. ");
INSERT INTO tif_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tunum unang yaapkan ilmi abip ma ma kiiyo kela tal Yesus ami fanang tala-tala-ke-bilipla, Yesus ayo utama yi, Tunum unang iyo yaapkan kelip kala, kalba-kup, kulaa weng faldak-tiimin weng ma bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Kulaa, tunum ma ayo wiit o kala-laabip kaami san kaali, kulii-din langabip kawu sekelmon o kalala, una kemin, san kiiyo sekelale, san malo ma iyo sekela daak langabip kaptam-ami liip kulu-bamniple, awon ita tal inamnip, kuno unang tunum iyo tal-une-bamdip wiit san iyo kulaak saan tal-une-bilip tambal kelakin disa ke-lom atin ti mafaknip. ");
INSERT INTO tif_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kuno san malo ma kiili, sekelna daak tawaal tuum tip diim aba bikin-tibip. Katale, tuum diim kaali ok dinim kemin, taba-lom tam iip kuluba datnip. ");
INSERT INTO tif_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","San malo ma kiita sekelna daak al mafak imi iipyak tem un-ilom tabamniple, abiltap-siik al mafak ita ita ke-lomdip, kuyak molip mafakniple, ");
INSERT INTO tif_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","malo ma kiita daak tawaal tambal diim aba tambal-kup taba-lom iyo abuu-bi-lomdip, 100 kup abuula abuula kelu no, imba-kup, bokola: Ibi abat disa; ipkal talang tem tambal kemin, mep weng kala bokoyi uyo talalu weng san-ilomdip atamin a! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus almi daang bakaalin tunum iyo ami weng uyo weng sandiwa, iyo dik-daalip ko: Kamokim kapyo, nuli kapni weng kaa ma talalu kaal kelin disa kelup kemin, kabi kabak-ami miit kaayo, ifii-lom bokoyan o! akipla, ");
INSERT INTO tif_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesus ayo bokoya ko: God alalta kipni aket tem ayo ifiiya kaal-kebip kemin, kipkal utam ale, Awu, Yesus ami faldak-tiimin weng bakayin-bamda faldak kulu tii fal taldak kulu tii ke-balala, nokol kaami miit kaa talalu bam-daa, Awu, kanolin kanolin kabak-ami miit kaata nu! kalale, uyo tiltam God ami miit tem talemin kaata no, kala utabip. Katale, tunum malo malo kiita, nami ok kala talalbi kaa, ilmi tiin alep alep utafiin-umbip. Katale, imi aket tem uyo ma talalu kaal-kesip disa; le, ilmi talang tem alep kii, nami faldak-tiimin eng kaali, weng san-kaan-umbip. Yale, faldak-tiimin weng miit kaa ma talalu weng san-kaan-umbip disa yo. Ti disa weng san-kaamin kaata-kup, kanun-umbip. Kemin, kaali dok kanolin kabak-ata disa, nalta faldak-tiimin weng ayo mep kanolin tunum kiimi bakayila-yaabi no, yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesus ayo weng faldak-tii bokoyila kaami miit kaali, ku-fatap-daa bokoyila ko: Kaami miit namti kala bombuu: Wiit san kaali, God ami weng kuluuta te! ");
INSERT INTO tif_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","San malo ma kiili, sekela daak liip kulu abamniple, awon iyo tal inamnip o, kali kaali, kalanolin tap o. Tunum malo ma ili God ami weng uyo weng saniwale, Setaan ali awon kiimi kukup alaltap ke tal-ilomda God ami weng yak aket tem un-ilomdu bombuu kaali, takan-tiiyilala iyo weng kaa lukuuyilula, dok kano-som God ami lak ayo duuliwa, talalu-yimulamu disa yo. ");
INSERT INTO tif_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","San malo ma kiita, sekela daak tuum tip diim aba-lom bikin-taba datnu no, kali kaali, kalanolin o. Tunum malo ma iyo God ami weng ayo weng sanbip-kup, kutal-fuku fiyaap duu-mokomip. Katale, san ultiilap bikin-tabokomu. Yale, timtim disa kebu ultap kemin, kanola God ami weng kaali, kutal-fukulokomip. Katale, talalu fuku ku aket tem daalokomip disa; kemin, God ami lak ayo du kutal-fuku bom-iliple, Setaan ayo tal yam-kuku-mokoma kawu, kela yang banokomip o. ");
INSERT INTO tif_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ale, yak san malo ma sekela daak al mafak imi iipyak tem unipla, al mafak ita kuyak molip, mafak-nokomip kaali, kanola tunum iip maakup maakup ma ili God ami weng ayo weng sanokomip. Yale, tawaal diim kaldaak-ami mafek mafek yaapkan imi aket kaata, aket yaapkan fukun-bam ale, moni aket fukun-bamale, mafek mafek iipnip kaami aket kaata-kup suunkup fukun-bam ale, disa fiyaap duumin kaami aket fukun-bam kemin kaata uta uta kelule, God ami weng kaami aket utale, kulaak bunu, God ami ok kaali, okok-mokomip dinim o. ");
INSERT INTO tif_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kemin ale, san malo ma kiita sekela daak tawaal tambal diim aba tambal-kup taba abuulip. Kemin, kaali ultap o. Tunum malo ma iyo God ami weng kaali, weng sanbip-kup, lukuuyokomu disa; ti kano dukum-kup kuyak aket tem daalokomip kaa, God ami okok kemin kaali, suunkup titil-foko kutal-fuku-bom nuu-mokomip. Kemin, kanolin kaali, wiit lap yaapkan abuulokomu kaa, 100 kup abuu-laamin alaltap o, kalala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesus ayo asuk faldak-tiimin weng akal kusnum ma kaata, bokoya-lomda: Nuyo ilaam ayo iilfo kuyak baket tem aye, iilfo kulaak bet umi minlo tem anang kawu tiilokomup disa; ti kutam asal ulumi baan diim kawu tiiluwa, am kaptam ayo iilfo falala-kup kala bom-balaya, unang tunum iyo tiltam-ilomdipla, ata-mokomip o. ");
INSERT INTO tif_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bom bi-lom am mafiing daan tiltam talokomu kawu mafek mafek alik sawaanasip iyo, God alalta yam-taltam fatap diim daalala, ibi kuu ita-mokomip o. Ultap kemin ale, bi-lom am mafiing diim daanokomu kawu, weng sawaansu kaali, God alta weng ku-fatap-daalala kawu, ibi weng sanokomip te! ");
INSERT INTO tif_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kanolin weng kaa, bokoyili kaayo, ibi God ami weng alik kaali, talalu weng san bom iliwa yo, kala-somla ko. Tunum kanta ma nami weng kaali, weng san kaal-ke-lokoma namti, kaali God ata dong dakaan-balala, kaal ke yakyak kem-unokoma. Kemin ale, tunum kanta nami weng kaali, weng sanin disa ke-lomda kaata, Nali utamsi no, kala namti, kaami weng katip ma kaa utamsa kaali, abiltap-siik lokolokomu no, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kulaa, Yesus ami awak so, nakal so, aptil iyo Yesus ami fanang tal uliwa, Unang tunum yaapkan ita taba-lom Yesus ayo falala dabak-mobip kala, kalaliwa, aket fukunbi: Kwin! kaata dok liip yang-ilomdupla, Yesus ami mepso kaa yang unokomup i? kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kanumipla, tunum ma Yesus ami mepso bom-bilip ayo, Yesus ami bokola-lomda: Kapni nakal-aptil iyo tam daak abip kabaaku tal tola-bomdip titamum o, kebip te! akale, ");
INSERT INTO tif_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","asiik ami bokola-lomda: Unang tunum kanta God ami weng kaata, weng san-ilom kutal-fukulip namti, fan kiita nami akamen ale, nakal-fakal namti kiita ililtap o, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kulaali am ma daanule, Yesus so, almi daang bakaalin tunum iso, nikil iyo tam bot tem tiiniwa, Yesus ayo bokoya-lomda: Tilipla, nikil kulawa kela bot tem liip yak ok kumun dukum kaami malii kaptam unum o yakala, fan nikil iyo tam bot tem abalip unip. ");
INSERT INTO tif_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nikil iyo un-bomdiwa, Yesus ayo akan-unale, nikil iyo yakyak umbiyak ok daang iip-iip kawu unipla, inim aalap dukum ma amdu lo kawu taldaak ok daang diim aba-lomda, ok ayo langdu kulaala tiltam bot tem un-ilomdu, nikil anu-lon o, kemule, ");
INSERT INTO tif_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","kulaali iyo Yesus ayo dap-kafangale, bokolip: Numi Kamokim kapyo, nikil nuli mepso ti taanum o kalup kemin, baan tam tiinan o! Kala-lomdip dap-kafang-niple, kulaali tam tiin tola inim so, wok lang binala tiltam tele bokobu so, ayo bokola ko: Mep inim so, wok so, kunuubip kulaa, ditang kalin o! yaka-kem-salale, inim dulul so, wok so, iyo ditang kala dinimnip. ");
INSERT INTO tif_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Duluma kem-siliple, kulaali Yesus ayo almi daang bakaalin tunum imi kanum bokoyila ko: Kibi nitamiwa yi, Kamokim ali nuso bombe kaali nuyo yaap o nimbip disa ema? Kanimin o kalalipla, inim so, ok so, kiimi atul uyo suunbip i? kalala kanum bokoyilale, kulu nikil iyo Yesus ami atam suun-daa-lom aket alik tam baneyilula, aket yaapkan fukun una-tala-ke-bam ale, bokolip ko: Tunum kalawaami weng boko-lomda, inim so, ok so, dukum-kup bokoyala, yakal ami weng-kup weng san-ilomdip, balit-kala-lom dulumnip kemin, tunum kalawaata dok kanolin tunum i? ke-bamdip nikil kanum bakamip ko. ");
INSERT INTO tif_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kulu Yesus nikil iyo Provins Galili ayo kambola bot tem liip nikil yakyak biyak ok kumun ami malii Gerasa kayaak imi bokon ayo yak aba-somdiwa, ");
INSERT INTO tif_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","kulaa, Yesus ayo bot tem kaptam kela daak ok balang diim tola kemale, abip kaptam kayaak tunum ma sinik mafak ta dap-mafak-daasip ayo Yesus ami fanang talale, siin sawaalak kaptoop ali tunum kaali, ilim mikimin disa; ale ali am sin-yaamin disa; kemin, kanola ayo din kom tem kawu, sin tal-unen-umba. ");
INSERT INTO tif_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kemin, siin kaali, sinik mafak ta taba-lomda mep tunum kaa dap-mafak-daa-sala, aptum kusal iyo misii kuno kelupla yemama no, kala-lomdipla, sen ta kuluu tunum ayo sikil ang yaan ang iyo sok dela-lom, dap-tiilup o, kala tiin mo iliwa; kwin! sikil-ang yaan-ang de dubip ayo ukela dabaala una-tala-kelule, sinik mafak ta tunum kaa faldang mo dabaala bilin tunum dinim bokon aba aba ke-bamda, suunkup ti kanun-umba. Kemin, tunum ayo Yesus ami atam-ilomda, tal Yesus ami miit tem tal kabaaku mat asiik kulii daak tawaal diim aba dukum-kup ola-tabamnale, tunum ayo Yesus asiik sinik mafak ami bokola-lomda: Kabi tunum kaali, kela unan o, akale, sinik mafak ta atin dukum-kup naan-bamda bokola ko: Yesus kabi Atin Win Tabin God ami Man alik-daap kemin, kabi tal-ilomdap dok nop-non o, kalalapla, talbap i? Kabi nami olen-daap-na-lomdap, nami angtiil yol dukum kaa kukaap-nin disa; kambop-nan o, aka ko. ");
INSERT INTO tif_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kulaa, Yesus ayo dik-daala-lomda: Kapni win kaali, bokop-na taman, akale mep tunum kaa utama yi, Sinik mafak yaapkan kii nami iipyak tem kaldaaku tiinaasip kala, kalba-kup, bokola ko: Nami win kaali, Yaapkan Yaapkan o, kala kanum bokolala, ");
INSERT INTO tif_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","sinik mafak iyo Yesus ami dukum-kup naan-bamdip bokolip ko: Kabi nuli fotabam-napla, umbilup umbilaak tawaal tem abip mafak kabaak-ali unemin disa kayi! akip ko. ");
INSERT INTO tif_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akiwale, kang atin ti yaapkan kiili, yak amdu tikiin ami mepso kawu bomdip bak-fakabip. Kemin, sinik mafak iyo Yesus ami dukum-kup nen-bam bokola-lomdip: Kabi nuli, kuno kamboyap yak kang kuliimi tiling tem unum aa! akiple, Yesus ayo bokola: Ayo, yakale, ");
INSERT INTO tif_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","kulaa, sinik mafak iyo tunum kulaa kela-lomdip, iyo abiltap-siik tunum ayo kambola-lom, yang kang imi tiling tem uniwa, kulu kang-miin namti fanang mak-maak-uuyila abiltap bina dilila diim dap-kuldaak-mo yak aba umbilaak ok Galili Kumun tem un-ilomdip yan dong dokola taanip ko ");
INSERT INTO tif_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kemin, kang tiin molin tunum yakal kii itamiwa yi, Kang iyo kano-lomdip taanip kala, kala-somdipla, ukatamalip bina bilin abip unang tunum imi bakayin-bam ale, yang ima lang bom-bilip imi yang bakaya-tal-une-bilipla, ");
INSERT INTO tif_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","unang tunum iyo din-ilom kanola kaa din atamum i! kala-lomdip iyo tal ulipla, Sinik mafak ayo tunum kulaa kela yak-banipla, kulaali ayo ilim mikile, ami aket ayo akal tambal ma keluya, tildang Yesus ami miit tem kulu tiinba kala, kalaliwa iyo suunip ko. ");
INSERT INTO tif_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Unang tunum iyo Yesus ami kukup kanola atamip kaata, aptum kusal iyo bakayim-bam ale, tunum kaami sinik mafak ta dap-mafak-daasipla, Yesus ata dap-talalulala tambalna no, kalalip bakan-una-tala-ke-bilipla, ");
INSERT INTO tif_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasa kasel unang tunum iyo atin ti suun-daa-lom Yesus ami bokola-lomdip: Kabi nuli keya unan o! akipla, fan Yesus ayo imi weng kaata-kup, weng sandala, asuk tam bot tem tiin-ilomda, unum o kalale, ");
INSERT INTO tif_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","tunum sinik mafak kano kelip ayo, tal Yesus ami dukum-kup dik-daala-lomda: Nali kapso unum o, akale, Yesus ayo bokola: E, daa. Kabi asuk din kaltapni abip aba-lomdap, God ami mafek mafek sakbaalim dukum ma kanop-tamba kaali, ku-fatap-daka-bamdap unang tunum alik iyo bakayan aa! aka-lomda, mep tunum ayo dabaala din almi abip kasel imi bokoya-lomda: Yesus ata mafek mafek dukum ma talalu-namuba no, yakan-kan-tal-unema ko. ");
INSERT INTO tif_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kanolaya, unang tunum iyo Yesus ami fen-bom-bilipla, ayo asuk tal Ok Galili Kumun yak malii kawu talala, unang tunum iyo fiyaap duu-bam ale, weng umkaansip o. ");
INSERT INTO tif_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Abip kaptam kayaak tunum ma ami win kaali, Jairus. Kemin ale, ami abip kaptam-ami lotu am kaptam-ami tiin molin tunum kemin, ali tal Yesus almi mepso kulu tilik duung fakela daak tiinba-kup, dukum-kup Yesus ami dik-daala-lomda: Nali atin unang man maakup ulufin kemin, umi wasital kaali, talangkal duk-duule kulu, uyo mafak umu-lomdu atin ti kulaata mepso taanon e kalbu kemin, talawa alep din nalmi am kawu bombuu kemin, din dong dokowan o, akala, fan Yesus ayo Jairus so alep unip. Kemin, Yesus ayo umbabalala, unang tunum yaapkan iyo Yesus kaa falala dap iip kabaak-daaliwa, un-bomdipla, ");
INSERT INTO tif_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","mep kiimi iipyak tem kabak daa-lom unabip kaa unang ma bombuu kuuli, suunkup ulmi am unemin-kup kem-laabu; uli dokta yaapkan iyo saan-bulula, dong dakawa-laabip. Lale, kanola tunum ma kaata taba-lomda umi mafak-alin ayo um-talaluma disa ke-bilipla, bombii wasital ulmi-kup talangkal dakan-tiisula kulaali, ");
INSERT INTO tif_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","unang tunum yaapkan iyo yam kayak kayak kem tal aba biyak Yesus mepso almi daang tem kulu tola aket fukunu yi, Ti Yesus maakup ata-kup nali dong dokop-nokoma kala, kalale, kulaa sikil kuyak Yesus almi ilim matum diim ayo malelule, kulaali maak fak-daalin tap umi mafak-alin uyo dinim kelula, kulaata utamula yi, Nalmi am unemin-kup ken-unbi kaali, disa kep-nulu kala, kemu ko. ");
INSERT INTO tif_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kemule, Yesus ayo bokola ko: Kaa kawanta tal malep-na ni? kemale, alik tal falala duubip iyo bokolip: Nali disa disa kemiple, Pita ayo bokola-lomda: Kamokim aa, unang tunum yaapkan iyo tal-ilomdip, iipyak tem daa tam-bak-mobip kaa kanimin o, kalalapla, kaa kanum bokolap yoko? aka kemale, ");
INSERT INTO tif_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","kulaa Yesus ayo bokola: Alik ili disa; kemin ale, nali utamila, Nalmi titil kuuta malo ma imi dong dokoyu no, kali kemin, nakal utamila, Atin maakup ma ta kanoliya dong dokop-nak i! kalalaya, tildak malep-nala, nami titil ta dong dokolu kala kali no, kala kanum bakamala, ");
INSERT INTO tif_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","unang ukol utamula, Maaklo kasentap sawaanami disa, Yesus ali ti fatap nitama kala kala-somdula, kulaali suun-daa walwaal-kup taptap tildang Yesus almi miit tem kuluwu tilik duung fakela tildaak tiinbu-kup, unang tunum imi tiin diim kulu bokolu ko: Nali nalmi am-kup unem-laabi kemin, nalmi sikil kulaata yak malep-tilila, kapni titil kulaata abiltap-siik, nayo talalu-namulala yaapni no, kemula, ");
INSERT INTO tif_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus ayo bokowa-lomda: Nafalop kupyo, kubi aket fukunawa, Kulaata nam-talulokoma no, kala-lomdapla, kanolap tam-talaluli kemin, ti kupni aket tem kaa balili-kala-lom tambal-kup dindap tiin bom-balapla yo, waka ko. ");
INSERT INTO tif_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus ayo ti unang kuumi weng ayo baka-um-bam ilale, kulaa Jairus ami am kaptam-ami ok fukulin tunum ma tal Jairus ami bokola-lomda: Kapyo, kapni man unang kuluuli, taanu utamdi tili kemin, kabi God ami weng kukuyin tunum kaali, disa iip kawu dibii-talemin dinim o, akale, ");
INSERT INTO tif_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesus ayo weng san-ilomda, Jairus ami bokola: Kabi suunin disa kela, Ali ti yaap kanolokoma no! nakapla, kapni man uyo asuk tam tiip-tuk o aka. ");
INSERT INTO tif_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kemin, Yesus ayo din kamokim ami am mepso din abale, unang tunum aso tilip iyo bokoya ko: Ibi naso tam am kaptam-ali tam unemin daa yo, yakale, Pita so, Jon so, Jems nikil isole, man umi awak-aalap iso, ita-kup Yesus ayo yim-baala tam kamokim ami am kaptam unipla, ");
INSERT INTO tif_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","unang tunum ita abip kaldaak bomdip dukum-kup amamipla, Yesus ayo bokoya ko: Kiwe, amamin disa yo; man kuuli taanbu disa; uli akan-unbu te! kemale, ");
INSERT INTO tif_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","alik iyo utamipla, Unang man kuuli, atin taanu utabip kemin, ali kasen-fakayinba no, kal-bomdip aban kulil-teliwa, ");
INSERT INTO tif_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesus ayo kamboya tam am abale, man unang umi sikil kaali, fukuba-kup bokowa ko: Man unang kubi tam tiinan aa! uka kem-salale, ");
INSERT INTO tif_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","man umi sinik ayo asuk tal tiip-nula, kulaa unang man uyo abiltap tam tiinule, Yesus ayo unang man umi awak-aalap imi bokoya-lomda: Inin-inin ma man unang kuluuli kuuwip inamnuk o, yakale ");
INSERT INTO tif_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","man unang umi awak-aalap imi fanang uyo alik tam baneyilula, fiyaap duumip. Katale, Yesus ayo dukum-kup bokoya ko: Alep ibi din unang maakup tunum maakup kiili, bakayin dinim o, yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus ayo daang bakaalin tunum talangkal iyo weng umuuya alik tal mepso kulu tiliple, almi titil ayo kuyale, bokoya-lomda: Nami win diim kaata-kup sinik mafak alik iyo fotabe-bam ale, tunum unang mafak umusip akal-alik akal-alik kuluusip kiili, takan-tiiyim-bam kem-tal-unemin o, yaka-lomda, ");
INSERT INTO tif_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","asuk bokoya ko: Ibi din unang tunum iyo bokoya-lomdip: Ibi God ami lak kaali, dukum-kup duu-lomdipla tiltam God ami miit tem tilin o, yakan-kan tal-une-bam ale, aa, unang tunum mafak umusip iyo yam-talal kaa-bam kem yakyak tal-unemin o. ");
INSERT INTO tif_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kemin, unokomip kaali, bung ayo ma kulii-unemin disa; malal aye, ima men moni aa, iyo ma kulii-unemin disa. Ti disa; tunum tiil-kup unin o. Ti ilim maakup ata-kup mikile, unin o. Unang tunum kii dong dokoyipla, kuno isiik dong dokoyum o, kala-lomdip kaa isiik kipni mafek mafek kiili, kuyokomip kayi! ");
INSERT INTO tif_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ibi um-bi-lom umbilin abip ma din unipla, kaali ti am maakup ma kaptamu kup tiin-bom unang tunum iyo dong dakaayinbile, keya unemalip kayi! ");
INSERT INTO tif_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Katale, abip kasel iyo im-tam daa ibi tiin molin dinim kelip namti, Juda numi kukup ma kaata, kuluu-lomdipla, abip kaptam ayo kambola unolip ko. Nulmi kukup kaali, sung ilol tal aba yak kipni yaan diim tabuuba uyo diliit-mo kulaalip yak abip kasel imi lo kabamnala kawu, abip kaptam-ami unang tunum iyo utamiwa yi, Asuk ilom kaa maso ma tal abip kaltam nuli dong dokoyokomip dinim o, kalin o, kala Yesus ayo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kala-lomda, Yesus ayo daang bakaalin tunum talangkal iyo yim-baala din abip ma ma kawu, God ami weng tambal uyo kulii-bom bakayila-tal-une-bam ale, unang tunum mafak-alin umkaan-unsip iyo yam-talal kaa-bam kem-tal-unemsip o. ");
INSERT INTO tif_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kemin, unang tunum iyo Yesus ami sang kaayo, bakan-una-tala-ke-bam ale, malo ma ita bokolip: Kaali oksam ukayin tunum Jon ata asuk tam tiin kawang keba no, ke-biliple, kuno malo ma ita bokolip: Daa; kaali tunum sawaayak bom-biisa Elaija ata kulu tiltam talba no, ke-balale, unang tunum malo ma ita boko-lomdip: Kulaaye, kaa sawaalak profet God ami weng ku-fatap-daa bakayin tunum ma taansa kemin, ata nema, asuk tam tiinba no? ke-bala kemiple, kulaali Herot ali Provins Galili kaptam-ami kamokim king kesa. Kemin, unang tunum iyo Yesus ami sang ayo baka-bilipla kawu, Herot ami aptum kusal iyo weng san-ilom, tal bokolipla, Herot akal aket dukum ayo fukunsile bokola ko: ");
INSERT INTO tif_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sawaalak kaali, nami okok kemin tunum iyo yim-baali din-ilomdip, Jon ami dabom kaa ti bak-duu aasip. Kemin, ali dok kanolin kaami sang kaata, weng seli ni? kal-bomda baan Yesus kaa atamon o! kema ko. ");
INSERT INTO tif_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kulaa, Yesus ami kalaan tunum iyo asuk tal-ilomdip Yesus ayo bokolip: Kapyo, mafek mafek ok alik kiili, nolup tulup o, akipla, Yesus almi kalaan tunum ita-kup yim-biila, unang tunum iyo kamboya, umbilin abip ma Betsaida unip. ");
INSERT INTO tif_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Unang tunum iyo weng seliwa yi, Yesus ayo abip Betsaida una no, kalalip kulaali, unang tunum iyo dak-daa kulii yak aba din atamipla, Yesus ayo weng umkaayin-bam, fiyaap duu-bamda bokola: Ibi atin ti God ami lak uyo duuliwa kawu, tiltam God almi miit tem tilin o, yakan-kaa-bam ale, unang tunum mafak-alin kuluusip yaapkan iyo yam-talal kaa-bam kema ko. ");
INSERT INTO tif_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kemin, kanu-bam bom bii am tiinule, Yesus ami daang bakaalin tunum talangkal iyo tal Yesus ami bokola-lomdip: Kapyo, bokon kala bom-bulup kalawaali, unang tunum dinim bokon kalawu bom-bulup kemin, kabi unang tunum kalawiili yim-baalap din abip ma din abip ma kawu, din ima waan ma fen-daa ina-lomdipla, kawu siik o! akan-kaamiple, ");
INSERT INTO tif_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","kulaa Yesus asiik bokola: Nikil kipkal inin-inin ma kuyilipla yo! yakale, tunum ilmi-kup faiv tausin (5,000) ema iyo bom-bilip. Kemin, Yesus ami daang bakaalin tunum iyo Yesus ami bokolip ko: Nuli ima yaapkan dinim; la bret awakal ale, kuno aniing alep ma kiita-kup bom-bilip kemin, kuliili tiknamip disa; kanolin kemin, ti kabi yim-baalap din kayak kayak kii dik-daayupla, ima ayo maso ma kuyip mo kuliilup taldupla, unang tunum alik kula tiinaabip iyo ifalup ina-lom solip eliye disa ye? akiwale, Yesus ami daang bakaalin tunum imi bokoyila-lomda: Unang tunum iyo bokoyilipla: Afetbi 50 e kala tiina tiina ke-lomdip tiinin o, yikiwa yo, yakale, ");
INSERT INTO tif_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesus ami daang bakaalin tunum iyo unang tunum imi bokoya-lomdip: Kanola tiinin o, yikiwa, alik iyo kanola tiinip. ");
INSERT INTO tif_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesus ayo bret awakal ale, aniing alep ma iyo foko-lomda titam abiil daa, God ami yaap ke yo, anba-kup, bret so, aniing so, iyo bakela kutii-lomda almi daang bakaalin imi kuyala ita unang tunum imi banuyipla, ");
INSERT INTO tif_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","alik iyo kuluu inbi-lom tiknipla kawu, Yesus almi daang bakaalin tunum iyo yak ima tinan-bamdip, kutiibip daam daam kiiyo, fakan-tal-unemsi basket almi-kup tal aba tam talangkal kiita, abuu-bilip dongnip ko. ");
INSERT INTO tif_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kemin, am ma daanule, Yesus ayo alafin bomda beten ke-balala, almi daang bakaalin tunum iyo bital tiliwa, ayo dik-daaya-lomda: Unang tunum kiili boko-lom: Kaali kawanta ni? nakan-kaabip, kalala, imi dik-daayale, ");
INSERT INTO tif_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","daang bakaalin tunum isiik Yesus ami weng maan tela-lom bokolip ko: Aa, unang tunum malo ma iyo boko-lom: Kaali, oksam ukayin tunum, Jon Baptis ata no, ke-biliple, malo ma ita boko-lomdip: Yi, kaali God ami weng ku-fatap-dakamin tunum sawaayak biisa Elaija ata no, takan-kaa-biliple, malo ma ita bokop-ta-lomdip: Kaali siin sawaalak God ami weng ku-fatap-dakamin tunum ma saaksa. La, asuk tam tiinba no, tambip o, kem-una-tala-kemiple, ");
INSERT INTO tif_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesus ayo bokola: Aa, ibi yi? Ibi nali kawanta no, nakan-kaabip i? yaka kemale, Pita ata Yesus ami weng uyo maan tela bokola-lomda: Kabi fan ti God Almi Man uldaa-tam-buusa Kraist namti kulu-balap ale, God ami dabaali din unokoma no, kal-bomda Israel-miin numi bokoyila fen-tabasup tunum namti kulu balap o, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita ayo kanum bokolale, Yesus ayo titil tibin weng uyo almi daang bakaalin tunum imi dil mole bokoya-lomda: Nami weng kala bokoyokomi kaali, din-ilomdip yen-tal-une-bamdip: Yi, Yesus kaali, God almi Man uldaa-dabuusa tunum o, kalalip kaata ke-bamdip bakayila-tal-unemin disa yo! ");
INSERT INTO tif_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ilom am ma daanokoma kawu, Dukum Ami Man Nali, kukup mafak yaapkan angtiil yol kukaap-nokomip. Ale, Juda imi kamok kamok so, awem tunum o kala pris imi kamok kamok so, lo utamsip tunum iso, ili daang ukup-na nitam suun-bamdipla, iyo nam-baalip yak nulmi waasi Rom kayaak imi sikil diim abamnila, ita nelip saaka bombii am alep keliya, tam am asuum diim kulu God ayo nam-fola asuk tam tiinokomi no, yimba-kup, ");
INSERT INTO tif_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","asuk unang tunum alik iyo bokoya-lomda: Dok nolin tunum kapta, naso din nami okok kemin kaata, okok kemon o, kalap namti, am maakup maakup yak kaltapni aket fukunin kaata-kup kanumin kaali, kambola-lomdap nami aket kaata, dukum-kup kup-na-lomdap, nami as diim angtiil yol kuluulokomi ultap ke-lom taanami kulaali, kunola taanami no, kal-bomdap, kanolin kukup kaata kuluu-lom, tiltamdap nami okok kemin kaali, kutal-fuku kulii-taba balapla yo! kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kanolin kemin, tunum iyo kawanta ma almi angtiil lak kaata, suunkup aket kuwa-bom, almi aket fukunin kaata-kup kanum tal-unemon o, kema namti, kaata taan-ilomda maaklo ke-lokoma; kemin ale, tunum ayo kawanta, kuno yang kunu-bili waasi iyo taba-lomdip nelamip kulaa, kuno nelamip o, kala-lomda tildang nami lak kaata-kup dukum-kup kutal-fuku kulii-taba namti, kanolin tunum kaata ti suunkup ilokoma. ");
INSERT INTO tif_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kuno tunum ma tawaal kala dik-daa kulaasu kalawaami mafek mafek alik kiita ti kaa-bam ilomda saaknala, ami sinik ayo maaklo kela namti, almi mafek mafek kiita taba-lomdip dong dokolokomip ema? Disa te! Kabak dok kano-lomdip dong dokolokomip disa. ");
INSERT INTO tif_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tunum kanta ma nami win ayo kufup-nin dinim ke-bamale, kayak kayak kiimi itam suun-daa nami weng ayo bakayin disa kema namti, am ma daanokoma kaali, Dukum Ami Man Nayo, nalmi falala-kalin so, Aatumen God ami falala-kalin so, ensel atin tambal-kup tabasip imi falala-kalin kiiso, kiimi diim kawu talokomi kaa, nasiik tunum kaami win ayo kufolokomi disa ale disa. Ali ti disa kayi! aka-lomdi ali dap-kan-tiilokomi. ");
INSERT INTO tif_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kemin, mep tituun weng kala bokoyokomi uyo, dotu weng san iliwa! Iip maakup maakup kula tola-bilip, ibi saaknin disa, bom ilom utamiwa yi, Ali tiltam king ke-lomda unang tunum iyo tiin mola kala kalokomi kayi! kal-bomda Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus ayo kanum bakayinbi disa kelule, kulaa keya bom-bala bii am oklungkal kelale, kulu Yesus ayo God ami beten kamaalon o kalale, kulaa Pita so, Jon so, Jems so, ita-kup nikil foko im-tama umbitam amdu tikiin ma tam un-ilomdipla, ");
INSERT INTO tif_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesus ayo beten ke-balale, daang bakaalin tunum iyo atamiwa yi, Ami tiin matum ayo akal alik kelala, ami ilim ayo namaal alik ke-lomdu tiin angkaal so kelu kala, kalip. ");
INSERT INTO tif_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kulaa, maak fak-daalin tap, tunum alep ma iyo God ami falala-kalin so tiltam Yesus almi diim kulu tolniple, Yesus so weng bakamipla, ma ata sawaalak God ami weng ku-fatap-daa bakayinbi saaksa Moses sole, ma ata Elaija so, alep ita Yesus ami kanum yakyak kulii-din Jerusalam kawu taanala, God ami, Kaa kanuman o, akase kaali, disa kelu ke-lokoma kaami sang kaata, bakalip. ");
INSERT INTO tif_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita nikil iyo tiin yak keyu atin akan-unip. Lale, asuk kulaa kela tiin baa talaalipla, Yesus ayo atin ti falala-kup kala-lom tolnale, tunum alep ma tal tola kelipla itamiple, ");
INSERT INTO tif_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pita akal utamala: Moses so, Elaija so, kii mepso Yesus kaa kela unum o kalbip kaa kalale, yak kanolip kabak-ami miit kaa talalu utamin disa ke-lom ali atin babon daa-lomda Yesus ami bokola-lomda: Kamokim kapyo, ti yaap ke kapso tal bom-bulup kemin, nuli am kiin-laap asuumano aye ma ema de-lomduwa, ma kaata kaltapni, ma kaata Moses ami, ma kaata Elaija ami, kela deluwa yo, kema ko. ");
INSERT INTO tif_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kemin, Pita ayo kanum bakayim-balale, tam ibin uyo tildaak tilnong mo-imaalule, kulaali Yesus ami daang bakaalin tunum asuumano iyo suuniple, ");
INSERT INTO tif_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ibin tem kaptamu weng ma boko-lomda: Kaali ti Nalmi Man uldaa-dabuusi namti kulube, kemin ale, ibi ami weng bakama uyo ti weng san-kaa-bamdiwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kemin, kulaata weng kulu bakaba ayo disa ke kem-sulule, ibin ta tal tunum alep iyo im-tama unula, Pita nikil iyo talaalipla, Yesus alafin kela kala, kaliwale, Yesus ami tawaal diim bom ilsa kaa, Yesus ami daang bakaalin tunum ili ilmi amdu tikiin kawu mafek mafek kanum tulula utabip kaami sang kaayo, unang tunum kii ma bokoyilalip dinim ke-lom yawaal daalip. ");
INSERT INTO tif_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kulaa, Yesus aso, almi daang bakaalin tunum asuumano iso, nikil iyo amdu tikiin kawu silip sintam kutim malang tem amdu ayo kulaa kela tildaak ulipla, Unang tunum yaapkan iyo Yesus ami liip tal-bomdip, liip fen-talabip kala, kalalip itamiple, ");
INSERT INTO tif_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","tunum ma unang tunum yaapkan imi tem kulaaku ma naan-bamda bokola-lomda: Kukuyin tunum kapyo, nami man tunum kuluwaayo, ali atin ti yaan maak alafin kemin, sinik mafak ta taba-lomda dukum-kup yikik dap-tal-fuku-balala, man ayo abiltap-siik naak-fakan-taba atamuple, mook daban-kup baktam-baktam-bamda sinik mafak ta dap-mafak-daalu saaka bombii tam tiin-tiin-kem-yaaba. Kemin, sinik mafak kaalile, abiltap-siik kela yak banen-umba disa. Kemin, kabi atam-ilomdapla, dukum-kup dong dokolan o. ");
INSERT INTO tif_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kemin, nali kapni daang bakaalin tunum imi dik-dakaayin-bam bakayin-bamdi: Kipta sinik mafak kulaa fotabamnip yak banak o, yakan-kaabi. Katale, faneng, titil-foko fotabamnip yak banoma dinim kelip o kala-lomda Yesus ami kanum bakaan-balala, ");
INSERT INTO tif_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus ayo alami daang bakaalin tunum sole, unang tunum bom-bilip iyo bokoya-lomda: Kwin! Ipni aket fukunin kaali, fan atin tituun disa kawi! Nali kipso bom bii, kayoop yaapkan dak-duusi. Kata, ibi nitamiwa yi, Kaali God ami titil kaata kuluu-lomda sinik mafak iyo fotabeba yak banen-umbip kala, naka-laabip disa yo. Nali ipso bii, am kanim kal kelila, ibi natamiwa yi, Ali ti God ami titil kaali, nokol ti kuyama no, nokokomip i? Nali ipni aket mafak fukunbip kaali, daal tabep-nu no, kala-lomda fal-siki taba man ami aalap ayo bokola-lomda: Yak kapni man kaayo dibii-tal taman! aka ko. ");
INSERT INTO tif_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Akale, man tunum ayo almi aalap so alim tal Yesus almi mepso kulu tola bom-biliwa, sinik mafak ayo taba-lomda tunum man ayo dukum-kup an-binala daak tawaal diim abamnala, dukum-kup dabuu dap-kula-saan bii kambolale, kulu Yesus ayo sinik mafak ami mafakso no akan-kaa-bam bokola ko: Sinik mafak kabi yak banan aa! aka kem-salale, man ayo kela yak banala, Yesus ayo yak tunum ayo talalu-lomda asuk almi aalap ami kola. ");
INSERT INTO tif_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kemin, kanolala unang tunum iyo utamiwa yi, God ami titil dukum kaata Yesus ami kolala, kaa kanola kala, kalalipla, aket yaapkan fukun-una-tala kemip ko. Unang tunum ili Yesus ami titil kabak kanola kaami aket uyo aket dukum fukun-bilipla, Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ibi nami weng kalawuuli, talalu weng san-ilomdip lukuuya-yaamin disa. Ti mepso kulu nami nak-tunum ma ayo aket fal-siki-lom Dukum Ami Man Nayo, nam-fatap-daa-lomda nam-baala yak waasi imi sikil diim abokomi no, kala kanum bokoyila. ");
INSERT INTO tif_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Katale, ami daang bakaalin tunum ili, ami weng kaa bakayinba kabak-ali talalu bam-daa utamin disa kelip, kabak-alile, God ali weng kabak-ami miit ayo kuwaalaya kemin, talalu utamin disa keliwa, mafek mafek tiltam tabokomu kaami atul kaata, utam suun-daa-lomdipla, Yesus kaa dik-daalin dinim kelip ko. ");
INSERT INTO tif_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kamboliwa, Yesus ami daang bakaalin tunum nikil iyo weng aal diki-bamdip boko una-tala-ke-bam ale, bokoya-lomda: Kaa kawanta nulmi iipyak tem kaltam bombe ata, tiltam kamokim ke-lokoma ni? kal-bomdip kanum una-tala-kemiple, ");
INSERT INTO tif_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Yesus akal utama yi, Iyo yak kanolin aket kaali, fukunbip kala, kalba-kup, man katip ma ami naan-daala tal Yesus almi bombe kawu tal tolnale, Yesus ayo almi daang bakaalin tunum iyo bokoya-lomda: Nami tiin diim kaali, man katip kalanolin kalawaali sakbaalim dukum kala kalbi. Kemin ale, kawanta ma man katip kalawaltap kalaali, nami win diim kaata dong dokola namti, kaa nimi dong dakaap-nin ali kaa bombe te! Ale, God ali nam-baala talsii kaa, kawanta nami dong dakaap-na namti, kaali God ami dong dakaalin tunum namti kaa bombe no. Kemin, kawanta fanang daalaya, Nali ami minlo tem unsi tunum u, kala namti, kaata fan God ami tiin diim kawu, atin ti dukum ke-lokoma no, yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kala kanum bokoyilale, Jon ayo Yesus ami bokola-lomda: Nikil nuli tunum ma atamupla, Ali kapni win kaata, kufo-lomda sinik mafak iyo fotabamna yak bane-bilip kawu, nuli atamupla, Ali kapni daang bakaalin tunum kelin dinim bomda kanolin kaali, kanuba kala, kala-lom bokola-lomdup: Kapni disa kawu Yesus ami win kufon-bam kanubap kaali kambolan o, kala dil molup o, akiple, ");
INSERT INTO tif_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus asiik Jon so, almi aptum kusal iso, iyo bokoya-lomda: Dok kanolin tunum kaata, kipni waasi keyin disa kela namti, kulaali iltipni kayaak alaltap kemin, ibi kaa kulaalan o akan-kaamin disa yo, kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God ami Yesus dibii tam abiil tikiin unokoma kaami am kaali, mepso tulula kemin, Yesus ayo fuku-daala yi, Kulaata atin ti Jerusalam unon o, kalale, almi daang bakaalin tunum iso nikil ");
INSERT INTO tif_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","alimal um-bom ale, Yesus ayo daang bakaalin tunum malo ma isiik yim-baala dusiin daalip, nikil yakyak bilin Provins Sameria kaami abip ma kaptamu boko-lomdip: Yesus ayo talaba kemin, am sokoma ayo ma dotola kem-sulupla, talak o, kalip. Katale, ");
INSERT INTO tif_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sameria kayaak kiili, utamipla, Yesus ayo tal sindala, Juda numi waasi kiimi abip dukum Jerusalam unon o kala, talaba kala kalaliwa, Kulaali, kala talemin disa yo, kala weng binalip din ileliwa, Yesus ayo kuno kelale, ");
INSERT INTO tif_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ami daang bakaalin tunum Jon so, Jems so, nikil iyo weng sandiwa, Yesus ami tal bokola-lomdip: Kamokim kapyo, nuli God ami naan-daaluwa, wing mol lapnin ma fokola tildaak aba-lomdip abip kasel kutamali fuula kiin-abamnik o, kalbup te! Kemin, kapni aket fukunin kaata, bokoyilapla utamum o, akiwa, ");
INSERT INTO tif_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesus ayo fal-siki alep iyo weng dukum-kup bokoya-lomda: Kwin! kukup mafak kaa kanumin disa kawi! yakale ");
INSERT INTO tif_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","abip kaali, kelalip din abip kusnum kaptam banip ko. ");
INSERT INTO tif_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kemin, Jerusalam unum o, kalalip nikil una-bilipla, tunum ma tal Yesus ami bokola-lomda: Kabi dok kanolin kawu tal-unemap kaa, nali ti kapso naso maakup tal-une-mokomup o, akale, ");
INSERT INTO tif_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus asiik bokola-lomda: Sinokim ali tawaal tem kabaaku tem kalabi kuu-tiile, iim de sin-laabala le, awon yakal kuno ilmi iim tem kawu sin-yaa-bala, ken-umbip. Lale, Dukum Ami Man Natale, sin-yaamin am kaa disa; ti kapkal talalu aket fuku-daalan aa! Kabi ti kanola naso tal-unemon o, kebap ema? akala ");
INSERT INTO tif_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesus ayo tunum ma ami bokola-lomda: Kabi nami fanang tal-ilomdap nami daang bakaalin tunum kelan o! akale, tunum ayo bokola: Kamokim kapyo, kamasi kaa kuno kep-napla, asuk din-ilomdila, abip kawu nalmi atok ayo tiin mo-bom ilila, saaknala kawu, dibii-din dawaalila, asuk kapni fanang talokomi kayi! akale, ");
INSERT INTO tif_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesus asiik ami weng maan tela bokola-lomda: Daa yo! Kabi unokomap disa; kulaa kela tildang nami daang bakaalin tunum kelan aa! Tunum kanta nami daang abam-nokomup disa yo, kalbip ilta-kup aptum kusal taanip iyo imbi din ima-laamik. Katale, kabi din unang tunum bokoya-lomdapla, God ami lak duulip tiltam God ami miit tem tiltam-ilomdip suunkup ilin unang tunum kelin o, kala bakayila-tal-uneman aa! kala mep tunum ami kanum bakaalale, ");
INSERT INTO tif_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tunum ma ayo Yesus ami tal bokola-lomda: Nak-tunum kapyo, nali kapni daang bakaalin tunum kelon o, kalbi. Katale, kamasi kaali, nayo kambop-napla, din abip aba ilomdi nalmi awil-fakal iyo itam weng fokoya kawu, tal-ilomdi kapni daang bakaalin tunum kelon o, akale, ");
INSERT INTO tif_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesus asiik bokola-lomda: Tunum ayo ima lang kaa talalu tiin molin disa ke-lokoma kaali, ami man kiili, talalu tiin mo ifa-mokoma dinim; kemin, ultap o. Tunum ali nimi lak ata-kup duuli no, kalala, ayo atuk-atuk-kema namti, God ami weng ayo unang tunum kiili, talalu kukaayokoma disa yo, kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kemin, kaali disa kelule, Kamokim Yesus ami aket fukunin ayo bom bii-somdila, kaata kawu abip ma ma tal-unemon o kala-lomda ayo tunum ilmi-kup 72 kiita ulela-lomda, alep e kala yim-baala abip e kala un-un-kelin disa bom iliple, ");
INSERT INTO tif_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesus ayo weng ma faldak-tii bokoya-lomda: Unang tunum yaapkan kiili, Yesus ami lak duulin disa lale, iyo God ami weng uyo weng san-kaamum o kebip kemin, kiili wiit yakaana-laabu kanolin tap. Lale, wiit dakamin tunum iyo alep-kup kemin, (mep wiit dakamin tunum kuliili, tunum ita God ami weng kulii yang unang tunum imi bakayin ita kemin), ibi God ami beten kamaan-bilipla, alta okok kemin tunum yaapkan iyo ulelale, yim-baala din iltipni diim aba-lomdipla, kipso maakup din unang tunum God ami weng ayo bakayin o! ");
INSERT INTO tif_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kibi yim-baalila unin o. Kanola ibi unokomip kaa, tunum ili saak miyaan apliip imi sipsip man an-fakan-umbip tap ke, tal yam-mafak-daka-mokomip. Kemin ale, ibi kuu talalu utafii-bamdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kipni unokomip kaali, tuumon kii kulii-unemin disa; aa, ima men ayo abuu kulii-unemin disa; yak yaan-alom kusnum aso ma kulii-unemin disa; aa, liip kawu un-bom talaalip unang tunum iyo liip kawu tala-tala duk-duulip kaa, tiin-bom weng bakayin disa; weng-kup umuuya ti abiltap din abip aba nami sang kaata, bakayila-une-bala, tale-bala kelin aa! ");
INSERT INTO tif_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kanola suunkup am une-mokomip kaali, kamasi kaa am kasel iyo weng fokoya bokoya-lomdip: God alta am kaptam kasel ibi tiin mo-balala, kipni fanang dakamin ayo ti balili-kup kala, bom-biliwa yo, kala-somla kemin, ");
INSERT INTO tif_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","am kaptam bombe kaa balili-kalin tunum namti alta bokoya-lomda: Ibi tan ke tilip o, yokokoma kemin, God alalta kukup tambal ma kuyokoma. Katale, ali balili-kalin disa kela namti, tiin so, aket so, kiita-kup, Awu, kaa tilip u, kalale, ali weng umuuyokoma disa. Kemin, God ali kukup tambal kaa, ami kolokoma dinim. ");
INSERT INTO tif_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kemin, ibi abip kaptamu bomdip unang tunum kukuyin-bam ilip kaa, kibi din am kusnum kusnum kaa sin-laamin disa; ti kamasi din am kuluulip kaptamu-kup bomdipla, ima aye, ok aa, saak yak dok kanolin inin-inin kuyip uyo ti saak inin-kup kemalip ko. Kemin ale, ima kukaayin-bilip inokomip kaalile, kipni okok kamayin-biliple, kaami tiim kaata, ima kukaayin-bilip inokomip o. ");
INSERT INTO tif_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Abip unum o, kalalip din itamipla, Ipyo, tan ke tilip o, kalalip iyo yim-bii din dok nolin ima ma ayo kuyip namti, kulaa ti inin-kup o. ");
INSERT INTO tif_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kibi abip kasel unang tunum mafak umkaan-unsip imi yam-talal-bam imi bokoya-lomdip: God ali kipni bokoya-lomda: Kibi tiltam nalmi miit tem tiliwa, tiin molokomi no, kalba kaali, mepso dikipnu no, yakan-kaamiwa kawu, kaal kelik o. ");
INSERT INTO tif_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Din abip ma ayo din itamipla, Abip kaptam ayo tiin aa, fanang aa kiita-kup itamipla, iyo weng umuuyin disa kelip namti, yang abip iip kulu tolale, iltipni kukup kaata-kup, kanola sung ilol tal ipni yaan diim tabuubip kiiyo, diliit mo fokolip yak abip kayaak imi diim uniple, ibi bokoya-lomdip: ");
INSERT INTO tif_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Kipyo, weng san bom ilipla, ti yaap ke tilip o, yokolip disa kelip. Kemin, kiltipni abip ami sung diliit mo binalup din unu kaali, iltipni diim kawu bom-bulu yi; Nuli kamboya unabup kemin, weng katip ma bokoya-somdupla unum o, kalup. Kemin, talalu weng san bom iliwa! Nuli God ami weng kaali, Tiltam nalmi miit tem tiliwa, tiin molokomi no, kalba kaayo, mepso dikipnu kaali, iltipni kuliiya tulup. Katale, ibi weng sanin disa kelip. Kemin, kuno iltipni san o, yakalip, abip kasel kaptam iyo kanum bokoyilalip kamboya unolip kayi! ");
INSERT INTO tif_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kemin, nali abip kasel kaptam-ami sang kaata ma bokoyokomi kemin, sawaalak abip ma bom-biisu umi win kaali Sodom ale, abip kaptam-ami unang tunum imi kukup kaali ti, atin mafak ke-bilipla, God alta taba-lomda abip kaptam ayo ku-mafak-daale, kuno unang tunum iyo yam-mafak-daasa. Kemin ale, God ami am mafiing diim tiltam tabula, Sodom kayaak imi angtiil yol kukaayokoma kulaali, katip so ale, abip kaptam-ami dok kanolin tunum ita God ami weng, weng sanup disa yo, kalalip babon tal-unebip kiimi angtiil yol kukaayokoma kaatale, atin ti sakbaalkan dukum kuluulokomip o, yakale, Yesus ayo tunum ilmi-kup 72 imi weng bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kulaa, Yesus ayo abip alep kaptam-ami unang tunum weng uyo bakayin-bam ale bokola: Korasin kasel so, Betsaida kasel so, kipyo. Kibi iifan mokop soyal o! Nali kukup ukol ulmi kusnum kusnum kiili ti kipni abip alep kaptamu kanumsi. Lale, kipni aket fukunin ayo ma fal-siki-lom ban wakamin kaali ma, kensip disa te! Nali kanolin kukup ukol ulmi kusnum akal alik akal alik miit ma miit ma imi abip Taya so, Saidon so, kaptamu ma kanumsi dinam, abip kasel God ami atamin disa ita atam-somdipla, imi ban wakamin kuuta, aket uluum keyulala ilmi aket uluum kaami kukup kuuta kuluu-lomdipla, yek ayo tuk-duu-lomdip, ilimi angtiil diim ayo kabii-bam ale, ilim kaal mafak balal-tibin kaata, miki-lomdip dinam kaa, aman duluum bi-lomdip ilmi ban wakamin kii kambola-silip. ");
INSERT INTO tif_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kemin, kanola am mafiing diim tiltam tabokomu kaali, kanola God ami angtiil yol dukum kukaayokoma kaa, God ami Taya kasel sole, Saidon kasel so, imi angtiil yol kukaayokoma kuluuli, katip so kemin. Kata, fan kiptale, angtiil yol sakbaalim dukum so, namti kipta kuluulokomip te! ");
INSERT INTO tif_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aa, Kapeneam kasel kipkal, kibi boko-lomdip: Alik nuli ti din God ami abip kawu ilokomup o, kalbip. Katale, kaa fan disa; kibi nami weng kaa, weng san-kaamin disa kesip. Kemin, ibi fokoli daak abip mafak unokomip o, kala Yesus ayo abip asuumano kaptam-ami unang tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kemin, Yesus ayo almi daang bakaalin tunum ilmi bokoya-lomda: Dok kanolin tunum kiita, nami daang bakaalin tunum kapni weng ayo weng san-kaama namti, ayo nami weng, kakal weng san-kaap-nin tunum ali kulu bombe. Kemin, kanta kapni weng kaa weng sanami disa yo! kala namti, kaata fan nami weng kaa, weng sanami dinim o, kalba namti kulu bombe no. Ale, tunum kaa dok kata God nam-baala talsi, nami weng kaa weng sanami disa yo, kalba namti, kulaali God ami weng kaa weng san-kaamin dinim namti kulu bombe no, kal-bomda almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Daang bakaalin tunum 72 imi okok kem yakyak bilip bii disa kelula, asuk tal Yesus atam-ilomdip, fiyaap duumin dukum kaali, duu-bam Yesus ayo bokola-lomdip: Kamokim, kapyo, sinik mafak kiili, kapni win ata-kup baka-bulupla kawu, ili numi weng kaata, weng san-ilomdip tunum iyo baa tukuya unem-solip o, akiwa, ");
INSERT INTO tif_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus asiik bokoya-lomda: Kanu-biliwa kawu, nakal utami yi, Setaan ami titil kaali kabaak ban-ilomda ayo baabaa dabaalin tap ke-lomda kasentap abiil tikiin kawu kutal daak tawaal diim daaba kala, kalasii. ");
INSERT INTO tif_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kemin, ibi weng selin! Nali nami titil kaa kipni kuyasii. Kemin, liip un-bomdipla, inap sole, malepkan so, imi diim kawu yaan ta im-baak molokomip. Lale, kaa yelokomip disa. Kipni titil kaali, nami waasi Tunum Mafakim ami titil kuluuli kabaak banula, kipni titil kaata, uta uta ke-lokomu. Kemin, yak mafek mafek mafak ita ma taba-lomdip, yam-mafak-daalokomip dinim, atin disa. ");
INSERT INTO tif_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kemin, sinik mafak ili kipni weng kaa, weng san kutal-fukulin kala, kalale, ibi fiyaap duubip. Lale, kuluuli katipkan ale, mafek mafek sakbaalim dukum namti kala bombuu: ibi tal God ami miit tem tiliwale, God alalta kipni win kiili, alami Sukon Tem kabaku dola kuyak daayase. Kemin, kabak-ami fiyaap kaata duumalip te! ");
INSERT INTO tif_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kemin, kulaali God ami Sinik Tambal Yesus ami aket tem ilin ayo Yesus ami aket uluum takan telale, Yesus ayo atin fiyaap duumin dukum uyo duu-bamda, almi aalap ami bokola-lomda: Atok kapyo, kabi tawaal diim kaldaak aso, abiil tikiin so, kiili tiin mosap. Kemin, (kapni kukup kaata taba-lom unang tunum imi kukup uyo kabaak banu kewa uta uta kesu. Kemin, yaap ke yo, kebi.) unang tunum maakup maakup iyo aket fuku-daa-lomdip: God ata kukuyin-balala, nuli utamsup disa. Kemin, nulumi aket fukunin kaata, kukuyin-bulula, nokol God ami mafek mafek uyo utamsup o, ken-umbip kala, kalalapla, kabi kapni aket fukunin tambal uyo kelalapla, kiiyo ma utamsip disa. Kemin ale, unang tunum maakup maakup iyo boko-lomdip: God kabi kukuyin-balapla, utamum o, ken-umbip kala, kalalapla, kiita kukuyin-balapla, utabip. Kemin, (kiiyo nimi weng uyo weng san-kaamin-kup, kemum o ken-umbip kemin,) kaayo, Aatumen kabi yaap ke yo, kebi. Kemin, kapkal, kanumin kukup uyo, kaata kanumin o, kalalapla, kapni aket fukunin tambal uyo utamsup disa yo kebip tunum imi kukaayim-bam ale, kukuyin-balapla, kaal ken-umbip o, kala Yesus ayo God ami kanum bakaan-bam bakaala ko. ");
INSERT INTO tif_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Beten keba uyo kulaa kela-somdala, Yesus ayo tunum unang yaapkan imi diim kawu bokoya-lomda: Nami Atok God ali mafek mafek alik iyo kulaap-na tildak nami sikil diim abasip. Kemin, nali almi man alik-daap lale, unang tunum ili ma natam, Awu, kaali fan God almi man tituun o, kalsip dinim; ti Atok God maakup ata-kup ti nali natama. Ultap kemin, dok kanolin tunum ata ma nami Atok ali ma atam, Awu, kanolin tunum u! ma kalsip disa ti; almi Man nata-kup atamsi. Kemin, unang tunum nalta ulela-lomdi, nalmi Atok ami sang uyo kukuyi namti, kiita-kup fan Atok ayo atam ke-lokomip o, kal-bomda bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kanumsile, kulaa fal-siki almi daang bakaalin tunum ilmi-kup bokoya-lomda: Mafek mafek kipni tiin diim namti kulu tiltam tabamnula, utafiin-umbip. Kemin, kipta ti tambal ma God alalta ti mafek mafek kalawiili kukuyimba kemin, fiyaap duulin o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Weng ma bokoyokomi kemin, kipyo weng selin! Siin sawaalak kaa nili tilin dinim bom-bilila kawu, God ami weng ku-fatap-daa bakayin tunum yaapkan iso, king o kala kamok kamok yaapkan iso, ili nami ok kala kanubi kaali, ipni utafiin-umbip kaa, utamum o, kemsip. Lale, kuu utamipla, Tiltam tulu no, kalsip dinim. Ale, nami weng kala kipni bakayinbi kalawuuli kuno ti yakal weng san-kaamum o, kemsip. Lale, ili ma weng san-kaamsip disa kayi! kal-bomda ayo almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lo utamsa tunum ma ayo tola-lom, Yesus kaa dap-kukulila, weng mafak ma yak-boko-tildak-boko kela kala kalon i! kalale, bokola ko: Kukuyin tunum u. Nali dok kano-somdila suunkup tunum ke ilokomi ni? akale, ");
INSERT INTO tif_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus asiik bokola-lomda: God ami weng Sukon Tem sawaalak kawu dolsip kaali, kapkal tik-tiin-umbap kemin ale, kabak kanimin o kalsu ni? akala, ");
INSERT INTO tif_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","lo utamsa tunum ayo bokola: God ami Sukon Tem uyo boko-lomdu: Kabi ti atuk-atuk kemin daa; kapni aket, fanang, tiin, titil, kiili, alik kulaalap yak God Dukum ami diim abu atin ami mok-kup inan-bamdawa yo, kala-somla ko. Kuno kaltapni mok inbap tap ke-somdapla, kaptum ami mok-kup inan-bamdawa yo kala kanum bokosu no, akale, ");
INSERT INTO tif_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","kulaa Yesus asiik bokola-lomda: Kulaa ti fan bokolap. Kemin, kaata kanumap namti, kuuta ti suunkup ilokomap. Kemin, kanu-bamdapla yo, akale ");
INSERT INTO tif_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","lo utamsa tunum ayo, kanum bokolila, unang tunum kayak kayak iyo nitam, Kaali ti tunum tambalim o, nikin o kalala, ayo Yesus ami asuk bokola-lomda: Kaptum ami mok inaalan o, kalsu kaata, kawanami mok inaalin kaata ni? akale, ");
INSERT INTO tif_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus ayo mep tunum kaami weng kaali, maan tela boko-lom kayak kayak imi mok inaayin sang kaata faldak-tiimin weng ma bokola ko: Am ma daanule, Juda tunum ma Jerusalam kela yakyak bilin abip Jeriko unon o kala una-balaya, tunum liip kutii yan kutii keya imi mafek mafek dakaayin tunum iyo, tal dap-tal-fuku an-ku liip kaa daa kela yak ami ilim bung men kiiyo, alik duk-duu kulii-un-bomdip andap liip kutiilip unip saaknin tap kela bom-balala, ");
INSERT INTO tif_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","lotu am tunum awem pris o kebip ayo ma liip kulu kutal-fuku um-bom atam talaalaya, Tunum ma kanoba kala, atama. Katale, kela yang balang liip abala kela unale, ");
INSERT INTO tif_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","kuno Livai tunum lotu am kaptam-ami dong dakaayin tunum ma tal ula, Tunum kaa ti kano bombe kala, kata, kuno ti akal liip balang biki-lom akaala una kelipla, ");
INSERT INTO tif_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Juda imi waasi tunum Sameria ma liip kaami diim tal ulaya, Kwin, fan kalawaali imi waasi Juda tunum ma an-ku liip kala, tii unip taanin ke tiinba kala, kalale, kulaali ayo olen-daalale, ");
INSERT INTO tif_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","kulaa yang mepso kulu dap-tal miki yak marasin abang abamin ok ayo kuluu an-kutii-unbip kaami abang tem ayo abonba-kup, yak abang dinamin ayo kuluu dela ke, tunum ayo dabuu dafo dap-tam yak almi dongki ami daang kun diim tii-lom dap-tamala tii bital fatal imi tal siin-unemin am kawu daa talalu tiin mola se. ");
INSERT INTO tif_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sintam tuumon silva alep ma kuluu-lom am kaptam-ami tiin molin tunum ami kola-lom bokola-lomda: Tunum an-kutiibip kalawaali, kapta tambal-kup tiin molap bom-balala, bii asuk tal-ilomdi, kapni mafek mafek iktu-balap ayo yaap-nokoma kaami maan kaayo, tiip-ton o, kala tabanse no, kala Yesus ayo lo utamsa tunum ami bokola-lomda: ");
INSERT INTO tif_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kapni aket fukunbap kaa, tunum asuumano kii kanta tunum aabip ami aket kolase? akale, ");
INSERT INTO tif_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","kulaa lo utamsa tunum ayo bokola: Yi, tunum olen-daala-lom, dong dokolase ata no, akale, Yesus ayo bokola: Kemin ale, ti kapkal din-ilomdap kaltapni waasi imi aket kaata, kuya-lomdap kanumin kukup kuuta-kup ti kanu-balawa yo! aka ko. ");
INSERT INTO tif_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus so, almi daang bakaalin tunum iso, nikil iyo asuk yak aba bilin abip akal alik ma din itamipla, kulaa unang ma umi win kaali, Mata uta ti yaap ke tilip o, kalalu im-tam am daalule, ");
INSERT INTO tif_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata ulmi neng Maria uyo tal Yesus almi miit tem kulu tiin-bomdu ami weng kaayo, weng san-kaa-bam tiin ilula, ");
INSERT INTO tif_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","kulaa Mata uyo fiit-bamdu, ima ayo dot-bam ale, uyo aket uluum dukum ma kewale, tal Yesus ami bokola-lomdu: Kamokim kapyo! Nami neng kalawuuli kambop-na-bulula, nalakis fiit-bamdi ima fuubi kaa, nitamin disa nobap ema? Baan uyo bokowapla tal dong dokop-nuk aa! akan-kaa-bam bakaalula, ");
INSERT INTO tif_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kamokim asiik bokowa-lomda: Mata, kubi ti mafek mafek yaapkan kiimi aket kaata ti tan-bulula, aket uluum kep-timbu. Katale, ");
INSERT INTO tif_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kubi kukup maakup ma umi aket kaata-kup lukup-tula kuuli, iibap. La, Maria uli utamu yi, Kukup lukup-tu kulaabap kaa, nami weng uyo weng san-kaamin kaata nu, kalalula, kabak-ata nami weng kaa, weng san kuyak aket tem dakabu. Kemin, umi kanolin kukup kaa takan-tii-wokomup dinim o, kalala, Yesus ayo kanum bokowa ko. ");
INSERT INTO tif_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Am ma daanale, Yesus ayo tunum dinim bokon kawu bomda God ami beten kamaan-balala, almi daang bakaalin tunum kiili, aso maakup bom-bilip kemin, ami beten keba ayo disa kelule, kulaa daang bakaalin tunum maakup ma tal Yesus ayo dik-daala-lomda: Kamokim kapyo, beten kemin kukup kaali, nuli dok kano-lomdupla, beten ke-mokomup i? Sawaalak kaali, oksam ukayin tunum Jon ami daang bakaalin tunum ata-kup kukuyin-bam bokoya-lomda, God ami beten kamaalin kukup tambal namti kalabuu no, kal-bomda kukuyinsa ultap ke, kapkal God ami beten kamaalin kaami kukup kaali, kukuyan o, kala bokolale, ");
INSERT INTO tif_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesus ayo bokoya-lomda: God ami beten kamaalin kaali, kalanola bakaalalip ko: Numi Aatumen God kapyo, Nuli kapni win kaa, atin ti tambal kemin kaata, nuli kufop-tum o, kalup kemin, Kabi alik nuli yim-tama tam kapni miit tem daa-lom tiin molokomap kaali, talak o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Am kala daan-bulula ilup kaa, nuli ima kaa kukaayin-balawa, tiika-bomdup, inan una-buluwa yo. ");
INSERT INTO tif_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kayak kayak ita, numi kukup kanuyilip kaa, kukan-tiiyila-yaabup kemin, kanola ti kapkal numi ban wakamin kukal kukan-tiiyin-balawa yo, kala-somla ko. Mafek mafek mafak kaa tiltam numi yam-kukulon o kalbu namti, dukum-kup dong dakaayim-balapla, ban kemin kaa uktayuluk o, kalalip, beten kamaalin kaami kukup kaali, kutal-fuku-bomdiwa yo, yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kemin, Yesus ayo asuk beten kamaalin kaami sang kaali, faldak-tiimin weng kusnum ma boko-lomda: Am malang tini-lom am iip yaknule, tunum ma yak aba din almi aptum am din-ilomda almi aptum ayo dik-daala-lom bokola-lomda: Nak-tunum kapyo, am kamala kutamiip kulawu nalmi naktum ma tal nalmi am kawu sindila unon o, kalala tala. Katale, nali ima dinim o, kalalila tili. Kemin, tam tiin-ilomdap kapta dong dokop-na bret asuumano ma kup-napla, kulii-din daali ayo ina sinda unala, kawu ilom nasiik maan kaa tiip-ton o, akale, ");
INSERT INTO tif_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tunum am kaptam akanba ayo bokola-lomda: Saal kaltam talalu lii-lom alimal akanbup. Kemin, tam tiin-laa-bamdi, man imi tiin yak dakel-yilami kemin, nali tam tiin ima kaa ma kup-tokomi disa; kabi duluum-alomdap baan ti kep-na unan o, akase. Lale, ");
INSERT INTO tif_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","nali kabak-ami sang kaali bokoyon o, kalalila kemin, weng san iliwa! Am kayaakim ali utama yi, Tunum abip tola-bomda bakaba kaa nalmi nak-tunum u, kalalaya, kaata fan tam tiin-somdala, ima ayo kolokoma disa. Ti atamala, tunum abip kaptam tola-bomda naanba, ali suun-daa-yaamin disa; ti naanin-kup kema kala, kala-somdala kawu, akal tam-tiin tam ap-tunum ami weng alik kanu bokoba kaali, maan tela ima kaa kolaya, kuliila unokoma. ");
INSERT INTO tif_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kanolin kemin, nami weng bokoya-lomdi kaata, ibi kanumin o, yokokomi kabak-ata kanu-malip kayi! Kibi dok kanolin mafek mafek kaata ma iibup o, kalip namti, suunkup God ami dik-dakaan-bilipla, ayo kukaayilama ko! Kanola suunkup fen-tal-une-bilipla, God akal dong dokoyilaya utamalip te! Aa, ti saal dok-dok kemin ultap ke, ti suunkup God kaa ti dik-dakaan-bilipla, dong dakaayin-balaya yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kanola ili mafek mafek sang ayo ma God ami dik-daalip namti, akal tunum alik dik-dakaanbip imi kuyokoma le, kuno tunum imi mafek mafek fen-tal-unebip namti, kanola God alta dong dokoyila fen-bam uta-mokomip. Aa, tunum saal dok-dok ke-mokomip kakal ti, saal busuu-yinba-kup, im-taldang almi miit tem ayo daalokoma no! ");
INSERT INTO tif_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Awil-fakal kipyo. Kibi nami weng kalawu weng sanalip ko. Kanola kapni man ayo dik-daap-ta-lomda: Aatumen kabi aniing ma inamnon o, kebi kemin, kup-nokomap e disa ye? kala dik-daala kaali, inap kaata kolokomap ema? Disa te! Ti aniing kaata-kup kolokomap. ");
INSERT INTO tif_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aa, ti asuk dik-daap-ta-lomda: Awon win ma inamnon o kebi kemin, kup-nokomap e disa ye? kala dik-daala kaali, kaa keng mafak malepkan kuuta, kuluu kolokomap ema? Disa te! Ti awon win kuuta-kup, kolokoma no. ");
INSERT INTO tif_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kibi ti ban-kemin tunum-kup bom-bilip. Lale, kibi mafek mafek tambal kii, kaltipni man kii kukaayila-yaabip tap kanola, iltipni Kaalap abiil tikiin kayaak God akal ti tunum kemin, alta mafek mafek tambal iyo almi man kipni kukaaya-laaba; ami kukaayin kukup kaa ti, uta uta kesu. Kemin, kipkal ami dik-daalokomip kaa, akal almi Sinik Tambal ayo dibii-tildaak dong dokoyokoma kayi! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tunum ma sinik mafak ta dap-mafak-daalaya, weng abat kesa. La, Yesus ata sinik mafak ayo fotabamna yak banala kulu, tunum ayo tambal ke-lom asuk weng bakan-tabale, unang tunum iyo atam-ilomdip, fanang alik tam baneyilu. Katale, ");
INSERT INTO tif_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","16","malo ma ili boko-lomdip: Yesus ami diim kawu, sinik mafak imi kamokim Belsebul o kala, Setaan ata bomda tiin mo-bom dong dakaan-balala, ali unang tunum sinik mafak im-buusip imi fotaba yak banebip o, ke-balale, malo ma imi aket fukunin kaata, Yesus ami dik-daaluwa, kukup akal alik ma nolaya kawu atamuwa yi, Kaa kukup mafak ema! kanuba kaa kalum i, kala-lomdip bokolip ko: Kabi kukup ukol alik ma numi kukuyap nokol utamuwa yi, God ata dong dokop-talala, yak kanolin kukup kaa kanubap kala, tukum o, kala bakamip. ");
INSERT INTO tif_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lale, Yesus ali kanubip kiimi aket fukunin kaali, utam-ilom bokoya-lomda: Kiwe! Mep faldak-tiimin weng kala bokoyokomi kaali, talalu weng selin! Abip maakup ma kaptam-ali biki-kutii dinan-kulii-tabip namti, imi titil foko-laabip namti, kulaata mafak-nokomu no. Kanumin ultap kemin, kanola unang tunum am maakup kaptam bom-bilip ili, weng aal-kup diki-bam suunkup dinin-kup, ilip namti, kaa maakup ilokomip disa; biki-lom una-tala-ke-lokomip. Kemin, ultap o. ");
INSERT INTO tif_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kibi bokop-na-lomdip: Setaan ayo titil so ma kup-tala, almi kayaak sinik mafak imi fotabam-napla, yak banen-umbip o, ninbip kaali, tifan dinam Setaan so, almi kayaak sinik mafak iso, alimal yakal biki-kutii miit alep ke dinan tabolip kaa, alimal kii titil-fokolamip disa; (Lale, Setaan ali kanu-mama disa kawi! Ibi kulaali, babonin weng bakabip te!) ");
INSERT INTO tif_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nali sinik mafak iyo fotabi yak banen-yaabip kanolin kemin, ultap Juda daang bakaalin tunum yakal sinik mafak iyo fotabamnip yak banebip o. Ibi bokop-na-lomdip: Setaan ata Yesus kaali, dong dokolala, sinik mafak fotabe-balala, yak banen-umbip o, nakan-kaan-umbip. Yale, kipni okok kemin tunum iyo sinik mafak fotabam-niwa yak banen-umbip kiili utamipla, Tunum kaa ma Setaan ami titil kaata kuluu-lomda sinik mafak kii ma yak banoma disa yo, kalalip utam-silip. Kemin, ili kabak-ata utamiwa yi, Kibi nami sang bakap-nambip kaali, ibakap-nambip o, kala-lomdip Juda okokmin tunum ita kanum bokoyokomip ko. ");
INSERT INTO tif_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","God alalta nali titil kup-nalala, mep sinik mafak kii fotabamni yak banen-umbip kaali, tifan namti, ibi utamiwa yi, Awu, faneng God ayo unang tunum imi yim-bi-din nalmi miit tem tii-lomdi tiin molokomi no kalsa kaali, kuluwu tiltam tabu no kala, kalik o kala, Yesus ayo kanum bakama ko. ");
INSERT INTO tif_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kemin, Yesus ayo almi titil dukum kaata, uta uta ke Setaan ami titil kaa wela kabaak bansu. Kemin, kaami sang kaali, weng ma faldak-tii bokoya-lomda: Tunum ma titil soyim ayo tam almi bung kiiyo, talalbi kutam almi am tii kambola, waasi dinin mafek mafek iyo foko miki-lomda, almi am bung ayo tiin mo bom-balala, almi bung uyo ti tambal-kup tiin-bilipla, ");
INSERT INTO tif_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kulaali tunum ma ayo disa akal titil ta akal ma kesa ata tal atamala, aso alep din-bi-lomdip ata ata ke-lomda, aptum am kayaak ami waasi dinin ami mafek mafek kii mikilom faksa-lomda, Tal nelamu disa yo, keba so, aptum ami mafek mafek dotu kutam am tiiba so, kiiyo alik dik-duu-lom almi waasi tunum ami kolokoma kaali, tunum am kayaak ami titil kaali kulu dinim-nokomu. ");
INSERT INTO tif_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kulaa, dok kanolin unang tunum ita nami ok ayo ma nuumin disa, aa yang aptum kusal iyo dong dakaayin-bilip tildang nami miit tem talemin disa, kemip namti, kiili nami waasi unang tunum ililtap ke unang tunum imi oko-takayim-bilipla yang banen-umbip ililtap ke-lom kanun-umbip o, kala Yesus ayo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus ayo asuk weng faldak-tiimin weng kusnum ma bokoya-lomda: Sinik mafak ma tunum ma ami diim kawu laaba. Kemin, sinik mafak ayo tunum kela din ok dinim-kup bokon kawu yang aba tildang aba ke-bam baan diim uyo ma utam-somdila ilon o, kalala, fen-tal-tal kema yi, Baan diim ayo ma atamin disa keli kala, kalba-kup, ayo bokola: Yi! nami am baan kaa, fen-bili disa keba kemin, asuk umbilin nalmi tunum kela talsii ami diim kawu bomdila ilon o, kalale, ");
INSERT INTO tif_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","kulaali asuk umbilin ulala, Ami tunum ami iipyak tem kaa am kaptam-ami sung ilol aye, saak yak bung mafek mafek kiiyo atin diliit mo-lom tambal ma kela-lomda, tunum disa am-kup bombuu tap keba kalale, ");
INSERT INTO tif_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","kulaali din sinik mafak ilmi-kup fetkal kiita, itam-ilom, iso kulii-tal tunum ami diim tiilala, alik maakup bomdipla, kamasi sinik mafak maakup kaami ilsa kulaali, kulaak banin, ale mulo kaami sinik mafak fetkal kaa tiltam tilip kiita, ita ita ke-lomdip kulu tunum kulaami aket fukunin mafak kaali, atin mafak-alom, uta uta kelula, kamasi aket fukunin mafak utale, kabaak banu kewansu no, kala Yesus ayo faldak-tiimin weng kaa kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus ayo weng ma unang tunum yaapkan imi tem kawu bokoyilale, kulaa unang ma usiik Yesus ami dukum-kup bokola-lomdu: Kapyo, tambal kemin kapni kawak uyo tamu-lomdu muuk ayo kukaap-tam-bamdu tiin molu bom bii fasuu-lom tunum dukum ke-salap. Kemin, God ata kawak umi kukup tambal-kup kuka-um-balala, fiyaap duu-buluya yo, aku. ");
INSERT INTO tif_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lale, Yesus ayo bokowa-lomda: Fan bakabap. Katale, unang tunum ili kawanta ma God ami weng kaa weng san-kaa-bamdip, God ami kukup tambal kaata kutal-fuku kulii-tabe-bam kem una namti, kaata fan God ayo kukup tambal kaa, maso ma ti kukaayin-kup kem-unokoma no, kalala, Yesus ayo unang umi weng kanum bokolula maan tiiwa ko. ");
INSERT INTO tif_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Unang tunum yaapkan iyo din Yesus ayo ata-buluwa, kukup akal alik uyo ma nolaya, nuyo atamum o, kalalip tal falala duuliple, bokola: Ibi aket fukunin mafak kaali fukun-ilom ibi bokop-na-lomdip: Mirakel o, kala kukup akal kusnum kaata ma, kukuyapla kawu, atamuwa yi, Kabi fan God alta tam-baala tal-salap kala kalum o, kala-lomdip dukum-kup dik-dakamin-kup kebip. Lale, nili kanolin kukup kaali ma kanumila, kaami fiyaap kaali ma, duu-mokomip disa. Kemin, sang maakup ma kaata-kup kukuyokomi kaali, Jona ami toop aniing dukum kaami mat tem tiin ilsa kaami sang kaata-kup kukuyokomi. ");
INSERT INTO tif_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Siin sawaalak kawu, God ami weng tem bakayin tunum Jona ayo almi abip kaa kela umbilin tunum miit kusnum ma imi abip win finin dukum Niniva yo, kala-laabip kawu, Niniva kayaak iyo bokoya-lomda: Kibi kukup mafak kulu kanun-umbip kuluu kulaalin o, kal-bomda bokoya bokoya ke-bisa ultap, Dukum Ami Man Nali tal kamala kulaami unang tunum bom-bilip kiita bokoya-lomdi: Kibi kukup mafak kula kanun-yaabip kuluu kewin o, kalalila bakayon o, kala talsi no. ");
INSERT INTO tif_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sawaalak kaa, Seba bokon kaptam-ami unang tunum imi tiin molin unang kamokan Kwin uyo Solomon ami weng tambal kaata ma weng selon o, kalalula, ulmi abip kaali kela-lomdu, yakyak umbital Israel-miin imi bokon kawu talsu. Kanola am mafiing diim daanokomu kaali, God ata unang tunum alik iyo yim-tama din weng talalmin baan diim daale, yim-bak-saanokoma kaa unang kuluuta tam tola-lomdu, kamala kulaami unang tunum bom-bilip kipni sang ayo bokolule, Solomon ami weng tambal kaata, kabaak banule, Yesus ami weng tambal kaata, uta uta kesuu. Lale, unang tunum kalawiili, ma weng san-silip dinim o, kalalula, God ami diim kawu, kanum bokolokomu. ");
INSERT INTO tif_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kanumin ultap kemin, am mafiing diim daanokomu kaali, God ata unang tunum alik yim-tama din weng talalmin baan diim kawu daale, yim-bak-saanokoma kaa, Niniva kayaak iyo tam tola-lomdip, kamala kalawaami unang tunum bom-bilip kipni sang kaata boko-lomdip: Nuli Jona ami weng tambal kaata, weng sandupla, aket fal-siki-lom, nulmi ban wakamin kuluu kewasup. Kemin, Jona ami weng tambal kuluu kulaak banula, Yesus ami weng tambal kaata, uta uta kesuu. Unang tunum kalawiili, Yesus ami weng tambal kuuta, weng san-silip. Lale, nuli aket fal-siki-lom nulmi ban kemin, kaa kulaalokomup disa yo, kala-silip o, kala, Niniva kasel ili kipni sang kaata, God ami kanum bokolokomip o, kala, Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus ayo asuk faldak-tiimin weng ma bokoya ko: Ibi ilaam kaa iilfo-lomdip kulii-daak kabuk tem tiile, baket kuuta kuluu-lomdip ilaam kuumi kulaak tinilokomip ema? Daa; iilfo kuyak alami baan diim kawu tiiliwa, unang tunum talokomip iyo tal kaali ata-mokomip te! ");
INSERT INTO tif_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kemin, kipni tiin kiili, amitom ultap. Kemin, amitom saal ayo busuulip namti, falala-kalin ayo am ba talokoma. Kanolin tap kemin, kipni tiin kaa baalip namti, falala-kalin ayo tal kipni tiin ayo tulu ata-mokomip. Kemin ale, kipni tiin kaa mafak ilu namti, atin ti malang tinilin diim kawu ilomdip mafek mafek kii ma ita-mokomip dinim o. ");
INSERT INTO tif_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kemin, ibi kaa talalu utafii-bamdipla! Ibi tiin mafak ililtap ke babon-bamdip, kipni aket fukunin ayo malang tinilin tap ke ilin disa yo; tiin tambal-kup baa-bomdip mafek mafek itam-laabip tap ke, ti tambal-kup bomdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ibi God ami falala-kalin kaa kuno kewip, talaba daak kipni aket tem ayo un iilfolokomu kawu, kipni aket tem malang tini-yinsu uyo alik falala-kup kala-lom ibi falala-kup kala-lom, ilaam iilfolin tap ke, ibi tambal-kup ilokomip o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus ayo kanum bakamsi bokoyila disa kelule, kulaa Falosi ayo ma tal Yesus ami bokola-lomda: Kapyo, talapla, naso alep din nami am kawu ima inum o, akale, fan Yesus ayo aso alep din Falosi ami am kawu tiinip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falosi ayo Yesus kaa atama yi, Yesus kaa Juda numi kukup kaata kuluu-lomda sikil kaa diing-nama dinim ke-lom kambola ima imba kala, atam-ilomda aket dukum fukuna ko. ");
INSERT INTO tif_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kanolale, Kamokim ayo ami kanola kaali, atam ale bokola-lomda: Lotu kaami lo fukumin kaali, Falosi ibi wok ket inin kaap so, falet so, ili disa tiltam saak lo angtiil diim kulaata-kup diinga-laabip. Katale, yak iipyak tem kabak-alile, diinga-laabip dinim. Kemin, kanolin tap o. Kipni aket fukunin ayo ti God ami tiin diim kawu tiinum tambal o, kala-lomdip suunkup wok-sam kaa waka-bam ken-umbip. Lale, yak kipni aket fukunin mafak dukum so, unang tunum imi moni kaami aket-kup tiin nen-bam kuluu-yaamin kaaso, iyo ma keya-laamin disa ken-umbip. ");
INSERT INTO tif_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kipni aket fanang kaali ti, babonbip kemin, ibi ti talalu utamin! God ami mafek mafek talalu kutiisa kaa, saak lo kaata-kup talalusa nema? Disa; ali tildak ipnaal diim so, iipyak tem kabak aso, maakup talalu kutiisa te! Kemin, ibi ipnaal diim so, iipyak tem kabak aso, kiili tiin saan-bamdiwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ibi aket fukunin ayo ti fal-siki-lom unang tunum mafek mafek iibip iyo olen-daayinbip-kup, kipni inin-inin kaali, falet diim bombuu aye, yak ket tem kabaaku wok so, bombuu aye, kiiyo kuyokomip kaali, ibi God almi tiin diim ayo atin tambal-kup ke-lokomip te! ");
INSERT INTO tif_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Falosi kipyo, kibi weng senin! Kibi maang aa, kuut aa, yak mafek mafek inin-inin katip katip atul-kup tabasip kii, duula kutii sikip nakalkal keliple, sikip maakup ma kabaak-ata tii God ami kukaala-yaabip tap, ibi kukup katip katip kiimi aket kaata yan-buluya, kanu-bam ale, yak kukup sengkan dukum kaami aket kaata lukuuya-laaba. Kemin, kaali ti ibi God ami aket yelula, dukum-kup ma kolin dinim ke-bamale, iltipni kaptum kusal iyo alik maakup ti kukup tambal kaata-kup kukaayin dinim; kemin, God ali ipni fiyaap kaa duun-umba disa. Am ma daanokomu kaali, kaami kalan kaata, God ayo angtiil yol kaali kukaayokoma. Kemin, ibi kukup dukum kaami aket-kup yelula, kanu-mokomip kaata, God ayo fiyaap dukum duulokoma. Kemin, yak kukup katip katip ita-kup kanumin disa; ti kukup dukum kaso kanu-bam kemin o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Falosi kipyo! Kibi din lotu am unokomip kaa, Nuli tunum kamok te! kala, din abiin tambal kawu tiinupla, unang tunum alik iyo itamik i! kalalip tiin-laabip. Aa, din ima waan saanin baan diim unokomip kaakal, kipni aket fukunin kaali ti, Nili fatap diim kawu tola-bilila, unang tunum alik iyo tal bakap-nam-bamdip: Kamokim kaa balap o? Kukuyin tunum kaa salap o? nakan-kaamik i, kalalapla, kabi kanun-umbap. Katale, ilom am ma daanokomu kaali, God ali kanun-umbip kaami kalan kaata, kibi angtiil yol kaa kuyokoma no. ");
INSERT INTO tif_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kayak kayak kiimi titafiibip kaali, angtiil diim kaata, Kabi tunum tambal o, tinbip. Katale, kapni iipyak tem kabak-ami aket mafak so, fanang mafak so, fukunbap kaali, tunum taana dibii-din dawaalip tawaal tem kabaaku foma-sing-daka-balala, unang tunum iyo atamin disa ke-bomdip disa tiip diim kulu tal-unebip. Ultap kemin ale, ilom am ma daanokomu kaali, God ayo kaami kalan kaata, kabi angtiil yol ayo kup-tokoma no, kala Yesus ayo Falosi imi itafiimin weng kaata kanum bakayinsa ko. ");
INSERT INTO tif_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kemin, kanum bokoyilale, kulaa lo utamsa tunum ma tiltam Yesus ami bokola-lomda: Kukuyin tunum o! kabi kanolin weng bokolap kaa, nuli kaa itafiimin weng bakabap kala, kalbup o, akale, ");
INSERT INTO tif_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus ayo bokola-lomda: Ayo, faneng, bakabap te! Lo utamsip tunum kibi unang tunum iyo bokoya-lomdip: God ami weng kuka-daasa kaata ti fukulin o! kala, kaata-kup bakan-umbip disa; kaltipni saak weng sawaa kusnum kusnum iyo kulii tam God ami weng kutiisa umi tiip diim kaa daka-bamdipla, unang tunum iyo bokoya-lomdip: kutal-fukulin o! yakan-kan-umbip. Kemin, unang tunum ili kaa utamiwa yi, Lo yaapkan iyo kutal-fuku-bam nuyo fiitbup o, kalaliwa, aket uluum kaa tabeyila-yaabu. Lale, ibi olen-daayila dong dakaayin-bilipla, iyo lo fukumin disa ken-umbip. Kemin, am ma daanokomu kaa, God ali kabak-ami kalan kaata, lo utamsip tunum kipkal, ti kanola angtiil yol kaa kuyokoma kayi! ");
INSERT INTO tif_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Kipni kawil-fakal ili, God ami weng ku-fatap-daa bakayin tunum kiiyo, yan-fakabi imbii din kuwakamsip. Kemin, ibi kasen-foko God ami weng tem bakayinsip imi aket kaata, fukunbup o, kalalipla, imi dibim diim kaayo, tambal-nuk o, kalalipla, tuum uyo kuluu ilaka-bamdip, aa as tes san kiiyo, diki-bam ken-umbip. Katale, kipni aket tem ayo, Tambal-kup ke, kawil-fakal ita taba kiiyo anu-silip o, ken-umbip. Kemin, kibi iltipni kawil-fakal ililtap kayi! Kiili anulip imaa-silip ale, kipta imi dibim diim uyo tiin mosip. Kemin, am ma daanokomu kaali, God ata kaami kalan kaata, ibi angtiil yol kaa, kuyokoma. ");
INSERT INTO tif_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kemin, God ali yak aba kunolin mafek mafek bombuu kuluu utamsa. Kemin, ali kipni kukup kaami sang ayo boko-lomda: Nali nalmi weng ku-fatap-daa bakayin tunum so, aa daang bakaalin tunum iso, ili yim-baali din unang tunum imi diim abokomip. Yale, tunum ita tam taba malo ma anu kuwaka-bam ale, kuno malo ma kiita, disa angtiil yol-kup kukaayin-bam, ke-mokomip o, kalala, God ayo kanum bokosa no. ");
INSERT INTO tif_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Siin sawaalak God ami tawaal so, abiil so, talalusa kawu, kipni kawil-fakal iyo God ami weng ku-fatap-daa bakayin tunum iyo yan-fakan yakyak kulii umbital kula diilu kemin, tunum unang kama kula bom-bilip yakal ti kanola, nami daang bakaalin tunum ye-bamale, kuwaka-bam ke-mokomip. Kemin, kabak-ami kalan kaata, kawil-fakal iyo kaami maan kaata kuluusip. La, God akal kipni kawil-fakal imi ban so, iltipni ban kiiso, kuyaku-diyaku ke-lomda, ban kuumi maan kaata, God ayo angtiil yol kaa kipni kuyokoma. ");
INSERT INTO tif_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kamasi kaptoop-ali Kein asiik taba-lom niing Abel aala taanala, kulaali God ami ok tabuulin tunum iyo kayak kayak ita yan-talan-umbipla, yan yakyak kutama tal awem tunum ma Sekaraya namti am awem kaldak ale, mafek mafek fuulip kiin-aba-laamin baan diim kabaaku an-ku kabaak tiilipla saaksa. Lale, kabak-ata asuk bokoyokomi kemin, weng san bom-ilipla! Kipni kawil-fakal kanola ban ke-biliwa, kanola kaami ban kuluuta tal man loop kipni diim abamnula, God ali kabak-ata angtiil yol kaa, kuyokoma ko. ");
INSERT INTO tif_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Lo utamsip tunum kipyo! Kibi utamiwa yi, God ami Sukon Tem kaali, God ami aket fukunin weng kaata, kukuyin-bulu utafiibup kala, kalbip. Yale, ti kipkal God ami aket fukunin kukup kaa, kanu-malup dinim o, kal-bom ale, yak kaptum kusal imi God ami aket fukunin kukup kaata, kanumum o, kal-biliwa, kipta yim-tal yim-tal ke-bam ken-umbip. Kemin, ilom kawu, God ayo kaami kalan kaata ibi angtiil yol dukum uyo kuyokoma no, kala Yesus ayo lo utamsip tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Kanum bokoyinba-kup, Yesus ayo am kula kela tam daak abip unale, alik maakup yak ami daang aba un-bomdipla, lo utamsip tunum so, Falosi iso, iyo Yesus ami aket atul dukum kaayo kola-lomdip, Yesus ami bon tem ayo talalu tiin dik-yak-dela dik-dakaalin-kup ke-bulupla, ayo weng mafak ma bokola kala kalale, kulu ti dibii-din weng talalmin baan diim kawu daalum o, akan-kaa-bamdip atafiimin weng so, kasen-fakaalin weng so, dik-dakamin weng so, kiili ti yaapkan Yesus ami bakaalip ko. ");
INSERT INTO tif_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Unang tunum yaapkan iyo tala-tala-ke-lom ang de-lomdip Yesus ami weng kaata ma, weng san-kaamum o kalalip, muup-daa-lomdip aptum kusal imi yaan kaami yim-baak saanin so, kemipla, Yesus ayo almi daang bakaalin tunum imi akolkup bokoya-lomda: Misii ibi Falosi ililtap kelamip kemin, ibi Falosi imi yiis bret faskaamin kaami kutap kaa utafii-bamdiwa kayi! Falosi imi kukup alep fukulin kiimi sang ata bakayinbi. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","dok kanolin unang tunum imi kukup mafak maaklo kuwaalokomip kaata ilom am ma daanula, God akal alta imi kukup mafak uyo ku-fatap-daayokoma. ");
INSERT INTO tif_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kanolin kemin ale, kutamiip kawu kaptum kusal imi kukup mafak kaami sang kaa kuwaa-lom boko-lomdip: Kanolokomup o, kalalap bokolap namti, am daanin diim kawu, unang tunum alik iyo, alep imi maaklo weng bokobip kaali, weng san-ilomdip, weng yen una-tala-ke-bamale, taken-una-tala-ke-mokomip aa, yak dok nolin ami weng mafak sang akolkup kaltapni am kaptamu bokolap namti, unang tunum ili alik abip iip kawu kapni sang bokobap kaami sang uyo naan-bam ke-mokomip o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus ayo asuk bokoya-lomda: Nak-tunum kusal kipyo, nami weng ma bokoyokomi ayo weng san iliwa! Tawaal diim tunum kaami tela taanokomap kaa, kapni angtiil kaata-kup wela taanokomu. Katale, am ma daanokomu kaali, kapni sinik ayo kaaso dap-mafak-daap-ta-lom aala disa. Kemin, tawaal diim tunum kiimi atul kaa itam suunin daa yo. ");
INSERT INTO tif_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kemin, dok nolin ami ma atam suun-daalokomap kaami sang uyo bokop-tokomi. God ali titil soyim kemin, ata taba-lomda tela namti, ali ti tam-baala yang suunkup as kiin-bam ilin abip unokomap ami atul kaata-kup atam suunamap. ");
INSERT INTO tif_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Lale, ipkal weng sanin! Tunum iyo tuumon kiin abin alep kuliita, yim-buu-lomdip awon katip katip awakal kii molokomip. Lale, God ali awon kanolin katip sakap kiimi aket ayo ma lokolu ke-lokoma dinim. ");
INSERT INTO tif_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kemin, God ami tiin diim kulaali, awon katip katip kuliimi aket kula, kabaak baniwa, ipta ipta kesip. Kemin, God ali kipni aket kaa ma lokolokomu dinim; ali kipni dabom kon maakup maakup kiili ti diing baka-bam ale, kipni aket ayo suunkup fanang daka-bam, tiin mo dong dakaayin-bam kem-tabasa. Kemin, tawaal diim tunum kiimi atul kaali, itam suunin daa yo, yakan-kaa-bamda kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ayo daang bakaalin tunum imi bokoya-lomda: Nali kipni weng ma bokoyokomi kemin, dok kanolin kapta din unang tunum imi tiin diim kawu boko-lomdap: Nali Dukum Ami Man kaami daang bakaalin tunum tituun keli no, kalap namti, God ata lek yim-bamda angtiil yol uyo kukaayin-bamda kanuyokoma kaami am daanokomu kabaku, nali abiil tikiin kasel imi tiin diim kawu bokop-ta-lomdi: Kaali nalmi daang bakaalin tunum te! tokokomi. Kemin ale, ");
INSERT INTO tif_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kabi unang tunum kawanta unang tunum imi tiin diim kawu boko-lomdap: Nali Dukum Ami Man kaami daang bakaalin tunum kelami dinim o, kala namti, God ami lek yim-bam angtiil yol kukaayokoma kaami am daanokomu kawu, nakal abiil tikiin kasel imi tiin diim kawu bokop-ta-lomdi: Kaali nami daang bakaalin tunum disa yo, tokokomi. ");
INSERT INTO tif_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kemin, nali Dukum Ami Man yale, tunum unang kanta nami weng mafak uyo kukaap-nambile, asuk aket fal-sikila namti, God akal ami ban kemin kaali, kukan-telokoma. Kemin ale, dok nolin unang tunum ita God ami Sinik Tambal ami weng mafak kaayo bakalip namti, God ali imi ban kemin kaali, atin ti kukan-tiiyokoma disa. ");
INSERT INTO tif_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Kanola tunum iyo itamiwa yi, Ibi nami daang bakaalin tunum kala, kalbip-kup, iyo yim-tama tam lotu am daalipla, Juda imi kamok kamok iyo im-bak-saanbile, yim-tama din kiyap imi diim kawu daalipla, ita yim-bak-saanokomip. Kemin, kanuyokomip kaali, ibi aket yaapkan fukun-bamdip: Kwin! weng kutal numi diim diiyokomip kaali, kanimin o, kalokomup i? Kemin, dok kanumin weng kaata, maan tiiyokomup ma? kala-laamin daa yo. Kela bilili-kup-kala bom ilipla, God ami Sinik Tambal ata taba ibi kukup tambal kaali, kukuyalala, weng tambal kaata-kup bakayokomip o, kala Yesus almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Unang tunum yaapkan iyo Yesus aso tola-bom iliple, kulaa, tunum ma ayo unang tunum yaapkan imi iipyak tem kulu bokola-lomda: Kukuyin tunum kapyo. Kabi nami abaap ayo bokolapla, numi atok saakba ami tawaal so, am bung mafek mafek iso, iyo biki-lomdap nakal anung ma kup-nala yo! akale, ");
INSERT INTO tif_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus ayo tunum kaami bokola-lomda: Nak-tunum kapyo, God ali nam-baala tal-ilomdi, kipni tawaal so, mafek mafek am bung iso, kiimi weng kiita, talal-bamdap kabaan-yilan o, kalalaya, nam-baala talsi disa yo; nali ti ok kusnum okok kemin tunum o, kalba-kup, ");
INSERT INTO tif_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","kulaa fal-siki taba unang tunum imi bokoya ko: Ibi nami weng bakabi kalawuuli, talalu weng senin! Tunum mafek mafek soyal ili ilmi mafek mafek kiita, dong dokolipla, tambal-kup ilokoma disa le, kaptoop kaptoop kakal, ali suunkup ilokoma disa. Kemin, ibi kaptum kusal imi tawaal so, mafek mafek am bung iso, imi mok kaa inin disa yo, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesus ayo weng ma faldak-tii bokoya-lomda: Mafek mafek soyap tunum ma ami langabip ayo wiit san yaapkan tabamnip itaba-kup, kulaali tunum ayo tiin-bomda aket fukuna ko: ");
INSERT INTO tif_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kwin! nami wiit dakela kutal am tiimin am kaali, dukum disa kemin, umi baan diim kutiimin ayo muup-nula dok kanolokomi ni? ");
INSERT INTO tif_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nami wiit am kaali, balata kutii-lom, am dukum-kup ma de-lomdila, wiit so, mafek mafek so, kiili diili tam abamnuk o, kala! ");
INSERT INTO tif_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ayo dinamsi bom bii disa kelule, kulaa tiin-bom aket fukun-bamdi: Ti yaap ke, nali mafek mafek yaapkan so ke tiikni no. Kemin, kulaata bom bii wasital yaapkan ma duk-duu-somdila, kaata kun fan kaa-bamdile, inin-inin yaapkan uyo im-bomdi, ok mafak dukum-kup in-bomdila, fiyaap duumon o, kalokomi no, kalala, kanolin aket kaali, fukuna. ");
INSERT INTO tif_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lale, God ali bokola-lomda: Kabi babon bi-lom tiinsap kapyo! Am kamala kutamiip kulu saaka-lomdap yak kapni mafek mafek talalbi kutiin-tabasap kuluuli, ke-wokomap. Kemin kabi, Bung kiili, nalmi alik o kala-laabap kaali, kawanta kuluulokoma ni? kala, God ayo mep tunum kaami kanum bakaanba. ");
INSERT INTO tif_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kemin, ipkal utamin! Kanola ibi tunum kaaltap ke iltipni aket-kup fukun-bamdip mafek mafek afet-mokomip kaa, ibi God ami tiin diim kaa tifan win dinim o, ke-lokomip o kala, Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kulaa, Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Kibi kamala kulu nami weng bokoyili kaa, weng selip o? Kanum bokoli kaami anung kaali, bokoyokomi. Ipni kula unip kaami aket awak dukum ayo fanang daka-bamdip boko-lom: Kwin! ima kaa doku ma tulula, inam-nokomup i? kal-bomdip aket yaapkan kaa fukun-bam ale, iltipni angtiil lak uyo duu-lom boko-lomdip: Kwin! ilim kaa doku ma tulula, mikilokomup i? kal-bomdip aket yaapkan fukunin disa yo. ");
INSERT INTO tif_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","God ata mafek mafek sakbaalim dukum kaa iltipni mam so, titil so kiita, kuyilaya kulu bom-bilip, aa mep mafek mafek katip katip o, kala inin-inin aye, ilim mikimin aye, kiiyo kanola God alta kuyokoma. Kemin, kabak-ami aket kaali, yaapkan fukunin disa yo. ");
INSERT INTO tif_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ti ipkal awon kii itam-tamin! Kiili ima waan lang kaa imi dikimin disa; lale, ili ima kaa dabuubi kulii-din am kawu tii-bam inin disa; God alalta imi ima ayo kukaayin-balala inan-umbip. Katale, God ami aket dukum kaali, unang tunum kipni kuyale, awon imi aket kuya-laaba kaata kabaak banala, unang tunum iptale, ima ayo kukaayim-balaya, ima iyo inan-laabip. ");
INSERT INTO tif_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ibi kanolin aket yaapkan kaa fukun-bam, iltipni angtiil lak kuuta, dong dokoyilula, ibi tiika-yilin ayo kayoop so, wasital so, kiiyo til daalup toop lo so keluya, tawaal diim kalawu bom bii ilanin tap ke-lokomip ema? Daa te! God ali boko-lomda: Kuyaku taanan aa! kalsa kuyaku ti taanokomap te! ");
INSERT INTO tif_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kemin, kayoop til-dakamin aa, yak wasital til-dakamin kaa, katip sakap lale, ibi taang-kala kanolamip disa. Kemin, ibi kanimin o, kalalipla, mafek mafek awak dukum kaami aket kaata, aket yaapkan fukun-umbip yoko? ");
INSERT INTO tif_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ti ipkal as tes uyo utamin! Kaali tunum nulultap kelula, ulmi ilim uyo talal-bam bikimin disa; uli ti disa kulu tabemin kaali, God alta tiin molaya, uyo bomdula umi tes tambal kaa, abun-umbu. Kemin, siin sawaalak tunum win soyap Solomon ami bom-biisa kaa, ali mafek mafek soyim tunum ale, ilim tambal tambal kiita-kup miki-bisa. Yale, unang tunum ilmi sikil ta, ilim tambal kii baken-bilip miki-bisa le, imi dawang kuluuli, kulaak banin so kelula, God ami as tes kaa talalusa utale, kaami dawang kaali ti uta uta kesu. ");
INSERT INTO tif_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kemin, sinaan so, mokol so, imi tes tambal iyo bom-bilip kemin, bom ilanin tap ke data kemiple, kulaa tunum ita tikiin kuyak daalip tes kiiyo, kasentap kiin aba-yaabip. Katale, tes kaali, God alalta talalu kutiilala, tambal-kup falala-kala-laabip. Kemin, nikil ibi aket alep kiili fukun-bam, God kaa nuli ilim kaa ma kuyokoma ne, disa ye? kem-laabip kaa, ipkal talalu utamin. God ami aket dukum kaa, kipni kuyale, as tes kiimi aket kuya-laaba kaali, kabaak unin kemin, alalta kipni ilim kaa kukaayokoma. ");
INSERT INTO tif_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kemin ti, ipkal kanolin aket kuuta, fukun-bamdiwa, inin-inin kaami aket kaata-kup yan-bulula, aket yaapkan kaa fukunin daa yo. ");
INSERT INTO tif_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kaa dok kata naa kalolip: Tawaal diim kaldaak-ami unang tunum ili God ami samaan kawu bomdipla, tildang ami weng kaayo ma, weng san-kaamin disa; ili ti suunkup ilim so, inin so, kiimi aket kaata-kup yan-bulula, aket yaapkan iyo fukun-umbip. Lale, kipni Kaalap God akal kaali, utamala, Ibi suunkup inin-inin umi liip kaa fenbip kala, kala-somdala, inin-inin iyo suunkup kukaayokoma te! ");
INSERT INTO tif_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kemin, tawaal diim kalawaami mafek mafek aket kaali, dukum-kup yelula ilin disa; ti God almi ok kaami aket kaata-kup yelu okok ke-mokomip kaata, fan God akal ilim so, inin-inin so, kiiyo kukaayokoma no, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kulaa, asuk Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Nikil kipyo. Kibi sipsip alep-kup ililtap kemin, God ali aket fuku-daa utama yi, Ibi imbii tal nalmi abip kala daaliya, ilin o, keba kemin, kibi tawaal diim kalawaami mafek mafek aket kii aket yaapkan fukunin dinim ale, suunin daa. ");
INSERT INTO tif_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kemin, nuli mafek mafek yaapkan kiili bom-bilip o kalip namti, mafek mafek kiili, saan-bamdipla, tuumon ayo kuluu-lom, unang tunum iyo itamiwa yi, Awu, kuliita duluubip kala, kalalip, kuliimi kukaayin-biliple, kuuta imi dong dakaayuk o. Tawaal diim kalawaami men sole, ilim so, kuliili, disap-nokomip aa, tuumon ukol kuno abiltap-kup disa ke-lokomu; yak keng katip katip ita mafek mafek uyo inam-nipla, balat tabokoma; kuno tunum yakal mafek mafek yukut daka-bilip ken-umbip kemin, mafek mafek kuliili, dinim-nokomu. Kemin, mafek mafek kalawu kuliili, tildak kuyaku-diyaku-ke-bam afetmin disa; God ami ok tambal kaata-kup kanu-bilip bom bii, God alalta maan tiiya-lom yim-tama din almi suunkup ilin abip kawu daalaya, tambal-kup ilin o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kanola tunum ma tawaal diim kalaami mafek mafek kiimi aket-kup an-bulula ila namti, ali kanolin mafek mafek kaali, kulii-tildak kuyak mim-daa sikip fak-dakan-unokoma. Kemin ale, kanola tunum ma ali almi mafek mafek aket fukunin ayo kuno maas kewa God ami aket kaata-kup an-bulu ila namti, fan tunum kaata, God ami lak dakamin kaami kukup kaa, kutal-fuku-bom ilokoma no, kala, Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus ami bokoya-lomda: Ibi weng senin. Ibi dotu-lomdip nami liip ayo fen-bam bom-ilipla, bom biilila kawu tolon o. Kemin, nata faldak-tiimin weng ma ok tabuulin tunum ma kaami sang kaata bokoyokomi kemin, kipni kukup kaali, ok fukulin tunum kiimi kukup ilaltap ke-biliwa yo, kala-somla ko. Kemin, am ma daanule, kaami kamokim ayo utamala, Nak-tunum kaali, unang sii ma kuluulala, akam imi aptum kusal iyo tala-tala-ke-bam ima ina fakaneng tababip kala, kalale, kulaali itamala, Aso fiyaap duumum o, kalalala tabana. Kemin, almi ok tabuulin tunum kiili, ilmi kamokim kaa dok kanolin diim kawu asuk talokoma no, kalbip disa; ti maaklo kulu bung mafek mafek ayo dotu kutii kela fen-bam iliwa, kutamiipnu kala, kala-lomdip, yokon uyo iilfo-lom kawang-kup tiin-bom ilmi kamokim ayo fen-bilipla, bom biila ayo tal saal dok-dok diina kalale, kulaali abiltap tam-tiin din saal ayo busolip. ");
INSERT INTO tif_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kemin, almi okok kemin tunum iyo kawang bom iliwa, tal itamale, kulaa, Ti yaap ke tal itami no, kalale, imi fiyaap kaali, duu-bam kukup tambal uyo kukuyinba-kup ale, kamokim ali, ima ifamin imi kukup kaata, kuluu-lomda bokola: Daak tiinipla, nalta ima ifalila inin o, kala kanum bokoyale, ");
INSERT INTO tif_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ok fukulin tunum yakal utamiwa yi, Awu, am kutamiip muma diinula, toloma ne, am daan daan tala-balala kawu toloma ne? kalbip disa. Yale, ti disa maaklo kulu suunkup fenin-kup ke-bilipla, ayo tal-ilomda kukup tambal kaayo kukaayila ko. ");
INSERT INTO tif_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Weng ma bokolokomi kaa, weng senin! Am kayaakim ayo utamala, Awu, atan sinik uyo tal dok ba tulula, yukut-inipyaap tunum ayo tolokoma no kalase dinam ali tiin baa fen-bamda ilala, yukut-inipyaap ayo am taloma dinim. ");
INSERT INTO tif_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kanolin kemin, Dukum Ami Man Nami tolokomi kaa ibi utam, Awu, kunolin diim kulu tolokoma no, kalbip disa; kemin ipkal ti maaklo kulu suunkup fen-bam bom-ilipla, nayo tolomi kayi! kala-lomda Yesus ayo almi daang bakaalin tunum imi kanum bokoyinsa ko. ");
INSERT INTO tif_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesus ayo weng faldak-tiimin weng kaali, bokoyila disa kelule, kulaa Pita asiik Yesus ami bokola-lomda: Kamokim kapyo. Yak faldak-tiimin sang ma bokolap kaali, nuta-kup bokoyap e, unang tunum alik iso bokoyap e? akale, ");
INSERT INTO tif_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kamokim asiik bokola-lomda: Kanum bokolap kemin, ibi talalu weng san-ilipla! Nali tunum titil-fak-daa-bomda, aket tambal-kup fukun-bamda ilin tunum ami sang kaata ma bokoyon o, kali kemin, kamokim ma ayo umbilin samaan kawu bom biilila, tolokomi kayi, kalalaya, almi okok kamaalin tunum ma ulduu-dap-tii-lom, bokola ko: Kabi nami ok tabuulin tunum kalawiili, tambal-kup itafii-bamdapla tiin mo-balap, iyo ok tambal-kup fuku-bamdipla, nami mafek mafek iyo tambal-kup bom-bilipla, ima kabaanu-ya-laamin kaami diim daanokoma kabaku, kapta nami okok kemin tunum imi kukaayan o, kala, bokola-lomda kela unokoma. ");
INSERT INTO tif_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kela tabanala, okok kemin tunum ayo kamokim ami weng uyo weng san-ilomda, ali ami ok tambal ayo kutal-fukulin-kup ke-bomda, okok kemin-kup ila namti, kamokim ayo asuk tal ulala, Ali tambal-kup okok keba kala, kalokoma kawu, ami fiyaap kaali, dolokoma. ");
INSERT INTO tif_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kemin, kamokim ayo tal bokola-lomda: Nali kalawu bomdi, kabi titafiimin disa; bom bilila, kabi ok tambal ayo tabuusap kala, tal tiki kemin, ok dukum ma uyo kup-ta unila, kapta nami mafek mafek kiili, alik tiin molokomap o, akokoma. ");
INSERT INTO tif_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lale, kanola okok kemin tunum ayo aket fuku-daa: Nami kamokim kaa mafek mafek kusnum ma kuuta taba-lomdu, ami tolokin uyo dap-diila kemin, abiltap-siik toloma dinim o, kala-lomda, ali aptum kusal okok kemin unang tunum iyo ye-bamda, ima ayo faka-bam im-bomda saak ok mafak in-bomda, babon tal-une-bamda, kema; ");
INSERT INTO tif_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kwin! kamokim kanumin diim kawu ma tolokoma ni, kala fenin disa ke-bam ila namti, bom-balala bii, am ma daanule, kamokim ayo tal ula yi, Kukup mafak kem-tabasa nu, kala atam ale, kulu ami kukup mafak namti maan tela-lomda angtiil yol awak dukum ayo kukaalokoma kaali, weng kuyang saak tiimin tunum kiimi angtiil yol dukum-kup kukaayin tap kela kukaalokoma no. ");
INSERT INTO tif_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kanu-bam okok kemin tunum ali kawanta utamala, Kamokim ayo yak kanolin ok kabak-ata kanuman o, kalba. Katale, ok kabak-ami aket kaali, fukun-bamda, kufuku okok kemama disa; ami weng uyo kuyang saak tiila namti, ami kamokim ayo tal-ilomda angtiil yol awak dukum uyo, kolokoma. ");
INSERT INTO tif_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kemin ale, okok kemin tunum kaa kanta utamala yi, Kamokim ali, Kalanolin ok kaata kanuman o, akin disa kela unala; ti maaklo kulu kukup mafak-kup kema namti, ami kamokim ayo angtiil yol katip kaali, kolokoma. God ali aket fukunin tambal kaata, tunum ma kaami kola ayo utamsa namti, God alalta kabi tambal-kup okok keman o! akokoma. Kanola, tunum ma ata God ali suunkup aket tambal uyo, kukaalin-kup ila namti, God ali, Kabi atin ti ok tambal kaata-kup, suunkup okok kemin-kup keman o, akokoma no, kala Yesus ayo kanum bakayin-bisa ko. ");
INSERT INTO tif_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Nami taldaak tawaal diim talsii kaali, unang tunum imi aket fukunin mafak so, kukup mafak so, imi kalan kaata, wing ta kuyak daalila kiin-aba-lomdu disa keluk o kala talsii. Kemin, nalmi aket fukunbi kaali, as kuyak dakamin kaali kamala kawu no kebi. ");
INSERT INTO tif_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yale, kanolin kukup uyo tiltam tilin disa bom-bulula, nasiik angtiil yol awak dukum kaali, kuluulokomi. Kemin, nali utamila, Kaami am uyo daan tiltam tolokomu kala, kala-lomdila, kabak-ami aket dukum kaata, fukun-bamdi aket uluum tabep-na-bulula, bom biile, nami kanolin angtiil yol uyo dinim-nokomu no. ");
INSERT INTO tif_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kipni aket fukunbip kaa, Ali tal-ilomda unang tunum imi weng kaata, bokoyi tilipla alik aket maakup kelin o, kalalala talse no, kalbip ema? Disa te! Nami weng, weng sep-nokomip kaali, iip maakup maakup ita weng sanokomip. Lale, malo ma kiitale, Weng sanokomup disa yo, kalalipla daang ukolokomip. Kemin ale, toko-lom tunum miit alep ke-lomdip, weng aal dikin-una-tala-ke-bam, waasi kela una-tala ke-mokomip. ");
INSERT INTO tif_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kanola am maakup kutamu unang tunum awakal ilip namti, biki-lom alep ma yakal kelip kuno, asuumano yakal kelip ke-lomdipla, nami weng kalan kabak-ata kanum taba, alep iyo tunum asuumano iso, weng aal diki-biliple, ");
INSERT INTO tif_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","awil-fakal yakal, tunum ma iso, waasi kela una-tala-ke-biliple, awil-fakal unang yakal unang man iso, kuno waasi kela una-tala-ke-biliple, abimuwak kusal yakal miining imi unang tan iso, waasi kela una-tala-ke-bilip ke-mokomip o, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kulaa, asuk Yesus ayo unang tunum imi kanum bokoya-lomda: Ibi utamiwa yi, Ibin uyo duutkan kelu kala, kalale, ipyo boko-lomdip: Yi, om tolokoma no, kalalip abip talen-umbip, ");
INSERT INTO tif_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","aa, ibi utamiwa yi, Atan tem un-laabu kawu utamipla, Inim ayo fufu tala kala, kalokomip kaali, am yaak am tiltam tabokomu no, kaliwale, tiltam taben-umbu. ");
INSERT INTO tif_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kukup alep kutal-fuku-bam utamsip tunum kibi, tawaal diim so, abiil kaaso, kiita, itam ale, Awu, am kanolin am kaata daanokomu no, kem-laabip. Lale, ibi babonin tunum kiimi kukup kaata kuluu-lomdipla kemin, dok nolin mafek mafek kamala kawu tiltam taben-umba kaami miit kabak utabup disa yo, kalbip kayi! kala, Yesus ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesus ayo weng kusnum ma bokoya-lomda: Ibi kanimin ma nolum o, kalaliwa, ipkal aket fuku-daa, Awu, kabak-ata kanu-mokomup kaata ti mokso keyokomu no, ken-umbip elile disa ye? ");
INSERT INTO tif_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Uyo kanolin kemin, kanola tunum ali ma bokop-ta-lomda: Kukup mafak kamap-nambap kemin, timbi din kamokim ami diim kawu daalila, ata tam-bak-saanbi, kulaali angtiil yol kaali, kup-tak o taka namti, kabak kapkal utamapla, Ulmi am tituun namti kuyaku tiltam tabokomu kala, kalokomap kaa, kapkal ale, akal alep din weng uyo talalulip disa kelule, alep aket maakup kelip kulaalalip. Ale, weng uyo talalulip disa kelin disa kelip namti, ata kabi timbi din kamokim ami diim kawu daalaya, ata lekbi tam-bak mole, tam-baala yak bolis boi imi sikil diim kawu abamnaple, ita tam-baalip tam kalabus am unokomap. ");
INSERT INTO tif_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kanop-tip bom biile, kapni ban kanun-umbap uyo kot baan diim kawu alik molap disa kelule kaata, taldaa tam-baalip tiltam ba tolokomap. Kemin, ibi nami faldak-tiimin weng kaali, talalu weng san iliwa yo, kala Yesus ayo unang tunum imi kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kanumin am daanbu kuyaku, unang tunum bom-bilip iyo tal Yesus ami diim abale bokolip: Unang tunum malo ma Provins Galili kayaak ili God ami yaap ke yo, akum o, kalalipla, olti iyo kutal tiiliple, awem tunum ita yak olti kiiyo, anu-lom fuu-bilipla, kiyap Pailat ami soldiya iyo yim-baala tal Galili kasel imi anulipla, imi kiim kaami kuyaku le, olti imi kiim kaayo kuyaku, ke-lom sing-tam daasip o, kala bokoliple, ");
INSERT INTO tif_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","asiik bokoya-lomda: Kipyo, kipni aket fukunbip kaa, Galili kasel ili malo ma ban kemin, kaa ti sakbaalkan dukum o, kala, kalalip anulip taanipla, malo ma kiita, imi ban kemin kaata katip u, kalaliwa, kuno kamboyip yaap ke-silip o, kalbip ema? ");
INSERT INTO tif_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Disa, ilmi ban kemin kaami kalan kaata taansip disa. Lale, ibi nami weng kala bokoyokomi kabak-ali ipyo talalu weng san iliwa! Ibi iltipni ban kemin kaa kela aket fal-sikilin disa ke-lokomip kaali, ibi alik Galili kasel ililtap ke-lom alik saak-nokomip te! ");
INSERT INTO tif_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kanolin kemin, siin kaali, tunum ilmi-kup tal aba tam daak nakal malii foko (18) kiita, abip dukum Jerusalam kaami tang tem abip ma Siloam kaptamu tola bom-iliple, kulaali am batbat ma kaata bal du kulii taldaak aba-lomdu yim-baak mo anulu saaksip. Kemin, kipni aket fukunbip kaali, Jerusalam kasel ili imi ban kemin kaa, dukum kemin, kaa anulu taansip o. Ale, malo ma ita imi ban kemin kaatale, katipso kemin, anulin disa kelu yaawa-silip o, kebip ema? ");
INSERT INTO tif_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kaa disa! Ilmi ban kemin kaami kalan kaata taansip disa. Lale, ibi nami weng kala bokoyokomi kabak-ali ipyo talalu weng san iliwa! Kipni ban kemin kaa kela aket fal-sikilin disa ke-lokomip kaali, alik ibi mep tunum kiimi kanosip ililtap ke taanokomip te! kal-bomda ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kulaa, Yesus ayo faldak-tiimin weng ma boko-lomda: As fik ma kaali tunum imi wain lang iip-iip kabaaku tolsu. La, tunum wain lang kayaak ayo din as fik kuu utamala, Fik kuuli, abuubu kala kalon o, kalale, ayo tal ula yi, As lap so ma abuulamu disa kelula utama ");
INSERT INTO tif_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","le, ami langabip okok kemin tunum imi bokoya-lomda: Kipyo, as lap abuumin am kulaa mep tulu kemin, tal utam utam kemsi wasital asuumano duk-duuli. Katale, as fik kalawuuli lap so ma abuulamu dinim, kesu kemin, as kuluu welan aa! Mep as kuuta, taba-lomdu tawaal kaami matak ayo alik in-bulula, disa ke-lokoma kaa, mafak kemin, baan as kuluu welan o, akale, ");
INSERT INTO tif_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","kulaa langabip kaptam-ami okok kemin tunum ayo langabip kayaak ami weng ayo maan tela ko: Kamokim o. As kalawaami miit tem ayo tawaal an-fal-siki-lomdi as kaami ima inin kaali, dotulila ");
INSERT INTO tif_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","as kuu lap abuuluk o. Ilom wasital maakup anang ma duk-duu utam talaalupla, Abuulin disa; ti kanolin-kup ilu namti, bokop-napla kawu, welon o, kalase no, kala ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","God ami iintang am ma daanale, Yesus ayo yak aba din lotu am kawu, unang tunum imi God ami weng bakayilale, ");
INSERT INTO tif_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","kulaa, unang ma tiinbu kuuli, sinik mafak ta taba-lom mafak-alin kuwa tiinsu. La, bom bii-lom wasital almi-kup tal aba daak nakal malii foko (18) duk-duusu. Ale, unang kuumi ol kun kaali, silik tal u kesu. Kemin, uyo talalu tolnamu disa, kesula, ");
INSERT INTO tif_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus ayo unang kuuli, utaba-kup, kulaa uyo naan-daawa tal atamule, bokowa-lomda: Unang kupyo, nali kupni mafak-alin kulaali ");
INSERT INTO tif_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","kukan-tiip-ti te! umba-kup, almi sikil ayo kuyak tam unang umi angtiil diim tii kem-salale, kulu maak fak-daalin tap, tituun-kup tam tola-lom, God ami fiyaap ayo don-bamdu win kufolu ko. ");
INSERT INTO tif_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Uyo kanu-bulula kawu, lotu am kaptam-ami kamokim ayo utama yi, Yesus ali God ami iintang am daanbu kawu, unang kuu um-talalula tam tolnu kala, kalale, tunum kaami aket atul ayo Yesus ami kola-lomda, unang tunum imi bokoya ko: Am bukupkal ke-laamin kiimi diim kaata-kup okok kemin; ale, God ami iintang am daanu no, kala, kaa okok kemin am daanbu disa; ibi tal Yesus atamupla, Yam-talalulak o, kalip namti, okok kemin am ma daanula kawu, ipyo tal atamip yam-talal kaamak aa! Ale, yak God ami iintang am daanba kaali, tal atamip yam-talal kaamin disa te! kala, ban boko-lom kanum bokoya. ");
INSERT INTO tif_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kala kanum bokolale, Yesus asiik weng bokola-lomda: Kukup alep fukulin tunum kipyo! God ami iintang am daanbu diim kaa alik ibi iltipni bulumaki so, dongki iso, iyo din sok baa yim-bi din ok ayo kuyip inan-umbip kaali yi! ");
INSERT INTO tif_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mep unang kulawuuli, Abraham almi man loop ukol ti nulultap kemin, unang kalawuuli, Setaan ata um-mafak-daalala, umi ol kun kaali, silik tal uuwala bom bi-lom wasital almi-kup tal aba tam daak nakal malii foko (18) duk-duusula te! Kanola, God ami iintang am kalawaata yaap kep-nula, Setaan ami sok ta de-umtiisa kaa, nata taba-lom tildaa umbaa-lomdila, um-talaluli dalaal kelu no, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus ayo kanum bokoyila kem-salale, kulaa ami waasi kensip iyo fatom-duk-duu-lomdip weng so ma bokolin disa kelipla, unang tunum iyo Yesus ami kukup tambal talala tal-uneba kaali, atam-ilomdip ami fiyaap ayo dukum-kup duumip ko. ");
INSERT INTO tif_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ayo asuk bokola-lomda: Unang tunum kiimi tal aba tam God ami miit tem uniwa, tiin mo-laaba kiili, dok kanolin ililtap i? Kemin, nalta bokoya-lomdi: Kiili kalanolin unang tunum o, kalomi. ");
INSERT INTO tif_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Unang tunum God ami miit tem bilip iyo mastat kaami san ililtap kemin, (mastat san kaali, fan lap atin ti katip sakap lale,) tunum ma ata kulii yang dikiilala, yaap taba-lom, atin ti as dukum alaltap kelale, awon iyo talaba tam ami tang diim kawu, iim kiiyo dinan-umbip o, kala Yesus ayo kanum bokola ko. (Kemin, faldak-tiimin weng kaami miit kaali, bokoya-lomdu: Mastat ami san ililtap, ti God ami unang tunum iyo kamala kaali, iip maakup maakup ita-kup talebip. Lale, ilom am ma daanokoma kawu, tala-tala-ken-umbi-lom atin ti yaapkan ke-lokomip o, kalsu ko.) ");
INSERT INTO tif_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus ayo asuk weng kusnum ma boko-lomda: Tunum unang iyo tal aba tam God ami miit tem tiliwale, tiin moba kiili, dok kanolin iltap ma? ");
INSERT INTO tif_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nakal bokoya-lomdi: Unang tunum kiili, kalanolin o, yokokomi. Kemin, unang tunum tal God ami miit tem kawu bom-bilip kiili yiis o kala, bret dotmin mafek mafek ulultap kemin, unang ma yiis katip ma tuk-duu-lom kulaalu daak flawa dukum kaami tem unala, fal-siki-bulu bii, maakup kelula kuno kela ilanin tap kelule, flawa uyo fasuu-lom akal alik ma ke-lokomu alaltap o, kala Yesus ayo kanum bokola ko. (Kemin, faldak-tiimin weng kaami miit kaali, bokoya-lomdu: God ami lak duulin unang tunum iyo unang tunum kusnum imi iipyak tem kawu bom-bilip namti, aptum kusal God ami lak duulin dinim bom-bilip iyo yakal ilimi kusnum ke-lomdip, yakal ti kano God ami lak uyo duu-lom, atin ti yaapkan ke-lokomip o, kalsu ko.) ");
INSERT INTO tif_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus so, almi daang bakaalin tunum iso, iyo Jerusalam unum o, kalalip yakyak un-bomdipla, Yesus ayo God ami weng kaali, yak abip tildak abip imi bakaya yakyakda, uniwale, ");
INSERT INTO tif_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","kulaa, tunum ma ayo tal Yesus ami dik-daala-lomda: Kamokim kapyo, God ayo tunum iip maakup maakup ma ita-kup yim-buu-lom yim-tama tam God ami abip daalokoma nema? akale, Yesus ayo alik imi bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","God ami abip unemin kaami amitom kaali, atin ti katip sakap kemin, unang tunum yaapkan iyo tam unum o, kalbip. Katale, ili fan taang-kala-lomdip tam unolip disa te! Ti ipkal titil-fak-daa God ami weng tambal kuuyo, kutal-fuku-lomdipla, God ami abip kaa tam unin aa! ");
INSERT INTO tif_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bom ilom am ma daanokomu kawu, abip tiin molin kayaak alta tam tola yang amitom saal liilokoma kawu, tunum unang tildang kulu tolbip. Ibi din amitom kulu tolale, dok-dok ke-bam naan-bamdip kanum baka-mokomip o: Kamokim, kamokim, kapyo saal busuuyan o, saal busuuyan o, ke-bam akan-kaa-bam naalokomip. Lale, abip kaptam-ami amitom tiin molin tunum asiik bokoyokoma: Daa. Ibi dok kayaak i? Nali ibi ma itamsi dinim kemin, ibi kaloku ma laabipla tilip i? kalala dik-daayokoma no, ");
INSERT INTO tif_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","kala, kanum bokoyilale, kulaa kipkal bokolokomip ko: Aa, kabi tal numi abip kawu talawa titafii-bam ale, nuso ima im-bom, ok im-bom, God ami weng tambal ayo bakayin-bam ke-bamdapla kawu, nuli itamsap kaali yi? akiwale, ");
INSERT INTO tif_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kulaa, asiik asuk bokoya-lomda: Nali ibi ma itamsi dinim kemin, ibi kaloku ma laabipla tilip i? Nali kibi itamila, Ban kemin unang tunum ibi nami unang tunum o, kalsi disa; baan kep-na tabanin aa! yokokoma no. ");
INSERT INTO tif_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ibi itamipla, Juda nulmi awil-fakal Abraham, Aisak, Jekop alimal yakal aa, God ami weng ku-fatap-daa bakayin tunum kanolin iso, alik ili God ami abip kaltamu bom-bilip; kemin ale, nuta fotabam-nala tam daak saak lo kaptamu bom-bulup kala, kalokomip. Kemin, ibi angtiil yol dukum tabemin kaali, tabeya bom-bulula; Kwin! kuuso kawi! kal-bomdip iltipni angtiil kaami kalan kaata ama-mokomip kayi! ");
INSERT INTO tif_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kanola abiil kulii umbilin dilit kalsu so, tawaal kulii umbilin dilit kalsu so, kiimi tunum unang yaapkan kipni itam-laabip dinim kiiyo, tala-tala-ke-lom God ami abip kawu bomdipla, ima ina fakaneng taba-bilipla, ibi itafii-mokomip. ");
INSERT INTO tif_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Am kamala kalawaami diim kawu tunum unang yaapkan ili win dinim bom-laabip iyo am mafiing diim kawu isiik win soyal keliwale, kamala kala unang tunum yaapkan win soyal ke-bom-laabip ita, am mafiing diim kaali, isiik win dinim ke-lokomip o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Am kanumin diim kuyaku, Falosi malo ma iyo tal Yesus ami bokola-lomdip: Yesus kapyo! Provins Galili kaptam-ami tiin molin tunum Herot ali boko-lomda: Nalmi soldiya iyo yim-baali din telip taanan o, kalba. Kemin, baan abiltap Galili kaltam-ali kulaa kelalap tabanan o, akiple, ");
INSERT INTO tif_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus asiik bokoya-lomda: Herot ali saak miyaan alaltap kemin, ipta asuk din-ilomdip kanum bokolin o: Yesus ami weng bokop-tamba kalawuuli, talalu weng selan o, kala-somla ko. Ali, bokop-ta-lomda: Nali kapni atul uyo titam suun-daa ukadaa unokomi dinim; kamala so, sabi so, uyo unang tunum sinik mafak yim-fukusa imi sinik mafak fotabe-bam ale, yak unang tunum sik mafak umkan-unsip imi yam-talal-bam ken-um-bomdi, am sabi ye, sankaali ye, anang kawu, nami ok ayo dinimna kulaalokomi no, kalba kayi! kalalip din Herot kaa kanum bokolin o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yale, God ami weng ku-fatap-daa bakayin tunum ili suunkup abip dukum Jerusalam kaptamu-kup yan-umbip kemin, kaa yaap kep-nula, Jerusalam kaptamu God ami weng ku-fatap-daa bakayin tunum nayo, nelokomip. Nali Herot ami bokon tiin moba kalawaali, keya din Jerusalam kawu itamila, neliwa taanokomi kemin, kalawu okok ke-lom kamala so, sabi so, sankaali so, kiiyo okok daalila kawu, yakyak Jerusalam unokomi no, kalaya bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kanola Jerusalam kasel imi aket kaata fukun-ilomda ayo aket uluum dap-telule, almi aket-kup fuku-daale bokola: Jerusalam kasel kipyo! Ibi God ami weng ku-fatap-daa bakayin tunum iyo ye-bilipla saaka-yaa-bam ale, God ami daang bakaalin tunum yim-baala tal-silip iyo, tuum ta kup ye-bilip taan-yaa-bam ken-umbip. Katale, awon awak umi man kiili, kuu ulmi bal kun tem tii katii-yaabu tap kemin, am yaapkan daan tal-unem-tabasa kaa, nali ti alik maakup ibi im-taldang daa, nalmi sikil ta uti fokolin tap ke yam am daalon o, kemin-kup, kanum-tabasi. Yale, kibi kep-nip kaali, kanun-umbi disa yo. ");
INSERT INTO tif_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kipyaa! Kipkal daang ukup-nip kemin, God akal ibi daang ukuya-lomda, waasi iyo kamboya tal-ilomdip kipni abip so, lotu am awak dukum so, kiili, yam-mafak-daayokomip. Kemin, nali tituun weng kaata bokoyokomi: Ibi maso ma nitamin disa bom bi-lom iltipta boko-lom: Numi Kamokim kalawaali, God kaltapni win diim kawu tala kemin, kabi kukup tambal kaata-kup kukaayan o, naka-lomdip nita-fii-mokomip kayi! kala Yesus ayo kanum bokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","God ami iintang am ma daanule, Yesus ayo din Falosi imi kamokim ma ami am kawu tiin-bom ima im-balaya, tunum alik am kaptam tiinbip iyo Yesus ami kukup kaata ma atafiimum o, kalalip kanumipla ");
INSERT INTO tif_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","kulaa, tunum ma sikil yaan fasonsu ayo Yesus almi mepso kulu tiinba kemin, ");
INSERT INTO tif_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesus ayo atamale, lo utamsip tunum so, Falosi iso, imi aket fukunbip kaata ma utam-ilom iyo dik-daaya-lomda: Kipyo, nulmi lo kabak-ali boko-lomdu: God ami iintang am daana kaali, ibi tunum mafak-alin umuba kaa yaap dap-talalmin o, kalsu ne disa ye? yakale, ");
INSERT INTO tif_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","iyo kaal kesip lale, isiik weng so ma maan telin disa keliwa, Yesus ayo yak tunum mafak-alin umusa ayo dap-tal-fuku dap-talalu-lom dabaala almi am unala, ");
INSERT INTO tif_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesus ayo kamok kamok imi bokoya-lomda: Kibi God ami iintang am daanbu kaa kanola ibi iltipni man aa, bulumaki aa, ma kulii ok kumun tem una namti, kabi abiltap kaltapni man aye, bulumaki aa, kaa dabuu dap-taltam daalokomap e, kuno ke-lokomap e? kala dik-daayilale, ");
INSERT INTO tif_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Falosi iyo ma taang-kala ami weng ma maan telalip disa, kuno kulaa kelip ko. ");
INSERT INTO tif_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus ayo utamala, Tunum kii tala-tala-kebam ima kaa inum o, kalalip tal aba tiltam am tale-bamdip kanu-buluwa, unang tunum kiita nuyo itamik o, kalalip tal ti abiin baan tambal kiita-kup, fen-tal aba yang tiin-yaamip itaba-kup, kulaa tunum kaptam bom-bilip imi faldak-tiimin weng ma bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Dok kanolin tunum kaata ma unang kuluulon o, kalba-kup, kapni weng umuup-ta talawale, yak ima in-bom ale, fiyaap duumum o, kalala, din aba tam am unap namti, kabi abiin baan tambal kaa tiin-laamin disa; kabi ti iiwaan win dinim tunum kemin, tunum win soyim ma tolokoma ali unang kuluulon o kalba ayo ami naan-daala-lomda kabi tal abiin baan tambal kaldaaku tiinan o, anba-kup, ");
INSERT INTO tif_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","dibii-tal kapni bokop-ta-lomda: Kabi yak abiin tambalim kabaak yak tunum win soyap ami kolan aa! tokokoma kaali, kabi umbiyang imi daang tem kulu tiinale, kwin! fatom-duk-duulokomap. ");
INSERT INTO tif_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kanola kuno tunum ma weng umuup-ta-lomda: Talawa, ima inum o, taka namti, kuno din-ilomdap met wolung tem aa, balang tem aa, kulu ma tiin-yaamin taa! Kanu-mokomap kaata, mep tunum weng umuup-ta ayo tal bokop-ta-lomda: Nak-tunum kapyo, tal ti abiin baan tambal kaldaaku tiinan o, takale, kabaku alik kaptam tiinbip iyo titamiwa yi, Awu, kabi win tabin kelap kala, kala-lomdip kapni win ayo kufup-tokomip o. ");
INSERT INTO tif_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kanolin altap kemin, dok kanolin tunum kaata almi win kaali, kufuuma namti, God ali dabaala kulaak banokoma le, dok kanolin tunum kaata almi win ayo kufuumin disa kema namti, God ata mep tunum kaami win kaa kufolala, win soyap ke-lokoma kayi! kala, Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kemin, Yesus ayo kanum bokoyinba-kup, fal-siki taba mep tunum kaa weng umola tal atama ima im-bokobip ami bokola: Kabi ima tang dap-kaalon o, kalap namti, kaltapni aket fukunin kaa, Nak-tunum kusal iyo naan-daayi tal nami ima ayo inabip-kup kawu, isiik nami ima ayo tiip-nik o, kalalapla, kaltapni kaptum kusal so, kaltapni abip kasel bung kayaakal iso, kiita weng umuuyila-yaamin disa. Kanolap namti, kunolin tunum kuliita-kup kapni ima fuuyap inamnip ita-kup tiip-tokomip. ");
INSERT INTO tif_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kabak-ali kanumin daa. Kapni ima tikiyap namti tunum iiwaan so, tunum yawiit aa, tunum yaan ukum aa, tunum tiin mafak kanolin kuliita naan-daayap tal ima kaa inin o. ");
INSERT INTO tif_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kanoyap inam-nokomip. Lale, saak yak kanolin kiili, fan kapni ima kabak tiip-talalip disa te! Bom ilom tituun-kup tunum taansip imi tam tiinokomip kabaku, God ata kapni kukup tambal mep tawaal diim kalawaami kanumsap kaali, tiip-tale, kabi kulu fiyaap dukum-kup duu-mokomap o, kala, Yesus ayo kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kulaa, tunum ma Yesus aso ima im-bokobip ilmi iipyak tem kulu tunum ma Yesus ami weng ayo weng san-ilomda ayo bokola: Kamokim o. Bom bii-lom kaptoowu tunum ayo God ami abip din unale, God ami ima tini-bala inam-nokoma kaali, tunum kaa fiyaap duu-mokoma no, akale ");
INSERT INTO tif_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","kulaa, Yesus asiik weng ma faldak-tii bokola: Tunum ma ima tinimon o kalale, unang tunum yaapkan imi bokoya-lomda: Am kunolin diim kulu talemin i! yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yakalala bombe la, kulaata utama yi, Ima inin am ayo daanu kala, kalale, kulu almi okok kemin tunum ma dabaala din tunum kamosinim kawu diing kutiiyase imi bokoya-lomda: Kipyo, kulaata inin am uyo daana kemin, tilin i! kala. Katale, ");
INSERT INTO tif_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","tunum alik imi aket tem kaali, Ima falalup kayi! kala, faldak-tii kasen-fakan-bamdipla, tunum ma ayo kanum bokola-lomda: Nali ima lang ma mobi kemin, din atamdila kawu, talokomi disa kayi! Kemin, din bokolan i, akale ");
INSERT INTO tif_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","kulaa, tunum ma akal bokola: Yi, bulumaki nakalkal ma mobi kemin, din tik-tii itam-somdila yo, kalbi kemin, nali talokomi disa. Kemin, din-ilomdap bokolan o, akale, ");
INSERT INTO tif_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","tunum ma ayo bokola: Yi, nali unang ma kama-kup kuluubi kemin, nali talokomi disa kayi! kala kanum boko-boko-kelip ko. ");
INSERT INTO tif_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tunum yaapkan iyo kanum boko-boko-kelip kala, itaba-kup, asuk ok tabuumin tunum ayo tal almi tiin molin kamokim ayo tal tunum kanum boko-boko-kelip itam tala kiimi sang kaayo, bokolale, kamokim ayo tunum kanum boko-lom kolip kiimi aket atul kuuyale, kulaa asuk almi ok tabuulin tunum ayo bokola-lomda: Na, baan abiiltap bilin abip kaptam-ami liip dukum sole, liip katip katip so, kawu tal-une-bamdapla, iiwaan, win dinim, tunum yawiit, tunum yaan ukum, tiin mafak, iyo afetbi kuliilap imtal daalawa, ita ima kawol aye, kang kawol aye, tawobi kutiibi kaldaak-ata inik o, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ok fukulin tunum ayo kamokim ami weng ayo weng san-ilomda din kanoba-kup, abiltap asuk tal almi kamokim ayo bokola-lomda: Kamokim o, nali kapni weng uyo weng sandila, kanoli. Katale, am kaltam-ali abiin anung ma disa kulu bombuu no, akala, kamokim almi ok fokolin tunum ayo bokola: ");
INSERT INTO tif_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tunum unang ita taba-lomdip nami am kaltamu tiltam tale-bilip tiiknak o, kalbi. Kemin, kabi din aba langabip liip kawu kutal-fuku din langabip ma ma kawu tal-une-bamdap, unang tunum iyo ku muwa tal-unebi kuno saak-kup sisii imtal nami am kaltamu tiilawa ima so, kang awon iso, inik o, akale, ");
INSERT INTO tif_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","fal-siki taba ti almi am tunum unang tiin bom-bilip imi bokoya-lomda: Nali nikil alimal kipni weng ma bokoyon o, kalalila kemin, kamasi unang tunum imi bokoya-lomdi: Tiliwa, nami am kaltamu naso ima inum o, yikila, kela-silip kiili, nami ima kaa inam-nokomip disa. Ale, unang tunum tal nami am kaltam talbip kiptale, nami ima kaali, inam-nokomip kayi! kalan o, kala, Yesus ayo unang tunum ilom am ma daanokomu kawu, din God ami abip ima ina-faka-mokomip kiimi sang kaata faldak-tiimin weng kamun bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Am ma daanale, unang tunum yaapkan iyo Yesus aso um-bomdipla, Yesus ayo fal-siki taba tiyak unang tunum iyo itam bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Kabi tildang nami okok kemin kaa kutal-fukulon o, kalap namti, kabi talalu aket fukudapla yo, kala-somla. Kemin, kabi nami lak duu-yaamin kaata sakbaalim dukum kelule, yak kaltapni kawak-aalap imi lak duu-yaamin, kalel umi lak dakaamin, man lak aye, ilem anung maakup imi lak dakaamin, kaltapni angtiil lak dakaamin kulu kulaak banula, nami lak duu-yaamin kaata, dukum keluk o, aka. Kemin, kabi kuliili keyilalap tildang nami miit tem tal-ilomdap, nami ok kaata-kup fukulap namti, kabi nami daang bakaalin tunum kelan o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kemin, dok nolin kapta nimi daang bakaalin tunum kelon o, kalokomap kaali, tunum ayo dabak as diim daaliwa ayo angtiil yol kuluu-lomda taanokoma ulultap ke, Kuno kuluulami no, kalin dinim so, nami daang bakalap nali boko-lomdi: Kaata kanuman o, kalbi kaayo, kutal-fukulin dinim kaaso, kiiyo kanumap namti, kabi kalok no-lomdap nami daang bakaalin tunum kelamap dinim o. (Lale, kabi kabak alik kanumap namti, kaata fan nalmi daang bakaalin tunum ke-lokomap ko.) ");
INSERT INTO tif_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kabi nami ok kuu kutal-fukulon o, kalap namti, kamasi kaali, kabak-ami fiitmin kaami aket uyo talalu fuku-daa-somdapla kawu, tildang nami ok uyo tabuulon o kala-somla kemin, mep faldak-tiimin weng kala bokoyokomi kalawuuta, kipni aket fukunin kabak ayo bam-daayokomu. Kemin, ibi talalu weng san-iliwa, dok kanolin tunum ata ma am sakbaalim dukum ma delon o, kala namti, kamosinim kaali, tiin-bomda tuumon ayo ding boko utamala, Am kaami kun kulaali, tiknu ne, disa ye? kalokoma. ");
INSERT INTO tif_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ale, ayo moni ding bokolin disa kela namti, am kun kiita-kup molile, tuumon uyo disa kelamu no, kalala kulaalokoma kaa, unang tunum alik iyo atam-ilomdip aban den-bam ale, atafiimin weng bakaan-bam ke-bam ale, ");
INSERT INTO tif_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bokolip: Tiyak tunum kaa daa atamin! Ali am dukum ma delokomi no, kala-lomda dinan-umba. Yale, tuumon kaa disa kenbu kemin, tunum kaa am kaa dela dinimnu kulaalokoma disa te! akokomip o. ");
INSERT INTO tif_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kanolin tap kemin, kamokim ma ayo weng selaya boko-lomdip: Waasi dinin ilmi kamokim sole, twenti tausin (20,000) ita tal numi kamokim aso dinan-tabum o, kalalip talabip kayi! kalokomip namti, ami aket fukunin uyo tambal ma talalulin disa yo, kalale, tunum ten tausin (10,000) kiita-kup baa kulin daalip aso dinan-tabokomip ema? Disa. Kamasi akal kaptoowu tiin-bom aket fukun-bamda almi tunum iso, iyo ding boko, Awu, ti waasi dinin imi kamokim aso, almi dinin tunum iso, dinan-tabokomup kulaa ti, nuta nuta ke-lokomup o, kalale, kulaa dotu afet daa kutiilokoma no. ");
INSERT INTO tif_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aa, kanola utamala yi, Nuli tiiknamup disa yo, kalokoma kaa, waasi tunum kiili, samaan kawu talabip o, kalokoma kaa, almi kalaan yim-baala unemin tunum iyo yim-baala din waasi imi kamokim ayo bokolip ko: Kapyo, numi kamokim ata yim-baala tal bokop-ta-lomdup: Dinan-kulii-tabokomup disa; kemin ale, disa weng kaata-kup, talalu-lomdup kelum o, kalokomip o. ");
INSERT INTO tif_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kanolin tap kemin, kabi tildang nami ok fukulon o, kalap kaa, kamasi kawu talalu aket fuku-daa-somdapla kawu, kapni mafek mafek so, kaptum kusal iso, iyo alik keya-somdapla kawu, tildang nami miit tem tilin disa kelap namti, kabi nami daang bakaalin tunum ke-lokomap disa yo, kala ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesus ayo faldak-tiimin sang ma boko-lomda kanum bokola ko: Yol kaali ti mafek mafek tambal abaal-kup tabasa. Lale, kanola kaami titil kaa disa kelu namti, dok kano dotuluwa, asuk yol kaa titil kaa kuluulokoma ni? Kabak-ali atin disa te! ");
INSERT INTO tif_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yak yol abaal dinim kesu uyo binalu daak tawaal tambal diim abam-nokomu namti, yol ta taba-lomdu tawaal kaa dong dokolokomu disa; ku-mafak-daalu, titon san tabokoma disa kemin, kulaala saak banokomu no, kala-som ale, kuno bokola kipkal talang tem sole, nami weng kala bakayinbi uyo talalu weng selin o! kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tunum takis kaamin sole, tunum kukup mafak kutal-fukulin iso, iyo tal Yesus ami mepso kulu tal-ilomdip, ami weng kaata weng san-kaamipla, ");
INSERT INTO tif_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Falosi so, lo utamsip iso, iyo Yesus ami aket atul kola-lom, kala weng baka-bamdip bokolip ko: Mep tunum kalawaali tunum kukup mafak kutal-fukusip kiimi aptum ke-bomdala, iso ima inan-umba no, kalbip kala, kala-lomdala, ");
INSERT INTO tif_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","faldak-tiimin weng ma bokoya-lomda: Kanola iltipni tunum ma sipsip ilmi-kup 100 kiita tiin mola laabip. La, kulaa maakup ma maaklo kela namti, sipsip aalap kayaak ayo ding bokola yi, 99 kiita-kup bom-bilip kala, kalba-kup, malo ma kiili kawu tikiinal kulu kano keyale, aptum maakup ma disa keba ami fen-tal-unebi ata-mokoma no. ");
INSERT INTO tif_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kanola atam-ilomdala, dabuu dap-tam almi nakal kun diim tii kawu kuliiya-lomda, fiyaap duun-duun dibii-tala. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","dibii-tal almi abip tal-ilomda, almi aptum kusal iyo naan-daayila, tala-tala-kelipla, kulaali bokoya-lomda: Kipyo, nami sipsip ma maaklo kelaya, fen-tal-unebi atam dabuu dabii-tali kemin, kipso naso ami fiyaap duumum o, kalokoma. ");
INSERT INTO tif_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kanolin tap, kanola nakal ibi bokoyon o, kalalila kemin, ban kemin tunum ma ami ban ayo kela-lomda aket fal-siki-lom God ami lak duula namti, abiil tikiin kasel ensel ili atin ti ami fiyaap awak dukum uyo duulokomip. Ale, mep tunum ilmi-kup 99 kiita le boko-lomdip: Nuli ban kemin dinim; tambal-kup bom-bulup kemin, dok kano-lomdup aket fal-sikilokomup i? kalip namti, ensel iyo kanubip kiimi fiyaap dukum uyo duuyokomip dinim; kemin ale, fiyaap katip sakap ma duuyokomip o, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus ayo faldak-tiimin weng ma bokoya-lomda: Unang ma uyo sisol dukum tuumon nakalkal kiita, kutal-fukulu ilom ale, maakup ma maaklo kusolu namti, uli yokon iilfo kufo-lomdu abiin sung ilol kaali, diliit-saanbi asuk ata-mokomu no. ");
INSERT INTO tif_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Atabu-kup, ulmi kayaak iyo weng umuuya tala-tala-keliple, kulaali uyo bokolu: Yi! nami tuumon ma maaklo kelula, fen-bi-lomdi utabi kemin, kipso naso fiyaap duumum o, yakan-kaa-mokomu. ");
INSERT INTO tif_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kemin, nali ipni bokoyon o, kalalila kaayu, kanola ban kemin tunum ma almi ban ayo kulaa kela-lomda aket fal-siki-lom God ami lak duula namti, God ami ensel iyo atin ti tunum kanola kaami fiyaap sakbaalim dukum uyo duu-mokomip o, kema ko. ");
INSERT INTO tif_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus ayo asuk weng ma faldak-tii bokoya-lomda: Tunum ma ayo laaba, ");
INSERT INTO tif_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ami man kiili alep kemin, niing ata aalap ami bokola-lomda: Atok kapyo, bom biilap kapni taanapla, kapni bung mafek mafek baanokomip kawu, nami malii kup-nokomip kaali ti kama kulawu nasiik kup-nawa yo, akale, kulaa fan almi bung mafek mafek iyo alap imi tokoya ko. ");
INSERT INTO tif_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kanolaya, niing ayo bom ilanali yo kaloma dinim; kulu ti almi bung kanolin mafek mafek iyo dibii kulii yak aba bilin abip samaan ma kabana. Kemin, din abip kaptamu bomdala, da kukup mafek mafek iyo kutal-fuku-bomdala, ami kanolin mafek mafek dap-tama talsa kiili, alik tinan-daala disa kelip, ");
INSERT INTO tif_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","kulaali bokon kaptam ayo ima disa ke, ol fuut am dukum ma kutaltam daalule, kulaa mafek mafek iyo dulule um-tal daala. ");
INSERT INTO tif_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kanolu utam ale, din abip kaptam kayaak tunum ma atama aso bomdipla, tunum ayo dabaala din ami bokon kawu kang imi ima waan ifamin ok kaata, tiin mo-bomda, ");
INSERT INTO tif_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","as ma kaami lap kaata, kang imi ifa-balala, iyo im-bilipla, akal kuno kuuta ma inatamon o, keba. Lale, ami ima ayo ma kolin dinim kela. ");
INSERT INTO tif_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kanu-bam ilom ale, kawu ami aket kaali, bam-daalula boko-lomda: Nami atok ami okok kemin tunum iyo ima yaapkan-kup inan-laabip. Katale, nami tal kala-laabi kaatale, ima tinap-kup bomdila, taanon o, kalbi. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","kulaa kela nalmi atok ami fanang unokomi. La, nali bokola-lomdi: Atok kapyo, nali God ami tiin diim kaayo, ban ke-bam ale, kapni tiin diim ayo ban ke-bam ken-umbila tili. Kemin ");
INSERT INTO tif_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ale, kamali kabi maso ma bokop-na-lomdap: Nalmi man o, nokokomap kaali, yaap kep-nokomu disa kemin, kuno kep-na-lomdap kapni okok kemin tunum kelon o, akokomi kayi! kal-bomda kanolin aket uyo fanang dakama ko. ");
INSERT INTO tif_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kulaa, almi aalap aket kaali, tabamnule, nalmi atok be kawu unon o, kalala tabamna. Kemin, almi aalap fanang umbabala, umbilin abip mep-mep un-kem-salale, aalap ayo atam ami aket tem kaali, olenin dukum kemsile, kulaali baan abiltap bina toop dip-tal miki weng fokola kem-salale, ");
INSERT INTO tif_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","kulaa, man ayo bokola-lomda: Atok kapyo, nali God ami tiin diim so, kapni tiin diim so, kaali, ban ken-umbila tili. Kemin, kalawaali maso ma kabi bokop-na-lomdap: Nalmi man o, nokokomap kaa, yaak kep-tu bokop-nokomap disa yo kemale, ");
INSERT INTO tif_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","aalap ayo almi okok kemin tunum imi bokoya-lomda: Baan abiltap bina din-ilomdip, atin ti ilim tambal ayo ma kulii-tal makenbip-kup, ale, sikil iling ayo ma kuluu kulii-tal sikil duung tem ayo diltoop daala-som aa, yaan ilom ayo ma kuluu kulii-tal diltoop tinela kenbip-kup, kulaa ");
INSERT INTO tif_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","din-ilomdip bulumaki man tambalim tiil abuulin ayo ma an-kulii-tilipla, fuu-bam in-bomdup fiyaap duu-bam kemum o. ");
INSERT INTO tif_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kabak-ami miit kaa dok ata naa kalolip: mep nami man kalawaali maaklo ke-lom, saaknin tap kesa. La, kamala asuk tam-tiin ke tiin kawang kela tala atamup. Kemin, ami fiyaap duu-bam inum o, kalale, fan iyo fiyaap duu-bamdip ilip. ");
INSERT INTO tif_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Katale, fik ali lang dikin-umba kemin, lang dikibi bital am daang mepso kuluba weng sena yi, Abip namti was eng sole, baal eng so, namti akal ma kebu kaa kala, weng sanba-kup kulaa, ");
INSERT INTO tif_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","okok kemin tunum ma ami naan-daala tal bokola-lomda: Kiili, kanimin fiyaap ma duu-bam kanubip i? akale, asiik bokola: ");
INSERT INTO tif_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yi! kapni niing ayo asuk ti tambal-kup tal itamala, kaalap ayo asuk dabuulala kemin, bulumaki man tambal tiil abuulin ma an-kulii-tal kufuu-bam in-bom kanubip o, akale, fik ayo weng san-ilomda ");
INSERT INTO tif_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","aket atul dukum kelu, Nili tam am unomi dinim o, kalala, kano abip daal kabaaku bom ilale, aalap ayo tiltam daak-ilomda man ayo naan-bam bokola-lomda: Tiltam talawa yo, kal-bom molale, ");
INSERT INTO tif_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","man asiik aalap ami bokola-lomda: Daa yo! Atok kapyo! Nali wasital yaapkan dakan-tii yakyak kem-tabasi kaali, kapni ok-kup tabup-tansi kaa, kapni weng bakaap-na-laabap kaa, ma kuyang saak tiip-tinsi disa. Lale, kabi meme man tambalim kaa ma aap-napla, nalmi kayaak iso tiin-bom fiyaap duu-bamdup inasup dinim. Lale, ");
INSERT INTO tif_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","mep kapni man ayo kapni kanolin mafek mafek kuliila din sadikimin kaata, kanum tal-une-bam ale, mafek mafek iyo sekela kulaala unu-tulu-ke-balala, talale, kaata kapyo, bulumaki man tambal tiil abuulin kaata aalap o? ke-bam aalap bakaalale, ");
INSERT INTO tif_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","aalap asiik bokola-lomda: Man aa, kabi suunkup alim maakup laabup kemin ale, nami mafek mafek kulaa ti alik kaltapni te! ");
INSERT INTO tif_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kanola niing ayo maaklo ke-lom saaknin tap kesa. La, kamala kulu tam tiin-ilom tiin kawang kela talala, atamup kemin, kaata fiyaap duumum o, akan-kaamsa no, kala Yesus ayo kanum bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus ayo faldak-tiimin weng ma alami daang bakaalin tunum imi bokoya-lomda: Tunum bung kayaakim ata okok kemin tunum ma ulduulila, ata taba-lom bung mafek mafek so, ok fuku-yilin tunum iso, iyo tiin molak o, kalalala, ayo ulduula. Lale, tunum kusnum iyo tal mafek mafek soyap ami bokola-lomdip: Yi, kapni bung tiin molin tunum kaali, kapni mafek mafek kii ma talalu tambal-kup ma tiin moba disa kemin, almi kayaak iyo tale-bilipla, masiim kuluu kukaayinba kayi! akipla ");
INSERT INTO tif_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","kulaa, bung tiin molin tunum ayo weng umola tal atamale bokola: Kabi kukup mafak so nema, ke-balapla, unang tunum iyo weng bakan-una-tala-kemip weng sani kaa, kabi kabak kanimin ma nuu-balawa yi? Kanubap kaa kalalila, kabi kamala kulu tam-kan-tiilila kemin, kabi asuk maso ma nami mafek mafek iyo ma tiin mop-nokomap disa. Baan ti unin disa ilomdawa, ti kamala kulawu sukon ma kuluu nami mafek mafek kanobap kaami win kaa, dolbi kutiile kuliip-na talap tii atam, Awu, dok nolin bung kiita tambal bom-bilip aa, dok nolin kiita disa kebip kaa kalon o! aka ko. ");
INSERT INTO tif_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kala kanum bokola, bung tiin molin tunum ayo aket fukunbi bokola: Yi, nami kamokim ayo nam-kan tiilon o, kala kabak-ata dok nolokomi ma? Nali titil so foko-lomdila, tawaal dikilmin kaami ok kaa ma ke-mokomi disa le, aa fatom kemin, nak-tunum kusal imi ima sang kaa nen-daayokomi disa. ");
INSERT INTO tif_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ayo! Kulu nali aket fukunin tambal ma utami kayi! Nali nak-tunum kusal iyo kamokim ami maan anung ayo kuluu kuya kuya keli salala kawu, nami ok ayo dinimnu kewa-somdila disa kawu ilokomi. Nak-tunum kusal isiik fiyaap duu-bamdip nam-tama din imi am daa-lom iyo nami tiin molin o, kalale, ");
INSERT INTO tif_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","kulaa, kamokim ami bung tiin molin tunum ayo tunum alik ita kamokim ami maan kuluu-silip iyo naan-daaya-lom bokoya-lomda: Ibi kamokim ami maan kensip ayo maakup e kala asiik tal mo una-una-kemin o, yaka bom-balala, dusiin daalin tunum asiik tal atamale bokola: Kabi kanim kal kaata kamokim kaa maan telokomap i? akale, kulaa asiik bokola: ");
INSERT INTO tif_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yi, nali as lap oliv ok ket ulmi-kup 100 kiita maan telokomi no, akale, bung tiin molin tunum ayo bokola: Kabi yak maan kunolin alik kiili, kamokim ami alik tela-laamin disa; baan tal tiin-ilomdap kaltapni sukon (tiket) falduup-tasi kaata, kuluu-lomdapla, dolmin fal-siki-lomdap oliv ok ket 50 kiita-kup, kaltapni win ayo dola ke-lomdap oliv ok ket 50 kiita-kup telan o! akala, ");
INSERT INTO tif_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","fan, maan kaa anung-kup tela-lomda unale, kuno tunum ma asiik tal tiin molin tunum ayo bokola-lomda: Aa, kabi yi? Kanim kal kaata kamokim kaa maan telokomap i? akale, ayo bokola: Nali wiit bek almi-kup 100 kiita maan telokomi no, akale, bung tiin molin tunum ayo bokola: Maan kaa alik kamokim ami tela-laamin disa; baan tal tiin-ilomdapla, kaltapni sukon falduup-tasi kaata, kuluu dolmin kaa fal-siki-lomdap bek ulmi-kup 80 kuliita-kup, kaltapni win ayo dola ke-lomdap 80 bek kiita-kup telan o, akale, fan maan anung kiita-kup tela-lomda una ko. ");
INSERT INTO tif_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mafek mafek tiin molin tunum mafak ayo almi kamokim ami kanumin mafek mafek iyo kanubi tinan daa kutela. Lale, mulo kawu almi kamokim ayo utama yi, Mafek mafek tiin moyilin tunum ami fiyaap dolin disa la, mafek mafek tiin molin tunum almi angtiil lak duu-bom tambal tiin-yaamin kaami aket kaata-kup fukun-bamdala, kanolin kukup kaa kanonba kala, kala-lomdala, almi mafek mafek tiin molin tunum mafak ami win ayo kufola no. Kemin, kamokim ami tunum mafak kaami win kufolin kaa dok kabak-ata daa kalolip: Tawaal diim kalawaami unang tunum ilmi okok kemin kaami aket fukunin kaata, kuluu-lomdipla mamdet kuyak daa-bom okok ke-bamdip, unang tunum God ami falala-kalin diim bom-bilip ita, kulaak baniwa keyinsip te! ");
INSERT INTO tif_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Weng ma bokoyokomi kemin weng san bom ilipla! Kibi tawaal diim kalawaami ilip kaa, bung aye, yak tuumon aye kii, kuluu-lom unang tunum kii tambal-kup dong dakaayin-bam ale, naan-daayip tal iltipni am tilipla, tiin saan-bam kamayin-biliwa, ili ti iltipni kaptum kusal tituun alik-daap kelin o. Kemin, bombii ibi yaap-kup tawaal diim kalaami tuumon aa, mafek mafek tambal aye, kulaa disa keliwa kawu, God ami suunkup ilin abip unokomip kaata, God akal bokoya-lomda: Yi, ibi ti nalmi naktum kusal o, yokokoma no. ");
INSERT INTO tif_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kemin, kamokim ayo almi ok ayo kulaala yak almi okok kemin tunum ami sikil diim unula, ali ti tambal-kup okok kema namti, almi kamokim ayo utamaya, Ti tambal-kup kanum taba kala, kala-lomdala, ayo fiyaap duu-mokoma kaata, ok dukum kaata-kup kolaya, okok ke-mokoma no. Ale, almi kamokim ayo, Ok katip kaata, koli mafak nuuba kala, kalalala, ok dukum kaata, koliya, ti kanu-mama no, kalalala kemin, kolokoma disa. ");
INSERT INTO tif_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kanolin tap kemin ale, kipni mafek mafek tawaal diim kala bom-bilip kiili, kuluu-lomdip tambal-kup tiin molin disa kelip namti, God ami okok kemin dukum uyo binala yak ipni sikil diim abam-nokomu nema? Daa. ");
INSERT INTO tif_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ibi tunum kusnum imi mafek mafek kaa talalu tiin molokomip disa kaali, God ami mafek mafek kulaala yak iltipni sikil diim abamnula, iltipni ke-lokomu nema? Disa. ");
INSERT INTO tif_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tunum kawanta kamok alep kiili, ma ami ok fuku-som, ale, ma ami ok fuku-som kemon o, kala namti, ali taang-kala-lomdala kamok alep imi ok kaa fuku-mokoma disa; kanola tunum ayo God ami okok kemon o, kala-lom, ok tabuu-bam moni kaama namti, God ali daang ukolale, moni kaami aket kaata ti dukum kukaayokoma. Kemin ale, tunum kaa kanta God ami aket-kup kola-lomda, God ami wok kaata talalu yikik fukula namti, moni kaamin kaami aket kaa, ma fanang daalokoma disa; ibi titil-foko-lom taang-kala God so, moni so, alep kiimi aket kii aalu ilokoma disa yo, kalala, ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falosi ili ti moni aket-kup yesula, Yesus ami kanolin sang bakayinba kaali, weng san-ilomdip isiik atafiimin weng uyo bakaliple, ");
INSERT INTO tif_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus ayo itam bokoya-lomda: Ibi unang tunum imi tiin diim kaata, kukup tambal kaata kutal-fuku-bom-buluwa, unang tunum iyo numi win kaa kufuyik o! kem-tabasip. Lale, God akal itama yi, Kipni aket aa, fanang aa, iyo tambal e mafak e ken-umba. Kemin, tunum unang ili kipni kunolin kukup kulaami win kulaa bakan-tabasa. Lale, God almi tiin diim kawu kanun-umbip kaali, ti kukup mafak kutal-fukusip kaa, tang tabin mafak dukum o. ");
INSERT INTO tif_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sawaalak kawu, Moses ata God ami Lo kuka-daasa kaali, dola kutiilale, God ami weng ku-fatap-daa bakayin tunum yakal God ami weng uyo dola-lom keliwa, uyo bokoya-lomdu: God ami weng alik kaali, yikik kuyak aket tem daa-lom kutal-fukulin o, kalaya, yakal kutal-fuku-bomdip man loop dip-tiilip tam tam tabasula, oksam ukaayin tunum Jon namti tildaak talsa. Yale, kamala kulaata Jon so, nami daang bakaalin tunum iso, yakal ale, nakal nuta-kup unang tunum imi weng tambal kaali, bakayin-bamdup: Kipni aket uyo fal-sikilipla, God akal kipni iliim kaali, boya-lomda yim-tama tildang almi miit tem tiilak o, kala nikil nuli bakayin-bulupla, tunum unang yaapkan iyo tildang God ami miit tem tulum o, kala-lomdip nikneka talabip. ");
INSERT INTO tif_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kemin, God ata unang tunum imi iliim boyokomi no, kalba kaali, am ma daanon o kalbu. Lale, God ami Lo uyo dinim kelin disa bombuu kemin, am mafiing diim daanokomu kawu, tawaal so, abiil so, kiili disa ke-lokomip. Katale, fan God ami Lo alik kuutale dinim-nokomu disa; ti kano suunkup ilokomu no, kala bakayinsa no. ");
INSERT INTO tif_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yesus ayo asuk bokoya-lomda: Kanola tunum ma ayo almi kalel uyo kewa-lomda, yak unang kusnum ma kuuta kuluula namti, God ami tiin diim kaa kaami kanolokoma kaali, sadikin-tal-unemin tunum o, kalokoma. Kemin, kano ti tunum ma akal aptum ami kalel kewa-lom fotabasa kuuta kuluula namti, God ami tiin diim kawu ami kanolokoma kaali, sadikin-tal-unemin tunum o, kalokoma no, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus ayo faldak-tiimin weng ma bokola-lomda: Sawaalak kawu tunum bung kayaakim ma ti tambal-kup tiin bom ale, okok kemin disa; ti disa kulu tiin-bomdala, suunkup ilim tambal tambal akal alik akal alik kiita-kup miki-bam ale, ima tambal tambal kiita-kup in-bom ken-umba. ");
INSERT INTO tif_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Kemin ale, kulaa tunum iiwaan ma ami win kaali, Lasarus ali aptum kusal iyo dap-tal bung kayaakim ami amitom daalip unip bom bii, un-un-ken-um-bala, suunkup akan-uni kawo! kala, medaak aba bom bii un-un-ken-umba. Kemin, ayo fen-bam utamala yi, Bung kayaakim ami ima in-bomda ima bam aa, ima anung binalip saak unebip kiita talaala, Bom-bilip kala, kalba-kup, kulaa ayo ima tinap kenbu kemin, kiiyo kuluu ina-ina-ke-balale, ami angtiil kaali ti abang ta disa akal ma kensa. Kemin, miyaan yaapkan ita tal ami abang iyo falang atalip ko. ");
INSERT INTO tif_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bom ilomda ayo taanale, ensel iyo tal tunum iiwaan ami sinik ayo dabuu dap-tamalip din abiil tikiin daalip, Abraham aso bom biliwa, bom ilom kuno bung kayaakim akal taana dawaaliple, ");
INSERT INTO tif_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ali din as kiinin abip kawu bomdala, angtiil yol awak uyo kuluu-lomda titam daala yi, Abraham namti bitam samaan kawu bombe kala, kalale, Lasarus ali Abraham aso bombe kala, atama ko. ");
INSERT INTO tif_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tiin kawang-bomda bung soyap ke-bomda biisa ayo naan-taba-lomda boko-lom: Nalmi awaalik Abraham kapyo! Nali as dawang tem diin-bomdila, nami angtiil ayo kiin tal faal-faal-balala, angtiil yol dukum ayo kamap-na talababa kemin, olen-daap-na-lomdap, kabi Lasarus kulaa dabaalap tal-ilomda sikil diil diim ok katip ma kulii-tal-ilomda, kuyak nami falang kiin-bokoba kulaa abop-na diis-nak o, ke-bamda naan daalale, ");
INSERT INTO tif_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham ayo bokola-lomda: Nalmi man kabi ti aket fuku-daatam. Siin kaa, kabi tiin kawang bom ilsap kaali, kabi mafek mafek tambal tambal kiita-kup kaa-balaple, Lasarus alile, saak mafek mafek mafak kiita-kup fakan-umba. Kemin, Lasarus ali abip tambal kuluu bomda fiyaap dukum duuba. Kemin ale, kuno kapta angtiil yol awak uyo kuluubap te! ");
INSERT INTO tif_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ti kukup akal alik ma namti kala bombuu kaa daataman, God ali ok bukung dukum ma kala bikisa. Kemin, kuno yakal yak malii kuluunip nokol tildak malii kuluunup kesup kalaali, tunum tildak malii kaldak bom-bilip kaliilile, yak malii unum o, kalokomip. Lale, ili dok kano taang-kala-lomdip yak malii unolip disa; kuno yak malii tunum kabaak bom-bilip yakal tildak malii tulum o! kalokomip. Katale, yakal dok kano-somdip kanim diip tildak malii baa tololip daa! aka ko. ");
INSERT INTO tif_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Kanolin kemin o, akale, siin bung kayaak ke-bom biisa asiik bokola-lomda: Nalmi awaalik kapyo, nali weng ma dik-daap-tokomi. Nalmi nakal awakal ili nalmi atok ami am kaptamu bom-bilip kemin, yakal kanola tal angtiil yol awak dukum kuluu-laamin abip kalaba tololip kemin, kapyo, dik-daap-talila, Lasarus kulaata dabaalap daak-ilom bokoya-lomda: Yi, kipni tiing ami bomda kukup mafak mafak kem unan-soma ulultap kaa, Ibi kanumin disa yo, kalala, kanum bokoyak o, akale, ");
INSERT INTO tif_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham asiik bokola-lomda: Aa, Moses sole, God ami weng ku-fatap-daa bakayin tunum iso, ita God ami weng ku-fatap-daa-laamin kaali, God ami Sukon Tem kabaku dolsip. Kemin, kuyak ata kapni nakal iyo ti yaap weng sanamip te! akala, ");
INSERT INTO tif_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","fan bung soyim ke-bom biisa ayo bokola: Daa yo. Ti awaalik Abraham kabi ti kano weng san ilawa, nami nakal kiili, God ami Sukon Tem weng uyo weng sanamip dinim. Lale, ti tunum taansa kaata, kom tem kawu tam tiin-ilomda din God ami Sukon Tem weng uyo bokoyokoma kaata, fan imi aket ayo fal-siki-lom yak kukup mafak nuumin kaali, kulaalokomip o, akale ");
INSERT INTO tif_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","kulaa, Abraham asiik bokola: Kuno kapni nakal ili Moses so, God ami profet imi weng so, iyo weng san-kaamin disa ken-umbip namti, kanola tunum siin kawu saaksa ata kom tem kawu tam tiinda din bokoyokoma kaali, kanolin tunum ami weng kaa, weng sanokomip dinim o, kala kayi! kala Yesus ayo faldak-tiimin weng kaali, kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus ayo almi daang bakaalin tunum imi bokoya-lomda: Kukup mafak uyo tiltam aba-lomdu unang tunum imi aket fukunin kaa ku-mafak-daayulula, yang bun-alomdip ban kem-tal-une-mokomip. Yale, tunum kaa dok kanolin tunum kaata, kukup mafak ke-balala, aptum kusal iyo atamiwa yi, Awu, ali kanuba no kalbip-kup, kulaa yakal ban ke-bam God ami lak duu-yilin uyo kulaa kela yang banip namti, God akal mep tunum ayo angtiil yol kaa kolokoma. Kemin, ibi kuu talalu utafii-bamdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kanola kayak kayak ili utamiwa yi, Tunum kaa kanolon o, kalba kala, kalokomip uyo ili taba-lom tuum dukum ma kuluu-lomdip kuyak tunum kaami kalum kun diim kabaku sok de-lom dabaalip daak yol ok kumun tem una namti, mep tunum kaa saaknala, bi-lom kawu God ayo angtiil yol katip ma kaata-kup ami kolokoma. Kemin ale, tunum ali taba unang tunum God ami lak dakaamin katip katip kebip imi yam-mafak-daala ban ke-lomdip yang banip namti, kulaa God akal taba-lomda kabak-ami du tiim o, kala tunum ayo angtiil yol awak dukum kaa kolokoma. ");
INSERT INTO tif_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kemin, kabak-ali iltipni kukup kabak-ata talalu utafii-bamdiwa kayi! Kapni kap-tunum ayo kapni mafek mafek ma ban kep-ta kaa kabi boko-lomdap: Kabi maso ma kanumin disa yo! akawa, ami aket uyo fal-sikila namti, kabi ami ban kep-timba kaa, kuno kambolalap. ");
INSERT INTO tif_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kanola am maakup ma daana kuyaku kapni ban kamap-tin-bi-lomda asuk ti suunkup tal bakap-tam-bamda: Kapyo, nami kukup kaa kanup-tambi kaa ti mafak o, kali kemin, kuno kulaali no, kem-una namti, kapkal ami kukup mafak kanup-tamba kaa, lukup-ta kela-laamalap kayi! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesus ami kalaan tunum iyo bokolip: Kamokim kapyo, kapta dong dokoyilawa, numi God ami lak dakaamin ayo dukum-nuk o, kala kanum bokoliple, ");
INSERT INTO tif_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kamokim ayo bokoya-lomda: Kanola, kipni God ami lak duu-laamin kaali, mastat almi san alaltap katip sakap ke-lomdip God ami dik-daalip namti, akal dong dokoyilala, as ma bokola-lomdip: As kabi timtim so dola kutamalap daak yol ok kumun tem aba-lom tolnan o! kalokomip kulaa, fan God ali kipni weng kulaata-kup weng seya-lomda as ayo bokolale, timtim soyim dola-lomda din yol ok kumun tem kawu tolna uta-mokomip o, kala Yesus ayo faldak-tiimin weng kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesus ayo bokoya-lomda: Tunum win soyim ami disa iip okok kamaalin tunum kaali, din langabip din-ilomda fiitbi ok fakabi talale, yak kang imi tiin mo-bala bom bii am tiinu tala kaa, tunum win soyim kaa boko-lomda: Baan abiltap siin din kaltapni ima kaasiik fuu inalapla yo! akokoma nema? ");
INSERT INTO tif_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Disa! Kuyak kanum bokolokoma disa. Kemin, ayo bokola-lomda: Kamasi kaali, nami ima kasiik talalup-na-lom ifop-nap im-bilile, mulo kaata kaltapni ima ayo talalu-lom fuu inamnan o, akokoma. ");
INSERT INTO tif_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Disa iip okok kamaalin tunum ali ti almi tiin molin tunum ami weng kaata-kup weng san din ami wok-kup, fukubi tala. Lale, ali almi tiin molin ayo, Ami yaap ke yo, kala, atin kukup tambal uyo kolokoma disa. Kemin, almi okok keba kaami sisol kaata-kup kolokoma. ");
INSERT INTO tif_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ultap kemin, ibi God ami okok kamaalin tunum kemin, God alta bokoya-lomda: Ibi kala nolin ok kala, kuyi kaata-kup nuu-biliwa yo! yakala, kanu-bilip bii dinimnu namti, iltipni win kaa kufo-bam boko-lomdip: Numi ok tambal kanun-tabasup kabak-ata talalu utam-ilomdap numi win uyo kufoyin-bam yaap ke yo yakan-kaaman o, kemin disa; ti boko-lomdip: Nuli fan ti disa iip okok kamaalin tunum kemin, numi suunkup ok tabuumin kaata-kup ti kanun-umbup o, kemin o! kala kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus so, almi daang bakaalin tunum iso, nikil iyo Jerusalam kaptam banum o, kalalip din liip ma din kaba-lomdip, Provins Sameria ku kabak daa, mep Provins Galili kuu kaldang daa, ke iip-iip kuyak liip ");
INSERT INTO tif_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","nikil wan din abip ma kamolipla, kulaa tunum nakalkal ma dikik-fukusip iyo tal Yesus atamum o kalalip tal-ilom, mafak-umusip ilmi kukup kanun-umbip kaata-kup no-lomdip daa samaanlo kabangu tolale, ");
INSERT INTO tif_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","weng kaata-kup fak tildang daa naan-bam bokolip: Kamokim kapyo, numi olen-daaya-lomdap numi angtiil mafak kalanosup kulaa dong dokoya dotu-yimulan o! ");
INSERT INTO tif_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","akan kaamiwa, Yesus akal fan imi angtiil mafak uyo uteyila-lomda ayo bokoya-lomda: Ibi din-ilom awem tunum imi diim kawu ipni angtiil uyo kukuyilipla, iyo utam-ilom boko-lomdip: Ipni angtiil uyo tambalnu no, kalipla kawu, unang tunum iyo weng san-ilomdip fiyaap duumin o, yaka. Kemin, kanum bokoyilala, Yesus ami weng kaata-kup weng san-ilomdip liip kulu unan-siliple, imi angtiil kaa, yaap tambal-kup ma keyulule, ");
INSERT INTO tif_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","kulaa nikil unabip iyo tunum maakup ma akal ata utamala yi, Nami angtiil uyo tambal kep-nu kala, kalala asuk tal-bomda dukum-kup God ami win ayo kufola tal-bom ");
INSERT INTO tif_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","lamo daak Yesus almi miit tem kuluba-lomda, tilik duung fakela daak tiin-ilom, Yesus ami, Yaap ke yo, aka ko. Tunum kaali, Sameria kasel kiili, Juda imi waasi kemin. ");
INSERT INTO tif_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesus ayo almi daang bakaalin tunum kuliiso, maakup imi bokoya-lomda: Tunum maakup kalawaata-kup tala. Katale, tunum nakalkal yam-talaluli katale, tunum bitikal kiili yi? ");
INSERT INTO tif_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tunum bitikal kiili kanimin o, kalalip tal God ami win kaali, kufolin disa kulaalip tabanipla, Juda numi waasi Sameria kayaak maakup kalawaata-kup talda God ami win kaa kufon-bam yaap ke yo, keba ni? kala-lom ");
INSERT INTO tif_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sameria tunum ami bokola-lomda: Kabi nami weng kaata weng sandap utamawa yi, Fan ali yaap kanolama no kalbap kala, kala-lomdila kulu kapni aket tem kabak aso talalu-tamuli kemin, tam tola-lomdapla tambal-kup din bom-balawa yo, kala kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Falosi malo ma iyo tal Yesus ami dik-daala-lom bokola-lomdip: Dok kanumin diim kawu God ami tunum ulduula Kamokim kesa ayo dabaala tal-ilomda, Rom ita numi tiin mosip kaa, tal-ilom tildaa yim-baa-lom tiin molokoma yoko? akiwale, asiik bokola: God ami tunum ulduula Kamokim kesa tunum kaami tal tiin molokoma kaali, fatap kulu tiin tiyak daa atam-laamin kaami mafek mafek disa te! ");
INSERT INTO tif_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ali tal abip maakup ma kaptamu bomdala ibi tiin molokoma disa ale, ami tiin molokoma kaali akal alik. Kiwe! Ali tal-ilomda kipni aket tem kabaku bomdala, ibi tiin saanokoma no, kala-lom, Falosi imi bokoyimba-kup kulaa, ");
INSERT INTO tif_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ayo fal-siki taba alami daang bakaalin tunum iyo bokoya-lomda: Am ma daan tiltam talokomu kaali, tiin-yaamin am mafak ma tiltam tabokomu kemin, ipkal talalu utamiwa yi, Dok kanumin diim kabaku Dukum Ami Man Nayo, asuk talokoma kaa kalum o, kalokomip. Lale, ibi ti disa maaklo kawu fenokomip. ");
INSERT INTO tif_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mep tunum unang malo ma ita ipni bokoya-lomdip: Yak tunum kula bombe kulaata God ami ulduu-dabaala talse no, kaliwale, tunum unang malo ma ita boko-lomdip: Daa. Kakaa disa. Kalawaata God ami dabaala talse tunum namti kala bombe no, ke-bamdip; kasen-faka-mokomip kemin, ibi imi weng kaa weng sandip din itamum o, kemin disa yo. ");
INSERT INTO tif_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dukum Ami Man Nami asuk talokomi kaa kanolala kawu talokomi disa. Baabaa maak ma dabaa falala-kup kalala, am bokon alik abiil so, maakup wii-falala-kup kala-laaba tap kelila, fatap-kup kuyaku talokomi. Kemin, kuyaku unang tunum alik iyo nita-mokomip. ");
INSERT INTO tif_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yale, din abiil tikiin unin disa bom ilila, unang tunum kamala kula bom-bilip kalawiili, daang ukup-na-lomdip kukup mafak kaata, kukaap-nam-bilipla, angtiil yol awak uyo kuluu-lomdila unokomi ko. ");
INSERT INTO tif_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nami unokomi kaali, asuk tilin disa bom-ilila, unang tunum kiili, sawaalak Noa ami sip awak sakbaalkan dina-balala, unang tunum imi kanolin kukup kanumsip ultap kanu-bam kanu-mokomip. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa ami sip dina-bisa kaa, unang tunum alik ili (God ami lak uyo dukum-kup duu-bomdiwa disa; ti tawaal diim kalawaami mafek mafek kiimi aket kaata ti dukum-kup duu ilsip. Ili yaap bom-bulup o kal-bomdiwa) kasen-foko ima in-bom ale, unang aa tunum aa iyo dan-kaa-bamdip ok ke-bamdip kanu-biliwa, bombii sip uyo alik ditang-kala dinimnule, Noa alimal iyo tam sip tem uniwa, abiltap maak fak-daalin tap, ok ayo alala tiltam-ilomdu, unang tunum iyo alik im-baak-molu mam bapliiya-lomdu alik kuliila tabasip. Kemin, kanumin siim o kanola nakal abiltap-siik talokomi kayi! ");
INSERT INTO tif_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kanolin kemin, nami unokomi kaali, asuk talin disa kalo bom ilila, unang tunum imi siin sawaalak Abraham ami niing ami man Lot kaami bom-balala unang tunum kiimi kukup kanu-bisip tap ke-lomdip kanu-mokomip. Kemin, Lot ami bom-balala, abip Sodom kasel unang tunum alik imi God ami lak kaa duulin disa; ti tawaal diim kalawaami mafek mafek aket dukum-kup yesu. Kemin, Nuli yaap bom-bulup o, kal-bomdiwa; disa kulu ima im-bom, mafek mafek san-bam ale, am lang diki-bam, ke-bam biliwa biile, ");
INSERT INTO tif_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot alimal iyo abip Sodom ayo kambolalip tabanipla kulu, abiil kaptamu maak fak-daalin tap as kiinba sole, tuum mangsip so, iyo om manin tap ke-lomdip, tildaak tunum unang iyo alik fuulipla taansip. ");
INSERT INTO tif_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dukum Ami Man Nami asuk tiliya kawu, alik nata-mokomip kaali, kanola unang tunum kii God ami lak kaa talalu dukum-kup duu-laabip disa; ti tawaal diim kaldaak-ami mafek mafek aket kiita dukum-kup duu-bom ilipla, nali talokomi te! ");
INSERT INTO tif_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kemin, nami am daanokoma kaali, tunum ma almi abal akiim tiinba ayo asuk tam am aba-lom almi bung kaptam bom-bilip kiiyo duk-duu kulii-tiltam banemin disa; almi bung alik kiili ti maas kutii keya unokoma. Kanolin kemin, kanola tunum ma ayo almi langabip kawu bomda lang dikiba kaali, asuk din am kaa un-ilom bung duk-duu kulii-unemin daa, kela wakadaa unak o. ");
INSERT INTO tif_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kemin, siin sawaalak kawu, Lot ami kalel uyo abip kaptam-ami mafek mafek kela tulu kabak-ami aket kaata, disa akal ma kewalala asuk fal-siki taba ti daang tem daalamu daa, as mamin kaata uyo umfuulala, taansu kabak-ami aket kaata talalu fukun-bamdiwa yo, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dok kanolin tunum kaata ti almi angtiil-kup mok im-bomda ila namti, ali taan-ilomdala, maaklo ke-lokoma le, aa tunum kanta ma almi angtiil lak kuuli, duulin disa maas kewa-lomda nami aket-kup kup-na bomda, nami ok kaata-kup kulii-taba namti, kaata suunkup ilokoma no. ");
INSERT INTO tif_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kemin, nali weng ma bokoyokomi kaali, nali kutamiip tili namti, abiin maakup ma kabaaku tunum alep iyo akan bom-iliwale, ensel iyo tal-ilomdip ma ata dabuu dabii-un-bomdiple, ma ata kuno kela unokomip. ");
INSERT INTO tif_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kanolin tap nakal am daanin diim tili namti, unang alep ma ima fuumum o kalalip kama num-siliple, ensel iyo tal-ilomdip ma uta kuluu kulii-un-bomdiple, ma uta kuno kewa unokomip o. ");
INSERT INTO tif_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kanola nimi talokomi kaali, tunum alep ma ima lang diki-bam ilipla, ensel iyo tal-ilomdip, ma kaata dabuu dap-tama un-bomdip, ale ma kaata kuno kela unokomip o, kal-bomda Yesus ayo almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kanum bokolale, daang bakaalin tunum iyo dik-daalip: Kamokim, kapyo! Doku kanu-mokomu ni? akiple, Yesus asiik bokoya-lomda: Kabi utamawa yi, Awon filfil yaapkan iyo sak fun una-talabip o, kala itamap namti, kaptam-ali tunum ayo taanba ami as kuli kaata bom-balaya kemin, kanubip o kalokomap. Kemin, kanolin tap ti ipkal utamiwa yi, Mep nami mafek mafek sang kaali, kaa tiltam tabu kala, kalokomip o, kulaata utamiwa yi, Nami talokin uyo mep dikipnu no, kalokomip kayi! kala, ayo bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ayo almi daang bakaalin tunum imi bokoyilala, daal tabe-bam God ami beten kemin uyo kuno kela-som kemin disa; suunkup ti kanu-biliwa, God ayo imi beten weng kaali, akal maan tiiyilama no, kala-lomda ayo faldak-tiimin weng ma bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Abip ma kaptamu tunum kot weng san-kaamin tunum ma bombe. Kemin, ali God ami atul ayo suunin disa ke-bamda, ami weng uyo weng san-kaamin disa ke-bam ale, ali aptum kusal imi aket kaa ma kuyima disa ke-bam laaba. ");
INSERT INTO tif_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kuno abip kaptam-ali unang kaluun ma tiinsu. La, uli ti suunkup tal weng talalmin tunum ami fanang-kup tale-bamdu dik-dakaala-lomdu: Nami waasi ayo nam-mafak-daalon o, keba kaa dong dokop-na-lom, tunum kaa lekbi dabak-molawa kep-nak o, kal-bomdu bakaalu ko. ");
INSERT INTO tif_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Akan-kaa-bulula, kamosinim kaali, weng talalmin tunum ayo dong dokop-nin dinim ken-umba. Kata, bom-ilomda, kaata aket fuku-daa-lomda: Yi! Nali God ami atul kaa ma suunin disa bom ale, aa mep unang kaluun kuumi angtiil lak kaa ma duu kemin disa kanubi. Katale, ");
INSERT INTO tif_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","unang kaluun kaa tal dik-dakamin-kup kem-tabasu kaa, nali daal dap-tiip-nansa kemin, nakal kabak talalu-walila, kambop-nu ilon i, kala Yesus ayo faldak-tiimin weng kaa kanum ");
INSERT INTO tif_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","bokoyilale kulu, Yesus ayo weng faldak-tii-lom bokoyila kaami miit ayo ku-fatap-daa bokoyila ko: Kibi weng talalmin tunum mafak kaami weng uyo weng sanip taa! ");
INSERT INTO tif_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Ali saak tunum mafak la, ali unang kaluun umi weng ayo weng sewa te! Ale, God ali ti atin tambal-kup tabasa. Kemin, alta almi unang tunum ulelsa, imi weng tambal kaata-kup weng san-kaa-bam laaba kemin, bokoyokomi kemin, weng san iliwa. Tunum unang ili kutamiip so, taap so, beten kemin-kup laabip kaali, God ali keya-laamin disa; ali abiltap tambal-kup dong dakaayin-bam laaba. Kemin ale, Dukum Ami Man Nayo, nami din abiil tikiin din abali asuk tal tawaal diim kalaba talokomi kaali, nali utamila, God ami unang tunum yaapkan ili God ami lak duu-bomdip kutamiip so, taap so, beten ke-bam bom-laabip o, yokokomi ne disa ye? Daa. Malo ma ita yang banokomip. Kemin, nikil kibi nami bii asuk talokomi kaami aket kaali ti, fuku-daa God ami lak ayo talalu yikik-kutal-fuku naan-biliwa yo, kal-bomda bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tunum malo ma ilmi aket-kup fukun-bamdip, Nuli ti tituun-kup tibin tunum ale, nak-tunum kusal malo ma ilile, tituun-kup tabin tunum disa yo, kebip kala, kalba-kup, Yesus ayo faldak-tiimin sang ma kanubip imi bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tunum alep ma iyo God ami beten kamaalum o kalale, alep iyo din lotu am diilim kaptamu din abale, kulaa ma kaali takis fakamin tunum ale, ma kaata Falosi tunum, alep iyo din uniple, ");
INSERT INTO tif_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","kulaa, Falosi ali tola bom almi fanang-kup fanang daka-bamda beten kema ko: God kapyo, nali nak-tunum kusal kusnum ban wakamin ililtap disa yo, kalalila kemin, yaap ke yo kalbi. Ili aptum kusal imi bung mafek mafek uyo disa kawu dakayin-bam ale, kasen-fakayin-bam, saak yak sadikin-tal-une-bam ken-umbip. Ale, nali kabak-ali ma kanun-umbi dinim. Nali mep yak takis kaamin tunum alaltap kelila ban ke-laabi disa. Kemin, nali yaap ke yo, kebi. ");
INSERT INTO tif_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nami kukup tambal kanun-umbi kaami sang kaali, weng san ilawa, suunkup Sarere e kala dukduu-dukduu-ken-umbup kabak-ami iipyak tem kabak-ali nali kapni aket kaa dukum-kup fuku-daka-bamdi, ima inin disa fala bombii am alep keke-ke-bamdi, yak nami sisol kan-umbi kaali, sikip nakalkal fak-tii-lomdi sikip maakup ma kabaak-ata kulii-tal lotu am dukum kaltamu kapni kukaap-tam-bam ken-unbi no, kala kanu-bam beten kema. ");
INSERT INTO tif_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ale, mep tunum takis kaamin tunum ali toop daang tem kutoowu tola bomda, almi kukup mafak ken-umba kaami fatom uta tabela bom-bulula titam abiil tikiin daalama disa; kulaa kela dabuna-lomda bokola ko: God kapyo, nali ban wakamin tunum kemin, nali olen-daap-na-lom dong dokop-nan o, kal-bomda beten kema ko. ");
INSERT INTO tif_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nali kipni weng ma bokoyokomi kaali, God ata taba-lomda takis kaamin tunum ami ban wakamin ayo takan-telala, tituun-kup tabin tunum kelap o, akale, kulaa almi am banale, Falosi ata God ali kuno kambola akal disa almi am una kelipla, kemin, tunum almi win kufolokoma kaali, God ali dap-kayak daalokoma. Kemin, tunum kaa kanta aptum kusal imi minlo tem un-ilomda almi win kaa, kufumin disa kema namti, God ata ami win kaayo, kufolokoma no, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yak mafak umusip kiita-kup foko-kulii Yesus ami fanang talsip disa; man katip katip iyo imbiilip tal Yesus be taldip awak-aalap imi aket kaali, Yesus ata sikil kuyak man katip katip imi dabom diim kawu tiiya-lomda, dong dokoyilala, tambal-kup ilomdip fasuulin o, kalalipla kemin, man katip katip iyo yim-tamalip tilip. Katale, Yesus ami daang bakaalin tunum ili, man katip katip kiili, foko-kuliilip talemin daa yo, kala fotabam-niwa, ");
INSERT INTO tif_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesus ali daang bakaalin tunum imi bokoya-lomda: Man iyo kuno yim-biilip nami fanang tilin aa! yimba-kup, bokoya-lomda: Tunum unang ili fanang daaliwa yi, God ali nuli dong dokoyokoma no, kalalip, tiltam God ami miit tem talebip iyo, mep man katip katip kalawiltap kemin, ibi man katip katip kii fotaba dil-saanin disa; keyilipla nami fanang tilin o, yaka-lomda, ");
INSERT INTO tif_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nali ti tituun-kup tabin weng kaata bokoyokomi kemin, weng san bom ilipla! Man kiili, man katip katip bom-bilip kiita, awil-fakal iyo mafek mafek ma kuyum o kalokomip kaali, man kiili maaklo yak awil-fakal imi sikil diim kaali, kuluulokomip dinim; kanolin kemin, unang tunum kawanta God ami miit tem kaali, tam unum o, kalip kaali, kamboyiwa, God akal dong dokoyalala, God ami miit tem kaali, tiltam talokomip; kemin ale, unang tunum kawanta ilmi aket kaata-kup fukun-bam kukup mafak nuumum o, kalip kaali, ilmi san kemin, atin ti God ami miit tem kaali, tiltam talokomip dinim o, kala-lomda kanum bokoyinsa ko. ");
INSERT INTO tif_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kulaa, Juda imi kamokim ma tal Yesus ami dik-daala-lomda: Kukuyin tunum tambal kapyo, nami dik-dakamin ma dik-daap-tokomi kaa, maan-tiip-napla utamon o. Kemin, nali dok kano-somdila, tiltam suunkup ilin tunum ke-lokomi ni? akale, ");
INSERT INTO tif_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus ayo bokola-lomda: Kabi kanimin o kala bokop-na-lomdap: Kabi tunum tambal o nakap i? Tunum tambal ayo ma bombe dinim; ti God maakup ata-kup tambal-kup tabin. Kemin, kabi kanimin o kalalap: Kabi tunum tambal o, nakap yoko? ");
INSERT INTO tif_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kabi God ami weng kuka-daasa kulaali utamsap uyo boko-lomdu: Kaltapni kalel kuu, kewa unang kusnum so sadikimin disa; aa, kabi tunum unang kii anulap taan-yaamin disa; kabi yukut kaa inin daa; kabi disa kawu ibaka-balap, soldiya iyo kaptum kusal kii sok dinayin disa; kabi kaltapni kawil-fakal imi weng uyo kuyang saak tiimin daa; ti imi weng kaata-kup, weng san-kaa-bam ale, kukup tangbal kaata-kup kukaayin-bam keman o, kalsa no kala, kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","kulaa, kamokim asiik bokola-lomda: Kwin, nali sawaalak man katip sakap kaptoowu yakyak kulii umbital tunum aalap dukum kulaa diili kaali, God ami weng kaa kutiiyinsa kiili, alik weng san-kan-tabasi no, akale, ");
INSERT INTO tif_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus ayo tunum kamokim ami weng kaa, weng san ale, bokola-lomda: Kulaali fan kanun-umbap yale, kabi ti kukup maakup ma kuuta-kup kanun-umbap disa; kemin, kabi dindap kaltapni mafek mafek kiili, kaptum kusal imi kuyilapla, ita moliwale, kaami moni kaata, kuluu-lom kulii-din unang tunum iiwaan imi kuyokomap kaata, fan din God ami abip kawu suunkup tambal ilokomap. Kemin, kano-lomdapla, kabi talawa, naso tal-une-bam, God ami okok kem-tal-unemum o, akale, ");
INSERT INTO tif_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","kulaa, tunum man kasaa ayo mafek mafek kayaakim kemin, Yesus ami weng kanum bokola ayo weng san-ilomda, ami aket kaa fanang daala yi, Kwin! ti suunkup tunum kelon o, kalbi. Katale, yak nami mafek mafek kiili, yaapkan kemin, kuno ke-lokomi disa yo, kala-lomda aket uluum kensa. ");
INSERT INTO tif_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus ayo atama yi, Tunum mafek mafek soyap kaali, aket uluum dap-telu kala, kalale, almi daang bakaalin tunum imi bokoya-lomda: Yak mafek mafek soyal unang tunum kii, ti fiit-bamdip, (imi mafek mafek sikip fak-dakan-unsip iyo kulaalokomip kemin, malo ma kiita-kup God ami aket kola-lomdip,) tiltam God ami miit tem tam unokomip. ");
INSERT INTO tif_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kemin, kabak utamsip. Olti dukum kamel uyo tam men sil ami tem kaa tam unon o kalu kaa, fiit-bi-somdula tam unokomu. Ulultap kemin, yak tunum bung kayaakim ali atin ti fiit-bi-somdala kawu, tam God ami miit tem ayo tam unokoma kayi! kala bokoyilale, ");
INSERT INTO tif_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","tunum unang Yesus ami weng bakaanba uyo weng san-ilomdip Yesus ami dik-daala-lomdip: Kapni kanum boko-lom: Bung kayaakim ayo fiit-bamdala tiltam God ami miit tem kaa tiltam talokoma no, kalap kaali, faneng namti, mafek mafek dinimal nuli dok kano-somdupya kawu, tam God ami miit tem uyo tam unokomup i? Kaa fan taang-kala tam unolup daa yo, akiwale, ");
INSERT INTO tif_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus ayo bokoya-lomda: Tunum kaa taang-kala-somdala, tam God ami miit tem kaa tam unokoma disa; God ata dong dokolokoma kaata, fan tam God ami miit tem uyo tam unokoma no, yakale, ");
INSERT INTO tif_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ayo bokola-lomda: Kapyo, weng san ilawa! Kapni daang bakaalin tunum nikil nuli nulmi abip so, nulmi mafek mafek alik so, kii keya-lomdupla, kapni ok kaata, fuku-bom kapso tal-unebup o, akale, ");
INSERT INTO tif_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus almi daang bakaalin tunum nikil ilmi bokoya-lomda: Kulaa fan yale, nami bokoyokomi kalawaali fan kayi! Kawanita aket fukun-ilomdip: Nuli God ami weng uyo kulii yang unang tunum imi bakayin-bulupla, tam God ami miit tem unin o, kalale, imi am so, almi man aptil so, nakal-fakal so, awak-aalap aye, iyo abip kawu keya-lomdipla din God ami ok fukulip namti, ");
INSERT INTO tif_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kamala tawaal diim kala bom-bilip kawu, God akal maan dukum kaali, tiiya-lom tiin mola tambal-kup bilipla, ilom kawu saak-nokomip kaali, din atamiwa God aso suunkup ilin o, yakan-kaama ko. ");
INSERT INTO tif_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus ayo almi daang bakaalin tunum talangkal iyo kumup-daa yim-tama yang abale, bokola: Ipyo weng selin! Siin kawu Dukum Ami Man Nami sang uyo, God ami profet weng tem bakayin tunum imi bokoyilala, ita God ami Sukon Tem kabaku dolsip. Kemin, kamala kulu met Jerusalam unokomup kaali, weng kaa alik tiltam aba-lom lap abuulokomu. ");
INSERT INTO tif_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kemin, din Jerusalam kasel itamupla, Juda imi kamok kamok kiita, taba-lomdip nam-baalip yak Rom kayaak imi sikil diim abamnile, nitafiimin weng mafak uyo bakap-nam-bamdiple, angtiil diim mok tik-tiip-nam-bam, ");
INSERT INTO tif_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","sok faklet ta kuluu ne-bi-lom nelip taanokomi. Lale, am asuumano diim kaata, asuk tam tiinokomi no, yaka. ");
INSERT INTO tif_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lale, almi daang bakaalin tunum iyo Yesus ami bakaba kaami miit uyo talalu kaal kelin disa kelipla, kulaa Yesus almi daang bakaalin tunum ili ami weng bakaba kabak-ami aket kaali, talalu ma fukunin daa ke-lomdip weng kaami miit uyo bam-daalin disa kelip ko. ");
INSERT INTO tif_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus so, almi daang bakaalin tunum iso, iyo yakyak din abip Jeriko mep kulu unan-siliple, kulaa tunum tiin mafak ma liip balang diim kawu tiin-bomda unang tunum tal-unebip imi moni kaata dik-dakaayin-bamda neyila-laaba. ");
INSERT INTO tif_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kemin, akal weng selaya yi, Unang tunum yaapkan iyo tal-unebip kala, kalba-kup dik-daala ko: Kaa kanimin ma nuubip i? yakale, ");
INSERT INTO tif_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","tunum unang isiik bokolip: Abip Nasaret kayaak Yesus ata talaba no, akiwale, ");
INSERT INTO tif_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","tunum tiin bikilin ayo Yesus ami naan-bam bokola-lomda: King Devit ami man loop Yesus kapyo, kabi nali olen-daap-na-lom dong dokop-nan o! kemale, ");
INSERT INTO tif_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","unang tunum dusiin daa unbabip iyo balaan-bamdip bokola-lomdip: Dulumnan o! akan-kaabip. Katale, tunum tiin bikilin ayo dukum-kup ti naanin-kup ke-bamda bokola: King Devit ami man loop kapyo, nali olen-daap-na-lom dong dokop-nan o! kal-bom naanin-kup kemale, ");
INSERT INTO tif_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus ayo duluuma kawu tola-lomda, kusnum imi bokoya-lomda: Kiwe, tunum tiin mafak ayo dibiilip nami fanang tilin o, yakale, kulaa fan, tunum tiin mafak ayo dibii-tal Yesus ami miit tem daalipla, Yesus ayo tunum tiin mafak ami dik-daala-lomda: ");
INSERT INTO tif_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Kabi kanimin ma nop-nalak o, kala naap-nanbap i? akale, tiin bikilin tunum ayo bokola: Kamokim kapyo, nami tiin ayo baap-napla mafek mafek kiili, itafiimon o, kalbi no, akale, ");
INSERT INTO tif_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus ayo bokola-lomda: Nali utamiya, Kabi fan nam-talalulamap o, nakap kala, kalalila kemin, kulaa tam-talaluli asuk tambalnap kemin, tiin baa mafek mafek uyo talalu ataman o! aka-laam-salale, ");
INSERT INTO tif_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","kulaa, maak fak-daalin tap ami tiin ayo tambal-kup kewalule kulaa, mafek mafek iyo itam Yesus aso tal-une-bamda, God ami yaap ke yo, kema. Kemin, kanu-balala, unang tunum yakal atamiwa yi, Tunum tiin bikilin ayo Yesus dap-talalula kala, kalalip God ami win uyo kufon-bam fiyaap duumip ko. ");
INSERT INTO tif_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus almi daang bakaalin tunum nikil iyo din abip Jeriko kaayo, din aba akaala unum o, kalalip Jeriko tam itamiple, ");
INSERT INTO tif_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kulaa tunum ma bombe ami win kaali Sakius; ali takis kaamin tunum imi kamokim ale, ali bung kayaakim kemin, ali Jeriko kaptamu laaba; ");
INSERT INTO tif_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ali, Yesus kaa atamdila dok kanolin tunum ata kala, kalon o, kema. Katale, unang tunum yaapkan isiik tal aba toop liip bak-daalip kemin, Sakius ayo tunum mepkan kemin, Yesus kaa atamin disa kelala, ");
INSERT INTO tif_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","akal utama yi, Awu, Yesus namti kula liip tal-unokoma kala, kalale, Yesus ayo talalu atamon o, kalba-kup, asiik unang tunum yaapkan tem kuyaku kuleka bina din as fik al ma kaptamu duu tam tiin tital daak liip daa tiin bom ilale, ");
INSERT INTO tif_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","kulu Yesus ayo yak aba tal asal tiinba kaami miit tem kulu tola titam daa Sakius ayo atam ale bokola-lomda: Sakius aa, kamala kulaali ti nali din kapni am kawu ilokomi. Kemin, baan abiltap asal uyo kela tildaak tawaal talawa yo, akale, ");
INSERT INTO tif_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","fan Sakius ayo asal uyo kela abiltap-siik tildaak tawaal aba-lom, Yesus ami weng fokola-lomda, fiyaap sakbaalim dukum duuma ko. ");
INSERT INTO tif_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kanola tunum unang iyo alik atamipla, Yesus ali kukup mafak fukumin tunum ami am una no, kala-lomdip, Yesus ami daang tem weng bakaan-bamdip boko-lom: Kaali din ban kemin tunum ami am kaptamu sokoma no, kemip. ");
INSERT INTO tif_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakius ayo yak Yesus so, almi miining so, iyo foko kulii tam almi am kawu yim-tam daa ilanale, kulaa Sakius ayo tam tola Yesus ayo bokola-lomda: Nak-tunum kapyo, weng san ilawa, nami bung iyo fak-tiibi sikip alep fak-tii-lomdi yak ma kabaak-ata tunum iiwaan mafek mafek dinimal imi kabaanuyokomi. Ale, ma kabaak-ata unang tunum ibakayin-bamdi, imi moni dakayila-yaabi uyo asuk kukaayokomi kaali, tuumon maakup e kala yukut duk-duuyasii ni kalbi-kup, tam tuumon atalingkal e kala kuyaku-som kola kola ke-lokomi no, kalale, ");
INSERT INTO tif_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus asiik bokola-lomda: Kabi Abraham ami man loop lale, kabi siin kaali, God ami liip kela yang atin ti maaklo kesap. Lale, ti kamala kulu God ayo kapso, kapni man-aptil iso, kipni iliim uyo boyila yaap kelip o. ");
INSERT INTO tif_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Dukum Ami Man Nali tal unang tunum kukup mafak ke-bam God ami daang ukola-lomdip maaklo kesip kiita, fen-bamdi yim-taldang daa dong dokoyilile, imi iliim kaata boyon o, kalalila, abiil tikiin kaa kela talsii no, kala Sakius ami kanum bakaala ko. ");
INSERT INTO tif_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesus ali tal Jerusalam mepso tala no, kalbip-kup, unang tunum iyo aket fuku-daaliwa yi, Kamala kaali, God ata taba-lomda Rom kayaak imi diim uyo tak-daa yim-buu-lomda, Numi tiin molokoma nema yo? kemipla, unang tunum ili Yesus ami weng uyo, weng san ilipla, Yesus ayo talalu-kukuyilila, numi kanolin aket fukunbup kaali, faneng disa yo, kalin o, kala-lomda, faldak-tiimin weng ma bokola, ");
INSERT INTO tif_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kulaa, kamokim ma ayo aket fuku-daala yi, Naan-daap-nambip kemin, umbili bilin am bokon samaan ma kaptam banila, mep bokon kaptam kasel ita taba-lomdip uldaa-nam-buuliwa, Kabi numi tiin molin tunum kayi! kalalipla Kabi king kelan o, kaliwa, asuk tolokomi no, kema. ");
INSERT INTO tif_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tunum kaali unon o, kal-bom ale, kulu almi okok kemin tunum nakalkal iyo naan-daaya tildang atamiple, kulaa tunum maakup almi moni nakalkal e kala kola-kola keba-kup bokoya-lomda: Nami umbili umbilin am bokon samaan kawu ilokomi uyo, mep moni kaa dunuuyi kaa kuluu-lom wan saan-tal-une-bamdip, moni ayo maso ma kuluu kuyak tiip-tiip ke-biliwa, biili asuk nalmi talokomi kabaku moni kaayo, asuk kulii-tal kup-nin o, yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kamokim ayo kanum bokoya, tabanala almi abip tunum atam suun-umbip iyo tunum ma kalaan yim-baalip ami daang tem din-ilomdip tunum unang samaan kawu bilip imi bokoya-lomdip: Nuli mep tunum kalawaali king ke-lokoma disa yo, kalbup te! kalip ko. ");
INSERT INTO tif_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kemin, kanum bokolip. Lale, mep tunum kalawa ulduulip tiltam king ke-bom biile, asuk yak aba tal almi abip aba-lomda baan abiltap almi ok tabuulin tunum ma bokola-lomda: Na! baan abil din tunum nakalkal kiimi tuumon kuyila unsii iyo weng umuuyilap tilip dik-daaya-lomdi: Nami tuumon kuyila tabansii kaa, kanim kal ma kuluu-silip kala, yokon o kalbi. Kemin, ipyo din bokoyap tilin o, akale, ");
INSERT INTO tif_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","kulaa fan tunum ma asiik tal king ami bokola-lomda: Kamokim kapyo, nili kapni tuumon nakalkal kup-na un-salap kiili, wan saan-tal-une-bamdi dukum-nipla, kutiip-tasii asuk nakalkal ma kuluu kuyak tiptiip-ta kebi no, akala, ");
INSERT INTO tif_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","king ayo bokola-lomda: Kabi ti ok tabuulin tunum tambalim kesap. Kemin, nami mafek mafek katip ma kup-ta unsii namti, atin yaap-kup tiin-mo-salap. Kemin, kaali abip nakalkal kiita, kup-tila tiin-molokomap o, kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","tunum ma akal tal bokola-lomda: Kamokim aa, nali kapni tuumon nakalkal kup-na un-salap kiili, wan saan-tal-une-bili tiltam sakbaalim dukum kelipla, kulaa kewa bomdila, mep moni kiiyo, awakal ma kuluu kuyak tiptiip-ta kebi no, akale, ");
INSERT INTO tif_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","king ayo bokola-lomda: Kaa tambal kebap kemin, kulaata kabi abip awakal ma kiita kup-tila, tiin-molokomap o, aka ko. ");
INSERT INTO tif_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Kuno ti tunum ma akal tal-ilom bokola: Kamokim aa, kabi titamila, Kabi tunum siliil-kup tabin kala, kalalila kemin, kapni okokmin tunum kiili, fiit-bamdip kaami win moni kaali, kaap-tam-biliwa kawu, miing-kup tal tiin-bomdawa kaa-bam ale, kaltapni okok kemin tunum imi langabip kaami mafek mafek dikilip tiltam tiilbu kaa, kabi mikil diim-kup tal tiin-bomdawa faka-bam ken-umbap kemin, nali kapni atul kaata, titam suun-daa-som ale, aa bisnis kemin kaami liip kaa ma talalu utamsi disa kala, kala-lomdila kemin, kapni moni iyo ti tambal-kup kambola kuwaap-ti tiinsip te! Ti kala daatam akale, ");
INSERT INTO tif_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","king ayo ok tabuulin tunum ami bokola-lomda: Kabi ti ok tabuulin tunum mafak dukum kesap. Kemin, ti kaltapni weng bokop-nap utami kaami kalan kaata, sok de-tamulokomi te! Kabi bokop-na-lomdap, Kabi tunum siliil-kup tabin balap titamsi kemin, kapni ok tabuulin tunum imi ok tabuu-bamdip moni kan-umbip kaa, kabi miing-kup tal bomdapla kaa-bam ale, kapni okok kemin tunum imi langabip kaptam-ami mafek mafek dikilip tiltam tiilbu kaali, mikil-kup tal tiin-bomdap faka-bam im-bom ken-umbap o, kalap. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kaa kanimin o, kalalawa, nami moni kaa kuliilap din beng kawu tiilawa, tal-ilomdi win moni kaa maso ma kuluulami dinim i? Kemin, kaa kanimin o, kalalapla, kuwaalawa disa iip kawu bom-laabu ni? kala kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","kulaa almi dong dakaalin tunum bom-bilip iyo bokoya-lomda: Kibi yakdiwa, ami sikil diim kawu moni kutal-fukuba kulaa kuluu-lomdiwa, tunum moni nakalkal kuluuba kaami kolin o! yakala, ");
INSERT INTO tif_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","iyo bokolip: Kamokim kapyo, kabak kanum bakamin daa; tunum kalawaali, moni nakalkal kuluuba kaali yoko? akiwa, ");
INSERT INTO tif_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","king asiik imi weng maan tiiya bokoya-lomda: Weng ma bokoyokomi kemin, ipyo weng san bom iliwa! Tunum kaa kawanta ok tambal-kup fuku-bomda almi kamokim ami weng kaata-kup weng san-kaa-bamda ila namti, ami kamokim ayo ok uyo maso ma kolala, ok dukum kaata okok kemama. Ale, kawanta ok uyo mafak ke-bamda ami kamokim ami weng ayo kuyang saak ten-bamda kema namti, kaami kamokim ayo almi mafek mafek katip bombe uyo kuluu-lomda okokmin sisol uyo maso ma kolokoma disa yo! ke-bamdala, weng ");
INSERT INTO tif_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ma kaata boko-lomda: Siin kawu tunum malo ma imi bokola-lomdip: Nuli mep tunum kaali, numi king ke-lokoma disa yo, kalbup o, naka-silip. Kemin, kii yim-bital nalmi tiin diim kulu anulip taanik o, kalsa no, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus ami weng uyo disa kelula kawu, ayo dusiin daalale, daang bakaalin tunum ita mafiingnip ke yakyak din Jerusalam din unipla, ");
INSERT INTO tif_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","abip alep kemin, ma kaa Betfage so, Betani so, kiili umbitam Oliv Tikiin kaptamu kemin, Yesus nikil iyo mepso kulubale, Yesus almi daang bakaalin tunum alep ma ipsiik unipla yo, yaka-lom, ");
INSERT INTO tif_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","bokoya-lomda: Alep ibi yak aba tam abip utafiibup kaptam ulip, Dongki man kasaa ma sok buk-duulip bombe kala kalip namti kaalile, siin kaa tunum so dap-tama tal-unemakin dinim; disa kama man bombe kemin, alep yak sok baa dibiilip nami bi kala tilipla yo. Kemin ale, kanumipla ");
INSERT INTO tif_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","tunum ayo ma alep dik-daaya-lomdip: Kaa kanimin o kala-lomdip kaa kanubip i? yaka namti, kipkal bokola-lomdip: Yi, numi Kamokim ayo ok so kemin, din kulii-tilin o, yakala tulup kayi! kala bokolalip kulii-tiliwa yo, kala yim-baala unip ko. ");
INSERT INTO tif_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Alep iyo tal abip kawu tal uliwa, Fan Yesus almi weng bokoyila kaata-kup tifan dongki man kasaa ayo sok buk-dulip bombe kaa kalale, ");
INSERT INTO tif_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","alep iyo sok baamiple, dongki tiin molin tunum ayo tal dik-daaya bokoya-lomda: Ibi kaa, kanim nolum o, kalaliwa, tal dongki ami sok kaa baabip i? yakale ");
INSERT INTO tif_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","alep isiik bokola-lomdip: Yi, numi Kamokim kaali bokoya-lomda: Alep din kuliilip tiliwa yo, yakala alep tulup o, kala kanum bokolipla dongki kayaak ayo boko-lom, Kuno kulii-unin o, yakale, ");
INSERT INTO tif_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","alep iyo dongki man kasaa ayo dibii-tal Yesus ami kutal daaliple, almi daang bakaalin tunum ita ilmi ilim batbat ta kutam dongki ami daang kun diim kabaaku tabeliwa, Yesus ami dong dokolipla, Yesus ayo tam dongki ami daang kun diim tiinala, alimal ");
INSERT INTO tif_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","una-bilipla, unang tunum imi aket fukunin kaali, Yesus ami liip talaba kaayo, liip tambal-kup ma dotuluwa tal-unak o, kala-lomdip, ilimi ilim malo ma kiita dalela kulaak liip kawu kutii-kutii-ke-bilipla, dongki ayo Yesus ami dibii yak ilim kutii bokobip kaptoop bala una ko. ");
INSERT INTO tif_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesus Oliv Tikiin ayo kulaa kela, tildaak Jerusalam mepso talan-salale, Yesus ami lak duulin tunum unang yaapkan iyo tal dap-falala duu-lomdip iso una-bilip, unang tunum alik iyo kukup akal alik akal alik Yesus ata kanu-balaya, itafiimsip kaami aket kaata, fanang daa-lomdip alik iyo ti God ami win kaata, kufu-bam, naan una-tala-ke-bamdip fiyaap sakbaalim dukum-kup duu-bam ");
INSERT INTO tif_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","bokola-lomdip: Numi kamokim king kalawaali, God Dukum ami win diim o, kalala talaba kemin, God ata kukup tangbal-kup kukayim-balala yo! Kemin, ayo numi dong dokoya yaap kelupla, tam abiil tikiin kaptamu abiin tambal-kup tiinokomup. Kemin, God ami win dukum-kup ayo kufon-bamdup fiyaap duumum o, ke-bam kanu-bilipla, ");
INSERT INTO tif_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Falosi malo ma unang tunum yaapkan imi tem kulu bom-bilip kemin, tiltam Yesus ami bokola-lomdip: Kap kukuyin tunum kapyo, mep tunum unang kapni daang bakep-tambip kalawiili, baan bokoyawa, Dulumnin o! kala kanum bakaaliple, ");
INSERT INTO tif_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesus asiik imi bokoya: Nali dulumnin o! yokokomi disa; nali kipni weng ma bokoyokomi kemin, weng san iliwa. Mep tunum unang kalawiili, dulumnin o! yokokomi namti, daak tuum kuliita, tunum ililtap keliwa kawu, nami win kaa kufumalip o, yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus ayo tal abip dukum Jerusalam mepso kuluba-lom atam-ilomda, kulaali abip kasel kaptam imi olen-in-bamda ama-bam bokola: ");
INSERT INTO tif_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","44","Ibi, Nuli ti tambal-kup balili-kala bomduwa yi, kalbip. Lale, am kala daansuu kaali, kipni aket fukunin kaa atin ti mafak-yinsu. Kemin, ibi kanolin kukup uyo ma utabip disale, bilili-kalin kukup uyo kaa utabip disa yo. Ibi utamipla, Kamala kuluwu God ali numi yam-talalulon o kalba, nuli kalalip utabip dinam, fan ibi yam-talalulama. Yale, ibi tiin bokol tap kelip, kipni aket uyo fal-sikilin disa kelip kaa, uktaalip kemin, kabak-ata am ma daanula kawu, kipni waasi iyo tal-ilomdip, kipni abip uyo falala kuyak moliple, kibi ok fanang, ima fanang, dok kanolin kaami fanang kaali ma tiltam talokomip disa; keliple, waasi ita baan dalaa kutam abip uti dong diim daa kela unfoko tam daak abip aba-lom, ibi yan-fakan tal-une-bam ale, abip kaami mafek mafek iyo ku-mafak fuuyin-bamdip, kipni tuum am dinan-unsip so, tuum uti fokosip so, iyo dekela binalip tildaak tawaal diim kaba-lomdu, tuum iyo sekela yang kuluba tildang kuluba ke-mokomu no, kala Jerusalam kasel imi aket kaata, fukun-bamda kiimi kalan kaata amama ko. ");
INSERT INTO tif_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus almi daang bakaalin tunum iso yim-tamala tam Jerusalam daa keyila tam lotu am diilim tam ulala, Kwin, tunum iyo taba-lomdip sipsip so, bulumaki so, kiili kulii-tal God ami koliwa, tunum unang imi ban kelip kukan-tiiyila-yaamin kaami inin-inin uyo kutal tii-bomdip lotu am diilim kaptamu saanbip kala, kalale, Yesus ayo tunum mafek mafek saaneng kalaabip iyo alik yan-buk-duu yim-baala tam baniwa, ");
INSERT INTO tif_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kang awon saan-bamdip kiimi sisol kaa-bokobip imi weng ma bokoya-lomda: God ami Sukon Tem kabak-ali boko-lomdu: Nami am kaltam-ali beten kemin kaata-kup kanumin o, kalsu. Lale, ibi ami weng kaa kuyak saak tii-lom, God ami am kaltam ku-mafak-dakan-tabasip. Kemin, am kaltam-ali ipni wan saan-bam kaptum kusal imi moni yukut inin am kelu kewinsip o, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus ayo suunkup unang tunum imi God ami weng uyo am diilim kaptamu kukuyin-kup ke-balala, kulaa tunum awem imi kamok kamok iso, lo utamsip iso, Jerusalam kaptam-ami kamok kamok iso, iyo Yesus aalup taanak o, kalalip kaami liip kaata fen-tal-unemip. Katale, ");
INSERT INTO tif_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","tunum unang alik ili Yesus ami weng kaata-kup weng san-kaamum o, kalalipla suunkup tal falala-dabak-mo yakyak ke-bam weng san-kaamin-kup ke-biliwa kemin, kamok kamok iyo dok liip kawu ma yang-ilomdip dap-tal-fukulalip dinim kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Am ma daanala, Yesus ayo lotu am diilim kawu unang tunum imi kukuyin-bamda God ami weng tambal uyo bakayin-balala, pris awem tunum imi kamok kamok iso, lo utamsip tunum iso, Juda kayaak imi kamok kamok iso, iyo tal dik-daala-lomdip: ");
INSERT INTO tif_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kapyo, kabi kawanami win diim kaata, tal kanolin kukup kala kanun-umbap i? Kawanta tam-baala tal-ilomdap, kanolin kukup kala kanum-solap yoko? Nuyo bokoyawa utamum o, akiwale, ");
INSERT INTO tif_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus asiik bokoya-lomda: Na, nakal weng ma ipni dik-daayokomi kemin, kipkal maan tiip-nin aa! ");
INSERT INTO tif_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Oksam ukayin tunum Jon Baptis ali kawanami win diim kaata, unang tunum kii oksam ukayinsa ni? God ami win diim kawu kanum-soma elile, tawaal diim kaldaak-ami tunum imi win diim kawu kanumsa ni? Nami weng kala dik-daayi kaata, maan tiip-niwa yo, kala dik-daayale, ");
INSERT INTO tif_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ilimi-kup bokola una-tala-ke-bamdip bokolip: Kwin! nokol kaa kanimin o, kalokomup i? Nuyo boko-lomdup: God ami win diim kaata, kanumsa no, kalokomup kaali, ali bokoya-lomda: Ibi utamiwa, God ami win diim kanumsa no, kalip namti, ibi kanimin o, kala, Jon ali fan God ami weng kaata tituun bakayimba, kemsip disa ema? kalokoma kemin, ");
INSERT INTO tif_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","unang tunum yaapkan kalawiili utamiwa yi, Jon ali God ami weng ku-fatap-daa bakayin tunum u, kebip kemin, nokol boko-lomdup: Tawaal diim tunum ma kaami win diim kaata kanum-soma no, kalokomup namti, unang tunum kalawiili aket atul keyula, tuum ta kuluu nuyo yelamip o, kala-lomdipla kemin, ");
INSERT INTO tif_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yesus ami ibokola-lomdip: Kaa kanta Jon kaa bokolaya, ali taba-lom unang tunum kii oksam ukayinsa kalalup utabup dinim o, akiwale, ");
INSERT INTO tif_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus asiik bokoya-lomda: Nakal ti kanolin kemin, kawanami win diim kaata, kanolin kukup kii kanun-umbi no, yokokomi disa yo! yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kulaa, Yesus ayo weng faldak-tiimin weng ma kaali, sawaayak God almi weng ku-fatap-daa bakayin tunum imi yim-baala talemsip imi diim tii unang tunum iyo bakayila ko. Tunum ma ayo wain lang ma dikibii diki-lomda, wain lang ayo kulaala yak tunum kusnum malo imi sikil diim abamnula bokoya-lomda: Wain lap abuu tii-mokoma kaali, dakabi kutii kela tak-nuubi ok ayo laabi kutiiliwa, kaptum kusal kiita tal molipla, kipta sisol ayo kuluu-lom anung ma iltipni kuluubip-kup; nakal anung ma kuluu kulaap-nip din unemak o, kala keya bilin samaan kawu una ko. ");
INSERT INTO tif_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kawu bom-balala, wain lap abuumin umi am uyo daan tiltam tabamnula kawu, tiin-saanin tunum iyo wain lap dakabi kutii-lomdip ok ayo tuk-nuu-bam ok laabi kutiilipla, aptum kusal imi kuyip ita tal moliwa, kulaa wain lang kayaakim ata alami okok kemin tunum ayo ma dabaala tal wain lang tiin molin imi bokoya-lomda: Nimi kamokim ami wain lap kaami ok kaami sisol anung kaata ma kup-nipla, nulmi kamokim ami kulela unon o, yaka. Lale, iyo biwaka-bi-lomdip, disa kulu dabaalip almi kamokim be una. ");
INSERT INTO tif_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kamokim ayo asuk ok tabuulin tunum akal kusnum ma dabaala din wain lang tiin molin tunum imi diim tal-ilom kamokim ami weng uyo tal bokola. Lale, akal ti kuno dabaak-mo biwaka-bamdiple, kukup mafak kaayo, kukaan-bi-lom, disa kulu dabaalip unale, ");
INSERT INTO tif_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ati kuno kamokim ayo asuk liip asuumalo diim okok kemin tunum kusnum ma dabaala din wain lang tiin molin tunum imi diim unon e! biwakabi aalip kiim tabamnale, dap-tal-fuku dabuu-dabaalip saak lo uti yam tem abala una ko. ");
INSERT INTO tif_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kanumsile, wain lang kayaakim ayo aket fukunsi, Kwin! kaata kanimin ma nolokomi ni? kemsi. E, e aket fukunin ma tildang tulu utami. Ti nalmi aket-iip man kulaata dabaali imi fanang din unokoma te! kalale, aket fukuna yi, Nami Man aket-iip kalawaali aalokomip disa; ti ami weng kaata-kup weng sanokomip ema? kala, dabaala din wain lang tiin molin tunum imi fanang din una. ");
INSERT INTO tif_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lale, wain lang tiin molin tunum iyo atamiwa yi, Fan kamokim almi man ali kulu tala kala kala-lomdip, maaklo abiltap ilmi-kup bokola una-tala-ke-lomdip bokolip ko: Kuluwaali ti wain lang kayaakim almi man kemin, bom bii-lom almi aalap ami taanokoma ayo, alalta aalap ami mafek mafek kiili, alik tiin mo-lom almi alik ke-lokoma kemin, baan aalup taanala, wain lang kaltam ayo nulmi alik keyuk o, kala-lomdipla, ");
INSERT INTO tif_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","kulaali yak dap-tal-fuku, sisii dilili dibii tam uti daam tem uyo akaala dabaak saaklo daa-lom aalip taana no, kala-lomda kanum bokoyila ko. Kemin, Yesus ayo dik-daaya-lomda: Kipyo, wain lang kayaakim ami asuk talokoma kaa, ali wain lang tiin molin kasel kii, kanimin ma noyokoma ni? ");
INSERT INTO tif_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Akal tal-ilomda wain lang tiin molin tunum iyo anula taaniple, asuk tunum kusnum ma iyo ulela-lomda, wain lang uyo kuyak kiimi sikil diim tiiyala, ita tiltam wain lang kaayo, tiin molokomip o, kala Yesus ayo faldak-tiimin weng uyo kanum bakayila ko. Unang tunum iyo weng faldak-tiimin weng kaata, weng san-ilomdip iyo (utamiwa yi, Wain lang kayaakim kulaali, God ami sang kaata bakayinba nu, kalbip-kup, yak wain lang tiin molin tunum o kala, kuliili Juda nulmi kamok kamok kuliimi sang kulaata bokola no, kala-lomdip) bokolip. Daa te. God ali numi kamok kamok kiili, kanola anulokoma disa, akiwale, ");
INSERT INTO tif_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus ayo talalu tiin dik-yak-diiya bokoya-lomda: Dok kabak-ami miit kaata, God ami Sukon Tem weng uyo boko-lomdu: Ok fukulin tunum ili am kaa dina-bam tiyak daaliwa, am kun ma kaali mafak o, kala-lomdip faldang mo binalip yak balang diim kabang abamna. Katale, Kamokim ali am kun kaa atam-ilomda, Kwin! kaali ti tambal kemin am dubim ami duwokop kelak o, kala-lomda am kun kaali, asuk dibii tildak dap-molaya ayo tangbal mokso ke tolnu ko. kalsu nema? ");
INSERT INTO tif_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aa, kuno ti am kun awak dukum ma bombuu. La, dok nolin tunum ata kutal daak am kun diim kaa daala namti, ayo dap-mafak-daalokoma le, am kun uyo dik-tam-daa tildaak tunum kaami angtiil diim abam-nokomu ayo, atin tunum dabuu dabaak molula, atin ti dap-mafak-daalokoma no, kala Yesus ayo almi sang kaata, faldak am kun umi diim kabak tii-lomda bakaya ko. ");
INSERT INTO tif_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lo utamsip tunum isole, awem tunum imi kamok kamok iso, ili utamipla, Ee, Yesus ayo nulmi sang kulaata, faldak kulu tii numi bakayinba kala, kala-lomdip, Kulaata yak da-fukulum o, kalip. Katale, unang tunum Yesus ami weng uyo weng san-kaabip imi itam-suun-daa-lomdip kuno kambolip ko. ");
INSERT INTO tif_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kulaa, lo utamsip tunum isole, awem tunum imi kamok kamok iso, iyo boko-lomdip: Kano ata bom iluwa, Yesus ayo kukup mafak ma nola kala, kalbup-kup, kuyaku dap-tal-fuku dabaalup yak Rom kasel imi gavman ami sikil diim abamnala, ata dabak saan-bi-lomda, dabaala yak almi soldiya imi kuyilala, Yesus kaa aalip taanak o! kala-lomdip, Yesus ayo talalu tiin dik-yak-dela atafii-bamdipla kemin, ili tunum kusnum ma moni kuya-lom bokoya-lomdip: Kipta din Yesus ayo atam kasen-fokola-lomdip, Nuli kabi tunum tambalim o, kal-bom tamsong-bamdup mok-kup inap-tanbup o, akan-kaa-bamdip ata-bom iliwa, Yesus ayo weng mafak aye ma bokola ne kala tal bokoyipla yo, kala iyo yim-baalip unip ko. ");
INSERT INTO tif_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yim-baalip tal Yesus ayo bokola-lomdip: Kukuyin tunum kapyo, numi titafiin-umbup kaali, kapni weng bakayin-bam kukuyila-yaabap kaa, ti tituun-kup. Aa, kabi ti yak win tibin kiita ti nami dong dakaap-nin o, kal-bomdap imi tong kaa ma bakan-umbap disa; kabi ti unang tunum alik win so, win dinim iso, ili alik tikip maakup God ami weng so, kukup so, kii ti tambal-kup kukaayila-tabasap kayi! kalbup te! ");
INSERT INTO tif_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mafek mafek sang uyo ma dik-daap-tum o kalalupla tulup kemin, (Rom kasel imi lo kaali, boko-lomdu: Ibi ipni takis moni uyo, numi king Sisa ami gavman ami kukaayin o, kalbu-kup ale, Juda kasel numi lo kuuta, boko-lomdu: Ibi ipni moni kuuli, God ami kukaalin o, kalsu.) Kemin, numi takis moni uyo Sisa ami kukaalum elile, God ami kukaalum e? akiwale ");
INSERT INTO tif_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesus ayo imi aket tem kaa uteyila yi, Kii kanola wak-talalupla, ayo weng kuyak kutaldak ke-bamda weng mafak aye ma bokola kala, kalum i, kala-lomdip bokop-nip u, kala-lomda asiik bokoya-lomda: ");
INSERT INTO tif_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Na! tuumon ma kulii-tal kukup-nipla! yakale, kulaa tuumon ma kuluu kukoliple, bokoya-lomda: Yak tuumon diim kabak-ali sinik so, win so, kala bombe kaa, kawanami sinik sole, win so, kaata bom-bilip i? yakala, iyo bokolip: Kaye? Sisa ami sinik so, win so, kiita no, akipla, ");
INSERT INTO tif_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesus ayo bokoya-lomda: Uyo kanolin kemin, tuumon kalawaali Rom kasel King Sisa ami tuumon kemin, Rom kasel imi gavman almi kukaan-bam ale, God ami mafek mafek kiita, kuno God ami kukaan-bam kemin o, yaka. ");
INSERT INTO tif_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kemin, ili Yesus ami weng asiik maan tiiya-lom bokoyila kaali, weng sandiwa, fanang alik tam baneyilula, unang tunum kalawiimi tiin diim kaa nuli wak-talalokomup. Lale, kaa nuta nuta kelalup disa yo, kalaliwa, weng kaa kulaa kela, dulumnip ko. ");
INSERT INTO tif_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Juda imi kamok kamok malo ma kiili, Sadusi yo, ken-umbip iyo boko-lomdip: Unang tunum taansip kiili, asuk tam tiinokomip disa yo, ken-umbip. Kemin, Sadusi malo ma iyo (din Yesus ami dik-dakamin fiitmin dukum ma dik-daaluwa, ami miit kaali, talalu daka-daa bokoyin disa kela namti, unang tunum iyo aban-delik i! kalalip) tal Yesus ami bokola-lomdip: ");
INSERT INTO tif_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kukuyin tunum kapyo! Nuli weng ma dik-daalum o, kalup. Kemin ale, sawaalak kawu, Moses ata God ami lo ayo numi kuyinsa kaami anung uyo boko-lomdu: Tunum ali tunum man ma foko tiilin dinim ke ilomda saak-alom kalel kutiila namti, niing alta asuk fik ami kaluun uta kuluulala akam imi tunum man kuulokomip kaali ali bokola-lomda: Kabi nami abaap ami man kayi! aka-lomda kamasi fik taanse ami bung mafek mafek uyo mep man kuula ami kukaalak o, kala kanum bokosu te! ");
INSERT INTO tif_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Weng san ilawa, sawaalak kawu tunum ma ayo, man tunum man ilmi-kup fetkal foko kutiilale, ti nikil alik maakup fasuu tiiliwa, kulaa fik diilim asiik unang ma kuluu bom-ilom man so ma kuulama disa; ilomda taanale, ");
INSERT INTO tif_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","kulaa, almi tamon ata fik kalel kaluun uyo kuluula bom ilip. Katale, akal ti kuno man dinim-ilomda ayo saaknale, ");
INSERT INTO tif_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","niing iip ma akal ti kanolale, kano nakal yakal fakal imi kaluun uyo kuluu kuluu ke-bi-lomdip, iyo man ma kuulamip disa ke-lomdip taan-taan-keliple, ");
INSERT INTO tif_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","atin mafiing mafiing kulaata unang ukol ti kuno taan kesu no. ");
INSERT INTO tif_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na! kapni aket fukunbap kaa bokoyan o! Tunum nikil fetkal alik kiili, unang maakup kuuta-kup kuluu biile, taan-taan-kesip. Kemin, bom-bi-lom tunum taansip imi tam tiin kawang ke-lokomip kaali, unang kuuta kawanmi kalel ke-lokomu ni? kala, Sadusi iyo Yesus ami dik-daaliple, ");
INSERT INTO tif_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","kulaali Yesus asiik bokoya-lomda: Kamala tawaal diim kula bom-bilip kaata, tunum ata unang dan kaa-bala, unang yakal tunum dan kaa-bala ke-bam akmal ken-umbip. Yale, ");
INSERT INTO tif_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","am mafiing am daanokomu kabaku, God ali unang tunum malo ma kiita-kup bokoya-lomda: Saaksip ibi yaap-kup asuk tam tiindiwa, tam nami abip kawu suunkup ilokomip kayi! kalokoma. Kemin, kiimi tam tiindipla, tam ilokomip kaali, tunum kiili asuk unang dan kaa-mokomip disa le, aa unang kiikal asuk tunum kii dan kaa-mokomip disa. ");
INSERT INTO tif_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kemin, kiili asuk maso taanokomip disa; ti fan God almi man alik-daap ke-lomdip abiil kayaak ensel ililtap ke suunkup ilokomip te! ");
INSERT INTO tif_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kemin ale, ipni (weng boko-lomdip: Unang tunum taansip iyo, taan-ilomdip maaklo kesip kemin, God ali asuk yim-fola tam tiinokomip disa yo, ken-umbip) kaami sang kaata bokoyon o, kalalila, nami weng kaata-kup disa; Moses ami weng kaaso, kukuyula utamupla, Unang tunum taansip iyo asuk tam tiinokomip o, kalokomup. Kemin, as katip sakap ma Moses ami mepso kawu tolsa. La, ayo wing kiin-taba-lom kiin-abamnin disa kesa ami sang kaata, baka-bam ale, bokola: Nali Abraham so, almi man Aisak so, almi man loop Jekop alimal imi God namti kalabi no, kalsa. Sawaayak mep tunum alimal kaa taansip imi sang kanum bokosa. ");
INSERT INTO tif_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kemin, unang tunum iyo taan-ilom maaklo kelip namti, God ayo imi tiin molama disa. La, unang tunum iyo taan-ilom maaklo kemin dinim. Kemin ti, tunum taandip din God ami diim kawu suunkup laabip isole, tunum tiin kawang bom-bilip iso, ita tiin mosa. Kemin, ultap God ami weng Moses ami bokonsa kaami miit uyo dok kabak-ata naa kalolip: Abraham alimal ili sawaayak kawu taansip. Lale, God ami tiin diim kaali ti bom-bilip kemin, alimal iyo tiin mo-bomdala, ayo boko-lomda: Nali alimal imi God namti kalabi no, kalsa no, kala, Yesus ayo Sadusi imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kanum bokoyilala, lo utamsip tunum iyo Yesus ami weng Sadusi kanum bokoyila kaata, weng san-ilomdip, malo ma bokola-lomdip: Kukuyin tunum kapyo, kabi Sadusi imi weng kuu tambal-kup bokoyilap o, kalalipla kemin, ");
INSERT INTO tif_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","kanola ili utamiwa yi, Yesus kaali ti talalu dik-daa kuluusa tunum o, kalalipla, ami atam suun-daa maso ma dik-daalin dinim kelip ko. ");
INSERT INTO tif_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus ayo kamok kamok imi dik-daaya-lomda: Lo utamsip tunum iyo boko-lomdip: God ami Man uldaa-dabuusa tunum Kraist o kebip kaali, Devit ami man loop o, ken-umbip. Kemin, kanimin o kalalipla, kaa kanum bakan-umbip i? ");
INSERT INTO tif_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","God ami Sukon Tem weng anung ma Buk Saam kabaku Devit akal boko-lomda: God Dukum ali nami Kamokim ami bokola-lomda: Kapyo, tal aba yang nalmi ting tuuplo kamokim ami tiin-yaamin baan kaldaaku tiin-balapla, bii-lom nata nata kelila kawu, ");
INSERT INTO tif_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kapni waasi itale, kabaak banipla, kapta tiin molokomap o, kala God ata kanum bokoyinsa kayi! kala, Devit ayo bokosa no. ");
INSERT INTO tif_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kiwe, God ami uldaa-dabuula Kamokim kesa kaa kawanmi man i? Devit ami aket kaa fanang daalaya, Am ma daanokomu kaali, ilom kaptoowu nalmi man loop ata ma tiltam tabokoma kala kalalala kaami aket kaata fanang daalaya, kanum bokosa dinam kabak boko-lomda: Kaa nami Kamokim o, kaloma disa yo. Devit ali kalok nolin aket kaata, fanang-daa ke boko-lomda: Kaa nami Kamokim o, kalsa ni? kala Yesus ayo Falosi imi dik-daaya ko. ");
INSERT INTO tif_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tunum unang alik iyo kawu bomdip Yesus ami weng kaata weng san-kaa-bam iliwa kulaa, fal-siki taba aso almi daang bakaalin tunum imi bokoyila ko: ");
INSERT INTO tif_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Kiwo, kibi mep lo utamsip tunum kii talalu itafii-bamdiwa kayi! Imi aket fukunbip kaalile, ti ilim batbat kaata-kup miki-bi-lomdupla abip kawu tal-une-bulupla, unang tunum iyo numi itafiimik o! kala-lomdipla tal-une-bam ale, iyo din maket saanin baan diim kawu unokomip kaa, unang tunum iyo tal bakayin-bamdip: Kamokim kaa balap o? Kukuyin tunum kaa balap o? yakan-kaamin o, kalaliwa, unang tunum imi tiin diim kawu tal-une-bam ale, iyo din lotu am aye, ima inin am aye kawu, din unokomip kaa, ti abiin tambal-kup kuluu tiinupla, tunum unang iyo itafii-bamdip numi win ayo kufuyik o, kal-bomdiwa, tinaa-bom ken-umbip. ");
INSERT INTO tif_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lale, lo utamsip tunum iyo unang kaluun kiili kasen-fakayim-bamdipla, imi sin-yaamin am kiiyo kuluuyipla, ili am dinim, mafek mafek dinim, ke-bam ken-umbip. Kemin, mep kanolin kukup mafak kaa kanubip. Kemin, ili unang tunum imi tiin diim kawu God ami beten kamaalup kawo kala, bakan kaptoop kaptoop ke-bulupla, unang tunum iyo itam-lomdipla, numi tong kaata-kup bakayik o, kal-bomdipla, beten batbat-kup ken-umbip o. Kanola ibi imi talalu itafii-bamdiwa kayi! Kukup mafak sakbaalim dukum ken-umbip kemin, God ali angtiil yol sakbaalim dukum kaata, kuyokoma te! kala, Yesus ayo lo utamsip tunum imi sang kaata, daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus ayo lotu am diilim kaptamu bomda unang tunum tuumon kulii-tal God ami kukaalum o, kala kulii-tilip kiiyo, ita-bom ilale, mafek mafek soyal iyo maakup e kala, kulii-tal ket abuu una-una-kemiple, ");
INSERT INTO tif_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ayo tiyak daala yi, Unang kaluun atin mafek mafek dinim ma ukol tal tuumon kiin-abin katip katip alep ma iyo kulii-tal ket abuulu kala, utam ale, ");
INSERT INTO tif_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","aso daang bakaalin tunum imi bokoya-lomda: Ibi unang kaluun kuuli utamip elile disa ye? Unang tunum kusnum kiili, mafek mafek soyal kemin, ili tuumon yaapkan lale, anung katip kiita-kup kulii-tal God ami kukaanbip ale, unang kaluun kuluutale, mafek mafek dinim umi tuumon katip ma ima saan-bam inokin kuliita, alik dilii-tal God ami alik kulu kolu. Kemin, atin ti weng tifan ma bokoyokomi kemin, ibi weng san bom iliwa! God ami tiin diim kaali, unang kaluun bung dinim umi kukup kaata, uta uta kelule, tunum unang kusnum imi kukup kaata, kulaak banu no, kala, Yesus ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kemin, Yesus ami daang bakaalin tunum malo ma God ami lotu am diilim desip kaami sang kaata bokolip: Iyo tuum tambal tambal sole, kiit kon o, kala, am kaptamu kutiilip tambal kemin kiita, kuluu God ami am uyo talalu desip. Kemin, atin tiin so malii-malii diinsu kayi! kemiple, ");
INSERT INTO tif_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesus ayo bokoya-lomda: Am ma daanokomu kawu, waasi iyo tal mafek mafek tambal tambal kii itafiibip kuliiyo, alik ku-mafak fuulipla, disa kelule, am uyo alik ti olso balata-lomdip, tuum kuyak tip-tip-bam miltiin-unsip kiiyo dekela fokolip daak aba-lomdipla, almi kulu bala-bala-ke-lokomip o, kala Yesus ayo kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesus almi daang bakaalin tunum iyo dik-daala-lomdip: Kukuyin tunum kapyo, dok kanumin diim kawu waasi kii tal-ilomdip kabak kanum tal-une-mokomip i? Dok kanolin kukup kabak asiik tiltam tabu utam talaaluwa yi, Awu, kukup mafak namti kulu tiltam tabon o, kalu kalokomup yoko? akiwale, ");
INSERT INTO tif_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus ayo maan tiiya bokoya-lomda: Kabak talalu utafii-bamdiwa yi! Kasen-fakayin tunum kiimi weng kaa, weng san-kaamin daa. Tunum yaapkan iyo tal baka-bamdip: Yi, nuli God ami man ami win diim tulup o, yakan-kaa-bam ale, iyo tal boko-na-boko-na-ke-bamdip: Nali God ata uldaa-nam-buulala kamokim kesi tunum o, kala ke-biliple, tunum iip maakup maakup ita boko-lomdip: Am mafiing diim uyo tiltam tabu kemin, God ami ulduula kamokim kesa tunum ayo talon o kalba no kal-bom ke-mokomip. Katale, ibi imi weng kaali, Fan o, kala weng san-kaamin disa kayi! ");
INSERT INTO tif_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kulaa, ipkal weng seliwa! Tunum miit ma iyo baa kulin daalip miit kusnum ma iso waasi din-biliple, abip kayaak ilmi yakal kano waasi kela una-tala-kem tiltam tabamnu namti, kaami atul kaali, ibi suunin disa; kamasi kaali, yak kanolin kukup yaapkan kiisiik tiltam tabokomip. Yale, kabak asiik kanum tal-unule, am mafiing diim kaali, abiltap-siik tiltam talokomu disa yo. ");
INSERT INTO tif_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Am bokon ma kaptam kasel iyo bokon kusnum ma kasel iso din-biliwale, kuno king kusnum ma ami tunum tiin moba ita taba-lomdip yak king kusnum ma ami tunum tiin mosa iso, dinan-tal-une-mokomip. ");
INSERT INTO tif_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kanu-biliple, am bokon yaapkan kala bombe kaali, bim aalap dukum ma kutaltam daa-lomda, tawaal kalawaali, kukula saan-bala fili-fili-ke-balale, ol fut am sole, angtiil mafak umkaamin am so, iyo daan tiltam tabe-biliple, mafek mafek ukol alik ma utamsip disa uyo, abiil tikiin kaptamu dikela tildaak tulula, unang tunum ili kanolin kukup tiltam tabokomu kaali, atin ti suunin dukum kaali, tiltam tabeyokomu kayi! ");
INSERT INTO tif_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yale, kabak-ali tiltam tabin disa bom ilula, kayak kayak ita taba-lomdip, ibi Yesus ami win diim kawu laabup o, ken-umbip kaami kalan kaata, ipni yim-tal-fuku kukup mafak kaayo, kukaayin-bamdip yim-baalip yak Juda kamok kamok imi sikil diim abamnipla, ita yam lotu am kaptam tii-lomdip, yim-bak saanbile, yim-baalip tam kalabus am unokomip. Ale, ma kaali yim-tama din tunum kusnum imi kamok kamok aye king so, kiyap so, imi diim kawu daaliwa, ita yim-buu weng yim-bak-saanokomip kabaku utamiwa yi, God almi weng kaami kalan namti kabuu no, kaliwa imi diim kawu nami sang namti bakayokomip o. ");
INSERT INTO tif_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kabak-ami kanum tiltam tabokomu kabak-ali ipkal utamipla, Awu, liip namti kaa tiltam tabu no, kala-lomdip unang tunum iyo nami sang so, weng so, kiita bakayokomip. ");
INSERT INTO tif_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ibi yim-tamalip din weng talalmin tunum imi diim kawu daalum o kalbip kaa, aket yaapkan kii fukun-bamdip: Kwin, kaso kawi! Dok kanolin weng kaata ma nokol maan tiiyokomup i? kemin disa; bilili-kup kala bomdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kanolin am daanokomu kaali, nalta aket fukunin tambal ayo kuya-lom ale, weng tambal baka-mokomip kaali, nalta kukuyilila, kipni weng kuuta uta uta ke-lom waasi imi weng kuluuli, dibiiwip tiil banokomu. ");
INSERT INTO tif_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Iltipni kawak-aalap so, nakal-fakal so, kawal so, kaptum kasal so, kiita, God ami lak kaa, duulin disa kemin, ibi yam-fatap-daa yim-baalip din kamok kamok imi sikil diim abamnipla, kamok kamok ilmi soldiya imi bokoyilip, malo ma ibi anulip taanokomip. ");
INSERT INTO tif_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kemin, ibi nami lak kaata-kup, duu-bom nami okok kebip o, kala-lomdipla, unang tunum yaapkan ita taba-lom ibi aket atul kukaayin-bam, itafii-mokomip. Yale, ");
INSERT INTO tif_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","nami lak uyo dukum-kup duu-bom bii taanipla kawu, God akal ibi tambal-kup tiin mo-laaba kemin, taandip maaklo ke-lokomip disa te! Ali yim-tama tam alami abip tambal kawu daalala, suunkup ilokomip o, kala Yesus ayo kanolin weng kaayo, kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus ayo weng ma imi bokoya-lomda: Ilom am ma daanokomu kaali, ipkal utamiwa yi, Waasi dinin tunum iyo tal abip dukum Jerusalam kaptam ayo falalnip kala, kalokomip kulu utamiwa yi, Abip namti ku-mafak-daalip abiltap disa ke-lokomu no, kalolip ko. ");
INSERT INTO tif_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kulu waasi tunum iyo kuno keya wakadaa unin o. Kemin, ibi Provins Judiya kawu bom-bilip namti, iltipni abip uyo kulaa kela ukadaa umbitam amdu tikiin kabale, sawaan-yaamin; ibi mep abip dukum Jerusalam kaptamu bom-bilip namti, baan abiltap uka-daalip din sawaanin; aa, iltipni langabip kawu bom-bilip namti, asuk abip unemin daa; abiltap kela yang sawaanamip kayi! ");
INSERT INTO tif_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sawaalak kaali, God ami weng Sukon Tem kabaku dola-lomdip: God ami Jerusalam kasel imi uluum iyo maan tiiya angtiil yol kukaayokoma kaami sang kaali bokosip. Kemin, waasi imi talokomip kabaku mep weng kala bokosip kaali, fan tiltam duuk-kup dakat kalokomu no. ");
INSERT INTO tif_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kabak-ami tiltam talokomu kawu, God ayo kuno tong-foko kamboyilaya, Judiya kayaak imi angtiil yol kaali, kuya-lomda kukup mafak uyo mep kanolin kiimi kuyokoma te! Kanola unang man kumun sole, manuuk so, imi ukadaa unokomip uyo fiit-bamdip tal-une-bam ale, angtiil yol dukum uyo kaa-bam ke-mokomip kemin, kwin! kiiso kawe! yakan-kaabi no. ");
INSERT INTO tif_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waasi tunum ita taba-lomdip Judiya kasel malo ma ili wan kong tup ye-bilip iyo taan-yaa-bilip; kuno malo ma kiitale, yim-tal-fuku sok de-yimu-lom yim-bii yak aba bilin bokon kusnum kawu kutii-bam ale, yak waasi yakal ilmi bokon ayo kulaa kela, tal abip Jerusalam kaptam ayo tiin mo-bomdip ti ku-mafak-dakamin-kup ke-bilip bombii, God ayo Jerusalam kaa kelalip ilmi bokon unokomip kaami diim kaali, tiltam tulula, unokomip kayi! kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesus ayo asuk weng akal alik ma bokoya-lomda: Am mafiing diim tiltam tabokomu kaa, atan, kayoop, wakalkan so, kiili, yakal ilmi kusnum ma ke-lokomip. Kemin, tawaal diim kalawaali yol ok daang kun fonfon tal-bom dukum-alomdu an-kulaala tildak ok balang abe-bamdu, weng dukum uun-una-tala-ken-umbu no. Unang tunum miit ma miit ma alik iyo kabak-ami kanum tulu kaa, uta-mokomip o! Atin suunin awak dukum kaali, kuluu-lom aket uluum dukum tabeyokomu no. ");
INSERT INTO tif_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abiil tikiin kaptam-ami wakalkan kiili, ilmi liip ayo kela-lomdip almi liip kusnum kusnum kawu tal-une-bala tal-une-bala ke-mokomip. Kanu-biliwa, unang tunum iyo itamiwa, Kaa kanum tabip uu! kala-lomdipla, abiin kaa talalu ma tiinokomip disa; ti suunin dukum kaata-kup ti kanu-bam ale, bokolip ko: Kwin! Tawaal diim kalawaata dok kanolin kukup mafak kalawuuli tal numi diim abon o, kalbu ni? ke-mokomip. ");
INSERT INTO tif_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kemin, kanolin kii kanumsi tal banipla, kulaata Dukum Ami Man Nayo ibin tem kabaku tilila, nami titil uyo kuluu-lomdila, atan alaltap ke tiin buluusi-kup sikin-bulula, kawu alik iyo nita-mokomip. ");
INSERT INTO tif_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kemin, ibi utamipla, Yak kanolin kukup uyo tiltam tabu kala, kalaliwa, kulu utamiwa yi, Nali abiltap tal kipni iliim bokoyokomi kala, kalalipla, kipni aket uluum tabebip uyo, kulu ditang-kala, kipni aket uyo titil-fak-daa tola-lomdip, nami liip uyo titam-daa fenipla talon o, kala, Yesus ayo fiyaap duumin weng uyo kanum kukaayin-bam bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Yesus ayo sang ma faldak-tii bokoya-lomda: Ibi as fik kuuli atamiwa, Kaami abuu-laamin kukup ayo dok kanu-bamdu abuubu ni, ken-umbip. Kemin, kanola ipkal mep as fik uyo utamipla, malap bam-daala namti, abuulon o, kalalu malap bam-daaba no, kalokomip. Aa, ipkal kanolin kabak-ami aket kaa fukun-bamdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kanolin tap kemin, utamiwa yi, Nimi kukup kanum talokomu kaami sang bakan-tabasi kaali, kulu tiltam tulu kala, kalokomip kaali, ibi utamiwa yi, God ami nam-baala tal unang tunum imi tiin molokomi kaami am uyo mepso tulu kala, kalokomip. ");
INSERT INTO tif_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nami weng kala bokoyokomi kaali, ibi weng san iliwa. Tunum unang malo ma tiin kawang bom-bilip kiili, taanin disa kuno bom ilipla, nami weng bokoya-lomdi: Ilom kaali, mafek mafek mafak alik iyo tiltam abokomu no, kalbi kaali, tiltam talokomu. ");
INSERT INTO tif_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Am ma daanokomu kuyaku, abiil so, tawaal so, kiili maaklo ke disa ke-lokomip. Yale, nami weng kuuta ti disa ke-lokomu dinim; kano ti suunkup ilokomu no, kala Yesus ayo faldak-tiimin sang ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Kulaa, bokoya-lomda: Nalmi kayaak kibi talalu utafii-bamdiwa yi! Unang tunum yaapkan iyo ima waan yam tabamnu no, kalalip suunkup inin-kup ke-bam ale, ok mafak ayo im-bom tikiiyila babon tal-une-bam saak yak tawaal diim kalawaami mafek mafek kiimi aket uluum kaata, tabe-bam ke-mokomu. Kemin, kibi mep kanolin mafek mafek kabak-ami aket kaata ti yan-laamin daa yo! God ami am mafiing am kaali, ali abil diila faksalin tap kebu kemin, unang tunum alik tawaal diim kala bom-bilip iyo babon-iliple, abiltap ninolin tap dik-yak daalale, kwin! kaluuso kawe! kalolip kemin talalu kabak utafii-bamdiwa kayi! ");
INSERT INTO tif_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kibi ti suunkup nami talokomi uyo utafii-bam fen-bamdipla, God ami beten kamaan-bam dik-dakaan-biliwa, God akal titil kaayo, kukaayin-balaya, yak kukup mafak tal kipni angtiil diim abokomu kaa, kipni aket fukunin kaa ku-mafak-daayokomu disa te! Ti suunkup titil-foko bom-biliwa, bii am mafiing diim kaa suunin disa; Dukum Ami Man, Nalmi talokomi diim kulu tol-nokomip o, kalala, Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus ami Jerusalam kaptamu bomdala, taap kaata lotu am diilim kawu tola-bomda, God ami weng kaata, unang tunum imi kukuyin-bam ale, kutamiip kaatale, tam Oliv Tikiin kawu beten ke-bam sin-sin ke-balale, ");
INSERT INTO tif_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","unang tunum yaapkan iyo din atamup, lotu am diilim kawu, Yesus ami weng uyo bakayin-balala, weng san-kaamum o, kalalipla kutim malang tem iyo suunkup talemip ko. ");
INSERT INTO tif_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret fuulip fasuulin disa kela inin kaami win kaali, boko-lomdip Pasova yo, ken-umbip kaami am uyo mep talan-sulule, ");
INSERT INTO tif_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","tunum awem imi kamok kamok so, lo utamsip so, iyo taken-bamdipla, Kalok kanola-lomduwa, Yesus kaa aalum i? kemip. Yale, unang tunum yaapkan kiita, Jerusalam kaptamu tala-tala-ke-lom, ang dinan tala-bilipla kemin, numi balaayin-bamdip yemilip o! kalalip, iyo suun-daa-lomdip maaklo kuwakamin liip kaata fen-bam ilip ko. ");
INSERT INTO tif_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Abip Keriot kayaak Judas ali Yesus ami daang bakaalin tunum talangkal iso nikil maakup okok kemin tunum la, Setaan ayo tal yak Judas ami aket tem un-ilomda ku-mafak-daalala utamala, ");
INSERT INTO tif_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","kamok kamok iyo kanolum o, kebip kala, kalba-kup, kulaa din itama, awem tunum kamok kamok iso, lotu am diilim kaptam-ami soldiya imi kamok kamok so, kiimi kalaan din bokoya ko: Nali Yesus kulaa dabaayi yak kipni sikil diim abam-nokoma kaptoop-ami liip kaata fenbi no, yakale, ");
INSERT INTO tif_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","kwin! iyo weng sandiwa, imi aket tem kaayo, atin tangbal ma keyilula, iyo bokola-lomdip: Sisol kabak-ami weng kaata, boko-lomdupla dotu kutiip-tup salala kup-tum o, akiwale, fan ");
INSERT INTO tif_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ayo imi weng bokolip ayo, weng san-ilomda, Ayo, yaka-lomda, bokola: Yi, siin atamila, unang tunum yaapkan iyo tiin kuwaalip kala, kala-lomdila kawu, Yesus ayo maaklo dabaayilila, yak kamok kamok kipni sikil diim abak o! yakalala, din liip fen-tal-unema ko. ");
INSERT INTO tif_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kulaa, bret fuu-bilip faskaamin disa ke-bala, inin kaami iintang am uyo daan tiltam tulule, Juda kasel imi kukup uyo ti kanumin kemin, Pasova am daan-laaba kaali, sipsip man iyo aa-bam fuu-bam inin kemin, ");
INSERT INTO tif_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","asuk kaami am uyo daanule, Yesus ayo Pita so, Jon so, alep imi bokoya-lomda: Alep kipta dindip Pasova inokomup kaami mafek mafek iyo talalu kutii kemipla, nuyo din unupla alimal tiin-bom inum o, yakale, ");
INSERT INTO tif_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ili bokola-lomdip: Din ilom am kaa doku-bomdup inin kaa talal-bam dotmupla, din unokomip i? akiwa ");
INSERT INTO tif_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ayo bokoya-lomda: Nayo kabak-ami weng ma bokoyokomi kemin, weng san bom iliwa! Alep ibi din Jerusalam aba kem-siliple, okok kemin tunum ma tal ita-mokoma kemin, ami atamipla, ali unang imi ok lan-umbip tap ke ok ket dukum ma tawaal ta talalusip kaptoowu ok iluu kutam dabom diim tii kulii-talaba ami daang tem kawu, yak ami daang bakaalip, din am unokoma kaali, ti kipso aso tam am abale, ");
INSERT INTO tif_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","am kayaak ali kutamu bombe kemin bokola-lomdip: Yi, numi kukuyin tunum ayo weng ma kup-ta nuli kulii-tulup kemin, ali bokop-ta-lomda: Kapni am kultamu am anung ma kiin ukuyilawa, nami daang bakaalin tunum iso naso kaptamu bomdup nokol Pasova uyo inamnum o, kalaya tulup o, kala kanum bokola tulup te! kala bokolipla, ");
INSERT INTO tif_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","kulaa, am kayaak ayo kipni weng uyo weng sanba-kup, yim-bitam am tip kaptoowu am anung dukum ma kabang-ata kukuyila utam talaalipla, ima fuumin kaami mafek mafek alik ti kaptamu bom-bilip kala, kalalipla, kaptamu inin-inin iyo talal-bam iliwa yo, yaka-lomda ");
INSERT INTO tif_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","alep yim-baala din uliwa, Yesus ami weng bokoya tulup ayo, tifan tituun-kup kelu kala, kalale, Pasova kaami inin-inin iyo kaptamu talal-bam fuumip ko. ");
INSERT INTO tif_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bom bii atan uyo yak tem unula, Yesus ayo almi daang bakaalin tunum iso, iyo tal Jerusalam am ukduu kuyinbip kaptamu tiin-bomdipla, ima im-bom ale, ");
INSERT INTO tif_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","kulu almi daang bakaalin tunum iyo bokoya-lomda: Nami aket dukum fukunbi kaali, angtiil yol ayo kuluu-lomdi saaknin disa, ilomdila kawu, kipso Pasova ima kaa ina-lomdila yo! kalbi no. ");
INSERT INTO tif_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nami weng kala bokoyokomi kaa, ibi weng san iliwa. Kamala kulaata nali mafiing mafiing kipso tiin-bom Pasova ayo inbi kaa, tawaal diim kalawaali maso ma inam-nomi disa; kuno kela bom-bili bii, am ma daanula kawu, Atok God ata alik tiin molokoma kaali, Pasova kaami miit ayo ku-fatap-daalokoma kabaku, asuk Pasova uyo maso ma inam-nokomi no, kala-lom kanum bokoyinsa ko. ");
INSERT INTO tif_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesus ayo wain ok ayo kaap tem iluu kutii kela God, Ami yaap ke yo anba-kup, kulaa almi daang bakaalin tunum imi kuya bokoya-lomda: Wain ok kalawaali, kuluu-lom ma asiik inamna inamna kelin o, yaka kanoya inam-niple, ");
INSERT INTO tif_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","bokoya: Weng selin! Nali kamala kaali, wain ok kalawaali maso ma inam-nokomi disa; kuno kela bom biili dok kanumin diim kabaku God ami unang tunum alik iyo tiin molokoma kawu, asuk tiltam tulu kala, kalaliya kawu, inam-nokomi kayi! yakale, ");
INSERT INTO tif_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","kulaa, bret uyo kuluuba-kup, God ami yaap ke yo, anba-kup, lo kutii almi daang bakaalin tunum imi kuya-lom, bokoya-lomda: Bret kalawaali nalmi tiil ultap kemin, kipni iliim kabak-ata boyon o, kalalila, nalmi tiil kala kuyokomi kaa mep ima bret kuyokomi kaluuli kuluu inamnin aa! Ilom am ma daanula kawu, asuk inokomip kaali, asuk nalmi tiil kuumi aket kaata, fanang daka-bamdiwa inin o, kala-somla ko. ");
INSERT INTO tif_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kanola Pasova ima ayo inamnip disa kelule, Yesus ayo wain wok ma iluu kuyinba-kup bokoya-lomda: Wain ok kalawaali nalmi kiim alaltap kemin, nami nelip taanila, nami kiim sing-tam-daa tildaak abam-nokomu kaali, ipkal utamiwa yi, Ipni iliim uta boyon o, kalalila, nalmi kiim ayo kamboli sing-tam-daalu kala kalaliwa, yak God ami weng alokso kaa kutiisa uyo, fan tiltam duuk-kup dakat kalu nu, kalokomip kayi! yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kanumin sang uyo kanum bokoyinba-kup, weng akal alik ma ayo bokola: Nak-tunum kusal, kibi weng selin. Tunum ma nam-fatap-daa nam-baala yak nami waasi kep-ninsip imi sikil diim abam-nokomi ali naso tiin-bom ima imbup. Kemin, ");
INSERT INTO tif_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","siin sawaayak kawu, God ami aket fukunin ayo, Nami Man kaali, dabaali daak unokoma ayo, kanola taanokoma kayi! kalsa. Yale, dok nolin tunum ma ata Dukum Ami Man nam-fatap-daalokoma kaata ti, almi uluum tem diinokoma kayi! kala, Yesus ayo kanum bokoyilala, ");
INSERT INTO tif_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","almi daang bakaalin tunum iyo weng sandiwa, nikil iyo aket uluum tabeyule, dik-daala una-tala ke-bam ale, bokolip: Nikil numi iipyak tem kultam bombe kaa, dok kanolin tunum kaata dap-fatap daalokoma ni? Ken-una-tala-kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesus ami daang bakaalin tunum iyo weng aal dikin-una-tala-ke-bam boko-lomdip: Nulmi tunum kaa, kanata ma tiltam numi dabom ke-lokoma ni? kemipla ");
INSERT INTO tif_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus ayo bokoya-lomda: Tawaal diim kalawaami God ami lak duu-laamin disa tunum kiimi kamok kamok ili tunum unang titil-kup tabin kukup kaata, fuku-bomdiwa tiin saan-tabasip. Kemin, imi aket fukunin kaali, unang tunum kiita, numi tong kaata-kup bakayin o, kal-bomdiwa, disa iip bakayin-bamdip: Nuli unang tunum kipni dong dakaayin tunum o, kem-laabip. Lale, ");
INSERT INTO tif_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ibi imi kukup kanun-umbip kaa kipkal utabip-kup kanumin disa; kemin, dok kanolin kapta talaba tam kaptum kusal imi dabom kelap namti, kabi ti, Nalta-kup o, kalalawa, kaptum kusal kii titil eng kaa bakayin disa; ti ilmi niing alaltap kelawa, kaptum kusal imi ok tabuulin tunum tap tambal-kup tiin molokomap kaata, fan mokso ke-lokomu; le kabi talaba tam kaptum kusal imi kamokim kelap kaa disa kawu tiin-yaamin disa; kaptum kusal imi ok tabuulin tunum kelawa, dong dakaayin-balawa yo! yaka. ");
INSERT INTO tif_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kemin, tunum win tibin asole, almi okok kemin tunum iso, imi kukup kaali, kipkal utamsip, tiin-bomda naan-balala, ima kutal dakan-bala inba kaata, tunum win tibin elile, yak ima ifa kulii-tala ata tunum win tibin e? Kulaaye? tiin-bomda ima inba kaata, tunum win tibin. Yale, nali kipso laabi kaali, nali ma kanun-umbi dinim; kemin, okok kemin tunum tap ke-lomdila, nali kipni dong dakaayila-yaabi. ");
INSERT INTO tif_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kukup mafak tiltam nami diim aben-umbu kaa, ibi nili kep-nansip disa; ibi ti suunkup nami diim kaldaku fewa-laabip te! ");
INSERT INTO tif_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Kulaa, Atok ami kanop-ninsa ultap ke-somdila, nakal ti ibi kanoyokomi. God alta uldaa-nam-buu-lomda, almi titil ayo kup-ninsa. Kemin, ami win diim kawu unang tunum iyo tiin molokomi. Kemin ultap o. Am ma daanala kawu, ipyo yim-buu-lomdi yim-bii din nami abip kawu, ipso naso maakup tiin-bom ima inbi-lomdup, titil kuyila, nami win diim kawu, Israel imi tunum miit talangkal iyo ipkal taba-lom miit maakup e kala, tiin mola tiin mola ke-lomdip yim-bak-saanokomip o, kala Yesus almi daang bakaalin tunum imi kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesus ayo Pita ami bokola-lomda: Nak-tunum Saimon aa, kabi weng san ilawa! Setaan ali alik ibi yam-kuku-bamdala, Awu, kibi God ami man e nalmi man e yokon o kalala, God ami dik-daalaya, God ali, Ayo, kala kemin, tunum ma wiit lap kiiyo foko tam-aba-tildaak-aba ke-bilipla, bulung iyo, takela yak ban-ilomdip, tiil kaata-kup daak kabas diim abebip ilaltap ke, Setaan akal yim-baala tam aba daak aba ke-bam yam-kukulala, ibi kulii daak abokomip kayi! ");
INSERT INTO tif_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lale, nalile God ami beten kamaan-bam ale bokola-lom: Atok kapyo, Setaan ata Saimon ami dap-kululala kanolokoma kemin, kabi dong dokolapla, ami kukup mafak uyo taba-lomdu ami lak dakaamin kaa ku-mafak-daalamu disa yo, kal-bomdi beten kebi. Kemin, ilomdapla kawu, kabi asuk aket fal-siki-lomdap, aket kup-nokomap kabaku, kapni aket fukunin uyo bam-daap-tokomu kawu, kaptum kusal iyo dong dakaayin-balapya, imi aket fukunin uyo baayilula, titil-fokolik o, kala Yesus ayo Pita ami kanum bakaala ko. ");
INSERT INTO tif_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita asiik bokola-lomda: Kamokim aa! Nali ti kapso maakup kuno yim-tama din kalabus am daalalip. Katale, kapni diim kawu ti fep-nami le, kuno kapso alep maakup yelalip. Katale, kuno nakal ti yak kapni diim kawu fep-nami no! kemale, ");
INSERT INTO tif_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesus ayo Pita ami bokola-lomda: Pita kawe, kabi talalu weng san ilawa! Nali bokop-ton: Kutim malang tem kawu, awon kakaruk ayo naan-tabin disa ilala, kabi, Ni kaa ma atamsi disa yo, nakan-kaabi du asuumano fak-daalokomap te! aka ko. ");
INSERT INTO tif_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kulaa, Yesus alami daang bakaalin tunum imi dik-daaya-lomda, Siin kaali, bokoya-lomdi: Ibi moni so, ima men so, yaan-alom kiiso, kulii bomdip, nami ok kaa okok kem-tal-unemin disa yo kala, dil mo-lom, yim-baali tal-unemsip kaa, mafek mafek so ma iiwa-silip ema? kala, dik-daayilale, Yi, disa. Mafek mafek so ma iiwa-sulup disa yo, akiwale, ");
INSERT INTO tif_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesus ayo bokoya-lomda: Kamala kula tiinbup kaali, ukol ulmi kusnum. Moni, ima men, kulaa bom-bilip namti, kuno kulii ale, bainat ayo disa yo, kalip namti, iltipni ilim saket kulaata dulduu kulin tiilipla, tunum kusnum ita tam mo-lom kabak-ami moni kaata kuluu-lomdip, bainat ayo mo kulii bomdiwa tal-unemalip kayi! ");
INSERT INTO tif_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kemin, kibi nami weng kulaa, weng san iliwa! God ami Sukon Tem kabak-ali boko-lomdu: Kiili kukup mafak kaali, fuut tabin imi kukaayila-yaabip ultap ke, tunum kaami konsip kayi! kalsu kulaa nalmi sang kulaata bokosu te! God ami Sukon Tem alik nami sang bokosu uyo ti mepso dik-tam-daa tiltam tolon e, kalbu kemin ale, kanolin kukup mafak uyo mepso kukaap-nokomip o, kala kanum bokoyale, ");
INSERT INTO tif_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","almi daang bakaalin tunum iyo weng san-ilom bokolip: Kamokim aa, ti kala daatama bainat alep kala bom bilip kalaayo, akiple, Yesus ayo utama yi, Daang bakaalin tunum iyo kukup mafak tildak nami angtiil diim tildak abokomu uyo talalu utamin disa ke-bom bakabip o, kala, kala-lom, bokoya-lomda: Ti, bokoli kemin ti te. ");
INSERT INTO tif_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus ayo amdu Oliv Tikiin kawu ti suunkup God ami naan-bam beten kamaalin-kup ken-umba kemin, kaami kutamiip kulu almi kukup kanun-umba kaata-kup kuluu-lomda, daang bakaalin tunum iyo foko kuliila Jerusalam ayo kambo kela, Oliv Tikiin kawu ");
INSERT INTO tif_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","alimal din abale bokoya-lomda: Kukup mafak uyo tal yam-kukulon o, kalalula abiltap tal kipni diim abam-nokomu kemin, ibi God kaa beten kamaan-bam, dik-dakaan-biliwa, ata dong dakaayin-balala, ban kemin kukup uyo tal ipni diim abemin kaa, uktayuk o, yimba-kup, ");
INSERT INTO tif_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","alami daang bakaalin tunum iyo kulu bom ilipla, keya mep yang kulu tilik duung fakela daak tiin God ayo beten kamaan-bam bokola: ");
INSERT INTO tif_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Atok God kapyo, mep kukup mafak tiltam nami diim talon o, kalbu kuluuyo, kaltapni san kemin, dil molan o, kalap namti, dil molawa kawu, nayo angtiil yol kaa kuluulin disa kelon o. Nali mep kanolin kukup uyo tal nami angtiil diim kaa abemin disa yo, kalbi. Lale, nami fanang daka-bamdi Aatumen kabi kabak-ata dil moyawa, kep-nuk o, kebi kaali, kabi kuluu kanumin disa; kaltapni aket fukunbap kaata-kup kuluu kanumon o, kalolap kaali ti yaap o, kal-bomda beten ");
INSERT INTO tif_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","kem-salale, kulaa, ensel ma tildaak-ilomda dong dokola-lom, dap-titil diilale, ");
INSERT INTO tif_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus ayo kwin! angtiil mamin dukum kaata disa akal ma ok fon tap kelule, aket uluum dukum uyo kuluu-lomda asuk God beten kamaan-bam, almi aket uluum kuluula, kaami sang kaata, bakaan-bam kem-salale, ami mamin ayo kiim tap ke-lom dung-dung-ke-balala, ");
INSERT INTO tif_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","beten kemsi kelale, din ulala, Kwin! almi daang bakaalin tunum namti aket uluum-kup keya-lomdu, daal-kup tabeyu akan-fak-liibip kala kalale, ");
INSERT INTO tif_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kulaa, yam-kafalna tam tiinip bokoya-lomda: Ipyaa! Ibi akan-unemin disa te! Mafek mafek mafak tal yam-kula molokomu kemin, baan tam tiin God kaa naan-bamdiwa yo, kala Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus ayo kanumin sang bakayin-salale, kulu tunum yaapkan iyo tilip. Judas ali Yesus almi kalaan tunum kelala, nikil talangkal ke-bom tal-banen-umbip ata, kulaa Yesus ami bombe bokon kaayo, liip kukulala tal-ilomdip, kula Judas ayo tal Yesus ayo dap-kiil-mon o, kalala, bital mepso kulu talale, ");
INSERT INTO tif_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesus ayo bokola-lomda: Nak-tunum Judas kapyo, kabi tal-ilomdap Dukum Ami Man Nayo, nam-kiila tal-bomdawa, nam-fatap-daa dabaali yak waasi imi sikil diim abamnak o, kalalawa, tal nam-kiil-mon o, kebap ema? kala, kanum bokola ko. ");
INSERT INTO tif_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesus ami daang bakaalin tunum aso bom-bilip ili tunum kii, itamip yi, Yesus ayo dap-tal-fukulum o, kalbip kala, kala-lom Yesus ami bokola-lomdip: Kamokim kapyo, nokol nulmi bainat ta ma kuluu-lomdup yemalup yoko? akiwale, ");
INSERT INTO tif_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","awem tunum imi dabom ami ok tabuulin tunum ma bombe kemin, daang bakaalin tunum ma ata almi bainat ayo kuluu-lomda, mep tunum kaami talang-kaal tiing tup kaayo, tuk-duu kulaala daak abamnale, ");
INSERT INTO tif_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesus ayo atam-ilomda, daang bakaalin tunum imi yim-bak-saan-bam ale, bokoya-lomda: Kaa kanumin disa yo, yaka-lomda, tunum kaami talang-kaal kaayo, kutal-fukula, asuk tambal ma ke-lom mokso kelu ko. ");
INSERT INTO tif_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kemin, awem tunum imi kamok kamok aye, lotu am diilim kaptam-ami soldiya imi kamok kamok, aa saak yak kamok kamok malo ma kii bom-bilip kiita, tal-ilomdip Yesus ayo dap-tal-fukulum o, kalalip tal tolniwale, Yesus ayo bokoya-lomda: Kipni aket fukunbip kaa nali, Banengim tunum atulim o, kalaliwa, nami atul kaata, ipyo suun-daa-lomdip wan so, bainat so, as sukum so, kiita, daka-bi-lom kulii-tal nam-tal-fukulum o, kalalip baa tal akip-nip o? ");
INSERT INTO tif_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Am yaapkan daan-laabu kaa, nali lotu am diilim kaptam tiin-bomdi unang tunum ili kaa suunkup kukuyin-bilila, kaa nitam nitam ken-umbip. La, ibi tal kaptamu nam-tal-fuku sok dep-nin disa nosip. Kata, kamala kulu God ayo kutamiip kaami miit tiin saanin tunum Setaan ayo kambolala, almi aket fukunin ayo kipni kuya-lom, dong dokoyilala, Kanumum o! kalalipla, Awu, numi liip uyo bombuu nu, kala-lomdipla, baa tal nam-tal-fukulum o, kalalipla, tilip o kala, Yesus ayo kamok kamok imi kanum bokoyila ko. ");
INSERT INTO tif_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesus ayo kanum bakayinsi kamboyilale, soldiya iyo yak dap-tal-fuku dap-tamalip dibii yak aba din abip tam-ilom awem tunum imi dabom ami am kaptam uniwale, Pita ayo samaan so kaptoowu tip-tal tip-tal yak aba tam ");
INSERT INTO tif_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","awem tunum imi dabom ami uti daam tem ula, Okok kemin tunum iyo abip daal iip kabaaku as kuyak daalip kiin-balala, tunum malo ma tal tiin-bomdip wing tiil ayo falala kuyak mobip kaa kalba-kup, akal yang itama iso tiin-bom diil fuumipla, ");
INSERT INTO tif_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ok tabuulin unang ma ukol atam talaalu yi, Ayo tal as dawang falala kalba kabaaku tiinba kala, kala-lomdu tiyak daa talalu atam ale kulaa, tunum kulu tiinbip imi bokoya-lomdu: Kipyo, mep tunum kula tal tiinba kuluwaali, Yesus ami daang bakaalin tunum te! yukule, ");
INSERT INTO tif_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita ayo yawaal daa-lom bokowa-lomda: Kupyo, nali tunum kaa ma atamsi disa yo! wakale, ");
INSERT INTO tif_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","bom ilanale, tunum ma ayo Pita ami atam ale bokola: Kabi ti mep tunum kaami daang bakaalin tunum te! akale, Pita asiik asuk bokola-lomda: Kapyo, nali ti atin disa te! aka-lomda ");
INSERT INTO tif_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tiin bom ilale, tunum kusnum ma asiik tal bokola-lomda: Nali mep tunum kalawaami weng bakaba kaali, weng seliya, Provins Galili kayaak o, kali kemin, kaali Provins Galili kayaak Yesus ami daang bakaalin tunum o! kala, ti kanum bokola bokola kemale, ");
INSERT INTO tif_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita asiik bokola-lomda: Kapyo, kapni weng bakabap kaali, nali weng san-ilomdila, kabak dok kanolin sang kaata ma bakabap o, kalbi disa te! kalale, kulu maak fak-daalin tap, awon kakaruk aalap ayo naan-taba ko. ");
INSERT INTO tif_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kamokim Yesus ayo kuyaku fal-siki tiyak-daa Pita ayo talalu atafiimale, ayo asuk aket fanang daala yi, Awu, Yesus ami kamasi bokop-na-lomda: Awon kakaruk aalap ayo naan-tabin dinim kama bom ilala, Pita kabi nami sang ayo bokop-na-lom: Ni kaa ma atamsi disa yo, naka-naka kemsi liip asuumano fak-daalokomap o, namba kaali, fan kaa kanoli kala aket fuku-daa-lom ");
INSERT INTO tif_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","utama yi, Kwin! Fan, Yesus ami win kaali, kuwaala-lomdi, Kaa ma atamsi disa yo, kali kaali, atin ti kukup mafak kaata kuluu-lomdila, kanum bokoli kawi! kalalala, keya tam daak uti am kaba-lomda dukum-kup iin-bam amama ko. ");
INSERT INTO tif_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Soldiya Yesus ami tiin mobip iyo Yesus ami atafiimin weng bakaan-bam biwakamiple, ");
INSERT INTO tif_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","kanolin kukup kaata kanu-bamdip, Yesus ami tiin matum ayo ilim ta kuluu de-lomdip, aa-bamale, atafiimin weng uyo, boko-lom: Kabi kamboyap unang tunum ili bokop-ta-lomdip: Kabi God ami weng ku-fatap-daa bakayin tunum o, ken-umbip. Yale, kabi talalu utamsap namti kulu balap ema? Kapyo, tunum ma tal tela kaata bokoya-lomdap, kaali ata tal nelan i? yakawa, atamum o, akan-kaa-bamdip ");
INSERT INTO tif_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","saak weng mafak disa akal almi weng mafak mafak kiita bakaan-bam kemip ko. ");
INSERT INTO tif_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kulaa, am daanale kawu, Juda imi kamok kamok iso, awem tunum imi kamok kamok lo utamsip tunum iso, iyo weng bakamum o, kala, tala-tala-ke-lomdip tal ilmi weng bakamin am kaptamu tal tiin-ilomdip, soldiya iyo Yesus ayo dibii-din imi diim daaliple, ");
INSERT INTO tif_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","kamok kamok iyo Yesus ami bokola-lomdip: Kalo, kabi bakayan o! Kabi God ami ulduusa tunum Kraist ema? akipla, Yesus asiik bokoya-lomda: Nali bokoya-lomdi: Nali God ami ulduula-nam-buusa tunum Kraist o, kalokomi kaali, ibi kabak tifan bakaba no, kalokomip dinim. ");
INSERT INTO tif_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kanolin ultap kemin, nakal weng ma dik-daayokomi uyo, ibi maan tiip-nokomip disa. Yale, ");
INSERT INTO tif_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","nali weng kulawuuta-kup bokoyon o, kalalila, kamala kulawu kulii yak aba kaptoop unokomu kaali, Dukum Ami Man Nali, Kamokim ami tiin-laamin baan diim ayo kuluu-lomdila, titil-kup tabasa God ami sikil tingtup diim kabaku tiinokomi no, kala kanum bokoyale, ");
INSERT INTO tif_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","alik iyo bokola-lomdip: Yak kanum bokolap kaa: Nali God ami Man o, kala bokolap ema? akiwale, Yesus asiik maan tiiyila-lomda: Ipni kabak-ami bokop-nip kabak-ali ti fan te! yakale, ");
INSERT INTO tif_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ilmi weng-kup boko-una-tala-ke-bam bokolip: Nuli almi weng bokola kuu, nulmi talang tem alep alep weng sanup yi, Ali fan ban kemin tunum o, akup kemin, nuli tunum ma fen-bam atamupla, ata Yesus ami sang kaali maso ma bokoyokoma dinim o, kala ilmi weng-kup bakamip ko. ");
INSERT INTO tif_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kamok kamok alik iyo Yesus ayo dap-tamalip yak aba bilin Rom kasel imi kiyap Pailat ami diim daale, ");
INSERT INTO tif_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","faldak-faltalak ke-bamdip, disa weng mafak mafak uyo baka-bam boko-lomdip: Tunum kalawaali, numi weng sanbup kaa Juda, numi unang tunum imi kasen-foko neyin-bamda boko-lom: Ibi moni takis ayo kuluu Rom kayaak imi King Sisa Juda kipni tiin molin kaa kukaalin disa; nata God ami uldaa-nam-buusa Kraist kemin, nali kipni king o, kalala atam-ilomdupla kaata, dibiilup kapni fanang tulup o, akiwa, ");
INSERT INTO tif_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat ayo weng san-ilomda, Yesus ami dik-daala-lom: Kabi Juda-miin imi kamokim king namti kulu-balap ema? akale, Yesus asiik bokola-lomda: Nali kaa ma bokolin disa; la, kabak kaltapta bokolap o, aka. ");
INSERT INTO tif_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kemin, Pailat ayo awem tunum imi kamok kamok aye, yak tunum kusnum yaapkan imi bokoya-lomda: Kipyo, nali tunum kala atamila, ali kukup mafak so ma nolaya, dibii-tilip dinim; (kemin, nali nalmi soldiya iyo ma bokoyilila, angtiil yol kaa ma kolokomip disa) te! yaka. Katale, ");
INSERT INTO tif_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","(kiimi aket fukunbip kaali, Pailat ami uko-tokolupla, kukup mafak ma Yesus ami kolak o, kala-lomdip) asuk dukum-kup naan-bam bokolip ko: Kaali Provins Judiya abip ma ma kayaak imi tunum alik imi wiis-saayin-bam bakaya-tal-une-bamda Rom kayaak iso waasi dinum o, kebip o. Kamosinim kanolin kukup kaali, Provins Galili bokon kaptam asiik kanum tabasa. Kemin ale, kamala kaata tal numi Provins Judiya kalawu kanum tal-uneba no, kala kanum bakalip ko. ");
INSERT INTO tif_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat ayo weng kaayo, weng san-ilomda, dik-daa-lomda: Awu, tunum kalaali Provins Galili kayaak ema taa? ");
INSERT INTO tif_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ayo, tunum kaali Galili kayaak ta! akipla kemin, sawaayak Rom kaptam-ami king Sisa ata Herot uldaa-dabuu bokola-lomda: Nalmi win diim kaata, kabi Provins Galili kaptam-ami unang tunum iyo tiin molokomap o kalaya, tiin mosa. Kemin, Pailat ali utama yi, Kama kuluwaata Herot ali Provins Galili kulaa kela, kiin tal Jerusalam kalawu bombe no! kalba-kup, kulaa Yesus ayo dibii-tal ami diim kawu dabak molum o, kalalip dibii tilip, Uyo, kaa nami ok disa, Herot almi ok alik o, kala-lomda almi waasi dinin tunum soldiya iyo weng umbaaya tal Yesus ayo dibiilip din Herot ami diim daalip ko. ");
INSERT INTO tif_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Siin kawu Herot ayo Yesus ami sang baka-bilipla, weng san-kaa-bamdala, Naka Yesus kaa ma atamon i, ken-umba. Kemin, ami aket fukuna kaali, kukup ukol alik kaata ma kanu-balala atamon o, kem-tabasa. Kemin, Yesus ayo dap-tal-fuku dibii-din alami diim daalip atam-ilomda, ami aket uyo disa akal ma ke-bam fiyaap duumale ");
INSERT INTO tif_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","kulaa, Herot ayo ti weng yaapkan kaata, Yesus ami dik-daa kala. Katale, Yesus ayo weng anung so ma telama disa, kelaya, ");
INSERT INTO tif_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","awem tunum imi kamok kamok sole, lo utamsip tunum iso, yakal ti Herot ami be un-ilom taklii yang mepso kuluba-lomdip, Yesus ami sang kaata ti mokop faldak-faltalak kamaan-bam disa weng mafak mafak kaayo, bakaan-bilipla, ");
INSERT INTO tif_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yesus ami weng dinim ke-bom-balaya, Herot asole, almi Provins Galili imi soldiya iso, iyo atafiimin weng bakaan-bam, kukup mafak kukaan-bam ale, king ami ilim tambal mikin-umba tap ke, mikelale, nong saan-am-bam fan ti king ami weng umkaalin ultap kamaansi kelale, kulaa almi soldiya iyo bokoyilala, Yesus ayo dap-tamalip asuk Pailat ami be kawu unip. ");
INSERT INTO tif_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Siin kaali, Herot so, Pailat so, alep ili waasi kela una-tala-kesip. La, alep kamala kulaata aptum kela una-tala-keliwa ilip ko. ");
INSERT INTO tif_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat ayo awem tunum imi kamok kamok sole, Juda imi kamok kamok sole, tunum kusnum so, iyo naan-daaya tala-tala-ke ang-delipla bokola: ");
INSERT INTO tif_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ibi tunum kalawaali dibii-tal nami diim daa bokop-na-lomdip: Tunum kalawaali, Juda imi wiis-saayin-balala, Rom kayaak iso, dinalupla yo, kalbip o, kalip. Lale, kaami sang kaali, iltipni tiin diim kulu ali dik-dakaanbi. Katale, nali atamila, Ali kukup mafak so ma noba disa yo, kalalala, ");
INSERT INTO tif_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot akal Yesus ami dik-dakaan-bam atamala, Ali ban ma keba disa yo, kala-lomdala, asuk dabaala nami fanang tala. Kemin, nali utamila, Kipni aket fukunbip kaa soldiya imi bokoyilila, Yesus kaa aalip saaknak o, kali. Lale, Yesus ali ban ma keba kelala, kata nali bokoyila aalip taanokoma disa. ");
INSERT INTO tif_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nali soldiya imi bokoyilila, sok faklet ta langatal kaanbi kamboliwa, ami sok kaa tildaa dabaali tabanak o, kalokomi no, kema ko. ");
INSERT INTO tif_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mep Pasova inin kaami diim ayo wasital maakup e kala duk-duu-lom kawu ina-ina ken-yaabip. Kemin, inip kaali, Pailat ali Jerusalam kaptam-ami kiyap imi kukup kaata, kuluu-lomda kanolila, Juda-miin iyo nami kanoli kaami fiyaap uyo ma duumik o, kala-lomda soldiya imi bokoya-lomda: Juda-miin sok laabi im-tiisip imi maakup ma kulaata dildaa dabaalip tabanak o, yaka-yaka-ken-umba. (Kemin, kulaali Pailat ami aket fukunba kaali, soldiya iyo bokoyila, Yesus ata sok tildaa dabaalip unak i! keba). Lale, ");
INSERT INTO tif_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Juda iyo alik maakup dukum-kup naan-bamdip bokola-lom: Bokoyapla, tunum kulaa aalip taana le, Barabas atale, sok tildaa dabaalip unak o, kal-bomdip mamdet kuyak daa-bom kanum bakaalip ko. ");
INSERT INTO tif_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tunum Barabas kaali, sawaalak kawu Rom kasel so din-bomdupla, Juda numi bokon ayo kela-lomdip ilmi abip unin o, kalala, Barabas ata tunum malo ma nen-bam titil tibin weng kaata, bakayim-balala, iyo Barabas so, ke-lomdip, Rom kasel tal abip dukum Jerusalam kaptam tiinsip iso, dinan-taba-lomdip nikil ita tunum malo ma iyo anulip saakniwa, Rom kayaak ita ita ke-lom Barabas ayo dap-tal-fuku-lomdip, sok de dibii-din kalabus am daalip laaba. La, ");
INSERT INTO tif_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat ayo soldiya imi bokoya-lomda: Yesus ayo sok tildaa dabaalip unak o, kalala, asuk tunum yaapkan imi bokoya. Katale, ");
INSERT INTO tif_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ili ti weng sanamip disa ke-lom, asuk dukum-kup fuuta una-tala-ke-bam, Tunum kaa ti dibii-din as diim kawu aalip taanak o! Kaa dibii din dabak as diim daa aalip taanak o, kal-bomdip weng dukum-kup bakaalip. ");
INSERT INTO tif_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kemin, liip alep fak-daa kamboyinba-kup, ma kaami diim kaata Pailat ayo bokoya-lomda: Kaa dok kanolin ban kabak-ata keba kala-lomdupla, kabak-ami kalan o, kalaluwa aalokomup i? Nali atamila, Ali kukup mafak aye ma keba dinim o, kali kemin, nali kaa bokoyila aalip saak-nokoma disa. Kulaa kela bokoyilila, disa sok faklet ta kuluu langatal kaanbi kela-lomdip, dabaalip tabanak o, kalokomi no, kala ko. ");
INSERT INTO tif_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Juda-miin ili Pailat ami weng kaa weng sanokomup disa yo, kala-lomdip imi aket fukunin ayo Pailat kaa, Numi weng kaata-kup weng seya kutal-fukuyak o, kala-lom dukum-kup ti suunkup naanin-kup ke-bam ale, Kaa kanumin disa yo! Ti bokoyap dibii-din as diim daa aalip taanak o, kal-bom dukum-kup naan-bam ale, kulu Pailat ami fanang saanin ayo ku-mafak-daaliple, ");
INSERT INTO tif_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailat ayo Juda imi kamok kamok imi kabak-ata kanolan o, kalbip namti, kanoya-lom, ");
INSERT INTO tif_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","almi soldiya imi bokoya-lomda: Ibi din kalabus am tunum ma gavman so din-bomdip tunum anula taanipla, ayo sok de dap-tal daasip ata sok tildaalip tabanala, Yesus ata dibii-din as diim daa aalin aa! yaka ko. ");
INSERT INTO tif_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rom kaptam-ami soldiya iyo Yesus dap-tamalip abip Jerusalam kaptam kambolalip um-bom ale, tunum Provins Sairini kayaak ma Saimon o, akan-kan-umbip ayo tal liip kawu itamale, Saimon ali saaklo kawu tal Jerusalam unon o, kala talala, soldiya iyo yak dap-tal-fuku fal-siki dap-tii-lomdip Yesus ami as tiim uyo kuluu kuyak nakal tela bokolip: As tiim kala kuu nakal tiilap, yak Yesus daang abap unip unum o, akiwale, kulaa fan as tiim kuluu kuu nakal tiilala unip ko. ");
INSERT INTO tif_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Una-bilipla, tunum unang yaapkan itale, Yesus ami mafiing tem kaptoowu tal-bomdiwa, unang malo ma ita ti aket uluum ke-lom mafak keyu dukum-kup amamiple, ");
INSERT INTO tif_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus ayo weng san-ilomda, fal-siki-lom imi bokoya-lomda: Jerusalam kasel unang tunum aa! nami kalan kaa amamin disa yo; ti iltipni angtiil kalan so, man kalan so, kiita amamin o! ");
INSERT INTO tif_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kibi weng selin! Ilom am ma daanula kawu, waasi ita tal-ilom kipni angtiil yol uyo kukaayokomip kawu, awal unang kipyo, iltipni man angtiil yol daka-mokomip kaami kalan kaata, ama-bam boko-lomdip: Unang man dinim so, unang kama man kuulin disa bombuu so, aa unang man amaat kama muuk kuuwin disa bombuu so, ita tambal-kup aket uluum so ma kuluulin disa kelip o, yokokomip kemin, ");
INSERT INTO tif_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","kaami am kaa daanokomu kaali, unang tunum iyo amdu fiil dukum ami bokola-lomdip: Yi, ti balduu kulii tildaak yim-baak mo-lom yelawa baan saaknum o, ke-mokomip. ");
INSERT INTO tif_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kemin, as wiis kaami kuyak daalip kiin-tabemin kulaa mamin katip sakap ke-lokoma ale, as dat kaami kuyak daalokomap kaata, abiltap kiin-taba-lom mamin dukum ke-lokoma. Kanolin kemin, nali as wiis alaltap ke, nali kukup mafak kaa ma kanolin disa kesi. Lale, kiita angtiil yol ayo kup-nokomip, kemin ale, mep Jerusalam kasel kipta ti as dat alaltap ke, ti kukup mafak yaapkan uyo kanum tabasip. Kemin, waasi iyo tal kipni angtiil yol sakbaalim dukum uyo kuyokomip o, kala, Yesus ayo kanum bakayila ko. ");
INSERT INTO tif_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kemin, soldiya iyo fuut tabin tunum alep ma iso, yim-tama tal tituun-kup tunum Yesus aso, dabaku ke imbii yak as diim daa anulum o, kalaliwa, iyo yim-biilip tal-ilomdipla, ");
INSERT INTO tif_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","mukun ma tola bombe kaptam-ali Mukun Dabaal Kun Tap o, kalbip kaptamu tam-ilomdip soldiya iyo Yesus ayo kulaata dabak as diim daa sil biki-lomdip dabuu dafole, kuno tunum fuut tabin tunum alep ma yakal yim-bital yim-bak as diim daa-lomdip, ma ata dap Yesus ami tiing tuplo kawu dip-tam diibip-kup, ale ma kaata awaanlo kawu dip-tam dii keya-lomdip yim-tiilipla ");
INSERT INTO tif_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus ayo bomda Aalap God ayo beten kamaan-bam bokola-lomda: Atok kapyo, mep kalawiili babon-bam maaklo kanup-nambip kemin, kaami kalan kabak-ata, angtiil yol kaa kuuyila-yaamin disa; imi uluum kulaa kukan-tiiyan o, kala kanum bakayila ko. Kulaa, soldiya iyo Yesus ami ilim kaali, kuluu kutii-bomdipla tuum katip saatu iyo kulaalup tam aba daak aba ke-bam, kanta ata ata ke, Yesus ami ilim ayo kuluula kala, kalalup utamum o, kala-lomdip Yesus ami ilim namti kabaanulip disa kelaya, ");
INSERT INTO tif_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","unang tunum iyo tola-bom Yesus atafii-bam iliwa, kulaa Juda imi kamok kamok ita atafiimin weng bakaan-bamdip bokolip: Ali ti unang tunum kusnum imi angtiil lak kaata dong dakaayin-balala yaawa-laabip. Kemin ale, ali fan ti God almi ulduusa tunum Kraist namti, baan akal almi angtiil lak uyo duu-lomda as diim yol daka bokoba uyo kulaa kela tildaak abamna atamum o, ke-bamdip atafiimin weng uyo bakaalip ko. ");
INSERT INTO tif_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldiya iyo kamok kamok imi weng uyo weng san-ilom kulaa isiik Yesus ami titul weng bakaan-bamdip, tal Yesus almi mepso kuluba tal-ilom ale, wain wok kok tabasa kaata, kuu delup inamnak i! kala, kola-lom, ");
INSERT INTO tif_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","asuk bokola-lomdip: Kabi fan ti, Juda imi king namti, kapkal kaltapni angtiil lak uyo duu-lomdap yaap-nan o, akan-kaa-bam bakaalipla, ");
INSERT INTO tif_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pailat ami okok kemin tunum iyo, as kom ma kuluu-lom kaami diim kabaku dolale bokola: Tunum kalawaali, Juda kasel imi kamokim king o, kala dolnale, as kom ayo kuyak tam Yesus ami tip diim diibip as dabom diim kabaku kuu diiliple, ");
INSERT INTO tif_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","kulaa fuut tabin tunum alep Yesus aso im-diibip iyo, ma ata Yesus ami atafiimin weng bakaan-bam bokola-lomda: Kabi tituun eng boko-lomdap: Nali tifan weng God almi ulduula Kamokim kesi no, kalap namti, ti kapkal kaltapni angtiil lak kaata, duu-som ale, alep numi lak ayo duu-lomdap God ami dik-daalawa, alta dong dokoyilaya, nikil alik ti kano yaap-num o! kemale, ");
INSERT INTO tif_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ma ata aptum ami titil-tibin weng bokola-lomda: Kawe, Yesus ayo aalip saaknon o kalba kemin, ti kapkal telip taanon o, kalbap kaa, kanimin o kalalawa kanum bakabap? Kabi God ami atul kaa suun-daalin disa bom-balap ema? ");
INSERT INTO tif_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kwin! alep nuli kukup mafak tabuulin-kup tabin kesup kemin, kaata yaap-kup angtiil yol uyo kuluu taanum e kalup ale, yak tunum kalawaalile, ali kukup mafak so ma nosa disa yo, kala aptum ma ami kanum bokolale, ");
INSERT INTO tif_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","kulaa fal-siki-lom Yesus ami bokola-lomda: Yesus, kapyo, kapni king ke-lom unang tunum imi tiin molokomap kaali, nami aket uyo fukun-ilomdap dong dokop-nan o, akale, ");
INSERT INTO tif_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus asiik bokola-lomda: Nami tifan tituun 