﻿USE sofia;
DROP TABLE IF EXISTS sofia.thv_vpl;
CREATE TABLE thv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES thv_vpl WRITE;
INSERT INTO thv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","S tizaret Yaḷḷah yexlek aǧenna d ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ǎmǎḍal wr ilé elhal, yefraɣ, tihay ellanet denneg ǧeréw wan tizaret. Unfas n Yaḷḷah yeɣlay, iggad denneg aman. ");
INSERT INTO thv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Yenna Yaḷḷah : « Temlét taffawt », temelt taffawt. ");
INSERT INTO thv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yeney Yaḷḷah as taffawt tekna ezzar yeẓmeẓley taffawt d tihay. ");
INSERT INTO thv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Iǧa isem i taffawt ahel d tihay iǧasnet isem éheḍ. Yokey éheḍ, tokey tufat, ahel wa yezzaren. ");
INSERT INTO thv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Yenna Yaḷḷah : « Yemlét asfel iyyen yǎẓimeẓleyen aman. » ");
INSERT INTO thv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Yeǧa awas yenna, yexlek asfel yǎẓimeẓleyen aman win afella d win érés. ");
INSERT INTO thv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Asfel wanǧam igas isem aǧenna. Yokey éheḍ, tokey tufat, ahel wan essin. ");
INSERT INTO thv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Yenna Yaḷḷah : « Dukkelnét aman win érés dɣ édeg iyyen baš éd yuman édeg wa yeqqoren. » Awén a iǧen. ");
INSERT INTO thv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Iǧa isem i édeg wa yeqqoren ǎmǎḍal d aman iǧa sn isem ǧeréw. Yosa awén yekna. ");
INSERT INTO thv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yenna Yaḷḷah : « Yelsét ǎmǎḍal iškan : ak iyyen s iyyen iyyen, ak iyyen s ennoƹ ennét, yekrehét téfest ennét dɣ térwa ennét. » Awén a iǧen. ");
INSERT INTO thv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Yesla ǎmǎḍal tekkewelt : iškan emdan, wi meḍruynén aked wi maqqornén, ak iyyen yérew téfest dɣ térwa ennét ak iyyen s ennoƹ ennét. Yosa Yaḷḷah awén yekna. ");
INSERT INTO thv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Yokey éheḍ, tokey tufat : ahel wan kǎraḍ. ");
INSERT INTO thv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Yenna Yaḷḷah : « Emlinét ifatten dɣ aǧenna baš éd saknén ahel d éheḍ ; éd saknén iméren n imadden ; éd saknén iheḍan d iwetyan. ");
INSERT INTO thv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ifatten win afella ǎǧinét taffawt fol ǎmǎḍal ! » Awén a iǧen. ");
INSERT INTO thv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yexlek Yaḷḷah essin ifatten wi ǎmunnén : wa mǎqqeren tǎfuk, teqqalet taffawt n ahel, d ta mǎḍriyet tallit, tǎmoset taffawt n éheḍ, yessétin itran. ");
INSERT INTO thv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Yeǧén dɣ aǧenna baš éd eǧan taffawt i ǎmǎḍal, ");
INSERT INTO thv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","éd enniheḍen dɣ ahel d éheḍ, ǎzimeẓleyen tihay d taffawt. Yosa Yaḷḷah awén yekna. ");
INSERT INTO thv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Yokey éheḍ tokey tufat, ahel wan ekkoẓ. ");
INSERT INTO thv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Yenna Yaḷḷah : « Emlinét ǎxxuten ǎǧǧotnén ǎwinekneken dɣ aman d igḍaḍ eggadnén dɣ aǧenna denneg ǎmǎḍal ! » ");
INSERT INTO thv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yexlek Yaḷḷah ǎxxuten wi mǎqqornén n aman d isolmiyen ǎǧǧotnén, ǎwinekneken, ak iyyen d ennoƹ ennét, d ǎxxuten wi taggednén emdan, ak iyyen d ennoƹ ennét. Yosa awén yekna. ");
INSERT INTO thv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Yegasen Yaḷḷah elbaraka yenna : « Aruwnét ǎxxuten win aman s ǎǧut dɣ aman, eṭkernét aman, d igḍaḍ fol ǎmǎḍal s ǎǧut, eṭkernét ǎmǎḍal ! » ");
INSERT INTO thv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Yokey éheḍ tokey tufat, ahel wan semmos. ");
INSERT INTO thv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Yenna Yaḷḷah : « Yekrehét ǎmǎḍal ǎxxuten ak iyyen d ennoƹ ennét : éheré, ǎxxuten wi enḍuknén, ǎxxuten wi ǎhimemmeretnén, iweɣsan ! » Awén a iǧen. ");
INSERT INTO thv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Yexlek Yaḷḷah ǎxxuten ak iyyen d ennoƹ ennét : éheré, ǎxxuten wi enḍuknén, ǎxxuten wi ǎhimemmeretnén d iweɣsan. Yosa awén yekna.. ");
INSERT INTO thv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Yenna Yaḷḷah : « Nexlekét ǎwadem, yola dnɣ, hund nekkenéḍ ! Éd yumas messis n isolmiyen dɣ aman d igḍaḍ d éheré d ǎxxuten wi enḍuknén d ǎxxuten wi ǎhimemmeretnén d iweɣsan ! » ");
INSERT INTO thv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yexlek Yaḷḷah ǎwadem ds yolan. Yola d Yaḷḷah ast yexlek, yexlekt éy d tunté. ");
INSERT INTO thv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Yeǧa sn Yaḷḷah elbaraka yenna : « Arwet, eqqelet i ǎǧǧotnén, eṭkeret ǎmǎḍal imda, neheḍet ds, umaset aked messawsen n isolmiyen dɣ aman d igḍaḍ d éheré d ǎxxuten wi enḍuknén d ǎxxuten wi ǎhimemmeretnén d iweɣsan. » ");
INSERT INTO thv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Yenna daɣ : « Hékwet, éd kewen ekfeɣ iškan tarewnén fol ǎrori n ǎmǎḍal imda. Téfsén d ǎmaris n iškan éd folwn eqqelen imekšan. ");
INSERT INTO thv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Iškan wi kewalnén ekfeɣ tn i ǎxxuten wi ezzeɣnén fol ǎmǎḍal d igḍaḍ d ǎxxuten wi ǎhimemmeretnén d wi eddernén emdan baš éd hasn umasin imekšan. » Awén a iǧen. ");
INSERT INTO thv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yeney Yaḷḷah awa yexlek imda, nɣwah, awén yekna emuken hullan. Yokey éheḍ tokey tufat, ahel wan seḍis. ");
INSERT INTO thv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Hund awéndɣ a eǧen eknen aǧenna d awadt ihen d ǎmǎḍal d awadt iwaren. ");
INSERT INTO thv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","As yesmenda Yaḷḷah ǎxalak n awéndɣ imda, yessunfa ahel wan essa. ");
INSERT INTO thv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Yekna dɣ ahel wéndɣ n essa ahel n elbaraka, yesnefrent, yezmeẓleyt ǧér iheḍan wi heḍnén emdan, baš éd yumas innét édét ahel héndɣ ad yessunfa. ");
INSERT INTO thv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nɣwéndɣ awa iǧen awad exleken aǧenna d ǎmǎḍal. As yexlek Amaɣlol Yaḷḷah ǎmǎḍal d aǧenna, ");
INSERT INTO thv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","wr enkeren iškan arweh fol ǎmǎḍal ula wi mǎqqornén ula wi enḍuknén édét Amaɣlol Yaḷḷah wr yesseswa ǎmǎḍal s aǧenna, wrt ellén ǎddunet wi hé exdemnén ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Beššan tellé téṭ iyyet d tegmaḍet ǎmǎḍal, tsaswé imda. ");
INSERT INTO thv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yermes Amaɣlol Yaḷḷah tǎlaq yexlek ss ales. Yesheḍ as unfas dɣ tinhar ezzar yekreh ales wah iman. ");
INSERT INTO thv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ezzar yessenker Amaɣlol Yaḷḷah ǎfǎraǧ iyyen dɣ ǎkal n Ƹaden berén awas d tgammeḍ tǎfuk. Yeǧa ds ales wa yexlek. ");
INSERT INTO thv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yessenker dɣ ǎmǎḍal ǎǧut ašek eẓlaynén ǧérésn, ǎhoseynén, tarewnén a yeẓéden. Ǧér iškan emdan iǧa ašek wa ihakken tǎmeddort d ašek wa ihakken muzyet n awa yehoseyen méɣ awa yexlen. ");
INSERT INTO thv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Eɣǎher iyyen yefal ǎkal n Ƹaden, aman ennét saswén ǎfǎraǧ. Γor déndɣ ad yemmizzey s ekkoẓ eḍaren ohalnen. ");
INSERT INTO thv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Wa yezzaren isem ennét Fišon, yeɣlay i ǎkal n Hawila. Ǎkal wah ihé orǎɣ wa yehoseyen. Ellant aked tǎɣeŋɣert d ikedéwen wi ǎhoseynén heggaɣnén. ");
INSERT INTO thv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Wan essin dɣ éḍaren n eɣǎher isem ennét Jihun, yeɣlay i ǎkal wan Kuš. ");
INSERT INTO thv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Wan karaḍ, Hiddaqil yekka aɣil was-d tgammeḍ tǎfuk i ǎkal wan Ašur. Wan ekkoẓ isem ennét Elferat. ");
INSERT INTO thv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yermes Amaɣlol Yaḷḷah ales, yeǧé dɣ ǎfǎraǧ wan Ƹaden, yesseɣlef ast baš edt yexdem, edt yageẓ. ");
INSERT INTO thv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yenna has : « Teddobéd éd tekšed dɣ iškan emdan win ǎfǎraǧ, ");
INSERT INTO thv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ar iyyen ɣas, ašek wa ihakken muzyet n awa yehoseyen d awa yexlen. Ahel héndɣ d-édt tekšed éd temmeted ! » ");
INSERT INTO thv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yexxemmem Amaɣlol Yaḷḷah : « Wr yǎhosey in ales éd yeqqim ɣas ennét. Éd has eǧeɣ tǎmidit tenihegget ds, tilal as. » ");
INSERT INTO thv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yexlek Amaɣlol Yaḷḷah s tǎlaq ǎǧut ǎxxu d egaḍéḍ, yéwey tn ɣor ales éd issen isem wa hasn éd yeǧ. Ak ǎxxu yeǧa isem wa has yosa ales. ");
INSERT INTO thv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Yeǧa ismawen i ǎxxuten emdan : éheré, igḍaḍ d iweɣsan. Beššan wr yosé i yeqqalen éré has yellilen. ");
INSERT INTO thv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yessoḍes Amaɣlol Yaḷḷah Adam s éḍes iyyen yeẓẓayen, yekkes as ǎɣerdés ezzar yergel isan fol édeg ennét. ");
INSERT INTO thv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","S ǎɣerdés wah yekna Amaɣlol Yaḷḷah tǎmǎṭ, yewey tt s Adam. ");
INSERT INTO thv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","As tt yeney Adam, yenna : « Nɣwah éɣes wan éɣesanin, isan win isanin ! Éd teǧ isem tǎwadamt édét Adam ad-d tefal. » ");
INSERT INTO thv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Fol awéndɣ as ales éd yefel mas d tis baš éd yerti d hennis, éd ǎqqelen iyyen n heret. ");
INSERT INTO thv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ales d tǎmǎṭ, issenen ésn ezzafen beššan wr ǎqquššemen ǧérésn. ");
INSERT INTO thv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ǎxxuten emdan wi yexlek Amaɣlol Yaḷḷah yoǧer tn aššel tittéwen. Yenna i tǎmǎṭ : « Tidet in Yaḷḷah yenna wr tettim ašek wl iyyen dɣ ǎfǎraǧ ? » ");
INSERT INTO thv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tenna has tǎmǎṭ : « Kela, neddobet éd nekš iškan emdan wi ehenén ǎfǎraǧ. ");
INSERT INTO thv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Beššan ašek wa ihen ammas n ǎfǎraǧ yenna hanɣ Yaḷḷah wr neddobet téteté ennét d éḍés ennét kud wr neré éd nemmet. » ");
INSERT INTO thv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yenna aššel i tǎmǎṭ : « Kela wr éd teqqelem éd tamettem ! ");
INSERT INTO thv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Beššan Yaḷḷah issan ss : as ds tekšem éd emérinet téṭṭawén nwn s tidet, éd teqqelem hund Yaḷḷah wa yessanen ǧér awa yehoseyen d awa yexlen. » ");
INSERT INTO thv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Teney tǎmǎṭ as ašek yǎhosey, éd tenned yeẓéd, éd tt yekf tayetté. Téwey heret dɣ térwa ennét tekšét. Tekfa iyyen i ales ennét wa-d teddéw yekša ds aked enta. ");
INSERT INTO thv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Dédih essenen, ǎmérenet téṭṭawén nsn elmeden as ezzafen. Éweyen ifrawen n tahart eknen dsn iselsa tn effarnén. ");
INSERT INTO thv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","S iẓelluwaẓ eslen ales d tǎmǎṭ i Amaɣlol Yaḷḷah yeɣlay dɣ ǎfǎraǧ. Elɣesen ǧér iškan. ");
INSERT INTO thv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yeɣra Yaḷḷah ales yessestent : « Ma tǧéd ? » ");
INSERT INTO thv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Yegmeḍ d ales, yenna : « Esléɣ i ǎfékas ennek dɣ ǎfǎraǧ, eksoḍeɣ édét ezzafeɣ, elɣeseɣ. » ");
INSERT INTO thv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yenna has Yaḷḷah :\"Mi hak yennen in tezzafed, toremed ašek was ak ennéɣ wrt tetted ? » ");
INSERT INTO thv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Yenna has ales : « Tǎmǎṭ ta dɣ teknéd tamiditin, enta ahi yekfen ašek ekšéɣ ds. » ");
INSERT INTO thv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yenna Amaɣlol Yaḷḷah i tǎmǎṭ : « Mafol teǧéd awén ? » Tenna : « Aššel waɣ, enta ahi yeɣderen, ekšéɣ dɣ ašek » ");
INSERT INTO thv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yenna Amaɣlol Yaḷḷah i aššel : « Édét teǧéd awén, tewar key tilɣant, dɣ ǎxxuten emdan key éd tǎhimemmeréd fol tesa ennek tatted tǎgoḍrart a tekked teddared. ");
INSERT INTO thv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Éd eǧeɣ ǎššer ǧérék d tǎmǎṭ, ǧér térwa ennek d térwa ennét. Térwa ennét éd key teɣdem dɣ éɣef. Key éd tt teɣdemed dɣ azreh. ");
INSERT INTO thv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Yenna Yaḷḷah i tǎmǎṭ : « Ǎsemrew ennem éd terreɣ yeṣṣohet, éd tɣasseled as tarewed. Tera ennem i ales ennem, tǎmixataredt, enta éd dm yenniheḍ. » ");
INSERT INTO thv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Yenna i ales : « Tesgeded awa hak tenna tǎmǎṭ, toremed ašek was ak ennéɣ wr tetted. Dimaɣ éd hak eǧeɣ tilɣant fol ǎmǎḍal. Éd folk yeqqel yeṣṣohet ukus n imekšan dɣ ǎmǎḍal a tekkéd teddared. ");
INSERT INTO thv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Éd hak ikan ǎmǎḍal iškan wi ehen isennanen d awekraẓ. Éd tatted awa inakkeren fol ǎmǎḍal, ");
INSERT INTO thv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ilzam ak erǎbax n imekšan ennek s tidé ennek ad teqqeled ǎmǎḍal wa dɣ teknéd édét teknéd dɣ tǎgoḍrart éd teqqeled tǎgoḍrart. » ");
INSERT INTO thv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Iǧa Adam isem i tǎmǎṭ ennét Ḥawa (elmeƹna ennét tǎmeddort), édét enta as mas n wi eddernén emdan. ");
INSERT INTO thv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yekna Amaɣlol Yaḷḷah argag s élem i ales d tǎmǎṭ ennét baš éd tn isels. ");
INSERT INTO thv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ezzar yenna Amaɣlol Yaḷḷah dɣ iman ennét : « Dimaɣ ales yeqqel hund iyyen dnɣ dɣ ǎẓemmeẓli n awa yehoseyen d awa yexlen. Dimaɣ éd has nekkes éd yaweḍ ašek wan tǎmeddort, kud yekšé éd yedder ar abedǎh. ");
INSERT INTO thv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Yesteɣ Amaɣlol Yaḷḷah Adam dɣ ǎfǎraǧ n Ƹaden, yessoké éd yexdem dɣ ǎmǎḍal wa dɣ ikna. ");
INSERT INTO thv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ast yesteɣ, yeǧa aɣil was-d tǧammeḍ tǎfuk i ǎfǎraǧ wan Ƹaden ǎngelosen n imastanen d tǎkoba tolat d ahes, teɣlay enta d témsé ennét. Ogaẓen ǎbǎreqqa wa yekken ašek wan tǎmeddort. ");
INSERT INTO thv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Yezzey Adam tǎmǎṭ ennét Ḥawa, tessimrew. Tekreh Kayin ezzar tenna : « S telilt n Yaḷḷah eknéɣ ǎwadem. » ");
INSERT INTO thv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tekreh arraw iyyen heḍen, isem ennét Abel. Abel yǎmos ǎmǎḍan, Kayin ixaddem ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","As okeyen iwetyan, Kayin yeǧa takuté i Yaḷḷah s awa yexdem dɣ iferǧan ennét. ");
INSERT INTO thv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel yéwey-in ikerwaten d éɣeyden ennét wi ewenén ezzaren entenéḍ d tadent nsn, ikkat awa yufen dsn i Yaḷḷah. Yaḷḷah iǧa ǎsǎwaḍ yehoseyen i Abel d takuté ennét, ");
INSERT INTO thv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","beššan Kayin d takuté tannét, widih wr hasn iǧé ǎsǎwaḍ yehoseyen. Yeggoret Kayin dɣ iman ennét, yergel udem ennét. ");
INSERT INTO thv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yenna has Yaḷḷah : « Ma yenfa in teggoréd dɣ iman ennek, yergal udem ennek hund aydɣ ? ");
INSERT INTO thv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kud temmugnéd, weggéɣ éd teṭkeled éɣef ? Beššan kud wr temmugnéd ǎbekkaḍ yohaẓ key, hund ǎxxu yeffaren, yegmay éd key yernu, beššan key, ilzam ak éd ternud. » ");
INSERT INTO thv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Beššan Kayin yenna i ǎmeḍray ennét Abel : « Neǧmeḍét. » As eǧmeḍen dɣ igeg, yertek Kayin fol Abel, yeŋɣé. ");
INSERT INTO thv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yenna Yaḷḷah : « Ma iǧa ǎmeḍray ennek Abel ? » Yenna Kayin : « Ma essaneɣ. Weggéɣ nk adt yeḍanen. » ");
INSERT INTO thv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yenna Yaḷḷah : « Mafol teǧéd awén ? Salleɣ i ahni n Abel yesiɣeret ahi yefal-d ǎmǎḍal ! ");
INSERT INTO thv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Dimaɣ tewer key tilɣant, estaɣeɣ key dɣ ǎmǎḍal wa yoren émi ennét baš édt iggeh ahni n ǎmeḍray ennek wa teŋɣéd. ");
INSERT INTO thv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Fol awéndɣ, id texdemed ǎmǎḍal wr key éd yekf ula enḍerren. Éd tumased ǎɣǎrib yehureǧen fol ǎmǎḍal. » ");
INSERT INTO thv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Yenna Kayin i Yaḷḷah : « Ǎḥezanin yeṣṣohet foli. ");
INSERT INTO thv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ahel waɣ testeɣed ahi dɣ ǎmǎḍal wa yehoseyen, éd eqqeleɣ taffereɣ imanin fol udem ennek. Éd eqqeleɣ ǎɣǎrib yehureǧen dɣ ténéré. I hi yosen éd hi yeŋɣ. » ");
INSERT INTO thv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Dédih yenna has Yaḷḷah : « Kela, édét kud yeŋɣa iyyen Kayin ilzam essahet timettanén baš éd yexelles ǎmerwas. » Yezzehwel Yaḷḷah Kayin baš wrt éd yeŋɣ wl iyyen d yemheyyet. ");
INSERT INTO thv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Yefel Kayin dat Yaḷḷah, yekka éd yezzeɣ ǎkal wan Nod, illen aɣil wan aǧmoḍ n tǎfuk i Ƹaden. ");
INSERT INTO thv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Yezzey Kayin hennis, tǎssimrew, tekreh Hénok. Yebna Kayin aɣrem s iǧa isem Hénok hund rurés. ");
INSERT INTO thv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hénok yérew Ƹirad, Ƹirad yérew Mehwel, Mehwel yérew Metušayel. Metušayel yérew Lamek. ");
INSERT INTO thv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Yéwey Lamek senatet téḍéḍén, ta tezzaret isem ennét Ada, ta heḍet isem ennét Ṣilla. ");
INSERT INTO thv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada térew Yabal. Yabal enta a yeziheyewen wi ezzeɣnen ihenan d eḍanen éheré. ");
INSERT INTO thv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yekreh Yabal ǎmeḍray, isem ennét Yubal, enta a yeziheyewen wi eggatnén imzaḍ d tǎẓemmart. ");
INSERT INTO thv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ṣilla aked enta tekreh arraw, isem ennét Tubal-Kayin, yeqqal éneḍ, ikan hereten wi nekkeḍnén s eɣer d taẓoli. Tǎmeḍrayt n Tubal-Kayin isem ennét Naƹma. ");
INSERT INTO thv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Yenna Lamek i téḍéḍén ennét : « Ada d Ṣilla, segedmet ahi, Téḍéḍén n Lamek segedmet i awalin : eŋɣeɣ ales kud yeɣdem ahi, eŋɣeɣ arraw kud yewet ahi. ");
INSERT INTO thv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kud emmuten essa médden dɣ érét n Kayin éd emmeten essahet temerwén d essa dɣ érét n Lamek. » ");
INSERT INTO thv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ekrehen Adam d Hawa arraw iyyen heḍen. Tegas Hawa isem Šet, tenna : « Yaḷḷah yekfahi ara iyyen heḍen dɣ édeg n Abel wa yeŋɣa Kayin. » ");
INSERT INTO thv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Yekreh Šet arraw s iǧa isem Enoš. Déndɣ ad aqqelen ǎddunet ɣarren isem n Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Awah tǎnǎqqést tan Adam d iheyawen ennét : ahel wad yexlek Yaḷḷah Adam yekné yola ds. ");
INSERT INTO thv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Yexlek tn ǎmosen éy d tunté. Yeǧa sn elbaraka ezzar yeǧa sn isem ales d tǎmǎṭ ahel wa dɣ exleken. ");
INSERT INTO thv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","As yekreh Adam téméḍé n ǎwetay d keraḍet temerwén yekreh arraw hund enta, yola ds. Igas isem Šet. ");
INSERT INTO thv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ḍeffer tiwit n Šet yedder Adam ettamet temaḍ n ǎwetay arweh. Yekreh arrawen wiyeḍ heḍnén d tarrawén. ");
INSERT INTO thv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Yedder teẓẓahet temaḍ n ǎwetay d keraḍet temerwén ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","As yekreh Šet téméḍé n ǎwetay d semmos yekreh arraw isem ennét Enoš. ");
INSERT INTO thv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ḍeffer tiwit n Enoš, yedder Šet ettamet temaḍ n ǎwetay d essa. Yekreh arrawen d tarrawén wiyeḍ heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Yedder teẓẓahet temaḍ n ǎwetay d meraw d essin ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","As yekreh Enoš teẓẓahet temerwén n ǎwetay yekreh arraw isem ennét Qenan. ");
INSERT INTO thv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ḍeffer tiwit n Qenan yedder Enoš ettamet temaḍ n ǎwetay d meraw d semmos. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Yedder teẓẓahet temaḍ n ǎwetay d semmos ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","As yekreh Qenan essahet temerwén n ǎwetay yekreh arraw isem ennét Mahlalyel. ");
INSERT INTO thv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ḍeffer tiwit n Mahlalyel yedder Qenan ettamet temaḍ n ǎwetay d ekkoẓet temerwén. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Yedder teẓẓahet temaḍ n ǎwetay d meraw ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","As yekreh Mahlalyel seḍiset temerwén n ǎwetay d semmos yekreh arraw isem ennét Yared. ");
INSERT INTO thv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ḍeffer tiwit n Yared, yedder Mahlalyel ettamet temaḍ n ǎwetay d keraḍet temerwén. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Yedder ettamet temaḍ n ǎwetay d teẓẓahet temerwén d semmos ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","As yekreh Yered téméḍé n ǎwetay d seḍiset temerwén d essin yekreh arraw isem ennét Hénok. ");
INSERT INTO thv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ḍeffer tiwit n Hénok yedder Yered ettamet temaḍ n ǎwetay. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yedder teẓẓahet temaḍ n ǎwetay d seḍiset temerwén d essin ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","As yekreh Hénok seḍiset temerwén n ǎwetay d semmos yekreh arraw isem ennét Matušaleḥ. ");
INSERT INTO thv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ḍeffer tiwit n Matušaleḥ, yedder Hénok keraḍet temaḍ n ǎwetay, yelkam i ǎbǎreqqa n Yaḷḷah. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Yedder keraḍet temaḍ n ǎwetay d seḍiset temerwén d semmos. ");
INSERT INTO thv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Dɣ tǎmeddort ennét yelkam i ǎbǎreqqa n Yaḷḷah, ad yexrek édét Yaḷḷah yéweyt ɣors. ");
INSERT INTO thv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","As yekreh Matušaleḥ téméḍé n ǎwetay d ettamet temerwén d essa yekreh arraw isem ennét Lamek. ");
INSERT INTO thv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ḍeffer tiwit n Lamek yedder Matušaleḥ essahet temaḍ n ǎwetay d ettamet temerwén d essin. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Yedder teẓẓahet temaḍ n ǎwetay d seḍiset temerwén d teẓẓa ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","As yekreh Lamek téméḍé n ǎwetay d ettamet temerwén d essin yekreh arraw, ");
INSERT INTO thv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","yeǧas isem Noḥ. Yenna : « Édét waɣ éd haneɣ isesmeḍ fol oḍuh d elxedmet ta teṣṣohét n ǎmǎḍal wa fol iǧa Amaɣlol tilɣant. » ");
INSERT INTO thv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ḍeffer tiwit n Noḥ, yedder Lamek semmoset temaḍ n ǎwetay d teẓẓahet temerwén d semmos. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Yedder essahet temaḍ n ǎwetay d essahet temerwén d essa ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ila Noḥ semmoset temaḍ n ǎwetay as yekreh keraḍ arrawen ismawen nsn Sam, Ḥam d Jafet. ");
INSERT INTO thv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Élwen aytadem fol ǎmǎḍal, ekrehen tarrawén, ");
INSERT INTO thv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","dg Yaḷḷah eneyen eššét aytadem ǎhoseynet, éweyen ti hasn egraẓnén. ");
INSERT INTO thv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yenna Amaɣlol: « Wr éd eyyeɣ unfasin dɣ ǎwadem baš éd yeddar ar abedǎh, édét yekna dɣ isan. Tǎmeddort ennét wr éd takey téméḍé n ǎwetay d senatet temerwén. » ");
INSERT INTO thv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Émér héndɣ aked ḍeffer adih, ellant ijabbaren fol ǎmǎḍal. Entenéḍ ewen ǧér enmerti n dg Yaḷḷah d eššét aytadem. Wiɣ a yǎmosen ǎddunet wi elenén tisellet ɣor kél éru. ");
INSERT INTO thv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yeney Amaɣlol as aytadem eqqelen exlan fol ǎmǎḍal, ulawen nsn abedǎh wr ekkén ar berén tǎxellawt. ");
INSERT INTO thv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yessexzent dɣ ul ennét awén ezzar yemmuǧreẓ fol emuken nsn fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yenna : « Éd amseɣ fol ǎmǎḍal aytadem wi exlekeɣ, entenéḍ d ǎxxuten emdan, wi enḍuknen d wi mǎqqornén d igḍaḍ. Emmuǧreẓeɣ in eknéɣ-tn. » ");
INSERT INTO thv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Beššan Noḥ yeǧraẓ i Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Awah tǎnǎqqést n Noḥ d iheyawen ennét : Noḥ ales yeẓẓalen, i yolaɣen ǧér ǎddunet win ezzeman ennét. Yelkam i ǎbǎreqqa n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ikrah keraḍ arrawen Sam, Ḥam d Jafet. ");
INSERT INTO thv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Beššan ɣor Yaḷḷah edduniya texla, iǧiten n ǎddunet eššaḍen. ");
INSERT INTO thv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","As ikyed Yaḷḷah edduniya, yosét texla, awa iddaren imda yeǧmaḍ ǎbǎreqqa. ");
INSERT INTO thv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Yenna i Noḥ : « Ennéɣ-tn ! Ǎheddem ahé eǧeɣ i ǎddunet d a iddaren. Dɣ érét n erk iǧiten n ǎddunet, edduniya texla, esilekeneɣ ak as éd tt ehheddemeɣ. ");
INSERT INTO thv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Eken essendoq yolan d elbabor yeknan dɣ ǎseɣér yeṣṣohén ; éd ds tekned téɣehmén ǎǧǧotnén, éd fols teblenbeliḍ keḍran ammas aked dɣ ténéré. ");
INSERT INTO thv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nɣwah awa has éd teǧed : Ilzem yela keraḍet temaḍ n iɣallen fol tezzegret ennét d semmoset temerwén fol eluseɣ ennét d keraḍet temerwén n iɣallen fol tébeddé. ");
INSERT INTO thv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Eken as temmérit dɣ afella ennét, ékét ennét aɣil. Eken as émi fol ǎgenena d tekned as keraḍ leƹléten. ");
INSERT INTO thv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Awah Nk, éd-d zihleɣ anǧi iyyen mǎqqeren, aman ennét éd ahlin fol adt illen dag aǧenna d fol ǎmǎḍal imda, éd eŋɣin a ilan unfas n iman. Adt illen fol ǎmǎḍal éd yemmet. ");
INSERT INTO thv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Éd egeɣ téséq ǧéri dk. Éd teggehed dɣ essendoq key d hennik d meddank d tiḍulén ennek. ");
INSERT INTO thv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","A yedderen, a ilan unfas édt tzughed ; ǎxxuten s essin essin dɣ ak ennoƹ, éy d tunté n ak ǎxxu baš éd edderen hund key. ");
INSERT INTO thv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Éy d tunté n ak ǎxxu d egǎḍéḍ, a enḍukken d a mǎqqeren ak iyyen d ennoƹ ennét, éd key d asin baš éd ennejjin. ");
INSERT INTO thv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Key, eǧmi a tekšéd key dsn, eken taheqqa. » ");
INSERT INTO thv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Awén a iǧa Noḥ, yeǧa awa has yenna Yaḷḷah imda. ");
INSERT INTO thv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yenna Amaɣlol i Noḥ : « Eggeh essendoq key d ǎddunet ennek édét key ɣas a hanneyeɣ yeẓẓalen ǧér ǎddunet emdan. ");
INSERT INTO thv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Awi essa éyyan d essahet tuntawén dɣ ak ǎxxu xelalen ; awi tunté d éy dɣ ǎxxuten wi xeramnén. ");
INSERT INTO thv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Dɣ igḍaḍ awi essa éyyan d essahet tuntawén dɣ ak ennoƹ baš éd ennejjin ǎxxuten wiɣ fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Eqqimen essa iheḍan, dédih éd-d sewteɣ aǧenna fol ekkoẓet temerwén n ahel d ekkoẓet temerwén n éheḍ, éd amseɣ awad exlekeɣ imda fol ǎmǎḍal. » ");
INSERT INTO thv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yeǧa Noḥ awa has yenna Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","As-d yosa anǧi wa mǎqqeren fol ǎmǎḍal, ila Noḥ seḍiset temaḍ n ǎwetay. ");
INSERT INTO thv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Yeggeh essendoq enta d hennis d meddans d tiḍulén ennét baš éd ennejjin fol anǧi. ");
INSERT INTO thv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ǎxxuten wi xelalnén d wi xeramnen d igḍaḍ d ǎxxuten wi ǎhimemmeretnén ");
INSERT INTO thv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","osen in emdan dɣ essendoq ɣor Noḥ, s essin essin, éy d tunté hund awa yenna Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","As okeyen essa iheḍan anǧi wa mǎqqeren yenkel ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ǎwetay wa dɣ yekreh Noḥ seḍiset temaḍ n ǎwetay, ahel wan meraw d essa dɣ tallit tan senatet, osen-d aman wi-d efalnén édér n ǎmǎḍal, yaméra aǧenna yoyya-d aman. ");
INSERT INTO thv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yewet aǧenna fol ǎmǎḍal, aǧenna yewat ad eǧen ekkoẓet temerwén n ahel d éheḍ. ");
INSERT INTO thv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ahel héndɣ d-yeggeh Noḥ essendoq enta d hennis d meddans Sam d Ḥam d Jafet d tiḍulén ennét keraḍet, ");
INSERT INTO thv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","eddéwen dsn ǎxxuten emdan, ak iyyen d ennoƹ ennét : éheré d iweɣsan d ǎxxuten wi ǎhimemmeretnén d igḍaḍ d a ilan tifakfakén. ");
INSERT INTO thv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Éyyan d tuntawén n a iha unfas, osen in ɣor Noḥ dɣ essendoq. ");
INSERT INTO thv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Éy d tunté n a iha unfas, yeggeh hund awa has yenna Yaḷḷah i Noḥ. Ezzar yergel Amaɣlol taflut. ");
INSERT INTO thv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Anǧi wa mǎqqeren iǧa ekkoẓet temerwén n ahel d éheḍ fol ǎmǎḍal. Éwenen aman denneg awén, dédih yéwen essendoq denneg ǎmǎḍal yeqqim yediweylel fol aman. ");
INSERT INTO thv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Esséten aman animér ezzar yegla essendoq fol aman. ");
INSERT INTO thv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ak ahel tawenen aman a yeggén ad okeyen tidreɣén ti mǎqqornén, ti ellenen dag aǧenna. ");
INSERT INTO thv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Éwenen aman denneg awén s meraw iɣallen d semmos, okeyen tidreɣén. ");
INSERT INTO thv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","A yedderen fol ǎmǎḍal yemmut : igḍaḍ, éheré, iweɣsan, awa yehimemmerén d awa yedderen fol ǎmǎḍal imda, aked ǎddunet. ");
INSERT INTO thv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","A ilan unfas dɣ tinhar, a yedderen fol ǎmǎḍal yemmut. ");
INSERT INTO thv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yomes Yaḷḷah a yedderen fol ǎmǎḍal : ǎddunet, éheré, iweɣsan, igḍaḍ, ǎxxuten wi ǎhimemmeretnén. Emdan omesen fol ǎrori n ǎmǎḍal. Wr yeddér ar Noḥ d wi ehenen essendoq. ");
INSERT INTO thv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Aqqimen aman fol ǎmǎḍal ad okeyen téméḍé n ahel d semmoset temerwén. ");
INSERT INTO thv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ezzar yesmekta Yaḷḷah Noḥ d ǎxxuten emdan wi ds eddéwnén dɣ essendoq. Yesheḍ aḍu fol ǎmǎḍal ezzar eglen aman sollan sollan. ");
INSERT INTO thv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Aman wid efalnén édér n ǎmǎḍal d win aǧenna ergelen. Aǧenna yessosem. ");
INSERT INTO thv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Eglen aman sollan sollan fol ǎmǎḍal. Eresen aman ḍeffer téméḍé n ahel d semmoset temerwén. ");
INSERT INTO thv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ahel wan meraw d essa dɣ tallit tan essahet, yeres essendoq fol tidreɣén tin Araraṭ. ");
INSERT INTO thv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Eqqimen aman errasen arweh ar tallit tan merawet. Ahel wa yezzaren dɣ tallit taɣ, ǎmunnet tidreɣén. ");
INSERT INTO thv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","As okeyen ekkoẓet temerwén n ahel yora Noḥ eṭṭaga ta yekna fol essendoq. ");
INSERT INTO thv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Yessegla ǎɣaleǧ. Igal itaqqel-d a ekken aman toɣaren fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ezzar yessegla Noḥ tedǎbért baš éd yessen aman eresen fol ǎmǎḍal méɣ animér. ");
INSERT INTO thv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Beššan wr tosé id tejjen édét aman ellant arweh, teqqel-d essendoq ɣor Noḥ. Yeẓẓel ǎfus yermes tt, yezzogeh tt ɣors dɣ essendoq. ");
INSERT INTO thv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Okeyen essa iheḍan ezzar yesseglet arweh. ");
INSERT INTO thv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Teqqel-d tedǎbért s iẓelluwaẓ teṭṭaf dɣ émi ennét afraw n ezzeytun. Yelmed Noḥ as aman eresen. ");
INSERT INTO thv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Yessokey essa iheḍan arweh, ezzar yessegla tedǎbért beššan wr-d teqqél. ");
INSERT INTO thv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ahel wa yezzaren dɣ seḍiset temaḍ d iyyen dɣ iwetyan n Noḥ ad yeswa ǎmǎḍal aman. Yora Noḥ asfel n essendoq, yekyed dɣ ténéré, ma ihanney deh ? Ihanney ǎmǎḍal yeqqoren, ǎbas-t ellen aman. ");
INSERT INTO thv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ahel wan senatet temerwén d essa dɣ tallit tan senatet ǎmǎḍal yeqqor. ");
INSERT INTO thv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yesséwel Yaḷḷah i Noḥ, yenna has : ");
INSERT INTO thv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","« Egmeḍ essendoq, key d hennik d meddank d tiḍulén ennek. ");
INSERT INTO thv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Segmeḍ ǎxxuten wi dk eddéwnén emdan : éheré, iweɣsan d ǎxxuten wi ǎhimemmeretnén d igḍaḍ. Éd ewnekneken, éd ilwin fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Yegmeḍ Noḥ essendoq enta d hennis d meddans d tiḍulén ennét. ");
INSERT INTO thv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Egmeḍen ǎxxuten emdan ak iyyen d ennoƹ ennét : éheré, iweɣsan d ǎxxuten wi ǎhimemmeretnén d igḍaḍ, wiyeḍ ḍeffer wiyeḍ. ");
INSERT INTO thv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Yekna Noḥ ǎsǎɣres i Amaɣlol. Yeŋɣa iyyen dɣ ak ǎxxu xelalen d ak egǎḍéḍ xelalen yeket tn i Yaḷḷah eqqaden fol témsé. ");
INSERT INTO thv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yesreɣ Amaɣlol aḍu wah yeẓéden, yegreẓ as, yeɣbelt ezzar yenna dɣ iman ennét : « Mn dimaɣ ǎbas taggeɣ tilɣant fol ǎmǎḍal dɣ érét n ǎddunet. Tidet as wa fol meḍriyen exlan ulawen nsn. Beššan ǎbas naqqeɣ a yedderen hund awa egeɣ dimaɣ. ");
INSERT INTO thv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","A yekka illé ǎmǎḍal, a yeŋɣelen d a yeŋŋen, tuksé d esǎméḍ, ǎwélen d tagrest, ahel d éheḍ, wr éd emmendun. » ");
INSERT INTO thv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Iǧa Yaḷḷah elbaraka i Noḥ d meddans, yenna hasn : « Arwet, ǎqqelet i ǎǧǧotnén, eṭkeret ǎmǎḍal imda. ");
INSERT INTO thv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ǎxxuten emdan fol ǎmǎḍal éd kewen uksaḍin hullan, igḍaḍ emdan, wi ǎhimemmeretnén emdan, isolmiyen win ǧeréw emdan : emdan ellan ǧér ifassen nwn. ");
INSERT INTO thv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","A yemmussen d a yedderen éd hawen yumas ǎmekši. Hund as kewen ekféɣ tekkewelt n iškan, dimaɣ hakkeɣ kewen awaɣ imda. ");
INSERT INTO thv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Beššan wr tettim isan iha ahni, édét ahni a ehan iman. ");
INSERT INTO thv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Édét iman ahni a ehan, fol awéndɣ as i iǧen iman, ǎxxu méɣ ǎwadem, éd ds egmeyeɣ ǎrreẓam n iman wi iǧa. Éré yeŋɣen eŋŋas, éd ds egmeyeɣ ǎrreẓam n ahni ennét. ");
INSERT INTO thv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wa yesseŋɣelen ahni n ǎwadem, ahni ennét éd yeŋɣel s ǎwadem, édét Yaḷḷah yekna ǎwadem yola ds, hund enta. ");
INSERT INTO thv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kewenéḍ, arwet, ǎqqelet i ǎǧǧotnén, eṭkeret ǎmǎḍal imda. » ");
INSERT INTO thv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yenna Yaḷḷah i Noḥ d meddans : ");
INSERT INTO thv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","« Nk, éd eǧeɣ téséq ǧéri dewen d iheyawen nwn, ");
INSERT INTO thv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","d a-wa yedderen imda ɣorwen : eheriwen, iweɣsan d ǎxxuten wi ǎhimemmeretnén d igḍaḍ, wid igmeḍnén essendoq emdan. ");
INSERT INTO thv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nɣtah téséqin ǧéri dewen : a yedderen ǎbas éd yemmet s anǧi wa mǎqqeren, ǎbas-d éd siwyeɣ anǧi wa mǎqqeren baš éd yeɣhed ǎmǎḍal » ");
INSERT INTO thv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yenna Yaḷḷah arweh : « Nɣwah éhwel n téséqin ǧéri dewen d awa yedderen imda d wi hé eddernén dɣ ezzemanen wi-d eǧlenén ar abedǎh : ");
INSERT INTO thv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","éd eǧeɣ tǎẓẓel-aḍer dɣ éẓyaren, éd tumas éhwel n téséqin ǧéri d ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","I-d élwen eẓyaren dɣ aǧenna ezzar temun-d tǎẓẓel-aḍer, ");
INSERT INTO thv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","éd ektuɣ téséqin ǧéri dewen d awa yedderen imda, in ǎbast éd yemel anǧi wa mǎqqeren hé yeŋɣin awa iha unfas imda. ");
INSERT INTO thv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","I-d eneyeɣ tǎẓẓel-aḍer éd ektuɣ téséq tan abedǎh ; ta tellet ǧér Yaḷḷah d awa yedderen fol ǎmǎḍal. » ");
INSERT INTO thv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Yenna Yaḷḷah i Noḥ arweh : « Tǎẓẓel-aḍer tǎmos éhwel n téséq ǧéri d awa yedderen fol ǎmǎḍal imda. » ");
INSERT INTO thv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Meddans n Noḥ wi-d eǧmeḍnén essendoq entenéḍ Sam, Ḥam d Jafet. Ḥam yeqqal tis n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Awa yezzeɣen ǎmǎḍal yefal-d dg Noḥ win keraḍ. ");
INSERT INTO thv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noḥ, yǎmosen elfellaḥ, yessenker tǎzzebibt. ");
INSERT INTO thv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Yeswa elboẓa, yexbeṭ, yezzef dɣ éhen ennét. ");
INSERT INTO thv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ḥam, tis n Kenƹan yeney tis yezzaf, yeǧmeḍ yennen i ayet-mas. ");
INSERT INTO thv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sam d Jafet eṭkelen ǎbǎtéɣ, eswerent éẓéren nsn, eggehen s ḍeffer ḍeffer dɣ éhen ezzar esselsen tisn. Ekyaden aɣil wa dɣ wr illé baš wr éd eynin tisn yezzaf. ");
INSERT INTO thv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","As ǎbas yexbeṭ Noḥ yelmed awa iǧa rurés wa meḍriyen, ");
INSERT INTO thv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","yenna : « Tilɣant tewer Kenƹan ! Yumaset akli n éklan n ayet-mas ! » ");
INSERT INTO thv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yenna arweh : « Nemmuyet i Amaɣlol, Messineɣ n Sam ! Yumasét Kenƹan akli n Sam ! ");
INSERT INTO thv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yekfét Yaḷḷah Jafet d iheyawen ennét ǎkal mǎqqeren, yezzeɣét Jafet dɣ ihenan n Sam, yumasét Kenƹan akli nsn ! » ");
INSERT INTO thv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ḍeffer anǧi wa mǎqqeren, yedder Noḥ arweh keraḍet temaḍ n ǎwetay d semmoset temerwén. ");
INSERT INTO thv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Yedder Noḥ teẓẓahet temaḍ n ǎwetay d semmoset temerwén ezzar yemmut. ");
INSERT INTO thv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ḍeffer anǧi wa mǎqqeren, dg Noḥ Sam, Ḥam d Jafet ekrehen arrawen. Nɣwih iheyawen nsn : ");
INSERT INTO thv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Dg Jafet : Gomer, Magog, Maday, Yawan, Tubal, Mašek d Tiras. ");
INSERT INTO thv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Dg Gomer : Aškenaz, Rifat d Togarma. ");
INSERT INTO thv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Dg Yawan : Eliša, Tarsis, Kittim d Dodanim. ");
INSERT INTO thv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Dg Jafet a-d efalen ǎddunet wi ezzeɣnén ɣor ǧeréw, ak wiyyeḍ d ellametén nsn d ikallen nsn d tawsitén nsn d awalen nsn. ");
INSERT INTO thv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Dg Ḥam : Kuš, Miṣrayim, Fuṭ d Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Dg Kuš : Seba, Hawila, Sabta, Raƹma d Sabteka. Dg Raƹma : Saba d Dédan. ");
INSERT INTO thv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuš yǎmos aked tis n Nemrod, yeqqalen amɣar mǎqqeren, wa yezzaren ǧér ǎddunet. ");
INSERT INTO thv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nemrod yeqqal amagdal mǎqqeren ɣor Amaɣlol fol awéndɣ as itahawal : « Amagdal mǎqqeren ɣor Amaɣlol hund Nemrod. » ");
INSERT INTO thv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Dɣ ikallen wi ezzarnén fol yemnakel, ellant éɣermen win Babel, Erek, Akad d Kalne dɣ ǎkal n Šinƹar. ");
INSERT INTO thv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Yefel Nemrod ǎkal wah yekka ǎkal n Aššur. Yebna ds éɣerman win Niniwa d Rehobot d Kelaḥ, ");
INSERT INTO thv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","d Ressen, illan ǧér Niniwa d Kelaḥ, aɣrem mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Miṣrayim yǎmos tis n Luditen, Ƹanamiten, Lehabiten, Naftuhiten, ");
INSERT INTO thv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fatros, Kasluḥ, wad efelen Filistiniten d Kaftorten. ");
INSERT INTO thv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenƹan yǎmos tis n Sidon wa mǎqqeren dɣ meddans d Ḥeth, ");
INSERT INTO thv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","yǎmosen aked tis n Yabusiten, Amoriten, Girgašiten, ");
INSERT INTO thv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwiten, Arqiten, Siniten, ");
INSERT INTO thv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwaditen, Sémariten d Hematiten. Ḍeffer awén tawsitén ti-d efelnén Kenƹan emmezeynet. ");
INSERT INTO thv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ǎkal nsn yemel ǧér Sidon berén Gerar ar Γaza berén Sodoma, Ƹamora, Adma d Ṣeboyim ar Leša. ");
INSERT INTO thv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Awén dg Ḥam, ak iyyen d tawsit ennét d awal ennét dɣ ǎkal ennét d ellamet ennét. ");
INSERT INTO thv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sam, ǎmeqqar n Jafet yekreh arrawen. Yǎmos tis n Eber d wi yérew. ");
INSERT INTO thv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Dg Sam : Elam, Aššur, Arfakšad, Lud d Aram. ");
INSERT INTO thv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Dg Aram : Uṣ, Ḥul, Geter d Maš. ");
INSERT INTO thv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfakšad yǎmos tis n Šelaḥ, Šelaḥ yérew Eber. ");
INSERT INTO thv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber yekreh essin arrawen : iyyen isem ennét Feleg, -Azmezzi-, édét émér wa dɣ yeddar ǎddunet win edduniya emmezzeyen, wa heḍen isem ennét Yoqtan. ");
INSERT INTO thv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqtan yǎmos tis n Almodad, Šelef, Haḍarmawet, Yeraḥ, ");
INSERT INTO thv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diqla, ");
INSERT INTO thv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimayel, Saba, ");
INSERT INTO thv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, Yobab, wiɣ emdan ǎmosen meddans n Yoqtan. ");
INSERT INTO thv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ezzaɣen ǧér Meša d ǎkal n tidreɣén n Sefar berén awas d tgammeḍ tǎfuk. ");
INSERT INTO thv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Awén meddans n Sam ak iyyen d tawsit ennét d awal ennét dɣ ǎkal ennét d ellamet ennét. ");
INSERT INTO thv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Awén tawsitén ti-d efelnén Dg Noḥ, ak iyyet d iheyawen ennét d ellametén ennét. Entenéḍ a-d efalen ǎddunet emdan wi ezzeɣnén ǎmǎḍal ḍeffer anǧi wa mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ǎddunet emdan sawalen awal iyyen d tifér tiyyeḍ. ");
INSERT INTO thv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ǎddunet efelen berén awas d tǧammeḍ tǎfuk osen édeg iyyen dɣ asyaf dɣ ǎkal n Šinƹar ǎqqimen ds. ");
INSERT INTO thv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ennen ǧérésn : « Eywah ! Neknét oṭṭében ezzar éd tn enseŋ dɣ témsé ! » Oṭṭében ǎmosen asn éẓẓeden d ǎbeleɣleɣ teqqal asn tǎlaq ta temmalet ǧér oṭṭében. ");
INSERT INTO thv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ennen arweh : « Eywah ! Nexdemét baš éd neken aɣrem d elburj iyyen yéwaḍen aǧenna ! Éd nekreh tisellet, wr éd nemmezzey fol ǎrori n ǎmǎḍal imda. » ");
INSERT INTO thv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yeres-d Amaɣlol itassen ma-d yola aɣrem d elburj wi kannen ǎddunet. ");
INSERT INTO thv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ezzar yenna Amaɣlol dɣ iman ennét : « Ellamet iyyet, awal iyyen ! Nɣwah awas ebden emuken ennét, kud ebden hund awaɣ éd eknin awa eran imda. ");
INSERT INTO thv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Eywah ! Endawtet neres, éd ensemmerti awal nsn baš éd ǎbas éd tanefhamen ǧérésn. » ");
INSERT INTO thv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yezmezzey tn Amaɣlol fol ǎmǎḍal imda, ezzar oyyen elbeni n aɣrem.. ");
INSERT INTO thv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Fol awéndɣ as aɣrem iǧa isem Babel, -ǎsemmerti-, édét Amaɣlol déndɣ ad yesmertey awal n ǎddunet, yesmertey-tn fol ǎrori n ǎmǎḍal imda. ");
INSERT INTO thv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Awah iheyawen n Sam. Ila Sam téméḍé n ǎwetay as yewa rurés Arfakšad, essin iwetyan ḍeffer anǧi wa mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ḍeffer tiwit n Arfakšad yedder Sam semmoset temaḍ n ǎwetay. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","As yekreh Arfakšad keraḍet temerwén n ǎwetay d semmos yekreh arraw isem ennét Šelaḥ. ");
INSERT INTO thv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ḍeffer tiwit n Šelaḥ yedder Arfakšad ekkoẓet temaḍ n ǎwetay d keraḍ. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","As yekreh Šelaḥ keraḍet temerwén n ǎwetay yekreh arraw isem ennét Eber. ");
INSERT INTO thv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ḍeffer tiwit n Eber yedder Šelaḥ ekkoẓet temaḍ n ǎwetay d keraḍ. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","As yekreh Eber keraḍet temerwén n ǎwetay d ekkoẓ yekreh arraw isem ennét Feleg. ");
INSERT INTO thv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ḍeffer tiwit n Feleg yedder Eber ekkoẓet temaḍ n ǎwetay d keraḍet temerwén. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","As yekreh Feleg keraḍet temerwén n ǎwetay yekreh arraw isem ennét Reƹu. ");
INSERT INTO thv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ḍeffer tiwit n Reƹu, yedder Feleg senatet temaḍ n ǎwetay d teẓẓa. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","As yekreh Reƹu keraḍet temerwén n ǎwetay d essin yekreh arraw isem ennét Serug. ");
INSERT INTO thv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ḍeffer tiwit n Serug yedder Reƹu senatet temaḍ n ǎwetay d essa. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","As yekreh Serug keraḍet temerwén n ǎwetay yekrah arraw isem ennét Naḥor. ");
INSERT INTO thv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ḍeffer tiwit n Naḥor yedder Serug senatet temaḍ n ǎwetay. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","As yekreh Naḥor senatet temerwén n ǎwetay d teẓẓa yekreh arraw isem ennét Teraḥ. ");
INSERT INTO thv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ḍeffer tiwit n Teraḥ yedder Naḥor téméḍé n ǎwetay d meraw d teẓẓa. Yekreh arrawen d tarrawén heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","As yekreh Teraḥ essahet temerwén n ǎwetay yekreh keraḍ arrawen Abram d Naḥor d Haran. ");
INSERT INTO thv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Awah iheyawen n Teraḥ : Teraḥ yérew Abram d Naḥor d Haran. Yekreh Haran arraw isem ennét Loṭ. ");
INSERT INTO thv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran yemmut arweh yeddar tis Teraḥ dɣ Ur ǎkal wa dɣ yewa dɣ ǎkal n Kaldé. ");
INSERT INTO thv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Yewey Abram Saray, Naḥor yéwey Milka wlt Haran. Haran tis n Milka aked n Yiska. ");
INSERT INTO thv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray, tǎmeǧǧaǧrut, wr telé arraw wl iyyen. ");
INSERT INTO thv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Yéwey Teraḥ rurés Abram d aheya ennét Loṭ ag Haran d tǎḍeggalt ennét Saray, hennis n Abram, efelen Ur dɣ ǎkal n Kaldé ekken ǎkal n Kenƹan, as éweḍen Ḥaran ǎqqimen ds. ");
INSERT INTO thv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Yedder Teraḥ senatet temaḍ n ǎwetay d semmos ezzar yemmut dɣ Haran. ");
INSERT INTO thv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yenna Amaɣlol i Abram : « Efel ǎkal ennek d ǎddunet ennek d win tǎɣǎhamt n tik, ek ǎkal wa key éd sekneɣ. ");
INSERT INTO thv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Éd dk ekneɣ ellamet mǎqqeret. Éd hak eǧeɣ elbaraka. Éd erreɣ isem ennek yetiwezzay hullan. Éd dk eǧeɣ elbaraka i wi heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Éd ekfeɣ elbaraka-hin i wi key hakkenén ta nsn beššan éd elɣeneɣ wi key leɣɣennén. Tawsitén tin ǎmǎḍal emdanet éd eǧrewnet elbaraka-hin serek. » ");
INSERT INTO thv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yegla Abram, hund awa has yenna Amaɣlol, yeddéw ds Loṭ. Ila Abram essahet temerwén n ǎwetay d semmos as yefel Haran. ");
INSERT INTO thv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Yéwey hennis Saray d Loṭ, yǎmosen rurés n eɲɲas, éweyen a elen, aked éklan nsn wi ezzenhen dɣ Haran. Ekken ǎkal wan Kenƹan. Éweḍent. ");
INSERT INTO thv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Yejjer Abram akal ar édeg wa iǧen isem Šakim, ar ašek wan Moré. Γor déndɣ Kenƹaniten ezzaɣen ǎkal. ");
INSERT INTO thv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yemun-d Amaɣlol i Abram yenna has : « Éd ekfeɣ ǎkal waɣ i iheyawen ennek. » Yekna Abram ǎsǎɣres i Amaɣlol dɣ édeg wéngɣ dɣ has-d yemun. ");
INSERT INTO thv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yekka tidreɣén ellanén s aǧmoḍ n tǎfuk n Beytel, yekres ihenan ennét ǧér Beytel d Ay. Yeqqal as Beytel aɣil wan ǎgǎḍel n tǎfuk, Ay illas aɣil was d tǧammeḍ tǎfuk. Yekna ǎsǎɣres i Amaɣlol, yeƹbedt s isem n Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Éhen s wa heḍen, yennehel Abram ǎnǎhol berén ǎkal wan Negeb. ");
INSERT INTO thv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tellé menna dɣ ǎkal, fol awéndɣ yekka Abram Maṣar, yezzeɣ ds, édét menna teṣṣohet hullan dɣ ǎkal. ");
INSERT INTO thv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","As deroɣ yeǧǧeh Maṣar yenna Abram i Saray : « Seged ahi Saray, essaneɣ as km tǎmǎṭ tǎhoseyet a tǎmosed. ");
INSERT INTO thv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","As km éd eynin Elmesriten éd ennin tǎmǎṭin a tǎmosed, éd hi eŋɣin, km, éd km eyyin teddared. ");
INSERT INTO thv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Inhod ad tennéd tǎmeḍraytin a tǎmosed baš wr hi éd eŋɣin dɣ érét ennem, baš éd hi eknin taɣera dɣ érét ennem. » ");
INSERT INTO thv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","As yéweḍ Abram Maṣar, eneyen Elmesriten tihusay ti teǧa hennis. ");
INSERT INTO thv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Eneyen tt erraysen n Ferƹaon, ǎmǎnokal n Maṣar, ezzar ennen i amɣar in tekna tihusay. Teméwey-d tǎmǎṭ ɣor ǎmǎnokal. ");
INSERT INTO thv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Dɣ érét ennét Ferƹaon yekna taɣera i Abram. Yekfé éheré wa ǧezzulen d wa heǧrén, ihéḍan, d éklan d teklatén d tihéḍén d imnas. ");
INSERT INTO thv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Beššan Amaɣlol yesséwey fol Ferƹaon d tǎɣahamt ennét tilɣanén, wr has yegreẓ awén, yesséwey tǎxellawt dɣ érét n Saray hennis n Abram. ");
INSERT INTO thv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Adih yeɣra Ferƹaon Abram, yenna has : « Mafol teǧéd ahi awén ? Mafol wr hi tennéd as hennik a tǎmos ? ");
INSERT INTO thv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mafol tennéd ahi tǎmeḍrayt ennek a tǎmos, eknéɣ ds tǎmǎṭin, dimaɣ nɣtaḥ tǎmaṭ ennek, awi-tt d tegled ! » ");
INSERT INTO thv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Yessofeḍt Ferƹaon s médden, enta d hennis d tela nsn temda ad eǧmeḍen ǎkal. ");
INSERT INTO thv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Yefel Abram Maṣar, yekka berén Negeb enta d hennis d awa ila imda. Yeddéw ds Loṭ. ");
INSERT INTO thv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram yeɣmar hullan. Ila éheré d aẓref d oreɣ ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mn Negeb, ǎmǎzzaɣ s ǎmǎzzaɣ, yéweḍ Beytel, édeg wa dɣ kelad yekras éhen ennét, ǧér Beytel d Ay, ");
INSERT INTO thv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","édeg wa dɣ yekna ǎsǎɣres i Amaɣlol. Yeƹbed ds Abram s isem n Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loṭ yeddéw ds, aked enta ila éheré wa ǧezzulen d wa heǧrén, ila ihenan ennét aked enta. ");
INSERT INTO thv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ǎkal wr hasn yegdéh issenen ésn, tela nsn tekna dɣ ilwi ar wr ǎddobén muzɣet édeg iyyen. ");
INSERT INTO thv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Eknesen imaḍinen nsn. Kenƹaniten d Feriziten a yezzaɣen ǎkal émér héndɣ. ");
INSERT INTO thv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yenna Abram i Loṭ : « Wr éd yemlét ǎkennas ǧérénɣ ula ǧér imaḍinen nnɣ édét noɲɲat ! ");
INSERT INTO thv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ǎkal imda illa dat-k. Nemmezzeyét : kud tekkéd afella éd ekkeɣ ǎtǎram, kud tekkéd ǎtǎram éd ekkeɣ afella. » ");
INSERT INTO thv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Yeṭkel Loṭ ǎsewaḍ ennét, yeney as ǎkal wan ǎɣǎher n Elurdun yeksa, awén ar aɣrem wan Soɣar. Animér wr yeɣhéd Amaɣlol ikallen win Sodoma d Ƹamora, yola d ǎfǎraǧ wan Amaɣlol d ǎɣǎher wan Ennil dɣ Maṣar. ");
INSERT INTO thv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Yesnefren Loṭ ǎkal wa ɣor Elurdun, yegla yessokel berén awas-d tǧammeḍ tǎfuk, hund awéndɣ as emmezzeyen. ");
INSERT INTO thv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Yezzeɣ Abram dɣ Kenƹan. Loṭ, enta wadih, yekres ihenan ennét ɣor éɣremen wi ellenén ɣor Elurdun, ihenan ennét ekkan ar Sodoma. ");
INSERT INTO thv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ǎddunet wi ezzeɣnén Sodoma eššaḍen, ǎmosen inesbekkaḍen mǎqqornén fol Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","As yemmezzey Loṭ d Abram, yenna Amaɣlol i Abram : « Ǎṭkel ǎsewaḍ ennek dɣ édeg wa-d telléd, ekyed afella d ǎtǎram, berén awas d tǧammeḍ tǎfuk d ǎgǎḍel ennét. ");
INSERT INTO thv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ǎkal wa thanneyed imda, ekféɣ ak key d iheyawen ennek ar abedǎh. ");
INSERT INTO thv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Iheyawen ennek éd tn erreɣ eggeten hund tǎkessélt : as neqqel neddobet ǎseḍen n tǎkessélt dédih éd neséḍen aked iheyawen ennek. ");
INSERT INTO thv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Enker, sikel dɣ ǎkal imda édét key ast éd ekfeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yezzeɣ Abram ɣor iškan win Mamré dɣ Hebron, yekres ds ihenan ennét, yekna déndɣ ǎsǎɣres i Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Dɣ ezzeman wan imenokalen Amrafel wan Šinƹar d Ariok wan Alasar d Kedor-Layomer wan Elam d Tidal wan Goyim ");
INSERT INTO thv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","eggehen enmeŋɣi d imenokalen Béra wan Sodoma, Birša wan Ƹamora, Šinab wan Adma, Šemeber wan Ṣeboyim d ǎmǎnokal wan Béla, aɣrem wah iǧa aked isem wan Soɣar. ");
INSERT INTO thv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wiɣ ehreynén emelen dɣ ǎɣǎher wan Sidim ta tǎmoset ǧeréw wan tésemt. ");
INSERT INTO thv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dat awén, ǎmosen imɣad n Kedor-Layomer fol meraw iwetyan d essin beššan dɣ ǎwetay wan meraw d keraḍ enkeren fols. ");
INSERT INTO thv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ǎwetay wan meraw d ekkoẓ yenker Kedor-Layomer yessenker imidiwen ennét imenokalen. Ernen Refayiten dɣ Ašertaroṭ-Karnayim, Zuziten dɣ Ham, Emiten dɣ asyaf wan Qiriatayim. ");
INSERT INTO thv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Horiten widih ernen-tn ɣorsn dɣ tidreɣén nsn, dɣ ǎkal n Seƹir, eḍrenen-tn ar El-Faran ɣor tinariwén. ");
INSERT INTO thv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ezzar eqqelen-d In-Mišefaṭ, wa yǎmosen Qadeš. Ernen Amalékiten dɣ ǎkal nsn d Amoriten wi ezzeɣnén Hasason-Tamar. ");
INSERT INTO thv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Imenokalen n ikallen win Sodoma d Ƹamora d Adma d Ṣeboyim d Béla, wa yǎmosen Soɣar, essegmeḍen médden nsn, eǧen enmeŋɣi dɣ ǎɣǎher n Sidim, ");
INSERT INTO thv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","entenéḍ d imenokalen Kedor-Layomer wan Elam d Tidal wan Goyim d Amrafel wan Šinƹar d Ariok wan Alasar, ǎmosen semmos imenokalen fol ekkoẓ. ");
INSERT INTO thv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ellant unan n keḍran dɣ ǎɣǎher n Sidim. Imenokalen n Sodoma d Ƹamora erwelen ezzar oḍen dsn, wi heḍnén efferen dɣ tidreɣén. ");
INSERT INTO thv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wi ernenén éweyen awa elen kél Sodoma d Ƹamora aked imekšan emdan ezzar eglen. ");
INSERT INTO thv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Loṭ, ag eŋŋas n Abram yezzaɣ Sodoma. Éweyent aked enta d awa ila imda. ");
INSERT INTO thv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Iyyen dɣ wi erwelnén yennén i Abram wan Ƹibrani wa yezzeɣen ɣor iškan n Amori iyyen, Mamré. Mamré yǎmos eŋŋas n Ešekol d Aner, keraḍ ésn ǎmosen imidiwen n Abram, eǧan téséq ǧérésn ds. ");
INSERT INTO thv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","As yelmed Abram in ag eŋŋas yettermes, yesdew keraḍet temaḍ d meraw d ettam éklan, wi ewenén dɣ tǎɣǎhamt ennét, yelkem i ihenǧa ar Dan. ");
INSERT INTO thv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Yezmezzey Abram éklan ezzar oḍen fol ihenǧa dɣ éheḍ. Yerna imenokalen, yeḍren tn ar Hoba denneg Damašqa. ");
INSERT INTO thv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yéwey awa ohaɣen imda aked eɲɲas Loṭ d awa ila, téḍéḍén d ǎddunet wi ohaɣen ihenǧa emdan. ");
INSERT INTO thv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","As yerna Abram Kedor-Layomer d imenokalen wi heḍnén, yosé hin ǎmǎnokal n Sodoma dɣ ǎɣǎher n Šawa, yǎmosen ǎɣǎher wan Ǎmǎnokal. ");
INSERT INTO thv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Yosé hin ales iyyen heḍen, isem ennét Melkisedek yeqqalen ǎmǎnokal n Salam d ǎmǎrabu n Messineɣ wan Afella, yéwey-in tagella d elboẓa. ");
INSERT INTO thv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Yeǧa elbaraka i Abram, yenna : « Temlét elbaraka n Messineɣ wan Afella wa yexleken aǧenna d ǎmǎḍal fol Abram ! ");
INSERT INTO thv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Yeborek Messineɣ wan Afella wa key yessernén ihenǧa ennek ! » Yekfé Abram wa fol meraw n awad yéwey. ");
INSERT INTO thv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Yenna ǎmǎnokal n Sodoma i Abram : « Ekf ahi ǎddunet d tawyed hereten wi heḍnén. » ");
INSERT INTO thv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Yenna has Abram : « Eṭkeleɣ ǎfus s Amaɣlol, Messineɣ wan Afella wa yexleken aǧenna d ǎmǎḍal : ");
INSERT INTO thv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ahaḍeɣ as wr éd awyeɣ ula enḍerren ennek, ula ahed méɣ awa iraggelen iɣǎtémen ennek. Baš wr éd tenned : \"Esseɣmereɣ Abram.\" ");
INSERT INTO thv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wr éd agẓeɣ ula enḍerren i imanin. Wr eɣbéleɣ ar awa ekšen imidiwenin d tafolt n médden wi dɣi ǎddéwnén Aner d Ešekol d Mamré, widih éd awyin tafolt nsn. » ");
INSERT INTO thv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ḍeffer awén, yemun-d awal n Amaɣlol i Abram, iganna as : « Wr teksoḍed Abram ! Ǎmihahéɣ dk, nk ǎmoseɣ ǎmastan ennek, elkera ennek imaqqeren hullan. » ");
INSERT INTO thv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yenna Abram : « Ma hi éd tekfed Émeli Amaɣlol ? Egléɣ wr eléɣ arraw. Was éd eyyeɣ telahin enta Elyezer wan Damašqa. » ");
INSERT INTO thv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Yesséta daɣ : « Nk, wr hi tekféd arraw wa hé yekrehen telahin, enta wa yewen dɣ ihenanin. » ");
INSERT INTO thv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Adih Amaɣlol yenna has : « Kela, weggéɣ enta a hé yekrehen tǎkasit ennek, wa hé yekkussin, enta wa hé tarwed. » ");
INSERT INTO thv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yessegmeḍt éhen ennét ezzar yenna has : « Ekid aǧenna ezzar séḍen itran kud teddobét. » Ezzar yesseta daɣ : « Hund entenéḍ iheyawen ennek éd umasin eggeten. » ");
INSERT INTO thv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Yesfella Abram fol Amaɣlol. Fol awéndɣ as ast yesséḍen dɣ elhaq. ");
INSERT INTO thv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yenna has : « Ǎmoseɣ Amaɣlol, nk a key d issegmeḍen Ur dɣ Kaldé baš éd key ekfeɣ ǎkal waɣ théd baš éd yumas innek. » ");
INSERT INTO thv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Yessesten Abram : « Émeli Amaɣlol menék awa hé eǧeɣ éd elmedeɣ as édt ekreheɣ ? » ");
INSERT INTO thv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yenna has Yaḷḷah : « Awi ahid tésut n keraḍ iwetyan, téɣsé d ékrer elanén keraḍ iwetyan, tǎgerregert d tǎdebért meḍriyet. » ");
INSERT INTO thv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Yéwey as in Abram ǎxxuten wih. Yezmezzey-tn dɣ ǧéréǧéré sl igḍaḍ, yeznehel ak aɣil d ămidi ennét. ");
INSERT INTO thv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Osen-in iẓẓaẓen éd ekšin timeɣsay beššan Abram yesteɣ tn. ");
INSERT INTO thv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","As toḍa tǎfuk, yeṭṭes Abram s éḍes yeẓẓayen, yermeɣ dɣ tihay, tosé hid tǎremméq. ");
INSERT INTO thv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yenna has Amaɣlol : « Selleken as iheyawen ennek éd ezzeɣen dɣ ǎkal n elɣurba, éd ds umasen éklan, wr éd ds eynin ar toẓẓért ad akyin ekkoẓet temaḍ n ǎwetay. ");
INSERT INTO thv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Beššan ellametén tih dsn éd eknin éklan, tidih éd tnt eḥasbeɣ, ḍeffer adih eddobén éd eglin éwayen tela teǧǧét. ");
INSERT INTO thv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Key éd temmeted dɣ esselamet ezzar éd tenbeled as tessokeyed tewehré tǎhoseyet. ");
INSERT INTO thv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Wr-d éd yeqqel déɣ ar iheyawen ennek win ennubet tan ekkoẓet édét Amoriten wr eɣréden erk iǧiten baš éd tn esteɣeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","As toḍa tǎfuk, emelnet tihay mǎqqornén ; adih temelt témsé, témsé taɣ d ehu ennét takeyen ǧér ǎxxuten wi emmezzeynén. ");
INSERT INTO thv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ahel héndɣ yeǧa Amaɣlol téséq ǧérés d Abram. Yenna has : « Éd ekfeɣ ǎkal waɣ i iheyawen ennek, yekkan mn ǎɣǎher wan Maṣar ar ǎɣǎher wa mǎqqeren n Elferat, ");
INSERT INTO thv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ǎkal wan Qeniten d Qeniziten d Qadmoniten ");
INSERT INTO thv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","d Ḥethiten d Feriziten d Refayiten ");
INSERT INTO thv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","d Amoriten d Kenƹaniten d Girgašiten d Yabusiten. » ");
INSERT INTO thv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Wr tekréh Saray, hennis n Abram, arrawen. Beššan tela taklit Telmeṣrit iyyet isem ennét Hajar. ");
INSERT INTO thv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tenna Saray i ales ennét : « Ekid : Amaɣlol yekkas ahi térwa. Tiǧenén éd ekreheɣ arraw s taklitin. Inhod, egel sukey éheḍ ɣors. » Yeɣbel Abram awa has tenna Saray. ");
INSERT INTO thv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tenker Saray, hennis Abram, téwey Hajar, taklit ennét tan Telmeṣrit, tekfét i Abram, ales ennét. Awén itaǧ as yessokey Abram meraw iwetyan dɣ Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Yosa Abram Hajar, tessimrew. As telmed as tessimrew teqqim taǧ erk ǎkeyad i Saray, messas. ");
INSERT INTO thv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tenna Saray i Abram : « Yeqqelét key akwer wa hi yeweren ! Nk a hak-in iǧen taklitin dɣ édeg ennek ! As teney in tessimrew, taǧǧahi erk ǎkeyad. Yumasét Amaɣlol elqadi ǧérénɣ nk d key ! » ");
INSERT INTO thv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Yenna has Abram : « Awén taklit tannem a tǎmos, tella ǧér ifassen ennem. Eǧ as awa teréd. » Teqqim Saray taǧ a yexlan i Hajar ad tegla tekka ténéré. ");
INSERT INTO thv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yosét ǎngelos n Amaɣlol dɣ ténéré ɣor téṭ ta tellet dɣ ǎbǎreqqa n Šur. ");
INSERT INTO thv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Yessesten tt : « Hajar, taklit n Saray, mis-d tefeled ? Mis tekkéd ? » Tenna : « Erweleɣ fol Saray, ta hi telet. » ");
INSERT INTO thv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yenna has ǎngelos n Amaɣlol : « Eqqel ɣor messam, teqqimed taǧǧed awa ham tganna. » ");
INSERT INTO thv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yenna has ǎngelos n Amaɣlol : « Éd kem ekfeɣ iheyawen s wr neddobet ǎséḍen nsn awa hasn iǧa ǎǧut. » ");
INSERT INTO thv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ǎngelos n Amaɣlol yenna has daɣ : « Tessimrewed dimaɣ. Éd tekrehed arraw. Eǧ as isem Ismaƹil (elmeƹna ennét yesla Messineɣ) édét Amaɣlol yesla i toẓẓért ennem. ");
INSERT INTO thv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Rurém éd yumas hund eyhéḍ yeholelen. Yeṭkal ǎfus ennét fol ǎddunet emdan ; ǎddunet emdan eṭkalen ifassen nsn fols. Éd yezzeɣ yenimehal d ayet-mas emdan. » ");
INSERT INTO thv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Teǧa isem i Amaɣlol wa has yesséwelen : « Tǎmosed El-Roy, (elmeƹna ennét Messineɣ wa hi ihanneyen) » Tenna : « Eneyeɣ déɣ méɣ kela wa hi i ihanneyen ? » ");
INSERT INTO thv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Fol awéndɣ as anu iǧa isem Lahay-Roy, (elmeƹna ennét Anu wan wa yedderen hi ihanneyenen). Anu waɣ illa ǧér Qadeš d Béred. ");
INSERT INTO thv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Térew Hajar arraw i Abram, iǧa Abram i arraw wa has térew Hajar isem wan Ismaƹil. ");
INSERT INTO thv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ila Abram ettamet temerwén n ǎwetay d seḍis émer wad térew Hajar Ismaƹil i Abram. ");
INSERT INTO thv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","As yekreh Abram teẓẓahet temerwén n ǎwetay d teẓẓa yemun asin Amaɣlol yenna has : « Nk Messineɣ wan Ǎneddabu. Egel dati, umas yebbillel. ");
INSERT INTO thv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Éd eḍmeneɣ téséqin ǧéri dk éd key ekfeɣ iheyawen eknanén ǎǧut hullan. » ");
INSERT INTO thv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yenḍew Abram udem ennét fol ǎmǎḍal ezzar yenna has Yaḷḷah daɣ : ");
INSERT INTO thv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","« Nɣtah téséqin ǧéri dk : éd teqqeled tis n ellametén ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ǎbas key enɣar s Abram, éd teqqeled Ibrahim édét éd teqqeled tis n ellametén ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Éd key ekfeɣ iheyawen eknanén ǎǧut hullan, éd dk ekneɣ ellametén d imenokalen a key-d éd eǧmeḍen. ");
INSERT INTO thv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ogaẓeɣ téséqin ǧéri dk, d ǧéri d iheyawen ennek ḍeffer-k, éd tumas téséq teɣlalet, baš éd umaseɣ Messineɣ ennek d Messineɣ n térwa ennek. ");
INSERT INTO thv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Éd key ekfeɣ key d iheyawen ennek ǎkal waɣ dɣ tǎmosed ǎɣǎrib, ǎkal n Kenƹan. Éd yumas ǎkal nwn ar abedǎh. Éd umaseɣ Messineɣ n térwa ennek. ");
INSERT INTO thv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Yenna Yaḷḷah i Ibrahim : « Keyunan, éd tagẓed téséqin, key d iheyawen ennek ḍeffer-k dɣ ezzemanen emdan. ");
INSERT INTO thv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nɣtah téséqin ta hé taǧẓim ǧéri dk d ǧéri d iheyawen ennek : ak ales dɣ winnek ilzam as ǎzeyyen. ");
INSERT INTO thv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Édt tezzeyyenem, éd yumas éhwel n téséq ta ǧéri dewen. ");
INSERT INTO thv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Dɣ ak ezzeman, éyyan emdan n ǎddunet ennek éd ezzeyyenen as ekrehen ettam iheḍan, awén aked éklan wi uwenén ɣor-k méɣ wi tezzenhed s aẓref wrn ǎmos in térwa ennek. ");
INSERT INTO thv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Akli wa yuwen ɣor-k d wa tezzenhed s aẓref éd ezzeyenen, téséqin dɣ isan nwn téséq teɣlalet. ");
INSERT INTO thv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ales wa wrn yezzeyyen éd yemmukkes dɣ ellamet ennét folin yeɣtes téséqin. » ");
INSERT INTO thv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Yenna Yaḷḷah i Ibrahim daɣ : « Saray, hennik tadih, ǎbas tt tɣarred s isem wan Saray, dimaɣ isem ennét Sara. ");
INSERT INTO thv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Éd has eǧeɣ elbaraka, éd key ekfeɣ arraw n éy ds. Éd has eǧeɣ elbaraka éd tumas mas n ellametén ǎǧǧotnén, imenokalen n ellametén ǎǧǧotnén a tt-d éd yeǧmeḍen. » ");
INSERT INTO thv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Yenḍew Ibrahim udem ennét fol ǎmǎḍal ezzar yeṭsa, yenna dɣ iman ennét : « Menék awa hé eǧeɣ éd ekreheɣ arraw, nk wa ilen téméḍé n ǎwetay d Sara telat teẓẓahet temerwén n ǎwetay ? » ");
INSERT INTO thv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Yenna i Yaḷḷah : « Wr eréɣ ar éd yedder Ismaƹil dat-k. » ");
INSERT INTO thv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Yenna Yaḷḷah : « Kela, hennik Sara éd key tekf arraw d teǧed as isem Isḥaq. Éd agzeɣ téséqin ǧéri ds d ǧéri d iheyawen ennét ar abedǎh. ");
INSERT INTO thv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Awa tennéd fol Ismaƹil, esléɣ as : éd has eǧeɣ elbaraka, éd yekreh ǎǧut arraw, éd yekreh iheyawen. Éd yumas tis n meraw imenokalen d essin. Éd yeqqel tis n ellamet mǎqqeret. ");
INSERT INTO thv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Beššan téséqin éd tt agzeɣ ǧéri d Isḥaq, arraw wa hak éd taru Sara ǎwetay wad iglen hund émér waɣ. » ");
INSERT INTO thv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","As yesmenda Yaḷḷah awal ǧérés d Ibrahim, yefelt. ");
INSERT INTO thv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Yezzeyyen Ibrahim arraw ennét Ismaƹil d médden wi ewenén dɣ tǎɣǎhamt ennét d wi yezzenha s aẓref ennét. Éyyan emdan dɣ ǎddunet win tǎɣǎhamt tan Ibrahim ezzeyyenen ahel héndɣ hund awa has yenna Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","As yezzeyen Ibrahim ila teẓẓahet temerwén n ǎwetay d teẓẓa. ");
INSERT INTO thv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","As yezzeyen rurés Ismaƹil ila meraw iwetyan d keraḍ. ");
INSERT INTO thv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ahel iyyen ad ezzeyenen Ibrahim d arraw ennét Ismaƹil, ");
INSERT INTO thv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","aked médden win tǎɣǎhamt n Ibrahim emdan, wi ewenén déndɣ méɣ wi enhenén s aẓref ɣor iɣǎriben, emdan ezzeyyenen. ");
INSERT INTO thv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yemun-d Amaɣlol i Ibrahim ɣor iškan win Mamré. Ibrahim yeqqim dɣ émi n éhen ennét émér wad yekkus ahel. ");
INSERT INTO thv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Yeṭkel ǎsewaḍ ennét, yeney keraḍ médden ebdadnén illehasin, déndɣ-d tn yeney yohelin yefal émi n éhen ennét, yerkeƹ datsn ar ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Yenna : « Sidi, inhod, kud egreweɣ ɣorek udem, wr tokeyed ɣor akli ennek sl wr tebdeded ɣors. ");
INSERT INTO thv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Éd hawen-d ǎmawyin heret n aman baš éd tsérdim éḍaren nwn ezzar éd tsunfum dɣ télé n ašek. ");
INSERT INTO thv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Éd hawen-d awyeɣ a tekšem, aɣrum n tagella hawen yessokesen ulawen nwn, ezzar éd takyim ǎbǎreqqa nwn. Awéndɣ as tokeyem dat éhen n akli nwn ! » Ennen as : « Eǧ awas tennéd. » ");
INSERT INTO thv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Yohel Ibrahim s éhen ɣor Sara yenna has : « Hik ! Eṭkel keraḍet tẓiwawén n éǧél wa yehoseyen d tekned keraḍet tiǧelwén. » ");
INSERT INTO thv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ezzar yohel yekka éheré, yéwey ǎloki yehoseyen, yedderén. Yekfé i akli ennét éd yerured éd ds imhihi. ");
INSERT INTO thv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","As eknen isan, yeǧén Ibrahim dat imegaren ennét entenéḍ d ax wa yeẓẓen d wa kefayen. Tatten a yekka Ibrahim yella édés nsn dag ašek. Esmenden téteté. ");
INSERT INTO thv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ezzar essestenent : « Magga hennik Sara ? » Yenna : « Tella deh, teha éhen. » ");
INSERT INTO thv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yenna : « Esilekeneɣ ak as éd-d ǎqqeleɣ aẓen ! Γor déndɣ Sara, hennik tekrah arraw. » Sara tesiged teha émi n éhen illan ḍeffers. ");
INSERT INTO thv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Beššan Ibrahim d Sara weššaren, eknan tewǎhré. Sara ǎbas tt-d tas ta-d taset téḍéḍén ak tallit. ");
INSERT INTO thv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Teṭsa Sara dɣ iman ennét, tenna : « Dimaɣ-d weššereɣ d alesin weššer, émér n tǎẓudé édt yemel ? » ");
INSERT INTO thv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yessesten Amaɣlol Ibrahim : « Mafol teṭsa Sara ? Mafol tenna : \"Wr yenmehal éd ekreheɣ arraw édét weššareɣ ?\" ");
INSERT INTO thv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ma yendaren i Amaɣlol. Aẓen, dɣ émér ennét, as-d éd ǎqqeleɣ, éd tekreh arraw. » ");
INSERT INTO thv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Termeɣ Sara, tenna bahu : « Wr eṭséɣ. » Yenna has Amaɣlol : « Tidet diš, teṭséd ! » ");
INSERT INTO thv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Enkeren médden baš éd eglin, ennehelen Sodoma. Yessofeḍ tn Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yenna Amaɣlol dɣ iman ennét : « Éd effereɣ i Ibrahim awas ǎbokeɣ tiǧawt ennét ? ");
INSERT INTO thv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Yemmukken in éd yeqqel tis n ellametén ǎǧǧotnén hullan, mǎqqornén. Édt id tefel elbaraka ta hé tewrit ǎddunet n eddunya temda. ");
INSERT INTO thv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Édét esnefreneɣt baš éd iselmed i meddans d iheyawen ennét ǎbǎreqqa n Amaɣlol, taǧǧen elḥaq d a yeẓẓalen. Baš éd yeǧ Amaɣlol i Ibrahim awa has yenna. » ");
INSERT INTO thv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yenna Amaɣlol i Ibrahim : « Esléɣ i tǎɣerit ta tǎṣṣohét fol ǎmezzaɣ n Sodoma d Ƹamora, ibekkaḍen nsn elmenker mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Éd hin erseɣ éd esseneɣ tidet awas esléɣ itahawalen folsn. Kud taǧǧen elmenker wéndɣ folsn yehéwelen, éd ss elmedeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Imegaren winǧam ekken Sodoma, Ibrahim yeqqim yebdad dat Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Yoheẓ in Ibrahim yenna : « Tidet as teddobéd éd teŋɣed wa yeẓẓelen yeddéw d ănesbekkaḍ ? ");
INSERT INTO thv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kud ellant semmoset temerwén n ǎwadem yeẓẓalen dɣ aɣrem. Teddobed éd tn teŋɣed aked entenéḍ ? Wr teddobéd éd tsorfed i édeg wéndɣ dɣ érét n win semmoset temerwén wi eẓẓelnén ? ");
INSERT INTO thv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kela ! Wr teddobéd éd teŋɣed wi eẓẓelnén ! Kela ! Wr teddobéd éd teŋɣed wa yeẓẓelen yola d ănesbekkaḍ. Kela ! Mafol wr yeddobet elqaḍi n edduniya temda tiǧawt n a yeẓẓalen ? » ");
INSERT INTO thv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yenna Amaɣlol : « Kud oséɣ semmoset temerwén n ǎwadem yeẓẓalen dɣ aɣrem, éd sorfeɣ i édeg waɣ imda dɣ érét nsn. » ");
INSERT INTO thv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Yenna Ibrahim : « Soref ahi, é Émeli, fol awal wa hak taggeɣ, wr ǎmoseɣ ar heret n tǎgoḍrart d éẓed, ula ǎmoseɣ. ");
INSERT INTO thv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kud dag semmoset temerwén eẓẓalnén adt illan, kud ella ekkoẓet temerwén d semmos. Fol semmos wi osernén éd tn teŋɣed emdan ? » Yenna Amaɣlol : « Wr tn éd eŋɣeɣ kud oséɣ ekkoẓet temerwén d semmos. » ");
INSERT INTO thv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Yenna Ibrahim daɣ : « Kud wrt ellen ar ekkoẓet temerwén. » Yenna Amaɣlol : « Wr teǧǧeɣ ula dɣ érét n win ekkoẓet temerwén. » ");
INSERT INTO thv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Yenna Ibrahim : « Inhod wr tewweššened kud esséweleɣ daɣ, é Émeli. Tigenén wrt ellén ar keraḍet temerwén. » Yenna Amaɣlol : « Wr tn éd eŋɣeɣ kud oséɣ keraḍet temerwén. » ");
INSERT INTO thv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Yenna Ibrahim : « Soref ahi kud esséweleɣ ak animér, é Émeli. Tigénén wrt ellén ar senatet temerwén ? » Yenna Amaɣlol : « Wr tn éd eŋɣeɣ kud oséɣ senatet temerwén. » ");
INSERT INTO thv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Yenna Ibrahim : « Inhod, é Émeli, wr tewweššened. Wr éd siwleɣ animér. Beššan tigenén wrt ellén ar meraw eẓẓalnén. » Yenna Amaɣlol : « Wr tn éd eŋɣeɣ dɣ érét n meraw widɣ. » ");
INSERT INTO thv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","As yesmenda Amaɣlol awal yegla, Ibrahim yeqqel éhen ennét. ");
INSERT INTO thv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Iẓelluwaẓ as éweḍen ǎngelosen winǧam essin Sodoma. Yeqqim Loṭ dɣ émi n aɣrem, édeg wa dɣ timheyyin ǎddunet. As tn yeney, yenker, yerkeƹ datsn ar ǎmǎḍal, udem yewer ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Yenna : « Inhodet, Siditenin, emmeret tǎɣǎhamtin. Teddobém éd tsérdim éḍaren nwn d tensim, awén ɣor akli nwn. Tufat s tufat éd takyim ǎbǎreqqa nwn. » Ennen : « Kela, éd neṭṭes dɣ ǧéréǧéré n aɣrem. » ");
INSERT INTO thv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Beššan yeẓey tn Loṭ ad eɣbelen éd emmeren ɣors. Yekna sn amensu mǎqqeren, yesseŋŋa sn tiǧelwén wr thé elxemméra ezzar ekšen. ");
INSERT INTO thv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Wr ensén animér as in osen médden win aɣrem, médden win Sodoma eɣleyen i tǎɣǎhamt, wi meḍruynén hund wi weššarnén, emdan osen in. ");
INSERT INTO thv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Eɣren Loṭ ennen as : « Ma eǧen médden wi key-d osenén éheḍ waɣ ? Segmeḍ tn-d. Nera éd tn nk. » ");
INSERT INTO thv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Yegmeḍ Loṭ dat émi, yergel taflut ḍeffers, ");
INSERT INTO thv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","yenna : « Inhodet imidiwenin wr tegem elmenker. ");
INSERT INTO thv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ekidet, eléɣ senatet tarrawén awenet wr ezzéynet médden, éd hawen tnt-in awyeɣ eǧet awa teram srsnt. Beššan wr teǧém heret i imeǧarenin édét ellan daw ihenanin. » ");
INSERT INTO thv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ennen as : « Efel datnɣ ! Wah wr yǎmos ar ǎɣerib, yosed yera éd yeǧ elxekuma ɣornɣ. Adih éd hak neǧ a yernan awa hasn éd neǧ ! » Ezzenkehen Loṭ s eṣṣahet ezzar eɣhelen éd erẓin taflut. ");
INSERT INTO thv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Oren médden win essin taflut, eẓẓelen ifassen nsn, ermesen Loṭ, ezzogehent ezzar ergelen taflut. ");
INSERT INTO thv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ǎddunet wi ellenén dat émi, ekfen tn teddǎrɣelt emdan wi meḍruynén hund wi mǎqqornén ad hasn tender tisit n taflut. ");
INSERT INTO thv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ennen médden win essin i Loṭ : « Teléd ǎddunet ennek arweh ? Iḍulan, arrawen, tarrawén d ǎddunet emdan. Seǧmeḍ wi tléd emdan aɣrem. ");
INSERT INTO thv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Édét éd nehheddem aɣrem, édét Amaɣlol yesla i tǎɣerit mǎqqeret ta taǧǧet fol ǎddunet win déɣ. Yesséwey anɣ-d éd nehhedem aɣrem waɣ. » ");
INSERT INTO thv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Yosa Loṭ médden wi hé awinén eššéš, yenna hasn : « Hik ! Téklé, Amaɣlol yera ǎheddem n aɣrem waɣ. » Beššan eɣélen tǎhǎnḍezzit. ");
INSERT INTO thv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","S ihokhaken, ennen ǎngelosen i Loṭ éd yermaḍ : « Téklé, téklé, ebded, awi hennik d tarrawén ennek tih senatet baš wr éd tehheddemem dɣ érét n ibekkaḍen n aɣrem. » ");
INSERT INTO thv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Beššan yeǧa imehlan, ermesen médden Loṭ s ǎfus enta d hennis s ǎfus d eššeš s ǎfus, essegmeḍen tn aɣrem édét Amaɣlol yera éd tn yennej. ");
INSERT INTO thv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","A yekka isaǧmaḍ tn aɣrem yenna iyyen dɣ médden i Loṭ : « Erwel baš éd teddered, wr tekyeded ḍefferk, wr tebdeded dɣ ǎbǎreqqa dɣ ǎǧuras imda, ek tadreq baš éd teddered. » ");
INSERT INTO thv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Yenna Loṭ : « Kela, inhod é Émeli, awah wr yemmuken. ");
INSERT INTO thv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tidet as teǧéd i akli ennét a yehoseyen, tessikned ahi tamella édét togaẓed ahi tǎmeddort. Beššan wr ǎddobéɣ d erweleɣ s tadreq arweh wr yehheddem aɣrem, éd emmeteɣ. ");
INSERT INTO thv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Inhod, hanneyed taɣremt tén toheẓet ? Tohaẓ, ey ahi éd ahleɣ a tt awḍeɣ. Inhod, meḍriy taɣremt téndɣ, ey ahi éd ss erweleɣ baš éd ennejjeɣ imanin. » ");
INSERT INTO thv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Yenna has : « Egel, eɣbaleɣ ak éd eyyeɣ taɣremt tas tgannéd wr tehheddem. ");
INSERT INTO thv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","As ét hik erwel ss édét wr eddobéɣ a eǧéɣ arweh wr tt-in téweḍed. » Fol awéndɣ as taɣremt téndɣ teǧa isem Soɣar, (elmeƹna ennét ta meḍriyet). ");
INSERT INTO thv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Déndɣ éd tenker tǎfuk ad yéweḍ Loṭ Soɣar. ");
INSERT INTO thv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Γor déndɣ a hin yessertek Amaɣlol témsé d-tefalet aǧenna a awḍis fol Sodoma d Ƹamora. ");
INSERT INTO thv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yǎhheddem éɣermen win essin ehhedemen entenetéḍ d ǎǧuras imda, aked ǎddunet emdan d at illen n iškan. ");
INSERT INTO thv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Beššan hennis n Loṭ tesweḍ ḍeffers, teqqel tǎgettewt n tésemt. ");
INSERT INTO thv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Déndɣ-d yeffo ahel wa heḍen yekka Ibrahim édeg wadɣ yenmebded d-Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","As yekyed berén Sodoma d Ƹamora d ǎǧuras wa hasn yeɣlayen yeney ǎhu yeẓẓagen d-ifalen ǎmaḍal hund ǎhu d-ifalen elfor. ");
INSERT INTO thv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Hund awéndɣ adih, as yehheddem Yaḷḷah éɣermen win ǎǧuras, yesmekta-d Yaḷḷah Ibrahim, fol awéndɣ as yennejja Loṭ fol ǎheddem, yessegmeḍt aɣrem wa yezzeɣ. ");
INSERT INTO thv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Yeksoḍ Loṭ éd yeqqayem dɣ Soɣar, yefel ǎkal baš éd yezzeɣ dɣ tadreq. Tarrawén ennét elkemnet as, yezzeɣ enta dsnt dɣ elkǎwri iyyen dɣ tadreq. ");
INSERT INTO thv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ahel iyyen tenna ta mǎqqeret i tǎmeḍrayt ennét : « Abbannɣ weššar, wrt illé ales dɣ ǎkal baš éd dnɣ yenmens hund awa itaweǧǧén dɣ ak édeg. ");
INSERT INTO thv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Endawet éd nesesu elboẓa i abbannɣ baš ak iyyet éd sukey éheḍ ɣors baš éd yekreh iheyawen. » ");
INSERT INTO thv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Esseswenet abba nsnt elboẓa, éheḍ héndɣ tensa ɣors ta mǎqqeret. Wr yeššek i ula enḍerren, ula awad tensa ula awad tenker. ");
INSERT INTO thv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ahel wa heḍen ta mǎqqeret tenna i ta mǎḍreyet : « Nk ǎssokeyeɣ éheḍ ɣor abba nnɣ. Nesseswét éheḍ waɣ animér, maléla ennem. Hund aɣdɣ éd tnekf iheyawen. » ");
INSERT INTO thv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Essexbetnet tisnet arweh ezzar ta meḍriyet tessokey éheḍ ɣors. Wr yeššek i ula enḍerren, ula awad tensa ula awad tenker. ");
INSERT INTO thv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Essemrewnet eššét n Loṭ dɣ tisnt. ");
INSERT INTO thv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ta mǎqqeret tekreh arraw teǧas isem Mowab. Enta tis n Mowabiten ar dimaɣ. ");
INSERT INTO thv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ta meḍriyet aked enta tekreh arraw teǧas isem Ben-Ƹammi. Enta tis n Beni-Ƹammon ar dimaɣ. ");
INSERT INTO thv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Yefel Ibrahim édeg wah, yekka ǎkal wan Negeb. Yezzeɣ ǧér Qadeš d Šur, ezzar yezzeɣ aɣrem wan Gerar. ");
INSERT INTO thv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Iganna Ibrahim in Sara tǎmeḍrayt ennét a tǎmos. Yeṭṭef tt Abimelek ǎmǎnokal n Gerar. ");
INSERT INTO thv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","S éheḍ yosa Yaḷḷah Abimelek dɣ tihorǧa yenna has : « Key, éd temmeted dɣ érét n tǎmǎṭ ta teṭṭafed, enta teddéw. » ");
INSERT INTO thv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek wa wrn tt yeḍés yenna i Yaḷḷah : « É Émeli, éd teŋɣed ellamet teẓẓalet ? ");
INSERT INTO thv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Weǧǧén Ibrahim iman ennét ahi yennen in tǎmeḍrayt ennét a tǎmos, enta tenna ǎmeqqar ennét a yǎmos. Awa eǧéɣ, eǧéɣt s enniyetin, wrt eǧéɣ dɣ tekma wl iyyet. » ");
INSERT INTO thv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dɣ teharǧit ten dɣ yenna Yaḷḷah : « Aked nk essaneɣ as enniyet ennek as telkamed. Nk a hak yekkesen éd teǧed ǎbekkaḍ foli, awéndɣ as wr key oyyéɣ éd tt teḍsed. ");
INSERT INTO thv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Dimaɣ er tǎmǎṭ i ales ennét. Enta ennebi a yǎmos, éd hak yemuhed baš éd teddered. Beššan kud wr tt terréd elmed as tǎmettant a hak yeqqalen key d winnek. » ");
INSERT INTO thv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yenker Abimelek déndɣ-d yeffo yeɣra éklan ennét emdan yenna hasn awén. Armeɣen médden hullan. ");
INSERT INTO thv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Yeɣra Abimelek Ibrahim yessestent : « Ma haneɣ teǧéd deh ? Ma hak eɣhedeɣ baš éd hi tsewred nk d elmelekin ǎbekkaḍ mǎqqeren ? Teǧéd ahi a wrn iteweǧǧi. » ");
INSERT INTO thv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Yesséta Abimelek daɣ : « Ma key iǧrawen as taǧǧed awén ? » ");
INSERT INTO thv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Yenna Ibrahim : « Ennéɣ dɣ imanin in itbat as ǎddunet windɣ wr eǧén eššek i Yaḷḷah, éd hi eŋɣin dɣ érét n tǎmǎṭin. ");
INSERT INTO thv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Beššan tidet as tǎmeḍraytin édét abbannɣ iyyen, anna ɣas a wr nohér, adih teqqel tǎmǎṭin. ");
INSERT INTO thv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","As i yesfel Yaḷḷah tǎɣǎhamt n abbahin ennéɣ i tǎmǎṭin : \"Is nekka, inhod ad tennéd as ǎmeqqar ennem a ǎmoseɣ\". » ");
INSERT INTO thv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Yekfa Abimelek Ibrahim éheré wa ǧezzulen d wa heǧrén d éklan ǎmosnén téḍéḍén d médden, yerras hennis Sara. ");
INSERT INTO thv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Yenna has : « Ǎkalin yǎmérak. Ek édeg wa teréd, ezzeɣ awad teréd. » ");
INSERT INTO thv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ezzar yenna i Sara : « Hanneyed, ekféɣ aǧim n erriyalen n aẓref i ǎmeqqar ennem, yǎmos am hund afer yewaren téṭṭawén n emdan wi ellenen ɣorm, éd elmeden as kem tezzubbéd. » ");
INSERT INTO thv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Adih yemohed Ibrahim Yaḷḷah fol Abimelek, yǎzozey tn Yaḷḷah enta d hennis d téklatén ennét baš éd aruwnet. ");
INSERT INTO thv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Édét Amaɣlol yekkas asn térwa emdan dɣ érét n Sara, hennis n Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yesres Amaɣlol elxér fol Sara s emmek was iǧa awal ennét, yeǧas Amaɣlol i Sara awas as yenna. ");
INSERT INTO thv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tessimrew Sara, Ibrahim weššar hullan émér héndɣ, térew arraw i Ibrahim émér was as yenna Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Iǧa Ibrahim isem i arraw wa yekreh, wa has térew Sara Isḥaq (elmeƹna ennét taḍeẓẓa). ");
INSERT INTO thv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Yezzeyen Ibrahim arraw ennét Isḥaq as yekreh ettam iheḍan hund awa has yenna Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahim ila téméḍé n ǎwetay as yewa rurés Isḥaq. ");
INSERT INTO thv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tenna Sara : « Yesseṭsahi Yaḷḷah s tǎdewit. Emdan wi hé eslinén i tiwit n Isḥaq éd hi eṭsin. » ");
INSERT INTO thv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tenna arweh : « Mi yeddobén éd yen i Ibrahim, in ahel iyyen Sara éd tsenkes arrawen ? Beššan ekfeɣt arraw dɣ tewehré ennét ! » ");
INSERT INTO thv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Yedwel arraw, yogel. As yogel Isḥaq iǧa Ibrahim teramman mǎqqeret. ");
INSERT INTO thv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Teney Sara Ismaƹil arraw wan Ibrahim wa térew Hajar telmeṣrit, iḍazzen. ");
INSERT INTO thv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ezzar tenna i Ibrahim : « Esteɣ taklit tah enta d rurés. Wr eréɣ éd yaher tǎkasit d arrawin Isḥaq. » ");
INSERT INTO thv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Awal waɣ yessexzen Ibrahim hullan édét Ismaƹil rurés a yǎmos aked enta. ");
INSERT INTO thv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Beššan yenna has Yaḷḷah : « Wr texzéned fol taklit ennek d rurés. Seged i awa hak tenna Sara. Édét s Isḥaq as éd tekrehed iheyawen ennek. Iheyawen ennek wi hé eǧinén isem ennek éd tn tekrehed s Isḥaq. ");
INSERT INTO thv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Rurés n taklit aked enta éd yekreh iheyawen éd ds ekneɣ ellamet édét rurék a yǎmos. » ");
INSERT INTO thv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Déndɣ-d yeffo ahel wa heḍen, yéwey Ibrahim tagella d ǎbeyoɣ yeṭkaren aman, yekfén i Hajar, yeǧas tn fol éẓér, yekfét aked arraw, ezzar yesseglét. Tegla tehoreǧ dɣ ténéré tan Beršéba. ");
INSERT INTO thv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","As as emmenden aman toyya arraw dag ašek iyyen, ");
INSERT INTO thv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ezzar tegla teqqim illehasin, tenna : « Wr eréɣ éd eyneɣ arrawin itammet. » Teqqim illehasin teslef. ");
INSERT INTO thv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Yesla Yaḷḷah i ǎmesli n arraw, yeɣra ǎngelos n Yaḷḷah Hajar dɣ aǧenna, yenna : « Ma kem yegrawen Hajar ? Wr tekṣoḍed. Yaḷḷah yesla i ǎmesli n rurém dén. ");
INSERT INTO thv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ebded ! Awiy arraw ennem d teṭefedt s ǎfus, édét éd ekneɣ ds ellamet mǎqqeret. » ");
INSERT INTO thv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Yora Yaḷḷah téṭṭawén tin Hajar ezzar teney anu. Tekké, teṭker ds ǎbeyoɣ ennét, tesseswa arraw. ");
INSERT INTO thv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Yeɣlef Yaḷḷah fol arraw, yedwel. Yezzaɣ ténéré, yeqqel ǎmagdal s taɣǎyé. ");
INSERT INTO thv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Yeqqim dɣ ténéré n Faran, mas tesnefren as tǎmǎṭ dɣ ǎkal n Maṣar. ");
INSERT INTO thv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Émer héndɣ Abimelek d Fikol, amɣar wan jonditen ennét, ennen i Ibrahim : « Yaḷḷah yeddéw dk dɣ a teǧéd. ");
INSERT INTO thv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Dimaɣ ǎheḍ ahi déɣ s Yaḷḷah, in wr hi éd teɣdered nk ula wihin, win dimaɣ d wi elkemnén. Hund awa hak eǧéɣ dɣ ǎkal waɣ, eǧ elxér aked key i ǎddunet d ǎkal waɣ dɣ tezzeɣed. » ");
INSERT INTO thv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Yenna Ibrahim : « Ayoh, ǎhaḍeɣ ak ! » ");
INSERT INTO thv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Yesséwel Ibrahim i Abimelek fol anu iyyen oheɣen ǎddunet win Abimelek. ");
INSERT INTO thv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Yenna has Abimelek : « Wr esséneɣ mi iǧen awah. Wr hi tn tennéd. Ar ahel waɣ a has esléɣ. » ");
INSERT INTO thv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Adih yéwey Ibrahim éheré wa ǧezzulen d wa heǧrén yekfén i Abimelek eǧén téséq ǧérésn. ");
INSERT INTO thv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Yeẓmeẓley Ibrahim essahet tikerwatén dɣ éheré ennét. ");
INSERT INTO thv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Yessestent Abimelek : « Mafol teẓmeẓleyed essahet tikerwaten tih ? » ");
INSERT INTO thv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Yenna has Ibrahim : « Awi tnt baš éd tkuttud as nk a yeɣehen anu waɣ. » ");
INSERT INTO thv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Fol awéndɣ as iǧa édeg isem wan Beršéba (elmeƹna ennét Anu wan Elɣahed méɣ Anu wan Essa), édét déndɣ ad eǧen elɣahed. ");
INSERT INTO thv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Eǧen téséq nsn dɣ Beršéba. Ezzar yegla Abimelek yeddéw d Fikol, amɣar n jonditen ennét, eqqelen ǎkal wan Filistiniten. ");
INSERT INTO thv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Yeẓẓa Ibrahim tǎberekkat dɣ Beršéba, yemohed fol Yaḷḷah, yeɣré s Amaɣlol wan iddaren abedǎh. ");
INSERT INTO thv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Yezzeɣ Ibrahim a yeggén dɣ ǎkal n Filistiniten. ");
INSERT INTO thv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ḍeffer awén, yorem Yaḷḷah Ibrahim. Yeɣré : «Ibrahim key. », yenna Ibrahim : « Nk deh. » ");
INSERT INTO thv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Yenna Yaḷḷah : « Adih dimaɣ awiy Isḥaq, rurék wan iyyen, essaneɣ as teknéd as tera, ek ǎkal n Morya fol tadreq tas ak éd enneɣ ezzar, eket ahit takuté teqqadet. ");
INSERT INTO thv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ahel wa heḍen yenker Ibrahim déndɣ-d yeffo. Yeǧa ǎrukku fol eyhéḍ ennét, yéwey essin dɣ éklan ennét d rurés Isḥaq. Yerẓa iseɣéren win takuté teqqadet ezzar yekka édeg was as yenna Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ahel wan keraḍ, yeṭkel ǎsǎwaḍ ennét, yeney édeg dɣ iǧeǧ. ");
INSERT INTO thv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Yenna i éklan ennét : « Γeymet déɣ kewenéḍ d eyhéḍ. Nk d arrawin éd nek afella éd neƹbed Messineɣ ezzar éd kewen-d neqqel. » ");
INSERT INTO thv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Yeswer Ibrahim arraw ennét Isḥaq iseɣéren win tikutawén. Enta yéwey témsé d elmosi. Eglen eddéwen. ");
INSERT INTO thv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yenna Isḥaq i tis : « Abba ! » Yenna has Ibrahim : « Nk deh, arrawin. » Yenna Isḥaq : « Nela témsé d iseɣéren beššan ǎkerwat wan takuté ma iǧa ? » ");
INSERT INTO thv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Yenna has Ibrahim : « Arrawin, Yaḷḷah iman ennét éd yeḍḍebber ǎkerwat wan takuté. » Eglen eddéwen. ");
INSERT INTO thv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","As éweḍen édeg was yenna Yaḷḷah, yekna Ibrahim ǎsǎɣres wa fol yessensa iseɣéren. Yekred rurés Isḥaq ezzar yessensé fol ǎseɣres denneg iseɣéren. ");
INSERT INTO thv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Yeẓẓel ǎfus, yeṭkel elmosi baš éd yeɣres i rurés. ");
INSERT INTO thv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Beššan ǎngelos n Amaɣlol yeɣré dɣ iǧennawen : « Ibrahim, Ibrahim ! » Yenna Ibrahim : « Nk deh. » ");
INSERT INTO thv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Yenna has ǎngelos : « Wr teḍésed arraw. Wr has teɣhéded ula. Essaneɣ dimaɣ as teksoḍed Yaḷḷah édét wr hi tenkéẓed rurék, rurék wan iyyen. » ");
INSERT INTO thv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Yeṭkel Ibrahim ǎsǎwaḍ ennét, yeney ékrer yetiwermas s iskawen dɣ elweška iyyet. Yéweyt, yeŋɣé, yekna ss takuté teqqadet dɣ édeg n rurés. ");
INSERT INTO thv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Yeǧa Ibrahim isem i édeg wéndɣ Yahwé-Yiré (elmeƹna ennét yeḍḍebber Amaɣlol). Fol awéndɣ as itahawal dimaɣ : fol tadreq tan Amaɣlol, éd yeḍḍebber. ");
INSERT INTO thv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yeɣra ǎngelos n Amaɣlol dɣ iǧennawen Ibrahim animér. ");
INSERT INTO thv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Yenna has : « Awaɣ tanaṭ tan Amaɣlol : édét teǧéd awén, édét wr tenkéẓed rurék wan iyyen, ehaḍeɣ ak s imanin ");
INSERT INTO thv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","as éd hak eḍmeneɣ elbaraka hin s ǎǧut , éd silwiɣ iheyawen ennek hullan hund itran dɣ aǧenna méɣ ǎmǎḍal ɣor ǧeréw. Iheyawen ennek éd awyin iɣermen n ihenǧa nsn. ");
INSERT INTO thv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Éd ekfeɣ elbaraka hin i ellametén tin ǎmǎḍal imdan, s térwa ennek, édét tesgeded i awalin. ");
INSERT INTO thv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Yeqqel Ibrahim ɣor éklan ennét, ebdeden eqqelen Beršéba eddéwen, awad yezzeɣ Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ḍeffer awén, yehéwel i Ibrahim in Milka térew aked enta arrawen i eŋŋas Naḥor : ");
INSERT INTO thv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uṣ wa mǎqqeren, ǎmeḍray ennét Buz, Qemuwel tis n Aram, ");
INSERT INTO thv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazon, Fildaš, Yidlaf d Betuwel. ");
INSERT INTO thv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel a yérawen Rébéka. Awén meddans win ettam wi térew Milka i Naḥor, eŋŋas n Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naḥor ila tǎmǎṭ iyyet heḍet isem ennét Reyuma tekrahet arrawen : Teba d Gaham d Tahaš d Maƹka. ");
INSERT INTO thv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Tedder Sara téméḍé n ǎwetay d senatet temerwén d essa. Awén iwetyan wi tedder Sara. ");
INSERT INTO thv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Temmut dɣ Qiryat-Arba, yǎmosen Hebron dɣ ǎkal n Kenƹan. Yosin Ibrahim, yeḥzen fol hennis, yeslef fols. ");
INSERT INTO thv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Yefel édeg wa teha taɣessa n hennis ezzar yosa Ḥethiten yenna hasn : ");
INSERT INTO thv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","« Wr ǎmoseɣ ar ǎɣerib, ǎmegar nwn. Ekfet ahi édeg dɣ eknéɣ asenso, édeg wa dɣ éd enbeleɣ tenemmitentin. » ");
INSERT INTO thv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Esséwelen Ḥethiten i Ibrahim, ennen as : ");
INSERT INTO thv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","« Seged anɣ, Sidi ! Tǎmosed hund ǎmǎnokal n Yaḷḷah ǧérénɣ. Enbel tǎmǎṭ ennek dɣ ǎsenso wa tn yufen ɣornɣ. Wr haneɣ ihé wa hak éd yenkeẓen ǎsenso wah ula wa hak éd yenkeẓen éd tenbeled tenemmittent ennek. » ");
INSERT INTO thv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yenker Ibrahim ezzar yerkeƹ dat Ḥethiten wi ezzeɣnén ǎkal waɣ, ");
INSERT INTO thv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","yenna hasn : « Kud tebokem as, éd enbeleɣ henni déɣ, segdeti d siwlim ahi i Efron ag Sohar, ");
INSERT INTO thv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","baš éd hi yekf elkǎwri wan Makfela, yǎmosen innét, illa dɣ ǎǧenena n ǎfǎraǧ ennét. Éd hidt izenh datwn s ǎtuǧ ennét dɣ aẓref baš éd yeqqel asenso wah tela hin. » ");
INSERT INTO thv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron yeqqim ǧér Ḥethiten. Yenna Efron wan Ḥethit i Ibrahim dat Ḥethiten, emdan wi hin tasenén dat émi n aɣrem, édeg wa dɣ timhiyyin ǎddunet : ");
INSERT INTO thv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","« Kela, Sidi, seged ahi, ǎfǎraǧ ekféɣ akt, elkǎwri wat ihen, ekféɣ akt. Ekféɣ akt dat téṭṭawén n kél ellametin. Enbel tenemmittent ennek. » ");
INSERT INTO thv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yerkeƹ Ibrahim dat ǎddunet win ǎkal wah, ");
INSERT INTO thv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ezzar yesséwel i Efron dat ellamet n akal temda yenna : « Kud teboked as, inhod seged ahi ! Éd key ekfeɣ ǎtuǧ n ǎfǎraǧ. Awi aẓref wah, éd enbeleɣ tenemmittentin. » ");
INSERT INTO thv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Yesséwel Efron i Ibrahim, yenna has : ");
INSERT INTO thv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","« Seged ahi, Sidi. Édeg ihan ekkoẓet temaḍ n erriyalen n aẓref ula-t ihen ǧéri dk. Enbel tǎmǎṭ ennek. » ");
INSERT INTO thv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Yeɣbel Ibrahim, hund awa yenna, yeket i Efron dat Ḥethiten ekkoẓet temaḍ n erriyalen n aẓref wa eššešɣelen ettejjaren ezzar yekfas tn. ");
INSERT INTO thv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Dédih ǎmǎḍal n Efron illan dɣ Makfela berén Mamré d elkǎwri wadt ihen d iškan emdan wi ehenén ǎǧenena ennét ");
INSERT INTO thv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","eqqelen in Ibrahim, Ḥethiten emdan wi hin osenen dat émi n aɣrem ešhaden fol awén. ");
INSERT INTO thv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ḍeffer awén, yenbel Ibrahim hennis Sara dɣ elkǎwri n ǎmǎḍal n Makfela yenimehalen d Mamré, wa yǎmosen Hebron, dɣ ǎkal n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ǎmǎḍal d elkǎwri wadt ihen ǎmosen tela n Ibrahim d-tefalet Ḥethiten baš éd ds inabbel inemmuttan ennét. ");
INSERT INTO thv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Weššar Ibrahim, yekna tewehré hullan. Iǧas Amaɣlol elbaraka fol ak heret. ");
INSERT INTO thv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ahel iyyen yenna Ibrahim i wa yezzaren dɣ éklan ennét, wa yǎmosen amɣar nsn : « Eǧ ǎfus ennek dag taɣmahin. ");
INSERT INTO thv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Éd key zehḍeɣ s Amaɣlol, Yaḷḷah n aǧenna d ǎmǎḍal, in wr éd teǧmeyed i ruré tǎmǎṭ n ǎkal waɣ n Kenƹan, ǎkal waɣ dɣ ezzaɣeɣ. ");
INSERT INTO thv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Beššan éd tekked ǎkalin wan tidet ɣor ǎddunetin ezzar éd hi teǧmeyed tǎmǎṭ i ruré, Isḥaq. » ");
INSERT INTO thv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yenna has akli : « Tiǧenén tǎmǎṭ éd tugay éd hi telkem dɣ ǎkal waɣ. Éd awyeɣ dédih rurék s ǎkal wa tefeled ? » ");
INSERT INTO thv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Yenna Ibrahim : « Kela. Hékey éd tawyed ruré séndɣ. ");
INSERT INTO thv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Amaɣlol, Yaḷḷah n aǧenna, wa hi yesfelen tǎɣǎhamt n abbahin d ǎkal wan ǎddunetin, yesséwel ahi yeheḍ ahi in éd yekf ǎkal waɣ i iheyawenin. Enta a hé isiwyin ǎngelos ennét datk baš éd-d tawyed tǎmǎṭ i ruré. ");
INSERT INTO thv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Beššan kud wr teré tǎmǎṭ éd hak telkem, dédih éd key yefel éhéḍ wa teǧéd beššan wr teweyed ruré sendɣ fo ! » ");
INSERT INTO thv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Yeǧa akli ǎfus ennét dag taɣma n messis Ibrahim ezzar yeheḍ as in éd yeǧ awa has yenna. ");
INSERT INTO thv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Yéwey meraw imnas dɣ imnas win messis. Yéwey hereten wi tn unfenén dɣ win messis. Yegla yekka ǎkal wan Aram-Ennahreyn dɣ aɣrem wan Naḥor. ");
INSERT INTO thv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","As yéweḍ ɣor anu wa yoheẓen aɣrem, yesgen imnas ɣor anu. Awén iẓelluwaẓ émér wad harreǧnet téḍéḍén aman. ");
INSERT INTO thv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Yenna : « É Amaɣlol, Messineɣ n messi Ibrahim, ahi yellilen éd yeǧ amhiyyu ahel waɣ. Seken ahi sémɣar ennek i Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Elléɣ ɣor téṭ, tarrawén ti ezzeɣnén aɣrem éd-d asinet ehraǧnet. ");
INSERT INTO thv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Éd egmeyeɣ dɣ iyyet éd hi tekf aman baš éd esweɣ. Kud tenna : \"Esu, éd ekfeɣ aman aked i imnas ennek\", éd elmedeɣ dédih as enta a teréd éd tt yawi Isḥaq. Éd elmedeɣ adih as tessimɣered messi. » ");
INSERT INTO thv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Animér wr yesmenda awa iganna as in tosa Rébéka welt Betuwel, wa érewen Milka d Naḥor, eŋŋas n Ibrahim. Teway elgeḷḷa ennét fol éẓér. ");
INSERT INTO thv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Tǎmos tǎmawaṭ tǎhoseyet, atewa wr tezzéy médden. Teres s téṭ, teṭker elgeḷḷa ennét ezzar téwen. ");
INSERT INTO thv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yohelin srs akli n Ibrahim yenna has : « Inhod, seswahi dɣ aman n elgeḷḷa ennem. » ");
INSERT INTO thv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Tenna has : « Esu, Sidi ! » Tesres-in elgeḷḷa ennét hik tekfé aman. ");
INSERT INTO thv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","As tesmenda tenna has : « Éd ehreǧeɣ aman i imnas ennek baš éd eknin tésesé aked entenéḍ. » ");
INSERT INTO thv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Termeḍ tesseŋɣel aman dɣ édeg wa dɣ sassen imnas ezzar tohel tehreǧ animér. Tesseswa imnas emdan. ");
INSERT INTO thv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Yekyad tt ales, yessossem, itaxemmam in Amaɣlol yellil as méɣ dɣ asikel ennét. ");
INSERT INTO thv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","As esmenden imnas tésesé, yekfa ales i tǎmawaṭ tiǧemt n oreɣ yogdan d aɣil n erriyal d essin ihebgan n oreɣ ogdanén d meraw erriyalen. ");
INSERT INTO thv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Yessesten tt : « Inhod leɣtahi mi kem yérewen ? D leɣted ahi kud illé édeg ɣor tim baš éd enseɣ éheḍ waɣ nk d wi dɣi eddéwnén ? » ");
INSERT INTO thv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","tenna has : « Nk welt Betuwel ag Milka d Naḥor. ");
INSERT INTO thv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Γornɣ illé édeg wa dɣ éd tensim d iškan d ǎrummu s ǎǧut. » ");
INSERT INTO thv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Yeneh ales, yerkeƹ dat Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Yenna : « Ǎborekeɣ Amaɣlol, Messineɣ wan messi Ibrahim, wa yogaẓen ellemana d sémɣar ennét i Ibrahim. Yeznehel ahi ɣor ǎddunet n messi déndɣ yezzaren. » ");
INSERT INTO thv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tohel tǎmawaṭ s tǎɣǎhamt n mas éd teǧ isǎlan. ");
INSERT INTO thv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rébéka tela eŋŋas igan isem Laban. Yegmeḍ Laban hik yosa ales ɣor teṭ. ");
INSERT INTO thv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Édét yenay tiǧemt d ihebgan dɣ ǎfus n welt mas, yeslâ i isǎlan wi yeǧa ales i Rébéka, yosa ales enta d imnas ennét ɣor téṭ. ");
INSERT INTO thv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Yenna has : « As-d ɣori, key wa ilen elbaraka n Amaɣlol. Mafol teqqimed dɣ ténéré ? Ezwejjedeɣ tǎɣǎhamt, imanin, eknéɣ édeg i imnas. » ");
INSERT INTO thv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Yekka ales ɣor Laban. Yesseɣser Laban imnas, egrewen iškan d ǎrummu. Egrewen enta d ǎddunet wi ds eddéwnén aman éd serdin éḍaren nsn. ");
INSERT INTO thv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yeǧrew imekšan beššan yenna : « Wr tetteɣ ar eskundebat ennéɣ awas eréɣ éd tn enneɣ. » Yenna has Laban : « Siwel adih ! » ");
INSERT INTO thv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Yenna ales : « Nk, akli n Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Amaɣlol iǧa elbaraka mǎqqeret i Ibrahim, wan messi, yeɣmer, yeqqel ales mǎqqeren édét yekfé Yaḷḷah éheré wa ǧezzulen d wa heǧrén d aẓref d oreɣ, éklan d téklatén, imnas d iheḍan. ");
INSERT INTO thv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Hennis Sara, dɣ tewehré ennét, tekfa arraw i messi, yekfé tela ennét temda. ");
INSERT INTO thv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Yezheḍi messi Ibrahim, yenna : \"Wr tǧemmiyed tǎmǎṭ i ruré dɣ šét Kenƹaniten, dɣ ǎkal waɣ ezzaɣeɣ. ");
INSERT INTO thv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Yuf tekkéd ǎddunet n ti, dɣ tawsitin baš éd tawyed tǎmǎṭ i ruré\". ");
INSERT INTO thv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ezzar essestenneɣt : \"Kud tuǧey tǎmǎṭ éd dɣi tidaw ?\" ");
INSERT INTO thv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Adih yenna hi : \"Amaɣlol, was dat erriǧeheɣ abedǎh, éd yesiwiy ǎngelos ennét, yeddéw dk, éd hak yilal dɣ ǎsikel ennek baš éd tawyed tǎmǎṭ i arrawin ɣor ǎddunet n ti. ");
INSERT INTO thv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Beššan kud tekkéd ɣor ǎddunet n tawsitin, kud uǧeyen ak éd key ekfin tǎmawaṭ, dédih yefal key éhéḍ wa hi teǧéd\". ");
INSERT INTO thv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","As-d éweḍeɣ ahel waɣ ɣor téṭ ennéɣ : \"Amaɣlol, Messineɣ n messi Ibrahim, inhod a hi telliled dɣ ǎsikelin. ");
INSERT INTO thv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Adih nk deh elléɣ deh ebdadeɣ dat téṭ taɣ, dédih as-d teǧmeḍ tǎmawaṭ, tehraǧet, éd has enneɣ : ”Inhod ahi tekféd heret n aman n elgeḷḷa ennem'. ");
INSERT INTO thv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Adih, kud tenna hi : “Esu key, éd sesweɣ aked imnas ennek', éd elmedeɣ as enta, tǎmǎṭ ta yesinefren Amaɣlol i rurés n messi. ");
INSERT INTO thv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Arweh wr esmendeɣ awal dɣ imanin, Rébéka nɣtah, tosed, tǎsiwer elgeḷḷa éẓér, teras s téṭ, tehraǧ aman. Ennéɣ as : \"Inhod ahi tekféd aman\". ");
INSERT INTO thv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tesres-d elgeḷḷa ennét ta téway hik, tenna hi : \"Esu key, ezzar éd sesweɣ imnas ennek.\" Eswéɣ ezzar tesseswa imnas. ");
INSERT INTO thv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","As tt essesteneɣ mi tt yérewen, tenna : “Nk welt Betuwel ag Naḥor d Milka. » Eǧéɣ as tiǧemt dɣ tinhar d ihebgan dɣ ifassen. ");
INSERT INTO thv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Eneheɣ, erkeƹeɣ dat Amaɣlol, Messineɣ n messi Ibrahim, emmoyéɣ as, édét yesséwey ahi dɣ ǎbǎreqqa wan ellemana, yesséwey ahi s tǎheyawt n eŋŋas n Ibrahim. Ǎddobéɣ éd tt awyeɣ i rurés n Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Dimaɣ, kud teknam sémɣar i messi, teǧam ds ellemana, ennét ahi tn, kud kela, ennet ahi tn. Nk éd semmelelleyeɣ a iǧen. » ");
INSERT INTO thv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Nɣwah awa has ennen Betuwel d Laban : « Amaɣlol, iman ennét, a yesiweggen awén. Wr nelé a hé nen, ula a yehoseyen ula a yexlan. ");
INSERT INTO thv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rébéka nɣtah, datk. Awi tt. Éd tumas hennis n rurés n messik, hund awa yenna Amaɣlol. » ");
INSERT INTO thv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","As yesla akli n Ibrahim awén, yerkeƹ ar ǎmǎḍal dat Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Yekkes-d dɣ kaya ennét oɣnen n aẓref d oɣnen n oreɣ d iselsa, yekfén i Rébéka. Eǧrewen eŋŋas d mas n tǎmawaṭ hereten eknanén tihusay aked entenéḍ. ");
INSERT INTO thv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ḍeffer awén, ekšen, eswen, enta d ǎddunet wi ds eddéwnén ezzar ekken éḍes. As yeffo, enkeren, yenna akli n Ibrahim : « Eyyet ahi éd eqqeleɣ ɣor messi. » ");
INSERT INTO thv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ennen as : « Tǎqqeymét tǎmawaṭ ɣornɣ iheḍan wiyyeḍ, meraw iheḍan arweh ezzar teglét. » ");
INSERT INTO thv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yenna akli : « Wr hi téwéɣem, dimaɣ-d hi yellil Amaɣlol dɣ ǎsikelin, eyyet ahi éd eqqeleɣ ɣor messi. » ");
INSERT INTO thv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Adih ennen : « Neɣrét tǎmawaṭ éd tt nesesten enta » ");
INSERT INTO thv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Eɣren Rébéka essestenen tt : « Teréd éd tegled teddéwed d ales waɣ ? » Tenna : « Éwalla. » ");
INSERT INTO thv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Eɣbelen éd eyyin Rébéka éd tegel teddéw d ta tt tessedwelet. Eglenet eddéwnet d akli n Ibrahim d ǎddunet wi ds eddéwnén. ");
INSERT INTO thv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Émér wan téklé, eǧen i Rébéka elbaraka nsn ennen as : « Kem, tǎmeḍrayt nnɣ umas mas n iǧiman d iǧiman n ǎddunet. Iheyawen ennem awyin iɣermen n ihenǧa ennem ! » ");
INSERT INTO thv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Enkernet Rébéka d téklatén ennét, oɣarnet imnas, eǧlenet elkamnet i ales. Yéwey akli Rébéka, yegla. ");
INSERT INTO thv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Émér héndɣ, yefel-d Isḥaq anu wan Lahay-Roy, yezzaɣ ǎkal n Negeb. ");
INSERT INTO thv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ahel iyyen d igmaḍ s iẓelluwaẓ, yerriǧeh fol iman ennét, yeṭkel éɣef, yemheyyet ǎsewaḍ ennét d imnas wi hin eglenén. ");
INSERT INTO thv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Teṭkel Rébéka ǎsewaḍ ennét aked enta, teney Isḥaq, teres amis ");
INSERT INTO thv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","tessesten akli : « Ma yǎmos ales wén haneɣ-d inkaden dɣ ténéré ? » Yenna : « Awén messi. » Teswer afer udem ennét. ");
INSERT INTO thv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Yenna akli i Isḥaq awa iǧen imda. ");
INSERT INTO thv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yessofeḍ Isḥaq Rébéka s éhen n mas, Sara, yéwey tt, teqqel hennis, yeɣhel tt. Tera taɣ has iǧa, tellil as fol iba n mas. ");
INSERT INTO thv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Yéwey Ibrahim tǎmǎṭ iyyet heḍet isem ennét Qetura. ");
INSERT INTO thv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","yekreh ds arrawen : Zimran, Yoksan, Medan, Madian, Išbak, Šuwwa. ");
INSERT INTO thv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan yérew Saba d Dédan. Meddans n Dédan ǎmosen Ašuriten, Letušiten d Leyumiten. ");
INSERT INTO thv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Meddans n Madian ǎmosen Efa, Efer, Hénok, Abida d Elda. Wiɣ emdan téraw tn Qetura. ");
INSERT INTO thv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Yekfa Ibrahim tela ennét temda i Isḥaq. ");
INSERT INTO thv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A yekka yeddar yekfa a yeǧǧén i arrawen n téḍéḍén ennét ti heḍnén ezzar yesséwey tn s ikallen oggegnén fol Isḥaq, berén ikallen wis d tǧammeḍ tǎfuk. ");
INSERT INTO thv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Awaɣ tezzeǧret n tǎmeddort n Ibrahim, yedder téméḍé n ǎwetay d essahet temerwén d semmos. ");
INSERT INTO thv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ezzar eba Ibrahim, yemmut dɣ tewehré tǎhoseyet, weššar yeyyiwen tǎmeddort, ad yéweḍ édeg ennét ɣor innét. ");
INSERT INTO thv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Enbelent meddans Isḥaq d Ismaƹil dɣ elkǎwri wan Makfela illan dɣ amaḍal n Efron ag Sohar, wan Ḥethit yenimehalen d Mamré. ");
INSERT INTO thv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Yezzenha Ibrahim elkǎwri wéndɣ fol Ḥethiten. Déndɣ ad enbelen Ibrahim d hennis Sara. ");
INSERT INTO thv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ḍeffer iba n Ibrahim, iǧa Yaḷḷah elbaraka i Isḥaq. Yezzaɣ Isḥaq ɣor anu wan Lahay-Roy. ");
INSERT INTO thv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Awah iheyawen n Ismaƹil ag Ibrahim wa térew telmeṣrit Hajar, taklit tan Sara. ");
INSERT INTO thv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Awah ismawen n dg Ismaƹil s émér n tiwit nsn, mn wa yezzaren dɣ dg Ismaƹil, Nebayoṭ, elkamen as Qedar, Adabel, Mibsam, ");
INSERT INTO thv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mišema, Duma, Masa, ");
INSERT INTO thv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Téma, Yetur, Nafiš, Qedma. ");
INSERT INTO thv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nɣwih meddans win meraw d essin n Ismaƹil. Ak iyyen yǎmos amɣar n tawsit, ekfen ismawen nsn i ihenan nsn d tiɣermén ti ezzeɣen. Meraw imenokalen d essin ak iyyen d tawsit ennét. ");
INSERT INTO thv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Awaɣ tezzeǧret n tǎmeddort n Ismaƹil, yedder téméḍé n ǎwetay d keraḍet temerwén d essa. Yéweḍ édeg ennét ɣor innét. ");
INSERT INTO thv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Dg Ismaƹil ezzaɣen dɣ ǎmǎḍal wa yekken mn Hawila ar Šur. Šur yenimehal d Maṣar berén Ašur. Yezzeɣ Ismaƹil édés n ayet-mas emdan. ");
INSERT INTO thv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Awah iheyawen n Isḥaq ag Ibrahim. Ibrahim yérew Isḥaq. ");
INSERT INTO thv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","As yekreh Isḥaq ekkoẓet temerwén n ǎwetay yéwey Rébéka, welt mas n Laban wan Arami, yéraw tt Betuwel, wan Arami n Fadan-Aram. ");
INSERT INTO thv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rébéka tǎmeǧǧaǧrut, yegmey Isḥaq dɣ Amaɣlol telilt i hennis baš éd tekreh arrawen. Yesged as Amaɣlol ezzar tessimrew hennis Rébéka. ");
INSERT INTO thv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kannesen arrawen dɣ tesa. Tenna : « Kud nɣwaɣ, mafol hi iǧarrew awah ? » Tekka éd tsesten Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yenna has Amaɣlol : « Ellanet senatet ellametén dɣ tesa ennem, senatet tawsitén hé emezynén as km-d eǧmeḍnet. Iyyet terna ta heḍet, wa mǎqqeren édt yernu wa meḍreyen. » ");
INSERT INTO thv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Yéweḍ émér n térwa, yemun-d as Rébéka tela éknéwen dɣ tesa ennét. ");
INSERT INTO thv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wa yezzaren ila imẓaden heggaɣnén. Yeṭkar imẓaden fol élem hund ǎbernuh. Iǧa isem Esayu (elmeƹna ennét wan ihǎfélen). ");
INSERT INTO thv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ilkam as eŋŋas. Ǎfus ennét yeṭṭaf azreh n Esayu, iǧa isem Yaƹqub (elmeƹna ennét tefal-d isem wan 'azreh'). Γor tiwit n meddans ila Isḥaq seḍiset temerwén n ǎwetay. ");
INSERT INTO thv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Edwelen. Yǎmos Esayu ǎmagdal mǎqqeren, yegraẓ as ǎɣǎlay dɣ tinariwén. Yaƹqub wadih ales n imnay, yessof tǎɣimit dɣ ihenan. ");
INSERT INTO thv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isḥaq yessof Esayu édét yegraẓ as awad irammes, beššan Rébéka, tadih, tessof Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ahel iyyen ikan Yaƹqub ǎliwa iyyen, yefeld Esayu tinariwén yeḍḍah, ");
INSERT INTO thv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","yenna has i Yaƹqub : « Eḍḍaheɣ. Elluyyeɣeɣ. Zekš ahid. Waydɣ heggeɣen, ekf ahid dɣ ǎliwa waydɣ heggeɣen. » Fol awéndɣ as iǧa isem Edom (elmeƹna ennét Wa-Heggeɣen). ");
INSERT INTO thv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yenna has Yaƹqub : « Zenh ahi tumast n ǎmahwar ahel waɣ. » ");
INSERT INTO thv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yenna Esayu : « Dimaɣ ad éd emmeteɣ, mas i tenfa tumast n ǎmahwar ? » ");
INSERT INTO thv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yenna Yaƹqub : « Ǎheḍ ahidt ezzar. » Yeheḍ Esayu, yezzenhas tumast n ǎmahwar, ");
INSERT INTO thv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","dédih yekfé Yaƹqub tagella d ǎliwa n elɣedes. Yekša Esayu, yeswa ezzar yenker, yegla. Hund awéndɣ as yelka tumast n ǎmahwar. ");
INSERT INTO thv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Temelt menna iyyet heḍet, seléd ta temelet awad t illa Ibrahim. Yekka Isḥaq Gerar ɣor Abimelek ǎmǎnokal n Filistiniten. ");
INSERT INTO thv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yemun-d Amaɣlol yenna has : « Wr tekkéd Maṣar, ɣeyem dɣ ǎkal was ak éd enneɣ. ");
INSERT INTO thv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ezzeɣ dɣ ǎkal wéndɣ, éd dk imhihiɣ, éd hak eǧeɣ elbaraka édét key d iheyawen ennek as eréɣ éd ekfeɣ ikallen wih emdan. Éd setbeteɣ elɣahed wa ǧéri d tik Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Éd erreɣ iheyawen ennek eggeten, ojaden hund itran dɣ aǧenna éd tn ekfeɣ ikallen wih emdan. S térwa ennek, éd eǧeɣ elbaraka i ellametén emdanet dɣ edduniya. ");
INSERT INTO thv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Édét Ibrahim ilkam i awalin, ilkam i eššeréƹeténin d elwaṣyaténin, elqanunenin d tinaḍénin. » ");
INSERT INTO thv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yeqqim Isḥaq dɣ Gerar. ");
INSERT INTO thv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ahel iyyen essestenent kél Gerar fol hennis. Yenna welt mas a tǎmos. Wr yeré éd yen as Rébéka hennis a tǎmos édét yeksoḍ in éd-t eŋɣin dɣ érét ennét édét tǎhosey. ");
INSERT INTO thv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Iha Isḥaq ǎkal a ilan ékét. Ahel iyyen ǎmǎnokal n Filistiniten Abimelek yekyad s eṭṭaga yeney Isḥaq yeḍḍas Rébéka s éḍés wa wr iteǧ ales i welt mas. ");
INSERT INTO thv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Yeɣré yenna has : « Awén, tǎmǎṭ ennek a tǎmos. Mafol tennéd welt mak a tǎmos ? Yenna Isḥaq : « Édét eksoḍeɣ éd emmeteɣ dɣ érét ennét. » ");
INSERT INTO thv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Yenna Abimelek : « Ma hanɣ teǧéd deh ? Deroɣ-d yensa iyyen dɣ win ellamet ɣor hennik, dédih nemda as neḍlam. » ");
INSERT INTO thv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Yenna Abimelek awah i ǎddunet ennét emdan : « I yeḍesen ales d tǎmǎṭ tah, itbat as éd yemmet. » ");
INSERT INTO thv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ǎwetay wéndɣ, yesseŋɣel Isḥaq ezzar yekreh téméḍé n awa yesseŋɣel édét Amaɣlol yekfé elbaraka. ");
INSERT INTO thv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yeqqel ales n ǎnesbeɣor, tela ennét teqqel ti mǎqqeret ak ahel, yeqqel yeɣmar hullan. ");
INSERT INTO thv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yekreh éheré wa ǧezzulen d wa heǧrén d éklan ǎǧǧotnén. Osamen fols Filistiniten. ");
INSERT INTO thv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Enbelen unan wi eɣehen éklan n tis Ibrahim, eṭkeren tn ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Yenna Abimelek i Isḥaq : « Teɣmered hullan, tokeyed anɣ, egel, eflaneɣ » ");
INSERT INTO thv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Yegla Isḥaq, yekka ɣor ǎɣǎher wan Gerar, yeqqim ds. ");
INSERT INTO thv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yeɣeh unan win tis wi enbelen Filistiniten ḍeffer iba n Ibrahim. Yeǧa sn ismawen wi hasn iǧa Ibrahim. ");
INSERT INTO thv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ahel iyyen éklan n Isḥaq eɣehen dɣ ǎɣǎher osen aman wi kewalnén. ");
INSERT INTO thv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Imǎḍanen win Gerar eknesen d win Isḥaq gannén : « Aman ineneɣ. » Yeǧa Isḥaq isem i anu Esek (elmeƹna ennét ǎkennas), édét eknesen fols. ");
INSERT INTO thv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Eɣehen éklan n Isḥaq anu iyyen heḍen eknesen fols aked enta. Igas Isḥaq isem Siṭna (elmeƹna ennét ihenǧa). ");
INSERT INTO thv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Yefel édeg wéndɣ yeɣeh anu iyyen heḍen, waɣ wr eknesen fols. Igas isem Rehobot (elmeƹna ennét édeg wa feroren). Yenna : « Dimaɣ Amaɣlol yekfanɣ édeg wa feroren, yellil anɣ baš éd neɣmer dɣ ǎkal. » ");
INSERT INTO thv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Yefel déndɣ, yekka Beršéba. ");
INSERT INTO thv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yemun as-d Amaɣlol éheḍ wa ilkemen yenna has : « Ǎmoseɣ Messineɣ n tik Ibrahim. Wr teksoḍeḍ édét ǎddéweɣ dk, éd hak eǧeɣ elbaraka . Éd key sekreheɣ iheyawen ǎǧǧotnén dɣ érét n tik aklihin Ibrahim. » ");
INSERT INTO thv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yekna Isḥaq ǎsǎɣres dɣ édeg wéndɣ, yeƹbed isem n Amaɣlol. Yekres ds ihenan ennét, éklan ennét eɣehen anu iyyen heḍen. ");
INSERT INTO thv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Yefeld Abimelek Gerar baš edt yeney, yeddéw d ămidi ennét Ahuzat d Fikol amɣar n jonditen ennét. ");
INSERT INTO thv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yessesten tn Isḥaq : « Mafol tosem id édét teksanem dɣi, testaɣem ahi dɣ ǎkal nwn ? » ");
INSERT INTO thv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ennen as : « Enhanney as Amaɣlol yeddéw dk ezzar nenna éd neǧ elƹahed ǧérénɣ dk. Éd neǧ téséq. ");
INSERT INTO thv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ǎheḍ as wr haneɣ éd teǧéd a yexlan édét wr hak neǧé a yexlan, wr hak neǧé ar awa yehoseyen ; noyyik tegléd dɣ esselamet. Dimaɣ teléd elbaraka n Amaɣlol. » ");
INSERT INTO thv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Yesmegaret tn. Ekšen, eswen. ");
INSERT INTO thv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Eknen iman nsn déndɣ-d yeffo, eǧen elƹahed ǧérésn. Yenna hasn Isḥaq ar essaɣet ezzar eglen dɣ elxér, dɣ esselamet. ");
INSERT INTO thv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ahel héndɣ éklan n Isḥaq osent-in eǧen as isǎlan fol anu wa eqqahen, ennen as : « Nosa aman. » ");
INSERT INTO thv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Yeǧa Isḥaq isem i anu Šiba, fol awéndɣ as iǧa aɣrem isem Beršéba, ar ahel waɣ (elmeƹna ennét anu wan elɣahed). ");
INSERT INTO thv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ila Esayu ekkoẓet temerwén n ǎwetay as yéwey senatet Telḥethitén, Yehudit welt Béri d Basmat welt Elon. ");
INSERT INTO thv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Éweynet-d tesemmé i Isḥaq d Rébéka. ");
INSERT INTO thv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Weššer Isḥaq. Deroɣ-d ǎbas ihanney. Yeɣra rurés wa mǎqqeren Esayu yenna has : « Esayu », yekéwen yenna : « Nk deh. » ");
INSERT INTO thv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Yenna Isḥaq : « Hanneyed as weššareɣ, wr esséneɣ menekét hi yeqqimen i tǎmeddort. ");
INSERT INTO thv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Dimaɣ, awi tǎɣayé d tinassabén. Egel, ek tinariwén, egdel ahid tǎweqqast, ");
INSERT INTO thv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","eken ahi ǎmekši yeẓéden hund wi essimɣereɣ, awi ahit-id. Éd ds ekšeɣ ezzar éd hak eǧeɣ elbaraka imanin animér wr emmuteɣ. » ");
INSERT INTO thv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rébéka tesiǧed, a yekka Isḥaq yesséwel i rurés Esayu. Ezzar yegla Esayu yekka tinariwén éd yegdel tǎwaqqast, éd tt-d yawi. ");
INSERT INTO thv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Tenna Rébéka i rurés Yaƹqub : « Esléɣ i tik iganna i eŋŋak Esayu : ");
INSERT INTO thv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","\"Egel awi ahid isan egdalnén ezzar seŋŋahi tn, eknahi ǎmekši yeknan tǎẓudé. As ekšéɣ éd hak eǧeɣ elbaraka dat Amaɣlol arweh wr hi eba\". ");
INSERT INTO thv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Dimaɣ arrawin, seged ahi d teǧed awa hak éd enneɣ. ");
INSERT INTO thv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ek éheré awid essin éɣeyden ǎhoseynén. Éd dsn ekneɣ ǎmekši yeknan taẓudé hund awast yessimɣer tik. ");
INSERT INTO thv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Awi tn i tik baš éd tn yekš ezzar éd hak yeǧ elbaraka arweh wr yemmut. » ");
INSERT INTO thv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yenna Yaƹqub i mas, Rébéka : « Esayu, eŋŋa, yeṭkar imẓaden, nk kela. ");
INSERT INTO thv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kud abbahin yeḍes ahi, éd yelmed as esseɣleḍeɣt, dédih weggéɣ elbaraka a hi éd yekf, tilɣant ɣas a hi éd yesewer. » ");
INSERT INTO thv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tenna mas : « Éd awyeɣ tilɣant tah fol imanin. Seged ahi ɣas, arrawin, eǧel awid éɣeyden. » ");
INSERT INTO thv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yegla yéwey-d Yaƹqub awas as tenna mas. Tesseŋŋa imekšan eknan taẓudé wi yessimɣer tis. ");
INSERT INTO thv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Téwey iselsa win rurés wa mǎqqeren, wi ellenén ɣors, wi ǎhoseynén dsn, tesselsén i Yaƹqub rurés wa meḍreyen. ");
INSERT INTO thv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Teswert élem n éɣeyden fol ifassen d éri wa wr ewéren imẓaden, ");
INSERT INTO thv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","teǧa dɣ ifassen n rurés Yaƹqub imekšan wi eẓédnen d tagella wi tesseŋŋa. ");
INSERT INTO thv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yosa tis yenna has : « Abba » yenna has Isḥaq : « Nk deh, en ahi ma tǎmosed arrawin. » ");
INSERT INTO thv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yenna Yaƹqub i tis : « Nk Esayu wa mǎqqeren dɣ meddank. Eǧéɣ awas i tennéd. Enker, as-d, ekš awa egdeleɣ ezzar eg ahi elbaraka ennek » ");
INSERT INTO thv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yenna Isḥaq i rurés : « Menék awa teǧéd toséd tǎweqqast hik arraw in ? » Yenna has Yaƹqub : « Amaɣlol, Messineɣ ennek yeǧé fol ǎbǎreqqa hin. » ");
INSERT INTO thv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yenna Isḥaq i Yaƹqub : « Aheẓ. Eréɣ éd key eḍseɣ arrawin baš éd elmedɣ as Esayu a tǎmosed méɣ kela. » ");
INSERT INTO thv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yoheẓ Yaƹqub tis Isḥaq, yeḍest tis ezzar yenna : « Ǎmesli waɣ in Yaƹqub beššan ifassen in Esayu. » ");
INSERT INTO thv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wr yezzey Yaƹqub édét ifassen ennét ewaren tn imẓaden hund win eŋŋas Esayu. Yeǧas elbaraka, ");
INSERT INTO thv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","yessestent arweh : « Key arrawin Esayu a tǎmosed ? » Yenna Yaƹqub : « Ayoh awah nk. » ");
INSERT INTO thv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yenna Isḥaq : « Ekf ahi awa tegdeled arrawin, éd ekšeɣ ezzar éd hak eǧeɣ elbaraka. » Yekfé Yaƹqub ǎmekši, yekša, yekfé elboẓa, yeswa. ");
INSERT INTO thv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ezzar yenna has tis Isḥaq : « Aheẓ mullet ahi, arrawin ! » ");
INSERT INTO thv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yoheẓ Yaƹqub yemmullet as. Yesreɣ Isḥaq aḍu n iselsa ennét ezzar yekfé elbaraka ennét, yenna : « Aḍu n arrawin yola d aḍu n ǎmǎḍal yeborek Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","« É Yaḷḷah a key yekfen aman n aǧenna, d ad yefalen ǎmǎḍal yolaɣen, éred d elboẓa ta teynayet s ǎǧut. ");
INSERT INTO thv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ellametén eqqelnét éklan ennek, tawsitén erkeƹnét datk. Umas amɣar n aɲɲaten ennek, ayet-mak erkeƹnét datk ! Tewar tilɣant wa hak tt yesweren d elbaraka i wa hak tt iǧen. » ");
INSERT INTO thv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","As yesmenda Isḥaq elbaraka ennét, yegmeḍ Yaƹqub. Déndɣ d yefel ɣor tis yefel-d eɲɲas Esayu ǎgǎddil. ");
INSERT INTO thv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Yekna ǎmekši yeẓéden aked enta, yéweyt i tis yenna has : « Enker abba, ekš awa hak d egdeleɣ ezzar éd hi teǧed elbaraka. » ");
INSERT INTO thv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yenna has tis Isḥaq : « Ma tǎmosed key ? » Yenna has : « Nk Esayu wa mǎqqeren dɣ meddanek. » ");
INSERT INTO thv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yeqqim Isḥaq yehikeḍkeḍ hullan ezzar yessestent : « Adih ma yǎmos wa hid yegdelen tǎweqqast, yéwey ahidt-id, ekšeɣt arweh wr-d toséd ? Enta as eǧéɣ elbaraka, éd teqqayem fols. » ");
INSERT INTO thv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","As yesla awa yenna tis, yeǧa Esayu tǎɣerit mǎqqeret, teknat téẓawt. Yenna has i tis : « Inhod ahi teǧéd elbaraka aked nk Abba ! » ");
INSERT INTO thv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yenna Isḥaq : « Eŋŋak yesseɣleḍ ahi. Yéwey elbaraka ennek. » ");
INSERT INTO thv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Yenna Esayu : « Awéndɣ as isem ennét Yaƹqub, édét yekkerres ahi essin iméren, yezzar, yéwey ahi tumast n ǎmahwar, dimaɣ yéwey ahi elbaraka hin ! » Ezzar yenna : « Wr hi yeqqim heret n elbaraka ? » ");
INSERT INTO thv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Awa yenna Isḥaq i Esayu : « Adih, eknéɣ ds amɣar ennek ezzar eknéɣ dɣ ayet-mas emdan éklan ennét. Akféɣt éred d elboẓa. Ula hak eddobéɣ arrawin ! » ");
INSERT INTO thv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Yenna Esayu i tis : « Wr teléd ar elbaraka iyyet ɣas ? Eǧ ahi elbaraka aked nk Abba ! » Yeslef hullan. ");
INSERT INTO thv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Yenna has tis Isḥaq : « Ǎkal ennek illa illehin i ǎmǎḍal wa yoleyen, illehin i tǎlamut ta-d tefalet aǧenna. ");
INSERT INTO thv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tǎmeddort ennek, tǎkoba ennek ; akli n eŋŋak, tumast ennek ; ad tekrehed terna, éd ds-d tekkesed iman ennek. » ");
INSERT INTO thv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yeqqim Esayu yeṭkar dɣ Yaƹqub dɣ érét n elbaraka ta yeǧrew ɣor tis. Yenna dɣ iman ennét : « Abba hin deroɣ éd yemmet. Ahel héndɣ éd eŋɣeɣ eŋŋa Yaƹqub. » ");
INSERT INTO thv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","As telmed Rébéka a was yera éd t yeǧ rurés wa mǎqqeren, teɣra Yaƹqub, rurés wa meḍreyen, tenna has : « Hékey, eŋŋak Esayu yera éd ismaḍ s téneɣé ennek. ");
INSERT INTO thv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Adih, seged ahi dimaɣ arrawin. Enker, ek ɣor eŋŋa Laban dɣ Haran. ");
INSERT INTO thv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Γeyem ɣors ezzeman iyyen, ad hin yeššem ǎweššen wan Esayu, ");
INSERT INTO thv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","as yokey aweššen n eŋŋak, ezzar yettewet key. Dédih éd key-d erreɣ. Mafol éd hi teflim issenen éwn ahel iyyen ? » ");
INSERT INTO thv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Tenna Rébéka i Isḥaq : « Wr hi egreẓen iman dɣ érét n tiḍulénin, Telḥethitén. Kud Yaƹqub aked enta yéwey Telḥethit n ǎkal waɣ, ǎbas hi éd teqqayem terha n iman ! » ");
INSERT INTO thv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yeɣra Isḥaq Yaƹqub yeǧas elbaraka ezzar yenna has : « Wr téweyed tarrawt n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Enker ! As Fadan-Aram ɣor Betuwel, tis n mak. Awi tǎmǎṭ ɣors, iyyet dɣ eššéš n Laban, eŋŋas n mak. ");
INSERT INTO thv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","É Messineɣ wan Ǎneddabu a key yekfen elbaraka, arew, ǎqqel i ǎǧǧotnén baš éd teqqeled tis n ellametén ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yeǧét ak elbaraka tan Ibrahim key d iheyawen ennek baš éd teǧrewed ǎkal waɣ dɣ tezzeɣed tǎmosed ds ǎɣerib, ǎkal wa yekfa Yaḷḷah i Ibrahim. » ");
INSERT INTO thv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yessoka Isḥaq Yaƹqub Fadan-Aram ɣor Laban ag wan Arami Betuwel, eŋŋas n Rébéka mas n Esayu d Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yelmed Esayu as Isḥaq yeǧa elbaraka i Yaƹqub, yesséweyt éd yeǧ éhen dɣ Fadan-Aram. Yelmed as yenna Isḥaq i Yaƹqub in wr éd yawi tarrawt n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yeney Esayu as yelkem Yaƹqub awa has ennen imerawen ennét yekka Fadan-Aram. ");
INSERT INTO thv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Yelmed Esayu as tarrawén n Kenƹan wr egréẓnet i tis. ");
INSERT INTO thv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Yegla yosa Ismaƹil ag Ibrahim, yéwey tarrawt ennét Mahalaṭ welt-mas n Nebayoṭ, yessétét-in fol téḍéḍén ennét. ");
INSERT INTO thv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yefel Yaƹqub Beršéba, yekka berén Haran. ");
INSERT INTO thv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yensa dɣ édeg wa dɣ-t yeɣder ǎgǎḍel n tǎfuk. Yeṭkel aẓẓed yessomet déndɣ. ");
INSERT INTO thv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yehhorǧet, nɣwah awa yehhorǧet : tisekkukal ewarnet ǎmǎḍal, afella yewaḍ aǧenna. Ǎngelosen n Yaḷḷah tawenen errassen. ");
INSERT INTO thv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yebdad Amaɣlol dats iganna as : « Nk Amaɣlol, Messineɣ n abbaten ennek Ibrahim d Isḥaq. Ǎmǎḍal yemda wa fol tenséd éd hakt ekfeɣ key d iheyawen ennek. ");
INSERT INTO thv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Iheyawen ennek éd umasin eǧǧeten hund tǎkessélt. Ǎkal nwn éd yefel aǧmoḍ n tǎfuk, yekka ǎgǎḍel n tǎfuk, afella d ǎteram. Tawsitén tin ǎmǎḍal emdanet éd eǧrewnet elbaraka-hin srk d iheyawen ennek. ");
INSERT INTO thv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nɣwah awa hé eǧeɣ : éd dk idaweɣ, éd key agẓeɣ is tekkéd, éd key-d ǎrreɣ ǎkal waɣ. Wr key éd eyyeɣ, éd eǧeɣ awas ak ennéɣ imda. » ");
INSERT INTO thv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yenker-d Yaƹqub dɣ éḍes ennét, yenna dɣ iman ennét : « Itbat as Amaɣlol illa déɣ beššan wr ss esséneɣ. » ");
INSERT INTO thv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yermeɣ, yenna : « Édeg waɣ yessukseḍ ! Itbat as tǎɣǎhamt n Yaḷḷah d émi n aǧenna ! » ");
INSERT INTO thv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yenker déndɣ-d yeffo. Yéwey aẓẓed wa yessomet, yessebdedt yǎmos as ǎmesenner n awa iǧen enḍéheḍ, yesseŋɣel fols ǎhatim. ");
INSERT INTO thv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Iǧa isem i édeg wéndɣ Beytel (elmeƹna ennét éhen n Yaḷḷah), dat awén isem ennét Luz. ");
INSERT INTO thv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yesmeḍren Yaƹqub, yenna : « Kud Yaḷḷah yeddéw dɣi, yogaẓ ahi fol ǎbǎreqqa hin, ihak ahi a ekšéɣ d a elséɣ, ");
INSERT INTO thv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kud eqqeleɣ-d eddareɣ eslameɣ ɣor abbahin, dédih Amaɣlol éd yeqqel Messineɣin. ");
INSERT INTO thv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Aẓẓed waɣ essebdedeɣ, éd yumas éhen ennek key é Yaḷḷah, éd hak ekkateɣ elɣašer n awa hi éd tekfed. » ");
INSERT INTO thv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yessokel Yaƹqub berén ikallen wi ellenén s awas tǧammeḍ tǎfuk. ");
INSERT INTO thv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ahel iyyen yeney anu dɣ ténéré, yellé ɣors éheré yeganen ar keraḍ iméren, édét ɣor anu wéndɣ ad isas éheré. Aẓẓed wa yeharen émi n anu i mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","As-t yemel éheré yemda, éd yemmukes aẓẓed dɣ émi ezzar éd isu éheré, ḍeffer adih éd yeher animér. ");
INSERT INTO thv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yessesten Yaƹqub imeḍinen : « Imidiwen in, mis d tefalem ? » Ennen as : « Nefal-d Haran. » ");
INSERT INTO thv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","« Tezzayem Laban ag Naḥor ? »- - « Ayoh, nezzayt » ");
INSERT INTO thv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","« Ma hin iǧa ? »- - « Yǎǧoḍey, yellés Rašél, nɣtén-d teglet enta d éheré ennét. » ");
INSERT INTO thv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yenna Yaƹqub : « Ahel heǧret animér, weggéɣ émér n tsedwim éheré, seswet-t ezzar teglim teḍanem animér. » ");
INSERT INTO thv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ennen as : « Wr neddobet éd nesesew éheré a ekken wr-d osén emdan, déndɣ ad nekkes aẓẓed éd nesesew éheré. » ");
INSERT INTO thv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yemisawal dsn Yaƹqub animér as in tosa Rašél enta d éheré n tis, tǎmǎḍint a tǎmos. ");
INSERT INTO thv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","As yeney Yaƹqub Rašél, yellés n Laban, eŋŋas n mas d éheré n Laban, yoheẓ anu, yezzenkeh aẓẓed ezzar yesseswa éheré n xali ennét. ");
INSERT INTO thv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yemullet Yaƹqub i Rašél ezzar yeslef. ");
INSERT INTO thv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yenna has i Rašél in yoŋŋat d tis, térawt Rébéka. Tohel tennen i tis. ");
INSERT INTO thv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","As yesla Laban isǎlan n Yaƹqub, ag welt mas, yohel yenked as, yeṭṭeft dɣ ifassen ennét, yemullet as, yezzogeht tǎɣǎhamt. Iǧa Yaƹqub isǎlan emdan i Laban. ");
INSERT INTO thv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Yenna Laban : « Key yemmukken as in éɣesanin. » Yessokey Yaƹqub tallit temda ɣor Laban. ");
INSERT INTO thv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ahel iyyen yenna Laban i Yaƹqub : « Key in addunetin, beššan weǧǧén fol awéndɣ as éd txaddemed bennan ɣori. En ahi menekét teréd éd key raẓẓemeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ila Laban senatet tarrawén. Ta mǎqqeret isem ennét Léya, ta meḍriyet isem ennét Rašél. ");
INSERT INTO thv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Teṭṭawén tin Léya ǎhoseynet beššan Rašél tekna tihusay hullan. ");
INSERT INTO thv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaƹqub yera Rašél, yenna i Laban : « Éd hak exdemeɣ essa iwetyan baš éd awyeɣ Rašél, ta meḍriyet dɣ tarrawén ennek. » ");
INSERT INTO thv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Yerḍa Laban : « Ǎssofeɣ ekféɣ ak tt key ula i ales iyyen heḍen. Γǎyem ɣori. » ");
INSERT INTO thv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Baš éd yawiy Rašél yexdem Yaƹqub essa iwetyan i Laban. Beššan iwetyan windɣ ǎmosen as hund iheḍan édét yera Rašél. ");
INSERT INTO thv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yenna Yaƹqub i Laban : « Okeyen iwetyan. Ekfi tǎmǎṭin éd tt awyeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Yeɣra Laban ǎddunet emdan win ǎkal i amensu n éhen. ");
INSERT INTO thv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Beššan as yeǧa éheḍ yéwey Laban tarrawt ennét Léya s Yaƹqub, yessokey éheḍ enta d nét. ");
INSERT INTO thv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Yekfa Laban taklit ennét Zilfa éd tumas taklit tan Léya. ");
INSERT INTO thv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","As yeffo, teǧrew Yaƹqub tekunt, ma ihanney deh, Léya i illan dats. Yenna i Laban : « Ma hi teǧéd deh ? Weǧǧén elxedmet ta eǧéɣ ɣork, eǧéɣ tt baš éd awyeɣ Rašél ? Mafol teɣdered ahi ? » ");
INSERT INTO thv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Yenna Laban : « Weǧǧén dɣ iǧiten nnɣ in éd tidaw ta meḍriyet tezzar i ta mǎqqeret. ");
INSERT INTO thv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Semdu essa iheḍan key d ta mǎqqeret. Éd key nekf ta meḍriyet kud texdemed essa iwetyan arweh ɣori. » ");
INSERT INTO thv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yeǧa Yaƹqub awén, yessemda essa iheḍan enta d Léya ezzar yekfé Laban Rašél. ");
INSERT INTO thv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Yekfa Laban taklit ennét Bilha éd tumas taklit tan Rašél. ");
INSERT INTO thv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yessokey Yaƹqub éheḍ enta d Rašél, yeɣhel tt denneg Léya. Yexdem ɣor Laban essa iwetyan heḍnén. ");
INSERT INTO thv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","As yeney Amaɣlol in Léya wr tt wera, yekfét ǎdabu n térwa beššan Rašél yerrét tǎmeǧǧaǧrut. ");
INSERT INTO thv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Tessimrew Léya, tekreh arraw s teǧa isem Ruben (elmeƹna ennét enyet éy). Tenna : « Amaɣlol yeney tǎɣaššimtin, dimaɣ alesin éd hi yeɣhel. » ");
INSERT INTO thv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tessimrew arweh, tekreh arraw iyyen heḍen. Tenna : « Amaɣlol isal as wr etwereɣ ezzar yekf ahi arraw iyyen heḍen. » Teǧas isem Šimƹun (elmeƹna ennét isal). ");
INSERT INTO thv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tessimrew arweh tekreh arraw iyyen heḍen. Tenna : « Dimaɣ alesin éd hi yesemɣer édét ekféɣt keraḍ éyyan. » Teǧa isem i arraw Léwi (elmeƹna ennét yessimɣer). ");
INSERT INTO thv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tessimrew arweh tekreh arraw iyyen heḍen. Tenna : « Dimaɣ éd exmedeɣ Amaɣlol. » Teǧas isem Yehuda (elmeƹna ennét éd yexmed). Ezzar ǎbas tkarreh arrawen. ");
INSERT INTO thv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","As teney Rašél in wr tkerreh arrawen, tosem fol tǎmeqqart ennét. Tenna i Yaƹqub : « Ekf ahi arrawen méɣ éd emmeteɣ. » ");
INSERT INTO thv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yewweššen fols Yaƹqub, yenna : « Teknéd dɣi Yaḷḷah, wa ham ikkasen éd tekrehed arrawen ? » ");
INSERT INTO thv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tenna : « Awi taklitin Bilha baš éd tekreh arrawen fol ifadden-in, éd tn sedweleɣ. Baš aked nk éd ekreheɣ ss arrawen ! » ");
INSERT INTO thv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Adih tekfa taklit ennét i Yaƹqub, yessokey éheḍ ɣors. ");
INSERT INTO thv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tessimrew Bilha, térew éy i Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Tenna Rašél : « Yaḷḷah yeǧa hi elxekum, yesla i awa eréɣ, yekfahi arraw. » Fol awéndɣ as as teǧa isem Dan (elmeƹna ennét yeǧa elxekum). ");
INSERT INTO thv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tessimrew Bilha, taklit tan Rašél animér, térew ey iyyen heḍen i Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tenna Rašél : « Nebbelen nk d tǎmeqqartin, tebbillant teṣṣohét, erbexeɣ. » Teǧa isem i arraw Neftali (elmeƹna ennét tebbillant). ");
INSERT INTO thv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","As teney Léya in ǎbas tkarreh arrawen, téwey taklit ennét Zilfa, tekfét i Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Térew Zilfa, taklit tan Léya éy i Yaƹqub, ");
INSERT INTO thv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","tenna Léya : « Eléɣ ezzeher ! » Teǧas isem Jad (elmeƹna ennét ezzeher). ");
INSERT INTO thv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Térew Zilfa, taklit tan Léya arraw iyyen heḍen i Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tenna Léya : « I tǎdewitin ! Dimaɣ téḍéḍén eddobetnet éd enninet in eddiwéɣ. » Teǧas isem Ašer (elmeƹna ennét tǎdewit). ");
INSERT INTO thv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ahel iyyen, émér wa dɣ yeŋŋa éred, yekka Ruben tinariwén, yosa ellefax. Yéweyt i mas Léya. Adih tenna Rašél i Léya : « Ekf ahi dɣ ellefax n rurém inhod. » ");
INSERT INTO thv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tenna Léya : « Wr ham yegdéh in téweyed alesin ? Teréd éd tawyed aked ellefax n arrawin ! » Tenna Rašél : « Éd yesukey Yaƹqub éheḍ wad iglen ɣorm, semmeskelahit d ellefax wan rurém ! » ");
INSERT INTO thv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","As yeǧa éheḍ yefel-d Yaƹqub iferǧan, tegmeḍ Léya tenked as, tenna : « Γori ad éd tenséd éheḍ waɣ, erẓameɣt s ellefax wan arrawin. » Yessokey Yaƹqub éheḍ wéndɣ ɣors. ");
INSERT INTO thv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Yesla Yaḷḷah i Léya. Tessimrew, tekreh arraw iyyen heḍen i Yaƹqub, wan semmos. ");
INSERT INTO thv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tenna : « Yekfahi Yaḷḷah elkerahin fol-in ekféɣ taklitin i alesin. » Teǧa isem i arraw ennét Isakar (elmeƹna ennét elkera). ");
INSERT INTO thv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Tessimrew Léya arweh térew arraw wan seḍis i Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Tenna : « Yekf ahi Yaḷḷah elkera yehoseyen. Dimaɣ alesin éd hi yekf elhimma édét ekfeɣt seḍis arrawen win eyyan. » Teǧas isem Zabulon (elmeƹna ennét yerrahi édegin). ");
INSERT INTO thv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ḍeffer awén tekreh tarrawt s teǧa isem Dina. ");
INSERT INTO thv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Yesmekta Yaḷḷah Rašél. Yeslas in tera éd tekreh arrawen, yekfét ǎdabu n térwa. ");
INSERT INTO thv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tessimrew, tekreh arraw. Tenna : « Yaḷḷah yekkes ahi tǎɣaššimt. » ");
INSERT INTO thv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Teǧa isem i arraw ennét Yusef (elmeƹna ennét yesséta), tǧanna : « É Amaɣlol, ahi yesséten arraw iyyen heḍen. » ");
INSERT INTO thv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ḍeffer tiwit n Yusef, yenna Yaƹqub i Laban : « Ey ahi éd eqqeleɣ ɣori, dɣ ǎkalin. ");
INSERT INTO thv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ey ahi éd awyeɣ téḍéḍénin d arrawenin. Dɣ érét nsnt as exdemeɣ ɣork, key iman ennek tessaned elxedmet temda ta hak eǧéɣ. » ");
INSERT INTO thv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Yenna Laban : « Inhod, ekreheɣét udem datk. Elmedeɣ in Amaɣlol yeǧa hi elbaraka dɣ érét ennek. ");
INSERT INTO thv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","En ahi menekét teréd éd key erẓemeɣ, éd hak-t ekfeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yenna Yaƹqub : « Tessaned iman ennek, menek awa eǧéɣ exdemeɣ ak baš éd yeqqel éheré awa yǎmos dimaɣ. ");
INSERT INTO thv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Awa enḍerren teléd arweh wr-d oseɣ, yeqqel imaqqeren hullan. Yegak Amaɣlol elbaraka wa fol d oseɣ ɣork. Weǧǧén yéweḍ émér wa fol éd exdemeɣ fol imanin d addunetin ? » ");
INSERT INTO thv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Yenna Laban : « Ma hak éd erẓemeɣ ? » Yenna Yaƹqub : « Ula enḍerren. Kud teǧéd awa hak éd enneɣ eddobéɣ éd hak exdemeɣ animér, éd emhihiɣ d éheré ennek hund engom. ");
INSERT INTO thv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Éd ekyedeɣ éheré ennek imda ahel waɣ éd ẓemmeẓleyeɣ ak ékrer kewelen méɣ ilan titbeqqa meḍreynén méɣ mǎqqornén ; ak téɣsé telat titbeqqa meḍreynén méɣ mǎqqornén : awéndɣ ahe yumasin erreẓamin. ");
INSERT INTO thv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Éd foli yuman elhaq tufat as-d éd tased éd tekyeded erreẓamin. Ulli ti wrn elé titbeqqa meḍreynén méɣ mǎqqornén, ikraren wrn kewal eqqalen dédih iɣefawen ǎmékernén. » ");
INSERT INTO thv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Yenna Laban : « Eɣbaleɣ, eǧ awas tennéd. » ");
INSERT INTO thv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ahel héndɣ, yeẓmeẓley Laban iholaɣen wi elenén ixerréren méɣ titbeqqa, ulli ti elenén titbeqqa meḍreynén méɣ maqqernén méɣ ti teha temellé d ikraren kewalnén. Yekfa iɣefawen wih i meddans. ");
INSERT INTO thv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ezzar yesséwey-tn a yoǧǧeǧen s keraḍ iheḍan n téklé, yoǧǧeǧ fol Yaƹqub. Yaƹqub wadih yemhaha d éheré wa heḍen n Laban. ");
INSERT INTO thv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yéwey Yaƹqub éẓlan n eṣṣefṣaf, ašek wan elluz d ašek iyyen heḍen, yekkes asn elem baš éd umanen ixerréren wi mǎllolnén. ");
INSERT INTO thv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yeǧa eẓlan dɣ édeg wa d isas éheré dag téṭṭawén n wi tibukumnén émér wad sassen. ");
INSERT INTO thv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tibukumen dat eẓlan fol awéndɣ as ulli d tihatten ekrehnet éɣeyden d ikerwaten elanen ixerréren d titbeqqa ti enḍuknén d ti mǎqqornén. ");
INSERT INTO thv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Iẓameẓlay Yaƹqub éɣeyden d ikerwaten, yeznehel-tn d éheré wan Laban wa ilen ixerréren d wa kewelen. Ikan éheré ennét, yeẓimeẓleyt d wan Laban. ");
INSERT INTO thv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Id tibukumen iɣefawen wi eṣṣohetnén, éd yeǧ Yaƹqub éẓlan dat téṭṭawén nsn baš éd ebukumen datsn. ");
INSERT INTO thv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","As ǎmosen iɣefawen wi emleyenén wr iteǧ éẓlan, fol awéndɣ as éheré wa yemleyen in Laban d wa yehoseyen in Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yeɣmer Yaƹqub hullan, yekreh éheré mǎqqeren, éklan d téklatén, imnas d ihéḍan. ");
INSERT INTO thv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yelmed Yaƹqub as dg Laban ǧannén : « Yaƹqub yéwey a ila abbannɣ, awéndɣ as yekreh tela ennét temda. » ");
INSERT INTO thv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yeney as Laban ǎbas ds yeǧa amhihi wan enǧom. ");
INSERT INTO thv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Dédih yenna Amaɣlol i Yaƹqub : « Eqqel ǎkal n abbaten ennek, ɣor ǎddunet ennek. Éd dk idaweɣ. » ");
INSERT INTO thv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yesosin Yaƹqub Rašél d Léya dɣ édeg wa iha éheré ennét, ");
INSERT INTO thv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","yenna hasnt : « Hanneyeɣ as tikmet ǎbas dɣi yemhaha hund enǧom, beššan Messineɣ n abba hin yeddéw dɣi. ");
INSERT INTO thv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kemetéḍ iman-nkmt, tessanmet as exdemeɣ i tikmet s eṣṣahetin temda ; ");
INSERT INTO thv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","beššan yeɣder ahi édét yebbeddel erreẓamin meraw iméren. Beššan Yaḷḷah wrt yoyyé éd hi yeǧ a yexlan. ");
INSERT INTO thv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kud tikmet iganna : \"Iɣefawen wi elenen titbeqqa ti enḍuknen ǎmosen erreẓam ennek\", tuntawén emdanet karrehnet arrawen n titbeqqa enḍuknén. Id yenna : \"Iɣefawen wi elenén iẓelelan ǎmosen erreẓam ennek\", tuntawén emdanet karrehnet arrawen n iẓelelan. ");
INSERT INTO thv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Awén Yaḷḷah a yekkessen éheré wan tikmet, ikfahit. ");
INSERT INTO thv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Émér wad tibukumen iɣefawen, eneyeɣ dɣ teharǧit : éyyan wi toɣarnén tihattén méɣ ulli elan iẓelelan, méɣ titbeqqa meḍreynén méɣ ganén ellunen. ");
INSERT INTO thv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Dɣ teharǧit tah ǎngelos n Yaḷḷah yeɣra hi : \"Yaƹqub !\" Enneɣ as : \"Nk deh.\" ");
INSERT INTO thv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Yenna hi : \"Eṭkel ǎsewaḍ ennek, eniy : Eyyan emdan wi toɣarnén tihatten méɣ ulli elan iẓelelan méɣ titbeqqa d titbeqqa n ellunen. Awén, nɣwéndɣ, édét hanneyeɣ awa hak itaǧ Laban. ");
INSERT INTO thv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nk Yaḷḷah wa hak isseknen iman ennét dɣ Beytel, dɣ édeg wa dɣ tessensed aẓẓed wan ǎmesenner, teǧéd fols ǎhatim, édeg wa dɣ tesmeḍrened. Dimaɣ egel, efel ǎkal waɣ, eqqel ǎkal ennek.\" » ");
INSERT INTO thv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ennenet Rašél d Léya i Yaƹqub : « Waš ǎbas nela heret tǎkasit ɣor amɣar-nnɣ ? ");
INSERT INTO thv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Weǧǧén yekna dnɣ hund weǧǧén tin déɣ, édét yezzenhaneɣ ezzar yekša aẓref-nnɣ ? ");
INSERT INTO thv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dédih, hereten wi yekkes Yaḷḷah dɣ abba-nnɣ eqqalen ineneɣ nekkenetéḍ d arrawen- nnɣ. Eg awas ak yenna Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yenker Yaƹqub yessoɣer meddans d téḍéḍén ennét fol imnas. ");
INSERT INTO thv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Yelwey éheré imda d tela ennét temda ta yekreh dɣ ǎkal n Fadan-Aram, baš éd yeqqel ɣor tis Isḥaq, dɣ ǎkal n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban wadih, a yekka éd yales tihattén ennét, toker Rašél eleṣnam n tis. ");
INSERT INTO thv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaƹqub wadih, yeɣder Laban wan Arami édét yerwel wr has tn yenné. ");
INSERT INTO thv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yeṭkel iman ennét enta d awa ila imda, yejjer eɣǎher wan Elferat ezzar yennehel tidreɣén tin Jelƹad. ");
INSERT INTO thv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ahel wan keraḍ, yehéwel i Laban in Yaƹqub yerwel. ");
INSERT INTO thv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Yéwey Laban ǎddunet n tǎɣǎhamt ennét ezzar yesteɣ Yaƹqub ad iǧa essa iheḍan, yéweḍt dɣ tidreɣén tin Jelƹad. ");
INSERT INTO thv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Beššan dɣ éheḍ, yemun Yaḷḷah i Laban wan Arami dɣ teharǧit, yenna has : « Hékey éd tenned a yexlan i Yaƹqub ! » ");
INSERT INTO thv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","As yéweḍ Laban Yaƹqub, waɣ yekras éhen ennét dɣ tidreɣén n Jelƹad. Ǎddunet win Laban ekresen ihenan nsn aked entenéḍ. ");
INSERT INTO thv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Yeɣra Laban Yaƹqub : « Ma teǧéd deh ? Teɣdered ahi, téweyed tarrawenin hund a termased dɣ enmeŋɣi. ");
INSERT INTO thv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mafol terweled teffared foli, teɣdared ahi ? Kud tenned ahi tn, éd key sufḍɣ s isuhaɣ ǎhoseynén d gengaten d imẓad. ");
INSERT INTO thv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Beššan key wr hi toyyéd aked éd emmulluɣ i tarrawénin d iheyawenin. Tegléd hund éré wrn ilé tayetté. ");
INSERT INTO thv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Eddobéɣ éd hak eǧeɣ taxellawt beššan Messineɣ wan tik yenna hi enḍéhed : « Hékey éd tenned a yexlan i Yaƹqub ! » ");
INSERT INTO thv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Eywah, dimaɣ-d tegléd édét teroreded éd teqqeled ɣor tik. Beššan mafol tokered ahi messineɣenin ? » ");
INSERT INTO thv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yenna Yaƹqub i Laban : « Ermeɣeɣ ennéɣ dɣ imanin : \"Wr eréɣ éd dɣi yekkes eššéš\". ");
INSERT INTO thv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Dimaɣ kud toséd messineɣen ennek ɣor iyyen dɣ addunetin, wéndɣ wr éd yedder. Dat aɲɲaten-nnɣ, egmey awa illen ɣori d tawyed awa tléd. » Yaƹqub wr yeɣél Rašél téway elaṣnam n ǎddunet ennét. ");
INSERT INTO thv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Yegmey Laban dɣ ihenan n Yaƹqub, n Léya d téklatén senatet beššan ula yosa. As-d yeǧmeḍ éhen n Léya, yeǧǧeh dɣ wan Rašél. ");
INSERT INTO thv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rašél a yéwayen eleṣnam, teǧén dag tebeyut ezzar teqqim folsn. Yeǧmey Laban dɣ éhen imda ula yosa. ");
INSERT INTO thv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Tenna Rašél i tis : « Wr tewweššened, abbahin, kud wr nekkereɣ datk, nk tosa hid ta-d taset téḍéḍén. » Yegmey Laban beššan wr yosé eleṣnam. ");
INSERT INTO thv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yewweššen Yaƹqub ezzar yenna i Laban : « Ma eɣhadɣ ? Ma yǎmos ǎbekkaḍin as i testaɣed ? ");
INSERT INTO thv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Teǧmeyed dɣ kayatenin emdan. Toséd ad yefalen ɣork ? Sekent i ayet ma d ayet-mak éd tt efrun ǧérénɣ. ");
INSERT INTO thv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Essokeyeɣ senatet temerwén n ǎwetay ɣork, wr esserteknet tihattén ennek ula ulli ennek, awéɣ wr ekšéɣ ékrer dɣ éheré ennek. ");
INSERT INTO thv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Awéɣ wr hak d éweyeɣ éɣef ekšan iweɣsan, imanin a hak d itarren awa hak yemmekšen. Teǧmayed dɣi iɣefawen wi ǎmékernén dɣ ahel méɣ wi ǎmékernén dɣ éheḍ. ");
INSERT INTO thv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tekšahi tuksé s ahel, yekšahi esǎméḍ s éheḍ, éḍes yefel téṭṭawenin. ");
INSERT INTO thv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Aɣbeleɣ éd sukyeɣ senatet temerwén n ǎwetay ɣork : exdemeɣ ɣork meraw iwetyan d ekkoẓ baš éd awyeɣ tarrawén ennek senatet d seḍis iwetyan baš éd ekreheɣ éheré beššan key tebbedeled erreẓamin meraw iméren. ");
INSERT INTO thv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Messineɣ n abbahin, Messineɣ n Ibrahim, Messineɣ wa yessérmeɣen abbahin Isḥaq, kud wr hi yellil éd hi tsegled sl ula enḍerren. Beššan Messineɣ ihanney tǎɣaššimtin d elxedmet ta teṣṣohet eǧéɣ, enḍéhed yessekna as eẓẓaleɣ. » ");
INSERT INTO thv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yenna Laban i Yaƹqub : « Tarrawén tiɣ tihin, arrawen nsnt innu, éheré innu d awa thanneyed imda innu. Beššan ma hé egeɣ ahel waɣ i tarrawénin d arrawen nsnt ? ");
INSERT INTO thv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Dimaɣ neǧét téséq ǧérénɣ, nk d key, tešhadet ǧéri dk. » ");
INSERT INTO thv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yessebded Yaƹqub aẓẓed, yǎmosen ǎmesenner. ");
INSERT INTO thv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ezzar yenna i ǎddunet ennét éd ekkemun éẓẓeden. Ekkemen tn ezzar eknen ssn tǎdebbont. Ezzar ekšen emdan fol tǎdebbont taɣ. ");
INSERT INTO thv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Iǧa Laban isem i édeg waɣ Yejer Sahduta, Yaƹqub wadih iǧas isem Jelƹid. ");
INSERT INTO thv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Yenna Laban : « Tǎdebbont taɣ tešhad ǧérénɣ. » Awéndɣ as teǧa isem Jelƹid (elmeƹna ennét tǎdebbont tan ǎmašhad). ");
INSERT INTO thv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Teǧa aked isem Miṣfa (elmeƹna ennét édeg wan wa isweḍen). Édét yenna Laban : « Amaɣlol a folnɣ yeswaḍen nk d key, émér wad ǎbas nenimenay. » ");
INSERT INTO thv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kud teǧéd a yexlan i tarrawénin, kud téweyed téḍéḍén tiyyeḍ heḍnén, uksaḍ ɣas, weggéɣ ales ɣas a yešhaden, awén Yaḷḷah iman ennét a yešhaden ǧérénɣ. » ");
INSERT INTO thv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ezzar yenna Laban i Yaƹqub : « Ekid tǎdebbont n éẓẓeden, ǎmesenner wa eǧéɣ ǧérénɣ. ");
INSERT INTO thv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tǎdebbont n éẓẓeden taɣ tǎmos ǧérénɣ ǎmašhad : wr tt éd akyeɣ berén ennek eléɣ erk ettexmam, aked key wr tt éd takyed berén in teléd erk ettexmam, tǎdebbont taɣ, ǎmesenner waɣ. ");
INSERT INTO thv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Messineɣ wan Ibrahim, Messineɣ wan Naḥor, Messineɣ n abba nsn yǎmos elqadi ǧérénɣ. » Ezzar yeheḍ Yaƹqub s wa yessérmeɣen tis Isḥaq. ");
INSERT INTO thv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yeǧa Yaƹqub takuté fol tadreq ezzar yeɣra ayet-mas éd ekšin tagella. Ekšen, ensen fol tadreq. ");
INSERT INTO thv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Déndɣ-d yeffo, yenker Laban, yemmullet i tarrawén ennét d iheyawen ennét, yeǧasn elbaraka. Ezzar yegla yeqqel ǎkal ennét. ");
INSERT INTO thv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaƹqub, wadih yokey ǎbǎreqqa ennét, osent-in ǎngelosen n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","As tn yeney, yenna : « Awah ǎmezzaɣ n Yaḷḷah ! » Yeǧa isem i édeg wéndɣ Maḥanayim (elmeƹna ennét essin imezzaɣen). ");
INSERT INTO thv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yesséwey Yaƹqub inemmahalen dats i eŋŋas Esayu dɣ Seƹir ihan ǎkal n Edom. ");
INSERT INTO thv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Yenna hasn awah : « Siwlet i messi Esayu hund awah : \"Nɣwah awa hak iganna akli ennek Yaƹqub : 'ezzeɣeɣ ɣor Laban, ǎmoseɣ ǎɣǎrib, ehléɣin ar dimaɣ. ");
INSERT INTO thv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ekreheɣ éswan d ihéḍan d éheré d éklan d tiklatén. Esséweyeɣ ǎmahal i messi, baš éd ekreheɣ udem dats'\". » ");
INSERT INTO thv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Eqqelen-d inemmahalen ɣor Yaƹqub ennen as : « Nosa eŋŋak Esayu. Yeglad, yenkad ak yeddéw d ekkoẓet temaḍ n ǎwadem. » ");
INSERT INTO thv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yermeɣ Yaƹqub hullan, yeksoḍ. Yezmezzey s essin henddegen ǎddunet wi ds eddéwnén d éheré wa ǧezzulen d wa heǧrén d imnas. ");
INSERT INTO thv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yenna dɣ iman ennét : « Kud Esayu yerjem iyyen dɣ ihenan, wa heḍen éd yennej. » ");
INSERT INTO thv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yenna Yaƹqub : « Messineɣ n ti Ibrahim d Messineɣ n ti Isḥaq, é Amaɣlol wa hi yennen : \"Ǎqqel ǎkal ennek ɣor ǎddunet ennek, éd hak egeɣ a yolaɣen !\" ");
INSERT INTO thv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Wr ogdéɣ d ellemana d tǎhanint tihi tessekned i nk, wan akli ennét. Wr eléɣ ar taboritin baš éd ejjereɣ aman n ǎɣǎher wan Elurdun, nɣtah, dimaɣ ǎqqeleɣ-d eddéweɣ d ǎddunet ogdanén d essin imezzaɣen. ");
INSERT INTO thv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Inhod ahi tennejjed fol eŋŋa, nejjahi fol Esayu ! Édét eksoḍeɣ éd-d yas éd hi yeŋɣ, éd yeŋɣ anna d arrawen. ");
INSERT INTO thv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Beššan key a yennen : \"Itbat as éd hak eǧeɣ a yolaɣen, éd key ekfeɣ iheyawen ogdanén d takesselt ta ɣor ǧeréw, ad ǎbas neddobet ǎseḍen nsn s ǎǧut nsn\". » ");
INSERT INTO thv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yessokey Yaƹqub éheḍ dɣ édeg wéndɣ. Dɣ awa ila, yeǧmey a yekfa i eŋŋas Esayu : ");
INSERT INTO thv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","senatet temaḍ n téɣsé d senatet temerwén n eholaɣ, senatet temaḍ n téhelé d senatet temerwén n ékrer, ");
INSERT INTO thv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","keraḍet temerwén n teḷḷemen sankasnén entenetéḍ d meddansnet, ekkoẓet temerwén n tésut d meraw éswan, senatet temerwén n teyhéṭ d meraw ihéḍan. ");
INSERT INTO thv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yekfén i éklan ennét, ak éheré ɣas ennét ezzar yenna i éklan ennét : « Akyet dati, eyyet édeg feroren ǧér ak éheré. » ");
INSERT INTO thv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Wa yezzaren yenna has : « As dk yemheyyet eɲɲa Esayu yessesten key : \"Mi key ilen ? Mis tekked ? Mi ilen éheré wa datk ?\" ");
INSERT INTO thv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","En as : \"Awaɣ yesséweyt id akli ennek Yaƹqub i messis Esayu, enta yelkam anɣ-d\". » ");
INSERT INTO thv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yenna awén aked i wan essin dɣ éklan ennét, d wan keraḍ d emdan wi hasn elkamnén eḍanen éheré. Yenna hasn : « Nɣwah awa hé tennim i Esayu as ds temheyyém, ");
INSERT INTO thv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","éd tennim : \"Adih, aked Yaƹqub, akli ennek, yelkam anɣ-d\". » Yenna dɣ iman ennét : « Édt ethennuɣ s awadt éd ekfeɣ yezzar ahi, ezzar édt-in aseɣ, tiǧenén dédih éd hi yerrexeb. » ");
INSERT INTO thv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yegla éheré waɣ yezzar, éheḍ héndɣ enta yeqqim dɣ ihenan. ");
INSERT INTO thv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Éheḍ héndɣ yenker, yéwey téḍéḍén ennét senatet, téklatén ennét senatet d arrawen ennét meraw d iyyen, yokey dɣ édeg wa dɣ wr élwén aman dɣ téǧert tan Yaboq. ");
INSERT INTO thv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yessokey tn aman, yessokey tela ennét temda. ");
INSERT INTO thv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yeqqim Yaƹqub ɣas ennét. Yebbillen ds iyyen ar ihokhaken. ");
INSERT INTO thv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ihanney in wrt éd yernu, yewet adih ɣor ǎɣezzug, ǎɣezzug wan Yaƹqub yemmezzey. ");
INSERT INTO thv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yenna : « Ey ahi édét ihokhaken éweḍen. » Beššan yenna has Yaƹqub : « Wr key éd eyyeɣ a tekked wr hi teǧéd elbaraka. » ");
INSERT INTO thv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yessestent : « Isem ennek ? » Yenna : « Yaƹqub. » ");
INSERT INTO thv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yenna daɣ : « Ǎbas ak itahawal Yaƹqub, dimaɣ éd hak itahawal Israyil (elmeƹna ennét yebbillen d Yaḷḷah) édét tebbillened d Yaḷḷah d médden, ternéd. » ");
INSERT INTO thv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yenna Yaƹqub : « Inhod ahi tennéd isem ennek. », beššan yenna has : « Mafol sastaned ahi d isemin ? » Déndɣ a has yeǧa elbaraka. ");
INSERT INTO thv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yeǧa Yaƹqub isem i édeg wéndɣ Fanyel (elmeƹna ennét udem n Messineɣ), yenna : « Édét eneyeɣ Yaḷḷah udem d udem, beššan eqqimeɣ eddareɣ. » ");
INSERT INTO thv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","As yeffo, yokey Fanyel yesiketew dɣ érét n ǎɣezzug. ");
INSERT INTO thv_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Fol awéndɣ as Israyliten wr tettin ar dimaɣ aẓar d isan wi illenén ɣor ǎɣezzug, édét yewet Yaƹqub déndɣ fol aẓar. ");
INSERT INTO thv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yeṭkel Yaƹqub ǎsewaḍ, ma ihanney deh ? Ihanney Esayu yeddéw d ekkoẓet temaḍ n ales. Yeẓun arrawen ǧér Léya d Rašél d téklatén senatet. ");
INSERT INTO thv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yeǧa dɣ éɣef téklatén d arrawen nsnt, ḍeffersnt Léya d arrawen ennét, ḍeffer s arweh yeǧa Rašél d Yusef. ");
INSERT INTO thv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Enta Yemel dɣ éɣef datsn emdan. Yerkeƹ ar essa iméren a yekka itaweḍin ɣor eŋŋas. ");
INSERT INTO thv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yohel ss Esayu, yenḍew iman ennét dɣ éri ennét, yeṭṭeft dɣ ifassen ennét, yemmullet as. Eslefen issenen ésn. ");
INSERT INTO thv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Yeṭkel Esayu ǎsǎwaḍ, yeney téḍéḍén d arrawen, yessesten : « Ma ǎmosen ǎddunet wih dk eddéwnen ? » Yenna Yaƹqub : « Awén arrawen wi yekfa Yaḷḷah dɣ tǎhanint ennét i akli ennek. » ");
INSERT INTO thv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Oheẓnet téklatén entenetéḍ d meddansnet, erkeƹen. ");
INSERT INTO thv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ḍeffer sn oheẓen in Léya d meddans, erkeƹen aked entenéḍ, elkamen asn Yusef d Rašél erkeƹen aked entenéḍ. ");
INSERT INTO thv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Yessesten Esayu : « Mas teboked éd teǧed s ǎmezzaɣ imda wad emheyyeɣ ? » Yenna has Yaƹqub : « Egmayeɣ éd ekreheɣ udem datk, sidi. » ");
INSERT INTO thv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Yenna Esayu : « Eléɣ tela hi tegdahet, ageẓ awa teléd, eŋŋa. » ");
INSERT INTO thv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yenna Yaƹqub : « Kela, inhod. Kud eǧraweɣ udem datk, awi awa key ekféɣ. Amhiyyu hin dk yola d amhiyyu d Yaḷḷah, édét terrexeb ahi. ");
INSERT INTO thv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Inhod ad téweyed awa hak d eweyeɣ édét Yaḷḷah dɣ tǎhanint ennét, yekfahi a yeǧǧén, eléɣ awa eréɣ imda. » Yoded ad yeɣbel Esayu awa yeǧrew. ");
INSERT INTO thv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Yenna Esayu : « Endawet ! Éd hak izareɣ. » ");
INSERT INTO thv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Beššan yenna Yaƹqub : « Tessaned as arrawen wr eṣṣohén, ilzam ahi aked éd emhihiɣ d tihattén d ulli d tisista ti sankasnén : kud oẓernet ahel iyyen, éheré imda éd yemmet. ");
INSERT INTO thv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Egel tezzared, eɲɲa, izarahi, nk wan akli ennek, éd egleɣ sollan eddéweɣ d éheré was elkameɣ d arrawen a hin awḍeɣ ɣork dɣ ǎkal n Seƹir. » ");
INSERT INTO thv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Yenna Esayu : « Éd hak eyyeɣ ǎddunet wiyyeḍ éd key sufḍin ! » Beššan yenna has Yaƹqub : « Mafol awén ? Inhod, sidi, ekreheɣét udem datk ɣas ! » ");
INSERT INTO thv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Yegla Esayu ahel héndɣ yekka Seƹir. ");
INSERT INTO thv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Beššan Yaƹqub wadih, yekka Sukut, yekna tǎɣǎhamt i iman ennét d ikebran ǎmosnén ibakken i éheré ennét, fol awéndɣ as iǧa édeg wéndɣ isem Sukut (elmeƹna ennét ikebran). ");
INSERT INTO thv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","As-d yefel Fadan-Aram, yéweḍ Yaƹqub, yeddar yeslam, aɣrem wan Šakim dɣ ǎkal n Kenƹan, yekres ihenan ennét ɣor aɣrem. ");
INSERT INTO thv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yezzenha s téméḍé n erriyalen n aẓref, i dg Ḥamor, tis n Šakim, édeg iyyen dɣ yekres éhen ennét. ");
INSERT INTO thv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yekna ǎsǎɣres iyyen s iǧa isem El-Ilaha-Israyil (elmeƹna ennét Yaḷḷah enta Messineɣ n Israyil). ");
INSERT INTO thv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ahel iyyen tekka, Dina, yellés n Yaƹqub d Léya, ɣor timawaḍén tin ǎkal. ");
INSERT INTO thv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Yeney tt Šakim ag amɣar n ǎkal, Ḥamor wan Hiwit, yéwey tt, yenmensa ds s tǎkeréṭ, yohaɣ tt. ");
INSERT INTO thv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ezzar teggǎh Dina welt Yaƹqub iman n Šakim, yeɣhel tǎmawaṭ, yesséwel as ad yegreẓ i ul ennét. ");
INSERT INTO thv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Yenna i tis Ḥamor : « Eǧmi ahi tǎmawaṭ taɣ, eréɣ éd tt awyeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yelmed Yaƹqub elɣib wa iweren yellés Dina ɣor Šakim. Edét meddans eḍanen, wr yenné ula enḍerren ad eqqelen. ");
INSERT INTO thv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Yosa Ḥamor tis n Šakim ɣor Yaƹqub baš éd has isiwel. ");
INSERT INTO thv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","As-d eqqelen dg Yaƹqub, eggehen tn isǎlan. Ǎkkusen, ewweššenen hullan édét Šakim iǧa alhin fol welt Yaƹqub, awén wr iteweǧǧi ɣor kél Israyil. ");
INSERT INTO thv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Adih yenna hasn Ḥamor : « Ruré Šakim ikna tera i talyaḍt nwn hullan. Ekfet as tt, inhodet, éd tt yawi. ");
INSERT INTO thv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Erteyet dnɣ : ekfet anɣ tarrawén nwn d tawyim tinenɣ. ");
INSERT INTO thv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Éd tezzeɣem édés nnɣ. Éd hawen yemar ǎkal, teddobém éd ds tezzeɣem, éd ds teknim eššeɣlen nwn, éd ds tekrehim tela. » ");
INSERT INTO thv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Yosin Šakim iman ennét ayet-mas n tǎmawaṭ d tis, yenna hasn : « Ekreheɣét udem ɣorwen ! Eddobeɣ éd kewen ekfeɣ awa terem. ");
INSERT INTO thv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Teddobem éd dɣi tegmeyem taggalt mǎqqeret d eddelil mǎqqeren. Éd kewen ekfeɣ awa dɣi tegmeyem, ekfet ahi tǎmawaṭ ɣas éd tt awyeɣ. » ");
INSERT INTO thv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ǎjéweben dg Yaƹqub s tittéwen i Šakim d tis Ḥamor, édét Šakim iǧa elɣib fol welt masn Dina. ");
INSERT INTO thv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Esséwelen asn hund awah : « Wr neddobet éd nekf tarrawt nnɣ i ales wrn yezzeyyen, éd yumas fol nɣ elɣar. ");
INSERT INTO thv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Wr neddobet éd hawen nerḍu ar s ǎšerreḍ iyyen : ilzam in médden nwn emdan éd ezzeyenen hund nekkenéḍ. ");
INSERT INTO thv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dédih éd kewen nekf tarrawén nnɣ, éd nawiy ti-nwn. Éd nezzeɣ édés nwn, éd numas ellamet iyyet. ");
INSERT INTO thv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Beššan kud wr terḍém s ǎziyyen dédih éd nawiy tǎmeḍrayt nnɣ ezzar éd negel. » ");
INSERT INTO thv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Awal nsn yegréẓ i Ḥamor d rurés. ");
INSERT INTO thv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Yerored ǎmawaḍ éd yeǧ awa yehéwelen, édét yera welt Yaƹqub hullan. Enta yamos ales s lakkemen ǎddunet ennét, ewweqqerent. ");
INSERT INTO thv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Emelen Ḥamor d rurés Šakim awad timheyyin ǎddunet dɣ émi n aɣrem, ennen asn : ");
INSERT INTO thv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","« Médden wiɣ wr haneɣ erén ar elɣafyet. Addoben éd emlin dɣ ǎkal nnɣ, éd ds exdemen, édét ǎkal imaqqeren ! Neddobet éd nawiy tarrawén nsn, eddoben éd awyin ti-nnɣ. ");
INSERT INTO thv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Eɣbelen éd ezzeɣen édés nnɣ, éd numas ellamet iyyet, beššan awén ila ašeraḍ iyyen : ilzam dɣ médden nnɣ éd nezzeyen hund entenéḍ. ");
INSERT INTO thv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kud neɣbel asn, éd d asin éd ezzeɣen édés nnɣ, dédih éheré nsn d tela nsn éd eqqelen i-nnɣ. » ");
INSERT INTO thv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Emdan wi ellenén déndɣ eɣbelen awa ennen Ḥamor d rurés Šakim, médden emdan win aɣrem ezzeyenen. Médden emdan wi okeynén émi n aɣrem ezzeyyenen. ");
INSERT INTO thv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ahel wan keraḍ, médden oẓaren arweh, eǧǧehen essin dɣ dg Yaƹqub aɣrem, Šimƹun d Léwi ayet-mas n Dina, ak iyyen d tǎkoba ennét, eɣderen médden, eŋɣen tn emdan, ");
INSERT INTO thv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","aked amɣar nsn Ḥamor d rurés Šakim. As efelen tǎɣǎhamt tan Šakim éweyen Dina. ");
INSERT INTO thv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Osen-d meddans n Yaƹqub éweyen awa iweren timeɣsay, éweyen awa ihen aɣrem, dɣ érét n welt masn ta iwer elɣib. ");
INSERT INTO thv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Éweyen éheré wa ǧezzulen d wa heǧrén d iheḍan, awa ihen aɣrem d ténéré imda. ");
INSERT INTO thv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Éweyen tela temda, éweyen arrawen d téḍéḍén, éweyen awa ihen téɣehmén imda. ");
INSERT INTO thv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Dédih yenna Yaƹqub i Šimƹun d Léwi : « Teǧem foli elɣib, terrem ahi éré yexlan fol udmawen n ǎddunet win ǎkal, Kerƹaniten d Fariziten. Ǎddunet wih éd ertiyen foli éd hi eŋɣin nk d addunetin, nk wr eléɣ médden eǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ennen as aŋŋaten : « Ales wah wr yeddobet éd yeǧ i tǎmeḍrayt nnɣ hund awa itaweǧǧén i tǎmasrayt. » ");
INSERT INTO thv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Yenna Yaḷḷah i Yaƹqub : « Ebded, ek Beytel, ɣǎyem ds. Eken déndɣ ǎsǎɣres i Messineɣ wa hak-d yemunen émér wa d terweled i eŋŋak Esayu. ");
INSERT INTO thv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yenna Yaƹqub i ǎddunet n tǎɣǎhamt ennét d ǎddunet wi ds eddéwnén emdan : « Ekkeset elaṣnam n messineɣen win ǎɣerib, ellanen ǧéréwn. Ṭehheret iman nwn, beddelet iselsa nwn. ");
INSERT INTO thv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Enkeret ! Éd nk Beytel, éd ekneɣ ǎsǎɣres i Messineɣ wa hi yellilen ahel wad eǧǧeheɣ mihi. Yeddéw dɣi dɣ ǎbǎreqqa wa dɣ erriǧeheɣ. » ");
INSERT INTO thv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ekfen messineɣen win ǎɣerib, wi eṭṭefen dɣ ifassen nsn d tiẓabaten ti ehenén timeẓẓuǧén nsn. Yenbel tn Yaƹqub dag ašek wa mǎqqeren illen ɣor Šakim. ");
INSERT INTO thv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Efelen édeg wéndɣ ezzar tosin tukseḍa n Yaḷḷah fol éɣermen wi ellenen déndɣ : wrt illé i yeḍrenen Yaƹqub d winnét. ");
INSERT INTO thv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yéweḍ Yaƹqub d ǎddunet wi ds eddéwnén Luz, was itahawal Beytel, illa dɣ ǎkal wan Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yekna ǎsǎɣres, yeǧa isem i édeg wéndɣ El-Beytel (elmeƹna ennét Messineɣ wan Beytel), édét dɣ édeg wéndɣ a has-in yemun Yaḷḷah émér wa fol yerwel fol eɲɲas. ");
INSERT INTO thv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Eba Débora, ta tessedwelet Rébéka, tenbel dag Beytel, dag ašek biluṭ was iǧa Yaƹqub isem biluṭ wan tǎseloft. » ");
INSERT INTO thv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yemun Yaḷḷah i Yaƹqub arweh, émér wad-d yefel Fadan-Aram, yeǧas elbaraka. ");
INSERT INTO thv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Yenna Yaḷḷah : « Isem ennek Yaƹqub, beššan ǎbas ak itahawal Yaƹqub, isem ennek yeqqel Israyil. » Fol awéndɣ ast yeɣra s Israyil. ");
INSERT INTO thv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yenna has Yaḷḷah : « Nk Messineɣ wan Ǎneddabu. Aruw, umas ǎǧut, ellametén eǧǧotnén a key-d éd eflin, imenokalen a key-d éd eǧmeḍen. ");
INSERT INTO thv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ǎkal wa ekfeɣ i Ibrahim d Isḥaq, ekfeɣ akt, édt ekfeɣ i iheyawen ennek ḍefferek. » ");
INSERT INTO thv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Yefel Yaḷḷah édeg wa dɣ has yesséwel. ");
INSERT INTO thv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yekna Yaƹqub ǎmesenner dɣ édeg wa dɣ has yesséwel Yaḷḷah, ǎmesenner yeknan s ikedewen, yeǧa fols takuté teknat dɣ awa itameswen ezzar yesseŋɣel fols ǎhatim. ");
INSERT INTO thv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yeǧa Yaƹqub isem wan Beytel i édeg wa dɣ yemsawal d Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Efelen Beytel. Oggegen Efrata as térew Rašél, térwa ennét teṣṣohet hullan. ");
INSERT INTO thv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","A tekka terhan s terwa ennét, tenna has tǎmǎṭ ta has tellilet s terwa : « Wr tekṣoḍed, édét ey iyyen heḍen a tekrehed. » ");
INSERT INTO thv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Dɣ unfas ennét wa yehreyen, émér wéndɣ s tebok éd temmet, teǧas isem Ben-Oni (elmeƹna ennét ag toẓẓértin) beššan tis iǧas isem Benyamin (elmeƹna ennét ag aɣil). ");
INSERT INTO thv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Eba Rašél, tetwenbal dɣ ǎbǎreqqa wan Efrata, dɣ édeg wa iǧen isem Beytlaḥm. ");
INSERT INTO thv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yessebded Yaƹqub aẓẓed fol aẓekka ennét : ar dimaɣ illé aẓẓed n aẓekka wan Rašél. ");
INSERT INTO thv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yefel Israyil édeg wéndɣ, yekres éhen ennét illehin i Mijdal-Γedr. ");
INSERT INTO thv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","A yekka yezzaɣ Israyil ǎkal wéndɣ, yekka Ruben Bilha, tǎmǎṭ iyyet n tis, yelmed ss Israyil. Dg Yaƹqub ǎmosen meraw d essin : ");
INSERT INTO thv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Dg Léya : Ruben, wa yezzaren dɣ dg Yaƹqub, Šimƹun, Léwi, Yehuda, Isakar, Zabulon. ");
INSERT INTO thv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Dg Rašél : Yusef d Benyamin. ");
INSERT INTO thv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Dg Bilha, taklit tan Rašél : Dan d Neftali. ");
INSERT INTO thv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Dg Zilfa, taklit tan Léya : Jad d Ašer. Awén dg Yaƹqub wi ewenén dɣ Fadan-Aram. ");
INSERT INTO thv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yéweḍ Yaƹqub ɣor tis Isḥaq dɣ Mamré, dɣ Qiryat-Arba, enta Hebron, édeg wa dɣ ezzeɣen Ibrahim d Isḥaq ǎmosen iɣeriben. ");
INSERT INTO thv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yedder Isḥaq téméḍé n ǎwetay d ettamet temerwén. ");
INSERT INTO thv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Yemmut. Yéweḍ ɣor innet, weššar, yekna tǎmeddort. Enbelent meddans Esayu d Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Awah iheyawen n Esayu wa yǎmosen Edom. ");
INSERT INTO thv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Yéwey Esayu téḍéḍén n Kenƹan : Ada welt Elon wan Ḥethit, Oholibama welt Ana, welt Sibɣon wan Hiwit, ");
INSERT INTO thv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","d Basmat welt Ismaƹil, welt mas n Nebayoṭ. ");
INSERT INTO thv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Yekreh Esayu dɣ Ada, Elifaz d Basmat térew as Raƹuyil. ");
INSERT INTO thv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama tekreh Yeƹuš, Yelam, Qoraḥ. Awén dg Esayu wi yekreh dɣ ǎkal n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Yéwey Esayu téḍéḍén ennét, meddans d eššéš, d ǎddunet win tǎɣǎhamt ennét, éheré ennét d awa yezzenha imda dɣ ǎkal n Kenƹan, ezzar yekka ǎkal yoǧǧeǧen ǎkal wa yezzeɣ eŋŋas Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Tela nsn ti mǎqqeret, wr eddobén éd ezzeɣen édeg iyyen, ǎkal wa dɣ ezzaɣen wr yeddobet éd yekf akesa i éheré nsn édét imaqqeren. ");
INSERT INTO thv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yezzeɣ Esayu tidreɣén tin Seƹir : Esayu enta as Edom. ");
INSERT INTO thv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Awah iheyawen n Esayu, tis n kél Edom, dɣ tidreɣén tan Seƹir : ");
INSERT INTO thv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Nɣwih ismawen n dg Esayu : Elifaz ag Ada, hennis n Esayu d Raƹuyil ag Basmat, hennis n Esayu. ");
INSERT INTO thv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Dg Elifaz entenéḍ Téman, Omar, Sefo, Jaƹtam d Qenaz. ");
INSERT INTO thv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz ag Esayu yekreh éy iyyen dɣ Timna tǎmǎt iyyet heḍet, yekreh ds éy, isem ennét Amalék. Awén iheyawen win Ada, hennis n Esayu. ");
INSERT INTO thv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Nɣwih dg Raƹuyil : Nahat, Zera, Šamma d Mizza. Awén iheyawen win Basmat, hennis n Esayu. ");
INSERT INTO thv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Nɣwih dg Oholibama, welt Ana welt Sibɣon, hennis n Esayu, térew as Yeƹuš, Yelam d Qoraḥ. ");
INSERT INTO thv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Nɣwih imɣaren n dg Esayu : Dg Elifaz, wa yezzaren dɣ dg Esayu : amɣar Téman, amɣar Omar, amɣar Sefo, amɣar Qenaz, ");
INSERT INTO thv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","amɣar Qora, amɣar Jaƹtam, amɣar Amalék. Awén imɣaren win Elifaz dɣ ǎkal n Edom, awén iheyawen win Ada. ");
INSERT INTO thv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nɣwih dg Raƹuyil, ag Esayu : amɣar Nahat, amɣar Zera, amɣar Šamma, amɣar Mizza. Awén imɣaren n Raƹuyil dɣ ǎkal n Edom ; awén iheyawen win Basmat, hennis n Esayu. ");
INSERT INTO thv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Nɣwih dg Oholibama, hennis n Esayu : amɣar Yeƹuš, amɣar Yelam, amɣar Qoraḥ. Awén imɣaren n Oholibama, welt Ana, hennis n Esayu. ");
INSERT INTO thv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Wiɣ entenéḍ dg Esayu, awén imɣaren nsn. Esayu enta as Edom. ");
INSERT INTO thv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Nɣwih dg Seƹir wan Horit, ǎmezzaɣ n ǎkal : Lotan, Šobal, Sibƹon, Ana, ");
INSERT INTO thv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dišon, Eser d Dišan. Awén imɣaren n Horiten, dg Seƹir dɣ ǎkal n Edom. ");
INSERT INTO thv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Dg Lotan ǎmosen Hori d Hemam, welt mas n Lotan enta as Timna. ");
INSERT INTO thv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Nɣwih dg Šobal : Alwan, Manaḥat, Eybal, Šefo d Onam. ");
INSERT INTO thv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Nɣwih dg Sibƹon : Ayya d Ana. Ana a yosen téṭ n aman wi ekkusnén dɣ ténéré, awad yeḍan ihéḍan win tis Sibƹon. ");
INSERT INTO thv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Nɣwih dg Ana : Dišon d Oholibama welt Ana. ");
INSERT INTO thv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Nɣwih dg Dišan : Hemdan, Ešban, Yitran d Keran. ");
INSERT INTO thv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Nɣwih dg Eser : Bilhan, Zaƹwan, Aqan. ");
INSERT INTO thv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Nɣwih dg Dišan : Uṣ d Aran. ");
INSERT INTO thv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Nɣwih imɣaren n Horiten : amɣar Lotan, amɣar Šobal, amɣar Sibƹon, amɣar Ana, ");
INSERT INTO thv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","amɣar Dišon, amɣar Eser, amɣar Dišan. Awén imɣaren n Horiten ak iyyen d tawsit ennét dɣ ǎkal n Seƹir. ");
INSERT INTO thv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nɣwih imenokalen wi emnakelnén dɣ ǎkal n Edom arweh wr ekréhen Israyiliten imenokalen : ");
INSERT INTO thv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla ag Beƹor, yemnakel fol Edom, isem n aɣrem ennét Dinhaba. ");
INSERT INTO thv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Yemmut Béla, yelkem as Yobab ag Zera wan Boṣra. ");
INSERT INTO thv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yemmut Yobab, yelkem as Hušam wan ǎkal wan Temaniten. ");
INSERT INTO thv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Yemmut Hušam, yelkem as Hadad ag Bedad. Yewet Madian dɣ ǎkal wan Mowab, isem n aɣrem ennét Awit. ");
INSERT INTO thv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Yemmut Hadad, yelkem as Semla wan Masreqa. ");
INSERT INTO thv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Yemmut Semla, yelkem as Šaul wan Rehobot ɣor ǎɣǎher. ");
INSERT INTO thv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Yemmut Šaul, yelkem as Baƹl-Hanan ag Akbor. ");
INSERT INTO thv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Yemmut Baƹl-Hanan ag Akbor, yelkem as Hadar ; isem n aɣrem ennét Faƹu. Isem n hennis Mehetabeel welt Matred welt Me-Zahab. ");
INSERT INTO thv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nɣwih ismawen n imɣaren n Esayu, ak iyyen d tawsit ennét d ǎkal ennét : amɣar Timna, amɣar Alwa, amɣar Yatét, ");
INSERT INTO thv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","amɣar Oholibama, amɣar Ela, amɣar Finon, ");
INSERT INTO thv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","amɣar Qenaz, amɣar Téman, amɣar Mibṣar, ");
INSERT INTO thv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","amɣar Magdiel, amɣar Iram. Awén imɣaren n Edom ak iyyen d awad yezzeɣ dɣ ǎkal wa dɣ iǧa tela. Awén iheyawen win Esayu tis n Edom. ");
INSERT INTO thv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yosa Yaƹqub ǎkal wa-n Kenƹan, dɣ édeg was kela ds izzeɣ tis. ");
INSERT INTO thv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Awah tǎnǎqqést n iheyawen n Yaƹqub. Yusef, ǎmawaḍ n meraw iwetyan d essa. Yeḍḍan éheré wa meḍriyen enta d ayet-mas, wi érewnet Bilha d Zilfa, tiyeḍ dɣ téḍéḍén n tis. Itaǧ i tisn isǎlan n awa itahawalen wrn oléɣ. ");
INSERT INTO thv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yoǧer sémɣar wa iǧa Yaƹqub i Yusef, édét yekreht dɣ tewehré ennét. Ikfé tǎkǎmést ta tnt tufet. ");
INSERT INTO thv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ayet mas n Yusef hanneyen sémɣar wa iǧa tisn i Yusef. Fol awéndɣ ekyeḍent, ǎbas has sawalen ar s tǎxellawt. ");
INSERT INTO thv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ahel iyen, yehhorǧet Yusef, yennen i ayet-mas, essoten ds ikeḍ. ");
INSERT INTO thv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nɣwah awa hasn yenna : « Seǧdet i tǎharǧitin, ");
INSERT INTO thv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","as iɲɲa éred, nefrest, nekredt, nekna ds tizzemén. Tahin tazzemt tebded, tinewen eɣleynet as, erkaƹnet dats ». ");
INSERT INTO thv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ennen as ayet-mas : « Teɣéled éd teqqeled ǎmǎnokal nnɣ ? ». Yota ikeḍ wa ds eǧen. ");
INSERT INTO thv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yehhorǧet Yusef arwah, yennen i ayet-mas : « Ehhorǧéɣ awah : tǎfuk, ǎyor d meraw itran d iyyen erkaƹen dati ». ");
INSERT INTO thv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Iǧa isǎlan aked i tis. Yeggoret fols, yenna has : « Ma tǧannéd deh, teɣéled nk d ayet-mak d mak, éd nerkeƹ datk ? » ");
INSERT INTO thv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ayet mas osemen fols, beššan tis yeqqim yoǧaẓ awéndɣ ul ennét. ");
INSERT INTO thv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ahel iyyen ekken ayet-mas n Yusef ǎkal n Šakim, eḍanen ds éheré n tisn. ");
INSERT INTO thv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Yenker Yaƹqub, yenna has i Yusef : « Ayet mak eḍanen éheré édés n Šakim. Egel asén » – « Ayoh Abba. » Yenna has Yusef. ");
INSERT INTO thv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yenna has Yaƹqub : « Egel essen ma dsn iǧan, entenéḍ d éheré, d teqqel-d, d teǧed ahi isǎlan. » Yesfelt ǎɣǎher wan Hebron, wa hen ihanén nsn. As yéweḍ Yusef édés n Šakim, ");
INSERT INTO thv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","yemheyyet d ǎwadem iyyen t-ihanneyen hund yexrak ezzar yessestent : « Ma teǧmayed ? » ");
INSERT INTO thv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yenna has Yusef : « Eǧmayeɣ ayet ma, teddobéd éd hi tenned mi-d eḍanen éheré nsn ? » ");
INSERT INTO thv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yenna has ales wah : « Efelen édeg waɣ. Esléɣ asn ǧannén in ekkan berén Dotan. » Yegmey tn Yusef, yosén dɣ ǎkal wan Dotan. ");
INSERT INTO thv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Eneyent dɣ iǧeǧ, arwah wr tn in yéweḍ, eǧǧehen anmekni fol téneɣé ennét. ");
INSERT INTO thv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ennen ǧérésn : « Hahet ! Ales wan tihorǧa ihiwen ! ");
INSERT INTO thv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Endawtet, neŋɣét dimaɣ. Édt nenḍuw dɣ anu, éd nen yeŋɣé ǎxxu iyyen. Éd nessen ma has éd eǧinet tihorǧa ennét tinǧam ! » ");
INSERT INTO thv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","As asn yesla Ruben, yeǧmey édt yennej, yenna hasn : « Wr enteǧǧét ds iman ! » ");
INSERT INTO thv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Yenna hasn daɣ : « Wr teǧém iman : enḍewet dɣ anu dɣ ténéré ɣas », yera édt yennej fol ayet-mas, baš édt yer i tis. ");
INSERT INTO thv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","As tn in yéweḍ Yusef, ermesenet, ekkesen as tǎkǎmést ennét ta tǎhoseyet, ");
INSERT INTO thv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","enḍewent dɣ anu. Anu wéndɣ yeqqor. ");
INSERT INTO thv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ḍeffer adih eqqimen éd ekšin. Eṭkelen ǎsǎwaḍ nsn ezzar eneyen tǎrǎkeft n Ismaƹiliten, efalen-d ǎkal n Jelƹad, ekkan Maṣar. Imnas nsn egguggen ikrora d elɣetren d tament. ");
INSERT INTO thv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yenna Yehuda i iyet mas : « Mas haneɣ tenfa téneɣé n Yusef d ufur n ahni ennét ? » ");
INSERT INTO thv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Wr yuf nezzenhéhin i Ismaƹiliten ula neǧa iman ? Enta ǎmeḍray nnɣ a yǎmos, nohar ds ahni ». Eɣbelen ayet-mas. ");
INSERT INTO thv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","A yekka essewelen fol awa hé eǧin, okeyen ettejjaren Ismaƹiliten n Madian winǧam. Ekkesen-d Yusef dɣ anu, ezzenhent-in i Ismaƹiliten wih, ezzenhent-in senatet temerwén n erriyalen n azref. Eweyent Ismaƹiliten s Maṣar. ");
INSERT INTO thv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","As yeqqel Ruben ɣor anu, wr yosé Yusef, yekun, abas yessen mad ihen fols, yessenxer iselsa ennét awa has iǧa ǎḥezan, ");
INSERT INTO thv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","yohel s ayet-mas, yenna hasn : « Yusef abas-t illa ! Ma hé eǧeɣ dimaɣ ?. » ");
INSERT INTO thv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ayet mas eŋɣen ǎholaɣ, esweren tǎkǎmést n Yusef ahni n ǎholaɣ wah. ");
INSERT INTO thv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ezzar esseweynt i tisn yeddéw d ǎmahal wah : « Nosa awaɣ. Essen weǧǧén ǎreswey n rurék. » ");
INSERT INTO thv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yezzeyt Yaƹqub, yenna : « Itbat as tǎkǎmést taɣ tin Yusef ! Okeleɣ yekša hit ǎxxu ! » ");
INSERT INTO thv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yessenxer iselsa ennét, yeslef, ilsa iselsa n ǎḥǎzan, yeḥzen ad iǧa a yeǧǧén. ");
INSERT INTO thv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Meddans emdan eǧmeyen éd tsismeḍen, yuǧey asn. Iganna : « Éd selfeɣ ad igen éheḍin aked nk. » Yeqqim yesilef fols. ");
INSERT INTO thv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yusef wadih éweyent Madianiten winǧam ar Maṣar, ezzenhent-in i Foṭifar, yǎmosen ales mǎqqeren ɣor Feraƹon, ales n ǎnaɣlaf. Yǎmos amɣar n wi tageẓnén Feraƹon. ");
INSERT INTO thv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Iwetyan windɣ, yefel Yehuda ɣor ayet-mas, yeres s ǎkal iǧan isem Adulam, ɣor ales iǧan isem Hira. ");
INSERT INTO thv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Déndɣ ad iney yellés n Šuƹa, iyyen dɣ Kenƹaniten. Yéwey tt. ");
INSERT INTO thv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Yekreh ds arraw, iǧas isem Γer. ");
INSERT INTO thv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Tessimrew animér, tekreh arraw iyyen heḍen, teǧas isem Onan. ");
INSERT INTO thv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","D iyyen heḍen, wan keraḍ, teǧas isem Šila. As iwa waɣ yehreyen, Yehuda iha Kezib. ");
INSERT INTO thv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yehuda iǧa éhen i Γer, wa mǎqqeren dɣ meddans, yéwey tǎmǎṭ iyyet s isem ennét Tamar. ");
INSERT INTO thv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Amaɣlol yeŋɣa Γer fol as wr has eǧrezen iǧiten ennét. ");
INSERT INTO thv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yenna Yehuda i Onan : « Eŋŋak abat wr ila arrawen, eǧel eǧ awa yeqqalen folk ǎššil, awi tǎmǎṭ tas kelad tt yéwey, ekreh ds arrawen i ǎmǎqqar ennek ». ");
INSERT INTO thv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Yessan Onan as arraw wéndɣ wr éd yeqqel innét, éd yumas arraw n ǎmǎqqar ennét. Fol awén, i-d yenmensa d tǎleggest ennét, éd yahes fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wr yegréẓ awén i Amaɣlol, yeŋɣé aked enta. ");
INSERT INTO thv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yenna Yehuda i tǎḍeggalt ennét : « Édét tǎmosed tadhant, eǧel eqqel ɣor tim ad idwel Šila. » Yenna dɣ iman ennét : « Wr ǎréɣ éd yemmet Šila hund ayet-mas ». Tenker Tamar, teqqel tezzeɣ ɣor tis. ");
INSERT INTO thv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ḍeffer adih, okeyen iwetyan, eba welet Šuƹa, hannis n Yehuda. As yokey ǎḥǎzan, yenker Yehuda, yekka Timna enta d ămidi ennét Hira wan Adulam, ekken éd enyin ǎddunet wi talesnen tihatten ti-n Yehuda. ");
INSERT INTO thv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Γor déɣ teslas Tamar, yahewel as : « aḍaggal ennem Yehuda yosa-d, ikka éd yales éheré ennét. » ");
INSERT INTO thv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tefel iselsa ennét win tadhant, tengeḍ afer, teswer-t udem ennét, tegla teqqim dat émi n aɣrem wan Enaym, aɣrem ihan ǎbǎreqqa n Timna. Teǧa awén-dɣ édét han tt isǎlan n-innin Šila yedwal, yeqqel ales, beššan wr hasn eǧen éhen. ");
INSERT INTO thv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yeney tt Yehuda, yekna ds temasrayt fol in teffar udem ennét. ");
INSERT INTO thv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Wr yeɣel tǎḍeggalt ennét, yoset in awa-d teqqim dɣ ǎbǎreqqa, yenna has éd yenmensi ds, éd tt yas, tenna has : « ma hi éd tekfed elkera hin? » ");
INSERT INTO thv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yenna has « éd ham-d siwyeɣ eɣeyd n éheré hin », tenna has : « beššan areɣ teɣelift ta hi éd tekfed dimaɣ a d-d yas eɣeyd ». ");
INSERT INTO thv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yenna has « ma tered ? » Tenna has : « Ǎẓeẓlu ennek d ǎhellum wa teṭṭafed, d teborit ta teṭṭafed ». Yekf-as tn, ezzar yeddew d-s. Tessimrew. ");
INSERT INTO thv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Teqqel tǎɣǎhamt ennét, tekkes afer ennét, ezzar teqqel iselsa ennét win tadhant. ");
INSERT INTO thv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yessewey Yehuda eɣeyd i tǎmǎṭ tanǧam, yekfe i ămidi ennét wan Adulam, yenna has éd yawi teɣalift ennét ta ɣor-s tellet. Ămidi ennét wr tt yose, ");
INSERT INTO thv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","yessesten ds ǎddunet win Enaym : « maǧǧa temasrayt ta s kelad tella déɣ edes n ǎbǎreqqa ? » Ennen as ǎddunet : « wr telle temasrayt déɣ wl iyyet » ");
INSERT INTO thv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Yaqqel-d Hira ɣor Yehuda, yenna has : « Tǎmǎṭ ta hi tesseǧmeyed wr tt oseɣ, aked ǎddunet win ǎkal wéndɣ, wr has eslen, wr tt ezzeyen. » ");
INSERT INTO thv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yenna Yehuda : « Tagże-t hereten winǧam, wr nezɣešumet iman nnɣ. Asseweyeɣ eɣeyd, key wr tt tosed ». ");
INSERT INTO thv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Γor keraḍet tilil ḍeffer adih, yos-d ales iyyen ɣor Yehuda, yenna has : « Tǎḍeggalt ennek teɣšad taɣera ennét, tekf-in iman ennét, tessimrew » yenna Yehuda : « Awyed tt-d, éd tt neqqed ! » ");
INSERT INTO thv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","As tt-d osen baš éd tt awyin, tenna hasn : « Ẓeyderawet, awyet ǎmahal waɣ i aḍeggalin, ennét as wiɣ kayaten in tis n arrawin », tesseknen teɣalift tangam, tamoset aẓeẓlu, ǎhellum d tǎborit. ");
INSERT INTO thv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yezzey Yehuda hereten winǧam ezzar yenna : « Tǎmǎṭ taɣ teżżal, teẓẓal fol-i, awa-d eba Onan, enneɣ as éd tt yawi Šila, ezzar wr hasn egeɣ éhen ». Ebas ds yenmensa Yehuda animér. ");
INSERT INTO thv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ahel wan terwa, eneyen as iknewen a hé tekreh. ");
INSERT INTO thv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Iyyen yesegmaḍ-d ǎfus. Tǎmǎṭ ta tt sasarawet, tekred ahed heggeɣen dɣ ǎfus wanǧam. Tenna : « Waɣ enta as ǎmǎqqar ». ");
INSERT INTO thv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Beššan yekkes ǎfus ennét, wa heḍen yegmeḍ-d enta yezzar. Tenna tǎmǎṭ ta teɣleyet Tamar : « Iket n ǎbǎreqqa tored i iman ennek ! » Yeǧa-s Yehuda isem Fareṣ -elmeƹna ennét temmerit-. ");
INSERT INTO thv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Yelkem as arraw wan ahed wa heggeɣen, yeǧ-as Yehuda isem Zera. Zera elmeƹna ennét taffawt tamileɣleɣet. ");
INSERT INTO thv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Eweyen Ismaƹiliten Yusef s Maṣar, ezzenhen-t in i elmasri iyyen igan isem Fotifar. Fotifar yexdam ɣor Ferƹaon, yǎmos ales mǎqqeren ɣor Feraƹon, ales n anaɣlaf. Yǎmos amɣar n wi tageẓnen Feraƹon. ");
INSERT INTO thv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yusef yezzaɣ ɣor Fotifar dɣ éhen ennét. Yellil as Amaɣlol. A yekna Yusef iǧǧah-t elxér, ikna emuken. ");
INSERT INTO thv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ihanney Fotifar as Amaɣlol yellil i Yusef. ");
INSERT INTO thv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yegreż Yusef i Fotifar hullan, yekfe tanaṭ n tǎɣǎhamt ennét temda.Yekfa ds taflest n tidet. ");
INSERT INTO thv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Men ahel wéndɣ, teǧǧeh elbaraka tǎɣǎhamt tan elmasri. Awén, dɣ ak heret, kud yera dɣ tǎɣǎhamt ula dɣ iferǧan. ");
INSERT INTO thv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Dédih, yenna Fotifar i Yusef éd iken ak haret. Ebas yemhaha d ula enḍerren ar-d téteté ennét. Tinaḍen emdanet yeǧenet dɣ ifassen n Yusef. Yusef yǎmos ales iknan tihusay. ");
INSERT INTO thv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ahel iyyen, teneyt tǎmǎṭ tan Fotifar, tenna has : « as a-hid, éd nenmensi ! » ");
INSERT INTO thv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yuǧey Yusef, yenna has : « messi a ila dɣ errezɣen d a ila dɣ tanaṭ d a-dɣ inniheḍ iǧa hi-t dɣ ifassen, nk ahel waɣ manek awa hé egeɣ éd enkereɣ éd eɣdereɣ fol-s éd egeɣ iǧi yogdan d waɣ, wrn eẓẓel ");
INSERT INTO thv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ikfi tanaṭ n a-dɣ inniheḍ dɣ tǎɣǎhamt taɣ, ar kem ɣas, wr eleɣ ettesrex n éd kem eḍseɣ, édét tǎmosed hannis. Manek awa hé aǧeɣ nekkunan fol tiǧawt n ǎbekkaḍ yogdan d déɣ ǧér-i d Messineɣ, ma-d ekkeɣ imanin ɣor Amaɣlol fol iǧi yogdan d waɣ ». ");
INSERT INTO thv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ak ahel tasehin, tegan as éd enmensin, beššan enta asǧed wr has esǧed, yuǧay éd ds yidaw, éd ds inmensi, . ");
INSERT INTO thv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ahel iyyen, yeǧǧeh Yusef tǎɣǎhamt éd iken eššeɣlen ennét, ahel hen-dɣ inaxdamen wrt ellen. ");
INSERT INTO thv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Termes-t tǎmǎṭ n Fotifar s aselso, tenna has : « endawet nemensi dɣ-i ! » Yusef yerwel, yoyya-s aselso déndɣ. ");
INSERT INTO thv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","As yegla, teney aselso dɣ ifassen ennét, ");
INSERT INTO thv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tesɣeret a td yerren, tenna i inaxdamen : « Enyet ƹibrani waɣ haneɣ-d yelwey ales in yeǧmey éd nenmensi, beššan esɣereɣ a hi-d yerren. ");
INSERT INTO thv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","As i yesla asiɣreɣ, yerwel, yoyya aselso ennét ɣor-i ». ");
INSERT INTO thv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Togaż areswey wanǧam ɣor-s a-d yosa ales ennét. ");
INSERT INTO thv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tenna has awa tenna i inaxdamen : « akli ƹibrani wa haneɣ-d tewey-d, nɣ-wah awa iǧa, yeǧmey éd nenmensi. ");
INSERT INTO thv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","As asɣereɣ yerwel, yoyya aselso ennét ɣor-i. » ");
INSERT INTO thv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","As yesla messis n Yusef i isǎlan wiɣ, yewwešen. ");
INSERT INTO thv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yesseǧmey Yusef, yeǧe dɣ tǎkormut tan ǎmǎnokal. Yusef yemel dɣ tǎkormut, ");
INSERT INTO thv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","beššan dɣ tamayt ennét, Amaɣlol iǧa i Yusef elbaraka. Yesmadew-t d amɣar n tǎkormut. ");
INSERT INTO thv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Amɣar waɣ yekfa i Yusef tanaṭ n éd yenneheḍ dɣ imidiwen ennét win tǎkormut. Enta a yeqqelen yenniheḍ dɣ awa itaweknen imda dɣ tǎkormut. ");
INSERT INTO thv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Amɣar ebas itimhihi d ula enḍerren, édét ihanney elxér wa yekfa Amaɣlol i Yusef. ");
INSERT INTO thv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ahel iyyen, ḍeffer awén emelent essin imɣaren dɣ elxeddamen n ǎmǎnokal n Maṣar, eǧen harat iyyen wrn has igreż. Iyyen yǎmos amɣar n wi saswenen ǎmǎnokal, iyyen amɣar n wi has toẓannen tiǧelwen. ");
INSERT INTO thv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Yewwešen Feraƹaon, yeǧen dɣ tǎkormut n amɣar n wi tageẓnen Ferƹaon, dɣ édeg wéndɣ iha Yusef. ");
INSERT INTO thv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Yaẓẓogeẓ-tn amɣar wan-ǧam n tǎkormut i Yusef. Eǧen eket yeǧǧen dɣ tǎkormut. ");
INSERT INTO thv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Éheḍ iyyen ehhorgen médden win-ǧam essin, ahhorǧen éheḍ iyyen beššan ak iyyen d teharǧit ennét. Ak tǎharǧit d tamulé ennét. ");
INSERT INTO thv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","As yeffo, yosen-in Yusef, yeɣley tn-in, yeney tn azikenẓaren dɣ iman nsn. ");
INSERT INTO thv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yessesten tn : « Ahel waɣ as kewen-d yeffo wr tesxem, ma kewen iǧrawen ? » Ennen as : ");
INSERT INTO thv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","« Ak iyyen deneɣ yehhorǧet teharǧit iyyet, beššan déɣ wr-t ille i tafeysaren tihoraǧa. » Yenna hasn Yusef : « Tihorǧa Messineɣ a tnt itafeysaren ! Leɣt-t i tihorǧa nwn éd hasnt esleɣ. » ");
INSERT INTO thv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ales wanǧam i hakken tésesé i ǎmǎnokal yenna : « Nekkunan, dɣ teharǧitin, enayeɣ tǎzzebibt. ");
INSERT INTO thv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tǎzzebibt taɣ tela karaḍ eẓlan. Tessegmeḍ, tekreh tisekkunén, eŋŋenet. ");
INSERT INTO thv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Aṭṭefeɣ elkar wa-n Ferƹaon. Ekkeseɣ-d ǎzzebib, egeɣ iẓeman ennét dɣ elkar wan Ferƹaon, ezzar eẓẓeleɣ ast. » ");
INSERT INTO thv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yenna has Yusef : « Tamulé n teharǧit ennek neɣtah : eẓlan winǧam karaḍ, ǎmosen karaḍ iheḍan. ");
INSERT INTO thv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dɣ keraḍ iheḍan éd key yeseǧmeḍ Ferƹaon, éd hak yer elxedmat ennek. Éd hak yeṭkel éɣef. Éd has tagged dɣ elkas ennét awa ises hund eru. ");
INSERT INTO thv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","As tegmeḍed déɣ, teknak taɣera, kud tekted ahi, inhod a has tenned i Ferƹaon éd hi yesegmeḍ tǎkormut taɣ. ");
INSERT INTO thv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Amehaɣeɣ, efeleɣ-d akalin s takareṭ, wr eɣhedɣ ula enḍerren as eǧǧeheɣ tǎkormut. » ");
INSERT INTO thv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","As yeney amɣar wan tiǧelwen as afeyser waɣ yǎhosey, yeǧreẓ as awén, dédih yenna has i Yusef : « Dɣ teharǧit tahin, ellanet keraḍet tisenaten n tagella, asiwereɣ tnt eɣefin. ");
INSERT INTO thv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dɣ tesǎnit tan afella dsnt, wr tt ihe ar hereten wi yessof Ferƹaon, beššan han tt igḍaḍ afella n eɣefin tatten tn. » ");
INSERT INTO thv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yenna has Yusef : « Nɣ-wah afeyser n teharǧit ennek : tisenaten ti-dɣ emosnet karaḍ iheḍan. ");
INSERT INTO thv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dɣ keraḍ iheḍan, éd key yeseǧmeḍ Ferƹaon, éd hak yeṭkel éɣef, éd key isiliy dɣ ašek, éd key-d asin igḍaḍ, éd key ekšin déndɣ. » ");
INSERT INTO thv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","As okeyen keraḍ iheḍan winǧan, Ferƹaon iǧa teramman n ahel wan tiwit ennét, yeɣra elxeddamen ennét wi-t oheẓnen emdan. Yesseǧmeḍ-d winǧam essin. Yeṭkel asn iɣefawen dat elxeddamen emdan. ");
INSERT INTO thv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Wa yezzaren n tésesé, yerra-s elxedmet ennét, yeqqim ihak elkas i Ferƹaon hund enǧom. ");
INSERT INTO thv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","wa heḍen n tiǧelwen yeskerareyt. Awén hund awa hasn yenna Yusef dɣ afeyser n tihoǧa nsn. ");
INSERT INTO thv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Beššan wa ihakken tésesé i Ferƹaon wr yekte Yusef, yettuwt. ");
INSERT INTO thv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Okeyen essin iwetyan, ahel iyyen yehhorget Ferƹaon innin yeqqim ɣor ǎɣǎher wan Ennil, ");
INSERT INTO thv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","yeney essahet tisita ehoseynen, edderetnen, egmaḍnet-d eɣǎher, efrednet dat-s akesa wan eɣǎher. ");
INSERT INTO thv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Elkamnet asnt essahet heḍnén exlanen, elbaknen, amosnet imlay, ebdednet edes n ti ezzarnen. ");
INSERT INTO thv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tisita ti emleynen ekšenet ti ehoseynen. Émér hen-dɣ yenker-d Ferƹaon dɣ eḍes. ");
INSERT INTO thv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Yeṭṭes, ezzar yehhorǧet animér : ihanney fol aẓenkew iyyen essahet tihammaren ehoseynen, eṭkarnen teḍaɣen. ");
INSERT INTO thv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Edes nsnt egmaḍnet-d essahet tihamarren exlanen, yekšenet ahoḍ. ");
INSERT INTO thv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Tiɣ ehreynen ekšenet ti ezzarnen. Émér hen-dɣ yenker-d Ferƹaon dɣ eḍes, yelmed as tǎharǧit a iǧa. ");
INSERT INTO thv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","A-s yeffo, yeqqan éɣef n Ferƹaon, yessegmey édeg d illa dɣ ǎkal imda n Maṣar amaššexew d aneddebber ula elkehhani. Illeɣet asn tihorǧa ennét, eba éré wa has tnt yeffeyserin. ");
INSERT INTO thv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Γor déndɣ, yesséwel amɣar wan iseswiten, yenna i Ferƹaon : « Ahel waɣ a-d éd semmektuɣ dat-k awa eɣhedɣ a ilan iwetyan, ");
INSERT INTO thv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ahel iyyen teggored fol-i nk d fol amɣar wan tiǧelwen, tenḍewed aneɣ dɣ tǎkormut tan amɣar n wi eɣleynen Ferƹaon. ");
INSERT INTO thv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nehhorǧet issenen-eneɣ éheḍ iyyen. Ak tǎharǧit d tamulé ennét. ");
INSERT INTO thv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Dɣ tǎkormut tanǧam ille ǎmawaḍ iyyen ƹibrani yamosen akli wan amɣar wan tǎkormut. Nenna has awa nehhorǧet, yekfaneɣ ak iyyen elmeƹna n tǎharǧit ennét. ");
INSERT INTO thv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Awén-dɣ haneɣ yenna enta a iǧen : nk, yenna hi éd aqqeleɣ elxedmetin, eqqeleɣ-tt, amidihin enta yenna has, éd tekririyed, yekrarey ». ");
INSERT INTO thv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yesseǧmey Ferƹaon Yusef. Essegmeḍen-t id dɣ tǎkormut, efrenen as, ebbedelen as iselsa, ezzar elweyent-id dat ǎmǎnokal. ");
INSERT INTO thv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Yenna has ǎmǎnokal i Yusef : « ahhorǧeɣ tihorǧa hin, esdekkeleɣ id t-illa ǎwadem issanen heret, elleɣeɣ asn tihorǧa hin, wr tn ihe éré yekfen elmeƹna n tihorǧa hin. Esleɣ in as tesled i tehharǧit, teddobed éd tekfed elmeƹna ennét ». ");
INSERT INTO thv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yenna has Yusef : « Awén Amaɣlol a hé yekfin elmeƹnaten n elxér i tihorǧa tin Ferƹaon, weǧǧén nk. » ");
INSERT INTO thv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Yenna Ferƹaon : « ehhorǧeɣ in eqqimeɣ ɣor Ennil. ");
INSERT INTO thv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Essahet tisita huharnen ehoseynen egmaḍnet-d eɣǎher, efrednet fol aǧenena. ");
INSERT INTO thv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Elkamnet asnt essahet exlanen, emlaynen, a-eweɣ wr neyeɣ dɣ ǎkal n Maṣar tisita ǧanen tǎxellawt ten-dɣ. ");
INSERT INTO thv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ekšenet ti ezzarnen, ti edderetnen. ");
INSERT INTO thv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tisita tiɣ, as egreyyetnet ti ezzarnen, eqqimnet emlaynet hund enǧom. Den-dɣ a-d enkereɣ. ");
INSERT INTO thv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Eṭṭeseɣ, egeɣ teharǧit iyyet heḍet : eneyeɣ fol aẓenkew iyyen essahet tihemmaren ahoseynen, essanen teḍaɣen. ");
INSERT INTO thv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Eǧmeḍnet-d essahet tihemmaren heḍnén exlanen, wr tnt tehe isem n ṭaḍaq, aqqornet. ");
INSERT INTO thv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tihemmaren ti exlanen ekšenet ti ehoseynen. Elleɣeɣ tihorǧa tiɣ i imeššexewen d ineddubbar, eba éré hi yennen elmeƹna wl iyyet ». ");
INSERT INTO thv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yenna has Yusef : « tihorǧa ennek amosnet heret iyyen. Itileɣut Messineɣ i Ferƹaon awa hé yeǧ. ");
INSERT INTO thv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tisita ti ehoseynen d tihemarren ti ehoseynen amosnet essa iwetyan. Essa iwetyan n akesa : tihorǧa ennek iyyen n heret. ");
INSERT INTO thv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tiheḍnen tisita d tihemmaren, aked entaneteḍ amosnet essa iwetyan, beššan essa iwetyan n menna. ");
INSERT INTO thv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Awéndɣ hak enneɣ : Messineɣ itileɣut ak awa-s yebok éd t-weǧ. ");
INSERT INTO thv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Essa iwetyan wiɣ d eglenen, éd t-imel akesa yeǧǧen dɣ ǎmǎḍal n Maṣar imda. ");
INSERT INTO thv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Éd hasn elkemen essa iwetyan n menna. Menna ten-dɣ éd tehheddem ǎkal imda. ");
INSERT INTO thv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Éd tumas heret iyyen éd haneɣ éd isettewin aked isem n akesa. ");
INSERT INTO thv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tihorǧa ennek amosnet senatet édét Messineɣ yera éd key iselmed as awén-dɣ itbat, wr éd yebbedel, yerored tigawt ennét. ");
INSERT INTO thv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Adih egmiy ales yessanen, ilan tayetté, éd hak yilal s elxekem n Maṣar. ");
INSERT INTO thv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Egmiy aked ǎddunet wi-s ak ǎwetay, dɣ ǎkal imda éd eṭṭefen tan semmoset n afaras fol essa wetyan n akesa. ");
INSERT INTO thv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Éd ṭaṭṭefen allon fol iwetyan n akesa wiɣ-d eglenen, éd eṭṭefen éred, éd t-eǧin dɣ tiheqqiwen n eɣremen emdan. Awéndɣ imda éd yemel dag elxekem ennek. ");
INSERT INTO thv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","As-d éd asin iwetyan win menna, wr éd emmeten ǎddunet s laż ». ");
INSERT INTO thv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Egreżnet tifér tiɣ i Ferƹaon d elwezeren ennét ; ");
INSERT INTO thv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","yenna hasn Ferƹaon : « Tordam in éd nas éré ds yolan, ales iha Unfas n Messineɣ ? ». ");
INSERT INTO thv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ezzar yenna i Yusef : « édét Messineɣ isselmed key awén-dɣ imda, wr ordeɣ as éd neǧrew ales dk yolan musnet d tayetté dɣ Maṣar s elxedmet taɣ. ");
INSERT INTO thv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Key a hé yeqqelen amɣar n tǎɣǎhamt-in temda, éd texkemed fol ellamet-in d fol ǎkal imda. Wr key éd akyeɣ ar s tamennukela. » ");
INSERT INTO thv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Yenna Ferƹaon i Yusef : « key a hé yexkemen, a hé yenneheḍen fol Maṣar imda ». ");
INSERT INTO thv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Yekkes Ferƹaon tisaq ennét tan tammenukela ezzar yeǧet dɣ aḍaḍ wan Yusef ; yesselse iselsa n elkettan wi tn ufenén, yeǧa-s tasɣalt n oreɣ. ");
INSERT INTO thv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","yessewen-t fol elkerwila tan senatet, ta wr itiwen ar ales wa ilkemen elxukuma i Ferƹaon. Ezzaren-as ǎddunet wiyeḍ asiɣeren : « Hekwet ! Erkeƹet ! » ");
INSERT INTO thv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Yenna Ferƹaon i Yusef : « nk a yǎmosen Ferƹaon ! Beššan wr t-ille éré yesmessen aḍer ula ǎfus sl wr has tesserrexed ». ");
INSERT INTO thv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ferƹaon yeǧa isem i Yusef wan Mesriten, isem waɣ Safnat-Feƹnia, iǧa-s ṭameṭ tega-t isem Asnat welt Foti-fereƹ, yǎmosen amerabu dɣ aɣrem wan On. Dédih Yusef yegla yeɣley dɣ ǎkal n Maṣar. ");
INSERT INTO thv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Émér hen-dɣ Yusef ila keraḍet temerwén n ewetay. Yefel Yusef édeg wa iha Ferƹaon, yessokel dɣ Maṣar imda. ");
INSERT INTO thv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Fol essa iwetyan, yemel-t akesa yeǧǧen, ");
INSERT INTO thv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","isadaw Yusef awa yeddobet imda dɣ Maṣar imda, ak aɣrem ikna ds iǧenden dɣ isadaw allon n iferǧan wi has eɣlaynen. ");
INSERT INTO thv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yesdew éred yeǧǧen. Ǧannen ǎddunet a-d yogda d tekesselt ta ɣor ǧeréw, ǎǧut wa iǧa a-d ǎbas eddoben éd tseḍnin. ");
INSERT INTO thv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Arwah wr-d teweḍ menna, tekreh Asnat, hennis n Yusef, essin arrawen. ");
INSERT INTO thv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","As yewa wa mǎqqeren yenna Yusef : « yestewet ahi Messineɣ awa yexlen, wa fol efeleɣ addunetin » fol awén-dɣ as as iǧa isem wan Mensi. ");
INSERT INTO thv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","As iwa wa meḍriyen yenna : « yekf-i Messineɣ arrawen dɣ ǎkal wa dɣ oseɣ toẓẓért » fol awén-dɣ as as iǧa isem Efraym. ");
INSERT INTO thv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Okeyen iwetyan wi-n akesa dɣ Maṣar. ");
INSERT INTO thv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Elkemen asn iwetyan win menna, hund awa yenna Yusef. Temelt menna dɣ ikallen emdan, beššan dɣ Maṣar yelle allon dɣ iǧenden, iǧenden ennét eṭkarnet. ");
INSERT INTO thv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","As yeŋɣa laż kél Maṣar, osen Ferƹaon ennen as yeŋɣa nɣ laż. Yenna hasn : « aset Yusef, d t-egim awa hawen éd yen. » ");
INSERT INTO thv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Menna tella dɣ ikallen emdan. Yora Yosef tiheqqiwen, yezzenhin éred i ǎddunet win Maṣar. Menna tassota aṣahu dɣ Maṣar ");
INSERT INTO thv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aked ǎddunet win ikalen wi heḍnén osen-d ɣor Yusef, zanhen éred édét menna mǎqqeret a ihan ikalen emdan. ");
INSERT INTO thv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yelmed Yaƹqub in ille éred dɣ Maṣar ; yenna hasn i meddans : « ma tkannem deh, tenimekyadem ? ");
INSERT INTO thv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Esleɣ in Maṣar ihet éred. Eglet zenhet id. Wr nere éd nemmet ». ");
INSERT INTO thv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Eglen ayet-mas n Yusef meraw essen, ekken Maṣar éd ds zenhin éred. ");
INSERT INTO thv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Benyamin wadih, Yaƹqub yeṭṭeft. Yaƹqub wr issegla Benyamin, rurés wa meḍreyen, ǎmeḍray n Yusef, yenna : « Wr ereɣ éd t-yeǧrew a yexlan. » ");
INSERT INTO thv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Eweḍen in Dg Yaƹqub Maṣar eddewen d ǎddunet wiyeḍ heḍnén win Kenƹan, édét menna telwa dɣ ǎkal nsn. ");
INSERT INTO thv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusef enta as amɣar, enta a izazenhen éred. Osen-t in ayet-mas, esseslement, erkeƹen dat-s, udem yeḍas maḍal édét amɣar a yǎmos. ");
INSERT INTO thv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yezzeyten Yusef, beššan wr hasn yeẓẓel awal, iǧa iman ennét hund wr tn izzey. Yessestenten : « Mis-d tefelem ? » Ennen as : « Ǎkal wan Kenƹan, nera éd nezenh isudar. » ");
INSERT INTO thv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yezzey tn Yusef, beššan entenéḍ wr t-ezzeyen. ");
INSERT INTO thv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Γor déndɣ yesmekta Yusef tihorǧa ennét. Yenna hasn : « Kawaneḍ dimaɣ temosem kél tinawen (imaɣlayen) ! Teram éd teynim taɣaššimt n ǎkal waɣ ». ");
INSERT INTO thv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ennen as : « kela Sidi, nos-d éd nezenh isudar ɣas. ");
INSERT INTO thv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nakkeneḍ nemos araten n ales iyyen. Wr nere a yexlan i ǎkal waɣ, wr fol-s neǧmey tinawen.» ");
INSERT INTO thv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yenna Yusef : « Bahu nwn, taɣaššimt n ǎkal a-d tosem éd tt teynim ». ");
INSERT INTO thv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ennen : « kela, nefal-d ǎkal wan Kenƹan. Nemos maraw aŋŋaten d essin, wa meḍriyen yeqqim ɣor abba nnɣ, iyyen heḍen ebat ». ");
INSERT INTO thv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yenna Yusef : « awén-dɣ enneɣ : temosem kél tinawen (imaɣlayen). ");
INSERT INTO thv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nɣ-tah tametart nwn : Ahaḍeɣ awn fol Ferƹaon éd kud tefelem waɣ ǎkal as kundebat yosed ǎmeḍray nwn wa enḍerren déɣ. ");
INSERT INTO thv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Seglet iyyen dewen éd t-id yawi, wi heḍnén éd eqqeymin déɣ dɣ tǎkormut a-d yeqqel. Éd esseneɣ ǧannem ahi tidet méɣ kala, méɣ ahaḍeɣ awn fol Ferƹaon ar imaɣlayen a temosem ». ");
INSERT INTO thv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yeǧen Yusef emdan dɣ tǎkormut, as okeyen keraḍ iheḍan yesseǧmeḍ tn. ");
INSERT INTO thv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ahel wan keraḍ yenna hasn : « a-wah a hé tegim, baš éd teqqeymim teddarem, édét eksoḍeɣ Messineɣ. ");
INSERT INTO thv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kud tidet a ǧannem, iyyen dewen éd yeqqayem dɣ tǎkormut taɣ. Wi heḍnén, éd eqqelen ǎkal nsn, éd awyin éred d isudar i ǎddunet nsn édét manna a igan. ");
INSERT INTO thv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Éd hi-d tawyim ǎmeḍray nwn. Éd elmedɣ dédih as tidet a ǧannem. Éd teqqeymim teddarem ». Eɣbelen awén. ");
INSERT INTO thv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Beššan ǧér-essen ennen : « Ah ! Teweḍ aneɣ addeɣwet n ǎmeḍray nnɣ, wr has nesged as deneɣ iǧmey tinaheɣén émér wa-t noya, dimaɣ iǧarrew-aneɣ awa-t iǧrewen. » ");
INSERT INTO thv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Yenna Ruben : « Ennéɣ awn tn innin wr teŋɣem Yusef. Beššan wr hi tesgedem, adiš dimaɣ éd nerẓem tǎmettant ennét ! » ");
INSERT INTO thv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wr eɣelen in Yusef yefham tn, édét as yekka yesséwel asn, yelle muṭerjem. ");
INSERT INTO thv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Dédih, yefel tn Yusef, yegla yeslef. As-d yeqqel, yenna hasn éd yeṭṭef Šimƹun, igas tihebeǧiwen dat-sen. ");
INSERT INTO thv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yenna Yusef i elxeddamen ennét éd hasn eṭkeren ibelbaḍ nsn allon, éd hasn errin aẓref nsn dɣ ibelbaḍ nsn, éd tn ekfin ezzad i asikel nsn, eǧen awén. ");
INSERT INTO thv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Aǧuǧǧen iheḍan nsn, ezzar eglen. ");
INSERT INTO thv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","As tn iǧa éheḍ esseɣseren, yora iyyen dsn ǎbelboḍ ennét baš éd izekš eyhéḍ ennét, ma yeney deh ? Aẓref wanǧam dɣ émi n abelboḍ. ");
INSERT INTO thv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Yenna hasn i ayet-mas : « arahwet, nekkunan erren ahi-d aẓref in ! Yella deh, dɣ ǎbelboḍ in ! » Enmekyeden, ermeɣen, ehtebben ulawen nsn, ennen : « ma d ihen fol-nɣ ? Ma haneɣ iǧa Messineɣ deh ? » ");
INSERT INTO thv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","As eweḍen Kenƹan ɣor tisn, ennen as awa iǧen imda : ");
INSERT INTO thv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","« Ales wa yǎmosen amɣar n ǎkal, yesséwel aneɣ s tǎxellawt, iǧa-nɣ erk awal. Ikna deneɣ imaɣlayen. ");
INSERT INTO thv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nekkenéḍ nelleɣet as in wr nexle, wr nemos imaɣlayen. ");
INSERT INTO thv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nemos meraw aŋŋaten d essin, iyyen deneɣ ebat, wa enḍerren yeqqim ɣor abba-nnɣ dɣ Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Yenna haneɣ yera éd yelmed in enǧanna tidet méɣ bahu. Yenna : « Eyyet iyyen dewen déɣ, eglet awyet tanafek i ǎddunet nwn. ");
INSERT INTO thv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Awyet ahi-d ǎmeḍray nwn wa yehreyen. Éd elmedɣ in gannem tidet méɣ. Éd hawen erreɣ ǎmeḍray nwn Šimƹun, ɣor déndɣ éd kewen eyyeɣ dédih tessokelem dɣ ǎkal imda. » ");
INSERT INTO thv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Esseɣseren kayaten nsn, i hé yarin ǎbelboḍ ennét éd yas aẓref ennét ihe. As eneyen aẓref wah, ermeɣen, ehtebben ulawen nsn, aked ul wan tisn yehtebbet. ");
INSERT INTO thv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yenna hasn Yaƹqub : « teram éd ǎbas leɣ meddani : ǎbas leɣ Yusef ula Šimƹun, dimaɣ teram éd dɣ-i tekkesem aked Benyamin ! Ma eɣhedɣ ar déndɣ ? Ma eɣhedɣ a-d eǧǧeheɣ erk emmek waɣ ? » ");
INSERT INTO thv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Yenna has Ruben : « Kud wr hak d erreɣ Benyamin, eŋɣ arrawen in essin essen. Eyyahi-t, éd hak id erreɣ ». ");
INSERT INTO thv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yenna has Yaƹqub : « Kela, arrawin wr dewn éd yidaw. Eŋas yemmut, wr hi yeqqim ar enta. Kud yeǧrewt heret iyyen dɣ esikel, s tewehre hin éd emmeteɣ dɣ érét nwn. » ");
INSERT INTO thv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Teṣṣohet menna dɣ ǎkal n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","As yemmenda éred wa-d ifelen Maṣar ɣor Yaƹqub, yenna hasn i meddans : « aqqelet, zenhet aneɣ-d a nekša ». ");
INSERT INTO thv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yenna has Yehuda : « amɣar wéndɣ yenna haneɣ kud nosin sel ǎmeḍray nnɣ, wr haneɣ éd yekf ula enḍerren. ");
INSERT INTO thv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kud toyed aneɣ éd nawiy Benyamin, éd d-neqel neway isudar ». ");
INSERT INTO thv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kud tuǧeyed, wr neǧle, édét ales wéndɣ, tinawt yenna haneɣ-tn : « kud amaḍray nwn wr dewn yeddew, wr hawen ilkem éd hi teynim ! » ");
INSERT INTO thv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yenna Yaƹqub : « Mafol a hi teǧem elɣib waɣ ? Mafol has tileɣum in telam ǎmeḍray ? ». ");
INSERT INTO thv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ennen as : « Enta a-haneɣ yessestenen fol ǎddunet nnɣ. « Tikwen yeddar ? Telam ǎmeḍray iyyen heḍen ? Newejeb as. Wr neɣel éd haneɣ yen éd d-nawiy ǎmeḍray nnɣ ». ");
INSERT INTO thv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yenna Yehuda : « Abba, ey Benyamin éd deneɣ yidaw. Ilzem éd neǧel, kud nera éd nedder, nekkenéḍ d ǎddunet nnɣ. Wr nere éd nemmet. ");
INSERT INTO thv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nk a-hé yekkelefin fol amaḍray nnɣ Benyamin. Kud wr hak t id erreɣ, nk a yeḍlamen ar abedǎh. ");
INSERT INTO thv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Dimaɣ kud wr haneɣ teṭṭefed, kud nera neǧa essin isikilen ». ");
INSERT INTO thv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Yenna hasn Yaƹqub : « Adih eǧlet, beššan awyet hereten n ǎkal nnɣ aẓednen emdan i elmasri wéndɣ. Akfet ikrora d elɣetren d torawet d fustaq d elluz d tament. ");
INSERT INTO thv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Awyet aked aẓref wa tosem dɣ ibelbaḍ nwn, tiǧenen iyyen dsn a yeɣleḍen, sitet fol-s aẓref iyyen heḍen i awa hé-d t-zenhim. ");
INSERT INTO thv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dimaɣ eǧlet, idawet d ǎmeḍray nwn. ");
INSERT INTO thv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","É Messineɣ, key wan Ǎneddabu, a iǧen tamella dɣ ales waɣ baš éd kewen d yer kewenéḍ d imeḍrayen nwn Šimƹun d Benyamin ! Nk dédih kud ilkam éd hi exreken arrawenin, exrekenet ». ");
INSERT INTO thv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Eglen aŋŋaten winǧam, ewayen aẓref waɣ imda d tihekkiwen, eddewen d Benyamin, osen Yusef dɣ Maṣar, ebdeden dat-s eket nsn. ");
INSERT INTO thv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","As yeney Yusef Benyamin, yenna has i amɣar n inaxdamen ennét : « Elwey ǎddunet win s teɣahamtin, eŋɣasen éɣef, éd umasen imeǧarenin, éd eklin ɣori ». ");
INSERT INTO thv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yeǧa amɣar wah awa has yenna Yusef, yelweten s tǎɣǎhamt n Yusef. ");
INSERT INTO thv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","As asn yehewel éd eǧǧehen, ermaɣen, ennen ǧér-essen : « Tiǧenen dɣ érét n aẓref wan asikel wa yezzaren. Aran éd haneɣ zuǧhin déɣ, baš éd erteken deneɣ, éd awyin iheḍan nnɣ, éd eneɣ eknin éklan ». ");
INSERT INTO thv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","As deroɣ eǧǧehen, oheẓen-in ales wanǧam sollan, ennen as : ");
INSERT INTO thv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","« Inhoḍ a haneɣ tesǧeded, kela-d d nosa déɣ dat ahel waɣ, enzanha isudar. ");
INSERT INTO thv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Dɣ ebaraqqa wan oɣul, nora ibelbaḍ nnɣ, ak iyyen deneɣ yosa dɣ innet aẓref was yezzenha isudar winǧam imda. Nerre hid aẓref wen. ");
INSERT INTO thv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Newey-d aẓref iyyen heḍen i isudar wi hé-nzenh asihey waɣ. Wr nessen mi erren aẓref dɣ ibelbaḍ nnɣ ». ");
INSERT INTO thv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yenna hasn amɣar wah : « Kela kela, tǎhanint, wr termeɣem, wr teksoḍem, Messineɣ nwn, Messineɣ n abbaten nwn a ha wen yerren aẓref nwn dɣ ibelbaḍ, aẓref wan isudar ermeseɣ-t. » Yessegmeḍ asn-d ales Šimƹun dɣ tǎkormut. ");
INSERT INTO thv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Yezzoǧeh tn emdan ɣor Yusef. Egrewen aman éd serdin eḍaren nsn, iheḍan nsn eǧrewen iškan. ");
INSERT INTO thv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ezwejjeden awa-d eweyen i Yusef, eqqelen as éd hin yas s terut édét elmeden as yeklin. ");
INSERT INTO thv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","As in yeǧǧeh Yusef, ekfent hereten winǧam. arkaƹen dat-s. ");
INSERT INTO thv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yesseslem tn Yusef, ezzar yenna : « Ma hin iǧa amɣar nwn ? yeddar arwah ? » ");
INSERT INTO thv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ennen : « Ayoh, yegoḍey. » Arkaƹen dat-s animér. ");
INSERT INTO thv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yeṭkel Yusef ǎsewaḍ ennét, yeney Benyamin, aŋŋas, wa terew mas, ezzar yenna : « Awah ǎmeḍray nwn was-i tennem. » Itter as : « É Messineɣ a key yoǧeẓen abaraḍin ! » ");
INSERT INTO thv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusef teweḍt tamella n aŋŋas, yenker hik, yerwel, édét éwenen as imeṭṭawen dɣ téṭṭawén. Yeǧla yeslef ɣas ennét. ");
INSERT INTO thv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yessered udem ennét, ezzar yeqqel-d. Yenna hasn i ǎddunet ennét éd d-awyin ameklu. ");
INSERT INTO thv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yos-d ǎmekši. Yeqqim Yusef ɣas ennét, ayet-mas yosen-d ǎmekši ɣas nsn. Elmesriten aked entenéḍ ekšen ɣas nsn, édét wr tihrin taɣahut d ƹibraniten, xaram fol-sn. ");
INSERT INTO thv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yesɣeymen Yusef dat-s, mn wa mǎqqeren ar wa enḍerrenn, enmeswaḍen ǧérésn akirebben. ");
INSERT INTO thv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yekfen Yusef imekšan wi t-ellenen dat-s. Beššan tafolt ta yekfa i Benyamin toǧer s semmos meren tiful tin wi heḍnén. Yeswa elboẓa yertay dsn, a-d ezhen. ");
INSERT INTO thv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yenna Yusef i amɣar n inaxdamen ennét : « Aṭker ibelbaḍ n ǎddunet wih, eǧ-asn awa eddoben. Er aẓref dɣ imawen n ibelbaḍ nsn. ");
INSERT INTO thv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Dɣ abelboḍ n wa meḍreyen, eǧ ds aẓref ennét, aked elkasin wa yeknen dɣ aẓref. » Yeǧa ǎwadem awa has yenna Yusef. ");
INSERT INTO thv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Déndɣ d yeffo ahel wa heḍen, eglen Dg Yaƹqub entenéḍ d iheḍan nsn. ");
INSERT INTO thv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Efelen aɣrem, beššan wr oǧeǧǧen animér, as yenna Yusef i amɣar n inaxdamen ennét : « Enker, aweḍ-tn, en asn : « Mafol as taǧǧem elɣib dɣ édeg n elxér wa teǧrewen ? ");
INSERT INTO thv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Mafol tokerem elkas wa dɣ isas elwezer, elkas wa dɣ ilammed awa iǧen d awa hé eǧin ? Elɣib mǎqqeren a teǧem deh ! » ");
INSERT INTO thv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yosen in ales, illeɣet asn awa has yenna Yusef. ");
INSERT INTO thv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ennen as : « Ma yǎmos waɣ heret ? Xaram-aneɣ in neǧa awén-ɣ ! ");
INSERT INTO thv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ner-d aẓref wa newey s Kenƹan, wa nosa dɣ ibelbaḍ nnɣ. Ma-fol as éd naker aẓref méɣ oreɣ dɣ tǎɣǎhamt n ales wéndɣ ? ");
INSERT INTO thv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kud nosa elkas dɣ kaya n iyyen deneɣ, yemmetet ! Éd neqqel dédih éklan ennek. » ");
INSERT INTO thv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yenna amɣar n elxeddamen : « Eɣbaleɣ. Beššan ǎmǎker ɣas a-hé yeqqelen akli hin, wi heḍnén esserexen, éd eǧlin ». ");
INSERT INTO thv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Esseɣseren kaya nsn hik, oren tn. ");
INSERT INTO thv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Yeǧǧeh ales asefferetwi, yebda s kaya n wa mǎqqeren, yezzehrey s wan wa meḍreyen. Yemesa elkas dɣ abelboḍ wan Benyamin. ");
INSERT INTO thv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ermaɣen, essenxeren iselsa nsn, erren kaya fol iheḍan nsn, emlellayen aqqelen aɣrem. ");
INSERT INTO thv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Eweḍen Yehuda d ayet ma-s ɣor Yusef : iha tǎɣǎhamt ennét animér. Erkeƹen dat-s udem yewaḍ ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yenna hasn Yusef : « Mafol taǧǧem awén-dɣ ? Wr teɣelem as ǎwadem hund nk yeddobet éd elmed awa iǧen ? » ");
INSERT INTO thv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yenna has Yehuda : « Ma hak éd nen dimaɣ ? Ma hak éd nen baš éd teflesed in wr neḍlem ? Messineɣ a haneɣ yermesen. Éd neqqel éklan ennek, nekkenéḍ d was nosa elkas dɣ abelboḍ ennét.. » ");
INSERT INTO thv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yenna Yusef : « Kela, Wr eddobeɣ éd egeɣ awén ! Wr éd awyeɣ ar was oseɣ elkas dɣ abelboḍ ennét. Wi heḍnén eqqelnet ɣor tisn dɣ elxér d esselamet. » ");
INSERT INTO thv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yoheẓin Yehuda sollan ɣor Yusef, yenna has : « Adobeɣ éd enneɣ tafert iyyet, wr-t key tzewweššen ? Key wa yolan d Ferƹaon. ");
INSERT INTO thv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Asihey wa yezzaren, tessestened aneɣ kud nela abba nnɣ animér d ǎmeḍray iyyen heḍen. ");
INSERT INTO thv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nelleɣet ak n innin amɣar nnɣ yeddar, nela ǎmeḍray, yekreht abba nnɣ dɣ tewehre ennét, yere hullan. Berén mas ta eba, wr has-d yeqqim ar enta, aŋŋas ebat. ");
INSERT INTO thv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tenned aneɣ : « Awyet id, ereɣ éd t-enyeɣ s teṭṭawenin ». ");
INSERT INTO thv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nelleɣet ak innin wr neddobet éd t-id nawiy, kud wr-t in nerre, abba nnɣ éd t-iba. ");
INSERT INTO thv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tenned aneɣ kud wr ti-d newey, kela wr d entaset, wr key éd neney. ");
INSERT INTO thv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Neqqel ɣor abba nnɣ, nenna has awa haneɣ tenned imda. ");
INSERT INTO thv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","As aneɣ yezmahel animér éd hin nawey isudar, ");
INSERT INTO thv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nenna has : « Wr neddobet éd neǧel ar neddew d ameḍay nnɣ, fol as amɣar wan ǎkal, kud wr hin nose neddew ds, iǧaneɣ eššeɣel wan innin wr-t éd neney, wr haneɣ éd yerrexeb ». ");
INSERT INTO thv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Yenna haneɣ abba nnɣ : « Tessanem as tǎmǎṭ in Rašél, wr ds ekreheɣ ar essin arrawen. ");
INSERT INTO thv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Iyyen ebat ; tiǧenen ekšen-t exxuten, édét mn axarok wa iǧa eggeden isǎlan ennét. ");
INSERT INTO thv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Teram éd hi tawyim aked wa heḍen ! Kud yeǧrewt haret iyyen, nk éd emmeteɣ dɣ tewehre-hin ». ");
INSERT INTO thv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Dimaɣ, menek awa hé egeɣ éd eqqeleɣ ɣor abba hin sel arraw waɣ ? Tǎmeddort n abba nnɣ togda d awa hé yeǧrewen arraw waɣ ");
INSERT INTO thv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Éd t-iba kud wr hin neqqel neddew d arraw. Dɣ érét-nnɣ, s tewehre ta iǧa, éd iba abba-nnɣ. ");
INSERT INTO thv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Enneɣ as i abba-hin : « Kud wr d erreɣ arraw, nk as ǎnaḍlam ». ");
INSERT INTO thv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Inhod, ey ahi éd eqqeymeɣ déɣ, eṭṭefi nk, éd umaseɣ akli ennek, ey arraw éd iǧel, enta d ayet-mas. ");
INSERT INTO thv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Wr eddobéɣ éd eqqeleɣ ɣor abbahin sl arraw. Wr eddobéɣ ǎhenay n toẓẓért ta hé tegrewet abbahin. » ");
INSERT INTO thv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ǎbas yeddobet Yusef éd yeffer iman ennét dat ǎddunet emdan, yesɣeret asn, yenna hasn éd eǧmeḍen. Yera éd eǧmeḍen baš yeqqayem ɣas-ennét enta d aŋŋaten ennét émér wad tn éd yezozey iman-ennét. ");
INSERT INTO thv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Beššan yeslef tǎseloft teknan tuksé, ad has eslen Elmesriten, eqqimen ǧannen tn, ad éweḍen isǎlan ɣor Ferƹaon. ");
INSERT INTO thv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yenna Yusef i ayet-mas : « Awaɣ nk Yusef ! Abba hin yeddar animér méɣ ? » Ayet mas ǎbas essanen ad ihen folsn, wr ennen ula. ");
INSERT INTO thv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","« Ahẓet id » yenna hasn. Oheẓent in. Yenna Yusef : « Nk awah Yusef, ǎmeḍray nwn, wa hin tezzenhem s Maṣar. ");
INSERT INTO thv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Dimaɣ wr kewen itaǧǧehet elhem n ininnin tezzenhem ahi, ula enḍerren. Awén Messineɣ a hi yesseweyen s Maṣar, baš éd hawen ekkeseɣ tǎmettant dɣ émér n menna. ");
INSERT INTO thv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Okeyen essin iwetyan n menna beššan eqqimen semmos arweh, semmos iwetyan wiɣ wr tn thé elxedmet, wr tn ihe afaras, wrt illé a dsn iknen. ");
INSERT INTO thv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yesséweyen a hid Messineɣ dɣ ǎkal waɣ baš éd ds tekrehem arrawen, éd ds tezzeɣem. Hund awéndɣ yeddobet éd kewen yennej, ǎnejji mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Hanneyem as weǧǧén kewenéḍ a hid yesseweyen déɣ, awén isweǧǧan win Messineɣ. Enta a dɣi yeknen elwezér n Ferƹaon, amɣar n éhen ennét d Maṣar imda. ");
INSERT INTO thv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Dimaɣ, eǧlet hik, siwḍet ǎmahal i abba-hin, ennét as : “Awaɣ Yusef yehulkey-d, yenna : Messineɣ yekna dɣi amɣar wan Maṣar. As ahid dimaɣ hik, wr tehléd. ");
INSERT INTO thv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","As-d éd tezzeɣed ǎkal was itahawal Jasen key d meddank d iheyawen ennek d éheré ennek wa ǧezzulen d wa heǧren d errezɣen ennek emdan. Éd hid tahẓed. ");
INSERT INTO thv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Déɣ, ula-s éd tafriyem, ula hawen éd yasrin, édét eglan-d semmos iwetyan n menna.” » ");
INSERT INTO thv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yenna Yusef arweh : « Tessanem as nk a-hawen yesséwelen, aked eŋŋa Benyamin issan awén. ");
INSERT INTO thv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Eglet aset abba-nnɣ, leɣtet as innin ǎmoseɣ ales mǎqqeren dɣ Maṣar, leɣtet as awa teneyem imda. Teqqelim-d déɣ teddewem ds hik. » ");
INSERT INTO thv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Dédih yermes dɣ ifassen ennét Yusef ǎmeḍray ennét Benyamin, eslefen issenen ésn. ");
INSERT INTO thv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yennermes d ayet-mas aked wi heḍnén, yemmullet asn emdan yesilef. Ɣor déndɣ ɣas a-ds esdewennén. ");
INSERT INTO thv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Dɣ éhen wan ǎmǎnokal, elmeden ǎddunet s innin Yusef osent id ayet-mas. Iǧreẓ awén i Ferƹaon d inaɣlafen-ennét. ");
INSERT INTO thv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Yenna has i Yusef : « En-asn i ayet-mak éd eǧaǧǧin ihéḍan nsn, d eqqelnet ǎkal nsn, ");
INSERT INTO thv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","éd-d awyin tisn d ǎddunet-nsn. Éd tn egeɣ dɣ ǎkal wa t-n yufen dɣ Maṣar, édeg wa hen hereten wi tn ufenen dɣ ǎkal. ");
INSERT INTO thv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","En-asn i ayet-mak éd d-awyin elkerwiletén ti dɣ-d éd awyin téḍéḍén nsn, d arrawen nsn, d tisn. ");
INSERT INTO thv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wr i tn zemhelhilet awa hin éd eyyin, édét tiẓudawen n Maṣar éd umasnet tinasen. ");
INSERT INTO thv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Eǧen meddans n Yaƹqub awa hasn yehewelen. Yekfen Yusef elkerwiletén, hund awa yenna Ferƹaon, yekfén aked ezzad wan ǎbǎreqqa. ");
INSERT INTO thv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ak iyyen dsn yekfé ǎreswey yehoseyen s ibbeddel. Benyamin yekfé semmos iresweyen, yessétas keraḍet temaḍ n aẓref. ");
INSERT INTO thv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yessewey i tis meraw ihéḍan, eǧuǧǧenén awa tn yufen dɣ ǎkal n Maṣar. Yesséwey as arwah merawet tihéḍén eǧuǧǧenén éred, tagella d imekšan ǎǧǧotnén. Yekfén aked ezzad wan ǎbǎreqqa. ");
INSERT INTO thv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yenna hasn i ayet-mas : « Héwet wr teknésem dɣ ǎbǎreqqa, ezzayeɣ-kewen », ezzar yoyyen éd eǧlin. ");
INSERT INTO thv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Efelen Maṣar, éweḍen ǎkal n Kenƹan ɣor tisn. ");
INSERT INTO thv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ennen as : « Yusef yeddar animér ! Enta as amɣar n Maṣar. » Yendar i Yaƹqub éd yefles awén, wr tn yefles. ");
INSERT INTO thv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ennen as awa hasn yenna Yusef imda, esseknent awa has-d yessewey Yusef imda. Ɣor déndɣ yenker-d Yaƹqub dɣ eḍes ennét, yeddewet. ");
INSERT INTO thv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yenna : « Xlas ! Dimaɣ eddobeɣ édt efleseɣ ! Arrawin Yusef ikna tǎmeddort ! Endawtet ! Ereɣ éd eyneɣ teṭṭawén-ennét arwah wr emmuteɣ ! » ");
INSERT INTO thv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yegla Yaƹqub enta d tela ennét temda. As yeweḍ taɣremt n Bersabeƹ, iǧa takuté i Messineɣ n tis Isḥaq. ");
INSERT INTO thv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Éheḍ wéndɣ yesséwel as Messineɣ. Yeɣre : « Yaƹqub ! Yaƹqub ! » Yenna has Yaƹqub : « Nk deh. » ");
INSERT INTO thv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Yenna has Messineɣ : « Nk Messineɣ, Amaɣlol n tik, wr teksoḍed éd tas-d Maṣar, éd key ekfeɣ iheyawen ǎǧǧotnén, déndɣ ad éd umasen ellamet mǎqqeret. ");
INSERT INTO thv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nk a dk éd idawen a hin tawḍed, arreɣ key-d daɣ ǎkal-ennek. Ɣor tǎmettant ennek, Yusef iman ennét a hak éd yehrin téṭṭawén ». ");
INSERT INTO thv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yefel Yaƹqub Bersabeƹ. Egent meddans dɣ elkerwiletén tin Ferƹaon, enta d téḍéḍén-nsn d meddansn. ");
INSERT INTO thv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Emhelen éheré nsn d awa elen imda dɣ Kenƹan, eweḍen-in Maṣar hund awén. ");
INSERT INTO thv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Awéndɣ a iǧa Yaƹqub ad yaweḍ Maṣar enta d ǎddunet ennét emdan. ");
INSERT INTO thv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","15","Awah ǎddunet win Yaƹqub wi osenen Maṣar : meddans d iheyawen-ennét. Awaɣ arrawen wi yekreh Yaƹqub dɣ Léya dɣ ǎkal wan Fadan-Aram : Ruben, wa mǎqqeren dɣ meddans n Yaƹqub. arrawen n Ruben Hénok, Falu, Heṣron d Kermi. Šimƹun, meddans Yemuel, Yamin, Ohad, Yakin, Sohar d Šaul, waɣ ehreyen térewt tǎmǎṭ n Kenƹaniten. Léwi, meddans, Jeršon, Qehat d Merari. Yehuda, meddans Šila, Fareṣ d Zerah. Ila essin eba tn dɣ ǎkal n Kenƹan, Ɣer d Onan. Rurés n Yahuda wan essin s isem ennét Fares ila essin meddans, Hesron d Hamul. Isakar, meddans Tola, Fuwa, Yub d Šimron. Zabulon, meddans Sared, Elon d Yaleel. Ila Yaƹqub dɣ Léya aked tunté teǧat isem Dina. Entenéḍ d meddansn ǎmosen keraḍet temerwén d karaḍ. ");
INSERT INTO thv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Yekreh Yaƹqub arrawen aked dɣ Zilfa, taklit ta yekfa Laban i yellés Léya, nɣwih : Jad d meddans Sefyun, Haji, Šuni, Esbon, Eri, Arodi d Areli. Ašir d meddan-s Yemna, Išwa, Išwi d Beriƹa, d tǎmeḍrayt nsn Sera. Beriƹa ila essin meddans Heber d Malkiel. Awén meddans d iheyawen n Yaƹqub d Zilfa. Ǎmosen meraw d seḍis. ");
INSERT INTO thv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rašél, hennis Yaƹqub, tekfe essin arrawen : Yusef d Benyamin. ");
INSERT INTO thv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Dɣ Maṣar Yusef yekreh essin arrawen dɣ hennis Asnat, welt Foti-fereƹ ǎmǎrabu n aɣrem wan On, isem nsn Mensi d Efraym. ");
INSERT INTO thv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin yekreh meraw arrawen : Béla, Baker, Ašbil, Jira, Naƹman, Ehi, Roš, Mufim, Hufim d Ard. ");
INSERT INTO thv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Awah meddans d iheyawen n Yaƹqub d Rašél, ǎmosen meraw d ekkoẓ. ");
INSERT INTO thv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Yekreh Yaƹqub arrawen aked dɣ Bilha, taklit ta yekfa Laban i yellés Rašél, nɣwih : Dan d rurés Hušim. Neftali d meddans Yasiel, Juni, Yeser d Šilem. Awén meddans d iheyawen n Yaƹqub d Bilha. Ǎmosen essa. ");
INSERT INTO thv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ǎddunet win Yaƹqub wi ekkenen Maṣar ǎmosen seḍiset temerwén d seḍis. Otanet folsn tiḍulén ennét (téḍéḍén n meddans). ");
INSERT INTO thv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Windɣ d arrawen win Yusef wi ewenén dɣ Maṣar, eqqalen essahet temerwén. ");
INSERT INTO thv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yezmahel Yaƹqub Yehuda éd has yelleɣet i Yusef émér wa hin eyaweḍ Jasen. As deroɣ ewaḍen Yaƹqub d innet Jasen, ");
INSERT INTO thv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","yezwejjed Yusef elkerwila-ennét, yegla éd dsn imhiyyet. As yeney tis, yeṭṭef-t dɣ ifassen ennét, yeslef as fol eẓer a-d iǧa eket. ");
INSERT INTO thv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yenna has Yaƹqub : « dimaɣ addobeɣ éd emmeteɣ, édét teddared. Enmeneynet téṭṭawén tinnu d tinnek dɣ tameddortin ». ");
INSERT INTO thv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yenna Yusef i ayet-mas d ǎddunet win tis emdan : « éd egleɣ éd elleɣuɣ i Ferƹaon tisit nwn déɣ, kewenéḍ wis kelad tezzaɣem ǎmǎḍal n Kenƹan. ");
INSERT INTO thv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Éd has enneɣ in tamosem imeḍanen, teḍḍanem éheré, teweyem-d éheré nwn we ǧezzulen d wa heǧren d awa tlem imda. ");
INSERT INTO thv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","As kewen yeɣra Ferƹaon, yessesten kewen d elxedmet-nwn, ");
INSERT INTO thv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ennét as tamosem imeḍanen, teḍḍanem éheré wa fol meḍriyem ar dimaɣ hund abbaten nwn emdan. Dédih éd kewen yey éd tezzeɣem ǎmǎḍal wa yoǧǧeǧen n Jasen, édét elmesriten ekyaḍen ǎddunet wi eḍḍanen éheré wa ǧezzulen . ");
INSERT INTO thv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yegla Yusef yosa Ferƹaon, yenna has : « osen-d abba-hin d ayet ma, ewaten-d éheré nsn wa ǧezzulen aked wa heǧren, efalen-d Kenƹan, han ǎkal n Jasen émér waɣ ». ");
INSERT INTO thv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yezozeyt semmos dɣ ayet-mas. ");
INSERT INTO thv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Yessesten tn Ferƹaon : « Ma tǎmos elxedmet nwn ? ». Ennen as : « Nekkenéḍ imeḍanen, neḍḍan éheré wa fol n meḍriy hund abbaten nnɣ. ");
INSERT INTO thv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Menna tekkus dɣ Kenƹan, enta a-haneɣ-d isteɣen, ǎbas t-illa akesa i éheré nnɣ. Nos-d déɣ neǧmay a nezzekša i éheré nnɣ d iman nnɣ. Neǧmay dk éd haneɣ teyyed éd nezzeɣ Jasen ». ");
INSERT INTO thv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Yenna Ferƹaon i Yusef : « Dimaɣ d osen ayet-mak d tik, ");
INSERT INTO thv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Maṣar tinnek, eǧmey édeg wa hak egreẓen ds, t-ekfed asnt. Addoben éd eqqeymin dɣ Jasen kud eran. Kud tezzayed dsn ma ǎmosen wi elenen serho, zemmehihiten d éheré hin. » ");
INSERT INTO thv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yelwey Yusef tis ɣor Ferƹaon. Yesseslemt Yaƹqub, iǧas tittar. ");
INSERT INTO thv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Yessestent ǎmǎnokal « Maneket iwetyan ennek ? » ");
INSERT INTO thv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yenna has Yaƹqub « Leɣ téméḍé n ewatay d keraḍet temerwén exrakeɣ ǧér ikallen, ǎmoseɣ aw-ténéré. Temeddortin tokey hik, okeyen fol-i iwetyan eṣṣohetnen, beššan kela wr ewedɣ iwetyan wi essokeyen abbaten-in dɣ isikilen nsn, ǎmosen eddunya n ténéré. » ");
INSERT INTO thv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","As yenna awén, yenker yetter as arweh ezzar yegmeḍ tǎɣǎhamt n Ferƹaon. ");
INSERT INTO thv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yezozeɣ Yusef ǎddunet ennét dɣ ǎkal wa tn yufen dɣ Maṣar, Jasen, ǎkal wan Ramsès, hund awa has yenna Ferƹaon. Yekfen imeḍlan. ");
INSERT INTO thv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yekfa Yusef tanafek i tis d ayet-mas d ǎddunet nsn emdan, ak iyyen yekfe a yegdehen i ǎddunet-ennét d arrawen-ennét. ");
INSERT INTO thv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Temel-t menna ad ǎbas t-tella tanafek dɣ ǎkal imda. Dɣ Maṣar aked dɣ Kenƹan ǎddunet inaqqen laẓ dɣ érét n menna taɣ. ");
INSERT INTO thv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusef yezzenha éred i ǎddunet, yeǧa aẓref dɣ tǎɣǎhamt tan ǎmǎnokal. Awén-dɣ a iǧa Yusef yermes aẓref imda wan Kenƹan d wan Maṣar ");
INSERT INTO thv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","As immenda aẓref dɣ Maṣar d Kenƹan, osen-in elmasriten ɣor Yusef, ennen as « Akf aneɣ a nekša, akf anɣ awas éd nedder, wr haneɣ éd teyyed éd nemmet dat téṭṭawén ennek, ǎbas nela aẓref baš éd key nerẓem. » ");
INSERT INTO thv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yenna hasn Yusef « kud ǎbas tlem aẓref, akfet id éheré nwn. » ");
INSERT INTO thv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Eweyen-d éheré nsn i Yusef, yekfen imekšan. Ewatay wéndɣ, ezzenhen tanafek s tela, eǧrewen imekšan esimeskelen t-n s éheré nsn imda : iyyesan, tihatten, ulli, tisista d ihiḍan. ");
INSERT INTO thv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","As yokey ewatay, osen-d Yusef, ennen as « Ǎbas nela aẓref, ǎbas nela éheré. Ǎbas nela ar imeḍlan-nnɣ d iman-nnɣ. ");
INSERT INTO thv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Wr haneɣ éd teyyed éd nemmet dat téṭṭawén-ennek d imeḍlan-nnɣ éd eqqarin ? Zenh anɣ nekkenéḍ d imeḍlan-nnɣ. Akf aneɣ a nekša. Éd numas éklan n Ferƹaon d imeḍlan-nnɣ éd eqqelen innet. Wr nere éd nemmet. Akf aneɣ tefest baš éd nedder d imeḍlan-nnɣ wr éd eqqarin ». ");
INSERT INTO thv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yezzenha Yusef imeḍlan win Maṣar emdan. Elmasriten ezzenhen iferǧan nsn dɣ érét n eṣahu n menna. Yeqqel ǎkal imda in Ferƹaon. ");
INSERT INTO thv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yekna Yusef dɣ ǎddunet win Maṣar emdan éklan n Ferƹaon. ");
INSERT INTO thv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Imeḍlan wi wr izzenha Yusef ɣas, win imerubay. Édét eddaren fol awa tn ihak Ferƹaon, wr emxataren isudar, fol awéndɣ as wr ezzenhen imeḍlan nsn. ");
INSERT INTO thv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yenna Yusef i ǎddunet : « Dimaɣ kewen ezzenheɣ kewenéḍ d imeḍlan nwn i Ferƹaon, éd kewen ekfeɣ tefest baš éd tseŋŋelem éred. ");
INSERT INTO thv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ɣor awa-d éd yeŋ éred, éd tekfim tan semmoset i Ferƹaon. Awa heḍen inewen. Agẓet ds tefsen nwn. Akšet, zekšet arrawen nwn d ǎddunet emdan wi ezzeɣnen dɣ ihenan nwn». ");
INSERT INTO thv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ennen as : « Neddar. Nekrehét datk udem, sidi ! Fol awéndɣ éd neɣbel, neddiwet, éd neqqel éklan n Ferƹaon. » ");
INSERT INTO thv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Mn ahel wéndɣ elxekuma ten-dɣ ikna Yusef fol éred teqqim telle dɣ Maṣar : tan semmoset n awa-d ifalen iferǧan yǎmos in Ferƹaon. Wr t-ille ar imeḍlan win imerubay a wrn yǎmos in Ferƹaon. ");
INSERT INTO thv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ezzeɣen Israyliten, ǎddunet win Yaƹqub, dɣ Maṣar, dɣ ǎkal wan Jasen. Ekrehen ds imeḍlan, ekrehen arrawen, eqqelen eǧǧeten. ");
INSERT INTO thv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yezzeɣ Yaƹqub meraw iwetyan d essa dɣ Maṣar. Yedder téméḍé n ǎwetay d ekkoẓet temerwén d essa. ");
INSERT INTO thv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","As yelmed Yaƹqub in tǎmettant toheẓ, yeɣr-in rurés Yusef, yenna has : « kud tered ahi s tidet, sekn ahi-t : wr hi tenbeled dɣ Maṣar. Inhod ahi-t tahaḍed, sens ǎfus ennek dag eleɣ in. ");
INSERT INTO thv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","As i eba, awi ahi s édeg n ǎddunet-in ». yenna has Yusef : « Éd egeɣ awa-s i tenned ». ");
INSERT INTO thv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yenna has Yaƹqub : « Ahaḍ ». Yehaḍ ast Yusef, a yekka Yaƹqub yerkaƹ dat édeg-ennét. ");
INSERT INTO thv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ḍeffer awén, yesla Yusef i torna n tis. Yegla yeddéw d meddans, Mensi d Efraym. ");
INSERT INTO thv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","As yelmed Yaƹqub tisit n rurés, yeɣhel éd yeqqayem fol édeg ennét, zernah-d yeqqim. ");
INSERT INTO thv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yenna has i Yusef : « Messineɣ wan Ǎneddabu yosa hid dɣ ǎkal wan Luz, dɣ ǎkal n Kenƹan, yeǧa-hi elbaraka-ennét. ");
INSERT INTO thv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Yenna-hi : « éd key ekfeɣ arrawen ǎǧǧotnén baš éd teqqeled abba n tawsitén ǎǧǧotnén. Éd ekfeɣ ǎkal waɣ i arrawen ennek ar abedǎh ». ");
INSERT INTO thv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yenna Yaƹqub : « Dédih arrawen ennek wi ewenén dɣ Maṣar, aqqalen sr-i hund arrawenin. Efraym d Mensi ǎmosen sri hund Šimƹun méɣ Ruben. ");
INSERT INTO thv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Wi hak ewenén ḍeffer-sn, éd eqqeymin innek. Éd eǧrewen tǎkasit nsn dɣ ikallen n imeqqaren nsn. ");
INSERT INTO thv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","As-d efeleɣ Fadan-Aram, arwah wr hin éweḍeɣ Efrata, dɣ ǎkal n Kenƹan, mak Rašél eba tt dɣ ǎbǎreqqa, tenbal édés n Efrata, dɣ Beytlaḥm, ihan ǎbǎreqqa n Efrata. ");
INSERT INTO thv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ɣor déndɣ yeney Yaƹqub arrawen win Yusef, yessestent : « Ma ǎmosen wih ? » ");
INSERT INTO thv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yenna has Yusef : « Awah arrawenin wi hi yekfa Messineɣ dɣ Maṣar. » Yenna has Yaƹqub « ẓihẓiten-d, éd tn ekfeɣ elbaraka. » ");
INSERT INTO thv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tewehre n Yaƹqub tesderɣel-t, wr yesnefra hullan. Yeẓẓoheẓ-t Yusef arrawen ennét. Yeṭṭef ten Yaƹqub, yemmullet asn. ");
INSERT INTO thv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ezzar yenna i Yusef : « itbat as ekkaseɣ eṭṭema n éd eyneɣ udem ennek beššan dimaɣ Messineɣ yessekna-hi aked udem n meddank ». ");
INSERT INTO thv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yezzenkeh Yusef arrawen ennét ɣor ifadden n Yaƹqub ezzar yerkeƹ udem-ennét insa fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ezzar yeṭṭef tn s ifassen ennét : Efraym yeṭṭaf-t s aɣil, yemel fol tehalǧe n Yaƹqub. Mensi yettaf-t s tahalǧe, yemel fol aɣil n Yaƹqub. Yeẓẓoheẓ tn Yaƹqub arweh. ");
INSERT INTO thv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Yeznemehrey Yaƹqub ifassen ennét, yeswer ǎfus wan aɣil Efraym, ǎfus wan tahalǧe yeswer-t Mensi. Wr iteweǧǧi édét Mensi enta a yǎmosen wan ǎmeqqar. ");
INSERT INTO thv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nɣ-tih tittar ti iǧa i Yusef : « É Messineɣ, Messineɣ wan ḥenini-hin Ibrahim d abba-hin Isḥaq ! É Messineɣ wa yolen d amaḍan, hi yoǧeẓen wa fol eweɣ ar dimaɣ ! ");
INSERT INTO thv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","wa yolen d ǎngelos hi yeɣlesen : eǧ elbaraka i arrawen wiɣ. Ereɣ édt imel isemin ɣorsn ar abǎdeh, hund win abba hin Isḥaq d ḥenini hin Ibrahim ! Éd ekrehen arrawen ǎǧǧotnén dɣ ǎkal imda ! » ");
INSERT INTO thv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Wr iǧreẓ awén i Yusef as iney tis yesiwer ǎfus ennét wan aɣil éɣef n Efraym, yermest yeǧmey édt yeǧ fol éɣef n Mensi. ");
INSERT INTO thv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yenna has :« Abba, teɣlaḍed. Wa mǎqqeren nɣwah, eǧ ǎfus ennek wan eɣil fol éɣef ennét ». ");
INSERT INTO thv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Yuǧey Yaƹqub, yenna has : « Essaneɣ, ǎbǎraḍin, essaneɣ. Arrawen win Mensi éd eqqelen ellamet mǎqqeret. Beššan ǎmeḍray ennét édt yaki, éd yekreh ellametén ǎǧǧotnén. » ");
INSERT INTO thv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ahel wéndɣ yenna hasn : « Israyliten éd ɣarren ismawen nwn baš éd eǧin tittar. Éd ennin : « É Messineɣ a key yessolen d Efraym d Mensi ! » Hund awéndɣ as iǧa Efraym dat Mensi. ");
INSERT INTO thv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Dédih yenna i Yusef : « Deroɣ d-iǧen éheḍin, éd kewen yageẓ Messineɣ, éd kewen yer ǎkal n abbaten-nwn. ");
INSERT INTO thv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Éd key ekfeɣ ǎmǎḍal yoǧeren wan ayet-mak, éd teǧrewed Šakim, tendɣ erbexeɣ dɣ enmaŋɣi ǧeri d Amoriten s tǎkoba-hin d taɣaye-hin. » ");
INSERT INTO thv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yeɣr-d Yaƹqub meddans, yenna hasn : « Aset-d temdam, éd hawen enneɣ awa hawen yelkamen dɣ ezzeman. ");
INSERT INTO thv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Idawet-d, seǧdet ahi dg Yaƹqub, seǧdet i abba nwn Israyil. ");
INSERT INTO thv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben key, ǎmahwarin, key wa ekreheɣ émér-d ǎmoseɣ ǎmali, key a yoǧeren dɣ serho, key a yoǧeren dɣ terna. ");
INSERT INTO thv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tameskaled hund anǧi yohalen, ǎbas éd tumased wa yezzaren, édét tehreyed tik dɣ édeg ennét, édét tessǎxremed tafteqin. ");
INSERT INTO thv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Šimƹun d Léwi, aɲɲaten, tikobawén nsn, tiẓolyawén ekmanén. ");
INSERT INTO thv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ufuren nsn, wr hi teǧǧehen dɣ iman, wr eréɣ éd eǧǧeheɣ iǧiten nsn, dɣ ikennasen nsn, eŋɣen médden. Aqquderen aked éswan dɣ ǎddelen. ");
INSERT INTO thv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tilɣant fol ǎweššen nsn édét yekkus, tilɣant fol iǧiten nsn édét ǎṣṣohén ! Éd tn oẓaneɣ dɣ ǎkal n Yaƹqub, éd tn zemmezzeyeɣ dɣ ǎkal n Israyil. ");
INSERT INTO thv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda, ayet-mak éd hak eǧin tamulé. Éd ternud ihenǧa ennek, dg tik éd enhin datk. ");
INSERT INTO thv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yehuda, ǎbaraḍin, tǎmosed hund aher meḍriyen, wa inaqqen a yermes, ḍeffer adih éd yeqqel édeg ennét. hund aher, yeǧen, hund tahert, mit éd isenkerin ? ");
INSERT INTO thv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Aṭṭebel n temenukela, éd yeqqayem ɣor kél Yehuda, Wr éd yemmukkes ǧér éḍaren ennét, ar ahel wa-d éd yas Šilo, was éd elkemnet ellametén. ");
INSERT INTO thv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yoǧey eyhéḍ ennét dɣ tǎzzebibt, yoǧey ǎmaynu ennét dɣ aẓel yehoseyen, isarad aselso ennét s elboẓa, d ǎbernuh ennét s ahni n ǎzzebib. ");
INSERT INTO thv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Téṭṭawén ernanet elboẓa tekkewelt, isénen ernan ax temellé. ");
INSERT INTO thv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon éd yezzeɣ édés n ǧeréw, awad tizekkuten elbaboren. Yegla ǎkal ennét ar émi n aɣrem wan Sidon. ");
INSERT INTO thv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar eyhéḍ yeṣṣohén, inassen ǧér ǎgiggiten ennét. ");
INSERT INTO thv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Yeney as édeg yǎhosey, ǎkal yǎẓéd, ǎẓuk yezneh as ǎrori, adih yexdem hund akli. ");
INSERT INTO thv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan éd yeḥkem fol ellamet ennét, hund iyyet dɣ tawsitén n Israyil. ");
INSERT INTO thv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan hund taššelt dɣ ǎbǎreqqa, tǎxxut dɣ tarrayt : ta teddadet azreh n ayes ad yoḍu éré wadt yoɣaren. ");
INSERT INTO thv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Amaɣlol, eǧéɣ eṭṭema dɣ eféssi ennek ! ");
INSERT INTO thv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Jad, édt ehjemen imǎkǎren, éd tn yeqqel, éd tn yeḍren. ");
INSERT INTO thv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asser éd yekreh tagella tedanet. Imekšan n ǎmǎnokal effalent-id. ");
INSERT INTO thv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali yǎmos hund ǎhenkeḍ dɣ tinariwén, ihak eddunya iwhémen ǎhoseynén. ");
INSERT INTO thv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusef hund ašek itarewen s ǎǧut, ašek itarewen s ǎǧut iwaren téṭ n aman, Éẓlan ennét okayen aked elxiyaḍen. ");
INSERT INTO thv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Eḍlement, eǧerent, ekyeḍent, wi ǎmosnén messawsn n tiɣayiwén. ");
INSERT INTO thv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Beššan yekna oḍuf i tǎɣayé ennét, fesusen ifassen ennét, dɣ terna n Ǎmeqqered wan Yaƹqub, Ǎmǎḍan, Étǎq n Israyil, ");
INSERT INTO thv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","s Messineɣ n tik, éd key yennej ! S Ǎneddabu, éd key yeburek s elbaraka n iǧennawen win afella, d elbaraka n aman wi-d efelnén ammas n ǎmǎḍal, d elbaraka fol éfef d tesa n tuntawén. ");
INSERT INTO thv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Elbaraka ta key yekfa abba ennek, tokey elbaraka ta eǧreweɣ ɣor abbatenin, tewrét éɣef n Yusef, yǎmosen amɣar n aɲɲaten ennét ! ");
INSERT INTO thv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin yola d-tǎhori tessukṣeḍet, s tufat itat a-wa yermes s éheḍ itoẓan awa yosa. » ");
INSERT INTO thv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Emdan-ésn ǎmosen tawsitén tin merawet d senatet tin Israyil. Awén tifér ti hasn yenna tisn émér wa tn yeburek, ak iyyen dsn yekfé elbaraka ds togdat. ");
INSERT INTO thv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ḍeffer awén yenna Yaƹqub i meddans : « As i eba, enbelet ahi ɣor abbatenin dɣ teɣaɣit ta thet ǎmǎḍal wan Efron, wan Ḥethit, ");
INSERT INTO thv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","dɣ Makfela, ɣor Mamré, dɣ ǎkal n Kenƹan. Ibrahim yezzenha ǎmǎḍal wéndɣ dɣ Efron baš éd yeqqel isensa. ");
INSERT INTO thv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Déndɣ ad inbel, enta d hennis Sara, aked Isḥaq d hennis Rébéka. Déndɣ ad enbeleɣ Léya. ");
INSERT INTO thv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Teɣaɣit d ǎmǎḍal enhan fol Ḥethiten ». ");
INSERT INTO thv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","As yesmenda Yaƹqub awa iganna i meddans, yensa, ezzar ebat, yéweḍ édeg ennét ɣor innét. ");
INSERT INTO thv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yegged Yusef fol abba ennét hik, yemmullet as yesilef. ");
INSERT INTO thv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Yenna hasn i éḍbab éd eknin taɣara i abba ennét. Essokeyen eḍbab akkoẓet temerwén n ahel kannen taɣara i Yaƹqub, esweren-t ikrora, elɣetren baš wr éd yageẓ. Elmasriten eslefen fol tǎmattant n Yaƹqub essahet temerwén n ahel. ");
INSERT INTO thv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","As yemmenda ǎḥǎzan, yenna Yusef i ǎddunet win Ferƹaon : « Kud teram ahi elxér, ennét as i Ferƹaon awah : ");
INSERT INTO thv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","« Animér wr eba ti, yezheḍ ahi in édt enbeleɣ dɣ ǎkal n Kenƹan, dɣ édeg ennét. Eyyahi éd egleɣ édt enbeleɣ, éd eqqeleɣ ḍeffer awén». ");
INSERT INTO thv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yenna has Ferƹaon : « Awen s Kenƹan, egel enbel tik édét teheḍed ast. » ");
INSERT INTO thv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yegla Yusef éd yenbel tis, aṣṣofeḍent imɣaren win Maṣar, ");
INSERT INTO thv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Eddéwen ds ǎddunet ennét, ayet-mas emdan. Wr yeqqim dɣ Jasen ar arrawen d éheré ɣas. ");
INSERT INTO thv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tesufeṭ ennét teqqal elkerwileten d iyyesan d messawesn. Awen tesufeṭ mǎqqeret. ");
INSERT INTO thv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Eweḍen édeg igan isem tǎɣerɣert tan Atad, denneg ǎɣǎher wan Elurdun. Déndɣ eslefen tǎseloft mǎqqeret, yexzen Yusef tis essa iheḍan. ");
INSERT INTO thv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wi ezzeɣnén akal, Kanƹaniten eneyen ǎxǎzan wah fol tǎɣerɣert tan Atad, ennen : « Awah ǎxǎzan yeṣṣohén fol Maṣar ! » Fol awén as édeg wéndɣ iǧa isem Abel-Miṣraym (elmeƹna ennét ǎxǎzan n Maṣar). ");
INSERT INTO thv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ḍeffer adih Dg Yaƹqub eǧen awa hasn yenna tisn : ");
INSERT INTO thv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","enbelent dɣ teɣaɣit tan Makfela, ɣor Mamré. Ibrahim a yezzenhen ǎmǎḍal wéndɣ fol Efron wan Ḥethit baš éd yumas isensa ennét. ");
INSERT INTO thv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","As yesmenda Yusef awa iteǧ, yeqqel Maṣar, enta d ayet-mas d ǎddunet wi ds eddéwnen emdan s ǎnebal n tis. ");
INSERT INTO thv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ḍeffer adih, ennen ayet-mas n Yusef ǧérésn : « Dimaɣ d eba abbannɣ, yeddobet Yusef éd yeqqel folnɣ, éd yerẓem tǎxellawt temda ta has neǧa. » ");
INSERT INTO thv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ezzar esseweyen ǎmahal i Yusef : « Arwah wr eba abba nnɣ, yenna haneɣ éd hak nen awah : ");
INSERT INTO thv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","« Ennet as i Yusef : inhod, soref i ayet-mak, soref ibekkaḍen nsn, soref erk iǧiten nsn. » Dimaɣ inhod ad tessorefed erk iǧiten n éklan n Messineɣ n tik. » Yeslef Yusef as tin yéweḍ ǎmahal waɣ. ");
INSERT INTO thv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Osent-in ayet-mas, enḍewen iman nsn dats, ennen as : « Kud teréd éd tekned dnɣ éklan ennek. » ");
INSERT INTO thv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yenna hasn Yusef : « Wr terméɣem. Wr eddobéɣ éd eǧǧeheɣ édeǧ n Messineɣ. ");
INSERT INTO thv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Teɣhelem ahi tǎxellawt, beššan Messineɣ yebbedel tǎxellawt s tihusay. Yeɣhel éd yennej ǎddunet ǎǧǧotnén hund awa henneyem itaǧ émér waɣ. » ");
INSERT INTO thv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Dimaɣ wr terméɣem, éd folwn ewwekeleɣ, kewenéḍ d ǎddunet nwn. » Iǧasn awal yeẓéden, awal n tǎhanint yeḍasen ulawen nsn. ");
INSERT INTO thv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Aqqimen Yusef d ǎddunet ennét d ǎddunet n tis dɣ Maṣar. Téweḍ tǎmeddort n Yusef téméḍé n ǎwetay d meraw. ");
INSERT INTO thv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yeney tiwit n arrawen d iheyawen n rurés Efraym, yessedwel arrawen n aheya ennét Makir, ag Mensi. ");
INSERT INTO thv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ahel iyyen yenna Yusef i ayet-mas : « Deroɣ d-iǧen éheḍin. Éd kewen-d yas Messineɣ. Éd kewen isefel Maṣar, éd kewen yer ǎkal was yeheḍ édt yekf i Ibrahim, Isḥaq d Yaƹqub. Inhodet a hi téweyem. ");
INSERT INTO thv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yezheḍ Yusef Dg Israyil : « As kewen-d yosa Messineɣ, awyet éɣesanin » ");
INSERT INTO thv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","As eba Yusef dɣ Maṣar ila téméḍé n ǎwetay d meraw. Eǧen as elɣetren baš édt agẓin, eǧent dɣ essendoq.");
INSERT INTO thv_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Dɣ ezzeman wa dɣ eḥkamen elqaḍiten dɣ ǎkal wan Israyil, yeǧǧeh laẓ ǎkal. Fol awéndɣ as yegla ales iyyen n aɣrem n Beytlaḥm dɣ ǎkal n Yehuda, yeddew d hennis d meddans essin ; ezzeɣen dɣ ǎkal n Mowab. ");
INSERT INTO thv_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ales weéndɣ isem ennét Alimelek, hennis isem ennét Naɣomi, d meddans ismawen nsn Maxlon d Kilyon ; tǎqqǎbilt ennét tan Kél Efrata, win Beytlaḥm. A yekka ezzaɣen dɣ ǎkal n Mowab, ");
INSERT INTO thv_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","eba Alimelek, ales wan Naɣomi, teqqim ɣas ennét, enta d meddan-s. ");
INSERT INTO thv_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Wiɣ essin eddéwen d téḍéḍén n Mowab, iyyet isem ennét Orfa, ta heḍet isem ennét Raɣut. Ezzeɣen déndɣ ɣor meraw iwetyan. ");
INSERT INTO thv_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ezzar eba aked Maxlon d Kilyon, issenen ésn, teqqim Naɣomi ɣas ennét, ebas tela la meddans la ales ennét. ");
INSERT INTO thv_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","A yekka teha ǎkal n Mowab, tesla Naɣomi as Amaɣlol yesres-d elxér wa ɣors illen fol win ǎkal ennét, yekfén allon. Dédih tenker tefel ǎkal n Mowab, teqqel ǎkal ennét, teddéw d tiḍulén ennét issenetén. ");
INSERT INTO thv_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Eglenet ǎddéwnet, ekkenet ǎkal n Yehuda, beššan dɣ ǎbǎreqqa, ");
INSERT INTO thv_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","tenna hasnt Naoɣmi : « Egelmet, ǎqqelmet ihenan n matték-mt. É Messineɣ a kemet isseknen elxér hund wa hi tesseknemet, isekné i inemmutan-nnɣ. ");
INSERT INTO thv_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","É Messineɣ a kemet yekfen tǎmeddort tolaɣet dɣ ihenan n médden wiyaḍ ! » Temmullet asnt ezzar eskelelnet hullan. ");
INSERT INTO thv_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ennenet as : « Kela ! Éd dm nidaw s ǎkal ennem. » ");
INSERT INTO thv_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Tenna hasnt Naɣomi : « Egelmet, tibaraḍénin, mafol teramet éd dɣi tidawmet ? Taɣélmet ǎddobéɣ éd arweɣ ales kemet yéweyen ? ");
INSERT INTO thv_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Egelmet tibaraḍénin, egelmet, édét tewǎhré a eǧéɣ, ebas ǎddobéɣ éd eǧeɣ éhen. Aked kud enneɣ : “Eǧareɣ eṭṭema, éheḍ waɣ éd idaweɣ, éd ekreheɣ arrawen”. ");
INSERT INTO thv_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Tǎddobetmet éd tẓeẓẓidermet ad edwelen ? Tǎddobetmet éd tǎqqeymimet wr teddéwmet ar déndɣ ? Bo, bo ! Tibaraḍénin, wr hi telkémmet. Édét nk a yoẓer Amaɣlol hullan. » ");
INSERT INTO thv_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Eskelelnet hullan arwah, dédih Orfa temmullet i taḍeggal ennét ezzar tegla tǎqqel imalan ennét, beššan Raɣut, tadih, tuǧey éd tt tefel. ");
INSERT INTO thv_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Tenna Naɣomi i Raɣut : « Ekid, tǎleggest ennem tǎqqel ǎddunet ennét d messineɣen-ennét. Eǧ hund enta, ǎqqel innem. » ");
INSERT INTO thv_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Baššin tenna has Raɣut : « Wr hi teššewwešed baš éd kem afleɣ éd egleɣ, édét is tekkéd, éd-t ekkeɣ ; id tenséd éd ds enseɣ ; ǎddunet ennem éd umasin ǎddunetin d messineɣ ennem éd yumas messineɣin. ");
INSERT INTO thv_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Id temmuted éd ds ǎmmǎteɣ, déndɣ ad éd enbeleɣ. Yaǧét ahi Amaɣlol tasnit ta mǎqqeret kud weǧǧén tǎmettant ɣas a hi yezimezzeyen dm ! » ");
INSERT INTO thv_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","As teney Naɣomi as Raɣut teǧlay, tera éd ds tidaw, tebboṭṭel. ");
INSERT INTO thv_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Eglenet essenetén éweḍnet Beytlaḥm. Tisit nsnt dɣ Beytlaḥm tǎmos a yemunen. Ennenet téḍéḍén : « Awarɣ Naɣomi méɣ ? » ");
INSERT INTO thv_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Tenna hasnt Naɣomi : « Ǎbas hi tǧannémet Naɣomi, (tas tenǧeḍ ; enǧom d eǧéɣ isem wan Naɣomi ǎmoseɣ tǎmǎṭ n tǎmejjeɣrort), eɣrimet ahi s Mara, (ta teǧrew tasnit), édét Messineɣ wan Ǎneddabu yeswer ahi tasnit. ");
INSERT INTO thv_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Efeleɣ ǎkal waɣ eɣmareɣ, yerra hid Amaɣlol ǎqqoren ifassenin ! Mafol ɣarremet ahi s isem wan Naɣomi arwah, édét Amaɣlol yekkes foli elbaraka ennét, yeswer ahi Ǎneddabu tasnit ? » ");
INSERT INTO thv_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Hund awéndɣ a teǧa Naɣomi tefel-d ǎkal wan Mowab teddéw d tǎḍeggalt ennét Raɣut, telmowabit. Osenet Beytlaḥm dɣ elwaq n ibri. ");
INSERT INTO thv_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Berén aɣil wan ales ennét, toŋŋat Naɣomi d ales iyyen. Enta ales n ǎnesbeɣor ilan serho, in ǎddunet win Alimelek, isem ennét Boɣaz. ");
INSERT INTO thv_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Tenna Raɣut tan telmowabit i Naɣomi : « Ey ahi éd ekkeɣ iferǧan éd ekkemuɣ tihemmarén ti tayyen inafrasen. Éd aseɣ iyyen dsn teha tamella éd hi yey éd ekkemuɣ tikmutén ḍeffers. »Tenna has Naɣomi : « Emhel, tǎbǎraṭin. » ");
INSERT INTO thv_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tegla Raɣut taqqim tikmut dɣ iferǧan, ḍeffer inafrasen. Yéwey tt eẓẓeher ennét s ǎfǎraǧ wan Boɣaz, wa yoŋŋaten d Alimelek. ");
INSERT INTO thv_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ḍeffer adih, yos-d Boɣaz, yefal-d Beytlaḥm. Yesseslem inafrasen, erren as-d esselam. ");
INSERT INTO thv_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Yessesten Boɣaz akli wa yǎmosen amɣar n inafrasen, yenna has : « Mi ilen tašaɣet tén ? » ");
INSERT INTO thv_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Yenna has akli : « Tašaɣet téndɣ enta as telmowabit, ta-d toset tǎddéw d Naɣomi. ");
INSERT INTO thv_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Tenna haneɣ éd tt ney éd tekkemet tihemmarén ti ratteknén ḍeffer inafrasen. Tos-d tella deh, mn tufat ar dimaɣ, énéh iyyen a teǧa zernah hin teǧa haret n tǎsonfat. » ");
INSERT INTO thv_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Dédih yenna Boɣaz i Raɣut : « Seǧed ahi, tǎbǎraṭin, wr teqqimed tikmud dɣ iferǧan wi heḍnén, ɣayem déɣ, erti d téklaténin. ");
INSERT INTO thv_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ekid édeg wa-d farressen, d telkemed i téḍéḍén ti tikmutnén. Elmed as ennéɣ asn i éklanin éd kem akfin elɣafét. Kud yeŋɣim fad, egel esu aman dɣ teqqelilen ti-d ehraǧen inaxdamen. » ");
INSERT INTO thv_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Dédih terkeƹ Raɣut dat Boɣaz, tenna has : « Mafol eǧreweɣ ɣork sémɣar d tǎhanint, nk ta wrt tǎmos ar tǎɣǎribt ? » ");
INSERT INTO thv_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Yenna has Boɣaz : « Awa hi yǎhéwelen tidet, awa teǧéd i tǎḍeggalt ennem imda as eba ales ennem, menék awa teǧéd tefeled tim, mam d ǎkal ennem baš éd tekked ɣor ǎddunet wr tezzéyed a tewéd, ula enḍahel ula ǎhendin sl enḍahel. ");
INSERT INTO thv_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","É Messineɣ a ham yerren awa teǧéd, teǧrewed elkera mǎqqeren ɣor Amaɣlol, Messineɣ n Israyil, dag tifakfakén ennét a dd toséd teǧmayed éfi ! » ");
INSERT INTO thv_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Tenna : « Key teɣlaled foli hullan. Tekféd ahi tǎhulet s awal wa yehoseyen hi teǧéd, nk, taklit ennek, tas wr togdé elqima ula d iyyet dɣ téklatén ennek. » ");
INSERT INTO thv_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Émér wan ameklu, yenna Boɣaz i Raɣut : « Aheẓ, ekš tagella tah, selmeɣ aɣrum ennem dɣ eḍǎraẓ wan elxel. » Taqqim édés n inaxdamen, yekfét Boɣaz téɣwaw. Tekna téwant, yeqqim-d. ");
INSERT INTO thv_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","As tǎqqel éd tekkemet, yenna Boɣaz i éklan ennét : « Eyyet tt tikmut aked ǧér tizzemén, d tekfim tt elɣafét. ");
INSERT INTO thv_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ekkeset aked heret n tihemmaren dɣ tizzemén nwn, eyyet as tnt éd tnt tǎkkemet. Wr has teǧém ǎsekor. » ");
INSERT INTO thv_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Tikmut Raɣut dɣ ǎfǎraǧ ar almeẓ, teddǎh, teffufferet, teṭker ǎbelboḍ mǎqqeren n timẓén. ");
INSERT INTO thv_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Téweyt, teqqel aɣrem, teney tǎḍeggalt ennét awa tekkemet imda. Tekfét aked awa-d eqqimen dɣ ameklu ennét. ");
INSERT INTO thv_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tenna has tǎḍeggalt ennét : « Menid tekkemed ahel waɣ ? Mi ilen ǎfǎraǧ wa dɣ texdemed ? É Messineɣ has iǧen erramet dɣ arrezɣen ennét. » Tenna has Raɣut : « Ales wa ɣor exdemeɣ ahel waɣ isem ennét Boɣaz. » ");
INSERT INTO thv_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Tenna has Naɣomi : « Ales wéndɣ in ǎddunet-nnɣ, yǎmos iyyen dɣ wi fol yeqqel aššil éd haneɣ iken taɣara, édét iyyen dɣ inebdiden-nnɣ. Amaɣlol wr yettewet elxér wa haneɣ iteǧ, itaǧǧé i inemmuttan-nnɣ ! » ");
INSERT INTO thv_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Tenna has telmowabit : « Yenna hi aked in addobeɣ éd tikmuɣ ḍeffer inafrasen ennét ad semmendun ǎfǎras imda. » ");
INSERT INTO thv_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Tenna has Naɣomi : « Yuf awéndɣ, tǎbǎraṭin, ɣayem tertayed d téklatén n Boɣaz, hékem, wr kem yeḍḍasét ǎwadem dɣ ǎfǎraǧ iyyen heḍen. » ");
INSERT INTO thv_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Tegla Raɣut tikmut tertay d téklatén n Boɣaz ad efresen éred d timẓén. Tenimezzaɣ d tǎḍeggalt ennét. ");
INSERT INTO thv_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ahel iyyen, tenna Naɣomi i Raɣut : « Tǎbǎraṭin, wr yuf éd ham aseɣ éhen dɣ teǧrewed elxér ? ");
INSERT INTO thv_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Tessaned as Boɣaz, waydɣ km yoyyen tennéxdemed d téklatén ennét, iyyen dɣ ǎddunet-nnɣ a yǎmos. Eywah éheḍ waɣ itizezzerut timẓén dɣ teɣǎrɣert. ");
INSERT INTO thv_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Séred, eǧ aḍuten wi ǎẓédnén, els aselso ennem wa yǎhoseyen d tersed s teɣǎrɣert, beššan hékem wrt tessekned iman ennét ad isemmendu téteté d tésesé. ");
INSERT INTO thv_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","As yensa, ekid édeg wa dɣ éd yemel. Dédih aheẓ, eken édeg dag elfersada ǎtǎram ennét, d tensed. Dédih éd ham illeɣet iman ennét awa hé teǧed. » ");
INSERT INTO thv_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Tenna has Raɣut : « Awa hi tennéd imda édt eǧeɣ. » ");
INSERT INTO thv_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Dédih teres s teɣǎrɣert, teǧa awa has tenna tǎḍeggalt ennét imda. ");
INSERT INTO thv_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Yekša Boɣaz, yeswa, ezzar yezha dɣ iman ennét, yegla yensa édés n tǎdebbont ennét n timẓén. Ezzar toheẓ-in Raɣut sollan, tekna édeg dag elfersada daw éḍaren ennét ezzar tensa. ");
INSERT INTO thv_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","As iǧa émér iyyen dɣ éheḍ, yehkeḍkeḍ ales, yebreɣwel, teǧrewt tǎkunt n tǎmǎṭ tah tenset daw éḍaren ennét. ");
INSERT INTO thv_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Yenna has : « Ma tǎmosed, kem? »Tenna has : « Nk Raɣut, taklit ennek. Ettareɣ dk udem baš éd hi tagẓed édét key iyyen dɣ ibebdiden-nnɣ. » ");
INSERT INTO thv_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Yenna has : « É Messineɣ a kem ikfen elbaraka, Raɣut ! Elxér wa teǧéd i tǎḍeggalt ennem yǎhosey ; dimaɣ tessikned iyyet tehreyet tufet aked ta tezzaret, édét wr teǧméyed tera n médden meḍriynén, ula inesbeɣar ula tilaqqiwén. ");
INSERT INTO thv_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Adih dimaɣ, wr teksoḍed ! Éd eǧeɣ awas hi tennéd, dɣ aɣrem wrt illé éré wrn yessén as tǎmǎṭ tolaɣet a tǎmosed. ");
INSERT INTO thv_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Tidet as ǎnabdad ennem a ǎmoseɣ beššan illé iyyen heḍen d-yoraken serem illǎha hid. ");
INSERT INTO thv_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Sikey éheḍ déɣ, as yeffo éd nessen yera éd kem yeɣlef méɣ kela. Kud yebok as yeǧé-t, kud kela, ǎhaḍeɣ-am, s Amaɣlol wa yedderen, ar éd km-d erreɣ, eǧéɣ am awa hi yeweren. Dimaɣ ens ar tufat. » ");
INSERT INTO thv_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Tǎqqim tensa ɣor éḍaren ennét ar s tufat, ezzar tenker s ihokhaken, dɣ émér wéndɣ-d wr yeddobet ǎwadem éd izemmeẓli ǧér ǎbǎggi d eydi, méɣ ǧér ales d tǎmǎṭ. Wr yeré Boɣaz éd elmeden ǎddunet in tos-in dɣ teɣǎrɣert. ");
INSERT INTO thv_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Yenna has dédih : « Awid afer wa tesiwered éɣef ennem, d tekned as oḍuf. » Taṭṭeft, yeṭkel seḍiset tiẓiwawén n timẓén, yeǧas tnt ds, yellil as teswer tnt éɣef ennét, ezzar yeqqel aɣrem. ");
INSERT INTO thv_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Tosa Raɣut ɣor tǎḍeggalt ennét, tenna has tǎḍeggalt : « Ma hin iǧen tǎbǎraṭin ? »Teǧas Raɣut isǎlan n awa has iǧa ales wah imda. ");
INSERT INTO thv_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Tenna Raɣut daɣ : « Yekfa hi seḍiset tiẓiwawén tiɣ, yenna hi : “Wr tǎqqel-d ɣor tǎḍeggalt ennem tǎsibekbeked ifassen.” » ");
INSERT INTO thv_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Tenna has Naɣomi : « Zeẓẓider déɣ, tǎbǎraṭin, ad telmeded taɣera n eššeɣel waɣ. Wr éd yeǧrew Boɣaz imnay ad tefru ahel waɣ ! » ");
INSERT INTO thv_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Yekka Boɣaz émi n aɣrem, yeqqigm, émér iyyen yokey-in ales wanǧam s iganna, wa yoŋŋaten d Alimelek. Yenna has Boɣaz : « Aheẓ, ɣayem deh. » Yoheẓ in ales, yeqqim. ");
INSERT INTO thv_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Dédih yeɣra Boɣaz meraw imɣaren n aɣrem, yenna hasn : « Γeymet deh », ǎqqimen. ");
INSERT INTO thv_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Yenna has i ales wanǧam : « Ǎfǎraǧ wan eŋŋa- nnɣ Alimelek, zanhé hin Naɣomi, ta-d tefelet ǎkal n Mowab. » ");
INSERT INTO thv_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Yenna has : « Ǎfǎraǧ waɣ id-t izzenhen telléd asd seres key, édét key wa yezzaren, édét key a yoŋŋaten d Alimelek, awaɣ as ak tn ennéɣ dat imɣaren-nnɣ éd ǎmosen tiǧuhawén, kudét zanhéd-t, ennén dɣ eljemat, kudét wrt teréd ennén dɣ eljemat, éd nelmed awa hé yeǧin, édét key ǎmuzer, nk ḍefferk ad elléɣ, nk, as tennéd nk wr teǧǧed awaɣ, tekféd-i tefért ennek n-innin wrt eddobéɣ awaɣ éd-t aǧeɣ, eǧé key, ɣor déndɣ éd awreɣ nk. » Yenna has ales wah : « Ayoh, ǎréɣ édt zenheɣ. » ");
INSERT INTO thv_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Beššan yenna has Boɣaz : « Ahel wa-d éd tzenhed ǎfǎraǧ wéndɣ fol Naɣomi, éd tzenhed aked Raɣut telmowabit, hennis n wa eba, baš éd tekrehed arrawen hé umasnin meddans n wa eba fol tǎkasit ennét. » ");
INSERT INTO thv_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Yenna has ales wanǧam : « Γor déɣ-d iǧǧeh ǎdewenné wan tediwt, nk ahel waɣ eǧmeḍeɣ. Wr eréɣ éd zenheɣ, édét wr eréɣ éd enfeẓeɣ tela-hin. Oyyéɣ ak édeg, zenh key, nk wrt eddobéɣ. » ");
INSERT INTO thv_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Dɣ ezzeman wéndɣ dɣ Israyil, tellé elɣada tah, tamos tǎmǎtart : ɣor inezzan méɣ ɣor ǎsemmeskel n heret, as tekna taɣera iyyet, éd yekkes ǎwadem eɣǎtém ennét édt yekf i wa heḍen. Awéndɣ a yǎmosen tǎǧuhé. ");
INSERT INTO thv_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Yenna ales wanǧam i Boɣaz : « Zenh key. » Ezzar yekkes eɣǎtém ennét. ");
INSERT INTO thv_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Yenna Boɣaz i imɣaren d ǎddunet widt ellenén emdan : « Tešhadem ahel waɣ as zanhéɣ i Naɣomi, tela d ǎrrezɣen n Alimelek emdan d win Maxlon d Kilyon meddans, ");
INSERT INTO thv_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","éweyeɣ aked Raɣut telmowabit, hennis n Maxlon, baš éd teqqayem tǎkasit n Maxlon dɣ ǎddunet ennét, baš éd yedder isem ennét ǧér ayet-mas d dɣ émi n aɣrem waɣ. Ahel waɣ tešhadem fol awén. » ");
INSERT INTO thv_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ǎddunet emdan wi ellenén ɣor émi n aɣrem ennen : « Nešhad »; ennen imɣaren : « É Messineɣ a yessolen tǎmǎṭ ta hé teǧǧehet ihenan ennek d Rašél d Leya, essenetésnet, annǎtén n Kél-Israyil. É Messineɣ a key yekfen isem déɣ, dɣ Beytlaḥm d tela déɣ, dɣ Efrata. ");
INSERT INTO thv_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","É Messineɣ a key yerzeɣen s inuba dɣ tǎmǎṭ taɣ, yumasét éhen ennek hund wan Fereṣ, wa térew Tamar i Yehuda. » ");
INSERT INTO thv_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Yéwey Boɣaz Raɣut. Éheḍ héndɣ ad iǧa éhen, yerzeɣt ds Messineɣ s arraw n éy. ");
INSERT INTO thv_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ennenet téḍéḍén i Naɣomi : « Elbaraka n Messineɣ wa kem yekfen ahel waɣ wa kem éd yagẓin. Yetwezzayét isem ennét dɣ Israyil ! ");
INSERT INTO thv_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Éd kem-d yer s tǎmeddort, éd ham yilal dɣ tewǎhré ennem. Édét mas ta-d térewet tessimɣer kem, tufam essa arrawen. » ");
INSERT INTO thv_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Teṭkel Naɣomi arraw, teswert éfef ennét, enta adt yessedwelen. ");
INSERT INTO thv_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ennenet tinaraǧén : « Tekreh Naɣomi arraw. » Eǧenet as isem Γubeyd. Γubeyd waɣ a yérewen Yessa, tis n Dawud. ");
INSERT INTO thv_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Awah abbaten n Dawud mn Fereṣ : Fareṣ tis n Hesron, ");
INSERT INTO thv_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron tis n Ram, Ram tis n Amminadab, ");
INSERT INTO thv_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Amminadab tis n Našon, Našon tis n Salmun, ");
INSERT INTO thv_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmun tis n Buɣaz, Buɣaz tis n Γubeyd, ");
INSERT INTO thv_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Γubeyd tis n Yessa, Yassa tis n Dawud.");
INSERT INTO thv_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Ahel iyyen Amaɣlol yesséwel i Yunan ag Amitay, yenna has : ");
INSERT INTO thv_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","« Enker, as Niniwa, aɣrem wa mǎqqeren, zemmeheḍ fols ! Édét isalan tǎxellawt n ǎddunet ennét éweḍen ahid. » ");
INSERT INTO thv_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Dédih yenker Yunan, yennehel Taršiš, yerwal fol Amaɣlol. Yeres s Jaffa, yosa elbabor iyyen yekkan Taršiš ; yerẓem édeg ennét, yéwen yertay d inaxdamen n elbabor wi ekkenén Taršiš, yerwal fol Amaɣlol. ");
INSERT INTO thv_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Beššan yesheḍ Amaɣlol aḍu fol aman, teǧa téǧént mǎqqeret fol ǧeréw. Ar deroɣ yerreẓẓa elbabor. ");
INSERT INTO thv_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ermeɣen inaxdamen, ak iyyen yesiɣeret i messineɣ ennét, eggaren ilalen dɣ aman baš éd sifsasen. Yunan, wadih yeres dɣ édér n elbabor, yensa, yekna éḍes. ");
INSERT INTO thv_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Amɣar n elbabor yoheẓt, yenna has : « Mafol teṭṭased ? Enker, seqqeret i messineɣ ennek ! Tigenén messineɣ wah éd isismaḍ folnɣ, wr éd nemmet. » ");
INSERT INTO thv_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ennen ǧér essen : « Aset-d, éd neǧ isaɣéren, baš éd nelmed ma yǎmos wa hanɣ-d yéwayen elɣar. » Esséwelen isaɣéren fol Yunan. ");
INSERT INTO thv_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ennen as dédih : « En anɣ ma haneɣ yoseɣen d elɣib wah. Ma ǎmosen eššeɣlen ennek, mis-d tefeled ? Ma yǎmos ǎkal ennek, ma tǎmos ellamet ennek ? ");
INSERT INTO thv_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yenna hasn : « Nk Ƹibrani, eksoḍeɣ Amaɣlol, Messineɣ n iǧennawen wa yexleken ǧeréw d ǎmǎḍal. » ");
INSERT INTO thv_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yenna Yunan i médden wih in yerwal fol udem n Amaɣlol, eknen tǎremméq, ennen as : « Ma tǎmos tekunt ta haneɣ teǧéd deh ? » ");
INSERT INTO thv_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ennen a-s : «  Ma hak éd neǧ, baš éd yehdu ǧeréw folnɣ ? » Aman ǎsséten ǎmussu. ");
INSERT INTO thv_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yenna hasn : « Ǎṭṭefet ahi, enḍewet ahi dɣ ǧeréw baš éd yehdu folwn ; édét essaneɣ as nk a hawen-d yéwayen aḍu waɣ mǎqqeren. » ");
INSERT INTO thv_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Médden eṭṭefen tiboryén nsn tis saglen elbabor, esmessen tnt eǧmayen éd awḍin ǎmǎḍal beššan yenderen asn, édét ǧeréw yekna ǎweššen folsn. ");
INSERT INTO thv_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Dédih eɣren Amaɣlol, ennen : « Amaɣlol, inhod, wr nemmetét dɣ érét n iman n ales wah, wr haneɣ teswered ahni n ales wrn haneɣ yeɣhéden ula enḍerren ! Édét, key é Amaɣlol, teǧed awa teréd. » ");
INSERT INTO thv_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ezzar eṭkelen Yunan, enḍewent dɣ ǧeréw, dédih yeššem-in ǧeréw dɣ ǎweššen. ");
INSERT INTO thv_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Médden wih, eknen tuksaḍa mǎqqeret i Amaɣlol. Eǧen as takuté, esmeḍrenen. ");
INSERT INTO thv_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yesséwey-in Amaɣlol ǎsolmi mǎqqeren, yelmeẓ Yunan, yeqqim Yunan dɣ tesa n ǎsolmi keraḍ ihilan d keraḍ iheḍan. ");
INSERT INTO thv_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Dɣ tesa n ǎsolmi, yeqqim Yunan itimuhud fol Amaɣlol, Messineɣ ennét, yenna : ");
INSERT INTO thv_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","« Dɣ mihi, eɣréɣ Amaɣlol, Yǎjeweb ahi ; Dɣ ammas n ǎkal n inemmuttan, eǧmeyeɣ telilt, Tesgeded i awalin. ");
INSERT INTO thv_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Tenḍew-d ahi dɣ édér n ǧeréw, Tihiw n aman eɣleynet ahi ; Tihiw emdanet, aman emdan okeyen foli. ");
INSERT INTO thv_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Nk ǧannéɣ dɣ imanin : “Etwestaɣeɣ, oǧeǧeɣ ǎhenay ennek ! Beššan abedǎh eǧareɣ eṭṭema n éd eyneɣ éhen ennek wan ǎmud wa heddigen.” ");
INSERT INTO thv_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Aman éweḍen ahi ar tǎkorseyt, Tihay eɣleynet ahi, Tǎleggit tekres fol éɣefin. ");
INSERT INTO thv_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Ereseɣ ar ikéwen n tidreɣén, ǎmǎḍal yergelen foli tinassén ennét ar abedǎh ; Beššan tesseǧmeḍed ahí-d anu eddareɣ, É Messineɣ, Amaɣlolin ! ");
INSERT INTO thv_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Awad edhašen imanin dɣ ammasin, Ektéɣ-d Amaɣlol, tittarin éweḍnet key, éweḍnet éhen ennek n ǎmud wa heddigen. ");
INSERT INTO thv_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Wi elkemnén i elṣnam wrn elé tenfa, wr ilkém éd ennejjin. ");
INSERT INTO thv_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Nk, éd hak eǧeɣ tikutawén, timmuyuɣ ǎsiɣeréɣ, Awas ennéɣ édt eǧeɣ, tidet as édt eǧeɣ : ǎnejji wr-t iteǧ ar Amaɣlol. » ");
INSERT INTO thv_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Dédih yesséwel Amaɣlol i ǎsolmi, yoq-d Yunan fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Yesséwel Amaɣlol i Yunan animér, yenna has: ");
INSERT INTO thv_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","« Enker, ek Niniwa, aɣrem wa mǎqqeren, siweḍ ǎmahal was hak ǧannéɣ ! » ");
INSERT INTO thv_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Dédih dimaɣ yenker Yunan, yekka Niniwa, hund awa has yenna Amaɣlol. Niniwa, aɣrem iknan tezzuhert, elzamen keraḍ iheḍan baš éd tt tejjered. ");
INSERT INTO thv_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yerreǧeh Yunan dɣ aɣrem ahel iyyen. Yesiɣeret, iganna : « Eqqimen ekkoẓet temerwén n ahel baš édt tehheddem Niniwa ! » ");
INSERT INTO thv_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Eflesen ǎddunet win Niniwa Messineɣ ; enmeknen fol aẓum, elsen eššekaretén, ɣor wa mǎqqeren ar wa enḍukken. ");
INSERT INTO thv_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Eweḍen isǎlan ǎmǎnokal n Niniwa ; yezzenkeh fol eṭṭebel ennét, yekkes ǎbernuh ennét wan temmenukela, yelsa eššekaret ezzar yeqqim fol éẓed. ");
INSERT INTO thv_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Yeswenna awah dɣ Niniwa : « Awah awa ennen ǎmǎnokal d imɣaren ennét : “Ǎddunet d éheré, aked éswan, wr tettim, wr sessim ! ");
INSERT INTO thv_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Ǎddunet d éheré d éswan éd elsin eššekaretén, éd seqqerin i Messineɣ s eṣṣahet, ak iyyen yemmuǧreẓ fol erk iǧiten ennét d tǎxellawt ta tehet ǎdékel ennét ! ");
INSERT INTO thv_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Tigenén Messineɣ éd yemmuǧreẓ, éd ismaḍ fol ǎweššen ennét, dédih tigenén wr éd nemmet ?” » ");
INSERT INTO thv_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Yeney Messineɣ in ǎmmuǧreẓen fol erk iǧiten nsn. Yeqqel-d fol tǎxellawt tas yebok éd tt yeǧ kud wr ǎmmuǧreẓen. ");
INSERT INTO thv_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Awén wr yeǧréẓ fo i Yunan, yewweššen. ");
INSERT INTO thv_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Yenna i Amaɣlol : « É Amaɣlol, awén essaneɣ ss arwah ehéɣ ǎkalin ? Awéndɣ as eǧléɣ erwaleɣ ekkéɣ Taršiš. Édét essaneɣ as tǎmosed Messineɣ n tǎhanint, teha ellemana, wrn iteweššin hik, yeṭkaren tihusay, hin iṭaṭṭefen tǎxellawt ta fol iǧa hik. ");
INSERT INTO thv_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Dimaɣ, Amaɣlol, ekkes dɣi iman, édét essoféɣ tǎmettant i tǎmeddort. » ");
INSERT INTO thv_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Yessestent Amaɣlol : « Teẓẓaled as tawwiššened ? » ");
INSERT INTO thv_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yeǧmeḍ Yunan aɣrem, yeqqim berén aǧmoḍ n tǎfuk. Yekna ǎkǎber déndɣ, yeqqim ds, baš éd yeney awa itaǧǧen dɣ aɣrem. ");
INSERT INTO thv_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Amaɣlol Messineɣ yessenker ašek iyyen denneg Yunan baš éd has yeǧ télé fol éɣef ennét, baš éd isesmeḍ anḍerren fol ǎweššen ennét. Yeddewet Yunan hullan fol ašek wah. ");
INSERT INTO thv_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Beššan as yeffo, ɣor ihokhaken, yesséwey-in Messineɣ tawekké tekšet ašek, ad yeqqor. ");
INSERT INTO thv_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","As tenker tǎfuk, yessewey-in Messineɣ ǎhoḍ d-ifalen aǧmoḍ n tǎfuk, tǎfuk teha dɣ éɣef n Yunan, ad deroɣ yenɣalef. Yesmeḍren tǎmettant, yenna : « Ǎssofeɣ tǎmettant i tǎmeddort. » ");
INSERT INTO thv_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Yessesten Messineɣ Yunan, yenna has : « Teẓẓaled as tewwiššened dɣ érét n ašek ? » Yenna Yunan : « Eẓẓaleɣ as ewwiššeneɣ ad esmeḍreneɣ tǎmettant. » ");
INSERT INTO thv_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Yenna Amaɣlol : « Teŋɣik tamella n ašek fol wr teknéd heret, weǧǧén key adt issenkeren, yenker dɣ éheḍ iyyen, ahel wa heḍen yemmut. ");
INSERT INTO thv_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Nk, dédih wr hi éd teŋɣ tamella n Niniwa, aɣrem mǎqqeren, aɣrem ehan denneg téméḍé d senatet temerwén n aǧim n ayt-adem wrn essén ǎzemmeẓli n aɣil d tǎhalǧé nsn, aked ǎxxuten ǎǧǧotnén. »");
INSERT INTO thv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eɲa Teofiles, eggeten wi eǧmeynén éd ekteben isǎlan n awa iǧen ǧérénɣ, ");
INSERT INTO thv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","hund awa hasn tn eǧen imašhaden wi tn eneynén s téṭṭawén nsn émér héndɣ d eǧen s tizaret. Wiɣ entenéḍ a yǎmosen imawayen n Awal n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Fol awén, aked nk, édét eknéɣ ǎgemay i isǎlan win tizaret, teǧǧeh ahi enniyet n éd tn ektebeɣ s emmek was tn elmedeɣ baš éd hak tn amleɣ s iyyen iyyen, eɲa Teofiles, ");
INSERT INTO thv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","baš éd tsellekened tidet n tifér ti telmeded. ");
INSERT INTO thv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dɣ ezzeman wa dɣ yǎmos Hérodes ǎmǎnokal n ǎkal n Yehudiya, illé amɣar n imerubay iyyen iǧan isem Zakariya, elant kél Abya. Hennis isem ennét Elizabét telét tawsit iyyet n dg Harun. ");
INSERT INTO thv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Essin éssen olaɣen dat Yaḷḷah, eknan ǎlekam i elḥaq d elwaṣiya tin Émeli. ");
INSERT INTO thv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Beššan wr elén arrawen, édét Elizabét tǎmeǧǧaǧrut, essin éssen weššaren daɣ. ");
INSERT INTO thv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ahel iyyen, itag Zakariya eššeɣel ennét dat Yaḷḷah édét tewaḍ tn-d meléla nsn enta d winnét. ");
INSERT INTO thv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Hund awa tenna elɣada tan imerubay, eǧen iseɣéren, yeqqel folas émér n éd yeǧǧeh dɣ Éhen wa Heddigen n Émeli, éd ds yeǧ ikrora. ");
INSERT INTO thv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A yekka Zakariya isikrurut, ǎddunet emdan timihuden dɣ ténéré. ");
INSERT INTO thv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Émér héndɣ yos-d ǎngelos iyyen n Émeli dat Zakariya, yebded aɣil wan aɣil n elmejmer wan ikrora. ");
INSERT INTO thv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","As-t yeney Zakariya, yeǧa tǎremméq mǎqqeret ezzar yeksoḍ hullan. ");
INSERT INTO thv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Beššan yenna has ǎngelos : « Wr teksoḍed, Zakariya, Yaḷḷah yesla i awa tettered : hennik, Elizabét, éd tekreh arraw, eǧ as isem Eḥya. ");
INSERT INTO thv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Éd key-d tas tǎdǎwit mǎqqeret, ǎddunet aggotnén éd eddewén fol tiwit ennét. ");
INSERT INTO thv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Edét éd yumas imaqqeren dat Émeli. Wr éd isas elboẓa ula a yǎmosen tésesé texmaret wl iyyet. Déndɣ d éd yeǧǧeh tesa n mas, éd yeṭker Unfas Heddigen. ");
INSERT INTO thv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Éd yer Israyiliten ǎǧǧotnén dɣ ǎbǎreqqa n Émeli, Messineɣ nsn. ");
INSERT INTO thv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Éd yeglâ dat Émeli s eṣṣahet d unfas win ennebi Eliya, baš éd iẓuheẓ ulawen n abbaten d meddansn ; baš éd-d isuɣel wi efelnén ǎbǎreqqa, éd tn-d yer s tayetté ta karrehen ǎddunet wi elenén udem dat Yaḷḷah ; hund awéndɣ éd isebded ǎddunet ojadnén i Émeli. » ");
INSERT INTO thv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yenna Zakariya i ǎngelos : « Menék awa hé eǧeɣ éd elmedeɣ as tidet a tgannéd ? Édét nk amɣar a ǎmoseɣ, henni aked enta weššar. » ");
INSERT INTO thv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yenna has ǎngelos : « Nk Jibril wa ibaddeden dat Yaḷḷah, ǎméheleɣ-d ɣork, éd hak siwleɣ, éd hak elleɣuɣ isǎlan wiɣ n elxér. ");
INSERT INTO thv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Awah tidet a hak ennéɣ, tidet hé tetbetet dɣ émér ennét ; beššan wr hi teflésed, fol awén éd yeṭṭef émi ennek, ǎbas teddobéd awal ar émér héndɣ. » ");
INSERT INTO thv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Émér héndɣ, ǎddunet eqqalen i Zakariya, ǎkunen folin yeqqim-in a yeǧǧén dɣ Éhen wa Heddigen. ");
INSERT INTO thv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","As zernah yeǧmeḍ-d, wr yeddobet éd hasn isiwel, elmeden as yemun as-d heret iyyen dɣ éhen wanǧam. Yeǧa sn tǎloǧamt beššan yendar as awal. ");
INSERT INTO thv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Adih as yesmenda Zakariya iheḍan ennét n ǎƹebad, yeqqel tǎɣǎhamt ennét. ");
INSERT INTO thv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Okeyen iheḍan, tessimrew Elizabét. Teffer awén semmoset tlil. Tenna dɣ iman ennét : ");
INSERT INTO thv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","« Awah ahi yeǧa Émeli : as foli yesres ǎsewaḍ ennét, yekkes ahi teɣaššimt ta eléɣ ǧér ǎddunet. » ");
INSERT INTO thv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","As okeynet seḍiset tlil, yesséwey Yaḷḷah ǎngelos ennét Jibril s taɣremt iyyet dɣ ǎkal n Jalila, teǧat isem Ennaṣira, ");
INSERT INTO thv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ɣor tǎmawaṭ iyyet teǧat isem Meryem, teggibbel i Yusef. Yusef wah, aheya n ǎmǎnokal Dawud. ");
INSERT INTO thv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yeǧǧeh-in ds ǎngelos, yenna has : « Esselam folm ! Km ta telet tǎhanint mǎqqeret n Émeli wa dm yeddéwen, teboreked ǧer téḍéḍén emdanet. » ");
INSERT INTO thv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tǎkun Meryem hullan fol awa has yenna, wr tessén elmeƹna n ǎseslam wah. ");
INSERT INTO thv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yenna has ǎngelos : « Wr teksoḍed, Meryem, édét Yaḷḷah yesres folm tǎhanint ennét. ");
INSERT INTO thv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Adih éd tsimrewed, éd tekrehed arraw, éd has teǧed isem Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Éd yeqqel imaqqaren, éd has itahawal Ag Ǎmaṭkal. Éd-t yekf Émeli Yaḷḷah eṭṭebel wan tis Dawud, ");
INSERT INTO thv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","éd imnukel ar abedǎh fol iheyawen n Yaƹqub, temenukela ennét wr éd temmendu. » ");
INSERT INTO thv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tenna has Meryem : « Man emmek n awén ? Edét nk wr ezzéyeɣ médden ?” ");
INSERT INTO thv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yenna has ǎngelos : « Unfas Heddigen éd-d yeres folm d eṣṣahet tan Ǎmaṭkal éd km yewer hund télé. Fol awéndɣ arraw wa yeqquddesen hé yiwin, éd i has itahawal Ag Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ekid, aked wlt mam Elizabét, dɣ tewehré ennét tessimrew, enta tas itahawal tǎmeǧǧaǧrut, teǧǧeh tallit ennét tan seḍiset. ");
INSERT INTO thv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Edét ula indaren i Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tenna has Meryem : « Taklit n Émeli a ǎmoseɣ, yeǧét awas i tennéd. » Ifel tt ǎngelos émér héndɣ. ");
INSERT INTO thv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Adih tenker Meryem dɣ iheḍan windɣ, tegla terored, tekka aɣrem iyyen dɣ tidreɣén n ǎkal wan Yehudiya. ");
INSERT INTO thv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Teǧǧeh tǎɣǎhamt tan Zakariya, tesseslem Elizabét. ");
INSERT INTO thv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Adih déndɣ d tesla Elizabét awal wan Meryem, tofrey i arraw ennét yeggad s tǎdǎwit dɣ tesa ennét. Émér héndɣ yeṭker tt Unfas Heddigen has yeswennen awah, ");
INSERT INTO thv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","teṭkel Elizabét emesli ennét, tenna : « Yekfim Émeli elbaraka ennét ǧer téḍéḍén emdanet, elbaraka ennét tella fol arraw wa ihen tesa ennem ! ");
INSERT INTO thv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma ǎmoseɣ as hi-d tas mas n Émeli-hin ? ");
INSERT INTO thv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Édét, ekid, émér wéndɣ d-esléɣ i ǎseslam ennem, arraw wa ihan tesa hin yegged s tǎdǎwit. ");
INSERT INTO thv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tengeḍ-am km ta teflaset édét éd yetbet awas ham yenna Émeli !” ");
INSERT INTO thv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dédih tenna Meryem : « S enniyetin, éd simɣereɣ Émeli, ");
INSERT INTO thv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ulin yeddiwet fol Yaḷḷah, emaɣlasin, ");
INSERT INTO thv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","édét yesres foli akeyad ennét, nk ta wrt tǎmos ar taklit ennét. Edét mn dimaɣ ar abedǎh, ayt Adem, éd hi gannen : tengeḍ am, ");
INSERT INTO thv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","édét Ǎneddabu yeǧa ahi a yeggén n tihusay. Enta was isem ennét yeqquddes, ");
INSERT INTO thv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","yǎmos tamella i wi-t ekṣoḍnén dɣ iwetyan ikét nsn ; ");
INSERT INTO thv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","yessekna terna n ǎfus ennét : yezmezzey ǎddunet wi yeṭker ettekebbor dɣ ulawen nsn. ");
INSERT INTO thv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yesres imenokalen d temenukela nsn, yeṭkel wi meḍruynén. ");
INSERT INTO thv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yeɣmer wi yeŋɣa laẓ, yesɣer wi eɣmernén. ");
INSERT INTO thv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yellil i Israyil, wa yǎmosen akli ennét : wr yettuwet tamella tas yenna éd tt yekf i abbaten nnɣ, ");
INSERT INTO thv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ibrahim d iheyawen ennét, ar abedǎh. » ");
INSERT INTO thv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Teqqim Meryem ɣor Elizabét ɣor keraḍet tlil, ezzar teqqel ihenan ennét. ");
INSERT INTO thv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yéweḍ émér wan térwa tan Elizabét, tekreh arraw. ");
INSERT INTO thv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Inaraǧen ennét d ǎddunet ennét, elmeden tamella ta mǎqqeret has iǧa Émeli, oheren ds tǎdewit. ");
INSERT INTO thv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","As okeyen ettam iheḍan ḍeffer tiwit, osen-d éd ezzeyenén arraw, eɣélen éd has eǧin isem n tis, Zakariya. ");
INSERT INTO thv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Beššan tuǧey asn mas, tenna hasn : « Kela, éd yeǧ isem Eḥya. » ");
INSERT INTO thv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ennen as : « Wrt illé ǎwadem wl iyyen dɣ ǎddunet ennem iǧan isem wan Eḥya !” ");
INSERT INTO thv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ezzar essestenen s tǎloǧamt tis n arraw, essestenent d isem was yera éd-t yeǧ i rurés. ");
INSERT INTO thv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yesseǧmey Zakariya elloḥ wa fol yekteb awah : « Isem ennét Eḥya. » Yeskerebbetten awén. ");
INSERT INTO thv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Γor déndɣ ǎméren émi d iles win Zakariya, yesnemmer Yaḷḷah yeṭkal awal ennét. ");
INSERT INTO thv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Inaraǧen emdan eksoḍen, efelen isǎlan édeg wéndɣ eɣleyen tidreɣén emdanet tin ǎkal wan Yehudiya. ");
INSERT INTO thv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Emdan wi has eslenén, yǎmos asn ettexmima, gannén : « Ma hé yumas arraw waɣ ? » Yemun as yesiwert Émeli ǎfus ennét. ");
INSERT INTO thv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariya, tis n arraw, yeṭkert Unfas Heddigen, iǧa awal n ennebi, yenna awah : ");
INSERT INTO thv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","« Tebareka Émeli, Messineɣ n Israyil, wa hin yosen, yennejja ellamet ennét. ");
INSERT INTO thv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yesséwey anɣ-d Ǎmaɣlas mǎqqeren dɣ iheyawen n akli ennét Dawud. ");
INSERT INTO thv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Awén awa yeswenna i ennebiten ennét wi eqqudesnén wan éru : ");
INSERT INTO thv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yenna haneɣ éd haneɣ yennej fol ihenǧa nnɣ, d imiksenen nnɣ. ");
INSERT INTO thv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yessekna tamella i abbaten nnɣ, ikuttu téséq ennét ta teqquddeset. ");
INSERT INTO thv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Awén, tahoḍé tas yeǧa Messineɣ i abba nnɣ Ibrahim éd hanɣ tt yekf, ");
INSERT INTO thv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yenna has éd hanɣ yennej fol ihenǧa nnɣ, éd haneɣ yey éd-t neƹbed wr neksoḍ, ");
INSERT INTO thv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","neqquddes, neẓẓal dats dɣ tǎmeddort nnɣ temda. ");
INSERT INTO thv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Key, arrawin, éd tumased ennebi n Ǎmaṭkal, édét éd tegled dat Émeli, éd has zehhuseyed ǎbǎreqqa ennét ");
INSERT INTO thv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","baš éd iselmed elɣelas i ǎddunet ennét s ǎsaruf n ibekkaḍen nsn, ");
INSERT INTO thv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","s tamella n ul n Messineɣ nnɣ. Hund awéndɣ éd d yas folnɣ yǎmos taffawt n ihokhaken, ");
INSERT INTO thv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","baš éd yeǧ taffawt i wi eqqimen dɣ tihay n éheḍ d dɣ télé n tǎmettant, éd hanɣ isuman ǎbǎreqqa wan esselamet. » ");
INSERT INTO thv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Idaggel arraw, ikarreh tayetté. Yeqqim dɣ ikalen win tinariwen ar ahel wa-d yosa ǧér ǎddunet win Israyil. ");
INSERT INTO thv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dɣ waɣ ezzeman, yenna Elqaysar Aɣestes ilzam éd téḍanen ǎddunet win ikellan wi etiwezzaɣnén n Romaniten emdan. ");
INSERT INTO thv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Méḍan wéndɣ yezzaren, as yenta, Kirinyus yǎmos amɣar n Surya. ");
INSERT INTO thv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ǎddunet emdan ekkan éd etweséḍanen ak iyyen dɣ aɣrem ennét. ");
INSERT INTO thv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aked Yusef, yefel Ennaṣira, dɣ ǎkal n Jalila, yekka Beytlaḥm, dɣ ǎkal n Yehudiya, déndɣ ad iwa ǎmǎnokal Dawud ; édét enta aheya n Dawud a yǎmos. ");
INSERT INTO thv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yegla éd yessejel iman ennét, enta d ta has teggibellet Meryem, ta tessimrewet. ");
INSERT INTO thv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Émér héndɣ d-ellan dɣ Beytlaḥm, tiwit téweḍ. ");
INSERT INTO thv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tekreh Meryem arraw ennét wa yezzaren, éy. Tesselsé tiksén, ezzar tessensé dɣ aɣlal wan éheré, édét abast illa édeg dɣ tǎɣǎhamt tan imegaren. ");
INSERT INTO thv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dɣ ǎkal wéndɣ, ellant imǎḍanen ensanén déndɣ, eḍanen éheré nsn. ");
INSERT INTO thv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yosén in ǎngelos n Émeli, yeɣley asn elmejd n Émeli yesimelewlew tn. Eknen tǎremméq. ");
INSERT INTO thv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Beššan yenna hasn ǎngelos : « Wr teksoḍem, ekidet, éwayeɣ awn-d isǎlan n elxér, hé egreẓnén hullan i ǎddunet emdan : ");
INSERT INTO thv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ahel waɣ dɣ aɣrem wan Dawud, yewawn ǎmaɣlas, enta Elmesiḥ d Émeli a yǎmos. ");
INSERT INTO thv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Éd hawen leɣteɣ ǎhamol, menék awa hé teǧim éd tezziyem : éd tasim arraw yelsa tiksén yensa dɣ aɣlal wan éheré. » ");
INSERT INTO thv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ezzar hik, ǎmunen-d ǎngelosen wiyeḍ heḍnén eknanén ǎǧut, efalen-d aǧenna, tamelen Yaḷḷah, gannén : ");
INSERT INTO thv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","« Elmejd n Yaḷḷah, dɣ iǧennawen win afella, esselamet fol ǎmǎḍal ɣor ǎddunet wi fol yeǧa sémɣar ennét ! » ");
INSERT INTO thv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","As eglen ǎngelosen, eqqalen aǧenna, ennen imǎḍanen ǧérésn : « Endawtet éd nk Beytlaḥm : ilzem éd neney awa iǧen, awa haneɣ yenna Émeli. » ");
INSERT INTO thv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ǎroreden in, as in éweḍen, eneyen Yusef d Meryem, d arraw yensa dɣ aɣlal wanǧam. ");
INSERT INTO thv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","As-t eneyen, essoɣelen i wi-t ellenén awa hasn yenna ǎngelos fol arraw wah. ");
INSERT INTO thv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","I hasn yeslen, éd yukan fol isǎlan wi taggen imǎḍanen. ");
INSERT INTO thv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meryem tadih, tageẓ dɣ ul ennét awas tsal imda, taxemmamt. ");
INSERT INTO thv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ḍeffer awén, eqqelen imǎḍanen eššeɣlen nsn, essimɣeren Yaḷḷah, tamelent fol awa eneyen d awas eslen, édét awéndɣ a hasn yahéwelen. ");
INSERT INTO thv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ahel wan ettam ḍeffer tiwit, yos-d émér wan eziyyen n arraw, yeǧa isem wan Ƹisa, isem was yenna ǎngelos dat esimrew n mas. ");
INSERT INTO thv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ezzar as yokey ǎṭehher n Yusef d Meryem hund awa tganna eššeriƹa tan ennebi Musa, eweyen arraw s Éhen wan ǎmud wa mǎqqeren dɣ Yerušelem éd ds seknin arraw i Émeli, ");
INSERT INTO thv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","hund awa yektaben dɣ eššeriƹa téndɣ n Émeli : « Ak ǎmahwar n éy, éd yemmeẓley i Émeli. » ");
INSERT INTO thv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yelzam asn aked éd egin takuté tas tganna eššeriƹa téndɣ : « Senatet tigerregerén méɣ senatet tidebrén meḍreynén. » ");
INSERT INTO thv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dɣ Yerušelem, illé ales iǧan isem Šimƹun. Ales wah yeẓẓal, yeksoḍ Messineɣ, yeqqal i wa hé yennejjin Israyil. Iwart Unfas Heddigen. ");
INSERT INTO thv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yessilmedt Unfas Heddigen as wr éd yemmet ar s kundebat yeney Elmesiḥ wan Émeli. ");
INSERT INTO thv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yosa éhen wan ǎmud yemhalt ss Unfas Heddigen. As in osen imerawen n Ƹisa eddéwen d arraw nsn baš éd has eǧin awa tganna eššeriƹa, ");
INSERT INTO thv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","yeṭṭef arraw dɣ ifassen ennét, yomel Yaḷḷah, yenna : ");
INSERT INTO thv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","« Dimaɣ, É Émeli, tegéd awas tennéd, teddobéd éd teyyed akli ennek éd-t iba dɣ esselamet. ");
INSERT INTO thv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Édét dimaɣ eneyeɣ s téṭṭawénin elɣelas ennek, ");
INSERT INTO thv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wa tezwejjeded dat eddunya temda : ");
INSERT INTO thv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yǎmos taffawt ta key édt seknit i tawsitén n eddunya temda, elmejd n ellamet ennek Israyil. » ");
INSERT INTO thv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tis d mas n arraw ekunen fol awa yehéwelen fols. ");
INSERT INTO thv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yekfén Šimƹun elbaraka ennét, ezzar yenna i Meryem, mas n Ƹisa : « Ekid arraw waɣ yesnefrent Yaḷḷah éd yumas eǧeḍel méɣ tébeddé n ǎddunet aggotnén dɣ ǎkal wan Israyil. Éd yumas ǎhamol n Yaḷḷah wa wr éd eɣbelen ǎddunet. ");
INSERT INTO thv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Éd-d yesegmeḍ awa effaren ǎddunet aggotnén dɣ ulawen nsn. Km, dédih Meryem, éd ham yumas tekmo mǎqqeret ham éd teggehet iman hund tǎkoba. » ");
INSERT INTO thv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tellé aked tennabit iyyet, isem ennét Anna, welt Fenuel, tin tawsit tan Aser. Enta tamos tamɣart weššeret. Dɣ temmeḍrit ennét, teddéw d ales iyyen essa iwetyan ɣas, ");
INSERT INTO thv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ebat, teqqim wr teddéw, téwaḍ ettamet temerwén n ǎwetay d ekkoẓ. Wr teffil Éhen wan ǎmud, tǎmos taklit n Émeli ahel d éheḍ : timuhud, toẓam. ");
INSERT INTO thv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Téwǎḍ-in émér héndɣ, ezzar teqqim tamel Yaḷḷah. Tessewel fol arraw i ǎddunet emdan wi eqqelnén i enejji n Yerušelem ɣor Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","As esmenden imerawen win Ƹisa eššeɣlen nsn wis tenna eššeriƹa tan Émeli, eqqelen ǎkal n Jalila, dɣ taɣremt nsn tan Ennaṣira. ");
INSERT INTO thv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yeqqim arraw idaggel, itiṣuhut. Ila elmiɣna teggét, teṭkart tǎhanint n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ak ǎwetay, imerawen win Ƹisa takken ǎmud wan Ǎsuref -Tefaské tan elyehud- dɣ Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","As yekreh Ƹisa meraw iwetyan d essin, eddéwen ds hund awa tganna elƹada tan ǎmud. ");
INSERT INTO thv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","As yemmenda ǎmud, eglen eqqalen aɣrem nsn, beššan Ƹisa yeqqim dɣ Yerušelem, wr ss essénen imerawen ennét. ");
INSERT INTO thv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Aɣélen Ƹisa iha terǎkeft, eglen hund awén ahel iyyen imda. Ezzar egmeyen-t ɣor ǎddunet nsn d imidiwen nsn, ");
INSERT INTO thv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","beššan wrt osen. Aqqelen Yerušelem egmayen-t. ");
INSERT INTO thv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","As okeyen keraḍ iheḍan, osen-t dɣ éhen wan ǎmud : yeqqim ǧer elmuƹlimin, yesiged asn, isastan tn. ");
INSERT INTO thv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","I has yeslen, éd yukan d teyette ennét d ejiwiben wi iteǧ. ");
INSERT INTO thv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","As-t eneyen imerawen ennét, eqqenen iɣefawen nsn, tenna has mas : « Arrawin, mafol haneɣ tegéd awén ? Nk d tik nermaɣ, neyyewen negmay key. » ");
INSERT INTO thv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yenna hasn : « Mafol tegmayem ahi ? Wr tessénem as yelzam ahi amhihi d eššeɣlen n ti ? » ");
INSERT INTO thv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wr egréhen awa hasn yenna. ");
INSERT INTO thv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yeddew dsn s Ennaṣira. Isagad i awa has gannén. Mas teqqim texximmem awa igen, togaẓ-t dɣ ul ennét. ");
INSERT INTO thv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Isata Ƹisa dɣ elmiɣna d tébeddé d tǎhanint tan Yaḷḷah d tan ǎddunet. ");
INSERT INTO thv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ǎwetay wan maraw d semmos dɣ temenukela n Elqaysar Tiberyus ; Bilaṭes Elbunṭi yeḥkam dɣ Yehudiya, Hérodes yeḥkam dɣ Jalila, eŋŋas Filibes yeḥkam dɣ ikallen win Iturya d Traxunis, Lisanyus wadih yeḥkam fol Abilya, ");
INSERT INTO thv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","dɣ ezzeman wa dɣ ǎmosen Hana d Qeyafa imerubay wi meqqornén, yesséwel Yaḷḷah i Eḥya ag Zakariya, dɣ ténéré. ");
INSERT INTO thv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yegla Eḥya, yellil ǎkal wa yoheẓen eɣǎher wan Elurdun. Iganna awah : « Utabet, selmeɣet iman nwn dɣ aman baš éd tegrewem ǎsaruf n ibekkaḍen nwn. » ");
INSERT INTO thv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Awéndɣ itag Eḥya, yektabt ennebi Išeƹya dɣ elkettab ennét : « Ǎmesli n wa yesiɣerén dɣ ténéré, iganna : zewwejedet ǎbǎreqqa n Émeli, sugduhet as ǎbǎreqqa ennét ! ");
INSERT INTO thv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","iɣehran wi eɣehnén éd enbelen, éd ensinet tidreɣén d tidebbonén ; imnenniḍen n ibereqqaten éd eẓẓelen, ibereqqaten wi exlenén éd ehusiyen. ");
INSERT INTO thv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dédih ak ǎwadem éd yeni elɣelas n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ǎgut ǎwadem yosin ɣor Eḥya, baš éd tn iselmeɣ dɣ aman. Yenna hasn : « Ikét n tiššelén ! Mi hawen innen éd terwelem i ǎweššen wan Yaḷḷah wad yoheẓen. ? ");
INSERT INTO thv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Setbetet s iǧiten olaɣnen as tetubem, eyyet tinawt dɣ iman nwn : -Abba nnɣ Ibrahim-. Asilekeneɣ awen as ikedéwen wiɣ, Yaḷḷah yeddobet éd tn yer iheyawen n Ibrahim ! ");
INSERT INTO thv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tolam d iškan, takedimt tojad, tennihel d ikéwen n iškan : ak ašek, kud wr itirew a tha elfayda, éd yemmenkeḍ, éd hin yettenḍew dɣ témsé. » ");
INSERT INTO thv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Essenstenent ǎddunet, ennen as : « Ma hé neǧ ? » ");
INSERT INTO thv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yenna hasn : « Wa ilen essin iselsa, yekfét iyyen i wa wrn ile ula, wa ilen imekšan, yoẓan-tn. » ");
INSERT INTO thv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Osen-d aked inarmasen n tiwsé, egmayen ǎselmeɣ, essestenen Eḥya, ennen as : « Muƹalim, ma hé neǧ nekkenéḍ ? » ");
INSERT INTO thv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yenna hasn : « Wr teẓẓerẓemem denneg awa hawen yahéwelen. » ");
INSERT INTO thv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Osent in jonditen, essestenent : « Nekkenéḍ daɣ ma hé neǧ ? » Yenna hasn : « Wr teqqimem taheɣem ǎddunet, wr teqqimem taggem tinawén wrn eẓẓél fol ǎddunet, wr tegméyem ar aẓref wa hawen yetterẓemen. » ");
INSERT INTO thv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ǎddunet aẓiẓeyderen, egaren eṭṭema, gannén dɣ iman nsn : « Eḥya, weggéɣ enta a yǎmosen Elmesiḥ ? » ");
INSERT INTO thv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yenna hasn Eḥya : « Nk, aman a dɣ kewen éd selmeɣeɣ ; beššan éd-d yas wa hi yernen : wr enheggeɣ aked éd areɣ tikerras tin iɣetémen ennét. Wadih Unfas Heddigen d témsé a dɣ kewen éd iselmeɣ. ");
INSERT INTO thv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yeṭṭaf dɣ ǎfus ennét téseyt tas izazzaǧ tǎɣerɣert, iẓameẓlay allon d aɣešlaf. Éd yeṭker taheqqa ennét allon, awa yexlen, éd-t yeqqed dɣ témsé ta wrt ɣessey ar abedǎh. » ");
INSERT INTO thv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hund awéndɣ itag Eḥya isǎlan n elxér i dg Israyil dɣ isemmetiren ǎǧǧotnén, itabeššar tn. ");
INSERT INTO thv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yesséwel Eḥya i Hérodes, amɣar wan Jalila, fol aggay wa iǧa i Herodya hennis n eŋŋas d fol erk iǧiten ǎǧǧotnén heḍnén. ");
INSERT INTO thv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yessotin folsn aked awah : yeǧa Eḥya dɣ tǎkormut. ");
INSERT INTO thv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A yekka Eḥya isalmaɣ ǎddunet, yesselmeɣ aked Ƹisa. A yekka Ƹisa itimuhud, améren iǧennawen ");
INSERT INTO thv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ezzar yeres in fols Unfas Heddigen, yeǧa emuken n tedebért mellet. Émér héndɣ yegmeḍ-d amesli d ifalen iǧennawen, yenna : « Key tǎmosed Ruré was eknéɣ tera, teknéd ahi iman. » ");
INSERT INTO thv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ila Ƹisa berén keraḍet temerwén n ǎwetay as yessenta emahal ennét. Aɣélen ǎddunet rurés n Yusef a yǎmos, Yusef ag Hali, ");
INSERT INTO thv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ag Matthat, ag Léwi, ag Melki, ag Yenna, ag Yusef, ");
INSERT INTO thv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ag Matathya, ag Amos, ag Naḥum, ag Ḥesli, ag Nejjay, ");
INSERT INTO thv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ag Math, ag Matathya, ag Šemaƹi, ag Yusef, ag Yehuda, ");
INSERT INTO thv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ag Yuḥna, ag Risa, ag Zerubabel, ag Šeyaltayil, ag Niri, ");
INSERT INTO thv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ag Melki, ag Addi, ag Kosam, ag Elmudam, ag Ƹer, ");
INSERT INTO thv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ag Ƹisa, ag Elyezer, ag Yurim, ag Matthat, ag Léwi, ");
INSERT INTO thv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ag Šimƹun, ag Yehuda, ag Yusef, ag Yunam, ag Elyaqim, ");
INSERT INTO thv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ag Meleya, ag Meynan, ag Mattatha, ag Nathan, ag Dawud, ");
INSERT INTO thv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ag Yessa, ag Γubeyd, ag Buɣaz, ag Selmun, ag Naḥšun, ");
INSERT INTO thv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ag Amminadab, ag Admin, ag Arni, ag Ḥeṣrun, ag Fareṣ, ag Yehuda, ");
INSERT INTO thv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ag Yaƹqub, ag Isḥaq, ag Ibrahim, ag Teraḥ, ag Naḥur, ");
INSERT INTO thv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ag Serruj, ag Reyu, ag Falej, ag Abir, ag Šelḥa, ");
INSERT INTO thv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ag Qinan, ag Arfekšad, ag Sam, ag Noḥ, ag Lamek, ");
INSERT INTO thv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ag Matušaleḥ, ag Axnux, ag Yered, ag Mehlalil, ag Qinan, ");
INSERT INTO thv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ag Anuš, ag Šit, ag Adam wa yexlek Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ƹisa yeṭkar Unfas Heddigen, yefel eɣǎher wan Elurdun, yelwayt Unfas dɣ ténéré, ");
INSERT INTO thv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","dɣ yessokey ekkoẓet temerwén n ahel itajerrabt Iblis. Wr yekšé ula enḍerren iheḍan windɣ, as okeyen, yeŋɣé laẓ. ");
INSERT INTO thv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yenna has Iblis : « Kud tidet as Ag Yaḷḷah a tǎmosed key, en as i ékedé waɣ éd yeqqel tagella. » ");
INSERT INTO thv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yenna has Ƹisa : « Yektab : -Ǎwadem wr éd yeddar s tagella ɣas, beššan aked s ak tefért n Yaḷḷah ». ");
INSERT INTO thv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yeweyt Iblis édeg iknan aṭkul, yessekné-hin hik id-t illa ǎkal yetiwezzaɣen ");
INSERT INTO thv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ezzar yenna has : « Éd key ekfeɣ terna n ikallen wiɣ emdan d elmejd nsn : awaɣ imda egreweɣt, addobéɣ édt ekfeɣ i was eréɣ. ");
INSERT INTO thv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kud terkeƹed dati, ak heret innek, ekféɣ akt. » ");
INSERT INTO thv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yenna has Ƹisa : « Yektab : « Erkeƹ dat Émeli Messineɣ ennek enta ɣas a hé teƹbeded.” » ");
INSERT INTO thv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yeweyt Iblis adih s Yerušelem, yeǧé afella n Éhen wan ǎmud, yenna has : « Kud tǎmosed Ag Yaḷḷah, enḍu iman ennek s ǎmǎḍal ; ");
INSERT INTO thv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","édét yektab : « Yaḷḷah yenna hasn i ǎngelosen ennét éd key agẓin, key.” ");
INSERT INTO thv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Méɣ daɣ : « Éd key eṭṭefen s ifassen nsn, baš wr éd yeqqef aḍer ennek i ékedé.” » ");
INSERT INTO thv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yenna has Ƹisa : « Yahéwel : « Wr éd taremed Émeli, Messineɣ ennek.” » ");
INSERT INTO thv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","As yesmenda Iblis awa yeddobet dɣ térmitén ennét, yegla, yoyyé ar émér iyyen heḍen. ");
INSERT INTO thv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeqqel Ƹisa Jalila yeṭkar terna n Unfas Heddigen. Esineqqesen fols ǎddunet dɣ ǎkal héndɣ imda. ");
INSERT INTO thv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yeqqim isaɣra dɣ ihenan n téɣeré nsn, ǎddunet emdan tamelent. ");
INSERT INTO thv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yekka Ƹisa Ennaṣira, ǎkal wa dɣ yedwel. Yosin ahel n essebet, ahel n tesonfat, yeggeh éhen n téɣeré, hund emǧom. Yenker, éd yeɣer, ");
INSERT INTO thv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","yegrew elkettab wan ennebi Išeƹya. Yoré, yosa édeg wa dɣ ikteb aẓel waɣ : ");
INSERT INTO thv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","« Unfas n Émeli iwar ahi, yesnefren ahi nk, baš éd egeɣ isǎlan n elxér i tilaqqiwen, éd zuzyeɣ ulawen iha elhem. Yezmahel ahi-d baš éd enneɣ i kél tǎkormut aǧmoḍ yoheẓ, éd enneɣ i immedorɣal ǎhenay yeǧrew, éd exxerereɣ wi atiwekrasnén, ");
INSERT INTO thv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","baš éd enneɣ ǎwetay n elxér n Émeli. » ");
INSERT INTO thv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","As yesmenda, yoḍa Ƹisa elkettab, yerré i ǎnaxdam, ezzar yeqqim. Ǎddunet wi ehenén éhen n téɣeré, ekyedent emdan. ");
INSERT INTO thv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dédih yenna hasn : « Ahel waɣ aẓel wa yektaben dɣ Elkettab yetbet émér héndɣ d has tsallem, kewenéḍ wiɣ has esgednén. » ");
INSERT INTO thv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Emdan tamelent, eqqimen ǎkunen dɣ tifér n elxér ti yenna. Ennen : « Awah weggéɣ rurés n Yusef ?” ");
INSERT INTO thv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yenna hasn Ƹisa : « Essaneɣ as teddobém éd hi tennim anhi wah yenna : « Ǎḍebib ! Zuzey iman ennek ! » Éd tennim aked : « Nessan awa tgéd imda dɣ Kafranahum, egé déɣ dɣ ǎkal ennek. » ");
INSERT INTO thv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ezzar yesséta : « Éd hawen tn enneɣ, awah tidet : wrt illé ennebi yeknan etwerexxeb dɣ ǎkal ennét. ");
INSERT INTO thv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Awah tidet, eddobéɣ éd hawen tn enneɣ, élwanet téḍéḍén s eba ales nesnet dɣ ǎkal n Israyil dɣ ezzeman wan Eliya. Émér wéndɣ dɣ wr iwét aǧenna ad éweḍen keraḍ iwetyan d aɣil n iyyen. Émér héndɣ d temel menna mǎqqeret dɣ ǎkal imda. ");
INSERT INTO thv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Beššan wr yesséwey Messineɣ Eliya ɣor wl iyyet dsnt, yesseweyt ɣor iyyet heḍet tezzaɣet dɣ Ṣerfa dɣ ǎkal n Ṣeyda. ");
INSERT INTO thv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Awén yola d wa iǧen dɣ ezzeman wan ennebi Elišeƹ, élwan ǎddunet wi tegrew torna tan élem mellen ; beššan wl iyyen dsn wr yezzéy, wr yezzéy ar Naƹman d ifalen ǎkal wan Surya. » ");
INSERT INTO thv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Emdan, dɣ éhen n téɣeré, ekkusen, ewweššenen as eslen i awén. ");
INSERT INTO thv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Enkeren, emhelen Ƹisa essegmeḍent aɣrem, eweyent s afella n térgit tan tadreq ta ɣor tebna Ennaṣira, eran édt in sebbereɣwelen. ");
INSERT INTO thv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Beššan yokey gérésn, yegla. ");
INSERT INTO thv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yekka Ƹisa Kafranahum, dɣ ǎkal n Jalila, isaɣra ds ahel wan essebet, yǎmosen ahel n tesonfat. ");
INSERT INTO thv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Akunen ǎddunet dɣ ǎseɣri ennét folin awal ennét ila elḥikma. ");
INSERT INTO thv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dɣ éhen wan téɣeré, illé ales iyyen iha ag ǎsuf. Yeṭkel amesli ennét yesiɣeret : ");
INSERT INTO thv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","« Hey ! Ƹisa wan Ennaṣira, ma dnɣ teréd ? Teréd éd haneɣ tehheddemed ? Essaneɣ ma tǎmosed : Wa Heddigen d yezmahel Yaḷḷah ! » ");
INSERT INTO thv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yezmeheḍ Ƹisa fol ag ǎsuf wa ihen ales wah, yenna has : « Susem folnɣ d tegmeḍed ales wah !” Yegmeḍ-d ag ǎsuf, yessoḍa ales fol ǎmǎḍal dat ǎddunet, beššan wr has yeɣhéd ula enḍerren. ");
INSERT INTO thv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ǎddunet emdan akunen, ennen gérésn : « Ma yǎmos awal wah ? Ales waɣ yeḥkam s terna d elḥikma dɣ kél ǎsuf, ǧammeḍen !” ");
INSERT INTO thv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dédih enferen isǎlan ennét dɣ ǎkal imda. ");
INSERT INTO thv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yefel Ƹisa éhen n téɣeré, yekka tǎɣǎhamt tan ales iyyen igan isem Simƹun. Tamɣart iyyet, tǎḍeggalt n Simgenƹun tegraw tt tazzaq teṣṣohet, yehéwel i Ƹisa éd has yeg heret iyyen. ");
INSERT INTO thv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yeneh-in fols, yezmeheḍ fol tazzaq. Tefel tt tazzaq, tenker tǎmǎṭ déndɣ a tn simgurut. ");
INSERT INTO thv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","As toḍa tǎfuk, i ilen ǎméren, ak iyyen d torna ennét, yéweyt ɣor Ƹisa. Isansa ifassen ennét fol ak iyyen dsn, tazzeyen emdan. ");
INSERT INTO thv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aked déndɣ, gammeḍen-d kel ǎsuf dɣ ǎddunet ǎǧǧotnén, gannén : « Key as Elmesiḥ Ag Yaḷḷah ! » Beššan izamahaḍ dsn Ƹisa, yekkas asn awal, édét entenéḍ essanen as enta Elmesiḥ. ");
INSERT INTO thv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Déndɣ d yeffo, yefel Ƹisa aɣrem, yekka édeg iyyen yesofen. Egmeyent ǎddunet ; ast osen, eɣélen édt ermesin, wr erén éd tn yefel. ");
INSERT INTO thv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Beššan yenna hasn Ƹisa : « Yelkam ahi éd ebbeššereɣ Isǎlan n Elxér win Elmelek n Yaḷḷah dɣ iɣermen wi heḍnén emdan. Fol awéndɣ as hid yesséwey Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yeqqim ixatteb dɣ ihenan n téɣeré dɣ ǎkal n Jalila imda. ");
INSERT INTO thv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ahel iyyen, yebdad Ƹisa ɣor geréw wan Jenneysarat, ǎddunet eɣlayen as, osasent eran éd segdin i awal n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yeney senatet elfelluketén erasen tnt messawsnt, eqqimen saraden dɣ aman ihellumen nsn wis rammesen isolmiyen. ");
INSERT INTO thv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yéwen Ƹisa iyyet dɣ elfelluketén, tan Simƹun, ezzar yenna has éd hin izenkeh anḍerren fol ǎgenena n geréw. Yeqqim Ƹisa isaɣra i ǎddunet héndɣ, enta wadih iha elfelluka. ");
INSERT INTO thv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","As yesmenda awal ennét, yenna i Simƹun : « Egel ar sén key d imidiwen ennek, dɣ édeg wa dɣ ojaden aman, ezzar tenḍewim ihellumen nwn wis rammesem isolmeyen. » ");
INSERT INTO thv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yenna has Simƹun : « Muƹalim, éheḍ imda negmay isolmiyen as wr nermés ula. Beššan dɣ érét n awal ennek, éd egleɣ, éd hin enḍuweɣ ihellumen. » ");
INSERT INTO thv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Enḍewen tn in, ezzar ermesen isolmiyen eknanén ǎǧut, ar deroɣ hasn essenxeren ihellumen nsn. ");
INSERT INTO thv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eɣren imidiwen nsn win elfelluka ta heḍet, éd hasn ilalen. Osenten in, ellilen asn ad eṭkeren elfellukaten essenetén, ganet aṭkor iyyen ar deroɣ elmeɣnet dɣ aman. ");
INSERT INTO thv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","As yeney Simƹun Betrus awén, yerkeƹ dat Ƹisa, yenna has : « É Émeli, efel ahi, nk enesbekkaḍ a ǎmoseɣ ! » ");
INSERT INTO thv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simƹun d wi heḍnén ellenén déndɣ eknen tǎremméq mǎqqeret, fol ǎǧut wa eǧen isolmiyen wi esdewen. ");
INSERT INTO thv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tǎremméq ta iǧa Simƹun, a eǧen imidiwen ennét, Yaƹqub d Eḥya, dg Zabadi. Beššan yenna Ƹisa i Simƹun : « Wr terméɣed, dimaɣ ǎddunet as éd teqqeled tsadawed tn-d sri. » ");
INSERT INTO thv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Essoɣelen-d elfellukatén nsn, oyyen ak heret déndɣ, elkemen i Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iha Ƹisa aɣrem iyyen ast in yosa ales, tenkalt torna tan élem mellen. As yeney Ƹisa, yenḍew iman ennét dats, ad-t ilaqqed, yenna has : « É Émeli, kud teboked as, teddobéd éd hi tzizzeǧed. » ");
INSERT INTO thv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeẓẓel Ƹisa ǎfus ennét, yeḍest ezzar yenna has : « Awén a ǎréɣ, izzaǧ !” Émér héndɣ adt tefel torna. ");
INSERT INTO thv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yenna has Ƹisa : « Wr tenned awén i isem n ǎwadem. Beššan egel seken iman ennek i ǎmǎrabu, ekf takuté tan ǎṭehher tas yenna Musa, baš éd ešheden ǎddunet as tezzeyed. » ");
INSERT INTO thv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dédih isǎlan n Ƹisa ekken illehin i ikallen, tasent in ǎddunet ǎǧǧotnén, eran éd has sagaden, éd tn izuzuy d tornawén nsn. ");
INSERT INTO thv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Beššan Ƹisa abedǎh itak ideggen ǎsofnén, itimuhud dsn. ");
INSERT INTO thv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ahel iyyen, isaɣra Ƹisa. Aqqimen déngam Elfarisiten d elmuƹlimin win eššereƹa efalen-d téɣermén aggotnén dɣ Jalila méɣ Yehudiya, efalen-d aked Yerušelem. Yegraw Ƹisa terna ta teṣṣohet ɣor Émeli, izuzuy ss imérenén. ");
INSERT INTO thv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Adih osen-d ǎddunet, éwayen-d ales yebdanen fol tǎsalat, eran éd tzughin dɣ tǎɣǎhamt dat Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Beššan wr essénen menék awa hé eǧin édt tzughin ǧér ǎgut ǎwadem wadt illen dat tǎɣǎhamt. Esséwenent afella, oren asfel, ezzar esresen enabdan fol tǎsalat ar dat Ƹisa ǧer ǎddunet. ");
INSERT INTO thv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","As yeney Ƹisa taflest nsn, yenna i eméren : « Ămidi hin key ! Ibekkaḍen ennek essorefen. » ");
INSERT INTO thv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Elƹulama wi kettebnén d Elfarisiten exxemmemen : « Ma yǎmos ales wah isikufuren ? Mi yeddobén ǎsaruf n ibekkaḍen ar Yaḷḷah ɣas ? » ");
INSERT INTO thv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yelmed Ƹisa awa exximmemen, yenna hasn : « Mafol as texximemem awah ? ");
INSERT INTO thv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma yogeren tinawt n : “Ibekkaḍen ennek essorefen” méɣ tinawt n : “Enker, egel ?” ");
INSERT INTO thv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Beššan eréɣ éd telmedem as Ag ǎwadem ila terna ta fol yeddobet ǎsaruf n ibekkaḍen fol ǎmǎḍal waɣ. » Γor déndɣ yenna i enabdan : « Ennéɣ ak, enker, eṭkel tǎsalat ennek, d teqqeled ihenan ennek !” ");
INSERT INTO thv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Émér héndɣ, yenker ales wanǧam dat ǎddunet emdan, yeṭkel tǎsalat ennét, yeqqel ihenan ennét itamel Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","As tn d iǧa Messineɣ, ǎkunen. Eqqimen tamelen Yaḷḷah. Emdan ermaɣen, gannén ǧérésn : « Ahel waɣ neney tikunén ! » ");
INSERT INTO thv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ḍeffer awén, yegmeḍ Ƹisa, yeney Léwi, ǎnarmas n tiwsé iyyen, yeqqim dɣ édeg wan elxedmet ennét. Yenna has Ƹisa : « Elkem ahi ! » ");
INSERT INTO thv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yenker Léwi, yoyya ak heret, yelkem as. ");
INSERT INTO thv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yesmegaret Léwi dɣ tǎɣǎhamt ennét s ǎmegaru mǎqqeren, tatten entenéḍ d inarmasen n tiwsé ǎǧǧotnén d ǎddunet wiyeḍ heḍnén. ");
INSERT INTO thv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Elfarisiten d elƹulama nsn wi kettebnén taẓemen awén, ennen i inelkimen n Ƹisa : « Mafol tattem d tsassen tertayem d inarmasen n tiwsé d inesbekkaḍen ? » ");
INSERT INTO thv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yenna hasn Ƹisa : « Ǎddunet wi eslexnén, wr erén éḍbab, imérenen a tn yeran. ");
INSERT INTO thv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wr-d oséɣ éd eɣreɣ wi eɣélnén eẓẓalen, oseɣ-d inesbekkaḍen baš éd utaben. » ");
INSERT INTO thv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ennen i Ƹisa : « Inelkimen n Eḥya d win Elfarisiten, toẓamen a yeggén, timuhuden, beššan winnek, tatten, sassen. » ");
INSERT INTO thv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yenna hasn Ƹisa : « Tordam in éd tetwenkaẓ téteté i imegaren n éhen a ekken ertayen d ales ? Ula deroɣ ! ");
INSERT INTO thv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Beššan ilkam éd dsn yemmukkes ales wah, dédih eddobén éd oẓamen. » ");
INSERT INTO thv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yegasn Ƹisa tangalt tah : « Wrt illé wa isanxaren aselso yeynayen baš éd yewet ss tiksén i aselso yemminden, dédih aselso wa yeynayen éd yenxer, wa yemmenden wr yenhegga d tikest tan wa yeynayen. ");
INSERT INTO thv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wrt illé daɣ éré i isaŋŋalen elboẓa teynayet dɣ ibyaɣ emmindenén, édét elboẓa ta teynayet éd tsenxer ibyaɣ : éd teŋŋel, ibyaɣ éd eɣheden. ");
INSERT INTO thv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kela ! Elboẓa ta teynayet taggeh ibyaɣ eynaynén ! ");
INSERT INTO thv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wrt illé wa yessofen elboẓa ta teynayet kud yoram ta terwet. Itahawal : tuf ta terwet. » ");
INSERT INTO thv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ahel iyyen n essebet yǎmosen ahel n tesonfat, yellil Ƹisa iferǧan n éred. Inelkimen ennét tameden tihemmarén. Tifefferuten tnt dɣ ifassen nsn, tatten téḍaɣén. ");
INSERT INTO thv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ennen asn Elfarisiten wiyyeḍ : « Mafol ad taggem awa xeramen ahel n essebet ? » ");
INSERT INTO thv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yenna hasn Ƹisa : « Wr teɣrém ula awa iǧa Dawud ahel wadt yeŋɣa laẓ enta d imidiwen ennét ? ");
INSERT INTO thv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yeggeh dɣ éhen n Yaḷḷah, yéwey tiǧelwén tin Émeli, yekša dsnt, yekfa i imidiwen ennét, awén imerubay ɣas a itatten tiǧelwén tin. » ");
INSERT INTO thv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yenna Ƹisa daɣ : « Ag ǎwadem enta Émeli n ahel n tesonfat. » ");
INSERT INTO thv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ahel iyyen heḍen n essebet, yeggeh Ƹisa éhen n téɣeré, isaɣra ds. Illé ales iyyen s yeqqor ǎfus ennét wan aɣil. ");
INSERT INTO thv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Elƹulama wi kettebnén d Elfarisiten eknan akeyad i Ƹisa, tassenen éd izuzey ales wah ahel n essebet, édét eran éd tseḍlemen. ");
INSERT INTO thv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Beššan yessan Ƹisa awa exximemen. Yenna has i ales was yeqqor ǎfus : « Enker, ebded dat ǎddunet. » Yenker ǎwadem, yebded. ");
INSERT INTO thv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ezzar yenna hasn Ƹisa : « Éd kewen sesteneɣ : -Ma tenna eššeriƹa ? Tiǧawt n elxér méɣ tiǧawt n a yeššaḍen ahel n essebet ? Uguẓ n iman méɣ iǧi n iman ahel n essebet ? » ");
INSERT INTO thv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yekyed tn emdan s iyyen iyyen ezzar yenna has i ales : « Ziheẓ d ǎfus ennek. » Yeǧa awa has yenna, ǎfus ennét yezzey. ");
INSERT INTO thv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Beššan wi heḍnén ekkusen hullan, eggehen awal ǧérésn fol awa hé eǧin i Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Adih dɣ iheḍan windɣ, yéwen Ƹisa tadreq iyyet, éd ds yemuhed, yeqqim in fols éheḍ imda itimuhud. ");
INSERT INTO thv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","As yeffo, yeɣra inelkimen ennét, yesnefren dsn meraw d essin s iǧa isem inemmahalen : ");
INSERT INTO thv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simƹun, was yeǧa isem wan Betrus, eŋŋas Andraws, Yaƹqub d Eḥya, Filibes d Bertulmaws, ");
INSERT INTO thv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta d Toma, Yaƹqub ag Ḥalfa d Simƹun, was itahawal wan elwaṭani, ");
INSERT INTO thv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yehudas ag Yaƹqub d Yehudas wan Elisxaryuṭi, wa hé yeqqelen amaɣdar ḍeffer awén. ");
INSERT INTO thv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeres d Ƹisa tadreq yeddéw dsn, yebded dɣ tesalit iyyet teṭkaret inelkimen ennét aked ǎddunet elwanén déngam : ǎddunet d efalnen d Yehudiya temda, d Yerušelem, d ikallen wi oheẓnén geréw hund Ṣura méɣ Ṣayda. ");
INSERT INTO thv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Osen d éd has segdin méɣ éd zuzyin tornawén nsn aked wi ehan kél ǎsuf tazzeyen. ");
INSERT INTO thv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Emdan egmayen édt eḍsin, fol eṣṣahet ta-d gammeḍet zuzuy tn emdan. ");
INSERT INTO thv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeṭkel Ƹisa esewaḍ ennét fol inelkimen ennét, yenna hasn : « Tengeḍ awén, kawenéḍ wi ǎmosnén tilaqqiwén, édét Elmelek n Yaḷḷah inewen ! ");
INSERT INTO thv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tengeḍ awén, kawenéḍ wi yeŋɣa laẓ dimaɣ, édét éd teyyewenem ! Tengeḍ awén, kawenéḍ wi esilefnen dimaɣ, édét éd teṭsim ! ");
INSERT INTO thv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tengeḍ awén kud okaḍen dewen ǎddunet, kud satteɣen kewen, méɣ tasebbén kewen méɣ gannén folwn ennemima, dɣ érét in teflasem Ag ǎwadem. ");
INSERT INTO thv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dewetet, eggedet s tǎdewit, awad éd yaweḍ émér héndɣ, édét tlam elkera nwn dɣ iǧennawen. Awéndɣ a taggen abbaten nsn i ennebiten. ");
INSERT INTO thv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Beššan elƹib folwn, kewenéḍ wi eɣmernén, édét elxér nwn iha ifassen nwn dimaɣ ! ");
INSERT INTO thv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Elƹib folwn, kewenéḍ wi eyyiwennén dimaɣ, édét éd kewen yeŋɣ laẓ ! Elƹib folwn, kewenéḍ wi ḍaẓẓenén dimaɣ, édét éd eɣheden iman nwn, éd tselfim ! ");
INSERT INTO thv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Elƹib folwn kud ǎddunet gannén folwn elxér, awéndɣ a taggen abbaten nsn i ennebiten win bahu ! » ");
INSERT INTO thv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","« Beššan, gannéɣ awn tn, kewenéḍ wi hi asigednén : Eɣhelet imiksenen nwn, eǧet elxér i wi dewen okeḍnén, ");
INSERT INTO thv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","wi kewen elɣennén bareket asn, wi hawen taggenén ennemima, etteret asn. ");
INSERT INTO thv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kud yesteɣ-ak iyyen fol anḍeḍ, eẓẓel as aked wa heḍen ; kud yekkes dk iyyen ǎbernuh ennek, wr has tenkeẓed aked tǎkerbast ennek. ");
INSERT INTO thv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","I dk yegmeyen ǎkfé, kud yekkes dk iyyen awa tléd, ey ast. ");
INSERT INTO thv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Eget i wi heḍnén awas teram éd hawent eǧin. ");
INSERT INTO thv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kud wr terém ar wi kewen erenén, ma yǎmos emerkéd ? Aked inesbekkaḍen eran wi tn erenén ! ");
INSERT INTO thv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kud wr teggim elxér ar i wi hawen taggenén elxér, ma yǎmos amerkéd ? Aked inesbekkaḍen awéndɣ a taggen ! ");
INSERT INTO thv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kud wr tserḍilem ar i wi hawen d errin awa hasn tesserḍelem, ma yǎmos amerkéd ? Aked inesbekkaḍen sarḍalen i inesbekkaḍen wi hasn errinen a wa hasn esserḍelen ! ");
INSERT INTO thv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Beššan kewenéḍ, eɣhelet imiksenen nwn, eǧet asn elxér, serḍelet asn bla wr teǧérem eṭṭema. Dédih amerkéd nwn éd yumas i mǎqqeren, éd teqqelem dg Ǎmaṭkal, édét itag tihusay aked i wi wr tehé temayet d wi exlenén. ");
INSERT INTO thv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Teggehét kewen tǎhanint hund tǎhanint ta thet Abba nwn. » ");
INSERT INTO thv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","« Wr toẓamem ǎwadem, wr kewen entéẓem ; wr seḍlimem ǎwadem, wr kewen enseḍlem ; sorfet, éd hawen ensoref. ");
INSERT INTO thv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Akfet, éd tegrewem ǎsebbeter yeknan aṭkor yessan ad iflenfelet, édét ékét was tekkatem i wi heḍnén enta s hawen éd yeket Messineɣ. » ");
INSERT INTO thv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesséwel asn Ƹisa arwah s tangalt : « Ǎmeddérɣel wr yeddobet éd yelwi iyyen heḍen, tidet méɣ bahu ? Dédih éd oḍun issenen-ésn dɣ anu. ");
INSERT INTO thv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wr t illé ǎneṭṭalib yogeren elmuƹlim ennét, beššan ak ǎneṭṭalib yeknan alemad yeddobet éd yugdu d elmuƹlim ennét. ");
INSERT INTO thv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mafol tekyaded téẓéwt ta thet téṭ n eŋŋak, kud wr henneyed esǎɣér wa ihen téṭ ennek ? ");
INSERT INTO thv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Menék awa hé teǧed, éd tenned : -Eŋŋa, eyyahi éd hak ekkeseɣ téẓéwt ta thet ṭéṭ ennek-, key wa wrn ihenney esǎɣér wa ihen téṭ ennek ? Wan essin udmawen ! Ekkes esǎɣér wa ihen téṭ ennek ezzar, dédih éd teyned téẓéwt ta thet téṭ n eŋŋak baš éd tt tekkesed ». ");
INSERT INTO thv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","« Ašek yolaɣen, wr itirew a yexlan, méɣ ašek yexlan wr itirew a yeslaxen. ");
INSERT INTO thv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ak ašek, ititwezzay s awa itarew : wr neddobet ammad n aharen fol efteẓẓen, méɣ ǎzzebib fol isennanen. ");
INSERT INTO thv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ales wa yolaɣen, wr-d itekkes ar awa yolaɣen yogeẓ dɣ ul ennét ; ales iššaḍen wr-d itakkes ar awa iššaḍen yogeẓ dɣ ul ennét. Édét émi n ak iyyen dnɣ isagmaḍ-d awa yeṭker ul. » ");
INSERT INTO thv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","« Mafol tɣarrem ahi : -Émeli, Émeli-, kud wr teggim awa hawen gannéɣ ? ");
INSERT INTO thv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Éd kewen sekneɣ awad yola wa hid itasen, isagad ahi, itag awa has gannéɣ : ");
INSERT INTO thv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yola d ales wa yessenten elbeni n tǎɣǎhamt ; yeɣeh ǎmǎḍal, as yéweḍ ǎseli, yebna fols. As d yosa anǧi, aman win ǎɣǎher enkefen i tǎɣǎhamt tah, beššan wr tt essoḍen, édét tekna elbeni fol ǎseli. ");
INSERT INTO thv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Beššan wa hi yesigeden, wr iteg awa has gannéɣ yola d ales wa ibunnun tǎɣǎhamt dɣ tǎɣezzit wr yéwéḍ ǎseli. As as enkefen aman win ǎɣǎher, éd tt soḍun, éd teheddem temda. » ");
INSERT INTO thv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","As yesmenda Ƹisa ǎseɣri ennét i ǎddunet wi has eɣleynén deh, yegla, yekka Kafranahum. ");
INSERT INTO thv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Déndɣ illé elqebṭan iyyen n errumaniten ilan akli yessimɣer hullan. Akli wah yekna torna, tohaẓt tǎmettant. ");
INSERT INTO thv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","As yesla elqebṭan isǎlan n Ƹisa, yesséwey as imɣaren wiyyeḍ dɣ elyehud, yenna has édt in yas, éd yezuzey akli ennét. ");
INSERT INTO thv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Osen in ɣor Ƹisa, eyyewenen laqqedent, gannén as : « Ales wah yenihegga d telilt. ");
INSERT INTO thv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yessimɣer ǎddunet nnɣ, enta a yebnen éhen n téɣeré nnɣ. » ");
INSERT INTO thv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yeddéw dsn Ƹisa. Ohaẓen tǎɣǎhamt, as in yesséwey elqebṭan imidiwen ennét, éd ennin i Ƹisa : « É Émeli, wr teŋɣéd iman ennek édét ula ǎmoseɣ éd teggehed tǎɣǎhamtin, ");
INSERT INTO thv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","awéndɣ as wr ezneheggeɣ iman in éd key in aseɣ nk. Beššan, inhod ad tennéd tefért iyyet hé tennejit akli hin. ");
INSERT INTO thv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nk iman in, eléɣ médden dennegi, eléɣ jonditen dawi. Kud ennéɣ i iyyen : -Egel !- Éd yegel ; kud ennéɣ i iyyen heḍen : -Eyow !- Éd-d yas ; kud ennéɣ i akli hin : -Eǧ awah !- Éd-t yeǧ. ");
INSERT INTO thv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","As yesla Ƹisa i tifér tih, yekun dɣ awal n elqebṭan. Yeznehlem, ezzar yenna i ǎddunet wi has elkemnen : « Ennéɣ awen tn, ula ǧer ǎddunet win Israyil, a ewéɣ wr eneyeɣ taflest togdat d tah. » ");
INSERT INTO thv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","As eqqelen wi yezmahel elqebṭan tǎɣǎhamt, osen akli yezzay. ");
INSERT INTO thv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ḍeffer awén, yekka Ƹisa ǎkal wan Nayin, eddéwen ds inelkimen ennét d ǎddunet aggotnén. ");
INSERT INTO thv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","As yoheẓ émi n aɣrem, yemheyyet d ǎddunet ewaynén enemmitten s isensa : enta yǎmos rurés wan iyyen n tǎmǎṭ s yemmut ales ennét. Eddéwen ds ǎddunet aggotnén. ");
INSERT INTO thv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","As tt yeney Émeli, teŋɣé s tamella hullan, yenna has : « Ey tekelélt ! » ");
INSERT INTO thv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ezzar yoheẓ ǎɣǎrabu, yeḍest, ebdeden wi-t emisaweynén. Yenna Ƹisa : « Ǎmawaḍ key, enker, nk a hak tn igannén ! » ");
INSERT INTO thv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yenker-d enemmitten, yebded, yeqqim yesséwel. Yerré Ƹisa i mas. ");
INSERT INTO thv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Emdan eksoḍen, omelen Yaḷḷah gannén : « Ennebi mǎqqeren a haneɣ-d yosen ! » Méɣ arweh : « Yos-d Yaḷḷah éd yilal i ellamet ennét ! » ");
INSERT INTO thv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dédih dɣ Yehudiya temda d ikallan wi has eɣleynén, elmeden ǎddunet awa iǧa Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ennen as inelkimen n Eḥya awén imda. Yeɣra Eḥya essin dsn ");
INSERT INTO thv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","yenna hasn éd sestenin Émeli d awah : « Key tǎmosed wa folnɣ ilkamen, méɣ ilzam anɣ éd neqqel i iyyen heḍen ? » ");
INSERT INTO thv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","As in éweḍen ɣor Ƹisa, ennen as : « Eḥya wan ǎnesselmaɣ a hanɣ yezimahelen, éd key nesesten : -Key a yǎmosen wa folnɣ ilkamén, méɣ ilzam anɣ éd neqqel i iyyen heḍen ? » ");
INSERT INTO thv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Émér héndɣ, Ƹisa izuzuy tornawén d toẓẓérén n ǎddunet aggotnén, itakkes kél ǎsuf dɣ wi etiwehenén, itar ǎhenay i imeddorɣal ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yenna hasn i wi-d yezmahel Eḥya : « Eglet ennét i Eḥya awa teneyem d awas teslem : wi derɣelnén hanneyen, wi esketewnén gallen, wi tegrew torna n élem mellen ezzeyen, wi meẓẓegnén sallen, wi emmutnén edderen, eǧrewnet tilaqqiwén isǎlan n elxér. ");
INSERT INTO thv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tengeḍ i wa wrn dɣi yeǧé eššek ! » ");
INSERT INTO thv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","As eglen wi-d yezmahel Eḥya, yesséwel Ƹisa, yenna i ǎddunet fol Eḥya : « Ma tekkem éd-t teynim dɣ ténéré ? Tahlé yesiwelawel aḍu ? Kela ! ");
INSERT INTO thv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Méɣ ma tekkem éd teynim ? Ales yelsan iselsa eknanén tihusay ? Kela édét, wi elsenén iselsa ǎhoseynén, eɣmernén, ezzaɣen dɣ ihenan win imenokalen. ");
INSERT INTO thv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma tekkem éd teynim ? Ennebi ? Ayoh, éd hawen tn enneɣ, yokey aked ennebi. ");
INSERT INTO thv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Édét Eḥya yǎmos wa fol yetiwektab : « Éd hin siwyeɣ datk ǎnemmahalin, baš éd yeken ǎbǎreqqa datk.” ");
INSERT INTO thv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","« Gannéɣ awén tn, ǧér ǎddunet emdan wi ewenén, wrt illé wa yogeren Eḥya, beššan wa metteken dɣ Elmelek n Yaḷḷah yogert. ");
INSERT INTO thv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Id-t illa ǎwadem, aked inarmasen n tiwsé esgeden as, ešheden as yeẓẓal Yaḷḷah eɣbalen in éd tn iselmeɣ Eḥya dɣ aman. ");
INSERT INTO thv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Beššan Elfarisiten d elmuƹlimin win eššeriƹa wr eɣbélen awa hasn yeɣhel Yaḷḷah, ugeyen éd tn iselmeɣ Eḥya dɣ aman. » ");
INSERT INTO thv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yenna Ƹisa daɣ : « Mi-d éd suluɣ ǎddunet win ezzeman waɣ ? Mi-d olan ? ");
INSERT INTO thv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Olan d arrawen eqqimnén dɣ eẓẓegag, wiyeḍ gannén i wi heḍnén : -Neddel awn tǎẓemmart, wr terkéḍem ! Néwey awn isuhaɣ n tasnit, wr teslefem !- ");
INSERT INTO thv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hund awéndɣ yos-d Eḥya, wr itet tagella, wr ises elboẓa, beššan tennem : -Ehant kél ǎsuf !- ");
INSERT INTO thv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yos-d Ag ǎwadem, itat, isas, beššan tennem : -Eynet ales wah, wrn yexxemmem ar téteté méɣ tésesé n elboẓa, yemédew d inarmasen n tiwsé d inesbekkaḍen !- ");
INSERT INTO thv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Beššan elmiɣna tan Yaḷḷah tetbat dɣ érét n térwa-nét. ");
INSERT INTO thv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yeɣr-d Elfarisi iyyen Ƹisa s amensu. Yosé hin Ƹisa, yesɣemer. ");
INSERT INTO thv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dɣ aɣrem wéndɣ tellé tǎmǎṭ n tǎnesbekkaṭ. As telmed in Ƹisa illa ɣor Elfarisi, tosin teway tehǎttint teknat tihusay iha elɣeṭer, ");
INSERT INTO thv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","temel ḍeffer Ƹisa, ɣor éḍaren-nét. Tesilef, imeṭṭawen-nét eweren éḍaren win Ƹisa, ezzar tomes tn s imẓaden ennét, temmulet asn, teswer tn elɣeṭer. ");
INSERT INTO thv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","As yeney Elfarisi wa ɣor illa Ƹisa awén, yenna dɣ iman ennét : « Kud ales waɣ yetbat as ennebi a yǎmos, éd yelmed ma tǎmos tǎmǎṭ taɣ t-teḍḍaset : tǎmǎṭ n tǎnesbekkaṭ. » ");
INSERT INTO thv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesséwel Ƹisa, yenna has i Elfarisi : « Simƹun, ǎréɣ éd hak enneɣ heret iyyen. » Yenna has Simƹun : « Leɣt ahi, Muƹalim. » ");
INSERT INTO thv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yenna has Ƹisa : « Essin médden yellil tn ales. Iyyen yellil-t semmoset temaḍ n erriyalen n aẓref, wa heḍen, semmoset temerwén. ");
INSERT INTO thv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wl iyyen dsn wr ilé aẓref, dédih yessoref asn sérḍal wah. Ma tordéd menék wa has éd yeknin tera ? » ");
INSERT INTO thv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yejéweb Simƹun : « Ordeɣ as was yesoref sérḍal wa yeggén. » Yenna has Ƹisa : « Tidet. » ");
INSERT INTO thv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yeznehlem berén tǎmǎṭ, ezzar yenna i Simƹun : « Thaneyed tǎmǎṭ taɣ ? Eggeheɣ-d ɣork, wr hi tekféd aman i éḍarenin ; enta tesséred ahi tn s imeṭṭawen ennét, tomes tn s imẓaden ennét. ");
INSERT INTO thv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wr hi terreḥḥebed s timulla, enta timellut i éḍarenin wa fol d oséɣ. ");
INSERT INTO thv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wr hi tehwéyed éɣef, enta teswer ahi éḍaren elɣeṭer. ");
INSERT INTO thv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Fol awéndɣ as hak ennéɣ dimaɣ : tegrew ǎsaruf fol ibekkaḍen ennét wi ǎǧǧotnén fol awéndɣ as tera ennét ti mǎqqeret. Beššan was ensoruf a derusen, isakna tera deruset. » ");
INSERT INTO thv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dédih yenna Ƹisa i tǎmǎṭ : « Ibekkaḍen ennem essorefen. » ");
INSERT INTO thv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ǎddunet wi-t ellenén déndɣ ennen dɣ iman nsn : « Ma yǎmos ales wah yekoyesen ǎsaruf n ibekkaḍen ? » ");
INSERT INTO thv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Beššan yenna Ƹisa i tǎmǎṭ : « Egel dɣ esselamet : taflest ennem tennejjim. » ");
INSERT INTO thv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ḍeffer awén, yeɣlay Ƹisa iɣerman d ikallen itabeššar dsn Isǎlan n Elxér win Elmelek n Yaḷḷah. Innemmahalen ennét win maraw d essin eddéwen ds, ");
INSERT INTO thv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","entenéḍ d téḍéḍén tiyyeḍ dɣ yestaɣ kél ǎsuf méɣ yezozey d tornawén. amosnet Meryem tas itahawal Meryem Elmejdaliya, ta dɣ emmukkesen essa eššeyaṭin ; ");
INSERT INTO thv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuwenna, hennis n Xuzi, wakil n Hérodes ; Susenna d tiyeḍ heḍnén ellilnet i Ƹisa d inelkimen-nét s tela nsnt. ");
INSERT INTO thv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Edét élwen ǎddunet, effalen-d éɣerman emdan ekkan Ƹisa, yeǧa sn tangalt tah : ");
INSERT INTO thv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","« Ales iyyen yekka ǎfǎraǧ-nét a ds isaŋɣal téḍaɣen. A yekka isaŋɣal, téfsén tiyyeḍ erteknet dɣ ǎbǎreqqa : eglen folsnt ǎddunet, ekšen tnt igḍaḍ. ");
INSERT INTO thv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tiyyeḍ erteknet ǧer ikedéwen : as-d enkernet, eqqornet déndɣ s iba n aman. ");
INSERT INTO thv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tiyyeḍ erteknet dɣ isennanen ; enkeren eddéwnen dsnt, elmeẓen tnt. ");
INSERT INTO thv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Beššan ellanet ti erteknén fol ǎmǎḍal yolaɣen ; enkernet, eknenet tanekra, ekrehnet tihemmaren : ak iyyet tekreh téméḍé n taḍaq. » Déndɣ ad yenker Ƹisa yessota, yeṭkel awal : « Eré ilan tǎmeẓẓuk isegdét !” ");
INSERT INTO thv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Essestenent inelkimen ennét d elmeƹna n tangalt tah. ");
INSERT INTO thv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yenna hasn : « Kewenéḍ tegrawem almud n awa yefferen dɣ Elmelek n Yaḷḷah, beššan ǎddunet wi heḍnén, itahawal asn s tangalt, baš éd esweḍen, wr henneyen baš éd segdin, wr egréhen. » ");
INSERT INTO thv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","« Nɣtah elmeƹna tan tangalt : téḍaɣen ǎmosnet awal n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wi ehenén ǎbǎreqqa, entenéḍ a isallen, beššan itas-d Iblis, itakkes asn awal wah dɣ ulawen nsn, baš wrt éd eflesen, wr éd ennejjin. ");
INSERT INTO thv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wi ellenén ǧér ikedéwen, entenéḍ a isallen i awal n Yaḷḷah, tarreḥabent s tǎdewit beššan wrt iyyin éd yeǧ ikéwen, eflasent émér iyyen ɣas, edt in egrin hik émér n elmašakel n tǎmeddort. ");
INSERT INTO thv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Téḍaɣén ti erteknén ǧér isennanen, entenetéḍ as ǎddunet wi sallenen, beššan ixulluten aǧut elhem d ǎɣemar n addunya d taẓudé n tǎmeddort nsn. Wr kerrehen a teha elfayda. ");
INSERT INTO thv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Téḍaɣén ti erteknén dɣ ǎmǎḍal wa yehoseyen, entenntéḍ as ǎddunet wi sallenen i awal n Yaḷḷah, éd has eknin oḍuf s serho dɣ ulawen nsn, éd eẓiẓeyderen kannen abedǎh a teha elfayda. ");
INSERT INTO thv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","« Wrt illé wa isukun énér, ezzar éd isebbembi fols ǎkus méɣ éd tt yeǧ dag tedabut. Kela, éré isukun énér, ǎsensi afella a has itaǧ, baš as-d taggehen ǎddunet éd hanneyen taffawt-nét. ");
INSERT INTO thv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Édét a yefferen, ilkam éd yuman. A yeɣrehen ilkam éd yeffuker, éd iggeh taffawt. ");
INSERT INTO thv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eǧet enniyet s emmek was tsagadem ! Édét éré ilan, éd igrew, éré wrn ilé éd has yemmukes aked awas yeɣél in ilé. » ");
INSERT INTO thv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mas d ayet-mas n Ƹisa osen in dɣ édeg wa-d illa, beššan wr eddobén éd-t in awḍin s ǎgut n ǎddunet wi has eɣleynén. ");
INSERT INTO thv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yehéwel as : « Mak d ayet-mak ehan ténéré, eran éd key eynin. » ");
INSERT INTO thv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yenna hasn Ƹisa : « Ma d ayet ma, ǎmosen wi sagadnén, elkamen i awal n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ahel iyyen, yéwen Ƹisa dɣ elfelluka iyyet, yeddéw d inelkimen-nét, yenna hasn : « Endawtet éd nk aɣil hén n geréw. » Eglen. ");
INSERT INTO thv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","A tekka elfelluka tegla, yeṭṭes Ƹisa. Émér héndɣ yenker-d aḍu yeṣṣohén, teṭker elfelluka aman, eggehen mihi. ");
INSERT INTO thv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oheẓen in inelkimen Ƹisa, essenkernt, ennen as : « Muƹalim, Muƹalim, éd nemmet ! » Yenker-d Ƹisa, yezmeheḍ dɣ aḍu d aman. Yebded awéndɣ ikét ennét, semméḍ. ");
INSERT INTO thv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ezzar yenna hasn : « Ma tǧa taflest nwn ? » Eqqimen ǎkunen, ermaɣen, gannén ǧérésn : « Ma yǎmos ales wah, yeḥkam dɣ aḍu d dɣ aman, sagaden as ?. » ");
INSERT INTO thv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Eweḍen ǎkal wan Eljarisiyin, yenimehalen d ǎkal n Jalila. ");
INSERT INTO thv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","As yeres, déndɣ d issensa aḍer ennét fol ǎmǎḍal, yosé hin ales iyyen n aɣrem, ehant kél ǎsuf. Wan éru ales wah wr iles iselsa, wr izzéɣ tǎɣǎhamt, izzaɣ ɣor isensa. ");
INSERT INTO thv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","As yeney Ƹisa, yenḍew iman ennét ɣor éḍaren ennét, yesɣeret ad-t id yerren, yenna has : « Ma hi teréd Ƹisa, Ag Yaḷḷah wan Ǎmaṭkal ? Inhod, wr hi tesseɣseled. » ");
INSERT INTO thv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Awéndɣ ḍeffer awa has yenna Ƹisa i ag ǎsuf éd-d igmeḍ. Ag ǎsuf wanǧam wan éru ad yeggeh ales, iméren wi-d inakker ag ǎsuf, ititwekrad s tihebeǧiwén dɣ éḍaren d ifassen baš éd yogaẓ, wr éd yegel. Beššan iɣattes tnt, yezziwwet ag ǎsuf s tinariwén. ");
INSERT INTO thv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yessestent Ƹisa : « Isem ennek ? » Yenna has : « Isem in Ǎǧut. » Edét eǧǧeten kél ǎsuf wi-dt ehenén. ");
INSERT INTO thv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eqqimen laqqedent baš wr tn éd isiwiy tihay n ǎkǎhem wrn ilé édér. ");
INSERT INTO thv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Émér héndɣ illé éheré mǎqqeren n elxenzéren yeḍanen fol tadreq. Elɣeden kél ǎsuf Ƹisa baš éd tn isiwiy dɣ elxenzéren. Yerḍa sn. ");
INSERT INTO thv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","As egmeḍen ales, eggehen dɣ elxenzéren. Éheré imda yenḍew iman ennét fol térgit dɣ geréw, yemmut, ekšen tn aman. ");
INSERT INTO thv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","As eneyen imaḍanen awa iǧen, eṭkelen iman nsn, eǧen isǎlan dɣ aɣrem d tinariwén emdan. ");
INSERT INTO thv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Egmeḍen-d ǎddunet egmayen éd eynin awa iǧen. Osen in ɣor Ƹisa, osen ales wa-d egmeḍen kél ǎsuf, yeqqim ɣor Ƹisa, ilsa, yemmugnet, as eneyen awén eksoḍen. ");
INSERT INTO thv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wi eneynén awa iǧa ales wanǧam ehan kél ǎsuf yennejja eǧen asn isǎlan. ");
INSERT INTO thv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ǎddunet emdan win ǎkal wan Eljarisiyin ennen as i Ƹisa éd yefel ǎkal, édét eksoḍen hullan. Yewen Ƹisa elfelluka, yegla. ");
INSERT INTO thv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ales wa-d egmeḍen kél ǎsuf, ilaqqedt baš éd ds yidaw, beššan yugey as Ƹisa, yenna has : ");
INSERT INTO thv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","« Aqqel ihenan ennek, d tenned elxér wa hak iǧa Yaḷḷah. » Yegla yeqqim iganna awa has iǧa Ƹisa dɣ aɣrem imda. ");
INSERT INTO thv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","As in yeqqel Ƹisa dɣ Jalila, erreḥebent ǎddunet ǎǧǧotnén has eqqalnén. ");
INSERT INTO thv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Γor déndɣ a hin yosa ales iyyen iǧan isem Yayrus, yǎmosen amɣar n éhen n téɣeré. Yenḍew iman ennét dat Ƹisa, ilaqqedt éd hin yas ɣors ");
INSERT INTO thv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","édét wr ilé ar tarrawt iyyet ɣas, telat ɣor meraw d essin iwetyan, yebok éd tt iba. Yeddéw ds beššan ǎddunet eɣlayen as, eẓmament. ");
INSERT INTO thv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tehén tǎmǎṭ iyyet dɣ yeffay ahni a ilan meraw iwetyan d essin. Wrt illé ǎḍebib wr tosé, emdan yender asn éd tt tzuzyin. ");
INSERT INTO thv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Toheẓ in Ƹisa s ḍeffer, teḍes ǎbašekšek n ereswey ennét, dɣ émér héndɣ d teḍes, yeṭṭef in ahni. ");
INSERT INTO thv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Adih yenna Ƹisa : « Mi hi yeḍesen ? » Emdan ennen weggén entenéḍ. Yenna has Betrus : « Muƹalim, ǎddunet élwan eɣlayen ak, eẓmamen key. » ");
INSERT INTO thv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Beššan yenna Ƹisa : « Yeḍes ahi iyyen, édét ofreyeɣ i eṣṣahet iyyet tegmaḍ ahi. » ");
INSERT INTO thv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Telmed tǎmǎṭ as teffuker, ezzar toheẓ in Ƹisa tehikeḍkeḍ, tenḍew iman ennét dats. Tenna dat ǎddunet emdan mafol teḍes aselso wan Ƹisa d menék awa teǧa tezzey dɣ émér héndɣ d teḍes. ");
INSERT INTO thv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yenna has Ƹisa : « Talyaṭin, taflest ennem tezzozey km, egel dɣ esselamet. » ");
INSERT INTO thv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A yekka yesséwel Ƹisa, yosin ǎmahal d ifalen tǎɣǎhamt tan Yayrus, yehéwel : « Yellék ǎba tt, wr teẓẓoḍehed elmuƹalim. » ");
INSERT INTO thv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yeslas Ƹisa, yenna i Yayrus : « Wr terméɣed, efles ɣas, éd tezzey. » ");
INSERT INTO thv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","As in éweḍen tǎɣǎhamt, wr yoyyé wl iyyen éd ds yidaw ɣor tarrawt, ar Betrus, Eḥya d Yaƹqub, d imerawen n tarrawt. ");
INSERT INTO thv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ikét nsn esilefen, dɣ érét n iba n tarrawt. Yenna hasn Ƹisa : « Wr teslefem, wr temmut, eḍes ɣas a teǧa. » ");
INSERT INTO thv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eḍsen ds, édét wr eǧen eššek fol iba-nét. ");
INSERT INTO thv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Beššan yeṭṭef tt Ƹisa s ǎfus, yenna has yeṭkal amesli ennét : « Talyaṭ, enker ! » ");
INSERT INTO thv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yeqqel tt-d unfas, tenker déndɣ. Yenna hasn Ƹisa éd tt ekfin ǎmekši. ");
INSERT INTO thv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ekunen imerawen n tarrawt, beššan yenna hasn Ƹisa éd susmin, wr gennin awa iǧen i wl iyyen. ");
INSERT INTO thv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeɣr-d Ƹisa inelkimen-nét win meraw d essin, yekfén terna d elḥikma ti fol eddobén d satteɣen kél ǎsuf, d ti fol éd zuzuyen tornawén. ");
INSERT INTO thv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ezzar yesséwey tn éd xaṭṭeben Elmelek n Yaḷḷah, zuzuyen imérenen. ");
INSERT INTO thv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yenna hasn : « Wr téwéyem ula enḍerren i ǎsikel nwn : wr téwéyem ebelboḍ ula teborit ula tagella ula aẓref. Wr téwéyem senatet tikerbasén ak iyyen dwn. ");
INSERT INTO thv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Id tekkem, ɣeymet dɣ tǎɣǎhamt iyyet ad teflim aɣrem. ");
INSERT INTO thv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Id tosem kud ugeyen ǎddunet éd kewen errexxeben, eflet aɣrem d tebbekbekem agoḍrar fol éḍaren nwn , ilkam éd yeǧǧuhet awén folsn. » ");
INSERT INTO thv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eglen inelkimen, eɣlayen iɣerman emdan, tabeššaren Isǎlan n Elxér, zuzuyen ǎddunet. ");
INSERT INTO thv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yelmed Hérodes, wa yeminakelen fol Jalila, s awén imda. Wr yessén a hé yexxemmem édét gannén ǎddunet wiyeḍ : « Eḥya wan Ǎnesselmaɣ yenker-d ǧér inemmuttan. » ");
INSERT INTO thv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wiyeḍ heḍnén gannén : « Eliya ad-d yemunen. » Wiyeḍ heḍnén gannén daɣ : « Iyyen dɣ ennebiten win éru ad-d yeqqelen. » ");
INSERT INTO thv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yenna Hérodes : « Eḥya ! Eswenkeḍeɣ as éɣef imanin. Ma yǎmos ales wah fol salleɣ iǧiten ennét ? » Igammey éd yeniy Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","As-d eqqelen inemmahalen n Ƹisa, eǧen as isǎlan fol awa eknen. Yeẓmeẓley tn s taghé ɣor ǎkal iǧan isem Beytṣayda. ");
INSERT INTO thv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Beššan elmeden ss ǎddunet ǎǧǧotnén, elkemen asn. Yerreḥebten Ƹisa, yesséwel asn fol Elmelek n Yaḷḷah, yezozey widt ǎsimexaternén. ");
INSERT INTO thv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Deroɣ ǎgǎḍel n tǎfuk as in oheẓen inemmahalen win meraw d essin ɣor Ƹisa, ennen as : « Segel ǎddunet, éd ekkin iɣerman d tiɣermén wi oheẓnén baš éd dsn ekšin d ensin, édét édeg waɣ yesuf, wrt ihé ula enḍerren. » ");
INSERT INTO thv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yenna hasn : « Ekfet tn téteté iman nwn. » Ennen as : « Wr nelé ar semmoset tiǧelwén d essin isolmiyen. Méɣ éd negel iman nnɣ éd-d nezenh ǎmekši i ǎddunet wiɣ emdan ? » ");
INSERT INTO thv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Médden winǧam ǎmosen ɣor semmos iǧiman. Beššan yenna hasn Ƹisa i inelkimen-nét : « Seqqeymet tn s semmoset semmoset temerwén. » ");
INSERT INTO thv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eǧen awa hasn yenna, esɣeymen tn emdan. ");
INSERT INTO thv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeṭkel Ƹisa tiǧelwén tingam semmoset d isolmiyen winǧam essin, yeǧǧeẓey aǧenna, yebarek tiǧelwén, yerẓénet ezzar yekfénet i inelkimen ennét baš éd tn oẓanen i ǎddunet. ");
INSERT INTO thv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ekšen, eyyewenen emdan, yemmeṭkel awa-d yeqqimen : awén meraw d senatet tisenatén ! ");
INSERT INTO thv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ahel iyyen itimuhud Ƹisa ɣas ennét, wrt illé ar inelkimen-nét ɣors, yessesten tn, yenna hasn : « Ma gannen ǎddunet, ma ǎmoseɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ennen as : « Wiyeḍ gannén tǎmosed Eḥya wan ǎnesselmaɣ, wiyeḍ heḍnén gannen tǎmosed Eliya, méɣ wiyeḍ gannén tǎmosed ennebi yeruwen ad yeqqelen. » ");
INSERT INTO thv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","« Mi eqqaleɣ ɣorwen kewenéḍ ? » Yenna has Betrus : « Elmesiḥ n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeẓmeheḍ dsn Ƹisa, yenna hasn éd susmin, wr tn gennin i wl iyyen. ");
INSERT INTO thv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yenna Ƹisa : « Ag ǎwadem, yelzam as éd yaẓer hullan, éd yetweksan ɣor imɣaren d elƹulama wi kettebnén d imerubay wi mǎqqornén, éd yetweŋɣ, d ahel wan keraḍ éd-d yenker ǧér inemmuttan. » ");
INSERT INTO thv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ezzar yenna hasn emdan : « Eré yeran éd hi yelkem, yelzam as éd yeksen iman ennét, yelzam as éd yeɣbel in éd yeggugga ǎfeǧǧaǧ-nét ak ahel, awén yewwijjed in éd yemmet hund nk, ezzar éd hi yelkem. ");
INSERT INTO thv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","I yeɣhelen éd yennej iman ennét, éd tn yexser, beššan i yexseren iman ennét dɣ érétin, wéndɣ éd tn yennej. ");
INSERT INTO thv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mas infa i ǎwadem ǎǧeraw n eddunya temda, kud iɣahhed méɣ iɣasser iman ennét ? ");
INSERT INTO thv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Eré yekrakeḍen foli méɣ fol tiférin, fol wéndɣ Ag ǎwadem éd ikrakeḍ ahel wad éd yas dɣ elmejdin d dɣ elmejd n Abba d ǎngelosen aqquddesnén. ");
INSERT INTO thv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ǎsilekeneɣ awent, ehan kewen wiyeḍ dimaɣ, wr éd emmetten iba wr enéyen Elmelek n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Adih ɣor ettam iheḍan ḍeffer awal wén, yéwey Ƹisa, Betrus d Eḥya d Yaƹqub, yéwen tadreq éd yemuhed. ");
INSERT INTO thv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Émér héndɣ d itimuhud, yebbedel udem ennét, aselso ennét yeqqel imellen hund essam. ");
INSERT INTO thv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Γor déndɣ osent in essin médden, esdewennén ds : médden wih ǎmosen ennebiten Musa d Eliya, ");
INSERT INTO thv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ǎmunen-d dɣ elmejd. Esdewennén fol téklé n Ƹisa ta hé teǧit dɣ Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Betrus d imidiwen ennét ilɣad tn éḍes émér héndɣ, beššan enkeren-d eneyen elmejd wan Ƹisa, eneyen médden win essin d yennibded. ");
INSERT INTO thv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A yekka effalen médden wih Ƹisa, yenna has Betrus i Ƹisa : « Muƹalim, yuf awéndɣ s nella déɣ. Éd nekres keraḍ ihenan, iyyen innek, iyyen in Musa, iyyen in Eliya. » Wr yessén awa iganna. ");
INSERT INTO thv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A yekka yesséwel, yeres-d aẓyar yesselsén s télé ennét. Eksoḍen as eneyen aẓyar wah tn isselsen. ");
INSERT INTO thv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yefel-d aẓyar ǎmesli iyyen : « Awaɣ Ruré, wa eréɣ hullan.. Segdet as. » ");
INSERT INTO thv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","As yesmenda ǎmesli awal ennét, ǎbas yemun ar Ƹisa ɣas ennét. Inelkimen essosemen, iheḍan windɣ wr ennén heret i ǎwadem fol awa eneyen. ");
INSERT INTO thv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ahel wa heḍen, awa-d errasen adrar, emheyyén d ǎddunet aggotnén d ekkanén Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dɣ ammas n ǎddunet, yesɣeret ales iyyen, yenna : « Muƹalim, inhod ad toḍened tǎhanint i ruré, édét enta ɣas a eléɣ ! ");
INSERT INTO thv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Itaggeht ag ǎsuf, ezzar dédih isaɣerat, isandawt s alhin, isagmaḍ as-d tǎkuffé s émi, zernah-t iffal ast yellubbeḍ hullan. ");
INSERT INTO thv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ennéɣ asn i inelkimen ennek éd esteɣen ag ǎsuf beššan yender asn. » ");
INSERT INTO thv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yenna Ƹisa : « Ikét n ikufar ! Ǎddunet exlanén ! Ar emmey éd eqqimeɣ ǧeréwen ? Ar emmey eẓiẓeydereɣ awén ? Awid rurék. » ");
INSERT INTO thv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","As in yoheẓ arraw, yessoḍé ag ǎsuf, yessendewt. Beššan yezmeheḍ ds Ƹisa, yezozey arraw ezzar yerré i tis. ");
INSERT INTO thv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Emdan ǎkunen dɣ terna n Yaḷḷah. A yekka ǎkunen dɣ awa itaǧ Ƹisa imda, yenna hasn i inelkimen ennét : ");
INSERT INTO thv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","« Eknet asgdet i isǎlan wi hawen éd egeɣ dimaɣ : Ag ǎwadem éd yetweɣdar, éd iggeh ifassen n ǎddunet. » ");
INSERT INTO thv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Beššan wr efhémen awa iganna : elmeƹna ennét teffar baš wr tt éd efhemin, eksoḍen éd sestenen Ƹisa fol tifér tih. ");
INSERT INTO thv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tenker temɣnnant ǧér inelkimen n Ƹisa tassenen ma yǎmos wa mǎqqeren ǧérésn. ");
INSERT INTO thv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Beššan ihanney Ƹisa awa ihan ulawen nsn. Yeṭṭef arraw iyyen, yessebdedt édés ennét, ");
INSERT INTO thv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yenna hasn : « Eré yeɣbelen arraw waɣ dɣ érétin, yeɣbel ahi nk imanin, wa hi yeɣbelen, yeɣbel wa hi-d yesséweyen. Édét wa enḍukken ǧeréwen temdam enta a kewen yogeren. » ");
INSERT INTO thv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yenna Eḥya : « Muƹalim, nenay ales iyyen iḍarrenen kél ǎsuf s terna n isem ennek, nenna has wr itiles édét weggén in ǎddunet nnɣ. » ");
INSERT INTO thv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yenna has Ƹisa : « Wr has gennim ula enḍerren, édét wa wrn kewen yeksén ǎmidi nwn. » ");
INSERT INTO thv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","As yohéẓ émér wa-d éd yefel Ƹisa eddunya, yenneheḍ éd yawiy ǎbǎreqqa wan Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yezmahel wiyeḍ dats. Eglen, osen aɣrem iyyen dɣ ǎkal wan Samariten baš éd has zewwejeden. ");
INSERT INTO thv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Beššan ǎddunet n ǎkal ugeyen as édét yennihel Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","As eneyen inelkimen-nét Yaƹqub d Eḥya awén, ennen i Ƹisa : « Émeli, teréd éd-d neseres témsé tan aǧenna éd tn tehheddem hund awa iǧa Eliya ? » ");
INSERT INTO thv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yeznehlem in Ƹisa berén nsn, yeggoret folsn, yenna hasn : « Kewenéḍ wr tessénem emmek n unfas wa kewen imhalen. ");
INSERT INTO thv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tidet, Ag ǎwadem wrd yosé éd isexrek ǎddunet, yos-d éd tn yennej. » Okeyen s aɣrem iyyen heḍen. ");
INSERT INTO thv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ehan ǎbǎreqqa as yenna ales iyyen i Ƹisa : « Éd hak elkemeɣ id tekkéd. » ");
INSERT INTO thv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yenna has Ƹisa : « Ixorhiten elan unan, igḍaḍ elan essuken beššan Ag ǎwadem wr ilé édeg dɣ issensa éɣef-nét. » ");
INSERT INTO thv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yenna i ales iyyen heḍen : « Elkem ahi. » Yenna has ales : « Eyyahi éd enbeleɣ abba hin ezzar. » ");
INSERT INTO thv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yenna has Ƹisa : « Ey inemmuttan éd enbelen inemmuttan nsn, key egel beššer isǎlan n Elmelek n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ales iyyen heḍen yenna : « É Émeli , éd hak elkemeɣ, beššan eyyahi éd egeɣ ar essaɣet i ǎddunetin ezzar. » ");
INSERT INTO thv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yenna has Ƹisa : « Kud illé éré ibuddun ǎgelleb, ikayyed ḍeffers, dédih wr yojéd i Elmelek n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ḍeffer adih, yeɣra Ƹisa essahet temerwén d essin inelkimen daɣ, yesséweyten s essin essin dats dɣ éɣerman emdan wi hé yek enta iman-nét. ");
INSERT INTO thv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yenna hasn : « Ǎferas yegget, beššan osaren elxeddamen t exdemnén, eǧmiyet dɣ messis n ǎferas éd d isiwiy elxeddamen wiyeḍ heḍnén. ");
INSERT INTO thv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eywah ! Enkeret ! Esséweyeɣ kewen hund ikerwaten ǧer ibeggan. ");
INSERT INTO thv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wr téweyem aẓref, ula ǎbelboḍ, ula iɣetémen, wr tesseslemem ǎwadem dɣ ǎbǎreqqa nwn. ");
INSERT INTO thv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Éhen teggehem, s tizaret ennét : -Esselamet folwn-. ");
INSERT INTO thv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kud éhen wah ihé ag esselamet, igrew esselamet nwn, kud wrt ihé ag esselamet, dédih éd kewen-d teqqel. ");
INSERT INTO thv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dɣ tǎɣǎhamt téndɣ ɣeymet, ekšet, eswet awa kewen éd ekfin messawes n éhen, édét ak elxeddam yenihegga d elḥaq-nét. Wr teqqimem takkem ǧer ihenan. ");
INSERT INTO thv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ak aɣrem teggehem dɣ tetiwereḥḥabem, ekšet awa tegrewem. ");
INSERT INTO thv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Zuzyet ǎddunet-nét d tennim asn : -Elmelek n Yaḷḷah yoheẓ kewen-. ");
INSERT INTO thv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Beššan ak aɣrem teggehem dɣ wr tetwereḥḥabem, ekket eẓẓegagen d tennim : ");
INSERT INTO thv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","-Aked agoḍrar wan aɣrem yemelen fol éḍaren nnɣ, éd hawent-in nebbekbek, éd hawent-in ney. Beššan elmedet as Elmelek n Yaḷḷah yoheẓ-. ");
INSERT INTO thv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ennéɣ awen tn, ahel wéndɣ, ǎddunet win aɣrem wan Sodoma toẓẓért nsn éd teqqel meḍriy fol toẓẓért n ǎddunet n aɣrem waɣ. ");
INSERT INTO thv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Elɣib folkm aɣrem wan Korazin ! Elɣib folm aɣrem wan Beytṣayda ! Édét kud tekunt ta teget fol aɣrem nwn, éɣermen win Ṣura méɣ Ṣayda a fol tega, éru a-d eqqimen ǎddunet nsn fol éẓed ǎtuben, ǎsilefen fol ibekkaḍen nsn. ");
INSERT INTO thv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Adih, ahel wan tanaṭ éd yaǧer ǎṣahu folwn i fol Ṣura d Ṣayda. ");
INSERT INTO thv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kewenéḍ wi ezzeɣnén Kafranahum, teɣélem éd tetweṭkalem ar aǧenna ? Xeram awen ! Erés s ǎkal wan inemmuttan a hé teǧim. » ");
INSERT INTO thv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yenna daɣ i inelkimen ennét : « Wa hawen yesigeden yesiged ahi, wa wrn kewen yeɣbél, wr hi yeɣbél, wa wrn hi yeɣbél, wr yeɣbél wa hi-d yesséweyen. » ");
INSERT INTO thv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Eqqelen-d inelkimen n Ƹisa win essahet temerwén d essin eddiwén, ennen as : « Émeli, aked kél ǎsuf nernén s isem ennek. » ");
INSERT INTO thv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yenna hasn : « Enayeɣ Eššeyṭan yoḍa-d dɣ aǧenna hund essam ! ");
INSERT INTO thv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ekfeɣ kewen ǎdabu n téklé fol iššelen, fol iẓordam d fol awa ila ahengo dɣ terna, ula kewen éd yekmun. ");
INSERT INTO thv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Beššan wr teddewém fol in kél ǎsuf ternem tn, yuf awn teddewém in ekteben ismawen nwn dɣ iǧennawen. » ");
INSERT INTO thv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Émér héndɣ, yeṭker Ƹisa tǎdǎwit s Unfas Heddigen, yenna : « Omaleɣ-key, Abba, Émeli n aǧenna d ǎmǎḍal, édét windɣ hereten tessekned-tn i arrawen wi meḍruynén, teffered-tn i imɣaren d wi elenén tayetté. Tidet, Abba, édét awén a tessofed. ");
INSERT INTO thv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ak heret egreweɣt ɣor abbahin, wrt illé wa yessenen ma yǎmos Rurés ar Abba, wrt illé wa yessenen ma yǎmos Abba ar Rurés d was yebok Rurés ǎsekni-nét. » ");
INSERT INTO thv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yeznehlem berén inelkimen ennét, yenna hasn i entenéḍ ɣas : « Ennufleynet téṭṭawen ti henneynén awa thanneyem ! ");
INSERT INTO thv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ǎddobéɣ éd hawen enneɣ as ǎǧut n ennebi d ǎmenokal yeɣhel éd yeney awa thanneyem, wrt enéyen, awas tsallem wr has eslén ! » ");
INSERT INTO thv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yebded elmuƹlim wan eššeréƹa iyyen, yeɣhel éd yarem Ƹisa, yenna has : « Muƹalim, ma hé eǧeɣ baš éd eǧreweɣ tǎmeddort ta teɣlalet ? » ");
INSERT INTO thv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yenna has : « Ma yektaben dɣ Eššeriƹa ? Ma ds teɣréd ? » ");
INSERT INTO thv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yenna has wanǧam : « Eken tera i Émeli, Messineɣ ennek, s ul ennek imda, s iman ennek emdan, s eṣṣahet ennek temda, s tayetté ennek temda, eken tera i ǎmehreǧ hund tera ta tegéd i iman ennek. » ");
INSERT INTO thv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yenna has Ƹisa : « Tennéd tidet, eg awén éd teddered. » ");
INSERT INTO thv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Beššan, yegmey éd yeẓẓel iman ennét, yenna daɣ i Ƹisa : « Ma yǎmos ǎmehreǧin ? » ");
INSERT INTO thv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Adih yenna has Ƹisa : « Ales iyyen yefal-d Yerušelem yekka Yariḥo, erteken fols imekeren, elkesent, oheɣen ds a ila, oyyent deroɣ yemmut. ");
INSERT INTO thv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yokay ǎmǎrabu iyyen dɣ wéndɣ ǎbǎreqqa, yeneyt yoyyé déndɣ. ");
INSERT INTO thv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yemmert in Uléwi iyyen n tawsit n kél tikutawén, yeneyt, yoyyé déndɣ. ");
INSERT INTO thv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Usamari iyyen dédih, yokeyin, enta ǎɣerib n ǎkal waɣ a yǎmos, yessokel, yeneyt, yeŋɣé s tamella. ");
INSERT INTO thv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yoheẓt, yezzuket ɣors, yesséred as ibuysen ennét, yeswert ǎhatim d elboẓa, yettel as tn, yeswert tasnit ennét, yeweyt ar éhen n imessukal iyyen, yemhaha ds. ");
INSERT INTO thv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","As yeffo tufat, yekkes-d essin erriyalen, yekfén i messis n édeg wanǧam, yenna has : -Esseɣlefeɣ ak, mehihi ds, a tebxesed denneg awén fols, yokeyen erriyalen essin wiɣ, éd hak-t erẓemeɣ as d eqqeleɣ-. ");
INSERT INTO thv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","-En ahi : menék wah dsn ǧér wiɣ keraḍ a yeqqalen ǎmehreǧ n ales wah eŋɣen imakeren ? » ");
INSERT INTO thv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yenna has : « Ǎmehreǧ ennét, waɣ has yoḍenen tamella. » Yenna has Ƹisa : « Adih, eǧel eǧ awén aked key. » ");
INSERT INTO thv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dɣ ǎsikel nsn, enta d inelkimen ennét, yosa Ƹisa aɣrem iyyen, terreḥḥebt tǎmǎṭ iyyet dɣ ihenan ennét, isem ennét Marta. ");
INSERT INTO thv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta tela tǎmeḍrayt iyyet tegat isem Meryem. Teqqim ɣor éḍaren n Ƹisa tesiged i awa iganna. ");
INSERT INTO thv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta, tǎmihelhal. Tenna : « Émeli, wr key yekmé in toyyahi tǎmeḍraytin exdameɣ ɣasin ? En as éd hi tilal. » ");
INSERT INTO thv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yenna has Ƹisa : « Marta kem ! Toẓared dɣ a yeggén. ");
INSERT INTO thv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Beššan heret iyyen a ilan tenfa, tafolt taɣ tǎhoseyet a tesnefren Meryem, wr has éd yemmukkes awén. » ");
INSERT INTO thv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ahel iyyen itimuhud Ƹisa dɣ édeg iyyen, as yesmenda, yosé hin iyyen dɣ inelkimen ennét, yenna has : « Émeli, selmed anɣ éd entimuhud, hund awa iǧa Eḥya i inelkimen ennét. » ");
INSERT INTO thv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yenna hasn : « As timuhudem ennet : Abba, emdan éd eqquddesen isem ennek, yasét-d Elmelek ennek, ");
INSERT INTO thv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","teqqimed thakked anɣ tagella nnɣ ak ahel, ");
INSERT INTO thv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","soref anɣ ibekkaḍen nnɣ, édét aked nekkenéḍ ensoruf i wi haneɣ eḍlemnén. Wr hanɣ toyyéd éd neggeh térmitén beššan nejj-anɣ dɣ a yeššaḍen. » ");
INSERT INTO thv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yenna hasn Ƹisa daɣ : « Kud iyyen dewen, yosa ǎmidi iyyen dɣ ammas n éheḍ, yegmey éd has iserḍel keraḍet tiǧelwén, ");
INSERT INTO thv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","édét yekreh ǎmegar dɣ éheḍ, wr ilé as-t yesmager. ");
INSERT INTO thv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kud ǎmidi wah yenna has : « Ekfi elɣafyet, émér waɣ taflut tergal, nk d arrawenin neha édeg nnɣ, wr eddobéɣ éd enkereɣ éd key ekfeɣ awa teréd. » ");
INSERT INTO thv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Elleɣeɣ awn as kud wr éd yenker baš éd-t yekf awén édét ǎmidi ennét a yǎmos, éd yenker éd-t yekf awa yemxater imda fol tekunt n iba n teɣaššimt n ămidi ennét. ");
INSERT INTO thv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nk, ennéɣ awn awén : edelet, éd tegrewem ; egmeyet, éd tasim ; ewtet taflut, éd hawn nar. ");
INSERT INTO thv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Édét éré idelen, éd yegrew, éré yegmeyen éd yas, éré yeweten taflut éd has nar. ");
INSERT INTO thv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Essesteneɣ kewen, leɣteti : ma yǎmos dewen abba wa dɣ éd yegmey rurés ǎsolmi edt yekf aššel ? ");
INSERT INTO thv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Méɣ yegmey ds tesedalt, yeẓẓel as ǎẓérdem ? ");
INSERT INTO thv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ula kewenéḍ wi exlenén, tessanem isuf n tihusay i meddankwen, beršéɣ Abba n Iǧennawen, éd yekf Unfas ennét Heddigen i wi dst egmeynén ! » ");
INSERT INTO thv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesteɣ Ƹisa ag ǎsuf ihan ales iyyen, yekkas as awal. As yegmeḍ ag ǎsuf, yesséwel ales, ǎkunen ǎddunet wi has eɣleynén. ");
INSERT INTO thv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Beššan wiyeḍ ennen : « Isatteɣ kél ǎsuf s terna n Beƹlezabul, amɣar n kél ǎsuf. » ");
INSERT INTO thv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wiyeḍ heḍnén, eran édt armin, egmeyen ds ǎhamol iyyen d ifalen aǧenna. ");
INSERT INTO thv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Beššan yessan awa exximmemen, yenna hasn : « Ak ǎkal s ǎddunet-nét kannesen ǧérésn, éd yehlek ; ak tawsit kanneset d iman-nét éd toḍu. ");
INSERT INTO thv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kud aked Iblis ikannes d iman-nét, menék awa hé yeǧ elmelek-nét éd yeṭṭef ? Édét tennem s terna n Beƹlezabul as satteɣeɣ kél ǎsuf. ");
INSERT INTO thv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kud nk satteɣeɣ-tn s terna n Beƹlezabul dédih menék awa taggen arrawen nwn satteɣen-tn ? Entenéḍ a hé yumasin elqaḍiten nwn. ");
INSERT INTO thv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Beššan kud s aḍaḍ n Yaḷḷah as satteɣeɣ kél ǎsuf, dédih Elmelek n Yaḷḷah yeweḍ kewen-d. ");
INSERT INTO thv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kud ales yeṣṣohén, ilan teẓoli, yogaẓen ihenan ennét, tela ennét teɣlaf, ");
INSERT INTO thv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","beššan kud yosé hin ales t-yernan, yeŋɣé, yekkes ds teẓoli ennét ta fol yesfella d tela ennét, yeẓun tn in emdan. ");
INSERT INTO thv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wa wrn dɣ-i yeddéw, ahengo hin, éré wa wrn hi itilal s asdu, izamezzay. » ");
INSERT INTO thv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","As yegmeḍ ag ǎsuf ales, yehoreǧ yegmay imnay. Wrt yosé, ezzar yenna : « Éd eqqeleɣ ihenanin, windɣ d egmeḍɣ. » ");
INSERT INTO thv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","As in yosa yosén efraḍen, eknan emuken. ");
INSERT INTO thv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dédih yegla yosa essa kél ǎsuf heḍnén éd-t ernanén tǎxellawt, eqqelen-d ezzeɣen. Herrayet n ales wén terna tǎxellawt tizaret ennét. » ");
INSERT INTO thv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A yekka yesséwel Ƹisa, tenna has tǎmǎṭ iyyet teṭkal ǎmesli ennét : « Tengeḍ i tesa ta dɣ tedweled, tengeḍ i ifefan wi tenkesed. » ");
INSERT INTO thv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yenna has : « Tengeḍ ɣas i wi sagadnén i Awal n Yaḷḷah, lakkemen as ! » ");
INSERT INTO thv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Osen in ǎddunet s ǎǧut eɣleyen as, yenna hasn : « Ǎddunet win dimaɣ exlan, gammeyen ǎhamol iyyen n Yaḷḷah, wr éd egrewen ar ǎhamol n ennebi Yunes. ");
INSERT INTO thv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hund awas yeqqal Yunes ǎhamol n Yaḷḷah ɣor kél Niniwa, Ag ǎwadem éd-t yumas i win ezzeman waɣ. ");
INSERT INTO thv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Éd tenker tǎmenokalt n ǎnǎhol ahel wan tanaṭ, éd tseḍlem ǎddunet win ezzeman waɣ, édét tefal-d ikallen wi ogegnén baš éd seged i elmiɣna tan Suleyman. Segdet ! Déɣ illé i yogeren Suleyman ! ");
INSERT INTO thv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ahel wan tanaṭ, kél Niniwa éd enkeren éd emlin dat ǎddunet win dimaɣ, éd tn seḍlemen, édét kél Niniwa ǎtuben ahel wa-d eslen i Yunes. Segdet ! Déɣ illé i yogeren Yunes ! » ");
INSERT INTO thv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","« Wrt illé wa hé isukun énér ezzar éd-t yeffer méɣ édt yeǧ dag ǎkus, kela, afella adt éd yeǧ baš wi-d taggehnén éd hanneyen taffawt. ");
INSERT INTO thv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Téṭ tǎmos énér n taɣessa. Kud téṭ ennek tesxa, taɣessa ennek temda tehét taffawt, beššan kud terin téṭ ennek, taɣessa éd tumas tihay. ");
INSERT INTO thv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hékey ɣas ! Essen kud taffawt ta key tehet wr éd tumas tihay ! ");
INSERT INTO thv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kud taɣessa ennek temda tehét taffawt, sl ula enḍerren n tihay, éd tumas efa temda, hund énér ta hak teget taffawt. » ");
INSERT INTO thv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","A yekka yesséwel Ƹisa, yeƹreḍ-t Elfarisi iyyen éd yemmeklow ɣors. Yeggeh ɣors, yesɣemer. ");
INSERT INTO thv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ast yeney Elfarisi, yekun fol in wr yewweḍa dat ameklu hund elɣada. ");
INSERT INTO thv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yenna has Ƹisa : « Kewenéḍ Elfarisiten ! Zazzagem afella n ikassen a yekka ammas nwn yeṭkar tikra d tǎxellawt ! ");
INSERT INTO thv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ikét n inebbuddal ! Yaḷḷah wa yeknen ǎgenena, weggén enta a yeknen ammas ? ");
INSERT INTO thv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Adih ektet i tileqqiwén s ulawen nwn, dédih ak heret éd hawen yizzag. ");
INSERT INTO thv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Beššan elƹib folwn Elfarisiten, kewenéḍ wi hekkenén i Yaḷḷah tafolt fol merawet n enneɣnaɣ d tǎneṭfért d iškan win iferǧan emdan. Toyyem uẓul d tera wi-d efelnén Yaḷḷah ! Awaɣ as ilzam tiɣawt-nét, sl wr toyyém awa heḍen ! ");
INSERT INTO thv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Elƹib folwn, Elfarisiten, kewenéḍ wi essofnén ideggen wi ezzarnén dɣ éhen n téɣeré d iseslamen dɣ ideggen wi maqqornén ! ");
INSERT INTO thv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Elƹib folwn, kewenéḍ wi olenen d éẓekwan wr amunnén, wi fol gallen ǎddunet bla wr essénen in errigehen folsnt ! » ");
INSERT INTO thv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yenna elmuƹlim iyyen n eššeriƹa : « Muƹalim, s awal wa tagged, tesebbed anɣ aked nekkenéḍ ! » ");
INSERT INTO thv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yenna Ƹisa : « Aked kewenéḍ, elmuƹlimin, elɣib folwn, édét tsawarem ǎddunet aẓuk s asn indar aggay ennét, iman nwn wrt teḍḍisem ula s aḍaḍ ! ");
INSERT INTO thv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Elƹib folwn, édét tkannem idebnan i ennebiten, windɣ neqqen abbaten nwn ! ");
INSERT INTO thv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Temosem dédih imašhaden n abbaten nwn, sakném in terḍam asn, édét entenéḍ a-d tn inaqqen, kewenéḍ a ibunnun idebnan ! » ");
INSERT INTO thv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Fol awéndɣ as tenna elmiɣna n Yaḷḷah : « Éd hasn siwyeɣ ennebiten d inemmahalen, éd dsn eŋɣin wiyeḍ, éd dsn esteɣen wiyeḍ, ");
INSERT INTO thv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ǎddunet win dimaɣ éd erẓemen ahni n ennebiten wa yeŋɣelen wa fol tenta eddunya, ");
INSERT INTO thv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mn ahni wan Habel ar wan Zakariya, wa yemmuten ǧér ǎseɣres wan tikutawén d éhen wan Yaḷḷah. Tidet ! Eḍmaneɣ awn as ǎddunet win ezzeman waɣ, erreẓam a hé eǧin ! ");
INSERT INTO thv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Elƹib folwn, elmuƹlimin win eššeréƹa, édét tekkesem ǎsaru n musnet ! Kewenéḍ wr teggehem, wi erenén éd eggehen, tekkesem asnt ! » ");
INSERT INTO thv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","As yegmeḍ déngam, elmuƹlimin wi kettebnén d Elfarisiten ewwiššenen, ǎkkusen fols, eqqimen sastanent fol hereten ǎǧǧotnén, ");
INSERT INTO thv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","egmeyen édt ermesen, eran édt seḍlemen fol awal ennét. ");
INSERT INTO thv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Émér héndɣ, ǎddunet emelent s ǎgut, ǎmosen iǧiman, ad eqqelen timekukalen. Yenna Ƹisa i inelkimen ennét ezzar : « Uksaḍet elxemméra n Elfarisiten, awén telmenufeɣa. ");
INSERT INTO thv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A yeɣrehen, yelkam éd yeffuker, a yefferen, yelkam éd yuman. ");
INSERT INTO thv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Fol awén awa tennem dɣ tihay éd yegmeḍ dɣ taffawt, awa testektekem dɣ temeẓẓuk n iyyen dɣ éhen yergalen éd has teslim fol isfelen. » ");
INSERT INTO thv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yenna Ƹisa daɣ : « Gannéɣ awn tn imidiwenin : wr teksoḍem wi wrn eddobet ar téneɣé n taɣessa ɣas, beššan ula eddobén sl awén. ");
INSERT INTO thv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Éd hawen leɣteɣ wa hé tuksaḍem : uksaḍet-t Enta, as kewen yeŋɣa, yeddobet éd kewen yenḍu dɣ jahennama. Enneɣ awén tn, Enta as uksaḍet ! ");
INSERT INTO thv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Weggén essin sinkuten as nazzen semmos eẓẓerẓoren, méɣ ? Beššan, wl iyyen, wrt ititaw Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aked imẓaden nwn emdan win éɣef teḍanen. Adih wr termǧɣem : tokeyem ǎtuǧ ǎǧut eẓẓerẓoren ! ");
INSERT INTO thv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Éd hawen tn enneɣ : éré yennen dat ǎddunet in nk ad-t ilan, Ag ǎwadem éd yešhed dat ǎngelosen n Yaḷḷah as innét. ");
INSERT INTO thv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Beššan éré yennen dat ǎddunet in wr hi yezzéy, Ag ǎwadem éd yešhed dat ǎngelosen n Yaḷḷah in wrt yezzéy. ");
INSERT INTO thv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Eré yeǧen erk awal fol Ag ǎwadem, yessoref, beššan éré yesikaferen fol Unfas Heddigen wr ilkem in éd yesoref. ");
INSERT INTO thv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ahel wa-d éd tasim tanaṭ dɣ éhen n téɣeré, méɣ ɣor imenokalen d imɣaren n elḥukuma, wr teksoḍem menék d awa hé tegim méɣ awa hé tennim baš éd tedafƹim fol iman nwn, ");
INSERT INTO thv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","édét Unfas Heddigen éd kewen iselmed awa hé tennim émér héndɣ. » ");
INSERT INTO thv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yenna iyyen dɣ ǎddunet i Ƹisa : « Muƹalim, en as i eɲɲa éd dɣi yoẓan tǎkasit. » ");
INSERT INTO thv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yenna has Ƹisa : « Ales key ! Mi hi yeǧen deh éd umaseɣ elqaḍi nwn, wa itoẓanen awa tlem ? » ");
INSERT INTO thv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ezzar yenna hasn emdan : « Uksaḍet ! Zigẓet iman nwn fol tera n heret, édét aked kud yeɣmar weggén errezɣen n ǎwadem a yeḍmanen tǎmeddort ennét. » ");
INSERT INTO thv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iǧa sn Ƹisa tangalt tah : « Ales iyyen yeɣmaren, ila ǎmǎḍal t ikfen ǎǧut n etteɣam, ");
INSERT INTO thv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","itaxemmam iganna : -Ma hé eǧeɣ ? Ǎbas eléɣ édeg dɣ eǧéɣ etteɣam-. ");
INSERT INTO thv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yenna awah : -Nɣwah awa hé eǧeɣ : éd erẓeɣ izeɣrahin, éd ebnuɣ wiyyeḍ heḍnén meqqornén, éd dsn eǧeɣ etteɣamin d awa eléɣ imda. ");
INSERT INTO thv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ezzar éd enneɣ dɣ imanin : ǎmidihin, teɣmared i iwetyan ǎǧǧotnén, sunfu dimaɣ, ekš, esu d tezhud-. ");
INSERT INTO thv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Beššan yenna has Yaḷḷah : -Tǎmosed ǎnebzuǧ key ! Éheḍ waɣ a dk emmukkesin iman. Mi hé yenfu awa teɣrahed imda ?- » ");
INSERT INTO thv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yenna Ƹisa : « Awéndɣ a iǧarrewen éré yegmayen éd iseɣmer iman ennét, wrn tn iseɣmir dat Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yenna Ƹisa i inelkimen-nét : « Awéndɣ a fol hawen gannéɣ : wr teksoḍem, wr texxemmemem i tǎmeddort awa hé tekšim méy i taɣessa awa hé telsim. ");
INSERT INTO thv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Édét iman ogeren téteté d taɣessa tuf iselsa. ");
INSERT INTO thv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Eynet iɣalgiwen, wr seŋŋilen, wr ferresen, wr elén izeɣrah, beššan Yaḷḷah izakšen ! Kewenéḍ tokeyem ǎtuǧ igḍaḍ s a yeggén ! ");
INSERT INTO thv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma yǎmos dewen wa yeddoben éd isit tǎmeddort ennét folin yermaɣ fols ? ");
INSERT INTO thv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Fol awéndɣ kud ula teddobém i awa wrn yǎmos heret yeggén, mafol texximmemem awa heḍen ? ");
INSERT INTO thv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ekidet menék awa taggenet téṭṭawén n iškan éd enkkernet, wr xeddemnet, wr kenninet iselsa. Beššan, aked Suleyman, a eǧenet tihusay ennét, a yewa wr yekréh iselsa ufenen ula iyyet dɣ téṭṭawén tiɣ. ");
INSERT INTO thv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yaḷḷah, ahel waɣ izihusuy ula iškan dɣ tinariwén, wis tufat eddobén éd eqqeden dɣ témsé beršéɣ kewenéḍ ! Éd kewen isels. Ǎddunet win taflest meḍriyet ! ");
INSERT INTO thv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kewenéḍ ! Wr teqqimem tegmayem abedǎh awa hé tekšim d awa hé teswim, wr teššewwešem. ");
INSERT INTO thv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Awén ellametén n eddunya taɣ wrn ezzéy Messineɣ emdanet ad-t igmayen. Kewenéḍ telam Abba yessanen engom awa temixatarem. ");
INSERT INTO thv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yuf awn tegmeyem Elmelek ennét, dédih éd tegrewem aked awa heḍen imda. ");
INSERT INTO thv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wr teksoḍem, kewenéḍ éheré hin wa derusen ! Édét yeɣhel awn Abba nwn isuf n Elmelek. ");
INSERT INTO thv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Zenhetin tela nwn d tekfim i wi ǎsimexaternén. Eget aẓref nwn dɣ eẓẓeṭamen wrn fettek, sedwet dɣ iǧennawen elmal wa wrn itemendu : imekeren wrt éd akrin, melul wrt éd yeɣhed. ");
INSERT INTO thv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Édét tidet as édeg wa-d illa elmal nwn déndɣ ad illa ul nwn. » ");
INSERT INTO thv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","« Zewwejedet iman nwn, egbeset, suket énéren nwn. ");
INSERT INTO thv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kewenéḍ ! Ulut d éklan wi eqqelnén i messisn, messisn wadih yegla, yekka aẓli iyyen, entenéḍ eqqelen as, éd has arin taflut émér wéndɣ d éd yas éd yeqqebqeb. ");
INSERT INTO thv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tengeḍ i éklan wi hé yas messisn okayen émér wad hin éd yeqqel, émér s d yosa ! Awén tidet a hawen gannéɣ : éd yegbes, éd tn iseqqayem, éd hasn-d yawiy ǎmekši. ");
INSERT INTO thv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kud yos-d ammas n éheḍ méɣ ɣor ihokhaken, yosén okayen, tengeḍ asn ! ");
INSERT INTO thv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Elmedet awah : kud yessan messis n éhen émér wad hin itas ǎmeker, wr éd yey taflut ennét édt terraẓ. ");
INSERT INTO thv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aked kewenéḍ ! Γaymet teziwejjedem iman nwn, édét Ag ǎwadem éd-d yas émér héndɣ dɣ wr has teqqélem. » ");
INSERT INTO thv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yessestent Betrus, yenna has : « Émeli, tagged tangalt taɣ i nekkenéḍ ɣas méɣ tagged tt i ǎddunet emdan ? » ");
INSERT INTO thv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yenna has Ƹisa : « Ma yǎmos amɣar n éklan wa teha ellemana, ilan tayetté ? Weggén was yenna messis éd yexkem yageẓ éklan wi heḍnén, éd tn ihak tiful nsn n ǎmekši ? ");
INSERT INTO thv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tengeḍ i akli wén kud yosé hin messis, émér wa hin yeqqel, itag awa has yenna ! ");
INSERT INTO thv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Awa hawen gannéɣ tidet : édt iseɣlef messis awa ila imda. ");
INSERT INTO thv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Beššan kud akli yenna dɣ iman ennét : -Messi wr-d iteqqel hik-, kud inaq éklan d téklatén wi heḍnén, kud itat isas ixabbeṭ, ");
INSERT INTO thv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dédih messis éd-d yeqqel ahel iyyen méɣ émér iyyen d wr fols yessén akli, éd-t yeŋɣ hullan, éd-t isteɣ, éd has yeǧ awa itaweggén i imaɣdaren. ");
INSERT INTO thv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Akli yessanen awa yera messis, beššan wrt itéǧ, wr izewejjid ula enḍerren, éd yeǧrew tiwit ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Beššan akli wa wrn yessén awa yera messis, kud iǧa a yexlan, wrt éd newet hullan. Wa yegrewen a yeggén, éd ds negmey a yeggén. Wa nesseɣlef a yeggén éd ds negmey denneg awén. ");
INSERT INTO thv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Oseɣ-d éd serɣeɣ témsé fol ǎmǎḍal, ǎsiderheneɣ in éru terɣa ! ");
INSERT INTO thv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ilkam dɣi ǎlǎmaɣ dɣ toẓẓért, wr éd eǧreweɣ imnay ad yakiy. ");
INSERT INTO thv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Teɣélem oséɣ-d éd-d awyeɣ elɣafyet fol ǎmǎḍal ? Kela ! Ganneɣ awén tn, ǎzemmezziy ad-d éwayeɣ. ");
INSERT INTO thv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mn émér waɣ, ǎddunet n éhen iyyen ǎmosnén semmos éd emmezeyen, éd eknesen essin fol keraḍ, keraḍ fol essin. ");
INSERT INTO thv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abba éd yeknes d rurés, arraw d tis, anna d yellés, tarrawt d mas, tǎḍeggalt d tǎḍeggalt ennét. » ");
INSERT INTO thv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yenna Ƹisa i ǎddunet : « As teneyem aẓyar d yefalen ǎgǎḍel n tǎfuk, éd tennim : -Ǎhamol n aǧenna-, awén a hé yeǧin. ");
INSERT INTO thv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","As tofreyem i ǎhoḍ, éd tennim : -Ǎhamol n tuksé-, awén a hé yeǧin. ");
INSERT INTO thv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kewenéḍ wi elenén essin udmawen ! Kewenéḍ essennén téɣeré n ihmal n aǧenna d ǎmǎḍal, mafol wr tessénem téɣeré n awa itaǧǧen dɣ ezzeman waɣ ? ");
INSERT INTO thv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Adih mafol wr teddobém éd telmedem ɣor iman nwn ǎẓemmeẓli n awa yeẓẓelen d awa wrn yeẓẓél ? ");
INSERT INTO thv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Adih as teknased d iyyen, tekkem elmaḥkama, essen wr éd tased a fol tenmeknem animér wr hin téweḍem. Éd tennejed iman ennek ékét-dih wr key yéwey dat elqaḍi, yessewey key elqaḍi ɣor wa isatbaten tinaḍén key isiwyin s tǎkormut. ");
INSERT INTO thv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Éd hak tn enneɣ, wr éd-d tegmeḍed déndɣ ad terẓemed ǎmerwas ennek imda ar sinku wa yehreyen. » ");
INSERT INTO thv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Émér héndɣ, ennen ǎddunet wiyeḍ i Ƹisa menék awa iǧa Bilaṭes yeŋɣa kél Jalila, isartay ahni nsn d wan tikutawén nsn. ");
INSERT INTO thv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yenna hasn Ƹisa : « Tordam as in etweŋɣen kél Jalila wih hund awéndɣ folin ǎmosen inesbekkaḍen ogernén kél Jalila wi heḍnén emdan ? ");
INSERT INTO thv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kela, gannéɣ awn tn, beššan kud wr tetubem aked kewenéḍ temdam éd temmetim. ");
INSERT INTO thv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Méɣ ma tordam daɣ, kuttum ǎddunet win meraw d ettam fol d yoḍa elburj wan Silwam, dɣ Yerušelem, tordam as inaḍlamen ogernén ǎddunet wi heḍnén n Yerušelem a ǎmosen ? ");
INSERT INTO thv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kela, ennéɣ awn tn, beššan kud wr tetubem aked kewenéḍ temdan éd temmetim. » ");
INSERT INTO thv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yegasn Ƹisa tangalt tah : « Ales iyyen ila tahart yessinker tt iyyen ǧér tizzebab ennét. Ahel iyyen yegmey ds aharen, wr tn yosé. ");
INSERT INTO thv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Adih yenna has i ǎnaxdam wa yogeẓen tizzebab : -Ekid, keraḍ iwetyanin, taseɣ d déɣ gammeyeɣ aharen dɣ tahart taɣ, wr tn tiseɣ. Enkeḍ tt dédih ! Mafol tenkar fol ǎmǎḍal bennan ?- ");
INSERT INTO thv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yenna has ǎnaxdam : -Sidi, eyyét ǎwetay waɣ arweh ad éd has ebrekeɣ, éd has egeɣ elɣebar. ");
INSERT INTO thv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dédih tigenén éd taru iwetyan wid eglenén, kud kela, dédih en ahi éd tt enkeḍeɣ-. ");
INSERT INTO thv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ahel iyyen n essebet yǎmosen ahel wan tesonfat, isaɣra Ƹisa dɣ éhen n téɣeré. ");
INSERT INTO thv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Adih, tella dén tǎmǎṭ iyyet, tela meraw iwetyan d ettam yeṭṭaf tt ag ǎsuf, yesikerembey tt, wr teddobet éd tǎẓẓel iman ennét fo. ");
INSERT INTO thv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","As tt yeney Ƹisa, yeɣrét, yenna has : « Tǎmǎṭ kem ! Tereǧed dɣ torna ennem ! » ");
INSERT INTO thv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yeswer tt ifassen ennét. Émér héndɣ tebded, teqqim tamel Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Beššan amɣar wan éhen wan téɣeré yewweššen dɣ érét in yezozey Ƹisa ahel n essebet, yenna i ǎddunet widt ellenén : « Ellant seḍis iheḍan dɣ wis neddobet elxedmet, aset-d iheḍan windɣ baš éd dsn tezzeyem, beššan weggén ahel wan essebet ! » ");
INSERT INTO thv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yenna Ƹisa : « Ikét n ǎddunet n essin udmawen ! Ahel wan essebet, ak iyyen dwn itar ésu ennét méɣ eyhéḍ ennét baš éd-t isesu, tidet méɣ bahu ? ");
INSERT INTO thv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tǎmǎṭ taɣ, welt Ibrahim, yekraf tt Eššeyṭan meraw iwetyan d ettam, mafol wr yenhegga éd tt etreǧeɣ ahel n essebet ? » ");
INSERT INTO thv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Awa yenna yezɣeššem imiksenen ennét, beššan ǎddunet wi heḍnén ezhan fol tikunén-nét. ");
INSERT INTO thv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yenna Ƹisa : « Ma-d yola Elmelek n Yaḷḷah ? Ma-dt éd suluɣ ? ");
INSERT INTO thv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yola d taḍaq tan elxerdel yeṭkel ales iyyen, yesseŋɣel tt dɣ ǎfǎraǧ ennét : Tenker, tǎmos ašek, eknen igḍaḍ essuken nsn fol éẓlan ennét. » ");
INSERT INTO thv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yenna Ƹisa daɣ : « Ma-d éd suluɣ Elmelek n Yaḷḷah ? ");
INSERT INTO thv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yola d elxemméra téway tǎmǎṭ éd tt serti d keraḍ modaten n eǧel, elxemméra édt sekef eǧel imda. » ");
INSERT INTO thv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yessokel Ƹisa, itaggeh iɣerman d téɣermén, isaɣra dsn, yennihel Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yessestent ǎwadem iyyen : « Émeli, wrt illé ar heret n ǎddunet n bennan a hé yennejjin ? » Yenna hasn Ƹisa : ");
INSERT INTO thv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","« Egmeyet s eṣṣahet nwn éd teggehim s taflut ta kerroẓet, édét éd hawen tn enneɣ, eggeten éd egmeyen éd eggehen, beššan éd hasn yender. ");
INSERT INTO thv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","As éd yenker messis n tǎɣǎhamt yergel taflut s esaru, éd teqqeymim dɣ ténéré, éd teqqimem taqebqabem, ganném : -Émeli, ar anɣ-. Ed hawen yen : -Wr esséneɣ mi kewen ilen !- ");
INSERT INTO thv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dédih éd has tennim : -Nekša, neswa nertay dk, tesseɣred dɣ eẓẓegagen n aɣrem nnɣ-. ");
INSERT INTO thv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Beššan éd hawen yen daɣ : -Wr esséneɣ i kewen ilen. Enkehet in foli, kewenéḍ wi teggenén a wrn yeẓẓél-. ");
INSERT INTO thv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Déndɣ ad éd tselfim, éd ẓekkeẓeẓim timɣas nwn, as éd teynim Ibrahim, Isḥaq, Yaƹqub d ennebiten emdam dɣ Elmelek n Yaḷḷah, a yekka kewenéḍ tenḍawem-in dɣ ténéré ! ");
INSERT INTO thv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Éd-d asin ǎddunet d efalnén foy d ǎnǎhol, aǧmoḍ d aǧeḍel n tǎfuk, éd eqqeymin i ǎmǎǧaru dɣ Elmelek n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dédih, wiyeḍ dɣ wi ehreynén éd izaren, wiyeḍ dɣ wi ezzarnén éd ehreyen. » ");
INSERT INTO thv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Émér héndɣ oheẓent-in Elfarisiten wiyeḍ ennen as : « Erwel, efel édeǧ waɣ, Hérodes yera éd key yeŋɣ. » ");
INSERT INTO thv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yenna hasn Ƹisa : « Aset ǎxorhi wah, ennet as : Satteɣeɣ kél ǎsuf, zuzuyeɣ imérenen ahel waɣ d tufat, ahel wan keraḍ éd semmenduɣ awa kanneɣ. ");
INSERT INTO thv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Beššan ahel waɣ, tufat d ahel hén ilzam ahi éd akyeɣ ǎbǎreqqa hin, édét ennebi wr has yemmukken tǎmettant dɣ édeǧ wrn yǎmos Yerušelem-. ");
INSERT INTO thv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerušelem, Yerušlem kem, kem ta tnaqqet ennebiten, kem ta teggaret éẓẓeden fol ǎddunet wi ham-d yessewey Yaḷḷah ! Menekét iméren eɣheleɣ éd sedweɣ meddanek ɣori hund awa tag tekehit tsadaw ifellusen dag tifakfakén ennét, beššan tuǧeyem ! ");
INSERT INTO thv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Adih, tǎɣǎhamt nwn édt tetwenḍaw. Beššan, ennéɣ awn tn, wr hi éd teynim ar émér wad éd tennim : Tǎbareka wad yosen dɣ isem n Émeli. » ");
INSERT INTO thv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ahel iyyen n essebet, yǎmosen ahel n tesonfat, ikka Ƹisa berén amɣar iyyen n Elfarisiten baš éd yekš ɣors. Wi-t ellenén déndɣ eknan as ǎkeyad. ");
INSERT INTO thv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Adih yeqqim dats ales yerinen, tehiḍeḍey taɣessa ennét. ");
INSERT INTO thv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesséwel Ƹisa, yessesten Elfarisiten d elƹulama win eššereƹa, yenna hasn : « Yessérrex anɣ méɣ kela éd nezuzey ahel n assebet ? » ");
INSERT INTO thv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ǎqqimen essôsemen. Dédih yeḍes Ƹisa ǎméren, yezozey-t ezzar yenna has éd yegel. ");
INSERT INTO thv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ezzar yenna hasn : « Ma yǎmos dwn was kud ila rurés méɣ ésu yoḍen dɣ anu, wrn t-id éd yekkes hik aked ahel wan essebet ? » ");
INSERT INTO thv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aked déɣ wr essenen a has éd ennin. ");
INSERT INTO thv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","As yeney Ƹisa imegaren sanefranen ideggen wi ufenén éd dsn eqqeymin, yeǧa sn adih tangalt wah : ");
INSERT INTO thv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","« As key yesimagaret iyyen dɣ aẓli, wr éd teqqeymed dɣ édeg wa yufen. Édét kud yera illé iyyen key yufen yetiweƹraḍ. ");
INSERT INTO thv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Éd key in yas wa yeƹraḍen éd hak yenn : -Ey as édeg waɣ-. Dédih s teɣaššimt éd teqqeymed dɣ édeg wa yehreyen. ");
INSERT INTO thv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kela, as tetiweƹraḍed, ɣeyem dɣ édeg wa yehreyen, baš as éd yas wa yeƹreḍen, éd hak yen : -Ǎmidihin, eyow, aheẓ ahid-. Dédih éd hak yumas a yehoseyen dat imegaren emdan wi ɣork ellenén. ");
INSERT INTO thv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Édét éré yeṭkalen iman ennét, éd yeres, éré yesiresen iman ennét éd yeṭkel. » ");
INSERT INTO thv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ezzar yenna Ƹisa i wa-t yeƹreḍen : « As teknéd ameklu méɣ amensu, uksaḍ éd teƹreḍed imidiwen ennek, ula ayet-mak, ula ǎddunet ennek, ula inaraǧen ennek wi eɣmernen, édét eddoben éd key eƹreḍen aked entenéḍ, éd hak errin awa teǧéd. ");
INSERT INTO thv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kela, as tkanned ǎmegaru mǎqqeren, yuf ak éd semmegured tilaqqiwen d inebdonen d wi asiketewnén d imeddorɣal. ");
INSERT INTO thv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Éd teddewéd édét wr eddoben éd hak eẓẓelen elxér wa hasn teǧéd. Éd terẓemed ahel wan tébeddé n wi ehenén ǎbǎreqqa yeẓẓalen. » ");
INSERT INTO thv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","As yesla i awal wah, iyyen dɣ imegaren yenna i Ƹisa : « Tengeḍ i wa yeddoben éd yeqqayem dɣ Elmelek n Yaḷḷah, éd ds yekš ! » ");
INSERT INTO thv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yegas Ƹisa tangalt tah : « Ales iyyen yekna ǎmegaru mǎqqeren, yenna éd isemmensu ǎddunet aggotnén. ");
INSERT INTO thv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","As yeweḍ émér n amensu yessewey akli ennét s imegaren, yenna hasn : -Eyawet, taɣera temda tekna-. ");
INSERT INTO thv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Beššan emdan s iyyen iyyen eqqimen eǧmayen ǎsaruf baš wr hin éd asin, wa yezzaren yenna has : -Ezzenheɣ ǎfǎraǧ, ilzam ahi éd-t aseɣ éd-t eyneɣ, inhod a hi tessorefed-. ");
INSERT INTO thv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Iyyen heḍen yenna : -Ezzenheɣ meraw éswan, ilzam éd dsn emhihiɣ, inhod a hi tessorefed-. ");
INSERT INTO thv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iyyen heḍen yenna : -Nk ékét d eǧéɣ éhen, wr eddobéɣ éd hin aseɣ-. ");
INSERT INTO thv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yeqqel akli ɣor messis, yegas isǎlan. Adih amɣar n tǎɣǎhamt wah, yewweššen, yenna has i akli ennét : -Enker, ek aɣrem hik, ek eẓẓegagen emdan, wi meḍruynén aked wi meqqornén, wr toyyéd tilaqqiwén ula inebdan ula wi asiketewnén ula imeddorɣal-. ");
INSERT INTO thv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","As yokey émér iyyen, yos-d akli yenna has : -Eǧéɣ awa hi tennéd, beššan yellé édeg arwah-. ");
INSERT INTO thv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yenna has messis : -As ibereqqaten, ilal ifarran, en asn i ǎddunet éd-d asin s tekereṭ ad teṭker tǎɣǎhamtin. ");
INSERT INTO thv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ennéɣ awn tn adih, wl iyyen dɣ wi ezzarnén eƹreḍeɣ wr yelkém as yorem ǎmegaru !- » ");
INSERT INTO thv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ǎddunet aggotnén eddéwen d Ƹisa. Yeznehlemin ssn, yenna : ");
INSERT INTO thv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","« Wa dɣi yeddéwen, wrn yeksén d tis d mas d hennis d meddans d ayet-mas d eššét mas d aked iman ennét, dédih wr éd yumas ǎnalkamin. » ");
INSERT INTO thv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Eré wrn yeṭkél tǎgettewt-nét, awén yewwijjed in éd yemmet hund nk baš éd hi yelkem wr yeddobet éd yeqqel ǎnalkamin. ");
INSERT INTO thv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Adih, kud iyyen dwn yera éd yebnu tǎɣǎhamt toggat, weggéɣ tǎɣimit a hé yeǧ éd iséḍen aẓref ennét, éd yessen yegdeh has baš ed isemmendu elbeni ezzar ? ");
INSERT INTO thv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","As wr iǧé awén, yessenta elbeni beššan yender as ǎsemmendu-nét, éd ds eḍsin ǎddunet. ");
INSERT INTO thv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Éd ennin : -Ales wah yessenta elbeni beššan yendar as ǎsemmendu-nnét !- ");
INSERT INTO thv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Méɣ daɣ, kud ǎmenokal iyyen yera éd yek enmeŋɣi, weggéɣ tǎɣimit a hé yeǧ éd yessen ezzar kud yeddobet s meraw iǧiman n ales éd yeŋɣ ǎmiksen ennét ilan senatet temerwén n aǧim n ales ? ");
INSERT INTO thv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kud wrt yeddobet, isiwyét ǎmahal i ǎmenokal wa heḍen animér yoggeg, éd yessen wr éd eǧin elɣafyet. ");
INSERT INTO thv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Fol awén, wl iyyen dwn wr yeddobet éd yeqqel ǎnalkamin kud wr itiy awa ila imda ḍeffers. ");
INSERT INTO thv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tésemt tenfa. Beššan kud ǎbas tela ténḍé, menék awa hé neǧ éd has tt ner ? ");
INSERT INTO thv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ǎbas tenfa heret, wr tenfé ǎmǎḍal ula ezzebel, éd tt in nenḍew dɣ ténéré. Eré ilan tǎmeẓẓuk isegdét ! » ");
INSERT INTO thv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Taheẓen inarmasen n tiwsé d inesbekkaḍen ǎǧǧotnén emdan ɣor Ƹisa, sagaden as. ");
INSERT INTO thv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Beššan Elfarisiten d elƹulama wi kettebnén estekteken, gannén : « Ales waɣ itarexxab inesbekkaḍen, yertay dsn s téteté ! » ");
INSERT INTO thv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Adih yega sn Ƹisa tangalt tah : ");
INSERT INTO thv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","« Ma yǎmos dwn ilan téméḍé n téhelé, ezzar texrek as iyyet, weggéɣ éd yey teẓẓahet temerwén d teẓẓa ti eqqimnén dɣ tinariwén baš éd yegmey ta texreket ad tt yas ? ");
INSERT INTO thv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","As tt éd yas, éd yeddewet, éd tt isewer éẓéren ennét, ");
INSERT INTO thv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","éd yeqqel ihenan ennét, éd yeɣer imidiwen ennét d imehreǧen ennét, éd hasn yen : « Ahret dɣi tǎdǎwit, édét oséɣ téhelé hin, ta hi texreket ! » ");
INSERT INTO thv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hund awéndɣ as éd hawen tn gannéɣ, togǎr tǎdewit dɣ aǧenna i ǎnesbekkaḍ iyyen yetuben i teẓẓahet temerwén d teẓẓa eẓẓalnén wrn eré tetubt. ");
INSERT INTO thv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","« Méɣ adih ma tǎmos tǎmǎṭ ta tlet meraw erriyalen, kud yexrek as iyyen, dédih wr éd tsuk énér, éd tefreḍ tǎɣǎhamt, éd teken ǎgǎmay ad tas erriyal wa yexreken ? ");
INSERT INTO thv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ast tegrew, éd teɣer timidiwén ennét d tinaragén ennét, éd hasnt ten : « Ahermet dɣi tǎdǎwit, édét oséɣ erriyalin wa yexreken ! » ");
INSERT INTO thv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Enneɣ awn tn, hund awéndɣ as temmal tǎdǎwit ǧér ǎngelosen n Yaḷḷah i ănesbekkaḍ iyyen yetuben. » ");
INSERT INTO thv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yenna Ƹisa daɣ : « Ales iyyen ila meddans essin. ");
INSERT INTO thv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wa meḍriyen yenna has i tis : -Abba, ekf ahi tafoltin dɣ tǎkasit-. Yenker tisn yeẓun tǎkasit ǧér meddans. ");
INSERT INTO thv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","As okeyen iheḍan wiyyeḍ, yeṭkel wa meḍriyen kaya ennét imda ezzar yegla dɣ ikallen ogegnén. Yebxes awa ila imda, aẓref dɣ ǎǧut ennét, yebxest, itag a yexlan. ");
INSERT INTO thv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","As yeŋɣa awa yeṭṭef imda, tos-d menna mǎqqeret dɣ ǎkal wah, yemxater. ");
INSERT INTO thv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yosa ɣor ales iyyen n ǎkal, yessoḍent elḥellufen dɣ tinariwén. ");
INSERT INTO thv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Igas laẓ ǎsemmenenneḍ wa dɣ fol d yeqqel isaderhan téteté n elxernub wa tetten elḥellufen, beššan wrt illé i hast ikfen. ");
INSERT INTO thv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ezzar yessoɣel-d, yenmeqqal d iman ennét, yenna dɣ iman ennét : « Elxeddamen win abba hin emdan kannen téteté, nk elléɣ déɣ inaq ahi laẓ ! ");
INSERT INTO thv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Éd enkereɣ, éd egleɣ éd has enneɣ i abba hin : -Abba, ǎbodereɣ-key, egéɣ awn ǎbekkaḍ, key d Yaḷḷah, ");
INSERT INTO thv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ǎbas ǎniheggeɣ éd umaseɣ rurék. Eken dɣi ǎnaxdam ennek. » ");
INSERT INTO thv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yenker, yegla, yekka awas illa tis. Yeneyt tis dɣ igeg, yeŋɣé s tamella, yohel ss, yeṭṭeft dɣ ifassen ennét itimellut as. ");
INSERT INTO thv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yelleɣet as : « Abba, ǎbodereɣ-key, eǧéɣ ǎbekkaḍ i Yaḷḷah, ǎbas ǎniheggeɣ éd umaseɣ rurék. » ");
INSERT INTO thv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Beššan yenna tis i inaxdamen ennét : « Ermaḍet awyet-d tikemsén ti tnt ufenen, d selsimt, eget as tiseq dɣ aḍaḍ d iɣetémen dɣ éḍaren. ");
INSERT INTO thv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Awyet-d ǎloki wa yedderén, eŋɣet, éd has neǧ ǎmǎǧaru d teramman, ");
INSERT INTO thv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","édét arrawin wa eba yeqqel-d tǎmeddort, yexrak yettegrew-d. » Eǧen teramman. ");
INSERT INTO thv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Émér héndɣ rurés wa mǎqqeren iha iferǧan. As-d yeqqel, yoheẓ in tǎɣǎhamt, yesla i teramman d ǎrekkoḍ. ");
INSERT INTO thv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yeɣra iyyen dɣ inaxdamen , yessestent fol awa itaggen. ");
INSERT INTO thv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yenna has ǎnaxdam : Ǎmeḍray ennek yeqqel-d, abba ennek yeŋɣas ǎloki wa yedderén édét yegrew-d yeslam. » ");
INSERT INTO thv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yewweššen, ezzar yugey éd yeggeh tǎɣǎhamt. Yosé hin tis baš éd-t ilɣed éd yeggeh. ");
INSERT INTO thv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yenna has i tis : « Nk, eléɣ iwetyan exdameɣ ɣork, a ewéɣ wr key ǎbodereɣ. Beššan a ewéɣ wr hi tekféd ula éɣeyd baš éd egeɣ teramman nk d imidiwenin. ");
INSERT INTO thv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dimaɣ as-d yeqqel rurék waɣ, enta wa yekšen aẓref ennek ɣor timasrayén, enta teŋɣéd as ǎloki wa yedderén ! » ");
INSERT INTO thv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yenna has tis : « Arrawin, key telléd abedǎh ɣori, a eléɣ innek. ");
INSERT INTO thv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Beššan ilzam anɣ éd neddewet, éd neǧ teramman édét ǎmeḍray ennek waɣ eba teqqelt id tǎmeddort, yexrak, dimaɣ yettegrew. » ");
INSERT INTO thv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yenna Ƹisa awah daɣ i inelkimen ennét : « Kelad t-illa ǎnesbeɣor iyyen ilan ǎnaẓraf, yehéwel as in ǎnaẓraf wah ibaxxes as tela ennét. ");
INSERT INTO thv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yeɣré hid, yenna has : -Ma itahawalen folk ? Ǎréɣ éd hi telleɣéd emmek was texdemed tela hin, édét ǎbas ǎréɣ eššeɣel ennek. ");
INSERT INTO thv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yenna ǎnaẓraf dɣ iman ennét : -Ma hé eǧeɣ, yekkes dɣi messi elxedmetin ? Elxedmet n ǎmǎḍal, wr has eléɣ eṣṣahet ; ǎǧemay n édél, yeziɣeššem ahi. ");
INSERT INTO thv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Essaneɣ awa hé eǧeɣ baš éd hi tarrexabben ǎddunet ɣorsn, as ebas eléɣ elxedmetin ! ");
INSERT INTO thv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yessosin ǎddunet emdan wi yellil messis. Yenna i wa yezzaren : -Menekét a key yellil messi ? ");
INSERT INTO thv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yenna has : -Téméḍé n elbeteyyet n ǎhatim. Yenna has ǎnaẓraf : -Γeyem ekteb in hik fol elkaḍ ennek wan ǎmerwas semmoset temerwén-. ");
INSERT INTO thv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yessesten iyyen heḍen : -Key menekét ?- Yenna : -Téméḍé n eššekaret n éred-, yenna has ǎnaẓraf : -Eṭṭef elkaḍ ennek, ekteb ettamet temerwén-. ");
INSERT INTO thv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yomel messis ǎnaẓraf wan ǎmaɣdar édét yessimsed tayetté ennét. Yenna Ƹisa : « Kél eddunya taɣ oǧeren tela n tayetté dɣ tumast ǧérésn i kél taffawt. ");
INSERT INTO thv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nk éd hawen tn enneɣ, egmeyet imidiwen dɣ aẓref wrn yeẓẓél n eddunya taɣ, ahel wa-dt éd iba, éd tegrewem édeg dɣ ihenan eɣlalnén. ");
INSERT INTO thv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Eré yeɣdalen dɣ awa feroren, yeɣdal dɣ awa mǎqqeren, éré wrn yeẓẓél dɣ awa feroren wr yeẓẓél dɣ awa mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kud wr teɣdélem dɣ aẓref wrn yeẓẓél n eddunya taɣ, mi hawen éd iseɣlefen errezɣen win tidet ? ");
INSERT INTO thv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kud wr teɣdélem dɣ éheré n wi heḍnén, mi kewen éd yekfin éheré nwn ? ");
INSERT INTO thv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","« Wrt illé akli yeddobén elxedmet i essin imelan : éd yakeḍ d iyyen éd yeɣhel wa heḍen, méɣ éd yekf iman ennét i iyyen yekyeḍ wa heḍen. Wr yeddobet ǎwadem éd yumas akli n Messineɣ aked akli n aẓref. » ");
INSERT INTO thv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Elfarisiten esigeden i awén hǎret, ḍazzen ds, édét entenéḍ eran aẓref. ");
INSERT INTO thv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yenna hasn Ƹisa : « Kewenéḍ, tsakném iman nwn dat ǎddunet in teẓẓalem, beššan Messineɣ yessan awa ihen ulawen nwn. Awa eṭkalen ǎddunet, yeššaḍ ɣor Messineɣ. ");
INSERT INTO thv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ezzeman wan eššeriƹa d wan ennebiten yemmenda ɣor Eḥya. Dédih, mn déndɣ taweggén Isǎlan n Elxér fol Elmelek n Yaḷḷah. Ak iyyen yera ds uǧuh s eṣṣahet. ");
INSERT INTO thv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Beššan nehil iba n aǧenna d ǎmǎḍal i artuk n tetbeqqét ta metteket dɣ eššeriƹa. ");
INSERT INTO thv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Eré yellefen hennis, yewey iyyet heḍet, wadih izna, méɣ éré yeweyen tǎmǎṭ yellef ales iyyen heḍen, wadih izna. » ");
INSERT INTO thv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","« Kelad-t illa ǎnesbeɣor, ilassen iselsa wi tn ufenén, wi eɣlenén. Ak ahel itag ezzeho, itat imekšan ǎẓédnén. ");
INSERT INTO thv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dat émi n tǎɣǎhamt ennét, tenḍaw taleqqé iyyet, isem ennét Lazar. Taɣessa ennét teṭkar ibuysen. ");
INSERT INTO thv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Isaderhan téteté n awa-d iratteken dɣ imekšan n ales wanǧam. Aked iyyeḍan talleɣen as ibuysen ennét. ");
INSERT INTO thv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Temmut talǎqqé, éweyen tt ǎngelosen ɣor Ibrahim. Ǎnesbaɣor aked enta yemmut, yetwenbal. ");
INSERT INTO thv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iha ǎkal wan inemmuttan dɣ ihanney ǎɣena, yeṭkel esawaḍ ennét yeney Ibrahim dɣ igeg, illa ɣors Lazar. ");
INSERT INTO thv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yesɣeret : « Abba Ibrahim, aḍen ahi tǎhanint, zemmihel-d seri Lazar éd yeselmeɣ aḍaḍ ennét dɣ aman éd isesmeḍ ilesin, toẓar ahi témsé ta ehéɣ. » ");
INSERT INTO thv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yenna has Ibrahim : « Arrawin, semmektu in kelad teǧrawed a yeggén dɣ tǎmeddort ennek, Lazar wr yenéy ar ǎɣena. Dimaɣ enta yella déɣ, yessismeḍ, key toẓared. ");
INSERT INTO thv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yota fol awén in gér énɣ dewen yellé édér mǎqqeren, wi erenén éd haneɣ eflin ekkan kewen wrt eddobén, wi erenén éd kewen eflin ekkananeɣ-d wrt eddobén. ");
INSERT INTO thv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yenna ales : « Inhod, abba, siwiy Lazar s tǎɣǎhamt n ti, ");
INSERT INTO thv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","eléɣ ds semmos ayet ma. Yasét tn, éd tn isemmeter, baš wr-d éd asin aked entenéḍ dɣ édeg waɣ iha ǎɣena. » ");
INSERT INTO thv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Yenna has Ibrahim : « Ayet mak elan Musa d ennebiten : segdin asn ! » ");
INSERT INTO thv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yenna ales : « Kela, abbahin Ibrahim, wr hasn yegdeh awén. Beššan kud yosén in éré d yefalen ɣor inemmuttan, éd utaben. » ");
INSERT INTO thv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yenna has Ibrahim : « Kud wr segiden i Musa d ennebiten wr éd segdin aked i éré d ifalen ɣor inemmuttan. » ");
INSERT INTO thv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yenna Ƹisa i inelkimen ennét : « Wr yemmukken in wrt éd yemel essebab n ǎbekkaḍ, beššan yokel wadt id itaweyen ! ");
INSERT INTO thv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yuf as tetwekred as tǎhunt ta mǎqqeret dɣ éri ennét, ezzar yetwegar dɣ geréw, ula yǎmos essebab n ǎbekkaḍ ula wa meḍriyen dɣ wiɣ. ");
INSERT INTO thv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Uksaḍet fol iman nwn ! Kud yeǧa eɲɲak ăbekkaḍ, siwel as. Kud yetub, soref as. ");
INSERT INTO thv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kud iǧak ăbekkaḍ essa iméren dɣ ahel iyyen, kud ak émér itaqqel keyd iganna : -Ǎtubeɣ-, soref as. » ");
INSERT INTO thv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ennen as inemmahalen i Ƹisa : « Sit taflest nnɣ. » ");
INSERT INTO thv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yenna hasn : « Kud taflest nwn togda d taḍaq n elxerdel, teddobém éd tennim i ašek waɣ n ettut : -Estef iman ennek d tekked ǧeréw emel ds-, éd hawen iseged, éd yeǧ awa has tennem. » ");
INSERT INTO thv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kud iyyen dwn ila akli has yexdamen iferǧan méɣ has yeḍḍanen éheré, kud yeneyt yeqqal-d ihenan, éd has yen méɣ : -Ermaḍ, as-d éd tekšed ?- ");
INSERT INTO thv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kela, éd has yen : -Seɲ ahi amensu hin, egbes ezzar ekf ahi-d a ekšéɣ d a eswéɣ. As esmendɣ dédih éd tekšed éd teswed-. ");
INSERT INTO thv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tordam as in ales wéndɣ éd yummay i akli ennét fol awad-t iweren. ");
INSERT INTO thv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kewenéḍ daɣ, as tesmendem elxedmet nwn, ennet : -Wr nemos ar éklan wrn enfé heret, wr negé ar awa haneɣ iweren-. » ");
INSERT INTO thv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A yekka Ƹisa yennihel Yerušelem, yellil ǎbǎreqqa ǧér Samira d Jalila. ");
INSERT INTO thv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","As yoheẓ aɣrem iyyen enkeden asin meraw médden teǧraw torna tan élem mellen. Ebdeden dɣ igeg. ");
INSERT INTO thv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ezzar eqqimen esiɣerén : « Ƹisa, Muƹalim, aḍen anɣ tǎhanint ! » ");
INSERT INTO thv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","As tn yeney Ƹisa, yenna hasn : « Eglet, seknet iman nwn i imerubay. » Eglen, dɣ ǎbǎreqqa ezzeyen. ");
INSERT INTO thv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iyyen dsn as yeney iman ennét yezzey, yeqqel-d fol tikkal ennét, itamel Yaḷḷah yeṭkal emesli ennét. ");
INSERT INTO thv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yenḍew iman ennét dag éḍaren win Ƹisa, yekfa udem ǎmǎḍal, yemmoy i Ƹisa. Ales wéndɣ yǎmos Samari. ");
INSERT INTO thv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yenna Ƹisa : « Meraw éssen ezzeyen, tidet méɣ kela ? Ma eǧen wi heḍnén teẓẓa ? ");
INSERT INTO thv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wl iyyen wr-d yeqqél éd yamel Yaḷḷah ar ǎɣerib waɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ezzar yenna has Ƹisa : « Enker, egel, tennejjik taflest ennek. » ");
INSERT INTO thv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Essetenen Elfarisiten Ƹisa d émér wa-d éd yas Elmelek n Yaḷḷah. Yenna hasn : « Emelek n Yaḷḷah wr iteǧ tisit temunet. ");
INSERT INTO thv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wr éd yehawel : -Enyet, yos-d deh- méɣ -Illa deh !- Ekidet adih Elmelek n Yaḷḷah illa ǧeréwen. » ");
INSERT INTO thv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ezzar yenna i inelkimen ennét : « Ilkam ahel wad éd tsedderhenem ǎhǎnay ula ahel iyyen n ihilan n Ag ǎwadem, beššan wrt éd teynim. ");
INSERT INTO thv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Éd hawen yehawel : -Enyet, yos-d deh- méɣ -Illa deh !- Beššan wrt tekkém, wr tohélem. ");
INSERT INTO thv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hund éssam wa yokeyen dɣ aǧenna, yemlewlew ds seh ar seh, ad éd yulu Ag ǎwadem dɣ ahel ennét. ");
INSERT INTO thv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Beššan ilkam as éd yaẓer hullan, éd yetweksan ɣor ǎddunet n ezzeman waɣ. ");
INSERT INTO thv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Awa iǧen dɣ ezzeman n Noḥ, a hé yeǧin arweh dɣ ezzeman n Ag ǎwadem. ");
INSERT INTO thv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ǎddunet tatten, sassen, tidawen, sidawen eššéššen ar ahel wa-d yeǧǧeh Noḥ dɣ essendoq wa itaggehen aman : yos-d anǧi wa mǎqqeren, yeŋɣén emdan. ");
INSERT INTO thv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Awa iǧen dɣ ezzeman wan Loṭ, a hé yeǧin arweh. Ǎddunet tatten, sassen, zanhén, saŋŋalen, bunnun. ");
INSERT INTO thv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Beššan ahel wa-d ifel Loṭ Sodoma, yewet-d aǧenna yǎmosen ahes d awḍis, yeŋɣén emdan. ");
INSERT INTO thv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Awéndɣ a hé yeǧin ahel wa-d éd yuman Ag ǎwadem. ");
INSERT INTO thv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ahel héndɣ, wa yeqqimen fol asfel n tǎɣǎhamt ennét, ilen kaya ennét dɣ édér, wr yerris yegmayt, méɣ wa ihen iferǧan wr iteqqelét tǎɣǎhamt ennét. ");
INSERT INTO thv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ektuhet awa yegrewen hennis n Loṭ ! ");
INSERT INTO thv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wa yegmeyen éd yennej iman ennét éd tn yeɣser, wa iɣasseren iman ennét éd yennej. ");
INSERT INTO thv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Éd hawen tn enneɣ, éheḍ héndɣ essin ǎddunet ensanén dɣ édeg iyyen, iyyen éd yemawey wa heḍen éd yeqqayem. ");
INSERT INTO thv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Senatet téḍéḍén eẓẓadnén ertaynet : iyyet éd temawey ta heḍet éd tetwey. ");
INSERT INTO thv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Essin médden ehanén ǎfǎraǧ : iyyen éd yemawey wa heḍen éd yeqqayem. ");
INSERT INTO thv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Essestenent inelkimen : « Menék deh Émeli ? » Yenna hasn : « Édeg wa teha tǎmeɣsoyt, ad emmalen iẓaẓẓen. » ");
INSERT INTO thv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeǧa Ƹisa tangalt tah i inelkimen ennét baš éd elmeden in ilzam asn timuhuden abedǎh, bela wr ekkésen eṭṭema : ");
INSERT INTO thv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","« Dɣ aɣrem iyyen illé elqaḍi wrn yeksoḍ Yaḷḷah, wr yekkul dɣ wl iyyen. ");
INSERT INTO thv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dɣ aɣrem wah tellé tǎmǎṭ iyyet s eba ales ennét, tasé hin abedǎh, tganna as : -Ekkes ahi tekeréṭ dɣ ǎwadem wa hi yeḍlamen-. ");
INSERT INTO thv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yugay as elqaḍi ad iǧa a yeggén, ezzar ahel iyyen yenna dɣ iman ennét : -Kud yera wr eksoḍeɣ Messineɣ, wr ekkuleɣ dɣ wl iyyen ; ");
INSERT INTO thv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","beššan tǎmǎṭ taɣ teẓẓoḍeh ahi, éd esseneɣ wr has éd ekkeseɣ tekeréṭ baš wr éd tales tas ahi-d, tessersen ahi-. » ");
INSERT INTO thv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yenna Ƹisa : « Sallem i ǎdewenné n erk elqaḍi wah ! ");
INSERT INTO thv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Adih tordam as Messineɣ wr éd yekkes tekeréṭ i innét as ǎsiɣerén ahel d éheḍ ? Tordam as éd ihel baš éd hasn yilal ? ");
INSERT INTO thv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Elleɣéɣ awn as éd hasn yekkes tekeréṭ hik. Beššan tordam as, as éd yas Ag ǎwadem éd yas dɣ ǎmǎḍal ǎddunet tha taflest hund téndɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesseɣley Ƹisa tangalt tah i wi ǎsilekennén in eẓẓalen dat Yaḷḷah, elkan ǎddunet wi heḍnén : ");
INSERT INTO thv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","« Essin médden éwenen s éhen wan ǎmud ekkan ds ǎmuhed, iyyen yǎmos elfarisi wa heḍen yeqqal ǎnarmas n tiwsé. ");
INSERT INTO thv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Elfarisi yebdad itimuhud dɣ iman ennét hund awah, iganna : -É Messineɣ, emmoyeɣ ak in wr oléɣ d ǎddunet wi heḍnén, wi ǎmosnén imǎkeren, inesbekkaḍen, kél ezzina, ǎmmoyyéɣ ak in wr oléɣ d ǎnarmas n tiwsé wén. ");
INSERT INTO thv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Toẓameɣ essin iméren fol essa iheḍan, takkeseɣ ak tafolt fol merawet n awa garreweɣ iket ennét-. ");
INSERT INTO thv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ǎnarmas n tiwsé yebdad dɣ igeg, awa has tega tekrakéṭ wr yeṭkél aked ǎsewaḍ ennét s aǧenna, beššan iggat idmaren ennét iganna : -É Messineɣ, sismeḍ foli, nk wan ănesbekkaḍ-. » ");
INSERT INTO thv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yenna Ƹisa : « Elleɣéɣ awn as u-tiwsé yeqqel tǎɣǎhamt ennét yeǧraw udem ɣor Yaḷḷah, wr igréw Elfarisi. Eré yeṭkalen iman ennét, éd yeres, éré yesiresen iman ennét, éd yeṭkel. » ");
INSERT INTO thv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Taweyen in ǎddunet i Ƹisa aked arrawen enḍuknén baš éd isansa ifassen ennét folsn. As eneyen inelkimen ennét awén eɣtelen-tn. ");
INSERT INTO thv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Beššan yeẓẓoheẓ-tn in Ƹisa ezzar yenna : « Eyyet arrawen wi enḍuknén éd hi-d asin, wr hasn tuǧeyem édét Elmelek n Yaḷḷah elant wi dsn olenén. ");
INSERT INTO thv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Elleɣéɣ awn tn, awén tidet : wa wrn iɣebbel Elmelek n Yaḷḷah hund arraw wa enḍukken wr yeddobet éd-t yeggeh ar abedǎh. » ");
INSERT INTO thv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yessesten amɣar iyyen Ƹisa, yenna : « Muƹalim wa yoleɣen, ma hé egeɣ baš éd ekreheɣ tǎmeddort tan abedǎh ? » ");
INSERT INTO thv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yenna has Ƹisa : « Mafol tgannéd ahi wa yoleɣen ? Wrt illé i yolaɣen ar Yaḷḷah ɣas. ");
INSERT INTO thv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tezzayed eššeriƹa : -Wr tegged ezzina, wr tegged iman, wr tikred, wr tegged tǎǧuhé teɣlaḍet, simɣer tik d mak-. » ");
INSERT INTO thv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yenna has ales : « Taggeɣ awa tenna eššeriƹa wa fol meḍriyeɣ. » ");
INSERT INTO thv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","As yesla Ƹisa i awah, yenna : « Tosared heret iyyen arweh : zenhin awa tléd imda d tekfed aẓref ennét i tilǎqqiwén, dédih éd teɣmered dɣ iǧennawen, ezzar telkemed ahi. » ");
INSERT INTO thv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","As yesla ales i awén eɣheden iman ennét édét yelwa s tela. ");
INSERT INTO thv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yeney Ƹisa as eɣheden iman n ales yenna : « Eṣṣahet a yeǧa uǧuh dɣ Elmelek n Yaḷḷah fol wi eɣmernén ! ");
INSERT INTO thv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Edét yeṣṣohet fol amis akkay dɣ téṭ n estenfus, beššan yerné eṣahu wa iǧen fol wi eɣmernén uǧuh dɣ Elmelek n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wi has esigednén gannén : « Adih, mi yeddobén éd yennej ? » ");
INSERT INTO thv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yenna Ƹisa : « Awa wr ǎddobén ǎddunet, yeddobet Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yenna Betrus adih : « Eniy, nefel awa nela imda baš éd hak nelkem. » ");
INSERT INTO thv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yenna hasn Ƹisa : « Elleɣéɣ awn tn, tidet awén, éré yoyyen tǎɣǎhamt ennét méɣ hennis méɣ meddans méɣ tis méɣ mas méɣ ayet-mas dɣ érét n Elmelek n Yaḷḷah, ");
INSERT INTO thv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","éd yegrew a yeggén dɣ tǎmeddort taɣ, d dɣ eddunya ta-d teglet éd igrew tǎmeddort tan abedǎh. » ");
INSERT INTO thv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeẓmeẓley Ƹisa inemmahalen ennét win meraw d essin, yenna hasn : « Segdeti, éd nk Yerušelem, éd yeǧ ds imda awa ekteben ennebiten fol Ag ǎwadem. ");
INSERT INTO thv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Éd hin yetwegar ɣor tawsitén wrn ǎmos kél Elyehud, éd ds eḍsin, édt tessebbin, éd fols sutfin. ");
INSERT INTO thv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Éd-t ewtin ezzar éd-t eŋɣin. Beššan ahel wan keraḍ éd-d yenker ǧer inemmuttan. » ");
INSERT INTO thv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Beššan inelkimen ennét wr egrehen awas yera éd tn yen ; tifér ennét effarnet asn, wr essénen elmeƹna nsnt. ");
INSERT INTO thv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ḍeffer awéndɣ yoheẓ Ƹisa aɣrem wan Yariḥo. Yellé ales derɣalen yeqqimen fol ǎbǎreqqa, yegmay takuté. ");
INSERT INTO thv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yesla i ǎddunet errigehen ezzar yessesten ma itaǧǧen. ");
INSERT INTO thv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yehéwel as Ƹisa wan Ennaṣira a yokayen deh. ");
INSERT INTO thv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yesɣeret, yenna : « Ƹisa, ag Dawud, aḍen ahi tǎhanint ! » ");
INSERT INTO thv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wi erregehnén dɣ éɣef eɣtelent, ennen as éd yesusem, beššan yeqqim yesiɣeret denneg awén : « Ag Dawud, aḍen ahi tǎhanint ! » ");
INSERT INTO thv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yebded Ƹisa, yenna éd has-d awyin ales wah. As in yoheẓ yessestent Ƹisa : ");
INSERT INTO thv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","« Mas tered éd hak-t egeɣ ? » Yenna has : « Émeli, ǎhenay a ǎréɣ. » ");
INSERT INTO thv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yenna has Ƹisa : « Eniy ! Taflest ennek tezzozey key. » ");
INSERT INTO thv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Émér héndɣ yeney, yelkem i Ƹisa itamel Yaḷḷah. As eneyen ǎddunet awén eqqimen tamelen Yaḷḷah emdan. ");
INSERT INTO thv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeggah Ƹisa dɣ aɣrem wan Yariḥo, yejjert. ");
INSERT INTO thv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yella deh, ǎnesbeɣor iyyen iǧan isem Zakka, enta yǎmos amɣar iyyen wan inarmasen n tiwsé. ");
INSERT INTO thv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yegmey éd yeney ma yǎmos Ƹisa beššan yendar as édét ǧezzul, eɣlayen as ǎddunet ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yohel yezzar asn, yéwen fol ašek iyyen baš éd yeney Ƹisa hé akyin deh. ");
INSERT INTO thv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","As in yéweḍ edeǧ wéndɣ, yeṭkel Ƹisa ǎsewaḍ ennét ezzar yenna has : « Zakka key, ermaḍ eres, ilzam éd enseɣ ɣork éheḍ waɣ. » ");
INSERT INTO thv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yeres-d Zakka hik yerrexebt yeddiwet. ");
INSERT INTO thv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","As eneyen ǎddunet awén, emdan taẓemen Ƹisa gannén : « Ales waɣ yekka éd yens ɣor ǎnesbekkaḍ ! » ");
INSERT INTO thv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakka yebdad dat Émeli, yenna has : « Émeli, hakkeɣ aɣil n éheré hin i tilaqqiwén, kud oheɣeɣ iyyen tarreɣ ast ar ekkoẓ iméren. ");
INSERT INTO thv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yenna has Ƹisa : « Ahel waɣ elɣelas yeggah éhen waɣ édét aked enta aheya n Ibrahim a yǎmos. ");
INSERT INTO thv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Édét Ag ǎwadem yos-d ed igmiy d éd yennej wa yexreken. » ");
INSERT INTO thv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Folin esigeden ǎddunet i tifér ennét, yeǧa sn Ƹisa tangalt iyyet édét folas yoheẓ Yerušelem, ǎɣélen ǎddunet in émér waɣ ad éd yuman Elmelek n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yenna awah : « Ales iyyen n ǎddunet win imenokalen yosa ǎkal yoggegen baš éd ds yumas ǎmenokal ezzar éd-d yeqqel ḍeffer adih. ");
INSERT INTO thv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Arweh wr yeglé, yeɣra meraw dɣ éklan ennét, yekfén ak iyyen erriyal n oreɣ, ezzar yenna hasn : -Sexdemet s oreɣ waɣ ar d eqqeleɣ-. ");
INSERT INTO thv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ǎddunet win ǎkal ennét okaḍen ds, esselkemen as eljemat baš éd ten : -Wr neré éd imnukel folnɣ ales waɣ-. ");
INSERT INTO thv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Beššan yǎmos ǎmenokal, yeqqel-d ǎkal ennét. Yeɣra éklan ennét winǧam yekfa oreɣ, baš éd yessen awa ds eknen. ");
INSERT INTO thv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wa yezzaren yos-in yenna : -Messi, erriyal wa hi tekféd, yéweyey-d meraw erriyalen-. ");
INSERT INTO thv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yenna has ǎmenokal : -Awén a yeknan ! Key akli yolaɣen a tǎmosed, éré yeɣdalen dɣ hereten wi ferornén, fol awén éd dk ekneɣ amɣar n meraw iɣerman-. ");
INSERT INTO thv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wan essin yosin yenna : -Messi, erriyal wa hi tekféd, yéweyey-d semmos erriyalen-. ");
INSERT INTO thv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yenna has ǎmenokal : -Aked key éd dk ekneɣ amɣar n semmos iɣerman-. ");
INSERT INTO thv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yosin iyyen heḍen yenna : -Messi, erriyal wa hi tekféd ogezeɣt dɣ tikest, nɣwah. ");
INSERT INTO thv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Eksodeɣ key, édét ales yeṣṣohén a tǎmosed, taweyed awa wr tessensed, tameded awa wr tesseŋŋeled-. ");
INSERT INTO thv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yenna has ǎmenokal : -Erk akli a tǎmosed, éd key eššereɣeɣ fol awal ennek. Tessaned as ales yeṣṣohén a ǎmoseɣ, taweyeɣ awa wr essenseɣ, tamedeɣ awa wr esseŋŋeleɣ. ");
INSERT INTO thv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mafol wr tessensed aẓrefin ula dɣ elbanka ? As-d eqqeleɣ éd-t awyeɣ enta d awa yesserbeḥ-. ");
INSERT INTO thv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ezzar yenna i wi-t ellenén déndɣ : -Ekkeset ds erriyal ekfet i wa yerbeḥen meraw-. ");
INSERT INTO thv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ennen as : -Messi, beššan ila meraw !- ");
INSERT INTO thv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yenna hasn : -Elleɣéɣ awén tn, éré ilen, éd yegrew a yeggén ; éré wrn ilé, éd ds yemmukkes aked awa ila. ");
INSERT INTO thv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ihenǧa hin widih, windin wrn yeré in éd umaseɣ ǎmenokal nsn, awyeten-d déɣ, eɣreset asn dati-. » ");
INSERT INTO thv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","As yenna Ƹisa awén, yegla dat ǎddunet, yéwey ǎbǎreqqa wa yéwenen s Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","As yoheẓ Beytfaji d Beytƹanya, ɣor tadreq tas itahawal tan Ezzeytun, yessewey dats essin dɣ inelkimen ennét, ");
INSERT INTO thv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yenna hasn : « Aset taɣremt tén tellet datwn. As in téweḍem éd tasim érwel yekras, a yewa wrt yéwén wl iyyen. Aret d tawyimt-id déɣ . ");
INSERT INTO thv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kud yessesten kewen iyyen, iganna : -Mafol taremt ?- Ennet as : -Yemixatart Émeli-. » ");
INSERT INTO thv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eglen wi ǎméhelnén, osent hund awa hasn yenna Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","A yekka taren érwel, messawes ennen asn : « Mafol tarem érwel waɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ennen asn : « Émeli adt yemixataren. » ");
INSERT INTO thv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ezzar eweyenin érwel i Ƹisa, essensen ibernah nsn fols ezzar esséwenen Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A yekka yerǧéh sansén ǎddunet dats ibernah nsn fol ǎbǎreqqa. ");
INSERT INTO thv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Deroɣ yoheẓ Yerušelem, s ǎbǎreqqa wa yeresen dɣ tadraq tan Ezzeytun, inelkimen eddewén, eqqimen tamelen Yaḷḷah fol tikunén ti eneyen eṭkalen ǎmesli. ");
INSERT INTO thv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Gannén : « Tebareka ǎmenokal, wad yosen dɣ isem n Émeli, esselamet dɣ aǧenna, elmejd n Yaḷḷah dɣ iǧennawen win afella. » ");
INSERT INTO thv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ellant Elfarisiten wiyeḍ déndɣ ǧér ǎddunet, ennen as i Ƹisa : « Muƹalim, eɣtel inelkimen ennek. » ");
INSERT INTO thv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yenna hasn Ƹisa : « Elleɣéɣ awén tn, kud entenéḍ essosemen, ikedéwen éd seqqerin ! » ");
INSERT INTO thv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","As deroɣ hin yéweḍ Ƹisa Yerušelem, yeney aɣrem ezzar yeslef dɣ érét ennét, ");
INSERT INTO thv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","yenna : « Kem, enner ula ahel waɣ, aked kem tessaned ǎbǎreqqa n esselamet ! Beššan dimaɣ yeffar fol téṭṭawén ennem ! ");
INSERT INTO thv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Elkamen dm iheḍan wi dɣ ham éd seɣleyen ihenǧa ennem elxiyaḍen, éd ham eɣliyen, éd kem eẓmemen. ");
INSERT INTO thv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Éd kem etteɣteɣen ékét ennem, kem d araten ennem, wr ham éd eyyin ula aẓẓed yensan fol ămidi ennét, édét tugeyed éd telmeded émér wa kem-d yosa Yaḷḷah ! » ");
INSERT INTO thv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ḍeffer adih, yeggeh Ƹisa dɣ Éhen wan Ǎmud, yeqqim isatteɣ ds ettejjar, ");
INSERT INTO thv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iganna sn : « Yektab : -Tǎɣǎhamtin tǎmos tǎɣǎhamt n ǎmud-. Beššan kewenéḍ teknem ds ekǎhǎm n imekeren ! » ");
INSERT INTO thv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ak ahel isaɣra Ƹisa dɣ Éhen wan Ǎmud. Ad gammeyen imɣaren n imerubay d elƹulama wi kettebnén d imɣaren n ǎkal édt eŋɣin. ");
INSERT INTO thv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Beššan wr essénen menék awa hé eǧin édét ǎddunet emdan yegraẓ asn awa iganna hullan, ekfant tǎmeẓẓuk. ");
INSERT INTO thv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ahel iyyen dɣ windɣ ihilan, isaɣra Ƹisa ǎddunet dɣ éhen wan ǎmud, itag asn Isǎlan n Elxér as-d osen imɣaren n imerubay d elƹulama wi kettebnén eddéwen d imɣaren n ǎkal, ");
INSERT INTO thv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","essestenent : « En anɣ ma tǎmos terna ta fol tagged awaɣ, méɣ mi key yekfen terna tareɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yenna hasn Ƹisa : « Éd kewen sesteneɣ aked nk. Leɣtet ahi : ");
INSERT INTO thv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mi has innen i Eḥya éd isalmaɣ ǎddunet dɣ aman. Messineɣ méɣ dg Adem ? » ");
INSERT INTO thv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Exxemmemen ǧérésn, ennen : « Kud nenna : Messineɣ a-d yezimahelen Eḥya, éd hanɣ yesesten : Mafol wrt teflésem ? ");
INSERT INTO thv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kud nenna : « Dg Adem a yezimahelen Eḥya, ǎddunet emdan éd haneɣ egrin eẓẓeden baš éd hanɣ eŋɣin, édét wr eǧén eššek as Eḥya ennebi a yǎmos. » ");
INSERT INTO thv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ennen dédih : « Wr nessén. » ");
INSERT INTO thv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yenna Ƹisa : « Aked nk wr hawen éd elleɣéɣ emmek was eléɣ elḥikma tas taggeɣ awa taggeɣ. » ");
INSERT INTO thv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yeqqim Ƹisa isaɣlay tangalt tah i ǎddunet : « Ales iyyen yeẓẓa tizzebab, yekrey tnt i inaxdamen wiyyeḍ ezzar yekka ǎsikel mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","As teŋŋa tǎzzebibt, yezmahel akli ennét iyyen éd has in yawiy tafolt ennét dɣ ǎzzebib. Beššan inaxdamen eŋɣen ǎnemmahal wah, ezzar esteɣent wr yéwey ula enḍerren. ");
INSERT INTO thv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yezmahel akli iyyen heḍen, eŋɣent aked enta, essebbent, esteɣent wr yewey ula enḍerren. ");
INSERT INTO thv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yezmahel akli wan keraḍ daɣ, aked enta eŋɣent, eɣḍement, esteɣent. ");
INSERT INTO thv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yenna messis n tizzebab : « Ma hé egeɣ ? Éd zemmiheleɣ ruré was ekneɣ tera, tigenén enta éd tewweqqeren. » ");
INSERT INTO thv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Beššan as-t eneyen inaxdamen, ennen ǧérésn : « Enyet awén rurés, messis n tǎkasit, neŋɣét baš éd eqqelnet tizzebab tineneɣ. » ");
INSERT INTO thv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Esteɣent dɣ tizzebab, eŋɣent, yemmut. Yessesten Ƹisa : « Dimaɣ ma hasn éd yeǧ messis n tizzebab ? ");
INSERT INTO thv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Éd-d yeqqel, éd yehheddem inaxdamen wih éd yeǧ wiyyeḍ heḍnén. » As eslen ǎddunet i tifér tih, ennen : « Awén wr éd yeǧ fo ! » ");
INSERT INTO thv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yekna sn Ƹisa akeyad ezzar yenna : « Ma tǎmos elmeƹna n tifér tih dɣ elkettab : -Ékedé wa enḍewen wi bunnunén, enta a yeqqelen ékedé wa yekbelen éhen-. ");
INSERT INTO thv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ékedé wéndɣ kud toḍéd fols éd key yeŋɣ, kud yoḍa folk éd key yerẓ. » ");
INSERT INTO thv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Elƹulama wi kettebnén d imerubay wi mǎqqornén egmeyen éd ermesen Ƹisa émér héndɣ, édét essanen as tangalt tah entenéḍ as teɣlay, beššan eksoḍen ǎddunet wit ellenén. ");
INSERT INTO thv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eqqimen eƹƹissen Ƹisa. Sawayen as imaɣlayen elmet ǎddunet olaɣnén. Ǎddunet wih egmayen éd ermesen Ƹisa s tifér ennét baš édt awyin, édt eǧin dɣ ifassen n amɣar wa yeḥkemen dɣ ǎkal. ");
INSERT INTO thv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Essestenent, ennen : « Muƹalim, nessan as awa tsaɣréd yeẓẓal, wr teẓmeẓleyed ǎddunet édét tidet fol ǎbǎreqqa n Yaḷḷah ɣas a tsaɣréd. ");
INSERT INTO thv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","En anɣ dédih, xelal anɣ ǎrreẓam n tiwsé i Elqayser méɣ kela ? » ");
INSERT INTO thv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Beššan yelmed Ƹisa tittéwén nsn, yenna hasn : ");
INSERT INTO thv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","« Seknet ahi erriyal iyyen. Udem d isem wi ewernén erriyal waɣ mi tn ilen ? » Ennen as : « In Elqayser. » ");
INSERT INTO thv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yenna hasn Ƹisa dédih : « Adih erret i Elqeyser heret ennét, d i Yaḷḷah awa ennét. » ");
INSERT INTO thv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yender asn édt seḍlemen fol wl iyyet dɣ tifér ennét dat ǎddunet. Ǎkunen dɣ awa yenna ezzar essosemen. ");
INSERT INTO thv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Osent-in wiyeḍ dɣ Essaduqiten. Entenéḍ a igannén in wrt tellé tanekra ǧér inemmuttan. Essestenent, ");
INSERT INTO thv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ennen as : « Muƹalim, ennebi Musa yekteb anɣ awah : -Ales yeddéwen ilan eŋŋas, ebat wr ilé meddans, ilzam i eŋŋas éd yawiy tǎmǎṭ n wa eba baš éd ds yekreh arrawen wi hé eqqelnén in wa yemmuten. ");
INSERT INTO thv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ellant essa aŋŋaten. Wa yezzaren yeddew, yemmut wr yekréh arrawen. ");
INSERT INTO thv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wan essin yéwey tǎmǎṭ n wa eba, yemmut wr yekréh arrawen. ");
INSERT INTO thv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yelkem as wan keraḍ. Essa aŋŋaten emdan éweyen tǎmǎṭ tanǧam beššan emmuten emdan wr ekréhen arrawen. ");
INSERT INTO thv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ezzar temmut tǎmǎṭ aked enta. ");
INSERT INTO thv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ahel wan tébeddé mis tǎmos hennis édét eweyen tt emdan ? » ");
INSERT INTO thv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yenna hasn Ƹisa : « Kél eddunya taɣ neha tidawen, ");
INSERT INTO thv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","beššan wi eniheggenén d tanekra ǧér inemmuttan, d tǎmeddort dɣ eddunya tad teglet wr tidawen. ");
INSERT INTO thv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Edét ǎbas eddobén tǎmettant, olen d ǎngelosen. Ǎmosen dg Yaḷḷah, ǎmosen dg elqiamet. ");
INSERT INTO thv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Fol inemmuttan wi-d éd enkernén, Musa iman ennét isalmad anɣ-t dɣ aẓel wa yesséwelen fol elweška terɣat s temsé, iɣar Émeli s : Messineɣ n Ibrahim, Messineɣ n Isḥaq, Messineɣ n Yaƹqub. ");
INSERT INTO thv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Adih Yaḷḷah wr yǎmos Messineɣ n inemmuttan, kela, yǎmos Messineɣ n wi eddernén édét ɣors emdan eddaren. » ");
INSERT INTO thv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Esséwelen elƹulama wi kettebnén wiyeḍ, ennen as : « Tekned awal Muƹalim. » ");
INSERT INTO thv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aqquššemen éd sestenin arweh. ");
INSERT INTO thv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yenna hasn Ƹisa : « Menék emmek was éd itahawal, Elmesiḥ ag Dawud ? ");
INSERT INTO thv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Édét Dawud iman ennét iganna dɣ elkettab wan Tisiway : Yenna Émeli i Emelihin : Ǎyew ɣayem fol aɣil in, ");
INSERT INTO thv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ad erreɣ ihenǧa ennek dag éḍaren ennek. ");
INSERT INTO thv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kud igannas Dawud : -Émeli- ; menék awa hé yeg éd yumas Ag Dawud dédih ? » ");
INSERT INTO thv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A ekken emdan ǎddunet winǧam esigeden as, yenna Ƹisa i inelkimen ennét : ");
INSERT INTO thv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","« Uksaḍet elƹulama wi kettebnén, wis tegraẓ téklé dɣ iselsa ahobetnén, wis igraẓ iseslamen dɣ ideggen wi eṭkernén ǎddunet, sanefranen ideggen wi amunnén dɣ ihenan n téɣeré d dɣ imekliwen. ");
INSERT INTO thv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","A yekka tatten tela temda tan téḍéḍén tis eba médden nsnt, timuhuden imadden heǧretnén eran temunt. Elmedet as telkam dsn tanaṭ teknat ǎṣahu. » ");
INSERT INTO thv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeṭkel Ƹisa ǎsewaḍ, yeney inesbeɣar sansén tikutawén nsn dɣ essendoq wa taǧǧehnet. ");
INSERT INTO thv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yeney aked tǎmǎṭ s eba ales ennét tǎmoset taleqqé tega ds essin sinkuten. ");
INSERT INTO thv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yenna Ƹisa : « Éd hawen enneɣ tidet : taleqqé taɣ teǧa a yogeren awa eǧen wi heḍnén. ");
INSERT INTO thv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Édét wiɣ endam ekfen dɣ a yélwan ɣorsn, enta, dɣ elleqqu ennét, tekfa ǎmeddor ennét. » ");
INSERT INTO thv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesla Ƹisa i wi esséwelnén, tamelen éhen wan ǎmud folin edlagent éẓẓeden d tikutawén ti taǧǧen ǎddunet i Yaḷḷah, yenna hasn : ");
INSERT INTO thv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","« Yelkam ahel was, dɣ awa thanneyem, wr éd yeqqayem aẓẓed fol aẓẓed wrn yehheddem. » ");
INSERT INTO thv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Essestenent dédih : « Muƹalim, emmey d-éd yeǧ awén ? Ma yǎmos ǎhamol n in yebok éd yeǧ awén ? » ");
INSERT INTO thv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yenna Ƹisa : « Uksaḍet, wr toyyém iman nwn éd kewen seɣleḍen. Édét ǎddunet ǎǧǧotnén éd asin s isem-in, éd ennin : -Nk as Elmesiḥ- méɣ : -Émér yoheẓ !- Beššan wr hasn telkémem. ");
INSERT INTO thv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","As teslem in ellant ǎnmeŋɣiten d išiwwiššen aggotnén, wr terméɣem, awén ilzam éd yeǧ ezzar, beššan wr yéwéḍ ǎsemdu animér. » ");
INSERT INTO thv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yenna daɣ : « Ed teknes ellamet d iyyet heḍet, éd yeknes ǎkal d iyyen heḍen, ");
INSERT INTO thv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","éd-t emlin ezzelzalen maqqornén, dɣ ikallen ǎǧǧotnén, éd temel menna d tornawén, éd t emlin hereten essukseḍnén d ihmal huharnén d efalnén aǧenna. ");
INSERT INTO thv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Beššan dat awén, éd tetwermasem, éd tetweŋɣim, éd hawen neǧ eššeriƹa dɣ ihenan n téɣeré, éd tetwenḍawem dɣ tǎkormut, éd temawyim dat imenokalen d imɣaren dɣ érét-in. ");
INSERT INTO thv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Awén éd yeǧ baš éd tešhedem foli. ");
INSERT INTO thv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eǧet dɣ ulawen nwn in wr éd tzewwejjedem ǎmestan nwn. ");
INSERT INTO thv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Fol as, nk imanin, éd kewen ekfeɣ iyyen awal d iyyet elmiƹna wis wr eddobén imiksenen nwn éd tn emɣennanen ula hawen errin awal. ");
INSERT INTO thv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Éd kewen settermesen aked imerawen nwn d aŋŋaten nwn d ǎddunet nwn d imidiwen nwn ; wiyeḍ dewen éd etweŋɣin. ");
INSERT INTO thv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Éd kewen ekyeḍen ǎddunet emdan dɣ érét n isemin. ");
INSERT INTO thv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Beššan wr hin éd iba ula amẓad n éɣef nwn. ");
INSERT INTO thv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tǎẓidért nwn as éd tagẓim iman nwn. ");
INSERT INTO thv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","As teynim Yerušelem s eɣlay elɣeskeren, elmedet émér héndɣ as deroɣ éd tehhedem. ");
INSERT INTO thv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dédih wi ehenén Yehudiya erwelnét s idraren, wi ellenén ammas n Yerušelem zérehnetin, wi ehenén iferǧan wr teggehnét aɣrem. ");
INSERT INTO thv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Édét iheḍan n éɣa nɣwindɣ baš éd yetbet awa yektaben imda. ");
INSERT INTO thv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Okelnet téḍéḍén ti essimrewnén d ti sankasnén ezzeman wéndɣ ! Édét éd teǧ toẓẓért mǎqqeret fol ǎkal, éd teɣtes tanaṭ n Yaḷḷah fol ǎddunet. ");
INSERT INTO thv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Éd emmeten ǎddunet wiyeḍ s tikobawén, wiyeḍ éd emahɣin éd emawyin s ikallen, éd ǎkukelnet tawsitén wrn ǎmos tin Elyehud Yerušelem, awén ad yemmendu ezzeman wa tn ikfa Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Éd-t emlinet tikunén fol tǎfuk, fol tallit d fol itran. Dɣ ǎmǎḍal ellametén d ermeɣnet fol tekat d išewwišen win geréw. ");
INSERT INTO thv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Éd teŋɣ tǎremméq ǎddunet dɣ érét n awa hé yegin fol ǎmǎḍal. Édét tehkeḍkeḍ terna n iǧennawen. ");
INSERT INTO thv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dédih éd neney Ag ǎwadem yegla-d iha aẓyar elkamen as a-yeggén n elmejd d terna. ");
INSERT INTO thv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","As yessenta awén, ebdedet, eṭkelet iɣefawen nwn édét elɣelas nwn yoheẓ. » ");
INSERT INTO thv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ezzar yesseɣley Ƹisa tangalt tah : « Ekyedet tahart d iškan wi heḍnén : ");
INSERT INTO thv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","as tn teneyem eggaren dédih telmedem iman nwn as ǎwélen yoheẓ. ");
INSERT INTO thv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hund awéndɣ, as teneyem hereten windɣ, elmedet as Elmelek n Yaḷḷah yoheẓ-d. ");
INSERT INTO thv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Éd hawen tn enneɣ s tidet : ǎddunet win ezzeman wéndɣ wr tn eba emdan as éd yeg awa itaggen. ");
INSERT INTO thv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aǧenna d ǎmǎḍal éd tn iba beššan tiferin wr tnt éd iba ar abedǎh. » ");
INSERT INTO thv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","« Uksaḍet fol iman nwn ! Wr toyyém iman nwn xarreken dɣ tirammanén d tésesé teggét d dɣ elhemmen n edduniya, méɣ ahel héndɣ éd kewen yeɣder ");
INSERT INTO thv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","hund elxeniyyet, édét éd teres fol ǎddunet emdan wi aqqimnen fol ǎrori n ǎkal. ");
INSERT INTO thv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eǧet enniyet, muhdet abedǎh, baš éd tekrehem eṣṣahet éd terwélem fol awa hé yeǧin, baš éd tudabem tébeddé dat Ag ǎwadem. » ");
INSERT INTO thv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","S ahel Ƹisa isaɣra dɣ éhen wan ǎmud, s éheḍ itak tadreq tan Ezzeytun inas-in séndɣ. ");
INSERT INTO thv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tasent-in ǎddunet emdan déndɣ d yeffo baš éd has segdin dɣ éhen wan ǎmud. ");
INSERT INTO thv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yoheẓ-d ǎmud wan Elyehud, wa dɣ tamekšénet tiǧelwén ti wr thé elxemméra, iǧan isem Ǎsuref. ");
INSERT INTO thv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Imerubay wi mǎqqornén d elƹulama wi kettebnén egmayen emmek was éd eŋɣin Ƹisa beššan eksoḍen ellamet. ");
INSERT INTO thv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Adih yeǧǧeh Iblis Yehudas was itahawal Elisxeryuṭi, yǎmosen iyyen dɣ inemmahalen n Ƹisa win meraw d essin. ");
INSERT INTO thv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yosa Yehudas imerubay wi mǎqqornén d imɣaren n wi ogeẓnén éhen wan ǎmud, enmeknen fol emmek was éd ermesen Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yegreẓ asn awén hullan, ennefhemen fol éd-t ekfin aẓref. ");
INSERT INTO thv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yerḍa sn Yehudas ezzar yegmey émér wa-d éd isettermes Ƹisa bla wr ss essénen taxlek. ");
INSERT INTO thv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","As yéweḍ ahel wan tiǧelwén ti wr thé elxemméra, wa dɣ tɣarres Tefaské. ");
INSERT INTO thv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yezmahel Ƹisa Betrus d Eḥya yenna hasn : « Eglet zewwejjedet Tefaské baš éd tt nekš. » ");
INSERT INTO thv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Essestenent : « Mi-d teréd éd tt neken ? » ");
INSERT INTO thv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yenna hasn : « Segdet : Émér héndɣ hin éd tawḍim aɣrem, éd temheyyum d ǎwadem yehraǧen dɣ teqqelilt. Elkemet as dɣ tǎɣǎhamt ta hé yeggeh, ");
INSERT INTO thv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ennét i messis n tǎɣǎhamt : -Yenna hak elmuƹalim : ma iǧa édeg wa dɣ éd ekšeɣ Tefaské, nk d inelkimenin ?- ");
INSERT INTO thv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Éd kewen iseken, afella dɣ tǎɣǎhamt, éhen mǎqqeren iha ak heret, déndɣ ad éd tzewwejjedim. » ");
INSERT INTO thv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eglen osen awa hasn yenna Ƹisa, ezwejjeden Tefaské. ");
INSERT INTO thv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","As yeweḍ elwǎq, yesɣemer Ƹisa i amensu enta d inemmahalen ennét win meraw d essin. ");
INSERT INTO thv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yenna hasn : « Ekneɣ ǎsedderhen émér waɣ dɣ éd ekšeɣ Tefaské nk d kewenéḍ arweh wr oẓéreɣ ! ");
INSERT INTO thv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Édét gannéɣ awn tn, ǎbas éd ekšeɣ iyyet heḍet ad tetbet elmeƹna ennét temda dɣ Elmelek n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yeṭkel elkas, yemmoy i Yaḷḷah, yenna : « Hékwet, ahret awa ihen elkas waɣ, ");
INSERT INTO thv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","édét, gannéɣ awn tn, ǎbas éd esweɣ ad igmaḍen ǎzzebib ad-d yaweḍ Elmelek n Yaḷḷah. » ");
INSERT INTO thv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ezzar yeṭkel tagella, yemmoy i Yaḷḷah, yerẓét ezzar yeẓun asn tt, yenna : « Awaɣ taɣessa hin, tegrawem tt. Eǧet awéndɣ tǎketutin. » ");
INSERT INTO thv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","As esmenden téteté yekfén aked elkas wanǧam, yenna : « Elkas waɣ yǎmos téséq ta teynayet s ahni hin wa hawen yeŋŋalen. » ");
INSERT INTO thv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","« Beššan, enyet ! Wa hi éd yeɣderen, yeqqim déɣ yertay dnɣ, ");
INSERT INTO thv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ag ǎwadem éd yegel hund awa yekteben beššan yokel wat yeɣderen ! » ");
INSERT INTO thv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ad tinmesestinen inelkimen ennét gérésen tassenen ma yǎmos dsn wa hé yeɣderin Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ezzar yenker ǎkennas ǧér inemmahalen, tassenen ma yǎmos wa mǎqqeren ǧérésn. ");
INSERT INTO thv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yenna hasn Ƹisa : « Imenokalen ǎminakelen fol ikallen nsn, wi dsn exkamenén, itahawal asn dg elxér. ");
INSERT INTO thv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kewenéḍ kela ! Wr teggim awén. Wa mǎqqeren ǧéréwn yumasét enta wa meḍreyen, wa yexkamen yumasét hund d akli. ");
INSERT INTO thv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ma yǎmos wa mǎqqeren, wa yeqqimen itat méɣ wa fols yexdamen ? Wa yeqqimen, tidet méɣ kela ? Beššan nk, ǎmoseɣ ǧéréwn hund akli. ");
INSERT INTO thv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kewenéḍ, telkamem ahi abedash dɣ térmiténin. ");
INSERT INTO thv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Awéndɣ a fol taggeɣ Elmelek ǧér ifassen nwn hund emmek was-t iǧa Abbahin ǧér wihin : ");
INSERT INTO thv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","baš éd tekšim éd teswim édésin dɣ Elmelekin, baš éd teqqeymim fol elkorsiten n elqaḍiten tenniheḍem fol tawsitén tin merawet d senatet tin Israyil. » ");
INSERT INTO thv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","« Simƹun key ! Seged : yegmey kewen Iblis, baš éd kewen yeɣɣerben hund allon. ");
INSERT INTO thv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Beššan ettereɣ i Yaḷḷah in wr hak éd tiba taflest. Key, as-d teqqeled sri, sebded ayet-mak. » ");
INSERT INTO thv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yenna has Betrus : « Émeli, eknéɣ imanin éd dk idaweɣ s tǎkormut d tǎmettant. » ");
INSERT INTO thv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yenna has Ƹisa : « Ed hak tn enneɣ Betrus, éheḍ waɣ arweh wr yesɣeyyet ǎkehi, éd tenned ar keraḍ iméren in wr hi tezzéyed. » ");
INSERT INTO thv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ezzar yenna Ƹisa : « As kewen ezmaheleɣ wr telém aẓref ula ǎbelboḍ ula iɣetémen, ma hawen yoseren ? » Ennen as : « Ula. » ");
INSERT INTO thv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yenna hasn Ƹisa : « Dimaɣ, wa ilen aẓref méɣ ǎbelboḍ yawyét, wa wrn ilé tǎkoba, izenhét-in aselso ennét baš éd izenh iyyet. ");
INSERT INTO thv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Éd hawen elleɣoɣ as awa yehéwelen foli dɣ elkettab n Yaḷḷah éd yetbet : -Yeṭṭin ǧér ineḍḍullam-. Edét imda awa foli yekteben éd yemmendu. » ");
INSERT INTO thv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ennen as : « Émeli, ellanet senatet tikobawén. » Yenna : « Egdehnet. » ");
INSERT INTO thv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yegmeḍ Ƹisa yosa, hund elɣada, adrar n Ezzeytun, elkemen as inemmahalen ennét. ");
INSERT INTO thv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","As in yeweḍ yenna hasn : « Muhdet baš éd tagẓim fol térmitén. » ");
INSERT INTO thv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ezzar yezzenkeh-in folsn Ƹisa s édeg yéwaḍen tégéré n aẓẓed, yegen, yeqqim itimuhud, ");
INSERT INTO thv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","yenna : « Abba, kud teréd awén, sefel ahi ǎkus wan toẓẓért. Beššan eǧ awa teréd key, weggén awa ǎréɣ nk. » ");
INSERT INTO thv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Émér héndɣ yemun as-d ǎngelos n aǧenna, yekfé eṣṣahet. ");
INSERT INTO thv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Idgeẓ hullan, ezzar yeqqim itimuhud denneg awén. Teffey ds tidé hund ahni iratteken fol ǎmǎḍal. ");
INSERT INTO thv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","As yesmenda ǎmud ennét, yenker, yeqqel-d ɣor inemmahalen ennét, yosén eṭṭasen, yeẓẓoḍeh tn elhem, ");
INSERT INTO thv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","yenna hasn : « Mas teṭṭasem ? Enkeret muhdet, baš éd tagẓim iman nwn fol térmitén. » ");
INSERT INTO thv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesséwel arweh as in osen ǎddunet. Yezzar asn Yehudas, iyyen dɣ inemmahalen win meraw d essin, yoheẓ Ƹisa baš éd has yemmullet. ");
INSERT INTO thv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yenna has Ƹisa : « Yehudas key, tǎmullét as tɣaddered Ag ǎwadem ? » ");
INSERT INTO thv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","As eneyen imidiwen n Ƹisa awa itaǧǧen, essestenent : « Émeli, éd neŋɣ s tikobawén nnɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iyyen dsn yewet akli n ǎmerabu wa mǎqqeren, yenkeḍ as tǎmeẓẓuk tan aɣil. ");
INSERT INTO thv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yenna Ƹisa : « Yegdeh ! Wr teǧém adih ! » Yeḍes tǎmeẓẓuk n akli, yezzozeyt. ");
INSERT INTO thv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ezzar yesséwel Ƹisa i wi-t-d osenen éd-t ermesen, imerubay wi mǎqqornén d imɣaren n wi ogeẓnén éhen wan ǎmud d imɣaren, yenna hasn : « Mafol tosem-d téwayem tikobawén d tiboryawén hund as tegmayem ǎmeker ? ");
INSERT INTO thv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ak ahel elléɣ ɣorwn dɣ éhen wan ǎmud, wr hi termésem. Elmedet as émér waɣ, émér nwn d émér n terna n tihay. » ");
INSERT INTO thv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ermesen Ƹisa, éweyent dɣ tǎɣǎhamt tan ǎmerabu wa mǎqqeren. Yelkam as Betrus dɣ iǧeǧ. ");
INSERT INTO thv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Essoken témsé dɣ ammas n axxam, yeqqim Betrus ǧér ǎddunet wi eɣleynén i témsé. ");
INSERT INTO thv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Teneyt taklit iyyet dɣ taffawt n témsé, teknas ǎkeyad, tenna : « Ales waɣ aked enta yeddéw ds ! » ");
INSERT INTO thv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Beššan yenna has Betrus : « Kela kela, tǎmaṭ, wrt ezzéyeɣ !. » ");
INSERT INTO thv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Émér iyyen heḍen yeneyt iyyen, yenna : « Aked key, tǎmosed iyyen dsn ! » Yenna has Betrus : « Kela kela, ales, wr ǎmoseɣ iyyen dsn ! » ");
INSERT INTO thv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","As tokey essaɣet iyyet ɣor déndɣ, ales iyyen heḍen yenna : « Igmaḍt eššek, ales waɣ insen, édét in Jalila. » ");
INSERT INTO thv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Beššan yenna Betrus : « Ales, key, wr esséneɣ a fol tesséweled. » Émér héndɣ, animér yesséwel, yesɣeyyet ǎkehi. ");
INSERT INTO thv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Adih yeznehlemin ss Émeli, yekna ds ǎsewaḍ. Déndɣ ad yekta Betrus awa has yenna : « Arweh wr yesɣeyyet ǎkehi, éd tenned ar keraḍ iméren in wr hi tezzéyed. » ");
INSERT INTO thv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yegmeḍ Betrus, yekna tǎkelélt. ");
INSERT INTO thv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Médden wi ogeẓnén Ƹisa, ḍaẓẓen ds, eggatent. ");
INSERT INTO thv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sawaren as udem tikest ezzar édt sestenen : « Key wan ennebi, en anɣ mi key yeweten ? » ");
INSERT INTO thv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Sikufuren fols a a yeǧǧén s awalen ǎǧǧotnén. ");
INSERT INTO thv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","As yeffo, imɣaren n elyehud -imerubay wi mǎqqornén d elƹulama wi kettebnén- ǎddukkelen. Éweyen Ƹisa s elmejles nsn wa mǎqqeren. ");
INSERT INTO thv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Essestenent : « Key as Elmesiḥ ? En anɣ tn. » Yenna hasn : « Kud ennéɣ awn tn wr hi éd teflesem, ");
INSERT INTO thv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kud essestenɣ kewen, wr hi éd tejawbim, wr hi éd teyyim. ");
INSERT INTO thv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Elmedet as, mn dimaɣ Ag ǎwadem éd yeqqayem fol aɣil n Yaḷḷah ilan terna. » ");
INSERT INTO thv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ennen emdan : « Key as Ag Yaḷḷah ? » Yenna hasn : « Iman nwn tennem tn, amoseɣt. » ");
INSERT INTO thv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ezzar ennen : « Ǎbas nera imašhaden ! Neslas iman nnɣ igannén s émi ennét ! » ");
INSERT INTO thv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tenker ejjemƹiya temda, éweyen Ƹisa dat Bilaṭes. ");
INSERT INTO thv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Eqqimen saḍlament gannén : « Nosa ales waɣ yegmay éd isexrek ǎddunet nnɣ, yera aked éd tn iseǧmeḍ ǎbǎreqqa n Elqaysar : iganna sn wr has reẓẓemen tiwsé, iganna aked in yǎmos Elmesiḥ wan ǎmenokal. » ");
INSERT INTO thv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yessestent Bilaṭes : « Tǎmosed ǎmenokal n Elyehud ? » Yenna has Ƹisa : « Tennéd tn iman ennek. » ");
INSERT INTO thv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yenna Bilaṭes dédih i imerubay wi mǎqqornén d ǎddunet : « Wr henneyeɣ eddelil wl iyyen a fol ewweddebeɣ ales waɣ. » ");
INSERT INTO thv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ennen as arwǎh : « Yegmay éd isewweǧ i ǎddunet ettowra, isaɣra dɣ Yehudiya temda, yessenta dɣ Jalila ar déɣ. » ");
INSERT INTO thv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","As yesla Bilaṭes awén, yessesten : « Ales waɣ in Jalila ? » ");
INSERT INTO thv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","As yelmed in Ƹisa yefal-d ǎkal wa dɣ yeḥkam Hérodes, yesséweyas-t, édét iha Yerušelem iheḍan windɣ. ");
INSERT INTO thv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yekna Hérodes tǎdewit hullan as yeney Ƹisa. Edét yeslas, yeɣhal édt yeney a ilan a yeǧǧén, yera éd yeney Ƹisa itaǧǧen tikunén. ");
INSERT INTO thv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yeǧas isestanen ǎǧǧotnén ad iǧa a yeggén beššan wr has yenné Ƹisa heret. ");
INSERT INTO thv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Imerubay wi meqqornén d elƹulama wi kettebnén ebdaden deh saḍlament s eṣṣahet. ");
INSERT INTO thv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elkent Hérodes d jonditen ennét, eṭsen ds, esselsent aselso yeknan tihusay ezzar errent ɣor Bilaṭes. ");
INSERT INTO thv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dɣ waɣ ahel ǎqqelen Bilaṭes d Hérodes imidiwen, fol enǧom ǎmosen ihenǧa. ");
INSERT INTO thv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesdew Bilaṭes imerubay wi meqqornén d imɣaren n ǎkal d ǎddunet emdan, ");
INSERT INTO thv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","yenna hasn : « Téweyem ahid ales waɣ, tǧanném yessexrek ǎddunet. Essesteneɣt datwn, tesséḍlememt beššan wr enéyeɣ eddelil wl iyyen a fol ewweddebeɣ ales waɣ. ");
INSERT INTO thv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aked Hérodes wrt yosé yeḍlam, yerra nɣt-id. Dedih, ales waɣ wr yeǧé heret yeniheggen d tǎmettant. ");
INSERT INTO thv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Adih éd-t ewweddebeɣ ezzar éd-t eyyeɣ. » ");
INSERT INTO thv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ak ǎmud n Ǎsuref -Tefaské n Elyehud-, yewar Bilaṭes éd-d hasn iseǧmeḍ ales iyyen dɣ tǎkormut. ");
INSERT INTO thv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Esiɣeren as emdan, gannén : « Ekf ales waɣ tǎmettant ! Segmeḍ anɣ-d Barabbas ! » ");
INSERT INTO thv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas iha tǎkormut fol in iǧa iman d yessinker ettowra dɣ aɣrem. ");
INSERT INTO thv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilaṭes yera éd iseǧmeḍ Ƹisa, yesséwel asn daɣ. ");
INSERT INTO thv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Beššan esiɣerén as : « Tǎmettant fol tǎgettewt ! Tǎmettant fol tǎgettewt ! » ");
INSERT INTO thv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yesséwel Bilaṭes s émér wan keraḍ, yenna : « Ma yeɣhed ? Wr enéyeɣ eddelil wl iyyen st esséweyeɣ s tǎmettant. Éd-t ewweddebeɣ ezzar éd-t eyyeɣ. » ");
INSERT INTO thv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Beššan esiɣerén in eran éd yewer Ƹisa tǎgettewt. Tǎɣerit nsn teṣṣohet. ");
INSERT INTO thv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yerḍa sn Bilaṭes, yoyya sn awa eran. ");
INSERT INTO thv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yessegmeḍ tǎkormut ales was as ennen, wa iǧan iman yessinker ettowra. Yoyya sn Ƹisa éd ss eǧin awa eren. ");
INSERT INTO thv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A yekka éwayen Ƹisa emheyyén d Simƹun, ales iyyen n Qeyrawan, yefal-d iferǧan. Ermesent, eswerent tǎgettewt baš éd tt yeway ḍeffer Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ǎddunet eknanén ǎǧut elkamen as, aked téḍéḍén ǎǧǧotnén esilefnén dɣ érét ennét. ");
INSERT INTO thv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesweḍin dsnt Ƹisa yenna : « Eššét Yerušelem, wr teslefmet foli ! Selefmet fol iman nekmet d meddankmet ! ");
INSERT INTO thv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Édét yéweḍ émér wa fol éd yehawel :-Tengeḍ i timeǧǧuǧra, tengeḍ i tisattén ti wrn éréw, tengeḍ i ifefan wi wrn essenkes !- ");
INSERT INTO thv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Adih éd ennin ǎddunet i tidreɣén : -Oḍumet folnɣ !- Méɣ i iménḍeḍen : -Efferet anɣ- ");
INSERT INTO thv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","édét kud taǧǧem awaɣ i isǎɣéren ebdagnén, ma hé yegrewen wi eqqornén ? » ");
INSERT INTO thv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eméweyen-d essin erk aytadem eddéwen d Ƹisa s tǎmettant. ");
INSERT INTO thv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","As éweḍen édeg was itahawal « Ǎkerkor\", ezzogehen jonditen dɣ ifassen n Ƹisa d éḍaren ennét teẓoli t-teṭṭafet fol tǎgettewt. Eǧen awén aked i erk aytadem winǧam, iyyen fol aɣil ennét wa heḍen fol tehalǧé. ");
INSERT INTO thv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yenna Ƹisa : « Abba, sorf asn, édét wr essénen awa taggen. » Ǎẓunen iselsa ennét ǧérésn s iseɣéren. ");
INSERT INTO thv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ǎddunet eqqimen ekyaden. Imɣaren n Elyehud eqqimen ḍazzen ds, gannén : « Yennejja ǎddunet wiyeḍ heḍnén, yennejjét iman ennét kud enta as Elmesiḥ, wa yesnefren Yaḷḷah ! » ");
INSERT INTO thv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ḍazzen ds aked jonditen, osent-in, eẓẓoheẓen as elxel, ");
INSERT INTO thv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ennen as : « Kud key ǎmenokal n elyehud a tǎmosed, nej iman ennek ! » ");
INSERT INTO thv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dennegs, yektab s elyunaniya, ellatiniya d elƹibraniya: « Awaɣ ǎmenokal n Elyehud. » ");
INSERT INTO thv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iyyen dɣ erk aytadem iwaren tǎgettewt ennét, yessebé yenna : « Wr tǎmosed Elmesiḥ key ? Nej iman ennek d tennejed anɣ ! » ");
INSERT INTO thv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Beššan yeɣtelt wa heḍen : « Wr teksoḍed Yaḷḷah key wa ds yoheren tanaṭ ? ");
INSERT INTO thv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eššeriɣa ta nnɣ teẓẓal, nenihegga ds édét neɣhad heret, beššan enta ula yeɣhed. » ");
INSERT INTO thv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ezzar yenna : « Ƹisa, teqqimed tkuttud ahi as-d tosed teminakeled. » ");
INSERT INTO thv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yenna has Ƹisa : « Éd hak tn enneɣ, édét tidet, ahel waɣ éd dɣi tidawed s eljennet. » ");
INSERT INTO thv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","As itag awéndɣ ihwer teǧa terut, elsenet tihay ǎrori n ǎkal imda ar deroɣ tewer tézzar. ");
INSERT INTO thv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tettunkel tǎfuk, tenxer teǧǎfayt ta huheret n Éhen wa Heddigen dɣ ǧéréǧéré. ");
INSERT INTO thv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesɣeret Ƹisa, yenna : « Abba, eǧéɣ imanin ǧer ifassen ennek. » As yenna awén efelent iman. ");
INSERT INTO thv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","As yeney elqebtan n errumaniten awén, yomel Yaḷḷah ezzar yenna : « Wrt iǧméḍ eššek, ales waɣ i yolaɣen ! » ");
INSERT INTO thv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Emdan ǎddunet wi hin osenen éd eynin awa hé yeǧin, as eneyen awa iǧen, eglen eggaten idmaren nsn. ");
INSERT INTO thv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Imidiwen n Ƹisa emdan, d téḍéḍén ti ds eddéwnén mn Jalila, emalen dɣ igeg baš éd hanneyen awa itaggen. ");
INSERT INTO thv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yellé ales iyyen igan isem Yusef. Ales yolaɣen, yeẓẓalen. Yǎmos iyyen dɣ imɣaren win elmejles wa mǎqqeren, ");
INSERT INTO thv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","beššan enta wr yerḍé fol tinaḍén n wi heḍnén ula fol iǧiten nsn. Yefal-d aɣrem wan Erramata, ihan ǎkal n elyehud, yeqqal i Elmelek n Yaḷḷah. ");
INSERT INTO thv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yosa Bilaṭes, yegmey ds tafekka tan Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yesres-t id, yesseɣley as téfit, yeǧé dɣ teɣaɣit eɣahen ǎddunet eknan ds aẓekka, édeg wa dɣ wrt imél animér wl iyyen. ");
INSERT INTO thv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Awén ahel n ǎzewwejjed, deroɣ éheḍ n essebet, ahel n tesonfat. ");
INSERT INTO thv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Téḍéḍén ti-d eddéwnén d Ƹisa mn Jalila, elkemnet i Yusef, ekyednet aẓekka tassennet taɣera ta tega tafekka ennét tensa. ");
INSERT INTO thv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ezzar eqqelnet aɣrem éd ekninet elɣeṭren d ihewayen wi hé eginet fol tafekka ennét. Ahel n essebet wr eknénet ula enḍerren, essunfenet édét awéndɣ a tenna eššeriƹa. ");
INSERT INTO thv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Déndɣ d yeffo ahel wan elḥad, ahel wa yelkamen i wan tesonfat, ekkenet téḍéḍén aẓekka dɣ édeg wa iha Ƹisa éwaynet ihewayen d elɣetren wi eknenet. ");
INSERT INTO thv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Osenet adih aẓẓed wa-t illen dat émi n aẓekka yeɣirarew-in. ");
INSERT INTO thv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eggehnet beššan wr osenet tafekka tan Émeli Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Adih ǎbas essennet awa hé exxemmemnet as d ǎmunen datsnt essin médden elsanén iselsa ǎmilewlewnén. ");
INSERT INTO thv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Eknenet taremmeq, esweḍnet dɣ ǎmǎḍal, ennen asnt médden : « Mafol tegmaymet éré yeddarren ǧér inemmutan ? ");
INSERT INTO thv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wr illé déɣ, beššan yedder. Semmektumet awa yenna animér iha Jalila : ");
INSERT INTO thv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","-Ag ǎwadem éd yetweɣdar, éd iggeh ifassen n ǎddunet win inesbekkaḍen, éd-t etteyteyen fol tǎgettewt, éd-d yefel tǎmettant ahel wan keraḍ-. ");
INSERT INTO thv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ektenet-d tifér tin Ƹisa. ");
INSERT INTO thv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Efelnet aẓekka osenet inemmahalen n Ƹisa win meraw d iyyen d inelkimen wi heḍnén, egenet asn isǎlan wiɣ emdan. ");
INSERT INTO thv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Entenetéḍ Meryem Elmejdaliya, Yuwenna d Meryam mas n Yaƹqub d téḍéḍén ti heḍnén dsnt eddéwnen, ennenet awén imda i inemmahalen. ");
INSERT INTO thv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Beššan eɣélen wr essénnet awa gannénet, wr tnt eflésen. ");
INSERT INTO thv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Beššan Betrus yenker yohel ad yeweḍ aẓekka, yeneh-in beššan wr yenéy ar téfit tensa fol ǎmǎḍal. Yeqqel ihenan ennét yekun fol awa iǧen. ");
INSERT INTO thv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ahel héndɣ, essin dɣ inelkimen win Ƹisa ekkan taɣremt tegat isem Ƹimwas, temel fol senatet essaɣeten n téklé mn Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Esséwelen fol awa iǧen imda. ");
INSERT INTO thv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A yekka eglan, esséwelen, yoheẓ-in Ƹisa yeqqim yeddéy dsn. ");
INSERT INTO thv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hanneyent beššan yekkas asn heret iyyen éd-t ezzeyen. ");
INSERT INTO thv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yessesten tn Ƹisa : « Ma fol tesséwelem a yekka terǧéhem? » Ebdeden, udmawen nsn yewar tn ezerri. ");
INSERT INTO thv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Iyyen dsn igan isem Kelyubas, yenna has : « Key ɣas dɣ wi ehenén Yerušelem a wrn yessén awa iǧen iheḍan wiɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yenna : « Ma iǧen ? » Ennen as : « Awa yeǧrewen Ƹisa wan Ennaṣira ! Enta ennebi mǎqqeren a yǎmos, yessekné s iǧiten ennét d awal ennét dat Yaḷḷah d ǎddunet emdan. ");
INSERT INTO thv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Imerubay wi mǎqqornén d imɣaren nnɣ ekfent in baš éd yemmet fol tǎgettewt. ");
INSERT INTO thv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nekkenéḍ nemos wiyeḍ dɣ wi egernén eṭṭema n as enta a hé yennejjin Israyil. Beššan, dimaɣ okeyen keraḍ iheḍan ḍeffer tǎmettant ennét. ");
INSERT INTO thv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tidet as ahel waɣ eskerebbetnet anɣ téḍéḍén tiyyeḍ dnɣ eddéwnén. Ekkenet aẓekka ennét déndɣ d yeffo ");
INSERT INTO thv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wr osénet tafekka ennét. Eqqelnet anɣ-d, ennenet eneynet ǎngelosen hasnt innen in yeddar. ");
INSERT INTO thv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wiyeḍ dɣ imidiwen nnɣ osen aẓekka ennét, eneyen awa ennenet téḍéḍén beššan enta wr ds-t osén. » ");
INSERT INTO thv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yenna hasn Ƹisa : « Kewenéḍ iba n tayetté a kewen yegrawen ! Ulawen newen eẓẓayen ed eflesen awa ennen ennebiten ! ");
INSERT INTO thv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wr yelzém in éd iney Elmesiḥ ǎɣena waɣ arweh wrt yezzoǧeh Yaḷḷah dɣ elmejd ennét ? » ");
INSERT INTO thv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ezzar yenna hasn awa yehéwelen fols dɣ elkettaben, yessenta s wan Musa yokey s ennebiten emdan. ");
INSERT INTO thv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","As eweḍen aɣrem wa ekkan, yesseknén Ƹisa in yokay. ");
INSERT INTO thv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ermesent, ennen as : « Γeyem ɣornɣ, deroɣ iǧa éheḍ. » Yeggeh aɣrem yeddéw dsn. ");
INSERT INTO thv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yeqqim, yertey dsn s ǎmekši, yeṭkel tagella, yomel Yaḷḷah, yerẓa tagella ezzar yekfasen tt. ");
INSERT INTO thv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Émér héndɣ emérenet téṭṭawén nsn ezzeyent, beššan yettunkel asn in. ");
INSERT INTO thv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ennen ǧérésn : « Weggén yeḍḍas ulawen nnɣ a yekka itar anɣ téṭṭawén fol Elkettaben dɣ ǎbǎreqqa ? » ");
INSERT INTO thv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Enkeren émér héndɣ ǎqqelen Yerušelem. Osen inemmahalen win meraw d iyyen entenéḍ d imidiwen nsn, ");
INSERT INTO thv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","gannén : « Itbat as Émeli nnɣ yenker-d dɣ tǎmettant, yemun-d i Simƹun ! » ");
INSERT INTO thv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dedih aked entenéḍ eǧen asn isǎlan n awa iǧen dɣ ǎbǎreqqa d menék awa eǧen ezzeyen Ƹisa émér wa-d iraẓ tagella. ");
INSERT INTO thv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Esséwelen fol awéndɣ arweh as in yebded Ƹisa ǧérésn, yenna hasn : « Esselamet folwn ! » ");
INSERT INTO thv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eknen tǎremméq d ǎmettesu édét eɣélen hanneyen ag ǎsuf. ");
INSERT INTO thv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yenna hasn Ƹisa : « Mafol termaɣem ? Mafol yeggeh eššek dɣ ulawen nwn ? ");
INSERT INTO thv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ekidet ifassenin d éḍarenin, awarɣ nk ! Eḍset ahi d tekidem, ag ǎsuf wr ilé éɣesan ula isan, hanneyem as nk léɣ-tn. » ");
INSERT INTO thv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A yekka iganna awéndɣ, isaknén ifassen ennét d éḍaren ennét. ");
INSERT INTO thv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Awa hasn tega tǎdewit, wr eflésen awa hanneyen, ekunen, adih yessesten tn : « Wr telém a yemmekšen déɣ ? » ");
INSERT INTO thv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ekfent ǎsolmi yeŋŋan d heret n torawet. ");
INSERT INTO thv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yeṭkel tn, yekšén datsn. ");
INSERT INTO thv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ezzar yanna hasn : « Arweh elléɣt ǧéréwn, ennéɣ awen in yelzam éd yetbet awa yektaben foli dɣ eššeriƹa tan Musa, dɣ elkettaben win ennibiten d dɣ Tisiway. » ");
INSERT INTO thv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dédih yora sn tayetté baš éd egrehen Elkettaben, ");
INSERT INTO thv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","yenna hasn : « Weggéɣ iktab as Elmesiḥ ilzam as éd yaẓer, ezzar éd yenker ǧér inemmuttan ahel wan keraḍ. ");
INSERT INTO thv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ezzar ilzam in isǎlan n tetubt d ǎsaruf n ibekkaḍen dɣ érét n isem ennét éd eǧin i ellametén emdanet, yenta awéndɣ Yerušelem. ");
INSERT INTO thv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tešhadem fol awén. ");
INSERT INTO thv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Imanin as hawen-d éd siwyeɣ elɣahed wa iǧa Abbahin. Kewenéḍ ɣeymet dɣ aɣrem a-dt teǧrewem terna tan afella. ");
INSERT INTO thv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yelwey tn Ƹisa s aɣrem wan Beytƹanya, yeṭkel ifassen, yeǧa sn elbaraka. ");
INSERT INTO thv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A yekka itag asn elbaraka, yefel tn, yetweṭkal s aǧenna. ");
INSERT INTO thv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Entenéḍ, erkeƹen ezzar eqqelen Yerušelem eknan tǎdewit. ");
INSERT INTO thv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Eqqimen abedǎh dɣ éhen wan ǎmud xammeden Yaḷḷah.");
ALTER TABLE thv_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
