﻿USE sofia;
DROP TABLE IF EXISTS sofia.thr_vpl;
CREATE TABLE thr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES thr_vpl WRITE;
INSERT INTO thr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","अब्राहम को बंस दाऊद के लौड़ा ईसु मसीह की बंसावली किताब मैं जौ तरह से है। ");
INSERT INTO thr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहम इसहाक को दऊवा रहै, और इसहाक याकूब को दऊवा, और याकूब यहूदा और बाके भईय्यन को दऊवा, ");
INSERT INTO thr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा को लौड़ा पेरेस और जरह रहैं उनकी अईय्या को नाओं तामार रहै। पेरेस हेस्रोन को दऊवा रहै, हेज्रोन आराम को दऊवा रहै, ");
INSERT INTO thr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","आराम अम्मीनादाब को दऊवा, और अम्मीनादाब नहसोन को दऊवा, और नहसोन सलमोन को दऊवा, ");
INSERT INTO thr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन से बोअज को जनम भौ, बोअज की अईय्या को नाओं राहाब रहै, बोअज और रूत से ओबेद को जनम भौ और ओबेद यिसै को दऊवा रहै। ");
INSERT INTO thr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","और यिसै से राजा दाऊद पैदा भौ। सुलैमान दाऊद को लौड़ा रहै जो बौ बईय्यर से पैदा भौ जो पहले ऊरिय्याह की बईय्यर रहै। ");
INSERT INTO thr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","और सुलैमान रेहोबाम को दऊवा, और रेहोबाम अबिजा को दऊवा, और अबिजा आसा को दऊवा, ");
INSERT INTO thr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","यहोसापात को दऊवा आसा, और जोराम को दऊवा यहोसापात, और उज्जियाह को दऊवा जोराम; ");
INSERT INTO thr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","और उज्जियाह योताम को दऊवा, और योताम आहाज को दऊवा, और हिजकिय्याह को दऊवा आहाज, ");
INSERT INTO thr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","और हिजकिय्याह मनस्से को दऊवा, और मनस्से आमोन को दऊवा, और आमोन योसिय्याह को दऊवा, ");
INSERT INTO thr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","फिर इस्राएल के लोगन कै बंधी बनाएकै बेबीलोन लै जात समय योसिय्याह से यकुन्याह और बाके भईय्या पैदा भै। ");
INSERT INTO thr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबीलोन मैं जान के बाद यकुन्याह सालतियेल को दऊवा बनो, सालतियेल से जरूब्बाबेल पैदा भौ, ");
INSERT INTO thr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","और जरूब्बाबेल से अबीहूद पैदा भौ, और अबीहूद को लौड़ा एलयाकीम, और एलयाकीम को लौड़ा अजोर, ");
INSERT INTO thr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","और अजोर को दऊवा सादोक, और अखीम को दऊवा एलीहूद, ");
INSERT INTO thr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","और एलियाजर के दऊवा एलीहूद और मत्तान को दऊवा एलीयाजर, और मत्तान याकूब के दऊवा, ");
INSERT INTO thr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","और याकूब, यूसुफ को दऊवा, जो मरियम को दऊवा रहै, मरियम से ईसु जनम भौ, जो मसीह कहलाओ। ");
INSERT INTO thr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","तौ, अब्राहम से लैकै राजा दाऊद तक चौदह पीढ़ी रहैं, और दाऊद से लैकै बंधी बनाएकै बाबुल पहुँचाए जाने तक चौदह पीढ़ी, और बंधी बनाएकै बेबीलोन पहुँचाए जाने से मसीह को जनम तक चौदह पीढ़ी और भईं। ");
INSERT INTO thr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ईसु मसीह को जनम ऐसे करकै भौ। बाकी अईय्या मरियम की दिखनौरी यूसुफ से हुई गई रहै, लेकिन जासे पहले कि बे बिहा करते, बाकै पता चल गौ कि बौ पवित्र आत्मा की सक्ति से गर्भवती है। ");
INSERT INTO thr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","लेकिन बाको होन बारो लोगा यूसुफ एक अच्छो और धर्मी आदमी रहै, बौ नाय चाहत रहै कि बाकै लोगन के सामने बदनाम करै, तभई बौ तै करी कि चुप्पे से बौ मंगनी तोड़ देबै। ");
INSERT INTO thr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जब बौ जौ बारे मैं सोचतै रहै, प्रभु को एक स्वर्गदूत बाकै सपने मैं दिखाई दई और कही, “हे यूसुफ दाऊद के लौड़ा, मरियम कै अपनी बईय्यर बनान के ताहीं मत डराबै। काहैकि जो बच्चा बाके गरब मैं है बौ पवित्र आत्मा की घाँईं से है। ");
INSERT INTO thr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","बाको एक लौड़ा होगो, और तुम बाको नाओं ईसु रखियो, काहैकि बौ अपने लोगन कै उनके पापन से बचागो।” ");
INSERT INTO thr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","जब प्रभु भविस्यवक्ता के जरिया कही भइ बात कै पूरो करन के ताहीं जौ सब करी, ");
INSERT INTO thr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","देखौ “एक कुवाँरी लौड़िया गर्भवती हुईकै एक लौड़ा कै जनम देगी, और बाको नाओं इम्मानुएल रखो जागो” जोको मतलब है, “परमेस्वर हमरे संग है।” ");
INSERT INTO thr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","जब यूसुफ नींद से उठो, तब बौ बहे करी जो प्रभु को स्वर्गदूत करन के ताहीं आग्या दई रहै बौ मरियम से बिहा करी, जैसी कि प्रभु के दूत बाकै आग्या दई रहै। ");
INSERT INTO thr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","लेकिन अपने लौड़ा कै पैदा होन से पहले बाके संग कोई गलत संबंध नाय रहै। और युसुफ अपने लौड़ा को नाओं ईसु रखी। ");
INSERT INTO thr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ईसु को जनम यहूदिया के बैतलहम सहर मैं बौ समय भौ जब हेरोदस राजा रहै। जाके तुरंत बाद, कुछ विद्वान लोग जो तारन को अध्ययन करत रहैं, अगार से यरूसलेम आए ");
INSERT INTO thr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","बे पूँछीं, “यहूदियन को नया जन्मों भौ राजा कहाँ है? हम बाके तारा कै आसमान मैं देखे, तभई हम पूँछ रै हैं, और हम बाकी आराधना करन कै आए हैं।” ");
INSERT INTO thr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","जब राजा हेरोदस जौ बारे मैं सुनी, तौ बौ भौत परेसान भौ, और ऐसोई यरूसलेम मैं सबै कोई रहै। ");
INSERT INTO thr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","बौ सब यहूदि सब बड़े पुजारिन और यहूदि नियम के सिक्छक कै बुलबाए कै उनसे पूँछी, “मसीहा को जनम कहाँ होने है?” ");
INSERT INTO thr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","बे जबाब दईं, “यहूदिया के बैतलहम सहर मैं, जाके बारे मैं भविस्यवक्ता लिखी हैं: ");
INSERT INTO thr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘लेकिन तैं यहूदा की धरती की सीमा स्थित बैतलहम, तैं यहूदा अधिकारिन मैं कोई से छोटो नाय है; काहैकि तेरे मैं से एक सासक आगो जो मेरे लोग और इस्राएल को मार्गदर्सन करैगो।’” ");
INSERT INTO thr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तभई राजा हेरोदस अगार से ज्योतिसियन कै चुप्पे से बैठक मैं बुलाई और उनसे पता लगाई कि तारा कौन से समय दिखो रहै। ");
INSERT INTO thr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","तब बौ उनकै जौ हुकम दैकै बैतलहम पनारी: “जाबौ बौ बालका के बारे मैं अच्छी तरह से पता लगाबौ, और जब तुम्हैं बौ मिल जाबै, तौ मोकै बताओ, जोसे महुँ जाएकै बाकी आराधना कर सकौं।” ");
INSERT INTO thr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","और बे राजा की आग्या सुनकै चले गै, और उनकै राह मैं बहे तारा दिखो जो बे अगार मैं देखीं रहैं। ");
INSERT INTO thr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","जब बे बौ तारा देखीं, तौ बे भौत खुस भै! ");
INSERT INTO thr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","बे घर मैं गै, और जब बे बालक कै बाकी अईय्या मरियम के संग देखीं, तौ झुककै घूँटो टेक बाकै दन्डवत करीं। और बे अपनो कीमती चीज को पिटारो खोलीं और अपनो सोनो, लोबान और मुर को भेंट लायकै, बाके सामने भेंट करीं। ");
INSERT INTO thr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","फिर बे दुसरी रस्ता से अपने देस कै लौट गै, काहैकि परमेस्वर उनकै सपने मैं चिताई रहै कि हेरोदस के झोने फिर मत जईयो। ");
INSERT INTO thr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","जब बे चले गै, तब प्रभु को एक स्वर्गदूत यूसुफ के सपने मैं दिखाई दई और कही, “राजा हेरोदस बालक कै मारन के ताहीं ढूँड़ैगो। सो उठ, बालक और बाकी अईय्या कै लै जा और मिस्र देस कै भाज जा, और जब तक मैं तुमकै देस छोड़न के ताहीं ना कहमौं, तब तक हूँनै रहियो।” ");
INSERT INTO thr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तौ युसुफ उठो, और बालक और बाकी अईय्या कै लैकै रातै कै मिस्र कै चले गौ, ");
INSERT INTO thr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","जहाँ बौ राजा हेरोदस के मरन ले रहो। ऐसो तभई भौ जौ प्रभु भविस्यवक्ता के जरिये कही रहै, बौ पूरो हुई जाबै “मैं अपने बालक कै मिस्र से बाहर बुलाओ।” ");
INSERT INTO thr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","राजा हेरोदस जब जौ देखी कि सितारन को अध्ययन करन बारे विद्वान बाके संग चाल चली हैं, तब बौ भौत गुस्सा हुई गौ और बौ आग्या दई कि बैतलहम और बाके आसपास मैं दुई साल या बासे छोटे सबै बालकन की हत्या कर दई जाबै! सितारन को अध्ययन करन बारे विद्वान के बताए भै समय को आधार बनाएकै जौ करी। ");
INSERT INTO thr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ऐसे करकै यिर्मयाह भविस्यवक्ता जो कही रहै, बौ सच मैं पूरो भौ: ");
INSERT INTO thr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामा नगर मैं एक अबाज सुनाई देथै, जो दर्दीली रोन की अबाज है। राहेल अपने बालकन के ताहीं रोय रइ है; ना चाहत रहै कि बौ समय बाकै कोई सांति दियै, काहैकि बाके तौ सबै बालका मर चुके रहैं।” ");
INSERT INTO thr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","जब राजा हेरोदस की मौत हुई गई, तब प्रभु को एक स्वर्गदूत मिस्र मैं यूसुफ कै एक सपने मैं दिखाई दई। ");
INSERT INTO thr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","बौ कही, “उठ, बालका और बाकी अईय्या कै लै जा, और इस्राएल देस की जमीन मैं तुम बापस लौट जाबौ, काहैकि जो आदमी बालकन की ज्यान लेन बारो रहै बौ मर चुको है।” ");
INSERT INTO thr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","तभई यूसुफ उठो, बालक और बाकी अईय्या कै लैकै इस्राएल देस चले गौ। ");
INSERT INTO thr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","लेकिन जब यूसुफ सुनी कि हेरोदस अपने लौड़ा अर्खलास कै यहूदिया को राजा बनाई है, तौ बौ हूँना जान से डरो। बाकै एक सपने मैं निरे निर्देस मिले रहैं, तभई बे गलील परदेस मैं चले गै। ");
INSERT INTO thr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","और नासरत नाओं के एक सहर मैं अपनो घर बनाईं। और तभई भविस्यवक्ता जो कहीं रहैं बौ बात सच मैं पूरी भइ: “बाकै नासरी कहो जाबैगो।” ");
INSERT INTO thr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","बौ समय यूहन्ना बपतिस्मा देन बारो यहूदिया के रेगिस्तान मैं आओ और प्रचार करनो सुरु करी। ");
INSERT INTO thr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","बौ कही: “पापन से मन फिराबौ, काहैकि स्वर्ग को राज्य झोने है!” ");
INSERT INTO thr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","यूहन्ना बहे आदमी है, जोके बारे मैं यसायाह भविस्यवक्ता चर्चा करत भै कही रहै, “कोई रेगिस्तान से चिल्लाए रौ है, कि प्रभु के ताहीं रस्ता तैयार करौ; बाके ताहीं राह सीधी बनाबौ!” ");
INSERT INTO thr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्ना के लत्ता ऊँट के बारन से बने रहैं; बौ अपने करिहाँओं मैं एक चमड़ा की कमरबंद पहने रहै, और बाको खानु टींड़ा और बन को सहद रहै। ");
INSERT INTO thr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","बौ समय यरूसलेम, और पूरो यहूदिया छेत्र और यरदन नदिया के आसपास के लोग बाके झोने आयकै जुराए गै। ");
INSERT INTO thr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","बे अपने पापन कै मान लेते, और बौ उनकै यरदन नदिया मैं बपतिस्मा दई। ");
INSERT INTO thr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जब यूहन्ना निरे फरीसियन और सदूकियन कै बपतिस्मा लेन के ताहीं बाके झोने आत देखी, तौ बौ उनसे कही, “साँप के बालकौ, जो तुमकै कौन बताई कि तुम प्रभु के भावी क्रोध से बच सकथौ? ");
INSERT INTO thr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","तुमकै सबूत देनो होगो कि तुम बास्तव मैं मन फिराए भै हौ। ");
INSERT INTO thr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","और जौ मत सोचौ कि तुम जौ कहकै सजा से बच जागे कि अब्राहम तुमरो पुरखा है। मैं तुमसे कहथौं कि परमेस्वर जे चट्टान से अब्राहम के ताहीं बंस बनाये सकथै! ");
INSERT INTO thr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","कुल्हाड़ी पेंड़न की जड़न कै काटन के ताहीं तैयार है; अच्छो फरा ना देनबारे सब पेंड़ कै काटकै आगी मैं झोंक दौ जागो। ");
INSERT INTO thr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","मैं तौ तुम्हैं पानी से मन फिराव के ताहीं पानी से बपतिस्मा देथौं, लेकिन जो मेरे बाद आगो बौ तुमकै पवित्र आत्मा और आगी से बपतिस्मा देगो। बौ मोसे भौत बड़ो है; और मैं इत्तो अच्छो नाय हौं कि बाकी जूता की तनी खोलन के काबिल हौं। ");
INSERT INTO thr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","बाके हात मैं बाको सूपो है, जोसे बौ गेंहूँ छान कै भूसा से अलग करथै अपने खेत कै साफ करकै पूरो अनाज कै इखट्टो कर कुठियन मैं भरैगो, पर भुसा कै ऐसी आगी मैं डार देगो जो कभी बुझन से न बुझैगी।” ");
INSERT INTO thr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","बौ समय ईसु गलील परदेस से चलकै यरदन नदिया के किनारे यूहन्ना के झोने बासे बपतिस्मा लई। ");
INSERT INTO thr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","लेकिन यूहन्ना जौ कहकै बाकै रोकन लगो कि, “मोकै तेरे हातन से बपतिस्मा लेन की जरूरत है और तहुँओं तैं मेरे झोने आओ है!” ");
INSERT INTO thr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","लेकिन ईसु बाकै जबाब दई, “हबै ऐसिये होन दे। हमसे जो परमेस्वर चाहथै बाकै पूरो करन के ताहीं धार्मिकता जहे तरहन से ठीक है।” फिर यूहन्ना मान गौ। ");
INSERT INTO thr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ईसु के बपतिस्मा लेन के तुरंत बाद, बौ पानी से बहार आओ, तौ बाके ताहीं स्वर्ग खोलो गौ, और बौ परमेस्वर की आत्मा को एक कबूतर के हानी नीचे उतरत और अपने ऊपर आत भौ देखी और बाके ऊपर उजीतो हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","तौ स्वर्ग से एक अबाज आई, “जौ मेरो अपनो प्रिय लौड़ा है, जोसे मैं भौत खुस हौं।” ");
INSERT INTO thr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","फिर आत्मा ईसु कै सैतान के जरिया परिक्छा करन के ताहीं मरुसथल मैं लै गई। ");
INSERT INTO thr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","चालीस दिन और चालीस रात बर्त रहन के बाद ईसु कै भूंक लगी। ");
INSERT INTO thr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","तब सैतान बाके झोने आओ और लालच देत भै कही, “अगर तैं परमेस्वर को लौड़ा है, तौ जे पथरन कै रोटी बनान के तहीं कह।” ");
INSERT INTO thr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","पर ईसु जबाब दई, “सास्त्र कहथै, ‘इंसान सिरफ रोटी से ही जिंदो नाय रह सकथै,’ लेकिन हर बौ सब्द से जीथै जो परमेस्वर बोलथै।” ");
INSERT INTO thr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","फिर सैतान ईसु कै यरूसलेम के पवित्र सहर मैं लै जाएकै, बौ बाकै मंदिर के सबसे ऊँची जघा मैं खड़ो करकै। ");
INSERT INTO thr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","और बासे कही, “अगर तैं परमेस्वर को लौड़ा है, तौ अपने आपकै नीचे फेंक दे, काहैकि सास्त्र कहथै, ‘परमेस्वर तेरी देखभार करन के ताहीं स्वर्गदूतन कै आग्या देगो ताकी तोकै हातौ हात उठाए लेंगे, ताकी तेरे पैर मैं पथरा से चोट ना लगै।’” ");
INSERT INTO thr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ईसु जबाब दई, “लेकिन सास्त्र जौ भी कहथै, ‘अपने प्रभु परमेस्वर की परिक्छा मत कर।’” ");
INSERT INTO thr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","जब सैतान ईसु कै भौत ऊँचे पहाड़ मैं लैगौ और बाकै दुनिया के सबै राज्यन कै अपनी महानता मैं दिखाई। ");
INSERT INTO thr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“सैतान कही, जौ सब मैं तोकै देंगो, अगर तैं झुककै मेरी आराधना करैगो।” ");
INSERT INTO thr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तौ ईसु जबाब दई, “सैतान चले जा! सास्त्र कहथै, ‘प्रभु अपने परमेस्वर की आराधना कर और सिरफ बहे की सेवा कर!’” ");
INSERT INTO thr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तौ सैतान ईसु के छोड़ दई; और स्वर्गदूत आयकै बाकी सेवा और मदत करीं। ");
INSERT INTO thr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जब ईसु सुनी कि यूहन्ना कै कैदखाना मैं डार दौ गौ है, तौ बौ गलील लौट आओ। ");
INSERT INTO thr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","लेकिन बौ नासरत मैं नाय ठहरो, लेकिन जबूलून और नप्ताली के इलाका मैं गलील झील के एक सहर कफरनहूम मैं रहन लगो। ");
INSERT INTO thr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ऐसो तभई भौ कि परमेस्वर यसायाह भविस्यवक्ता के जरिया जो कही रहै बौ पूरो हो। ");
INSERT INTO thr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबूलून की जमीन और नप्ताली के देस, समुंदर के रस्ता मैं, यरदन नदिया के पछार मैं गैर यहूदिन के देस गलील मैं! ");
INSERT INTO thr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","जो आदमी अंधियारे मैं जीथैं , बे एक महान जोती देखीं। जो मौत की छाया के देस मैं रहत रहैं उनके ऊपर जोती उनके ऊपर चमकी।” ");
INSERT INTO thr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","बौ समय से ईसु अपनो प्रचार सुनानो सुरु करी: “अपने पापन से मन फिराबौ काहैकि स्वर्ग को राज्य झोने है!” ");
INSERT INTO thr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","जैसे ईसु गलील झील के किनारे कै गौ, बौ दुई भईय्यन कै देखी, जो मछरेया रहैं, सिमौन पतरस और बाको भईय्या अन्द्रियास, एक संग जार से झील मैं मच्छी मारत रहैं। ");
INSERT INTO thr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ईसु उनसे कही, “मेरे पच्छू चले आबौ, मैं तुमकै सिखांगो मच्छी पकड़न के बजाय इंसानी रूपी मच्छी कैसे पकड़ी जाथैं।” ");
INSERT INTO thr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","बे तुरंतै अपनो जार छोड़कै बाके संग चले गै। ");
INSERT INTO thr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","फिर बौ हुँआँ से अग्गु चल पड़ो और बौ देखी कि, जब्दी को लौड़ा याकूब और बाको भईय्या यूहन्ना कै देखी। बे अपने दऊवा के संग नईंयाँ मैं जार सुरजात रहैं, ईसु उनकै बुलाई। ");
INSERT INTO thr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","और बे तुरंत नईंयाँ और अपने दऊवा कै छोड़कै बाके पच्छू चले गै। ");
INSERT INTO thr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ईसु गलील परदेस मैं यहूदि सभाघरन मैं स्वर्ग के राज्य को सुसमाचार को उपदेस देतो और सब तरह के रोग और बिमारन कै चंगो करत भै घूमन लगो। ");
INSERT INTO thr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","बाके बारे मैं पूरे सीरिया तक खबर फैल गई, तभई लोग जो बिमार रहैं और तरह-तरह के रोग और दुखन से दुखी रहैं, जिनमैं प्रेत आत्मा सवार रहैं, जिन्हैं मिर्गी आत रहै और जो फालिस के मारे रहैं बाके झोने लान लगे, और ईसु उन्हैं चंगो करी। ");
INSERT INTO thr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","तभई गलील दिकापुलिस जोके दस सहर कहो जाथै, यरूसलेम, यहूदिया, और यरदन नदिया के पार लोगन की बड़ी-बड़ी भीड़ बको अनुसरँड़ करन लगी। ");
INSERT INTO thr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ईसु भीड़ कै देखी और एक पहाड़ मैं चढ़गौ, जितै बौ बैठगौ, और बाके चेला बाके झोने आए गै, ");
INSERT INTO thr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","और बौ उनकै सिखान लगो: ");
INSERT INTO thr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“धन्य बे हैं, जो मन के दीन हैं; स्वर्ग को राज्य उन्हईं को है!” ");
INSERT INTO thr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“धन्य बे हैं जो दुख मनाथैं; परमेस्वर उनकै सांति देगो!” ");
INSERT INTO thr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“धन्य बे हैं जो विनम्र हैं; बे धरती के वारिस होंगे!” ");
INSERT INTO thr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“धन्य बे हैं, जो धार्मिकता के भूंके और प्यासे हैं, बे तृप्त करे जांगे!” ");
INSERT INTO thr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“धन्य बे हैं, जो दुसरेन ऊपर दया करथैं; परमेस्वर उनके ऊपर दया करैगो!” ");
INSERT INTO thr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“धन्य बे हैं जिनके मन सुद्ध हैं; बे परमेस्वर कै देखंगे!” ");
INSERT INTO thr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“धन्य बे हैं जो सांति के ताहीं काम करथैं; परमेस्वर उनकै अपनो लौड़ा बनागो!” ");
INSERT INTO thr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“धन्य बे हैं जिनकै धार्मिकता के बजह से सताओ जाथै, काहैकि स्वर्ग को राज्य उन्हईं को है!” ");
INSERT INTO thr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“धन्य तुम हौ, जब लोग तुमरी बुराई करथैं और तुमकै सताथैं और तुमरे खिलाप सबै तरह के झूठ बोलथैं काहैकि तुम मेरे अनुयायी हौ। ");
INSERT INTO thr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","धन्य और रहबौ काहैकि स्वर्ग मैं तुमरे ताहीं एक बड़ो इनाम रखो गौ है, बे तारन को अध्ययन करन बारे भविस्यवक्तन कै जो तुमसे पहले एसेई सताव गौ रहै।” ");
INSERT INTO thr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“तुम, पूरी इंसान जाति के ताहीं पृथ्वी के नमक के तरह हौ। लेकिन अगर नमक अपने नुनियानपन कै खाए देथै, तौ बाकै दुबारा से नुनियान बनान को कोई तरीका नाय है; जौ पक्का बेकार हुई गौ है, तभई जाकै बहार फेंक दौ जाथै और लोग बाकै रौंद देथैं।” ");
INSERT INTO thr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“तुम पूरी दुनिया के ताहीं उजियारो के हानी हौ। पहाड़ मैं बनो सहर छिप नाय सकथै। ");
INSERT INTO thr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","और लोग दिया जलायकै छपरिया के तरे नाय रखथैं लेकिन डीट मैं रखथैं, तौ बाके उजीते से घर के सब लोगन कै उजियारो मिलथै। ");
INSERT INTO thr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","बैसिये लोगन के सामने तुमरो उजियारो ऐसे चमकै कि तुमरे अच्छे कामन कै देख तुमरे स्वर्गिय, दऊवा की बड़ाँईं होबै।” ");
INSERT INTO thr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“जौ मत सोचौ कि मैं मूसा के नियम और भविस्यवक्तन के लिखे भै नियम कै खतम करन आओ हौं बल्कि उन्हैं पूरो करन के ताहीं आओ हौं। ");
INSERT INTO thr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","मैं सच कहथौं कि जब तक धरती और आसमान मिट न जामैं, तब तक मूसा के नियम की एक ंमात्रा या बिन्दु भी बिना पूरो भौ खतम नाय होगो। ");
INSERT INTO thr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","तौ जो कोई जे छोटी से छोटी आग्यन मैं से कोई एक कै तोड़ै, और बैसिये लोगन कै सिखाबै, बौ स्वर्ग के राज्य मैं सबसे छोटो मानो जागो; लेकिन जो कोई उनको पालन करैगो और उनकै सिखागो, बहे स्वर्ग के राज्य मैं महान मानो जागो। ");
INSERT INTO thr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","मैं तुमकै सच कहथौं, तुम स्वर्ग के राज्य मैं तभई जाए पागे, जब तुम्हारी धार्मिकता यहूदि नियम के सिक्छन की तुलना मैं और फरीसियन की तुलना मैं जाधे बिस्वास के काबिल होगे।” ");
INSERT INTO thr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“तुम जानत हौ कि हमरे पुरखन से कहो गौ रहै कि हत्या मत करियो, ‘जो कोई भी कोई कै मारैगो बाकै कचहरी मैं न्याय के ताहीं ले जाओ जागो।’ ");
INSERT INTO thr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","लेकिन मैं तुमसे कहथौं कि जो कोई आदमी अपने भईय्या से गुस्सा करथै बाकै भी न्याय के अदालत मैं बाके ताहीं जबाब देनो होगो और जो कोई अपने भईय्या कै ‘तैं कोई काम नाय करथै है तौ बाकै महासभा मैं लाओ जागो। और अगर कोई अपने भईय्या कै हे मूर्ख कहेगो तौ बाकै नरक की आगी मैं जान को खतरा रैहगो।’ ");
INSERT INTO thr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","तौ अगर तैं बेदी मैं अपनो भेंट चढ़ाय रहो है और हूँना तोकै याद है कि तेरे भईय्या के मन तेरे ताहीं तेरे खिलाप मैं कुछ है, ");
INSERT INTO thr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","तौ तैं बेदी के सामने अपनी भेंट हूँनै धर दे, पहले जाएकै अपने भईय्या के संग मेल कर, और फिरौंकी बापस आयकै अपनी भेंट परमेस्वर कै चढ़ा।” ");
INSERT INTO thr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“अगर तुमरे खिलाप कोई मुकदमा चलाथै और तोकै अदालत मैं लै जाथै, तौ अदालत मैं पहोंचन से पहले जौ बात कै बाकै सुलझा, नाय तौ एक बार अगर तुम हूँना पौहौंच गै, तौ तुमकै न्यायधीस कै सौंप दौ जागो, जो तोकै सिपईय्यन कै सौंप देगो, और बौ तुमकै कैदखाना मैं डार देगो। ");
INSERT INTO thr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मैं तुमसे सच कहथौं, तैं जेल से तब तक छूट नाय पागो जबले तैं पैसा पाई-पाई नाय चुकाए देगो तौले हूँना से छुट ना पायगो।” ");
INSERT INTO thr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“तुम सुने हौ कि जौ कहो गौ रहै, ‘व्यभिचार मत करीये।’ ");
INSERT INTO thr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","लेकिन मैं तुमसे कहथौं: अगर जो कोई की बईय्यर कै वासना की नजर से देखथै तौ बौ अपने मन मैं पहले से ही व्यभिचार कर चुको है। ");
INSERT INTO thr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","तौ अगर तुमरी दहनी आँखी तुमकै पाप की बजह बनाथै, तौ बाकै निकारकै फेंक दे! तुमरे सरीर के एक हिस्सा कै खाए देन से अच्छो है कि तुम अपने पूरे सरीर कै नरक मैं जान से बचाए लेगे। ");
INSERT INTO thr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","और अगर तुमरो दहनो हात पाप करबाय, तौ बाकै काटकै फेंक दे! काहैकि तुमरे ताहीं अच्छो है कि तेरो सरीर को एक अंग नास होन के बजाय जासे कि तेरो पूरो सरीर नरक मैं जान से बच जाबै।” ");
INSERT INTO thr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“जौ भी कहो गौ रहै, ‘जो कोई भी अपनी बईय्यर कै तलाक देथै, बाकै तलाक को लिखत रूप मैं तलाक देनो चहाईये।’ ");
INSERT INTO thr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","लेकिन मैं तुमसे कहथौं: हर बौ आदमी अपनी बईय्यर कै तलाक देथै, अगर बौ जौ तलाक बाके व्यभिचारी आचरड़ के बजह से नाय दियो गौ है तौ जब बौ दुसरो बिहा करथै तौ बौ आदमी बासे व्यभिचार करवाथै। और जो कोई बौ छोड़ी भइ बईय्यर से बिहा करथै तौ बौ भी व्यभिचार करथै।” ");
INSERT INTO thr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“तुम जहो सुने हौ कि हमरे पुरखन से कहो गौ रहै, ‘अपनो वादा मत तोड़िये, लेकिन बौ करीये जो प्रभु से करन की कसम खाए हौ।’ ");
INSERT INTO thr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","लेकिन मैं तुमसे कहथौं: कि कसम मत खाबौ हिंयाँ तक की स्वर्ग की कसम मत खाबौ, काहैकि जौ परमेस्वर को सिंहासन है; ");
INSERT INTO thr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","और ना धरती, काहैकि जौ बाके पाँव के चौकी की जघा है; ना यरूसलेम की, जरिया, काहैकि जौ महान राजा को सहर है। ");
INSERT INTO thr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ना तौ तैं अपने मूड़ की कसम खईयो, काहैकि तू एक भी बार सफेद या कारो नाय कर सकथौ। ");
INSERT INTO thr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","लेकिन तुमरी बात ‘हाँ’ कि ‘हाँ’ और ‘ना’ कि ‘ना’ होबै; काहैकि जो कुछ जासे जाधे होथै बौ दुस्ट के घाँईं से होथै।” ");
INSERT INTO thr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“तुम सुने हौ कि जौ कहो गौ रहै, ‘एक आँखी के बदले एक आँखी, और दाँत के बदले दाँत।’ ");
INSERT INTO thr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","लेकिन अब मैं तुमसे कहथौं: बुरे आदमी को बिरोध मत करौ। अगर कोई तुमरे दहने गलऊवा मैं चाँटा मारै तौ बाकै अपने बाँए गलऊवा मैं भी चाँटा मारन दे। ");
INSERT INTO thr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","और अगर कोई तेरे ऊपर तुमकै अपनो कुरता को फैसला के ताहीं मुकदमा करकै अदालत मैं लै जाथै, तौ बाकै अपनो झगिया भी दैदे। ");
INSERT INTO thr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","अगर तुम मैं से कोई एक तोकै कोस भर बेगार मैं लै जाबै तौ बाके संग दुई कोस चलो जा। ");
INSERT INTO thr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जब कोई तोसे कछु माँगै, तौ बाकै दैदे; जब कोई कुछ उधार लेनो चाहबै, तौ बाकै उधार दैदे।” ");
INSERT INTO thr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“तुम सुने हौ कि जौ कहो गौ रहै, ‘अपने दोस्तन से प्यार करौ, और अपने बैरियन से बैर करौ।’ ");
INSERT INTO thr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","लेकिन मैं तुमसे कहथौं: अपने बैरियों से प्यार करौ और बे आदमिन के ताहीं प्रार्थना करौ जो तुमकै सताथैं, ");
INSERT INTO thr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ताकी स्वर्ग मैं तुम अपने परम दऊवा के बालका बन सकौ। काहैकि बौ भले और बुरे दोनों के ऊपर अपनो सूरज चमकाथै, और जो धर्मी और अधर्मी के ऊपर मेंहें बरसाथै। ");
INSERT INTO thr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","अगर सिरफ तुम बे आदमिन से प्यार करथौ, जो तुमकै प्यार करथैं, तौ परमेस्वर काहे तुमकै इनाम देगो? हिंयाँ ले कि लगान लेन बारे ऐसोई नाय करथैं! ");
INSERT INTO thr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","अगर तुम अपने भईय्या बन्धू कै ही नमस्ते करैगे तौ तैं औरौ से जाधे का जाधे का कर रहो है? ऐसो तौ गैर यहूदि भी करथैं! ");
INSERT INTO thr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","तुम सिद्ध बनौ जैसे कि तुमरो स्वर्गिय दऊवा सिद्ध है।” ");
INSERT INTO thr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","सावधान रहबौ, “परमेस्वर चाहथै कि धार्मिकता के काम लोगन सामने दिखाबा के ताहीं मत करौ न तौ तुम स्वर्गिय दऊवा से बाको प्रतिफल नाय पागे।” ");
INSERT INTO thr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“तभई जब तुम कोई दीन दुखी कै दान देथौ तौ बाको ढिंढोरा मत पीटौ जैसो कि यहूदि सभाघर मैं और गलियन मैं कपटी लोग औरन से बड़ाँईं पान के ताहीं करथैं। मैं तुमसे सच कहथौं उन्हैं तौ बाको पूरो फल पहलिये ही दौ चुको है। ");
INSERT INTO thr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","लेकिन जब तुम कोई जरूरतमंद आदमी की मदत करथौ, और दीन दुखी कै देथौ, तौ तुमरो बाँया हात नाय जान पाबै कि तेरो दहने हात का करथै। ");
INSERT INTO thr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताकी तेरो दान छिपो रहबै; और तेरो परम दऊवा जो छिपो भौ देखथै, तोकै इनाम देगो।” ");
INSERT INTO thr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“जब तुम प्रार्थना करथौ, तौ कपटियन के तराहनी दिखाबा मत करौ! काहैकि उन्हैं यहूदि सभाघरन मैं और सड़कन के चौहराय मैं ठाड़कै प्रार्थना करनो अच्छो लगथै। ताकी लोग उन्हैं खास लोग के भेस मैं जानै। मैं तुम्हैं सच कहथौं, बे पहलिये सब प्रतिफल पाये लईं हैं। ");
INSERT INTO thr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","लेकिन जब तैं प्रार्थना करै, तौ अपने कमरा मैं जा, मोहोंट लगा और गुप्त रूप से अपने परम दऊवा से प्रार्थना कर और फिर तेरो परम दऊवा जो छिपकै तेरे कामन कै देखथै बाको तोकै प्रतिफल देगो।” ");
INSERT INTO thr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“जब तुम प्रार्थना करथौ, तौ गैर यहूदि कि तरह बेकार बातन कै बार-बार मत दोहराते रहबै तौ जौ सोचथौ कि भौत बोलन से उनकी सुनी जाबैगी। ");
INSERT INTO thr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","तौ तुम उनके हानी मत बनौ, काहैकि तुमरो परम दऊवा तुमरे माँगन से पहलिये जानथै, कि तुमकै का जरुरत है। ");
INSERT INTO thr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","तभई जौ तरह तुमकै प्रार्थना करनो चहाईये: ‘हे हमरे स्वर्गिय पिता, तेरो नाओं पवित्र मानो जाबै। ");
INSERT INTO thr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","तेरो राज्य आबै, तेरी इच्छा जैसी स्वर्ग मैं पूरी होथै, बैसिये धरती मैं भी होबै। ");
INSERT INTO thr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","हमरे दिन भर की रोटी आज हमकै दे। ");
INSERT INTO thr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","और जैसी हम अपने अपराधियन कै माफ करे हैं, बैसिये तहूँ हमरे अपराधन कै माफ कर। ");
INSERT INTO thr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","हमैं परिक्छा मैं न ला, और बुराई से बचा।’” ");
INSERT INTO thr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“अगर तुम दुसरेन की गलतियन कै माफ करैगे, तौ तुमरो स्वर्गिय दऊवा तुमकै माफ कर देगो। ");
INSERT INTO thr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","लेकिन अगर तुम दुसरेन कै माफ नाय करैगे, तौ तुमरो दऊवा परमेस्वर तुमरे करे भै गलत कामन कै माफ नाय करैगो।” ");
INSERT INTO thr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“और जब तुम बर्त रखथौ, तौ पाखंडी के तराहनी मोहों मत बनाबौ बे तरह-तरह से मोहों बनाथैं ताकी लोग उनकै जानै कि जे बर्त रखी हैं, मैं तुमसे सच्ची कहथौं कि बे अपनो इनाम पाय चुके हैं। ");
INSERT INTO thr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","लेकिन जब तुम बर्त रखथौ तौ अपनो मोहों धो और अपने बार मैं तेल लगाये कै उन्हैं अभिसेक कर। ");
INSERT INTO thr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ताकी दुसरे जान सकैं कि तुम बर्त कर रहै हौ, ऐसो करकै तेरो परम दऊवा जो लुककै करे भै कामन कै देखथै, तोकै इनाम देगो।” ");
INSERT INTO thr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“धरती मैं अपने ताहीं धन मत जोरौ, जहाँ कीरा और काई खतम कर देथैं, और चुट्टा चुराय लै जाथैं। ");
INSERT INTO thr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","बल्कि स्वर्ग मैं अपने ताहीं धन जोरौ, जहाँ ना कीरा और ना काई नास कर पाबै, और चुट्टा भी हुँआँ सेंध लगाये कै चुराय न सकथैं। ");
INSERT INTO thr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","काहैकि जितै तेरो धन उतै तेरो मनौ भी लगो रैहगो।” ");
INSERT INTO thr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“सरीर को दिया आँखी है। अगर तेरी आँखी ठीक है तौ तेरो पूरो सरीर उजियारो मैं रैहगो; ");
INSERT INTO thr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","लेकिन अगर तेरी आँखी खराब है, तौ तेरो सरीर अंधियारे मैं होगो। तभई सिरफ जो उजियारो जो तेरे भीतर है अगर अंधियारो हुई जाए तौ अंधियारो कित्तो गहरो होगो!” ");
INSERT INTO thr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“कोई भी एक संग दुई मालिक की सेवा नाय हुई सकथै; काहैकि बौ एक से नफरत करैगो, और दुसरे से प्यार करैगे; एक के प्रति बफादार रैहगो और दुसरे को तिरस्कार करैगो। तुम धन की और परमेस्वर की सेवा नाय कर सकथौ।” ");
INSERT INTO thr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“तभई मैं तुमसे कहथौं: जिंदो रहन के ताहीं, चिंता मत करीये कि हम खांगे, और का पीमंगे, और ना अपने सरीर के ताहीं कि का पहनंगे, सबन के बाद, का ज्यान रोटी से जद्धे जरूरी नाय है? और सरीर लत्तन से बढ़कै नाय है? ");
INSERT INTO thr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","आसमान के पक्छिन कै देखौ! बे ना तौ बीज बोथैं, नाय काटथैं, और कुठियन मैं जोड़थैं; तहुँओं तुमरो स्वर्गिय दऊवा उनकै खबाथै! का तुम बे पक्छिन से बढ़कै नाय हौ? ");
INSERT INTO thr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","का तुम मैं से कोई ऐसो है जो चिंता करकै अपने जिंदगी काल को एक घड़ी भी बढ़ाये सकथै?” ");
INSERT INTO thr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“और लत्तन के ताहीं काहे सोचथौ? देखौ बन के फूला कैसे बढ़थैं: बे ना तौ काम करथैं और ना अपने ताहीं लत्ता बनाथैं। ");
INSERT INTO thr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","लेकिन मैं तुमसे सच कहथौं कि महान सुलैमान राजा अपनी पूरी वैभव मैं से कोईये के तराहनी नाय सज सको। ");
INSERT INTO thr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","तौ जब परमेस्वर मैदान की घाँस कै, जो आज है, और कल भट्टी मैं झोंकी जागी, ऐसो लत्ता पहनाथै, तौ ओ कम बिस्वास करन बारे! का बौ तुमकै और भी जाधे ना पहनागो?” ");
INSERT INTO thr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“तौ चिंता मत करियो: ‘कि हम का खांगे? या का पींगे? और या का पहनंगे?’ ");
INSERT INTO thr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","गैर यहूदि लोग जे सब चीजन के पच्छू दौड़त रहथैं लेकिन स्वर्ग मैं रहन बारो तुमरो स्वर्गिय दऊवा जानथै कि तुमकै जे सब चीजन की जरूरत है। ");
INSERT INTO thr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","तभई जाके अलावा पहले तुम परमेस्वर के राज्य और धार्मिकता कै ढूँड़ौ तौ जे सब चीजैं तुमकै मिल जांगी। ");
INSERT INTO thr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","तौ कल के बारे मैं चिंता मत करौ; काहैकि कल को दिन अपनी चिंता अपने आप कर लेगो; आज के ताहीं आजै को दुख भौत है।” ");
INSERT INTO thr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“दुसरेन को न्याय मत करौ, ताकी परमेस्वर तुमरो न्याय ना करै, ");
INSERT INTO thr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","काहैकि तुमरो न्याय बहे फैसला के आधार होगो और जो नपना से तुम नापथौ, बहे से तुमरे ताहीं नापो जागो। ");
INSERT INTO thr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","तैं काहे अपने भईय्या की आँखी के कूरा कै देखथै, और अपनी आँखी को लट्ठा तोकै नाय दिखथै? ");
INSERT INTO thr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","तैं अपने भईय्या से कैसे कह सकथै, ‘ला मैं तेरी आँखी से कूरा निकार दियौं,’ जब तेरिये आँखी मैं लट्ठा है? ");
INSERT INTO thr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","अरे पाखंडी! पहले अपनी आँखी मैं से लट्ठा निकार ले, तौ तैं अपने भईय्या की आँखी को कूरा अच्छे से निकार पाएगो।” ");
INSERT INTO thr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“पवित्र चीज कुत्तन कै मत दियौ, और अपने मोती सोरा के अग्गु मत डारौ; ऐसो ना होबै कि बे उनकै टाँग तरे रौंद डारैं और कुत्ता तुम्हैं पलटकर फाड़ डारैं।” ");
INSERT INTO thr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“माँगौ तौ तुमकै दौ जागो, ढूँड़ौ तौ तुम पागे; खटखटाबौ, तौ तुमरे ताहीं खोलो जागो। ");
INSERT INTO thr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","काहैकि जो कोई मांगथै, बाकै मिलथै; और जो ढूँड़थै, बौ पाथै; और जो खटखटाथै, बाके ताहीं मोहोंट खोलो जागो। ");
INSERT INTO thr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तुम मैं से कौन इंसान है, कि अगर बाको लौड़ा बासे रोटी माँगै, तौ बौ बाकै पथरा पकड़ाबै? ");
INSERT INTO thr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","या मच्छी माँगै तौ, बाकै साँप देबै? ");
INSERT INTO thr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","अगर तुम बुरे हुईकै अपने बालकन कै अच्छी चीज देनो जानथौ, तौ तुमरो स्वर्गिय दऊवा अपने माँगन बारे कै अच्छी चीज काहे ना देगो?” ");
INSERT INTO thr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“तभई जैसो व्यवहार तुम अपने ताहीं दुसरेन से चाहथौ बैसो ही व्यवहार तू दुसरन से करौ; जौ मूसा की नियम विधि और भविस्यवक्ता को जहे सार है।” ");
INSERT INTO thr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“सकरे रस्ता से भीतर जाबौ, काहैकि चौंहड़ो फाटक से जानो सरल है बौ रस्ता जो बिनास के घाँईं लै जाथै; और भौत सारे लोग हैं जो बासे घुसथैं। ");
INSERT INTO thr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","लेकिन जिंदगी को फाटक सकरो है और हुँआँ तक जान बारो रस्ता कठिन है, और भौत कम लोग हैं जो जाकै पाथैं।” ");
INSERT INTO thr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“झूठे भविस्यवक्तन से चहाचीते रहबौ, जो भेंड़ के सकल मैं लत्ता पहने तुमरे झोने आथैं, लेकिन भीतर से फाड़न बारे भेंड़िया हैं। ");
INSERT INTO thr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","तुम उनके फलन से उनकै जान जाबैगे। का झाड़ियन से अंगूर तोड़थैं, या चिरचिरा से अंजीर इखट्टो करथैं? ");
INSERT INTO thr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ऐसिये हर एक अच्छो पेंड़ अच्छो फल देथै और बुरो पेंड़ बुरो फल देथै। ");
INSERT INTO thr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","अच्छो रूखा बुरो फल नाय दै सकथै, और ना ही बुरो पेंड़ अच्छो फल लाय सकथै। ");
INSERT INTO thr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","और जो पेंड़ अच्छो फल ना देथै, बौ काटो और आगी मैं डारो जागो। ");
INSERT INTO thr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","तभई तुम उनके कामन के परीड़ामो के जरिया बे भविस्यवक्तन कै पहचानैगे।” ");
INSERT INTO thr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“हर कोई जो मोकै, ‘प्रभु, प्रभु’ कहथै, स्वर्ग के राज्य मैं ना जाए सकैगो, लेकिन सिरफ बेईं जो मेरे परम दऊवा स्वर्ग मैं है, बाकी इच्छा मैं चलथैं। ");
INSERT INTO thr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","जब न्याय को दिन आगो, तौ निरे मोसे कहंगे, ‘प्रभु, प्रभु! तुमरे नाओं से हम भविस्यवाँड़ी करे, तेरे नाओं से हम निरे प्रेत आत्मा कै निकारे और कित्ते अचम्मे काम करे!’ ");
INSERT INTO thr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तौ ‘मैं उनसे खुलकै कहेंगो, देखौ मैं तुमकै कभी नाय जानो। अरे अधर्मियौ मोसे दूर हुई जाबौ!’” ");
INSERT INTO thr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“तभई, जो कोई मेरी जे बातन कै सुनथै और आग्या पालन करथै, बौ, बौ बुद्धिमान इंसान के जैसो है जो अपनो घर चट्टान मैं बनाई है।” ");
INSERT INTO thr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","मेंहें आओ और नदिया मैं बाढ़ आई, और आँधी चली, घर मैं से टक्कर खाईं, लेकिन बौ नाय गिरो, काहैकि बाकी बुनियाद चट्टान मैं पड़ी रहैं। ");
INSERT INTO thr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“लेकिन जो कोई मेरी बातन कै सुनथै और उनको पालन नाय करथै बौ एक मूर्ख आदमी के तराहनी है जो रेता मैं अपनो घर बनाई है। ");
INSERT INTO thr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","मेंहें आओ, बाढ़ आई, आँधी चली बौ घर से टक्कर खाई और बौ बुरी तरह से ढह गौ!” ");
INSERT INTO thr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जब ईसु जे बातन कै कह चुको, तौ भीड़ बाके सिक्छा से अचम्भित भइ। ");
INSERT INTO thr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","काहैकि बौ उन्हैं यहूदि नियम के सिक्छक के तराहनी नाय; बल्कि एक अधिकारी के तराहनी सिक्छा देत रहै। ");
INSERT INTO thr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जब ईसु पहाड़ से नीचे आओ, तौ भारी भीड़ बाके पच्छू हुई लई। ");
INSERT INTO thr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","तौ एक आदमी जोकै कोहोढ़ रोग रहै बाके झोने आओ, बाके अग्गु झुकी और घुटनो टेक दई, और कही, “गुरुजी, अगर तैं चाहबै, तौ मोकै सुद्ध कर सकथै।” ");
INSERT INTO thr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","तौ ईसु अपनो हात बढ़ाये कै कोहोढ़ रोगी कै छुइ और कही, “जरूर मैं चाहथौं कि तू सुद्ध हुई जा और तुरंत कोढ़ रोग ठीक हुई गौ।” ");
INSERT INTO thr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","तौ ईसु बासे कही, “सुन! कोई कै मत बतइये, लेकिन सीधे पुजारी के झोने जा और अपने आपकै दिखा; तौ सबन कै जौ साबित करन के ताहीं कि तैं ठीक हुई गौ है, और जो भेंट मूसा चढ़ान कै कही है; चढ़ा ताकी उनके ताहीं गभाई होबै।” ");
INSERT INTO thr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जब ईसु कफरनहूम मैं आओ, तौ एक रोमन सेनापति बासे मिलो और मदत के ताहीं नहोरे करी: ");
INSERT INTO thr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“प्रभु, मेरो एक सेवक घर मैं बिमार पड़ो है, बाकै फालिस मार गौ है, बाकै भौत पीड़ा हुई रइ है।” ");
INSERT INTO thr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“तब ईसु सेनापति से कही मैं आयकै बाकै अच्छो करंगो” ");
INSERT INTO thr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","अधिकारी जबाब दई “अरे नाय, प्रभु, मैं जाके लायक ना हौं कि तू मेरे घर के छत तरे आबै, लेकिन तू सिरफ बचन दैदे बस मेरो सेवक ठीक हुई जागो। ");
INSERT INTO thr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","काहैकि महुँ दुसरेन के अधिकार मैं रहन बारो एक आदमी हौं, और सैनिक मेरे हात मैं हैं, और जब एक से कहथौं, ‘जा!’ तौ बौ जाथै; और दुसरे से कहथौं कि ‘आ!’ तौ बौ आथै; और अपने सेवक से कहथौं, कि जौ कर, तौ बौ करथै।” ");
INSERT INTO thr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","जब ईसु जौ सुनी तौ बौ चकित हुई गौ, और जो बाके पच्छू आत रहैं उनसे कही, “मैं तुमसे सच कहथौं, कि मैं इस्राएल मैं कोईये मैं भी ऐसो बिस्वास नाय देखो। ");
INSERT INTO thr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","मैं तुमकै बिस्वास दिबाथौं कि निरे आदमी अगार और पछार से आंगे और स्वर्ग के राज्य मैं दावत मैं अब्राहम, इसहाक और याकूब के संग बैठंगे। ");
INSERT INTO thr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","लेकिन जो आदमिन कै राज्य मैं होनो चहाईये उनकै अंधियारे मैं फेंक दौ जागो, जितै बे रोंगे और अपने दाँतन कै पीसंगे।” ");
INSERT INTO thr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","तौ ईसु सेनापति से कही, “जा, बैसो ही तेरे ताहीं होबै जैसो तेरो बिस्वास है,” और अधिकारी को सेवक बहे समय ठीक हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","जब ईसु पतरस के घर पहुँचो, बौ पतरस की सास कै बुखार से बिमार बिस्तर मैं पाई, ");
INSERT INTO thr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","तभई ईसु बाकै अपने हात से छुइ और बुखार उतर गौ। फिर बौ उठी और ईसु की सेवा करन लगी। ");
INSERT INTO thr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","जब संजा खिन हुई गई, तौ आदमी ईसु के झोने आए, जिनके अंदर प्रेत आत्मा रहैं अपनी एक आग्या से बौ प्रेत आत्मा कै निकार दई जौ तरह से बौ सब रोगी कै चंगो कर दई। ");
INSERT INTO thr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","जौ तभई भौ ताकी परमेस्वर यसायाह भविस्यवक्ता के जरिया जो कही रहै पूरो होबै, “बौ खुद हमरी बिमारी कै लै लई और हमारी बिमारियन कै ठीक करी।” ");
INSERT INTO thr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","जब ईसु अपने आस-पास की भीड़ कै देखी, तौ बौ अपने चेलन कै झील के दुसरे पाँजर जान की आग्या दई। ");
INSERT INTO thr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","और एक यहूदि नियम को सिक्छक बाके झोने आओ। बौ कही, “प्रभु,” जहाँ कहूँ तैं जागो “मैं तेरे संग जान के ताहीं तैयार हौं।” ");
INSERT INTO thr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ईसु बाकै जबाब दई, “लोमड़ियन की माद और आसमान के पक्छी के घोसला होथैं, लेकिन इंसान के लौड़ा के पास मूड़ धरन के ताहीं जघा तक नाय है।” ");
INSERT INTO thr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","और बाको एक चेला बासे कही, “प्रभु, मोकै पहले जान दे, कि मेरे दऊवा कै दफनाए दियौं।” ");
INSERT INTO thr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","लेकिन ईसु जबाब दई, “तैं मेरे पच्छू हुई ले; और मरे भैन कै अपने मुर्दा खुद गाड़न दे।” ");
INSERT INTO thr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","तभई ईसु एक नईंयाँ मैं चढ़गौ, और बाके चेला बाके संग गै। ");
INSERT INTO thr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","और झील मैं एक ऐसो तूफान उठो कि नईंयाँ लहरन से ढकन लगी; लेकिन ईसु सोत रहै। ");
INSERT INTO thr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तौ चेला झोने आयकै बाकै जगाईं, और कहीं, “प्रभु हमैं बचा! हम मरे जाए रै हैं!” ");
INSERT INTO thr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","तभई ईसु उनसे कही, “अरे कम बिस्वास के आदमियौ! काहे डराथौ?” तौ बौ ठाड़कै तूफान और आँधी कै झुकाइ, और सब सांत हुई गई। ");
INSERT INTO thr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","और आदमी अचम्मो करकै कहेन लगे, “जौ कैसो इंसान है? कि आँधी और लहरैं जाकी आग्या मानथैं!” ");
INSERT INTO thr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जब ईसु झील के बौ पाँजर गदरेनियो के सीमा मैं पहुँचो, तौ दुई इंसान जिनके अंदर प्रेत आत्मा रहैं कबरन से निकरत भै उनकै मिले, जो इत्ते सक्तिसाली और भयानक रहैं कि कोई बौ रस्ता से छिर नाय पात रहै। ");
INSERT INTO thr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","और बे चिल्लाए कै कहीं, “हे परमेस्वर को लौड़ा, तैं हमसे का चाहथै? का तैं समय से पहले हमकै दुख देन कै आओ है?” ");
INSERT INTO thr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","थोड़ी दूरी मैं सोरन को झुंड चुगत रहै। ");
INSERT INTO thr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","प्रेत आत्मा बासे जौ कहकै नहोरे करीं, “अगर तैं हमैं निकारथै, तौ सोरन के झुंड मैं भेज दे।” ");
INSERT INTO thr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ईसु उनसे कही, “जाबौ,” तभई बे लोगन से निकरकै बे सोरन मैं जा घुसे और पूरो झुंड टीला से झपटकै नदिया मैं जाए गिरे और डूबकै मर गै। ");
INSERT INTO thr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","सोरन के रखबरिया हुँआँ से नगर मैं आए और सोरन के संग और प्रेत आत्मा से बिमार आदमी के संग जो कुछ भौ रहै नगर मैं जाएकै कह सुनाईं। ");
INSERT INTO thr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","तौ पूरे नगर के लोग ईसु से भेंटा करन कै निकर आए और बाकै देखकै नहोरे करीं, कि हमरे इलाका से बाहर निकर जा। ");
INSERT INTO thr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","फिर ईसु नईंयाँ से झील के जौ पाँजर अपने नगर बापस आओ, ");
INSERT INTO thr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","हूँना कुछ आदमी फालिस के मारे भै कै, खटिया मैं लाद कै बाके झोने लाईं। फिर ईसु बाको बिस्वास देखकै, बौ फालिस के मारे भै से कही खुसी मना, “मेरे लौड़ा! तेरे पाप माफ हुई गै।” ");
INSERT INTO thr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","तौ कुछ नियम के यहूदि नियम के सिक्छक आपस मैं कहीं, “जौ इंसान तौ परमेस्वर की बुराई करथै!” ");
INSERT INTO thr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ईसु उनके मन की बात जानकै कही, “तुम काहे अपने मन मैं बुरो सोच रै हौ? ");
INSERT INTO thr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","जौ कहनो सरल है, ‘कि तेरे पाप माफ करे गै हैं,’ या जौ कहनो, ‘उठ और नेंग?’ ");
INSERT INTO thr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","तौ तुमकै मालुम हुई जाबै, कि इंसान के लौड़ा कै पाप माफ करन के ताहीं पृथ्वी मैं अधिकार है।” तभई बौ फालिस के मारे भौ आदमी से कही, “उठ, अपनी खटिया उठा, और घरै चले जा!” ");
INSERT INTO thr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","आदमी उठकै घरै चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","जब आदमी जौ सब देखीं, तौ बे डराय गै, और आदमिन कै ऐसो अधिकार देन के ताहीं परमेस्वर की बड़ाँईं करीं। ");
INSERT INTO thr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ईसु जब हुँआँ से जात रहै, तौ बौ लगान की चौकी मैं बैठौ एक आदमी कै देखी बाको नाओं मत्ती रहै। बौ बासे कही, “मेरे पच्छू आ।” और मत्ती उठकै बाके पच्छू हुई लई। ");
INSERT INTO thr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","जब ईसु मत्ती के घरै खानु खात रहै, तौ निरे लगान लेन बारे और पापी आदमी आए और मेज मैं ईसु और बाके चेलन के संग खान कै बैठे। ");
INSERT INTO thr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","कुछ फरीसी जौ देखीं और चेलन से पूँछीं, “तुमरो गुरुजी लगान बसूलन बारे पापी लोगन के संग खानु काहे खाथै?” ");
INSERT INTO thr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ईसु सुनी और जबाब दई, “जो आदमी अच्छे भले हैं उनकै बैध की जरूरत नाय होथै, लेकिन सिरफ उन्हईं कै जो बिमार हैं। ");
INSERT INTO thr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","लेकिन तुम लोग जाबौ और समझौ कि सास्त्र के जौ बचन को मतलब का है: कि ‘मैं जानवर को बलिदान नाय पर दया चाहथौं।’ मैं आदर के संग धर्मिन कै नाय बल्कि पापियन कै बुलान कै आओ हौं।” ");
INSERT INTO thr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","फिर बपतिस्मा देनबारे यूहन्ना के चेला के झोने आयकै पूँछीं, “ऐसो काहे है कि हम और फरीसी जद्धेतर बर्त रखथैं, पर तेरे चेला बर्त बिलकुल नाय करथैं?” ");
INSERT INTO thr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","फिर ईसु जबाब दई, “का बरैतिया, जब तक दुल्हा उनके संग है दुखी रह सकथैं? बिलकुल नाय! पर बौ दिन आगो कि दुल्हा उनसे अलग करो जागो, और बे दुखी होंगे बर्त रखंगे।” ");
INSERT INTO thr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“नये लत्ता को थिगरा पुराने थिगरा मैं कोई नाय लगाथै, काहैकि बौ थिगरा लत्ता से और कुछ खींच लेथै, और बौ जद्धे फट जाथै। ");
INSERT INTO thr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","और नई दाखरस पुराने मसकन मैं नाय भरथैं; काहैकि ऐसो करन से मसका फट जाथै, और दाखरस बहे जाथै और मसका खराब हुई जाथैं, पर नया दाखरस नये मसकन मैं भरथैं और बे दोनों बची रैहथैं।” ");
INSERT INTO thr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","जब ईसु कहतै रहै, एक यहूदि अधिकारी बाके झोने आओ, बाके अग्गु घूँटेन मैं झुककै बिनती करन लागो, “मेरी लौड़िया हबइ खतम भइ है; पर तैं आयकै अपनो हात बाके ऊपर धर, और बौ जिंदी ही जागी।” ");
INSERT INTO thr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","तभई ईसु उठकै बाके पच्छू गौ, और बाके चेला बाके संग हुई लईं। ");
INSERT INTO thr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","एक बईय्यर जोको बहारै साल से खून बहेत रहै, बाके पच्छू से आयकै बाके लत्ता के कुंछ कै छुइ लई। ");
INSERT INTO thr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","बौ खुद से बोलत रहै, “अगर मैं सिरफ बाके लत्ता कै छुइ लेंगो, तौ अच्छी हुई जांगो।” ");
INSERT INTO thr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ईसु मुड़ कै देखी और कही, “हिम्मत धर और खुसी मना मेरी लौड़िया! तेरो बिस्वास तोकै अच्छो करी है।” बहे समय बौ बईय्यर अच्छी हुई गई। ");
INSERT INTO thr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जब ईसु बौ अधिकारी के घरै पुगो तौ बौ देखी कि सोक धुन बुसली बजान बारो और हुँआँ हल्ला मचात भै लोग लौड़िया की मौत मैं सोक कर रै हैं, ");
INSERT INTO thr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तभई ईसु लोगन से कही, “दुआरे जाबौ, सब लोग! लौड़िया मरी नाय, पर सोए रइ है।” फिरौंकी जौ बात मैं बे सब बाको मजाक बनान लगे। ");
INSERT INTO thr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पर जैसिये लोगन कै दुआरे कर दौ गौ, ईसु लौड़िया के कमरा मैं गौ और बाको हात पकड़ी, और बौ उठ गई। ");
INSERT INTO thr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","और जौ बात की खबर पूरे देस मैं फैल गई। ");
INSERT INTO thr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जब ईसु हूँना से अग्गु बढ़ो, और जब बौ चलो, तौ दुई अंधरा बाके पच्छू जौ चिल्लात भै पीछा करन लगे, “ओ दाऊद के लौड़ा!” हमरे ऊपर दया कर। ");
INSERT INTO thr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जब ईसु घरै पुगो, तौ बे अंधरा बाके झोने आए, और बौ उनसे पूँछी, “का तुम बिस्वास करथौ कि मैं तुमकै अच्छो कर सकथौं?” बे जबाब दईं “हाँ प्रभु!” ");
INSERT INTO thr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तौ ईसु उनकी आँखी छुइ कै कही, “जैसो तुम बिस्वास करथौ बैसिये तुमरे ताहीं होबै!” ");
INSERT INTO thr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","और उनकी आँखी की नजर खुल गईं ईसु उनकै चितौनी देत भै कही, “चौकन्नो रहियो कोई जौ बात कै नाय जान पाबै!” ");
INSERT INTO thr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पर बे निकरकै पूरे देस मैं चारौ तरफ ईसु के सुसमाचार को ढिंढोरा पीट दईं। ");
INSERT INTO thr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जब बे बहार जात रहैं, तौ कुछ आदमी एक गूँगा कै जोके भीतर प्रेत आत्मा रहै ईसु के झोने लाईं। ");
INSERT INTO thr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","पर जैसिये प्रेत आत्मा निकरे, तौ गूँगा बोलन लगो और भीड़ चकित हुईकै चिल्लाई, “इस्राएल! मैं ऐसो कहु नाय देखन मैं आओ।” ");
INSERT INTO thr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पर फरीसी कहीं, “जौ तौ प्रेत आत्मा के मुखिया से प्रेत आत्मा कै निकारथै।” ");
INSERT INTO thr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ईसु यहूदि सभाघरन मैं उपदेस देतो, परमेस्वर के राज्य को सुसमाचार को प्रचार करतो, लोगन के रोग और हर तरह की बिमारिन से अच्छो करतो बौ गाँव-गाँव और नगर-नगर घूमत रहै। ");
INSERT INTO thr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जैसी ही बौ भीड़ कै देखी, बाको दिल उनके ताहीं दया से भरगौ, काहैकि बे लोग बैसिये ही सताए भै और बिन सहारा के रहैं जैसे बिना बरदिया के भेंड़। ");
INSERT INTO thr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तौ बौ अपने चेलन से कही, “फसल तौ भौत हैं पर मजदूरी करन बारे थोड़ी से हैं। ");
INSERT INTO thr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","तभई फसल के मालिक से बिनती करौ कि बौ अपने खेत मैं काम करन के ताहीं मजदूरी करन बारेन के भेज दियै।” ");
INSERT INTO thr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","फिरौंकी ईसु अपने बारह चेलन कै झोने बुलाएकै, उनकै असुद्ध आत्मा कै बाहर निकारन और सब बिमारिन कै ठीक करन को अधिकार दई। ");
INSERT INTO thr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","जे बारह प्रेरितन के नाओं हैं: पहलो सिमौन, जो पतरस कहो जाथै, और बाको भईय्या अन्द्रियास; जब्दी को लौड़ा याकूब और बाको भईय्या यूहन्ना; ");
INSERT INTO thr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस, बरतुल्मै, थोमा, और लगान लेन बारो मत्ती, हलफई को लौड़ा याकूब और तद्दै। ");
INSERT INTO thr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","सिमौन कनानी, और यहूदा इस्करियोती, जो ईसु कै पकड़बाई रहै। ");
INSERT INTO thr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","जे बारहन कै ईसु जौ निर्देस दैकै भेजी, “कोई भी गैर यहूदि के इलाका या कोई सामरी सहर मैं मत जाबौ। ");
INSERT INTO thr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","बल्कि इस्राएल के परिवार की खोई भइ भेंड़न के झोने जाबौ। ");
INSERT INTO thr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","और नेंगत-नेंगत प्रचार करकै कहबौ कि ‘स्वर्ग को राज्य झोने आए गौ है!’ ");
INSERT INTO thr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बिमारन कै अच्छो करौ; मरे भैन कै जिंदो करौ, कोहोढ़ बारेन कै सुद्ध करौ, प्रेत आत्मा कै निकारौ, तुम सेंत-मेंत मैं पाए हौ, बिना कुछ लिये मुफ्त मैं बाँटो। ");
INSERT INTO thr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","अपने बटुआ मैं ना तौ सोनो, चाँदी, और न तांबा के सिक्का कमरबंद मैं रखियो। ");
INSERT INTO thr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","रस्ता के ताहीं ना झोला, ना दुई जोड़ी कुरता, ना जूता और ना लठिया लियो, काहैकि मजदूर कै बाकी रोटी मिलनो चाहिए।” ");
INSERT INTO thr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“जो कोई नगर या गाँव मैं जाबौ तौ मालुम करौ कि हूँना कौन काबिल है? और जब तक हूँना से ना निकरौ, उन्हईं के हूँना रहबौ। ");
INSERT INTO thr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","जब तुम कोई के घर मैं जाबौ तौ परिवार के लोगन को आदर सत्कार करत भै कहबौ, ‘तुम्हैं सांति मिलै।’ ");
INSERT INTO thr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","अगर बौ घर के आदमी काबिल होंगे तौ तुम्हारी सांति उनके संग रहबैगी, और बे काबिल नाय होंगे तौ तुम्हारी सांति बापस लौट जाबैगी। ");
INSERT INTO thr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","और जो कोई तुमकै नाय अपनाबै, और तुमरी बात ना सुनै, बौ घर या बौ नगर से निकरत भै अपने टाँगन से धूदर झार डारौ। ");
INSERT INTO thr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मैं तुमसे सच कहथौं, कि जब न्याय होगो बौ दिन बौ देस की हालत सदोम और अमोरा के नगर की हालत से भी जद्धे सहन के काबिल होगी।” ");
INSERT INTO thr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“सुनौ! मैं तुमकै भेंड़न के हानी भेंड़ियन के बीच मैं भेजथौं तभई साँपन के हानी अकलदार और कबूतरन के हानी भोले बनौ। ");
INSERT INTO thr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","लोगन से सावधान रहियो काहैकि बे तुम्हैं बंधी बनाएकै यहूदि सभाघरन मैं सौंप देंगे, और बे तुम्हैं अपने यहूदि सभाघरन मैं कोड़ा से पिटबांगे। ");
INSERT INTO thr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तुम राजन और सासकन के अग्गु पेस करे जागे, काहैकि तुम मेरे अनुयायी हौ तुमकै मौका दियो जागो कि उनकी और गैर यहूदिन के बारे मैं गभाई देबौ। ");
INSERT INTO thr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जब बे तुमकै पकड़बांगे तौ जौ चिंता मत करियो, कि तुम कैसे बोलैगे और का कहबैगे; काहैकि जो कछु तुमकै कहने होगो, बौ बहे समय बताए दौ जागो। ");
INSERT INTO thr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","काहैकि बोलन बारे तुम नाय हौ पर तुमरे परम दऊवा की आत्मा तुमरे जरिया बोलैगी।” ");
INSERT INTO thr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“भईय्या अपने भईय्या कै पकड़वाए कै मरबाए डारंगे, अईय्या दऊवा अपने कै पकड़बांगे, और बालका अपने अईय्या दऊवा के खिलाप ही जांगे और बे उन्हैं मरबाए डारंगे। ");
INSERT INTO thr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मेरे नाओं के बजह से सब तुमसे बैर करंगे, पर जो अंत तक धीरज धरैगो बहे को उद्धार होगो। ");
INSERT INTO thr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जब बे तुमकै एक नगर मैं सतामै, तौ दुसरे नगर कै भाज जईयो। मैं तुमसे सच कहथौं, तुम इंसान के लौड़ा के आन से पहले इस्राएल के सब नगरन मैं से गै भी ना होगे इंसान को लौड़ा आए जागो।” ");
INSERT INTO thr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“कोई भी चेला अपने गुरु से बड़ो नाय होथै; कोई भी सेवक अपने स्वामी से बड़ो नाय होथै। ");
INSERT INTO thr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेला कै गुरु के बराबर होन मैं, और सेवक स्वामी के बराबर होन मैं ही संतोस करनो चाहिए। जब बे घर के स्वामी कै बालजबूल मतलब दुस्टआत्मा को अगुवा कहथैं तौ बाके घर के दुसरे लोगन संग और बुरो बर्ताव करंगे!” ");
INSERT INTO thr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“तौ लोगन से मत डरईयो, काहैकि जो कछु लुको भौ है, बाकै उजागर करो जागो, और सब चीजन को भेद बताओ जागो। ");
INSERT INTO thr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","मैं अंधियारे मैं जो कुछ कहथौं, बाकै तुम उजीते मैं कहबौ; और जो कानौ कान सुनथौ, बाकै छत के ऊपर से प्रचार करौ। ");
INSERT INTO thr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","जो सरीर कै मार सकथैं, पर आत्मा कै नाय मार सकथैं, उनसे मत डरौ; पर बहे से डराबौ, जो भीतरी आत्मा और सरीर दोनों कै नरक मैं खतम कर सकथै। ");
INSERT INTO thr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","का एक पैसा की दुई गौरैया नाय बेंची जाथै? तौभी तुमरे दऊवा की मरजी के बिना उनमैं से एक भी जमीन मैं नाय गिर सकथै। ");
INSERT INTO thr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","और तुमरे मूड़ के एक बार तक भी सब गिने भै हैं। ");
INSERT INTO thr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","तभई डराबौ मत; तुम निरे गौरैयन से बढ़कै कीमती हौ।” ");
INSERT INTO thr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जो कोई इंसान के सामने मोकै मान लेगो, बाकै महुँ अपने स्वर्गिय दऊवा के अग्गु मान लेंगो। ");
INSERT INTO thr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पर जो कोई इंसान के अग्गु मेरो इंकार करैगो बाकै महुँ अपने स्वर्गिय दऊवा के अग्गु इंकार करंगो।” ");
INSERT INTO thr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“जौ मत समझौ, कि मैं दुनिया मैं सांति लान के ताहीं आओ हौं। नाय, मैं सांति लान नाय आओ हौं, पर एक तलवार चलवान आओ हौं। ");
INSERT INTO thr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मैं जौ करन आओ हौं, बेटा अपने दऊवा के खिलाप मैं बेटी अपनी अईय्या के खिलाप और बहु अपनी सास के खिलाप मैं होंगी, ");
INSERT INTO thr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","इंसान के बैरी बाके घरै के लोग होंगे।” ");
INSERT INTO thr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जो अपने अईय्या या दऊवा कै मोसे जाधे प्यार करथै, बे मेरे चेला बनन के काबिल नाय हैं। और जो अपने लौड़ा या लौड़िया कै मोसे जाधे प्यार करथै, बे मेरे चेला बनन के काबिल नाय हैं। ");
INSERT INTO thr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","बौ जो राहगीर को अपनो क्रूस खुद उठाएकै मेरे पच्छू नाय हुई लेथै बौ मेरो चेला बनन के काबिल नाय है। ");
INSERT INTO thr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जो अपनी ज्यान बचाथै, बौ बाकै गबागो; पर जो मेरे बजह से अपनी ज्यान खोथै, बौ जिंदगी पाएगो।” ");
INSERT INTO thr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जो तुमकै अपनाथै, बौ मोकै अपनाथै; और जो मोकै अपनाथै, बौ परमेस्वर कै अपनाथै जो मोकै पनारी। ");
INSERT INTO thr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जो कोई भविस्यवक्ता कै तभई अपनाथै कि बौ भविस्यवक्ता है, बाकै बहे प्रतिफल मिलैगो जो भविस्यवक्ता कै मिलथै, और अगर कोई भले आदमी को तभईये स्वागत करथौ कि बौ भलो आदमी है बाकै सच मैं बहे प्रतिफल मिलैगो जो कोई धर्मी आदमी कै मिलनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","जो कोई जे छोटे मैं से एक कै चेला मानकै सिरफ एक गिलास ठंडो पानी पिबाबै, मैं तुमसे सच कहथौं, बाको प्रतिफल सच मैं मिलैगो।” ");
INSERT INTO thr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","जब ईसु अपने बारह चेलन कै निर्देस देन के बाद, ईसु हुँआँ से चल पड़ो और गलील परदेस के नगर मैं उपदेस देत घूमन लगो। ");
INSERT INTO thr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","यूहन्ना जब कैदखाना मैं ईसु मसीह के बारे मैं सुनी तौ बौ अपने चेलन कै बासे जौ पूँछन पनारी, ");
INSERT INTO thr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“का आनबारो तहीं है, या हम दुसरे को इंतजार करैं?” ");
INSERT INTO thr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ईसु जबाब दई, “जो कछु तुम सुनथौ और देखथौ, बौ सब जाएकै यूहन्ना से कह दियौ: ");
INSERT INTO thr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","कि अंधरन कै आँखी मिल रइ है, लंगड़ा चल फिर रै हैं, कोहढ़ी सुद्ध करे जाए रै हैं, और बैहरा सुन रै हैं, और मुर्दा जिंदे करे जाए रै हैं, और दीन दुखियन कै सुसमाचार सुनाते जाए रै हैं। ");
INSERT INTO thr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","और धन्य है बौ जो मेरे बजह से ठोकर ना खामैं।” ");
INSERT INTO thr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जब यूहन्ना के चेला हुँआँ से जात रहैं तौ ईसु यूहन्ना के बारे मैं लोगन से कही, “तुम लोग बन मैं का देखन आए हौ? का कोई सरकंडा जो ब्यार से हिल रहो है? ");
INSERT INTO thr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","तौ फिर तुम का देखन आए हौ? का एक आदमी जो भौत अच्छे लत्ता पहने है, देखौ जो अच्छे लत्ता पहनथैं बे राजमहल मैं ही पाए जाथैं। ");
INSERT INTO thr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","तौ फिर तुम का देखन आए हौ? का कोई भविस्यवक्ता कै देखन कै? हाँ, मैं तुमसे कहथौं, जोकै तुम देखे हौ बौ कोई भविस्यवक्ता से कहीं जाधा बड़ो है। ");
INSERT INTO thr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","जौ बहे है, जोके बारे मैं लिखो है, कि ‘देखौ, मैं अपने दूत कै तेरे अग्गु भेजथौं, जो तेरे अग्गु तेरो रस्ता बनाबैगो।’ ");
INSERT INTO thr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मैं तुमसे सच कहथौं, कि जो बईय्यर से जनमें हैं, उनमैं से यूहन्ना बपतिस्मा देनबारे से कोई बड़ो नाय भौ; पर जो स्वर्ग के राज्य मैं छोटो से छोटो इंसान भी बासे बड़ो है। ");
INSERT INTO thr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","बपतिस्मा देनबारे के यूहन्ना से आज तक स्वर्ग को राज्य भयानक आघातन कै झेलत आओ और हिंसा के बल पर जाकै छीनन की कोसिस कियो जाए रहो है। ");
INSERT INTO thr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","यूहन्ना के समय तक सबै भविस्यवक्ता और मूसा की नियम भविस्यवाँड़ी करी रहै; ");
INSERT INTO thr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","और अगर तुम उनके संदेसो मैं बिस्वास करन कै तैयार हौ, तौ यूहन्ना ही एलिय्याह है, जोके आन की भविस्यवाँड़ी करी गई रहै। ");
INSERT INTO thr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","फिरौंकी सुनौ, अगर तुमरे पास कान हैं!” ");
INSERT INTO thr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“अब, आज के पीढ़ी की तुलना मैं कौन से करौं? बे बजार मैं बैठे बालकन के हानी हैं। जो एक दुसरे से पुकारत भै कह रै हैं, ");
INSERT INTO thr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘हम तुमरे ताहीं बिहा मैं बुसली बजाय, पर तुम ना नाचे! हम आखरी संस्कार गीत गाये, पर तुम ना रोए!’ ");
INSERT INTO thr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","जब बपतिस्मा देन बारो यूहन्ना आओ, बौ बर्त रखी और कोई दाखरस नाय पी, और सब कहीं, कि ‘बामै प्रेत आत्मा है!’ ");
INSERT INTO thr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","फिरौंकी इंसान को लौड़ा आओ जो औरन के तराहनी खात-पीत है लेकिन लोग कहथैं, ‘जौ आदमी कै देखौ जौ पेटू और पिबक्कड़ है, जौ लगान बसूलन बारेन और पापियन को दोस्त है।’ लेकिन बुद्धि बाके काम से सई ठहरथै।” ");
INSERT INTO thr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","जो गाँव मैं ईसु अपने जद्धेतर चमत्कार करी रहै, बे आदमी अपने पापन से मन ना फिराईं, तभई बौ बे सहर की निंदा करी। ");
INSERT INTO thr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“हे खुराजीन जौ तुमरे ताहीं कित्तो भयानक है, हे बैतसैदा! तुमरे ताहीं कित्तो भयानक है, तुम्हारे जो चमत्कार करे गै अगर बहे चमत्कार सूर और सैदा मैं करे जाते तौ हूँना के लोग भौत पहले से ही टाट दुख के लत्ता ओढ़कै अपने सरीर मैं राख मलकै खेद करते और मन फिराए चुके होते। ");
INSERT INTO thr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","मैं तुम्हैं बिस्वास दिलाथौं कि न्याय के दिन परमेस्वर तुमसे जाधे सूर और सैदा के लोगन ऊपर दया करैगो। ");
INSERT INTO thr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","और हे कफरनहूम, का तैं स्वर्ग ले ऊँचो करो जागो? तैं तौ नरक ले नीचे जागो; काहैकि जो अचम्मे काम तेरे मैं करे गै हैं, अगर सदोम मैं करे जाते, तौ बौ सहर आज ले बनो रहतो! ");
INSERT INTO thr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पर मैं तुम्हैं बताथौं, कि न्याय के दिन तेरे लोगन की हालत सदोम देस के लोगन के हालात से जाधे बेकार होगी!” ");
INSERT INTO thr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","बहे समय ईसु कही, “हे दऊवा, स्वर्ग और पृथ्वी के प्रभु! मैं तेरो धन्यवाद करथौं, कि तैं जे बातन कै ग्यानियन और समझदारन से लुकाएकै रखो है, और जो भोले भाले हैं उनके ऊपर प्रकट करो। ");
INSERT INTO thr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हाँ, दऊवा, काहैकि तोकै जहे अच्छो लगो।” ");
INSERT INTO thr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“मेरो परमपिता मोकै सब कछु दई है। और कोई लौड़ा कै ना जानथै, सिरफ दऊवा; और कोई भी दऊवा कै नाय जानथै, सिरफ लौड़ा कै और जिन्हैं लौड़ा प्रकट करनो चाहथै।” ");
INSERT INTO thr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“हे थके मांदे बोझ से दबे लोग मेरे झोने आबौ; मैं तुम्हैं विसराम दुंगो। ");
INSERT INTO thr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मेरे जुआ उठाएकै अपने ऊपर लै लेबौ; और मोसे सीखौ; काहैकि मैं नम्र और मन को दीन हौं: और तुम विसराम पागे। ");
INSERT INTO thr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","काहैकि जोमैं तोकै दुंगो बौ आसान है, जुआ और मेरो बोझ हलको है।” ");
INSERT INTO thr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","बौ समय ईसु साबत के दिन खेतन से हुईकै जात रहै, और बाके चेलन कै भूंक लगी, और बे बाली तोड़-तोड़कै खान लगे। ");
INSERT INTO thr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","जब जौ सब फरीसी देखीं तौ बे ईसु से कहीं, “देख, तेरे चेलन कै साबत के दिन ऐसो करनो मूसा के नियम से सई नाय है!” ");
INSERT INTO thr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ईसु जबाब दई, “का तुम कभी ना पढ़े, कि दाऊद बौ समय का करी जब बौ और बाके संग के भूंके रहैं? ");
INSERT INTO thr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","बौ परमेस्वर के घर मैं गौ, और बाके संग के भेंट करी भइ रोटी खाईं, मूसा के नियम के खिलाप रहै, लेकिन बौ रोटी कै सिरफ पुजारी कै खान की अनुमति रहै। ");
INSERT INTO thr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","और का तुम मूसा के नियम मैं ना पढ़े, कि साबत के दिन मंदिर के पुजारी साबत की व्यवस्था को अपमान करथैं, तौभी बे दोसी नाय ठहरथैं? ");
INSERT INTO thr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","मैं तुम्हैं बताथौं कि कोई है जो मंदिर से भी महान है। ");
INSERT INTO thr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","सास्त्र कहथै, ‘मैं दया चाहथौं, पसु बलि नाय।’ अगर तुम सच मैं जानत रहौ कि जाको का मतलब है, तौ तुम बे लोगन की बुराई न करैगे जो दोसी हैं; ");
INSERT INTO thr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","काहैकि इंसान को लौड़ा साबत के दिन को भी प्रभु है।” ");
INSERT INTO thr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ईसु बौ जघा कै छोड़कै फिर यहूदि सभाघर मैं गौ। ");
INSERT INTO thr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","हूँना एक इंसान रहै, जोको हात फालिस को मारो रहै; हूँना कुछ लोग रहैं जो ईसु के ऊपर दोस लगानो चाहत रहैं, तौ बे बासे पूँछीं, “का साबत के दिन चंगो करनो मूसा के नियम के जरिया ठीक है?” ");
INSERT INTO thr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ईसु जबाब दई, “अगर तुम मैं से कोई झोने सौ भेंड़ होमैं, और बौ साबत के दिन एक गड्डा मैं गिर जाबै तौ का होगो, तौ बाकै पकड़कै दुआरे ना निकारैगे? ");
INSERT INTO thr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","फिर एक इंसान तौ एक भेंड़ से तौ कहीं जाधे कीमती है! तौ फिर, मूसा के नियम हमैं साबत के दिन कोई की भी मदत करन की अनुमति देथै।” ");
INSERT INTO thr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तब ईसु फालिस के मारे भै आदमी से कही, “अपनो हात बड़ा।” और बौ दुसरे जैसी फिर ठीक हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","तौ फरीसी बहार जाएकै ईसु के बिरोध मैं सलाह जोड़ीं, कि बाकै कैसे करकै मार डारैं? ");
INSERT INTO thr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","जब ईसु अपने खिलाप साजिस को समाचार सुनी, तौ ईसु बौ जघा से चले गौ; और बड़ी भीड़ बाके संग हुई लई। बौ सब बिमारन कै चंगो करी। ");
INSERT INTO thr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","और उन्हैं जाके बारे मैं दूसरेन कै न बतान की चितौनी दई। ");
INSERT INTO thr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","जौ बौ बचन कै पूरो करन कै ताहीं रहै जो यसायाह भविस्यवक्ता के जरिया कहो गौ रहै: ");
INSERT INTO thr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“जौ मेरो सेवक है, जोकै मैं चुनो हौं; मेरो प्रिय, और जोसे मेरो मन खुस है। मैं अपनी आत्मा बाके ऊपर भेजंगो; और बौ सब देस के सब गैर यहूदि के न्याय की घोसड़ाँ करैगो। ");
INSERT INTO thr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","बौ ना लड़ैगो, और नाय चिल्लागो; सड़क मैं बाकी अबाज कोई ना सुनैगो। ");
INSERT INTO thr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","बौ कुचले भै सरकंडा कै नाय तोड़ैगो; और न जलत भै दीया की लपट कै बुझागो। बौ तब तक बनो रैहगो जब तक कि बौ न्याय की जीत न हुई जाए। ");
INSERT INTO thr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","तौ फिर रास्ट्र के गैर यहूदि लोग बहे के नाओं के ऊपर अपनी आसा रखंगे।” ");
INSERT INTO thr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तब कुछ लोग ईसु के झोने एक ऐसे आदमी कै लै आए जो एक अंधरा रहै बात नाय कर पात रहै काहैकि बामै प्रेत आत्मा रहै। ईसु बाकै चंगो करी, और तभई बौ गूँगा देखन और बात करन लगो। ");
INSERT INTO thr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ईसु जो कुछ करी रहै, बासे सबै लोग चकित रहैं। “का जौ दाऊद को बालका हुई सकथै?” बे पूँछीं। ");
INSERT INTO thr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","जब फरीसी जौ सुनी, तौ बे जबाब दई “बौ प्रेत आत्मा कै सिरफ तभई निकार पाथै काहैकि उनको अधिकारी बालजबूल बाकै ऐसो करन की ताकत देथै।” ");
INSERT INTO thr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ईसु जानत रहै कि बे मन मैं का सोच रहै हैं, और तभई बौ उनसे कही, “जो राज्य मैं फूट पड़ जाथै तौ नास हुई जाथै बैसिये हर नगर या घर परिवार मैं जोमैं फूट पड़ जाबै बौ टिको नाय रह सकथै। ");
INSERT INTO thr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","तौ अगर एक समूह सैतान के राज्य मैं दुसरे से लड़ रहो है, तौ जाको मतलब है कि जौ पहले से ही समूह मैं बटो भौ है और जल्दी ही अलग हुई जागो। ");
INSERT INTO thr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","और अगर जौ सच है कि मैं बालजबूल के सहारे से प्रेत आत्मा कै बाहर निकारथौं तौ तुमरे अनुयायी कौनकी सहारे से उन्हैं बाहर निकारथैं? तौ तुमरे अनुयायी न्याय करंगे! ");
INSERT INTO thr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","लेकिन अगर प्रेत आत्मा कै मैं परमेस्वर की आत्मा की मदत से निकारथौं, तौ जासे जौ सिद्ध है कि परमेस्वर को राज्य तुमरे झोने आए पहोंचो है।” ");
INSERT INTO thr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“कोई किसी बलवन्त आदमी के घर मैं घुसकै बाको माल नाय लूट सकथै, जब तक कि बौ पहले बौ बलवन्त कै नाय भाँद लियै? और फिर बौ बाको घर लूट सकथै।” ");
INSERT INTO thr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जो मेरे पक्छ मैं नाय है, बौ मेरे बिरोध मैं है; और जो मेरे संग नाय बटोरथै, बौ बिखेरथै। ");
INSERT INTO thr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","तभई मैं तुम सच कहथौं, कि हर एक पाप निंदा माफ करो जागो, लेकिन जो कोई पवित्र आत्मा की बुराई करथै बाकै माफ ना करी जागी। ");
INSERT INTO thr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जो कोई इंसान के लौड़ा के खिलाप मैं कोई बात कहेगो, बाको अपराध माफ करो जागो, पर जो कोई पवित्र आत्मा के खिलाप मैं बुरी बात कहथै, बौ माफ नाय करी जागी। न जौ युग मैं और न आनबारे युग मैं।” ");
INSERT INTO thr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“अच्छो फल पान के ताहीं तुमरे झोने एक अच्छो पेंड़ होनो चाहिए; अगर तुमरे झोने खराब पेंड़ है, तौ तुमरे झोने खराब फल होंगे। काहैकि पेंड़ अपने फल से पहचानो जाथै। ");
INSERT INTO thr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","अरे साँप के बालकौ, जब तुम बुरे होत भै अच्छी बात कैसे कह सकथौ? काहैकि जो मन मैं भरो होथै, बहे मोहों से निकरथै। ");
INSERT INTO thr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","एक अच्छे इंसान के मन के भंडार मैं से अच्छाई इखट्टी है बहे मैं से अच्छी बात निकरथै, जबकी एक बुरो इंसान जो बुराई बाके मन मैं है बहे मैं से बुरी बात निकरथैं। ");
INSERT INTO thr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","लेकिन मैं तुमसे सच कहथौं, कि इंसान को न्याय के दिन अपनी हर एक बेकार निकम्मी बातन को लेखा देने होगो। ");
INSERT INTO thr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","काहैकि तैं अपनी बातन के बजह से निर्दोस और अपनी बातन के बजह से दोसी मानो जाबैगो।” ");
INSERT INTO thr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","तब व्यवस्था के कुछ यहूदि नियम के सिक्छक और फरीसी कहीं। “गुरुजी, हम तोसे एक चिन्ह चमत्कार देखनो चाहथैं।” ");
INSERT INTO thr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","बौ जबाब दई, “जौ युग के दुस्ट और व्यभिचार करन बारे लोग चिन्ह ढूँड़थै!” लेकिन योना भविस्यवक्ता के चिन्ह कै छोड़कै कोई और चिन्ह उनकै ना दौ जागो। ");
INSERT INTO thr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","जैसी करकै योना बड़ी मच्छी मैं तीन और तीन रात बिताई, बैसिये इंसान को लौड़ा तीन दिन और तीन रात धरती के भीतर की गहराई मैं बितागो। ");
INSERT INTO thr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","न्याय के दिन नीनवे के लोग ठाड़कै तुमरे ऊपर दोस लगांगे, काहैकि बे योना के उपदेस से अपनो मन फिराई रहैं, और अब हिंयाँ योना से भी बड़ो है! ");
INSERT INTO thr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","न्याय के दिन दक्खिन सेबा की रानी तुमरे ऊपर दोस लगाबैगी, काहैकि बौ राजा सुलैमान को ग्यान सुनन के ताहीं पृथ्वी के छोर से आई, और अब हिंयाँ तौ बौ सुलैमान से भी एक बड़ो है! ");
INSERT INTO thr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“जब कोई असुद्ध आत्मा कोई आदमी मैं से बाहर निकरथै, तौ बौ सूखी जघा मैं आराम की खोज मैं निकर जाथै। और बाकै नाय पाथै, ");
INSERT INTO thr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तौ फिर बौ कहथै, ‘मैं बहे घर मैं लौट जांगो जोमैं छोड़ो रहों।’ जब बौ आथै, तौ बौ घर कै खाली साफ सुथरो और सजो-सजाओ पाथै। ");
INSERT INTO thr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तब बौ निकरकै अपने से भी सात प्रेत आत्मा कै अपने संग लै आथै, और बे आयकै हूँनै रहथैं। और बौ इंसान की हालत पहले से भी बत्तर ही जाथै। आज की बुरी पीढ़ी के संग ऐसोई होगो।” ");
INSERT INTO thr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ईसु हबै भी लोगन से बात करत रहै, तौ बाकी अईय्या और भईय्या हूँना पहुँचे। बे बाहर ठाड़कै बासे बात करनो चाहत रहैं। ");
INSERT INTO thr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","कोई बासे कही, “देख तेरी अईय्या और तेरे भईय्या बाहर ठाड़े हैं, और तोसे बात करनो चाहथैं।” ");
INSERT INTO thr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ईसु जबाब दई, “मेरी अईय्या और भईय्या कौन हैं?” ");
INSERT INTO thr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","फिर बौ अपने चेलन के घाँईं इसारा करत भै कही, “देखौ! जे मेरी अईय्या और मेरी भईय्या हैं। ");
INSERT INTO thr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","काहैकि जो कोई मेरे स्वर्ग मैं दऊवा की इच्छा मैं चलथैं, बहे मेरो भईय्या और बहेनिया, और अईय्या हैं।” ");
INSERT INTO thr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","बहे दिन ईसु घर से निकरो और झील के किनारे चले गौ, जहाँ बौ उपदेस देन बैठो। ");
INSERT INTO thr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","बाके चारौ तरफ इत्ती भीड़ जुराए गई कि बौ नईंयाँ मैं चढ़कै बैठगौ, और सब लोग किनारे मैं ठाड़े रहैं। ");
INSERT INTO thr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","फिर बौ उन्हैं कहानी मैं भौत सी बात बताई, और कही: एक किसान बीज बोन निकरो। ");
INSERT INTO thr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","जब बौ बीज कै खेत मैं बिखेरी, तौ बाको कुछ भाग रस्ता के किनारे गिरे, और पक्छी आयकै उनकै खाए गै। ");
INSERT INTO thr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","बाको कुछ भाग पथरीली जमीन मैं गिरे, जहाँ थोड़ी सी मट्टी रहै। बीज जल्दिये ही अंकुरित ही गै, काहैकि मट्टी गहरी नाय रहै। ");
INSERT INTO thr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पर जब सूरज निकरो, बौ अंकुरित पौधन कै जलाए दई; काहैकि जड़ गहरी नाय रहैं, पौधा जल्दिये सूख गै। ");
INSERT INTO thr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कुछ बीज कटीली झाड़िन के बीच गिरे, जो बड़े भै और पौधन कै दबाय दई। ");
INSERT INTO thr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","पर कुछ बीज अच्छी जघा मैं गिरे, और फल लाईं, कोई सौ गुना, कोई साठ गुना, कोई तीस गुना। ");
INSERT INTO thr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","और ईसु हल निकारी, “सुनौ, जोके कान होमैं बौ सुन लियौ।” ");
INSERT INTO thr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","तब चेला ईसु के झोने आयकै बासे पूँछीं, “तैं लोगन से बात करत समय कहानियन को इस्तमाल करथैं?” ");
INSERT INTO thr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ईसु जबाब दई, “तुमकै स्वर्ग के राज्य के भेदन की समझ दई गई है, पर उनकै नाय। ");
INSERT INTO thr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","काहैकि जिनके झोने कुछ है, बाकै और जाधे दौ जागो; लेकिन जिनके झोने कुछ नाय हे, बौ बासे जो कुछ है बासे और बाके झोने है बौ भी लै लेगो। ");
INSERT INTO thr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","तभई मैं उनसे कहानियन मैं बात करथौं काहैकि बे देखथैं लेकिन बास्तव मैं उन्हैं कुछ दिखाई नाय देथै। और बे सुनथैं लेकिन बास्तव मैं उन्हैं सुनाई नाय देथै, और नाय समझथैं। ");
INSERT INTO thr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","तभई यसायाह की भविस्यवाँड़ी उन पर लागू होथै: ‘तुम सुनैगे और सुनतै रैहगे, पर तुम्हारी समझ मैं कुछ नाय आगो; तुम बस देखतै रैहगे, पर तुम्हारी समझ मैं कुछ न आगो, ");
INSERT INTO thr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","काहैकि उनको मन सुस्त है, और बे अपने कान कै बंद कर लईं हैं, और अपनी आँखी मूंद लईं हैं। ना तौ उनकी आँखी देखती, उनके कान सुनते, उनकी बुद्धि समझती, और बे मेरी तरफ फिरंगे, परमेस्वर जहे कहथै, और मैं उनकै चंगो करंगो।’” ");
INSERT INTO thr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“पर तुमरी आँखी और कान धन्य हैं, काहैकि बे देख और सुन सकथैं। मैं तुमसे सच कहथौं कि भौत से भविस्यवक्ता और परमेस्वर के भौत से लोग चाहत रहैं कि जो कुछ तुम देखथौ बाकै देखौ, पर बे नाय सुनत रहैं, और जो बातैं तुम सुनथौ, सुनौ, लेकिन बे नाय करीं। ");
INSERT INTO thr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","काहैकि मैं तुमसे सच-सच कहथौं, कि भौत से भविस्यवक्ता और धर्मी लोग जौ देखन की लालसा रखथैं कि तुम का देखथौ, लेकिन नाय देख पाथैं, और जो बात तुम सुनथौ, सुनकै, पर नाय सुनी।” ");
INSERT INTO thr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“तौ, सुनौ, और सीखौ कि बोन बारे की कहानी को मतलब का है। ");
INSERT INTO thr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जो लोग राज्य बारे संदेस सुनथैं, लेकिन जाकै नाय समझथैं, बे बीज जो रस्ता के किनारे गिरे भै रहैं बाको मतलब जौ है कि जब कोई राज्य के सुसमाचार सुनथै। और बाकै समझत नाय है तौ दुस्ट आयकै जो बाके मन मैं उगो रहै बौ उठाए लै जाथै। ");
INSERT INTO thr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","बे बीज जो पथरीली जमीन मैं गिरे रहैं उनको मतलब जौ है कि बौ आदमी जो संदेस सुनथै बाकै खुसी से तुरंत अपनाय लेथैं। ");
INSERT INTO thr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पर उनमैं कोईये जड़ नाय है, और तभई लम्बे समय तक नाय टिक पाथैं। तभई जब संदेस के बजह से परेसानी या दुख आथै, तौ बे तुरंतै हार मान लेथैं। ");
INSERT INTO thr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जो बीज कटीली झाड़िन मैं गिरे रहैं, बाको मतलब जौ है बौ आदमी जो सुभ संदेस सुनथै तौ युग की चिंताए और धन को लोभ सुभ संदेस कै दबाय देथै, और बौ आदमी फल न लाय पाथै। ");
INSERT INTO thr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","अच्छी जमीन मैं गिरे भै बीज को मतलब जौ है कि बौ आदमी जो सुभ संदेस कै सुनथै और समझथै बौ कामयाब होथै बौ सफलता से बोए बीज से तीस गुना, साठ गुना, या सौ गुना तक होथै।” ");
INSERT INTO thr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ईसु उनकै एक और कहानी सुनाई, “स्वर्ग को राज्य बौ इंसान के हानी है जो अपने खेत मैं अच्छो बीज बोई। ");
INSERT INTO thr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पर जब आदमी सोत रहैं, तौ बौ आदमी को दुस्मन आओ और गेंहूँ के बीच मैं जंगली पौधा के बीज बोई और चले गौ। ");
INSERT INTO thr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जब गेंहूँ मैं अंकुर निकरे और बामै बाली आई, तौ घाँस के जंगली पौधा भी दिखाई देन लगे। ");
INSERT INTO thr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","तब खेत के मालिक के सेवक बाके झोने आयकै कहीं, ‘मालिक, तैं तौ अच्छो बीज बौ रहै, फिर जंगली पौधा कहाँ से आए?’ ");
INSERT INTO thr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘तब मालिक उनसे कही, जौ कोई दुस्मन को काम है।’ सेवक बासे पूँछी, ‘का तैं चाहथै कि हम जाएकै जंगली पौधन कै उखाड़ फेकैं?’ ");
INSERT INTO thr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","बौ कही, ‘नाय,’ काहैकि जब तुम जंगली पौधन कै उखाड़ेगे तौ बाके संग गेंहूँ भी उखड़ सकथैं। ");
INSERT INTO thr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","कटनी तक गेंहूँ और जंगली पौधा दोनों कै एक संग बढ़न दे। तभई मैं फसल काटन बारेन से कहेंगो, कि जंगली पौधन कै हटाय दे, उन्हैं गट्ठा भाँदकै जलाए दे, और फिर गेंहूँ बटोरकै अपने कुठियन मैं रख दे।” ");
INSERT INTO thr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ईसु उनकै एक और कहानी सुनाई, “स्वर्ग को राज्य राया के छोटो बीज के तराहनी होथै, जोकै कोई लैकै खेत मैं बोई होबै। ");
INSERT INTO thr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","बौ सब बीजन मैं सबसे छोटो होथै, तौ सब बाग के पौधन से बढ़ो हुई जाथै। बौ पेंड़ बन जाथै, जामैं आसमान के पक्छी आयकै बाकी हँगईय्या मैं अपनो घोसला बनाथैं।” ");
INSERT INTO thr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ईसु एक और कहानी उनकै सुनाई, “स्वर्ग को राज्य खमीर के तराहनी है, जोकै कोई बईय्यर तीन बार चून मैं मिलाई और तब तक बाकै रख छोड़ी जब तक सबको सब खमीर नाय बन गौ।” ");
INSERT INTO thr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","जे सब बात भीड़ कै बतान के ताहीं ईसु कहानी को प्रयोग करी, बौ कहानी को उपयोग करे बिना कुछ नाय कहतो। ");
INSERT INTO thr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ऐसो जहेमारे रहै कि परमेस्वर भविस्यवक्ता के जरिया कहो गौ रहै, बौ पूरो होबै: परमेस्वर कही, मैं कहानी के जरिया अपनो मोहों खोलंगो; दुनिया के सुरुवात से जो बात छिपी रहीं हैं मैं उनकै उजागर करंगो। ");
INSERT INTO thr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","जब ईसु भीड़ कै छोड़कै घर के भीतर चले गौ, तौ बाके चेला बाके झोने आयकै कहन लगे, “हमैं कहानियाँ बता कि जंगली पौधन के बारेन को मतलब का है।” ");
INSERT INTO thr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ईसु जबाब दई, “जो अच्छो बीज बोई बौ इंसान को लौड़ा है। ");
INSERT INTO thr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","खेत दुनिया है; अच्छो बीज को मतलब है स्वर्ग के राज्य के लोग, और जंगली पौध के बीज को जौ मतलब है बे लोग जो दुस्ट सैतान की संतान हैं। ");
INSERT INTO thr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","और जंगली बीज बोन बारो बैरी सैतान है; और कटनी के समय जौ दुनिया को अंत है: और कटाई करन बारे मजदूर स्वर्गदूत हैं। ");
INSERT INTO thr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","जैसी जंगली पौधा आगी मैं इखट्टे हुईकै जल जाथैं, बैसिये दुनिया के अंत मैं ऐसो ही होगो। ");
INSERT INTO thr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","इंसान को लौड़ा अपने स्वर्गदूतन कै भेजकै, और बे बाके राज्य मैं से सब ठोकर के बजह के और अधर्मियन कै इखट्टो करैगो। ");
INSERT INTO thr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","और बौ उनकै धधकत भइ भट्टी मैं डार देगो, जहाँ बे रोमंगे और दाँत पीसंगे। ");
INSERT INTO thr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","बौ समय धर्मी लोग अपने दऊवा परमेस्वर के राज्य मैं सूरज के हानी चमकंगे। जोके कान हैं बौ सुन लियै।” ");
INSERT INTO thr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“स्वर्ग को राज्य ऐसो है। एक आदमी कै खेत मैं छिपो खजाना मिल जाथै। बौ बाकै फिर ढोंक देथै, और इत्तो खुस होथै कि बौ जाथै और अपनो सब कछु बेंच देथै, और बापस जाएकै बौ खेत कै खरीद लेथै।” ");
INSERT INTO thr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“फिर स्वर्ग को राज्य एक ब्यापारी के हानी है जो अच्छे मोती कै ढूँड़त रहै। ");
INSERT INTO thr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जब बाकै एक कीमती मोती मिलो तौ बौ जाएकै अपनो सब कछु बेंच डारी और बौ मोती कै खरीद लई।” ");
INSERT INTO thr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“फिर स्वर्ग को राज्य ऐसो है, कुछ मछरेया समुंदर मैं जार फेंक देथैं, और सब जैसी की मच्छिन कै समेट लेथैं। ");
INSERT INTO thr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","और जब जार भरगौ, तौ मछरेया किनारे खींच लाईं, और बैठकै मच्छी बाँटन के ताहीं बैठ जाथैं, जो अच्छी उन्हैं अपने बर्तन मैं भर लेथैं, और जो खराब हैं बे फेंक दई जाथैं। ");
INSERT INTO thr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","दुनिया के अंत मैं असोई होगो; स्वर्गदूत आयकै दुस्टन कै धर्मियन से अलग करंगे, ");
INSERT INTO thr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","और उनकै आगी की भट्टी मैं झोकंगे, हूँना रोनो और दाँत पीसनो होगो।” ");
INSERT INTO thr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“का तुम जे सब बात समझ गै?” ईसु उनसे पूँछी चेला जबाब दईं, “हाँ।” ");
INSERT INTO thr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","फिर ईसु अपने चेलन से कही, “तभई यहूदि नियम के सिक्छक जो परमेस्वर के स्वर्गिय राज्य कै जानथै बौ घर के मालिक के जैसे है जो अपनी भंडार की कुठरिया से नई और पुरानी चीजन कै बाहर निकारथै।” ");
INSERT INTO thr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जब ईसु जे सब कहानी कह चुको, तौ हूँना से बे चले गै। ");
INSERT INTO thr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","और अपने नगर मैं आयकै उनके यहूदि सभाघरन मैं ऐसो उपदेस देन लगो; कि बे अचम्मे हुईकै कहन लागे, “जाकै जौ ग्यान और सामर्थ्य के काम कहाँ से मिले? ");
INSERT INTO thr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","का जौ बहे बढ़ई को लौड़ा ना है? और का जाकी अईय्या को नाओं मरियम और जाके भईय्यन के नाओं याकूब, युसुफ, सिमौन और यहूदा ना हैं? ");
INSERT INTO thr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","और का जाकी सब बहेनिया हमरे बीच मैं ना रहथैं? फिर जाकै जौ सब कहाँ से मिलो?” ");
INSERT INTO thr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","और तभई बाकै नापसंद करथै। ईसु उनसे कही, “एक भविस्यवक्ता को सिरफ अपने गाँव और घर के अलावा हर जघा आदर करो जाथै।” ");
INSERT INTO thr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","और उनके अविस्वास के बजह से बौ हूँना जाधे अचम्मे काम नाय कर पाई। ");
INSERT INTO thr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","बौ समय गलील के सासक हेरोदस ईसु के बारे मैं सुनी। ");
INSERT INTO thr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“तौ बौ अपने सेवकन से कही जौ बपतिस्मा देन बारो यूहन्ना जो मरे भै मैं से जी उठो है, तभई बाके पास अचम्मे काम करन की सक्ति हैं।” ");
INSERT INTO thr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","काहैकि हेरोदस पहले यूहन्ना कै पकड़वान को आदेस दई रहै, और बौ बाकै भाँदकै कैदखाना मैं डरबाई रहै, जौ बौ हेरोदियास के कहने मैं करी रहै जो पहले बाके भईय्या फिलिप्पुस की बईय्यर रहै। ");
INSERT INTO thr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","हेरोदस यूहन्ना कै मार डारनो चाहत रहै, “कि बाकै रखनो तेरे ताहीं नियम के जरिया से ठीक नाय है!” ");
INSERT INTO thr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","हेरोदस यूहन्ना कै मार डारनो चहात रहै, लेकिन बौ यहूदि आदमिन से डरात रहै, काहैकि बे यूहन्ना कै भविस्यवक्ता मानत रहैं। ");
INSERT INTO thr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","हेरोदस के जनम दिन मैं हेरोदियास की लौड़िया पूरे हितुअन के सामने नाची। हेरोद इत्तो खुस भौ ");
INSERT INTO thr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","कि बौ बासे वादा करी, “मैं कसम खाथौं कि मैं सब कुछ दुंगो जो तू माँगैगी!” ");
INSERT INTO thr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","बाकी अईय्या के सिखाने मैं आयकै बासे कही, “मोकै एक थरिया मैं यूहन्ना बपतिस्मा देनबारे की मुड़िया मंगवाए दे!” ");
INSERT INTO thr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","तौ राजा भौत दुखी भौ, पर बौ अपने सब हितुअन के अग्गु जो वादा करी रहै, बाके बजह से आग्या दई कि बाकी इच्छा पूरी होबै। ");
INSERT INTO thr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","तभई बौ कैदखाना मैं यूहन्ना की मुड़िया कलम करबाय दई। ");
INSERT INTO thr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","फिर बाको मूड़ थरिया मैं लाओ गौ, और लौड़िया कै दै दौ गौ; और बौ बाकै अपनी अईय्या के झोने लै गई। ");
INSERT INTO thr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","तब यूहन्ना के चेला आए और बे बाके लास कै दफनाईं और जाएकै ईसु कै बताईं। ");
INSERT INTO thr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जब ईसु जौ सुनी, तौ नईंयाँ मैं चढ़कै हूँना से अकेलो कोई सुनसान जघा के, एकांत मैं चले गौ; और लोग जौ सुनकै नगर-नगर से पैदल बाके पच्छू हुई लईं। ");
INSERT INTO thr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ईसु जब बाहर नईंयाँ से निकरकै किनारे मैं आओ तौ बौ एक बड़ी भीड़ देखी, बाकै उनके ऊपर तरस आई और बौ उनकी बिमारिन कै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जब संजा भइ, तौ बाके चेला बाके झोने आयकै कहीं, “जौ तौ सुनसान जघा है और देर हुई रइ है, लोगन कै पनार देनो चहाईये कि बे गाँव मैं जाएकै अपने ताहीं खानु खरीदैं।” ");
INSERT INTO thr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","लेकिन ईसु उनसे कही, “इन्हैं कहीं जान की जरूरत ना है! तुम्हईं इन्हैं खान कै दियौ।” ");
INSERT INTO thr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","बे ईसु से कहीं, “हिंयाँ हमरे झोने पाँच रोटी और दुई मच्छी के अलावा और कुछ ना है।” ");
INSERT INTO thr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ईसु कही, “उनकै हींना मेरे झोने लाबौ।” ");
INSERT INTO thr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तौ बौ आदमिन कै घाँस मैं बैठन कै कही, और बे पाँच रोटियन कै और दुई मच्छियन कै लईं; और स्वर्ग के घाँईं देखकै आसीस माँगी और परमेस्वर कै धन्यवाद दईं और रोटियन कै तोड़-तोड़कै चेलन कै दई, और चेला बे टुकड़ा लोगन मैं बाँट दईं। ");
INSERT INTO thr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","और सब पेट भरकै खाईं बाके बाद बचे टुकड़न से बाके चेला बारह छपरिया भरीं। ");
INSERT INTO thr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","और खानबारी बईंय्यरैं और बालकन कै छोड़कै पाँच हजार लोग के लमसम रहैं। ");
INSERT INTO thr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","और ईसु तुरंतै अपने चेलन कै नईंयाँ मैं चढ़ाई, कि बे बासे पहले झील के बौ पाँजर चले जामैं, जबले कि बौ लोगन कै बिदा कर लेबै। ");
INSERT INTO thr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","बौ लोगन कै पनारकै, प्रार्थना करन कै अलग पहाड़ मैं चढ़गौ; और संजा कै बौ हूँना अकेलो रहै। ");
INSERT INTO thr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तब तक नईंयाँ जमीन के किनारे से काफी दूर जाए चुकी रहै और लहरन मैं लपेटा खाती डगमगात रहै, काहैकि ब्यार बाके खिलाप मैं चलत रहै। ");
INSERT INTO thr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","सुबेरे के लमसम तीन से छ: बजे के बीच ईसु पानी मैं नेंगत भौ आओ। ");
INSERT INTO thr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","चेला बाकै झील के ऊपर नेंगत भै देखकै घबराय गै, और कहेन लगे, “बौ भूत है,” डर के मारे चिल्लाए पड़े। ");
INSERT INTO thr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ईसु तुरंत उनसे बात करी, और कही, “हिम्मत रखौ, मैं हौं; डराबौ मत।” ");
INSERT INTO thr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस बाकै जबाब दई, “हे प्रभु, अगर तू ही है, तौ मोकै अपने झोने पानी मैं नेंग कै आन कै कह।” ");
INSERT INTO thr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ईसु कही, “आ!” तौ पतरस नईंयाँ मैं से उतरकै ईसु के झोने जान ताहीं पानी मैं नेंगन लगो। ");
INSERT INTO thr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पर जब तेज ब्यार कै देखी तौ डराय गौ, और जब डूबन लगो तौ चिल्लाए कै कही, “हे प्रभु, मोकै बचा।” ");
INSERT INTO thr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ईसु तुरंत हात बढ़ाये कै बाकै थाम लई, और बासे कही, “हे कम बिस्वास बारे, तैं काहे सन्देह करो?” ");
INSERT INTO thr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जब बे नईंयाँ मैं चढ़ गै तौ, तूफान रुक गौ। ");
INSERT INTO thr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","नईंयाँ के पार लोग ईसु की आराधना करीं और कहीं, “तू सच मैं परमेस्वर को लौड़ा है।” ");
INSERT INTO thr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","बे बौ पाँजर उतरकै गन्नेसरत तट की धरती मैं पुगे। ");
INSERT INTO thr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","और हूँना के रहन बारे ईसु कै पहचानी तौ बाके आन को समाचार आसपास के सब जघा मैं पनार दईं, जोसे लोग बिमार रहैं बे सबन कै हुँआँ लै आए। ");
INSERT INTO thr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","बासे नहोरे करन लगे कि बे उनकै अपने लत्ता के कुंछ कै छून दे ताकी बच सकैं; और जित्ते बाकै छुइं, बे अच्छे हुईगै। ");
INSERT INTO thr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","“जब कुछ फरीसी और यहूदि नियम के सिक्छक यरूसलेम से ईसु के झोने आए और बासे पूँछी, ");
INSERT INTO thr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ऐसो काहे है कि तेरे चेला हमरे पुरखन के जरिया दै गै रीति-रिवाजन कै टालथैं? खान से पहले बे अपने हातन कै नाय धोथैं!” ");
INSERT INTO thr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ईसु जबाब दई, “अपने रीति-रिवाजन की बजह से तुम परमेस्वर की आग्या कै काहे तोड़थौ? ");
INSERT INTO thr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","काहैकि परमेस्वर कही, ‘अपनी अईय्या और दऊवा को आदर करौ,’ और ‘अगर तुम अपने अईय्या या दऊवा कै बुरो भलो कहबैगे, तौ तुमकै सच मैं मार दौ जागो।’ ");
INSERT INTO thr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पर तुम कहथौ, कि अगर कोई अपनी अईय्या या दऊवा से कहबै, ‘काहैकि मैं अपनो सब कछु परमेस्वर कै दान कर चुको हौं, तभईये तुम्हारी सहायता नाय कर सकथौं।’ ");
INSERT INTO thr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ऐसिये बाकै अपने अईय्या और दऊवा को आदर करन की जरूरत नाय, जौ तरीका से तुम अपने रीति-रिवाजन की बजह से परमेस्वर की आग्या कै नकारत हौ। ");
INSERT INTO thr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","अरे! कपटियो, यसायाह तुमरे बारे मैं ठीकै भविस्यवाँड़ी करी रहै, बौ कही रहै: ");
INSERT INTO thr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘जे आदमी होटन से तौ मेरो आदर करथैं, पर उनको मन मोसे दूर रैहथै। ");
INSERT INTO thr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","मेरे ताहीं उनकी आराधना बेकार है, काहैकि बे आदमी के बनाए भै सिध्दांतन मैं है!’” ");
INSERT INTO thr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","और बौ आदमिन कै अपने झोने बुलाई और उनसे कही, “सुनौ, और समझौ! ");
INSERT INTO thr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जो मोहों मैं जाथै, बौ इंसान कै असुद्ध नाय करथै, पर जो मोहों से निकरथै, बहे इंसान कै असुद्ध करथै।” ");
INSERT INTO thr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तौ ईसु के चेला बाके झोने आए और बासे कहीं, “का तोकै पता है तेरी बात कै सुनकै फरीसियन कै बड़ा बुरो लगो है?” ");
INSERT INTO thr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","“बौ जबाब दई, सब पौधा जो मेरो स्वर्गिय दऊवा नाय लगाई, उनकै उखाड़ दौ जागो। ");
INSERT INTO thr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","उनकै जान दियौ; बे अंधी रहा दिखान बारे हैं और अगर एक अंधरा दुसरे अंधरा कै रहा दिखाबै, तौ दोनों गड्डा मैं गिरंगे।” ");
INSERT INTO thr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","जौ सुनकै पतरस बासे कही, “जौ कहानी हमैं समझाए दे।” ");
INSERT INTO thr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ईसु कही, “का तुम्हऊँ हबै ले ना समझे हौ? ");
INSERT INTO thr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","का तुम नाय समझथौ, कि जो कछु मोहों मैं जाथै, बौ पेट मैं जाथै, और सरीर से मल निकर जाथै? ");
INSERT INTO thr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पर जो कछु मोहों से निकरथै, बौ मन से निकरथै, और बहे इंसान कै असुद्ध करथै। ");
INSERT INTO thr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","काहैकि बुरे बिचार, मार डारनो, दुसरेन की बईय्यर कै अपनो बनानो, व्यभिचार, चोरी करनो, झूठी गभाई और बुराई सबै बुराई मनै से आथै। ");
INSERT INTO thr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","जेईं हैं जो इंसान कै असुद्ध करथैं, पर बिना हात धोए खानु खानो इंसान कै असुद्ध नाय करथै।” ");
INSERT INTO thr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ईसु बौ जघा कै छोड़कै सूर और सैदा सहर के घाँईं चल दई। ");
INSERT INTO thr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","और देखौ, बौ परदेस से एक कनानी बईय्यर निकरी, और चिल्लाए कै कहन लगी, “हे प्रभु! दाऊद की संतान, मेरे ऊपर दया कर, मेरी लौड़िया कै प्रेत आत्मा बुरी तरहन से पकड़े पड़े है।” ");
INSERT INTO thr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पर ईसु बाकै कछु जबाब ना दई, और चेला आयकै बासे नहोरे करकै कहीं, “जाकै पनार दे; काहैकि बौ हमरे पच्छू चिल्लात भई आए रई है।” ");
INSERT INTO thr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ईसु जबाब दई, “खाली इस्राएल के घराने की हरानी भइ भेंड़न कै छोड़कै मैं कोई के झोने नाय भेजो गौ हौं।” ");
INSERT INTO thr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","तौ बौ बईय्यर ईसु के अग्गु झुककै नहोरे करी, “हे प्रभु मेरी मदत कर।” ");
INSERT INTO thr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ईसु जबाब दई, “लौड़न की रोटी लैकै कुत्तन के अग्गु डारनो अच्छो नाय है।” ");
INSERT INTO thr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","बौ बोली, “सैंदे प्रभु, पर कुत्तौ बौ करकूना खाथैं, जो उनके स्वामियन की मेज से गिरथै।” ");
INSERT INTO thr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","जौ बात से ईसु बाकै जबाब दैकै कही, “हे बईय्यर, तेरो बिस्वास बड़ो है; जैसो तैं चाहथैं, तेरे ताहीं बैसोई होबै” और बाकी लौड़िया बहे समय अच्छी हुई गई। ");
INSERT INTO thr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ईसु हूँना से जाएकै, गलील की झील के झोने आओ, और पहाड़ मैं चढ़कै हूँना उपदेस देनकै बैठगौ। ");
INSERT INTO thr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","और खूब भीड़ बाके झोने आई, बे अपने संग लंगड़ा, अंधरा, गूँगा, टुन्डा और निरे बिमारन कै लैकै बाके झोने आए; और बे लोग उनकै बाकी टाँग मैं डार दईं, और ईसु उनकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जब आदमी देखीं, कि गूँगा बोलथैं और टुन्डा अच्छे होत भै और लंगड़ा नेंगत और अंधरा देखथैं, तौ जाकै अचम्मो मानकै इस्राएल के परमेस्वर की बड़ाँईं करीं। ");
INSERT INTO thr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","तौ ईसु अपने चेलन कै बुलाएकै कही, “मोकै जौ भीड़ के ऊपर तरस आथै; काहैकि बे तीन दिन से मेरे संग हैं और उनके झोने कछु खान कै ना है; और मैं उनकै भूंको पनारनो नाय चाहथौं; कहीं ऐसो नाय होबै कि थक हार कै रहामैं चक्कर आयकै गिर पड़ै।” ");
INSERT INTO thr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","चेला बासे कहीं, “हमकै जौ सूनी जघा मैं कहाँ से इत्ती रोटी मिलंगी कि हम इत्ती बड़ी भीड़ कै खानु खबाए सकैं?” ");
INSERT INTO thr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ईसु उनसे पूँछी, “तुमरे झोने कित्ती रोटी हैं?” बे कहीं, “सात और थोड़ी सी छोटी मच्छी है।” ");
INSERT INTO thr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तौ बौ भीड़ कै जमीन मैं बैठन कै कही। ");
INSERT INTO thr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","और बे सात रोटी और मच्छी कै लैकै बौ परमेस्वर को धन्यवाद करी। फिर बौ रोटी तोड़ी और अपने चेलन कै दई फिर बाके चेला आदमियन कै बाँट दई। ");
INSERT INTO thr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","और आदमी खाएकै तृप्त भै फिर बाके चेला बचे भै टुकड़न से भरे भै सात टोकरा उठाईं। ");
INSERT INTO thr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","और खान बारेन मैं बईंय्यरन और बालकन कै छोड़कै चार हजार इंसान रहैं। ");
INSERT INTO thr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तौ ईसु भीड़ कै पनारकै नईंयाँ मैं चढ़गौ, और मगदन की सीमा मैं चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","कुछ फरीसी और सदूकी ईसु के झोने आए बे बाकै परखनो चाहत रहैं, तौ बे बासे कोई स्वर्गिय चिन्ह चमत्कार करन कै कहीं, ताकी पता लग सकै कि बाकै परमेस्वर कि अनुमति मिली है। ");
INSERT INTO thr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ईसु उनकै जबाब दई, “दिन मुदथै तौ तुम कहथौ, कि मौसम अच्छो रैहगो, काहैकि आसमान लाल है। ");
INSERT INTO thr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","और दिन निकरथै तौ तुम कहथौ, कि आज आँधी आगी काहैकि आसमान लाल और धुंधरो है; तुम आसमान के लक्छड़ देखकै भेद जानथौ, पर अपने समय के चिन्ह लक्छड़न कै नाय पढ़ सकथौ? ");
INSERT INTO thr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","बुरे और व्यभिचार करन बारी पीढ़ी के आदमी कोई चिन्ह देखनो चाहथै, पर उनकै योना के चिन्ह कै छोड़कै और कोई चिन्ह ना दौ जागो।” और बौ उनकै छोड़कै चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","और चेला झील के बौ पाँजर जात पोती रोटी लेनो भूल गै रहैं। ");
INSERT INTO thr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","तौ ईसु उनसे कही, “देखौ, फरीसियन और सदूकियन के खमीर से बचे रहियो।” ");
INSERT INTO thr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","बे आपस मैं सोच-बिचार करत भै बोलीं, “हुई सकथै बौ जहे ताहीं कही काहैकि हम कोई रोटी संग नाय लाए।” ");
INSERT INTO thr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","बे का सोच रै हैं जौ जानकै, ईसु उनसे कहीं, “ओ कम बिस्वास बारेयौ, तुम आपस मैं काहे बतकाथौ कि हमरे झोने रोटी नाय हैं? ");
INSERT INTO thr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","का तुम अब नाय समझे? और बे पाँच हजार की पाँच रोटी याद नाय करथौ, और ना जहो कि कितनी छपरिया उठाए रहौ? ");
INSERT INTO thr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","और का तुमकै याद नाय बे चार हजार के ताहीं सात रोटी, और फिर कितनी टोकरी भरकै तुम जमा करे रहौ? ");
INSERT INTO thr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तुम काहे ना समझथौ कि मैं तुमसे रोटिन के बारे मैं नाय कहो? पर फरीसियन और सदूकियन के खमीर से बचन कै कहो।” ");
INSERT INTO thr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तौ चेलन कै समझ मैं आओ, कि बौ रोटी के खमीर से नाय, पर फरीसियन और सदूकियन की सिक्छा से बचे रहन कै कहेत रहै। ");
INSERT INTO thr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","जब ईसु कैसरिया फिलिप्पी के परदेस मैं आओ और अपने चेलन से पूँछन लगो, “आदमी इंसान के लौड़ा कै का कहथैं?” ");
INSERT INTO thr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","बे कहीं, “कुछ तौ कहथै तू यूहन्ना बपतिस्मा देन बारो है और दूसरे कहथै कि तू एलिय्याह है और एक काद आदमी कहथै कि तू यिर्मयाह या भविस्यवक्तन मैं से कोई एक है।” ");
INSERT INTO thr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ईसु जबाब मैं उनसे कही, “हे यूहन्ना के लौड़ा सिमौन तू धन्य है काहैकि तोकै जे बात कोई इंसान नाय बल्कि स्वर्ग मैं रहेन बारो मेरो परम पिता दिखाई है?” ");
INSERT INTO thr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","सिमौन पतरस जबाब दई, “तैं जिंदे परमेस्वर को लौड़ा मसीह है।” ");
INSERT INTO thr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ईसु बाकै जबाब दई, “हे सिमौन, योना के लौड़ा, तैं धन्य है, काहैकि मास और खून नाय, पर मेरो दऊवा स्वर्ग मैं है, जौ बात तेरे ऊपर दिखाई है। ");
INSERT INTO thr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","और महुँ तोसे कहथौं, कि तैं पतरस है, और मैं जहे चट्टान मैं कलीसिया बनांगो, और नरक की सक्ति बाके ऊपर परबल ना होगी। ");
INSERT INTO thr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मैं तोकै स्वर्ग के राज्य की चाबी दुंगो: ताकी जो कछु तैं पृथ्वी मैं भाँदैगो, बौ स्वर्ग मैं भंदैगो; और जो कछु तैं पृथ्वी मैं खोलैगो, बौ स्वर्ग मैं खुलैगो।” ");
INSERT INTO thr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तौ बौ चेलन कै चितौनी दई, “कोई से मत कहियो कि मैं मसीह हौं।” ");
INSERT INTO thr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","बौ समय ईसु चेलन कै बतान लगो, “मोकै जरूरी है, कि यरूसलेम जामौं और यहूदि नियम के सिक्छक, बड़े-बूढ़े यहूदि नेतन और प्रमुख पुजारियन के जरिये बड़ा दुख उठामौं; और मार डारो जामौं; फिर तिसरे दिन जी उठौं।” ");
INSERT INTO thr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","जौ बात मैं पतरस बाकै अलग्याँओं लै जाएकै झुकान लगो, “हे प्रभु, परमेस्वर ना करै! तेरे संग ऐसो कहु ना होगो।” ");
INSERT INTO thr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ईसु मुड़ कै पतरस से कही, “सैतान, मेरे अग्गु से दूर हुई जा! तैं मेरे ताहीं ठोकर को बजह है; काहैकि तैं परमेस्वर के तराहनी नाय, इंसानन के तराहनी सोचरौ है।” ");
INSERT INTO thr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तौ ईसु अपने चेलन से कही, “अगर कोई मेरे पच्छू आनो चाहबै, तौ अपने आपकै इंकार करै और अपनो क्रूस उठाबै, और मेरे पच्छू हुई लेबै। ");
INSERT INTO thr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","काहैकि जो कोई अपनी ज्यान बचानो चाहगो, बौ बाकै गबागो; और जो कोई मेरे ताहीं अपनी ज्यान गबागो, बौ बाकै पायगो। ");
INSERT INTO thr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","अगर इंसान पूरी दुनिया कै पाय लियै, और अपनी ज्यान की हानी उठाबै, तौ बाकै का फायदा? या इंसान अपनी ज्यान पान के बदले मैं का देगो? ");
INSERT INTO thr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","इंसान को लौड़ा अपने स्वर्गदूत के संग अपने दऊवा की महिमा मैं आगो, और बौ समय ‘बौ सबन कै उनके कामन के हिसाब से फल देगो।’ ");
INSERT INTO thr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मैं तुमसे सच कहथौं, कि जो हींना ठाड़े हैं, उनमैं से कित्ते ऐसे हैं, कि जबले इंसान के लौड़ा कै बाके राज्य समेत आत भै नाय देखलेमैं, तौले मौत को स्वाद कहु नाय चखंगे।” ");
INSERT INTO thr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छै दिन बाद ईसु पतरस और याकूब और बाके भईय्या यूहन्ना कै संग लई, उनकै एकांत मैं कोई ऊँचे पहाड़ मैं लैगौ। ");
INSERT INTO thr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","और हूँना उनके अग्गु बाको रूप बदल गौ बाको मोहों सूरज के हानी चमकन लगो और बाके लत्ता उजीते के हानी उजले हुईगै। ");
INSERT INTO thr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","तभई मूसा और एलिय्याह ईसु के संग बतकात भै चेलन कै दिखाई दईं। ");
INSERT INTO thr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","तौ पतरस ईसु से कही, “प्रभु, हमरे हींना रहनो अच्छो है; अगर तेरी इच्छा होबै तौ मैं हींना तम्बु बनामौं; एक तेरे ताहीं, एक मूसा ताहीं, और एक एलिय्याह के ताहीं।” ");
INSERT INTO thr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","बौ बोलतै रहै, कि एक उजलो बादर बाकै ढोंक लई, और बौ बादर मैं से जौ अबाज निकरी, “जौ मेरो प्रिय लौड़ा है, जासे मैं खुस हौं: जाकी सुनौ।” ");
INSERT INTO thr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","चेला जौ सुनकै मोहों के बल गिर गै और बड़ा डराय गै। ");
INSERT INTO thr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","पर ईसु झोने आयकै उनकै छुइ, और कही, “उठौ, डराबौ मत्ती।” ");
INSERT INTO thr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तौ बे अपनी आँखी उठाएकै ईसु कै छोड़ और कोई कै ना देखीं। ");
INSERT INTO thr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जब बे पहाड़ से उतरत रहैं तौ ईसु उनकै आग्या दई, “जबले इंसान को लौड़ा मरे भैन मैं से जिंदो ना हुई जागो, तौले जो कछु तुम देखे हौ कोई से मत कहियो।” ");
INSERT INTO thr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","और बाके चेला बासे पूँछी, “तौ यहूदि नियम के सिक्छक काहे कहथैं, कि एलिय्याह को पहले आनो जरूरी है?” ");
INSERT INTO thr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ईसु जबाब दई, “एलिय्याह तौ जरूर आगो और सब कछु सुधारैगो। ");
INSERT INTO thr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","लेकिन मैं तुमसे कहथौं, कि एलिय्याह आए चुको है; और बे बाकै नाय पैहचानीं; पर जैसो चाँहीं बैसोई बाके संग करीं। जहे बजह से इंसान को लौड़ा भी उनके हात से दुख उठाबैगो।” ");
INSERT INTO thr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तौ चेला समझीं कि बौ हमसे यूहन्ना बपतिस्मा देनबारे के बारे मैं कही रहै। ");
INSERT INTO thr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","जब बे भीड़ झोने पुगे, तौ एक इंसान ईसु के झोने आओ, और घुपटियाय कै कहेन लागो। ");
INSERT INTO thr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“प्रभु मेरे लौड़ा ऊपर दया कर! काहैकि बाकै मिर्गी आथै, और बौ भौत दुख उठाथै; और बार-बार आगी, पानी मैं गिर पड़थै। ");
INSERT INTO thr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","और मैं बाकै तेरे चेलन के झोने लाओ रहौं, पर बे बाकै अच्छो नाय कर पाईं।” ");
INSERT INTO thr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ईसु जबाब दई, “अरे अविस्वासियौ और हठीले आदमियौं, मैं कबले तुमरे संग रहांगो? कबले तुमरी सहमंगो? बाकै मेरे झोने लाबौ।” ");
INSERT INTO thr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तौ ईसु प्रेत आत्मा कै झुकाएकै आग्या दई और बौ बाके अंदर से निकर गौ, और बालका बहे समय अच्छो हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","तौ चेला एकांत मैं ईसु से आए कै कहीं, “हम जाकै काहे ना निकार पाए?” ");
INSERT INTO thr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ईसु जबाब दई, “तुमरे बिस्वास की कमताई के बजह: काहैकि मैं तुमसे सच कहथौं, अगर तुमरो बिस्वास राया के दाने के बीज के बराबर भी होतो, तौ जौ पहाड़ से कहते, ‘तौ हींना से खिसक्कै हूँना चलो जा,’ तौ बौ चलो जातो और कोई बात तुमरे ताहीं असम्भव नाय होगी। ");
INSERT INTO thr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पर जौ तरहन से कि दुस्टात्मन कै बिना प्रार्थना और उपवास के नाय निकार सकथै!” पर सिरफ प्रार्थना और उपवास के जरिये ही निकार सकथै। ");
INSERT INTO thr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जब ईसु के चेला आए और बाके संग गलील मैं मिले, तौ ईसु बासे कही, “इंसान को लौड़ा इंसान के हात मैं पकड़बाओ जागो। ");
INSERT INTO thr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","और बे बाकै मार डारंगे, फिर बौ तिसरे दिन जिंदो हुई जागो।” जौ बात मैं चेला भौत उदास भै। ");
INSERT INTO thr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जब ईसु और बाके चेला कफरनहूम मैं आए, तौ मंदिर के ताहीं कर लेन बारे पतरस के झोने आए कै पूँछीं, “का तुमरो गुरुजी मंदिर को कर नाय देथै?” ");
INSERT INTO thr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","पतरस जबाब दई, “हाँ, देथै।” जब बौ घरै आओ, तौ ईसु बाके पूँछन से पहले बासे कही, “सिमौन तैं का समझथै? पृथ्वी के राजा लगान या कर कौन से बसूलथैं? अपने लौड़न से या परायन से?” ");
INSERT INTO thr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरस जबाब दई, “परायन से।” ईसु बासे कही, “तौ लौड़ा बच गै। ");
INSERT INTO thr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","पर हम उन आदमिन कै गुस्सा नाय करैं तभईये तैं झील मैं जा अपनो मच्छी पकड़नबारी बन्छी और फिर जो मच्छी पहले पकड़ मैं आबै बाको मोहों खोलिये, तोकै जितनी जरुरत है उतने सिक्का तोकै मिलैगो बाकै लैकै मेरे और अपने ताहीं उनकै दैदे।” ");
INSERT INTO thr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","बहे समय चेला ईसु के झोने आयकै पूँछन लगे, “स्वर्ग के राज्य मैं बड़ो कौन है?” ");
INSERT INTO thr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","तभई ईसु एक बालका कै झोने बुलाएकै उनके बीच खड़ो करकै कही, ");
INSERT INTO thr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“मैं तुमसे सच कहथौं, और तुम मन ना बदले और बालकन के हानी नाय बने, तौ स्वर्ग के राज्य मैं घुस ना पाबैगे। ");
INSERT INTO thr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जो कोई अपने आपकै जौ बालका के हानी नम्र रहगो, बौ स्वर्ग के राज्य मैं बड़ो होगो। ");
INSERT INTO thr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","और जो कोई मेरे नाओं से एक ऐसे बालका कै अपनाथै बौ मोकै अपनाथै।” ");
INSERT INTO thr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“पर जोमैं मैं बिस्वास करन बारे कोई ऐसे छोटे अनुयायी के रस्ता मैं बाधा बनथै, अच्छो होबै कि बाकी गरजन मैं चक्की को पथरा लटकाए कै बाकै समुंदर मैं गहरोरी मैं डुबाय दौ जाबै। ");
INSERT INTO thr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","भयानक बाँधन की बजह से मोकै दुनिया के आदमिन पर तरस है पर बाधाएँ तौ आमंगी पर हाय तौ मोकै बाके ऊपर है जोके बजह से बाधा आथै।” ");
INSERT INTO thr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“अगर तेरो हात या तेरी टाँग तोकै बाधा डारै, तौ काटकै फेंक दे; काहैकि स्वर्ग मैं बिना हात या टाँग के अनंत जिंदगी मैं घुसनों तेरे ताहीं जाधे अच्छो है बजाय जाके कि दोनों हात और दोनों टाँग सुंदा तोकै अनंत आगी मैं डार दौ जाबै। ");
INSERT INTO thr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","काहैकि स्वर्ग मैं एक आँखी के होत भै अनंत जिंदगी मैं प्रवेस करनो तेरे ताहीं जाधे अच्छो है, बजाय जाके कि दोनों आँखी सुंदा खोन को तोकै नरक की आगी मैं डारो जाबै।” ");
INSERT INTO thr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“देखौ, मेरे जे मासूम अनुयायी मैं से कोई कै तुच्छ मत समझियो; काहैकि मैं तुमकै बताथौं उनके रक्छक स्वर्गदूतन की पौहौंच स्वर्ग मैं मेरे परम दऊवा के झोने हमेसा रहथै। ");
INSERT INTO thr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","काहैकि इंसान को लौड़ा हराने भै कै बचान आओ है।” ");
INSERT INTO thr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“तुम का समझथौ? अगर कोई इंसान की सौ भेंड़ होमैं, और उनमैं से एक हराए जाबै, तौ का निन्यानवे कै छोड़कै, और पहाड़न मैं जाएकै, बौ हरानी भइ कै ना ढूँड़ैगे? ");
INSERT INTO thr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","बौ सच्ची को जाबैगो, और जब बाकै मिल जागी, मैं तुमसे सच्ची कहथौं, कि बौ बे निन्यानवे भेंड़न के ताहीं जो हराई नाय रहैं भौत खुस नाय होगो, जित्तो की हरानी भइ भेंड़ के ताहीं होगो। ");
INSERT INTO thr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ऐसोई तुमरे परम दऊवा की जो स्वर्ग मैं है जौ इच्छा ना है, कि जे छोटे मैं से एक भी ना भटकै।” ");
INSERT INTO thr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“अगर तेरो भईय्या तेरे बिरोध मैं पाप करै, तौ जा और अकेले मैं जाएकै बाकै समझा; अगर बौ तेरी सुनै तौ तैं अपने भईय्या कै जीत लेगो। ");
INSERT INTO thr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","और अगर बौ नाय सुनै, तौ और एक दुई जनी कै अपने संग लै कै जा, कि हर एक बात के ताहीं दुई, तीन गभा ही सकै। ");
INSERT INTO thr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","अगर बौ उन्हऊँ कि ना मानै, तौ कलीसिया से कहदे, पर अगर बौ कलीसिया की भी ना मानै, तौ फिर तू बासे ऐसो व्यवहार कर जैसे बौ गैर यहूदि होबै या लगान बसूलन बारो होबै।” ");
INSERT INTO thr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“मैं तुमसे सच कहथौं, जो कछु तुम पृथ्वी मैं भाँदैगे, बौ स्वर्ग मैं भंदैगो और जो कछु तुम पृथ्वी मैं खोलैगे, बौ स्वर्ग मैं खुलैगो। ");
INSERT INTO thr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","फिरौंकी मैं तुमसे सच मैं कहथौं, अगर तुम मैं से दुई जनी पृथ्वी मैं कोई बात के ताहीं जोकै बे माँगैं, एक मन के होमैं, तौ बौ मेरे परम दऊवा के घाँईं से जो स्वर्ग मैं है उनके ताहीं हुई जागी। ");
INSERT INTO thr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","काहैकि जहाँ दुई या तीन मेरे नाओं से जुरांगे हूँना मैं उनके बीच मैं होथौं।” ");
INSERT INTO thr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तौ फिर पतरस ईसु के झोने आयकै कही, “प्रभु, अगर मेरो भईय्या पाप करथै, तौ मैं कित्ती बार बाकै माफ करौं, का सात बार ले?” ");
INSERT INTO thr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ईसु जबाब दई, “मैं तोसे जौ नाय कहथौं, कि खाली सात बार, बल्किन सात बार के सत्तर गुना ले माफ करीये। ");
INSERT INTO thr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","तभई स्वर्ग के राज्य कि बराबरी बौ राजा से करी जाए सकथै, जो अपने सेवकन से हिसाब चुकता करन की सोची। ");
INSERT INTO thr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जब बौ लेखा लेन लगो, तौ एक जनी बाके सामने लाओ गौ जो दस हजार तोड़ा को कर्जदार रहै। ");
INSERT INTO thr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","जब कि चुकान कै बाके पास कछु ना रहै, तौ बाको मालिक कही, कि जौ और जाकी बईय्यर और बाल-बच्चे और जो कछु जाको है सब बेचो जाबै, और बौ कर्जा चुकाए दौ जाबै। ");
INSERT INTO thr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","तौ बौ दास बाके पाँव मैं झुककै गिर गिड़गिड़ान लगो, ‘धीरज धरौ मैं सब कछु चुकाए दूँगो।’ ");
INSERT INTO thr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तौ बौ दास को मालिक तरस खाएकै बाकै छोड़ दई, और बाको कर्जा माफ करी।” ");
INSERT INTO thr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“फिर जब बौ सेवक हुँआँ से जात रहै, तौ बाकै बाको साथी सेवक मिलो, जोकै बासे कुछ पैसा लेने रहै, बौ बाको गिल्चुआ पकड़ लई और बाको गला दबात भइ बोलो जो तोकै मेरो देने है बाकै लौटाय दे। ");
INSERT INTO thr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","जौ बात मैं बाको संग बारो दास बाके पाओ मैं गिर पड़ो और नहोरे करत भै कहेन लगो, ‘धीरज धर मैं चुकाए दुंगो।’ ");
INSERT INTO thr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","पर बौ ना मानो, जाएकै बाकै कैदखाना मैं डरबाए दई; कि जबले कर्जा ना भरै तौले हूँनै रैहबै। ");
INSERT INTO thr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","जहे मैं दुसरे दास जौ सारी घटना कै देखकै बड़ा दुखी भै और हूँना जो कछु भौ रहै बे जाएकै अपने मालिक कै बताईं। ");
INSERT INTO thr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तौ बाको मालिक बाकै बुलाएकै बासे कही, ‘दुस्ट दास, तैं जो मोसे नहोरे करो, तौ मैं तेरो पूरो कर्जा माफ करो। ");
INSERT INTO thr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","तभईये जैसी मैं तेरे ऊपर दया करो, बैसिये का तहूँ कै अपने संग बारे दास कै माफ ना करनो चहाईये रहै?’ ");
INSERT INTO thr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","और बाको मालिक गुस्सा मैं आयकै बाकै सजा देन बारेन के हातन मैं सौंप दई, कि जबले बौ सब कर्जा भर ना दियै, तौले उनके हात मैं रहबै।” ");
INSERT INTO thr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","और ईसु जे बातन कै खतम करत भै कही, “जबले अपने भाई बन्धुअन कै अपने मन से माफ नाय कर दियौ मेरो स्वर्गिय दऊवा भी तुमरे संग ऐसिये व्यवहार करैगो।” ");
INSERT INTO thr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","जब ईसु जे बातन कै कहेन के बाद, बौ गलील से लौटकै यहूदिया के छेत्र मैं यरदन नदिया के पार चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","और बड़ी भीड़ बाके पच्छू हुई लई, और बौ हूँना उनकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","बाकै परखन ताहीं कुछ फरीसी बाके झोने आए और बोले, “का जौ सई है कि कोई भी अपनी बईय्यर कै नियम के जरिया से तलाक दै सकथै?” ");
INSERT INTO thr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ईसु जबाब दई, “का तुम ना पढ़े, कि दुनिया कै बनानबारो सुरुए मैं एक आदमी और बईय्यर के रूप मैं रची रहै? ");
INSERT INTO thr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","और कही रहै ‘जौ बजह से इंसान अपने अईय्या-दऊवा कै छोड़कै आदमी अपनी बईय्यर के संग दुई होत भै भी एक सरीर हीकै रहेंगे।’ ");
INSERT INTO thr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","तभई बे अब दुई नाय, पर एक तन हैं जोकै परमेस्वर जोड़ी है, बाकै इंसान अलग ना करै।” ");
INSERT INTO thr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","बे बोले, “फिर मूसा आग्या देत भै जाकै काहे निर्धारित करी है कि कोई आदमी अपनी बईय्यर कै व्यवस्था की किताब के अनुसार तलाक दै सकथै, सर्त जौ है कि बौ बाकै तलाकनामा लिखकै देबै?” ");
INSERT INTO thr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ईसु जबाब दई, “मूसा तुमरे मन के कर्‌रेपन के बजह से तुमकै अपनी बईय्यर कै छोड़न कै कही रहै, पर पहले ऐसो नाय रहैं। ");
INSERT INTO thr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","मैं तुमसे कहथौं, कि जो कोई छिनरइ कै छोड़ और कोई बजह से अपनी बईय्यर कै छोड़कै दुसरी से बिहा करै, बौ छिनरइ करथै।” ");
INSERT INTO thr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेला बासे कहीं, “अगर आदमी को बईय्यर के संग ऐसो संबंध है, तौ बिहा करनो अच्छो नाय है।” ");
INSERT INTO thr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","फिर ईसु उनसे कही, “हर कोई तौ जौ उपदेस कै नाय अपनाय सकथै। जाकै सब बे ही अपनाय सकथै जिनकै जाकी छमता दई गई है। ");
INSERT INTO thr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","काहैकि कुछ नपुंसक ऐसे हैं जो अईय्या के गरब से ऐसे पैदा भै; जो स्वर्ग के राज्य ताहीं अपने आप नपुंसक बनाई है, और आखरी मैं कुछ ऐसे है जो स्वर्ग के राज कि बजह से बिहा नाय करन को निस्चय करीं है जो जौ उपदेस कै अपनाय सकथै अपनाबै।” ");
INSERT INTO thr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तौ कुछ आदमी बालकन कै ईसु के झोने लाईं, कि ईसु उनके ऊपर हात धरकै आर्सिवाद देबै और प्रार्थना करै; पर चेला उनकै झुकाईं। ");
INSERT INTO thr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ईसु कही, “बालकन कै मेरे झोने आन दियौ, और उनकै मना मत करौ, काहैकि स्वर्ग को राज्य ऐसियनै को है।” ");
INSERT INTO thr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","और बौ उनके ऊपर हात रखकै हूँना से चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","एक इंसान झोने आयकै ईसु से कही, “गुरुजी,” मैं कौन सो भलो काम करौं, “कि अनंत जिंदगी पामौ?” ");
INSERT INTO thr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ईसु बासे कही, “अच्छो का है जाके बारे मैं तैं मोसे काहे पूँछ रहो है काहैकि अच्छो तौ सिरफ ऐकै है फिर भी अगर तू अनंत जिंदगी पानो चाहथै तौ तू आग्यन को पालन कर।” ");
INSERT INTO thr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","बौ ईसु से पूँछीं, “कौन सी आग्या?” ईसु कही, “जौ कि कोई कै मारिये मति, व्यभिचार मत करियो, चोरी मत करियो, झूठी गभाई मत दियो; ");
INSERT INTO thr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अपने दऊवा और अईय्या को आदर करीये, और अपने पड़ोसी से अपने हानी प्यार करीये।” ");
INSERT INTO thr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“बौ ज्वान आदमी ईसु से कही, जे सब बात तौ मैं मानो हौं अब मेरे मैं कौन सी बात की कमी है?” ");
INSERT INTO thr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ईसु बासे कही, “अगर तैं हर बात मैं बढ़िया होनो चाहथै; तौ जा, अपनो सब कुछ बेंच कै गरीबन मैं बाँट दे; और तोकै स्वर्ग मैं धन मिलैगो; और आयकै मेरे पच्छू हुई ले।” ");
INSERT INTO thr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","पर बौ ज्वान आदमी जौ बात कै सुनकै उदास हुईकै चलो गौ, काहैकि बौ भौत सेठ रहै। ");
INSERT INTO thr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तौ ईसु अपने चेलन से कही, “मैं तुमसे सच कहथौं, कि सेठन को स्वर्ग के राज्य मैं जाए पानो कठिन है। ");
INSERT INTO thr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","हाँ तुमसे कहथौं कि कोई सेठ आदमी कै परमेस्वर राज्य मैं जानो आसान नाय है जैसी कि ऊँट को सुईं के भार से निकर जानो।” ");
INSERT INTO thr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","जौ सुनकै, चेला भौत चकित हुईकै कहीं, “फिर कौन को उद्धार हुई सकथै?” ");
INSERT INTO thr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ईसु उनके घाँईं देखकै कही, “इंसान से तौ जौ नाय हुई सकथै, पर परमेस्वर से सब कछु हुई सकथै।” ");
INSERT INTO thr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","जौ बात मैं पतरस बासे कही, “देख, हम तौ सब कछु छोड़कै तेरे पच्छू हुई लै हैं तौ हमकै का मिलैगो?” ");
INSERT INTO thr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ईसु उनसे कही, “मैं तुमसे सच कहथौं, कि नई उत्पत्ति मैं जब इंसान को लौड़ा अपनी महिमा के सिंहासन मैं बैठैगो, तौ तुम्हऊँ जो मेरे पच्छू हुई लै हौ, बहारै सिंहासन के राज्य मैं बैठकै इस्राएल के बहारै गोत्रन को न्याय करैगे। ");
INSERT INTO thr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","और जो कोई घरन या भईय्यन या बहेनियन या दऊवा या अईय्या या बाल-बच्चन या खेतन कै मेरे नाओं के ताहीं छोड़ दई है, बाकै सौ गुना मिलैगो, और बौ अनंत जिंदगी को अधिकारी होगो। ");
INSERT INTO thr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पर भौत से जो पहले हैं, पिछले होंगे; और जो पिछले हैं, पहले होंगे।” ");
INSERT INTO thr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“स्वर्ग को राज्य एक जमीनदार के हानी है जो सुबेरे अपनी अंगूर की बारी के ताहीं मजदूर लान कै निकरो। ");
INSERT INTO thr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","बौ उनकै रोज की मजदूरी देन कै मान गौ, एक दिन को एक चाँदी को सिक्का, और उनकै अपनी अंगूर की बारी मैं काम करन कै भेजी। ");
INSERT INTO thr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","लमसम नौ बजे के आस-पास जमीनदार फिर से घर से निकरो और बौ देखी कि कुछ आदमी बजार मैं बेकार ठाड़े है। ");
INSERT INTO thr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","तौ बौ उनसे कही, ‘तुम्हऊँ मेरी अंगूर की बारी मैं जाबौ, और जो ठीक मजदूरी है बौ ठीक मजदूरी दूँगो।’ ");
INSERT INTO thr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","सो बे भी बगिया मैं काम करन कै चले गै फिर लमसम बहारै बजे के आस-पास और दुबारा तीन बजे के आस-पास बौ बैसोई करी। ");
INSERT INTO thr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","फिर से लमसम पाँच बजे घर से बाहर गौ और कुछ आदमिन कै बजार मैं इतै-उतै देखी, बौ उनसे पूँछीं तुम सब आदमी हिंयाँ बेकार मैं काहे ठाड़े रहथौ? ");
INSERT INTO thr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","बे बासे कही, काहैकि कोई हमकै मजदूरी मैं नाय रखथै फिर बौ उनसे कही, ‘तुम्हऊँ मेरी अंगूर की बारी चले जाबौ।’” ");
INSERT INTO thr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“जब संजा भइ तौ अंगूर की बारी को मालिक अपने मजदूर के पधान से कही, ‘मजदूरन कै बुलबाए कै आखरी मजदूर से सुरु करकै जो पहले लगाए गै रहैं बे सबन कि मजदूरी दैदे।’ ");
INSERT INTO thr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","पाँच बजे काम करन बारे आदमिन कै सिक्का दौ जात रहै। ");
INSERT INTO thr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","फिर जो पहले लगाए गै रहैं बे सोचीं हमकै कुछ जद्धा मिलैगो पर उनमैं से हर एक कै एक-एक ही चाँदी को सिक्का मिलो। ");
INSERT INTO thr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","सिक्का तौ बे लै लईं और जमीनदार से सिकायत करत भै। ");
INSERT INTO thr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘बे कहीं जो बाद मैं लगे रहैं बे बस एक घंटा काम करीं और तू हमकै भी उतकै मजदूरी दौ जित्ती उनकै दौ। जबकी हम पूरे दिन बड़े घामो मैं मेहनत करे?’ ");
INSERT INTO thr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘मालिक उनमैं से एक कै जबाब दई, सुन दोस्त, मैं तेरे संग कोई अन्याय नाय करो हौं। का तैं एक चाँदी के सिक्का ताहीं एक दिन को काम करन के ताहीं राजी नाय भौ रहै। ");
INSERT INTO thr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","अब अपनी मजदूरी लियौ और घरै जाबौ। अब मैं जहो कै उतनोई दुंगो जित्तो मैं तोकै दौ। ");
INSERT INTO thr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","का मोकै अपनी रुपईया से अपनी जरुरत के इच्छा के अनुसार देन को अधिकार ना है? या का तुम जलथौ काहैकि मैं अच्छो हौं?’” ");
INSERT INTO thr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","और ईसु जौ तरीका से खतम करी, “कि जो आखरी हैं बे पहले होंगे, और जो पहले हैं बे आखरी होंगे।” ");
INSERT INTO thr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","जब ईसु यरूसलेम कै जात भौ बहारै चेलन कै एकांत मैं लैगौ, और रहामैं उनसे कहन लगो। ");
INSERT INTO thr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“देखौ, हम यरूसलेम कै जाए रै हैं; और इंसान को लौड़ा बड़ो पुजारी और यहूदि नियम के सिक्छकन के हात पकड़बाओ जागो और बे बाकै मौत की सजा देंगे। ");
INSERT INTO thr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","और फिर बे बाको मजाक उड़ान को, और कोड़ा लगबान कै, बाकै गैर यहूदियन कै सौंप देमंगे, और बाकै क्रूस मैं चढ़ाओ जागो पर बौ तिसरे दिन जिंदो करो जागो।” ");
INSERT INTO thr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","जब जब्दी के लौड़न की अईय्या अपने लौड़न के संग बाके झोने आयकै झुककै नमस्ते करी, और नहोरे करत भै कुछ माँगी। ");
INSERT INTO thr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ईसु उनसे पूँछी, “तैं का चाहथै?” बौ जबाब दई, “मोकै बचन दे कि मेरे जे दोनों लौड़ा तेरे राज्य मैं एक तेरे दहने और एक तेरे बाँए बैठै।” ");
INSERT INTO thr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ईसु जबाब दई, “तुम नाय जानथौ कि का माँग रै हौ।” का तुम दुख को बौ प्याला पी सकथौ जोकै मैं पीन बारो हौं? बौ ईसु से कही, “हाँ हम पी सकथैं।” ");
INSERT INTO thr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ईसु कही, “तुम मेरो कटोरा तौ पीबैगे पर अपने दहने और बाँए बैठान को अधिकार मेरे पास नाय है, हिंयाँ बैठन को अधिकार उनको है जिनके ताहीं मेरे दऊवा के घाँईं से तैयार करो गौ है।” ");
INSERT INTO thr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","जब बाके चेला जौ सुनी, तौ दसौ चेला बे दोनों भईय्यन ऊपर गुस्सा भै। ");
INSERT INTO thr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ईसु उनकै झोने मस्काए कै कही, “तुम जानथौ, कि गैर यहूदि राजा लोगन के ऊपर राज करथैं, और उनके बड़े अधिकारी लोगन के ऊपर अपनो अधिकार जतानो चाहथैं। ");
INSERT INTO thr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पर तुमरे बीच मैं ऐसो नाय होनो चाहिए; पर तुम मैं जो कोई पहलो बननो चाहबै बाकै तुमरो सेवक बननो होगो। ");
INSERT INTO thr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","और जो तुम मैं पधान होनो चाहबै बौ तुमरो दास बनै; ");
INSERT INTO thr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","तुमकै इंसान के लौड़ा के हानी होनो चाहिए, जो सेवा करान कै नाय सेवा करन और भौतन के छुड़ौती के ताहीं अपनी ज्यान देन कै आओ है।” ");
INSERT INTO thr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जब ईसु और बाके चेला यरीहो से जात रहैं, तौ एक भारी भीड़ बाके पच्छू हुई लई। ");
INSERT INTO thr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","और दुई अंधरा आदमी जो सड़क के किनारे बैठे रहैं, जौ सुनकै कि ईसु जाएरौ है, चिल्लाए कै कहेन लगे, “प्रभु, दाऊद के बालक हमरे ऊपर दया कर।” ");
INSERT INTO thr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","आदमी उनकै झुकाइ, कि चुप्पा रहाबौ, पर बे औरौ चिल्लाए कै कहीं, “प्रभु दाऊद के बालक हमरे ऊपर दया कर।” ");
INSERT INTO thr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तौ ईसु ठाड़कै उनकै बुलाई और कही, “तुम का चाहथौं कि मैं तुमरे ताहीं करौं?” ");
INSERT INTO thr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","बे जबाब दईं, “गुरुजी, हम चाहथैं कि तैं हमैं आँखी कि जोती दे!” ");
INSERT INTO thr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ईसु तरस खाएकै उनकी आँखी छुइ और बे तुरंतै देखन लगे, और बाके पच्छू हुई लईं। ");
INSERT INTO thr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ईसु और बाके चेला यरूसलेम के झोने, बे जैतून के पहाड़ मैं बैतनिय्याह आए। तौ ईसु दुई चेलन से कही: ");
INSERT INTO thr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","और आग्या दैकै भेजी: “तुम सामने के गाँव मैं जाबौ, हूँना पहौंचतै एक गधी भँदी भइ, और बाके संग बच्चा तुमकै मिलैगो; उनकै खोलकै मेरे झोने लैयाबौ। ");
INSERT INTO thr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","और कोई कछु भी कहथै, तौ बाकै बतईयो, ‘कि प्रभु कै इनकी जरूरत है।’ और फिर बौ तुमकै जान देगो।” ");
INSERT INTO thr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ऐसो जहे ताहीं भौ कि, भविस्यवक्ता को जौ बचन पूरो होबै: ");
INSERT INTO thr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सिय्योन सहर से कहबौ, देखौ, तुमरो राजा तुमरे झोने आए रौ है! बौ विनम्र है और एक गधा मैं बैठो है हाँ जौ एक गधा को बच्चा है।” ");
INSERT INTO thr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेला चले गै और बे बहे करीं जो ईसु उनसे करन कै कही रहै: ");
INSERT INTO thr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","बे गधा और बाके बच्चा कै लैयाए, उनके ऊपर अपने लत्ता डारीं, और ईसु बाके ऊपर बैठगौ। ");
INSERT INTO thr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","और भौत सारे आदमी अपने लत्ता राह मैं बिछाईं और आदमी पेंड़न से हँगईय्या काटकै राह मैं बिछाईं। ");
INSERT INTO thr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","और जो भीड़ अग्गु-अग्गु जात और पच्छू-पच्छू चली आत रहै, चिल्लाए-चिल्लाए कै कहेत रहै, “दाऊद के बालक की होसन्ना; धन्य है बौ जो प्रभु के नाओं से आथै, परम प्रभु होसन्ना!” ");
INSERT INTO thr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जब बौ यरूसलेम मैं आओ, तौ पूरे नगर मैं हलचल मच गई; और आदमी कहेन लगे, “जौ कौन है?” ");
INSERT INTO thr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","आदमी कहीं, “जौ गलील के नासरत को भविस्यवक्ता ईसु है।” ");
INSERT INTO thr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","फिर ईसु परमेस्वर के मंदिर के आँगन मैं आओ, बे सबै जो मंदिर मैं खरीदत और बेंचत रहै, बे सबन कै खदेड़ दई; और ब्यापारियन कि मेज और कबूतरन कै बेचन बारेन के तखता पलट दई। ");
INSERT INTO thr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","और उनसे कही, “सास्त्र मैं लिखो है, ‘मेरो घर प्रार्थना को घर मानो जागो।’ पर तुम बाकै लुटेरन को अड्डा बनाथौ!” ");
INSERT INTO thr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","और अंधरा और लंगड़ा मंदिर मैं बाके झोने आए और बौ उनकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","पर जब मुखिया पुजारी और यहूदि नियम के सिक्छक जे निराले कामन कै जो बौ करी, और लौड़न कै मंदिर मैं दाऊद के बालक की होसन्ना चिल्लात भै देखीं, तौ गुस्सा भै, ");
INSERT INTO thr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","तौ बे ईसु से पूँछीं, “का तैं सुनथै कि जे का कह रै हैं?” ईसु उनसे कही, “हाँ सुनथौं का धर्मसास्त्र मैं ‘तुम जौ नाय पढ़े तू बालकन और दूत पीत भै बालकन से आराधना करबाओ है।’” ");
INSERT INTO thr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तौ ईसु उनकै छोड़कै यरूसलेम के बहार बैतनिय्याह कै गौ, और हूँना रात काटी। ");
INSERT INTO thr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","अगले दिन जब भोर भौ तौ ईसु नगर से लौटत रहै, तौ बाकै भूंक लगी। ");
INSERT INTO thr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","जब अंजीर के रूखा कै सड़क के किनारे देखकै बौ बाके झोने गौ, और पत्तन कै छोड़ बामै कछु नाय पाय कै रूखा से कही, “अब से तेरे मैं कहु फरा ना लगै।” और अंजीर को रूखा तुरंतै सूख गौ। ");
INSERT INTO thr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","जौ देखकै चेला चकाय गै और पूँछीं, “जौ अंजीर को रूखा तुरंतै कैसे सूख गौ?” ");
INSERT INTO thr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ईसु जबाब दई, “मैं तुमसे सच कहथौं; अगर तुम बिस्वास रखौ, और संका ना करौ; तौ ना सिरफ जौ करैगे, जो जौ अंजीर के रूखा से करो गौ है; पर अगर जौ पहाड़ से भी कहगे, कि उखड़ जा, और समुंदर मैं जाए गिर, तौ जौ हुई जागो। ");
INSERT INTO thr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","और जो कछु तुम प्रार्थना मैं बिस्वास से माँगैगे बौ सब तुमकै मिलैगो।” ");
INSERT INTO thr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","जब ईसु मंदिर मैं जाएकै उपदेस देत रहै; तौ प्रमुख पुजारी और यहूदि बड़े-बूढ़े के पास आए कै पूँछीं, “ऐसी बात तू कोनछे अधिकार से करथै, और जौ अधिकार तोकै कौन दौ है?” ");
INSERT INTO thr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ईसु जबाब दई, “महुँ तुमसे एक सवाल पूछथौं, और तुम मोकै जबाब देबौ, तौ महुँ तुमकै बतांगो कि कौन से अधिकार से करथौं। ");
INSERT INTO thr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","बताबौ यूहन्ना कै बपतिस्मा कहाँ से मिलो? परमेस्वर से या इंसान से?” बे आपस मैं बिचार करकै कहेन लगे, “अगर हम कहमैं ‘स्वर्गिय परमेस्वर के घाँईं से,’ तौ बौ हमसे कहेगो कि, ‘फिर तुम बाको बिस्वास कहे नाय करे?’ ");
INSERT INTO thr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","और अगर हम कहमैं ‘इंसान के घाँईं से’ तौ हमैं भीड़ को डर है, काहैकि बे सब यूहन्ना कै भविस्यवक्ता मानथैं।” ");
INSERT INTO thr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","तभई बे ईसु कै जबाब दईं, “हम नाय जानथैं।” बहो उनसे कही, “तौ महुँ तुमकै नाय बताथौं, कि जे काम कौन से अधिकार से करथौं।” ");
INSERT INTO thr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“अच्छा बताबौ तुम जाके बारे मैं का सोचत हौ? एक इंसान के दुई लौड़ा रहैं; बौ बड़े के झोने जाएकै कही, ‘अंगूर की बारी मैं काम करन जा।’ ");
INSERT INTO thr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","पर लौड़ा जबाब दई, ‘मैं ना जांगो,’ पर बाद मैं बौ अपनो मन बदल दई और चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","फिर बौ दऊवा दुसरे के झोने गौ, बौ जबाब दई, हाँ प्रभु जाथौं, पर बौ नाय गौ। ");
INSERT INTO thr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","बताबौ जे दोनों मैं से जो दऊवा चाहत रहै कौन करो, बे कहीं बड़े करी, ईसु उनसे कही मैं तुमसे सच्ची कहथौं, लगान बासूलन बारे और बैस्या तुमसे पहले परमेस्वर के राज्य मैं जाथैं।” ");
INSERT INTO thr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","काहैकि यूहन्ना बपतिस्मा देन बारो धार्मिकता के रस्ता से तुमरे झोने आओ, और तुम बाके ऊपर बिस्वास नाय करे: पर लगान लेन बारे और बैस्या बाको बिस्वास करकै मन बदलीं: और तुम जौ देखकै बादौ मैं नाय पछताए कि बाको बिस्वास कर लेते। ");
INSERT INTO thr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ईसु कही, “दुसरी कहानी कै सुनौ। एक बार एक जमीनदार रहै जो एक अंगूर की बारी लगाई, बाके चारौ तरफ एक बेहड़ा लगाई, फिर दाखरस निकारन ताहीं एक गड्डा खोदी और रखबारी ताहीं एक मिनार बनाईं, और कुछ किसानन कै किराय मैं दैकै सफर कै चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जब अंगूरन कै समेटन को समय आओ तौ, बौ अपने सेवकन कै फसल को हिस्सा लेन के ताहीं भेजी। ");
INSERT INTO thr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पर किसान बाके दासन कै पकड़कै कोई कै पीटीं, और कोई कै मारडारीं; और कोई कै पथरन से मारीं। ");
INSERT INTO thr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","एक बार फिर बौ पहले से जद्धा सेवकन कै भेजी, और बे उन्हऊँ के संग बैसोई करीं। ");
INSERT INTO thr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आखरी मैं बौ अपने लौड़ा कै उनके झोने जौ कहकै भेजी, कि बे मेरे लौड़ा को आदर करंगे। ");
INSERT INTO thr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","लेकिन किसान लौड़ा कै देखकै आपस मैं कहीं, ‘जहे तौ वारिस है, आबौ, जाकै मार डारैं: और बाकी बिरासत लै लियैं।’ ");
INSERT INTO thr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","और बे बाकै पकड़ीं और अंगूर की बारी से निकारकै मारडारीं। ");
INSERT INTO thr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","तुम का सोचथौ, जब बौ अंगूर की बारी को मालिक आबैगो, तौ बे किसानन के संग का करैगो?” ");
INSERT INTO thr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","बे उत्तर दईं, “बौ बे बुरे आदमिन कै मार देगो; और अंगूर की बारी कै कोई और ठेका औरै किसानन कै देगो, जो बाकै सई समय मैं फसल को हिस्सा दे करंगे।” ");
INSERT INTO thr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ईसु उनसे कही, “का तुम कहु पवित्र सास्त्र मैं जौ नाय पढ़े? ‘जो पथरा कै राजमिस्त्री बेकार जानी रहैं, बहे कोहने के सिरा को पथरा हुई गौ। जौ प्रभु के घाँईं से भौ, और हमरे देखन मैं निरालो है!’” ");
INSERT INTO thr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“तभई मैं तुमसे कहथौं, कि परमेस्वर को राज्य तुमसे लै लौ जागो; और बे लोगन कै दै दौ जागो जो फल लामंगे। ");
INSERT INTO thr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","जो जौ पथरा मैं गिरैगो, बौ चकनाचूर हुई जागो: और जौ चट्टान जोके ऊपर गिरैगी, बौ बाकै पीस डारैगी।” ");
INSERT INTO thr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","प्रधान पुजारी और फरीसी बाकी कहानी कै सुनकै समझ गै, कि बौ हमरे बारे मैं कहरौ है। ");
INSERT INTO thr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","तौ बे बाकै पकड़नो चाँहीं, पर आदमिन से डराय गै काहैकि बे बाकै भविस्यवक्ता जानत रहैं। ");
INSERT INTO thr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","एक बार फिर ईसु लोगन से बात करन ताहीं कहानियाँ कै लई। ");
INSERT INTO thr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“स्वर्ग को राज्य ऐसो है, एक बार एक राजा रहै जो अपने लौड़ा के ताहीं बिहा मैं दावत दई। ");
INSERT INTO thr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","राजा अपने सेवकन कै भेजी कि बे लोगन कै बुलाए लाबौ जिनकै बिहा के खानौ को न्युतो दौ गौ है पर बे आदमी नाय आए। ");
INSERT INTO thr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","फिर बौ अपने सेवकन कै जौ कहकै भेजी, ‘जिनकै न्युतो दौ गौ है उनसे कहियो: देखौ, मैं खानु तैयार कर चुको हौं, और मेरे बरधा और पले भै डंगर काट दै गै हैं और सब कछु तैयार है; बिहा को खानु खान आबौ।’ ");
INSERT INTO thr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पर बुलाए भै हितुआ कोई ध्यान नाय दईं और अपने काम कै चले गै: कोई अपने खेत मैं गौ, कोई अपने ब्यापार कै, ");
INSERT INTO thr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","जबकी कुछ आदमी सेवकन कै पकड़कै उनके संग मारपीट करीं और औरन कै मारडारीं ");
INSERT INTO thr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","राजा भौत गुस्सा मैं रहै; तभई बौ सैनिकन कै भेजी; बे उन मारन बारेन कै मारडारीं और उनके सहर कै जलाए दईं। ");
INSERT INTO thr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तौ बौ अपने सेवकन कै बुलाई और उनसे कही, ‘मेरे बिहा को खानु तौ तैयार है, पर जिनकै न्युतो दौ बे आदमी जाके लायक नाय रहैं। ");
INSERT INTO thr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","अब चौराहे की सड़कन मैं जाबौ और जित्ते आदमी तुमकै मिलैं उनकै दाबत के ताहीं न्युतो दियौ।’ ");
INSERT INTO thr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","तभई सेवक सड़कन मैं निकर गै और जो-जो अच्छे-बुरे उनकै मिले बे सबै आदमिन कै इखट्टो करीं; और बिहा की डेहरी आदमिन से भर गई।” ");
INSERT INTO thr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“जब राजा हितुअन कै देखन भीतर आओ; तौ बौ हूँना एक इंसान कै देखी, जो बिहा के लत्ता नाय पहने रहै। ");
INSERT INTO thr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","बौ बासे पूँछी, ‘दोस्त तैं बिहा के लत्ता बिना पहने हींना काहे आए गौ?’ और बौ इंसान चुप हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तौ राजा सेवक से कही, ‘जाके हात-टाँग भाँदकै बहार अंधियारे मैं खेंप दियौ, हूँना रोनो, और दाँत पीसनो होगो।’” ");
INSERT INTO thr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","और ईसु कहानी के आखरी मैं कही, “बुलाए भै तौ भौतेरे हैं, पर चुने भै थोड़ी से हैं।” ");
INSERT INTO thr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","फिर फरीसी सभा बुलाईं और ईसु कै सबाल पूँछ कै फसान की सोची। ");
INSERT INTO thr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","बे अपने चेलन कै हेरोदियन के संग बाके झोने जौ कहेन कै भेजीं, “गुरुजी, हम जानथैं, कि तैं सच्चो है और परमेस्वर की रहा सच्चाई से सिखाथै, और कोई की परबा नाय करथै, काहैकि तैं इंसानन को मोहों देखकै बात नाय करथै। ");
INSERT INTO thr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","तौ, हमैं बताबौ, तुम का सोचथौ? का रोमन सम्राट कैसर कै लगान देनो हमरे नियम के खिलाप है या नाय?” ");
INSERT INTO thr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","हालाकि, ईसु उनकी बुरी योजना कै जानत रहै, और तभई बौ कही, “तुम पाखंडी हौ! मोकै काहेकै फसान की कोसिस कर रहे हौ? ");
INSERT INTO thr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","मोकै लगान देन को सिक्का दिखाबौ!” बे बाकै सिक्का दिखाईं, ");
INSERT INTO thr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","और बौ उनसे पूँछी, “जौ सिक्का मैं कौनकी छाप और सकल को नाओं है?” ");
INSERT INTO thr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","बे बाकै जबाब दईं, “कैसर को,” तौ ईसु कही, “ठीक है, जो कैसर को है बौ कैसर कै; और जो परमेस्वर को है, बौ परमेस्वर कै दियौ।” ");
INSERT INTO thr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","जब बे जौ सुनीं, तौ हैरान रहगै; और बे बाकै छोड़कै चले गै। ");
INSERT INTO thr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","बहे दिन कुछ सदूकी जो मौत से फिर से जी उठन मैं बिस्वास नाय करत रहैं ईसु के झोने आए और बासे कहीं। ");
INSERT INTO thr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“गुरुजी, मूसा के अनुसार अगर कोई बिना बाले-बच्चे के मर जाए तौ का बाको भईय्या बाकी बिधवा से बिहा करै और अपनो बंस बड़ान कै कही रहै कि एक आदमी जोकी कोई औलाद ना है, बाको भईय्या मर जाथै, तौ बाके भईय्या कै बिधवा से बिहा कर लेनो चहाईये ताकी उनके बालका हुई सकैं जिनकै मरे भै आदमी के बालका मानो जागो। ");
INSERT INTO thr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","अब सोचौ मत सात भईय्या हैं पहले को बिहा भौ फिर बौ मर गौ, काहैकि बौ अपनी बिधवा बईय्यर कै अपने भईय्या के झोने छोड़ दई। ");
INSERT INTO thr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ऐसोई दुसरे भईय्या के संग, तिसरे भईय्या के संग और आखिरकार सबै सातन के संग ऐसोई भौ। ");
INSERT INTO thr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","आखरी मैं बईंय्यरौं मर गई। ");
INSERT INTO thr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","अब हमरो कहनो जौ है कि जब बौ जी उठैगी तौ कौन कि बईय्यर होगी काहैकि बाकै सातौ अपनाईं रहैं।” ");
INSERT INTO thr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ईसु जबाब दई, “तुम कित्ते गलत हौ! ऐसो तभईये है काहैकि तुम सास्त्र या परमेस्वर की सक्ति कै नाय जानथौ। ");
INSERT INTO thr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","तुमकै समझनो चाहिए कि दुबारा जी उठन मैं ना तौ लोग बिहा करंगे और ना कोई बिहा मैं दौ जागो बलकिन बे स्वर्गदूतन के हानी होंगे। ");
INSERT INTO thr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","अब, मरे भैन के जी उठन के बारे मैं का तुम जौ बचन नये पढ़े जो परमेस्वर तुमसे कही: ");
INSERT INTO thr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘मैं अब्राहम को परमेस्वर, इसहाक को परमेस्वर, और याकूब को परमेस्वर हौं।’ बौ तौ मरे भैन को नाय, पर जिंदो को परमेस्वर है।” ");
INSERT INTO thr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","जब भीड़ जौ सुनी, तौ बे बाके उपदेस से चकित हुईगै। ");
INSERT INTO thr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जब फरीसी सुनीं कि ईसु सदूकिन कै चुप कर दई है, तौ बे एक संग आए, ");
INSERT INTO thr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","और उनमैं से एक नियम को सिक्छक, बाकै एक सबाल के संग फसान की कोसिस करी। ");
INSERT INTO thr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","बे पूँछीं, “गुरुजी, नियम मैं सबसे बड़ी आग्या कौन सी है?” ");
INSERT INTO thr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ईसु जबाब दई, “‘तैं अपने पूरे मन और पूरी आत्मा, और पूरे दिमाक के संग अपने प्रभु परमेस्वर से प्यार कर।’ ");
INSERT INTO thr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","जौ सबसे पहली और बड़ी आग्या है। ");
INSERT INTO thr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","फिर ऐसिये दुसरी आग्या जौ है: ‘अपने परोसी से बैसिये प्यार कर जैसे तुम अपने आप से करथौ।’ ");
INSERT INTO thr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","पुरो नियम और भविस्यवक्ता की सिक्छा जे दुई आग्यन ऊपर निर्भर करथैं।” ");
INSERT INTO thr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जब कुछ फरीसी जुराने तौ, ईसु उनसे एक सबाल पूँछीं, ");
INSERT INTO thr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसीहा के बारे मैं तुम का सोचथौ? बौ कौन को लौड़ा है?” बे जबाब दईं, “बौ दाऊद को बंसज” है। ");
INSERT INTO thr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","बौ उनसे पूँछी, “तौ दाऊद आत्मा मैं हुईकै बाकै प्रभु काहे कहथै? ");
INSERT INTO thr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘प्रभु, मेरे प्रभु से कही, मेरे दहने बैठ, जबले कि मैं तेरे बैरियन कै तेरी टाँग के नीचे की चौकी ना कर दियौं।’ ");
INSERT INTO thr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","तौ अगर, दाऊद बाकै प्रभु कही, तौ मसीहा दाऊद को लौड़ा कैसे हुई सकथै?” ");
INSERT INTO thr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","कोई भी ईसु को कोई सो भी जबाब देन के काबिल ना रहैं, और बहे दिन से कोईये कोई सो सबाल पूँछन की हिम्मत नाय रखीं। ");
INSERT INTO thr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तौ ईसु भीड़ और अपने चेलन से कही, ");
INSERT INTO thr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“यहूदि नियम के सिक्छक और फरीसी खुदकै मूसा के नियमन कि ब्याख्या करन के आसन के अधिकार मैं रखीं हैं; ");
INSERT INTO thr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","तभई बे जो कछु तुमसे कहमैं बहे करियो, और मानियो, पर उनके जैसो काम मत करियो; काहैकि बे कहेत तौ हैं पर करत नाय हैं। ");
INSERT INTO thr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","बे एक ऐसो भारी बोझ देथैं कि बे बाकै उठाएकै चल नाय सकथैं, बे लोगन के ऊपर दबाब डारथैं कि बे बाकै लैकै चलैं। पर बे खुदै बामै कोई पाओ तक नाय डारथैं। ");
INSERT INTO thr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","बे अपने सब काम आदमिन कै दिखान के ताहीं करथैं बे अपनी ताबीजन कै चौहोंड़ी करथैं, और अपने लत्तन की झालरन कै बढ़ाथैं। ");
INSERT INTO thr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","बे न्युतो के खानु मैं अच्छी जघा पानो चाहथैं और यहूदि सभाघरन मैं खास आसन पानो चाहथैं। ");
INSERT INTO thr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","और बजारन मैं नमस्ते और इंसानन मैं रब्बी कहबानो उनकै अच्छो लगथै। ");
INSERT INTO thr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पर तुम लोगन से अपने आपकै रब्बी मत कहबईयो, काहैकि सच्चो गुरु तौ एकै है और तुम सब भईय्या-बहेनिया हौ। ");
INSERT INTO thr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","और पृथ्वी मैं कोई कै अपनो दऊवा मत कहियो, काहैकि तुमरो एकै दऊवा है, जो स्वर्ग मैं है। ");
INSERT INTO thr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","और मालिक भी मत कहबईयो, काहैकि तुमरो एकै मालिक है, मतलब मसीह। ");
INSERT INTO thr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जो तुम मैं बड़ो होबै, बौ तुमरो सेवक बनै। ");
INSERT INTO thr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जो कोई अपने आपकै बड़ो बनागो, बौ छोटो करो जागो: और जो कोई अपने आपकै छोटो बनागो, बौ बड़ो करो जागो।” ");
INSERT INTO thr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“तुम पाखंडी हौ, यहूदि नियम के सिक्छक और फरीसी तुमरे ऊपर भयानक हाय! तुमरे मोहों के अग्गु स्वर्ग राज्य को फाटक बंद है, जो जान की कोसिस करथैं, उनकै नाय तौ अंदर जान देथौ और ना खुद जाथौ! ");
INSERT INTO thr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","पाखंडी यहूदि नियम के सिक्छक और फरीसी, तुम बिधवन के घरन कै खाए जाथौ, और दिखान के ताहीं बड़ा देर ले प्रार्थना करत रहाथौ: तभई तुमकै भौत सजा मिलैगी।” ");
INSERT INTO thr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“तुम पाखंडी हौ! तेरे ऊपर हाय है, यहूदि नियम के सिक्छक और फरीसी! तुम एक जनी कै अपने मत मैं मिलान के ताहीं पूरे पानी और जघन मैं घूँमथौ, और जब बौ तुमरे मत मैं मिल जाथै, तौ बाकै अपने से दुगने नरक मैं जान बारे बनाये देथौ।” ");
INSERT INTO thr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“अंधे अगुवौ तुमरे ताहीं कितनो भयानक है! तुम पाखंडी हौ, ‘जो कहथैं कि अगर कोई मंदिर की कसम खाबै तौ कुछ नाय, पर अगर कोई मंदिर के सोने की कसम खाबै तौ बासे बौ भंद जागो।’ ");
INSERT INTO thr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","अरे बेअकलियौ और अंधौ, कौन बड़ो है, सोनो या बौ मंदिर जोसे सोनो पवित्र होथै? ");
INSERT INTO thr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","फिरौंकी कहथौ कि अगर कोई बेदी की कसम खाबै तौ कछु नाय, पर जो भेंट बामै है, अगर कोई बाकी कसम खाबै तौ भंद जागो। ");
INSERT INTO thr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","अरे अंधौ, कौन बड़ो है, भेंट या बेदी जोसे भेंट पवित्र होथै? ");
INSERT INTO thr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","तभईये जो बेदी की कसम खाथै, बौ बाकी, और जो कछु बामै है, बाकी भी सपथ खाथै। ");
INSERT INTO thr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","और जो मंदिर की कसम खाथै, बौ बाकी और बामै रहन बारेन की भी कसम खाथै। ");
INSERT INTO thr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","और जो स्वर्ग की कसम खाथै, बौ परमेस्वर के सिंहासन की और बाके ऊपर बैठन बारे की भी कसम खाथै।” ");
INSERT INTO thr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“तुम पाखंडी हौ! और तुमरे ताहीं कितनो भयानक है, यहूदि नियम के सिक्छक और फरीसीयौ! तुम पुदीना, सौंफ और जीरा को दसमों अंस देथौ, पर तुम नियम की हकीकत मैं जरूरी सिक्छन को पालन ना करन कै कहथौ, जैसे कि न्याय, दया और इमानदारी। तुमकै दुसरेन कै गलत नाय बताए कै ऐसो करनो चहाईये।” ");
INSERT INTO thr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","अंधे अगुवौ! तुम अपने पीन मैं से मक्खी तौ निकारथौ, पर ऊँट कै लील जाथौ। ");
INSERT INTO thr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“तुम पाखंडी हौ! तुमरे ताहीं कितनो भयानक है, यहूदि नियम के सिक्छक और फरीसियौ! तुम अपने गिलास और थरियन कै बहार से साफ करकै माँजथौ, जबकी अंदर से तुम हिंसा और लालच से भरे हौ।” ");
INSERT INTO thr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","अंधे फरीसी! पहले कटोरा और थरिया कै भीतर से माँज कि बे बहार सेऊ साफ होमैं। ");
INSERT INTO thr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“तुम पाखंडी हौ! तुमरे ताहीं कितनो भयानक है, यहूदि नियम के सिक्छक और फरीसी! तुम चूना पोती भइ कबरन के हानी हौ जो ऊपर से तौ सुगड़ दिखथैं, पर भीतर मरे भैन की हड्डी और सब तरहन की असुद्धता से भरी हैं। ");
INSERT INTO thr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","जहे तरीका से तुम्हऊँ ऊपर से इंसानन कै धर्मी दिखाई देथौ, पर भीतर कपट और अधर्म से भरे भै हौ।” ");
INSERT INTO thr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“तुम पाखंडी हौ! तुमरे ताहीं कितनो भयानक है, यहूदि नियम के सिक्छक और फरीसीयौ! तुम भविस्यवक्तन की कबरन कै समारथौ और धर्मियन की कबरन कै बनाथौ। ");
INSERT INTO thr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","और तुम कहथौ, ‘कि अगर हम अपने पुरखन के दिनन मैं होते तौ भविस्यवक्तन को खून बहान मैं उनके सहभागी ना होते।’ ");
INSERT INTO thr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","जासे तौ तुम खुदै गभाई देथौ, कि तुम भविस्यवक्ता के मारन बारेन के बालका हौ! ");
INSERT INTO thr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","तुम अपने पुरखन के पाप को घड़ा भर दियौ। ");
INSERT INTO thr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","तुम साँप और साँप के बालका हौ! तुम नरक के न्याय से बचन की उमीद कैसे कर सकथौ? ");
INSERT INTO thr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","तभईये देखौ, मैं तुमरे झोने भविस्यवक्ता और दिमाकदारन और यहूदि नियम के सिक्छकन कै भेजथौं; और तुम उनमैं से कुछ कै मार डारैगे, और क्रूस मैं चढ़ागे; और कुछ कै अपनी सभाघरन मैं कोड़े मारैगे, और एक नगर से दुसरे नगर मैं खदेड़त फिरैगे। ");
INSERT INTO thr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","फलस्वरूप, ऐसे करकै धर्मी हाबिल के खून से लैकै बेरेक्याह को लौड़ा जकर्याह के खून तक, जोकै तू मंदिर की बेदी के बीच मैं घात करो रहै, निर्दोस खून जो पृथ्वी मैं बहाओ गौ रहै, बौ सब तुमरे ऊपर पड़ेगो। ");
INSERT INTO thr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मैं तुमसे सच कहथौं, जे सब बातैं जहे पीढ़ी के लोगन ऊपर आए पड़ंगी।” ");
INSERT INTO thr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“यरूसलेम, यरूसलेम! तैं जो भविस्यवक्तन कै मार डारथै, और जो तेरे झोने भेजे गै, उनके ऊपर पथरवाह करथै, कित्ते बार मैं चाहो कि जैसी मुर्गिया अपने बच्चन कै अपने पखमा तरे इखट्टो करथै, बैसिये महुँ तेरे बालकन कै इखट्टो कर लियौं, पर तुम ना चाहे। ");
INSERT INTO thr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देखौ, तुमरो घर तुमरे ताहीं उजाड़ छोड़ो जाथै। ");
INSERT INTO thr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","काहैकि मैं तुमसे कहथौं, कि अब से जबले तुम ना कहबैगे, ‘धन्य है बौ, जो प्रभु के नाओं से आथै’ तौले तुम मोकै फिर कहु ना देखैगे।” ");
INSERT INTO thr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जब ईसु मंदिर से निकरकै जात रहै, तौ बाके चेला बाकै मंदिर की इमारत की बनावट दिखान के ताहीं बाके झोने आए। ");
INSERT INTO thr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“बौ कही,” हाँ, “का तुम जौ सब नाय देखथौ? मैं तुमसे सच कहथौं, हींना पथरा से पथरा भी ना छुटैगो, जो गिराओ ना जागो।” ");
INSERT INTO thr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जब ईसु जैतून के पहाड़ मैं बैठो, तौ चेला बाके झोने अलग आयकै कहीं, “हमैं बता कि जौ सब कब होगो, और तेरे आन को और दुनिया के अंत को का चिन्ह होगो?” ");
INSERT INTO thr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ईसु उनकै जबाब दई, “चहाचीते रैहबौ! कोई तुमकै ना बैहकाबै। ");
INSERT INTO thr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","काहैकि भौत से ऐसे होंगे जो मेरे नाओं से आयकै कहमंगे, ‘मैं मसीह हौं,’ और भौतन कै बैहकाए देंगे। ");
INSERT INTO thr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुम लड़ाईयन और लड़ाईयन की चर्चा सुनैगे; देखौ घबरईयो मति काहैकि इनको होनो जरूरी है, पर बौ समय अंत ना होगो। ");
INSERT INTO thr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","काहैकि जाति ऊपर जाति, और राज्य ऊपर राज्य चढ़ाई करैगो, और जघा-जघा अकाल पड़ंगे, और भूकंप होंगे। ");
INSERT INTO thr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","जे सब बात दुखन की सुरुवात होंगी।” ");
INSERT INTO thr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","तौ बे कलेस दिबान के ताहीं तुमकै पकड़बांगे, और मार डारंगे और मेरे नाओं के बजह से सब जाति के लोग तुमसे बैर रखांगे। ");
INSERT INTO thr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तौ भौत से ठोकर खांगे, और एक दुसरे कै पकड़बांगे और एक दुसरे से बैर रखांगे। ");
INSERT INTO thr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","भौत से झूठे भविस्यवक्ता उठ खड़े होंगे, और भौतन कै बैहकांगे। ");
INSERT INTO thr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","और अधर्म के बढ़न से भौतन को प्यार ठंडो हुई जागो। ");
INSERT INTO thr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पर जो आखरी ले धीर धरंगे, उन्हईं को उद्धार होगो। ");
INSERT INTO thr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","और राज्य को जौ सुसमाचार पूरे देस दुनिया मैं प्रचार करो जागो, कि सब जाति मैं गभाई होबै, तौ अंत हुई जागो। ");
INSERT INTO thr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“बौ दिन आए रौ है जब तुम देखैगे कि दानिय्येल भविस्यवक्ता के बारे मैं बुरी बात करी रहै, पवित्र जघा मैं निर्बलता को कारड़ बनन बारी पवित्र चीज।” पाठक ध्यान देमैं! ");
INSERT INTO thr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“तौ जो यहूदिया मैं होमैं बे पहाड़न मैं भाज जामैं। ");
INSERT INTO thr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जो छत मैं होमैं, बे अपने घर मैं से सामान लेन कै ना उतरैं। ");
INSERT INTO thr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","और जो खेत मैं होमैं, बौ अपनो लत्ता लेन कै पच्छू ना लौटै। ");
INSERT INTO thr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","बे दिनन मैं जो गर्भवती और दूद पिबात होंगी, उनके ताहीं भौत भयानक होगो! ");
INSERT INTO thr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","और प्रार्थना करौ; कि तुमकै जाड़े मैं या साबत के दिन भाजन ना पड़ै। ");
INSERT INTO thr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","बौ समय की परेसानी के ताहीं दुनिया की सुरुवात से लैकै आज ले कहूँ भी इत्तो भयानक ना भौ ना कहु ऐसो कुछ होगो। ");
INSERT INTO thr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","लेकिन परमेस्वर पहलिये दिनन की संख्या कम कर दई है; अगर बौ ऐसो ना करतो तौ कोई ना बचतो। हालाकि, अपने चुने भै लोगन के खातिर दिन कम हुई जांगे।” ");
INSERT INTO thr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“तौ, अगर कोई तुमसे कहबै, ‘कि देखौ, मसीह हींना है!’ या ‘हूँना है!’ तौ बिस्वास मत करियो। ");
INSERT INTO thr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","झूठे मसीह और झूठे भविस्यवक्ता दिखाई देंगे; जितनो हुई सकैगो बे परमेस्वर के चुने भै लोगन कै धोका देन के ताहीं महान चमत्कार के ऊपर चिन्ह चमत्कार करंगे। ");
INSERT INTO thr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","सुनौ! जौ बात मैं तुमकै समय से पहले बताओ हौं।” ");
INSERT INTO thr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“तभई अगर बे तुमसे कहमैं, ‘देखौ, बौ बन मैं है,’ तौ हूँनै मत चले जईयो, ‘देखौ, बौ भीतर के कमरा मैं लुको है!’ तौ बिस्वास मत करियो।” ");
INSERT INTO thr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","काहैकि इंसान को लौड़ा बौ बिजली के हानी आगो जो अगार से पछार ले पूरे आसमान मैं चमकथै। ");
INSERT INTO thr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“जितै लास होगी, हूँनै गिद्धा जुरांगे।” ");
INSERT INTO thr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“जल्दियै बे दिनन की परेसानीयो के बाद, सूरज अंधियारो हुई जागो, जोनी अब नाय चमकैगी, तारा स्वर्ग से गिराय जांगे, और आसमान की सक्ति हिलाई जांगी। ");
INSERT INTO thr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तौ इंसान के लौड़ा को चिन्ह आसमान मैं दिखाई देगो; और पृथ्वी के सबै जाति के लोग रोमंगे काहैकि बे इंसान के लौड़ा कै स्वर्ग के बादरन ऊपर सक्ति और महान महिमा के संग आत भै देखंगे। ");
INSERT INTO thr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","बौ महान तुरहई अबाज करैगी, और बौ अपने स्वर्गदूतन कै पृथ्वी के चारौ कोहने मैं भेज देगो, और बे अपने चुने भै लोगन कै दुनिया के एक छोर से दुसरे छोर ले इखट्टो करंगे।” ");
INSERT INTO thr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“अंजीर के रूखा से जौ कहानी सीखौ जब बाकी हँगईय्या कोमल हुई जाथैं और पत्ता निकरत रहाथैं, तौ तुम जान लेथौ, कि गर्मी झोने है। ");
INSERT INTO thr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","जहे तरीका से जब तुम जे सब बातन कै देखौ, तौ जान लियौ, कि बौ दिन झोने है, बल्किन ठीक मोहोंट के अग्गु है। ");
INSERT INTO thr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","मैं तुमसे सच कहथौं, कि जबले जे सब बातैं पूरी ना हुई लेमैं, तौले जौ पीढ़ी को अंत ना होगो। ");
INSERT INTO thr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","आसमान और पृथ्वी टल जांगी, पर मेरे सब्द कहु नाय टलंगे।” ");
INSERT INTO thr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“हालाकि, कोई ना जानथै, बौ दिन और घंटा कब आगो, ना तौ स्वर्ग मैं स्वर्गदूत, और ना लौड़ा, पर सिरफ परम दऊवा। ");
INSERT INTO thr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जैसी नूह के दिन रहैं, बैसिये इंसान के लौड़ा को भी आनो होगो। ");
INSERT INTO thr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","बहाड़ से पहले के दिनन मैं आदमी खाईं-पीं, लोग और बईय्यर बिहा करीं, बहे दिन नूह बड़ी नईंय्याँ मैं गौ; ");
INSERT INTO thr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","तहुँओं पतै नाय चलो कि बहाड़ आन ले का हुई रौ है और सबै पुही गै। ऐसोई होगो जब इंसान को लौड़ा आगो। ");
INSERT INTO thr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","बौ समय दुई जनी खेत मैं होंगे, एक कै लै लौ जागो और दुसरे कै छोड़ दौ जागो। ");
INSERT INTO thr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दुई बईंय्यरैं चक्की पीसत रहांगी, एक लै लई जागी, और दुसरी छोड़ दई जागी। ");
INSERT INTO thr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","तभई जगत रहाबौ, काहैकि तुम नाय जानथौ कि तुमरो प्रभु कौनसे दिन आगो। ");
INSERT INTO thr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पर जौ जान लियौ कि अगर घर को मालिक जानत होतो कि चुट्टा कित्ते बजे की बेरा आगो, तौ जगत रहातो; और अपने घर मैं चोरी नाय होन देतो। ");
INSERT INTO thr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","तभई तुम्हऊँ तैयार रैहबौ, काहैकि जो समय के बारे मैं तुम सोचतौ ना हौ, बहे समय इंसान को लौड़ा आए जागो।” ");
INSERT INTO thr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“फिरौंकी, एक भरोसेमंद और दिमाकदार सेवक कौन है? जौ बौ है जोकै बाको मालिक अपने सेवकन को सरदार बनाई, कि समय से उनकै खानु देबै? ");
INSERT INTO thr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","धन्य है, बौ सेवक जोकै बाको मालिक आयकै ऐसोई करत भै पाबै! ");
INSERT INTO thr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मैं तुमसे सच कहथौं; बौ बाकै अपनी पूरी सम्पत्ति ऊपर अधिकारी बनागो। ");
INSERT INTO thr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","पर अगर बौ दुस्ट सेवक अपने मन मैं सोचन लगै, कि मेरे मालिक के आन मैं देरी है। ");
INSERT INTO thr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","और अपने सेवकन कै पीटन लगै, और पिबक्कड़न के संग खाबै-पीबै। ");
INSERT INTO thr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","तौ बौ सेवक को मालिक ऐसे दिन आगो, जब बौ बाकै असियात नाय होगो, और ऐसी घड़ी कि जोकै बौ ना जानत होगो, ");
INSERT INTO thr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","और बाकै तगड़ी सजा दैकै, बाको भाग कपटियन के संग ठहरागो: हूँना रोनो और दाँत पीसनो होगो।” ");
INSERT INTO thr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“बौ समय स्वर्ग को राज्य ऐसो होगो। एक बार दस कुवाँरी बईंय्यरैं रहैं, जो अपनी तेल की दिया लैकै दुल्हा से मिलन के ताहीं निकरीं। ");
INSERT INTO thr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","उनमैं से पाँच बेअकलन और दुसरी पाँच दिमाकदार रहैं। ");
INSERT INTO thr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","बेअकलन अपनी दिया तौ लईं, पर अपने संग तेल नाय लईं। ");
INSERT INTO thr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पर समझदार अपनी दिया के संग अपनी कुप्पियन मैं तेलौ भर लईं। ");
INSERT INTO thr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जब दुल्हा कै आन मैं देर हुई गई, तौ बे सब उँघान लगी और सोए गईं।” ");
INSERT INTO thr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“आधी रात मैं चहैल-पहैल भइ, कि देखौ, दुल्हा आए रौ है, बासे मिलन कै दुआरे चलौ। ");
INSERT INTO thr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","बहे समय बे सब कुवाँरी उठकै अपनी दिया ठीक करन लगी। ");
INSERT INTO thr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","और बेअकलन समझदारन से कहीं, ‘अपने तेल मैं से थोड़ी हमउँ कै दियौ, काहैकि हमरी दिया बुत रईं हैं।’ ");
INSERT INTO thr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पर जो समझदार रहैं बे जबाब दईं और कहीं कि हमरे और तुमरे ताहीं पूरा ना होगो; भलो तौ जौ है कि, तुम बेचन बारेन के झोने जाएकै अपने ताहीं मोल लै लियौ। ");
INSERT INTO thr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जब बे मोल लेन कै जात रहैं, तौ दुल्हा आए गै, और जो समरी रहैं, बे बाके संग बिहाए कै घरै चली गईं और फाटक बंद कर दौ गौ।” ");
INSERT INTO thr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“जाके बाद बे दुसरी कुवाँरीयौ आयकै कहेन लगी, ‘गुरुजी, गुरुजी, हमरे ताहीं फाटक खोल दे।’ ");
INSERT INTO thr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","बौ जबाब दई, कि मैं तुमसे सच कहथौं, मैं तुमकै नाय जानथौं।” ");
INSERT INTO thr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","और ईसु तोड़ निकारी, “देखौ, काहैकि तुम ना बौ दिन कै जानथौ, ना बौ समय कै।” ");
INSERT INTO thr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“बौ समय स्वर्ग को राज्य ऐसो होगो। एक बार एक आदमी रहै जो एक सफर के ताहीं घर छोड़न बारो रहै; बौ अपने सेवकन कै मस्काई और उनकै अपनी सम्पत्ति सौंप दई। ");
INSERT INTO thr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","बौ अपनी सामर्थ्य के हिसाब से सबन कै दई: एक कै बौ पाँच हजार सोने के सिक्का दई, दुसरे कै बौ दुई हजार दई, और तिसरे कै बौ एक हजार दई। फिरौंकी बौ अपने सफर मैं निकर गौ। ");
INSERT INTO thr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","जो सेवक कै पाँच हजार सिक्का मिले रहैं, बौ एकै बार मैं पाँच हजार पैसा लगाई और पाँच हजार कमाई। ");
INSERT INTO thr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","बैसिये जो सेवक कै दुई हजार सिक्का मिले रहैं, बौ दुई हजार और कमाई। ");
INSERT INTO thr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पर जो सेवक कै एक हजार सिक्का मिले रहैं, बौ चलो गौ, और जमीन मैं एक गड्डा खोदी और अपने मालिक के पैसा लुकाए दई।” ");
INSERT INTO thr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“लंबे समय के बाद बे सेवकन को मालिक बापस लौटो और बौ उनसे हिसाब लेन लगो। ");
INSERT INTO thr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जोकै पाँच हजार मिले रहैं, बौ पाँच हजार और लायकै कही, ‘मालिक, तैं मोकै पाँच हजार सिक्का सौंपो रहै, देख मैं पाँच हजार सिक्का और कमाओ हौं।’ ");
INSERT INTO thr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","बाको मालिक बासे कही, ‘धन्य है अच्छो और बिस्वास के काबिल सेवक, तैं थोड़ी मैं बिस्वास के काबिल रहो; मैं तोकै तमान चीजन को हकदार बनांगो। अपने मालिक की खुसी मैं मिल जा।’ ");
INSERT INTO thr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","फिरौंकी जो सेवक कै दुई हजार सिक्का दै गै रहैं, बौ आओ और कही, ‘मालिक तैं मोकै दुई हजार के सिक्का दौ रहै, देख! हींना एक और दुई हजार हैं जोमैं कमाओ हौं।’ ");
INSERT INTO thr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","बाको मालिक बासे कही, ‘धन्य है अच्छो और बिस्वास के काबिल सेवक, तैं थोड़ी मैं बिस्वास के काबिल रहो, मैं तोकै तमान चीजन को हकदार बनांगो अपने मालिक की खुसी मैं मिल जा।’ ");
INSERT INTO thr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","तौ एक हजार सिक्का जोकै मिले रहैं, बौ आए कै कही, ‘मालिक, मैं तोकै जानथौं कि तैं कड़क आदमी है; जब तैं पौधा ना लगाथै तहुँओं फसल काटथै, और तैं बौ फसल कै इखट्टो करथै जितै तैं बीज ना बखेरो रहै। ");
INSERT INTO thr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","तभई मैं डराय गौ और जाएकै तेरे सिक्का जमीन मैं लुकाए दौ; देख, जो तेरो है, बौ जौ है।’ ");
INSERT INTO thr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","बाको मालिक बाकै जबाब दई, कि तैं बुरो और आलसी सेवक; जब तैं जौ जानत रहै, कि जितै मैं नाय बोथौं हूँना से काटथौं; और जितै मैं नाय बखेरो हूँना से बटोरथौं। ");
INSERT INTO thr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","तौ फिर ठीक है, तोकै मेरो पैसा बैंक मैं जमा करनो चहाईये रहै, और मोकै जौ सब ब्याज समेत बापस मिल जातो। ");
INSERT INTO thr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","अब, बे सिक्का बासे छीन लियौ, और बाके झोने दस सिक्का हैं, बाकै दै दियौ। ");
INSERT INTO thr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","जो कोई के पास है बाकै और दौ जागो; और बाके पास भौत हुई जागो: पर जोके पास नाय है, बासे बहो जो बाके पास है छीन लौ जागो। ");
INSERT INTO thr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","जौ निकम्मो सेवक कै बहार के अंधियारे मैं डार दियौ, जितै रोनो और दाँत पीसनो होगो।” ");
INSERT INTO thr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“जब इंसान को लौड़ा अपनी महिमा मैं आगो, और बाके संग सब स्वर्गदूत आंगे तौ बौ अपनी महिमा के सिंहासन मैं बैठैगो। ");
INSERT INTO thr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","और सब जाति बाके अग्गु जुरांगी; और जैसी बरदिया भेंड़न कै बकरियन के बच्चा से अलग कर देथै, बैसिये बौ उनकै एक दुसरे से अलग करैगो। ");
INSERT INTO thr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","बौ भेंड़न कै अपने दहने और बकरियन कै अपने बाँए रखैगो। ");
INSERT INTO thr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तौ राजा अपने दहने घाँईं बारेन से कहैगो, ‘मेरे परम दऊवा के धन्य आदमियौ, तुम आबौ, बौ राज्य के हकदार हुई जाबौ, जो दुनिया के सुरु से तुमरे ताहीं समारो गौ है। ");
INSERT INTO thr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","मोकै भूंक लगी रहै, तुम मोकै खानु खबाए; मोकै प्यास लगी रहै, तुम मोकै पानी पिबाए, मैं परदेसी रहौं, तुम मोकै अपने घरै रखाए। ");
INSERT INTO thr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","मैं नंगो रहौं, तुम मोकै लत्ता पैंहदाए; मैं बिमार रहौं, तुम मेरी खबर लै, मैं कैदखाना मैं रहौं, तुम मोसे मिलन आए।’ ");
INSERT INTO thr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तौ धर्मी बाकै जबाब देंगे, ‘प्रभु हम कब तोकै भूंको देखे और खबाए? या प्यासो देखे और पानी पिबाए? ");
INSERT INTO thr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हम कब तोकै परदेसी देखे और अपने घर मैं रखाए या नंगो देखे, और लत्ता पैंहदाए? ");
INSERT INTO thr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","हम कब तोकै बिमार या कैदखाना मैं देखे और तोसे मिलन आए?’ ");
INSERT INTO thr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तौ राजा उनकै जबाब देगो, ‘मैं तुमसे सच कहथौं, कि तुम जो मेरे जे छोटे से छोटे भईय्यन मैं से कोई एक के संग करे, बौ मेरिये संग करे!’” ");
INSERT INTO thr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“तौ बौ बाँए घाँईं बारेन से कहैगो, ‘स्रापित आदमियौं मेरे अग्गु से बौ अनंत आगी मैं चले जाबौ, जो सैतान और बाके दूतन के ताहीं तैयार करी गई हैं। ");
INSERT INTO thr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","काहैकि मैं भूंको रहौं, और तुम मोकै खान कै ना दै, मैं प्यासो रहौं, तुम मोकै पानी ना पिबाए; ");
INSERT INTO thr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मैं परदेसी रहौं, तुम मोकै अपने घरै ना रुकन दै; मैं नंगो रहौं, तुम मोकै लत्ता ना पैंहदाए; मैं बिमार और कैदखाना मैं रहौं, तुम कब मेरी खबर लै।’” ");
INSERT INTO thr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“तौ बे जबाब देंगे, ‘प्रभु, हम तोकै कब भूंको, या प्यासो, या परदेसी, या नंगो, या बिमार, या कैदखाना मैं देखे, और तेरी मदत ना करे?’ ");
INSERT INTO thr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तौ राजा उनकै जबाब देगो, ‘मैं तुमसे सच कहथौं कि तुम जो जे छोटे से छोटे मैं से कोई एक कै संग नाय करे, बौ मेरे भी संग नाय करे।’ ");
INSERT INTO thr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","फिरौंकी इनकै अनंत सजा भोगने पड़ैगो पर धर्मी हमेसा की जिंदगी पांगे।” ");
INSERT INTO thr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जब ईसु जे सब बात कह चुको, तौ अपने चेलन से कहेन लगो, ");
INSERT INTO thr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुम जानथौ, कि दुई दिन के बाद फसह को त्योहार होबैगो; और इंसान को लौड़ा क्रूस मैं चढ़ाओ जान के ताहीं पकड़बाओ जागो।” ");
INSERT INTO thr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तौ मुखिया पुजारी और परजा के बड़े-बूढ़े कैफा नाओं के मुखिया पुजारी के आँगन मैं जुराने, ");
INSERT INTO thr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","और आपस मैं बतकान लागे कि ईसु कै धोका से पकड़वाए कै मार डारैं। ");
INSERT INTO thr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“पर बे कहेत रहैं, त्योहार के समय नाय; कहीं ऐसो ना होबै कि आदमिन मैं हुल्लड़ मच जाबै।” ");
INSERT INTO thr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जब ईसु बैतनिय्याह मैं सिमौन कोहढ़ी के घरै रहै। ");
INSERT INTO thr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","तौ एक बईय्यर संगमरमर के बर्तन मैं कीमती इत्तर लैकै बाके झोने आई, और जब बौ खानु खान बैठो रहै, तौ बाके मूड़ मैं अखनाए दई। ");
INSERT INTO thr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","जौ देखकै, बाके चेला गुस्सा भै और कहेन लगे, “जौ चीज काहे बरबाद करो?” ");
INSERT INTO thr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“जौ अच्छे रुपईया मैं बेचकै गरीबन कै बाँटो जाए सकथै!” ");
INSERT INTO thr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","जौ देखकै ईसु उनसे कही, “जौ बईय्यर कै काहे परेसान कर्‌रै हौ? बौ मेरे संग भलाई करी है। ");
INSERT INTO thr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब तुमरे संग हमेसा रैहथैं, पर मैं तुमरे संग हमेसा नाय रैहंगो। ");
INSERT INTO thr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","बौ मेरी सरीर मैं जो इत्तर उड़ेली है, बौ मेरे गाड़े जान के ताहीं करी है। ");
INSERT INTO thr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","अब, मैं तुमसे सच कहथौं, कि पूरी दुनिया मैं जितै कहीं जौ सुसमाचार प्रचार करो जागो, हूँना बाके जौ काम की बात बाकै याद करन के ताहीं करो जागो।” ");
INSERT INTO thr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तौ यहूदा इस्करियोती जो बहारै चेलन मैं से एक रहै, मुखिया पुजारी के झोने जाएकै कही, ");
INSERT INTO thr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“अगर मैं बाकै तेरे हात पकड़वाए दियौं, तौ मोकै का देगो?” बौ बाकै तीस चाँदी के सिक्का तौल कै दै दई। ");
INSERT INTO thr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","तौ से यहूदा ईसु कै उनके हवाले करन कै एक अच्छो मौका ढूँड़त रहै। ");
INSERT INTO thr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","अखमीरी रोटी के त्योहार के पहले दिन चेला ईसु के झोने आयकै बासे पूँछीं, “तैं कहाँ चाहथै कि हम तेरे ताहीं फसह को खानु की तैयारी करैं?” ");
INSERT INTO thr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“बौ कही, नगर मैं फलाने के झोने जाएकै बासे कह, कि गुरु कहथै, कि मेरो समय झोने है, मैं अपने चेलन के संग तेरे हींना फसह मनांगो।” ");
INSERT INTO thr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ईसु जैसी बताई रहै, चेला फसह के खानु की तैयारी करीं। ");
INSERT INTO thr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जब संजा खिन भइ, तौ बौ बहारै चेलन के संग खानु खान के ताहीं बैठो। ");
INSERT INTO thr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जब बे खात रहैं, तौ ईसु कही, “मैं तुमसे सच कहथौं, कि तुम मैं से एक मोकै पकड़बागो।” ");
INSERT INTO thr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","जौ बात से बे बड़ा उदास भै, और बासे पूँछन लागे, “गुरुजी, का बौ मैं हौं?” ");
INSERT INTO thr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ईसु जबाब दई, “जो मेरे संग थरिया मैं हात डारी है, बहे मोकै पकड़बागो। ");
INSERT INTO thr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","जैसी इंसान के लौड़ा के बारे मैं लिखो है, बौ जौ दुनिया से जाथै; पर बौ इंसान के ताहीं भयानक है जोके जरिया इंसान को लौड़ा पकड़बाओ जाथै: अगर बौ इंसान को जनम ना होतो, तौ बाके ताहीं भलो होतो!” ");
INSERT INTO thr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तौ बाको पकड़वान बारो यहूदा पूँछी, “हे रब्बी, का बौ मैं हौं?” ईसु जबाब दई, “तैं कह लौ।” ");
INSERT INTO thr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जब बे खात रहैं, तौ ईसु रोटी लई, और आसीस माँग कै तोड़ी, और चेलन कै दैकै कही, “लियौ, खाबौ; जहे मेरी सरीर है।” ");
INSERT INTO thr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","फिर बौ कटोरा लई और धन्यवाद करी, और उनकै दैकै कही, “तुम सब जामैं से पीबौ, ");
INSERT INTO thr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","काहैकि जौ मेरो वाचा को खून है, जो निरेन के ताहीं पापन की माफी के ताहीं बहाओ जाथै। ");
INSERT INTO thr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","मैं तुमसे कहथौं, कि जौ दाखरस बौ दिन ले कहु ना पींगो, जबले तुमरे संग अपने दऊवा के राज्य मैं नया ना पीमौं।” ");
INSERT INTO thr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","फिरौंकी बे गाना गायकै जैतून के पहाड़ मैं गै। ");
INSERT INTO thr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तौ ईसु उनसे कही, “आज की रात तुम सब भाज जाबैगे, और मोकै छोड़ देगे, काहैकि सास्त्र कहथै, ‘परमेस्वर बरदिया कै मार देगो और झुंड की भेंड़ैं बिगद जांगी।’ ");
INSERT INTO thr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","लेकिन जब मैं जिंदो हुई जांगो, तौ तुमसे पहले गलील जांगो।” ");
INSERT INTO thr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","पर पतरस बासे कही, “अगर सब तोकै छोड़ैं तौ छोड़ैं, पर मैं कहु ना छोड़ंगो।” ");
INSERT INTO thr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ईसु पतरस से कही, “मैं तोसे सच कहथौं की आज रात मुर्गा बोलन से पहले तैं तीन बारो कहैगो कि मैं जाकै ना जानथौं।” ");
INSERT INTO thr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरस जबाब दई, “जौ मैं कहु ना कहेंगो, भलेई मोकै तेरे संग मरन पड़ै!” और बाकी के चेलौ जहे कहीं। ");
INSERT INTO thr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तौ ईसु अपने चेलन के संग गतसमनी नाओं की जघा मैं गौ, और बौ उनसे कही, “मैं हींना बैठकै प्रार्थना कर रौ हौं।” ");
INSERT INTO thr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","बौ अपने संग पतरस और जब्दी के लौड़ा कै लैगौ, दुखी और परेसान होन लगो। ");
INSERT INTO thr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","और बौ उनसे कही, “मेरो मन भौत उदास है, हिंयाँ ले कि मेरी ज्यान निकरी जाए रई है। तुम हीनैं रुकौ, और मेरे संग जगत रहाबौ।” ");
INSERT INTO thr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","फिर बौ थोड़ी और अग्गु बढ़कै मोखरा गिरो, और ऐसे प्रार्थना करन लगो, “मेरे दऊवा, अगर हुई सकै, तौ जौ कटोरा मोसे टल जाबै, फिर भी जैसी मैं चाहथौं बैसो नाय, पर जैसी तैं चाहथै बैसो होबै।” ");
INSERT INTO thr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","फिर चेलन के झोने आयकै उनकै सोत भौ पाई, और पतरस से कही, “का तुम मेरे संग घंटा भर ना जग सके? ");
INSERT INTO thr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जगत रहाबौ, और प्रार्थना करत रहाबौ, कि तुम परिक्छा मैं ना पड़ो! आत्मा तौ तैयार है, पर सरीर कमजोर है।” ");
INSERT INTO thr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","फिरौंकी बौ दुसरी बार जाएकै प्रार्थना करी, “मेरे दऊवा, अगर जौ मेरे पिये बगैर ना हट सकथै तौ तेरी इच्छा पूरी होबै।” ");
INSERT INTO thr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तौ बौ आयकै उनकै फिरौंकी सोत पाई, काहैकि उनकी आँखी निंधानि रहैं। ");
INSERT INTO thr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","और उनकै छोड़कै फिरौंकी चलो गौ, और बहे बात कहकै, तिसरी बार प्रार्थना करी। ");
INSERT INTO thr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तौ बौ चेलन के झोने आयकै उनसे कही, “अब सोत रहाबौ, और आराम करौ: देखौ, समय आए पहोंचो है, और इंसान को लौड़ा पापिन के हात से पकड़बाओ जाथै। ");
INSERT INTO thr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठौ, चलैं; देखौ, मेरो पकड़वान बारो झोने आए पहोंचो है।” ");
INSERT INTO thr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","बौ जौ कहतै रहै कि, यहूदा जो बहारैयन मैं से एक रहै, आओ, और बाके संग मुखिया पुजारिन और आदमिन के बड़े-बूढ़ेन के घाँईं से बड़ी भीड़, तलवारन और लठियन कै लै भै आए। ");
INSERT INTO thr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","बाको पकड़वान बारो उनकै जौ चिन्ह बताए दई रहै: “जोकै मैं चूम लियौं बहे है; बाकै पकड़ लियो!” ");
INSERT INTO thr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","यहूदा तुरंतै ईसु के झोने आयकै कही, “रब्बी, नमस्ते!” और बाकै चुम्मी लई। ");
INSERT INTO thr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ईसु जबाब दई, “दोस्त, जो काम के ताहीं तैं आओ है, बाकै कर ले।” तौ बे झोने आयकै ईसु के ऊपर हात डारी और बाकै पकड़ लईं। ");
INSERT INTO thr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","तौ ईसु के संग बारेन मैं से एक हात बढ़ायकै अपनी तलवार खींची और बड़े पुजारी के सेवक ऊपर चलाय कै बाको कान काट दई। ");
INSERT INTO thr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तौ ईसु बासे कही, “अपनी तलवार हूँनै रख ले काहैकि जो तलवार चलाथैं, बे सब तलवार से नास करे जांगे। ");
INSERT INTO thr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","का तैं ना समझथै, कि मैं अपने दऊवा से नहोरे कर सकथौं, और बौ स्वर्गदूतन की बहारै सेना दल से जद्धे मेरे झोने हबइ भेज देगो? ");
INSERT INTO thr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पर पवित्र सास्त्र की बे बातैं कि ऐसोई होनो जरूरी है, कैसे पूरी होंगी?” ");
INSERT INTO thr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","बहे समय ईसु भीड़ से कही, “का तुम तलवार और लठिया लैकै मोकै डाँकुअन के हानी पकड़न के ताहीं निकरे हौ? मैं सब दिन मंदिर मैं बैठकै उपदेस देत रहौं, और तुम मोकै ना पकड़े। ");
INSERT INTO thr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","पर जौ सब तभई भौ है, कि भविस्यवक्ता पवित्र सास्त्र मैं जो कुछ लिखो है बौ पूरो होबै।” तौ सब चेला बाकै छोड़कै भाज गै। ");
INSERT INTO thr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","जो आदमी ईसु कै गिरफ्तार करीं रहैं, बे बाकै कैफा के घरै, बड़े पुजारी के झोने लैगै जितै यहूदि नियम के सिक्छक और बड़े-बूढ़े जुराने रहैं। ");
INSERT INTO thr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","पतरस दूर से बाको पीछा करी जितै ले बड़े पुजारी को आँगन रहै बौ आँगन मैं गौ और सिपईय्यन संग बैठकै जौ देखन लागो कि अब बौ कैसे निकरैगो। ");
INSERT INTO thr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","मुखिया पुजारी और पूरे बड़े सभा के ईसु कै मार डारन के ताहीं बाके बिरोध मैं झूठे सबूत ढूँड़न लगे। ");
INSERT INTO thr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पर भौत से झूठे गभन के आन मैं भी ना पाई, आखरी मैं दुई जनी आए, ");
INSERT INTO thr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","और कही, “जौ कही कि मैं परमेस्वर के मंदिर कै ढ़ाय सकथौं और बाकै फिर से तीन दिन मैं बनाये सकथौं।” ");
INSERT INTO thr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","बड़ो पुजारी ठाड़कै ईसु से कही, “का तेरे पास जौ आरोप को कोई जबाब ना है?” ");
INSERT INTO thr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पर ईसु चुप्पा रहो। तौ बड़ो पुजारी बासे कही “मैं तोकै जिंदे परमेस्वर की कसम देथौं, कि अगर तैं परमेस्वर को लौड़ा मसीह है, तौ हमसे कहदे।” ");
INSERT INTO thr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ईसु बासे कही, “तैं खुदै कह दौ; बल्किन मैं तुमसे जहो कहथौं, कि अब से तुम इंसान के लौड़ा कै सर्वसक्तिमान के दहने घाँईं बैठे, और आसमान के बादर मैं आत देखैगे।” ");
INSERT INTO thr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","तौ बड़ो पुजारी अपने लत्ता फाड़कै कही, “जौ परमेस्वर की बुराई करी है, अब हमकै गभा की कोई जरूरत ना है! देखौ, तुम हबै जौ बुराई सुने हौ! ");
INSERT INTO thr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुम का समझथौ?” बे जबाब दई, “जौ मौत की सजा पान के काबिल है।” ");
INSERT INTO thr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तौ बे बाके मोहों मैं थूकीं और बाकै घूँसा मारी, दुसरे चाँटा मारकै ");
INSERT INTO thr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","कहीं, “मसीह! हमरे ताहीं भविस्यवाँड़ी करकै कह कि कौन तोकै मारी!” ");
INSERT INTO thr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस बहार आँगन मैं बैठो रहै कि बड़े पुजारी की एक सेविका बाके झोने आयकै कही, “तहूँ ईसु गलीली के संग रहै।” ");
INSERT INTO thr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","बौ सबके सामने जौ कहकै मना करी और कही, “मैं ना जानथौं तू का कह रइ है।” ");
INSERT INTO thr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","और जब बौ बहार फाटक के मोहोंट झोने गौ, तौ दुसरी बईय्यर बाकै देखकै उनसे जो हूँना रहैं कही, “जहो तौ ईसु नासरी के संग रहै।” ");
INSERT INTO thr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","पतरस फिरौंकी जबाब दई, “मैं कसम खाथौं कि जौ इंसान कै नाय जानथौं!” ");
INSERT INTO thr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","थोड़ी देर बाद हूँना ठाड़े भै पतरस के झोने आए। “बे कहीं, सच मैं तैं उनमैं से एक है। काहैकि तेरे बोलन के ढंग से पता चल रौ है!” ");
INSERT INTO thr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","पतरस कही, “मैं कसम खाथौं कि मैं सच्ची कहरौ हौं! अगर मैं नाय हौं तौ परमेस्वर मोकै सजा देमैं! मैं बौ आदमी कै नाय जानथौं!” तभईये एक मुर्गा बास दई, ");
INSERT INTO thr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","पतरस कै याद आओ कि ईसु बासे का कही रहै: “मुर्गा बासन से पहले, तैं तीन बार कहैगो कि मोए ना जानथै।” बौ बहार गौ और बिलक-बिलक कै रोन लगो। ");
INSERT INTO thr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","सुबेरे-सुबेरे सबै मुखिया पुजारी और बड़े-बूढ़े ईसु कै मौत के घाट उतारन के ताहीं तरकीब सोचीं। ");
INSERT INTO thr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","बे बाकै जंजीरन से भाँद दईं, और रोमन राज्यपाल पिलातुस कै सौंप दईं। ");
INSERT INTO thr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जब धोकेबाज, यहूदा कै मालुम भौ कि ईसु की बुराई करी गई है, तौ बौ पछताई और मुखिया पुजारिन और बड़े-बूढ़ेन के तीस चाँदी के सिक्का बापस लौटाय दई। ");
INSERT INTO thr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","बौ कही, “मैं एक निर्दोस आदमी के खून कै धोका दैकै पाप करो हौं!” बे जबाब दईं। “हमैं जासे का? जौ तौ तेरो काम है!” ");
INSERT INTO thr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","यहूदा सिक्कन कै मंदिर मैं खेंप कै हूँनै छोड़ दई; फिरौंकी बौ हूँना से चले गौ और फाँसी खाएकै लटक गौ। ");
INSERT INTO thr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","मुखिया पुजारी सिक्कन कै उठाईं और कहीं, “जौ खून को पैसा है, और जाकै मंदिर मैं रखनो नियम के खिलाप है।” ");
INSERT INTO thr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","तभई बे विदेसियन के ताहीं दफनान बारी जघा के रूप मैं कुम्हरा के खेत कै खरीदन ताहीं पैसा कै इस्तमाल करन को फैसला करीं। ");
INSERT INTO thr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","जहे के बजह से जौ जघा कै, जहे दिन से “खून को खेत” कहो जाथै। ");
INSERT INTO thr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तौ भविस्यवक्ता यिर्मयाह जो कही रहै, बौ सच मैं पूरो भौ: “बे तीस चाँदी के सिक्का के ताहीं, इस्राएल के आदमी बाके ताहीं भुगतान करन के ताहीं मान गै, ");
INSERT INTO thr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","और जैसी प्रभु मोकै आग्या दई रहै बैसिये उनकै कुम्हरा के खेत कै मोल दै दईं।” ");
INSERT INTO thr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ईसु रोमन हाकीम के अग्गु ठाड़ो रहै, जो बासे पूँछी। “का तैं यहूदियन को राजा है? ईसु जबाब दई, तैं खुदै कहरौ है।” ");
INSERT INTO thr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","लेकिन बौ मुखिया पुजारिन और बड़े-बूढ़ेन के दोस लगान पर भी कछु नाय कही। ");
INSERT INTO thr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","तौ पिलातुस बासे कही, “का तैं जे सब बातन कै नाय सुनथै जो बे तेरे ऊपर दोस लगाथैं?” ");
INSERT INTO thr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","लेकिन ईसु एक भी सब्द को जबाब देन से मना कर दई, जोके फलस्वरूप हाकिम भौत चकित भौ। ");
INSERT INTO thr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","हर फसह के त्योहार मैं रोमन हाकिम कोई भी एक कैदी कै भीड़ के ताहीं छोंड़े करत रहै। ");
INSERT INTO thr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","बौ समय ईसु बरअब्बा नाओं को एक नामी कैदी रहै। ");
INSERT INTO thr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","जब भीड़ जुरानी तौ पिलातुस उनसे पूँछी, “तुम कौनकै चाहथौ कि मैं तुमरे ताहीं छोड़ो? बरअब्बा कै या ईसु जो मसीहा कहो जाथै?” ");
INSERT INTO thr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","बौ अच्छी तरहन से जानत रहै कि यहूदि नेता ईसु कै बाकै सौंप दईं रहैं काहैकि बे जले करत रहैं। ");
INSERT INTO thr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जब पिलातुस न्याय की सभा मैं बैठो रहै, तौ बाकी बईय्यर बाकै एक खबर भेजी: “बौ बेकसूर आदमी से मतलब मत रखै, काहैकि कल रात एक सपने मैं, मैं बाके बारे मैं भौत कछु सोचो रहौं।” ");
INSERT INTO thr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","मुखिया पुजारी और बड़े-बूढ़े भीड़ कै राजी करीं ताकी पिलातुस बरअब्बा कै छोड़ देबै, और ईसु के मार डारैं। ");
INSERT INTO thr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","पर पिलातुस भीड़ से पूँछी, “तुम कौनकै चाहथौं कि मैं बाकै तुमरे ताहीं छोड़ो?” बे जबाब दईं। “बरअब्बा!” ");
INSERT INTO thr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“पिलातुस उनसे पूँछी, तौ मैं ईसु के संग का करौं जो मसीह कहबाओ जाथै?” बे सब जबाब दईं। “बाकै क्रूस मैं टाँगौ!” ");
INSERT INTO thr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पर पिलातुस पूँछी, “बौ का गुनाह करी है?” तौ बे अपनी अबाज ऊँची करीं और चिल्लान लगे: “बाकै क्रूस मैं टाँग!” ");
INSERT INTO thr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जब पिलातुस देखी कि कुछ हुइये नाय रौ है, पर हुड़दंग मच सकथै, तौ बौ भीड़ के अग्गु पानी लैकै अपने हात धोई, और कही, “मैं जौ आदमी के खून को दोसी ना हौं! तुम्हईं जानौ!” ");
INSERT INTO thr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","पूरी भीड़ जबाब दई, “बाके खून को जिम्मेदार हम पर और हमरे बालकन ऊपर है!” ");
INSERT INTO thr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","फिर पिलातुस बरअब्बा कै खाली-मूली छोड़ दई; और ईसु कै कोड़े लगबाए कै सौंप दईं, कि क्रूस मैं चढ़ाओ जाबै। ");
INSERT INTO thr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","तौ पिलातुस के सिपईय्या ईसु कै हाकीम के महल मैं लैगै, और पूरो झुंड बाके चारौ तरफ जुराए गौ। ");
INSERT INTO thr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","बे बाके लत्ता उतार दईं, और लाल रंग को चोंगा पैंधाय दईं। ");
INSERT INTO thr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","तौ बे कांटेदार झाड़ी की हँगईय्या से एक मुकुट बनाईं और बाके मूड़ मैं रख दईं, और बाके दहने हात मैं सरकंडा की छड़ी रख दईं; तौ बे बाके अग्गु घुपटियाय कै बाको मजाक उड़ाईं। “बे कहीं यहूदियन के राजा!” जीते रह। ");
INSERT INTO thr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","बे बाके ऊपर थूकीं, और बहे सरकंडा की छड़ी से बाके मूड़ मैं मारीं। ");
INSERT INTO thr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","जब बे बाको मजाक उड़ाईं, बे चोंगा उतार दईं और बहे के लत्ता फिरौंकी से बाकै पैंधाय दईं। तौ बे बाकै क्रूस मैं टाँगीं। ");
INSERT INTO thr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","जब बे बहार जात रहैं, सिमौन नाओं को एक कुरेनी इंसान मिलो, और सिपईय्या जबरजत्ती ईसु को क्रूस उठान कै कहीं। ");
INSERT INTO thr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","बे गुलगुता नाओं की जघा मैं आए, जोको मतलब है, “खुपड़िया की जघा।” ");
INSERT INTO thr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","हूँना बे ईसु कै करवान बारी चीज के संग दाखरस पिबाईं; पर बौ जाकै चीखन के बाद नाय पी। ");
INSERT INTO thr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","बे बाकै क्रूस मैं चढ़ाईं और फिरौंकी पासो खेंप कै आपस मैं लत्ता बाँट लईं। ");
INSERT INTO thr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","जाके बाद बे कितउ बैठकै बाँए देखत रहै। ");
INSERT INTO thr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","बाके मूड़ के ऊपर बे बाके खिलाप इल्जाम को लिखो भौ परचा लगाईं: “जौ ईसु यहूदियन को राजा है।” ");
INSERT INTO thr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तौ बे ईसु के संग दुई डकैतन कै क्रूस मैं चढ़ाईं, एक बाके दहने और दुसरो बाके बाँए। ");
INSERT INTO thr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","झोने से गुजरन बारे आदमी अपनो मूड़ हिलाय और बुराई करत भै ईसु की बेजती करीं: ");
INSERT INTO thr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“तैं मंदिर कै तोड़न और बाकै तीन दिन मैं बनान जात रहै! अगर तैं परमेस्वर को लौड़ा है तौ खुदकै बचा! और क्रूस से उतरेया!” ");
INSERT INTO thr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ऐसियै मुखिया पुजारी और यहूदि नियम के सिक्छक और बड़े-बूढ़े बाको मजाक उड़ाईं: ");
INSERT INTO thr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“बौ दुसरेन कै बचाई, पर खुदकै नाय बचाए सकथै! का बौ इस्राएल को राजा नाय है? अगर अब बौ क्रूस मैं से तरे उतर आगो, तौ हम बाके ऊपर बिस्वास करंगे! ");
INSERT INTO thr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","बौ परमेस्वर के ऊपर भरोसो करथै, और परमेस्वर को लौड़ा होन को दाबा करथै। ठीक है, तौ हम देखथैं की परमेस्वर बाकै बचाथै कि नाय!” ");
INSERT INTO thr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","हिंयाँ ले कि बाके संग क्रूस मैं चढ़े भै डकैतौ बैसिये बाकी बुराई करीं। ");
INSERT INTO thr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","दुपारी कै पूरे देस मैं कुप्प अंधियारो छाए गौ, जो तीन घंटा ले चलत रहो। ");
INSERT INTO thr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","लमसम तीन बजे ईसु जोड़ से चिल्लायकै कही, “एली, एली, लीमा सबकत्तनी?” जोको मतलब है, “मेरे परमेस्वर, मेरे परमेस्वर, तैं मोए काहे छोड़ दौ?” ");
INSERT INTO thr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","“हूँना ठाड़े कुछ आदमी बाकै सुनीं और कहीं, बौ एलिय्याह कै बुलाए रौ है!” ");
INSERT INTO thr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","उनमैं से एक तुरंत भाजो, एक सोकता लई, दाखरस मैं डुबाई, सरकंडा की छड़ी के कोने मैं रखी, और बाके पीन ताहीं बनान की कोसिस करी। ");
INSERT INTO thr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","लेकिन दुसरे कहीं, “रुक जा, हम देखथैं कि का एलिय्याह बाकै बचान कै आए रौ है!” ");
INSERT INTO thr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ईसु फिर जोड़ से चिल्लाई और अपनी जान छोड़ दई। ");
INSERT INTO thr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","तौ मंदिर मैं लटको भौ परदा ऊपर से तरे ले दुई हिस्सन मैं फट गौ। धरती हिल गई, चट्टानैं अलग हुई गईं, ");
INSERT INTO thr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","कबरैं खुल गईं, और परमेस्वर के तमान पवित्र आदमी जो सरीर मैं मर गै रहैं जिंदगी जीन के ताहीं उठ गै। ");
INSERT INTO thr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","बे कबरन कै छोड़ दईं, और ईसु मरन के बाद उठे, बे पवित्र सहर मैं गै, जितै निरे आदमी उनकै देखीं। ");
INSERT INTO thr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","जब ईसु कै देखत पोती सेना को अधिकारी और बाके संग आए सिपईय्या भूकंप और बाकी सब कछु देखीं, बे डराय गै और कहीं, “बौ सचमुच मैं परमेस्वर को लौड़ा रहै!” ");
INSERT INTO thr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","हूँना निरी बईंय्यरैं दूर से देखत रहैं, जो गलील से ईसु को पीछा करी रहैं, और बाकी मदत करी रहैं। ");
INSERT INTO thr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","उनमैं मरियम मगदलीनी, याकूब और यूसुफ की अईय्या मरियम और जब्दी की बईय्यर रहैं। ");
INSERT INTO thr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","जब संजा हुई गई, अरिमतियाह को एक सेठ आदमी आओ; बाको नाओं यूसुफ रहै, और बहे ईसु को चेला रहै। ");
INSERT INTO thr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","बौ पिलातुस के झोने गौ, और ईसु की मृत सरीर कै माँगी। पिलातुस सरीर कै देन की आग्या दई। ");
INSERT INTO thr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","तौ यूसुफ बाकै सरीर कै एक साफ चद्दर मैं लपटे कै लैगौ, ");
INSERT INTO thr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","और बाकै नई कबर मैं धर दई, जोकै बे हबइ कुछ दिन पहले ठोस चट्टान मैं खोदी रहैं। फिरौंकी बौ कबर के मोहोंट मैं एक बड़ो सो पथरा लुढ़काई और चले गौ। ");
INSERT INTO thr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मगदलीनी और दुसरी मरियम हूँना, कबर के अग्गु बैठी रहैं। ");
INSERT INTO thr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","अगले दिन, साबत को दिन रहै, मुखिया पुजारी और फरीसी पिलातुस से मिले ");
INSERT INTO thr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","और कहीं, “गुरुजी, हमैं याद है कि जब बौ झूठो जिंदो रहै तहुँओं बौ कही रहै, ‘मैं तीन दिन बाद जी उठंगो।’ ");
INSERT INTO thr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","आग्या दे, फिरौंकी से तिसरे दिन ले बाकी कबर की ध्यान से रखबारी करन के ताहीं, ताकी बाके चेला सरीर कै चुराय कै ना लै जाए सकैं, और फिरौंकी आदमिन से कहमैं कि बौ जी उठो है। जौ आखरी झूठ पहले बारे सेऊ बत्तर होगो।” ");
INSERT INTO thr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुस उनकै बताई “एक सिपईय्या लेबौ,” और “जाबौ जित्तो हुई सकै कबर की रखबारी करौ।” ");
INSERT INTO thr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","तभई बे पथरा मैं एक मुहर लगाएकै और पहरेदारन कै ध्यान से कबर की रखबारी करन कै छोड़ीं। ");
INSERT INTO thr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","साबत के बाद, जैसो की इतवार सप्ताह को पहलो दिन रहै, मरियम मगदलीनी और दुसरी मरियम कबर कै देखन गईं। ");
INSERT INTO thr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","अनकाचीति से एक खतरनाक भूकंप आओ; स्वर्ग से उतरो प्रभु को एक दूत, पथरा कै हटाय दई, और बाके ऊपर बैठगौ। ");
INSERT INTO thr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","बाको रूप बिजली के हानी रहै, और बाके लत्ता बरफ के हानी सफेद रहैं। ");
INSERT INTO thr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","रखबरेया इत्ते डराने भै रहैं कि बे कप-कपाय गै और बेजान आदमी से हुईगै। ");
INSERT INTO thr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","स्वर्गदूत बईंय्यरन से बतकाईं। बे कहीं, “तुम डराबौ मत्ती, मोए पता है कि तुम ईसु कै ढूँड़ रै हौ, जोकै क्रूस मैं चढ़ाय दौ गौ रहै। ");
INSERT INTO thr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","बौ हिंयाँ नाय है; और बे कहीं, पर अपने बचन के अनुसार जी उठो है। हिंयाँ आयकै देख लियौ, जितै बौ लेटो रहै। ");
INSERT INTO thr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अब जल्दी जाबौ, और बे चेलन से कहबौ, ‘कि बौ मरे भैन मैं से जी उठो है, और अब बौ तुमसे पहले गलील जाएरौ है; हूँना तुम बाकै देखैगे!’ याद रैहबै कि मैं तुमकै का बताओ हौं।” ");
INSERT INTO thr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","तभई बे जल्दी बाजी मैं कबर से चले गईं, डरानि और खुसी से भरी चेलन कै बतान कै भाज पड़ीं। ");
INSERT INTO thr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","अनकाचीति ईसु उनसे मिलो और कही, “तुमकै सांति मिलै।” बे बाके झोने आए, और घुपटियाय कै, बाकी आराधना करीं। ");
INSERT INTO thr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ईसु उनसे कही “डराबौ मत्ती, जाबौ और मेरे भईय्यन कै गलील मैं जानकै कहबौ, और हूँना तुम मोकै देखैगे।” ");
INSERT INTO thr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","जब बईंय्यरैं अपनी रहा कै चली गईं, कबर की रखबारी करन बारे कुछ सिपईय्या सहर बापस चले गै और मुखिया पुजारिन कै जो हूँना भौ रहै सब कछु बताए दईं जो भौ रहै। ");
INSERT INTO thr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","मुखिया पुजारी बड़े-बूढ़ेन से मिले और योजना बनाईं; बे सिपईय्यन कै भौत रुपईया दईं ");
INSERT INTO thr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","और कही, “तुम कहियो कि बाके चेला रात के समय आए रहैं और जब तुम सोत रहौ तौ बे बाको सरीर चुराय लैगै रहैं। ");
INSERT INTO thr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","और अगर राज्यपाल कै सुननो चहाईये, हम बाकै समझाए देंगे कि तैं निर्दोस है, और तुमकै चिंता करन की कोई जरूरत नाय होगी।” ");
INSERT INTO thr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","रखबरेया पैसा लई और बहे करी जो बाकै करन कै कहो गौ रहै। और तभई जौ बात यहूदियन के जरिया आज ले मानी जाए रइ है। ");
INSERT INTO thr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ईसु के ग्यारह चेला गलील के बौ पहाड़ मैं गै जितै जान के ताहीं बौ कही रहै। ");
INSERT INTO thr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","जब बे बाकै देखीं, बे बाकी आराधना करीं, हालाकि उनमैं से कुछन कै संका रहै। ");
INSERT INTO thr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ईसु झोने जाएकै उनसे कही, “मोकै स्वर्ग और पृथ्वी मैं सबै अधिकार दै गै हैं। ");
INSERT INTO thr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","तौ, सब जघा सब आदमिन के झोने जाबौ और उनकै मेरे चेला बनाबौ: दऊवा, लौड़ा और पवित्र आत्मा के नाओं से बपतिस्मा देबौ, ");
INSERT INTO thr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","और जो कछु मैं आग्या दौ हौं बाकै मानन कै सिखाबौ। और मैं दुनिया के अंत ले हमेसा तुमरे संग रहांगो।”");
INSERT INTO thr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","परमेस्वर को लौड़ा ईसु मसीह के सुसमाचार की सुरुवात। ");
INSERT INTO thr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जैसो यसायाह भविस्यवक्ता भविस्यवाँड़ी करन बारे की किताब मैं लिखो है “परमेस्वर कही, ‘देख मैं अपने दूत कै तेरे अग्गु पनारथौं, जो तेरे ताहीं रहा सुधारैगो।’ ");
INSERT INTO thr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","बन मैं एक पुकारन बारे की अबाज सुनाई दई है, ‘कि प्रभु के ताहीं रहा बनाबौ; और बाकी रहा सीधी करौ!’” ");
INSERT INTO thr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","यूहन्ना बन मैं आओ, और बौ प्रचार करकै आदमिन से कहेन लागो, “अपने पापन से मन फिराबौ और बपतिस्मा लेबौ तभईये परमेस्वर तुम्हारे पापन से तुमकै माफ करैगो।” ");
INSERT INTO thr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","तौ यहूदिया देस के और यरूसलेम सहर के सबै रहेन बारे निकरकै बाके झोने आए, और अपने पापन कै मानकै यरदन नदिया मैं बासे बपतिस्मा लईं। ");
INSERT INTO thr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्ना ऊँट के खाल के लत्ता पहनत रहै और अपने करिहाँओं मैं चमड़ा को कमरबंद भाँदे रहेत रहै, और बौ टींड़ा और बन को सहद खाए करत रहै, ");
INSERT INTO thr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","और जौ बात को प्रचार करत रहै, “कि मेरे बाद जो आनबारो है, बौ महुँ से ताकतवर है, मैं लोहोक्कै बाके जूता की तनी खोलनौ लायक नाय हौं। ");
INSERT INTO thr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मैं तौ तुमकै पानी से बपतिस्मा दौ हौं, पर बौ तुमकै पवित्र आत्मा से बपतिस्मा देबैगो।” ");
INSERT INTO thr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","बेईं दिनन ईसु गलील देस के नासरत नगर से आए कै, यरदन नदिया मैं यूहन्ना से बपतिस्मा लई। ");
INSERT INTO thr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","और जब ईसु पानी से निकरकै ऊपर आओ, तौ बौ बहे समय कै स्वर्ग खुलत और आत्मा कै कबूतर के हानी अपने ऊपर उतरत भौ देखी। ");
INSERT INTO thr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","और स्वर्ग से एक अबाज आई, “तू मेरो प्रिय लौड़ा है, तोसे मैं बड़ा खुस हौं।” ");
INSERT INTO thr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तौ पवित्र आत्मा बाकै तुरंतै बन घाँईं पनार दई। ");
INSERT INTO thr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","और बन मैं चालीस दिन ले, सैतान बाकै लालच देत रहो। और बौ बन के जानवरन के संग रहो, और स्वर्गदूत बाकी सेवा करत रहे। ");
INSERT INTO thr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","यूहन्ना के पकड़वाए जान के बाद ईसु गलील मैं आयकै परमेस्वर के राज्य को सुसमाचार को प्रचार करी, ");
INSERT INTO thr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","और कही, “समय पूरो हुई गौ है, और परमेस्वर को राज्य झोने आए चुको है; मन बदलौ और सुसमाचार मैं बिस्वास करौ।” ");
INSERT INTO thr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ईसु गलील देस की झील के डींड़े-डींड़े जात भै, बौ सिमौन और बाके भईय्या अन्द्रियास कै झील मैं जार डारत देखी; काहैकि बे मछरेया रहैं। ");
INSERT INTO thr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ईसु उनसे कही, “मेरे पच्छू आबौ; मैं तुमकै परमेस्वर के झोने कैसे आदमिन कै लाथैं बौ सिखांगो।” ");
INSERT INTO thr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","बे तुरंतै जार कै छोड़कै बाके पच्छू हुई लईं। ");
INSERT INTO thr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","और जरा सो अग्गु पुगकै, ईसु जब्दी के लौड़ा याकूब, और बाके भईय्या यूहन्ना कै, अपनी नईंयाँ मैं जार कै सुरजात भै देखी। ");
INSERT INTO thr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","बौ तुरंतै उनकै मस्काई; और बे अपने दऊवा जब्दी कै मजदूरन के संग नईंयाँ मैं छोड़कै, बाके पच्छू हुई लईं। ");
INSERT INTO thr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","तौ फिर ईसु और बाके चेला कफरनहूम सहर मैं आए, और बौ तुरंतै साबत के दिन सभाघर मैं जाएकै उपदेस देन लागो। ");
INSERT INTO thr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","और लोग बाके उपदेस से चौहोंक गै; काहैकि बौ उनकै यहूदि नियम के सिक्छक के हानी नाय, बल्किन अपने अधिकार से उपदेस देत रहै। ");
INSERT INTO thr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","और बहे समय, उनके सभाघर मैं एक आदमी रहै, जोके भीतर प्रेत आत्मा सटकी रहै। ");
INSERT INTO thr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","बौ चिल्लाए कै कही, “हे ईसु नासरी, हमकै तोसे का काम? का तू हमकै नास करन कै आओ है? मैं तोकै जानथौं, तू कौन है? तू परमेस्वर को पवित्र आदमी है!” ");
INSERT INTO thr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ईसु बाकै झुकाएकै कही, “चुप्पा रहे; और बाके भीतर से निकर जा।” ");
INSERT INTO thr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तौ प्रेत आत्मा बाकै ऐंठाएकै, और बड़ा जोड़ से किक्याए कै बाके भीतर से निकर गौ। ");
INSERT INTO thr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","जौ देखकै सब जनी चौहोंक गै, और सब आपस मैं बहस करन लग्गै, “कि जौ का बात है? जौ तौ अनोखो उपदेस है! बौ तौ अधिकार से प्रेत आत्मा कै आग्या देथै, और प्रेत आत्मा बाकी बात मानथैं।” ");
INSERT INTO thr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","और ईसु को नाओं तुरंतै गलील के आस-पास के सबै जघन मैं फैल गौ। ");
INSERT INTO thr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","और ईसु तुरंतै सभाघर मैं से निकरकै, याकूब और यूहन्ना के संग सिमौन और अन्द्रियास के घरै आओ। ");
INSERT INTO thr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","और सिमौन की सास ततासेरी से बिमार रहै, और बे तुरंतै बासे, बाके बारे मैं कहीं। ");
INSERT INTO thr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तौ फिर ईसु बाके झोने जाएकै बाको हाथ पकड़कै उठाई; और बाको बुखार तुरंतै उतर गई, और बौ उनकी सेवा-खातिर करन लग्गई। ");
INSERT INTO thr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","संजा खिन जब दिन डूब गौ तौ लोग सब बिमारन कै और उनकै, जोके भीतर प्रेत आत्मा सटकी रहैं, ईसु के झोने लाईं। ");
INSERT INTO thr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","और पूरो सहर बाके घर के दुआरे जुराएगौ। ");
INSERT INTO thr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","और बौ निरेन कै जो अलग-अलग तरहन की बिमारिन से परेसान रहैं, उनकै अच्छो करी, और निरे तरहन के भूतन कै निकारी, और प्रेत आत्मा कै मसकन तक नाय दई, काहैकि प्रेत आत्मा ईसु कै जानत रहैं। ");
INSERT INTO thr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","और भुकभुको होन से भौत अग्गु, ईसु उठकै निकरो, और बन मैं गौ और बौ प्रार्थना करन लग्गौ। ");
INSERT INTO thr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","तौ सिमौन और बाके संग बारे ईसु कै ढूँड़न गै। ");
INSERT INTO thr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","जब ईसु मिलगौ, तौ बे बासे कहीं, “सब जनी तोकै ढूँड़ रै हैं।” ");
INSERT INTO thr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ईसु उनकै जबाब दई, “आबौ; आपन और कहूँ आसपास के गाँव मैं चलैं, मैं हुँओं प्रचार करंगो, काहैकि मैं जहे ताहीं निकरो हौं।” ");
INSERT INTO thr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","और ईसु पूरे गलील मैं उनके सभाघर मैं जाए-जाएकै प्रचार करतो, और प्रेत आत्मा कै निकारे करत रहै। ");
INSERT INTO thr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","एक कोहढ़ी ईसु के झोने आयकै, बासे नहोरे करी, और बाके अग्गु घूँटे टेक कै बासे कही, “अगर तू चाहबैगो तौ मोकै सुद्ध कर सकथै।” ");
INSERT INTO thr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ईसु बाके ऊपर तरस खाएकै बाके ऊपर हाथ बढ़ाई, और बाकै छुइ कै कही, “मैं चाहथौं कि तू सुद्ध हुई जा।” ");
INSERT INTO thr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","और तुरंतै बाको कोहोढ़ चले गौ, और बौ सुद्ध हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","फिर ईसु बाकै समझाए कै तुरंत पनार दई, ");
INSERT INTO thr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","और बासे कही, “देख, कोई से कछु मत कहिये, और जाएकै अपने आपकै पुजारी कै दिखा, और अपने सुद्ध होन के बारे मैं, जो कछु मूसा के नियम हैं, बाकै भेंट चढ़ा ताकी तेरे अच्छे होन को तू गभा बनै।” ");
INSERT INTO thr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पर बौ हुँआँ से जाएकै जौ बात को गजब प्रचार करी और हिंयाँ तक की ऐसे बात फैलान लग्गौ की ईसु फिर खुल्लम-खुल्ला नगर मैं नाय जाए पाई, पर बौ बाहर अलग्याँओं जघा मैं रहेत रहै; और लोग सब घाँईं से बाके झोने आत रहैं। ");
INSERT INTO thr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","थोड़ी दिन के बाद ईसु कफरनहूम सहर मैं आओ, और ऐसी खबर फैली की बौ अपने घर मैं है। ");
INSERT INTO thr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","फिर इत्ते जनी जुराए गै की दुआरे तक जघा नाय मिली; और बौ उनकै बचन सुनात रहै। ");
INSERT INTO thr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","और चार जनी एक फालिस मारे भै बिमार आदमी कै उठाएकै बाके झोने लै आईं। ");
INSERT INTO thr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","जब बे भीड़ की बजह से बाके झोने नाय पुग पाईं, तौ बे बौ छत, जोके तरे ईसु रहै, उत्कार दईं; और बाकी खटिया कै जोमैं फालिस को बिमार आदमी लेटो रहै, बाकै हुँए से तरे उतार दईं। ");
INSERT INTO thr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ईसु उनको ऐसो बिस्वास देखकै बौ फालिस के बिमार आदमी से कही, “ओरे लौड़ा, तेरे पाप माफ हुईगै।” ");
INSERT INTO thr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","तौ जो हुँआँ पर कुछ यहूदि नियम के सिक्छक बैठे पड़े रहैं, बे अपने-अपने मन मैं सोचन लागे, ");
INSERT INTO thr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“कि जौ आदमी ऐसो कैसे कह सकथै? जौ तौ परमेस्वर की बुराई कर रहो है! परमेस्वर के अलावा और कौन पाप माफ कर सकथै?” ");
INSERT INTO thr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ईसु तुरंतै अपने मन (आत्मा) मैं जानगौ, की बे अपने-अपने मन मैं ऐसो सोच रै हैं, और बौ उनसे कही, “तुम अपने मन मैं ऐसो काहेकै सोच रहे हौ? ");
INSERT INTO thr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","आसान का है? का फालिस के बिमार आदमी से ऐसो कहनो कि तेरे पाप माफ हुईगै, या फिर जौ कहनो, कि उठ अपनी खटिया उठा और नेंग? ");
INSERT INTO thr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पर जासे तुम जानलेबौ की इंसान के लौड़ा कै दुनिया मैं पाप माफ करन को भी अधिकार है।” बौ फालिस के बिमार आदमी से कही, ");
INSERT INTO thr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मैं तोसे कहथौं, उठ, अपनी खटिया उठाएकै अपने घरै चले जा।” ");
INSERT INTO thr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","और बौ उठो, और तुरंतै अपनी खटिया उठाएकै सबन के अग्गु से निकरकै चले गौ। ऐसो देखकै सब चौहोंक गै, और परमेस्वर की बड़ाँईं करन लागे, और कहेन लागे, “हम ऐसो होत भौ कहुए नाय देखे।” ");
INSERT INTO thr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ईसु फिर निकरकै गलील झील के टिकारे गौ, और पूरी भीड़ बाके झोने आई, और बौ उनकै उपदेस देन लगो। ");
INSERT INTO thr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","बौ जात भौ हलफई के लौड़ा लेवी कै लगान की चौकी मैं बैठो भौ देखी, और बासे कही, “मेरे पच्छू हुई ले।” और बौ उठकै, बाके पच्छू हुई लई। ");
INSERT INTO thr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","जब ईसु लेवी के घरै खानु खान कै बैठो, तौ निरे जनी लगान लेन बारे और पापी, ईसु और बाके चेलन के संग खानु खान कै बैठे; और बे निरे जनी रहैं, और बाके पच्छू हुई लईं रहैं। ");
INSERT INTO thr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","फरीसिन मैं से और नियम की सिक्छा देनबारे भौत से यहूदि नियम के सिक्छक लोग जौ सब देखकै, कि बौ तौ पापी और लगान लेन बारेन संग खानु खाए रौ है, बाके चेलन से कहीं, “बौ काहे लगान लेन बारेन और पापिन के संग खानु खाथै!” ");
INSERT INTO thr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ईसु जौ सुनकै उनसे कही, “अच्छे भलेन कै बैध की जरूरत नाय होथै, लेकिन बिमारन कै होथै। मैं धर्मिन कै नाय, पर पापिन कै मस्कान आओ हौं।” ");
INSERT INTO thr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यूहन्ना बपतिस्मा देनबारे के चेला, और फरीसी बर्त रखत रहैं, तौ कुछ लोग आयकै ईसु से कहीं, “ऐसो काहे है कि यूहन्ना के चेला और फरीसिन के चेला तौ बर्त रखथैं, पर तेरे चेला तौ बर्त नाय रखथैं?” ");
INSERT INTO thr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ईसु उनकै जबाब दई, “एक बिहा बारे घर मैं जबले दुल्हा बरैतियन के संग रहथै, का बे बर्त रख सकथैं?” और जबले दुल्हा उनके संग है, तौले बे बर्त नाय रखथैं। ");
INSERT INTO thr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पर बे दिन आंगे, जब दुल्हा उनसे अलग करो जागो; बौ समय बे बर्त रखंगे। ");
INSERT INTO thr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“कोरे लत्ता को थिगरा पुराने लत्ता मैं कोई नाय लगाथै; ना तौ बौ थिगरा सुकर कै बामै से पुराने लत्ता से खींच लेगो, और जो भार है बौ पहले से अगरो फट जाबैगो। ");
INSERT INTO thr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नई दाखरस कै पुराने मसकन मैं कोई नाय रखथै, ना तौ दाखरस मसकन कै फाड़ देगी, और दाखरस और मसका दोनों बरबाद हुई जांगे, पर नई दाखरस कै नये मसकन मैं भरो जाथै।” ");
INSERT INTO thr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ऐसो भौ कि ईसु साबत के दिन खेत से हुईकै जात रहै, और बाके चेला नेंगतै-नेंगत बाली तोड़न लग्गै। ");
INSERT INTO thr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तौ फरीसी ईसु से कहीं, “देख; साबत के दिन तेरे चेलन कै ऐसो करनो नियम के हिसाब से ठीक नाय है?” ");
INSERT INTO thr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ईसु उनकै जबाब दई, “का तुम जौ कहुए ना पढ़े हौ कि जब दाऊद कै जरूरत पड़ी, और जब बौ और बाके संग के भूंके भै, तौ बौ का करी रहै? ");
INSERT INTO thr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","बौ कैसे अबियातार बड़ो पुजारी के समय, परमेस्वर के घर मैं भेंट करी भई रोटी खाईं, जो रोटी खानो नियम के हिसाब से बड़े पुजारी के अलावा कोई नाय खाए सक्त रहै, और बौ अपने संग बारेन कै दई?” ");
INSERT INTO thr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","तौ बौ उनसे कही, “साबत को दिन आदमिन के ताहीं बनाओ गौ है, जौ न कि आदमी साबत के दिन ताहीं। ");
INSERT INTO thr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","तभईये, इंसानन को लौड़ा साबत के दिन को भी मालिक है।” ");
INSERT INTO thr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ईसु फिर सभाघर मैं गौ, और हुँआँ एक आदमी रहै, जोके हात मैं फालिस मार दई रहै, ");
INSERT INTO thr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","और कुछ लोग ईसु ऊपर इल्जाम लगान के ताहीं बाके ऊपर घात लगाएकै बैठे रहैं, कि देखैं तौ, बौ साबत के दिन बाकै अच्छो करथै की नाय। ");
INSERT INTO thr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ईसु फालिस मारे भै आदमी से कही, “बीच मैं ठाड़ जा।” ");
INSERT INTO thr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","फिर बौ लोगन से पूँछी, “हमरो नियम साबत के दिन का कहथै? अच्छो करन ताहीं, कि बुरो करन ताहीं? कोई की ज्यान बचान ताहीं या मारन ताहीं?” पर बे सब चुप रहे। ");
INSERT INTO thr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ईसु उनको कर्‌रो मन देखकै उदास हुईकै, उनकै गुस्सा से सब घाँईं देखी, और बौ आदमी से कही, “अपनो हाथ अग्गु कर।” बौ अग्गु करी, और बाको हाथ फिर से अच्छो हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तौ फरीसी सभाघर से दुआरे जाएकै तुरंतै राजा हेरोद के संग ईसु मसीह के खिलाप मैं सलाह मस्वरा करन लागे कि बाको कैसे करकै नास करैं। ");
INSERT INTO thr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ईसु अपने चेलन के संग गलील झील घाँईं चले गौ: और एक बड़ा बड़ी भीड़ बाके पच्छू हुई लई; जो कि गलील, यहूदिया, ");
INSERT INTO thr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","यरूसलेम नगर, इदूमिया परदेस से, और यरदन नदिया के अगार की जघा से, और सूर और सैदा नगरन के आस-पास से आए रहैं। कि ईसु कैसे-कैसे अचम्मे काम करथै, जौ सुनकै बाके झोने आए रहैं। ");
INSERT INTO thr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","और ईसु अपने चेलन से कही, “मेरे ताहीं एक छोटी नईंयाँ समारे रखाबौ” ताकी मोकै भीड़ चिबदाए नाय पाबै। ");
INSERT INTO thr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","काहैकि बौ निरेन कै अच्छो करी रहै; तभईये जित्ते जनी बिमारी से दुखी रहैं, ईसु कै छून ताहीं मरे जात रहैं। ");
INSERT INTO thr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","और प्रेत आत्मा, जब ईसु कै देखत रहैं, तौ बाके अग्गु गिर पड़त रहैं, और चिल्लाए कै कहेत रहैं की “तू परमेस्वर को लौड़ा है!” ");
INSERT INTO thr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","और ईसु प्रेत आत्मा कै आग्या दैकै कही, कि जौ बात को जिकर कोई से नाय करै। ");
INSERT INTO thr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","फिर ईसु पहाड़ मैं चढ़गौ, और जोकै बौ चहात रहै उनकै अपने झोने बुलाई; और बे बाके झोने आए। ");
INSERT INTO thr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तौ बौ बारह आदमिन कै छाँटी और उनकै प्रेरित नाओं दई। और उनसे कही “मैं तुमकै मेरे संग रहेन ताहीं चुनो हौं, मैं तुमकै प्रचार करन ताहीं पनारंगो, ");
INSERT INTO thr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","और प्रेत आत्मा कै निकारन को अधिकार तुमरे पास होगो।” ");
INSERT INTO thr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","बे बारह छाँटे भै प्रेरितन के नाओं जे रहैं: सिमौन जोको नाओं बौ पतरस रखी, ");
INSERT INTO thr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","और जब्दी को लौड़ा याकूब और याकूब को भईय्या यूहन्ना, इन भईय्यन को नाओं बौ बुअनरगिस मतलब “गरजन को लौड़ा” रखी; ");
INSERT INTO thr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","और अन्द्रियास, और फिलिप्पुस, और बरतुल्मै, और मत्ती, और थोमा, और हलफई को लौड़ा याकूब, और तद्दै, और सिमौन कनानी, ");
INSERT INTO thr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","और यहूदा इस्करियोती, जो ईसु कै बाद मैं पकड़बाई रहै। ");
INSERT INTO thr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","तौ फिर ईसु घरै आओ: और हूँना पर ऐसी भीड़ जुरानी, कि ईसु और बाके चेला खानु तक नाय खाए पाईं। ");
INSERT INTO thr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जब ईसु के घर बारे जौ बात सुनीं, तौ बे बाकै लेन कै चल दईं; काहैकि लोग-बाग कहेन डटे रहैं कि, बाकी अकल खराब हुई गई है। ");
INSERT INTO thr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","थोड़ी यहूदि नियम के सिक्छक जो यरूसलेम से आए रहैं, ऐसे कहेत रहैं, “की बाके भीतर बालजबूल है,” और बहे अपने अधिकार से प्रेत आत्मा कै निकारन के ताहीं ईसु कै ताकत देथै। ");
INSERT INTO thr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","और ईसु उनकै अपने झोने बुलाएकै उनसे कहानी के जरिये कहेन लगो: “सैतान कै सैतान कैसे निकार सकथै?” ");
INSERT INTO thr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","और अगर कोई राज्य मैं फूट पड़ जाबै, तौ बौ राज्य कैसे टिको रह सकथै? ");
INSERT INTO thr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","और अगर कोई के घर मैं फूट पड़ जाबै, तौ बौ घर कैसे टिको रह सकथै? ");
INSERT INTO thr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","और अगर सैतान अपनेई खिलाप हुईकै और अपनेई मैं फूट डारै, तौ बौ कैसे टिको रह सकथै? बाको तौ नामो निसान खतम हुई जातो। ");
INSERT INTO thr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“पर कोई इंसान, कोई तगड़े आदमी के घर मैं घुसकै बाको माल जेबर नाय लूट सकथै, जबले की पहले बौ तगड़े आदमी कै भाँद ना लेबै; तौ जाएकै बाको घर लूट पागो।” ");
INSERT INTO thr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“मैं तुमसे सच्ची कहथौं कि इंसानन की औलादन के सब पाप और बुराई जो बे करथैं, बे माफ करे जांगे, ");
INSERT INTO thr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पर जो कोई पवित्र आत्मा के खिलाप बुराई करैगो, बौ अनंतकाल तक माफ न करो जागो: और बौ कहु ना खतम होन बारो पाप को कसूरवार मानो जागो।” ");
INSERT INTO thr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ईसु जौ कही, काहैकि बे जौ कहेत रहैं, कि “ईसु मैं प्रेत आत्मा है।” ");
INSERT INTO thr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","तभईये ईसु की अईय्या और बाके भईय्या आए, और दुआरे ठाड़कै ईसु कै मस्कान ताहीं एक जनी कै पनारीं। ");
INSERT INTO thr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","भीड़ बाके आसपास बैठी रहै, और बे बासे कहीं, “देख तेरी अईय्या और तेरे भईय्या-बहेनिया तोकै दुआरे ढूँड़ रै हैं।” ");
INSERT INTO thr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ईसु उनकै जबाब दई, “मेरी अईय्या और मेरो भईय्या कौन है?” ");
INSERT INTO thr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","और जो ईसु के आसपास बैठे रहै, उनके घाँईं देखकै बौ कही, “देखौ, मेरी अईय्या और मेरे भईय्या जे हैं। ");
INSERT INTO thr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","परमेस्वर जो कहथै बहे बौ करैगो, बहे मेरो भईय्या, मेरी बहेनिया, और मेरी अईय्या है।” ");
INSERT INTO thr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ईसु फिरौंकी, गलील झील के डींड़े से उपदेस देन लगो: और हुँआँ पर इत्ती भीड़ लागी कि बौ झील मैं एक नईंयाँ के ऊपर चढ़कै बैठगौ, और पूरी भीड़ झील के डींड़े मैं ठाड़ी रइ। ");
INSERT INTO thr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","और ईसु उनकै कहानी के जरिये भौत सी बात सिखान लग्गौ, और अपने उपदेस के जरिये उनसे कही, ");
INSERT INTO thr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“सुनौ! एक बीज बोन बारो बीज बोन ताहीं निकरो। ");
INSERT INTO thr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","बीज बोत पोती थोड़ी रहा किनारे गिरो और चिरईंयाँ आयकै बाकै चुग लईं। ");
INSERT INTO thr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","थोड़ी पथरिया बारी जमीन मैं गिरो जहाँ बाकै अगरी मट्टी नाय मिलपाई, और गहरी मट्टी नाय मिलन से बीज जल्दी जमेंआओ, ");
INSERT INTO thr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","और जब दिन निकरो तौ भुर्स गौ, और जड़ न पकड़न से सूख गौ। ");
INSERT INTO thr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","थोड़ी झाड़ी मैं गिरे, और झाड़ी बड़ी हुईकै बीज कै दबाय दई, और बे फल-फूल नाय पाईं। ");
INSERT INTO thr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पर कुछ बीज अच्छी जमीन मैं गिरे, और बे जमें और खूबै फल लाईं; कोई तीस गुना, कोई साठ गुना और कोई सौ गुना फल लाईं।” ");
INSERT INTO thr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","तौ ईसु कही, “जोके कान होमैं, बौ सुन लेबै!” ");
INSERT INTO thr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जब ईसु अकेलो रहगौ, तौ बाके बारह प्रेरित बासे बौ कहानी के बारे मैं पूँछीं। ");
INSERT INTO thr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ईसु उनसे कही, “तुमकै तौ परमेस्वर के राज्य के भेद की समझ दई गई है,” पर बाहर बारेन कै कहानी के जरिये समझाओ जाथै, ");
INSERT INTO thr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","तभईये तौ, “उनकै सुजात तौ है लेकिन उनकै सुजाई ना देथै; बे सुनत तौ हैं, लेकिन कछुए समक ना पाथैं। ऐसो ना होबै, कि बे फिरैं और माफी पाए जामैं।” ");
INSERT INTO thr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","फिर ईसु उनसे कही, “का तुम जौ कहानी नाय समझपाए? तौ फिर और सबै कहानिन कै कैसे समझैगे? ");
INSERT INTO thr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","बोन बारो परमेस्वर के बचन कै बोथै। ");
INSERT INTO thr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जो रहा किनारे के हैं जहाँ बचन बोओ जाथै, जे बे हैं कि जब बे बचन कै सुनीं, तौ सैतान तुरंत आयकै बचन कै जो उनमैं बोए गौ रहैं, उठाए लै जाथै। ");
INSERT INTO thr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","बैसिये जो पथरिया बारी जघा मैं बोए जाथै, जे बे हैं जो बचन कै सुनकै तुरंत खुसी से अपनाय लेथैं। ");
INSERT INTO thr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पर अपने भीतर टिकाउ जड़ ना होन की बजह से बे थोड़िये दिन के होथैं; जाके बाद जब बचन के बजह से उनमैं दुख और कलेस होथै, तौ बे तुरंतै पच्छू ओहोर जाथैं। ");
INSERT INTO thr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","जो झाड़ी मैं बोए गै, जे बे हैं जो बचन कै सुनीं, ");
INSERT INTO thr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","और युग भर की फिकर, और धन को धोका, और चीजन को लालच उनमैं समाएकै बचन कै दबाय देथैं और बौ (फल नाय देन बारो) रह जाथै। ");
INSERT INTO thr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","और जो अच्छी जमीन मैं बोए गै, बे जे हैं जो बचन सुनकै अपनाथैं और फल लाथैं: कोई तीस गुना, कोई साठ गुना और कोई सौ गुना।” ");
INSERT INTO thr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ईसु उनसे कही, “का दिया कै जहे ताहीं लाथैं कि छपरिया या खटिया के तरे रखो जाबै? का जौ ताहीं नाय कि डीट मैं रखो जाबै? ");
INSERT INTO thr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ऐसो कछु नाय है, जो लुको है और खुलो न जाबैगो और ना कछु लुको है, जो उजियारे मैं ना लाओ जागो। ");
INSERT INTO thr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","अगर कोई के सुनन ताहीं कान होमैं, तौ बौ सुन लेबै।” ");
INSERT INTO thr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","फिर बौ उनसे कही, “ध्यान से सुनौ! जो नपना से तुम नापथौ बहे से तुम्हऊँ कै नापो जागो, और तुमकै अगरो दौ जागो। ");
INSERT INTO thr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","जोके झोने है, बाकै और दौ जागो; और जोके झोने नाय है, बासे बहो जो बाके झोने है, लै लौ जागो।” ");
INSERT INTO thr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","फिर ईसु कही, “परमेस्वर को राज्य बौ आदमी के हानी है, जो जमीन मैं बीजन कै छिटक दई, ");
INSERT INTO thr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","और रात मैं जाएकै सोए गौ, सुबेरे बौ उठकै देखी कि बीज जमकै निकर रौ है, कैसे निकर रौ है, जौ बौ खुद नाय जानथै। ");
INSERT INTO thr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","जमीन अपने आप जमाथै, सबसे पहले नकुवा, फिर बाली, और बाके बाद बालिन मैं दाने। ");
INSERT INTO thr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","और जब दाने पक जाथैं, बौ बिना देरी करे दरांती से काट लेथै, काहैकि बाकी फसल तैयार है।” ");
INSERT INTO thr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","फिर बौ कही, “परमेस्वर के राज्य की बराबरी कौन से करी जाए सकथै?” और कौनसी कहानी के जरिये जाकी बात बताई जाए सकथै? ");
INSERT INTO thr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“बौ राया के गूदा के हानी है: जब जमीन मैं बोओ जाथै तौ जमीन के सबै गूदन से छोटो होथै, ");
INSERT INTO thr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","लेकिन जब बोओ गौ, तौ जमकै बौ सब सागपातन से बड़ो हुई जाथै, और बाकी ऐसी बड़ी हँगईय्या निकरथैं कि आसमान की चिरईंयाँ बाकी छाँईं मैं घोसला बनाएकै रह सकथैं।” ");
INSERT INTO thr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ईसु निरेन कै कहानी बताए-बताए कै उनकै बचन सुनाए करत रहै, ताकी बे समझ पामैं। ");
INSERT INTO thr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","और बिना कहानी के, बौ उनसे कछुए नाय कहेत रहै; पर बौ अलग्याँओं मैं अपने खुद के चेलन कै सब बातन को मतलब समझात रहै। ");
INSERT INTO thr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","बहे दिन जब संजा भइ, तौ बौ चेलन से कही, “आबौ, आपन झील के बौ पाँजर चलैं।” ");
INSERT INTO thr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","और बे भीड़ कै छोड़कै, ईसु कै नईंयाँ मैं संग लै चल दईं; और बाके संग औरौ नईंयाँ रहैं। ");
INSERT INTO thr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","तौ अनकाचीति एक बड़ी आँधी आई, और लहरैं नईंयाँ मैं ऐसी टक्कर खामैं, कि पानी से नईंयाँ भरी जाबै। ");
INSERT INTO thr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","पर ईसु नईंयाँ के पच्छू के सिरा मैं तकिया लगाएकै सोत रहै। तौ ईसु के चेला जाएकै कहीं, “गुरुजी, का तोकै फिकर नाय है कि हम डूबे जाए रै हैं?” ");
INSERT INTO thr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तौ फिर ईसु उठकै आँधी कै आग्या दई, और पानी से कही, “सांत हुई जा, रुक जा!” और आँधी रुक गई और सब घाँईं सांति छाए गई। ");
INSERT INTO thr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","और बौ अपने चेलन से कही, “तुम काहे डराथौ? का तुमकै हबै तक बिस्वास नाय है?” ");
INSERT INTO thr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","बे गजबै डराय गै और आपस मैं बतकाईं, “जौ कौन है कि आँधी और पानी की लहरैं जाकी बात मानथैं?” ");
INSERT INTO thr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ईसु और बाके चेला गलील झील के पच्छू गिरासेनियों नाओं के देस मैं गै, ");
INSERT INTO thr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","जब ईसु नईंयाँ मैं से उतरो तौ तुरंतै एक आदमी जोके अंदर प्रेत आत्मा रहै, कबर मैं से निकरो और ईसु से मिलो। ");
INSERT INTO thr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","बौ मरघटान मैं रहत रहै और बाकै साँकर से कोईये नाय भाँद पात रहै, ");
INSERT INTO thr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","काहैकि बाकै निरे बार जंजीर और बेड़ियन से भाँदो गौ रहै, तहुँओं बौ साँकर और बेड़ियन कै कछुए नाय समझत रहै सब तोड़-ताड़ कै टुकड़ा-टुकड़ा कर देत रहै, और कोई के पास बाकै बस मैं करन ताहीं सक्ति नाय रहै। ");
INSERT INTO thr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","बौ दिन-रात कबर और पहाड़न मैं चिल्लात फिरत रहै, और अपने आपकै पथरन से चोट पहोंचात रहै। ");
INSERT INTO thr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","बौ ईसु कै दूरै से देखकै दौड़ो, बाकै घुपटियाय कै नमस्ते करी, ");
INSERT INTO thr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","और खूब जोड़न से चिल्लाए कै कही, “ईसु, परमप्रधान परमेस्वर को लौड़ा, तोकै मोसे का काम? मैं तोकै परमेस्वर के नाओं से नहोरे करथौं कि मोकै सजा मत देबै।” ");
INSERT INTO thr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","काहैकि ईसु कही रहै, “प्रेत आत्मा, जौ आदमी मैं से निकर जा!” ");
INSERT INTO thr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ईसु बासे पूँछी, “तेरो नाओं का है?” आदमी जबाब दई, “मेरो नाओं पलटन है; काहैकि हम निरे हैं।” ");
INSERT INTO thr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","और बौ ईसु से बड़ा नहोरे करी, “हमकै जौ देस से जान मत कहबै।” ");
INSERT INTO thr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","उतै पहाड़ मैं सोरन को बड़ा भारी झुंड चुगत रहै। ");
INSERT INTO thr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","प्रेत आत्मा ईसु से नहोरे करकै कहीं, “हमकै सोरन के भीतर भेज दे।” ");
INSERT INTO thr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ईसु प्रेत आत्मा से कही और प्रेत आत्मा निकरकै सोरन के अंदर समाए गै और झुंड, जो करीब दुई हजार रहैं, ढाव से झिपटाए कै झील मैं जाए गिरे और डूबकै मर गै। ");
INSERT INTO thr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","उनके बरदिया भाजत-भाजत नगर और गाँवन मैं सब किस्सा कह सुनाई, और जो भौ रहै, सब जनी देखन आए। ");
INSERT INTO thr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","बे ईसु के झोने आयकै जोके भीतर प्रेत आत्मा की पलटन रहैं बाकै लत्ता पहने और सांत बैठे देखकै डराय गै। ");
INSERT INTO thr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","जोकै प्रेत आत्मा पकड़ी रहैं और सोरन के संग जो कछु भौ रहै देखन बारे जौ सब देखकै हुँआँ के आदमिन कै सब कछु कह सुनाईं। ");
INSERT INTO thr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तौ बे सब जनी ईसु से नहोरे करकै कहीं की तैं हमरी हद से चलो जा। ");
INSERT INTO thr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","जब बौ नईंयाँ मैं चढ़न लगो तौ जोके अंदर प्रेत आत्मा रहैं, ईसु से नहोरे करन लागो, “मोकै अपने झोने रहेन दे।” ");
INSERT INTO thr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पर ईसु बाकै मना करी, और बासे कही, “अपने घरै जा और सब जनिन कै बता। कि तेरे ऊपर दया करकै प्रभु कितनो बड़ो काम करी है।” ");
INSERT INTO thr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","बौ जाएकै दिकापुलिस मैं जौ प्रचार कै फैलान लागो कि ईसु मेरे ताहीं कित्ते बड़े काम करी है; और सबै सुनकै अचम्मो करीं। ");
INSERT INTO thr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जब ईसु नईंयाँ से झील के बौ पाँजर गौ, तौ झील के किनारे एक भारी भीड़ बाके झोने जुराए गई। ");
INSERT INTO thr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","याईर नाओं को आदमी जो सभाघर को मुखिया मैं से एक रहै आओ, और बाकै देखकै बाके पाँव मैं गिर गौ, ");
INSERT INTO thr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","और जौ कहकै बासे नहोरे करी, “मेरी छोटी लौड़िया मरन पड़ी है; तैं आयकै बाके ऊपर हात रख कि बौ अच्छी हुईकै जिंदी रहाबै।” ");
INSERT INTO thr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तौ, बौ बाके संग जान लगो और पूरी भीड़ बाके पच्छू हुई गई; हिंयाँ तक कि लोग बाके ऊपर गिरागिर करैं। ");
INSERT INTO thr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","एक बईय्यर रहै, जोकै बारह साल से खून बहेन की बिमारी रहै। ");
INSERT INTO thr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","बौ निरे बैधिन कै दिखाए डारी रहै, और अपनो सबै रुपईया-पैसा उठाए डारी रहै तहुँओं कछु आराम नाय मिलो, लेकिन औरौ जाधे बिमार हुई गई रहै। ");
INSERT INTO thr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","बौ ईसु के बारे मैं सुनी रहै जहे बजह से भीड़ कै हटात भइ पच्छू से आयकै बाके लत्ता कै छुइ, ");
INSERT INTO thr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","काहैकि बौ अपने आपकै कहेत रहै, “अगर मैं बाके लत्ता कै छुइ लेंगो, तौ अच्छी ही जांगो।” ");
INSERT INTO thr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","और तुरंतै बाको खून बहनो बंद ही गौ, और बौ अपनी सरीर मैं महसूस कर लई की मैं बौ बिमारी से ठीक ही गौ हौं। ");
INSERT INTO thr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","तुरंतै ईसु के भीतर से सामर्थ्य निकरी, तौ बाकै पता लग्गौ कि, कोई तौ मोकै छुओ है। और पच्छू घूमकै भीड़ से पूँछी, “मेरो लत्ता कौन छुओ है?” ");
INSERT INTO thr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","बाके चेला जबाब दईं, “तैं तौ देखिये रौ है कि तेरे ऊपर भीड़ गिरी जाए रइ है, तहुँओं तू कहथै कि मोकै कौन छुओ?” ");
INSERT INTO thr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","पर मेरे लत्ता कौन छुओ देखन ताहीं सब घाँईं देखन लगो। ");
INSERT INTO thr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","बौ बईय्यर सोची मेरे संग अच्छोई भौ है, तौ डरात और थरथरात भइ आई, और बाके गोड़े मैं गिरकै सब कछु उनकै सच-सच कह सुनाई। ");
INSERT INTO thr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ईसु बासे कही, “मेरी लौड़िया, तेरो बिस्वास तोकै अच्छो करी है: सांति से जा, और जौ बिमारी से बची रहिये।” ");
INSERT INTO thr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ईसु जौ कहतै रहै तभईये सभाघर को मुखिया के घर से कोई आदमी आयकै कही, “तेरी लौड़िया तौ मर गई, अब गुरुजी कै काहे दुख दे रौ है?” ");
INSERT INTO thr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","जो बात बे कहेत रहैं, बौ बात कै ईसु ना सुनी, सभाघर के मुखिया से कही, “मत डराबै; सिरफ बिस्वास कर।” ");
INSERT INTO thr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","और बौ पतरस और याकूब और याकूब को भईय्या यूहन्ना कै छोड़, और कोईयन कै अपने संग नाय आन दई। ");
INSERT INTO thr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","जब बौ मुखिया के घरै पहोंचो तौ हूँना बैठे भैन कै रोबा पिटाउ करत देखी। ");
INSERT INTO thr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तौ बौ भीतर जाएकै उनसे कही, “तुम काहेकै रोत और हुल्ल गदड़ मचाथौ? लौड़िया तौ मरिये नाय है, बौ सोए रइ है।” ");
INSERT INTO thr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","लेकिन हूँना पर जो आदमी रहैं बाके ऊपर हसन लागे, तभईये बौ सबन कै दुआरे भजाए दई सिरफ लौड़िया के अईय्या-दऊवा और अपने तीन चेलन संग घर के भीतर जितै लौड़िया लेटी रहै, झोने गै। ");
INSERT INTO thr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","और लौड़िया को हात पकड़कै कही, “तलीता कूमी!” जोको मतलब है, “ओ छोटी लौड़िया, मैं तोसे कहथौ, उठ!” ");
INSERT INTO thr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","और लौड़िया उठकै नेंगन लगी; बौ बारह साल की रहै। जौ देखकै सबै चौहोंक गै। ");
INSERT INTO thr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","फिर बौ उनकै चहाचीतो करकै कही कि जौ बात कोईये कै नाय पता चलै और कही, “जाकै कछु-कछा खान कै दियौ।” ");
INSERT INTO thr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","फिरौंकी ईसु बौ जघा कै छोड़कै अपने सहर कै चल पड़ो, बाके चेलौ बाके संग रहैं। ");
INSERT INTO thr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","साबत के दिन सभाघर मैं उपदेस देन लगो, और भौत से आदमी सुनकै चोहोंक गै और कहेन लगे, “जाकै इत्ती बढ़िया-बढ़िया बात कितै से आए गईं?” जाकै इतनी अकल कहाँ से आए गई? जौ इतने सामर्थ्य के काम कैसे करकै करो? ");
INSERT INTO thr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","का जौ बहे बढ़ईया ना है, जो मरियम को लौड़ा, और याकूब, योसेस, यहूदा और सिमौन को भईय्या है? का बाकी बहेनिया आपनैं संग गाओं मैं नाय रहथैं? बे ईसु कै अपनाईये ना पामैं। ");
INSERT INTO thr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","फिर ईसु उनसे कही, “भविस्यवक्ता कै अपने घर, गाओं-सहर, और अपने हितुआ, और कुरमन कै छोड़कै और कहुए अनादर ना होथै।” ");
INSERT INTO thr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ईसु हुँआँ जाधे सामर्थ्य के काम करिये ना पाई, कतई जराएक आदमिन के ऊपर हात रखकै बिमारिन से अच्छो कर पाई। ");
INSERT INTO thr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","बौ उनको कतईये बिस्वास नाय देखकै बड़ा अचम्मो भौ। फिर बौ गाओं-गाओं मैं सिक्छा देत भै घूमन लगो। ");
INSERT INTO thr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ईसु अपने बारह चेलन कै अपने झोने बुलाई और दुई-दुई करकै भेजन लगो; बौ उनकै प्रेत आत्मा के ऊपर अधिकार दई, ");
INSERT INTO thr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","और एक भौत जरूरी बात समझाई, “तुम अपने संग एक लठिया के अलावा कछु मत लियो। ना तौ रोटी लियो, ना झोला, ना गोझा मैं रुपईया-पैसा। ");
INSERT INTO thr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","तुम चप्पल तौ पहेनियो पर दुई जोड़ी कुरता मत लियो।” ");
INSERT INTO thr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","और बौ उनसे कही, “चाँहे जोसे घर मैं तुम रहबौ, हूँना से ना जान तक हूँनै रहियो। ");
INSERT INTO thr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जो गाँव के आदमी तुमकै ना अपनामैं और तुमरी एकौ ना सुनैं, तौ तुम हुँआँ से नेंगतै खिना अपनी टाँग के तरबन से धूदर झार दियो, बौ उनके ताहीं चितौनी होगी।” ");
INSERT INTO thr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","फिर बे हूँना से चले गै। और बे पापन से मन बदलन ताहीं प्रचार करन लगे। ");
INSERT INTO thr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","बे भौत आदमिन कै प्रेत आत्मा से छुड़ाईं और भौतन कै जो रोगी रहैं उन्हैं जैतून को तेल लगाएकै अभिसेक करकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","राजा हेरोद जब ईसु के बारे मैं सुनी; बौ समय ईसु को नाओं भौत फैल गौ रहै। कुछ जनी कहेत रहैं “बपतिस्मा देन बारो यूहन्ना मरे भैन मैं से जिंदो ही गौ है, तभईये बौ जे सामर्थ्य के काम करथै।” ");
INSERT INTO thr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","दुसरे आदमी कहेत रहैं, “कि बौ एलिय्याह भविस्यवक्ता है।” थोड़ी आदमी और कहमैं, कि ना! “जौ पुराने जमाने को कोई भविस्यवक्ता है।” ");
INSERT INTO thr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","इन सबन की बात जब राजा हेरोद सुनी, तौ बौ कही, “बपतिस्मा देन बारो यूहन्ना, जो की गरदन मैं कटबाओ रहौं, बहे जिंदो हुई गौ है!” ");
INSERT INTO thr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","काहैकि हेरोद खुदै यूहन्ना कै बंधी बनान और कैदखाना मैं डारन ताहीं हुकम दई रहै। बौ अपने भईय्या फिलिप्पुस की बईय्यर जोको नाओं हेरोदियास रहै बहे की बजह से, बाकै आदमिन से पकड़बाई और कैदखाना मैं डरबाए दई रहै; हेरोद हेरोदियास कै बिहाए लई रहै। ");
INSERT INTO thr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","काहैकि यूहन्ना हेरोद से कही रहै, “अपने भईय्या की बईय्यर तैं बिहाए तौ लौ है पर ठीक ना है।” ");
INSERT INTO thr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","तहीं के मारे हेरोदियास की बईय्यर यूहन्ना कै अच्छो ना मानत रहै और बौ जहे चहात रहै कि बौ बाकै मार डारै; पर राजा हेरोद के बजह से कहुए ना भौ, ");
INSERT INTO thr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","काहैकि हेरोद राजा यूहन्ना कै धर्मी और पवित्र आदमी मानकै बासे डरात रहै, बौ मर ना जाबै बाकै बचात रहेत रहै, और यूहन्ना की बात सुनकै गजबै परेसान रहै, लेकिन खुस हुईकै सुनतौ रहै। ");
INSERT INTO thr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","एक दिन आओ जब हेरोद को जनम दिन रहै; बौ दिन ऊँचे और बड़े-बड़े अधिकारिन, सेनापतिन और गलील नगर के खास लोगन कै न्युतो दैकै खान-पीन को इंतजाम करी। ");
INSERT INTO thr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","बौ जनम दिन के मौका मैं हेरोदियास की बईय्यर की लौड़िया हूँना जाएकै नाची और हूँना बैठे भै लोगन कै खुस कर दई। तौ राजा हेरोद बौ लौड़िया से कही, “तैं जो कछु आज मोसे माँगैगी मैं तोकै देंगो।” ");
INSERT INTO thr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","और बाकै कसम दैकै कही, “तैं मोसे जो कछु भी माँगैगी तौ मैं तोकै दै दुंगो, हिंयाँ तक कि मैं तोकै आधो राज्य पाट दै दुंगो।” ");
INSERT INTO thr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","बौ रइ सो दुआरे गई और अपनी अईय्या हेरोदियास से पूँछी, “मैं का माँगौं?” बौ कही, “बपतिस्मा देनबारे यूहन्ना की मुड़िया।” ");
INSERT INTO thr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","बौ तुरंतै राजा झोने बापस आई और बासे नहोरे करी, “मैं चाहथौं कि तैं कतई अभईये यूहन्ना बपतिस्मा देनबारे की मुड़िया कटवाए कै एक थरिया मैं मंगवाए दे।” ");
INSERT INTO thr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","जौ सुनकै राजा को मोहों पुस्केयाए गौ, लेकिन अपना जो कसम हितुअन के अग्गु दई रहै बाकी बजह से मना ना कर पाई। ");
INSERT INTO thr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","राजा तुरंतै एक जल्लाद से कही कैदखाना मैं जा और यूहन्ना की मुड़िया काटकै लैयाबौ। ");
INSERT INTO thr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","बौ ताराबास मैं जाएकै बाको मूड़ काटी, और एक थरिया मैं धर लाई और लौड़िया कै दई, और लौड़िया रइ सो अईय्या कै दै दई। ");
INSERT INTO thr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","जो भौ रहै सुनकै यूहन्ना के चेला आए, और यूहन्ना के सरीर कै लै जाएकै कबर मैं दफनाए दईं। ");
INSERT INTO thr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","प्रेरित लोग ईसु के झोने जुराए गै, जो कछु बे करीं और लोगन कै सिखाईं, सब कछु ईसु कै बताईं। ");
INSERT INTO thr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ईसु उनसे कही, “आबौ आपन एक अलग्याँओं जघा मैं जाएकै थोड़ी देर सैंताए लेमैं।” काहैकि हुँआँ भौत आदमी आन जान लग गै रहै, और उनकै तौ खानौ की संकता ना रहै। ");
INSERT INTO thr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","तभई के मारे बे नईंयाँ से, अलग्याँओं सुनसान जघा मैं चले गै। ");
INSERT INTO thr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","बहे समय निरे जनी उनकै जात देख डारीं और जानगै कि जे बेईं हैं, और सब नगरन से जुराए कै नेंगतै-नेंगत ईसु और बाके चेलन से पहलिये पौहौंच गै। ");
INSERT INTO thr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ईसु नईंयाँ मैं से उतरिये पाई रहै कि बड़ा जोड़ भीड़ देखी, और बाकै भीड़ ऊपर बड़ा तरस आओ, काहैकि बे उन भेंड़न हानी रहैं, जिनकी देखाभारी करन बारो कोईये ना रहै: फिर बौ उनकै निरी बात सिखान लगो। ");
INSERT INTO thr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जब दिन जराएक बचो, तौ बाके चेला बासे कहेन लगे, “जौ बड़ा सूनी जघा है, और दिनौ जराएक बचो है। ");
INSERT INTO thr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","उनकै पनार दे कि बे इतै-उतै गाँव और बस्तियन मैं जाएकै कछु-कछा मोल लैकै खाएलेमैं।” ");
INSERT INTO thr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ईसु उनकै जबाब दई, “तुम्हईं उनकै खान कै देबौ।” बे ईसु से कहीं, “का हम दुई सौ चाँदी के सिक्का कि रोटी मोल लैकै खान कै देमैं?” ");
INSERT INTO thr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ईसु उनसे कही, “जाएकै देखौ तौ, तुमरे झोने कितका रोटी हैं?” फिरौंकी पूँछ-पाँछ कै बे कहीं “पाँचै रोटी और दुईये मच्छी हैं।” ");
INSERT INTO thr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","फिर ईसु चेलन से कही, “जौ हरी-हरी घाँस मैं सबन कै लैनबार से बैठार देबौ।” ");
INSERT INTO thr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","तभईये बे सौ-सौ, पचास-पचास करकै लैनबार से बैठत गै। ");
INSERT INTO thr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","बौ पाँच रोटी और दुई मच्छी कै लैकै, ऊपर स्वर्ग के घाँईं देखी और धन्यवाद करी, और रोटियन कै तोड़कै चेलन कै देत गौ, ताकी बे सब जनिन ताहीं परसा परसैं, और बे दुई मच्छी सबन कै बाँट दईं। ");
INSERT INTO thr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","सब जनी खूबै छक कै खाए लईं। ");
INSERT INTO thr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","और फिर बाके चेला मच्छी और रोटी की बहारै छपरिया बची भईं उठाईं। ");
INSERT INTO thr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","जित्ते जनी खाईं, उनमैं खाली लोगै-लोग पाँच हजार रहैं। ");
INSERT INTO thr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","फिर ईसु चेलन से कही जल्दी-जल्दी नईंयाँ से तुम झील के बौ पाँजर बैतसैदा गाँव चले जाबौ, तौले मैं भीड़ पनार लेमौं। ");
INSERT INTO thr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","उनकै पनारकै ईसु पहाड़ मैं प्रार्थना करन चले गौ। ");
INSERT INTO thr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","जब संजा खिन ही गई तौ नईंयाँ झील के बीच-बाच रहै, खाली ईसु इकल्लो डींड़े मैं रहै। ");
INSERT INTO thr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","जब बौ देखी कि चेला पतवार चलात-चलात थक गै हैं, काहैकि ब्यार उल्टा उन्हईं घाँईं चलै, तौ तीन से छ: बजे के करीब मैं भुकभुको होन से पहले बौ पानी के ऊपर नेंगत भै चेलन के झोने आओ; और बौ चेलन से अग्गु जान ताहीं करै, ");
INSERT INTO thr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","लेकिन बे बाकै पानी ऊपर नेंगत देखकै डराय गै और चिल्लाए पड़े, उनकै लगो की भूत है। ");
INSERT INTO thr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","बे सबै ईसु कै देखकै डराय गै रहैं, लेकिन ईसु जल्दी से उनसे बात करन लगो और कही, “हिम्मत भाँदौ: मैं हौं; डराबौ मति!” ");
INSERT INTO thr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","फिर ईसु उनके झोने नईंयाँ मैं आए गौ, और ब्यारौ रुक गई: और बे बड़ा अचम्मो करैं। ");
INSERT INTO thr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","बे कुछ समय पहले की पाँच हजार लोगन कै रोटी खबान की बात ना समझ पाईं रहैं, काहैकि उनके मन कर्‌रे ही गै रहैं। ");
INSERT INTO thr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ईसु झील के बौ पाँजर जाएकै गन्नेसरत परदेस समुंदर के डींड़े मैं पुगे, और नईंयाँ कै डींड़े मैं करीं और भाँद दईं। ");
INSERT INTO thr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","और जब बे नईंयाँ मैं से उतरे, तौ आदमी तुरंतै उनकै जानगै, ");
INSERT INTO thr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","बौ परदेस के सब घाँईं जाए-जाएकै, बे जितने बिमार रहैं; उनकै खटिया मैं लिटाए कै, जितै-जितै ईसु मसीह की खबर मिलै बे उतई-उतई लै-लै फिरैं। ");
INSERT INTO thr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","और जितै कहूँ बौ गाँव, नगरन और बस्तियन मैं जात रहैं, तौ आदमी बिमारन कै बजारौ मैं लै चले जात रहैं और बासे नहोरे करकै कहेत रहैं कि तैं अपने लत्ता के कुंछ कै छून दे: जित्ते बाकै छूत रहैं, सबै अच्छे ही जात रहैं। ");
INSERT INTO thr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","तौ फरीसी और एक काद यहूदि नियम के सिक्छक जो यरूसलेम नगर से आए रहैं, ईसु झोने जुराए गै, ");
INSERT INTO thr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","और बे बाके कुछ चेलन कै रीत के हिसाब से छिया-पछारे हातन से खानु खात भइ देखीं, बे फरीसियन के कहेन के हिसाब से खान से अग्गु हात नाय धोईं रहैं। ");
INSERT INTO thr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","काहैकि बे फरीसी और यहूदि जाति के लोग रहैं, बे अपने पुरखन की रीत रबईय्या मानकै ही चलत रहैं, बे जबले खूबै अच्छे से हात नाय धोए लेते तौले खानु ना खात रहैं। ");
INSERT INTO thr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","बजार-घाट से आए कै, बिना हंदाए धोए तौ खानु खातै ना रहैं; औरौ दुसरी परम्परा माने करत रहैं, जैसे कटोरा, लोटा, फूल के बर्तन और खटिया कै माँजनो-धोनो। ");
INSERT INTO thr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","तभई के मारे फरीसी और यहूदि नियम के सिक्छक ईसु से पूँछी, “तेरे चेला काहेकै पुरखन की रीत रबईय्या कै ना मानथैं, और रीत के हिसाब से छिया-पछारे हातन से खाए लेथैं?” ");
INSERT INTO thr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","इतका कहतै खिना ईसु बोल उठो, “यसायाह भविस्यवक्ता जो रहै बौ तुम कपटियन ताहीं कतईये ठीकै-ठीक भविस्यवाँड़ी करी है” जैसे कि लिखो पड़ो है: “जे आदमी, मोहों से तौ मेरो आदर करथैं, लेकिन उनको मन तौ मोसे लगोई ना है। ");
INSERT INTO thr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","उनकै मेरी उपासना करकै कोई फायदा ना है, कैसे बे इंसानन की बनाई भइ बातन कै परमेस्वर को नियम करकै सिखाथैं!” ");
INSERT INTO thr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“काहैकि तुम तौ परमेस्वर के आग्या कै टालमटोल करकै इंसानन की रीत-रबईय्यन कै मानत रहथौ।” ");
INSERT INTO thr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","बौ दोहराए कै उनसे कही, “तुम तौ अपनी रीत मानन ताहीं परमेस्वर के आग्या कै एक घड़ी मैं टाल देथौ! ");
INSERT INTO thr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","जौ बात मूसा नाओं को भविस्यवक्ता हुकम दै रखाई है, ‘अपने अईय्या-दऊवा को आदर करिये,’ और ‘जो कोई अपनी अईय्या-दऊवा कै भलो-बुरो कहबै, बौ सच्ची मैं मरिये जाबै।’ ");
INSERT INTO thr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","लेकिन तुम तौ कहथौ कि अगर कोई इंसान अपने अईय्या-दऊवा से कहबै कि तोकै मोसे जो मदत होने रहै, बौ तौ दान है, मतलब जौ परमेस्वर को है। ");
INSERT INTO thr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","तौ-तौ बे उनके अईय्या-दऊवा की सेवा साति करन ताहीं कतईये मनै कर देथैं। ");
INSERT INTO thr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","जहे की बजह से तुम अपनेई रीत-रबईय्या से परमेस्वर की बात कै टाल देथौ। और ऐसियै तुम भौत कछु करथौ।” ");
INSERT INTO thr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तौ ईसु सबन कै अपने झोने बुलाएकै कही, “तुम सब जनी मेरी सुनौ और समझौ। ");
INSERT INTO thr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ऐसी कोई चीज हईये नाय जो इंसानन कै बाहर से भीतर जाएकै गंदो करै, बल्किन जो चीज इंसानन के भीतर से निकरथै, बहे बाकै गंदो करथै।” ");
INSERT INTO thr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","जो-जोके सुनन के कान हैं बौ सुन लियै। ");
INSERT INTO thr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जब बौ भीड़ छोड़कै घरै गौ, तौ बाके चेला बौ कहानी के बारे मैं पूँछन लगे। ");
INSERT INTO thr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","तौ बौ उनसे कहेन लगो कि “तुम्हऊँ ना समझपाए का? का तुम ना जानथौ? कि जो चीज इंसान के भीतर जाथै, बासे बौ असुद्ध ना होथै। ");
INSERT INTO thr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","काहैकि बौ तौ पेट मैं जाएकै सरीर से मल के जरिये निकर जाथै बौ मन मैं थोड़ी ना रहथै जौ सब कछु कहकै बौ सब खानबारी चीजन कै साफ बताई।” ");
INSERT INTO thr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","फिर बौ कहेन लगो, “जो कछु इंसानन के भीतर से निकरथै, बहे से बौ गंदो, होथै। ");
INSERT INTO thr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","काहैकि इंसानन के भीतर सेई मन मैं बुरी-बुरी सोच, छिनरइपना, चोरी करनो, मार डारनो, ");
INSERT INTO thr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","व्यभिचार, लालच, सबै तरहन के बुरे काम, छल-कपट, असलीलता, चिड़नो, बदनामी करनो, गुमान करनो, और मूर्खता की बात निकारनो। ");
INSERT INTO thr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","जे बातैं मन के भीतर सेई निकरथैं और इंसानन कै असुद्ध करथैं।” ");
INSERT INTO thr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","फिरौंकी ईसु उतै से सूर नाओं के देस मैं आओ; और एक घर मैं चले गौ, पर बौ ना चहात रहै कि कोई बाकै देखै; लेकिन बौ अपने आपकै लुकाईये ना पाई। ");
INSERT INTO thr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","और तभई एक बईय्यर आई, जोकी छोटी लौड़िया के अंदर प्रेत आत्मा रहै, बौ ईसु के बारे मैं सुनकै बाके झोने आई, और पाँव लागी। ");
INSERT INTO thr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","बौ यूनानी और सुरुफिनीकी जाति की बईय्यर रहै। बौ बासे नहोरे करी कि मेरी लौड़िया के अंदर से प्रेत आत्मा निकार दे। ");
INSERT INTO thr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ईसु बौ बईय्यर से कही, “पहले बालकन कै तौ खाए लेन दे, काहैकि उनको परसो भौ परसा उनसे छीन कै कुत्तन कै देनो ठीक ना समझथौं।” ");
INSERT INTO thr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","पर बईय्यर कही, “सच्चियै बात है प्रभु, तहुँओं कुत्तौ तौ बालकन के नीचे को पड़ो-पड़ाव रोटी को करकूना खाईये लेथैं!” ");
INSERT INTO thr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ईसु बासे कही, “तैं अब जौ कहोई है तौ चली जा प्रेत आत्मा तेरी लौड़िया के अंदर से निकर गई है।” ");
INSERT INTO thr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","जब बौ घरै आयकै देखी तौ लौड़िया खटिया मैं लेटी है, और प्रेत आत्मा निकर गई। ");
INSERT INTO thr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","फिरौंकी बौ सूर के देस से निकरकै सैदा से हुईकै दिकापुलिस से होत भौ गलील की झील झोने पुगो। ");
INSERT INTO thr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","और फिर निरे आदमी एक बैहरा कै लाईं जो गूँगौ रहै, ईसु के झोने लायकै बासे नहोरे करीं कि बौ अपनो हात बाके ऊपर रखै। ");
INSERT INTO thr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","तौ ईसु बाकै भीड़ से अलग्याँओं लैगौ, और अपनी उँगरिया बाके कान मैं डारकै थूकी, और बाकी जीभ कै छुइ; ");
INSERT INTO thr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","और स्वर्ग घाँईं देखकै आँह भरी, और बासे कही, “एफ्फाथा!” मतलब “खुल जा।” ");
INSERT INTO thr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","और बाके कान खुल गै, और बाकी जीभ की गाँठियौ खुल गई, और बौ सपा-सपा बोलन लगो। ");
INSERT INTO thr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तौ ईसु लोगन कै उपदेस दई और कही कतई कोई से मत कहियो; जो हिसाब से बौ बाकै हुकम दई रहै, बौ औरौ हुलगदड़ मचाई। ");
INSERT INTO thr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","हुँआँ के आदमी बड़ा अचम्मो करकै कहेन लगे, “बौ जो कछु करी है अच्छोई करी है; बौ बहरन कै जो पहले सुन ना पात रहैं सुनन लगे, और गूँगा जो बोल ना पात रहैं बोलन लगे।” ");
INSERT INTO thr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","बे दिनन फिर से एक मौका आओ तौ बड़ा जोड़ भीड़ जुराए गई, और उनके झोने खान कै कछुए नाय रहै, तौ ईसु अपने चेलन कै झोने बुलाएकै कही, ");
INSERT INTO thr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“मोए जौ भीड़ के ऊपर बड़ा तरस आए रहो है, काहैकि निठाठौर जे तीन दिन से मेरे संगै हैं, और उनके झोने खानौ ताहीं कछु नाय है। ");
INSERT INTO thr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","बौ कही मैं इन्हैं भूंको भेज दौ तौ, जे थक हार कै अधरस्ता मैं रह जांगे, और एक-काद तौ दूरौ के हैं।” ");
INSERT INTO thr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","बाके चेला बासे कहीं, “हिंयाँ बन मैं ढेर रोटी कोई कितै से लागो कि जे छक सकथैं?” ");
INSERT INTO thr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ईसु उनसे पूँछी, “तुमरे झोने कितका रोटी हैं?” बे कहीं “सात।” ");
INSERT INTO thr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","फिर बौ सबन से कही, कि जमीन मैं बैठ जाबौ, और सात रोटी लैकै धन्यवाद दैकै तोड़ी, और अपने चेलन कै देत जाबै कि उनके अग्गु रखै, फिर चेला सबन अग्गु परस दईं। ");
INSERT INTO thr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","उनके झोने जराएक छोटी मच्छियौ रहैं: बौ धन्यवाद दैकै उन्हऊँ कै बाँटन कही। ");
INSERT INTO thr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","बे भर पेट खाए लईं और चेला बचे कुचे टुकड़ा के सात बितौला भरे भै उठाईं। ");
INSERT INTO thr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","और हूँना चार हजार के लमसम आदमी रहैं। फिर बौ उनकै पनार दई, ");
INSERT INTO thr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","और बौ तुरंतै अपने चेलन संग नईंयाँ से दलमनूथा जिला मैं चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","कुछ फरीसी आयकै ईसु से बहस करन लगे, और बाकै अजमान ताहीं स्वर्ग को कोइसो भी चिन्ह माँगी। ");
INSERT INTO thr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","पर बौ अपने मन मैं आँह भरी और कही, “जौ समय के आदमी पता नाय काहेकै, कोई चिन्ह ढूँड़त फिरथै? ईसु उनसे कही मैं तुमसे सच्ची कहथौं हबै के आदमिन कै कोईये निसानी नाय दई जागी।” ");
INSERT INTO thr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","और फिर ईसु उनकै हूँन छोड़कै नईंयाँ से झील के बौ पाँजर चले गौ। ");
INSERT INTO thr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","चेला खान ताहीं कम खानु लईं, और जब बे नईंयाँ मैं रहैं तौ उनके झोने एकै रोटी रहै। ");
INSERT INTO thr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ईसु उनकै चिताए कै कही, “देखौ फरीसियन के खमीर और हेरोद राजा के खमीर से चौकन्ने रहियो।” ");
INSERT INTO thr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","बे आपस मैं बतकान लगे, तभई जौ ऐसो कहबै काहैकि “हमरे झोने रोटी नाय हैं।” ");
INSERT INTO thr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","जो बे कहेत रहैं बौ जानकै ईसु कही, “तुम काहे रोटी नाय होन मैं एक दुसरे से बतकाथौ? का तुम हबै तक नाय जान और समझपाए हौ? का तुमरो मन इत्तो कर्‌रो हुई गौ है? ");
INSERT INTO thr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","तुमरी आँखी होत भै तुम नाय देख पाथौ? और तुमरे कान होत भै भी नाय सुन पाथौ? तुमकै यादौ नाय है ");
INSERT INTO thr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","कि जब मैं पाँच हजारन के ताहीं पाँचै रोटी तोड़ो तौ तुम कित्ते टुकड़ा भरी भई छपरिया उठाए?” बे बासे कहीं, “बारह छपरिया।” ");
INSERT INTO thr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“और जब चार हजारन के ताहीं सात रोटी रहैं, तौ तुम कित्ते टुकड़ा भरी भई छपरिया कै उठाए रहौ?” बे फिर बासे कहीं “सात छपरिया।” ");
INSERT INTO thr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","बौ उनसे कही, “का तुम हबै तक समझिए नाय पाए?” ");
INSERT INTO thr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","फिर बे बैतसैदा मैं आए; तौ आदमी एक अंधरा कै ईसु के झोने लैयाईं और बासे नहोरे करीं कि बाकै छुइबै। ");
INSERT INTO thr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","बौ अंधरा को हात पकड़कै गाँव के दुआरे लैगौ, और बाकी आँखी मैं थूक कै बाके ऊपर हात धरकै, बासे पूँछी, “तू कछु देखथै कि नाय?” ");
INSERT INTO thr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","बौ आँखी उठाएकै कही, “मैं लौड़ा कै तौ देखत जरूर हौ लेकिन बे मोकै नेंगत भै पेंड़ के तराहनी दिखाई देथैं।” ");
INSERT INTO thr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","फिरौंकी बौ दुबारा से बाकी आँखी मैं हात रखी, और अंधरा गौर से देखी। और का देखरौ है कि बौ अच्छो हुई गौ है, और सपा-सपा देखरौ है। ");
INSERT INTO thr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ईसु बासे जौ कहकै घरै भेजी, “जौ गाँव के भीतर दुबारा पाँव मत धरिये।” ");
INSERT INTO thr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ईसु और बाके चेला कैसरिया फिलिप्पी के गाँव मैं गै। जब बे रस्ता मैं रहैं तौ अपने चेलन से पूँछन लगो, “आदमी मोसे का कहथैं बताबौ?” ");
INSERT INTO thr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“बे बासे कहीं, एकाद यूहन्ना बपतिस्मा देन बारो; लेकिन एकाद-जनी एलिय्याह भविस्यवक्ता और दुसरे भविस्यवक्तन मैं से एक कहमैं।” ");
INSERT INTO thr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“लेकिन ईसु उनसे पूँछी, तुम मोसे का कहथौ?” पतरस बासे कही, “तू मसीह है।” ");
INSERT INTO thr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तौ ईसु उनकै आग्या दई, “मेरे बारे मैं जौ बात कोई से मत कहियो।” ");
INSERT INTO thr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","तौ फिर ईसु उनकै सिखान लगो कि “इंसानन के लौड़ा के ताहीं जरूरी है कि बौ खूबै दुख उठाबैगो, और बड़े-बूढ़े और मुखिया पुजारी और यहूदि नियम के सिक्छक बाकै ठुकराए कै मार डारंगे, फिर बौ तीन दिन बाद फिर जिंदो हुई जाबैगो।” ");
INSERT INTO thr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ईसु जौ बात कै उनसे सपा-सपा कह दई। जौ बात से पतरस ईसु कै अलग्याँओं लैजाय कै झुकान लगो, ");
INSERT INTO thr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","लेकिन बौ मुरक्कै अपने चेलन घाँईं दुबारा से देखी, और पतरस कै झुकाएकै कही, “ए सैतान मेरे अग्गु से दूर हुई जा; काहैकि तैं परमेस्वर की बातन के ऊपर नाय, लेकिन इंसानन की बातन के ऊपर मन लगाथै।” ");
INSERT INTO thr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","बौ चेला समेत भीड़ कै अपने झोने बुलाई और कही, “जो मेरे पच्छू आनो चाहथै, बौ अपने आपकै इंकार करै और अपनो क्रूस उठाएकै, मेरे पच्छू आबै। ");
INSERT INTO thr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","काहैकि जो अपनी ज्यान बचानो चहागो बौ बाकै गबागो, लेकिन जो अपनी ज्यान मेरे ताहीं और सुसमाचार के ताहीं खोबैगो, बौ बाकै बचाए लेगो। ");
INSERT INTO thr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","अगर इंसान पूरी दुनिया कै पाए लेबै और अपनी ज्यान कै गबाबै, तौ बाकै का फायदा? ");
INSERT INTO thr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","इंसान अपनी ज्यान के बदले मैं का दै सकथै? ");
INSERT INTO thr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जो कोई व्यभिचारी और पापी पीढ़ी के बीच मोसे और मेरी बातन से सर्मागो, तौ इंसान को लौड़ा भी जब बौ पवित्र दूतन के संग अपने दऊवा की महिमा समेत आगो, तौ बहो से सर्मागो।” ");
INSERT INTO thr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ईसु उनसे कही, “मैं तुमसे सच्ची कहथौं कि जित्ते भी इतै ठाड़े हैं, इनमैं से कित्ते ऐसे हैं, कि जब तक परमेस्वर के राज्य कै सामर्थ्य संगै आत भइ नाय देख लेमंगे, तब तक नाय मरंगे।” ");
INSERT INTO thr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","छै दिन बाद ईसु पतरस और याकूब और यूहन्ना कै संग लई, और ऊँचे पहाड़ मैं लैगौ। जहाँ बे इकल्ले रहैं, हुँआँ उनके अग्गु, देखतै-देखत बाकी सकल पूरिये बदल गई, ");
INSERT INTO thr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","और बाके लत्ता ऐसे चमकन लागे, कि दुनिया मैं लत्ता धोन बारूओ इतनो सेतो नाय कर पातो। ");
INSERT INTO thr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","तौ बे तीनौ चेलन कै मूसा के संग एलिय्याह दिखाई दई, बे ईसु के संग बतकात रहैं। ");
INSERT INTO thr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","और पतरस ईसु से कही, “गुरुजी, जौ अच्छी बात है कि हम हिंयाँ रहमैं: तभईये हम तीन तम्बु बनाए; एक तेरे ताहीं, एक मूसा ताहीं, और एक एलिय्याह ताहीं।” ");
INSERT INTO thr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","बे बड़ा जोड़ डराय गै रहैं, जहे बजह से पतरस नाय जानत रहै कि का जबाब देबै। ");
INSERT INTO thr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तौ एक बादर उनकै छाए लई, और बौ बादर मैं से जौ अबाज निकरी, “जौ मेरो प्रिय लौड़ा है, जाकी सुनौ।” ");
INSERT INTO thr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तुरंतै बे सब घाँईं देखन लगे, और ईसु कै छोड़कै अपने संग और कोई कै नाय देखी। ");
INSERT INTO thr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","पहाड़ से उतरत पोती बौ उनकै हुकम दई, “जब तक इंसान को लौड़ा मरे भै मैं से जिंदो नाय ही जाबै, तब तक जो कछु तुम देखे हौ बौ कोई से मत कहियो।” ");
INSERT INTO thr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","बे जौ बात कै याद रखीं; और एक दुसरे से सोच बिचार करन लगे, “मरे भै मैं से जिंदो होन को का मतलब है?” ");
INSERT INTO thr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","और बे बासे पूँछन लगे, “यहूदि नियम के सिक्छक काहे कहथै कि एलिय्याह को पहले आनो जरूरी है?” ");
INSERT INTO thr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","बौ उनकै जबाब दई, “एलिय्याह सच्ची मैं पहले आयकै सब कछु सुधारैगो, पर इंसान के लौड़ा के बारे मैं सास्त्र कहथै कि बौ बड़ा दुख उठाबैगो, और ठुकराओ जागो? ");
INSERT INTO thr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पर मैं तुमसे कहथौ, कि एलिय्याह तौ आए चुको, और जैसो सास्त्र मैं बाके बारे मैं लिखो है, लोग जैसो चाँहीं बाके संग करी।” ");
INSERT INTO thr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","जब बौ बचे भै चेलन के झोने आओ, तौ देखी की उनके चारौ घाँईं बड़ी भीड़ लगी है, और यहूदि नियम के सिक्छक उनके संग बहस कर रै हैं। ");
INSERT INTO thr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","लोग ईसु कै देखत खिना कि बड़ा चौहोंक गै, और बाके घाँईं दौड़कै बाकै नमस्ते करीं। ");
INSERT INTO thr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ईसु उनसे पूँछी, “तुम इनसे काहे बहस कर रै हौ?” ");
INSERT INTO thr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","भीड़ मैं से एक जबाब दई, “गुरुजी, मैं अपने लौड़ा कै तेरे झोने लाओ रहौं, जोमैं प्रेत आत्मा समाई रहै और बौ बतकाए नाय पाथै। ");
INSERT INTO thr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","जहाँ कहूँ बौ बाकै पकड़थै, हुँए पद्द दिना गिराय देथै: और बाके मोहों मैं से बुजबुजा आन लगथै, और बाके दाँत मिस जाथैं, और बौ ऐंठ जाथै, मैं तेरे चेलन से कहो रहौं की बाकै निकार दे, लेकिन उनमैं निकारन की हिम्मत नाय रहै।” ");
INSERT INTO thr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","जौ सुनकै बौ उनकै जबाब दैकै कही, “हे अविस्वासी लोगौ, मैं कब तक तुमरे संग रहमंगो? और मैं कब तक तुमरी सकारंगो? लौड़ा कै मेरे झोने लाबौ।” ");
INSERT INTO thr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तौ बे बाकै बाके झोने लाईं: और जब बौ बाकै देखी, तौ प्रेत आत्मा बाकै तुरंत मरोड़ दई; और बौ जमीन मैं गिर गौ, और बाके मोहों मैं से बुजबुजा निकरै और बौ पल्टईंयाँ खान लग गौ। ");
INSERT INTO thr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","बौ बाके दऊवा से पूँछन लगो, “जौ हालत जाकी कब से है?” बौ कही, “बचपन से।” ");
INSERT INTO thr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“जहे प्रेत आत्मा जाकै खतम करन ताहीं कहु आगी और कहु पानी मैं गिराई; अगर तू कछु कर सकै तौ हमरे ऊपर तरस खा और मदत कर।” ");
INSERT INTO thr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“हाँ” ईसु उनकै जबाब दई, “बिस्वास करन बारे के ताहीं सब कछु ही सकथै।” ");
INSERT INTO thr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","लौड़ा को दऊवा तुरंतै गिड़गिड़ाए कै कही, “प्रभु, मैं बिस्वास तौ करथौं, और जद्धा बिस्वास करन ताहीं मेरी मदत कर।” ");
INSERT INTO thr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","तौ ईसु देखी कि लोग दौड़कै भीड़ लगाए रै हैं, तौ बौ प्रेत आत्मा कै जौ कहकै झुकाइ, गूँगी और बैहरी आत्मा मैं तोकै आग्या देथौं तू बाके भीतर से निकर जा। गूँगी और बैहरी आत्मा, “मैं तोकै आग्या देथौं, बामै से निकर जा, और फिर बामै कहुए मत घुसिये।” ");
INSERT INTO thr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तौ बौ चिल्लाए कै और बाकै बड़ा जोड़ से मरोड़ कै, निकर आई; और सबै जनी कहेन लागे “बौ मर गौ है।” ");
INSERT INTO thr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","लेकिन ईसु बौ लौड़ा को हाथ पकड़कै उठाई, और बौ ठाड़गौ। ");
INSERT INTO thr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जब ईसु घरै आओ, तौ बाके चेला अकेले मैं पूँछी, “हम प्रेत आत्मा कै काहे नाय निकार पाए?” ");
INSERT INTO thr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ईसु उनकै जबाब दई, “ऐसो भूत प्रार्थना के अलावा और कोई तरीका से नाय निकर सकथै।” ");
INSERT INTO thr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ईसु और बाके चेला हुँआँ से निकरकै गलील नगर होत भै जात रहैं। बौ नाय चहात रहै की बौ कहाँ हैं, कोई कै पता चलै, ");
INSERT INTO thr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","काहैकि बौ अपने चेलन कै उपदेस देत और उनसे कहेत रहै, “इंसान को लौड़ा आदमियन के हाथ मैं पकड़बाओ जागो, और बे बाकै मार डारंगे; और बौ मरन के तीन दिन बाद जिंदो हुई जाबैगो।” ");
INSERT INTO thr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पर बौ जो उपदेस देत रहै बौ बात उनकी समझ मैं नाय आई, और बे बासे पूँछन से डरात रहैं। ");
INSERT INTO thr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ईसु और बाके चेला कफरनहूम मैं आए; और घर मैं आए कै बौ उनसे पूँछी, “रस्ता मैं तुम कौनछी बात मैं सोच-बिचार करत रहौ?” ");
INSERT INTO thr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","बे चुप रहैं, काहैकि रहामैं बे हममैं से बड़ो कौन है बौ बात के बारे मैं सोच-बिचार करत रहैं। ");
INSERT INTO thr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","बौ बैठकै बारहों कै बुलाई और उनसे कही, “अगर कोई बड़ो होनो चाहबै, तौ अग्गु सबसे छोटो और सबकी सेवा करन बारो सेवक बनै।” ");
INSERT INTO thr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","और बौ एक बालक कै लायकै उनके बीच मैं ठड़बाए दई, और बाकै गोदी मैं लैकै उनसे कही, ");
INSERT INTO thr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जो कोई मेरे नाओं से ऐसे बालकन मैं से एक कै भी मानथै, बौ मोकै मानथै; और जो कोई मोकै मानथै, बौ मोकै नाय, बल्किन मेरे भेजन बारे कै मानथै।” ");
INSERT INTO thr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","तौ यूहन्ना ईसु से कही, “गुरुजी, हम एक आदमी कै तेरे नाओं से प्रेत आत्मा कै निकारत देखे और हम बाकै मना करन लगे, काहैकि बौ हमरे झुंड को नाय रहै।” ");
INSERT INTO thr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ईसु कही, “बाकै मत मना करौ,” ऐसो कोई नाय है जो मेरे नाओं से सामर्थ्य को काम करै, और जल्दी से मोकै बुरो कह सकै, ");
INSERT INTO thr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","काहैकि जो हमरे खिलाप मैं नाय हैं, बे हमरे घाँईं हैं। ");
INSERT INTO thr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जो कोई एक कटोरा पानी तुमकै पिबाबै कि तुम मसीह के हौ तौ मैं तुमसे सच्ची कहथौं कि बौ अपनो इनाम नाय हरबाबैगो। ");
INSERT INTO thr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“जो कोई इन छोटे मैं से मेरे ऊपर बिस्वास करथै, अगर कोई बाके बिस्वास खोन को बजह बनै तौ बाके ताहीं अच्छो जौ है कि एक बड़ी चक्की को पटला बाकी घेंट मैं लटकाओ जाए और समुंदर मैं डार दौ जाए। ");
INSERT INTO thr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","अगर तेरो हाथ तेरे बिस्वास खोन को बजह बनै तौ बाकै काट दे। टुन्डा हुईकै जिंदगी बितानो तेरे ताहीं अच्छो है कि दुई हाथ होत भइ तू नरक की आगी मैं डारो जाए जो कहुए बुतन की नाय है। ");
INSERT INTO thr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","जहाँ पर बाको कीरा नाय मरथै और आगी भी नाय बुतथै। ");
INSERT INTO thr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","अगर तेरो पाँव तेरे बिस्वास कै खोन को बजह बनै तौ बाकै काट दे। लंगड़ा हुईकै जिंदगी बितानो तेरे ताहीं अच्छो है कहूँ दुई पाँव होन के बाबजूद भी तू नरक की आगी मैं खेंक दौ जाबै, ");
INSERT INTO thr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","जहाँ पर उनको कीरा कहुए नाय मरथै और आगी भी कहुए नाय बुतथै। ");
INSERT INTO thr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","अगर तेरी आँखी तेरे बिस्वास कै खोन को बजह बनै तौ बाकै निकार दे। काना हुईकै परमेस्वर के राज्य मैं आनो तेरे ताहीं अच्छो है। कहीं ऐसो नाय होबै दुई आँखी होन के बाबजूद तू नरक की आगी मैं खेंक दौ जाबै। ");
INSERT INTO thr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","जहाँ पर बाको कीरा नाय मरथै और आगियौ नाय बुतथै।” ");
INSERT INTO thr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","काहैकि हर एक आदमी कै आगी से सुद्ध करौ जाबैगो जैसे कि भेंट कै नून से सुद्ध करो जाथै। ");
INSERT INTO thr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“नून अच्छो है; और अगर नून को नुनियानपन चले गौ तौ बाकै कासे नुनियान करैगे?” “अपने मैं दिलबराने को नुनियानपन रखौ, और एक दुसरे के संग सांति से रहबौ।” ");
INSERT INTO thr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","फिर ईसु हूँना से उठकै यहूदिया की सीमा से यरदन नदिया के पार आओ। लोगन की भीड़ फिर से बाके झोने आई और बौ हमेसा तराहनी सिखान लागो। ");
INSERT INTO thr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तौ फरीसी बाके झोने आए कै बाकै फसान की कोसिस करीं। “बे ईसु से पूँछीं,” हमकै बता, “का हमरो नियम एक आदमी कै बाकी अपनी बईय्यर कै छोड़न को अधिकार देथै?” ");
INSERT INTO thr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","तौ बौ उनकै जबाब दई। “मूसा तोकै का नियम दई है?” ");
INSERT INTO thr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","बे कहीं “मूसा अपनी बईय्यर कै नियम के जरिया एक चिट्ठी लिखकै छोड़न ताहीं इजाजत दई है।” ");
INSERT INTO thr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ईसु उनसे कही, “तुमरे कर्‌रे मन की बजह से जौ आग्या बौ तुमरे ताहीं लिखी। ");
INSERT INTO thr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","सास्त्र ऐसो कहथै, जौ दुनिया की सुरुवात से परमेस्वर लोग और बईय्यर करकै उनकै बनाई है। ");
INSERT INTO thr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","तौ जहे बजह से आदमी अपनी अईय्या और दऊवा से अलग हुईकै अपनी बईय्यर के संग रहागो, ");
INSERT INTO thr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","तौ बे दोनों एक तन हीकै एक संग रहमंगे; काहैकि अब बे दुई नाय बल्किन एक सरीर हैं। ");
INSERT INTO thr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","काहैकि जोकै परमेस्वर जोड़ी है, उनकै आदमी अलग नाय करै।” ");
INSERT INTO thr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","घर मैं आयकै चेला जाके बारे मैं बासे फिर पूँछीं। ");
INSERT INTO thr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","बौ उनसे कही, “एक आदमी अपनी बईय्यर कै तलाक दैकै दुसरी से बिहा करथै तौ बौ पहली बारी के खिलाप व्यभिचार करथै; ");
INSERT INTO thr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","जहे हानी अगर बईय्यर अपने लोगा कै तलाक दैकै दुसरे लोग से बिहा करथै तौ बौ भी व्यभिचार करथै।” ");
INSERT INTO thr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","फिर लोग बालकन कै ईसु के झोने लान लगे की बौ उनके ऊपर हाथ धरै, तौ बाके चेला उनकै झुकाईं। ");
INSERT INTO thr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ईसु जौ देखकै गुस्सा हुईकै चेलन से कही, “बालकन कै मेरे झोने आनदेयौ उनकै रोकौ मत्ती, काहैकि परमेस्वर को राज्य ऐसियनै को है। ");
INSERT INTO thr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मैं तोसे सच्ची कहथौं कि जो कोई परमेस्वर के राज्य कै बालकन जैसी नाय मानैगो, बौ परमेस्वर के राज्य मैं कहुए नाय पुगैगो।” ");
INSERT INTO thr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","फिरौंकी बौ बालकन कै गोदी मैं लई, और उनके ऊपर हाथ धरकै आर्सिवाद दई। ");
INSERT INTO thr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ईसु हुँआँ से निकरकै रहामैं जातै रहै, तौ एक आदमी भाजत भौ बाके झोने आओ, और बाके अग्गु घूँटे टेक कै बासे पूँछी, “अच्छो गुरुजी, अनंत जिंदगी पान ताहीं मैं का करौं?” ");
INSERT INTO thr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ईसु बासे कही, “तू मोकै अच्छो काहे मानथै? कोई अच्छो नाय है, खाली परमेस्वर है। ");
INSERT INTO thr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तू आग्यन कै जानतै होगो: ‘हत्या मत करिये, व्यभिचार मत करिये, चोरी मत करिये, झूठी गभाई मत दिए, ठगिये मत्ती, अपने दऊवा और अईय्या को कहनो मानिये।’” ");
INSERT INTO thr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","बौ बासे कही, “गुरुजी, इन सबन कै मैं बचपन से मानत आओ हौं।” ");
INSERT INTO thr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ईसु बाकै प्यार से देखकै बासे कही, “तेरे मैं एक बात की कमी है। जा, जो कछु तेरो है बाकै बेंच कै कंगालन कै दैदे, और तोकै स्वर्ग मैं धन मिलैगो, और मेरे पच्छू हुई ले।” ");
INSERT INTO thr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","और जौ बात से बाको मोहों पुस्केयाए गौ, बौ दुखी हुईकै चले गौ, काहैकि बौ बड़ा सेठ रहै। ");
INSERT INTO thr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ईसु सब घाँईं देखी और अपने चेलन से कही, “सेठ आदमी को परमेस्वर के राज्य मैं आनो बड़ा मुस्किल है।” ");
INSERT INTO thr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","चेला बाकी बात से अचम्मे भै। और फिर ईसु उनसे कही, “अरे बालकौ, जो धन के ऊपर भरोसो रखथै, उनको परमेस्वर के राज्य मैं जानो बड़ा मुस्किल है! ");
INSERT INTO thr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","सुईं के भार से ऊँट कै निकर जानो तौ आसान है पर परमेस्वर के राज्य मैं सेठ आदमी को घुसनों कतई मुस्किल है।” ");
INSERT INTO thr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","चेला बड़ा अचम्मे हुईकै आपस मैं कहेन लगे, “तौ फिर कौन, बचाओ जाओ सकथै?” ");
INSERT INTO thr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ईसु उनके घाँईं देखकै कही, “आदमिन से तौ जौ नाय हुई सकथै, लेकिन परमेस्वर से हुई सकथै; काहैकि परमेस्वर से सब कछु हुई सकथै।” ");
INSERT INTO thr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस उनसे कहेन लागो, “देख हम तौ सब कछु छोड़कै तेरे पच्छू हुई लै हैं।” ");
INSERT INTO thr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ईसु कही, “मैं तुमसे सच्ची कहथौं कि ऐसो कोई नाय है जो मेरे सुसमाचार के ताहीं घर या भईय्यन या बहेनियन या अईय्या-दऊवा या बाले-बच्चन या खेतन कै छोड़ दई होबै, ");
INSERT INTO thr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","बौ अब जौ समय खूबै पाबैगो। बौ सौ गुना अगरो घर, भईय्यन, बहेनियन, अईय्या, बाल-बच्चन, खेतन, सताव, और दुसरे युग मैं अनंत जिंदगी पाबैगो। ");
INSERT INTO thr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","पर बे जो बड़ा जोड़ जनी पहले से हैं, पच्छू होमंगे; और जो पच्छू हैं, बे अग्गु होमंगे।” ");
INSERT INTO thr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","बे यरूसलेम कै जात भै रहामैं रहैं, और उनके अग्गु-अग्गु ईसु जात रहै: चेला अचम्मे होन लागे। बे जो बाके पच्छू-पच्छू आत रहैं बे डरात रहैं। तौ बौ फिरौंकी बारहों कै लैकै उनसे कहेन लागो, जो बाके ऊपर आनबारी रहै, ");
INSERT INTO thr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“देखौ हम यरूसलेम कै जानथैं, इंसान को लौड़ा कै पकड़वाए कै मुखिया पुजारिन और यहूदि नियम के सिक्छकन के हाथ मैं दै दौ जागो, और बे बाकै मारन ताहीं बाकी बुराई करंगे, और गैर यहूदि कै दै देंगे। ");
INSERT INTO thr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","बे बाकी मजाक बनांगे, और बाके ऊपर थूकंगे, बाकै कोड़ा मारंगे और बाकै मार डारंगे और बौ तीन दिन बाद जिंदो हुई जागो।” ");
INSERT INTO thr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तौ जब्दी को लौड़ा याकूब और यूहन्ना बाके झोने आए कै कहीं, “गुरुजी, जो कुछ हम तोसे माँगै बौ तू हमरे ताहीं करै।” ");
INSERT INTO thr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","बौ उनसे कही, “तुम का चाहथौ?” ");
INSERT INTO thr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","तौ बे बासे कहीं, “हमैं जौ दे कि तेरे राज्य के सिंघासन की महिमा मैं जब तैं बैठैगो तौ हममैं से एक तेरे दाँए और दुसरो तेरे बाँए बैठै।” ");
INSERT INTO thr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ईसु उनसे कही, “तुम नाय जानथौ की तुम का माँग रै हौ? जो कटोरा मैं, मैं पीन बारो हौं, का तुम पी सकथौ? और जो बपतिस्मा मैं लेन बारो हौं, का तुम लै सकथौ?” ");
INSERT INTO thr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","बे बासे कहीं, “हमसे हुई सकथै।” ईसु उनसे कही, “जो कटोरा मैं पीन बारो हौं, तुम पीबैगे; और जो बपतिस्मा मैं लेन बारो हौं, बाकै लेगे। ");
INSERT INTO thr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","पर जौ अधिकार मेरो नाय है और दाँए-बाँए बैठारन को मेरो काम नाय है। जोके ताहीं जघा समारो गौ है, उनकै परमेस्वर खुद बैठारैगो।” ");
INSERT INTO thr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","जौ सुनकै बे दसौ चेला याकूब और यूहन्ना से खिसियान लगे। ");
INSERT INTO thr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","तौ ईसु उनकै झोने बुलाएकै उनसे कही, “तुम जानथौ की गैर यहूदि के हाकिम माने जाथैं; और बे उनके ऊपर राज्य करत रहैं; और उनमैं जो बड़ो है, उनके ऊपर अधिकार दिखात रहै। ");
INSERT INTO thr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पर तेरे मैं ऐसो न है, जो कोई तुम मैं से बड़ो होनो चाहथै बौ तुमरी सेवा करन बारो सेवक बनै; ");
INSERT INTO thr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","और जो कोई तुम मैं से मुखिया बननो चाहबै सबको दास बनै। ");
INSERT INTO thr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","इंसान को लौड़ा जाके ताहीं नाय आओ है कि बाकी सेवा करी जाबै, बल्कि जाके ताहीं आओ कि बौ खुद सेवा करै, और दुसरेन कै छुड़ान ताहीं अपनी ज्यान देबै।” ");
INSERT INTO thr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ईसु और बाके चेला यरीहो मैं आए, और बे एक बड़ी भीड़ संग यरीहो से निकरत रहैं, तौ तिमाही को लौड़ा बरतिमाई, एक अंधरा भिकमंगा रस्ता टिकारे बैठो रहै। ");
INSERT INTO thr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","बौ जौ सुनकै की ईसु नासरी है, तौ चिल्लाए-चिल्लाए कै कहेन लगो, “दाऊद को लौड़ा, ईसु मेरे ऊपर दया कर।” ");
INSERT INTO thr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","सबै जनी बाकै झुकाइ की चुप्पा रहा, बौ और चिल्लान लागो, “ए दाऊद को लौड़ा, मेरे ऊपर दया कर।” ");
INSERT INTO thr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तौ ईसु रुक कै कही, “बाकै बुलाबौ।” और बे आदमी अंधरा कै बुलाएकै बासे कहीं, “हिम्मत भाँद! उठ! बौ तोकै बुलाए रौ है।” ");
INSERT INTO thr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","बौ अपनो लत्ता खेंक कै तुरंत उठो, और ईसु के झोने आओ। ");
INSERT INTO thr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","तौ फिर ईसु बासे कही, “तू का चाहथै कि मैं तेरे ताहीं करौं?” अंधरा बासे कही, “गुरु, मैं फिर से देखन लगौं।” ");
INSERT INTO thr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ईसु बासे कही, “चले जा, तेरो बिस्वास तोकै अच्छो करी है।” बौ तुरंत देखन लगो, और रस्ता मैं बाके पच्छू हुई लई। ");
INSERT INTO thr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जब ईसु और बाके चेला यरूसलेम झोने, जैतून पहाड़ के बैतफगे और बैतनिय्याह के झोने आओ, बौ अपने चेलन मैं से दुई कै जौ कहकै पनारी, ");
INSERT INTO thr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“झोने के गाँव मैं जाबौ, हूँना पुगकै एक गधईया को बच्चा, जोके ऊपर कोई नाय बैठो है, बंधो भौ तुमकै मिलैगो। बाकै खोल लाबौ। ");
INSERT INTO thr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","तुमसे कोई पूँछै जाको तुम का करैगे, तौ कहियो, ‘गुरु कै जरूरत है,’ और बौ तुरंतै बाकै हिंयाँ पनार देगो।” ");
INSERT INTO thr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","बे जाएकै बौ बच्चा कै दुआरे फाटक के झोने खुटी मैं बंधो भौ पाईं, तौ खोलन लगे। ");
INSERT INTO thr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","बामै से जो हूँना ठाड़े रहैं, कोई-कोई कहेन लागे, “गधईया के बच्चा कै काहे खोल रै हौ?” ");
INSERT INTO thr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","जैसी ईसु उनसे कही, बैसिये बे उनसे कह दईं; तौ लोग उनकै जान दईं। ");
INSERT INTO thr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","बे बच्चा कै ईसु के झोने लाईं और बे बाके ऊपर लत्ता डारीं और बौ बाके ऊपर बैठगौ। ");
INSERT INTO thr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","तौ निरे जनी अपने लत्ता रहामैं बिछाईं और दुसरे आदमी खेत मैं से हँगईय्या तोड़-तोड़कै रहामैं फैलाय दईं, ");
INSERT INTO thr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","जो बाके अग्गु-अग्गु जात रहैं और जो बाके पच्छू-पच्छू आत रहैं, चिल्लाए-चिल्लाए कै कहेत जात रहैं, “होसन्ना! धन्य है बौ जो प्रभु के नाओं से आथै। ");
INSERT INTO thr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","हमरो दऊवा राजा दाऊद को राज्य जो आए रौ है; धन्य है! होसन्ना।” ");
INSERT INTO thr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ईसु यरूसलेम पुगकै मंदिर मैं आओ, और सब चीज देखकै बारहों के संग बैतनिय्याह गौ, काहैकि संजा खिन हुई गई रहै। ");
INSERT INTO thr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","दुसरे दिन ईसु और बाके चेला बैतनिय्याह से निकरे तौ बाकै भूंक लगी। ");
INSERT INTO thr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","बौ दूर से अंजीर को एक हरो रूखा देखकै बाके झोने गौ की बामै कछु होबै: बामै पत्ता के अलावा कछुए नाय पाई; काहैकि बौ समय फरन की बेरा नाय रहै। ");
INSERT INTO thr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","तौ बौ बासे कही, “अब से तेरो फरा कहुए कोई नाय खागो!” और बाके चेला सुनत रहैं। ");
INSERT INTO thr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","बे फिर यरूसलेम मैं आए, और बौ मंदिर मैं गौ; जो हूँना खरीदन और बेचन को काम करत रहैं उनकै दुआरे निकारन लागो, रुपईया-पैसन कै बदलन बारेन और कबूतर बेचन बारेन की मेज कै पलट दई। ");
INSERT INTO thr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","और मंदिर मैं से हुईकै कछुए लैकै नाय आन-जान दई। ");
INSERT INTO thr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","और उपदेस दैकै उनसे कही, “का जौ सास्त्र मैं नाय लिखो है कि मेरो घर सब देस के लोगन के ताहीं प्रार्थना को घर कहो जाबै? और तुम जाकै डकैतन की जघा बनाए दै हौ।” ");
INSERT INTO thr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","जौ सुनकै मुखिया पुजारी और यहूदि नियम के सिक्छक ईसु कै मार डारन की सोचन लागे; काहैकि बे बासे डरात रहैं, और बाके उपदेस से पूरो झुंड अचम्मो मानत रहैं। ");
INSERT INTO thr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","संजा भौ तौ ईसु और बाके चेला सहर से दुआरे चले गै। ");
INSERT INTO thr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","भोर भौ तौ ईसु और बाके चेला उतै से जात रहैं तौ बे अंजीर के रूखा कै जड़ तक सूखो भौ देखीं। ");
INSERT INTO thr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरस कै बौ बात याद आई, और बौ उनसे कही, “गुरु, देख! जौ अंजीर को रूखा जोकै तू बद्‌दुआ दौ रहै, सूख गौ है।” ");
INSERT INTO thr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ईसु बाकै जबाब दई, “परमेस्वर के ऊपर बिस्वास रखौ। ");
INSERT INTO thr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मैं तोसे सच्ची कहथौं कि जो कोई जौ पहाड़ से कहबै, तू उखड़ जा, और समुंदर मैं गिर जा, और अपने मन मैं संका नाय करै, बल्किन जौ बिस्वास करै कि जो कहो हौं बौ हुई जाबैगो, तौ बाके ताहीं बहे होगो। ");
INSERT INTO thr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","जहेमारे मैं तुमसे कहथौं कि जो कुछ तुम प्रार्थना करकै माँगौ, तौ भरोसो कर लेयौ कि तुमकै मिलगौ, और तुमरे ताहीं हुई जाबैगो। ");
INSERT INTO thr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","जब कहूँ तुम ठाड़कै प्रार्थना करथौ, तुमरे मन मैं कोई के ताहीं गुस्सा होबै, तौ माफ कर दियौ: तभई तुमरो स्वर्ग को दऊवा जो बात तुम गलत करे हौ माफ करैगो। ");
INSERT INTO thr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","अगर तुम माफ नाय करौ तौ तुमरो दऊवौ जो स्वर्ग मैं है, तुमरो पाप माफ नाय करैगो।” ");
INSERT INTO thr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ईसु और बाके चेला फिरौंकी यरूसलेम मैं आए, और जब बे मंदिर मैं फिरत रहैं तौ मुखिया पुजारी और यहूदि नियम के सिक्छक और बड़े-बूढ़े बाके झोने आए कै पूँछन लगे, ");
INSERT INTO thr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“तू जे काम कौन्छे अधिकार से करथै? और जौ अधिकार तोकै कौन दौ है?” ");
INSERT INTO thr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ईसु उनसे कही, “महुँ तुमसे एक बात पूँछ थौं; मोकै जबाब देयौं तौ मैं तुमकै बतांगो कि जौ काम कौन्छे अधिकार से करथौं। ");
INSERT INTO thr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्ना को बपतिस्मा का स्वर्ग से रहै की आदमियन के घाँईं से रहै मोकै बताबौ?” ");
INSERT INTO thr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","तौ बे आपस मैं बातचीत करन लागे अगर हम कहमैं: “स्वर्ग की घाँईं से” तौ बौ कहगो, “तुम बाके ऊपर बिस्वास काहेकै नाय करे? ");
INSERT INTO thr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","और अगर हम कहमैं, ‘आदमियन की घाँईं से, तौ उनकै लोगन को डर रहै, काहैकि सब जानत रहैं कि यूहन्ना सच मैं भविस्यवाँड़ी करन बारो रहै।’” ");
INSERT INTO thr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","और बे ईसु कै जबाब दईं, “हम नाय जानथैं।” ईसु उनसे कही, “महुँ तुमकै नाय बतांगो की जौ काम कौन के अधिकार से करथौं।” ");
INSERT INTO thr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","फिर ईसु कहानी मैं उनसे बात करन लागो: “एक आदमी अंगूर की बारी लगाई, और बाके चारौ तरफ बेहड़ा लगाई, और रस के ताहीं गड्डा खोदी, और गुम्मट बनाई। और कमईंयन कै बाको ठेका दैकै दुसरे देस कै चलो गौ। ");
INSERT INTO thr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","फिर फरा बारे महेना के बेरा मैं, बौ किसानन के झोने एक दास कै पनारी कि किसानन से अंगूर की बारी के फरा को हिस्सा लै आबै। ");
INSERT INTO thr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पर बे बाकै पकड़कै भौत मारीं और खाली हाथ लौटाय दईं। ");
INSERT INTO thr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","फिर बौ एक और दास कै उनके झोने पनारी; बे बाको मूड़ फोड़ दईं और बाकी बेजती करीं। ");
INSERT INTO thr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","फिर बौ एकौर कै पनारी, बाकै बे मारडारीं; तौ बौ निरे जनी कै पनारी, उनमैं से बे कुछ एक कै पीटीं, और कुछन कै मारडारीं। ");
INSERT INTO thr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","अब एक रहगौ रहै, जो बाको प्रिय लौड़ा रहे। और आखरी मैं बाकै जौ सोचकै पनारी कि ‘बे मेरे लौड़ा की इज्जत’ करंगे। ");
INSERT INTO thr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","बे कमईंयाँ आपस मैं कहीं, ‘जहे तौ बारिस है; आबौ हम जाकै मार डारैं, तौ जमीन हमरी हुई जाबैगी!’” ");
INSERT INTO thr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","और बाकै पकड़कै मारडारीं और अंगूर की बारी के दुआरे फेंक दईं। ");
INSERT INTO thr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“तौ अब, अंगूर की बारी को मालिक का करैगो?” बौ आए कै बे कमईंयन कै बरबाद कर देगो, और अंगूर की बारी दुसरे कै दै देगो। ");
INSERT INTO thr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","का तुम जौ बचन पवित्र सास्त्र मैं नाय पढ़े हौ? “जो पथरा कै राजमिस्त्री ठुकराई बहे मकान के कोहने को खास हिस्सा हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","जौ प्रभु की मरजी से भौ; और हमरी नजर मैं अचम्मो है!” ");
INSERT INTO thr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","तौ यहूदि नेता बाकै पकड़न ताहीं करीं; काहैकि बे समझ गै कि बौ उनसे कहानी मैं उनके खिलाप मैं कही है। पर बे लोगन से डरात रहैं, और बाकै छोड़कै चले गै। ");
INSERT INTO thr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","तौ ईसु कै बातन मैं फसान ताहीं फरीसियन और हेरोदियन कै बाके झोने पनारी। ");
INSERT INTO thr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","बे आयकै बासे कहीं, “गुरुजी हम जानथैं, कि तू सच्चो है, और कोई की परबाह नाय करथै; काहैकि तू आदमिन को मोहों देखकै बात नाय करथै, पर परमेस्वर की रहा अच्छे से बताथै। तौ का कैसर कै नियम से हिसाब से लगान देनो अच्छो है या नाय?” ");
INSERT INTO thr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","हम देमैं, या नाय देमैं, “बौ उनको कपट जानकै उनसे कही, मोकै काहे परखथौ? एक चाँदी को सिक्का मेरे झोने लाबौ, कि मैं बाकै देखौं।” ");
INSERT INTO thr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","बे लै आईं, और बौ बासे कही, “जौ छापो और नाओं कौन को है?” तौ बे कहीं, “कैसर को।” ");
INSERT INTO thr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ईसु उनसे कही, “जो कैसर को है बौ कैसर कै, और जो परमेस्वर को है बौ परमेस्वर कै देबौ।” तौ बे बड़ा अचम्मो मानन लागे। ");
INSERT INTO thr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","फिर कुछ सदूकी, जौ कहेत रहैं कि मरे भैन को जिंदो होनो हईये नाय, ईसु झोने आयकै बासे पूँछी, ");
INSERT INTO thr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ओ गुरु, मूसा हमरे ताहीं लिखी है कि अगर बाको भईय्या बिना बालक के मर जाबै और बाकी बईय्यर रह जाबै तौ बाको भईय्या बासे बिहा कर लेबै और अपने भईय्या के ताहीं बालक पैदा करै। ");
INSERT INTO thr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","सात भईय्या रहैं। सबसे बड़ो बारो बिहा करकै बिना बालक के मर गौ। ");
INSERT INTO thr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तौ दुसरो भईय्या बौ बईय्यर से बिहा कर लई और बिना बालक के मर गौ; और बैसिये तीसरो बारो भी करी। ");
INSERT INTO thr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","और सातौ भईय्या से बालक नाय भै। और सबन के पच्छू बौ बईय्यर भी मर गई। ");
INSERT INTO thr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","अच्छेया तौ जिंदो होन के बाद बौ कौनकी बईय्यर होगी? काहैकि बौ सातौ की बईय्यर बन चुकी रहै।” ");
INSERT INTO thr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ईसु उनसे कही, “का तुम जौ बजह से भूल मैं नाय पड़े हौ कि तुम पवित्र सास्त्र कै नाय जानथौ, और नाय परमेस्वर कि सामर्थ्य कै? ");
INSERT INTO thr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","काहैकि जब बे मरे भै मैं से जिंदे हुई जामंगे, तौ ना बे बिहा करंगे और ना बिहा कर सकंगे, और स्वर्ग मैं दूतन के हानी होंगे। ");
INSERT INTO thr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरे भै के जिंदो होन के बारे मैं का तुम मूसा की किताब झाड़ी की कहानी मैं नाय पढ़े? कि परमेस्वर बासे कही, ‘मैं अब्राहम को परमेस्वर, और इसहाक को परमेस्वर, और याकूब को परमेस्वर हौं।’ ");
INSERT INTO thr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","परमेस्वर मरे भैन को नाय बल्किन जिंदेन को परमेस्वर है; तुम बड़ा भूल मैं हौ।” ");
INSERT INTO thr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","यहूदि नियम के सिक्छकन मैं से एक आयकै उनकै लड़त भइ सुनी, और जौ जानकै कि ईसु उनकै सई-सई जबाब दई, बासे पूँछी, “सबसे बड़ी आग्या कौन सी है?” ");
INSERT INTO thr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ईसु उनकै जबाब दई, “सब आग्यन मैं से जौ अच्छी है: ‘अरे इस्राएल सुन! प्रभु हमरो परमेस्वर एकै परमेस्वर है, ");
INSERT INTO thr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","और प्रभु अपने परमेस्वर से अपने पूरे मन से, और अपनी पूरी ज्यान से, और अपनी पूरी अकल से, और अपनी पूरी ताकत से प्यार रखनो।’ ");
INSERT INTO thr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","और दुसरी आग्या जौ है, ‘कि तू अपने पड़ोसी से अपने हानी प्यार रखिये।’ जासे बड़ी और कोई आग्या नाय है।” ");
INSERT INTO thr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","यहूदि नियम के सिक्छक बासे कही, “अरे गुरु बड़ा अच्छो! तू सच्ची कहो कि बौ एकै है, और बाकै छोड़ और कोई नाय। ");
INSERT INTO thr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","और परमेस्वर से पूरे मन, और पूरी बुद्धि, और पूरी ज्यान से, और पूरी ताकत से प्यार रखनो; और पड़ोसी से अपने हानी प्यार रखनो, सारे पसु बलियन और सबै बलिदान से बढ़कै है।” ");
INSERT INTO thr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","तौ ईसु देखी कि बौ समझदारी से जबाब दई, तौ बासे कही, “तू परमेस्वर के राज्य से दूर नाय।” और कोई की भी बासे कछु पूँछन की हिम्मत नाय पुगी। ");
INSERT INTO thr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","फिर ईसु मंदिर मैं उपदेस देत भइ जौ कही, “यहूदि नियम के सिक्छक काहे कहथैं कि मसीह दाऊद को लौड़ा है?” ");
INSERT INTO thr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाऊद खुद पवित्र आत्मा मैं हुईकै जौ कही है: “प्रभु मेरे प्रभु से कही: मेरे दहने बैठ जब तक मैं तेरे बैरियन के बंस कै तेरे टाँग तरे नाय कर देयौं।” ");
INSERT INTO thr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाऊद तौ खुद बाकै “प्रभु कहथै; फिर बौ बाको लौड़ा कहाँ से भौ? और भीड़ के आदमी बाकी मगन हीकै सुनत रहैं।” ");
INSERT INTO thr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","बौ अपने उपदेस मैं बासे कही, “यहूदि नियम के सिक्छकन से चहाचीते रहबौ, जो लम्बे-लम्बे चोंगा पहनकै फिरथैं और बजारन मैं नमस्ते, ");
INSERT INTO thr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","और सभाघर मैं अच्छे-अच्छे आसन और हटकना मैं अच्छी-अच्छी जघा भी चाहथैं। ");
INSERT INTO thr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","बे बिधवन के घरन कै खाए जाथैं, और दिखान ताहीं बड़ी देर तक प्रार्थना करत रहथैं। बे भौत सजा पांगे।” ");
INSERT INTO thr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ईसु मंदिर के भंडार के सामने बैठकै देखत रहै कि आदमी मंदिर के भंडार मैं कैसे पैसा डारथैं; और सेठ आदमी गजब-गजब डारीं। ");
INSERT INTO thr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","इत्ते मैं एक कंगाल बिधवा आयकै दुई ताँबे के छोटे सिक्का डारी। ");
INSERT INTO thr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तौ बौ चेलन कै झोने मस्काए कै उनसे कही, “मैं तुमसे सच्ची कहथौं कि मंदिर के भंडार मैं डारन बारेन से जौ कंगाल बिधवा सबसे जाधा डारी है; ");
INSERT INTO thr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","काहैकि सब अपनी जाधा सम्पत्ति मैं से डारी हैं, लेकिन जौ अपनी घटी मैं से जो कुछ बाको रहै, बौ सब डार दई है।” ");
INSERT INTO thr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जब ईसु से मंदिर से निकरत रहै, तौ बाके चेलन मैं से एक बासे कही, “ए गुरु, देख कैसे बड़े-बड़े पथरा और इमारत हैं!” ");
INSERT INTO thr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","तौ ईसु बासे कही, “का बड़ी-बड़ी इमारत देखथौ: हींना पर एकौ पथरा नाय बचैगो जो गिराओ नाय जागो।” ");
INSERT INTO thr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ईसु मंदिर के अग्गु जैतून पहाड़ मैं बैठो रहै, तौ पतरस, याकूब, यूहन्ना और अन्द्रियास इकल्ले मैं बाके झोने आए। ");
INSERT INTO thr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","बासे पूँछी, “हमकै बता जे बात कब होंगी? और जे जब सब बात पूरी होन बारी होंगी बौ समय को का चिन्ह होगो?” ");
INSERT INTO thr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ईसु उनसे कहेन लागो, “चहाचीते रहियो कोई तुमकै भरमाबै ना। ");
INSERT INTO thr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","निरे मेरो नाओं लैकै कहमंगे, ‘मैं बहे हौं!’ और निरेन कै बहकामंगे।” ");
INSERT INTO thr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जब तुम लड़ाई की बात सुनौ, तौ मत डरईयो; काहैकि इनको होनो जरूरी है, लेकिन बौ अंत ना होगो। ");
INSERT INTO thr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","देस एक दुसरे से लड़ंगे, राज्य एक दुसरे ऊपर हमला करंगे और सब कहूँ हालाचाला होंगे, और सूखा पड़ैगो। जौ सब कछु बालका होन के अग्गु को पीर हानी होगो। ");
INSERT INTO thr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","पर तुम चहाचीते रहियो; काहैकि आदमी तुमकै पंचायतन मैं सौंपंगे और सभाघरन मैं पीटे जांगे और सुसमाचार के बजह से तुमकै हाकिमन और राजाओं के अग्गु खड़ो करौ जागो, ताकी उनके ताहीं गभाई होबै। ");
INSERT INTO thr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","और जौ जरूरी है कि अग्गु सुसमाचार को प्रचार सब आदमिन मैं करो जाबै। ");
INSERT INTO thr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","जब बे तुमकै लै जाएकै सौंपैं, तौ अग्गु से चिंता मत करियो कि हम का बोलंगे; और तुमकै जैसो बताओ जाबै बैसोई कहियो; काहैकि बोलन बारे तुम ना बल्किन पवित्र आत्मा है। ");
INSERT INTO thr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","भईय्या-भईय्या कै और दऊवा लौड़ा कै मरन के ताहीं सौंप देंगे, बालका अपने अईय्या-दऊवा के खिलाप मैं उठंगे और उनकै जान से मरबाए देंगे। ");
INSERT INTO thr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","और मेरो नाओं की बजह से सब जनी तुमसे बुरो बर्ताव करंगे। लेकिन जो आखरी तक सबर रखैगो, बहे को उद्धार होगो। ");
INSERT INTO thr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“जब तुम बौ ‘बरबाद करन बारी बुरी चीजन’ कै जहाँ ठीक नाय हूँना बाकै ठाड़ी देखौ।” पढ़न बारो समझ जाए: तौ जो यहूदिया मैं होमैं, बे पहाड़ मैं भाज जामैं! ");
INSERT INTO thr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जो कोई छत के ऊपर हैं, बौ अपने घर मैं से कछु लेन ताहीं तरे ना आमै और ना भीतर जामैं; ");
INSERT INTO thr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","और जो खेत मैं हैं, बे अपनो लत्ता लेन पच्छू ना लौटैं। ");
INSERT INTO thr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","बे दिनन मैं जो गरब से होंगी, और जो दूद पिबान बारी होंगी उनके ताहीं कित्तो भयानक होगो। ");
INSERT INTO thr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","और प्रार्थना करौ कि ऐसो जाड़ो के समय ना होबै ");
INSERT INTO thr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","काहैकि जे दिनन मैं ऐसो दुख आगो जो दुनिया की सुरुवात से परमेस्वर बनाई है, अब तक ना तौ भौ, और ना कहुए दोहराए कै होबैगो। ");
INSERT INTO thr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अगर प्रभु बे दिनन कै ना घटातो, तौ कोईये लोग ना बचते। लेकिन बे छटे भै की बजह से जिनकै बौ चुनी, तभई जौ समय कै घटाई। ");
INSERT INTO thr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“बहे समय कोई भी तुमसे कहबै, देखौ, मसीह! हींना है, ‘देखौ, हूँना है!’ तौ भरोसा मत करियो।” ");
INSERT INTO thr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","काहैकि झूठे मसीह और झूठे भविस्यवक्ता ठाड़ जामंगे। चिन्ह और तरह-तरह के चमत्कार दिखांगे ताकी चुने भै आदमिन कै भी भरमाए देमैं। ");
INSERT INTO thr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","लेकिन तुम चहाचीते रहियो; देखौ जे सब बात होन से अग्गुए बताए देथौं। ");
INSERT INTO thr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“बे दिनन मैं दुख के बाद दिन अंधियारो मैं बदल जागो, और जोनी उजियारो नाय देगी, ");
INSERT INTO thr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","और आसमान से तारा गिरन लगंगे, और आसमान की सक्तियन कै हलाओ जागो। ");
INSERT INTO thr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तौ आदमी इंसान के लौड़ा कै पूरी सामर्थ्य, और महिमा के संग बादर मैं आत देखंगे। ");
INSERT INTO thr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","बहे समय बौ अपने स्वर्गदूतन कै पनारकै, दुनिया के एक छोर से दुसरे छोर तक, चारौ घाँईं से अपने चुने भै आदमिन कै जोरैगो।” ");
INSERT INTO thr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“अंजीर के रूखा से जौ कहानी सिकौ: जब बाकी हँगईय्या मुलायम होथैं, और उनमैं से कन्ति निकरथैं; तौ तुम पता लगाए लेथौ कि गर्मी को मौसम आनबारो है। ");
INSERT INTO thr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","अगर जे बात ऐसो होत भै देखैगे, तौ जान लियो, कि बौ झोने है बल्किन दुआरे है। ");
INSERT INTO thr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","मैं तुमसे सच्ची बात कहथौं, ऐसो जब तक पूरो ना होगो, तब तक कोई पीढ़ी खतम नाय होबैगी। ");
INSERT INTO thr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","दुनिया और आसमान मिट जागो, लेकिन मेरी बात कहुए नाय मिटंगी।” ");
INSERT INTO thr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“बाकई मैं बौ दिन या पल कब आगो ऐसो कोईये नाय जानथै, ना स्वर्ग के स्वर्गदूत ना लौड़ा; सिरफ दऊवा जानथै। ");
INSERT INTO thr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","जगत रहियो, चहाचीते रहियो; तुमकै ना पता है बौ समय कब आए जागो। ");
INSERT INTO thr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","जौ बौ आदमी के गत की तरह है जो परदेस जान पोती अपनो घर छोड़ जाबै, और अपने सेवक कै काम सौंपै, और सबन कै बाकी जिम्मेदारी देबै, और रखबरिया कै जगत रहेन कि आग्या देबै। ");
INSERT INTO thr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","जहेमारे जगत रहियो, काहैकि तुम कछु नाय जानथौ कि घर को मालिक कब आए जाबै, संजा कै या आधी रात कै या मुर्गा के बास देन के समय या दिन निकरन से अग्गु। ");
INSERT INTO thr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ऐसो ना होबै कि अनकाचीति आए कै, और तुमकै सोत भै पाबै। ");
INSERT INTO thr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","और जो भी बात तुमकै बताओ, मैं सबसे कहथौं: जगत रहियो!” ");
INSERT INTO thr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दुई दिन के बाद फसह और अखमीरी रोटी को त्योहार आनबारो रहै। मुखिया पुजारी, यहूदि नियम के सिक्छक जौ ताक मैं रहैं कि ईसु कै कैसे धोका से पकड़कै जान से मार डारैं। ");
INSERT INTO thr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“फिर बे कहेन लागे त्योहार के दिन नाय,” कहीं ऐसो न होबै, “कि आदमिन मैं हुलगदड़ मच जाबै।” ");
INSERT INTO thr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जब ईसु बैतनिय्याह मैं सिमौन कोहढ़ी के घर मैं खानु खान बैठो तभई बाके झोने एक बईय्यर संगमरमर के बर्तन मैं जटामांसी की कीमती सुद्ध इत्तर संग लाई; और बाके मूड़ इत्तर अखनाए दई। ");
INSERT INTO thr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","तौ कुछ आदमी गुस्सा करत भै कहेन लागे, “जौ इत्तर कै काहे बरबाद करो गौ? ");
INSERT INTO thr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","जबकी जौ इत्तर तीन सौ चाँदी के सिक्का से जाधे मैं बेचकै गरीबन मैं बाँट देते!” और बाके ऊपर गुस्सा होन लगे। ");
INSERT INTO thr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ईसु उनसे कही, “बाकै छोड़ देबौ! बाकै काहे सताथौ? बौ तौ मेरे संग भलो करी है। ");
INSERT INTO thr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरीब तौ तुमरे संग हमेसा रहेंगे, और कहु भी उनके संग भलाई कर लेगे, लेकिन मैं तुमरे संग हमेसा ना रहेंगो। ");
INSERT INTO thr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","बौ जो कुछ कर सकी, बौ करी, बौ मेरे दफन होन की तैयारी से अग्गु मेरे सरीर कै जटामांसी नाओं के तेल से अभिसेक करी है। ");
INSERT INTO thr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मैं सच्ची-सच्ची कहथौं पूरी दुनिया मैं कहूँ भी सुसमाचार बताओ जागो, बाके काम की बात की बड़ाँईं जरूर करी जाबैगी।” ");
INSERT INTO thr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","और यहूदा इस्करियोती जो बारहों मैं से एक रहै, और बौ मुखिया पुजारिन के झोने गौ ताकी उनके हाथ ईसु कै पकड़वाए सकै। ");
INSERT INTO thr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","जे बात बाकी सुनकै बे बड़ा खुस भै, और बाकै रुपईया देन के ताहीं वादा करीं; और बौ मौका ढूँड़न लागो कि ईसु कै कौन सी तरकीब से पकड़बामैं। ");
INSERT INTO thr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अखमीरी रोटी त्योहार के पहले दिन, जामैं बे फसह त्योहार कै डंगर को यानी भेंड़ के बच्चा कै मारत रहैं, तौ ईसु के चेला बासे पूँछी, “तू कितै जानो चाहथै कि हम तेरे ताहीं फसह खानु को बंदोबस्त करैं?” ");
INSERT INTO thr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ईसु अपने दुई चेलन कै जौ कहकै पनारी: “गाँव मैं जाबौ, और एक आदमी तुमकै पानी से भरो घल्ला उठात भै मिलैगो। तौ बाके पच्छू जात रहियो ");
INSERT INTO thr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","और बौ जो घर मैं जाबै, बौ घर के मालिक से कहियो: ‘गुरु कही है, कि अलग से बैठन की जघा कहाँ है?’ जोमैं मैं अपने चेलन के संग फसह को खानु खाए सकौं। ");
INSERT INTO thr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","बौ तुमकै एक सजी सजाई, और सब बंदोबस्त करी भइ ऊपर की एक कुठरिया बताए देगो, बामै हम सबन के ताहीं फसह के खानु की तैयारी करियो।” ");
INSERT INTO thr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","बाके कहेन के मुताबिक चेला नगर मैं आए, और जैसो ईसु कही रहै, बैसोई पाईं; और बौ जघा मैं फसह तैयार करीं। ");
INSERT INTO thr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जब संजा भइ, तौ हूँना बारहों चेलन कै लैकै आओ। ");
INSERT INTO thr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","जब सब बे खानु खान बैठन लगे, तौ ईसु कहेन लागो, “मैं तुमसे सच्ची कहथौं, तुम मैं से एक, जो मेरे संग खानु खाए रौ है, मोकै पकड़बागो।” ");
INSERT INTO thr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","तभई सब चेला निरास हुईगै और पाली-पाली से बासे पूँछन लागे, “का बौ मैं हौं?” ");
INSERT INTO thr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ईसु उनकै जबाब दई, “बौ बारह मैं से एक है, जो मेरे संग थरिया मैं हात डारथै। ");
INSERT INTO thr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","जैसो इंसान के लौड़ा के बारे मैं लिखो है, बौ हुईकै रहगो; लेकिन कित्तो भयानक बौ आदमी के ताहीं होगो जो मोकै पकड़बागो!” ");
INSERT INTO thr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","जब बे खात रहैं, तौ ईसु रोटी लई, और धन्यवाद की प्रार्थना करकै रोटी तोड़ी, और उनसे कही। लेबौ, “जौ मेरी सरीर है।” ");
INSERT INTO thr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","तौ फिर बौ कटोरा लई और धन्यवाद करकै दई; और सब बामै से पीं। ");
INSERT INTO thr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","और बौ उनसे कहेन लागो, जौ मेरो वाचा को बौ खून है, “जो सबन के ताहीं बहाओ जाथै। ");
INSERT INTO thr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","मैं तुमसे सच्ची कहथौं, बौ दिन तक दाखरस नाय पीहौं, जबले परमेस्वर के राज्य मैं नई दाखरस नाय पियौं।” ");
INSERT INTO thr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","फिर बे गीत गात जैतून पहाड़ मैं चले गै। ");
INSERT INTO thr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तौ ईसु उनसे कही, “तुम सब मोकै छोड़कै भाज जाबैगे, ऐसो सास्त्र मैं लिखो है, ‘मैं बरदिया कै मारंगो, और भेंड़ तितर-बितर हुई जांगी।’ ");
INSERT INTO thr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","लेकिन मैं अपने जिंदो होन के बाद तुमसे अग्गु गलील कै जांगो।” ");
INSERT INTO thr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पतरस बासे कहेन लागो, “सबै तोकै छोड़ देमैं लेकिन मैं नाय छोड़ंगो।” ");
INSERT INTO thr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ईसु बासे कही, “मैं तोसे सच्ची कहथौं, आजै जहे रात मैं मुर्गा के दुई बार बासन के अग्गु, तू तीन बार मोसे मुकर जागो।” ");
INSERT INTO thr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","लेकिन बौ और जोर दैकै कहेन लागो, “अगर मोकै तेरे संग मरन भी पड़ै, तहुँओं कहुए नाय मुकरंगो!” और सबै चेला बासे ऐसिये कहीं। ");
INSERT INTO thr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ईसु और बाके चेला गतसमनी नाओं की एक जघा मैं आए, और बौ अपने चेलन से कहेन लागो, “जहे जघा मैं बैठे रहियो जबले मैं प्रार्थना कर लेमौं।” ");
INSERT INTO thr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","और बौ पतरस, याकूब और यूहन्ना कै अपने संग लैकै गौ। फिर बौ बड़ा बेचैन और उदास होन लागो, ");
INSERT INTO thr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","और बौ उनसे कहेन लागो, “मेरो मन बड़ा बेचैन है, हींना तक की मेरी जान निकरन कै है। तुम हीनैं रुकियो और चौकन्ने रहियो।” ");
INSERT INTO thr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","फिर बौ जरा अग्गु बढ़ो और हूँनै घुपटियाय कै जमीन मैं प्रार्थना करन लागो, कि हुई सकै तौ जौ दुख मेरे ऊपर से हट जाबै। ");
INSERT INTO thr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","और ऐसे कहेन लागो, “हे परमपिता तोसे तौ सबै कछु हुई सकथै, जौ कटोरा मेरे अग्गु से हटाय दे। तहुँओं जैसो मैं चाहथौं बौ नाय लेकिन जो तू चाहथै बहे होबै।” ");
INSERT INTO thr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","बौ फिर बापस आओ और उनकै सोत भै देखी। और पतरस से कही, “अरे सिमौन, तू का सोए रौ है? तेरे मैं एक घड़ी भी जगन की हिम्मत नाय है? ");
INSERT INTO thr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जगत और प्रार्थना करत रहियो ताकी तुम परिक्छा मैं ना फसौ। आत्मा तौ तैयार है, लेकिन सरीर तौ कमजोर है।” ");
INSERT INTO thr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","और दुबारा से फिर बापस गौ और बैसिये प्रार्थना करन लागो। ");
INSERT INTO thr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","फिर लौटकै देखी तौ उनकै सोत भै पाई काहैकि उनकी आँखी निंधानि भइ रहैं। तौ उनके पास कछु बोल ना बचे कि हम बाकै का जबाब देमैं। ");
INSERT INTO thr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","तौ तिसरी बार आयकै उनसे कही, “अब तुम सोत रहबौ और सैंतात रहबौ? काहैकि बौ समय आए गौ! देखौ इंसान को लौड़ा पापिन के हाथ पकड़बाओ जाथै। ");
INSERT INTO thr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","अब उठौ, नेंगौ। देखौ, मेरो पकड़ान बारो मेरे झोने आए चुको है!” ");
INSERT INTO thr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ईसु जौ कहेतै रहै कि तुरंतै यहूदा इस्करियोती जो बारह चेलन मैं से एक रहै, अपने संग मुखिया पुजारी, यहूदि नियम के सिक्छक और बड़े-बूढ़ेन के घाँईं से एक बड़ी भीड़ तलवार और लठिया लै तुरंतै आए पुगे। ");
INSERT INTO thr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","बाको पकड़वान बारो उनकै जौ चिताए दई रहै, कि मैं “जो आदमी कै चूमौं बौ बहे होगो। बाकै पकड़कै अपने संग लै जाबौ।” ");
INSERT INTO thr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","और बाके झोने आयकै बासे कहेन लागो, “गुरुजी!” और बाकै प्यार से चूमन लागो। ");
INSERT INTO thr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तौ बे ईसु कै तुरंतै धर दबोचीं। ");
INSERT INTO thr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","पर ठाड़ें मैं से एक तुरंतै अपनी तलवार निकारी और बड़ो पुजारी के सेवक के ऊपर चलाई, और बाको एक कान काट दई। ");
INSERT INTO thr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ईसु उनसे कहेन लागो, “का तुम डकैत जानकै मोकै पकड़न के ताहीं तलवार और लठिया लैकै निकरे हौ? ");
INSERT INTO thr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मैं तौ सब दिन मंदिर मैं तुमरे संग रहकै उपदेस देत रहौं, तौ तुम मोकै नाय पकड़े: काहैकि ऐसो जहे ताहीं भौ कि पवित्र सास्त्र की बात पूरी होबै।” ");
INSERT INTO thr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","तभईये बाके संग के सबै चेला बाकै छोड़कै भाज गै। ");
INSERT INTO thr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","तौ एक ज्वान आदमी नंगी सरीर मैं चद्दर ओढ़े ईसु पच्छू हुई लई; तौ बे आदमी बाकै पकड़न ताहीं कोसिस करीं, ");
INSERT INTO thr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","लेकिन बौ चद्दर छोड़कै, नंगोई भाज पड़ो। ");
INSERT INTO thr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","फिर बे ईसु कै बड़ो पुजारी के झोने लैकै गै, और मुखिया पुजारी, यहूदि नियम के सिक्छक और बड़े-बूढ़े बाके दरबार मैं सब जुराए गै। ");
INSERT INTO thr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस उनसे दूर-दूर और पच्छू-पच्छू बड़ो पुजारी के आँगन के भीतर तक चले गौ। और रखबरियन के संग बैठकै आगी तापन लगो। ");
INSERT INTO thr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","मुखिया पुजारी और पूरी पंचायती ईसु कै मार डारन के ताहीं बाके खिलाप गभाई ढूँड़त रहैं, लेकिन नाय मिलो। ");
INSERT INTO thr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","निरे बाके खिलाप मैं गलत गभाई देत रहैं, लेकिन उनकी गभाई एक दुसरे से मेल नाय खामैं। ");
INSERT INTO thr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तभई कुछ आदमी बाके खिलाप उठकै जौ गलत गभाई दईं। ");
INSERT INTO thr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“हम जासे जौ बात कहेत सुने हैं, ‘कि मैं अपने हाथ के बनाए भै मंदिर कै उजाड़ दुंगो और तिसरे दिन मैं दुसरो बनाए दुंगो, बौ इंसानन के हाथ को बनो भौ नाय होगो।’” ");
INSERT INTO thr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","जामैं भी उनकी गभाई एक सी नाय बैठी। ");
INSERT INTO thr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तौ बड़ो पुजारी सबन के बीच मैं ठाड़कै ईसु से पूँछी; जे सब जनी जो तेरे ऊपर दोस लगाए रै हैं “तैं उनकै कोई जबाब काहे ना देथै?” ");
INSERT INTO thr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","लेकिन बौ चुप्पा रहो, और कछु नाय जबाब दई। बड़ो पुजारी बासे फिर पूँछी, “का तू आसीसित परमेस्वर को लौड़ा मसीह है?” ");
INSERT INTO thr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ईसु कही, “मैं हौं: और तुम सबै इंसान के लौड़ा कै सर्वसक्तिमान परमेस्वर के दाँए घाँईं बैठो, और आसमान के बादरन संग आत देखैगे।” ");
INSERT INTO thr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तौ बड़ो पुजारी अपने लत्ता फाड़कै कही, “अब हमकै जाके खिलाप गभन की का जरूरत है? ");
INSERT INTO thr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुम जौ बदनामी सुने। तुम सबन की का सलाह है?” बे सब बाके खिलाप बोलीं और कहीं जौ तौ कसूरवार है और जाकै मौत की सजा मिलनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तब कोई बाके ऊपर थूकन, और कोई बाको मोहों ढोकैं और बाकै घूँसा मारैं, और बासे कहमैं, “अगर तैं भविस्यवक्ता है तौ बता, तोए कौन मारो!” और रखबरिया भी बाकै पकड़कै चाँटा मारीं। ");
INSERT INTO thr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जब पतरस दुआरे आँगन मैं रहै, तौ बड़ो पुजारी की एक सेविका हूँना आई, ");
INSERT INTO thr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","और पतरस कै आगी तापत देखकै बाके घाँईं एक टक भाँदकै देखी और बासे कहेन लागी, “तहूँ तौ बहे ईसु नासरी के संग रहै।” ");
INSERT INTO thr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","लेकिन बौ मुकर गौ, और कहेन लागो, “मैं कछु नाय जानथौं की तू कौनके बारे मैं कह रइ है।” और बाके दुआरे डेहरी मैं आत खिना की मुर्गा बास दई। ");
INSERT INTO thr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","सेविका बाकै देखकै झोने ठाड़े आदमिन से दुबारा कहेन लागी, जहो तौ उनके संग रहै। ");
INSERT INTO thr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","लेकिन पतरस फिर मुकर गौ, थोड़ी देर बाद बे जो बाके झोने ठाड़े रहैं फिर पतरस से कहेन लागे, “सच्ची तहूँ उनमैं से एक है; काहैकि तहूँ गलीली है।” ");
INSERT INTO thr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","लेकिन पतरस धिक्कारन और कसम खान लागो, “मैं बौ आदमी कै जोकी तुम बातचीत कर रै हौ, नाय जानथौं।” ");
INSERT INTO thr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तभई तुरंतै मुर्गा बास दई। तौ पतरस कै बौ बात जो ईसु बासे कही रहै समक आई, “कि मुर्गा के दुई बार बास देन से अग्गु तैं तीन बार मेरो इंकार करैगो।” और बौ जोर-जोर से रोन लगो। ");
INSERT INTO thr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","भोर होतै खिना मुखिया पुजारी, खास बड़े-बूढ़े, यहूदि नियम के सिक्छकन, और पूरी सभा आपस मैं फैसला करीं और ईसु कै बंधबाए कै पिलातुस के हात मैं सौंप दईं। ");
INSERT INTO thr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातुस बासे पूँछी, “का तू यहूदिन को राजा है?” ईसु जबाब दई, “तू खुदै बताए रौ है।” ");
INSERT INTO thr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","और मुखिया पुजारी बाके ऊपर निरी बातन को दोस लगात रहे। ");
INSERT INTO thr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुस बासे फिर पूँछी, “तू जबाब काहे ना देथै? देख जे तेरे ऊपर कित्ते बातन को दोस लगाए रै हैं।” ");
INSERT INTO thr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ईसु फिर कछु जबाब नाय दई; तौ पिलातुस कै बड़ा अचम्मो भौ। ");
INSERT INTO thr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","पिलातुस हर फसह के त्योहार मैं कोई एक कैदी कै जोकै लोग चहात रहैं, उनके ताहीं छोड़ देत रहै। ");
INSERT INTO thr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","बरअब्बा नाओं को एक आदमी बे दंगाईयन के संग कैदी रहै, जो दंगा मैं हत्या करी रहैं। ");
INSERT INTO thr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","तौ भीड़ ऊपर जाएकै बासे नहोरे करन लागी, जैसो तू हमरे ताहीं करत आओ है बैसोई कर दे। ");
INSERT INTO thr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","तौ पिलातुस उनकै जबाब दई, “का तुम जौ चाहथौ कि तुमरे ताहीं यहूदियन के राजा कै छोड़ देयौं?” ");
INSERT INTO thr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","काहैकि बौ सब जानत रहै, कि मुखिया पुजारी बाकै धोके से पकड़बाई है। ");
INSERT INTO thr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","लेकिन मुखिया पुजारी आदमिन कै भड़काईं, और जौ बोलन कै कही कि बौ बरअब्बा कै उनके ताहीं छोड़ देबै। ");
INSERT INTO thr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","जौ सुनकै पिलातुस उनसे फिर पूँछी, “तौ जोकै तुम यहूदिन को राजा कहथौ, बाको मैं का करौ?” ");
INSERT INTO thr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","बे फिर चिल्लाईं, “बाकै क्रूस मैं टँगबाए दे!” ");
INSERT INTO thr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातुस उनसे कही, “काहे? बौ का बुरो काम करी है?” लेकिन भीड़ और जोड़ से चिल्लाए उठी बाकै क्रूस मैं टाँगौ। ");
INSERT INTO thr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","पिलातुस भीड़ कै सांत करन के ताहीं बरअब्बा कै उनके ताहीं छोड़ दई, और ईसु कै कोड़ा लगबाए कै क्रूस मैं टाँगन ताहीं सौंप दई। ");
INSERT INTO thr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","सिपईय्या ईसु कै राज्यपाल के महल के भीतर के आँगन मैं लैगै, और हूँना पूरी पलटन बुलाएकै इखट्टो करीं। ");
INSERT INTO thr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","तौ बाकै बैंजनी लत्ता पहनाईं और कांटो को मुकुट बनाएकै बाके मूड़ मैं पैंधाय दईं। ");
INSERT INTO thr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","और बासे जौ कहीं “ओ यहूदियन के राजा तेरी लम्बी उमर होबै!” ");
INSERT INTO thr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","और बे बाके मूड़ मैं डंडा मारते, थूकते, और घुपटियाय कै बासे नमस्ते करतै रहे। ");
INSERT INTO thr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","जब बाको बे मजाक उड़ाए चुके, तौ बाके ऊपर से बैंजनी लत्ता उतारकै बहे के लत्ता पहनाए दईं; और फिर बाकै क्रूस मैं टँगलान ताहीं दुआरे लाए कै चल दईं। ");
INSERT INTO thr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","सिकन्दर और रूफुस को दऊवा सिमौन, जो एक कुरेनी आदमी रहै, बौ कोई गाँव से आत रहै और बौ बहे रस्ता से गुजरो; तौ बाकै आदमी जबरजत्ती पकड़ लईं ताकी बाको क्रूस उठाएकै पहुँचाए आबै। ");
INSERT INTO thr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","बे ईसु कै गुलगुता (जाको मतलब खोपड़ी की जघा) मैं लैकै आए। ");
INSERT INTO thr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","हूँना बे ईसु कै मुर्र मिली भइ दाखरस पिबामैं, लेकिन बौ नाय पी। ");
INSERT INTO thr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तौ बे बाकै क्रूस मैं चढ़ाईं, और बाके लत्ता ताहीं परची डारीं फिर आपस मैं बाँट लईं। ");
INSERT INTO thr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","सुबेरे के नौ बजे रहैं, जब बे बाकै क्रूस मैं टाँगीं। ");
INSERT INTO thr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","और बाके दोसपत्‌र मैं जौ लिखकै बाके ऊपर टाँगो गौ “यहूदियन को राजा।” ");
INSERT INTO thr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","बे बाके संग दुई चुट्टन कै क्रूस मैं टाँगीं, एक कै दहने घाँईं और दुसरो बाके बाँए घाँईं। ");
INSERT INTO thr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","जौ लेख कि “ईसु अपराधिन संग गिनों गौ” और पूरो भौ। ");
INSERT INTO thr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","रहामैं आन-जान बारे आदमी अपनो मूड़ हलाए-हलाए कै ईसु की बुराई करत भै जात रहैं, “देखौ! मंदिर कै गिरान बारो और तीन दिन मैं बनानबारो! ");
INSERT INTO thr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","क्रूस मैं से उतरकै अपने आपकै बचा!” ");
INSERT INTO thr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","बैसिये मुखिया पुजारी यहूदि नियम के सिक्छक मिलकै बाको मजाक उड़ात भौ कहमैं; “जौ औरन कै बचाई लेकिन अपने आपकै काहे ना बचाए पाई। ");
INSERT INTO thr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","अब इस्राएल को राजा मसीह क्रूस तरे उतर आबै तौ हम बाके ऊपर बिस्वास करैं।” जिनकै ईसु के संग टाँगीं रहैं, बेऊँ ईसु की बेजती करीं। ");
INSERT INTO thr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","और दुपारी मैं सबै देस मैं अंधियारो छाए गौ और तीन घंटा रहो। ");
INSERT INTO thr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","दुपारी के तीन बजे ईसु जोड़ से चिल्लाए कै कही, “इलोई, इलोई, लमा सबक्तनी?” जाको मतलब है “मेरे परमेस्वर, मेरे परमेस्वर, तू मोकै काहे छोड़ दौ?” ");
INSERT INTO thr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","जो बाके झोने ठाड़े रहैं उनमैं से जौ सुनकै कोई कहीं, “देखौ बौ एलिय्याह कै पुकार रौ है।” ");
INSERT INTO thr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","तौ उनमैं से एक दौड़कै बरछा कै सिरका के सोकता मैं डुबाई, और डंडा के सिरा मैं भाँदकै बाकै चुसाय कै बासे कहन लागो, “देखैं, एलिय्याह जाकै क्रूस से तरे उतारन आथै कि ना।” ");
INSERT INTO thr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तौ ईसु जोड़ से चिल्लाई और ज्यान त्याग दई। ");
INSERT INTO thr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","मंदिर को परदा ऊपर से तरे ले फटकै दुई टुकड़ा हुई गौ। ");
INSERT INTO thr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","हूँना बाके अग्गु ठाड़ो कप्तान ईसु कै चिल्लात और ज्यान छोड़त भै देखी, तौ बौ कही, “सच्ची मैं जौ आदमी, परमेस्वर को लौड़ा रहै।” ");
INSERT INTO thr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","बाकै तमान बईंय्यरैं दूर से देखत रहैं, बामै मरियम मगदलीनी, छोटो याकूब और योसेस की अईय्या मरियम और सलोमी रहैं। ");
INSERT INTO thr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जब बौ गलील मैं रहै तौ जे बाके पच्छू हुई लेत रहैं; और बाकी सेवा-टहल करत रहैं। औरौ निरी बईंय्यरैं रहैं; जो बाके संग यरूसलेम मैं आई रहैं। ");
INSERT INTO thr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जब संजा खिन हुई गई काहैकि जौ दिन तैयारी को रहै, जौ साबत के एक दिन के अग्गु को रहै। ");
INSERT INTO thr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतियाह को रहेन बारो यूसुफ आओ, और बौ महासभा को मानो भौ मनतरी रहै। और खुद बौ परमेस्वर के राज्य के इंतजार मैं रहै। बौ हिम्मत भाँदकै पिलातुस के झोने गौ और ईसु की लास माँगी। ");
INSERT INTO thr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातुस कै अचम्मो भौ की बौ इत्ती जल्दी मर गौ; और बौ सूबेदार कै बुलाएकै पूँछी, कि बाके मरे कित्ती देर भइ है? ");
INSERT INTO thr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","फिरौंकी बौ सूबेदार से सब खबर लैकै यूसुफ कै ईसु की लास दिबाए दई। ");
INSERT INTO thr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तौ बौ एक लीनन को चद्दर लई, और लास कै बामै लिपटाए दई, और एक कबर मैं जो चट्टान मैं खोदी गई रहै धरी, और कबर के मोहोंट मैं एक भारी पथरा ढुरकाय दईं। ");
INSERT INTO thr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मगदलीनी और योसेस की अईय्या मरियम देखत रहैं कि बाकै कहाँ धरी हैं। ");
INSERT INTO thr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जब साबत को दिन बीत गौ, तौ मरियम मगदलीनी, और याकूब की अईय्या मरियम, और सलोमी महाकनबारी चीज मोल लैकै आईं कि आयकै ईसु के सरीर मैं मलकै अभिसेक करैं। ");
INSERT INTO thr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","इतवार के दिन तड़के भोर, जब दिन निकरतै रहै, तौ बे कबर मैं आईं, ");
INSERT INTO thr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","बे आपस मैं कहेत रहैं, “हमरे ताहीं कबर के मोहोंट मैं से पथरा कौन ढुरकाबैगो?” काहैकि पथरा निरो बड़ो रहै। ");
INSERT INTO thr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","तौ हूँना पौहौंच कै देखीं कि पथरा तौ पहले सेई ढुरको भौ है! ");
INSERT INTO thr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","तौ कबर के भीतर घुसतै, बे एक ज्वान आदमी कै सेतो चोंगा पहने भै दहने घाँईं बैठो भौ देखीं, और बड़ा अचम्मो मैं पड़ गईं। ");
INSERT INTO thr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","बौ उनसे कही, “अचम्मो मत करौ, तुम ईसु नासरी कै, जो क्रूस मैं टाँगो गौ रहै, बाकै ढूँड़थौ। जिंदो हुई गौ है, हिंयाँ नाय है; जौ बहे ठिया है, जहाँ बाकै धरी रहैं। ");
INSERT INTO thr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","अब जाबौ, बाके चेलन कै और पतरस कै बताबौ कि बौ तुमसे अग्गु गलील मैं जागो। जैसो बौ तुमसे कही रहै।” ");
INSERT INTO thr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","तौ बे ईसु की कबर से निकरतै भाज लईं; बे थर-थरान लागीं, बे कोईये से कछु नाय कहीं, काहैकि बे सच मैं बड़ा डराय गईं रहैं जाके बाद बे पतरस और सब चेलन कै अपनी गभाई बताईं। ");
INSERT INTO thr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ईसु जिंदो होन के बाद इतवार बारे रोज भोर होत खिना, सबन से अग्गु मरियम मगदलीनी जोके भीतर से बौ सात प्रेत आत्मा कै निकारी रहै, बाकै दिखाई दई। ");
INSERT INTO thr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","बौ जाएकै जौ खबर ईसु के संग बारेन कै सुनाई, जो सोक मैं डूबे रोत रहैं। ");
INSERT INTO thr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","चेला जौ सुनकै कि बौ ईसु कै जिंदो देखी है, बे बाकी बात मैं बिस्वास नाय करीं। ");
INSERT INTO thr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","जाके बाद ईसु दुई जनी कै दुसरे तराहनी दिखाई दई। जब बे गाँव घाँईं जात रहैं। ");
INSERT INTO thr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","बेऊँ जौ खबर औरन कै बताईं, लेकिन उन्हऊँ को भरोसो नाय करीं। ");
INSERT INTO thr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","आखरी मैं जब बे ग्यारह चेला खानु खान बैठे रहैं। तौ ईसु उनकै दिखाई दई, उनके अविस्वास और कर्‌रे मन होन पर समझाई कि बिस्वास करौ। जो बाकै जिंदो होन के बाद देखी रहै, बे उनके ऊपर भरोसो नाय करी रहैं। ");
INSERT INTO thr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ईसु उनसे कही, “जाएकै पूरी दुनिया के आदमिन कै जौ सुसमाचार प्रचार करौ। ");
INSERT INTO thr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जो बिस्वास करैगो और बपतिस्मा लेगो बाको उद्धार होगो, लेकिन जो बिस्वास नाय करैगो बाकी बुराई करी जागी। ");
INSERT INTO thr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","बिस्वास करन बारेन मैं जौ चिन्ह होगो कि बे मेरे नाओं से प्रेत आत्मा कै निकारंगे, और नई-नई भासा बोलंगे; ");
INSERT INTO thr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","साँपन कै उठाए लेमंगे, और अगर जहरौ पी लेमैं तहुँओं कछु नुकसान नाय होगो; और बे बिमारन के ऊपर हाथ धरंगे और बे अच्छे हुई जांगे।” ");
INSERT INTO thr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","प्रभु ईसु उनसे बात करन के बाद स्वर्ग के ऊपर उठाए लौ गौ, और परमेस्वर के दहने घाँईं बैठगौ। ");
INSERT INTO thr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","चेला निकरकै सब जघा ईसु को प्रचार करीं, और प्रभु उनके संग रहकै काम करत रहो, बे चिन्ह चमत्कार के जरिया जो चेलन संग होत रहै, बचन कै मजबूत करत रहो। आमीन।");
INSERT INTO thr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","प्रिय थियुफिलुस: भौत जनी बे बातन कै जो हमरे बीच मैं बीती हैं लिखन कि पूरी कोसिस करीं हैं। ");
INSERT INTO thr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","बे लिखी हैं कि हम बे सेवकन से का कहे हैं जो परमेस्वर के चेला सुरुवात से जे चीजन कै देखीं और जौ खबर को प्रचार करीं। ");
INSERT INTO thr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","और इसलै, थियुफिलुस, काहैकि महुँ सुरु सेई जे सब मामलेन कै चौकन्नो हुईकै परखो हौं, मैं सोचो कि तेरे ताहीं एक लैनबार से खाता मैं लिखनो अच्छो होगो। ");
INSERT INTO thr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","मैं ऐसो इसलै करथौं ताकी तोकै हर बौ यकीन चीज के बारे मैं पूरी सच्चाई पता चल जाबै जो तोकै सिखाओ गौ है। ");
INSERT INTO thr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया के राजा हेरोद के समय अबिय्याह के दल मैं जकर्याह नाओं को एक पुजारी रहै, और बाकी बईय्यर हारून के बंस की रहै, जोको नाओं एलिसिबा रहै। ");
INSERT INTO thr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","और बे दोनों जनी परमेस्वर के सामने सिरफ धर्मी रहैं, और प्रभु की सबै आग्या और कानून मैं निर्दोस चलन बारे रहैं। ");
INSERT INTO thr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","उनकी कोई औलाद ना रहै, काहैकि एलिसिबा बाँझ रहै, और बे दोनों बुढ्‌ढे रहैं। ");
INSERT INTO thr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","एक दिन जकर्याह मंदिर मैं परमेस्वर के अग्गु पुजारी के रूप मैं सेवा करत रहै, रोजाना सेवा मैं अपनी बारी लेत रहै। ");
INSERT INTO thr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","पुजारी पंचायत के रीत के हिसाब से बाके नाओं से चिट्ठी निकरी, कि प्रभु के मंदिर मैं जाएकै धूप बत्ती जलाबै, ");
INSERT INTO thr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","और धूप बत्ती जलान पोती लोगन की पूरी मन्डली दुआरे प्रार्थना करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","इत्ते मैं प्रभु को एक स्वर्गदूत बेदी की धूप बत्ती के दहने घाँईं ठाड़ो भौ बाकै दिखाई दई। ");
INSERT INTO thr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","और जकर्याह देखकै डराएगौ और बाकै बड़ा डर बैठगौ। ");
INSERT INTO thr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","लेकिन स्वर्गदूत बासे कही, “हे जकर्याह, डराबै मत्ती काहैकि तेरी प्रार्थना सुन लई गई है और तेरी बईय्यर एलिसिबा से तेरे ताहीं एक लौड़ा पैदा होगो, और तू बाको नाओं यूहन्ना रखिये। ");
INSERT INTO thr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","और तोकै खुसी होगी, और भौत जनी बाके जनम लेन कि बजह से खुस होंगे! ");
INSERT INTO thr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","काहैकि बौ प्रभु के सामने महान होगो। और दाखरस और दारु कहु ना पीगो। और बौ अपने जनम से ही पवित्र आत्मा से भर जागो, ");
INSERT INTO thr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","और इस्राएल के लोगन मैं से भौतन कै उनके प्रभु परमेस्वर के घाँईं करैगो। ");
INSERT INTO thr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","बौ एलिय्याह भविस्यवक्ता की आत्मा और सामर्थ्य मैं हुईकै बाके अग्गु-अग्गु चलैगो, कि दउवन को मन बाल-बच्चन के घाँईं फेर दे; और नियम ना मानन बारेन कै धर्मी कि समझ मैं लाबै; और प्रभु के ताहीं सिरफ काबिल आदमी कै तैयार करै।” ");
INSERT INTO thr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकर्याह स्वर्गदूत से पूँछी, “जौ मैं कैसे जानौ? काहैकि मैं तौ बुढ़रा हौं; और मेरी बईंय्यरौं बुढ़िया हुई गई है।” ");
INSERT INTO thr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","स्वर्गदूत बाकै जबाब दई, “मैं जिब्राईल हौं, मैं परमेस्वर के सामने ठाड़ो रहथौ; और मैं तोसे बतकान और तोकै जौ सुसमाचार सुनान के ताहीं भेजो गौ हौं। ");
INSERT INTO thr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","और देख, जो दिन ले जे बातैं पूरी ना हुई लेमैं, बौ दिन ले तू अपनो मोहों बंद रखागो, और बोल ना पागो, इसलै कि तैं मेरी बातन कै जो अपने समय मैं पूरी होमंगी, उनके ऊपर तैं बिस्वास ना करो।” ");
INSERT INTO thr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","लोग जकर्याह कै असियात रहैं और अचम्मो मानन लागे, कि बाकै मंदिर मैं इतनी देर काहेकै लग रइ है? ");
INSERT INTO thr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जब जकर्याह दुआरे आओ, तौ बौ कछु बोल ना पाई और आखरी मैं बे जानगै, कि जकर्याह कै मंदिर मैं कछु दर्सन मिलो है; जकर्याह उनसे इसारन मैं बतान की कोसिस करत रहो, लेकिन बौ गूँगा बनो रहगौ। ");
INSERT INTO thr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जब जकर्याह को मंदिर मैं सेवा करन को पूरो समय हुई गौ, तौ बौ अपने घरै चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","थोड़ी दिनन के बाद बाकी बईय्यर एलिसिबा पेट से हुई गई; और पाँच महेना ले अपने आपकै जौ कहकै लुकाए रखाई। ");
INSERT INTO thr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","कि “इंसानन मैं मेरी बेजती दूर करन के ताहीं प्रभु जे दिनन मैं किरपा करकै मेरे ताहीं ऐसो करी है!” ");
INSERT INTO thr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","एलिसिबा के गरब के छठमें महेना मैं परमेस्वर की तरफ से जिब्राईल नाओं को स्वर्गदूत गलील के नासरत नगर मैं, ");
INSERT INTO thr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","एक कुवाँरी के झोने भेजो गौ। जोको नाओं मरियम रहै बाकी दिखनौरी यूसुफ नाओं दाऊद के बंस के एक आदमी से भइ रहै। ");
INSERT INTO thr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","और स्वर्गदूत बाके झोने आयकै कही, “तोकै सांति मिलै! प्रभु तेरे संग है और बौ तेरे ऊपर दया करी है!” ");
INSERT INTO thr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","मरियम स्वर्गदूत के संदेस से बड़ा परेसान रहै, और बौ सोचत रहै कि बाकी बातन को का मतलब है। ");
INSERT INTO thr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","स्वर्गदूत बासे कही, “हे मरियम; डराबै मति, काहैकि परमेस्वर की अनुग्रह तेरे ऊपर भइ है। ");
INSERT INTO thr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","और देख, तैं पेट से होबैगी, और एक लौड़ा कै जनम देगी, तैं बाको नाओं ईसु रखिये। ");
INSERT INTO thr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","बौ महान होगो; और परमप्रधान परमेस्वर को बालका कहो जागो। और प्रभु परमेस्वर बाके दऊवा दाऊद की सिंहासन बाकै देगो, ");
INSERT INTO thr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","और बौ याकूब के बंस मैं हमेसा राज्य करैगो; और बाको राज कहुए खतम नाय होगो!” ");
INSERT INTO thr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम स्वर्गदूत से कही, “मैं एक कुवाँरी हौं। फिर ऐसे कैसे हुई सकथै?” ");
INSERT INTO thr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्वर्गदूत बाकै जबाब दई, “पवित्र आत्मा तेरे ऊपर उतरैगी, और परमप्रधान परमेस्वर की सामर्थ्य तेरे ऊपर आबैगी; जौ बजह से पवित्र बालका कै परमेस्वर को लौड़ा कहो जागो। ");
INSERT INTO thr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अपनी हितुनिया एलिसिबा कै समक। जौ कहो जात रहै कि बाकै बालका नाय हुई सकथैं, लेकिन बौ अब छै महेना पेट से है, भलेई बौ बड़ा बुढ़िया होबै। ");
INSERT INTO thr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","काहैकि ऐसो कुछ भी ना है जो बात परमेस्वर ना कर सकथै।” ");
INSERT INTO thr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियम कही, “देख, मैं प्रभु की दासी हौं, जैसो तैं बात कहो है, बैसोई मेरे संग होबै।” फिर स्वर्गदूत बाके झोने से चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","कुछ समय बाद मरियम तैयार भइ और जल्दी से पहाड़ी देस मैं यहूदा के एक सहर मैं चली गई। ");
INSERT INTO thr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","बौ जकर्याह के घरै जाएकै एलिसिबा कै नमस्ते करी। ");
INSERT INTO thr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जब एलिसिबा मरियम को नमस्ते सुनीं, तुरंतै एलिसिबा को बालका बाके पेट मैं उछलो, और एलिसिबा पवित्र आत्मा से भर गई ");
INSERT INTO thr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","और एलिसिबा जोड़न से चिल्लाए कै कही, “तैं बईंय्यरन मैं परमधन्य है, और आसीसित है बौ बालका जोकै तैं जनम देगी! ");
INSERT INTO thr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","और जौ दया मेरे ऊपर कहाँ से भइ, कि मेरे प्रभु की अईय्या मेरे झोने मिलन कै आई? ");
INSERT INTO thr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","काहैकि जैसी मैं तेरो नमस्ते सुनों, मेरे भीतर को बालका खुसी से उछल पड़ो। ");
INSERT INTO thr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","तोकै जौ बिस्वास करन मैं कितनी खुसी है कि प्रभु को संदेस तेरे ताहीं सच होगो!” ");
INSERT INTO thr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","मरियम कही, “अपने आप मेरो मन प्रभु की स्तुति करथै; ");
INSERT INTO thr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","मेरी आत्मा मेरो उद्धार करन बारे परमेस्वर से खुस भइ है, ");
INSERT INTO thr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","काहैकि बौ अपनी दीन दासी कै याद करी है! अब से सब लोग मोकै धन्य कहमंगे, ");
INSERT INTO thr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","काहैकि परमेस्वर मेरे ताहीं महान काम करी है। बाको नाओं पवित्र है; ");
INSERT INTO thr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","और बाकी दया उनके ऊपर जो बासे डरथैं, पीढ़ी से पीढ़ी तक बनी रहथै। ");
INSERT INTO thr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","बौ अपने हातन की ताकत दिखाई और जो अपने मन मैं घमंड करथै, उनकै बिखेर दई। ");
INSERT INTO thr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","बौ सक्तिसाली सासकन कै उनके सिंहासन से नीचे उतारी, और दीन कै ऊपर उठाई। ");
INSERT INTO thr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","बौ भूंके कै अच्छी चीजन से भर दई, और सेठन कै खाली हाथ भेज दई। ");
INSERT INTO thr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","बौ हमरे बड़े-बूढ़ेन से करो भौ वादा निभाई, और बौ अपने सेवक इस्राएल के ऊपर दया और मदत करन आओ है। ");
INSERT INTO thr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","बौ अब्राहम और बाके पूरे बंस के ऊपर दया करनो हमेसा याद रखी है!” ");
INSERT INTO thr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम लमसम तीन महेना एलिसिबा के संग रहकै अपने घरै बापस चली गई। ");
INSERT INTO thr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","एलिसिबा के बालका को जनम लेन को समय आए गौ और बौ एक लौड़ा कै जनम दई। ");
INSERT INTO thr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","बाके पड़ोसी और हितुआ जौ सुनकै, कि प्रभु बाकै ऊपर बड़ा दया करी है, एलिसिबा के संग बड़ा खुस भै। ");
INSERT INTO thr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","जब बालका एक सप्ताह को रहै, तौ बे बाको खतना करन कै आए और बाको नाओं बाके दऊवा के नाओं मैं जकर्याह रखनो चहात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","लेकिन बाकी अईय्या कही, “न! बाको नाओं यूहन्ना रखो जाबै।” ");
INSERT INTO thr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","बे एलिसिबा से कहीं, “तेरे हितुअन मैं कोई को जौ नाओं ना है!” ");
INSERT INTO thr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","फिर बे बाके दऊवा घाँईं इसारा करकै पूँछीं, कि तैं लौड़ा को नाओं का रखनो चाहथै। ");
INSERT INTO thr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","जकर्याह लिखन बारी पटिया माँग कै लिख दई, “बाको नाओं यूहन्ना है,” और सब बड़ा हैरान भै! ");
INSERT INTO thr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","बहे समय जकर्याह फिर से बोलन मैं सक्छम भौ, और बौ आसीसित परमेस्वर को धन्यवाद करन लागो। ");
INSERT INTO thr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","बाके पड़ोसी सब बड़ा डराएगै; और बे सब बात की खबर यहूदिया के पूरे पहाड़ी देस मैं फैल गई। ");
INSERT INTO thr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","जो भी जाके बारे मैं सुनीं, बौ जाके बारे मैं मन मैं सोचीं और पूँछीं, “जौ बालका को का होन बारो है?” काहैकि जौ स्पस्ट रहै कि प्रभु की सक्ति बाके ऊपर रहै। ");
INSERT INTO thr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","यूहन्ना को दऊवा जकर्याह पवित्र आत्मा से भरो पड़ो रहै, और बौ परमेस्वर की भविस्यवाँड़ी सुनाई: ");
INSERT INTO thr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“आबौ हम इस्राएल के परमेस्वर प्रभु की स्तुति करैं! बौ अपने लोगन को छुटकारा और आसीस देन ताहीं आओ है, और उनकै आजाद करी है। ");
INSERT INTO thr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","बौ हमरे ताहीं एक सक्तिसाली उद्धारकर्ता, अपने सेवक दाऊद की पीढ़ी दई है। ");
INSERT INTO thr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","बौ सुरुवातै से अपने पवित्र भविस्यवक्ता के जरिये वादा करी रहै ");
INSERT INTO thr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","कि बौ हमैं हमरे बैरियन से बचागो, बे सबन की ताकत से जो हमसे बैर रखथैं उनके हात से हमरो उद्धार करी है। ");
INSERT INTO thr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","बौ कही कि बौ हमरे पुरखन के ऊपर दया करैगो और अपनी पवित्र वाचा कै याद रखैगो। ");
INSERT INTO thr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","हमरे पुरखा अब्राहम के ताहीं एक गंभीर कसम के संग ");
INSERT INTO thr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","बौ हमैं हमरे बैरियन से बचान को वादा करी और हमैं बिना कोई डर के बाकी आराधना करन की इजाजत दई, ");
INSERT INTO thr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ताकी हम जिंदगी भर बाके सामने पवित्रता और धार्मिकता से बाकी सेवा करत रहमैं। ");
INSERT INTO thr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","हे मेरे बालका, परमप्रधान परमेस्वर को भविस्यवक्ता कहो जागो। काहैकि तैं प्रभु को रहा बनान के ताहीं बाके अग्गु-अग्गु चलैगो, ");
INSERT INTO thr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","अपने लोगन कै उद्धार को ग्यान दे, कि उनके पापन कै माफ करन से बे बच जांगे। ");
INSERT INTO thr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","हमरो परमेस्वर दया और प्यार से भरो और कोमल है। बौ हमरे ऊपर उद्धार को उजितो बारो भोर निकारैगो। ");
INSERT INTO thr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","और बे सबन के ऊपर जो मौत के अंधकारमै छाया मैं रहथैं, स्वर्ग से चमकन के ताहीं, सांति के रहामैं हमरे कदम को मार्गदर्सन करै।” ");
INSERT INTO thr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","और बौ बालक यूहन्ना, बढ़त और आत्मा मैं ताकतबर होत गौ। यूहन्ना बौ दिन ले जंगल मैं रहो, जब तक कि बौ इस्राएल के आदमी के सामने सार्वजनिक रूप से सामने ना आओ। ");
INSERT INTO thr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","बौ समय कैसर सम्राट औगुस्तुस के हात पूरी जग के साम्राज्य मैं जनगड़ना पंजिका करन को आदेस दई रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","जौ पहली जनगड़ना बौ समय भइ, जब किरिनियुस सीरिया को राज्यपाल रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","और सब जनी अपनो नाओं जनगड़ना मैं लिखवान ताहीं अपने-अपने सहर कै गै। ");
INSERT INTO thr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","यूसुफ जौ बजह से कि बौ राजा दाऊद के घराने और बंस को रहै, गलील के नासरत सहर से यहूदिया मैं दाऊद के सहर बैतलहम कै गौ। ");
INSERT INTO thr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","बौ मरियम के संग जनगड़ना करवान गै, जोसे बाकी दिखनौरी भइ रहै। और बौ पेट से रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","और जब बे बैतलहम मैं रहैं, तौ मरियम के बालका को जनम लेन के पूरो समय हुई गौ। ");
INSERT INTO thr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","मरियम अपनो पहलोठो बालका कै जनम दई, और बाकै लत्ता मैं लपटे कै खुड़ली मैं लिटाए दई काहैकि उनके ताहीं सराय मैं जघा ना रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","बौ देस मैं कुछ बरदिया रहैं, जो रात मैं मैदान मैं रहकै अपने भेंड़-बकरियन के झुंड की रखबारी करत भइ खेतन मैं रात बितात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","उन्हैं परमेस्वर को एक दूत दिखाई दई, और प्रभु की महिमा को तेज उनके ऊपर चमको, बरदिया गजब डराय गै रहैं, ");
INSERT INTO thr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","पर स्वर्गदूत उनसे कहीं, “मत डराबौ! मैं हिंयाँ तुमरे ताहीं सुसमाचार लैकै आओ हौं, जोसे सब लोगन बड़ा खुसी होगी। ");
INSERT INTO thr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","आजै के दिन दाऊद के सहर मैं तुमरे ताहीं एक उद्धारकर्ता जनमो है, और बहे प्रभु मसीह है! ");
INSERT INTO thr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","और जाको तुमरे ताहीं जौ चिन्ह है, कि तुम एक बालका कै लत्ता मैं लिपटो भौ और खुड़ली मैं लेटो भौ पाबैगे।” ");
INSERT INTO thr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","अनकाचीति एक स्वर्गिय सेना स्वर्गदूत के संग दिखाई दईं, जो परमेस्वर की स्तुति गात रहैं: ");
INSERT INTO thr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“परमेस्वर की महिमा ऊँचे स्वर्ग मैं, और पृथ्वी मैं सांति बे लोगन के ताहीं है जिनसे बौ खुस है!” ");
INSERT INTO thr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जब स्वर्गदूत बरदियन के झोने से बापस स्वर्ग मैं चले गै, तौ बरदिया आपस मैं बतकाईं, “आबौ, आपन बैतलहम जाएकै जौ बात जो भईं हैं, और जोके बारे मैं प्रभु हमैं बताई है, देखथैं।” ");
INSERT INTO thr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","और बे तुरंत फुर्ती से जाएकै मरियम और यूसुफ कै पाईं, और बौ बालक कै खुड़ली मैं पड़ो भौ देखीं। ");
INSERT INTO thr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","जब बरदिया बाकै देखीं, तौ बे उन्हैं बात बताईं कि स्वर्गदूत बालका के बारे मैं का कहीं रहैं। ");
INSERT INTO thr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","और सब सुनन बारे, बे बातन कै जो बरदिया उनसे कहीं रहैं, अचम्मे भै। ");
INSERT INTO thr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","मरियम जे सब बात कै याद करी और उनके बारे मैं से मन सोची। ");
INSERT INTO thr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","जो कुछ बे सुनीं और देखी रहैं, बौ सबके बजह से बरदिया परमेस्वर के बड़ाँईं को गाना गात भै लौट गै; जौ बैसोई भौ जैसो स्वर्गदूत उन्हैं बताईं रहैं। ");
INSERT INTO thr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","एक सप्ताह बाद, जब बालका को खतना करन को समय आओ, तौ बाको नाओं ईसु रखो गौ, जो स्वर्गदूत बाके कोक मैं आन से पहले बाकै दई रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","जब मूसा की नियम के हिसाब से मरियम के सुद्ध होन को समय आए गौ, तौ यूसुफ और मरियम बौ बालका कै प्रभु के सामने यरूसलेम मैं लैगै, ");
INSERT INTO thr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","जैसो कि प्रभु के नियम मैं लिखो है: “हर एक पहलोठो पुरुस प्रभु के ताहीं पवित्र सौंपो जाए।” ");
INSERT INTO thr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","बे प्रभु की नियम के हिसाब से एक जोड़ी कछुआ या कबूतर के दुई बच्चन की बलि चढ़ान गै। ");
INSERT INTO thr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","बौ समय यरूसलेम मैं सिमौन नाओं को सिरफ एक धर्मी आदमी रहै, सिमौन एक अच्छो और साहसी भक्त रहै और इस्राएल कि सांति के ताहीं असियात रहै, और पवित्र आत्मा बाके संग रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","पवित्र आत्मा के जरिये सिमौन कै भरोसो दौ गौ रहै कि जबले तैं प्रभु मसीह कै देख ना लेगो, तौले तैं ना मरैगो। ");
INSERT INTO thr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","पवित्र आत्मा के सिखाने मैं, सिमौन मंदिर मैं आओ; जब अईय्या-दऊवा बालका ईसु कै मंदिर मैं लाईं, कि ईसु के ताहीं नियम के हिसाब से करैं, ");
INSERT INTO thr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","सिमौन बालका कै गोदी मैं लई और परमेस्वर को धन्यवाद करकै आसीस दई: ");
INSERT INTO thr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“अब, हे प्रभु, तैं अपनी बात के जरिया अपनो वादा पूरो करो है, और तैं अपने सेवक कै सांति से बिदा कर दे; ");
INSERT INTO thr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","काहैकि मेरी आँखी तेरे उद्धार कै देख लईं हैं, ");
INSERT INTO thr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जोकै तैं सब लोग के सामने तैयार करो है: ");
INSERT INTO thr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","गैर यहूदि के ऊपर अपनी इच्छा दिखान के ताहीं एक जोती और तेरे खुद के लोगन ताहीं इस्राएल की महिमा होबै।” ");
INSERT INTO thr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","सिमौन बाके बारे मैं जो कछु कही बासे बालका के अईय्या और दऊवा अचम्मे रहगै। ");
INSERT INTO thr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","फिर सिमौन उनकै आसीस और आर्सिवाद दई और मरियम, ईसु की अईय्या से कही, “जौ बालका कै परमेस्वर इस्राएल मैं भौत लोगन को गिरन और जी उठन के ताहीं चुनी है। बौ परमेस्वर की तरफ से एक चिन्ह होगो, जोके खिलाप भौत जनी बोलंगे ");
INSERT INTO thr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","और इसलै उनकी लुकी भइ सोच सामने आमंगी। और दुख, एक धारदार तलवार के हानी तेरो अपनो मन अपने आप तोड़ डारैगो।” ");
INSERT INTO thr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","असेर के गोत्र मैं से हन्ना नाओं कि फनूएल की लौड़िया एक भविस्यवक्ता रहै: बौ बड़ा बूढ़ी रहै, और बिहा होन के बाद अपने लोगा के संग सात साल जिंदगी बिता पाई रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","हन्ना चौरासी साल की हुई चुकी रहै: बौ मंदिर कहु नाय छोड़त रहै; दिन-रात बौ परमेस्वर की आराधना करत रहै, बर्त रखत रहै और प्रार्थना करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","हन्ना बहे समय हुँआँ आयकै परमेस्वर को धन्यवाद देन लागी, और बे सबन से, जो यरूसलेम के छुटकारा ताहीं असियात रहैं, बौ बालका ईसु के बारे मैं उनसे बतकान लागी। ");
INSERT INTO thr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","और जब यूसुफ और मरियम प्रभु के नियम के हिसाब से सब निपटाए चुके तौ बे गलील मैं नासरत सहर अपने घरै बापस चले गै। ");
INSERT INTO thr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","बालका बड़ो होत गौ, और मजबूत हुई गौ; बौ ग्यान से भरो रहै, और बाके ऊपर परमेस्वर को अनुग्रह रहै। ");
INSERT INTO thr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","हर साल ईसु के अईय्या-दऊवा फसह को त्योहार के ताहीं यरूसलेम कै जाए करत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जब ईसु बारह साल को रहै, तौ बे हमेसा की तरह त्योहार मैं यरूसलेम कै गै। ");
INSERT INTO thr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","जब त्योहार खतम हुई गौ, तौ बे घरै बापस लौट गै, लेकिन बालक ईसु यरूसलेम मैं रहगौ। बाके अईय्या-दऊवा कै जौ पता नाय रहै; ");
INSERT INTO thr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","बे सोचीं कि बौ भीड़ के संग है, इसलै बे पूरे दिन सफर करीं और फिर अपने हितुअन और अपने पहचान बारेन के बीच बाकै ढूँड़न लगे। ");
INSERT INTO thr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ईसु जब उनकै नाय मिलो, तौ बे बाकै ढूँड़त-ढूँड़त बापस यरूसलेम कै चले गै। ");
INSERT INTO thr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","और तीन दिन के बाद बे ईसु कै मंदिर मैं यहूदि सिक्छकन के संग बैठो, उनकी बातन कै सुनत और सवाल पूँछत भइ पाईं। ");
INSERT INTO thr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","और जो बाकै सुनत रहैं, बे बाके बुद्धिमान जबाब से बड़ा हैरान हुई जात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","जब बाके अईय्या-दऊवा अपने बालका कै देखीं तौ बे हैरान ही गै, और ईसु की अईय्या बासे कही, “बेटा, तैं हमरे संग ऐसो काहे करो? तेरो दऊवा और मैं तोकै ढूँड़न की कोसिस मैं गजब परेसान भै।” ");
INSERT INTO thr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ईसु जबाब दई, “तुम मोकै काहेकै ढूँड़ रै हौ? का ना जानत रहौ, कि मोकै अपने दऊवा के घरै होनो जरूरी है?” ");
INSERT INTO thr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","लेकिन उन्हैं बाकी बात समझ मैं ना आई। ");
INSERT INTO thr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","इसलै ईसु उनके संग बापस नासरत मैं चले गौ, जहाँ बौ उनकी बात माने करतो। और उनके वस मैं रहो; बाकी अईय्या जे सब बातन कै अपने मन मैं संजोए कै धरे रखाई। ");
INSERT INTO thr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ईसु सरीर और बुद्धि दोनों मैं खूब बढ़त गौ, परमेस्वर और लोगन के अनुग्रह मैं बढ़तो चलो गौ। ");
INSERT INTO thr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","जौ सम्राट तिबिरियुस के सासन को पन्द्रमों साल रहै; पुन्तियुस पिलातुस यहूदिया को राज्यपाल रहै, हेरोद अंतिपास गलील देस को सासक रहै, और बाको भईय्या फिलिप्पुस इतूरैया और तरखोनीतिस के इलाका को सासक रहै; लिसानियास अबिलेने इलाका को सासक रहै, ");
INSERT INTO thr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","और हन्ना और कैफा बड़ो पुजारी रहै, बौ समय परमेस्वर को बचन जकर्याह को लौड़ा यूहन्ना के झोने पुगो जो रेगिस्तान मैं रहत रहै। ");
INSERT INTO thr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","जौ बजह से यूहन्ना यरदन नदिया के आस-पास पूरे इलाका मैं गौ, प्रचार करी, “अपने पापन से मन फिराबौ और बपतिस्मा लेबौ, और परमेस्वर तुमरे पापन कै माफ कर देगो।” ");
INSERT INTO thr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जैसो कि यसायाह भविस्यवक्ता कि किताब मैं लिखो गौ है: “कोई रेगिस्तान मैं पुकार रौ है: कि प्रभु के ताहीं रहा सूदी करौ; सफर के लै प्रभु के ताहीं एक सीधी रहा बनाबौ! ");
INSERT INTO thr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","हर एक घाट कै भर दई जागी, हर पहाड़ी और पहाड़ कै नीचो कर दौ जागो; और जो टेहड़ी रहा है बाकै सीधी करो जानो चाहिए, और ऊबड़-खाबड़ रहा मुलायम बनैगो। ");
INSERT INTO thr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","पूरी इंसान की जाति परमेस्वर के उद्धार कै देखैगी!” ");
INSERT INTO thr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","बड़ी भीड़ यूहन्ना से बपतिस्मा लेन के ताहीं निकरकै आत रहै, उनसे यूहन्ना कहत रहै, “साँप के बालकौ, तुमकै कौन चिताओ, कि आनबारे गुस्सा से भाजौ? ");
INSERT INTO thr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","बे कामन कै करौ जिनसे पता चलै कि तुम अपने पापन से मन फिराए लै हौ। और आपस मैं जौ ना कहियो कि अब्राहम तुमरो पुरखा है। मैं तुमसे कहथौं कि परमेस्वर जे चट्टानन कै लैकै अब्राहम को बंसज बनाए सकथै! ");
INSERT INTO thr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","और अब कुल्हाड़ी पेंड़ कै जड़ से काटन के ताहीं तैयार है; अच्छो फल ना देनबारे हर पेंड़ कै काटकै आगी मैं डार दौ जागो।” ");
INSERT INTO thr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","और लोग बासे पूँछीं, “तौ हम का करैं?” ");
INSERT INTO thr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","यूहन्ना जबाब दई, “जोके पास दुई कुरता होमैं, बौ बाकै एक कुरता देबै जोके पास ना है, और जोके पास खानु है बहो बाँटनों चाहिए।” ");
INSERT INTO thr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","और कुछ लगान लेन बारे भी बपतिस्मा लेन आए, और बे यूहन्ना से कहीं, “गुरु, हम का करैं?” ");
INSERT INTO thr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","यूहन्ना उनसे कही, “जित्तो तुमरे ताहीं तैं करो गौ है, बासे जद्धे मत लियो।” ");
INSERT INTO thr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","और कुछ सिपईय्या यूहन्ना से पूँछीं, “हमैं का करनो चाहिए?” यूहन्ना उनसे कही, “कोई के ताकत दिखाए कै बासे पैसा मत लियो या फिर कोई के ऊपर झूठो इल्जाम मत लगइयो, अपनी तनखा से सन्तुस्ट रहबौ।” ");
INSERT INTO thr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","लोगन की उमीद बढ़न लगी और बे अचम्मे और मन मैं सोचन लगे कि कहीं सायद यूहन्ना मसीह तौ ना है। ");
INSERT INTO thr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","फिर यूहन्ना बे सबन के जबाब मैं कही, “मैं तौ तुमकै पानी से बपतिस्मा देथौं, लेकिन बौ आनबारो है, जो मोसे ताकतबर है; मैं तौ जहो काबिल ना हौं, कि बाके जूतन की तनी खोल सकौं, बौ तुमकै पवित्र आत्मा और आगी से बपतिस्मा देगो। ");
INSERT INTO thr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","बाके पास अपनो खुद को सूपो है, और बौ अपनो खेत खलियान कै अच्छे से साफ करैगो; और गेंहूँ कै अपने खाते मैं इखट्टो करैगो, लेकिन गेंहूँ छान कै बौ भूसा कै अलग करकै आगी मैं जलागो जो कहु बुझत ना है।” ");
INSERT INTO thr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","यूहन्ना भौत सी सिक्छा दै दैकै लोगन कै सुसमाचार सुनात भइ मन फिरान के ताहीं नहोरे करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","लेकिन यूहन्ना गवर्नर हेरोद कै फटकार लगाई, काहैकि हेरोद अपने भईय्या फिलिप्पुस की बईय्यर हेरोदियास से बिहा करी रहै, और भी भौत से बुरे काम करी रहै। ");
INSERT INTO thr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","तौ हेरोद यूहन्ना कै कैदखाना मैं डारकै औरौ बड़ो काम करी। ");
INSERT INTO thr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","सब जनी के बपतिस्मा लेन के बाद, ईसु भी बपतिस्मा लई। जब बौ प्रार्थना करत रहै, तौ स्वर्ग खुल गौ, ");
INSERT INTO thr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","और पवित्र आत्मा सारीरिक रूप मैं कबूतर के हानी ईसु के ऊपर उतरो, और स्वर्ग से जौ आकासवाड़ी भइ, “तैं मेरो प्रिय लौड़ा है, मैं तोसे खुस हौं।” ");
INSERT INTO thr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","जब ईसु अपनो काम सुरु करी तौ बौ लमसम तीस साल को रहै और जैसी लोग समझत रहैं कि बौ यूसुफ को लौड़ा रहै; जो कि यूसुफ एली को लौड़ा रहै, ");
INSERT INTO thr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","और एली मत्तान को, और मत्तान लेवी को, और लेवी मलाकी को, और मलाकी यन्नाई को, और बौ यूसुफ को, ");
INSERT INTO thr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","और यूसुफ मत्तित्याह को, और बौ आमोस को, और बौ नहूम को, और नहूम असल्याह को, और असल्याह नोगह को, ");
INSERT INTO thr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","और नोगह मात को, और मात मत्तित्याह को, और बौ सिमी को, और बौ योसेख को, और योसेख योदाह को, ");
INSERT INTO thr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","और योदाह यूहन्ना को, और यूहन्ना रेसा को, और रेसा जरूब्बाबेल को, जरूब्बाबेल सालतियेल को, और सालतियेल नेरी को, ");
INSERT INTO thr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","और नेरी मलकी को, और मलकी अद्दी को, और अद्दी कोसाम को, और कोसाम इलमोदाम को, और इलमोदाम एर को, ");
INSERT INTO thr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","और एर जोस्वा को, जोस्वा एलीएजेर को, और एलीएजेर योरीम को, और योरीम मत्तात को, और मत्तात लेवी को, ");
INSERT INTO thr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","और लेवी सिमौन को, और सिमौन यहूदा को, और यहूदा यूसुफ को, और यूसुफ योनान को, और योनान एलयाकीम को, ");
INSERT INTO thr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","और एलयाकीम मलेआह को, और मलेआह मिन्नाह को, और मिन्नाह मत्तता को, और मत्तता नातान को, और नातान दाऊद को, ");
INSERT INTO thr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","और दाऊद यिसै को, और यिसै ओबेद को, और ओबेद बोअज को, और बोअज सलमोन को, और सलमोन नहसोन को, ");
INSERT INTO thr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","और नहसोन अम्मीनादाब को, और अम्मीनादाब आदमिन को, आदमिन अरनी को, और अरनी हेस्रोन को, और हेस्रोन पेरेस को, और पेरेस यहूदा को, ");
INSERT INTO thr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","और यहूदा याकूब को, और याकूब इसहाक को, और इसहाक अब्राहम को, और अब्राहम तेरह को, और तेरह नाहोर को, ");
INSERT INTO thr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","और नाहोर सरूग को, और सरूग रऊ को, और रऊ पेलेग को, और पेलेग एबिर को, और एबिर सिलह को, ");
INSERT INTO thr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","और सिलह केनान को, और केनान अरफक्छद को, और अरफक्छद सेम को, और सेम नूह को, और नूह लेमेक को, ");
INSERT INTO thr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","और लेमेक मथूसिलह को, और मथूसिलह हनोक को, और हनोक यिरिद को, और यिरिद महललेल को, महललेल केनान को, ");
INSERT INTO thr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","और केनान एनोस को, और एनोस सेत को, और सेत आदम को, और आदम परमेस्वर को लौड़ा रहै। ");
INSERT INTO thr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ईसु पवित्र आत्मा से भरो भौ, यरदन नदिया से लौटो; और आत्मा कि अगुवाई मैं रेगिस्तान मैं फिरत रहो, ");
INSERT INTO thr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","और चालीस दिन ले सैतान ईसु की परिक्छा लेत रहो। ");
INSERT INTO thr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","सैतान ईसु से कही, “अगर तैं परमेस्वर को लौड़ा है, तौ जौ पथरा से कह, कि रोटी बन जा।” ");
INSERT INTO thr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ईसु जबाब दई, “सास्त्र मैं लिखो है, ‘इंसान खाली रोटी से जिंदो ना रह सकथै।’” ");
INSERT INTO thr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","तौ सैतान ईसु कै उठाएकै लैगौ और ईसु कै दुनिया भर के राज्य दिखाई। ");
INSERT INTO thr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","और सैतान ईसु से कही, “मैं जौ सब अधिकार और जौ सब धन-दौलत और महिमा तोकै दुंगो,” काहैकि “जौ सब मोकै सौंप दौ गौ है, और जोकै चाहथौं, बाकै दै सकथौं। ");
INSERT INTO thr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","अगर तैं मेरी आराधना करैगो, तौ जौ सब तेरो होगो।” ");
INSERT INTO thr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ईसु जबाब दई, “सास्त्र कहथै, ‘कि तू प्रभु अपने परमेस्वर की आराधना कर और सिरफ बहे की सेवा कर!’” ");
INSERT INTO thr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","तौ सैतान ईसु कै यरूसलेम मैं लैगौ और ईसु कै मंदिर के सबसे ऊँची जघा मैं ठड़बाए दई, और ईसु से कही, “अगर तैं परमेस्वर को लौड़ा है, तौ अपने आपकै हिंयाँ से तरे फेंक दे। ");
INSERT INTO thr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","काहैकि सास्त्र मैं लिखो है, ‘कि परमेस्वर अपने दूतन कै आग्या देगो, कि बे तेरी रक्छा करैं।’ ");
INSERT INTO thr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","और जहो कहो गौ है, ‘बे तोकै हातो-हाथ उठाए लेंगे ताकी तेरे पाँव मैं पथरन से चोट ना लगै।’” ");
INSERT INTO thr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ईसु सैतान कै जबाब दई, “सास्त्र जहो कहथै, ‘प्रभु अपने परमेस्वर कै परिक्छा मैं मत डारियो।’” ");
INSERT INTO thr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जब सैतान सब परिक्छा लै चुको, तौ थोड़ी समय ताहीं ईसु झोने से चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","फिर ईसु गलील मैं लौटियाओ, और पवित्र आत्मा की सामर्थ्य बाके संग रहै, ईसु के बारे मैं खबर पूरे आस-पास के इलाका मैं फैल गई। ");
INSERT INTO thr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ईसु सभाघरन मैं पढ़ाई और सब ईसु की बड़ाँईं करे करते। ");
INSERT INTO thr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","फिर ईसु नासरत मैं आओ; जहाँ बाको पालन-पोसँड़ भौ रहै, और हमेसा की तरह साबत के दिन सभाघर मैं गौ। ईसु सास्त्र पढ़न के ताहीं ठाड़गौ ");
INSERT INTO thr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","और यसायाह भविस्यवक्ता की किताब बाकै दई गई, और ईसु चिट्ठी खोलकै, बौ जघा निकारी जहाँ जौ लिखो रहै, ");
INSERT INTO thr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभु की आत्मा मेरे मैं है, काहैकि बौ कंगालन कै सुसमाचार सुनान के ताहीं मेरो अभिसेक करी है। और मोकै जौ ताहीं भेजी है, कि मैं बंधुवन कै छुटकारा को प्रचार और अंधरन कै उजीते, और दुखियारेन कै आजाद करौं, ");
INSERT INTO thr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","और खबर को प्रचार फैलाय दियौ कि बौ समय आयगौ है जब प्रभु अपने लोगन कै बचागो।” ");
INSERT INTO thr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","फिर ईसु किताब कै बन्द करकै बापस सेवक कै दै दई, और बैठगौ। और सभाघर मैं सब जनी की नजर ईसु के ऊपर टिकी रहैं, ");
INSERT INTO thr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","फिर ईसु उनसे कही, “पवित्र सास्त्र को जौ लिखो भौ तुमरे सामने आज सच हुई गौ है, जैसो कि तुमरे सामने पढ़ो जाएरौ है।” ");
INSERT INTO thr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","और बे सब ईसु कै सराहीं, और जो अनुग्रह की बात ईसु के मोहों से निकरत रहैं, उनसे बे अचम्मे भै; और कहेन लागे, “का जौ यूसुफ को लौड़ा ना है?” ");
INSERT INTO thr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ईसु उनसे कही, “तुम मेरे ऊपर जौ कहानी जरूर कहबैगे, ‘कि बैध, अपने आपकै अच्छो कर!’ जो कुछ तुम सुने हौ कि जो कफरनहूम मैं भौ रहै, बाकै तुम मोकै हिंयाँ अपने देस मैं भी करन ताहीं कहगे।” ");
INSERT INTO thr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ईसु कही, मैं तुमसे सच्ची कहथौं, “कोई भविस्यवक्ता कै अपने देस मैं मान-सम्मान नाय मिलथै। ");
INSERT INTO thr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","मेरी बात सुनों: जौ सच है कि एलिय्याह के समय मैं जब साढ़े तीन साल ले आसमान से मेंहें ना बरसो और पूरे देस मैं भैंकर आकाल पड़ो रहै, तौ इस्राएल मैं भौत एक बिधवा रहैं। ");
INSERT INTO thr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पर एलिय्याह कै उनमैं से कोई के झोने नाय भेजो गौ, खाली सैदा के जारफत मैं एक बिधवा कै छोड़कै। ");
INSERT INTO thr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","और एलीसा भविस्यवक्ता के समय इस्राएल मैं भौत से कोहढ़ी रहैं, पर सीरिया वासी नामान कै छोड़कै उनमैं से कोई सुद्ध ना करो गौ रहै।” ");
INSERT INTO thr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","सभाघर के आदमी जौ सुनकै, सब बड़ा गुस्सा मैं आयगै। ");
INSERT INTO thr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","और बे उठकै ईसु कै सहर से बाहर निकारीं, और बौ पहाड़ी की चुटिया मैं लैगै, जोमैं उनको सहर बसो रहै, बे ईसु कै नीचे चट्टान मैं फेंकन ताहीं लैगै रहैं, ");
INSERT INTO thr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पर बौ भीड़ के बीच से निकरकै अपने रहा चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","फिर ईसु गलील के एक कफरनहूम सहर मैं गौ, और बौ लोगन कै साबत के रोज यहूदियन के सभाघर मैं उपदेस दई। ");
INSERT INTO thr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","बे ईसु के उपदेस से अचम्मे भै, काहैकि ईसु बचन कै सबके अधिकार से बात करी रहै। ");
INSERT INTO thr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","सभाघर मैं एक आदमी रहै, जोके अंदर एक असुद्ध प्रेत आत्मा घुसी रहै; बौ बड़ा जोड़ से चिल्लाई, ");
INSERT INTO thr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“आँह! हमकै तोसे का काम, नासरत के ईसु? का तैं हमैं नास करन कै आओ है? मोकै पता है कि तैं कौन है: तैं परमेस्वर को पवित्र दूत है!” ");
INSERT INTO thr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ईसु भूत कै आग्या दई, “चुप रहा और आदमी के भीतर से बाहर निकर जा!” प्रेत आत्मा आदमी कै उनके सामने नीचे फेंक दई और बिना कोई नुकसान करे बाके अंदर से निकर गौ। ");
INSERT INTO thr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","जौ सब देखकै सब जनी अचम्मे भै, और बे आपस मैं एक-दुसरेन से कहेन लागे, “जे कैसे सब्द हैं? अधिकार और सामर्थ्य के संग जौ आदमी प्रेत आत्मा कै हुकम देथै, और बे बाहर निकर जाथैं!” ");
INSERT INTO thr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","और ईसु के बारे मैं सब गाँव मैं खबर फैल गई। ");
INSERT INTO thr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ईसु सभाघर छोड़कै सिमौन के घरै चले गौ। सिमौन की सास तेज बुखार से बिमार रहै, और बे ईसु से बाके बारे मैं पूँछीं। ");
INSERT INTO thr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ईसु बाकी सास झोने ठाड़कै बुखार कै बाकै छोड़न को आग्या दई और बुखार बाके अंदर से उतर गौ, और बौ एकै बार मैं उठ गई और उनकी सेवा करन लग्गई। ");
INSERT INTO thr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","दिन मुदन के बाद, जो-जोके हिंयाँ लोग भौत तरहन की बिमारी से बिमार रहैं, बे सब उनकै ईसु के झोने लै आईं, और ईसु एक-एक के ऊपर हाथ रखकै उनकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","और प्रेत आत्मा चिल्लाए-चिल्लाए कै कहेन डटे पड़े, “तैं परमेस्वर को लौड़ा है,” भौतन मैं से प्रेत आत्मा निकर गई, और ईसु उनकै आग्या देतो और उनकै बोलन तक ना देत रहै, काहैकि भूत जानत रहैं, कि जौ मसीह है। ");
INSERT INTO thr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","जब दिन भौ तौ ईसु निकरकै एक एकांत जघा मैं गौ, लोग ईसु कै ढूँड़न लग्गै, और जब ईसु कै ढूँड़ डारीं, तौ बे ईसु कै रोकन लग्गै, कि तैं हमरे झोने से मत जाबै। ");
INSERT INTO thr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","लेकिन ईसु उनसे कही, “मोकै दुसरे सहरन मैं भी परमेस्वर के राज्य को सुसमाचार प्रचार करनो जरूरी है, काहैकि परमेस्वर मोकै जहे ताहीं भेजी है।” ");
INSERT INTO thr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","और बौ पूरे गलील देस मैं यहूदिया के सभाघरन मैं प्रचार करी। ");
INSERT INTO thr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","एक दिन ईसु गन्नेसरत की झील के किनारे ठाड़ो रहै, और लोग परमेस्वर को बचन सुनन के ताहीं ईसु के ऊपर भीड़ गिरी जात रहै, ");
INSERT INTO thr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ईसु झील के किनारे दुई नईंयाँ लगी भइ देखी, बे नईंयाँ मैं से उतरकै मछरिया जार धोत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","बे नईंयाँ मैं से एक के ऊपर चढ़कै, जो सिमौन की रहै, ईसु बासे डींड़े से थोड़ी भीतर कै धक्का देन ताहीं पूँछी, फिर ईसु नईंयाँ मैं बैठकै भीड़ कै उपदेस दई। ");
INSERT INTO thr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","जब ईसु बोलनो बंद करी, तौ बौ सिमौन से कही, “नईंयाँ गहरे मैं लै चल, और तैं और तेरे संग के मच्छी मारन ताहीं अपने जार डारौ।” ");
INSERT INTO thr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","सिमौन ईसु कै जबाब दई, “गुरुजी, हम पूरी रात मेहनत करे और कछु ना पकड़पाए; लेकिन तैं ऐसो कहरौ है, तौ मैं जार कै डारंगो।” ");
INSERT INTO thr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जब बे जार डारीं, तौ इतनी मच्छी आए गईं कि जार फटन लग्गौ। ");
INSERT INTO thr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","इसलै बे अपने सहभागी के जो दुसरी नईंयाँ मैं रहैं, उनकै इसारा करीं, कि आयकै हमरी मदत करौ: और बे आयकै दोनों नईंयाँ कै मच्छी से इत्तो भर दईं कि नईंयाँ तक डूबा-डूब करैं। ");
INSERT INTO thr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","जौ सब देखकै सिमौन पतरस ईसु के घूँटो मैं गिर गौ, और कही, “प्रभु, मेरे झोने से चले जा, मैं एक पापी आदमी हौं!” ");
INSERT INTO thr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","सिमौन और बाके संग के इतनी जाधे मच्छी पकड़कै हैरान रहैं। ");
INSERT INTO thr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","और बैसिये जब्दी को लौड़ा याकूब और यूहन्ना कै भी, जो सिमौन के सहभागी रहैं, हैरान भै फिर ईसु सिमौन से कही, “मत डराबै, अब से तैं लोगन कै परमेस्वर के झोने लागो।” ");
INSERT INTO thr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","और बे नईंयाँ कै झील के डींड़े लै आईं और सब कछु छोड़-छाड़ कै ईसु के पच्छू ही लईं। ");
INSERT INTO thr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जब ईसु एक सहर मैं रहै, तौ हुँआँ कोढ़ से भरो भौ एक आदमी आओ, और बौ ईसु कै देखकै मोहों के बल गिरो, और नहोरे करी, “प्रभु अगर तैं चाहबै तौ मोकै सुद्ध कर सकथै!” ");
INSERT INTO thr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ईसु हाथ बढ़ायकै बाकै छुइ और कही, “मैं चाहथौं, तैं कोहोढ़ से सुद्ध हुई जा।” और एक बार मैं बिमारी बौ आदमी कै छोड़ दई। ");
INSERT INTO thr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","फिर ईसु बाकै हुकम दई, “कोई कै मत बतइये, लेकिन तैं सूदे पुजारी के झोने जा और अपने-आपकै दिखा; और अपने सुद्ध होन के बारे जो कछु मूसा चढ़ावा चढ़ाई है बाकै चढ़ा कि उनके ऊपर गभाई होबै; सबन कै साबित करन के ताहीं कि तैं ठीक हुई गौ है, तौ जैसो मूसा हुकम दई है” बैसिये भेंट चढ़ा। ");
INSERT INTO thr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","लेकिन ईसु के बारे मैं खबर और जोर-सोर से फैल गई, और लोगन की भीड़ बाकै सुनन ताहीं और अपनी बिमारिन से अच्छो होन के ताहीं जुरानी। ");
INSERT INTO thr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","लेकिन ईसु अकेली जघा मैं जाएकै प्रार्थना करे करतो। ");
INSERT INTO thr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","एक दिन ऐसो भौ जब ईसु उपदेस देत रहै, तौ कुछ फरीसी और नियम के सिक्छक हुँआँ बैठे रहैं, जो गलील और यहूदिया के हर एक सहर से और यरूसलेम से आए रहै; और बिमारन कै अच्छो करन की प्रभु की सामर्थ्य ईसु के पास रहै। ");
INSERT INTO thr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","कुछ आदमी एक फालिस मारे भै आदमी कै खटिया मैं लाईं, और बे ईसु के सामने घर के भीतर लै जान की बड़ा कोसिस करीं। ");
INSERT INTO thr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","जब बे भीड़ के बजह से बाकै भीतर ना ला पाईं तौ बे बाकै छप्पर मैं लै जाएकै छप्पर हटाएकै, बाकै खटिया समेत बीच मैं ईसु के सामने उतार दईं। ");
INSERT INTO thr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","जब ईसु देखी कि उनमैं कितनो बिस्वास है, तौ ईसु बौ आदमी से कही, “तेरे पाप माफ हुईगै, मेरे दोस्त।” ");
INSERT INTO thr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","फिर यहूदि नियम के सिक्छक और फरीसी अपने मैं कहेन लागे, “जौ कौन आदमी है, जो परमेस्वर की बुराई कर्‌रौ है! खाली एकै परमेस्वर है जो पापन की माफी दै सकथै!” ");
INSERT INTO thr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ईसु उनकी मन की बात जानकै, उनसे कही, “तुम ऐसी बात काहे सोच रै हौ? ");
INSERT INTO thr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","सई का है? का जौ कहनो, कि ‘तेरे पाप माफ हुईगै,’ या जौ कहनो कि ‘उठ और चल फिर?’ ");
INSERT INTO thr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","मैं तुमकै जौ साबित कर दुंगो कि आदमी के लौड़ा कै पृथ्वी मैं पाप माफ करन को भी अधिकार है।” ईसु बौ फालिस मारे भै आदमी से कही, “मैं तोसे कहथौं, उठ और अपनी खटिया उठा और घरै चले जा!” ");
INSERT INTO thr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","बौ मोहोंट से उनके सामने उठो, और जोमैं बौ लेटो रहै बाकै उठाएकै, परमेस्वर की बड़ाँईं करत भइ अपने घर कै चलो गौ। ");
INSERT INTO thr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","बे सब बड़ा चकाएगै और परमेस्वर की बड़ाँईं करन लागे, और बड़ा डराएकै कहेन लगे, “आज हम अनोखी चीज देखे हैं!” ");
INSERT INTO thr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","जाके बाद, ईसु बाहर गौ और लेवी नाओं के एक आदमी कै लगान लेन बारी चौकी मैं बैठो देखी, और बासे कही, “मेरे पच्छू आ।” ");
INSERT INTO thr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","लेवी सब कछु छोड़कै उठो, और ईसु के पच्छू हुई लई। ");
INSERT INTO thr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","और लेवी अपने घरै ईसु के ताहीं बड़ो हटकना करी; और लगान लेन बारेन कि और दुसरे लोगन कि जो ईसु के संग खानु खान बैठे रहै उनकी भीड़ रहै। ");
INSERT INTO thr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","कुछ फरीसी घाँईं यहूदि नियम के सिक्छक ईसु के चेलन से सिकायत करीं, “तुम लगान लेन बारेन और पापिन के संग काहेकै खाथौ-पीथौ?” ");
INSERT INTO thr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ईसु उनकै जबाब दई, “बैध भले अच्छेन के ताहीं नाय, लेकिन बिमारन के ताहीं जरूरी है। ");
INSERT INTO thr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","मैं धर्मी कै नाय, बल्कि पापिन को मन फिरान के ताहीं बुलान आओ हौं।” ");
INSERT INTO thr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","कुछ लोग ईसु से कहीं, “यूहन्ना के चेला तौ बार-बार बर्त रखथैं और प्रार्थना करथैं, और बैसिये फरीसियन के चेला करथै; पर तेरे चेला तौ खाथैं।” ");
INSERT INTO thr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ईसु उनसे कही, “का तुम बिहा बारे घरै बरैतियन से जबले दुल्हा उनके संग है, बर्त रखबाये सकथौ? ");
INSERT INTO thr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","लेकिन बौ दिन आगो, जब दुल्हा उनसे दूर लैजाओ जागो, और फिर बे बर्त रखंगे।” ");
INSERT INTO thr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ईसु उनकै जौ कहानी भी सुनाई, “कोई आदमी एक नया कोट या झगिया मैं पुराने लत्ता को थिगरा ना लगागो, ना तौ नया लत्ता फट जागो और बाको थिगरा पुराने कोट मैं मेल ना खागो। ");
INSERT INTO thr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","और न कोई नई दाखरस कै पुराने इस्तमाल करे भै मसकन मैं भरथै, ना तौ नई दाखरस मसकन कै फाड़कै पुही जागी, और मसक नास ही जांगे। ");
INSERT INTO thr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","जाके बदले दाखरस कै नया मसकन मैं भरनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोई आदमी पुरानी दाखरस पीकै नई दाखरस नाय मांगथै, काहैकि बौ कहथै कि पुरानिए अच्छी है।” ");
INSERT INTO thr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ईसु साबत के रोज गेंहूँ के खेतन से होत भइ जात रहै, और ईसु के चेला बाली तोड़-तोड़कै हातन से मिजलकै खात भइ जान डटे पड़े। ");
INSERT INTO thr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","कुछ फरीसी पूँछीं, “तुम ऐसो काहे कर्‌रै हौ जो हमरे नियम के हिसाब से साबत के दिन करनो सई ना है?” ");
INSERT INTO thr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ईसु उनकै जबाब दई, “का तुम नाय पढ़े हौ, कि जब दाऊद और बाके संग के लोग भूंके रहैं, तौ बौ का करी रहै? ");
INSERT INTO thr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","बौ कैसे करकै परमेस्वर के घर मैं गौ, और परमेस्वर कै दै भइ रोटी उठाएकै खाई, और अपने संग बारेन कै भी खबाई। जबकी जौ नियम के हिसाब से पुजारी कै छोड़ और कोई कै जौ खानो सई ना रहै।” ");
INSERT INTO thr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","और ईसु हल निकारकै उनसे कही, “इंसान को लौड़ा साबत के दिन को प्रभु है।” ");
INSERT INTO thr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","एकोर साबत के रोज ईसु सभाघर मैं जाएकै उपदेस दई; और हुँआँ एक आदमी रहै, जोके दहने हात मैं फालिस मार गई रहै। ");
INSERT INTO thr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","कुछ यहूदि नियम के सिक्छक और फरीसी ईसु के ऊपर गलत इल्जाम लगान के ताहीं मौका ढूँड़त रहैं, इसलै बे ईसु कै ध्यान से देखीं कि का बौ साबत के रोज अच्छो करैगो। ");
INSERT INTO thr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","लेकिन ईसु उनकी मन की बात जानत रहै; इसलै ईसु जोके हाथ मैं फालिस मारी रहै, बौ आदमी से कही, “उठ, ठाड़कै अग्गु आ।” बौ आदमी उठकै हुँआँ ठाड़गौ। ");
INSERT INTO thr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ईसु उनसे कही, “मैं तुमसे जौ पूछथौं: कि हमरे नियम के हिसाब से साबत के रोज का करनो चाहिए? भलो करन ताहीं या बुरो करन ताहीं? कोई की ज्यान बचान ताहीं या खतम करन के ताहीं?” ");
INSERT INTO thr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","और ईसु सब घाँईं बे सबन कै देखी; फिर बौ आदमी से कही जोके हात मैं फालिस मार गई रहै, “अपनो हात बड़ा।” बौ एसोई करी, और बाको हात फिर से ठीक हुई गौ। ");
INSERT INTO thr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","बे बड़ा गुस्सा मैं आए गै और आपस मैं बतकान लागे कि हम ईसु के संग का कर सकथैं। ");
INSERT INTO thr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","बौ समय ईसु प्रार्थना करन के ताहीं एक पहाड़ी मैं चढ़गौ, और पूरी रात परमेस्वर से प्रार्थना मैं बिताई। ");
INSERT INTO thr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जब दिन भौ, तौ ईसु अपने चेलन कै बुलाई और उनमैं से बारह कै चुनी, जिनकै ईसु प्रेरित को नाओं दई: ");
INSERT INTO thr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","और बे जे रहैं, सिमौन जोको नाओं बौ पतरस रखी; और बाको भईय्या अन्द्रियास, याकूब, यूहन्ना, फिलिप्पुस, और बरतुल्मै, ");
INSERT INTO thr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","और मत्ती, और थोमा, हलफई को लौड़ा याकूब, और सिमौन जो जेलोतेस कहो जात रहै, ");
INSERT INTO thr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","और याकूब को लौड़ा यहूदा, और यहूदा इस्करियोती, जो ईसु कै पकड़वान बारो बनो। ");
INSERT INTO thr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","जब ईसु प्रेरितन के संग पहाड़ी से उतरकै नीचे बराबर बारी जघा मैं आओ, हुँआँ बाके चेलन की बड़ी भीड़, और पूरे यहूदिया, और यरूसलेम, और सूर और सैदा के किनारे के लोगन की बड़ा बड़ी भीड़ जुरानी रहै; ");
INSERT INTO thr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","बे ईसु कै सुनन कै और अपनी बिमारिन से अच्छो होन के ताहीं बाके झोने आए रहैं, जो लोग प्रेत आत्मा से परेसान रहैं, बेऊँ आए और ठीक हुईगै। ");
INSERT INTO thr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सब जनी ईसु कै छूनो चाहत रहैं, काहैकि ईसु मैं से सामर्थ्य निकरकै सबकै अच्छो करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","फिर ईसु अपने चेलन के घाँईं देखी और कही, खुसनसीब हौ तुम, जो दीन हौ, काहैकि परमेस्वर को राज्य तुम्हारो है! ");
INSERT INTO thr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","खुसनसीब हौ तुम, जो हबै भूंके हौ; तुम छके जाबैगे! खुसनसीब हौ तुम, जो अभै रोय रै हौ; तुम हँसैगे! ");
INSERT INTO thr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","खुसनसीब हौ तुम, जब इंसान के लौड़ा के बजे से लोग तुमसे बैर रखंगे, और तुमकै निकार देंगे, और तुमरी बुराई करंगे, और तुमरो नाओं बुरो मानकै काट देंगे। ");
INSERT INTO thr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","जब ऐसो होबै, तौ खुस रहियो और खुसी के मारे नाचियो, काहैकि स्वर्ग मैं तुमरे ताहीं एक बड़ो इनाम रखो गौ है। उनके पुरखा भविस्यवक्ता के संग बैसोई करे करत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","कितनो भयानक है तुमरे ऊपर जो सेठ हौ, काहैकि तुम अपनी सांति पाए चुके! ");
INSERT INTO thr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“हाय तुमरे ऊपर जो अब तुम छके हौ, तुम भूंके होगे!” “तुमरे ताहीं कितनो भयानक है, जो हबै हँस रै हौ, काहैकि तुम रोबैगे!” ");
INSERT INTO thr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“जब सब जनी तुमरे बारे मैं अच्छो बोलथैं, तौ कितनो भयानक होथै; काहैकि उनके पुरखा झूठा भविस्यवक्ता के बारे मैं भौत कछु कहीं।” ");
INSERT INTO thr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“पर मैं तुम सुनन बारेन से कहथौ, कि अपने बैरी से प्यार करौ; जो तुमसे बैर करैं, उनको भलो करौ,” ");
INSERT INTO thr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जो तुमकै बद्‌दुआ देबै, तुम उनकै आसीस दियो; जो तुमरी बेजती करैं, उनके ताहीं प्रार्थना करौ। ");
INSERT INTO thr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","अगर कोई तुमकै एक गलऊवा मैं चाँटा मारै, तौ बाके घाँईं दुसरो गलऊवा रोक लियो; अगर कोई तुमरो कोट लेथै, तौ बाकै अपनो कुरता पहनन देमैं। ");
INSERT INTO thr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जो कोई तुमसे कछु मांगथै, बाकै देमैं; और जो तुमरी चीज छीन लेबै, बाकै दुबारा मत माँगियो। ");
INSERT INTO thr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","दुसरेन ताहीं बहे करैं, जैसो अपने ताहीं चाहथौ, और तुम्हऊँ उनके संग बैसोई करियो। ");
INSERT INTO thr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“अगर तुम खाली बे लोगन से प्यार करथौ, जो तुमसे प्यार-भाव रखथैं, तौ तुमकै दुआ काहे मिलनो चाहिए? काहैकि पापी अपने प्रेम-भाव रखन बारेन से प्यार करथैं।” ");
INSERT INTO thr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","अगर तुम बे लोगन को भलो करथौ, जो तुमरो भलो करथैं, तौ तुमकै दुआ काहेकै मिलनो चाहिए? काहैकि पापी ऐसोई करथैं! ");
INSERT INTO thr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","और अगर तुम खाली बे लोगन कै उधार देथौ, जिनसे तुम बापस पान की आसा करथौ, तौ तुमकै दुआ काहे मिलनो चाहिए? पापी भी पापिन कै उधार देथैं, ताकी उतनोई पैसा बापस पामैं! ");
INSERT INTO thr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","न! अपने बैरी से प्यार करौ और उनको भलो करौ; उधार और बापस लेन की कछु उमीद मत करौ, तौ तुमरे पास एक बड़ो इनाम होगो; और तुम परमप्रधान के बालका माने जागे, काहैकि बौ उनके ताहीं जो धन्यवाद नाय देथैं और बुरेन के ताहीं अच्छो है। ");
INSERT INTO thr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","दयालु बनौ जैसो तुमरो दऊवा दयालु है। ");
INSERT INTO thr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“दुसरेन को न्याय मत करौ, और परमेस्वर तुमरो न्याय ना करैगो; दुसरेन की बुराई मत करौ, और परमेस्वर तुमरी बुराई ना करैगो; दुसरेन कै माफ करौ, और परमेस्वर तुमकै माफ करैगो। ");
INSERT INTO thr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","दुसरेन कै दे करौ, और परमेस्वर तुमकै देगो; सई मैं, तुमकै एक पूरो तरीका मिलैगो, खूब एक मदत, तुमरे हाथ मैं दई जागी, जो तुम पकड़ सकथौ; दुसरेन ताहीं तुमरे जरिये इस्तमाल करो जान बारो तरीका बौ है जो परमेस्वर तुमरे ताहीं इस्तमाल करैगो।” ");
INSERT INTO thr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","फिर ईसु उनकै एक कहानी सुनाई: “एक अंधरा आदमी दूसरे आदमी कै रस्ता ना बताए सकथै; अगर बौ रस्ता बतात भइ अग्गु जागो, तौ दोनों जनी एक खाई मैं गिर जांगे।” ");
INSERT INTO thr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","कोई भी चेला अपने गुरु से बड़ो नाय होथै; सब चेला जब बे अपनी पूरी तैयारी कर लेंगे, तौ बे अपने गुरु के बराबर हुई जांगे। ");
INSERT INTO thr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“तैं अपने भईय्या की आँखी मैं को धब्बा या कूरा काहेकै देखथै, और अपनिए आँखी को लट्ठा तोकै नाय सुजाथै? ");
INSERT INTO thr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","और जब तैं अपनिए आँखी को लट्ठा नाय देखथै, तौ अपने भईय्या से कैसे कह सकथै, ‘कि भईय्या, रुक जा ला तेरी आँखी से धब्बा, कूरा साफ कर देमौं?’ तुम ढोंगी, पहले अपनी आँखी से लट्ठा निकारौ, तौ जो कूरा तेरे भईय्या की आँखी मैं है, खूब अच्छे से देखकै निकार सकथै।” ");
INSERT INTO thr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“अच्छो पेंड़ कहु खराब फल ना देथै, और एक खराब पेंड़ कहु अच्छो फल ना देथै। ");
INSERT INTO thr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","हर एक पेंड़ अपने फल से जानो जाथै: काहैकि लोग कांटे बारी झाड़ी से अंजीर नाय तोड़थैं, और ना कटबंजर बारी झाड़िन से अंगूर तोड़थैं। ");
INSERT INTO thr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","एक अच्छो आदमी अपने दिल मैं अच्छी चीज के खजाना के भंडार मैं से अच्छी बात निकारथै; और एक बुरो आदमी अपने बुरे मन के खजाना के भंडार मैं से बुरी बात निकारथै; काहैकि जो मन मैं भरो है बहे बाके मोहों मैं आथै।” ");
INSERT INTO thr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“जब तुम मेरो कहनो नाय मानथौ, तौ काहेकै मोसे ‘हे प्रभु,’ हे प्रभु कहथौ? ");
INSERT INTO thr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जो कोई मेरे झोने आथै, और मेरी बात सुनकै मानथै, मैं तुमकै बताथौं कि बौ कौनके हानी है। ");
INSERT INTO thr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","बौ आदमी बाके हानी है, जो घर बनान पोती गहरी मट्टी खोदकै चट्टान मैं बुनियाद डारी, और जब बाढ़ आई तौ धार बाके घर मैं टकरानी, लेकिन बाकै हिलाय न पाई; काहैकि बौ अच्छी तरह से पक्को बनो गौ रहै। ");
INSERT INTO thr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","लेकिन जो कोई भी मेरी बातन कै सुनकै मेरी बात नाय मानथै, बौ आदमी बाके हानी है, जो अपनो घर जमीन मैं बिन चट्टान के ऊपर बनाई; जब बाढ़ की धार बाके घर मैं टक्कर मारी तौ बौ तुरंत गिर पड़ो, और बौ गिरकै सत्यानास हुई गौ!” का अपने फल से जानो जाथै: काहैकि लोग कांटे बारी झाड़ी से अंजीर नाय तोड़थैं, और ना कटबंजर बारी झाड़िन से दाख तोड़थैं। ");
INSERT INTO thr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जब ईसु लोगन कै अपनी पूरी बात सुनाए चुको, तौ कफरनहूम मैं गौ। ");
INSERT INTO thr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","और एक रोमन अधिकारी को सेवक जो बाको बड़ा प्रिय रहै, बिमारी से मरन मैं रहै। ");
INSERT INTO thr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","जब अधिकारी ईसु के बारे मैं सुनी, तौ बौ कुछ बचे भै यहूदि बड़े-बूढ़ेन कै ईसु के झोने पनारी, कि बे जाएकै बाके सेवक कै ठीक करन के ताहीं ईसु कै आन के ताहीं पूँछै। ");
INSERT INTO thr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","बे ईसु के झोने आयकै बासे नहोरे करकै कहेन लगे, “बौ अधिकारी जौ काबिल है, कि तैं बाकी मदत करै। ");
INSERT INTO thr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","बौ हमरे देस के लोगन से प्यार करथै, और बौ खुद हमरे ताहीं एक सभाघर बनाई है।” ");
INSERT INTO thr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","इसलै ईसु उनके संग गौ, ईसु बौ घर से जाधे दूर नाय रहै, तौ अधिकारी अपने दोस्तन कै ईसु झोने जौ कहकै भेजी, “कि प्रभु तैं परेसान मत होबै, काहैकि मैं जौ काबिल ना हौं, कि तैं मेरे छत के तरे आबै, ");
INSERT INTO thr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","जहे बजे से मैं खुदकै जौ काबिल ना समझो, कि तेरे झोने आमौं, तैं खाली बस कहदे, तौ मेरो सेवक ठीक हुई जागो। ");
INSERT INTO thr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","महुँ बड़े अधिकारी के नीचे काम करथौं; और सिपईय्या मेरे अधिकार मैं काम करथैं, और जब मैं एक से कहथौं, ‘जा,’ तौ बौ जाथै, और दुसरे से कहथौं कि ‘आ,’ तौ आथै; और जब मैं अपने सेवक से कहथौं कि ‘जौ कर,’ तौ बौ करथै।” ");
INSERT INTO thr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","जौ सुनकै ईसु चौहोंक गौ, और ईसु मोहों घुमाएकै बौ भीड़ से जो बाके पच्छू आत रहै उनसे कही, “मैं तुमसे कहथौं, मोकै जाके हानी को बिस्वास कहु नाय मिलो, इस्राएल मैं भी ना पाओ!” ");
INSERT INTO thr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","और अधिकारी के भेजे भै आदमी घरै लौटकै गै, और देखीं कि सेवक अच्छो है। ");
INSERT INTO thr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","जाके तुरंत बाद ईसु अपने चेलन और एक बड़ी भीड़ के संग नाईन नाओं के सहर मैं गौ। ");
INSERT INTO thr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जैसी बौ सहर के फाटक के झोने पहुँचो, तौ देखी, कि लोग एक मुर्दा कै बाहर लै जाए रै हैं; मरो भौ आदमी अपनी अईय्या को इकलौतो लौड़ा रहै, और बौ बिधवा रहै, और सहर की एक बड़ी भीड़ बाके संग रहै। ");
INSERT INTO thr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","जब प्रभु ईसु बौ बिधवा अईय्या कै रोत भइ देखी, तौ बाको दिल दया से भरगौ, और ईसु बासे कही, “मत रोबै।” ");
INSERT INTO thr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","फिर ईसु झोने जाएकै ताबूत कै छुइ, और बाकै लै जान बारे लोग रुक गै, ईसु कही, “ज्वान आदमी! मैं तोसे कहथौं, उठ!” ");
INSERT INTO thr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","बौ मरो भौ आदमी उठकै बैठगौ, और बोलन लग्गौ, ईसु बाकै बाकी अईय्या कै बापस सौंप दई। ");
INSERT INTO thr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","जौ सब देखकै बे सब जनी बड़ा डराय गै; बे परमेस्वर की बड़ाँईं करकै कहेन लागे, “हमरे बीच मैं एक बड़ो भविस्यवक्ता दिखाई दई है!” और बे कहीं; “परमेस्वर अपने लोगन कै बचान के ताहीं आओ है!” ");
INSERT INTO thr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ईसु के बारे मैं जे सब बात पूरे यहूदिया देस और आस-पास के इलाका मैं फैल गई। ");
INSERT INTO thr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","जब यूहन्ना के चेला यूहन्ना कै जे सब बातन के बारे मैं बताईं, तौ बौ अपने चेलन मैं से दुई कै बुलाई ");
INSERT INTO thr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","और उनकै प्रभु झोने जौ पूँछन ताहीं भेजी कि, “का आनबारो तहीं है, या हमकै कोई और दुसरे से उमीद करनो चाहिए?” ");
INSERT INTO thr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","जब बे ईसु के झोने आए, तौ बे कहीं, “यूहन्ना बपतिस्मा देन बारो हमकै तेरे झोने जौ पूँछन ताहीं भेजी है, कि का आनबारो तहीं है, या हमकै कोई और से उमीद रखनो चाहिए?” ");
INSERT INTO thr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","बहे समय ईसु भौत जनी कै बिमारी और प्रेत आत्मा से बचाई; और भौत से अंधरन की आँखी अच्छी करी। ");
INSERT INTO thr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ईसु यूहन्ना के भेजे भैन कै जबाब दई, “जो कछु तुम देखे और सुने हौ, जाएकै यूहन्ना से कह दियौ; कि अंधरा देखरै हैं, लंगड़ा चल-फिर रै हैं, कोहढ़ी सुद्ध करे जाए रै हैं, बहरा सुनरै हैं, और मरे भै जी उठ रै हैं, और सुसमाचार प्रचार गरीबन कै सुनाओ जाथै। ");
INSERT INTO thr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","बे कितने खुस हैं जिनकै मेरे ऊपर सक नाय है!” ");
INSERT INTO thr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","यूहन्ना के भेजे भै लोगन के जान के बाद, ईसु यूहन्ना के बारे मैं कहनो सुरू करी: “जब तुम रेगिस्तान मैं यूहन्ना के ताहीं निकरे, तौ तुमकै का देखन की उमीद रहै? तेज ब्यार से हालत भै सरकंडा कै? ");
INSERT INTO thr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","तौ तुम का देखन गै रहो? फैंसी लत्ता पहने भै महान आदमी कै? जो लोग ऐसे लत्ता पहनथैं, और ऐसो आराम से रहथैं, बे महल मैं रहथैं। ");
INSERT INTO thr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","बताबौ, तौ फिर तुम का देखन गै रहौ? एक भविस्यवक्ता कै? हाँ सई मैं, लेकिन तुम एक भविस्यवक्ता कि तुलना मैं भौत कछु देखे। ");
INSERT INTO thr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","यूहन्ना बहे है, जोके बारे मैं सास्त्र मैं लिखो है: जो परमेस्वर कही, ‘देख, मैं अपने खबरेया कै तेरे अग्गु-अग्गु भेजथौं, जो तेरे ताहीं रहा सीधी करैगो।’” ");
INSERT INTO thr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ईसु उनसे कही, मैं तुमकै बताथौं, “यूहन्ना जिंदेन मैं से सबसे बड़ो है, बासे बड़ो कोई ना है, लेकिन जो परमेस्वर के राज्य मैं सबसे छोटो है, बौ यूहन्ना से भी बड़ो है।” ");
INSERT INTO thr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","सब जनी ईसु कै सुनीं, और लगान लेन बारे यूहन्ना से बपतिस्मा लैकै परमेस्वर कै धर्मी मान लईं। ");
INSERT INTO thr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","लेकिन फरीसियैं और नियम के सिक्छक अपने ताहीं परमेस्वर के उद्देस्य कै नाय अपनाईं और यूहन्ना से बपतिस्मा लेन से मना कर दईं। ");
INSERT INTO thr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ईसु कही, “अब मैं आज कल के लोगन की तुलना कौन से कर सकथौं? ");
INSERT INTO thr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","बे बजार मैं बैठे बालकन के हानी हैं, जो एक दुसरेन से चिल्लाए कै कहथैं, ‘कि हम तुमरे ताहीं बिहा मैं बुसली बजाओ, और तुम ना नाचे, हम रोटी के गीत गाये, लेकिन तुम ना रोए!’ ");
INSERT INTO thr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","यूहन्ना बपतिस्मा देन बारो आओ, और बौ बर्त रखी और दाखरस भी ना पिये, और तुम कहथौ, ‘बाके भीतर प्रेत आत्मा है!’ ");
INSERT INTO thr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","इंसान को लौड़ा आओ, और बौ खाई भी लई और पीयो लई, और तुम कहथौ, ‘जौ आदमी कै देखौ! पेटू और पियक्कड़ आदमी, लगान लेन बारेन को और पापिन को दोस्त।’ ");
INSERT INTO thr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","हालाकि, परमेस्वर की अकल कै सब जनी के जरिये सच्ची और सई ठहराओ जाथैं, जाकै जो अपनाथैं।” ");
INSERT INTO thr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","एक फरीसी ईसु कै अपने घरै खानु खान पूँछी; और ईसु बाके घरै गौ और खानु खान कै बैठगौ। ");
INSERT INTO thr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","बौ सहर मैं एक बईय्यर रहै जो पाप भरी जिंदगी जीत रहै, बौ सुनी कि ईसु फरीसी के घरै खानु खाए रौ है, इसलै संगमरमर की सीसी मैं भरकै इत्तर लै आई। ");
INSERT INTO thr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","और बौ ईसु पच्छू ठाड़कै, रोत भइ, ईसु के पाँव कै आँसु से भिजाये दई, और अपनी मुड़िया के बारन से पछोनन लग्गई और बाके पाँव बार-बार चूमकै उनमैं इत्तर डारकै अभिसेक करी। ");
INSERT INTO thr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","जब फरीसी जौ सब देखी, तौ बौ अपने मन मैं सोचन लगो, “अगर जौ आदमी सच्ची मैं एक भविस्यवक्ता होतो तौ जान जातो, कि जो बईय्यर जाकै छुइ रइ है, जौ कैसी है? काहैकि जौ तौ पाप भरी जिंदगी जीथै!” ");
INSERT INTO thr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ईसु बाके मन कि बात सुनकै बासे कही, “सिमौन, तोकै मोसे कछु कहने है। हाँ, गुरुजी, ईसु कही, बता मोकै।” ");
INSERT INTO thr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“दुई आदमी रहैं, दोनों को बकाया मुन्सी झोने रहै, एक जनी मुन्सी कै पाँच सौ चाँदी को सिक्का देतो, और दुसरो पचास चाँदी के सिक्का देतो। ");
INSERT INTO thr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","जबकी दोनों के पास बापस करन ताहीं कछु ना रहै, इसलै मुन्सी दोनों जनी को कर्जा माफ कर दई। अब बता कौन सो बारो बासे जाधे प्यार करैगो?” ");
INSERT INTO thr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","सिमौन जबाब दई, “मोकै लगथै,” जोको बौ जाधे कर्जा, माफ ईसु सिमौन से कही, “तैं सई न्याय करो है।” ");
INSERT INTO thr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","फिर बौ बईय्यर के घाँईं मुड़कै सिमौन से कही, “का तैं जौ बईय्यर कै देखरौ है? मैं तेरे घरै आओ, लेकिन तैं मेरे पाँव धोन के ताहीं पानी नाय दौ, पर जौ मेरे पाँव आँसु से भिजाये कै, अपने बारन से पछोनी।” ");
INSERT INTO thr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तैं मोकै ना चूमो, पर जब से मैं आओ हौं, तौ से जौ मेरे पाँव कै चूम रइ है। ");
INSERT INTO thr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तैं तौ मेरे अभिसेक के ताहीं जैतून तेल तक नाय दौ, बल्किन बौ मेरे पाँव कै इत्तर से ढोंक दई। ");
INSERT INTO thr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“मैं तोसे कहथौं; कि जाके पाप जो भौत रहैं, माफ ही गै है, काहैकि जौ भौत प्यार दिखाई है; लेकिन जिनकै माफी मिल गई है बौ थोड़ी सो प्यार दिखाथै।” ");
INSERT INTO thr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","फिर ईसु बौ बईय्यर से कही, “तेरे पाप माफ ही गै।” ");
INSERT INTO thr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","जो लोग मेज मैं बैठे रहैं, बे खुद से कहेन लगे, “जौ कौन है, जो पापन कै भी माफी देथै?” ");
INSERT INTO thr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","लेकिन ईसु बौ बईय्यर से कही, “तेरो बिस्वास तोकै बचाई है; तैं सांति से चली जा।” ");
INSERT INTO thr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","जाके बाद ईसु सहर-सहर और गाँव-गाँव परमेस्वर के राज्य को सुसमाचार प्रचार करत भइ, फिरन लगो, और बारह चेला बाके संग रहैं, ");
INSERT INTO thr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","और थोड़ी बईंय्यरैं रहैं जो प्रेत आत्मा से और बिमारिन से अच्छी भइ रहैं, और बे जे रहैं, मरियम जो मगदलीनी कही जात रहै, जोके भीतर से सात प्रेत आत्मा निकरी रहैं, ");
INSERT INTO thr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","योअन्ना, जोको आदमी खोजा हेरोद के दरबार मैं एक अधिकारी रहै; और सुसन्नाह, और भौत सी बईंय्यरैं, जो ईसु और बाके प्रेरितन कि मदत करन के ताहीं अपने खुद की सम्पत्ति से उनकी सेवा करत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","लोग एक के बाद एक सहर से ईसु के झोने आत जामैं; और जब एक बड़ी भीड़ जुराए गई, तौ ईसु जौ कहानी बताई: ");
INSERT INTO thr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“एक बार कि बात रहै, एक आदमी रहै, जो कि बौ बीज बोन के ताहीं निकरो रहै, जब बौ खेत मैं बीज बोत रहै, बामै से कुछ रहामैं गिरो, जो पाँव से कुचल गौ, और बाकै आसमान के पक्छी चुग लईं। ");
INSERT INTO thr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","बामै से कुछ चट्टान बारी जमीन मैं गिरे, और जब पौधा जमयाए, तौ बे सूख गै काहैकि मट्टी मैं नमी ना रहै। ");
INSERT INTO thr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कुछ बीज कांटे की झाड़िन के बीच मैं गिरे, और कांटे की झाड़ी पौधन के संग-संग बढ़कै उनकै दबाय दईं। ");
INSERT INTO thr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","और कुछ बीज अच्छी जमीन मैं गिरे, और जमकै सौ गुना दाने लाईं।” जौ सब कहकै ईसु जोड़न से कही, “जोके पास सुनन ताहीं कान होमैं बौ सुन लेबै!” ");
INSERT INTO thr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ईसु के चेला ईसु से पूँछीं, “जौ कहानी को मतलब का है?” ");
INSERT INTO thr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ईसु जबाब दई, “तुमकै परमेस्वर के राज्य के रहस्य की समझ दई गई है, लेकिन दुसरेन कै कहानी के जरिये सुनाओ जाथै, इसलै कि बे दिखात भौ भी ना देखैं, और सुनैं लेकिन समझ मैं ना आबै।” ");
INSERT INTO thr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“जौ कहानी को मतलब है: बीज परमेस्वर को बचन है।” ");
INSERT INTO thr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","रहा के किनारे के बे हैं, जो बचन सुनीं; फिर सैतान आयकै उनके मन मैं से बचन उठाए लै जाथै, कि कहूँ ऐसो ना होबै कि बे बिस्वास करकै बचाए जामैं। ");
INSERT INTO thr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","चट्टान मैं के बीज बे हैं, कि जब बे सुनथैं, तौ खुसी से बचन कै अपनाथैं, पर जड़ ना पकड़न से बे थोड़ी देर ले बिस्वास रखथैं, जब परिक्छा को समय आथैं, तौ बे बहक जाथैं। ");
INSERT INTO thr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जो बीज कांटे की झाड़ी मैं गिरो, जे बे हैं, जो सुनथैं, पर अग्गु चलकै चिंता और जायदाद और रोज मर्‌रा की जिंदगी के सुख-दुख मैं फस जाथैं, और उनको फल कहु नाय पकथै। ");
INSERT INTO thr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","अच्छी जमीन मैं के गिरे भै बे बीज हैं, जो कि बचन सुनकै अच्छे मन मैं समारे रखाथैं, और बे तौले बने रहथैं जबले कि बे फल ना लामैं। ");
INSERT INTO thr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“कोई भी दिया जलायकै, कटोरा तरे या खटिया के तरे नाय रखथै, जाके बदले, दिया कै डीट मैं रखथैं, ताकी लोग भीतर आन पोती उजितो पामैं।” ");
INSERT INTO thr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“जो कछु लुको भौ है, बाकै बाहर खुले मैं लाओ जागो, और जो कछु है लुको बाकै ढूँड़कै उजिते मैं लाओ जागो। ");
INSERT INTO thr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","तुम चौकन्ने रहाबौ, न तौ तुम कैसे सुनैगे; काहैकि जोके पास थोड़ी भौत है, उनकै और जाधे दौ जागो, और जोके पास नाय है, बासे बहो लै लौ जागो, जोकै बौ अपनो समझथै।” ");
INSERT INTO thr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ईसु की अईय्या और भईय्या बाके झोने आए, पर भीड़ कि बजे से बासे भेंटा ना कर पाईं। ");
INSERT INTO thr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","कोई ईसु से कही, “तेरी अईय्या और भईय्या बाहर ठाड़े हैं और तोकै देखनो चाहथैं।” ");
INSERT INTO thr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ईसु उन सबन से कही, “मेरी अईय्या और भईय्या बे हैं जो परमेस्वर को बचन सुनथैं और मानथैं।” ");
INSERT INTO thr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","एक रोज ईसु अपने चेलन संग एक नईंयाँ मैं चढ़ो, और ईसु उनसे कही, “आबौ, आपन झील के बौ पाँजर चलैं।” और बे नईंयाँ खोल दई। ");
INSERT INTO thr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","जब नईंयाँ चलत रहै, तौ ईसु सोए गौ: अनकाचीति झील मैं एक तेज आँधी चली और नईंयाँ पानी से भरन लगी, जोसे बे सब बड़ा खतरा मैं पड़ गै। ");
INSERT INTO thr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","चेला ईसु के झोने गै और बाकै जगाएकै कहीं, “गुरुजी, गुरुजी! हम मरन बारे हैं!” ईसु उठकै आँधी और पानी की लहरन कै आग्या दई; और बे सांत ही गै, और सब घाँईं एक दम सांत वातावरड़ बन गौ। ");
INSERT INTO thr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","फिर ईसु चेलन से कही, “तुमरो बिस्वास कहाँ है?” पर बे हैरान और डराने भै रहैं, और एक दुसरे से आपस मैं बतकान लगे, “जौ आदमी कौन है? बौ आँधी और पानी कै हुकम देथै, और बे बाकी मानतौ हैं!” ");
INSERT INTO thr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ईसु और बाके चेला गिरासेनियों के देस मैं पुगे, जो कि गलील झील के दुसरे पाँजर रहै। ");
INSERT INTO thr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","जब बे डींड़े मैं उतरे, तौ बौ सहर को आदमी ईसु कै मिलो, जोके अंदर प्रेत आत्मा रहैं। और बड़ा दिन से बिन कोट, लत्ता पहने रहत रहै और घरौ ना रहत रहै, बौ कबर मैं रहे करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","जब बौ ईसु कै देखी, तौ बौ जोड़न से चिल्लाई, और अपने आपकै ईसु के टाँगन मैं गिरकै जोड़न से कही, “ईसु, परमप्रधान परमेस्वर को लौड़ा! तैं मोसे का चाहथै? मैं तोसे नहोरे करथौं, मोकै सजा मत दे!” ");
INSERT INTO thr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","बौ ऐसो इसलै कहत रहै कि ईसु प्रेत आत्मा कै बाके अंदर से निकरन को आग्या देत रहै, बौ आदमी कै प्रेत आत्मा बार-बार पकड़ लेत रहै, बाके हात और टाँग साँकर से भाँद देत रहैं, तहुँओं बौ तोड़ डारत रहै, और भूत बाकै रेगिस्तान मैं भजाए करतो। ");
INSERT INTO thr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ईसु बासे पूँछी, “तेरो नाओं का है?” प्रेत आत्मा जबाब दईं, “हमरो नाओं, पलटन है,” काहैकि बाके अंदर गजब भूत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","भूत ईसु से नहोरे करीं कि, “हमैं अधोलोक मैं मत भेजै।” ");
INSERT INTO thr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","झोनेई सोरन को एक बड़ो झुंड रहै, जो एक पहाड़ी मैं चुगत रहैं, इसलै भूत ईसु से नहोरे करीं कि हमकै सोरन के भीतर जान दे, और ईसु उनकै जान दई। ");
INSERT INTO thr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","प्रेत आत्मा बौ आदमी से निकरकै सोरन के भीतर समाए गै और बौ झुंड चट्टान से झिपटकै नीचे झील मैं जाए गिरे और डूब गै। ");
INSERT INTO thr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","जो लोग सोरन की देखाभारी करन बारे रहैं, बे जौ सब देखकै कही जौ का भौ, और भाज पड़े और सहर मैं, और गाँव मैं जाएकै बाके बारे मैं खबर फैलाय दईं। ");
INSERT INTO thr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","और लोग बाकै देखन ताहीं निकरे, जो कछु भौ रहै, और जब बे ईसु के झोने आए, तौ आयकै जो आदमी के अंदर से प्रेत आत्मा निकरी रहैं, बाकै ईसु के पाँव झोने लत्ता पहने और चुप-चाप बैठो भौ देखकै, सब बड़ा डराय गै। ");
INSERT INTO thr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","और देखन बारे उनकै बताईं, कि बौ आदमी प्रेत आत्मा से सताव भौ कैसे अच्छो हुई गौ। ");
INSERT INTO thr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तौ गिरासेनियों के आस-पास के सब लोग आपस मैं एक दुसरे से पूँछीं और ईसु से दूर जान ताहीं कहीं, काहैकि बे बड़ा डराय गै रहैं। फिर ईसु नईंयाँ मैं चढ़कै चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जो आदमी के भीतर से प्रेत आत्मा निकरो रहै बौ ईसु से नहोरे करन लगो कि, “मोकै अपने संग रहन दे।” लेकिन ईसु बासे जौ कहकै बिदा करी, ");
INSERT INTO thr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“अपने घर मैं लौट जा और लोगन के बीच प्रचार, कि परमेस्वर तेरे ताहीं का करी है।” बौ आदमी सहर से छिरकै, सबन कै बताई कि ईसु बाके ताहीं का करी है। ");
INSERT INTO thr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जब ईसु झील के दूसरे घाँईं लौटो, तौ लोग बाको स्वागत करीं, काहैकि बे सब बाकै असियात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","फिर याईर नाओं को एक आदमी आओ, बौ सभाघर को अधिकारी रहै, बौ ईसु के पाँव मैं गिरकै बासे नहोरे करन लगो कि, मेरे घरै चल, ");
INSERT INTO thr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","काहैकि बाकी बारह साल की एक इकलौती लौड़िया रहै, और बौ मरन मैं रहै। ईसु बाके संग जब जात रहै, तौ लोग ईसु के ऊपर गिरे जात रहैं, इत्ती भीड़ रहै। ");
INSERT INTO thr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","बहे भीड़ मैं एक बईय्यर रहै जोकै बारह साल से खून बहन कि बिमारी रहै, पूरी जिंदगी की जमा पूँजी इलाज मैं खर्च कर चुकी रहै तहुँओं बौ अच्छी होन मैं कामयाब ना भइ। ");
INSERT INTO thr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","बौ ईसु के पच्छू से आई और बाके कोट के लत्ता के छोर के कुंछ कै छुइ लई, और तुरंत बाको खून बहनो बंद ही गौ। ");
INSERT INTO thr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ईसु पूँछी, “मोकै कौन छुओ?” सब जनी मना करीं, फिर पतरस कही, “गुरुजी, लोग सब घाँईं से चढ़े जाए रै हैं और तेरे ऊपर गिरे जाए रै हैं।” ");
INSERT INTO thr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","लेकिन ईसु कही, “कोई मोकै छुओ है, काहैकि मैं जानगौ रहौं कि मेरे मैं से सामर्थ्य निकरी है।” ");
INSERT INTO thr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","बईय्यर देखी कि ईसु कै पता चल गौ है, तौ बौ काँपत भइ आई, और ईसु के पाँव मैं गिरकै सब जनी के सामने बताई, कि मैं कौन से बजह से ईसु कै छुओ रहों, और कैसे तुरंत एकै बार मैं ठीक ही गौ। ");
INSERT INTO thr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ईसु बासे कही, “मेरी लौड़िया, तेरो बिस्वास तोकै अच्छो करी है, सांति से चली जा।” ");
INSERT INTO thr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","जब ईसु जौ कहतै रहै, कि मुखिया के घर से एक जनी आयकै कही, “तेरी लौड़िया मर गई है, अब गुरुजी कै परेसान मत करै।” ");
INSERT INTO thr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ईसु जौ सब सुनी और याईर से कही, “मत डराबै; खाली बिस्वास कर, तौ बौ अच्छी ही जागी।” ");
INSERT INTO thr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","जब बे याईर के घरै पुगे, तौ ईसु पतरस, और यूहन्ना, याकूब, और बच्ची के अईय्या-दऊवा कै छोड़कै और कोई कै अपने संग भीतर ना आन दई। ");
INSERT INTO thr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","हूँना हर कोई बालका के ताहीं रोत रहैं, ईसु उनसे कही, “मत रोबौ; बौ मरी ना है, बौ खाली सोए रइ है!” ");
INSERT INTO thr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","बे सब ईसु को मजाक बनान लग्गै, काहैकि बे जानत रहैं कि लौड़िया मर चुकी है। ");
INSERT INTO thr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","लेकिन ईसु बाको हात पकड़ी, और पुकारी, “उठ बच्ची!” ");
INSERT INTO thr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","बौ लौड़िया की आत्मा लौट आई, और बौ एकै बार कहेन मैं उठ गई, ईसु हुकम दई, कि जाकै कछु खान कै देबौ। ");
INSERT INTO thr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","बाके अईय्या-दऊवा हैरान रहैं, जौ सब देखकै, लेकिन ईसु उनकै चितौनी दई, कि बे कोई कै भी जौ ना बतामैं कि हिंयाँ का भौ रहै। ");
INSERT INTO thr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","फिर ईसु बारह चेलन कै एक संग बुलाई और उनकै सब प्रेत आत्मा कै और बिमारियन से अच्छो करन की सामर्थ्य और अधिकार दई। ");
INSERT INTO thr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","और उनकै परमेस्वर के राज्य को प्रचार करन, और बिमारन कै अच्छो करन के ताहीं भेजी, ");
INSERT INTO thr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","और ईसु उनसे कही, “रहा के ताहीं कछु मत लै जईयो: ना लठिया, ना झोला, ना रोटी, ना रुपईया और ना अगरे कुरता। ");
INSERT INTO thr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जहाँ तुमरो आदर करो जाथै, तुम बहे घर मैं रहियो, जबले तुम बौ सहर कै नाय छोड़कै जाबौ; ");
INSERT INTO thr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","जहाँ लोग तुमरो आदर नाय करथैं, बौ सहर कै छोड़ दियो और अपने पाँव के धूदर कै उनके लै चितौनी समझकै झार दियो, कि उनके ऊपर गभाई होबै।” ");
INSERT INTO thr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","और ईसु के चेला निकरकै गाँव-गाँव घूमकै हर जघा सुसमाचार सुनाईं, और लोगन कै अच्छो करीं। ");
INSERT INTO thr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","जब गलील को राजा हेरोद जौ सब सुनकै घबराएगौ, काहैकि कुछ लोग कहत रहैं कि यूहन्ना बपतिस्मा देन बारो मरे भै मैं से जी उठो है। ");
INSERT INTO thr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","और कितने ऐसे कहत रहैं, कि एलिय्याह दिखाई दई है: और कोई कहत रहैं, कि पुराने भविस्यवक्ता मैं से कोई जी उठो है। ");
INSERT INTO thr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","हेरोद कही, “मैं तौ यूहन्ना कि मूड़ कटवाए दौ रहौं; लेकिन जौ आदमी कौन है जोके बारे मैं जो बात सुनों हौं?” और बौ ईसु कै देखन कि इच्छा करी। ");
INSERT INTO thr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","फिर प्रेरितैं लौटकै जो कछु बे करी रहैं, बौ सब कछु ईसु कै बताईं, और ईसु उनके अपने संग बैतसैदा नाओं के एक सहर मैं लैकै गौ। ");
INSERT INTO thr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","जब भीड़ जाके बारे मैं सुनीं, तौ बे बाके पच्छू ही लई, और ईसु उनसे परमेस्वर के राज्य की बात करन लगो, और जिनकै चंगाई की जरूरत रहैं, उनकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जब दिन मुद चुको, तौ बारह चेला ईसु के झोने आयकै कहीं, “भीड़ कै अब भेज दे ताकी बे गाँव और बस्तियन मैं जाएकै अपने ताहीं रहन कि जघा, और खानु को जुगाड़ कर सकैं, बौ इसलै कि हम हिंयाँ सुनसान जघा मैं हैं।” ");
INSERT INTO thr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","लेकिन ईसु उनसे कही, “तुम खुद उनकै कछु खान ताहीं देबौ।” बे जबाब दईं, “हमरे पास पाँच रोटी और दुई मच्छी हैं। का तैं चाहथै कि हम जौ पूरी भीड़ के ताहीं खानु मोल लामैं?” ");
INSERT INTO thr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","हुँआँ लमसम पाँच हजार आदमी रहैं। ईसु अपने चेलन से कही, “उनकै पचास-पचास करकै समूह मैं बैठारौ।” ");
INSERT INTO thr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","चेला ऐसोई करीं, और सबन कै बैठार दईं, बाके बाद, ");
INSERT INTO thr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ईसु बे पाँच रोटी और दुई मच्छी लई, और स्वर्ग घाँईं देखकै परमेस्वर से आसीस माँग कै धन्यवाद करी, और रोटी तोड़-तोड़कै चेलन कै देत गौ ताकी बे लोगन कै बाँटें। ");
INSERT INTO thr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","और बे सब खाएकै पेट भर लईं, और चेला बची भइ बारह छपरिया उठाए लईं। ");
INSERT INTO thr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","एक दिन जब ईसु अकेले मैं प्रार्थना करत रहै, चेला बाके झोने आए। तौ ईसु उनसे पूँछी, “लोग मोसे का कहथैं?” ");
INSERT INTO thr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","बे जबाब दईं, “कुछ लोग तोसे यूहन्ना बपतिस्मा देन बारो कहथैं, और कोई-कोई एलिय्याह, और कोई जौ कहथै कि पुराने भविस्यवक्ता मैं से कोई जिंदो ही गौ है।” ");
INSERT INTO thr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ईसु उनसे पूँछी, “पर तुम मोसे का कहथौ?” पतरस जबाब दई, “तैं परमेस्वर को मसीहा है।” ");
INSERT INTO thr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","फिर ईसु उनकै सक्ति से आग्या दई कि जौ बात तुम कोई से मत कहियो। ");
INSERT INTO thr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","और ईसु जहो कही, “इंसान के लौड़ा के ताहीं जरूरी है, कि बौ गजब दुख उठाबै, और बड़े-बूढ़े और पुजारी और यहूदि नियम के सिक्छक बाकै ठुकराए कै मार डारंगे, और बौ तिसरे दिन जी उठैगो।” ");
INSERT INTO thr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","और ईसु बे सबन से कही, “अगर कोई मेरे पच्छू आनो चाहथै, तौ तुमकै अपने आपकै इंकार करियो, और रोजाना अपनो क्रूस उठईयो और मेरे पच्छू हुई लियो। ");
INSERT INTO thr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","अगर कोई अपनी ज्यान बचानो चाहगो, तौ बौ बाकै खोए देगो, पर जो कोई मेरे ताहीं अपनी जान गबागो, बहे जाकै बचाबैगो। ");
INSERT INTO thr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","अगर तुम पूरी दुनिया कै जीतथौ, और अपनी जान खोए देयौं, या बाको नुकसान उठाबै, तौ बासे का फायदा होगो! ");
INSERT INTO thr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जो कोई मोसे और मेरी बातन से सरमागो; इंसान को लौड़ा भी जब अपनी, और अपने दऊवा की, और पवित्र स्वर्गदूतन की महिमा सुंदा आगो, तौ तुमसे सरम आगी। ");
INSERT INTO thr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","मैं तुमसे सच कहथौं, कि कुछ लोग हिंयाँ पर ऐसे हैं जो तौले नाय मरंगे, जबले कि बे परमेस्वर को राज्य ना देखलेमैं।” ");
INSERT INTO thr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","इन बातन के लमसम एक सप्ताह बाद पतरस, और यूहन्ना, और याकूब कै ईसु अपने संग लैकै प्रार्थना करन के ताहीं पहाड़ी मैं चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","जब ईसु प्रार्थना करत रहै, तौ बाको चैहरा को रूप बदल गौ, और बाके लत्ता सेतो हुईकै चमकन लगे। ");
INSERT INTO thr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","अनकाचीति दुई आदमी बासे बतकात रहैं; बे मूसा और एलिय्याह रहैं, ");
INSERT INTO thr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","जे स्वर्गिय महिमा मैं दिखाई दईं और बाके मरन के बारे मैं बतकात रहैं, जो यरूसलेम मैं होन बारो रहै। ");
INSERT INTO thr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस और बाके संग के सोत रहैं, जब उनकी नींद खुल गई, तौ बाकी महिमा; और बे दोनों आदमिन कै, जो ईसु के संग ठाड़े रहैं, देखी। ");
INSERT INTO thr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","जब बे ईसु के झोने से जान लगे, तौ पतरस ईसु से कही, “गुरुजी, हमरो हिंयाँ रहनो भलो है: हम तीन तम्बु बनांगे, एक तेरे ताहीं, एक मूसा के ताहीं, और एक एलिय्याह के ताहीं” बौ सई मैं ना जानत रहै कि बौ का कहरौ है। ");
INSERT INTO thr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","जब बौ बोलतै रहै, तौ एक बादर दिखाई दई और उनकै अपनी छाया से तोप लई; जब बादर उनके ऊपर आओ, तौ चेला डराएगै। ");
INSERT INTO thr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","बादर से एक अबाज निकरी, “जौ मेरो लौड़ा है, जोकै मैं चुनो हौं। जाकी सुनौ!” ");
INSERT INTO thr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","जब अबाज बंद भइ, तौ हुँआँ ईसु अकेलो रहै; चेला जौ सबके बारे मैं चुप रहे और बे बौ समय कोई कै भी कछु ना बताईं, जो बे देखी रहैं। ");
INSERT INTO thr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","दुसरे दिन जब ईसु और तीन चेला पहाड़ से नीचे उतरे, तौ एक बड़ी भीड़ ईसु से मिली। ");
INSERT INTO thr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","एक आदमी भीड़ मैं से चिल्लाए कै कही, “गुरुजी! मैं तोसे बिनती करथौं, मेरे लौड़ा कै देख। जौ मेरो इकलौतो लौड़ा है। ");
INSERT INTO thr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","एक आत्मा बाकै अनकाचीति से चिल्लाए कै पकड़ लेथै, और बाकै एक फिट मैं फेंक देत रहै, और ऐसो ऐंठात रहैं कि मोहों मैं से झाग निकर जात रहै; और बाकै कुचलकै बड़ा मुस्किल से छोड़थै। ");
INSERT INTO thr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","और मैं तेरे चेलन से नहोरे करो, कि जाकै निकारैं; पर बे ना निकार पाईं।” ");
INSERT INTO thr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ईसु जबाब दई, “तुम लोग कितने अविस्वासी और गलत हौ! मैं कबले तुमरे संग रहांगो, और कबले तुमरी सहमंगो?” फिर बौ आदमी से कही, “अपने लौड़ा कै हिंयाँ लैया।” ");
INSERT INTO thr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","बौ बच्चा आतै रहै कि इत्ते मैं प्रेत आत्मा बाकै जमीन मैं गिराय दई, और बाकै एक फिट दूर फेंक दई; ईसु प्रेत आत्मा कै निकरन की आग्या दई, और लौड़ा कै अच्छो करकै बाके दऊवा कै सौंप दई। ");
INSERT INTO thr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","सब जनी परमेस्वर कि सक्तिसाली ताकत देखकै चौहोंक पड़े रहैं। जब हर कोई जो कुछ ईसु करत रहै, बे सब बातन से चौहोंक रहै, ईसु अपने चेलन से कही, ");
INSERT INTO thr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“जे बातैं तुमरे कानन मैं पड़ी रहाबै, काहैकि इंसान को लौड़ा इंसान के हात मैं पकड़बाओ जान बारो है।” ");
INSERT INTO thr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पर चेला जे बातन कै नाय समझत रहैं, और जौ उनसे छिपाओ गौ रहै; ताकी बे बाकै जान ना पामैं, और बे जौ बात के बारे मैं बासे पूँछन से डरात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","चेलन कि जौ बात मैं बहस छिड़ गई कि हममैं से बड़ो कौन है। ");
INSERT INTO thr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ईसु कै पता रहै कि बे मन मैं का सोच रै हैं, इसलै ईसु एक बालका कै लैकै अपने झोने ठड़बाई, ");
INSERT INTO thr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","और उनसे कही, “जो कोई भी मेरे नाओं से जौ बालका को स्वागत करथै, बौ मेरो स्वागत करथै; और जो मेरो स्वागत करथै, बौ मोकै भेजन बारे को स्वागत करथै, जो तुम मैं से सबसे छोटो से छोटो है, बहे बड़ो है।” ");
INSERT INTO thr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","फिर यूहन्ना कही, “गुरुजी, हम एक आदमी कै तेरे नाओं से प्रेत आत्मा कै निकारत भइ देखे है, और हम बाकै मना करे, काहैकि बौ हमरे संग को ना रहै।” ");
INSERT INTO thr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ईसु बासे और दुसरे चेलन से कही, “बाकै रोकन की कोसिस मत करौ; काहैकि जो तुमरे खिलाप ना है बौ तुमरे घाँईं है।” ");
INSERT INTO thr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जब ईसु स्वर्ग जानकै भौ, तौ बौ यरूसलेम कै जान ताहीं निकर पड़ो। ");
INSERT INTO thr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","बौ अपने अग्गु दूत भेजी, जो सामरियन के एक गाँव मैं जाएकै बाके ताहीं सब कछु तैयार कर दईं। ");
INSERT INTO thr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पर बे लोग बाकै ना अपनाईं, काहैकि बौ यरूसलेम कै जात रहै। ");
INSERT INTO thr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","जौ सब देखकै बाके चेला याकूब और यूहन्ना कहीं, “प्रभु; का तैं चाहथै, कि स्वर्ग से आगी गिरकै उनकै भसम कर देबै?” ");
INSERT INTO thr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ईसु मुड़कै उनकै झुकाइ। ");
INSERT INTO thr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","फिर ईसु और बाके चेला दुसरे गाँव गै। ");
INSERT INTO thr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","जब बे अपने रहा जात रहैं, तौ एक आदमी ईसु से कही, “जहाँ भी तैं जागो मैं तुमरे पच्छू आंगो।” ");
INSERT INTO thr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ईसु बासे कही, “लोमड़ियन के मांद हैं, और आसमान के पक्छिन के घोसला होथैं, लेकिन इंसान के लौड़ा के पास लेटन और सस्तान के ताहीं कोई जघा ना है।” ");
INSERT INTO thr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ईसु दूसरे आदमी से कही, “मेरे पच्छू आ।” लेकिन बौ आदमी कही, “प्रभु, पहले मोकै बापस जान दे ताकी मैं अपने दऊवा कै दफनाए दियौं।” ");
INSERT INTO thr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ईसु जबाब दई, “मरे भैन कै अपनेई मुर्दन कै दफनान दे, तैं जा और परमेस्वर के राज्य को ऐलान कर।” ");
INSERT INTO thr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","एकौर आदमी कही, “प्रभु, मैं तेरो पीछा करंगो; पर पहले मोकै जान दे कि अपने घरबारेन से बिदा हुई आमौं।” ");
INSERT INTO thr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ईसु बासे कही, “जो कोई अपनो हाथ हर मैं रखकै पच्छू देखथै, बौ परमेस्वर के राज्य के काबिल ना है।” ");
INSERT INTO thr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","जाके बाद प्रभु बहात्तर आदमिन कै चुनी और उनकै दुई-दुई करकै बाहर पनारी, ताकी बे हर सहर और बौ जघा मैं जामैं जहाँ बौ खुद जान बारो रहै। ");
INSERT INTO thr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ईसु उनसे कही, “गजब एक खेती है, लेकिन लेबर बड़ा कम हैं; इसलै खेत के प्रभु से प्रार्थना करौ, कि बौ अपने खेत काटन ताहीं लेबर भेज देबै। ");
INSERT INTO thr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जाबौ! भेंड़ियन के बीच मैं तुमकै मेमना के हानी भेज रौ हौं। ");
INSERT INTO thr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","इसलै बटुआ, झोला, जूता मत लियो; और ना रहामैं कोई से नमस्ते करियो। ");
INSERT INTO thr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जब भी तुम कोई के घर मैं जाथौ, तौ पहले कहियो, ‘जौ घर मैं सांति बनी रहाबै।’ ");
INSERT INTO thr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अगर हुँआँ कोई सांतिप्रिय होगो; तौ तुमरो आर्सिवाद बाके ऊपर बनो रहगो, अगर ना है, तौ सांति बने रहन को आर्सिवाद बापस लै लियो। ");
INSERT INTO thr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","बहे घर मैं रहबौ, और जो कछु उनसे मिलै, बहे खाबौ-पीबौ, काहैकि लेबर कै अपनी दिहाड़ी मिलनी चाहिए; घर-घर मत फिरियो। ");
INSERT INTO thr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","जब भी तुम कोई सहर मैं जाबौ, और हुँआँ के लोग तुमरो स्वागत करैं, तौ जो कछु तुमरे सामने रखो जाबै बहे खईयो, ");
INSERT INTO thr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","बौ सहर के बिमारन कै अच्छो करौ, और हुँआँ के लोगन से कहबौ, ‘परमेस्वर को राज्य तुमरे झोने आए चुको है।’ ");
INSERT INTO thr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","लेकिन जब भी तुम एक सहर मैं जाबौ, और हुँआँ के लोग तुमरो स्वागत ना करैं, तौ रहा से निकर जईयो और कहियो, ");
INSERT INTO thr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘तुमरे सहर को धूदर जो हमरे पाँव मैं लगो है, हम तुमरे सामने झार देथैं, लेकिन जौ याद रखियो कि परमेस्वर को राज्य तुमरे झोने आए चुको है!’ ");
INSERT INTO thr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","मैं तुमकै बिस्वास दिलाथौं कि परमेस्वर न्याय के दिन बौ सहर से जाधे सदोम के ऊपर दया दिखागो!” ");
INSERT INTO thr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“जौ तुमरे ताहीं कितनो भयानक होगो खुराजीन! जौ तुमरे ताहीं कितनो भयानक होगो बैतसैदा! जो सामर्थ्य के काम तुमरे ऊपर भै हैं, अगर बे सूर और सैदा मैं करे जाते, तौ टाट ओढ़कै और राख मैं बैठकै बे कबके अपने पाप से मन बदल लेते! ");
INSERT INTO thr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","पर न्याय के रोज तुमरी दसा से सूर और सैदा की दसा जाधे सहन के काबिल होगी। ");
INSERT INTO thr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","और हे कफरनहूम! का तैं स्वर्ग ले ऊँचो करो जागो? तैं तौ मरे भै के नरक मैं फेंको जागो!” ");
INSERT INTO thr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ईसु अपने चेलन से कही, “जो कोई तुमरी बात सुनथै, बौ मेरी बात सुनथै, जो तुमकै ना अपनाथै, बौ मोकै ना अपनाथै; और जो मोकै ना अपनाथै, बौ मोकै भेजन बारे कै ना अपनाथै।” ");
INSERT INTO thr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","बहात्तर आदमी बड़ा खुसी से लौटकै आयकै कहीं, “प्रभु, हिंयाँ तक कि प्रेत आत्मा हमरी बात मानी जब हम उनकै तेरे नाओं को हुकम दै!” ");
INSERT INTO thr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ईसु उनकै जबाब दई, “मैं सैतान कै स्वर्ग से बिजली के हानी गिरत भइ देखो। ");
INSERT INTO thr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","बात सुनौ! मैं तुमकै साँप और बीछी कै कुचलन को अधिकार दौ हौं और तुम अपने बैरी की पूरी सामर्थ्य के ऊपर जीत सकथौ, और तुमकै कोई नुकसान ना होगो। ");
INSERT INTO thr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","तहुँओं जासे खुस मत होबौ, कि बुरी आत्मा तुमरी बात मानथैं; पर तुम जासे खुस रहबौ कि तुमरो नाओं स्वर्ग मैं लिखे गै हैं।” ");
INSERT INTO thr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","बहे समय ईसु पवित्र आत्मा के जरिये खुसी से भरगौ, और कही, “दऊवा, स्वर्ग और पृथ्वी को प्रभु! मैं तोकै धन्यवाद देथौं, कि तैं जे बातन कै ग्यानिन और समझदारन से लुकाए रखो, हाँ, दऊवा जी, तोकै ऐसो होन से खुसी मिली। ");
INSERT INTO thr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","मेरो दऊवा मोकै सब कछु दई है; कोई ना जानथै कि लौड़ा दऊवा कै छोड़कै कौन है, और कोई ना जानथै कि दऊवा लौड़ा कै छोड़कै कौन है और लौड़ा कौनके चुनथै।” ");
INSERT INTO thr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","फिर ईसु चेलन के घाँईं मुड़कै अकेले मैं कही, “तुम कितने खुसनसीब हौ कि तुम जे चीजैं देखरै हौ! ");
INSERT INTO thr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","मैं तुमकै बताथौं, कि भौत से भविस्यवक्ता और राजा चाँहीं, कि जो तुम देखरै हौ, बौ बे देखैं; पर बे ना देख पाईं और जो तुम सुनथौ, बौ बे सुनैं, पर बे ना सुन सके।” ");
INSERT INTO thr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","फिर एक कानून को सिक्छक ईसु कै फसान की कोसिस करी; और कही, “गुरुजी, मोकै अनंत जिंदगी पान के ताहीं का करने पड़ैगो?” ");
INSERT INTO thr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ईसु बाकै जबाब दई, “नियम मैं का लिखो है? तैं कैसे पढ़थै?” ");
INSERT INTO thr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","बौ आदमी जबाब दई, “अपने पूरे मन से, अपनी पूरी ताकत से, और अपने प्रभु और परमेस्वर से प्यार करौ। और अपने पड़ोसी से बैसोई प्यार करौ जैसो तुम अपने आप से करथौ।” ");
INSERT INTO thr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ईसु बासे कही, “तैं ठीक जबाब दौ, जहे कर तौ तू जिंदो रैहगो।” ");
INSERT INTO thr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","लेकिन कानून को सिक्छक खुदकै सई ठहरानो चहात रहै, इसलै बौ ईसु से पूँछी, “मेरो पड़ोसी कौन है?” ");
INSERT INTO thr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ईसु जबाब दई, “एक बार एक आदमी रहै, जो यरूसलेम से यरीहो कै जात रहै, इत्ते मैं डाँकू बाकै घेर कै बाके लत्ता उतार लईं, और मार पीटकै बाकै अधमरा छोड़कै चले गै। ");
INSERT INTO thr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","और ऐसो भौ कि बहे रहा से एक पुजारी जात रहै, लेकिन जब बौ आदमी कै देखी, तौ बौ कतराएकै चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","बैसिये एक लेवी बौ जघा आओ, बहो बाकै देखकै कतराएकै चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","पर एक सामरी बौ रहा से सफर करत रहै, बौ बाके झोने आओ जो अधमरा पड़ो रहै, बौ बाकै देखी, तौ बाको दिल दया से भरगौ। ");
INSERT INTO thr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","बौ बाके झोने गौ, और बाके घाव मैं जैतून तेल और दाखरस डारकै पट्टी भाँदी; फिर बौ अधमरा आदमी कै अपने जानवर मैं चढ़ायकै सराय मैं लैगौ, और बाकी सेवा संती करी। ");
INSERT INTO thr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दुसरे रोज बौ दुई चाँदी के सिक्का निकारकै सराय के मालिक कै दै दई, और कही, ‘जाकी सेवा संती करिये, और जो कछु तेरो और लगैगो, बौ मैं लौटन पोती तोकै दै दुंगो।’ ");
INSERT INTO thr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","अब तेरी समझ मैं जो डाकुन मैं घिर गौ रहै, जे तीनौ मैं से बाको पड़ोसी कौन है?” ");
INSERT INTO thr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","कानून को सिक्छक जबाब दई, “बहे जो बाके ऊपर दया तरस खाई रहै।” ईसु फिर बासे कही, “तैं जा, तहूँ ऐसोई कर।” ");
INSERT INTO thr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","जब ईसु और बाके चेला अपने रहा जात रहैं, तौ बौ एक गाँव मैं आओ, जहाँ मार्था नाओं की एक बईय्यर अपने घरै बाको स्वागत करी। ");
INSERT INTO thr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","बाकी एक बहेनिया रहै, जोको नाओं मरियम रहै, बौ प्रभु के पाँव मैं बैठकै बाकी सिक्छा कै सुनत रहै। ");
INSERT INTO thr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पर मार्था सेवा करत-करत तंग हुई गई और बाके झोने आयकै कहेन लगी, “प्रभु, का तोकै कछु चिंता ना है कि मेरी बहेनिया मोकै सेवकाई करन के ताहीं इकल्ली छोड़ दई है? इसलै बासे कह, कि मेरी मदत करै!” ");
INSERT INTO thr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभु बाकै जबाब दई, “मार्था, मार्था! तैं भौत बातन की चिंता करथै और परेसान है, ");
INSERT INTO thr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","लेकिन एक बात जरूर है; मरियम अच्छी चीज चुनी है, जो बासे छीनो ना जागो।” ");
INSERT INTO thr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","एक रोज ईसु एक जघा मैं प्रार्थना करत रहै। जब बौ प्रार्थना कर चुको, तौ बाके चेलन मैं से एक चेला ईसु से कही, “प्रभु, जैसे यूहन्ना अपने चेलन कै प्रार्थना करनो सिखाई है बैसिये हमउँ कै तैं प्रार्थना सिखाए दे।” ");
INSERT INTO thr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ईसु उनसे कही, “जब तुम प्रार्थना करथौ, तौ जौ कहियो: ‘दऊवा: तेरो नाओं पवित्र मानो जाबै; तेरो राज्य आबै। ");
INSERT INTO thr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","हमरी दिन भर की रोटी हर रोज हमकै दे कर। ");
INSERT INTO thr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","और हमरे पापन कै माफ कर, काहैकि हम भी अपने हर एक कसूरवार कै माफ करथैं, और हमकै कठिन परिक्छा मैं मत ला।’” ");
INSERT INTO thr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","और ईसु अपने चेलन से कही, “मान लियौ तुम मैं से बाको एक दोस्त होबै, और बौ आधी रात कै बाके झोने जाएकै बासे कहबै, ‘दोस्त; मोकै तीन रोटी उधार दैदे। ");
INSERT INTO thr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","काहैकि मेरो एक दोस्त सफर करकै मेरे घरै आओ है, और मेरे पास बाके ताहीं कछु खान ताहीं ना है!’ ");
INSERT INTO thr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","और मान लेबौ कि तुमरो दोस्त अंदर से जबाब देबै, ‘मोकै परेसान मत करै! अब तौ फाटकौ बंद है, और मेरे बालका मेरे संग बिस्तर मैं हैं, मैं उठकै तोकै कछु ना दै सकथौं।’ ");
INSERT INTO thr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","खैर, फिर का? मैं तुमसे कहथौं, कि भलेई बाको दोस्त उठकै रोटी ना दई, तहुँओं बौ उठैगो और तुमकै तुम्हारी जरूरत की हर चीज देगो काहैकि तुमकै मांगत रहन मैं ना सरमानो चाहिए। ");
INSERT INTO thr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","और इसलै मैं तुमसे कहथौं: माँगौ, तौ तुमकै दौ जागो; ढूँड़ौ तौ तुम पाबैगे; खटखटाबौ, तौ तुमरे ताहीं मोहोंट खोलो जागो। ");
INSERT INTO thr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","काहैकि जो कोई मांगथै, बाकै मिलथै; और जो ढूँड़थै, बौ पाथै; और जो खटखटाथै, बाके ताहीं मोहोंट खोलो जागो। ");
INSERT INTO thr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","का तुम मैं से ऐसो कोई दऊवा होगो, कि जब बाको लौड़ा मच्छी माँगै, तौ बाको दऊवा बाकै मच्छी के बदले साँप देबै? ");
INSERT INTO thr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","या जब बौ अंडा माँगै, तौ का तुम बाकै बीछी देगे? ");
INSERT INTO thr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","तुम चाँहे जित्ते बुरे होबौ, तुम अपने बालका कै अच्छी चीज देनो जानथौ, तौ तुमरो स्वर्गिय दऊवा अपने माँगन बारे कै पवित्र आत्मा काहेकै ना देगो!” ");
INSERT INTO thr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","फिर ईसु एक गूँगी प्रेत आत्मा कै निकारी; जब प्रेत आत्मा निकर गई, तौ बौ आदमी बोलन लगो; और भीड़ हैरान रहै, ");
INSERT INTO thr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","लेकिन कुछ लोग कहीं, “जौ तौ प्रेत आत्मा को अधिकारी बालजबूल कि मदत से प्रेत आत्मा कै निकारथै।” ");
INSERT INTO thr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","और लोग ईसु कै फसानो चहात रहैं, इसलै उनके ऊपर परमेस्वर की मंजूरी है जौ साबित करन के ताहीं बाकै स्वर्ग से एक चिन्ह दिखान के ताहीं कहीं। ");
INSERT INTO thr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","लेकिन ईसु जानत रहै कि बे का सोचत रहैं, इसलै ईसु उनसे कही, “जो-जो देस मैं फूट पड़थै, बौ देस राज्य कभी न कर पाथै; और जो घर मैं फूट पड़थै, बौ परिवार अलग ही जाथै।” ");
INSERT INTO thr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","इसलै अगर सैतान अपनोई बिरोधी ही जाबै, तौ बाको राज्य कैसे बनो रहगो? तुम तौ मेरे बारे मैं कहथौ, कि जौ प्रेत आत्मा के मुखिया बालजबूल की मदत से प्रेत आत्मा कै निकारथै। ");
INSERT INTO thr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","अगर मैं बालजबूल की मदत से प्रेत आत्मा कै निकारथौं, तौ तुमरे चेला उनकै कैसे बाहर निकारथैं? तुमरे खुद के चेला न्याय करथैं कि तुम गलत हौ! ");
INSERT INTO thr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ना, मैं जौ परमेस्वर कि सक्ति के जरिये प्रेत आत्मा कै बाहर निकारथौं, और जौ साबित करथैं कि परमेस्वर को राज्य पहलेई तुमरे पास आए चुको है। ");
INSERT INTO thr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“जब एक तगड़ो आदमी, अपने पूरे हथियार के संग अपने घर आँगन की रखबारी सांति से करथै, तौ बाको पूरो सामान सुरक्छित रहथै।” ");
INSERT INTO thr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पर जब बासे तगड़ो कोई बाके ऊपर हमला करथै और बासे जीत जाथै, तौ बाके बे हथियार जोके ऊपर बाको भरोसो रहै, छीन लेथै और बाकी सम्पत्ति लूटकै बाँट देथै। ");
INSERT INTO thr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“जो मेरे संग ना है बौ मेरे बिरोध मैं है, और जो मेरे संग ना बटोरथै बौ बिखेरथै।” ");
INSERT INTO thr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“जब प्रेत आत्मा कोई आदमी के भीतर से निकर जाथै, तौ बौ सूखे देस मैं आराम करन ताहीं जघा ढूँड़त फिरथै, और जब ना मिलथै तौ खुदकै कहथै, ‘कि मैं अपने बहे घर मैं जहाँ से निकरो रहौं बापस जांगो।’ ");
INSERT INTO thr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","और बापस आयकै बाकै साफ-सुथरो और सजो-सजाओ मिलथै। ");
INSERT INTO thr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","फिर बौ आयकै अपने से और जाधे बुरी सात आत्मा कै अपने संग लै आथै, और बे बामै समाएकै बास करथैं, बौ आदमी की दसा पहले कि दसा से और बुरी ही जाथै।” ");
INSERT INTO thr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","जब ईसु जे बात कहतै रहै तौ भीड़ मैं से एक बईय्यर जोड़न से ईसु से कही, “बौ बईय्यर कितनी खुसनसीब है जो तैं बाकी कोक मैं रहो, और तेरो पालन पोसँड़ करी!” ");
INSERT INTO thr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","लेकिन ईसु जबाब दई, “बल्किन, बे कितने खुसनसीब हैं जो परमेस्वर को बचन सुनथैं और बाकै मानथैं!” ");
INSERT INTO thr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जैसे-जैसे लोगन की भीड़ ईसु के चारौ तरफ जमा भइ, ईसु कही, “आज-कल के लोग कितने बुरे हैं! बे चिन्ह कै पूँछथैं, लेकिन योना के चिन्ह के अलावा उनकै कोई और चिन्ह उनकै ना दौ जागो। ");
INSERT INTO thr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जैसे योना नीनवे के लोगन के ताहीं चिन्ह रहै, बैसिये इंसान को लौड़ा आज-कल के लोगन के ताहीं एक चिन्ह होगो। ");
INSERT INTO thr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","न्याय के दिन तरिहाँए सीबा की रानी उठ खड़ी होगी और आज के लोगन के ऊपर इल्जाम लगागी, काहैकि बौ राजा सुलैमान की अकल को ग्यान सुनन के ताहीं अपने देस से पूरी पृथ्वी को रहा सफर करी; मैं तुमसे कहथौं, कि हिंयाँ कछु है, जो राजा सुलैमान से भी बड़ो है। ");
INSERT INTO thr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","नीनवे के लोगन के घोसड़ाँ बारे दिन आज-कल के लोगन के संग ठाड़कै, और तुमरे ऊपर दोस लगांगे; काहैकि बे योना को उपदेस सुनकै मन बदलीं और देखौ, हिंयाँ बौ है, जो योना से भी बड़ो न्याय करन बारो है।” ");
INSERT INTO thr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कोई आदमी दिया जलायकै लुकात ना है या छपरिया के नीचे ना रखथै; बल्किन बाकै डीट मैं रखथै, ताकी लोग उजिते मैं देख सकैं और भीतर आए सकैं। ");
INSERT INTO thr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तुमरी सरीर को दिया तुमरी आँखी है, इसलै जब तुमरी आँखी अच्छी है, तौ तुमरो पूरो सरीर उजिते से भरो होथै; लेकिन जब तुमरी आँखी अच्छी ना होंगी, तौ तुमरो पूरो सरीर अंधियारे मैं होगो। ");
INSERT INTO thr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","पक्को करैं, कि कहूँ जो उजियारे तुमरे मैं है बौ अंधियारे मैं ना हुई जाबै। ");
INSERT INTO thr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","अगर तुमरो पूरो सरीर उजिते से भरो है, और तेरो कोई भी हिस्सा अंधियारे मैं ना होबै, तौ सब जघा ऐसो उजितो होगो, जैसे एक दिया अपनी चमक से तोकै उजितो देथै।” ");
INSERT INTO thr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","जब ईसु बोलनो बंद करी, तौ एक फरीसी बासे अपने संग खानु खान ताहीं पूँछी; इसलै बौ भीतर जाएकै खानु खान कै बैठगौ। ");
INSERT INTO thr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी हैरान ही गौ, जब बौ देखी कि ईसु खानु खान से पहले हात ना धोई है। ");
INSERT INTO thr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","तौ प्रभु बासे कही, “फरीसियौ, तुम कप और थरिया कै बाहर से सुद्ध करथौ, लेकिन तुमरे भीतर हिंसा और बुराई भरी भइ है। ");
INSERT INTO thr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","मूर्ख! परमेस्वर जो बाहर को हिस्सा बनाई, का बौ भीतर को हिस्सा ना बनाई? ");
INSERT INTO thr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","लेकिन अपने कप और प्लेटन मैं जो कछु है, बाकै गरीबन के दै देबौ और सब कछु तुमरे ताहीं विधि पूर्वक सुद्ध ही जागो।” ");
INSERT INTO thr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“फरीसियौ तुमरे ताहीं कितनो भयानक है! तुम परमेस्वर कै मसाला और पुदीना और भौत सी जड़ी बूटिन के पौध जैसे मौसमी जड़ी बूटिन को दसमों हिस्सा देथौ, लेकिन तुम परमेस्वर के प्यार कै टाल देथौ; जौ तुमकै दुसरेन कि उपेक्छा के बिना कोसिस के न्याय करनो चाहिए।” ");
INSERT INTO thr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“तुम फरीसियन के ताहीं कितनो भयानक है! तुम सभाघरन मैं खास-खास आसन से प्यार करथौ और बजार मैं नमस्ते चाहथौ। ");
INSERT INTO thr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","तुमरे ताहीं कितनो भयानक है! काहैकि तुम बिना निसानी के कबर के हानी हौ, जिनके ऊपर लोग चलथै, पर ना जानथैं।” ");
INSERT INTO thr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","कानून के सिक्छकन मैं से एक ईसु से कही, “गुरुजी, जब तैं जौ कहरौ है, तौ तैं हमरी भी बेजती कर रौ है!” ");
INSERT INTO thr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ईसु जबाब दई, “तुम्हऊँ कानून के सिक्छकन के ताहीं कितनो भयानक है! तुम ऐसे बोझ जिनकै उठानो मुस्किल है, इंसानन के ऊपर लादथौ पर तुम खुद बे बोझन कै उठान मैं मदत करन के ताहीं एक उँगरिया तक ना लगाथौ। ");
INSERT INTO thr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","तुमरे ताहीं कितनो भयानक है! तुम बे भविस्यवक्ता कि कबर बनाथौ, जिनकै तुमरे पुरखा मारडारीं रहैं। ");
INSERT INTO thr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","तुम गभा हौ, और अपने पुरखन के कामन से सहमत हौ; काहैकि बे भविस्यवक्ता कि हत्या करीं और तुम उनकी कबर बनाथौ। ");
INSERT INTO thr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","इसलै परमेस्वर कि बुद्धि कही, ‘कि मैं उनके झोने भविस्यवक्ता और प्रेरितन कै भेजंगो; और बे उनमैं से कुछ कै मार देंगे और कुछ कै सतांगे।’ ");
INSERT INTO thr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","दुनिया कि उत्पत्ति के बाद से मारे गै सबै भविस्यवक्ता कि हत्या के ताहीं जौ समय के लोगन कै खून की सजा दई जागी, ");
INSERT INTO thr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","हाबिल कि हत्या से लैकै जकर्याह कि हत्या तक जो बेदी और पवित्र जघा के बीच मारे गै हैं: हाँ, मैं तुमकै बताथौं, जौ समय के लोगन कै उन सबन कै परमेस्वर के घर मैं खून की सजा दी जागी! ");
INSERT INTO thr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","तुम कानून के सिक्छकन के ताहीं कितनो भयानक है! तुम ग्यान कि कुंजी रख तौ लै हौ जो ग्यान के घर को फाटक खोलथै; पर तुम खुद ना गै, और जो अंदर जान कि कोसिस करत रहैं, उनकै भी रोक दै!” ");
INSERT INTO thr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जब ईसु बौ जघा से चले गौ, तौ यहूदि नियम के सिक्छक और फरीसी बाकी बुराई करीं और ईसु से गजब सवाल पूँछीं, ");
INSERT INTO thr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","और बाकै फसान के ताहीं घात मैं लगे रहे, ताकी बाके कछु गलत कहेन मैं पकड़ सकैं। ");
INSERT INTO thr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","इतने मैं जब हजारो जनी एक संग भीड़ लगाईं, हिंयाँ तक कि एक दुसरेन के ऊपर गिरे जामैं, तौ ईसु सबसे पहले अपने चेलन से कही, “फरीसियन के खमीर के खिलाप रहबौ, मेरो मतलब पाखंड से है। ");
INSERT INTO thr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","जो कछु लुकाओ गौ है, बाकै उजागर करो जागो, और हर रहस्य को पता करो जागो। ");
INSERT INTO thr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","इसलै जो कछु तुम अंधियारे मैं कहे हौ, बौ उजिते मैं सुनो जागो; और जो तुम बंद कमरा मैं कानाफूसी को प्रचार करे हौ, बौ मकान कि छत से चिल्लाओ जागो।” ");
INSERT INTO thr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“मैं तुमकै बताथौं, मेरे दोस्तौ, सरीर कै मारन बारेन से मत डराबौ, काहैकि बासे जाधा और कछु ना कर सकथैं। ");
INSERT INTO thr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मैं तुमकै दिखांगो कि कौन से डराने है: परमेस्वर से डराबौ, जो मारन के बाद नरक मैं फेंकन को अधिकार रखथै, मेरो बिस्वास करौ, बौ बहे है जोसे तुमकै डरानो चाहिए!” ");
INSERT INTO thr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“का दुई पैसा के सिक्का की पाँच गौरैया ना बिकथैं? फिर भी परमेस्वर उनमैं से एक कै भी ना भूलथै। ");
INSERT INTO thr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","हिंयाँ तक कि तुमरी मुड़िया के बार भी गिने जा चुके हैं, इसलै डराबौ मत; तुम भौत गौरैयन से जाधा बढ़कै हौ!” ");
INSERT INTO thr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“मैं तुमकै बिस्वास दिलाथौं कि जो लोग सबन के सामने मोकै मान लेंगे, कि बे मेरे हैं, इंसान को लौड़ा भी परमेस्वर के स्वर्गदूतन के सामने ऐसोई करैगो। ");
INSERT INTO thr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","लेकिन जो लोग मोकै सबन के सामने ना अपनाथैं, इंसान को लौड़ा भी परमेस्वर के स्वर्गदूतन के सामने उनकै अपनान से मना कर देगो।” ");
INSERT INTO thr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“जो कोई भी इंसान के लौड़ा के खिलाप एक सब्द कहथै उनकै माफ करो जा सकथै; लेकिन जो कोई भी पवित्र आत्मा के खिलाप बुराई करथै, बाकै कहुए माफ ना करो जा सकथै।” ");
INSERT INTO thr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“जब बे तुमकै सभाघरन मैं या राज्यपालन या सासक अधिकारिन के सामने लामैं, तौ जौ बात कि चिंता मत करियो कि तुम खुद को बचाव कैसे करैगे या तुम अपने मैं अधिकार का कहबैगे। ");
INSERT INTO thr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","पवित्र आत्मा तुमकै बौ समय सिखाए देगी, जो तुमकै कहनो चाहिए।” ");
INSERT INTO thr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","फिर भीड़ मैं से एक आदमी ईसु से कही, “गुरुजी, मेरे भईय्या से कह, कि दऊवा कि सम्पत्ति मोकै बाँट दे जो हमरो दऊवा हमरे ताहीं छोड़ी है।” ");
INSERT INTO thr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ईसु बाकै जबाब दई, “दोस्त, कौन मोकै दुई के बीच कि सम्पत्ति को न्याय करन या हिस्सा डारन को अधिकार दई है?” ");
INSERT INTO thr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","और बौ बे सबन से कहत गौ, “देखौ और हर तरहन के लालच से खुद के बचाबौ; काहैकि तुमरी सच्ची जिंदगी बे चीजन से ना बनथै, जो तुमरी खुद कि हैं, चाहे तुम कितने सेठ क्यों ना होबौ।” ");
INSERT INTO thr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","तौ ईसु उनकै जौ कहानी सुनाई: “एक सेठ आदमी रहै जोके पास जमीन रहै, और बाकी बड़ा अच्छी फसल भइ रहै। ");
INSERT INTO thr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","तौ बौ अपने मन मैं सोचन लगो, मेरे पास अपनी फसल रखन के ताहीं जघा ना है: मैं का कर सकथौं? ");
INSERT INTO thr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","और बौ कही, ‘मैं जौ करंगो: मैं अपनी बखारी तोड़कै उनसे बड़ी बनांगो; और बामै अपनो सब खलियान को अन्न और गेंहूँ रखंगे। ");
INSERT INTO thr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","तौ मैं अपने आप से कहेंगो, भाग्यसाली आदमी! तेरे पास गजब सालन के ताहीं सम्पत्ति और जरूरी सब अच्छी चीजैं हैं; चैन से रहा, खा, पी, सुख से रहा!’ ");
INSERT INTO thr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","लेकिन परमेस्वर बासे कही, तैं मूर्ख है! जहे रात तेरी जान तोसे लै लई जागी; तौ जो कछु तैं अपने आप इखट्टो करो है, बौ कौन को होगो?” ");
INSERT INTO thr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","और ईसु उपाय निकारी, “ऐसोई बौ आदमी भी है जो अपने ताहीं धन बटोरथैं, पर परमेस्वर कि नजर मैं सेठ ना हैं।” ");
INSERT INTO thr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","तौ ईसु अपने चेलन से कही, “और इसलै मैं तुमसे कहथौं, अपनी ज्यान के ताहीं खानु के बारे मैं या सरीर के ताहीं जरूरी लत्तन के बारे मैं चिंता मत करौ। ");
INSERT INTO thr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","काहैकि ज्यान खानु से, और सरीर लत्तन से जाधे जरूरी है। ");
INSERT INTO thr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कउवा कै देखौ: बे बीज ना लगाथै और ना फसल कै इखट्टो करथैं; उनके पास भंडार को घर या खेत खलियान ना हैं; फिर भी परमेस्वर उनकै खबाथै! तुमरो मूल्य पक्छिन की तुलना मैं भौत है! ");
INSERT INTO thr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","का तुम मैं से कोई भी जिंदगी के बारे मैं चिंता करकै थोड़ी सो लम्बो जी सकथै? ");
INSERT INTO thr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","अगर तुम इत्ती छोटी चीज ना कर सकथौ, तौ और दुसरी चीजन के बारे मैं काहे चिंता करथौ? ");
INSERT INTO thr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","देखौ जंगली फूल मेरी महिमा के जरिया कैसे बढ़थैं: बे काम ना करथैं और ना अपने ताहीं लत्ता बनाथैं; लेकिन मैं तुमकै बताथौं, कि राजा सुलैमान भी अपनी पूरी सम्पत्ति मैं से एकौ फूल के हानी सुगड़ लत्ता ना पहनी रहै। ");
INSERT INTO thr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","अगर परमेस्वर मैदान कि घाँस कै जो आज है, और कल भट्टी मैं झोंकी जागी, ऐसो पहनाथै; तौ कम बिस्वास करन बारे, बौ तुमकै और जाधे काहे ना पहनागो?” ");
INSERT INTO thr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“और तुम जौ बात की परेसानी मैं मत रहबौ, कि का खांगे और का पींगे। ");
INSERT INTO thr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","काहैकि दुनिया के गैर यहूदि जे सब चीजन कै ढूँड़न मैं रहथैं और तुमरो दऊवा जानथै, कि तुमकै जे चीजन कि जरूरत है। ");
INSERT INTO thr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","जाके बदले, बाके राज्य कै ढूँड़न मैं लगे रहबौ, तौ जे चीजैं भी तुमकै मिल जांगी।” ");
INSERT INTO thr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“छोटो झुंड, मत डराबै; काहैकि तुमरे दऊवा कै जौ अच्छो लगो है, कि तुमकै राज्य देबै। ");
INSERT INTO thr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","अपनो सब हानी बेचकै गरीबन कै पैसा दै देबौ; और अपने ताहीं ऐसो बटुआ बनाबौ, जो पुराने ना होथैं, मतलब स्वर्ग मैं ऐसो धन इखट्टो करौ जो घटत ना है, जोके झोने चुट्टा ना जाए सकथै, और कीरा करमोला नास ना कर सकथैं। ");
INSERT INTO thr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","काहैकि जहाँ तुमरो धन है, हूँनै तुमरो मन भी लगो रहबैगो।” ");
INSERT INTO thr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“जो भी आथै बाके ताहीं तैयार रहबौ, कारवाई के ताहीं लत्ता पहनै और अपने दिया जलाए रखाबौ, ");
INSERT INTO thr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","और तुम बे नौकरन के हानी बनौ, जो बिहा की दावत से अपने प्रभु के बापस आन के ताहीं असियाय रै हैं; जब बौ आगो और फाटक खटखटागो, तौ तुरंत बाके ताहीं फाटक खोल देंगे। ");
INSERT INTO thr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","खुसनसीब हैं बे सेवक, जिनके प्रभु बापस आन मैं उनकै जगत भइ और सेवा करत भै पाथै! मैं तुमसे सच्ची कहथौं, बौ अपनो कोट उतारकै, उनके झोने बैठ जागो, और उनके संग असियागो। ");
INSERT INTO thr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","अगर बौ आधी रात कै या बाके बाद आयकै उनकै जगत भइ पाबै, तौ बे नौकर कितने खुस होंगे! ");
INSERT INTO thr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","और तुम जौ पक्को कर सकथौ कि अगर कोई घर के मालिक कै पता होतो कि चुट्टा कौन से समय आगो, तौ बौ जगत रहतो, और चुट्टा कै अपने घर मैं ना घुसन देतो। ");
INSERT INTO thr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुम्हऊँ तैयार रहबौ; काहैकि जो समय तुम सोचैगे भी ना, बहे समय इंसान को लौड़ा आ जागो।” ");
INSERT INTO thr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","पतरस कही, “प्रभु, का जौ कहानी हमरे ताहीं लागू होथै, या तैं जौ सबन के ताहीं कहरौ है?” ");
INSERT INTO thr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभु जबाब दई, “बौ बफादार, अकलदार और भरोसेमंद प्रबंधक कौन है? जोकै बाको मालिक, घर चलान के ताहीं और सेवक के झुंड मैं से एक कै सई समय मैं खानु देन ताहीं सरदार बनाबै। ");
INSERT INTO thr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","खुसनसीब है बौ सेवक, जोकै बाको प्रभु आयकै ऐसोई करत पाबै। ");
INSERT INTO thr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","सच मैं, मैं तुमकै बताथौं, मालिक बौ नौकर कै अपनी पूरी सम्पत्ति को अधिकारी बनाए देगो। ");
INSERT INTO thr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पर अगर बौ सेवक अपने मन मैं सोचन लगै, कि मेरो प्रभु आन मैं देरी कर रौ है, और दुसरे दास और दासियन कै मारनो-पीटनो सुरू कर देबै, और खाए-पीकै नसा मैं होन लगै, ");
INSERT INTO thr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तौ बौ सेवक को प्रभु ऐसे रोज आगो, जब नौकर बाकै ना असियागो, और ऐसे समय जोकै बौ ना जानत होगो, आगो और बाकै गजब दुख दैकै बाको हिस्सा अविस्वासी के संग ठहरागो।” ");
INSERT INTO thr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","और बौ सेवक जो जानत रहै कि बाको प्रभु बासे का चाहथै, और बौ तैयार ना रहै ना बाकी इच्छा के हिसाब से चलो, बाकै सजा दई जागी। ");
INSERT INTO thr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","लेकिन जो नौकर जौ ना जानथै कि बाको मालिक का चाहथै, और फिर भी कुछ ऐसो करथै जोके ताहीं बौ कोड़े खान को हकदार है, बाकै हल्के कोड़े से सजा दई जागी। जो आदमी कै भौत कछु दौ जाथै, बासे भौत माँगो जागो; और जोकै भौत सौंपो गौ है, बासे भौत लौ जागो। ");
INSERT INTO thr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“मैं धरती कै आगी लगान कै आओ रहौं, और मैं कैसे चहात रहौं कि जौ पहले सेई जल जाबै! ");
INSERT INTO thr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मोकै तौ एक बपतिस्मा लेने है; और जबले बौ ना हुई लेबै तौले मैं कैसी हालत मैं रहेंगो! ");
INSERT INTO thr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","का तुमकै लगथै कि मैं धरती मैं सांति लान के ताहीं आओ हौं? ना, सांति ना, बल्कि अलग करन आओ हौं। ");
INSERT INTO thr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","काहैकि अब से एक परिवार मैं पाँच जनी आपस मैं बिरोध रखंगे, तीन दुई से और दुई तीन से। ");
INSERT INTO thr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","दऊवा लौड़ा से, और लौड़ा दऊवा से बिरोध रखैगो, और अईय्या अपनी लौड़िया के खिलाप होंगी, और लौड़ियैं अपनी अईय्यन के खिलाप होंगी; सास अपनी बहु के और बहु अपनी सास के खिलाप होंगी।” ");
INSERT INTO thr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","और ईसु लोगन से जहो कही, “जब बादर कै पछार से उठत भइ देखथौ, तौ तुरंत कहथौ, कि मेंहें बरसैगो; और ऐसोई होथै। ");
INSERT INTO thr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","और जब तरिहाँए कि ब्यार चलत देखथौ, तौ कहथौ, कि लुहू चलैगी, और ऐसोई होथै। ");
INSERT INTO thr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","अरे ढोंगियौ! तुम धरती और आसमान कै देखकै मौसम कै परख सकथौ; फिरौंकी, तुम जौ अभै जो चल रौ है बाको मतलब काहेकै ना समझथौ?” ");
INSERT INTO thr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“तुम अपने आपै परख करकै न्याय काहेकै ना कर लेथौ, कि धर्मी कौन है? ");
INSERT INTO thr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","अगर कोई अधिकारी तुमरे खिलाप मुकदमा करथै और तुमकै अदालत मैं लै जाथै, तौ तुम अदालत मैं जान से पहलेई खुदकै छुड़ान की पूरी कोसिस करौ; अगर तुम ना निपटागे, तौ तुमकै न्याई के सामने खींच लौ जागो, जो तुमकै सिपईय्या कै सौंप देगो, और तुमकै कैदखाना मैं डार दौ जागो। ");
INSERT INTO thr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मैं तुमकै बताथौं, कि जबले तुम अपनो जुर्माना पाई-पाई ना चुकाए देगे तौले हुँआँ से छुट ना पागे।” ");
INSERT INTO thr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","बौ समय कुछ लोग हुँआँ रहैं, जो ईसु कै बे गलीली के बारे मैं बताईं, जिनकै पिलातुस तौ मारी रहै जब बौ परमेस्वर कै खून की बलि करत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","जौ सुनकै ईसु उनकै जबाब दई, “का तुम समझथौ, कि बे गलीली दुसरे गलीली से जाधे पापी रहैं कि उनकै ऐसे मार दौ गौ? ");
INSERT INTO thr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","बास्तव मैं नाय! और मैं तुमसे कहथौं कि अगर तुम अपने पापन से मन ना बदलैगे, तौ तुम्हऊँ उनके हानी मर जागे। ");
INSERT INTO thr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","सिलोह मैं बे अठारै जनी के बारे मैं का है उनके ऊपर गुम्मट गिरो, और बे मारे गै रहैं? का तुमकै लगथै कि जौ साबित होथै कि बे यरूसलेम मैं रहेन बारे दुसरे सब जनी कि तुलना मैं पापी रहैं? ");
INSERT INTO thr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","बास्तव मैं न! और मैं तुमसे कहथौं, कि अगर तुम अपने पापन से ना मन बदलैगे, तौ तुम सब मर जाबैगे, जैसो बे करी रहैं।” ");
INSERT INTO thr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","फिर ईसु उनकै जौ कहानी सुनाई, “एक बार एक आदमी रहै, जोके अंगूर की बारी मैं एक अंजीर को पेंड़ रहै: बौ बामै अंजीर कै ढूँड़न कै गौ, लेकिन कछु ना मिलो। ");
INSERT INTO thr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तौ बौ अपनी बारी के रखबरिया से कही, रखबरिया ‘देख, तीन साल से मैं जौ अंजीर के पेंड़ मैं अंजीर ढूँड़त आयरौ हौं, और मोकै कछु न मिलो; जाकै काट दे! कि जौ जमीन कै भी काहे रोके रहमैं?’ ");
INSERT INTO thr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","लेकिन रखबरिया जबाब दई, ‘प्रभु जाकै जौ साल तौ और छोड़ दे; मैं जाके चारौ घाँईं से खोदकै खाद डारंगो। ");
INSERT INTO thr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","फिर अगर अगले साल अंजीर को पेंड़ फरो तौ भलो, अगर ना फरो तौ जाकै काट देंगे।’” ");
INSERT INTO thr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","साबत के रोज ईसु एक सभाघर मैं सिक्छा देत रहै। ");
INSERT INTO thr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","हुँआँ एक बईय्यर रहै, जोकै अठारै साल से एक कमजोर करन बारी प्रेत आत्मा पकड़े रहै, बौ कतई लोहोक गई रहै और कतईये सीधी ना हुई पात रहै। ");
INSERT INTO thr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","जब ईसु बाकै देखी, तौ ईसु बासे बोली, “बईय्यर, तैं अपनी बिमारी से आजाद है!” ");
INSERT INTO thr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ईसु बाके ऊपर हाथ धरी, और बौ तुरंतै सीधी हुई गई, और परमेस्वर कि बड़ाँईं करन लग गई। ");
INSERT INTO thr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","सभाघर के मुखिया गुस्सा मैं रहै बौ जौ ताहीं कि ईसु साबत के रोज बाकै अच्छो करी रहै, सभाघर के अधिकारी खिसियाए कै लोगन से कहेन लगे, “छै रोज हैं, जोमैं काम करनो चाहिए, और बेईं दिनन मैं आयकै अच्छे होबौ; पर साबत के रोज ना!” ");
INSERT INTO thr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","प्रभु बाकै जबाब दई, “तुम ढोंगी हौ! का साबत के रोज तुम मैं से कोई भी अपने बरधा या गधा कै सार से खोलकै पानी नाय पिबागो। ");
INSERT INTO thr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","हिंयाँ अब अब्राहम को बंस है, जोकै सैतान अठारै साल ले कब्जा मैं करे रखाई रहै; का बाकै साबत के रोज बंधन से आजाद ना करो जानो चाहिए?” ");
INSERT INTO thr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ईसु को जबाब बाके दुस्मनन कै खुदकै सरम बाए दई, जबकी लोग बे सब अचम्मे चीजन मैं खुसी मनाईं जो बौ महान काम करी रहै। ");
INSERT INTO thr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ईसु पूँछी, “परमेस्वर को राज्य कैसो है? मैं जाके संग का कि तुलना करौं? ");
INSERT INTO thr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","बौ राया के एक गूदा के हानी है, जोकै एक आदमी लैकै अपनी बारी मैं बोई: और बौ बढ़कै पेंड़ बन गौ; और आसमान के पक्छी बाकी हँगईय्या मैं अपनो घोसला बनाईं।” ");
INSERT INTO thr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ईसु फिर से पूँछी, “मैं परमेस्वर के राज्य कि तुलना कासे करौं? ");
INSERT INTO thr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","जौ जाके हानी है: कि एक बईय्यर थोड़ी खमीर लैकै तीन नाप चून मैं मिलाथै, तौले मिलाथै जबले कि चून खमीर मैं अच्छे से मिलत ना है।” ");
INSERT INTO thr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ईसु सहर-सहर, और गाँव-गाँव से गुजरो, और लोगन कै पढ़ातो और यरूसलेम के घाँईं अपनो रहा बनात रहै। ");
INSERT INTO thr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","कोई बासे पूँछी, “प्रभु जी, कुछ लोगन कै बचाओ जागो?” ");
INSERT INTO thr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ईसु उनकै जबाब दई, “पतरे फाटक से भीतर जान कि पूरी कोसिस करौ; काहैकि भौत से लोग जरूर करकै भीतर जान कि कोसिस करंगे, लेकिन जाए ना पांगे। ");
INSERT INTO thr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जब घर को मालिक उठकै फाटक बंद कर देगो, और तुम बाहर ठाड़कै फाटक खटखटाए कै कहगे, ‘हमरे ताहीं फाटक खोल दे, प्रभु!’ बौ तुमकै जबाब देगो, ‘मोकै न पता है कि तुम कहाँ से आथौ!’ ");
INSERT INTO thr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तौ तुम जबाब देगे, ‘हम तेरे संग खाए और पिये; तैं हमरे सहर मैं पढ़ाओ है!’ ");
INSERT INTO thr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","लेकिन बौ फिर से कहेगो, ‘मोकै ना पता है कि तुम कहाँ से आथौ; मोसे दूर हुई जाबौ, तुम सब जनी अधर्मी हौ!’ ");
INSERT INTO thr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","हुँआँ रोनो और दाँत पीसनो होगो, जब तुम अब्राहम और इसहाक और याकूब और सब भविस्यवक्ता कै परमेस्वर के राज्य मैं बैठे भै देखैगे, और अपने आपकै बाहर निकारे भै देखैगे! ");
INSERT INTO thr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","लोग अगार और पछार से, सीरे और तरिहाँए से आंगे, और परमेस्वर के राज्य मैं खानु खान कै बैठंगे। ");
INSERT INTO thr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","फिर जो अभै आखरी मैं हैं बे पहले होंगे, और जो अभै पहले हैं बे आखरी मैं होंगे।” ");
INSERT INTO thr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","बहे समय कुछ फरीसी ईसु के झोने आए और बासे कहीं, “तोकै हिंयाँ से निकरकै कहूँ और जाने होगो, काहैकि हेरोद तोकै मारनो चाहथै।” ");
INSERT INTO thr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ईसु उनकै जबाब दई, “जाएकै बौ लोमड़ी से कहदे, कि देख मैं आज और कल प्रेत आत्मा कै निकर रौ हौं और चंगो कर रहो हौं, और तिसरे रोज अपनो काम पूरो करंगो।” ");
INSERT INTO thr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","फिर भी मोकै आज और कल और परसौं अपने रहा जानो जरूरी है, काहैकि हुई ना सकथै कि कोई भविस्यवक्ता यरूसलेम के बाहर मारो जाबै। ");
INSERT INTO thr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“यरूसलेम! यरूसलेम! तैं भविस्यवक्ता कै मारथै, तैं बे खबरिन कै पथरा मारथै जिनकै परमेस्वर तुमरे ताहीं भेजी है! कित्ती बार मैं चाहो, कि जैसे पक्छी मुर्गिया अपने चूजन कै अपने पखमन के तरे इखट्टो करथै, बैसिये महुँ तेरे बालकन कै इखट्टो करौं, पर तैं मोकै जौ ना करन देथै! ");
INSERT INTO thr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","और जौ बजे से तुमरे मंदिर कै छोड़ दौ जागो, और मैं तुमकै बिस्वास दिलाथौं कि जबले तुम कहगे न कि, ‘आसीसित है बौ जो प्रभु के नाओं से आथै,’ तौले तुम मोकै फिर कहु ना देखैगे।” ");
INSERT INTO thr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ईसु एक साबत के रोज फरीसियन के अधिकारी मैं से कोई के घरै खानु खान गौ: और लोग ईसु कै झोने से देखत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","एक आदमी जोके पाँव और हाथ सूज गै रहैं, ईसु के झोने आओ, ");
INSERT INTO thr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","और ईसु कानून और फरीसियन के सिक्छकन से बात करी और पूँछी, “का हमरे नियम के हिसाब से साबत के रोज अच्छो करन कि इजाजत है या ना है?” ");
INSERT INTO thr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","लेकिन बे एक बार कछु न कहीं; ईसु बौ आदमी कै हाथ लगाएकै अच्छो करी, और बाकै बिदा करी। ");
INSERT INTO thr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","फिर ईसु उनसे कही, “तुम मैं से ऐसो कौन है, अगर तुमरो बालका या बरधा कुआँ मैं गिर जाबै तौ का तुम साबत के रोज बाकै बाहर ना निकारैगे?” ");
INSERT INTO thr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","लेकिन उनकै ईसु कै जौ बारे मैं जबाब देन कि हिम्मत ना रहै। ");
INSERT INTO thr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ईसु देखी कि कैसे कुछ हितुआ अच्छी जघा कै चुन रै हैं, जौ बजे से ईसु बे सबन के ताहीं जौ कहानी बताई: ");
INSERT INTO thr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“जब कोई तोकै बिहा मैं बुलाबै, तौ सबसे अच्छी जघा मैं मत बैठिये; ऐसो भी हुई सकथै कि बौ तोसे भी कोई भौत जरूरी आदमी कै न्युतो दई होबै, ");
INSERT INTO thr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","और जो तोकै और बाकै दोनों कै न्युतो दई है, बौ आयकै तोसे कहबै, ‘कि जाकै जघा दे,’ तौ तोकै सर्मिंदा होन पड़ैगो और सबसे नीची जघा मैं बैठन पड़ैगो। ");
INSERT INTO thr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","जाके बदले, जब तोकै बुलाओ जाबै, तौ सबसे नीची जघा मैं बैठ, ताकी तेरे झोने न्युतो देन बारो आबै, तौ तोसे कहबै, ‘मेरे दोस्त, एक अच्छी जघा मैं बैठ,’ तौ तेरे संग बैठन बारेन के सामने तेरी बड़ाँईं और महिमा होगी। ");
INSERT INTO thr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","काहैकि जो कोई अपने आपकै बड़ो बनागो, बौ छोटो करो जागो; और जो कोई अपने आपकै छोटो बनागो, बौ बड़ो करो जागो।” ");
INSERT INTO thr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तौ ईसु अपने न्युतो देनबारे से भी कही, “जब तैं दिन को या रात को हटकना करै, तौ अपने दोस्तन कै या भईय्यन कै या अपने हितुअन कै या अपने सेठ पड़ोसिन कै मत बुलाबै, कहूँ ऐसो ना होबै, कि बेऊँ तोकै न्युतो देमैं, और तेरो बदलो ही जाबै। ");
INSERT INTO thr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","पर जब तैं हटकना करै, तौ गरीबन कै, अपंगन कै, लंगड़न कै और अंधरन कै बुला; ");
INSERT INTO thr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","और तैं खुसनसीब हुई जागो, काहैकि उनके पास तोकै बदले मैं देन कै कछु ना है, जो दिन धर्मी लोग जी उठंगे होन लगंगे, परमेस्वर तुमकै बापस प्रतिफल देगो।” ");
INSERT INTO thr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","जब मेज मैं बैठे भै हितुअन मैं से एक जौ सुनी, तौ बौ ईसु से कही, “बे कितने खुसनसीब हैं, जो परमेस्वर के राज्य मैं खानु खान बैठंगे!” ");
INSERT INTO thr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ईसु बासे कही, “एक बार एक आदमी रहै जो एक बड़ो हटकना करी रहै, जोमैं बौ भौत जनी कै हटकि रहै। ");
INSERT INTO thr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जब खानु तैयार ही गौ, तौ बौ अपने सेवक के हात जौ बतान के ताहीं पनारी, ‘कि आबौ; सब कछु तैयार है!’ ");
INSERT INTO thr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","लेकिन बे सबके सब माफी माँगन लगे, पहलो नौकर कही, ‘मैं एक खेत मोल लौ हौं, और जरूरी है कि बाकै देखौं; मैं तोसे पूछथौं, मोकै माफ कर दे।’ ");
INSERT INTO thr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दुसरो कही, ‘मैं पाँच जोड़ी बरधा मोल लौ हौं, और उनकै समझन और परखन जाएरौ हौं; मैं तोसे पूछथौं, मोकै माफ कर दे।’ ");
INSERT INTO thr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","और एक दुसरो कही, ‘मैं कतई-अभई बिहा करो हौं, और जौ बजे से मैं ना आए सकथौं।’ ");
INSERT INTO thr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","बौ सेवक आयकै अपने प्रभु कै जे बात सुनान लगो। तौ घर को प्रभु गुस्सा मैं आयकै अपने सेवक से कही, ‘नगर के बजारन और गलियन मैं तुरंतै जाएकै कंगालन, टुन्डन, लंगड़न और अंधरन कै हिंयाँ लै आबौ।’ ");
INSERT INTO thr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","सेवक फिर कही, ‘अरे प्रभु, जैसो तू कहो रहे, बैसिये कहो गौ है; फिर भी जघा है।’ ");
INSERT INTO thr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","प्रभु सेवक से कही, ‘सड़कन मैं और बेहड़ा के घाँईं जाएकै लोगन कै बरबस लइये आ ताकी मेरो घर भर जाबै। ");
INSERT INTO thr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","काहैकि मैं तुमसे कहथौं, कि बे आमन्तिरित लोगन मैं से कोईये मेरे भोज कै न चखैगो!’” ");
INSERT INTO thr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","और बड़ी भीड़ बाके संग जात रहे, तौ बौ पच्छू घूमकै उनसे कही। ");
INSERT INTO thr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“अगर कोई मेरे झोने आबै, और मोकै अपने अईय्या-दऊवा, घरबारी, बालकन, भईय्या-बहेनिया और अपने ज्यान से भी जाधे प्यारो नाय मानै, तौ बौ मेरो चेला नाय ही सकथै; ");
INSERT INTO thr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","और जो कोई अपनो क्रूस नाय उठाबै; और मेरे पच्छू नाय आबै; तौ बहो मेरो चेला नाय ही सकथै। ");
INSERT INTO thr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","तुम मैं से कौन है कि गुम्मट बनानो चहात होबै, और अग्गु बैठकै खर्च नाय जोड़ै, कि पूरो करन कि हिम्मत मेरे झोने है कि नाय? ");
INSERT INTO thr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","कहीं ऐसो ना होबै, कि नीव चट्टान के ऊपर डारकै तैयार नाय कर सकै, तौ सब देखन बारे जो भौ है बाको मजाक बनांगे। ");
INSERT INTO thr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","बे कहमंगे, ‘जौ आदमी बनान तौ लगो, लेकिन बनाये ना पाई।’ ");
INSERT INTO thr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","या कौन ऐसो राजा है, कि दुसरे से युद्ध करन कै जात होबै, और अग्गु बैठकै बिचार नाय कर लेबै कि जो बीस हजार आदमी लैकै मेरे घाँईं चढ़ो आथै, का मैं दस हजार आदमी लैकै बाको सामना कर सकथौं, कि नाय? ");
INSERT INTO thr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","नाय तौ बाके दूर रहतै खिना कि, बौ खबरेया कै भेजकै सांति से भेंटा करनो चाहबैगो। ");
INSERT INTO thr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","जहे रीति से तुम मैं से जो कोई अपनो सब कछु त्याग नाय देबै, तौ बौ मेरो चेला नाय ही सकथै।” ");
INSERT INTO thr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“नून तौ अच्छो है, पर अगर नून को नुनियानपन खतम हुई जाबै, तौ बौ का चीज से नुनियान करो जाबैगो। ");
INSERT INTO thr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","बौ नाय तौ जमीन के और न खाद के काम मैं आथै: बाकै लोग दुआरे फेंक देथैं। जोके सुनन के कान हैं सुन लेबै।” ");
INSERT INTO thr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","एक दिन कई लगान लेन बारे और पापी बाके झोने आए करत रहैं ताकी ईसु की सुनैं। ");
INSERT INTO thr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","फरीसी और यहूदि नियम के सिक्छक बड़-बड़ान, “जौ तौ पापिन से मिलथै और उनके संग खात भी है।” ");
INSERT INTO thr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तौ बौ उनसे जौ कहानी कही: ");
INSERT INTO thr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“तुम मैं से कौन है जोकी सौ भेंड़ होमैं, और एक हराए जाबै तौ निन्यानवे कै मैदान मैं छोड़कै, बौ हराई भइ कै जब तक मिल नाय जाबै ढूँड़त रहबै? ");
INSERT INTO thr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","और जब मिल जाथै, तौ बड़ा खुस हीकै बाकै कंधा मैं उठाए लेथै। ");
INSERT INTO thr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","और घरै आयकै दोस्त और परोसियन कै इखट्टो करकै कहथै, ‘मेरे संग खुसी मनाबौ, काहैकि मेरी हराई भइ भेंड़ मिल गई है!’ ");
INSERT INTO thr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मैं तुमसे कहथौं; जहे रीति से एक मन फिरान बारे पापी के बारे मैं भी स्वर्ग मैं इतनी ही खुसी होगी, जितनो की निन्यानवे ऐसे धर्मी के बारे मैं नाय होथै, जिनकै मन बदलन की जरूरत नाय।” ");
INSERT INTO thr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“या मान लेबौ कि एक घर की एक ऐसी बईय्यर होगी, जोके झोने दस चाँदी के सिक्का होमैं, और उनमैं से एक हराए जाबै; तौ बौ दिया जलाए कै और झाड़ बुड़ार कै जब तक मिल नाय जाबै, मन लगाएकै ढूँड़त नाय रहबै? ");
INSERT INTO thr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","और जब मिल जाथै, तौ बौ अपने दोस्त और परोसियन कै इखट्टो करकै कहथै, कि ‘मेरे संग खुसी मनाबौ, काहैकि मेरो हराओ भौ चाँदी को सिक्का मिलगौ है।’ ");
INSERT INTO thr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","जहे रीति से मैं तुमसे कहथौं, कि एक मन बदलन बारे पापी के बजह से परमेस्वर के दूत खुस होथैं।” ");
INSERT INTO thr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ईसु अग्गु कही, “एक आदमी रहै जोके दुई बेटा रहैं। ");
INSERT INTO thr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","उनमैं से छोटो बारो दऊवा से कही ‘हे दऊवा, दौलत मैं से जो हिस्सा मेरो होबै, बौ मोकै दैदे।’ इसलै बौ आदमी अपनी सम्पत्ति कै अपने दुई बेटा के बीच मैं बाँट दई। ");
INSERT INTO thr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","और जाधा दिन नाय बीते रहैं कि छोटो बेटा सब कछु इखट्टो करकै एक दुसरे देस कै चलो गौ और हुँआँ कुकर्म की जिंदगी मैं अपनी पूरी सम्पत्ति उड़ाए दई। ");
INSERT INTO thr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जब बौ सब कछु खर्च कर चुको, तौ बौ देस मैं बड़ा आकाल पड़ो, और बौ कंगाल ही गौ। ");
INSERT INTO thr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","और बौ बौ देस के रहन बारेन के हुँआँ गौ, बौ बाकै अपने खेतन मैं सोरा चुगान कै भेजी। ");
INSERT INTO thr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","और बौ चहात रहै, कि बे फलियन मैं जिनकै सोरा खात रहैं अपनो पेट भरै; काहैकि बाकै कोई कछु नाय देत रहे। ");
INSERT INTO thr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","आखरी मैं बाकै होस आओ और बौ कही, ‘मेरे दऊवा के कितने मजदूरन के पास जितनो बे खाए सकथैं बासे जाधे है, और हिंयाँ मैं भूंको मर रौ हौं। ");
INSERT INTO thr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मैं अब उठकै अपने दऊवा के झोने जामंगो और बासे कहमंगो, हे दऊवा, मैं स्वर्ग और तेरी नजर मैं पाप करो हौं। ");
INSERT INTO thr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","अब जौ लायक नाय रहो कि तेरो बेटा कहलामौ, मोकै अपने एक मजदूर के हानी रख ले।’” ");
INSERT INTO thr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","तौ बौ उठो और अपने दऊवा के झोने बापस चले गौ। “बौ अभै दूरै रहे, कि बाको दऊवा बाके ऊपर दया से भरकै दौड़ो बाकै लगे लगाई, और बड़ा जोड़ चूमी। ");
INSERT INTO thr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","बेटा बासे कही, ‘दऊवा, मैं स्वर्ग के बिरोध मैं और तेरी नजर मैं पाप करो हौ, और अब जौ लायक नाय रहो कि तेरो बेटा कहलामौ।’ ");
INSERT INTO thr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","लेकिन दऊवा अपने सेवकन से कही, ‘जल्दी से अच्छो से अच्छो चोंगा निकारकै जाकै पहनाबौ, बाके हाथ मैं अंगूठी, और पाओं मैं जूती पहनाबौ। ");
INSERT INTO thr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","तौ जाएकै इनाम को बछड़ा ले आबौ और बाकै मार डारौ, और हम एक दावत के संग मनामैं! ");
INSERT INTO thr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","काहैकि मेरो जौ बेटा मर गौ रहै, फिर जिंदो ही गौ है: जौ हराए गौ रहै, अब मिलगौ है।’ और ऐसे करकै दावत सुरु भइ।” ");
INSERT INTO thr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“इतने मैं बाको जेठो लौड़ा खेत मैं रहे। और जब बौ आत भै घर के झोने पहोंचो, तौ बौ गान-बजान और नाचन की अबाज सुनी। ");
INSERT INTO thr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","तौ बौ एक सेवक कै बुलबाए कै पूँछीं, ‘कि जौ का ही रहो है?’ ");
INSERT INTO thr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","नौकर जबाब दई, ‘तेरो भईय्या घरै बापस आए गौ है,’ और ‘तेरो दऊवा इनामी बछड़ा कै मार डारी है, काहैकि बौ बाकै सुरक्छित और स्वस्थ पाई है।’ ");
INSERT INTO thr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","बौ बड़ा गुस्सा से भरगौ और घर के भीतर नाय जानो चाही: पर बाको दऊवा दुआरे आयकै बासे नहोरे करी, की बौ भीतर आबै। ");
INSERT INTO thr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","पर बौ दऊवा कै जबाब दई, ‘देख; मैं इतने साल से तेरी सेवा कर रहो हौं, और कभी भी तेरो आग्या नाय टालो, फिर तू मोकै आज तक एक बकरिया को बच्चा तक नाय दौ, कि मैं अपने दोस्तनौ के संग खुसी मनामौ! ");
INSERT INTO thr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पर जब जौ तेरो बेटा, जो वैसियन मैं अपनी सम्पत्ति उड़ाए दई है, आओ, तौ बाके ताहीं बछड़ा मारकै बड़ो भोज बनबाओ!’ ");
INSERT INTO thr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","दऊवा बासे कही, ‘बेटा, तू हमेसा मेरे संग है; और जो कछु मेरो है बौ सब तेरो ही है। ");
INSERT INTO thr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पर अब खुसी मनानो और खुस रहनो चाहिए काहैकि जौ तेरो भईय्या मर गौ रहे फिर जिंदी हुई गौ है; हराए गौ रहे, अब मिलगौ है।’” ");
INSERT INTO thr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ईसु अपने चेलन से कही, “एक सेठ आदमी के झोने एक नौकर रहै जो बाकी जायदाद को प्रबन्ध करत रहै। सेठ आदमी कै कोई के जरिया बताओ गौ रहै कि भंडारी अपने मालिक को पैसा उड़ाथै, ");
INSERT INTO thr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","तभईये बौ बाकै भीतर बुलाएकै कहथै, ‘जौ मैं तेरे बारे मैं का सुन रहों हौं? मेरी जायदाद को हिसाब दे, काहैकि अब तू मेरो भंडारी नाय रह सकथै।’ ");
INSERT INTO thr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","भंडारी सोचन लगो, ‘मेरो मालिक मोकै काम से निकार देगो। अब मैं का करौं? मेरे भीतर इतनी ताकत भी ना है कि मट्टी खोद सकौं, और मोकै तौ भीख माँगन मैं भी सरम आथै। ");
INSERT INTO thr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","अब मोकै मालुम है कि मोए का करने है! ताकी जब मैं भंडारी के काम से निकारो जामौं, तौ मेरे ऐसे दोस्त होंगे जो मेरे घर मैं मेरो स्वागत करंगे।’ ");
INSERT INTO thr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","तभई बौ बे सबै लोगन कै बुलबाई जो अपने प्रभु के कर्जा मैं रहैं। बौ पहलो से पूँछी, ‘मेरे मालिक के झोने कित्तो बकाया है?’ ");
INSERT INTO thr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","बौ जबाब दई, ‘सौ मन जैतून को तेल,’ तौ प्रबंधक बासे कही, ‘बैठ और अपनो खाता-बहे ले और बामै पचास लिख।’ ");
INSERT INTO thr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","फिरौंकी बौ एक और से पूँछी, ‘और तेरो कित्तो बकाया है?’ बौ जबाब दई, ‘एक हजार बोरी गेंहूँ,’ तौ प्रबंधक बासे कही, ‘अपनो खाता-बहे मैं आठ सौ लिख।’ ");
INSERT INTO thr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","मालिक बौ दुस्ट अधर्मी भंडारी की चतुराई भरी बात सुनकै बाकी बड़ाँईं करी; काहैकि जौ युग के लोग जोती से जुड़ी लोगन की तुलना मैं भौत चालाँक हैं।” ");
INSERT INTO thr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","और ईसु उनसे कही, अधर्मी की कमाई दौलत से अपने ताहीं दोस्त बनाबौ, ताकी जब जे दुआरे निकरैं तौ तुमरो अनंत घर मैं तुमरो स्वागत करो जागो। ");
INSERT INTO thr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","जो छोटी बातन मैं बिस्वास योग्य है, बौ बड़ी बातन मैं भी भरोसेमंद रहगो; जो छोटे-छोटे मामलेन मैं अधर्मी है, बौ बड़े मामलेन मैं अधर्मी होगो। ");
INSERT INTO thr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","अगर, तुम अधर्मी की दौलत कै संभालन मैं भरोसेमंद नाय हौ, तौ तुमरे ऊपर सच्ची दौलत मैं कैसे भरोसो करो जाबै? ");
INSERT INTO thr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","और अगर तुम पराए की दौलत मैं भरोसेमंद नाय हौ, तौ जो तुमरो है बौ तुम्हैं कौन देगो? ");
INSERT INTO thr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कोई भी सेवक दुई प्रभु को सेवक नाय हुई सकथै; काहैकि बौ एक से नफरत दुसरे से प्यार करैगो या मिलो रैहगो और दुसरे से नफरत करैगो। तुम परमेस्वर और दौलत दोनों की सेवा नाय कर सकथौ।” ");
INSERT INTO thr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरीसी जब जे सब बात सुनी, तौ बे ईसु मसीह ऊपर उल्झ पड़े, काहैकि उन्हैं पैसा से भौत प्यार रहै। ");
INSERT INTO thr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ईसु उनसे कहथै, तुम बे हौ जो खुदकै दुसरे लोगन की नजर मैं सई ठहराथौ, लेकिन परमेस्वर तुमरे नफरत भरे मन कै जानथै। और चीज परमेस्वर की नजर मैं खास है, बौ चीज परमेस्वर की नजर मैं कुछ न है। ");
INSERT INTO thr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“मूसा के नियम और भविस्यवक्ता के लेख बपतिस्मा देनबारे यूहन्ना के समय ले सरदार रहैं; और तभई से परमेस्वर के राज्य को सुसमाचार सुनाए जाए रहो है, और हर कोई अपने ढंग सेई रहा बनाथै।” ");
INSERT INTO thr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","लेकिन नियम के छोटे से छोटे विवरड़ कै खतम करन की तुलना मैं स्वर्ग और धरती को गायब होनो आसान है। ");
INSERT INTO thr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“जो आदमी अपनी बईय्यर कै तलाक दैकै दुसरी बईय्यर से बिहा करै, बौ व्यभिचार करथै; और जो कोई तलाकसुदा बईय्यर से बिहा करथै बौ भी छिनरइ करथै।” ");
INSERT INTO thr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“एक बार एक सेठ आदमी रहै जो बैंजनी लत्ता पहनतो और हर-रोज भौत ठाट से रहतो। ");
INSERT INTO thr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","और हुँआँ लाजर नाओं को भी एक कंगाल आदमी रहै, जो घाव से ढको रहै, और सेठ आदमी की डेहरी मैं लायकै छोड़ दौ जातो ");
INSERT INTO thr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","और बौ सेठ आदमी के मेज से गिरे जूठो से पेट भरन की आस मैं रहतो। और हिंयाँ तक कि बाके घाव कै कुत्ता चाटत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","एक दिन ऐसो भौ कंगाल आदमी मर जाथै और स्वर्गदूतन के जरिया स्वर्ग मैं अब्राहम के झोने लै जाओ जाथै। और एक दिन सेठ आदमी भी मर जाथै और बाकै गाड़ो गौ, ");
INSERT INTO thr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","और बौ नरक मैं, खुदकै बौ भौत दर्द मैं पाथै, जब बौ ऊपर कै देखथै तौ लाजर कै अब्राहम के संग बैठो देखी। ");
INSERT INTO thr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","तभई बौ चिल्लाए कै कहथै, ‘दऊवा अब्राहम! मेरे ऊपर दया कर, और लाजर कै मेरे झोने पनार दे, ताकी बौ अपनी उँगरिया के पोरा पानी मैं डुबो कै मेरी जीभ कै सांत करै, काहैकि मैं जो आगी मैं दर्द से मरो जाए रहो हौं!’ ");
INSERT INTO thr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","लेकिन अब्राहम कहथै, ‘याद कर, मेरे लौड़ा, तोकै जिंदगी मैं जे सब अच्छी चीज मिल चुकी रहैं, और लाजर कै खराब। लेकिन अब बौ हिंयाँ सांति मैं है, और तैं दर्द मैं है। ");
INSERT INTO thr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","जे सब बातन कै छोड़, हमरे बीच एक बड़ी गहरी खईया बनी है, ताकी जो लोग तुमरे झोने जानो चाँहे बे नाय जा सकैं, और न हूँना से जौ पार मेरे झोने आए सकथै।’ ");
INSERT INTO thr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","तभई सेठ आदमी कहथै, ‘मैं तोसे नहोरे करथौं, दऊवा अब्राहम, मेरे दऊवा के घरै लाजर कै पनार दे, ");
INSERT INTO thr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","हूँना मेरे पाँच भईय्या हैं। उनके अग्गु जे सब बात की चितौनी दैकै बाकै पनार दे, ताकी बे जौ दर्द भरी जघा मैं न आमै।’ ");
INSERT INTO thr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहम कहथै, ‘तेरे भईय्यन के झोने चितौनी देन ताहीं मूसा और भविस्यवक्ता के कानून हैं; तुमरे भईय्यन कै उनकी बात सुननो चाहिए कि बे का कहथैं।’ ");
INSERT INTO thr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","तौ सेठ आदमी जबाब देथै, ‘जौ काफी नाय है, दऊवा अब्राहम! लेकिन अगर कोई मौत से उठकै उनके झोने जाबै, तौ बे अपने पापन से मन बदलथै।’ ");
INSERT INTO thr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","अब्राहम कहथै, ‘जब बे मूसा और भविस्यवक्ता की बात नाय सुनंगे, तौ मौत से जिंदो होन की बात कैसे मानंगे।’” ");
INSERT INTO thr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ईसु अपने चेलन से कही, “जो बातन से लोग पाप मैं पड़ जाथैं, बौ जरूरै होथैं, लेकिन जो उनकै करथै बाके ताहीं का भयानक है! ईसु अपने चेलन से कही: जिन बातन के कारड़ लोग ठोकर खाथैं, बे जरूरै आथैं, लेकिन जोके जरिया बे आथैं बाके ऊपर हाय। एक दिन ईसु अपने चेलन से कही, पाप के ताहीं परिक्छा हमेसा होत रहमंगी, लेकिन परिक्छा करन बारे कै का दुख होगो! ");
INSERT INTO thr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जो जे छोटेन मैं से कोई एक कै ठोकर खबाथै, बाके ताहीं जौ भलो होतो कि चक्की को हिस्सा बाके गले मैं लटकाओ जातो, और बाकै समुंदर मैं डार दौ जातो।” ");
INSERT INTO thr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","तौ तुम का करैगे! “अगर तुमरो भईय्या पाप करथै, तौ बाकै झुकाए, और अगर बौ मन बदलथै तौ बाकै माफ कर दे। ");
INSERT INTO thr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","अगर बौ दिन भर मैं सात बार तेरे खिलाप पाप करै, और हर बार तेरे झोने आयकै कहबै, ‘मैं मन बदल लौ हौं,’ तौ तू बाकै माफ कर दे।” ");
INSERT INTO thr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","प्रेरित प्रभु से कहथैं, “हमरे बिस्वास कै बड़ा।” ");
INSERT INTO thr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","तौ प्रभु जबाब देथै, “अगर तुम्हैं राया के गूदा के बराबर बिस्वास है, तौ तुम जौ सहतूत के पेंड़ से कहबौ, ‘कि जर से उखड़कै समुंदर मैं लग जाबै!’ तौ बौ तुमरी बात मान लेगो।” ");
INSERT INTO thr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“मान लियो कि तुम मैं से एक झोने एक सेवक है जो खेत की जुताई या भेंड़न की देख-रेख करथै। जब बौ खेत से आथै, तौ का तुरंतै तुम बासे जौ कहथौ आबौ खानु खान कै बैठौ? ");
INSERT INTO thr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","कतई नाय! जाके उल्टा, तुम जौ कहगे, ‘रात की सेवा के काम के ताहीं तैयारी करौ, और मेरे खान-पीन के पोती मेरो इंतजार करौ; जाके बाद तुम खाए सकथौ।’ ");
INSERT INTO thr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","का सेवक आग्या कै मानन के ताहीं धन्यवाद को हकदार है? ");
INSERT INTO thr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","तुमरे संग भी ऐसोई होतो, जब तुम बे सब कामन कै कर रहै हौ जोकी आग्या तुमकै दई गई रहै, तौ कहबौ, ‘हम निकम्मे सेवक हैं; कि जो हमैं करनो चाहिए रहै बौ करे हैं।’” ");
INSERT INTO thr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","जब ईसु यरूसलेम के घाँईं जानो सुरू करी, तौ बौ सामरिया और गलील की सीमा के किनारे चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","और जब बौ हुँआँ के गाँव से निकरो जात रहै तौ बाको भेंटा दस कोहढ़ी आदमी से भइ। बे थोड़ी दूरी मैं ठाड़े रहैं ");
INSERT INTO thr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","और हूँनै से चिल्लाईं, “ईसु! गुरुजी! हमरे ऊपर दया कर!” ");
INSERT INTO thr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ईसु उनकै देखकै उनसे कही, “जाबौ और पुजारी कै अपने आपकै दिखाबौ।” और बे नेंगत-नेंगत कोढ़ से सुद्ध होत चले गै। ");
INSERT INTO thr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तभई उनमैं से एक खुदकै देखी कि बौ अच्छो ही गौ है, तौ बौ ऊँची अबाज मैं परमेस्वर की बड़ाँईं करत भै लौटकै आओ। ");
INSERT INTO thr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","और बौ ईसु के पाओं मैं घुपटियाय कै बाको धन्यवाद करी। और बौ एक सामरी आदमी रहै। ");
INSERT INTO thr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ईसु बासे कही, “दस आदमी जो सुद्ध भै रहैं; बाकी नौ कितै गै? ");
INSERT INTO thr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","जौ परदेसी कै छोड़ और कोई नाय है जो परमेस्वर कै धन्यवाद और महिमा देन के ताहीं आओ है?” ");
INSERT INTO thr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","और ईसु बासे कहथै, “उठ और जा; तोकै तेरो ही बिस्वास अच्छो करी है।” ");
INSERT INTO thr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","कुछ फरीसी ईसु से पूँछी कि परमेस्वर को राज्य कब आगो। तौ बाको जबाब रहै, “परमेस्वर को राज्य जौ हानी नाय आगो जैसो तुम देख रहे हौ। ");
INSERT INTO thr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","जौ कोई नाय कहेगो, ‘देखौ, हिंयाँ है!’ या ‘हुँआँ है!’ काहैकि परमेस्वर को राज्य तुमरे बीच मैं है।” ");
INSERT INTO thr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","फिर बौ चेलन से कही, “बौ समय आगो तभई तुम चाहगे कि इंसान के लौड़ा कै एक दिन देख सकैं, लेकिन तुम बाकै नाय देख पागे। ");
INSERT INTO thr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","बेईं होंगे जो तुमसे कहंगे, ‘देखौ, हिंयाँ है! या हुँआँ है!’ लेकिन तुम उनके पच्छू मत जईयो।” ");
INSERT INTO thr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","जैसे आसमान मैं बिजली चमकत है और एक छोर दुसरे छोर उजियारो होथै, बैसिये इंसान को लौड़ा अपने दिनन मैं दिखाई देगो। ");
INSERT INTO thr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","लेकिन बाके ताहीं जौ जरूरी है, कि बौ भौत दुख उठागो, और जौ दिन के लोग बाकै ठुकरामंगे। ");
INSERT INTO thr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जैसो नूह के समय मैं भौ रहै, बैसोई इंसान के लौड़ा के दिनन मैं भी होगो। ");
INSERT INTO thr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जो दिन ले नूह जहाज मैं नाय चढ़ो, बौ दिन ले लोग खात-पीत रहैं, और उनमैं बिहा होत रहैं; तभई जल-प्रलय आयकै बे सबन कै नास कर दई। ");
INSERT INTO thr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","और जैसो लूत के दिनन मैं भौ रहै, कि लोग खाते-पीते, खरीदते-बेंचते, काम करते और घर बनाते। ");
INSERT INTO thr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","लेकिन जो दिन लूत सदोम देस से निकरो, बौ दिन आगी और गंधक आसमान से बरसी और सबकै नास कर दई। ");
INSERT INTO thr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","इंसान के लौड़ा के आन के दिनन मैं ऐसेई होगो। ");
INSERT INTO thr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“बौ दिन जो कोई छत मैं होबै और बाको हानी घर के भीतर होबै, बौ बाकै लेन ताहीं तरे नाय उतरै, और बैसिये जो खेत मैं होमैं बे घरै ना लौटैं। ");
INSERT INTO thr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लूत की बईय्यर कै याद करौ! ");
INSERT INTO thr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जो कोई अपनी ज्यान बचानो चाहगो बौ बाकै खोबैगो; लेकिन जो कोई जिंदगी खोबैगो बौ बाकै बचागो। ");
INSERT INTO thr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मैं तुमसे कहथौं, बौ रात दुई लोग एक खटिया मैं सोत होंगे, एक कै लै लौ जागो, और दुसरे कै छोड़ दौ जागो। ");
INSERT INTO thr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दुई बईय्यर एक संग चक्की पीसत होंगी, एक कै उठाए लै जागी, और दुसरी कै हूँनै छोड़ दई जागी। ");
INSERT INTO thr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दुई आदमी खेत मैं होंगे एक कै उठाए लौ जागो और दुसरे कै छोड़ दौ जागो।” ");
INSERT INTO thr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","जौ सुनकै चेला बासे पूँछी, “कितै, प्रभु?” ईसु उनकै जबाब दई, “जितै सरीर होगी, हूँनै गिद्धा जुरांगे।” ");
INSERT INTO thr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","तौ ईसु अपने चेलन कै जौ सिखान के ताहीं एक कहानी बताई कि उनकै हमेसा प्रार्थना करनो चाहिए और कहु निरास ना होनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“कोई सहर मैं एक न्याई रहत रहै बौ ना परमेस्वर से डरात रहै, और नाय कोई आदमिन को आदर करतो। ");
INSERT INTO thr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","और कोई सहर मैं एक बिधवा बईय्यर भी रहत रहै, जो बाके झोने आयकै कहती मेरो न्याय करकै, ‘मोए दलालन से बचा!’ ");
INSERT INTO thr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","कुछ समय ले तौ बौ नाय मानो लेकिन आखरी मैं मन मैं सोच बिचार करकै कही, ‘ना मैं तौ परमेस्वर से डराथौं और ना लोगन को आदर करथौं, ");
INSERT INTO thr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","फिर भी जौ बईय्यर मोए सतात रहथै, तभई मैं जाको न्याय करंगो, कहीं ऐसो नाय होबै कि घड़ी-घड़ी आयकै मोए परेसान कर देबै!’” ");
INSERT INTO thr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","तौ प्रभु कही, “सुनौ बौ अधर्मी न्याई का कही। ");
INSERT INTO thr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","का परमेस्वर अपने चुने भै को न्याय करैगो, जो दिन-रात गिड़-गिड़ात रहथैं, और का बौ उनके बारे मैं देर करैगो? ");
INSERT INTO thr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","मैं तुमसे कहथौं, बौ तुरंतै उनको न्याय करैगो। लेकिन इंसान को लौड़ा जब आगो तौ का बौ धरती मैं बिस्वास पाएगो?” ");
INSERT INTO thr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","और बौ उनसे जो अपने ऊपर भरोसा रखत रहैं, कि हम धर्मी हैं, और दुसरेन कै तुच्छ जानत रहैं, जौ कहानी कही: ");
INSERT INTO thr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","एक बार “दुई आदमी मंदिर मैं प्रार्थना करन कै गै, एक फरीसी रहै और दुसरो लगान लेन बारो। ");
INSERT INTO thr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी अपने आप से अलग ठाड़गौ और प्रार्थना करी, ‘मैं तोए धन्यवाद देथौं, परमेस्वर, कि मैं लालची, अधर्मी या व्यभिचारी नाय हौं, जैसो कि सबै कोई करी है। मैं तोए धन्यवाद देथौं कि मैं हूँना बौ लगान लेन बारे के तराहनी नाय हौं। ");
INSERT INTO thr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मैं सप्ताह मैं दुई बार बर्त रखथौं, और मैं अपनी कमाई को दसमों भाग भी देथौं।’ ");
INSERT INTO thr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","लेकिन लगान लेन बारो दूरै से ठाड़कै, स्वर्ग के घाँईं अपनी सकल भी नाय करी, बल्किन अपनी छाती पीट-पीटकै कहथै, ‘परमेस्वर मैं तौ पापी हौं मेरे ऊपर दया कर!’” ");
INSERT INTO thr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ईसु कही, मैं तुमसे कहथौं, “कर लेन बारो आदमी ना कि फरीसी परमेस्वर के हिंयाँ जागो। काहैकि जो कोई खुदकै बड़ो बनागो बौ छोटो करो जागो, और जो खुदकै छोटो बनागो बौ बड़ो करो जागो।” ");
INSERT INTO thr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","तौ लोग अपने बालकन कै ईसु के झोने लान लगे कि बौ उनके ऊपर हात धरै। तौ चेला उन्हैं देखकै झुकाईं, ");
INSERT INTO thr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","लेकिन ईसु बालकन कै झोने मस्काए कै कहथै, “बालकन कै मेरे झोने आन दियौ, और उन्हैं मना मत करौ, काहैकि परमेस्वर को राज्य ऐसियन को है। ");
INSERT INTO thr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मैं तुमसे सच्ची मैं कहथौं, कोई भी परमेस्वर को राज्य जे बालकन के हानी नाय अपनागो बौ स्वर्ग के राज्य मैं कहुए घुस नाय पागो।” ");
INSERT INTO thr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","एक यहूदिन को अधिकारी ईसु से पूँछथै, “अच्छो गुरुजी, अनंत जिंदगी पान के ताहीं मैं का करौं?” ");
INSERT INTO thr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ईसु बासे कहथै, “तू मोए अच्छो काहे कहथै? कोई अच्छो नाय है, परमेस्वर के अलावा। ");
INSERT INTO thr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तू कानून और आग्या कै तौ जानतै है, ‘व्यभिचार मत करीये; हत्या मत करीये, चोरी मत करीये, और अपने अईय्या-बाबा को आदर करीये।’” ");
INSERT INTO thr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","बौ आदमी जबाब दई, “मैं तौ जे सब आग्या छोटे से मानत आओ हौं।” ");
INSERT INTO thr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","जौ सुनकै ईसु, बासे कहथै, तेरे भीतर अभै भी एक कमी की बात है, “तू अपनो सबै कुछ बेंच कै गरीबन मैं बाँट दे, और तोए स्वर्ग मैं धन मिल जागो, और आयकै मेरे पच्छू हुई ले।” ");
INSERT INTO thr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","लेकिन जौ सुनकै बौ आदमी को मन दुखी हुई गौ, काहैकि बौ आदमी भौत सेठ रहै। ");
INSERT INTO thr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ईसु बाकै दुखी देखकै कही, “सेठ और पैसा बारे आदमी को परमेस्वर के राज्य मैं जानो कठिन है! ");
INSERT INTO thr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","एक ऊँट को सुईं के भार मैं से निकर जानो सहज है लेकिन एक सेठ आदमी को परमेस्वर के राज्य मैं जानो भौत कठिन है।” ");
INSERT INTO thr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","उनकै सुनन बारे लोग बासे पूँछथैं, “तौ फिर कौनकै बचाओ जाए सकथै?” ");
INSERT INTO thr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","जो चीज इंसान से नाय हुई सकथै बौ चीज परमेस्वर से हुई सकथै। ");
INSERT INTO thr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","तभई पतरस कहथै, “देख! हम तौ घर-बार छोड़कै तेरे पच्छू हुई लै हैं।” ");
INSERT INTO thr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ईसु उनसे कहथै, “हाँ, और मैं तुमसे सच्ची कहथौं, कि जो परमेस्वर के राज्य के ताहीं घर-बार, बईय्यर और अईय्या-दऊवा, भईय्या और बालकन कै परमेस्वर के राज्य के ताहीं छोड़ी हैं, ");
INSERT INTO thr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","बौ जहे समय मैं कई गुना आसीस पागो, और आनबारे समय के युग मैं अनंत जिंदगी।” ");
INSERT INTO thr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ईसु बारह चेलन कै बाजू मैं लै जाएकै कही, “सुनौ! आपन यरूसलेम कै जांगे, और जित्ती बात इंसान के लौड़ा के ताहीं भविस्यवक्ता के जरिया लिखी गईं हैं बे सबै सच्ची होंगी। ");
INSERT INTO thr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","बाकै गैर यहूदि कै सौंप दौ जागो, जो बाको मजाक उड़ांगे, बाकी बेजती करंगे और बाके ऊपर थूकंगे। ");
INSERT INTO thr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","बे बाकै कोड़ा मारंगे और बाकै मार डारंगे, लेकिन बौ तीन दिन बाद जिंदो हुई जागो।” ");
INSERT INTO thr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","लेकिन चेला जे बातन मैं से कछु नाय समझीं; सब्दन को मतलब उनसे लुको पड़ो रहै, और बे ना जानत रहैं कि ईसु काके बारे मैं बात करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जब ईसु यरीहो के झोने आए चुको रहै, तौ हुँआँ एक अंधरा आदमी रस्ता मैं बैठकै भीख मांगत रहै। ");
INSERT INTO thr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","जब बौ झोने से छिरत भइ भीड़ कै सुनी, तौ बौ पूँछी, “जौ का ही रौ है?” ");
INSERT INTO thr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","बे बाकै बताईं, “नासरत को ईसु झोने से छिर रौ है।” ");
INSERT INTO thr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","बौ पुकारी, “ईसु! दाऊद को लौड़ा! मेरे ऊपर दया कर!” ");
INSERT INTO thr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","अग्गु के लोग बाकै झुकाईं और सांत होन के ताहीं कहीं। लेकिन बौ औरौ जोड़न से चिल्लाई, “दाऊद को लौड़ा! मेरे ऊपर दया कर!” ");
INSERT INTO thr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","इसलै ईसु रुक गौ और बौ अंधरा आदमी कै अपने झोने लान को हुकम दई। जब बौ झोने आओ, तौ ईसु बासे पूँछी, ");
INSERT INTO thr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","तैं मोसे का चाहथै, “मैं तेरे ताहीं का कर सकथौ?” बौ जबाब दई, “प्रभु, मैं फिर से देखनो चाहथौं।” ");
INSERT INTO thr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ईसु बासे कही, “तौ देखन लग! तेरो बिस्वास तोकै अच्छो करी है।” ");
INSERT INTO thr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","बौ तुरंतै देखन लागो, और ईसु को अनुसरँड़ करी, और परमेस्वर कै धन्यवाद दई। जब भीड़ जाकै देखी, तौ बेऊँ सब परमेस्वर कि बड़ाँईं करीं। ");
INSERT INTO thr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ईसु यरीहो मैं घुसो और हुँआँ से छिरत रहै। ");
INSERT INTO thr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","हुँआँ एक मुख्य लगान को अधिकारी रहै, जोको नाओं जक्कई रहै, और बौ सेठ रहै। ");
INSERT INTO thr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","बौ जौ देखन कि कोसिस करत रहै कि ईसु कौन है, लेकिन बौ एक गंठो आदमी रहै और भीड़ कि बजह से ईसु कै नाय देख सकत रहै। ");
INSERT INTO thr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","इसलै बौ ईसु कै देखन के ताहीं अग्गु दौड़कै एक गूलर के पेंड़ मैं चढ़गौ, काहैकि ईसु बहे रस्ता से जान बारो रहै। ");
INSERT INTO thr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जब ईसु बौ जघा पौहोंचो, तौ ऊपर नजर करकै जक्कई से कही, “जल्दी उतर जक्कई, काहैकि मोकै आज तेरे घर मैं रहने होगो।” ");
INSERT INTO thr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","जक्कई तुरंत उतरो और बाको बड़ा खुसी से स्वागत करी। ");
INSERT INTO thr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","जाकै देखन बारे सब जनी बड़बड़ात भइ कहेन लागे, “जौ आदमी पापी के घरै हितुआ बनकै गौ है!” ");
INSERT INTO thr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जक्कई ठाड़कै प्रभु से कही, “सुन, गुरुजी! मैं अपनी आधी सम्पत्ति कंगालन कै दै दुंगो, और अगर मैं कोई कै धोका दैकै कछु लौ हौं, तौ बाकै चौगुना जाधे दुंगो।” ");
INSERT INTO thr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ईसु बासे कही, “आज जौ घर मैं उद्धार आओ है, इसलै कि जहो भी अब्राहम को लौड़ा है। ");
INSERT INTO thr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","काहैकि इंसान को लौड़ा खोए भैन कै ढूँड़न और उनकै बचान के ताहीं आओ रहै।” ");
INSERT INTO thr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जब लोग जौ सुनत रहैं, ईसु जारी रखी और उनकै एक कहानी बताई। बौ अब लमसम यरूसलेम मैं रहै, और बे मानत रहैं कि परमेस्वर को राज्य बस अब दिखन बारो है। ");
INSERT INTO thr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","तौ ईसु कही, “एक समय एक बड़े पद को आदमी दूर देस कै चलो ताकी राजा बनकै राज्य करन लौट आबै। ");
INSERT INTO thr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","बाके जान से पहले, बौ अपने सेवकन कै बुलाई और उनकै एक-एक सोने को सिक्का दई और उनसे कही, ‘देखथैं, मेरे जान के बाद तुम जासे का कमाए सकथौ।’ ");
INSERT INTO thr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","अब बाके अपने लोग बासे नफरत करत रहैं, और बाके पच्छू खबरेया के जरिये कहकै भेजीं, ‘कि हम नाय चाहथैं, कि जौ आदमी हमरो राजा बनै।’” ");
INSERT INTO thr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“जब बौ आदमी बापस राजा को राज्य पद लैकै आओ। तौ एक बार बौ अपने सेवकन कै बाके सामने हाजिर होन को हुकम दई, ताकी जौ पता लगाओ जा सकै कि बे कितनो कमाई रहैं। ");
INSERT INTO thr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","पहलो बारो आयकै कही, ‘प्रभु, तैं जो मोकै दौ रहै, बाके संग मैं दस सोने के सिक्का कमाओ हौं।’ ");
INSERT INTO thr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","बौ कही, ‘भौत बढ़िया, तैं एक अच्छो सेवक है! काहैकि तैं छोटे-मोटे मामलेन मैं बफादार और भरोसेमंद रहै, इसलै मैं तोकै दस सहरन के अधिकार को वारिस बनांगो।’ ");
INSERT INTO thr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दुसरो नौकर आओ और बोली, ‘प्रभु, तैं जो मोकै दौ रहै, बाके संग मैं पाँच सोने के सिक्का कमाओ हौं।’ ");
INSERT INTO thr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","जाके ताहीं बौ कही, ‘तैं पाँच सहरन को अधिकारी होगो।’ ");
INSERT INTO thr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तीसरो नौकर आयकै कही, ‘प्रभु, हिंयाँ तेरो सोने को सिक्का है; मैं बाकै एक रुमाल मैं लुकाएकै रखो रहौं। ");
INSERT INTO thr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","काहैकि मैं तोसे डरात रहौं, तैं एक कठोर इंसान है। तैं बौ लै लेथै जो तेरो ना है और जो तैं ना बोथै बाकै काटथै।’ ");
INSERT INTO thr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","बाको मालिक जबाब दई, ‘हे दुस्ट सेवक, मैं तेरिये बचनन से तेरो न्याय करंगो! तैं जानत रहै कि मैं एक सक्त आदमी हौं, जो मेरो ना है बाकै लै लेथौं और जोमैं ना बोथौं बाकै काट लेथौं। ");
INSERT INTO thr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","अच्छेया, फिर, तैं मेरे पैसा बैंक मैं काहेकै ना डारो? जब मैं लौटतो तौ मोकै ब्याज समेत बापस मिल जातो।’ ");
INSERT INTO thr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","फिर बौ बे लोगन से कही जो हुँआँ ठाड़े रहैं, ‘सोने को सिक्का बासे लै लेबौ, और बौ नौकर कै दै दियौ जोके पास दस सोने के सिक्का हैं।’ ");
INSERT INTO thr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","लेकिन बे बासे कहीं, ‘प्रभु, बाके पास पहलेई से दस सिक्का हैं!’ ");
INSERT INTO thr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘मैं तुमकै बताथौं,’ बौ जबाब दई, ‘बे सबन के ताहीं जिनके पास कछु है, उनकै औरौ अगरो दौ जागो; लेकिन जिनके पास कछुए ना है, हिंयाँ ले कि उनके पास जो कछु भी होगो, बहो उनसे छीन लौ जागो। ");
INSERT INTO thr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","अब, मेरे बे बैरी के ताहीं जो ना चहात रहैं कि मैं उनको राजा बनौ, उनकै हिंयाँ लाबौ और मेरे सामने मार देबौ!’” ");
INSERT INTO thr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ईसु के जौ सब कहेन के बाद, बौ उनके अग्गु-अग्गु यरूसलेम कै गौ। ");
INSERT INTO thr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","जब बौ जैतून नाओं कै पहाड़ मैं बैतफगे और बैतनिय्याह के झोने पौहोंचो, तौ बौ अपने चेलन मैं से दुई कै जौ कहकै पनारी ");
INSERT INTO thr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“सामने के गाँव मैं जाबौ, जैसेई तुम अंदर जाबैगे, तुम एक गधईया को बच्चा जोके ऊपर कोई कहु सवार ना भौ, भँदो भौ तुमकै मिलैगो, बाकै खोलकै लै आबौ। ");
INSERT INTO thr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","अगर कोई तुमसे पूँछै कि तुम जाकै काहे खोल रै हौ, तौ बासे कहियो कि प्रभु कै जाकी जरूरत है।” ");
INSERT INTO thr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","बे अपने रस्ता मैं चले गै और सब कछु बैसो पाईं जैसो ईसु उनकै बताई रहै। ");
INSERT INTO thr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जैसो कि बे गधा के बच्चा कै खोलत रहैं, तौ बाको प्रभु उनसे कही, “तुम जाकै काहेकै खोल रै हौ?” ");
INSERT INTO thr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","बे जबाब दईं, “प्रभु कै जाकी जरूरत है,” ");
INSERT INTO thr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","बे गधा के बच्चा कै ईसु के झोने लैगै और अपने लत्ता बौ बच्चा के ऊपर डारकै ईसु कै बाके ऊपर चढ़न मैं मदत करीं। ");
INSERT INTO thr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","जब बौ अग्गु बढ़ो, तौ लोग अपने लत्ता सड़क मैं बिछात जात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","जब बे यरूसलेम के झोने आए चुके, तौ जो जघा मैं सड़क जैतून पहाड़ के तरे चली गई रहै, जब बे हुँआँ पहुँचे, तौ चेलन कि बड़ा बड़ी भीड़ परमेस्वर को धन्यवाद करन लग्गै और बे सब महान सामर्थी काम के ताहीं जोड़न से स्तुति करीं, जो बे देखी रहैं: ");
INSERT INTO thr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“परमेस्वर बौ राजा कै आसीस देबै जो प्रभु के नाओं से आथै! स्वर्ग मैं सांति और परमेस्वर कि महिमा होबै!” ");
INSERT INTO thr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तौ भीड़ मैं से कुछ फरीसी ईसु से बात करीं। बे कहीं, “गुरुजी, अपने चेलन कै झुकाए, कि बे सांत रहमैं!” ");
INSERT INTO thr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ईसु जबाब दई, “मैं तुमसे कहथौं कि अगर बे चुप हुईगै, तौ पथरा खुदै चिल्लान लगंगे।” ");
INSERT INTO thr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ईसु सहर के झोने आओ, और जब बौ देखी, तौ बौ बाके ऊपर रोए पड़ो, ");
INSERT INTO thr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","जौ कहत भै, “अगर तुम सिरफ आजै जानते कि सांति के ताहीं का जरूरी है! लेकिन अब तुम जाकै नाय देख सकथौ! ");
INSERT INTO thr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","समय आगो जब तुमरे बैरी तुमकै घेर लेंगे, तुमरो नाकाबंदी करंगे, और सब घाँईं से तुम बंद हुई जागे। ");
INSERT INTO thr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","बे तुमकै और तुमरी दिवारन के भीतर के लोगन कै पूरी तरहन से खतम कर देंगे; एकौ पथरा ना होंगे जो बे अपनी जघा मैं छोड़ंगे, काहैकि तुम बौ समय कै नाय पहचान पाए जब परमेस्वर तुमकै बचान कै आओ रहै!” ");
INSERT INTO thr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","तौ ईसु मंदिर मैं गौ और ब्यापारियन कै भजान लगो, ");
INSERT INTO thr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","उनसे कहरौ है, “जौ सास्त्र मैं लिखो है कि परमेस्वर कही है, ‘मेरो मंदिर परमेस्वर के घर प्रार्थना को घर होगो।’ लेकिन तुम जाकै चुट्टन के ठिकाना मैं बदल दै हौ!” ");
INSERT INTO thr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","हर दिन ईसु मंदिर मैं सिक्छा देत रहै। बड़ो पुजारी, यहूदि नियम के सिक्छक और लोगन के नेता बाकै मारनो चहात रहैं, ");
INSERT INTO thr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","लेकिन उनकै ऐसो करन को कोई तरीका ना मिलो, काहैकि सब जनी बाकै सुने करत रहैं, और कोई भी बाकी बात कै छोड़नो ना चहात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक दिन जब ईसु मंदिर मैं लोगन कै सिखात रहै और सुसमाचार सुनात रहै, तौ बड़ो पुजारी और यहूदि नियम के सिक्छक, बड़े-बूढ़ेन के संग, आयकै ठाड़गै ");
INSERT INTO thr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","और बासे कहीं, “हमकै जौ बता, तोकै जे सब करन को का अधिकार है? तोकै जो अधिकार कौन दौ है?” ");
INSERT INTO thr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ईसु उनकै जबाब दई, “अब महुँ कै एक सवाल पूँछने है। मोकै बताबौ, ");
INSERT INTO thr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","का यूहन्ना कै बपतिस्मा देन को अधिकार स्वर्ग से रहै या इंसानन से रहै?” ");
INSERT INTO thr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","बे आपस मैं बहस करन लगे, “हम का कहंगे? अगर हम कहथैं, ‘कि स्वर्ग के घाँईं से,’ तौ बौ कहेगो, ‘तौ तुम यूहन्ना के ऊपर बिस्वास काहेकै ना करे?’ ");
INSERT INTO thr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","लेकिन अगर हम कहंगे, ‘इंसानन से,’ तौ हिंयाँ पूरी भीड़ हमकै पथरा मारेगी, काहैकि उनकै भरोसा है कि यूहन्ना एक भविस्यवक्ता रहै।” ");
INSERT INTO thr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","तौ बे जबाब दई, “हम ना जानथैं कि बौ कहाँ से आओ है।” ");
INSERT INTO thr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","और ईसु उनसे कही, “तौ मैं भी तुमकै ना बतांगो कि मैं जे काम कौन से अधिकार से करथौं।” ");
INSERT INTO thr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","तौ ईसु लोगन कै जौ कहानी बताई: “एक बार एक आदमी रहै जो अंगूर की बारी लगाई रहै, और किसानन कै दै दई, और फिर लंबे समय तक घर छोड़ दई। ");
INSERT INTO thr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","जब दाखन कै इखट्टो करन को समय आओ, तौ बौ किसानन के झोने एक सेवक कै पनारी, कि बे अंगूर की बारी मैं से मेरो थोड़ी हिस्सा देमैं, लेकिन किसान बाकै पीटीं और बाकै खाली हात बापस पनार दई। ");
INSERT INTO thr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","इसलै बौ एक और सेवक कै पनारी; लेकिन किसान बहो कै पीटीं, बाके संग सर्मनाक व्यवहार करीं, और बाकै खाली हात बापस पनार दईं। ");
INSERT INTO thr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","फिर बौ तीसरे नौकर कै पनारी; किसान बहो कै घायल कर दईं, और बाकै बाहर फेंक दईं। ");
INSERT INTO thr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तौ अंगूर की बारी को प्रभु कहीं, ‘मैं का करौं? मैं अपने प्रिय लौड़ा कै भेजंगो; बे पक्का बाको आदर करंगे!’ ");
INSERT INTO thr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","लेकिन जब किसान बाकै देखीं, तौ बे एक दूसरे से कहीं, ‘जौ मालिक को लौड़ा है। चलौ बाकै मार डारैं, और बाकी जायदाद हमारी हुई जागी!’” ");
INSERT INTO thr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","इसलै बे बाकै अंगूर की बारी से बाहर निकारकै मारडारीं। फिर ईसु पूँछी, “अंगूर की बारी को प्रभु बे किसानन के संग का करैगो?” ");
INSERT INTO thr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“बौ आयकै बे लोगन कै मार देगो, और अंगूर की बारी कै दुसरे किसानन कै सौंप देगो।” जब लोग जौ सुनीं, तौ बे कहीं, “सच मैं नाय!” ");
INSERT INTO thr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ईसु उनके घाँईं देखी और पूँछी, “का, तौ, जौ सास्त्र को मतलब है? ‘जो पथरा कै राजमिस्त्री ठुकराई रहैं बहे सबन के ताहीं सबसे जरूरी निकरो।’ ");
INSERT INTO thr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","जो कोई बौ पथरा मैं गिरैगो बौ चकनाचूर हुई जागो; और अगर बौ पथरा कोई के ऊपर गिरैगो, तौ बौ बाकै धूदर मैं कुचल देगो।” ");
INSERT INTO thr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","यहूदि नियम के सिक्छक और बड़ो पुजारी ईसु कै मौका मैं गिरफ्तार करन कि कोसिस करीं, काहैकि बे जानत रहैं कि बौ उनके खिलाप जौ कहानी बताई है; लेकिन बे लोगन से डरात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","इसलै बे मौका कि तलास करीं। बे कुछ लोगन कै धर्मी, इमानदार बनन को दिखावा करन के ताहीं रिस्वत दईं, और बे उनकै ईसु कै सवालन के संग फसान के ताहीं पनारीं, ताकी बे बाकै रोमन सासक के अधिकार से और सक्ति कै सौंप सकैं। ");
INSERT INTO thr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","जे जासूस ईसु से कहीं, “गुरुजी, हम जानथैं कि तैं जो कहथै और सिखाथै बौ ठीक है। हम जानथैं कि तैं कोई कि हालत मैं ध्यान ना देथै, लेकिन लोगन के परमेस्वर कि इच्छा के बारे मैं सच्चाई से सिखाथै। ");
INSERT INTO thr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","हमकै बता, का हमकै रोमन सम्राट कैसर कै लगान देनो नियम के हिसाब से बाके खिलाप है, या नाय?” ");
INSERT INTO thr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","लेकिन ईसु उनकी चाल कै देखी और उनसे कही, ");
INSERT INTO thr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“मोकै एक चाँदी को सिक्का दिखाबौ। जामैं कौन को छाप और नाओं है?” बे जबाब दई, “सम्राट कैसर को।” ");
INSERT INTO thr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","तौ ईसु कही, “ठीक है, सम्राट कैसर को भुगतान करैं जो सम्राट कैसर को है, और परमेस्वर को भुगतान करैं जो परमेस्वर को है।” ");
INSERT INTO thr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","हुँआँ बे लोगन के सामने बौ बात कै पकड़ ना पाईं, इसलै बाके जबाब से अचम्मे हुईकै चुप रहगै। ");
INSERT INTO thr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","फिर कुछ सदूकी, जो कहथैं, कि लोग मरकै नाय जी उठंगे, ईसु के झोने आयकै कहीं, ");
INSERT INTO thr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“गुरुजी, मूसा हमरे ताहीं जौ कानून लिखी है, ‘अगर कोई आदमी मर जाबै और अपनी बईय्यर कै छोड़ जाबै, लेकिन बाकी कोई औलाद ना होबै, तौ आदमी के भईय्या कै बौ बिधवा के संग बिहा कर लेनो चाहिए ताकी उनके बालका हुई सकैं जिनकै मरे भै आदमी के बालका मानो जागो।’ ");
INSERT INTO thr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","एक बार सात ददा-भईय्या रहैं; सबसे बड़े को बिहा हुई गौ और बिना बालका भै बाकी मौत हुई गई। ");
INSERT INTO thr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","फिर दुसरो बौ बईय्यर से बिहा करी, ");
INSERT INTO thr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","और फिर तीसरो। सबै सात ददा-भईय्यन के संग एकै बात भइ, बे बालका पैदा करे बिना मर गै। ");
INSERT INTO thr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","आखिरकार, बौ बईय्यर कि मौत हुई गई। ");
INSERT INTO thr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","अब, जो रोज मरे भै जिंदे जी उठंगे, तौ बौ कौन कि बईय्यर होगी, काहैकि बे सातौ बाके संग बिहा करी रहैं।” ");
INSERT INTO thr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ईसु उनकै जबाब दई, “जौ युग मैं आदमी और बईंय्यरैं बिहा करथैं, ");
INSERT INTO thr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","लेकिन बे आदमी और बईंय्यरैं जो मौत से जिंदे जी उठन और आनबारी जग के युग मैं जीन के काबिल हैं फिर उनमैं बिहा ना होगो। ");
INSERT INTO thr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","बे स्वर्गदूतन के हानी होंगे और मर नाय सकथैं। बे परमेस्वर के बालका है, काहैकि बे मौत से जी उठे हैं। ");
INSERT INTO thr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","और मूसा साफ तरीका से साबित करथै कि मरे भैन कै जी उठन ताहीं उठाओ जाथै। जलत भइ झाड़ी के बारे मैं रहामैं बौ प्रभु कै ‘अब्राहम को परमेस्वर, इसहाक को परमेस्वर, और याकूब को परमेस्वर कहथै।’ ");
INSERT INTO thr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","बौ जिंदो परमेस्वर है, मरे भै को नाय, काहैकि बाके ताहीं सब जिंदे हैं।” ");
INSERT INTO thr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","तौ जौ सुनकै कुछ यहूदि नियम के सिक्छक कहीं, “गुरुजी, तैं अच्छो जबाब दौ!” ");
INSERT INTO thr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","और उनकै बासे फिर कछु और पूँछन कि हिम्मत न भइ। ");
INSERT INTO thr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ईसु उनसे पूँछी, “जौ कैसे कहो जाए सकथै कि मसीह दाऊद को बंसज होगो? ");
INSERT INTO thr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","काहैकि दाऊद खुद भजन संहिता कि किताब मैं कहथै, ‘प्रभु मेरे प्रभु से कही: मेरे झोने दाँए घाँईं बैठ ");
INSERT INTO thr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","जब तक मैं तेरे बैरियन कै तेरे पाँव के तरे कि चौकी न कर देयौं।’ ");
INSERT INTO thr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाऊद तौ बाकै ‘प्रभु’ कहथै; तौ फिर, मसीहा दाऊद को बंसज कैसे हुई सकथै?” ");
INSERT INTO thr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","जैसो कि सब जनी ईसु की बात सुनत रहैं, तभई बौ अपने चेलन से कही, ");
INSERT INTO thr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“यहूदि नियम के सिक्छकन से सावधान रहबौ, जिनकै लम्बे-लम्बे चोंगा पहने भै फिरनो अच्छो लगथै, और जिनकै बजार मैं सम्मान के संग नमस्ते, और सभाघरन मैं अच्छी जघा और हटकना मैं अच्छी से अच्छी जघा प्रिय लगथै; ");
INSERT INTO thr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","जो बिधवन को फायदा उठाथैं और उनके घरन कै लूटथैं, फिर दिखान के ताहीं बड़ा देर ले प्रार्थना करथैं! उनको न्याय भौत खराब होगो!” ");
INSERT INTO thr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","फिर ईसु नजर उठाएकै देखी और सेठन कै अपनो-अपनो दान मंदिर के दान पेटी मैं डारत भइ देखी, ");
INSERT INTO thr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","और बौ एक गजब गरीब बिधवा कै भी दुई ताँबे के छोटे सिक्का कै डारत भै देखी। ");
INSERT INTO thr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","तौ बौ कही, “मैं तुमकै सच बताथौं कि जौ गरीब बिधवा सबन से अगरो डारी है। ");
INSERT INTO thr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","काहैकि बे दूसरे सब अपनी-अपनी सम्पत्ति मैं से दान मैं कुछ डारी हैं, लेकिन बौ गरीब है, और बौ सब कछु दै दई जोसे बाकै रहने रहै।” ");
INSERT INTO thr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","एकाद चेला मंदिर के बारे मैं बात करत रहैं, कि बौ सुगड़ पथरन और परमेस्वर कै चढ़ाय गै दान से कितनो सुगड़ लग रौ है। लेकिन ईसु उनकै कही, ");
INSERT INTO thr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“जौ सब जो तुम देखरै हौ, बौ समय आगो जब हिंयाँ एकौ पथरा अपनी जघा मैं ना छोड़ो जागो; हर एक कै नीचे फेंक दौ जागो।” ");
INSERT INTO thr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","बे पूँछीं, “गुरुजी, जौ कब होगो? जे बातैं जब होन बारी होंगी, और जब जे बातैं पूरी होमंगी तौ बौ समय को का चिन्ह होगो?” ");
INSERT INTO thr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ईसु कही, “पहरा मैं रहबौ; धोका मत खाबौ। भौत से मेरे नाओं से आयकै कहंगे, ‘कि मैं बहे हौं!’ और जहो भी, ‘कि समय झोने आए चुको है!’ लेकिन तुम उनके पच्छू मत जईयो। ");
INSERT INTO thr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जब तुम लड़ाई और क्रांति के बारे मैं सुनथौ तौ डराबौ मत; ऐसी चीजैं होनो जरूरी है, लेकिन उनको मतलब जौ ना है कि अंत झोने है।” ");
INSERT INTO thr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तौ बौ कही, “देस आपस मैं लड़ंगे; राज्य एक दुसरे के ऊपर हमला करंगे। ");
INSERT INTO thr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","हर जघा भयानक भूकंप, आकाल और आफत आमंगी; आसमान से बड़े-बड़े चिन्ह दिखाई देंगे। ");
INSERT INTO thr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","जे सब बातन से पहले बे मेरे नाओं के बजह से तुमकै पकड़ंगे, और सतांगे, तुम सभाघरन मैं परखे जान के ताहीं सौंपे जागे; तुमकै कैदखाना मैं डार देंगे; और तुमकै मेरी बजह से राजाओं और सासकन के सामने लाओ जागो। ");
INSERT INTO thr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","पर जौ तुमरे ताहीं सुसमाचार की गभाई देन को मौका होगो। ");
INSERT INTO thr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","पहलेई से अपने मन मैं चिंता मत करियो कि तुम कैसे करकै अपनी रक्छा करैगे, ");
INSERT INTO thr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","काहैकि मैं तुमकै ऐसो बोल और बुद्धि दुंगो, कि तुमरो कोई भी दुस्मन तुमरे कहे को खंडन या बिरोध नाय कर पागो। ");
INSERT INTO thr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","तुमरे अईय्या-दऊवा, भईय्या, हितुआ और तुमरे दोस्तन के जरिया तुमकै सौंप दौ जागो; और तुम्मैं से कितने कै मौत के घाट उतार दौ जागो। ");
INSERT INTO thr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मेरे नाओं की बजह से तुमकै भौत नफरत मिलैगी। ");
INSERT INTO thr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","लेकिन तुमरी मुड़िया से एक बार भी बाँका ना होगो। ");
INSERT INTO thr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","धीरज धरौ, और तुम अपने आपकै बचाए लेगे। ");
INSERT INTO thr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","जब तुम यरूसलेम कै सेना से घिरो भौ देखौ, तौ तुम जान लियो कि बौ जल्दिये उजड़ जागो। ");
INSERT INTO thr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","फिरौंकी जो लोग यहूदिया मैं हैं उनकै पहाड़ियन के घाँईं भाजनो चाहिए; जो लोग सहर मैं हैं उनकै छोड़ने होगो, और जो लोग देस से बाहर हैं उनकै सहर मैं ना जानो चाहिए। ");
INSERT INTO thr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","काहैकि बे ‘न्याय के दिन’ होंगे, जो पवित्र सास्त्र मैं कही गई बातन कै सच करन के ताहीं होंगे। ");
INSERT INTO thr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","बे बईंय्यरन के ताहीं जो पेट से होंगी और छोटे बालकन कि अईय्या होंगी उनके ताहीं कितनो भयानक होगो! जौ धरती मैं भयानक आफत आगी, और परमेस्वर कि सजा जे लोगन के ऊपर पड़ैगी। ");
INSERT INTO thr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","कुछन कै तलवार से मार दौ जागो, और दुसरेन कै सबै देसन मैं कैदियन के हानी लैजाओ जागो; और जब तक गैर यहूदि को समय पूरो ना होगो तौले बे यरूसलेम के ऊपर रहंगे। ");
INSERT INTO thr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","सूरज, चंद्रमा और तारेन मैं चिन्ह दिखाई देंगे। धरती और पूरे देस निरासा मैं होंगे, समुंदर कि गरजन और ऊँची लहरन से डरांगे। ");
INSERT INTO thr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","लोग डर के मारे बेहोस हुई जांगे काहैकि बे असियाय रै हैं कि पूरी दुनिया मैं का ही रौ है, काहैकि आसमान मैं रहन बारी सामर्थी काम की सक्ति हिलाई जांगी। ");
INSERT INTO thr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तौ बे इंसान के लौड़ा कै सामर्थ्य और महिमा के संग बादर मैं आत भइ देखंगे। ");
INSERT INTO thr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जब जे चीज होन लगैं, तौ ठाड़कै अपनी मुड़िया कै ऊपर उठईयो, काहैकि तुमरो उद्धार और छुटकारा झोने होगो।” ");
INSERT INTO thr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","तौ ईसु उनकै जो कहानी बताई: “अंजीर के पेंड़ और दूसरे सबै पेंड़न के बारे मैं सोचौ। ");
INSERT INTO thr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जब तुम देखथौ कि उनके पत्ता दिखाई देन लगे हैं, तौ तुम जान जाथौ कि गर्मी झोने आए चुकी है। ");
INSERT INTO thr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","बैसिये, जब तुम जे चीजन कै होत भइ देखैगे, तौ तुम जान जागे कि परमेस्वर को राज्य आनबारो है।” ");
INSERT INTO thr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“मैं तुमसे सच्ची मैं कहथौं कि जे सब चीजैं लोगन के सामने होंगी, जहाँ अभै सब जिंदे हैं। ");
INSERT INTO thr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","स्वर्ग और पृथ्वी टल जागी, लेकिन मेरी बात कहु ना टलैगी।” ");
INSERT INTO thr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“तुम चहाचीते रहबौ! अपने आपकै भौत जाधा दावत और पीन के सामान संग और जौ दुनिया की बात कै मन मैं चिंता के संग कब्जा मत करन दियौ, या बौ दिन अनकाचीति तुमकै पकड़ लेबै। ");
INSERT INTO thr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","काहैकि जौ जार के तराहनी धरती मैं हर जघा सबै लोगन के ऊपर आए पड़ैगो। ");
INSERT INTO thr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","चहाचीते रहाबौ और हमेसा प्रार्थना करत रहबौ कि तुम जे सब आनबारी घटनन से सई सलामत निकरन, और इंसान के लौड़ा के सामने ठाड़न की सक्ति मिलै।” ");
INSERT INTO thr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ईसु बे दिनन मंदिर मैं उपदेस देत भइ बिताई, और जब संजा होती, तौ बौ बाहर निकर जातो और रात जैतून नाओं के पहाड़ मैं बितातो। ");
INSERT INTO thr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","रोजाना सुबेरे सब जनी मंदिर मैं बाकी बात सुनन कै जाए करत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","बौ समय अखमीरी रोटी को त्योहार जो फसह कहो जाथै, झोने रहै। ");
INSERT INTO thr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","बड़ो पुजारी और यहूदि नियम के सिक्छक कोई बीच से ईसु कै चुपके से मौत के घाट उतारन कि कोसिस करत रहैं, पर बे लोगन से डरात रहैं। ");
INSERT INTO thr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","तौ सैतान यहूदा के अंदर घुस गौ, जोकै इस्करियोती कहो जात रहै, और बौ बारह चेलन मैं से एक रहै। ");
INSERT INTO thr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","तौ यहूदा जाएकै बड़े पुजारी और मंदिर के पहरेदारन से कही, कि बौ ईसु कै उनके हाथ कैसे पकड़वाए सकथै। ");
INSERT INTO thr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","बे खुस हुईगै और बाकै पैसा देन को वादा करीं। ");
INSERT INTO thr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","यहूदा जाके ताहीं राजी ही गौ और ईसु कै जानन बारे लोगन कै बिना पता चलाय उनकै सौंपन को एक अच्छो मौका ढूँड़न लगो। ");
INSERT INTO thr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","बौ दिन अखमीरी रोटी के त्योहार के समय आओ जब फसह के खानु के ताहीं भेंड़ के बच्चा कै बलिदान हुई जाने रहैं। ");
INSERT INTO thr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ईसु पतरस और यूहन्ना कै जौ कहकै भेजी, “कि जाबौ और फसह को खानु हमरे खान के ताहीं तैयार करौ।” ");
INSERT INTO thr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","बे बासे पूँछीं, “तैं कहाँ चाहथै, कि हम जाकै तैयार करैं?” ");
INSERT INTO thr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ईसु जबाब दई, “जब तुम सहर मैं जागे, तौ एक आदमी तुमकै पानी को एक घल्ला लै मिल जागो। जो घर मैं बौ जाबै तुम बाके पच्छू चले जईयो, ");
INSERT INTO thr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","और बौ घर के मालिक से कहियो, ‘गुरु तोसे कहथै, कि बौ कमरा कहाँ है जहाँ मैं और मेरे चेला फसह को खानु खांगे?’ ");
INSERT INTO thr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","बौ तुमकै एक बड़ी सजी-सजाई कुठरिया दिखागो, जहाँ तुमकै सब कछु तैयार मिलैगो।” ");
INSERT INTO thr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","बे चले गै, और बे सब कछु बैसिये पाईं जैसी ईसु उनसे कही रहै, और बे फसह को खानु तैयार करीं। ");
INSERT INTO thr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जब समय आओ, तौ ईसु प्रेरितन के संग खानु खान कै मेज मैं अपनी जघा बैठो। ");
INSERT INTO thr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ईसु उनसे कही, “मैं चहात रहौं, कि मैं दुख भोगन से पहले जौ फसह को खानु तुमरे संग खामौं! ");
INSERT INTO thr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","काहैकि मैं तुमकै बताथौं, मैं जाकै तौले ना खामंगो, जब तक कि परमेस्वर के राज्य मैं जाको पूरो मतलब ना दौ जागो।” ");
INSERT INTO thr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","तौ ईसु एक प्यालो लई, और परमेस्वर को धन्यवाद दई, और कही, “जाकै लियौ और आपस मैं बाँट लेबौ। ");
INSERT INTO thr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","मैं तुमसे कहथौं, कि जब तक परमेस्वर को राज्य ना आगो तब तक मैं जौ दाखरस कै ना पींगो।” ");
INSERT INTO thr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","फिर ईसु रोटी को एक टुकड़ा लई, और परमेस्वर कै धन्यवाद दई, बाकै तोड़ी, और जौ कहत भइ उनकै दै दई, “जौ मेरी सरीर है, जो तुमरे ताहीं दई गई है। जौ मोकै याद करन के ताहीं करे करियो।” ");
INSERT INTO thr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","बैसिये, बौ उनकै खानु खान के बाद प्यालो जौ कहकै दई, “जौ प्यालो परमेस्वर कि नई वाचा है जोके ऊपर मेरे बौ खून से मुहर लगाई गई है, जो तुमरे ताहीं बहाओ जाथै।” ");
INSERT INTO thr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“लेकिन देखौ! जो मोकै धोका देगो बौ हिंयाँ मेरे संग मेज मैं बैठो है! ");
INSERT INTO thr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","इंसान को लौड़ा मर जागो जैसो कि परमेस्वर ठानी है, लेकिन बौ आदमी के ताहीं कितनो भयानक होगो जो बाके संग विस्वासघात करथै!” ");
INSERT INTO thr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","फिर बे आपस मैं पूँछन लगे कि उनमैं से कौन ऐसो हुई सकथै जो ऐसो करन बारो है। ");
INSERT INTO thr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","चेलन मैं एक बहस छिड़ गई कि उनमैं से कौन सबसे बड़ो और महान मानो जानो चाहिए। ");
INSERT INTO thr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ईसु उनसे कही, “गैर यहूदि के राजा को अपने लोगन के ऊपर अधिकार है, और सासक ‘लोगन के दोस्त’ उपाधि को दाबा करथैं।” ");
INSERT INTO thr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","लेकिन जौ तुमरे संग ऐसो ना है; बल्कि, तुमरे बीच को सबसे बड़ो आदमी सबसे छोटो होनो चाहिए, और नेता कै सेवा करन बारे सेवक के हानी होनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","कौन बड़ो है, जो खान के ताहीं बैठो है या जो सेवा करथै? जरूर बौ जो नीचे बैठथै। लेकिन मैं तुमरे बीच मैं हौं जो सेवा करथै। ");
INSERT INTO thr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“तुम मेरी सबै परिक्छन मैं मेरे संग रहे; ");
INSERT INTO thr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","और जैसे मेरो दऊवा मोकै राज्य करन को अधिकार दई है, बैसिये महुँ तुमकै बहे अधिकार दुंगो। ");
INSERT INTO thr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","तुम मेरे राज्य मैं मेरी मेज मैं खागे पीगे, और तुम इस्राएल के बारह गोत्रन के ऊपर राज करन के ताहीं सिंहासन मैं बैठैगो।” ");
INSERT INTO thr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“सिमौन, सिमौन! बात सुन! सैतान तुम सबन कि परिक्छा लेन की, अच्छाई कै बुराई से अलग करन के ताहीं इजाजत लै लई है, जैसे एक किसान गेंहूँ कै भूसा से अलग करथै। ");
INSERT INTO thr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","लेकिन हे सिमौन, मैं तेरे ताहीं प्रार्थना करो हौं, कि तेरो बिस्वास कम ना होबै। और जब तैं मेरे पास लौटेगो, तौ तोकै अपने भईय्यन कै मजबूत करने होगो।” ");
INSERT INTO thr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","पतरस जबाब दई, “प्रभु, मैं तेरे संग कैदखाना जान और तेरे संग मरन के ताहीं तैयार हौं!” ");
INSERT INTO thr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ईसु कही, “मैं तोसे कहथौं, पतरस, जब तक तैं तीन बार ना कहगो कि तैं मोकै ना जानथै, तौले मुर्गा आज रात ना बासैगो।” ");
INSERT INTO thr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","फिर ईसु अपने चेलन से पूँछी, “जब मैं तुमकै बटुआ, झोला, और जूतन के बिना भेजो रहौं, तौ का तुमकै कछु चीज कि कमी भइ रहै।” ");
INSERT INTO thr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ईसु उनसे कही, “लेकिन अब, जोके पास कोई बटुआ या झोला होबै बौ लेबै; और जोके पास तलवार ना है, बाकै अपनो कोट बेचकै एक खरीदने होगो। ");
INSERT INTO thr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","काहैकि मैं तुमसे कहथौं कि जो व्यवस्था की किताब मैं लिखो है, ‘बौ अपराधिन के संग गिनो गौ,’ मेरे बारे मैं सच होनो चाहिए, काहैकि मेरे बारे मैं जो लिखो गौ रहै बौ सच हुई रौ है।” ");
INSERT INTO thr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","चेला कहीं, “प्रभु देख! हिंयाँ दुई तलवार हैं!” बौ जबाब दई, “जे काफी हैं!” ");
INSERT INTO thr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ईसु सहर छोड़ दई और जैतून के पहाड़ मैं चले गौ, जैसो कि बौ आमतौर मैं करत रहै, और चेला बाके संग गै। ");
INSERT INTO thr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","जब बे बौ जघा मैं पौहोंचे, तौ ईसु उनसे कही, “प्रार्थना करौ कि तुम परिक्छा मैं ना पड़ौ।” ");
INSERT INTO thr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","फिर ईसु एक पथरा फेंकन भरे कि दूरी मैं चले गौ और घूँटे टेक कै प्रार्थना करन लगो। ");
INSERT INTO thr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ईसु कही, “दऊवा, अगर तैं चाहबै तौ जौ दुख के प्यालो कै मोसे दूर लै जा। फिर भी मेरी इच्छा ना, लेकिन तेरी इच्छा पूरी होबै।” ");
INSERT INTO thr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तौ स्वर्ग को एक दूत बाकै दिखाई दई और बाकै ताकत दई। ");
INSERT INTO thr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","बौ बड़ा दर्द मैं और भी जोस के संग प्रार्थना करी; बाको पसीना जमीन मैं मानौ खून कि बूंद के हानी गिरत रहै। ");
INSERT INTO thr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","अपनी प्रार्थना से उठकै, बौ चेलन के झोने बापस गौ और उन्हैं उनके दुख से थके भै पाई। ");
INSERT INTO thr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ईसु उनसे कही, “तुम सोए काहे रै हौ? उठौ और प्रार्थना करौ कि तुम परिक्छा मैं ना पड़ौ।” ");
INSERT INTO thr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ईसु अभै बोलतै रहै की जबले यहूदा के पच्छू-पच्छू एक भीड़ आई, जो बारह चेलन मैं से एक रहै। बौ ईसु कै चूमन के ताहीं ईसु के झोने आओ। ");
INSERT INTO thr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","लेकिन ईसु कही, “यहूदा, का तैं चूमकै इंसान के लौड़ा कै पकड़वाए रौ है?” ");
INSERT INTO thr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","जब ईसु के संग गै भै चेला जौ सब देखीं कि का होन बारो है, तौ बे ईसु से पूँछीं, “प्रभु, का हम अपनी तलवारन को इस्तमाल करैं?” ");
INSERT INTO thr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","और उनमैं से एक बड़े पुजारी के सेवक के ऊपर तलवार चलाय दई और बाको दहने कान कै काट दई। ");
INSERT INTO thr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","लेकिन ईसु कही, “अब बस ही गौ!” बौ आदमी के कान के छुइ और बाकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तौ ईसु बड़ो पुजारी और मंदिर के अधिकारिन और बे बड़े-बूढ़ेन से कही जो बाकै लेन आए रहैं, “का तुम मोकै डाँकू समझकै तलवार और लठिया लैकै निकरे हौ? ");
INSERT INTO thr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","मैं हर रोज मंदिर मैं तुमरे संग रहौं, और तुम मोकै गिरफ्तार करन कि कोसिस ना करे। लेकिन जौ तुमरे काम करन को समय है, जब अंधियारे कि सक्ति अधिकार रखथै।” ");
INSERT INTO thr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","बे ईसु कै गिरफ्तार करीं और बाकै बड़े पुजारी के घर मैं लैगै; और पतरस थोड़ी दूर हुईकै पीछा करी। ");
INSERT INTO thr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","और जब बे आँगन के बीच मैं आगी सुलगाए कै बैठै, तौ पतरस बे लोगन बीच मैं बैठगौ, जो गोल घेरा बनाएकै बैठै रहैं। ");
INSERT INTO thr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","जब एक सेविका बाकै हुँआँ आगी के किनारे बैठो देखी, तौ बौ सीधे बाके घाँईं देखकै कही, “जौ आदमी भी ईसु के संग रहै!” ");
INSERT INTO thr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","लेकिन पतरस जौ कहकै इंकार कर दई, “बईय्यर, मैं बाकै ना जानथौं!” ");
INSERT INTO thr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोड़ी देर बाद एक आदमी और पतरस कै देखकै कही, “तहूँ तौ उन्हईं मैं से एक है!” लेकिन पतरस जबाब दई, “हे इंसान, मैं ना हौं!” ");
INSERT INTO thr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","और लमसम एक घंटा बाद एक दुसरो आदमी जोर दैकै कही, “जामैं कोई सच ना है कि जौ आदमी ईसु के संग रहै, काहैकि जहो एक गलीली है!” ");
INSERT INTO thr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","लेकिन पतरस जबाब दई, “हे इंसान, मोकै पता ना है कि तुम कौनके बारे मैं बात कर रै हौ!” जब बौ कहतै रहै कि तुरंत मुर्गा बास दई। ");
INSERT INTO thr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","प्रभु ईसु घूमकै सीधे पतरस घाँईं देखी, और पतरस कै याद आओ कि प्रभु बासे कही रहै, “आज रात मुर्गा बासन से पहले, तैं तीन बार कहगो कि तैं मोकै ना जानथै।” ");
INSERT INTO thr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","पतरस बाहर चले गौ और फूट-फूट कै रोन लागो। ");
INSERT INTO thr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जो लोग ईसु कि रखबारी करत रहै, बे बाकी मजाक बनाईं और बाकै मारीं। ");
INSERT INTO thr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","बे बाकी आँखिन मैं पट्टी भाँदकै और बासे पूँछीं, “अब भविस्यवाँड़ी करकै बता तोकै कौन मारो!” ");
INSERT INTO thr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","और बे बड़ा बुराई करन बारी बात कहीं। ");
INSERT INTO thr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जब दिन भौ, तौ बड़े-बूढ़े, और बड़ो पुजारी और यहूदि नियम के सिक्छक इखट्टे भै, और ईसु कै पंचायत घर मैं लाईं। ");
INSERT INTO thr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","बे कहीं, “हमैं बता, का तैं मसीह है?” ईसु जबाब दई, “अगर मैं तुमसे कहेंगो, तौ तुम मेरे ऊपर बिस्वास ना करैगे; ");
INSERT INTO thr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","और अगर मैं तुमसे एक सवाल पूँछंगो, तौ तुम जबाब ना देगे। ");
INSERT INTO thr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","लेकिन अब से इंसान के लौड़ा कै सर्वसक्तिमान सामर्थ्य को परमेस्वर के अधिकार मैं बैठाए दौ जागो।” ");
INSERT INTO thr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","बे सब जनी कहीं, “फिर का तैं, परमेस्वर को लौड़ा है?” ईसु उनकै जबाब दई, “तुम खुदै कहथौ, कि मैं हौं।” ");
INSERT INTO thr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","और बे कहीं, “हमैं कोई गभाई कि जरूरत ना है! हम खुदै सुने हैं कि बौ का कही!” ");
INSERT INTO thr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","पूरो समूह उठकै ईसु कै पिलातुस के सामने लैगै, ");
INSERT INTO thr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","जहाँ बे बाके ऊपर दोस लगानो सुरु करीं: “हम जौ आदमी कै हमरे देस के लोगन कै गुमराह करत भइ पकड़े, और सम्राट कैसर कै लगान देन से मना करत, अपने आपकै मसीहा, राजा कहत भइ सुने हैं।” ");
INSERT INTO thr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पिलातुस ईसु से पूँछी, “का तैं यहूदियन को राजा है?” ईसु जबाब दई, “तैं खुदै कहरौ है।” ");
INSERT INTO thr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तौ पिलातुस बड़े पुजारी और भीड़ से कही, “मोकै जौ आदमी मैं कोई दोस ना मिलो।” ");
INSERT INTO thr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","लेकिन बे और जोर दैकै कहीं, “जौ गलील से लैकै हिंयाँ तक पूरे यहूदिया मैं उपदेस दै दैकै लोगन कै भड़काथै।” ");
INSERT INTO thr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","जब पिलातुस जौ सुनी, तौ उनसे पूँछी, “का जौ आदमी गलीली है?” ");
INSERT INTO thr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","जब बाकै पता चलो कि ईसु हेरोद के इलाका को है, तौ बौ बाकै हेरोद के अधिकार के झोने पनार दई, काहैकि बे दिनन बौ भी यरूसलेम मैं रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ईसु कै देखकै हेरोद बड़ा खुस भौ, काहैकि बौ बाके बारे मैं सुनी रहै, और भौत दिनन से बाकै देखनो चहात रहै। बौ ईसु कै कछु चिन्ह करत भइ देखन कि उमीद करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","इसलै हेरोद ईसु से गजब सबाल पूँछी, लेकिन ईसु कोई जबाब ना दई। ");
INSERT INTO thr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","और बड़ो पुजारी और यहूदि नियम के सिक्छक अग्गु कदम बढ़ाई और ईसु के खिलाप मजबूत आरोप लगाईं। ");
INSERT INTO thr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तौ हेरोद और बाके सैनिक ईसु को मजाक बनाईं और बाको अपमान करीं; और बे ईसु कै एक अच्छो लत्ता पहनाए कै बाकै बापस पिलातुस के झोने पनार दई। ");
INSERT INTO thr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","बहे रोज से हेरोद और पिलातुस दोस्त बन गै; जासे पहले बे दुस्मन रहैं। ");
INSERT INTO thr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुस बड़े पुजारी, अधिकारी और लोगन कै एक संग बुलाई, ");
INSERT INTO thr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","और बौ कही, “तुम जौ आदमी कै मेरे झोने लैकै आए और कहे कि जौ लोगन कै भरमाए रौ है। अब, मैं तेरे सामने बाकी परिक्छा करो हौं, और जो अपराध तैं बाके ऊपर करो है, बे बातन के बारे मैं मैं बामै कोई दोस नाय पाओ हौं। ");
INSERT INTO thr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","और न तौ हेरोद जाकै दोसी पाई, काहैकि बौ जाकै हमरे झोने बापस पनार दई है। जौ आदमी मौत के लायक कुछ न करी है। ");
INSERT INTO thr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","इसलै मैं जाकै कोड़ा मरवाएकै जान दुंगो।” ");
INSERT INTO thr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","पिलातुस त्योहार के समय उनके ताहीं एक बंधी कै छोड़न ताहीं बेबस रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","तौ पूरी भीड़ चिल्लाए उठी, “जाकै मार डारौ! और हमरे ताहीं बरअब्बा कै आजाद कर दे।” ");
INSERT INTO thr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","सहर मैं होन बारे दंगा के ताहीं और खून करन मैं बरअब्बा कै कैदखाना मैं डार दौ गौ रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पर पिलातुस ईसु कै छोड़नो चहात रहै, इसलै बौ भीड़ कै फिर से समझाई। ");
INSERT INTO thr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","लेकिन बे चिल्लाईं, “बाकै क्रूस मैं चढ़ाबौ! बाकै क्रूस मैं चढ़ाओ!” ");
INSERT INTO thr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","पिलातुस तिसरी बार उनसे कही, “लेकिन बौ का गुनाह करी है? मोकै ऐसो कछु नाय मिलो जोसे बौ मौत के लायक होबै! इसलै मैं बाकै कोड़ा मरवाएकै छोड़ देथौं।” ");
INSERT INTO thr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","लेकिन बे अपनी अबाज मैं जोड़न से चिल्लात रहे कि ईसु कै क्रूस मैं चढ़ाओ जानो चाहिए, और आखिरकार उनको चिल्लानो कामयाब हुई गौ। ");
INSERT INTO thr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","जौ बजह से पिलातुस ईसु कै सजा को फैसला दई जो बे अधिकार से मांगत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","पिलातुस बौ आदमी कै छोड़ दई, जो दंगा और हत्या के आरोप मैं कैदखाना मैं डार दौ गौ रहै, और ईसु कै उनकी इच्छा के हिसाब से सौंप दई। ");
INSERT INTO thr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","सिपईय्या जब ईसु कै क्रूस के संग लैकै जात रहैं, तौ बे सिमौन नाओं को एक कुरेनी कै जो सहर मैं आत रहै, बे बाकै पकड़ लईं, और बाकै ईसु के पच्छू-पच्छू लै चले गै। ");
INSERT INTO thr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","लोगन कि एक बड़ी भीड़ ईसु के पच्छू ही लई; उनमैं से कुछ बईंय्यरैं तौ छाती पीट-पीटकै रोत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ईसु उनके घाँईं मुड़कै कही, “यरूसलेम कि बईंय्यरौं! मेरे ताहीं मत रोबौ, बल्किन अपने और अपने बालकन के ताहीं रोबौ। ");
INSERT INTO thr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","काहैकि बे दिन आए रै हैं जब लोग कहंगे, ‘कितनी खुसनसीब हैं बे बईंय्यरैं जिनके कहु बालका ना भै, जो कहु बालका पैदा ना करीं, जो कहु उनको पालन पोसँड़ ना करीं!’ ");
INSERT INTO thr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","जहे बौ समय होगो जब लोग पहाड़न से कहंगे, ‘हमरे ऊपर गिर!’ और चुटिया से, ‘हमकै ढोंक ले!’ ");
INSERT INTO thr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","काहैकि अगर ऐसे काम कठिया के हरे होन मैं करे जाथैं, तौ जब जौ सूख जागी तौ का होगो?” ");
INSERT INTO thr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","बे दुई आदमिन कै भी जो अपराधी रहैं ईसु के संग मौत के घाट उतारन दौ गौ। ");
INSERT INTO thr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","जब बे खोपड़ी नाओं कि जघा मैं पौहोंचे, तौ बे हुँआँ ईसु कै क्रूस मैं चढ़ाईं, और बे दोनों अपराधिन कै भी, एक ईसु के दहने और दुसरो ईसु के बाँए घाँईं। ");
INSERT INTO thr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","तौ ईसु कही, “दऊवा! इनकै माफ कर दे, काहैकि जे ना जानथैं कि जे का कर रै हैं।” बे पासा डारकै बाके लत्ता आपस मैं बाँट लईं। ");
INSERT INTO thr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","यहूदि अधिकारी बाके ऊपर झपटत भइ हुँआँ ठाड़े भै लोगन कै देखत रहैं: और कहीं, “बौ दुसरेन कै बचाई है; अगर बौ मसीहा है जोकै परमेस्वर चुनी है तौ अपने आपकै बचाए ले!” ");
INSERT INTO thr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सिपईय्या ईसु को मजाक बनाईं: बे बाके झोने आए और बाकै घटिया दाखरस पीन कै दई, ");
INSERT INTO thr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","और कहीं, “अगर तैं यहूदियन को राजा है तौ अपने आपकै बचाए ले!” ");
INSERT INTO thr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ईसु के ऊपर जे सब्द लिखे गै रहैं: कि “जौ यहूदियन को राजा है।” ");
INSERT INTO thr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","हुँआँ लटके भै अपराधिन मैं से एक जनी बाकी बुराई करीं: “का तैं मसीहा ना है? अपने आपकै और हमकै बचा!” ");
INSERT INTO thr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","लेकिन दुसरो जनी बाकै झुकात भै कही, “का तैं परमेस्वर के न्याय से ना डराथै? तहूँ तौ बहे सजा पाए रौ है। ");
INSERT INTO thr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","हमरो, खाली ठीक है, काहैकि हमैं बहे मिल रौ है जोके हम सई रूप मैं हकदार हैं, जो हम करे; लेकिन बौ कोई गलत काम ना करी।” ");
INSERT INTO thr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","और बौ ईसु से कही, “ईसु, जब तैं अपने राज्य मैं राजा के रूप मैं आबै, तौ मोकै याद करीये!” ");
INSERT INTO thr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ईसु बासे कही, “मैं तोसे सच्ची मैं कहथौं कि आज तैं मेरे संग स्वर्गलोक मैं होगो।” ");
INSERT INTO thr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","और लमसम दिन के बारह बजे रहैं जब सूरज चमकनो बंद होन लग्गौ और दुपारी के तीन बजे ले पूरे देस मैं बुराई मैं अंधियारो छाए गौ; ");
INSERT INTO thr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","और मंदिर मैं लटको भौ परदा बीच से फटकै दुई टुकड़ा हुई गौ। ");
INSERT INTO thr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ईसु ऊँची अबाज मैं पुकारी, “दऊवा! मैं अपनी आत्मा तेरे हातन मैं सौंपथौं।” बौ ऐसे कही और मरकुस गौ। ");
INSERT INTO thr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","सेना को अधिकारी जौ सब देखकै जो सब भौ रहै, बौ परमेस्वर कि बड़ाँईं करत भइ कही, “ठीक मैं जौ एक धर्मी आदमी रहै!” ");
INSERT INTO thr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","जब तमासा देखन बारे जो हुँआँ जुराने रहैं बे लोग देखीं कि का भौ है, तौ बे सब दुख मैं अपनी छाती पीटत भइ घरै बापस लौट गै। ");
INSERT INTO thr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","बे सब ईसु के जान पहचान के, और जो बईंय्यरैं गलील से बाके संग आई रहैं, दूर ठाड़कै जौ सब देखत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","और हुँआँ, यहूदिया के सहर अरिमतियाह से यूसुफ नाओं को एक आदमी रहै। बौ एक अच्छो और धर्मी आदमी रहै, जो सिरफ परमेस्वर के राज्य के आन को इंतजार करत रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","हालाकि बौ महासभा और अरिमतियाह सहर को एक यहूदि सदस्य और परमेस्वर के राज्य की बाट जोहनबारो रहै, लेकिन बौ उनके न्याय और कारवाई से सहमत ना रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","बौ पिलातुस के झोने जाएकै ईसु कि सरीर कै माँगी। ");
INSERT INTO thr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","फिर बौ ईसु कि सरीर कै नीचे उतारकै एक चद्दर मैं लपेट दई, और एक कबर मैं रखी जो ठोस चट्टान मैं खुदी गई रहै और जोको कहु इस्तमाल ना करो गौ रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","जौ सुक्कर को दिन रहै, और साबत को दिन सुरु होन बारो रहै। ");
INSERT INTO thr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","और बे बईंय्यरैं जो बाके संग गलील से आई रहैं, बे यूसुफ के संग जाएकै कबर कै देखीं और जहो कि ईसु के सरीर कै कैसे करकै रखो गौ है। ");
INSERT INTO thr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","आग्या लैकै फिर बे साबत के दिन बापस घरै गै और ईसु कि सरीर के ताहीं महाकनबारी चीज मसाल और इत्तर तैयार करीं। और साबत के रोज तौ बे कानून के हिसाब से आराम करीं। ");
INSERT INTO thr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","सप्ताह के पहलो दिन के सुबेरे बड़ा जल्दी बे इत्तर और महाकनबारी चीज और मसाले जो बे बईंय्यरैं तैयार करी रहैं लैकै कबर मैं गईं। ");
INSERT INTO thr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","बे देखीं कि पथरा कबर से लुढ़को भौ है, ");
INSERT INTO thr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","इसलै बे अंदर गै; लेकिन उनकै प्रभु ईसु को सरीर नाय मिलो। ");
INSERT INTO thr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","बे जौ बात सोचकै हैरान रहैं, कि अनकाचीति चमकीले चमकदार लत्तन मैं दुई आदमी उनके झोने आयकै ठाड़गै। ");
INSERT INTO thr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","और जो उनके ऊपर जो बीतो बे डर के मारे बईंय्यरैं जमीन मैं गिर पड़ीं, बे आदमी उनसे कहीं, “तुम जिंदे कै मरे भैन मैं काहेकै ढूँड़ रै हौ? ");
INSERT INTO thr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","बौ हिंयाँ ना है; बौ जी उठो है। याद करौ कि गलील मैं रहत भइ बौ तुमसे का कही रहै: ");
INSERT INTO thr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘इंसान को लौड़ा पापिन के हात पकड़बाओ जागो, क्रूस मैं चढ़ाओ जागो, और तीसरे दिन जिंदो हुई जागो।’” ");
INSERT INTO thr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तौ बईंय्यरन कै ईसु कि बात याद आई, ");
INSERT INTO thr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","और कबर से लौटकै, जे सब बातन कै ग्यारह चेला और बाकी लोगन कै बताईं। ");
INSERT INTO thr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","बईंय्यरन मैं मरियम मगदलीनी, योअन्ना और याकूब कि अईय्या मरियम रहै; बे और उनके संग कि दुसरी बईंय्यरैं प्रेरितन कै जे सब बात बताईं। ");
INSERT INTO thr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","लेकिन प्रेरितैं सोचीं कि बईंय्यरैं जो बात कह रइ हैं बौ सब बकवास है, और बे उनके ऊपर बिस्वास ना करीं। ");
INSERT INTO thr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","लेकिन पतरस उठकै कबर के घाँईं भाजत गौ; और तरे झुककै खाली लत्ता पड़े भै देखी और कछु ना देखी। फिर बौ जो भौ रहै, बाके ऊपर ताजुब भइ घरै बापस चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","बहे रोज ईसु के ऊपर बिस्वास करन बारे दुई जनी इम्माऊस नाओं के एक गाँव मैं जात रहैं, जो यरूसलेम से लमसम ग्यारह किलो मीटर दूर रहै, ");
INSERT INTO thr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","और जो कछु भौ रहै, बौ सबके बारे मैं आपस मैं बात करत रहैं। ");
INSERT INTO thr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","जैसो कि बे बातचीत और पूँछ-तांछ करत रहैं, तौ ईसु खुद उनके झोने आयकै और उनके संग चल दई; ");
INSERT INTO thr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","बे बाकै देखीं, लेकिन कैसियो बाकै पहचान ना पाईं। ");
INSERT INTO thr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ईसु उनसे कही, “तुम नेंगत-नेंगत आपस मैं का बतकाए रै हौ?” बे उदास चैहरा लैकै ठाड़े रहगै। ");
INSERT INTO thr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","उनमैं से एक, जोको नाओं क्लियुपास रहै, बौ पूँछी, “का तैं यरूसलेम मैं इकलौतो परदेसी है जो बे चीजन कै ना जानथै जो पिछले कुछ दिनन से हुँआँ हुई रौ है?” ");
INSERT INTO thr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ईसु उनसे पूँछी, “कौन सी बातैं?” बे जबाब दई, “ईसु नासरत के संग भइ बातैं, जौ आदमी एक भविस्यवक्ता रहै और परमेस्वर और सबै लोगन के जरिये उनके जरिये कहे गै और करे गै हर काम मैं सक्तिसाली होन के ताहीं मानो जात रहै। ");
INSERT INTO thr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","हमरे बड़े पुजारी कानून और न्याय के अधिकारी बाकै मौत कि सजा के ताहीं सौंप दई, और बाकै क्रूस मैं चढ़ाय दौ गौ। ");
INSERT INTO thr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","और हमकै उमीद रहै कि बौ बहे होगो जो इस्राएल कै छुड़ाय कै आजाद करन बारो है! इन सबके अलावा, जौ घटना कै भै जौ तीसरो दिन है। ");
INSERT INTO thr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","हमरे समूह कि कुछ बईंय्यरैं तौ हमकै अचम्मो मैं डार दई; बे भोर कै कबर मैं गईं, ");
INSERT INTO thr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","लेकिन ईसु कि सरीर ना मिली। बे जौ कहत भइ बापस आई कि हम स्वर्गदूतन को दर्सन देखीं जो हमकै बताईं कि बौ जिंदो है। ");
INSERT INTO thr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","हमरे संग के कुछ लोग कबर मैं गै और जैसो बईंय्यरैं कहीं रहैं, बैसो पाईं लेकिन बे ईसु कै ना देखीं।” ");
INSERT INTO thr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तौ ईसु उनसे कही, “तुम कितने मूर्ख हौ, भविस्यवक्ता कि हर बात के ऊपर मन मैं बिस्वास करन मैं कितने धीमे हौ! ");
INSERT INTO thr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","का मसीहा के ताहीं जौ जरूरी नाय रहै कि बौ जे दुखन कै उठाबै और अपनी महिमा मैं आबै?” ");
INSERT INTO thr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","और ईसु मूसा कि किताब से लैकै सब भविस्यवक्ता जो बाके बारे मैं सास्त्र मैं लिखी रहैं उनकै समझाई। ");
INSERT INTO thr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","तौ बे बौ गाँव के झोने आए जितै बे जात रहैं, ईसु ऐसो व्यवहार करी कि मानौ बौ अग्गु जात रहै; ");
INSERT INTO thr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","लेकिन बे कै जौ कहकै रोक लईं कि “हमरे संग रहा; दिन लमसम खतम हुई गौ है और अंधियारो हुई रौ है।” इसलै बौ उनके संग रहन कै चले गौ। ");
INSERT INTO thr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","बौ उनके संग खानु खान कै बैठगौ, रोटी लई, और आसीस माँग कै धन्यवाद करी; तौ बौ रोटी तोड़कै उनकै दई। ");
INSERT INTO thr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तौ उनकी आँखी खुली और बे बाकै पहचान लईं, लेकिन बौ उनकी नजर से गायब हुई गौ। ");
INSERT INTO thr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","बे आपस मैं कहीं, “का जौ बौ आगी के हानी नाय जो हमरे मन मैं पजरत रहै, जब बौ रस्ता मैं हमसे बतकात रहै, और सास्त्र को मतलब समझात रहै?” ");
INSERT INTO thr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","बे तुरंतै उठकै यरूसलेम कै लौट गै, और जितै पाईं की बे ग्यारह चेला औरन के संग जुराए गै हैं ");
INSERT INTO thr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","और कहीं, “प्रभु सचमुच मैं जी उठो है! बौ सिमौन कै दिखाई दई!” ");
INSERT INTO thr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","फिर दोनों उनकै समझाईं कि सड़क मैं का भौ रहै, और जब बे रोटी तोड़ीं तौ बे प्रभु कै कैसे पहचानी। ");
INSERT INTO thr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","जब बे दोनों उनसे जौ कहतै रहैं, अनकाचीति प्रभु खुद उनके बीच मैं ठाड़गौ और उनसे कही, “तुमकै सांति मिलै।” ");
INSERT INTO thr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पर जौ सोचकै कि हम एक भूत कै देखरै हैं, बे घबराय गै। ");
INSERT INTO thr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","लेकिन ईसु उनसे कही, “तुम काहेकै घबराय रै हौ? तुमरे मन मैं जौ संका काहेकै आए रौ है? ");
INSERT INTO thr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मेरे हातन कै और मेरे पाँवन कै देखौ, कि जौ मैं खुद हौं। मोकै महसूस करौ, और तुम जान जागे, काहैकि भूत के पास मास और हड्डी ना होथैं, जैसो कि तुम देख सकथौ कि मेरे पास हैं।” ");
INSERT INTO thr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","बौ ऐसे कही और उनकै अपने हात और पाँव दिखाई। ");
INSERT INTO thr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","उनकै दोस्तौ खुसी के मारे बिस्वास ना होत रहै, बे बड़ा अचम्मे से भरे भै रहैं; और बौ उनसे पूँछी, “का तुमरे पास खान के ताहीं कछु है?” ");
INSERT INTO thr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","बे बाकै पकी भइ मच्छी को एक टुकड़ा दई, ");
INSERT INTO thr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","जोकै बौ लई और उनके अग्गु खाई। ");
INSERT INTO thr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","फिर बौ उनसे कही, “जे मेरी बे बातैं हैं, जोमैं तुमरे संग रहत भइ, तुमसे कहो रहौं, कि जरूरी है, कि जितनी बात मूसा के नियम और भविस्यवक्ता और भजन संहिता कि किताबन मैं, मेरे बारे मैं लिखी हैं, सब पूरी होमैं।” ");
INSERT INTO thr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तौ बौ सास्त्र कै समझन के ताहीं उनके दिमाक कै खोली, ");
INSERT INTO thr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","और बौ कही, “जौ लिखो है, की मसीहा दुख उठागो, और तीन दिन बाद मौत से जी उठैगो, ");
INSERT INTO thr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","और यरूसलेम देस से सुरुवात करकै सब जातिन मैं मन फिरान और पापन की माफी को प्रचार बहे के नाओं से सुनाओ जाबै। ");
INSERT INTO thr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","तुम जे सब बातन के गभा हौ। ");
INSERT INTO thr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","और जो कुछ मेरो दऊवा वादा करी है मैं हूँनै तुमकै पनारंगो। लेकिन जबले ऊपर से सामर्थ्य तुमरे ऊपर ना उतरै तौले तुम नगर मैं असियाबौ।” ");
INSERT INTO thr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","तौ बौ उनकै बैतनिय्याह सहर से बाहर लैगौ, और बौ अपने हात उठाएकै उनकै आसीस दियो। ");
INSERT INTO thr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","और उनकै आसीस देत भइ बौ उनसे अलग हुई गौ और स्वर्ग मैं लैजाओ गौ। ");
INSERT INTO thr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","बे बाकी आराधना करीं और बड़े खुसी से भरकै यरूसलेम कै लौट गै। ");
INSERT INTO thr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","और अपनो पूरो समय मंदिर मैं परमेस्वर कै धन्यवाद देन और आसीस माँगन मैं बिताई।");
INSERT INTO thr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","सबसे सुरू मैं बचन रहै, और बचन परमेस्वर के संग रहै, और सब्दै परमेस्वर रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","और जहे सुरू मैं परमेस्वर के संग रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","सबै कछु बाके जरिये पैदा भौ, और जो कछुए बनो है, बामै से कछु चीज बाके बिना पैदा नाय भौ है। ");
INSERT INTO thr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","बहे मैं जिंदगी रहै और बहे जिंदगी दुनिया के इंसानन ताहीं उजियारो रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","जोती अंधियारे मैं चमकथै, और अंधियारो बाके ना अपनाईं। ");
INSERT INTO thr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेस्वर को भेजो भौ एक आदमी आओ, बाको नाओं यूहन्ना रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","बौ गभाई देन आओ कि बौ सब जनी कै जोती के बारे मैं बताबै, ताकी सब इंसान बाके जरिये बिस्वास करैं। ");
INSERT INTO thr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","बौ खुद जोती नाय रहै, पर बौ जोती की गभाई देन कै आओ रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","सच्ची जोती सब जनी कै उजीतो देथै, जौ दुनिया मैं आनबारी रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","बौ जौ दुनिया मैं रहै, और पूरी दुनिया बाके जरिये बनाई गई, और दुनिया बारे बाकै नाय पहचानी। ");
INSERT INTO thr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","बौ अपनेन के झोने आओ, और अपने बाकै नाय अपनाईं। ");
INSERT INTO thr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","लेकिन जित्ते जनी अपनाईं, बौ उनकै परमेस्वर को बालका होन को अधिकार दई, यानी बे जो बाके नाओं मैं बिस्वास रखथै। ");
INSERT INTO thr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","बे ना तौ खून से, और ना तौ सरीर की इच्छा से, और ना तौ इंसानन की मरजी से, पर बे तौ परमेस्वर से पैदा भै है। ");
INSERT INTO thr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","और बौ बचन इंसान को सरीर रूप लैकै, हमरे बीच मैं डेरा धरी, और हम बाकी ऐसी महिमा देखे, जैसे परम दऊवा परमेस्वर के इकलौते बेटा की महिमा, जो दया और सच्चाई से भरो हे। ");
INSERT INTO thr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्ना बाके बारे मैं गभाई दई, और पुकारकै कही, “जौ बहे है जोके बारे मैं जिकर करो रहों, कि जो मेरे बाद आए रौ है, बहे मोसे बड़ो है, काहैकि बौ मोसे पहले को रहै।” ");
INSERT INTO thr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","बाकी दया और सच्चाई कै पूरी तरह से हम सब जनी पाए हैं मतलब अनुग्रह मैं अनुग्रह। ");
INSERT INTO thr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","जहे ताहीं की नियम तौ मूसा के जरिये दौ गौ है, लेकिन अनुग्रह और सच्चाई ईसु मसीह के जरिये हमरे झोने पुगी हैं। ");
INSERT INTO thr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","जो खुद परमेस्वर है और परम दऊवा के संग है, परमेस्वर उनकै दिखाई है। ");
INSERT INTO thr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यूहन्ना की गभाई जौ है कि, जब यहूदि यरूसलेम से पुजारी और लेवीयन कै बासे जौ पूँछन के ताहीं भेजीं, “कि तैं कौन है?” ");
INSERT INTO thr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","तौ यूहन्ना मान लई, और मना नाय करी, और कही “मैं मसीह ना हौं।” ");
INSERT INTO thr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तौ बे बासे पूँछीं, “तौ फिर तैं कौन है? का तैं एलिय्याह भविस्यवक्ता है?” यूहन्ना कही, “मैं नाय हौं।” “का तैं बौ भविस्यवक्ता है?” बौ जबाब दई, “ना।” ");
INSERT INTO thr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तौ बे बासे पूँछीं, “फिर तैं है कौन? ताकी हम अपने भेजन बारेन कै जबाब देमैं। तैं अपने बारे मैं का कहथै?” ");
INSERT INTO thr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","यूहन्ना कही, “जैसो यसायाह भविस्यवक्ता कही है, ‘मैं रेगिस्तान मैं एक बुलान बारे की अबाज हौं, कि तुम प्रभु की रहा सीधी करौ!’” ");
INSERT INTO thr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","बे फरीसियन के घाँईं से भिजबाए गै खबर लेन बारे रहैं। ");
INSERT INTO thr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","बे यूहन्ना से जौ पूँछीं, “कि अगर तैं मसीह नाय है, और ना तैं एलिय्याह है, और न तैं भविस्यवक्ता है, तौ फिर तैं बपतिस्मा काहे देथै?” ");
INSERT INTO thr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यूहन्ना बाकै जबाब दई, “मैं तौ पानी से बपतिस्मा देथौं, लेकिन एक आदमी तुमरे बीच मैं ठाड़ो है, जोकै तुम नाय जानथौ। ");
INSERT INTO thr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","मतलब कि जो मेरे बाद आनबारो है, बाकी मैं जूता कि तनी खोलनौ के लायक ना हौं।” ");
INSERT INTO thr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","जे बातैं यरदन नदिया के बौ पाँजर बैतनिय्याह मैं भईं, जहाँ पर यूहन्ना बपतिस्मा देत रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दुसरे दिन यूहन्ना ईसु कै अपने घाँईं आत भौ देखी, और कही “देखौ, जौ परमेस्वर को मेम्ना है और जौ दुनिया के पापन कै दूर करथै। ");
INSERT INTO thr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","जौ बहे है जोके बारे मैं, मैं कहो रहों, ‘एक आदमी मेरे पच्छू आए रौ है जो महुँ से महान है, काहैकि बौ मोसे पहले रहै।’ ");
INSERT INTO thr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","मैं तौ बाकै जानतै नाय रहों, पर मैं जहे ताहीं पानी से बपतिस्मा देत आओ हौं ताकी इस्राएल के आदमी बाकै जान लेमैं।” ");
INSERT INTO thr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","और यूहन्ना जौ गभाई दई, “मैं पवित्र आत्मा कै कबूतर के भेस मैं आसमान से उतरत भौ देखो, और पवित्र आत्मा कै बाके ऊपर बैठत भइ देखो। ");
INSERT INTO thr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","मैं तौ बाकै जानतै ना रहों, पर जो मोकै पानी से बपतिस्मा देन ताहीं भेजी रहै, बहे मोसे कही रहै, कि जोके ऊपर तैं पवित्र आत्मा कै उतरत भइ और बाके ऊपर ठैहरथ भइ देखै, बहे पवित्र आत्मा से बपतिस्मा देन बारो है। ");
INSERT INTO thr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","यूहन्ना कही, मैं देखो हौं, गभाई दौ हौं कि जहे परमेस्वर को लौड़ा है।” ");
INSERT INTO thr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दुसरे दिन यूहन्ना और बाके दुई चेला ठाड़े रहैं। ");
INSERT INTO thr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","और यूहन्ना ईसु कै, झोने आत भइ देखकै कही, “देखौ, जौ परमेस्वर को मेम्ना है।” ");
INSERT INTO thr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","तौ बे दोनों चेला यूहन्ना की जे बात सुनकै ईसु के पच्छू चल दईं। ");
INSERT INTO thr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ईसु मुड़कै उनकै पच्छू आत भौ देखी और उनसे कही, “तुम कौनकै ढूँड़ रै हौ?” बे ईसु कै जबाब दईं, “गुरुजी, तैं कहाँ पर रहथै?” ");
INSERT INTO thr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ईसु उनसे कही, “आबौ, और देखौ।” तौ बे जाएकै ईसु की रहन बारी जघा कै देखीं, और बौ दिन ईसु के संग रहीं। काहैकि लमसम संजा के चार बज चुके रहैं। ");
INSERT INTO thr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","बे दोनों मैं से, जो यूहन्ना की बात सुनकै ईसु के पच्छू हुई लईं रहैं, उनमैं से एक सिमौन पतरस को भईय्या अन्द्रियास रहै। ");
INSERT INTO thr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","बौ पहले अपने सगे भईय्या सिमौन से मिलकै बासे कही, “हमकै मसीह मिलगौ है।” ");
INSERT INTO thr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","बौ बाकै ईसु के झोने लाई, ईसु बाके घाँईं देखकै कही, “तैं यूहन्ना को लौड़ा पतरस सिमौन है, तैं कैफा मतलब पतरस कहो जागो।” ");
INSERT INTO thr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दुसरे दिन ईसु गलील कै जान की सोची, बौ फिलिप्पुस से मिलकै कही, “मेरे हुई ले।” ");
INSERT INTO thr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस, अन्द्रियास और पतरस बैतसैदा सहर के रहन बारे रहैं। ");
INSERT INTO thr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुस, नतनएल से मिलो और बासे कही, “जो की बात मूसा और भविस्यवक्ता नियम मैं करी है, बौ यूसुफ को लौड़ा, नासरत को ईसु है।” ");
INSERT INTO thr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएल बासे कही, “कछु अच्छी चीजौ नासरत से निकर सकथै का?” फिलिप्पुस बासे कही, “चलकै देखले।” ");
INSERT INTO thr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ईसु नतनएल कै अपने घाँईं आत भौ देखकै कही, “देखौ, जौ सच्ची मैं इस्राएली है, जाके भीतर कपट नाय है?” ");
INSERT INTO thr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएल ईसु से कही, “तैं मोकै कैसे जानथै?” ईसु बाकै जबाब दई, “फिलिप्पुस के बुलान से पहले, तैं अंजीर के रूखा के तरे रहै, तहिये मैं तोकै देखो रहों।” ");
INSERT INTO thr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएल फिर ईसु से कही, “गुरुजी, तैं परमेस्वर को लौड़ा है, तैं इस्राएल को राजा है।” ");
INSERT INTO thr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ईसु बाकै जबाब दई, “मैं तोसे कहो हौं, कि मैं तोकै अंजीर के रूखा के तरे देखो, का तैं तभई बिस्वास करथै तैं जहो से बड़े-बड़े काम देखैगो।” ");
INSERT INTO thr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फिर बासे कही, “मैं तुमसे सच्ची-सच्ची कहथौं कि तुम आसमान कै खुलो भौ, और परमेस्वर के स्वर्गदूतन कै आदमी के लौड़ा के ऊपर उतरत और ऊपर जात भौ देखैगे।” ");
INSERT INTO thr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","फिर दुई दिन बाद गलील के काना सहर मैं एक बिहा रहै; और ईसु कि अईय्या भी हुँआँ रहै। ");
INSERT INTO thr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ईसु और बाके चेला को बिहा मैं न्युतो रहै। ");
INSERT INTO thr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जब बौ बिहा मैं दाखरस निपट गौ, तौ ईसु की अईय्या बासे कही, “उनके झोने दाखरस निपट गौ है।” ");
INSERT INTO thr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ईसु बासे कही “तैं मोकै मत बताबै कि मोकै का करने है, अभै मेरो समय नाय आओ है।” ");
INSERT INTO thr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ईसु की अईय्या सेवकन से कही, “जो कछु बौ तुमसे कहबै, बहे करियो।” ");
INSERT INTO thr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","हुँआँ पर यहूदियन कै सुद्धिकरन के ताहीं, उनके रीत-रबईय्या के हानी, पथरा के छै घल्ला धरे रहैं, जोके भीतर लमसम सौ लीटर अपात रहैं। ");
INSERT INTO thr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ईसु उनसे कही, “घल्ला मैं पानी भर देबौ,” तौ बे घल्‍लन कै डबाडब भर दईं। ");
INSERT INTO thr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ईसु उनसे कही, “अब निकारकै बिहा को पधान के झोने लै जाबौ”, और बे लैकै गै। ");
INSERT INTO thr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जब बिहा को बौ पानी पधान चखी जो दाखरस बन गौ रहै, और बाकै जहे मालुम नाय रहै कि जौ कहाँ से आई है (पर जो सेवक रहैं, उनकै जौ मालुम रहै, कि जौ पानी है) तौ बिहा को पधान दुल्हा कै बुलाएकै कही, ");
INSERT INTO thr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“हर आदमी पहले अच्छी दाखरस देथै, और जब लोग पीकै छक जाथैं, तौ थोड़ी मद्दी देथैं, पर तैं तौ अच्छी दाखरस अभैले धरे पड़े है।” ");
INSERT INTO thr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ईसु गलील देस के काना सहर मैं अपनो पहलो चिन्ह दिखाए कै अपनी महिमा दिखाई और बाके‍ चेला बाके ऊपर बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","जाके बाद, ईसु और बाकी अईय्या, बाको भईय्या, और बाके चेला कफरनहूम सहर कै गै और हूँना थोड़ी दिन रुके। ");
INSERT INTO thr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदियन को फसह को त्योहार आनबारो रहै, और ईसु यरूसलेम कै गौ। ");
INSERT INTO thr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","बौ मंदिर मैं बरधा, भेंड़ और कबूतर कै बेचन बारे और रुपईया अदला बदली करन बारेन कै बैठे देखी। ");
INSERT INTO thr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तौ ईसु रस्सी को कोड़ा बनाये कै, सब भेंड़ और बरधन कै मंदिर से निकार दई, और रुपईया बदलन बारेन की सब रुपईया बखेर दई, और उनकी बैठन बारी जघा उलट दई। ");
INSERT INTO thr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","और कबूतर बेचन बारेन से कही, “इनकै हींना से लै जाबौ, मेरे परमेस्वर दऊवा के घर कै ब्यापार को घर मत बनाबौ।” ");
INSERT INTO thr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तौ बाके चेलन कै समक मैं आई कि लिखो है, “तेरे घर की धुन मोकै राख कर देगी।” ");
INSERT INTO thr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","जे सब देखकै यहूदि नेता बासे कहीं, “तैं जो जौ कर्‌रौ है जौ करन को अधिकार तोकै है तौ हमकै कोई चिन्ह दिखा?” ");
INSERT INTO thr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ईसु उनकै जबाब दई, “जौ मंदिर कै उजाड़ देबौ, और मैं जाकै तीन दिन मैं ठड़बाए देंगो।” ");
INSERT INTO thr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदि नेता कहीं, “जौ मंदिर कै बनान मैं छियालिस साल लगे हैं, और का तैं जाकै तीन दिन मैं ठड़बाए देबैगो?” ");
INSERT INTO thr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ईसु जो मंदिर के बारे मैं कहत रहै बौ अपनी सरीर के बारे मैं कही रहै। ");
INSERT INTO thr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","और जब ईसु मुर्दन मैं से जी उठो तौ बाके चेलन कै समक मैं आओ कि ईसु ऐसो कही रहै; और सास्त्रन मैं और ईसु कि बात मैं बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जब बौ यरूसलेम मैं फसह के समय, त्योहार मैं रहै, तौ निरे जनी बे चिन्ह जो ईसु दिखात रहै, देखकै बाके नाओं मैं बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","लेकिन ईसु अपने आपकै उनके भरोसे नाय छोड़ी, काहैकि बौ सबकै जानत रहै; ");
INSERT INTO thr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ईसु कै जौ बात की कोई जरूरत नाय रहै कि कोई आयकै बाकै इंसानन के बारे मैं गभाई बताबै, काहैकि इंसानन के मन मैं का है, जौ बौ जानत रहै। ");
INSERT INTO thr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसियन मैं नीकुदेमुस नाओं को एक आदमी रहै, जो यहूदियन को मुखिया रहै। ");
INSERT INTO thr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","बौ रात मैं ईसु के झोने आयकै बासे कही, “गुरुजी, हम जानथैं कि तैं परमेस्वर की घाँईं से गुरु बनकै आओ है, कोई जे चिन्ह और चमत्कार, ना दिखाए सकथै जबले परमेस्वर बाके संग नाय होबै।” ");
INSERT INTO thr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ईसु बाकै जबाब दई, “मैं तोसे सच-सच कहथौं, अगर कोई नये सिरे से नाय जनमैं, तौ बौ परमेस्वर के राज्य कै नाय देख सकथै।” ");
INSERT INTO thr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस बासे कही, “इंसान अगर बुढ़रा हुई जाए तौ कैसे दुबारा पैदा हुई सकथै? का बौ अपनी अईय्या की कोक मैं दुसरी बार जाएकै पैदा ना हुई सकथै!” ");
INSERT INTO thr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ईसु जबाब दई, “मैं तोसे सच्ची-सच्ची कहथौं, जबले कोई इंसान पानी और आत्मा से नाय जनमैं, तौले बौ परमेस्वर के राज्य मैं नाय जाए सकथै। ");
INSERT INTO thr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","काहैकि जो सरीर से जनमों बौ सरीर है; और जो आत्मा से जनमों, बौ आत्मा है। ");
INSERT INTO thr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","अचम्मो मत होबै कि मैं तोसे कहो, ‘कि तोकै नये सिरे से जनम लेनो जरूरी है।’ ");
INSERT INTO thr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ब्यार जितै चाहथै उतै चलथै और तैं बाकी अबाज सुनथै, लेकिन नाय जानथै कि बौ कहाँ से आथै, और कहाँ जाथै? और जो कोई आत्मा से पैदा भौ है, बौ ऐसिये है,” ");
INSERT INTO thr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुस बाकै जबाब दई, “जौ बात कैसे हुई सकथै?” ");
INSERT INTO thr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","जौ सुनकै ईसु बासे कही, “इस्राएलियन को गुरु हुईकै भी का जे बातन कै नाय जानथै?” ");
INSERT INTO thr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मैं तोसे सच्ची-सच्ची कहथौं कि जो हम जानथैं बौ हम कहथैं, और जोकै हम देखे हैं बाकी गभाई देथैं, और तुम हमरी गभाई मानतै नाय हौ। ");
INSERT INTO thr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जब मैं तुमसे जौ पृथ्वी की बात करो, और तुम बिस्वास नाय करै, तौ अगर मैं तुमसे स्वर्ग की बात कहेंगो, तौ फिर कैसे बिस्वास करैगे? ");
INSERT INTO thr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","कोई आसमान मैं नाय चढ़ो है, खाली बहे जो स्वर्ग से उतरो है, मतलब आदमी के लौड़ा जो स्वर्ग मैं है। ");
INSERT INTO thr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","और जैसी मूसा जंगल मैं साँप कै ऊँचे मैं चढ़ाई, बैसिये जरूरी है कि आदमी को लौड़ा ऊँचे मैं चढ़ाओ जाबै। ");
INSERT INTO thr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताकी जो कोई बाके ऊपर बिस्वास करै, बौ अनंत जिंदगी पाबै। ");
INSERT INTO thr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“काहैकि परमेस्वर जौ दुनिया से ऐसो प्यार करी कि बौ अपनो इकलौतो लौड़ा दै दई, ताकी जो कोई बाके ऊपर बिस्वास करै, बौ नास ना होबै, बल्किन अनंत जिंदगी पाबै। ");
INSERT INTO thr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","परमेस्वर अपने लौड़ा कै जौ दुनिया मैं जाके ताहीं नाय पनारी, कि बौ दुनिया मैं न्याय करै, बल्किन जाके ताहीं पनारी कि जौ दुनिया मैं बाके जरिये उद्धार पामैं। ");
INSERT INTO thr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जो बाके ऊपर बिस्वास करथै, बाकै बाके ऊपर न्याय करन की आग्या नाय है, पर जो बाके ऊपर बिस्वास नाय करथै, बौ दोसी ठहर चुको है; जाकेमारे कि बौ परमेस्वर के इकलौते बालका के नाओं मैं बिस्वास ना करी। ");
INSERT INTO thr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","और जौ न्याय की बजह जौ है कि जोती जौ दुनिया मैं आई है, और इंसान अंधियारे कै जोती से अगरो प्यार करीं, काहैकि बाके काम बुरे रहैं। ");
INSERT INTO thr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","काहैकि जो कोई बुराई करथै, बहे जोती से बैर रखथै, और जोती के झोने नाय जाथै, ऐसो नाय होबै कि बाके काम मैं इल्जाम लगाओ जाबै। ");
INSERT INTO thr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","लेकिन जो सच्चाई मैं चलथै, बहे जोती झोने आथै, ताकी बाके काम दिखामै, कि बौ परमेस्वर की घाँईं से करो गौ है।” ");
INSERT INTO thr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","जाके बाद ईसु और बाके चेला यहूदिया देस मैं आए; और बौ हूँना उनके संग रहकै बपतिस्मा देन लगो। ");
INSERT INTO thr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्ना सालेम सहर के झोने ऐनोन नाओं की जघा मैं बपतिस्मा देत रहै, काहैकि हुँआँ गजब पानी रहै, और सब जनी आयकै बपतिस्मा लेत रहैं। ");
INSERT INTO thr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","और बौ समय यूहन्ना कैदखाना मैं नाय गौ रहै। ");
INSERT INTO thr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","हुँआँ यूहन्ना के चेलन की कोई यहूदि के संग सुद्धिकरन के बारे मैं जिरहबाजी हुई गई। ");
INSERT INTO thr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","और बे यूहन्ना के झोने आयकै बासे कहीं, “गुरुजी, जो आदमी यरदन नदिया के पार तेरे संग रहै, और जोकी तैं गभाई दौ है; देख, बौ तौ बपतिस्मा देथै, और सब बाके झोने जाथैं!” ");
INSERT INTO thr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्ना बाकै जबाब दई, “जबले इंसान कै आसमान से ना दौ जाबै, तौले बाकै कछु ना मिल सकथै। ");
INSERT INTO thr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुम तौ खुद मेरे गभा हौ, मैं कहो हौं, ‘कि मैं मसीह ना हौं, लेकिन बासे अग्गु भेजो गौ हौं।’ ");
INSERT INTO thr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","जो की दुल्हेन है, बहे दुल्हा है, लेकिन दुल्हा को दोस्त जो ठाड़कै बाकी सुनथै, दुल्हा के बोल से बड़ा खुसी होथै; अब मेरी खुसी पूरी भइ है। ");
INSERT INTO thr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","जरूरी है कि बौ बढ़ै और मैं घटौं।” ");
INSERT INTO thr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“जो ऊपर से आथै बौ महान है, और जो धरती से है, बौ धरती से जुड़ो है, जहे ताहीं बौ धरतीए की बात करथै, जो आसमान से आथै, बहे सबके ऊपर है। ");
INSERT INTO thr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","जो कछु बौ देखी और सुनी है, बहे की गभाई देथै; और कोई बाकी गभाई ना अपनाथै। ");
INSERT INTO thr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जो बाकी गभाई कै अपनाय लेथै, बौ जौ बात मैं छाप लगाए देथै कि परमेस्वर सच्चो है। ");
INSERT INTO thr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","काहैकि जोकै परमेस्वर भेजी है, बौ परमेस्वर के बचन कै कहथै, काहैकि बौ आत्मा नाप-नाप कै नाय देथै। ");
INSERT INTO thr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","दऊवा अपने बालक से प्यार करथै, और बौ सब चीज बाके हाथ मैं सौंप दई है। ");
INSERT INTO thr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जो लौड़ा के ऊपर बिस्वास करथै, अनंत जिंदगी बाकी है; लेकिन जो लौड़ा की नाय मानथै, बौ जिंदगी कै ना देखैगो, और परमेस्वर की सजा बाके ऊपर रहथै।” ");
INSERT INTO thr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","फिरौंकी जब प्रभु ईसु कै जौ बात पता चली, कि फरीसी जौ सुनी हैं कि ईसु यूहन्ना से जद्धे चेला बनाथै और उनकै बपतिस्मा देथै। ");
INSERT INTO thr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","लेकिन ईसु खुद नाय बल्किन बाके चेला बपतिस्मा देत रहैं, ");
INSERT INTO thr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तौ ईसु यहूदिया कै छोड़कै फिर से गलील देस कै चले गौ, ");
INSERT INTO thr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","और बाकै सामरिया से हुईकै जानो जरूरी रहै। ");
INSERT INTO thr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","बौ सूखार नाओं के सामरिया के एक सहर तक आओ, जो कि बहे जघा के झोने रहै जो याकूब अपने लौड़ा यूसुफ कै दई रहै। ");
INSERT INTO thr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","हुँआँ याकूब को कुआँ रहै। ईसु रहा को थको भौ कुआँ के झोने ऐसिये बैठगौ। जौ बात लमसम दुपारी की बेरा रहै। ");
INSERT INTO thr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","इत्ते मैं एक सामरिया की एक बईय्यर पानी भरन कै आई। ईसु बासे कही, “मोकै पानी पिबा।” ");
INSERT INTO thr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","का है की बाके चेला बौ समय सहर मैं खानु लेन कै गै रहैं। ");
INSERT INTO thr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","बौ सामरी बईय्यर बासे कही, “तैं यहूदि हुईकै मोसे पानी काहेकै माँग रौ है?” काहैकि यहूदि सामरियन के संग कैसियो बोलचाल नाय रखथैं। ");
INSERT INTO thr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ईसु बाकै जबाब दई, “अगर तैं परमेस्वर के वरदान कै जानती, और जहो जानती कि बौ कौन है जो तोसे कहरौ है, ‘कि मोकै पानी पिबा’ तौ तैं बासे माँगती, और बौ तोकै जिंदगी को पानी देतो।” ");
INSERT INTO thr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","बौ बईय्यर बासे कही, “हे प्रभु, तेरे झोने तौ पानी भरन ताहीं कछु हईये नाय, और कुआँ गहरो है; तौ फिर बौ जिंदगी को पानी तेरे झोने कहाँ से आओ? ");
INSERT INTO thr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","का तैं हमरे बाबा याकूब से बड़ो है? बौ हमकै जौ कुआँ दई है; और खुदै अपने बालकन, और अपने जानवरन समेत बामै पानी पीथैं?” ");
INSERT INTO thr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ईसु बाकै जबाब दई, “जो कोई जौ पानी पीबैगो बौ फिर से प्यासो होबैगो, ");
INSERT INTO thr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","लेकिन जो कोई बौ पानी मैं से पीबैगो जोमैं बाकै दुंगो, बौ फिर कहु ना प्यासो होबैगो; और जो पानी मैं बाकै दुंगो, बौ बामै एक सोता बन जाबैगो, जो अनंत जिंदगी ले उमड़त रहगो।” ");
INSERT INTO thr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","बईय्यर बासे कही, “प्रभु, बौ पानी मोकै दैदे ताकी मैं प्यासी ना होमौं, और ना इतनी दूर पानी भरन कै आमौं।” ");
INSERT INTO thr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ईसु बासे कही, “जा, अपने आदमी कै हींना बुलाए ला।” ");
INSERT INTO thr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","बौ बईय्यर कही, “मैं बिना लोगा की हौं।” ईसु बासे कही, “तैं सई कह रइ है, ‘कि तैं बिना आदमी की हौं।’ ");
INSERT INTO thr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","और तैं पाँच आदमी कर चुकी है, और जोके झोने तैं हबै है बहो तेरो आदमी नाय है, जौ तैं सच्ची कहो है।” ");
INSERT INTO thr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","बईय्यर बासे कही, “हे प्रभु, मोकै लगथै कि तैं भविस्यवक्ता है।” ");
INSERT INTO thr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“हमरे सामरी बापदादो जहे पहाड़ मैं आराधना करीं और तैं कहथै कि बौ जघा जहाँ आराधना करनो चाहिए यरूसलेम मैं है।” ");
INSERT INTO thr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ईसु बासे कही, “हे बईय्यर, मेरी बात को बिस्वास कर कि बौ समय आनबारो है कि तुम ना तौ जौ पहाड़ मैं दऊवा की आराधना करैगे, और ना यरूसलेम मैं। ");
INSERT INTO thr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुम सामरी जोकै ना जानथौ, बाको आराधना करथौ; और हम जोकै जानथैं, बाको आराधना करथैं; काहैकि उद्धार यहूदि मैं से है। ");
INSERT INTO thr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","लेकिन बौ समय आए रौ है, और अभईयो है, जोमैं सच्चे भक्त दऊवा की आराधना आत्मा और सच्चाई से करंगे, काहैकि दऊवा अपने ताहीं ऐसिये सभाघर करन बारे कै ढूँड़थै। ");
INSERT INTO thr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेस्वर आत्मा है, और जरूरी है की बाकी आराधना करन बारे आत्मा और सच्चाई से सभाघर करैं।” ");
INSERT INTO thr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","बौ बईय्यर बासे कही, “मैं जानथौ कि मसीह जो ख्रिस्त कहो जाथै, आनबारो है; जब बौ आगो, तौ हमकै सब बात बताए देगो।” ");
INSERT INTO thr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ईसु बासे कही, “मैं जो तोसे कहरौ हौं।” ");
INSERT INTO thr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","इत्ते मैं बाके चेला आए गै, और अचम्मो मानन लागे कि बौ बईय्यर से बतकाए रौ है; फिर भी कोई कछु नाय पूँछी, “कि तैं का चाहथै? या फिर काहेकै तैं बासे बतकाए रौ है?” ");
INSERT INTO thr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तौ बौ बईय्यर अपनो घल्ला छोड़कै सहर मैं चली गई, और सब जनी से कहेन लगी, ");
INSERT INTO thr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“आबौ, एक इंसान कै देखौ, जो कि सब कछु, जोमैं करो हौं मोकै बताए दई। कहूँ जहे तौ मसीह ना है?” ");
INSERT INTO thr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","और बे सब जनी सहर से निकर-निकरकै ईसु के झोने आन लागे। ");
INSERT INTO thr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","इतने मैं बाके चेला बासे नहोरे करन लागे, “गुरुजी, कछु खाए ले।” ");
INSERT INTO thr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","फिर ईसु उनसे कही, “मेरे झोने खान ताहीं ऐसो खानु है जोकै तुम ना जानथौ।” ");
INSERT INTO thr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तौ बाके चेला आपस मैं बतकाईं, “का कोई बाके ताहीं कछु खान ताहीं लाई है?” ");
INSERT INTO thr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ईसु उनसे कही, “मेरो खानु जौ है, कि अपने भेजन बारे के मन से चलौं और बाको काम पूरो करौं। ");
INSERT INTO thr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","का तुम ना कहथौ, ‘काटन ताहीं अभईयो चार महेना पड़े हैं,’ देखौ, मैं तुमसे कहथौं, अपनी आँखी उठाएकै खेतन घाँईं देखौ कि बे काटन के ताहीं पक गै हैं! ");
INSERT INTO thr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","काटन बारे कै दिहाड़ी मिलथै और अनंत जिंदगी के ताहीं फल बटोरथै, ताकी बोन बारो और काटन बारो दोनों मिलकै खुसी मनामैं। ");
INSERT INTO thr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","काहैकि हिंयाँ पर जौ कहाबत सच बैठथै, कि ‘बोन बारो दुसरो है, और काटन बारो दुसरो।’ ");
INSERT INTO thr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मैं तुमकै बौ खेत काटन ताहीं भेजो जोमैं तुम मेहेनतै ना करे; दुसरे जनी मेहनत करीं और उनकी मेहनत के फल मैं भागी भै।” ");
INSERT INTO thr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","और बौ सहर के गजब सामरिया बौ बईय्यर के कहने मैं ईसु के ऊपर बिस्वास करीं; काहैकि बौ जौ गभाई दई रहै, “कि बौ सब कछु जोमैं करो हौं, मोकै बताए दई है।” ");
INSERT INTO thr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","जे सब बात सुनकै सामरी ईसु झोने आए, और बासे नहोरे करन लगे कि हमरे हिंयाँ पर रुकले, और ईसु हुँआँ पर दुई दिन तक रुको। ");
INSERT INTO thr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ईसु के बचन की बजह से और गजब जनी बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","और बौ बईय्यर से कही, “अब हम तेरे कहेन सेई बिस्वास ना करथै; काहैकि हम खुदै सुन लै, और जानथैं कि जहे सच्ची मैं जौ दुनिया को उद्धारकर्ता है।” ");
INSERT INTO thr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","फिर दुई दिन के बाद ईसु हुँआँ से निकरकै गलील देस कै गौ। ");
INSERT INTO thr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","काहैकि ईसु अपने आपै अपनी गभाई दई रहै कि “भविस्यवक्ता अपनेई देस मैं इज्जत नाय पाथैं।” ");
INSERT INTO thr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जब ईसु गलील मैं आओ, तौ गलील के रहन बारे खुसी से बासे मिले; काहैकि जितने काम बौ यरूसलेम मैं त्योहार के समय करी रहै, बे बौ सब कामन कै देखीं रहैं। ");
INSERT INTO thr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तौ ईसु फिर गलील के काना सहर मैं आओ, जहाँ बौ पानी कै दाखरस बनाई रहै। हुँआँ पर राजा को एक करमचारी रहै जोको लौड़ा कफरनहूम मैं बिमार रहै। ");
INSERT INTO thr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","बौ जौ सुनकै कि ईसु यहूदिया से गलील मैं आए गौ है, बाके झोने गौ और ईसु से नहोरे करन लगो कि चलकै मेरे लौड़ा कै अच्छो कर दे, बौ कतई मरन मैं है। ");
INSERT INTO thr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ईसु बासे कही, “जबले तुम चिन्ह और अचम्मे काम ना देखैगे तौले तुम कतई बिस्वास ना करैगे।” ");
INSERT INTO thr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","राजा को करमचारी ईसु से कही, “प्रभु, मेरे लौड़ा के मरन से पहले तैं चल।” ");
INSERT INTO thr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ईसु बासे कही, “जा, तेरो लौड़ा जिंदो है!” बौ आदमी ईसु की कही बात मैं बिस्वास करी और चले गौ। ");
INSERT INTO thr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","बौ रहामैं रहै तभई बाके सेवक बासे आयकै मिले और कहेन लागे, “तेरो बालक जिंदो है!” ");
INSERT INTO thr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","बौ उनसे पूँछी, “कौन से समय मैं मेरो लौड़ा अच्छो होन लागो रहै?” बे बासे कहीं “कल दुपारी एक बजे घाँईं बाको बुखार उतर गौ रहै।” ");
INSERT INTO thr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तौ बाको बाबा जानगौ कि जौ बहे समय रहै, जो समय ईसु मोसे कही रहै, “कि तेरो लौड़ा जिंदो है,” फिर बौ और बाके पूरे घर के बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","जौ ईसु को दुसरो अदभुत चिन्ह रहै, जो कि ईसु यहूदिया से गलील मैं आयकै दिखाई। ");
INSERT INTO thr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","जे सब बातन के थोड़ी दिन के बाद यहूदियन को एक त्योहार आओ, और ईसु यरूसलेम कै गौ। ");
INSERT INTO thr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूसलेम मैं भेंड़-फाटक के झोने एक डबरा है, जो कि इब्रानी भासा मैं बैतसैदा कहो जाथै; बाके किनारे-किनारे पाँच डेहरी हैं। ");
INSERT INTO thr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","जोमैं तमान बिमार, और अंधरा, लंगड़ा और सूखे अंग बारे पानी हालन की आस मैं पड़े रहथैं। ");
INSERT INTO thr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","काहैकि कोई एक समय मैं परमेस्वर के स्वर्गदूत तलऊआ मैं उतरकै पानी कै हलाए करत रहैं, पानी हालत खिना कि जो कोई पहले घुसतो बहे अच्छो हुई जात रहै चाँहे बाकै कैसियो बिमारी होबै। ");
INSERT INTO thr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","हुँआँ एक आदमी रहै, जो अड़तीस साल से बिमारी मैं पड़ो रहै। ");
INSERT INTO thr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ईसु बाकै पड़ो भौ देखकै और जौ कि बौ गजब दिन से ऐसी हालत मैं पड़ो है, बासे पूँछी, “का तैं अच्छो होनो चाहथै?” ");
INSERT INTO thr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","बौ बिमार आदमी बासे कही, “प्रभु, मेरे झोने कोई आदमी नाय है कि जब पानी हलाओ जाथै, तौ कोई मोकै डबरा मैं उतारै; और मेरे पुगते-पुगते, दुसरो मोसे पहले उतर जाथै।” ");
INSERT INTO thr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ईसु बासे कही, “उठ, अपनी खटिया उठा, और चल फिर।” ");
INSERT INTO thr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","बौ आदमी तुरंतै अच्छो हुई गौ, और अपनी खटिया उठाएकै चलन फिरन लग्गौ। जो दिन जौ भौ बौ साबत को दिन रहै। ");
INSERT INTO thr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","बौ साबत को दिन रहै, इसलै यहूदि बासे जो अच्छो भौ रहै, कहेन लागे, “आज तौ साबत को दिन है, तोकै खटिया उठानो हमरे नियम के खिलाप है।” ");
INSERT INTO thr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","बौ उनकै जबाब दई, “जो मोकै अच्छो करी है, बहे मोसे कही है, अपनी खटिया उठा, और चल फिर।” ");
INSERT INTO thr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","बे बासे पूँछीं, “बौ कौन आदमी है जो तोसे कही, कि खटिया उठा, और चल फिर?” ");
INSERT INTO thr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","लेकिन जो अच्छो हुई गौ रहै बौ ईसु कै नाय जानत रहै कि बौ कौन है, और बौ जघा मैं भीड़ होन की बजह से ईसु हुँआँ से हट गौ रहै। ");
INSERT INTO thr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","जे सब बात होन के बाद बौ ईसु कै मंदिर मैं मिलो, और ईसु बासे कही, “देख, तैं अच्छो हुई गौ है; फिर से पाप मत करिये, ऐसो नाय होबै कि जासे कोई बड़ी आफत तेरे ऊपर आए जाबै।” ");
INSERT INTO thr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","बौ आदमी जाएकै यहूदि अधिकारिन से कह दई कि जो मोकै अच्छो करी है, बौ ईसु है। ");
INSERT INTO thr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","जहे बजह से यहूदि ईसु कै सतान लागे, काहैकि बौ ऐसे काम साबत के दिन करत रहै। ");
INSERT INTO thr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","जौ बात मैं ईसु उनसे कही, “मेरो दऊवा हबै तक काम करथै, और महुँ काम करथौं।” ");
INSERT INTO thr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","जौ बजह से यहूदि औरौ बाकै मार डारन की कोसिस करन लगे, काहैकि बौ खाली साबत के दिनै बाको नियम तोड़त रहै, जाके संग बौ परमेस्वर कै अपनो दऊवा कहकै अपने आपकै परमेस्वर के बराबर मानत रहै। ");
INSERT INTO thr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","जौ बात मैं ईसु उनसे कही, “मैं तुमसे सच-सच कहथौ, लौड़ा अपने आप कछु नाय कर सकथै, खाली बहे जो अपने दऊवा कै करत भौ देखथै; काहैकि जो-जो काम बौ करथै उनकै लौड़ा बैसिये करथै। ");
INSERT INTO thr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","काहैकि दऊवा अपने लौड़ा से प्यार करथै और जो-जो काम बौ अपने आप करथै, बौ सब बाकै दिखाथै; और बौ इन्हँऊ से बड़े काम बाकै दिखागो, ताकी तुम अचम्मो मानौं। ");
INSERT INTO thr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","काहैकि जोसे दऊवा मरे भैन कै उठाथै और जिंदो करथै, बैसिये लौड़ौ जोकै चाहथै उनकै जिंदो करथै। ");
INSERT INTO thr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","दऊवा कोई के परखत नाय है, पर न्याय करन को सब काम लौड़ा कै सौंप दई है। ");
INSERT INTO thr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","कि सब जनी जैसो दऊवा को आदर करथैं बैसिये लौड़ौ को आदर करैं, जो लौड़ा को आदर नाय करथै, बौ बाबा को जो कि बाकै भेजी है, आदर नाय करथै।” ");
INSERT INTO thr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मैं तुमसे सच-सच कहथौं, जो मेरो बचन सुनकै मेरे भेजन बारे के ऊपर बिस्वास करथै, अनंत जिंदगी बाकी है; और बाकै न्याय की आग्या नाय मिलथै, और बौ मरन से पार हुईकै अनंत जिंदगी मैं जाए चुको है। ");
INSERT INTO thr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","मैं तुमसे सच-सच कहथौं बौ समय आए गौ है, और अभै है, जहे बजह से मरे भै परमेस्वर के लौड़ा की अबाज सुनंगे, और जो सुनंगे बे जिंदे होमंगे। ");
INSERT INTO thr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","काहैकि जैसे दऊवा अपने आप मैं जिंदगी रखथै, बैसिये अपने लौड़ा कै जो अधिकार दई है कि अपने आप मैं जिंदगी रखै; ");
INSERT INTO thr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","जहे संग बाकै न्याय करनौ को अधिकार दई है, जहे ताहीं कि बौ आदमी को लौड़ा है। ");
INSERT INTO thr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","जासे अचम्मे मत होबौ; काहैकि बौ समय आए रहो है कि जितने मुर्दा कबर मैं हैं बे बाकी बोली सुनकै निकर आंगे। ");
INSERT INTO thr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जो भले काम करीं हैं बे जिंदगी के ताहीं मरकै जी उठंगे, और जो बुरे काम करीं हैं बे न्याय पान ताहीं उनको पुनरुत्थान होगो। ");
INSERT INTO thr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“मैं अपने आप से कछु नाय कर सकथौं; जैसो सुनथौं, बैसो परखथौं, और मेरो न्याय धर्मी है, काहैकि मैं अपनी मरजी से नाय, बल्कि अपने भेजन बारे की मरजी चाहथौ। ");
INSERT INTO thr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","और अगर मैं खुदै अपनी गभाई देथौं, तौ मेरी गभाई सच्ची ना है। ");
INSERT INTO thr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","एकौर है जो मेरी गभाई देथै, और मैं जानथौं कि मेरी गभाई जो बौ देथै, बौ सच्ची है। ");
INSERT INTO thr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुम यूहन्ना से पुछबाए और बौ सच्चाई की गभाई दई है। ");
INSERT INTO thr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","पर मैं अपने बारे मैं इंसानन की गभाई नाय चाहथौं; तहुँओं जे बात जौ ताहीं कहथौं कि तुमकै उद्धार मिलै। ");
INSERT INTO thr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","बौ तौ जलत भौ और चमकत भौ दिया रहै, और तुमकै थोड़ी देर ताहीं बाके उजियारे मैं मगन होनो अच्छो लागो। ");
INSERT INTO thr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पर मेरी जो गभाई है, बौ यूहन्ना की गभाई से बड़ी गभाई है: काहैकि जो काम मोकै दऊवा पूरो करन के ताहीं सौंपी है मतलब कि जहे काम जोमैं करथौं, बे मेरे गभा हैं, कि बाबा मोकै पनारी है। ");
INSERT INTO thr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","और दऊवा जो मोकै पनारी है, बहे मेरी गभाई दई है, तुम ना कहु बाकी अबाज सुने, और नाय बाको मोहों देखे हौ; ");
INSERT INTO thr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","और बाके बचनौ कै मन मैं नाय रखथौ, काहैकि जोकै बौ पनारी है तुम बाको बिस्वास नाय करथौ। ");
INSERT INTO thr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुम सास्त्रन मैं ढूँड़थौ, और समझथौ कि बामै अनंत जिंदगी तुमकै मिलथै; और जौ बहे है, जो मेरी गभाई देथै; ");
INSERT INTO thr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","तहुँओं तुम जिंदगी पान के ताहीं मेरे झोने आनो नाय चाहथौ। ");
INSERT INTO thr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","मैं इंसानन से आदर ना चाहथौं। ");
INSERT INTO thr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पर मैं तुमकै जानथौं, कि तुमरे भीतर परमेस्वर को प्यार ना है। ");
INSERT INTO thr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","मैं अपने दऊवा के नाओं से आओ हौं, और तुम मोकै अपनात नाय हौ; और अगर दुसरो कोई अपने नाओं से आगो, तौ तुम बाकै अपनाय लेगे। ");
INSERT INTO thr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुम जो एक-दुसरे से आदर महिमा चाहथौ और बौ आदर जो अकेलो परमेस्वर के घाँईं से है, बाकै तुम ना चाहथौ, कैसे करकै बिस्वास कर सकथौ? ");
INSERT INTO thr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","जौ मत समझियो कि मैं दऊवा के अग्गु तुमरे ऊपर दोस लगांगो; तुमरे ऊपर दोस लगान बारो तौ मूसा है, जोके ऊपर तुम उमीद रखे पड़े हौ। ");
INSERT INTO thr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","और अगर तुम मूसा के ऊपर बिस्वास करते, तौ मेरियौ ऊपर बिस्वास करते, बौ जहे ताहीं कि बौ मेरे बारे मैं लिखी है। ");
INSERT INTO thr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","और अगर तुम बहोकि लिखी भइ बातन के ऊपर बिस्वास ना करथौ, तौ मेरी बातन के ऊपर बिस्वास कैसे करैगे?” ");
INSERT INTO thr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","जे सब बातन के बाद ईसु गलील की झील मैं यानी तिबिरियुस की झील के बौ पाँजर गौ। ");
INSERT INTO thr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","और एक बड़ी भीड़ बाके पच्छू हुई गई काहैकि बे बिमारन कै ठीक करन को बाके चिन्ह कै देखी रहैं। ");
INSERT INTO thr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","फिरौंकी ईसु पहाड़ मैं चढ़कै अपने चेलन के संग हुँआँ बैठगौ। ");
INSERT INTO thr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","और यहूदियन को फसह को त्योहार झोने आए चुको रहै। ");
INSERT INTO thr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","तौ ईसु अपनी नजर उठाएकै एक बड़ा बड़ी भीड़ कै अपने झोने आत देखी, और फिलिप्पुस से कही, “हम इनके खान ताहीं कहाँ से रोटी मोल लामैं?” ");
INSERT INTO thr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","पर ईसु जौ बात फिलिप्पुस कै परखन ताहीं कही रहै; काहैकि बौ जानत रहै कि बौ का करैगो। ");
INSERT INTO thr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिर फिलिप्पुस ईसु कै जबाब दई, “दुई सौ चाँदी के सिक्कन की रोटिनौ से उनको पूरा नाय पड़ैगो एसियौ ना कि एक-एक जनी कै थोड़ी-थोड़ी मिल जाबै।” ");
INSERT INTO thr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","बाके चेलन मैं से सिमौन पतरस को भईय्या अन्द्रियास ईसु से कही, ");
INSERT INTO thr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“हिंयाँ एक लौड़ा है, बाके झोने जई की पाँच रोटी और दुई मच्छी हैं, पर बासे इत्ते जनी ताहीं का होगो।” ");
INSERT INTO thr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ईसु कही, “सब जनी कै बैठार देयौं।” बौ जघा मैं गजब घाँस रहै। तौ बे सब जनी जो करीबन पाँच हजार रहैं, बैठगै। ");
INSERT INTO thr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तौ ईसु रोटी कै लई, और परमेस्वर कै धन्यवाद करकै बैठन बारेन कै बाँट दई; और बैसिये मच्छी मैं से जित्ती बे चहात रहैं बाँट दईं। ");
INSERT INTO thr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जब बे खाएकै छक गै, तौ बौ अपने चेलन से कही, “बचे भै टुकड़ा बटोर लेबौ, ताकी कछु फेंको ना जाबै।” ");
INSERT INTO thr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","तौ बे बटोरीं, और जई की पाँच रोटिन के टुकड़ा जो खान बारेन से बच गईं रहैं, उनकी बारह छपरिया भरीं। ");
INSERT INTO thr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","तौ जो चिन्ह ईसु करकै दिखाई बौ देखकै सब जनी कहेन लागे; कि “बौ भविस्यवक्ता जो दुनिया मैं आनबारो रहै सचमुच जहे है।” ");
INSERT INTO thr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ईसु जौ जानगौ कि बे बाकै पकड़कै राजा बनानो चाहथैं, फिर ईसु पहाड़ मैं अकेलो चले गौ। ");
INSERT INTO thr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","फिर जब संजा भइ, तौ ईसु के चेला झील के किनारे गै, ");
INSERT INTO thr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","और नईंयाँ मैं चढ़कै झील के पार कफरनहूम कै जान लगे। बौ समय अंधियारो हुई गौ रहै, और ईसु अभै तक उनके झोने नाय आओ रहै। ");
INSERT INTO thr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","और आँधी की बजह से झील मैं लहेर उठन लागीं। ");
INSERT INTO thr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","तौ जब बे चप्पु चलात-चलात पाँच-छै किलो मीटर के लमसम निकर गै, तौ बे ईसु कै झील मैं चलत भै और नईंयाँ के झोने आत भौ देखीं, और बे गजब डराय गै। ");
INSERT INTO thr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पर ईसु उनसे कही, “मैं हौं; डराबौ मत्ती।” ");
INSERT INTO thr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","तौ बे बाकै नईंयाँ मैं चढ़ान ताहीं राजी भै और तुरंतै बौ नईंयाँ बहे डींड़े मैं पुगी जहाँ बे जात रहैं। ");
INSERT INTO thr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","दुसरे दिन बौ भीड़, जो कि झील के दुसरे पाँजर ठाड़ी रहै, जौ देखीं, कि एक कै छोड़कै और कोई छोटी नईंयाँ नाय रहै, और ईसु अपने चेलन के संग बौ नईंयाँ मैं नाय चढ़ो रहै, और खाली बाके चेलै गै रहैं। ");
INSERT INTO thr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तौ फिर और नईंयाँ तिबिरियुस से बौ जघा के झोने आईं, जहाँ बे प्रभु को धन्यवाद करकै रोटी खाईं रहैं। ");
INSERT INTO thr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","जब भीड़ कै पता चलो, कि हिंयाँ पर ना ईसु है, और ना बाके चेला, तौ बेऊँ छोटी-छोटी नईंयाँ मैं बैठकै ईसु कै ढूँड़त भै कफरनहूम मैं पुगे। ");
INSERT INTO thr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","झील के पार जब बे ईसु से मिले तौ बासे कहीं, “गुरुजी, तैं हिंयाँ कब आओ?” ");
INSERT INTO thr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ईसु उनकै जबाब दई, “मैं तुमसे सच-सच कहथौं, तुम मोकै जाके ताहीं नाय ढूँड़ रै हौ कि तुम चिन्ह देखे, पर जहे ताहीं कि तुम रोटिन कै खाएकै छके हौ। ");
INSERT INTO thr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","खतम होन बारे खानु के ताहीं मेहनत मत करौ, पर बौ खानु के ताहीं जो अनंत जिंदगी तक रहथै, जो कि आदमी को लौड़ा तुमकै देगो, काहैकि दऊवा, यानी परमेस्वर बहे के ऊपर छाप लगाई है।” ");
INSERT INTO thr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","बे ईसु से कहीं, “परमेस्वर को काम करन ताहीं हम का करैं?” ");
INSERT INTO thr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ईसु उनकै जबाब दई, “परमेस्वर को काम जौ है, कि तुम जोकै बौ पनारी है, बाके ऊपर बिस्वास करौ।” ");
INSERT INTO thr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तौ बे ईसु से कहीं, “फिर तैं कौन सो चिन्ह दिखाथै कि हम बाकै देखकै तेरे ऊपर बिस्वास करैं? तैं कौन सो काम दिखाथै? ");
INSERT INTO thr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","हमरे बापदादे बन मैं मन्ना खाईं, जैसो लिखो है, ‘बौ उनकै स्वर्ग से खान ताहीं रोटी दई।’” ");
INSERT INTO thr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ईसु उनसे कही, “मैं तुमसे सच-सच कहथौं कि मूसा तुमकै बौ रोटी आसमान से नाय दई, पर मेरो दऊवा तुमकै सच्ची रोटी स्वर्ग से देथै। ");
INSERT INTO thr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","परमेस्वर कि रोटी बौ है जो स्वर्ग से नीचे आथै, और दुनिया कै जिंदगी देथै।” ");
INSERT INTO thr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तौ बे बासे कहीं, “हे प्रभु, जौ रोटी हमकै हमेसा दे करिये।” ");
INSERT INTO thr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ईसु उनसे कही, “जिंदगी की रोटी मैं हौं, जो मेरे झोने आथै बौ कहुए भूंको नाय होगो, और जो मेरे ऊपर बिस्वास करथै बौ कहुए प्यासो ना होगो। ");
INSERT INTO thr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","पर मैं तुमसे कहो रहों कि तुम मोकै देखियो लै हौ, तहुँओं बिस्वास नाय करथौ। ");
INSERT INTO thr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","जो कछु दऊवा मोकै देथै बौ सब मेरे झोने आगो, और जो कोई मेरे झोने आगो बाकै मैं कहुए नाय निकारंगो। ");
INSERT INTO thr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","काहैकि मैं अपनी इच्छा नाय पर अपने पनारन बारे की इच्छा पूरी करन के ताहीं स्वर्ग से उतरो हौं। ");
INSERT INTO thr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","और मेरे पनारन बारे की इच्छा जौ है कि जो कछु मोकै बौ दई है, बामै से मैं कछु नाय हरबामौं, और उनकै आखरी दिन फिर से जिंदो कर देमौं। ");
INSERT INTO thr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","काहैकि मेरे दऊवा की इच्छा जौ है, कि जो कोई लौड़ा कै देखथै और बाके ऊपर बिस्वास करै, बौ अनंत जिंदगी पाबै; और मैं बाकै आखरी दिन फिर से जिंदो कर देंगो।” ");
INSERT INTO thr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","तौ यहूदि बाके ऊपर कुड़कुड़ान लगे, काहैकि ईसु कही रहै, “मैं बौ रोटी हौं जो स्वर्ग से उतरी है।” ");
INSERT INTO thr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","और बे कहीं, “का जौ यूसुफ को लौड़ा ईसु नाय है, जोके अईय्या-दऊवा कै हम जानथैं? तौ बौ कैसे कहदेथै कि मैं स्वर्ग से उतरो हौं?” ");
INSERT INTO thr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ईसु उनकै जबाब दई, “आपस मैं मत कुड़कुड़ाबौ। ");
INSERT INTO thr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोई मेरे झोने ना आए सकथै जबले दऊवा, जो मोकै पनारी है, बाकै खींच नाय लेबै; और मैं बाकै आखरी दिन फिर से जिंदो कर देंगो। ");
INSERT INTO thr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","भविस्यवक्ता के लेखन मैं जौ लिखो है, ‘बे सब परमेस्वर के घाँईं से सिखे भै होंगे।’ जो कोई दऊवा से सुनो और सिखो है, बौ मेरे झोने आथै। ");
INSERT INTO thr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","जौ नाय कि कोई दऊवा कै देखो है; पर जो परमेस्वर के घाँईं से है, खाली बहे बाबा कै देखी है। ");
INSERT INTO thr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","मैं तुमसे सच-सच कहथौं, कि जो कोई बिस्वास करथै, अनंत जिंदगी बहे की है। ");
INSERT INTO thr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","जिंदगी की रोटी मैं हौं। ");
INSERT INTO thr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुमरे बापदादो रेगिस्तान मैं मन्ना खाईं और मर गै। ");
INSERT INTO thr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","जौ बौ रोटी है जो स्वर्ग से उतरी है ताकी आदमी जामैं से खाबै और नाय मरै। ");
INSERT INTO thr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","जिंदगी की रोटी जो स्वर्ग से उतरी बौ मैं हौं। अगर कोई जौ रोटी मैं से खाबैगो, तौ हमेसा के ताहीं जिंदो रहबैगो; और जो रोटी मैं जौ दुनिया की जिंदगी के ताहीं देंगो, बौ मेरो सरीर है।” ");
INSERT INTO thr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","जौ सुनकै यहूदि ऐसे कहकै आपस मैं लड़न लागे, “कि जौ आदमी कैसे हमकै अपनो सरीर खान ताहीं दै सकथै?” ");
INSERT INTO thr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ईसु उनसे कही, “मैं तुमसे सच-सच कहथौं जब तक आदमी के लौड़ा को सरीर नाय खागे, और बाको खून नाय पीगे, तुम मैं जिंदगी नाय है। ");
INSERT INTO thr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जो मेरो सरीर खाथै, और मेरो खून पीथै, अनंत जिंदगी बहे की है, और मैं आखरी दिन फिर बाकै जिंदो कर देंगो। ");
INSERT INTO thr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","काहैकि मेरो सरीर सच्ची मैं खान की चीज है और मेरो खून सच्ची मैं पीन की चीज है। ");
INSERT INTO thr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जो मेरो सरीर खाथै और मेरो खून पीथै, बौ मेरे मैं अटल बनो रहथै, और मैं बामै। ");
INSERT INTO thr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जैसो जिंदो दऊवा (परमेस्वर) मोकै भेजी और मैं दऊवा की बजह से जिंदो हौं, बैसिये बहो जो मोकै खागो मेरी बजह से जिंदो रहगो। ");
INSERT INTO thr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","जो रोटी स्वर्ग से उतरी बौ जहे है, बापदादे हानी नाय कि खाईं, और मर गै; जो कोई जौ रोटी खागो, बौ हमेसा के ताहीं जिंदो रहगो।” ");
INSERT INTO thr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","जे बातैं ईसु कफरनहूम के सभाघर मैं उपदेस देत समय कही। ");
INSERT INTO thr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ईसु के चेलन मैं से तमान जौ सुनकै कहीं, “जौ तौ भौतै कठोर सिक्छा है; जाकै कौन मान सकथै?” ");
INSERT INTO thr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ईसु अपने मन मैं जौ जानकै कि मेरे चेला आपस मैं जौ बात मैं कुड़कुड़ाए रै हैं, ईसु उनसे पूँछी, “का जौ बात से तुमकै ठोकर लग रइ है? ");
INSERT INTO thr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","और अगर तुम आदमी के लौड़ा कै, जहाँ पर बौ पहले रहै, हुँआँ ऊपर जात भौ देखैगे, तौ का होगो? ");
INSERT INTO thr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आत्मा तौ जिंदगी देन बारो है, सरीर से कछु फायदा नाय है। जो बातैं मैं तुमसे कहो हौं बे आत्मा हैं, और जिंदगीयो हैं। ");
INSERT INTO thr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","पर तुम मैं से कित्ते ऐसे हैं जो बिस्वास नाय करथैं।” काहैकि ईसु पहलेई से जानत रहै कि जो बिस्वास नाय करथै, बे कौन हैं; और कौन मोकै पकड़बागो। ");
INSERT INTO thr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","और बौ कही, “जहे ताहीं मैं तुमसे कहो रहों कि जब तक कोई कै दऊवा की तरफ से जौ वरदान नाय दौ जागो तौले बौ मेरे झोने नाय आए सकथै।” ");
INSERT INTO thr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","जे सब बातन के बाद बाके चेलन मैं से गजब जनी उल्टा लौट गै और बाके बाद ईसु के संग ना चलीं। ");
INSERT INTO thr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तौ ईसु बे बारह चेलन से कही, “का तुम्हऊँ चले जानो चाहथौ?” ");
INSERT INTO thr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","सिमौन पतरस ईसु कै जबाब दई, “हे प्रभु, हम कौनके झोने जामैं? अनंत जिंदगी की बातैं तौ तेरे झोने हैं। ");
INSERT INTO thr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","और हम बिस्वास करे हैं, और जानगै हैं, कि परमेस्वर को पवित्र जन तैं है।” ");
INSERT INTO thr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ईसु उनकै जबाब दई, “का मैं तुम बारहौ कै ना चुन लौ? तहुँओं तुम मैं से एक जनी सैतान है।” ");
INSERT INTO thr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","जौ बौ सिमौन इस्करियोती के लौड़ा यहूदा के बारे मैं कही। काहैकि जौ बारह चेलन मैं से एक रहै, जो ईसु कै पकड़वान बारो रहै। ");
INSERT INTO thr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","जे सब बातन के बाद ईसु गलील देस मैं फिरत रहो, काहैकि यहूदि नेता बाकै मार डारन की कोसिस करत रहैं, जहे ताहीं बौ यहूदिया मैं फिरनो ना चहात रहै। ");
INSERT INTO thr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","और यहूदि तम्बु को त्योहार झोने आए गौ रहै। ");
INSERT INTO thr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","जहे ताहीं बाके भईय्या बासे कहीं, “हींना से यहूदिया कै जा, कि जो काम तैं करथै, बे काम तेरे चेलौ देखैं। ");
INSERT INTO thr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","कोई ऐसो कोई नाय होगो जो प्रसिद्ध होनो ना चाहबै, और लुककै काम करै, अगर तैं जौ काम करथै, तौ अपने आपकै जौ दुनिया मैं दिखा।” ");
INSERT INTO thr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","काहैकि बाके भईय्या बाके ऊपर बिस्वास नाय करत रहैं। ");
INSERT INTO thr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तौ ईसु उनसे कही, “मेरो समय हबै नाय आओ है; पर तुम्हारे ताहीं अब समय है। ");
INSERT INTO thr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","जौ दुनिया तुमसे बैर ना रख सकथै, पर बौ मोसे बैर करथै, काहैकि मैं बाके बिरोध मैं जौ गभाई देथौं, कि बाके काम बुरे हैं। ");
INSERT INTO thr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुम त्योहार मैं जाबौ; मैं अभै जौ त्योहार मैं नाय जांगो, काहैकि अभै तक मेरो समय ना भौ है।” ");
INSERT INTO thr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","बौ उनसे जे बात कहकै गलीलै मैं रुक गौ। ");
INSERT INTO thr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","और जब बाके भईय्या त्योहार मैं चले गै, तौ बौ खुलेआम तौ नाय, पर चुप्पे से चले गौ। ");
INSERT INTO thr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","यहूदि त्योहार मैं ईसु कै ऐसे कहकै ढूँड़न लागे कि “बौ कहाँ है?” ");
INSERT INTO thr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","और सब जनी ईसु के बारे मैं चुप्पे-चुप्पे भौत सी बात करन लागे, कोई कहेत रहै, “बौ भलो आदमी है।” और कित्ते ऐसे कहेत रहैं, “कि ना, बौ तौ लोगन कै भरमाथै।” ");
INSERT INTO thr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","तहुँओं यहूदि नेतन के डर के मारे कोई खुलकै बाके बारे मैं ना बोलत रहै। ");
INSERT INTO thr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","और जब त्योहार को आधो दिन गुजर गौ; तौ ईसु मंदिर मैं जाएकै उपदेस देन लागो। ");
INSERT INTO thr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","तौ यहूदि नेता चौहोंक कै कहीं, “जाकै बिना पढ़े बिद्या कैसे आए गई?” ");
INSERT INTO thr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ईसु उनकै जबाब दई, “मेरो उपदेस मेरो ना है, पर मेरे भेजन बारे को है। ");
INSERT INTO thr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","अगर कोई बाकी इच्छा मैं चलनो चाहबै, तौ बौ जौ उपदेस के बारे मैं जान जागो कि बौ परमेस्वर के घाँईं से है, या मैं अपने घाँईं से कहथौं। ");
INSERT INTO thr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जो अपने घाँईं से कछु कहथै, बौ अपनिए बड़ाँईं चाहथै; पर जो अपने पनारन बारे की महिमा चाहथै बहे सच्चो है, और बामै कोई अधर्म नाय है। ");
INSERT INTO thr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","का मूसा तुमकै नियम नाय दई? तहुँओं तुम मैं से कोई नियम मैं नाय चलथै। तुम काहेकै मोकै मार डारनो चाहथौ?” ");
INSERT INTO thr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","हूँना के लोग जबाब दईं, “तेरे मैं प्रेत आत्मा है! कौन तोकै मार डारनो चाहथै?” ");
INSERT INTO thr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ईसु उनकै जबाब दई, “मैं एक काम करो हौं, और तुम सब अचम्मो मानथौ। ");
INSERT INTO thr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","जहे बजह से मूसा तुमकै खतना करन की आग्या दई है, जौ नाय कि बौ मूसा की घाँईं से है, जौ तौ बापदादोन से चलो आओ है, और तुम साबत के दिन लौड़ा को खतना करथौ। ");
INSERT INTO thr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जब साबत के दिन लौड़ा को खतना करो जाथै, ताकी मूसा की नियम की आग्या नाय टूटै, तौ तुम जाके ताहीं मेरे ऊपर काहेकै गुस्सा होथौ, कि मैं साबत के दिन एक आदमी कै पूरी तरह से अच्छो करो। ");
INSERT INTO thr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मोहों देखकै मत परखौ, पर सई न्याय करौ।” ");
INSERT INTO thr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तौ कित्ते यरूसलेम मैं रहन बारे ऐसे कहेन लागे, “का जौ बौ नाय है, जोकै मार डारन की कोसिस करी जाए रइ है? ");
INSERT INTO thr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पर देखौ, बौ तौ खुलेआम बतकाए रौ है और कोई बासे कछुए नाय कहथै; का मुखिया सच मैं जानगै हैं; कि जहे मसीह है? ");
INSERT INTO thr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","जाकै तौ हम जानथैं, कि जौ कहाँ को है; पर जब मसीह आगो, तौ कोई नाय जानैगो कि बौ कहाँ को है।” ");
INSERT INTO thr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तौ ईसु मंदिर मैं उपदेस देन पोती चिल्लाए कै कही, “तुम मोकै जानथौ और ऐसियौ जानथौ कि मैं कहाँ को हौं। मैं तौ अपने आप से ना आओ पर मेरो पनारन बारो सच्चो है, बाकै तुम नाय जानथौ। ");
INSERT INTO thr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","मैं बाकै जानथौं; काहैकि मैं बहे कि घाँईं से हौं और बहे मोकै पनारी है।” ");
INSERT INTO thr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","जौ सब होन के बाद बे ईसु कै पकड़बानो चाँहीं तहुँओं कोई बाके ऊपर हाथ नाय डारीं, काहैकि बाको समय अभै तक नाय आओ रहै। ");
INSERT INTO thr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","तहुँओं भीड़ मैं से तमान जनी बाके ऊपर बिस्वास करीं, और कहेन लागे, “मसीह जब आगो, तौ का जासे जाधे अचम्मे चिन्ह दिखागो जो जौ दिखाई है?” ");
INSERT INTO thr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसी लोग, दूसरे लोगन कै ईसु के बारे मैं चुप्पे-चुप्पे बतकात सुनीं; और फिर मुखिया पुजारी और फरीसी ईसु कै पकड़न के ताहीं सिपईय्यन कै पनारीं। ");
INSERT INTO thr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","जौ सब होन के बाद ईसु कही, “मैं थोड़ी देर तक और तुमरे संग हौं; फिर मैं अपने पनारन बारे के झोने चलो जांगो। ");
INSERT INTO thr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुम मोकै ढूँड़ैगे, पर नाय पागे; और जहाँ मैं हौं, हुँआँ तुम नाय आए सकथौ।” ");
INSERT INTO thr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहूदि नेता आपस मैं बतकाईं, “जौ कहाँ जागो कि हम जाकै नाय पांगे? का जौ उनके झोने जागो, जो यूनान सहर मैं तितर-बितर हुईकै रहथैं, और यूनानियन कै भी उपदेस देगो। ");
INSERT INTO thr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","जौ का बात है जो बौ कही, कि तुम मोकै ढूँड़ैगे, पर नाय पागे, और जहाँ मैं होंगो, हुँआँ तुम नाय आए सकथौ?” ");
INSERT INTO thr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","फिर त्योहार के आखरी दिन, जो खास दिन रहै, ईसु ठाड़गौ और चिल्लाए कै कही, “अगर कोई प्यासो होबै तौ मेरे झोने आबै और पीबै। ");
INSERT INTO thr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जो मेरे ऊपर बिस्वास करैगो, जैसे सास्त्र मैं आओ है, ‘बाके भीतर से जिंदगी के पानी की नदिया बहे निकरंगी।’” ");
INSERT INTO thr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","बौ जौ बचन बौ पवित्र आत्मा के बारे मैं कही, जोकै ईसु के ऊपर बिस्वास करन बारे पान मैं रहैं; का है आत्मा अभै तक नाय उतरो रहै, काहैकि ईसु अभै तक अपनी महिमा तक नाय पहुँचो रहै। ");
INSERT INTO thr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ईसु कै सुनकै भीड़ मैं से कोई-कोई कहीं, “सच्ची मैं जौ बहे भविस्यवक्ता है।” ");
INSERT INTO thr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","और दुसरे कहीं, “जौ मसीह है,” पर कुछ कहीं, “काहेकै? का मसीह गलील से आबैगो? ");
INSERT INTO thr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","का पवित्र सास्त्र मैं ना आओ कि मसीह दाऊद की पीढ़ी से और बैतलहम गाँव से आगो, जहाँ पर दाऊद रहत रहै?” ");
INSERT INTO thr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","और बाकी बजह से लोगन मैं फूट पड़ी। ");
INSERT INTO thr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","उनमैं से कित्ते बाकै पकड़नो चहात रहैं, पर कोई बाके ऊपर हाथ ना डारी। ");
INSERT INTO thr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तौ सिपईय्या मुखिया पुजारिन और फरीसियन के झोने आए, और बे सिपईय्यन से कहीं, “तुम बाकै काहेकै नाय लाए?” ");
INSERT INTO thr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सिपईय्या जबाब दईं, “अभै तक कोई इंसान ऐसी बातैं नाय करीं!” ");
INSERT INTO thr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरीसी उनकै जबाब दईं, “का तुम्हऊँ भरमाए गै हौ? ");
INSERT INTO thr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","का मुखिया या फिर फरीसियन मैं से कोई भी बाके ऊपर बिस्वास करीं है? ");
INSERT INTO thr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","पर जे लोग जो मूसा के नियम नाय जानथैं, स्रापित हैं।” ");
INSERT INTO thr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुस, जो सुरू मैं बाके झोने आओ रहै और उनमैं से एक रहै, बौ कही, ");
INSERT INTO thr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“का हमरे नियम कोई जनी कै, जबले बाकी सुनकै परख नाय लेमैं, कि बौ का करथै; का कसूरवार मानथै?” ");
INSERT INTO thr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","बे बाकै जबाब दईं, “का तहूँ गलील को है? सास्त्र मैं ढूँड़ और देख, कि गलील से कोई भविस्यवक्ता नाय आगो।” ");
INSERT INTO thr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","फिर बे सब अपने-अपने घरै चले गै। ");
INSERT INTO thr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","लेकिन ईसु जैतून के पहाड़ मैं गौ। ");
INSERT INTO thr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","और भोर होत खिना कि मंदिर मैं आए गौ, और सब जनी बाके झोने आए; और बौ हूँना बैठकै उनकै उपदेस देन लगो। ");
INSERT INTO thr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तौ यहूदि नियम के सिक्छक और फरीसियैं एक बईय्यर कै लाईं जो कि व्यभिचार करत भइ पकड़ी गई रहै, और बाकै बीच मैं ठड़बाए कै ईसु से कहीं, ");
INSERT INTO thr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“गुरुजी, जौ बईय्यर व्यभिचार करत भइ पकड़ी गई है। ");
INSERT INTO thr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","नियम मैं मूसा हमकै आग्या दई है कि ऐसी बईंय्यरन कै पथरा मारियो; और तैं जौ बईय्यर के बारे मैं का कहनो चाहथै?” ");
INSERT INTO thr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","बे ईसु कै परखन के मारे ऐसे कहीं ताकी बाके ऊपर दोस लगान के ताहीं कोई बात पाए जामैं, पर ईसु लोहोक कै उँगरिया से जमीन मैं लिखन लागो। ");
INSERT INTO thr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जब बे ईसु से पूँछतै रहैं, तौ बौ सीध हुईकै कही, “तुम मैं से जो पाप नाय करो है, बहे पहले बाकै पथरा मारै।” ");
INSERT INTO thr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","और फिर से लोहोक कै जमीन मैं लिखन लागो। ");
INSERT INTO thr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","पर बे ऐसे सुनकै बड़े-बूढ़े से लैकै छोटे तक एक-एक करकै हुँआँ से निकर गै, और ईसु अकेलो रहगौ, और बौ हुँए बीच मैं ठाड़ी रह गई। ");
INSERT INTO thr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ईसु ठाड़कै बासे कही, “हे नारी, बे सब कहाँ गै? का कोई तोकै सजा की आग्या नाय दौ?” ");
INSERT INTO thr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","बौ बईय्यर कही, “हे प्रभु, कोई नाय दौ।” ईसु कही, “महुँ तोकै सजा की आग्या नाय देंगो; और अब तैं जा और कहु पाप मत करिये।” ");
INSERT INTO thr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ईसु फिर फरीसियन से बात करी, “जौ दुनिया को उजियारो मैं हौं,” बौ कही। जो मेरे पच्छू हुई लेगो, बाके पास जिंदगी को उजीतो होगो और बौ कहु अंधियारे मैं नाय चलैगो। ");
INSERT INTO thr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसी ईसु से कहीं, “तैं अपनी गभाई अपने आप देथै; तेरी गभाई सच नाय है।” ");
INSERT INTO thr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ईसु उनकै जबाब दई, “अगर मैं अपनी गभाई अपने आप देथौं, तहुँओं मेरी गभाई सच है, काहैकि मैं जानथौं, कि मैं कहाँ से आओ हौं, और कहाँ कै जाथौं? पर तुम नाय जानथौ कि मैं कहाँ से आथौं या फिर कहाँ कै जाथौं। ");
INSERT INTO thr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुम जौ सरीर के अनुसार परखथौ; मैं कोई को न्याय ना करथौं। ");
INSERT INTO thr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","और अगर मैं न्याय करौं भी, तौ मेरो परखनो सच्चो है; काहैकि मैं अकेलो नाय हौं, पर मैं दऊवा के संग हौं, जो मोकै पनारी है। ");
INSERT INTO thr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","और तुम्हारे नियम मैं लिखो है; दुई जनी की गभाई मिलकै सच होथै। ");
INSERT INTO thr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","एक तौ मैं अपने आप गभाई देथौं, और दूसरी दऊवा मेरी गभाई देथै जो मोकै पनारी है।” ");
INSERT INTO thr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","बे ईसु से कहीं, “तेरो दऊवा कहाँ है?” ईसु जबाब दई, “ना तुम मोकै जानथौ, ना मेरे बाबा कै, अगर तुम मोकै जानते, तौ मेरे दऊवा कै भी जानते।” ");
INSERT INTO thr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","जे बात बौ मंदिर मैं उपदेस देत भौ भंडार घर मैं कही रहै, और कोई बाकै नाय पकड़ो; काहैकि अभै बाको समय नाय आओ रहै। ");
INSERT INTO thr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ईसु फिर उनसे कही, “मैं जाथौं, और तुम मोकै ढूँड़ैगे और अपने पापन मैं मरैगे; जहाँ मैं जाथौं, हुँआँ तुम नाय आए सकथौ।” ");
INSERT INTO thr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","जौ सुनकै यहूदि नेता कहीं, “का बौ अपने आपकै मार डारैगो, जैसो बौ कहरौ है, कि जहाँ मैं जाथौं हुँआँ तुम नाय आए सकथौ?” ");
INSERT INTO thr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ईसु उनसे कही, “तुम तरे के हौ, मैं ऊपर को हौं; तुम जौ दुनिया के हौ, मैं जौ दुनिया को ना हौं। ");
INSERT INTO thr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","जहे ताहीं मैं तुमसे कहो, कि तुम अपने पापन मैं मरैगे; काहैकि अगर तुम बिस्वास नाय करैगे कि मैं बहे हौं, तौ अपने पापन मैं मरैगे।” ");
INSERT INTO thr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","बे ईसु से कहीं, “तैं कौन है?” ईसु उनसे कही, “बहे हौं जो सुरू से कहेत भौ आओ हौं। ");
INSERT INTO thr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुमरे बारे मैं मोकै बहोत कछु कहने और परखने है पर मोकै जो पनारी है बौ सच्चो है; और जोमैं बासे सुनो हौं, बहे जौ दुनिया मैं कहथौं।” ");
INSERT INTO thr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","बे जौ नाय समझैं कि हमसे दऊवा के बारे मैं कहरौ है। ");
INSERT INTO thr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","फिर ईसु कही, “जब तुम आदमी के लौड़ा कै ऊँचे मैं चढ़ाबैगे, तौ पता चलैगो कि मैं बहे हौं, और अपने मन से कछु नाय करथौं, पर जैसी मेरो दऊवा मोकै सिखाई है, बेईं बात करथौं। ");
INSERT INTO thr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","और मोकै भेजन बारो मेरे संग है; बौ मोकै अकेलो नाय छोड़ी है; बौ इसलै कि मैं हमेसा बेईं काम करथौं, जोसे बौ खुस होथै।” ");
INSERT INTO thr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ईसु जे बात कहतै रह, और गजब जनी बाके ऊपर बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तौ ईसु बे यहूदियन से जो बाके ऊपर बिस्वास करी रहैं, उनसे कही, “अगर तुम मेरे बचन मैं बने रहबैगे, तौ सच्ची को मेरे चेला बन जाबैगे। ");
INSERT INTO thr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","और सच कै जानैगे, और सत्य तुमकै आजाद करैगो।” ");
INSERT INTO thr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","बे ईसु कै जबाब दईं, “हम तौ अब्राहम की पीढ़ी के हैं, और कहुए कोई की सेवा नाय करे; फिर तैं काहे कहरौ है, कि तुम आजाद हुई जाबैगे?” ");
INSERT INTO thr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ईसु उनकै जबाब दई, “मैं तुमसे सच-सच कहथौं कि जो कोई पाप करथै, बौ पाप को सेवक है। ");
INSERT INTO thr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","और सेवक हमेसा घरै नाय रहथै; लौड़ा हमेसा रहथै। ");
INSERT INTO thr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","इसलै अगर लौड़ा तुमकै आजाद करैगो, तौ सच्ची को तुम आजाद हुई जाबैगे। ");
INSERT INTO thr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मैं जानथौं कि तुम अब्राहम की पीढ़ी से हौ; तहुँओं मेरो बचन तुमरे मन मैं जघा नाय बना पाथै, इसलै तुम मोकै मार डारनो चाहथौ। ");
INSERT INTO thr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","मैं बहे कहथौं, जो अपने दऊवा के हिंयाँ पर देखो हौं; और तुम बहे करत रहथौ जो तुम अपने दऊवा से सुने हौ।” ");
INSERT INTO thr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","बे ईसु कै जबाब दईं, “हमरो दऊवा तौ अब्राहम है।” ईसु उनसे कही, “अगर तुम अब्राहम के बालका होते, तौ अब्राहम के हानी काम करते। ");
INSERT INTO thr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","पर अब तुम मेरे जैसो इंसान कै मार डारनो चाहथौ, जो कि तुमकै बौ सच बचन बताई जो परमेस्वर से सुनी, ऐसे तौ अब्राहमौ नाय करी रहै। ");
INSERT INTO thr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुम अपने दऊवा के हानी काम करथौ” फिर बे ईसु से कहीं, “हम छिनरइ से नाय पैदा भै, हमरो एकै बाबा है यानी कि परमेस्वर।” ");
INSERT INTO thr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ईसु उनसे कही, “अगर परमेस्वर तुमरो दऊवा होतो, तौ तुम मोसे प्यार करते; काहैकि मैं परमेस्वर मैं से निकरकै आओ हौं; मैं अपने आप से नाय आओ, पर बहे मोकै पनारी। ");
INSERT INTO thr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","तुम मेरी बात काहेकै ना समझथौ? इसलै कि मेरो बचन सुन नाय सकथौ। ");
INSERT INTO thr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुम अपने दऊवा सैतान के घाँईं से हौऔर अपने दऊवा की इच्छा पूरी करनो चाहथौ। बौ तौ सुरु से हत्यारो है, और सच मैं टिक नाय पाई, काहैकि सत्य बामै हईये नाय; जब बौ झूठ बोलथै, तौ अपने मन सेई बोलथै; काहैकि बौ झूठो है, और जहे संग बौ झूठ को दऊवा है। ");
INSERT INTO thr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","पर मैं जो सच बोलथौं, इसलै तुम मेरो बिस्वास नाय करथौ। ");
INSERT INTO thr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुम मैं से मोकै कौन पापी मानथै? और अगर मैं सच बोलथौं, तौ तुम मेरो बिस्वास काहेकै नाय करथौ? ");
INSERT INTO thr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","बौ जो परमेस्वर की घाँईं से है, बौ परमेस्वर की बात कै सुनथै; और तुम इसलै नाय सुनथौ कि तुम परमेस्वर की घाँईं से नाय हौ।” ");
INSERT INTO thr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","जे सब बात सुनकै यहूदि ईसु से कहीं “का हम सई नाय कहथैं कि तैं सामरी जाति को है, और तेरे भीतर प्रेत आत्मा है?” ");
INSERT INTO thr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ईसु जबाब दई, “मेरे मैं प्रेत आत्मा नाय है; पर मैं अपने दऊवा को आदर करथौं, और तुम मेरो निरादर करथौ। ");
INSERT INTO thr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","मैं अपनी महिमा नाय चाहथौं हाँ पर एक ऐसो है जो मेरी महिमा चाहथै, और न्याय करथै। ");
INSERT INTO thr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मैं तुमसे सच-सच कहथौं, कि अगर कोई आदमी मेरे बचन मैं चलैगो, तौ हमेसा-हमेसा के ताहीं मौत कै नाय देखैगो।” ");
INSERT INTO thr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदि ईसु से कहीं, “अब हम जानगै हैं कि तेरे भीतर प्रेत आत्मा है, अब्राहम मर गौ, और भविस्यवक्ता मर गै हैं और तैं कहथै, ‘अगर मेरे बचन मैं कोई हमेसा चलैगो तौ बौ कहुए मौत को स्वाद नाय चखैगो।’ ");
INSERT INTO thr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","हमरो बाबा अब्राहम तौ मर गौ, का तैं बासे बड़ो है? और भविस्यवक्ता मर गै हैं, तैं अपने आपकै का ठहराथै?” ");
INSERT INTO thr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ईसु जबाब दई, “अगर मैं अपने आप अपनी महिमा करौं, तौ मेरी महिमा कछु नाय है, पर मेरी महिमा करन बारो मेरो दऊवा है, जोकै तुम कहथौ, कि बौ हमरो परमेस्वर है। ");
INSERT INTO thr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","और तुम तौ बाकै नाय जाने पर मैं बाकै जानथौं; और अगर मैं कहमौं कि मैं बाकै नाय जानथौं, तौ मैं तुमरे हानी झूठो मानो जांगो। पर मैं बाकै जानथौं, और बाके बचन मैं चलथौं। ");
INSERT INTO thr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुमरो दऊवा अब्राहम जौ जानकै कि बौ जौ दिन कै देखैगो जब मैं आंगो, खुसी से भरगौ रहै। बौ जौ देखी और खुसी भौ।” ");
INSERT INTO thr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदि लोग ईसु से कहीं, “अभै तैं पचास साल को तक नाय भौ है, तहुँओं तैं अब्राहम कै देखो है?” ");
INSERT INTO thr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ईसु उनसे कही, “मैं तुमसे सच्ची-सच्ची कहथौं, अब्राहमौ से पहले मैं हौं।” ");
INSERT INTO thr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तौ फिर बे ईसु कै मारन के ताहीं पथरा उठाईं, पर ईसु लुककै मंदिर से निकर गौ। ");
INSERT INTO thr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","फिर ईसु जात भौ एक आदमी कै देखी, जो जनम से अंधरा रहै। ");
INSERT INTO thr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","और ईसु के चेला बासे पूँछीं, “गुरुजी, कौन पाप करो होगो, कि जौ अंधरा पैदा भौ, जौ आदमी करी होगो, या फिर जाके अईय्या दऊवा?” ");
INSERT INTO thr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ईसु जबाब दई, “ना तौ जौ पाप करी रहै, और ना जाके अईय्या दऊवा करीं, बौ जहे ताहीं कि जाके जरिये से परमेस्वर को चमत्कार दिखाई देबै। ");
INSERT INTO thr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जो मोकै पनारी है; बाके काम कै दिनै-दिन करनो जरूरी है, काहैकि जब रात हुई जाबैगी, तौ कोई काम नाय हुई सकैगो। ");
INSERT INTO thr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जबले मैं जौ दुनिया मैं हौं, तौले मैं जौ दुनिया को उजियारो हौं।” ");
INSERT INTO thr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ऐसे कहकै ईसु धरती मैं थूकी और बौ थूक से मट्टी कै माड़ दई, और बहे मट्टी बौ अंधरा की आँखी मैं लेप लगाएकै। ");
INSERT INTO thr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","बासे कही, “जा सिलोह के डबरा मैं धोए आ, सीलोह को मतलब पनारो भौ” और फिर बौ अंधरा जाएकै धोई, और जब बौ लौटकै आओ तौ बाकै दिखाई देत रहै। ");
INSERT INTO thr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तौ बाके पड़ोसी और जो पहले बाकै भीख मांगत भौ देखीं रहैं, कहेन लागे, “का जौ बहे नाय है, जो बैठकै भीख माँगे करत रहै?” ");
INSERT INTO thr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कोई कहबै, “कि जौ बहे है,” और कोई कहमैं, “कि जौ नाय है, पर बाके हानी है” बौ कही, “मैं बहे हौं।” ");
INSERT INTO thr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तौ बे बासे पूँछन लागे, “तेरी आँखी कैसे खुल गईं?” ");
INSERT INTO thr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","बौ जबाब दई, “ईसु नाओं को एक आदमी मट्टी कै माँड़ी, और मेरी आँखी मैं लेप लगाएकै मोसे कही, सिलोह मैं जाएकै धोएले तौ मैं गौ, और धोत खिना कि देखन लग्गौ।” ");
INSERT INTO thr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","बे बासे पूँछीं, “तौ फिर बौ कहाँ है?” बौ कही, “मोकै पता नाय है, मैं नाय जानथौं।” ");
INSERT INTO thr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","बे लोग बाकै, जो पहले अंधरा रहै फरीसियन के झोने लैगै। ");
INSERT INTO thr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जो दिन ईसु मट्टी मांड़कै बाकी आँखी खोली रहै बौ साबत को दिन रहै। ");
INSERT INTO thr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फिर फरीसी लोग बासे पूँछीं; तेरी आँखी कैसे करकै खुल गईं? बौ उनसे कही, “बौ मेरी आँखी मैं मट्टी लगाई, फिर मैं धोए लौ, और अब देखथौं।” ");
INSERT INTO thr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","जौ सब सुनकै बहोत से फरीसी कहेन लागे, “जौ इंसान परमेस्वर की घाँईं से नाय है, काहैकि बौ साबत को दिन मानतै नाय है।” और जनी कहीं, तौ “पापी इंसान कैसे ऐसे चिन्ह दिखाए सकथै?” और उनमैं फूट पड़ गई। ");
INSERT INTO thr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","बे बौ अंधरा से फिर से कहीं, “बौ जो तेरी आँखी खोली है, तैं बाके बारे मैं का कहनो चाहथै?” बौ कही, “बौ भविस्यवक्ता है।” ");
INSERT INTO thr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","फिर भी यहूदियन कै बिस्वास नाय भौ कि जौ सच्ची को अंधरा रहै और अब देखथै, जबले बौ अंधरा के अईय्या-दऊवा कै बुलाए नाय लईं। ");
INSERT INTO thr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","और उनसे पूँछीं, “का जौ तुमरो लौड़ा है, जोकै तुम कहथौ कि जौ जनम से अंधरा रहै? फिर अब जौ कैसे करकै देखथै?” ");
INSERT INTO thr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","बाके अईय्या-दऊवा जबाब दईं, “हम तौ जानथैं कि जौ हमरो लौड़ा है, और जौ जनम से अंधरा रहै। ");
INSERT INTO thr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पर हम ऐसे नाय जानथैं, कि जौ अब कैसे करकै देखन लागो है; और ऐसियौ नाय जानथैं, कि कौन जाकी आँखी खोली है; हमरो लौड़ा अब स्यानो ही गौ है; बहे से पूँछ लियो; बौ अपने बारे मैं अपने आप कह लेगो।” ");
INSERT INTO thr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","जे बात बाके अईय्या-दऊवा इसलै कहीं काहैकि बे यहूदि नेतन से डरात रहैं; काहैकि यहूदि एकजुट हुईगै रहैं, कि अगर कोई कहबै कि बौ अच्छो करन बारो मसीह है, तौ बाकै सभाघर मैं से निकारो जाबै। ");
INSERT INTO thr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","जहे बजह से बाके अईय्या-दऊवा कहीं, “बौ स्यानो है; बहे से पूँछ लियो!” ");
INSERT INTO thr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तौ बे बौ आदमी कै जो अंधरा रहै दुसरी बार बाकै बुलाएकै बासे कहीं, “परमेस्वर की महिमा कर; हम तौ जानथैं कि बौ इंसान पापी है।” ");
INSERT INTO thr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","बौ जबाब दई, “मैं नाय जानथौं कि बौ पापी है कि ना है, मैं बस इतका जानथौं कि मैं अंधरा रहों और अब देखथौ।” ");
INSERT INTO thr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","बे बासे फिर से कहीं, “बौ तेरे संग का करी है? और कैसे करकै तेरी आँखी खोली?” ");
INSERT INTO thr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","बौ उनसे कही, “मैं तौ तुमसे कह चुको हौं, और तुम नाय सुने; अब एकोर बार काहेकै सुननो चाहथौ? का तुम्हऊँ बाके चेला बननो चाहथौ?” ");
INSERT INTO thr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तौ बे बाकै बुरो भलो कहकै कहीं, “तहीं बाको चेला है; हम तौ मूसा के चेला हैं। ");
INSERT INTO thr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","हम जानथैं कि परमेस्वर मूसा से बतकाई है; पर जौ इंसान कै नाय जानथैं की जौ कहाँ को है।” ");
INSERT INTO thr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","बौ उनकै जबाब दई, “जौ तौ अचम्मो होन बारी बात है कि तुम बाकै नाय जानथौ कि बौ कहाँ को है तहुँओं बौ मेरी आँखी खोल दई। ");
INSERT INTO thr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","हम जानथैं कि परमेस्वर पापिन की नाय सुनथै, पर अगर कोई परमेस्वर को भक्त है, और बाकी इच्छा मैं चलथै, तौ परमेस्वर बाकी सुनथै। ");
INSERT INTO thr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","दुनिया की सुरुवात से जौ कहु सुनन मैं ना आओ, कि कोई भी जलमत से अंधरा की आँखी खोली होबै। ");
INSERT INTO thr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अगर जौ आदमी परमेस्वर की घाँईं से नाय होतो, तौ जौ कछुए नाय कर पातो।” ");
INSERT INTO thr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","बे बाकै जबाब दईं, “तैं तौ कतई पाप से पैदा भौ है, तैं हमकै का सिखाए रौ है?” और बे बाकै सभाघर से बाहर निकार दईं। ");
INSERT INTO thr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ईसु सुनी कि बे बाकै निकार दईं हैं, और जब बासे ईसु को भेंटा भौ तौ ईसु बासे कही, “का तैं आदमी के लौड़ा के ऊपर बिस्वास करथै?” ");
INSERT INTO thr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","बौ जबाब दई, “प्रभु, बौ कौन है, कि मैं बाके ऊपर बिस्वास करौं!” ");
INSERT INTO thr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ईसु बासे कही, “तैं बाकै देखो भी है; और जो तोसे बतकाए रौ है, बौ बहे है।” ");
INSERT INTO thr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","बौ कही, “हे प्रभु, मैं बिस्वास करथौं।” और बौ ईसु कै घुपटियाय कै आराधना करी। ");
INSERT INTO thr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तौ फिर ईसु कही, “मैं जौ दुनिया मैं न्याय करन के ताहीं आओ हौं, ताकी जो नाय देखथैं बे देखैं, और जोकै दिखाथै बे अंधरा हुई जामैं।” ");
INSERT INTO thr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","और जो फरीसी बाके संग रहैं, बे जे सब बात सुनकै ईसु से कही, “का हमउँ अंधरा हैं?” ");
INSERT INTO thr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ईसु उनसे कही, “अगर तुम अंधरा होते तौ पापी नाय ठहरते पर अब तुम कहथौ, कि हम देखथैं, इसलै तुमरो पाप बनो रहथै।” ");
INSERT INTO thr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“मैं तुमसे सच्ची-सच्ची कहथौं, कि जो कोई फाटक से भेंड़ कि सार मैं नाय जागो, पर दुसरे घाँईं से घुस जाथै, तौ बौ चुट्टा और डाँकू है। ");
INSERT INTO thr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पर जो फाटक हुईकै जाथै, बौ भेंड़न कै चुगान बारो है। ");
INSERT INTO thr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","उनको मालिक उनके ताहीं फाटक खोलथै, और भेंड़ बाकी अबाज कै सुनथैं, और बौ अपनी भेंड़न कै नाओं लै-लैकै मस्काथै और बाहर लै जाथै। ");
INSERT INTO thr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","और जब बौ अपनी भेंड़न कै निकार चुको होथै, तौ बौ उनके अग्गु-अग्गु चलथै, और भेंड़ बाके पच्छू-पच्छू चल देथैं; काहैकि बे बाकी अबाज कै जानथैं। ");
INSERT INTO thr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पर बे दुसरेन के पच्छू नाय जांगी, और उल्टा बासे भाजंगी, काहैकि बे पराए के बोलकै नाय जानथैं।” ");
INSERT INTO thr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ईसु उनसे जौ कहानी कही, पर बे नाय समझे, कि जौ का बात है, जो जौ हमसे कहरौ है। ");
INSERT INTO thr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तौ ईसु उनसे फिर कही, “मैं तुमसे सच्ची-सच्ची कहथौं, कि भेंड़न को फाटक मैं हौ। ");
INSERT INTO thr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जित्ते मोसे पहले आए; बे सब चुट्टा और डाँकू हैं पर भेंड़ बाकी नाय सुनीं। ");
INSERT INTO thr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","फाटक मैं हौं; अगर कोई मेरे जरिये भीतर जाबैगो तौ बौ उद्धार पाबैगो और भीतर आए-जाए करैगो और चारौ पाबैगो। ");
INSERT INTO thr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चुट्टा और कछु काम ताहीं नाय आथै बौ खाली चोरी करन और घात करन और खतम करन कै आथै। मैं इसलै आओ कि बे जिंदगी पामैं, और खूबै पामैं। ");
INSERT INTO thr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","अच्छो बरदिया मैं हौं; एक अच्छो बरदिया अपनी भेंड़न के ताहीं ज्यान न तक देथै। ");
INSERT INTO thr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","मजदूर जो ना चारौ चुगान बारो है, और ना भेंड़न को मालिक है, बौ भेंड़ियन कै आत भौ देखत खिना कि, भेंड़न कै छोड़कै भाज पड़थै, और भेंड़िया उनकै पकड़थै, और तितर-बितर कर देथै। ");
INSERT INTO thr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","बौ इसलै भाज पड़थै कि बौ मजदूर है, और बाकै भेंड़न की फिकर नाय है। ");
INSERT INTO thr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","अच्छो बरदिया मैं हौं; मैं अपनी भेंड़न कै जानथौं, और मेरी भेंड़ौं मोकै जानथैं। ");
INSERT INTO thr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","मैं अच्छो बरदिया हौं। जैसो दऊवा मोकै जानथै और मैं दऊवा कै जानथौं, बैसिये मैं अपनी भेंड़न कै जानथौं। और मैं उनके ताहीं ज्यान देन ताहीं तैयार हौं। ");
INSERT INTO thr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","और मेरी औरौ भेंड़न के झुंड हैं, जो जौ की सार की नाय हैं; मोकै उन्हऊँ कै लानो जरूरी है, बे मेरी अबाज कै सुनंगी; तौ फिर बाद मैं एकै झुंड और एकै चुगान बारो बरदिया होगो। ");
INSERT INTO thr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","दऊवा मोसे इसलै प्यार करथै, कि मैं अपनी ज्यान दै देथौं, मैं अपनी जान देथौं ताकी फिर से बापिस पाए सकौ। ");
INSERT INTO thr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कोई बाकै मोसे नाय छीन सकथै, उल्टा मैं बाकै अपने आप देथौं। मोकै बाकै देनौ को अधिकार है, और बासे फिर लै लेन को भी अधिकार है। जौ आग्या मेरे दऊवा से मोकै मिली है।” ");
INSERT INTO thr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","जे सब बातन की बजह से यहूदियन मैं फिर फूट पड़ गई। ");
INSERT INTO thr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","उनमैं से गजब जनी कहेन लगे, “बाके भीतर प्रेत आत्मा है, और बौ पागल है; बाकी काहे सुनरै हौ?” ");
INSERT INTO thr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","और जनी कहीं, “जे बातैं ऐसे आदमी की नाय हुई सकथैं जोके भीतर प्रेत आत्मा होबै, का भूत अंधरन की आँखी अच्छी कर देगो?” ");
INSERT INTO thr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरूसलेम मैं मंदिर के समरपड़ को त्योहार आओ, और जाड़े को समय रहै। ");
INSERT INTO thr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","और ईसु मंदिर मैं सुलैमान की डेहरी मैं घूँमत रहै। ");
INSERT INTO thr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तौ यहूदि ईसु कै आए कै घेर लईं और पूँछीं, “तैं हमरे मन कै कबले दुविधा मैं रखागो? अगर तैं मसीह है, तौ हमसे सपा-सपा कहदे।” ");
INSERT INTO thr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ईसु उनकै जबाब दई, “मैं तुमसे कह दौ हौं, और तुम तहुँओं बिस्वास करतै ना हौ, जो काम मैं अपने दऊवा के नाओं से करथौ बेईं मेरे गभा हैं; ");
INSERT INTO thr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पर तुम इसलै बिस्वास ना करथौ, कि तुम मेरी भेंड़न मैं से नाय हौ। ");
INSERT INTO thr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मेरी भेंड़ैं मेरी अबाज कै सुनथैं, और मैं उनकै जानथौं, और बे मेरे पच्छू-पच्छू चलथैं। ");
INSERT INTO thr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","और मैं उनकै अनंत जिंदगी देथौं, और बे कहु खतम नाय होंगी, और कोई उनकै मेरे हाथ से नाय छीन पागो। ");
INSERT INTO thr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मेरो दऊवा, जो कि उनकै मोकै दई है, सबसे बड़ो है, और कोई उनकै बाबा के हाथ से छीन नाय सकथै। ");
INSERT INTO thr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मैं और मेरो दऊवा एक हैं।” ");
INSERT INTO thr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदि ईसु कै पथरा मारन के ताहीं फिर से पथरा उठाईं। ");
INSERT INTO thr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","जौ सब देखकै ईसु उनसे कही, “मैं तुमकै अपने दऊवा के घाँईं से कित्ते भले अच्छे काम दिखाओ हौं, उनमैं से कोनसे काम के ताहीं तुम मोकै पथरा मारथौ?” ");
INSERT INTO thr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदि बाकै जबाब दईं, “अच्छे काम के ताहीं हम तोकै पथरा नाय मारथैं, पर तैं परमेस्वर की बदनामी करो है, और इसलै कि तैं इंसान हुईकै अपने आपकै परमेस्वर बनाथै।” ");
INSERT INTO thr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ईसु उनकै जबाब दई, “तुमरे नियम मैं लिखो है कि परमेस्वर कही, ‘तुम्हईं देवता हौ।’ ");
INSERT INTO thr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","का हिंयाँ पर ईस्वर उन्हईं लोगन कै नाय कहो गौ, जोकै परम दऊवा परमेस्वर की बात मिल चुकी है; और सास्त्र को टुकड़ा-टुकड़ा नाय करो जाए सकथै। ");
INSERT INTO thr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","तौ जोकै दऊवा पवित्र मानकै जौ दुनिया कै समर्पित करी है, तुम बासे कहथौ, तैं परमेस्वर कि बुराई करथै इसलै कि मैं कहो, ‘मैं परमेस्वर को लौड़ा’ हौं? ");
INSERT INTO thr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","अगर बौ काम जो मेरो दऊवा मोसे करवानो चहात होबै और मैं ना करो होमौं, तौ मेरो बिस्वास मत करौ। ");
INSERT INTO thr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पर अगर मैं करथौं, तौ चाँहे मेरो बिस्वास मत करौ, पर बे कामन मैं बिस्वास करौ, ताकी तुम जानौ, और समझौ, कि दऊवा मेरे मैं है, और मैं बाबा मैं हौं।” ");
INSERT INTO thr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तौ फिर से बे बाकै पकड़न की कोसिस करीं पर ईसु उनके हाथ से निकर गौ। ");
INSERT INTO thr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","फिर ईसु यरदन नदिया के बौ पाँजर बौ जघा मैं चले गौ, जहाँ पर यूहन्ना पहले बपतिस्मा देत रहै, और हुँए रहो। ");
INSERT INTO thr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","और तमान जनी बाके झोने आयकै कहेत रहैं, “यूहन्ना तौ कोई चिन्ह नाय दिखाई, पर जो कछु यूहन्ना जाके बारे मैं कही रहै बौ सब सच्ची है।” ");
INSERT INTO thr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","और हूँन पर तमान जनी बाके ऊपर बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","मरियम और बाकी बहेनिया मार्था के गाँव बैतनिय्याह मैं लाजर नाओं को एक आदमी बिमार रहै। ");
INSERT INTO thr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","जौ बहे मरियम रहै जो प्रभु ईसु के ऊपर इत्तर से अभिसेक करी डारकै बाकी टाँग कै अपने बारन से पोंछी रहै, जहे को भईय्या लाजर बिमार रहै। ");
INSERT INTO thr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","और बाकी बहेनिया ईसु कहेन ताहीं पनारी कि, “प्रभु, देख, तेरो प्रिय दोस्त, बौ बिमार है।” ");
INSERT INTO thr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","जौ सुनकै ईसु कही, “जौ बिमारी मौत की नाय है, पर परमेस्वर की महिमा के ताहीं है, कि बाके जरिये परमेस्वर के लौड़ा की महिमा होबै।” ");
INSERT INTO thr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ईसु, मार्था और बाकी बहेनिया लाजर से प्यार करे करत रहै। ");
INSERT INTO thr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","जब ईसु सुनी, कि बौ बिमार है, तौ जो जघा मैं बौ रहै, हुँआँ पर दुई दिन और रुक गौ। ");
INSERT INTO thr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","फिर जाके बाद बौ चेलन से कही, “आबौ, हम फिर से यहूदिया कै चलैं।” ");
INSERT INTO thr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेला बासे कहीं, “गुरुजी, अभईये तौ तोकै यहूदि पथरा मारनो चहात रहैं, और का तैं हूँनै जानो चाहथै?” ");
INSERT INTO thr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ईसु कही, “का दिन के बारह घंटा नाय होथैं? अगर कोई दिन मैं चलै, तौ ठोकर नाय खाथै, काहैकि जौ दुनिया को उजियारो देखथै। ");
INSERT INTO thr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पर अगर कोई रात मैं चलै, तौ बौ ठोकर खाथै, काहैकि बामै उजियारो नाय है।” ");
INSERT INTO thr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ईसु ऐसे करकै कही, और जाके बाद उनसे कहेन लागो, “आपन को दोस्त लाजर सोए गौ है, और मैं बाकै जगान कै जाएरौ हौं।” ");
INSERT INTO thr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तौ चेला ईसु से कहीं, “प्रभु, अगर बौ सोए गौ है, तौ अच्छो हुई जागो।” ");
INSERT INTO thr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ईसु तौ बाके मरन के बारे मैं कही रहै, पर बे समझे कि बौ नींद से सोन के बारे मैं कहरौ है। ");
INSERT INTO thr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तौ ईसु उनसे सपा-सपा कह दई, “लाजर मर गौ है, ");
INSERT INTO thr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","और मैं तुमरी बजह से खुस हौं कि मैं हुँआँ नाय रहों जोसे कि तुम बिस्वास करौ। पर अब आबौ, हम बाके झोने चलैं।” ");
INSERT INTO thr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तौ थोमा जो दिदुमुस कहो जात रहै, अपने संग बारे चेलन से कही, “आबौ, आपनौं बाके संग मरन कै चलैं।” ");
INSERT INTO thr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","फिर ईसु बैतनिय्याह पुगो तौ पता चलो कि लाजर कै कबर मैं रखे भै चार दिन हुई चुके हैं। ");
INSERT INTO thr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनिय्याह यरूसलेम के झोने कोई तीन किलो मीटर की दूरी मैं रहै। ");
INSERT INTO thr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","और गजब यहूदि मार्था और मरियम के झोने बाके भईय्या के बारे मैं सांति देन के ताहीं आए रहैं। ");
INSERT INTO thr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जब मार्था ईसु के आन की खबर सुनकै ईसु से मिलन कै गई, पर मरियम घरई मैं रुक गई। ");
INSERT INTO thr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्था ईसु से कही, “प्रभु, अगर तैं हींना पर होतो, तौ मेरो भईय्या नाय मरतो! ");
INSERT INTO thr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","और अभऊ मैं जानथौं, कि जो कछु तैं परमेस्वर से माँगैगो, परमेस्वर तोकै देगो।” ");
INSERT INTO thr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ईसु बासे कही, “तेरो भईय्या जिंदो हुई जागो।” ");
INSERT INTO thr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्था बासे कही, “मैं जानथौं, आखरी दिन मैं दुबारा पुनरुत्थान के समय बौ जी उठैगो।” ");
INSERT INTO thr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ईसु बासे कही, “पुनरुत्थान और जिंदगी महीं हौं, जो कोई मेरे ऊपर बिस्वास करथै बौ अगर मरियो जाबै, तहुँओं जीबैगो; ");
INSERT INTO thr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","और जो कोई जिंदो है, और मेरे ऊपर बिस्वास करथै, बौ अनंतकाल तक नाय मरैगो, का तैं जौ बात मैं बिस्वास करथै?” ");
INSERT INTO thr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","बौ ईसु से कही, “हाँ, प्रभु! मैं बिस्वास कर चुकी हौं, कि परमेस्वर को लौड़ा मसीह जो जौ दुनिया मैं आनबारो रहै, बौ तैं है।” ");
INSERT INTO thr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ऐसे कहकै बौ चली गई, और अपनी बहेनिया मरियम कै चुप्पे से बुलाएकै कही, “ईसु मसीह हिंए पर है, और तोकै बुलाए रौ हौ।” ");
INSERT INTO thr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","बौ ऐसे सुनत खिना कि तुरंतै हूँना से उठकै ईसु के झोने चली गई। ");
INSERT INTO thr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ईसु अभै तक गाँव मैं नाय पहोंचो रहै, पर बौ बहे जघा मैं रहै जहाँ मार्था से भेंटा करी रहै। ");
INSERT INTO thr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तौ जो यहूदि बाके संग बाके घरै रहैं, और बाकै सांति देत रहैं, जौ देखकै कि मरियम तुरंतै उठकै बाहर कै गई है, और बे जौ समझीं कि बौ कबर मैं रोन कै जाए रइ है, बे बाके पच्छू-पच्छू चल दईं। ");
INSERT INTO thr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जब मरियम हूँना पुगी, जहाँ पर ईसु रहै, तौ ईसु कै देखत खिना कि बाकी टाँग मैं गिरकै कही, “प्रभु, अगर तैं हींना पर होतो तौ मेरो भईय्या नाय मरतो!” ");
INSERT INTO thr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जब ईसु बाकै और बे यहूदियन कै जो मरियम के संग-संग आए रहैं उनकै रोत भौ देखी, तौ ईसु आत्मा मैं गजब उदास और बेचैन हुई गौ। ");
INSERT INTO thr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","और कही, “तुम बाकै कहाँ पर रखे हौ?” बे ईसु से कहीं “हे प्रभु, चलकै देखले।” ");
INSERT INTO thr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ईसु रोई। ");
INSERT INTO thr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तौ यहूदि कहेन लगे, “देखौ, बौ बासे कित्तो प्यार करथै!” ");
INSERT INTO thr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पर बामै से गजब जनी ऐसे कहीं, “जौ आदमी अंधरा की आँखी खोल दई, का लाजर कै मरन से नाय बचाए सकथै?” ");
INSERT INTO thr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ईसु मनै मन फिर गजब उदास हुईकै कबर मैं आओ, हुँआँ पर गुफा रहै, और गुफा के मोहोंकै पथरा से बंद करो गौ रहै। ");
INSERT INTO thr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ईसु कही, “पथरा कै उठाबौ!” बौ मरे भै की बहेनिया मार्था बासे कहेन लागी, “प्रभु, बौ तौ अब गिंधात होगो, काहैकि बाकै मरे भै चार दिन हुईगै हैं।” ");
INSERT INTO thr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ईसु बासे कही, “का मैं तोसे नाय कहो रहों कि अगर तैं बिस्वास करैगी, तौ परमेस्वर की महिमा कै देखैगी।” ");
INSERT INTO thr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तौ बे बौ पथरा कै हटाईं, फिर ईसु अपनी नजर उठाएकै कही, “हे दऊवा, मैं तेरो धन्यवाद करथौं कि तैं मेरी सुन लौ है। ");
INSERT INTO thr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","और मैं जानत रहों, कि तैं हमेसा मेरी सुनथै, पर जो भीड़ आसपास ठाड़ी पड़ी है, उनकी बजह से मैं ऐसे कहो, जोसे कि बे बिस्वास करैं, कि तैं मोकै पनारो है।” ");
INSERT INTO thr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ऐसे कहकै ईसु फिर बड़ा जोर से कही, “ए लाजर, निकर आ!” ");
INSERT INTO thr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जो मर गौ रहै, बौ कफन सुंदा हाथ पाँव बंधो भौ निकर आओ और बाको मोहों अंगोछा से लिपटो पड़ो रहै। फिर ईसु उनसे कही, “बाकै खोल देबौ और जान देबौ।” ");
INSERT INTO thr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","तौ जो यहूदि मरियम के झोने आए रहैं, और ईसु को ऐसो काम देखीं रहै, उनमैं से तमान जनी बाके ऊपर बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पर उनमैं से कित्ते जनी ऐसे रहैं जो कि फरीसियन के झोने जाएकै ईसु के काम की खबर दईं। ");
INSERT INTO thr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","जे सब सुनन के बाद मुखिया पुजारी और फरीसी लोग सभा के लोगन कै इखट्टो करकै कहीं, “हमैं का करनो चाहिए? जौ आदमी तौ बड़ा चिन्ह दिखाए रौ है! ");
INSERT INTO thr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","अगर आपन बाकै ऐसिये छोड़ देंगे, तौ सब लोग बाके ऊपर बिस्वास करन लग जांगे और रोमी नेता हमरे मंदिर और देस दोनों के ऊपर अपनो अधिकार कर लेंगे!” ");
INSERT INTO thr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तौ उनमैं से कैफा नाओं को एक आदमी जो कि बहे साल को बड़ो पुजारी रहै, बौ कही, “तुम कछु नाय जानथौ! ");
INSERT INTO thr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","और ना ऐसे समझथौ, कि जौ तुमरे ताहीं भलो है, कि आपन के लोगन के ताहीं एक इंसान मरै, और पूरी जाति खतम नाय होबै।” ");
INSERT INTO thr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","जे बात बौ अपने मन से नाय कही, पर बौ साल को बड़ो पुजारी हुईकै भविस्यवाँड़ी करी, कि ईसु बौ यहूदि लोगन के ताहीं मरैगो; ");
INSERT INTO thr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","और ना खाली उनके लोगन ताहीं, बल्किन जहो ताहीं कि परमेस्वर के तितर-बितर बालकन कै एक कर देबै। ");
INSERT INTO thr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","और बहे दिन से यहूदि नेता ईसु कै मार डारन की साजिस करन लग्गै। ");
INSERT INTO thr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","तौ ईसु बौ समय से यहूदियन के अग्गु नाय गौ; पर हूँना से जंगल के किनारे के परदेस इफ्राईम नाओं के एक सहर मैं चले गौ; और अपने चेलन के संग हुँए रहन लगो। ");
INSERT INTO thr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहूदियन को फसह को त्योहार झोने आए चुको रहै, और गजब जनी फसह से पहले, गाँव से यरूसलेम कै गै कि बे अपने आपकै सुद्ध कर लेमैं। ");
INSERT INTO thr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","और बे ईसु कै ढूँड़न लगे और मंदिर मैं ठाड़कै आपस मैं कहेन लगे, “तुम का सोचथौ? का बौ त्योहार मैं नाय आगो?” ");
INSERT INTO thr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","मुखिया पुजारी और फरीसी भी आग्या दै रखाईं रहैं कि अगर कोई कै पता होबै कि ईसु कहाँ है तौ बौ बताबै, ताकी बे बाकै पकड़ सकैं। ");
INSERT INTO thr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","फिर ईसु फसह से छै दिन पहले बैतनिय्याह मैं आओ जहाँ पर लाजर रहै, जोकै ईसु मर कै भी जिंदो करी रहै। ");
INSERT INTO thr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","हूँना पर बे ईसु के ताहीं खानु बनाईं; और मार्था ईसु की सेवा करत रहै, ईसु के संग जो खानु खान के ताहीं बैठे रहैं लाजरौ उनमैं से एक रहै। ");
INSERT INTO thr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","मरियम जटामांसी से बनो भौ लमसम आधो किलो सुद्ध इत्तर लैकै ईसु की टाँगन मैं अभिसेक करी, और अपने बार से बाकी टाँगन कै पछोनी। इत्तर की मीठी महक से पूरो घर महाक गौ। ");
INSERT INTO thr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पर बाके चेलन मैं से यहूदा इस्करियोती नाओं को एक चेला जो ईसु कै पकड़बानो चहात रहै, बौ कहेन लागो, ");
INSERT INTO thr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“जौ इत्तर तीन सौ चाँदी के सिक्का मैं बेचकै गरीबन कै काहे ना दौ गौ?” ");
INSERT INTO thr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","बौ जौ बात इसलै नाय कही, कि बाकै गरीबन की फिकर रहै, पर इसलै कि बौ खुद चुट्टा रहै, बाके झोने उनके गुल्लक रहत रहै, और बामै जो कछु डारो जात रहै, बौ बामै से निकार लेत रहै। ");
INSERT INTO thr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ईसु कही, “बाकै रहन देयौं। बाकै मेरे गाड़े ज्यान बारे दिन के ताहीं रहन देयौं। ");
INSERT INTO thr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","काहैकि गरीब तौ तुमरे संग हमेसा रहथैं, पर मैं तुमरे संग हमेसा ना रहेंगो।” ");
INSERT INTO thr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जब यहूदियन की बड़ी भीड़ ज्यान गई कि ईसु बेतनियाह मैं है, तौ बे ना खाली ईसु के मारे आए पर बे जहो ताहीं आए कि बे लाजर कै देखैं, जोकै बौ मरे भै मैं से जिंदो करी। ");
INSERT INTO thr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तौ फिर मुखिया पुजारी लाजर कै भी मार डारन की साजिस करीं, ");
INSERT INTO thr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","काहैकि बाकी बजह से तमान यहूदि चले गै और ईसु मैं बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दुसरे दिन तमान लोग फसह के त्योहार मैं आए रहैं जौ सुनीं कि ईसु यरूसलेम मैं आए रौ है। ");
INSERT INTO thr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","तौ बे खजूर की हँगईय्या लईं और बासे मिलन ताहीं निकरे, और चिल्लान लग्गै, “परमेस्वर की स्तुति हो! धन्य इस्राएल को राजा, जो प्रभु के नाओं से आथै!” ");
INSERT INTO thr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जब ईसु कै एक गधा मिलो; तौ बौ बाके ऊपर बैठगौ, जैसो नियम मैं लिखो है, ");
INSERT INTO thr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“मत डराबै सिय्योन सहर! हिंयाँ तुमरो राजा, एक गधईया के बच्चा के ऊपर बैठकै आथै।” ");
INSERT INTO thr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","बाके चेला जे बात पहले ना समझीं रहैं, पर जब ईसु की महिमा दिखाई दई तौ उनकै याद आओ कि जे बात बाके बारे मैं लिखी पड़ी रहैं और लोग बासे कतई ऐसिये व्यवहार करीं रहैं। ");
INSERT INTO thr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तौ भीड़ के लोग गभाई दईं, जो बौ समय बाके संग रहैं ऐसे गभाई दईं कि बौ लाजर कै कबर मैं से बुलाएकै, मरे भै मैं से जिंदो करी रहै। ");
INSERT INTO thr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","जहे बजह से लोग बासे मिलन कै आए रहैं काहैकि बे सुनीं रहैं कि बौ जौ चिन्ह दिखाई है। ");
INSERT INTO thr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तौ फरीसी आपस मैं बतकाईं, “सोचौ, तुम लोग कछु नाय कर पाए रै हौ; देखौ, दुनिया बाके पच्छू हुई चली है।” ");
INSERT INTO thr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जो लोग फसह के त्योहार मैं सभाघर मैं आराधना के ताहीं यरूसलेम मैं आए रहैं उनमैं से थोड़ी जनी यूनानी रहैं। ");
INSERT INTO thr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","बे गलील देस के बैतसैदा के रहन बारे फिलिप्पुस के झोने आयकै बासे नहोरे करीं, “स्रीमान, हम प्रभु ईसु से भेंटा करनो चाहथैं।” ");
INSERT INTO thr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप्पुस आयकै अन्द्रियास से कही, तौ फिर अन्द्रियास और फिलिप्पुस जाएकै ईसु से कहीं। ");
INSERT INTO thr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","जौ सुनकै ईसु कही, “बौ समय आए गौ है कि आदमी के लौड़ा की महिमा होबै। ");
INSERT INTO thr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मैं तुमसे सच्ची-सच्ची कहथौं कि जबले गेंहूँ को गूदा जमीन की मट्टी मैं पड़कै मर नाय जाथै, बौ अकेलो रहथै; पर जब मर जाथै, तौ गजब फल लाथै। ");
INSERT INTO thr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जो अपनी ज्यान कै प्रिय जानथै, बौ बाकै खोए देथै; और जो जौ दुनिया मैं अपनी ज्यान कै प्रिय ना जानथै; बौ अनंत जिंदगी पाबैगो। ");
INSERT INTO thr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","अगर कोई मेरी सेवा करै, तौ मेरे पच्छू हुई लेबै; और जहाँ मैं हौं, हूँना मेरो सेवक होगो। अगर कोई मेरी सेवा करै, तौ दऊवा बाको आदर करैगो।” ");
INSERT INTO thr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“अब मेरो मन घबराय रौ है। अब मैं का कहमौं? का मैं कहमौं, ‘हे दऊवा, मोकै जौ घड़ी से बचा? पर मैं जहे बजह से जौ घड़ी कै पहुँचो हौं।’” ");
INSERT INTO thr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे दऊवा, अपने नाओं की महिमा कर, तौ स्वर्ग से अबाज आई, “मैं बाकी महिमा करो हौं, और तहुँओं करंगो।” ");
INSERT INTO thr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तौ जो लोग ठाड़कै सुनत रहैं बे कहीं कि बादर कड़को। और दुसरे कहीं, “कोई स्वर्गदूत बासे बोली!” ");
INSERT INTO thr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","जे बातन मैं ईसु कही, “जौ बोल मेरे ताहीं नाय, जौ तौ तुमरे ताहीं आओ है। ");
INSERT INTO thr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","अब जौ दुनिया को न्याय होगो, और अब जौ दुनिया को मुखिया निकार दौ जागो। ");
INSERT INTO thr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","और मैं अगर पृथ्वी मैं से ऊँचे मैं चढ़ाओ जांगो, तौ सब जनी कै अपने झोने खीचंगो।” ");
INSERT INTO thr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ऐसो कहकै बौ जौ बताए दई कि बौ कैसे करकै मौत से मरैगो। ");
INSERT INTO thr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","जे सब बात सुनकै लोग ईसु से कहीं, “हम नियम की जौ बात सुने हैं कि मसीह अनंत के ताहीं रहबैगो, फिर तैं काहेकै कहरौ है कि आदमी के लौड़ा कै ऊँचे मैं चढ़ाओ ज्यानो जरूरी है? जौ इंसान को लौड़ा कौन है?” ");
INSERT INTO thr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ईसु उनसे कही, “उजियारो अब जरा देर तक तुमरे बीच मैं है। जबले उजियारो तुमरे संग है तौले मेरे पच्छू चले चलौ, ऐसो ना होबै कि अंधियारो तुमकै आए घेरै; जो अंधियारे मैं चलथै बौ नाय जानथै कि कितै जाएरौ है। ");
INSERT INTO thr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जबले उजियारो तुमरे संग है, उजियारो मैं बिस्वास करौ ताकी तुम उजियारो की औलाद बनौ।” जे बात कहकै ईसु चले गौ और उनसे लुको रहो। ");
INSERT INTO thr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ईसु उनके सामने इतने चिन्ह दिखाई, तहुँओं बे बाके ऊपर बिस्वास नाय करीं, ");
INSERT INTO thr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ताकी यसायाह भविस्यवक्ता की भविस्यवाँड़ी के बचन पूरो होबै जो बौ कही; “ओ प्रभु, हमरी खबर को कौन बिस्वास करो है? और प्रभु की सामर्थ्य कौनके ऊपर दिखाई दई है?” ");
INSERT INTO thr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","जौ बजह से बे बिस्वास नाय कर पाईं, काहैकि यसायाह जहो कही है; ");
INSERT INTO thr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“बौ उनकी आँखी अंधरी, और उनको मन कर्‌रो कर दई है; कहीं ऐसो ना होबै कि बे आँखिन से देखैं, और मन से समझैं, और घूँमैं-फिरैं, और मैं उनकै अच्छो करौं।” ");
INSERT INTO thr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसायाह जे बातैं इसलै कही कि बौ ईसु कि महिमा कै देखी, और बौ बाके बारे मैं बतकाई। ");
INSERT INTO thr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","तहुँओं यहूदि मुखियन मैं से गजब जनी बाके ऊपर बिस्वास करीं, पर फरीसियन के बजह से अपने बिस्वास करन के बारे मैं नाय बताईं, कि कहीं ऐसो ना होबै कि बे सभाघर मैं से निकारे जामैं। ");
INSERT INTO thr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","काहैकि इंसानन कि तरफ से दौ भौ महिमा उनकै परमेस्वर के जरिये दै भै सम्मान से जाधा प्यार करथैं। ");
INSERT INTO thr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ईसु चिल्लाए कै कही, “जो मेरे ऊपर बिस्वास करथै, बौ मेरे ऊपर नाय बल्कि मेरे भेजन बारे के ऊपर बिस्वास करथै। ");
INSERT INTO thr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","और जो मोकै देखथै, बौ मेरे भेजन बारे कै देखथै। ");
INSERT INTO thr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मैं जौ दुनिया मैं जोती बनकै आओ हौं, ताकी जो कोई मेरे ऊपर बिस्वास करै बौ अंधियारे मैं नाय रहबै। ");
INSERT INTO thr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","अगर कोई मेरी बात सुनकै नाय मानै, तौ मैं बाकै कसूरवार नाय मानथौं; काहैकि मैं जौ दुनिया मैं परखन कै नाय, पर मैं जौ दुनिया को बचान कै आओ हौं। ");
INSERT INTO thr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जो मोकै बेकार जानथै और मेरी बातन कै नाय अपनात है बाकै कसूरवार ठहरान बारो तौ एक है। मतलब जो बचन मैं कहो हौं, बहे आखरी दिनन मैं बाकै परखंगो! ");
INSERT INTO thr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","काहैकि मैं अपनी घाँईं से बात नाय करो; पर दऊवा जो मोकै भेजी है बहे मोकै आग्या दई है कि का-का कहमौं और का-का बोलौं। ");
INSERT INTO thr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","और मैं जानथौं कि बाको आग्या अनंत जिंदगी है। इसलै मैं जो कछु बोलथौं, बौ जो दऊवा मोसे कही है बैसिये बोलथौं।” ");
INSERT INTO thr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह के त्योहार से पहले, जब ईसु जान लई कि मेरो समय आए गौ है कि जौ दुनिया कै छोड़कै परम दऊवा परमेस्वर के झोने जाऊँ, तौ अपने लोगन से जो जौ दुनिया मैं रहैं जैसो बौ प्यार रख्खत रहै, आखरी तक बैसिये प्यार रख्खत रहो। ");
INSERT INTO thr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","जब सैतान सिमौन के लौड़ा यहूदा इस्करियोती के मन मैं जौ डार चुको रहै कि बाकै पकड़बाबै, तौ खानु खान के समय ");
INSERT INTO thr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ईसु, जौ जानकै कि दऊवा सब कछु मेरे हाथ मैं कर दई है और मैं परमेस्वर के झोने से आओ हौं और परमेस्वर के झोने जाथौं, ");
INSERT INTO thr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","खानु से उठकै अपने ऊपर के लत्ता उतार दई, और अंगोछा से अपनो करिहाँओं भाँदी। ");
INSERT INTO thr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तौ फिर बौ बर्तन मैं पानी भरकै चेलन की टाँग धोन और जो अंगोछा से बौ अपनो करिहाँओं भाँदी रहै बहे से पछोनन लगो। ");
INSERT INTO thr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जब बौ सिमौन पतरस के झोने आओ, तौ पतरस बासे कही, “हे प्रभु, का तैं मेरी पाँव धोन कै आए रौ है?” ");
INSERT INTO thr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ईसु बाकै जबाब दई, “जोमैं करथौं, तैं बौ अभै नाय जानथै, पर जाके बाद समझ जागो।” ");
INSERT INTO thr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरस बासे कही, “तैं मेरी टाँग कहु नाय धोए पागो!” जौ सुनकै ईसु बासे कही, “अगर मैं तोकै नाय धोमौं, तौ मेरो तेरे संग कोई रिस्ता नाय है।” ");
INSERT INTO thr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","सिमौन पतरस बासे कही, “हे प्रभु, तौ मेरे पाँव नाय, बाके संग-संग हाथ और मुड़ियौ धोए दे।” ");
INSERT INTO thr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ईसु बासे कही, “जो हंदाए चुको है बाकै पाँव के सिबाय और कछु धोन की जरूरत नाय, पर बौ कतई सुद्ध है; एक कै छोड़कै बाकी तुम सब सुद्ध हौ।” ");
INSERT INTO thr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","बौ तौ अपने पकड़वान बारे कै जानत रहै इसलै बौ कही, “एक कै छोड़कै बाकी तुम सब सुद्ध हौ।” ");
INSERT INTO thr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जब बौ उनकी टाँग कै धोए चुको, और अपने लत्ता पहनकै फिर से बैठगौ, तौ ईसु उनसे कहेन लागो, “का तुम समझे कि मैं तुमरे संग का करो?” ");
INSERT INTO thr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुम मोकै गुरु और प्रभु कहथौ, और ठीकै कहथौ, काहैकि मैं बहे हौं। ");
INSERT INTO thr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","अगर मैं प्रभु और गुरु बनकै तुमरे पाँव कै धो, तौ तुमकै एक दुसरे के पाँव धोनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","काहैकि मैं तुमकै नमूना दिखाए दौ हौं कि जैसो मैं तुमरे संग करो हौं, तुम्हऊँ बैसिये करे करौ। ");
INSERT INTO thr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मैं तुमसे सच्ची-सच्ची कहथौं, सेवक अपने मालिक से बड़ो नाय होथै, और ना खबरेया अपने भेजन बारे से। ");
INSERT INTO thr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तुम सच्ची बात जानथौ, और अगर तुम उनमैं चलौ तौ तुम धन्य हौ! ");
INSERT INTO thr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“मैं तुम सबके बारे मैं नाय कहथौं; जोकै मैं चुन लौ हौं, उनकै मैं जानथौं; पर जौ इसलै है कि पवित्र सास्त्र को जौ बचन पूरो होबै, ‘जो मेरी रोटी खाथै, बौ मेरे ऊपर लात चलाई।’ ");
INSERT INTO thr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","अब मैं बौ होन से पहले तुमकै बताए दे रौ हौं कि जब खिना कि जौ बात हुई जाबै तौ तुम बिस्वास करियो कि मैं बहे हौं। ");
INSERT INTO thr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मैं तुमसे सच्ची-सच्ची कहथौं कि जो कोई मेरे भेजन बारे कै अपनाय लेथै, बौ मोकै अपनाथै; और जो कोई मोकै अपनाथै, बौ मेरे भेजन बारे कै अपनाथै।” ");
INSERT INTO thr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","जे बात कहकै ईसु आत्मा मैं बेचैन भौ और जौ गभाई दई, “मैं तुमसे सच्ची-सच्ची कहथौं कि तुम मैं से एक जनी मोकै पकड़बागो।” ");
INSERT INTO thr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेला सक की नजर से, कि बौ कौनके बारे मैं कहरौ है, एक दुसरे कै देखन लागे। ");
INSERT INTO thr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","बाके चेलन मैं से एक जोसे ईसु प्यार करत रहै, ईसु की छाती के घाँईं लोहको भौ बैठो रहै। ");
INSERT INTO thr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","सिमौन पतरस बाके घाँईं इसारा करकै बासे पूँछी, “बता तौ, बौ कौनके बारे मैं कहरौ है।” ");
INSERT INTO thr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तौ बौ बैसिये ईसु की छाती के घाँईं लोहको भौ बासे पूँछी, “हे प्रभु, बौ कौन है?” ");
INSERT INTO thr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ईसु जबाब दई, “जोकै मैं जौ रोटी को टुकड़ा डुबाय कै दुंगो बहे है।” और बौ टुकड़ा डुबाय कै सिमौन इस्करियोती के लौड़ा यहूदा कै दई। ");
INSERT INTO thr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","टुकड़ा लेत खिना कि सैतान बाके भीतर घुस गौ। तौ ईसु बासे कही, “जो तैं कहथै, अभई कर!” ");
INSERT INTO thr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","पर बैठन बारेन मैं से कोई नाय जानीं कि बौ जौ बात बासे काहे ताहीं कही। ");
INSERT INTO thr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदा के झोने पैसन की थैलिया रहत रहै, इसलै कोई-कोई समझी कि ईसु बासे कहरौ है कि जो कछुए हमकै त्योहार के ताहीं चाहिए बौ खरीद लेबै, या फिर जौ कि भिकमंगन कै कछु दै देबै। ");
INSERT INTO thr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","और फिर यहूदा रोटी को टुकड़ा लैकै तुरंत चले गौ; और बौ रात को समय रहै। ");
INSERT INTO thr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जब यहूदा बाहर चले गौ तौ ईसु कही, “अब इंसान के लौड़ा की महिमा भइ है, और बाके जरिये परमेस्वर की महिमा भइ है। ");
INSERT INTO thr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","अगर बाके जरिये परमेस्वर की महिमा भइ है, तौ परमेस्वर अपने जरिये इंसान के लौड़ा कै महिमावान करैगो। और बौ बाकै महिमा जल्दी देगो। ");
INSERT INTO thr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","मेरे बालकौ, मैं जरा देर और तुमरे झोने हौं। फिर तुम मोकै बाद मैं ढूँड़ैगे, और जैसो मैं यहूदि नेतन से कहो, ‘जितै मैं जाथौं हूँना तुम नाय आए सकथौ बैसिये अब मैं तुमसे कहथौं।’ ");
INSERT INTO thr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","मैं तुमकै एक नई आग्या देथौं कि एक दुसरे से प्यार रखौ; जैसो मैं तुमसे प्यार रखो हौं, बैसिये तुम्हऊँ एक दुसरे से प्यार रखौ। ");
INSERT INTO thr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","अगर आपस मैं प्यार रखैगे, तौ जहे से सब जानंगे कि तुम मेरे चेला हौ।” ");
INSERT INTO thr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","सिमौन पतरस ईसु से कही, “हे प्रभु, तैं कहाँ जाएरौ है?” ईसु जबाब दई, “जहाँ मैं जाथौं हूँना तैं अभै मेरे पच्छू आए नाय सकथै; पर जाके बाद मेरे पच्छू आगो।” ");
INSERT INTO thr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरस बासे कही, “हे प्रभु, अभै मैं तेरे पच्छू काहेकै नाय आए सकथौं? मैं तौ तेरे ताहीं अपनी ज्यान तक दै दुंगो।” ");
INSERT INTO thr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ईसु जबाब दई, “का तैं मेरे ताहीं अपनी ज्यान तक दै देगो? मैं तोसे सच्ची-सच्ची कहथौं, कि मुर्गा बासन से पहले तीन बार तैं कहगो कि मैं तोकै ना जानथौं।” ");
INSERT INTO thr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ईसु उनसे कही, “तुम अपने मन मैं परेसान मत होबौ, परमेस्वर के ऊपर, और मेरे ऊपरौ बिस्वास रखौ। ");
INSERT INTO thr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मेरे दऊवा के घर मैं गजब रहन ताहीं जघा है, अगर ऐसो नाय होतो तौ मैं तुमसे कह देतो; काहैकि मैं तुमरे ताहीं जघा बनान कै जाएरौ हौं। ");
INSERT INTO thr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","और अगर मैं जाएकै तुमरे ताहीं जघा बनामौं, तौ फिर आयकै तुमकै अपने हिंयाँ लै जांगो कि जहाँ मैं रहमौं हूँना तुम्हऊँ रहबौ। ");
INSERT INTO thr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","जहाँ पर मैं जाथौं तुम हुँआँ की रहा जानथौ।” ");
INSERT INTO thr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा बासे कही, “हे प्रभु, हम नाय जानथैं कि तैं कहाँ जाएरौ है; तौ रहा कैसे जानंगे?” ");
INSERT INTO thr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ईसु बासे कही, “रहा और सच और जिंदगी मैं ही हौं; बिना मेरे जरिये कोई दऊवा के झोने नाय पौहौंच सकथै। ");
INSERT INTO thr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","अगर तुम मोकै जानत होते, तौ मेरे दऊवा कै जानत होते; और अब तुम बाकै जानथौ, और बाकै देखे भी हौ।” ");
INSERT INTO thr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुस बासे कही, “हे प्रभु, दऊवा कै हमकै दिखाए दे, जहे हमरे ताहीं भौत है।” ");
INSERT INTO thr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ईसु बासे कही, “फिलिप्पुस, मैं इत्ते दिनन से तुमरे संग हौं, और का तैं मोकै नाय जानथै? जो मोकै देखो है बौ दऊवा कै देखी है। तैं काहे कहरौ है कि दऊवा कै हमकै दिखा? ");
INSERT INTO thr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","फिलिप्पुस का तैं बिस्वास नाय करथै कि मैं दऊवा हौं और दऊवा मेरे मैं है? ईसु अपने चेलन से कही, जे बातैं जोमैं अपनी तरफ से नाय कहथौं, पर दऊवा मेरे मैं रहकै अपने काम करथै। ");
INSERT INTO thr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मेरो बिस्वास करौ कि मैं दऊवा मैं हौं और दऊवा मेरे मैं है; अरे ना तौ मेरे कामन के बजह से मेरो बिस्वास करौ। ");
INSERT INTO thr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","मैं तुमसे सच्ची-सच्ची कहथौं कि जो मेरे ऊपर बिस्वास रखथै, जे काम जोमैं करथौं बहो करैगो, बल्किन जेऊँ से बड़े काम करैगो, काहैकि कि मैं दऊवा के झोने जाएरौ हौं। ");
INSERT INTO thr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","जो कछु तुम मेरे नाओं से माँगैगे, बहे मैं करंगो कि बालक के जरिये दऊवा की महिमा होबै। ");
INSERT INTO thr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","अगर तुम मेरे नाओं से कछु माँगैगे, तौ मैं बाकै करंगो।” ");
INSERT INTO thr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“अगर तुम मोसे प्यार करथौ, तौ तुम मेरी आग्या कै मानैगे। ");
INSERT INTO thr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","मैं दऊवा से नहोरे करंगो, और बौ तुमकै एक मदत करन बारो देगो, कि बौ हमेसा तुमरे संग रहबै। ");
INSERT INTO thr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","मतलब सच्चाई की आत्मा, जोकै दुनिया अपनाय ना सकथै, काहैकि बौ ना बाकै देखथै और ना बाकै जानथै; तुम बाकै जानथौ, काहैकि बौ तुमरे संग रहथै, और बौ तुम मैं होगो।” ");
INSERT INTO thr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“मैं तुमकै अकेलो नाय छोड़ंगो; मैं तुमरे झोने आथौं। ");
INSERT INTO thr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","थोड़ी देर और रहगौ है फिर मोकै दुनिया नाय देखैगी, पर तुम मोकै देखैगे; इसलै कि मैं जिंदो हौं, तुम्हऊँ जिंदे रहबैगे। ");
INSERT INTO thr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","बौ दिन तुम जानैगे कि मैं अपने दऊवा मैं हौं, और तुम मेरे मैं, और मैं तुम मैं। ");
INSERT INTO thr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जोके पास मेरी दई गई आग्या है और बौ उनकै मानथै, बहे मोसे प्यार करथै; और जो मोसे प्यार करथै बासे मेरो दऊवा प्यार करैगो, और मैं बासे प्यार करंगो और अपने आपकै बाके ऊपर दिखांगो।” ");
INSERT INTO thr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","बौ यहूदा जो इस्करियोती नाय रहै, बौ ईसु से कही, “हे प्रभु, का भौ तैं अपने आपकै हमरे ऊपर प्रकट करनो चाहथै और दुनिया के ऊपर नाय?” ");
INSERT INTO thr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ईसु बाकै जबाब दई, “अगर कोई मोसे प्यार रखैगो तौ बौ मेरी सिक्छा कै मानैगो, और मेरो दऊवा बासे प्यार रखैगो, और हम बाके झोने आंगे और बाके संग रहमंगे। ");
INSERT INTO thr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जो मोसे प्यार नाय रखथै, बौ मेरी सिक्छा कै नाय मानथै; और जो सिक्छा कै तुम सुनथौ बौ मेरो नाय बल्किन दऊवा को है, जो मोकै भेजी है।” ");
INSERT INTO thr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“जे बात मैं तुमरे संग रहत भौ तुमसे कहो। ");
INSERT INTO thr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पर मदत करन बारो यानी कि पवित्र आत्मा जोकी दऊवा मेरे नाओं से भेजैगो, बौ तुमकै सब बात सिखागो, और जो कछु मैं तुमसे कहो हौं, बौ सब चीज तुमकै याद कराबैगो।” ");
INSERT INTO thr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“मैं तुमकै सांति दै जाएरौ हौं, अपनी सांति तुमकै देथौं; जैसे दुनिया देथै, मैं तुमकै नाय देथौं, तुमरो मन घबराबै नाय और ना डराबै। ");
INSERT INTO thr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","तुम सुने कि मैं तुमसे कहो, ‘मैं जाथौं और तुमरे झोने फिर बाद मैं आंगो।’ अगर तुम मोसे प्यार करते, तौ जौ बात से खुस होते कि मैं दऊवा के झोने जाएरौ हौं, काहैकि दऊवा मोसे बड़ो है।” ");
INSERT INTO thr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","और मैं अब जौ होन से अग्गु तुमसे कह दौ हौं, कि जब बौ हुई जाए, तौ तुम बिस्वास करियो। ");
INSERT INTO thr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","मैं अब तुमरे संग और अगरी बात ना करंगो, काहैकि जो दुनिया को मुखिया आए रौ है। मेरे ऊपर बाको कोई अधिकार ना है, ");
INSERT INTO thr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","पर जे बात इसलै ही रइ हैं ताकी जौ दुनिया जान जाबै कि मैं परम दऊवा से प्यार करथौं, और दऊवा जैसो आग्या मोकै दई, मैं बैसिये करथौं, “अब उठौ, आपन हिंयाँ से चलैं।” ");
INSERT INTO thr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“सच्ची दाखलता मैं हौं, और मेरो दऊवा रखबरिया है। ");
INSERT INTO thr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","जो हँगईय्या मेरे मैं है और नाय फरथै, बाकै बौ काट देथै; और जो फरथै, बाकै बौ छाँटथै ताकी और फरै। ");
INSERT INTO thr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुम तौ बौ सिक्छा की बजह से जोमैं तुमसे कहो हौं, बाकी बजह से पहलिये सुद्ध हौ। ");
INSERT INTO thr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुम मेरे मैं बने रहबौ, और मैं तुम मैं बनो रैहंगो। जैसे कि हँगईय्या दाखलता से नाय जुरी होबै तौ अपने आप से नाय फर सकथै, बैसिये तुम अगर मेरे मैं नाय बने रैहगे तौ नाय फर सकथौ।” ");
INSERT INTO thr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","मैं दाखलता हौं, तुम हँगईय्या हौ। जो मेरे मैं बनो रहथै और मैं बामै बनो रहथौं, बौ भौत फरथै, काहैकि तुम मोसे अलग हुईकै कछु नाय कर सकथौ। ");
INSERT INTO thr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","अगर कोई मेरे मैं नाय बनो रहबै, तौ बौ हँगईय्या के हानी फेंक दौ जाथै, और सूख जाथै; और लोग उनकै बटोरकै आगी मैं डार देथैं, बे पजर जाथैं। ");
INSERT INTO thr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","अगर तुम मेरे मैं बने रहै और मेरो बचन तुमरे मैं बनो रहो, तौ चाँहे जो कछु माँगौ बौ तुमरे ताहीं हुई जाबैगो। ");
INSERT INTO thr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","जहे से मेरे परम दऊवा की महिमा होथै कि तुम गजबै फरौ तभई तुम मेरे चेला माने जागे। ");
INSERT INTO thr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जैसो परम दऊवा मोसे प्यार करी है, बैसिये मैं तुमसे प्यार करो; मेरे प्यार मैं बने रहबौ। ");
INSERT INTO thr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अगर तुम मेरी आग्या कै मानैगे, तौ मेरे प्यार मैं बने रहबैगे; जैसे कि मैं अपने परम दऊवा के हुकम कै मानो हौं, और बाके प्यार मैं बनो रहथौं। ");
INSERT INTO thr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मैं जे बात तुमसे इसलै कहो हौं, कि मेरी खुसी तुम मैं बनी रहबै, और तुमरी खुसी पूरी हुई जाबै। ");
INSERT INTO thr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मेरी आग्या जौ है, कि जैसो मैं तुमसे प्यार करो हौं, बैसिये तुम्हऊँ एक-दुसरे से प्यार करौ। ");
INSERT INTO thr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","जासे बड़ो प्यार कोई को ना है कि कोई अपने दोस्तन के ताहीं अपनी ज्यान दै देबै। ");
INSERT INTO thr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जो आग्या मैं तुमकै देथौं, अगर तुम बाकै मानौ तौ तुम मेरे दोस्त हौ। ");
INSERT INTO thr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","अब से मैं तुमकै सेवक ना कहेंगो, काहैकि नौकर ना जानथै कि बाको मालिक का करथै; पर मैं तुमसे दोस्त कहो हौं, काहैकि जो बात मैं अपने परम दऊवा से सुनों, बे सब तुमकै बताए दौ हौं। ");
INSERT INTO thr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुम मोकै नाय छाँटे पर मैं तुमकै चुनो हौं और मैं तुमकै छाँट कै रखो हौं कि तुम जाएकै फरौ और तुमरो फरा टिको रहबै, कि तुम मेरे नाओं से जो कछु परम दऊवा से माँगौ, बौ तुमकै देबै। ");
INSERT INTO thr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","जे बातन को आग्या मैं तुमकै इसलै देथौं कि तुम एक-दुसरे से प्यार करौ। ");
INSERT INTO thr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“अगर जौ दुनिया तुमसे बैर रखथै, तौ तुम जानथौ कि बे तुमसे अग्गु मोसे बैर रखीं। ");
INSERT INTO thr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अगर तुम जौ दुनिया के होते, तौ जौ दुनिया अपने से प्यार करती; पर जौ बजह से कि तुम जौ दुनिया के ना हौ, बल्कि मैं तुमकै जौ दुनिया से चुन लौ हौं, जहे ताहीं जौ दुनिया तुमसे बैर रखथै। ");
INSERT INTO thr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","जो बात मैं तुमसे कहो रहों, ‘सेवक अपने मालिक से बड़ो नाय होथै जाकै समकियो।’ अगर बे मोकै सताईं, तौ तुम्हऊँ कै सतांगे; अगर बे मेरी सिक्छा मानीं, तौ तुमरियौ मानंगे। ");
INSERT INTO thr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","पर जे सब चीज बे मेरे नाओं की बजह से तुमरे संग करंगे, काहैकि बे मेरे भेजन बारे कै नाय जानथैं। ");
INSERT INTO thr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","अगर मैं नाय आतो और उनसे नाय बतकातो, तौ बे पापी ना माने जाते; पर अब अपने पाप के ताहीं उनके झोने कोई बहाना नाय है। ");
INSERT INTO thr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जो मोसे बैर रखथै, बौ मेरे परम दऊवा से भी बैर रखथै। ");
INSERT INTO thr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","अगर मैं उनके बीच मैं काम नाय करतो जो कि और कोई नाय करो, तौ बे पापी नाय माने जाते; पर अब जब बे देख लईं हैं, तहुँओं मोसे और मेरे परम दऊवा दोनों से बैर करीं हैं। ");
INSERT INTO thr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","जौ इसलै भौ कि बौ बचन पूरो होबै, जो कि उनकी नियम मैं लिखो है, ‘बे मोसे खाली-मूली बैर करीं।’” ");
INSERT INTO thr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पर जब बौ मदत करन बारो आगो, जोकै मैं तुमरे झोने परम दऊवा परमेस्वर की तरफ से भेजंगो, मतलब कि सच्ची आत्मा जो कि परम दऊवा कि तरफ से निकरथै, तौ बौ मेरी गभाई देगो। ");
INSERT INTO thr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","और तुम्हऊँ मेरे गभा हौ काहैकि तुम सुरू से मेरे संग रहे हौ। ");
INSERT INTO thr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“जे बात मैं तुमसे इसलै कहो हौं कि तुम ठोकर नाय खाबौ। ");
INSERT INTO thr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","बे तुमकै सभाघर मैं से निकार देंगे, पर बौ समय आनबारो है, कि जो कोई तुमकै मार डारैगो बौ समझैगो कि मैं परमेस्वर की सेवा करथौं। ");
INSERT INTO thr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ऐसो बे इसलै करंगे कि बे ना तौ परम दऊवा कै जानीं हैं और ना तौ मोकै जानथैं। ");
INSERT INTO thr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पर जे बात मैं जौ ताहीं कहो, कि जब इनको समय आबै तौ तुमकै याद आए जाबै कि मैं तुमसे अग्गुए कह दौ रहों, मैं सुरू मैं तुमसे जे बात जौ ताहीं नाय कहो काहैकि मैं तुमरेई संग रहों।” ");
INSERT INTO thr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","पर अब मैं खुद के भेजन बारे के झोने जाएरौ हौं; और तुम मैं से कोई मोसे नाय पूँछ रौ है, कि तैं कहाँ जाएरौ है। ");
INSERT INTO thr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पर जो बात मैं तुमसे कहो हौं, जौ ताहीं तुमरो मन दुखी हुई गौ है। ");
INSERT INTO thr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तहुँओं मैं तुमसे सच्ची कहथौं कि मेरो जानो तुमरे ताहीं भलो है, काहैकि अगर मैं नाय जांगो तौ बौ मदत करन बारो तुमरे झोने नाय आगो; पर अगर मैं जांगो, तौ बाकै तुमरे झोने भेजंगो। ");
INSERT INTO thr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","और जब बौ आगो, तौ दुनिया के लोगन के सामने साबित करैगो कि बौ पाप और धार्मिकता के बारे मैं जो सई हैं और जो परमेस्वर के न्याय के जरिया गलत ठहरथैं। ");
INSERT INTO thr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पाप के बारे मैं जौ ताहीं कि बे मेरे ऊपर बिस्वास नाय करथैं; ");
INSERT INTO thr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","और धार्मिकता के बारे मैं जौ ताहीं कि मैं परम दऊवा के झोने जाएरौ हौं, और तुम मोकै कहुए नाय देखैगे; ");
INSERT INTO thr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","न्याय के बारे मैं जौ ताहीं कि जौ दुनिया को मुखिया कसूरवार मानो गौ है। ");
INSERT INTO thr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“मोकै तुमसे औरौ गजब एक बात बतकाने है, पर अभै तुम उनकै झेल नाय सकथौ। ");
INSERT INTO thr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पर जब बौ मतलब कि सच्चाई को आत्मा आबैगो, तौ तुमकै बौ सब सच्चाई को रहा बताबैगो, काहैकि बौ अपनी तरफ से नाय कहेगो, पर जो कछु सुनैगो बहे कहगो, और आनबारी बात तुमकै बताबैगो। ");
INSERT INTO thr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","बौ मेरी महिमा करैगो, काहैकि बौ मेरी बातन मैं से लैकै तुमकै बताबैगो। ");
INSERT INTO thr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जो कछु परम दऊवा को है, बौ सब मेरो है; जौ ताहीं मैं कहो कि बौ मेरी बातन मैं से लैकै तुमकै बताबैगो।” ");
INSERT INTO thr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“थोड़ी देर मैं तुम मोकै नाय देखैगे, और फिर थोड़ी देर मैं मोकै देखैगे।” ");
INSERT INTO thr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","तौ फिर बाके थोड़ी चेला आपस मैं बतकाईं, “जौ का है जो बौ आपन से कहरौ है, कि थोड़ी देर मैं तुम मोकै नाय देखैगे, और फिर थोड़ी देर मैं मोकै देखैगे? और जौ ‘इसलै कि मैं परम दऊवा के झोने जाएरौ हौं।’ ");
INSERT INTO thr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","तौ फिर बे कहीं, ‘जौ थोड़ी देर’ जो बौ कहरौ है, का बात है? हम नाय जानथैं कि बौ का कहरौ है!” ");
INSERT INTO thr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ईसु जानत रहै कि बे बासे सबाल पूँछनों चाहथैं, तभई उनसे कहथै, “मैं कहो, ‘थोड़ी देर मैं मोकै नाय देखैगे, और फिर थोड़ी देर मैं मोकै देखैगे।’ का तुम जहे बारे मैं पूँछ रहे हौ अपने आप? ");
INSERT INTO thr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मैं तुमसे सच्ची-सच्ची कहथौं कि तुम रोबैगे और विलाप करैगे, पर जौ दुनिया खुसी मनाबैगी; तुमकै दुख होगो, पर तुमरो दुख खुसी मैं बदल जागो। ");
INSERT INTO thr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","बालका होन के समय बईय्यर कै दुख होथै, काहैकि बाको दुख को समय आए चुको है, पर जब बौ बालका कै जनम दै चुकी होथै, तौ जौ खुसी से कि जौ दुनिया मैं एक इंसान पैदा भौ है, बौ दुख कै फिर दुबारा नाय समकथै। ");
INSERT INTO thr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","बैसिये तुम्हऊँ कै अभै तक दुख है, पर मैं तुमसे फिर से मिलंगो और तुमरे मन खुसी से भर जांगे; और तुमरी खुसी कै कोई तुमसे छीन नाय पागो।” ");
INSERT INTO thr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“बौ दिन तुम मोसे कछु नाय पूँछैगे। मैं तुमसे सच्ची-सच्ची कहथौं, अगर परम दऊवा से कछु माँगैगे, तौ बौ मेरे नाओं से तुमकै देगो। ");
INSERT INTO thr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","अभै तक तुम मेरे नाओं से कछु नाय माँगे; माँगौ, तौ पाबैगे ताकी तुमरी खुसी पूरी हुई जाबै।” ");
INSERT INTO thr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“मैं जे बात तुमसे कहानी मैं कहो हौं, पर बौ समय आनबारो है कि मैं तुमसे फिर कहु कहानी मैं नाय कहेंगो, पर खोलकै तुमकै परम दऊवा के बारे मैं बतामंगो। ");
INSERT INTO thr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","बौ दिन कै तुम मेरे नाओं से माँगैगे; और मैं तुमसे जौ नाय कहथौं कि मैं तुमरे ताहीं परम दऊवा से नहोरे करंगो; ");
INSERT INTO thr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","काहैकि परम पिता तौ खुदै तुमसे प्यार करथै, इसलै कि तुम मोसे प्यार करथौ और जहो बिस्वास करे हौ कि मैं परमेस्वर कि तरफ से आओ हौं। ");
INSERT INTO thr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मैं परम दऊवा कि तरफ से जौ दुनिया मैं आओ हौं; और मैं अब जौ दुनिया कै छोड़कै परम दऊवा के झोने जाएरौ हौं।” ");
INSERT INTO thr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","बाके चेला कहीं, “देख, अब तौ तैं खुलकै कहरौ है, और कोई कहानी नाय कहो। ");
INSERT INTO thr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","अब हम जानगै हैं कि तैं सब कछु जानथै, और जाकी जरूरत नाय कि कोई तोसे कछु पूँछै; जासे हम बिस्वास करथैं कि तैं परमेस्वर की तरफ से आओ है।” ");
INSERT INTO thr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","जौ सुनकै ईसु जबाब दई, “का तुम अब बिस्वास करथौ? ");
INSERT INTO thr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","देखौ, बौ समय आए रौ है बल्कि आए चुको है अब तुम सब जनी तितर-बितर हुईकै अपनो-अपनो रहा लेबैगे, और मोकै अकेलो छोड़ देगे; तहुँओं मैं अकेलो नाय काहैकि परम दऊवा मेरे संग है। ");
INSERT INTO thr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मैं जे बात तुमसे जौ ताहीं कहो हौं, कि तुमकै मेरे मैं सांति मिलै। जौ दुनिया से तुमकै कलेस होथै, पर हिम्मत भाँदौ, मैं जौ दुनिया कै जीत लौ हौं!” ");
INSERT INTO thr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ईसु जे बात बतकाई और अपनी आँखी स्वर्ग के घाँईं उठाएकै कही, “हे परम दऊवा, बौ समय आए चुको है; अपने लौड़ा की महिमा कर कि लौड़ौ तेरी महिमा करै, ");
INSERT INTO thr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","काहैकि तैं बाकै पूरी इंसानन की जाति के ऊपर अधिकार दौ, कि जोकै तैं बाकै दौ है बे सबन कै तैं अनंत जिंदगी दे। ");
INSERT INTO thr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","और अनंत जिंदगी जौ है कि बे खाली एक तैं सच्चो परमेस्वर कै और ईसु मसीह कै, जोकै तैं भेजो है, जानै। ");
INSERT INTO thr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","जो काम तैं मोकै करन के ताहीं दौ रहै, बाकै पूरो करकै मैं पृथ्वी मैं तेरी महिमा करो हौं। ");
INSERT INTO thr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","अब, हे परम दऊवा! तैं अपने संग मेरी महिमा बौ महिमा से कर जो जौ दुनिया के बनन से पहले, मेरी तेरे संग रहै।” ");
INSERT INTO thr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“मैं तेरो नाओं बे आदमिन के ऊपर दिखाओ हौं जोकै तैं जौ दुनिया से मोकै दौ। बे तेरे रहैं और तैं उनकै मोकै दौ, और बे तेरे बचन कै मान लईं हैं। ");
INSERT INTO thr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","अब बे जानगै हैं कि जो कछुए तैं मोकै दौ है बौ सब तेरे घाँईं से है; ");
INSERT INTO thr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","काहैकि जो बचन तैं मोकै दौ, मैं उनकै उनके झोने पुगाए दौ; और बे उनकै अपनाईं, और सच्ची-सच्ची जान लईं हैं कि मैं तेरी तरफ से आओ हौं, और बिस्वास कर लईं हैं कि तहीं मोकै भेजो है।” ");
INSERT INTO thr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","मैं उनके ताहीं नहोरे करथौं; जौ दुनिया के ताहीं नहोरे नाय करथौं पर उन्हईं के ताहीं जिनकै तैं मोकै दौ है, का है बे तेरे हैं। ");
INSERT INTO thr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","और जो कछु मेरो है बौ सब तेरो है, और जो तेरो है बौ मेरो है, और जासे मेरी महिमा दिखाई दई है। ");
INSERT INTO thr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","मैं अब जौ दुनिया मैं नाय रहमंगो, पर जे जौ दुनिया मैं रहमंगे, और मैं तेरे झोने आए रौ हौं। हे पवित्र दऊवा! अपने बौ नाओं से जो तैं मोकै दौ है, उनकै देखे रहिये कि बे आपन के हानी एक होमैं। ");
INSERT INTO thr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जब मैं उनके संग रहों, तौ मैं तेरे नाओं से, जो तैं मोकै दौ है उनकै मैं उनकै देखे रहो। मैं उनकी चौकीदारी करो, और बिनास करन बारे के लौड़ा कै छोड़कै उनमैं से कोई खतम नाय भौ, इसलै पवित्र सास्त्र मैं जो कहो गौ है बौ पूरो होबै। ");
INSERT INTO thr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","अब मैं तेरे झोने आथौं, और जे बात जौ दुनिया मैं कहथौं, कि बे मेरी खुसी अपने मैं पूरो पामैं। ");
INSERT INTO thr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मैं तेरो बचन उनकै पुगाए दौ हौं, और जौ दुनिया उनसे बैर करी, काहैकि जैसो मैं जौ दुनिया को नाय हौं, बैसिये बेऊँ जौ दुनिया के नाय हैं। ");
INSERT INTO thr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मैं जौ नहोरे नाय करथौं कि तैं उनकै जौ दुनिया से उठाएले; पर जौ कि तैं उनकै बौ दुस्ट से बचाए रखा। ");
INSERT INTO thr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जैसे मैं जौ दुनिया को नाय हौं, बैसिये बेऊँ जौ दुनिया के नाय हैं। ");
INSERT INTO thr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","सच्चाई के जरिये उनकै समर्पित कर; तेरो बचन सच्चो है। ");
INSERT INTO thr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जैसे तैं मोकै जौ दुनिया मैं भेजो, बैसिये महुँ उनकै जौ दुनिया मैं भेजो; ");
INSERT INTO thr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","और उनके ताहीं मैं अपने आपकै खुद समरपड़ करो हौं, ताकी बेऊँ सच्ची मैं तुमरे झोने समर्पित होमैं। ");
INSERT INTO thr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“मैं खाली इनके ताहीं नहोरे नाय करौ हौं, पर उन्हऊँ के ताहीं जो इनके बचन के जरिये मेरे ऊपर बिस्वास करंगे, ");
INSERT INTO thr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","कि बे सब एक होमैं; जैसो तैं परम दऊवा मेरे मैं है, और मैं तेरे मैं हौं, बैसिये बेऊँ हमरे मैं होमैं, जोसे जौ दुनिया बिस्वास करै कि तहीं मोकै भेजो है। ");
INSERT INTO thr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","बौ महिमा जो तैं मोकै दौ है, कि बैसिये महिमा मैं इनकैयो दौ हौं कि बे बैसिये एक होमैं जैसे कि आपन एक हैं, ");
INSERT INTO thr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मैं उनमैं और तैं मेरे मैं कि बे मजबूत हुईकै एक हुई जामैं, और जौ दुनिया जानै कि तहीं मोकै भेजो है, और जैसी तैं मोसे प्यार करो बैसिये उन्हऊँ से प्यार करो। ");
INSERT INTO thr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","हे परम दऊवा, मैं चाहथौं कि जिनकै तैं मोकै दौ है, जहाँ मैं हौं हुँआँ बेऊँ मेरे संग होमैं, कि बे मेरी बौ महिमा कै देखैं जो तैं मोकै दौ है, काहैकि जौ दुनिया बनन से अग्गु तैं मोसे प्यार करो। ");
INSERT INTO thr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","हे धार्मिक परम दऊवा, जौ दुनिया मोकै नाय जानी, पर मैं तोकै जानो; और जेऊँ जानीं कि तहीं मोकै भेजो है। ");
INSERT INTO thr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मैं तेरो नाओं उनकै बताओ और बतात रहमंगो कि जो प्यार तोकै मोसे रहै बौ प्यार उनमैं बसजाबै, और मैं उनमैं बसौं।” ");
INSERT INTO thr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ईसु जे बात कहकै अपने चेलन के संग किद्रोन घाटी के पाँजर गौ। हूँना एक बारी रहै, जोमैं बौ और बाके चेला गै। ");
INSERT INTO thr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","बाकै पकड़वान बारो यहूदौ बौ जघा जानत रहै, काहैकि ईसु अपने चेलन के संग हुँआँ जाए करत रहै। ");
INSERT INTO thr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तौ यहूदा, सिपईय्यन की एक टोली कै और मुखिया पुजारी और फरीसियन की तरफ से उनके काम करन बारेन कै लैकै, दिया और मसाल और हथियार लैकै हुँआँ आओ। ");
INSERT INTO thr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तौ ईसु, बे सब बातन कै जो बाके ऊपर आनबारी रहैं उनकै जानकै, निकरो और उनसे कही, “कौनकै ढूँड़ रै हौ?” ");
INSERT INTO thr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","बे बाकै जबाब दईं, “ईसु नासरी कै ढूँड़ रै हैं।” ईसु उनसे कही, “महीं हौं।” बाकै पकड़वान बारो यहूदौ हूँनै उनके संग ठाड़ो रहै। ");
INSERT INTO thr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ईसु के कहेत खिना कि, “कि महीं हौं,” बे पच्छू हुईकै धरती मैं गिर पड़े। ");
INSERT INTO thr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","तौ बौ फिर से उनसे पूँछी, “तुम कौनकै ढूँड़ रै हौ।” बे बोलीं, “ईसु नासरी कै।” ");
INSERT INTO thr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ईसु उनकै जबाब दई, “मैं तौ तुमसे कह चुको हौं कि महीं हौं, अगर तुम मोकै ढूँड़ रै हौ तौ इनकै जान देऔ।” ");
INSERT INTO thr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","जौ इसलै भौ कि बौ बचन पूरो होबै जो बौ कही रहै, “जिनकै तैं मोकै दौ उनमैं से मैं एकौ कै नाय हरबाओ।” ");
INSERT INTO thr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","तौ सिमौन पतरस तलवार कै, जो बाके झोने रहै, बाकै खींचकै और बड़ो पुजारी के कमईंयाँ के ऊपर चलाय कै बाको सीधे हाथ घाँईं को कान काट दई। बौ सेवक को नाओं मलखुस रहै। ");
INSERT INTO thr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तौ ईसु पतरस से कही, “अपनी तलवार कै म्यान मैं रख। जो कटोरा परम दऊवा मोकै दई है। का मैं बाकै पीमौं?” ");
INSERT INTO thr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तौ रोमी सिपईय्या और उनके सूबेदार और यहूदियन के रखबरेया ईसु कै पकड़कै भाँद लईं, ");
INSERT INTO thr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","और अग्गु बाकै हन्ना के झोने लैगै, काहैकि बौ बहे साल के बड़ो पुजारी कैफा को सुसर रहै। ");
INSERT INTO thr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","जौ बहे कैफा रहै, जो यहूदि नेतन कै सलाह दई रहै कि आपन के लोगन के ताहीं एक आदमी को मरनो अच्छो है। ");
INSERT INTO thr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","सिमौन पतरस और बाके संग एक चेला ईसु के पच्छू चल दईं। जौ चेला बड़ो पुजारी को जानो-पहचानो रहै, तभईये बौ ईसु के संग बड़ो पुजारी के घर के आँगन मैं गौ, ");
INSERT INTO thr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","लेकिन पतरस दुआरे फाटक मैं ठाड़ो रहो। तौ बौ दुसरो चेला जो बड़ो पुजारी को जानो-पहचानो रहै, बौ बाहर आओ और फाटक की रखबारी करन बारी से कहकै पतरस कै भीतर लैगौ। ");
INSERT INTO thr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","बौ फाटक की रखबारी करन बारी सेविका, पतरस से कही, “कहूँ तहूँ जौ आदमी के चेलन मैं से तौ नाय है?” बौ कही, “मैं नाय हौं।” ");
INSERT INTO thr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","सिपईय्या और सेवक जाड़े कि बजह से ठाड़कै आगी सेंकत रहैं, और पतरसौ उनके संग ठाड़कै आगी सेंकत रहै। ");
INSERT INTO thr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तौ बड़ो पुजारी ईसु से बाके चेलन के बारे मैं और बाके उपदेस के बारे मैं पूँछताछ करी। ");
INSERT INTO thr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ईसु उनकै जबाब दई, “मैं जौ दुनिया से खुलकै बात करो हौं; मैं सभाघरन मैं और मंदिर मैं, जहाँ पर सब यहूदि जुराए करत रहैं, हमेसा उपदेस दौ और लुके छुपे मैं कछु नाय कहो। ");
INSERT INTO thr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तैं मोसे काहेकै पूछरौ है? सुनन बारेन से पूँछ कि मैं उनसे का कहो हौं। देख, बे जानथैं कि मैं का-का कहो हौं।” ");
INSERT INTO thr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जब उनसे ऐसे कही, तौ रखबरेयन मैं से एक जो झोने ठाड़ो पड़ो रहै, ईसु कै झापड़ मारकै कही, “का तैं बड़ो पुजारी कै ऐसे करकै जबाब देथै?” ");
INSERT INTO thr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ईसु बाकै जबाब दई, “अगर मैं बुरो कहो, तौ बौ बुराई की गभाई दे; लेकिन अगर भलो कहो, तौ मोकै काहेकै मारथै?” ");
INSERT INTO thr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","हन्ना बाकै भँदे भै कैफा बड़ो पुजारी के झोने पुगाए दई। ");
INSERT INTO thr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","सिमौन पतरस ठाड़कै आगी सेंकत रहै। तौ बे बासे कहीं, “कहूँ तहूँ बाके चेलन मैं से तौ नाय है?” बौ मना करकै कही, “मैं नाय हौं।” ");
INSERT INTO thr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","बड़े पुजारी के सेवकन मैं से एक, जो बाके परिवार को रहै जोको कान पतरस काट दई रहै, बौ बोलो, “का मैं तोकै बाके संग बारेन मैं नाय देखो रहों?” ");
INSERT INTO thr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरस फिर से मना कर दई, और तुरंतै मुर्गा बास दई। ");
INSERT INTO thr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तौ बे फिर ईसु कै कैफा के झोने से रोमी हाकीम के महल मैं लैगै, और भुगभुको होन को समय रहै, लेकिन यहूदि नेता खुद महल के भीतर नाय गै कि कहूँ बे फसह खान से अग्गु अपवित्र नाय हुई जामैं, ताकी बे बाद मैं फसह खाए सकैं। ");
INSERT INTO thr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तौ फिर पिलातुस निकरकै उनके झोने आओ और कही, “तुम जौ आदमी के ऊपर कौन-सी बात को इल्जाम लगाथौ?” ");
INSERT INTO thr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","बे बाकै जबाब दईं, “अगर बौ कसूरवार नाय होतो तौ हम बाकै तेरे हाथ मैं काहेकै देते।” ");
INSERT INTO thr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुस उनसे कही, “तुम्हईं जाकै लैजाय कै अपनेई नियम के हिसाब से जाको न्याय करौ।” यहूदि बासे कहीं, “हमकै अधिकार नाय है कि कोई की जान लेमैं।” ");
INSERT INTO thr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","जौ इसलै भौ कि ईसु को बचन पूरो होबै, जोके जरिये बौ इसारा करी रहै कि बाकी मौत कैसे करकै होबैगी। ");
INSERT INTO thr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तौ फिर पिलातुस फिर महल के भीतर गौ, और ईसु कै बुलाएकै ईसु से पूँछीं, “का तैं यहूदियन को राजा है?” ");
INSERT INTO thr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ईसु जबाब दई, “का तैं जौ बात अपनी तरफ से कहरौ है या फिर कोई दुसरो मेरे बारे मैं तोसे जौ कही है?” ");
INSERT INTO thr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुस जबाब दई, “का मैं यहूदि हौं? तेरे अपने लोग और मुखिया पुजारी तोकै मेरे हाथ मैं सौंपीं हैं। तैं का करो है?” ");
INSERT INTO thr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ईसु जबाब दई, “मेरो राज्य जौ दुनिया मैं नाय है; अगर मेरो राज्य जौ दुनिया को होतो, तौ मेरे पछ लगुवा लड़ते और मोकै यहूदि नेतन के संग जान नाय देते; लेकिन मेरो राज्य हींना नाय है।” ");
INSERT INTO thr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","फिर पिलातुस कही, “तौ का तैं राजा है?” ईसु जबाब दई, “तैं कहथै कि मैं राजा हौं। मैं जौ ताहीं पैदा भौ हौं, और जौ ताहीं जौ दुनिया मैं आओ हौं कि सच्चाई की गभाई देयौं जो कोई सच्चो है, बौ मेरी सुनथै।” ");
INSERT INTO thr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुस बासे कही, “सच्चाई का है?” ऐसे कहकै बौ फिर यहूदियन के झोने निकर गौ और उनसे कही, “मोकै तौ बामै कोई दोस नाय मिलो। ");
INSERT INTO thr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","लेकिन तुमरी एक परम्परा है कि फसह के त्योहार मैं तुमरे ताहीं एक आदमी कै छोड़ दियौं। इसलै का तुम चाहथौ कि मैं तुमरे ताहीं यहूदियन के राजा कै छोड़ दियौं?” ");
INSERT INTO thr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तौ बे फिर चिल्लाए कै कहीं, “जाकै नाय! लेकिन तैं हमरे ताहीं बरअब्बा कै छोड़ दे!” और बरअब्बा डाँकू रहै। ");
INSERT INTO thr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","जौ सब सुनकै पिलातुस ईसु कै कोड़ा मरवाई। ");
INSERT INTO thr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपईय्या कांटेदार झाड़िन की हँगईय्यन कै मोड़कै कांटे को मुकुट बाके मुड़िया मैं पहनाईं, और बाकै बैंगनी रंग के लत्ता पहनाईं, ");
INSERT INTO thr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","और उनके झोने आए कै कहेन लागे, “ओ यहूदियन के राजा, जीते रहौ!” और बाकै चाँटा मारीं। ");
INSERT INTO thr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तौ फिर पिलातुस दुआरे निकरकै लोगन से कही, “देखौ, मैं बाकै फिर से तुमरे झोने लाथौं; ताकी तुम जानलेबौ कि मैं बामै कोई गलती नाय पाथौं।” ");
INSERT INTO thr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तौ फिर ईसु कांटे को मुकुट और बैंगनी रंग के लत्ता पहनकै दुआरे निकरो; और पिलातुस उनसे कही, “देखौ, जौ है बौ आदमी!” ");
INSERT INTO thr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","जब मुखिया पुजारी और रखबरेया बाकै देखीं, तौ चिल्लाए कै कहीं, “बाकै क्रूस मैं चढ़ाबौ, क्रूस मैं चढ़ाबौ!” पिलातुस उनसे कही, “तुम्हईं बाकै लैकै क्रूस मैं चढ़ाबौ, काहैकि मैं बामै कोई गलती नाय पाथौं।” ");
INSERT INTO thr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदि लोग बाकै जबाब दईं, “हमरो भी नियम है और बौ नियम के हिसाब से बौ मरनो चाहिए, काहैकि बौ अपने आपकै परमेस्वर को लौड़ा बताथै।” ");
INSERT INTO thr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जब पिलातुस जौ बात सुनी तौ बौ भौत डराय गौ। ");
INSERT INTO thr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","और फिर बौ महल के भीतर गौ, और ईसु से कही, “तैं कहाँ को है?” पर ईसु बासे एक अखरा तक नाय मस्की। ");
INSERT INTO thr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातुस बासे कही, “का तैं मोसे नाय मसकैगो? समझले, मोकै तोए छोड़न को अधिकार है और तोकै क्रूस मैं भी चढ़ान को अधिकार है।” ");
INSERT INTO thr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ईसु जबाब दई, “मेरे ऊपर तेरो जहे ताहीं अधिकार है कि जौ अधिकार तोए परमेस्वर दई है। इसलै जो आदमी मोए तोकै सौंपी, बौ एक बुरे पाप को कसूरवार है।” ");
INSERT INTO thr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","जब पिलातुस जौ सुनी, तौ बौ ईसु कै कैसियो करकै छोड़न के ताहीं कोसिस करी, पर यहूदि चिल्लाए-चिल्लाए कै कहीं, “अगर तैं जाकै छोड़ देगो, तौ जाको मतलब है कि तैं कैसर सम्राट को दोस्त ना है! जो कोई अपने आपकै राजा बनाथै बौ कैसर को सामना करथै।” ");
INSERT INTO thr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","जे बात सुनकै पिलातुस ईसु कै दुआरे लाई और बौ न्याय करन बारी जघा मैं जोकै चबूतरा कहो जाथै, बौ हिसाब करन ताहीं बैठगौ, जो इब्रानी मैं “गब्बता” कहो जाथै। ");
INSERT INTO thr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","और जौ फसह के एक दिन पहले को दिन रहै, फिर पिलातुस यहूदियन से कही, “देखौ, जहे है तुमरो राजा!” ");
INSERT INTO thr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पर बे चिल्लाईं, “बाकै मार डारौ! बाकै मार दियौ! बाकै क्रूस मैं चढ़ाबौ!” पिलातुस उनसे कही, “का मैं तुमरे राजा कै क्रूस मैं चढ़ामौं?” मुखिया पुजारी कहीं, “कैसर कै छोड़कै हमरो और कोई राजा ना है।” ");
INSERT INTO thr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तौ बौ ईसु कै उनके हाथ मैं सौंप दई ताकी बौ क्रूस मैं चढ़ाओ जाबै, तौ फिर बे ईसु कै हूँना से लैगै। ");
INSERT INTO thr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ईसु अपनो क्रूस उठाएकै बौ जघा ले दुआरे गौ, जो “खोपड़ी कि जघा” कहो जाथै, इब्रानी मैं जाकै “गुलगुता” कहो जाथै। ");
INSERT INTO thr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","हूँना बे बाकै क्रूस मैं चढ़ाईं; और बे दुई और आदमिन कै सूली मैं चढ़ाय दईं, बे ईसु के इतै-उतै सूली मैं चढ़ाय गै रहैं, और ईसु बीच मैं सूली मैं चढ़ाओ गौ रहै। ");
INSERT INTO thr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातुस एक खबर लिखकै और बाकै क्रूस मैं लटकाए दई और बामै ऐसे लिखो पड़ो रहै कि, “ईसु नासरी यहूदियन को राजा।” ");
INSERT INTO thr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","गजब यहूदियैं जाकै पढ़ी, काहैकि जो जघा मैं ईसु कै क्रूस मैं चढ़ाओ गौ रहै, बौ जघा सहर के झोनेई रहै और बौ इब्रानी और लतीनी और यूनानी मैं लिखो भौ रहै। ");
INSERT INTO thr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तौ फिर यहूदियन के मुखिया पुजारी पिलातुस से कहीं, “यहूदियन को राजा मत लिखै उल्टा ऐसे लिख कि बौ कही, ‘मैं यहूदियन को राजा’ हौं।” ");
INSERT INTO thr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुस जबाब दई, “मैं जो लिख दौ, सो लिख दौ।” ");
INSERT INTO thr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जब सिपईय्या ईसु कै क्रूस मैं चढ़ाय चुके, तौ बाके लत्ता लैकै बाके चार टुकड़ा करीं, और हर एक सिपईय्यन के ताहीं एक टुकड़ा, और बाको कुरता लै लईं, जो कि बौ कुरता तरे से ऊपर तक बिनो भौ और बिना सिलो भौ रहै; ");
INSERT INTO thr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","फिर बे आपस मैं बतकाईं, “आपन जे लत्तन कै नाय फाड़ैं, और जामैं चिट्ठी डारैं कि जे लत्ता कौनके होंगे।” जौ इसलै भौ, कि सास्त्र की बात पूरी होबै, “बे मेरे लत्ता आपस मैं बाँट लईं और मेरे लत्तन मैं चिट्ठी डारीं।” और सिपईय्या ऐसोई करीं। ");
INSERT INTO thr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ईसु के क्रूस के झोने बाकी अईय्या और बाकी अईय्या की बहेनिया मरियम, क्लोपास की बईय्यर और मरियम मगदलीनी ठाड़ी रहैं। ");
INSERT INTO thr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ईसु अपनी अईय्या और बौ चेला कै जोसे बौ प्यार करत रहै झोने ठाड़े भै देखकै अपनी अईय्या से कही, “जौ तेरो लौड़ा है।” ");
INSERT INTO thr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","फिर बौ चेला से कही, “जौ तेरी अईय्या है।” और बहे समय से बौ चेला, बाकै अपने घरै रहन ताहीं लैगौ। ");
INSERT INTO thr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","जाके बाद ईसु जौ जानकै कि अब सब कछु पूरो हुई चुको; इसलै कि पवित्र सास्त्र मैं जो कहो गौ बौ पूरो होबै फिर कही, “मैं प्यासो हौं।” ");
INSERT INTO thr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","हूँना दाखरस को एक सिरका से भरो भौ बर्तन धरो रहै, इसलै बे सिरका के भीजे भै सोकता कै जूफा कठिया मैं धरकै बाके मोहों से लगाईं। ");
INSERT INTO thr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","जब ईसु बौ सिरका पी लई, और कही, “पूरो भौ!” और अपनो मूड़ झुकाए कै अपनी जान छोड़ दई। ");
INSERT INTO thr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","तौ फिर यहूदि नेता पिलातुस से नहोरे करीं, कि उनकी टाँग तोड़ दई जाबै और उनके सव उतारे जामैं, ताकी साबत के दिन बे क्रूस मैं नाय रहमैं, काहैकि साबत को दिन बड़ो दिन रहै। ");
INSERT INTO thr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","तौ फिर सिपईय्या आयकै बे आदमिन मैं से पहले बारे आदमी की टाँग तोड़ीं फिर दुसरे की, जो ईसु के संग क्रूस मैं चढ़ाय गै रहैं; ");
INSERT INTO thr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","फिरौंकी बे जब ईसु के झोने आयकै देखीं कि बौ मर चुको है, तौ बाकी टाँग कै नाय तोड़ीं। ");
INSERT INTO thr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","लेकिन सिपईय्यन मैं से एक जनी बाकै बरछी से पुसरिया मैं छेद दई, और बामै से तुरंत खून और पानी निकरो। ");
INSERT INTO thr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जो जौ देखी, बहे जौ गभाई दई है, और बाकी गभाई सच्ची है; और बौ जानथै, कि सच्ची कहथै कि तुम बिस्वास करौ। ");
INSERT INTO thr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","काहैकि जे बात जहे ताहीं भईं कि पवित्र सास्त्र की बात पूरी होबै, “और बाकी कोई हड्डी तोड़ी नाय जागी।” ");
INSERT INTO thr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फिर एक और सास्त्र जौ कहथै, “जोकै बे छेदी रहैं, बाके घाँईं देखंगे।” ");
INSERT INTO thr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","जे बातन के बाद अरिमतियाह को यूसुफ, जो ईसु को चेला रहै (काहैकि यहूदियो के डर के मारे जौ बात कै बतात नाय रहै) पिलातुस से नहोरे करी, कि मैं ईसु के सव कै लै जामौं, और पिलातुस बाके नहोरे कै सुन लई, और बौ आए कै बाकी लास कै लैगौ। ");
INSERT INTO thr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस जो पहली बार रात मैं ईसु से मिलन कै गौ रहै, युसुफ के संग लोबान और एलबा से बनाओ गौ तीस किलो महाकनबारी चीज, लैकै गै। ");
INSERT INTO thr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तौ बे ईसु के सव कै लईं और यहूदियन की गाड़न के नियम के अनुसार महाकनबारी चीज और लोहबान के संग कफन के लत्ता मैं लपेट दईं। ");
INSERT INTO thr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","बौ जघा जितै पर ईसु कै क्रूस मैं लटकाईं रहैं, हुँआँ एक बारी रहै; और बौ बारी मैं एक कबर रहै; जामैं कभी कोई नाय रखो गौ रहै। ");
INSERT INTO thr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","काहैकि जौ यहूदियन के साबत के एक दिन पहले को रहै और कबर झोने होन के बजह से ईसु की सरीर कै हूँनै रख दईं। ");
INSERT INTO thr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","सप्ताह के पहले दिन इतवार कै मरियम मगदलीनी भुकभुको होन से अग्गु अंधियारे मैं कबर मैं आईं, और बौ हुँआँ पर पथरा कै कबर मैं से हटो भौ देखीं। ");
INSERT INTO thr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","बौ फिर दौड़कै सिमौन पतरस और दुसरे चेलन के झोने गई जोसे ईसु प्यार करत रहै, उनसे आए कै कही, “बे प्रभु कै कबर मैं से निकार लैगै, और हम नाय जानथैं कि बे बाकै कहाँ धरी हैं!” ");
INSERT INTO thr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तौ फिर पतरस और बौ दुसरो चेला कबर मैं गै। ");
INSERT INTO thr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","बे दोनों जनी संग-संग दौड़त रहैं, पर दुसरो चेला पतरस से अग्गु बढ़कै कबर मैं अग्गु पुगो; ");
INSERT INTO thr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","और बौ लोहोक्कै बाके लत्ता पड़े भै देखी, तहुँओं बौ भीतर नाय गौ। ");
INSERT INTO thr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","फिर सिमौन पतरस बाके पच्छू-पच्छू पुगो, और कबर के भीतर गौ और लत्ता पड़े भै देखी; ");
INSERT INTO thr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","और बौ अंगोछा जो ईसु को मूड़ से भँदो रहत रहै, बौ लत्तन के संग पड़ो भौ नाय, बल्किन अलग्याँओं एक जघा लिपटो धरो भौ देखी। ");
INSERT INTO thr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तौ दुसरो चेलौ जो कबर मैं अग्गु पुगो रहै, भीतर गौ और देखकै बिस्वास करी। ");
INSERT INTO thr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","बे तौ अभैले पवित्र सास्त्र की बौ बात नाय समझी रहैं कि बाकै मरे भैन मैं से जिंदो उठने होगो। ");
INSERT INTO thr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","फिर बे चेला अपने घरै लौट गै। ");
INSERT INTO thr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","मरियम रोत भइ कबर के दुआरे ठाड़ी रइ, तौ बौ रोत भइ लोहोक्कै कबर मैं देखी। ");
INSERT INTO thr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","और हूँना देखी कि दुई स्वर्गदूत सेतो लत्ता पहने रहैं, जितै ईसु की सरीर रहै, एक कै सिराने और दुसरे कै टाँग घाँईं बैठो भौ देखी। ");
INSERT INTO thr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","बे स्वर्गदूत बासे कहीं, “अरे बईय्यर तैं काहेकै रोय रइ है?” बौ फिर उनसे कही, “बे मेरे प्रभु कै उठाए लैगै हैं और मोकै पता नाय है कि बे बाकै कहाँ धरी हैं।” ");
INSERT INTO thr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ऐसे कहकै बौ पच्छू मुरकी और हुँआँ ईसु कै ठाड़ो भौ देखी; पर बौ नाय जानत रहै कि बौ ईसु है। ");
INSERT INTO thr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ईसु बासे पूँछी, “ओ बईय्यर, तैं काहेकै रोए रइ है? बौ कौन है जोकै तैं ढूँड़ रइ है?” बौ बाकै माली समझकै बासे कही, “महाराज, अगर तैं बाकै उठाए लैगौ है तौ मोकै बता कि बाकै कहाँ धरो है, और मैं बाकै लै जांगो।” ");
INSERT INTO thr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ईसु बासे कही, “मरियम!” बौ पच्छू मुड़कै बासे इब्रानी भासा मैं कही, “रब्बूनी!” जाको मतलब है “गुरु।” ");
INSERT INTO thr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ईसु बासे कही, “मोकै मत छूबै, काहैकि मैं अभै तक परम दऊवा के झोने ऊपर नाय गौ हौं, पर मेरे भईय्यन के झोने जाएकै उनसे कहदे, कि मैं अपने परम दऊवा, और तुमरे परम दऊवा, और अपने परमेस्वर और तुमरे परमेस्वर के झोने ऊपर जाथौं।” ");
INSERT INTO thr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","फिर मरियम मगदलीनी गईं और चेलन से कहीं कि बौ प्रभु कै देखीं है और जहो बताईं की प्रभु उनके बारे मैं का-का कही है। ");
INSERT INTO thr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","सप्ताह के पहले दिन इतवार कै, संजा के समय हुँआँ पर चेला फाटक बंद करकै एक कमरा मैं जुराने रहैं, काहैकि बे यहूदियन के नेतन से डरात रहैं। तौ फिर ईसु आओ और उनके बीच मैं ठाड़कै उनसे कही, “तुमकै सांति मिलै।” ");
INSERT INTO thr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","और ऐसे कहकै बौ अपने हाथ और अपनी पुसरिया उनकै दिखाई, तौ फिर चेला प्रभु ईसु कै देखकै खुस हुईगै। ");
INSERT INTO thr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ईसु फिर उनसे कही, “तुमकै सांति मिलै; जैसे परम दऊवा मोकै भेजी है, ऐसियै महुँ तुमकै भेजथौं।” ");
INSERT INTO thr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","जौ कहकै बौ उनके ऊपर फूँकी और उनसे कही, “पवित्र आत्मा लेबौ। ");
INSERT INTO thr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","अगर तुम लोगंन के पाप कै माफ करथौ, तौ उनकै माफ कर दौ जाथै, अगर तुम उनकै माफ नाय करथौ, तौ उनकै माफ नाय करो जाथै।” ");
INSERT INTO thr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","लेकिन बारह मैं से एक जनी यानी थोमा जो दिदुमुस कहो जात रहै, जब ईसु आओ तौ उनके संग ना रहै। ");
INSERT INTO thr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जब और चेला बासे कहेन लागे, “कि हम प्रभु कै देखे हैं,” तौ बौ उनसे कही, “जबले मैं बाके हातन मैं कील के भार नाय देख लेमौं, और कीलन के भार मैं अपनी उँगरिया नाय डार लेमौं, तौले मैं बिस्वास नाय करंगो।” ");
INSERT INTO thr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","एक सप्ताह के बाद बाके चेला फिर घर के भीतर रहैं, और थोमा उनके संग रहै; और फाटक बंद रहैं, तौ फिर ईसु आओ और उनके बीच मैं ठाड़कै कही, “तुमकै सांति मिलै।” ");
INSERT INTO thr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तौ ईसु थोमा से कही, “अपनी उँगरिया हींना लाए कै मेरे हातन मैं रख और अपने हात लायकै मेरी पुसरिया मैं डार और अविस्वासी ना बल्कि बिस्वास कर।” ");
INSERT INTO thr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","जौ सुनकै थोमा जबाब दई, “हे मेरे प्रभु, हे मेरे परमेस्वर!” ");
INSERT INTO thr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ईसु बासे कही, “तैं मोकै देखो है, का जहे ताहीं तैं बिस्वास करो है? धन्य बे हैं जो बिना देखे बिस्वास करीं हैं!” ");
INSERT INTO thr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ईसु और गजब एक चिन्ह चेलन के अग्गु दिखाई, जो जौ किताब मैं लिखो नाय गौ है। ");
INSERT INTO thr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पर जे इसलै लिखे गै हैं, कि तुम बिस्वास करौ, कि ईसु ही परमेस्वर को लौड़ा मसीह है, और बिस्वास करकै बाके नाओं से जिंदगी पाबौ। ");
INSERT INTO thr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","जाके बाद ईसु तिबिरियुस झील मैं अपने चेलन के झोने एक बार फिर से आओ, जौ ऐसे भौ है। ");
INSERT INTO thr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","सिमौन पतरस, और थोमा जो दिदुमुस कहो जाथै, और गलील के काना सहर को नतनएल, और जब्दी को लौड़ा, और बाके चेलन मैं से दुई जनी और जुराने रहैं। ");
INSERT INTO thr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","सिमौन पतरस उनसे कही, “मैं मच्छी मारन कै जाएरौ हौं।” बे बासे कहीं, “हमउँ तेरे संग चलथैं।” और बे निकरकै नईंयाँ मैं बैठकै चले गै, पर बौ रात कै कछुए नाय पकड़ पाईं। ");
INSERT INTO thr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","भोर होत खिना कि ईसु डींड़े मैं आयकै ठाड़गौ; तहुँओं चेला नाय जान पाईं कि जौ ईसु है। ");
INSERT INTO thr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तौ फिर ईसु उनसे कही, “बालकौ, का तुमरे झोने थोड़ी मच्छी हैं?” बे जबाब दईं, “ना हैं।” ");
INSERT INTO thr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","बौ उनसे कही, “नईंयाँ के सीधे हात घाँईं जार डारौ तौ मिल जांगी।” तौ फिर बे जार डारीं, और गजब एक मच्छी होन की बजह से बे जार कै खींच तक नाय पाईं काहैकि मच्छी उनके काबू से बाहर रहैं। ");
INSERT INTO thr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तौ फिर बौ चेला जोसे ईसु प्यार करे करत रहै, बौ पतरस से कही, “जौ तौ प्रभु है!” सिमौन पतरस जौ सुनकै कि बौ प्रभु है, करिहाँओं मैं अंगोछा कर्‌रे से कस लई, काहैकि पतरस नंगो रहै, और झील मैं कूद पड़ो। ");
INSERT INTO thr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","और दुसरे चेला मच्छी से भरे भै जार कै खींचकै छोटी नईंयाँ मैं बैठगै, बे जमीन से जद्धा दूर नाय रहैं, बे लमसम जमीन से सौ मीटर दूर रहैं। ");
INSERT INTO thr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जब बे डींड़े मैं उतरे, तौ बे कुइला की आगी और बामै मच्छी धरी भइ, और रोटी देखीं। ");
INSERT INTO thr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ईसु उनसे कही, “जो मच्छी तुम अभई मारे हौ, उनमैं से थोड़ी लाबौ।” ");
INSERT INTO thr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","तौ सिमौन पतरस नईंयाँ मैं चढ़कै एक सौ तिरेपन बड़ी मच्छिन से भरो भौ जार डींड़े मैं खींची, और इत्ती मच्छी होन की बजह से भी जार नाय फटो। ");
INSERT INTO thr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ईसु उनसे कही, “आबौ, खानु खाबौ।” चेलन मैं से कोई की हिम्मत नाय पड़ी की बासे पूँछै, “कि तैं कौन है?” काहैकि बे जानत रहैं कि जौ प्रभु है। ");
INSERT INTO thr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ईसु आओ और रोटी लैकै उनकै दई, और बैसिये मच्छियौ दई। ");
INSERT INTO thr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","जौ तिसरी बार है कि ईसु मरे भैन मैं से जिंदो होन के बाद चेलन कै दिखाई दई। ");
INSERT INTO thr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","खानु खान के बाद ईसु सिमौन पतरस से कही, “सिमौन, यूहन्ना को लौड़ा, का तैं इन सबसे अगरो प्यार करथै?” सिमौन पतरस बासे कही, “हाँ, प्रभु; तैं तौ जानथै कि मैं तोसे प्यार करथौं,” ईसु बासे कही, “मेरे मेम्नन कै चुगा।” ");
INSERT INTO thr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","बौ फिर दुसरी बार बासे कही, “सिमौन, यूहन्ना को लौड़ा, का तैं मोसे प्यार करथै?” सिमौन ईसु से कही, “हाँ, प्रभु; तैं जानथै कि मैं तोसे प्यार करथौं।” ईसु बासे कही, “मेरी भेंड़न की रखबारी कर।” ");
INSERT INTO thr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","फिर बौ तिसरी बार बासे कही, “सिमौन, यूहन्ना को लौड़ा, का तैं मोसे प्यार करथै?” पतरस को मोहों लटक गौ ऐसे करकै कि ईसु बासे तिसरी बार ऐसो कही, “कि का तैं मोसे प्यार करथै?” फिर ईसु से कही, “प्रभु, तैं तौ सब कछु जानथै; तैं जहो जानथै कि मैं तोसे प्यार करथौं।” ईसु बासे कही, “मेरी भेंड़न की रखबारी कर। ");
INSERT INTO thr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","मैं तोसे सच्ची-सच्ची कहथौं, जब तैं ज्वान रहै तौ अपनो करिहाँओं भाँदकै जहाँ मन होत रहै हुँए चल देत रहै; पर जब तैं बुढ्ढो पड़ैगो तौ अपने हाथ फैलागो, और कोई दुसरो तेरो करिहाँओं भाँदकै जहाँ तेरो मन नाय होगो हूँना लै जागो।” ");
INSERT INTO thr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ईसु जे बातन से इसारा करी, कि पतरस कैसे करकै मरैगो, और परमेस्वर की महिमा करैगो। और फिर ईसु बासे कही, “मेरे पच्छू चल दे!” ");
INSERT INTO thr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरस मुड़कै बौ चेला कै पच्छू आत भौ देखी, जोसे ईसु प्यार करे करत रहै, और जो खानु खान के समय ईसु की छाती के घाँईं लोहोक्कै पूँछी रहै, “प्रभु, कि तोकै पकड़वान बारो कौन है?” ");
INSERT INTO thr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","बाकै देखकै पतरस ईसु से कही, “प्रभु, जाको का हाल होगो?” ");
INSERT INTO thr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ईसु बासे कही, “अगर मैं चाहथौं कि बौ मेरे आन तक रुको रहबै, तौ तोकै जासे का? तैं मेरे पच्छू आ!” ");
INSERT INTO thr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","तौ फिर ईसु के विस्वासी भईय्यन मैं जौ बात फैल गई कि बौ चेला ना मरैगो; पर ईसु बासे ऐसे कहिये नाय रहै कि बौ ना मरैगो, बौ ऐसे करकै कही रहै, “कि अगर मैं चाहमौं कि बौ मेरे आन तक रुको रहबै, तौ तोकै जासे का?” ");
INSERT INTO thr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","जौ बहे चेला है जो जे बातन की गभाई देथै और जो जे बातन कै लिखी है, और हम जानथैं कि बाकी गभाई सच्ची है। ");
INSERT INTO thr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","औरौ भौत से काम हैं, जो ईसु करी है; अगर बे एक-एक करकै लिखे जाते, तौ मैं समझथौं कि किताबैं जो लिखी जातीं, तौ बे जौ दुनिया तक मैं नाय अपातीं।");
INSERT INTO thr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","प्रिय थियुफिलुस: मैं अपनी पहली किताब मैं बे सब चीजन के बारे मैं लिखो जो ईसु करी रहै और बौ समय से सिखाओ रहौं जब बौ अपनो काम सुरू करी रहै ");
INSERT INTO thr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","बौ दिन तक बौ स्वर्ग मैं लैजाओ गौ रहै। जासे पहले कि बौ उठाओ लौ जातो, बौ पवित्र आत्मा की सक्ति के जरिये अपने प्रेरितन के रूप मैं चुने गै लोगन कै निर्देस दई। ");
INSERT INTO thr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","अपनी मौत के बाद चालीस दिन ले बौ भौत बार दिखाई दौ जासे साबित भौ कि बौ जिंदो है। बे बाकै देखीं, और बौ उनके संग परमेस्वर के राज्य के बारे मैं बात करी। ");
INSERT INTO thr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","और जब बे सब एक संग आए, तौ बौ उनकै जौ आदेस दई: “यरूसलेम कै मत छोड़ौ, लेकिन जो उपहार के बारे मैं मैं तुम्हैं बताओ हौं, बाकै असियाबौ, बौ उपहार जोको मेरो दऊवा वादा करी रहै। ");
INSERT INTO thr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","यूहन्ना पानी से बपतिस्मा लई, लेकिन कुछै दिनन मैं तुम पवित्र आत्मा के संग बपतिस्मा लेगे।” ");
INSERT INTO thr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","जब प्रेरित ईसु के संग मिले, तौ बे बासे पूँछीं, “हे प्रभु, का तैं जौ समय राज्य कै बापस इस्राएल कै देगो?” ");
INSERT INTO thr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ईसु उनसे कही, “समय और मौका मेरे दऊवा के अपने अधिकार के जरिये तैं करो गौ है, और जौ जाननो तुमरे ताहीं नाय है कि बे कब होमंगे। ");
INSERT INTO thr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","लेकिन जब पवित्र आत्मा तुमरे ऊपर आगो तौ तुम सामर्थ्य से भर जागे, और तुम यरूसलेम मैं, यहूदिया, सामरिया और पृथ्वी के छोर तक मेरे ताहीं गभा बनैगे।” ");
INSERT INTO thr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","जौ कहेन के बाद, बाकै स्वर्ग मैं लैजाओ गौ काहैकि बे बाकै देखत रहैं, और एक बादर उनकै अपनी नजर से लुकाए दई। ");
INSERT INTO thr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","जब बे चले गै, तहुँओं उनकी निघा आसमान मैं टिकी रइ, जब सेतो लत्ता पहने दुई आदमी अनकाचीति उनके झोने ठाड़े रहैं ");
INSERT INTO thr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","और कही, “गलील, तुम हूँना ठाड़कै आसमान के घाँईं काहे देखरै हौ? जौ ईसु, जो तुमरे झोने से स्वर्ग मैं लैजाओ गौ रहै, बहे तरीका बापस आबैगो जो तरीका से तुम बाकै स्वर्ग जात भइ देखे रहौ।” ");
INSERT INTO thr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","तौ प्रेरित जैतून नाओं के पहाड़ से यरूसलेम के घाँईं गै, यरूसलेम सहर से लमसम आधी मील की दूरी मैं है। ");
INSERT INTO thr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","बे सहर मैं आत खिना कि बौ कमरा मैं गै, जहाँ बे रुके भै रहैं: पतरस, यूहन्ना, याकूब और अन्द्रियास, फिलिप्पुस और थोमा, बरतुल्मै और मत्ती, हलफई का लौड़ा याकूब, देसभक्त सिमौन, और याकूब का लौड़ा यहूदा। ");
INSERT INTO thr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","जे सब तमान बईंय्यरैं और ईसु की अईय्या मरियम और बाके भईय्यन के संग झुंड मैं प्रार्थना करन के ताहीं इखट्टे होबै करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","कुछ दिनन के बाद पतरस सब विस्वासी भईय्यन के बीच मैं, जो एक सौ बीस आदमी के लमसम रहैं, बौ हूँना ठाड़कै कहेन लागो। ");
INSERT INTO thr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","बौ कहीं, “मेरे भईय्यौ, पवित्र सास्त्र कै सच होनो जरूरी रहै, जोमैं पवित्र आत्मा, दाऊद के जरिये बोलत भै यहूदा के बारे मैं एक भविस्यवाँड़ी करी रहै, जो ईसु कै पकड़वान बारेन के ताहीं अगुवन रहै। ");
INSERT INTO thr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहूदा हमरे झुंड को सदस्य रहै, काहैकि बाकै हमरे काम मैं सेवकाई मैं हिस्सा लेन के ताहीं चुनो गौ रहै।” ");
INSERT INTO thr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","यहूदा कै अपने अधर्म के कामन के ताहीं जो पैसा मिलो, बासे बौ एक खेत खरीदी जितै बाकी मौत ही गई; बाको पेट फट गौ और बाकी पूरी भीतर की आँती बाहर निकर आई। ");
INSERT INTO thr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","यरूसलेम मैं रहन बारे सबै आदमी जाके बारे मैं सुनीं, और इसलै उनकी अपनी भासा मैं बे बौ जघा कै हकलदमा कहीं, जो मतलब है “खून को खेत।” ");
INSERT INTO thr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“जाके ताहीं भजन संहिता की किताब मैं लिखो गौ है, ‘बाको घर खाली हुई जाबै; कोई भी जामैं नाय रह सकथै।’ जहो लिखो है: ‘कोई और भी बाकी सेवा लै सकथै।’” ");
INSERT INTO thr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“इसलै जितने दिन ले प्रभु ईसु हमरे संग आत जात रहो, ठीक जौ है कि उनमैं से एक आदमी बाके जी उठन को गभा ही जाबै, ");
INSERT INTO thr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","मतलब यूहन्ना के बपतिस्मा से लैकै बाके हमरे झोने से जी उठाए जान तक, जो लोग बराबर हमरे संग रहे।” ");
INSERT INTO thr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तौ बे दुई आदमी कै ठड़बाईं: एक यूसुफ जो बरसब्बास कहो जात रहै बाको उपनाओं यूस्तुस है, और दुसरो मत्तियाह कहो जात रहै। ");
INSERT INTO thr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","फिर बे प्रार्थना करीं, “प्रभु, तैं सबन के बिचारन कै जानथै, इसलै हमकै दिखा कि इन दोनों मैं से कौनकै चुनो है ");
INSERT INTO thr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","कि बाकै जौ सेवकाई और प्रेरित को पद मिलै, जो यहूदा छोड़कै अपने जघा कै चले गौ है।” ");
INSERT INTO thr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तौ बे दोनों आदमिन कै छाँटन के ताहीं उनके बीच भौत कुछ मुहान कि कोसिस करीं, और एक चुने भौ मत्तियाह रहै, जोकै ग्यारह प्रेरितन के झुंड मैं जोड़ो गौ रहै। ");
INSERT INTO thr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जब पिन्तेकुस्त को दिन आओ तौ सबै विस्वासी एक जघा जुराने। ");
INSERT INTO thr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","अनकाचीति आसमान से बड़ा तगड़ी आँधी की सनसनाहट जैसी अबाज सुनन मैं आई, और बासे पूरो घर जहाँ बे बैठे रहैं, झन्नाए पड़ो। ");
INSERT INTO thr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","फिर बे देखीं कि आगी की जीभ कैसी दिखाए रइ है जो फैल गई और हुँआँ सबै आदमी कै छुइ लई। ");
INSERT INTO thr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","और बे सब पवित्र आत्मा से भर गै, और पवित्र आत्मा उनकै बोलन की सामर्थ्य दई, और बे अलग-अलग भासा बोलन लगे। ");
INSERT INTO thr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","यरूसलेम मैं रहन बारे यहूदि रहैं, धार्मिक लोग जो दुनिया के हर देस से आए रहैं। ");
INSERT INTO thr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जब बे जौ गलु सुनीं बड़ा जोड़ भीड़ इखट्टी हुई गई। बे सबै उत्साहित रहैं, काहैकि सबै विस्वासिन कै अपनी भासा मैं बात करत भइ सुनीं। ");
INSERT INTO thr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","बे सब चकाय गै और अचम्मो हुईकै कहीं, “जे लोग जो जे तरहन की बात कर रै हैं जे गलीली हैं! ");
INSERT INTO thr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तौ फिर काहेकै, हममैं से हर एक अपनी-अपनी जलमत की भासा कै नाय सुनथैं? ");
INSERT INTO thr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हम पारथी, और मेदी, एलामी से हैं; मेसोपोटामिया, यहूदिया और कप्पदूकिया से; पुन्तुस और आसिया से, ");
INSERT INTO thr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रूगिया और पंफूलिया से, मिस्र से और साइरेन के झोने लीबिया के इलाका से। हममैं से कुछ रोम से हैं, ");
INSERT INTO thr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","और दोनों यहूदि धर्म मैं बदल गै, और हममैं से कुछ क्रेती और अरब से हैं, फिर भी हम सबै उनकै अपनी-अपनी भाँसड़ मैं बे महान चीजन के बारे मैं बोलत भै सुने, जो परमेस्वर करी है!” ");
INSERT INTO thr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","और बे सब चकित भै और डराय कै एक दुसरे से कहेन लगे, “जाको का मतलब है?” ");
INSERT INTO thr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","लेकिन दुसरे विस्वासियन को मजाक उड़ाए कै कहीं, “बे लोग नसा मैं हैं!” ");
INSERT INTO thr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तौ पतरस दूसरे ग्यारह प्रेरितन के संग ठाड़ो और खूब जोड़ से भीड़ से कहेन लागो: “मूर्ख यहूदियो और तुम सब जो यरूसलेम मैं रहथौ, मेरी बात सुनौ और मोकै बताबौ कि जाको का मतलब है। ");
INSERT INTO thr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","आदमी नसा मैं नाय हैं जैसो तुम समझ रै हौ; जे आदमी नसा मैं नाय हैं, काहैकि हबै तौ सुबेरे के नौवें बजे हैं। ");
INSERT INTO thr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","जाके अलावा, जौ बौ बात है, जो योएल भविस्यवक्ता कही रहै: ");
INSERT INTO thr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘परमेस्वर कहथै: जौ बहे है जोमैं आखरी दिनन मैं करंगो, कि मैं अपनी आत्मा सब इंसानन मैं अखनांगो। तुमरे लौड़ा और लौड़िया मेरे संदेस की भविस्यवाँड़ी करंगे; तुमरे ज्वानन कै दर्सन दिखाई देंगे, और तुमरे बड़े-बूढ़े सपनो देखंगे। ");
INSERT INTO thr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","हाँ, मेरे सेवकन मैं, हींना तक कि लोग और बईंय्यरैं दोनों मैं, मैं बे दिनन मैं अपनी आत्मा कै बहार निकारंगो, और बे मेरे संदेस को ऐलान करंगे। ");
INSERT INTO thr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","मैं ऊपर आसमान मैं चिन्ह चमत्कार करंगो, और तरे धरती मैं चिन्ह चमत्कार करंगो। खून, आगी और घनों धुआँ होगो; ");
INSERT INTO thr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","सूरज अंधियारो हुई जाबैगो, और जोनी खून हानी लाल हुई जाबैगी प्रभु को महान और गौरवसाली दिन आन से पहले ");
INSERT INTO thr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","और फिरौंकी जो कोई भी मदत के ताहीं प्रभु कै पुकारैगो बाकै बचाओ जागो।’” ");
INSERT INTO thr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“इस्राएलियौ! जे सब्दन कै सुनौ, नासरत को ईसु एक ऐसो इंसान रहै जोको ईस्वरीय अधिकार तुमकै बे सबै सामर्थ्य और चिन्ह चमत्कारन से सपा तरीका से सिद्ध भौ, जो परमेस्वर बाके जरिये करी रहै, जौ तुम खुद जानथौ, काहैकि हींना तुमरे बीच ऐसो भौ रहै। ");
INSERT INTO thr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","अपनी योजना के अनुसार परमेस्वर पहलिये तैं कर लई रहै की ईसु कै तुमकै सौंप दौ जागो; और तुम पापियन के हात से क्रूस मैं चढ़ायकै बाकै मार डारे। ");
INSERT INTO thr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पर परमेस्वर बाकै मौत से उठाई, बाकै अपनी सक्ति से आजाद करी, काहैकि जौ मुम्किम नाय रहै कि मौत बाकै कैदी बनाये कै रखाबै। ");
INSERT INTO thr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","दाऊद बाके बारे मैं कहथै, ‘मैं प्रभु कै हमेसा अपने अग्गु देखत रहथौं; बौ मेरे झोने है, और मैं परेसान नाय होमंगो। ");
INSERT INTO thr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","और इसलै मैं मन मैं खुसी से भरगौ, और मेरे बचन खुसी से भरे हैं और हालाकि मैं सारीरिक हौं, आसा मैं हिम्मत दई जागी, ");
INSERT INTO thr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","काहैकि तुम मोकै नरक के भीतर नाय छोड़ैगे; तुम अपने वफादार दास कै सड़न ना देबैगे। ");
INSERT INTO thr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तैं तौ मोए जिंदगी की रहा बताओ है। और तेरी मौजूदगी मोकै खुसी से भर देबैगी।’” ");
INSERT INTO thr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“मेरे दोस्तौ, मोकै तुमसे हमरे प्रसिद्ध बड़े-बूढ़े राजा दाऊद के बारे मैं सपा तरीका से बात करनी चाहिए। बौ मर गौ और बाकै दफनाए दौ गौ, और बाकी कबर आज भी हमरे पास है। ");
INSERT INTO thr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","बौ एक भविस्यवक्ता रहै, और बौ जानत रहै कि परमेस्वर बासे का वादा करी रहै: परमेस्वर एक प्रतिग्या दई रहै कि बौ दाऊद के बंस मैं से एक कै सिंहासन मैं बैठारैगो, जैसो कि दाऊद रहै। ");
INSERT INTO thr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","दाऊद देखी कि आनबारे समय मैं परमेस्वर का करन जाएरौ है, और तभई बौ जब मसीहा के पुनरुत्थान के बारे मैं बात करी, तौ बौ कही, ‘बाकै नरक मैं नाय छोड़ो गौ रहै; बाको सरीर कबर मैं नाय सड़त रहै।’ ");
INSERT INTO thr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","जहे ईसु कै परमेस्वर मौत से उठाई है, और हम सबै जौ बात के गभा हैं। ");
INSERT INTO thr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","बौ परमेस्वर, बाके दऊवा के दहने घाँईं उठो भौ है, और बासे पवित्र आत्मा लई है, जैसो बौ वादा करी रहै। अब तुम जो देख और सुनरै हौ, बौ बाको उपहार है जो बौ हमरे ऊपर डारी है। ");
INSERT INTO thr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","काहैकि बौ दाऊद नाय रहै जो स्वर्ग मैं गौ रहै; बल्किन बौ अपने आप बताथै। ‘प्रभु मेरे प्रभु से कही: मेरे दहने बैठ ");
INSERT INTO thr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","जबले कि मैं तेरे दुस्मन कै तेरे टाँग तरे की पुटली नाय कर दियौं।’” ");
INSERT INTO thr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“इस्राएल के सबै लोग, जौ सुनिस्चित करन के ताहीं जानथैं कि जौ ईसु, जोकै तुम क्रूस मैं चढ़ाय रहौ बौ बहे है जोकै परमेस्वर प्रभु और मसीहा बनाई है!” ");
INSERT INTO thr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","जब लोग जौ सुनीं, तौ परेसान भै और बे पतरस और दुसरे प्रेरितन से कहीं, “हम का करंगे भईय्यौ?” ");
INSERT INTO thr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरस उनसे कही, “पछताबौ और तुम सब अपने पापन की माफी के ताहीं ईसु मसीह के नाओं से बपतिस्मा लेयौ, तौ तुम पवित्र आत्मा को दान पाबैगे। ");
INSERT INTO thr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","काहैकि तुम और तुमरे बाले-बच्चन के ताहीं परमेस्वर वादा करी रहै, और बे सब जो भौत दूर हैं, जिनकै हमरो प्रभु और परमेस्वर बुलाथै।” ");
INSERT INTO thr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरस निरी बातन से उनकै गभाई बताए कै समझाई भी “कि खुदकै हठेली जातिन से बचइयो!” ");
INSERT INTO thr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","उनमैं से तमान लोग उनके संदेस कै मन से मानत रहैं और बपतिस्मा लेत रहैं, और बौ दिन समूह मैं लमसम तीन हजार लोगन को जोड़ा गौ रहै। बचन कै अपनाओ बौ बपतिस्मा ");
INSERT INTO thr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","बे प्रेरितन की सिक्छा पान ताहीं, और संगती रखन ताहीं, रोटी तोड़न (प्रभु भोज) और प्रार्थना करन मैं मगन रहैं। ");
INSERT INTO thr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","प्रेरितन के जरिया निरे चिन्ह चमत्कार होत रहैं, और कोई के मन मैं डर बैठगौ रहै। ");
INSERT INTO thr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","सबै विस्वासी करीबी संगती मैं संग-संग चलत रहैं और एक दूसरे के संग अपने सामान कै साझा करीं। ");
INSERT INTO thr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","बे अपनी-अपनी धन-दौलत और समान बेंच-बेचकै जोकै जो चीज की जरूरत होत रहै बाकै बौ चीज दै देत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","और बे हर दिन एक मन हुईकै मंदिर मैं एक समूह के रूप मैं मिले, और बे अपने घरन मैं एक संग खुसी और विनम्र मन से खानु खाईं, ");
INSERT INTO thr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","परमेस्वर की बड़ाँईं करनो, और सबै लोगन ऊपर दया की इच्छा रखनो। और जिनकै बचाओ जात रहै हर दिन प्रभु अपने झुंड मैं मिलाय देत रहै। ");
INSERT INTO thr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","एक दिन पतरस और यूहन्ना दुपारी के बाद तीन बजे प्रार्थना करन कै मंदिर मैं गै। ");
INSERT INTO thr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","और लोग एक जनम के लंगड़ा कै लात रहैं, बाकै बे रोजाना मंदिर के फाटक जो सुगड़ कहो जात रहै, बैठार देत रहैं, कि मंदिर मैं जान बारेन से भीख माँगै। ");
INSERT INTO thr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जब बौ पतरस और यूहन्ना कै मंदिर भीतर जात देखी, तौ बौ उनसे कछु पान ताहीं नहोरे करी। ");
INSERT INTO thr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","बे सीधे बाकै देखीं, और पतरस और यूहन्ना कही, “हमैं देख!” ");
INSERT INTO thr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","तभई बौ उनके घाँईं देखी, बौ कछु पान की आसा करी। ");
INSERT INTO thr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","लेकिन पतरस बासे कही, “मेरे झोने पैसा, सोनो नाय है, लेकिन मैं तोकै बहे देथौं जो मेरे झोने है: नासरत के ईसु मसीह के नाओं मैं, मैं तोकै उठन और नेंगन को आदेस देथौं!” ");
INSERT INTO thr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","फिरौंकी बौ बाको दहनो हात पकड़कै बाकै उठाई। तुरंतै बाके पाँव और घूँटेन मैं ताकत आए गई; ");
INSERT INTO thr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","और बौ तुरंतै कूदकै ठाड़गौ, फिर बौ चलन-फिरन लगो, और कूदत-फाँदत परमेस्वर की स्तुति करत भौ उनके संग मंदिर मैं गौ। ");
INSERT INTO thr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","सब जनी बाकै चलत-फिरत और परमेस्वर की स्तुति करत भौ देखीं, ");
INSERT INTO thr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","और जब बे बाकै बौ भिखारी के रूप मैं पहचानी, जो मंदिर के सुगड़ दुआर मैं बैठो रहै, तौ बे सबै अचम्मो करीं और बाके संग जो भौ बौ देखकै हक्का-बक्का रहगै। ");
INSERT INTO thr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","तौ लंगड़ा भिकमंगा कै पतरस और यूहन्ना के पच्छू-पच्छू नेंगत देखकै, सब आदमी इत्तो अचम्मो करीं कि जोकै सुलैमान की डेहरी कहत रहैं, उनके झोने दौड़त भै आए। ");
INSERT INTO thr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","जब पतरस लोगन कै देखी, तौ बौ उनसे कही, “इस्राएल के लोगौ, तुम जौ बात मैं चकित काहे हौ, और तुम हमैं काहे घूरथौ? का तुमकै जौ लगथै कि जौ हमरी सामर्थ्य या परमेस्वर की भक्ति के जरिये रहै कि हम जौ आदमी कै बनाए? ");
INSERT INTO thr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम, इसहाक और याकूब को परमेस्वर, हमरो पुरखन को परमेस्वर अपने सेवक ईसु की महिमा करी है, जोकै तुम पकड़वान को फैसला करे पर पिलातुस बाकै छोड़न बारो रहे। ");
INSERT INTO thr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","बौ पवित्र और धर्मी रहै, लेकिन तुम बाकै ना अपनाय, और जाके बजाय तुम पिलातुस कै सौंप दै और कहे कि बौ बाकै एक कातिल के रूप मैं बदल दियै। ");
INSERT INTO thr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","तुम जिंदगी के घाँईं लै जान बारे कै मार डारे, लेकिन परमेस्वर बाकै मौत से उठाई और जौ बात के हम गभा हैं। ");
INSERT INTO thr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","जौ बाके नाओं की सक्ति रहै कि लंगड़ा आदमी कै ताकत दई। जो तुम देखथौ और जानथौ बहे के नाओं मैं बिस्वास के जरिया भौ; जो ईसु मैं बिस्वास करन से अच्छो भौ, और जौ तुम सब देख सकथौ।” ");
INSERT INTO thr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“अब मेरे दोस्तौ, मोकै पता है कि तुम और तुमरे मुखिया ईसु के संग जो करीं बौ तुमरी अग्यानता के कारड़ रहै। ");
INSERT INTO thr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","बहोत पहले जे बातन कै परमेस्वर सब भविस्यवक्तन से अग्गुए बताए दई रहे, कि बाको मसीह दुख भोगैगो, तौ ऐसे करकै बौ भविस्यवक्ता पूरी करी। ");
INSERT INTO thr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","जहेमारे, परमेस्वर के झोने लौट आबौ कि बौ तुमरे पाप माफ करै अगर तुम पछताबौ, ");
INSERT INTO thr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","प्रभु की सक्ति बहे के समय से आगी, और बौ ईसु कै पनारैगो, जो तुमरे ताहीं मसीहा ठहराव गौ है जोकै बौ तुमरे ताहीं पहलेई चुनी है। ");
INSERT INTO thr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","जबले सबै चीजन कै नया बनान को ऐलान नाय करी जाबै, तौले स्वर्ग मैं रहने चाहिए, काहैकि परमेस्वर अपने पवित्र भविस्यवक्ता के जरिया ऐलान करी रहै। ");
INSERT INTO thr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","काहैकि मूसा कही ‘तुमरो प्रभु तुमरो परमेस्वर तुमरे ताहीं एक भविस्यवक्ता भेज देगो, जैसी बौ मोकै भेजी रहै, और बौ तुमरेई लोगन मैं से एक होगो। तुम बौ सब कछु मानन बारे हौ जो बौ तुमकै करन कै कहथै। ");
INSERT INTO thr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","जो कोई भी बौ भविस्यवक्ता को पालन नाय करथै, बौ परमेस्वर के लोगन से अलग हुई जाबैगो और अपने आप मैं खतम हुई जागो।’ ");
INSERT INTO thr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","और समूएल से लैकै बाके बाद के सब भविस्यवक्ता जोभी संदेस बोली रहैं, बे सब जेईं दिनन की भविस्यवाँड़ी करीं रहैं कि जे दिनन का ही रौ है। ");
INSERT INTO thr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","अपने भविस्यवक्तन के जरिये परमेस्वर के वादा तुमरे ताहीं हैं, और तुम बौ वाचा मैं भागी बनथौ जोकै परमेस्वर तुमरे परखन के संग बनाई रहै। जैसो कि बे अब्राहम से कहीं, ‘तुमरे बंसज के जरिये मैं धरती मैं सबै लोगन कै आर्सिवाद दुंगो।’ ");
INSERT INTO thr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","और जहे ताहीं परमेस्वर अपने सेवक कै चुनी और तुमरे झोने पनारी, ताकी तुम सबन के ऊपर से बुराई खतम करकै आसीस देबै।” ");
INSERT INTO thr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","जब पतरस और यूहन्ना लोगन से बात करत रहैं, तौ कुछ पुजारी, मंदिर के पहरेदारन के प्रभारी अधिकारी, और कुछ सदूकी पहोंचे। ");
INSERT INTO thr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","बे गुस्सा रहैं काहैकि दुई प्रेरित लोगन कै सिखात रहैं कि ईसु मौत से जी उठ गौ रहै, जोसे जौ साबित हुई गौ कि मरो भौ आदमी जिंदगी मैं आगो। ");
INSERT INTO thr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","तौ बे उनकै पकड़कै दुसरे दिन तक कैदखाना मैं बंद कर दईं, काहैकि पहलेई देर हुई चुकी रहै। ");
INSERT INTO thr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","लेकिन उनको जौ संदेस सुनकै, उनमैं से निरे आदमी बिस्वास करीं; और जिनको आँकड़ा पाँच हजार के लमसम हुई गौ। ");
INSERT INTO thr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","दुसरे दिन यहूदि मुखिया, बड़े-बूढ़े और यहूदि नियम के सिक्छा देनबारे यरूसलेम मैं जुराने। ");
INSERT INTO thr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","बे बड़े पुजारी हन्ना और कैफा, यूहन्ना, सिकन्दर के संग, और जितने बड़े पुजारी के परिवार के रहैं उनसे मिले। ");
INSERT INTO thr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","बे प्रेरितन कै सबके सामने ठड़बाए कै और उनसे पूँछीं, “तुम जौ काम कौनकी सामर्थ्य और कौनके नाओं से करथौ?” ");
INSERT INTO thr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तौ पतरस पवित्र आत्मा से भरकै उनकै जबाब दई, “लोगौ और बड़े-बूढ़े के मुखिया: ");
INSERT INTO thr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","आदमिन के मुखियौ और बड़े-बूढ़े जौ लंगड़ा आदमी के संग तौ अच्छो करो गौ है, लेकिन आज हमसे जाके बारे मैं सवाल करथौ कि बौ कैसे अच्छो भौ है, ");
INSERT INTO thr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तौ तुम सब और पूरे इस्राएली आदमी जान लियो कि मसीह ईसु नासरी के नाओं से जोकै तुम सब क्रूस के ऊपर टाँगे, और परमेस्वर बाकै मरो भौ मैं से जिंदो कर दई, जौ बहे आदमी है तुमरे अग्गु अच्छो-भलो ठाड़ो है। ");
INSERT INTO thr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ईसु ही बौ है जोके बारे मैं धर्मग्रंथ करथै, जौ बहे पथरा है जोकै राजमिस्त्री बेकार समझी, ‘बौ सबन के ताहीं कोहने को खास पथरा बन गौ।’ ");
INSERT INTO thr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","उद्धार कोई दुसरे के जरिया नाय है; काहैकि स्वर्ग के तरे आदमिन मैं और कोई दुसरो नाओं ही नाय दौ गौ है, जोके जरिया हम मुक्ति पाये सकथैं।” ");
INSERT INTO thr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जब पंचायत के आदमी देखीं तौ बे अचम्मे मैं पड़ गै, पतरस और यूहन्ना की हिम्मत देखकै जानगै कि जे अनपढ़ और साधारँड़ से आदमी हैं बे बड़ा ताजुब करीं; फिर उनकै पता चल गौ, कि जे ईसु के संग रहत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","लेकिन ऐसो कछु नाय रहै जो बे कह सकत रहैं, काहैकि बे बौ अच्छो आदमी कै देखी रहैं जो पतरस और यूहन्ना के संग हुँआँ ठाड़ो रहै। ");
INSERT INTO thr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","जहे बजे से बे उन्हैं पंचायत घर कै छोड़न के ताहीं कहीं, और फिर बे आपस मैं चर्चा करन लगे। ");
INSERT INTO thr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“हम जे आदमिन के संग का करंगे?” बे पूँछीं। “यरूसलेम मैं हर कोई जानथै कि जौ असाधारड़ चिन्ह चमत्कार उनके जरिये करो गौ है और, हम बाकै नकार भी नाय सकथैं। ");
INSERT INTO thr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","लेकिन जौ बात आदमिन के बीच फैलन से रोकन के ताहीं, आबौ हम जे लोगन कै चितौनी देमैं कि ईसु के नाओं से कहु कोई से बात ना करै।” ");
INSERT INTO thr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तौ पतरस और यूहन्ना कै बुलाएकै और चितौनी देत भै जौ कहीं, ईसु के नाओं से ना कछु बोलियो और ना कछु सिखईयो। ");
INSERT INTO thr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","लेकिन पतरस और यूहन्ना उनकै जबाब दईं, “तुम्हईं न्याय करौ, ठीक काहैकि परमेस्वर की बात नाय मानकै तुमरी बात मान लेमैं। ");
INSERT INTO thr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ऐसो तौ हम नाय कर पांगे, कि जो हम देखे और सुने, बौ ना सिखामैं।” ");
INSERT INTO thr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तौ बे उनकै और कड़ी चितौनी दैकै छोड़ दईं, बे देखीं कि उनकै सजा देनो नामुमकिन रहै, काहैकि जो कछु हुँआँ रहै, बाके ताहीं सब जनी परमेस्वर की बड़ाँईं करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","जो आदमी के ऊपर अच्छो करन को चिन्ह चमत्कार दिखाओ गौ रहै, बौ चालीस साल की उमर से भी जाधे को रहै। ");
INSERT INTO thr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","पतरस और यूहन्ना छुटकै अपने साथियन के झोने आए, और जो कछु मुखिया पुजारिन और बड़े-बूढ़े कही रहैं, उनकै सुनाए दईं। ");
INSERT INTO thr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","जौ सुनकै बे सब विस्वासी परमेस्वर से प्रार्थना करन लगे: “हे स्वर्ग, धरती, और समुंदर के मालिक और सब कछु बनान बारे, जौ सब बामै है! ");
INSERT INTO thr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तैं पवित्र आत्मा के जरिया अपने सेवक हमरे पुरखा दाऊद के मोहों से बोलो, जब बौ कही, ‘गैर यहूदि हुलगदड़ काहे मचाथैं; और देस-देस के आदमी काहे बेकार की बात सोचथैं? ");
INSERT INTO thr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","पृथ्वी के राजा अपने आपकै तैयार करीं, और सासक आपस मैं मिल गै प्रभु और उनके मसीह के खिलाप।’ ");
INSERT INTO thr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","काहैकि सच्ची मैं तेरे पवित्र सेवक ईसु के खिलाप मैं, जोकै तू अभिसेक करो, हेरोद और पुन्तियुस, पिलातुस, गैर यहूदि और इस्राएलियौ के संग जहे सहर मैं जुराए गै। ");
INSERT INTO thr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ताकी जो कछु अग्गुए से ठहराओ रहै, तेरी ताकत और इच्छा से बैसो ही होबै। ");
INSERT INTO thr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","और अब प्रभु, उनकी धमकियन मैं ख्याल कर और अपने सेवकन कै बिना डराय तेरो बचन पूरी हिम्मत से सुनाए सकैं। ");
INSERT INTO thr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","अच्छो करन के ताहीं तैं अपनो हात हमरे अग्गु कर, ताकी चिन्ह चमत्कार और अनोखे काम तेरे पवित्र सेवक ईसु के नाओं से करे जामैं।” ");
INSERT INTO thr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जब बे पूरी प्रार्थना कर डारीं, जो जघा मैं सब जुराए रहैं, तौ सबके भीतर पवित्र आत्मा समाए गई, और बे बिना डरे परमेस्वर को बचन सुनात रहैं। ");
INSERT INTO thr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","बिस्वास करन बारेन को एक बड़ो झुंड रहै, जोकी एक मनसा और एक मन के रहैं। कोइयो जौ नाय कहत रहै की बाकी चीज खुद की हैं। उनके झोने जो कछु रहे, बौ चीज कै आपस मैं साझा लेत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","बड़ी सामर्थ्य के संग प्रेरित प्रभु ईसु के मौत से जी उठन की गभाई दईं, और परमेस्वर उन सबन के ऊपर भरपूर अनुग्रह डारी। ");
INSERT INTO thr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","समूह मैं ऐसो कोईये नाय रहै जो जरूरतमंद होबै। जो लोग खेतन कै या घरन के मालिक रहैं, बे उनकै बेंच देते और बासे जो भी पैसा मिलत रहै बाकै बे लायकै, ");
INSERT INTO thr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","प्रेरितन कै सौंप देत रहैं; और लोगन की जरूरतन के हिसाब से पैसा बाँट दौ जात रहै। ");
INSERT INTO thr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","यूसुफ नाओं को एक लेवी जो साइप्रस मैं पैदा भौ रहै, लेकिन प्रेरित बाको नाओं बरनबास जोको मतलब है “हौंसला देन बारो,” ");
INSERT INTO thr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","बौ अपने खेत कै बेंच दई और पैसा लायकै, प्रेरितन कै सौंप दई। ");
INSERT INTO thr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नाओं को एक आदमी रहै, और बाकी बईय्यर को नाओं सफीरा रहै, तौ बे जमीन को एक हिस्सा बेचीं। ");
INSERT INTO thr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","बौ अपनी बईय्यर के संग मिलकै बामै से कुछ पैसा धर लई और बचे भै पैसा प्रेरितन कै दै दई। ");
INSERT INTO thr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","तौ पतरस कही, “हनन्याह, तू सैतान कै अपने मन मैं काहे घुसन दौ कि तू पवित्र आत्मा के अग्गु झूठ बोलो और जमीन बेचकै मिले भै पैसन मैं से धर लौ? ");
INSERT INTO thr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","जब तक सम्पत्ति तेरे झोने रहै, का बाको अधिकार तेरो नाय रहै? और जब तू बेंचो बौ पैसा का तेरे अधिकार मैं नाय रहै? तैं जौ बात अपने मन मैं काहे सोचो? तैं आदमिन से नाय, बल्किन परमेस्वर से झूठ बोलो है!” ");
INSERT INTO thr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","जौ बात सुनकै हनन्याह जमीन मैं मोखरा गिर गौ और तुरंतै बाकी ज्यान निकर गई। तौ सब सुनन बारेन कै बड़ा डर छाए गौ। ");
INSERT INTO thr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","तौ ज्वान आदमी उठकै बाकी अर्थी बनाईं और दुआरे लै जाएकै दफनाए दईं। ");
INSERT INTO thr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","लमसम तीन घंटा बाद, जो कुछ हूँना भौ रहै, बाकी बईय्यर कै कछुए पता नाय रहै और बौ सीधे भीतर आई। ");
INSERT INTO thr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","तौ पतरस बासे कही, “मोकै बता का तुम बौ जमीन कै इत्ते मैं बेंचे रहौ?” बौ कही, “हाँ, इत्तेई मैं।” ");
INSERT INTO thr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","तौ पतरस बासे कही, “तुम दोनों प्रभु की आत्मा की इम्तिहान लेन के ताहीं कैसे राजी ही गै? देख तेरे लोगा कै दफनान बारेन के पाँव फाटक तक आए चुके हैं और बे तहूँ कै उठाएकै लै जामंगे!” ");
INSERT INTO thr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","और बौ तुरंतै उनके पाँव मैं गिर पड़ी और बौ खतम हुई गई, तौ ज्वान आदमी भीतर आए कै बाकै मरी भइ पाईं, और दुआरे लै जाएकै बहे के लोगा झोने बाकै दफनाए दईं। ");
INSERT INTO thr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","तौ पूरी कलीसिया मैं जे बात सब सुनन बारेन के ऊपर बड़ा डर छाए गौ। ");
INSERT INTO thr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","प्रेरितन के हात से निरे चिन्ह और अनोखे काम आदमिन के बीच मैं दिखाए जात रहैं, और बे सब एक मन हुईकै सुलैमान की डेहरी मैं जुरात रहैं। ");
INSERT INTO thr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","लेकिन औरन मैं से कोई की हिम्मत नाय होत रहै कि, उनमैं मिल जामैं; तहुँओं आदमी उनकी बड़ा बात करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","लेकिन बिस्वास करन बारे निरे आदमी और बईंय्यरैं प्रभु की कलीसिया मैं बड़तै जात रहैं। ");
INSERT INTO thr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","प्रेरितन के कामन के हिसाब से आदमी बिमारन कै सड़कन मैं लाए लायकै, खटिया और मुंदरा मैं लिटाए देत रहैं, कि जब पतरस आबै, तौ बाकी छाँईं उनके ऊपर पड़ जाबै। ");
INSERT INTO thr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","और यरूसलेम के आस-पास के सहरन मैं से आदमिन की बड़ी भीड़, जो बिमार और प्रेत आत्मा के सताए भैन कै लात रहैं; और सबन कै अच्छो कर दौ जात रहै। ");
INSERT INTO thr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","तौ बड़ो पुजारी और बाके सब संग के जो सदूकी स्थानीय दल के सदस्य रहैं, बे जलन से भरकै प्रेरितन के बिरोध मैं सलाह करीं और फैसला लईं। ");
INSERT INTO thr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","और प्रेरितन कै पकड़कै उन्हैं सार्वजनिक कैदखाना मैं डार दईं। ");
INSERT INTO thr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","लेकिन रात कै प्रभु को एक स्वर्गदूत कैदखाना के फाटक खोलकै, प्रेरितन कै दुआरे निकारी, और उनसे कही, ");
INSERT INTO thr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जाबौ मंदिर मैं ठाड़े रहाबौ, और लोगन कै जौ नई जिंदगी की बातन कै बताबौ।” ");
INSERT INTO thr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","प्रेरित आग्या को पालन करीं, और भोर होतै खिना मंदिर मैं जाएकै सिक्छा देन लागे। तौ बड़ो पुजारी और बाके सब संग बारे आयकै बड़ी पंचायत मैं इस्राएलियन के सब बड़े-बूढ़ेन कै एक संग बुलाई; तौ बे प्रेरितन कै कैदखाना से लान को आदेस दईं। ");
INSERT INTO thr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","लेकिन जब अधिकारी पहुँचे तौ प्रेरितन कै कैदखाना मैं नाय पाईं, और लौटकै पंचायत मैं खबर दईं, ");
INSERT INTO thr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“हम कैदखाना के चौकीदारन के और फाटक कै सई-सलामत बंद पाए; लेकिन जब खोले, तौ भीतर कोईये नाय मिलो!” ");
INSERT INTO thr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जब मंदिर के मुखिया पुजारी और चौकीदार के अधिकारी जे बात सुनीं, तौ बड़ा सोच मैं पड़ गै कि प्रेरितन को का भौ। ");
INSERT INTO thr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","तभईये एक आदमी आओ और उनसे कही, “सुनौ! जिनकै तुम कैदखाना मैं डारे रहौ, बे लोगन कै मंदिर मैं उपदेस दे रै हैं!” ");
INSERT INTO thr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","तभईये अधिकारी, सिपईय्यन के संग जाएकै, प्रेरितन कै लै आईं लेकिन जबरजत्ती से नाय, काहैकि बे आदमिन से डरात रहैं कि उनके ऊपर पथराव नाय कर देमैं। ");
INSERT INTO thr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","बे प्रेरितन कै लायकै बड़ी पंचायत के अग्गु ठड़बाए दईं; और बड़ो पुजारी उनसे पूँछताछ करी। ");
INSERT INTO thr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","बे कहीं, “का हम तुमकै कड़ो आदेस ना दै रहैं कि तुम जौ आदमी के नाओं से उपदेस मत दियो; लेकिन देखौ तुम का करे हौ! तुम पूरे यरूसलेम मैं अपने उपदेसन कै फैलाय दै हौ, और तुम बाके खून को इल्जाम हमरे ऊपर लगानो चाहथौ!” ");
INSERT INTO thr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","पतरस और दुसरे प्रेरित उनकै जबाब दईं, “हमैं परमेस्वर कै माननो चाहिए, ना कि आदमिन कै। ");
INSERT INTO thr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","हमरे परखन को परमेस्वर ईसु कै जिंदो करी, जोकै तुम क्रूस मैं टँगाए कै मार डारे रहौ। ");
INSERT INTO thr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","परमेस्वर बाकै अपने दहने हाथ को नेता और उद्धारकर्ता के रूप मैं उठाई, ताकी इस्राएलियन कै पछतान को मौका दौ जाए सकै और पापन कै माफ कर देबै। ");
INSERT INTO thr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","हम जे बातन के गभा हैं, और बैसिये पवित्र आत्मा भी जोकै उपहार के रूप मैं परमेस्वर उनकै दई है जो बाकी आग्या मानथैं।” ");
INSERT INTO thr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","जब पंचायत के सदस्य जौ सुनीं, तौ बे इतने गुस्सा मैं रहैं कि बे चहात रहैं कि प्रेरितन कै मौत के घाट उतार दौ जाबै। ");
INSERT INTO thr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","लेकिन गमलीएल नाओं को एक फरीसी जो नियम के सिक्छकन और सब आदमिन मैं बड़ा पहोंचो भौ रहै, पंचायत मैं ठाड़कै प्रेरितन कै जरा देर दुआरे जान ताहीं कही। ");
INSERT INTO thr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तौ बौ पंचायत से कही “हे इस्राएलियौ, जो कछु तुम जे आदमिन के संग करनो चाहथौं, सोच समझकै करियो। ");
INSERT INTO thr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","तुमकै याद है कुछ समय पहले थियूदासौ कहत भौ उठो, कि महुँ कछु हौं; और बाके संग कम से कम चार सौ आदमी ही गै, लेकिन बौ मारो गौ, और जित्ते आदमी बाकै मानत रहैं तितर-बितर ही गै और बाको आन्दोलन खतम हुई गौ। ");
INSERT INTO thr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","बाके बाद गलीलियन जनगड़ना के समय मैं यहूदा दिखाई दई, बौ बाके बाद एक भीड़ कै अपने घाँईं कर लई; लेकिन बहो खतम हुई गौ, और जित्ते आदमी बाकै मानत रहैं बे सब तितर-बितर ही गै। ");
INSERT INTO thr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","और जहे ताहीं जौ मामले मैं, मैं तुमसे कहथौं, इनसे कोई मतलब भी मत रखियो; और इनकै अकेलो छोड़ देयौं! अगर जौ योजना आदमिन घाँईं से होगी तौ अपने आपै खतम हुई जागी, ");
INSERT INTO thr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","लेकिन अगर परमेस्वर के घाँईं से है तौ तुम उनकै कहुए नाय रोक पाबैगे। कहूँ ऐसो नाय होबै कि तुम अपने आपकै परमेस्वर के खिलाप लड़त भइ पाबौ!” तौ पंचायत गमलीएल की सलाह मान लईं। ");
INSERT INTO thr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","फिर बे प्रेरितन कै भीतर बुलबाईं, और कोड़ा लगवाईं, और आदेस दईं, कि बे फिर ईसु के नाओं से फिर कहुए बात ना करैं; और फिर बे उन्हैं आजाद कर दईं। ");
INSERT INTO thr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","प्रेरित जौ बात से खुस हुईकै पंचायत के अग्गु से निकर गै, कि हम ईसु के नाओं के ताहीं बेईज्जत होन के लायक तौ बने। ");
INSERT INTO thr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","जाके बाद हर रोज मंदिर मैं और लोगन के घरन मैं जाए-जाएकै ईसु मसीह के बारे मैं सुसमाचार सुनाते और प्रचार करनो जारी रखत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","कुछ समय बाद, जैसे-जैसे सेवकाई मैं चेलन की गिनती बढ़त रहै, यूनानी भासा बोलन बारे यहूदिन के बीच और इब्रानी यहूदियन के बीच लड़ाई होन लगी। यूनानी भासा बोलन बारे यहूदि दाबा करीं, कि खान-पीन मैं उनकी बिधवन की खैर-खबर नाय लई जाए रइ है। ");
INSERT INTO thr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तौ बे बारह चेलन के विस्वासी समूह कै एक संग बुलाई और कही, “जौ तौ अच्छो नाय है कि आपन परमेस्वर के बचन को प्रचार छोड़ खबान-पिबान की सेवा मैं रहमैं। ");
INSERT INTO thr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","जहे बजह से भईय्यौ, आपन मैं से सात भले आदमिन कै जो पवित्र आत्मा और बुद्धि से भरे होमैं, छाँट लेबौ, कि हम उनकै जौ काम मैं लगाए देमैं। ");
INSERT INTO thr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","तौ हम खुद, अपनो पूरो समय प्रार्थना और प्रचार के काम मैं देंगे।” ");
INSERT INTO thr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","जौ राय पूरे समूह कै अच्छी लागी, तौ बे स्तिफनुस नाओं के एक आदमी कै जो बिस्वास और पवित्र आत्मा से भरो रहै, और फिलिप्पुस, प्रुखुरुस, नीकानोर, तीमोन, परमिनास और अन्ताकिया मैं रहेन बारे नीकुलाउस जो यहूदि धर्म मैं बदल गै रहैं, चुन लई। ");
INSERT INTO thr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","समूह उन्हैं प्रेरितन के अग्गु ठड़बाईं और प्रार्थना करकै उनके ऊपर हात धरी। ");
INSERT INTO thr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","और परमेस्वर को बचन फैलत गौ। और यरूसलेम मैं चेलन की गिनती बड़ा बढ़त गई, और पुजारी को एक बड़ो समाज जौ बिस्वास कै मानन बारो ही गौ। ");
INSERT INTO thr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस, एक आदमी जो परमेस्वर के अनुग्रह पाओ भौ रहै और सामर्थ्य से भरपूर भरो रहै, बौ लोगन के बीच बड़े-बड़े अचम्मे काम और चिन्ह दिखात रहै। ");
INSERT INTO thr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","लेकिन बौ कुछ आदमिन के जरिये बिरोध करो गौ रहै जो आजाद करन बारेन के सभाघरन के सदस्य रहैं, जैसो कि जाकै कहो जाथै, जोमैं कुरेनी और सिकन्दरिया के यहूदि सामिल रहैं। बे और दूसरे आदमी किलिकिया और आसिया के देसन से स्तिफनुस के संग बहस कर लागे। ");
INSERT INTO thr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","लेकिन आत्मा स्तिफनुस कै ऐसो ग्यान दई कि जब बौ बोलो, तौ बे बाके अग्गु टिक ना पाईं। ");
INSERT INTO thr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","तौ बे कई लोगन कै घूस दईं जो कहेन लगे, “हम जाकै मूसा और परमेस्वर के खिलाप बुरो-भलो कहत सुने हैं।” ");
INSERT INTO thr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ऐसे करकै बे आदमिन कै, बड़े-बूढ़ेन और यहूदि नियम के सिक्छकन कै हलाए दईं। बे स्तिफनुस कै पकड़कै पंचायत मैं लै आए। ");
INSERT INTO thr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","फिर बे कुछ आदमिन कै बाके बारे मैं झूठ गभन के ताहीं लै आए। बे कहीं, “जौ आदमी, हमेसा हमरे पवित्र मंदिर और मूसा के नियम के खिलाप बोलथै। ");
INSERT INTO thr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","हम बासे जौ कहत सुने हैं कि जहे ईसु नासरी जौ मंदिर कै उजाड़ देगो, और बे रीतियन कै बदल देगो जोकी मूसा हमकै दई है!” ");
INSERT INTO thr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तौ सब आदमी जो पंचायत मैं बैठे रहैं, स्तिफनुस कै निहारकै देखीं कि बाको मोहों एक स्वर्गदूत के मोहों के हानी दिखात रहै। ");
INSERT INTO thr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","बड़ो पुजारी स्तिफनुस से पूँछी, “का जौ सच्ची है?” ");
INSERT INTO thr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्तिफनुस जबाब दई, “भईय्यौ और बड़े-बूढ़े सुनौ! हमरो पुरखा अब्राहम हारान सहर मैं बसन से अग्गु जब मेसोपोटामिया मैं रहै; तौ महिमा मैं परमेस्वर बाकै दर्सन दई ");
INSERT INTO thr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","और बासे कही, ‘अपने देस और अपने परिवार कै छोड़कै तू बौ जघा मैं चले जा, जो तोकै मैं दिखांगो।’ ");
INSERT INTO thr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","और जहे बजह से बौ कसदियों के देस कै छोड़कै हारान मैं रहन चले गौ। अब्राहम के दऊवा के खतम होन के बाद, परमेस्वर बाकै हूँना से जौ जघा मैं लाई जहाँ अब तुम रहथौ। ");
INSERT INTO thr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","परमेस्वर अब्राहम कै कोई हिस्सा नाय दई, हिंयाँ तक कि बाके पास जमीन को एक मीटर तक नाय रहै, लेकिन परमेस्वर बाकै देन को वादा करी रहै, और जौ कि बौ बाके और बाके बंसज को होगो। जो समय परमेस्वर जौ बचन दई, बौ समय अब्राहम की कोई औलाद नाय रहै। ");
INSERT INTO thr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","परमेस्वर बासे ऐसो वादा करी: ‘तेरी औलाद दुसरे देस मैं परदेसी होमंगे, और बे गुलाम बनंगे, और 400 साल तक बे दुख उठामंगे। ");
INSERT INTO thr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","तौ मैं परमेस्वर कमईंयन के मालिकन के ऊपर फैसला लेंगो और तुमरे बंसज बौ देस से निकरकै जहे जघा मैं मेरी महिमा करंगे।’ ");
INSERT INTO thr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","तौ परमेस्वर अब्राहम से खतना की वाचा भाँदी। जहे बजह से अब्राहम इसहाक के पैदा होन के एक सप्ताह के बाद बाको खतना करी; इसहाक अपने लौड़ा याकूब को खतना करी, और याकूब अपने बारह लौड़न को खतना करी, हमरी जाति के प्रसिद्ध परखन को खतना भौ।” ");
INSERT INTO thr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“याकूब के लौड़ा अपने भईय्या यूसुफ से जलन लगे और बाकै मिस्र देस मैं गुलाम बनन के ताहीं बेंच दई। लेकिन परमेस्वर बाके संग रहै” ");
INSERT INTO thr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","और परमेस्वर यूसुफ की सब परेसानी से छुड़ाय कै मिस्र के राजा फिरौन के सामने आओ, तौ परमेस्वर बाकै खुस करन के तरीका अनुग्रह और ग्यान दई, और राजा बाकै मिस्र को और अपने पूरे घराने को राज्यधिकारी बनाई। ");
INSERT INTO thr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","तौ मिस्र और कनान मैं आकाल पड़ो; और बड़ो संकट आओ, और हमरे बड़े-बूढ़ेन कै अन्न नाय मिलन लगो। ");
INSERT INTO thr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","जब याकूब जौ सुनी, कि मिस्र मैं अन्न हैं, तौ बौ अपने लौड़न कै, और हमरे परखन कै पहली बार हूँना पनारी। ");
INSERT INTO thr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","दुसरी बार यूसुफ अपने आपकै अपने ददा-भईय्यन के सामने लै आई, तौ यूसुफ के परिवार के बारे मैं फिरौन राजा कै पता चलो। ");
INSERT INTO thr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","जहे बजह से यूसुफ अपने आप से अपने दऊवा याकूब और अपने पूरे परिवार कै, जो 75 जनी रहैं, मिस्र मैं आन की खबर पनारी। ");
INSERT INTO thr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","तौ याकूब मिस्र गौ, और हूँना पर बौ और बाके लौड़ा हूँनै खतम ही गै। ");
INSERT INTO thr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","उनकी लास सेकेम मैं लै जाएकै, कबर मैं दफनाओ गौ रहै जोकै अब्राहम पैसा दैकै हामोर जाति से खरीदी रहै। ");
INSERT INTO thr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","जब परमेस्वर को वादा अब्राहम से पूरो करन को समय आओ तौ मिस्र मैं हमरे लोगन की गिनती निरी बढ़ गई रहे। ");
INSERT INTO thr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","आखरी मैं एक राजा जो यूसुफ कै नाय जानत रहै, मिस्र मैं राज करन लगो। ");
INSERT INTO thr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","बौ हमरे लोगन के संग विस्वासघात करी और हमरे पुरखन कै उनके नवजात बालकन कै बाहर फेंकन के ताहीं बेबस करी ताकी बे मर जामैं। ");
INSERT INTO thr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","बहे समय मूसा को जनम भौ; और बौ परमेस्वर की नजर मैं भौत सुगड़ रहै। और बौ तीन महेना ले अपने घर मैं पालो पोसो गौ, ");
INSERT INTO thr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","और जब बाकै अपने घर से बाहर कर दौ गौ, तौ फिरौन राजा की लौड़िया बाकै उठाए लाई और अपनो लौड़ा करकै पाली। ");
INSERT INTO thr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","और मूसा कै मिस्रियन की सब सिक्छा दई गईं, और बौ सब्दन मैं और कामन मैं एक महान आदमी बन गौ। ");
INSERT INTO thr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“जब मूसा चालीस साल को भौ, तौ बाके मन मैं जौ बात पता लगान को फैसला करी कि बाके संग के इस्राएलियन के संग कैसो बर्ताव कर रै हैं। ");
INSERT INTO thr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","बौ देखी कि उनमैं से एक मिस्र के लोगन के संग अन्याय कर रौ है, जहे बजह से बौ बाकी मदत के ताहीं गौ और मिस्रियन कै मारकै बाको बदला लई। ");
INSERT INTO thr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","मूसा सोची की बाके अपने लोग जौ समझंगे कि परमेस्वर बाके हातन से उनको उद्धार करैगो लेकिन बे नाय समझ पाईं। ");
INSERT INTO thr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","दुसरे दिन मूसा दुई इस्राएली आदमिन कै लड़त भइ देखी, बौ उनके बीच सांति बनान की कोसिस करी। और बौ कही, ‘सुनौ, तुम एक संग के इस्राएली हौ; तुम एक दुसरे ऊपर काहे अन्याय करथौ?’ ");
INSERT INTO thr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","लेकिन जो दूसरे के संग अन्याय करत रहै, बौ मूसा कै एक घाँईं धकियाए दई। बौ पूँछी, ‘कौन तोकै सासक बनाओ और हमरो फैसला करन कै कही?’ ");
INSERT INTO thr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘तू जैसे कल मिस्री कै मारो रहै, का महुँ कै मार डारनो चाहथै?’ ");
INSERT INTO thr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","जब मूसा जौ सुनी, तौ बौ मिस्र से भाज गौ और मिद्दान देस मैं रहेन चले गौ। और हूँना बाके दुई लौड़ा पैदा भै।” ");
INSERT INTO thr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“जब पूरे चालीस साल गुजर गै, तौ एक स्वर्गदूत सीनै पहाड़ के झोने रेगिस्तान मैं बाकै जलत भइ झाड़ी की लपट मैं दिखाई दई। ");
INSERT INTO thr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मूसा जौ देखकै अचम्मो भौ, और देखन ताहीं जब बौ झाड़ी के झोने गौ, तौ प्रभु की अबाज सुनाई दई: ");
INSERT INTO thr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘मैं तेरे पुरखा अब्राहम, इसहाक और याकूब को परमेस्वर हौं।’ तौ मूसा कपकपाए गौ, हींना तक की बाकै देखन की हिम्मत नाय रही। ");
INSERT INTO thr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","प्रभु बासे कही, ‘अपनी चप्पल खोल दे, जो जघा मैं तू ठाड़ो है, बौ पवित्र जघा है। ");
INSERT INTO thr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मैं मिस्र मैं अपने आदमिन की हालत कै देखो हौं; और उनको कराहनो सुनो हौं, और उनकै छुड़ान के ताहीं उतरो हौं। अब आबौ; मैं तुमकै मिस्र पनारंगो।’” ");
INSERT INTO thr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“मूसा बहे है जोकै इस्राएल के लोग जौ कहकै नकारी रहैं, बे पूँछीं, ‘कौन तोकै सासक बनाओ और हमरो फैसला करन कै कही?’ मूसा बौ है जोकै परमेस्वर लोगन के ऊपर सासन करन के ताहीं पनारी है और उनकै स्वर्गदूत की मदत से आजाद करी जो जलत भइ झाड़ी मैं दिखाई दई रहै। ");
INSERT INTO thr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","जहे मूसा मिस्र देस के लोगन कै मिस्र और लाल समुंदर मैं और रेगिस्तान मैं चालीस साल तक चमत्कार और चिन्ह दिखाए-दिखाए कै उनकै निकार लाई। ");
INSERT INTO thr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","मूसा बहे है, जो इस्राएल के लोगन से कही रहै, ‘परमेस्वर तुमरे ताहीं एक भविस्यवक्ता भेजैगो, जैसे बौ मोकै भेजी, और बौ तुमरेई लोगन मैं से एक होगो।’ ");
INSERT INTO thr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","जौ बहे है, जोकै जो रेगिस्तान मैं जुराने इस्राएल के लोगन के संग रहै; बहे स्वर्गदूत के संग सीनै पहाड़ मैं बासे बात करी रहै, और आपन के परखन के संग रहै, और बौ हमरे झोने जान के तहीं परमेस्वर के जिंदे संदेस लई।” ");
INSERT INTO thr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“लेकिन हमरे पुरखा बाकी बात मानन से मना कर दईं; बे बाकै एक घाँईं धकयाईं और चाँहीं कि बे मिस्र बापस जाए सकथैं। ");
INSERT INTO thr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","तौ बे हारून से कहीं, ‘हमरे ताहीं ऐसो दुईता बनाए दे जो हमरे अग्गु-अग्गु नेंगै, काहैकि जहे मूसा जो हमकै मिस्र देस से निकारकै लाई, हमकै नाय मालुम है कि बाको का भौ।’ ");
INSERT INTO thr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","बे दिनन मैं बे एक बछड़ा की मूर्ति बनाएकै बाके अग्गु बलि चढ़ाईं, बाके आदर मैं खानु खाईं। ");
INSERT INTO thr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","तौ परमेस्वर उनसे दूर हुई गौ, और स्वर्ग के तारामंडल कै पूजत रहामैं, जैसो कि भविस्यवक्ता की किताब मैं लिखो है: ‘इस्राएल के लोगौ! जौ मेरे ताहीं ना रहै कि तुम रेगिस्तान मैं चालीस साल तक जानवरन को मारे और बलि करत रहे। ");
INSERT INTO thr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","जौ बौ दुईता मोलेक को तम्बु रहै जोकै तुम ढ़ोए रहौ, और रिफान की छवी, तुमरो तारा दुईता; बे मूर्ति रहैं जिनकै तुम पूजा करन के ताहीं बनाए रहौ। और तभईये मैं तुमकै बेबीलोन से भी दूर भजाए दुंगो।’” ");
INSERT INTO thr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“परमेस्वर को तम्बु रेगिस्तान मैं हमरे पुरखन के बीच मैं साक्छी रहै। और बौ ऐसो बनो रहे जैसो परमेस्वर मूसा से चहात रहे, जैसो ढाँचो मूसा देखी रहे। ");
INSERT INTO thr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","बाद मैं, हमरे पुरखा अपने बाप-दादोन से तम्बु पाईं, जब बे यहोसू के संग गै और देसन से जमीन मैं कब्जा कर लईं जोकै परमेस्वर अग्गु बढ़ाई। और दाऊद के समय तक बौ हूँनै रहो। ");
INSERT INTO thr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","और परमेस्वर बाके ऊपर दया करी; फिर परमेस्वर बाकै इजाजत दई, कि बौ याकूब के परमेस्वर के तम्बु ताहीं बसन की जघा बनाबै। ");
INSERT INTO thr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","लेकिन जौ सुलैमान रहै जो बाके ताहीं एक घर बनाई।” ");
INSERT INTO thr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“लेकिन परमप्रधान दऊवा परमेस्वर इंसान के हात को बनो भौ घर मैं नाय बास करथै; जैसो कि भविस्यवक्ता कहथै: ");
INSERT INTO thr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘प्रभु कहथै, स्वर्ग मेरो सिंहासन है, और पृथ्वी मेरे पाँवों तरे की चौकी है। तुम मेरे ताहीं कैसो घर बनाबैगे? और मेरे ताहीं रहन की जघा कहाँ है? ");
INSERT INTO thr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","का जे सब चीज मेरे हात की बनाई भइ नाय हैं?’” ");
INSERT INTO thr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“तुम कित्ते जिद्दी हौ!” कहनै मैं स्तिफनुस चले गौ। “तुम अपने मन कै कित्तो पवित्र करथौ, तुम परमेस्वर के संदेस मैं कित्ते ध्यान देनबारे हौ! तुम अपने पुरखन के हानी हौ: तुम हमेसा पवित्र आत्मा को बिरोध करे हौ! ");
INSERT INTO thr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","भविस्यवक्ता मैं से कौनकै तुमरे पुरखा नाय सताईं रहैं? बे परमेस्वर के दूतन कै मारडारीं, जो भौत पहले अपने धर्मी सेवक के आन के बारे मैं घोसड़ाँ करी रहैं। और अब तैं बाकै धोका दैकै मार डारो है। ");
INSERT INTO thr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुम बहे हौ जो परमेस्वर के नियम पाईं जो स्वर्गदूतन के जरिया दौ गौ रहै, फिर भी तुम जाको पालन ना करे!” ");
INSERT INTO thr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","जब पंचायत के सदस्य स्तिफनुस की बात सुनीं तौ बे गुस्साय गै और बाके ऊपर दाँत मीसन लागे। ");
INSERT INTO thr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","लेकिन स्तिफनुस पवित्र आत्मा से भरकै स्वर्ग के घाँईं देखी और परमेस्वर की महिमा और ईसु कै परमेस्वर के दहने घाँईं ठाड़ो देखकै ");
INSERT INTO thr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","कही, “देखौ! मैं स्वर्ग कै खुलो भौ और आदमी के लौड़ा कै परमेस्वर के दहने घाँईं ठाड़ो भौ देखथौं!” ");
INSERT INTO thr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","जोर से रोन के संग पंचायत के सदस्य अपने कानन कै हातन से मूंद लईं और जुराए कै बाके ऊपर चढ़ बैठे, ");
INSERT INTO thr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","और बाकै सहर के बहार निकारकै पथराव करन लागे। और जो गभा रहैं अपने लत्ता उतारकै साऊल नाओं को एक ज्वान कै देखाभारी के ताहीं छोड़ दईं। ");
INSERT INTO thr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","बे स्तिफनुस के ऊपर पथरा मारतै रहै, और बौ प्रभु कै पुकारकै कही, “प्रभु ईसु, मेरी आत्मा कै लै ले!” ");
INSERT INTO thr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","फिरौंकी घुपटियाय कै ऊँची अबाज मैं चिल्लाई, “प्रभु! जौ पाप इनके ऊपर मत लगईये!” और जौ कहतै मर गौ। ");
INSERT INTO thr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","और साऊल बाकै मारन की सहमति दई। बहे दिन से यरूसलेम की कलीसिया के ऊपर बड़ा सताव होन लगो। और प्रेरितन कै छोड़ सब विस्वासी यहूदिया और सामरिया के देसन मैं तितर-बितर हुईगै। ");
INSERT INTO thr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","कुछ धर्मप्रेमी लोग स्तिफनुस कै दफन कर दईं और बड़ा रोईं। ");
INSERT INTO thr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","पर साऊल कलीसिया कै उजाड़त गौ; बौ घर-घर जाएकै विस्वासियन कै, और आदमिन कै और बईंय्यरन कै घसीट कै कैदखाना मैं डार देत रहै। ");
INSERT INTO thr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जो विस्वासी बिखरे भै रहैं, बे हर जघा जाएकै सुसमाचार देत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलिप्पुस सामरिया सहर मैं जाएकै और हुँआँ लोगन कै मसीह को उपदेस दई। ");
INSERT INTO thr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","जो फिलिप्पुस कही, बामै भीड़ पूरो ध्यान दई, काहैकि बे बाकी बात सुनीं और बाके जरिये करे गै चिन्ह चमत्कार कै देखीं। ");
INSERT INTO thr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","निरे जनिन मैं से बुरी आत्मा निकारी गईं, और निरे फालिस की बिमारी और लंगड़न कै अच्छो करो गौ। ");
INSERT INTO thr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","जहे बजह से बौ सहर बड़ा खुस रहै। ");
INSERT INTO thr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","सिमौन नाओं को एक आदमी रहै, जो जादू-टोना से सामरिया के आदमिन कै अचम्मो करतो और खुदकै महान आदमी बतातो, ");
INSERT INTO thr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","और सहर के सब जनी, समाज के सबै वर्गन से, बाके ऊपर पूरो ध्यान दईं। बे कहीं, “कि परमेस्वर की सामर्थ्य ‘महान सामर्थ्य’ के रूप मैं जानी जाथै।” ");
INSERT INTO thr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","बौ निरे दिनन से उनकै अपने जादू के कामन से चकित करत रहो, तभईये बे बाकै बड़ा ध्यान देत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","लेकिन जब बे फिलिप्पुस को बिस्वास करीं जो परमेस्वर के राज्य और ईसु मसीह के नाओं को सुसमाचार सुनात रहै, तौ आदमी का बईय्यर बपतिस्मा लेन लगे। ");
INSERT INTO thr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","तौ सिमौन भी बिस्वास करी और बपतिस्मा लैकै फिलिप्पुस के संग रहेन लगो और चिन्ह चमत्कार और बड़े-बड़े सामर्थ्य के काम होत भै देखकै बड़ा अचम्मो करतो। ");
INSERT INTO thr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जब यरूसलेम मैं प्रेरित सुनीं, कि सामरिया के लोग परमेस्वर को बचन अपनाय लईं हैं तौ पतरस और यूहन्ना कै उनके झोने पनारी। ");
INSERT INTO thr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","जब बे हूँना पुगे, तौ विस्वासिन के ताहीं प्रार्थना करीं ताकी बे पवित्र आत्मा पामैं। ");
INSERT INTO thr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","काहैकि पवित्र आत्मा अबले उनमैं से कोईये ऊपर नाय उतरी रहै; बे सिरफ प्रभु ईसु के नाओं से बपतिस्मा लईं रहैं। ");
INSERT INTO thr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तौ पतरस और यूहन्ना उनके ऊपर हात धरी और बे पवित्र आत्मा पाईं। ");
INSERT INTO thr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जब सिमौन देखी कि प्रेरितन के हात धरन से पवित्र आत्मा दौ जाथै, तौ पतरस और यूहन्ना कै पैसन की घूस देन की कोसिस करी, ");
INSERT INTO thr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","और कही, “जहे अधिकार मोकै भी देबौ, कि जो कोई के ऊपर मैं हात धरौं, तौ बौ पवित्र आत्मा पाबै।” ");
INSERT INTO thr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","लेकिन पतरस बाकै जबाब दई, “तेरे पैसा तेरे संग नरक मैं जामैं, जौ सोचन के ताहीं कि तैं पैसन से परमेस्वर को वरदान मोल लै सकथै! ");
INSERT INTO thr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","जौ काम मैं ना तेरो कोई हिस्सा है और ना बाँट है, काहैकि तेरो मन परमेस्वर कि नजर मैं सई ना है। ");
INSERT INTO thr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","पस्चाताप कर, फिर, अपनी जौ योजना ताहीं प्रभु से प्रार्थना कर कि बौ तोकै जौ तरहन की बात मन मैं सोचन के ताहीं माफ कर देबै। ");
INSERT INTO thr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","काहैकि मैं देखरौ हौं कि तुम कटु ईर्सा से भरो भौ है और अधर्म को कैदी है।” ");
INSERT INTO thr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","तौ सिमौन पतरस और यूहन्ना से कही, “किरपा करकै मेरे ताहीं प्रभु से प्रार्थना करौ, ताकी तुमरे जरिये कही गई जे बातन मैं से कोई भी मेरे ताहीं ना होबै।” ");
INSERT INTO thr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","फिरौंकी पतरस और यूहन्ना गभाई दैकै, सामरिया और निरे गाँवन मैं प्रभु को सुसमाचार सुनात भै यरूसलेम कै लौट गै। ");
INSERT INTO thr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","प्रभु को एक दूत फिलिप्पुस से कही, “तैयार हुई जा और तरिहाँए के घाँईं जा रस्ता जो यरूसलेम से गाजा कै जाथै।” जौ रेगिस्तान बारो रस्ता है। ");
INSERT INTO thr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","इसलै फिलिप्पुस तैयार हुई गौ और चले गौ। तभई कूस देस को एक खोजा आत रहै, जो कूसियन की रानी के भंडार को एक खास अधिकारी रहै। बौ आराधना करन के ताहीं यरूसलेम मैं आओ रहै। ");
INSERT INTO thr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","बौ अपनी रथ मैं घरै बापस जात रहै। जैसे-जैसे बौ अग्गु बढ़ै, बौ यसायाह भविस्यवक्ता की किताब पड़त भै जाबै। ");
INSERT INTO thr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तौ पवित्र आत्मा फिलिप्पुस से कही, “बाके झोने जाएकै जौ रथ के संग हुई ले।” ");
INSERT INTO thr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस दौड़कै यसायाह भविस्यवक्ता की किताब से पढ़त भै सुनी तौ बासे पूँछी, “तू जो पढ़ रहो है, का तू बाकै समझतौ है?” ");
INSERT INTO thr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","अधिकारी जबाब दई, “जबले कोई मोकै नाय समझागो तौ मैं बाकै कैसे समझंगो?” और बौ फिलिप्पुस बासे बिनती करी की बौ चढ़कै बाके संग बैठे। ");
INSERT INTO thr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","सास्त्र को जौ अध्याय बौ पढ़त रहै, बौ जौ कहत रहै: “बौ एक भेंड़ के हानी रहै जोकै मारन के ताहीं लैजाओ जाथै, एक भेंड़ के मेम्ना के हानी जो कोई अबाज ना करथै जब बाको ऊन काट दौ जाथै। बौ एक सब्द ना कही। ");
INSERT INTO thr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","बाकै बेईज्जत करो गौ, और बाकै न्याय से वंचित कर दौ गौ। कोइयो बाके बंसज के बारे मैं नाय बताए पाओ। काहैकि पृथ्वी मैं बाकी जिंदगी खतम हुई गई।” ");
INSERT INTO thr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","तौ अधिकारी फिलिप्पुस से पूँछी, “मैं तोसे बिनती करथौं, बता, जौ भविस्यवक्ता कौनके बारे मैं कहरौ है? अपने बारे मैं या कोई दुसरे के बारे मैं?” ");
INSERT INTO thr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तौ फिलिप्पुस कहेन लागो; और सास्त्र के जौ अंस से सुरू हुईकै, बौ बाकै ईसु को सुसमाचार सुनाई। ");
INSERT INTO thr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","जब बे रस्ता मैं जातै रहैं, तौ बे एक जघा मैं आए जहाँ पानी रहै, तौ अधिकारी कही, “देख हिंयाँ पानी है। और अब मोकै बपतिस्मा लेन मैं का कोई रुकावट है?” ");
INSERT INTO thr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुस कही, “अगर तू पूरे मन से बिस्वास करथै तौ लै सकथै।” बौ कही “मैं बिस्वास करथौं।” ");
INSERT INTO thr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तौ अधिकारी रथ रोकन को आदेस दई, और फिलिप्पुस और अधिकारी दोनों पानी मैं उतर गै, और फिलिप्पुस बाकै बपतिस्मा दई। ");
INSERT INTO thr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जब बे पानी से बहार निकरकै आए, तौ प्रभु की आत्मा फिलिप्पुस कै दूर लै गई। अधिकारी बाकै फिर से नाय देखी, लेकिन खुसी से अपने रस्ता मैं चलत रहो। ");
INSERT INTO thr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","फिलिप्पुस अपने आपकै अस्दोद मैं पाई; बौ कैसरिया गौ, और रस्ता मैं बौ हर सहर मैं सुसमाचार को प्रचार करी। ");
INSERT INTO thr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","साऊल अपने चेला जो प्रभु के चेलन के खिलाप मार डारन की धमकी दई। जौ बीच बौ बड़ो पुजारी के झोने गौ धमकान और घात करन के ताक मैं रहत रहै। ");
INSERT INTO thr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","और बासे दमिस्क नाओं के सभाघर से जौ अधिकार को दस्तावेज माँगी कि आदमी का बईय्यर, जिनकै बौ परमेस्वर के रहामैं पाबै तौ उनकै पकड़कै यरूसलेम मैं लै आबै। ");
INSERT INTO thr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जैसे-जैसे साऊल दमिस्क सहर के झोने आत गौ, अनकाचीति आसमान से बाके ऊपर एक उजियारो चमको। ");
INSERT INTO thr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","बौ जमीन मैं गिर गौ और बाकै एक अबाज सुनाई दई, “साऊल, साऊल! तू मोकै काहेकै सताथै?” ");
INSERT INTO thr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","बौ पूँछी, “प्रभु तैं कौन है?” अबाज कही, “मैं ईसु हौं; जोकै तू सताथौ।” ");
INSERT INTO thr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“लेकिन अब उठकै और सहर मैं जा, जहाँ तोकै बताओ जागो कि तोकै का करनो चाहिए।” ");
INSERT INTO thr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जो आदमी साऊल के संग सफर करत रहैं, बे चकाय गै, काहैकि बे अबाज कै सुनत तौ रहैं, लेकिन कोई कै देख नाय पात रहै। ");
INSERT INTO thr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तौ साऊल जमीन मैं से उठो, लेकिन जब आँखी खोली तौ बाकै कछु सुजान ना लगो। जहे बजह से बे बाको हात पकड़कै दमिस्क मैं लैगै। ");
INSERT INTO thr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","बौ तीन दिन ले नाय देख सको, और बौ समय साऊल कछु ना खाए पी पाई। ");
INSERT INTO thr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिस्क मैं हनन्याह नाओं को एक चेला रहै, बासे प्रभु दर्सन मैं कही, “ए हनन्याह!” बौ जबाब दई, “परमेस्वर मैं हिंयाँ हौं।” ");
INSERT INTO thr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","प्रभु बासे कही, “तैयार हुई जा और बौ गली मैं जा, जो सीधी कही जाथै, और यहूदा के घर मैं साऊल नाओं को एक तरसुस बासिन्दा कै पूँछ; बौ प्रार्थना कर रौ है, ");
INSERT INTO thr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","और बौ सपने मैं देखी कि हनन्याह नाओं को एक आदमी बाके झोने आयकै बाके ऊपर हात रख रौ है, ताकी बौ फिर से देख सकै।” ");
INSERT INTO thr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याह जबाब दई, “प्रभु, मैं जहे आदमी के बारे मैं निरेन से सुनो हौं कि जौ यरूसलेम मैं तेरे पवित्र आदमिन के ताहीं करो गौ सबै भयानक कामन के बारे मैं बताई है। ");
INSERT INTO thr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","और बौ बड़े पुजारिन के अधिकार के संग दमिस्क नाओं की जघा आए गौ है, जो तुमरी पूजा करथैं।” ");
INSERT INTO thr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","प्रभु बासे कही, “तू जा, काहैकि बौ तौ गैर यहूदि और राजन और इस्राएलिन के अग्गु मेरो नाओं उजागर करन के ताहीं, मेरो चुनो भौ जन है। ");
INSERT INTO thr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","और मैं खुद बाकै बौ सब दिखांगो, जो बाकै मेरे नाओं खातिर भुकतने होगो।” ");
INSERT INTO thr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तौ हनन्याह उठकै बहे घर मैं गौ जोमैं साऊल रहे, और बाके ऊपर हात धरकै कही, “भईय्या साऊल, जो रस्ता मैं ईसु तोकै सुजाई दई रहै, बहे प्रभु मोकै पनारी है कि तैं दुबारा देख पाबै और पवित्र आत्मा से भर जाबै।” ");
INSERT INTO thr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","तुरंतै बाकी आँखी से मच्छी के सिन्नो जैसी पपड़ी झरी, और बाकै सुजाई देन लगो। तौ बौ उठकै बपतिस्मा लई; ");
INSERT INTO thr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","बौ खानु खाई, तौ बाकी ताकत बापस आई। फिर साऊल कुछ दिन ले चेलन संग दमिस्क मैं रहो। ");
INSERT INTO thr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","बौ तुरंतै सभाघर मैं ईसु को उपदेस देन लगो, कि बौ परमेस्वर को लौड़ा है। ");
INSERT INTO thr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","सब सुनन बारे अचम्मे भै और पूँछीं, “का जौ बहे नाय है जो यरूसलेम मैं रहै, जो बे आदमिन कै मारत रहै जो ईसु कै पूजत रहैं? और का बौ हिंयाँ इसलै ना आओ कि बे लोगन कै बंधी बनाएकै बड़े पुजारिन के झोने लै जाबै?” ");
INSERT INTO thr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","लेकिन साऊल को उपदेस और सक्तिसाली ही गै, बौ प्रमाड़ देत रहो की ईसु मसीहा रहै, बौ इतनो आस्वस्त रहै कि दमिस्क मैं रहेन बारे यहूदि बाको उत्तर नाय दै सकत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","जब निरे दिन गुजर गै, तौ यहूदिया के मिलकै साऊल कै खतम करन की साजिस बनाईं, ");
INSERT INTO thr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","लेकिन उनकी साजिस की खबर साऊल कै बताई गई। बे तौ बाकै खतम करन के ताहीं रात-दिन फाटकन घाँईं देखत रहेत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","लेकिन एक रात साऊल के चेला बाकै लै लई बाकै बितौला मैं बैठाईं और दीवार मैं से लटकाए कै उतार दईं। ");
INSERT INTO thr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","साऊल यरूसलेम गौ बौ चेलन से मिलन की कोसिस करी। लेकिन बे बिस्वास नाय करंगे कि बौ एक दास रहे, और बे सब बासे डरात रहैं। ");
INSERT INTO thr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","तौ बरनबास बाकी मदत के ताहीं आओ और बाकै प्रेरितन के झोने लैगौ। बौ उनकै समझाई कि कैसे साऊल सड़क मैं प्रभु कै देखी रहै और प्रभु बासे बात करी रहै। बौ जौ भी बताई रहै कि दमिस्क मैं ईसु के नाओं मैं साऊल कितनी हिम्मत से प्रचार करी रहै। ");
INSERT INTO thr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","तब साऊल उनके संग यरूसलेम मैं रहो और बेधड़क हुईकै प्रभु के नाओं से प्रचार करत रहो। ");
INSERT INTO thr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","बौ यूनानी भासा बोलन बारे यहूदियन के संग बोलचाल और बाद-विवाद करी, लेकिन बे बाकै मारन की कोसिस करीं। ");
INSERT INTO thr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","जब विस्वासी भईय्यन कै जौ पता चलो, तौ बे साऊल कै कैसरिया मैं लैगै और बाकै तरसुस कै पनार दईं। ");
INSERT INTO thr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","जौ बजह से पूरे यहूदिया, गलील और सामरिया की कलीसिया मैं सांति को समय रहै। पवित्र आत्मा की मदत से हौंसला पाईं और संख्या मैं बढ़ोतरी भइ, जो प्रभु के ताहीं सृद्धा रखत रहै। ");
INSERT INTO thr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पतरस सब जघा को सफर करी, और एक मौका मैं बौ परमेस्वर के पवित्र लोगन से मिलन कै गौ, जो लुद्दा मैं रहेत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","हूँना बाकै ऐनियास नाओं फालिस को मारो एक आदमी मिलो, जो आठ साल से खटिया मैं पड़ो रहै। ");
INSERT INTO thr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरस कही। “ऐनियास, उठ और अपनी सितरी उठा; ईसु मसीह तोकै ठीक करी है।” ");
INSERT INTO thr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तौ लुद्दा और सारोन के सब रहन बारे बाकै देखकै प्रभु के घाँईं मुरक गै। ");
INSERT INTO thr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा मैं तबीता नाओं की एक बईय्यर रहै, जो एक विस्वासन रहै। ग्रीक मैं बाको नाओं दोरकास है, जोको मतलब है “एक हीरन।” बौ अपनो सारो समय अच्छो करन और गरीबन की मदत करन मैं बिताई। ");
INSERT INTO thr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","बहे दिनन मैं बौ बिमार पड़कै मर गई; और आदमी बाकै हंदबाय कै ऊपर एक आँटी मैं धर दईं। ");
INSERT INTO thr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा याफा से जद्धा दूर नाय रहै, जब लुद्दा मैं चेला सुनी की पतरस याफा मैं है, तौ बे दुई जनी कै खबर के संग पनारकै नहोरे करीं, “कि जल्दी हमरे झोने आए जा।” ");
INSERT INTO thr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","जौ बजह से पतरस तैयार हुई गौ और उनके संग चले गौ। जब बे पहुँचे, तौ उनकै ऊपर कमरा मैं लैजाओ गौ, जहाँ सब बिधवैं उनकै गोल घेर लईं, और जो कुरता और लत्ता दोरकास उनके संग जीते जी रहेत भै बनाई रहै, बे दिखान लगी। ");
INSERT INTO thr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","तौ पतरस सबकै दुआरे कर दई, और घुपटियाय कै प्रार्थना करी और बौ सरीर के घाँईं मुड़कै देखकै कही, “ए तबीता, उठ!” तभई बौ अपनी आँखी खोल दई, और पतरस कै देखकै उठकै बैठ गई। ");
INSERT INTO thr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पतरस जाएकै बाकै उठन मैं मदत करी, और पवित्र विस्वासिन और बिधवन कै बुलाएकै बाकै जिंदो कर दई। ");
INSERT INTO thr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","जौ खबर पूरे याफा मैं फैल गई, और निरे आदमी प्रभु के ऊपर बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","पतरस याफा मैं कोई सिमौन नाओं के चमड़ा को कारोबार करन बारे के हींना निरे दिन तक रहो। ");
INSERT INTO thr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया मैं कुरनेलियुस नाओं को एक आदमी रहै, जो रोमन सेना-दल मैं एक कप्तान रहै, जोकै “इटालियन सेना-दल” कहो जात रहै। ");
INSERT INTO thr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","बौ एक धार्मिक आदमी रहै; बौ और बाको पूरो परिवार परमेस्वर की आराधना करी। बौ गरीब यहूदि आदमिन की मदत करन के ताहीं भौत कुछ करी और लगातार परमेस्वर से प्रार्थना करतो। ");
INSERT INTO thr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","बौ दिन के तीन बजे के आस-पास एक दर्सन देखी, कि परमेस्वर को एक स्वर्गदूत बाके झोने अंदर आए कै कही, “कुरनेलियुस!” ");
INSERT INTO thr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","तौ बौ स्वर्गदूत कै निहारकै देखी और डरात भौ कही, “गुरु, जौ का है?” स्‍वर्गदूत जबाब दई, “परमेस्वर तेरी प्रार्थना और दान के कामन से खुस है, और तेरो जबाब देन के ताहीं तैयार है। ");
INSERT INTO thr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","और अब याफा मैं कोई आदमी कै पनार दियौ जो सिमौन नाओं के एक आदमी कै बापस लै आबै जोकै जो पतरस कहो जाथै। ");
INSERT INTO thr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","बौ चमड़ा को कारोबार करन बारे सिमौन, के हींना हितुआ है, जोको घर समुंदर टिकारे है।” ");
INSERT INTO thr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जब स्वर्गदूत चले गौ, और कुरनेलियुस अपने दुई घर के सेवक और एक सिपईय्या कै बुलाई, एक धार्मिक आदमी जो उनके सबसे अच्छे सहयोगिन मैं से एक रहै। ");
INSERT INTO thr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","और उनकै सब बात बताए कै याफा कै पनारी। ");
INSERT INTO thr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दुसरे दिन जब बे अपने रहा मैं रहैं और याफा सहर के झोने पुगे, तौ दुपारी मैं पतरस छत ऊपर प्रार्थना करन चढ़ो। ");
INSERT INTO thr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","बाकै भूंक लागी और कछु खानो चहात रहै; लेकिन जब बे खानु बनान की तैयारी करत रहैं तौ बौ एक दर्सन देखी। ");
INSERT INTO thr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","बौ देखी कि आसमान खुल गौ है और कुछ नीचे आए रौ है, जो एक बड़ी चद्दर हानी दिखाए रौ है जो पृथ्वी के चारौ कोहने से उतारो जाएरौ है। ");
INSERT INTO thr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जोमैं पृथ्वी के सब हानी के जानवर, नेंगन बारे जानवर कीरा करमोला और आसमान के पक्छी रहैं। ");
INSERT INTO thr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","आसमान से एक अबाज बासे कही, “उठ, पतरस; मार और खा!” ");
INSERT INTO thr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","लेकिन पतरस कही, “ना प्रभु, कहुए नाय! मैं कहुए कोईये असुद्ध या छिया-पछारे चीज ना खाओ हौं।” ");
INSERT INTO thr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","फिर दुसरी बार बाकै अबाज सुनाई दई, “जो कछु परमेस्वर सुद्ध ठहराई है, बाकै तू असुद्ध मत बोलै।” ");
INSERT INTO thr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ऐसो तीन बार भौ; और फिर जौ चीज कै बापस आसमान मैं लैजाओ गौ। ");
INSERT INTO thr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जब पतरस दर्सन के मतलब के बारे मैं सोचत रहै, कुरनेलियुस के जरिये पनारे गै आदमिन कै पता रहै कि सिमौन को घर कहाँ है, बे मोहोंट अग्गु जाएकै ठाड़गै। ");
INSERT INTO thr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","और बे अबाज दैकै पूँछन लगे, “का सिमौन पतरस नाओं से हिंयाँ कोई हितुआ है?” ");
INSERT INTO thr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस अभईयो समझन की कोसिस करत रहै कि दर्सन को का मतलब है, जब आत्मा कही, “सुन! तीन आदमी हिंयाँ तोकै ढूँड़ रै हैं। ");
INSERT INTO thr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","इसलै तैयार हुईकै नीचे जाबौ, और उनके संग जान मैं संका मत करियो, काहैकि मैं उनकै भेजो हौं।” ");
INSERT INTO thr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तौ पतरस तरे उतरकै बे आदमिन से कही, “देखौ, जोकै तुम ढूँड़ रै हौ, बौ महीं हौं; तुम काहेकै आए हौ?” ");
INSERT INTO thr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","बे जबाब दईं, “कुरनेलियुस कप्तान हमैं भेजी है। बौ एक धर्मी आदमी है और परमेस्वर की आराधना करथै और पूरी यहूदि जाति मैं भलो है। परमेस्वर को पवित्र स्वर्गदूत बासे कही कि तैं बाकै अपने घरै बुलबा, ताकी बौ सुन सकै कि तोकै का बोलने है।” ");
INSERT INTO thr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तौ पतरस बे आदमिन कै अंदर बुलाई और उन्हैं रात रुकन ताहीं कही। दुसरे दिन बौ समर गौ और उनके संग चले गौ; और याफा के कुछ विस्वासी भईय्या बाके संग गै। ");
INSERT INTO thr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","दुसरे दिन बे कैसरिया सहर मैं पुगे, हूँन कुरनेलियुस अपने कुरमा-टब्बर और साथियन कै जोर कै उनकै असियात रहो। ");
INSERT INTO thr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जैसी पतरस भीतर घुसो, तौ कुरनेलियुस बासे मिलो, और लोहोक्कै बाके पाँव मैं गिर गौ। ");
INSERT INTO thr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","तौ पतरस बाकै उठात भइ कही। “ठाड़ जा,” और कही; “मैं खुद सिरफ एक आदमी हौं।” ");
INSERT INTO thr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","फिर पतरस बाके संग बात करत भइ घरै गौ, जहाँ बौ पाई कि निरे आदमी जुराने पड़े हैं। ");
INSERT INTO thr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","पतरस उनसे कही, “तुम खुद अच्छी तरह से जानथौ, कि कोई यहूदि कै उनके धर्म मैं जान से या गैर यहूदिन के संग जुड़न की इजाजत ना है। लेकिन परमेस्वर मोकै दिखाई है कि कोई भी आदमी कै छिया-पछारे या असुद्ध ना समझनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","और जब मैं बुलाओ गौ, तौ मैं बिना कोई दिक्कत करे चले आओ। मैं तुमसे पूछथौं, कि मोकै कौन से काम के ताहीं बुलाओ गौ है?” ");
INSERT INTO thr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","तौ कुरनेलियुस कही, “जौ तीन दिन पहले की बात है जब मैं अपने घरै दुपारी के तीन बजे प्रार्थना करत रहौं। अनकाचीति एक आदमी चमकीले लत्ता पहने भै, मेरे अग्गु आए कै ठाड़गौ। ");
INSERT INTO thr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","और कही, ‘कुरनेलियुस! परमेस्वर तेरी प्रार्थना सुन लई है और तेरे दान के कामन मैं ध्यान दई है। ");
INSERT INTO thr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","जहेमारे कोई कै याफा पनार जो सिमौन पतरस नाओं के आदमी कै बुलाबै। बौ सिमौन के घरै, जो चमड़ा को कारोबार करन बारे को हितुआ है, जो समुंदर के टिकारे रहथै।’ ");
INSERT INTO thr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तौ मैं तुरंतै तोकै बुलबाओ, और तैं जौ अच्छो करो कि आए गौ। अब हम सब हींना परमेस्वर की मौजूदगी मैं हैं, ताकी जो कछु प्रभु तोसे कही है बाकै सुनैं।” ");
INSERT INTO thr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तौ पतरस बोलनो सुरू करी: “मोकै अब एहसास भौ है कि जौ सच है कि परमेस्वर सबन के संग एक जैसो बर्ताव करथै। ");
INSERT INTO thr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","जो बासे डराथैं और धार्मिक काम करथैं, बौ बाकै भाथै, चाँहे बे कोई भी जाति के होमैं। ");
INSERT INTO thr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","तुम ईसु मसीह के जरिये सांति के सुसमाचार को ऐलान करत भइ इस्राएल के लोगन कै भेजे गै संदेस कै जानथौ, जो सबन को प्रभु है। ");
INSERT INTO thr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","तुम यहूदिया की बौ महान घटना के बारे मैं जानतै हौ जो यूहन्ना के बपतिस्मा के बचन को प्रचार के बाद गलील मैं सुरू भइ, जो इस्राएल की धरती मैं भइ रहै। ");
INSERT INTO thr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","तुम ईसु नासरी के बारे मैं जानथौ और परमेस्वर बाके ऊपर पवित्र आत्मा और सामर्थ्य कैसे अभिसेक करी। बौ सब जघा जातो, और जो सैतान के सताए भै रहैं, अच्छो करत फिरतो, काहैकि परमेस्वर बाके संग रहै। ");
INSERT INTO thr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","हम बे सब बातन के गभा हैं; जो बौ यहूदा और यरूसलेम मैं करी, और बे बाकै क्रूस मैं टाँग कै मारडारीं। ");
INSERT INTO thr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","लेकिन परमेस्वर बाकै तिसरे दिन बाद मरे से जिंदो करी, और उजागर भी करी, ");
INSERT INTO thr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सब लोगन कै नाय बल्कि उन गभन कै जिन्हैं परमेस्वर पहले से चुन लई रहै, मतलब हमकै जो बाके मरे भैन मैं से जी उठन के बाद बाके संग खाईं पीं। ");
INSERT INTO thr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","और बौ हमकै हुकम दई कि आदमिन मैं सुसमाचार प्रचार करौ और गभाई देबौ, कि जौ बहे है जोकै परमेस्वर जिंदे और मरे भै को न्याय करन बारो ठहराई है। ");
INSERT INTO thr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","सब भविस्यवक्ता गभाई देथैं जो भी बाके ऊपर बिस्वास करैगो, बहेकै बाके सामर्थी नाओं के जरिये पापन से माफी मिलैगी।” ");
INSERT INTO thr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस जे बात करतै रहै, कि जो-जो बाको संदेस सुनत रहै बाके ऊपर पवित्र आत्मा उतर आई। ");
INSERT INTO thr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","और जित्ते खतना करे भै विस्वासी पतरस के संग याफा से आए रहैं, बे सब अचम्मे मैं पड़ गै कि गैर यहूदिन के ऊपर पवित्र आत्मा को दान अखनाओ गौ है। ");
INSERT INTO thr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","काहैकि बे उनकै तरह-तरह की भासा बोलत और परमेस्वर की महानता की तारिफी करत सुनी, जहे ऊपर पतरस कही: ");
INSERT INTO thr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“का अब कोई इनकै पानी को बपतिस्मा लेन से कोई रोक सकथै, जेऊँ हमरे हानी पवित्र आत्मा पाईं हैं?” ");
INSERT INTO thr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","और बौ हुकम दई कि बे ईसु मसीह के नाओं मैं बपतिस्मा लेमैं। तौ बे बासे नहोरे करीं कि बौ कुछ दिन और उनके संग रहाबै। ");
INSERT INTO thr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","यहूदिया मैं रहन बारे जो निरे प्रेरित और विस्वासी भईय्या रहैं सुनीं, कि गैर यहूदि के भी परमेस्वर को बचन अपनाय लईं हैं। ");
INSERT INTO thr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","और जब पतरस यरूसलेम गौ, तौ हूँन के लोग गैर यहूदि को खतना करन बारेन के घाँईं रहैं, बे बाकी बुराई करत भै कहीं, ");
INSERT INTO thr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“तैं बिना खतना यहूदि के घरै एक हितुआ रहै, और तैं उनके संग भी खाओ!” ");
INSERT INTO thr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","तभई पतरस उन्हैं सुरु से जो कुछ भौ रहै, बाको पूरो हिसाब दई: ");
INSERT INTO thr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“जब मैं याफा सहर मैं प्रार्थना करत रहौं, तौ मैं एक दर्सन मैं देखो कि आसमान से कछु नीचे आए रौ है, जो स्वर्ग के चारौ कोने से एक बड़ी चद्दर के तराहनी उतारी जाए रइ है, और बौ मेरे झोने आयकै ठहर गई। ");
INSERT INTO thr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","जब बाकै झोने से देखो तौ मैं बामै पृथ्वी के तमान पालतू, नेंगन बारे जानवर, कीरा-करमोला और आसमान के पक्छी देखो। ");
INSERT INTO thr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","तभई मोए एक अबाज सुनाई दई, ‘उठ, पतरस; मार और खा!’ ");
INSERT INTO thr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","लेकिन मैं कहो, ‘हरगिज नाय प्रभु! कैसो भी असुद्ध और छिया-पछारे खानु मेरे मोहों मैं नाय गौ है।’ ");
INSERT INTO thr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","तौ आसमान से फिर से अबाज आई, ‘जो कछु परमेस्वर सुद्ध ठहराई है, बाकै असुद्ध मत कह।’ ");
INSERT INTO thr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तीन बार ऐसो ही भौ, और आखरी मैं सारो सामान आसमान मैं खींच लौ गौ। ");
INSERT INTO thr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","बहे घड़ी कैसरिया से मेरे झोने पनारे गै तीन आदमी बहे घर पहुँचे जितै मैं रुको रहौं। ");
INSERT INTO thr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तौ आत्मा मोसे बिना हिचकिचाय उनके संग जानकै कही और याफा के जे छ: विस्वासी भईय्या मेरे संग कैसरिया गै, और हम सब कुर्नेलियुस के घर मैं गै। ");
INSERT INTO thr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","और कुर्नेलियुस हमकै बताई कि कैसे एक दिन बौ अपनेई घरै एक स्वर्गदूत कै देखी रहै, जो बासे कही, ‘याफा के ताहीं कोई ऐसो आदमी कै पनारै जोको पूरो नाओं सिमौन पतरस है। ");
INSERT INTO thr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","बौ तोसे ऐसी बात कहेगो, जोके बजह से तैं और तेरो पूरो परिवार बच जागो।’ ");
INSERT INTO thr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","जब मैं बोलनो सुरु करो, तौ पवित्र आत्मा उनके ऊपर बैसिये उतरो, जैसो सुरु मैं हमरे ऊपर उतरो रहै। ");
INSERT INTO thr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तौ मोए प्रभु को बात याद आओ कि बौ का कही रहै: ‘यूहन्ना तौ पानी से बपतिस्मा लई लेकिन तुमकै पवित्र आत्मा को बपतिस्मा दिओ जागो।’ ");
INSERT INTO thr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","जौ सपा है कि परमेस्वर बे गैर यहूदिन कै बहे दान दई है जो बौ आपन कै दई रहै जब आपन प्रभु ईसु मसीह मैं बिस्वास करत रहैं; तौ मैं कौन होथौं, जो, परमेस्वर कै रोक सकत रहौं!” ");
INSERT INTO thr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","जब बे ऐसो सुनी, तौ बे बुराई करनो बंद कर दईं और परमेस्वर की बड़ाँईं करत भै कहीं, “तभई तौ परमेस्वर गैर यहूदिन कै मन फिरान और जिंदगी जीन को मौका दई है!” ");
INSERT INTO thr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","कुछ विस्वासी सताव के बजह से तितर-बितर भै रहैं जब स्तिफनुस कै मार डारो गौ रहै, तभई फीनीके, साइप्रस और अन्ताकिया की जघा मैं साऊल और बरनबास गै। जो सिरफ यहूदिन कै संदेस देत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","लेकिन गैरविस्वासी, जो साइप्रस और कुरेनी के रहैं, अन्ताकिया गै और यूनानी भासा बोलन बारेन कै भी संदेस, और उन्हैं प्रभु ईसु मसीह को सुसमाचार सुनाईं। ");
INSERT INTO thr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","और प्रभु की ताकत उनके संग रहै, और तादात मैं लोग बिस्वास करीं और प्रभु के घाँईं मुड़ गै। ");
INSERT INTO thr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","तौ उनकी खबर यरूसलेम की कलीसिया मैं पौहौंच गई, और तभई बे बरनबास कै अन्ताकिया मैं पनार दईं। ");
INSERT INTO thr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","जब बौ आयकै देखी कि परमेस्वर लोगन कै कैसी सामर्थ्य और अनुग्रह दई है, तौ बौ मन मैं भौत खुस भौ और सबसे पूरे दिल से प्रभु के ताहीं बफादार और सच्चो होन की नहोरे करी। ");
INSERT INTO thr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","काहैकि बरनबास एक अच्छो आदमी रहै; बौ पवित्र आत्मा और बिस्वास मैं भरो भौ रहै, और निरे लोगन कै प्रभु के झोने लाई रहै। ");
INSERT INTO thr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तौ बरनबास साऊल कै देखन के ताहीं तरसुस कै निकर गौ। ");
INSERT INTO thr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","जब बासे भेंटा भौ, तौ बाकै अन्ताकिया मैं लैगौ, और पूरो एक साल तक दोनों कलीसिया के लोगन संग मिले और एक बड़े झुंड कै पढ़ाई। ऐसो अन्ताकिया मैं रहै कि चेलन कै पहले मसीह कहो जात रहै। ");
INSERT INTO thr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","बहे समय मैं कुछ भविस्यवक्ता यरूसलेम से अन्ताकिया आए रहैं। ");
INSERT INTO thr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","उनमैं से एक, अगबुस नाओं को उठ खड़ो भौ और पवित्र आत्मा की ताकत से भविस्यवाँड़ी करी कि पृथ्वी मैं भैंकर सूखा पड़ैगो। जौ ऐसो जब क्लौदियुस महाराजा के समय आओ रहै। ");
INSERT INTO thr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तौ चेला सलाह करीं कि बे हर एक विस्वासिन भईय्यन की सेवा करन के ताहीं उत्तो ही पनारंगे, जित्तो कि बे यहूदिया मैं रहत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","बे ऐसो ही करीं, और बरनबास और साऊल के हात कलीसिया मैं बड़े-बूढ़ेन कै पैसा भेजीं। ");
INSERT INTO thr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","बेईं दिनन हेरोद राजा कलीसिया के कुछ सदस्यन कै सतानो सुरू कर दई। ");
INSERT INTO thr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","बौ यूहन्ना के भईय्या याकूब कै तलवार से मार डारी रहै। ");
INSERT INTO thr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जब बौ देखी, कि जासे यहूदि खुस हैं, तौ बौ अग्गु बढ़ो और पतरस कै पकड़ लई। बे दिन अखमीरी रोटी के दिन रहैं। ");
INSERT INTO thr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","बाकै पकड़वान के बाद पतरस कै कैदखाना मैं डार दौ गौ, जितै उनकै चार सैनिकन के चार झुंडन के जरिया हर एक कै बचान के ताहीं सौंप दौ गौ रहै। हेरोद फसह के बाद बाकै जनता के मुकदमा मैं डारन की योजना बनाई। ");
INSERT INTO thr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","तभई पतरस कै कैदखाना मैं रखो गौ, लेकिन कलीसिया के लोग बाके ताहीं परमेस्वर से प्रार्थना करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जो रात हेरोद बाके लोगन के अग्गु लान बारो रहै, बासे पहले की रात पतरस दुई रखबरिया के बीच सोत रहै। बौ दुई जंजीर से भँदो भौ रहै, और कैदखाना के मोहोंट मैं रखबारी करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","अनकाचीति प्रभु को एक स्वर्गदूत आयकै ठाड़ो रहै, और कुठरिया मैं एक रौसनी चमकत रहै। स्वर्गदूत पतरस कै कंधा पकड़कै हलाई, बाकै जगाई और कही, “फटाफट कर! उठ जा!” बाके हात से जंजीर खुलकै गिर गईं। ");
INSERT INTO thr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तौ स्वर्गदूत बासे कही, “करिहाँओं कस और अपनी चप्पल रख ले।” और पतरस बैसोई करी, और स्वर्गदूत बासे कही, “अपने लत्ता अपने चारौ तरफ धर और मेरे पच्छू हुई ले।” ");
INSERT INTO thr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","पतरस निकरकै बाके पच्छू हुई लई; लेकिन जौ नाय जानत रहै कि जो कछु स्वर्गदूत कह रहो है, बौ सच्ची है, बल्किन जौ समझी कि मैं दर्सन देख रहो हौं। ");
INSERT INTO thr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तौ बे पहलो और दुसरो पहरा से निकरकै बौ लोहे के फाटक मैं पुगे, जो सहर के घाँईं रहै। तौ उनके ताहीं अपने आप फाटक खुल गौ, और बे एक गलियारे हुईकै दुआरे निकर गै। और तुरंतै स्वर्गदूत पतरस कै छोड़कै चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","तौ पतरस होस मैं आयकै कही, “अब मैं सच्ची मैं जानगौ कि प्रभु अपनो स्वर्गदूत पनारकै मोकै हेरोद के हाथ से छुड़ाय लई, और यहूदियन की सबै उमीद तोड़ दई।” ");
INSERT INTO thr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","अपनी हालत जानकै, बौ पतरस यूहन्ना की अईय्या मरियम के घर मैं आओ जो मरकुस नाओं से जानो जात रहै। हूँना निरे आदमी जुराए कै प्रार्थना करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पतरस मोहोंट को फाटक खटखटाई, और जाको जबाब देन के ताहीं रोडा नाओं की एक सेविका आई। ");
INSERT INTO thr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","बौ पतरस की अबाज पहचान लई और बौ भौत खुसी के मारे फाटक नाय खोली; बौ दौड़कै भीतर गई और बताई कि पतरस मोहोंट मैं ठाड़ो है। ");
INSERT INTO thr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","बे बासे कहीं, “तू पागल है!” लेकिन बौ और जोर दैकै बोली कि ऐसो ही है। तौ बे कहीं, “बाको स्वर्गदूत होगो।” ");
INSERT INTO thr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","लेकिन पतरस खटखटात रहो तौ बे फाटक खोलीं, और जब बे बाकै देखीं तौ दंग रहगै। ");
INSERT INTO thr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तभई बौ उनकै हात से इसारा करी की बे चुप रहमैं; और उनकै बताई कि प्रभु कौन तरीका से मोकै कैदखाना से निकार लाई है। फिर कही, “जौ याकूब और उनके विस्वासी भईय्यन कै बताए दियो।” तौ निकरकै दुसरी जघा चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","भोर कै सिपईय्यन मैं बड़ा खलबली मच गई कि पतरस कितै गौ? ");
INSERT INTO thr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","जब हेरोद बाकै ढुँड़बाई और नाय पाई, तौ रखबरियन कै हुकम दई कि, बे पतरस कै मार डारैं और हेरोद यहूदिया कै छोड़कै कैसरिया मैं रहेन लगो। ");
INSERT INTO thr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोद सूर और सैदा के आदमिन से कतई सांति नाय रहै। तभई बे एक मन हुईकै बाके झोने आए और बलास्तुस कै जो राजा को एक करमचारी रहै, बाकै राजी करकै मेल करनो चाही; काहैकि राजा के देस से उनके देस को पालन-पोसँड़ होत रहै। ");
INSERT INTO thr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ठहराओ भौ दिन मैं हेरोद, राजा बारे लत्ता पहनकै न्याय करन बारी जघा मैं बैठो; और उनकै बखान करन लागो। ");
INSERT INTO thr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","और आदमी चिल्लाए उठे, “जौ तौ आदमी को नाय परमेस्वर को बोल है।” ");
INSERT INTO thr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","बहे घड़ी प्रभु को एक स्वर्गदूत तुरंतै चोट मारी, काहैकि हेरोद परमेस्वर की आदर नाय करी रहै; और बौ कीरा पड़कै मरो। ");
INSERT INTO thr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","लेकिन परमेस्वर को बचन बढ़त और फैलत गौ। ");
INSERT INTO thr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जब बरनबास और साऊल अपनी सेवा पूरी कर चुके तौ यूहन्ना कै जो मरकुस कहलात रहै, बाकै संग लैकै यरूसलेम लौट आओ। ");
INSERT INTO thr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया की कलीसिया मैं कुछ भविस्यवक्ता और सिक्छक रहैं; उनमैं बरनबास, समौन जो नीगर कहो जाथै, लूकियुस कुरेनी, मनाहेम जोकै हेरोद राजा के संग लाओ गौ रहै, और साऊल। ");
INSERT INTO thr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जब बे बर्त रखकै प्रभु की प्रार्थना करत रहैं, तौ पवित्र आत्मा उनसे कही, “मेरी सेवा ताहीं बरनबास और साऊल कै बौ काम के ताहीं अलग करौ जोके ताहीं मैं उनकै बुलाओ हौं।” ");
INSERT INTO thr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तौ बे बर्त रखीं और प्रार्थना करकै उनके ऊपर हात धरकै उनकै बिदा करीं। ");
INSERT INTO thr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","तौ बरनबास और साऊल पवित्र आत्मा से भरकै सिलुकिया कै गै; और हूँना से पानी के जहाज मैं साइप्रस जान के ताहीं चढ़े। ");
INSERT INTO thr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","जब बे सलमीस मैं पहुँचे, तौ बे यहूदि सभाघरन मैं अधिकार से परमेस्वर के बचन को प्रचार करीं। उनके काम करन मैं मदत करन के ताहीं यूहन्ना उनके संग रहै। ");
INSERT INTO thr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","और बे सब टापू मैं से होत भै, पाफुस तक पुगे। हूँना उनकै बार-ईसु नाओं को एक जादूगर मिलो, जो यहूदि और झूठो भविस्यवक्ता रहै। ");
INSERT INTO thr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","बौ टापू को राज्यपाल सर्जियस पौलुस को दोस्त रहै, जो एक बुद्धिमान आदमी रहै। राज्यपाल उनके सामने बरनबास और साऊल कै बुलाई काहैकि बौ परमेस्वर को बचन सुननो चहात रहै। ");
INSERT INTO thr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","लेकिन जादूगर एलीमास, ग्रीक भासा मैं बाको नाओं है के जरिये बिरोध करो गौ, जो राज्यपाल कै बिस्वास से दूर करन की कोसिस करी। ");
INSERT INTO thr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तौ साऊल जोको नाओं पौलुस भी है, पवित्र आत्मा से भरो भौ; बौ जादूगर घाँईं देखी ");
INSERT INTO thr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","और कही, “तैं सैतान को बालका है! तैं धार्मिकता को दुस्मन है। तैं सब तरहन की बुरी चालन से भरो भौ है, और तैं हमेसा प्रभु के सच्चाई कै झूठ मैं बदलन की कोसिस करत रहथै! ");
INSERT INTO thr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","प्रभु को हाथ अब तेरे ऊपर आगो; तैं अंधरा हुई जागो और कुछ समय के ताहीं दिन की उजीतो ना देख पागो।” एक बार के ताहीं एलीमास कै लगो कि बाकी आँखी मैं अंधियारो छाए गौ है, और बाको हाथ पकड़कै नेतृत्व करन के ताहीं कोई कै ढूँड़न की कोसिस करन लगो। ");
INSERT INTO thr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","जब राज्यपाल देखी कि का भौ रहै, तौ बौ बिस्वास करी; काहैकि बौ प्रभु के बारे मैं पढ़कै भौत चकित भौ रहै। ");
INSERT INTO thr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौलुस और बाके संग के पाफुस से रवाना भै और पंफूलिया के एक सहर पिरगा मैं आए, जहाँ यूहन्ना उनकै छोड़कै बापस यरूसलेम मैं चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","बे पिरगा से चले गै और पिसिदिया के अन्ताकिया मैं पहुँचे, और साबत के दिन सभाघर मैं जाएकै बैठगै। ");
INSERT INTO thr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","तौ मूसा के नियम और भविस्यवक्ता को सास्त्र पढ़न के बाद सभाघर के मुखिया उनके झोने एक खबर भेजीं, “भईय्यौ और बहेनियौ, अगर तुमरे पास जे लोगन कै हौंसला देन ताहीं संदेस है तौ तुम कहबौ।” ");
INSERT INTO thr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तौ पौलुस ठाड़गौ, और अपने हात से इसारा करकै, कहेन लगो: “इस्राएलियौ और हिंयाँ के सब दूसरे लोग जो परमेस्वर की आराधना करथैं: मोकै सुन लेबौ! ");
INSERT INTO thr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इस्राएल के लोगन को परमेस्वर हमरे बड़े-बूढ़ेन कै चुनी, और मिस्र देस मैं परदेसी हुईकै रहन के दौरान लोगन कै एक महान रास्ट्र बनाई। परमेस्वर उन्हैं अपनी महान सक्ति से मिस्र से बाहर निकारी, ");
INSERT INTO thr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","और चालीस साल तक बौ रेगिस्तान मैं उनकी सहत रहो। ");
INSERT INTO thr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","बौ कनान मैं सात देसन कै नास कर दई और अपने जाति लोगन कै जघा को मालिक बनाए दई। ");
INSERT INTO thr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","जौ सब मैं लमसम 450 साल लगे। जाके बाद समूएल भविस्यवक्ता के समय ले बौ उनके ऊपर न्याय करन बारो ठहराई। ");
INSERT INTO thr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","बाके बाद बे एक राजा माँगी; तौ परमेस्वर चालीस साल के ताहीं बिन्यामीन के खानदान मैं से एक आदमी मतलब कीस के लौड़ा साऊल कै उनके ऊपर राजा ठहराई। ");
INSERT INTO thr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","बाकै हटान के बाद, परमेस्वर दाऊद कै उनको राजा बनाई। परमेस्वर बाके बारे मैं गभाई दई: ‘मोकै एक आदमी, यिसै को लौड़ा दाऊद, मेरे मन के हिसाब से मिलगौ है। बहे मेरी सब इच्छा पूरी करैगो।’ ");
INSERT INTO thr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","दाऊद की पीढ़ी मैं से परमेस्वर अपने वादा के मुताबिक इस्राएलिन के झोने एक उद्धारकर्ता, यानी ईसु कै पनारी। ");
INSERT INTO thr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ईसु को काम सुरू करन से पहले, यूहन्ना इस्राएल के सब लोगन कै उपदेस दई कि उन्हैं अपने पापन से मन फिरान और बपतिस्मा लेनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","और जब यूहन्ना अपनी सेवा पूरी करन बारो रहै, तौ बौ कही, ‘तुम मोकै का समझथौ? मैं बौ नाय हौं! जोको तुम इंतजार कर रै हौ। लेकिन सुनौ! मेरे बाद एक आनबारो है, और जोके मैं पाँव के जूतन की तनी भी खोलन के लायक ना हौं।’” ");
INSERT INTO thr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“मेरे साथी इस्राएलियौ, अब्राहम के बंसज और हिंयाँ के सब गैर यहूदि, जो परमेस्वर की आराधना को मान रखथैं: जौ हमरे ताहीं है कि जौ उद्धार को संदेस भेजो गौ है! ");
INSERT INTO thr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरूसलेम मैं रहन बारे और उनके सासक कै जौ पता ना रहै कि बौ उद्धारकर्ता है, और ना बे भविस्यवक्ता की बे न्याय की बातन कै समझत रहैं जो हर साबत के दिन पढ़ी जात रहैं। फिर भी बे ईसु की बुराई करकै भविस्यवक्तन की बातन कै सच कर दईं। ");
INSERT INTO thr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","बे बाकै मार डारन को ऐसो कोई दोस बामै नाय पाईं, तहुँओं बे पिलातुस से कहीं कि बौ बाकै मौत के घाट उतार देबै। ");
INSERT INTO thr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","और जब बे बाके बारे मैं पवित्र सास्त्र मैं लिखी भइ सब बात पूरी करीं, तौ बे बाकै क्रूस से नीचे उतारकै कबर मैं रखीं। ");
INSERT INTO thr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","लेकिन परमेस्वर बाकै मरे भै मैं से जिंदो करी, ");
INSERT INTO thr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","और बौ उनकै जो बाके संग गलील से यरूसलेम आए रहैं, निरे दिन तक बे लोगन कै दिखाई देत रहो। बे अब इस्राएल के लोगन के ताहीं बाके गभा हैं। ");
INSERT INTO thr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","और हम तुम्हैं बौ वादा के बारे मैं जो बड़े-बूढ़ेन से करी गई रहै, जौ सुसमाचार सुनाथैं, ");
INSERT INTO thr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","कि परमेस्वर ईसु कै जिंदो करकै, बहे प्रतिग्या हमारी औलाद के ताहीं पूरी करी; जैसो कि दूसरे भजन संहिता मैं लिखो गौ है: ‘तू मेरो बालका है; आज मैं तेरो दऊवा बन गौ हौं।’ ");
INSERT INTO thr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","और परमेस्वर बाकै मरे भैन मैं ऊपर उठन के बारे मैं कही, कहुए कबर मैं सड़न के ताहीं नाय: ‘मैं तुम्हैं पवित्र आर्सिवाद दुंगो मैं दाऊद से वादा करो रहौं।’ ");
INSERT INTO thr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","जैसो कि बास्तव मैं बौ एक और भजन संहिता मैं कहथै: ‘तैं अपने वफादार जन कै कबर मैं सड़न ना देगो।’ ");
INSERT INTO thr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","काहैकि दाऊद अपने समय मैं परमेस्वर के उद्देस्यन की सेबा करी, और फिर बौ मर गौ, अपने पुरखन के संग दफनाओ गौ, और बाके सरीर कै कबर मैं रखो गौ। ");
INSERT INTO thr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पर जौ बाके संग ना भौ जोकै परमेस्वर मौत मैं से जिंदो। ");
INSERT INTO thr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","हम तुमकै जाननो चाहथैं, मेरे साथी इस्राएलियौ, कि जौ ईसु के जरिये से है कि पापन की माफी के बारे मैं संदेस तुमकै प्रचारित करो जाथै; जिनसे मूसा को नियम तुम्हैं माफ नाय कर सकथै। ");
INSERT INTO thr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","और जो कोई बाके ऊपर बिस्वास करथै बौ बे उन सब पापन से मुक्त हुई जाथै। ");
INSERT INTO thr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ध्यान रखियो, फिर, ताकी भविस्यवक्ता जो कछु कही हैं बौ तुमरे संग ना होबै: ");
INSERT INTO thr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘देखौ, तुम बदमासौ! चकित हुई जाबौ और मर जाबौ! आज मैं जो कछु कर रौ हौं बौ कुछ ऐसो है जब कोई जाकै तुमकै समझागो, तौ तुम बाके ऊपर बिस्वास ना करैगे!’” ");
INSERT INTO thr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","जैसो कि पौलुस और बरनबास सभाघर से निकरत रहैं, लोग उन्हैं अगले साबत के रोज बापस आन और अपनी बातन के बारे मैं और जाधे बतान के ताहीं नहोरे करीं। ");
INSERT INTO thr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","लोगन के सभाघर से आराधना खतम होन के बाद, पौलुस और बरनबास के पच्छू तमान यहूदि और तमान गैर यहूदि रहैं जो यहूदि धर्म मैं बदल गै रहैं। प्रेरित उनसे बात करकै समझाईं, कि परमेस्वर के अनुग्रह और किरपा मैं बने रहाबौ। ");
INSERT INTO thr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","अगले साबत के दिन सहर के लमसम सब आदमी प्रभु को बचन सुनन के ताहीं आए। ");
INSERT INTO thr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","लेकिन यहूदि भीड़ कै देखकै नफरत से भर गै, और बुराई करत भै पौलुस की बातन के खिलाप मैं बोलन लागे। ");
INSERT INTO thr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","लेकिन पौलुस और बरनबास और भी निडर हुईकै कहीं: “जरूरी रहे, कि परमेस्वर को बचन अग्गु तुमकै सुनाओ जाए। लेकिन जब तुम जाकै ना अपनाथौ और अपने आपकै अनंत जिंदगी के ताहीं नाय परखथौ, तौ हम तुमकै छोड़ देंगे और गैर यहूदिन मैं जांगे। ");
INSERT INTO thr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","काहैकि प्रभु हमकै जौ आग्या दई है, बौ जौ है: ‘मैं तोकै गैर यहूदिन के ताहीं जोती ठहराओ हौं, कि तैं पृथ्वी के छोर ले उद्धार पहोंचाबै और सब बच जामैं।’” ");
INSERT INTO thr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","जौ सुनकै गैर यहूदि खुस भै, और प्रभु के बचन की बड़ाँईं करन लगे, और जित्ते अनंत जिंदगी के ताहीं ठहराए गै रहैं, बे सब बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","तौ प्रभु को बचन बौ पूरे छेत्र मैं फैल गौ। ");
INSERT INTO thr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","लेकिन यहूदि आदमी ऊँचे कुल की भक्त बईंय्यरन कै और सहर के जाने-माने आदमिन कै भड़काईं, जो परमेस्वर की आराधना करत रहैं, और पौलुस और बरनबास के खिलाप मैं करबाय कै उनकै अपने छेत्र से बाहर निकार दईं। ");
INSERT INTO thr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","प्रेरित उनके बिरोध मैं अपने पाँव के धूदर कै झारकै इकुनियुम कै चले गै। ");
INSERT INTO thr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","और चेला अन्ताकिया मैं खुसी और पवित्र आत्मा से भरत गै। ");
INSERT INTO thr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनियुम मैं भी जहे बात भइ: कि पौलुस और बरनबास यहूदियन के सभाघर मैं गै, और ऐसी बात करीं, कि यहूदि और गैर यहूदि लोग विस्वासी बन गै। ");
INSERT INTO thr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","लेकिन जो यहूदि बिस्वास ना करी रहैं, बे गैर यहूदिन कै भड़काए कै उन्हैं विस्वासी भईय्यन के खिलाप कर दईं और उनके मन मैं जहर भर दईं। ");
INSERT INTO thr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","और बे प्रेरित लंबे समय तक हूँना रुके रहे, प्रभु के बारे मैं निडर हुईकै बात करत भै, जो बे साबित करीं कि उनकी किरपा के बारे मैं उनको अनुग्रह को संदेस उन्हैं चिन्ह चमत्कार और अचम्मे काम करन की सक्ति देन के ताहीं गभाई देथै। ");
INSERT INTO thr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","लेकिन सहर के आदमिन के बीच मैं फूट पड़ गई रहै; और जासे कित्ते तौ यहूदिन के घाँईं, और कित्ते प्रेरितन के घाँईं हुईगै। ");
INSERT INTO thr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","तौ कुछ गैर यहूदि और यहूदि अपने मुखियन के संग मिलकै प्रेरितन के संग बुरो बर्ताव करन के ताहीं और उन्हैं पथरा मारन को फैसला करीं। ");
INSERT INTO thr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","जब प्रेरितन कै जाके बारे मैं पता चलो, तौ बे लुकाओनिया मैं लुस्त्रा और दिरबे के सहरन और आसपास के छेत्र मैं भाज गै। ");
INSERT INTO thr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","हूँना बे सुसमाचार को प्रचार करीं। ");
INSERT INTO thr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्त्रा सहर मैं एक आदमी रहै, बौ जनम से लंगड़ा रहै, और कहुए नाय नेंगी रहै। ");
INSERT INTO thr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","बौ हूँना बैठकै पौलुस की बात सुनी। पौलुस बाकै देखी कि बौ बिस्वास करथै और अच्छो हुई सकथै, जौ बजह से बौ बाकै एक टक भाँदकै देखी ");
INSERT INTO thr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","और बासे ऊँचे बोल मैं कही, “अपनी टाँग के बल सीध ठाड़ जा।” तौ बौ कूदकै चलन फिरन लगो। ");
INSERT INTO thr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","जब भीड़ पौलुस को जौ काम देखी, तौ बे अपनी लुकाओनियाई भासा मैं चिल्लानो सुरू कर दईं, “दुईता आदमिन के तराहनी ही गै हैं और हमरे झोने आए गै हैं!” ");
INSERT INTO thr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","और बे बरनबास कै ज्यूस, और पौलुस कै हिरमेस नाओं दईं, काहैकि बे मुख्य वक्ता रहैं। ");
INSERT INTO thr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","और ज्यूस दुईता को बौ पुजारी रहै, जोको मंदिर सहर के बाहर खड़ो रहै, बौ बरधा और फूलन की माला कै सहर के मोहोंट मैं लाईं, काहैकि बौ और भीड़ प्रेरितन के ताहीं बलिदान देनो चहात रहैं। ");
INSERT INTO thr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","जब बरनबास और पौलुस प्रेरित ऐसो सुनीं, तौ बे अपने लत्ता फाड़ीं और भीड़ के बीच मैं भाजत भै चिल्लाईं, ");
INSERT INTO thr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“तुम जौ काहे कर रै हौ? हमउँ तौ तुमरे जैसी इंसान हैं! हम हिंयाँ तुमकै सुसमाचार सुनाथैं, कि तुम जे बेकार चीजन से अलग हुईकै जिंदे परमेस्वर के घाँईं फिरौ, जो स्वर्ग और धरती और समुंदर और जो कछु बामै है बनाई। ");
INSERT INTO thr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","बीते समय मैं बे सब लोगन कै अपने तरीका से जान दई। ");
INSERT INTO thr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","लेकिन बौ हमेसा अपनी मौजूदगी को सबूत दई है कि बौ जो अच्छो काम करथै: बौ तुमकै सई समय मैं स्वर्ग से मेंहें, और फसल दई है; बौ तुमकै खानु देथै और तुमरे मन कै सांति और खुसी से भर देथै।” ");
INSERT INTO thr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","जे सब्दन के संग प्रेरित सायद भीड़ कै उनके ताहीं बलिदान देन से रोक सकैं। ");
INSERT INTO thr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","कुछ यहूदि अन्ताकिया और इकुनियुम से आए रहैं; आदमिन कै अपने घाँईं कर लईं, और पौलुस के ऊपर पथराव करीं, और बाकै मरो भौ समझकै सहर के दुआरे घसीटत लैगै। ");
INSERT INTO thr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","लेकिन जब चेला बाके घाँईं आयकै ठाड़गै, तौ बौ उठकै सहर मैं गौ और दुसरे दिन बरनबास के संग दिरबे के घाँईं चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","और बे दिरबे सहर के आदमिन कै सुसमाचार सुनाए कै, और निरे चेला बनाएकै, लुस्त्रा, इकुनियुम से अन्ताकिया कै लौट आए। ");
INSERT INTO thr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","बे चेलन कै मजबूत करत रहैं और उनकै जौ सुसमाचार देत रहैं कि बिस्वास के ताहीं सच्चे मन से रहाबौ; और जौ कहत रहैं, हमकै बड़ा कलेस सह कै परमेस्वर के राज्य मैं घुसन होगो ");
INSERT INTO thr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","और बे हर एक कलीसिया मैं उनके ताहीं बड़े-बूढ़े चुनत रहैं, और बर्त के संग प्रार्थना करकै उनके प्रभु की बड़ाँईं करीं, जोमैं बे अपनो बिस्वास रखी रहैं। ");
INSERT INTO thr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","और पिसिदिया परदेस से होत भै बे पंफूलिया परदेस मैं पुगे। ");
INSERT INTO thr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","और पिरगा नगर मैं बचन सुनाए कै अत्तालिया नगर मैं आए। ");
INSERT INTO thr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","और हूँना से बे अन्ताकिया लौट आए, जो जघा बे परमेस्वर के अनुग्रह और किरपा की देखाभारी करन के ताहीं सराहे गै रहैं जो अब बे पूरो कर चुके हैं। ");
INSERT INTO thr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","जब बे अन्ताकिया पुगे, तौ बे कलीसिया के लोगन कै एक संग इखट्टो करीं और उनकै बे सबन के बारे मैं बताईं जो परमेस्वर उनके संग करी रहै और कैसे बे गैर यहूदि के बिस्वास करन को फाटक खोल दईं। ");
INSERT INTO thr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","और बे चेलन के संग लंबे समय ले हूँना रहे। ");
INSERT INTO thr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","फिर यहूदिया से कुछ आदमी अन्ताकिया आयकै विस्वासी भईय्यन कै जौ सिखान लगे; “अगर तुमरो खतना मूसा के नियम से नाय होथै तौले तुम उद्धार नाय पाए सकथौ।” ");
INSERT INTO thr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","जब पौलुस और बरनबास की उनसे खूबै लड़ाई और बहेस भइ तौ जहे ठहराओ गौ, कि पौलुस और बरनबास, और अन्ताकिया से कुछ आदमी जौ बात के बारे मैं प्रेरितन और बड़े-बूढ़ेन के झोने यरूसलेम कै जाएकै पता करैं। ");
INSERT INTO thr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","तौ कलीसिया उनकै कुछ दूर ले छोड़न आई; और बे फीनीके और सामरिया से होत भै गुजरे, तौ बे बताईं कि कैसे गैर यहूदि परमेस्वर के घाँईं फिरे हैं; जौ खबर सुनकै सब विस्वासी भईय्यन कै बड़ा खुसी भइ। ");
INSERT INTO thr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जब बे यरूसलेम मैं पुगे, तौ कलीसिया और प्रेरित और बड़े-बूढ़े उनसे खुसी के संग भेंटा करीं, और बे बताईं कि परमेस्वर उनके संग हुईकै कैसे-कैसे काम करी रहै। ");
INSERT INTO thr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","लेकिन फरीसिन के झुंड मैं से कुछ विस्वासी ठाड़गै और कहीं, “गैर यहूदिन कै खतना करनो चाहिए और मूसा के नियम को पालन करनो चाहिए।” ");
INSERT INTO thr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तौ प्रेरित और बड़े-बूढ़े मिलकै जौ सवाल मैं बिचार करीं। ");
INSERT INTO thr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","बड़ा बहस के बाद पतरस ठाड़कै कही, “मेरे भईय्यौ और बहेनियौ, तुम जानथौ कि भौत समय पहले परमेस्वर मोकै तुम मैं से चुनी रहै कि हम गैर यहूदिन कै सुसमाचार सुनामैं, ताकी बे सुन सकैं और बिस्वास कर सकैं। ");
INSERT INTO thr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","और परमेस्वर, जो सबन के बिचारन कै जानथै, गैर यहूदिन कै अपनी पवित्र आत्मा दैकै उन्हैं अपनाय लई, जैसो बौ हमरे संग करी। ");
INSERT INTO thr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","बौ हमरे और उनके बीच कोई भेद-भाव ना करी; काहैकि बौ बिस्वास से उनके मन कै सुद्ध करी। ");
INSERT INTO thr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","तौ अब तुम परमेस्वर की काहे इम्तिहान लेथौ। कि चेलन की घेंट मैं ऐसो जुआ धरौ, जोकै ना हमरे बड़े-बूढ़े ठड़बाए सक्त रहैं और ना हम ठड़बाए सकथैं। ");
INSERT INTO thr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","न! हम बिस्वास करथै और प्रभु ईसु के अनुग्रह और किरपा से बच जाथैं, जैसे बे हैं।” ");
INSERT INTO thr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तौ पूरी सभा चुप्पेचाप‍ से बरनबास और पौलुस की बात सुनन लागी, जो कि परमेस्वर गैर यहूदिन मैं उनके जरिये कैसे-कैसे चिन्ह दिखाई, और अचम्मे काम करी रहै। ");
INSERT INTO thr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","जब बे बोलनो बंद कर दईं, तौ याकूब बोलो: “मेरे भईय्यौ और बहेनियौ, मेरी सुनौ। ");
INSERT INTO thr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","सिमौन बताई, कि परमेस्वर पहली बार गैर यहूदि मैं कैसे किरपा दृस्टि करी, उनमैं से अपने नाओं के ताहीं उनकै अपनो बनाए लई। ");
INSERT INTO thr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","भविस्यवक्तन के बचन जासे पूरी तरह सहमत हैं। जैसो कि सास्त्र कहथै, ");
INSERT INTO thr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘प्रभु कहथै, जाके बाद मैं लौटंगो, और दाऊद को मिलाप बारो तम्बु फिर से बनांगो। और मैं जाके खंडर कै फिर से मजबूत बनांगो। ");
INSERT INTO thr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","कि बची भइ मानव जाति प्रभु कै ढूँड़ैं, और सब गैर यहूदि जो मेरो नाओं लेथैं, यहोवा की जहे वाँड़ी है, जो जे कामन कै करथैं। ");
INSERT INTO thr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","तौ परमेस्वर कहथै, जो सुरुवातै से जान लई रहै।’” ");
INSERT INTO thr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","यूहन्ना की, “जौ मेरी राय है, हमैं गैर यहूदियन कै परेसान नाय करनो चाहिए जो न्याई परमेस्वर के घाँईं मुड़ रै हैं। ");
INSERT INTO thr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पर उनकै चिट्ठी लिखकै पनारैं कि बे मूर्तिन के चढ़ाय भै असुद्ध खानु होन से और व्यभिचार और घेंट अमेठे भै जानवर के मास से और बाके खून से दूर रहामैं। ");
INSERT INTO thr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","काहैकि पुराने समय से सहर-सहर मैं मूसा की नियम को प्रचार करन बारे होत चले आए हैं, और बौ हर साबत के दिन सभाघर मैं पढ़ो जात रहै।” ");
INSERT INTO thr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तौ प्रेरित और बड़े-बूढ़े पूरी कलीसिया के संग मिलकै कलीसिया के कुछ लोगन कै चुनन और उनकै पौलुस और बरनबास के संग अन्ताकिया मैं भेजन को फैसला करीं। बे दुई आदमिन कै चुनीं, जो विस्वासियन, यहूदा जोकै बरसब्बास कहो जाथै, और सीलास कै चुनीं, जो भईय्यन मैं प्रमुख रहैं। ");
INSERT INTO thr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","और बे उनके जरिया जे चिट्ठी भेजीं: “अन्ताकिया, सीरिया और किलिकिया देस के रहन बारे, हम प्रेरित और बड़े-बूढ़े तुमरे भईय्यन कै जो गैर यहूदि हैं जनम-जनम के ताहीं सुभकामना भेजथैं। ");
INSERT INTO thr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","हम सुने हैं कि कुछ लोग हमरी आग्या के बिना हमसे बाहर चले गै और बे तुमकै परेसान करीं, बे तुमरे मन कै परेसान करीं। ");
INSERT INTO thr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","और तभई हम एक संग मिले हैं और सब कुछ दूत चुनन और उनकै तुमकै भेजन के ताहीं सहमति उजागर करी है। बे हमरे प्रिय दोस्त बरनबास और पौलुस के संग जांगे। ");
INSERT INTO thr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","जो अपनी ज्यान हमरे प्रभु ईसु मसीह के नाओं की सेवा के ताहीं खतरा मैं डारीं हैं। ");
INSERT INTO thr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","तभईये हम यहूदा और सीलास कै बहै बात कहेन ताहीं पनारे हैं, जो हम लिखे हैं। ");
INSERT INTO thr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पवित्र आत्मा, और जरूरी बातन के अलावा; हम तुमरे ऊपर कोई और बोझ नाय डारे हैं। ");
INSERT INTO thr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","कि जो मूर्तिन कै चढ़ाओ गौ होबै और घेंट अमेठो भौ जानवर के खून; मास कै नाय खामैं, और छिनरइपना से दूर रहामैं; इनसे दूर रैहगे तौ तुम्हारो भलो होगो। तुमरे ताहीं अच्छी कामना के संग।” ");
INSERT INTO thr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","दूतन कै भेज दौ गौ और अन्ताकिया चले गै, जितै बे विस्वासियन के पूरे झुंड कै जोरीं और उनकै चिट्ठी दईं। ");
INSERT INTO thr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","और जब आदमी जाए पढ़ीं, तौ बे प्रोत्साहित से भरो संदेस से खुसी से भर गै। ");
INSERT INTO thr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","और यहूदा और सीलास जो खुद भविस्यवक्ता रहैं, बे भईय्यन से निरी लम्बी बात करीं जोसे बे हौंसला और ताकत से भर गै। ");
INSERT INTO thr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","कुछ समय हूँना बितान के बाद, उनकै भईय्यन के जरिया सांति के संग पनार दौ गौ, और जो लोग उनकै भेज डारीं रहैं, बे बापस चले गै। ");
INSERT INTO thr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","लेकिन सीलास कै हूँना रहनों अच्छो लगो। ");
INSERT INTO thr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पौलुस और बरनबास कुछ समय अन्ताकिया मैं बिताईं; और कइयो लोगन के संग मैं बे प्रभु को सुसमाचार सुनात और प्रचार करत रहे। ");
INSERT INTO thr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","कुछ समय बाद पौलुस बरनबास से कही, “जो-जो सहरन मैं हम जो प्रभु को बचन सुनाए रहैं, आबौ, उनके झोने जाएकै बे भईय्यन और बहेनियन को हाल-खबर लेमैं।” ");
INSERT INTO thr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","बरनबास की इच्छा रहै कि बौ यूहन्ना जोको दुसरो नाओं मरकुस है कै भी अपने संग लै चले, ");
INSERT INTO thr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","लेकिन पौलुस बाकै अपने संग लै जानो सई ना समझी, काहैकि बौ उनके मिसन के संग आखरी ले ना रुको रहै, बल्कि उनकै पंफूलिया मैं छोड़ दई रहै। ");
INSERT INTO thr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","और जे दोनों के बीच मैं ऐसी बहस भइ कि बे एक दुसरे से अलग हुईगै; तौ बरनबास, मरकुस कै लैकै साइप्रस कै चले गै। ");
INSERT INTO thr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","जबकी पौलुस सीलास कै छाँटी, और प्रभु को अनुग्रह और किरपा भईय्यन की देखाभारी करन के ताहीं सराहना करी। ");
INSERT INTO thr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","सीरिया और किलिकिया से होत भै निकरो, जोसे कलीसियन कै मजबूती मिली। ");
INSERT INTO thr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पौलुस दिरबे और लुस्त्रा मैं भी गौ, और हूँना तीमुथियुस नाओं को एक चेला रहै। बाकी अईय्या यहूदि विस्वासी रहै, लेकिन बाको दऊवा यूनानी रहै। ");
INSERT INTO thr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लुस्त्रा और इकुनियुम मैं सबै विस्वासी भईय्यन तीमुथियुस की अच्छी बात करीं। ");
INSERT INTO thr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुस तीमुथियुस कै अपने संग लै जानो चहात रहै, जहे बजह से बौ बाको खतना करी काहैकि बे जघा रहेन बारे सबै यहूदि जानत रहै कि तीमुथियुस को बाबा यूनानी रहै। ");
INSERT INTO thr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","और सहर-सहर जात भै बे उन नियम कै जो यरूसलेम के प्रेरित और बड़े-बूढ़े ठहराईं रहैं, मानन और परखन के ताहीं उनकै झोने जात रहै। ");
INSERT INTO thr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","जौ बजह से कलीसियन कै बिस्वास मैं मजबूत बनाओ गौ और रोजाना संख्या मैं बढ़त भइ। ");
INSERT INTO thr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","बे फ्रूगिया और गलातिया देसन मैं से हुईकै गै, काहैकि पवित्र आत्मा उनकै आसिया के देसन मैं बचन सुनान से मना कर दई। ");
INSERT INTO thr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","बे मूसिया की सीमा मैं पुगकै बितूनिया मैं जान की कोसिस करीं, लेकिन ईसु की आत्मा उनकै जान की इजाजत ना दई। ");
INSERT INTO thr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","जौ बजह से बे मूसिया से हुईकै तरोआस मैं आए। ");
INSERT INTO thr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","हूँना पौलुस रात कै एक दर्सन देखी कि एक मकिदुनी आदमी ठाड़ो भौ, बासे नहोरे करकै कहथै, “मकिदुनिया मैं आ और हमरी मदद कर!” ");
INSERT INTO thr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","बाके जौ दर्सन देखतै हम तुरंतै मकिदुनिया रवाना होन के ताहीं तैयार हुईगै, काहैकि हम तैं करे कि परमेस्वर हमैं हूँना के लोगन कै सुसमाचार सुनान के ताहीं बुलाई है। ");
INSERT INTO thr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","हम तरोआस से जहाज के जरिया सीधे समुथ्राके रवाना भै और दुसरे दिन कै नियापुलिस मैं आए। ");
INSERT INTO thr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","हूँना से हम फिलिप्पी मैं गै, जो मकिदुनिया जिला को खास सहर, और रोमन की बस्ती रहै; हम बौ सहर मैं कुछ दिन तक रहे; ");
INSERT INTO thr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","साबत के दिन हम सहर के दुआरे नदिया के टिकारे जौ समझकै गै कि हूँना प्रार्थना करन की जघा होगी; और बे हूँना बैठी भइ बईंय्यरन से बात करन लगे। ");
INSERT INTO thr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","जो बईंय्यरैं हमैं सुनीं, उनमैं से एक थुआतीरा सरह मैं की लुदिया नाओं की बईय्यर रहै, जो बैंगनी लत्तन को ब्यापार करत रहै। बौ एक बईय्यर रहै जो परमेस्वर की आराधना करे करत रहै, और प्रभु बाको मन खोली, ताकी पौलुस की बातन मैं ध्यान लगाबै। ");
INSERT INTO thr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","और बाके बाद बाके घर के लोग बपतिस्मा लईं, बौ हमकै बुलबाई, “आबौ और मेरे घर मैं रहबौ अगर तुम फैसला करे हौ कि मैं प्रभु मैं सच्चो बिस्वास रखथौं।” और बौ हमकै नहोरे करकै जान के ताहीं मनाए लई। ");
INSERT INTO thr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","एक दिन जब हम प्रार्थना करन बारी जघा मैं जात रहैं, तौ हमरो भेंटा एक ज्वान सेविका बईय्यर से भइ, जोमैं एक प्रेत आत्मा रहै, जो बाकै भविस्य की भविस्यवाँड़ी करन मैं माहिर बनाई। बौ अपने मालिकन कै भाग्य बताए कै बड़ा पैसा कमाई। ");
INSERT INTO thr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","बौ पौलुस और हमरे पच्छू आत भै कही, “जे आदमी परमप्रधान दऊवा परमेस्वर के सेवक हैं! बे तुमरी घोसड़ाँ करत हैं कि तुमरो कैसे उद्धार हुई सकथै!” ");
INSERT INTO thr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","बौ निरे दिन तक ऐसो करी, जबले की पौलुस इत्तो परेसान नाय भौ कि बौ चक्कर लगाई और आत्मा से कही, “ईसु मसीह के नाओं मैं, मैं तुमकै बासे बहार आन कै कहथौं!” आत्मा बहे घड़ी निकरकै चली गई। ");
INSERT INTO thr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","“जब बाके मालिकन कै पता लगो कि हमरी कमाई की आसा खतम हुई जाए रहो है, तौ पौलुस और सीलास कै पकड़कै चौराहे मैं मुखिया के झोने खींचत भै लैगै। ");
INSERT INTO thr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","बे उनकै रोमन अधिकारिन के झोने लाए और कहीं, जे आदमी यहूदि हैं, और जे हमरे सहर मैं बखेड़ो खड़ो कर रै हैं। ");
INSERT INTO thr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","और बे ऐसी रीति रिवाज सिखाए रै हैं जो हमरे नियम के खिलाप है; हम रोमन नागरिक हैं, और हम जे रीति रिवाजन कै नाय अपनाय सकथैं या उनकै नाय पढ़ सकथैं।” ");
INSERT INTO thr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","और भीड़ पौलुस और सीलास के खिलाप जुराए कै उनके ऊपर चढ़ गई। तौ हाकिम पौलुस और सीलास के लत्ता फाड़ दईं, और उनकै बेंथ से मारन कै कहीं। ");
INSERT INTO thr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","खूब पिटाई के बाद, उनकै कैदखाना मैं डरबाए दईं और दरोगा से कहीं कि उनकै तंग करकै रखियो। ");
INSERT INTO thr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","उनके कहनो के मुताबिक दरोगा उनकै भीतर की कुठरिया मैं लैजाय कै और उनकी टाँग कट्ठा के खपचा मैं कस दईं। ");
INSERT INTO thr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","करीबन आधी रात कै पौलुस और सीलास प्रार्थना करत भै परमेस्वर के भजन संहिता गात रहैं और दुसरे कैदी उनकी बातैं सुनत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","कि इत्ते मैं अनकाचीति एक बड़ो हालाचाला आओ, जो कैदखाना की बुनियाद को पथरा तक हलाए दई। एक बार सब फाटक खुल गै, और सबन की साँकर खुल गईं। ");
INSERT INTO thr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","दरोगा जग गौ, और जब बौ कैदखाना के फाटक खुले देखकै समझी कि कैदी भाज गै हैं, तभईये बौ अपनी तलवार से खुदकै मारनो चाही। ");
INSERT INTO thr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","लेकिन पौलुस तेज अबाज से चिल्लाए कै कही, “अपने कै कछु नुकसान मत करै, काहैकि हम सब हीनैं हैं!” ");
INSERT INTO thr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तभई दरोगा दिया मंगवाए कै भीतर आओ और कपकपात भौ पौलुस और सीलास के पाँव मैं गिर गौ। ");
INSERT INTO thr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","फिरौंकी उनकै दुआरे लाए कै कही, “हे मालिक उद्धार पान ताहीं मैं का करौं?” ");
INSERT INTO thr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","बे जबाब दईं, “प्रभु ईसु के ऊपर बिस्वास कर, तौ तैं और तेरो पूरो परिवार उद्धार पागो।” ");
INSERT INTO thr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","तौ बे बाके पूरे घर के आदमिन कै प्रभु को बचन सुनाईं। ");
INSERT INTO thr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","और रात कै बहे समय बौ उनकै लै जाएकै उनके घाव कै धोई, और बौ अपने सब आदमी समेत तुरंतै बपतिस्मा लई। ");
INSERT INTO thr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","फिर बौ पौलुस सीलास कै अपने घर मैं लै जाएकै कुछ उनकै खानु खान कै दई। और बाको पूरो परिवार परमेस्वर ऊपर बिस्वास करकै खुसी मनाईं। ");
INSERT INTO thr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","अगले भोर रोमन अधिकारी पुलिस अधिकारिन कै आदेस दैकै भेजी, “कि बे आदमिन कै छोड़ देबौ।” ");
INSERT INTO thr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","फिर कैदखाना को अधिकारी पौलुस से कही, “अधिकारियैं तोकै और सीलास कै छोड़ देन को आदेस दई हैं। अब तुम छोड़कै सांति से जाए सकथौ।” ");
INSERT INTO thr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","लेकिन पौलुस पुलिस अधिकारी से कही, “हमैं कोई भी गुनाह को कसूरवार नाय पाईं, फिर भी बे हमैं सबन के सामने मारीं, हम रोमन नागरिक हैं! फिर भी बे हमैं कैदखाना मैं डार दईं। और अब बे हमैं चुपके से भेजनो चाहथैं। ऐसो ना हुई सकथै! रोमन अधिकारिन कै खुद हींना आनो चाहिए और हमैं बाहर लैकै जामैं।” ");
INSERT INTO thr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","पुलिस अधिकारी जे बातन की खबर रोमन अधिकारिन कै दईं; और जब बे सुनीं कि पौलुस और सीलास रोमन नागरिक हैं, तौ बे डराय गै। ");
INSERT INTO thr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","जौ बजह से बे जाएकै उनसे नहोरे करी और माफी माँगी; और बे उन्हैं कैदखाना से बाहर निकारीं और उनसे सहर छोड़न के ताहीं कहीं। ");
INSERT INTO thr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","पौलुस और सीलास कैदखाना से निकरकै लुदिया के घरै गै। हूँना बे विस्वासी भईय्यन से मिलकै उनकै हौंसला दईं, और चले गै। ");
INSERT INTO thr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पौलुस और सीलास अम्फिपुलिस और अपुल्लोनिया से होत भै थिस्सलुनीके मैं आए, जितै यहूदियन को एक सभाघर रहै। ");
INSERT INTO thr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पौलुस साधारँड़ चाल-चलन के जरिया उनके झोने गौ, और हूँना तीन साबत दिन के दौरान आदमिन से सास्त्र की बातचीत करी। ");
INSERT INTO thr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","और उनकै सास्त्र से फोड़-फोड़कै मतलब समझात रहै, और साबित करी कि “मसीह को दुख उठानो, और मरे भै मैं से जिंदो होनो जरूरी रहै,” पौलुस कही, “जहे ईसु की जोकी मैं बात सुनाथौं, मसीह है।” ");
INSERT INTO thr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","उनमैं से कुछ यहूदिन कै राजी कर लौ गौ, और भक्त यूनानिन मैं से निरे और निरी सारी बईंय्यरैं परमेस्वर कै अपनाईं, और पौलुस और सीलास के संग सामिल हुईगै और परमेस्वर की आराधना करीं। ");
INSERT INTO thr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","लेकिन यहूदि जलन से भर गै और फालतू आदमी जुराए कै एक बड़ी भीड़ बनाएकै सहर मैं हुलगदड़ मचान लागे। और पौलुस और सीलास कै ढूँड़न लगे ताकी और लोगन कै बहार लाय सकैं, जहे कोसिस मैं यासोन नाओं के एक आदमी के घर मैं हमला कर उनकै आदमिन के बीच लानो चाँहीं। ");
INSERT INTO thr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","लेकिन जब उनकै हूँना नाय पाईं तौ बे चिल्लात भै सहर के हाकिम झोने यासोन और कुछ विस्वासी भईय्यन कै खींच लाईं, “जे लोग दुनिया मैं गलत माहौल बनाए दईं हैं! और अब हिंयाँ भी आए गै हैं, ");
INSERT INTO thr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","और यासोन उनकै अपने घर मैं रखी है। बे सबै कैसर के नियम कै तोड़ी रै हैं कि एक और राजा है, जोको नाओं ईसु है।” ");
INSERT INTO thr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","जब भीड़ नगर और हाकिम जे बात सुनी, तौ बे बाकी बात मैं आए गै। ");
INSERT INTO thr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","हाकिम यासोन और बाकी आदमिन कै जमानत के ताहीं पैसन को भुगतान करीं, और फिरौंकी उनकै छोड़ दईं। ");
INSERT INTO thr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","तौ भईय्या तुरंतै रातौ-रात पौलुस और सीलास कै बेरीया मैं पनार दईं। जब बे हूँना पुगकै, यहूदिन के सभाघर मैं गै। ");
INSERT INTO thr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","जे आदमी थिस्सलुनीके के यहूदिन से समझदार रहैं तभईये बे पूरी लगन से बचन अपनाईं, और रोजाना पवित्र सास्त्रन मैं ढूँड़ते कि जे बात पौलुस सच कही है कि नाय। ");
INSERT INTO thr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","उनमैं से निरे लोग बिस्वास करीं; और ऊँची खानदान की निरी यूनानी बईंय्यरैं और निरे आदमी भी बिस्वास करीं। ");
INSERT INTO thr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","लेकिन जब थिस्सलुनीके के यहूदि जानगै कि पौलुस बेरीया मैं भी परमेस्वर को बचन सुनाई है, तौ बे हूँना आयकै भीड़ कै भड़कान लागे। ");
INSERT INTO thr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तभई भईय्या पौलुस कै समुंदर के टिकारे पनार दईं; लेकिन सीलास और तीमुथियुस बेरीया मैं लौट गै। ");
INSERT INTO thr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पौलुस कै भेजन बारे बाकै एथेंस ले लैगै, और फिर पौलुस से आग्या लैकै बेरीया लौटे कि सीलास और तीमुथियुस जल्दिये बाके संग मिल जामैं। ");
INSERT INTO thr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जब पौलुस एथेंस मैं सीलास और तीमुथियुस कै असियात रहै, तौ नगर कै मूर्तिन से भरो भौ देखकै बौ मन से भौत परेसान भौ। ");
INSERT INTO thr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","तभई बे यहूदि और यहूदि सभाघर मैं बतकाईं की, हर दिन बे नगर की चौक मैं आनबारेन के संग परमेस्वर की आराधना करीं। ");
INSERT INTO thr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","कुछ इपिकूरी और स्तोईकी गुरु बासे बहस करन लगे। उनमैं से कुछ कहीं, “जौ अग्यानी का कहनो चाहथै?” लेकिन दुसरे लोग जबाब दईं, “बौ दुसरे विदेसी दुईतन के बारे मैं बात कर रौ है।” बे जौ इसलै कहीं काहैकि पौलुस ईसु और बाके दुबारा जी उठन और सुसमाचार को प्रचार करत रहै। ");
INSERT INTO thr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","जौ बजह से बे पौलुस कै अपने संग अरियुपगुस सहर के घेरा की एक बैठक मैं लै आई, जहाँ बे बासे कहीं, “का हम जानथै की जौ नया सिक्छड़ का है जो तुम दिखाए रहे हौ? ");
INSERT INTO thr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","काहैकि तू अनोखी बात हमैं सुनाए रहो है, तभईये हम जाननो चाहथैं कि इनको मतलब का होथै।” ");
INSERT INTO thr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","तभईये सबै एथेंस नगर बारे और बाहर के जो हूँना रहेत रहैं, अपनो समय बितान के अलावा और कछु नाय करत रहैं और नये बिचारन कै सुनत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","पौलुस अरियुपगुस सहर परिसद के सामने ठाड़कै कही, “एथेंस मैं रहन बारेयौ, मैं देखथौं कि तुम सब बड़ा धर्मी हौ। ");
INSERT INTO thr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","काहैकि मैं तुमरे नगर से चलत भौ आत रहौं, और बे जघन कै देखो, जितै तुम आराधना करथौ, तौ मोकै एक बेदी मिली, जोमैं लिखो रहै, ‘अनजानो परमेस्वर।’ तभई मैं तुमकै बाके बारे मैं बतानो चाहथौं जोकै तुम बिना जाने पूजथौ। ");
INSERT INTO thr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","परमेस्वर, जो धरती और बामै सब कछु बनाई है, बौ स्वर्ग और दुनिया को प्रभु है और इंसान के हातन से बने भै मंदिरन मैं नाय रहथै। ");
INSERT INTO thr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ना बाकै कोई ऐसी चीज की जरूरत है जोकै हम बाके ताहीं काम करकै पूरो कर सकैं, काहैकि बौ तौ खुदै जिंदगी और सांस और सब कछु देथै। ");
INSERT INTO thr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","बौ एकै इंसान से धरती मैं सब तरह की जाति बनाई और उनकै पूरी पृथ्वी रहेन ताहीं दई। और जघन की सीमा तैं करीं, जितै बे रहेत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","बौ ऐसो जहेमारे करी ताकी बे बाकै ढूँड़ैं, और सायद बे बाकै पाए लेमैं जैसो कि बे बाके बारे मैं महसूस करीं रहैं। फिर भी परमेस्वर बास्तव मैं हममैं से कोई से दूर ना है; ");
INSERT INTO thr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","जैसो कि कोई कहो है, ‘बामै हम जीथैं और अग्गु बढ़थैं और मौजूद रहथैं।’ जैसो कि तुमरे कुछ कवि कहीं हैं, ‘हमउँ उनके बालका हैं।’ ");
INSERT INTO thr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","काहैकि हम परमेस्वर के बालक हैं, हमकै जौ नाय माननो चाहिए कि बाको स्वभाव सोनो या चाँदी या पथरा की छवी जैसो है, जोकै इंसान की कला और सोच से बनाओ गौ है। ");
INSERT INTO thr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","परमेस्वर बौ समय कै अनदेखो कर दई जब लोग बाकै नाय जानत रहैं, लेकिन अब बौ उन सबन कै हर जघा आग्या देथै कि बे अपनी बुरी रहा से मुड़ैं। ");
INSERT INTO thr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","काहैकि बौ एक दिन ठहराई है जोमैं बौ बहे धार्मिकता से दुनिया को न्याय करैगो, जो आदमी कै बौ ठहराई है और बाकै मरे भैन मैं से जिंदो करकै जौ बात सबन के बीच मैं साबित कर दई है!” ");
INSERT INTO thr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","जब बे पौलुस कै पुनरुत्थान के बारे मैं बोलत सुनी, तौ उनमैं से कित्ते बाकी मजाक उड़ाईं, लेकिन दुसरे लोग कहीं, “हम तोकै बाके बारे मैं फिर से बोलत भौ सुननो चाहथैं।” ");
INSERT INTO thr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","और पौलुस उनकी बैठक छोड़कै उनके बीच से चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","लेकिन कुछ आदमी बाके संग जुड़ गै, और बिस्वास करीं, जिनमैं से दियुनुसियुस, जो परिसद को सदस्य रहै; एक बईय्यर रहै, जोको नाओं दमरिस रहै, और कुछ दुसरे लोग भी रहै। ");
INSERT INTO thr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","जाके बाद पौलुस एथेंस कै छोड़कै कुरिन्थुस मैं चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","हूँना बाकै अक्विला नाओं को एक यहूदि मिलो, जोको जनम पुन्तुस मैं भौ रहै, बौ अपनी बईय्यर प्रिस्किल्ला के संग हाल ही मैं इटली से आओ रहै, काहैकि सम्राट क्लौदियुस सब यहूदिन कै रोम से निकर जान को आदेस दई रहै। जहे बजह से पौलुस उनकै देखन गौ, ");
INSERT INTO thr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","और बाको और उनको एकै काम रहै; जहे बजह से बौ उनके संग रहो, और बे काम करन लगे, उनको काम तम्बु बनान को रहै। ");
INSERT INTO thr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","और बौ हर साबत के दिन सभाघर मैं बात-चीत करकै यहूदि और यूनानि दोनों कै समझान की कोसिस करत रहै। ");
INSERT INTO thr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जब सीलास और तीमुथियुस मकिदुनिया से आए, तौ पौलुस अपनो पूरो समय संदेस प्रचार करन के ताहीं दई, यहूदिन कै गभाई देत भइ कि ईसु ही मसीह है। ");
INSERT INTO thr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","जब बे बाको बिरोध करीं और बाके बारे मैं बुराई करीं, तौ बौ अपने लत्तन से धूदर झारकै बिरोध करी और उनसे कही, तुमरो खून तुमरेई मुड़ियन मैं होबै! “अगर तुम हराए गै हौ, तौ तुमकै जाके ताहीं खुदकै दोसी माननो चाहिए! मैं जिम्मेदार ना हौं। अब से मैं गैर यहूदिन मैं जांगो।” ");
INSERT INTO thr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","जौ बजह से बौ उन्हैं छोड़ दई और तीतुस यूस्तुस नाओं के एक गैर यहूदि के घर मैं रहन लगो, जो परमेस्वर की आराधना करे करत रहै; बाको घर सभाघर के बगल मैं रहै। ");
INSERT INTO thr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","क्रिस्पुस, जो सभाघर को मुखिया रहै, अपने पूरे घरबारेन समेत प्रभु मैं बिस्वास करीं; और निरे कुरिन्थवासी भी सुनकै बिस्वास करीं और बपतिस्मा लईं। ");
INSERT INTO thr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","एक रात प्रभु दर्सन के जरिया पौलुस से कही, “मत डराबै, बल्कि बोलत रहा और हार मत मानै, ");
INSERT INTO thr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","काहैकि मैं तेरे संग हौं, और कोई भी तोकै नुकसान नाय पहुँचाए सकथै, काहैकि जौ सहर मैं मेरे भौत से आदमी हैं।” ");
INSERT INTO thr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","जौ बजह से पौलुस उनकै परमेस्वर को बचन सिखात भै डेढ़ साल ले रहो। ");
INSERT INTO thr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जब गल्लियो कै अखाया देस को राज्यपाल बनाओ गौ, तौ हुँआँ के यहूदि जुराने, और पौलुस कै पकड़ लईं और बाकै न्याय करन बारी जघा मैं लैगै। ");
INSERT INTO thr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","और बे कहीं, “जौ आदमी, लोगन कै जो नियम के खिलाप है बौ तरीका से परमेस्वर की आराधना करन के ताहीं कहथै!” ");
INSERT INTO thr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","जब पौलुस बोलन बारो रहै, तौ गल्लियो यहूदिन से कही, “अगर जौ कोई बुरे अपराध या गलत काम की बात रहै, तौ यहूदिन के संग रहनो मेरे ताहीं सई होगो। ");
INSERT INTO thr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","लेकिन अगर जौ सब्दन और नाओं और तुमरे अपने नियम के बारे मैं एक तर्क है, जहे बजह से जाकै तुमकै खुदै निपटाने होगो। मैं ऐसी चीजन को न्याय ना करनो चाहथौं!” ");
INSERT INTO thr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","और बौ उनकै न्याय करन बारी जघा से निकार दई। ");
INSERT INTO thr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तौ सब जनी सभाघर के मुखिया सोस्थिनेस कै पकड़कै न्याय करन बारी जघा के अग्गु मारीं। लेकिन गल्लियो जे बातन की कछु फिकर ना करी। ");
INSERT INTO thr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौलुस कुरिन्थ भईय्यन के संग निरे दिन ले हूँना रहो, फिर उनकै छोड़ दई और सीरिया के ताहीं प्रिस्किल्ला, और अक्विला के संग रवाना भै। किंख्रिया से नईंयाँ मैं चढ़न से पहले बौ अपनो मूड़ मुड़बाय लई रहै काहैकि बौ जो बर्त लई रहै। ");
INSERT INTO thr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","बे इफिसुस पहोंचे, जहाँ पौलुस प्रिस्किल्ला और अक्विला कै छोड़ दई। बौ सभाघर मैं जाएकै यहूदियन के संग सलाह-मसौराह करन लगो। ");
INSERT INTO thr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","लोग जब बासे लम्बे समय ताहीं रहेन कै कहीं, लेकिन बौ राजी नाय भौ। ");
INSERT INTO thr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","लेकिन जौ कहकै, बौ उनकै छोड़ दई, जैसो बौ कही, “अगर परमेस्वर की इच्छा भइ तौ मैं तुमरे झोने आंगो।” और बौ इफिसुस से रवाना भौ। ");
INSERT INTO thr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","जब बौ कैसरिया पहुँचो, तौ बौ यरूसलेम कै गौ और कलीसिया कै नमस्ते करी, और फिर अन्ताकिया मैं गौ। ");
INSERT INTO thr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","हूँना कुछ समय बितान के बाद। बौ सबै चेलन कै मजबूत करत भै, गलातिया और फ्रूगिया छेत्र से चले गौ, सबै विस्वासियन कै मजबूत करत रहो। ");
INSERT INTO thr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","बौ समय अपुल्लोस नाओं को एक यहूदि जोको जनम सिकन्दरिया मैं भौ रहै, इफिसुस मैं आओ रहै। जो एक ग्यानी आदमी रहै और पवित्र सास्त्र को अच्छो जानकार रहै। ");
INSERT INTO thr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","बाकै प्रभु के रहा को निर्देस दौ गौ रहै, और बड़े उत्साह के संग बौ ईसु के बारे मैं तथ्यन कै ढंग से बताई और सिखाई। काहैकि बौ सिरफ यूहन्ना के बपतिस्मा कै जानत रहै। ");
INSERT INTO thr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","बौ सभाघर मैं बेखौफ हुईकै बोलन लगो। जब प्रिस्किल्ला और अक्विला बाकै सुनी, तौ बे बाकै अपने संग घरै लैगै और बाकै और सई ढंग से समझाई कि परमेस्वर की रहा है। ");
INSERT INTO thr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","तौ अपुल्लोस अखाया के झोने जान को फैसला करी, जहे बजह से इफिसुस के भईय्या अखाया मैं चेलन कै लिखकै मदत करीं, उनको स्वागत करन को बड़ाबा करीं। जब बौ आओ, तौ बौ बे लोगन के ताहीं एक बड़ो मदतगार रहै, जो परमेस्वर के अनुग्रह और किरपा से बिस्वास करन बारे रहैं। ");
INSERT INTO thr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","अपने मजबूत तर्कन के संग बौ सार्वजनिक बहस मैं यहूदियन कै सास्त्रन जौ साबित कर दई कि ईसु ही मसीह है। ");
INSERT INTO thr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","जब अपुल्लोस कुरिन्थुस मैं रहै, तौ पौलुस ऊपर के सबै देस से होत भौ इफिसुस मैं पहुँचो। और हूँना कुछ चेला मिले, ");
INSERT INTO thr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","और उनसे पूँछी, “का तुम बिस्वास करन पोती पवित्र आत्मा पाए?” बे जबाब दईं, “हम तौ पवित्र आत्मा के बारे मैं सुने तक नाय हैं।” ");
INSERT INTO thr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","पौलुस पूँछी, “तौ फिर तुम कैसो बपतिस्मा लै?” बे जबाब दईं, “यूहन्ना को बपतिस्मा।” ");
INSERT INTO thr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पौलुस कही, “यूहन्ना को बपतिस्मा बे लोगन के ताहीं रहै जो अपने पापन से मुकर गै; और बौ इस्राएल के लोगन से कही कि जो मेरे बाद आनबारो है, बहै ईसु मैं बिस्वास करियो।” ");
INSERT INTO thr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","जब बे जौ सुनीं, तौ उनकै प्रभु ईसु के नाओं को बपतिस्मा दौ गौ। ");
INSERT INTO thr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","जब पौलुस उनके ऊपर हाथ धरी, तौ उनके ऊपर पवित्र आत्मा उतरी; और बे अलग-अलग जबान मैं ऐलान करीं और परमेस्वर को संदेस भी सुनाईं। ");
INSERT INTO thr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","बे सब करीबन बारह आदमी रहैं। ");
INSERT INTO thr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","पौलुस सभाघर मैं गौ और तीन महेना के दौरान लोगन के संग बेखौफ बात करी, बौ परमेस्वर के राज्य के बारे मैं बात करतो और समझान की कोसिस करत रहो। ");
INSERT INTO thr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","लेकिन उनमैं से कुछ जिद्दी रहैं और बिस्वास ना करत रहैं, पूरे समूह से बे प्रभु के रहा के बारे मैं बुरी बात कहीं। जौ बजह से पौलुस उनकै छोड़ दई और चेलन कै अपने संग लैगौ, और रोजाना बौ तुरन्नुस की स्कूल मैं बात-चीत करतो। ");
INSERT INTO thr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","जौ दुई साल ले चलो, ताकी जो लोग जो कि आसिया के देसन मैं रहेत रहै, यहूदि और गैर यहूदि दोनों प्रभु के बचन कै सुनी। ");
INSERT INTO thr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","परमेस्वर पौलुस के जरिया सामर्थ्य के अचम्मे काम करत रहै। ");
INSERT INTO thr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","हिंयाँ ले कि रुमाल और अंगोछा जो बौ पहने रहै, उनकै बिमारन के झोने लैजाओ गौ रहै, और उनकी बिमारियन कै ठीक करो गौ रहै, और प्रेत आत्मा उनसे बाहर निकर जांगी। ");
INSERT INTO thr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","बुरी सफर करन बारे और प्रेत आत्मा कै भजान बारे कुछ यहूदि ऐसो करन के ताहीं प्रभु ईसु के नाओं को उपयोग करन को भी हिम्मत करीं, बे बुरी आत्मा से कहीं, “मैं तुमकै ईसु के नाओं से आग्या देथौं, जोकै पौलुस प्रचार करथै।” ");
INSERT INTO thr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","सात भईय्या, जो स्क्किवा नाओं के एक यहूदि बड़े पुजारी के लौड़ा रहैं, जो ऐसो करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","लेकिन प्रेत आत्मा कही ईसु कै मैं जानथौं और पौलुस कै भी जानथौ, पर तुम कौन हौ? ");
INSERT INTO thr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","जो आदमी मैं प्रेत आत्मा रहै, बौ उनकै झपटी और काबू मैं करकै ऐसो परेसान करी कि बे नंगे और चोट खाएकै बौ घर से निकरकै भाजे। ");
INSERT INTO thr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","इफिसुस के रहन बारे सब यहूदि और गैर यहूदि जौ बात सुनीं; बे सबन के ऊपर डर छाए गौ, और प्रभु ईसु के नाओं की बड़ाँईं भइ। ");
INSERT INTO thr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","विस्वासिन मैं से कई, सबन के सामने स्वीकार करथैं और खुलासा करथैं कि बे का करी रहैं। ");
INSERT INTO thr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","जादू कै सिकन बारेन मैं से तमान अपनी किताबन कै एक संग लाईं और उन्हैं सबके सामने जलाए दईं। बे किताबन की कीमत कै जोड़ीं, और सब मिलाएकै पचास हजार चाँदी के सिक्का भै। ");
INSERT INTO thr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","जौ तरीका से प्रभु को बचन सामर्थ्य से फैलत गौ और मजबूत होत गौ। ");
INSERT INTO thr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जे बात होन के बाद, पौलुस मन मैं ठान लई कि मकिदुनिया और अखाया से हुईकै यरूसलेम कै जामौं। और कही, “हूँना जान के बाद मोकै रोम कै भी देखनो चाहिए।” ");
INSERT INTO thr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","इसलै बौ अपने दुई सेवा करन बारेन मैं से तीमुथियुस और एरास्तुस कै मकिदुनिया मैं भेजी, जबकी बौ आसिया के सहर मैं जाधे समय बिताई। ");
INSERT INTO thr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","जौ बौ समय रहै कि प्रभु के रहा की बजह से इफिसुस मैं गंभीर संकट रहै। ");
INSERT INTO thr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","दिमेतिरियुस नाओं को एक चाँदी को कारीगर रहै, जो अरतिमिस देवी के मंदिर चाँदी के बनाए करत रहै, जोसे कारीगरन को एक बड़ो काम चले करत रहै। ");
INSERT INTO thr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","इसलै बौ बे सबन कै दुसरेन के संग बुलाई, जिनको काम उनके जैसो रहै और उनसे कही, “आदमियौं, तुम जानथौ कि जौ काम से हमरी समृद्धि आथै। ");
INSERT INTO thr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","अब, तुम खुद देख सकथौ और सुन सकथौ कि जौ पौलुस का कहरौ है। बौ कहथै कि हाथ से बने भै देवता बिल्कुल भी देवता ना हैं, और बौ इफिसुस और आसिया के लमसम पूरे देसन मैं, कई लोगन कै समझान मैं कामयाब रहो है। ");
INSERT INTO thr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","तौ खतरा है, अब सिरफ जहे एक बात को डर नाय है कि हमरे जौ कारोबार को मान-सम्मान चले जागो बल्कि जौ महान देबी अरतिमिस को मंदिर बेकार समझो जागो और बाकी महानता खतम हुई जागी। जोकै आसिया और पूरी दुनिया पूजथै!” ");
INSERT INTO thr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","जैसी भीड़ जे सब्दन कै सुनीं, बे गुस्सा से भर गै और चिल्लान लगे, “महान तौ इफिसुस की देवी अरतिमिस है!” ");
INSERT INTO thr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","और पूरे सहर मैं हंगामा फैल गौ। भीड़ मकिदुनिया परदेस से आए पौलुस के साथी गयुस और अरिस्तर्खुस कै पकड़ लईं, और उनके संग रंगसाला मैं पहुँचे। ");
INSERT INTO thr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पौलुस खुद भीड़ के सामने जानो चहात रहै, लेकिन चेला बाकै जान ना दईं। ");
INSERT INTO thr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","कुछ आसिया के देसन के अधिकारी, जो उनके दोस्त रहैं, बे उन्हऊँ कै खबर भेजीं नहोरे करीं कि रंगसाला मैं नाय आमै। ");
INSERT INTO thr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","जौ बीच पूरी बैठक हंगामा मैं रहै: कोई कुछ चिल्लातो, दुसरो कुछ और चिल्लातो, काहैकि उनमैं से निरेन कै तौ जहो नाय पता रहैं की बे काहे ताहीं जुराने हैं। ");
INSERT INTO thr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","कुछ लोग निस्कर्स निकारीं कि सिकन्दर जिम्मेदार है, काहैकि यहूदि बाकै मोर्चा मैं जान के ताहीं बनाई रहैं। तौ सिकन्दर लोगन कै चुप रहन के ताहीं अपने हाथ से इसारा करी, और बौ बचाव के ताहीं भाँसड़ देन की कोसिस करी। ");
INSERT INTO thr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","लेकिन जब बे जानगै कि बौ यहूदि है तौ सबके सब एकै अबाज मैं करीब दुई घंटा तक चिल्लात रहे, “इफिसुस की देवी अरतिमिस, महान है!” ");
INSERT INTO thr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","आखिरकार सहर को संत्री भीड़ कै सांत करन मैं कामयाब रहो। बौ कही, “साथी इफिसियों! हर कोई जानथै कि इफिसियों सहर महान देवी अरतिमिस के मंदिर और पवित्र पथरा जो स्वर्ग से नीचे गिर गौ है बाको रक्छक है। ");
INSERT INTO thr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","कोई भी जे बातन कै नकार नाय सकथै। तौ फिर, तुमकै सांत हुई जानो चाहिए और लापरवाही कछु ना करनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","तुम जे आदमिन कै हिंयाँ लै आए हौ, जो जे मंदिर कै ना लूटी हैं और ना हमरी देवी के बारे मैं बुराई करीं हैं। ");
INSERT INTO thr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","अगर दिमेतिरियुस और बाके संग बारे कारीगरन कै कोई के खिलाप आरोप है। तौ हमरे पास अधिकारी और अदालत के नियमित दिन हैं; हुँआँ आरोप लगाए जा सकथैं। ");
INSERT INTO thr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","लेकिन अगर तुम कुछ और चाहथौ तौ जाकै नगरन की एक नियम की बैठक मैं तैं करने होगो। ");
INSERT INTO thr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","आज जो कुछ भी भौ है, बाके बाद हमरे ऊपर दंगा करन को आरोप लगाओ जागो। जौ सब हंगामा के ताहीं को बहाना ना है, और हम जाके ताहीं एक अच्छो बजह ना दै पांगे।” ");
INSERT INTO thr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","जौ कहेन के बाद, बौ बैठक कै बिदा कर दई। ");
INSERT INTO thr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","हंगामा खतम होन के बाद, पौलुस चेलन कै एक संग बुलबाए कै समझाई और उनसे बिदाई लई। फिर बौ मकिदुनिया कै चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","बौ सब परदेसन से होत भौ छिरो और लोगन कै संदेस के संग हौंसला दई। फिर बौ यूनान मैं आओ। ");
INSERT INTO thr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","जहाँ बौ तीन महेना रहो। बौ सीरिया कै जान के ताहीं तैयार होत रहै जब बाकै पता चलो कि हुँआँ तौ यहूदि बाके खिलाप साजिस रच रै हैं; जौ बजह से बौ मकिदुनिया से हुईकै बापस चले जान को फैसला करी। ");
INSERT INTO thr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरीया को रहन बारो पुरूर्स को लौड़ा सोपत्‌रुस; और थिस्सलुनीकियों को रहन बारो अरिस्तर्खुस और सिकुन्दुस; और दिरबे को गयुस; और तीमुथियुस और आसिया के देस को तुखिकुस और तुरुफिमुस; बाके संग हुई लईं। ");
INSERT INTO thr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","बे अग्गु जाएकै तरोआस मैं हमैं असियान लगे। ");
INSERT INTO thr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","और हम अखमीरी रोटी के त्योहार के बाद फिलिप्पी से रवाना भै, और पाँच दिन बाद हम उन्हैं तरोआस मैं मिले, जहाँ हम एक सप्ताह बिताए। ");
INSERT INTO thr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","सप्ताह के पहले दिन हम रोटी तोड़न के ताहीं एक संग आए। तौ पौलुस जो दुसरे दिन कै जान बारो रहै, उनसे बात करी और आधी रात तक बात करत रहो। ");
INSERT INTO thr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","जो ऊपर के कमरा मैं हम जुराने रहैं, बामै निरे दिया जलत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","यूतुखुस नाओं को एक ज्वान आदमी खिड़की मैं बैठो भौ नींद से उँघात रहै, और पौलुस जब बात करत रहै तौ बौ नींद आन से तिसरे मंजिला से गिर पड़ो, और जब बे बाकै उठाईं तौ बौ खतम हुई चुको रहै। ");
INSERT INTO thr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","लेकिन पौलुस तरे आयकै बाकै अकौरी मैं भर लई, और कही, “फिकर मत करौ; बौ अभऊ जिंदो है!” ");
INSERT INTO thr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","फिरौंकी बौ ऊपर जाएकै, रोटी तोड़ी, और खाएकै। इत्ती देर तक उनसे बात करत रहो कि भुकभुको हुई गौ; फिर बौ चले गौ। ");
INSERT INTO thr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","और बे बौ ज्वान आदमी कै जिंदो घरै लैगै, और भौत सांति पाई। ");
INSERT INTO thr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","हम पहले से जहाज मैं चढ़कै अस्सुस के झोने जौ सोचकै रवाना भै, कि हूँना से हम पौलुस कै चढ़ाय लेमैं। बौ हमसे ऐसिये करन ताहीं कही रहै, काहैकि अपना पैदल जात रहै। ");
INSERT INTO thr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जब बासे हमरो अस्सुस मैं भेंटा भौ तौ हम बाकै जहाज मैं चढ़ायकै और मितुलेने मैं चले गै। ");
INSERT INTO thr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","हम हूँना से रवाना भै और अगले दिन खियुस पहुँचे। और एक दिन बाद हम सामुस पहुँचे, फिर दुसरे दिन हम मीलेतुस मैं पहुँचे। ");
INSERT INTO thr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पौलुस इफिसुस के झोने से हुईकै जान को फैसला करी रहै, कि कहूँ ऐसो न होबै, कि बाकै आसिया मैं देर लगै। बौ जल्दी मैं रहै, कि अगर हुई सकै, तौ बौ पिन्तेकुस्त के दिन ले यरूसलेम मैं रहबै। ");
INSERT INTO thr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","पौलुस मीलेतुस से इफिसुस मैं खबर भेजी, जोमैं कलीसिया के बड़े-बूढ़े से मिलन के ताहीं कही। ");
INSERT INTO thr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जब बे बाके झोने आए, तौ बौ उनसे कही, “तुम जानथौ कि मैं पहलिये दिन से जब मैं आसिया मैं पुगो, मैं तुमरे संग हर समय कैसे रहो। ");
INSERT INTO thr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","मैं पूरी नमरता से और आँसु बहाए-बहाएकै, और बे इम्तिहान मैं जो यहूदियन की साजिस के बजह से जो समय मेरे ऊपर आओ, प्रभु के सेवक के रूप मैं मैं अपनो काम करो। ");
INSERT INTO thr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","तुम जानथौ कि जो-जो बात तुमरे फायदा की रहैं उनकै सबन कै बतान से और घर-घर प्रचार करन से मैं कहु संकोच ना करो। ");
INSERT INTO thr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यहूदि और गैर यहूदिन कै एक हानी चितौनी देत रहौं कि परमेस्वर के घाँईं मन फिराबौ, और हमरे प्रभु ईसु मसीह मैं बिस्वास करौ। ");
INSERT INTO thr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","और अब, मैं पवित्र आत्मा के कहेन मैं यरूसलेम कै जाएरौ हौं, ना जानै हूँना मेरे संग का होगो। ");
INSERT INTO thr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","मैं सिरफ इतनो जानथौं कि पवित्र आत्मा हर सहर मैं मोकै चितौनी दई है कि कैदखाना की साँकर और मुसीबतैं मेरो इंतजार कर रइ हैं। ");
INSERT INTO thr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","लेकिन मैं अपनी खुद की जिंदगी के ताहीं मेरो कुछ भी प्रिय ना है; मैं सिरफ अपने काम कै पूरो करनो चाहथौं और बौ सेवा पूरो करनो चाहथौं जो प्रभु ईसु मोकै चितौनी के जरिया करन के ताहीं दई रहै, जो कि परमेस्वर के अनुग्रह और किरपा के बारे मैं सुसमाचार की घोसड़ाँ करनो है।” ");
INSERT INTO thr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","मैं तुमरे सबन के बीच मैं परमेस्वर के राज्य को प्रचार सुनात फिरो हौं। और अब मोकै पता है कि तुम मैं से कोई भी मोकै फिर ना देख पागे। ");
INSERT INTO thr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","जौ बजह से मैं पूरी तरह से तुमकै आज के दिन ऐलान करथौं: अगर तुम मैं से कोई भी भटक जाबै, तौ मैं बाके खून से निर्दोस हौं। ");
INSERT INTO thr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","काहैकि मैं तुमकै परमेस्वर के पूरे उद्देस्य की घोसड़ाँ करन से नाय झिझको। ");
INSERT INTO thr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","तभईये अपनी और पूरे झुंड की देखा-भारी करौ; जोमैं पवित्र आत्मा तुमकै अगुवा ठहराई है कि तुम परमेस्वर की कलीसिया की रखबारी करौ, जो बौ अपने खून के जरिये अपनो बनाई। ");
INSERT INTO thr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मैं जानथौं, कि मेरे जान के बाद फाड़न बारे भेंड़िया तुमरे बीच मैं आंगे, और बे झुंड कै नाय छोड़ंगे। ");
INSERT INTO thr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","बौ समय आगो जब तुमरे खुद के झुंड के आदमी चेलन कै अपने पच्छू लान ताहीं झूठ कहमंगे। ");
INSERT INTO thr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","देखौ, और याद करौ कि मैं तीन साल तक आँसु बहाए-बहाएकै, रात-दिन हर एक कै सिक्छा देनो नाय छोड़ो। ");
INSERT INTO thr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“और अब मैं तुमकै परमेस्वर की दया को बचन सौंप देथौं; जो तुमकै बढ़ाए सकथै, और परमेस्वर तुम्हैं बे सब आदमिन कै पवित्र करथै। ");
INSERT INTO thr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मोकै कोई को चाँदी या सोनो या लत्ता नाय चाहिए रहै। ");
INSERT INTO thr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुम खुदै जानथौ कि जहे हाथ मेरो और मेरे संग बारेन की जरूरतन कै पूरो करी। ");
INSERT INTO thr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मैं तुमकै सब कछु करकै दिखाओ, कि जौ तरीका से मेहनत करकै कमजोरन की मदत करैं, और प्रभु ईसु की बातन कै याद धरनो जरूरी है, जो बौ खुद कही रहै: ‘लेन से जाधे देन मैं खुसी मिलथै।’” ");
INSERT INTO thr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","जब पौलुस कहनो बंद करी, तौ बौ उनके संग घूँटे टेक कै प्रार्थना करी। ");
INSERT INTO thr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तौ बे सब रोन लगे और पौलुस के गले से लग कै बाकै चूमी और पनार दईं। ");
INSERT INTO thr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","बे खासकर कै जौ बात को दुखी रहैं कि बौ कही रहै, कि तुम फिर कहु मोकै नाय देखैगे। जौ बजह से बे बाकै जहाज ले पुगान गै। ");
INSERT INTO thr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","हम उनसे न्यारे हुईकै रवाना भै। सीधे रहा से कोस मैं आए; दुसरे दिन रूदुस मैं, और हूँना से पतरा मैं। ");
INSERT INTO thr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","और एक जहाज फीनीके कै जात भै मिलो, तभई हम बाके ऊपर चढ़कै चले गै। ");
INSERT INTO thr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जब साइप्रस दिखाई दई, तौ हम बाकै उल्टा छोड़कै, सीरिया कै चलकै सूर मैं उतरे। काहैकि हूँना जहाज को समान उतारने रहै। ");
INSERT INTO thr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","हम हूँना कुछ चेलन से मिले और उनके संग सात दिन ले रहे। बे आत्मा के सिखे भै पौलुस से कहीं कि यरूसलेम मैं मत जईये। ");
INSERT INTO thr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","लेकिन जब उनके संग हमरो समय खतम हुई गौ, तौ हम हूँना से अपनी रहामैं नेंग दै। और बे सब बईंय्यरन और बालकन समेत, हमैं नगर के दुआरे तक छोड़न आए और हम समुंदर टिकारे घुपटियाय कै प्रार्थना करे। ");
INSERT INTO thr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तौ एक दुसरे से बिदाई लैकै, हम जहाज मैं चढ़ गै, और बे अपने-अपने घर लौट गै। ");
INSERT INTO thr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","फिरौंकी हम लगातार सफर करकै सूर से पतुलिमयिस मैं पुगे, और भईय्यन कै नमस्ते करकै उनके संग एक दिन ठहरे। ");
INSERT INTO thr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दुसरे दिन हम हूँना से नेंग कै कैसरिया मैं आए, और फिलिप्पुस प्रचारक के घर मैं जो सातन मैं से एक जोकै यरूसलेम मैं सहायकन के रूप मैं चुनो गौ रहै, जाएकै बाके हींना रहे। ");
INSERT INTO thr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","बाकी चार कुवाँरी लौड़िया रहैं; जो परमेस्वर के संदेसो को ऐलान करीं। ");
INSERT INTO thr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जब हम हूँना कुछ दिन रह लै, तौ यहूदिया से अगबुस नाओं को एक भविस्यवक्ता आओ। ");
INSERT INTO thr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","बौ हमरे झोने आए कै पौलुस की कमरबंद लई, और अपने हाथ पायें भाँदकै कही, “पवित्र आत्मा जौ कहथै: कि जो आदमी कि जौ कमरबंद है, बाकै यरूसलेम मैं यहूदि ऐसिये भाँदंगे, और गैर यहूदिन के हाथ मैं दै देंगे।” ");
INSERT INTO thr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जब हम जे बात सुने, तौ हम और हूँना के आदमी बासे नहोरे करे, कि यरूसलेम कै मत जाबै। ");
INSERT INTO thr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","लेकिन पौलुस जबाब दई, “तुम का कर रहै हौ, कि तुम ऐसे रोए रहे हौ, और मेरो मन तोड़ रहै हौ? मैं तौ प्रभु ईसु के नाओं के ताहीं यरूसलेम मैं ना सिरफ बंधन ताहीं बल्किन मरनौ ताहीं तैयार हौं।” ");
INSERT INTO thr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जब बौ नाय मानो तौ हम जौ कहकै चुप हुईगै, “कि प्रभु की मरजी पूरी होबै।” ");
INSERT INTO thr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","हूँना कुछ समय बितान के बाद हम अपनी चीजैं तैयारी करे और यरूसलेम कै चल दै। ");
INSERT INTO thr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया के भी कुछ चेला हमरे संग हुई लईं, और मनासोन नाओं के साइप्रस के एक पुराने चेला कै संग लै आए, कि हम बाके घरै रुकैं। ");
INSERT INTO thr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जब हम यरूसलेम मैं पुगे, तौ हूँना के भईय्या बड़ा खुसी से हमरो स्वागत करीं। ");
INSERT INTO thr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दुसरे दिन पौलुस हमैं लैकै याकूब के झोने गौ: जितै कलीसिया के सब बड़े-बूढ़े जुरे रहैं। ");
INSERT INTO thr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तौ बौ उनकै नमस्ते करकै, जो-जो काम परमेस्वर बाकी सेवकाई के जरिया गैर यहूदि मैं करी रहै, एक-एक करकै सब बताई। ");
INSERT INTO thr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","जौ सुनकै बे परमेस्वर की बड़ाँईं करीं और बे कहीं, “भईय्या पौलुस, तैं तौ देखो कि यहूदिन मैं हजारौ आदमी हैं, जो बे बिस्वास करीं हैं। और सब नियमन के ताहीं जोसीले हैं। ");
INSERT INTO thr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","और उनकै तेरे बारे मैं बताओ गौ है कि तैं गैर यहूदिन के बीच मैं रहन बारे यहूदिन कै जौ सिखाथै कि मूसा कि सिक्छा कै छोड़ दिऔ और कहथै, कि न तौ बालकन को खतना करौ और नाय पुरानी रीतियन के हिसाब से चलौ। ");
INSERT INTO thr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","तौ फिर का करो जाबै? बे तौ जरूर सुनंगे कि तैं हींना आओ है। ");
INSERT INTO thr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","तभईये जो हम तोसे कहथैं, बौ कर। हमरे हींना चार आदमी हैं, जो बर्त रखी रहैं। ");
INSERT INTO thr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","उनकै संग लैजाय कै उनसे अपने आपकै सुद्ध कर; और उनको खर्चा दे, कि बे मूड़ मुड़बाय लेमैं। तौ सब जान जांगे, कि जो बात उनकै तेरे बारे मैं बताईं हैं, बे सच नाय हैं बल्कि तैं खुदै मूसा के नियम कै मानत भै चलथै। ");
INSERT INTO thr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","लेकिन बे गैर यहूदिन के बारे मैं जो बिस्वास करीं हैं, हम जौ फैसला करकै लिखकै पनारे हैं कि बे मूर्तिन के अग्गु चढ़ाय भै मास से, और खून से, और घेंट अमेठे भैन के मास से, और छिनरइपना से, बचे रहाबौ।” ");
INSERT INTO thr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","तौ पौलुस बे आदमिन कै लैकै, और दुसरे दिन उनके संग सुद्ध हुईकै मंदिर मैं गौ, और हूँना बताये दई, सुद्ध होन के दिन, मतलब उनमैं से सबन के ताहीं चढ़ावा चढ़ाय जान के दिन कब पूरे होंगे। ");
INSERT INTO thr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जब सात दिन पूरे होन बारे रहैं, तौ आसिया के कुछ यहूदि लोग पौलुस कै मंदिर मैं देखकै सब आदमिन कै भड़काईं। और ऐसे चिल्लाए-चिल्लाए कै बाकै पकड़ लईं, ");
INSERT INTO thr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","बे लोग चिल्लाईं। “इस्राएल के लोगौ!” मदत करौ! “जौ बहे आदमी है, जो सब जघा इस्राएल के लोगन मैं, मूसा को नियमन और जौ मंदिर के खिलाप हर कोई कै पढ़ाथै। हींना तक कि बौ यूनानिन कै भी मंदिर मैं लाए कै जौ पवित्र जघा कै अपवित्र कर दई है!” ");
INSERT INTO thr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","काहैकि जासे अग्गु बे तुरुफिमुस नाओं के इफिसुस कै बाके संग नगर मैं देखी रहैं, और जौ समझीं कि पौलुस बाकै मंदिर मैं लाई है। ");
INSERT INTO thr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तौ पूरे सहर मैं कोहराम मच गौ, और लोग दौड़कै जुराए गै, और पौलुस कै पकड़कै मंदिर के दुआरे घसीटत लाईं, और तुरंतै फाटक बन्द कर दईं। ");
INSERT INTO thr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जब बे बाकै मार डारनो चहात रहैं, तौ सिपईय्यन के सरदार के झोने खबर पुगी कि पूरे यरूसलेम मैं कोहराम मच गौ है। ");
INSERT INTO thr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","एक सिपईय्या कुछ सुबेदारन कै लैकै भीड़ के झोने पुग गौ। जब लोग बाकै सैनिकन के संग देखी, तौ बे पौलुस कै पीटनो बन्द कर दईं। ");
INSERT INTO thr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","सरदार झोने आयकै पौलुस कै पकड़ लई, और दुई जंजीर से भाँदन को आदेस दई। फिरौंकी बौ पूँछन लागो, “जौ आदमी कौन है, और बौ का करी है?” ");
INSERT INTO thr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","लेकिन भीड़ मैं से कोई कछु और कोई कछु चिल्लात रहे और जब हुलगदड़ के बजह से सई सच ना जान सको, तौ पौलुस कै किला मैं लै जान को हुकम दई। ");
INSERT INTO thr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जब बौ सिड़ी मैं पुगो, तौ ऐसो भौ कि भीड़ के दाब की बजह से सिपईय्यन कै बाकै उठाएकै लै जान पड़ो। ");
INSERT INTO thr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","लोगन की भीड़ जौ चिल्लात भै बाके पच्छू पड़ी, “बाकै खतम कर दिऔ!” ");
INSERT INTO thr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जब सिपईय्या पौलुस कै किला मैं लै जान बारे रहैं, बौ सेना के सरदार से कही: “का मोकै इजाजत है कि मैं तोसे कछु कहमौं?” बौ पूँछी, का तैं यूनानी भासा जानथै? ");
INSERT INTO thr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“का तैं बौ मिस्री नाय है, जो जेईं दिनन से अग्गु क्रांति सुरू करकै रेगिस्तान मैं चार हजार हथियारबन्द आतंकबादी लोगन कै लैगौ रहै?” ");
INSERT INTO thr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुस जबाब दई, “मैं तौ तरसुस को यहूदि इंसान हौं किलिकिया के जाने-माने नगर को निवासी हौं। और मैं तोसे बिनती करथौं, कि मोकै लोगन से बात करन दे।” ");
INSERT INTO thr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","सेनापति बाकै हुकम दई, तौ पौलुस सिड़ी मैं ठाड़कै लोगन कै चुप रहन कै ताहीं अपने हात से इसारा करी। जब बे चुप हुईगै, तौ पौलुस इब्रानी भासा मैं उनसे बात करी: ");
INSERT INTO thr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“मेरे यहूदिया देस के दोस्तौ, मेरी बात सुनौ काहैकि मैं तुमरे सामने अपनो बचाव करथौं!” ");
INSERT INTO thr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","बे जौ सुनकै कि बौ उनसे इब्रानी भासा मैं बोल रहो है, बे सांत ही गै; तभई पौलुस ऐसे कहकै चले गौ: ");
INSERT INTO thr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“मैं तौ यहूदि हौं, किलिकिया के तरसुस मैं पैदा भौ, लेकिन यरूसलेम मैं गमलीएल के छात्‌र के भेस मैं आओ। और मोकै बड़े-बूढ़ेन के नियम मैं सक्त हिदायत मिली रहै और परमेस्वर के ताहीं ऐसी धुन लगाओ रहौं जैसी तुम सब आज लगाए हौ। ");
INSERT INTO thr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मैं जौ रहामैं चलन बारे लोगन कै मौत के घाट उतारो। मैं ही लोग और बईंय्यरन कै पकड़ौ और कैदखाना मैं डारो। ");
INSERT INTO thr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","खुद बड़े पुजारी और पूरी पंचायत गभा हैं कि मैं सई कर रहो हौं। मोए उनसे दमिस्क मैं यहूदिन के दोस्तन की लिखी भई चिट्ठी मिली, जहेमारे मैं जे लोगन कै पकड़न ताहीं साँकर मैं भाँदकै सजा देन के ताहीं यरूसलेम गौ।” ");
INSERT INTO thr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“जब मैं सफर करकै दमिस्क के झोने पहोंचो, तौ ऐसो भौ कि दुपारी मैं अनकाचीति से एक बड़ो उजियारो आसमान से मेरे चारौ घाँईं चमको। ");
INSERT INTO thr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","और मैं जमीन मैं गिर गौ और मोकै एक अबाज सुनाई दई, ‘साऊल, साऊल! तैं मोकै काहे सताथै?’ ");
INSERT INTO thr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मैं पूँछो, ‘तैं कौन है प्रभु? मैं नासरत को ईसु हौं, जोकै तू सताथै,’ बौ मोसे कही। ");
INSERT INTO thr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","और मेरे संग बारे उजियारो तौ देखीं, लेकिन जो मोसे बोलत रहै बाकी अबाज नाय सुनी। ");
INSERT INTO thr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","मैं पूँछो, ‘प्रभु, मैं का करौं?’ प्रभु मोसे कही, ‘उठ और दमिस्क मैं जा, और हूँना तोकै बौ सब कुछ बताए दौ जागो जो परमेस्वर तोए करन ताहीं ठहराई है।’ ");
INSERT INTO thr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जब मैं तेज चमक के बजह से अंधरा हुई गौ, तभई मेरे संग बारे मेरो हात पकड़कै दमिस्क मैं लै आईं।” ");
INSERT INTO thr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“बहे सहर मैं हनन्याह नाओं को एक भलो आदमी रहै, जो हमरे नियम को पालन करत रहै और हूँना के रहन बारे यहूदियन को भौत आदर करत रहै। ");
INSERT INTO thr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","बौ मेरे झोने आयकै, मेरे झोने ठाड़गौ, और मोसे कही, ‘भईय्या साऊल, फिर से देख!’ बहे घड़ी मेरी आँखी खुली और मैं बाकै देखो। ");
INSERT INTO thr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तौ बौ कही, हमरे पुरखा को परमेस्वर तोकै जहेमारे चुनी है कि तैं बाकी मरजी कै जानैं, और बौ धर्मी कै देखै, और बाके मोहों की बात सुनै। ");
INSERT INTO thr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","काहैकि तैं बाके घाँईं से सब आदमिन के अग्गु बे बातन को गभा होगो, जो तैं देखो और सुनो है। ");
INSERT INTO thr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","और अब, का को आसरो करथै? उठ बपतिस्मा ले, और बाको नाओं लैकै अपने पापन कै धोय डार।” ");
INSERT INTO thr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“मैं यरूसलेम मैं बापस गौ, और जब मैं मंदिर मैं प्रार्थना करत रहौं, तौ मोए एक दर्सन मिलो, ");
INSERT INTO thr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","जोमैं मैं प्रभु कै देखो, जैसो कि बौ मोसे कही रहै, ‘जल्दिये यरूसलेम से निकर जा; काहैकि बे मेरे बारे मैं तेरी गभाई नाय मानंगे।’ ");
INSERT INTO thr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मैं कहो, ‘प्रभु, बे तौ अच्छी तरह से जानथैं कि मैं तेरे ऊपर बिस्वास करन बारेन कै कालकोठरी मैं डारत रहौं और जघा-जघा सभाघर मैं पिटवात रहौं। ");
INSERT INTO thr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","और जब तेरो गभा स्तिफनुस को खून बहाओ गौ, तौ मैं खुद हूँनै रहौं, और बाकी हत्या की मंजूरी होत रहै तौ बाके हत्यारेन के लत्तन को ध्यान धरत रहौं।’ ");
INSERT INTO thr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","तौ प्रभु मोसे कही, ‘जा,’ काहैकि मैं तोकै गैर यहूदि मैं दूर पनारंगो।” ");
INSERT INTO thr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","लोग पौलुस की बात सुनी जबले जौ बात न सुनी; फिरौंकी बे तेज अबाज मैं चिल्लान लागे, “बासे दूर रहाबौ! जाए मार देबौ! जाकै धरती से मिटाए दियौ, जौ जिंदो रहन के लायक नाय है!” ");
INSERT INTO thr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","बे चिल्लात रहैं, और अपने लत्ता लहरात रहैं और ब्यार मैं धूदर उड़ात रहैं। ");
INSERT INTO thr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","तौ रोमी सेना को सरदार अपने आदमिन संग पौलुस कै किला मैं लै जान को आदेस दई, और जाकै कोड़ा मारकै उन्हैं परखौ, कि लोग का बजह से बाके खिलाप मैं चिल्लाए रहे हैं। ");
INSERT INTO thr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","जब बे बाकै कोड़ा मारन के ताहीं भाँद दईं, तौ पौलुस हूँना ठाड़े अधिकारी से कही, “का तेरे ताहीं रोमी वासी कै कोड़ा मारनो सई है, और बौ भी बिना दोस को?” ");
INSERT INTO thr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","तभई सेनापति पौलुस के झोने गौ और बासे पूँछी, “मोकै बता, का तैं रोमी वासी है?” ");
INSERT INTO thr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तभई सेना को सरदार बाके झोने आयकै कही, “मोकै बता, का तैं रोमी है?” “हाँ,” पौलुस जबाब दई। ");
INSERT INTO thr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","जौ सुनकै सेनापति कही, “मैं रोमी होन को पद भौत रुपईया दैकै पाओ हौं।” पौलुस कही, “लेकिन मैं तौ जनम से रोमी हौं।” ");
INSERT INTO thr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तौ जो आदमी बाकी जाँच करन बारे रहैं, बे तुरंतै बाके झोने से हट गै; और सेनापति भी जौ जानकै कि पौलुस रोमी वासी है, और बौ बाकै साँकरन से भाँदी है, डराय गौ। ");
INSERT INTO thr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","सेनापति जौ मालुम करनो चहात रहै कि यहूदि पौलुस के ऊपर का आरोप लगात रहैं; तभई दुसरे दिन पौलुस की साँकर खोल दई और मुख्य बड़े पुजारी और पूरे पंचन कै मिलन को आदेस दई। और फिर पौलुस कै लै जाएकै उनके सामने ठड़बाए दईं। ");
INSERT INTO thr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुस सीधे बड़ी सभा के घाँईं देखी और कही, “मेरे संगी इस्राएलियौ! मैं आज तक परमेस्वर के ताहीं कतई सच्चे मन से और अच्छे से जिंदगी गुजारो हौं।” ");
INSERT INTO thr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","हनन्याह बड़ो पुजारी बे लोगन कै आदेस दई, जो मोहों मैं हमला करन के ताहीं पौलुस के झोने ठाड़े रहैं। ");
INSERT INTO thr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तौ पौलुस बासे कही, “चूना पुति भइ दीवार, परमेस्वर पक्का तेरे ऊपर हमला करैगो! तैं नियम के हिसाब से मेरो फैसला करन ताहीं बैठो है, फिर काहे नियम के खिलाप मोकै मारन ताहीं कहरौ है!” ");
INSERT INTO thr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","पौलुस के करीबी लोग बासे कहीं, “तैं परमेस्वर के बड़े पुजारी को अपमान कर रौ है!” ");
INSERT INTO thr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुस जबाब दई, “मेरे इस्राएल के संगी, मैं नाय जानत रहौं, कि बौ बड़ो पुजारी रहै। सास्त्र कहथै, ‘अपने लोगन के मुखिया की बुराई ना करनो चाहिए।’ ");
INSERT INTO thr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तौ पौलुस जौ जानकै, कि एक गुट सदूकियन को और दुसरो फरीसियन को है, महासभा मैं चिल्लाए कै कही, संगी इस्राएलियौ! मैं फरीसी और फरीसियन के पीढ़ी को हौं, मरे भैन की आसा और दुबारा जी उठन के बारे मैं मेरो फैसला हुई रहौ है!” ");
INSERT INTO thr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","जैसिये बौ जौ कही, तौ फरीसी और सदूकियन मैं लड़ाई होन लागी; और सभा मैं फूट पड़ गई। ");
INSERT INTO thr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","सदूकी तौ जौ कहथैं, कि न कोई पुनरुत्थान होथै, और नाय स्वर्गदूत होथैं और नाय आत्मा होथै; लेकिन फरीसी इन सब मै बिस्वास करथैं। ");
INSERT INTO thr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तौ बड़ा हल्ला मचो और कुछ यहूदि नियम के सिक्छक जो फरीसिन के गुट के रहैं, उठकै जोरदार बिरोध करीं: “हम जौ आदमी मैं कछु बुरो ना पाये! सायद एक आत्मा या स्वर्गदूत सच मैं बासे बोली है!” ");
INSERT INTO thr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जब भौत लड़ाई भइ, तौ सेना को सरदार जौ डर से कि बे पौलुस के टुकड़ा-टुकड़ा न कर डारैं, सेना के दल कै आदेस दई कि उतरकै बाकै उनके बीच मैं से जबरजत्ती निकारौ, और किला मैं लैजाओ। ");
INSERT INTO thr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","बहे रात प्रभु पौलुस कै ठड़बाए कै कही, “हिम्मत भाँद! काहैकि जैसी तैं यरूसलेम मैं गभाई दौ, बैसिये तोकै रोम मैं भी गभाई देने होगो।” ");
INSERT INTO thr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","अगले सुबेरे कुछ यहूदि मिलकै योजना बनाईं। और कसम खाईं कि जबले हम पौलुस कै खतम न कर डारैं, तौले खामैं या पीमंगे नाय। ");
INSERT INTO thr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जो जौ योजना बनाईं रहैं, बे चालीस आदमी से जद्धा रहैं। ");
INSERT INTO thr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","बे बड़ो पुजारी और बड़े-बूढ़ेन के झोने आयकै कहीं, “हम एक पवित्र कसम खाए हैं कि हम पौलुस कै खतम न कर डारैं, तौले कछु भी ना खामैं, ना पीमैं। ");
INSERT INTO thr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","तभईये अब सभा समेत सेना के सरदार कै समझाबौ, कि बाकै तुमरे झोने लै आबै, समझ लियो कि तुम बाके बारे मैं और भी सई से जाँच करनो चाहथौ। और हम बाके पुगन से अग्गु बाकै मार डारन के ताहीं तैयार रहंगे।” ");
INSERT INTO thr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","तौ पौलुस की बहेनिया को लौड़ा सुनी कि बे बाकी घात मैं हैं; तौ किला मैं जाएकै पौलुस कै खबर दई। ");
INSERT INTO thr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पौलुस कप्तानन कै अपने झोने बुलाएकै कही, “जौ ज्वान आदमी कै सेना के सरदार के झोने लै जाबौ, जौ बासे कछु कहनो चाहथै।” ");
INSERT INTO thr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","तभई अधिकारी बाकै सेना के सरदार के झोने लै जाएकै कही, “कैदी पौलुस मोकै बुलाएकै नहोरे करी, कि जौ ज्वान आदमी सेना के सरदार से कछु कहनो चाहथै; जाकै बाके झोने लै जा।” ");
INSERT INTO thr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","सेना को सरदार बाको हाथ पकड़कै, और बाकै अलग लै जाएकै पूँछी, “तू मोसे का कहनो चाहथै?” ");
INSERT INTO thr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","बौ कही, यहूदि अधिकारी तोसे जौ नहोरे करन के ताहीं एक मत ही गै हैं कि तू कल पौलुस कै बड़ी सभा के अग्गु लाबै, कि मानौ बे बाकी और भी जाधा जानकारी लेनो चाहथैं। ");
INSERT INTO thr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","लेकिन तू उनकी मत सुनिये, काहैकि उनमैं से चालीस से जाधा आदमी बाकी घात मैं हैं, बे जौ ठान लईं हैं कि जबले बे पौलुस कै खतम ना कर लेमैं, तब तक ना खांगे ना पींगे, और अब बे तैयार हैं और तेरे कहेन कै असियाय रहै हैं। ");
INSERT INTO thr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","तौ सेना को सरदार ज्वान आदमी कै जौ संकेत दैकै बिदाई करी, “कोईये से मत कहिये कि तैं मोकै जे बात बताओ है।” ");
INSERT INTO thr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तभई सेनापति अपने दुई सरदारन कै बुलाएकै कही, “दुई सौ सिपईय्या, सत्तर घुड़सवार कै और दुई सौ सैनिक कैसरिया जान ताहीं तैयार रख, तैं आज रात नौ बजे ले निकर जान के ताहीं समरो रहिये। ");
INSERT INTO thr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","और पौलुस की सवारी के ताहीं घोड़ा तैयार रखौ और बाकै फेलिक्स राज्यपाल के झोने सबसे बचाए कै सई सलामत पुगाए दियौ।” ");
INSERT INTO thr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","तौ सेनापति एक चिट्ठी लिखी जो ऐसे करकै रहै: ");
INSERT INTO thr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“महाप्रतापी, फेलिक्स लिसियास: राज्यपाल कै क्लौदियुस को नमस्ते। ");
INSERT INTO thr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","जौ आदमी कै यहूदि लोग पकड़कै मार डारनों चाँहीं, मोकै पता चलो कि बौ रोमी नागरिक है, तौ सिपईय्यन कै लै जाएकै छुड़बाए लाओ। ");
INSERT INTO thr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","और मैं जाननो चहात रहौं, कि बे बाके ऊपर कौनसी बजह से दोस लगाथैं, तभईये बाकै उनकी बड़ी सभा मैं लैगौ। ");
INSERT INTO thr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","तभई मैं जान लौ, कि बे खुदै अपने नियम के झमेला मैं बाके ऊपर दोस लगाथैं, लेकिन बाकै मार डारन हानी या भाँदे जाने जैसो कोईये दोस नाय है। ");
INSERT INTO thr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","और जब मोकै बताओ गौ, कि बे जौ आदमी की घात मैं लगे हैं, तौ मैं तुरंतै बाकै तेरे झोने पनारन को फैसला करो। और दोस लगान बारेन कै भी हुकम दौ, कि, तेरे अग्गु बाके ऊपर दोस लगामैं।” ");
INSERT INTO thr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","तभई जैसे सिपईय्यन कै हुकम दौ गौ। बैसिये पौलुस कै लैकै रातौ-रात अंतिपतरिस मैं लाईं। ");
INSERT INTO thr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दुसरे दिन सैनिक घुड़सवारन कै बाके संग जान के ताहीं छोड़कै बे किला मैं लौट आए। ");
INSERT INTO thr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","बे कैसरिया मैं पुगकै राज्यपाल कै चिट्ठी दईं, और पौलुस कै बाके हवाले कर दईं। ");
INSERT INTO thr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","गवर्नर चिट्ठी पढ़कै पौलुस से पूँछी, तैं कौन परदेस को है। जब बे जान लई कि किलिकिया को है, ");
INSERT INTO thr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","बौ कही, “जब तेरे इल्जाम लगान बारे आंगे, तभई मैं तेरो फैसला करंगो।” तौ बौ पौलुस कै हेरोद गवर्नर के महल मैं रखबारी करन को हुकम दई। ");
INSERT INTO thr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाँच दिन बाद हनन्याह बड़ो पुजारी कुछ बड़े-बूढ़े और तिरतुल्लुस नाओं के एक वकील के संग कैसरिया गै। बे राज्यपाल के अग्गु पौलुस के ऊपर इल्जाम लगाईं। ");
INSERT INTO thr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","तौ पौलुस बुलाओ गौ, और तिरतुल्लुस बाके ऊपर इल्जाम लगाएकै कहेन लगो, जो ऐसे करकै है: “महामहिम! तेरे बुद्धिमान नेतृत्व हमैं सांति लंबे समय दई है, और हमरी जाति की भलाई के ताहीं कई जरूरी सुधार करे जाए रै हैं। ");
INSERT INTO thr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","हम हर जघा और हर समय फेलिक्स स्वागत करथैं, और हम तेरे प्रति भौत आभारी हैं। ");
INSERT INTO thr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","अब मैं तेरो और जाधा समय खराब नाय करकै, तोसे दयालु होन और हमरे दुई बोल सुनन के ताहीं नहोरे करथौं। ");
INSERT INTO thr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","हम जौ आदमी कै खतरनाक उधम्मी पाए; जौ दुनिया भर मैं यहूदिन के बीच दंगा की सुरुवात करथै और नासरियन के झुंड को नेता है। ");
INSERT INTO thr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","जौ मंदिर कै अपवित्र करन की भी कोसिस करी, और हम जाकै गिरफ्तार कर लै। ");
INSERT INTO thr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","लेकिन सेना को सरदार लूसियास आयकै बाकै जबरजत्ती हमरे हात से छीन लई। ");
INSERT INTO thr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","अगर तैं जौ आदमी के ऊपर सवाल उठाथै, जे सब बातन कै जिनके बारे मैं हम जाके ऊपर इल्जाम लगाथैं, तैं खुदै बाके बारे मैं पता करकै जान लेगो।” ");
INSERT INTO thr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदि भी आरोप मैं सामिल हुईगै और कहीं कि जौ सब सच रहै। ");
INSERT INTO thr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","राज्यपाल पौलुस कै बोलन को मौका दई, और पौलुस कही, “मोकै पता है कि तैं भौत सालन से जौ जाति को न्यायधीस रहो है, और जौ बजह से मैं तेरे सामने अपनो बचाव करन के ताहीं खुस हौं। ");
INSERT INTO thr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तैं खुदै जान सकथै, कि जब से मैं यरूसलेम मैं आराधना करन आओ हौं, मोकै बारह दिन से जद्धा नाय भै हैं। ");
INSERT INTO thr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","यहूदि मोकै ना तौ मंदिर मैं ना सभाघरन मैं और ना तौ सहर मैं बहस करत भइ पाईं, और ना ही भीड़ लगात भै पाईं। ");
INSERT INTO thr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ना बे तोकै बे आरोपन को सबूत दे सकथैं जो बे मेरे खिलाप कहथैं। ");
INSERT INTO thr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","जौ मैं तेरे अग्गु मानथौं: मैं अपने पुर्खन के परमेस्वर की आराधना बौ तरीका से करथौं जो बे कहथैं कि जौ गलत है। लेकिन मैं मूसा के नियम और भविस्यवक्तन की किताबन मैं लिखी हर बातन के ऊपर बिस्वास करथौं। ");
INSERT INTO thr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","परमेस्वर से मेरी जहे आसा है कि जे खुदै, मतलब, गैरविस्वासी, धर्मी और अधर्मी दोनों, मौत से जी उठंगे। ");
INSERT INTO thr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","और जौ बजह से मैं हमेसा परमेस्वर और लोगन के सामने साफ मन रखन की पूरी कोसिस करथौं।” ");
INSERT INTO thr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“निरे सालन तक यरूसलेम से दूर रहन के बाद, मैं अपने लोगन के ताहीं दान पुगान और भेंट चढ़ान आओ रहौं। ");
INSERT INTO thr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","जब मैं ऐसो करत रहौं, तौ बे मोकै मंदिर मैं, सुद्ध करन बारी रसम पूरी होन के बाद देखीं। मेरे संग कोई भीड़ ना रहै और ना कैसियो गड़बड़ी रहै। ");
INSERT INTO thr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","लेकिन आसिया के देस के कुछ यहूदि हुँआँ रहैं; अगर बे मेरे खिलाप कुछ भी करथैं, तौ बे खुद तेरे सामने आयकै मेरे ऊपर आरोप लगाथैं। ");
INSERT INTO thr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","या जे खुदै कहमैं, कि जब मैं महासभा के अग्गु ठाड़ो रहों, तौ बे मेरे मैं कौन सो अपराध को दोसी पाईं रहैं। ");
INSERT INTO thr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","एक बात कै छोड़कै जोमैं उनके बीच मैं ठाड़कै चिल्लाए कै कहो रहों: जौ पुनरुत्थान के बारे मैं आज मेरो तुमरे अग्गु फैसला ही रहो है।” ");
INSERT INTO thr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","तौ फेलिक्स, जोकै रहा के बारे मैं अच्छी जानकारी रहै, बौ सुनवाई रोक कै कही, “जब सेनापति लिसियास आए जागो, तौ मैं तुमरे मुकदमा को फैसला सुनांगो।” ");
INSERT INTO thr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","और प्रभारी अधिकारी से कही, कि पौलुस कै पूरी छूट दैकै रखबारी करन कै कहिये, और बाके संग बारेन मैं से कोई कै भी बाकी सेबा करन से मत रोकिये। ");
INSERT INTO thr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","थोड़ी दिनन के बाद फेलिक्स अपनी बईय्यर द्रुसिल्ला कै, जो यहूदि रहै, संग लैकै आओ और पौलुस कै बुलबाए कै बौ ईसु मसीह के बिस्वास के बारे मैं बासे सुनी। ");
INSERT INTO thr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","लेकिन जैसे-जैसे पौलुस धार्मिकता, संयम और आनबारे न्याय की बात करन लागो, तौ फेलिक्स डराय गौ और कही, “हबै तैं जा। मौका मिलैगो तौ मैं तोकै फिर बुलांगो।” ");
INSERT INTO thr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","बहे समय बौ उमीद करत रहै कि पौलुस बाकै थोड़ी भौत पैसा देगो; और जौ बजह से बौ जद्धेतर बुलाए-बुलाएकै बासे बात करत रहै। ");
INSERT INTO thr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","दुई साल बीत जान के बाद, पुरकियुस फेस्तुस, फेलिक्स की जघा मैं राज्यपाल बनकै आओ। फेलिक्स यहूदियन ऊपर दया देन के इरादा से पौलुस कै कैदखाना मैं छोड़ गौ। ");
INSERT INTO thr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्तुस बौ देस मैं पुगकै तीन दिन के बाद कैसरिया से यरूसलेम कै गौ, ");
INSERT INTO thr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","जहाँ बड़ो पुजारी और यहूदि नेता पौलुस के खिलाप अपने आरोप लगाईं। बे फेस्तुस से नहोरे करीं ");
INSERT INTO thr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","कि पौलुस के यरूसलेम मैं आन को दया उनके ऊपर करो जाबै, काहैकि बे रास्तै मैं बाकै खतम करन ताहीं घात लगाए भै रहैं। ");
INSERT INTO thr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुस जबाब दई, “पौलुस कैसरिया मैं कैदी है, और मैं खुद जल्दी हूँना जांगो। ");
INSERT INTO thr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","अपने नेतन कै मेरे संग कैसरिया भेजौ और बौ आदमी के ऊपर इल्जाम लगाबौ।” ");
INSERT INTO thr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","फेस्तुस उनके झोने लमसम आठ-दस दिन रहकै कैसरिया गौ। और दुसरे दिन न्याय करन बारी जघा मैं बैठगौ और पौलुस कै लान को आदेस दई। ");
INSERT INTO thr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जब पौलुस आओ, तौ जो यहूदि यरूसलेम से रहैं, बे आस-पास ठाड़कै बाके ऊपर निरे इल्जाम लगामैं, जिनकै बे साबित ना कर पात रहैं। ");
INSERT INTO thr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","लेकिन पौलुस खुद को बचाव करी: “मैं यहूदिन के नियम या मंदिर या रोमन सम्राट के खिलाप कछु गलत ना करो हौं।” ");
INSERT INTO thr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","लेकिन फेस्तुस यहूदिन ऊपर दया करनो चहात रहै तौ पौलुस से पूँछी, “का तैं चाहथै कि मैं जे दोस लगान बारेन को फैसला यरूसलेम मैं करौं?” ");
INSERT INTO thr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पौलुस कही, “मैं सम्राट कैसर के न्याय करन बारी जघा के अग्गु ठाड़ो हौं, मेरे मुकदमा को फैसला हीनैं होनो चहाईये। जैसे तैं अच्छी तरहन से जानथै, यहूदिन को मैं कछु अन्याय नाय करो। ");
INSERT INTO thr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","अगर मैं कानून तोड़ो हौं और कछु करो हौं, तौ जाके ताहीं मैं मौत की सजा के लायक हौं, और मैं जासे बचन के ताहीं ना कहथौं। लेकिन जो बातन को जे मेरे ऊपर इल्जाम लगाथैं, अगर उनमैं से कोईये की बात एक सी नाय बैठी, तौ कोई मोकै उनके हात मैं नाय सौंप सकथै। मैं सम्राट कैसर से अपील करथौं।” ");
INSERT INTO thr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तौ फेस्तुस अपने सलाहकारन के संग बैठक करन के बाद जबाब दई, “तैं सम्राट कैसर से अपील करो है, जौ बजह से तैं सम्राट कैसर के झोने जागो।” ");
INSERT INTO thr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कुछ समय बाद राजा अग्रिप्पा और बिरनीके कैसरिया मैं आयकै फेस्तुस से भेंटा करीं। ");
INSERT INTO thr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","उनके निरे दिन हुँआँ रहन के बाद, फेस्तुस पौलुस के बारे मैं राजा कै समझाई: “हिंयाँ एक आदमी है, जोकै फेलिक्स कैदी छोड़ दई रहै; ");
INSERT INTO thr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","और जब मैं यरूसलेम मैं रहौं, तौ बड़ो पुजारी और यहूदि और बड़े-बूढ़े बाके खिलाप आरोप लगाईं और मोकै बाकी बुराई करन के ताहीं कहीं। ");
INSERT INTO thr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","लेकिन मैं उनसे कहो कि जौ रोमियन को रिवाज नाय है, कि कोई भी आदमी कै सजा देन के ताहीं सौंप देबै, जब तक मुजरिम कै इल्जाम लगान बारेन के अग्गु ठड़बाए कै खुद के बचाव मैं जबाब देन को मौका ना मिलै। ");
INSERT INTO thr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","जब बे हिंयाँ आए, तौ, मैं कुछ देरा दारी नाय करो, बल्किन दुसरे दिन न्याय करन बारी जघा मैं बैठकै बौ आदमी कै लान ताहीं कहो। ");
INSERT INTO thr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जब बाके बिरोधी खड़े भै, तौ बे बाके ऊपर कोई भी बुरो अपराध को इल्जाम ना लगाईं, जैसो मोकै लगत रहै कि बे कहंगे। ");
INSERT INTO thr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","लेकिन बे खुद के तर्क, और ईसु नाओं के कोई इंसान के बारे मैं जो मर चुको रहै; और पौलुस बाकै जिंदो होन को दाबा करत रहै, बहस करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","मैं ऐसी उलझन मैं रहौं, कि जे बातन को पता कैसे लगामौं? जौ बजह से मैं पौलुस से पूँछो का तैं यरूसलेम जान ताहीं तैयार होगो जहाँ हुँआँ जे बातन को फैसला करो जागो। ");
INSERT INTO thr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","लेकिन पौलुस अपील करी; कि मेरो मुकदमा को फैसला सम्राट के हिंयाँ होबै। जौ बजह से बाकै सम्राट कैसर के झोने भेजन को आदेस दौ, जब तक मैं बाकै सम्राट के झोने ना भेज दियौं तब तक बाकी रखबारी करी जाबै।” ");
INSERT INTO thr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","अग्रिप्पा फेस्तुस से कही, “महुँ बौ इंसान की सुननो चाहथौं। फेस्तुस जबाब दई, तैं कल सुन लेगो।” ");
INSERT INTO thr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","दुसरे दिन अग्रिप्पा और बिरनीके भौत धूमधाम से आयकै सेना के सरदारन और सहर के खास आदमिन के संग दरबार मैं अंदर आओ। फेस्तुस आदेस दई, कि पौलुस कै अंदर लामैं। ");
INSERT INTO thr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुस कही, “राजा अग्रिप्पा, और सब आदमी जो हिंयाँ हमरे संग हौ: तुम जौ आदमी कै देखथौ, जोके खिलाप पूरे यहूदि लोग, यरूसलेम मैं और हींनौं चिल्लाए-चिल्लाए कै मेरे झोने सिकायत लाई हैं। कि जाको जिंदो रहनो ठीक नाय है। ");
INSERT INTO thr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","लेकिन मैं जान लौ कि बौ ऐसो कुछ नाय करी कि बाकै मार डारो जाबै। और जब कि बौ खुदै सम्राट से एक अपील करी, तौ मैं बाकै पनारन को फैसला करो। ");
INSERT INTO thr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","लेकिन मैं बाके बारे मैं कोईये ऐसी बात नाय पाओ कि सम्राट कै लिखौं। जौ बजह से मैं बाकै तुमरे सामने और खासकर कै राजा अग्रिप्पा तेरे अग्गु लाओ हौं! जाके अलावा, बाके मामले कि जाँच-पड़ताल के बाद, मेरे पास कछु लिखन ताहीं हुई सकथै। ");
INSERT INTO thr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","जाके ताहीं मोकै साफ तरीका से बाके खिलाप आरोपन कै संकेत दै बिना एक कैदी कै भेजनो सई ना लगथै।” ");
INSERT INTO thr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्रिप्पा पौलुस से कही, “तोकै खुद के बचाओ मैं बोलन की अनुमति है।” तौ पौलुस अपनो हाथ बढ़ाई और अपनो बचाव ऐसे करकै करी: ");
INSERT INTO thr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“राजा अग्रिप्पा! जित्ती बातन को यहूदि मेरे ऊपर इल्जाम लगाथैं, आज तेरे अग्गु उनकै जबाब देन मैं खुदकै भाग्यसाली मानथौं, ");
INSERT INTO thr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","खासकर जब से तैं सबै यहूदि रीति-रिवाज और बहेस कै अच्छी तरह से जानथै। मैं तोसे धीरज के संग मेरी बात सुनन के ताहीं कहथौं।” ");
INSERT INTO thr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“सब यहूदि जानथैं कि जब मैं छोटो रहौं तौ मैं कैसो रहत रहौं। बे जानथैं कि मैं अपनी पूरी जिंदगी कैसे बिताओ, पहले अपने देस मैं और फिर यरूसलेम मैं। ");
INSERT INTO thr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","बे हमेसा से मोकै पहचानथैं अगर बे गभाई देनो चाहथैं, कि मैं पहले से हमरे धर्म, फरीसियन के सबसे सक्त समूह को सदस्य रह चुको हौं। ");
INSERT INTO thr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","और अब बौ वादा की आसा के बजह से जो परमेस्वर हमरे बड़े-बूढ़ेन से करी रहैं की आज मेरो फैसला ही रौ है। ");
INSERT INTO thr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","बहे वादा के पूरे होन की आसा करत भै, हमरे बारह जनजाति अपने पूरे मन से रात-दिन परमेस्वर की आराधना करथैं। हे राजा, जहे की बजे से यहूदि मेरे ऊपर दोस लगाए रै हैं! ");
INSERT INTO thr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","तुम हिंयाँ काहे हौ, जौ बिस्वास करनो नामुमकिन है कि न्याई परमेस्वर मरे भै कै जिंदो करथै?” ");
INSERT INTO thr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“महुँ सोचो रहों कि ईसु नासरी के नाओं के खिलाप मोकै भौत कुछ करनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","जहे मैं यरूसलेम मैं करो। मैं बड़ो पुजारी से अधिकार लैकै परमेस्वर के निरे पवित्र आदमिन कै कैदखाना मैं डार दौ; और जब उन्हैं मौत की सजा सुनाई गई, तौ महुँ उनके खिलाप बोट डारो। ");
INSERT INTO thr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","तमान बार मैं उन्हैं सभाघर मैं सजा देत रहौं और मैं उनकै प्रभु की बुराई करन के ताहीं मजबूर करन की कोसिस करत रहौं। मैं उनसे इतनो भड़को भौ रहौं की मैं बाहर के सहरन मैं भी जाएकै उन्हैं सतात रहों।” ");
INSERT INTO thr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“जौ सब जौ उद्देस्य के ताहीं रहै कि मैं बड़े पुजारिन से अधिकार और आदेस लैकै दमिस्क गौ। ");
INSERT INTO thr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","तौ राजा, रस्ता मैं दुपारी के समय आसमान से सूरज की तुलना से उजियारो, अपने और अपने संग बारेन के चारौ तरफ चमकत भै देखो। ");
INSERT INTO thr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","और जब हम सब जमीन मैं गिर पड़े, तौ मैं इब्रानी भासा मैं, मोसे कहत भै जौ अबाज सुनो, ‘साऊल, साऊल, तैं मोकै काहे सताथै? पैंना मैं लात मारनो तेरे ताहीं मुस्किल है।’ ");
INSERT INTO thr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","मैं कहो, ‘प्रभु, तैं कौन है?’ प्रभु कही, ‘मैं ईसु हौं, जोकै तैं सताथै। ");
INSERT INTO thr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","लेकिन तैं उठ, अपनी टाँग के बल ठाड़ जा; काहैकि मैं तोकै जहे ताहीं दर्सन दौ हौं कि तोकै बे बातन को भी सेवक और गभा ठहरामौ, जो तैं देखो है, और उनको भी जोमैं तोकै दर्सन दिखांगो। ");
INSERT INTO thr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","मैं तोकै इस्राएलियन और गैर यहूदियन के हात से छुड़ांगो जिनके झोने मैं तोकै पनारंगो। ");
INSERT INTO thr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","कि तैं उनकी आँखी खोलै, कि बे अंधियारे से उजियारे के घाँईं, और सैतान के अधिकार से परमेस्वर के घाँईं लौटैं; कि पापन की माफी, और बे लोगन के संग जो मेरे ऊपर बिस्वास करन से पवित्र करे गै हैं, बिस्वास पामैं।’ ");
INSERT INTO thr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","तभईये राजा अग्रिप्पा, मैं बौ स्वर्गिय दर्सन की बात नाय टालो, ");
INSERT INTO thr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","लेकिन पहले दमिस्क के, फिर यरूसलेम के रहन बारेन कै, फिर यहूदिया के पूरे देस मैं और गैर यहूदियन कै समझात रहो, कि मन फिराबौ और परमेस्वर के घाँईं लौटकै मन फिरन के जैसे काम करौ। ");
INSERT INTO thr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","जेईं बातन के बजह से यहूदि मोकै मंदिर मैं पकड़कै मार डारन की कोसिस करत रहैं। ");
INSERT INTO thr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","लेकिन परमेस्वर की मदद से हबै ले बनो हौं और छोटे-बड़े सबन के अग्गु गभाई देथौं, और बे बातन के अलावा कुछ ना कहथौं, जो भविस्यवक्ता और मूसा भी कही, कि होन बारी हैं, ");
INSERT INTO thr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","कि मसीह कै दुख उठाने होगो, और बहे सबसे अग्गु मरे भैन मैं से जी उठकै हमरे लोगन मैं और गैर यहूदियन मैं जोती को प्रचार करैगो।” ");
INSERT INTO thr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जब बौ जौ तरह से जबाब देत रहै, तौ फेस्तुस तेज अबाज से कही, “पौलुस तैं पागल है। भौत विद्या तोकै पागल कर दई है।” ");
INSERT INTO thr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","लेकिन पौलुस कही, महाप्रतापी फेस्तुस, “मैं पागल नाय हौं, लेकिन सच्ची और सिक्छा की बात करथौं।” ");
INSERT INTO thr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","“राजा भी जोके अग्गु मैं बिना डरे बोल रौ हौं, जे बात जानथै, और मोकै बिस्वास है, कि जे बातन मैं से कोई बासे लुकी नाय है, काहैकि बौ बात कोई कोहने मैं नाय भइ है। ");
INSERT INTO thr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","राजा अग्रिप्पा, का तैं भविस्यवक्तन मैं बिस्वास करथै? हाँ, मैं जानथौं, कि तैं बिस्वास करथै।” ");
INSERT INTO thr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","अब अग्रिप्पा पौलुस से कही, “का तैं जरा सो समझाए कै मोकै मसीह बनानो चाहथै?” ");
INSERT INTO thr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुस कही, “परमेस्वर से मेरी प्रार्थना जौ है कि जरा से मैं, का भौत मैं, सिरफ तहीं नाय, लेकिन जितने लोग आज मेरी सुनथैं, मेरे जे बेड़ियन कै छोड़कै बे मेरे जैसी हुई जामैं।” ");
INSERT INTO thr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तौ राजा और राज्यपाल और बिरनीके और उनके संग बैठन बारे ठाड़गै; ");
INSERT INTO thr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","और अलग जाएकै आपसै मैं कहेन लागे, “जौ आदमी ऐसो तौ कछु ना करथै, जो मौत की सजा या कैदखाना के बंधन मैं डारो जाबै।” ");
INSERT INTO thr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पा फेस्तुस से कही, “अगर जौ आदमी कैसर की अपील न देतो, तौ छुट सकत रहै।” ");
INSERT INTO thr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जब जौ उनको पक्को फैसला ही गौ कि हम इटली जामैं, तौ बे पौलुस और थोड़ी और कैदियन कै भी यूलियुस नाओं के औगुस्तुस की सेना के एक कप्तान कै सौंप दई, जो रोमन सेना-दल को एक अधिकारी रहै, जिनकै “सम्राट को सेना-दल कहो जाथै।” ");
INSERT INTO thr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","हम आसिया परदेस के बन्दरगाहन कै जान बारे अद्रमुत्तियुम नगर के एक जहाज मैं सवार हुईकै रवाना हुईगै। मकिदुनिया देस के थिस्सलुनीके नगर को रहन बारो अरिस्तर्खुस नाओं को एक विस्वासी भी हमरे संग रहै। ");
INSERT INTO thr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दुसरे दिन हम सैदा पुगे। यूलियुस पौलुस के ऊपर दया करकै बाकै अपने दोस्तन के झोने जान को हुकम दई, जोकी उनकै जरूरत रहै। ");
INSERT INTO thr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","हूँना से हम साइप्रस द्वीप की आड़ मैं हुईकै अग्गु बढ़े काहैकि ब्यार हमरे खिलाप रहे। ");
INSERT INTO thr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","और किलिकिया और पंफूलिया के समुंदर पार करकै लूसिया मैं मायरा आए। ");
INSERT INTO thr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","हूँना कप्तान कै सिकन्दरिया को एक जहाज मिलो जो इटली के ताहीं जान बारो रहै, तभईये बौ हमैं बहे मैं चढ़ाय दई। ");
INSERT INTO thr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","हम भौत दिन तक धीरे-धीरे नेंग कै मुस्किल से कनिदुस सहर पुगे। तौ जहेमारे कि ब्यार हमैं अग्गु न बढ़न देत रहे, हम सलमोने के अग्गु से हुईकै क्रेते द्वीप की आड़ मैं नीचे मोहोंकै निंगे। ");
INSERT INTO thr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","और बाके टिकारे-टिकारे मुस्किल से नेंगत भै सुभलंगरबारी नाओं की एक जघा मैं पुगे, जितै से लसया नगर झोने रहे। ");
INSERT INTO thr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","हम हूँना भौत समय गुजारे, जबले कि सफर जारी रखनो खतरनाक ना हुई गौ, काहैकि अबले बर्त को दिन पहलेई बीत चुको रहै। तभई पौलुस उनकै जौ सलाह दई: ");
INSERT INTO thr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“भईय्यौ, मोकै ऐसो लग रहो है कि जौ सफर मैं परेसानी और भौत नुकसान, खाली समान और जहाज को नाय बल्कि आपन की ज्यान को भी है।” ");
INSERT INTO thr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","लेकिन कप्तान और जहाज के मालिक की बातन कै पौलुस की बातन से जद्धा मानी। ");
INSERT INTO thr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","बन्दरगाह जाड़ो काटन ताहीं अच्छो ना रहे; जहेमारे लमसम सबै लोग समुंदर से बहार निकरन और फीनिक्स मैं पुगन की कोसिस करत रहैं, अगर हुई सकै, तौ सर्दियन कै बीतन के ताहीं। फीनिक्स क्रेते को एक बन्दरगाह है जो तरिहाँए-पछार और सीरे-पछार को सामना करथै। ");
INSERT INTO thr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जब तरिहाँए की ब्यार धीरे-धीरे चलन लागी, तौ आदमी सोचीं कि उनकै अपनी योजना कै पुरो कर सकथैं, तभईये लंगर उठाईं और टिकारे-टिकारे क्रेते के झोने से होत भै जान लगे। ");
INSERT INTO thr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","लेकिन जल्दिये एक भौत तेज ब्यार उठी, जोकै “यूरकुलीन” कहथैं, द्वीप से नीचे गिरन लगी। ");
INSERT INTO thr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जब आँधी जहाज से टकराई, तौ जहाज ब्यार के अग्गु रुक न पाओ, तौ हम जहाज कै ब्यार के संग पुहिन दै, और कोसिस करनो छोड़ दै। ");
INSERT INTO thr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तौ कौदा नाओं के एक छोटे से टापू की आड़ मैं हमैं कुछ आसरो मिलो। हूँना, कुछ मुस्किल के संग हम जहाज की छोटी नईंयाँ कै सई सलामत बनान मैं कामयाब रहे। ");
INSERT INTO thr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","फिर जहाज चलान बारे डोंगी कै उठाईं और जहाज कै रस्सन से तरे से ऊपर तक कसकै भाँदी और सुरतिस टापू के उथले जघा मैं फसन के डर से पाल और समान कै उतारकै ब्यार से पुहात भै चले गै। ");
INSERT INTO thr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","भयानक आँधी चलतै रइ, तभई दुसरे दिन बे कुछ समान जो जाधे रहै फेंकन लागे, ");
INSERT INTO thr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","और तीसरे दिन कै बे जहाज को समान भी फेंक दईं। ");
INSERT INTO thr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","और जब भौत दिनन तक नाय सूरज नाय तारा दिखाई दै, और भौत आँधी चलत रहे। तौ आखरी मैं हमरे बचन की सब आसा जान लगी। ");
INSERT INTO thr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जब बे भौत दिन तक भूंके रह डारीं, तौ पौलुस उनके बीच मैं ठाड़कै कही, “लोगौ, ठीक तौ जौ रहे की तुम मेरी बात मानकै, क्रेते से जौ जहाज नाय खोलते; नाय जौ परेसानी आती और नाय जौ नुकसान उठाने पड़तो। ");
INSERT INTO thr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","लेकिन अब मैं तुमकै समझाथौं कि हिम्मत भाँदौ! काहैकि तुम मैं से कोई की ज्यान कै नुकसान न होगो; बस खाली जहाज कै। ");
INSERT INTO thr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","काहैकि जो परमेस्वर को मैं हौं और जोकी सेवा करथौं बाको स्वर्गदूत आज रात मेरे झोने आयकै ");
INSERT INTO thr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","और कही पौलुस, मत डराय! तोकै कैसर के अग्गु ठाड़ने जरूर है। और देख, परमेस्वर सबन कै जो तेरे संग सफर कर रहे हैं, तोकै सौंपी है। ");
INSERT INTO thr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","तभईये, भईय्यौ! हिम्मत भाँदौ; काहैकि मैं परमेस्वर मैं बिस्वास रखथौं, कि जैसो मोसे कही है, बैसिये होगो। ");
INSERT INTO thr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","लेकिन हमैं कोई टीला मैं आसरो मिलैगो।” ");
INSERT INTO thr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जब चौदहमीं रात भइ, और हम अद्रिया समुंदर मैं भटकत रहैं, तौ आधी रात के करीब मल्लाह अन्दाजे से जानी की हम कोई देस के झोने पुग रहे हैं। ");
INSERT INTO thr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","जब थाह लईं तौ पानी एक सौ बीस फिट गहरो पाईं; और थोड़ी अग्गु बढ़कै फिर थाह लईं, तौ नब्बै फिट गहरो पाईं। ");
INSERT INTO thr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तौ पथरा बारी जघा मैं टकरान की डर से बे जहाज के पच्छू चार लंगर डारीं, और भोर होन के ताहीं प्रार्थना करत रहै। ");
INSERT INTO thr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","तौ मल्लाह नईंयाँ से भाजन की कोसिस करत रहैं; और अग्गु बारे हिस्सा से लंगर डारन के बहाना से ढोंगा कै समुंदर मैं उतार दईं। ");
INSERT INTO thr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","लेकिन पौलुस कप्तान और सिपईय्यन से कही, “अगर जे आदमी जहाज मैं न रहैं, तौ तुम भी न बच सकथौ।” ");
INSERT INTO thr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तौ सिपईय्या रस्सी कै काटकै छोटी नईंयाँ कै जान दईं। ");
INSERT INTO thr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जब भोर होन बारो रहे, तौ पौलुस जौ कहकै सबन कै खानु खान ताहीं नहोरे करी: “आज के चौदह दिन हुईगै हैं कि तुम आसरो देखत-देखत भूंके रहे, और कछु न खाए। ");
INSERT INTO thr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","जहे ताहीं मैं तुमसे नहोरे करथौं कि कछु खाए लियौ, जोसे तुमरी ज्यान बच जाए; काहैकि तुमरे मूड़ से एक बार भी न गिरैगो।” ");
INSERT INTO thr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","और जौ कहकै बौ रोटी लैकै सबन के अग्गु परमेस्वर को धन्यवाद करी और खान लागो। ");
INSERT INTO thr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","जासे सबन कै हिम्मत मिली और बे भी खानु खाईं। ");
INSERT INTO thr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","हम सब मिलाय कै जहाज के भीतर दुई सौ छियत्तर जनी बैठे रहैं। ");
INSERT INTO thr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जब बे खानु खाएकै तृप्त भै, तौ गेंहूँ कै समुंदर मैं फेंक कै जहाज कै हलको करन लगे। ");
INSERT INTO thr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जब दिन निकरो, तौ बे बौ देस कै नाय पहचानी, लेकिन एक खाड़ी देखीं जोको बरोबर किनारो रहे, और सोची कि अगर हुई सकै तौ हीनैं पर जहाज टिकेमैं। ");
INSERT INTO thr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तौ बे लंगरन कै खोलकै समुंदर मैं डार दईं और बहे समय पतवारन कै पकड़नबारी रस्सी खोल दईं और ब्यार के अग्गु बारो पाल चढ़ायकै डींड़े घाँईं निगैं। ");
INSERT INTO thr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","लेकिन दुई समुंदर के मिलन की जघा पड़कै बे जहाज कै टिकाईं, और लंगर तौ झटका खाएकै अंद गौ, और हाल ना सको; लेकिन पच्छू जहाज लहरन की बजह से टूटन लगो। ");
INSERT INTO thr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तौ सिपईय्या जौ सोची की कैदियन कै मार डारैं; ऐसो न होबै कि कोई पैर कै भाज जाबै। ");
INSERT INTO thr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","लेकिन कप्तान पौलुस कै बचान के बिचार से रोकी, और जौ कही, कि जो पैर लेथैं, पहले कूदकै डींड़े कै निकर जामैं; ");
INSERT INTO thr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","और बचे भै कोई पटरन मैं, और कोई जहाज की और दुसरी चीजन के मदद से निकर डींड़े कै निकर जामैं, और जौ तरीका से सब कोई बच निकरे। ");
INSERT INTO thr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जब हम सई सलामत बच निकरे, तौ पता चलो कि जौ टापू कै माल्टा कहथैं। ");
INSERT INTO thr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","और हुँआँ के परदेसी हमसे अच्छे ढंग से पेस आए। मेंहें बरसन लगो और ठंड रहै, तभई बे आगी पजार कै हम सबन को आदर करीं। ");
INSERT INTO thr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जब पौलुस कठिया को गट्ठा इखट्टो करी और बाकै आगी मैं डारत रहे तौ एक साँप आँच लगन के बजह से बाहर आओ और बौ बाके हात मैं लिपट गौ। ");
INSERT INTO thr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जब हुँआँ के परदेसी साँप कै बाके हात मैं लिपटो भौ देखी तौ आपस मैं कहीं, “सच्ची मैं जौ आदमी खूनी है, लेकिन जाको भाग्य जाकै जिंदो रहेन नाय देगो, भले बौ समुंदर के जोखिम से बच निकरो है।” ");
INSERT INTO thr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","तौ पौलुस साँप कै बिना नुकसान पहुँचाए आगी मैं झटक दई। ");
INSERT INTO thr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","लेकिन बे असियात रहैं कि बौ सूज जागो, या अनकाचीति गिरकै मर जागो, लेकिन जब बे भौत देर तक देखत रहे और देखीं कि बाको कछु भी नाय भौ, तौ बे अपने मन कै बदल दईं और कहीं, “जौ तौ कोई प्रभु है!” ");
INSERT INTO thr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","बौ जघा से बड़ा दूर कुछ खेत रहैं जो दीप के प्रमुख पुब्लियुस नाओं के आदमी के रहैं बे हमरो स्वागत करीं और तीन दिन तक हम उनके हितुआ रहैं। ");
INSERT INTO thr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुब्लियुस को दऊवा तेज बुखार और पेंचिस से बिमार पड़ो रहे। पौलुस कमरा मैं गौ, प्रार्थना करी, बाके ऊपर हात धरी और बाकै अच्छो करी। ");
INSERT INTO thr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","जब ऐसो भौ, तौ बौ टापू के और भी दुसरे बिमार पहुँचे और बे भी अच्छे ही गै। ");
INSERT INTO thr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","बे हमकै भौत उपहार दई, और जब हम नेंगन लागे, तौ जो कछु हमरे ताहीं जरूरी रहे, जहाज मैं धर दईं। ");
INSERT INTO thr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","तीन महेना के बाद हम “जुड़वा देवता” कहे जान बारे सिकन्दरिया के एक जहाज मैं रवाना भै, जो बौ टापू मैं ठंड को समय बिताई रहै। ");
INSERT INTO thr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","हम सुरकूसा सहर मैं पहोंचे और हूँना तीन दिन रहे। ");
INSERT INTO thr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","हूँना से हम रवाना भै और रेगियुम सहर पहुँचे। अगले दिन तरिहाँए की ब्यार चलनो सुरु भई तौ दुई दिन मैं हम पुतियुली सहर मैं आए। ");
INSERT INTO thr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","हूँना हमकै कुछ विस्वासी भईय्या मिले जो हमसे एक सप्ताह संग रहेन के ताहीं नहोरे करीं। और जहेमारे हम रोम मैं आए। ");
INSERT INTO thr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","रोम के विस्वासी भईय्या हमरे बारे मैं सुनी और हमसे भेंटा के ताहीं अप्पियुस के चौहराय और तीन सराय लै आए। जब पौलुस उनकै देखी, तौ परमेस्वर कै धन्यवाद दई और बड़ा बढ़ावा दई। ");
INSERT INTO thr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जब हम रोम मैं पुगे, तौ पौलुस कै एक सिपईय्या के संग जो बाकी रखबारी करत रहै, खुदै रहेन को आदेस मिलो। ");
INSERT INTO thr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीन दिन के बाद बौ हुँआँ के रहेन बारे यहूदिन के नेतन कै एक बैठक मैं बुलाई। जब बे जुराए, तौ उनसे कही, “मेरे संग के इस्राएलियो, भले मैं अपने लोगन कै या बड़े-बूढ़ेन के रीति-रिवाज के खिलाप मैं कुछ भी नाय करो, मोकै यरूसलेम मैं कैदी बनाए दौ गौ और रोमियों के हात सौंप दौ गौ। ");
INSERT INTO thr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","मोसे सवाल करन के बाद रोमियों मोकै छोड़नो चाँहीं, काहैकि बे पाई मैं कछु नाय करो, जोके ताहीं मैं मरन के लायक रहौ। ");
INSERT INTO thr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","लेकिन जब यहूदि जाको बिरोध करीं, तौ मोकै कैसर से अपील करन के ताहीं बेबस होन पड़ो, भले मोकै अपने लोगन के खिलाप बनान को कोई आरोप नाय रहे। ");
INSERT INTO thr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","जहेमारे मैं तुमकै देखो और तुमसे बातचीत करन के ताहीं कहो। बास्तव मैं, मैं बाके ताहीं जौ तरहन से जंजीर मैं बंधो भौ हौ, जोके ताहीं इस्राएल के लोग आसा करथैं।” ");
INSERT INTO thr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","बे बासे कहीं, “हम तेरे बारे मैं यहूदियन से कोई चिट्ठी नाय पाए हैं, और ना हमरे कोई आदमिन के झोने तुमरे बारे मैं कहेन के ताहीं कोई खबर या कोई बुरी बात है। ");
INSERT INTO thr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","लेकिन हम तुमरे बिचारन कै सुननो चाहमंगे, काहैकि हम जानथै कि सब जघा लोग जौ दल के खिलाप बोलथैं जोसे तुम बंधे भै हौ।” ");
INSERT INTO thr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तौ बे पौलुस के ताहीं एक तारीक छाँटी, और बौ दिन बड़ी संख्या मैं लोग बौ जघा मैं आए जहाँ पौलुस रहेत रहै। भोर से लैकै रात तक बौ उनकै परमेस्वर के राज्य के बारे मैं अपनो संदेस समझाई, बौ मूसा के नियम और भविस्यवक्तन की किताबन से उनकै ईसु के बारे समझान की कोसिस करी। ");
INSERT INTO thr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","उनमैं से कुछ लोग पौलुस की बाकी बातन कै मान लईं, लेकिन कुछ लोग अविस्वासी बने रहे। ");
INSERT INTO thr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","काहैकि पौलुस जब उनसे जौ बात कही तौ बे आपस मैं असहमत हीकै चले गै: “पवित्र आत्मा यसायाह भविस्यवक्ता के जरिये तुमरे बुजर्गन से कितने अच्छे से बात करी रहै! ");
INSERT INTO thr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","काहैकि बे कहीं, ‘जाबौ और जे लोगन से कहबौ: तुम सुनैगे और सुनैगे, लेकिन समझ मैं नाय आगो; तुम देखौ और देखौ, लेकिन नाय देखैगे, ");
INSERT INTO thr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","काहैकि जे लोगन को दिमाक सुस्त है, और बे अपने कान बन्द कर लईं और बे अपनी आँखी मूंद लईं। नाय तौ उनकी आँखी देख लेमंगी, उनके कान सुनंगे, उनको दिमाक समझ जाबैगो, और बे मोसे कहमंगे, प्रभु कहथै, और मैं उनकै अच्छो कर दुंगो।’” ");
INSERT INTO thr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","और पौलुस बाको मतलब निकारी: “तुम जौ जाननो चाहथौ कि, परमेस्वर के उद्धार को संदेस गैर यहूदियन कै भेजो गौ है। बे सुनंगे!” ");
INSERT INTO thr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जब बौ जौ कही तौ यहूदि आपस मैं गजब विवाद करन लगे और हुँआँ से चले गै। ");
INSERT INTO thr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","पौलुस पूरे दुई साल अपने किराय के घर मैं रहो, और हुँआँ बौ बे सबन को स्वागत करी जो बासे मिलन आए रहैं। ");
INSERT INTO thr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","बौ परमेस्वर के राज्य के बारे मैं प्रचार करी और प्रभु ईसु मसीह के बारे मैं सिखाई, जो बेझिजक और आजादी के संग बोलत रहै।");
INSERT INTO thr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","पौलुस के घाँईं से जो ईसु मसीह को सेवक है, और प्रेरित होन के ताहीं मस्काओ गौ, और परमेस्वर के बौ सुसमाचार के ताहीं अलग करो गौ है। ");
INSERT INTO thr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","सुसमाचार की प्रतिग्या भौत पहले परमेस्वर अपने भविस्यवक्तन के जरिये करी रहै, जैसो कि पवित्र सास्त्र मैं लिखो है। ");
INSERT INTO thr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","अपनेई लौड़ा हमरे प्रभु ईसु मसीह के बारे मैं वादा करी है बौ सरीर से तौ राजा दाऊद की पीढ़ी से भौ है। ");
INSERT INTO thr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","और पवित्रता की आत्मा से भरकै मरे भौ से, जिंदो होन की बजह से सामर्थ्य के संग परमेस्वर को लौड़ा प्रभु ईसु मसीह ठहरो है। ");
INSERT INTO thr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","बहे की बजह से हमकै दया और प्रेरिताई मिली की बाके नाओं से सबै जाति के लोग बिस्वास करकै बाकी मानैं, ");
INSERT INTO thr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","जित्ते हैं उन्हऊँ मैं से तुम्हऊँ ईसु मसीह के होन के ताहीं बुलाए गै हौ। ");
INSERT INTO thr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","बे सबन के जो रोम देस मैं परमेस्वर के प्रिय हैं और पवित्र होन के ताहीं मस्काए गै हैं: आपन के परम दऊवा परमेस्वर और प्रभु ईसु मसीह के घाँईं से तुमकै दया और सांति मिलत रहबै। ");
INSERT INTO thr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","सबसे पहले मैं तुम सबन के ताहीं ईसु मसीह के घाँईं से अपने परमेस्वर कै धन्यवाद करथौं, काहैकि तुमरे बिस्वास की बात पूरी दुनिया मैं हुई रइ है। ");
INSERT INTO thr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","परमेस्वर जो की सेवा मैं अपनी आत्मा से बाके लौड़ा के सुसमाचार के बारे मैं कहथौं, बहे मेरो गभा है कि मैं तुमकै कैसे करकै हमेसा याद करत रहथौं, ");
INSERT INTO thr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","और हमेसा अपनी प्रार्थना मैं नहोरे करथौं कि कैसियो करकै अब तुमरे झोने आन ताहीं मेरो सफर परमेस्वर की मरजी से पूरो होबै। ");
INSERT INTO thr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","काहैकि मैं तुमसे मिलन की इच्छा करथौं, ताकी तुम्हैं ऐसो आध्यात्मिक वरदान को उपहार देमौं जोसे तुम मजबूती से बने रहाबौ; ");
INSERT INTO thr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","मतलब की जब मैं तुमरे बीच मैं होमौं, तौ हम बौ बिस्वास से जो मेरे मैं है और तुम मैं है, एक दुसरे कै उकसात जामैं। ");
INSERT INTO thr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","भईय्यौ और बहेनियौ, मैं नाय चाहथौं कि तुम जासे बेखबर रहबौ कि मैं, निरे बार तुमरे झोने आनो चाहो, कि जैसो मोकै दुसरे गैर यहूदि मैं बिस्वास रूपी फल मिलो, बैसिये तुम्हऊँ मैं मिलै, लेकिन हबै ले दिक्कतै आत गईं। ");
INSERT INTO thr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","मैं यूनानियन और परदेसी, और अकल बारेन और बेअकलिन को कर्जदार हौं। ");
INSERT INTO thr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","मैं तुम्हऊँ कै जो रोम देस मैं रहथौ, सुसमाचार सुनान के ताहीं कतई तैयार हौं। ");
INSERT INTO thr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","काहैकि मैं सुसमाचार से नाय सरमाथौं, जहेमारे बौ सबै बिस्वास करन बारेन के ताहीं पहले तौ यहूदि फिर यूनानी के उद्धार के ताहीं परमेस्वर की सामर्थ्य है। ");
INSERT INTO thr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","काहैकि सुसमाचार मैं परमेस्वर की धार्मिकता बिस्वास से और बिस्वास के ताहीं दिखाई देथै; जैसो कि लिखो है, “बिस्वास से धर्मी लोग जिंदे रहमंगे।” ");
INSERT INTO thr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेस्वर को गुस्सा उन लोगन की अभक्ति और अधर्म जो स्वर्ग से दिखाई देथै, जो सच्चाई कै अधर्म से दबाय कै रखथैं। ");
INSERT INTO thr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","परमेस्वर उनकै सजा देगो, काहैकि परमेस्वर को ग्यान उनके मन मैं दिखाई दौ है, और परमेस्वर बाकै दिखाई है। ");
INSERT INTO thr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","काहैकि परमेस्वर के अनदेखे गुन, मतलब बाकी अनंत सामर्थ्य, और परमेस्वरत्व दुनिया की उत्पत्ति के समय से बाके काम के जरिया देखन मैं आथैं, इसलै उनके झोने कोई उत्तर नाय है। ");
INSERT INTO thr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","जहे वजह से परमेस्वर कै जानत भै बाके काबिल कोई बड़ाँईं और धन्यवाद नाय करीं, पर बे बेकार बिचार करन लागे, हिंयाँ तक कि उनको र्निबुद्धि मन अंधियारो हुई गौ। ");
INSERT INTO thr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","बे अपने आपकै अकल बारे जताथैं, पर बे मूर्ख हैं; ");
INSERT INTO thr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","और अविनासी परमेस्वर की महिमा कै, नास होन बारे इंसान, चिरईंयाँ, जानवर और घिसटन बारे कीरा करमोला की मूर्ति के हानी बदल दईं। ");
INSERT INTO thr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","जहे बजह से परमेस्वर उनकै उनकी मन की अभिलासा के जरिया असुद्धता ताहीं छोड़ दई कि बे आपस मैं अपनेई सरीर को बुरो करन लगे। ");
INSERT INTO thr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","काहैकि बे परमेस्वर की सच्चाई कै बदलकै झूठ कर दईं, और जो कुछ परमेस्वर बनाई रहै; बहे की उपासना करीं, ना की बौ बनान बारे की जो हमेसा ताहीं धन्य है! आमीन। ");
INSERT INTO thr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","तभई परमेस्वर उनकै बेकार इच्छा के वस मैं छोड़ दई; हिंयाँ ले की उनकी बईंय्यरौं जो अपने लोगा संग सम्बंध रखनो चाहिए रहै छोड़कै परायन के संग गलत सम्बंध रखन लागीं। ");
INSERT INTO thr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ऐसिये आदमियौं अपनी बईय्यर संग सम्बंध छोड़कै एक दुसरे संग इच्छा मैं जलन लागे। और आदमी-आदमी के संग गलत काम करन लागे। उनकै अपनेई बुरे काम की बजह से बुरो फल मिलन लागो। ");
INSERT INTO thr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","जब बे परमेस्वर कै नाय पहेचाननो चाँहीं, तौ परमेस्वरौ उनकै उनके निठल्ले मन मैं छोड़ दई कि बे ना करन बारे भी काम करैं। ");
INSERT INTO thr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","तभईये बे सबै तरहन के अधर्म, दुस्टता, लालच और एक दुसरे को बुरो करन बारे बन गै; और डहान बारे और मारन और लड़न और धोका, और जलन से भर गै। बे चुगल्या, ");
INSERT INTO thr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","और बदनामी करन बारे, परमेस्वर कै अच्छो ना मानन बारे, दुसरेन को आदर नाय करन बारे, अभिमानी, फोकिया, बुरी बात करन बारे, अपने अईय्या-बाबा को कहनो नाय मानन बारे; ");
INSERT INTO thr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","बेअकली, भरोसो तोड़न बारे, प्यार ना करन बारे और दया ना करन बारे हुईगै हैं। ");
INSERT INTO thr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","बे तौ परमेस्वर की जौ नियम जानथैं, कि ऐसे-ऐसे काम करन बारे मौत की सजा के लायक हैं, तहुँओं बे ऐसो काम करथैं, बल्किन करन बारेन कै बढ़ावा देथैं। ");
INSERT INTO thr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","मेरे भईय्यौ, का तुम दुसरेन के ऊपर दोस लगाथौ? तुमरे झोने कोईये बहाना नाय है, तुम चाँहे जो होबौ; जब तुम दुसरेन को फैसला, और फिर बहे काम करथौ, जो बे करथैं, तौ तुम खुद को तिरस्कार करथौ। ");
INSERT INTO thr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","और हम जानथैं ऐसे-ऐसे काम करन बारेन के ऊपर परमेस्वर घाँईं से सच्चे सजा की आग्या होथै। ");
INSERT INTO thr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","लेकिन तुम, मेरे भईय्यौ, बेईं चीजन कै करथौ जिनके ताहीं तुम दुसरेन ऊपर फैसला सुनाथौ, का तुमकै लगथै कि तुम परमेस्वर के फैसला से बच जागे? ");
INSERT INTO thr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","का तैं बाकी दया, और सकारन, और तसल्ली रूपी धन कै तुच्छ जानथै, का जौ नाय समझथै कि परमेस्वर की भलाई तेरो मन फिरान कै सिखाथै। ");
INSERT INTO thr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","पर अपने हठीले और जिद्दी मन के बजह से, परमेस्वर के न्याय के दिन ताहीं, अपनी सजा कै और बढ़ात जायरै हौ। ");
INSERT INTO thr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेस्वर सबन कै उनके करमन के हिसाब से फल देगो। ");
INSERT INTO thr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जो अच्छे कामन मैं टिके रहकै इज्जत और आदर, और अमरता कै ढूँड़ रै हैं, उनकै बौ अनंत जिंदगी देबैगो; ");
INSERT INTO thr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","लेकिन जो मतलबी हैं, और सच्चाई कै नाय मानकै अधर्म के पच्छू चलथैं, उनके ऊपर गुस्सा और परमेस्वर को परकोप पड़ैगो। ");
INSERT INTO thr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","और कलेस और भीतरी परेसानी सब इंसान की ज्यान ऊपर आमंगी, अग्गु यहूदि ऊपर फिरौंकी यूनानी ऊपर; ");
INSERT INTO thr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","पर महिमा और आदर और सांति सबन कै मिलैगी, जो भलाई करथैं, अग्गु यहूदि कै फिरौंकी यूनानिन कै। ");
INSERT INTO thr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","काहैकि परमेस्वर कोई को भेद-भाव ना करथै। ");
INSERT INTO thr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","तभईये जो बगैर नियम पाए पाप करीं, बे बिना नियम के खतमौं हुई जांगे और जो नियम पाएकै पाप करीं, उनकै सजा भी नियम से मिलैगी। ");
INSERT INTO thr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","काहैकि परमेस्वर के झोने नियम के सुनन बारे धर्मी नाय हैं, लेकिन नियम कै मानन बारे धर्मी होमंगे। ");
INSERT INTO thr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","फिर जब गैर यहूदि के लोग जिनके झोने नियम हइयें नाय, अपने आप से नियम की बातन कै मानथैं तौ बे अपने आप मैं नियम हैं। ");
INSERT INTO thr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","बे नियम की बात अपने-अपने मन मैं लिखी भइ दिखाथै और उनके दिल गभाई देथैं, और उनकी सोच एक दुसरे ऊपर दोस लगाथैं या उन्हईं कै बेगुनाह ठहराथैं। ");
INSERT INTO thr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","एक दिन आगो परमेस्वर मेरे सुसमाचार से ईसु मसीह के घाँईं से इंसान की लुकी बातन को फैसला करैगो। ");
INSERT INTO thr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","का तैं यहूदि है? और नियम मैं भरोसो रखथै, और परमेस्वर के बारे मैं गरब करथै, ");
INSERT INTO thr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","और परमेस्वर की इच्छा जानथै और नियम की सिक्छा की परख पाएकै अच्छी-अच्छी बातन कै प्रिय मानथै; ");
INSERT INTO thr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","और अपने ऊपर भरोसो रखथै कि मैं तौ अंधरन कै चलान बारो, और अंधियारे मैं पड़े भैन कै, उजीतो देन बारो, ");
INSERT INTO thr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","और बगैर बुद्धि बारेन कै सिखान बारो, और बालकन को उपदेसक हौं; और ग्यान, और सच्चाई को नमूना जो नियम मैं है मोकै मिलो है। ");
INSERT INTO thr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","तौ का तैं जो दुसरेन कै सिखाथै, अपने आपकै नाय सिखाथै? “कि चोरी मत करियो” को उपदेस देथै, खुदै चोरी करथै? ");
INSERT INTO thr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तैं तौ ऐसियौ कहथै, “व्यभिचार मत करियो,” का खुदै व्यभिचार करथै? तैं जो मूर्तियन कै घिनौनाे मानथै, का खुदै मंदिरन कै लूटथै? ");
INSERT INTO thr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तैं जो नियम मैं गुमान करथै, का नियम कै नाय मानकै परमेस्वर को अनादर करथै? ");
INSERT INTO thr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“काहैकि तुमरे बजह से गैर यहूदि मैं परमेस्वर के नाओं कै बुरो-भलो कहो जाथै,” जैसो कि लिखो है। ");
INSERT INTO thr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","अगर तैं नियम कै मानै तौ, खतना से फायदा तौ है; अगर तैं नियम कै नाय मानै, तौ तेरो खतना बगैर खतना सो है। ");
INSERT INTO thr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","अगर दुसरी जाति जिनको खतना नाय भौ है, और नियम के आदेसन कै मानथै, का परमेस्वर बाको खतना ना करैगो काहैकि बाको खतना करो गौ रहै? ");
INSERT INTO thr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","और तभई तुम यहूदियन कै, दुसरी जाति के जरिया बुराई करबाई जागी काहैकि तुम नियम तोड़न को अपने आप मैं फैसला कर लेथौ, भलेई तुम जाकै लिखे होबौ और खतना करे होबौ; पर बे नियम को पालन करथैं, भलेई बे सारीरिक रूप से खतना नाय करी हैं। ");
INSERT INTO thr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","आखिर असली यहूदि कौन है, सच्ची मैं खतना? जौ बौ इंसान नाय है जो बाहर से दिखावटी यहूदि हैं, जोको खतना एक सारीरिक चीज है। ");
INSERT INTO thr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","बल्किन, सच्चो यहूदि बहे है जो भीतर से यहूदि है, बौ जोके दिल को खतना भौ है, और जौ परमेस्वर की आत्मा को काम है, लिखित नियम को नाय। ऐसो आदमी परमेस्वर से खुसी हासिल करथै, इंसान से नाय। ");
INSERT INTO thr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","का यहूदियन कै गैर यहूदि से फायदा भौ है? या खतना को का मोल रहगौ? ");
INSERT INTO thr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","सब तरहन से भौत कुछ! सबसे पहले परमेस्वर को उपदेस बिस्वास करकै तौ उन्हईं कै सौंपो गौ रहै। ");
INSERT INTO thr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","अगर उनमैं से एकाद वफादार ना होमैं तौ का होगो? का जाको मतलब जौ है कि परमेस्वर वफादार ना होगो? ");
INSERT INTO thr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","कतई नाय! पर परमेस्वर सच्चो है और सबै इंसान को न्याय होगो, जैसे कि लिखो है, “जब तुम बोलथौ तौ तुमकै सई से बोलनो चहाईये; और जब तुमरे ताहीं कोसिस करी जात होबै तौ तुमकै अपनो मुकदमा जीतनो चहाईये।” ");
INSERT INTO thr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","पर अगर हमरो अधर्म परमेस्वर की धार्मिकता होथै, तौ हम का कह सकथैं? का जौ कहमैं की परमेस्वर सजा देथै तभईये गुस्सा करथै? जौ तौ मैं इंसानन के जैसी कहथौं। ");
INSERT INTO thr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","कतई नाय! नाय तौ परमेस्वर कैसे दुनिया को फैसला करैगो? ");
INSERT INTO thr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","पर का होगो अगर मेरो झूठ बाकी सच्चाई कै और जद्धे सपा तरीका से बनाये कै परमेस्वर की महिमा को काम करथै? तौ फिर काहे पापी के हानी मैं सजा के काबिल मानो जाथौं? ");
INSERT INTO thr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","“काहे ना कहे, तौ हमैं बुराई करन दियौ ताकी अच्छाई आबै?” कुछ लोग, सच्ची मैं मेरे ऊपर जौ बात कहेन को दोस लगाएकै मेरो अपमान करी हैं! उनकी बुराई करी जागी, जैसी उनके संग होनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","तौ फिर का भौ? का हम यहूदि गैर यहूदियन से अच्छे हैं, नाय कतईये नाय! काहैकि हम जौ दिखाए दै हैं कि चाँहे यहूदि होमैं, चाँहे गैर यहूदि सबै पाप के वस मैं हैं। ");
INSERT INTO thr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जैसो सास्त्र मैं लिखो है: “कोई धर्मी नाय हैं, एकौ नाय हैं। ");
INSERT INTO thr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोई भी समझदार नाय हैं, कोईये परमेस्वर कै ढूँड़न बारे नाय हैं। ");
INSERT INTO thr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सबै परमेस्वर से दूर हुईगै हैं; बे सब गलत हुईगै हैं; कोई भलाई करन बारो नाय है। कोइयो सई नाय है, एकौ नाय। ");
INSERT INTO thr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","उनके बोल चोट पहोंचान बारे कपट से भरे कबर हैं; बे अपनी जीभ से छल कपट करीं हैं, उनके ओंठन मैं साँपन को जहर है। ");
INSERT INTO thr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","उनको मोहों बद्‌दुअन और करुआंन बारी बातन से भरो है। ");
INSERT INTO thr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","उनकी टाँग खून बहान ताहीं तैयार हैं, ");
INSERT INTO thr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","उनके रस्ता मैं नास और कलेस है। ");
INSERT INTO thr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","बे सांति को रस्ता नाय जानीं हैं, ");
INSERT INTO thr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","उनकी आँखी अग्गु परमेस्वर को डर हईये नाय।” ");
INSERT INTO thr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","हम जानथैं कि नियम जो कछु कहथै उन्हईं से कहथै, जो नियम मैं चलथैं; तभईये कि सबन को मोहों बंद करो जाबै और पूरी दुनिया परमेस्वर की सजा पान कै ठहरै, ");
INSERT INTO thr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","काहैकि कोई कै नियम की जरूरत के अनुसार कोई इंसान परमेस्वर की नजर मैं सई नाय रखो गौ है; नियम जो करथै बौ हमैं जौ बतान के ताहीं की हम पाप करे हैं। ");
INSERT INTO thr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","लेकिन अब परमेस्वर की धार्मिकता के जरिया आदमिन कै अपने संग रखन को तरीका सामने आओ है। जाको नियम से कोई लेनो देनो नाय है, हालाकि मूसा को नियम और भविस्यवक्ता जाकी गभाई दईं हैं। ");
INSERT INTO thr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","मतलब जौ कि, परमेस्वर की बौ धार्मिकता जो ईसु मसीह मैं बिस्वास करन से सबै बिस्वास करन बारेन ताहीं है, काहैकि कछु चीज को भेद-भाव हईये नाय: ");
INSERT INTO thr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","तभईये सबै पाप करीं हैं और परमेस्वर की महिमा से दूर हैं, ");
INSERT INTO thr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","लेकिन बाकी दया और बाके छुटकारा से जो ईसु मसीह मैं है, सेंत-मेंत मैं धर्मी हुई जाथैं, ");
INSERT INTO thr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","बाकै परमेस्वर ईसु के खून के बजह से ऐसो पछताबा करबाई, जो बिस्वास करन सेई होथै, कि जो पाप पहले करे गै और जिनके ऊपर परमेस्वर बरदास करन की बजह से ध्यान नाय दई। उनके बारे मैं बौ अपनी धार्मिकता दिखाई है। ");
INSERT INTO thr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ऐसे करकै परमेस्वर दिखाथै कि बौ खुद धर्मी है और जो कोई ईसु पर बिस्वास करथै, बाकै बौ सई ठहराथै। ");
INSERT INTO thr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तौ घमंड करनो रहुए नाय? बाकी तौ जघा हईये नाय! कौन से नियम से? का करमन के नियमन से? नाय, बल्किन बिस्वास के नियम से। ");
INSERT INTO thr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","काहैकि हम जौ नतीजा मैं पहोंचे हैं कि एक आदमी कै बिस्वास के जरिया परमेस्वर के संग धर्मी मानो जाथै, और ऐसो करन से नाय कि नियम का कहथै। ");
INSERT INTO thr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","का परमेस्वर सिरफ यहूदियन को है? का गैर यहूदिन को नाय है? हाँ, गैर यहूदिन को भी है। ");
INSERT INTO thr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","काहैकि एकै परमेस्वर है, और बौ अपने बिस्वास के आधार मैं खतना करान बारे यहूदियन कै अपने संग रखैगो, और गैर यहूदिन कै उनके बिस्वास के जरिया धर्मी ठहरागो। ");
INSERT INTO thr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","का जाको मतलब जौ है कि जौ बिस्वास से हम नियम को पालन करथैं? नाय, कतई नाय; जाके अलावा, हम नियम कै बनाये रखाथैं। बल्किन नियम कै निठाठौर एकै जघा रखथैं। ");
INSERT INTO thr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","तौ हम का कहमैं, कि हमरे सारीरिक दऊवा अब्राहम? बाको अनुभव का रहै? ");
INSERT INTO thr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","अगर अब्राहम परमेस्वर के संग सई काम करथै, बाके पास घमंड के ताहीं कुछ होगो लेकिन परमेस्वर की नजर मैं नाय। ");
INSERT INTO thr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","पवित्र सास्त्र का कहथै? जौ कि “अब्राहम परमेस्वर ऊपर बिस्वास करी, और बाके बिस्वास के बजह से परमेस्वर बाकै धर्मी के रूप मैं अपनाई।” ");
INSERT INTO thr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","काम करन बारे आदमी कै दिहाड़ी देनो दान ना होथै, लेकिन बाको अधिकार होथै। ");
INSERT INTO thr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","पर जो काम ना करथै बल्किन बिना काम के धर्मी ठहरान बारे ऊपर बिस्वास करथै, बाको बिस्वास बाके ताहीं धार्मिकता गिनो जाथै। ");
INSERT INTO thr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","दाऊद को जौ मतलब है कि जब बौ आदमी कि खुसी की बात करथै जोकै परमेस्वर धर्मी के तराहनी अपनाथै, जाके अलावा बौ आदमी जो कुछ भी करथै: ");
INSERT INTO thr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्य हैं बे जिनके अधर्म माफ हुईगै, और जोके पाप ढोंक दै गै। ");
INSERT INTO thr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धन्य है बौ इंसान जोकै प्रभु पापी नाय मानै!” ");
INSERT INTO thr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","तौ जौ खुसी की दाऊद सिरफ खतना करन बारेन से जुड़े होन कि बात करी रहै? सच मैं नाय! जाको सम्बंध बे आदमिन से भी है जिनको खतना ना भौ है। काहैकि पवित्र सास्त्र मैं लिखो है “अब्राहम परमेस्वर के ऊपर बिस्वास करी और परमेस्वर बाकै धर्मी मानी।” ");
INSERT INTO thr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","तौ अब्राहम कैसे गिनो गौ? खतना हानी नाय लेकिन बगैर खतना हानी गिनो गौ। ");
INSERT INTO thr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","बौ खतना को चिन्ह पाई कि बौ बिस्वास की धार्मिकता ऊपर मुहर हुई जाबै, जो बौ बगैर खतना के हानी रहै, जोसे बौ सबन को बाबा होबै जो बगैर खतना हानी बिस्वास करथैं ताकी बेऊँ धर्मी होमैं; ");
INSERT INTO thr_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","और बौ खतना करे भौ को बाबा होबै, जो नाय तौ सिरफ खतना करे भै हैं, पर हमरे बाबा अब्राहम के बौ बिस्वास की पटक मैं चलथैं जो बौ बगैर खतना के हानी करी रहै। ");
INSERT INTO thr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","परमेस्वर जो अब्राहम से वादा करी रहै कि दुनिया को वारिस होगो, ना तौ अब्राहम कै, ना तौ अब्राहम मूसा के नियम के मानन के जरिये, बल्किन बिस्वास के जरिये अब्राहम धर्मी मानो गौ रहै। ");
INSERT INTO thr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","काहैकि अगर नियम बारे वारिस हैं, तौ बिस्वास बेकार और वादा बिना फल को है। ");
INSERT INTO thr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","नियम परमेस्वर के गुस्सा कै कम करथै, पर जहाँ नियम नाय है, नियम की कोई आग्या ना मानथै। ");
INSERT INTO thr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","और जहे बजह से वादा बिस्वास और अनुग्रह मैं आधारित रहै, ताकी वादा कै अब्राहम के सबै बंसज के ताहीं परमेस्वर के मुफ्त उपहार के रूप मैं पक्को करनो चाहिए सिरफ बे आदमिन के ताहीं नाय जो नियम को पालन करथैं, पर बे आदमिन के ताहींयों जो अब्राहम के जैसी मानथैं काहैकि अब्राहम हम सबन को आत्मिक दऊवा है; ");
INSERT INTO thr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जैसो कि सास्त्र मैं लिखो है, “मैं तोकै भौत से देसन को दऊवा बनाओ हौं।” परमेस्वर की नजर मैं अब्राहम हमारो दऊवा है। बे बौ परमेस्वर मैं बिस्वास करीं, जो मरे भैन कै जिंदो करथै और जोकी आग्या अस्तित्व मैं लाथै, जो की अस्तित्व मैं रहिये नाय। ");
INSERT INTO thr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","अब्राहम निरासा मैं भी आसा धरकै बिस्वास करी, हिंयाँ ले कि जब उमीद के ताहीं कोई कारड़ नाय रहै, और तभईये “निरे देसन को बाबा बन गौ।” जैसी सास्त्र कहथै, “तेरो बंसज तारा जित्तो होगो।” ");
INSERT INTO thr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","बौ जब सौ साल को रहै, पर बाको बिस्वास बौ समय कमजोर ना पड़ो जब बौ अपने सरीर के बारे मैं सोची, जो पहलिये से बहार से मरो भौ रहै, या जौ बात से कि सारा को बालका ना हुई सकथै। ");
INSERT INTO thr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","और ना कहुए बगैर बिस्वास के बाके वादा ऊपर संका करी, लेकिन बिस्वास मैं टिको रहो; बाको बिस्वास बाकै सक्ति से भर दई, और बौ परमेस्वर की महिमा करी। ");
INSERT INTO thr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","और बाकै पूरो यकीन रहै कि परमेस्वर जो वादा करी रहै, बौ पूरो करैगो। ");
INSERT INTO thr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","जहे बजह है कि अब्राहम, बिस्वास से, “परमेस्वर के जरिया धर्मी हुईकै गिनो गौ।” ");
INSERT INTO thr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","और जहे बचन, “बिस्वास बाके ताहीं धार्मिकता गिनो गौ,” ना सिरफ बहे के ताहीं लिखो गौ। ");
INSERT INTO thr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","बेऊँ हमरे ताहीं लिखे गै रहैं जिनकै धर्मी के रूप मैं अपनाओ जाने है, जो बाके ऊपर बिस्वास करथै जो हमारे प्रभु ईसु कै मौत से जिंदो करी। ");
INSERT INTO thr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","हमरे पापन के बजे से बाकै मरन कै दौ गौ रहै, और बौ हमैं जिंदगी देन के ताहीं उठाओ गौ रहै ताकी हम परमेस्वर के संग सई करे जामैं। ");
INSERT INTO thr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","अब जब हमकै बिस्वास के जरिये परमेस्वर के संग सई से रखो गौ है, तौ हम अपने प्रभु ईसु मसीह के जरिया से परमेस्वर के संग सांति रखथैं। ");
INSERT INTO thr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","जोके जरिया बिस्वास के बजह से बौ अनुग्रह तक, जोमैं हम बने हैं, हमरी पहोंचो भइ, परमेस्वर की महिमा! और आसा मैं घमंड करैं। ");
INSERT INTO thr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","सिरफ जहे नाय, बल्किन हम कलेसनौं मैं गरब करैं, जौ जानकै की कलेस से धीरज, ");
INSERT INTO thr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","और धीरज से खरो निकरनो, और खरो होन से आसा मिलथै। ");
INSERT INTO thr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","और जौ आसा हमकै उदास नाय करथै, काहैकि पवित्र आत्मा जो हमकै दई गौ है बासे परमेस्वर को प्यार हमरे मन मैं डार दौ गौ है। ");
INSERT INTO thr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","जब हम हबऊ बगैर सहारा के रहैं, मसीह बौ समय पापिन के ताहीं मर गौ जोकै परमेस्वर चुनी रहै। ");
INSERT INTO thr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","अगर कोई इंसान धर्मी के ताहीं मरै; जौ अनहोनो है। और कोई अच्छे इंसान ताहीं ऐसियौ तौ होबै जो मरन की हिम्मतौ करै। ");
INSERT INTO thr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","लेकिन परमेस्वर अपने प्यार की भलाई ऐसे करकै दिखाथै कि जब हम पापियै रहैं तभई मसीह हमरे ताहीं मरो! ");
INSERT INTO thr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","अब जब हम बाके खून से धर्मी हिये गै हैं, तौ बैसिये परमेस्वर के गुस्सौ से काहे नाय बचंगे! ");
INSERT INTO thr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","हम परमेस्वर के दुस्मी रहैं, लेकिन बौ हमैं अपने बालक की मौत के जरिया अपनो दोस्त बनाई। अब जब हम परमेस्वर के दिलबर हैं, हम मसीह की जिंदगी से कित्तो बचंगे! ");
INSERT INTO thr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","लेकिन ऐसो कतई नाय है; हमरे प्रभु ईसु मसीह के जरिया परमेस्वर जो कछु करी है, बाके बजह से हम खुस होथैं, जो अब हमैं परमेस्वर से मेल-मिलाप करबाई है। ");
INSERT INTO thr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ऐसिये जैसे एक इंसान से पाप जौ दुनिया मैं आओ, और पाप से मौत आई, और ऐसे करकै मौत सबै इंसानन मैं फैल गई, काहैकि सबै पाप करीं। ");
INSERT INTO thr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","हींना दुनिया मैं नियम दौ जान से पहले पाप रहै; लेकिन जहाँ नियम नाय है, कोई भी खाता पापन को नाय है। ");
INSERT INTO thr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","पर आदम के समय से मूसा के समय ले, मौत सबै इंसानन ऊपर राज्य करी, हिंयाँ ले कि बे आदमिन ऊपर भी, जो आदम परमेस्वर की आग्या ना मानी रहै बैसिये पाप नाय करी। आदम जो आनबारो रहै बहो को एक आँकड़ा रहै। ");
INSERT INTO thr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","लेकिन जो हाल गलतियन को है, बौ हाल अनुग्रह के वरदान को हईये नाय, काहैकि जब एक इंसान के अपराध से निरे इंसान मरे, तौ परमेस्वर की अनुग्रह और बाको जौ दान एक इंसान के, मतलब ईसु मसीह के, अनुग्रह से भौ, भौत से लोगन ऊपर सच्चियै मैं खूबै-खूब भौ। ");
INSERT INTO thr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","और परमेस्वर के उपहार और एक आदमी के पाप के बीच अंतर है। एक पाप के बाद “दोसी” को न्याय के काम को फैसला आओ; पर इत्ते सारे पापन के बाद, “कोई दोसी नाय है उपहार आथै!” ");
INSERT INTO thr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","जौ सच है कि एक इंसान के पाप के जरिये मौत बौ एक इंसान के बजह से राज्य करन लगी। लेकिन जो एक आदमी, ईसु मसीह करी, बाको फल कितनो बड़ो है! बे सबै जो परमेस्वर को गजब अनुग्रह कै पाथैं और बाके संग स्वतंत्‌र ऊपर से न्याय पाथैं, मसीह के जरिये जिंदगी मैं राज करंगे। ");
INSERT INTO thr_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","तभई, एक अपराध सब इंसानन के ताहीं सजा की आग्या को बजह बनो, बैसिये एक धर्म को काम सब आदमिन के जिंदगी के ताहीं, धर्मी को बजह बनो। ");
INSERT INTO thr_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","और जैसी सब आदमिन कै पापी बनाओ गौ रहै, बैसिये एक आदमी की आग्या के कारड़, बैसिये बे सबै एक आदमी के आग्या मानन के फलस्वरूप परमेस्वर के संग धर्मी हुई जांगे। ");
INSERT INTO thr_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","नियम जो रहै बीच मैं आए गौ कि अपराध भौत होबै, पर जितै पाप खूबै भौ हुँआँ परमेस्वर को अनुग्रह बहो से जाधे भौ, ");
INSERT INTO thr_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","तौ फिरौंकी, जैसी पाप मौत कै फैलात भै राज करी, बैसिये हमरे प्रभु ईसु मसीह से अनुग्रह भी अनंत जिंदगी के ताहीं धर्मी होत भै राज करै। ");
INSERT INTO thr_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","तौ हम का कहमैं? का हम पाप करत रहमैं, कि परमेस्वर को अनुग्रह खूबै होबै? ");
INSERT INTO thr_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","कतईये नाय! हम जब पाप के ताहीं मर गै तौ फिर अग्गु कै बामै जिंदगी कैसे करकै बितामैं? ");
INSERT INTO thr_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","का तुम नाय जानथौ, कि हम जित्ते ईसु मसीह को बपतिस्मा लै हैं, तौ बाके मरन को बपतिस्मा लै हैं। ");
INSERT INTO thr_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","सो बाके मौत को बपतिस्मा पाए लेन से हम बाके संग गड़ार दै गै, ताकी जैसे मसीह परमपिता की महिमा से मरे भै मैं से जिंदो करो गौ, बैसिये हमउँ नई जिंदगी की चाल चलैं। ");
INSERT INTO thr_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","काहैकि अगर हम बाके मौत से बाकी समानता मैं हुईगै हैं, तौ जैसे बौ जिंदो हुई गौ बैसिये हमउँ जिंदे हुई जांगे। ");
INSERT INTO thr_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","और हम जानथैं की हमरो पुरानो चाल-चलन बाके संग क्रूस मैं चढ़ाय दौ गौ, ताकी पाप को सरीर बरबाद हुई जाबै, और हम अग्गु कै पाप की गुलामी मैं नाय रहमैं। ");
INSERT INTO thr_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","काहैकि जो मर गौ, बौ पाप से छुटकै धर्मी ठहरो। ");
INSERT INTO thr_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","तौ अगर हम मसीह के संग मर गै, तौ हमरो बिस्वास जौ है कि बाके संग हम जीमंगे भी। ");
INSERT INTO thr_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","काहैकि हम जौ जानथैं मसीह मरे भै मैं से जिंदो भौ फिर दुबारा मरन बारो हईये नाय; बाके ऊपर मौत राज्य कहु नाय करैगी। ");
INSERT INTO thr_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","और तभई, काहैकि बौ मर गौ, पाप की बाके ऊपर कोई सक्ति नाय है; और अब जिंदो है तौ सिरफ परमेस्वर के ताहीं जिंदो है। ");
INSERT INTO thr_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ऐसिये तुम्हऊँ अपने आपकै मरो भौ समझथौ, जहाँ ले पाप को सबाल है, लेकिन मसीह ईसु के जरिया परमेस्वर के संग संगती मैं जिंदे रहियो। ");
INSERT INTO thr_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","अब पाप तुमरे खतम होन बारे सरीर मैं राज्य ना करै, ताकी तुम अपने प्राकृतिक सरीर की इच्छन को पालन ना कर सकौ। ");
INSERT INTO thr_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","और ना अपने सरीर के कोई भी हिस्सा कै अधर्म को हथियार होन के ताहीं पाप कै सौपौं, पर खुदकै मरे भै मैं से जिंदो करो गौ जानकै परमेस्वर कै सौंपौ, और अपने सरीर के एक-एक हिस्सा कै धर्मी को हथियार होन के ताहीं परमेस्वर कै सौंपौ। ");
INSERT INTO thr_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","पाप तुमरो मालिक ना होनो चाहिए; काहैकि तुम नियम के तहत नाय; बल्किन परमेस्वर के अनुग्रह और किरपा के अधीन रहथौ। ");
INSERT INTO thr_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","तौ का भौ? का हम जहे के मारे पाप करैं कि हम नियम के अधीन नाय बल्किन अनुग्रह के अधीन हैं? कतईये नाय! ");
INSERT INTO thr_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","का तुम ना जानथौ, कि जो कि आग्या मानन ताहीं तुम अपने आपकै दास के हानी सौंप देथौ बहे के दास हौ: और जोकी मानथौ, चाँहे पाप के, जोको अंत मौत है, या चाँहे आग्या मानन बारे होमैं जोको अंत धार्मिकता है, जोके फलस्वरूप परमेस्वर के संग सई करो जाएरौ है। ");
INSERT INTO thr_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","लेकिन परमेस्वर को धन्यवाद होबै! हालाकि एक समय तुम पाप के दास रहौ, तुम जो कछु पढ़ाए, बामै मिली सच्चाईयन कै अपने दिल से माने। ");
INSERT INTO thr_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","और पाप से छुड़ाय जाएकै धर्म के गुलाम हुईगै हौ। ");
INSERT INTO thr_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","मैं तुमरे सरीर की कमजोरी के बजह से इंसान की रीत मैं कहथौं। जैसे तुम अपने सरीर के अंग कै असुद्ध करन के ताहीं अधर्म के बजह से गुलाम बनाए दै रहौ, बैसिये अब अपने सरीर के हिस्सन कै पवित्रता के ताहीं धर्मी के दास करकै सौंप देबौ। ");
INSERT INTO thr_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","जब तुम पाप के दास रहौ, तौ बौ समय धार्मिकता से आजाद रहौ। ");
INSERT INTO thr_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","अब जो-जो बातन से तुम सर्माथौ, बौ समय उनसे का फल पात रहौ? काहैकि उनके अंत मैं तौ मरनोई लिखो है! ");
INSERT INTO thr_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","लेकिन अब तुम पाप से छुटकै और परमेस्वर के दास हौ। तुमरो फायदा पूरे तरीका से बाकै सौंपो भौ जीवन है, और जाको नतीजा अनंत जिंदगी है। ");
INSERT INTO thr_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","पाप कि मजदूरी तौ मौत है, लेकिन परमेस्वर को वरदान हमरे प्रभु मसीह ईसु मैं अनंत जिंदगी है। ");
INSERT INTO thr_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","हे भईय्यौ और बहेनियौ, का तुम नाय जानथौ मैं नियम के जानन बारेन से कहथौं कि जबले इंसान जिंदो रहथै, तौले बाके ऊपर नियम को राज्य रहथै। ");
INSERT INTO thr_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","काहैकि सादी सुदा बईय्यर, नियम के आधार मैं अपने आदमी के जीते जी बासे भँदी है, पर अगर बाको आदमी खतम हुई जाबै, तौ बौ अपने लोगा के नियम से छुट गई। ");
INSERT INTO thr_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","तभई अगर, आदमी के जीते जी बौ कोई पराए आदमी की हुई जाबै, तौ बौ छिनरइ कही जाबैगी, लेकिन अगर आदमी खतम हुई जाबै, तौ बौ नियम से छुट गई, हिंयाँ तक कि अगर कोई पराए आदमी की हुई जाबै तौ तहुँओं छिनरइ नाय मानी जागी। ");
INSERT INTO thr_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","बैसिये मेरे भईय्यौ और बहेनियौ, तुम्हऊँ मसीह के सरीर से नियम के ताहीं मरे भै हुईगै, कि बे दुसरेन के हुई जाबौ, जो मरे भौ मैं से जिंदो हुई गौ: ताकी हम परमेस्वर के ताहीं फल लामैं। ");
INSERT INTO thr_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","काहैकि जब हम सारीरिक रहैं, तौ पापन की इच्छा जो नियम के जरिया रहै, मरन को फल देन ताहीं हमरे सरीर के अंगन मैं काम करत रहैं। ");
INSERT INTO thr_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","अब, हालाकि जोके बंधन मैं हम भँदे रहैं बाके ताहीं मर कै, अब नियम से ऐसे करकै छुट गै, कि लिखी भइ पुरानी रीत मैं नाय, बल्किन आत्मा की नई रीत से। ");
INSERT INTO thr_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","तौ हम का कहमैं? फिरौंकी का नियमै पापी है? कतईये नाय! बल्किन बगैर नियम के मैं पाप कै जानिए ना सकथौं। अगर नियम कहतो कि “जो कोई और कोई को है बाकी इच्छा मत करै,” तौ मैं ऐसी इच्छा कै जानतोई नाय। ");
INSERT INTO thr_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","लेकिन बौ आग्या के जरिया पाप मेरे मैं सबै तरह की लालची इच्छन कै जगान को मौका पाई। काहैकि बगैर नियम के तौ पाप मरो भौ है। ");
INSERT INTO thr_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","मैं तौ पहले बगैर नियम के जिंदो रहौं लेकिन जब आग्या मिली, तौ पाप जी गौ, और मैं मर गौ। ");
INSERT INTO thr_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","और बहे आग्या जो मेरी जिंदगी के ताहीं रहै, मेरे ताहीं मरन की बजह बनी। ");
INSERT INTO thr_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","काहैकि पाप मौका मारकै आग्या से मोकै फुसलाई, और बहे की बजह से मोकै मारियो डारी। ");
INSERT INTO thr_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","तभई के मारे नियम पवित्र है, और आग्या पवित्र, धर्मी और अच्छी है। ");
INSERT INTO thr_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","तौ का बौ जो अच्छो रहै, मेरे ताहीं मौत ठहरो? कतईये नाय! लेकिन पाप बौ अच्छी चीजन से मेरे ताहीं मौत कै पैदा करन बारो भौ, ताकी पाप को असली रूप सामने आए सकै। और तभई आग्या के जरिया पाप कै औरौ खतरनाक तरीका से पाप के रूप मैं दिखाओ गौ है। ");
INSERT INTO thr_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","हम जानथैं कि नियम तौ आध्यात्मिक है, लेकिन मैं सारीरिक हौं और पाप के हात मैं बिको भौ हौं। ");
INSERT INTO thr_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","मोकै समझ मैं नाय आए रौ है कि मैं का करौं; काहैकि मैं बौ ना करथौं जो मोकै करनो चाहिए, लेकिन जाके बजाय मैं बहे करथौं जोसे मैं नफरत करथौं। ");
INSERT INTO thr_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","काहैकि मैं जो कहथौं, बहे करथौं, जासे पता लगथै कि मैं मानथौं कि नियम ठीक है। ");
INSERT INTO thr_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","तौ ऐसे हालत मैं बाकै करन बारो मैं नाय, बल्किन बौ पाप है जो मेरे भीतर है। ");
INSERT INTO thr_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","मैं जानथौं, कि मेरे सरीर के भीतर कोई अच्छी चीज नाय बास करथै, मन तौ मेरो होथै, भलेई अच्छो करन की इच्छा मेरे मैं है, लेकिन भले काम मोसे होतै ना हैं। ");
INSERT INTO thr_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","काहैकि जो अच्छो काम करन को मेरो मन होथै, बौ तौ मैं करतै नाय हौं, लेकिन जो खराब काम के ताहीं मन नाय करथै, बहे काम करथौं। ");
INSERT INTO thr_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","अगर मैं बे काम करथौं जोको मेरो मन नाय करथै, जाको मतलब बे काम कै करन बारो मैं नाय रहौं, लेकिन पाप जो मेरे भीतर है बहे जे काम करथै। ");
INSERT INTO thr_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","तौ मोकै जो नियम मिलथै कि जब मैं भले काम करन की सोचथौं: जब मैं बौ करनो चाहथौं जो अच्छो है, तौ बुराई मेरे झोने आथै। ");
INSERT INTO thr_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","काहैकि मैं अपने अंदर की इंसानियत से तौ परमेस्वर के नियम से भौतै खुस रहथौं। ");
INSERT INTO thr_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","लेकिन मोकै मेरे सरीर के हिस्सन मैं कुछ अलगै जैसो नियम दिखाई देथैं, जो मेरे अकल के नियम से लड़थैं और मोकै पाप के नियम के भँदना मैं डरात रहथैं जो मेरे सरीर के हिस्सन मैं हैं। ");
INSERT INTO thr_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","मैं कैसो दुखी आदमी हौं! जौ सरीर से मोकै कौन छुड़ाबैगो जो मोकै मौत के घाट उतार रहो है? ");
INSERT INTO thr_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","हमरे प्रभु ईसु मसीह के जरिये, परमेस्वर को धन्यवाद होबै! जौ फिर मेरी स्थिति है: अपने दम पर मैं अपने मन से सिरफ परमेस्वर के नियम की सेवा करथौ, जबकी मेरो इंसान को स्वभाव पाप के नियम को काम करथै। ");
INSERT INTO thr_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","तौ अब मसीह ईसु के संग रहन बारेन के ताहीं कोई सजा नाय है। ");
INSERT INTO thr_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","आत्मा के नियम के ताहीं, जो हमैं मसीह ईसु के संग जिंदगी मैं लाथै, मोकै पाप और मौत के नियम से छुटकारो दै दई है। ");
INSERT INTO thr_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","काहैकि जो काम नियम सरीर की बजह से कमजोर हुईकै नाय कर पाई, बाकै परमेस्वर करी, मतलब अपनोई लौड़ा कै पाप बारे सरीर के हानी और पाप बलि होन के ताहीं भेजकै, सरीर मैं पाप ऊपर सजा की आग्या दई। ");
INSERT INTO thr_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","परमेस्वर ऐसो तभई करी ताकी नियम की धर्मी माँगैं पूरी तरीका से हम्मै तसल्ली कर सकैं जो आत्मा के अनुसार चलथैं, और इंसान की प्रकृति के हानी नाय। ");
INSERT INTO thr_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","काहैकि जो लोग सारीरिक होथैं बे सरीर की बातन मैं मन लगाथैं; जो लोग आत्मा के रूप मैं जीथैं उनकै, आत्मा जो चाहथै बहे के जरिया अपने मन कै नियंतरित करो जाथै। ");
INSERT INTO thr_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","सरीर मैं मन लगानो तौ मौत है, लेकिन पवित्र आत्मा मैं मन लगानो जिंदगी और सांति है। ");
INSERT INTO thr_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","और सरीर मैं मन लगानो तौ परमेस्वर से दुस्मनी रखनो है, काहैकि ना तौ हम परमेस्वर के नियम के भरोसे है और ना हुई सकथै; ");
INSERT INTO thr_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","और जो सरीर के प्रकृति के वस मैं है, बे परमेस्वर कै खुस नाय कर सकथैं। ");
INSERT INTO thr_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पर जबकी परमेस्वर को आत्मा तुमरे भीतर रहथै, तौ तुम सारीरिक प्रकृति मैं नाय लेकिन आत्मा के हालत मैं होबौ। अगर कोई के भीतर मसीह की आत्मा नाय है तौ बौ बाको इंसान हईये नाय। ");
INSERT INTO thr_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","अगर मसीह तुमरे मैं है, तौ सरीर पाप की बजह से मरी भइ है; लेकिन आत्मा धर्म के बजह से जिंदी है। ");
INSERT INTO thr_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","अगर बहे को आत्मा जो ईसु कै मरे भौ मैं से जिंदो करी, तुमरे भीतर बसो पड़ो है; तौ जो मसीह के मरे भौ मैं से जिंदो करी, बहे तुमरे नास होन बारे सरीर कै अपनी आत्मा से जो तुमरे मैं बसी भइ है, जिंदो करैगो। ");
INSERT INTO thr_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","भईय्यौ और बहेनियौ, हम सरीर के कर्जदार नाय हैं कि सरीर के हिसाब से जिंदगी काटैं, ");
INSERT INTO thr_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","काहैकि अगर तुम सरीर के हानी दिन काटैगे तौ मरैगे, अगर आत्मा से सरीर के कामन कै मारौगे तौ जिंदे रहाबैगे। ");
INSERT INTO thr_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","तभईये जित्ते आदमी परमेस्वर की आत्मा के चलाय चलथैं, बेईं परमेस्वर के बालका हैं। ");
INSERT INTO thr_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","परमेस्वर तुमकै जो आत्मा दई है, बौ तुमकै गुलाम नाय बनाथै, और ना तुमकै डरपाथै; बल्किन, उल्टा आत्मा तुमकै परमेस्वर को बालका बनाथै, और आत्मा के बल से हम परमेस्वर कै पुकारथैं, “परमपिता! मेरे परमपिता!” ");
INSERT INTO thr_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","परमेस्वर की आत्मा खुदै हमरी आत्मा के संग गभाई देथै, कि हम परमेस्वर के बालका हैं। ");
INSERT INTO thr_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","और अगर बालका हैं तौ बाके वारिस हैं, बल्किन परमेस्वर के हकदार और मसीह के संगी हकदार हैं, कि जब हम बाके संग दुख उठामैं तौ बाके संग महिमा पांगे। ");
INSERT INTO thr_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","मोकै लगथै कि जौ समय के दुख और कलेस बाकी महिमा के अग्गु, जो हमरे ऊपर दिखन बारी है, कछुए नाय है। ");
INSERT INTO thr_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","दुनिया खूबै आसा बारी नजर से परमेस्वर के बालकन के दिखाई देन की रहा निहार रइ है। ");
INSERT INTO thr_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","सृस्टि अपनी मरजी से नाय पर अधीन करन बारे के घाँईं से, लेकिन परमेस्वर को ऐसो करन की इच्छा है। तहुँओं आसा रहै ");
INSERT INTO thr_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","कि सिरस्टी खुद एक दिन अपनी गुलामी से छुटकै खतम होन लगैगी और परमेस्वर के बालकन की महिमा की आजादी लेबैगी। ");
INSERT INTO thr_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","हम जानथैं कि पूरी दुनिया हबै तक मिलकै कांखथै और परेसानी मैं पड़ी भइ तड़पत रहथै। ");
INSERT INTO thr_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","और सिरफ बहे नाय लेकिन हमउँ बाके झोने आत्मा को फल हैं, अपने आपै मैं कांखथैं; और बालक होन ताहीं मतलब अपनी सरीर के छुटकारे की रहा तकथैं। ");
INSERT INTO thr_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","हमरो उद्धार जौ आसा से भौ है लेकिन जो चीज की आसा करी जाथै, जब बौ देखन मैं आथै तौ फिर आसा रहिये कहाँ? काहैकि जो चीजन कै कोई देखरौ है बाकी आसा कहाँ करंगे? ");
INSERT INTO thr_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","पर जो चीज कै हम देखतै नाय हैं, अगर बाकी आसा रखथैं तौ, धीरज से बाकी रहा तकथैं। ");
INSERT INTO thr_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ऐसियै आत्मौ हमरी कमजोरी मैं मदत करथै, काहैकि हम जानतै ना हैं, कि प्रार्थना कैसे करकै करनो चाहिए; आत्मा खुदै ऐसे आँह भर-भरकै जो बखान करन से परे है, हमरे ताहीं मिन्नत करथै। ");
INSERT INTO thr_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","और मन कै परखन बारो जानथै कि आत्मा की का मरजी है? काहैकि बौ पवित्र आदमिन के ताहीं परमेस्वर की इच्छा से बिनती करथै। ");
INSERT INTO thr_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","और हमउँ जानथैं, कि जो आदमी परमेस्वर से प्यार करथैं, उनके ताहीं सबै बात मिलकै भलाइये पैदा करथैं; मतलब उन्हईं के ताहीं जो बाकी इच्छा से बुलाए भै हैं। ");
INSERT INTO thr_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","काहैकि जिनकै बौ पहलिये से जान लई है उनकै पहलिये से ठहराए भी दई है कि बाके लौड़ै हानी होमैं जोसे बौ निरे भईय्यनौ मैं पहलोठो होबै। ");
INSERT INTO thr_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","फिरौंकी जिनकै बौ पहलिये से ठहराए दई है, उनकै मस्काई भी, और जिनकै मस्काइयो, उनकै धर्मी ठहराई, और जिनकै धर्मी ठहराई, उनकै महिमा भी दई है। ");
INSERT INTO thr_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","तौ जे बातन के बारे मैं का कहमैं? अगर परमेस्वर हमरे घाँईं है, तौ हमरो बिरोधी कौन हुई सकथै? ");
INSERT INTO thr_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","जो अपने खुदै के बालक कै नाय छोड़ी, लेकिन बौ ईसु कै हम सबन कै ताहीं सौंप दई, तौ बाके संग हमकै और सबै कछु काहे नाय देगो? ");
INSERT INTO thr_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","परमेस्वर के चुने भै के ऊपर कौन दोस लगाए पागो? परमेस्वर बौ है जो उनकै धर्मी बनानबारो है! ");
INSERT INTO thr_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","फिर कौन है जो सजा की आग्या देगो? ईसु मसीह बौ है जो मर गौ बल्किन मरे भौ मैं से जिंदो भी हुई गौ, और परमेस्वर के दहने है, और हमरे ताहीं बिन्तिओ करथै! ");
INSERT INTO thr_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कौन है जो हमकै मसीह के प्यार से अलग कर सकथै? का कलेस, या मुसीबत, या संकट, या अकाल, या कंगाली, या उपद्दर, या जोखिम, या तलवार या मौत? ");
INSERT INTO thr_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जैसे कि सास्त्र मैं लिखो है, “तुमरे खातिर हमैं हर समय मौत को खतरा है; हमरे संग मरन बारी भेंड़-बकरियन के जैसे बर्ताव करो जाएरौ है।” ");
INSERT INTO thr_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","नाय! इन सब चीजन मैं हमैं बाके जरिया से पूरी जीत मिली है जो हमसे प्यार करी है! ");
INSERT INTO thr_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","काहैकि मोकै पक्को बिस्वास है, कि ना तौ मौत ना जिंदगी, ना स्वर्गदूत, ना हुई प्रधानताऐं, ना समय जो चल रहो है, ना आनबारो समय, ना सामर्थ्य, ना ऊँचो, ");
INSERT INTO thr_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ना गहरो और ना सृस्टि, हमकै परमेस्वर के प्यार से, जो हमरे प्रभु ईसु मसीह मैं है, अलग कर पागो। ");
INSERT INTO thr_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","मैं मसीह मैं सच्ची कहथौं, और झूठ नाय बोलथौं और मेरो मन पवित्र आत्मा मैं गभाई देथै। ");
INSERT INTO thr_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","जब मैं कहथौं कि मेरो दुख कितनो बड़ो है, मेरे दिल मैं कितनो दर्द है ");
INSERT INTO thr_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","काहैकि मैं हिंयाँ तक चाहथौं, कि मेरे लोगन के ताहीं जो सरीर के हिसाब से तौ मेरे कुरमा टब्बर हैं, बे अपने आपै मसीह से स्रापित और न्यारे हुई जाते। ");
INSERT INTO thr_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","बे परमेस्वर के लोग इस्राएली हैं; बौ उन्हैं अपनो बालका बनाई, और अपनी महिमा उनके ऊपर दिखाई; बौ उनके संग अपनी वाचा भाँदी और उन्हैं नियम दई; उनके पास सच्ची आराधना है; बे परमेस्वर की प्रतिग्यन कै पाईं हैं; ");
INSERT INTO thr_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","नामी इब्रानी पुरखा उन्हईं के हैं, मसीह सरीर के भाव से उन्हईं मैं से भौ। सबन के ऊपर परम परमेस्वर हमेसा-हमेसा धन्य होबै। आमीन। ");
INSERT INTO thr_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","लेकिन ऐसो ना है कि परमेस्वर को बचन टल गौ, तभईये कि जो इस्राएल के बंस हैं बे सब इस्राएली नाय हैं; ");
INSERT INTO thr_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","और ना अब्राहम के बंस होन के बजह से सबै बाके बालका भै, लेकिन लिखो है “इसहाक से तेरो बंस कहलाओ जागो।” ");
INSERT INTO thr_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","जाको मतलब सरीर से पैदा भै बालका परमेस्वर के बालका ना हैं; जाके बजाय, परमेस्वर के वादा के हिसाब से पैदा भै बालका सच्चे बंसज माने जाथैं। ");
INSERT INTO thr_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","परमेस्वर को वादा जे बचन से है: “मैं सई समय मैं दुबारा आंगो, और सारा को लौड़ा होगो।” ");
INSERT INTO thr_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","और जौ काफी ना है; रिबका के दुई लौड़न को बाबा एकै रहै, हमरे पुरखा इसहाक। ");
INSERT INTO thr_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","फिर भी, जासे पहले कि जुड़वा बालका पैदा होमैं या बे कछु अच्छो या बुरो करै, ताकी चुनन मैं परमेस्वर को उद्देस्य खड़ो हुई सकै: ");
INSERT INTO thr_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","काम से नाय, बल्किन बाके जरिये जो बुलाथै-बाकै बताओ गौ रहै, “बड़ो छोटे कि सेवा करै।” ");
INSERT INTO thr_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","जैसो कि सास्त्र मैं लिखो पड़ो है, “मैं याकूब से प्यार करो, पर एसाव कै नफरत करत रहौं।” ");
INSERT INTO thr_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","तौ हम का कहमैं? का परमेस्वर के हिंयाँ अधर्म और अन्याय है? कतई नाय। ");
INSERT INTO thr_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","काहैकि बौ मूसा से कहथै, “मैं जोके ऊपर दया करनो चाहमौं बाके ऊपर दया करंगो, और जो कोई ऊपर किरपा करनो चाहमौं, बहे ऊपर किरपा करंगो।” ");
INSERT INTO thr_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","तौ फिर, जो इंसान चाहथै और जो करथै बाके ऊपर कछु निर्भर नाय करथै, लेकिन खाली परमेस्वर कि दया के ऊपर निर्भर करथै। ");
INSERT INTO thr_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","काहैकि पवित्र सास्त्र मिस्र के राजा फिरौन से कहो गौ, “मैं तोकै तभईये ठड़बाओ हौं कि तेरे मैं हुईकै अपनी सामर्थ्य दिखामौं, और मेरे नाओं को प्रचार पूरी दुनिया मैं होबै।” ");
INSERT INTO thr_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","तभईये परमेस्वर जोकै चाहथै बहे के ऊपर दया करथै, और जोकै चाहथै बाको मन कर्‌रो कर देथै। ");
INSERT INTO thr_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","अब तैं मोसे कहेगो, “बौ फिर से काहेकै इल्जाम लगाथै? कौन बाकी मरजी को सामना करथै?” ");
INSERT INTO thr_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","इंसान, तू भला कौन है जो परमेस्वर को सामना करथै? का गढ़ी भइ कोई चीज गढ़नबारे से कह सकथै, “तैं मोकै ऐसो काहे बनाओ है?” ");
INSERT INTO thr_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","का कुम्हरा कै मट्टी मैं अधिकार ना है कि एकै लोंदा मैं से एक बर्तन आदर के ताहीं, और दुसरेन कै अनादर के ताहीं बनाबै? ");
INSERT INTO thr_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","और परमेस्वर जो करी है बहे सच है; बौ अपने गुस्सा कै दिखानो चात रहै, और अपनी ताकत को परिचय देनो चात रहै; लेकिन बौ बे लोगन कै धीरज देन मैं भोतै धीरज रखत रहै, जो बाके गुस्सा होन कि चीज रहैं, जो बिनास के ताहीं बरबाद रहै। ");
INSERT INTO thr_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","और बौ अपनी प्रचुर महिमा कै दिखानो चात रहै, जोकै हमरे ऊपर डारो गौ रहै जो बाकी दया कि चीज है, हममैं से जिनकै बौ अपनी महिमा पान के ताहीं तैयार करी है। ");
INSERT INTO thr_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","मतलब हमरे ऊपर जिनकै बौ नाय सिरफ गैर यहूदियन मैं से, बल्किन गैर यहूदिन मैं से मस्काईं। ");
INSERT INTO thr_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जैसे कि बौ होसे नाओं कि किताब मैं भी कहथै, जो मेरे लोग ना रहैं, उनकै मैं अपने लोग कहेंगो, और जो लोगन से मैं प्यार नाय करथौं, उनकै प्रिय कहेंगो। ");
INSERT INTO thr_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","और, “ऐसो होगो कि जो जघा मैं उनसे ऐसो कहो गौ रहै कि तुम मेरे लोग नाय हौ, बहे जघा बे जिंदे परमेस्वर के बालका कहे जामंगे।” ");
INSERT INTO thr_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","और यसायाह भविस्यवक्ता इस्राएल देस के बारे मैं चिल्लाए कै कही है, “चाँहे इस्राएल के बालका की गिनती समुंदर के रेता के बराबर होबै, तहुँओं उनमैं से थोड़ी एक बचंगे। ");
INSERT INTO thr_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","काहैकि प्रभु अपनो बचन दुनिया मैं जल्दिये पूरो करैगो।” ");
INSERT INTO thr_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जैसे कि यसायाह भविस्यवक्ता पहले भी कही रहै, “अगर सेना को प्रभु हमरे ताहीं एकौ बंस नाय छोड़तो, तौ हम सदोम के हानी हुई जाते, और अमोरा के हानी होते।” ");
INSERT INTO thr_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","अब हम का कहमैं? कि गैर यहूदि जो धार्मिकता की खोज नाय करत रहैं, धार्मिकता कै लै लईं, यानी की बौ धार्मिकता कै जो बिस्वास से है; ");
INSERT INTO thr_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","लेकिन परमेस्वर के आदमी इस्राएली, जो धर्म के नियम की खोज करत रहैं बौ नियम तक नाय पुगे। ");
INSERT INTO thr_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","कौनके ताहीं? तभईये कि बे बिस्वास से नाय, लेकिन जैसे मानौ करमन से बाकी खोज करत रहैं। और इसलै बे बौ ठोकर के “पथरा से ठोकर खाईं” ");
INSERT INTO thr_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","जैसे कि सास्त्र मैं लिखो है, “देखौ मैं सिय्योन पहाड़ मैं एक ठेस लगन को पथरा, और ठोकर खान की चट्टान रखथौं, और जो बाके ऊपर बिस्वास करैगो बौ कहु उदास नाय होगो।” ");
INSERT INTO thr_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","भईय्यौ और बहेनियौ, मेरे मन की इच्छा और मेरे लोगन के ताहीं परमेस्वर से मेरी प्रार्थना है, कि बे उद्धार पामैं! ");
INSERT INTO thr_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","का काहैकि मैं उनकी गभाई देथौं कि बे परमेस्वर की धुन मैं रहथैं, पर अकल के ताहीं नाय। ");
INSERT INTO thr_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","काहैकि बे परमेस्वर की धार्मिकता से अनजान हुईकै, और अपनी धार्मिकता बनान ताहीं खूबै कोसिस करकै, परमेस्वर की धार्मिकता के हवाले नाय भै। ");
INSERT INTO thr_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","काहैकि मसीह नियम कै खतम कर दई है, ताकी जो कोई बिस्वास करथै, बौ परमेस्वर के सामने धार्मिक ठहराओ जाथै। ");
INSERT INTO thr_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","काहैकि मूसा जौ लिखी है कि जो इंसान बौ धार्मिकता मैं जो नियम से है चलथै, बौ बहे से जिंदो रहबैगो। ");
INSERT INTO thr_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","लेकिन जो धार्मिकता बिस्वास से है, बौ ऐसे कहथै, “तैं अपने मन मैं जौ मत कहिये कि स्वर्ग मैं कौन जागो?” मतलब मसीह कै उतार लान ताहीं! ");
INSERT INTO thr_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","या अधोलोक मैं कौन आगो? मतलब कि ईसु मसीह कै मरे भौ मैं से जिंदो करकै ऊपर लान ताहीं। ");
INSERT INTO thr_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","लेकिन बौ का कहथै? जौ कि “बचन तेरे झोने है, तेरे मोहों और मन मैं है,” जौ बहे बिस्वास को बचन है, जोको हम प्रचार करथैं। ");
INSERT INTO thr_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","कि अगर तैं अपने मोहों से ईसु कै प्रभु मानकै अंगीकार करै मतलब ईसु कै प्रभु मानिये लेबै और अपने मन मैं बिस्वास करकै कि परमेस्वर बाकै मरे भैन मैं से जिंदो करी है, तौ तू सच्ची मैं उद्धार पायगो। ");
INSERT INTO thr_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","काहैकि धार्मिकता के ताहीं मन से बिस्वास करो जाथै, और उद्धार के ताहीं मोहों से अंगीकार करो जाथै। ");
INSERT INTO thr_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","पवित्र सास्त्र ऐसो कहथै कि, “जो भी चाँहे जो होबै ईसु मैं बिस्वास करैगो बौ कहु सर्मिंदा ना होगो।” ");
INSERT INTO thr_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","यहूदियन और यूनानिन मैं कछु भेद हईये नाय, तभई तौ बौ सबन को प्रभु है और अपने सब नाओं लेन बारेन के ताहीं इमानदार है। ");
INSERT INTO thr_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","जैसो कि पवित्र सास्त्र कहथै, “जो कोई भी मदत के ताहीं प्रभु कै पुकारैगो, बौ बच जाबैगो।” ");
INSERT INTO thr_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","पर जोके ऊपर बिस्वास नाय करीं, बे बाको नाओं काहेकै लेमैं? और जोके बारे मैं सुनिये नाय बाके ऊपर कैसे करकै बिस्वास करैं? और प्रचार करन बारे के बिना कैसे सुनैं? ");
INSERT INTO thr_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","और अगर भेजे ना जामैं, तौ कैसे प्रचार करैं? जैसे कि सास्त्र कहथै, “उनकी टाँग कैसी सुहानी हैं, जो अच्छी बातन को सुसमाचार सुनाथैं।” ");
INSERT INTO thr_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","लेकिन जितने हैं सुसमाचार मैं कान नाय लगाईं: यसायाह भविस्यवक्ता कहथै, “प्रभु, कौन है जो हमरे समाचार मैं बिस्वास करी है?” ");
INSERT INTO thr_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","अब बिस्वास सुनन से और सुननो मसीह ईसु के बचन से होथै। ");
INSERT INTO thr_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","लेकिन मैं कहथौं, का बे नाय सुनीं? सुनीं तौ जरूरै हैं, काहैकि सास्त्र मैं लिखो है, “उनकी अबाज पूरी पृथ्वी मैं, और बाके बचन दुनिया की छोर ले पुग गै हैं।” ");
INSERT INTO thr_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","मैं फिर पूछथौं: का इस्राएल के लोग नाय समझथैं? पहले तौ मूसा भविस्यवक्ता कहथै, “मैं उनसे जो जाति मेरी ना है, तुमरे मन मैं जलन भरंगो; और मूर्खन के देस के जरिये मैं मूढ़ी लोगन से तुमकै खिजरबांगो।” ");
INSERT INTO thr_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","फिरौंकी यसायाह भविस्यवक्ता खूब हिम्मत दैकै कहथै, “जो मोकै ना ढूँड़त रहैं, बे मोकै पायलईं; और जो मोकै पूँछत तक नाय रहैं, उनके ऊपर मैं दिखाई दौ।” ");
INSERT INTO thr_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","लेकिन इस्राएल के बारे मैं बौ ऐसो कहथै, “मैं अपनो हात पूरे दिन एक आग्या ना मानन बारी और बहस करन बारे लोगन के घाँईं फैलाय रखाओ।” ");
INSERT INTO thr_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","मैं पूछथौं, तौ: का परमेस्वर अपने लोगन कै ना अपनाई? कतईये नाय! मैं खुद एक इस्राएल हौं अब्राहम को बंस और बिन्यामीन के बंस को एक सदस्य हौं। ");
INSERT INTO thr_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेस्वर अपने लोगन कै नाय छोड़ी है, जोकै बौ पहलिये से चुनी। तुम जानथौ कि पवित्र सास्त्र एलिय्याह भविस्यवक्ता के बारे मैं का कहथै, जितै बौ इस्राएल के बिरोध मैं परमेस्वर से प्रार्थना करी: ");
INSERT INTO thr_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“हे प्रभु, बे तेरे भविस्यवक्तन कै मार डारी हैं और तेरी बेदियन कै गिराय दईं हैं; मैं सिरफ एकै बचो हौं, और बे मेरी ज्यान लेन की कोसिस कर्‌रै हैं।” ");
INSERT INTO thr_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","परमेस्वर बाकै का जबाब दई? “मैं अपने ताहीं सात हजार आदमियन को ख्याल लौ हौं जो झूठे बाल देवतन की पूजा नाय करी हैं।” ");
INSERT INTO thr_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","जौ अब बहे तरह है: बे लोगन की एक छोटी संख्या बची है जिनकै परमेस्वर उनके अनुग्रह और किरपा के कारड़ चुनी है। ");
INSERT INTO thr_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","उनकी पसंद अनुग्रह मैं आधारित है, बे जो करी हैं बामै नाय। अगर परमेस्वर की पसंद मैं लोग का करथैं, जाके आधार मैं, तौ उनकी किरपा सच्ची की किरपा नाय होगी। ");
INSERT INTO thr_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","तौ का? इस्राएली लोग जोकै ढूँड़त रहैं, बौ उनकै नाय मिलो, जौ एक छोटो झुंड रहै जोकै परमेस्वर चुनी, जो जाकै पाई; बाकी परमेस्वर के बुलान मैं बैहरा हुईगै। ");
INSERT INTO thr_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जैसे कि सास्त्र मैं लिखो है, “परमेस्वर उनके मन और दिलन कै मंद बनाये दई; जौ दिन बे देख और सुन नाय सकथैं।” ");
INSERT INTO thr_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","और राजा दाऊद कहथै, “उनको खानु उनके ताहीं जार है; बे गिर सकथैं, उनकै सजा दौ जाए सकथै! ");
INSERT INTO thr_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","उनकी आँखिन कै अंधो कर दौ जाबै ताकी बे देखिये नाय पामैं; और तैं हमेसा उनकै परेसानी के ताहीं नीचे झुकाए रखाबै।” ");
INSERT INTO thr_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","मैं पूँछथौ, तौ: जब यहूदि लड़खड़ाय गै, तौ का बे अपने खंडर मैं गिर गै? कैसियौ नाय! बे पाप करीं, गैर यहूदि लोगन के ताहीं उद्धार आओ है, तही के मारे यहूदियन कै उनसे जलन होथै। ");
INSERT INTO thr_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","यहूदियन को पाप दुनिया कै खूब आर्सिवाद दई, और उनकी आध्यात्मिक गरीबी गैर यहूदियन कै खूब आर्सिवाद दई। फिरौंकी, यहूदियन की पूरी संख्या मैं सामिल होन से आर्सिवाद कित्तो बड़ो होगो! ");
INSERT INTO thr_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","गैर यहूदियौ मैं तुमसे अब बात कर रहो हौं: जबले मैं गैर यहूदियन के ताहीं प्रेरित हौं, मैं अपने सेवा के बड़ाँईं के काम मैं गरब करंगो। ");
INSERT INTO thr_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","सायद मैं अपनी जाति के लोगन के अंदर जलन पैदा कर सकथौं, और तभई उनमैं से कुछन कै बचान मैं काबिल हौं। ");
INSERT INTO thr_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","जब उनकै नाय अपनाओ गौ, तौ दुनिया के सबै लोग परमेस्वर के दुस्मन से दोस्त मैं बदल गै। तौ का होगो जब उनकै अपनाय लौ जागो। जौ मरे भैन के ताहीं जिंदगी होगी! ");
INSERT INTO thr_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","अगर पवित्र रोटी को पहलो टुकड़ा परमेस्वर के दौ जाथै, तौ पूरी पवित्र रोटी बहे की है; और अगर रूखन की जड़ैं परमेस्वर कै चढ़ाई जाथैं, तौ हँगईय्यौ बहे की हैं। ");
INSERT INTO thr_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","खेती करी भइ जैतून के पेंड़ की एकाद हँगईय्या कै तोड़ दौ गौ है, और बन के जैतून के जड़ की एक हँगईय्या जामैं मिल गई है। तुम गैर यहूदि जंगली जैतून के पेंड़ के हानी हैं, और अब तुम यहूदियन के भागीदार भै। ");
INSERT INTO thr_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","तौ तुमकै बे लोगन से नफरत नाय करनो चाहिए जो डंघईय्यन के जैसी टूट गै रहैं। तुम कैसे घमंड कर सकथौ? तुम सिरफ एक डंघा हौ; तुम जड़न कै नाय पकड़े हौ पर जड़ैं तुमकै पकड़े हैं। ");
INSERT INTO thr_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","पर तैं कहबैगो, “हाँ, पर मेरे ताहीं जघा बनान के ताहीं हँगईय्यन कै तोड़ दौ गौ रहै।” ");
INSERT INTO thr_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","सई है, बिस्वास ना होन की बजह से बे टूट गै; जब तुम जघा मैं बने रैहथौ काहैकि तुम बिस्वास करथौ। लेकिन तैं घमंडी मत बनै, पर जाके बजाय डर मान। ");
INSERT INTO thr_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","परमेस्वर यहूदियन कै नाय छोड़ी, जो प्राकृतिक डंघईय्यन के हानी हैं; का तोकै लगथै कि बौ तोए छोड़ देगो? ");
INSERT INTO thr_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","हींना हम देखथैं कि परमेस्वर कित्ते दयालु और गंभीर हैं। बौ बे लोगन के ताहीं गंभीर है जो गिर गै हैं लेकिन तुमरे ऊपर दया करथै अगर तुम बाकी दयालुता बनाये रखाथौ तौ। लेकिन अगर तुम नाय करथौ, तौ तुम्हऊँ टूट जागे। ");
INSERT INTO thr_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","और अगर यहूदि उनके अविस्वास कै छोड़ दईं, उनकै फिरौंकी से बहे जघा रखो जागो जितै बे रहैं; काहैकि परमेस्वर ऐसो करन के काबिल है। ");
INSERT INTO thr_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","तुम गैर यहूदियौ एक जंगली जैतून के पेंड़ की डंघईय्यन के जैसी होथौ जो टूट जाथै और फिरौंकी, प्रकृति से हटकै, एक खेती जैतून के रूखा मैं मिलगौ है। यहूदि जौ खेती के रूखा के जैसी हैं; और परमेस्वर के ताहीं जे टूटी-फूटी डंघईय्यन कै फिरसे अपने रूखा के संग जोड़न के ताहीं सरल हुई जागो। ");
INSERT INTO thr_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","भईय्यौ और बहेनियौ, एक लुकी भइ सच्चाई है, जोमैं तुमकै बतानो चाहथौं, ऐसो है जौ तुमकै ऐसे करकै सोचन से बचागो कि तुम कित्ते ग्यानवान हौ। ऐसो है कि इस्राएल देस के लोगन की जिद टिकी भइ नाय है, पर इनकी जिद तौले चलैगी जबले गैर यहूदि की पूरी संख्या परमेस्वर के झोने ना आए जाबै। ");
INSERT INTO thr_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","और ऐसो करकै पूरो इस्राएल कै बचाओ जागो। जैसे कि सास्त्र मैं लिखो है, “उद्धारकर्ता सिय्योन पहाड़ से आगो, और याकूब के बंसज से बुरी बात दूर करैगो। ");
INSERT INTO thr_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","और उनके संग मेरो जहे वाचा होगो, जब खिन मैं उनके पापन कै दूर कर देंगो।” ");
INSERT INTO thr_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","काहैकि बे सुसमाचार कै नकारथैं, यहूदि तुम मैं गैर यहूदि ताहीं परमेस्वर के दुस्मीं हैं। लेकिन परमेस्वर के चुनन के बजह से, बे अपने परखन के बजह से प्रिय हैं। ");
INSERT INTO thr_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","परमेस्वर अपनो मन नाय बदलथै, जोकै बौ चुनथै और आर्सिवाद को उपहार देथै। ");
INSERT INTO thr_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","जैसी की तुम गैर यहूदियन के ताहीं, तुम पहले परमेस्वर की आग्या नाय माने रहौ; लेकिन हबै उनके आग्या नाय मानन से तुमरे ऊपर दया भइ। ");
INSERT INTO thr_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","बैसिये दया की बजह से जो तुमकै मिलो है, यहूदि अब परमेस्वर की आग्या ना मानथैं, ताकी अब बेऊँ परमेस्वर की दया पाय सकैं। ");
INSERT INTO thr_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","परमेस्वर सबन कै आग्या नाय मानन के बजह से भाँद लई है, ताकी बौ सबन के ऊपर दया करै। ");
INSERT INTO thr_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","परमेस्वर को धन कित्तो महान है! बाकी बुद्धि और ग्यान कैसो गहरो है! बाके फैसलन को बखान कौन कर सकथै? बाके तरीका कौन समझ सकथै? ");
INSERT INTO thr_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","जैसे कि सास्त्र मैं लिखो है: “प्रभु के मन कै कौन जानथै? कौन बाकै सलाह देन मैं काबिल है? ");
INSERT INTO thr_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","कौन बाकै कहु कछु दई है, ताकी बाकै बापस भुगतान करन पड़ै?” ");
INSERT INTO thr_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","काहैकि बहे के घाँईं से, और बहे से, और बहे के ताहीं सब कछु है। सच मैं बाकी महिमा हमेसा-हमेसा होत रहबै! आमीन। ");
INSERT INTO thr_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","तभईये, भईय्यौ और बहेनियौ, मैं तुमसे परमेस्वर की दया याद करबाय कै नहोरे करथौं कि अपने सरीर कै जिंदो, और पवित्र, और परमेस्वर कै मन से लगन बारो बलिदान करकै चढ़ाबौ। जहे तुमरी आत्मिक सेवा है। ");
INSERT INTO thr_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","जौ युग के जैसे मत बनौ; लेकिन तुमरे मन के नये हुई जान से तुमरो चालचलनौ बदलत जाबै, जोसे तुम परमेस्वर कै अच्छी, और बाकै भान बारी, और परख की सिद्ध इच्छा अनुभव से मालुम करत रहबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","काहैकि मैं बहे अनुग्रह के बजह से जो मोकै मिलो है, तुम जितने हौ सबन से कहथौं, कि जैसो समझनो चाहिए, बासे जाधे कोई अपने आपकै नाय समझै; जाके अलावा अपनी सोच मैं विनम्र बनौ, लेकिन जैसे परमेस्वर सबन कै बिस्वास से नाप तौल से बाँट दई है, बैसिये सई बुद्धि के संग अपने आपकै आकैं। ");
INSERT INTO thr_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","जैसे हमरे सरीर मैं भौत से अंग हैं, और सब अंगन को एक सो काम नाय है। ");
INSERT INTO thr_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","बैसिये हमउँ निरे हैं, मसीह मैं एक सरीर हुईकै आपसै मैं एक सरीर के अलग-अलग अंग हैं। ");
INSERT INTO thr_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","इसलै हम अपने अलग-अलग उपहार को इस्तमाल बौ अनुग्रह के हिसाब से करथैं, जो परमेस्वर हमकै दई है; अगर हमरो उपहार परमेस्वर के संदेस कै बोलनो है, तौ हमकै बौ बिस्वास के हिसाब से करनो चाहिए जो हमरे पास है; ");
INSERT INTO thr_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","अगर सेवा करन को दान मिलो है, तौ बौ सेवा करत रहबै, अगर कोई सिखान बारो है, तौ सिखातै रहबै; ");
INSERT INTO thr_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","जो हौंसला देथै, बे हौंसला देत रहमैं; और दान देनबारे इच्छा से देमैं, जो अगुवाई करै, बौ कड़ी मेहनत से करै, जो कोई दया दिखाथै, बौ खुसी से दया दिखाबै। ");
INSERT INTO thr_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","प्यार पूरी तरह से इमानदारी से होने चाहिए, जो बुराई है बासे नफरत करौ, जो अच्छो है बाकै पकड़ौ। ");
INSERT INTO thr_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","एक दुसरे से मसीह भईय्यौ और बहेनियन के हानी प्यार करैं; एक दुसरे को आदर करन मैं एक दुसरे से बढ़त चले जाबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","कड़ी मेहनत करैं और आलसी ना बनै; आत्मिक धुन और हौंसला से भरे रहबौ प्रभु की सेवा करत रहबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","आसा मैं खुस रहबौ; कलेस मैं टिके रहबौ; प्रार्थना हमेसा करत रहबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","परमेस्वर के पवित्र लोगन कै जो-जो चीजन की जरूरत होबै, बामै उन सबन की मदत करौ; खातिरदारी करत रहबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","अपने सतान बारेन कै आसीस देबौ; हाँ, आसीस देबौ बद्‌दुआ मत देबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","खुसी मनान बारेन के संग खुसी मनाबौ, और रोन बारेन के संग रोबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","आपस मैं एकै सो मन और सोच रखाबौ; घमंडी मत होबौ, लेकिन गरीबन के संग भी संगती रखन को मन रखौ; खुद की नजर मैं ग्यानी मत बनौ। ");
INSERT INTO thr_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","बुराई के बदला मैं बुराई मत करौ; जो-जो बात सबन के ताहीं भली हैं, उनकी चिंता करौ। ");
INSERT INTO thr_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जित्तो हुई सकै, तुम सब आदमिन के संग मेल करकै रहबौ। ");
INSERT INTO thr_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","मेरे प्रिय भईय्यौ, बहेनियौ, बदला मत लियो, लेकिन परमेस्वर के गुस्सा कै मौका देबौ, काहैकि सास्त्र मैं लिखो है, “बदला लेनो मेरो काम है, प्रभु कहथै महीं बदला लेंगो।” ");
INSERT INTO thr_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","लेकिन “अगर तेरो बैरी भूंको होबै तौ बाकै खानु खबा, और अगर प्यासो होबै तौ बाकै पानी पिबा; काहैकि ऐसो करन से तू बाकी मुड़िया मैं आगी के अंगरन की ढ़ेरी लगागो।” ");
INSERT INTO thr_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","बुराई से मत हारियो, पर भले काम करकै बुराई कै जीत लियो। ");
INSERT INTO thr_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","सबै आदमी अपने आप सासकीय अधिकारियन के सुपर्त रहमैं, काहैकि कोई को अधिकार ऐसो हईये नाय जो परमेस्वर के घाँईं से ना होबै; और जो अधिकार हैं, बे परमेस्वर के बनाये भै हैं। ");
INSERT INTO thr_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","तभईये जो भी कोई अधिकार को बिरोध करथै, बौ परमेस्वर के नियम को सामना करथै, और सामना करन बारे सजा पामंगे। ");
INSERT INTO thr_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","पर सासक अच्छे काम के ताहीं नाय, पर बुरे काम के ताहीं डर को कारड़ हैं; अगर तुम अधिकारिन से डरानो नाय चाहथौ तौ अच्छे काम करौ। और जो ताहीं है बहे करौ, तौ बे तुमरी बड़ाँईं करंगे, ");
INSERT INTO thr_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","काहैकि बौ तेरी भलाई ताहीं परमेस्वर को सेवा करन बारो है। लेकिन अगर तैं बुरे काम करथै तौ-तौ डरा, काहैकि बे तलवार खालिमूलि मैं नाय लै हैं; और परमेस्वर की सेवा करन बारे सेवक हैं कि बाके गुस्सा से बुरे काम करन बारेन कै सजा देबै। ");
INSERT INTO thr_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","तभईये अधिकारिन के सुपर्त मैं रहनो नाय सिरफ बाके गुस्सा के डर से जरूरी है, बल्किन विवेक भी जहे गभाई देथै। ");
INSERT INTO thr_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","तभईये चुंगी भी देबौ काहैकि सासन करन बारे परमेस्वर की सेवा करन बारे हैं और हमेसा जहे काम करत रहथैं। ");
INSERT INTO thr_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","जहे बजह से उनको कर्तव्य उनकै दे करौ; जोकै चुंगी चहाईये बाकै, चुंगी देबौ; जोसे डरानो चहाईये, बासे डराबौ; जोको आदर करनो चहाईये, बाको आदर करौ। ");
INSERT INTO thr_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","आपस के प्यार कै छोड़ और कोई सी बात मैं कोई के कर्जदार मत हुइयो; काहैकि जो दूसरेन से प्यार करथै, बहे नियम कै मानी है। ");
INSERT INTO thr_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","काहैकि “व्यभिचार मत करियो, हत्या मत करियो, चोरी मत करियो, लालचौ मत करियो,” और इनकै छोड़कै औरौ कोई सी आग्या होबै तौ जौ पूरे को तोड़ जौ बात मैं मिलथै, कि “अपने पड़ोसियन से अपनेई हानी प्यार करियो।” ");
INSERT INTO thr_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","प्यारै है जो पड़ोसियन की कछु बुराई नाय करथै, तभईये प्यार रखनो तौ नियम कै माननो है। ");
INSERT INTO thr_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","समय कै देखभार कै ऐसियै करौ, तभई कि अब तुमरे ताहीं नींद से जगन की बेरा आए गई है; काहैकि जो घड़ी हम बिस्वास करे रहैं, बौ समय की सोच से अब आपन को उद्धार झोने है। ");
INSERT INTO thr_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","रात बीतन बारी है, और दिन निकरन बारो है; तभई हम अंधियारे के कामन कै छोड़कै उजीतो के हथियार भाँद लेमैं। ");
INSERT INTO thr_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","जो-जो दिन जैसे-जैसे सोभा देथैं, बैसिये हम सई ढंग से चलैं, ना कि मौज मस्ती और पीन-पान मैं, ना व्यभिचार, और ना घटिया काम करन मैं, और लड़ाई और नफरत से दूर रहमैं। ");
INSERT INTO thr_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","बल्किन प्रभु ईसु मसीह कै पहन लेबौ, और सरीर की इच्छन कै पूरो करन को मत सोचौ। ");
INSERT INTO thr_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","जो बिस्वास मैं कमजोर हैं, उनकै अपने अच्छे विवेक के चाल-चलन मैं मिलाए लेबौ, लेकिन उनकी राय मैं बहस करन के ताहीं नाय। ");
INSERT INTO thr_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","कोई कै बिस्वास है कि सब कछु खानो सई है, लेकिन जो बिस्वास मैं कमजोर हैं सागपात खाथैं। ");
INSERT INTO thr_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","सब कछु खान बारो ना खान बारे के ऊपर दोस लगान को फैसला ना करे और ना खान बारो सब कछु खान बारे के ऊपर दोस ना लगाबै; काहैकि परमेस्वर बाकै अपनाय लई है। ");
INSERT INTO thr_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","तू कौन है जो दुसरेन की सेवा करन बारेन के ऊपर दोस लगाथै? बाको बनो रहनो या गिर जानो बाके मालिक से रिस्ता रखथै; बल्किन बौ एकै जघा कर दौ जागो; काहैकि न्याई प्रभु बाकै टिकाय सकथै। ");
INSERT INTO thr_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","कोई तौ एक दिन कै दुसरे दिन से बढ़कै मानथैं और कोई तौ सबै दिनन कै एक जैसो मानथैं। सबै अपने-अपने दिमाक मैं का बिस्वास करने है बाकै जानन ताहीं फैसला करनो जरूरी है। ");
INSERT INTO thr_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","जो, जे दिन कै मानथैं; बौ प्रभु के ताहीं मानथैं। जो मन से खाथैं, बे प्रभु के ताहीं खाथैं, काहैकि बे परमेस्वर को धन्यवाद करथैं, और जो नाय खाथैं बेऊँ प्रभु के ताहीं नाय खाथैं और परमेस्वर को धन्यवाद करथैं। ");
INSERT INTO thr_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","काहैकि हममैं से ना तौ कोई अपने ताहीं जीथै और ना कोई अपने ताहीं मरथै। ");
INSERT INTO thr_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","अगर हम जिंदे हैं तौ प्रभु के ताहीं जिंदे हैं; और अगर मरथैं तौ, प्रभु के ताहीं मरथैं; अब चाँहे हम मरैं या जीमैं प्रभुए के हैं। ");
INSERT INTO thr_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","काहैकि मसीह तभई मरो और जिंदो भी भौ कि बौ मरे भैन और जिंदेन दोनों को प्रभु होबै। ");
INSERT INTO thr_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","फिर तुम, जो खाली साग सब्जी खाथैं, तुम दुसरेन के ताहीं फैसला काहे सुनाथौ? और तुम जो कुछ भी खाथौ, तुम दुसरे विस्वासी भईय्यन को तिरस्कार काहेकै करथौ? हम सब परमेस्वर के सामने खड़े होंगे कि बाके जरिये न्याय करो जाबै। ");
INSERT INTO thr_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","काहैकि सास्त्र मैं लिखो है, प्रभु कहथै, “जैसे मैं हमेसा से जिंदो परमेस्वर हौं, सबै मेरे अग्गु घूँटे टेक देंगे, और सबन की जीब परमेस्वर को अंगीकार करैगी कि महीं परमेस्वर हौं।” ");
INSERT INTO thr_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","तभईये हम सबन मैं से सबै परमेस्वर कै अपनो-अपनो हिसाब देमंगे। ");
INSERT INTO thr_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","अब हम एक दुसरे के ऊपर दोस ना लगामैं, लेकिन तुम जौ ठान लेबौ कि खुद से कहु ऐसो करन को फैसला नाय करनो चाहिए, जोसे दुसरे भईय्यन कै ठोकर लगै या बे पाप मैं गिरैं। ");
INSERT INTO thr_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","मैं जानथौं और प्रभु ईसु को चेला होन के नाते मेरो बिस्वास है कि कोई चीज अपने आप से असुद्ध ना है, लेकिन जो बाकै असुद्ध समझथै बाके ताहीं असुद्ध है। ");
INSERT INTO thr_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","अगर तुमरे कोई चीज के खान से तुम दुसरे भईय्यन कै ठेस पहोंचाथौ, तौ तुम प्यार से नाय चलथौ। अगर कोई कै बुरो लगथै तौ बौ चीज खान कै मत देबौ नाय तौ तुम बौ आदमी कै बरबाद करथौ, जोके ताहीं ईसु मसीह मर गौ रहै। ");
INSERT INTO thr_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","अब जो तुमरे ताहीं भलो है बाकी बुराई मत करौ। ");
INSERT INTO thr_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","काहैकि परमेस्वर को राज्य खान-पीन को ना है, लेकिन धर्म और मेल-मिलाप और बौ खुसी सांति को है जो पवित्र आत्मा से मिलथै। ");
INSERT INTO thr_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","जो ऐसे करकै मसीह ईसु की सेवा करथै बौ परमेस्वर कै भाथै और इंसानन के बीच मैं अपनाओ जाथै। ");
INSERT INTO thr_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","इसलै हम उन बातन मैं लगे रहमैं, जोसे सांति कै बढ़ावा मिलथै और जिनके जरिये हम एक-दूसरे को निर्माड़ कर सकैं। ");
INSERT INTO thr_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","खान-पीन के ताहीं परमेस्वर को काम मत बिगाड़ै। सब कछु सुद्ध तौ है, लेकिन ऐसो कछु नाय खानो चाहिए जो कोई और कै पाप मैं डार देबै। ");
INSERT INTO thr_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ठीक तौ जौ है कि तू ना तौ सिकार खा और ना दाखरस पी, और नाय कछु ऐसो कर जोसे तेरो भईय्या और बहेनिया ठोकर खाबै। ");
INSERT INTO thr_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","तेरो जो बिस्वास होबै, बाकै परमेस्वर के अग्गु अपनेई मन मैं धर। धन्य है बौ जो बौ बात मैं, जोकै बौ सई समझथै, और बाके परखे जाने मैं गलत ना बताथै! ");
INSERT INTO thr_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","पर जो संका करकै खाथै, बौ सजा देन ताहीं हुई चुको, काहैकि बौ बिस्वास से नाय खाथै; और जो कछु बिस्वास से नाय है, बौ पाप है। ");
INSERT INTO thr_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","हम जो बिस्वास मैं मजबूत हैं उनकै अपनो बोझ ढोन के ताहीं मदत करनो चाहिए। हमैं खुदकै खुस नाय करनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","जाके अलावा हम सब भईय्या और बहेनियन कै बिस्वास मैं बढ़ान के ताहीं उनकी भलाई के लै दुसरे विस्वासियन कै खुस करनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","काहैकि मसीह महिमा के ताहीं खुस नाय करी, जाके बजाय, जैसो सास्त्र मैं लिखो है: “जो अनादर तेरो भौ है, बौ मेरे ऊपर भौ है।” ");
INSERT INTO thr_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","सास्त्र मैं लिखी हर बात हमैं पढ़ान के ताहीं लिखी गई है, कि आदेस मैं हम धीरज और प्रोत्साहन के जरिया से आसा कर सकथैं जो सास्त्र हमैं देथै। ");
INSERT INTO thr_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","और परमेस्वर धीरज और प्रोत्साहन कै देन बारो है, ईसु मसीह के उदाहरड़ कै अपनाय कै आपस मैं एक जैसी सोच के जरिया देखन मैं काबिल होबौ, ");
INSERT INTO thr_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","जोसे तुम सब मिलकै और एक सुर मैं हमरे प्रभु ईसु मसीह और परमपिता परमेस्वर की महिमा करौ। ");
INSERT INTO thr_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","फिरौंकी, परमेस्वर की महिमा के ताहीं, एक दुसरे कै अपनाय लियौ, जैसे मसीह भी तुमकै अपनाई है। ");
INSERT INTO thr_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","काहैकि मैं तुमसे कहथौं, कि परमेस्वर की सच्चाई के घाँईं से मसीह यहूदिन को सेवक बनो, कि पुरखन से करे गै वादा कै पूरो करो जाबै, ");
INSERT INTO thr_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","और गैर यहूदियन कै भी बाकी दया के ताहीं परमेस्वर की महिमा करन के काबिल बनाने है। जैसी कि सास्त्रन मैं लिखो है: “तभईये मैं गैर यहूदियन मैं तुमरी बड़ाँईं करंगो; और तेरे नाओं को गीत गांगो।” ");
INSERT INTO thr_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","फिर से कही है, “गैर यहूदियौ, परमेस्वर के संग खुसी मनाबौ!” ");
INSERT INTO thr_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","और फिर “गैर यहूदियौ, प्रभु की स्तुति करौ; सब जनी बाकी प्रसंसा करौ!” ");
INSERT INTO thr_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","और फिरौंकी यसायाह भविस्यवक्तौ कहथै, “यिसै के घराने की जड़ दिखाई देबैगी, और गैर यहूदियन को सासन होन के ताहीं एक उठैगो, बाके ऊपर बे आस लगाए रखांगे।” ");
INSERT INTO thr_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","परमेस्वर जो आसा को देन बारो है तुमकै बिस्वास करन मैं सब हानी खुसी और सांति से भरै, कि पवित्र आत्मा की सामर्थ्य से तुमरी आसा बढ़त चली जाबै। ");
INSERT INTO thr_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","मेरे भईय्यौ और बहेनियौ; मैं पक्को बिस्वास है कि तुम लोग भलाई से भरे हौ, और तुमरियौ पास ग्यान है, और तुम एक दुसरे कै सिखान ताहीं समझाए सकथौ। ");
INSERT INTO thr_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तहुँओं मैं कहु-कभार याद दिबान ताहीं तुमकै जौ खूबै हिम्मत करकै लिखो हौं, जौ बौ अनुग्रह के कारड़ भौ, जो परमेस्वर मोकै सामर्थ्य दई है। ");
INSERT INTO thr_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","कि मैं गैर यहूदि के ताहीं मसीह ईसु को सेवक हुईकै परमेस्वर के सुसमाचार की सेवा पुजारी के हानी करौं; कि गैर यहूदि पवित्र आत्मा के जरिये बाकै समर्पित करी गई भेंट होमैं, जो परमेस्वर के भाँति है। ");
INSERT INTO thr_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","तभईये बे बातन के बारे मैं जो परमेस्वर से जुड़ी हैं, मैं मसीह ईसु मैं बड़ाँईं कर सकथौं। ");
INSERT INTO thr_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","मैं निडर रैहंगो और खाली बाके बारे मैं बोलंगो जो मसीह परमेस्वर के हुकम को पालन करन के ताहीं गैर यहूदियन के अगुवाई मैं करी है। मसीह सब्दन और करमन के जरिये ऐसो करी है, ");
INSERT INTO thr_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","और चिन्ह, अचम्मे कामन से और परमेस्वर के आत्मा के सामर्थ्य से पूरे करे गै हैं। हिंयाँ तक मैं यरूसलेम से लैकै सबै घाँईं इल्लुरिकुम तक मसीह के सुसमाचार कै पूरो फैलाओ। ");
INSERT INTO thr_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","पर मेरो मन जौ है, कि जितै-जितै मसीह को नाओं नाय लौ गौ, हूँनै सुसमाचार सुनामौ; ऐसो ना होबै, कि दुसरेन की बुनियाद मैं घर बनामौं। ");
INSERT INTO thr_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","लेकिन जैसो सास्त्र मैं लिखो है: “जोके बारे मैं नाय बताओ गौ रहै, बे देखंगे, और जो नाय सुनीं बेईं समझंगे।” ");
INSERT INTO thr_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","और तभईये मोकै निरे दाँव तुमरे झोने आन से रोक रखाईं रहैं। ");
INSERT INTO thr_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","लेकिन अब जे देसन मैं मेरे काम के ताहीं जघा ना रइ, और निरे सालन से मेरो तुमरे झोने आन को मन रहै, ");
INSERT INTO thr_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","और बौ अभई करन कि आसा रखथौं। तभईये जब मैं स्पेन देस जांगो तौ तुमरे झोने होत भौ जांगो, काहैकि मोकै आसा है कि सफर मैं तुमसे भेंटा करंगो, और जब तुमरी संगती से थोड़ी सो मेरी इच्छा भर जागी, तौ तुम्हईं मोकै थोड़ी दूर अग्गु पनार दियो। ");
INSERT INTO thr_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","लेकिन हबै तौ पवित्र आदमिन की सेवा करन ताहीं यरूसलेम नगर कै जाथौं। ");
INSERT INTO thr_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","काहैकि मकिदुनिया और अखाया कलीसिया के आदमिन कै अच्छो लगो, कि यरूसलेम नगर के परमेस्वर के पवित्र लोगन के कंगालन की सहभागिता मैं कछु चन्दा देमैं। ");
INSERT INTO thr_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","बे अपने मन से जौ करीं; पर बे उनके कर्जदार भी हैं, काहैकि अगर गैर यहूदि उनकी आत्मिक बातन मैं मिले भै हैं, तौ उन्हऊँ के ताहीं सई है, कि सरीर की बातन मैं उनकी सेवा करैं। ");
INSERT INTO thr_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","तभईये जौ छाप और काम मैं पूरो करकै और उनको जौ चन्दा दैकै तुमरे घाँईं से होत भौ स्पेन कै चलो जांगो। ");
INSERT INTO thr_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","और मैं जानथौं, कि जब मैं तुमरे झोने आंगो, तौ मसीह की पूरी आसीस के संग आंगो। ");
INSERT INTO thr_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","और भईय्यौ और बहेनियौ, मैं ईसु मसीह कै जो हमरो प्रभु है और पवित्र आत्मा के प्यार कै याद दिबाए कै, तुमसे नहोरे करथौं: कि मेरे ताहीं परमेस्वर से प्रार्थना करन मैं मेरे संग मिलकै डटे रहाबौ। ");
INSERT INTO thr_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","प्रार्थना करैं कि मैं यहूदिया देस के अविस्वासियन से बचो रहामौ, और मेरी बौ सेवा जो यरूसलेम के ताहीं है, पवित्र आदमी अपनाय लेमैं। ");
INSERT INTO thr_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","और मैं परमेस्वर की इच्छा से तुमरे झोने खुसी से आयकै तुमरे झोने सस्तामौं। ");
INSERT INTO thr_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","सांति को परमेस्वर सच्ची मैं तुम सबन के संग रहबै। आमीन। ");
INSERT INTO thr_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","मैं तुमकै हमरी बहेनिया फीबे कै सौंपथौं, जो किंख्रिया मैं कलीसिया की सेवकी है। ");
INSERT INTO thr_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","जैसी तुम पवित्र आदमिन कै अपनाथौ, बैसिये प्रभु मैं बाकै अपनाबौ; और जो-जो बात मैं बाकै तुमरी जरूरत होबै, बाकी मदत करौ, काहैकि बहो निरेन की बल्किन मेरियौ मदत करी रहै। ");
INSERT INTO thr_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","प्रिस्किल्ला और अक्विला कै जो ईसु मसीह मैं मेरे संग काम करन बारे हैं, नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","बे मेरे ताहीं अपनी ज्यान कै खतरा मैं डारथैं, मैं उनको बड़ा एहसान मंद हौं, और नाय सिरफ महीं, बल्किन गैर यहूदि की सबै कलीसियौ उनको धन्यवाद करथैं। ");
INSERT INTO thr_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","और बहो कलीसिया कै नमस्ते जो उनके घर मैं बनी हैं। मेरे प्रिय दिलबर इपैनितुस (इफिसुस) कै जो मसीह के ताहीं आसिया को पहलो फल है, नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","मरियम कै जो तुमरे ताहीं खूबै मेहनत करी, नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","अन्द्रुनीकुस और यूनियास कै जो मेरे हितुआ-नातेदार हैं, और मेरे संग कैदखाना मैं गै रहैं, प्रेरित होन मैं खूब नाओं बारे हैं, और मोसे पहले मसीह बन गै रहैं, उनकै नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","अम्पलियातुस कै, जो प्रभु मैं मेरो प्रिय है, नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","उरबानुस कै, जो मसीह मैं हमरे संगै कामन मैं चलन बारो है, और मेरो प्रिय इस्तखुस कै नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","अपिल्लेस जो मसीह मैं खरो निकरो, उनको नमस्ते, बे लोगन के नमस्ते जो एरिस्टोबुलस के परिवार से सम्बधित हैं। ");
INSERT INTO thr_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","मेरे संग के यहूदि हेरोदियोन कै नमस्ते। नरकिस्सुस के घराने कै जो लोग प्रभु मैं हैं, उन्हऊँ कै नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","बहेनिया तुरुफैना और बहेनिया तुरुफोसा कै जो प्रभु मैं मेहनत करथैं, नमस्ते। प्रिय पिरसिस कै जो प्रभु मैं खूब मेहनत करीं, नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","रूफुस कै जो प्रभु मैं चुनो भौ है, और बाकी अईय्या कै भी नमस्ते, जो हमेसा मोकै अपनो बेटा हानी मानी। ");
INSERT INTO thr_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","असुंक्रितुस और फिलगोन और हर्मास, पत्‌रुबास, हिरमेस और उनके संग के दुसरे मसीह भईय्या और बहेनियन कै नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","फिलुलुगुस और यूलिया और नेरेउस और बाकी बहेनिया, और उलुंपास और उनके संग के सब परमेस्वर के पवित्र लोगन कै नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","आपस मैं पवित्र चुम्मी से नमस्ते करौ: तुम्हऊँ कै मसीह की पूरी कलीसियन की तरफ से नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","अब मेरे भईय्यौ और बहेनियौ; मैं तुमसे नहोरे करथौं, कि तुम बे आदमिन से सावधान रहाबौ, जो फूट डारथैं और दूसरेन के ताहीं पाप को बजह बनथैं। ऐसो व्यवहार बौ सिक्छा से मेल ना खाथै, जो तुमकै मिली है, तुम ऐसे लोगन से दूर रहबौ। ");
INSERT INTO thr_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","काहैकि ऐसे आदमी हमरे प्रभु मसीह कि नाय, लेकिन अपने पेट की सेवा करथैं; और चिकनी चुपड़ी बातन से सीधे-सादे मन बारे लोगन कै बहकाये देथैं। ");
INSERT INTO thr_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","सबै तुमरे सुसमाचार की इमानदारी के बारे मैं सुन लईं हैं, जौ मेरे ताहीं खुसी की बात है, तहुँओं मेरी जहे इच्छा है कि तुम भलाई के ताहीं अकलदार और बुराई के ताहीं भोले बने रहबौ। ");
INSERT INTO thr_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","सांति को परमेस्वर जल्दियै सैतान कै तुमरी टाँग के तरे कुचल देगो, हमरे प्रभु ईसु मसीह की दया तुमरे ऊपर बनी रहबै। ");
INSERT INTO thr_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","मेरे संगी तीमुथियुस को और मेरे साथी यहूदि लूकियुस, यासोन और सोसिपत्‌रुस को तुमकै नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","जौ लेख को लिखन बारो, तिरतियुस को तुमकै प्रभु मैं नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","गयुस को, जोके हिंयाँ मैं हितुआ हौं और जोके घर मैं कलीसिया के लोग आराधना करथैं, तुम्हऊँ कै नमस्ते। सहर के कोसाध्यक्छ एरास्तुस और हमरे भईय्या क्वार्तुस को तुमकै नमस्ते। ");
INSERT INTO thr_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","हमरे प्रभु ईसु मसीह को अनुग्रह तुमरे ऊपर हमेसा रहबै आमीन। ");
INSERT INTO thr_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","अब जो तुमकै मेरे सुसमाचार मतलब ईसु मसीह के बारे मैं उपदेस के अनुसार निठाठौर कर सकथै, बौ भेद के उजियारे के अनुसार जो अनंत से लुको रहो। इसलै आबौ आपन परमेस्वर कि महिमा करैं! ");
INSERT INTO thr_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","लेकिन अब दिखाई दौ है कि अनंत परमेस्वर की आग्या से भविस्यवक्तन के सास्त्रन के जरिया सब जाति कै बताओ गौ है, कि बे बिस्वास से आग्या मानन बारे हुई जामैं। ");
INSERT INTO thr_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","बहे इकल्लो परमेस्वर जो बुद्धिमान है, की ईसु मसीह के जरिये सच मैं हमेसा-हमेसा महिमा होत रहबै। आमीन।");
INSERT INTO thr_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","पौलुस के घाँईं से जोकै परमेस्वर की मरजी से ईसु मसीह को प्रेरित कहो गौ रहै, और भईय्या जोको नाओं सोस्थिनेस है के तरफ से। ");
INSERT INTO thr_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","परमेस्वर की बौ कलीसिया जो कुरिन्थुस नगर मैं है, बे सब जो मसीह मैं पवित्र लोग कहे जाथैं, और हर जघा जो हमरे प्रभु ईसु मसीह के नाओं से प्रार्थना करथैं: ");
INSERT INTO thr_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","हमरे परम दऊवा परमेस्वर और प्रभु ईसु मसीह के घाँईं से तुमकै दया और सांति मिलत रहबै। ");
INSERT INTO thr_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","मैं तुमरे बारे मैं अपने परमेस्वर को धन्यवाद हमेसा करथौं, जहे बजह से परमेस्वर को जौ दया तुमरे ऊपर ईसु मसीह मैं भौ। ");
INSERT INTO thr_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","कि बामै हुईकै तुम सबै बातन मैं मतलब सबै बचन और सबै ग्यान मैं सेठ करे गै। ");
INSERT INTO thr_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","कि मसीह को संदेस तुमरे मैं पक्को हुई गौ है ");
INSERT INTO thr_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","हिंयाँ ले कि कोई आध्यात्मिक उपहार मैं तुमकै कमी नाय भइ, और तुम हमरे प्रभु ईसु मसीह के दिखाई देन कै असियात रहथौ। ");
INSERT INTO thr_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","बौ तुमकै आखरी ले कसे रखागो, कि तुम हमरे प्रभु ईसु मसीह के दिनन मैं बिना गलती के माने जाबौ। ");
INSERT INTO thr_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","परमेस्वर भरोसेमंद है; जो तुमकै अपने लौड़ा हमरे प्रभु ईसु मसीह की संगती मैं मस्काई है। ");
INSERT INTO thr_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","भईय्यौ और बहेनियौ, मैं तुमसे ईसु मसीह जो हमरो प्रभु है बाके नाओं से नहोरे करथौं, कि तुम सब एकै बात कहबौ और तुम मैं फूट ना पड़ै, लेकिन एकै मन और एकै मकसद मैं रहकै मेल-जोल से रहबौ। ");
INSERT INTO thr_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","काहैकि मेरे भईय्यौ, खलोए नाओं की बईय्यर के घराने के आदमी मोकै तुमरे बारे मैं बताईं हैं, कि तुमरे बीच मैं लड़ाई होथैं। ");
INSERT INTO thr_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","मेरो जौ कहनो है, कि तुम मैं से कोई तौ अपने आपकै कहथै कि मैं “पौलुस को पछलगुआ हौं,” कोई कहथै मैं “अपुल्लोस को पछलगुआ हौं,” कोई कहथै “कैफाको पछलगुआ हौं,” और कोई दुसरे कहथैं कि मैं “मसीह को पछलगुआ हौं।” ");
INSERT INTO thr_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","का मसीह कै झुंड मैं बाँटो गौ है? का पौलुस तुमरे ताहीं क्रूस मैं चढ़ाओ गौ? या तौ तुम पौलुस के चेला हौ या बाके नाओं से बपतिस्मा मिलो है? ");
INSERT INTO thr_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","मैं परमेस्वर को धन्यवाद करथौं, कि क्रिस्पुस और गयुस नाओं के आदमी कै छोड़कै, मैं तुम मैं से कोई कै बपतिस्मा नाय दौ हौं। ");
INSERT INTO thr_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","कहूँ ऐसो ना होबै, कि कोई कहबै, कि तुमकै मेरे नाओं से बपतिस्मा दौ गौ है और तुम मेरे चेला हौ। ");
INSERT INTO thr_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ओ हाँ, मैं स्तिफनास के घराने कै भी बपतिस्मा दौ हौं; लेकिन मोकै याद ना है कि इनकै छोड़कै मैं कोई कै बपतिस्मा दौ कि ना। ");
INSERT INTO thr_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","काहैकि मसीह मोकै बपतिस्मा देन ताहीं नाय, बल्किन सुसमाचार सुनान कै भेजी है, और जहो इंसानन के बोल के ग्यान के हानी नाय, ऐसो ना होबै कि मसीह को क्रूस बेकार मानो जाबै। ");
INSERT INTO thr_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","क्रूस की कहानी नास होन बारेन के ताहीं मूर्खता है; लेकिन हमरे ताहीं जो हम बचाए भै हैं, परमेस्वर की सामर्थ्य है। ");
INSERT INTO thr_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","सास्त्र कहथै: “मैं अकल बारेन के अकल कै खतम करंगो, और समझदारन की समझकै बेकार कर देंगो।” ");
INSERT INTO thr_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","कितै गौ जौ दुनिया को ग्यानी? कितै गौ यहूदि नियम के सिक्छक? कितै गौ जौ युग को बहस करन बारो? का परमेस्वर युग के ग्यान कै बेबकूफी की बात ना बताई! ");
INSERT INTO thr_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","जब परमेस्वर के ग्यान के हानी, दुनिया ग्यान से परमेस्वर कै नाय जानी तौ परमेस्वर कै जौ अच्छो लगो, कि जौ उपदेस की “बेवकूफ” बात से बिस्वास करन बारेन कै बचाबै। ");
INSERT INTO thr_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","यहूदि तौ सबूत के ताहीं चिन्ह माँगथैं, और यूनानी ग्यान कै ढूँड़ रै हैं। ");
INSERT INTO thr_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","लेकिन हम तौ बौ क्रूस मैं चढ़ाय भै मसीह को प्रचार करथैं जो यहूदियन के झोने ठोकर की बजह, और गैर यहूदि के झोने बकवास की बात है; ");
INSERT INTO thr_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","पर जो मस्काए गै हैं का यहूदि, का यूनानी, उनके झोने मसीह परमेस्वर की सामर्थ्य, और परमेस्वर को ग्यान है। ");
INSERT INTO thr_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","काहैकि परमेस्वर की मूर्खता इंसानन के ग्यान से कहीं ग्यानवान है; और परमेस्वर की निर्बलता इंसानन के बल से भौत बलबान है। ");
INSERT INTO thr_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","भईय्यौ और बहेनियौ, खुद के मस्काए जान के बारे मैं सोचौ, कि नाय तौ सरीर से भौत ग्यान बारे, और नाय भौत सामर्थी, और ना भौत समाज मैं नाओं बारे मस्काए गै रहौ। ");
INSERT INTO thr_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","लेकिन परमेस्वर दुनिया के मूर्खन कै चुन लई है, कि ग्यान बारेन कै सरम बामै; और परमेस्वर दुनिया के निर्बलन कै चुन लई है, कि बलबानन कै सरम बामै। ");
INSERT INTO thr_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","और परमेस्वर दुनिया के गिरे भै और बेकारन कै, बल्किन उन्हऊँ कै जो ना के बराबर हैं, चुन लई है, जिनकै खतम करन के ताहीं दुनिया सोचथै। ");
INSERT INTO thr_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","जोसे कोई इंसान परमेस्वर के सामने घमंड ना दिखाबै। ");
INSERT INTO thr_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","लेकिन परमेस्वर तुमकै मसीह मैं धार्मिकता के संग जोड़कै सौंप दई है, और परमेस्वर मसीह ईसु कै हमरो ग्यान बनाये दई है। बहे के लिहाज से हम परमेस्वर के संग सई माने गै हैं, कि हम परमेस्वर के पवित्र जन और छुटकारा पामैं। ");
INSERT INTO thr_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ताकी जैसो सास्त्र कहथै “जो घमंड करै तौ बौ प्रभु मैं घमंड करै।” ");
INSERT INTO thr_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","भईय्यौ और बहेनियौ, जब मैं परमेस्वर को भेद सुनात भौ तुमरे झोने आओ, तौ बचन या ग्यान की अच्छाई के संग नाय आओ। ");
INSERT INTO thr_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","मैं जौ ठान लौ रहौं, कि तुमरे बीच ईसु मसीह, बल्किन क्रूस मैं चढ़ाय भै मसीह कै परखौ और कोई बात कै नाय जानौ। ");
INSERT INTO thr_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","तभई जब मैं तुमरे झोने आओ, मैं कमजोर रहौं और डर से कपकपात रहौं, ");
INSERT INTO thr_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","और मेरो प्रचार और संदेस कै इंसानी ग्यान के कुसल सब्दन के संग नाय दौ गौ, लेकिन परमेस्वर की आत्मा के सामर्थ्य के संग। ");
INSERT INTO thr_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","जहे बजह से कि तुमरो बिस्वास इंसानन के ग्यान मैं नाय, लेकिन परमेस्वर की सामर्थ्य के ऊपर आसरो होबै। ");
INSERT INTO thr_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","फिर भी मैं बे लोगन कै ग्यान को संदेस देथौं जो आत्मिक रूप से मजबूत है। लेकिन जौ ग्यान ना है जो जौ युग से संबंधित है या बे सक्तियन से जो जौ दुनिया के मुखिया राज करथैं, ऐसी सक्तियैं जो अपनी सक्ति खोए रइ हैं। ");
INSERT INTO thr_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","जो ग्यान की मैं घोसड़ाँ करथौं, बौ परमेस्वर की लुकी भइ बुद्धि है, जो इंसानन से लुको भौ है, लेकिन जोकै बौ युग बनान से पहलिये हमारी महिमा के ताहीं चुनी रहै। ");
INSERT INTO thr_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","जोकै जौ युग के मुखियन मैं से कोईये बाकी महिमा ना जानी, काहैकि अगर जानते, तौ बे प्रकासमान प्रभु कै क्रूस मैं ना चढ़ाते। ");
INSERT INTO thr_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","हालाकि, जैसो सास्त्र कहथै, “जो आँखी नाय देखीं, और जो कान नाय सुनीं, और जो बात इंसान के मन मैं नाय चढ़ी, बेईं हैं, जो परमेस्वर अपने प्यार करन बारे के ताहीं समारीं हैं।” ");
INSERT INTO thr_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","लेकिन परमेस्वर उनकै अपनी आत्मा से हममैं दिखाई; आत्मा सबै बातन, बल्किन परमेस्वर की गहरी बातन कै भी परखथै। ");
INSERT INTO thr_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","इंसानन मैं से कौन इंसान की बातन कै जानथै, सिरफ इंसान की आत्मा जो बामै है? बैसिये परमेस्वर की बातन कै भी कोई नाय जानथै, सिरफ परमेस्वर की आत्मा जानथै। ");
INSERT INTO thr_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","हमैं जौ दुनिया की आत्मा नाय मिली है; जाके बजाय, हमैं परमेस्वर के जरिया भेजी भइ आत्मा मिली है, ताकी हम बौ सब जान सकैं, जो परमेस्वर हमकै सौंपी है। ");
INSERT INTO thr_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","तौ फिर, जिनकै हम इंसानन के ग्यान की सिखाई भइ बातन मैं नाय, लेकिन पवित्र आत्मा की सिखाई भइ बातन मैं, आत्मा, आत्मिक ग्यान से आत्मिक सच्चाई के बारे मैं बताथै। ");
INSERT INTO thr_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","जो इंसान पास आत्मा नाय है, बौ परमेस्वर की आत्मा से आनबारे वरदानन कै नाय पाय सकथै। ऐसो आदमी हकीकत मैं उनकै नाय समझथै, और बे बकबास कर रै हैं, बे बहे की नजर मैं बेकार की बातैं हैं, और ना बौ उनकै जान सकथै काहैकि बाकी परिक्छा आत्मिक तरहन से होथै। ");
INSERT INTO thr_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","हालाकि, जो भी आत्मिक है, सब चीज कै परखन मैं काबिल है, लेकिन कोई भी बाको परिक्छा करन मैं काबिल नाय है। ");
INSERT INTO thr_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","जैसे की सास्त्र कहथै: “प्रभु के मन कै कौन जानथै? प्रभु कै कौन सलाह दै सकथै?” हालाकि, हम मसीह को दिमाक रखथैं। ");
INSERT INTO thr_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","मेरे भईय्यौ और बहेनियौ, हकीकत मैं, मैं तुमसे बात नाय कर सकथौं मैं बे आदमिन से बतकाथौं जो आत्मिक है; जैसी तुम जौ सरीर से हौ, बैसिये मोए तुमसे बात करने रहै, और उनसे जो मसीह मैं बालका हैं। ");
INSERT INTO thr_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","मैं तुमकै दूद पिबाओ हौं, खानु नाय खबाओ हौं; काहैकि तुम बाकै नाय खाए पाते; बल्किन हबै ले नाय खाए पाथौ, ");
INSERT INTO thr_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","काहैकि तुम अभैले अपने सरीर के स्वभाव से काबू मैं हौ। तुम एक दूसरे से नफरत करथौ और एक दूसरे से लड़थौ। का जौ साबित ना होथै कि तुम अपने सरीर के स्वभाव से काबू मैं हौ? का तुम दुनिया के लोगन के हानी नाय जी रै हौ? ");
INSERT INTO thr_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","जब एक कहथै, “मैं पौलुस को हौं,” और दुसरो, “मैं अपुल्लोस को हौं,” का तुम दुनिया के लोगन के हानी बर्ताव ना कर्‌रै हौ? ");
INSERT INTO thr_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","अपुल्लोस कौन है? और पौलुस कौन है? सिरफ सेवा करन बारे सेवक हैं, जोसे तुम बिस्वास करे, जैसे कि सबन कै प्रभु दई: ");
INSERT INTO thr_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","मैं बीज लगाओ, अपुल्लोस छींची, लेकिन परमेस्वर बढ़ाई। ");
INSERT INTO thr_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","तभईये ना तौ लगान बारो कछु है और ना छींचन बारो, लेकिन परमेस्वरै सब कछु है जो बढ़ान बारो है। ");
INSERT INTO thr_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","लगान बारो और छींचन बारो एक है; लेकिन सबै आदमी अपनी मेहनत से अपनिए कमाई पामंगे। ");
INSERT INTO thr_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","हम परमेस्वर के सहकर्मी हैं। तुम परमेस्वर की खेती और परमेस्वर के बनाये भै इमारत हौ। ");
INSERT INTO thr_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","परमेस्वर जो मेरे ऊपर दया करी, बाको इस्तमाल करकै, मैं एक अच्छे मिस्त्री को काम करो और बुनियाद डारो, और कोई अब बाके ऊपर काम कर रौ है। लेकिन हर कै सावधान रहनो चाहिए कि बौ कैसे बनाथै। ");
INSERT INTO thr_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","बौ बुनियाद कै छोड़कै जो पड़ी है, और बौ ईसु मसीह है, दुसरो कोई बौ बुनियाद नाय डार सकथै। ");
INSERT INTO thr_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","अगर कोई जौ बुनियाद मैं सोनो या चाँदी या खूबै कीमती पथरा या कठिया या घाँस-फूस को रद्दा रखै। ");
INSERT INTO thr_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","तौ सबन को काम दिखाई दै जागो; काहैकि बौ दिन बाकै बतागो, तभईये कि आगी के संग दिखाई देगो और बौ आगी सबन को काम परखैगी कि कैसो है। ");
INSERT INTO thr_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","जो-जोको काम बामै बनो भौ टिको रहागो, बौ दिहाड़ी पागो। ");
INSERT INTO thr_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","अगर कोई को करम बाकी आगी मैं जर जागो, तौ बाको नुकसान उठान पड़ैगो; लेकिन फिरौंकी बौ खुदै बैयसिये बच जागो जैसे कि कोई आगी लगे भै घर मैं से भाज कै निकर जाथै। ");
INSERT INTO thr_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","का तुम ना जानथौ, कि तुम खुदै परमेस्वर को मंदिर हौ, और परमेस्वर को आत्मा तुमरे मैं रहथै! ");
INSERT INTO thr_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","अगर कोई परमेस्वर के मंदिर कै खतम कर देगो तौ परमेस्वर बाकै खतम कर देगो; परमेस्वर को मंदिर पवित्र है, और बौ तुम हौ। ");
INSERT INTO thr_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","कोई अपने आपकै धोका ना देबै। अगर तुम मैं से कोई जौ युग मैं अपने आपकै ग्यानी समझै, तौ मूर्ख बनै कि ग्यानी हुई जाबै। ");
INSERT INTO thr_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","जौ दुनिया को ग्यान परमेस्वर के झोने मूर्खता की बात है, जैसो सास्त्र कहथै, “बौ ग्यानियन कै उनकी चलाँकी मैं फसाए देथै” ");
INSERT INTO thr_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","और फिर, “प्रभु ग्यानियन के मन की बातन कै जानथै, कि बे मन की बात बेकार हैं।” ");
INSERT INTO thr_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","तभईये इंसानन के ऊपर कोई घमंड ना करै, काहैकि सबै कछु तुमरो है: ");
INSERT INTO thr_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","का पौलुस, का अपुल्लोस, का कैफा, का दुनिया, का जिंदगी, का मौत, का हबै को समय, का गुजरो समय, सबै कछु तुमरो है, ");
INSERT INTO thr_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","और तुम ईसु मसीह के हौ, और मसीह परमेस्वर को है। ");
INSERT INTO thr_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","तुमकै हमैं मसीह को सेवक के रूप मैं सोचनो चाहिए, जिनकै परमेस्वर कि गुप्त सच्चाईयन को प्रबंधक बनाओ गौ है। ");
INSERT INTO thr_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ऐसे सेवकन के ताहीं एक बात जरूरी है कि बे अपने प्रबंधक के प्रति भरोसेमंद रहमैं। ");
INSERT INTO thr_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","अब, मैं तुमरे जरिये या कोई भी मानवीय मानक के बारे मैं चिंतित ना हौं; मैं खुद की भी नाय परिक्छा करथौं। ");
INSERT INTO thr_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","मेरो मन मोकै दोसमुक्त ठहराथै, काहैकि मेरो प्रभु मोकै अजमाथै। ");
INSERT INTO thr_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","इसलै तुमकै सई समय आन से पहले कोई के ऊपर फैसला लागू ना करनो चाहिए। आखरी फैसला प्रभु के आन तक असियानो चाहिए; बौ अंधियारे रहस्यन कै उजिते मैं लागो और लोगन के मन के छिपे उद्देस्यन कै उजागर करैगो। और तौ सब परमेस्वर से बे बड़ाँईं पांगे जिनके बे हकदार हैं। ");
INSERT INTO thr_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","भईय्यौ और बहेनियौ, मैं जे बातन मैं तुमरे ताहीं अपनी और अपुल्लोस की बात-चीत कहानी के जैसी करो हौं, तभईये कि तुम हमसे जौ सीखौ, “कि सास्त्र मैं जो लिखो है बासे अग्गु मत बढ़ौ,” और एक के घाँईं से और दुसरे के बिरोध मैं घमंड मत करियो। ");
INSERT INTO thr_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","तुमकै दूसरे से बड़ो कौन बनाओ? का परमेस्वर तुमकै बौ सब कछु ना दई जो तुमरे पास है? ठीक है, तौ, तुम कैसे भेद-भाव कर सकथौ, जैसे कि तुमरे पास कोई उपहार नाय है? ");
INSERT INTO thr_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","का तुमरे झोने पहले से सब कछु है जो तुमकै चाहिए? का तुम पहलेई से सेठ हौ? का तुम राजा ना हौ, भलेई हम ना हैं? खैर, मेरी इच्छा है कि तुम बास्तव मैं राजा रहो, ताकी हम तुमरे संग मिलकै राजा बन सकैं। ");
INSERT INTO thr_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","मेरी समझ से परमेस्वर हम प्रेरितन कै सबन के बाद बे आदमिन के हानी मानी है, जो-जो कि मौत की आग्या हुई चुकी है; काहैकि हम दुनिया और स्वर्गदूतन और इंसानन के ताहीं एक खिलबाड़ बन गै हैं। ");
INSERT INTO thr_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","हम मसीह मैं बेअकली हैं; लेकिन तुम मसीह के संग समझदार हौ! हम कमजोर हैं, लेकिन तुम मजबूत हौ! तुम आदर पाथौ लेकिन हमरो आदर नाय होथै! ");
INSERT INTO thr_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","हम आज तक भूंके-प्यासे हैं; और नंगे हैं, और घूँसा खाथैं और मारे-बितारे फिरथैं; ");
INSERT INTO thr_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","और अपनेई हातन के काम करकै मेहनत करथैं, आदमी बुरो कहथैं, हम आसीस देथैं; बे सताथैं, हम सकार लेथैं; ");
INSERT INTO thr_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","जब हमरी बेजती होथै, तौ हम दयालु सब्दन के संग नहोरे करथैं। हम दुनिया के मैल हैं और बन गै हैं। हम कछुए नाय हैं! ");
INSERT INTO thr_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","मैं तुमकै सर्मबान ताहीं जे बातन कै नाय लिखथौं, लेकिन अपने प्रिय बालका जानकै तुमकै चिताथौं। ");
INSERT INTO thr_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","अगर मसीह मैं तुमरे सिखान बारे दसौ हजार होते, तहुँओं तुमरे बाबा भौत से नाय होते, तभई ईसु मसीह मैं सुसमाचार के जरिया मैं तुमरो बाबा बन गौ हौं। ");
INSERT INTO thr_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","मैं तुमसे नहोरे करथौं, कि मेरे हानी चाल चलौ। ");
INSERT INTO thr_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","तभईये मैं जोको नाओं तीमुथियुस है, और जो मेरो प्रिय और भरोसा बारो लौड़ा है, तुमरे झोने पनारो हौं, और बौ तुमकै प्रभु ईसु मसीह मैं मेरे बर्ताव कै याद दिबागो, जैसे कि मैं सबै जघा सब कलीसियन मैं उपदेस देथौं। ");
INSERT INTO thr_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","तुम मैं से कुछ लोग गरब महसूस करथैं काहैकि तुम सोचे हौ कि मैं तुमसे मिलन ना आंगो। ");
INSERT INTO thr_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","अगर प्रभु तैयार है, हालाकि, मैं जल्दिये तुमरे झोने आंगो, और फिर मैं अपने ताहीं बौ सामर्थ्य को पता लगांगो जो जे गरब करन बारे लोगन के पास है, और ना कि सिरफ बे जो कहथैं। ");
INSERT INTO thr_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","परमेस्वर को राज्य बातन मैं नाय है, लेकिन सामर्थ्य मैं है। ");
INSERT INTO thr_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","तुम का पसंद करैगे? का मैं लठिया लैकै तुमरे झोने आमौं या प्यार और नमरता की आत्मा के संग आमौं? ");
INSERT INTO thr_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","अब हिंयाँ ले सुनन मैं आओ है, कि तुम मैं व्यभिचार होथै, बल्किन ऐसो व्यभिचार जो गैर यहूदि मैं भी नाय होथै, कि एक लोग अपनी सौतेली अईय्या के संग सोथै! ");
INSERT INTO thr_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","फिर, का तुम गरब कर सकथौ? जाके उल्टा, तुमकै उदासी से भरो होनो चाहिए, और जो आदमी ऐसो करी है बाकै तुमरी संगती से बाहर निकार देनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","भलेई मैं सरीर मैं तुमरे सामने नाय हौं, मैं आत्मा मैं तुमरे संग हौं। लेकिन जब हुँआँ रहौं, तौ मैं जौ आदमी के ताहीं पहलेई से फैसला लागू कर चुको हौं ");
INSERT INTO thr_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","प्रभु ईसु के नाओं मैं तुम कलीसिया कि एक बैठक बुलाए सकथौ। मैं आत्मा मैं तुमरे संग मौजूद रहेंगो, और ऐसिये हमरे प्रभु ईसु कि सामर्थ्य होगी। ");
INSERT INTO thr_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","इंसान के सरीर के बिनास के ताहीं सैतान कै सौंपो जाबै, ताकी बाकी आत्मा प्रभु ईसु के दिन बच पाबै। ");
INSERT INTO thr_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","तुमरो घमंड करनो अच्छो नाय है! का तुम नाय जानथौ, “की जरा सो खमीर पूरे मड़े भै चून कै खमीर कर देथै।” ");
INSERT INTO thr_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","तुमकै पाप के पुराने खमीर कै निकारने होगो ताकी तुम पूरी तरह सुद्ध हुई जाबौ। फिर तुम बिना कोई खमीर के चून को नै घना के हानी होगो, जैसो कि मैं जानथौं कि तुम बास्तव मैं हौ। हमरे फसह के त्योहार के ताहीं तैयार है, अब जब कि मसीह, हमरे फसह को मेमना, बलिदान करो गौ है। ");
INSERT INTO thr_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","सो तुम आबौ हम परव मैं खुसी मनामैं, नाय तौ पुराने खमीर से और नाय बुराई और दुस्टता के खमीर से, बल्किन सीदे और सच्चाई की अखमीरी रोटी से। ");
INSERT INTO thr_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","मैं अपनी चिट्ठी मैं तुमकै लिखो हौं, की व्यभिचारियन की संगती मत रखियो। ");
INSERT INTO thr_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","जौ नाय, कि तुम कतईये जौ दुनिया के व्यभिचारियन, लालचिन, अंधेर करन बारे, या मूर्ति पूजा करन बारेन की संगती करन कै बाध्य बनौ; काहैकि जौ हाल मैं तौ तुमकै दुनिया मैं से निकर जानो चाहिए। ");
INSERT INTO thr_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","मेरो जौ कहनो है की; अगर कोई भईय्या कहवाएकै, व्यभिचारी, लालची, मूर्ति पूजा करन बारो, गारी देन बारो, पियक्कड़, या अंधेर करन बारो होबै, तौ बाके संग संगती मत रखियो; बल्किन ऐसे इंसानन के संग खानुओ मत खईयो। ");
INSERT INTO thr_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","मोकै बहार बारेन को फैसला करन से का मतलब? का तुम भीतर बारेन को हिसाब ना करथौ? ");
INSERT INTO thr_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","लेकिन बहार बारेन को फैसला परमेस्वर करथै, “तभईये बौ बुरे काम करन बारे कै अपने झुंड मैं से निकार देबौ।” ");
INSERT INTO thr_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","का तुम मैं से कोई के पास इतनी हिम्मत है, की जब दुसरे संग लड़ाई होबै, तौ फैसला करन के ताहीं अधर्मियन के झोने जाबै; और पवित्र लोगन के झोने नाय जाबै? ");
INSERT INTO thr_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","का तुम नाय जानथौ, की पवित्र लोग दुनिया को फैसला करंगे? और जब तुमकै दुनिया को हिसाब करने है, तौ का तुम छोटी से छोटी लड़ाई को भी मुकदमा करन के भी काबिल नाय हौ? ");
INSERT INTO thr_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","का तुम नाय जानथौ, कि हम स्वर्गदूतन को हिसाब करंगे? तौ का दुनिया की बातन को फैसला नाय कर सकथैं! ");
INSERT INTO thr_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","अगर तुमकै दुनिया की बातन को मुकदमा करने होबै, तौ का उन्हईं कै बैठागे जो कलीसिया मैं कछु नाय समझे जाथैं? ");
INSERT INTO thr_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","मैं तुमकै लज्जित करन ताहीं जौ कहथौं! का तुम मैं से एकौ अकल बारे नाय हैं, जो अपने मसीह भईय्यन के बीच फैसला कर सकै। ");
INSERT INTO thr_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","बल्किन भईय्या-भईय्या मैं फैसला होथै, और बहो गैरविस्वासियन के सामने! ");
INSERT INTO thr_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","सच्ची को तुम मैं बड़ो दोस तौ जौ है, कि आपस मैं मुकदमा करथौ, बल्किन अन्याय काहे नाय सहथौ? अपनो नुकसान काहे नाय उठाथौ? ");
INSERT INTO thr_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","बल्किन अन्याय करथौ और नुकसान पहोंचाथौ, और बहो भईय्यन और बहेनियन कै! ");
INSERT INTO thr_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","का तुम नाय जानथौ, की अधर्मी परमेस्वर के राज्य के बारिस ना होंगे? धोका मत खाबौ, नाय व्यभिचारी, नाय मूर्ति पूजा करन बारे, नाय दुसरेन की बईय्यर कै अपनो बनाये लेन बारे, नाय लुच्चे, नाय कोई आदमी कै अपनो बनान बारे बनौ ");
INSERT INTO thr_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","नाय चुट्टा, ना लालची, ना पियक्कड़, ना गारी देनबारे, ना अंधेर करन बारे परमेस्वर के राज्य के बारिस होमंगे। ");
INSERT INTO thr_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","और तुम मैं से कित्ते समर्पित रहैं, लेकिन तुम प्रभु ईसु मसीह के नाओं से और हमरे परमेस्वर की आत्मा से धोए गै हौ, और पवित्र भै और धर्मी बने। ");
INSERT INTO thr_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","सबै चीज की मेरे ताहीं इजाजत है, हाँ; लेकिन सब चीज सई नाय हैं, और “मैं कोई बात के सुपर्त नाय होंगो।” ");
INSERT INTO thr_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“खानु पेट के ताहीं, और पेट खानु के ताहीं है,” हाँ; लेकिन परमेस्वर जाकै और बाकै दोनों कै खतम करैगो, लेकिन सरीर व्यभिचार के ताहीं नाय, बल्किन प्रभु के ताहीं है; और प्रभु सरीर के ताहीं है। ");
INSERT INTO thr_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","और परमेस्वर अपनी सामर्थ्य से प्रभु कै मरे मैं से जिंदो करी, और हमउँ कै जिंदो करी। ");
INSERT INTO thr_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","का तुम नाय जानथौ, की तुमरो सरीर मसीह को अंग है? तौ का मैं मसीह के सरीर को अंग लैकै उनकै वेस्या को अंग बनामौं? कतई नाय! ");
INSERT INTO thr_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","का तुम नाय जानथौ की जो कोई वेस्या से संगती रखथै, बौ बाके संग एक सरीर हुई जाथै सास्त्र कहथै, “बे दोनों एक तन होंगे।” ");
INSERT INTO thr_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","और जो प्रभु की संगती मैं रहथै, बौ बाके संग एक आत्मा हुई जाथै। ");
INSERT INTO thr_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","व्यभिचार से बचे रहबौ और जित्ते पाप इंसान करथैं, बे सरीर के बहार हैं, लेकिन व्यभिचार करन बारो अपनेई सरीर के खिलाप पाप करथै। ");
INSERT INTO thr_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","का तुम नाय जानथौ, कि तुमरो सरीर पवित्र आत्मा को मंदिर है, जो तुम मैं बसो भौ है और तुमकै परमेस्वर के घाँईं से मिलो है? और तुम अपने नाय हौ, लेकिन परमेस्वर हौ; ");
INSERT INTO thr_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","परमेस्वर तुमकै दाम दैकै मोल लई है, तभईये अपने सरीर से परमेस्वर की महिमा करौ। ");
INSERT INTO thr_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","बे जे बातन के बारे मैं जो तुम लिखे हौ, जौ अच्छो है। की लोग बईय्यर कै ना छुइबै। ");
INSERT INTO thr_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","लेकिन व्यभिचार के डर से सब लोगन की अपनी बईय्यर, और सब बईय्यर के अपने लोगा होनो चाहिए। ");
INSERT INTO thr_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","लोगा अपनी बईय्यर को कर्तव्य पूरो करै; और बैसिये बईंय्यरैं अपने लोगा को। ");
INSERT INTO thr_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","बईय्यर कै अपनी सरीर मैं अधिकार नाय है पर बाके लोगा को अधिकार है; बैसिये लोगा कै भी अपने सरीर मैं अधिकार नाय है, लेकिन बईय्यर कै है। ");
INSERT INTO thr_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","जबले तुम पहली बार प्रार्थना मैं अपनो समय बितान के ताहीं थोड़ी समय के लै ऐसो करन के ताहीं सहमत नाय होथौ, तौले एक दूसरे से खुदकै इंकार ना करैं; लेकिन फिर सामान्य सादी सुदा रिस्ता कै फिर से सुरु करैं। ऐसे करकै तुमकै अपने आत्मनियंत्रड़ कि कमी कि बजह से सैतान के लालच मैं देन से रखो जागो। ");
INSERT INTO thr_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","लेकिन मैं जो जौ कहथौं बौ मेरो कहनो है, नाय कि आग्या है। ");
INSERT INTO thr_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","मैं जौ चाहथौं, की जैसो मैं हौं, बैसिये सब इंसान होमैं; लेकिन सबन कै परमेस्वर के घाँईं से जरूरी उपहार मिले हैं; कोई कै कैसियौ, और कोई कै कोई और जैसी को। ");
INSERT INTO thr_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","अब मैं बिना बिहा बारिन और बिधवन के बारे मैं कहथौं, कि उनके ताहीं ऐसिये रहनो अच्छो है, जैसो मैं हौं। ");
INSERT INTO thr_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","लेकिन अगर बे खुदकै ना रोक सकैं, तौ बिहा कर लेमैं; काहैकि बिहा करनो रहन से अच्छो है। ");
INSERT INTO thr_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","जिनको बिहा हुई गौ है, उनकै मैं नाय, बल्किन प्रभु आग्या देथै, की बईय्यर अपने लोगा से न्यारे ना होबै; ");
INSERT INTO thr_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","और अगर समझौता हियो जाबै, तौ दुसरो बिहा करे बगैर रहबै; या अपने लोगा से फिर से मिल जाबै और नाय लोगा अपनी बईय्यर कै तलाक दैकै छोड़ै। ");
INSERT INTO thr_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","दुसरेन से तौ प्रभु नाय, लेकिन महीं, कहथौं, अगर कोई मसीह भईय्या की बईय्यर बिस्वास नाय करत होबै, और बाके संग रहेन ताहीं खुस होबै, तौ बौ बाकै नाय छोड़ै। ");
INSERT INTO thr_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","और जो मसीह बईय्यर को लोगा अविस्वास होबै, और बाके संग रहेन ताहीं खुस होबै; बौ लोगा कै नाय छोड़ै। ");
INSERT INTO thr_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ऐसो लोगा जो अविस्वासी है, बौ समर्पित बईय्यर के बजह से पवित्र मानो जाथै, और ऐसी बईय्यर जो बिस्वास नाय करथै, विस्वासी भईय्या के बजह से पवित्र मानी जाथै; नाय तौ तुमरे बालका असुद्ध होते, लेकिन अब तौ पवित्र हैं। ");
INSERT INTO thr_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","लेकिन जो आदमी अविस्वासी है, और बौ न्यारे होबै, तौ न्यारे होन देबौ, ऐसे हालात मैं कोई भईय्या या बहेनिया, बंधे भै गुलाम नाय हैं; लेकिन परमेस्वर तौ हमकै सांति के ताहीं बुलाई है। ");
INSERT INTO thr_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","हे मसीह बईय्यर, का तैं जानथै, की तू अपने लोगा को उद्धार करबाय लेगी? और आदमी, तहूँ जानथै का, कि अपनी बईय्यर कै बचा लेगो? ");
INSERT INTO thr_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","पर जैसे प्रभु सबन कै बाँटी है, और जैसे परमेस्वर सबन कै बुलाई है; बैसिये बर्ताव चलै: और मैं सब कलीसियन मैं ऐसिये ठहरातौ हौं। ");
INSERT INTO thr_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","जो खतना करो भौ बुलाओ गौ है, बौ बिना खतना जैसो नाय बनै: जो बिना खतना के बुलाए गै हैं, बे खतना नाय करामै। ");
INSERT INTO thr_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ना खतना कछु है, और ना ही बगैर खतना करो भौ, लेकिन परमेस्वर की आग्या कै माननो सब कछु है। ");
INSERT INTO thr_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","सबै जनी जो जैसे हाल मैं परमेस्वर बुलाए गै हैं, बहे मैं रहामैं। ");
INSERT INTO thr_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","अगर तैं दास के हाल मैं बुलाओ गौ है तौ फिकर मत करै; और अगर तैं आजाद हुई सकै, तौ ऐसिये काम कर। ");
INSERT INTO thr_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","जो दास के हाल मैं बुलाओ गौ है, बौ प्रभु को आजाद करो भौ है, और बैसिये जो आजाद के हाल मैं बुलाओ गौ है, बौ मसीह को दास है। ");
INSERT INTO thr_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","तुम कीमत दाम दैकै मोल लै भै हौ, इंसानन के दास मत बनौ। ");
INSERT INTO thr_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","हे भईय्यौ और बहेनियौ, जो कोई जैसे हाल मैं बुलाओ गौ है, बौ बहे मैं परमेस्वर के संग रहबै। ");
INSERT INTO thr_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","कुवाँरिन के बारे मैं प्रभु से मोकै कोई आग्या नाय मिली है, पर भरोसेमंद होन के ताहीं जैसी दया प्रभु मेरे ऊपर करी है, बहे भरोसे सलाह देथौं। ");
INSERT INTO thr_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","सो मेरी समझ से जौ अच्छो है, की आज कल कलेस की बजह से इंसान जैसी है बैसिये रहबै। ");
INSERT INTO thr_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","अगर तेरी बईय्यर है तौ, अलग होन की कोसिस मत करै: और अगर तेरी बईय्यर नाय है, तौ बईय्यर की खोज मत करै। ");
INSERT INTO thr_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","और अगर तैं बिहा करै, तौ पाप नाय है; अगर कुवाँरी बिहाई जाए तौ कोई पाप नाय है; पर ऐसेन कै सारीरिक दुख होगो, और मैं बचानो चाहथौं। ");
INSERT INTO thr_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","भईय्यौ मैं जौ कहथौं, कि समय कम करो गौ है, तभई चहाईये कि जोकी बईंय्यरैं हैं, बे ऐसे होमैं मानौं उनकी बईंय्यरैं नाय हैं। ");
INSERT INTO thr_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","और रोन बारे ऐसे होमैं, मानौ बे रोतै नाय हैं; और आनन्द करन बारे ऐसे होमैं, मानौ आनन्द नाय करथैं; और मोल लेन बारे ऐसे होमैं, कि मानौ उनके झोने कछु हईये नाय। ");
INSERT INTO thr_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","और जौ दुनिया के संग रबईय्या करन बारे ऐसे होमैं, कि दुनिया के नाय हुई लेमैं; जौ दुनिया की रीत और रबईय्या बदलत जाथैं। ");
INSERT INTO thr_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","मैं जौ चाहथौं, कि तुमकै चिंता नाय होबै। बिना बिहा के आदमी प्रभु की बातन की चिंता मैं रहथैं, कि प्रभु कै कैसे करकै खुस रखै। ");
INSERT INTO thr_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","लेकिन बिहा बारे आदमी दुनिया की बात की चिंता मैं रहथै, कि अपनी बईय्यर कै कौन सी रीति से खुस रखै। ");
INSERT INTO thr_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","बिहा बारी और कुवाँरी मैं भी फरक है: बिना बिहा बारी प्रभु की चिंता मैं रहथै, की बौ सरीर और आत्मा दोनों मैं पवित्र होबै, लेकिन बिहा बारी दुनिया की चिंता मैं रहथै, की अपने लोगा कै खुस रखै। ");
INSERT INTO thr_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","जौ बात तुमरियै फायदे के ताहीं कहथौं, नाय की तुमकै फसान के ताहीं, बल्कि जैसो सुहाथै बैसिये करो जाए; की तुम एक चित्त हुईकै प्रभु की सेवा मैं लगे रहबौ। ");
INSERT INTO thr_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","और अगर कोई जौ समझै, कि मैं अपनो कुवाँरीपन को हक मार रहो हौं, जोकी जवानी ढल रइ है, और जोको इरादो होबै, तौ बौ बाध्य नाय है उनके ताहीं सई है, जामैं कोई पाप नाय है, बौ बाको बिहा होन देबै। ");
INSERT INTO thr_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","पर जो मन मैं फैसला करथै, और बौ अपने अधिकारन कै मार सकथै, तौ बौ कुवाँरी रहे कै अच्छो करथै। ");
INSERT INTO thr_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","तौ जो अपनी कुवाँरी को बिहा कर देथै, बौ अच्छो करथै और जो बिहा ना कर पाथै, बौ औरौ अच्छो करथै। ");
INSERT INTO thr_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","जब तक कोई बईय्यर को लोगा जिंदो रहथै, तब तक बौ बासे बंधी भइ है, लेकिन जब बाको लोगा मर जाए तौ, जोसे चाहबै बिहा कर सकथै, लेकिन सिरफ प्रभु मसीह मैं। ");
INSERT INTO thr_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","और जैसी है अगर बैसिये रहाबै, तौ मेरी समझ से औरौ धन्य है, और मैं समझथौं, की परमेस्वर को आत्मा महुँ मैं है। ");
INSERT INTO thr_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","अब मूर्तियन के अग्गु चढ़ाई भइ बलि के बारे मैं हम जानथैं। की हम सबन कै ग्यान है: ग्यान घमंड पैदा करथै, लेकिन प्यार से उन्नति होथै। ");
INSERT INTO thr_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","अगर कोई समझै, कि मैं कछु जानथौं, तौ जैसो जाननो चहाईये बैसो अब तक नाय जानीं। ");
INSERT INTO thr_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","अगर कोई परमेस्वर कै प्यार करथै, तौ बाकै परमेस्वर जानथै। ");
INSERT INTO thr_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","तौ मूर्तियन के अग्गु चढ़ाई बलि कै खान के बारे मैं हम जानथैं, की मूर्ति दुनिया मैं कोई चीज नाय है, और एक कै छोड़कै कोई परमेस्वर हईये नाय। ");
INSERT INTO thr_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","अगर स्वर्ग और धरती मैं निरे ईस्वर कहे जाथैं, जैसे कि निरे ईस्वर और निरे प्रभु हैं, ");
INSERT INTO thr_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","तहुँओं हमरे झोने तौ एकै परमेस्वर है, मतलब; दऊवा परमेस्वर जोके घाँईं से सबै चीज हैं, और हमउँ बहे के ताहीं हैं, और एकै प्रभु है, मतलब ईसु मसीह जोसे सब चीज हैं और हमउँ बहे से हैं। ");
INSERT INTO thr_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","लेकिन सबन कै जौ ग्यान नाय है; पर कित्ते तौ अब तक मूरत कै मन मैं कछु समझथैं, मूर्तियन के अग्गु बलि करी भइ चीजन कै समझकै खाथैं। उनके ऐसो करन से उनकी आत्मा कमजोर होन के बजह से असुद्ध हुई जाथै। ");
INSERT INTO thr_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","खानु हमकै परमेस्वर के झोने नाय लै जागो, अगर हम बाकै नाय खाथैं तौ कछु नुकसान नाय, और अगर खांए तौ कछु फायदा नाय। ");
INSERT INTO thr_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","पर चौकन्ने रहबौ, ऐसो ना होबै कि, तुमरो जौ अधिकार कहूँ बिस्वास मैं कमजोरन के ताहीं ठोकर ना हुई जाए। ");
INSERT INTO thr_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","अगर तैं “अग्यानी” कै मूर्ति के मंदिर मैं बलि खात देखै, और बौ बिस्वास मैं कमजोर है, तौ का बाके मन मैं मूर्ति के अग्गु चढ़ाई भइ चीज कै खान की हिम्मत नाय हुई जागी? ");
INSERT INTO thr_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ऐसे तेरे ग्यान के बजह से बौ कमजोर भईय्या जोके ताहीं मसीह मरो, अपने ग्यान के ताहीं नास हुई जागो! ");
INSERT INTO thr_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","तौ मसीह भईय्यन के गलती करन से और बाके कमजोर मन कै चोट लगान से तुम मसीह के ताहीं पाप करथौ। ");
INSERT INTO thr_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","जौ बजह से अगर खानु मेरे भईय्या और बहेनिया कै ठोकर खबाबै, तौ मैं कहु कैसियौ रीति से सिकार नाय खांगो, ऐसो ना होबै कि मैं अपने भईय्या के ताहीं ठोकर को बजह बनौ। ");
INSERT INTO thr_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","का मैं आजाद ना हौं? का मैं प्रेरित ना हौं? का मैं ईसु को जो हमरो प्रभु है, ना देखो? का तुम प्रभु मैं मेरे बनाये भै ना हौ? ");
INSERT INTO thr_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","अगर मैं औरन के ताहीं प्रेरित नाय हौं, तहुँओं तुमरे ताहीं तौ हौं! काहैकि तुम प्रभु मैं मेरे प्रेरित होन को प्रमाड़ रहौ। ");
INSERT INTO thr_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","जो मोकै अजमाथैं, उनके ताहीं मेरो जहे जबाब है: ");
INSERT INTO thr_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","का हमकै खान-पीन को अधिकार नाय है? ");
INSERT INTO thr_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","का हमकै जौ अधिकार नाय है, की कोई मसीह बहेनिया कै बिहा करकै संग लैकै घूमैं, जैसे की दुसरे प्रेरित और प्रभु के भईय्या और कैफा करथैं? ");
INSERT INTO thr_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","या सिरफ मोकै और बरनबास कै जौ अधिकार नाय कि कमाई करनो छोड़ै? ");
INSERT INTO thr_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","कौन कहु अपनी झुंड से खाएकै सिपईय्या को काम करथै? कौन अंगूर की बारी लगाएकै बाको फरा ना खाथै? कौन भेंड़न की रखबारी करकै उनको दूद ना पीथै? ");
INSERT INTO thr_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","मोकै अपने आपकै जे रोज मर्‌रा के उदाहरड़ ले सीमित ना रखने है, काहैकि नियम एकै बात कहथै। ");
INSERT INTO thr_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","का नियम जौ नाय कहथै? कि मूसा के नियम मैं जौ लिखो है “दाँए लगात पोती बरधन के मोहों मैं मुसीका मत भाँदिये।” का परमेस्वर बरधनौं की फिकर करथै? ");
INSERT INTO thr_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","या जरूरी करकै हमरे ताहीं कहथै। हाँ, हमारियै ताहीं लिखो गौ है, ठीक है, कि जोतन बारो आसा से जोतै, और दाँए लगान बारो भागीदार होन की आसा से दाँए लगावै। ");
INSERT INTO thr_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","अगर हम तुमरे ताहीं आत्मिक चीज कै बोए हैं, तौ का जौ बड़ी बात है? की तुमरी सरीर के चीजन की फसल काटैं। ");
INSERT INTO thr_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","जब औरन को तुमरे ऊपर जौ भागीदारी और अधिकार है, तौ हमरो जासे जाधे ना होगो? लेकिन जौ हक हम काम मैं नाय लाए; पर सबै कछु सकारथैं, कि हमसे मसीह के सुसमाचार की कछु रोक-टोक ना होबै। ");
INSERT INTO thr_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","का तुम ना जानथौ की जो मंदिर मैं सेवा करथैं; बे मंदिर से खाथैं: और बेदी मैं चढ़ावा चढ़ान बारेन कै बलि को हिस्सा मिलथै। ");
INSERT INTO thr_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","जहे रीति से प्रभु भी ठहराई है, कि जो आदमी सुसमाचार सुनाथैं, उनकी जीविका सुसमाचार से होबै। ");
INSERT INTO thr_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","लेकिन मैं इनमैं से एकौ बात काम ना लाओ! और जे बेकार की बातन कै मैं जहे के मारे ना लिखो, कि मेरे ताहीं ऐसो होबै, काहैकि जासे तौ मेरो मरनोई भलो है; कि कोई मेरो घमंड खाली मूली ठहराबै। ");
INSERT INTO thr_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","अगर मैं सुसमाचार सुनामौ, तौ मेरो कछु घमंड नाय है; जौ मेरे ताहीं जरूरी है; और अगर मैं सुसमाचार ना सुनामौ, तौ मेरे ताहीं कितनो भयानक है! ");
INSERT INTO thr_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","काहैकि अगर अपनी मरजी से जौ करथौं, तौ दिहाड़ी मोकै मिलथै, और अगर अपनी मरजी से ना करतो, तहुँओं बिस्वास से भंडारी पन मोकै सौंपो गौ है। ");
INSERT INTO thr_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","तौ फिर मेरी कौन सी दिहाड़ी? जौ की सुसमाचार सुनान मैं, मैं मसीह को सुसमाचार सेंत मेंत कर देओं; हिंयाँ ले की स