﻿USE sofia;
DROP TABLE IF EXISTS sofia.thd_vpl;
CREATE TABLE thd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES thd_vpl WRITE;
INSERT INTO thd_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Min yomparr-r ith pam kaarp wakm kuuk pelnan pam raak warr-kak; Iiwurr nangunp kaarp thanm kulam-thaaw pam raak warr-kokonak; Iiiwurr niinhin kaarp ith ninh thang-kangkar-nanr. ");
INSERT INTO thd_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Pam ith nul mang-mangal minch nangun Raak-warram nangnma Pam Porkam. Ngul nul raak mangk minch min ngeem ngurnturnthurr miing. ");
INSERT INTO thd_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Nul kar yuk niinanirr thaapirri kar ngok miinthin, May yuk punth koo-yermperr raak karrtham, Iiwurr riingkaal kaarp warramr; Mit mong-thak nangn-man nul min yomparr-r. ");
INSERT INTO thd_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Pam warr yorrp kaarp, Kar may petn yarra puunuth puukr pelnan. ");
INSERT INTO thd_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Yarr i'i pam warr nangunp kaarp than, Ith pelnan koo-thakarr ko'orr; Iiwurr pam raak warr-kak nangunp Kaarp thaakokon thunprr pelnungun pam kuk-kunanpak; Ngul peln kulam-n pam warr peln wonp. ");
INSERT INTO thd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Godang nila ngangkam pama uyuwu akuni nila kawiyeni pama nengka ningurrm thononi waam-parra kawaya thana uyuni konnomeem ninguni ka'i uthumanha thana kawaya muchithaawaya yethala niin-nh. Kot nul ngeengkmam pam kulpungkak raakun nul angarrp pam Nemgk nangn thononurr reekarr angarr peln koop kaall-aath-nh Nangun kaar wonpnh, peln angarr muthaathan kunk niin-nh. ");
INSERT INTO thd_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Ŋay Paul, pam kuuk-kak, ith muth wunparr Pam Porka nuh Christ kunanpun-hatha raak korrkanpa. Leta ih'h yumpirr pam kaalaathimak raak Ephesus peln pam kampur wunum thurmthurma naŋun Christ Jesusak. ");
INSERT INTO thd_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Pam Pork pam Ŋanipi pul Pam Pork Jesus Christanthurr nurrnun min ak yomparrnanah nurr kampan aŋarr yancih. ");
INSERT INTO thd_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Ŋamp kuuk min ak yik naŋun Pam Porka, pam naŋanip naŋan Minh Puth Jesus Christak. Ŋamplin min yomparrnanirr ulp ith ŋamp kar thono weneyir naŋun Christak ŋul ŋamp warrmin min moŋ piitir man ŋeeŋkan kar yokun raakumunak. ");
INSERT INTO thd_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Raak kookanpantam, raak ith ŋarr oŋkorr kaarp yumpirr, Pam Porka ŋamplin kanpa kunmicarr ŋamp naŋan minc aŋarr wuunuh thaathurma naŋun Christak ŋul ŋamp rirrkir wacwaeirr iiwurr raakwarr-kaar aŋarr wunuh ruwunanpa Naŋun, ŋul ulp ŋeeŋkmam niinah... ");
INSERT INTO thd_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ŋul Nul ŋamplin kanpa kunmicarr ŋamp parr'ir naŋan aŋarr yomparrna naŋanma Jesus Christantam. Yarr i'i kaaluŋeeyim Pam Pork man ŋeeŋk naŋanman ith Nul ŋamplin kunmicarr. ");
INSERT INTO thd_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Nul yarr i'i meerenirr pam moŋthak ith Nul ŋampulŋun ŋeeŋkmam mincmin, ŋul ŋamplin muukur rokanirr raak pert naŋanmak pam Nerŋk naŋanmantam ulp Nul ŋeeŋkmam minc Naŋun. ");
INSERT INTO thd_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Nul ŋamplin yerkmanirr raak warrmam kam naŋanman, raak warr wothotherr ŋul ulp Nul ŋeeŋkmam mincmin ŋampulŋun. ");
INSERT INTO thd_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Nul ŋampulŋun warrmin ih'h yomparrnanirr ŋamp kaalpiinth, pam ŋaampurr naathim, aŋarr weneha. ");
INSERT INTO thd_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Ŋul Nul rirrkan wenehanirr ŋampulŋun ith Nul rep kaaluŋeeyim paant thuurun ŋul Nul kanpa kun-micarr naŋanul yarr i'i yump-hatha maŋmaŋal aŋarr wunuh. ");
INSERT INTO thd_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Raak yuukarrath, raak min wacwacirr, Nul warrmin moŋ raak korrkanpa aŋarr puŋk therkan-hatath ikan naŋun Christak, warrmin raakumunak, warrmin raakun, ŋaa minc, naŋanma Jesusuntam. ");
INSERT INTO thd_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Naŋun Christak ŋamp warrmin thaathurma moŋ pitim kar Kotunthurr kanpa kunmicarr ŋul Nul warrmin koop yompomparrnanirr ith Nul riiran kaalu-ŋeeyim yump-hatha. ");
INSERT INTO thd_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Ŋamp ith kaalaathim raak kookanpantam naŋun Christak ŋamp yarr i'i ak wun kar Nul Pam Pork thakiraaw wacwacirr. ");
INSERT INTO thd_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Nurr yorrpnurrp naŋun kaalaathim raak ith nurr kuuk mincminc ŋeeyir, ulp kuthip minthurr nurrnun kunk thananirr. Ŋul ulp nurr kanpa kaalaathim, nurrnun pam kaalpiinth yomparrnanirr Ŋeeŋk-rithurr-min-thurr ulp nuh man ke'err Pam Porka. ");
INSERT INTO thd_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Nurr nuh kanpa piitir ritar ŋul ulp nurrnun ŋuul reekhan mincminc Christanthurr, nurr Pam Pork wacwacirr aŋarr kunanpun-hatna raak ithrrath. ");
INSERT INTO thd_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Ŋay Paul kaaluŋeeyir nurr kaalaathim naŋun Jesus, Pam Thulumun ŋul nurr pam kaalaathimak ŋeeŋkmam. ");
INSERT INTO thd_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","Ŋay nurrŋun prayrirk raak yirr, raak yirr ŋul ŋay nurrnun kaalu-ŋeeŋeem kuukmin ŋathanman naŋun Pam Porka. ");
INSERT INTO thd_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Ŋul nul Pam Pork naŋan Min Puth Jesus Christak, pam Naŋanipi ith Pam miiŋak niihin, nurrnun pam kaalpiinth aŋarr yomparrnanan nurr warrmin wacwacirr aŋarr ŋaampurr naath-hancih naŋanma, ŋul nurr Nuh walmeeremah. ");
INSERT INTO thd_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Ŋul nurr pam kaalpiinth aŋarr weneha ŋul nurr kaal-kaalu ak kalir ith Nul man ke'err ŋul ith nurrnun muunur ŋul warrmin wacwacirr naŋan aŋarr ŋaampurr naathih ith Nul nurrnun reek-han pam naŋan. ");
INSERT INTO thd_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Ŋul ŋay kuukmin yik naŋun Pam Porka Nul piinthaarrn minc ŋamplin aŋarr yomparrhancih pam kaalaathim ŋul Nul minc pam piinthaarrn wacwacirr mit naŋan aŋarr rirk-hatha: ");
INSERT INTO thd_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","Ulp Nul Christak yomparrnanirr, raak ŋan? Ith Nul nuh watpam kunk thananirr ŋul Nul nuh niinanirr punth mal naŋanman iikan raakumunak. ");
INSERT INTO thd_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Nul ikan putpun pam thakiraaw minc ŋul mih puth yirryirram kopkop wuun naŋun, pelnuŋun pam thulumun, pelnuŋun mih punth-kokon. Namp naŋan min wacwacirr, namp pelnan pam yirra, pokon, yorr raakun, ŋuul raakumunak. ");
INSERT INTO thd_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Pam Pork, Kotunthurr warrmin moŋ wunparr kokopon thamur naŋanmak Jesus Christak ŋul Nul ulp thananirr nuh Pam Keeŋ pork aŋarr wunuh pam kaalaathim moŋthak. ");
INSERT INTO thd_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Peln ulp pam curcak kar yokun pam-minc naŋan Christak ith ŋamal minc korrkanpa raak moŋthak ithrrath korrkanpa. ");
INSERT INTO thd_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Nurrnun Pam Porka kunk thananirr, nurr kanpath pam watp wunum raak warr-kak yancim raak ŋanc kaar ŋeeyimpa; ");
INSERT INTO thd_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ŋul nurr kar pam waal yancim kanaŋkarr raak warr wuump yumpum kar yokun pam moŋthurr, ŋul mih puth waŋwarr ŋeeyimpa nul raak pert naŋan rep yancim raak korrkanpa, nul pam kululeekir ith kuukthaaw naŋan Pam Porka kaar ŋeeyir. ");
INSERT INTO thd_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Ŋaa minc, ŋamp kuukthaaw warr thurma minc yikim yorrpnurrp pelnuŋun, ŋamp kermper-thaaw-nurr maŋmaŋal wuump wenehanam, ŋul ŋamp warrmin warr wakam ith rirpirr pam mincum, paant thuurmam. Ŋamp Pam Pork ŋeeŋkul rancinirr kar yokun pam moŋthurr okun raakun. ");
INSERT INTO thd_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Ŋaa minc, Pam Pork nul ŋeeŋkmam minc pama ŋul Nul raak warr ŋamplin warr wothothuh. ");
INSERT INTO thd_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","6","Ŋawoy, ŋul ŋamp kar pam watp wunum raak warraŋan ŋul Nul ŋamplin kunk thananirr thurma Ŋan Waahancin ith Nul ŋeeŋkmam pama ŋul Nul ŋamplin kunk thananirr. Nul ŋamplin thurmthurma kunk rirkanirr ŋul Nul ŋamplin niinanirr raak puŋk naŋanmak raakumunak naŋanma Christ Jesusantam. (Iiwurr ith ŋamp raak warr ŋampulntam woonp ulp ŋamplin kaal-pinirmnanirr ŋeeŋk nerp naŋanman-thurr Nul ŋamplin kunk thananirr naŋun Christak, ŋul Nul ŋamplin aŋarr irrkan rirkan thaathurma wene-han ŋul ŋamp aŋarr thaathurma niihin ikan raakumunak raak ith ikan nul Jesus Christ niin-hat.) ");
INSERT INTO thd_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Ŋul nul raak ŋuul yup Nul aŋarrp meerenah pam kaalaathimak Nul ŋampulŋun ŋeeŋkmam wacwacirr ith Nul muukur thoŋkur ŋampulŋun naŋanma Christ Jesusantam. ");
INSERT INTO thd_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Ŋawoy, Nul nurrŋun ŋeeŋkmam, nurrnun kunk thananirr ith nurr kaalaathirr; pamal riiran kaarp yumpirr. Ulp yuur wuthan naŋanma Kotantam, ");
INSERT INTO thd_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","mit min nurruntam kaarp, pam yirraman kaar aŋarr kumun maakurrna. ");
INSERT INTO thd_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Ŋamplin Nul yumpirr yuur naŋanman ŋamp mit min aŋarr rirkuh naŋanma Jesus Christmam, ulp Kotunthurr kanpa minirpunirr ŋamp yarri'i aŋarr wacirr yancih. ");
INSERT INTO thd_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Wey, nurr kirri kaaluŋeey, nurr kanpa kar pam Jew kaarpi ulp petan yuuru yakum kermper-thaaw-thak, nurr pam yirrth yancim ŋul ith waanir ‘ŋeeŋk rirp kaarp yaakir’ peln pam ŋeeŋk rirp yuuru yakim yikir. ");
INSERT INTO thd_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Ŋul raak awith nurr Christ-kaar yancim, nurr pam korrpal wunum thorkurr niinim raak puŋk pam Israelantam, ŋul nurr kar pam yirrth wunum pam ŋooŋkom warrmin ith man ke'err Pam Porka ŋul nurr Kot-kaar yancim rirmurr raakun, nurr Nuh kaaluŋeeyim kaarp kanaŋkarr. ");
INSERT INTO thd_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Raak ith nurr kanpath pam thorkurr wunum Christ Jesusantam ŋul nurr yorr ih'h thaapirri thoŋkur kam naŋanman Christak. ");
INSERT INTO thd_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Nulnulur pam kampur ŋallin, Ŋallin kuthirr Nul thono wenehanirr ŋul Nul raak muth kana rumparrnanirr ulp werŋka thanam ŋalŋun. ");
INSERT INTO thd_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Nul Jesusun pam-minc naŋanman ŋamplin pamthaaw wenehanirr, ŋamplin Raakwarra kaar aŋarr koothakarr ko'ohancih raak warr ŋampulntaman, ŋul ŋallin kuthirr pam Jewnthurr pam yirraman kar thono yomparrnanirr naŋanman Christanthurr, ŋul ŋal kampan wuun thurmthurma. ");
INSERT INTO thd_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Nul yarr i'i pulnun kuthirr kar thono wenehanirr yuk crossantam ruwunanpa Pam Porka pam-minc thono naŋanman, ŋul Nul pulnun maŋmaŋal yomparrnanirr pam kuthirr ulp wakurrnam. ");
INSERT INTO thd_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Nul ulp Jesus iiwal yat ŋul kuuk yikir nurrnuŋun nurr pam thorkurr minc niinim, nurr kampan aŋarr weneha ŋul yorrpnurrp pelnuŋun pam thaapthaapirri niinim. ");
INSERT INTO thd_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Nul Ŋan Waaharr ŋamplin ŋumanirr, thaap-thaapirri wenehanirr Pam Naŋanipin ŋamplin pam Jewn pam Gentiln kar thono aŋarr niinah pilono Ŋeeŋk-rithurr-min thonthurr. ");
INSERT INTO thd_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Ŋul yorr ih'h nurr kar pam yirr kaarpi iiwurr pam korrpal, nurr pamthaaw minc thaathurma pelnuŋun pam kaalaathimak, raak pert naŋanman Pam Porka. ");
INSERT INTO thd_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Yorr ih'h, nurrnun niinanim raak foundationak ith peln apostle-thurr yumpirr pul prophetanthurr ŋul Jesus Christ nul koothononurr minc kar therrep thaarrn wuun raakun ith; ");
INSERT INTO thd_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ŋul putpun Naŋun pormpur thanan ulp thono wenenanirr, thorkorr minc ŋul ŋamal weneyir pormpur curc min minc aŋarr yomparrna naŋanma Pam Porkam. ");
INSERT INTO thd_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Nurrnun thaathurma rokanirr Naŋun kar pormpur minc weneyir Pam Pork nul aŋarr wunuh ikan naŋanman Ŋeeŋk-rithurr-minthurr. ");
INSERT INTO thd_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Ŋul yarr i'i, naŋanma Jesus Christmam, ŋay Paul wuun prisonak nurruntam pam Gentilantam. ");
INSERT INTO thd_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Anth okun nurr kana ŋeeyir Pam Pork nul ŋeeŋkmam minc ŋathun mit ŋathanmantam nurrnuŋun. ");
INSERT INTO thd_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Nul meer rirrkan rirpinirr ŋathun warrmin ith ŋay pam ŋooŋkom niinim kar ulp ŋay kanpa ratan yumpirr ritar nurrnuŋun. ");
INSERT INTO thd_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Ŋul ith nurr leta ŋathan naath-hat ulp, nurr aŋarr kaaluŋeeyih ŋay kuthip naŋan Christak walmeerem mincmin. ");
INSERT INTO thd_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Pam kanaŋkarr pam ŋooŋkom minc, pelnan kaarp kunanpunum raakun. Ulp Ŋeeŋk-rithurr-minthurr yorrnurr meer rirrkan rirpinirr pam prophetak pam apostulak ith nul ŋanc wenehanirr yarr i'i: ");
INSERT INTO thd_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","peln pam Gentile thurmthurma wun-hatath pilun pam Jewthak pam-minc thonthak naŋun Christak ŋul ŋamp pam moŋthurr pit-hatath ith Nul man ke'err kuthip min naŋanmak. ");
INSERT INTO thd_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Ŋul ŋah kunmicarr mit naŋan rirk-hatha ŋul Nul Pam Pork piinthaarrn minc-thurr ŋah kaalpiinth wenehanirr mit naŋanmak. Pam Pork-thurr ŋah mincthaaw naŋanmantam Nul piinthaarrn wenehanirr. ");
INSERT INTO thd_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Ŋawoy, ŋenem, ŋay pam ŋooŋkom niinam ith pam mantam minc pelnuŋun pam kaalaathim moŋthak ŋul Nul ŋah kunmicarr ŋay kuukmin wacwacirr naŋan aŋarr kunanpunuh pam korrpalak, yarri'i, Christ Nul pam thakiraaw wacwacirr pamal nuh kaarp koop kaaluŋeeyih. ");
INSERT INTO thd_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Ŋay ak meer rirrkan yikir pam moŋthak Pam Pork Nul ŋeeŋkmam minc pam Gentilak pelnan kunk thanan-hatha. Peln ih'h kanaŋkarr pam ŋooŋkom minc niinim, yorr kana; Pam Pork riiran walmeerem ith Nul warrmin koop yumpirr thurmthurma naŋanman Jesus Christunthurr. ");
INSERT INTO thd_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Ŋul ŋene? Pam Pork nul kaalpiinth wacwacirr ŋul yorrnurr ih'h ŋamp pam kaalaathiman yarr i'i aŋarr meerenah pelnuŋun pam thulumak, mih punth-kokon, pam porkthak raakumunak. ");
INSERT INTO thd_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Ŋul nul Kotunthurr kookanpantam kun-micarr nuh Jesus Christ Pam Pork ŋamplin yomparrnan-natha raak ŋuul. ");
INSERT INTO thd_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Ŋul naŋanma Christmam ŋamp naŋun aŋarr rokuh ŋul Nul ŋamplin muukur minimnanir, maŋmaŋal, iiwurr weneth-kaar ŋul ŋamp yorr pam kaalaath wuun naŋanma. ");
INSERT INTO thd_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Ŋay yarri'i yik — meerkunwarr oŋkorr wun ŋathanma ith ŋay kaalmeer kenceyir nurruntam. Nurrnun min wacwacirr yup yomparrnanurrtha. ");
INSERT INTO thd_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Ŋul yarri'i ŋay ulp puŋkumun niinir ruwunanpa Pam Naŋanip naŋanman Mih Puth Jesus Christak. ");
INSERT INTO thd_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Ŋul pam moŋthurr raakumunak raakun namp kumun naŋan Pam Porka ŋamp wanurrur. ");
INSERT INTO thd_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Ŋul ulp Pam Pork ith raak warrmin moŋ-kokonak kar paath therper rancirr, Nul nurrnun piinthaarrn aŋarr wenehanan Ŋeeŋk-rithurr-min naŋanman man ŋeeŋk paman. ");
INSERT INTO thd_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Ŋul ulp Christ nul ak wunur man ŋeeŋk nurrnuntaman nurrŋun pam kaalaathamak ŋul nurr pam ŋeeŋkmam aŋarr niinah kar yuk yukumun thaarrnkak irrkop piinthirr raakun. ");
INSERT INTO thd_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Nurr yarri'i kar yokun peln pam kaalaathim korrkanpa nurr aŋarr kaaluŋeeyhan Nul Kot wuun thampurr minc, wuun thorkorr minc, wuun iikop minc, wuun yuukan minc raak moŋthak. ");
INSERT INTO thd_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Ŋul ulp nurr aŋarr kaaluŋeeyih mincminc Christ nul ŋeeŋkmam wacwacirr minc pama ŋul nurr aŋarr wun thurmthurma naŋun Kotak man ŋeeŋkan, thaathaarrn mincip. ");
INSERT INTO thd_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Nul ŋamplin min yompomparr-nanancih, ŋamp wuump pokon raŋkaŋkuh iiwurr kaaluŋeeyih thil naŋanma. Nul mit pork wuump aŋarr rirkuh ŋampulŋun ŋul nul piinthaarrn wacwacirr. ");
INSERT INTO thd_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Namp naŋan ak porkpunur pam kaalaathimak naŋanma Christ Jesusuntam, thonomarr raak meer-ŋuul ŋoontma. Ŋawoy kana. ");
INSERT INTO thd_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Ŋay pam naŋan Pam Porka ith gaol-thak rokanirr, ŋul ŋay mincmin yik nurrnuŋun, nurr min wacwacirr aŋarr yancih kar yokun Nul ith nurrnun kanpa munarr. ");
INSERT INTO thd_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Ŋul nurr pam ŋeeŋkmam aŋarr yancih, nurr pam muukur rookur aŋarr wunuh; ŋul nurr pam yirr moŋ aŋarr yuur reekuh. ");
INSERT INTO thd_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Kar thono kirri yarr nurr, pam kampur wun Ŋeeŋk-rithurr-min-thurr, pam yirryirra ŋoŋkorr yarr! ");
INSERT INTO thd_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Pam-minc thononurr, ŋul Ŋeeŋk-rithurr-min thononurr wuun, kar yokun nurrnun pam moŋ munarr nul Pam Porka nurr pilthono aŋarr thanah. ");
INSERT INTO thd_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Mih Puth thononurr, pam kaalaathim kulpuŋk thononurr thanan, baptism thononurr aŋarr kaaluŋeeyih. ");
INSERT INTO thd_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Pam Pork thononurr niihin ulp pam Naŋanip ŋamplin pam moŋthak ith wuun putpun minc raakumunak, raak korrkanpa, iikan nurrŋun pam moŋthak. ");
INSERT INTO thd_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Ŋamplin moŋ Pam Porkunthurr yomparrnanirr ŋamp pam wacwacirr aŋarr wunuh kar yokun Christanthurr reekarr ŋamplin yirryirram. ");
INSERT INTO thd_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Ŋul yarr i'i yikir: “Nul irrkan yat putpun, Ŋul Nul pam prisonak katpirr, Ŋul nul yuur-wuthan reekarr pam.” (Ps 68.18) ");
INSERT INTO thd_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Kuuk ih'h “irrkan yat-ul” wanthantharr? ŋan waanir? Yarr i'i okun? Nul kanpa irrkop wuump yat kopkopuŋkurr raakun? ");
INSERT INTO thd_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Pam ith nul irrkop reenpenat, ŋul nul ulp yokunman irrkan thaaŋkarr putpun raakumunak kankan Nul raak moŋthak aŋarr wun-hancih korrkanpa Mih Puth pam moŋthak. ");
INSERT INTO thd_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Ŋul nul pam yirram micarr peln pam kuthip-kak aŋarr yancih, yirram pam poropet, yirram pam kuthip min aŋarr yik-hancih pam korrpalak. Yirram peln pam naŋan Christak kuupum, yirram pam tica yomparrnanirr. ");
INSERT INTO thd_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Nul yarr i'i yumpirr peln pam kaalaathim aŋarr kaalpiinth yancih mit naŋanman ŋul peln pam-minc naŋan Christak aŋarr ticim-rirkih. ");
INSERT INTO thd_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Ŋul yarri'i ŋamp kar thono aŋarr weneha ith ŋamp kaalaath ŋul ŋamp Pam Nerŋk naŋan Kot-thak walmeerem mincmin, ŋul ŋamp pam kaalpiinth yomparrna ŋamp pam wacwacirr kar Christ aŋarr than-hancih. ");
INSERT INTO thd_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Ŋul ŋamp kar parr'ir-nurr kaarp aŋarr wunuh kar yirram ith pelnan pam warran kululeekum, ulp ith pamal manaŋkar yikum ŋul peln ulp kar yuk thorkorr puun porkan ith peln pam moŋoŋomur, man thono kaarp yikum pelnan aŋarr warr wenehanancih. ");
INSERT INTO thd_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Ŋamp pam ŋeeŋkmam ak wuun, ŋamp kuuk mincminc aŋarr yik-hancih, ŋamp pam min aŋarr piinth-hancih warrmin moŋthak kar Christ nul pam Thulum ŋamplin. ");
INSERT INTO thd_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Ith naŋanma Christmam, pam-minc ŋamplin, yaŋkar, yuur, muth, paant kar thono aŋarr matanah pilono, pil, puŋk, punt, tendon ith kempkempthe mit naŋan yumpurrtha, peln koop pam-minc piinthinhancih ŋul pam ŋeeŋkmam aŋarr yancih, ŋul min aŋarr yomparrna. ");
INSERT INTO thd_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Yarri'i ŋay yiik, ŋay kunanpunur Pam Porkam nurrnuŋun — oŋkorr yarr kar yokun peln pam korrpal yancim ŋul peln waal wunum paant thuur pelnantaman. ");
INSERT INTO thd_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Peln kar walinthul, waal wunum, peln thorkurr yancim Pam Porkam, peln pokon kaaluŋeeyim ŋul peln thaarrn minc man ŋeeŋkan. ");
INSERT INTO thd_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Peln pokon ŋaatheyir ŋul peln ŋorŋur yancim pam-mincun, ŋul mit warr rirkim, warrmin koop wothothum, ulp rirrkir kaarp wunum. ");
INSERT INTO thd_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Wey, nurr kar ih'nul Christunthurr nurrnuŋun kaarp kunanpunum! ");
INSERT INTO thd_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Nurr nuh Christ wuump ŋeeyhat? Ŋul Nul nurrnuŋun wuump kaar yik-hat? Christ Nul kuuk mincminc yiik. ");
INSERT INTO thd_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Mit warr naŋan ‘pam meerkanaman’ kirri yarra thak paant thuurum, nurr mit warr wuwum, nurr pam warr wunum. ");
INSERT INTO thd_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Kar pam puukam kirri yarr paant thuurun, man ŋeeŋk nurrnuntaman. ");
INSERT INTO thd_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Pam Porka nih puukam wenenanirr: kirri yarrthurr kar pam ulp, kunkunanp, rirrkir minc kar Kot! ");
INSERT INTO thd_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Pam moŋoŋomur oŋkorr wun, kuuk mincminc-nurr yiik pama, ŋamp pamthaaw wuun pilono. ");
INSERT INTO thd_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Anth okun nunt pacarr, pam warran naam oŋkorr yarr; pam kampur wene puŋ kaarp munthirr. ");
INSERT INTO thd_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","Waŋ warra naŋkanunt oŋkorr pam thaayuur reekurr ŋul nih nul pam warram-hanir. ");
INSERT INTO thd_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Pam ith warrmin repam, oŋkorr rep, ak mit rirk yuur naŋanman, mit min rirk-narr nul pam raak-rirkir-kaar aŋarr reekah nuh. ");
INSERT INTO thd_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Kuuk-thaaw warr oŋkorr yiik, kuuk min yik pam yirr aŋarr maŋmaŋal yomparrnanah, pam moŋ aŋarr ŋeeŋkmam thananah thurmthurma. ");
INSERT INTO thd_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Ŋeeŋk-rithurr-min naŋan Pam Porka oŋkorr kululeek! Nul ulp nurrnun pam muurk thananirr Nul raak ith yuukarra nurrnun min aŋarr yomparrnanancih. ");
INSERT INTO thd_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Oŋkorr pac, oŋkorr ŋeeŋkuluuth, meer-warran oŋkorr naam, pam kuuk moŋ-kak oŋkorr than, pam rakakir oŋkorr wun — kuukthaaw warr oŋkorr yiik, pam kampur wene. ");
INSERT INTO thd_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Pam ŋeeŋkmam yarr thurmthurma pam moŋthak, pam kampur wun man ŋeeŋk minin, pam yirram oŋkorr pac nurr aŋarr yancih kar yokun Pam Pork, ith naŋun Christak raak warr naŋkan kana wothotherr. ");
INSERT INTO thd_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Yarri'i, Pam Pork nuh wak, kar parr'ir ulp Nul pelnuŋun ŋeeŋkmam. ");
INSERT INTO thd_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Nurr pam ŋeeŋkmam yarr kar yokunman Christ ith ŋampulŋun ŋeeŋkmam niinim. Ŋul nul naŋanul reekeyir Nuh Kot ŋul peln nuh therŋarr watp Nul raak warr ŋamplin aŋarr yarra wothoth-hatha ŋul maŋmaŋal Pam Pork naŋanma ŋul Nul ruwunanpa Naŋun Kot-thak niinim kar mih kermper ith kuŋun min minc reekurrur naŋanul. ");
INSERT INTO thd_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Warrmin ith warr, kar paanth yirr waathim, warrmin ith ŋorŋur, warrmin ith kar pam warrmin koop wothothum ŋul ŋuunp waatheyir, nurr oŋkorr wanan pama ŋul yarr i'i min wacwacirr pam kaalaathimak. ");
INSERT INTO thd_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Kuukthaaw ŋorŋur oŋkorr wanan, kuuk waal oŋkorr yik, kuukthaaw woocwocurr min kaarp. Yarri'i min ith nurr kuuk thaakuump aŋarr yikih naŋun Pam Porka. ");
INSERT INTO thd_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Ih'nul kirri ŋeey-le, pam ith paanth moŋ wakakim, pam ith kar ŋorŋur yancim, pam ith warrmin moŋ wothothum kar pam god naŋan, pam ulp kaarp yan Raak puŋkun naŋan Christak naŋan Kot-thak. ");
INSERT INTO thd_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Pam yirram oŋkorr muth wunp nurrnuŋun moŋom-hatha kuuk-thaawam manaŋkar-mam: nuh thakan! Ith nurr yarr i'i yuumpurrtha, Pam Pork nul pac-han pam moŋ ulp ith kuuk-thaaw naŋan kaar ŋeeyim. ");
INSERT INTO thd_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Yarri'i oŋkorr yarr pelnuŋun thurma. ");
INSERT INTO thd_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Nurr kanaŋkarr yancim kar raak ŋurnturnthurr-ak, yorr ih'h nurr raak miiŋin yaan naŋan Pam Porka. Kirri, wacwacirr yarr kar pam miiŋ-kak. ");
INSERT INTO thd_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Pam ith yancim miiŋ-thak nul mit kunkunanp riirk, ŋul min wacwacirr wuun kar pam mincminc. ");
INSERT INTO thd_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Ŋul nurr meren-nan warrmin ith Pam Pork maŋmaŋal wenehanan Nuh. ");
INSERT INTO thd_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Oŋkorr thurmthurma yarr pelnuŋun pamal mit warr rirkum kar raak ŋurnturnthurrak, kirri pelnan wananharr! ");
INSERT INTO thd_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Ŋamp ak pancir-rirk yan warrmin warrmam ith pam yirraman wananam-nurr mit warrmam ulp peln yumpum rep. ");
INSERT INTO thd_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Ith warrmin moŋ riirrkan wene raak miiŋ-thak ŋul aŋarr naathih pelnan, ŋawoy, warrmin ulp naathim pamal ŋul kar thit-kak yomparr. ");
INSERT INTO thd_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Nul yarri'i yikim, “Pinar wun, nunt pam ith wut wunum, rirk-le watpam ŋul Christunthurr Nul thiimp-han naŋkun.” ");
INSERT INTO thd_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Wacwacirr naath-harr ŋul nurr kar pam kaalpiinth aŋarr yancih, kar pam waal kaarp, pilwacirr yarr! ");
INSERT INTO thd_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Mit yirram naŋkan kirri rirkic, yuparr oŋkorr, raak yorr ih'h raak warr. ");
INSERT INTO thd_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Kar pam waal oŋkorr wun, ith Pam Porka kunmicarr kirri kaaluŋeey! ");
INSERT INTO thd_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Ŋok paapaath oŋkorr muŋk nunt drunk-rirk aŋarr yancih. Ŋeeŋk-rithurr-minthurr okun ak wuun mincmin iikan naŋkun. ");
INSERT INTO thd_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Kar pamthaaw minc kirri yarr ith nurr kuukthaaw wacwacirr yiikurrur thaathurma paman, wuuc naŋan Pam Porka mi'iharr ŋul nurr maŋmaŋal aŋarr yancih ŋeeŋk nerp nurrnuntaman. ");
INSERT INTO thd_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Kuuk thaakuump thaathaawan yik naŋun Pam Porka, pam Naŋanipin, iikan namp naŋanman Jesus Christak. ");
INSERT INTO thd_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Thaathurma wenehanurr nip, kuuk kaalu nip ŋeeŋeeyurr waat patheyir naŋanma ruwunanpa Kot-thak. ");
INSERT INTO thd_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Nurr paanthurra, ŋeey pam naŋkan, kar ith nunt Pam Pork ŋeeŋeem. ");
INSERT INTO thd_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Pam meermele nul mih puth naŋun paanthu kar ih'nul yorrpnurrp yarr i'i Nul Christ nul mih Puth curcak. Ŋul nul Christ-anthurr riiran curc kunk thananir ulp mincthaaw naŋan. ");
INSERT INTO thd_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Ŋul yarri'i kar paanth paathumun pam meermele pelnan kuuk kaaluŋeeyim mincmin ŋul yorrpnurrp curcunthurr kaaluŋeem nuh Christ. ");
INSERT INTO thd_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Nurr pam meermele, ŋeeŋkmam niin paanth nurruntamak kar yorrpnurrp ith Christ nul ŋeeŋkmam niinim Curcak, ŋul naŋanul therŋeyir, kaalmeer kenceyir, wonpur Nul naŋun, ");
INSERT INTO thd_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Nul aŋarr curc ŋanc wunp-hancih ŋul rirrkirm-hanancih kuukul naŋanman, kar ŋokel kuuk naŋanman curc rirrkirm-hanirr, ");
INSERT INTO thd_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","nul aŋarr curc reekurrur naŋanul, min wenehanurrur rirrkir, raak warrkaar, thatir, pilpuuŋk pokon, mincthaaw muny pokon, warr pokon, ŋul yarri'i curc nul rirrkir ak than-nan, raak warr-kaar, ŋanc thaarrn wacwacirr. ");
INSERT INTO thd_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Pam nul paanthu ŋeeŋkmam ak niin kar ith nul mincthaaw naŋanul kar mincthaaw nuluth wacwacirr piiturr. Ith nul pam ŋeeŋkmam niin naŋun paanthu, nul naŋanul yorrpnurrp piiturr. ");
INSERT INTO thd_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Pam yirryirram ŋamp mincthaaw ŋamplin kaarp meer warran naathurrur. Ŋawoy, ulp ŋamp mayil piipiinthinurr ulp wacwacirr piinthinir kar ith Christunthurr yomparrnanir Curcthak. ");
INSERT INTO thd_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","Ŋamp pam kulpuŋk mincthaaw naŋan, kermper, piinth naŋan. ");
INSERT INTO thd_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Yarr i'i Paypul yikir: “Peln pamal yarr i'i pam naŋanip thak-han, pam naŋanam yorrpnurrp, ŋul pul thaathurma wene paanth paathum naŋanman pamal paanth naŋanman, ŋul pul paanth naŋanman kar thono yomparr.” (Gen 2:23-24) ");
INSERT INTO thd_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Kuuk ulp warr ŋamal minc Kotunthurr rirpinirr Paypulntam ŋul ŋay kaalaathir kuuk ith kar yokunman Christanthurr pul Curcunthurr. ");
INSERT INTO thd_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Ulp nurrŋun yorrpnurrp min pam meermele moŋthak. Nurr paanth paathum-ak ŋeeŋkmam niin, kar nul riiran, ŋul paanth-paathum yorrpnurrp peln kuuk thakirmin ak yik pelnuŋun pam melencin. ");
INSERT INTO thd_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Wey, parr'ir ŋe! Ih'nth nurrnun kunanp wene-hanir wacwacirr kaalaath-hatha pam naŋanaman pam naŋanipin. Ih'nul wacwacirr yomparr-nanir Pam Porka. ");
INSERT INTO thd_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Kuuk wacwacirr yik pam naŋanaman pam naŋanipin. Ih'nul kuuk kookanpa naŋanma Kotantam nul kanpa man ke'err ŋamplin min wenehanir naŋanma kuuk thaawam. ");
INSERT INTO thd_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","Ŋul yarr i'i: “min aŋarr niinah raak meerŋuul ŋoontma raak kaal thorkorrtha raakun.” ");
INSERT INTO thd_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Pam naŋanip, waat wacwacirr oŋkorr, parr'ir yorrp oŋkorr ŋeeŋkul-oŋkan pelnan. Yarr i'i, piinthin pelnan raak Christianak, koothakarr ko'o pelnan, ith peln waat wacirr yaan peln, wacwacirr yikan pelnan kuuk Pam Porka wak-hatha. ");
INSERT INTO thd_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Pam mit rirkim, pam mih puth nurrnun kirri ŋeey-harr raakun, kar weneth minŋim ŋul ŋerŋarr-akum man ŋeeŋk minthak kar y-okunman naŋun Christak. ");
INSERT INTO thd_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Moŋoŋomur oŋkorr kar pam yirramthurr ith man thono kaar yiik ruwunanpa mih puth-thak ulp. Nurr mincminc wun kar pam mit rirkum naŋan Christak. Pam Pork ŋeey-le man ŋeeŋk nurrnuntaman. ");
INSERT INTO thd_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Mit min maŋmaŋal rirk ruwunanpa Pam Porkan, ruwunanpa paman kaarp. ");
INSERT INTO thd_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Kaaluŋeey-le, mit min ŋanŋanerr ith nul pamal yumpirr pam ulp Pam Porka warrmin yokunmannurrp reek-han nuh, ith nul mih puth-kak wunum iiwurr nul mih puth-pokonp. ");
INSERT INTO thd_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Nurr pam mih puth, pam mit rirkim nurrnan oŋkorr pac! Pam kampur wun pelnuŋun kar yokunman Pam Mih Puth nurrnun iiwurr pelnan, ikan niihin raakumunak, ŋul Nul pam pork iiwurr pam mit-rirkum kaar kunmicim. Nul pulnuŋun ŋeeŋkmam kuthirrman yokunman-nurrp. ");
INSERT INTO thd_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Ŋawoy, pamthaaw ŋathan, piinthaarrn than-harr ikan naŋun Pam Porka ith nurrnun piinthaarrn yomparr-nanurrtha. ");
INSERT INTO thd_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Warrmin pam warr thertherŋ-hatha moŋ naŋan Pam Porka kirri rok nunt pam piinthaarrn aŋarr pilwacirr than-hancih ruwunanpa Waŋ warran ith manaŋkar yorrpnurrp ŋampulŋun. ");
INSERT INTO thd_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Ŋamp pam warr kermper-kak kamkak kaarp therŋum, ŋamp waŋ-warr moŋ therŋurrtha ith mih puth-kak, ith pam pork-kak ith pam thulumkak raak ŋurnturnthurrak ŋul ŋamp pilwacirr thanan pelnan waŋwarr moŋ minc therŋ-hatha raakumun pelnantaman raak ithrrath. ");
INSERT INTO thd_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Yarri'i mimp armour moŋ naŋan Pam Porka rok-le nunt pam piinthaarrn aŋarr than-han raak warran awith ŋul thonomarr aŋarr than-hancih kaal-piinth! ");
INSERT INTO thd_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Ŋawoy, than-le mincminc man petan-kak ŋul moŋomur kaarp. Kunkunanp minc wun kar yuk putun-kak kar breastplate wacwacirr rok-le man ruwan. ");
INSERT INTO thd_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Kirri yarr yuk shoe pam kampur-kak pam yirram maŋmaŋal aŋarr wene-hanancih kuthip minmam. ");
INSERT INTO thd_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Ŋaa minc, yuk putun kirri kal, kaalaath naŋanma nunt kirk mant paathkak moŋ naŋan waŋ warra aŋarr thakanah. ");
INSERT INTO thd_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Nih kunk-thananirr ŋul ulp kar helmet paant naŋkanmak. Ith kuuk-thaaw naŋan Pam Porka kar nayp pork naŋan Ŋeeŋk-rithurr-minthak; kirri katp-le pulnun! ");
INSERT INTO thd_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Raŋkaŋk naŋun Pam Porka man ŋeeŋk naŋkanman warrmin min Nul nih aŋarr reek-hatha Ŋeeŋk-rithurr-minthurr. Pil wacirr ŋul yik minc-min naŋun Kot-thak Nul pam kaalathim moŋ min wenehanhatha, ");
INSERT INTO thd_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Kuukmin yik Naŋun ŋathanma Nul ŋah kuukthaaw wacwacirr aŋarr wan-hanah ŋay kuuk-thaaw putpun aŋarr yikah. Ŋul pam korrpaln ŋeeyhan kuthip min naŋan Christak. ");
INSERT INTO thd_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Ŋay pam kuthip-kak ŋah katharr pormpur gaolthak. Nurr wey, raŋkaŋk-le, ŋay kuthipmin kaalpiinth aŋarr yikah ŋul ŋay minc warr yik-hancih. ");
INSERT INTO thd_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Pamthaaw minc ŋathan Tychicus ith pam mit rirkum min naŋan Pam Porka nul warrmin moŋ wanhan nurrnuŋun ŋul nurr ŋathanma warrmin ŋathan moŋ aŋarr ŋeey-han ith ŋay min wuun. ");
INSERT INTO thd_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Ŋay nuh muth wunp nurrnuŋun yokunman yarri'i, nurr aŋarr kaaluŋeeyih ŋancin kana, yuur moŋon ŋul nul man ŋeeŋk nurrnan aŋarr maŋmaŋal wene-hanancih ŋancinantamantam. ");
INSERT INTO thd_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Pam kampur wun, pamthaaw ŋathan, pam ŋeeŋkmam niin ith nurr kaalaathim naŋanma Pam Porkam ulp ŋeeŋkmam nurrnuŋun, ulpnurrp Pam Naŋanipi pul Mih Puth Jesus Christanthurr. ");
INSERT INTO thd_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Kot nul min wenehanan pam moŋ ulp ŋeeŋkmam minc niinim naŋun Mih Puth Jesus Christak. Ŋawoy, leta ih'nul kana kerpir. ");
INSERT INTO thd_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Nganchn nurrngun rat yuumpr, waanr nurrngun kuuk-thaaw kunk. Nul kanpa raak inh'nemanam yanchm Kot-thak kanangkarr-antam minch. Nganchn ngeeyr ngul nganchn kana naawr meer nganchnantam-n. Ngawoy, nganchn naawr ngul nganchn yuuru katpirr nunh. ");
INSERT INTO thd_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Ilnen yat Nul pam-minch-un, ngeengk thakirn weneyr. Nganchn naawr angarr nganchn wanan-nh Nunh ngul nganchn nurrngun angarr kunanpun-nh, Nul thonomarr meerkanam niinhin. Nul pam nanganip nangn-mak wunm, Nul ngamplin kaal-pinirm-nanirr. ");
INSERT INTO thd_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Nul nganchn nurrngun waanr, nganchn naawr Nunh, ngeeyr Nunh. Kirri, ngamp thurma weneyr nganchnu-ngun, ngamp angarr pam-thaaw yomparr-na, nurr angarr nganchnungun thaaw-kokon thunp-nh, thurma pam Nanganip-n, pam Nerngka, Chiichach, Pam Porka. ");
INSERT INTO thd_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Nganchn inh'nul yuumpr, ngul ngamp mangmangal minch niin-nh. ");
INSERT INTO thd_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Kuuk yarr i'i nganchn nunh ngee-yr nangnma, Ngan Waanhanyum, pam Nerngkam; waananr nganchn nurr-ngun, Ngawoy; Kot nul miing, ngurnturnthurr pokon minch Nangun. ");
INSERT INTO thd_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Ngawoy; ith ngamp yik, “Ngamp pam-thaaw nangn yaan,” ngul ngamp mongongomr, kuuk, mit ngampulntam-n. Ngamp thaaw yiik. Ngeengk thakir ngamp-lin raak ngurnturnthurr. ");
INSERT INTO thd_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Ith ngamp raak miingith yan-chm kas Nuluth miing niinhin, kiiri — ngamp pam-thaaw thurma yarr ngamp. Kam nangn Chilchachak, pam Nerngk-nthurr, ngamplin rirrkirm-nanr raak warr mongtantam. ");
INSERT INTO thd_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Ith ngamp yik, “Mit warr nganchnan pokon,” ulp ngamp mongo-ngomr. Ulp minchminch kaarp, ngul nganchn man thono kaarp yik. ");
INSERT INTO thd_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Ngul ith ngamp raak warr ngamplin kunanpun-rr-na Nangun Kot-thak, ngamp nangun mutun thaa-yongon-nh, Nul yorrp-nurrp wach-wachirr yumpirr, koo, Nul ngamp-lin raak warram min wenenanr. Ngul ulp ngamplin rirrkirm-nan-nan raak waat koop ngampulntam. ");
INSERT INTO thd_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Ith ngamp yik, “Raak warr ngamp kaarp yumpirr,” ngamp Nunh miinnganr, monomnanr. Kuuk nangn nganchn kaarp ngeengem nangn Kot-thak. ");
ALTER TABLE thd_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
