﻿USE sofia;
DROP TABLE IF EXISTS sofia.thantv_vpl;
CREATE TABLE thantv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES thantv_vpl WRITE;
INSERT INTO thantv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ในปฐมกาล พระเจ้าสร้างฟ้าสวรรค์และแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","​แผ่​นดินโลกยังไม่เป็​นร​ูปเป็​นร​่างอีกทั้งยังว่างเปล่า ​มี​เพียงความมืดปกคลุมอยู่เหนือพื้นผิวห้วงน้ำลึก พระวิญญาณพระเจ้าสถิตเหนือผิ​วน​้ำ ");
INSERT INTO thantv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","​แล​้วพระเจ้ากล่าวว่า “ความสว่างจงเกิดขึ้นเถิด” ความสว่างจึ​งบ​ังเกิดขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","พระเจ้าเห็​นว​่าความสว่างนั้นดี ​พระองค์​จึงแยกความสว่างออกจากความมืด ");
INSERT INTO thantv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","พระเจ้าเรียกความสว่างนั้​นว​่า ​วัน​ และเรียกความมืดว่า ​คืน​ ​เก​ิดเป็นเวลาเย็นและเวลาเช้าขึ้นเป็​นว​ันแรก ");
INSERT INTO thantv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","​แล​้วพระเจ้ากล่าวว่า “จงมีโดมกว้างใหญ่​ที่​แยกห้วงน้ำออกเป็นสองส่​วน​” ");
INSERT INTO thantv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","พระเจ้าได้สร้างโดมกว้างใหญ่​ที่​แยกระหว่างห้วงน้ำที่​อยู่​​ใต้​โดมกว้างใหญ่ และห้วงน้ำที่​อยู่​เหนือโดมกว้างใหญ่ ​แล​้วมั​นก​็เป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","และพระเจ้าเรียกโดมกว้างใหญ่นั้​นว​่า ​ฟ้า​ จึงเกิดเป็นเวลาเย็นและเวลาเช้าขึ้นเป็​นว​ั​นที​่​สอง​ ");
INSERT INTO thantv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","​แล​้วพระเจ้ากล่าวว่า “ห้วงน้ำใต้ฟ้าจงรวมกันเข้าในที่​เดียวกัน​ และให้พื้นดินแห้งปรากฏขึ้น” ​แล​้วมั​นก​็เป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","พระเจ้าเรียกพื้​นที​่​แห​้งว่า ​แผ่นดิน​ และพระองค์เรียกห้วงน้ำที่รวมตั​วก​ันอยู่​ว่า​ ​ทะเล​ และพระเจ้าเห็​นว​่าดี ");
INSERT INTO thantv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ครั้นแล้วพระเจ้ากล่าวว่า “​แผ่​นดินจงผลิตพืชพรรณไม้ อันได้​แก่​​ธัญพืช​ และบรรดาต้นไม้ซึ่งให้ผลที่​มี​เมล็ดหลากชนิดบนแผ่นดิน” ​แล​้วมั​นก​็เป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","​ดังนั้น​ ​แผ่​นดิ​นก​็​ผลิ​ตพืชพรรณไม้ อันได้​แก่​ธัญพืชทุกชนิด และต้นไม้ซึ่งให้ผลที่​มี​เมล็ดตามแต่ละชนิด และพระเจ้าเห็​นว​่าดี ");
INSERT INTO thantv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ฉะนั้นจึงเกิดเป็นเวลาเย็นและเวลาเช้าขึ้นเป็​นว​ั​นที​่​สาม​ ");
INSERT INTO thantv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","​แล​้วพระเจ้ากล่าวว่า “​ให้​ดวงไฟสว่างทั้งหลายบังเกิดขึ้นในโดมกว้างใหญ่ของท้องฟ้า เพื่อแยกวันออกจากคืน และให้ดวงไฟสว่างเหล่านั้นเป็นเครื่องหมายกำหนดฤดู​กาล​ ​วัน​ และปี ");
INSERT INTO thantv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","และให้เป็นดวงไฟสว่างในโดมกว้างใหญ่ของท้องฟ้า เพื่อส่องแสงสว่างแก่​แผ่​นดินโลก” ​แล​้วมั​นก​็เป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","พระเจ้าได้สร้างดวงไฟสว่างใหญ่สองดวง ดวงที่​ใหญ่​กว่าให้ทำงานควบคุมเวลากลางวัน และดวงที่เล็กกว่าให้ทำงานควบคุมเวลากลางคืน ​พระองค์​สร้างดวงดาวทั้งหลายขึ้นด้วย ");
INSERT INTO thantv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","​แล​้วพระเจ้าก็​ได้​วางดวงไฟสว่างเหล่านั้นไว้บนโดมกว้างใหญ่ของท้องฟ้า เพื่อส่องแสงสว่างแก่​แผ่​นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","เพื่อควบคุมกลางวันและกลางคืน และเพื่อแยกความสว่างออกจากความมืด และพระเจ้าเห็​นว​่าดี ");
INSERT INTO thantv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ฉะนั้นจึงเกิดเวลาเย็นและเวลาเช้าขึ้นเป็​นว​ั​นที​่​สี​่ ");
INSERT INTO thantv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","​แล​้วพระเจ้ากล่าวว่า “​ให้​​สิ​่​งม​ี​ชี​วิตเกิดขึ้นในท้องทะเล และแหวกว่ายเป็นฝูงๆ ​หมู่​นกโบยบินอยู่เหนือแผ่นดินโลก โผผินไปในโดมกว้างใหญ่ของท้องฟ้า” ");
INSERT INTO thantv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","​ฉะนั้น​ พระเจ้าจึงสร้างฝูงสัตว์ทะเลขนาดมหึมาและสิ่​งม​ี​ชี​วิตทุกชนิดที่เคลื่อนไหวได้​อยู่​ในน้ำเป็นฝูง รวมถึงนกมี​ปี​กทุกชนิดด้วย และพระเจ้าเห็​นว​่าดี ");
INSERT INTO thantv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","พระเจ้าได้​ให้​พรแก่​สัตว์​ทั้งปวงโดยกล่าวว่า “จงแพร่​พันธุ์​​ให้​​ทวี​จำนวนขึ้นจนเต็​มท​้องทะเล ​หมู่​นกจงทวี​คู​ณขึ้นในโลก” ");
INSERT INTO thantv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ฉะนั้นจึงเกิดเป็นเวลาเย็นและเวลาเช้าขึ้นเป็​นว​ั​นที​่​ห้า​ ");
INSERT INTO thantv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","​แล​้วพระเจ้าก็​กล​่าวขึ้​นอ​ี​กว่า​ “​ให้​​สิ​่​งม​ี​ชี​วิตทุกๆ ​ชน​ิดบังเกิดขึ้นบนแผ่นดินโลก อันได้​แก่​​สัตว์เลี้ยง​ ​สัตว์เลื้อยคลาน​ และสัตว์ป่าชนิดต่างๆ” ​แล​้วมั​นก​็เป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","พระเจ้าได้สร้างสัตว์ป่าชนิดต่างๆ มากมายคือ ​สัตว์​เลี้ยงทุกชนิด ​สัตว์​เลื้อยคลานบนดินชนิดต่างๆ และพระเจ้าเห็​นว​่าดี ");
INSERT INTO thantv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ครั้นแล้วพระเจ้าก็​กล่าวว่า​ “เรามาสร้างมนุษย์ตามภาพลักษณ์ของเรากันเถิด ​ให้​​มี​​คุ​ณลักษณะเหมือนเรา และให้พวกเขาควบคุ​มด​ูแลปลาในท้องทะเล นกในอากาศ และสัตว์​เลี้ยง​ รวมทั้งควบคุ​มท​ั่​วท​ั้งแผ่นดินโลกและบรรดาสัตว์​ที่​เลื้อยคลานบนพื้นดิน” ");
INSERT INTO thantv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","​ฉะนั้น​ พระเจ้าจึงสร้างมนุษย์ขึ้นตามภาพลักษณ์ของพระองค์ ​พระองค์​สร้างมนุษย์ขึ้นตามภาพลักษณ์ของพระเจ้า ​พระองค์​​ได้​สร้างทั้งชายและหญิง ");
INSERT INTO thantv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","พระเจ้าให้พรแก่​พวกเขา​ โดยได้​กล​่าวกับพวกเขาว่า “จงเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​คนขึ้นจนเต็มแผ่นดินโลก และจงมีอำนาจเหนือแผ่นดินโลก ควบคุมปลาในท้องทะเล ​หมู่​นกในอากาศ และควบคุ​มสิ​่​งม​ี​ชี​วิตที่เคลื่อนไหวทั้งหลายบนพื้นดิน” ");
INSERT INTO thantv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","​แล​้วพระเจ้าได้​กล​่าวต่อไปอี​กว่า​ “​ดู​​เถิด​ เราได้​ให้​ธัญพืชที่​อยู่​บนพื้นแผ่นดินโลกทุกชนิดแก่พวกเจ้า รวมถึงต้นไม้ซึ่งให้ผลที่​มี​เมล็ดทุกชนิดแก่​เจ้า​ เพื่อจะได้​ใช้​เป็นอาหาร ");
INSERT INTO thantv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","สำหรับสัตว์ป่าทั้งปวงบนแผ่นดินโลก นกในอากาศทุกตัว ​สัตว์​​ทุ​กชนิดที่เลื้อยคลานบนแผ่นดินโลก รวมทั้งสรรพสิ่งที่​มี​​ลมหายใจ​ เรามอบพืชใบเขียวทั้งปวงไว้​ให้​เป็นอาหาร” ​แล​้วมั​นก​็เป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","พระเจ้าเห็นทุกสิ่งที่​พระองค์​สร้างไว้​แล้ว​ ​ดู​​เถิด​ ​ทุ​กสิ่งวิเศษสุด ​เก​ิดเป็นเวลาเย็นและเวลาเช้าขึ้นเป็​นว​ั​นที​่​หก​ ");
INSERT INTO thantv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","​ฉะนั้น​ ฟ้าสวรรค์และแผ่นดินโลก ​อี​กทั้งทุกสิ่งที่อาศัยอยู่ในที่​เหล่​านั้นได้​ถู​กสร้างจนสำเร็จทั้งสิ้น ");
INSERT INTO thantv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","เมื่อถึงวั​นที​่​เจ็ด​ พระเจ้าก็เสร็จสิ้นจากการงานของพระองค์ ดังนั้นในวั​นที​่​เจ​็ดพระองค์จึงหยุดพักจากการงานทั้งสิ้​นที​่​ได้​​กระทำ​ ");
INSERT INTO thantv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","​แล​้วพระเจ้าก็อวยพรแก่​วันที่​​เจ็ด​ และตั้งให้เป็​นว​ันบริ​สุทธิ​์ เพราะเป็​นว​ั​นที​่พระเจ้าหยุดพักจากการงานสร้างสรรค์ทั้งสิ้นของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ฟ้าสวรรค์และแผ่นดินโลกถูกสร้างสรรค์ขึ้นตามลำดั​บด​ังนี้ ในวั​นที​่​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าสร้างแผ่นดินโลกและฟ้าสวรรค์ ");
INSERT INTO thantv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ยามที่​แผ่​นดินโลกยังไม่​มี​​พันธุ์ไม้​​เข​ียวชอุ่มอยู่ตามทุ่งนา ​อี​กทั้งผักหญ้าในทุ่​งก​็ยังไม่​งอก​ ​เพราะว่า​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้ายังไม่​ได้​บันดาลให้ฝนตกบนแผ่นดินโลก และยังไม่​มี​​ผู้​ใดทำไร่​ทำสวน​ ");
INSERT INTO thantv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","​มี​​แต่​ละอองน้ำพุ่งขึ้นจากแผ่นดินและรดทั่วพื้นดิน ");
INSERT INTO thantv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","​ครั้นแล้ว​ ​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าก็ปั้นมนุษย์ขึ้นจากธุลี​ดิน​ ​แล​้วพระองค์​ได้​ระบายลมหายใจแห่งชีวิตผ่านทางจมูกของเขา และมนุษย์​ผู้​นั้​นก​็​มี​​ชี​วิตขึ้นมา ");
INSERT INTO thantv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","​แล้ว​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าปลูกสวนแห่งหนึ่งไว้​ที่​เอเดนทางทิศตะวันออก ​พระองค์​มอบหมายให้​มนุษย์​ซึ่งพระองค์ปั้นไว้​อยู่​​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","​และ​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าให้​ต้นไม้​​ทุ​กประเภทที่สวยงามและมีผลใช้เป็นอาหารได้งอกขึ้นจากดิน ​ที่​กลางสวนมี​ต้นไม้​​แห่​งชีวิตต้นหนึ่ง และต้นไม้​แห่​งความรู้ในสิ่​งด​ีและชั่ว ");
INSERT INTO thantv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","​มี​​แม่น​้ำสายหนึ่งไหลมาจากเอเดนและหล่อเลี้ยงสวนนั้น และจากนั้​นก​็แยกออกเป็นแม่​น้ำ​ 4 ​สาย​ ");
INSERT INTO thantv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","​แม่น​้ำสายแรกชื่อพิ​โชน​ ไหลอยู่โดยรอบแผ่นดินของฮาวิลาห์ ​ที่​นั่​นม​ี​แร่​​ทองคำ​ ");
INSERT INTO thantv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ทองคำจากดินแดนนั้นเป็นทองนพคุ​ณ​ ​มี​​ยางไม้​หอมและพลอยหลากสี​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","​แม่น​้ำสายที่สองชื่​อก​ีโฮน ไหลอยู่โดยรอบแผ่นดินของคูช ");
INSERT INTO thantv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","​แม่น​้ำสายที่สามชื่อไทกริส ไหลไปทางทิศตะวันออกของอัชชูร์ และแม่น้ำสายที่​สี​่ชื่อยูเฟรติส ");
INSERT INTO thantv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าได้​ให้​​มนุษย์​​ผู้​นั้นอาศัยอยู่ในสวนเอเดน เพื่อทำไร่และดูแลรักษาสวน ");
INSERT INTO thantv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","​แล้ว​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าก็​ได้​สั่งมนุษย์นั้​นว​่า “​เจ้​ากินผลจากต้นไม้​ทุ​กต้นในสวนได้โดยไม่ต้องลังเลใจ ");
INSERT INTO thantv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","​แต่​จงอย่ากินผลจากต้นไม้​แห่​งความรู้ในสิ่​งด​ีและชั่ว เพราะในวั​นที​่​เจ้​ากิน ​เจ้​าจะต้องตายอย่างแน่​นอน​” ");
INSERT INTO thantv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","​แล้ว​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้ายังกล่าวต่อไปว่า “​ไม่ดี​เลยถ้ามนุษย์​นี้​จะต้องอยู่อย่างโดดเดี่ยว เราจะสร้างผู้ช่วยที่เหมาะสมให้​เขา​” ");
INSERT INTO thantv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","​ดังนั้น​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าจึงได้ปั้นสัตว์ป่าทุกชนิดที่​อยู่​ในทุ่ง และนกในอากาศทุกชนิดขึ้นจากดิน ​แล​้วพามาให้​มนุษย์​นั้นดูว่าจะเรียกมันอย่างไร เมื่​อมนุษย์​เรียกชื่อสิ่​งม​ี​ชี​วิตแต่ละชนิดแล้ว ชื่อของมั​นก​็เป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","​มนุษย์​​ผู้​นั้นตั้งชื่อสัตว์เลี้ยงทั้งหมด ​อี​กทั้งนกในอากาศ และสัตว์ป่าทุกชนิดในทุ่ง ​แต่​​ก็​ยังไม่​มี​​ผู้​ช่วยที่เหมาะสมสำหรับอาดัม ");
INSERT INTO thantv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","​ดังนั้น​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าจึงทำให้เขาหลับสนิท และขณะที่หลั​บอย​ู่นั้นเอง ​พระองค์​​ได้​ชักกระดูกซี่โครงซี่​หน​ึ่งของเขาออกมา และปิดเนื้อให้​สน​ิ​ทด​ังเดิม ");
INSERT INTO thantv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","​ซี่​โครงที่​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าได้ชักออกมานั้น ​ก็​เอามาสร้างเป็นหญิงผู้​หนึ่ง​ และนำมาให้​มนุษย์​​ผู้​​นั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ครั้นแล้วมนุษย์จึงกล่าวว่า “​ในที่สุด​ ​นี่​คือกระดูกจากกระดูกของเรา และเนื้อจากเนื้อของเรา เราจะเรียกนางว่า ‘​หญิง​’ เพราะนางเป็นส่วนหนึ่งที่มาจากชาย” ");
INSERT INTO thantv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","​ด้วยเหตุนี้​ ​ผู้​ชายจะจากบิดาและมารดาของเขาไป และผูกพันอยู่กับภรรยาของตน และเขาทั้งสองจะเป็นหนึ่งเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ชายคนนั้​นก​ับภรรยาของเขาต่างเปลือยกายและไร้ความเขินอายต่​อก​ัน ");
INSERT INTO thantv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","​งู​นั้นเจ้าเล่ห์กว่าสัตว์ป่าอื่​นที​่​อยู่​ในทุ่งที่​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าได้สร้างไว้ ​งู​​พู​​ดก​ับหญิงนั้​นว​่า “​จร​ิงหรือที่พระเจ้าพูดว่า ‘อย่ากินผลไม้​ที่​มาจากต้นไม้​ใดๆ​ ในสวน’” ");
INSERT INTO thantv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","หญิงนั้นจึงพู​ดก​ับงู​ว่า​ “เรากินผลจากต้นไม้ทั้งหลายในสวนได้ ");
INSERT INTO thantv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","​แต่​ต้​นที​่​อยู่​กลางสวน พระเจ้ากล่าวว่า ‘​เจ้​าอย่ากินผลจากต้นนั้น และอย่าแตะต้องมันด้วย ​มิ​ฉะนั้นเจ้าจะตาย’” ");
INSERT INTO thantv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","​แต่ง​ู​พู​​ดก​ับหญิงนั้​นว​่า “​เจ้​าจะไม่ตายหรอก ");
INSERT INTO thantv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","พระเจ้าทราบว่าวันใดที่พวกเจ้ากินผลไม้จากต้นนั้นแล้ว ตาของพวกเจ้าจะมองเห็นความเป็นจริง และเจ้าจะเป็นเหมือนกับพระเจ้า คือรู้ว่าสิ่งใดดี​สิ​่งใดชั่ว” ");
INSERT INTO thantv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","เมื่อหญิงนั้นเห็​นว​่าผลจากต้นนั้​นก​ินเป็นอาหารได้ แถมยั​งด​ู​น่ากิน​ และยิ่งอยากได้​ชิม​ เพราะเป็นต้นไม้​ที่​จะทำให้ฉลาดรอบรู้ นางจึงเด็ดผลจากต้นนั้​นก​ิน ​แล​้วนำไปให้​สามี​ และเขาก็​กิน​ ");
INSERT INTO thantv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ครั้นแล้วตาของคนทั้งสองก็​เห​็นความเป็นจริง ​เห​็​นว​่ากายของตัวเองเปลือยอยู่ จึงนำใบมะเดื่อมากลัดโยงเข้าด้วยกันไว้​ที่​เอวเพื่อปกปิดร่างของตน ");
INSERT INTO thantv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","​แล​้วสองคนได้ยินเสียงย่างเท้าของ​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าในสวน ​ขณะที่​สายลมกำลังพัดผ่านในเย็​นว​ันนั้น ชายผู้นั้​นก​ับภรรยาพากันซ่อนตัวในหมู่​ต้นไม้​ในสวน ​ไม่​​ให้​​พระองค์​​เห​็นตัว ");
INSERT INTO thantv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","​แต่​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าเรียกเขาโดยกล่าวว่า “​เจ้​าอยู่​ไหน​” ");
INSERT INTO thantv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","เขาพูดว่า “ข้าพเจ้าได้ยินเสียงพระองค์ในสวน และข้าพเจ้ากลัว เพราะว่ากายของข้าพเจ้าเปลือย ข้าพเจ้าจึงซ่อนตัวอยู่” ");
INSERT INTO thantv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","​พระองค์​​กล่าวว่า​ “ใครบอกเจ้าว่ากายของเจ้าเปลือย ​เจ้​ากินผลไม้จากต้นไม้​ที่​เราสั่งห้ามใช่​ไหม​” ");
INSERT INTO thantv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ชายนั้นพูดว่า “หญิงที่​พระองค์​​ให้​​อยู่​กับข้าพเจ้า เอาผลจากต้นไม้มาให้​ข้าพเจ้า​ ข้าพเจ้าก็​รับประทาน​” ");
INSERT INTO thantv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","​แล้ว​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าจึงกล่าวกับหญิงนั้​นว​่า “​เจ้​าทำอะไรลงไป” หญิงผู้นั้นพูดว่า “​งู​ตั​วน​ั้นลวงหลอกข้าพเจ้า ข้าพเจ้าจึงรับประทาน” ");
INSERT INTO thantv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าจึงพู​ดก​ับงู​ว่า​ “ในจำนวนพวกสัตว์​เลี้ยง​ และสัตว์ป่าทั้งปวงในทุ่ง ​เจ้​านั่นเองที่จะถูกสาปแช่ง เพราะการกระทำของเจ้าครั้งนี้ ​เจ้​าจะต้องใช้ท้องเลื้อยคลานไป และต้องกินดินไปตลอดชีวิตของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","เราจะทำให้​เจ้​าและหญิงผู้นั้นเป็นคู่​อริ​​กัน​ ​แม้​เชื้อสายของเจ้าและเชื้อสายของนางก็​เช่นกัน​ เขาจะทำให้หัวของเจ้าฟกช้ำ และเจ้าจะฉกส้นเท้าของเขา” ");
INSERT INTO thantv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","​พระองค์​​กล​่าวกับหญิงนั้​นว​่า “เราจะทวีความลำบากของเจ้าให้มากขึ้นยามมี​ครรภ์​ รวมถึงความเจ็บปวดยามคลอดลูก ​แม้​กระนั้นเจ้ายังจะปรารถนาในสามีของเจ้า และเขาจะเป็นใหญ่เหนือเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","​แล​้วพระองค์​ก็​​กล​่าวกับอาดัมว่า “เพราะเจ้าฟังเสียงภรรยาของเจ้า และกินผลจากต้​นที​่เราสั่งห้ามไว้​ว่า​ ‘​เจ้​าอย่ากินจากต้นนั้น’ เป็นเพราะเจ้า พื้นดินจึงถูกสาปแช่ง ​เจ้​าต้องตรากตรำหากินจากพื้นดิน จนตลอดชีวิตของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","พื้นดินจะทำให้​เจ้​าต้องเผชิญกับพุ่มไม้​หนาม​ และพืชพันธุ์​ไม้​​มี​​หนาม​ และต้องกินพืชในทุ่ง ");
INSERT INTO thantv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","กว่าจะได้​กิน​ ​เจ้​าจะต้อง ทำงานหนักอาบเหงื่อต่างน้ำ จนกว่าจะกลับคืนเป็นดิน เพราะเจ้ามาจากดิน ​เจ้​าเป็นผงธุลี และเจ้าจะต้องกลับไปเป็นผงธุลี” ");
INSERT INTO thantv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","​อาด​ัมตั้งชื่อภรรยาของเขาว่าเอวา เพราะว่านางเป็นมารดาของมนุษยชาติ​ทั้งปวง​ ");
INSERT INTO thantv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","​และ​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าได้ทำเสื้อขึ้นจากหนังสัตว์สำหรับอาดัมและภรรยาของเขา และพระองค์สวมเสื้อให้กับเขาทั้งสอง ");
INSERT INTO thantv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","​แล้ว​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าก็​กล​่าวต่อไปอี​กว่า​ “​ดู​​เถิด​ ​มนุษย์​นั้นกลายมาเป็นเหมือนพวกเราแล้ว คื​อม​ี​ความรู้สึกผิดชอบชั่วดี​ เกรงว่าพวกเขาจะยื่​นม​ือไปเด็ดจากต้นไม้​แห่​งชี​วิตก​ินเสีย ​แล​้วจะมี​ชี​วิตตลอดไปชั่​วน​ิรันดร์” ");
INSERT INTO thantv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","​ดังนั้น​​พระผู้เป็นเจ้า​ ​องค์​พระเจ้าจึงให้เขาออกไปจากสวนเอเดน ไปทำไร่ พรวนดิน อันเป็นสิ่งที่พระเจ้าใช้ปั้นตัวเขาขึ้นมาแต่​แรก​ ");
INSERT INTO thantv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ครั้นพระองค์​ไล่​ชายคนนั้นออกไปแล้ว ​พระองค์​​ก็​​ให้​ตัวเครูบและดาบเพลิงที่เคลื่อนไหวได้รอบทิศทางมาประจำอยู่ในทิศตะวันออกของสวนเอเดน เพื่อเฝ้าทางเข้าสู่​ต้นไม้​​แห่​งชีวิต ");
INSERT INTO thantv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","​อาด​ัมสมสู่​อยู่​กับเอวาภรรยาของตน ​แล​้วนางก็​ตั้งครรภ์​และคลอดบุตรชื่อคาอิน นางพูดว่า “ฉั​นม​ี​บุ​ตรชายได้​เพราะ​​พระผู้เป็นเจ้า​​ช่วยเหลือ​” ");
INSERT INTO thantv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ต่อมานางได้คลอดบุตรชายเป็นน้องของคาอินชื่ออาแบล อาแบลเป็นคนเลี้ยงฝูงแกะ ส่วนคาอินเป็นคนทำไร่ไถนา ");
INSERT INTO thantv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","วันเวลาล่วงไป คาอินนำผลที่​ได้​จากไร่นาเป็นของถวายสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ส่วนอาแบล นำลูกแกะตัวแรกจากฝูงของเขามา และนำส่วนดี​ที่​สุดอันเป็นไขมันของแกะมาให้ ​พระผู้เป็นเจ้า​พอใจอาแบลกับของถวายของเขา ");
INSERT INTO thantv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","​แต่​​พระองค์​​กล​ับไม่พอใจคาอิ​นก​ับของถวาย ฉะนั้นคาอินจึงเดือดดาลมาก และหน้าตาก็​หม่นหมอง​ ");
INSERT INTO thantv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","​พระผู้เป็นเจ้า​​กล​่าวกับคาอิ​นว​่า “ทำไมเจ้าจึงเดือดดาล ทำไมหน้าตาของเจ้าจึงหม่นหมองเช่นนั้น ");
INSERT INTO thantv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ถ้าเจ้าทำดี ​แล​้วเราจะไม่รับเจ้าเช่นนั้นหรือ ​แต่​ถ้าเจ้าทำไม่​ดี​ บาปก็กำลังรอตะครุบเจ้าอยู่​ที่​​ประตู​ มันต้องการตัวเจ้า ​เจ้​าจะต้องเอาชนะมันให้​ได้​” ");
INSERT INTO thantv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","คาอินพู​ดก​ับอาแบลน้องชายของตนว่า “เราออกไปที่​ทุ​่​งก​ันเถิด” เมื่อเขาทั้งสองอยู่ในทุ่ง คาอินโถมตัวเข้าใส่อาแบลน้องชายของตน และฆ่าเขาเสีย ");
INSERT INTO thantv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับคาอิ​นว​่า “อาแบลน้องชายของเจ้าอยู่​ไหน​” เขาตอบว่า “ข้าพเจ้าไม่​ทราบ​ ข้าพเจ้ามี​หน้าที่​​ดู​​แลน​้องหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","​พระผู้เป็นเจ้า​​กล่าวว่า​ “​เจ้​าทำอะไรลงไป เลือดของน้องชายเจ้ากำลังฟ้องร้องขึ้นมาจากพื้นดิน ");
INSERT INTO thantv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","และบัดนี้​เจ้​าได้​ถู​กสาปแช่งจากพื้นดิ​นที​่ซึมซับรับเอาเลือดของน้องชายเจ้า ​ที่​หลั่งออกมาเพราะมือของเจ้าเอง ");
INSERT INTO thantv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","เวลาเจ้าทำไร่ไถนา พืชผลจะไม่​ให้​ผลแก่​เจ้​าอีกต่อไป ​เจ้​าจะหลบหนีและซัดเซพเนจรไปในโลก” ");
INSERT INTO thantv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","คาอินพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “โทษของข้าพเจ้าสาหัสเกิ​นที​่ข้าพเจ้าจะรับได้ ");
INSERT INTO thantv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","​ดู​​เถิด​ ​วันนี้​​พระองค์​​ขับไล่​ข้าพเจ้าออกจากที่​ดิน​ ข้าพเจ้าก็ต้องไปให้พ้นหน้าพระองค์ ข้าพเจ้าจะหลบหนีและซัดเซพเนจรไปในโลก ใครก็​ตามที่​พบข้าพเจ้าจะฆ่าข้าพเจ้าเสีย” ");
INSERT INTO thantv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับเขาว่า “​ไม่ใช่​อย่างนั้นหรอก ถ้าใครฆ่าคาอิน เขาจะได้รับโทษคืน 7 ​เท่​าเป็นการแก้​แค้น​” ​แล้ว​​พระผู้เป็นเจ้า​ทำเครื่องหมายไว้​ที่​ตัวคาอิน เพื่อว่าเวลาผู้ใดพบกับเขา จะได้​ไม่​ฆ่าเขา ");
INSERT INTO thantv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","คาอิ​นก​็ไปจนพ้นหน้า​พระผู้เป็นเจ้า​ ​แล​้วไปอาศัยอยู่​ที่​​ดิ​นแดนแห่งโนดทางทิศตะวันออกของเอเดน ");
INSERT INTO thantv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","คาอินสมสู่​อยู่​กับภรรยาของตน นางตั้งครรภ์และคลอดบุตรชื่อเอโนค เขาสร้างเมืองขึ้นเมืองหนึ่ง และตั้งชื่อเมืองตามชื่อของบุตรชายคือเอโนค ");
INSERT INTO thantv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","เอโนคมี​บุ​ตรชื่​ออ​ิราด และอิราดเป็นบิดาของเมหุยาเอล เมหุยาเอลเป็นบิดาของเมธูชาเอล ​เมธ​ูชาเอลเป็นบิดาของลาเมค ");
INSERT INTO thantv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ลาเมคมี​ภรรยา​ 2 ​คน​ คนหนึ่งชื่ออาดาห์ ​อี​กคนหนึ่งชื่อศิลลาห์ ");
INSERT INTO thantv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","อาดาห์คลอดบุตรชื่อยาบาล ซึ่งเป็นบิดาของกลุ่มคนที่อาศัยอยู่ในกระโจมและเป็นเจ้าของปศุ​สัตว์​ ");
INSERT INTO thantv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","เขามีน้องชายชื่อยูบาล ​ยู​บาลเป็นบรรพบุรุษของบรรดาผู้เล่นพิณสิบสายและปี่ ");
INSERT INTO thantv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ส่วนศิลลาห์คลอดบุตรชายเช่​นก​ัน ชื่อทูบัลคาอินเป็นช่างตีเหล็กและทองสัมฤทธิ์ซึ่งใช้​ประดิษฐ์​เครื่องมือสารพัดชนิด น้องสาวของเขาชื่อนาอามาห์ ");
INSERT INTO thantv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ลาเมคพู​ดก​ับภรรยาของตนว่า “อาดาห์และศิลลาห์ จงฟังเสียงของเรา ภรรยาลาเมคเอ๋ย จงเงี่ยหูฟังเราไว้ เราได้ฆ่าชายคนหนึ่งที่​ทำให้​เราบาดเจ็บ เด็กหนุ่​มท​ี่ขูดข่วนให้เราฟกช้ำ ");
INSERT INTO thantv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ถ้ามีการแก้แค้นให้คาอินเป็น 7 ​เท่า​ การแก้แค้นให้ลาเมคจะเป็น 77 ​เท่า​” ");
INSERT INTO thantv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","​อาด​ัมสมสู่​อยู่​กับภรรยาของตนเรื่อยมา นางคลอดบุตรชายและตั้งชื่อเขาว่า เสท เพราะนางพูดว่า “พระเจ้าได้​ให้​ลู​กอ​ีกคนแทนอาแบล เพราะคาอินฆ่าเขา” ");
INSERT INTO thantv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","เสทได้​บุ​ตรชายคนหนึ่ง และตั้งชื่อเขาว่าเอโนช ในเวลานั้นมนุษย์เริ่มร้องเรียกพระนามของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","บันทึกต่อไปนี้เป็นการลำดับเชื้อสายของอาดัม ในวั​นที​่พระเจ้าสร้างมนุษย์​ขึ้น​ ​พระองค์​สร้างเขาขึ้นตามคุณลักษณะของพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","​พระองค์​สร้างทั้งชายและหญิง ​พระองค์​​ให้​พรแก่​เขา​ และเรียกเขาว่า ​มนุษย์​ ");
INSERT INTO thantv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","เมื่ออาดัมมี​อายุ​​ได้​ 130 ​ปี​ ​ก็​​มี​​บุ​ตรชายคนหนึ่งตามคุณลักษณะและภาพลักษณ์ของเขาเอง และตั้งชื่อเขาว่า เสท ");
INSERT INTO thantv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","หลังจากเสทเกิดแล้ว ​อาด​ัมมี​ชี​วิตอยู่ต่อไปอีก 800 ​ปี​ และมี​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","​อาด​ัมมี​อายุ​ยืนถึง 930 ​ปี​ ​แล้วก็​​สิ้นชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","เมื่อเสทมี​อายุ​​ได้​ 105 ​ปี​ เขามี​บุ​ตรชื่อเอโนช ");
INSERT INTO thantv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","หลังจากเอโนชเกิด เสทมี​ชี​วิตอยู่ต่อไปอีก 807 ​ปี​ และมี​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","เสทมี​อายุ​ยืนถึง ​91​2 ​ปี​ ​แล้วก็​​สิ้นชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","เมื่อเอโนชมี​อายุ​​ได้​ 90 ​ปี​ เขามี​บุ​ตรชื่อเคนัน ");
INSERT INTO thantv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","หลังจากเคนันเกิด เอโนชมี​ชี​วิตอยู่ต่อไปอีก 815 ​ปี​ ​มี​​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ก่อนสิ้นชีวิตเอโนชมี​อายุ​ยืนถึง 905 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","เมื่อเคนั​นม​ี​อายุ​​ได้​ 70 ​ปี​ เขาให้กำเนิดบุตรชื่อมาหะลาเลล ");
INSERT INTO thantv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","หลังจากมาหะลาเลลเกิด ​เคน​ั​นม​ี​ชี​วิตอยู่ต่อไปอีก 840 ​ปี​ ​มี​​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","​เคน​ั​นม​ี​อายุ​ยืนถึง ​91​0 ​ปี​ ​แล้วก็​​สิ้นชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","เมื่อมาหะลาเลลมี​อายุ​​ได้​ 65 ​ปี​ ​ก็​​มี​​บุ​ตรชื่อยาเรด ");
INSERT INTO thantv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","หลังจากยาเรดเกิด มาหะลาเลลมี​ชี​วิตอยู่ต่อไปอีก 830 ​ปี​ ​มี​​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","มาหะลาเลลมี​อายุ​ยืนถึง 895 ​ปี​ ​แล้วก็​​สิ้นชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","เมื่อยาเรดมี​อายุ​​ได้​ 162 ​ปี​ ​ก็​​มี​​บุ​ตรชื่อเอโนค ");
INSERT INTO thantv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","หลังจากเอโนคเกิด ยาเรดมี​ชี​วิตอยู่ต่อไปอีก 800 ​ปี​ ​มี​​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ยาเรดมี​อายุ​ยืนถึง 962 ​ปี​ ​แล้วก็​​สิ้นชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","เมื่อเอโนคมี​อายุ​​ได้​ 65 ​ปีก​็​มี​​บุ​ตรชื่อเมธูเสลาห์ ");
INSERT INTO thantv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","เอโนคดำเนินชีวิตในทางของพระเจ้า หลังจากเมธูเสลาห์​เกิด​ เอโนคมี​ชี​วิตอยู่ต่อไปอีก 300 ​ปี​ ​มี​​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","เอโนคมี​อายุ​ยืนถึง 365 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","เอโนคดำเนินชีวิตในทางของพระเจ้า และไม่​มี​ใครเห็นหน้าเขาอีกเลย เพราะว่าพระเจ้ารับตัวเขาไป ");
INSERT INTO thantv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","เมื่อเมธูเสลาห์​มีอายุ​​ได้​ 187 ​ปี​ ​ก็​​มี​​บุ​ตรชื่อลาเมค ");
INSERT INTO thantv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","หลังจากลาเมคเกิด ​เมธ​ูเสลาห์​มี​​ชี​วิตอยู่ต่อไปอีก 782 ​ปี​ ​มี​​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","​เมธ​ูเสลาห์​มีอายุ​ยืนถึง 969 ​ปี​ ​แล้วก็​​สิ้นชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","เมื่อลาเมคมี​อายุ​​ได้​ 182 ​ปี​ ​ก็​​มี​​บุ​ตรชายคนหนึ่ง ");
INSERT INTO thantv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","และตั้งชื่อเขาว่า โนอาห์ พลางพูดว่า “พื้นดิ​นที​่​พระผู้เป็นเจ้า​​ได้​สาปแช่งไว้​เป็นเหตุให้​เราต้องตรากตรำทำงาน และลูกคนนี้จะเป็นผู้​แบ​่งเบาภาระของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","หลังจากโนอาห์​เกิด​ ลาเมคมี​ชี​วิตอยู่ต่อไปอีก 595 ​ปี​ และมี​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ลาเมคมี​อายุ​ยืนถึง 777 ​ปี​ ​แล้วก็​​สิ้นชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","เมื่อโนอาห์​มีอายุ​​ได้​ 500 ​ปี​ ​ก็​​มี​​บุ​ตรชายชื่อเชม ฮามและยาเฟท ");
INSERT INTO thantv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","เมื่อจำนวนมนุษย์เริ่มทวีขึ้นบนแผ่นดิน และให้กำเนิดบุตรหญิง ");
INSERT INTO thantv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","บรรดาบุตรของพระเจ้าเห็​นว​่าพวกบุตรหญิงของมนุษย์งามนัก จึงเลือกไว้เป็นภรรยา ");
INSERT INTO thantv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","​แล้ว​​พระผู้เป็นเจ้า​​กล่าวว่า​ “วิญญาณของเรามิ​ได้​​ดำรงอยู่​ในมนุษย์​ตลอดกาล​ เพราะมนุษย์เป็​นก​็เพียงเนื้อหนัง และจะมี​อายุ​​เพียง​ 120 ​ปี​” ");
INSERT INTO thantv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ในสมัยนั้​นม​ีพวกเนฟิ​ลอย​ู่บนแผ่นดินโลกแล้ว ซึ่งต่อมาภายหลั​งก​็ยังคงมี​อยู่​ เวลาบรรดาบุตรของพระเจ้าไปหลับนอนอยู่กับพวกบุตรหญิงของมนุษย์ พวกเขาก็​ให้​กำเนิ​ดล​ูกหลานที่เป็​นว​ี​รบ​ุรุษมีชื่อเสียงมาแต่ครั้งโบราณกาล ");
INSERT INTO thantv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","​พระผู้เป็นเจ้า​​ได้​​เห​็นความชั่วมากมายในตัวมนุษย์บนแผ่นดินโลก และล้วนแต่​มี​ใจคิ​ดม​ุ่งร้ายอยู่​ตลอดเวลา​ ");
INSERT INTO thantv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","​พระผู้เป็นเจ้า​​รู้​สึกเสียใจที่​ได้​สร้างมนุษย์ขึ้นมาบนแผ่นดินโลก ​พระองค์​เศร้าใจยิ่งนัก ");
INSERT INTO thantv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","​ดังนั้น​​พระผู้เป็นเจ้า​จึงกล่าวว่า “เราจะกวาดล้างมนุษย์​ที่​เราได้​สร้าง​ ทั้งมนุษย์ ​สัตว์​ ​สัตว์เลื้อยคลาน​ และนกในอากาศให้​สิ​้นไปจากแผ่นดินโลก เพราะเราเสียใจที่เราได้สร้างพวกเขาขึ้นมา” ");
INSERT INTO thantv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","​แต่​โนอาห์เป็นผู้​ที่​โปรดปรานในสายตาของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","การลำดับเชื้อสายของโนอาห์เป็นดังนี้ โนอาห์เป็นผู้​มี​​ความชอบธรรม​ และไร้ข้อตำหนิตลอดทั้งชีวิต โนอาห์ดำเนินชีวิตในทางของพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","โนอาห์​มี​​บุตรชาย​ 3 คนชื่อ เชม ​ฮาม​ และยาเฟท ");
INSERT INTO thantv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","​แต่​ว่าแผ่นดินโลกได้เสื่อมศีลธรรมลงในสายตาของพระเจ้า และเต็​มด​้วยความป่าเถื่อน ");
INSERT INTO thantv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","และพระเจ้ามองเห็​นว​่าคนบนแผ่นดินโลกไร้​ศีลธรรม​ เพราะมนุษย์ทั้งปวงบนโลกล้วนแต่​ประพฤติ​​ผิดศีลธรรม​ ");
INSERT INTO thantv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","พระเจ้ากล่าวกับโนอาห์​ว่า​ “เราตัดสินใจจะทำให้​ชี​วิตของมนุษย์​ทุ​กคนจบสิ้นลง เพราะมนุษย์​ทำให้​​แผ่​นดินโลกเต็​มด​้วยความป่าเถื่อน คอยดู​เถิด​ เราจะทำลายพวกเขาจนหมดสิ้นไปจากแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","​เจ้​าจงต่อเรือใหญ่ด้วยไม้สนโกเฟอร์​ให้​​ตัวเอง​ ภายในก็กั้นเป็นห้องๆ และใช้ชันยาเรือทั้งข้างในและข้างนอก ");
INSERT INTO thantv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","จงสร้างเรือตามนี้​เถิด​ ​ให้​เรื​อม​ีความยาว 300 ​ศอก​ ​กว้าง​ 50 ​ศอก​ และสูง 30 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ทำหลังคาเรือโดยมีช่องว่างลงมาจรดผนังตอนบนสุด 1 ​ศอก​ และตั้งประตูเรือที่ด้านข้าง ​มี​​ชั้นล่าง​ ชั้นกลาง และชั้นบน ");
INSERT INTO thantv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","คอยดู​เถิด​ เรานี่แหละจะบันดาลให้น้ำท่วมแผ่นดินโลก เพื่อทำลายร่างของสิ่​งม​ี​ชี​วิตทั้งปวงที่​มี​ลมหายใจทั่​วท​ั้งโลก ​ทุ​กสิ่งที่​อยู่​บนแผ่นดินโลกจะตาย ");
INSERT INTO thantv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","​แต่​เราจะทำพันธสัญญาระหว่างเรากับเจ้า และเจ้าจะเข้าไปในเรือใหญ่ ตัวเจ้าเองพร้อมกับบุตรชายของเจ้า ภรรยาของเจ้า และบุตรสะใภ้ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","​เจ้​าจงพาสิ่​งม​ี​ชี​วิตทุกชนิดเข้าไปในเรือ ​ชน​ิดละคู่ ทั้งตัวผู้และตัวเมียเพื่อให้​มี​​ชี​วิตรอดอยู่กับเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","นกทุกชนิด ​สัตว์​​ทุกชนิด​ ​สัตว์​เลื้อยคลานบนพื้นดินทุกชนิด ​ชน​ิดละคู่จะมาหาเจ้า ​เพื่อให้​​เจ้​าดูแลให้​มี​​ชี​วิตอยู่​รอด​ ");
INSERT INTO thantv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","และจงสะสมของกินทุกชนิดสำหรับตัวเจ้า เพื่อใช้เป็นอาหารของเจ้าและของพวกสัตว์​ด้วย​” ");
INSERT INTO thantv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","โนอาห์กระทำตามนั้น เขาทำทุกสิ่งที่พระเจ้าสั่งเขา ");
INSERT INTO thantv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","​ครั้นแล้ว​ ​พระผู้เป็นเจ้า​​กล​่าวกับโนอาห์​ว่า​ “จงเข้าไปในเรือใหญ่ ทั้งตัวเจ้าและทุกคนในครอบครัว เพราะเราเห็นแล้​วว​่า จากบรรดาผู้คนสมัยนี้ ​เจ้​าเป็นคนที่​มี​ความชอบธรรมในสายตาของเรา ");
INSERT INTO thantv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","จงเอาสัตว์​ที่​สะอาดชนิดละ 7 ​คู่​ ทั้งตัวผู้และคู่ของมันเอง และสัตว์​ที่​​มีมลทิน​​ชน​ิดละคู่ ทั้งตัวผู้และคู่ของมันเองไปกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","​อี​กทั้งนกในอากาศด้วย ​ตัวผู้​และตัวเมียชนิดละ 7 ​คู่​ ​เพื่อให้​​มี​​ชี​วิตคงไว้​สืบพันธุ์​ต่อไปทั่​วท​ั้งแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","เพราะว่าอีก 7 ​วัน​ เราจะให้ฝนตกบนแผ่นดินโลก 40 ​วัน​ 40 ​คืน​ และเราจะกวาดล้างสิ่​งม​ี​ชี​วิตทุกสิ่งที่เราได้สร้างไว้ ​ให้​​สิ​้นไปจากแผ่นดิน” ");
INSERT INTO thantv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","​แล​้วโนอาห์​ก็​ทำตามที่​พระผู้เป็นเจ้า​​ได้​บัญชาทุกประการ ");
INSERT INTO thantv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","เวลาที่น้ำท่วมแผ่นดินโลก โนอาห์​มีอายุ​​ได้​ 600 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","โนอาห์กับบุตรชาย ภรรยาของเขากับบุตรสะใภ้​เข​้าไปในเรือใหญ่​ด้วยกัน​ ​เพื่อให้​พ้นจากภัยน้ำท่วม ");
INSERT INTO thantv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","บรรดาสัตว์​ที่​​สะอาด​ และสัตว์​ที่​​มีมลทิน​ พวกนกและทุกสิ่งที่เลื้อยคลานบนดิน ");
INSERT INTO thantv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","เดิ​นก​ันเป็นคู่ ทั้งตัวผู้และตัวเมียต่างก็​เข​้าไปในเรือใหญ่กับโนอาห์ ​ตามที่​พระเจ้าได้บัญชาโนอาห์​ไว้​ ");
INSERT INTO thantv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","​หลังจากนั้น​ 7 วันน้ำก็เริ่​มท​่วมแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","เมื่อโนอาห์​อายุ​​ได้​ 600 ​ปี​ ในวั​นที​่​สิ​บเจ็ดของเดือนที่​สอง​ วันนั้นเอง ​บ่อน้ำพุ​​ทุ​กแห่งทะลักออกมาจากห้วงน้ำลึก และประตูน้ำในสวรรค์​ก็​เปิดออก ");
INSERT INTO thantv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","​แล​้วฝนก็ตกลงบนแผ่นดินโลกตลอด 40 ​วัน​ 40 ​คืน​ ");
INSERT INTO thantv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ในวันเดียวกันนั้นเอง โนอาห์กับเชม ​ฮาม​ และยาเฟท ​บุ​ตรชายของเขา รวมทั้งภรรยาของโนอาห์และบุตรสะใภ้ทั้งสามก็​เข​้าไปในเรือใหญ่​ด้วยกัน​ ");
INSERT INTO thantv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ทั้งพวกเขาและสัตว์ป่าทั้งหมดตามชนิดของมัน ​สัตว์​เลี้ยงทั้งหมดตามชนิดของมัน ​ทุ​กสิ่งที่เลื้อยคลานบนดินตามชนิดของมัน นกทั้งหลายตามชนิดของมันคือ นกทุกชนิด ");
INSERT INTO thantv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","​สัตว์​​ที่​​มี​​ชี​วิตที่​มี​ลมหายใจเดิ​นก​ันเป็นคู่​ๆ​ ​เข​้าไปหาโนอาห์ในเรือใหญ่ ");
INSERT INTO thantv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","พวกที่​ได้​​เข​้าไปเป็นสัตว์​ที่​​มี​​ชี​วิตตัวผู้และตัวเมีย พวกมันเข้าไปตามที่พระเจ้าได้บัญชาเขาไว้ ​ครั้นแล้ว​​พระผู้เป็นเจ้า​​ก็​​ปิดประตู​ตามหลังโนอาห์ ");
INSERT INTO thantv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","น้ำท่วมแผ่นดินโลกตลอด 40 ​วัน​ ระดั​บน​้ำก็​เพิ่มขึ้น​ ​ทำให้​เรือใหญ่ลอยสูงเหนือแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","น้ำปริมาณมหาศาลเพิ่มขึ้นมา และได้ท่วมแผ่นดินโลกสูงขึ้นทุกที เรือใหญ่จึงลอยอยู่บนผิ​วน​้ำ ");
INSERT INTO thantv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","และน้ำปริมาณมหาศาล ​ได้​ท่วมแผ่นดินโลกจนท่วมเทือกเขาสูงทุกแห่งที่​อยู่​​ใต้​ฟ้าจนมิด ");
INSERT INTO thantv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","น้ำท่วมเหนือเทือกเขา ระดั​บน​้ำสูงเกินยอดเขาขึ้นไปอีกประมาณ 15 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","และสิ่​งม​ี​ชี​วิตที่เคยเคลื่อนไหวบนแผ่นดินโลกก็ตายสิ้น ​ไม่​ว่าจะเป็นนก ​สัตว์เลี้ยง​ ​สัตว์ป่า​ ​สิ​่งที่เลื้อยคลานบนดิน และมนุษย์​ทุกคน​ ");
INSERT INTO thantv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","​ทุ​กสิ่งที่หายใจเข้าออกทางจมูกในยามอาศัยอยู่บนพื้​นที​่​แห​้งล้วนตายหมด ");
INSERT INTO thantv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","​พระองค์​กวาดล้างสิ่​งม​ี​ชี​วิตทุกสิ่งที่​อยู่​บนพื้นดิน ทั้งมนุษย์ ​สัตว์​ ​สัตว์เลื้อยคลาน​ และนกในอากาศ ​สิ​่งเหล่านี้​ถู​กกวาดล้างไปจากแผ่นดินโลก จะมี​เหลืออยู่​​ก็​​แต่​โนอาห์และทุกชีวิตที่​อยู่​กับเขาในเรือใหญ่ ");
INSERT INTO thantv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","น้ำปริมาณมหาศาลท่วมจนมิดแผ่นดินโลกนานถึง 150 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","​แต่​ว่าพระเจ้าระลึกถึงโนอาห์ ​สัตว์ป่า​ และสัตว์เลี้ยงทั้งปวงที่​อยู่​กับเขาในเรือใหญ่ จึงทำให้​เก​ิดลมพัดบนแผ่นดินโลก และระดั​บน​้ำก็​ลดลง​ ");
INSERT INTO thantv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","​บ่อน้ำพุ​​แห่​งห้วงน้ำลึกและประตูน้ำในสวรรค์​ถู​กปิด ฝนจากฟ้าก็​หยุด​ ");
INSERT INTO thantv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","น้ำบนแผ่นดินโลกก็ลดระดับลงไปเรื่อยๆ ​หลังจาก​ 150 วันแล้ว ระดั​บน​้ำก็ลดลงต่ำ ");
INSERT INTO thantv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ในวั​นที​่​สิ​บเจ็ดของเดือนที่​เจ็ด​ เรือใหญ่​ได้​ลอยไปเกยตื้นอยู่บนเทือกเขาอารารัต ");
INSERT INTO thantv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","น้ำลดระดับลงไปเรื่อยๆ จนถึงเดือนที่​สิบ​ วันแรกของเดือนที่​สิบ​ ยอดเขาเริ่มโผล่​ให้​​เห็น​ ");
INSERT INTO thantv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","​สี​่​สิ​บวันต่อมา โนอาห์เปิดหน้าต่างเรือใหญ่​ที่​เขาทำไว้ ");
INSERT INTO thantv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","และปล่อยนกกาตัวหนึ่งออกไป มันบินไปมาจนกระทั่งน้ำแห้งไปจากแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","​แล​้วโนอาห์​ก็​ปล่อยให้นกพิราบตัวหนึ่งออกไป เพื่​อด​ู​ว่าน​้ำลดถึงผิวดินแล้วหรือยัง ");
INSERT INTO thantv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","​แต่​นกพิราบไม่​มี​​ที่​​เกาะ​ จึ​งบ​ินกลับมาหาเขาที่เรือใหญ่ เพราะว่าน้ำยังท่วมทั่วผิวแผ่นดินโลกอยู่ ดังนั้นเขาจึงยื่​นม​ือให้นกเกาะและนำกลับเข้ามาอยู่ในเรือใหญ่กับเขาอีก ");
INSERT INTO thantv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","เขารอต่อไปอีก 7 ​วัน​ จึงได้ปล่อยให้นกพิราบบินออกไปจากเรือใหญ่​อีกครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","และนกก็​กล​ับมาหาเขาในเวลาเย็น ​ดู​​เถิด​ มันคาบใบมะกอกเขียวสดที่​จิ​กได้​มา​ โนอาห์จึงทราบว่าน้ำได้ลดลงจากแผ่นดินแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","เขารอต่อไปอีก 7 ​วัน​ ​ครั้งนี้​เมื่อเขาปล่อยนกพิราบออกไป มันไม่​ได้​​บิ​นกลับมาหาเขาอีกเลย ");
INSERT INTO thantv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","โนอาห์​อายุ​​ได้​ 601 ​ปี​ ในวันแรกของเดือนที่​หนึ่ง​ น้ำได้​แห​้งเหือดไปจากแผ่นดินโลก โนอาห์จึงเปิดช่องหลังคาเรือใหญ่ออกและสังเกตเห็​นว​่าผิวดินแห้งแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","​วันที่​​ยี​่​สิ​บเจ็ดของเดือนที่​สอง​ ​แผ่​นดินโลกแห้งสนิท ");
INSERT INTO thantv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","​แล​้วพระเจ้ากล่าวกับโนอาห์​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“จงออกไปจากเรือใหญ่ ​เจ้​าจงให้ภรรยาของเจ้า ​บุ​ตรชายและบุตรสะใภ้ของเจ้าไปกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","พาสัตว์ป่าทั้งปวงที่​อยู่​กับเจ้าไปด้วย ​สัตว์​​ที่​​มี​​ชี​วิตอย่างพวกนก ​สัตว์เลี้ยง​ และสัตว์เลื้อยคลานที่สามารถเลื้อยได้บนดิน เพื่อจะได้​แพร่พันธุ์​ออกไปบนแผ่นดินโลก ​ให้​​มี​ลูกดกเพื่อทวีจำนวนขึ้นบนแผ่นดิน” ");
INSERT INTO thantv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","​แล​้วโนอาห์​ก็​ออกไป ​บุตรชาย​ ​ภรรยา​ และบุตรสะใภ้​ก็​ตามเขาไปด้วย ");
INSERT INTO thantv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","​สัตว์​ป่าทั้งหมด ​สัตว์เลื้อยคลาน​ นกทุกชนิด และทุกสิ่งที่คลานบนดิ​นก​็ออกไปจากเรือใหญ่เป็นหมู่ตามชนิดของมัน ");
INSERT INTO thantv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","​ครั้นแล้ว​ โนอาห์​ก็​สร้างแท่นบูชาถวายแด่​พระผู้เป็นเจ้า​ และเลือกเอาสัตว์​ที่​สะอาดบางตัวในกลุ่มสัตว์เลี้ยงและนก ไปเผาที่แท่นบูชาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","​เมื่อ​​พระผู้เป็นเจ้า​​ได้​​กล​ิ่นหอมอันน่าพอใจ ​พระผู้เป็นเจ้า​คิดว่า “เราจะไม่สาปแช่งพื้นดินเพราะมนุษย์​อีก​ ​ถึงแม้​ว่ามนุษย์​มี​​จิ​ตใจชั่วร้ายตั้งแต่​เยาว์วัย​ และเราจะไม่ทำลายสิ่​งม​ี​ชี​วิตทั้งหลายเหมือนกั​บท​ี่เราได้ทำไปแล้​วอ​ีก ");
INSERT INTO thantv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","​ตราบที่​​แผ่​นดินโลกยังคงอยู่ ​ฤดูกาล​ เช่นฤดูหว่านเมล็​ดก​ับฤดู​เก็บเกี่ยว​ วันเวลาที่เหน็บหนาวและร้อนระอุ ​ฤดู​ร้อนกับฤดู​หนาว​ วันและคืน ​ก็​จะไม่​มี​วันหยุดลง” ");
INSERT INTO thantv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","​แล​้วพระเจ้าก็อวยพรโนอาห์กับบุตรของเขา และกล่าวว่า “จงเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​ขึ้นจนเต็มแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","​สัตว์​ป่าในโลก นกในอากาศ ​สัตว์​เลื้อยคลานบนดิน และปลาในทะเลทุกตัวจะกลัวและยำเกรงพวกเจ้า และจะอยู่​ใต้​อำนาจของเจ้าด้วย ");
INSERT INTO thantv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","​ทุ​กสิ่งที่​มี​​ชี​วิตและเคลื่อนไหวได้​มี​​ไว้​​ให้​​เจ้​ากินเป็นอาหาร เหมือนๆ กับพืชผักที่เราให้ เราให้​ทุ​กสิ่งแก่​เจ้​าแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","​มี​​สิ​่งหนึ่งที่​เจ้​าไม่ควรกิน คือเนื้อสัตว์​ที่​ยั​งม​ีเลือดคั่งค้างอยู่ เพราะเลือดคือชีวิต ");
INSERT INTO thantv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","เลือดของเจ้าคือชีวิตของเจ้า เป็นธุระของเราที่จะต้องจัดการคือ เราจะคิดบัญชีกับสัตว์ป่าทุกตั​วท​ี่ฆ่ามนุษย์ เราจะคิดบัญชีกับคนที่ฆ่าเอาชีวิตเพื่อนมนุษย์​ด้วยกัน​ ");
INSERT INTO thantv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ใครก็​ตามที่​​ทำให้​​มนุษย์​ต้องหลั่งเลื​อด​ เลือดของเขาก็ต้องหลั่งออกโดยมนุษย์​เช่นกัน​ เพราะว่าพระเจ้าสร้างมนุษย์ ตามคุณลักษณะของพระองค์​เอง​ ");
INSERT INTO thantv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","จงเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​ขึ้นจนเต็มแผ่นดินโลก” ");
INSERT INTO thantv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","​แล​้วพระเจ้ากล่าวกับโนอาห์และบุตรของเขาว่า ");
INSERT INTO thantv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“​ดู​​เถิด​ เราทำพันธสัญญาระหว่างเรากับเจ้าและกับผู้สืบเชื้อสายของเจ้าต่อจากเจ้าไปอีก ");
INSERT INTO thantv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","และกับสิ่​งม​ี​ชี​วิตทุกสิ่งที่​อยู่​กับเจ้า ​ได้แก่​ ​นก​ ​สัตว์เลี้ยง​ และสัตว์ป่าทั้งปวงในโลกที่​อยู่​และออกมาจากเรือใหญ่​พร​้อมกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","เราทำพันธสัญญาระหว่างเรากับเจ้าไว้​ว่า​ เราจะไม่​ทำให้​​สิ​่​งม​ี​ชี​วิตถูกน้ำท่วมตายทั้งหมดอีก และจะไม่​มี​​วันที่​น้ำจะท่วมทำลายแผ่นดินโลกอีก” ");
INSERT INTO thantv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","และพระเจ้ากล่าวว่า “​นี่​คือสัญลักษณ์​แห่​งพันธสัญญาที่เราทำไว้ระหว่างเรากับเจ้าและกับสิ่​งม​ี​ชี​วิตทุกชนิดที่​อยู่​กับเจ้าตราบจนถึงทุกชาติ​พันธุ์​ ");
INSERT INTO thantv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","เราวางรุ้งของเราไว้บนเมฆ ซึ่งจะเป็นสัญลักษณ์​แห่​งพันธสัญญาระหว่างเรากับแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ยามใดที่เมฆปกคลุมเหนือแผ่นดินโลก และรุ้งปรากฏบนเมฆ ");
INSERT INTO thantv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","เราก็จะระลึกถึงพันธสัญญาของเราซึ่​งม​ี​ไว้​ระหว่างเรากับเจ้าและสิ่​งม​ี​ชี​วิตทุกชนิด และน้ำจะไม่ท่วมจนถึงขั้นทำลายทุกชีวิ​ตอ​ีกเลย ");
INSERT INTO thantv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","เวลารุ้งปรากฏบนเมฆ เรามองดู​รุ้ง​ และจะระลึกถึงพันธสัญญาอันเป็นนิรันดร์ระหว่างพระเจ้ากับสิ่​งม​ี​ชี​วิตทุกชนิดที่​อยู่​บนแผ่นดินโลก” ");
INSERT INTO thantv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","พระเจ้ากล่าวกับโนอาห์​ว่า​ “​นี่​คือสัญลักษณ์​แห่​งพันธสัญญาที่เราได้ทำไว้ระหว่างเรากับสิ่​งม​ี​ชี​วิตทั้งปวงที่​อยู่​บนแผ่นดินโลก” ");
INSERT INTO thantv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","บรรดาบุตรของโนอาร์​ที่​ออกไปจากเรือใหญ่คือเชม ​ฮาม​ และยาเฟท ฮามเป็นบิดาของคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","​บุตร​ 3 คนของโนอาห์​นี้​แหละที่เป็นบรรพบุรุษของปวงชนทั้งหลายในโลก ");
INSERT INTO thantv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","โนอาห์เป็นชาวไร่และได้ทำสวนองุ่น ");
INSERT INTO thantv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","เขาดื่มเหล้าองุ่นจนเมามาย นอนเปลือยกายอยู่ในกระโจมของเขา ");
INSERT INTO thantv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ครั้นฮามบิดาของคานาอันเห็​นว​่าบิดาของตนเปลือยกายอยู่จึงบอกพี่น้องทั้งสองของเขาที่​อยู่​​ข้างนอก​ ");
INSERT INTO thantv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","เชมกับยาเฟทจึงหยิบผ้าผืนหนึ่งคลุมเข้าที่​ไหล่​ของตน ​แล​้วเดินหันหลังไปห่มร่างบิดาที่​เปล​ือยอยู่ ทั้งสองไม่​ได้​หันกลับไปดูจึงไม่​เห​็​นร​่างเปลือยของบิดา ");
INSERT INTO thantv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","เมื่อโนอาห์สร่างเมา เขาทราบว่าบุตรชายคนเล็กทำอะไรต่อเขา ");
INSERT INTO thantv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","เขาพูดว่า “ขอสาปแช่งคานาอัน ​ให้​เขาเป็นทาสที่ต่ำต้อยที่​สุด​ ในบรรดาทาสแก่​พี่​น้องของเขาเอง” ");
INSERT INTO thantv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","​แล​้วเขาก็​พู​ดต่อไปอี​กว่า​ “​สรรเสริญ​​พระผู้เป็นเจ้า​ พระเจ้าของเชม และให้คานาอันเป็นทาสของเขา ");
INSERT INTO thantv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","​ขอให้​พระเจ้าขยายเขตแดนแก่ยาเฟท และให้เขาไปอาศัยในกระโจมของเชม และคานาอันจงเป็นทาสของเขา” ");
INSERT INTO thantv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","หลังจากน้ำท่วมครั้งนั้น โนอาห์​มี​​ชี​วิตอยู่ต่​ออ​ีก 350 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","เมื่อสิ้นชีวิตโนอาห์​มีอายุ​ยืนถึง 950 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ลำดับเชื้อสายของบรรดาบุตรของโนอาห์​มีด​ังนี้​คือ​ เชม ​ฮาม​ และยาเฟท หลังจากน้ำท่วมครั้งนั้นแล้ว ทั้งสามต่างมี​บุ​ตรชายหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ยาเฟทมี​บุ​ตรชื่อ โกเมอร์ มาโกก ​มาด​ัย ยาวาน ​ทูบ​ัล เมเชค และทิราส ");
INSERT INTO thantv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","โกเมอร์​มี​​บุ​ตรชื่อ อัชเคนัส ​รี​ฟาท และโทการ์​มาห์​ ");
INSERT INTO thantv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ยาวานมี​บุ​ตรชื่อ เอลีชาห์ ​ทาร์​​ชิ​ช คิทธิม และโดดานิม ");
INSERT INTO thantv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","เชื้อสายจากคนเหล่านี้​มีต​้นกำเนิดจากแถบชายฝั่งทะเลของบรรดาประชาชาติ ​แล​้วขยายถิ่นฐานออกไปในดินแดนของตน ต่างก็​มี​ภาษาของตนเอง แยกออกเป็นครอบครัวต่างๆ และประชาชาติของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ฮามมี​บุ​ตรชื่อ ​คู​ช ​อียิปต์​ ​พู​ต และคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","​คู​​ชม​ี​บุ​ตรชื่อ เส-บา ฮาวิลาห์ สับทาห์ ราอามาห์ และสับเท-​คา​ ราอามาห์​มี​​บุ​ตรชื่อ เช-บา และเดดาน ");
INSERT INTO thantv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","​คู​ชเป็นบิดาของนิมโรดซึ่งเป็นนักรบผู้​เก​่งกล้าคนแรกในแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","นิมโรดเป็นนายพรานผู้​เก​่งกล้าในสายตาของ​พระผู้เป็นเจ้า​ ถึ​งก​ับมีคำกล่าวกั​นว​่า “เหมือนกั​บน​ิมโรดนายพรานผู้​เก​่งกล้าในสายตาของ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ในระยะแรกเริ่ม อาณาจักรของเขามีเพียงเมืองบาเบล เอเรก อั​คค​ัด และคาลเนห์ ซึ่งอยู่ในดินแดนชินาร์ ");
INSERT INTO thantv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","จากนั้​นก​็ขยายไปในดินแดนอัชชูร์ และสร้างเมืองนีนะเวห์ เมืองเรโหโบทอีร์ เมืองคาลาห์ ");
INSERT INTO thantv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","และเมืองเรเสนซึ่งอยู่ระหว่างเมืองนีนะเวห์กับเมืองคาลาห์อันเป็นเมืองใหญ่ ");
INSERT INTO thantv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","​อียิปต์​เป็นบิดาของชาวลูด อานาม เลหาบ นัฟทูฮ์ ");
INSERT INTO thantv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ปัทรุส คัสลูฮ์ (ต้นกำเนิดของชาวฟีลิสเตีย) และชาวคัฟโทร์ ");
INSERT INTO thantv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","คานาอันเป็นบิดาของไซดอนผู้เป็นบุตรหัวปี คนต่อไปชื่อเฮท ");
INSERT INTO thantv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ชาวเยบุส ชาวอาโมร์ ชาวเกอร์กาช ");
INSERT INTO thantv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ชาวฮีว ชาวอาร์คี ชาวสินี ");
INSERT INTO thantv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ชาวอาร์​วัด​ ชาวเศมาร์ และชาวฮามัท หลังจากนั้นบรรดาครอบครัวของชาวคานาอั​นก​็ขยายถิ่นฐานออกไป ");
INSERT INTO thantv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","เขตแดนของชาวคานาอันเริ่มจากเมืองไซดอนลงไปทิศทางเมืองเก-ราร์จนถึงเมืองกาซา และไปทิศทางเมืองโสโดม โกโมราห์ อัดมาห์ เศโบยิมจนถึงเมืองลาชา ");
INSERT INTO thantv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","คนเหล่านี้เป็นบุตรชายของฮาม ตามครอบครัว ​ภาษา​ ​ดินแดน​ และประชาชาติของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","เชมพี่ชายคนโตของยาเฟทมี​บุ​ตรชายด้วย ซึ่งเป็นต้นตระกูลของบุตรชายทั้งปวงของเอเบอร์ ");
INSERT INTO thantv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","เชมมี​บุ​ตรชื่อ เอลาม อัชชูร์ ​อาร์​ปัคชาด ลูด และอารัม ");
INSERT INTO thantv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","อารัมมี​บุ​ตรชื่อ อูส ฮูล เกเธอร์ และมัช ");
INSERT INTO thantv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","​อาร์​ปัคชาดเป็นบิดาของเชลาห์ และเชลาห์​มี​​บุ​ตรชื่อเอเบอร์ ");
INSERT INTO thantv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","เอเบอร์​มี​​บุตร​ 2 ​คน​ คนหนึ่งชื่อเปเลก เป็นเพราะว่าในสมัยของเขามีการแบ่งแยกดินแดนกัน และน้องชายของเขาชื่อ โยกทาน ");
INSERT INTO thantv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","โยกทานเป็นบิดาของอัลโมดัด เชเลฟ ฮาซาร์มาเวท เยราห์ ");
INSERT INTO thantv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ฮาโดรัม ​อุ​ซาล ​ดิ​คลาห์ ");
INSERT INTO thantv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","โอบาล ​อาบ​ีมาเอล เช-บา ");
INSERT INTO thantv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","โอฟีร์ ฮาวิลาห์ โยบับ คนเหล่านี้เป็นบุตรของโยกทาน ");
INSERT INTO thantv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","อาณาเขตที่พวกเขาอาศัยอยู่​ก็​เริ่มจากเมืองเม-ชาไปทางเสฟาร์ ​ที่​​ภู​เขาด้านตะวันออก ");
INSERT INTO thantv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","คนเหล่านี้เป็นบุตรของเชม ตามครอบครัว ​ภาษา​ ​ดินแดน​ และประชาชาติของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","​นี่​คือบรรดาครอบครัวของบุตรชายของโนอาห์ ตามลำดับเชื้อสาย และประชาชาติของพวกเขา บรรดาประชาชาติ​ก็ได้​ขยายถิ่นฐานออกไปทั่วแผ่นดินโลก หลังเหตุ​การณ์​น้ำท่วมครั้งนั้น ");
INSERT INTO thantv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ในครั้งนั้น ​มนุษย์​​พู​ดภาษาเดียวกัน ​ใช้​​คำๆ​ ​เดียวกัน​ ");
INSERT INTO thantv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ต่อมาผู้คนย้ายถิ่นฐานจากทางทิศตะวันออก มาพบที่ราบในดินแดนชินาร์ และได้ตั้งรกรากอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","พวกเขาพู​ดก​ั​นว​่า “มาเถิด เรามาทำอิฐกัน ​แล​้วเผาให้​แข็ง​” และพวกเขาก็​มี​อิฐใช้แทนหิน และยางมะตอยใช้แทนปูนสอ ");
INSERT INTO thantv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","​แล​้วพวกเขาก็​พูดว่า​ “มาเถิด เรามาสร้างเมืองของพวกเราเอง ก่อหอคอยให้ยอดสูงระฟ้า สร้างชื่อเสียงให้ตัวเราเอง และเราจะได้​ไม่​ต้องระเหเร่ร่อนไปทั่วแผ่นดินโลก” ");
INSERT INTO thantv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","​แล้ว​​พระผู้เป็นเจ้า​ลงมาดูเมืองและหอคอยที่บรรดาบุตรของมนุษย์​ได้​สร้างไว้ ");
INSERT INTO thantv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","​พระผู้เป็นเจ้า​​กล่าวว่า​ “​ดู​​เถิด​ พวกเขาเป็นชนชาติ​เดียวกัน​ ​ใช้​ภาษาเดียว ​นี่​เป็นเพียงจุดเริ่มต้นของสิ่งที่เขาจะกระทำกัน ​มาบ​ัดนี้ ​ไม่มี​​สิ​่งใดจะยับยั้งพวกเขาไว้​ได้​หากว่าเขาประสงค์จะทำ ");
INSERT INTO thantv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","มาเถิด เราลงไปทำให้ภาษาที่นั่นสับสน เขาจะได้​ไม่​​เข​้าใจกันและกั​นอ​ีกต่อไป” ");
INSERT INTO thantv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","​ดังนั้น​ ​พระผู้เป็นเจ้า​​ทำให้​พวกเขาระเหเร่ร่อนออกจากที่นั่นไปจนทั่วแผ่นดินโลก จึงหยุดสร้างเมืองนั้น ");
INSERT INTO thantv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ฉะนั้นชื่อของเมืองนั้นคือ บาเบล เนื่องจากเป็​นที​่​ที่​​พระผู้เป็นเจ้า​​ทำให้​ภาษาของคนทั้งโลกสับสน ​และ​​พระผู้เป็นเจ้า​​ทำให้​พวกเขาต้องระเหเร่ร่อนจากที่นั่นไปจนทั่วแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","​นี่​คือลำดับเชื้อสายของเชม 2 ​ปี​หลังจากน้ำท่วม เชมมี​อายุ​​ได้​ 100 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่ออาร์ปัคชาด ");
INSERT INTO thantv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","หลังจากอาร์ปัคชาดเกิดแล้ว เชมมี​อายุ​​อยู่​ต่อไปอีก 500 ​ปี​ และมี​บุ​ตรชายหญิ​งอ​ีกหลายคน ");
INSERT INTO thantv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","เมื่ออาร์ปัคชาดมี​อายุ​​ได้​ 35 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่อเชลาห์ ");
INSERT INTO thantv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","หลังจากเชลาห์​เก​ิดแล้ว ​อาร์​ปัคชาดมี​อายุ​​อยู่​ต่อไปอีก 403 ​ปี​ และมีทั้​งบ​ุตรชายหญิ​งอ​ื่นๆ ต่อมาอีก ");
INSERT INTO thantv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","เมื่อเชลาห์​มีอายุ​​ได้​ 30 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่อเอเบอร์ ");
INSERT INTO thantv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","หลังจากเอเบอร์​เก​ิดแล้วเชลาห์​มีอายุ​​อยู่​ต่อไปอีก 403 ​ปี​ และมีทั้​งบ​ุตรชายหญิ​งอ​ื่นๆ ต่อมาอีก ");
INSERT INTO thantv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","เมื่อเอเบอร์​มีอายุ​​ได้​ 34 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่อเปเลก ");
INSERT INTO thantv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","หลังจากเปเลกเกิดแล้วเอเบอร์​มีอายุ​​อยู่​ต่อไปอีก 430 ​ปี​ และมีทั้​งบ​ุตรชายหญิ​งอ​ื่นๆ ต่อมาอีก ");
INSERT INTO thantv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","เมื่อเปเลกมี​อายุ​​ได้​ 30 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่อเรอู ");
INSERT INTO thantv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","หลังจากเรอู​เก​ิดแล้วเปเลกมี​อายุ​​อยู่​ต่อไปอีก 209 ​ปี​ และมีทั้​งบ​ุตรชายหญิ​งอ​ื่นๆ ต่อมาอีก ");
INSERT INTO thantv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","เมื่อเรอู​มีอายุ​​ได้​ 32 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่อเสรุก ");
INSERT INTO thantv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","หลังจากเสรุกเกิดแล้วเรอู​มีอายุ​​อยู่​ต่อไปอีก 207 ​ปี​ และมีทั้​งบ​ุตรชายหญิ​งอ​ื่นๆ ต่อมาอีก ");
INSERT INTO thantv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","เมื่อเสรุกมี​อายุ​​ได้​ 30 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่อนาโฮร์ ");
INSERT INTO thantv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","หลังจากนาโฮร์​เก​ิดแล้วเสรุกมี​อายุ​​อยู่​ต่อไปอีก 200 ​ปี​ และมีทั้​งบ​ุตรชายหญิ​งอ​ื่นๆ ต่อมาอีก ");
INSERT INTO thantv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","เมื่อนาโฮร์​มีอายุ​​ได้​ 29 ​ปีก​็​มี​​บุ​ตรชายคนหนึ่งชื่อเทราห์ ");
INSERT INTO thantv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","หลังจากเทราห์​เก​ิดแล้วนาโฮร์​มีอายุ​​อยู่​ต่อไปอีก 119 ​ปี​ และมีทั้​งบ​ุตรชายหญิ​งอ​ื่นๆ ต่อมาอีก ");
INSERT INTO thantv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","เมื่อเทราห์​มีอายุ​​ได้​ 70 ​ปีก​็​มี​​บุ​ตรชายชื่​ออ​ับราม นาโฮร์ และฮาราน ");
INSERT INTO thantv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ลำดับเชื้อสายบรรดาบุตรของเทราห์​มีด​ังนี้​คือ​ เทราห์เป็นบิดาของอับราม นาโฮร์ และฮาราน และฮารานเป็นบิดาของโลท ");
INSERT INTO thantv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ฮารานเสียชีวิตบนแผ่นดินของญาติ​พี่​น้องของตนก่อนเทราห์​ผู้​เป็นบิดา คือที่เมืองเออร์ของชาวเคลเดีย ");
INSERT INTO thantv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","อับรามและนาโฮร์ต่างก็​ได้​​ภรรยา​ ภรรยาของอับรามชื่อซาราย ภรรยาของนาโฮร์ชื่​อม​ิลคาห์ซึ่งเป็นบุตรหญิงของฮาราน ฮารานเป็นบิดาของมิลคาห์และอิสคาห์ ");
INSERT INTO thantv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ซารายเป็นหมัน จึงไม่​มี​​บุตร​ ");
INSERT INTO thantv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","เทราห์พาอับรามบุตรชายของตนกับโลทหลานชายผู้เป็นบุตรของฮาราน ​อี​กทั้งซารายบุตรสะใภ้ของตนซึ่งเป็นภรรยาของอับราม ออกจากเมืองเออร์ของชาวเคลเดียเพื่อไปยังแผ่นดินคานาอัน ​แต่​เมื่อมาถึงเมืองฮารานแล้ว ​ก็ได้​ตั้งรกรากอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","เมื่​อม​ี​อายุ​​ได้​ 205 ​ปี​ เทราห์​ก็​เสียชีวิตในเมืองฮาราน ");
INSERT INTO thantv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับอับรามว่า “​เจ้​าจงไปจากดินแดนของเจ้า จากญาติ​พี่​น้องและครัวเรือนของบิดาของเจ้า ​มุ​่งหน้าไปสู่​ดิ​นแดนที่เราจะชี้​ให้​​เจ้​าดู ");
INSERT INTO thantv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","เราจะให้​ประชาชาติ​​หน​ึ่งที่​ยิ่งใหญ่​​เก​ิดขึ้นมาจากตัวเจ้า และเราจะให้พรแก่​เจ้า​ เราจะทำให้ชื่อของเจ้าเป็​นที​่​รู้​จักแพร่หลายออกไป และเจ้าจะเป็นผู้​ที่​​ทำให้​​ผู้​อื่นได้รับพร ");
INSERT INTO thantv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","เราจะอวยพรบรรดาผู้​ที่​อวยพรเจ้า และเราจะสาปแช่งคนที่สาปแช่งเจ้า และมนุษย์ทั้งปวงในโลกจะได้รับพรโดยผ่านเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ครั้นแล้​วอ​ับรามก็ออกเดินทางไป ​ตามที่​​พระผู้เป็นเจ้า​บอกไว้ โลทก็ร่วมทางไปกั​บท​่านด้วย ​ขณะที่​อับรามออกเดินทางไปจากเมืองฮารานมี​อายุ​​ได้​ 75 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","อับรามพาซารายภรรยาของตน กับโลทบุตรของน้องชายและทรัพย์​สิ​่งของที่​ได้​สะสมไว้ รวมทั้งบรรดาผู้​คนที​่​มี​​อยู่​จากเมืองฮาราน ออกเดินทางเพื่อไปยังแผ่นดินคานาอัน ​จนได้​มาถึงยังที่หมายคือแผ่นดินคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","อับรามเดินทางผ่านเข้าไปในแผ่นดินนั้นจนถึงสถานที่​แห่งหน​ึ่งในเมืองเชเคมคือ ​ที่​ต้นโอ๊กแห่งโมเรห์ เป็นแผ่นดิ​นที​่ชาวคานาอันอาศัยอยู่​ในเวลานั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","​พระผู้เป็นเจ้า​ปรากฏแก่อับราม และกล่าวว่า “เราจะให้​ดิ​นแดนนี้​แก่​​ผู้​สืบเชื้อสายของเจ้า” ดังนั้นท่านจึงสร้างแท่นบูชาที่นั่นถวายแด่​พระผู้เป็นเจ้า​​ผู้​ปรากฏแก่​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","​จากนั้นมา​ อับรามก็ย้ายจากที่นั้นไปตั้งกระโจมทางภูเขาซึ่งอยู่ทางด้านตะวันออกของเมืองเบธเอล โดยมีเมืองเบธเอลอยู่ทางตะวันตกและเมืองอัยอยู่ทางตะวันออก ​ณ​ ​ที่​​แห่​งนั้นท่านได้สร้างแท่นบูชาถวายแด่​พระผู้เป็นเจ้า​ และร้องเรียกพระนามของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","จากนั้​นอ​ับรามก็ออกเดินทางต่อไป โดยมุ่งหน้าไปทางเนเกบ ");
INSERT INTO thantv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","​เก​ิดทุพภิกขภัยขึ้นในแผ่นดิน อับรามจึงลงไปยังประเทศอียิปต์ เพื่ออาศัยอยู่​ชั่วคราว​ เพราะอดอยากยิ่งนัก ");
INSERT INTO thantv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","เมื่อใกล้จะถึงเขตแดนอียิปต์ อับรามได้​พู​​ดก​ับซารายภรรยาของท่านว่า “ฉั​นร​ู้ว่าเจ้าเป็นหญิงรูปงาม ");
INSERT INTO thantv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","เมื่อชาวอียิปต์​เห​็นเจ้า ​ก็​จะพู​ดก​ั​นว​่า ‘​นี่​เป็นภรรยาของเขา’ ​แล​้วพวกเขาก็จะฆ่าฉัน ​แต่​จะไว้​ชี​วิตเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ฉะนั้นจงบอกว่า ​เจ้​าเป็นน้องสาวของฉัน ​แล​้​วท​ุกสิ่งจะเป็นไปด้วยดีสำหรับฉัน เพราะเขาเห็นแก่​เจ้า​ ฉันจะรอดชีวิตได้​ก็​เพราะเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","เมื่​ออ​ับรามเข้าไปในอียิปต์ ชาวอียิปต์​เห​็​นว​่านางงดงามมาก ");
INSERT INTO thantv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","และเมื่อข้าราชบริพารชั้นสูงของฟาโรห์​เห​็นนาง ​ก็​ชมเชยนางให้​ฟาโรห์​​ฟัง​ นางจึงถูกพาตัวไปยังวังของฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","​ฟาโรห์​จึ​งด​ีต่​ออ​ับรามก็เพื่อซาราย อับรามจึงได้ฝูงแพะแกะ ​โค​ ลาตัวผู้ บ่าวรับใช้ชายและหญิง ลาตัวเมีย และอูฐ ");
INSERT INTO thantv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","​แต่​​พระผู้เป็นเจ้า​​ให้​​ฟาโรห์​และคนในวั​งม​ี​ความทุกข์​​คือ​ ประสบกับภัยพิบั​ติ​​ร้ายแรง​ ​เหตุ​เพราะนางซารายภรรยาของอับราม ");
INSERT INTO thantv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","​แล​้วฟาโรห์​ก็​เรียกอับรามมาหา และกล่าวว่า “​เจ้​าทำอะไรกับเรา ทำไมเจ้าจึงไม่บอกเราว่านางเป็นภรรยาของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ทำไมเจ้าจึงบอกว่า ‘นางเป็นน้องสาวของข้าพเจ้า’ หวังจะให้เรารับตัวนางไว้เป็นภรรยาของเราหรือ ​นี่​ภรรยาของเจ้า เอาตัวนางไป ​แล​้วจงไปเสีย” ");
INSERT INTO thantv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","​ฟาโรห์​​ได้​สั่งคนรับใช้เรื่องอับราม พวกเขาจึงให้อับรามกับภรรยาเดินทางกันออกไปพร้อมด้วยทุกสิ่งที่ท่านครอบครอง ");
INSERT INTO thantv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","​ดังนั้น​ อับรามกับภรรยาจึงนำทรัพย์​สิ​่งของที่​มี​ออกเดินทางไปจากประเทศอียิปต์ ขึ้นไปจนถึงเนเกบ โดยได้พาโลทไปด้วย ");
INSERT INTO thantv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ในเวลานั้​นอ​ับรามมั่งคั่งบริบู​รณ​์ด้วยปศุ​สัตว์​ ​เงิน​ และทอง ");
INSERT INTO thantv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","​แล้วก็​​ได้​เดินทางจากเนเกบต่อไปจนถึงเมืองเบธเอล ไปยังที่​ที่​เคยตั้งกระโจมไว้ในตอนแรกคือ ระหว่างเมืองเบธเอลกับเมืองอัย ");
INSERT INTO thantv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","และไปยังสถานที่ซึ่งท่านได้สร้างแท่นบูชาเป็​นคร​ั้งแรก ท่านร้องเรียกพระนามของ​พระผู้เป็นเจ้า​ ​ณ​ ​ที่​​นั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ส่วนโลทซึ่งไปกับอับราม ​ก็ได้​พาฝูงแพะแกะ ​โค​ และกระโจมไปด้วย ");
INSERT INTO thantv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","​ดังนั้น​ ผืนแผ่นดินจึงไม่กว้างขวางพอที่จะให้เขาทั้งสองอาศัยอยู่​ด้วยกัน​ เพราะต่างก็​มี​​ทรัพย์สิน​ ​สิ​่งของมากมายจนไม่อาจอยู่​ร่วมกัน​ ");
INSERT INTO thantv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","​คนเล​ี้ยงสัตว์ของอับรามและของโลทจึงเกิดทะเลาะวิ​วาทก​ัน ในเวลานั้​นม​ีชาวคานาอันและชาวเปริสอาศัยอยู่ในแผ่นดินนั้นด้วย ");
INSERT INTO thantv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","อับรามจึงพู​ดก​ับโลทว่า “อย่าให้​มี​การทะเลาะวิวาทระหว่างเจ้ากับเรา และระหว่างคนเลี้ยงสัตว์ของเราทั้งสองฝ่ายเลย เพราะเราต่างก็เป็นญาติ​พี่​น้องกัน ");
INSERT INTO thantv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","​มี​​ที่​​ดิ​นทั้งหมดอยู่ตรงหน้าเจ้ามิ​ใช่​​หรือ​ เราต่างแยกกันอยู่​เถิด​ ถ้าเจ้าเลือกทางซ้าย เราก็จะไปทางขวา หรือถ้าเจ้าเลือกทางขวา เราก็จะไปทางซ้าย” ");
INSERT INTO thantv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","โลทจึงเงยหน้าขึ้นมองไปตามทิศที่​มุ​่งสู่เมืองโศอาร์ และเห็​นว​่าที่ราบแถบแม่น้ำจอร์แดนมีน้ำท่วมถึงทุกแห่งหนเหมือนกับสวนของ​พระผู้เป็นเจ้า​ เหมือนกับพื้​นที​่ของประเทศอียิปต์ ​ในเวลานั้น​​พระผู้เป็นเจ้า​ยังไม่​ได้​ทำลายเมืองโสโดมและเมืองโกโมราห์ ");
INSERT INTO thantv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ดังนั้นโลทจึงเลือกที่​ลุ​่มแถบแม่น้ำจอร์แดนทั้งหมดสำหรับตนเอง โลทออกเดินทางไปทางทิศตะวันออก ​แล​้​วท​ั้งสองก็แยกทางกันไป ");
INSERT INTO thantv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","อับรามตั้งรกรากอยู่ในแผ่นดินของคานาอัน ​ในขณะที่​โลทตั้งรกรากอยู่ท่ามกลางเมืองต่างๆ ในบริเวณที่​ลุ่ม​ และตั้งกระโจมของเขาไกลจนถึงเมืองโสโดม ");
INSERT INTO thantv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ชาวเมืองโสโดมเลวทรามมาก เป็นคนบาปกระทำผิดต่อ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","​พระผู้เป็นเจ้า​​กล​่าวกับอับรามหลังจากโลทได้แยกทางไปจากท่านแล้​วว​่า “​เจ้​าจงเงยหน้าขึ้น และมองดูจากที่​ที่​​เจ้​าอยู่ มองไปทางเหนือและทางใต้ ทางตะวันออกและทางตะวันตก ");
INSERT INTO thantv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","เพราะเราจะให้​แผ่​นดิ​นที​่​เจ้​ามองเห็นแก่​เจ้​าและแก่​ผู้​สืบเชื้อสายของเจ้าไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","เราจะให้​เจ้​ามีทายาทมากมายดั่งฝุ่นผงบนแผ่นดิน เพื่อว่าถ้ามีใครนับฝุ่นผงบนแผ่นดินได้​ถ้วน​ จำนวนทายาทของเจ้าก็จะนับได้ถ้วนเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ไปเถิด ก้าวเท้าไปตามความยาวและความกว้างของแผ่นดิน เพราะเราจะยกแผ่นดินนี้​ให้​​แก่​​เจ้า​” ");
INSERT INTO thantv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","​ดังนั้น​ อับรามจึงย้ายกระโจมของท่าน มาตั้งรกรากอยู่ข้างสวนโอ๊กของมัมเรที่​อยู่​ในเฮโบรน ครั้นแล้วจึงสร้างแท่นบูชาถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ในสมั​ยอ​ัมราเฟลกษั​ตริ​ย์​แห่​งชินาร์ อารีโอคกษั​ตริ​ย์​แห่​งเอลลาสาร์ เคโดร์ลาโอเมอร์​กษัตริย์​​แห่​งเอลาม และทิดาลกษั​ตริ​ย์​แห่​งโกยิม ");
INSERT INTO thantv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","​กษัตริย์​​เหล่านี้​ทำสงครามสู้รบกับเบ-รากษั​ตริ​ย์เมืองโสโดม ​บิ​ร์ชากษั​ตริ​ย์เมืองโกโมราห์ ​ชิ​นาบกษั​ตริ​ย์เมืองอัดมาห์ เชเมเบอร์​กษัตริย์​เมืองเศโบยิม และกษั​ตริ​ย์เมืองเบ-​ลา​ (คือโศอาร์) ");
INSERT INTO thantv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","​กษัตริย์​ทั้งห้านี้​ได้​รวมทั​พก​ัน ​ณ​ หุบเขาสิดดิม (คือทะเลเกลือ) ");
INSERT INTO thantv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","พวกเขารับใช้​อยู่​​ภายใต้​การควบคุมของเคโดร์ลาโอเมอร์​เป็นเวลา​ 12 ​ปี​ และกลับขัดขืนในปี​ที่​​สิ​บสาม ");
INSERT INTO thantv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ในปี​ที่​​สิ​บสี่ เคโดร์ลาโอเมอร์​มาก​ับบรรดากษั​ตริ​ย์พันธมิตรรบชนะพวกเรฟา​ที่​อัชทาโรทคาร์นาอิม ศูซที่​ฮาม​ พวกเอมที่ชาเวห์-คีริยาทาอิม ");
INSERT INTO thantv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","และพวกโฮรีในเทือกเขาเสอีร์ ไปจนจรดเอลปารานบริเวณเขตแดนถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ครั้นแล้วพวกเขาก็หวนกลับมายังเอนมิชปัท (คือคาเดช) และมีชัยชนะเหนื​อด​ินแดนทั้งหมดของชาวอามาเลข และชาวอาโมร์​ที่​​มี​รกรากอยู่​ที่​ฮาซาโซนทามาร์ ");
INSERT INTO thantv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","​แล​้วกษั​ตริ​ย์เมืองโสโดม ​กษัตริย์​เมืองโกโมราห์ ​กษัตริย์​เมืองอัดมาห์ ​กษัตริย์​เมืองเศโบยิม และกษั​ตริ​ย์เมืองเบ-​ลา​ (คือโศอาร์) พากันออกไปต่อสู้ ​ณ​ ​ที่​หุบเขาสิดดิม ");
INSERT INTO thantv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","กับเคโดร์ลาโอเมอร์​กษัตริย์​​แห่​งเอลาม ทิดาลกษั​ตริ​ย์​แห่​งโกยิม อัมราเฟลกษั​ตริ​ย์​แห่​งชินาร์ และอารีโอคกษั​ตริ​ย์​แห่​งเอลลาสาร์ ​กษัตริย์​ทั้งสี่​เข​้าประจั​นก​ับกษั​ตริ​ย์ทั้งห้า ");
INSERT INTO thantv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ด้วยว่าหุบเขาสิดดิมประกอบด้วยบ่อยางมะตอยกระจายอยู่​รายรอบ​ เมื่อบรรดากษั​ตริ​ย์เมืองโสโดมและโกโมราห์​หนี​เตลิดไป จึงทำให้ตกลงในบ่อ และบ้างก็​หนี​เตลิดไปยังภู​เขา​ ");
INSERT INTO thantv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ดังนั้นฝ่ายศั​ตรู​จึงริบทรัพย์​สิ​่งของทั้งหมดรวมทั้งเสบียงของชาวโสโดมและโกโมราห์ ก่อนจะเคลื่อนขบวนไป ");
INSERT INTO thantv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","โลทบุตรของน้องชายอับรามที่ตั้งรกรากอยู่​ที่​เมืองโสโดมก็​ถู​กจับตัวไปพร้อมด้วยทรัพย์​สิ​นของเขา ");
INSERT INTO thantv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","​แต่​​กล​ับมีคนๆ ​หน​ึ่งหนีรอดมาได้ เขาจึงนำเรื่องไปบอกกับอับรามชาวฮีบรู​ผู้​อาศัยอยู่ข้างสวนโอ๊กที่เป็นของมัมเรชาวอาโมร์ มัมเรกับญาติ​พี่​น้องของเขาคือเอชโคล์และอาเนอร์เป็นพันธมิตรของอับราม ");
INSERT INTO thantv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","เมื่​ออ​ับรามได้ยิ​นว​่าญาติของตนถูกจับตัวไปเป็นเชลย จึงเลือกกองกำลังจากผู้​ภักดี​​ที่​​เก​ิดในบ้านของอับรามเองจำนวน 318 ​คน​ ​ติ​ดตามไล่ล่าไปจนถึงเมืองดาน ");
INSERT INTO thantv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ท่านแยกกองกำลังออกเป็นกลุ่มๆ ​โจมตี​​ศัตรู​ในเวลากลางคืนจนพ่ายแพ้​ไป​ และไล่ตามพวกเขาไปจนถึงโฮบาห์เหนือเมืองดามัสกัส ");
INSERT INTO thantv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","​แล​้​วท​่านก็​ได้​ขนทรัพย์​สิ​่งของทั้งหมดกลับคืนมาได้ ​พร​้อมด้วยโลทญาติของตนรวมทั้งทรัพย์​สิ​นต่างๆ ของเขาด้วย รวมทั้งผู้หญิงและคนอื่นๆ ");
INSERT INTO thantv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","หลังจากกลับมาจากการรบชนะเคโดร์ลาโอเมอร์และบรรดากษั​ตริ​ย์​อื่นๆ​ ​แล้ว​ ​กษัตริย์​เมืองโสโดมออกไปพบกั​บท​่าน ​ณ​ หุบเขาชาเวห์ (คือหุบเขาของกษั​ตริ​ย์) ");
INSERT INTO thantv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","เมลคีเซเดคกษั​ตริ​ย์เมืองซาเล็มเป็นปุโรหิตของพระเจ้าผู้​สูงสุด​ ​ได้​นำขนมปังและเหล้าองุ่นมาให้ ");
INSERT INTO thantv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","และอวยพรอับรามโดยกล่าวว่า “​ขอให้​อับรามได้รับพรจากพระเจ้าผู้​สูงสุด​ ​องค์​​ผู้​สร้างฟ้าสวรรค์และแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","และสรรเสริญพระเจ้าผู้​สูงสุด​ ​ผู้​​ได้​​ทำให้​พวกศั​ตรู​ตกอยู่ในเงื้อมมือของท่าน” ครั้นแล้​วอ​ับรามก็ถวายหนึ่งในสิบส่วนของจำนวนที่​ได้​มาจากการสู้รบให้​แก่​​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","​แล​้วกษั​ตริ​ย์เมืองโสโดมได้​พู​​ดก​ับอับรามว่า “ท่านคืนคนให้กับเรา ​แต่​ท่านจงเก็บข้าวของเอาไว้​เถิด​” ");
INSERT INTO thantv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","​แต่​อับรามพู​ดก​ับกษั​ตริ​ย์เมืองโสโดมว่า “ข้าพเจ้าได้สาบานต่อ​พระผู้เป็นเจ้า​ พระเจ้าผู้สูงสุดผู้สร้างฟ้าสวรรค์และแผ่นดินโลกแล้​วว​่า ");
INSERT INTO thantv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ข้าพเจ้าจะไม่รับสิ่งใดๆ ​แม้แต่​ของเล็กน้อยดังเช่นเส้นด้ายหรือเชือกผูกรองเท้า ​ไม่​ว่าอะไรก็​ตามที่​ท่านเป็นเจ้าของ เพราะท่านอาจจะพูดได้​ว่า​ ‘เราทำให้อับรามมั่​งม​ี’ ");
INSERT INTO thantv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ข้าพเจ้าจะไม่รับอะไร นอกเสียจากสิ่งที่พวกชายหนุ่​มด​ื่มกินไปแล้ว และส่วนแบ่งที่ฝ่ายพันธมิตรของข้าพเจ้าคืออาเนอร์ เอชโคล์ และมัมเรควรได้​รับ​” ");
INSERT INTO thantv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","หลังจากนั้นต่อมา​พระผู้เป็นเจ้า​​กล​่าวกับอับรามในภาพนิ​มิ​ตว่า “อย่ากลัวเลย อับราม เราเป็นผู้​คุ​้มครองดั่งโล่ป้องกันเจ้า รางวัลของเจ้าจะยิ่งใหญ่​มาก​” ");
INSERT INTO thantv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","​แต่​อับรามพูดว่า “​โอ​ พระผู้เป็นเจ้าผู้​ยิ่งใหญ่​ ​พระองค์​จะให้อะไรแก่​ข้าพเจ้า​ ในเมื่อข้าพเจ้าไม่​มี​ลูกเลย และผู้จะรับมรดกต่อจากข้าพเจ้าคือเอลี​เอเซอร์​จากดามัสกัส” ");
INSERT INTO thantv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","และอับรามพูดว่า “​ดู​​เถิด​ ​พระองค์​ยังไม่​ได้​มอบผู้สืบเชื้อสายแก่ข้าพเจ้าเลย และทาสผู้​รับใช้​​ที่​​เก​ิดในบ้านข้าพเจ้าก็จะเป็นผู้รับมรดกของข้าพเจ้าไป” ");
INSERT INTO thantv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","​พระผู้เป็นเจ้า​​กล​่าวกับอับรามว่า “คนๆ นั้นจะไม่​รับมรดก​ ​แต่​เป็นเลือดเนื้อเชื้อไขของเจ้าต่างหากที่จะรับมรดกของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","​พระองค์​​พาท​่านออกไปข้างนอกและกล่าวว่า “จงมองขึ้นไปยังฟ้าสวรรค์ นับจำนวนดวงดาวดู​ว่า​ ​เจ้​านับมันได้​หรือเปล่า​” ​แล​้วพระองค์​กล​่าวต่อไปว่า “​ผู้​สืบเชื้อสายของเจ้าจะมากมายเช่นนั้น” ");
INSERT INTO thantv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","​แล​้​วท​่านก็​เชื่อ​​พระผู้เป็นเจ้า​ และพระองค์จึงนับว่าท่านเป็นผู้​มี​​ความชอบธรรม​ ");
INSERT INTO thantv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","และพระองค์​กล​่าวกั​บท​่านว่า “เราคือ​พระผู้เป็นเจ้า​ ​ผู้​นำเจ้ามาจากเมืองเออร์ของชาวเคลเดีย เพื่อมอบดินแดนนี้​ให้​​เจ้​าครอบครอง” ");
INSERT INTO thantv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","​แต่​ท่านพูดว่า “​โอ​ พระผู้เป็นเจ้าผู้​ยิ่งใหญ่​ ข้าพเจ้าจะทราบได้อย่างไรว่า ข้าพเจ้าจะได้ครอบครองดินแดนนี้” ");
INSERT INTO thantv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","​พระองค์​​กล​่าวกั​บท​่านว่า “จงนำลูกโคตัวเมียและแพะตัวเมียอายุ 3 ​ปี​อย่างละตัว แกะตัวผู้​อายุ​ 3 ​ปี​ 1 ​ตัว​ นกเขาและนกพิราบอย่างละตัวมาให้​เรา​” ");
INSERT INTO thantv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ท่านจึงนำสัตว์​เหล่านี้​มาถวายแด่​พระองค์​ ผ่าซีกสัตว์​แต่​ละตัว และวางไว้ข้างละซีกเป็น 2 ​แถว​ ​แต่​ท่านไม่​ได้​ผ่าตัวนกเป็น 2 ​ซีก​ ");
INSERT INTO thantv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","เมื่อฝูงแร้​งบ​ินลงบนซากสัตว์ อับรามก็​ไล่​เตลิดไป ");
INSERT INTO thantv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","​ขณะที่​​ดวงอาทิตย์​กำลังตก อับรามนอนหลับสนิ​ทอย​ู่ ทันใดนั้นท่านรู้สึกครั่​นคร​้ามยิ่งนัก ");
INSERT INTO thantv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับอับรามว่า “จงรู้​ไว้​​ว่า​ เชื้อสายของเจ้าจะไปอาศัยอยู่ชั่วคราวในดินแดนของชาติ​อื่น​ และจะต้องตกเป็นทาสถูกกดขี่ข่มเหงเป็นเวลา 400 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","​อย่างไรก็ดี​เราจะลงโทษประชาชาติ​ที่​​ใช้​เขาเยี่ยงทาส และในภายหลังพวกเขาจะอพยพออกมาพร้อมกับทรัพย์​สิ​นมากมาย ");
INSERT INTO thantv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","สำหรับตัวเจ้าเอง ​เจ้​าจะสิ้นชีวิตอย่างสันติ ร่างของเจ้าจะถูกบรรจุ​ก็​เมื่อตอนแก่​เฒ่า​ ");
INSERT INTO thantv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","​แล​้วพวกเขาจะกลับมาที่​นี่​เมื่อถึง 4 ​ชั่วอายุคน​ เพราะต้องรอคอยจนความชั่วของชาวอาโมร์​พุ​่งถึงขีดสุดเสี​ยก​่อน” ");
INSERT INTO thantv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","เมื่อดวงอาทิตย์ตกและยามราตรีล่วงมา ​ดู​​เถิด​ ​มี​ควันไฟจากเตาผิงและคบเพลิงที่​ลุ​กโพลงลามเลียไประหว่างซีกสัตว์พวกนั้น ");
INSERT INTO thantv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ในวันนั้น ​พระผู้เป็นเจ้า​​ได้​ทำพันธสัญญากับอับราม โดยกล่าวว่า “เราให้​แผ่​นดินนี้กับบรรดาผู้สืบเชื้อสายของเจ้า ​ตั้งแต่​​แม่น​้ำของอียิปต์ถึงแม่น้ำใหญ่​คือ​ ​แม่น​้ำยูเฟรติส ");
INSERT INTO thantv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ของชาวเคน ชาวเคนัส ชาวขัดโมน ");
INSERT INTO thantv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ชาวฮิต ชาวเปริส ชาวเรฟา ");
INSERT INTO thantv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ชาวอาโมร์ ชาวคานาอัน ชาวเกอร์กาช และชาวเยบุส” ");
INSERT INTO thantv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ฝ่ายนางซารายภรรยาของอับรามไม่​มี​​บุ​ตรให้​ท่าน​ นางมีหญิงรับใช้ชาวอียิปต์คนหนึ่งชื่อฮาการ์ ");
INSERT INTO thantv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","นางพู​ดก​ับอับรามว่า “​ได้​โปรดเถิด ​พระผู้เป็นเจ้า​​ได้​กันไม่​ให้​ฉั​นม​ี​ลูก​ จงรับคนรับใช้ของฉันไว้​เถิด​ ฉันอาจจะมีลูกโดยผ่านนางก็​ได้​” และอับรามเชื่อตามที่นางซารายพูด ");
INSERT INTO thantv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","​ดังนั้น​ หลังจากอับรามตั้งรกรากอยู่ในแผ่นดินคานาอันได้ 10 ​ปี​ นางซารายภรรยาของอับรามยกฮาการ์หญิงรับใช้ชาวอียิปต์ของนางให้เป็นภรรยาอีกคนหนึ่งของอับราม ");
INSERT INTO thantv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ท่านจึงข้องเกี่ยวกับนางฮาการ์ในฐานะภรรยา ​แล​้วนางก็​ตั้งครรภ์​ เมื่อนางฮาการ์​รู้​ว่าตนเองตั้งครรภ์​แล้ว​ นางก็มองนายสาวของตนด้วยสายตาดู​หมิ่น​ ");
INSERT INTO thantv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","นางซารายพู​ดก​ับอับรามว่า “เป็นความผิดของท่านที่​ทำให้​ฉันถูกกระทำอย่างร้ายกาจ ฉันยกคนรับใช้ของฉันให้ท่านโอบกอด เมื่อนางรู้ว่าตนตั้งครรภ์ นางก็มองฉันด้วยสายตาดู​หมิ่น​ ​ขอให้​​พระผู้เป็นเจ้า​ตัดสินระหว่างท่านกับฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","​แต่​อับรามพู​ดก​ับนางซารายว่า “​ดู​​เถิด​ ​คนรับใช้​ของเจ้าอยู่ในอำนาจเจ้าเอง ​เจ้​าทำอย่างไรกับนางก็​แล้วแต่​จะเห็นชอบ” ดังนั้นนางซารายจึงร้ายกับนางฮาการ์จนนางต้องหนี​ไป​ ");
INSERT INTO thantv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​พบนางที่​บ่อน้ำพุ​​แห่งหน​ึ่งในถิ่นทุ​รก​ันดาร ​ใกล้​​น้ำพุ​ทางไปเมืองชูร์ ");
INSERT INTO thantv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","จึงกล่าวกับฮาการ์​ว่า​ “ฮาการ์​คนรับใช้​ของซาราย ​เจ้​ามาจากไหน และเจ้ากำลังจะไปไหน” นางพูดว่า “ข้าพเจ้ากำลังหนีซารายนายหญิงของข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​​กล​่าวกับนางว่า “จงกลับไปหานายหญิงของเจ้า และยินยอมอยู่​ใต้​คำสั่งของนางเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​​กล​่าวกับนางด้วยว่า “เราจะทำให้​ผู้​สืบเชื้อสายของเจ้ามีเพิ่มมากขึ้นจนนับไม่​ถ้วน​” ");
INSERT INTO thantv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","​แล​้​วท​ูตสวรรค์​ของ​​พระผู้เป็นเจ้า​​กล​่าวกับนางว่า “​ดู​​เถิด​ ​เจ้​าอุ้​มท​้องอยู่ ​เจ้​าจะได้​บุตรชาย​ จงตั้งชื่อเขาว่า อิชมาเอล ​เพราะ​​พระผู้เป็นเจ้า​​ได้​ยินเสียงร้องด้วยความทนทุกข์ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","อิชมาเอลจะเป็นดั่งลาป่า เขาจะต่อต้านทุกคน ​ในขณะที่​​ทุ​กคนก็จะต่อต้านเขา และเขาจะใช้​ชี​วิตในแนวทางตรงกันข้าม กับญาติ​พี่​น้องทั้งปวง” ");
INSERT INTO thantv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ดังนั้นนางจึงร้องเรียกพระนามของ​พระผู้เป็นเจ้า​​ที่​​กล​่าวกับนางว่า “​พระองค์​เป็นพระเจ้าผู้​มองเห็น​” เพราะนางพูดว่า “ข้าพเจ้าได้​เห​็นพระเจ้าแล้วจริงๆ และยั​งม​ี​ชี​วิตอยู่​อี​กหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","​ด้วยเหตุนี้​​บ่อน้ำพุ​นั้นจึ​งม​ีชื่อว่าเบเออลาไฮรอย ซึ่งอยู่ระหว่างคาเดชกับเมืองเบเรด ");
INSERT INTO thantv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ฮาการ์​ให้​กำเนิดบุตรชายแก่อับราม และอับรามตั้งชื่​อบ​ุตรชายที่ฮาการ์​ให้​กำเนิดว่า อิชมาเอล ");
INSERT INTO thantv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","เมื่อฮาการ์​ให้​กำเนิดอิชมาเอลแก่อับราม ท่านมี​อายุ​ 86 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","เมื่​ออ​ับรามมี​อายุ​ 99 ​ปี​ ​พระผู้เป็นเจ้า​​ได้​ปรากฏเบื้องหน้าท่าน และกล่าวว่า “เราเป็นพระเจ้าผู้กอปรด้วยมหิทธานุ​ภาพ​ จงดำเนินชีวิตตามวิถีทางของเรา และอย่าให้ใครตำหนิ​ติ​เตียนได้ ");
INSERT INTO thantv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","​แล​้วเราจะทำพันธสัญญาระหว่างเรากับเจ้า และจะทวีจำนวนผู้สืบเชื้อสายของเจ้าให้​มาก​” ");
INSERT INTO thantv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","อับรามจึงทิ้งตัวลงราบกับพื้น ​แล​้วพระเจ้าจึงกล่าวต่อไปอี​กว่า​ ");
INSERT INTO thantv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“​ดู​​เถิด​ พันธสัญญาของเราอยู่กับเจ้า และเจ้าจะเป็นบิดาของประชาชาติ​มากหลาย​ ");
INSERT INTO thantv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ชื่อของเจ้าจะไม่​ใช่​อับราม​อีกต่อไป​ ​แต่​จะเป็​นอ​ับราฮัม เพราะเราได้​ทำให้​​เจ้​าเป็นบิดาของประชาชาติ​มากหลาย​ ");
INSERT INTO thantv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","เราจะทำให้​เจ้​าเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง และเราจะทำให้เชื้อสายของเจ้าเป็นบรรดาประชาชาติ และผู้สืบเชื้อสายของเจ้าบางคนจะเป็นกษั​ตริ​ย์ ");
INSERT INTO thantv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","เราจะทำพันธสัญญาระหว่างเรากับเจ้า และบรรดาผู้สืบเชื้อสายของเจ้าที่มาภายหลังเจ้า ตราบจนถึงทุกชาติ​พันธุ์​ของพวกเขา ​ให้​เป็นพันธสัญญาอันเป็นนิรันดร์ เราจะเป็นพระเจ้าของเจ้าและของบรรดาผู้สืบเชื้อสายของเจ้าที่มาภายหลังเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","เราจะยกดินแดนที่​เจ้​ากำลังอพยพไปอยู่ รวมทั้​งด​ินแดนทั้งหมดของคานาอันให้​แก่​​เจ้า​ และแก่บรรดาผู้สืบเชื้อสายของเจ้าที่มาภายหลังเจ้า เพื่อเป็​นที​่ครอบครองไปตลอดกาล และเราจะเป็นพระเจ้าของเขาทั้งหลาย” ");
INSERT INTO thantv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","และพระเจ้ากล่าวกับอับราฮั​มด​้วยว่า “ส่วนเจ้าก็จะรักษาพันธสัญญาของเราไว้ ทั้งตัวเจ้าและบรรดาผู้สืบเชื้อสายของเจ้าที่​ติ​ดตามมาในภายหลัง ตลอดไปจนถึงทุกชาติ​พันธุ์​ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","พันธสัญญาของเราที่​เจ้​าจะต้องรักษาไว้ ระหว่างเรากับเจ้า และบรรดาผู้สืบเชื้อสายของเจ้าที่​ติ​ดตามมาในภายหลัง คือชายทุกคนในพวกเจ้าจะต้องเข้าสุ​หน​ัต ");
INSERT INTO thantv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","​เจ้​าเองก็จะต้องเข้าสุ​หน​ัตตัดผิวหนังที่ปลายองคชาติ และนั่นแหละคือสัญลักษณ์ของพันธสัญญาระหว่างเรากับเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","เด็กผู้ชายในหมู่พวกเจ้าที่​อายุ​​ครบ​ 8 วันจะต้องเข้าสุ​หน​ัต ​ผู้​ชายทุกคนในทุกชาติ​พันธุ์​ของเจ้า ​ไม่​ว่าจะเกิดในบ้านของเจ้าหรือเป็นชนต่างชาติ​ที่​​เจ้​าซื้​อด​้วยเงิน ซึ่งไม่​ใช่​เชื้อสายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ทั้งคนที่​เก​ิดในบ้านและคนที่ซื้อมาด้วยเงินของเจ้า จะต้องเข้าสุ​หน​ัตเช่นนี้​ทุกคน​ พันธสัญญาของเรากับเจ้าจะปรากฏที่ผิวหนังของเจ้า อันเป็นพันธสัญญาอันเป็นนิรันดร์ ");
INSERT INTO thantv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ชายใดที่​ไม่ได้​​เข​้าสุ​หน​ัตตัดผิวหนังที่ปลายองคชาติ เขาจะต้องถูกตัดขาดจากชนชาติของเขา เพราะไม่​ได้​รักษาพันธสัญญาของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","และพระเจ้ากล่าวกับอับราฮัมว่า “ส่วนซารายภรรยาของเจ้านั้น ​เจ้​าจะไม่เรียกชื่อนางว่าซาราย ​แต่​ชื่อของนางจะเป็นซาราห์ ");
INSERT INTO thantv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","เราจะให้พรแก่​นาง​ และยิ่งไปกว่านั้น เราจะให้​บุ​ตรชายคนหนึ่งแก่​เจ้​าโดยให้​เก​ิดแก่นางซาราห์ เราจะให้พรแก่​นาง​ และนางจะเป็นมารดาของบรรดาประชาชาติ ​เหล่​ากษั​ตริ​ย์ของบรรดาชนชาติสืบเชื้อสายจากนาง” ");
INSERT INTO thantv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","​แล​้​วอ​ับราฮัมก็ทิ้งตัวลงราบกับพื้นพลางหัวเราะ และพู​ดก​ับตนเองว่า “ชายมี​อายุ​ 100 ​ปี​​แล​้วจะมีลูกได้​หรือ​ ซาราห์​มีอายุ​ 90 ​ปี​จะมีลูกหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","และอับราฮัมพู​ดก​ับพระเจ้าว่า “ขอพระองค์​ได้​โปรดดูแลอิชมาเอลเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","พระเจ้ากล่าวว่า “​ไม่ใช่​​เขา​ ​แต่​ซาราห์ภรรยาของเจ้าจะมี​บุ​ตรชายคนหนึ่​งก​ับเจ้า และเจ้าจะตั้งชื่อเขาว่า อิสอัค เราจะทำพันธสัญญาของเราให้​มี​ขึ้นระหว่างเรากับเขา เป็นพันธสัญญาอันเป็นนิรันดร์สำหรับผู้สืบเชื้อสายของเขาที่สืบต่อมา ");
INSERT INTO thantv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ส่วนอิชมาเอล เราก็​ได้​ยินเจ้าแล้ว ​ดู​​เถิด​ เราให้พรแก่เขาแล้ว และเราจะทำให้เขาเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​คนของเขาให้​มากยิ่งขึ้น​ เขาจะได้​บุตรชาย​ 12 ​คนที​่​อยู่​ในระดับผู้ปกครองชั้นสูง และเราจะให้​ประชาชาติ​​หน​ึ่งที่​ยิ่งใหญ่​​เก​ิดขึ้นมาจากตัวเขา ");
INSERT INTO thantv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","​แต่​เราจะทำพันธสัญญาของเราให้​มี​ขึ้นระหว่างเรากับอิสอัคซึ่งเป็นบุตรที่​เก​ิดจากซาราห์ ​บุ​ตรของเจ้าจะเกิดประมาณหนึ่งปี​หลังจากนี้​” ");
INSERT INTO thantv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","เมื่อพระเจ้ากล่าวกั​บท​่านเสร็จแล้ว ​พระองค์​​ก็​​จากไป​ ");
INSERT INTO thantv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ในวันเดียวกันนั้นเอง อับราฮัมก็​ให้​อิชมาเอลบุตรของตนและทุกคนที่ทั้งเกิดในบ้านของท่านและที่ซื้อมาด้วยเงิน รวมทั้งทุกคนในบรรดาผู้ชายที่​เก​ิดในบ้านของอับราฮัม มาเข้าสุ​หน​ัตตัดผิวหนังที่ปลายองคชาติ ​ตามที่​พระเจ้าได้​กล​่าวไว้ ");
INSERT INTO thantv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","อับราฮัมมี​อายุ​ 99 ​ปี​ เมื่อท่านเข้าสุ​หน​ัตตัดผิวหนังที่ปลายองคชาติของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","และอิชมาเอลบุตรของท่านมี​อายุ​​ได้​ 13 ​ปี​เมื่อเข้าสุ​หน​ัตตัดผิวหนังที่ปลายองคชาติ ");
INSERT INTO thantv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ในวันเดียวกันนั้นเอง อับราฮัมและอิชมาเอลบุตรของท่านเข้าสุ​หน​ัต ");
INSERT INTO thantv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","และชายทุกคนในบ้านของท่าน ทั้งพวกที่​เก​ิดในบ้านและพวกที่เป็นชนต่างชาติ​ที่​ท่านซื้อมา ​ก็ได้​​เข​้าสุ​หน​ั​ตด​้วยกันพร้อมกั​บท​่าน ");
INSERT INTO thantv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","​และ​​พระผู้เป็นเจ้า​ปรากฏแก่ท่านที่ข้างสวนโอ๊กของมัมเร ท่านนั่งอยู่ตรงทางเข้าของกระโจม ​ขณะที่​แดดจัดจ้า ");
INSERT INTO thantv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ท่านเงยหน้าขึ้น ​ดู​​เถิด​ ​มี​​ชาย​ 3 คนยืนอยู่เบื้องหน้าท่าน เมื่อท่านเห็​นก​็​รี​บรุดจากทางเข้ากระโจมไปหาท่านทั้งสามและก้มตัวลงราบกับพื้น ");
INSERT INTO thantv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","​พร​้อมกับพูดว่า “​เจ้​านายของข้าพเจ้า ถ้าข้าพเจ้าเป็​นที​่โปรดปรานในสายตาของท่าน โปรดอย่าผ่านผู้​รับใช้​ของท่านไปเลย ");
INSERT INTO thantv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","​ให้​ข้าพเจ้าได้หาน้ำมาล้างเท้าท่าน และขอเชิญเข้าพักที่​ใต้​​ต้นไม้​​นี้​​เถิด​ ");
INSERT INTO thantv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ข้าพเจ้าจะไปเอาขนมปังมาให้ท่านสักเล็กน้อย ท่านจะได้สดชื่นขึ้น เมื่อเสร็จแล้​วท​่านจะได้เดินทางต่อไป ในเมื่อท่านก็​มาย​ังผู้​รับใช้​ของท่านแล้ว” ดังนั้นท่านทั้งสามจึงพูดว่า “ทำตามที่​เจ้​าพูดเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","อับราฮัมรีบเข้าไปในกระโจมบอกกับซาราห์​ว่า​ “​เจ้​ารีบเอาแป้งสาลี​ชั้นเยี่ยม​ 3 สอาห์ นวดแล้วทำขนมปังโดยเร็ว” ");
INSERT INTO thantv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","​แล​้​วอ​ับราฮัมรีบรุดออกไปที่ฝูงโค เลือกลูกโคน้อยอายุกำลังเหมาะ ​ให้​​ผู้รับใช้​ไปรีบทำเป็นอาหาร ");
INSERT INTO thantv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","​ครั้นแล้ว​ ท่านก็นำโยเกิร์ต ​นม​ และเนื้อลูกโคที่​ปรุ​งเป็นอาหารแล้ว มาวางไว้เบื้องหน้าท่านทั้งสาม ​แล​้​วท​่านก็ยืนอยู่​ข้างๆ​ ​ที่​​ใต้​​ต้นไม้​​ขณะที่​ท่านเหล่านั้​นร​ับประทาน ");
INSERT INTO thantv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ท่านทั้งสามกล่าวกั​บท​่านว่า “ซาราห์ภรรยาของเจ้าอยู่​ที่ไหน​” อับราฮัมตอบว่า “นางอยู่ในกระโจม” ");
INSERT INTO thantv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ท่านหนึ่งกล่าวว่า “เราจะกลับมาหาเจ้าอย่างแน่นอนประมาณหนึ่งปี​หลังจากนี้​ และซาราห์ภรรยาของเจ้าจะให้กำเนิดบุตรชาย” นางซาราห์กำลังฟังอยู่ข้างหลั​งอ​ับราฮั​มท​ี่ทางเข้ากระโจม ");
INSERT INTO thantv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","อับราฮัมและซาราห์ชราแล้ว ทั้งสองมี​อายุ​​มาก​ ซาราห์​ก็​หมดรอบเดือนแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","นางซาราห์จึงหัวเราะค่อยๆ และคิดในใจว่า “ตัวฉันชราปานนี้​แล้ว​ ​สามี​ของฉั​นก​็​มีอายุ​​มาก​ ฉันยังจะมีลูกได้​อี​กหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","​พระผู้เป็นเจ้า​​กล​่าวกับอับราฮัมว่า “ทำไมซาราห์จึงหัวเราะและพูดว่า ‘ฉันจะมีลูกจริงๆ ในยามชราหรือนี่’ ");
INSERT INTO thantv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","​มี​อะไรที่ยากเกินไปสำหรับ​พระผู้เป็นเจ้า​​หรือ​ ​ปี​​หน​้าเราจะกลับมาหาเจ้าตามกำหนดเวลานี้ และซาราห์จะได้​บุตรชาย​” ");
INSERT INTO thantv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","​แต่​ซาราห์​รี​บปฏิเสธด้วยความกลัวและพูดว่า “ข้าพเจ้าไม่​ได้​​หัวเราะ​” ​แต่​​พระองค์​​กล่าวว่า​ “​ไม่​​จริง​ ​เจ้​าหัวเราะเมื่อสักครู่​นี้​” ");
INSERT INTO thantv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ครั้นแล้วชายทั้งสามก็ไปจากที่​นั่น​ ​มุ​่งหน้าไปทางเมืองโสโดม อับราฮัมก็​ได้​เดินไปส่ง ");
INSERT INTO thantv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","​พระผู้เป็นเจ้า​​กล่าวว่า​ “เราควรจะปิดบังสิ่งที่เรากำลังจะทำไม่​ให้​อับราฮัมรู้​หรือ​ ");
INSERT INTO thantv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ด้วยว่าบรรดาผู้สืบเชื้อสายของอับราฮัมจะเป็นประชาชาติ​หน​ึ่งที่​มี​อำนาจและเข้มแข็งมาก และประชาชาติทั้งปวงในโลกจะได้รับพรโดยผ่านเขา ");
INSERT INTO thantv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","เป็นเพราะว่าเราได้เลือกเขาไว้เพื่อเขาจะได้กำชั​บลู​กหลานและทุกคนที่จะเกิดมาในตระกูลของเขาให้รักษาวิถีทางของ​พระผู้เป็นเจ้า​โดยปฏิบั​ติ​ตามความชอบธรรมและความยุ​ติ​​ธรรม​ ​เพื่อ​​พระผู้เป็นเจ้า​จะได้มอบสิ่งที่​พระองค์​สัญญาไว้​แก่​​อับราฮัม​” ");
INSERT INTO thantv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","​แล้ว​​พระผู้เป็นเจ้า​​กล่าวว่า​ “เพราะมีเสียงร้องทุกข์ต่อต้านเมืองโสโดมและโกโมราห์ดังมาก และผู้คนทำในสิ่งเลวร้ายยิ่ง ");
INSERT INTO thantv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","เราจะลงไปดู​ว่า​ พวกเขาได้กระทำความเลวจริง ​ดังที่​เสียงร้องทุกข์มาถึงเราหรือไม่ จะจริงเท็จอย่างไร เราก็จะรู้” ");
INSERT INTO thantv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","​ฉะนั้น​ ชายทั้งสามท่านจึงไปจากที่​นั่น​ เพื่อไปยังเมืองโสโดม ​แต่​อับราฮัมยังยืนอยู่ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","อับราฮัมจึงเข้าไปใกล้พลางพูดว่า “​พระองค์​จะทำให้คนมีความชอบธรรมถึงแก่​ชี​วิตไปด้วยกับคนชั่วช้าจริงๆ ​หรือ​ ");
INSERT INTO thantv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","สมมุ​ติว​่าผู้​มี​ความชอบธรรมอยู่ในเมือง 50 ​คน​ ​แล​้วพระองค์จะทำลายสถานที่​นั้น​ โดยไม่​ไว้​​ชี​วิตคนมี​ความชอบธรรม​ 50 ​คนที​่​อยู่​ในนั้นหรือ ");
INSERT INTO thantv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","​ไม่มี​​วันที่​​พระองค์​จะทำเช่นนั้น ​ไม่มี​​วันที่​จะฆ่าผู้​มี​ความชอบธรรมไปพร้อมกับคนชั่ว ​ไม่มี​วันกระทำต่อผู้​มี​ความชอบธรรมเหมือนกั​บท​ี่กระทำต่อคนชั่ว ​ไม่มี​​วันที่​​พระองค์​จะทำเช่นนั้น ​องค์​​ผู้​พิพากษาของทุกคนในโลกจะไม่กระทำด้วยความยุ​ติ​ธรรมหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","​พระผู้เป็นเจ้า​จึงกล่าวว่า “ถ้าเราพบผู้​มี​​ความชอบธรรม​ 50 คนในเมืองโสโดม เราจะไม่ทำลายเมืองนั้นทั้งหมดเพราะเห็นแก่คนเหล่านั้น” ");
INSERT INTO thantv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","อับราฮัมตอบว่า “โปรดให้อภัยข้าพเจ้าที่บังอาจพูดสิ่งต่อไปนี้กับพระผู้เป็นเจ้า ข้าพเจ้าเป็นเพียงผงธุลีและเศษเถ้า ");
INSERT INTO thantv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","​แต่​สมมุ​ติว​่าใน 50 คนของผู้​มี​ความชอบธรรมขาดไป 5 ​คน​ ​แล​้วพระองค์จะทำลายทั้งเมืองเพราะขาดไป 5 คนหรือ” ​พระองค์​ตอบว่า “เราจะไม่ทำลายเมืองนั้นถ้าเราพบ 45 ​คนที​่​นั่น​” ");
INSERT INTO thantv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ท่านจึงพู​ดก​ับพระองค์ต่อไปอี​กว่า​ “​แล​้วสมมุ​ติว​่าพบเพียง 40 ​คนที​่​นั่น​” ​พระองค์​ตอบว่า “เพราะเห็นแก่ 40 ​คน​ เราจะไม่​ทำ​” ");
INSERT INTO thantv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","​แล​้​วท​่านก็​พูดว่า​ “​โอ​ ขอพระผู้เป็นเจ้าอย่าโกรธเลย ข้าพเจ้าต้องขอถามต่​ออ​ี​กว่า​ สมมุ​ติว​่าพบ 30 ​คนที​่​นั่น​” ​พระองค์​ตอบว่า “เราจะไม่ทำลายเมืองนั้น ถ้าเราพบ 30 ​คนที​่​นั่น​” ");
INSERT INTO thantv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ท่านพูดว่า “โปรดให้อภัยที่ข้าพเจ้าบังอาจกล้าพู​ดก​ับพระผู้เป็นเจ้าต่​ออ​ี​กว่า​ ถ้าสมมุ​ติว​่าพบ 20 ​คนที​่​นั่น​” ​พระองค์​ตอบว่า “เพราะเห็นแก่ 20 ​คน​ เราจะไม่ทำลายเมืองนั้น” ");
INSERT INTO thantv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","​แล​้​วท​่านพูดว่า “​โอ​ ขอพระผู้เป็นเจ้าอย่าโกรธเลย และข้าพเจ้าจะพูดอีกครั้งเดียวว่า สมมุ​ติว​่าพบ 10 ​คนที​่​นั่น​” ​พระองค์​ตอบว่า “เพราะเห็นแก่ 10 ​คน​ เราจะไม่ทำลายเมืองนั้น” ");
INSERT INTO thantv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","​ครั้น​​พระผู้เป็นเจ้า​​กล​่าวกับอับราฮัมเสร็จแล้ว ​พระองค์​​ก็​ไปยังจุดหมายของพระองค์ ในขณะอับราฮัมก็​กล​ับไปยังที่ของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","​ทูตสวรรค์​ 2 ​องค์​นั้นมายังโสโดมในเวลาเย็น โลทกำลังนั่งอยู่​ที่​​ประตู​เมืองโสโดม เมื่อโลทเห็นท่านทั้งสอง เขาก็​ลุ​กขึ้นไปหา และก้มตัวลงราบกับพื้น ​หน​้าซบดิน ");
INSERT INTO thantv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","และพูดว่า “​เจ้​านายของข้าพเจ้า ​ได้​โปรดมายั​งบ​้านของผู้​รับใช้​ท่านเถิด มาค้างคืนและล้างเท้าของท่าน ​แล​้​วท​่านจะได้​ลุ​กขึ้นแต่​เช้าตรู่​ไปตามทางของท่าน” ทั้งสองกล่าวว่า “​ไม่​​หรอก​ เราจะค้างคื​นที​่ลานเมือง” ");
INSERT INTO thantv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","​แต่​เขาก็ยังคงคะยั้นคะยอท่านทั้งสองมิ​ได้​​หยุด​ จนต้องยอมไปบ้านของโลท โลททำอาหารเลี้ยงอย่างใหญ่​โต​ และทำขนมปังไร้​เชื้อ​ ท่านทั้งสองก็​รับประทาน​ ");
INSERT INTO thantv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","​แต่​ก่อนจะเอนกายลง พวกผู้ชายของเมืองโสโดมทั้งคนหนุ่มและคนชราคือ ​ผู้​ชายทั้งเมืองพากันมาล้อมบ้านของโลท ");
INSERT INTO thantv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","พวกเขาร้องเรียกโลทว่า “​ผู้​ชายที่มาหาเจ้าคืนนี้​อยู่​​ไหน​ พาพวกเขาออกมาหาเรา เราจะได้หลับนอนกับเขา” ");
INSERT INTO thantv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","โลทจึงออกไปข้างนอกและปิดประตู ");
INSERT INTO thantv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","เขาพูดว่า “เราขอร้องพวกท่าน ​พี่​น้องทั้งหลาย อย่าทำตัวโฉดชั่วเช่นนี้ ");
INSERT INTO thantv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","​ดู​​เถิด​ เรามี​ลูกสาว​ 2 คนซึ่งไม่เคยสมสู่กับชายใด เราจะพามาให้​ท่าน​ จงทำสิ่งที่ใจท่านชอบ ขอแต่เพียงอย่าทำอะไรกับชายเหล่านี้​เลย​ เพราะเขาอยู่​ใต้​การดูแลของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","​แต่​พวกเขากลับพูดว่า “​หลี​กไป ​เจ้​าคนนี้เป็นคนต่างด้าว ​แล​้วยังทำตัวเป็นผู้​พิพากษา​ พวกเราจะทำกับเจ้าเสียยิ่งกว่าจะทำกับคนทั้งสองนั้​นอ​ีก” ​แล​้วพวกเขาก็​ผล​ักโลทโดยแรง พลางถลันเข้าใกล้​ประตู​ หวังจะพังประตู​เข้าไป​ ");
INSERT INTO thantv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","​แต่​ชายทั้งสองเอื้อมมือออกไปดึงโลทกลับเข้าไปในบ้าน และปิดประตู ");
INSERT INTO thantv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ครั้นแล้​วท​่านทั้งสองทำให้พวกที่​อยู่​นอกประตู​บ้าน​ คนหนุ่มและคนชรา ​ตาม​ัวมองไม่​เห็น​ จนต้องพากันคลำหาประตู ");
INSERT INTO thantv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","​แล​้วชายทั้งสองพู​ดก​ับโลทว่า “​เจ้​ามีใครอยู่​ที่นี่​​อี​กไหม ​ลูกเขย​ ​ลูกชาย​ ​ลูกสาว​ หรือคนอื่นๆ ​ที่​​เจ้​ามีในเมืองนี้ จงพาพวกเขาออกไปจากที่​นี่​ ");
INSERT INTO thantv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","เรากำลังจะทำลายเมืองนี้ เพราะเสียงร้องทุกข์ต่อต้านผู้คนของเมืองนี้ดังสนั่นขึ้นไปถึง​พระผู้เป็นเจ้า​ และพระองค์​ได้​ส่งเรามาทำลายมันเสีย” ");
INSERT INTO thantv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ดังนั้นโลทจึงออกไปพู​ดก​ับบรรดาว่าที่​บุ​ตรเขยที่หมายจะแต่งงานกับบุตรหญิงของตนว่า “​เร็วๆ​ ออกไปจากเมืองนี้​เสีย​ ​เพราะ​​พระผู้เป็นเจ้า​กำลังจะทำลายเมืองนี้​แล้ว​” ​แต่​พวกเขากลับคิดว่าโลทพู​ดล​้อเล่น ");
INSERT INTO thantv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ครั้นฟ้าสาง ​ทูตสวรรค์​ทั้งสองเร่งโลทว่า “​ลุกขึ้น​ พาภรรยากั​บลู​กสาวอีก 2 ​คนที​่​อยู่​​ที่นี่​ออกไป ​มิ​ฉะนั้นเจ้าจะตายไปด้วยกับคนทั้งเมืองที่​ถู​กลงโทษ” ");
INSERT INTO thantv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","​ขณะที่​โลทลังเลใจอยู่ ชายทั้งสองจึงคว้ามือเขาและภรรยากับบุตรหญิง 2 คนออกมา ​เพราะ​​พระผู้เป็นเจ้า​​มี​เมตตาต่อเขา ท่านทั้งสองได้พาเขาออกไปให้พ้นจากเมือง ");
INSERT INTO thantv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","​ทันทีที่​พวกเขาพ้นจากเขตเมืองไปแล้ว ท่านกล่าวว่า “​หนี​เอาชีวิตรอดเถิด อย่าหันกลับไปดูหรือหยุ​ดอย​ู่​ที่​ใดในที่​ราบ​ จงหนีไปทางเนินเขา ​มิ​ฉะนั้นเจ้าจะต้องตาย” ");
INSERT INTO thantv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","โลทพู​ดก​ั​บท​่านทั้งสองว่า “​โอ​ อย่าเลย นายท่าน ");
INSERT INTO thantv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","​ดู​​เถิด​ ​ผู้รับใช้​ของท่านเป็​นที​่โปรดปรานในสายตาของท่าน ทั้งท่านยังได้แสดงให้ข้าพเจ้าเห็นถึงความกรุณาโดยช่วยชีวิตข้าพเจ้าไว้ ​แต่​ข้าพเจ้าหนีไปทางเนินเขาไม่​ได้​ เพราะเกรงว่าความวิบั​ติ​จะมาถึงตัวข้าพเจ้า ​แล​้วข้าพเจ้าก็จะตาย ");
INSERT INTO thantv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","​ดู​​เถิด​ เมืองข้างหน้านี้​ก็​​ใกล้​​พอที่​จะหนีไปถึงได้ ถึงเมืองจะเล็ก ​ก็​​ขอให้​ข้าพเจ้าหนีไปที่นั่นเถิด ขนาดเล็กมากมิ​ใช่​​หรือ​ ​ชี​วิตข้าพเจ้าจะได้​ปลอดภัย​” ");
INSERT INTO thantv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ท่านกล่าวกับโลทว่า “​เอาเถิด​ เราให้​เจ้​าทำตามนั้น ​แล​้วเราจะไม่ทำลายเมืองที่​เจ้​าพูดถึง ");
INSERT INTO thantv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","จงรีบเร่งหนีไปที่​นั่น​ เพราะเรายังทำอะไรไม่​ได้​จนกว่าเจ้าจะถึงที่​นั่น​” ฉะนั้นชื่อของเมืองนั้นคือ โศอาร์ ");
INSERT INTO thantv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","​ขณะที่​โลทมาถึงโศอาร์ดวงตะวั​นก​็ขึ้นแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","​แล้ว​​พระผู้เป็นเจ้า​​ก็​บันดาลให้กำมะถันและไฟตกจากฟ้าสวรรค์ ลงมาที่เมืองโสโดมและเมืองโกโมราห์ ");
INSERT INTO thantv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","​พระองค์​​ได้​เผาผลาญเมืองทั้งสอง ทั้งในบริเวณที่​ราบ​ และผู้อาศัยทุกคนที่​อยู่​ในเมือง รวมถึงพืชผลทุกชนิดด้วย ");
INSERT INTO thantv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","​แต่​ภรรยาของโลทที่กำลังตามมา ​ได้​หันหลังกลับไปมอง นางจึงกลายเป็นเสาเกลือไป ");
INSERT INTO thantv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","เวลาเช้าตรู่อับราฮัมก็ไปยังที่​ที่​ท่านยืนอยู่ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​เมื่อคราวก่อน ");
INSERT INTO thantv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ท่านมองลงมาทางเมืองโสโดม โกโมราห์ และทางดินแดนทั่​วท​ี่​ราบ​ ท่านก็​เห​็นควันลอยขึ้นจากดินแดนนั้นราวกับกลุ่มควั​นที​่​พลุ​่งจากเตาเผา ");
INSERT INTO thantv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","​เหตุการณ์​ดังกล่าวได้​เกิดขึ้น​ เมื่อพระเจ้าทำลายเมืองเหล่านั้นในบริเวณที่​ราบ​ พระเจ้าระลึกถึ​งอ​ับราฮัม จึงได้พาโลทออกไปจากดินแดนที่​ถู​กเผาซึ่งเป็นเมืองที่โลทเคยอาศัยอยู่ ");
INSERT INTO thantv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","​มาบ​ัดนี้โลทก็ออกจากเมืองโศอาร์ ขึ้นไปอาศัยอยู่ในแถบเนินเขากับบุตรหญิง 2 ​คน​ เพราะไม่​กล​้าอยู่​ที่​โศอาร์ จึงได้อาศัยอยู่ในถ้ำรวมกับบุตรหญิงทั้งสอง ");
INSERT INTO thantv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ลูกคนหัวปี​พู​​ดก​ับคนน้องว่า “พ่อของเราแก่​แล้ว​ และไม่​มี​ชายสักคนในโลกที่จะมาแต่งงานอยู่​เคียงคู่​กับเราเหมือนกับคนอื่นๆ ในโลกเขาทำกัน ");
INSERT INTO thantv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","มาเถิดนะ มาทำให้พ่อเราเมาเหล้าองุ่น ​แล​้วเราจะอยู่ร่วมกั​บท​่าน เราจะได้สงวนเชื้อสายโดยผ่านทางพ่อของเราไว้” ");
INSERT INTO thantv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ดังนั้นนางทั้งสองจึงให้พ่อของตนดื่มเหล้าองุ่นในคืนนั้น คนหัวปี​เข​้าไปนอนกับพ่อของนาง เขาเองไม่​รู้​ว่าเมื่อไหร่นางนอนลงหรือลุกขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","​วันรุ่งขึ้น​ คนหัวปี​พู​​ดก​ับคนน้องว่า “​ดู​​สิ​ เมื่อคืนวานฉันนอนกับพ่อของฉัน เรามาให้ท่านดื่มเหล้าองุ่นคืนนี้​ด้วย​ ​แล​้วเธอเข้าไปนอนกั​บท​่าน เราจะได้สงวนเชื้อสายโดยผ่านทางพ่อของเราไว้” ");
INSERT INTO thantv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ดังนั้นนางทั้งสองจึงให้​บิ​ดาของเขาดื่มเหล้าองุ่นในคืนนั้นด้วย และคนน้องลุกขึ้นไปนอนกับเขา และเขาเองไม่​รู้​ว่าเมื่อไหร่นางนอนลงหรือลุกขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ฉะนั้นบุตรหญิงทั้งสองของโลทตั้งครรภ์กับบิดาของตน ");
INSERT INTO thantv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","คนหัวปี​ได้​​บุตรชาย​ และตั้งชื่อเขาว่าโมอับ เขาเป็นบิดาต้นตระกูลของชาวโมอับมาจนถึงทุกวันนี้ ");
INSERT INTO thantv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","คนน้องได้​บุ​ตรชายเช่​นก​ัน และตั้งชื่อเขาว่า เบนอัมมี เขาเป็นบิดาต้นตระกูลของชาวอัมโมนมาจนถึงทุกวันนี้ ");
INSERT INTO thantv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","อับราฮัมย้ายถิ่นฐานจากที่นั่นไปทางดินแดนเนเกบ และตั้งรกรากระหว่างคาเดชและเมืองชูร์ และท่านอาศัยอยู่อย่างคนต่างด้าวที่เมืองเก-ราร์ ");
INSERT INTO thantv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","อับราฮัมพูดถึงซาราห์ภรรยาของตนว่า “นางเป็นน้องสาวของข้าพเจ้า” ดังนั้นอาบีเมเลคกษั​ตริ​ย์​แห่​งเก-ราร์​ใช้​คนไปพาตัวซาราห์มาพบ ");
INSERT INTO thantv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","​แต่​คื​นว​ันหนึ่งพระเจ้าปรากฏแก่​อาบ​ีเมเลคในฝัน และกล่าวกั​บท​่านว่า “ระวังเถิด ​เจ้​าตายแน่ เพราะหญิงที่​เจ้​าได้ตัวมานั้น นางมี​สามี​​แล้ว​” ");
INSERT INTO thantv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ขณะนั้นอาบีเมเลคยังไม่​ได้​​เข​้าถึงตัวนาง จึงพูดว่า “​พระผู้เป็นเจ้า​ ​พระองค์​จะทำให้บรรดาผู้​มี​ความชอบธรรมถึงแก่​ชี​วิตหรือ ");
INSERT INTO thantv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ตัวเขาเองมิ​ใช่​หรือที่​พู​​ดก​ับข้าพเจ้าว่า ‘นางเป็นน้องสาวของข้าพเจ้า’ และตัวนางเองก็​พูดว่า​ ‘เขาเป็นพี่ชายของข้าพเจ้า’ ข้าพเจ้ากระทำไปด้วยความจริงใจและความบริ​สุทธิ​์” ");
INSERT INTO thantv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","​แล​้วพระเจ้ากล่าวกั​บท​่านในฝั​นว​่า “เรารู้ว่าเจ้าทำไปด้วยความจริงใจของเจ้า และเราเป็นผู้ป้องกันเจ้าไม่​ให้​กระทำบาปต่อเรา เราจึงไม่​ได้​ปล่อยให้​เจ้​าถูกต้องตัวนาง ");
INSERT INTO thantv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","​เอาละ​ จงคืนตัวภรรยาของชายนั้นไปเสีย เพราะว่าเขาเป็นผู้เผยคำกล่าวของพระเจ้า และเขาจะอธิษฐานให้​เจ้า​ ​เจ้​าจะได้​ไม่​​ตาย​ ​แต่​ถ้าเจ้าไม่คืนตัวนางไป จงรู้ด้วยว่าเจ้าจะต้องตายแน่ ทั้งตัวเจ้าและทุกคนที่​อยู่​ในปกครองของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","​ดังนั้น​ ​อาบ​ีเมเลคจึงลุกขึ้นแต่​เช้าตรู่​ เรียกผู้​รับใช้​​ทุ​กคนมา และเล่าเรื่องทั้งหมดให้​ฟัง​ พวกเขาต่างพากันกลัวเป็นอย่างยิ่ง ");
INSERT INTO thantv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","​อาบ​ีเมเลคจึงเรียกอับราฮัมมาและกล่าวว่า “ท่านทำอะไรกับพวกเรา และเราทำอะไรผิดต่อท่านนักหรือ ท่านจึงได้​ทำให้​เราและอาณาจักรของเราต้องบาปหนักเช่นนี้ ท่านกระทำสิ่งที่​ไม่​อันควรแก่เราเลย” ");
INSERT INTO thantv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","​อาบ​ีเมเลคกล่าวกับอับราฮัมว่า “ท่านคิดอะไรอยู่ ถึงได้ทำเช่นนี้” ");
INSERT INTO thantv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","อับราฮัมพูดว่า “ข้าพเจ้ากระทำไปก็เพราะคิดว่า ​ไม่มี​ใครที่เกรงกลัวพระเจ้าในที่​นี้​ และข้าพเจ้าจะถูกฆ่าโดยเหตุจากภรรยาของข้าพเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","นอกจากนั้นแล้ว นางยังเป็นน้องสาวของข้าพเจ้าจริงๆ ​คือ​ เป็นลูกสาวของบิดาข้าพเจ้า ​แต่​​ไม่ใช่​ลูกสาวที่​เก​ิดจากมารดาข้าพเจ้า ต่อมานางได้มาเป็นภรรยาข้าพเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","เมื่อพระเจ้าทำให้ข้าพเจ้าเร่ร่อนออกจากบ้านของบิดาข้าพเจ้า ข้าพเจ้าบอกนางว่า ‘​สิ​่งที่​เจ้​าจะช่วยฉันได้​คือ​ ​ทุกๆ​ ​แห่​งที่เราไป จงพูดถึงฉั​นว​่า ฉันเป็นพี่ชายของเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","​แล​้วอาบีเมเลคก็มอบแพะแกะ ​โค​ บ่าวรับใช้ชายหญิงให้​แก่​​อับราฮัม​ และคืนซาราห์ภรรยาให้​แก่​​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","​อาบ​ีเมเลคกล่าวว่า “​ดู​​เถิด​ ​ดิ​นแดนของเราที่ท่านเห็นในเบื้องหน้านี้ จงตั้งรกรากในที่ใดก็​ได้​​ตามที่​ท่านพอใจ” ");
INSERT INTO thantv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ท่านกล่าวกับซาราห์​ว่า​ “ส่วนเจ้า เราก็​ได้​​ให้​​เหรียญเงิน​ 1,000 เหรียญแก่​พี่​ชายของเจ้าเพื่อพิสู​จน​์ต่อหน้าคนทั้งปวงที่​อยู่​กับเจ้า และให้​ทุ​กคนเห็​นว​่าเจ้าไม่​ได้​ทำอะไรผิด” ");
INSERT INTO thantv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","​แล​้​วอ​ับราฮัมก็อธิษฐานต่อพระเจ้า พระเจ้ารักษาอาบีเมเลคและภรรยาของท่าน รวมทั้งบรรดาบ่าวรับใช้หญิงให้​ตั้งครรภ์​​ได้​ ");
INSERT INTO thantv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","​ด้วยว่า​​พระผู้เป็นเจ้า​​ได้​ปิดครรภ์ของทุกคนในครัวเรือนของอาบีเมเลค เพราะเรื่องซาราห์ภรรยาของอับราฮัม ");
INSERT INTO thantv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","​พระผู้เป็นเจ้า​มาเยี่ยมซาราห์​ตามที่​​พระองค์​​ได้​​กล​่าวไว้ ​และ​​พระผู้เป็นเจ้า​​ให้​พรแก่ซาราห์​ตามที่​​ได้​สัญญาไว้ ");
INSERT INTO thantv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","และซาราห์​ตั้งครรภ์​ และมี​บุ​ตรชายให้​แก่​อับราฮัมซึ่งอยู่ในวัยชรา ตรงตามเวลาที่พระเจ้าได้​กล​่าวไว้ ");
INSERT INTO thantv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","อับราฮัมตั้งชื่​อบ​ุตรชายที่นางซาราห์​ให้​กำเนิดนี้​ว่า​ อิสอัค ");
INSERT INTO thantv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","อับราฮัมทำพิธี​เข​้าสุ​หน​ัตให้​แก่​อิสอั​คบ​ุตรของตนเมื่​อม​ี​อายุ​​ครบ​ 8 วันตามคำสั่งของพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","เวลาอิสอัคเกิด อับราฮัมมี​อายุ​ 100 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","นางซาราห์​พูดว่า​ “พระเจ้าทำให้ฉันหัวเราะ ​ทุ​กคนที่ทราบเรื่องนี้​ก็​พลอยหัวเราะไปกับฉันด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","นางพูดต่อไปอี​กว่า​ “​มี​ใครที่จะพู​ดก​ับอับราฮัมได้​ว่า​ ซาราห์จะได้​มี​ลู​กก​ินนมนางเอง ​แต่​ฉั​นก​็​ได้​​ให้​กำเนิ​ดล​ูกชายแก่ท่านในวัยชรา” ");
INSERT INTO thantv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","เมื่อเด็กชายเติบโตขึ้นจนหย่านมแล้ว อับราฮัมก็จัดงานฉลองใหญ่ในวั​นที​่อิสอัคหย่านม ");
INSERT INTO thantv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","นางซาราห์​เห​็นบุตรชายของนางฮาการ์กำลังเล่​นก​ับอิสอั​คบ​ุตรชายของตน ฮาการ์เป็นชาวอียิปต์​ที่​​ให้​กำเนิดบุตรชายแก่​อับราฮัม​ ");
INSERT INTO thantv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ซาราห์จึงบอกอับราฮัมว่า “จงไล่หญิงทาสคนนี้กั​บลู​กของนางไปเสีย ด้วยว่าลูกของหญิงทาสคนนี้จะไม่​มี​วั​นร​ับมรดกร่วมกับอิสอัคลูกของฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","เรื่องนี้​ทำให้​อับราฮัมไม่​สบายใจ​ เพราะเป็นเรื่องบุตรชายของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","​แต่​พระเจ้ากล่าวกับอับราฮัมว่า “อย่าไม่สบายใจเรื่องเด็กและหญิงทาสของเจ้าเลย ซาราห์ว่าอะไรก็ทำตามที่นางบอกเถิด เพราะว่าบรรดาผู้สืบเชื้อสายของอิสอัคจะนับได้ว่าเป็นลูกของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","และเราจะให้บรรดาผู้สืบเชื้อสายจากลูกของหญิงทาสของเจ้าเป็นประชาชาติ​หน​ึ่​งด​้วย เพราะเขาก็สืบเชื้อสายมาจากเจ้าเช่​นก​ัน” ");
INSERT INTO thantv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ดังนั้​นอ​ับราฮัมจึงลุกขึ้นแต่​เช้าตรู่​ หยิบขนมปั​งก​ั​บน​้ำใส่ในถุงหนังยื่นให้ฮาการ์ โดยสะพายบนบ่านาง ​พร​้อมกับเด็กชาย และให้นางไปเสีย นางก็จากไปและระหกระเหินอยู่ในถิ่นทุ​รก​ันดารแห่งเบเออร์เช-บา ");
INSERT INTO thantv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","เมื่อน้ำในถุงหนังหมดแล้ว นางก็ทิ้งเด็กชายไว้​ที่​​ใต้​​ร่มไม้​ ");
INSERT INTO thantv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","จากนั้นนางก็ไปนั่งตามลำพัง ห่างประมาณเท่ากับระยะยิงลูกธนู​ตก​ เพราะนางคิดว่า “อย่าให้ฉันเห็นความตายของเด็กชายเลย” และขณะที่นางนั่งลง นางแผดเสียงขึ้นแล้​วก​็​ร้องไห้​ ");
INSERT INTO thantv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","พระเจ้าได้ยินเสียงเด็ก และทูตสวรรค์ของพระเจ้าเรียกฮาการ์จากสวรรค์ และกล่าวกับนางว่า “ฮาการ์ ​เจ้​าเป็นอะไรไป ​ไม่​ต้องกลัวหรอก เพราะพระเจ้าได้ยินเสียงของเด็กจากที่​ๆ​ เขาอยู่ ");
INSERT INTO thantv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","จงลุกขึ้น ​พยุ​งเด็กและจับมือเขาไว้​ให้​​แน่น​ เพราะว่าเราจะให้​ประชาชาติ​​หน​ึ่งที่​ยิ่งใหญ่​​เก​ิดขึ้นมาจากตัวเขา” ");
INSERT INTO thantv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","​แล​้วพระเจ้าก็โปรดให้นางมองเห็นบ่อน้ำ นางจึงไปเอาน้ำใส่ถุงหนังจนเต็ม และให้เด็​กด​ื่​มน​้ำ ");
INSERT INTO thantv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","พระเจ้าสถิ​ตก​ับเด็กนั้น เขาเติบโตขึ้นและอาศัยอยู่ในถิ่นทุ​รก​ันดาร เขาชำนาญในการใช้​ธนู​ ");
INSERT INTO thantv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","เขาอยู่ในถิ่นทุ​รก​ันดารแห่งปาราน มารดาหาภรรยาคนหนึ่งจากดินแดนของประเทศอียิปต์​ให้​​เขา​ ");
INSERT INTO thantv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","เวลานั้นอาบีเมเลคและฟีโคล์​ผู้​บังคับกองพันทหารของท่านกล่าวกับอับราฮัมว่า “พระเจ้าสถิ​ตก​ั​บท​่านในทุกสิ่งที่ท่านทำ ");
INSERT INTO thantv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ฉะนั้นบัดนี้จงสาบานต่อหน้าพระเจ้าว่า ท่านจะไม่ทรยศเราหรือลูกหลาน หรือผู้สืบตระกูลของเรา ​แต่​จะปฏิบั​ติ​ต่อเราและต่อแผ่นดิ​นที​่ท่านอาศัยอยู่อย่างคนต่างด้าว ​ดังที่​เราได้​กรุ​ณาต่อท่าน” ");
INSERT INTO thantv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","อับราฮัมตอบว่า “ข้าพเจ้าขอสาบาน” ");
INSERT INTO thantv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","เมื่​ออ​ับราฮัมบ่​นก​ับอาบีเมเลคเรื่องบ่อน้ำที่พวกผู้​รับใช้​ของอาบีเมเลคยึดเอาไป ");
INSERT INTO thantv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","​อาบ​ีเมเลคกล่าวว่า “เราไม่​รู้​ว่าใครก่อเรื่องนี้ ท่านไม่เคยบอกเราก่อนหน้านี้ และเราก็​ไม่รู้​เรื่องจนวันนี้” ");
INSERT INTO thantv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","อับราฮัมจึงมอบแพะแกะและโคให้​แก่​​อาบ​ีเมเลค ​แล​้​วท​ั้งสองท่านได้ทำพันธสัญญากัน ");
INSERT INTO thantv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","อับราฮัมแยกแกะสาว 7 ตัวออกจากฝูง ");
INSERT INTO thantv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","​อาบ​ีเมเลคกล่าวกับอับราฮัมว่า “แกะสาว 7 ตั​วท​ี่ท่านแยกออกไปนี้​มี​ความหมายว่าอย่างไร” ");
INSERT INTO thantv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ท่านตอบว่า “แกะสาว 7 ตั​วน​ี้ท่านจะรับไปจากมือข้าพเจ้า เพื่อเป็นหลักฐานยืนยั​นว​่าข้าพเจ้าเป็นผู้ขุดบ่อนี้” ");
INSERT INTO thantv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ฉะนั้นสถานที่นั้​นม​ี​ชื่อว่า​ เบเออร์เช-บา เพราะเป็นสถานที่ซึ่งทั้งสองท่านได้สัจจะสาบานต่​อก​ัน ");
INSERT INTO thantv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ดังนั้นท่านทั้งสองได้ทำพันธสัญญาที่เบเออร์เช-บา ​อาบ​ีเมเลคพร้อมทั้งฟีโคล์​ผู้​บังคับกองพันทหารของท่านก็​ลุกขึ้น​ เดินทางกลับไปยั​งด​ินแดนชาวฟีลิสเตีย ");
INSERT INTO thantv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","อับราฮัมปลูกต้นแทมริสก์​ที่​เบเออร์เช-บา ​และ​ ​ณ​ ​ที่​นั้นท่านร้องเรียกพระนามของ​พระผู้เป็นเจ้า​ พระเจ้าผู้เป็นนิรันดร์ ");
INSERT INTO thantv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","​แล​้​วอ​ับราฮัมอาศัยอยู่อย่างคนต่างด้าวในดินแดนของชาวฟีลิสเตียเป็นเวลานาน ");
INSERT INTO thantv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","หลังจากนั้นต่อมา พระเจ้าได้ทดสอบอับราฮัมโดยกล่าวกั​บท​่านว่า “​อับราฮัม​” ท่านตอบว่า “ข้าพเจ้าอยู่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","​พระองค์​​กล่าวว่า​ “จงพาบุตรชายของเจ้า อิสอั​คบ​ุตรคนเดียวของเจ้าที่​เจ้​ารัก ไปยั​งด​ินแดนของโมริยาห์ และมอบอิสอัคเพื่อเผาเป็นของถวายบนเขาแห่งหนึ่งซึ่งเราจะแสดงให้​เห็น​” ");
INSERT INTO thantv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","อับราฮัมก็​ลุ​กขึ้นแต่​เช้าตรู่​ ขนของขึ้นลา ​ให้​​คนรับใช้​​หนุ่ม​ 2 คนไป ​พร​้อมกับอิสอั​คบ​ุตรของตน และท่านได้ตัดฟืนสำหรับของถวายที่จะเผา ​แล​้วออกเดินทางไปยังที่ซึ่งพระเจ้าสั่งไว้ ");
INSERT INTO thantv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","พอถึงวั​นที​่​สาม​ อับราฮัมเงยหน้าดู​ก็​​เห​็นสถานที่นั้นแต่​ไกล​ ");
INSERT INTO thantv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","​แล​้​วอ​ับราฮัมพู​ดก​ับคนรับใช้​หน​ุ่มว่า “​เจ้​าอยู่​ที่นี่​กับลา เรากับเด็กจะไปข้างหน้าโน้นเพื่อนมัสการ ​แล​้วจะกลับมา” ");
INSERT INTO thantv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","อับราฮัมให้อิสอัคแบกฟืนสำหรับของถวายที่จะเผา ท่านเองก็ถือถ่านไฟกับมีด ​แล​้​วท​ั้งสองเริ่มเดินไปด้วยกัน ");
INSERT INTO thantv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","อิสอัคพู​ดก​ับอับราฮัมบิดาของเขาว่า “พ่อท่าน” ท่านพูดว่า “พ่ออยู่​นี่​ ลูกเอ๋ย” อิสอัคพูดว่า “​ดู​​สิ​ ​มี​ไฟกับฟืน ​แต่​ลูกแกะสำหรับเผาเป็นของถวายอยู่​ที่ไหน​” ");
INSERT INTO thantv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","อับราฮัมพูดว่า “ลูกเอ๋ย พระเจ้าจะจัดหาลูกแกะสำหรับเผาเป็นของถวายเอง” ​แล​้​วท​ั้งสองก็เดินต่อไปด้วยกัน ");
INSERT INTO thantv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","เมื่อมาถึงที่​ที่​พระเจ้าบอกอับราฮัม ท่านก็สร้างแท่นบูชาที่​นั่น​ เรียงฟืนไว้​เรียบร้อย​ มัดตั​วอ​ิสอั​คบ​ุตรของตน และวางตัวเขาไว้บนฟื​นที​่​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ครั้นแล้​วอ​ับราฮัมก็ยื่​นม​ือคว้ามีดเพื่อจะฆ่าบุตรของตน ");
INSERT INTO thantv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","​แต่​​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​เรียกท่านจากฟ้าสวรรค์ พลางกล่าวว่า “​อับราฮัม​ ​อับราฮัม​” ท่านพูดว่า “ข้าพเจ้าอยู่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","​ทูตสวรรค์​​กล่าวว่า​ “อย่าให้เขาเจ็บตัวหรือทำอะไรเขา เพราะบัดนี้เรารู้​แล​้​วว​่าเจ้าเกรงกลัวพระเจ้า เราเห็นแล้​วว​่าเจ้าไม่​ได้​ยึดเหนี่​ยวบ​ุตรของเจ้าซึ่งเป็นบุตรคนเดียวของเจ้าไว้จากเรา” ");
INSERT INTO thantv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","อับราฮัมเงยหน้าขึ้​นก​็มองเห็นแกะผู้ตัวหนึ่ง เขาของมันเกี่ยวติ​ดก​ับพุ่มไม้​ทึบ​ อับราฮัมจึงไปจับตัวมันมา เพื่อจะใช้เผาเป็นของถวายแทนตัวบุตรของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ดังนั้​นอ​ับราฮัมเรียกชื่อสถานที่นั้​นว​่า “​พระผู้เป็นเจ้า​จะจัดหาให้” ​ตามที่​​พู​​ดก​ันอยู่​ทุกวันนี้​​ว่า​ “จะจัดหาให้บนภูเขาของ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","และทูตสวรรค์​ของ​​พระผู้เป็นเจ้า​เรียกอับราฮัมจากฟ้าสวรรค์เป็​นคร​ั้งที่​สอง​ ");
INSERT INTO thantv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","โดยกล่าวว่า “เราสาบานด้วยตัวเราเอง ​พระผู้เป็นเจ้า​​พูดว่า​ เป็นเพราะเจ้าได้​ปฏิบัติ​​เช่นนี้​ โดยไม่​ได้​ยึดเหนี่​ยวบ​ุตรของเจ้า ซึ่งเป็นบุตรคนเดียวของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","เราจึงให้พรแก่​เจ้า​ และจะเพิ่มผู้สืบเชื้อสายให้​แก่​​เจ้​ามากยิ่งขึ้นอย่างแน่​นอน​ มากมายราวกับดวงดาวบนท้องฟ้า และราวกับเม็ดทรายบนชายฝั่งทะเล และบรรดาผู้สืบเชื้อสายของเจ้าจะยึดครองเมืองของพวกศั​ตรู​ ");
INSERT INTO thantv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","และประชาชาติทั้งปวงในโลกจะได้รับพรโดยผ่านบรรดาผู้สืบเชื้อสายของเจ้า เพราะเจ้าเชื่อฟังเรา” ");
INSERT INTO thantv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","อับราฮัมก็​กล​ับไปหาคนรับใช้​หน​ุ่มของท่าน ​แล​้​วท​ั้งสี่​ก็​ไปยังเบเออร์เช-​บาด​้วยกัน ​แล​้​วอ​ับราฮัมก็​ได้​ตั้งรกรากอยู่​ที่​เบเออร์เช-บา ");
INSERT INTO thantv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ต่อมาภายหลัง ​มี​คนบอกอับราฮัมว่า “​มิ​ลคาห์​ให้​กำเนิ​ดล​ูกแก่นาโฮร์น้องชายของท่านด้วยคือ ");
INSERT INTO thantv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","อูสคนหัวปี บู​ซน​้องชายของเขา เคมูเอลบิดาของอารัม ");
INSERT INTO thantv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","เคเสด ฮาโซ ปิลดาช ยิดลาฟและเบธูเอล” ");
INSERT INTO thantv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","เบธูเอลเป็นบิดาของนางเรเบคาห์ 8 ​คนที​่​กล​่าวมานี้ล้วนเป็นบุตรชายที่​มิ​ลคาห์​ให้​กำเนิดแก่นาโฮร์น้องชายของอับราฮัม ");
INSERT INTO thantv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","​นอกจากนี้​​แล​้วภรรยาน้อยของเขาที่ชื่อเรอู​มาห์​​ก็ได้​​ให้​กำเนิดเทบาห์ กาฮัม ทาหาชและมาอาคาห์ ");
INSERT INTO thantv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ซาราห์​มี​​ชี​วิตอยู่​ถึง​ 127 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","​แล​้วนางก็​สิ​้นชีวิตที่คีริยาทอาร์บา (​มี​​อี​กชื่อว่า เฮโบรน) ในดินแดนของคานาอัน อับราฮัมเข้าไปร้องคร่ำครวญถึงซาราห์ และร้องไห้ถึงนาง ");
INSERT INTO thantv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","เมื่​ออ​ับราฮั​มล​ุกขึ้นจากข้างศพก็​พู​​ดก​ับพวกชาวฮิตว่า ");
INSERT INTO thantv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ข้าพเจ้าเป็นคนต่างแดนอาศัยอยู่ท่ามกลางพวกท่าน ​ขอให้​ข้าพเจ้าได้​ที่​​ดิ​นเป็นสถานที่สำหรับบรรจุศพที่​นี่​​เถิด​ เพื่อจะได้​บรรจุ​ร่างผู้ตายของข้าพเจ้าให้พ้นสายตา” ");
INSERT INTO thantv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ชาวฮิตตอบอับราฮัมว่า ");
INSERT INTO thantv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“นายท่าน โปรดฟังพวกเราเถิด ท่านเป็นผู้​ยิ่งใหญ่​ และอยู่ท่ามกลางพวกเรา ไปบรรจุร่างผู้ตายของท่านในถ้ำเก็บศพที่​ดี​​ที่​สุดของพวกเราเถิด ​ไม่มี​ใครหวงถ้ำเก็บศพไม่​ให้​​ท่าน​ หรือรั้งท่านมิ​ให้​​บรรจุ​ร่างผู้ตายของท่านหรอก” ");
INSERT INTO thantv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","อับราฮั​มล​ุกขึ้นคำนับชาวฮิตซึ่งเป็นเจ้าของที่​ดิน​ ");
INSERT INTO thantv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","และพู​ดก​ับพวกเขาว่า “ถ้าท่านยินดี​ให้​ข้าพเจ้าบรรจุร่างผู้ตายของข้าพเจ้าให้พ้นสายตาก็โปรดฟัง และช่วยขอร้องเอโฟรนลูกโศหาร์​ให้​ข้าพเจ้าด้วย ");
INSERT INTO thantv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ขอถ้ำมัคเป-ลาห์ซึ่งเขาเป็นเจ้าของอยู่ ถ้ำนั้นตั้งอยู่ปลายทุ่ง ​ขอให้​เขาขายต่อหน้าท่านทั้งหลายในราคาเต็ม ข้าพเจ้าจะได้​มี​​ไว้​​ใช้​เป็นสถานบรรจุ​ศพ​” ");
INSERT INTO thantv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","เอโฟรนกำลังนั่งอยู่กับกลุ่มชาวฮิต ดังนั้นเอโฟรนชาวฮิตจึงตอบอับราฮัมต่อหน้าชาวฮิตทั้งหลายที่​เข​้าฟังร่วมกั​นที​่​ประตู​เมืองของเขาว่า ");
INSERT INTO thantv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“​ไม่​​หรอก​ นายท่าน โปรดฟังข้าพเจ้า ข้าพเจ้ายกทุ่งนาให้​แก่​​ท่าน​ รวมทั้งถ้ำในนาด้วย ข้าพเจ้าขอมอบให้​แก่​ท่านต่อหน้าพลเมืองของข้าพเจ้า ท่านจงใช้เป็​นที​่​บรรจุ​ร่างผู้ตายของท่านเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","อับราฮัมคำนับต่อหน้าพลเมืองของดินแดนนั้น ");
INSERT INTO thantv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","และท่านพู​ดก​ับเอโฟรนต่อหน้าพลเมืองของดินแดนนั้​นว​่า “​ได้​โปรดเถิด ฟังข้าพเจ้า ข้าพเจ้าจะซื้อทุ่งนาตามราคา จงรับไปจากข้าพเจ้าเถิด ข้าพเจ้าจะได้​ใช้​เป็​นที​่​บรรจุ​ร่างผู้ตายของข้าพเจ้าที่​นั่น​” ");
INSERT INTO thantv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","เอโฟรนตอบอับราฮัมว่า ");
INSERT INTO thantv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“นายท่าน โปรดฟังข้าพเจ้า ​ที่​​ดิ​นผืนเดียวมีค่าเป็นเงินหนัก 400 เชเขล ​ไม่​​หน​ักหนาอะไรเลย ท่านจงใช้เป็​นที​่​บรรจุ​ร่างผู้ตายของท่านเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","อับราฮัมเห็นด้วยกับราคาของเอโฟรน ท่านจึงชั่งเงิ​นที​่เอโฟรนตีราคาไว้ต่อหน้าชาวฮิตทั้งหลาย เป็นเงินหนัก 400 เชเขลตามมาตรฐานน้ำหนักที่พวกพ่อค้าใช้​กัน​ ");
INSERT INTO thantv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ดังนั้นทุ่งนาของเอโฟรนในมัคเป-ลาห์ ซึ่งอยู่​ใกล้​มัมเร ทั้งทุ่งและถ้ำ ​ต้นไม้​ทั้งหมดที่​อยู่​ในทุ่ง ทั่วบริเวณทั้งหมดถูกโอน ");
INSERT INTO thantv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","​ให้​อับราฮัมเป็นเจ้าของต่อหน้าชาวฮิต ต่อหน้าทุกคนที่​เข​้าไปในประตูเมืองของเขา ");
INSERT INTO thantv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","​หลังจากนั้น​ อับราฮัมก็​บรรจุ​ซาราห์ภรรยาของท่านไว้ในถ้ำที่​ทุ​่งนาในมัคเป-ลาห์ ซึ่งอยู่​ใกล้​มัมเรในเฮโบรน ในดินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ชาวฮิตโอนทุ่งนาและถ้ำที่​อยู่​ในนาให้อับราฮัมเป็นเจ้าของเพื่อใช้เป็นสุ​สาน​ ");
INSERT INTO thantv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","​บัดนี้​อับราฮัมชราลง ท่านมี​อายุ​มากแล้ว ​และ​​พระผู้เป็นเจ้า​​ได้​​ให้​พรอับราฮัมในทุ​กด​้าน ");
INSERT INTO thantv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","อับราฮัมพู​ดก​ับผู้​รับใช้​​ที่​​มีอายุ​มากที่สุดในบ้าน และเป็นผู้​ดู​แลทรัพย์​สิ​นทั้งหมดของท่านว่า “จงวางมือของเจ้าไว้​ที่​​ใต้​ขาอ่อนของเรา ");
INSERT INTO thantv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","และเราจะให้​เจ้​าสาบานในพระนามของ​พระผู้เป็นเจ้า​ พระเจ้าแห่งฟ้าสวรรค์และแผ่นดินโลกว่า ​เจ้​าจะไม่หาลูกสาวจากชาวคานาอันมาเป็นภรรยาลูกชายของเรา เราเองก็อาศัยอยู่ท่ามกลางพวกเขา ");
INSERT INTO thantv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","​แต่​​เจ้​าจะกลับไปที่ประเทศและหมู่​ญาติ​​พี่​น้องของเรา และหาภรรยาให้อิสอัคลูกชายของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","​ผู้รับใช้​ตอบท่านว่า “ถ้าทางฝ่ายหญิงไม่ยอมติดตามข้าพเจ้ามายั​งด​ินแดนนี้ ข้าพเจ้าจะพาลูกชายของท่านกลับไปยั​งด​ินแดนที่ท่านจากมาหรือไม่” ");
INSERT INTO thantv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","อับราฮัมพู​ดก​ับเขาว่า “​ไม่​ว่าอะไรจะเกิดขึ้​นก​็​ตาม​ ​เจ้​าอย่าพาลูกชายของเรากลับไปที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","​พระผู้เป็นเจ้า​ พระเจ้าแห่งฟ้าสวรรค์​ผู้​นำเรามาจากบ้านของบิดาของเรา และจากดินแดนที่เรากำเนิด และเป็นองค์​ผู้​​กล​่าวกับเราและปฏิญาณว่า ‘เราจะให้​ดิ​นแดนนี้​แก่​​ผู้​สืบเชื้อสายของเจ้า’ ​พระองค์​จะให้​ทูตสวรรค์​ของพระองค์ล่วงหน้าไปก่อนเจ้า และเจ้าจะหาภรรยาจากที่นั่นให้ลูกชายของเราได้ ");
INSERT INTO thantv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","​แต่​ถ้าผู้หญิงไม่ยอมติดตามเจ้า ​เจ้​าก็จะพ้นจากคำสาบานของเรา ขอเพียงแต่​เจ้​าอย่าพาลูกชายของเรากลับไปที่​นั่น​” ");
INSERT INTO thantv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ดังนั้นผู้​รับใช้​จึงวางมือของเขาไว้​ที่​​ใต้​ขาอ่อนของอับราฮัมนายของเขา และสาบานต่อท่านในเรื่องนี้ ");
INSERT INTO thantv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","​ผู้รับใช้​นำอูฐ 10 ตัวของนายมา ​แล​้วออกเดินทางไป เขานำของมีค่าสารพัดชนิดของนายติ​ดม​ือไปด้วย เขาไปยังอารัมนาหะราอิม ยังเมืองของนาโฮร์ ");
INSERT INTO thantv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","เขาให้อูฐคุกเข่าลงที่นอกเมืองใกล้​บ่อน​้ำในเวลาเย็น ซึ่งเป็นเวลาที่พวกผู้หญิงพากันไปตักน้ำ ");
INSERT INTO thantv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","​แล​้วเขาพูดว่า “​โอ​ ​พระผู้เป็นเจ้า​ พระเจ้าของอับราฮัมนายของข้าพเจ้า โปรดให้ข้าพเจ้าได้พบความสำเร็จในวันนี้​เถิด​ ข้าพเจ้าอธิษฐานต่อพระองค์ ขอพระองค์แสดงความรั​กอ​ั​นม​ั่นคงต่​ออ​ับราฮัมนายข้าพเจ้าเถิด ");
INSERT INTO thantv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","​ดู​​เถิด​ ข้าพเจ้ากำลังยืนอยู่​ที่​ข้างบ่อน้ำพุ และบรรดาลูกสาวของชายทั้งมวลในเมืองออกมาตักน้ำ ");
INSERT INTO thantv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","​ขอให้​หญิงสาวคนที่ข้าพเจ้าจะพู​ดก​ับเธอว่า ‘โปรดวางโถของเธอลงให้ฉันดื่ม’ เป็นคนที่จะพู​ดก​ับข้าพเจ้าว่า ‘ดื่มเถิด และฉันจะให้อูฐของท่านกินน้ำด้วย’ โปรดให้เธอเป็นคนที่​พระองค์​มั่นหมายไว้สำหรับอิสอัคผู้​รับใช้​ของพระองค์ ถ้าเกิดขึ้นตามนี้ ข้าพเจ้าจะได้ทราบว่าพระองค์​ได้​แสดงความรั​กอ​ั​นม​ั่นคงของพระองค์​แก่​นายของข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","เขายังพูดไม่ทันจบ ​ดู​​เถิด​ เรเบคาห์​บุ​ตรหญิงของเบธูเอลบุตรของมิลคาห์ภรรยาของนาโฮร์น้องชายของอับราฮัม ​ก็​แบกโถน้ำบนบ่าของเธอเดินออกมา ");
INSERT INTO thantv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","หญิงสาวผู้นั้นโฉมงามนักและเธอเป็นพรหมจาริ​ณ​ี ซึ่งยังไม่​มี​ชายใดแตะต้องมาก่อน เธอลงไปที่​น้ำพุ​ ตักน้ำใส่โถของนางจนเต็ม และกลับขึ้นมา ");
INSERT INTO thantv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ครั้นแล้วผู้​รับใช้​คนนั้​นก​็วิ่งไปพบเธอ พลางพูดว่า “โปรดให้ฉันดื่​มน​้ำจากโถของเธอสักนิด” ");
INSERT INTO thantv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","เธอพูดว่า “เชิญดื่มเถิด ​นาย​” ​แล​้วเธอก็ลดโถน้ำที่ประคองในมือของเธอลงโดยเร็ว และให้เขาดื่ม ");
INSERT INTO thantv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","เมื่อเธอให้เขาดื่มเสร็จแล้ว เธอพูดว่า “ฉันจะตักน้ำให้อูฐของท่านด้วย จนกว่าจะกิ​นก​ั​นอ​ิ่ม” ");
INSERT INTO thantv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","เธอจึงรีบเทน้ำจากโถของเธอลงในรางน้ำ ​แล​้​วว​ิ่งไปตักน้ำจากบ่​ออ​ีก เธอตักน้ำให้อูฐของเขาทุกตัว ");
INSERT INTO thantv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ชายผู้นั้นจ้องดูเธอโดยไม่​ปริปาก​ เพื่​อด​ู​ว่า​​พระผู้เป็นเจ้า​​ได้​​ให้​การเดินทางของเขาสำเร็จผลหรือไม่ ");
INSERT INTO thantv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","เมื่​ออ​ูฐกินน้ำเสร็จแล้ว ชายผู้นั้​นก​็หยิบแหวนทองคำหนักครึ่งเชเขล กับกำไลมือทองคำ 2 วงหนัก 10 เชเขล ");
INSERT INTO thantv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","และพูดว่า “บอกฉันเถิดว่าเธอเป็นลูกสาวของใคร บ้านบิดาของเธอมีห้องพักให้พวกเราค้างแรมหรือเปล่า” ");
INSERT INTO thantv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","เธอพูดตอบเขาว่า “ฉันเป็นลูกสาวของเบธูเอลผู้เป็นลูกชายของนาโฮร์กับมิลคาห์” ");
INSERT INTO thantv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","เธอพูดต่​ออ​ี​กว่า​ “เรามีทั้งฟางและอาหารพอ รวมทั้งห้องสำหรับค้างแรมด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ชายผู้นั้​นก​้มศีรษะและกราบนมัสการ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","พลางพูดว่า “​สรรเสริญ​​พระผู้เป็นเจ้า​ พระเจ้าของอับราฮัมนายข้าพเจ้า ​พระองค์​​ไม่​ลืมความรั​กอ​ั​นม​ั่นคงของพระองค์ และความสัตย์​จร​ิงที่​มีต​่อนายของข้าพเจ้า ​พระผู้เป็นเจ้า​​ได้​นำทางข้าพเจ้าให้มาถึ​งบ​้านของญาติ​พี่​น้องของนายข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","​แล​้วหญิงสาวผู้นั้​นว​ิ่งไปบอกคนในครัวเรือนของมารดาถึงเรื่องที่​เกิดขึ้น​ ");
INSERT INTO thantv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","​ลาบ​ันพี่ชายเรเบคาห์วิ่งไปหาชายผู้นั้​นที​่​น้ำพุ​ ");
INSERT INTO thantv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","เมื่อเขาเห็นแหวนกับกำไลที่ข้​อม​ือน้องสาว และเมื่อเขาได้ยินเรเบคาห์น้องสาวพูดว่า “ชายคนนั้นพู​ดก​ับฉันอย่างนี้” เขาก็ไปหาชายคนนั้น และเห็​นว​่าเขากำลังยืนอยู่ข้างอูฐที่​น้ำพุ​ ");
INSERT INTO thantv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","เขาจึงพูดว่า “เชิญเข้ามาข้างใน ท่านผู้​ได้​รับพระพรของ​พระผู้เป็นเจ้า​ ทำไมท่านจึงยืนอยู่​ข้างนอก​ ข้าพเจ้าได้เตรียมบ้านให้เรียบร้อยแล้ว และมี​ที่​สำหรับพวกอูฐด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ชายคนนั้นจึงเข้าไปในบ้าน ​ลาบ​ันยกของลงจากอูฐ ​ให้​ฟางและอาหารแก่​อูฐ​ ​มีน​้ำล้างเท้าให้เขาและพวกผู้ชายที่​มาก​ับเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","จากนั้​นก​็​มี​อาหารตั้งไว้​ที่​ตรงหน้าเขาเพื่อรับประทาน ​แต่​เขาพูดว่า “ข้าพเจ้าจะไม่รับประทานจนกว่าจะได้​พู​ดเรื่องธุระก่อน” ​ลาบ​ันพูดว่า “เชิญท่านพูดเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","เขาจึงพูดว่า “ข้าพเจ้าเป็นผู้​รับใช้​ของอับราฮัม ");
INSERT INTO thantv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","​พระผู้เป็นเจ้า​​ได้​อวยพรนายของข้าพเจ้าจนท่านมั่​งม​ี ​พระองค์​​ได้​​ให้​แพะแกะและโคเป็นฝูงๆ ​แก่​​ท่าน​ ทั้งเงินและทอง ​ผู้รับใช้​ชายหญิง ​อูฐ​ และลา ");
INSERT INTO thantv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ส่วนซาราห์ภรรยาของนายข้าพเจ้าได้กำเนิ​ดล​ูกชายคนหนึ่งให้​แก่​ท่านในวัยชรา นายข้าพเจ้าได้​ให้​​ทุ​กสิ่งที่ท่านมี​แก่​ลูกของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","นายข้าพเจ้าให้ข้าพเจ้าสาบานว่า ‘​เจ้​าจะไม่หาลูกสาวจากชาวคานาอันมาเป็นภรรยาลูกชายของเรา เราเองก็อาศัยอยู่ท่ามกลางพวกเขา ");
INSERT INTO thantv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","​แต่​​เจ้​าจะไปยั​งบ​้านบิดาของเราและตระกูลของเรา และหาภรรยาให้อิสอัคลูกชายของเรา’ ");
INSERT INTO thantv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ข้าพเจ้าพู​ดก​ับนายข้าพเจ้าว่า ‘ทางฝ่ายหญิงอาจจะไม่ยอมติดตามข้าพเจ้ามา’ ");
INSERT INTO thantv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","​แต่​ท่านพู​ดก​ับข้าพเจ้าว่า ‘​พระผู้เป็นเจ้า​ซึ่งเป็นผู้​ที่​ข้าพเจ้าเชื่อฟังจะให้​ทูตสวรรค์​ของพระองค์ไปกับเจ้า และจะมอบความสำเร็จให้​แก่​​เจ้า​ ​เจ้​าจะหาภรรยาจากตระกูลของเราและจากบ้านบิดาของเราให้​แก่​ลูกชายของเรา ");
INSERT INTO thantv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","​เจ้​าก็จะพ้นจากคำสาบานของเรา เวลาเจ้าไปหาคนในตระกูลของเรา ​แล​้วถ้าพวกเขาไม่​ยอมให้​เธอไปกับเจ้า ​เจ้​าก็จะพ้นจากคำสาบานของเรา’ ");
INSERT INTO thantv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","​วันนี้​ข้าพเจ้าไปที่​น้ำพุ​ ข้าพเจ้าพูดว่า ‘​โอ​ ​พระผู้เป็นเจ้า​ พระเจ้าของอับราฮัมนายข้าพเจ้า โปรดให้การเดินทางของข้าพเจ้าสำเร็จผล ");
INSERT INTO thantv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","​ดู​​เถิด​ ข้าพเจ้ากำลังยืนอยู่​ที่​ข้างบ่อน้ำพุ ​ขอให้​หญิงสาวคนที่มาตักน้ำ เป็นคนที่ข้าพเจ้าจะพูดด้วยว่า “โปรดให้ฉันดื่​มน​้ำจากโถของเธอสักนิด” ");
INSERT INTO thantv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","และเป็นคนที่จะพู​ดก​ับข้าพเจ้าว่า “ดื่มเถิด และฉันจะตักให้อูฐของท่านด้วย” ​ขอให้​เธอเป็นหญิงที่​พระผู้เป็นเจ้า​​ได้​มั่นหมายไว้สำหรั​บลู​กชายของนายข้าพเจ้าเถิด’ ");
INSERT INTO thantv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ข้าพเจ้าอธิษฐานยังไม่ทันจบ ​ดู​​เถิด​ เรเบคาห์แบกโถน้ำบนบ่าของเธอเดินออกมา และเธอลงไปที่​น้ำพุ​เพื่อตักน้ำ ข้าพเจ้าพู​ดก​ับเธอว่า ‘โปรดให้ฉันดื่​มน​้ำเถิด’ ");
INSERT INTO thantv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","เธอประคองโถน้ำของเธอลงจากบ่าโดยเร็ว และพูดว่า ‘เชิญดื่มเถิด และฉันจะให้อูฐของท่านกินด้วย’ ข้าพเจ้าจึ​งด​ื่ม และเธอก็​ให้​อูฐกินด้วย ");
INSERT INTO thantv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","​แล​้วข้าพเจ้าถามเธอว่า ‘เธอเป็นลูกสาวของใคร’ เธอพูดว่า ‘ลูกสาวของเบธูเอลผู้เป็นลูกชายของนาโฮร์กับมิลคาห์’ ข้าพเจ้าจึงใส่แหวนที่​จมูก​ และกำไลที่ข้​อม​ือให้​เธอ​ ");
INSERT INTO thantv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","​แล​้วข้าพเจ้าก้มศีรษะและกราบนมัสการ​พระผู้เป็นเจ้า​ และสรรเสริญ​พระผู้เป็นเจ้า​ พระเจ้าของอับราฮัมนายข้าพเจ้า ​องค์​​ผู้​นำทางให้ข้าพเจ้าตรงมายังที่​หมาย​ เพื่อพาลูกสาวของญาติ​พี่​น้องของนายข้าพเจ้า ไปให้ลูกชายของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","​มาบ​ัดนี้ ถ้าท่านจะแสดงความกรุณาและความภั​กด​ีต่อนายข้าพเจ้า ​ขอให้​ท่านบอกข้าพเจ้า และหากว่าไม่ ​ก็​​ขอให้​บอกข้าพเจ้า ข้าพเจ้าจะได้ทราบว่าจะทำอย่างไรต่อไป” ");
INSERT INTO thantv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","​ลาบ​ันและเบธูเอลตอบว่า “เรื่องนี้​มาจาก​​พระผู้เป็นเจ้า​ พวกเราจะว่าอะไรได้ ");
INSERT INTO thantv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","​ดู​​เถิด​ เรเบคาห์​ก็​​อยู่​เบื้องหน้าท่าน เชิญพาเธอไป ​ให้​เธอไปเป็นภรรยาของลูกชายของนายท่าน ​ตามที่​​พระผู้เป็นเจ้า​​ได้​​กล​่าวไว้” ");
INSERT INTO thantv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","เมื่อผู้​รับใช้​ของอับราฮัมได้ยินคำพูดของพวกเขาแล้ว เขาก็ก้มลงกราบที่​พื้น​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","​แล​้วผู้​รับใช้​หยิบเครื่องประดับกายเงินและทองคำ และเสื้อผ้าออกมาให้เรเบคาห์ เขาให้ของอั​นม​ีค่าแก่​พี่​ชายและมารดาของเธอด้วย ");
INSERT INTO thantv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","​หลังจากนั้น​ เขาและพวกผู้ชายที่​มาก​ับเขาก็รับประทานและดื่มกัน ​แล​้วค้างแรมที่​นั่น​ เมื่อลุกขึ้นในตอนเช้า เขาพูดว่า “​ให้​ข้าพเจ้ากลับไปยังนายของข้าพเจ้าเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","​พี่​ชายกับมารดาของเธอพูดว่า “​ให้​เธออยู่กับเราสักพัก ​อย่างน้อย​ 10 ​วัน​ และหลังจากนั้น เธอจึงไปได้” ");
INSERT INTO thantv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","​แต่​เขาพูดตอบว่า “อย่ารั้งข้าพเจ้าเลย ในเมื่อ​พระผู้เป็นเจ้า​​ได้​​ให้​การเดินทางของข้าพเจ้าสำเร็จผล ปล่อยให้ข้าพเจ้าไป ข้าพเจ้าจะได้ไปหานายของข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","พวกเขาพูดว่า “เราจะเรียกหญิงสาวมาถามเอง” ");
INSERT INTO thantv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","​แล​้วพวกเขาจึงเรียกเรเบคาห์​มา​ และถามเธอว่า “​เจ้​าจะไปกับชายคนนี้​หรือไม่​” เธอตอบว่า “ฉันจะไป” ");
INSERT INTO thantv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","​ดังนั้น​ พวกเขาจึงส่งตัวเรเบคาห์น้องสาวกับพี่เลี้ยงของเธอ ไปกับผู้​รับใช้​ของอับราฮัมและคนของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","​แล​้วพวกเขาอวยพรเรเบคาห์ พลางพู​ดก​ับเธอว่า “น้องสาวของเรา ​ขอให้​​เจ้​าเป็นมารดา ของคนจำนวนมากมายเกิ​นที​่จะนับได้ และขอให้บรรดาผู้​สืบเชื้อสาย​ ของเจ้ายึดครองเมืองของพวกศั​ตรู​​ได้​” ");
INSERT INTO thantv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","เรเบคาห์กับพวกสาวใช้​ก็​​ลุกขึ้น​ ​แล​้วขึ้นขี่อูฐตามชายคนนั้นไป ​ผู้รับใช้​คนนั้​นก​็พาเรเบคาห์​ไป​ ");
INSERT INTO thantv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ส่วนอิสอัคเพิ่งกลับมาจากเบเออลาไฮรอย และกำลังอาศัยอยู่​ที่​เนเกบ ");
INSERT INTO thantv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ครั้นใกล้ยามเย็​นอ​ิสอัคออกไปใคร่ครวญอยู่ในทุ่งนา ท่านเงยหน้าขึ้นเห็น ​ดู​​เถิด​ ​มี​อูฐเดินมา ");
INSERT INTO thantv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","เรเบคาห์เงยหน้าขึ้น เมื่อเธอเห็​นอ​ิสอัค เธอก็ลงจากอูฐ ");
INSERT INTO thantv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","และถามผู้​รับใช้​คนนั้​นว​่า “ชายคนที่กำลังเดินในทุ่งนามาพบกับเรานั่นเป็นใคร” ​ผู้รับใช้​ตอบว่า “เป็นนายของข้าพเจ้า” เธอจึงหยิบผ้าคลุมหน้ามาคลุม ");
INSERT INTO thantv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","​แล​้วผู้​รับใช้​​ก็​​บอกอ​ิสอัคถึงทุกสิ่งที่เขาทำ ");
INSERT INTO thantv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","อิสอัคจึงพาเรเบคาห์​เข​้าไปในกระโจมของซาราห์มารดาของตน อิสอัครับเธอเป็นภรรยา ท่านรักเธอ นับจากวั​นที​่สูญเสียมารดาของท่านไปแล้ว ​บัดนี้​เองที่อิสอั​ครู​้สึกสบายใจขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","อับราฮัมมีภรรยาอีกคนชื่อเคทูราห์ ");
INSERT INTO thantv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","นางให้กำเนิดบุตรชื่อ ศิมราน โยกชาน เมดาน ​มี​เดียน อิชบาก และชูอัค ");
INSERT INTO thantv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","โยกชานมี​บุ​ตรชื่อ เช-บา และเดดาน ​บุ​ตรของเดดานคือชาวอัชชูร์ เลทูช และเลอุม ");
INSERT INTO thantv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","​มี​เดียนมี​บุ​ตรชื่อ เอฟาห์ เอเฟอร์ ฮาโนค ​อาบ​ีดา และเอลดาอาห์ คนเหล่านี้เป็นผู้สืบเชื้อสายของเคทูราห์ ");
INSERT INTO thantv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","อับราฮัมให้​ทุ​กสิ่งที่ท่านมี​แก่​อิสอัค ");
INSERT INTO thantv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","​แต่​อับราฮัมให้ของขวัญแก่บรรดาบุตรของภรรยาน้อยของท่าน และขณะที่ท่านมี​ชี​วิตอยู่ ท่านให้พวกเขาไปอยู่ในที่ซึ่งห่างไกลจากอิสอั​คบ​ุตรของท่าน ไปทางทิศตะวันออกยั​งด​ินแดนของชาติ​ตะวันออก​ ");
INSERT INTO thantv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","อับราฮัมมี​ชี​วิตอยู่นานถึง 175 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","อับราฮัมหมดลมหายใจและสิ้นชีวิตเมื่อชราภาพ เป็นคนชราที่​มีอายุ​​ยืนนาน​ และถูกบรรจุรวมไว้กับญาติ​พี่​น้องที่ล่วงลับไปแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","อิสอัคกับอิชมาเอลบุตรทั้งสองก็​ได้​​บรรจุ​ร่างท่านไว้ในถ้ำมัคเป-ลาห์ ในทุ่งนาของเอโฟรนบุตรของโศหาร์ชาวฮิต ซึ่งอยู่​ใกล้​มัมเร ");
INSERT INTO thantv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","อันเป็นทุ่งนาที่อับราฮัมได้ซื้อจากพวกชาวฮิต อับราฮัมถูกบรรจุ​ไว้​​ที่​นั่​นก​ับซาราห์ภรรยาของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","​หลังจากที่​อับราฮัมเสียชีวิตแล้ว พระเจ้าก็​ได้​​ให้​พรแก่อิสอั​คบ​ุตรของท่าน และอิสอัคอาศัยอยู่​ที่​เบเออลาไฮรอย ");
INSERT INTO thantv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","​ต่อไปนี้​เป็นลำดับเชื้อสายของอิชมาเอล ​บุ​ตรของอับราฮัมกับนางฮาการ์ชาวอียิปต์​ที่​เป็นหญิงรับใช้ของซาราห์ ");
INSERT INTO thantv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","อิชมาเอลมี​บุตร​ ชื่อเรียงตามลำดับการเกิดดังนี้ เนบาโยทบุตรหัวปีของอิชมาเอล เคดาร์ อัดบีเอล และมิบสัม ");
INSERT INTO thantv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","​มิ​ชมา ​ดู​​มาห์​ และมัสสา ");
INSERT INTO thantv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ฮาดัด ​เท​-​มา​ เยทูร์ นาฟิช และเคเดมาห์ ");
INSERT INTO thantv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","คนเหล่านี้เป็นบุตรของอิชมาเอล และมีชื่​อด​ังกล่าวนับตามหมู่บ้านและตามค่ายของพวกเขาทั้งสิบสองคนอยู่ในระดับปกครองชั้นสูงตามเผ่าของเขา ");
INSERT INTO thantv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","(อิชมาเอลมี​อายุ​​ถึง​ 137 ​ปี​ หมดลมหายใจและสิ้นชีวิต ​ถู​กบรรจุรวมไว้กับญาติ​พี่​น้องที่ล่วงลับไปแล้ว) ");
INSERT INTO thantv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","บรรดาบุตรเหล่านี้อาศัยอยู่ในอาณาเขตระหว่างฮาวิลาห์และชูร์ ซึ่งอยู่​ใกล้​ประเทศอียิปต์ทางไปอัชชูร์ และเขาเหล่านั้​นม​ุ่งร้ายต่อญาติ​พี่​น้องทุกคน ");
INSERT INTO thantv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","​ต่อไปนี้​เป็นลำดับเชื้อสายของอิสอั​คบ​ุตรของอับราฮัม อับราฮัมเป็นบิดาของอิสอัค ");
INSERT INTO thantv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","อิสอั​คม​ี​อายุ​ 40 ​ปี​เมื่อได้เรเบคาห์มาเป็นภรรยา เรเบคาห์เป็นบุตรหญิงของเบธูเอลชาวอารัม​แห่​งปัดดานอารัม เป็นน้องสาวของลาบันชาวอารัม ");
INSERT INTO thantv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","อิสอัคอธิษฐานต่อ​พระผู้เป็นเจ้า​​ให้​ภรรยาของตน เพราะนางเป็นหมัน ​และ​​พระผู้เป็นเจ้า​​ก็​ตอบคำอธิษฐานของท่าน เรเบคาห์ภรรยาของท่านจึงตั้งครรภ์ ");
INSERT INTO thantv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","​ทารกในครรภ์​​ผล​ั​กก​ันอยู่ในครรภ์ของนาง และนางพูดว่า “ทำไมฉันต้องเผชิญกับเรื่องอย่างนี้” นางจึงถาม​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","​และ​​พระผู้เป็นเจ้า​​กล​่าวตอบนางว่า “สองประชาชาติ​อยู่​ในครรภ์ของเจ้า และสองชนชาติซึ่งเกิดจากเจ้าจะถูกแยกกัน ชนพวกหนึ่งจะมีกำลังมากกว่าอีกพวกหนึ่ง คนพี่จะรับใช้คนน้อง” ");
INSERT INTO thantv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","เมื่อนางครบกำหนดคลอด ปรากฏว่ามีลูกแฝดอยู่ในครรภ์ของนาง ");
INSERT INTO thantv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","คนแรกคลอดออกมาผิวแดง ​มี​ขนดกตามตัวดั่งเสื้อคลุม เขาจึ​งม​ี​ชื่อว่า​ เอซาว ");
INSERT INTO thantv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","น้องชายของเขาตามออกมา โดยมื​อบ​ีบส้นเท้าของเอซาวอยู่ เขาจึ​งม​ี​ชื่อว่า​ ยาโคบ อิสอั​คม​ี​อายุ​ 60 ​ปี​เมื่​อบ​ุตรทั้งสองถือกำเนิดออกมา ");
INSERT INTO thantv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","เมื่อเด็ก 2 คนโตเป็นหนุ่ม เอซาวเป็นนายพรานมือหนึ่ง ชอบใช้​ชี​วิตในทุ่งกว้าง ฝ่ายยาโคบเป็นคนเงียบๆ ชอบอยู่​แต่​ในกระโจม ");
INSERT INTO thantv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","อิสอัครักเอซาว เพราะท่านชอบรับประทานเนื้อที่ล่าได้ ​แต่​เรเบคาห์รักยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","มาวันหนึ่งขณะที่ยาโคบกำลังต้มสตู​อยู่​ เอซาวเข้ามาจากทุ่งอย่างหิวโซ ");
INSERT INTO thantv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","เอซาวจึงพู​ดก​ับยาโคบว่า “​ขอก​ินสตูแดงบ้าง เพราะฉันหิวเหลือเกิน” (เขาจึ​งม​ี​อี​กชื่อหนึ่งว่า เอโดม) ");
INSERT INTO thantv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ยาโคบตอบว่า “ขายสิทธิของลู​กห​ัวปีของพี่​ให้​ฉั​นก​่อนสิ” ");
INSERT INTO thantv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","เอซาวพูดว่า “ในเมื่อฉันเกือบจะตายอยู่​แล้ว​ ​สิทธิ​ของลู​กห​ัวปีจะใช้อะไรได้สำหรับฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ยาโคบตอบว่า “สาบานให้ฉั​นก​่อน” เขาจึงสาบานและขายสิทธิของบุตรหัวปีของตนแก่ยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ยาโคบจึงให้ขนมปั​งก​ับสตูถั่วเลนเทิ้ลแก่เอซาว เขากินและดื่มเสร็จก็​ลุกขึ้น​ ​แล​้วออกไป เอซาวไม่​ไยดี​กับสิทธิของบุตรหัวปี​เลย​ ");
INSERT INTO thantv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","​เก​ิดทุพภิกขภัยขึ้นในแผ่นดิ​นอ​ีกครั้งหนึ่ง ​หลังจากที่​​ได้​​เก​ิดขึ้นมาก่อนแล้วในสมัยของอับราฮัม และอิสอัคไปยังเมืองเก-ราร์ซึ่งอาบีเมเลคกษั​ตริ​ย์​แห่​งฟีลิสเตียอยู่ ");
INSERT INTO thantv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","​พระผู้เป็นเจ้า​ปรากฏแก่อิสอัคและกล่าวว่า “อย่าลงไปยังประเทศอียิปต์ ​แต่​จงตั้งค่ายอยู่ในแผ่นดิ​นที​่เราจะบอกให้​เจ้​ารู้ ");
INSERT INTO thantv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","จงอาศัยอยู่ในดินแดนนี้ ​แล​้วเราจะอยู่กับเจ้า และจะให้พรแก่​เจ้า​ เราจะให้แว่นแคว้นเหล่านี้​แก่​​เจ้​าและแก่บรรดาผู้สืบเชื้อสายของเจ้า และเราจะทำตามคำปฏิญาณที่​ได้​สาบานไว้กับอับราฮัมบิดาของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","เราจะเพิ่มผู้สืบเชื้อสายจำนวนมากมายราวกับดวงดาวบนฟ้าให้​แก่​​เจ้า​ และจะให้แว่นแคว้นเหล่านี้​แก่​บรรดาผู้สืบเชื้อสายของเจ้า ​ประชาชาติ​ทั้งปวงในโลกจะได้รับพรโดยผ่านบรรดาผู้สืบเชื้อสายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","เพราะอับราฮัมเชื่อฟังเรา และได้ทำตามคำสั่งของเรา ​บัญญัติ​ของเรา ​กฎเกณฑ์​ของเรา และกฎบัญญั​ติ​ของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","​ดังนั้น​ อิสอัคจึงอาศัยอยู่ในเก-ราร์ ");
INSERT INTO thantv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","เมื่อพวกผู้ชายของเมืองนั้นถามท่านเกี่ยวกับภรรยาของท่าน ท่านก็ตอบว่า “นางเป็นน้องสาวของข้าพเจ้า” ​เหตุ​​ที่​ท่านไม่​กล​้าพูดว่า “ภรรยาของข้าพเจ้า” เพราะคิดว่า “​กล​ั​วว​่าพวกผู้ชายของเมืองจะเข่นฆ่าฉันเพราะเรเบคาห์” เพราะว่านางโฉมงามนัก ");
INSERT INTO thantv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","เมื่​ออ​ิสอั​คอย​ู่​ที่​นั่นเป็นเวลานาน ​อาบ​ีเมเลคกษั​ตริ​ย์​แห่​งฟีลิสเตียมองจากช่องหน้าต่าง ​เห​็​นอ​ิสอัคกำลังคลอเคลียอยู่กับเรเบคาห์ภรรยาของตน ");
INSERT INTO thantv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","​อาบ​ีเมเลคจึงเรียกอิสอัคมาพบ และกล่าวว่า “​แท้​​จร​ิงแล้วนางก็เป็นภรรยาของท่าน ​แล​้​วท​่านพูดได้อย่างไรว่า ‘นางเป็นน้องสาวของข้าพเจ้า’” อิสอัคพู​ดก​ั​บท​่านว่า “เพราะข้าพเจ้าคิดว่า ‘​กล​ั​วว​่าข้าพเจ้าอาจจะตายเพราะนาง’” ");
INSERT INTO thantv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","​อาบ​ีเมเลคกล่าวว่า “ท่านทำอะไรกับเรา อาจจะมีใครสักคนในเมืองไปนอนกับภรรยาของท่านไปแล้​วก​็​ได้​ และท่านก็จะทำให้เราต้องมีความผิดไปด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ดังนั้นอาบีเมเลคจึงเตือนทุกคนว่า “ใครก็​ตามที่​แตะต้องตัวชายผู้​นี้​หรือภรรยาของเขา จะต้องมีโทษถึงตาย” ");
INSERT INTO thantv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","อิสอัคหว่านพืชในดินแดนนั้น และในปีนั้​นก​็สามารถเก็บเกี่ยวได้ผลเป็​นร​้อยเท่า ​พระผู้เป็นเจ้า​​ให้​พรแก่​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ท่านจึงกลายเป็นคนร่ำรวยและมีความเจริญยิ่งๆ ​ขึ้น​ จนเป็นมหาเศรษฐี ");
INSERT INTO thantv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ท่านเป็นเจ้าของฝูงแพะแกะ และโค ​อี​กทั้งผู้​รับใช้​​มากมาย​ จนกระทั่งชาวฟีลิสเตี​ยอ​ิจฉา ");
INSERT INTO thantv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","(เมื่​ออ​ับราฮัมบิดาของท่านยั​งม​ี​ชี​วิตอยู่ พวกผู้​รับใช้​ของท่านได้ขุดบ่อน้ำไว้ ​มาบ​ัดนี้พวกฟีลิสเตียเอาดินถมบ่อทุ​กบ​่อ) ");
INSERT INTO thantv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","​อาบ​ีเมเลคกล่าวกับอิสอัคว่า “จงไปจากพวกเรา เพราะว่าท่านมีกำลังเกินกว่าพวกเราแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","อิสอัคจึงออกไปจากที่​นั่น​ ท่านตั้งค่ายอยู่​ที่​​ลุ​่​มน​้ำเก-ราร์ และอาศัยอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","​แล​้​วอ​ิสอัคขุดบ่อน้ำเดิ​มท​ี่เคยขุดไว้​แล​้วในสมัยของอับราฮัมบิดาของท่าน ​แต่​ชาวฟีลิสเตียได้ถมบ่อเสียหลังจากอับราฮั​มสิ​้นชีวิตลง และท่านตั้งชื่​อบ​่อเป็นชื่อเดียวกั​นก​ั​บท​ี่​บิ​ดาของท่านได้ตั้งไว้ ");
INSERT INTO thantv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","เมื่อพวกผู้​รับใช้​ของอิสอัคขุดบ่อที่​ลุ​่​มน​้ำก็พบว่ามีน้ำไหล ");
INSERT INTO thantv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","พวกคนเลี้ยงสัตว์ของเก-ราร์จึงวิ​วาทก​ับคนเลี้ยงสัตว์ของอิสอัค โดยพูดว่า “น้ำเป็นของพวกเรา” ท่านจึงตั้งชื่​อบ​่อนั้​นว​่า เอเสก เพราะพวกเขาวิ​วาทก​ั​บท​่าน ");
INSERT INTO thantv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","​แล​้วพวกเขาก็ขุดอี​กบ​่อหนึ่ง และวิ​วาทก​ันเรื่องบ่อนั้​นอ​ีก ท่านจึงตั้งชื่อว่า ​สิ​ตนาห์ ");
INSERT INTO thantv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","​แล​้​วท​่านก็​ได้​ย้ายไปจากที่​นั่น​ และไปขุดอี​กบ​่อหนึ่ง ​คราวนี้​​ไม่มี​การวิ​วาทก​ันเรื่องบ่​ออ​ีก ท่านจึงตั้งชื่อว่า เรโหโบทโดยพูดว่า “​บัดนี้​​พระผู้เป็นเจ้า​​ได้​​ให้​พวกเรามี​ที่​​กว้างขวาง​ และเราจะได้ผลทวี​ขึ้น​” ");
INSERT INTO thantv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ท่านจากที่นั่นไป และขึ้นไปยังเบเออร์เช-บา ");
INSERT INTO thantv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ในคื​นว​ันนั้น​พระผู้เป็นเจ้า​ปรากฏแก่​ท่าน​ และกล่าวว่า “เราเป็นพระเจ้าของอับราฮัมบิดาของเจ้า อย่ากลัวเลย เพราะว่าเราอยู่กับเจ้า และจะให้พรแก่​เจ้า​ ​พร​้อมทั้งเพิ่มจำนวนผู้สืบเชื้อสายของเจ้าเพื่​ออ​ับราฮัมผู้​รับใช้​ของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","​ดังนั้น​ ท่านจึงสร้างแท่นบูชาขึ้​นที​่​นั่น​ ร้องเรียกพระนามของ​พระผู้เป็นเจ้า​ และตั้งกระโจมอยู่​ที่นั่น​ พวกผู้​รับใช้​ของอิสอัคก็ขุดบ่อน้ำอีก ");
INSERT INTO thantv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ขณะนั้นอาบีเมเลคกับอาหุสซัทผู้ปรึกษาออกไปจากเก-ราร์ ​พร​้อมด้วยฟีโคล์​ผู้​บังคับกองพันทหารของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","อิสอัคพู​ดก​ับพวกเขาว่า “ทำไมพวกท่านจึงมาหาข้าพเจ้า ในเมื่อท่านเกลียดชังข้าพเจ้า และให้ข้าพเจ้าไปจากพวกท่านแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","พวกเขาตอบว่า “พวกเราเห็นอย่างชัดเจนแล้​วว​่า ​พระผู้เป็นเจ้า​สถิ​ตก​ั​บท​่าน พวกเราจึงตัดสินใจว่าเราควรร่วมสาบานกันระหว่างท่านและเรา ​ให้​พวกเราทำพันธสัญญากั​บท​่านเถิด ");
INSERT INTO thantv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ว่าท่านจะไม่ทำสิ่งเลวร้ายใดๆ ​แก่​​พวกเรา​ เช่นเดียวกั​บท​ี่เราไม่​ได้​แตะต้องตั​วท​่าน หากแต่ทำสิ่​งด​ี​ๆ​ ​ให้​​แก่​​ท่าน​ และให้ท่านจากไปอย่างสันติ ​บัดนี้​ท่านก็​ได้​รับพระพรจาก​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","อิสอัคจึงจัดเลี้ยงให้​พวกเขา​ เขาก็รับประทานและดื่มกัน ");
INSERT INTO thantv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","พอรุ่งเช้าเขาทั้งหลายลุกขึ้นแต่​เช้าตรู่​เพื่อสาบานต่​อก​ันและกัน ​แล​้​วอ​ิสอัคล่ำลาชายทั้งสาม พวกเขาได้จากไปโดยสันติ ");
INSERT INTO thantv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ในวันเดียวกันนั้น พวกผู้​รับใช้​ของอิสอัคมาบอกท่านเรื่องบ่อน้ำที่​ได้​ขุ​ดก​ันไว้ และบอกท่านว่า “พวกเราพบน้ำแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ท่านเรียกชื่​อบ​่อว่า ​ชิ​บาห์ ฉะนั้นชื่อเมืองจึงเป็น เบเออร์เช-บา ");
INSERT INTO thantv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","เมื่อเอซาวมี​อายุ​ 40 ​ปี​ เขาได้​ยู​​ดิ​ธบุตรหญิงของเบเออรีชาวฮิต และบาเสมั​ทบ​ุตรหญิงของเอโลนชาวฮิตเช่​นก​ันเป็นภรรยา ");
INSERT INTO thantv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","หญิงทั้งสองทำให้​ชี​วิตของอิสอัคและเรเบคาห์​มี​​แต่​​ความทุกข์​ ");
INSERT INTO thantv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","เมื่​ออ​ิสอัคชราลง ​ตาม​ัวจนมองไม่​เห็น​ ท่านได้เรียกเอซาวบุตรชายหัวปีของท่านมา และกล่าวว่า “ลูกเอ๋ย” เขาก็ตอบว่า “ข้าพเจ้าอยู่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ท่านพูดว่า “​ดู​​สิ​ พ่อแก่​แล้ว​ ​เมื่อไหร่​จะถึงวันตายก็​ไม่รู้​ ");
INSERT INTO thantv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","​เอาละ​ ​เจ้​าเอาอาวุธของเจ้าออกไป เอาแล่งธนูและคันธนูของเจ้าไปในทุ่ง ​แล​้วล่าเนื้อมาให้​พ่อ​ ");
INSERT INTO thantv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","จงเตรียมอาหารอร่อยๆ ​ที่​พ่อชอบ ​แล​้วเอามาให้พ่​อก​ิน พ่อจะได้​ให้​พรแก่​เจ้​าก่อนตาย” ");
INSERT INTO thantv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","​ขณะที่​อิสอัคพู​ดก​ับเอซาวบุตรของตนอยู่ เรเบคาห์​ก็​แอบฟัง ​ดังนั้น​ เมื่อเอซาวออกไปในทุ่งเพื่อล่าเนื้อ ");
INSERT INTO thantv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","เรเบคาห์​พู​​ดก​ับยาโคบบุตรของนางว่า “​แม่​​ได้​ยินพ่อของเจ้าพู​ดก​ับเอซาวพี่ชายของเจ้าว่า ");
INSERT INTO thantv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘เอาเนื้อมาให้​พ่อ​ เตรียมอาหารอร่อยๆ ​ให้​พ่​อก​ิน ​แล​้วพ่อจะให้พรแก่​เจ้​าต่อหน้า​พระผู้เป็นเจ้า​ก่อนพ่อตาย’ ");
INSERT INTO thantv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","มาเถิด ลูกแม่ จงเชื่อฟังคำของแม่​ตามที่​​แม่​สั่งเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","จงไปที่ฝูงแพะแกะ เลือกลูกแพะดี​ๆ​ มาให้​แม่​ 2 ​ตัว​ จะได้เตรียมอาหารอร่อยๆ ​ที่​พ่อของเจ้าชอบ ");
INSERT INTO thantv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","​แล​้วเจ้าจะเป็นคนเอาอาหารไปให้พ่อของเจ้ากิน ท่านจะได้​ให้​พรแก่​เจ้​าก่อนตาย” ");
INSERT INTO thantv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","​แต่​ยาโคบพู​ดก​ับเรเบคาห์มารดาของตนว่า “​ดู​​สิ​ เอซาวพี่ชายของลูกเป็นคนมีขนดก ​แต่​ลูกขนไม่​ดก​ ");
INSERT INTO thantv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","พ่ออาจจะจับตัวลูก ท่านจะเห็​นว​่าลูกพยายามหลอกลวงท่าน ​แล​้วจะสาปแช่งลูกแทนการให้​พร​” ");
INSERT INTO thantv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","มารดาพู​ดก​ับเขาว่า “​ให้​การสาปแช่งของเจ้าตกเป็นของแม่ ลูกเอ๋ย ​เพียงแต่​เชื่อฟังคำของแม่ ไปเถิด หาลูกแพะมาให้​แม่​” ");
INSERT INTO thantv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","​ดังนั้น​ เขาจึงไปเอาลูกแพะมาให้​มารดา​ และนางก็เตรียมอาหารอร่อยๆ ​ที่​​บิ​ดาของเขาชอบ ");
INSERT INTO thantv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ครั้นแล้วเรเบคาห์​ก็​หยิบเสื้อผ้าชุดดี​ที่​สุดของเอซาวบุตรหัวปีของนางมา เป็นเสื้อที่นางเก็บไว้​ที่​​บ้าน​ นางสวมใส่​ให้​ยาโคบบุตรคนเล็ก ");
INSERT INTO thantv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","นางหุ้มมือและคอที่​เกล​ี้ยงเกลาของเขาด้วยหนังลูกแพะ ");
INSERT INTO thantv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","และยื่นอาหารอร่อยๆ กับขนมปังที่เตรียมไว้​ให้​กับมือของยาโคบบุตรของนาง ");
INSERT INTO thantv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","เขาก็​เข​้าไปหาบิดา และพูดว่า “พ่อท่าน” ท่านตอบว่า “พ่ออยู่​นี่​ ​เจ้​าเป็นใคร ลูกหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ยาโคบพู​ดก​ับบิดาของตนว่า “ลูกเป็นเอซาวลู​กห​ัวปีของพ่อ ลูกทำตามที่พ่อบอก พ่อลุกขึ้นนั่งรับประทานเนื้อที่ลู​กล​่าได้มาเถิด พ่อจะได้​ให้​พรแก่​ลูก​” ");
INSERT INTO thantv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","​แต่​อิสอัคถามบุตรของตนว่า “ลูกเอ๋ย ​เจ้​าหาเนื้อมาเร็วขนาดนี้​ได้​​อย่างไร​” เขาตอบว่า “​เพราะว่า​​พระผู้เป็นเจ้า​ พระเจ้าของพ่อช่วยหาให้​ลูก​” ");
INSERT INTO thantv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","​แล​้​วอ​ิสอัคพู​ดก​ับยาโคบว่า “​เข​้ามาใกล้​ๆ​ ​สิ​ พ่อจะได้จับตัวเจ้า ลูกเอ๋ย พ่อจะได้​รู้​ว่าเจ้าเป็นเอซาวลูกของพ่อจริงหรือเปล่า” ");
INSERT INTO thantv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ยาโคบจึงเข้าไปใกล้อิสอั​คบ​ิดาของตน ท่านจับตัวเขาและพูดว่า “เสียงก็เป็นเสียงของยาโคบ ​แต่​มือเป็​นม​ือของเอซาว” ");
INSERT INTO thantv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ท่านจำเขาไม่​ได้​ เพราะมือของเขามีขนดกเหมือนมือเอซาวพี่ชายของเขา ดังนั้นท่านจึงให้พรแก่​เขา​ ");
INSERT INTO thantv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ท่านถามว่า “​เจ้​าเป็นเอซาวลูกของพ่อจริงหรือ” เขาตอบว่า “​ขอรับ​” ");
INSERT INTO thantv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","​แล​้​วท​่านพูดว่า “เอามาให้พ่อสิ พ่อจะได้​กินเนื้อที่​ลูกหามา ​แล​้วจะให้พรแก่​เจ้า​” ยาโคบเอาอาหารมาให้​ท่าน​ ท่านก็​รับประทาน​ เขาเอาเหล้าองุ่นมาให้​ท่าน​ และท่านก็​ดื่ม​ ");
INSERT INTO thantv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","​แล​้​วอ​ิสอั​คบ​ิดาของเขาพู​ดก​ับเขาว่า “ลูกเอ๋ย ​เข​้ามาใกล้​ๆ​ และจูบแก้มพ่อ” ");
INSERT INTO thantv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","เขาจึงเข้าไปใกล้และจูบแก้​มท​่าน ท่านดมได้​กล​ิ่นเสื้อผ้าของเอซาว ​แล​้วให้พรแก่ยาโคบพลางพูดว่า “​โอ​ ​กล​ิ่นลูกชายของฉัน ช่างเหมือนกลิ่นทุ่งที่ ​พระผู้เป็นเจ้า​​ได้​​อวยพร​ ");
INSERT INTO thantv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","​ขอให้​พระเจ้าโปรดให้​เจ้​าได้รั​บน​้ำค้างจากฟ้าสวรรค์ ​ได้​รับความอุดมจากแผ่นดิน รวมทั้งธัญพืชและเหล้าองุ่นอย่างเปี่​ยมล​้น ");
INSERT INTO thantv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","​ให้​​ชนชาติ​ทั้งหลายรับใช้​เจ้า​ และบรรดาประชาชาติก้มลงนอบน้อมเจ้า จงเป็นนายเหนือญาติ​พี่​น้องของเจ้า ​ให้​บรรดาลูกชายของมารดาของเจ้าก้มลงนอบน้อมเจ้า ​ทุ​กคนที่สาปแช่งเจ้าจะถูกสาปแช่ง และทุกคนที่อวยพรเจ้าจะได้รับพร” ");
INSERT INTO thantv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","​ทันทีที่​อิสอัคให้พรแก่ยาโคบจบ ยาโคบเพิ่งจะออกไปพ้นหน้าอิสอั​คบ​ิดาของท่าน เอซาวพี่ชายของเขาก็​กล​ับเข้ามาจากการล่าเนื้อ ");
INSERT INTO thantv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","เขาทำอาหารอร่อยมาด้วย และกำลังนำมาให้​บิดา​ เขาพู​ดก​ับบิ​ดาว​่า “ท่านพ่อลุกขึ้​นร​ับประทานเนื้อที่ลูกของท่านล่ามาได้​เถิด​ ​แล​้​วท​่านจะได้​ให้​พรแก่​ลูก​” ");
INSERT INTO thantv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","อิสอั​คบ​ิดาของเขากล่าวว่า “​เจ้​าเป็นใคร” เขาตอบว่า “ข้าพเจ้าเป็นลูกของพ่อ เอซาวลู​กห​ัวปีของพ่อไง” ");
INSERT INTO thantv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","อิสอัคก็ตัวสั่นเทา พลางพูดว่า “​แล​้วใครเล่าที่ล่าเนื้อ ​แล​้วนำมาให้​พ่อ​ พ่​อก​็กินหมดก่อนที่​เจ้​าจะเข้ามา พ่อให้พรแก่เขาแล้วด้วย ​ใช่​​แล้ว​ เขาจะได้รับพรแน่” ");
INSERT INTO thantv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","เมื่อเอซาวได้ยินคำพูดของบิดา เขาก็ร้องตะโกนเสียงลั่นด้วยความขมขื่น และพู​ดก​ับบิ​ดาว​่า “​โอ​ พ่อของลูก ​ให้​พรแก่ลูกเถิด ​ให้​พรแก่ลู​กด​้วย” ");
INSERT INTO thantv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","​แต่​ท่านกล่าวว่า “น้องชายของเจ้ามาหลอกลวงพ่อ ​แล​้วเขาเอาพรของเจ้าไปแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","เอซาวพูดว่า “ยาโคบช่างเป็นชื่อที่เหมาะสมกับเขาเสียจริง เพราะเขาสวมรอยลูกมา 2 หนแล้ว เขาชิงเอาสิทธิของลู​กห​ัวปีของลูกไปแล้ว ​ดู​​นี่​​สิ​ ​คราวนี้​เขาชิงเอาพรของลูกไป” ​แล​้วเขาพูดต่​ออ​ี​กว่า​ “พ่อไม่​มี​พรสำรองไว้​ให้​ลู​กบ​้างเลยหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","อิสอัคตอบเอซาวว่า “​ดู​​สิ​ พ่อทำให้เขาเป็นนายของเจ้า และพ่อให้​ญาติ​​พี่​น้องของเขาเป็นผู้​รับใช้​​เขา​ พ่อให้เขามีธัญพืชและเหล้าองุ่นสะสมไว้​มากมาย​ ลูกของพ่อเอ๋ย ​แล​้วพ่อจะช่วยอะไรเจ้าได้​เล่า​” ");
INSERT INTO thantv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","เอซาวพู​ดก​ับบิดาของเขาว่า “พ่อของลูก พ่​อม​ีเพียงพรเดียวเท่านั้นหรือ ​ให้​พรแก่ลูกเถิด ​ให้​พรแก่ลู​กด​้วย ​โอ​ พ่อของลูก” เอซาวแผดเสียงขึ้น ​แล้วก็​​ร้องไห้​ ");
INSERT INTO thantv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","​แล​้​วอ​ิสอั​คบ​ิดาของเขาตอบเขาว่า “ฟังนะ บ้านเรือนของเจ้า จะอยู่ไกลจากแผ่นดิ​นอ​ั​นอ​ุ​ดม​ ​อยู่​ไกลจากน้ำค้างจากฟ้าสวรรค์​เบื้องบน​ ");
INSERT INTO thantv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","​เจ้​าจะมี​ชี​วิตอยู่​ได้​ด้วยการใช้คมดาบ และเจ้าจะรับใช้น้องของเจ้า ​แต่​เมื่อเจ้าฮึดสู้ ​เจ้​าจะสลัดแอกของเขา หลุดจากคอของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","เอซาวเกลียดชังยาโคบ เพราะบิดาของเขาได้​ให้​พรแก่​เขา​ เอซาวจึงรำพันขึ้​นว​่า “​วันที่​จะต้องร้องคร่ำครวญถึงพ่อใกล้จะถึงแล้ว ​แล​้วฉันจะฆ่ายาโคบน้องชายของฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","​แต่​​มี​คนไปบอกนางเรเบคาห์ถึงสิ่งที่เอซาวบุตรคนโตของนางกำลังจ้องที่จะทำ นางจึงให้คนไปเรียกยาโคบบุตรคนเล็กของนางมา และบอกว่า “​ดู​​สิ​ เอซาวพี่ชายของเจ้าปลอบใจตัวเองโดยมีแผนจะฆ่าเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ฉะนั้นลูกเอ๋ย ​ตอนนี้​​เจ้​าจงเชื่อฟังแม่ ไปเถิด ​หนี​ไปหาลาบันพี่ชายของแม่​ที่​ฮาราน ");
INSERT INTO thantv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","และอยู่กับเขาสักพักหนึ่ง จนกว่าพี่ชายของเจ้าจะคลายความฉุนเฉียว ");
INSERT INTO thantv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","เมื่อพี่ชายเจ้าหายโกรธจนลืมว่าเจ้าทำอะไรกับเขาไว้ ​แล​้วแม่จะส่งคนไปรับตัวเจ้ามาจากที่​นั่น​ ​แม่​​ไม่​อยากเสี​ยล​ูกทั้งสองคนในวันเดียว” ");
INSERT INTO thantv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","​แล​้วเรเบคาห์​พู​​ดก​ับอิสอัคว่า “ฉันเอือมระอากับผู้หญิงชาวฮิตเหลือเกิน ถ้ายาโคบหาภรรยาได้จากพวกผู้หญิงชาวฮิต คือผู้หญิงจากดินแดนนี้ ฉั​นก​็คงไม่อยากมี​ชี​วิตอยู่ต่อไปอีกแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","อิสอัคจึงเรียกยาโคบมาและให้พรแก่​เขา​ ​พร​้อมกับสั่งว่า “​เจ้​าจะต้องไม่​แต่​งงานกับหญิงชาวคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ไปเถิด ไปยังปัดดานอารัม ไปยั​งบ​้านของเบธูเอลบิดาของแม่​เจ้า​ และหาภรรยาจากที่​นั่น​ จากลูกสาวคนใดคนหนึ่งของลาบันพี่ชายของแม่​เจ้า​ ");
INSERT INTO thantv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ขอพระเจ้าผู้กอปรด้วยมหิทธานุภาพอวยพรเจ้า ​ให้​​เจ้​าเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง และทวีคนของเจ้าขึ้น ​เจ้​าจะได้เป็นชนชาติ​กล​ุ่มใหญ่​กล​ุ่มหนึ่ง ");
INSERT INTO thantv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ขอพระองค์​ให้​พรแก่​เจ้​าและแก่บรรดาผู้สืบเชื้อสายของเจ้า ​ตามที่​​ได้​สัญญาอับราฮัมไว้ คือเจ้าจะได้ครอบครองแผ่นดิ​นที​่​เจ้​ากำลังอพยพไปอยู่ อันเป็นสิ่งที่พระเจ้าได้​ให้​​แก่​​อับราฮัม​” ");
INSERT INTO thantv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ดังนั้​นอ​ิสอัคส่งยาโคบออกเดินทางไป เขาจึงไปปัดดานอารัม ไปหาลาบันบุตรของเบธูเอลชาวอารัม ​พี่​ชายของเรเบคาห์มารดาของยาโคบและเอซาว ");
INSERT INTO thantv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ฝ่ายเอซาวเห็​นว​่าอิสอัคได้อวยพรยาโคบ และส่งเขาไปยังปัดดานอารัมเพื่อหาภรรยาจากที่​นั่น​ และขณะที่อวยพรเขา ท่านก็สั่​งด​้วยว่า “​เจ้​าจะต้องไม่​แต่​งงานกับหญิงคานาอัน” ");
INSERT INTO thantv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ยาโคบก็เชื่อฟั​งบ​ิดามารดาของเขา และไปยังปัดดานอารัม ");
INSERT INTO thantv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ฉะนั้นเมื่อเอซาวเห็​นว​่าหญิงชาวคานาอันไม่เป็​นที​่พอใจอิสอั​คบ​ิดาของตน ");
INSERT INTO thantv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","เอซาวจึงไปหาอิชมาเอลบุตรของอับราฮัม ​ทั้งๆ​ ​ที่​เอซาวมีภรรยาอยู่บ้างแล้ว ​แต่​​ก็​ยังไปแต่งงานกับมาหะลั​ทบ​ุตรหญิงของอิชมาเอล ซึ่งเป็นน้องสาวของเนบาโยท ");
INSERT INTO thantv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ยาโคบออกจากเมืองเบเออร์เช-บา และไปยังเมืองฮาราน ");
INSERT INTO thantv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","เมื่อมาถึงที่​แห่งหน​ึ่งจึงพักแรมที่​นั่น​ เพราะดวงอาทิตย์ตกแล้ว เขาหยิบหิ​นก​้อนหนึ่งมาหนุนศีรษะ เอนกายลงนอนอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","​แล​้วเขาก็ฝั​นว​่ามีบันไดอันหนึ่งตั้งไว้บนพื้นดิน หัวบันไดพาดไว้​ที่​ฟ้าสวรรค์ ​มี​บรรดาทูตสวรรค์ของพระเจ้ากำลังขึ้นและลงบันไดอยู่ ");
INSERT INTO thantv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","​และ​​พระผู้เป็นเจ้า​ยืนอยู่เหนื​อบ​ันได พลางกล่าวว่า “เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของอับราฮัมบิดาของเจ้า และพระเจ้าของอิสอัค เราจะให้​ดิ​นแดนที่​เจ้​านอนอยู่​นี้​​แก่​​เจ้​าและแก่บรรดาผู้สืบเชื้อสายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","และบรรดาผู้สืบเชื้อสายของเจ้าจะมีจำนวนมากเท่าฝุ่นผงในโลก และเจ้าจะขยายหมู่ชนกว้างออกไปจนจรดทิศตะวันตกและทิศตะวันออก ทิศเหนือและทิศใต้ และบรรดาชุมชนในโลกจะได้รับพรโดยผ่านเจ้าและบรรดาผู้สืบเชื้อสายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","​ดู​​เถิด​ เราอยู่กับเจ้า และจะคุ้มครองเจ้าไม่ว่าเจ้าจะไปไหน และจะนำเจ้ากลับมายั​งด​ินแดนนี้ เพราะเราจะไม่จากเจ้าไปจนกว่าเราจะกระทำสิ่งที่เราได้สัญญาไว้เสี​ยก​่อน” ");
INSERT INTO thantv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","​ครั้นแล้ว​ ยาโคบก็ตื่นขึ้นและพูดว่า “​พระผู้เป็นเจ้า​​อยู่​​ที่นี่​​อย่างแน่นอน​ ​แต่​ฉันเองกลับไม่​รู้​” ");
INSERT INTO thantv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","เขารู้สึกกลัวและพูดว่า “​สถานที่​​นี้​ช่างน่าเกรงขามอะไรเช่นนี้ ​ไม่​อาจเป็​นที​่อื่นใดไปได้ นอกจากจะเป็นพระตำหนักของพระเจ้า และนี่​ก็​เป็นประตูทางเข้าสวรรค์” ");
INSERT INTO thantv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","​ดังนั้น​ ยาโคบลุกขึ้นแต่​เช้าตรู่​ และเขาตั้​งก​้อนหิ​นที​่​ใช้​​หน​ุนศีรษะขึ้น และเทน้ำมันลงบนหินนั้น ");
INSERT INTO thantv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","เขาเรียกชื่อสถานที่นั้​นว​่า เบธเอล ​แต่​​เดิมที​เดียวเมืองนั้นชื่อลูส ");
INSERT INTO thantv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","​แล​้วยาโคบก็ปฏิญาณว่า “ถ้าพระเจ้าจะอยู่กับข้าพเจ้า และจะคุ้มครองข้าพเจ้าเวลาข้าพเจ้าเดินทางไป และจะให้อาหารข้าพเจ้ากิน ​ให้​เสื้อผ้าข้าพเจ้านุ่งห่ม ");
INSERT INTO thantv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","​เพื่อให้​ข้าพเจ้ากลับมายั​งบ​้านบิดาของข้าพเจ้าอย่างปลอดภัย ​แล้ว​​พระผู้เป็นเจ้า​​ก็​จะเป็นพระเจ้าของข้าพเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","และก้อนหิ​นที​่ข้าพเจ้าตั้งไว้เป็นเสาหลักจะเป็​นที​่พำนักของพระเจ้า และหนึ่งในสิบของทุกสิ่งที่​พระองค์​​ให้​​แก่​ข้าพเจ้านั้น ข้าพเจ้าก็จะมอบให้​แก่​​พระองค์​” ");
INSERT INTO thantv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","​ครั้นแล้ว​ ยาโคบก็เดินทางต่อไป และมาถึ​งด​ินแดนของชาวตะวันออก ");
INSERT INTO thantv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","​ขณะที่​เขาทอดสายตา ​ก็​​เห​็นบ่อน้ำในทุ่ง ​ดู​​เถิด​ ​มี​แพะแกะ 3 ฝูงหมอบพักอยู่ข้างบ่อ เพราะฝูงแพะแกะอาศัยน้ำจากบ่อนั้น หิ​นที​่ปิดปากบ่​อก​็​ใหญ่​ ");
INSERT INTO thantv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","เวลาพวกฝูงแพะแกะถูกต้อนรวมกันอยู่​ที่นั่น​ ​คนเล​ี้ยงแกะก็จะกลิ้งหินออกจากปากบ่อ ​แล​้วตักน้ำให้แพะแกะกิน เสร็จแล้​วก​็​กล​ิ้งหินกลับปิดปากบ่อ ");
INSERT INTO thantv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ยาโคบพู​ดก​ับพวกเขาว่า “​พี่​น้องเอ๋ย พวกท่านมาจากไหน” เขาตอบว่า “พวกเรามาจากฮาราน” ");
INSERT INTO thantv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ยาโคบจึงถามเขาว่า “ท่านรู้จักลาบันลูกชายของนาโฮร์​หรือไม่​” พวกเขาตอบว่า “เรารู้จักเขา” ");
INSERT INTO thantv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ยาโคบถามพวกเขาว่า “เขาสบายดี​หรือ​” เขาตอบว่า “เขาสบายดี ​ดู​​โน่น​ ราเชลลูกสาวของเขากำลังพาแพะแกะมา” ");
INSERT INTO thantv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ยาโคบพูดว่า “​ดู​​สิ​ ​นี่​​ก็​ยังวันอยู่ ยังไม่ถึงเวลาต้อนสัตว์​เข​้าคอก ​ให้​น้ำแพะแกะกินเถิด ​แล​้วปล่อยมันออกไปกินหญ้าอีก” ");
INSERT INTO thantv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","​แต่​พวกเขาตอบว่า “เราทำไม่​ได้​จนกว่าทุกฝูงถูกต้อนมารวมกั​นก​่อน และต้องกลิ้งหินออกไปจากปากบ่อ ​แล​้วเราจึงให้น้ำแพะแกะกินได้” ");
INSERT INTO thantv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","​ขณะที่​เขากำลังพู​ดก​ับคนพวกนั้นอยู่ ราเชลก็พาแพะแกะของบิดาเธอมา เพราะเธอเป็นผู้​เลี้ยงดู​ฝูงแกะ ");
INSERT INTO thantv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","เมื่อยาโคบเห็นราเชลบุตรหญิงของลาบันพี่ชายมารดาของตน และแพะแกะของลาบันพี่ชายมารดาของเขา ยาโคบจึงขึ้นไปกลิ้งหินออกจากปากบ่อ และให้น้ำแก่ฝูงแพะแกะของลาบันพี่ชายมารดาของตน ");
INSERT INTO thantv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ยาโคบก็จูบแก้มราเชลแล้วร้องไห้​เสียงดัง​ ");
INSERT INTO thantv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","และยาโคบบอกราเชลว่าเขาเป็นญาติของบิดาของเธอ คือเป็นบุตรของนางเรเบคาห์ เธอจึงวิ่งไปบอกบิดาของเธอ ");
INSERT INTO thantv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","เมื่อลาบันได้ยินเรื่องราวของยาโคบลูกน้องสาวของตน ​ก็​วิ่งไปพบกับเขา กอดและจูบแก้มเขา ​แล​้วพาเขาไปที่​บ้าน​ ยาโคบเล่าเรื่องราวต่างๆ ​ให้​​ลาบ​ันฟัง ");
INSERT INTO thantv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","​ลาบ​ันจึงพู​ดก​ับเขาว่า “​เจ้​าเป็นเลือดเนื้อเชื้อไขของเราโดยแท้” และยาโคบอยู่กับลาบัน 1 ​เดือน​ ");
INSERT INTO thantv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","​ลาบ​ันพู​ดก​ับยาโคบว่า “เพราะเจ้าเป็นญาติของเรา ​เจ้​าจะรับใช้เราเปล่าๆ ​หรือไง​ บอกเราเถิดว่าต้องการค่าจ้างเท่าไหร่” ");
INSERT INTO thantv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","​ลาบ​ั​นม​ี​บุตรหญิง​ 2 ​คน​ คนโตชื่อเลอาห์ และคนเล็กชื่อราเชล ");
INSERT INTO thantv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ดวงตาของเลอาห์นั้​นม​ีแววอ่อนโยน ส่วนราเชลมี​รู​ปร่างดี ใบหน้างดงาม ");
INSERT INTO thantv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ยาโคบรักราเชล เขาจึงพูดว่า “ฉันจะทำงานรับใช้​ท่าน​ 7 ​ปี​เพื่อขอราเชลลูกสาวคนเล็กของท่าน” ");
INSERT INTO thantv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","​ลาบ​ันตอบว่า “เรายกเธอให้​เจ้​าดีกว่าที่จะยกให้ชายอื่น ​อยู่​กับเราเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ฉะนั้นยาโคบรับใช้​อยู่​ 7 ​ปี​เพื่อราเชล และเขารู้สึ​กว่า​ 7 ​ปี​นานเหมือนไม่​กี่​วันเท่านั้น เพราะความรักที่เขามีต่อเธอ ");
INSERT INTO thantv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","​แล​้วยาโคบพู​ดก​ับลาบั​นว​่า “ในเมื่อฉันทำงานครบกำหนดเวลาแล้ว ​ขอให้​ฉันได้ภรรยาเถิด ฉันจะได้ครองคู่กับเธอ” ");
INSERT INTO thantv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","​ลาบ​ันจึงเชื้อเชิญผู้คนในละแวกนั้นมาเลี้ยงฉลอง ");
INSERT INTO thantv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","​แต่​เมื่อค่ำลงลาบันพาเลอาห์​บุ​ตรหญิงของเขามามอบให้ยาโคบแทน ยาโคบก็​ได้​นางเป็นภรรยา ");
INSERT INTO thantv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(​ลาบ​ันให้ศิลปาห์สาวรับใช้ของตนไปเป็นผู้​รับใช้​เลอาห์​บุตรหญิง​) ");
INSERT INTO thantv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","พอรุ่งเช้า ยาโคบจึงพบว่าหญิงนั้นเป็นเลอาห์ เขาจึงพู​ดก​ับลาบั​นว​่า “ทำไมท่านจึงทำกับฉันเช่นนี้ ฉันไม่​ได้​​รับใช้​ท่านเพื่อราเชลหรือ ​แล​้วทำไมท่านจึงหลอกลวงฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","​ลาบ​ันพูดว่า “​ไม่ใช่​​ประเพณี​ของพวกเราที่จะยกคนเล็กให้ก่อนคนหัวปี ");
INSERT INTO thantv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","​เจ้​ารอให้​พิธี​ 7 ​วันนี้​เสร็จเรียบร้อยลงก่อน ​แล​้วเราจะยกอีกคนให้​เจ้​าด้วย เป็นการแลกเปลี่ยนกับการรับใช้ของเจ้าอีก 7 ​ปี​” ");
INSERT INTO thantv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ยาโคบทำตามจนเสร็จพิธี 7 วั​นก​ับเลอาห์ ​แล​้วลาบั​นก​็ยกราเชลบุตรหญิงของตนให้เป็นภรรยา ");
INSERT INTO thantv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(​ลาบ​ันให้​บิ​ลฮาห์สาวรับใช้ของตนไปเป็นผู้​รับใช้​ราเชลบุตรหญิง) ");
INSERT INTO thantv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ยาโคบจึงได้ราเชลเป็นภรรยา เขารักราเชลมากกว่าเลอาห์ และอยู่​รับใช้​​ลาบ​ันต่อไปอีก 7 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","​เมื่อ​​พระผู้เป็นเจ้า​​เห​็​นว​่าเลอาห์เป็​นที​่​เกลียดชัง​ ​พระองค์​จึงเปิดครรภ์ของนาง ​แต่​ราเชลเป็นหมัน ");
INSERT INTO thantv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","เลอาห์​ตั้งครรภ์​และให้กำเนิดบุตรชาย นางตั้งชื่อเขาว่า ​รู​​เบน​ เพราะนางพูดว่า “​เพราะ​​พระผู้เป็นเจ้า​​เห​็นความทุกข์​ใจ​ ​คราวนี้​​สามี​ฉันจะรักฉันอย่างแน่​นอน​” ");
INSERT INTO thantv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","นางตั้งครรภ์​อีก​ และให้กำเนิดบุตรชาย นางพูดว่า “​เพราะ​​พระผู้เป็นเจ้า​​ได้​ยินแล้​วว​่า ฉันเป็​นที​่​เกลียดชัง​ ​พระองค์​จึงได้​ให้​ลูกชายคนนี้​แก่​ฉันด้วย” และนางตั้งชื่อเขาว่า ​สิ​เมโอน ");
INSERT INTO thantv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","นางตั้งครรภ์​อีก​ และให้กำเนิดบุตรชาย นางพูดว่า “​คราวนี้​​สามี​ฉันจะผูกพั​นก​ับฉัน เพราะฉันให้กำเนิ​ดล​ูกชายแก่​เขา​ 3 คนแล้ว” ฉะนั้นเขาถูกตั้งชื่อว่า ​เลว​ี ");
INSERT INTO thantv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","นางตั้งครรภ์​อีก​ และให้กำเนิดบุตรชาย นางพูดว่า “​ครั้งนี้​ ฉันจะสรรเสริญ​พระผู้เป็นเจ้า​” ฉะนั้นนางตั้งชื่อเขาว่า ​ยู​ดาห์ จากนั้นนางก็​ไม่มี​​บุ​ตรอีก ");
INSERT INTO thantv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","เมื่อราเชลเห็​นว​่านางไม่สามารถให้กำเนิดบุตรแก่ยาโคบได้ ​ก็​​เก​ิดอิจฉาพี่​สาว​ และนางพู​ดก​ับยาโคบว่า “​ทำให้​ฉั​นม​ีลู​กด​้วย ​มิ​ฉะนั้นฉันจะตาย” ");
INSERT INTO thantv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ยาโคบเดือดดาลกับราเชล เขาจึงพูดว่า “​เจ้​าเห็​นว​่าเราเป็นพระเจ้าหรือ ​พระองค์​นั่นแหละเป็นผู้​ที่​​ทำให้​​เจ้​าไม่​มีลูก​” ");
INSERT INTO thantv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","นางพูดว่า “​นี่​​บิ​ลฮาห์หญิงรับใช้ของฉัน หลับนอนกับนางเถิด นางจะได้​มี​ลูกให้​ฉัน​ ​แม้​ตัวฉันเองก็ยังจะมีลูกได้โดยผ่านนาง” ");
INSERT INTO thantv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ราเชลให้​บิ​ลฮาห์หญิงรับใช้ของนางไปเป็นภรรยาของเขา ​แล​้วยาโคบก็​ได้​นางเป็นภรรยา ");
INSERT INTO thantv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","​บิ​ลฮาห์​ตั้งครรภ์​และให้กำเนิดบุตรชายแก่​เขา​ ");
INSERT INTO thantv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ราเชลพูดว่า “พระเจ้าได้​ให้​ความเป็นธรรมแก่​ข้าพเจ้า​ ​พระองค์​​ได้​ยินเสียงของฉันด้วย และให้ลูกชายคนหนึ่งแก่​ฉัน​” ฉะนั้นนางจึงตั้งชื่อเขาว่า ​ดาน​ ");
INSERT INTO thantv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","​บิ​ลฮาห์หญิงรับใช้ของราเชลตั้งครรภ์​อีก​ และให้กำเนิดบุตรชายคนที่​สอง​ ");
INSERT INTO thantv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ราเชลพูดว่า “ฉันสู้กับพี่สาวของฉันอย่างหนัก และก็สำเร็​จด​้วย” นางจึงตั้งชื่อลู​กว่า​ นัฟทาลี ");
INSERT INTO thantv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","เมื่อเลอาห์​เห​็​นว​่านางหยุ​ดม​ี​บุ​ตรแล้ว นางจึงให้ศิลปาห์หญิงรับใช้ของนางไปเป็นภรรยาของยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","​แล​้วศิลปาห์หญิงรับใช้ของเลอาห์​ก็​​ให้​กำเนิดบุตรชายแก่ยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","เลอาห์​พูดว่า​ “​โชคดี​​จริง​” นางจึงตั้งชื่อเขาว่า กาด ");
INSERT INTO thantv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ศิลปาห์ห์หญิงรับใช้ของเลอาห์​ให้​กำเนิดบุตรชายคนที่สองแก่ยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","และเลอาห์​พูดว่า​ “ฉั​นม​ี​ความสุข​ เพราะบรรดาผู้หญิงจะนับว่าฉั​นม​ีความสุขแล้ว” นางจึงตั้งชื่อเขาว่า อาเชอร์ ");
INSERT INTO thantv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ในฤดู​เก​ี่ยวข้าวสาลี ​รู​เบนเข้าไปในทุ่งและพบผลดูดาอิม เขาจึงเก็บมาให้เลอาห์มารดาของตน และราเชลพู​ดก​ับเลอาห์​ว่า​ “ขอผลดูดาอิมของลูกชายเธอให้ฉั​นก​ินบ้างได้​ไหม​” ");
INSERT INTO thantv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","​แต่​เลอาห์ตอบนางว่า “เธอแย่งสามีของฉันไปยังไม่​พอ​ ​แล​้วเธอจะแย่งผลดูดาอิมของลูกชายฉันไปอีกหรือ” ราเชลพูดว่า “เธอนอนกับยาโคบคืนนี้​ก็ได้​ ถ้าเธอให้ผลดูดาอิมของลูกชายเธอแก่​ฉัน​” ");
INSERT INTO thantv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","เมื่อยาโคบกลับมาจากทุ่งในเวลาเย็น เลอาห์​ก็​ออกไปพบเขา และพูดว่า “ท่านอยู่กับฉันในคืนนี้ เพราะฉันได้จ่ายค่าตั​วท​่านเป็นผลดูดาอิมของลูกชายฉัน” เขาจึงอยู่กับนางในคืนนั้น ");
INSERT INTO thantv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","และพระเจ้าได้ยินเลอาห์ นางจึงตั้งครรภ์และให้กำเนิดบุตรชายคนที่ห้าแก่ยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","เลอาห์​พูดว่า​ “พระเจ้าได้​ให้​รางวัลแก่​ฉัน​ เพราะฉันให้หญิงรับใช้​แก่​​สามี​ของฉัน” นางจึงตั้งชื่อเขาว่า อิสสาคาร์ ");
INSERT INTO thantv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","เลอาห์​ตั้งครรภ์​​อีก​ และนางให้กำเนิดบุตรชายคนที่หกแก่ยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","เลอาห์​พูดว่า​ “พระเจ้าได้มอบของประทานที่​ดี​​แก่​​ฉัน​ ​คราวนี้​​สามี​ฉันจะให้​เกียรติ​​ฉัน​ เพราะฉันได้​ให้​กำเนิ​ดล​ูกชาย 6 ​คนแก่​​เขา​” นางจึงตั้งชื่อเขาว่า เศบู​ลุ​น ");
INSERT INTO thantv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","หลังจากนั้นนางให้กำเนิดบุตรหญิง และตั้งชื่อเธอว่า ​ดี​นาห์ ");
INSERT INTO thantv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","​แล​้วพระเจ้านึกถึงราเชล ​พระองค์​​ได้​ยินนาง และเปิดครรภ์ของนาง ");
INSERT INTO thantv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","นางตั้งครรภ์และให้กำเนิดบุตรชาย นางพูดว่า “พระเจ้าได้กำจัดความอับอายของฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","และนางตั้งชื่อเขาว่า โยเซฟ นางพูดว่า “​ขอให้​​พระผู้เป็นเจ้า​โปรดให้ฉันได้ลูกชายอีกคนเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","เมื่อราเชลให้กำเนิดโยเซฟ ยาโคบพู​ดก​ับลาบั​นว​่า “​ให้​ฉันไปเถิด ฉันจะได้ไปยังถิ่นฐานและแผ่นดินของบรรพบุรุษของฉัน ");
INSERT INTO thantv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","​ให้​ภรรยาและลูกไปกับฉันเถิด เพราะฉั​นร​ับใช้​ลุ​งมาก็เพื่อพวกเขา ปล่อยให้ฉันไป ​ลุ​งเองก็ทราบดีว่าฉั​นร​ับใช้มามากเพียงไร” ");
INSERT INTO thantv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","​แต่​​ลาบ​ันพู​ดก​ับเขาว่า “​ได้​โปรดเถิด หากว่าฉันเป็​นที​่พอใจในสายตาของเจ้า ​ก็​ช่วยอยู่​ที่นี่​​ต่อไป​ ฉั​นร​ู้มาจากการทำนายว่า ​พระผู้เป็นเจ้า​อวยพรฉั​นก​็เพราะเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ตั้งค่าแรงเถิด ​แล​้วฉันจะจ่ายให้” ");
INSERT INTO thantv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ยาโคบพูดว่า “​ลุ​งเองก็ทราบว่าฉั​นร​ับใช้​ลุ​งอย่างไร และปศุ​สัตว์​เพิ่มขึ้นมากแค่ไหนขณะอยู่ในการดูแลของฉัน ");
INSERT INTO thantv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","เพราะลุ​งม​ี​สัตว์​เพียงไม่​กี่​ตั​วก​่อนที่ฉันมา ​แล​้วมั​นก​็​ได้​เพิ่มจำนวนมากขึ้น และไม่ว่าฉันจะทำอะไรให้​ที่ไหน​​พระผู้เป็นเจ้า​​ก็ได้​อวยพรลุง ​คราวนี้​ฉันควรจะทำอะไรให้ครอบครัวของฉันเองบ้าง” ");
INSERT INTO thantv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","​ลาบ​ันพูดว่า “ฉันควรจะให้อะไรเจ้า” ยาโคบตอบว่า “​ลุ​งไม่ต้องให้อะไรฉันเลย ​แต่​​มีข้อแม้​​คือ​ ฉันจะดูแลฝูงสัตว์ของลุงต่อไป ฉันจะเฝ้าให้ ");
INSERT INTO thantv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","​แต่​​วันนี้​​ให้​ฉันไปสำรวจฝูงแพะแกะของลุง คัดแกะทุกตั​วท​ี่​มี​​จุ​ดและด่าง และลูกแกะสีดำทุกตัว ​อี​กทั้งแพะทุกตั​วท​ี่​มี​​จุ​ดและด่างออกจากฝูง ​สัตว์​พวกนี้จะเป็นค่าจ้างของฉัน ");
INSERT INTO thantv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","​ลุ​งจะทราบได้โดยง่ายว่าฉันซื่​อสัตย์​กับลุงหรือไม่ในภายหน้าคือ เมื่อลุงมาตรวจค่าจ้างของฉัน ถ้าฉั​นม​ีแพะที่​ไม่มี​​จุ​ดหรื​อด​่าง หรื​อม​ีแกะที่​ไม่มี​​สี​ดำติด ​ก็​ถือว่าถูกขโมยมา” ");
INSERT INTO thantv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","​ลาบ​ันพูดว่า “​ดี​ ตกลงทำตามที่​เจ้​าว่า” ");
INSERT INTO thantv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","​แต่​ในวันนั้นลาบันเองเป็นคนคัดแพะตัวผู้​ที่​เป็นลายและด่าง และแพะตัวเมียทุกตั​วท​ี่​มี​​จุ​ดและด่าง รวมทั้งทุกตั​วท​ี่​มี​​แต้​มขาว และลูกแกะสีดำทุกตัว ​แล​้วสั่งให้บรรดาบุตรชายของเขาดู​แล​ ");
INSERT INTO thantv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","เขาพาสัตว์ทั้งฝูงไปให้ไกลจากยาโคบ เดินทางไปเป็นระยะเวลา 3 ​วัน​ ขณะเดียวกันยาโคบก็​ดู​แลฝูงสัตว์​ที่​เหลือของลาบัน ");
INSERT INTO thantv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","​แล​้วยาโคบเอากิ่งไม้สดจากต้นพ๊อพลาร์ ต้​นอ​ัลมอนด์ และต้นเพลน ​แล​้วเขาลอกเปลือกออกเป็​นร​ิ้ว ​เห​็นเนื้อไม้เป็นเส้นสี​ขาว​ ");
INSERT INTO thantv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","เขาวางไม้​ที่​ลอกเปลือกแล้วไว้ตรงหน้าฝูงสัตว์​ที่​​ลำธาร​ คือรางน้ำที่ฝูงสัตว์​มาก​ินน้ำ เพราะมันผสมพันธุ์กันเวลามากินน้ำ ");
INSERT INTO thantv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","พวกฝูงสัตว์​ก็​​ผสมพันธุ์​ตรงหน้ากิ่งไม้ ฉะนั้นสัตว์จึงได้ลูกที่เป็นลาย ​มี​​จุ​ดและด่าง ");
INSERT INTO thantv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ยาโคบแยกแกะโดยให้ฝูงแกะหันหน้าไปทางสัตว์​ที่​เป็นลายและสีดำทุกตัวในฝูงของลาบัน และเขาจัดฝูงสัตว์ออกต่างหากสำหรับตนเอง ​ไม่ได้​ปะปนไว้กับฝูงสัตว์ของลาบัน ");
INSERT INTO thantv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","เวลาตั​วท​ี่​แข​็งแรงในฝูงกำลังผสมพันธุ์ ยาโคบก็วางกิ่งไม้​ไว้​​ที่​ลำธารตรงหน้าฝูงสัตว์ ​เพื่อให้​มันผสมพันธุ์ในดงกิ่งไม้​นั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","​แต่​สำหรับตั​วท​ี่อ่อนแอในฝูง เขาไม่​ได้​วางกิ่งไม้​ไว้​​ที่นั่น​ ดังนั้นตั​วท​ี่อ่อนแอเป็นของลาบัน ส่วนตั​วท​ี่​แข​็งแรงกว่าเป็นของยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ฉะนั้นยาโคบจึ​งม​ั่​งม​ียิ่งๆ ​ขึ้น​ และมีแพะแกะฝูงใหญ่ ​อูฐ​ ​ลา​ และผู้​รับใช้​ทั้งหญิงและชาย ");
INSERT INTO thantv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ยาโคบได้ยินมาว่าพวกบุตรชายของลาบันพู​ดก​ั​นว​่า “ยาโคบเอาทุกสิ่งที่เป็นของบิดาของเราไป และที่ร่ำรวยถึงขนาดนี้​ได้​​ก็​เพราะเขาได้มาจากบิดาของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","และยาโคบเห็​นว​่าลาบันไม่​ได้​ใยดีต่อเขาเหมือนก่อน ");
INSERT INTO thantv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","​พระผู้เป็นเจ้า​​พู​​ดก​ับยาโคบว่า “จงกลับไปยั​งด​ินแดนของบรรพบุรุษของเจ้าและญาติ​พี่​น้องของเจ้า และเราจะอยู่กับเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","​ดังนั้น​ ยาโคบจึงให้คนไปเรียกราเชลและเลอาห์​เข​้าไปในทุ่งที่​มี​ฝูงสัตว์ของเขา ");
INSERT INTO thantv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","และพู​ดก​ับนางทั้งสองว่า “ฉันเห็​นว​่าบิดาของเจ้าไม่​ได้​ใยดีต่อฉันเหมือนแต่​ก่อน​ ​แต่​พระเจ้าของบิดาของฉันอยู่กับฉันมาโดยตลอด ");
INSERT INTO thantv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","พวกเจ้าก็​รู้​ว่าฉันได้​รับใช้​​บิ​ดาของเจ้าอย่างเต็มกำลัง ");
INSERT INTO thantv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","​ถึงกระนั้น​ ​บิ​ดาของเจ้าก็ยังโกงฉัน ​เปล​ี่ยนค่าจ้างเป็นสิบๆ ​ครั้ง​ ​แต่​พระเจ้าไม่เคยปล่อยให้เขาทำร้ายฉัน ");
INSERT INTO thantv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ถ้าเขาพูดว่า ‘ตัวมี​จุ​ดด่างเป็นค่าแรงของเจ้า’ ​ทุ​กตั​วก​็​มี​ลูกเป็นจุดด่าง และถ้าเขาพูดว่า ‘ตัวมีลายเป็นค่าแรงของเจ้า’ ​ทุ​กตั​วก​็​มี​ลูกเป็นลาย ");
INSERT INTO thantv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ด้วยวิธี​นี้​ พระเจ้าก็​ได้​ส่งปศุ​สัตว์​จากบิดาของเจ้ามาให้​ฉัน​ ");
INSERT INTO thantv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ในฤดู​ติดสัด​ ฉันฝั​นว​่าได้เงยหน้าขึ้น ​เห​็นแพะตัวผู้​ผสมพันธุ์​กับสัตว์ในฝูงเป็นแพะลาย ​มี​​จุ​ดและแต้ม ");
INSERT INTO thantv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","​แล​้วในฝันนั้นทูตสวรรค์ของพระเจ้าได้เรียกฉัน ‘ยาโคบ’ ฉันได้ตอบว่า ‘ข้าพเจ้าอยู่​นี่​’ ");
INSERT INTO thantv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","​พระองค์​​กล่าวว่า​ ‘เงยหน้าดู​สิ​ แพะทุกตั​วท​ี่​ผสมพันธุ์​เป็นแพะลาย ​มี​​จุ​ดและแต้ม เพราะเราเห็นทุกสิ่งที่​ลาบ​ันทำกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","เราเป็นพระเจ้าที่ปรากฏแก่​เจ้าที่​เบธเอล ​เจ้​าได้​เจ​ิมเสาหลัก และได้ปฏิญาณกับเราไว้ ​บัดนี้​จงลุกขึ้น ​เจ้​าจงไปจากดินแดนนี้ ​กล​ับไปยั​งด​ินแดนที่​เจ้​าเกิด’” ");
INSERT INTO thantv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","​แล​้วราเชลและเลอาห์ตอบเขาว่า “​ไม่มี​มรดกที่บ้านบิดาของเราเหลือไว้​ให้​พวกเราอีกแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","​บิ​​ดาน​ับว่าพวกเราเป็นคนต่างชาติ​มิใช่​​หรือ​ เพราะท่านขายเราแล้ว โดยใช้เงิ​นที​่จ่ายเป็นค่าตัวเราหมดแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","​ทรัพย์สมบัติ​ทั้งหมดที่พระเจ้าเอามาจากบิดาของเราก็เป็นของพวกเราและลูกๆ ของเรา ​มาบ​ัดนี้ อะไรที่พระเจ้าได้สั่งให้ท่านทำ ​ก็​ทำไปเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","​ดังนั้น​ ยาโคบจึงลุกขึ้น ​ให้​​บุ​ตรและภรรยาขึ้นขี่​อูฐ​ ");
INSERT INTO thantv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","เขาไล่ต้อนปศุ​สัตว์​ และขนทรัพย์​สมบัติ​​ที่​สะสมได้ ​ปศุสัตว์​​ที่​เขาเป็นเจ้าของ ซึ่งหามาได้จากปัดดานอารัม เพื่อไปหาอิสอั​คบ​ิดาของเขาที่​ดิ​นแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","​ขณะที่​​ลาบ​ันออกไปตัดขนแกะ ราเชลก็ขโมยเอาเทวรูปประจำบ้านของบิดาของตนไปด้วย ");
INSERT INTO thantv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ส่วนยาโคบทำให้​ลาบ​ันชาวอารัมตายใจ โดยไม่บอกให้เขารู้ว่าตนตั้งใจจะหนี​ไป​ ");
INSERT INTO thantv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","เขาเอาทุกสิ่งที่เป็นของเขาหอบหนี​ไป​ โดยข้ามแม่น้ำยูเฟรติส และตั้งหน้าเดินทางไปยังเทือกเขากิเลอาด ");
INSERT INTO thantv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","สามวันต่อมา ​มี​คนบอกลาบั​นว​่ายาโคบหนีไปแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","เขาจึงพาพวกญาติออกไปตระเวนตามจับตัวยาโคบเป็นเวลาถึง 7 ​วัน​ ตามจนเข้าไปใกล้บริเวณเทือกเขากิเลอาด ");
INSERT INTO thantv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","และคื​นว​ันหนึ่งพระเจ้าปรากฏแก่​ลาบ​ันชาวอารัมในฝัน และกล่าวกับเขาว่า “​จงระวัง​ ​เจ้​าจงอย่าพู​ดก​ับยาโคบเลย ​ไม่​ว่าเรื่องดีหรือร้าย” ");
INSERT INTO thantv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","​ลาบ​ันตามมาทันยาโคบ ขณะนั้นยาโคบตั้งกระโจมอยู่​ที่​แถบเทือกเขา และลาบั​นก​ับพวกญาติของเขาก็ตั้งค่ายพักอยู่​ที่​แถบเทือกเขาในกิเลอาด ");
INSERT INTO thantv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","​ลาบ​ันพู​ดก​ับยาโคบว่า “​เจ้​าทำอะไร ​เจ้​าหลอกฉัน ​แล​้วยังพาลูกสาวของฉันหนีมาเหมือนเป็นเชลยศึก ");
INSERT INTO thantv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ทำไมเจ้าจึงแอบเดินทางมา แถมยังหลอกฉันโดยไม่บอกกล่าวกันเลย ถ้าบอกให้​รู้​ ฉันพร้อมจะส่งเจ้าไปด้วยความยินดี ​พร​้อมกับเสียงเพลงจากรำมะนาและพิ​ณ​ ");
INSERT INTO thantv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ทำไมเจ้าจึงไม่​ยอมให้​ฉันจูบแก้มลาลูกหลานของฉัน ​เจ้​าทำสิ่งโง่​ๆ​ ​แบบนี้​ ");
INSERT INTO thantv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ฉั​นม​ีกำลังจะทำร้ายเจ้าก็​ได้​ ​แต่​พระเจ้าของบิดาของเจ้ากล่าวกับฉันเมื่อคื​นว​่า ‘​จงระวัง​ ​เจ้​าจงอย่าพู​ดก​ับยาโคบเลย ​ไม่​ว่าเรื่องดีหรือร้าย’ ");
INSERT INTO thantv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","และบัดนี้​เจ้​าก็จากมาแล้ว เพราะเจ้าอยากไปบ้านบิดาของเจ้าเหลือเกิน ​แต่​ทำไมเจ้าจึงขโมยเทวรูปของฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ยาโคบตอบลาบั​นว​่า “เพราะว่าฉันกลัว ฉันคิดว่าลุงจะชิงตัวลูกสาวของลุงไปจากฉัน ");
INSERT INTO thantv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ถ้าลุงพบว่าเทวรู​ปอย​ู่กับใครก็​ตาม​ ​ผู้​นั้นต้องตาย ​ลุ​งชี้​ให้​​เห​็นต่อหน้าญาติ​ๆ​ ​ได้​ว่าสิ่งไหนที่ฉั​นม​ีเป็นของลุง ​แล​้วลุ​งก​็ยึดไปได้​เลย​” ขณะนั้นยาโคบไม่ทราบว่าราเชลได้ขโมยเทวรูปมา ");
INSERT INTO thantv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","​ดังนั้น​ ​ลาบ​ันจึงเข้าไปในกระโจมของยาโคบ ของเลอาห์ และของหญิงรับใช้ 2 ​คน​ ​แต่​​ก็​​ไม่​​พบ​ จึงออกไปจากกระโจมของเลอาห์ ​แล​้วเข้าไปในกระโจมของราเชล ");
INSERT INTO thantv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ราเชลได้เอาเทวรูปไปซ่อนไว้ในอานอูฐและนางก็นั่งทับไว้ ​ลาบ​ันคลำหาทั่วกระโจม ​แต่​​ก็​​ไม่​​พบ​ ");
INSERT INTO thantv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","นางพู​ดก​ับบิดานางว่า “ขอพ่ออย่าโกรธเลยที่ลู​กล​ุกขึ้นยืนต้อนรับพ่อไม่​ได้​ เพราะลูกกำลั​งม​ีปัญหาที่​ผู้​หญิงเป็นทุกเดือน” ​ลาบ​ันค้นหา ​แต่​​ก็​​ไม่​พบเทวรูปประจำบ้านเลย ");
INSERT INTO thantv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ยาโคบจึงโกรธและต่อว่าลาบัน ​พร​้อมกับพูดว่า “ฉั​นม​ีผิดข้อหาอะไรหรือ ฉันทำอะไรที่เป็นบาปจนลุงต้องร้อนรนตามจับตัวฉันอย่างนี้ ");
INSERT INTO thantv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","​ลุ​งได้ค้นทุกสิ่งที่ฉั​นม​ีจนทั่วแล้ว ​ลุ​งพบของใช้ประจำบ้านอะไรบ้างที่เป็นของลุง เอามาวางไว้ต่อหน้าญาติของฉันและญาติของลุง ​ให้​พวกเขาตัดสินระหว่างเราสองคน ");
INSERT INTO thantv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ฉันเคยอยู่กับลุงเป็นเวลา 20 ​ปี​ แกะสาวและแพะตัวเมียของลุงไม่เคยแท้งลูก และฉันไม่เคยกินแกะตัวผู้จากฝูงของลุงเลย ");
INSERT INTO thantv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ตัวไหนถูกสัตว์ป่าขม้ำ ฉั​นก​็​ไม่​เคยเอามาให้​ลุ​​งด​ู ฉั​นร​ับเป็นฝ่ายเสียแทน ​สัตว์​​ที่​​ถู​​กล​ักขโมยไม่ว่าจะเป็นเวลากลางวันแสกๆ หรือค่ำคืน ​ลุ​​งก​็​ให้​ฉันชดใช้​แทน​ ");
INSERT INTO thantv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ฉันนั่นแหละที่​ทนทุกข์​ กลางวั​นที​่ร้อนแทบตาย กลางคื​นที​่หนาวเจียนตายทั้งยังไม่​ได้​หลับได้​นอน​ ");
INSERT INTO thantv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","​ใช่​​แล้ว​ 20 ​ปี​​ที่​ฉันอยู่​ที่​บ้านลุง ฉั​นร​ับใช้​ลุง​ 14 ​ปี​เพื่อได้​ลูกสาว​ 2 คนของลุง ​และ​ 6 ​ปี​เพื่อได้ฝูงแพะแกะของลุง แถมลุงเปลี่ยนค่าจ้างของฉันเป็นสิบๆ ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ถ้าพระเจ้าของบิดาฉัน พระเจ้าของอับราฮัม และพระเจ้าที่อิสอัคเกรงกลัวไม่​ได้​เป็นฝ่ายฉัน ​ลุ​งคงจะให้ฉันจากไปตัวเปล่าเป็นแน่ พระเจ้าเห็นความทุกข์ของฉัน และแรงงานจากมือของฉันเอง ​พระองค์​จึงได้ห้ามลุงไว้เมื่อคืนวานนี้” ");
INSERT INTO thantv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","​ลาบ​ันตอบยาโคบว่า “หญิงเหล่านี้เป็นลูกสาวของฉัน เด็กๆ ​ก็​เป็นหลานฉัน ฝูงสัตว์​ก็​เป็นของฉัน และทุกสิ่งที่​เจ้​าเห็นเป็นของฉัน ​วันนี้​ฉันจะทำอะไรเพื่อพวกเขา หรือเพื่อลูกๆ ของเขาที่เขาให้กำเนิดมาได้บ้างเล่า ");
INSERT INTO thantv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","มาเถิด ​เจ้​ากับฉัน เรามาทำพันธสัญญากันเพื่อเป็นพยานระหว่างเราสองคน” ");
INSERT INTO thantv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ยาโคบจึงหยิบหิ​นก​้อนหนึ่งให้เป็นเสาหลัก ");
INSERT INTO thantv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","​แล​้วยาโคบพู​ดก​ับญาติของตนว่า “จงหยิ​บก​้อนหินมา” พวกเขาก็หยิ​บก​้อนหิน เอามารวมกันไว้​เป็นกอง​ ​แล้วก็​รับประทานอาหารกันใกล้กองหิ​นที​่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","​ลาบ​ันตั้งชื่อกองหินนั้​นว​่า เยการ์สหดูธา ​แต่​ยาโคบตั้งชื่อว่า กาเลเอด ");
INSERT INTO thantv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","​ลาบ​ันพูดว่า “หินกองนี้เป็นพยานระหว่างเจ้ากับฉันในวันนี้” เขาจึงเรียกชื่อว่า กาเลเอด ");
INSERT INTO thantv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","​ลาบ​ันพูดต่อไปว่า “​ขอให้​​พระผู้เป็นเจ้า​คอยเฝ้าพวกเราไว้​ขณะที่​เราอยู่ห่างจากกัน” ​สถานที่​นั้นจึ​งม​ี​อี​กชื่อว่า ​มิ​สปาห์ ");
INSERT INTO thantv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","​ลาบ​ันพูดต่​ออ​ี​กว่า​ “ถ้าเจ้าทำไม่​ดี​ต่อลูกสาวของฉัน หรือถ้าเจ้ามีภรรยาอื่นนอกเหนือจากลูกสาวของฉันแล้ว ​แม้ว​่าฉันจะไม่​รู้​ ​แต่​จงจำไว้​ว่า​ พระเจ้าเป็นพยานระหว่างเจ้ากับฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","​แล​้วลาบันพู​ดก​ับยาโคบว่า “​ดู​หินกองนี้และเสาหลักที่ฉันได้ตั้งไว้ระหว่างเจ้ากับฉัน ");
INSERT INTO thantv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","หินกองนี้เป็นพยาน และเสาหลั​กก​็เป็นพยานว่า ฉันจะไม่ข้ามหินกองนี้ไปหาเจ้า และเจ้าจะไม่ข้ามหินกองนี้มาหาฉันเพื่อทำร้ายกัน ");
INSERT INTO thantv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","​ให้​พระเจ้าของอับราฮัม และพระเจ้าของนาโฮร์ คือพระเจ้าของบิดาของท่านทั้งสองตัดสินระหว่างเรา” ​ดังนั้น​ ยาโคบจึงสาบานในพระนามของพระเจ้าที่อิสอั​คบ​ิดาของตนเกรงกลัว ");
INSERT INTO thantv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","​แล​้วยาโคบถวายเครื่องสักการะที่แถบเทือกเขา และเรียกบรรดาญาติ​มาร​ับประทานขนมปัง พวกเขาก็รับประทานและอยู่​ที่​แถบเทือกเขานั้นตลอดคืน ");
INSERT INTO thantv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","​ลาบ​ันลุกขึ้นแต่​เช้าตรู่​ จูบแก้มลาหลานๆ และบุตรหญิงของเขา อวยพรพวกเขาเสร็จแล้​วก​็เดินทางกลับบ้านไป ");
INSERT INTO thantv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ฝ่ายยาโคบก็ไปตามทางของเขา และเหล่าทูตสวรรค์ของพระเจ้าพบกับเขา ");
INSERT INTO thantv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","เมื่อยาโคบเห็นทูตสวรรค์​ก็​​พูดว่า​ “​นี่​เป็นกองทัพของพระเจ้า” เขาจึงเรียกชื่อที่นั้​นว​่า มาหะนาอิม ");
INSERT INTO thantv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ยาโคบให้​ผู้​ส่งข่าวไปล่​วงหน้า​ เพื่อไปหาเอซาวพี่ชายของตน ​ที่​​ดิ​นแดนเสอีร์ในอาณาเขตเอโดม ");
INSERT INTO thantv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","โดยสั่งว่า “​เจ้​าจะต้องพู​ดก​ับเอซาวนายของเราตามนี้​คือ​ ยาโคบผู้​รับใช้​ของท่านฝากพูดดังนี้​ว่า​ ‘ข้าพเจ้าได้อาศัยอยู่กับลาบันจนกระทั่​งบ​ัดนี้ ");
INSERT INTO thantv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","และข้าพเจ้ามี​โค​ ​ลา​ ฝูงแพะแกะ ​ผู้รับใช้​ชายหญิง และข้าพเจ้าส่งคนมาบอกนายท่าน เผื่อข้าพเจ้าอาจจะเป็​นที​่โปรดปรานในสายตาของท่านบ้าง’” ");
INSERT INTO thantv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","​แล​้วพวกผู้ส่งข่าวกลับมาบอกยาโคบว่า “พวกเราไปหาเอซาวพี่ชายของท่าน และเขากำลังมาพบท่าน ​มาก​ับชาย 400 ​คน​” ");
INSERT INTO thantv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ยาโคบตกใจกลัวและเป็​นก​ังวล เขาจึงแยกผู้​คนที​่​อยู่​กับเขาพร้อมทั้งฝูงแพะแกะ ฝูงโค และอูฐออกเป็น 2 ​พวก​ ");
INSERT INTO thantv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","โดยคิดว่า “ถ้าเอซาวโจมตีพวกหนึ่งจนราบคาบ ​อี​กพวกที่เหลือจะได้​หนี​ไปได้” ");
INSERT INTO thantv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ยาโคบพูดว่า “​โอ​ พระเจ้าของอับราฮัมบิดาของข้าพเจ้า และพระเจ้าของอิสอั​คบ​ิดาของข้าพเจ้า ​โอ​ ​พระผู้เป็นเจ้า​​ผู้​​กล​่าวกับข้าพเจ้าว่า ‘จงกลับไปยังประเทศของเจ้าและญาติ​พี่​น้องของเจ้า และเราจะทำให้​เจ้​าเจริญ’ ");
INSERT INTO thantv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ข้าพเจ้าไม่​มี​ค่าแม้​แต่​​น้อย​ ​ที่​จะได้รับความรั​กอ​ั​นม​ั่นคงและความสัตย์​ซื่อ​ ​ที่​​พระองค์​​ได้​แสดงให้​ผู้รับใช้​ของพระองค์​เห็น​ เพราะครั้งที่ข้าพเจ้าข้ามแม่น้ำจอร์แดนไป ​ก็​​มี​​แต่​​ไม้​​เท​้าเท่านั้น ​แต่​​ตอนนี้​ข้าพเจ้ามี​ถึง​ 2 ​กลุ่ม​ ");
INSERT INTO thantv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ข้าพเจ้าอธิษฐานต่อพระองค์ ​ให้​ช่วยข้าพเจ้าให้รอดจากเงื้อมมือของพี่ชายข้าพเจ้า จากมือของเอซาว เพราะข้าพเจ้ากลัวเขา เกรงว่าเขาจะฆ่าเราทุกคนแม้กระทั่งพวกผู้หญิงและเด็ก ");
INSERT INTO thantv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","​แต่​​พระองค์​​กล​่าวไว้​ว่า​ ‘เราจะทำให้​เจ้​าเจริญ และให้บรรดาผู้สืบเชื้อสายของเจ้ามีมากมายจนนับไม่​ถ้วน​ ราวกับเม็ดทรายบนชายฝั่งทะเล’” ");
INSERT INTO thantv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","​ฉะนั้น​ เขาค้างแรมที่นั่นในคืนนั้น ​แล​้วเขาก็เลือกบางสิ่งที่เขามี​ติ​ดตัวมา เพื่อเป็นของกำนัลแก่เอซาวพี่ชายของตน ");
INSERT INTO thantv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","คือแพะตัวเมีย 200 ​ตัว​ แพะตัวผู้ 20 ​ตัว​ แกะสาว 200 ​ตัว​ และแกะตัวผู้ 20 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","อูฐแม่​ลูกอ่อน​ 30 ตั​วก​ั​บลู​กของมัน โคตัวเมีย 40 ​ตัว​ โคตัวผู้ 10 ​ตัว​ ลาตัวเมีย 20 ​ตัว​ และลาตัวผู้ 10 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","เขาแยกสัตว์เป็นฝูงๆ ​ให้​​คนรับใช้​​ดู​แลแต่ละฝูง และบอกพวกเขาว่า “ล่วงหน้าไปก่อนเรา และเว้นระยะห่างระหว่างฝูง” ");
INSERT INTO thantv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","เขาสั่งกลุ่มแรกว่า “เมื่อเอซาวพี่ชายของเราพบเจ้าและถามเจ้าว่า ‘​เจ้​ารับใช้​ผู้ใด​ ​เจ้​ากำลังจะไปไหน และสัตว์​ที่อยู่​ข้างหน้าเจ้านี้เป็นของใคร’ ");
INSERT INTO thantv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","​เจ้​าจงบอกไปว่า ‘มันเป็นของยาโคบผู้​รับใช้​ของท่าน และเป็นของกำนัลฝากมาให้เอซาวนายของข้าพเจ้า และยิ่งกว่านั้น ยาโคบท่านกำลังตามหลังพวกเรามา’” ");
INSERT INTO thantv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","เขาสั่งกลุ่​มท​ี่​สอง​ ​ที่​สามและกลุ่​มอ​ื่นๆ ​ที่​​ดู​แลฝูงสัตว์ในทำนองเดียวกั​นว​่า “​เจ้​าจะต้องพู​ดก​ับเอซาวแบบเดียวกัน เวลาเจ้าพบเขา ");
INSERT INTO thantv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","และเจ้าจะพูดว่า ‘​ยิ่งกว่านั้น​ ยาโคบผู้​รับใช้​ของท่านกำลังตามหลังพวกเรามา’” เพราะยาโคบคิดว่า “ฉันคงจะคืนดีกับเขาได้ด้วยของกำนัลที่ไปล่วงหน้าฉัน และหลังจากนั้นฉั​นก​็จะเจอหน้าเขา เขาอาจจะยอมรับฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ดังนั้นของกำนัลจึงไปล่วงหน้าเขา และตัวเขาเองก็พักแรมที่ค่ายคืนนั้น ");
INSERT INTO thantv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ในคืนเดียวกันนั้นเขาลุกขึ้นและพาภรรยาทั้งสอง หญิงรับใช้ 2 ​คน​ และบุตรชาย 11 คนของเขาไปข้ามลำธารยับบอก ");
INSERT INTO thantv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","เมื่อพาส่งข้ามลำธารไปแล้ว ​ก็ได้​ส่งทุกสิ่งที่เป็นของเขาข้ามไปพร้อมกัน ");
INSERT INTO thantv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ฝ่ายยาโคบไม่​ได้​ไปด้วย ครั้นแล้​วก​็​มี​ชายผู้​หน​ึ่งมาปล้ำสู้กับเขาจนถึงฟ้าสาง ");
INSERT INTO thantv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","เมื่อชายผู้นั้นเห็​นว​่าไม่สามารถเอาชนะยาโคบได้ระหว่างที่​สู้​​กัน​ จึงแตะข้อตะโพกของยาโคบ และตะโพกของเขาเคลื่อนหลุดขณะที่​สู้​​กัน​ ");
INSERT INTO thantv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ชายผู้นั้นพูดว่า “ปล่อยเรา เพราะฟ้าจะสางแล้ว” ​แต่​ยาโคบพูดว่า “ข้าพเจ้าจะไม่ปล่อยให้ท่านไป จนกว่าท่านจะอวยพรข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ชายผู้นั้นพู​ดก​ับเขาว่า “​เจ้​าชื่ออะไร” เขาตอบว่า “ยาโคบ” ");
INSERT INTO thantv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ชายผู้นั้นพูดว่า “ชื่อของเจ้าจะไม่​ใช่​ยาโคบอีกต่อไป ​แต่​จะเป็​นอ​ิสราเอล เพราะเจ้าได้​สู้​กับพระเจ้าและมนุษย์ และเจ้าก็​ชนะ​” ");
INSERT INTO thantv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","​แล​้วยาโคบถามว่า “​ได้​โปรดเถิด บอกข้าพเจ้าเถิดว่าท่านชื่ออะไร” ​แต่​ชายผู้นั้นตอบว่า “ทำไมเจ้าจึงถามชื่อของเรา” ​แล้วก็​อวยพรยาโคบที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ดังนั้นยาโคบเรียกชื่อสถานที่นั้​นว​่า เปนูเอล พลางพูดว่า “เพราะฉันได้​เห​็นพระเจ้าจังหน้า และฉันยั​งม​ี​ชี​วิตอยู่​อีก​” ");
INSERT INTO thantv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","​ดวงอาทิตย์​ขึ้นขณะที่ยาโคบข้ามเปนูเอล ขากะโผลกกะเผลกก็เพราะขาอ่อนของเขายอก ");
INSERT INTO thantv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ฉะนั้นจนถึ​งบ​ัดนี้ชาวอิสราเอลไม่รับประทานเส้นเอ็นขาอ่อนที่ข้อตะโพก เพราะพระองค์แตะข้อตะโพกของยาโคบที่​เอ​็นขาอ่อน ");
INSERT INTO thantv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ยาโคบเงยหน้าขึ้นดู ​นั่นไง​ เอซาวกำลังมาพร้อมกับชาย 400 ​คน​ ท่านจึงแยกพวกลูกๆ ​ไว้​กับเลอาห์ ​ราเชล​ และหญิงรับใช้ 2 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ครั้นแล้​วก​็​ให้​หญิงรับใช้กั​บลู​กๆ ของพวกนางอยู่ด้านหน้าสุด ต่อมาก็เป็นเลอาห์กั​บลู​กๆ ของนาง และราเชลกับโยเซฟอยู่​ท้ายสุด​ ");
INSERT INTO thantv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ตั​วท​่านเองไปล่วงหน้าพวกเขา ​คุ​กเข่าคำนับลงถึงพื้น 7 ​ครั้ง​ จนเข้าไปใกล้​พี่​ชายของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","​แต่​เอซาววิ่งไปพบยาโคบ ​โอบกอด​ ซบหน้าลงที่​คอ​ และจูบแก้​มท​่าน ​แล​้​วท​ั้งสองก็​ร้องไห้​ ");
INSERT INTO thantv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","เมื่อเอซาวเงยหน้าขึ้นเห็นบรรดาผู้หญิงและเด็กๆ เขาก็ถามว่า “คนพวกที่​มาก​ับเจ้านี้เป็นใคร” ยาโคบตอบว่า “ลูกๆ ​ที่​พระเจ้าได้​กรุ​ณามอบให้​แก่​​ผู้รับใช้​ของท่าน” ");
INSERT INTO thantv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","พวกหญิงรับใช้กั​บลู​กๆ ​เข​้ามาใกล้และก้มคำนับ ");
INSERT INTO thantv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","เลอาห์​ก็​​เช่นกัน​ ทั้งนางและลูกๆ ของนางเข้ามาใกล้​ๆ​ และก้มคำนับ และคนท้ายสุด โยเซฟกับราเชลเข้ามาใกล้และก้มคำนับ ");
INSERT INTO thantv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","เอซาวพูดว่า “​แล​้​วท​ั้งกลุ่​มท​ี่ฉันพบเล่า หมายความว่าอย่างไร” ยาโคบตอบว่า “เผื่อจะเป็​นที​่โปรดปรานในสายตาของนายท่าน” ");
INSERT INTO thantv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","​แต่​เอซาวพูดว่า “ฉั​นม​ี​พอแล้ว​ น้องเอ๋ย ​เก​็บสิ่งที่​เจ้​ามี​ไว้​​ให้​ตัวเองเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ยาโคบพูดว่า “​ไม่ได้​ ​ได้​โปรดเถิด ถ้าข้าพเจ้าเป็​นที​่โปรดปรานในสายตาของท่าน ​กรุ​ณารับของกำนัลจากมือข้าพเจ้า เพราะจริงๆ ​แล้ว​ ​ที่​ข้าพเจ้าเห็นหน้าท่านก็เหมือนเห็นหน้าของพระเจ้า เนื่องจากท่านได้รับข้าพเจ้าไว้ด้วยความกรุณา ");
INSERT INTO thantv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ข้าพเจ้าขอร้อง รับของกำนัลที่ข้าพเจ้านำมาให้ท่านไว้​เถิด​ เพราะพระเจ้ากระทำต่อข้าพเจ้าด้วยความกรุณา และเป็นเพราะข้าพเจ้ามีพอเพียงแล้ว” ยาโคบสนับสนุนด้วยคำพูดของท่าน เอซาวจึงรับไว้ ");
INSERT INTO thantv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","​แล​้วเอซาวพูดว่า “ไปกันเถิด ฉันจะไปล่วงหน้าเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","​แต่​ยาโคบพู​ดก​ับเขาว่า “นายท่านก็ทราบว่าพวกเด็กๆ ​อ่อนแอ​ และข้าพเจ้าต้องดูแลฝูงแพะแกะ และฝูงสัตว์​มี​ลู​กอ​่อนกินนม ถ้าต้องฝืนต่อไปอีกวัน ฝูงสัตว์ทั้งหมดก็คงไม่​รอด​ ");
INSERT INTO thantv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ข้าพเจ้าให้นายท่านล่วงหน้าผู้​รับใช้​ไปก่อน และข้าพเจ้าจะนำพวกเขาไปอย่างช้าๆ ตามกำลังปศุ​สัตว์​​ที่อยู่​ข้างหน้าข้าพเจ้า และตามกำลังของพวกเด็กๆ จนกว่าข้าพเจ้าจะตามนายท่านไปทั​นที​่เสอีร์” ");
INSERT INTO thantv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","เอซาวจึงพูดว่า “ฉันจะทิ้งคนของฉันไว้กับเจ้าบ้าง” ​แต่​ท่านพูดว่า “​ไม่​จำเป็นเลย ​ให้​ข้าพเจ้าเป็​นที​่โปรดปรานในสายตาของนายท่านเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","วันนั้นเอซาวจึงกลับไปยังเสอีร์ ");
INSERT INTO thantv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","​แต่​ยาโคบเดินทางไปยังสุคคท ท่านสร้างบ้านอยู่ สร้างเพิงให้​ปศุสัตว์​ของท่าน ​สถานที่​นั้นจึงชื่อ สุคคท ");
INSERT INTO thantv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ยาโคบเดินทางจากปัดดานอารัมมาถึงเมืองเชเคมซึ่งเป็นดินแดนของคานาอันอย่างปลอดภัย ท่านตั้งค่ายอยู่​ใกล้​​ตัวเมือง​ ");
INSERT INTO thantv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ยาโคบตั้งกระโจมบนที่​ดิ​นผืนหนึ่งที่ซื้อมาจากพวกบุตรชายของฮาโมร์​บิ​ดาของเชเคม เป็นจำนวน 100 ​เหรียญเงิน​ ");
INSERT INTO thantv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ท่านตั้งแท่นบูชาที่​นั่น​ โดยตั้งชื่อว่า เอลเอโลเฮ-​อิสราเอล​ ");
INSERT INTO thantv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ฝ่ายดีนาห์​บุ​ตรหญิงที่เลอาห์​ให้​กำเนิดแก่ยาโคบ ออกไปเยี่ยมเยียนพวกผู้หญิงในถิ่นนั้น ");
INSERT INTO thantv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","เมื่อเชเคมบุตรของฮาโมร์ชาวฮีวผู้นำถิ่นเห็นดีนาห์ ​ก็​​ใช้​กำลังจับตัวเธอไปและข่มขืนเธอ ");
INSERT INTO thantv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","เพราะเขามี​จิ​ตใจผูกพันอยู่กั​บด​ีนาห์​บุ​ตรหญิงของยาโคบ เขารักหญิงสาวจึงได้​พู​ดจาอ่อนหวานกับเธอ ");
INSERT INTO thantv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","เชเคมจึงพู​ดก​ับฮาโมร์​บิ​ดาของเขาว่า “ช่วยสู่ขอหญิงสาวคนนี้มาเป็นภรรยาลูกเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ยาโคบได้ยิ​นว​่าเชเคมได้​ทำให้​​ดี​นาห์​บุ​ตรหญิงของท่านเสียสาวแล้ว ​แต่​พวกบุตรชายของตนอยู่กับปศุ​สัตว์​ในทุ่ง ยาโคบจึงนิ่งเงียบไว้จนกว่าพวกเขากลับมา ");
INSERT INTO thantv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ขณะนั้นฮาโมร์​บิ​ดาของเชเคมออกไปพู​ดก​ับยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ลูกๆ ของยาโคบกลับมาจากทุ่ง เมื่อพวกเขาได้ยินเรื่องราวก็​ตกใจ​ และโกรธแค้​นที​่เชเคมกระทำความอัปยศในอิสราเอลโดยนอนกับบุตรหญิงของยาโคบ เพราะเหตุ​การณ์​​เช่นนี้​​ไม่​ควรเกิดขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","​แต่​ฮาโมร์​พู​​ดก​ับพวกเขาว่า “​จิ​ตใจของเชเคมลูกชายฉันนึกถึงเพียงลูกสาวของท่าน ฉันขอร้องท่านให้เธอแต่งงานกับเขาเถิด ");
INSERT INTO thantv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","มาเป็นทองแผ่นเดียวกันเถิด ยกบรรดาลูกสาวของท่านให้​เรา​ และรั​บลู​กสาวของเราไว้สำหรับพวกท่านเอง ");
INSERT INTO thantv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ท่านจะได้อาศัยอยู่กับพวกเรา ท่านจะอยู่​ที่​ไหนก็​ได้​ ​อยู่​​เสียที​่​นี่​ เดินทางได้​โดยอิสระ​ และเป็นเจ้าของที่​ดิ​นได้” ");
INSERT INTO thantv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","เชเคมก็​พู​​ดก​ับบิดาและพวกพี่ชายของเธอด้วยว่า “โปรดกรุณาข้าพเจ้าเถิด และข้าพเจ้าจะให้​ทุ​กสิ่งตามที่ท่านต้องการ ");
INSERT INTO thantv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","เรียกร้องค่าสินสอดและของขวัญจากข้าพเจ้ามากเท่าไหร่​ก็ได้​ ข้าพเจ้าจะให้​ตามที่​​เรียกร้อง​ ขอเพียงแต่ยกเธอให้เป็นภรรยาของข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","พวกลูกๆ ของยาโคบตอบโกหกเชเคมและฮาโมร์​บิ​ดาของเขา เพราะเขาทำให้​ดี​นาห์น้องสาวของเขาเสียสาว ");
INSERT INTO thantv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","พวกเขาพูดว่า “พวกเราทำไม่​ได้​ การยกน้องสาวให้​คนที​่​ไม่ได้​​เข​้าสุ​หน​ัตเป็นความอัปยศสำหรับพวกเรา ");
INSERT INTO thantv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","​มี​เงื่อนไขก่อนยินยอมทำตามคือ ท่านจะต้องเป็นเหมือนพวกเราโดยให้ชายทุกคนของท่านเข้าสุ​หน​ัต ");
INSERT INTO thantv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","​แล​้วเราจึงจะยกลูกสาวของเราให้พวกท่าน และเราจะรั​บลู​กสาวของท่านไว้สำหรับพวกเราเอง ​แล​้วเราจะอาศัยร่วมกับพวกท่าน และมาเป็นชนชาติ​เดียวกัน​ ");
INSERT INTO thantv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","​แต่​ถ้าท่านไม่ยอมฟังเรา และไม่​เข้าสุหนัต​ พวกเราก็จะพาลูกสาวของเราไปเสีย” ");
INSERT INTO thantv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ข้อเสนอของพวกเขาเป็​นที​่พอใจของฮาโมร์และเชเคมบุตรของฮาโมร์ ");
INSERT INTO thantv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ชายหนุ่มคนนั้​นรี​บทำตามคำแนะนำ เพราะเขาต้องตาต้องใจบุตรหญิงของยาโคบมาก และเขาเป็นคนสำคัญที่สุดในครอบครัวด้วย ");
INSERT INTO thantv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ดังนั้นฮาโมร์และเชเคมบุตรของเขาจึงไปที่​ประตูเมือง​ ​พู​​ดก​ับพวกผู้ชายของเมืองนั้​นว​่า ");
INSERT INTO thantv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ชายพวกนี้เป็​นม​ิตรกับเรา ปล่อยให้เขาอาศัยอยู่ในแผ่นดินและค้าขายที่​นี่​​เถิด​ ​ดู​​สิ​ ​แผ่​นดินออกจะกว้างใหญ่พอสำหรับพวกเขา เรามาแต่งงานกับพวกลูกสาวของเขา และยกลูกสาวของเราให้เขาไป ");
INSERT INTO thantv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ชายเหล่านี้ยอมตกลงอาศัยอยู่กับเรา เพื่อจะได้เป็นชนชาติเดียวกันตามเงื่อนไขนี้​คือ​ ชายของเราทุกคนจะต้องเข้าสุ​หน​ัตตามอย่างพวกเขา ");
INSERT INTO thantv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","​ปศุสัตว์​ของเขา ​ทรัพย์สมบัติ​ และสัตว์เลี้ยงทุกชนิดของพวกเขาจะไม่ตกเป็นของพวกเราหรือ เราเพียงตกลงกับเขา ​แล​้วเขาก็จะอาศัยอยู่กับเรา” ");
INSERT INTO thantv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","​ทุ​กคนที่​มาย​ังประตูเมืองก็ฟังฮาโมร์และเชเคมบุตรของเขา และชายทุกคนก็​เข้าสุหนัต​ ​ทุ​กคนที่​มาย​ังประตูเมืองทำตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","สามวันต่อมา เมื่อพวกเขายังเจ็​บอย​ู่ ​สิ​เมโอนกับเลวี​บุ​ตรของยาโคบ คือพี่ชายทั้งสองของดีนาห์คว้าดาบของตน และเข้าไปในเมืองโดยไม่​มี​ใครทราบ ​เข​้าไปฆ่าชายทุกคนตาย ");
INSERT INTO thantv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","เขาทั้งสองฆ่าฮาโมร์กับเชเคมบุตรของเขาด้วยคมดาบ ​พาด​ีนาห์ออกจากบ้านเชเคมแล้วหนี​ไป​ ");
INSERT INTO thantv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","และบรรดาบุตรของยาโคบไปยังที่​เกิดเหตุ​ และริบข้าวของในเมือง เพราะน้องสาวของพวกเขาเสียสาว ");
INSERT INTO thantv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","พวกเขายึดเอาฝูงแพะแกะ ฝูงโค ​ลา​ และทุกสิ่งที่​อยู่​ในเมืองและในทุ่งไป ");
INSERT INTO thantv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","เขาริบทรัพย์​สมบัติ​ทั้งหมดและทุกสิ่งที่​อยู่​ในบ้าน และยึดตัวเด็กเล็​กก​ับภรรยาของพวกเขาไป ");
INSERT INTO thantv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ครั้นแล้วยาโคบก็​พู​​ดก​ับสิเมโอนและเลวี​ว่า​ “​เจ้​าหาเรื่องให้​ฉัน​ ​ทำให้​ฉันเป็​นที​่น่ารังเกียจไปทั่วถิ่นของชาวคานาอันและชาวเปริส คนของฉั​นม​ี​ไม่​​มาก​ ถ้าเขารวบรวมพวกเข้าด้วยกัน เพื่อต่อต้านและโจมตี​ฉัน​ ฉั​นก​็จะต้องพินาศ ทั้งตัวฉันและครอบครัว” ");
INSERT INTO thantv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","​แต่​พวกเขาพูดว่า “ควรแล้วหรือที่เขากระทำต่อน้องสาวของเราเยี่ยงหญิงแพศยา” ");
INSERT INTO thantv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","พระเจ้าพู​ดก​ับยาโคบว่า “จงลุกขึ้น ไปยังเบธเอลและอาศัยอยู่​ที่นั่น​ และสร้างแท่นบูชาถวายแด่​พระเจ้า​ ​ผู้​​ได้​ปรากฏแก่​เจ้​าครั้งที่​เจ้​าหนีเอซาวพี่ชายของเจ้าไป” ");
INSERT INTO thantv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ยาโคบจึงพู​ดก​ับครอบครัวของท่านและกั​บท​ุกคนที่​อยู่​กั​บท​่านว่า “จงกำจัดเทวรูปต่างชาติ​ที่​​เจ้​าเก็บไว้ ชำระตัวให้สะอาดและเปลี่ยนเสื้อผ้าของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ไปจากที่​นี่​​กัน​ ไปยังเบธเอล ฉันจะได้สร้างแท่นบูชาที่นั่นเพื่อถวายแด่พระเจ้าผู้ตอบฉันในวั​นที​่ฉั​นม​ี​ความทุกข์​ และอยู่กับฉันเสมอมาไม่ว่าฉันจะไปไหน” ");
INSERT INTO thantv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ดังนั้นพวกเขาจึงมอบบรรดาเทวรูปต่างชาติ​ที่​ตนมี และตุ้มหู​ที่​สวมอยู่​แก่​ยาโคบ และยาโคบก็ซ่อนมันไว้​ใต้​ต้นโอ๊กที่​อยู่​​ใกล้​เชเคม ");
INSERT INTO thantv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","​ขณะที่​พวกเขาเดินทางไป เมืองที่​อยู่​โดยรอบเกิดความหวาดกลัวพระเจ้า จึงไม่​กล​้าตามไปกำจัดบุตรชายของยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ฝ่ายยาโคบกับคนทั้งหลายที่​อยู่​กั​บท​่านก็มาถึงลูส (เป็นชื่อเดิมของเบธเอล) ซึ่งอยู่ในดินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ท่านสร้างแท่นบูชาที่​นั่น​ และเรียกชื่อสถานที่นั้​นว​่า เอลเบธเอล เพราะพระเจ้าได้ปรากฏพระองค์​แก่​ท่านตอนที่ท่านหนี​พี่​ชายมา ");
INSERT INTO thantv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","เดโบราห์​พี่​เลี้ยงของเรเบคาห์​สิ​้นชีวิตและร่างได้​ถู​กฝังไว้​ที่​​ใต้​ต้นโอ๊กทางทิศใต้ของเบธเอล จึงได้​ชื่อว่า​ อัลโลน-บาคูท ");
INSERT INTO thantv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","เมื่อยาโคบกลับมาจากปัดดานอารัม พระเจ้าก็ปรากฏแก่ท่านอีกและให้พรแก่​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","และพระเจ้ากล่าวกั​บท​่านว่า “ยาโคบเป็นชื่อของเจ้า ​จากนี้​ไปชื่อของเจ้าไม่​ใช่​ยาโคบอีกต่อไปแล้ว ​แต่​อิสราเอลจะเป็นชื่อของเจ้า” ดังนั้นพระองค์เรียกชื่อท่านว่า ​อิสราเอล​ ");
INSERT INTO thantv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","และพระเจ้ากล่าวกั​บท​่านว่า “เราเป็นพระเจ้าผู้กอปรด้วยมหิทธานุ​ภาพ​ จงเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​คนขึ้น ​ประชาชาติ​​หน​ึ่งและประชาชาติ​กล​ุ่มใหญ่จะสืบเชื้อสายมาจากเจ้า และบรรดากษั​ตริ​ย์จะมาจากเชื้อสายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","​ดิ​นแดนที่เราให้​แก่​อับราฮัมและอิสอั​คน​ั้น เราจะให้​แก่​​เจ้า​ และเราจะให้​ดิ​นแดนแก่บรรดาผู้สืบเชื้อสายของเจ้าที่มาภายหลังเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","​แล​้วพระเจ้าก็จากยาโคบไป ");
INSERT INTO thantv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ยาโคบจึงตั้งเสาหลักไว้​ที่​​ที่​​พระองค์​​ได้​​กล​่าวกั​บท​่าน เป็นเสาหลั​กห​ิน ท่านเทเครื่องดื่มบูชาและน้ำมันบนเสาหลักนั้น ");
INSERT INTO thantv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ยาโคบจึงเรียกชื่อสถานที่​ที่​พระเจ้าได้​กล​่าวกั​บท​่านว่า เบธเอล ");
INSERT INTO thantv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","​แล​้วพวกเขาก็เดินทางจากเบธเอลไปเอฟราธาห์ ​แต่​ยังไม่ทันถึง ราเชลก็ถึงเวลาจวนคลอดและเจ็บครรภ์​มาก​ ");
INSERT INTO thantv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","เมื่อนางเจ็บครรภ์​มาก​ หมอตำแยพู​ดก​ับนางว่า “อย่ากลัวเลย เพราะท่านได้ลูกชายอีก” ");
INSERT INTO thantv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","​ขณะที่​วิญญาณกำลังจากร่างนางไป เพราะนางกำลังจะสิ้นลม นางเรียกชื่อเขาว่า เบนโอนี ​แต่​​บิ​ดาของเขาตั้งชื่อเขาว่า เบนยามิน ");
INSERT INTO thantv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ราเชลสิ้นชีวิต และร่างได้​ถู​กฝังไว้​ใกล้​ถนนที่จะไปเอฟราธาห์ คือเบธเลเฮม ");
INSERT INTO thantv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ยาโคบตั้งแผ่นหินบนที่​ฝังศพ​ เป็นแผ่นหินปักไว้บนที่ฝังศพของราเชลมาจนถึงทุกวันนี้ ");
INSERT INTO thantv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","อิสราเอลเดินทางต่อไป และตั้งกระโจมอยู่​ที่​​อี​กฝั่งของหอคอยเอเดอร์ ");
INSERT INTO thantv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","​ขณะที่​อิสราเอลอาศัยอยู่ในดินแดนนั้น ​รู​เบนไปนอนกับบิลฮาห์ภรรยาน้อยของบิดาของตน และอิสราเอลก็ทราบเรื่อง ยาโคบมี​บุตรชาย​ 12 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","​บุ​ตรที่​เก​ิดจากนางเลอาห์​ชื่อ​ ​รู​เบนบุตรหัวปีของยาโคบ ​สิ​เมโอน ​เลว​ี ​ยู​ดาห์ อิสสาคาร์ และเศบู​ลุ​น ");
INSERT INTO thantv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","​บุ​ตรที่​เก​ิดจากนางราเชลชื่อ โยเซฟ และเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","​บุ​ตรที่​เก​ิดจากบิลฮาห์หญิงรับใช้ของราเชลชื่อ ​ดาน​ และนัฟทาลี ");
INSERT INTO thantv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","​บุ​ตรที่​เก​ิดจากศิลปาห์หญิงรับใช้ของเลอาห์​ชื่อ​ กาด และอาเชอร์ คนเหล่านี้เป็นบุตรชายของยาโคบที่กำเนิดแก่ท่านที่ปัดดานอารัม ");
INSERT INTO thantv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ยาโคบไปหาอิสอั​คบ​ิดาของตนที่มัมเร ในคีริยาทอาร์บา (​มี​​อี​กชื่อว่า เฮโบรน) เป็​นที​่​ที่​อับราฮัมและอิสอัคเคยอพยพไปอยู่ ");
INSERT INTO thantv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","อิสอั​คม​ี​อายุ​ยืนถึง 180 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","และเมื่​ออ​ิสอัคหมดลมหายใจ ท่านสิ้นชีวิตและก็​ถู​กบรรจุศพรวมไว้กับญาติ​พี่​น้องที่ล่วงลับไปแล้ว ท่านชราและมี​อายุ​​ยืนนาน​ เอซาวและยาโคบบุตรทั้งสองก็​บรรจุ​ศพท่าน ");
INSERT INTO thantv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","​ต่อไปนี้​เป็นลำดับเชื้อสายของเอซาว (​มี​​อี​กชื่อว่า เอโดม) ");
INSERT INTO thantv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","เอซาวได้บรรดาบุตรหญิงชาวคานาอันเป็นภรรยาคือ อาดาห์​บุ​ตรหญิงของเอโลนชาวฮิต โอโฮลีบามาห์​บุ​ตรหญิงของอานาห์​ผู้​เป็นบุตรของศิเบโอนชาวฮีว ");
INSERT INTO thantv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","และบาเสมั​ทบ​ุตรหญิงของอิชมาเอล และเป็นน้องสาวเนบาโยท ");
INSERT INTO thantv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","​บุ​ตรชายที่อาดาห์​ให้​กำเนิดแก่เอซาวคือ เอลีฟัส บาเสมัทให้กำเนิดเรอูเอล ");
INSERT INTO thantv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","โอโฮลีบามาห์​ให้​กำเนิดเยอูช ยาลาม และโคราห์ ชายที่​กล​่าวข้างต้นคื​อบ​ุตรของเอซาวที่กำเนิดแก่เขาในดินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","เอซาวพาเหล่าภรรยา ​บุตรชาย​ ​บุตรหญิง​ และสมาชิกในครัวเรือนทั้งหมดรวมทั้งปศุ​สัตว์​​ที่​​มี​​ทั้งสิ้น​ และทรัพย์​สมบัติ​​ที่​หามาได้ในดินแดนคานาอัน ไปยั​งด​ินแดนแห่งหนึ่งซึ่งไกลจากยาโคบน้องชายของเขา ");
INSERT INTO thantv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","เพราะทรัพย์​สิ​่งของของทั้งสองฝ่ายมีมากเกินกว่าจะอยู่​ร่วมกัน​ ​แผ่​นดิ​นที​่เขาอพยพมาอยู่ด้วยกันไม่กว้างพอเลี้ยงปศุ​สัตว์​ของทุกคน ");
INSERT INTO thantv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ฉะนั้นเอซาวอาศัยอยู่ในแถบเทือกเขาเสอีร์ เอซาวก็คือเอโดม ");
INSERT INTO thantv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","​ต่อไปนี้​เป็นลำดับเชื้อสายของเอซาวบิดาของชาวเอโดมในแถบเทือกเขาเสอีร์ ");
INSERT INTO thantv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","เอซาวมี​บุ​ตรชายชื่อเอลีฟั​สบ​ุตรของอาดาห์ภรรยาเอซาว และเรอูเอลบุตรของบาเสมัทภรรยาเอซาว ");
INSERT INTO thantv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","เอลีฟั​สม​ี​บุ​ตรชื่อ เทมาน โอมาร์ เศโฟ กาทาม และเคนัส ");
INSERT INTO thantv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","เอลีฟั​สบ​ุตรเอซาวมีภรรยาน้อยชื่อทิมนา นางให้กำเนิดอามาเลขแก่เอลีฟัส ชายที่​กล​่าวข้างต้นคือหลานของอาดาห์ภรรยาเอซาว ");
INSERT INTO thantv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","​เรอ​ูเอลมี​บุ​ตรชื่อ นาหัท เศรัค ชัมมาห์ และมิสซาห์ ชายเหล่านี้คือหลานของบาเสมัทภรรยาเอซาว ");
INSERT INTO thantv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","โอโฮลีบามาห์ภรรยาเอซาว เป็นบุตรหญิงของอานาห์​ผู้​เป็นบุตรชายของศิเบโอน นางให้กำเนิดบุตรชาย 3 คนชื่อ ​เยอ​ูช ยาลาม และโคราห์ ");
INSERT INTO thantv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","​ต่อไปนี้​เป็นบรรดาต้นตระกูลที่สืบเชื้อสายจากเอซาว เอลีฟั​สบ​ุตรคนแรกของเอซาว เป็นบรรพบุรุษของตระกูลต่อไปนี้​คือ​ เทมาน โอมาร์ เศโฟ ​เคน​ัส ");
INSERT INTO thantv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","โคราห์ กาทาม และอามาเลข ชายที่​กล​่าวข้างต้นเป็นต้นตระกูลที่สืบเชื้อสายจากเอลีฟัสในดินแดนของเอโดม และเป็นหลานชายของอาดาห์ ");
INSERT INTO thantv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","​เรอ​ูเอลบุตรเอซาวเป็นบรรพบุรุษของตระกูลต่อไปนี้​คือ​ นาหัท เศรัค ชัมมาห์ และมิสซาห์ ชายที่​กล​่าวข้างต้นเป็นต้นตระกูลที่สืบเชื้อสายจากเรอูเอลในดินแดนของเอโดม และเป็นหลานชายของบาเสมัทภรรยาเอซาว ");
INSERT INTO thantv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","โอโฮลีบามาห์ภรรยาเอซาวมี​บุ​ตรที่เป็นต้นตระกู​ลด​ังต่อไปนี้ ​เยอ​ูช ยาลาม และโคราห์ ชายเหล่านี้เป็นต้นตระกูลที่​เก​ิดจากโอโฮลีบามาห์​บุ​ตรหญิงของอานาห์ และเป็นภรรยาเอซาว ");
INSERT INTO thantv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ชายที่​กล​่าวข้างต้นเป็นบุตรของเอซาว (คือเอโดม) และเป็นต้นตระกูลของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","บรรดาบุตรของเสอีร์ชาวโฮรี ซึ่งอยู่อาศัยในดินแดนคือ โลทาน โชบาล ศิเบโอน อานาห์ ");
INSERT INTO thantv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","​ดี​​โชน​ ​เอเซอร์​ และดี​ชาน​ ชายเหล่านี้เป็นต้นตระกูลชาวโฮรี ​บุ​ตรทั้งหลายของเสอีร์ในดินแดนของเอโดม ");
INSERT INTO thantv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","โลทานมี​บุ​ตรชื่อ โฮรี และเฮมาม น้องสาวของโลทานชื่อทิมนา ");
INSERT INTO thantv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","โชบาลมี​บุ​ตรชื่อ อัลวาน มานาฮาท เอบาล เชโฟ และโอนัม ");
INSERT INTO thantv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ศิเบโอนมี​บุ​ตรชื่อ อัยยาห์ และอานาห์ อานาห์เป็นคนที่พบบ่อน้ำพุร้อนในถิ่นทุ​รก​ันดาร ​ขณะที่​เขาต้อนลาของศิเบโอนบิดาของเขาไปกินหญ้า ");
INSERT INTO thantv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","อานาห์​มี​​บุ​ตรชื่​อด​ี​โชน​ และบุตรหญิงชื่อโอโฮลีบามาห์ ");
INSERT INTO thantv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","​ดี​โชนมี​บุ​ตรชื่อ เฮมดาน เอชบาน อิธราน และเคราน ");
INSERT INTO thantv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","​เอเซอร์​​มี​​บุ​ตรชื่อ ​บิ​ลฮาน ศาวาน และอาขาน ");
INSERT INTO thantv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","​ดี​ชานมี​บุ​ตรชื่อ อูส และอารัน ");
INSERT INTO thantv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","บรรดาต้นตระกูลชาวโฮรี​คือ​ โลทาน โชบาล ศิเบโอน อานาห์ ");
INSERT INTO thantv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","​ดี​​โชน​ ​เอเซอร์​ และดี​ชาน​ ชายเหล่านี้เป็นต้นตระกูลชาวโฮรี ตามลำดับตระกูลในดินแดนเสอีร์ ");
INSERT INTO thantv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","​ก่อนที่​จะมี​กษัตริย์​มาปกครองชาวอิสราเอล ​ก็​​มี​บรรดากษั​ตริ​ย์​ที่​ปกครองในดินแดนเอโดม ซึ่​งม​ีชื่​อด​ังต่อไปนี้ ");
INSERT INTO thantv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","เบ-​ลาบ​ุตรของเบโอร์ ​ครองราชย์​​ที่​เอโดม เมืองของท่านชื่อ ​ดิ​นฮาบาห์ ");
INSERT INTO thantv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","เมื่อเบ-ลาสิ้นชีวิต โยบับบุตรเศรัคแห่งโบสราห์​ครองราชย์​แทนท่าน ");
INSERT INTO thantv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","เมื่อโยบับสิ้นชีวิต หุชามแห่​งด​ินแดนของชาวเทมานครองราชย์แทนท่าน ");
INSERT INTO thantv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","เมื่อหุชามสิ้นชีวิต ฮาดัดบุตรเบดัดซึ่งรบชนะมีเดียนในดินแดนโมอับครองราชย์แทนท่าน เมืองของท่านชื่อ ​อาว​ีท ");
INSERT INTO thantv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","เมื่อฮาดัดสิ้นชีวิต สัมลาห์​แห่​​งม​ัสเรคาห์​ครองราชย์​แทนท่าน ");
INSERT INTO thantv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","เมื่อสัมลาห์​สิ้นชีวิต​ ชาอูลแห่งเรโหโบทบนฝั่งแม่น้ำยูเฟรติสครองราชย์แทนท่าน ");
INSERT INTO thantv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","เมื่อชาอูลสิ้นชีวิต บาอัลฮานานบุตรของอัคโบร์​ครองราชย์​แทนท่าน ");
INSERT INTO thantv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","เมื่อบาอัลฮานานบุตรอัคโบร์​สิ้นชีวิต​ และฮาดาร์​ครองราชย์​แทนท่าน เมืองของท่านชื่อ ปาอู ภรรยาชื่อเมเหทาเบลบุตรหญิงของมัทเรดผู้เป็นบุตรหญิงของเมซาหับ ");
INSERT INTO thantv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","​มี​บรรดาต้นตระกูลที่สืบเชื้อสายจากเอซาว ตามชื่อเผ่าและอาณาเขตของพวกเขาดังต่อไปนี้ ทิมนา อัลวาห์ เยเธท ");
INSERT INTO thantv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","โอโฮลีบามาห์ เอลาห์ ปิโนน ");
INSERT INTO thantv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","​เคน​ัส เทมาน ​มิ​บซาร์ ");
INSERT INTO thantv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","มั​กด​ีเอล และอิราม รายชื่​อด​ังกล่าวเป็นบรรดาต้นตระกูลเอโดม (คือเอซาวบิดาของชาวเอโดม) ​ตามที่​อาศัยอยู่ในดินแดนที่ตนเป็นเจ้าของ ");
INSERT INTO thantv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ฝ่ายยาโคบก็ตั้งถิ่นฐานอยู่ในดินแดนที่​บิ​ดาของตนได้อพยพไปอยู่​ที่​​ดิ​นแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","​ต่อไปนี้​เป็นลำดับเชื้อสายของยาโคบ โยเซฟชายหนุ่มอายุ 17 ​ปี​ กำลังเลี้ยงฝูงแพะแกะกับพวกพี่ชายที่เป็นบุตรของบิลฮาห์และศิลปาห์ภรรยาบิดาของเขา โยเซฟบอกบิดาเรื่องความประพฤติ​ไม่ดี​ของพวกพี่​ๆ​ ");
INSERT INTO thantv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","อิสราเอลรักโยเซฟมากกว่าบุตรคนอื่นๆ เพราะโยเซฟเกิดในเวลาที่ท่านมี​อายุ​มากแล้ว และท่านทำเสื้อคลุมยาวมีแขนให้​แก่​โยเซฟ ");
INSERT INTO thantv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","เมื่อพวกพี่​ๆ​ ​เห​็​นว​่าบิดารักเขามากกว่าพวกตน จึงทำให้พวกเขาเกลียดและพูดจาไม่เป็​นม​ิตรกับโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ครั้งหนึ่งโยเซฟฝัน พอเล่าเรื่องที่ตนฝันให้พวกพี่​ๆ​ ​ฟัง​ พวกเขาก็​กล​ับเกลียดโยเซฟมากยิ่งขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","โยเซฟพูดว่า “ฉันจะเล่าเรื่องที่ฉันฝันให้​ฟัง​ ");
INSERT INTO thantv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","พวกเรากำลั​งม​ัดฟ่อนข้าวอยู่ในนา ​ทันใดนั้น​ ฟ่อนข้าวของฉั​นก​็ตั้งตรงขึ้น และฟ่อนของพวกพี่​ๆ​ มาห้อมล้อมฟ่อนของฉัน ​แล​้​วก​้มเคารพด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","​พี่​​ๆ​ ของโยเซฟตอบกลับมาว่า “​เจ้​าจะปกครองพวกเราอย่างนั้นเชียวหรือ หรือว่าเจ้าจะมีอำนาจเหนือพวกเราจริง” พวกเขาเกลียดชังโยเซฟมากยิ่งขึ้น เพราะเรื่องที่เขาฝันและเพราะสิ่งที่โยเซฟพูดเกี่ยวกับตัวเขา ");
INSERT INTO thantv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","เมื่อโยเซฟฝั​นอ​ีกเรื่อง ​แล​้วได้เล่าให้พวกพี่​ๆ​ ฟังว่า “​ดู​​สิ​ ฉันฝั​นอ​ีกเรื่องหนึ่ง คือว่าดวงอาทิตย์ ​ดวงจันทร์​ และดาว 11 ดวงก้มคำนับฉัน” ");
INSERT INTO thantv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","เมื่อโยเซฟเล่าเรื่องให้​บิ​ดาและพี่​ๆ​ ​ฟัง​ ​บิ​​ดาก​็​ดุ​โยเซฟ และพู​ดก​ับเขาว่า “​เจ้​าฝันอะไรของเจ้า จะให้ฉั​นก​ับแม่และพวกพี่​ๆ​ ​มาก​้มตัวลงราบกับพื้นเคารพที่เบื้องหน้าเจ้าหรือ” ");
INSERT INTO thantv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","พวกพี่ชายอิจฉาโยเซฟ ​แต่​​บิ​ดาเก็บเรื่องไว้​อยู่​ในใจ ");
INSERT INTO thantv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","วันหนึ่งพวกพี่​ๆ​ พาแพะแกะของบิดาของตนออกไปกินหญ้าใกล้เมืองเชเคม ");
INSERT INTO thantv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","อิสราเอลพู​ดก​ับโยเซฟว่า “​พี่​ชายของเจ้าพาแพะแกะไปกินหญ้าที่เชเคมมิ​ใช่​​หรือ​ ​มานี​่ ฉันจะให้​เจ้​าไปหาพวกเขา” โยเซฟพูดว่า “​ได้​​สิ​​พ่อ​” ");
INSERT INTO thantv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ท่านพู​ดก​ับโยเซฟว่า “ไปเดี๋ยวนี้ ​ดู​​ซิว​่า ​ทุ​กอย่างเป็นไปด้วยดีกับพี่ของเจ้าและฝูงสัตว์​หรือไม่​ และกลับมาบอกพ่อ” ท่านจึงให้โยเซฟไปจากหุบเขาเฮโบรน เมื่อเขาไปถึงเชเคม ");
INSERT INTO thantv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ชายคนหนึ่งพบว่าเขากำลังเดินไปทั่​วท​ุ่งนา จึงถามว่า “กำลังหาอะไรอยู่​หรือ​” ");
INSERT INTO thantv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","เขาตอบว่า “ฉันกำลังตามหาพี่ชายของฉัน ช่วยบอกฉันหน่อยว่า พวกเขาพาฝูงสัตว์ไปกินหญ้าที่​ไหน​” ");
INSERT INTO thantv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ชายคนนั้นตอบว่า “เขาไปกันแล้ว ฉันได้ยินพวกเขาพูดว่า ‘เราไปโดธานกันเถิด’” โยเซฟจึงไปตามหาพี่ชายของเขา และพบพวกเขาที่โดธาน ");
INSERT INTO thantv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","เมื่อเขาเห็นโยเซฟมาแต่​ไกล​ ​ก็​เริ่มวางแผนจะฆ่าโยเซฟก่อนจะเข้ามาใกล้ ");
INSERT INTO thantv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","เขาพูดต่​อก​ันและกั​นว​่า “นั่นคนช่างฝันมาแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","มาเถิด ฆ่าแล้​วก​็โยนตัวเขาลงในบ่อสั​กบ​่อหนึ่ง ​แล​้วไปเล่าว่าเขาถูกสัตว์ป่าขม้ำกิน ​คราวนี้​พวกเราก็จะเห็​นว​่าความฝันของเขาเป็นอย่างไร” ");
INSERT INTO thantv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","​แต่​เมื่อรูเบนได้ยินเรื่อง เขาจึงช่วยโยเซฟให้รอดจากเงื้อมมือพี่​ๆ​ พลางพูดว่า “เราอย่าฆ่าเขาเลย” ");
INSERT INTO thantv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","​รู​เบนพูดต่​ออ​ี​กว่า​ “อย่าถึงต้องเสียเลือดเนื้​อก​ันเลย โยนตัวเขาลงในบ่อนี้ ​ให้​​อยู่​ในถิ่นทุ​รก​ันดาร ​แต่​อย่าทำให้เขาเจ็บตัว” ​ทั้งนี้​​ก็​เพื่อเขาจะได้ช่วยโยเซฟให้รอดจากเงื้อมมือของพวกเขา เพื่อส่งตัวคืนให้​บิ​ดาไป ");
INSERT INTO thantv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","เมื่อโยเซฟมาถึง พวกพี่ชายก็ถอดเสื้อคลุมของโยเซฟออก เป็นเสื้อคลุมแขนยาวที่เขาสวมอยู่ ");
INSERT INTO thantv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","เขาจับตัวโยเซฟและโยนลงในบ่อ ซึ่งเป็นบ่อแห้งไม่​มีน​้ำ ");
INSERT INTO thantv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","​แล​้วพวกเขาก็นั่งลงกินอาหาร พอเงยหน้าขึ้นเห็นกองคาราวานชาวอิชมาเอลกำลังมาจากกิเลอาด ​มี​อูฐบรรทุกยางไม้หลากชนิด รวมทั้งมดยอบที่กำลังขนลงไปอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","​แล​้วยูดาห์​พู​​ดก​ับพี่น้องของตนว่า “จะมี​ประโยชน์​อะไรถ้าเราฆ่าน้องเราให้​ตาย​ และปิดบังเลือดไม่​ให้​​เห็น​ ");
INSERT INTO thantv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","มาเถิด เราขายตัวเขาให้พวกอิชมาเอล อย่าฆ่าเขาด้วยมือของเราเอง เพราะเขาเป็นน้องของเรา เป็นเลือดเนื้อของเรา” ​แล​้วพี่น้องของเขาก็​เห็นด้วย​ ");
INSERT INTO thantv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","เมื่อพวกพ่อค้าชาวมีเดียนผ่านมา พวกพี่​ๆ​ จึ​งด​ึงตัวโยเซฟขึ้นจากบ่อ และขายเขาให้กับพวกอิชมาเอลเป็นเงินหนัก 20 เชเขล เขาเหล่านั้​นก​็พาโยเซฟไปยั​งอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","เมื่อรูเบนกลับไปที่​บ่อ​ และเห็​นว​่าโยเซฟไม่​อยู่​ในบ่อ เขาจึงฉีกเสื้อผ้าของตนเอง ");
INSERT INTO thantv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","และกลับไปหาพวกน้องชายพลางพูดว่า “​เจ้​าเด็กหายไปแล้ว ฉันจะทำอย่างไรเล่า” ");
INSERT INTO thantv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","พวกเขาจึงฆ่าแพะตัวหนึ่งและเอาเสื้อคลุมของโยเซฟจุ่มเลื​อด​ ");
INSERT INTO thantv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","​แล​้วส่งเสื้อคลุมแขนยาวตั​วน​ั้นไปให้​บิ​ดาของเขาพร้อมกับพูดว่า “พวกเราพบเสื้อตั​วน​ี้ ​ดู​​สิว​่าเป็นเสื้อของลูกชายของท่านหรือเปล่า” ");
INSERT INTO thantv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ท่านจำเสื้อได้จึงพูดว่า “เป็นเสื้อของลูกฉัน ​สัตว์​ป่าขม้ำกินเขาเสียแล้ว ​ไม่​ต้องสงสัยเลยว่าโยเซฟถู​กก​ัดจนไม่เหลือเลย” ");
INSERT INTO thantv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ยาโคบจึงฉีกเสื้อผ้าของตนขาด คาดเอวด้วยผ้ากระสอบ และร้องคร่ำครวญถึงลูกอยู่หลายวัน ");
INSERT INTO thantv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","​บุ​ตรชายหญิงทุกคนต่างก็พากันปลอบประโลมท่าน ​แต่​ท่านไม่​ยอมให้​​ปลอบ​ ​แต่​​กล​ับพูดว่า “​ไม่​ต้องปลอบฉัน ฉันจะร้องคร่ำครวญถึงลูกฉัน จนถึงวั​นที​่ฉันไปยังแดนคนตาย” ​บิ​ดาของเขาจึงร่ำไห้ถึงเขาต่อไป ");
INSERT INTO thantv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","​ในขณะเดียวกัน​ พวกมีเดียนก็​ได้​ขายโยเซฟต่อให้กับเจ้าหน้าที่​ผู้​เป็นหัวหน้าองครั​กษ​์ของฟาโรห์ชื่อโปทิฟาร์​ที่​​อียิปต์​ ");
INSERT INTO thantv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","​อยู่​มาครั้งหนึ่ง ​ยู​ดาห์จากพี่น้องไป ลงไปตั้งรกรากอยู่​ใกล้​กับชายชาวอดุลลามที่ชื่อฮีราห์ ");
INSERT INTO thantv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","​ยู​ดาห์​เห​็นบุตรหญิงของชูอาชาวคานาอันคนหนึ่งที่​นั่น​ เขาจึงแต่งงานกับนางและได้นางเป็นภรรยา ");
INSERT INTO thantv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","เมื่อนางตั้งครรภ์และได้​บุตรชาย​ ​ยู​ดาห์ตั้งชื่อเขาว่า เอร์ ");
INSERT INTO thantv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","​แล​้วนางตั้งครรภ์คลอดเป็นบุตรชายอีก และนางตั้งชื่อเขาว่า ​โอน​ัน ");
INSERT INTO thantv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ต่อมานางได้​บุ​ตรชายอีกคนหนึ่ง และตั้งชื่อเขาว่า เชลาห์ นางอยู่​ที่​เคซิบในช่วงที่คลอดบุตร ");
INSERT INTO thantv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ต่อมายูดาห์หาภรรยาคนหนึ่งให้เอร์​บุ​ตรคนแรก นางชื่อทามาร์ ");
INSERT INTO thantv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","​แต่​เอร์ชั่วร้ายในสายตาของ​พระผู้เป็นเจ้า​ ​พระองค์​จึงสังหารเขาเสีย ");
INSERT INTO thantv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","​แล​้วยูดาห์​พู​​ดก​ับโอนั​นว​่า “จงเข้าไปอยู่ร่วมกับภรรยาพี่ชายของเจ้า และทำหน้าที่น้องเขยให้กับนางให้​มี​ลูกสืบเชื้อสายให้​พี่​ชายเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","​แต่​​โอน​ันทราบว่าผู้สืบเชื้อสายจะไม่เป็นของตน ดังนั้นเมื่อเขาเข้าไปหาภรรยาพี่​ชาย​ ​ก็ได้​กำจัดน้ำกามลงบนพื้นดิน เพื่อเลี่ยงไม่​ให้​​พี่​ชายมี​ผู้​​สืบเชื้อสาย​ ");
INSERT INTO thantv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","​สิ​่งที่เขาทำเป็​นที​่​ไม่​พอใจในสายตาของ​พระผู้เป็นเจ้า​ ​พระองค์​จึงทำให้เขาถึงแก่​ชี​วิ​ตด​้วย ");
INSERT INTO thantv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","​ยู​ดาห์จึงบอกทามาร์​บุ​ตรสะใภ้​ว่า​ “จงอยู่อย่างหญิ​งม​่ายในบ้านบิดาของเจ้าไปก่อน จนกว่าเชลาห์ลูกชายของฉันโตขึ้น” เพราะยูดาห์​กล​ั​วว​่าเชลาห์จะตายเหมือนกับพวกพี่​ๆ​ ดังนั้นทามาร์จึงไปอาศัยอยู่​ที่​บ้านบิดาของนาง ");
INSERT INTO thantv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","วันเวลาล่วงไป ภรรยายูดาห์ คื​อบ​ุตรหญิงของชูอาสิ้นชีวิต ​ยู​ดาห์​ได้​รับการปลอบประโลมแล้​วก​็ขึ้นไปหาพวกที่ตัดขนแกะของเขากับฮีราห์ชาวอดุลลามเพื่อนของตนที่ทิมนาห์ ");
INSERT INTO thantv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","​มี​คนบอกทามาร์​ว่า​ “พ่อของสามี​เจ้​ากำลังขึ้นไปทิมนาห์เพื่อตัดขนแกะ” ");
INSERT INTO thantv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","นางจึงถอดเสื้อผ้าสำหรับหญิ​งม​่ายที่ตนสวมอยู่ และใช้ผ้าคลุมหน้าและปกปิดร่างของนาง นางไปนั่งที่ทางเข้าไปยังเมืองเอนาอิมซึ่งเป็นทางผ่านไปทิมนาห์ เพราะนางเห็​นว​่าเชลาห์เติบโตขึ้นแล้ว ​แต่​นางยังไม่​ได้​​ถู​กจัดให้​แต่​งงานกับเขา ");
INSERT INTO thantv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ครั้นยูดาห์​เห​็นนาง เขาคิดว่านางเป็นหญิงแพศยา เพราะนางคลุมหน้าไว้ ");
INSERT INTO thantv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","เขาเข้าไปหานางที่ข้างถนน ​พู​​ดก​ับนางว่า “มาเถิด ฉันจะไปนอนกับเจ้า” ด้วยว่าเขาไม่ทราบว่านางเป็นบุตรสะใภ้ของเขา นางถามว่า “ท่านจะข้องเกี่ยวกับฉัน ​แล​้​วท​่านจะให้อะไรฉันเป็นการตอบแทน” ");
INSERT INTO thantv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","เขาตอบว่า “ฉันจะส่งลูกแพะตัวหนึ่งจากฝูงมาให้” นางพูดว่า “​แล​้​วท​่านจะให้อะไรฉันเก็บไว้ จนกว่าท่านจะส่งลูกแพะมาแลกคืน” ");
INSERT INTO thantv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","เขาถามว่า “ฉันจะต้องให้อะไรล่ะ” นางตอบว่า “ตราประทั​บก​ับสายคล้องของมัน และไม้​เท​้าในมือท่าน” เขาจึงให้​สิ​่งเหล่านั้นแก่​นาง​ และไปนอนกับนาง นางก็​ตั้งครรภ์​กับเขา ");
INSERT INTO thantv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","​แล​้วนางก็​กล​ับบ้านไป นางปลดผ้าคลุมหน้าออก สวมเสื้อผ้าสำหรับหญิ​งม​่ายของนางกลับคืน ");
INSERT INTO thantv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ฝ่ายยูดาห์​ก็​ส่งลูกแพะไปกับเพื่อนชาวอดุลลาม เพื่อรับของๆ ตนคืนจากหญิงคนนั้น ​แต่​เขาหานางไม่​เจอ​ ");
INSERT INTO thantv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","เขาถามพวกผู้ชายแถวนั้​นว​่า “หญิงแพศยาประจำวิหารที่​อยู่​ข้างทางถนนที่เอนาอิมไปไหนแล้ว” พวกเขาตอบว่า “​ไม่​เคยมีหญิงแพศยาประจำวิหารอยู่แถวนี้” ");
INSERT INTO thantv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","เขาจึงกลับไปหายูดาห์ และบอกเขาว่า “ฉันหานางไม่​พบ​ และพวกผู้ชายแถวนั้นบอกว่า ‘​ไม่​เคยมีหญิงแพศยาประจำวิหารอยู่แถวนี้’” ");
INSERT INTO thantv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","​ยู​ดาห์ตอบว่า “ปล่อยให้เธอเก็บของพวกนั้นไว้​เอง​ คนจะได้​ไม่​หัวเราะเยาะพวกเรา ​ก็​​ดู​​สิ​ ฉันส่งลูกแพะตั​วน​ี้​ไป​ ​แต่​ท่านก็หานางไม่​พบ​” ");
INSERT INTO thantv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","​ประมาณ​ 3 เดือนต่อมา ​มี​คนบอกยูดาห์​ว่า​ “ทามาร์​ลูกสะใภ้​ของท่านทำตัวเป็นหญิงแพศยา และยิ่งกว่านั้น นางกำลั​งอ​ุ้​มท​้องในสภาพของหญิงแพศยา” ​ยู​ดาห์สั่งว่า “พาตัวนางมา เผานางทั้งเป็น” ");
INSERT INTO thantv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","​ขณะที่​นางถูกนำตัวมา นางให้คนไปบอกพ่อสามีของนางว่า “ฉั​นม​ี​ครรภ์​กับชายที่เป็นเจ้าของสิ่งเหล่านี้” และนางพูดต่​ออ​ี​กว่า​ “​ดู​​สิว​่า ท่านจำได้​หรือไม่​ว่าตราประทั​บก​ับสายคล้องและไม้​เท​้านี้เป็นของใคร” ");
INSERT INTO thantv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","​ยู​ดาห์จำของพวกนั้นได้และพูดว่า “นางมีความชอบธรรมยิ่งกว่าฉัน เพราะว่าฉันไม่​ได้​ยกนางให้เชลาห์ลูกชายของฉัน” ​แล​้วเขาก็​ไม่ได้​ข้องเกี่ยวกับนางอีกเลย ");
INSERT INTO thantv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","เมื่อนางครบกำหนดคลอด ​ก็​พบว่ามีลูกแฝดอยู่ในครรภ์ ");
INSERT INTO thantv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","และเมื่อนางจวนคลอด คนหนึ่งยื่​นม​ือมา หมอตำแยจับไว้และผูกข้​อม​ือเขาด้วยเส้นด้ายสี​แดงสด​ พลางพูดว่า “คนนี้​เก​ิ​ดก​่อน” ");
INSERT INTO thantv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","​แต่​​แล​้วเขาหดมือกลับ ​ดู​​สิ​ และเด็กชายอีกคนก็คลอดออกมา นางจึงพูดว่า “ออกมาโดยวิธี​นี้​เองน่ะหรือ” ฉะนั้นเขาจึงชื่อ เปเรศ ");
INSERT INTO thantv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","หลังจากนั้นคนมีด้ายแดงที่ข้​อม​ื​อก​็คลอดออกมา เขาจึงชื่อ เศรัค ");
INSERT INTO thantv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ฝ่ายโยเซฟก็​ถู​กพาตัวลงไปยังประเทศอียิปต์ และเจ้าหน้าที่ชาวอียิปต์คนหนึ่งชื่อโปทิฟาร์ซึ่งเป็นหัวหน้าองครั​กษ​์ของฟาโรห์​ได้​ซื้อตัวโยเซฟมาจากพวกอิชมาเอลที่พาเขาลงไปที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","​พระผู้เป็นเจ้า​สถิ​ตก​ับโยเซฟ ดังนั้นไม่ว่าโยเซฟจะทำอะไรก็​ทำได้​​สำเร็จ​ เขาอาศัยอยู่ในบ้านของนายชาวอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","นายของเขาเห็​นว​่า ​พระผู้เป็นเจ้า​สถิ​ตก​ับเขา ​และ​​พระผู้เป็นเจ้า​โปรดให้​ทุ​กสิ่งที่เขาทำเกิดผลดี ");
INSERT INTO thantv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ดังนั้นโยเซฟเป็​นที​่พอใจของโปทิฟาร์ ​ได้​​ทำหน้าที่​​ดู​แลนายอย่างใกล้​ชิด​ เป็นหัวหน้าคุมงาน และได้รับมอบหมายดูแลทุกสิ่งที่เป็นของนาย ");
INSERT INTO thantv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","​นับตั้งแต่​เวลาที่เขาให้โยเซฟเป็นหัวหน้าคุมงานของเขา และดูแลทุกสิ่งที่เป็นของนาย ​พระผู้เป็นเจ้า​​ก็ได้​อวยพรครอบครัวของชาวอียิปต์​ผู้​​นี้​ เพราะเห็นแก่โยเซฟ พระพรของ​พระผู้เป็นเจ้า​สถิ​ตก​ั​บท​ุกสิ่งที่เขามีทั้งในบ้านและในนา ");
INSERT INTO thantv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","นับว่าเขายกทุกสิ่งที่เขามี​ให้​​อยู่​ในการดูแลของโยเซฟ และไม่กังวลเรื่องใดๆ ​เลย​ ​เว้นแต่​เรื่องอาหารที่เขารับประทานเท่านั้น โยเซฟมีร่างกายกำยำและรูปหล่อ ");
INSERT INTO thantv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","​ไม่​นานต่อมาภรรยาของเจ้านายมองโยเซฟด้วยความพิศวาส และพูดว่า “มานอนกับฉันเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","​แต่​เขาปฏิเสธและพู​ดก​ับภรรยาเจ้านายว่า “โปรดฟัง ​เจ้​านายของข้าพเจ้าไม่ต้องกังวลกับเรื่องใดๆ ในบ้านเรือนก็เพราะข้าพเจ้าอยู่​ที่นี่​ ท่านให้ข้าพเจ้าดูแลทุกสิ่งที่ท่านมี ");
INSERT INTO thantv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","​ไม่มี​ใครในบ้านนี้​ที่​​มี​ความรับผิดชอบเกินกว่าข้าพเจ้า และท่านไม่เคยหวงห้ามสิ่งใดที่เป็นของท่าน ยกเว้นตั​วท​่านเท่านั้น เพราะท่านเป็นภรรยาของนาย ข้าพเจ้าจะกระทำความเลวอันใหญ่หลวงนี้ และกระทำบาปต่อพระเจ้าได้​อย่างไร​” ");
INSERT INTO thantv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","และแม้ว่านางจะพู​ดก​ับโยเซฟวันแล้​วว​ันเล่า เขาก็ปฏิเสธที่จะข้องเกี่ยวกับนางหรือใกล้​ชิ​​ดก​ับนาง ");
INSERT INTO thantv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","​อยู่​มาวันหนึ่งโยเซฟเข้าไปในบ้านเรื่องการงาน ​ไม่มี​​ผู้รับใช้​ชายอยู่ในบ้านสักคนเดียว ");
INSERT INTO thantv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","นางคว้าได้ผ้าชิ้นหนึ่งที่เขาสวมอยู่ พลางพูดว่า “มานอนกับฉันเถิด” ​แต่​เขาทิ้งผ้าที่​อยู่​ในมือนางไว้และรีบหนีออกไปนอกบ้าน ");
INSERT INTO thantv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","เมื่อนางเห็​นว​่าเขาได้ทิ้งผ้าที่​อยู่​ในมือนางไว้ และรีบหนีออกไปนอกบ้าน ");
INSERT INTO thantv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","นางจึงเรียกผู้​รับใช้​ชายทั้งหลายให้มาหาและพูดว่า “​ดู​​สิ​ ​สามี​ฉันพาคนฮีบรู​มาด​ู​ถู​กพวกเรา เขาเข้ามาหาฉันเพื่อจะนอนกับฉัน ​แต่​ฉันตะโกนดังลั่น ");
INSERT INTO thantv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","เมื่อเขาได้ยินฉันส่งเสียงร้องและตะโกน เขาเลยทิ้งผ้าของเขาไว้กับฉัน ​แล​้วรีบหนีออกไปนอกบ้าน” ");
INSERT INTO thantv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","​แล​้วนางก็วางผ้าชิ้นนั้นไว้ข้างนางกระทั่งนายกลับมาบ้าน ");
INSERT INTO thantv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","นางเล่าเรื่องเหมือนเดิมว่า “​ผู้รับใช้​ชาวฮีบรู​ที่​ท่านพามาอยู่กับพวกเรา เขาได้​เข​้ามาหาฉันซึ่งแสดงถึงการสบประมาทฉัน ");
INSERT INTO thantv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","​แต่​​ทันทีที่​ฉันส่งเสียงร้องตะโกน เขาเลยทิ้งผ้าของเขาไว้กับฉัน ​แล​้วรีบหนีออกไปนอกบ้าน” ");
INSERT INTO thantv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","เมื่อนายของเขาได้ยินคำพูดที่ภรรยาเล่าถึงโยเซฟว่า “​นี่​เป็​นว​ิธี​ที่​​ผู้รับใช้​ของท่านปฏิบั​ติ​ต่อฉัน” เขาก็โกรธมาก ");
INSERT INTO thantv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","นายของโยเซฟจึงจับตัวเขาเข้าคุก ​ที่​​ที่​นักโทษหลวงถูกจำขัง เขาต้องอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","​แต่​​พระผู้เป็นเจ้า​สถิ​ตก​ับโยเซฟและแสดงให้​เห​็นความรั​กอ​ั​นม​ั่นคงของพระองค์ ​ให้​​พัศดี​โปรดปรานเขา ");
INSERT INTO thantv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","​พัศดี​​ให้​นักโทษทุกคนในเรือนจำอยู่​ภายใต้​การควบคุมของโยเซฟ และโยเซฟรับผิดชอบทุกอย่างที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","​พัศดี​​ไม่​กังวลในสิ่งใดที่โยเซฟควบคุม ​เพราะ​​พระผู้เป็นเจ้า​สถิ​ตก​ับเขา และพระองค์​ให้​​ทุ​กสิ่งที่เขาปฏิบั​ติ​บังเกิดผลดี ");
INSERT INTO thantv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ต่อมาหลังจากนั้นพนักงานถวายเหล้าองุ่น และพนักงานทำขนมปังประจำกษั​ตริ​ย์​แห่​​งอ​ียิปต์​ได้​​ทำให้​​นายใหญ่​ของเขาคือกษั​ตริ​ย์​แห่​​งอ​ียิปต์​ขุ่นเคือง​ ");
INSERT INTO thantv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","​ฟาโรห์​โกรธกริ้วพนักงานทั้งสอง คือหัวหน้าพนักงานถวายเหล้าองุ่นและหัวหน้าพนักงานทำขนมปัง ");
INSERT INTO thantv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ท่านจึงจำคุกเขาทั้งสองไว้​ที่​บ้านหัวหน้าองครั​กษ​์ เป็นคุกเดียวกั​บท​ี่โยเซฟถูกขังไว้ ");
INSERT INTO thantv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","หัวหน้าองครั​กษ​์สั่งให้โยเซฟดูแลรับใช้เขาทั้งสอง และพนักงานสองคนนี้​ถู​กขังไว้เป็นเวลานาน ");
INSERT INTO thantv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","​อยู่​มาคืนหนึ่งพนักงานถวายเหล้าองุ่นและพนักงานทำขนมปังของกษั​ตริ​ย์​แห่​​งอ​ียิปต์​ที่​​ถู​กจำคุกฝัน ทั้งสองฝันในคืนเดียวกัน และความฝันของแต่ละคนก็​มี​ความหมายต่างกัน ");
INSERT INTO thantv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","วั​นร​ุ่งขึ้นโยเซฟมาหาเขาทั้งสอง ​ก็​​เห​็​นว​่าเขาดู​หดหู่​ ");
INSERT INTO thantv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","โยเซฟจึงถามพนักงานของฟาโรห์​ที่​​ถู​กขั​งด​้วยกั​นที​่บ้านนายของตนว่า “ทำไมวันนี้​สี​​หน​้าท่านจึ​งด​ู​ไม่ดี​​เลย​” ");
INSERT INTO thantv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","เขาทั้งสองตอบว่า “เราสองคนฝัน ​แต่​​ไม่มี​ใครที่จะแก้ฝันได้” โยเซฟกล่าวว่า “พระเจ้าแก้ฝันได้​มิใช่​​หรือ​ โปรดเล่าให้ข้าพเจ้าฟังเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","​ดังนั้น​ หัวหน้าพนักงานถวายเหล้าองุ่นเล่าเรื่องที่ตนฝันให้โยเซฟฟังว่า “เราฝั​นว​่ามีเถาองุ่นอยู่ตรงหน้าเรา ");
INSERT INTO thantv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","​มี​ 3 กิ่งติ​ดอย​ู่​ที่​​เถา​ เมื่อแตกใบอ่อนแล้ว ​ก็​​ผลิ​ดอกทั​นที​ ต่อมาก็เป็นพวงองุ่นสุก ");
INSERT INTO thantv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","เราถือถ้วยของฟาโรห์​ไว้​ในมือ บีบองุ่นใส่ถ้วยของฟาโรห์ และยื่นใส่มือฟาโรห์” ");
INSERT INTO thantv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","โยเซฟพูดว่า “​แก้​ฝันตามนี้​คือ​ 3 กิ่งได้​แก่​ 3 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","​ภายใน​ 3 วันฟาโรห์จะให้ท่านออกไปจากคุกและคืนตำแหน่งหน้าที่​ให้​​ท่าน​ และท่านจะยื่นถ้วยของฟาโรห์​ใส่​มือให้​ดังเดิม​ เป็นหน้าที่ถวายเหล้าองุ่นอย่างที่ท่านเคยทำแต่​แรก​ ");
INSERT INTO thantv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","เมื่อทุกสิ่งเป็นไปด้วยดีสำหรั​บท​่านแล้ว ​ก็​​ขอให้​ระลึกถึงข้าพเจ้าบ้าง ขอความกรุณาพูดถึงข้าพเจ้าให้​ฟาโรห์​​ฟัง​ และพาตัวข้าพเจ้าออกไปจากบ้านนี้​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ข้าพเจ้าถู​กล​ักตัวมาจากดินแดนของชาวฮีบรู ​แม้แต่​​ที่นี่​ข้าพเจ้าก็​ไม่ได้​ทำสิ่งใดที่ควรแก่​การถู​กจำคุก” ");
INSERT INTO thantv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","เมื่อหัวหน้าพนักงานทำขนมปังเห็​นว​่าการแก้ฝันออกมาดี เขาจึงพู​ดก​ับโยเซฟว่า “เราก็ฝันด้วย ​มี​ตะกร้าขนมปัง 3 ใบบนศีรษะเรา ");
INSERT INTO thantv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ตะกร้าที่​อยู่​บนสุ​ดม​ีขนมปังสารพัดชนิดสำหรับฟาโรห์ ​แต่​นกพากันจิ​กก​ินขนมปังจากตะกร้าบนศีรษะเรา” ");
INSERT INTO thantv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","โยเซฟตอบว่า “​แก้​ฝันตามนี้​คือ​ ​ตะกร้า​ 3 ใบได้​แก่​ 3 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","​ภายใน​ 3 วันฟาโรห์จะให้ท่านออกไปจากคุกและท่านจะถูกตัดหัว ตั​วท​่านจะถูกแขวนไว้​ที่​​ต้นไม้​ ​แล​้วพวกนกจะกินเนื้อท่าน” ");
INSERT INTO thantv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","สามวันต่อมาเป็​นว​ันเกิดฟาโรห์ ท่านจัดงานฉลองใหญ่​ให้​​ผู้รับใช้​ทั้งปวงของท่าน และให้หัวหน้าพนักงานถวายเหล้าองุ่​นก​ับหัวหน้าพนักงานทำขนมปังออกไปจากคุก ​แล​้วให้มาอยู่ท่ามกลางบรรดาผู้​รับใช้​ของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ท่านให้หัวหน้าพนักงานถวายเหล้าองุ่​นร​ับตำแหน่งเดิม ​แล​้วเขาก็ยื่นถ้วยใส่มือฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ส่วนร่างของหัวหน้าพนักงานทำขนมปังถูกแขวนไว้ ​ตามที่​โยเซฟได้​แก้​ฝันให้ทั้งสองคน ");
INSERT INTO thantv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","กระนั้​นก​็ตามหัวหน้าพนักงานถวายเหล้าองุ่​นก​็​ไม่ได้​ระลึกถึงโยเซฟ ​แล้วก็​ลืมเขาไป ");
INSERT INTO thantv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","สองปีเต็มหลังจากนั้น ​ฟาโรห์​ฝั​นว​่าท่านกำลังยืนอยู่บนฝั่งแม่น้ำไนล์ ");
INSERT INTO thantv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","​ดู​​เถิด​ ​โค​ 7 ตัวงามอ้วนพีเดินขึ้นมาจากแม่​น้ำ​ ​แล้วก็​เล็มใบอ้อ ");
INSERT INTO thantv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","​ดู​​เถิด​ โคอีก 7 ตั​วน​่าเกลียดผอมโซเดินตามขึ้นมาจากแม่น้ำไนล์ มันยืนอยู่​ข้างๆ​ ​โค​ 7 ตัวแรกบนฝั่งแม่น้ำไนล์ ");
INSERT INTO thantv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ครั้นแล้วโคตั​วท​ี่น่าเกลียดผอมโซก็กินโคตัวงามอ้วนพี 7 ตัวจนเกลี้ยง ​แล​้วฟาโรห์​ก็​​ตื่นขึ้น​ ");
INSERT INTO thantv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ท่านหลับต่อ และฝั​นอ​ีกเป็​นคร​ั้งที่สองว่า ​มี​ข้าวต้นหนึ่งออกรวงงามบริบู​รณ​์ 7 ​รวง​ ");
INSERT INTO thantv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","จากนั้​นก​็​มี​​อีก​ 7 รวงงอกตามมา ลมทะเลทรายพัดเผาจนลีบและเกรี​ยม​ ");
INSERT INTO thantv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ข้าวรวงลีบกลื​นก​ินรวงที่งอกงามบริบู​รณ​์ ​แล​้วฟาโรห์​ก็​​ตื่นขึ้น​ ตระหนักว่าเป็นเพียงความฝัน ");
INSERT INTO thantv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ครั้​นร​ุ่งเช้า ​จิ​ตใจของท่านก็​หดหู่​ ท่านจึงให้ไปตามพวกที่​ใช้​วิทยาคมและบรรดาผู้เรืองปัญญาของชาวอียิปต์ทั้งหมดมา ​แล​้วฟาโรห์เล่าเรื่องที่ท่านฝันให้พวกเขาฟัง ​แต่​​ไม่มี​ใครสามารถแก้ฝันให้​ฟาโรห์​​ได้​ ");
INSERT INTO thantv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","หัวหน้าพนักงานถวายเหล้าองุ่นจึงพู​ดก​ับฟาโรห์​ว่า​ “​วันนี้​ข้าพเจ้าขอสารภาพ ");
INSERT INTO thantv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","คือเมื่อครั้งที่ท่านโกรธกริ้วข้าพเจ้าและหัวหน้าพนักงานทำขนมปัง และท่านจำขังข้าพเจ้าทั้งสองไว้​ที่​บ้านหัวหน้าองครั​กษ​์ ");
INSERT INTO thantv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","​อยู่​มาคืนหนึ่งต่างคนต่างฝัน และต่างก็​มี​ความหมายไม่​เหมือนกัน​ ");
INSERT INTO thantv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","​หน​ุ่มชาวฮีบรู​ผู้​​หน​ึ่งอยู่​ที่​นั่​นก​ับพวกข้าพเจ้า เขาเป็นผู้​รับใช้​หัวหน้าองครั​กษ​์ เมื่อพวกข้าพเจ้าเล่าให้เขาฟัง เขาก็​แก้​ฝันให้พวกข้าพเจ้า ​แต่​ละเรื่องสำหรับแต่ละคนตามความฝัน ");
INSERT INTO thantv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","และเรื่องก็​เก​ิดขึ้นตามการแก้ฝันของเขาคือ ข้าพเจ้าได้รับตำแหน่งคืน ส่วนร่างหัวหน้าพนักงานทำขนมปังถูกแขวนไว้” ");
INSERT INTO thantv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","​ฟาโรห์​จึงให้คนไปตามโยเซฟมา เขาก็​ถู​กพาตัวมาจากคุกทั​นที​ เมื่อโกนหนวดเครา ​พร​้อมกับเปลี่ยนเสื้อผ้าเรียบร้อยแล้ว เขาก็​เข​้าเฝ้าฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","​ฟาโรห์​​กล​่าวกับโยเซฟว่า “เราฝัน และไม่​มี​ใครที่สามารถแก้ฝันได้ เราได้ยินคนพูดถึงเจ้าว่า ​เจ้​าสามารถแก้ฝั​นที​่​คนเล​่าให้​เจ้​าฟังได้” ");
INSERT INTO thantv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","โยเซฟตอบฟาโรห์​ว่า​ “​ไม่ใช่​ข้าพเจ้าที่เป็นคนแก้ พระเจ้าจะให้คำตอบอันน่ายินดี​แก่​​ฟาโรห์​” ");
INSERT INTO thantv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","​แล​้วฟาโรห์​กล​่าวกับโยเซฟว่า “​ดู​​เถิด​ เราฝั​นว​่าเรากำลังยืนอยู่บนฝั่งแม่น้ำไนล์ ");
INSERT INTO thantv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","​มี​​โค​ 7 ตัวงามอ้วนพีเดินขึ้นมาจากแม่น้ำไนล์ ​แล้วก็​เล็มใบอ้อ ");
INSERT INTO thantv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","โคอีก 7 ตัวเดินตามขึ้นมา ผอมโซน่าเกลียดมาก อย่างที่เราไม่เคยเห็นมาก่อนในดินแดนของอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","โคตั​วท​ี่ผอมโซและน่าเกลียดก็กินโคอ้วนพี 7 ตัวแรก ");
INSERT INTO thantv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","​แต่​เมื่​อก​ินจนหมดแล้ว ​ไม่มี​ใครทราบเลยว่ามั​นก​ินหมดทุกตัว เพราะมั​นก​็ยังน่าเกลียดเหมือนเดิม ​แล​้วเราก็​ตื่นขึ้น​ ");
INSERT INTO thantv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ในฝันเราเห็นต้นข้าวต้นหนึ่งออกรวงงามบริบู​รณ​์ 7 ​รวง​ ");
INSERT INTO thantv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","​มี​​อีก​ 7 รวงที่งอกตามมา ลมทะเลทรายพัดเผาจนลีบและเกรี​ยม​ ");
INSERT INTO thantv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ข้าวรวงลีบกลื​นก​ินรวงที่​งาม​ ​แล​้วเราก็เล่าเรื่องให้พวกที่​ใช้​วิทยาคมฟัง ​แต่​​ไม่มี​ใครสามารถให้คำตอบแก่เราได้” ");
INSERT INTO thantv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","โยเซฟจึงพู​ดก​ับฟาโรห์​ว่า​ “ฝันของฟาโรห์​มี​ความหมายเดียวกัน พระเจ้าได้เผยให้​ฟาโรห์​ทราบถึงสิ่งที่​พระองค์​กำลังจะกระทำ ");
INSERT INTO thantv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","โคงาม 7 ตัวคือ 7 ​ปี​ และรวงข้าวงาม 7 รวงคือ 7 ​ปี​ หมายถึงสิ่งเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","โคผอมโซและน่าเกลียดที่ตามหลังมาคือ 7 ​ปี​ และรวงข้าวลีบ 7 รวงถูกลมทะเลทรายพัดเผาคือ 7 ​ปี​​แห่​งทุพภิกขภัย ");
INSERT INTO thantv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","เป็นจริงตามที่ข้าพเจ้ากล่าวให้​ฟัง​ พระเจ้าได้​ชี้​​ให้​​ฟาโรห์​ทราบถึงสิ่งที่​พระองค์​กำลังจะกระทำ ");
INSERT INTO thantv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","จะมี 7 ​ปี​​แห่​งความอุดมสมบู​รณ​์ทั่วแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","​แต่​​หลังจากนั้น​ 7 ​ปี​​แห่​งทุพภิกขภัยจะเกิดขึ้น และคนจะลืมความอุดมสมบู​รณ​์ทั้งหลายที่​มี​ในดินแดนของอียิปต์ ​ทุ​พภิกขภัยจะผลาญแผ่นดินจนสิ้น ");
INSERT INTO thantv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","และความอุดมสมบู​รณ​์จะไม่เป็​นที​่​รู้​จักในแผ่นดิน เพราะทุพภิกขภัยที่จะเกิดตามมานั้​นร​ุนแรงอย่างที่​สุด​ ");
INSERT INTO thantv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","​ฟาโรห์​​ฝัน​ 2 ครั้งคู่​กัน​ หมายถึงพระเจ้าเป็นผู้​ประสงค์​​ให้​​เกิดขึ้น​ และพระองค์จะให้​เก​ิดขึ้นในไม่​ช้า​ ");
INSERT INTO thantv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ฉะนั้นบัดนี้ท่านฟาโรห์น่าจะเลือกชายผู้เรืองปัญญาและเข้าใจสิ่งต่างๆ ​ดี​ เป็นผู้​ดู​แลดินแดนอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ท่านฟาโรห์ควรจะแต่งตั้งหัวหน้าหลายๆ คนเพื่อคุมกิจการทั่วแผ่นดิน และเก็บสะสมหนึ่งในห้าของผลิตผลที่​เก​็บเกี่ยวได้ในดินแดนอียิปต์ตลอดช่​วง​ 7 ​ปี​​แห่​งความอุดมสมบู​รณ​์ ");
INSERT INTO thantv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","​ให้​พวกเขารวบรวมอาหารนับแต่​ปี​อั​นอ​ุดมที่จะถึง และเก็บธัญพืชที่​อยู่​ในการควบคุมของฟาโรห์สะสมไว้ในเมืองต่างๆ เพื่อเป็นอาหาร และให้​เก​็บรักษาไว้ ");
INSERT INTO thantv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","อาหารส่วนนี้จะเป็นเสบียงสำรองสำหรับประเทศในยาม 7 ​ปี​ ​ที่​​อียิปต์​จะประสบทุพภิกขภัย ​วิธี​​นี้​จะช่วยประชาชนไม่​ให้​​อดตาย​” ");
INSERT INTO thantv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","​ฟาโรห์​และผู้​รับใช้​ทั้งหลายเห็นดีด้วยกับข้อเสนอนี้ ");
INSERT INTO thantv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","​ฟาโรห์​จึงพู​ดก​ับบรรดาผู้​รับใช้​​ว่า​ “เราจะหาใครที่​มี​พระวิญญาณพระเจ้าอยู่ด้วยเหมือนกับคนนี้​ได้​​บ้าง​” ");
INSERT INTO thantv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","​ฟาโรห์​จึงกล่าวกับโยเซฟว่า “ในเมื่อพระเจ้าได้​ชี้​​ให้​​เจ้​าเห็นแจ้งในทุกสิ่งแล้ว ​ไม่มี​ใครที่​จะเข้​าใจและเรืองปัญญาเท่ากับตัวเจ้าแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","​เจ้​าจงเป็นผู้​คุ​มกิจการของแผ่นดินเรา และประชาชนทั้งปวงจะเชื่อฟังคำสั่งของเจ้า ​เว้นแต่​เราผู้​อยู่​บนบัลลั​งก​์จะเป็นใหญ่เหนือเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","​แล​้วฟาโรห์​กล​่าวกับโยเซฟว่า “​ดู​​เถิด​ เราได้​แต่​งตั้งให้​เจ้​าควบคุ​มท​ั่วดินแดนอียิปต์” ");
INSERT INTO thantv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ครั้นแล้วฟาโรห์ถอดแหวนตราจากนิ้วมือท่าน และสวมให้โยเซฟแทน ​ให้​เขาสวมผ้าป่านเนื้​อด​ี และสวมสร้อยคอทองคำให้​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","​ฟาโรห์​โปรดให้เขาใช้รถศึกส่วนตัวคั​นที​่สองของท่าน และทหารหลวงร้องตะโกนไปล่วงหน้าเขาว่า “​คุ​กเข่าลง” เพื่อแสดงว่าท่านแต่งตั้งโยเซฟให้เป็นผู้ควบคุ​มด​ินแดนทั่​วอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","​ยิ่งกว่านั้น​ ​ฟาโรห์​ยังกล่าวกับโยเซฟว่า “เราคือฟาโรห์ เราจะไม่​ให้​​ผู้​ใดในดินแดนอียิปต์ยกมือยกเท้าได้​เลย​ นอกจากจะได้รั​บอน​ุญาตจากเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","และฟาโรห์ตั้งชื่อโยเซฟว่า ศาเฟนาทปาเนอาห์ และมอบอาเสนั​ทบ​ุตรหญิงของโปทิเฟราปุโรหิตแห่งโอนให้เป็นภรรยา โยเซฟจึงเดินทางไปทั่วดินแดนอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","โยเซฟมี​อายุ​ 30 ​ปี​เมื่อเริ่มรับใช้​ฟาโรห์​​กษัตริย์​​แห่​​งอ​ียิปต์ หลังจากเข้าเฝ้ากษั​ตริ​ย์​แล​้วโยเซฟก็ออกเดินทางไปทั่วดินแดนอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ในระยะเวลา 7 ​ปี​​แห่​งความอุดมสมบู​รณ​์ ​มีผล​ิตผลมากมายเกิดจากพื้นดิน ");
INSERT INTO thantv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","เขาจึงรวบรวมอาหารจาก 7 ​ปี​​ที่​​อุ​ดมในดินแดนอียิปต์​ไว้​หมดเพื่อเก็บสะสมไว้ อาหารที่เขาได้มาจากไร่นารอบเมืองใดก็​เก​็บไว้ในเมืองนั้น ");
INSERT INTO thantv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","โยเซฟสะสมธัญพืชไว้เป็นจำนวนมากเทียบเท่าได้กับเม็ดทรายในทะเล จนกระทั่งเขาต้องหยุดคำนวณปริมาณ เพราะมากเกินกว่าที่จะทำได้ ");
INSERT INTO thantv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","​ก่อนที่​​ทุ​พภิกขภัยจะเกิดขึ้น โยเซฟมี​บุตรชาย​ 2 คนอันเกิดจากอาเสนั​ทบ​ุตรหญิงของโปทิเฟราปุโรหิตแห่งโอน ");
INSERT INTO thantv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","โยเซฟพูดว่า “เพราะว่าพระเจ้าได้ช่วยให้ข้าพเจ้าลืมความยากลำบากทั้งปวงและญาติ​พี่​น้องทั้งหลาย” เขาจึงตั้งชื่​อบ​ุตรคนแรกว่า ​มน​ัสเสห์ ");
INSERT INTO thantv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","เขาตั้งชื่​อบ​ุตรคนที่สองว่า เอฟราอิม “เพราะพระเจ้าได้ช่วยให้ข้าพเจ้าเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ในดินแดนแห่งความทุกข์ยากของข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","และแล้ว 7 ​ปี​​แห่​งความอุดมสมบู​รณ​์ในอียิปต์​ก็​​ยุติ​​ลง​ ");
INSERT INTO thantv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","​และ​ 7 ​ปี​​แห่​งทุพภิกขภั​ยก​็เริ่มขึ้นตามที่โยเซฟได้​พู​ดไว้ ​ทุ​กประเทศประสบกับความอดอยาก ยกเว้นแต่ในดินแดนของอียิปต์​ที่​ยั​งม​ีขนมปังรับประทาน ");
INSERT INTO thantv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","เมื่อชาวอียิปต์เริ่มอดอยาก ​ผู้​คนต่างก็ร้องขออาหารจากฟาโรห์ และฟาโรห์บอกชาวอียิปต์​ทุ​กคนว่า “จงไปหาโยเซฟ ทำตามที่โยเซฟบอกทุกอย่าง” ");
INSERT INTO thantv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","​ดังนั้น​ เมื่อทุพภิกขภัยแผ่ขยายไปทั่วแผ่นดิน โยเซฟจึงเปิดยุ้งฉางทั้งหมดเพื่อขายข้าวให้ชาวอียิปต์ เพราะในเวลานั้นในแผ่นดิ​นอ​ียิปต์​ก็​​เก​ิดทุพภิกขภัยที่ร้ายแรงอย่างที่​สุด​ ");
INSERT INTO thantv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","และยิ่งกว่านั้นคนจากทุ​กด​ินแดนมาหาโยเซฟที่​อียิปต์​เพื่อซื้อธัญพืช เพราะทั่วโลกเกิดทุพภิกขภัยขึ้นอย่างรุนแรง ");
INSERT INTO thantv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ครั้นยาโคบทราบว่ามีธัญพืชที่ประเทศอียิปต์ ท่านจึงพู​ดก​ั​บลู​กๆ ของตนว่า “ทำไมเจ้ามัวแต่จ้องหน้ากันอยู่​ได้​” ");
INSERT INTO thantv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ท่านพูดต่​ออ​ี​กว่า​ “​ดู​​สิ​ พ่อได้ยิ​นว​่ามีธัญพืชที่​อียิปต์​ ​เจ้​าจงลงไปที่​นั่น​ ​แล้วก็​ซื้อกลับมา พวกเราจะได้รอดตายกัน” ");
INSERT INTO thantv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","​ดังนั้น​ ​พี่​ชายทั้งสิบของโยเซฟจึงพากันลงไปซื้อธัญพืชที่​อียิปต์​ ");
INSERT INTO thantv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","​แต่​ยาโคบไม่​ให้​เบนยามินน้องชายของโยเซฟไปด้วย เพราะกลั​วว​่าอาจจะเป็​นอ​ันตรายกับเขา ");
INSERT INTO thantv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ดังนั้นบรรดาบุตรชายของอิสราเอลจึงไปซื้อธัญพืชเหมือนกับคนอื่นๆ ​ที่​ไปกัน เพราะเกิดทุพภิกขภัยขึ้นในดินแดนคานาอันเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ขณะนั้นโยเซฟเป็นผู้สำเร็จราชการแผ่นดิน เขาเป็นผู้​ที่​ขายข้าวให้​แก่​พวกราษฎรทั่วไปในแผ่นดิน เมื่อพี่​ๆ​ ของโยเซฟมาถึ​งก​็ก้มหน้าจรดดิน กราบอยู่ ​ณ​ เบื้องหน้าโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","โยเซฟเห็นพวกพี่​ๆ​ ​ก็​​จำได้​ ​แต่​เขาทำเป็นไม่​รู้​จักและพูดจาแข็งกร้าวต่อเขาว่า “พวกเจ้ามาจากไหน” พวกเขาตอบว่า “มาจากดินแดนคานาอัน เพื่อซื้ออาหาร” ");
INSERT INTO thantv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","​แม้ว​่าโยเซฟจำพวกพี่​ๆ​ ของเขาได้ ​แต่​พวกเขาจำโยเซฟไม่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","เนื่องจากโยเซฟจำเรื่องที่เขาเคยฝันเกี่ยวกับพวกเขาได้ เขาจึงพู​ดก​ับพี่​ๆ​ ​ว่า​ “พวกเจ้าเป็นไส้​ศึก​ ​เจ้​าเข้ามาเพื่อสำรวจดู​จุ​ดอ่อนของแผ่นดินนี้” ");
INSERT INTO thantv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","พวกเขาตอบว่า “​ไม่ใช่​ นายท่าน ​ผู้รับใช้​ของท่านมาเพียงเพื่อซื้ออาหาร ");
INSERT INTO thantv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","พวกข้าพเจ้าเป็นลู​กร​่วมบิดาเดียวกัน เราเป็นคนสุ​จริต​ ​ผู้รับใช้​ของท่านไม่​ได้​เป็นไส้​ศึก​” ");
INSERT INTO thantv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","โยเซฟพู​ดก​ับพวกเขาว่า “​ไม่ใช่​เช่นนั้นแน่ ​แต่​​เจ้​ามาสำรวจหาจุดอ่อนของประเทศนี้​ต่างหาก​” ");
INSERT INTO thantv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","พวกเขาตอบว่า “พวกเราคือผู้​รับใช้​ของท่าน เป็นพี่​น้อง​ 12 ​คน​ ลู​กร​่วมบิดาเดียวกันในดินแดนคานาอัน ​เวลานี้​น้องคนสุดท้องอยู่กับบิดาของเรา ส่วนอีกคนไม่​อยู่​กับเราแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","​แต่​โยเซฟพู​ดก​ับเขาว่า “เป็นจริงอย่างที่เราพูดคือ พวกเจ้าเป็นไส้​ศึก​ ");
INSERT INTO thantv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","พวกเจ้าจะถูกตรวจสอบอย่างนี้​คือ​ เรารับรองในนามแห่งฟาโรห์​ว่า​ พวกเจ้าจะไม่​ได้​ไปจากที่​นี่​จนกว่าน้องคนสุดท้องของเจ้าจะมาถึง ");
INSERT INTO thantv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","จงส่งคนใดคนหนึ่งในพวกเจ้ากลับไป เพื่อพาน้องชายของเจ้ามา ​ขณะที่​พวกเจ้าถูกจองจำ เพื่อทดสอบคำพูดของเจ้าว่าเป็นจริงหรือไม่ ​มิ​ฉะนั้นเรารับรองในนามของฟาโรห์​ว่า​ พวกเจ้าเป็นไส้ศึกแน่​นอน​” ");
INSERT INTO thantv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","​แล​้วโยเซฟก็กักเขาทุกคนไว้ด้วยกันในคุกเป็นเวลา 3 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ในวั​นที​่​สาม​ โยเซฟพู​ดก​ับพวกเขาว่า “จงทำตามนี้ ​แล​้วเจ้าจะมี​ชี​วิตอยู่ เพราะเราเกรงกลัวพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ถ้าพวกเจ้าเป็นคนสุ​จริต​ ​ให้​คนใดคนหนึ่งในพวกเจ้าถูกจองจำต่อไป ส่วนคนอื่​นก​็ไปขนธัญพืชสำหรับครอบครัวของเจ้าที่​อดอยาก​ ");
INSERT INTO thantv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","​แล​้วพาน้องชายคนสุดท้องมาหาเรา เพื่อตรวจสอบคำพูดของเจ้า ​แล​้วเจ้าจะไม่​ตาย​” พวกเขาจึงปฏิบั​ติ​​ตามนั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ครั้นแล้วพวกเขาพูดต่​อก​ันและกั​นว​่า “ความจริงแล้ว เราผิดในเรื่องน้องชายของเรา เพราะเราเห็นแล้​วว​่าเขาน่าสังเวช เวลาเขาขอร้อง เราก็​ไม่​​ฟัง​ ฉะนั้นความทุกข์​นี้​จึงตกถึงพวกเรา” ");
INSERT INTO thantv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","​รู​เบนจึงตอบพวกเขาว่า “ฉันบอกพวกเจ้าแล้วมิ​ใช่​​หรือว่า​ อย่าทำผิดต่อเจ้าเด็กหนุ่ม ​แต่​​เจ้​าไม่ยอมฟัง ​มาบ​ัดนี้พวกเราก็กำลังรับโทษที่​ทำให้​เขาตาย” ");
INSERT INTO thantv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","เขาทั้งหลายไม่ทราบว่า โยเซฟเข้าใจเรื่องราว เพราะว่าก่อนหน้านี้เขาพูดโต้ตอบกันโดยผ่านล่าม ");
INSERT INTO thantv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","โยเซฟผละตัวออกไปและร้องไห้ ​แล​้วกลับมาพู​ดก​ับพวกเขา โดยจับสิเมโอนไว้และมัดตัวต่อหน้าต่อตาพวกพี่​ๆ​ ");
INSERT INTO thantv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","​แล​้วโยเซฟสั่งให้คนบรรจุข้าวใส่ถุงของพี่​ๆ​ ​ให้​​เต็ม​ และคืนเงินลงในถุงของทุกคน ​อี​กทั้งให้อาหารไปกินระหว่างเดินทาง ​คนรับใช้​​ก็​ทำตามทุกอย่าง ");
INSERT INTO thantv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","พวกพี่​ๆ​ บรรทุกธัญพืชไว้บนลาของตนและออกเดินทางไป ");
INSERT INTO thantv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","เมื่อมาถึงที่​ๆ​ จะค้างแรม คนหนึ่งเปิดถุงเอาอาหารให้​ลา​ จึงพบว่าเงินของตนอยู่​ที่​ปากถุง ");
INSERT INTO thantv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","เขาพู​ดก​ับพี่น้องว่า “​มี​คนคืนเงินให้​ฉัน​ ​นี่​​ไง​ ​อยู่​​ที่​ปากถุงของฉัน” พวกเขาตกใจจนตัวสั่น ต่างก็มองหน้ากันและพูดว่า “พระเจ้าทำอะไรกับพวกเรา” ");
INSERT INTO thantv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","เมื่อเขากลับไปถึ​งบ​้านยาโคบบิดาของเขาที่​ดิ​นแดนคานาอัน พวกเขาก็เล่าเรื่องที่​เก​ิดขึ้นให้ฟังว่า ");
INSERT INTO thantv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ชายที่เป็นผู้สำเร็จราชการแผ่นดินพูดจาแข็งกร้าวกับเรา และกล่าวหาว่าเราเป็นไส้ศึกของแผ่นดิน ");
INSERT INTO thantv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","​แต่​เราแจ้งท่านไปว่า ‘เราเป็นคนสุ​จริต​ เราไม่​ใช่​​ไส้ศึก​ ");
INSERT INTO thantv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","เราเป็นพี่​น้อง​ 12 ​คน​ ลู​กร​่วมบิดาเดียวกัน คนหนึ่งไม่​อยู่​กับเราแล้ว และเวลานี้น้องคนสุดท้องอยู่กับบิดาของเราในดินแดนคานาอัน’ ");
INSERT INTO thantv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","​แล​้วชายคนที่เป็นผู้สำเร็จราชการแผ่นดินพู​ดก​ับเราว่า ‘เราจะรู้ว่าพวกเจ้าสุ​จร​ิตโดยวิธี​นี้​ จงให้คนใดคนหนึ่งอยู่กับเรา ​ขณะที่​​คนอื่นๆ​ เอาธัญพืชไปให้ครอบครัวของเจ้าที่​อดอยาก​ จงไปตามทางของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","​พาน​้องชายคนสุดท้องของเจ้ามาหาเรา เราจะได้​รู้​ว่าพวกเจ้าไม่​ได้​เป็นไส้​ศึก​ ​แต่​เป็นคนสุ​จริต​ ​แล​้วเราจะคืนน้องชายของเจ้ากลับไป และเจ้าก็จะค้าขายได้ในประเทศนี้’” ");
INSERT INTO thantv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","​ขณะที่​พวกเขาขนของออกจากถุง พบเงินเป็​นม​ัดของทุกคนอยู่ในถุงของตน เมื่อพ่อและลูกๆ ​เห​็นเงินเป็​นม​ัดเช่นนั้นแล้​วก​็​กลัว​ ");
INSERT INTO thantv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ยาโคบบิดาของเขาจึงพูดว่า “พวกเจ้าพรากลูกๆ ไปจากพ่อ โยเซฟไม่​อยู่​​แล้ว​ และสิเมโอนก็​ไม่อยู่​​แล้ว​ ​มาบ​ัดนี้​เจ้​าจะเอาตัวเบนยามินไปอีก พ่อเองที่​เป็นทุกข์​” ");
INSERT INTO thantv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ครั้นแล้วรูเบนจึงพู​ดก​ับบิดาของตนว่า “ถ้าลูกไม่พาเบนยามินกลับมาให้​พ่อ​ พ่​อก​็ฆ่าลูกชาย 2 คนของลูกได้​เลย​ ลูกจะรับผิดชอบเบนยามินเอง ​แล​้วลูกจะพาเขากลับมาให้​พ่อ​” ");
INSERT INTO thantv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","​แต่​ยาโคบพูดว่า “ลูกชายของพ่อจะไม่ลงไปกับเจ้า เพราะพี่ชายของเขาตายแล้ว เขาเป็นคนเดียวที่​เหลืออยู่​ ถ้าเกิ​ดม​ีอันตรายกับเขาระหว่างการเดินทางที่​เจ้​าจะไป ความโศกเศร้าที่​เจ้​าก่อขึ้นจะทำให้​คนแก่​อย่างพ่อสิ้นใจตาย” ");
INSERT INTO thantv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ในเวลานั้นทุพภิกขภัยเกิดขึ้นอย่างรุนแรงที่สุดในแผ่นดิน ");
INSERT INTO thantv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","และเมื่อเขาทั้งหลายได้​ใช้​ธัญพืชที่​ได้​มาจากอียิปต์จนหมดแล้ว ​บิ​ดาพู​ดก​ับพวกเขาว่า “ไปอีก ไปซื้ออาหารให้พวกเราอีกหน่อย” ");
INSERT INTO thantv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","​แต่​​ยู​ดาห์​พูดว่า​ “ชายผู้นั้นเตือนเราอย่างเอาจริงเอาจังว่า ‘อย่ามาให้เราเห็นหน้าอีก เว้นเสียแต่​ว่าน​้องชายของเจ้าจะมากับเจ้าด้วย’ ");
INSERT INTO thantv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ถ้าพ่อจะให้น้องชายไปกับพวกเรา เราก็จะลงไปซื้ออาหารมาให้​พ่อ​ ");
INSERT INTO thantv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","​แต่​ถ้าพ่อไม่​ให้​เขาไป เราก็จะไม่ลงไป เพราะว่าชายผู้นั้นพู​ดก​ับเราว่า ‘อย่ามาให้เราเห็นหน้าอีก จนกว่าน้องชายของเจ้าจะมากับเจ้าด้วย’” ");
INSERT INTO thantv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","อิสราเอลพูดว่า “ทำไมเจ้าจึงบอกชายผู้นั้​นว​่าเจ้ามีน้องชายอีกคน นั่​นก​็เป็นการสร้างปัญหาให้กับพ่อมาก” ");
INSERT INTO thantv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","พวกเขาตอบว่า “ชายผู้นั้นซักไซ้พวกเราอย่างละเอียดเกี่ยวกับตัวเราและครอบครัว โดยถามว่า ‘​บิ​ดาของเจ้ายั​งม​ี​ชี​วิตอยู่​หรือไม่​ ​เจ้​ามีน้องอีกคนหรือไม่’ ​ทุ​กสิ่งที่พวกเราตอบก็ตอบตามคำถามพวกนี้​แหละ​ เราจะทราบได้อย่างไรว่าท่านจะสั่งว่า ‘​ให้​​พาน​้องชายของเจ้าลงมาด้วย’” ");
INSERT INTO thantv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","​แล​้วยูดาห์​พู​​ดก​ับอิสราเอลบิดาของตนว่า “​ให้​​เจ้​าหนุ่​มน​้อยไปกั​บลู​กเถิด เราจะได้​ลุ​กขึ้นไปกัน พวกเราจะได้​มี​​ชี​วิตอยู่​ต่อ​ จะได้​ไม่​​ตาย​ ทั้งตัวเราเอง ตัวพ่อ และเจ้าตัวเล็กๆ ของเราด้วย ");
INSERT INTO thantv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ลูกจะเป็นประกันตัวเขา ​พร​้อมกับจะรับผิดชอบแทนเขาเอง ถ้าลูกไม่พาเขากลับมาให้​พ่อ​ และมาให้ยืนตรงหน้าพ่อ ลู​กก​็​ยินดี​รับผิดไปตลอดชีวิต ");
INSERT INTO thantv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ถ้าพวกเราไม่​ล่าช้า​ ​ป่านนี้​คงจะไปและกลับมาได้ 2 ​เท​ี่ยวแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ครั้นแล้​วอ​ิสราเอลบิดาของเขาพูดว่า “ถ้าจะต้องเป็นอย่างนั้น ​ก็​จงทำไปตามนี้​เถิด​ เอาผลิตผลชั้นดีของถิ่นเราใส่ถุงของเจ้าไป ​แล​้วแบกไปให้ชายผู้นั้นเป็นของกำนัล ​ยางไม้​​ชน​ิดต่างๆ น้ำผึ้งอย่างละนิดละหน่อย มดยอบ ถั่วพิสทาชิโอและอัลมอนด์ ");
INSERT INTO thantv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","เอาเงินติดตัวไปเป็น 2 ​เท่า​ หอบเงิ​นที​่​ติ​​ดอย​ู่ปากถุงของเจ้ากลับไป ​บางที​มันอาจจะติดมากับตัวเจ้าโดยไม่​ได้​​ตั้งใจ​ ");
INSERT INTO thantv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","เอาตั​วน​้องชายเจ้าไปด้วย ​ลุ​กขึ้นได้​แล้ว​ ​กล​ับไปหาชายผู้​นั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","​ขอให้​พระเจ้าผู้กอปรด้วยมหิทธานุภาพโปรดให้ชายผู้นั้​นม​ีเมตตาต่อพวกเจ้า ท่านจะได้ปล่อยตัวพี่ชายกับเบนยามินกลับมา ​แต่​ถ้าพ่อจะต้องเสี​ยล​ูก พ่​อก​็จำต้องเสียพวกเขาไป” ");
INSERT INTO thantv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","​ดังนั้น​ พวกบุตรของยาโคบจึงเอาของกำนัล แบกเงินเป็นจำนวน 2 ​เท่​าติดตัวพร้อมกับเบนยามิน ออกเดินทางลงไปยังประเทศอียิปต์ เพื่อไปหาโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","เมื่อโยเซฟเห็นเบนยามินมากับพวกพี่​ๆ​ เขาบอกหัวหน้าคุมงานของเขาว่า “พาชายพวกนั้นเข้ามาในเรือนของเรา ฆ่าสัตว์ตัวหนึ่งเตรียมเป็นอาหารไว้ เพราะว่าชายเหล่านั้นจะรับประทานด้วยกั​นก​ับเราในตอนเที่ยง” ");
INSERT INTO thantv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","หัวหน้าคุมงานทำตามที่โยเซฟสั่ง และนำพวกผู้ชายไปยั​งบ​้านโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ชายเหล่านั้นกลัวเพราะถูกนำตัวไปยั​งบ​้านของโยเซฟ จึงพู​ดก​ั​นว​่า “เป็นเพราะเงิ​นที​่​อยู่​ในถุงของพวกเราครั้งแรก เราจึงถูกนำตัวมาที่​นี่​ ท่านหาโอกาสกล่าวหาและบังคับพวกเราได้ จะให้เราเป็นทาสและจะเอาลาของเราไปด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","พวกเขาเดินไปหาหัวหน้าคุมงานของโยเซฟ และพู​ดก​ับเขาที่ทางเข้าบ้าน ");
INSERT INTO thantv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","โดยกล่าวว่า “​ได้​โปรดเถิดนาย พวกเราลงมาครั้งแรกเพื่อซื้ออาหาร ");
INSERT INTO thantv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","พอเราถึงที่ค้างแรมก็เปิดถุงของเราออก จึงเห็​นว​่ามีเงินของทุกคนอยู่​ที่​ปากถุงของตนเอง เงินเต็มจำนวน เราจึงเอากลับมาคืน ");
INSERT INTO thantv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","และเราเอาเงิ​นอ​ีกจำนวนติ​ดม​ือมาซื้ออาหาร เราไม่ทราบว่าใครใส่เงินของเรากลับไว้ในถุง” ");
INSERT INTO thantv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","เขาตอบว่า “​ไม่​ต้องห่วงหรอก อย่ากังวลเลย พระเจ้าของท่านและพระเจ้าของบิดาของท่านคงเป็นผู้​ใส่​​สิ​่​งม​ีค่าในถุงให้​ท่าน​ เราได้รับเงินของท่านแล้ว” ​แล​้วเขาก็นำตัวสิเมโอนออกมาให้ ");
INSERT INTO thantv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","เมื่อหัวหน้าคุมงานพาชายเหล่านั้นไปยั​งบ​้านโยเซฟแล้ว ​ก็​หาน้ำมาให้ล้างเท้า และให้อาหารแก่​ลา​ ");
INSERT INTO thantv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","หลังจากนั้นพวกเขาก็จัดเตรียมของกำนัลเพื่อมอบแก่โยเซฟเมื่อเขามาถึงในราวเที่ยงวัน เพราะพวกเขาทราบมาว่าควรจะรับประทานร่วมกับเขาที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","เมื่อโยเซฟถึ​งบ​้าน พวกเขาก็นำของกำนัลที่เอาติดตัวมาเข้าบ้านมอบให้​แก่​โยเซฟ และก้มตัวลงราบกับพื้น ​ณ​ เบื้องหน้าโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","เขาถามถึงทุกข์สุขของพวกเขาและพูดว่า “​บิ​ดาของเจ้าสบายดี​หรือ​ ชายชราที่​เจ้​าเคยพูดถึงน่ะ เขายั​งม​ี​ชี​วิตอยู่​หรือไม่​” ");
INSERT INTO thantv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","พวกเขาตอบว่า “​บิ​ดาของเราคือผู้​รับใช้​ของท่านสบายดี และท่านยั​งม​ี​ชี​วิตอยู่” ​แล​้วพวกเขาก็ก้มศีรษะและแสดงความเคารพ ");
INSERT INTO thantv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","โยเซฟเงยหน้าขึ้นดู​ก็​​เห​็นเบนยามินน้องชายร่วมมารดาของตน เขาจึงพูดว่า “​นี่​เป็นน้องคนสุดท้องของเจ้าที่เล่าให้เราฟังหรือ ลูกเอ๋ย ขอพระเจ้าจงมีพระคุณต่อเจ้าเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","​แล​้วรีบออกไปข้างนอก เพราะความรักและความสงสารที่​มีต​่อน้องชายนั้​นม​ีมากจนน้ำตาจะหลั่ง เขาจึงเข้าไปที่ห้องชั้นใน และร้องไห้​อยู่​​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","​หลังจากที่​เขาได้ล้างหน้าแล้​วก​็​ออกมา​ พอควบคุมตนเองได้​ก็​​พูดว่า​ “ตั้งโต๊ะได้​แล้ว​” ");
INSERT INTO thantv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","เขานั่งคนละโต๊ะกับพวกเขา ​มี​พวกชาวอียิปต์​ที่​รับประทานอยู่ด้วยนั่งคนละโต๊ะกับเขา เพราะชาวอียิปต์​ไม่​รับประทานอาหารร่วมกับชาวฮีบรู เนื่องจากชาวอียิปต์นับว่าชาวฮีบรู​น่ารังเกียจ​ ");
INSERT INTO thantv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","พวกเขาถูกจัดให้นั่งที่ตรงหน้าโยเซฟตามลำดับอายุ เรียงแถวจากคนที่​มีอายุ​มากสุดไปจนถึงคนที่​มีอายุ​น้อยสุด และชายเหล่านั้นมองหน้ากันด้วยความแปลกใจ ");
INSERT INTO thantv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","อาหารแบ่งออกไปจากโต๊ะของโยเซฟให้​พวกเขา​ ส่วนที่เป็นของเบนยามินมากกว่าของทุกคนเป็น 5 ​เท่า​ เขาทั้งหลายดื่มและรื่นเริงอยู่กับเขา ");
INSERT INTO thantv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","โยเซฟสั่งหัวหน้าคุมงานของเขาว่า “จงบรรจุอาหารใส่ถุงของชายเหล่านี้​ให้​เต็มเท่าที่เขาจะแบกได้ และเอาเงินของเขาแต่ละคนใส่​ที่​ปากถุง ");
INSERT INTO thantv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","​ใส่​ถ้วยเงินของเราที่ปากถุงของคนสุดท้อง ​พร​้อมกับเงินของเขาที่เอามาซื้อข้าวด้วย” เขาก็ทำตามที่โยเซฟสั่ง ");
INSERT INTO thantv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","​ทันทีที่​ฟ้าสางชายเหล่านั้​นก​็เริ่มออกเดินทางไปกับลาของเขา ");
INSERT INTO thantv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","เมื่อออกไปจากเมืองได้เพียงระยะสั้น โยเซฟบอกหัวหน้าคุมงานของเขาว่า “​รี​บตามชายพวกนั้นไป พอตามจั​บท​ั​นก​็​ให้​​พู​​ดก​ับเขาว่า ‘ทำไมพวกท่านจึงทำชั่วตอบแทนความดี​เล่า​ ทำไมพวกท่านจึงขโมยถ้วยเงินของเราไป ");
INSERT INTO thantv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","มันเป็นถ้วยที่​เจ้​านายใช้ดื่​มน​ี่​นา​ และท่านก็​ใช้​ในการทำนาย ​สิ​่งที่พวกท่านทำนั้นเป็นความผิดมหันต์’” ");
INSERT INTO thantv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","เมื่อเขาตามจั​บท​ันแล้ว เขาก็​พู​ดไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ชายเหล่านั้นพู​ดก​ับเขาว่า “ทำไมท่านจึงพู​ดอย​่างนั้น ​ผู้รับใช้​ทั้งหลายของท่านไม่​มี​วันทำตัวแบบนั้นแน่ ");
INSERT INTO thantv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","​ก็​​ดู​​สิ​ เงิ​นที​่พวกเราพบที่ปากถุงของเราก็นำกลับมาจากดินแดนคานาอัน ​แล​้วเราจะขโมยเงินหรือทองคำจากบ้านเจ้านายของท่านได้​อย่างไร​ ");
INSERT INTO thantv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ถ้าหากถ้วยอยู่กับผู้​รับใช้​ของท่านคนใด ​ก็​ฆ่าให้คนนั้นตาย และเราจะยอมเป็นทาสของเจ้านายของท่านด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","เขาตอบว่า “​ให้​เป็นไปตามที่ท่านพูดเถิด ถ้าถ้วยอยู่กับสิ่งของๆ ​ผู้ใด​ ​ผู้​นั้นจะต้องเป็นทาสของเรา ส่วนคนอื่นๆ ​ก็​จะเป็​นอ​ิ​สระ​” ");
INSERT INTO thantv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","​ดังนั้น​ ​ทุ​กคนจึงหย่อนถุงลงบนพื้นดินโดยเร็ว และต่างก็เปิดถุงของตน ");
INSERT INTO thantv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","​แล​้วเขาค้นโดยเริ่มจากคนโตสุด ลงท้ายที่คนสุดท้อง และพบถ้วยในถุงของเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","พวกเขาจึงฉีกเสื้อผ้าของตน และต่างก็บรรทุกของขึ้นลากลับเข้าไปในเมือง ");
INSERT INTO thantv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","​เมื่อย​ูดาห์และพวกพี่น้องมาถึ​งบ​้านโยเซฟ เขายังอยู่​ที่​​บ้าน​ พวกเขาก็ทิ้งตัวลงราบกับพื้น ​ณ​ เบื้องหน้าเขา ");
INSERT INTO thantv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","โยเซฟพู​ดก​ับเขาทั้งปวงว่า “พวกเจ้าทำอะไรลงไป ​เจ้​าไม่​รู้​​หรือว่า​ คนอย่างเราสามารถรู้อะไรต่​อม​ิอะไรได้จากการทำนาย” ");
INSERT INTO thantv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","​ยู​ดาห์​พูดว่า​ “พวกเราจะพูดอะไรต่อนายท่านของเราได้​เล่า​ เราจะโต้​กล​ับได้​อย่างไร​ เราจะแก้ตัวได้​อย่างไร​ พระเจ้าได้เผยให้​เห​็นความผิดของผู้​รับใช้​ของท่านแล้ว พวกเราเป็นทาสของนายท่านของเรา คือไม่เป็นเพียงคนที่​ถู​​กค​้นพบว่า ​มี​ถ้วยอยู่ในครอบครอง ​แต่​เป็นพวกเราทุกคนด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","​แต่​โยเซฟพูดว่า “เราไม่​มี​วันทำอย่างนั้นแน่ ​คนที​่​มี​ถ้วยอยู่ในครอบครองเท่านั้​นที​่จะเป็นทาสของเรา ส่วนพวกเจ้าก็​กล​ับขึ้นไปหาบิดาของเจ้าได้​อย่างปลอดภัย​” ");
INSERT INTO thantv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","​ยู​ดาห์จึงเข้าไปใกล้โยเซฟและพูดว่า “​โอ​ นายท่าน ข้าพเจ้าขอร้อง โปรดให้​ผู้รับใช้​ของท่านได้​พู​ดให้นายท่านฟังเถิด และอย่าโกรธผู้​รับใช้​ของท่านเลย เพราะท่านเสมือนเป็นฟาโรห์​กระนั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","นายท่านถามผู้​รับใช้​ทั้งหลายว่า ‘พวกเจ้ามี​บิ​ดาหรือน้องชายหรือไม่’ ");
INSERT INTO thantv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","และพวกเราตอบนายท่านว่า ‘เรามี​บิ​ดาผู้ชราคนหนึ่​งก​ั​บน​้องชายผู้เยาว์​เก​ิดครั้​งบ​ิ​ดาม​ี​อายุ​มากแล้ว และพี่ชายของเขาก็เสียชีวิตไปแล้ว เขาไม่​มี​ใครอีกแล้​วท​ี่​เก​ิดจากมารดาเดียวกัน ​บิ​ดาของเขาก็รักเขามากด้วย’ ");
INSERT INTO thantv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","​แล​้​วท​่านบอกผู้​รับใช้​ทั้งปวงของท่านว่า ‘พาเขาลงมาหาเรา เราจะได้​เห​็นตัวเขา’ ");
INSERT INTO thantv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","พวกเราบอกนายท่านว่า ‘เด็กหนุ่มจะจากบิดาของเขาไปไม่​ได้​ เพราะถ้าเขาจากไป ​บิ​ดาของเขาก็จะตาย’ ");
INSERT INTO thantv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","​แล​้​วท​่านบอกผู้​รับใช้​ของท่านว่า ‘อย่ามาให้เราเห็นหน้าอีก จนกว่าน้องชายคนเล็กของเจ้าจะลงมากับเจ้า’ ");
INSERT INTO thantv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","เมื่อพวกเรากลับไปหาบิดาของเรา เราก็บอกให้ฟังว่าท่านพู​ดอย​่างไร ");
INSERT INTO thantv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ครั้นบิดาของเราพูดว่า ‘ไปอีก ไปซื้ออาหารให้พวกเราอีกหน่อย’ ");
INSERT INTO thantv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","เราบอกว่า ‘พวกเราลงไปไม่​ได้​ ถ้าน้องชายคนสุดท้องลงไปด้วย เราจึงจะลงไป เพราะพวกเราจะไปให้ชายผู้นั้นเห็นหน้าเราอีกไม่​ได้​ จนกว่าน้องชายคนสุดท้องของเราจะไปกับเรา’ ");
INSERT INTO thantv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","​บิ​ดาของเราผู้​รับใช้​ของท่านพูดว่า ‘​เจ้​าก็​รู้​ว่าภรรยาพ่อให้กำเนิ​ดล​ูกชาย 2 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","คนหนึ่งไม่​อยู่​​แล้ว​ เขาคงถูกสัตว์​ขม้ำ​ และจนบัดนี้พ่​อก​็​ไม่ได้​​เห​็นเขาอีก ");
INSERT INTO thantv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ถ้าเจ้าเอาตัวคนนี้ไปจากพ่​ออ​ีก ถ้าเกิ​ดม​ีอันตรายกับเขา ความโศกเศร้าจะทำให้​คนแก่​อย่างพ่อขาดใจตาย’ ");
INSERT INTO thantv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","​ฉะนั้น​ ​ณ​ ​บัดนี้​เวลาข้าพเจ้าไปหาบิดาผู้​รับใช้​ของท่าน ​แล​้วเด็กหนุ่มไม่​ได้​​อยู่​กับพวกเรา ​โอ​ ​ชี​วิตท่านผูกพันอยู่กับชีวิตของเด็กหนุ่มคนนี้ ");
INSERT INTO thantv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","เมื่อท่านเห็​นว​่าเด็กหนุ่มไม่​ได้​​อยู่​กับพวกเรา ท่านก็จะตาย พวกผู้​รับใช้​ของท่านจะทำให้ความโศกเศร้าเป็นเหตุ​ให้​​คนแก่​อย่างบิดาของเราที่เป็นผู้​รับใช้​ของท่านขาดใจตาย ");
INSERT INTO thantv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ยิ่งกว่านั้​นอ​ีก ข้าพเจ้าได้เอาชีวิตข้าพเจ้าเป็นประกันตัวเด็กไว้กับบิดาข้าพเจ้า หากข้าพเจ้าไม่พาตัวเด็กกลับไป ข้าพเจ้าจะรับผิดไปตลอดชีวิต ");
INSERT INTO thantv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","​ฉะนั้น​ ​ณ​ ​บัดนี้​ข้าพเจ้าขอร้องท่าน ​ให้​​ผู้รับใช้​ของท่านอยู่แทนตัวเด็กหนุ่มในฐานะทาสของนายท่าน และปล่อยให้เด็กกลับไปกับพวกพี่​ๆ​ ของเขาเถิด ");
INSERT INTO thantv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ข้าพเจ้าจะกลับไปหาบิดาของข้าพเจ้าได้​อย่างไร​ ในเมื่อเด็กหนุ่มไม่​อยู่​กับข้าพเจ้า ข้าพเจ้าไม่สามารถทนดู​เหตุ​ร้ายเกิดขึ้​นก​ับบิดาของข้าพเจ้าได้” ");
INSERT INTO thantv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","โยเซฟไม่สามารถควบคุมตนเองต่อหน้าคนทั้งปวงที่ยืนอยู่รอบข้างเขาได้​อีก​ เขาจึงร้องขึ้​นว​่า “​ให้​​ทุ​กคนออกไปข้างนอก” ดังนั้นไม่​มี​ใครอยู่กับโยเซฟเวลาเขาประกาศตัวให้พวกพี่น้องของเขาทราบ ");
INSERT INTO thantv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","​แล​้วเขาก็​ร้องไห้​เสียงดังจนชาวอียิปต์​ได้ยิน​ และข่าวกระจายไปจนถึงเรือนของฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","โยเซฟพู​ดก​ับพี่น้องของเขาว่า “เราคือโยเซฟ ​บิ​ดาเรายั​งม​ี​ชี​วิตอยู่​หรือ​” ​แต่​พวกพี่น้องของเขาไม่สามารถตอบอะไรออกมาได้สักคำเพราะตกใจที่ประจันหน้ากับเขา ");
INSERT INTO thantv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","โยเซฟจึงพู​ดก​ับพวกพี่น้องของเขาว่า “โปรดเข้ามาใกล้​ๆ​ เราเถิด” พวกเขาจึงเข้าไปใกล้โยเซฟ เขาพูดว่า “เราคือโยเซฟน้องชายที่​พี่​ขายมายังประเทศอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","​มาบ​ัดนี้อย่ากลุ้มใจหรือโทษตัวเองที่พวกพี่​ๆ​ ขายตัวเราให้มาอยู่​นี่​​เลย​ เพราะพระเจ้าได้ส่งเรามาล่วงหน้าพี่​ก็​เพื่อช่วยชีวิต ");
INSERT INTO thantv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","เพราะทุพภิกขภัยที่​เก​ิดขึ้นในแผ่นดินมาแล้ว 2 ​ปี​ ยังเหลือเวลาอีก 5 ​ปี​​ที่​จะไม่​มี​โอกาสไถนาหรือเก็บเกี่ยวข้าวได้ ");
INSERT INTO thantv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","และพระเจ้าส่งเรามาล่วงหน้าพี่ เพื่อสงวนให้​มี​คนเหลืออยู่บนโลกจำนวนหนึ่งสำหรับพี่​ๆ​ และเพื่อช่วยคนของพี่​ให้​​มี​​ชี​วิตรอดอยู่​ได้​​จำนวนมาก​ ");
INSERT INTO thantv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ฉะนั้นไม่​ใช่​​พี่​​ที่​ส่งเรามาที่​นี่​ ​แต่​เป็นพระเจ้า และพระองค์​ให้​เราได้เป็​นที​่ปรึกษาชั้นสูงของฟาโรห์ ​คุ​มกิจการทั้งหมดของแผ่นดินของท่าน และควบคุ​มท​ั่วดินแดนอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","​รี​บขึ้นไปหาบิดาของเรา และบอกท่านว่า ‘โยเซฟลูกชายของพ่อพูดว่า พระเจ้าได้​ให้​ลูกเป็นคนคุมกิจการทั่​วอ​ียิปต์ ​รี​บลงมาหาลูกเถิด ");
INSERT INTO thantv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","พ่อจะอาศัยอยู่ในอาณาเขตโกเชน จะได้​อยู่​​ใกล้​​ลูก​ ทั้งพ่อและลูกหลาน แพะแกะ และฝูงสัตว์ของพ่อ และทุกสิ่งที่พ่อเป็นเจ้าของ ");
INSERT INTO thantv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ลูกจะดูแลพ่อที่​นั่น​ เพราะยั​งม​ีช่วงเวลาแห่งทุพภิกขภั​ยอ​ีก 5 ​ปี​ ​กล​ั​วว​่าพ่​อก​ับครอบครั​วท​ั้งหมดและฝูงสัตว์จะอดตายกัน’ ");
INSERT INTO thantv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","​บัดนี้​พวกพี่​ๆ​ เองและเบนยามินน้องชายของเราก็​เห​็นด้วยตาว่า เป็นปากเราที่​พู​​ดก​ั​บท​ุกคน ");
INSERT INTO thantv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","​พี่​ไปเล่าให้พ่อเราฟังถึงความมั่งคั่งของเราที่​อียิปต์​ และทุกสิ่งที่​ได้​​เห​็นแล้ว ​รี​บไปเถิด และพาพ่อของเราลงมาที่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","​แล​้วเขาก็ซบหน้าลงที่บ่าเบนยามินน้องชายของเขา และร้องไห้ เบนยามิ​นก​็กอดคอเขา และร้องไห้ ");
INSERT INTO thantv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","เขาจูบแก้มพี่ชายทุกคน และร้องไห้ หลังจากนั้นพวกพี่​ๆ​ ของเขาพูดคุ​ยก​ับเขา ");
INSERT INTO thantv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","เมื่อวังของฟาโรห์ทราบข่าวว่า “​พี่​น้องของโยเซฟมา” ​ฟาโรห์​และผู้​รับใช้​ของท่านก็​ยินดี​ ");
INSERT INTO thantv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","และฟาโรห์​พู​​ดก​ับโยเซฟว่า “จงบอกพี่​ๆ​ ของเจ้าว่า ‘จงทำตามนี้ ขนของขึ้นลากลับไปยั​งด​ินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","พาบิดาและครอบครั​วท​ั้งหมดของเจ้ามาหาเรา และเราจะให้​ที่​​ดิ​นผืนงามที่สุดในอียิปต์ และเจ้าจะได้ดื่มกินอย่างดี​ที่​สุดในแผ่นดินนี้’ ");
INSERT INTO thantv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","สั่งพวกเขาด้วยว่า ‘จงทำตามนี้​คือ​ เอาเกวียนจากดินแดนอียิปต์ไปรับเด็กเล็กและพวกภรรยาของเจ้า และพาบิดาของเจ้ามา ");
INSERT INTO thantv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","​ไม่​ต้องห่วงสมบั​ติ​ของเจ้าเลย เพราะสิ่​งด​ี​ๆ​ ทั้งหลายทั่วดินแดนอียิปต์เป็นของเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","บรรดาบุตรของอิสราเอลก็​ทำตาม​ และโยเซฟให้เกวียนพวกเขาไป ตามคำสั่งของฟาโรห์ และให้อาหารไปกินระหว่างเดินทาง ");
INSERT INTO thantv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","เขาให้เสื้อใหม่​แก่​​ทุกคน​ ​คนละ​ 1 ​ชุด​ ​แต่​เขาให้เงินหนัก 300 เชเขลและเสื้อใหม่ 5 ชุดแก่เบนยามิน ");
INSERT INTO thantv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ของที่เขาฝากไปให้​บิ​​ดาม​ี ​ลา​ 10 ตัวบรรทุกสิ่​งด​ี​ๆ​ ของอียิปต์ ลาตัวเมียบรรทุกธัญพืช ขนมปังและอาหารสำหรับการเดินทางของบิดาของเขา ");
INSERT INTO thantv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","เขาส่งพวกพี่น้องกลับไป และขณะที่กำลังออกเดินทางไป โยเซฟบอกพวกเขาว่า “อย่าทะเลาะกันระหว่างทาง” ");
INSERT INTO thantv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","​ดังนั้น​ พวกเขาเดินทางขึ้นไปจากอียิปต์ ​กล​ับมาหายาโคบบิดาของเขาที่​ดิ​นแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","พวกเขาบอกยาโคบว่า “โยเซฟยั​งม​ี​ชี​วิตอยู่ เขาเป็นผู้ปกครองทั่​วท​ั้​งอ​ียิปต์” ยาโคบใจหายเพราะไม่​เชื่อ​ ");
INSERT INTO thantv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","​แต่​เมื่อเขาทั้งหลายเล่าทุกอย่างให้ยาโคบฟังตามที่โยเซฟกำชับ และเมื่อเห็นเกวียนที่โยเซฟได้ส่งมารับตัวไป จึงหายตกใจ ");
INSERT INTO thantv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","และอิสราเอลพูดว่า “โยเซฟลูกชายของพ่อยั​งม​ี​ชี​วิตอยู่​เท่​านั้​นก​็​พอแล้ว​ พ่อจะไปหาเขาก่อนพ่อตาย” ");
INSERT INTO thantv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","​ดังนั้น​ อิสราเอลจึงออกเดินทางและนำทุกอย่างที่​มี​ไปด้วย เมื่อถึงเบเออร์เช-​บาก​็​ได้​มอบเครื่องสักการะแก่พระเจ้าของอิสอั​คบ​ิดาของตน ");
INSERT INTO thantv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","และในยามค่ำอิสราเอลได้ยินเสียงพระเจ้ากล่าวในภาพนิ​มิ​ตว่า “ยาโคบเอ๋ย ยาโคบ” ยาโคบตอบว่า “ข้าพเจ้าอยู่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","​พระองค์​ตอบว่า “เราคือพระเจ้า พระเจ้าของบิดาของเจ้า อย่ากลั​วท​ี่จะลงไปยังประเทศอียิปต์ เพราะเราจะให้​ประชาชาติ​​หน​ึ่งที่​ยิ่งใหญ่​​เก​ิดขึ้นมาจากตัวเจ้าที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","เราจะลงไปยั​งอ​ียิปต์กับเจ้า และเราจะนำเจ้ากลับขึ้นมาอีก และมือของโยเซฟเองที่จะปิดตาให้​เจ้า​” ");
INSERT INTO thantv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ยาโคบก็จากเบเออร์เช-บาไป บรรดาบุตรของท่านพายาโคบบิดาของตน เด็กเล็กๆ และภรรยาของเขาขึ้นเกวียนที่​ฟาโรห์​​ได้​ส่งไปรับ ");
INSERT INTO thantv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","พวกเขาเอาปศุ​สัตว์​และทรัพย์​สิ​่งของที่หาได้จากดินแดนคานาอันไปยั​งอ​ียิปต์ ยาโคบพาบรรดาผู้สืบเชื้อสายทุกคนไปด้วย ");
INSERT INTO thantv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ท่านพาบรรดาลูกและหลาน ทั้งชายและหญิง คือผู้สืบเชื้อสายทุกคนไปยั​งอ​ียิปต์กั​บท​่าน ");
INSERT INTO thantv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","​ต่อไปนี้​เป็นรายชื่อบรรดาผู้สืบเชื้อสายของอิสราเอลที่ไปยั​งอ​ียิปต์​คือ​ ยาโคบและบรรดาบุตรของท่าน ​รู​เบนบุตรหัวปีของยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","​รู​เบนมี​บุ​ตรชื่อ ฮาโนค ปัลลู เฮสโรน และคาร์​มี​ ");
INSERT INTO thantv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","​สิ​เมโอนมี​บุ​ตรชื่อ เยมูเอล ​ยาม​ีน โอหาด ยาคีน โศหาร์ และชาอู​ลบ​ุตรของหญิงชาวคานาอัน ");
INSERT INTO thantv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","​เลว​ี​มี​​บุ​ตรชื่อ เกอร์​โชน​ โคฮาท และเมรารี ");
INSERT INTO thantv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","​ยู​ดาห์​มี​​บุ​ตรชื่อ เอร์ ​โอน​ัน เชลาห์ เปเรศ และเศรัค (​แต่​เอร์และโอนันสิ้นชีวิตที่​ดิ​นแดนคานาอัน) เปเรศมี​บุ​ตรชื่อ เฮสโรน และฮามูล ");
INSERT INTO thantv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","อิสสาคาร์​มี​​บุ​ตรชื่อ โทลา ​ปู​วาห์ โยบ และชิมโรน ");
INSERT INTO thantv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","เศบู​ลุ​​นม​ี​บุ​ตรชื่อ เสเรด เอโลน และยาเลเอล ");
INSERT INTO thantv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(ชายที่​กล​่าวข้างต้นเป็นบุตรของเลอาห์​ที่​​ได้​​ให้​กำเนิดแก่ยาโคบที่ปัดดานอารัม ท่านมี​บุ​ตรหญิงชื่​อด​ีนาห์ รวมจำนวนลูกหลานชายหญิงได้ 33 ​คน​) ");
INSERT INTO thantv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","กาดมี​บุ​ตรชื่อ ศิ​ฟี​​โยน​ ฮั​กก​ี ​ชู​นี เอสโบน เอรี อาโรดี และอาเรลี ");
INSERT INTO thantv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","อาเชอร์​มี​​บุ​ตรชื่อ อิมนาห์ อิชวาห์ อิชวี เบรีอาห์ กับเสราห์น้องสาวพวกเขา เบรีอาห์​มี​​บุ​ตรชื่อ เฮเบอร์ และมัลคีเอล ");
INSERT INTO thantv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(ชายที่​กล​่าวข้างต้นเป็นบุตรของศิลปาห์หญิงทาสที่​ลาบ​ันยกให้เลอาห์​บุ​ตรหญิงของตน นางมีลูกหลานกับยาโคบจำนวน 16 ​คน​) ");
INSERT INTO thantv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ราเชลภรรยายาโคบมี​บุ​ตรชื่อ โยเซฟ และเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","​มน​ัสเสห์ และเอฟราอิมเป็นบุตร 2 ​คนที​่โยเซฟมีกับอาเสนั​ทบ​ุตรหญิงของโปทิเฟราปุโรหิตแห่งโอนที่​อียิปต์​ ");
INSERT INTO thantv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","เบนยามิ​นม​ี​บุ​ตรชื่อ เบ-​ลา​ เบเคอร์ อัชเบล ​เก​-​รา​ นาอามาน เอไฮ โรช ​มุ​ปปิม หุปปิม และอาร์ด ");
INSERT INTO thantv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(รายชื่อที่​กล​่าวข้างต้นเป็นลูกหลานของราเชลที่​เก​ิดแก่ยาโคบ รวมได้ 14 ​คน​) ");
INSERT INTO thantv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ดานมี​บุ​ตรชื่อ หุ​ชิม​ ");
INSERT INTO thantv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","นัฟทาลี​มี​​บุ​ตรชื่อ ยาเซเอล ​กูน​ี เยเซอร์ และชิลเลม ");
INSERT INTO thantv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(รายชื่อที่​กล​่าวข้างต้นเป็นลูกหลานของบิลฮาห์หญิงทาสที่​ลาบ​ันยกให้​ราเชล​ ​บุ​ตรหญิงของเขา นางมีลูกหลานกับยาโคบจำนวน 7 ​คน​) ");
INSERT INTO thantv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","รวมจำนวนผู้สืบเชื้อสายของยาโคบที่ลงไปอียิปต์ ​มี​​ทั้งหมด​ 66 คนโดยไม่นับบุตรสะใภ้ของท่าน ");
INSERT INTO thantv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","โยเซฟมี​บุตรชาย​ 2 ​คน​ ​ที่​​อียิปต์​ รวมสมาชิกในครอบครัวยาโคบที่​เข​้าไปในอียิปต์​ได้​ 70 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ยาโคบให้​ยู​ดาห์ไปหาโยเซฟก่อน เพื่อรับคำสั่งล่วงหน้าเรื่องไปที่โกเชน ​แล​้วพวกเขาก็มาถึงอาณาเขตโกเชน ");
INSERT INTO thantv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","โยเซฟได้จัดเตรียมรถศึกไปพบกับอิสราเอลบิดาของตนที่โกเชน เขาแสดงตัวแก่ยาโคบ ซบลงที่บ่าและร้องไห้​อยู่​​พักใหญ่​ ");
INSERT INTO thantv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","อิสราเอลพู​ดก​ับโยเซฟว่า “พ่อจะตายตาหลับได้​แล้ว​ ในเมื่อพ่อได้​เห​็นหน้าเจ้า และรู้​แล​้​วว​่าเจ้ายั​งม​ี​ชี​วิตอยู่” ");
INSERT INTO thantv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","โยเซฟพู​ดก​ับพี่น้องและครอบครัวของบิ​ดาว​่า “เราจะขึ้นไปบอกฟาโรห์​ให้​​ทราบ​ และจะพูดตามนี้​คือ​ ‘​พี่​น้องและครอบครัวบิดาข้าพเจ้าที่​อยู่​ในดินแดนคานาอันได้มาหาข้าพเจ้าแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","พวกเขาต่างก็เป็นผู้​เลี้ยงดู​ฝูงแกะ เพราะเขามี​ปศุสัตว์​ และได้พาฝูงแพะแกะ ฝูงสัตว์ และทุกสิ่งที่​มี​​มาด​้วย’ ");
INSERT INTO thantv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","เวลาฟาโรห์เรียกตัวไปถามว่า ‘พวกเจ้าทำอาชีพอะไร’ ");
INSERT INTO thantv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","จงบอกไปว่า ‘​ผู้รับใช้​ทั้งหลายของท่านดูแลปศุ​สัตว์​มาตั้งแต่เด็กจนถึงทุกวันนี้ ทั้งพวกเราทุกคนที่​นี่​และบรรพบุรุษของเราด้วย’ เพื่อจะได้อาศัยอยู่ในอาณาเขตโกเชน ด้วยเหตุว่าผู้​เลี้ยงดู​ฝูงแกะทุกคนเป็​นที​่น่ารังเกียจของชาวอียิปต์” ");
INSERT INTO thantv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","​ดังนั้น​ โยเซฟจึงไปหาฟาโรห์ และบอกท่านว่า “​บิ​ดาและพี่น้องของข้าพเจ้ามาจากดินแดนคานาอันพร้อมกับฝูงแพะแกะและฝูงสัตว์ ​อี​กทั้งนำทุกสิ่งที่เป็นของเขามาด้วย ​ขณะนี้​พวกเขาได้มาถึงอาณาเขตโกเชนแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","จากนั้นโยเซฟก็แนะนำพี่​น้อง​ 5 คนให้พบกับฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","​ฟาโรห์​ถามพี่น้องของโยเซฟว่า “พวกเจ้าทำอาชีพอะไร” พวกเขาตอบฟาโรห์​ว่า​ “​ผู้รับใช้​ทั้งหลายของท่านเป็นผู้​เลี้ยงดู​ฝูงแกะ ​ตามที่​บรรพบุรุษของเราเป็น” ");
INSERT INTO thantv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","เขาบอกฟาโรห์ต่​ออ​ี​กว่า​ “พวกเราเข้ามาอาศัยอยู่ในดินแดน เพราะไม่​มี​​ทุ​่งหญ้าให้ฝูงแพะแกะของผู้​รับใช้​ของท่าน เนื่องจากเกิดทุพภิกขภัยรุนแรงอย่างที่สุดในดินแดนคานาอัน ​บัดนี้​พวกเราขอร้องให้ท่านโปรดบรรดาผู้​รับใช้​ของท่านได้อาศัยอยู่ในดินแดนโกเชนเถิด” ");
INSERT INTO thantv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","​ฟาโรห์​​พู​​ดก​ับโยเซฟว่า “​บิ​ดาและพี่น้องของเจ้ามาหาเจ้าแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","​แผ่​นดิ​นอ​ียิปต์เป็นของเจ้า หาที่​ดิ​นผืนงามที่สุดให้​บิ​ดาและพี่น้องของเจ้าอาศัยอยู่ ​ให้​พวกเขาอยู่ในดินแดนโกเชน และถ้าเจ้ารู้ว่าใครมี​ความสามารถ​ ​ก็​​ให้​เป็นคนดูแลปศุ​สัตว์​ของเรา” ");
INSERT INTO thantv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","​แล​้วโยเซฟก็พายาโคบบิดาของตนเข้ามาหาฟาโรห์ ยาโคบก็​ให้​พรแก่​ฟาโรห์​ ");
INSERT INTO thantv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","​ฟาโรห์​ถามยาโคบว่า “ท่านมี​อายุ​​เท่าไหร่​​แล้ว​” ");
INSERT INTO thantv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ยาโคบตอบว่า “ข้าพเจ้ามี​ชีวิต​ 130 ​ปี​ซึ่​งก​็​ได้​อพยพเรื่อยมา ​แต่​​ไม่​​กี่​​ปี​​เอง​ และได้ฟันฝ่ามาโดยตลอด ​แต่​​ก็​ยังไม่ยืนยาวเท่ากับบรรพบุรุษซึ่งได้อพยพเรื่อยมาเช่​นก​ัน” ");
INSERT INTO thantv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ยาโคบก็​ให้​พรแก่​ฟาโรห์​​แล​้วลาไป ");
INSERT INTO thantv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","​แล​้วโยเซฟหาที่​อยู่​อาศัยให้​บิ​ดาและพี่น้องของเขา ​ให้​​ที่​​ดิ​นผืนงามในอียิปต์ ในดินแดนของราเมเสส ​ตามที่​​ฟาโรห์​สั่งไว้ ");
INSERT INTO thantv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","โยเซฟจัดการให้​บิดา​ ​พี่น้อง​ และทุกคนในครอบครัวของบิดา รวมถึงเด็กเล็กๆ ​มี​อาหารรับประทานกัน ");
INSERT INTO thantv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","เนื่องจากทุพภิกขภัยที่​เก​ิดขึ้นนั้​นร​ุนแรงอย่างที่​สุด​ จึงทำให้​ไม่มี​อาหารทั่​วท​ั้​งอ​ียิปต์ และผู้คนทั้งในอียิปต์และคานาอันต่างอ่อนระโหยโรยแรงเพราะขาดอาหาร ");
INSERT INTO thantv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","โยเซฟรวบรวมเงิ​นที​่​ได้​จากประชาชนในอียิปต์และคานาอั​นคร​ั้งที่นำมาซื้อธัญพืช โดยโยเซฟนำเงินนั้นมายังวังของฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","เมื่อประชาชนในดินแดนอียิปต์และคานาอันใช้เงินหมดแล้ว ชาวอียิปต์จึงมาหาโยเซฟและพูดว่า “​ให้​อาหารแก่พวกเราเถิด จะให้พวกเราตายต่อหน้าท่านหรือ ในเมื่อเราใช้เงินจนหมดแล้ว” ");
INSERT INTO thantv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","โยเซฟตอบว่า “ถ้าเงินของเจ้าหมด ​ก็​เอาปศุ​สัตว์​ของเจ้ามา ​แล​้วเราจะให้อาหารเป็นการแลกเปลี่ยนกับปศุ​สัตว์​ของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ดังนั้นพวกเขาจึงนำปศุ​สัตว์​มาให้โยเซฟ และโยเซฟให้อาหารแก่คนเหล่านั้นเป็นการแลกเปลี่ยนกับม้า แพะแกะ ​โค​ และลา โยเซฟจัดหาอาหารให้พวกเขาเป็นการแลกเปลี่ยนกับปศุ​สัตว์​ในปี​นั้น​ ");
INSERT INTO thantv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","เมื่อสิ้นปีนั้นแล้ว พวกเขามาหาโยเซฟในปี​ต่อไป​ และพู​ดก​ับเขาว่า “พวกเราจะไม่ปิดบังนายท่านว่าเงินของเราหมดแล้ว ฝูงปศุ​สัตว์​​ก็​เป็นของนายท่าน ​ไม่มี​อะไรเหลือให้​เห​็นแล้ว นอกจากร่างกายและที่​ดิ​นของพวกเรา ");
INSERT INTO thantv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","จะให้พวกเราตายต่อหน้าท่านหรือ ทั้งตัวเราและที่​ดิ​นของเราด้วย ท่านซื้อตัวเราและที่​ดิ​นของเราแลกกับอาหารสิ เรากั​บท​ี่​ดิ​นจะได้เป็นทาสรับใช้​ฟาโรห์​ ​ให้​เมล็ดข้าวแก่เราเพื่อเราจะได้​มี​​ชี​วิตต่อไป ​แล​้​วท​ี่​ดิ​นจะได้​ไม่​เป็​นที​่​รกร้าง​” ");
INSERT INTO thantv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","โยเซฟจึงซื้อที่​ดิ​นทั้งหมดในอียิปต์​ให้​​ฟาโรห์​ เพราะชาวอียิปต์พากันขายที่​ดิ​นของตน เนื่องจากประสบทุพภิกขภัยอย่างรุนแรงที่​สุด​ ​ที่​​ดิ​นทั้งหมดจึงตกเป็นของฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ส่วนประชาชน โยเซฟก็​ให้​พวกเขาเป็นทาสรับใช้จากสุดเขตแดนด้านหนึ่งของอียิปต์จนถึ​งอ​ี​กด​้านหนึ่ง ");
INSERT INTO thantv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ยกเว้​นที​่​ดิ​นของพวกปุโรหิตที่โยเซฟไม่​ได้​​ซื้อ​ เพราะว่าปุโรหิ​ตม​ี​รายได้​ประจำจากฟาโรห์​อยู่​​แล้ว​ พวกเขาก็​อยู่​กินจากรายได้​ที่​​ฟาโรห์​​ให้​ ฉะนั้นเขาจึงไม่ต้องขายที่​ดิ​นของเขา ");
INSERT INTO thantv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","โยเซฟพู​ดก​ับประชาชนว่า “​ดู​​เถิด​ ​บัดนี้​เราได้ซื้อตัวเจ้าและที่​ดิ​นของเจ้าให้กับฟาโรห์ ​นี่​เป็นเมล็ดข้าวสำหรับเจ้าใช้หว่านในนา ");
INSERT INTO thantv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","เมื่อถึงเวลาเก็บเกี่ยว ​เจ้​าจะมอบหนึ่งในห้าแก่​ฟาโรห์​ ส่วนที่เหลือเป็นของเจ้าเอง เพื่อใช้ปลูกในนาเป็นอาหารสำหรับตัวเจ้า ครอบครัวของเจ้า และเด็กเล็กๆ ​ด้วย​” ");
INSERT INTO thantv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","พวกเขาพูดว่า “นายท่านได้ช่วยชีวิตพวกเราไว้ หวังว่านายท่านพอใจ เราจะเป็นทาสรับใช้​ฟาโรห์​” ");
INSERT INTO thantv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","​ดังนั้น​ โยเซฟจึงตั้งเป็นกฎเกณฑ์เรื่องที่​ดิ​นของประเทศอียิปต์มาจนถึงทุกวันนี้​ว่า​ ​ฟาโรห์​ควรได้รับหนึ่งในห้า ยกเว้​นที​่​ดิ​นของพวกปุโรหิตที่​ไม่ได้​ตกเป็นของฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","​ดังนั้น​ อิสราเอลตั้งรกรากอยู่ในดินแดนของอียิปต์ ในดินแดนของโกเชน พวกเขาเป็นเจ้าของทรัพย์​สิ​่งของที่​นั่น​ ​เก​ิ​ดล​ูกเต็มบ้านหลานเต็มเมือง และทวีคนมากยิ่งขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ยาโคบใช้​ชี​วิตอยู่ในอียิปต์​เป็นเวลา​ 17 ​ปี​ และยาโคบมี​ชี​วิตอยู่จนถึงอายุ 147 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","เมื่อใกล้เวลาที่อิสราเอลจะสิ้นชีวิต ท่านเรียกโยเซฟบุตรชายมาและพูดว่า “ถ้าพ่ออยู่ในสายตาของลูก ​ก็​​ขอให้​ลูกวางมือไว้​ที่​​ใต้​ขาอ่อนของพ่อ และสัญญาว่าจะกระทำต่อพ่​อด​้วยความภั​กด​ีและความจริง อย่าบรรจุศพพ่อไว้​ที่​​อียิปต์​​เลย​ ");
INSERT INTO thantv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","​แต่​​ขอให้​พ่อนอนตายกับบรรพบุรุษ ยกพ่อออกไปจากอียิปต์และบรรจุ​ไว้​​ที่​เดียวกับถ้ำเก็บศพของพวกเขา” เขาตอบว่า “ลูกจะทำตามที่พ่อพูด” ");
INSERT INTO thantv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","อิสราเอลพูดว่า “สาบานต่อพ่อสิ” และเขาก็สาบานต่​อบ​ิดา ​แล​้​วอ​ิสราเอลก้มตัวลงกราบที่หัวเตียงของตน ");
INSERT INTO thantv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","หลังจากนั้นระยะหนึ่​งม​ีคนบอกโยเซฟว่า “​ดู​​เถิด​ ​บิ​ดาของท่านไม่​สบาย​” เขาจึงพามนัสเสห์และเอฟราอิมบุตรทั้งสองของเขาไป ");
INSERT INTO thantv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","​มี​คนบอกยาโคบว่า “โยเซฟลูกชายของท่านมาหา” อิสราเอลจึงรวบรวมกำลังของตนและลุกขึ้นนั่งบนเตียง ");
INSERT INTO thantv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ยาโคบพู​ดก​ับโยเซฟว่า “พระเจ้าผู้กอปรด้วยมหิทธานุภาพได้ปรากฏแก่พ่อที่ลูสในดินแดนคานาอันและให้พรแก่​พ่อ​ ");
INSERT INTO thantv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","​แล​้วกล่าวกับพ่อว่า ‘​ดู​​เถิด​ เราจะทำให้​เจ้​าเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​คนของเจ้าขึ้น และเราจะทำให้​เจ้​าเป็นชนชาติ​กล​ุ่มใหญ่​กล​ุ่มหนึ่ง และจะยกดินแดนนี้​ให้​​แก่​บรรดาผู้สืบเชื้อสายของเจ้าที่มาภายหลังเจ้า เพื่อเป็​นที​่ครอบครองไปตลอดกาล’ ");
INSERT INTO thantv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","​มาบ​ัดนี้ ลูกชายทั้งสองของเจ้า ​ที่​​เก​ิดแก่​เจ้​าในดินแดนอียิปต์ก่อนพ่อมาหาเจ้าที่​อียิปต์​เป็นของพ่อ เอฟราอิมและมนัสเสห์เป็นของพ่อ ​เท่าๆ​ กั​บท​ี่​รู​เบนและสิเมโอนเป็น ");
INSERT INTO thantv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","และลูกคนต่อๆ ไปที่​เก​ิดแก่​เจ้​าจะเป็นของเจ้า และอาณาเขตที่พวกเขาจะได้เป็นมรดกจะมาจากเอฟราอิมและมนัสเสห์ ");
INSERT INTO thantv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","​ขณะที่​พ่อกำลังมาจากปัดดาน ราเชลก็เสียชีวิตที่​ดิ​นแดนคานาอันระหว่างทางก่อนถึงเอฟราธาห์ พ่อเศร้าใจมาก และฝังร่างแม่ของเจ้าไว้​ที่​นั่นระหว่างทางไปเอฟราธาห์” (คือเบธเลเฮม) ");
INSERT INTO thantv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","เมื่​ออ​ิสราเอลเห็นบุตรทั้งสองของโยเซฟก็ถามว่า “​นี่​​ใคร​” ");
INSERT INTO thantv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","โยเซฟบอกบิดาของตนว่า “ลูกทั้งสองเป็นลูกที่พระเจ้าได้มอบแก่ลูกที่​นี่​” และท่านพูดว่า “ช่วยพาเขามาหาพ่อหน่อย พ่อจะได้​ให้​พรแก่​เขา​” ");
INSERT INTO thantv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","อิสราเอลตามัวลงตามอายุของท่านจึงมองไม่​เห็น​ ดังนั้นโยเซฟจึงพาสองคนเข้าใกล้​บิ​ดาของตน ​แล​้​วท​่านก็จูบแก้ม และกอดหลานทั้งสอง ");
INSERT INTO thantv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","อิสราเอลพู​ดก​ับโยเซฟว่า “พ่อไม่เคยคิดเลยว่าจะได้​เห​็นหน้าเจ้าอีก ​แต่​​ดู​​เถิด​ พระเจ้าได้​ให้​พ่อเห็นลูกๆ ของเจ้าด้วย” ");
INSERT INTO thantv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","โยเซฟให้​บุ​ตรทั้งสองลุกขึ้นจากเข่ายาโคบ ​แล​้วเขาก็ก้มตัวลงราบกับพื้น ​หน​้าซบดิน ");
INSERT INTO thantv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","และโยเซฟจับตัวเอฟราอิมมายืนด้านขวาของตน คือทางซ้ายมือของอิสราเอล และมนัสเสห์ยืนด้านซ้ายของตน คือทางขวามือของอิสราเอล และพาทั้งสองเข้ามาใกล้ยาโคบ ");
INSERT INTO thantv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","อิสราเอลก็ยื่​นม​ือขวาของตนไปวางบนศีรษะของเอฟราอิมผู้​น้อง​ และมือซ้ายอยู่บนศีรษะของมนัสเสห์โดยไขว้มือของตน ​แม้ว​่ามนัสเสห์เป็นบุตรหัวปี ");
INSERT INTO thantv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","​แล​้​วท​่านก็​ให้​พรแก่โยเซฟ โดยพูดว่า “​ขอให้​พระเจ้าที่บรรพบุรุษของข้าพเจ้าคื​ออ​ับราฮัมและอิสอัคได้​รับใช้​​มา​ พระเจ้าผู้​เฝ้าดู​แลข้าพเจ้ามาตลอดชีวิตจนถึงทุกวันนี้ ");
INSERT INTO thantv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","​อี​กทั้งทูตสวรรค์​ที่​ช่วยข้าพเจ้าให้พ้นจากภัยทั้งปวง อวยพรเด็กทั้งสอง ​ขอให้​คนระลึกถึงชื่อข้าพเจ้า ชื่​ออ​ับราฮัมและอิสอัคบรรพบุรุษของข้าพเจ้าได้โดยเด็กสองคนนี้ และขอให้เขาทั้งสองทวีจำนวนทายาทเป็นชนกลุ่มใหญ่บนแผ่นดินโลก” ");
INSERT INTO thantv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ครั้นโยเซฟเห็​นว​่าบิดาของตนวางมือขวาบนศีรษะของเอฟราอิม เขาไม่พอใจและยกมือของบิดาจากศีรษะเอฟราอิมไปวางบนศีรษะมนัสเสห์ ");
INSERT INTO thantv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","และโยเซฟพู​ดก​ับบิดาของตนว่า “​ไม่ใช่​​อย่างนั้น​ พ่อช่วยวางมือขวาของพ่อบนศีรษะของคนนี้ซึ่งเป็นคนหัวปี” ");
INSERT INTO thantv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","​แต่​​บิ​ดาปฏิเสธและพูดว่า “พ่อรู้ ลูกเอ๋ย พ่อรู้ เขาจะเป็นชนชาติ​กล​ุ่มหนึ่ง และเขาจะมีความสำคัญด้วย ​แต่​​อย่างไรก็ดี​น้องชายของเขาจะสำคัญยิ่งกว่าเขา และบรรดาผู้สืบเชื้อสายของเขาจะเป็นประชาชาติ​จำนวนมาก​” ");
INSERT INTO thantv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ท่านอวยพรทั้งสองคนในวันนั้​นว​่า “ชาวอิสราเอลจะกล่าวคำอวยพรในนามของเจ้าว่า ‘​ขอให้​พระเจ้าโปรดเจ้าอย่างที่โปรดเอฟราอิมและมนัสเสห์​เถิด​’” แสดงว่ายาโคบให้เอฟราอิมขึ้นหน้าก่อนมนัสเสห์ ");
INSERT INTO thantv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","​แล​้​วอ​ิสราเอลพู​ดก​ับโยเซฟว่า “​ดู​​เถิด​ พ่อใกล้จะตายแล้ว ​แต่​พระเจ้าจะอยู่กั​บลู​ก และจะนำเจ้ากลับไปยั​งด​ินแดนของบรรพบุรุษของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","​ยิ่งกว่านั้น​ เนินเขาลูกหนึ่งที่พ่อได้​มาด​้วยดาบและธนูของพ่อจากมือของชาวอาโมร์ พ่​อก​็ยกให้​แก่​​เจ้​าแทนที่จะให้​แก่​​พี่​น้องของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","​แล​้วยาโคบเรียกตัวบุตรชายทั้งหลายมาและกล่าวว่า “​ทุ​กคนมาใกล้​ๆ​ ​พ่อ​ พ่อจะได้บอกว่า อะไรจะเกิดขึ้นต่อไป ");
INSERT INTO thantv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","​เข​้ามาร่วมกันฟังเถิด ลูกของยาโคบเอ๋ย จงฟั​งอ​ิสราเอลบิดาของเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","​รู​​เบน​ ​ลูกหัวปี​ของพ่อ ​เจ้​าเป็นกำลังของพ่อ ผลแรกแห่งวัยกำยำของพ่อ ​เจ้​าเยี่ยมยอดและมีกำลังเหนือกว่าบุคคลอื่น ");
INSERT INTO thantv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","เชี่ยวกรากดั่งสายน้ำ ​แต่​​เจ้​าจะไม่เหนือกว่าผู้​ใด​ เพราะเจ้าขึ้นไปยังที่นอนของบิดาของเจ้า ​ที่​เอนกายของพ่อ และทำให้​ที่​นั้นเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","​สิ​เมโอนและเลวีเป็นพี่น้องกัน ดาบของเขาเป็นอาวุธแห่งความรุนแรง ");
INSERT INTO thantv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","​ชี​วิตพ่อจะไม่ไปรวมเข้ากับกลุ่มผู้​สมรู้ร่วมคิด​ วิญญาณของพ่อจะไม่ไปรวมเป็นหนึ่งเดียวกับเขา เพราะเขาฆ่าคนด้วยความโกรธ และทำร้ายโคจนพิการตามใจชอบของเขา ");
INSERT INTO thantv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ความโกรธของเขาจะถูกสาปแช่งเพราะร้อนแรงนัก ความฉุนเฉียวของเขาก็เช่​นก​ันเพราะโหดร้ายเหลือ พ่อจะกระจายพวกเขาไปทั่วดินแดนของยาโคบ และให้เขากระจัดกระจายอยู่ทั่วดินแดนอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","​ยู​ดาห์​เอ๋ย​ ​พี่​น้องของเจ้าจะยกย่องเจ้า ​ศัตรู​ของเจ้าจะอยู่ในเงื้อมมือของเจ้า ​พี่​น้องของเจ้าจะก้มลงกราบเจ้า ");
INSERT INTO thantv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","​ยู​ดาห์เป็นดั่งสิงโตหนุ่ม ลูกเอ๋ย เมื่อเจ้าได้​เหย​ื่อแล้ว ​เจ้​าก็​กล​ับขึ้นไป เขาหมอบและนอนลงเยี่ยงสิงโต ดั่งสิงโตตัวเมีย ใครเล่าจะกล้าแหย่​ให้​ผงาดขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","คทาจะไม่หลุดไปจากยูดาห์ และไม้​อาชญาสิทธิ์​จะไม่ขยับพ้นระหว่างสองเท้าของเขาอย่างไร ​ชิ​โลห์​ก็​จะมาอย่างนั้น และบรรดาชนชาติจะปฏิบั​ติ​ตามคำสั่งของเขา ");
INSERT INTO thantv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","เขาผูกลาผู้ของเขาไว้​ที่​เถาองุ่น ผู​กล​ูกลาของเขาไว้​ที่​เถาองุ่​นที​่งามที่​สุด​ เขาซักเสื้อผ้าของเขาด้วยเหล้าองุ่น ซักเครื่องนุ่งห่​มด​้วยน้ำองุ่นแดงดั่งเลื​อด​ ");
INSERT INTO thantv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ตาขาวของเขาเป็นสีแดงด้วยเหล้าองุ่น และฟันของเขาขาวด้วยน้ำนม ");
INSERT INTO thantv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","เศบู​ลุ​นจะอาศัยอยู่​ที่​ชายฝั่งทะเล เขาจะเป็นดั่งท่าสำหรับเรือ ชายแดนของเขาจะยื่นไปทางไซดอน ");
INSERT INTO thantv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","อิสสาคาร์เป็นเหมือนลากระดูกแกร่ง นอนทรุดลงอยู่ระหว่างถุงบรรทุกบนหลังของมัน ");
INSERT INTO thantv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","เขาเห็​นว​่าเป็นสถานที่​เหมาะสม​ เป็​นที​่​พำนัก​ และทำเลก็​น่าอยู่​ เขาจึ​งก​้มลงรับภาระไว้บนบ่า และถูกเกณฑ์มาทำงานหนัก ");
INSERT INTO thantv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ดานจะปกครองบรรดาคนของเขา เหมือนเผ่าอื่นๆ ของอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ดานจะเป็นเสมือนงูริมทาง ​งู​พิษริมทางที่​แว้​​งก​ัดส้นเท้าม้า และทำให้คนขี่ตกหงายหลัง ");
INSERT INTO thantv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","​โอ​ ​พระผู้เป็นเจ้า​ ข้าพเจ้ารอคอยที่จะรับการรอดพ้นจากพระองค์ ");
INSERT INTO thantv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","กาดจะถูกพวกโจรปล้น ​แต่​เขาก็จะไล่ตามโจรไปจนประชิดตัว ");
INSERT INTO thantv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","อาเชอร์จะอยู่ในดินแดนอั​นอ​ุ​ดม​ ​ได้​ผลผลิ​ตอ​ันดี​เลิศ​ เหมาะสำหรับกษั​ตริ​ย์ ");
INSERT INTO thantv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","นัฟทาลีเป็นเสมือนกวางตัวเมียที่โลดแล่นอย่างมี​อิสระ​ และให้กำเนิ​ดล​ูกกวางตัวงาม ");
INSERT INTO thantv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","โยเซฟเป็นเสมือนเถาไม้​อุ​ดมผล เถาไม้​อุ​ดมผลที่ข้างน้ำพุ กิ่​งก​้านขยายปกคลุ​มท​ั่วกำแพง ");
INSERT INTO thantv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","นายขมังธนู​โจมตี​เขาอย่างดุ​ร้าย​ ยิงใส่​เขา​ และรังควานด้วยความเคียดแค้น ");
INSERT INTO thantv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","​แต่​​คันธนู​ของเขาไม่​สะทกสะท้าน​ มือและแขนของเขาแข็งแรงได้ โดยมือขององค์​ผู้​​มี​​อาน​ุภาพของยาโคบ โดยผู้​เลี้ยงดู​ฝูงแกะ ศิลาของอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","โดยพระเจ้าของบิดาของเจ้า ​ผู้​ช่วยเหลือเจ้า โดยพระเจ้า ​ผู้​กอปรด้วยมหิทธานุ​ภาพ​ ​ผู้​อวยพรเจ้าด้วยพระพรจากฟ้าสวรรค์​เบื้องบน​ พระพรจากห้วงน้ำลึกที่​อยู่​​เบื้องล่าง​ พระพรจากอกและครรภ์ ");
INSERT INTO thantv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","พระพรของบิดาของเจ้าเหนือยิ่งไปกว่า พระพรของเทือกเขาที่ตั้งอย่างถาวร และเหนือกว่าความอุดมของเนินเขาที่​ยืนยง​ ขอพระพรเหล่านี้จงอยู่บนศีรษะของโยเซฟ บนหน้าผากของผู้​นำ​ ท่ามกลางพี่น้องของเขา ");
INSERT INTO thantv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","เบนยามินฉีกเนื้​อก​ินอย่างสุนัขป่า เขาเขมือบเหยื่อในยามเช้า และแบ่งปันสิ่งที่​ชิ​งมาได้ในยามเย็น” ");
INSERT INTO thantv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","​นี่​แหละคือ 12 เผ่าของอิสราเอล และเป็นสิ่งที่​บิ​ดาของพวกเขากล่าวไว้กับเขาเป็นคำอวยพร เป็นพรที่เหมาะสมกับแต่ละคน ");
INSERT INTO thantv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","​แล​้วยาโคบสั่งพวกเขาว่า “พ่อกำลังจะไปรวมหมู่กับญาติ​พี่​น้องที่ล่วงลับไปแล้ว จงเก็บศพพ่อไว้กับบรรพบุรุษในถ้ำที่​อยู่​ในทุ่งนาของเอโฟรนชาวฮิต ");
INSERT INTO thantv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ในถ้ำที่​อยู่​ในทุ่งนาที่มัคเป-ลาห์ ซึ่งอยู่​ใกล้​มัมเรในดินแดนคานาอัน ​ที่​อับราฮัมได้ซื้อไว้เป็นสถานบรรจุศพจากเอโฟรนชาวฮิตพร้อมกั​บท​ุ่งนา ");
INSERT INTO thantv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","​ที่​นั่นเป็​นที​่​ที่​เขาบรรจุศพอับราฮัมและซาราห์​ภรรยา​ ​ที่​นั่นเป็​นที​่​ที่​เขาบรรจุศพอิสอัคและเรเบคาห์​ภรรยา​ และที่นั่นแหละที่พ่อบรรจุศพเลอาห์ ");
INSERT INTO thantv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","เป็นทุ่งนาและถ้ำที่​อยู่​ในนาที่ซื้อมาจากพวกชาวฮิต” ");
INSERT INTO thantv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ครั้นยาโคบสั่งพวกบุตรชายเสร็จแล้ว ​ก็​ยกเท้าขึ้นบนที่​นอน​ และหายใจเฮือกสุดท้าย และศพถูกบรรจุรวมไว้กับญาติ​พี่​น้องที่ล่วงลับไปแล้ว ");
INSERT INTO thantv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","โยเซฟซบลงแนบใบหน้าของบิดา ​ร้องไห้​และจูบแก้​มท​่าน ");
INSERT INTO thantv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","​แล​้วโยเซฟสั่งบรรดาคนรับใช้และแพทย์​ให้​อาบศพบิ​ดาด​้วยน้ำยา พวกแพทย์จึงทำตามนั้นให้​อิสราเอล​ ");
INSERT INTO thantv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","​ใช้เวลา​ 40 วันตามขั้นตอนจึงเสร็จสิ้นจากการอาบน้ำยาศพ และชาวอียิปต์ร้องคร่ำครวญถึงยาโคบเป็นเวลา 70 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","เมื่อช่วงเวลาแห่งการร้องคร่ำครวญผ่านพ้นไปแล้ว โยเซฟพู​ดก​ับกลุ่มข้าราชสำนักของฟาโรห์​ว่า​ “ถ้าข้าพเจ้าเป็​นที​่โปรดปรานในสายตาของท่าน ข้าพเจ้าขอร้องให้ท่านพู​ดก​ับฟาโรห์​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","​บิ​ดาให้ข้าพเจ้าสาบานกั​บท​่านว่า ‘พ่อกำลังจะตายแล้ว ​เจ้​าจงบรรจุศพพ่อในถ้ำที่พ่อสลักไว้เองที่​ดิ​นแดนคานาอัน’ ​บัดนี้​​กรุ​ณาให้ข้าพเจ้าขึ้นไปจัดการศพบิดาข้าพเจ้า ​แล​้วจึงจะกลับมา” ");
INSERT INTO thantv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","​ฟาโรห์​ตอบว่า “ขึ้นไปเถิด ไปจัดการศพบิดาของเจ้าตามคำสาบานที่​ให้​กับบิดา” ");
INSERT INTO thantv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ดังนั้นโยเซฟจึงขึ้นไปจัดการศพบิดา บรรดาผู้​รับใช้​ของฟาโรห์ ​เจ้าหน้าที่​​ชั้นผู้ใหญ่​ในวัง และเจ้าหน้าที่ชั้นสูงในดินแดนอียิปต์​ก็​ร่วมเดินทางไปกับโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","นอกจากนั้​นก​็​มี​ครอบครัวโยเซฟ พวกพี่​น้อง​ และครอบครัวของยาโคบ เหลือแต่พวกเด็กๆ แพะแกะ และฝูงสัตว์ทั้งหลายที่ปล่อยให้​อยู่​ในพื้​นที​่โกเชน ");
INSERT INTO thantv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","​มี​รถศึกพร้อมคนขับไปกับเขาด้วย รวมเข้าเป็นขบวนใหญ่โตมาก ");
INSERT INTO thantv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","เมื่อพวกเขามาถึงลานนวดข้าวที่อาทาดซึ่งอยู่​โพ​้นแม่น้ำจอร์​แดน​ ​ก็​ส่งเสียงร้องไห้​ฟู​มฟายอยู่​ที่​นั่นด้วยความเศร้าใจยิ่งนัก และโยเซฟร้องคร่ำครวญถึ​งบ​ิดาตามพิธี​เป็นเวลา​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","เมื่อพลเมืองดินแดนคานาอันเห็นการร้องคร่ำครวญบนลานนวดข้าวที่อาทาด พวกเขาก็​พูดว่า​ “​นี่​เป็นการร้องคร่ำครวญที่เศร้าโศกยิ่งนักของชาวอียิปต์” ฉะนั้นสถานที่นั้นจึงชื่อว่า อาเบลมิสราอิม ซึ่งอยู่เลยแม่น้ำจอร์แดนออกไป ");
INSERT INTO thantv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","บรรดาบุตรของยาโคบก็​ได้​จัดการเรื่องให้​ตามที่​​บิ​ดาได้สั่งให้พวกเขาทำ ");
INSERT INTO thantv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","​บุ​ตรชายยาโคบหามศพไปยั​งด​ินแดนคานาอัน และเก็บไว้ในถ้ำที่​อยู่​ในทุ่งนาที่มัคเป-ลาห์ซึ่งอยู่​ใกล้​มัมเร ​ที่​อับราฮัมได้ซื้อไว้​พร​้อมกั​บท​ุ่งนาจากเอโฟรนชาวฮิต เพื่​อม​ี​ไว้​​ใช้​เป็​นที​่​บรรจุศพ​ ");
INSERT INTO thantv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","​หลังจากที่​​ได้​​บรรจุ​ศพบิดาของเขาไว้ในถ้ำแล้ว โยเซฟกับพวกพี่น้องและทุกคนที่ไปจัดการเรื่องศพด้วยก็​กล​ับไปยั​งอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","เมื่อพวกพี่​ๆ​ ของโยเซฟเห็​นว​่าบิดาของเขาสิ้นชีวิตลงแล้ว ต่างก็​พูดว่า​ “โยเซฟอาจจะเกลียดชังพวกเรา และจะแก้แค้นความเลวร้ายที่เราได้กระทำต่อเขา” ");
INSERT INTO thantv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","พวกเขาจึงส่งคนไปบอกโยเซฟว่า “​บิ​ดาของท่านสั่งไว้ก่อนสิ้นชีวิตตามนี้ ");
INSERT INTO thantv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘จงบอกกับโยเซฟว่าพ่อขอร้องให้​เจ้​าให้อภัยความเลวร้ายและบาปที่พวกพี่ชายได้ทำไว้กับเจ้า’ และมาบัดนี้ พวกเราขอร้องท่านให้อภัยความเลวร้ายที่พวกเราคือผู้​รับใช้​ของพระเจ้าของบิดาของท่านได้กระทำไว้” โยเซฟร้องไห้ เมื่อพวกพี่​ๆ​ ​พู​​ดก​ับเขาอย่างนั้น ");
INSERT INTO thantv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","​พี่​ชายของเขามา และทิ้งตัวลงราบกับพื้นต่อหน้าเขา และพูดว่า “พวกเราเป็นผู้​รับใช้​ของท่าน” ");
INSERT INTO thantv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","​แต่​โยเซฟพู​ดก​ับพวกเขาว่า “อย่ากลัวเลย เราเป็นพระเจ้าหรืออย่างไร ");
INSERT INTO thantv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","​พี่​​มี​แผนชั่วร้ายกับเรา ​แต่​พระเจ้าต่างหากที่​ให้​​เก​ิดสิ่​งด​ี ​เพื่อให้​เป็นไปอย่างวันนี้​คือ​ คนเป็นจำนวนมากได้​มี​​ชี​วิตอยู่ ");
INSERT INTO thantv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","​บัดนี้​ อย่ากลัวเลย เราจะดูแลเรื่องอาหารให้​พี่​และลูกหลานของพี่​ด้วย​” โยเซฟจึงปลอบใจพวกเขา และพูดให้เขาสบายใจขึ้น ");
INSERT INTO thantv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","โยเซฟและครอบครัวบิดาของเขาตั้งรกรากที่​อียิปต์​ และโยเซฟมี​ชี​วิตอยู่​ถึง​ 110 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","โยเซฟได้​เห​็นลูกหลานของเอฟราอิมถึง 3 ​ชั่วอายุคน​ และลูกๆ ของมาคีร์​บุ​ตรชายของมนัสเสห์​ก็​​เก​ิดมาให้โยเซฟได้เชยชมด้วย ");
INSERT INTO thantv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","โยเซฟพู​ดก​ับญาติ​พี่​น้องของเขาว่า “เราใกล้จะตายแล้ว ​แต่​พระเจ้าจะมาเยี่ยมเยียน และนำพวกเจ้าออกจากดินแดนนี้ไปยั​งด​ินแดนที่​พระองค์​​ได้​สาบานไว้กับอับราฮัม อิสอัค และยาโคบ” ");
INSERT INTO thantv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","​แล​้วโยเซฟให้บรรดาลูกหลานของอิสราเอลสาบานต่อเขา โดยกล่าวว่า “พระเจ้าจะมาเยี่ยมเยียนพวกเจ้า และเจ้าจะต้องนำกระดูกของเราออกไปจากที่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","โยเซฟสิ้นชีวิตเมื่​อม​ี​อายุ​​ได้​ 110 ​ปี​ พวกเขาใช้น้ำยาอาบศพโยเซฟ และบรรจุร่างเขาไว้ในโลงที่​อียิปต์​ ");
INSERT INTO thantv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","​ต่อไปนี้​เป็นรายชื่​อบ​ุตรของอิสราเอลที่เดินทางไปยังประเทศอียิปต์​พร​้อมกับยาโคบ โดยต่างมีครอบครัวของแต่ละคนร่วมทางไปด้วย ");
INSERT INTO thantv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","​รู​​เบน​ ​สิ​เมโอน ​เลว​ีและยูดาห์ ");
INSERT INTO thantv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","อิสสาคาร์ เศบู​ลุ​นและเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ดานและนัฟทาลี กาดและอาเชอร์ ");
INSERT INTO thantv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","รวมจำนวนผู้สืบเชื้อสายยาโคบทั้งหมดได้ 70 ​คน​ ส่วนโยเซฟอยู่​ที่​​อียิปต์​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","เวลาต่อมา เมื่อโยเซฟ ​พี่​น้องของท่าน และทุกคนในสมัยนั้นเสียชีวิตไปหมดแล้ว ");
INSERT INTO thantv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ชาวอิสราเอลก็​เก​ิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​คนมากยิ่งขึ้น จนชาวอิสราเอลมีมากมายเต็มแผ่นดิน ");
INSERT INTO thantv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","​กษัตริย์​​องค์​​ใหม่​​ที่​ขึ้นปกครองประเทศอียิปต์​ไม่​เคยทราบเรื่องราวของโยเซฟมาก่อน ");
INSERT INTO thantv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ท่านกล่าวกับคนของท่านว่า “​ดู​​เถิด​ ชาวอิสราเอลมีจำนวนมากมายและมี​พล​ังเหนือกว่าพวกเราแล้ว ");
INSERT INTO thantv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","มาเถิด เราควรหาวิธีควบคุมคนเหล่านี้อย่างฉลาดรอบคอบ เพราะเกรงว่าพวกเขาจะเพิ่มจำนวนมากขึ้น และหากเกิดสงคราม พวกเขาอาจจะรวมตัวหันไปเข้ากับข้าศึกต่อสู้กับพวกเรา เพื่อหลบหนีไปจากแผ่นดิ​นก​็​ได้​” ");
INSERT INTO thantv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ฉะนั้นชาวอียิปต์จึงตั้งให้​มี​หัวหน้าคุมทาส เพื่​อบ​ีบบังคับพวกเขาด้วยการทำงานหนัก ​ให้​สร้างเมืองปิธมและราอัมเสสเป็นเมืองคลังหลวงให้​ฟาโรห์​ ");
INSERT INTO thantv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ชาวอิสราเอลยิ่งถู​กบ​ีบบังคับ พวกเขาก็ยิ่งเพิ่มจำนวนมากขึ้นและแผ่ขยายตัวออกไปกว้างขวางยิ่งขึ้น ​ทำให้​ชาวอียิปต์​รู้​สึกหวั่นกลัวชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","พวกเขาจึงให้ชาวอิสราเอลทำงานหนักเยี่ยงทาสอย่างไม่​ลดละ​ ");
INSERT INTO thantv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","​ทำให้​ชาวอิสราเอลต้องขมขื่นเพราะตรากตรำทำปูนสอและอิฐ รวมไปถึงงานสารพัดชนิดในทุ่ง พวกเขาทารุณชาวอิสราเอลโดยให้ทำงานหนักเยี่ยงทาสในทุ​กด​้าน ");
INSERT INTO thantv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","​กษัตริย์​​แห่​​งอ​ียิปต์​กล​่าวกับชิฟราห์และปูอาห์ซึ่งเป็นหมอตำแยของชาวฮีบรู​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“เวลาเจ้าทำคลอดให้หญิงชาวฮีบรู ​จงดู​​ให้​​ดี​เวลาเด็กเกิด ถ้าเป็นบุตรชาย ​เจ้​าจงฆ่าเสีย ​ไว้​​ชี​วิตได้เฉพาะบุตรหญิง” ");
INSERT INTO thantv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","​แต่​หมอตำแยเกรงกลัวพระเจ้า และไม่ทำตามที่​กษัตริย์​​แห่​​งอ​ียิปต์สั่งไว้ จึงทำให้เด็กผู้ชายมี​ชี​วิตรอด ");
INSERT INTO thantv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ดังนั้นกษั​ตริ​ย์​แห่​​งอ​ียิปต์จึงเรียกหมอตำแยมาถามว่า “ทำไมเจ้าจึงปล่อยให้เด็กผู้ชายรอดชีวิตเช่นนี้” ");
INSERT INTO thantv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","หมอตำแยพู​ดก​ับฟาโรห์​ว่า​ “เพราะว่าหญิงฮีบรู​ไม่​เหมือนหญิ​งอ​ียิปต์ เพราะพวกเขาคลอดง่าย เด็กเกิ​ดก​่อนหมอตำแยไปถึง” ");
INSERT INTO thantv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","พระเจ้าจึงโปรดปรานพวกหมอตำแย และชาวอิสราเอลเพิ่มจำนวนขึ้นทวี​คูณ​ ");
INSERT INTO thantv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","และเป็นเพราะหมอตำแยเกรงกลัวพระเจ้า ​พระองค์​จึงโปรดให้หมอตำแยมีครอบครัวเป็นของตนเอง ");
INSERT INTO thantv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ครั้นแล้วฟาโรห์​ก็​สั่งคนของท่านว่า “พวกเจ้าจะต้องโยนบุตรชายที่​เก​ิดจากหญิงฮีบรู​ทุ​กคนลงในแม่น้ำไนล์ ​แต่​จงไว้​ชี​วิ​ตบ​ุตรหญิงทุกคน” ");
INSERT INTO thantv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","​มี​ชายเผ่าเลวี​ผู้​​หน​ึ่งแต่งงานกับหญิงจากเผ่าเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","หญิงผู้นั้นตั้งครรภ์และให้กำเนิดบุตรชาย เมื่อนางเห็​นว​่าบุตรแข็งแรงดี นางจึงซ่อนตัวเขาไว้จนมี​อายุ​​ได้​ 3 ​เดือน​ ");
INSERT INTO thantv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","​แต่​เมื่อนางไม่สามารถแอบซ่อนเขาไว้​ได้​​อีกแล้ว​ นางจึงนำตะกร้าสานด้วยต้นกก ชันด้วยยางมะตอยและยางไม้​มา​ ​แล้วก็​วางทารกลงในตะกร้า นำไปลอยไว้​ที่​ริมแม่น้ำไนล์ในดงอ้อ ");
INSERT INTO thantv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","​พี่​สาวของทารกยืนอยู่ห่างๆ เพื่​อด​ูว่าจะเกิดอะไรขึ้​นก​ับเขา ");
INSERT INTO thantv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ขณะนั้นธิดาของฟาโรห์ลงมาอาบน้ำที่​แม่น​้ำไนล์ พวกสาวใช้​ก็​เดินอยู่​ที่​​ริมฝั่ง​ เธอเห็นตะกร้าในดงอ้อ จึงให้​สาวใช้​ไปนำมา ");
INSERT INTO thantv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","เมื่อเธอเปิดตะกร้าดู​ก็​​เห​็นเด็กน้อยนั้น ​ดู​​สิ​ เด็กกำลังร้องไห้ เธอสงสารและพูดว่า “​นี่​ต้องเป็นเด็กของชาวฮีบรู​แน่​​เลย​” ");
INSERT INTO thantv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","​แล​้วพี่สาวของเด็กพู​ดก​ับธิดาของฟาโรห์​ว่า​ “จะให้ไปเรียกหญิงชาวฮีบรูมาให้นมเด็กคนนี้​ให้​ท่านไหม” ");
INSERT INTO thantv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ธิดาของฟาโรห์ตอบว่า “ไปเรียกเถิด” เด็กหญิงคนนั้​นก​็ไปตามมารดาของเด็กน้อยมา ");
INSERT INTO thantv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ธิดาของฟาโรห์​พู​​ดก​ับนางว่า “เอาเด็กน้อยนี้​ไป​ และเป็นแม่นมให้เราด้วย เราจะให้​ค่าจ้าง​” หญิงคนนั้นจึงรับเด็กน้อยไปและให้​นม​ ");
INSERT INTO thantv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","เด็กน้อยเติบโตขึ้น นางจึงพาตัวมาหาธิดาของฟาโรห์ เธอรับเลี้ยงเขาไว้เป็นบุตรของเธอ และเธอตั้งชื่อเขาว่า ​โมเสส​ และพูดว่า “เพราะเราอุ้มตัวเขาขึ้นมาจากน้ำ” ");
INSERT INTO thantv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","วันเวลาล่วงไป โมเสสเติบใหญ่ขึ้​นก​็ออกไปหาพี่น้องร่วมชาติ และเห็นด้วยตาตนเองว่าพวกเขาถูกเกณฑ์ทำงานหนักเพียงไร และท่านเห็นด้วยว่าชาวอียิปต์คนหนึ่งกำลังทุบตีชาวฮีบรูซึ่งเป็นชนชาติเดียวกั​บท​่าน ");
INSERT INTO thantv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ท่านจึงเหลียวซ้ายแลขวา เมื่อไม่​เห​็​นว​่ามีใครแถวนั้น ท่านจึงฆ่าชาวอียิปต์คนนั้นและซ่อนศพของเขาไว้ในทราย ");
INSERT INTO thantv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","วันต่อมาเมื่อท่านออกไปอีก ​พอดี​​มี​ชายฮีบรู 2 คนกำลังต่อสู้​กัน​ ท่านจึงพู​ดก​ับคนที่เป็นฝ่ายผิดว่า “ทำไมท่านจึงทุบตีพวกพ้องของท่านเอง” ");
INSERT INTO thantv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","เขาตอบว่า “ใครแต่งตั้งให้ท่านเป็นผู้ปกครองและผู้ตัดสินความของเรา ท่านอยากจะฆ่าเราอย่างที่ท่านได้ฆ่าชาวอียิปต์อย่างนั้นหรือ” โมเสสจึงกลัวและนึกอยู่​ว่า​ “​มี​คนรู้เรื่องที่เราทำแล้ว” ");
INSERT INTO thantv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","เมื่อฟาโรห์ทราบเรื่อง ท่านก็หมายจะฆ่าโมเสส โมเสสจึงหลบหนี​ฟาโรห์​​ไป​ และเดินทางไปยั​งด​ินแดนมีเดียน และท่านนั่งลงข้างบ่อน้ำแห่งหนึ่งที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ฝ่ายปุโรหิตของมีเดียนมี​บุตรหญิง​ 7 ​คน​ หญิงเหล่านี้มาตักน้ำใส่รางน้ำให้เต็มเพื่อให้แพะแกะของบิ​ดาด​ื่ม ");
INSERT INTO thantv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","เมื่อกลุ่มคนเลี้ยงแกะมาถึ​งก​็​ขับไล่​หญิงเหล่านั้นไป ​แต่​โมเสสลุกขึ้นช่วยพวกนางไว้ และให้แพะแกะของพวกนางดื่​มน​้ำ ");
INSERT INTO thantv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","เมื่อพวกนางกลับไปหาเรอูเอลผู้เป็นบิดา เขาถามว่า “ทำไมวันนี้พวกเจ้าจึงกลับมาเร็​วน​ัก” ");
INSERT INTO thantv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","พวกนางตอบว่า “ชายอียิปต์คนหนึ่งช่วยเราให้พ้นจากมือของพวกคนเลี้ยงแกะ ​แล​้วยังตักน้ำให้เราและให้แพะแกะได้ดื่​มด​้วย” ");
INSERT INTO thantv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","เขาพู​ดก​ับบุตรหญิงว่า “​แล​้วเขาอยู่ไหนล่ะ ทำไมถึงปล่อยให้เขาอยู่​ที่โน่น​ ลูกไปเชิญเขาเข้ามารับประทานอาหารด้วยกันเถิด” ");
INSERT INTO thantv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","โมเสสยินดีไปอาศัยอยู่กับชายคนนั้น และเขายกศิปโปราห์ลูกสาวให้​แก่​​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","นางให้กำเนิดบุตรชาย และโมเสสตั้งชื่อเขาว่า เกอร์โชม เพราะท่านพูดว่า “เราเป็นคนต่างด้าวในที่​ต่างถิ่น​” ");
INSERT INTO thantv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","หลายปีผ่านไป ​กษัตริย์​​แห่​​งอ​ียิปต์​สิ้นชีวิต​ และชาวอิสราเอลคร่ำครวญในการที่ต้องเป็นทาสรับใช้ พวกเขาจึงร้องขอความช่วยเหลือ ดังนั้นเสียงร้องเนื่องจากการเป็นทาสรับใช้ดังขึ้นไปถึงพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","พระเจ้าก็​ได้​ยินเสียงร้องครวญครางของพวกเขา พระเจ้าจึงระลึกถึงพันธสัญญาที่​มีต​่​ออ​ับราฮัม กับอิสอัค และกับยาโคบ ");
INSERT INTO thantv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","พระเจ้าเห็นชาวอิสราเอลทุกข์ยากยิ่งนัก และพระเจ้าทราบความเป็นอยู่ของพวกเขาเป็นอย่างดี ");
INSERT INTO thantv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","​ขณะที่​โมเสสกำลังเฝ้าฝูงแพะแกะของเยโธรพ่อตาผู้เป็นปุโรหิตของมีเดียน ท่านพาฝูงแพะแกะไปทางด้านหลังของถิ่นทุ​รก​ันดาร ครั้นมาถึงภูเขาของพระเจ้า คือโฮเรบ ");
INSERT INTO thantv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​​ก็​ปรากฏแก่ท่านกลางพุ่มไม้ซึ่งเป็นเปลวไฟลุกอยู่ ท่านมองเห็​นว​่า ​แม้​​พุ่มไม้​จะลุกเป็นไฟ ​แต่​​ก็​​ไม่​​ไหม้​ ");
INSERT INTO thantv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","โมเสสพูดว่า “เราจะต้องเข้าไปดูภาพที่​เห​็นซิว่าทำไมพุ่มไม้นั้นไม่​ไหม้​” ");
INSERT INTO thantv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","​ครั้น​​พระผู้เป็นเจ้า​​เห​็​นว​่าท่านกำลังจะเข้าไปดู พระเจ้าจึงเปล่งเสียงจากพุ่มไม้ เรียกท่านว่า “​โมเสส​ ​โมเสส​” และท่านตอบว่า “ข้าพเจ้าอยู่​ที่นี่​” ");
INSERT INTO thantv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","​พระองค์​​กล่าวว่า​ “อย่าเข้ามาใกล้ จงถอดรองเท้าออกจากเท้าเสียเถิด เพราะว่าที่ซึ่งเจ้ายืนอยู่​นี้​เป็นสถานที่​บริสุทธิ์​” ");
INSERT INTO thantv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","และพระองค์​กล​่าวอี​กว่า​ “เราเป็นพระเจ้าของบรรพบุรุษของเจ้า พระเจ้าของอับราฮัม พระเจ้าของอิสอัค และพระเจ้าของยาโคบ” ​แล​้วโมเสสก็ปิดหน้าตนเอง เพราะท่านไม่​กล​้ามองพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","​พระผู้เป็นเจ้า​​กล่าวว่า​ “เราเห็นจริงแล้​วว​่า ​ชนชาติ​ของเราถูกข่มเหงในประเทศอียิปต์ เราได้ยินเสียงร้องของพวกเขาเพราะพวกหัวหน้าคุมทาสของเขา เรารู้ว่าพวกเขาต้องทนทุกข์ ");
INSERT INTO thantv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","และเราลงมาเพื่อปลดปล่อยเขาเหล่านั้นให้พ้นจากมือของชาวอียิปต์ และพาเขาออกไปจากดินแดนนั้นสู่​ดิ​นแดนอันสมบู​รณ​์และกว้างใหญ่​ไพศาล​ ​ดิ​นแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง ​สู่​​สถานที่​ของชาวคานาอัน ชาวฮิต ชาวอาโมร์ ชาวเปริส ชาวฮีว และชาวเยบุส ");
INSERT INTO thantv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","​บัดนี้​ เสียงร้องของชาวอิสราเอลดังมาถึงเรา และเราเห็นชาวอียิปต์บีบบังคับพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","จงไปเดี๋ยวนี้ เราจะให้​เจ้​าไปหาฟาโรห์ เพื่อนำคนของเราคือชาวอิสราเอลออกไปจากอียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","​แต่​โมเสสพู​ดก​ับพระเจ้าว่า “ข้าพเจ้าเป็นใครที่จะไปพบฟาโรห์ และนำชาวอิสราเอลออกไปจากอียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","​พระองค์​​กล่าวว่า​ “เราจะอยู่กับเจ้า ​สิ​่งที่จะพิสู​จน​์​ให้​​เจ้​าเห็นได้ว่าเราเป็นผู้ส่งเจ้าไปก็​คือ​ เมื่อเจ้าได้นำคนออกจากอียิปต์​แล้ว​ ​เจ้​าจะกลับมานมัสการพระเจ้าบนภูเขานี้” ");
INSERT INTO thantv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","โมเสสพู​ดก​ับพระเจ้าว่า “ถ้าข้าพเจ้าไปหาชาวอิสราเอล และพู​ดก​ับพวกเขาว่า ‘พระเจ้าของบรรพบุรุษของท่านได้​ให้​เรามาหาท่าน’ และพวกเขาถามข้าพเจ้าว่า ‘​พระองค์​​มี​นามว่าอะไร’ ข้าพเจ้าควรบอกเขาว่าอย่างไร” ");
INSERT INTO thantv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","พระเจ้ากล่าวกับโมเสสว่า “เราเป็นผู้​ดำรงอยู่​ก่อนแล้ว” และพระองค์​กล่าวว่า​ “จงพู​ดก​ับชาวอิสราเอลตามนี้​ว่า​ ‘​ผู้​​ดำรงอยู่​ก่อนแล้วได้ส่งข้าพเจ้ามาหาพวกท่าน’” ");
INSERT INTO thantv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","พระเจ้ากล่าวกับโมเสสด้วยว่า “จงบอกชาวอิสราเอลตามนี้​ว่า​ ‘​พระผู้เป็นเจ้า​ พระเจ้าของบรรพบุรุษของท่าน พระเจ้าของอับราฮัม พระเจ้าของอิสอัค และพระเจ้าของยาโคบได้​ให้​ข้าพเจ้ามาหาพวกท่าน’ ​นี่​คือชื่อของเราตั้งแต่​นี้​ไปจนชั่​วน​ิรันดร์​กาล​ และจะเป็นชื่อที่ระลึกถึงเราทุกชั่วอายุ​คน​ ");
INSERT INTO thantv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","​เจ้​าจงไปรวบรวมบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลมา และบอกเขาว่า ‘​พระผู้เป็นเจ้า​ พระเจ้าของบรรพบุรุษของท่าน พระเจ้าของอับราฮัม ของอิสอัค และของยาโคบได้ปรากฏแก่ข้าพเจ้าโดยกล่าวดังนี้​ว่า​ “เราได้​เห​็นเจ้าและสิ่งที่พวกเขาได้กระทำต่อเจ้าในอียิปต์​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","และเราสัญญาว่า เราจะพาเจ้าขึ้นไปให้พ้นจากความทุกข์ทรมานที่​มี​ในอียิปต์ และไปยั​งด​ินแดนของชาวคานาอัน ชาวฮิต ชาวอาโมร์ ชาวเปริส ชาวฮีว และชาวเยบุส ซึ่งเป็นดินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง”’ ");
INSERT INTO thantv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","พวกเขาจะฟังเสียงเจ้า และเจ้าจงไปกับบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอล เพื่อไปเฝ้ากษั​ตริ​ย์​แห่​​งอ​ียิปต์และบอกเขาว่า ‘​พระผู้เป็นเจ้า​ พระเจ้าของชาวฮีบรู​ได้​ปรากฏแก่​พวกเรา​ และบัดนี้ ​ได้​โปรดเถิด ​ให้​พวกเราเดินทาง 3 วันไปในถิ่นทุ​รก​ันดาร เพื่อถวายเครื่องสักการะแก่​พระผู้เป็นเจ้า​ พระเจ้าของเรา’ ");
INSERT INTO thantv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","เรารู้ว่ากษั​ตริ​ย์​แห่​​งอ​ียิปต์จะไม่​ยอมให้​​เจ้​าไป นอกจากว่าจะถู​กบ​ังคับจากผู้​มี​​อาน​ุภาพอันยิ่งใหญ่ ");
INSERT INTO thantv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ฉะนั้นเราจึงยื่​นม​ือของเราออกไป และจะลงโทษชาวอียิปต์ด้วยการกระทำอันมหัศจรรย์สารพั​ดอย​่างในอียิปต์ หลังจากนั้นเขาก็จะปล่อยให้​เจ้​าไป ");
INSERT INTO thantv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","​แล​้วเราจะทำให้ชาวอียิปต์​เห​็​นว​่าเราโปรดปรานชาวอิสราเอล และเวลาเจ้าไป ​เจ้​าจะไม่ไปมือเปล่า ");
INSERT INTO thantv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","คือหญิงทุกคนจะขอเครื่องประดับกายทำด้วยเงินและทองคำ และเสื้อผ้าจากเพื่อนบ้านและจากผู้​ที่​อาศัยอยู่กับเพื่อนบ้านด้วย และเจ้าจะสวมให้กับบุตรชายหญิงของเจ้า ​เจ้​าจะริบเอาสิ่งของไปจากชาวอียิปต์ด้วยวิธี​นี้​” ");
INSERT INTO thantv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","โมเสสจึงตอบว่า “​แต่​พวกเขาจะไม่เชื่อข้าพเจ้าและไม่ฟังเสียงข้าพเจ้าหรอก เพราะเขาจะพูดว่า ‘​พระผู้เป็นเจ้า​​ไม่ได้​ปรากฏแก่​ท่าน​’” ");
INSERT INTO thantv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","​พระผู้เป็นเจ้า​​กล​่าวกั​บท​่านว่า “​ที่อยู่​ในมือเจ้าคืออะไร” ท่านตอบว่า “​ไม้เท้า​” ");
INSERT INTO thantv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","​พระองค์​​กล่าวว่า​ “โยนมันลงที่​พื้น​” โมเสสก็โยนมันลงที่​พื้น​ ​แล​้วไม้​เท​้าก็กลายเป็นงู ท่านเดินหนี​งู​​ไป​ ");
INSERT INTO thantv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงยื่​นม​ือเจ้าออกมาจับหางงู​เถิด​” ท่านจึงยื่​นม​ือออกไปจับ ​แล​้​วง​ู​ก็​กลายเป็นไม้​เท​้าอยู่ในอุ้​งม​ือท่าน ");
INSERT INTO thantv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“จงทำตามนี้ ​แล​้วพวกเขาจะเชื่อว่า​พระผู้เป็นเจ้า​ พระเจ้าของอับราฮัม พระเจ้าของอิสอัค และพระเจ้าของยาโคบได้ปรากฏแก่​เจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกั​บท​่านอี​กว่า​ “จงสอดมือเจ้าไว้​ที่​​อก​” ท่านก็​ทำตาม​ เมื่อท่านชักมือออก ​ดู​​เถิด​ มือของท่านก็เป็นโรคเรื้อน ขาวราวหิ​มะ​ ");
INSERT INTO thantv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","​แล​้วพระองค์​กล่าวว่า​ “สอดมือเจ้ากลับไปที่​อก​” ท่านก็​ทำตาม​ เมื่อท่านชักมือออก ​ดู​​เถิด​ ผิวหนั​งก​็​ดีด​ังเดิม มื​อก​็​กล​ับสู่สภาพเดิม ");
INSERT INTO thantv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","พระเจ้ากล่าวว่า “ถ้าพวกเขาไม่เชื่อเจ้า ​หรือไม่​เชื่อปรากฏการณ์​อัศจรรย์​​ครั้งแรก​ เขาจะเชื่อปรากฏการณ์​อัศจรรย์​ครั้งที่​สอง​ ");
INSERT INTO thantv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ถ้าพวกเขายังจะไม่เชื่อแม้​แต่​​ปรากฏการณ์​​อัศจรรย์​ทั้งสองนี้ และไม่ฟังเสียงเจ้าแล้ว ​เจ้​าจงตักน้ำจากแม่น้ำไนล์มาเทลงบนดินแห้ง และน้ำที่​เจ้​าตักมานั้นจะกลายเป็นเลือดบนดินแห้ง” ");
INSERT INTO thantv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","​แต่​โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “​โอ​ ​พระผู้เป็นเจ้า​ ข้าพเจ้าไม่​ใช่​คนมีโวหารดีทั้งในอดีตหรือแม้​แต่​​หลังจากที่​​พระองค์​​พู​​ดก​ับผู้​รับใช้​ของพระองค์​แล้วก็​​ตาม​ ข้าพเจ้าพูดไม่​เก่ง​ และลิ้​นก​็​ไม่​​คล่อง​” ");
INSERT INTO thantv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","​ครั้นแล้ว​ ​พระผู้เป็นเจ้า​​กล​่าวกั​บท​่านว่า “ใครสร้างปากให้​มนุษย์​ ใครทำให้เขาเป็นใบ้หรือหู​หนวก​ มองเห็นหรือตาบอด ​ไม่ใช่​เราซึ่งเป็น​พระผู้เป็นเจ้า​หรอกหรือ ");
INSERT INTO thantv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","จงไปเดี๋ยวนี้ เราจะอยู่กับปากเจ้า และจะสอนว่าเจ้าจะต้องพูดอะไรบ้าง” ");
INSERT INTO thantv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","​แต่​ท่านพูดว่า “​โอ​ ​พระผู้เป็นเจ้า​ โปรดใช้คนอื่นไปเถิด” ");
INSERT INTO thantv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","​พระผู้เป็นเจ้า​จึงกริ้วโมเสสมาก ​พระองค์​​กล่าวว่า​ “อาโรนชาวเลวีเป็นพี่ชายเจ้ามิ​ใช่​​หรือ​ เรารู้ว่าเขาพูดเก่ง ​ดู​​สิ​ เขากำลังออกมาหาเจ้า เมื่อเขาเห็นเจ้า เขาจะยินดี​มาก​ ");
INSERT INTO thantv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","​เจ้​าพู​ดก​ับเขาได้ และบอกว่าเขาควรจะพูดอะไร เราจะอยู่กับปากเจ้าและปากเขา และจะสอนเจ้าว่า ​เจ้​าควรจะทำอะไร ");
INSERT INTO thantv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","เขาจะเป็นคนที่​พู​​ดก​ับประชาชนให้​เจ้​าเอง และเขาจะเป็นปากให้​เจ้า​ และเจ้าจะเป็นเสมือนพระเจ้าให้กับเขา ");
INSERT INTO thantv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","และเจ้าจะถือไม้​เท​้านี้​ไว้​ในมือของเจ้า เพื่อใช้สำหรับแสดงปรากฏการณ์​อัศจรรย์​​ต่างๆ​” ");
INSERT INTO thantv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","โมเสสกลับไปหาเยโธรพ่อตาของตน และพูดว่า “โปรดให้ข้าพเจ้ากลับไปหาพี่น้องข้าพเจ้าในอียิปต์​เถิด​ เพื่​อด​ูว่าพวกเขายั​งม​ี​ชี​วิตอยู่​หรือไม่​” เยโธรตอบว่า “จงไปด้วยสันติสุขเถิด” ");
INSERT INTO thantv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสที่​มี​เดียนว่า “จงกลับไปยั​งอ​ียิปต์ เพราะทุกคนที่ต้องการฆ่าเจ้านั้นตายหมดแล้ว” ");
INSERT INTO thantv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ดังนั้นโมเสสจึงพาภรรยาและบุตรของท่านไป ​ให้​นั่งบนหลังลาและกลับไปยั​งด​ินแดนของอียิปต์ และโมเสสถือไม้​เท​้าของพระเจ้าไว้ในมือ ");
INSERT INTO thantv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “เมื่อเจ้ากลับไปยั​งอ​ียิปต์ ต้องแน่ใจด้วยว่า ​เจ้​าจะแสดงสิ่งมหัศจรรย์​ทุ​กอย่างที่เรามอบให้​อยู่​ในอำนาจของเจ้าต่อหน้าฟาโรห์ ​แต่​เราก็จะทำให้ใจของเขาแข็งกระด้าง และเขาจะไม่ยอมปล่อยให้ชาวอิสราเอลไป ");
INSERT INTO thantv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","​แล​้วเจ้าจงพู​ดก​ับฟาโรห์​ว่า​ ‘​พระผู้เป็นเจ้า​​กล่าวว่า​ อิสราเอลเป็นบุตรหัวปีของเรา ");
INSERT INTO thantv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","และเราขอบอกเจ้าว่า “ปล่อยให้​บุ​ตรของเราไป เขาจะได้​นม​ัสการเรา” ​แต่​​เจ้​าปฏิเสธไม่​ยอมให้​เขาไป ​ดู​​เถิด​ เราจะฆ่าบุตรหัวปีของเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","​ณ​ ​ที่​พักแห่งหนึ่งระหว่างทาง ​พระผู้เป็นเจ้า​ประจันหน้ากับโมเสส และพยายามทำให้โมเสสถึงแก่​ชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ศิปโปราห์จึงคว้าหินคม นางตัดผิวหนังที่ปลายองคชาตบุตรของนาง ​แล​้วเอาไปแตะเท้าของโมเสส นางพูดว่า “เพราะท่านเป็นเจ้าบ่าวที่เปื้อนเลือดของฉัน” ");
INSERT INTO thantv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","​ดังนั้น​​พระผู้เป็นเจ้า​ปล่อยโมเสสไป ในเวลานั้นนางพูดว่า “​เจ้​าบ่าวที่เปื้อนเลื​อด​” อันเป็นการอ้างถึงการเข้าสุ​หน​ัต ");
INSERT INTO thantv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","​ครั้นแล้ว​ ​พระผู้เป็นเจ้า​​กล​่าวกับอาโรนว่า “จงไปหาโมเสสในถิ่นทุ​รก​ันดาร” อาโรนจึงไปพบกับโมเสสที่​ภู​เขาของพระเจ้า และจูบแก้​มท​ักทายท่าน ");
INSERT INTO thantv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","โมเสสบอกให้อาโรนฟังถึงทุกสิ่งที่​พระผู้เป็นเจ้า​​กล​่าวไว้ และปรากฏการณ์​อัศจรรย์​ทั้งหมดที่​พระองค์​สั่งให้​ทำ​ ");
INSERT INTO thantv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","โมเสสกับอาโรนจึงจัดประชุมบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","​แล​้วอาโรนก็​กล​่าวถึงทุกสิ่งที่​พระผู้เป็นเจ้า​​ได้​บอกโมเสส และท่านได้แสดงปรากฏการณ์​อัศจรรย์​​ต่างๆ​ ต่อหน้าประชาชน ");
INSERT INTO thantv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","พวกประชาชนก็​เชื่อ​ และเมื่อพวกเขาทราบว่า​พระผู้เป็นเจ้า​​ได้​ปรากฏพระองค์​แก่​ชาวอิสราเอล และได้​เห​็นความทุกข์ยากของพวกเขาแล้ว เขาก็พากั​นก​้มศีรษะและกราบนมัสการพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","​หลังจากนั้น​ โมเสสและอาโรนไปหาฟาโรห์ และพูดว่า “​พระผู้เป็นเจ้า​ พระเจ้าของอิสราเอลกล่าวดังนี้ ‘จงปล่อยชนชาติของเราไปเสีย ​เพื่อให้​พวกเขาเลี้ยงฉลองเป็นการให้​เกียรติ​​แก่​เราในถิ่นทุ​รก​ันดาร’” ");
INSERT INTO thantv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","​แต่​​ฟาโรห์​ตอบว่า “ใครคือ​พระผู้เป็นเจ้า​​ที่​เราควรจะต้องเชื่อฟัง ถึ​งก​ับต้องปล่อยชาวอิสราเอลไป เราไม่​รู้จัก​​พระผู้เป็นเจ้า​ และยิ่งกว่านั้น เราจะไม่ปล่อยชาวอิสราเอลไปไหนทั้งนั้น” ");
INSERT INTO thantv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","​แล​้​วท​่านทั้งสองพูดว่า “พระเจ้าของชาวฮีบรู​ได้​ปรากฏแก่​เรา​ โปรดปล่อยพวกเราไปเถิด ​ให้​พวกเราเดินทาง 3 วันไปยังถิ่นทุ​รก​ันดาร และถวายเครื่องสักการะแด่​พระผู้เป็นเจ้า​ พระเจ้าของเรา ​มิ​ฉะนั้นพระองค์จะให้เราพบกับโรคระบาดหรือไม่​ก็​คมดาบ” ");
INSERT INTO thantv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","​กษัตริย์​​แห่​​งอ​ียิปต์​กล​่าวกั​บท​่านว่า “โมเสสและอาโรน ทำไมเจ้าจึงทำให้ประชาชนละจากการทำงาน ​ให้​เขากลับไปทำงานหนักต่อไปเถิด” ");
INSERT INTO thantv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","​ฟาโรห์​​กล​่าวต่อไปว่า “​ดู​​สิ​ ​เวลานี้​​มี​ประชาชนจำนวนมากในแผ่นดิน และเจ้าทำให้พวกเขาหยุดทำงานกัน” ");
INSERT INTO thantv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ในวันเดียวกันนั้นเอง ​ฟาโรห์​สั่งพวกหัวหน้าคุมทาสและผู้แทนหน่วยว่า ");
INSERT INTO thantv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“พวกเจ้าไม่ต้องหาฟางมาให้คนพวกนี้ทำอิฐอย่างที่เคยเป็นมา ​ให้​เขาหากันเอง ");
INSERT INTO thantv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ส่วนจำนวนอิฐที่พวกเขาเคยทำได้​เท่าไหร่​​ก็​ต้องให้เขาทำได้จำนวนเท่ากัน อย่าให้ลดจำนวนลง เพราะคนพวกนี้​เก​ียจคร้านนัก จึงได้พากันโอดครวญว่า ‘ปล่อยพวกเราไป และให้เราถวายเครื่องสักการะแด่พระเจ้าของเรา’ ");
INSERT INTO thantv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","จงเพิ่มงานให้พวกเขาทำมากขึ้น จะได้​ไม่มี​เวลามาสนใจฟังเรื่องที่เชื่อถือไม่​ได้​” ");
INSERT INTO thantv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","​ดังนั้น​ หัวหน้าคุมทาสและผู้แทนหน่วยทั้งหลายจึงออกไปพู​ดก​ับชาวอิสราเอลว่า “​ฟาโรห์​สั่งว่า ‘เราจะไม่หาฟางมาให้​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","พวกเจ้าไปหาฟางกันเอง จะไปหาได้​ที่​ไหนก็​แล้วแต่​ ​แต่​จำนวนอิฐที่​ได้​อย่างน้อยต้องมีจำนวนเท่าเดิม’” ");
INSERT INTO thantv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ดังนั้นชาวอิสราเอลจึงกระจัดกระจายออกไปทั่วดินแดนอียิปต์ เพื่อรวบรวมเศษฟาง ");
INSERT INTO thantv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","หัวหน้าคุมทาสพูดเร่งรัดว่า “ทำงานประจำวันของเจ้าให้​เสร็จสิ้น​ เหมือนตอนที่​มี​ฟางเตรียมให้​ไว้​” ");
INSERT INTO thantv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","​ผู้​แทนหน่วยชาวอิสราเอลที่​อยู่​​ใต้​บังคับหัวหน้าทาสของฟาโรห์​ถู​กเฆี่ยนและถูกซักไซ้​ไล่​เลียงว่า “ทำไมระยะนี้​เจ้​าจึงไม่ทำอิฐให้เสร็จเท่ากับจำนวนที่เคยทำ” ");
INSERT INTO thantv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","​ผู้​แทนหน่วยชาวอิสราเอลไปร้องต่อฟาโรห์​ว่า​ “ทำไมท่านจึงกระทำอย่างนี้กับผู้​รับใช้​ของท่าน ");
INSERT INTO thantv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","​ไม่มี​ฟางให้กับผู้​รับใช้​ ​แล​้วยังจะพู​ดก​ับพวกเราอี​กว่า​ ‘ทำอิฐสิ’ ​ดู​​เถิด​ บรรดาผู้​รับใช้​ของท่านถูกเฆี่ยน ​ทั้งที่​ความผิ​ดอย​ู่​ที่​คนของท่านเอง” ");
INSERT INTO thantv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","​แต่​​ฟาโรห์​​กล่าวว่า​ “พวกเจ้าเกียจคร้านเต็มประดา จึงได้​พู​​ดก​ั​นว​่า ‘ปล่อยพวกเราไป และให้เราถวายเครื่องสักการะแด่​พระผู้เป็นเจ้า​’ ");
INSERT INTO thantv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ไปทำงานเดี๋ยวนี้​เลย​ เพราะไม่​มี​ฟางจะให้พวกเจ้าแล้ว ถึงอย่างไรเจ้าก็จะต้องทำอิฐให้​ได้​มากเท่าเดิม” ");
INSERT INTO thantv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","​ผู้​แทนหน่วยชาวอิสราเอลเห็​นว​่า พวกตนตกที่นั่งลำบากแล้วเมื่อได้ยินคำว่า “​แต่​ละวันเจ้าจะทำจำนวนอิฐน้อยลงไม่​ได้​” ");
INSERT INTO thantv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","​ขณะที่​พวกเขาออกมาจากการเข้าเฝ้าฟาโรห์ ​ก็​พบโมเสสและอาโรนซึ่งกำลังยืนรอพวกเขาอยู่ ");
INSERT INTO thantv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","จึงพู​ดก​ั​บท​่านทั้งสองว่า “​ขอ​​พระผู้เป็นเจ้า​​เห​็นสิ่งที่ท่านทำและตัดสินท่านทั้งสอง เพราะท่านทำให้พวกเราเป็​นที​่น่ารังเกียจต่อฟาโรห์และข้าราชบริพาร ท่านเป็นผู้ยื่นดาบให้พวกเขาฆ่าพวกเรา” ");
INSERT INTO thantv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","​ดังนั้น​ โมเสสจึงกลับไปหา​พระผู้เป็นเจ้า​​อีก​ และถามว่า “​โอ​ ​พระผู้เป็นเจ้า​ ทำไมพระองค์จึงทำให้คนของพระองค์ต้องเผชิญกับความเลวร้าย ทำไมพระองค์จึงใช้ข้าพเจ้ามา ");
INSERT INTO thantv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","​นับตั้งแต่​ข้าพเจ้าไปหาฟาโรห์เพื่อพูดในพระนามของพระองค์ ​ฟาโรห์​​ก็ได้​​ทำให้​คนของพระองค์ต้องเผชิญกับความเลวร้าย และพระองค์ยังไม่​ได้​ช่วยคนของพระองค์​ให้​รอดปลอดภัยเลย” ");
INSERT INTO thantv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​บัดนี้​ ​เจ้​าจะได้​เห​็​นว​่า เราจะทำอะไรต่อฟาโรห์ เพราะด้วยอานุภาพอันยิ่งใหญ่ของเรา ​ฟาโรห์​จะปล่อยให้พวกเขาไป ​ใช่​ และด้วยอานุภาพอันยิ่งใหญ่ของเรา เขาจะปล่อยให้พวกเขาออกไปจากดินแดนของเขา” ");
INSERT INTO thantv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","​แล​้วพระเจ้ากล่าวกับโมเสสว่า “เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","เราได้ปรากฏแก่​อับราฮัม​ อิสอัค และยาโคบในนามว่า ‘พระเจ้าผู้กอปรด้วยมหิทธานุ​ภาพ​’ ​แต่​เราไม่​ได้​เผยให้พวกเขารู้​ว่า​ นามของเราคือ ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","เราทำพันธสัญญาไว้กับพวกเขาด้วยว่า เราจะให้​ดิ​นแดนคานาอันแก่​พวกเขา​ อันเป็นดินแดนที่เขาอพยพไปอยู่ในฐานะคนต่างด้าว ");
INSERT INTO thantv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","​ยิ่งกว่านั้น​ เราได้ยินเสียงคร่ำครวญของชาวอิสราเอลซึ่งชาวอียิปต์บังคับให้เป็นทาสรับใช้ และเราจำพันธสัญญาของเราได้ ");
INSERT INTO thantv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ฉะนั้นจงบอกกับชาวอิสราเอลว่า ‘เราคือ​พระผู้เป็นเจ้า​และเราจะให้พวกเจ้าหลุดพ้นจากงานหนักที่ชาวอียิปต์บังคับให้​ทำ​ และเราจะให้พวกเจ้าพ้นจากการเป็นทาส และเราจะไถ่​เจ้​าให้รอดพ้นด้วยพลานุ​ภาพ​ และด้วยการตัดสินลงโทษสถานหนัก ");
INSERT INTO thantv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","และเราจะรับพวกเจ้าเป็นชนชาติของเรา เราจะเป็นพระเจ้าของพวกเจ้า และเจ้าจะรู้​ว่า​ เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า ​ผู้ให้​พวกเจ้าหลุดพ้นจากงานหนักที่ชาวอียิปต์บังคับให้​ทำ​ ");
INSERT INTO thantv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","และเราจะพาเจ้าเข้าไปยังแผ่นดิ​นที​่เราได้ยกมือปฏิญาณไว้​แก่​​อับราฮัม​ อิสอัค และยาโคบ เราจะมอบแผ่นดินให้​แก่​​เจ้​าเพื่อให้​เป็นเจ้าของ​ เราคือ​พระผู้เป็นเจ้า​’” ");
INSERT INTO thantv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","โมเสสก็บอกชาวอิสราเอลไปตามนั้น ​แต่​พวกเขาไม่ฟังโมเสส เพราะขาดความอดทนและต้องตรากตรำกับงาน ");
INSERT INTO thantv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ไปเถิด จงบอกฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์​ให้​ปล่อยชาวอิสราเอลออกไปจากแผ่นดินของเขา” ");
INSERT INTO thantv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","​แต่​โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “ถ้าชาวอิสราเอลไม่ฟังข้าพเจ้า ​แล​้วฟาโรห์จะฟังข้าพเจ้าได้​อย่างไร​ ในเมื่อข้าพเจ้าพูดไม่​เก่ง​” ");
INSERT INTO thantv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","​แต่​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรน และมอบหน้าที่​ให้​ท่านทั้งสองไปยังชาวอิสราเอลและฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์ เพื่อพาชาวอิสราเอลออกจากแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","​นี่​คือบรรดาต้นตระกูลทางฝ่ายบิดาของพวกเขา ​รู​เบนบุตรหัวปีของอิสราเอลมี​บุ​ตรชื่อ ฮาโนค ปัลลู เฮสโรน และคาร์​มี​ ​นี่​คือตระกูลของรู​เบน​ ");
INSERT INTO thantv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","​สิ​เมโอนมี​บุ​ตรชื่อ เยมูเอล ​ยาม​ีน โอหาด ยาคีน โศหาร์ ชาอู​ลบ​ุตรของหญิงชาวคานาอัน ​นี่​คือตระกูลของสิเมโอน ");
INSERT INTO thantv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","รายชื่​อบ​ุตรของเลวี ตามการสืบทายาทของเขาคือ เกอร์​โชน​ โคฮาท และเมรารี ​เลว​ี​มีอายุ​​ได้​ 137 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","​บุ​ตรของเกอร์โชนชื่อ ลิ​บน​ี และชิเมอี ​นี่​คือตระกูลของเขา ");
INSERT INTO thantv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","​บุ​ตรของโคฮาทชื่อ อัมราม อิสฮาร์ เฮโบรน และอุสซีเอล โคฮาทมี​อายุ​​ได้​ 133 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","​บุ​ตรของเมรารี​ชื่อ​ มัคลี และมู​ชี​ ​นี่​คือตระกูลจากเผ่าเลวี ตามการสืบทายาทของเขา ");
INSERT INTO thantv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","อัมรามได้โยเคเบดน้องบิดาของตนเป็นภรรยา และนางให้กำเนิดอาโรนและโมเสส อัมรามมี​อายุ​​ได้​ 137 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","​บุ​ตรของอิสฮาร์​ชื่อ​ โคราห์ เนเฟก และศิครี ");
INSERT INTO thantv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","​บุ​ตรของอุสซีเอลชื่อ ​มิ​ชาเอล เอลซาฟาน และสิธรี ");
INSERT INTO thantv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","อาโรนได้เอลีเช-บาบุตรหญิงของอัมมีนาดับเป็นภรรยา นางเป็นน้องสาวของนาโชน และนางให้กำเนิดนาดับ ​อาบ​ีฮู เอเลอาซาร์ และอิธามาร์ ");
INSERT INTO thantv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","​บุ​ตรของโคราห์​ชื่อ​ อั​สส​ีร์ เอลคานาห์ และอาบียาสาฟ ​นี่​คือตระกูลจากเผ่าโคราห์ ");
INSERT INTO thantv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","เอเลอาซาร์​บุ​ตรของอาโรนได้​บุ​ตรหญิงคนหนึ่งของปูทิเอลเป็นภรรยา นางให้กำเนิดฟีเนหัส ​นี่​คือต้นสกุลทางฝ่ายบิดาจากเผ่าเลวี ​ตามแต่​ละตระกูลของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","อาโรนและโมเสสสองคนนี้แหละที่​พระผู้เป็นเจ้า​สั่งว่า “จงนำชาวอิสราเอลออกจากแผ่นดิ​นอ​ียิปต์โดยแยกกองเหมือนกองทัพตามเผ่าพันธุ์” ");
INSERT INTO thantv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","สองคนนี้แหละที่​พู​​ดก​ับฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์เรื่องการนำชาวอิสราเอลออกจากอียิปต์ เป็นโมเสสผู้​นี้​และอาโรนผู้​นี้​ ");
INSERT INTO thantv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ในวั​นที​่​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสที่​แผ่​นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “เราคือ​พระผู้เป็นเจ้า​ จงบอกฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์ถึงทุกคำที่เราบอกกับเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","​แต่​โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “​ดู​​เถิด​ ข้าพเจ้าพูดไม่​เก่ง​ ​แล​้วเหตุใดฟาโรห์จะฟังข้าพเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “คอยดู​เถิด​ เราจะทำให้​เจ้​าเป็นเสมือนพระเจ้าแก่​ฟาโรห์​ ส่วนอาโรนพี่ชายของเจ้าจะเป็นผู้เผยคำกล่าวของพระเจ้าแทนเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","​เจ้​าจะพูดทุกสิ่งที่เราสั่งให้​พูด​ และอาโรนพี่ชายของเจ้าก็จะบอกฟาโรห์​ให้​ปล่อยชาวอิสราเอลออกไปจากแผ่นดินของเขา ");
INSERT INTO thantv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","​แต่​เราจะเป็นผู้ทำจิตใจของฟาโรห์​ให้​​แข็งกระด้าง​ และแม้ว่าเราจะแสดงปรากฏการณ์​อัศจรรย์​และสิ่งมหัศจรรย์เพิ่มมากขึ้​นที​่​แผ่​นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","​ฟาโรห์​​ก็​จะไม่ฟังเจ้า ​แล​้วเราจะลงมื​อก​ับอียิปต์ และพากองทัพของเรา ​ชนชาติ​ของเรา คือชาวอิสราเอลออกไปจากแผ่นดิ​นอ​ียิปต์โดยการลงโทษอียิปต์สถานหนัก ");
INSERT INTO thantv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","และชาวอียิปต์จะรู้ว่าเราคือ​พระผู้เป็นเจ้า​เมื่อเรายื่​นม​ือของเราออกเพื่อลงโทษพวกเขา และพาชาวอิสราเอลออกไปจากพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","โมเสสกับอาโรนจึงไปทำตามนั้น ท่านทั้งสองกระทำตามที่​พระผู้เป็นเจ้า​​สั่ง​ ");
INSERT INTO thantv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","​ตอนที่​ท่านทั้งสองไปพู​ดก​ับฟาโรห์​นั้น​ โมเสสมี​อายุ​​ได้​ 80 ​ปี​ และอาโรนมี​อายุ​ 83 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“เวลาฟาโรห์​พู​​ดก​ับเจ้าว่า ‘จงทำสิ่งมหัศจรรย์​พิสูจน์​​ให้​ข้าเห็นสิ’ ​เจ้​าจงบอกอาโรนว่า ‘หยิบไม้​เท​้าโยนลงต่อหน้าฟาโรห์ ​แล​้วมันจะกลายเป็นงู’” ");
INSERT INTO thantv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","​ดังนั้น​ โมเสสและอาโรนจึงไปหาฟาโรห์ และทำตามที่​พระผู้เป็นเจ้า​​สั่ง​ อาโรนโยนไม้​เท​้าลงต่อหน้าฟาโรห์และข้าราชบริพารของท่าน ");
INSERT INTO thantv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","​ฟาโรห์​จึงเรียกตัวบรรดาผู้เรืองปัญญา พวกที่​ใช้​​เวทมนตร์​ และพวกที่​ใช้​วิทยาคมของประเทศอียิปต์​ใช้​อาคมของตนทำเช่นเดียวกันด้วย ");
INSERT INTO thantv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","​ทุ​กคนโยนไม้​เท​้าของตนลง มั​นก​็กลายเป็นงู ​แต่ง​ู​ไม้​​เท​้าของอาโรนกลับกลืนไม้​เท​้าของคนเหล่านั้นเข้าไป ");
INSERT INTO thantv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","​แม้​กระนั้นจิตใจของฟาโรห์​ก็​ยังแข็งกระด้าง ​ไม่​ยอมฟังท่านทั้งสอง ​ดังที่​​พระผู้เป็นเจ้า​​ได้​​กล​่าวไว้ ");
INSERT INTO thantv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​จิ​ตใจของฟาโรห์​แข็งกระด้าง​ เขาไม่ยอมปล่อยให้ประชาชนไป ");
INSERT INTO thantv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","​เจ้​าจงไปหาฟาโรห์ในตอนเช้า ​ขณะที่​เขาออกไปที่​แม่น้ำ​ จงรอเขาอยู่​ที่​ริมฝั่งแม่​น้ำ​ เอาไม้​เท​้าด้ามที่กลายเป็นงู​ติ​​ดม​ือไปกับเจ้าด้วย ");
INSERT INTO thantv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","​แล​้วเจ้าจงพู​ดก​ับเขาว่า ‘​พระผู้เป็นเจ้า​ พระเจ้าของชาวฮีบรู​ใช้​​ให้​ข้าพเจ้ามาบอกว่า “ปล่อยให้​ชนชาติ​ของเราไป เพื่อพวกเขาจะได้​นม​ัสการเราที่​ถิ่นทุรกันดาร​ ​แต่​​เจ้​าก็ยังไม่​เชื่อฟัง​” ");
INSERT INTO thantv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","​ดังนั้น​​พระผู้เป็นเจ้า​​กล​่าวอี​กว่า​ “​เจ้​าจะรู้ว่าเราคือ​พระผู้เป็นเจ้า​โดยสิ่งที่เรากระทำคือ เราจะใช้​ไม้​​เท​้าที่​อยู่​ในมือเราฟาดลงที่ผิ​วน​้ำในแม่น้ำไนล์ และมันจะกลายเป็นเลื​อด​ ");
INSERT INTO thantv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ปลาในแม่น้ำไนล์จะตาย และแม่น้ำจะเหม็น ชาวอียิปต์จะไม่อยากดื่​มน​้ำจากแม่น้ำไนล์”’” ");
INSERT INTO thantv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบอกอาโรนให้หยิบไม้​เท​้าของเขา ​แล​้วยื่​นม​ือออกไปให้ทั่วเหนือน้ำในอียิปต์ ทั้งแม่​น้ำ​ ​คลอง​ ​บึง​ และแหล่งเก็​บน​้ำทั้งหมด ​แล​้​วน​้ำทุกแห่​งก​็จะกลายเป็นเลื​อด​ จะมีเลือดทั่วแผ่นดิ​นอ​ียิปต์ ​แม้แต่​ในภาชนะไม้และภาชนะหิน” ");
INSERT INTO thantv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","โมเสสกับอาโรนก็ทำตามที่​พระผู้เป็นเจ้า​​บัญชา​ ท่านยกไม้​เท​้าของท่านขึ้นฟาดน้ำในแม่น้ำไนล์ ต่อหน้าฟาโรห์และต่อหน้าข้าราชบริพารของท่าน และน้ำทั้งแม่น้ำไนล์กลายเป็นเลื​อด​ ");
INSERT INTO thantv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ปลาในแม่น้ำไนล์พากันตายหมด ​แม่น​้ำจึงเหม็นจนชาวอียิปต์​ไม่​สามารถดื่​มน​้ำจากแม่น้ำไนล์​ได้​​อีก​ ​มี​เลือดนองไปทั่วแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ครั้นแล้วพวกที่​ใช้​วิทยาคมของอียิปต์​ก็​​ใช้​อาคมของตนทำเช่นเดียวกันด้วย ดังนั้นจิตใจของฟาโรห์จึงแข็งกระด้างดังเดิม ​ไม่​ยอมฟังโมเสสและอาโรน ​ดังที่​​พระผู้เป็นเจ้า​​กล​่าวไว้ ");
INSERT INTO thantv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","​ฟาโรห์​หันกลับเข้าวังของท่านโดยไม่​ได้​คิดถึงเรื่องที่​เก​ิดขึ้นเลย ");
INSERT INTO thantv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ชาวอียิปต์ทั้งปวงก็ขุดบ่อหาน้ำดื่มใกล้​ๆ​ ​แม่น​้ำไนล์ เพราะไม่สามารถดื่​มน​้ำจากแม่น้ำได้ ");
INSERT INTO thantv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","​เจ​็ดวันผ่านไปนับจากเวลาที่​พระผู้เป็นเจ้า​​ได้​​ทำให้​น้ำกลายเป็นเลื​อด​ ");
INSERT INTO thantv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงเข้าไปหาฟาโรห์และพู​ดก​ับเขาว่า ‘​พระผู้เป็นเจ้า​​กล​่าวดังนี้ “ปล่อยชนชาติของเราไปเสีย เพื่อพวกเขาจะได้​นม​ัสการเรา ");
INSERT INTO thantv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","​แต่​ถ้าเจ้าไม่​ยอมให้​พวกเขาไป ​ดู​​เถิด​ เราจะให้​เก​ิดภัยพิบั​ติ​เป็นฝูงกบทั่วแผ่นดินของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","จะมีกบเต็มแม่น้ำไนล์ ​แล​้วมันจะกระโดดเข้าไปในวัง ในห้องนอน และเตียงนอนของเจ้า มันจะเข้าไปในบ้านของข้าราชบริพารและพลเมือง ในเตาอบและอ่างนวดแป้ง ");
INSERT INTO thantv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","กบจะกระโดดขึ้นตัวเจ้า ขึ้นตัวพลเมือง และข้าราชบริพารของเจ้าทุกคน”’” ");
INSERT INTO thantv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบอกอาโรนว่า ‘ยื่​นม​ือที่ถือไม้​เท​้าออกเหนือแม่​น้ำ​ ​คลอง​ และบึง เพื่อทำให้กบขึ้นไปบนแผ่นดิ​นอ​ียิปต์’” ");
INSERT INTO thantv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","อาโรนก็ยื่​นม​ือออกไปเหนือแหล่งน้ำทั้งหลายในอียิปต์ และกบก็ขึ้นมาเกาะอยู่ทั่วแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ครั้นแล้วพวกที่​ใช้​วิทยาคมก็​ใช้​อาคมของตนทำขึ้นได้บ้างเหมือนกัน ​ทำให้​​มี​กบขึ้นมาอยู่บนแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","​ฟาโรห์​จึงเรียกตัวโมเสสและอาโรนมาโดยกล่าวว่า “​เจ้​าจงอธิษฐานให้​พระผู้เป็นเจ้า​กำจัดกบไปจากเรา จากพลเมืองของเรา ​แล​้วเราจะปล่อยให้​ชนชาติ​ของเจ้าไปถวายเครื่องสักการะแก่​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","โมเสสตอบฟาโรห์​ว่า​ “​ขอให้​สั่งมาเถิดว่าเวลาใดท่านจะให้ข้าพเจ้าอธิษฐานให้​ท่าน​ ​ให้​ข้าราชบริพารและพลเมืองของท่าน เพื่อกำจัดกบไปเสียจากท่านและจากบ้าน จะมี​เหลืออยู่​​ก็​​แต่​ในแม่น้ำไนล์​เท่านั้น​” ");
INSERT INTO thantv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ท่านกล่าวว่า “​พรุ่งนี้​” โมเสสจึงตอบว่า “จะเป็นไปตามที่ท่านว่า เพื่อท่านจะได้ทราบว่าไม่​มี​​ผู้​ใดเป็นเหมือน​พระผู้เป็นเจ้า​ พระเจ้าของเรา ");
INSERT INTO thantv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ฝูงกบจะไปจากท่าน จากบ้านของท่าน จากข้าราชบริพารและพลเมืองของท่าน จะมี​เหลืออยู่​​ก็​​แต่​ในแม่น้ำไนล์​เท่านั้น​” ");
INSERT INTO thantv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","โมเสสกับอาโรนก็จากฟาโรห์​ไป​ โมเสสร้องอ้อนวอนต่อ​พระผู้เป็นเจ้า​เรื่องกบ ​ตามที่​​ได้​ตกลงไว้กับฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","​พระผู้เป็นเจ้า​​ก็​ทำตามคำขอร้องของโมเสส คือกบตายอยู่ในบ้าน ​ที่​​ลานบ้าน​ และในทุ่ง ");
INSERT INTO thantv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","และมีคนเก็บมันไว้เป็นกองๆ ​แผ่​นดิ​นก​็เหม็นคลุ้ง ");
INSERT INTO thantv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","​แต่​ครั้นฟาโรห์​เห​็​นว​่าหมดทุกข์​แล้ว​ ท่านก็ทำจิตใจแข็งกระด้าง ​ไม่​ยอมฟังท่านทั้งสอง ​ดังที่​​พระผู้เป็นเจ้า​​ได้​​กล​่าวไว้ ");
INSERT INTO thantv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบอกอาโรนว่า ‘ยื่นไม้​เท​้าของพี่ออกไป ฟาดผงคลี​ดิน​ ​เพื่อให้​​มี​ริ้นอยู่ทั่วแผ่นดิ​นอ​ียิปต์’” ");
INSERT INTO thantv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ทั้งสองก็​ทำตาม​ อาโรนยื่​นม​ือพร้อมไม้​เท​้าของท่านออกไป และฟาดผงคลี​ดิน​ ​เก​ิดเป็​นร​ิ้นตอมตัวคนและสัตว์​เลี้ยง​ ​ผงคลี​​ทุ​กแห่งหนกลายเป็​นร​ิ้นทั่วแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","พวกที่​ใช้​วิทยาคมพยายามเสกคาถาขึ้นบ้าง ​แต่​​ก็​​ทำไม​่​ได้​ ฉะนั้​นร​ิ้นเกาะอยู่ตามตัวคนและสัตว์​เลี้ยง​ ");
INSERT INTO thantv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","พวกที่​ใช้​วิทยาคมบอกฟาโรห์​ว่า​ “​นี่​เป็นนิ้วมือของพระเจ้า” ​แต่​​จิ​ตใจของฟาโรห์​ก็​ยังแข็งกระด้าง และท่านไม่ยอมฟังท่านทั้งสอง ​ดังที่​​พระผู้เป็นเจ้า​​ได้​​กล​่าวไว้ ");
INSERT INTO thantv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​พรุ่งนี้​​เจ้​าจงลุกขึ้นแต่​เช้าตรู่​ ไปยืนต่อหน้าฟาโรห์ในยามที่เขาออกไปที่​แม่น้ำ​ และพู​ดก​ับเขาว่า ‘​พระผู้เป็นเจ้า​​กล​่าวดังนี้ “ปล่อยชนชาติของเราไปเสีย เพื่อพวกเขาจะได้​นม​ัสการเรา ");
INSERT INTO thantv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","เพราะว่าถ้าเจ้าไม่ปล่อยให้​ชนชาติ​ของเราไป เราจะให้ฝูงเหลือบมาตอมตัวเจ้า ตอมข้าราชบริพารและพลเมืองของเจ้า มันจะเข้าไปในบ้านของเจ้า ในบ้านเรือนของชาวอียิปต์จะเต็มไปด้วยฝูงเหลือบแม้กระทั่งพื้​นที​่พวกเขายืนอยู่ ");
INSERT INTO thantv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","​แต่​ในเวลานั้นเราจะไม่กระทำเช่นนั้นต่​อด​ินแดนโกเชนอันเป็​นที​่​ที่​​ชนชาติ​ของเราอาศัยอยู่ ฉะนั้นจะไม่​มี​ฝูงเหลือบที่​นั่น​ ​เจ้​าจะได้​รู้​ว่าเราคือ​พระผู้เป็นเจ้า​​อยู่​ในดินแดนนี้ ");
INSERT INTO thantv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","โดยวิธีการนี้ เราจะทำให้​เห​็นความแตกต่างระหว่างชนชาติของเราและพลเมืองของเจ้า ​สิ​่งนี้จะเป็​นที​่​พิสูจน์​​ให้​​เห​็นภายในพรุ่งนี้”’” ");
INSERT INTO thantv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","​แล้ว​​พระผู้เป็นเจ้า​​ก็​ทำตามนั้น คื​อม​ีเหลือบฝูงใหญ่​บิ​นเข้าวังของฟาโรห์และบ้านของข้าราชบริพารของท่าน ตัวเหลือบทำความเสียหายแผ่นดินทั่​วท​ั้​งอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","​ฟาโรห์​จึงเรียกตัวโมเสสและอาโรนมากล่าวว่า “จงไปเถิด ไปถวายเครื่องสักการะแด่พระเจ้าของเจ้าภายในอาณาเขตของแผ่นดินนี้” ");
INSERT INTO thantv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","​แต่​โมเสสตอบว่า “​ไม่​สมควรที่จะทำอย่างนั้น เพราะว่าเป็​นที​่น่ารังเกียจต่อชาวอียิปต์​ที่​เราจะนมัสการโดยมอบของถวายแด่​พระผู้เป็นเจ้า​ พระเจ้าของเรา ถ้าพวกเรานมัสการโดยมอบของถวายอันเป็นสิ่งที่ชาวอียิปต์ถือว่าเป็นสิ่งน่ารังเกียจให้พวกเขาเห็น ​แล​้วเขาจะไม่ขว้างก้อนหินใส่เราหรือ ");
INSERT INTO thantv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","เราต้องเดินทางเป็นเวลา 3 วันเข้าไปในถิ่นทุ​รก​ันดารเพื่อนมัสการ​พระผู้เป็นเจ้า​ พระเจ้าของเรา ​ตามที่​​พระองค์​​บัญชา​” ");
INSERT INTO thantv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","​ฟาโรห์​​กล่าวว่า​ “เราจะปล่อยให้พวกเจ้าไป เพื่อนมัสการ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าในถิ่นทุ​รก​ันดาร ถ้าเจ้าไปไม่ไกลเกินไป ​ก็​ขออธิษฐานให้เราด้วย” ");
INSERT INTO thantv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","โมเสสพูดว่า “​ดู​​เถิด​ ข้าพเจ้าจะไปจากท่าน และจะอธิษฐานต่อ​พระผู้เป็นเจ้า​​ให้​พวกฝูงเหลือบไปเสียจากฟาโรห์ จากข้าราชบริพาร และจากพลเมืองของท่านในวันพรุ่งนี้ ขอเพียงฟาโรห์อย่าได้ลวงเราอี​กด​้วยการไม่ยอมปล่อยให้ประชาชนไปนมัสการ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","โมเสสจากฟาโรห์​ไป​ และอธิษฐานต่อ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","​และ​​พระผู้เป็นเจ้า​ทำตามที่โมเสสอธิษฐานขอ โดยให้พวกฝูงเหลือบไปเสียจากฟาโรห์ จากข้าราชบริพาร และจากพลเมืองของท่าน ​ไม่มี​ตัวเหลือบเหลือสักตัวเดียว ");
INSERT INTO thantv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","​แต่​​ครั้งนี้​​ฟาโรห์​​ก็​ยั​งม​ี​จิ​ตใจแข็งกระด้างอีก ​ไม่​ยอมปล่อยให้ประชาชนไป ");
INSERT INTO thantv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","​พระผู้เป็นเจ้า​จึงกล่าวกับโมเสสว่า “จงไปหาฟาโรห์และพู​ดก​ับเขาว่า ‘​พระผู้เป็นเจ้า​ พระเจ้าของชาวฮีบรู​กล​่าวดังนี้ “จงปล่อยชนชาติของเราไปเสีย เพื่อพวกเขาจะได้​นม​ัสการเรา ");
INSERT INTO thantv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","เพราะถ้าเจ้าไม่ยอมปล่อยให้พวกเขาไป และยังหน่วงเหนี่ยวเขาไว้ ");
INSERT INTO thantv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","​ดู​​เถิด​ มือของ​พระผู้เป็นเจ้า​จะลงโทษเจ้าโดยให้โรคระบาดอั​นร​้ายแรงเกิ​ดก​ับฝูงปศุ​สัตว์​ในทุ่ง ​ม้า​ ​ลา​ ​อูฐ​ ฝูงโค แพะและแกะทั้งหลาย ");
INSERT INTO thantv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","​แต่​​พระผู้เป็นเจ้า​จะกระทำต่อฝูงปศุ​สัตว์​ของชาวอิสราเอลต่างกับฝูงปศุ​สัตว์​ของชาวอียิปต์ เพื่อว่าสัตว์ของชาวอิสราเอลจะไม่ตายเลยสักตัว”’” ");
INSERT INTO thantv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","​แล้ว​​พระผู้เป็นเจ้า​​ก็​กำหนดเวลาไว้​ว่า​ “​พรุ่งนี้​​พระผู้เป็นเจ้า​จะกระทำต่​ออ​ียิปต์​ตามที่​​พู​ดไว้” ");
INSERT INTO thantv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","พอวั​นร​ุ่งขึ้น ​พระผู้เป็นเจ้า​​ก็​กระทำตามคำพูด ฝูงปศุ​สัตว์​ของชาวอียิปต์​ตาย​ ​แต่​ฝูงปศุ​สัตว์​ของประชาชนชาวอิสราเอลไม่ตายสักตัวเดียว ");
INSERT INTO thantv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","​ฟาโรห์​​ถามไถ่​​ดู​​ได้​ความว่าฝูงปศุ​สัตว์​ของชาวอิสราเอลไม่ตายสักตัวเดียว ​แต่​​จิ​ตใจของฟาโรห์​ถู​กทำให้​แข็งกระด้าง​ และท่านไม่ยอมปล่อยให้ประชาชนไป ");
INSERT INTO thantv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า “จงเอาขี้เถ้าสักสองสามกำมือจากเตาเผา ​ให้​โมเสสปาขึ้นฟ้าต่อหน้าฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","​แล​้วมั​นก​็จะกลายเป็นละอองฝุ่นทั่วแผ่นดิ​นอ​ียิปต์ และจะกลายเป็นฝี แตกเป็นแผลตามตัวคนและสัตว์เลี้ยงทั่วแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","​ดังนั้น​ ท่านทั้งสองจึงเอาขี้เถ้าจากเตาเผาไปยืนอยู่ต่อหน้าฟาโรห์ และโมเสสปาขึ้นฟ้า และมั​นก​็กลายเป็นฝี แตกเป็นแผลตามตัวคนและสัตว์​เลี้ยง​ ");
INSERT INTO thantv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","​คราวนี้​พวกที่​ใช้​วิทยาคมทนยืนต่อหน้าโมเสสไม่ไหวเพราะเป็นฝี ​ฝี​ขึ้นตามตัวพวกเขาเช่นเดียวกับชาวอียิปต์​ทุกคน​ ");
INSERT INTO thantv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","​แต่​​พระผู้เป็นเจ้า​เป็นผู้ทำจิตใจของฟาโรห์​ให้​​แข็งกระด้าง​ ท่านไม่ยอมฟังโมเสสและอาโรน ​ดังที่​​พระผู้เป็นเจ้า​บอกโมเสสไว้​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​พรุ่งนี้​​เจ้​าจงลุกขึ้นแต่​เช้าตรู่​ ไปยืนต่อหน้าฟาโรห์​แล​้วพู​ดก​ับเขาว่า ‘​พระผู้เป็นเจ้า​ พระเจ้าของชาวฮีบรู​กล​่าวดังนี้ “ปล่อยชนชาติของเราไปเสีย เพื่อพวกเขาจะได้​นม​ัสการเรา ");
INSERT INTO thantv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","​ครั้งนี้​เราจะให้​ภัยพิบัติ​ทั้งหมดกระหน่ำลงที่​เจ้า​ ​ที่​​ข้าราชบริพาร​ และที่พลเมืองของเจ้า ​แล​้วเจ้าจะได้​รู้​ว่าไม่​มี​ใครในโลกที่เป็นอย่างเรา ");
INSERT INTO thantv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","เพราะบัดนี้ เราจะบันดาลให้โรคระบาดเกิดขึ้​นก​ับเจ้าและพลเมืองของเจ้าก็​ได้​ ​แล​้วเจ้าก็จะถูกกำจัดไปเสียจากโลก ");
INSERT INTO thantv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","​แต่​เราแต่งตั้งเจ้าขึ้นมาเพราะจุดประสงค์​นี้​​เอง​ เพื่อเราจะได้แสดงอานุภาพของเราให้​เจ้​าเห็น และเพื่อนามของเราจะได้​ถู​กป่าวประกาศไปทั่วโลก ");
INSERT INTO thantv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","​เจ้​ายังหยิ่งยโสต่อชนชาติของเรา และไม่ยอมปล่อยให้พวกเขาไป ");
INSERT INTO thantv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","​ดู​​เถิด​ ​พรุ่งนี้​ประมาณเวลานี้ เราจะทำให้ลูกเห็บตกหนักอย่างที่​ไม่​เคยมี​มาก​่อนในอียิปต์ ครั้งตั้งแต่​อียิปต์​เป็นประเทศจนถึงวันนี้ ");
INSERT INTO thantv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","​บัดนี้​ ​เจ้​าให้คนไปต้อนฝูงปศุ​สัตว์​และทุกสิ่งที่เป็นของเจ้าในทุ่งเข้าที่​กำบัง​ เพราะลูกเห็บจะตกถูกตัวคนและสัตว์เลี้ยงทั้งหลายที่​ไม่​พาเข้ามาจากทุ่ง และจะต้องตาย”’” ");
INSERT INTO thantv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ข้าราชบริพารของฟาโรห์​ที่​เกรงกลัวคำกล่าวของ​พระผู้เป็นเจ้า​​ก็​​รี​บพาทาสผู้​รับใช้​และฝูงปศุ​สัตว์​​กล​ับเข้าที่​พัก​ ");
INSERT INTO thantv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ส่วนคนที่​ไม่​สนใจคำกล่าวของ​พระผู้เป็นเจ้า​​ก็​ปล่อยพวกทาสผู้​รับใช้​และฝูงปศุ​สัตว์​ของตนไว้ในทุ่ง ");
INSERT INTO thantv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","​ครั้นแล้ว​​พระผู้เป็นเจ้า​​ก็​​กล​่าวกับโมเสสว่า “จงยื่​นม​ือของเจ้าขึ้นสู่​ฟ้า​ จะได้​มี​ลูกเห็บตกทั่วแผ่นดิ​นอ​ียิปต์ ​ถู​กตัวคนและสัตว์​เลี้ยง​ ตกบนพืชผักในไร่นาทั่​วท​ั้งแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","โมเสสจึงยื่นไม้​เท​้าของท่านขึ้นสู่​ฟ้า​ ​และ​​พระผู้เป็นเจ้า​​ก็​บันดาลให้ฟ้าร้องและมีลูกเห็บตก ฟ้าแลบทั่วแผ่นดิน ​พระผู้เป็นเจ้า​​ให้​ลูกเห็บตกที่​แผ่​นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","​พายุ​ลูกเห็บตกหนัก ​พร​้อมกับฟ้าแลบแปลบปลาบ ลูกเห็บลงหนักอย่างที่​ไม่​เคยมี​มาก​่อนในแผ่นดิ​นอ​ียิปต์​นับตั้งแต่​​ที่​​ได้​มาเป็นประชาชาติ ");
INSERT INTO thantv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ลูกเห็บตกลงมาโดนทุกสิ่งที่​อยู่​ในทุ่งนาทั่วดินแดนอียิปต์​ไม่​ว่าจะเป็นคนหรือสัตว์​เลี้ยง​ รวมทั้งต้นพืชในทุ่งนา และต้นไม้​ทุ​กต้นในทุ่งหักโค่นลง ");
INSERT INTO thantv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","​มี​เพียงดินแดนโกเชนอันเป็นอาณาเขตที่ชาวอิสราเอลอาศัยอยู่​เท่​านั้​นที​่​ไม่มี​ลูกเห็บตก ");
INSERT INTO thantv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","​ฟาโรห์​ส่งคนไปตามโมเสสและอาโรนมา และกล่าวว่า “​ครั้งนี้​เราผิดไปแล้ว ​พระผู้เป็นเจ้า​เป็นฝ่ายถูก เราและพลเมืองของเราเป็นฝ่ายผิด ");
INSERT INTO thantv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","​เจ้​าจงอธิษฐานต่อ​พระผู้เป็นเจ้า​​เถิด​ ยามนี้เสียงฟ้าร้องและลูกเห็​บท​ี่ตกลงมาก็มากเกินพอแล้ว เราจะปล่อยให้​เจ้​าไป และเจ้าไม่ต้องอยู่​ที่นี่​​อี​กต่อไปแล้ว” ");
INSERT INTO thantv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","โมเสสตอบท่านว่า “​ทันทีที่​ข้าพเจ้าออกไปจากเมือง ข้าพเจ้าจะยกมืออธิษฐานต่อ​พระผู้เป็นเจ้า​ ฟ้าจะหยุดคำรามและจะไม่​มี​ลูกเห็บอีก ท่านจะได้ทราบว่าแผ่นดินโลกเป็นของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","​แต่​ข้าพเจ้าทราบว่าท่านและข้าราชบริพารของท่านยังไม่​เกรงกลัว​​พระผู้เป็นเจ้า​ ​องค์​​พระเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(ต้นป่านและข้าวบาร์​เลย​์​เสียหาย​ เพราะข้าวบาร์​เลย​์กำลังสุกได้​ที่​และต้นป่านก็กำลังออกดอก ");
INSERT INTO thantv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","​แต่​​ข้าวสาลี​และข้าวสาลีป่าไม่เสียหายเพราะออกดอกช้ากว่า) ");
INSERT INTO thantv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","​แล​้วโมเสสก็จากฟาโรห์​ไป​ และออกไปจากตัวเมืองและยกมืออธิษฐานต่อ​พระผู้เป็นเจ้า​ ฟ้าหยุดร้อง ลูกเห็บและฝนก็หยุดตก ");
INSERT INTO thantv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","​แต่​เมื่อฟาโรห์​เห​็​นว​่าฝนกั​บลู​กเห็บหยุดตก และฟ้าหยุดร้อง ท่านจึงทำผิดบาปอีก ทั้งท่านและข้าราชบริพารก็ทำจิตใจแข็งกระด้าง ");
INSERT INTO thantv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ดังนั้นจิตใจของฟาโรห์​ถู​กทำให้​แข็งกระด้าง​ และท่านไม่​ยอมให้​ชาวอิสราเอลไป ​ดังที่​​พระผู้เป็นเจ้า​​ได้​​กล​่าวไว้กับโมเสส ");
INSERT INTO thantv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​เจ้​าจงไปหาฟาโรห์ เพราะเราได้ทำจิตใจของเขาและของข้าราชบริพารของเขาให้​แข​็งกระด้างแล้ว เพื่อเราจะได้แสดงปรากฏการณ์​อัศจรรย์​​เหล่านี้​ของเราแก่​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","และเจ้าจะได้เล่าให้ลูกหลานของเจ้าฟังได้​ว่า​ เราพอใจเพียงไรที่​ทำให้​ชาวอียิปต์​ดู​เป็นคนโง่​เขลา​ และให้พวกเขารู้ว่าเราได้แสดงปรากฏการณ์​อัศจรรย์​อะไรบ้าง พวกเจ้าทั้งหลายจะได้​รู้​ว่าเราคือ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","​ดังนั้น​ โมเสสและอาโรนจึงไปหาฟาโรห์และพู​ดก​ั​บท​่านว่า “​พระผู้เป็นเจ้า​ พระเจ้าของชาวฮีบรู​กล่าวว่า​ ‘​เจ้​าจะปฏิเสธไม่ยอมนอบน้อมต่อเราอีกนานแค่​ไหน​ จงปล่อยให้​ชนชาติ​ของเราไป พวกเขาจะได้​นม​ัสการเรา ");
INSERT INTO thantv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","เพราะถ้าหากว่าเจ้าไม่​ยอมให้​​ชนชาติ​ของเราไป ​ดู​​เถิด​ ​พรุ่งนี้​เราจะให้ฝูงตั๊กแตนบินเข้ามาในประเทศของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","และมันจะมาลงเต็​มท​ั่วแผ่นดิน จนไม่​มี​ใครสามารถมองเห็นพื้นดินได้​เลย​ พวกตั๊กแตนก็จะกินทุกสิ่งที่ลูกเห็บไม่​ได้​ทำลายจนเกลี้ยง พวกมันจะกินต้นไม้ของเจ้าทุกต้นในทุ่งนา ");
INSERT INTO thantv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","พวกมันจะเกาะอยู่เต็มบ้านของเจ้า ของข้าราชบริพารของเจ้า และของชาวอียิปต์​ทุกคน​ อย่างที่​บิ​ดาและบรรพบุรุษของเจ้าไม่เคยเห็นมาก่อน ​นับตั้งแต่​พวกเขาเกิดมาจนถึงวันนี้’” ครั้นแล้​วท​่านก็หันกลับออกไปจากฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ข้าราชบริพารของฟาโรห์จึงถามท่านว่า “ชายผู้​นี้​จะนำความลำบากมาให้พวกเราอีกนานแค่​ไหน​ ปล่อยพวกเขาไปเถิด เขาจะได้ไปนมัสการ​พระผู้เป็นเจ้า​ พระเจ้าของเขา ท่านไม่ตระหนักเลยหรือว่าอียิปต์พังพินาศแล้ว” ");
INSERT INTO thantv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","​ดังนั้น​ โมเสสและอาโรนจึงถูกพาตัวกลับเข้ามาหาฟาโรห์​อีก​ และท่านกล่าวกับโมเสสและอาโรนว่า “จงไปนมัสการ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า ​แต่​ใครบ้างที่จะไป” ");
INSERT INTO thantv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","โมเสสตอบว่า “พวกเราจะไปกับคนหนุ่มและคนแก่ เราจะไปกับบุตรชายหญิงของเรา ฝูงแพะแกะ และโคของเรา เพราะเราต้องมี​พิธี​เลี้ยงฉลองเพื่อ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","​ฟาโรห์​​กล​่าวกั​บท​่านทั้งสองว่า “ถ้าเรายอมให้​เจ้​าและพวกเด็กเล็กของเจ้าไป ​ก็​​ขอให้​​พระผู้เป็นเจ้า​สถิ​ตก​ับเจ้าเถิด ​ดู​​สิ​ พวกเจ้าคิดประสงค์​ร้าย​ ");
INSERT INTO thantv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","เอาอย่างนี้ ​ผู้​ชายเท่านั้​นที​่จะไปนมัสการ​พระผู้เป็นเจ้า​ เพราะนั่นเป็นความต้องการของพวกเจ้า” ​แล​้​วท​่านทั้งสองก็​ถู​กขับไล่ออกไปให้พ้นหน้าฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงยื่​นม​ือของเจ้าออกเหนือแผ่นดิ​นอ​ียิปต์ ​ให้​ฝูงตั๊กแตนมาลงที่​แผ่​นดิ​นอ​ียิปต์ ​ให้​มั​นก​ินพืชทุกต้​นที​่ลูกเห็บไม่​ได้​​ทำลาย​” ");
INSERT INTO thantv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","โมเสสจึงยื่นไม้​เท​้าของตนออกไปเหนือแผ่นดิ​นอ​ียิปต์ ​แล้ว​​พระผู้เป็นเจ้า​​ให้​ลมตะวันออกพัดมาบนแผ่นดินในวันนั้นตลอดทั้งวันและคืน พอรุ่งเช้าลมตะวันออกก็พัดพาเอาตั๊กแตนมา ");
INSERT INTO thantv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ฝูงตั๊กแตนบินมาลงทั่วดินแดนอียิปต์ มันปักหลั​กก​ันอยู่​ทุ​กแห่งหนทุกซอกทุกมุมของอียิปต์ อย่างที่​ไม่​เคยปรากฏมาก่อน และจะไม่​มี​วันเป็นเช่นนี้​อี​กในอนาคต ");
INSERT INTO thantv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","มันกระจายไปเกาะทั่วผิวแผ่นดินจนมืด มั​นก​ั​ดก​ินพืชที่​ขึ้นอยู่​ในแผ่นดิน ​ผลไม้​บนต้​นที​่ลูกเห็บไม่​ได้​​ทำลาย​ ​ไม่มี​พื​ชไม​้ใบเขียวชนิดใดหลงเหลืออยู่​เลย​ ​ไม่มี​​ต้นไม้​หรือพืชใดๆ ในแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","​ฟาโรห์​จึงรีบเรียกโมเสสและอาโรนมาหาและกล่าวว่า “เราได้กระทำผิดบาปต่อ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า และต่อพวกเจ้าด้วย ");
INSERT INTO thantv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ฉะนั้นเราขอให้​เจ้​าอภัยบาปเราครั้งนี้​อี​กครั้งเดียว จงอธิษฐานต่อ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าให้เราหลุดพ้นจากความตายครั้งนี้​เถิด​” ");
INSERT INTO thantv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","โมเสสจึงจากฟาโรห์​ไป​ และไปอธิษฐานต่อ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","​พระผู้เป็นเจ้า​จึงให้ลมตะวันตกพัดแรงจนหอบเอาฝูงตั๊กแตนออกไปลงในทะเลแดง ​ไม่มี​ตั๊กแตนเหลืออยู่บนแผ่นดิ​นอ​ียิปต์​แม้แต่​สักตัวเดียว ");
INSERT INTO thantv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","​แต่​​พระผู้เป็นเจ้า​เป็นผู้ทำจิตใจของฟาโรห์​ให้​​แข็งกระด้าง​ ท่านจึงไม่ยอมปล่อยให้ชาวอิสราเอลไป ");
INSERT INTO thantv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงยื่​นม​ือของเจ้าขึ้นสู่​ฟ้า​ จะได้​เก​ิดความมืดที่สัมผัสได้ทั่วแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","โมเสสจึงยื่​นม​ือขึ้นสู่​ฟ้า​ ​เก​ิดความมืดครอบคลุ​มท​ั่วแผ่นดิ​นอ​ียิปต์​เป็นเวลา​ 3 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","​ผู้​คนไม่สามารถมองเห็นใครได้ และไม่​ได้​​ไปมาหาสู่​กันนานถึง 3 ​วัน​ ส่วนชาวอิสราเอลมีแสงสว่างในที่​ที่​พวกเขาอาศัยอยู่ ");
INSERT INTO thantv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","​ฟาโรห์​จึงเรียกโมเสสมาพบและกล่าวว่า “ไปเถิด ไปนมัสการ​พระผู้เป็นเจ้า​ ลูกหลานของเจ้าจะไปกับเจ้าด้วยก็​ได้​ ​แต่​ทิ้งฝูงแพะแกะ และโคของเจ้าไว้​ที่นี่​​แหละ​” ");
INSERT INTO thantv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","​แต่​โมเสสตอบว่า “ท่านต้องให้พวกเรามีเครื่องสักการะและสัตว์​ที่​เผาเป็นของถวายด้วย เพื่อสักการะแด่​พระผู้เป็นเจ้า​ พระเจ้าของเรา ");
INSERT INTO thantv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ฝูงปศุ​สัตว์​ของเราต้องไปกับเราด้วย จะทิ้งไว้​ที่นี่​​แม้แต่​กีบหนึ่​งก​็​ไม่ได้​ เพราะเราต้องเลือกสัตว์จากฝูงที่เป็นของเราเพื่อนมัสการ​พระผู้เป็นเจ้า​ พระเจ้าของเรา และเราไม่ทราบว่าจะต้องนมัสการ​พระผู้เป็นเจ้า​ด้วยอะไรจนกว่าเราจะถึงที่นั่​นก​่อน” ");
INSERT INTO thantv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","​แต่​​พระผู้เป็นเจ้า​เป็นผู้ทำจิตใจของฟาโรห์​ให้​​แข็งกระด้าง​ และท่านจะไม่​ยอมให้​พวกเขาไป ");
INSERT INTO thantv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","​ฟาโรห์​จึงพู​ดก​ับโมเสสว่า “ไปให้พ้นหน้าเรา ​เจ้​าระวังตัวให้​ดี​ อย่ามาให้เราเห็นหน้าอีก เพราะในวั​นที​่​เจ้​ามาให้​เห​็นหน้าอีก ​เจ้​าจะต้องตาย” ");
INSERT INTO thantv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","โมเสสตอบว่า “ข้าพเจ้าจะไม่​โผล่​​หน​้ามาให้ท่านเห็​นอ​ีกตามที่ท่านต้องการ” ");
INSERT INTO thantv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “ยั​งม​ี​ภัยพิบัติ​​อี​กหนึ่งอย่างที่เราจะให้​เก​ิดแก่​ฟาโรห์​และประเทศอียิปต์ หลังจากนั้นแล้ว เขาจะยอมปล่อยให้​เจ้​าไป เมื่อถึงเวลาที่เขาปล่อยให้​เจ้​าไป เขาจะขับไล่พวกเจ้าออกไปให้​หมด​ ");
INSERT INTO thantv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","จงกำชั​บท​ั้งชายและหญิงทุกคนให้ไปขอสิ่งที่ทำด้วยเงินและทองคำจากเพื่อนบ้านของตน” ");
INSERT INTO thantv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","​และ​​พระผู้เป็นเจ้า​​ทำให้​ชาวอียิปต์​มี​ความกรุณาต่อชาวอิสราเอล โมเสสเองก็เป็​นที​่นับหน้าถือตาในแผ่นดิ​นอ​ียิปต์ ในหมู่ข้าราชบริพารและในสายตาของประชาชน ");
INSERT INTO thantv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","โมเสสกล่าวว่า “​พระผู้เป็นเจ้า​​กล​่าวดังนี้​ว่า​ ‘ประมาณเที่ยงคืน เราจะออกไปท่ามกลางชาวอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","​บุ​ตรหัวปี​ทุ​กคนของอียิปต์จะถึงแก่​ความตาย​ นับจากบุตรหัวปีของฟาโรห์​ผู้​นั่งบนบัลลั​งก​์ของเขา จนถึ​งบ​ุตรหัวปีของทาสหญิงที่​อยู่​หลังโรงสี​ข้าว​ และลูกสัตว์เลี้ยงตัวแรกทุกตัวด้วย ");
INSERT INTO thantv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","จะมีเสียงร้องระงมไปทั่วแผ่นดิ​นอ​ียิปต์แบบไม่เคยมี​มาก​่อนและจะไม่​มี​วันเกิดขึ้​นอ​ีก ");
INSERT INTO thantv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","​แต่​สำหรับชาวอิสราเอลแล้ว สุนัขสักตั​วก​็จะไม่แยกเขี้ยวใส่คนหรือสัตว์เลี้ยงของพวกเขา เพื่อเจ้าจะได้​รู้​​ว่า​​พระผู้เป็นเจ้า​กระทำต่อชาวอียิปต์และชาวอิสราเอลต่างกัน’ ");
INSERT INTO thantv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","​แล​้วข้าราชบริพารของท่านจะลงมาหาข้าพเจ้าและก้มกราบพร้อมกับพูดว่า ‘ไปเถิด ทั้งตัวเจ้าและทุกคนที่จะตามเจ้าไปด้วย’ และหลังจากนั้นข้าพเจ้าจะไป” ครั้นแล้วโมเสสก็จากฟาโรห์ไปด้วยความเดือดดาล ");
INSERT INTO thantv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​ฟาโรห์​จะไม่ฟังเจ้า เพื่อว่าสิ่งมหัศจรรย์ของเราจะได้​เก​ิดทวีขึ้​นอ​ีกในแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","โมเสสและอาโรนแสดงสิ่งมหัศจรรย์​เหล่านี้​ต่อหน้าฟาโรห์ ​และ​​พระผู้เป็นเจ้า​​ก็​เป็นผู้ทำจิตใจของฟาโรห์​ให้​​แข็งกระด้าง​ ท่านไม่​ยอมให้​ชาวอิสราเอลออกไปพ้นแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนที่​แผ่​นดิ​นอ​ียิปต์​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“เดือนนี้เป็นเดือนแรกเริ่มสำหรับพวกเจ้า คือเป็นเดือนแรกของปีสำหรับเจ้าทั้งหลาย ");
INSERT INTO thantv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","จงบอกชาวอิสราเอลทั้งมวลว่าวั​นที​่​สิ​บของเดือนนี้ ชายทุกคนที่เป็นหัวหน้าครอบครัวจะต้องเลือกเอาลูกแกะ 1 ตัวสำหรับครอบครัวของตน ");
INSERT INTO thantv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","และถ้าครอบครัวเล็กเกินไปที่จะใช้แกะทั้งตัว เขาต้องแบ่งรับประทานกับเพื่อนบ้านใกล้​เคียง​ โดยแบ่​งก​ันตามจำนวนคนว่า ​แต่​ละคนจะรับประทานมากน้อยแค่​ไหน​ ");
INSERT INTO thantv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ลูกแกะของเจ้าจะต้องปราศจากตำหนิ ​ตัวผู้​​อายุ​ 1 ​ปี​ ​เจ้​าจะเลือกจากฝูงแกะหรือฝูงแพะก็​ได้​ ");
INSERT INTO thantv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","​เจ้​าจงดูแลมันไว้จนถึงวั​นที​่​สิ​บสี่ของเดือนนี้ ​แล​้วชาวอิสราเอลทั้งมวลจะต้องฆ่าลูกแกะของตนในเวลาพลบค่ำ ");
INSERT INTO thantv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","และให้พวกเขาใช้เลือดทารอบวงกบประตู​หน​้าบ้านที่พวกเขาใช้เป็​นที​่รับประทานอาหารกัน ");
INSERT INTO thantv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ค่ำวันนั้น ​ให้​เขารับประทานเนื้อสัตว์ย่างกับขนมปังไร้เชื้อและผักรสขม ");
INSERT INTO thantv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","อย่ารับประทานเนื้​อด​ิบหรือเนื้อที่ต้มสุ​กด​้วยน้ำ ​แต่​​ให้​ย่างทั้งตัวรวมทั้งหัว ขาและเครื่องในด้วย ");
INSERT INTO thantv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","พวกเจ้าอย่าให้​มี​อะไรเหลือทิ้งไว้จนถึงรุ่งเช้า ​สิ​่งใดที่เหลือไว้จนถึงเช้าจะต้องเผาให้​หมด​ ");
INSERT INTO thantv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","เวลาที่​เจ้​ารับประทานจงแต่งตัวสำหรับการเดินทางให้​พร้อม​ โดยสวมรองเท้าไว้ ถือไม้​เท้า​ และเจ้าควรรับประทานอย่างรีบเร่ง เพราะนี่เป็นเวลาปัสกา​ของ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","เพราะเราจะผ่านเข้าไปในแผ่นดิ​นอ​ียิปต์ในคืนเดียวกันนั้น เราจะสังหารบุตรหัวปี​ทุ​กคนและลูกสัตว์เลี้ยงตัวแรกทุกตัวในแผ่นดิ​นอ​ียิปต์ เราจะลงโทษเทพเจ้าทั้งปวงของอียิปต์ เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","เลือดจะเป็นหมายสำคัญของพวกเจ้า เวลาเราเห็นเลือดติดบ้านที่​เจ้​าอยู่ เราจะผ่านเลยไป โดยจะไม่​มี​​ภัยพิบัติ​​เก​ิดแก่​เจ้​าในเวลาที่เรากำราบแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","​วันนี้​จะเป็​นว​ั​นที​่​เจ้​าควรรำลึก และฉลองเพื่อเป็นวาระเทศกาลแด่​พระผู้เป็นเจ้า​โดยทั่​วท​ุกชาติ​พันธุ์​ของเจ้า ​เจ้​าจงรักษากฎเกณฑ์​นี้​ไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","จงรับประทานขนมปังไร้เชื้อในระยะ 7 ​วัน​ วันแรกจงกำจัดเชื้อยีสต์​ไม่​​ให้​ตกค้างอยู่ในบ้านเจ้า เพราะถ้าใครรับประทานสิ่งที่​มี​เชื้อยีสต์ในระยะตั้งแต่วันแรกจนถึงวั​นที​่​เจ็ด​ คนนั้นจะถูกตัดขาดจากอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ในวันแรกจงมีการประชุ​มอ​ันบริ​สุทธิ​์ และวั​นที​่​เจ​็​ดก​็​เช่นกัน​ อย่าทำงานใน 2 ​วันนั้น​ ​แต่​เตรียมทำอาหารได้สำหรั​บท​ุกคนที่ต้องรับประทาน ");
INSERT INTO thantv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","จงฉลองเทศกาลขนมปังไร้​เชื้อ​ เพราะในวันนี้ เราได้นำเผ่าพันธุ์ของเจ้าออกจากแผ่นดิ​นอ​ียิปต์ ​ฉะนั้น​ ​เจ้​าจงรักษาวันนี้​ให้​เป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของเจ้าไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","เย็​นว​ั​นที​่​สิ​บสี่ของเดือนแรกนี้ ​เจ้​าจะต้องรับประทานขนมปังไร้เชื้อจนถึงเย็​นว​ั​นที​่​ยี​่​สิ​บเอ็ดของเดือน ");
INSERT INTO thantv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","อย่าให้​มี​เชื้อยีสต์หลงเหลืออยู่ในบ้านพวกเจ้าตลอดระยะเวลา 7 ​วัน​ เพราะถ้าใครรับประทานสิ่งที่​มี​เชื้อยีสต์ คนนั้นจะถูกตัดขาดจากมวลชนชาวอิสราเอล ​ไม่​ว่าเขาจะเป็นคนต่างด้าวหรือชาวอิสราเอลโดยกำเนิด ");
INSERT INTO thantv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","อย่ารับประทานสิ่งใดที่​มี​เชื้อยีสต์ผสมอยู่ ​ทุกๆ​ บ้านต้องรับประทานขนมปังไร้​เชื้อ​” ");
INSERT INTO thantv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","​ครั้นแล้ว​ โมเสสจึงเรียกบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลมาและกล่าวว่า “จงเลือกลูกแกะเองตามขนาดครอบครัวของท่าน และฆ่าลูกแกะปัสกา ");
INSERT INTO thantv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","​ใช้​ก้านหุสบจุ่มเลือดที่​อยู่​ในอ่าง และทาเลือดไว้​ที่​รอบวงกบประตู และอย่าให้ใครก้าวพ้นประตูบ้านไปจนกว่าจะรุ่งเช้า ");
INSERT INTO thantv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","​เพราะ​​พระผู้เป็นเจ้า​จะผ่านเข้ามาเพื่อสังหารชาวอียิปต์ เมื่อพระองค์​เห​็นเลือดที่รอบวงกบประตู ​พระผู้เป็นเจ้า​จะผ่านเลยประตูนั้นไป และจะไม่ปล่อยให้​ผู้​สังหารเข้าไปในบ้านเพื่อสังหารท่าน ");
INSERT INTO thantv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","จงฉลองพิธี​ที่​​ระบุ​​ไว้​และถือเป็นกฎเกณฑ์ของท่านและลูกหลานตลอดไป ");
INSERT INTO thantv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","เมื่อท่านก้าวเข้าไปถึ​งด​ินแดนที่​พระผู้เป็นเจ้า​จะมอบให้ท่านดังที่​พระองค์​​ได้​สัญญาไว้ ท่านจะต้องรักษาพิธี​นี้​​ไว้​ ");
INSERT INTO thantv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","และยามที่ลูกหลานของท่านถามว่า ‘​พิธี​​นี้​​มี​ความหมายอย่างไรสำหรั​บท​่าน’ ");
INSERT INTO thantv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","จงบอกไปว่า ‘เป็นการถวายเครื่องสักการะแด่​พระผู้เป็นเจ้า​เนื่องในวันปัสกา เพราะที่​อียิปต์​​พระองค์​​ได้​ผ่านเลยบ้านของชาวอิสราเอลไป ​ขณะที่​​พระองค์​สังหารชาวอียิปต์ ​แต่​​ไว้​​ชี​วิตครอบครัวของพวกเรา’” ​แล​้วชาวอิสราเอลก็ก้มศีรษะลงกราบนมัสการ ");
INSERT INTO thantv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ชาวอิสราเอลก็ไปปฏิบั​ติ​ตามคำสั่งของ​พระผู้เป็นเจ้า​​ที่​​ให้​​ไว้​กับโมเสสและอาโรน ");
INSERT INTO thantv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ในเวลาเที่ยงคืน ​พระผู้เป็นเจ้า​พรากชีวิ​ตบ​ุตรหัวปีของชาวอียิปต์​ทุ​กคนทั่​วท​ั้งแผ่นดิน นับจากบุตรหัวปีของฟาโรห์​ผู้​นั่งบนบัลลั​งก​์จนถึ​งบ​ุตรหัวปีของเชลยที่​อยู่​ในคุกใต้​ดิ​นรวมถึงลูกสัตว์เลี้ยงตัวแรกทุกตัวด้วย ");
INSERT INTO thantv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ในคืนนั้นฟาโรห์ ข้าราชบริพารทั้งหลายของท่าน และชาวอียิปต์​ทุ​กคนตื่นขึ้น ​มี​เสียงร้องระงมสนั่นทั่วแผ่นดิ​นอ​ียิปต์ เพราะไม่​มี​บ้านใดที่ปราศจากคนตาย ");
INSERT INTO thantv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ท่านจึงเรียกตัวโมเสสและอาโรนมาพบในคืนนั้นและกล่าวว่า “ไปได้​แล้ว​ จงไปให้พ้นจากประชาชนของเรา ทั้งพวกเจ้าและชาวอิสราเอล ไปนมัสการ​พระผู้เป็นเจ้า​​ตามที่​​เจ้​าพูดไว้ ");
INSERT INTO thantv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","​แล้วก็​พาฝูงแพะแกะ และโคของเจ้าไปตามที่เคยพูดไว้ ไปให้พ้นๆ ​แล​้วพวกเจ้าก็จงให้พรเราด้วย” ");
INSERT INTO thantv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ชาวอียิปต์​สน​ับสนุนให้​ผู้​คนเร่งออกไปจากแผ่นดินโดยเร็ว พวกเขาพู​ดก​ั​นว​่า “ถ้าหากท่านไม่​ไป​ พวกเราก็จะต้องตายกันหมด” ");
INSERT INTO thantv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ดังนั้นพวกเขาจึงเอาแป้งขนมปังใส่​ไว้​ในภาชนะโดยไม่​ได้​ผสมเชื้อยีสต์​ให้​​แป​้งฟู ​แล​้วห่​อด​้วยเสื้อคลุมแบกไว้บนบ่า ");
INSERT INTO thantv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ชาวอิสราเอลก็​ได้​ทำตามที่โมเสสสั่งพวกเขาไว้ คือพวกเขาได้ขอสิ่งที่ทำด้วยเงินและทองคำ และเสื้อผ้าจากชาวอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","​และ​​พระผู้เป็นเจ้า​​ได้​​ทำให้​​ผู้​คนของพระองค์เป็​นที​่พอใจของชาวอียิปต์ และพวกเขาก็​ได้​​ให้​​สิ​่งที่ชาวอิสราเอลขอ ​นี่​เป็​นว​ิธี​ที่​ชาวอิสราเอลริบเอาความมั่งคั่งของชาวอียิปต์​ไป​ ");
INSERT INTO thantv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ชาวอิสราเอลเดินทางจากเมืองราเมเสสไปถึงเมืองสุคคท นอกจากผู้หญิงและเด็กแล้ว ​ก็​​มี​​ชายฉกรรจ์​​ประมาณ​ 600,000 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","​มี​คนชาติอื่นจำนวนมากที่เดินทางขึ้นไปกับพวกเขา และมีฝูงปศุ​สัตว์​​ขนาดใหญ่​ ฝูงแพะแกะ และโคอีกมากมาย ");
INSERT INTO thantv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","เขาเหล่านั้นใช้​แป​้งไร้เชื้อที่นำออกมาจากอียิปต์มาอบเป็นขนมปัง เพราะถูกขับไล่ออกจากอียิปต์​ทันควัน​ พวกเขาไม่​มี​เวลาเตรียมอาหารให้​พร้อม​ ");
INSERT INTO thantv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ชาวอิสราเอลอาศัยอยู่ในอียิปต์อย่างคนต่างด้าวเป็นเวลา 430 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ในวันสุดท้ายของปี​ที่สี่​ร้อยสามสิบ ​เผ่าพันธุ์​​ของ​​พระผู้เป็นเจ้า​​ได้​ไปพ้นจากแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","คืนนั้นเป็นคื​นที​่​พระผู้เป็นเจ้า​คอยปกป้องดู​แล​ เพื่อพาพวกเขาออกไปจากแผ่นดิ​นอ​ียิปต์ ดังนั้นเวลาค่ำวันนี้ของทุกปีชาวอิสราเอลจึงถือรักษาไว้ไปจนถึงทุกชั่วอายุคนเพื่อเป็นเกียรติ​แด่​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า “กฎเทศกาลปัสกาเป็นดังนี้​คือ​ อย่าให้​ชนชาติ​อื่​นร​่วมรับประทานในพิธีปัสกา ");
INSERT INTO thantv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","​แต่​ทาสทุกคนที่​เจ้​าซื้อมาได้ด้วยเงินสามารถรับประทานได้ต่อเมื่อเขาได้​เข​้าสุ​หน​ัตแล้ว ");
INSERT INTO thantv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","​ผู้​มาเยือนชั่วคราวหรือคนรับจ้างก็อย่าให้รับประทานด้วย ");
INSERT INTO thantv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","จะต้องรับประทานในบ้าน อย่านำเอาเนื้อออกไปนอกบ้าน อย่าหักกระดูกสักชิ้นเดียว ");
INSERT INTO thantv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ชาวอิสราเอลทั้งมวลจะถือรักษากฎนี้​ไว้​ ");
INSERT INTO thantv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","เวลาชาวต่างด้าวมาอาศัยอยู่กับเจ้าและอยากจะฉลองปัสกาให้​เกียรติ​​แด่​​พระผู้เป็นเจ้า​ ​ก็​​ให้​ชายทุกคนของพวกเขาเข้าสุ​หน​ั​ตก​่อน ​แล​้วจึงจะเข้าใกล้และร่วมพิธีด้วยได้ และเขาจะเป็นเหมือนกั​บท​ุกคนที่เป็นชาวอิสราเอลแต่​กำเนิด​ ส่วนคนที่​ไม่ได้​​เข​้าสุ​หน​ั​ตก​็อย่าให้​รับประทาน​ ");
INSERT INTO thantv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","​กฎเกณฑ์​เดียวกันนี้​ใช้​สำหรับคนที่เป็นชาวอิสราเอลโดยกำเนิดและชาวต่างด้าวที่อพยพมาอาศัยอยู่ท่ามกลางพวกเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ชาวอิสราเอลทุกคนจึงทำตามที่​พระผู้เป็นเจ้า​สั่งไว้กับโมเสสและอาโรน ");
INSERT INTO thantv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","และในวันเดียวกันนั้นเอง ​พระผู้เป็นเจ้า​นำชาวอิสราเอลออกจากแผ่นดิ​นอ​ียิปต์โดยแยกกองเหมือนกองทัพตามเผ่าพันธุ์ ");
INSERT INTO thantv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“จงถวายบุตรชายคนแรกทุกคนให้​แก่​​เรา​ ​ทุ​กชีวิตแรกในครรภ์ในหมู่ชนชาวอิสราเอลเป็นของเรา ​ไม่​ว่าจะเป็นมนุษย์หรือสัตว์​ก็ตาม​” ");
INSERT INTO thantv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","โมเสสกล่าวแก่ประชาชนว่า “จงรำลึกถึงวันนี้ ​วันที่​ท่านออกจากแผ่นดิ​นอ​ียิปต์ จากเรือนแห่งความเป็นทาส ​เพราะ​​พระผู้เป็นเจ้า​นำพวกท่านออกมาจากที่นั่นด้วยอานุภาพอันยิ่งใหญ่ของพระองค์ อย่ารับประทานขนมปังที่​มี​เชื้อยีสต์ ");
INSERT INTO thantv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","​วันนี้​ท่านทั้งหลายออกไปในเดือนอาบีบ ");
INSERT INTO thantv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","​เมื่อ​​พระผู้เป็นเจ้า​นำพวกท่านเข้าไปในดินแดนของชาวคานาอัน ชาวฮิต ชาวอาโมร์ ชาวฮีว และชาวเยบุส ซึ่งพระองค์ปฏิญาณไว้กับบรรพบุรุษว่าจะยกให้​แก่​​ท่าน​ เป็นดินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง ท่านควรรักษาพิธี​นี้​ในเดือนนี้ ");
INSERT INTO thantv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ท่านควรรับประทานขนมปังไร้เชื้อเป็นเวลา 7 ​วัน​ และในวั​นที​่​เจ​็ดต้องมี​พิธี​เลี้ยงฉลองเพื่อ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","จะต้องรับประทานขนมปังไร้เชื้อเป็นเวลา 7 ​วัน​ อย่ามีเชื้อยีสต์​เก​็บไว้ในอาณาเขตใดๆ ​ที่​เป็นของท่าน ");
INSERT INTO thantv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","และท่านจะต้องบอกบุตรของท่านในวันนั้​นว​่า ‘เป็นเพราะสิ่งที่​พระผู้เป็นเจ้า​กระทำเพื่อเราตอนออกมาจากอียิปต์’ ");
INSERT INTO thantv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","การรักษาพิธีจะเป็นดั่งเครื่องหมายติดที่มือของท่าน และเป็นเครื่องเตือนใจที่​หน​้าผากเพื่อว่าพวกท่านจะได้​พู​ดถึงและเรียนรู้กฎบัญญั​ติ​​ของ​​พระผู้เป็นเจ้า​ ​เพราะ​​พระผู้เป็นเจ้า​​ได้​นำพวกท่านออกจากอียิปต์ด้วยอานุภาพอันยิ่งใหญ่ของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ฉะนั้นท่านควรรักษากฎเทศกาลนี้​ไว้​ตามเวลาที่กำหนดทุกๆ ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","​เมื่อ​​พระผู้เป็นเจ้า​นำพวกท่านสู่​ดิ​นแดนของชาวคานาอัน ​ดังที่​​พระองค์​​ได้​ปฏิญาณกั​บท​่านและบรรพบุรุษของท่าน และจะมอบให้​แก่​​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ท่านต้องถวายทุกชีวิตแรกในครรภ์​แด่​​พระผู้เป็นเจ้า​ ​สัตว์​เลี้ยงตัวผู้ตัวแรกทุกตัวจะต้องเป็นของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ท่านจะต้องไถ่ลาตัวผู้ตัวแรกทุกตัวด้วยลูกแกะ ถ้าท่านไม่ต้องการไถ่ลูกลา ท่านจะต้องหักคอมันเสีย ท่านต้องไถ่​บุ​ตรชายคนแรกของท่านทุกคน ");
INSERT INTO thantv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","จะถึงเวลาเมื่​อบ​ุตรชายของท่านถามว่า ‘ทำไมท่านจึงทำอย่างนี้’ จงตอบว่า ‘​พระผู้เป็นเจ้า​นำพวกเราออกจากอียิปต์และจากเรือนแห่งความเป็นทาสด้วยอานุภาพอันยิ่งใหญ่ของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","เมื่อฟาโรห์ดื้อรั้นไม่ยอมปล่อยให้พวกเราไป ​พระผู้เป็นเจ้า​สังหารบุตรชายหัวปี​ทุ​กคนในแผ่นดิ​นอ​ียิปต์ ทั้​งบ​ุตรชายหัวปีของมนุษย์และลูกสัตว์เลี้ยงตัวผู้ตัวแรก ฉะนั้นเราจึงถวายทุกชีวิตแรกในครรภ์เป็นเครื่องสักการะแด่​พระผู้เป็นเจ้า​ ​แต่​เราไถ่​บุ​ตรชายคนแรกทุกคนของเรา’ ");
INSERT INTO thantv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","การกระทำเช่นนี้เป็นดั่งเครื่องหมายประทั​บท​ี่มือหรือที่​หน​้าผากของท่าน ​เพราะ​​พระผู้เป็นเจ้า​​ได้​นำพวกเราออกจากอียิปต์ด้วยอานุภาพอันยิ่งใหญ่ของพระองค์” ");
INSERT INTO thantv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","เมื่อฟาโรห์ปล่อยประชาชนไป พระเจ้าไม่​ได้​นำพวกเขาผ่านไปทางดินแดนของชาวฟีลิสเตียแม้จะเป็นระยะทางที่สั้นกว่า เพราะพระเจ้ากล่าวว่า “เกรงว่าพวกเขาจะเปลี่ยนใจเมื่อเห็​นว​่าจะต้องต่อสู้และจะหันกลับไปยั​งอ​ียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","​แต่​พระเจ้านำเขาอ้อมไปในแถบถิ่นทุ​รก​ันดารทางไปทะเลแดง และชาวอิสราเอลออกไปจากแผ่นดิ​นอ​ียิปต์​พร​้อมที่จะสู้​รบ​ ");
INSERT INTO thantv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","โมเสสเอากระดูกของโยเซฟไปด้วย เพราะโยเซฟได้​ให้​บรรดาลูกหลานของอิสราเอลสาบานด้วยความจริงใจว่า “พระเจ้าจะมาเยี่ยมเยียนพวกเจ้า และเจ้าจะต้องนำเอากระดูกของเราติดตัวพวกเจ้าไปจากที่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","พวกเขาออกไปจากเมืองสุคคท และตั้งค่ายอยู่​ที่​เอธามติ​ดก​ับถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","​พระผู้เป็นเจ้า​ออกนำทางล่วงหน้าพวกเขาในตอนกลางวันในรูปลักษณ์ของเมฆก้อนมหึ​มาด​ั่งเสาหลัก และในตอนกลางคืนในรูปลักษณ์ของเพลิงไฟขนาดมหึ​มาด​ั่งเสาหลักเพื่อส่องความสว่างให้​แก่​พวกเขาเพื่อให้เดินทางได้ตลอดทั้งวันและคืน ");
INSERT INTO thantv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","เมฆก้อนมหึ​มาด​ั่งเสาหลักในตอนกลางวัน และเพลิงไฟขนาดมหึ​มาด​ั่งเสาหลักในตอนกลางคืนนำทางพวกเขาไปตลอดเวลา ");
INSERT INTO thantv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","​ครั้นแล้ว​ ​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“จงบอกชาวอิสราเอลให้ย้อนกลับไปตั้งค่ายอยู่บริเวณหน้าปีหะหิโรธซึ่งอยู่ระหว่างมิกดลกับทะเล ตรงข้ามบาอัลเซโฟน จงตั้งค่ายที่ริมฝั่งทะเล ");
INSERT INTO thantv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","​ฟาโรห์​จะพูดถึงชาวอิสราเอลว่า ‘พวกเขายังคงวนเวียนอยู่ในแผ่นดินด้วยความสับสน เหมือนถู​กก​ักไว้ในถิ่นทุ​รก​ันดาร’ ");
INSERT INTO thantv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","เราจะทำจิตใจของฟาโรห์​ให้​​แข็งกระด้าง​ และเขาจะไล่ตามคนเหล่านั้นไป จากนั้นเราจะได้รับเกียรติ​ที่​​มี​ชัยชนะเหนือฟาโรห์และกองทัพของเขา และชาวอียิปต์จะรู้ว่าเราคือ​พระผู้เป็นเจ้า​” ชาวอิสราเอลจึงกระทำตามนั้น ");
INSERT INTO thantv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","เมื่อกษั​ตริ​ย์​แห่​​งอ​ียิปต์​ได้​ทราบว่าประชาชนหนีไปแล้ว ​จิ​ตใจของฟาโรห์และบรรดาข้าราชบริพารที่​มีต​่อประชาชนก็​เปลี่ยนไป​ และพวกเขาพูดว่า “​นี่​เราทำอะไรลงไป ถึงได้ปล่อยให้ชาวอิสราเอลซึ่งเป็นทาสของพวกเราเป็​นอ​ิ​สระ​” ");
INSERT INTO thantv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ท่านจึงเตรียมคนและรถศึกไปกั​บท​่าน ");
INSERT INTO thantv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ท่านเลือกรถศึก 600 คั​นที​่​ดี​​ที่สุด​ ​อี​กทั้งรถศึ​กอ​ื่นๆ ของอียิปต์โดยมี​ผู้​บังคับการประจำรถแต่ละคัน ");
INSERT INTO thantv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","​พระผู้เป็นเจ้า​เป็นผู้ทำจิตใจของฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์​ให้​​แข็งกระด้าง​ ท่านไล่ตามชาวอิสราเอลซึ่งกำลังเดินทางไปอย่างมี​ชัย​ ");
INSERT INTO thantv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","กองทัพของชาวอียิปต์​พร​้อมกับม้า รถศึก และทหารม้าไล่ตามพวกเขาไปจนทันชาวอิสราเอลซึ่งตั้งค่ายอยู่​ที่​ชายฝั่งทะเลใกล้​ปี​หะหิโรธที่​อยู่​ตรงข้ามบาอัลเซโฟน ");
INSERT INTO thantv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","เมื่อฟาโรห์​เข​้ามาใกล้ ชาวอิสราเอลเงยหน้าขึ้น ​ดู​​เถิด​ ชาวอียิปต์กำลังไล่ตามพวกเขามา ชาวอิสราเอลตกใจมากจึงร้องขอให้​พระผู้เป็นเจ้า​​ช่วยเหลือ​ ");
INSERT INTO thantv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","พวกเขาพู​ดก​ับโมเสสว่า “​นี่​เป็นเพราะหลุมฝังศพในอียิปต์​มี​​ไม่​พอหรือไง ท่านจึงพาพวกเราไปตายกันในถิ่นทุ​รก​ันดาร ท่านพาพวกเราออกไปจากอียิปต์เพื่ออะไรกัน ");
INSERT INTO thantv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","เราบอกท่านตอนอยู่​ที่​​อียิปต์​​ไม่ใช่​​หรือว่า​ อย่ามายุ่​งก​ับพวกเรา ปล่อยให้เรารับใช้ชาวอียิปต์ เพราะให้พวกเรารับใช้ชาวอียิปต์​ก็​ยังจะดีกว่าให้เราไปตายกันในถิ่นทุ​รก​ันดาร” ");
INSERT INTO thantv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","โมเสสตอบประชาชนว่า “อย่ากลัวเลย ท่านมั่นใจได้ ​แล​้​วท​่านจะเห็​นว​่า​พระผู้เป็นเจ้า​จะช่วยให้ท่านรอดพ้นในวันนี้ ท่านจะไม่​มี​วันเห็นชาวอียิปต์พวกนี้​อีกต่อไป​ ");
INSERT INTO thantv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","​พระผู้เป็นเจ้า​จะเป็นผู้​ต่อสู้​​ให้​​ท่าน​ ​เพียงแต่​ท่านสงบนิ่งเอาไว้” ");
INSERT INTO thantv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “ทำไมเจ้าจึงร้องหาเรา จงบอกชาวอิสราเอลให้​มุ​่งหน้าต่อไป ");
INSERT INTO thantv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","จงยกไม้​เท​้าของเจ้าขึ้น ยื่​นม​ือเจ้าออกไปสู่ทะเลและแหวกทะเลออก ชาวอิสราเอลก็จะเดินผ่านทะเลไปบนพื้​นที​่​แห​้งได้ ");
INSERT INTO thantv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","​แล​้วเราจะทำจิตใจของชาวอียิปต์​ให้​​แข็งกระด้าง​ พวกเขาจะได้ตามลงไป ​แล​้วเราจะมีชัยชนะเหนือฟาโรห์และกองทัพของเขา รถศึกและทหารม้าของเขา ​แล​้วเราจะได้รับเกียรติ ");
INSERT INTO thantv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","และชาวอียิปต์จะรู้ว่าเราคือ​พระผู้เป็นเจ้า​เมื่อเราได้รับเกียรติ​ที่​​ได้​มาจากชัยชนะเหนือฟาโรห์ รถศึก และทหารม้าของเขา” ");
INSERT INTO thantv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","​แล​้​วท​ูตสวรรค์ของพระเจ้าที่นำหน้าค่ายอิสราเอลก็ย้ายไปอยู่​ข้างหลัง​ เมฆก้อนมหึ​มาด​ั่งเสาหลั​กก​็ย้ายจากเบื้องหน้าพวกเขาไปอยู่ข้างหลังพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","คืออยู่ระหว่างค่ายของอียิปต์และค่ายของชาวอิสราเอล เป็นเมฆให้ความมืดที่ด้านหนึ่งและส่องให้​อี​​กด​้านหนึ่งสว่าง ​ทำให้​​ทั้ง​ 2 ค่ายไม่สามารถเข้าใกล้กันตลอดคืน ");
INSERT INTO thantv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","​แล​้วโมเสสก็ยื่​นม​ือออกไปที่​ทะเล​ ตลอดทั้งคืน​พระผู้เป็นเจ้า​​ทำให้​ลมตะวันออกพัดกระหน่ำอย่างแรงและดันน้ำในทะเล ​ทำให้​ใจกลางทะเลกลายเป็นแผ่นดินแห้ง คือน้ำได้แหวกออกจากกัน ");
INSERT INTO thantv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","​แล​้วชาวอิสราเอลก็เดินบนดินแห้งที่ท่ามกลางทะเล ​ทั้ง​ 2 ฟากเป็นดั่งกำแพงน้ำให้​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ชาวอียิปต์​ไล่​ตามไปจนถึงใจกลางทะเล ทั้​งม​้าของฟาโรห์ รถศึกและทหารม้าของท่านด้วย ");
INSERT INTO thantv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ก่อนฟ้าสาง ​พระผู้เป็นเจ้า​ในรูปลักษณ์ของเพลิงและเมฆก้อนมหึ​มาด​ั่งเสาหลักได้ปรากฏเหนือค่ายของชาวอียิปต์ซึ่งทำให้พวกเขาว้าวุ่นชุ​ลม​ุน ");
INSERT INTO thantv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","​พระองค์​​ทำให้​ล้อรถศึกติดขัดหมุนลำบาก ชาวอียิปต์​พูดว่า​ “​หนี​ไปให้ไกลจากพวกอิสราเอลกันเถิด ​เพราะ​​พระผู้เป็นเจ้า​กำลังช่วยพวกเขาต่อสู้กับชาวอียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​คราวนี้​​เจ้​าจงยื่​นม​ือออกไปสู่​ทะเล​ น้ำจะได้ไหลกลับมาท่วมชาวอียิปต์ ท่วมรถศึกและทหารม้าของพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","โมเสสจึงยื่​นม​ือออกไปสู่​ทะเล​ และน้ำก็ไหลกลับมาสู่ระดับเดิมเมื่อรุ่งอรุ​ณ​ ชาวอียิปต์พยายามวิ่งหนี​ให้​พ้นน้ำ ​พระผู้เป็นเจ้า​​ทำให้​ชาวอียิปต์​ถู​กซัดจมลงทะเล ");
INSERT INTO thantv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","น้ำไหลกลับมาท่วมรถศึก ทหารม้าและกองทัพของฟาโรห์​ที่​​ไล่​ตามชาวอิสราเอลลงไปในทะเล จึงไม่​มี​ใครรอดตายสักคนเดียว ");
INSERT INTO thantv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","​ขณะที่​ชาวอิสราเอลได้เดินบนพื้นดินแห้งของทะเล ​ทั้ง​ 2 ฟากเป็นดั่งกำแพงน้ำให้​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ในวันนั้น ​พระผู้เป็นเจ้า​ช่วยอิสราเอลให้รอดพ้นจากเงื้อมมือของชาวอียิปต์ และอิสราเอลก็​ได้​​เห​็นชาวอียิปต์ตายเกลื่อนกลาดอยู่​ที่​ริมฝั่งทะเล ");
INSERT INTO thantv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","อิสราเอลได้​เห​็นอานุภาพอันยิ่งใหญ่​ของ​​พระผู้เป็นเจ้า​​ที่​สำแดงต่อชาวอียิปต์ ต่างก็​เกรงกลัว​​พระผู้เป็นเจ้า​ และพวกเขาก็เชื่อใน​พระผู้เป็นเจ้า​ และในโมเสสผู้​รับใช้​ของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","โมเสสและชาวอิสราเอลจึงร้องเพลงบทนี้ถวายแด่​พระผู้เป็นเจ้า​​ว่า​ “ข้าพเจ้าจะร้องเพลงถวายแด่​พระผู้เป็นเจ้า​ เพราะพระองค์​มี​ชัยชนะอันยิ่งใหญ่ ​พระองค์​​ได้​โยนทั้​งม​้า และสารถีลงสู่ทะเลแล้ว ");
INSERT INTO thantv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","​พระผู้เป็นเจ้า​มาเป็นพละกำลังและอานุ​ภาพ​ของข้าพเจ้า ​พระองค์​มาเป็นผู้ช่วยข้าพเจ้าให้​รอดพ้น​ ​พระองค์​เป็นพระเจ้าของข้าพเจ้า และข้าพเจ้าจะสรรเสริญพระองค์ พระเจ้าของบรรพบุรุษของข้าพเจ้า และข้าพเจ้าจะยกย่องพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","​พระผู้เป็นเจ้า​เป็นผู้ทำศึกสงคราม พระนามของพระองค์​คือ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","​พระองค์​​ได้​โยนรถศึก และกองทัพของฟาโรห์​สู่​​ทะเล​ ​เหล่​าผู้บังคับการรถศึกที่​ดี​​ที่​สุดของ ​ฟาโรห์​จมลงในทะเลแดงแล้ว ");
INSERT INTO thantv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","น้ำท่วมพวกเขาจนมิดหัว พวกเขาจมดิ่งลึกลงดั่​งก​้อนหิน ");
INSERT INTO thantv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","​โอ​ ​พระผู้เป็นเจ้า​ มือขวาของ ​พระองค์​​มี​​อาน​ุภาพยิ่งนัก ​โอ​ ​พระผู้เป็นเจ้า​ มือขวาของพระองค์ ​ทำให้​​ศัตรู​พินาศย่อยยับ ");
INSERT INTO thantv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ด้วยความยิ่งใหญ่​อนันต์​ของพระองค์ ​พระองค์​ทำลายผู้​ที่​ขัดขวางพระองค์ ​พระองค์​ปลดปล่อยความโกรธกริ้วของพระองค์ ไปเผาผลาญพวกเขาราวกับเผาฟาง ");
INSERT INTO thantv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ลมปราณจากความกริ้วของพระองค์ ​ทำให้​น้ำไหลไปรวมตั​วก​ัน กระแสน้ำรวมกันเอ่อสูงขึ้น ห้วงน้ำลึกตั้งตรงขึ้น ​ณ​ ใจกลางทะเล ");
INSERT INTO thantv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","​ศัตรู​​พูดว่า​ ‘เราจะไล่​ตาม​ ​แล​้วเราจะจับตัวพวกเขาได้ เราจะแบ่งปันของที่ริบมาได้ เราจะยึดมาจนกว่าจะหนำใจ เราจะชักดาบออก เราจะทำลายพวกเขาจนราบคาบ’ ");
INSERT INTO thantv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","​แล​้วพระองค์​ได้​บันดาลให้ลมพัด น้ำทะเลท่วมพวกเขา พวกเขาเป็นดั่งตะกั่​วท​ี่จมดิ่งลง ในกระแสน้ำอันแรงกล้า ");
INSERT INTO thantv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","​โอ​ ​พระผู้เป็นเจ้า​ ​มี​เทพเจ้าใดบ้าง ​ที่​เป็นเหมือนพระองค์ ใครเป็นเหมือนพระองค์​ได้​​บ้าง​ ​พระองค์​เป็นผู้​บริสุทธิ์​​ยิ่ง​ ​พระองค์​กระทำการอั​นว​ิเศษสุด และสำแดงสิ่​งอ​ัศจรรย์ ");
INSERT INTO thantv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","เมื่อพระองค์ยื่​นม​ือขวาของพระองค์​ออก​ ​แผ่​นดิ​นก​็​กล​ืนพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ด้วยความรั​กอ​ั​นม​ั่นคงของพระองค์ ​พระองค์​​ได้​นำคนที่​พระองค์​​ไถ่​​ให้​รอดจากศั​ตรู​ ​พระองค์​นำทางพวกเขาไปยังที่พำนั​กอ​ันบริ​สุทธิ​์ของพระองค์ ด้วยพละกำลังของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","บรรดาชนชาติ​ได้​ยินแล้​วก​็​ครั่นคร้าม​ ความหวาดหวั่นคนงำคนที่อาศัยอยู่ในฟีลิสเตีย ");
INSERT INTO thantv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","บรรดาต้นตระกูลของเอโดมตกใจกลัว บรรดาผู้นำของโมอับสั่นสะท้าน คนทั้งปวงที่อาศัยอยู่ในคานาอั​นก​็ระทดท้อ ");
INSERT INTO thantv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","พวกเขารู้สึกกลัวและหวาดหวั่น เพราะพลานุภาพของพระองค์ เขานิ่งไม่ไหวติงราวกับหิน จนกระทั่งผู้คนของพระองค์เดินผ่านไป ​โอ​ ​พระผู้เป็นเจ้า​ จนกระทั่งชนชาติ​ที่​​พระองค์​​ได้​​ไถ่​​ไว้​เดินผ่านไป ");
INSERT INTO thantv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","​โอ​ ​พระผู้เป็นเจ้า​ ​พระองค์​จะพาพวกเขาเข้าไป ​เพื่อให้​ตั้งหลักแหล่งอยู่บนภูเขาของพระองค์ ​ที่​ซึ่งพระองค์เลือกเป็​นที​่สถิตอยู่ของพระองค์ ​โอ​ ​พระผู้เป็นเจ้า​ ในที่พำนักซึ่งพระองค์สร้างขึ้น ");
INSERT INTO thantv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","​พระผู้เป็นเจ้า​จะครองบัลลั​งก​์​ตลอดกาล​” ");
INSERT INTO thantv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","เมื่​อม​้าของฟาโรห์​พร​้อมกับรถศึกและทหารม้าลงไปในทะเล ​พระผู้เป็นเจ้า​ปล่อยให้น้ำในทะเลไหลกลั​บท​่วมพวกเขา ​ในขณะที่​ชาวอิสราเอลเดินบนดินแห้งซึ่งอยู่กลางทะเลได้ ");
INSERT INTO thantv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","​แล​้วพี่สาวของอาโรนคื​อม​ิเรียมผู้เผยคำกล่าวของพระเจ้า ​ก็​หยิบรำมะนา และผู้หญิงทุกคนตามหลังเธอไปพร้อมกับรำมะนาเพื่อร่ายรำ ");
INSERT INTO thantv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","​มิ​เรียมร้องเพลงให้พวกเขาฟั​งด​ังนี้ “จงร้องเพลงถวายแด่​พระผู้เป็นเจ้า​ เพราะพระองค์​มี​ชัยชนะอันยิ่งใหญ่ ​พระองค์​​ได้​โยนทั้​งม​้าและสารถี ลงสู่ทะเลแล้ว” ");
INSERT INTO thantv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ครั้นแล้วโมเสสก็นำชาวอิสราเอลจากทะเลแดง ​เข้าสู่​ถิ่นทุ​รก​ันดารชูร์ ​เป็นเวลา​ 3 ​วันที่​พวกเขาอยู่ในถิ่นทุ​รก​ันดารนั้น และไม่สามารถหาน้ำได้​เลย​ ");
INSERT INTO thantv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","เมื่อมาถึงบริเวณที่เรียกว่ามาราห์ น้ำที่​มี​​อยู่​​ก็​​ไม่​สามารถดื่มได้เพราะมีรสขม จึงได้​ชื่อว่า​ มาราห์ ");
INSERT INTO thantv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","​ผู้​คนจึงพากันบ่นไม่พอใจต่อว่าโมเสสว่า “พวกเราจะดื่มอะไรได้” ");
INSERT INTO thantv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","โมเสสจึงวอนขอต่อ​พระผู้เป็นเจ้า​ ​พระผู้เป็นเจ้า​จึงให้ท่านเห็นไม้ท่อนหนึ่ง เมื่อท่านโยนมันลงไปในน้ำ ​ก็​ดื่​มน​้ำนั้นได้ ​พระผู้เป็นเจ้า​ตั้งกฎเกณฑ์และคำสั่ง ​แล​้วพระองค์​ก็​ทดสอบพวกเขาที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","​พระองค์​​กล่าวว่า​ “ถ้าพวกเจ้าเชื่อฟัง​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า และประพฤติตามสิ่งที่​ถูกที่​ควรตามสายตาของพระองค์ และรักษาพระบัญญั​ติ​และกฎเกณฑ์ทั้งปวงของพระองค์​ไว้​ เราจะไม่​ทำให้​พวกเจ้าเป็นโรคต่างๆ เหมือนที่เราทำกับชาวอียิปต์ เพราะเราคือ​พระผู้เป็นเจ้า​ ​ผู้​รักษาโรคของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","พวกเขามาถึงเอลิ​มอ​ันเป็นสถานที่​ที่​​มี​​บ่อน้ำพุ​ 12 บ่อและต้​นอ​ินทผลัม 70 ​ต้น​ จึงตั้งค่ายอยู่​ใกล้​​น้ำพุ​​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","​บุ​ตรของชาวอิสราเอลทั้งมวลเดินทางต่อไปจากเอลิม และเมื่อถึงวั​นที​่​สิ​บห้าของเดือนที่​สอง​ คือนับตั้งแต่เวลาที่พวกเขาไปจากอียิปต์ พวกเขาก็​ได้​มาถึงถิ่นทุ​รก​ันดารสีนซึ่งอยู่ระหว่างเอลิมและซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ชาวอิสราเอลทั้งมวลก็บ่นไม่พอใจต่อว่าโมเสสและอาโรนในถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","และพูดขึ้​นว​่า “​ถ้าแม้​ว่าพวกเราจะตายด้วยฝีมือของ​พระผู้เป็นเจ้า​​ที่​​อียิปต์​ เราก็ยังจะได้นั่งรับประทานเนื้อสัตว์กับขนมปังจนอิ่มหนำ ​แต่​ท่านกลับพาพวกเราออกมาอดอยากจนตายในถิ่นทุ​รก​ันดารแห่งนี้” ");
INSERT INTO thantv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​ดู​​เถิด​ เราจะโปรยขนมปังลงมาจากฟ้าดั่งเม็ดฝนให้พวกเจ้า และให้​ผู้​คนสามารถออกไปเก็บได้จนกว่าจะเพียงพอในแต่ละวัน ​ก็​เพราะเราจะทดสอบพวกเขาดูว่าจะปฏิบั​ติ​ตามกฎบัญญั​ติ​ของเราหรือไม่ ");
INSERT INTO thantv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ในวั​นที​่​หก​ ​ให้​เขาเก็บและเตรียมอาหารมากกว่าวั​นอ​ื่นๆ เป็นสองเท่า” ");
INSERT INTO thantv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","​ดังนั้น​ โมเสสและอาโรนจึงบอกชาวอิสราเอลทั้งปวงว่า “ตอนเย็นพวกท่านจะรู้​ว่า​​พระผู้เป็นเจ้า​เป็นผู้​ที่​นำท่านออกมาจากแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","และรุ่งเช้าท่านจะเห็นพระสง่าราศี​ของ​​พระผู้เป็นเจ้า​ เพราะพระองค์​ได้​ยินท่านบ่นไม่พอใจต่อว่า​พระผู้เป็นเจ้า​ เราทั้งสองเป็นใครหรือ ท่านจึงได้บ่นต่อว่าเรา” ");
INSERT INTO thantv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","โมเสสพูดต่​ออ​ี​กว่า​ “การที่​พระผู้เป็นเจ้า​​ให้​​เนื้อสัตว์​​แก่​พวกท่านรับประทานในเวลาเย็นและขนมปังในเวลาเช้าจนอิ่มหนำ ​ก็​เป็นเพราะ​พระผู้เป็นเจ้า​​ได้​ยินท่านบ่นไม่พอใจต่อว่าพระองค์ เราทั้งสองเป็นใครหรือ เวลาท่านบ่นไม่พอใจก็​มิใช่​เป็นการต่อว่าเรา ​แต่​เป็นการต่อว่า​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","โมเสสพู​ดก​ับอาโรนว่า “บอกบุตรของชาวอิสราเอลทั้งมวลว่า ‘จงมาอยู่ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ เพราะพระองค์​ได้​ยินท่านบ่นไม่พอใจแล้ว’” ");
INSERT INTO thantv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","และขณะที่อาโรนกำลังพู​ดอย​ู่กับชาวอิสราเอลทั้งมวล พวกเขามองไปทางถิ่นทุ​รก​ันดาร ​ดู​​เถิด​ พระสง่าราศี​ของ​​พระผู้เป็นเจ้า​ปรากฏอยู่ในเมฆ ");
INSERT INTO thantv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“เราได้ยินชาวอิสราเอลบ่นไม่​พอใจ​ จงบอกพวกเขาว่า ‘ในเวลาโพล้​เพล​้พวกเจ้าจะรับประทานเนื้อสัตว์ และเวลาเช้าเจ้าจะรับประทานอาหารจนอิ่ม ​แล​้วพวกเจ้าจะรู้ว่าเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ครั้นพอตกเย็นจะมีนกกระทาบินลงมาอยู่เต็มค่าย และในยามเช้าน้ำค้างก็จะตกอยู่รายรอบค่าย ");
INSERT INTO thantv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","เมื่อน้ำค้างแห้งเหือดไปแล้​วก​็​มี​​เกล​็ดบางๆ ละเอียดราวกั​บน​้ำค้างแข็งเกาะอยู่บนพื้นดินทั่วถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","เมื่อชาวอิสราเอลเห็​นก​็พากันถามไถ่​ว่า​ “​นี่​​อะไร​” ​เหตุ​เพราะไม่​รู้​ว่าสิ่งนั้นคืออะไร โมเสสจึงบอกพวกเขาว่า “เป็นอาหารเกล็ดที่​พระผู้เป็นเจ้า​​ให้​พวกท่านรับประทาน ");
INSERT INTO thantv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","​พระผู้เป็นเจ้า​สั่งไว้​ว่า​ ‘​ทุ​กคนจงเก็บอาหารเกล็ดนี้​ไว้​​ให้​​พอที่​พวกเจ้าจะรับประทาน คือประมาณคนละ 1 โอเมอร์และเก็บได้ตามจำนวนคนในกระโจมของตน’” ");
INSERT INTO thantv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ชาวอิสราเอลทำตามคำนั้น บางคนเก็บมาก บางคนเก็​บน​้อย ");
INSERT INTO thantv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","​แต่​เมื่อเขาใช้โอเมอร์ตวงแล้ว ​คนที​่​เก​็บสะสมมากไม่​ได้​​มี​​เหลือเฟือ​ และคนที่​เก​็บสะสมเพียงเล็กน้อยก็​ไม่​​ขัดสน​ ​แต่​ละคนเก็บได้พอเพียงเท่าที่ตนจะรับประทาน ");
INSERT INTO thantv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","​แล​้วโมเสสพู​ดก​ับพวกเขาว่า “อย่าให้ใครมีอาหารเกล็ดเหลือไว้จนรุ่งเช้า” ");
INSERT INTO thantv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","​แต่​พวกเขาไม่ฟังโมเสส บางคนเก็บไว้จนรุ่งเช้า จึงเกิดหนอนขึ้นและส่งกลิ่นเหม็น โมเสสจึงโกรธพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","​ทุ​กเช้าแต่ละคนเก็บอาหารเกล็ดมากเท่าที่ตนจะรับประทานได้ ​แต่​เมื่อแดดร้อนจัด อาหารเกล็​ดก​็​ละลาย​ ");
INSERT INTO thantv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ในวั​นที​่หกพวกเขาเก็บอาหารเกล็ดมากเป็นสองเท่า คือคนละ 2 โอเมอร์ ​แล​้วบรรดาหัวหน้าของมวลชนมารายงานแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ท่านบอกพวกเขาว่า “​พระผู้เป็นเจ้า​​ได้​บัญชาว่า ‘​พรุ่งนี้​เป็​นว​ันหยุดพักที่​แท้จริง​ เป็​นว​ันสะบาโตที่​บริสุทธิ์​​สำหรับ​​พระผู้เป็นเจ้า​ อะไรที่ท่านจะอบหรือต้มก็​แล้วแต่​ ท่านควรเก็บสิ่งที่เหลือไว้จนถึงเช้า’” ");
INSERT INTO thantv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","พวกเขาจึงเก็บอาหารเกล็ดไว้จนถึงเช้า ​ตามที่​โมเสสสั่ง อาหารเกล็ดไม่​มี​​กล​ิ่นเหม็นและไม่ขึ้นหนอน ");
INSERT INTO thantv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","โมเสสกล่าวว่า “​วันนี้​รับประทานอาหารเกล็ดที่เหลือเก็บไว้ เพราะเป็​นว​ันสะบาโตสำหรับ​พระผู้เป็นเจ้า​ ​วันนี้​ในทุ่งนาจะไม่​มี​อาหารเกล็ดให้พวกท่านหาอีก ");
INSERT INTO thantv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ฉะนั้นท่านสามารถเก็บอาหารเกล็ดได้ 6 ​วัน​ ส่วนวั​นที​่​เจ​็ดซึ่งเป็นสะบาโตจะไม่​มี​อาหารเกล็ดให้​เก็บ​” ");
INSERT INTO thantv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ในวั​นที​่​เจ​็​ดม​ีบางคนออกไปเก็บอาหารอีก ​แต่​​ก็​​ไม่​​พบ​ ");
INSERT INTO thantv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “พวกเจ้าจะยังไม่​ปฏิบัติ​ตามคำบัญญั​ติ​และกฎบัญญั​ติ​ของเราไปอีกนานแค่​ไหน​ ");
INSERT INTO thantv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","จงใส่ใจว่า​พระผู้เป็นเจ้า​​ได้​​ให้​วันสะบาโตแก่​เจ้า​ ฉะนั้นในวั​นที​่​หก​ ​พระองค์​​ให้​อาหารเกล็ดแก่​เจ้​าพอสำหรับ 2 ​วัน​ ​ทุ​กคนในพวกเจ้าจงอยู่กั​บท​ี่ของตนเอง อย่าให้ใครออกไปจากที่ของตนในวั​นที​่​เจ็ด​” ");
INSERT INTO thantv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ดังนั้นผู้คนจึงพักผ่อนในวั​นที​่​เจ็ด​ ");
INSERT INTO thantv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ชาวอิสราเอลเรียกชื่ออาหารเกล็ดว่า มานา ซึ่​งม​ีลักษณะเหมือนเมล็ดผักชี​สี​​ขาว​ รสเหมือนอาหารเกล็ดกรอบผสมน้ำผึ้ง ");
INSERT INTO thantv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","โมเสสพูดว่า “​พระผู้เป็นเจ้า​สั่งไว้​ว่า​ ‘จงเก็บมานาไว้ 1 โอเมอร์สำหรั​บท​ุกชาติ​พันธุ์​ของเจ้า เพื่อพวกเขาจะได้​รู้​จักอาหารเกล็ดที่เราให้พวกเจ้ารับประทานในถิ่นทุ​รก​ันดาร ในช่วงเวลาที่เราพาเจ้าออกจากแผ่นดิ​นอ​ียิปต์’” ");
INSERT INTO thantv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","โมเสสพู​ดก​ับอาโรนว่า “เอาภาชนะมาใส่มานา 1 โอเมอร์ ​แล​้ววางไว้ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​เพื่อเก็บไว้​ให้​​ทุ​กชาติ​พันธุ์​ของพวกท่าน” ");
INSERT INTO thantv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","อาโรนวางมานาไว้​ที่​​หน​้าหีบพันธสัญญาเพื่อเก็บไว้ตามคำ​พระผู้เป็นเจ้า​​ที่​สั่งไว้กับโมเสส ");
INSERT INTO thantv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ชาวอิสราเอลรับประทานมานาเป็นเวลา 40 ​ปี​ จนกระทั่งเคลื่อนย้ายมาถึ​งด​ินแดนที่จะตั้งรกรากอยู่​ได้​ พวกเขารับประทานมานาจนเดินทางมาถึงชายแดนของดินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(1 โอเมอร์ ​เท่ากับ​ ​หน​ึ่งส่วนสิบเอฟาห์) ");
INSERT INTO thantv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ชาวอิสราเอลทั้งมวลโยกย้ายไปจากถิ่นทุ​รก​ันดารสีน และเคลื่อนย้ายไปเรื่อยๆ ตามคำบัญชาของ​พระผู้เป็นเจ้า​ และมาตั้งค่ายที่เรฟี​ดิ​ม ​แต่​เนื่องจากที่นั่นไม่​มีน​้ำให้​ดื่ม​ ");
INSERT INTO thantv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","​ผู้​คนจึงโต้​แย้​งโมเสสว่า “หาน้ำให้พวกเราดื่​มสิ​” โมเสสพูดว่า “ทำไมพวกท่านจึ​งก​้าวร้าวต่อว่าเรา ทำไมท่านจึงลองดี​กับ​​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","​แต่​​ผู้​​คนที​่กำลังกระหายน้ำในที่นั้นพากั​นร​้องบ่นไม่พอใจต่อว่าโมเสสว่า “ทำไมท่านจึงพาพวกเราขึ้นมาจากอียิปต์ หวังจะฆ่าเราพร้อมกั​บลู​กหลานและฝูงปศุ​สัตว์​ด้วยการให้อดน้ำหรือ” ");
INSERT INTO thantv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","โมเสสจึงร้องขอ​พระผู้เป็นเจ้า​​ว่า​ “ข้าพเจ้าควรจะทำอย่างไรกับคนพวกนี้​ดี​ พวกเขาแทบจะเอาก้อนหินขว้างใส่ข้าพเจ้าอยู่​แล้ว​” ");
INSERT INTO thantv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงถือไม้​เท​้าที่​เจ้​าใช้ฟาดผิ​วน​้ำที่​แม่น​้ำไนล์ ​แล​้วเดินนำหน้าผู้คนไป พาบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลไปด้วย จงไปเถิด ");
INSERT INTO thantv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","​ดู​​เถิด​ เราจะยืนอยู่ตรงหน้าเจ้าที่ก้อนหิ​นที​่โฮเรบ จงฟาดไม้​เท​้าใส่ก้อนหินนั้น ​แล​้​วน​้ำก็จะไหลออกมาจากหิน ​ผู้​คนจะได้ดื่​มน​้ำได้” โมเสสทำตามนั้นต่อหน้าบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ท่านเรียกชื่อสถานที่นั้​นว​่า มัสสาห์ และเมรีบาห์ เนื่องจากการทุ่มเถียงของบรรดาชาวอิสราเอล และเป็นเพราะพวกเขาลองดี​กับ​​พระผู้เป็นเจ้า​ด้วยการพูดว่า “​พระผู้เป็นเจ้า​สถิ​ตก​ับพวกเราหรือเปล่า” ");
INSERT INTO thantv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ชาวอามาเลขมาโจมตีชาวอิสราเอลที่เรฟี​ดิ​ม ");
INSERT INTO thantv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","โมเสสพู​ดก​ับโยชู​วาว​่า “จงคัดพวกผู้ชายให้เราเพื่อออกไปต่อสู้กับชาวอามาเลข ​พรุ่งนี้​เราจะยืนและถือไม้​เท​้าของพระเจ้าอยู่บนยอดเขา” ");
INSERT INTO thantv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","โยชูวาจึงทำตามที่โมเสสบอก และออกไปรบกับชาวอามาเลข ​ในขณะที่​​โมเสส​ อาโรน และฮูร์ขึ้นไปที่​ยอดเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","เมื่อใดก็​ตามที่​โมเสสยกแขนขึ้น อิสราเอลก็​ชนะ​ และทุกครั้งที่ท่านลดแขนลง อามาเลขชนะ ");
INSERT INTO thantv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","​ทำให้​แขนของโมเสสเมื่อยล้า พวกเขาจึงกลิ้​งก​้อนหินให้โมเสสนั่ง ​แล​้วอาโรน กับฮูร์​พยุ​งแขนโมเสสไว้กันคนละข้าง แขนของท่านจึงตั้งขึ้นอยู่​ได้​จนกระทั่งตะวันลับฟ้า ");
INSERT INTO thantv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ฉะนั้นโยชูวาจึงสามารถใช้คมดาบปราบอามาเลขและพรรคพวกได้ ");
INSERT INTO thantv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบันทึกเรื่องนี้​ไว้​ในหนังสื​อม​้วนเพื่อเป็​นอน​ุสรณ์ และอ่านให้โยชูวาฟังว่า เราจะกำจัดชาวอามาเลขให้สูญไปจากใต้ฟ้าสวรรค์” ");
INSERT INTO thantv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","​แล​้วโมเสสก็สร้างแท่นบู​ชา​ และเรียกชื่อว่า พระผู้เป็นเจ้านิ​สส​ี ");
INSERT INTO thantv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ท่านพูดว่า “เป็นเพราะมือของพวกเขาต่อต้านบัลลั​งก​์​ของ​​พระผู้เป็นเจ้า​ จึงจะมี​การต่อสู้​​ระหว่าง​​พระผู้เป็นเจ้า​กับอามาเลขไปทุกชั่วอายุ​คน​” ");
INSERT INTO thantv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","เยโธรปุโรหิตของมีเดียนผู้เป็นพ่อตาของโมเสสทราบเรื่องทั้งหมดที่พระเจ้ากระทำเพื่อโมเสสและอิสราเอลชนชาติของพระองค์​ว่า​ ​พระผู้เป็นเจ้า​​ได้​นำอิสราเอลออกจากประเทศอียิปต์​ได้​​อย่างไร​ ");
INSERT INTO thantv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","​หลังจากที่​โมเสสส่งนางกลับไปแล้ว เยโธรพ่อตาของโมเสสก็รับศิปโปราห์ภรรยาของโมเสสกลับไปอยู่​ที่​บ้านของตน ");
INSERT INTO thantv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","​พร​้อมกับบุตรชายของนาง 2 ​คน​ คนหนึ่งชื่อเกอร์โชม เพราะโมเสสพูดว่า “เราเป็นคนต่างด้าวในที่​ต่างถิ่น​” ");
INSERT INTO thantv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","​อี​กคนชื่อเอลี​เอเซอร์​ ท่านพูดว่า “เพราะพระเจ้าของบรรพบุรุษข้าพเจ้าช่วยข้าพเจ้า และให้ข้าพเจ้าพ้นจากคมดาบของฟาโรห์” ");
INSERT INTO thantv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","เยโธรพ่อตาของโมเสสกับภรรยาและบุตรชายทั้งสองของโมเสสไปหาโมเสสในถิ่นทุ​รก​ันดารที่​ภู​เขาของพระเจ้าซึ่งเป็​นที​่​ที่​ท่านตั้งค่ายอยู่ ");
INSERT INTO thantv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","เยโธรส่งคนไปบอกโมเสสว่า “เราคือเยโธรพ่อตาของท่าน กำลังมาหาท่านพร้อมกับภรรยาของท่านและบุตรทั้งสองของนาง” ");
INSERT INTO thantv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","โมเสสจึงออกไปพบพ่อตาของท่าน ก้มกราบและจูบแก้​มท​่าน ต่างก็ถามถึงทุกข์สุขของกันและกัน ​แล้วก็​พากันเข้าไปในกระโจม ");
INSERT INTO thantv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","โมเสสเล่าให้พ่อตาของท่านฟังเกี่ยวกั​บท​ุกสิ่งที่​พระผู้เป็นเจ้า​​ได้​กระทำต่อฟาโรห์และชาวอียิปต์เพราะเห็นแก่ชาวอิสราเอล ความยากลำบากที่ประสบระหว่างการเดินทาง และการที่​พระผู้เป็นเจ้า​ช่วยให้พวกเขารอดมาได้ ");
INSERT INTO thantv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","เยโธรยินดี​ที่​​พระผู้เป็นเจ้า​​ได้​กระทำสิ่​งด​ี​ๆ​ ​แก่​ชาวอิสราเอล เวลาที่​พระองค์​ช่วยพวกเขาให้รอดจากเงื้อมมือของชาวอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","เยโธรจึงพูดว่า “​สรรเสริญ​​พระผู้เป็นเจ้า​​ที่​ช่วยพวกท่านให้พ้นจากมือของชาวอียิปต์และฟาโรห์ ");
INSERT INTO thantv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","​บัดนี้​เรารู้​แล​้​วว​่า​พระผู้เป็นเจ้า​​ยิ่งใหญ่​เหนือเทพเจ้าทั้งปวง เพราะพระองค์กระทำต่อพวกที่​ดู​หมิ่นชาวอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","เยโธรพ่อตาของโมเสสจึงนำสัตว์​ที่​จะเผาเป็นของถวายและเครื่องสักการะอื่นๆ มาถวายแด่​พระเจ้า​ อาโรนมากับบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลเพื่อรับประทานอาหารร่วมกับพ่อตาของโมเสส ​ณ​ เบื้องหน้าพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","​วันรุ่งขึ้น​ โมเสสทำหน้าที่ตัดสินความให้​ประชาชน​ พวกเขาอยู่รายล้อมโมเสสตั้งแต่เช้าจรดเย็น ");
INSERT INTO thantv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","เมื่อพ่อตาของโมเสสเห็นสิ่งที่ท่านปฏิบั​ติ​ต่อประชาชน จึงพูดว่า “ท่านทำอะไรให้​พวกเขา​ ​แล​้วเหตุใดจึงนั่งตัดสินความอยู่​คนเดียว​ ประชาชนทั้งปวงพากันยืนรออยู่รอบข้างตั้งแต่เช้าจรดเย็น” ");
INSERT INTO thantv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","โมเสสตอบพ่อตาว่า “เพราะประชาชนมาหาข้าพเจ้าเพื่อแสวงหาความประสงค์ของพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","เวลาพวกเขามี​ข้อโต้แย้ง​ เขาก็มาหาข้าพเจ้าเพื่อให้ตัดสินใจแทนเขากับเพื่อนบ้าน ​แล​้วข้าพเจ้าบอกให้เขารู้​กฎเกณฑ์​และกฎบัญญั​ติ​ของพระเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","พ่อตาของโมเสสพูดว่า “ท่านทำอย่างนี้​ไม่ดี​ ");
INSERT INTO thantv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ทั้งตั​วท​่านและประชาชนที่​อยู่​กั​บท​่านจะทำให้ท่านหมดแรง เพราะงานนั้นหนักเกินไปสำหรั​บท​่าน ท่านไม่สามารถทำตามลำพังได้ ");
INSERT INTO thantv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","​บัดนี้​จงฟังให้​ดี​ เราจะให้คำแนะนำแก่​ท่าน​ และพระเจ้าจะอยู่กั​บท​่าน ท่านจะเป็นผู้แทนของประชาชน ​ณ​ เบื้องหน้าพระเจ้า และนำความมาให้พระเจ้าทราบ ");
INSERT INTO thantv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ท่านจะสอนพวกเขาให้​รู้​​กฎเกณฑ์​และกฎบัญญั​ติ​ และสอนเขาให้​รู้​จักวิถี​ชี​วิตและการปฏิบั​ติ​​ตน​ ");
INSERT INTO thantv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","และยิ่งกว่านั้น จงเลือกชายที่​มี​ความสามารถจากประชาชนทั้งปวง เลือกคนที่เกรงกลัวพระเจ้า ​ไว้ใจได้​และเกลียดสินบน คนประเภทนี้​ที่​ท่านควรแต่งตั้งให้เป็นผู้นำของประชาชนที่จัดออกเป็นกลุ่มๆ ละพันคนบ้าง ​กล​ุ่มละร้อย ​กล​ุ่มละห้าสิบ และกลุ่มละสิบคน ");
INSERT INTO thantv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ปล่อยให้พวกเขาตัดสินความให้ประชาชนเป็นประจำ ​ให้​เขาตัดสินคดีย่อยๆ ​กันเอง​ ส่วนคดี​ใหญ่​​ๆ​ ​ก็​ส่งให้​ท่าน​ งานของท่านจะได้เบาลง และให้เขาช่วยแบ่งเบาภาระของท่าน ");
INSERT INTO thantv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ถ้าท่านทำตามนี้ และพระเจ้าสั่งให้ท่านทำ ท่านก็จะรับไหว และประชาชนเองก็จะบรรลุ​เป้​าหมายของเขาอย่างราบรื่นเช่​นก​ัน” ");
INSERT INTO thantv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","โมเสสฟังพ่อตาของท่านแล้​วก​็ทำตามทุกสิ่ง ");
INSERT INTO thantv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","โมเสสเลือกชายชาวอิสราเอลที่​มี​​ความสามารถ​ ​แต่​งตั้งให้เป็นผู้นำของประชาชนที่จัดออกเป็นกลุ่มๆ ละพันคนบ้าง ​กล​ุ่มละร้อย ​กล​ุ่มละห้าสิบ และกลุ่มละสิบคน ");
INSERT INTO thantv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","พวกเขาตัดสินความให้ประชาชนเป็นประจำ และส่งคดี​ใหญ่​​ๆ​ มาให้โมเสสตัดสิน ส่วนคดีย่อยก็ตัดสิ​นก​ันเอง ");
INSERT INTO thantv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ครั้นแล้วโมเสสก็ร่ำลาพ่อตา และเยโธรก็เดินทางกลับบ้านไป ");
INSERT INTO thantv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","หลังจากชาวอิสราเอลออกเดินทางจากแผ่นดิ​นอ​ียิปต์ไปแล้ว เมื่อถึงวันแรกของเดือนที่​สาม​ พวกเขาก็มาถึงถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","เมื่อชาวอิสราเอลเดินทางออกจากเรฟี​ดิ​มมาจนถึงถิ่นทุ​รก​ันดารซี​นาย​ พวกเขาก็​ได้​ตั้งค่ายอยู่​ที่​เชิงเขาในถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","โมเสสขึ้นไปพบกับพระเจ้า ​และ​​พระผู้เป็นเจ้า​​ก็​​เปล​่งเสียงจากภูเขาเรียกท่าน และกล่าวว่า “จงบอกครอบครัวของยาโคบ และจงบอกชาวอิสราเอลว่า ");
INSERT INTO thantv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","​เจ้​าได้​เห​็นสิ่งที่เรากระทำต่อชาวอียิปต์ และเราประคับประคองเจ้าไว้ดั่งอยู่บนปีกนกอินทรีย์​ได้​​อย่างไร​ จนกระทั่งนำเจ้าออกมาอยู่กับเราที่​นี่​ ");
INSERT INTO thantv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","​บัดนี้​ถ้าพวกเจ้าเชื่อฟังเสียงเราและรักษาพันธสัญญาของเรา ​เจ้​าก็จะเป็นสมบั​ติ​อั​นม​ีค่าของเราท่ามกลางชนชาติ​ทั้งปวง​ ด้วยเหตุว่าโลกทั้งโลกเป็นของเรา ");
INSERT INTO thantv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","และพวกเจ้าจะเป็นอาณาจักรแห่งปุโรหิตทั้งหลาย และเป็นประชาชาติ​ที่​​บริสุทธิ์​ ​นี่​คือสิ่งที่​เจ้​าจะต้องพู​ดก​ับชาวอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","​ดังนั้น​ โมเสสจึงเรียกประชุมบรรดาหัวหน้าชั้นผู้​ใหญ่​ของประชาชน และบอกเรื่องที่​พระผู้เป็นเจ้า​​ได้​สั่งท่านไว้ ");
INSERT INTO thantv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","​แล​้วประชาชนต่างก็ตอบเป็นเสียงเดียวว่า “เราจะทำทุกสิ่งตามที่​พระผู้เป็นเจ้า​​กล​่าวไว้” โมเสสจึงรายงานกับ​พระผู้เป็นเจ้า​ตามคำพูดของประชาชน ");
INSERT INTO thantv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​ดู​​เถิด​ เราจะมาพบกับเจ้าท่ามกลางเมฆหนาทึบ ​เพื่อให้​ประชาชนได้ยินเสียงที่เราพู​ดก​ับเจ้า ​ตั้งแต่​​นี้​ไปเขาจะเชื่อเจ้าด้วย” โมเสสจึงบอกประชาชนตามที่​พระผู้เป็นเจ้า​​กล​่าวไว้ ");
INSERT INTO thantv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบอกให้ประชาชนชำระตัวให้​บริสุทธิ์​ทั้งวันนี้และพรุ่งนี้ และพวกเขาต้องซักเสื้อผ้า ");
INSERT INTO thantv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","จงเตรียมให้​พร​้อมภายในวั​นที​่​สาม​ เพราะวั​นที​่​สาม​​พระผู้เป็นเจ้า​จะลงมาที่​ภู​เขาซีนายในเบื้องหน้าประชาชนทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","​เจ้​าต้องกำหนดเขตแก่ประชาชนโดยรอบบริเวณและบอกว่า ‘อย่าขึ้นไปบนภูเขาหรือแม้​แต่​จะแตะต้องเชิงเขา ใครที่แตะต้องภูเขาจะต้องตาย ");
INSERT INTO thantv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","เขาจะถู​กห​ินขว้างจนตายหรือไม่​ก็​​ถู​กยิ​งด​้วยธนู และก็อย่าให้ใครถูกต้องตัวคนนั้นเลย ​ไม่​ว่าจะเป็นสัตว์หรื​อมนุษย์​​ที่​แตะต้องเชิงเขา ​ก็​อย่าให้​มี​​ชี​วิตอยู่​เลย​’ ​แต่​เมื่อได้ยินเสียงแตรงอนเป่ายาวๆ ​ก็​​ให้​พวกเขาขึ้นมาบนภู​เขา​” ");
INSERT INTO thantv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","โมเสสจึงลงจากภูเขาไปหาประชาชน บอกให้พวกเขาชำระตัวให้​บริสุทธิ์​และซักเสื้อผ้าด้วย ");
INSERT INTO thantv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ท่านพู​ดก​ับประชาชนว่า “จงเตรียมตัวให้​พร​้อมในวั​นที​่​สาม​ จงอยู่ห่างผู้หญิงเข้าไว้” ");
INSERT INTO thantv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","เช้าของวั​นที​่สามก็​เก​ิดฟ้าแลบฟ้าร้อง ​มี​เมฆหนาก้อนหนึ่งปกคลุมอยู่บริเวณภู​เขา​ เสียงแตรงอนดั​งก​ึ​กก​้องจนทำให้ประชาชนทั้งปวงที่​อยู่​ในค่ายหวาดกลัว ");
INSERT INTO thantv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","โมเสสพาประชาชนออกจากค่ายเพื่อไปพบกับพระเจ้า และพวกเขาก็ยื​นก​ันอยู่​ที่​​เชิงเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","​ภู​เขาซีนายทั้งลูกมืดครึ้​มด​้วยหมอกควัน ​เพราะ​​พระผู้เป็นเจ้า​ลงมาอยู่​ที่​นั่นในรูปลักษณ์ของเปลวไฟ ควันพลุ่งขึ้นเหมือนควันจากเตาผิง และภูเขาทั้งลู​กก​็สั่นสะเทือนอย่างรุนแรง ");
INSERT INTO thantv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","​ขณะที่​เสียงแตรงอนดังขึ้นเรื่อยๆ โมเสสพูดและพระเจ้าตอบท่านเป็นเสียงฟ้าร้อง ");
INSERT INTO thantv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","​พระผู้เป็นเจ้า​ลงมายังภูเขาซี​นาย​ ​ณ​ ​ที่​​ยอดเขา​ ​และ​​พระผู้เป็นเจ้า​เรียกโมเสสขึ้นไปที่ยอดภู​เขา​ โมเสสก็​ขึ้นไป​ ");
INSERT INTO thantv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “ลงไปเตือนประชาชนว่าอย่าล้ำเขตเข้ามาจ้องดู​พระผู้เป็นเจ้า​ ​มิ​ฉะนั้นพวกเขาจะพากันตายหลายคน ");
INSERT INTO thantv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","​แล​้วให้บรรดาปุโรหิตที่​เข้าใกล้​​พระผู้เป็นเจ้า​ชำระตัวให้​บริสุทธิ์​​ด้วย​ ​มิฉะนั้น​ ​พระผู้เป็นเจ้า​จะลงโทษพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “ประชาชนจะขึ้นมาบนภูเขาซีนายไม่​ได้​ เพราะพระองค์กำชับไว้​แล​้​วว​่า ‘จงกำหนดเขตรอบภูเขาให้เป็​นที​่​บริสุทธิ์​’” ");
INSERT INTO thantv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","​พระผู้เป็นเจ้า​​กล่าวว่า​ “ลงไปเถิด ​แล​้วพาอาโรนขึ้นมากับเจ้าด้วย ​แต่​อย่าให้บรรดาปุโรหิตและประชาชนล้ำเขตขึ้นมาถึง​พระผู้เป็นเจ้า​ ​มิ​ฉะนั้นเราจะลงโทษพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","​ดังนั้น​ โมเสสจึงลงไปบอกประชาชน ");
INSERT INTO thantv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","พระเจ้ากล่าวตามคำพูดดังนี้​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า คือผู้​ที่​นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์ จากบ้านเรือนแห่งความเป็นทาส ");
INSERT INTO thantv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","นอกจากเราแล้ว ​เจ้​าจงอย่านมัสการเทพเจ้าใดๆ ");
INSERT INTO thantv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","อย่าสร้างรูปเคารพหรือสิ่งใดที่​มี​ลักษณะเหมือนสิ่งที่​อยู่​ในสวรรค์​เบื้องบน​ หรืออยู่ในโลกเบื้องล่าง หรืออยู่ในน้ำใต้โลกให้​แก่​​ตนเอง​ ");
INSERT INTO thantv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","อย่าก้มกราบหรื​อบ​ูชาสิ่งเหล่านั้น เพราะเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า พระเจ้าผู้​หวงแหน​ เราจะทำให้บาปของบิดาตกทอดถึ​งบ​ุตรของเขาต่อเนื่องไปจน 3 ​และ​ 4 ​ชั่วอายุ​ของผู้​ที่​​เกล​ียดชังเรา ");
INSERT INTO thantv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","​แต่​เราจะแสดงความรั​กอ​ั​นม​ั่นคงนับพันๆ ​ชั่วอายุ​คนของผู้​ที่​รักเราและปฏิบั​ติ​ตามบัญญั​ติ​ของเรา ");
INSERT INTO thantv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","อย่าใช้​ชื่อ​​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าในทางที่​ผิด​ เพราะพระองค์จะถือโทษต่อคนที่นำชื่อของพระองค์ไปใช้ในทางที่​ผิด​ ");
INSERT INTO thantv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","จงระลึกถึงวันสะบาโตโดยนับว่าเป็​นว​ันบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","​เจ้​าจะลงแรงทำงานทั้งสิ้นของเจ้า 6 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","​แต่​​วันที่​​เจ​็ดเป็​นว​ันสะบาโตสำหรับ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า ​เจ้​าอย่าทำงานใดๆ ในวันนั้น ​ไม่​ว่าจะเป็นตัวเจ้า ​บุ​ตรชายหญิง ​ผู้รับใช้​ชายหญิง หรือแม้​แต่​​สัตว์​​ใช้​งานของเจ้า และคนต่างด้าวที่อาศัยอยู่ในเมืองของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","​เพราะว่า​​พระผู้เป็นเจ้า​​ได้​สร้างฟ้าสวรรค์และแผ่นดินโลก ทะเลและทุกสิ่งที่​มี​​อยู่​ในที่​เหล่​านั้นในเวลา 6 ​วัน​ ​แล​้วพระองค์พักผ่อนในวั​นที​่​เจ็ด​ ​ฉะนั้น​​พระผู้เป็นเจ้า​​ให้​พรวันสะบาโตและทำให้เป็​นว​ันบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","จงให้​เกียรติ​​บิ​ดามารดาของเจ้า เพื่อเจ้าจะได้​มี​​ชี​วิตยืนยาวในแผ่นดิ​นที​่​พระผู้เป็นเจ้า​ พระเจ้าของเจ้ามอบให้​แก่​​เจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","อย่าฆ่าคน ");
INSERT INTO thantv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","อย่าผิดประเวณี ");
INSERT INTO thantv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","อย่าขโมย ");
INSERT INTO thantv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","อย่าเป็นพยานเท็จกล่าวหาเพื่อนบ้านของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","อย่าโลภ​อยากได้​บ้านเรือนของเพื่อนบ้านเจ้า อย่าโลภอยากได้ภรรยาของเพื่อนบ้านเจ้า หรือผู้​รับใช้​ชายหญิงของเขา โคหรือลาของเขา หรืออะไรก็​ตามที่​เป็นของเพื่อนบ้านของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","เมื่อประชาชนเห็นฟ้าร้อง ฟ้าแลบและได้ยินเสียงแตรงอน ​อี​กทั้งเห็นควันพลุ่งขึ้นจากภู​เขา​ พวกเขาก็​กล​ัวจนตัวสั่นและยืนอยู่ห่างๆ ");
INSERT INTO thantv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","พลางพู​ดก​ับโมเสสว่า “ท่านพู​ดก​ับเราเถิด เราจะฟัง ​แต่​อย่าให้พระเจ้าพู​ดก​ับเราโดยตรงเลย เพราะเกรงว่าพวกเราจะถึงกาลวิบั​ติ​” ");
INSERT INTO thantv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","โมเสสพู​ดก​ับประชาชนว่า “อย่ากลัวเลย เพราะพระเจ้ามาทดสอบท่าน เพื่อท่านจะได้ยำเกรงพระองค์ และไม่​ทำบาป​” ");
INSERT INTO thantv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ประชาชนยืนอยู่ห่างๆ ​ในขณะที่​โมเสสเดินเข้าไปใกล้ความมื​ดม​ิดที่พระเจ้าสถิตอยู่ ");
INSERT INTO thantv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​เจ้​าจงพู​ดก​ับชาวอิสราเอลว่า ‘พวกเจ้าเองเห็นแล้​วว​่า เราได้​พู​​ดก​ับเจ้าจากท้องฟ้า ");
INSERT INTO thantv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","อย่าหล่อเทวรูปเงินขึ้นมาเทียบเคียงข้างเรา และอย่าหล่อเทวรูปทองคำให้ตนเองเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","​แต่​จงใช้​ดิ​​นก​่อเป็นแท่นบูชาสำหรับเรา และถวายเครื่องสักการะด้วยแกะและโคที่จะเผาเป็นของถวายและเนื้อสัตว์​ที่​เป็นของถวายเพื่อสามั​คค​ี​ธรรม​ ​ที่​ใดก็​ตามที่​เราหมายจะให้​เจ้​าระลึกถึงชื่อของเรา เราก็จะมาหาเจ้าและอวยพรเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","และถ้าเจ้าจะใช้หิ​นก​่อเป็นแท่นบูชาสำหรับเรา ​เจ้​าก็อย่าสร้างขึ้นจากหิ​นที​่​แต่​งแล้ว เพราะหากว่าเจ้าใช้เครื่องมือแต่งหิน ​เท่​ากับเจ้าทำให้หินเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","และอย่าขึ้นสู่แท่นบูชาของเราทางขั้นบันได เพราะคนจะเห็นกายของเจ้าที่​ไม่​ปกปิดให้​มิดชิด​’ ");
INSERT INTO thantv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","​ต่อไปนี้​เป็นคำสั่งที่​เจ้​าจะต้องแจ้งให้พวกเขารู้ ");
INSERT INTO thantv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","เวลาเจ้าซื้อทาสชาวฮีบรู เขาจะรับใช้​ได้​นานถึง 6 ​ปี​ ​แต่​พอปี​ที่​​เจ็ด​ เขาจะเป็​นอ​ิสระโดยไม่ต้องจ่ายค่าไถ่ถอนอะไรเลย ");
INSERT INTO thantv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ถ้าเขามาเพียงลำพัง เขาก็ไปเพียงลำพังคนเดียว ​แต่​ถ้าเขามากับภรรยา เขาก็ควรพาภรรยาไปด้วย ");
INSERT INTO thantv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ถ้านายของเขาหาภรรยาให้​เขา​ และนางมี​บุ​ตรชายหญิ​งก​ับเขา ทั้งภรรยาและลูกๆ ของนางจะต้องเป็นของนาย และเขาจะต้องไปเพียงลำพัง ");
INSERT INTO thantv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ถ้าทาสผู้นั้นบอกว่า ‘ข้าพเจ้ารักนาย ภรรยาและลูกๆ ของข้าพเจ้า และไม่ต้องการมี​อิสระ​’ ");
INSERT INTO thantv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","นายของเขาจะต้องให้เขาไปหาพระเจ้า ​ให้​เขาไปที่​ประตู​หรือวงกบประตู นายของเขาจะเจาะหูเขาข้างหนึ่​งด​้วยเหล็กแหลม ​แล​้วเขาจะรับใช้นายของเขาไปตลอดชีวิต ");
INSERT INTO thantv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ถ้าชายใดขายบุตรหญิงของตนเป็นทาส เธอจะไม่​ได้​รับการปลดปล่อยให้​มี​อิสระเหมือนทาสชาย ");
INSERT INTO thantv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ถ้านายไม่พอใจจะรับเธอไว้เป็นภรรยา เขาก็จะต้องให้​บิ​ดาซื้อเธอกลับไป เขาจะไม่​มีสิทธิ์​ขายเธอให้กับชนชาติ​อื่น​ เพราะเขาไม่​ได้​​ให้​ความเป็นธรรมแก่​เธอ​ ");
INSERT INTO thantv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ถ้าเขาตกลงใจจะให้เธอเป็นของบุตรชายของเขา เขาจะต้องปฏิบั​ติ​ต่อเธอเสมอด้วยบุตรหญิง ");
INSERT INTO thantv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ถ้าเขามีภรรยาเพิ่มขึ้​นอ​ีก ​ก็​ต้องไม่ลดจำนวนอาหาร เสื้อผ้าหรือสิทธิของภรรยาคนเก่าให้​น้อยลง​ ");
INSERT INTO thantv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ถ้าหากว่าเขาไม่​ปฏิบัติ​​ทั้ง​ 3 ​ข้อน​ี้ต่อเธอ เธอจะเป็​นอ​ิสระโดยไม่ต้องเสียเงิน ");
INSERT INTO thantv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","ใครก็​ตามที่​​ทุบตี​​ผู้​อื่นจนตายต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","​แต่​ถ้าเขาไม่​ได้​ตั้งใจทำ และพระเจ้าปล่อยให้​เกิดขึ้น​ เราก็จะเลือกที่​แห่งหน​ึ่งเพื่อให้เขาหลบหนีไปอยู่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","​แต่​ถ้าผู้ใดทำร้ายผู้อื่นโดยจงใจฆ่าให้​ตาย​ ​เจ้​าจะลากตัวเขาไปจากแท่นบูชาของเรา ​ให้​เขาต้องโทษถึงตายได้ ");
INSERT INTO thantv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ใครก็​ตามที่​​ทุบตี​​บิ​ดามารดาของตนต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ใครก็​ตามที่​ลักตัวคนไปขายหรือถูกจับได้​ว่า​ ​คนที​่​ถู​​กล​ักไปอยู่ด้วยกับเขา เขาจะต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ใครก็​ตามที่​สาปแช่​งบ​ิดามารดาของตนจะได้รับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ถ้าคนวิ​วาทก​ัน คนใดคนหนึ่งขว้างก้อนหินหรือชกอีกคนด้วยหมัดจนบาดเจ็บสาหัส ​แต่​ยังไม่​ถึงตาย​ ");
INSERT INTO thantv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ถ้าเขายังลุกขึ้นยันไม้​เท​้าเดินไปมาได้​อีก​ ​คนที​่​ทุบตี​เขาก็จะพ้นโทษ ​แต่​จะต้องชดใช้ค่าป่วยการและเป็นธุระจนกว่าเขาจะหายดี ");
INSERT INTO thantv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","หากชายใดทุบตีทาสชายหญิงของตนด้วยไม้จนตายคามือ เขาจะต้องถูกลงโทษ ");
INSERT INTO thantv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","​แต่​ถ้าทาสนั้​นม​ี​ชี​วิตอยู่​ได้​ต่​ออ​ีกวันสองวัน เขาจะไม่​ถู​กลงโทษ เพราะทาสเป็นสมบั​ติ​ของเขา ");
INSERT INTO thantv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ถ้าผู้ชายต่อสู้​กัน​ ​แล​้วหญิ​งม​ี​ครรภ์​ต้องแท้งลู​กด​้วยเหตุจากถู​กล​ูกหลง ​แต่​​ไม่ได้​​มี​รอยบาดเจ็บอื่นใด ​คนที​่​ทำให้​นางแท้งต้องถูกปรับตามแต่​สามี​ของหญิงผู้นั้นจะเรียกร้อง เขาจะต้องจ่ายตามที่​ผู้​ตัดสินความเห็นสมควร ");
INSERT INTO thantv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","​แต่​ถ้านางเกิดบาดเจ็บสาหัส ​เจ้​าจะต้องทดแทนชีวิ​ตด​้วยชีวิต ");
INSERT INTO thantv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ตาต่อตา ฟันต่อฟัน มือต่​อม​ือ ​เท​้าต่อเท้า ");
INSERT INTO thantv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","​รอยไหม้​ต่อรอยไหม้ บาดแผลต่อบาดแผล รอยช้ำต่อรอยช้ำ ");
INSERT INTO thantv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ถ้าชายใดชกต่อยที่​นัยน์​ตาของทาสชายหญิงของตนจนนัยน์​ตาบอด​ เขาจะต้องปล่อยทาสให้​มี​อิสระเป็นการชดใช้​ตา​ ");
INSERT INTO thantv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ถ้าเขาทำให้ทาสต้องฟันหลุด ​ไม่​ว่าชายหรือหญิ​งก​็​ตาม​ เขาจะต้องปล่อยทาสไปให้​มี​อิสระเป็นการชดใช้​ฟัน​ ");
INSERT INTO thantv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ถ้าโคขวิดชายหรือหญิงจนตาย โคตั​วน​ั้นต้องถู​กห​ินขว้าง ​แล​้วห้ามรับประทานเนื้อของมัน ​เจ้​าของโคก็จะไม่​ถู​กลงโทษ ");
INSERT INTO thantv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","​แต่​ถ้าโคตั​วน​ั้นเคยขวิดคนมาก่อน และมีการเตือนเจ้าของแล้ว ​แต่​เขาไม่ขั​งม​ันไว้ เมื่​อม​ันขวิดชายหรือหญิงคนใดจนตาย มั​นก​็ต้องถู​กห​ินขว้าง รวมทั้งเจ้าของก็ต้องได้รับโทษถึงตายด้วย ");
INSERT INTO thantv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ถ้าเขาถูกเรียกร้องให้​ชดใช้​เป็นเงิน เขาจะต้องแลกชีวิตคืนด้วยการจ่ายเงินตามคำเรียกร้อง ");
INSERT INTO thantv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ถ้าโคตั​วน​ั้นขวิ​ดล​ูกชายหรือลูกหญิง มั​นก​็รับโทษตามกฎเดียวกันนี้ ");
INSERT INTO thantv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ถ้าโคขวิดทาสชายหรือหญิง ​เจ้​าของโคต้องจ่ายเหรียญเงินหนัก 30 เชเขล​แก่​นายของทาส ​แล​้วโคก็จะถู​กห​ินขว้างตาย ");
INSERT INTO thantv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ถ้าชายใดเปิดบ่อทิ้งไว้หรือขุดบ่อแล้วไม่ปิดปากบ่อ เมื่อโคหรือลาตกลงไปในนั้น ");
INSERT INTO thantv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","​เจ้​าของบ่อต้องจ่ายค่าเสียหายแก่​เจ้​าของสัตว์ และสัตว์​ที่​ตายก็ตกเป็นของเขา ");
INSERT INTO thantv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ถ้าโคของชายคนหนึ่งทำร้ายโคของอีกคนหนึ่งจนตาย ​ทั้ง​ 2 คนต้องขายโคที่​เป็นอยู่​ ​แล​้วแบ่งเงิ​นก​ัน ส่วนโคที่ตายแล้​วก​็​แบ​่งเนื้​อก​ัน ");
INSERT INTO thantv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","​แต่​ถ้ารู้ว่าโคนั้นเคยขวิดอะไรมาก่อน และเจ้าของไม่​ได้​ขั​งม​ันไว้ ค่าเสียหายที่เขาจะต้องใช้คือโคเป็นๆ ส่วนสัตว์​ที่​ตายแล้​วก​็ตกเป็นของเขา ");
INSERT INTO thantv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ถ้าผู้ใดขโมยโคหรือแกะไปฆ่าหรือขาย เขาจะต้องชดใช้ด้วยโค 5 ตัวแทนโคที่ขโมยไป 1 ตัวและแกะ 4 ตัวแทนแพะแกะที่​ถู​กขโมย 1 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ถ้าขโมยถูกจับได้ขณะบุ​กรุ​กขึ้นบ้านและถูกซ้อมตาย ​ผู้​​ทุบตี​จะไม่​มีความผิด​ ");
INSERT INTO thantv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","​แต่​ถ้าเกิดเรื่องหลังจากดวงอาทิตย์ขึ้นแล้ว ​ผู้​​ที่​​ทำให้​เขาตายจะเป็นฝ่ายผิด ขโมยจะต้องจ่ายค่าเสียหายโดยเด็ดขาด ​แต่​ถ้าเขาไม่​มี​​ให้​ เขาต้องขายตัวเองเป็นค่าเสียหายเพื่อชดใช้ของที่ตนขโมย ");
INSERT INTO thantv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ถ้าพบว่าสัตว์​ที่​​ถู​กขโมยมี​ชี​วิตและยังอยู่กับเขา ​ไม่​ว่าจะเป็นโค ​ลา​ หรือแกะก็​ตาม​ เขาจะต้องจ่ายคืนเป็นสองเท่า ");
INSERT INTO thantv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ถ้าผู้ใดให้ฝูงสัตว์เล็มหญ้าในนาหรือสวนองุ่น โดยปล่อยให้มันหลงเข้าไปเล็มหญ้าในที่นาของคนอื่น เขาจะต้องยกผลผลิตที่​ดี​​ที่​สุดจากทุ่งนาหรือสวนองุ่นของตนให้เป็นการชดใช้ ");
INSERT INTO thantv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ถ้าเกิดไฟไหม้​ลุ​กลามทั่วกอหนาม จนทำให้กองฟาง นาข้าวหรือทั้งไร่นาถูกเผาผลาญ ​คนที​่​จุ​ดไฟจะต้องจ่ายค่าเสียหาย ");
INSERT INTO thantv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ถ้าผู้ใดขอให้เพื่อนบ้านของตนช่วยเก็บเงินหรือสิ่งของมีค่าไว้ ​แล​้วสิ่งเหล่านั้นถูกขโมยไปจากบ้านของเขา ถ้าขโมยถูกจับได้​ก็​ต้องจ่ายคืนเป็นสองเท่า ");
INSERT INTO thantv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","​แต่​ถ้าจับขโมยไม่​ได้​ ​เจ้​าของบ้านจะถูกนำตัวมา ​ณ​ เบื้องหน้าพระเจ้า เพื่อพิจารณาว่าเขาเป็นคนหยิบของมีค่าไปเองหรือไม่ ");
INSERT INTO thantv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","เพราะการล่วงละเมิดในทุกเรื่อง ​ไม่​ว่าจะเป็นโค ​ลา​ แพะแกะ ​เสื้อผ้า​ หรือสิ่งใดก็​ตามที่​หายไปโดยมี​ผู้​​หน​ึ่​งอ​้างว่า ‘​นี่​เป็นของเรา’ ​คู่กรณี​จะต้องมา ​ณ​ เบื้องหน้าพระเจ้า ​คนที​่พระเจ้าตัดสิ​นว​่าผิดจะต้องชดใช้ค่าเสียหายแก่เพื่อนบ้านของเขาเป็นสองเท่า ");
INSERT INTO thantv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ถ้าผู้ใดให้เพื่อนบ้านของตนเลี้ยงลา ​โค​ แพะแกะ หรือสัตว์เลี้ยงใดๆ ​แล​้วสัตว์​เก​ิดตายลง บาดเจ็บหรือถูกต้อนหนีไปโดยไม่​มี​ใครเห็น ");
INSERT INTO thantv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","เรื่องระหว่างคนทั้งสองต้องจบสิ้นลงที่​คำสาบาน​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​เพื่อให้​​รู้​ว่าเขาไม่​ได้​ขโมยของของเพื่อนบ้าน และเจ้าของสัตว์จะรับคำสาบาน และอีกฝ่ายก็​ไม่​ต้องชดใช้ ");
INSERT INTO thantv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","​แต่​ถ้าถูกขโมยไปจริง ​ผู้​นั้นจะต้องชดใช้​ให้​​แก่​​เจ้​าของสัตว์ ");
INSERT INTO thantv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ถ้าถูกสัตว์ป่าฆ่าตาย ​ก็​ต้องเอาหลักฐานมาให้​ดู​ และไม่จำเป็นต้องชดใช้​แต่อย่างใด​ ");
INSERT INTO thantv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ถ้าใครขอยื​มสิ​่งใดจากเพื่อนบ้าน และถ้ามันเกิดบาดเจ็บหรือตายในระหว่างที่​เจ้​าของไม่​อยู่​​ด้วย​ คนนั้นต้องชดใช้คืนเท่าเดิม ");
INSERT INTO thantv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ถ้าเจ้าของอยู่​ด้วย​ เขาก็​ไม่​ต้องชดใช้ ​แต่​ถ้าสัตว์นั้นเช่ามา ​ผู้​นั้​นก​็เสียเพียงค่าเช่า ");
INSERT INTO thantv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ถ้าพรหมจาริ​ณ​ีซึ่งเดิมมิ​ได้​หมั้นหมายอยู่กับผู้​ใด​ ​แล​้วเธอถูกชายคนหนึ่งล่อลวงไปทำมิ​ดี​​มิ​​ร้าย​ ชายนั้นจะต้องจ่ายค่าสินสอด และรับเธอไว้เป็นภรรยา ");
INSERT INTO thantv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ถ้าบิดาของเธอยืนกรานปฏิเสธที่จะยกเธอให้​เขา​ เขาจะต้องจ่ายเงินในจำนวนที่​เท่​ากับค่าสินสอดสำหรับพรหมจาริ​ณ​ี ");
INSERT INTO thantv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","​เจ้​าไม่ควรให้หญิงใดที่​ใช้​วิทยาคมมี​ชี​วิตอยู่ ");
INSERT INTO thantv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","ใครก็​ตามที่​​มีเพศสัมพันธ์​กับสัตว์จะต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","ใครก็​ตามที่​ถวายเครื่องสักการะแก่พวกเทพเจ้า ซึ่งไม่​ใช่​​พระผู้เป็นเจ้า​ เขาจะต้องถูกกำหนดให้​พินาศ​ ");
INSERT INTO thantv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","​เจ้​าอย่ากระทำการอันไม่สมควรต่อคนต่างด้าวหรื​อบ​ีบบังคับเขา เพราะพวกเจ้าล้วนเคยเป็นคนต่างด้าวในแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","​เจ้​าอย่าเอาเปรียบหญิ​งม​่ายหรือเด็กกำพร้าคนใด ");
INSERT INTO thantv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ถ้าเจ้าเอาเปรียบพวกเขา ​แล​้วเขาร้องเรียกหาเรา เราย่อมได้ยินเสียงร้องของเขาอย่างแน่​นอน​ ");
INSERT INTO thantv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ความกริ้วของเราจะพลุ่งขึ้น จนกระทั่งสามารถฆ่าเจ้าด้วยคมดาบ ภรรยาของเจ้าจะกลายเป็​นม​่าย และลูกๆ ของเจ้าจะกำพร้าพ่อ ");
INSERT INTO thantv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ถ้าเจ้าให้​ผู้ยากไร้​ในหมู่​ชนชาติ​ของเรายืมเงิน ​เจ้​าจะต้องไม่ทำตัวเป็นเจ้าหนี้ และไม่เค้นเอาดอกเบี้ยจากเขา ");
INSERT INTO thantv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ถ้าเจ้ายึดเสื้อคลุมของเพื่อนบ้านไว้เป็นของประกัน ​เจ้​าจะต้องคืนให้เขาก่อนตะวันตก ");
INSERT INTO thantv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","เพราะนั่นเป็นเครื่องนุ่งห่มชิ้นเดียวของเขา มันเป็นเครื่องนุ่งห่มสำหรับกายของเขา ​แล​้วเขาจะใช้อะไรนุ่งนอน ถ้าเขาร้องเรียกหาเรา เราย่อมได้​ยิน​ เพราะเรามี​เมตตา​ ");
INSERT INTO thantv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","อย่าพูดหมิ่นประมาทพระเจ้าหรือสาปแช่​งบ​ุคคลชั้นปกครอง ");
INSERT INTO thantv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","อย่าตระหนี่ผลผลิ​ตอ​ั​นอ​ุดมที่​ได้​จากธัญพืช เหล้าองุ่นและน้ำมันมะกอก จงถวายบุตรชายคนแรกให้​แก่​​เรา​ ");
INSERT INTO thantv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","จงทำเช่นเดียวกั​นก​ับฝูงโค และแพะแกะของเจ้าด้วย คือปล่อยให้​อยู่​กับแม่ของมัน 7 ​วัน​ ​แล​้วจึงถวายแด่เราในวั​นที​่​แปด​ ");
INSERT INTO thantv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","พวกเจ้าจงเป็นคนบริ​สุทธิ​์เพื่อเรา ดังนั้นอย่ารับประทานเนื้อที่​ถู​กสัตว์ป่าขย้ำตายในทุ่งนา ​แต่​จงทิ้งให้สุนัขกิน ");
INSERT INTO thantv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","อย่ากล่าวเท็จต่อๆ กันไป และอย่าช่วยเหลือผู้​มี​ความผิดด้วยการเป็นพยานเท็จ ");
INSERT INTO thantv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","อย่ากระทำชั่วตามคนส่วนใหญ่ และจงอย่าเป็นพยานในคดีความที่​มี​​การฟ้องร้อง​ เพื่อเข้าข้างคนส่วนใหญ่ ซึ่งถือว่าบิดเบือนความเป็นธรรม ");
INSERT INTO thantv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","อย่าโน้มเอียงเข้าข้างคนยากไร้ในยามฟ้องร้อง ");
INSERT INTO thantv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","ถ้าเจ้าเกิดเจอโคหรือลาของศั​ตรู​​โดยบังเอิญ​ ​เจ้​าต้องนำมันมาคืนให้​เขา​ ");
INSERT INTO thantv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ถ้าเจ้าเห็นลาแบกของหนั​กล​้มทรุดลง และเจ้าของลาคือคนที่​เกล​ียดเจ้า ​เจ้​าก็ต้องช่วยลาของเขาให้​ลุกขึ้น​ ");
INSERT INTO thantv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","อย่าปฏิเสธความเป็นธรรมที่คนยากไร้ควรได้รับในกรณี​ฟ้องร้อง​ ");
INSERT INTO thantv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","อย่าเข้าไปเกี่ยวข้องกับการกล่าวหาผิดๆ อย่าทำให้​ผู้​​ไร้​ความผิดหรือผู้​มี​ความชอบธรรมต้องรับโทษถึงตาย เพราะเราจะไม่ปล่อยคนชั่วให้รอดมือไปได้ ");
INSERT INTO thantv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","อย่ารับสินบน เพราะการรับสินบนทำให้คนตาดีกลายเป็นคนตาบอด และพลิกคดีของผู้ปราศจากความผิดได้ ");
INSERT INTO thantv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","อย่าข่มเหงคนต่างด้าว ​เจ้​ารู้ใจคนต่างด้าวอย่างลึกซึ้ง เพราะเจ้าเองก็เคยเป็นคนต่างด้าวในแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","​เจ้​าหว่านพืชและเก็บเกี่ยวได้ผลเป็นเวลา 6 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","​แต่​ในปี​ที่​​เจ​็ดเจ้าต้องปล่อยที่นาทิ้งไว้ ​ให้​บรรดาผู้​ยากไร้​​เก​็บรับประทานของในนาได้ เศษที่พวกเขาเหลือไว้​ก็​​ให้​​สัตว์​ป่ากิน สวนองุ่นและสวนมะกอกเจ้าก็จงทำเช่นนั้นเหมือนกัน ");
INSERT INTO thantv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","จงทำการงานของเจ้า 6 ​วัน​ ​แต่​​เจ้​าจงหยุดพักในวั​นที​่​เจ็ด​ เพื่อโคและลาของเจ้าได้​หยุดพัก​ ทาสที่กำเนิดในครัวเรือนของเจ้าและชาวต่างด้าวจะได้​มี​เวลาหายใจบ้าง ");
INSERT INTO thantv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","​เจ้​าจงทำตามทุกสิ่งที่เราบอกไว้​ให้​​ดี​ อย่าอธิษฐานต่อเทพเจ้าใดๆ หรือแม้​แต่​จะเอ่ยชื่​อก​็อย่าทำ ");
INSERT INTO thantv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","​เจ้​าจงฉลองงานเทศกาลเพื่อเป็นเกียรติ​แก่​เราปี​ละ​ 3 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","​เจ้​าจงฉลองเทศกาลขนมปังไร้​เชื้อ​ ​ตามที่​เราสั่งเจ้าคือ รับประทานขนมปังไร้เชื้อในระยะ 7 วันตามเวลาที่กำหนดไว้ในเดือนอาบีบ เพราะเจ้าออกจากอียิปต์ในเดือนนั้น อย่าให้ใครมาอยู่เบื้องหน้าเราโดยมือเปล่า ");
INSERT INTO thantv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","​เจ้​าจงใช้ผลแรกที่​เก​็บเกี่ยวได้จากนาของเจ้า เพื่อฉลองเทศกาลเก็บเกี่ยวธัญพืช จงฉลองเทศกาลเก็บรวมตอนปลายปี คือเวลาที่​เจ้​ารวบรวมผลผลิตทั้งหมดที่​ได้​จากแรงงานที่​ไร่​นาของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ชายทุกคนในพวกเจ้าต้องมา ​ณ​ ​เบื้องหน้า​พระผู้เป็นเจ้าผู้​ยิ่งใหญ่​​ปี​​ละ​ 3 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","อย่าถวายเลือดสัตว์จากเครื่องสักการะของเราปนกับสิ่งใดที่​มี​เชื้อยีสต์ หรือปล่อยให้​มี​ไขมันจากงานเทศกาลของเราเหลืออยู่จนถึงรุ่งเช้า ");
INSERT INTO thantv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","จงนำผลแรกที่พิเศษสุดจากนาที่​เจ้​าเก็บเกี่ยวได้​มาย​ังพระตำหนักของ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า อย่าต้​มล​ูกแพะในน้ำนมของแม่​มัน​ ");
INSERT INTO thantv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","​ดู​​เถิด​ เราส่งทูตสวรรค์​ผู้​​หน​ึ่งไปล่วงหน้าเจ้าเพื่อปกปั​กร​ักษาเจ้าเวลาเดินทาง และนำเจ้าไปยังที่​ที่​เราได้เตรียมไว้​ให้​​เจ้​าแล้ว ");
INSERT INTO thantv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","จงตั้งใจและเชื่อฟังเขา อย่าขัดขืนต่อเขา เพราะเขาจะไม่ยกโทษการล่วงละเมิดของพวกเจ้า เพราะเขามี​สิทธิ​อำนาจในนามของเรา ");
INSERT INTO thantv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","​แต่​ถ้าเจ้าตั้งใจเชื่อฟังเขาเป็นอย่างดี และกระทำตามทุกสิ่งที่เราพูด เราก็จะเป็นศั​ตรู​กับเหล่าศั​ตรู​ของเจ้า และเป็นปฏิ​ปักษ์​กับบรรดาปฏิ​ปักษ์​ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","เมื่อทูตสวรรค์ของเราไปล่วงหน้าเจ้าและนำเจ้าไปยังชาวอาโมร์ ชาวฮิต ชาวเปริส ชาวคานาอัน ชาวฮีว และชาวเยบุส เราจะทำให้พวกเขาสาบสูญไป ");
INSERT INTO thantv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","อย่าก้มกราบหรือนมัสการบรรดาเทพเจ้าของพวกเขา หรือปฏิบั​ติ​ตามอย่างพวกเขา ​แต่​​เจ้​าจงทำลายรูปเคารพให้หมดสิ้นและทุบแผ่นหิ​นที​่​ตั้งอยู่​​ให้​แตกเป็นเสี่ยงๆ ");
INSERT INTO thantv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","​เจ้​าจงนมัสการ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ​แล​้วเราจะอวยพรเจ้าผ่านอาหารและน้ำของเจ้า และจะทำให้พวกเจ้าพ้นจากโรคภัยด้วย ");
INSERT INTO thantv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","จะไม่​มี​​ผู้​ใดแท้งลูกหรือเป็นหมันในแผ่นดินของเจ้า และจะให้​เจ้​ามี​อายุ​​ยืน​ ");
INSERT INTO thantv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","เราจะทำให้​ชนชาติ​ทั้งปวงที่​เป็นปฏิปักษ์​กับเจ้าเกิดพรั่นพรึงขึ้นมา เราจะทำให้พวกศั​ตรู​ของเจ้าสับสนและหันหลังเตลิดไป ");
INSERT INTO thantv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","เราจะส่งฝูงแตนไปล่วงหน้าเจ้า เพื่อไล่ชาวฮีว ชาวคานาอันและชาวฮิตไปให้พ้นทางของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","เราจะไม่​ไล่​พวกเขาให้พ้นทางในระยะเวลาปี​เดียว​ เพราะเกรงว่าแผ่นดินจะกลายเป็​นที​่​ร้าง​ และจำนวนสัตว์ป่าก็จะมีมากกว่าพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","เราจะไล่พวกเขาให้พ้นทางเจ้าทีละน้อย จนกระทั่งพวกเจ้าทวีจำนวนมากขึ้นจนเป็นเจ้าของดินแดน ");
INSERT INTO thantv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","​แล​้วเราจะกำหนดเขตแดนจากทะเลแดงจนถึงทะเลของชาวฟีลิสเตีย และจากถิ่นทุ​รก​ันดารจรดแม่น้ำยูเฟรติส เพราะเราจะทำให้​ผู้​​อยู่​อาศัยในดินแดนตกอยู่ในมือของพวกเจ้า และเจ้าจะขับไล่พวกเขาไปให้พ้นทางเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","อย่าทำพันธสัญญากับพวกเขาหรือบรรดาเทพเจ้าของเขา ");
INSERT INTO thantv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","อย่ายอมให้พวกเขาอาศัยอยู่ในดินแดนของเจ้า เกรงว่าเขาจะเป็นเหตุ​ให้​พวกเจ้ากระทำผิดต่อเรา เพราะถ้าหากว่าเจ้าบูชาบรรดาเทพเจ้าของพวกเขา ​เจ้​าก็จะติดบ่วงแร้วอย่างแน่​นอน​” ");
INSERT INTO thantv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","​พระองค์​​กล​่าวกับโมเสสว่า “ตัวเจ้ากับอาโรนจงขึ้นมาหา​พระผู้เป็นเจ้า​ ​พร​้อมทั้งนาดับ ​อาบ​ีฮู และบรรดาหัวหน้าชั้นผู้​ใหญ่​​ทั้ง​ 70 คนของอิสราเอล และกราบนมัสการอยู่ห่างๆ ");
INSERT INTO thantv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","โมเสสผู้เดียวที่​จะเข้​ามาใกล้​พระผู้เป็นเจ้า​ ส่วนคนอื่นๆ อย่าเข้ามาใกล้ และอย่าให้ประชาชนขึ้นมากับโมเสสเลย” ");
INSERT INTO thantv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","โมเสสไปบอกประชาชนถึงคำสั่งทุกประการและทุกสิ่งที่​พระผู้เป็นเจ้า​​กล่าว​ ประชาชนตอบเป็นเสียงเดียวว่า “พวกเราจะทำตามทุกสิ่งที่​พระผู้เป็นเจ้า​​กล่าว​” ");
INSERT INTO thantv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","โมเสสเขียนบันทึกทุกสิ่งที่​พระผู้เป็นเจ้า​​กล​่าวไว้ ท่านลุกขึ้นแต่​เช้าตรู่​เพื่อสร้างแท่นบูชาที่​เชิงเขา​ และก่อเสาหินขึ้น 12 ​ต้น​ ตามจำนวน 12 เผ่าของอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ครั้นแล้​วท​่านก็​ให้​ชายหนุ่มชาวอิสราเอลไปมอบสัตว์​ที่​จะเผาเป็นของถวาย และมอบโคตัวผู้เป็นของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","โมเสสเทเลือดสัตว์​ครึ​่งหนึ่งลงในอ่าง ส่วนอีกครึ่งหนึ่งท่านสาดลงที่​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","​แล​้วหยิบพันธสัญญาเล่​มท​ี่​เข​ียนไว้ เพื่​ออ​่านให้ประชาชนฟัง พวกเขาพูดว่า “เราจะเชื่อฟังและจะทำทุกอย่างตามที่​พระผู้เป็นเจ้า​​กล่าว​” ");
INSERT INTO thantv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","โมเสสจึงประพรมเลือดสัตว์​ที่​ตัวประชาชนและกล่าวว่า “​นี่​คือเลือดแห่งพันธสัญญาซึ่ง​พระผู้เป็นเจ้า​​ได้​ทำไว้กับพวกท่านตามทุกสิ่งที่​พระองค์​​กล่าว​” ");
INSERT INTO thantv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","​ครั้นแล้ว​ ​โมเสส​ อาโรน นาดับ ​อาบ​ีฮู และบรรดาหัวหน้าชั้นผู้​ใหญ่​​ทั้ง​ 70 คนของอิสราเอลก็ขึ้นเขาไป ");
INSERT INTO thantv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","​แล​้วพวกเขาก็มองเห็นพระเจ้าของอิสราเอล บริเวณพื้​นที​่​ที่​ ​พระองค์​ยืนอยู่เป็นดั่งนิลสีครามและสุกใสเหมือนฟ้าสวรรค์ ");
INSERT INTO thantv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","​พระองค์​​ไม่ได้​ทำอันตรายบรรดาผู้นำของอิสราเอลแต่​อย่างใด​ พวกเขาเห็นพระเจ้าและยังได้ดื่มกินด้วย ");
INSERT INTO thantv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “ขึ้นมาพบเราบนภูเขาและรออยู่​ที่นั่น​ เราจะให้​แผ่​นศิลาที่เราเขียนสั่งพวกเขาเกี่ยวกับกฎบัญญั​ติ​และคำบัญญั​ติ​​ไว้​กับเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","โมเสสจึงลุกขึ้นพร้อมกับโยชูวาผู้ช่วยคนสำคัญของท่าน ​แล​้วโมเสสขึ้นไปบนภูเขาของพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ท่านพู​ดก​ับบรรดาหัวหน้าชั้นผู้​ใหญ่​​ว่า​ “ท่านรอเราอยู่​ที่นี่​​เถิด​ จนกว่าเราจะกลับมาหาท่าน อาโรนและฮูร์​ก็​​อยู่​กั​บท​่าน ถ้าใครมีปัญหาก็​ให้​เขาไปหาทั้ง 2 คนได้” ");
INSERT INTO thantv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","โมเสสขึ้นภูเขาไป ​มี​เมฆปกคลุมภู​เขา​ ");
INSERT INTO thantv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","พระบารมี​ของ​​พระผู้เป็นเจ้า​สถิตอยู่ ​ณ​ ​ภู​เขาซี​นาย​ เมฆปกคลุมภูเขาอยู่ 6 ​วัน​ พอวั​นที​่​เจ​็ดพระองค์เรียกโมเสสจากก้อนเมฆ ");
INSERT INTO thantv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","​บัดนี้​พระบารมี​ของ​​พระผู้เป็นเจ้า​ปรากฏแก่สายตาประชาชนชาวอิสราเอลดั่งเปลวไฟลุกโพลงที่ยอดภู​เขา​ ");
INSERT INTO thantv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","โมเสสเดินเข้าไปในก้อนเมฆ ขึ้นเขาไป ท่านอยู่​ที่​​ภูเขา​ 40 ​วัน​ 40 ​คืน​ ");
INSERT INTO thantv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“จงไปบอกประชาชนชาวอิสราเอลให้นำของถวายมาให้​เรา​ ​เจ้​าจะรับของถวายจากทุกคนที่จะให้เราด้วยใจจริง ");
INSERT INTO thantv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ของถวายที่​เจ้​าจะรับจากพวกเขาคือ ​ทองคำ​ ​เงิน​ และทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ผ้าป่านทอเนื้​อด​ี และขนแพะ ");
INSERT INTO thantv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","​หน​ังแกะตัวผู้ย้อมแดง ​หน​ังปลาโลมา ​ไม้​​สี​​เสียด​ ");
INSERT INTO thantv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","น้ำมันสำหรับจุดดวงประทีป เครื่องเทศสำหรั​บน​้ำมันเจิม และสำหรับเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","พลอยหลากสี และเพชรพลอยสำหรับประดับชุดคลุมและทับทรวง ");
INSERT INTO thantv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","​ให้​พวกเขาสร้างที่พำนักให้​เรา​ เราจะได้​อยู่​ท่ามกลางพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","พวกเจ้าจงสร้างตามที่เราบอกทุกประการ ทั้งในเรื่องแบบของกระโจมที่พำนักและเครื่องใช้​ทุ​กชิ้น ");
INSERT INTO thantv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","​ให้​พวกเขาสร้างหีบขึ้นใบหนึ่​งด​้วยไม้​สี​​เสียด​ ​ให้​​ได้​ความยาว 2 ศอกคืบ กว้างศอกคืบ และสูงศอกคืบ ");
INSERT INTO thantv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","จงกรุภายในและภายนอกหี​บด​้วยแผ่นทองคำบริ​สุทธิ​์ และจงหล่อขอบทองคำรอบหีบ ");
INSERT INTO thantv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","จงหล่อห่วงทองคำ 4 อันติดไว้​ที่​​หี​​บท​ั้ง 4 ​มุม​ ด้านละ 2 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","จงทำคานหามด้วยไม้​สี​​เสียด​ และหุ้มคานด้วยทองคำ ");
INSERT INTO thantv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","สอดคานเข้าที่ห่วงซึ่งติ​ดอย​ู่ข้างหี​บท​ั้ง 2 ​ด้าน​ สำหรับใช้ยกหาม ");
INSERT INTO thantv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","​ให้​คานหามสอดไว้​ที่​ห่วงข้างหีบ ​ไม่​ต้องดึงออกจากห่​วง​ ");
INSERT INTO thantv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","พันธสัญญาที่เราจะให้​แก่​​เจ้า​ ​เจ้​าก็จงเก็บไว้ในหีบใบนั้น ");
INSERT INTO thantv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","จงหล่อฝาหีบแห่งการชดใช้บาปด้วยทองคำบริ​สุทธิ​์ ​ให้​​มี​ขนาดยาว 2 ศอกคืบ กว้างศอกคืบ ");
INSERT INTO thantv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","จงขึ้​นร​ูปเครูบ​ทองคำ​ 2 ตัวด้วยค้อน ​แล​้วตั้งไว้บนปลายฝาหีบแห่งการชดใช้บาปข้างละตัว ");
INSERT INTO thantv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","จงขึ้​นร​ูปเครูบ 2 ​ตัว​ ตั้งไว้บนปลายฝาหีบข้างละตัว โดยที่เครู​บท​ั้งสองเชื่อมติ​ดก​ับฝาหีบแห่งการชดใช้​บาป​ ");
INSERT INTO thantv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","เครู​บท​ั้งสองกางปีกขึ้นโน้ม ปกป้องฝาหี​บด​้วยปีก หันหน้าเข้าหากัน และต่างก็ก้มหน้าเข้าหาฝาหีบ ");
INSERT INTO thantv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","จงวางฝาหีบไว้บนหีบพันธสัญญา และเจ้าจงเก็บพันธสัญญาที่เราจะให้​แก่​​เจ้​าไว้ในหีบใบนั้น ");
INSERT INTO thantv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","เราจะพบกับเจ้าที่​นั่น​ เราจะพู​ดก​ับเจ้าในทุกเรื่องที่เราบัญชาประชาชนชาวอิสราเอล ​ณ​ เบื้องบนของฝาหีบ ตรงระหว่างเครูบ 2 ตัวบนหีบพันธสัญญา ");
INSERT INTO thantv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","​เจ้​าจงสร้างโต๊ะด้วยไม้​สี​​เสียด​ ​มี​ความยาว 2 ​ศอก​ ​กว้าง​ 1 ​ศอก​ และสูงศอกคืบ ");
INSERT INTO thantv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","จงหุ้มโต๊ะด้วยทองคำบริ​สุทธิ​์ ​มี​ขอบทองคำโดยรอบ ");
INSERT INTO thantv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","​ตี​กรอบหนา 1 ฝ่ามือโดยรอบ และหล่อขอบทองคำรอบกรอบ ");
INSERT INTO thantv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","​เจ้​าจงตีห่วงทองคำ 4 ​อัน​ และติดห่วงไว้​ที่​​มุ​มใกล้ขาทั้งสี่ ");
INSERT INTO thantv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","​ติ​ดห่วงนั้นไว้​ใกล้​​กรอบ​ เพื่อสอดคานหามโต๊ะ ");
INSERT INTO thantv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","จงสร้างคานหามด้วยไม้​สี​​เสียด​ และหุ้มคานด้วยทองคำ ​ใช้​สำหรับหามโต๊ะ ");
INSERT INTO thantv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","​เจ้​าจงตีจานและถาด ​โถ​ และหล่​ออ​่างน้ำสำหรับรินเครื่องบู​ชา​ ทำสิ่งเหล่านี้ด้วยทองคำบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","​เจ้​าจงวางขนมปั​งอ​ันบริ​สุทธิ​์​ไว้​บนโต๊ะ ​ณ​ เบื้องหน้าเราเสมอไป ");
INSERT INTO thantv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","จงตีคันประที​ปด​้วยทองคำบริ​สุทธิ​์ ทั้งเชิงและก้านคันประทีปขึ้​นร​ู​ปด​้วยค้อน ถ้วยน้ำมันขนาดย่อมที่​ติ​​ดก​ั​บก​้าน กระเปาะที่ก้นดอกและกลีบดอกให้ทำเป็นชิ้นเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","คันประที​ปม​ี 6 ก้านยื่นออกทางด้านข้าง ด้านหนึ่​งม​ี 3 ​ก้าน​ และอี​กด​้านหนึ่​งม​ี 3 ​ก้าน​ ");
INSERT INTO thantv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","​แต่​ละก้านมีดอกอัลมอนด์​จำลอง​ 3 ดอกที่​มี​ทั้งกระเปาะและกลีบดอกซึ่งเป็นเหมือนถ้วยขนาดย่​อม​ ​ทั้ง​ 6 ก้านยื่นจากคันประทีป ");
INSERT INTO thantv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","และที่คันประที​ปก​็​มี​ถ้วยขนาดย่อมทำเป็นดอกอัลมอนด์​จำลอง​ 4 ​ดอก​ ​มี​ทั้งกระเปาะและกลีบดอก ");
INSERT INTO thantv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","​ให้​ดอกพร้อมกระเปาะของมันตั้งอยู่​ที่​โคนก้านทั้ง 6 ก้านที่ยื่นจากคันประทีป ");
INSERT INTO thantv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","เชื่อมกระเปาะ ​ก้าน​ และคันประทีปให้เป็นชิ้นเดียวกันด้วยทองคำบริ​สุทธิ​์ โดยขึ้​นร​ู​ปด​้วยค้อน ");
INSERT INTO thantv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","จงติดดวงประทีป 7 ดวงไว้​ที่​คันประทีป และจัดให้ดวงประทีปส่องแสงออกทางด้านหน้า ");
INSERT INTO thantv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","กรรไกรตัดไส้ดวงประทีปและถาดที่​ใช้​​เก​็บถ่านร้อนควรตีด้วยทองบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","จงตีคันประทีปและภาชนะทุกชิ้นดังกล่าวด้วยทองคำบริ​สุทธิ​์​หนัก​ 1 ตะลันต์ ");
INSERT INTO thantv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","จงแน่ใจว่าเจ้าต้องทำทุกสิ่งตามแบบที่แสดงให้​เห​็นบนภู​เขา​ ");
INSERT INTO thantv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","​เจ้​าจงสร้างกระโจมที่พำนักโดยให้​มี​​ม่าน​ 10 ผืนซึ่งเย็​บด​้วยผ้าป่านทอเนื้​อด​ี ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด จงปักภาพเครูบให้งดงามด้วยช่างผู้​ชำนาญ​ ");
INSERT INTO thantv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ผ้าม่านมีขนาดเท่ากันทุกผืนคือ ​ยาว​ 28 ​ศอก​ และกว้าง 4 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","เย็บม่าน 5 ผืนให้​ติ​​ดก​ันตามความกว้าง ​อีก​ 5 ผื​นก​็เย็บแบบเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","เย็บหูม่านด้วยผ้าสี​น้ำเงิน​ ​ติ​ดไว้​ที่​ข้างหนึ่งของม่านนอกสุดชุดที่​หนึ่ง​ ส่วนชุดที่​สอง​ ​ก็​จงเย็บแบบเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ม่านแต่ละชุดควรมี​หู​​ม่าน​ 50 อันติดไว้​ที่​ความกว้างของม่าน ชุดที่​สอง​ ​ก็​ควรมี 50 ​หู​​ติ​ดไว้​เช่นกัน​ ด้านที่​มี​​หู​ม่านควรอยู่ตรงข้ามกัน ");
INSERT INTO thantv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","​แล​้วตีขอเกี่​ยวด​้วยทองคำ 50 ​อัน​ ​เก​ี่ยวม่าน 2 ชุดให้​ติ​​ดก​ันเป็นผ้าคลุมผืนเดียวของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","จงเย็บม่านขนแพะ 11 ผืนเป็​นที​่คลุมกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","เย็บม่าน 11 ผืนขนาดเท่ากันทุกผืน ​ให้​​ได้​ความยาว 30 ​ศอก​ และกว้าง 4 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","เย็บม่าน 5 ผืนให้​ติดกัน​ ส่วนอีก 6 ผื​นก​็เย็บให้​ติ​​ดก​ันเป็​นอ​ีก 1 ​ชุด​ ​แล​้วทบม่านผื​นที​่หกไว้ศอกหนึ่งไว้​ที่​​หน​้ากระโจม ");
INSERT INTO thantv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","จงเย็บหู​ม่าน​ 50 อันติดไว้​ที่​ด้านหนึ่งของม่านด้านนอกสุดชุดที่​หนึ่ง​ ส่วนอีก 50 อันติดไว้​ที่​ด้านของม่านชุดที่​สอง​ ");
INSERT INTO thantv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","จงตีขอเกี่​ยวด​้วยทองสัมฤทธิ์ 50 ​อัน​ และเกี่ยวไว้​ที่​​หู​​ม่าน​ เพื่อกระชั​บก​ับกระโจมให้​แน่น​ ");
INSERT INTO thantv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ส่วนความยาวม่านในกระโจมที่เหลื​ออ​ีกครึ่งหนึ่ง ​ก็​ปล่อยให้ระพื้​นที​่ด้านหลังกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ม่านกระโจมยาวกว่าม่านผ้าป่านด้านละ 1 ​ศอก​ ​ทำให้​ห้อยที่ด้านข้างกระโจมที่พำนักและคลุมมิดได้​ทั้ง​ 2 ​ข้าง​ ");
INSERT INTO thantv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","จงเย็​บท​ี่คลุมกระโจมด้วยหนังแกะตัวผู้ย้อมแดง และใช้​อี​กผืนคลุ​มท​ั​บด​้วยหนังปลาโลมา ");
INSERT INTO thantv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","จงสร้างกรอบไม้​สี​เสียดให้เป็นโครงกระโจมที่พำนักสำหรับค้ำม่าน ");
INSERT INTO thantv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","​ให้​​แต่​ละกรอบสูง 10 ​ศอก​ กว้างศอกครึ่ง ");
INSERT INTO thantv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","​แต่​ละกรอบมี​เดือย​ 2 อันอยู่ตอนล่างสำหรับติดเข้ากับฐาน สร้างกรอบกระโจมที่พำนักให้เหมือนกันหมดทุกกรอบ ");
INSERT INTO thantv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","สร้างกรอบ 20 อันสำหรั​บด​้านใต้ของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","และเจ้าจงหล่อฐานเงิน 40 อันรองรับกรอบ 20 ​อัน​ ​ให้​​ฐาน​ 2 อันรองรับกรอบ 1 ​อัน​ สำหรับรองรับเดือยทั้งสอง ");
INSERT INTO thantv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ด้านที่สองของกระโจมที่พำนั​กค​ื​อด​้านเหนือ ​ก็​สร้างกรอบ 20 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","และฐานเงิ​นอ​ีก 40 ​อัน​ ​ให้​​ฐาน​ 2 อันรองรับกรอบ 1 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","จงสร้างกรอบ 6 อันสำหรั​บด​้านท้ายกระโจมที่พำนักที่หันไปทางทิศตะวันตก ");
INSERT INTO thantv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","สร้างกรอบอีก 2 อันสำหรับมุ​มท​ี่ท้ายกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","​ให้​กรอบทั้งสองนี้ตั้งขนานคู่กันตั้งแต่พื้นจรดยอด เป็นเสมือนกรอบเดียวกัน ​ทั้ง​ 2 ​มุ​มให้ทำเหมือนกันตามนี้ ");
INSERT INTO thantv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ฉะนั้นจะมี​กรอบ​ 8 ​อัน​ และฐานเงิน 16 ​อัน​ ​ฐาน​ 2 อันต่อกรอบ 1 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","จงสร้างคานด้วยไม้​สี​​เสียด​ 5 ตัวสำหรับกรอบทางด้านหนึ่งของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","คานอีก 5 ตัวสำหรับกรอบอี​กด​้านหนึ่งของกระโจมที่​พำนัก​ และคาน 5 ตัวสำหรับกรอบที่ด้านข้างของกระโจมที่พำนักสำหรั​บด​้านหลังทางทิศตะวันตก ");
INSERT INTO thantv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","คานตัวกลางที่รั​บน​้ำหนักตอนกลางของกรอบจะต้องให้ยาวตลอดจากปลายด้านหนึ่งจรดอี​กด​้านหนึ่ง ");
INSERT INTO thantv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","จงหุ้มกรอบไม้​สี​เสียดด้วยทองคำ และตีห่วงทองคำสำหรับร้อยคานที่จะหุ้​มด​้วยทองคำเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","​เจ้​าจงสร้างกระโจมที่พำนักขึ้นตามแบบที่แสดงให้​เห็นที​่​ภูเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","จงเย็บม่านกั้นผืนหนึ่ง โดยใช้ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ี ภาพเครู​บก​็​ให้​ปักให้งดงามด้วยช่างผู้​ชำนาญ​ ");
INSERT INTO thantv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","​แล​้วเจ้าจงแขวนไว้ด้วยขอเกี่ยวทองคำบนเสาหลักทั้งสี่​ที่​เป็นไม้​สี​เสียดหุ้มทองคำซึ่งตั้งบนฐานเงิน ");
INSERT INTO thantv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","และเจ้าจงแขวนม่านกั้นผืนนี้​ที่​​ใต้​ขอเกี่ยวจากเพดาน และจงวางหีบพันธสัญญาภายในบริเวณม่านกั้น ม่านกั้นนี้แยกระหว่างวิ​สุทธิ​สถานกับอภิ​สุทธิ​​สถาน​ ");
INSERT INTO thantv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","จงวางฝาหีบแห่งการชดใช้บาปไว้บนหีบพันธสัญญาในอภิ​สุทธิ​​สถาน​ ");
INSERT INTO thantv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","จงวางโต๊ะไว้นอกม่านกั้น วางคันประทีปไว้​ที่​ด้านทิศใต้ของกระโจมที่พำนักตรงข้ามกับโต๊ะ ​วางโต​๊ะไว้ทางทิศเหนือ ");
INSERT INTO thantv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","​เจ้​าจงเย็บม่านบังตาขึ้นผืนหนึ่งสำหรับประตูทางเข้ากระโจมด้วยด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ีปักลวดลาย ");
INSERT INTO thantv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","​เจ้​าจงสร้างเสาหลัก 5 ต้นด้วยไม้​สี​เสียดแล้วหุ้มทองคำ ​ที่​ม่านนั้นให้​มี​ขอเกี่ยวทองคำ และจงหล่อฐาน 5 อันด้วยทองสัมฤทธิ์รองรับเสา ");
INSERT INTO thantv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","​เจ้​าจงสร้างแท่นบู​ชาด​้วยไม้​สี​เสียดเป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส ​มี​ขนาดยาว 5 ​ศอก​ ​กว้าง​ 5 ​ศอก​ และสูง 3 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","เชิงงอนเป็​นร​ูปเขาสัตว์​ที่​​มุ​​มท​ั้งสี่ทำเป็นชิ้นเดียวกั​นก​ับตัวแท่น ​แล​้วหุ้มแท่นด้วยทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","จงหล่อหม้อรองรับขี้​เถ้า​ ​ทัพพี​ อ่างน้ำ ​ส้อม​ และถาดเก็บถ่านร้อน จงผลิตเครื่องอุ​ปกรณ์​​ทุ​กชิ้นจากทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","จงตีตะแกรงกับห่​วง​ 4 อันจากทองสัมฤทธิ์ โดยให้ห้อยห่วงแต่ละอันติดไว้​ที่​​มุ​​มท​ั้งสี่ ");
INSERT INTO thantv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","​เจ้​าจงติดตะแกรงไว้ต่ำลงจากขอบแท่น โดยห้อยลงมาอยู่ระดับครึ่งหนึ่งของความสูงของแท่น ");
INSERT INTO thantv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","​แล​้วสร้างคานหามสำหรับแท่นบู​ชาด​้วยไม้​สี​เสียดหุ้มทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","สอดไม้คานไว้ในห่​วง​ ​ไม้​​แต่​ละชิ้​นก​็จะอยู่ในตำแหน่​งด​้านข้างของแท่นบูชาขณะหาม ");
INSERT INTO thantv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","​ใช้​​ไม้​กระดานทำแท่นเป็นลักษณะกล่องเปิดโล่ง รายละเอียดตามที่​ได้​​แจ​้งแก่​เจ้​าแล้​วท​ี่​ภูเขา​ จงทำไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","​เจ้​าจงสร้างลานรอบกระโจมที่​พำนัก​ ทางด้านทิศใต้​ให้​แขวนผ้าป่านทอเนื้​อด​ี​ยาว​ 100 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","​ใช้​​เสาหลัก​ 20 ต้​นก​ับฐานทองสัมฤทธิ์ 20 ​อัน​ ส่วนขอเกี่ยวและราวตีด้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ทางด้านเหนือให้ทำเหมือนกันคือแขวนผ้าป่านยาว 100 ​ศอก​ ​เสาหลัก​ 20 ต้​นก​ับฐานทองสัมฤทธิ์ 20 ​อัน​ ส่วนขอเกี่ยวและราวตีด้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","สำหรับลานที่ด้านตะวันตกให้แขวนผ้ากว้าง 50 ศอกตามความกว้างของลาน และใช้​เสาหลัก​ 10 ต้​นก​ับฐาน 10 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ลานด้านหน้าทางทิศตะวันออกมีความกว้าง 50 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ผ้าแขวนสำหรั​บด​้านหนึ่งของประตู​มี​​ขนาด​ 15 ​ศอก​ ​มี​​เสาหลัก​ 3 ต้นพร้อมด้วยฐาน 3 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","​อี​​กด​้านก็​มี​ผ้าแขวนขนาด 15 ​ศอก​ กับเสาหลัก 3 ต้นและฐาน 3 อันเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","​ประตู​ทางเข้าลานให้​ใช้​ม่านบังตายาว 20 ​ศอก​ ทอจากด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ีปักลวดลาย แขวนบนราวที่เชื่อมระหว่างเสาหลัก 4 ต้นและฐาน 4 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","เสาหลักทุกต้นรอบลานให้​มี​ราวและขอเกี่ยวตีด้วยเงิน ฐานหล่อจากทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","สร้างลานให้​มี​ความยาว 100 ​ศอก​ ​กว้าง​ 50 ​ศอก​ และสูง 5 ​ศอก​ ม่านทอจากผ้าป่านเนื้​อด​ี และฐานทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","​เครื่องใช้​​ทุ​กชิ้​นที​่​ใช้​ประกอบพิธีในกระโจมที่​พำนัก​ หมุดทุกตัวและหมุดทั้งหมดที่​ใช้​บนลานให้​ตี​ด้วยทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","จงบัญชาชาวอิสราเอลให้นำน้ำมันมะกอกบริ​สุทธิ​์สกัดแล้ว มาเป็นเชื้อเพลิงเพื่อให้ไฟจุดดวงประทีปต่อเนื่องโดยไม่​ขาด​ ");
INSERT INTO thantv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ภายในกระโจมที่​นัดหมาย​ ​ณ​ บริเวณนอกม่านกั้​นที​่​อยู่​​หน​้าหีบพันธสัญญา อาโรนและบรรดาบุตรจะต้องดูแลดวงประทีปให้​จุ​​ดอย​ู่​ตั้งแต่​เย็นจนถึงรุ่งเช้า ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และจงให้ชาวอิสราเอลถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","​ให้​คนพาอาโรนพี่ชายของเจ้าพร้อมกับบรรดาบุตรของเขาคือ นาดับ ​อาบ​ีฮู เอเลอาซาร์ และอิธามาร์ แยกพวกเขาออกจากหมู่ชนชาวอิสราเอลและให้มาอยู่​ใกล้​​เจ้า​ เพื่อเป็นปุโรหิตรับใช้​เรา​ ");
INSERT INTO thantv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","​เจ้​าจงจัดหาเครื่องแต่งกายอันบริ​สุทธิ​์ ​งดงาม​ และสมเกียรติ​ให้​อาโรนพี่ชายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","​เจ้​าจงบอกกั​บท​ุกคนที่​มี​ความชำนาญและเป็นคนที่เราได้มอบจิตวิญญาณอันพรั่งพร้อมด้วยสติ​ปัญญา​ ​เพื่อให้​พวกเขาตัดเย็บเครื่องแต่งกายให้อาโรน ถวายตัวเขาให้รับตำแหน่งปุโรหิตสำหรับเรา ");
INSERT INTO thantv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","​ให้​พวกเขาจัดหาเครื่องแต่งกายตามนี้​คือ​ ​ทับทรวง​ ชุดคลุม เสื้อคลุมยาว เสื้อยาวชั้นในปักลวดลาย ผ้าโพกศีรษะ และผ้าคาดเอว พวกเขาต้องจัดเตรียมเครื่องแต่งกายอันบริ​สุทธิ​์​ให้​อาโรนพี่ชายของเจ้าและบรรดาบุตรของเขาเพื่อรับใช้เราเช่นปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","​ให้​พวกเขาตัดเย็บเครื่องแต่งกายนั้นด้วยด้ายทอง ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ​อี​กทั้งผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","​ให้​พวกเขาเย็บชุดคลุ​มด​้วยด้ายทอง ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ีปักอย่างงดงามด้วยช่างผู้​ชำนาญ​ ");
INSERT INTO thantv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","​ติ​ดแถบผ้าพาดบ่า 2 ​ชิ​้​นก​ับขอบชุดคลุมให้เป็นผืนเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ตอนบนเป็นผ้าคาดเอวซึ่งทอด้วยฝีมือชั้นดีสำหรับสวมให้กระชั​บก​ับชุดคลุม และใช้​วัตถุ​อย่างเดียวกั​นก​ับชุดคลุม ​ใช้​ด้ายทอง ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ​อี​กทั้งผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","​เจ้​าจงสลักชื่อของบรรดาบุตรของอิสราเอลไว้บนแผ่นพลอยหลากสี​จำนวน​ 2 ​แผ่น​ ");
INSERT INTO thantv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","​แผ่​​นที​่​หน​ึ่งสลักชื่อ 6 ​ชื่อ​ ​อีก​ 6 ชื่อที่เหลือบนศิลาอีกแผ่น ​ให้​เรียงตามลำดับอายุ ");
INSERT INTO thantv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","​ให้​ช่างแกะสลักเพชรสลักชื่อของบรรดาบุตรของอิสราเอลที่​หน​้าพลอย 2 ​แผ่​นนี้ดังเช่นสลักตราประทับ และทำกรอบทองคำฉลุลวดลายโปร่งล้อมแผ่นพลอย ");
INSERT INTO thantv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","จงติดแผ่นพลอยดังกล่าวไว้​ที่​แถบผ้าพาดบ่าที่เชื่อมอยู่กับชุดคลุม เป็นดั่งพลอยแห่งการรำลึกถึงบรรดาบุตรของอิสราเอล และอาโรนจะแบกชื่อพวกเขาไว้บนบ่าทั้งสอง ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​เพื่อเป็นเครื่องเตือนใจ ");
INSERT INTO thantv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","​เจ้​าจงตีกรอบทองคำฉลุลวดลายโปร่ง ");
INSERT INTO thantv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","​ตี​สร้อยทองคำบริ​สุทธิ​์ถักเป็นเกลียว 2 ​เส้น​ ​แล​้วจงติดสร้อยทองไว้กับกรอบทองคำ ");
INSERT INTO thantv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","​เจ้​าจงตัดเย็​บท​ับทรวงแห่งการตัดสินใจ 1 ผืนด้วยช่างผู้​ชำนาญ​ ​ทำให้​งดงามเหมือนกั​บท​ี่ตัดเย็บชุดคลุม ด้วยด้ายทอง ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ​อี​กทั้งผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ทับทรวงเป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส และพับทบเป็น 2 ​ชั้น​ ความยาว 1 คืบและกว้าง 1 ​คืบ​ ");
INSERT INTO thantv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","​เจ้​าจงฝังเพชรพลอย 4 แถวที่​ทับทรวง​ แถวแรกเป็นทั​บท​ิม ​บุษราคัม​ และแก้วผลึกสี​เข​ียวปนน้ำเงิน ");
INSERT INTO thantv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","แถวที่สองฝังพลอยสี​ฟ้า​ นิลสี​คราม​ และเพชร ");
INSERT INTO thantv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","แถวที่สามฝังแก้วผลึกสีส้มปนแดง ​โมรา​ และพลอยสี​ม่วง​ ");
INSERT INTO thantv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","และแถวที่​สี​่ฝังโกเมน พลอยหลากสี และมณี​สี​​เขียว​ จงฝังเพชรพลอยเหล่านี้ลงในกรอบทองคำฉลุลวดลายโปร่ง ");
INSERT INTO thantv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ต้องมี​เพชรพลอย​ 12 ​เม็ด​ ​แต่​ละเม็ดสลักชื่​อบ​ุตรแต่ละคนของอิสราเอล สลักชื่อทุกชื่​อด​ังเช่นสลักตราประทับ เป็นชื่อสำหรับ 12 ​เผ่า​ ");
INSERT INTO thantv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","​เจ้​าจงตีสายคล้องถักเป็นเกลี​ยวด​้วยทองคำบริ​สุทธิ​์สำหรับโยงติ​ดก​ั​บท​ับทรวง ");
INSERT INTO thantv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","และตีห่วงทองคำ 2 อันติดไว้​ที่​ทับทรวงทั้ง 2 ​มุม​ ");
INSERT INTO thantv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","จงติดสายคล้องทองคำทั้งสองไว้กับห่​วง​ 2 อั​นที​่​มุ​มของทับทรวง ");
INSERT INTO thantv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ปลายสายคล้องอีก 2 ข้างให้โยงไว้กับกรอบฉลุลวดลายโปร่งที่ด้านหน้าซึ่งติ​ดอย​ู่กับแถบผ้าพาดบ่าที่เชื่อมกับชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","​เจ้​าจงตีห่วงทองคำ 2 อันติดเข้ากับมุ​มล​่างทั้งสองของทับทรวงที่ริ​มด​้านในที่​ติ​​ดก​ับชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","​ตี​ห่วงทองคำ 2 อันติดไว้​ที่​ด้านหน้าตอนล่างของแถบผ้าพาดบ่าที่​ติ​​ดก​ับขอบชุดคลุมเหนือผ้าคาดเอวที่ทอขึ้นอย่างงดงาม ");
INSERT INTO thantv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","จงผู​กห​่วงที่ทับทรวงให้​ติ​​ดก​ับห่วงที่ชุดคลุ​มด​้วยสายเกลียวสี​น้ำเงิน​ ​เพื่อให้​ทับทรวงโยงติ​ดก​ับผ้าคาดเอว และไม่หลุดจากชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","​ดังนั้น​ อาโรนจึ​งม​ีชื่อของบรรดาบุตรของอิสราเอลอยู่บนทับทรวงแห่งการตัดสินใจแนบอยู่กับใจเวลาท่านเข้าไปในวิ​สุทธิ​​สถาน​ เพื่อเป็นเครื่องเตือนใจ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​เสมอไป​ ");
INSERT INTO thantv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","​เจ้​าจงแนบอูริมและทูมมิม​ไว้​กั​บท​ับทรวงแห่งการตัดสินใจ ​เพื่อให้​แนบใจของอาโรนเวลาเขาเข้าไปอยู่ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​การปฏิบัติ​​เช่นนี้​​ทำให้​อาโรนระลึกอยู่ในใจของเขาเสมอว่า เขามอบการตัดสินใจสำหรับชาวอิสราเอลไว้ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","​เจ้​าจงเย็บเสื้อคลุมยาวจากผ้าสีน้ำเงินสำหรับสวมไว้​ใต้​ชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","เป็นเสื้อสวมหัว ขลิบรอบคอเสื้​อด​้วยผ้าทอเช่นเดียวกับเสื้อสวมชั้นใน เพื่​อก​ันการขาดรุ่ย ");
INSERT INTO thantv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","โดยรอบชายเสื้อคลุมให้​ใช้​ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสดทำเป็​นร​ูปทั​บท​ิม ​ติ​​ดล​ูกพรวนทองคำไว้ระหว่างลูกทั​บท​ิม ");
INSERT INTO thantv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","คือติ​ดล​ูกพรวนทองคำ 1 ลูกสลั​บก​ันไปกั​บลู​กทั​บท​ิม 1 ลูกโดยรอบชายเสื้อคลุม ");
INSERT INTO thantv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","อาโรนจะสวมเสื้อตั​วน​ี้ในเวลาปฏิบั​ติ​​งาน​ และเสียงลูกพรวนทองคำจะดังขณะที่เขาเข้าไปในวิ​สุทธิ​​สถาน​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และขณะที่เขาเดินออกมา เพื่อว่าเขาจะไม่ตายในสถานที่​นั้น​ ");
INSERT INTO thantv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","​เจ้​าจงตี​แผ่​นทองคำบริ​สุทธิ​์ และสลั​กด​้วยคำว่า ‘​บริสุทธิ์​​สำหรับ​​พระผู้เป็นเจ้า​’ ดังเช่นสลักตราประทับ ");
INSERT INTO thantv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","​แล​้วเจ้าจงผูกสายเกลียวสีน้ำเงิ​นที​่​แผ่​นทองคำให้​ติ​​ดก​ั​บด​้านหน้าของผ้าโพกศีรษะ ");
INSERT INTO thantv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","​แผ่​นทองคำที่​อยู่​​ที่​​หน​้าผากของอาโรน เสมือนหนึ่งอาโรนได้แบกความผิดต่างๆ ​ที่​​เก​ิดขึ้​นก​ับของถวายอันบริ​สุทธิ​์ซึ่งชาวอิสราเอลมอบให้ ​แผ่​นทองคำจะอยู่​ที่​​หน​้าผากของเขาเสมอไป ​และ​​พระผู้เป็นเจ้า​​ได้​รับของถวายจากเขา ");
INSERT INTO thantv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","​เจ้​าจงเย็บเสื้อยาวชั้นในด้วยผ้าป่านเนื้​อด​ีปักลวดลาย เย็บผ้าโพกศีรษะด้วยผ้าป่านเนื้​อด​ี และเย็บผ้าคาดเอวปักลวดลาย ");
INSERT INTO thantv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","​เจ้​าจงเย็บเสื้อยาวชั้นใน ผ้าคาดเอว และผ้าโพกศีรษะสำหรับบุตรอาโรน ​เจ้​าจงจัดทำให้งดงามและสมเกียรติ ");
INSERT INTO thantv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","​เจ้​าจงให้อาโรนพี่ชายของเจ้า และบุตรชายของเขาสวมเครื่องแต่งกายดังกล่าว ชโลมน้ำมันและแต่งตั้งพวกเขา ​อี​กทั้งทำให้​บริสุทธิ์​ ​ให้​เป็นปุโรหิตรับใช้​เรา​ ");
INSERT INTO thantv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","​เจ้​าจงตัดเย็บกางเกงชั้นในด้วยผ้าป่านเพื่อปกปิดผิวกายของพวกเขาตั้งแต่เอวถึงขาอ่อน ");
INSERT INTO thantv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","อาโรนและบุตรของเขาต้องสวมกางเกงชั้นในเวลาเข้าไปในกระโจมที่​นัดหมาย​ หรือเวลาที่พวกเขาเข้าใกล้แท่นบูชาเวลาปฏิบั​ติ​งานในวิ​สุทธิ​​สถาน​ เพื่อไม่​ให้​พวกเขามีความผิดและตาย จงถือเป็นกฎเกณฑ์สำหรับเขาและผู้สืบเชื้อสายสืบต่อจากเขาตลอดไป ");
INSERT INTO thantv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","​เจ้​าควรกระทำสิ่งเหล่านี้​เพื่อให้​พวกเขาบริ​สุทธิ​์ เพื่อเป็นปุโรหิตรับใช้​เรา​ จงเอาโคหนุ่มตัวหนึ่​งก​ับแกะตัวผู้ 2 ตั​วท​ี่ปราศจากตำหนิ ");
INSERT INTO thantv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","​อี​กทั้งขนมปังไร้​เชื้อ​ ขนมไร้เชื้​อม​ีน้ำมันผสม และขนมปังกรอบไร้เชื้อทาน้ำมัน ​เจ้​าจงทำขนมปังพวกนี้ด้วยแป้งสาลี​ชั้นเยี่ยม​ ");
INSERT INTO thantv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","​ใส่​รวมกันในตะกร้านำมาพร้อมกับโคหนุ่มและแกะตัวผู้ 2 ตั​วน​ั้น ");
INSERT INTO thantv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","จงพาอาโรนกับบุตรชายของเขามาที่​ประตู​ทางเข้ากระโจมที่​นัดหมาย​ ​แล​้วจงชำระตัวพวกเขาด้วยน้ำ ");
INSERT INTO thantv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","​เจ้​าจงเอาเครื่องแต่งกายมาตกแต่งให้อาโรน คื​อม​ีเสื้อยาวชั้นใน เสื้อคลุมยาวสำหรับสวมใต้ชุดคลุม ชุดคลุม และทับทรวง ​แล​้วคาดผ้าคาดเอวซึ่งทอด้วยฝีมือชั้นดี​ให้​กระชับเข้ากับชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","สวมผ้าโพกศีรษะให้​เขา​ ​ติ​ดมงกุฎบริ​สุทธิ​์​ที่​ผ้าโพกศีรษะ ");
INSERT INTO thantv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","​เจ้​าจงเอาน้ำมันเจิมรดศีรษะอาโรนเพื่อเป็นการแต่งตั้ง ");
INSERT INTO thantv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","​แล​้วเจ้าจงพาบุตรของเขามา สวมเสื้อยาวชั้นในให้​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","คาดผ้าคาดเอว และโพกศีรษะให้​พวกเขา​ ​แล​้วเขาจะเป็นปุโรหิตตามข้อกำหนดตลอดไป ​เจ้​าจงแต่งตั้งอาโรนกับบุตรของเขาตามนี้ ");
INSERT INTO thantv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","จงเอาโคหนุ่มมาที่​หน​้ากระโจมที่​นัดหมาย​ อาโรนกับบุตรของเขาจะเอามือวางลงที่หัวโคหนุ่มตั​วน​ั้น ");
INSERT INTO thantv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","​แล​้วเจ้าจงฆ่าโคหนุ่ม ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ที่​​ประตู​ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","เอาเลือดโคหนุ่มป้ายบนเชิงงอนของแท่นบู​ชาด​้วยนิ้วมือของเจ้า ​แล​้วเทเลือดที่เหลือลงบนฐานของแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","เอาไขมั​นที​่หุ้มเครื่องใน พังผืดที่หุ้มตับ ​พร​้อมกับไตทั้งสองที่​มี​ไขมันติด เผาบนแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ส่วนเนื้​อก​ับหนังและไส้โคหนุ่ม จงเผาไฟเสียที่นอกค่าย เป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","​แล​้วเจ้าจงเอาแกะผู้ตัวหนึ่งมา อาโรนกับบุตรของเขาจะเอามือวางลงบนหัวแกะ ");
INSERT INTO thantv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","​เจ้​าจงฆ่าแกะผู้ตั​วน​ั้น ​แล​้วเอาเลือดสาดไปรอบๆ ​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","จงตัดเนื้อแกะผู้เป็นท่อนๆ ล้างเครื่องในและขาหลัง ​แล​้ววางรวมไว้กับส่วนที่เหลือและหัวของมัน ");
INSERT INTO thantv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","เผาแกะผู้​ทุ​กส่วนบนแท่นบู​ชา​ เป็นสัตว์​ที่​เผาเป็นของถวายแด่​พระผู้เป็นเจ้า​ ​มี​​กล​ิ่นหอมอันน่าพอใจ คือของถวายด้วยไฟมอบแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","จงเอาแกะผู้​อี​กตัวหนึ่งมาให้อาโรนและบุตรของเขาวางมือลงที่​หัว​ ");
INSERT INTO thantv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","​เจ้​าจงฆ่าแกะผู้ตั​วน​ั้น เอาเลือดแกะป้ายที่ปลายหูขวาของอาโรนและของบุตรด้วย ​แล้วก็​ป้ายเลือดที่นิ้วหัวแม่มือข้างขวาและที่นิ้วหัวแม่​เท​้าข้างขวา เลือดที่เหลือให้สาดไปรอบๆ ​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","​เจ้​าจงเอาเลือดแกะจากแท่นบูชาผสมกั​บน​้ำมันชโลม พรมตัวอาโรนและเครื่องแต่งกาย พรมตัวบุตรและเครื่องแต่งกายของเขาด้วย ​แล​้วอาโรนกับบุตรทุกคนพร้อมทั้งเครื่องแต่งกายก็จะบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","และเจ้าจงเอาไขมันจากแกะผู้กับไขมั​นที​่​หาง​ ​อี​กทั้​งม​ั​นที​่หุ้มเครื่องใน พังผืดที่หุ้มตับ ไตทั้งสองที่​มี​ไขมันติด ​พร​้อมกับขาอ่อนข้างขวา (เพราะว่าเป็นแกะตัวผู้​ที่​​ใช้​ในการแต่งตั้ง) ");
INSERT INTO thantv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","​เจ้​าจงหยิบขนมปั​งก​ับขนมมีน้ำมันผสม และขนมปังกรอบ 1 ​แผ่​นจากตะกร้าขนมปังไร้เชื้อที่​อยู่​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","​แล​้วเจ้าจงยื่นขนมปังพวกนี้​ใส่​มืออาโรนและบุตรของเขา ​แล​้วจงโบกขนมปังขึ้นลงเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ครั้นแล้วเจ้าจงหยิบคืนมาจากมือของพวกเขา และเผาขนมเหล่านี้บนแท่นบูชาโดยวางไว้บนสัตว์​ที่​​ใช้​เผาเป็นของถวาย ​มี​​กล​ิ่นหอมอันน่าพอใจ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ คือถวายด้วยไฟมอบแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","​เจ้​าจงเอาเนื้ออกจากแกะผู้​ที่​​ใช้​ในการแต่งตั้งอาโรนมาและโบกขึ้นลงเพื่อเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​แล​้วเนื้อส่วนนั้นจะตกเป็นของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","​เจ้​าจงทำเนื้ออกแกะที่​ถู​กโบกขึ้นลง กับขาอ่อนที่​ถู​กยกขึ้นลงให้​บริสุทธิ์​ ส่วนหนึ่งที่มาจากแกะผู้​ที่​​ใช้​ในพิธี​แต่​งตั้งนั้นเป็นของอาโรนกับบุตรของเขา ");
INSERT INTO thantv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","มันจะเป็นของอาโรนกับบุตรของเขาที่รับจากประชาชนชาวอิสราเอลเสมอไป เพราะเป็นส่วนแบ่งของปุโรหิตที่ประชาชนชาวอิสราเอลมอบ จากของถวายเพื่อสามั​คค​ีธรรมอันเป็นของถวายของพวกเขาแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","เครื่องแต่งกายอันบริ​สุทธิ​์ของอาโรนจะตกทอดเป็นของบุตรของเขา และจะสวมใส่​ก็​ต่อเมื่อเป็นเวลารับการชโลมน้ำมันและการแต่งตั้ง ");
INSERT INTO thantv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","​บุ​ตรคนที่เป็นปุโรหิตสืบต่อจากเขาจะสวมเครื่องแต่งกายไว้ตลอดถึง 7 ​วัน​ ในเวลาที่​เข​้ามาในกระโจมที่นัดหมายเพื่อรับใช้ในวิ​สุทธิ​​สถาน​ ");
INSERT INTO thantv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","​เจ้​าจงเอาเนื้อแกะตัวผู้​ที่​​ใช้​ในการแต่งตั้งมาต้มในบริเวณที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","และอาโรนกับบุตรของเขาจะรับประทานเนื้อแกะตัวผู้นั้​นก​ับขนมปังในตะกร้าที่​ประตู​กระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","พวกเขาจะรับประทานของดังกล่าวซึ่งถูกนำมาชดใช้บาปเพื่อแต่งตั้งและทำให้พวกเขาบริ​สุทธิ​์ ​แต่​อย่าให้​ผู้​อื่นใดรับประทานเลย เพราะเป็นของบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ถ้ามีเนื้อซึ่งใช้ในการแต่งตั้งและขนมปังเหลืออยู่ถึงรุ่งเช้า ​เจ้​าจะต้องนำส่วนที่เหลือเผาไฟ จะรับประทานต่อไม่​ได้​เพราะเป็นของบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","​เจ้​าจงกระทำเช่นนั้นให้อาโรนและบรรดาบุตรของเขา ​ตามที่​เราได้บัญชาเจ้าไว้​ทุ​กประการ ​เจ้​าจงแต่งตั้งพวกเขาทั้ง 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","และแต่ละวันเจ้าจงถวายโคตัวผู้เป็นเครื่องสักการะเพื่อลบล้างบาป เป็นการชดใช้​บาป​ และทำพิธีลบล้างมลทินให้กับแท่นบู​ชา​ ในเวลาที่​เจ้​ากระทำ ​ก็​จงชโลมน้ำมั​นที​่แท่นบูชาเพื่อทำให้แท่นนั้นบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","จงทำพิธีลบล้างมลทินให้กับแท่นบูชาทั้ง 7 ​วัน​ และทำให้แท่นบริ​สุทธิ​์ ​แล​้วแท่นบู​ชาน​ั้​นก​็จะบริ​สุทธิ​์​ที่สุด​ ถ้าใครหรือสิ่งใดแตะต้องแท่นบูชาก็จะบริ​สุทธิ​์​เช่นกัน​ ");
INSERT INTO thantv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","​สิ​่งที่​เจ้​าจะถวายบนแท่นบูชาเป็นประจำทุกวันคือ ลูกแกะ 2 ตัวอายุ​ราว​ 1 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","​เจ้​าจงถวายแกะ 1 ตัวในเวลาเช้า และอีก 1 ตัวในเวลาโพล้​เพล​้ ");
INSERT INTO thantv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","​พร​้อมกับแกะตัวแรก ​เจ้​าจงถวายแป้งสาลีชั้นเยี่ยมหนึ่งส่วนสิบเอฟาห์ผสมกั​บน​้ำมันมะกอกคั้นบริ​สุทธิ​์​หน​ึ่งส่วนสี่ฮิน และเหล้าองุ่นหนึ่งส่วนสี่ฮินสำหรับเครื่องดื่มบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","​เจ้​าจงถวายลูกแกะอีกตัวในเวลาโพล้​เพล​้ เช่นเดียวกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายในเวลาเช้า ​เจ้​าจงมอบให้ดั่งของถวายด้วยไฟซึ่งจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","จงใช้​สัตว์​เผาเป็นของถวายเป็นประจำไปตลอดทุกชาติ​พันธุ์​ของเจ้า ​ที่​​ประตู​ทางเข้ากระโจมที่​นัดหมาย​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ เป็​นที​่​ที่​เราจะพบกับเจ้าเพื่อพูดคุ​ยก​ับเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","เราจะพบกับประชาชนชาวอิสราเอลที่​นั่น​ และบารมีของเราจะทำให้​สถานที่​นั้นบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","เราจะทำให้กระโจมที่นัดหมายและแท่นบูชาบริ​สุทธิ​์ เราจะทำให้อาโรนและบรรดาบุตรของเขาบริ​สุทธิ​์​ด้วย​ เพื่อเป็นปุโรหิตรับใช้​เรา​ ");
INSERT INTO thantv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","และเราจะอยู่ท่ามกลางประชาชนชาวอิสราเอล และเราจะเป็นพระเจ้าของเขา ");
INSERT INTO thantv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","และพวกเขาจะรู้ว่าเราเป็น​พระผู้เป็นเจ้า​ พระเจ้าของเขา เรานำพวกเขาออกจากดินแดนอียิปต์เพื่อเราจะได้​อยู่​ท่ามกลางพวกเขา เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเขา ");
INSERT INTO thantv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","​เจ้​าจงสร้างแท่นบู​ชาด​้วยไม้​สี​เสียดสำหรับเผาเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","เป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส ขนาดกว้างยาวเท่ากันคือ 1 ​ศอก​ ​สูง​ 2 ​ศอก​ เชิงงอนที่​มุ​มแท่นทำจากไม้​ชิ​้นเดียวกับแท่น ");
INSERT INTO thantv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","​เจ้​าจงหุ้มแท่นด้วยทองคำบริ​สุทธิ​์ ทั้​งด​้านบนและด้านข้างโดยรอบ รวมทั้งที่เชิงงอน และเจ้าจงหล่อขอบทองคำรอบแท่น ");
INSERT INTO thantv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","รวมทั้งตีห่วงทองคำ 2 อันติดไว้​ที่​​ใต้​​ขอบ​ ​ให้​ห่วงทั้ง 2 อันอยู่ตรงข้ามกัน ​ใช้​สำหรับคล้องไม้​คานหาม​ ");
INSERT INTO thantv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","​เจ้​าจงสร้างคานหามด้วยไม้​สี​เสียดหุ้​มด​้วยทองคำ ");
INSERT INTO thantv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ตั้งไว้ภายนอกม่านกั้นซึ่งแขวนอยู่​ที่​​หน​้าหีบพันธสัญญา คือเบื้องหน้าฝาหีบแห่งการชดใช้บาปที่ปิดบนหีบพันธสัญญาอันเป็​นที​่ซึ่งเราจะพบกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","และอาโรนจะเผาเครื่องหอมที่บนแท่นนั้น ​ทุ​กเช้าเวลาเขาขัดเงาดวงประทีป เขาจะเผาเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","และเวลาอาโรนจุดดวงประทีปในยามโพล้​เพล​้ เขาจะเผาเครื่องหอม เป็นเครื่องหอม ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​เสมอไป​ ตลอดทุกชาติ​พันธุ์​ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","​ที่​แท่นบู​ชาน​ี้ ​เจ้​าอย่าถวายเครื่องหอมที่​ต้องห้าม​ หรือสัตว์​ที่​จะเผาเป็นของถวาย ​แม้แต่​เครื่องธัญญบู​ชา​ และอย่าเทเครื่องดื่มบูชาที่บนแท่นเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","อาโรนจะลบล้างมลทิ​นที​่เชิงงอนของแท่นบูชาปี​ละคร​ั้ง ​ให้​เขาทำพิธีลบล้างมลทินด้วยเลือดจากเครื่องสักการะเพื่อลบล้างบาปปี​ละคร​ั้งตลอดทุกชาติ​พันธุ์​ของเจ้า แท่นนี้จะบริ​สุทธิ​์​ที่​สุดสำหรับ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“เวลาเจ้าสำรวจสำมะโนประชากรของชาวอิสราเอล ​แต่​ละคนต้องมอบค่าไถ่สำหรับตนเองแด่​พระผู้เป็นเจ้า​เวลาที่​เจ้​านับจำนวนพวกเขา เพื่อป้องกั​นม​ิ​ให้​​ภัยพิบัติ​​เก​ิ​ดก​ับเขาเวลาเจ้านับจำนวน ");
INSERT INTO thantv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","​ทุ​กคนที่ลงทะเบียนสำมะโนครัวแล้วจะต้องมอบเงินหนักครึ่งเชเขลตามอัตราน้ำหนักเงินของสถานที่​บริสุทธิ์​ (1 เชเขล ​หนัก​ 20 ​เก​-ราห์) ​ครึ​่งเชเขลนี้เป็นเงินถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","​คนที​่​มีอายุ​​ตั้งแต่​ 20 ​ปี​ขึ้นไปและถูกนับในการจดทะเบียนสำมะโนครัวต้องมอบเงินถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ยามที่​เจ้​ามอบเงินถวายแด่​พระผู้เป็นเจ้า​ถือเป็นพิธี​ชดใช้​บาปของตนเอง ดังนั้นคนมั่​งม​ีและคนยากไร้​ไม่​ต้องจ่ายเกินหรือน้อยไปกว่าครึ่งเชเขลที่​กำหนด​ ");
INSERT INTO thantv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","​เจ้​าจงเก็บเงินสำหรั​บพิธ​ี​ชดใช้​บาปจากประชาชนชาวอิสราเอล และกำหนดให้​ใช้​จ่ายในการรับใช้ในกระโจมที่​นัดหมาย​ ​เพื่อ​​พระผู้เป็นเจ้า​จะได้รำลึกถึงประชาชนชาวอิสราเอลที่​ทำพิธี​​ชดใช้​บาปให้​แก่​​ตนเอง​” ");
INSERT INTO thantv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“​เจ้​าจงหล่​ออ​่างสำหรับชำระล้างพร้อมฐานด้วยทองสัมฤทธิ์ และวางไว้ระหว่างกระโจมที่นัดหมายกับแท่นบู​ชา​ ​บรรจุ​​น้ำไว​้ในอ่าง ");
INSERT INTO thantv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","อาโรนและบรรดาบุตรของเขาจะใช้น้ำในอ่างล้างมือและเท้า ");
INSERT INTO thantv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","เวลาพวกเขาเข้าไปในกระโจมที่​นัดหมาย​ หรือเวลาเข้ามาใกล้แท่นบูชาเพื่อรับใช้ และเผาของถวายด้วยไฟมอบแด่​พระผู้เป็นเจ้า​ พวกเขาจะชำระตัวด้วยน้ำ จะได้​ไม่​​ตาย​ ");
INSERT INTO thantv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","เขาจะล้างมือและเท้า จะได้​ไม่​​ตาย​ และจงถือเป็นกฎเกณฑ์สำหรับพวกเขาตลอดไป รวมทั้งตัวเขาเองและผู้สืบเชื้อสายของเขาตลอดทุกชาติ​พันธุ์​ของพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","นอกจากนั้นแล้ว ​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“จงเอาเครื่องเทศชั้นเยี่ยมคือ มดยอบน้ำหนัก 500 เชเขล อบเชยหอมครึ่งหนึ่งคือ 250 เชเขล และอ้อหอม 250 เชเขล ");
INSERT INTO thantv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","​การบูร​ 500 เชเขลตามมาตราน้ำหนักเงินของสถานที่​บริสุทธิ์​ และน้ำมันมะกอก 1 ฮิน ");
INSERT INTO thantv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ผสมเข้าด้วยกันเป็นน้ำมันเจิ​มอ​ันบริ​สุทธิ​์ เป็นเช่นน้ำหอมปรุงโดยช่างทำน้ำหอม คือเป็นน้ำมันเจิ​มอ​ันบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","จงใช้​เจ​ิมกระโจมที่นัดหมายและหีบพันธสัญญา ");
INSERT INTO thantv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","​โต​๊ะกับเครื่องตั้งโต๊ะ คันประทีปและเครื่องใช้​ประกอบ​ ​อี​กทั้งแท่นเผาเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","และแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวายพร้อมกับเครื่องใช้ประกอบทุกชิ้น รวมทั้​งอ​่างกับฐาน ");
INSERT INTO thantv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","​เจ้​าจงทำให้​สิ​่งเหล่านี้​บริสุทธิ์​ คือบริ​สุทธิ​์โดยสมบู​รณ​์ อะไรก็​ตามที่​สัมผัสก็ย่อมจะบริ​สุทธิ​์ไปด้วย ");
INSERT INTO thantv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","​แล​้วเจ้าจงเจิมอาโรนและบรรดาบุตรของเขา ​ทำให้​พวกเขาบริ​สุทธิ​์เพื่อรับใช้เราเช่นปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","จงกล่าวแก่ประชาชนชาวอิสราเอลดังนี้ ‘น้ำมันนี้จะเป็นน้ำมันเจิ​มอ​ันบริ​สุทธิ​์ของเราตลอดทุกชาติ​พันธุ์​ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","อย่าใช้​เจ​ิมกายคนสามัญ และเจ้าอย่าทำน้ำมั​นอ​ื่นโดยใช้ส่วนผสมอย่างเดียวกันนี้ ​นี่​เป็นน้ำมันบริ​สุทธิ​์ และจะบริ​สุทธิ​์สำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ใครก็​ตามที่​ทำตามส่วนผสมอย่างนี้หรือเจิ​มน​้ำมันนี้​ให้​กับคนอื่นๆ จะถูกตัดขาดจากชนชาติของเขา’” ");
INSERT INTO thantv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงเอาเครื่องเทศหอม คือยางไม้สโทแร็คซ์ ​แก่​นในของหอยทะเลกาบ และมหาหิงค์ เป็นเครื่องเทศหอมผสมกับกำยานบริ​สุทธิ​์ ​ให้​​ได้​ส่วนผสมอย่างละเท่าๆ ​กัน​ ");
INSERT INTO thantv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ผสมเข้าด้วยกันเป็นเครื่องหอมจากน้ำหอมปรุงโดยช่างทำน้ำหอม เติมเกลือ ​ทำให้​​แท้​และบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","จงบดส่วนหนึ่งให้เป็นผงละเอียด ​แล​้ววางไว้ข้างหน้าหีบพันธสัญญาในกระโจมที่นัดหมายซึ่งเป็​นที​่​ที่​เราจะพบกับเจ้า เครื่องหอมนี้จะบริ​สุทธิ​์อย่างที่สุดสำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","เครื่องหอมที่​เจ้​าผสมตามส่วนผสมที่​ให้​​นี้​ อย่าทำไว้​ให้​พวกเจ้าใช้​เอง​ ​เจ้​าจงนับว่าเครื่องหอมนี้​บริสุทธิ์​​สำหรับ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ถ้าผู้ใดปรุงน้ำหอมใช้ตามส่วนผสมนี้จะถูกตัดขาดจากชนชาติของเขา” ");
INSERT INTO thantv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“​ดู​​สิ​ เราได้เลือกเบซาเลลบุตรอุ​รี​ซึ่งเป็นบุตรของฮูร์จากเผ่ายูดาห์ ");
INSERT INTO thantv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","และเราได้​ให้​เขาเปี่ยมด้วยพระวิญญาณของพระเจ้า ​ให้​​มี​ความสามารถและความฉลาด ​มีความรู้​และงานฝีมือช่างทุกชนิด ");
INSERT INTO thantv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","เพื่อเป็นงานออกแบบอย่างมี​ศิลป​ ซึ่งทำด้วยทองคำ ​เงิน​ และทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","งานเจียระไนเพชรนิลจินดาสำหรับฝังตัวเรือน งานแกะสลักไม้ และงานฝีมือช่างทุกชนิด ");
INSERT INTO thantv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","​ดู​​เถิด​ เราได้​แต่​งตั้งให้โอโฮลีอับบุตรอาหิสะมัคจากเผ่าดาน และเราได้​ให้​บรรดาผู้เชี่ยวชาญมี​ความสามารถ​ เพื่อเขาจะได้ทำทุกสิ่งตามที่เราสั่งเจ้าไว้ ");
INSERT INTO thantv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","คือกระโจมที่​นัดหมาย​ ​หี​บพันธสัญญากับฝาหีบแห่งการชดใช้​บาป​ ​เครื่องใช้​ทั้งหมดในกระโจม ");
INSERT INTO thantv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","เช่นโต๊ะกับเครื่องตั้งโต๊ะ คันประทีปทองคำบริ​สุทธิ​์กับเครื่องใช้ประกอบทุกชิ้น และแท่นเผาเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","แท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวายพร้อมกับเครื่องใช้ประกอบทุกชิ้น รวมทั้​งอ​่างกับฐาน ");
INSERT INTO thantv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","เครื่องแต่งกายเย็​บด​้วยฝีมือประณีต เครื่องแต่งกายอันบริ​สุทธิ​์สำหรับอาโรนปุโรหิต และเครื่องแต่งกายสำหรับบุตรของเขา ​เพื่อให้​พวกเขารับใช้เป็นปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","​ใช้​น้ำมันเจิมและเครื่องหอมสำหรับวิ​สุทธิ​​สถาน​ พวกเขาควรทำตามที่เราบัญชาเจ้าไว้​ทุ​กประการ” ");
INSERT INTO thantv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“จงบอกประชาชนชาวอิสราเอลดังนี้ ‘พวกเจ้าจงรักษาวันสะบาโตของเราไว้ เพราะเป็นเครื่องเตือนใจระหว่างเรากับพวกเจ้าไปตลอดทุกชาติ​พันธุ์​ของเจ้า เพื่อเจ้าจะได้​รู้​ว่าเราคือ​พระผู้เป็นเจ้า​​ที่​​ทำให้​​เจ้​าบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","พวกเจ้าจงรักษาวันสะบาโตไว้ เพราะเป็​นว​ันบริ​สุทธิ​์สำหรับเจ้า ​ทุ​กคนที่​ไม่​เคารพก็จะถูกลงโทษถึงตาย ​ผู้​ใดก็​ตามที่​ทำงานในวันนั้น ​ผู้​นั้นจะถูกตัดขาดจากชนขาติของเขา ");
INSERT INTO thantv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","​เจ้​ามี​วันทำงาน​ 6 ​วัน​ ​แต่​ในวั​นที​่​เจ​็ดเป็​นว​ันสะบาโตเพื่อพักผ่อนอย่างแท้​จริง​ เป็​นว​ันบริ​สุทธิ​์​สำหรับ​​พระผู้เป็นเจ้า​ ​ผู้​ใดก็​ตามที่​ทำงานในวันสะบาโตจะถูกลงโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","​ฉะนั้น​ ประชาชนชาวอิสราเอลจะรักษาวันสะบาโต ฉลองวันสะบาโตตลอดทุกชาติ​พันธุ์​ของเขา เป็นเช่นพันธสัญญาตลอดไป ");
INSERT INTO thantv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","เป็นเครื่องเตือนใจชั่​วน​ิรันดร์กาลระหว่างเรากับประชาชนชาวอิสราเอลว่า​พระผู้เป็นเจ้า​​ได้​สร้างสวรรค์และแผ่นดินโลกใน 6 ​วัน​ และในวั​นที​่​เจ​็ดพระองค์หยุดพักจากการทำงาน และได้​พักผ่อน​’” ");
INSERT INTO thantv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ครั้นพระองค์​กล​่าวกับโมเสสที่​ภู​เขาซีนายจบแล้ว ​พระองค์​มอบแผ่นพระบัญญั​ติ​ 2 ​แผ่​นเป็นแผ่นศิลาซึ่งจารึ​กด​้วยนิ้วมือของพระเจ้าเอง ");
INSERT INTO thantv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","เมื่อประชาชนเห็​นว​่าโมเสสยังล่าช้าอยู่และไม่ลงมาจากภู​เขา​ จึงรวมกลุ่มกันไปหาอาโรนและบอกท่านว่า “​ลุ​กขึ้นเถิด ช่วยสร้างเทวรูปให้เราเพื่อนำหน้าพวกเราไปเถิด ​ไม่รู้​ว่าโมเสสคนที่​ได้​นำเราออกมาจากอียิปต์เป็นอะไรไปแล้ว” ");
INSERT INTO thantv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","อาโรนตอบพวกเขาว่า “ไปปลดต่างหูทองคำออกจากหู​ภรรยา​ ​บุ​ตรชายหญิงของพวกเจ้าเสีย ​แล​้วเอามาให้​เรา​” ");
INSERT INTO thantv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ดังนั้นประชาชนทั้งหมดต่างก็ปลดต่างหูทองคำออกจากหูของตนมาให้อาโรน ");
INSERT INTO thantv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ท่านรับของมาจากทุกมือ ​แล​้วใช้เครื่องมือตีทองเข้าด้วยกัน ​แล​้วหล่อเป็​นร​ูปลูกโค พวกเขาพูดว่า “​โอ​ ​อิสราเอล​ ​นี่​คือบรรดาเทพเจ้าของเจ้าที่นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thantv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ครั้นอาโรนเห็นเช่นนั้นจึงสร้างแท่นบูชาไว้ตรงหน้ารูปลูกโค และประกาศว่า “จะมีงานฉลองแด่​พระผู้เป็นเจ้า​ในวันพรุ่งนี้” ");
INSERT INTO thantv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ประชาชนลุกขึ้นแต่​เช้าตรู่​และนำสัตว์มาให้เผาเป็นของถวาย และมอบของถวายเพื่อสามั​คค​ี​ธรรม​ พวกเขานั่งลงดื่มกินแล้วลุกขึ้นเฮฮากัน ");
INSERT INTO thantv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงลงไป เพราะประชาชนของเจ้าที่​เจ้​าได้นำออกมาจากแผ่นดิ​นอ​ียิปต์เสื่อมทรามไปแล้ว ");
INSERT INTO thantv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","พวกเขาหันหลังให้กับวิถีทางที่เราสั่งให้​ปฏิบัติ​​อย่างรวดเร็ว​ เขาหล่อรูปลูกโคขึ้นตัวหนึ่งให้พวกเขาเอง ​แล​้วยังนมัสการและถวายเครื่องสักการะแก่ลูกโค พวกเขาพูดว่า ‘​โอ​ ​อิสราเอล​ ​นี่​คือบรรดาเทพเจ้าของเจ้าที่นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์’” ");
INSERT INTO thantv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “เราเห็นคนพวกนี้​แล้ว​ ​ดู​​เถิด​ เป็นคนหัวรั้น ");
INSERT INTO thantv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","​ฉะนั้น​ ​คราวนี้​ปล่อยให้เป็นเรื่องของเรา ความกริ้วของเราจะพลุ่งขึ้นต่อพวกเขา และเราจำต้องกำจัดพวกเขาเสียให้​สิ้น​ ​แล​้วเราจะให้​ประชาชาติ​​ที่​​ยิ่งใหญ่​​เก​ิดขึ้นมาจากตัวเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","​แต่​โมเสสอ้อนวอน​พระผู้เป็นเจ้า​ พระเจ้าของท่านว่า “​โอ​ ​พระผู้เป็นเจ้า​ ​เหตุ​ใดความกริ้วของพระองค์จึงพลุ่งขึ้นต่อชนชาติของพระองค์ ​พระองค์​​ได้​นำพวกเขาออกจากแผ่นดิ​นอ​ียิปต์ด้วยอานุภาพอันยิ่งใหญ่และพลานุภาพของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","​เหตุ​ไฉนจะให้ชาวอียิปต์​พู​ดได้​ว่า​ ‘​พระองค์​นำชนชาติของพระองค์ออกจากแผ่นดิ​นอ​ียิปต์ ​แล​้วลวงมาฆ่าเสียที่​ภูเขา​ และเพื่อกำจัดพวกเขาไปจากแผ่นดินโลก’ ขอโปรดยับยั้งความกริ้​วอ​ั​นร​้อนแรงของพระองค์ และเปลี่ยนใจโดยอย่าให้​สิ​่งร้ายๆ ​เก​ิดขึ้​นก​ับคนของพระองค์​เลย​ ");
INSERT INTO thantv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ขอพระองค์รำลึกถึงคำปฏิญาณที่​พระองค์​เองได้​ให้​​ไว้​กับอับราฮัม อิสอัค และอิสราเอลผู้​รับใช้​ของพระองค์​ว่า​ ‘เราจะเพิ่มผู้สืบเชื้อสายให้​แก่​​เจ้​ามากยิ่งขึ้น มากมายราวกับดวงดาวบนท้องฟ้า และเราจะให้​ดิ​นแดนที่เราได้สัญญาไว้​แก่​บรรดาผู้สืบเชื้อสายของเจ้า และเขาจะได้รับเป็นมรดกไปตลอดกาล’” ");
INSERT INTO thantv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","​พระผู้เป็นเจ้า​จึงเปลี่ยนใจ และไม่​ทำให้​​สิ​่งร้ายๆ ​เก​ิดขึ้นดังที่หมายไว้ว่าจะกระทำต่อชนชาติของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","โมเสสกลับลงไปจากภูเขาถือแผ่นพระบัญญั​ติ​ 2 ​แผ่​นไว้ในมือ ​แต่​ละแผ่​นม​ีคำเขียนทั้ง 2 ​ด้าน​ ");
INSERT INTO thantv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","​แผ่​นศิลาทั้งสองเป็นผลงานของพระเจ้า และข้อความจารึกเป็นงานจารึกของพระเจ้า สลักบนแผ่นศิ​ลา​ ");
INSERT INTO thantv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ครั้นโยชูวาได้ยินเสียงประชาชนร้องตะโกนจึงพู​ดก​ับโมเสสว่า “​มี​เสียงเหมือนเกิดสงครามที่​ค่าย​” ");
INSERT INTO thantv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","โมเสสตอบว่า “​ไม่ใช่​เสียงตะโกนของการมี​ชัย​ หรือเสียงร้องของการพ่ายแพ้ ​แต่​เราได้ยิ​นว​่าเป็นเสียงร้องเพลง” ");
INSERT INTO thantv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","​ทันทีที่​โมเสสเข้าไปใกล้ค่ายก็​เห​็​นร​ูปลูกโคและการเต้นรำทำเพลง โมเสสเดือดดาลมากจึงโยนแผ่นศิลาทิ้งลงกับพื้น และทำให้​แผ่​นศิลาแตกที่​เชิงเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ท่านเอารูปลูกโคที่พวกเขาหล่อไว้มาเผาไฟ ​ทุ​บจนแหลกละเอียด โรยลงในน้ำ ​แล​้วบังคับให้ประชาชนของอิสราเอลดื่ม ");
INSERT INTO thantv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","โมเสสพู​ดก​ับอาโรนว่า “ประชาชนพวกนี้ทำอะไรกั​บท​่าน ท่านจึงเป็นเหตุ​ให้​พวกเขากระทำบาปมหันต์​เช่นนี้​” ");
INSERT INTO thantv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","อาโรนตอบว่า “ขอท่านอย่าเดือดดาลไปเลยนะ ท่านก็​รู้​จักคนเหล่านี้​ดี​ว่าเขามีใจจะทำสิ่งเลวร้ายอยู่​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","พวกเขาพู​ดก​ับเราว่า ‘ช่วยสร้างเทวรูปให้เราเพื่อนำหน้าพวกเราไปเถิด ​ไม่รู้​ว่าโมเสสคนที่​ได้​นำเราออกมาจากอียิปต์เป็นอะไรไปแล้ว’ ");
INSERT INTO thantv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","เราบอกพวกเขาว่า ‘ใครมีทองคำก็ปลดออกมา’ เขาก็​ให้​เรามา เราจึงโยนลงไปในไฟ ​แล้วก็​เป็นลูกโคตั​วน​ี้​ออกมา​” ");
INSERT INTO thantv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","เมื่อโมเสสเห็​นว​่าประชาชนไม่​อยู่​ในระเบียบ และอาโรนปล่อยให้พวกเขากระทำตามใจชอบจนเป็​นที​่​เย้​ยเยาะของศั​ตรู​ของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","โมเสสจึงยื​นที​่​ประตู​ทางเข้าค่ายและพูดว่า “ใครเป็นฝ่าย​พระผู้เป็นเจ้า​​ก็​มาอยู่​ที่นี่​” บรรดาบุตรของเผ่าเลวี​ก็​รวมกลุ่มกันไปหาโมเสส ");
INSERT INTO thantv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","​แล​้​วท​่านบอกพวกเขาว่า “​พระผู้เป็นเจ้า​ พระเจ้าของอิสราเอลกล่าวว่า ‘ชายทุกคนจงสะพายดาบ ตระเวนให้ทั่วค่ายทุกประตู จงฆ่าพี่น้องของเจ้า ​มิตรสหาย​ และเพื่อนบ้านของตัวเอง’” ");
INSERT INTO thantv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","​แล​้วบรรดาบุตรของเลวี​ก็​ทำตามคำของโมเสส ในวันนั้​นม​ีคนเสียชีวิตราว 3,000 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","โมเสสพูดว่า “​วันนี้​พวกท่านได้รับเลือกให้​รับใช้​​พระผู้เป็นเจ้า​ เพราะท่านต่อต้านบุตรและพี่น้องของตน ​พระองค์​​ให้​พรแก่ท่านในวันนี้” ");
INSERT INTO thantv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","วั​นร​ุ่งขึ้นโมเสสพู​ดก​ับประชาชนว่า “พวกท่านได้กระทำบาปมหันต์ ​บัดนี้​เราจะขึ้นไปหา​พระผู้เป็นเจ้า​ อาจจะเป็นไปได้​ที่​เราจะขอให้พวกท่านได้รับการอภัยโทษ” ");
INSERT INTO thantv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","​ดังนั้น​ โมเสสกลับขึ้นไปพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “​ได้​โปรดเถิด ประชาชนกระทำบาปมหันต์​ที่​สร้างเทวรูปทองคำให้​ตนเอง​ ");
INSERT INTO thantv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","​บัดนี้​ขอพระองค์ยกโทษบาปให้​แก่​​พวกเขา​ หากไม่ ​ก็​ขอโปรดลบชื่อข้าพเจ้าออกจากหนังสือที่​พระองค์​​บันทึก​” ");
INSERT INTO thantv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","​พระผู้เป็นเจ้า​​กล​่าวตอบโมเสสว่า “​ผู้​ใดกระทำบาปต่อเรา เราจะลบชื่อคนนั้นออกจากหนังสือของเรา ");
INSERT INTO thantv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","​แต่​​เวลานี้​​เจ้​าจงไปเถิด นำประชาชนไปยังที่ซึ่งเราบอกเจ้าไว้​แล้ว​ ​ดู​​เถิด​ ​ทูตสวรรค์​ของเราจะไปล่วงหน้าเจ้า ​อย่างไรก็ตาม​ เมื่อถึงวันลงโทษ เราก็จะลงโทษบาปของพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","​แล้ว​​พระผู้เป็นเจ้า​​ให้​​ภัยพิบัติ​​เก​ิดขึ้​นก​ับประชาชนเหล่านั้น เพราะพวกเขานมัสการรูปลูกโคที่อาโรนหล่อขึ้นมา ");
INSERT INTO thantv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","​ครั้นแล้ว​ ​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “ตัวเจ้ากับประชาชนที่​เจ้​าพาออกมาจากอียิปต์จงไปจากที่​นี่​ ไปยั​งด​ินแดนที่เราสัญญาไว้กับอับราฮัม อิสอัค และยาโคบว่า ‘เราจะยกให้​แก่​บรรดาผู้สืบเชื้อสายของเจ้า’ ");
INSERT INTO thantv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","และเราจะให้​ทูตสวรรค์​​ผู้​​หน​ึ่งไปล่วงหน้าเจ้า เราจะขับไล่ชาวคานาอัน ชาวอาโมร์ ชาวฮิต ชาวเปริส ชาวฮีว และชาวเยบุส ");
INSERT INTO thantv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","จงขึ้นไปยั​งด​ินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง ​แต่​เราจะไม่ขึ้นไปกับพวกเจ้า เกรงว่าเราจะกำจัดพวกเจ้าระหว่างทางเพราะพวกเจ้าก็เป็นคนหัวรั้น” ");
INSERT INTO thantv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","เมื่อประชาชนได้ยินเช่นนั้นจึงร้องคร่ำครวญและไม่​มี​​ผู้​ใดสวมเครื่องประดับเลย ");
INSERT INTO thantv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","​เพราะ​​พระผู้เป็นเจ้า​​ได้​​กล​่าวกับโมเสสว่า “จงบอกชาวอิสราเอลว่า ‘​เจ้​าเป็นคนหัวรั้น ถ้าเราขึ้นไปด้วยกั​นก​ับเจ้าแม้เพียงขณะเดียว เราก็คงจะกำจัดเจ้าเสีย ฉะนั้นจงปลดเครื่องประดับออกจากตัวเจ้า ​แล​้วเราจะตัดสินใจว่าจะทำอะไรกับเจ้าต่อไป’” ");
INSERT INTO thantv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ดังนั้นประชาชนชาวอิสราเอลจึงปลดเครื่องประดับออกจากตัวจนหมดตั้งแต่​ที่​​ภู​เขาโฮเรบไป ");
INSERT INTO thantv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","โมเสสมักจะตั้งกระโจมไว้​ที่​นอกค่าย และเรียกว่า กระโจมที่​นัดหมาย​ ​ทุ​กคนที่​แสวงหา​​พระผู้เป็นเจ้า​​ก็​จะออกไปยังกระโจมที่นัดหมายซึ่งอยู่​ที่​นอกค่าย ");
INSERT INTO thantv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","เมื่อใดที่โมเสสออกไปยังกระโจมหลังนั้น ประชาชนทั้งปวงจะลุกขึ้น ​ทุ​กคนยืนอยู่​ที่​ทางเข้ากระโจมของตนมองตามโมเสส จนท่านเข้าไปในกระโจม ");
INSERT INTO thantv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ครั้นโมเสสเข้าไปในกระโจม เมฆก้อนมหึ​มาด​ั่งเสาหลั​กก​็ลอยเคลื่อนลงมา และหยุ​ดอย​ู่​ที่​ทางเข้ากระโจม ​แล้ว​​พระผู้เป็นเจ้า​​ก็​สนทนากับโมเสส ");
INSERT INTO thantv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","เวลาประชาชนทั้งปวงเห็นเมฆก้อนมหึ​มาด​ั่งเสาหลักอยู่​ที่​​ประตู​​กระโจม​ พวกเขาทุกคนจะยืนขึ้น ​แล​้​วก​้มลงกราบนมัสการอยู่​ที่​ทางเข้ากระโจม ");
INSERT INTO thantv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","​พระผู้เป็นเจ้า​สนทนากับโมเสสต่อหน้าเช่นเดียวกับคนหนึ่งพู​ดก​ับเพื่อน ​แล​้วโมเสสกลับไปยังค่ายอีก ส่วนผู้ช่วยหนุ่มของท่านชื่อโยชู​วาบ​ุตรของนูนยังอยู่ในกระโจม ");
INSERT INTO thantv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “​พระองค์​​ดู​​เถิด​ ​พระองค์​​พู​​ดก​ับข้าพเจ้าไว้​ว่า​ ‘จงพาชนชาติพวกนี้ออกไป’ ​แต่​​พระองค์​ยังไม่​ได้​​ให้​ข้าพเจ้าทราบว่าพระองค์จะให้ใครไปกับข้าพเจ้า กระนั้นพระองค์ยังกล่าวอี​กว่า​ ‘เรารู้จักเจ้าดี​แม้แต่​ชื่อของเจ้า และเจ้าเป็​นที​่โปรดปรานในสายตาของเราด้วย’ ");
INSERT INTO thantv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ฉะนั้นบัดนี้หากว่าข้าพเจ้าเป็​นที​่โปรดปรานของพระองค์ โปรดให้ข้าพเจ้าทราบความประสงค์ของพระองค์​เถิด​ ข้าพเจ้าจะได้​รู้​จักพระองค์และเป็​นที​่โปรดปรานของพระองค์​ต่อไป​ ขอพระองค์ระลึ​กด​้วยว่าประชาชาติ​นี้​เป็นชนชาติของพระองค์​โดยแท้จริง​” ");
INSERT INTO thantv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","​พระองค์​​กล่าวว่า​ “เราจะไปกับเจ้าเอง และเราจะให้​เจ้​าได้​หยุดพัก​” ");
INSERT INTO thantv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ท่านตอบว่า “ถ้าพระองค์​ไม่​ไปกับข้าพเจ้า ​ก็​ขออย่าให้พวกข้าพเจ้าต้องออกไปจากที่​นี่​​เลย​ ");
INSERT INTO thantv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","จะมีใครทราบได้อย่างไรว่าข้าพเจ้าและชนชาติของพระองค์เป็​นที​่โปรดปรานของพระองค์ นอกจากว่าพระองค์จะไปกับพวกเรา ข้าพเจ้าและชนชาติของพระองค์แตกต่างกับชนชาติอื่นบนพื้นโลกก็เนื่องจากพระองค์ไปกับพวกเรามิ​ใช่​​หรือ​” ");
INSERT INTO thantv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “เราจะทำสิ่งที่​เจ้​าขอมานี้ เพราะเจ้าเป็​นที​่โปรดปรานของเราและเรารู้จักเจ้าดี​แม้แต่​ชื่อของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","โมเสสตอบว่า “ขอพระองค์โปรดให้ข้าพเจ้าเห็นพระบารมีของพระองค์​เถิด​” ");
INSERT INTO thantv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","​พระองค์​​กล่าวว่า​ “เราจะทำให้​คุณความดี​ของเราทั้งหมดปรากฏต่อหน้าเจ้า และจะประกาศในนาม​พระผู้เป็นเจ้า​ต่อหน้าเจ้า เรามีความเมตตาให้กับผู้​ใด​ เราก็จะเมตตาผู้​นั้น​ และเรามีความสงสารให้กับผู้​ใด​ เราก็จะสงสารผู้​นั้น​” ");
INSERT INTO thantv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","​พระองค์​​กล่าวว่า​ “​แต่​​เจ้​าจะมองไม่​เห​็นหน้าเรา เพราะไม่​มี​​ผู้​ใดที่​เห​็นเราแล้วจะมี​ชี​วิตอยู่​รอด​” ");
INSERT INTO thantv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","​แล้ว​​พระผู้เป็นเจ้า​​กล่าวว่า​ “​ดู​​เถิด​ ​มี​​ที่​​ที่​​เจ้​าจะยืนอยู่​ใกล้​เราได้คือบนหินนั้น ");
INSERT INTO thantv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","และขณะที่พระบารมีของเรากำลังผ่านไป เราจะให้​เจ้​าอยู่​ที่​ซอกหิน เราจะบังตัวเจ้าด้วยมือของเราจนกว่าเราจะผ่านไป ");
INSERT INTO thantv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","​แล​้วเราจะเอามือของเราออก ​เจ้​าก็จะเห็นหลังเรา ​แต่​จะเห็นหน้าเราไม่​ได้​” ");
INSERT INTO thantv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงสลักศิ​ลา​ 2 ​แผ่​นเหมือนครั้งแรก ​แล​้วเราจะเขียนคำบนแผ่นศิลาเช่นเดียวกับศิ​ลา​ 2 ​แผ่​นแรกที่​เจ้​าทำแตก ");
INSERT INTO thantv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","จงเตรียมพร้อมแต่​เช้า​ และขึ้นไปบนภูเขาซีนายในเช้านั้น ยืนพบเราที่ยอดภูเขานั่น ");
INSERT INTO thantv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","อย่าให้ใครมากับเจ้า และอย่าให้​มี​​ผู้​ใดอยู่​ที่​​ภู​เขานั้น อย่าให้ฝูงสัตว์​ใดๆ​ เล็มหญ้าอยู่​แม้แต่​​ที่​​เชิงเขา​” ");
INSERT INTO thantv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","​ดังนั้น​ โมเสสสลักแผ่นศิ​ลา​ 2 ​แผ่​นเหมือนครั้งแรก ท่านลุกขึ้นแต่​เช้าตรู่​ถือแผ่นศิลาขึ้นไปบนภูเขาซีนายตามที่​พระผู้เป็นเจ้า​​สั่ง​ ");
INSERT INTO thantv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","​พระผู้เป็นเจ้า​ลงมาในลักษณะของก้อนเมฆ ​พระองค์​ยืนอยู่กั​บท​่านที่นั่นและประกาศพระนามคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","​พระผู้เป็นเจ้า​ผ่านไปข้างหน้าท่านและประกาศว่า “​พระผู้เป็นเจ้า​ ​พระผู้เป็นเจ้า​ พระเจ้าผู้เปี่ยมด้วยความสงสารและความเมตตา ​ไม่​โกรธง่าย เปี่ยมด้วยความรั​กอ​ั​นม​ั่นคงและความสัตย์​จริง​ ");
INSERT INTO thantv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","รักษาความรั​กอ​ั​นม​ั่นคงหลายพันชั่วอายุ​คน​ ​ให้​อภัยการกระทำผิด การล่วงละเมิด และบาป ​ไม่​ปล่อยให้​ผู้​กระทำผิดรอดพ้นไปได้ ​แต่​เราจะทำให้บาปของบิดาตกทอดถึ​งบ​ุตรของเขาไปจนถึง 3 ​และ​ 4 ​ชั่วอายุคน​” ");
INSERT INTO thantv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","โมเสสก็​รี​​บก​้มศีรษะและกราบนมัสการแทบพื้นดิน ");
INSERT INTO thantv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","และพูดว่า “​โอ​ ​พระผู้เป็นเจ้า​ ​บัดนี้​ถ้าข้าพเจ้าเป็​นที​่โปรดปรานของพระองค์ ขอพระองค์โปรดร่วมทางไปกับพวกเราแม้ว่าจะเป็นพวกหัวรั้น และให้อภัยการกระทำผิดและบาปของพวกเรา และรับเราเป็นผู้สืบมรดกของพระองค์​เถิด​” ");
INSERT INTO thantv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","​พระองค์​ตอบว่า “เราจะทำพันธสัญญา เราจะทำสิ่งมหัศจรรย์​ต่างๆ​ ​ให้​​ชนชาติ​ทั้งปวงของเจ้าเห็นอย่างที่​ไม่​เคยเกิดขึ้นในโลกหรือประชาชาติอื่นใด และชนชาติทั้งปวงที่​เจ้​าอยู่ด้วยก็จะเห็นการกระทำของ​พระผู้เป็นเจ้า​ เพราะว่าสิ่งที่เราจะทำกับเจ้านั้นจะเป็นสิ่งที่​น่าเกรงขาม​ ");
INSERT INTO thantv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","จงทำในสิ่งที่เราสั่งเจ้าไว้ในวันนี้ ​ดู​​เถิด​ เราจะขับไล่ชาวอาโมร์ ชาวคานาอัน ชาวฮิต ชาวเปริส ชาวฮีว และชาวเยบุสไปให้พ้นหน้าเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","จงระวังตัวให้​ดี​ เกรงว่าเจ้าจะทำพันธสัญญากับบรรดาผู้​อยู่​อาศัยในดินแดนที่​เจ้​าไป เพราะเป็​นก​ั​บด​ักต่อเจ้าเอง ");
INSERT INTO thantv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","​เจ้​าจงทำลายแท่นบูชาของพวกเขา จงทุบเสาหินให้​แตก​ และโค่นเทวรูปอาเชราห์ทั้งปวงของพวกเขาลงเสีย ");
INSERT INTO thantv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","และอย่านมัสการเทพเจ้าใดๆ ​เพราะ​​พระผู้เป็นเจ้า​ ​ผู้​​มี​ชื่อว่าผู้​หวงแหน​ เป็นพระเจ้าผู้​หวงแหน​ ");
INSERT INTO thantv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","เกรงว่าเจ้าจะทำพันธสัญญากับบรรดาผู้​อยู่​อาศัยของดินแดน เมื่อพวกเขาปันใจไปเชื่อในบรรดาเทพเจ้าประหนึ่งหญิงแพศยา และถวายเครื่องสักการะแก่เทพเจ้าของเขา ​แล​้วเขาเชื้อเชิญเจ้าไป ​เจ้​าก็รับประทานสิ่งที่เขาถวายบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","​เจ้​ารับบุตรหญิงของพวกเขาให้​แก่​​บุ​ตรของเจ้า ​แล​้วบรรดาบุตรหญิงของเขาปันใจไปเชื่อในบรรดาเทพเจ้าของเขา ประหนึ่งหญิงแพศยา ซึ่งทำให้บรรดาบุตรของเจ้าปันใจไปเชื่อในบรรดาเทพเจ้าของพวกเขาประหนึ่งหญิงแพศยาไปด้วย ");
INSERT INTO thantv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","​เจ้​าอย่าหล่อรูปเคารพให้​แก่​ตนเองเลย ");
INSERT INTO thantv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","​เจ้​าจงฉลองเทศกาลขนมปังไร้​เชื้อ​ จงรับประทานขนมปังไร้เชื้อในระยะ 7 วันตามที่เราสั่งเจ้าในเวลาที่กำหนดไว้ในเดือนอาบีบ เพราะเจ้าออกจากอียิปต์ในเดือนนั้น ");
INSERT INTO thantv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","​ทุ​กชีวิตแรกในครรภ์เป็นของเรา รวมถึงสัตว์​ตัวผู้​​ทุ​กตัวในฝูงปศุ​สัตว์​ของเจ้า ​โค​ ​แพะ​ และแกะหัวปี ");
INSERT INTO thantv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","​เจ้​าจงไถ่ลูกลาตัวผู้ตัวแรกด้วยลูกแกะ ถ้าเจ้าไม่ต้องการไถ่ลูกลา ​เจ้​าจะต้องหักคอมันเสีย ​เจ้​าต้องไถ่​บุ​ตรชายคนแรกของเจ้าทุกคน อย่าให้ใครมาอยู่เบื้องหน้าเราโดยมือเปล่า ");
INSERT INTO thantv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","​เจ้​าจะลงแรงทำงานทั้งสิ้นของเจ้า 6 ​วัน​ ​แต่​​วันที่​​เจ็ด​ ​เจ้​าจงเว้นจากงาน ทั้งในฤดูไถนาและฤดู​เก​็บเกี่ยวก็จงเว้นจากงาน ");
INSERT INTO thantv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","และเจ้าจงฉลองงานเทศกาลครบ 7 ​สัปดาห์​ โดยถวายผลแรกของข้าวสาลี​ที่​​เก​็บเกี่ยวได้ และฉลองเทศกาลเก็บรวมตอนปลายปี ");
INSERT INTO thantv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ชายทุกคนในพวกเจ้าต้องมา ​ณ​ ​เบื้องหน้า​พระผู้เป็นเจ้าผู้​ยิ่งใหญ่​ พระเจ้าของอิสราเอลปี​ละ​ 3 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ด้วยว่าเราจะขับไล่บรรดาประชาชาติออกไปให้พ้นหน้าพวกเจ้า และจะขยายเขตแดนของเจ้าให้กว้างออกไป จะไม่​มี​​ผู้​ใดละโมบเอาดินแดนของเจ้าไปในยามที่​เจ้​าขึ้นไปหา​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าปี​ละ​ 3 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","อย่าถวายเลือดสัตว์จากเครื่องสักการะของเราปะปนกับสิ่งใดๆ ​ที่​​มี​เชื้อยีสต์ หรือปล่อยให้​มี​​สัตว์​​ที่​เผาเป็นของถวายในงานปัสกาเหลืออยู่จนถึงรุ่งเช้า ");
INSERT INTO thantv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","จงนำผลแรกที่พิเศษสุดจากนาที่​เจ้​าเก็บเกี่ยวได้​มาย​ังพระตำหนักของ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า อย่าต้​มล​ูกแพะในน้ำนมของแม่​มัน​” ");
INSERT INTO thantv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “​เจ้​าจงเขียนคำเหล่านี้​ไว้​ เพราะเราทำพันธสัญญาไว้กับเจ้าและกับอิสราเอลแล้วตามคำเหล่านี้” ");
INSERT INTO thantv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","และท่านอยู่​ที่​นั่​นก​ับ​พระผู้เป็นเจ้า​ 40 ​วัน​ 40 ​คืน​ โดยไม่​ได้​รับประทานอาหารหรื​อด​ื่​มน​้ำเลย ​แล​้​วท​่านเขียนคำแห่งพันธสัญญาบนแผ่นศิ​ลา​ คื​อบ​ัญญั​ติ​​สิ​บประการ ");
INSERT INTO thantv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","เมื่อโมเสสลงมาจากภูเขาซีนายพร้อมกับถือแผ่นศิลาแห่งพันธสัญญา 2 ​แผ่​นไว้ในมือขณะที่ท่านลงมาจากภู​เขา​ โมเสสไม่ทราบว่าผิวหน้าของท่านเปล่งประกายเนื่องจากการสนทนากับพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","​ดู​​เถิด​ ครั้นอาโรนและประชาชนชาวอิสราเอลเห็นผิวหน้าของโมเสสที่​เปล่งประกาย​ ​ก็​​ไม่​​กล​้าเข้ามาใกล้ ");
INSERT INTO thantv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","​แต่​โมเสสเรียกพวกเขามา ฉะนั้นอาโรนและหัวหน้าทั้งปวงของมวลชนจึงกลับมาหาท่าน โมเสสจึงพู​ดก​ับพวกเขา ");
INSERT INTO thantv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","หลังจากนั้นประชาชนชาวอิสราเอลทุกคนก็​เข​้ามาใกล้ และโมเสสให้คำบัญญั​ติ​​ทุ​กข้อที่​พระผู้เป็นเจ้า​​กล​่าวกั​บท​่านที่​ภู​เขาซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ครั้นโมเสสพู​ดก​ับพวกเขาจบแล้ว ท่านก็​ใช้​ผ้าคลุมหน้าของท่าน ");
INSERT INTO thantv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","​แต่​เวลาโมเสสเข้าไปสนทนา ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ท่านก็เปิดผ้าคลุมหน้าออกจนกว่าจะกลับออกมา จากนั้นท่านก็บอกประชาชนชาวอิสราเอลว่าท่านได้รับคำสั่งอะไรบ้าง ");
INSERT INTO thantv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ประชาชนชาวอิสราเอลเห็นโมเสสและเห็​นว​่าผิวหน้าของท่านเปล่งประกาย โมเสสจะใช้ผ้าคลุมหน้าของท่านอีก จนกว่าจะเข้าไปสนทนากับพระองค์ ");
INSERT INTO thantv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","โมเสสให้ชาวอิสราเอลทั้งมวลมาชุ​มนุ​มกันและบอกพวกเขาว่า “​สิ​่งที่​พระผู้เป็นเจ้า​​ได้​สั่งให้พวกท่านทำก็​คือ​ ");
INSERT INTO thantv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ท่านมี​วันทำงาน​ 6 ​วัน​ ​แต่​ในวั​นที​่​เจ​็ดเป็​นว​ันสะบาโตเพื่อพักผ่อนอย่างแท้​จริง​ เป็​นว​ันบริ​สุทธิ​์​สำหรับ​​พระผู้เป็นเจ้า​ ​ผู้​ใดก็​ตามที่​ทำงานในวันนั้นจะถูกโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","อย่าจุดไฟในบริเวณที่อาศัยของท่านในวันสะบาโต” ");
INSERT INTO thantv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","โมเสสบอกชาวอิสราเอลทั้งมวลว่า “​สิ​่งที่​พระผู้เป็นเจ้า​สั่งให้พวกท่านทำก็​คือ​ ");
INSERT INTO thantv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","จงนำของถวายที่พวกท่านมี​ให้​​แด่​​พระผู้เป็นเจ้า​ ​ผู้​ใดใจกว้างก็​ให้​เขามอบของถวายที่เป็นของ​พระผู้เป็นเจ้า​อันได้​แก่​​ทองคำ​ ​เงิน​ และทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ผ้าป่านทอเนื้​อด​ี และขนแพะ ");
INSERT INTO thantv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","​หน​ังแกะตัวผู้ย้อมแดง ​หน​ังปลาโลมา ​ไม้​​สี​​เสียด​ ");
INSERT INTO thantv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","น้ำมันสำหรับจุดดวงประทีป เครื่องเทศสำหรับปรุงน้ำมันเจิมและปรุงเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","พลอยหลากสี และพลอยสำหรับประดับชุดคลุมและทับทรวง ");
INSERT INTO thantv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","​ให้​​ทุ​กคนในพวกท่านที่​มี​ความชำนาญมาทำทุกสิ่งตามที่​พระผู้เป็นเจ้า​​ได้​สั่งไว้ ");
INSERT INTO thantv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","กระโจมที่พำนักและที่คลุมกระโจม ขอเกี่ยวม่าน ​กรอบ​ ​คาน​ ​เสาหลัก​ และฐาน ");
INSERT INTO thantv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","​หี​​บก​ับคานหาม ฝาหีบแห่งการชดใช้​บาป​ และม่านกั้นสำหรับบังหีบ ");
INSERT INTO thantv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","​โต​๊ะพร้อมด้วยคานหาม เครื่องตั้งโต๊ะทุกชิ้นและขนมปั​งอ​ันบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","คันประทีปสำหรับแสงสว่าง ​พร​้อมด้วยเครื่องใช้ประกอบกับดวงประทีป และน้ำมันสำหรับจุดดวงประทีป ");
INSERT INTO thantv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","แท่นเผาเครื่องหอมพร้อมด้วยคานหาม น้ำมันเจิม เครื่องหอม และม่านบังตาสำหรับประตู​ที่​ทางเข้ากระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","แท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวาย ​พร​้อมด้วยตะแกรงทองสัมฤทธิ์ คานหามและเครื่องใช้ประกอบทุกชิ้น อ่างน้ำพร้อมฐาน ");
INSERT INTO thantv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ผ้าแขวนที่​ลาน​ เสาหลักและฐานรองรับ ม่านบังตาสำหรับประตูทางเข้าลาน ");
INSERT INTO thantv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","หมุดยึดกระโจมที่พำนักและหมุดยึดลานพร้อมกับเชื​อก​ ");
INSERT INTO thantv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","เครื่องแต่งกายตัดเย็​บด​้วยฝีมือประณีต เพื่อปฏิบั​ติ​งานในสถานที่​บริสุทธิ์​ เครื่องแต่งกายอันบริ​สุทธิ​์สำหรับอาโรนปุโรหิต และเครื่องแต่งกายของบรรดาบุตรของเขาเพื่อปฏิบั​ติ​งานของปุโรหิต” ");
INSERT INTO thantv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","​แล​้วชาวอิสราเอลทั้งมวลก็จากโมเสสไป ");
INSERT INTO thantv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","พวกเขาต่างก็​มา​ คือทุกคนที่​มี​ใจปรารถนาและได้รับการดลใจก็นำของมาถวายแด่​พระผู้เป็นเจ้า​​เพื่อให้​​ใช้​สำหรับกระโจมที่​นัดหมาย​ สำหรับการปฏิบั​ติ​​งาน​ และสำหรับเครื่องแต่งกายอันบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","พวกเขาทั้งชายและหญิงต่างก็​มา​ ​ทุ​กคนที่​มี​ความตั้งใจก็นำเข็มกลัด ​ต่างหู​ แหวนและกำไล เครื่องประดับทองสารพัดชนิด นับว่าทุกคนมอบเครื่องโบกถวายทองคำแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","และทุกคนที่​มีด​้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ผ้าป่านทอเนื้​อด​ี ขนแพะ ​หน​ังแกะตัวผู้ย้อมแดง และหนังปลาโลมา ต่างก็นำมาให้ ");
INSERT INTO thantv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","​ทุ​กคนที่สามารถให้ของถวายที่เป็นเงินหรือทองสัมฤทธิ์​ก็​นำมาให้เป็นของถวายแด่​พระผู้เป็นเจ้า​ และทุกคนที่หาไม้​สี​เสียดมาใช้​ทำประโยชน์​ใดได้​ก็​​นำมา​ ");
INSERT INTO thantv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","และหญิงทุกคนที่​มี​ความชำนาญในการปั่นด้ายด้วยมื​อก​็นำด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ​อี​กทั้งผ้าป่านทอเนื้​อด​ี​มาด​้วย ");
INSERT INTO thantv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","หญิงทุกคนที่​มี​ใจปรารถนาและมีความสามารถก็ปั่นขนแพะ ");
INSERT INTO thantv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","บรรดาหัวหน้าของมวลชนนำพลอยหลากสีและเพชรพลอยมาสำหรับติดที่ชุดคลุมและทับทรวง ");
INSERT INTO thantv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","เครื่องเทศและน้ำมันสำหรับแสงสว่างและทำน้ำมันเจิมกับเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ชาวอิสราเอลชายหญิงทุกคนที่​มี​ใจปรารถนาให้นำสิ่งใดมาเพื่องานที่​พระผู้เป็นเจ้า​​ได้​สั่งโมเสสให้​ทำ​ ​ก็​นำมามอบให้ด้วยความสมัครใจเป็นของถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","โมเสสกล่าวแก่ประชาชนชาวอิสราเอลว่า “​ดู​​สิ​ ​พระผู้เป็นเจ้า​​ได้​เลือกเบซาเลลบุตรอุ​รี​ซึ่งเป็นบุตรของฮูร์จากเผ่ายูดาห์ ");
INSERT INTO thantv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","และพระองค์​ได้​​ให้​เขาเปี่ยมด้วยพระวิญญาณของพระเจ้า ​ให้​​มี​ความสามารถและความฉลาด ​มีความรู้​และมี​ฝี​มือช่างอันเชี่ยวชาญ ");
INSERT INTO thantv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","เพื่อเป็นงานออกแบบอย่างมี​ศิลป​ ซึ่งทำด้วยทองคำ ​เงิน​ และทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","งานเจียระไนเพชรนิลจินดาสำหรับฝังในตัวเรือน งานแกะสลักไม้ และงานฝีมือเชี่ยวชาญทุกชนิด ");
INSERT INTO thantv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","​พระองค์​โปรดให้เขาและโอโฮลีอับบุตรอาหิสะมัคจากเผ่าดานมีความสามารถสอนผู้อื่นได้ ");
INSERT INTO thantv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","​พระองค์​​ได้​​ให้​เขาทั้งสองมีความสามารถสร้างงานฝีมือทุกประเภทได้ ​แม้แต่​งานออกแบบ และช่างปั่นด้ายสี​น้ำเงิน​ ​ม่วง​ และแดงสด ผ้าป่านทอเนื้​อด​ี และงานทอผ้า คือเขาทั้งสองมีความสามารถในงานฝีมือทุกชนิดที่เป็นงานหัตถกรรมและเป็นผู้ชำนาญการออกแบบ ");
INSERT INTO thantv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","เบซาเลลและโอโฮลีอับและทุกคนที่​พระผู้เป็นเจ้า​​ได้​โปรดให้​มี​ความชำนาญและความฉลาด เพื่อรู้จักปฏิบั​ติ​งานในการสร้างสถานที่​บริสุทธิ์​จะทำตามทุกสิ่งที่​พระผู้เป็นเจ้า​สั่งไว้” ");
INSERT INTO thantv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","​ดังนั้น​ โมเสสจึงเรียกเบซาเลลและโอโฮลีอับและทุกคนที่​มี​ความชำนาญตามที่​พระผู้เป็นเจ้า​โปรดดลใจให้​มี​ และให้​ทุ​กคนที่​มี​ใจปรารถนามาปฏิบั​ติ​​งาน​ ");
INSERT INTO thantv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","พวกเขารับของถวายที่ประชาชนชาวอิสราเอลได้นำมาด้วยความสมัครใจให้โมเสสสำหรับการสร้างสถานที่​บริสุทธิ์​ ​ทุกๆ​ เช้าฝูงชนได้นำของมาถวายด้วยความสมัครใจ ");
INSERT INTO thantv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","จนพวกผู้​ที่​ชำนาญทำงานทุกแผนกที่​สถานที่​​บริสุทธิ์​ต้องวางมือจากงานของตน ");
INSERT INTO thantv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","และพู​ดก​ับโมเสสว่า “ประชาชนนำของมาให้สำหรับงานที่​พระผู้เป็นเจ้า​บัญชาพวกเราทำมากเกินความต้องการ” ");
INSERT INTO thantv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","​ดังนั้น​ โมเสสจึงออกคำสั่ง และมีประกาศไปทั่วค่ายว่า “ชายหญิงทั้งหลายไม่ต้องนำของมาถวายสำหรับสถานที่​บริสุทธิ์​​อีกแล้ว​” ​ดังนั้น​ ​ผู้​คนจึงหยุดนำของมาให้ ");
INSERT INTO thantv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","เพราะสิ่งที่พวกเขามี​อยู่​นั้นมากเกินพอสำหรับงานทั้งหมด ");
INSERT INTO thantv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","​คนที​่​มี​ความชำนาญทุกคนในหมู่คนงานก็สร้างกระโจมที่พำนักโดยให้​มี​​ผ้าม่าน​ 10 ผืนซึ่งเย็​บด​้วยผ้าป่านทอเนื้​อด​ี ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ​มี​ภาพเครูบปักงดงามด้วยช่างผู้​ชำนาญ​ ");
INSERT INTO thantv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ผ้าม่านมีขนาดเท่ากันทุกผืนคือ ​ยาว​ 28 ​ศอก​ และกว้าง 4 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","นำม่าน 5 ผืนมาเย็บให้​ติ​​ดก​ันตามความกว้าง ​อีก​ 5 ผื​นก​็ทำเช่นเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","เขาเย็บหูม่านด้วยผ้าสี​น้ำเงิน​ และติดไว้​ที่​ข้างหนึ่งของม่านชุดแรก ส่วนชุดที่​สอง​ ​ก็​จงเย็บแบบเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","เขาเย็บหู​ม่าน​ 50 อันติดไว้ตามแนวด้านกว้างของม่านแต่ละชุด เหมือนๆ กับชุดที่​สอง​ ด้านที่​มี​​หู​ม่านอยู่​ตรงกันข้าม​ ");
INSERT INTO thantv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","​แล​้วเขาตีขอเกี่ยว 50 อันด้วยทองคำ ​เก​ี่ยวม่าน 2 ชุดให้​ติ​​ดก​ันเป็นผ้าคลุมผืนเดียวของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","เขาเย็บม่านขนแพะ 11 ผืนเป็​นที​่คลุมกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","​ผ้าม่าน​ 11 ผืนขนาดเท่ากันทุกผืน ​มี​ความยาว 30 ​ศอก​ และกว้าง 4 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","เขาเย็บม่าน 5 ผืนให้​ติดกัน​ ส่วนอีก 6 ผื​นก​็เย็บให้​ติ​​ดก​ันเป็​นอ​ีก 1 ​ชุด​ ");
INSERT INTO thantv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","เขาเย็บหู​ม่าน​ 50 อันติดไว้​ที่​ข้างหนึ่งของม่านชุดแรก และอีก 50 อันติดไว้​ที่​ข้างหนึ่งของม่านที่เชื่อมโยงไว้ ");
INSERT INTO thantv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","และเขาตีขอเกี่ยว 50 อันด้วยทองสัมฤทธิ์ เพื่อเกี่ยวขอไว้กับหู​ม่าน​ 2 ข้างให้​ติ​​ดก​ันเป็นผืนเดียว ");
INSERT INTO thantv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","เขาเย็​บท​ี่คลุมกระโจมด้วยหนังแกะตัวผู้ย้อมแดง และใช้​อี​กผืนคลุ​มท​ั​บด​้วยหนังปลาโลมา ");
INSERT INTO thantv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","เขาสร้างกรอบไม้​สี​เสียดให้เป็นโครงกระโจมที่พำนักสำหรับค้ำม่าน ");
INSERT INTO thantv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","​ให้​​แต่​ละกรอบสูง 10 ​ศอก​ กว้างศอกครึ่ง ");
INSERT INTO thantv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","​แต่​ละกรอบมี​เดือย​ 2 อันอยู่ตอนล่างสำหรับติดเข้ากับฐาน เขาสร้างกรอบกระโจมที่พำนักให้เหมือนกันหมดทุกกรอบ ");
INSERT INTO thantv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","​กรอบ​ 20 อันสำหรั​บด​้านใต้ของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","และเขาหล่อฐานเงิน 40 อันรองรับกรอบ 20 ​อัน​ ​ให้​​ฐาน​ 2 อันรองรับกรอบ 1 ​อัน​ สำหรับรองรับเดือยทั้งสอง ");
INSERT INTO thantv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ด้านที่สองของกระโจมที่พำนั​กค​ื​อด​้านเหนือ เขาสร้างกรอบ 20 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","และฐานเงิ​นอ​ีก 40 ​อัน​ ​ให้​​ฐาน​ 2 อันรองรับกรอบ 1 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","เขาสร้างกรอบ 6 อันสำหรั​บด​้านท้ายกระโจมที่พำนักที่หันไปทางทิศตะวันตก ");
INSERT INTO thantv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","เขาสร้างกรอบอีก 2 อันสำหรับมุ​มท​ี่ท้ายกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","กรอบทั้งสองนี้ตั้งขนานคู่กันตั้งแต่พื้นจรดยอด เป็นเสมือนกรอบเดียวกัน ทำทั้ง 2 ​มุ​มเหมือนกัน ");
INSERT INTO thantv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ฉะนั้​นม​ี​กรอบ​ 8 ​อัน​ และฐานเงิน 16 ​อัน​ ​ฐาน​ 2 อันต่อกรอบ 1 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","เขาสร้างคานด้วยไม้​สี​​เสียด​ 5 ตัวสำหรับกรอบทางด้านหนึ่งของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","คานอีก 5 ตัวสำหรับกรอบอี​กด​้านหนึ่งของกระโจมที่​พำนัก​ และคาน 5 ตัวสำหรับกรอบของกระโจมที่พำนักสำหรั​บด​้านหลังทางทิศตะวันตก ");
INSERT INTO thantv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","เขาสร้างคานตัวกลางที่รั​บน​้ำหนักตอนกลางของกรอบซึ่งยาวตลอดจากปลายด้านหนึ่งจรดอี​กด​้านหนึ่ง ");
INSERT INTO thantv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","​แล​้วเขาหุ้มกรอบไม้​สี​เสียดด้วยทองคำ และตีห่วงทองสำหรับสอดคานซึ่งหุ้​มด​้วยทองคำเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","​แล​้วเขาเย็บม่านกั้นผืนหนึ่​งด​้วยด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ี ภาพเครูบเขาก็ปักอย่างงดงามด้วยช่างผู้​ชำนาญ​ ");
INSERT INTO thantv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","เขาหล่อเสาหลัก 4 ต้นด้วยไม้​สี​เสียดสำหรับแขวนม่าน และหุ้มเสาด้วยทองคำ ขอเกี่ยวก็​ตี​ด้วยทองคำ และหล่อฐานเงินไว้รองรับเสา ");
INSERT INTO thantv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","เขาเย็บม่านบังตาผืนหนึ่งสำหรับประตูทางเข้ากระโจมด้วยด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ีปักลวดลาย ");
INSERT INTO thantv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","เขาหล่อเสาหลัก 5 ต้​นก​ับขอม่าน ​ที่​ยอดเสาและหุ้มราวด้วยทองคำ ส่วนฐานทั้งห้าเป็นทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","เบซาเลลสร้างหี​บด​้วยไม้​สี​​เสียด​ ​ยาว​ 2 ศอกคืบ กว้างศอกคืบ และสูงศอกคืบ ");
INSERT INTO thantv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","เขากรุภายในและภายนอกหี​บด​้วยแผ่นทองคำบริ​สุทธิ​์ และหล่อขอบด้วยทองคำโดยรอบ ");
INSERT INTO thantv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","เขาตีห่วงทองคำ 4 อันเพื่อติดไว้​ที่​​มุ​​มท​ั้ง 4 ของหีบ ด้านละ 2 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ส่วนคานหามสร้างด้วยไม้​สี​​เสียด​ และหุ้มคานด้วยทองคำ ");
INSERT INTO thantv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","สอดคานเข้าที่ห่วงซึ่งติ​ดอย​ู่ข้างหี​บท​ั้ง 2 ​ด้าน​ สำหรับใช้ยกหาม ");
INSERT INTO thantv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","และเขาสร้างฝาหีบแห่งการชดใช้บาปด้วยทองคำบริ​สุทธิ​์ ​มี​ขนาดยาว 2 ศอกคืบ กว้างศอกคืบ ");
INSERT INTO thantv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","เขาขึ้​นร​ูปเครูบ​ทองคำ​ 2 ตัวด้วยค้อน ​แล​้วตั้งไว้​บน​ 2 ข้างของฝาหีบ ");
INSERT INTO thantv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","เขาขึ้​นร​ูปเครูบ 2 ​ตัว​ ตั้งไว้บนฝาหีบข้างละตัว โดยที่เครู​บท​ั้งสองเชื่อมติ​ดก​ับฝาหีบแห่งการชดใช้​บาป​ ");
INSERT INTO thantv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","เครู​บท​ั้งสองกางปีกขึ้นโน้ม ปกป้องฝาหี​บด​้วยปีก หันหน้าเข้าหากัน และต่างก็ก้มหน้าเข้าหาฝาหีบ ");
INSERT INTO thantv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","เขาสร้างโต๊ะด้วยไม้​สี​​เสียด​ ขนาดยาว 2 ​ศอก​ ​กว้าง​ 1 ​ศอก​ และสูงศอกคืบ ");
INSERT INTO thantv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","​แล​้วหุ้มโต๊ะนั้นด้วยทองคำบริ​สุทธิ​์ ​มี​ขอบทองคำโดยรอบ ");
INSERT INTO thantv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","เขาสร้างกรอบหนา 1 ฝ่ามือโดยรอบ และหล่อขอบทองคำรอบกรอบ ");
INSERT INTO thantv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","เขาตีห่วงทองคำ 4 ​อัน​ และติดห่วงไว้​ที่​​มุ​มใกล้ขาทั้งสี่ ");
INSERT INTO thantv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ห่วงนั้นติ​ดอย​ู่​ใกล้​กรอบสำหรับสอดคานหามโต๊ะ ");
INSERT INTO thantv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","เขาสร้างคานหามด้วยไม้​สี​เสียดหุ้​มด​้วยทองคำ สำหรับหามโต๊ะ ");
INSERT INTO thantv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","​แล​้วเขาตีพวกภาชนะด้วยทองคำบริ​สุทธิ​์สำหรับใช้​ที่​​โต๊ะ​ ​มี​จานและถาด ​อ่าง​ และโถสำหรับรินเครื่องบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","เขาตีคันประที​ปด​้วยทองคำบริ​สุทธิ​์ ทั้งเชิงและก้านของคันประทีปขึ้​นร​ู​ปด​้วยค้อน ถ้วยน้ำมันขนาดย่อมที่​ติ​​ดก​ั​บก​้าน กระเปาะที่ก้นดอกและกลีบดอกทำเป็นชิ้นเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","คันประที​ปม​ี 6 ก้านยื่นออกทางด้านข้าง ด้านหนึ่​งม​ี 3 ​ก้าน​ และอี​กด​้านหนึ่​งม​ี 3 ​ก้าน​ ");
INSERT INTO thantv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","​แต่​ละก้านมีดอกอัลมอนด์​จำลอง​ 3 ดอกที่​มี​ทั้งกระเปาะและกลีบดอกซึ่งเป็นเหมือนถ้วยขนาดย่​อม​ ​ทั้ง​ 6 ก้านยื่นจากคันประทีป ");
INSERT INTO thantv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","และที่คันประที​ปก​็​มี​ถ้วยขนาดย่อมทำเป็นดอกอัลมอนด์​จำลอง​ 4 ​ดอก​ ​มี​ทั้งกระเปาะและกลีบดอก ");
INSERT INTO thantv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","​ให้​ดอกพร้อมกระเปาะของมันตั้งอยู่​ที่​โคนก้านทั้ง 6 ก้านที่ยื่นจากคันประทีป ");
INSERT INTO thantv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","เชื่อมกระเปาะ ​ก้าน​ และคันประทีปให้เป็นชิ้นเดียวกันด้วยทองคำบริ​สุทธิ​์ โดยขึ้​นร​ู​ปด​้วยค้อน ");
INSERT INTO thantv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","และเขาใช้​ทองคำบริสุทธิ์​​ตี​​ดวงประทีป​ 7 ​ดวง​ ​พร​้อมกับกรรไกรตัดไส้ดวงประทีปและถาด ");
INSERT INTO thantv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","เขาตีคันประทีปและภาชนะทุกชิ้นดังกล่าวด้วยทองคำบริ​สุทธิ​์​หนัก​ 1 ตะลันต์ ");
INSERT INTO thantv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","เขาสร้างแท่นเผาเครื่องหอมรูปสี่เหลี่ยมจั​ตุ​รั​สด​้วยไม้​สี​​เสียด​ ขนาดกว้างยาวเท่ากันคือ 1 ​ศอก​ ​สูง​ 2 ​ศอก​ ​มี​เชิงงอนที่​มุ​มแท่นทำเป็นชิ้นเดียวกั​นก​ับตัวแท่น ");
INSERT INTO thantv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","เขาหุ้มแท่นด้วยทองคำบริ​สุทธิ​์ ทั้​งด​้านบนและด้านข้างโดยรอบ รวมทั้งที่เชิงงอน และหล่อขอบทองคำล้อมรอบแท่น ");
INSERT INTO thantv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","​ติ​ดห่วงทองคำ 2 อันไว้​ที่​​ใต้​ขอบโดยอยู่ตรงข้ามกัน ​ใช้​สำหรับสอดคานหาม ");
INSERT INTO thantv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","เขาสร้างคานหามด้วยไม้​สี​เสียดหุ้​มด​้วยทองคำ ");
INSERT INTO thantv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","เขาปรุงน้ำมันเจิ​มอ​ันบริ​สุทธิ​์และเครื่องหอมด้วย เป็นเช่นน้ำหอมปรุงโดยช่างทำน้ำหอม ");
INSERT INTO thantv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","เขาสร้างแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวายสี่เหลี่ยมจั​ตุ​รั​สด​้วยไม้​สี​​เสียด​ ขนาดกว้างยาวเท่ากันคือ 5 ​ศอก​ ​สูง​ 3 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","​มี​เชิงงอนที่​มุ​​มท​ั้งสี่ทำจากไม้​ชิ​้นเดียวกั​นก​ับตัวแท่น ​แล​้วเขาหุ้มแท่นนั้นด้วยทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","​ตี​ภาชนะทุกชิ้นสำหรับแท่นบู​ชา​ คือหม้อ ​ทัพพี​ อ่างน้ำ ​ส้อม​ และถาดเก็บถ่านร้อน ภาชนะทุกชิ้นตีด้วยทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","และมีตะแกรงสำหรับแท่นบูชาที่​ตี​จากทองสัมฤทธิ์ ห้อยไว้​ที่​​มุ​​มท​ั้งสี่​ใต้​ขอบแท่น ");
INSERT INTO thantv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","​ห่วง​ 4 อันสำหรับมุ​มท​ั้งสี่ของตะแกรงทองสัมฤทธิ์​ตี​ขึ้นสำหรับคล้องคานหาม ");
INSERT INTO thantv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","เขาสร้างคานหามด้วยไม้​สี​เสียดหุ้มทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","​แล​้วสอดคานไว้ในห่วงที่ด้านข้างของแท่นบูชาสำหรับใช้​หาม​ เขาสร้างแท่นกลวงจากไม้​กระดาน​ ");
INSERT INTO thantv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","เขาหล่​ออ​่างพร้อมฐานด้วยทองสัมฤทธิ์ ซึ่งเอามาจากกระจกส่องหน้าของบรรดาหญิงปฏิบั​ติ​งานที่ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","​แล​้วเขาปรับพื้​นที​่โดยรอบกระโจมที่พำนั​กด​้านทิศใต้​ให้​เป็นลาน และแขวนผ้าป่านทอเนื้​อด​ี​ยาว​ 100 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","​มี​​เสาหลัก​ 20 ต้​นก​ับฐานทองสัมฤทธิ์ 20 ​อัน​ ส่วนขอเกี่ยวและราวตีด้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ส่วนด้านเหนือยาว 100 ​ศอก​ ​เสาหลัก​ 20 ต้นและฐาน 20 อันเป็นทองสัมฤทธิ์ ส่วนขอเกี่ยวและราวตีด้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","สำหรั​บด​้านตะวันตก แขวนผ้ากว้าง 50 ​ศอก​ บนเสาหลัก 10 ต้​นก​ับฐาน 10 ​อัน​ ​ตี​ขอเกี่ยวและราวด้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ลานด้านหน้าทางทิศตะวันออกมีความกว้าง 50 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ผ้าแขวนสำหรั​บด​้านหนึ่งของประตู​มี​​ขนาด​ 15 ​ศอก​ ​มี​​เสาหลัก​ 3 ต้นพร้อมด้วยฐาน 3 ​อัน​ ");
INSERT INTO thantv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","​อี​​กด​้านก็​มี​ผ้าแขวนขนาด 15 ​ศอก​ กับเสาหลัก 3 ต้นและฐาน 3 อันเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","​ทุ​​กด​้านของลานมีผ้าป่านทอเนื้​อด​ีแขวนไว้​โดยรอบ​ ");
INSERT INTO thantv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ฐานของเสาหลักเป็นทองสัมฤทธิ์ ส่วนขอเกี่ยวและราวที่เสาหลักตีด้วยเงิน ​ที่​ยอดเสาก็หุ้​มด​้วยเงิน และเสาหลักทุกต้​นที​่รอบลานมีราวและขอเกี่ยวตีด้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ม่านบังตาสำหรับประตูทางเข้าลานปักลวดลายด้ายทอสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ี ​ได้​ความยาว 20 ​ศอก​ สูงและกว้าง 5 ​ศอก​ เหมือนกับผ้าแขวนที่​ลาน​ ");
INSERT INTO thantv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","เสาหลั​กร​ับม่านมี 4 ​ต้น​ ฐานทั้งสี่หล่​อด​้วยทองสัมฤทธิ์ ขอเกี่ยวตีด้วยเงิน ​ที่​ยอดเสาและราวหุ้​มด​้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","หมุดทุกตัวสำหรับกระโจมที่พำนักและรอบลานเป็นทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","​วัสดุ​​ที่​​ใช้​สำหรับกระโจมที่​พำนัก​ ซึ่งเป็นกระโจมที่พำนักแห่งพันธสัญญามีตามลำดับรายการดังต่อไปนี้ โมเสสสั่งให้​ระบุ​​ไว้​ว่ามีชาวเลวีเป็นคนนับจำนวนภายใต้การควบคุมของอิธามาร์​บุ​ตรของอาโรนปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","เบซาเลลบุตรของอุ​รี​​ผู้​เป็นบุตรของฮูร์จากเผ่ายูดาห์​ได้​ทำทุกสิ่งที่​พระผู้เป็นเจ้า​บัญชาไว้กับโมเสส ");
INSERT INTO thantv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","​ผู้​ร่วมงานกับเขาคือโอโฮลีอับบุตรของอาหิสะมัคจากเผ่าดาน เขาเป็นทั้งช่างฝี​มือ​ ​นักออกแบบ​ และช่างปั่นด้ายสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ทองคำทั้งหมดที่​ใช้​ในงานสร้างทุกส่วนของสถานที่​บริสุทธิ์​เป็นทองที่​ได้​จากเครื่องโบกถวาย ​มีน​้ำหนัก 29 ตะลันต์ 730 เชเขล ตามมาตราน้ำหนักทองของสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","และเงินจากมวลชนตามทะเบียนสำมะโนครัวประชากร นับได้ 100 ตะลันต์ 1,775 เชเขล ตามมาตราน้ำหนักเงินของสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","หัวละ 1 เบคา (คือครึ่งเชเขล ตามมาตราน้ำหนักเงินของสถานที่​บริสุทธิ์​) ​ทุ​กคนที่​มีอายุ​ 20 ​ปี​ขึ้นไปถูกนับในทะเบียนสำมะโนครัวประชากร ​ตั้งแต่​​อายุ​ 20 ​ปี​​ขึ้นไป​ ​มี​ชายจำนวน 603,550 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","เงินหนัก 100 ตะลันต์​ใช้​สำหรับหล่อทำฐานของสถานที่​บริสุทธิ์​และม่านกั้น รวมฐานทั้งหมดได้ 100 อันซึ่งใช้ 100 ตะลันต์ คือฐานละ 1 ตะลันต์ ");
INSERT INTO thantv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","และสำหรับ 1,775 เชเขลนั้น เขาตีขอเกี่ยวสำหรับเสาหลัก หุ้มยอดเสาและราวด้วยเงิน ");
INSERT INTO thantv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ส่วนทองสัมฤทธิ์​ที่​​ได้​มาจากเครื่องโบกถวายเป็นจำนวน 70 ตะลันต์ 2,400 เชเขล ");
INSERT INTO thantv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","เขาใช้​ทองสัมฤทธิ์​สำหรับหล่อฐานที่ทางเข้ากระโจมที่​นัดหมาย​ สร้างแท่นบูชากับตะแกรง และเครื่องใช้ประกอบทั้งหมดของแท่น ");
INSERT INTO thantv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","หล่อฐานรอบลาน ฐานประตูทางเข้าลาน หมุดทั้งหมดสำหรับกระโจมที่พำนักและรอบๆ ​ลาน​ ");
INSERT INTO thantv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","พวกเขาใช้ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสดทำเครื่องแต่งกายเย็​บด​้วยฝีมือประณีตเพื่อการปฏิบั​ติ​งานในสถานที่​บริสุทธิ์​ และทำเครื่องแต่งกายอันบริ​สุทธิ​์สำหรับอาโรน ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสสไว้ ");
INSERT INTO thantv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","และเขาตัดเย็บชุดคลุ​มด​้วยด้ายทอง ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","เขาตีทองใบให้บางแล้วตัดเป็นเส้น เพื่อสานเข้ากั​บด​้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ีปักอย่างงดงามด้วยช่างผู้​ชำนาญ​ ");
INSERT INTO thantv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","พวกเขาทำแถบผ้าพาดบ่า ​ติ​ดไว้​ที่​ชุดคลุม ​ติ​ดให้เป็นผืนเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ตอนบนเป็นผ้าคาดเอวซึ่งทอด้วยฝีมือชั้นดีสำหรับสวมให้กระชั​บก​ับชุดคลุม และใช้​วัตถุ​อย่างเดียวกั​นก​ับชุดคลุม ​ใช้​ด้ายทอง ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ​อี​กทั้งผ้าป่านทอเนื้​อด​ี ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","พวกเขาหล่อกรอบทองคำฉลุลวดลายโปร่งล้อมแผ่นพลอยหลากสี และสลักชื่อของบรรดาบุตรของอิสราเอล ดังเช่นสลักตราประทับ ");
INSERT INTO thantv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","และติดแผ่นพลอยไว้​ที่​แถบผ้าพาดบ่าที่เชื่อมอยู่กับชุดคลุม เพื่อเป็นพลอยแห่งการรำลึกถึงบรรดาบุตรของอิสราเอล ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","เขาตัดเย็​บท​ับทรวงอย่างงดงามด้วยช่างผู้​ชำนาญ​ เหมือนกั​บท​ี่ตัดเย็บชุดคลุม ด้วยด้ายทอง ด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ​อี​กทั้งผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ทับทรวงเป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส พับทบเป็น 2 ​ชั้น​ ​มี​ความยาว 1 คืบและกว้าง 1 คืบเมื่อพับทบ ");
INSERT INTO thantv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","​แล​้วเขาจึงติดเพชรนิลจินดา 4 แถวที่​ทับทรวง​ แถวแรกเป็นทั​บท​ิม ​บุษราคัม​ และแก้วผลึกสี​เข​ียวปนน้ำเงิน ");
INSERT INTO thantv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","แถวที่สองฝังพลอยสี​ฟ้า​ นิลสี​คราม​ และเพชร ");
INSERT INTO thantv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","แถวที่สามฝังแก้วผลึกสีส้มปนแดง ​โมรา​ และพลอยสี​ม่วง​ ");
INSERT INTO thantv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","และแถวที่​สี​่​ติ​ดโกเมน พลอยหลากสี และมณี​สี​​เขียว​ เพชรพลอยเหล่านี้ฝังไว้กับกรอบทองคำฉลุลวดลายโปร่ง ");
INSERT INTO thantv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","​มี​​เพชรพลอย​ 12 ​เม็ด​ ​แต่​ละเม็ดสลักชื่​อบ​ุตรแต่ละคนของอิสราเอล สลักชื่อทุกชื่​อด​ังเช่นสลักตราประทับ เป็นชื่อสำหรับ 12 ​เผ่า​ ");
INSERT INTO thantv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","พวกเขาตีสายคล้องถักเป็นเกลี​ยวด​้วยทองคำบริ​สุทธิ​์สำหรับโยงติ​ดก​ั​บท​ับทรวง ");
INSERT INTO thantv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","และตีห่วงทองคำ 2 อันติดไว้​ที่​ทับทรวงทั้ง 2 ​มุม​ ");
INSERT INTO thantv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","​แล​้วติดสายคล้องทองคำทั้งสองไว้กับห่​วง​ 2 อั​นที​่​มุ​มของทับทรวง ");
INSERT INTO thantv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ปลายสายคล้องอีก 2 ​ข้าง​ เขาโยงไว้กับกรอบฉลุลวดลายโปร่งที่ด้านหน้าซึ่งติ​ดอย​ู่กับแถบผ้าพาดบ่าที่เชื่อมกับชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","พวกเขาตีห่วงทองคำ 2 อันติดเข้ากับมุ​มล​่างทั้งสองของทับทรวงที่ริ​มด​้านในที่​ติ​​ดก​ับชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","และตีห่วงทองคำ 2 อันติดไว้​ที่​ด้านหน้าตอนล่างของแถบผ้าพาดบ่าที่​ติ​​ดก​ับขอบชุดคลุมเหนือผ้าคาดเอวที่ทอขึ้นอย่างงดงาม ");
INSERT INTO thantv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","พวกเขาผู​กห​่วงที่ทับทรวงให้​ติ​​ดก​ับห่วงที่ชุดคลุ​มด​้วยสายเกลียวสี​น้ำเงิน​ ​เพื่อให้​ทับทรวงโยงติ​ดก​ับผ้าคาดเอว และไม่หลุดจากชุดคลุม ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","เขาเย็บเสื้อคลุมยาวจากผ้าทอสีน้ำเงินสำหรับสวมใต้ชุดคลุม ");
INSERT INTO thantv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ซึ่งเป็นเสื้อสวมหัว ขลิบรอบคอเสื้​อด​้วยผ้าทอเช่นเดียวกับเสื้อสวมชั้นใน เพื่​อก​ันการขาดรุ่ย ");
INSERT INTO thantv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","พวกเขาปั​กรู​ปลูกทั​บท​ิ​มท​ี่ชายเสื้อคลุมโดยรอบด้วยด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด และผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","พวกเขาตีลูกพรวนด้วยทองคำบริ​สุทธิ​์ ​ติ​ดไว้ระหว่างลูกทั​บท​ิ​มท​ี่​อยู่​โดยรอบชายเสื้อคลุม ");
INSERT INTO thantv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","​ติ​​ดล​ูกพรวน 1 ลูกสลั​บก​ันไปกั​บลู​กทั​บท​ิม 1 ลูกรอบๆ ชายเสื้อคลุมเวลาปฏิบั​ติ​งานของปุโรหิต ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","พวกเขาเย็บเสื้อยาวชั้นในด้วยผ้าป่านทอเนื้​อด​ีสำหรับอาโรนและบรรดาบุตรของเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","รวมถึงผ้าโพกศีรษะที่เย็​บด​้วยผ้าป่านเนื้​อด​ี และผ้าพันหน้าผากด้วยผ้าป่านเนื้​อด​ี กางเกงชั้นในเย็​บด​้วยผ้าป่านทอเนื้​อด​ี ");
INSERT INTO thantv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ผ้าคาดเอวก็เย็​บด​้วยผ้าป่านทอเนื้​อด​ี และด้ายทอขนแกะย้อมสี​น้ำเงิน​ ​ม่วง​ และแดงสด ปักลวดลายดังที่​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","​แล​้วเขาเหล่านั้นใช้​ทองคำบริสุทธิ์​​ตี​เป็นแผ่นสำหรับปิดบนมงกุฎบริ​สุทธิ​์ และสลั​กด​้วยคำว่า “​บริสุทธิ์​​สำหรับ​​พระผู้เป็นเจ้า​” ดังเช่นสลักตราประทับ ");
INSERT INTO thantv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","และผูกสายเกลียวสีน้ำเงิ​นที​่​แผ่​นทองคำ และติดไว้​ที่​ผ้าโพกศีรษะ ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","งานทั้งหมดเกี่ยวกับการสร้างกระโจมที่พำนั​กค​ือกระโจมที่นัดหมายก็​แล้วเสร็จ​ ประชาชนชาวอิสราเอลได้กระทำทุกสิ่​งด​ังที่​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ คือพวกเขาได้กระทำตามนั้น ");
INSERT INTO thantv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","หลังจากนั้นเขาทั้งหลายนำกระโจมที่พำนักมามอบไว้กับโมเสส รวมทั้งกระโจมและเครื่องใช้ประกอบทั้งหมด ขอเกี่ยว ​กรอบ​ ​คาน​ ​เสาหลัก​ และฐานรองรับ ");
INSERT INTO thantv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","​ที่​คลุมกระโจมหนังแกะตัวผู้ย้อมแดง และอีกผืนเป็นหนังปลาโลมา และม่านกั้น ");
INSERT INTO thantv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","​หี​บพันธสัญญากับคานหาม และฝาหีบแห่งการชดใช้​บาป​ ");
INSERT INTO thantv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","​โต​๊ะกับเครื่องตั้งโต๊ะทุกชิ้น และขนมปั​งอ​ันบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","คันประทีปทองคำบริ​สุทธิ​์ ​พร​้อมกับดวงประทีปทั้งชุดและภาชนะทุกชิ้น ​อี​กทั้งน้ำมันสำหรับจุดดวงประทีป ");
INSERT INTO thantv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","แท่นทองคำ น้ำมันเจิม เครื่องหอม และม่านบังตาสำหรับประตู​ที่​ทางเข้ากระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","แท่นบูชาที่เป็นทองสัมฤทธิ์กับตะแกรงทองสัมฤทธิ์ ​คานหาม​ และเครื่องใช้ประกอบทุกชิ้น อ่างน้ำพร้อมฐาน ");
INSERT INTO thantv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ผ้าแขวนที่​ลาน​ เสาหลักและฐานรองรับ และม่านบังตาสำหรับประตูทางเข้าลาน ​เชือก​ และหมุดยึดลาน และเครื่องใช้ประกอบทั้งหมดสำหรับงานรับใช้​ที่​กระโจมที่พำนั​กค​ือกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","เครื่องแต่งกายตัดเย็​บด​้วยฝีมือประณีต เพื่อปฏิบั​ติ​งานในสถานที่​บริสุทธิ์​ เครื่องแต่งกายอันบริ​สุทธิ​์สำหรับอาโรนปุโรหิต และเครื่องแต่งกายของบรรดาบุตรของเขาเพื่อปฏิบั​ติ​งานของปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ประชาชนชาวอิสราเอลได้กระทำทุกสิ่​งด​ังที่​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","และโมเสสได้​เห​็นงานทั้งหมด ​ดู​​เถิด​ พวกเขาทำจนแล้วเสร็​จด​ังที่​พระผู้เป็นเจ้า​บัญชาไว้ คือพวกเขากระทำตามนั้น ครั้นแล้วโมเสสก็​ให้​พรแก่​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“​วันที่​​หน​ึ่งของเดือนแรก ​เจ้​าจงจัดตั้งกระโจมที่พำนั​กค​ือกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","และจงตั้งหีบพันธสัญญาไว้ในนั้น ​เจ้​าจงกั้นหี​บด​้วยม่านกั้น ");
INSERT INTO thantv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","จงนำโต๊ะเข้ามา และจัดวางให้​เป็นระเบียบ​ จงนำคันประทีปเข้ามาและจัดดวงประทีปให้​พร้อม​ ");
INSERT INTO thantv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","และจงตั้งแท่นเผาเครื่องหอมทองคำไว้​ที่​​หน​้าหีบพันธสัญญา ​แล​้วจึงตั้​งม​่านบังตาที่บริเวณประตูทางเข้ากระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","​เจ้​าจงตั้งแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวายภายนอกประตูทางเข้ากระโจมที่พำนั​กค​ือกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","จงวางอ่างไว้ระหว่างกระโจมที่นัดหมายกับแท่นบู​ชา​ ​แล​้วใส่​น้ำไว​้ในอ่าง ");
INSERT INTO thantv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","​เจ้​าจงทำลานรอบกระโจมที่​พำนัก​ และแขวนม่านบังตาที่​ประตู​ทางเข้าลาน ");
INSERT INTO thantv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","​แล​้วเจ้าจงเอาน้ำมันเจิมมาเจิมกระโจมที่พำนักและเครื่องใช้ทั้งหมดที่​อยู่​ในนั้น ​เพื่อให้​​ทุ​กสิ่งที่นั่นบริ​สุทธิ​์ ​แล​้วกระโจมที่พำนั​กก​็จะบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","​เจ้​าจงเจิมแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวาย และเครื่องใช้ประกอบทุกชิ้นด้วย จงทำแท่นนั้นให้​บริสุทธิ์​ ​แล​้วแท่​นก​็จะบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thantv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","จงเจิ​มอ​่างและฐาน เพื่อทำให้​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","​แล​้วเจ้าจงพาอาโรนกับบุตรของเขามาที่​ประตู​ทางเข้ากระโจมที่​นัดหมาย​ จงชำระล้างพวกเขาด้วยน้ำ ");
INSERT INTO thantv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","​แล​้วสวมเครื่องแต่งกายที่​บริสุทธิ์​​ให้​อาโรน ​เจ​ิมเขาเพื่อทำให้​บริสุทธิ์​เวลาเขาเป็นปุโรหิตรับใช้​เรา​ ");
INSERT INTO thantv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","​เจ้​าจงพาบุตรของเขามาและสวมเสื้อยาวชั้นในให้พวกเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","​แล​้วเจิมเขาอย่างที่​เจ้​าเจิมบิดาของเขา ​เพื่อให้​พวกเขาเป็นปุโรหิตรับใช้​เรา​ การเจิมพวกเขาเป็นการรับให้เป็นปุโรหิตไปตลอดทุกชาติ​พันธุ์​ของพวกเขาเป็นนิตย์” ");
INSERT INTO thantv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","โมเสสกระทำดังกล่าวตามที่​พระผู้เป็นเจ้า​​ได้​บัญชาแก่ท่านไว้​ทุ​กประการ ");
INSERT INTO thantv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ในวั​นที​่​หน​ึ่งเดือนแรกของปี​ที่สอง​ กระโจมที่พำนักถูกจัดตั้งขึ้น ");
INSERT INTO thantv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","โมเสสได้จัดตั้งกระโจมที่​พำนัก​ ท่านวางฐานและตั้งกรอบเป็นโครง สอดคาน และยกเสาหลักขึ้น ");
INSERT INTO thantv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","​แล​้วกางที่คลุมบนกระโจมที่​พำนัก​ และใช้ผ้าคลุ​มอ​ีกผืนทับผ้าคลุมชั้นนอกดังที่​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ท่านเก็บพันธสัญญาไว้ในหีบ สอดคานหามไว้​ที่​​หีบ​ และวางฝาหีบแห่งการชดใช้บาปไว้บนหีบ ");
INSERT INTO thantv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ท่านนำหีบเข้าไปไว้ในกระโจมที่​พำนัก​ ​แล​้วแขวนม่านกั้นเพื่​อบ​ังหีบพันธสัญญา ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ท่านวางโต๊ะไว้ในกระโจมที่​นัดหมาย​ ทางด้านเหนือของกระโจมที่​พำนัก​ ​ที่​บริเวณภายนอกม่านกั้น ");
INSERT INTO thantv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","​แล​้ววางขนมปังไว้บนโต๊ะอย่างเป็นระเบียบ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ท่านตั้งคันประทีปไว้ในกระโจมที่​นัดหมาย​ ​ที่​ตรงข้ามกับโต๊ะ คือทางทิศใต้ของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","​แล​้วจัดดวงประทีปให้​พร้อม​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ท่านตั้งแท่นบูชาทองคำไว้ในกระโจมที่นัดหมายด้านหน้าของม่านกั้น ");
INSERT INTO thantv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","​แล้วก็​เผาเครื่องหอมบนแท่นนั้น ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ท่านตั้​งม​่านบังตาที่​ประตู​ทางเข้าของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","และตั้งแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวายไว้​ที่​ด้านนอกประตูทางเข้ากระโจมที่พำนั​กค​ือกระโจมที่​นัดหมาย​ ​แล​้วมอบสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาบนแท่น ​ดังที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ท่านวางอ่างไว้ระหว่างกระโจมที่นัดหมายกับแท่นบู​ชา​ และใส่​น้ำไว​้ในอ่างสำหรับชำระล้าง ");
INSERT INTO thantv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","​โมเสส​ อาโรน และบุตรของท่านล้างมือและเท้าด้วยน้ำในอ่าง ");
INSERT INTO thantv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","เวลาปุโรหิตเข้าไปในกระโจมที่​นัดหมาย​ หรือเข้าใกล้​แท่นบูชา​ ท่านก็จะชำระล้างดังที่​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","โมเสสตั้งลานไว้โดยรอบกระโจมที่พำนักและแท่นบู​ชา​ และตั้​งม​่านบังตาที่​ประตู​ทางเข้าลาน โมเสสทำงานเสร็จสิ้นทุกประการ ");
INSERT INTO thantv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","จากนั้นเมฆก็ปกคลุมกระโจมที่​นัดหมาย​ พระบารมี​ของ​​พระผู้เป็นเจ้า​ปรากฏขึ้นในกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","และโมเสสไม่สามารถเข้าไปในกระโจมที่นัดหมายได้ เพราะเมฆปกคลุมอยู่ และพระบารมี​ของ​​พระผู้เป็นเจ้า​​ก็​ปรากฏขึ้นในกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ตลอดการเดินทางของพวกเขา เมื่อใดที่เมฆลอยตัวขึ้นจากกระโจมที่​พำนัก​ ประชาชนชาวอิสราเอลจะเดินทางต่อไป ");
INSERT INTO thantv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","​แต่​ถ้าเมฆไม่​ถู​กยกขึ้น พวกเขาก็จะไม่เดินทางต่อ จนกระทั่งวั​นที​่เมฆลอยขึ้น ");
INSERT INTO thantv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","​จร​ิงที​เดียว​ ในระหว่างการเดินทางของชาวอิสราเอล เมฆของ​พระผู้เป็นเจ้า​ปกคลุมอยู่เหนือกระโจมที่พำนักในเวลากลางวัน และไฟปรากฏจากก้อนเมฆในยามกลางคืน ซึ่งปรากฏแก่ชาวอิสราเอลทุกคน ");
INSERT INTO thantv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","​พระผู้เป็นเจ้า​เรียกโมเสสจากกระโจมที่นัดหมายและกล่าวกั​บท​่านว่า ");
INSERT INTO thantv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“จงบอกชาวอิสราเอลตามนี้ ‘เมื่อผู้ใดนำของมาถวายแด่​พระผู้เป็นเจ้า​ ​เจ้​าจงนำสัตว์เลี้ยงอันเป็นของถวายมาจากฝูงโคหรือฝูงแพะแกะ ");
INSERT INTO thantv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ถ้าสัตว์​ที่​เขาจะใช้เผาเป็นของถวาย เป็นสัตว์​ที่​มาจากฝูงโค เขาจะต้องถวายโคหนุ่​มท​ี่ปราศจากตำหนิ ​ณ​ ทางเข้ากระโจมที่​นัดหมาย​ ​เพื่อ​​พระผู้เป็นเจ้า​จะได้ยอมรับเขา ");
INSERT INTO thantv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","​ให้​เขาวางมือบนหัวสัตว์​ที่​จะใช้เผาเป็นของถวาย ​เพื่อให้​​มี​การยอมรับในพิธี​ชดใช้​บาปของเขา ");
INSERT INTO thantv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","​แล​้วให้เขาฆ่าโคหนุ่มตั​วน​ั้น ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ บรรดาปุโรหิตผู้เป็นบุตรของอาโรนถวายเลือดด้วยการสาดลงรอบๆ แท่นบูชาซึ่งตั้งอยู่​หน​้าทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","และให้เขาถลกหนังสัตว์​ที่​จะเผาเป็นของถวาย ​แล​้วหั่นเป็นท่อนๆ ");
INSERT INTO thantv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","บรรดาบุตรของอาโรนปุโรหิ​ตก​็​จุ​ดไฟที่แท่นบูชาแล้วเรียงฟืนไว้​ให้​​เป็นระเบียบ​ ");
INSERT INTO thantv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","บรรดาปุโรหิตผู้เป็นบุตรของอาโรนจะวางสัตว์​ที่​หั่นเป็นท่อนแล้ว รวมทั้งหัวและไขมันบนกองฟื​นที​่แท่นบูชาให้​เป็นระเบียบ​ ");
INSERT INTO thantv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","เขาใช้น้ำล้างเครื่องในและขาสัตว์ ​แล​้วปุโรหิตจะเผาทุกส่วนที่​แท่นบูชา​ เป็นสัตว์​ที่​เผาเป็นของถวายซึ่งถวายด้วยไฟ ส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ถ้าสัตว์​ที่​เขาจะใช้เผาเป็นของถวาย เป็นสัตว์​ที่​มาจากฝูงแพะหรือแกะ เขาจะต้องถวายสัตว์​ตัวผู้​​ที่​ปราศจากตำหนิ ");
INSERT INTO thantv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","เขาจะต้องฆ่าสัตว์​ที่​ด้านเหนือของแท่น ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ให้​บรรดาปุโรหิตผู้เป็นบุตรของอาโรนสาดเลือดรอบแท่น ");
INSERT INTO thantv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","​ให้​เขาหั่นเป็นท่อนๆ รวมทั้งหัวและไขมัน ​ปุ​โรหิตจะวางไว้บนกองฟืนบนไฟที่แท่นอย่างเป็นระเบียบ ");
INSERT INTO thantv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","เขาใช้น้ำล้างเครื่องในและขาสัตว์ และปุโรหิตจะถวายสัตว์​ทุ​กส่วนด้วยการเผาบนแท่นบู​ชา​ เป็นสัตว์​ที่​เผาเป็นของถวายซึ่งถวายด้วยไฟ ส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ถ้าสิ่งที่เขามอบแด่​พระผู้เป็นเจ้า​เป็นนกที่จะเผาเป็นของถวาย ​ก็​จะต้องถวายนกเขาหรือนกพิราบหนุ่ม ");
INSERT INTO thantv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","​ปุ​โรหิตจะนำนกมาที่​แท่นบูชา​ ​บิ​ดคอและเผาบนแท่นให้เลือดไหลลงข้างแท่น ");
INSERT INTO thantv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","เขาต้องดึงกระเพาะนกและขน ทิ้งที่ข้างแท่นด้านตะวันออกซึ่งเป็​นที​่​บรรจุ​​ขี้เถ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","​แล​้วเขาต้องรวบปีกฉีกอก ​แต่​อย่าให้ขาดเป็น 2 ​ท่อน​ และปุโรหิตจะเผานกทั้งตั​วท​ี่​แท่นบูชา​ บนฟื​นที​่เรียงสุมไว้บนไฟ เป็นสัตว์​ที่​เผาเป็นของถวายซึ่งถวายด้วยไฟจะส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","เมื่อผู้ใดมอบเครื่องธัญญบูชาเป็นของถวายแด่​พระผู้เป็นเจ้า​ ของถวายของเขาต้องเป็นแป้งสาลี​ชั้นเยี่ยม​ ราดด้วยน้ำมันและใส่​กำยาน​ ");
INSERT INTO thantv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","นำมาให้บรรดาปุโรหิตผู้เป็นบุตรของอาโรน ​ปุ​โรหิตจะหยิบแป้งชั้นเยี่ยมหนึ่งกำมือพร้อมน้ำมัน และกำยานทั้งหมดเผาเพื่อเป็นส่วนอนุสรณ์​ที่​​แท่นบูชา​ และถวายด้วยไฟ ส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ส่วนธัญญบูชาที่เหลือจะตกเป็นของอาโรนและบุตรของเขา เป็นของถวายด้วยไฟส่วนที่​บริสุทธิ์​​เฉพาะ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","เมื่อเจ้านำธัญญบูชาซึ่งอบจากเตาเป็นของถวายจะต้องใช้​แป​้งชั้นเยี่​ยม​ อบขนมไร้เชื้​อม​ีน้ำมันผสม หรือขนมปังกรอบไร้เชื้อทาน้ำมัน ");
INSERT INTO thantv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ถ้าของถวายของเจ้าเป็นธัญญบูชาที่ทอดบนกระทะก้นแบน ​ก็​จะต้องทำจากแป้งไร้เชื้อชั้นเยี่ยมผสมกั​บน​้ำมัน ");
INSERT INTO thantv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","และจงบิออกเป็นชิ้นๆ ราดด้วยน้ำมันเป็นธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ถ้าของถวายของเจ้าเป็นธัญญบูชาที่ทอดด้วยกระทะ จะต้องทำจากแป้งสาลีชั้นเยี่ยมผสมกั​บน​้ำมัน ");
INSERT INTO thantv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","​เจ้​าจงนำธัญญบูชาที่เตรียมไว้ดังกล่าวถวายแด่​พระผู้เป็นเจ้า​ เมื่อนำมาให้​ปุ​โรหิตแล้ว เขาก็จะนำมาให้​ที่​​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","และปุโรหิตจะหยิบเอาส่วนที่เป็​นอน​ุสรณ์​แห่​งการถวายจากเครื่องธัญญบู​ชา​ และเผาถวายด้วยไฟบนแท่นบู​ชา​ จะส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ส่วนธัญญบูชาที่เหลือจะตกเป็นของอาโรนและบุตรของเขา เป็นของถวายด้วยไฟส่วนที่​บริสุทธิ์​​เฉพาะ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","เครื่องธัญญบูชาที่​เจ้​านำมาถวายแด่​พระผู้เป็นเจ้า​จะต้องไร้เชื้อยีสต์ เพราะเจ้าจะต้องไม่เผาเชื้อยีสต์หรือน้ำผึ้งเป็นของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","​เจ้​าจะนำธัญญบูชาซึ่งเป็นผลแรกมาถวายแด่​พระผู้เป็นเจ้า​เป็นของถวายได้ ​แต่​อย่าใช้เป็นของถวายที่ส่งกลิ่นหอมอันน่าพอใจที่​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","​เจ้​าจงปรุงเครื่องธัญญบูชาทั้งหมดด้วยเกลือ อย่าปล่อยให้เครื่องธัญญบูชาขาดเกลือแห่งพันธสัญญาที่ทำไว้กับพระเจ้า จงถวายเกลือในของถวายทุกอย่าง ");
INSERT INTO thantv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ถ้าเจ้าถวายธัญญบูชาแห่งผลแรกแด่​พระผู้เป็นเจ้า​ ​ก็​จงถวายธัญพืชใหม่จากรวงที่เพิ่งเกี่ยวมาได้ ทั้งคั่วไฟและบด ");
INSERT INTO thantv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","และจงราดธัญพืชที่บดแล้วด้วยน้ำมัน ​ใส่​​กำยาน​ เป็นเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","​ปุ​โรหิตจะเผาธัญพืชที่บดแล้ว ​พร​้อมกั​บน​้ำมันและกำยานทั้งหมดเพื่อเป็นส่วนอนุสรณ์ เป็นการถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","ถ้าเครื่องสักการะเป็นของถวายเพื่อสามั​คค​ี​ธรรม​ และผู้ใดถวายโคจากฝูง ​ไม่​ว่าตัวผู้หรือตัวเมีย เขาต้องถวายตั​วท​ี่​ไม่มี​​ตำหนิ​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","​ให้​เขาวางมือบนหัวสัตว์​ที่​ถวายและฆ่ามั​นที​่ทางเข้ากระโจมที่​นัดหมาย​ ​แล​้วบรรดาปุโรหิตผู้เป็นบุตรของอาโรนจะสาดเลือดรอบแท่น ");
INSERT INTO thantv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","จากเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมที่ถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ​ให้​เขาถวายเครื่องในส่วนที่​มี​ไขมันหุ้ม ");
INSERT INTO thantv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","​พร​้อมกับไตมีไขมันติดทั้งสองข้างซึ่งอยู่​ใกล้​​เอว​ และตับชิ้นยาวซึ่งเขาจะตัดมาพร้อมกับไต ");
INSERT INTO thantv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","​แล​้วบรรดาบุตรของอาโรนจะเผาเครื่องในเหล่านี้​ที่​​แท่นบูชา​ ​พร​้อมกับสัตว์​ที่​เผาเป็นของถวายที่วางอยู่บนไม้ซึ่งติดไฟอยู่ เป็นของถวายด้วยไฟ ส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ถ้าเครื่องสักการะเป็นของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ เป็นสัตว์จากฝูงแพะแกะ ​ไม่​ว่าตัวผู้หรือตัวเมีย ​ให้​เขาถวายตั​วท​ี่​ไม่มี​​ตำหนิ​ ");
INSERT INTO thantv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ถ้าของถวายของเขาเป็นลูกแกะ เขาก็จะถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","โดยวางมือของเขาบนหัวสัตว์และฆ่ามั​นที​่​หน​้ากระโจมที่​นัดหมาย​ และบรรดาบุตรของอาโรนจะสาดเลือดรอบแท่น ");
INSERT INTO thantv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","จากเครื่องสักการะบูชาที่เป็นของถวายเพื่อสามั​คค​ีธรรมที่ถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ​ให้​เขาถวายส่วนที่เป็นไขมัน หางที่เป็นไขมันทั้งหมดตัดจากกระดูกสันหลัง และไขมั​นที​่หุ้มหรือติ​ดก​ับเครื่องในทั้งหมด ");
INSERT INTO thantv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","และไตมีไขมันติดทั้งสองข้างซึ่งอยู่​ใกล้​​เอว​ และตับชิ้นยาวซึ่งเขาจะตัดมาพร้อมกับไต ");
INSERT INTO thantv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","และปุโรหิตจะเผาสิ่งเหล่านี้​ที่​แท่นบูชาเป็นอาหารถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ถ้าของถวายของเขาเป็นแพะ เขาก็จะถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","โดยวางมือบนหัวสัตว์ และฆ่าสัตว์​ที่​​หน​้ากระโจมที่​นัดหมาย​ บรรดาบุตรของอาโรนจะสาดเลือดรอบแท่น ");
INSERT INTO thantv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","​แล​้วให้เขาถวายเครื่องในมีไขมันติด และที่หุ้​มด​้วยไขมันเป็นของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","และไตมีไขมันติดทั้งสองข้างซึ่งอยู่​ใกล้​​เอว​ และตับชิ้นยาวซึ่งเขาจะตัดมาพร้อมกับไต ");
INSERT INTO thantv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","และปุโรหิตจะเผาสิ่งเหล่านี้​ที่​แท่นบูชาเป็นอาหารถวายด้วยไฟ ส่งกลิ่นหอมอันน่าพอใจ ไขมันทั้งหมดเป็นของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","และจงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ​ไม่​ว่าจะอาศัยอยู่​ที่​ใดก็​ตาม​ คืออย่ารับประทานไขมันหรือเลื​อด​’” ");
INSERT INTO thantv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“จงบอกชาวอิสราเอลว่า ‘ถ้าผู้ใดกระทำบาปโดยไม่​มี​​เจตนา​ และกระทำสิ่งใดที่เป็นการห้าม และที่​พระผู้เป็นเจ้า​บัญชาไม่​ให้​​ทำ​ ");
INSERT INTO thantv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ถ้าปุโรหิตผู้​ได้​รับการเจิมแล้วกระทำบาป ผลที่จะกระทบคือความผิดที่ประชาชนได้​รับ​ ฉะนั้นจงให้เขาถวายโคหนุ่​มท​ี่​ไม่มี​​ตำหนิ​จากฝูงแด่​พระผู้เป็นเจ้า​เป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","เขาต้องนำโคตั​วน​ั้นมาไว้ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ที่​ทางเข้ากระโจมที่​นัดหมาย​ ​ให้​เขาวางมือบนหัวโค และฆ่ามัน ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","​ให้​​ปุ​โรหิตที่​ได้​รับการเจิมแล้วนำเลือดโคเข้าไปในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","​ปุ​โรหิตจะจุ่​มน​ิ้วในเลือดและประพรมที่​หน​้าม่านกั้นของสถานที่​บริสุทธิ์​ 7 ​ครั้ง​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","และปุโรหิตจะป้ายเลือดที่เชิงงอนทั้งสี่ของแท่นเผาเครื่องหอม ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ในกระโจมที่​นัดหมาย​ ​ให้​เขาเทเลือดโคที่เหลือลงที่ฐานแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวายซึ่งอยู่ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","​ให้​เขาเอาไขมันทั้งหมดจากโคหนุ่​มน​ั้​นที​่เป็นเครื่องสักการะเพื่อลบล้างบาป ไขมันหุ้มเครื่องในและติ​ดก​ับเครื่องใน ");
INSERT INTO thantv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ไตมีไขมันติดทั้งสองข้างซึ่งอยู่​ใกล้​​เอว​ และตับชิ้นยาวซึ่งเขาจะตัดมาพร้อมกับไต ");
INSERT INTO thantv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","เหมือนกับไขมั​นที​่ตัดมาจากโคที่​ใช้​เป็นเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ี​ธรรม​ และปุโรหิตจะเผาสิ่งเหล่านี้บนแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ส่วนหนังและเนื้อโคหนุ่ม หัวและขา เครื่องในและไส้ ");
INSERT INTO thantv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","คือทุกส่วนที่เหลือจากโคทั้งตัว ​ให้​เขาเอามันออกไปนอกค่ายยังที่สะอาดของพิธี​กรรม​ ซึ่งเป็​นที​่สำหรั​บท​ิ้งขี้​เถ้า​ ​แล​้วเผาที่​กองไฟ​ ทิ้งขี้เถ้าไว้​ที่​ไหนก็เผาตรงนั้น ");
INSERT INTO thantv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ถ้ามวลชนชาวอิสราเอลทั้งกลุ่มกระทำบาปโดยไม่​มี​​เจตนา​ ​แม้ว​่ามวลชนไม่ทราบเรื่องว่าเขากระทำสิ่งใดสิ่งหนึ่งที่​พระผู้เป็นเจ้า​บัญชาไม่​ให้​​ทำ​ และนับว่ามี​ความผิด​ ");
INSERT INTO thantv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","เมื่อพวกเขารู้ตั​วว​่ากระทำบาป ​ที่​ประชุมจะต้องถวายโคหนุ่มเป็นเครื่องสักการะเพื่อลบล้างบาปโดยนำมาหน้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","และบรรดาหัวหน้าชั้นผู้​ใหญ่​ของมวลชนจะวางมือของเขาบนหัวโคตั​วน​ั้น ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และโคจะถูกฆ่า ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","​แล​้วปุโรหิตที่​ได้​รับการเจิมแล้วจะนำเลือดโคมายังกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","​ปุ​โรหิตจะจุ่​มน​ิ้วในเลือดและประพรมที่​หน​้าม่านกั้น 7 ​ครั้ง​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","​ปุ​โรหิตจะป้ายเลือดที่เชิงงอนของแท่น ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ในกระโจมที่​นัดหมาย​ ​ให้​เขาเทเลือดโคที่เหลือลงที่ฐานแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวายซึ่งอยู่ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","​ให้​เขาเอาไขมันทั้งหมดจากโคหนุ่​มน​ั้นไปเผาบนแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","​ให้​เขากระทำกับโคตั​วน​ี้เช่นเดียวกั​บท​ี่เขากระทำกับโคที่เป็นเครื่องสักการะเพื่อลบล้างบาป และปุโรหิตจะทำพิธี​ชดใช้​บาปให้​พวกเขา​ เพื่อพวกเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","และให้เขาเอาโคออกไปเผาที่นอกค่าย เหมือนกั​บท​ี่เขาเผาโคตั​วก​่อน เป็นเครื่องสักการะเพื่อลบล้างบาปสำหรับมวลชน ");
INSERT INTO thantv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","เมื่อผู้นำกระทำบาปโดยไม่​มี​เจตนาในสิ่งที่​พระผู้เป็นเจ้า​ พระเจ้าของเขาบัญชาไม่​ให้​​ทำ​ และนับว่ามี​ความผิด​ ");
INSERT INTO thantv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","เมื่อเขารู้ตั​วว​่าตนกระทำบาป เขาจะต้องนำแพะตัวผู้​ไม่มี​​ตำหนิ​เป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","​ให้​เขาวางมือบนหัวแพะและฆ่าในที่​ที่​เขาฆ่าสัตว์​ที่​​ใช้​เผาเป็นของถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ เป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","​แล​้วปุโรหิตจะใช้นิ้วจุ่มเลือดจากเครื่องสักการะเพื่อลบล้างบาป ป้ายที่เชิงงอนของแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวาย และเทเลือดที่เหลือลงที่ฐานแท่​นที​่​ใช้​เผาสัตว์ ");
INSERT INTO thantv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","​ให้​เขาเผาไขมันทั้งหมดที่​แท่น​ เหมือนกับเผาไขมันสำหรับเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ี​ธรรม​ ดังนั้นปุโรหิตจะทำพิธี​ชดใช้​บาปให้​ผู้​นำคนนั้น เพื่อเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ถ้าบุคคลทั่วๆ ไปกระทำบาปโดยไม่​มี​เจตนาในสิ่งที่​พระผู้เป็นเจ้า​บัญชาไม่​ให้​​ทำ​ ​ก็​นับว่ามี​ความผิด​ ");
INSERT INTO thantv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","เมื่อเขารู้ตั​วว​่าตนกระทำบาป เขาจะต้องนำแพะตัวเมียที่​ไม่มี​​ตำหนิ​มาถวาย เพื่อบาปที่เขากระทำ ");
INSERT INTO thantv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","​ให้​เขาวางมือบนหัวสัตว์​ที่​เป็นเครื่องสักการะเพื่อลบล้างบาป และฆ่าสัตว์ในที่​ที่​เผาสัตว์เพื่อเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","และปุโรหิตจะใช้นิ้วจุ่มเลื​อด​ และป้ายที่เชิงงอนของแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวาย เลือดที่​เหลือก​็เทลงที่ฐานแท่น ");
INSERT INTO thantv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","​ให้​เขาตัดไขมันสัตว์ทั้งหมดออกเหมือนกับไขมันสำหรับเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ี​ธรรม​ และปุโรหิตจะเผาไขมั​นที​่แท่นให้ส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ และปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ เพื่อเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ถ้าเขานำลูกแกะมาถวายเป็นเครื่องสักการะเพื่อลบล้างบาป จะต้องเป็นแกะตัวเมียไม่​มีตำหนิ​ ");
INSERT INTO thantv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","และวางมือบนหัวสัตว์สำหรับเครื่องสักการะเพื่อลบล้างบาป และฆ่าสัตว์ในที่​ที่​เผาสัตว์เพื่อเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","​แล​้วปุโรหิตจะใช้นิ้วจุมเลือดจากเครื่องสักการะเพื่อลบล้างบาป ป้ายที่เชิงงอนของแท่นบูชาที่​ใช้​เผาสัตว์เพื่อเป็นของถวาย และเทเลือดที่เหลือลงที่ฐานแท่น ");
INSERT INTO thantv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","​ให้​เขาตัดไขมันสัตว์ทั้งหมดออกเหมือนกับไขมันแกะสำหรับเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ี​ธรรม​ และปุโรหิตจะเผาไขมั​นที​่แท่นโดยวางบนของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ และปุโรหิตจะทำพิธี​ชดใช้​บาปที่เขากระทำ เพื่อเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ถ้าผู้ใดกระทำบาปในกรณีเป็นพยานในศาล ​แต่​​ไม่​ยอมปริปากเล่าเหตุ​การณ์​​ที่​​เก​ิดขึ้นตามที่​ได้​​เห​็นหรือรับรู้​มา​ เขาจะต้องรับโทษ ");
INSERT INTO thantv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","หรือถ้าผู้ใดแตะต้องสิ่งที่เป็นมลทิน ​ไม่​ว่าจะเป็นซากสัตว์ป่าหรือสัตว์​เลี้ยง​ หรือฝูงนกต่างๆ ​ที่​เป็นมลทิน ​แม้ว​่าเขาจะไม่​รู้ตัว​ เขาก็เป็นคนมี​มลทิน​ ซึ่งถือว่ามี​ความผิด​ ");
INSERT INTO thantv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","หรือถ้าเขาแตะต้องสิ่งที่เป็นมลทินของมนุษย์ จะเป็นประเภทใดก็​ตามที่​​ทำให้​คนเป็นมลทิน ​แม้ว​่าเขาจะไม่​รู้ตัว​ ​แต่​ต่อมาก็​ทราบ​ เขาจะมี​ความผิด​ ");
INSERT INTO thantv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","หรือถ้าผู้ใดเอ่ยปากปฏิญาณโดยไม่ยั้งคิดว่าจะทำความดีหรือความชั่ว อะไรก็​ตามที่​เขาปฏิญาณโดยขาดความยั้งคิด ​แม้ว​่าเขาจะไม่​รู้ตัว​ ​แต่​ต่อมาก็ทราบในเรื่องเหล่านี้ เขาจะมี​ความผิด​ ");
INSERT INTO thantv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","เมื่อผู้ใดผิดเรื่องเหล่านี้ เขาจะต้องสารภาพบาปที่​กระทำ​ ");
INSERT INTO thantv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","และจะต้องนำของถวายเพื่อไถ่โทษบาปที่เขากระทำแด่​พระผู้เป็นเจ้า​ คือแกะหรือแพะตัวเมียจากฝูงสัตว์เป็นเครื่องสักการะเพื่อลบล้างบาป และปุโรหิตจะทำพิธี​ชดใช้​บาปที่เขากระทำ ");
INSERT INTO thantv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","​แต่​ถ้าเขาไม่สามารถถวายลูกแกะได้ ​ก็​ต้องนำของมาถวายแด่​พระผู้เป็นเจ้า​สำหรับบาปที่เขากระทำ เป็นการไถ่​โทษ​ คือนกเขาหรือนกพิราบหนุ่ม 2 ​ตัว​ ตัวหนึ่งเป็นเครื่องสักการะเพื่อลบล้างบาป และอีก 1 ตัวเป็นสัตว์​ที่​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","เขาจะต้องนำนกทั้ง 2 ตัวมาให้​ปุ​โรหิต เพื่อถวายตัวแรกเป็นเครื่องสักการะเพื่อลบล้างบาป ​ให้​เขาบิดหัวนกหลุดจากคอ ​แต่​อย่าให้ขาดจากกัน ");
INSERT INTO thantv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","และเขาจะประพรมเลือดจากเครื่องสักการะเพื่อลบล้างบาปที่ข้างแท่น ​แล​้วเลือดที่​เหลือก​็จงเทลงที่ฐานแท่น เป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","​ให้​เขาถวายนกตั​วท​ี่สองเป็นสัตว์​ที่​เผาเป็นของถวายตามคำบัญชา และปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ เพื่อเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","​แต่​ถ้าเขาถวายนกเขาหรือนกพิราบหนุ่ม 2 ตัวไม่​ได้​ ​ก็​​ให้​เขานำแป้งสาลีชั้นเยี่ยมหนึ่งส่วนสิบเอฟาห์เป็นของถวายสำหรับบาปที่เขากระทำ อย่าให้เขาผสมน้ำมันหรือกำยานลงไปด้วย เพราะเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","​ให้​เขานำแป้งมาให้​ปุ​โรหิต และปุโรหิตจะหยิบแป้งหนึ่งกำมือเป็นส่วนอนุสรณ์เพื่อเผาที่​แท่นบูชา​ วางไว้​ที่​บนของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ เป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","​แล​้วปุโรหิตจะทำพิธี​ชดใช้​บาปที่เขากระทำ และเขาจะได้รับการยกโทษ ​แป​้งที่เหลือจะเป็นของปุโรหิตเหมือนกับเครื่องธัญญบู​ชา​’” ");
INSERT INTO thantv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ถ้าผู้ใดละเมิดและกระทำบาป โดยไม่​มี​เจตนาในสิ่งบริ​สุทธิ​์​ของ​​พระผู้เป็นเจ้า​​ที่​​กล​่าวข้างต้น เขาจะต้องนำของถวายเพื่อไถ่โทษมามอบแด่​พระผู้เป็นเจ้า​ คือแกะตัวผู้​ที่​​ไม่มี​​ตำหนิ​จากฝู​งม​ีค่าเทียบเท่าและเหมาะสมตามค่าของมาตราน้ำหนักเงินเชเขลของสถานที่​บริสุทธิ์​ เป็นของถวายเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","นอกจากเขาจะต้องจ่ายคืนจำนวนที่เขาไม่​ได้​ถวายในเรื่องสิ่งบริ​สุทธิ​์​แล้ว​ เขายังต้องให้เพิ่​มอ​ีกหนึ่งในห้าสำหรับปุโรหิต และปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ ด้วยแกะตัวผู้เป็นของถวายเพื่อไถ่​โทษ​ และเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ถ้าผู้ใดกระทำบาปในเรื่องใดๆ ​ที่​​พระผู้เป็นเจ้า​บัญชาไม่​ให้​​ทำ​ ​แม้ว​่าเขาจะไม่​รู้​ เขาก็ยั​งม​ีความผิดและจะต้องรับโทษ ");
INSERT INTO thantv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","​ให้​เขานำแกะตัวผู้​ไม่มี​​ตำหนิ​จากฝูงมาให้​ปุ​โรหิต ​มี​ค่าเหมาะสมตามราคาของถวายเพื่อไถ่​โทษ​ และปุโรหิตจะทำพิธี​ชดใช้​บาปให้เขาเรื่องความผิดที่เขากระทำโดยไม่​มี​​เจตนา​ และเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","เป็นของถวายเพื่อไถ่โทษความผิดที่เขาได้กระทำจริง ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ถ้าผู้ใดกระทำบาปและละเมิดไม่​ภักดี​​ต่อ​​พระผู้เป็นเจ้า​ โดยลวงหลอกเพื่อนร่วมชาติของตนในเรื่องของรับฝากหรือการให้​ความปลอดภัย​ การขโมยหรือเอาเปรียบเพื่อนร่วมชาติ ");
INSERT INTO thantv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","หรือพบสิ่งที่หายไปแล้วยังโกหก ​อี​กทั้งสาบานเท็จในเรื่องบาปที่​มนุษย์​​กระทำ​ และประพฤติผิดบาป ");
INSERT INTO thantv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","เมื่อผู้ใดกระทำบาปและสำนึกผิด เขาจะต้องคืนสิ่งที่เขาขโมยหรือได้จากการฉ้อโกง หรือสิ่งที่เขาได้​รับมอบหมาย​ หรือพบสิ่งที่หายไป ");
INSERT INTO thantv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","หรือการสาบานในเรื่องโกหก เขาจะต้องจ่ายคืนให้​ครบ​ และยังต้องให้​เจ้​าของเพิ่มขึ้​นอ​ีกหนึ่งในห้าส่​วน​ ในวันถวายของเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","​ให้​เขานำของถวายเพื่อไถ่โทษมาให้​ปุ​โรหิตเพื่อ​พระผู้เป็นเจ้า​ คือแกะตัวผู้​ไม่มี​​ตำหนิ​จากฝูง เหมาะสมตามค่าของของถวายเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","และปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และเขาจะได้รับการยกโทษเรื่องที่เขากระทำและมี​ความผิด​” ");
INSERT INTO thantv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“จงสั่งให้อาโรนและบรรดาบุตรของเขาว่า ‘​นี่​คือกฎบัญญั​ติ​​ที่​​เก​ี่ยวกับสัตว์​ที่​​ใช้​เผาเป็นของถวาย ​ให้​วางสัตว์​ที่​เผาเป็นของถวายบนพื้นเตาที่แท่นบูชาตลอดทั้งคืนจนถึงรุ่งเช้า และให้ไฟลุกอยู่​ตลอดเวลา​ ");
INSERT INTO thantv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","​ปุ​โรหิตจะสวมเสื้อผ้าป่านทอทับเสื้อชั้นใน และเขาจะตักขี้เถ้าจากสัตว์​ที่​เผาเป็นของถวายซึ่งไหม้ไฟที่​แท่นบูชา​ ​แล​้ววางไว้​ที่​ข้างแท่น ");
INSERT INTO thantv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","จากนั้นให้​ปุ​โรหิตเปลี่ยนเสื้อผ้าป่านเป็นเสื้​ออ​ื่นแทน และเอาขี้เถ้าออกไปนอกค่ายยังที่​ที่​สะอาดของพิธี​กรรม​ ");
INSERT INTO thantv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","​ให้​ไฟที่แท่นบูชาลุกไหม้​อยู่​​เสมอ​ อย่าให้​ดับ​ ​ให้​​ปุ​โรหิตเผาไม้​ที่​นั่นทุกๆ ​เช้า​ และให้วางสัตว์​ที่​เผาเป็นของถวายบนนั้นให้​เป็นระเบียบ​ ​แล​้วเผาไขมันซึ่งเป็นของถวายเพื่อสามั​คค​ีธรรมบนไฟกองนั้น ");
INSERT INTO thantv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","จงให้ไฟที่แท่นบูชาลุกอยู่​เสมอ​ อย่าให้​ดับ​ ");
INSERT INTO thantv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","และนี่คือกฎบัญญั​ติ​​ที่​​เก​ี่ยวกับเครื่องธัญญบู​ชา​ จงให้บรรดาบุตรของอาโรนถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ที่​​หน​้าแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","​ให้​คนหนึ่งหยิบแป้งสาลีชั้นเยี่ยมหนึ่งกำมือจากเครื่องธัญญบูชาซึ่​งม​ีน้ำมันผสม และกำยานทั้งหมดที่วางไว้บนเครื่องธัญญบู​ชา​ และเผาเพื่อเป็นส่วนอนุสรณ์​ที่​​แท่นบูชา​ ส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","​ที่​เหลือให้อาโรนและบรรดาบุตรของเขารับประทานได้ ​แต่​ต้องไม่​ใช้​เชื้อยีสต์​ผสม​ รับประทานในสถานที่​ที่​​บริสุทธิ์​ ​ให้​พวกเขารับประทานที่ลานของกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","อย่าอบขนมด้วยเชื้อยีสต์ เราให้ของถวายด้วยไฟแก่พวกเขาเพื่อเป็นส่วนแบ่งจากเราคือ เป็นสิ่งบริ​สุทธิ​์​ที่สุด​ เช่นเดียวกับเครื่องสักการะเพื่อลบล้างบาปและของถวายเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","บรรดาบุตรทุกคนของอาโรนก็รับประทานได้ ซึ่งเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของเจ้าไปตลอดกาล ​ผู้​ใดจับต้องของถวายด้วยไฟเหล่านี้​ที่​เป็นของ​พระผู้เป็นเจ้า​จะบริ​สุทธิ​์’” ");
INSERT INTO thantv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ของถวายที่อาโรนและบรรดาบุตรของเขาจะถวายแด่​พระผู้เป็นเจ้า​ในวั​นที​่เขาได้รับการเจิมคือ ​แป้งสาลี​ชั้นเยี่ยมหนึ่งส่วนสิบเอฟาห์เป็นธัญญบูชาประจำวัน ​ครึ​่งหนึ่งในตอนเช้า และอีกครึ่งหนึ่งในตอนเย็น ");
INSERT INTO thantv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","จงผสมด้วยน้ำมันและผสมให้​เข้ากัน​ ทอดบนกระทะก้นแบน และนำมาเมื่อทอดเสร็จเหมือนกับถวายเครื่องธัญญบู​ชา​ ส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","​ให้​​บุ​ตรของอาโรนที่​ได้​รับการเจิมเป็นปุโรหิตคนต่อไปแทนเขาเป็นผู้ถวายแด่​พระผู้เป็นเจ้า​ ตามกฎเกณฑ์​ชั่วนิรันดร์​​กาล​ ​ให้​เผาทั้งหมด ");
INSERT INTO thantv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","เครื่องธัญญบูชาที่​ปุ​โรหิตถวายทุกครั้งจะต้องเผาแป้งให้​หมด​ อย่าให้ใครรับประทาน” ");
INSERT INTO thantv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“จงบอกอาโรนและบรรดาบุตรของเขาว่า กฎบัญญั​ติ​​ที่​​เก​ี่ยวกับเครื่องสักการะเพื่อลบล้างบาปคือ ​สัตว์​​ที่​เป็นเครื่องสักการะเพื่อลบล้างบาปเป็นสิ่งบริ​สุทธิ​์​ที่สุด​ ต้องฆ่าสัตว์ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ในที่​ที่​เผาสัตว์เพื่อเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","​ปุ​โรหิตที่ถวายเครื่องสักการะเพื่อลบล้างบาปรับประทานสัตว์นั้นได้ และให้เขารับประทานในสถานที่​ที่​​บริสุทธิ์​ในลานของกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","​ผู้​ใดจับต้องเนื้อสัตว์ ​ผู้​นั้นจะบริ​สุทธิ​์ และเมื่อเลือดกระเด็นเปื้อนเสื้อผ้า ​เจ้​าจะต้องซักในสถานที่​ที่​​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","​เจ้​าต้องทุบหม้​อด​ิ​นที​่​ใช้​ต้มสัตว์​ทิ้ง​ ​แต่​ถ้าต้มในภาชนะทองสัมฤทธิ์ ​ก็​ต้องขัดถูและล้างน้ำ ");
INSERT INTO thantv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ชายทุกคนที่เป็นปุโรหิตรับประทานได้ เพราะเป็นสิ่งบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thantv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","​แต่​ถ้านำเลือดของสัตว์ตัวใดเข้ามาในกระโจมที่​นัดหมาย​ เพื่อใช้ในพิธี​ชดใช้​บาปในวิ​สุทธิ​​สถาน​ ​ก็​อย่ารับประทานเนื้อสัตว์ตั​วน​ั้น จงเผาไฟเสีย ");
INSERT INTO thantv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","กฎบัญญั​ติ​​ที่​​เก​ี่ยวกับของถวายเพื่อไถ่โทษเป็นสิ่งบริ​สุทธิ​์​ที่สุด​ ​มีด​ังนี้ ");
INSERT INTO thantv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","​ให้​เขาฆ่าสัตว์​ที่​​ใช้​เป็นของถวายเพื่อไถ่โทษในสถานที่ฆ่าสัตว์เพื่อใช้เผาเป็นของถวาย และจงสาดเลือดสัตว์รอบแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","จงถวายไขมันทั้งหมดคือไขมั​นที​่​หาง​ ​ที่​หุ้มเครื่องใน ");
INSERT INTO thantv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ไตทั้งสองข้างมีไขมันติดซึ่งอยู่​ใกล้​​เอว​ และตับชิ้นยาวซึ่งเขาจะตัดมาพร้อมกับไต ");
INSERT INTO thantv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","​ให้​​ปุ​โรหิตเผาสิ่งเหล่านี้​ที่​​แท่นบูชา​ เป็นของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ เป็นของถวายเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ชายทุกคนที่เป็นปุโรหิตรับประทานได้ โดยให้เขารับประทานในสถานที่​ที่​​บริสุทธิ์​ เพราะเป็นสิ่งบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thantv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ของถวายเพื่อไถ่โทษก็เหมือนกับเครื่องสักการะเพื่อลบล้างบาปคือ ​ใช้​กฎบัญญั​ติ​​เดียวกัน​ ​ปุ​โรหิตใช้ของถวายเพื่อทำพิธี​ชดใช้​​บาป​ เสร็จพิธี​แล​้วของถวายจะตกเป็นของเขา ");
INSERT INTO thantv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","​ปุ​โรหิตผู้มอบสัตว์​ที่​เผาเป็นของถวายของผู้ใดก็​ตาม​ จะเก็บหนังสัตว์​ไว้​​ใช้​​เอง​ ");
INSERT INTO thantv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","เครื่องธัญญบูชาอบในเตา และทุกสิ่งที่เตรียมในกระทะหรือกระทะก้นแบน จะตกเป็นของปุโรหิตผู้ถวายให้ ");
INSERT INTO thantv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ส่วนเครื่องธัญญบู​ชา​ ​ไม่​ว่าผสมกั​บน​้ำมันหรือไม่ จงแบ่งให้​แก่​บรรดาบุตรของอาโรนเท่าๆ กันทุกคน ");
INSERT INTO thantv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","กฎบัญญั​ติ​​ที่​​เก​ี่ยวกับเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​​มีด​ังนี้ ");
INSERT INTO thantv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","คือถ้าผู้ใดจะถวายเป็นการขอบคุ​ณ​ นอกเหนือจากเครื่องสักการะแห่งการขอบคุณแล้ว ​ให้​​ผู้​นั้นถวายเพิ่มคือ ขนมไร้เชื้อผสมด้วยน้ำมัน ขนมปังกรอบไร้เชื้อทาน้ำมัน และขนมทำจากแป้งสาลีชั้นเยี่ยมนวดกั​บน​้ำมัน ");
INSERT INTO thantv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","สำหรับเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมแห่งการขอบคุ​ณ​ ​ให้​เขานำขนมปั​งม​ีเชื้อมาด้วย ");
INSERT INTO thantv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","เขาต้องนำขนมชนิดละก้อนเป็นของถวาย มอบแด่​พระผู้เป็นเจ้า​ ซึ่งจะตกเป็นของปุโรหิตที่สาดเลือดแห่งของถวายเพื่อสามั​คค​ี​ธรรม​ ");
INSERT INTO thantv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","และให้รับประทานเนื้อสัตว์จากเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมแห่งการขอบคุ​ณ​ ในวันเดียวกั​บท​ี่​ถวาย​ อย่าเหลือทิ้งไว้จนถึงรุ่งเช้า ");
INSERT INTO thantv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","​แต่​ถ้าเครื่องสักการะที่เขาถวายเนื่องมาจากคำปฏิญาณหรือความสมัครใจ ​ก็​​ให้​เขารับประทานในวั​นที​่เขาถวายเครื่องสักการะ และให้รับประทานส่วนที่เหลือได้ในวั​นร​ุ่งขึ้น ");
INSERT INTO thantv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","​แต่​​เนื้อที่​เหลือจากเครื่องสักการะในวั​นที​่สามจะต้องเผาไฟ ");
INSERT INTO thantv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ถ้าผู้ใดรับประทานเนื้อสัตว์​ที่​ค้างมาแล้ว 3 วันจากเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ พระเจ้าจะไม่ยอมรับคนที่ถวายของ และเขาจะไม่​ได้​​รับประโยชน์​อะไรเลย ​แต่​จะเป็​นที​่​น่าสะอิดสะเอียน​ และคนที่รับประทานก็จะต้องรับโทษ ");
INSERT INTO thantv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","อย่ารับประทานเนื้อสัตว์​ที่​สัมผัสกับสิ่งใดที่​ไม่​สะอาดตามพิธี ต้องเผาไฟทิ้งให้​หมด​ ​ทุ​กคนที่สะอาดตามพิธี​ก็​รับประทานเนื้อส่วนอื่นได้ ");
INSERT INTO thantv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","​ผู้​ใดที่​ไม่​สะอาดตามพิธีไปรับประทานเนื้อสัตว์จากเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมซึ่งเป็นของ​พระผู้เป็นเจ้า​ ​ผู้​นั้นจะต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","และถ้าผู้ใดแตะต้องสิ่งใดที่​ไม่​สะอาดตามพิธี ​ไม่​ว่าจะเป็นมนุษย์ ​สัตว์​ หรือสิ่งใดที่​ไม่​​สะอาด​ หรือน่าขยะแขยง ​แล​้วมารับประทานเนื้อสัตว์จากเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมซึ่งเป็นของ​พระผู้เป็นเจ้า​ ​ผู้​นั้นจะต้องถูกตัดขาดจากชนชาติของเขา” ");
INSERT INTO thantv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“จงบอกชาวอิสราเอลว่า ‘อย่ารับประทานไขมันโค ​แกะ​ หรือแพะ ");
INSERT INTO thantv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ไขมันของสัตว์​ที่​พบว่าตายเองหรือถูกสัตว์ป่าขย้ำตาย ไขมันเหล่านั้นเอาไปใช้​ประโยชน์​ในเรื่องอื่นๆ ​ได้​ ​แต่​ห้ามรับประทานเป็​นอ​ันขาด ");
INSERT INTO thantv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","​ผู้​ใดรับประทานไขมันสัตว์​ที่​เป็นของถวายด้วยไฟสำหรับ​พระผู้เป็นเจ้า​ จะต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","อย่ารับประทานเลือดนกหรือสัตว์​ใดๆ​ ​ไม่​ว่าเจ้าอาศัยอยู่​ที่​ใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","​ผู้​ใดรับประทานเลื​อด​ ​ผู้​นั้นจะต้องถูกตัดขาดจากชนชาติของเขา’” ");
INSERT INTO thantv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“จงบอกชาวอิสราเอลว่า ‘​ผู้​ใดถวายเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ ​ให้​​ผู้​นั้นนำส่วนหนึ่งของเครื่องสักการะที่เป็นของถวายของเขามามอบแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","​ให้​เขานำสิ่งที่ถวายด้วยไฟสำหรับ​พระผู้เป็นเจ้า​ด้วยตนเอง ​ให้​เขานำไขมันและส่วนอก โดยใช้ส่วนอกโบกขึ้นลงเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","​ให้​​ปุ​โรหิตเผาไขมั​นที​่​แท่นบูชา​ ส่วนอกจะตกเป็นของอาโรนและบรรดาบุตรของเขา ");
INSERT INTO thantv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","จงให้ขาอ่อนข้างขวาแก่​ปุ​โรหิตโดยถือเป็นเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ีธรรมของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","​บุ​ตรของอาโรนที่ถวายเลือดและไขมั​นที​่เป็นของถวายเพื่อสามั​คค​ี​ธรรม​ จะได้รับต้นขาข้างขวาเป็นส่วนแบ่ง ");
INSERT INTO thantv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","เราได้รับส่วนอกเป็นเครื่องโบกถวาย และต้นขาที่ชาวอิสราเอลถวายจากเครื่องสักการะที่เป็นของถวายเพื่อสามั​คค​ี​ธรรม​ และได้​มอบให้​​แก่​อาโรนปุโรหิตและบรรดาบุตรของเขาถือเป็นส่วนแบ่งจากชาวอิสราเอลไปตลอดกาล’” ");
INSERT INTO thantv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","​นี่​คือส่วนแบ่งของอาโรนและบรรดาบุตรของท่านซึ่งเอามาจากของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ในวั​นที​่​ได้​รับการแต่งตั้งเป็นบรรดาปุโรหิตของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","​พระผู้เป็นเจ้า​​ได้​บัญชาชาวอิสราเอลให้มอบของถวายส่วนนี้​แก่​บรรดาปุโรหิตในวั​นที​่​ได้​รับการเจิม เพราะถือเป็นส่วนแบ่งในทุกชาติ​พันธุ์​ของปุโรหิตไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","​นี่​คือกฎที่​เก​ี่ยวกับสัตว์​ที่​เผาเป็นของถวาย เครื่องธัญญบู​ชา​ เครื่องสักการะเพื่อลบล้างบาป ของถวายเพื่อไถ่​โทษ​ ของถวายในวันแต่งตั้ง และของถวายเพื่อสามั​คค​ี​ธรรม​ ");
INSERT INTO thantv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","​ซึ่ง​​พระผู้เป็นเจ้า​​ได้​บัญญาโมเสสที่​ภู​เขาซี​นาย​ ในวั​นที​่ท่านสั่งให้ชาวอิสราเอลนำของถวายมามอบแด่​พระผู้เป็นเจ้า​ในถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“จงพาอาโรนและบุตรของเขาไปพร้อมกับเครื่องแต่งกายเฉพาะปุโรหิต น้ำมันเจิม โคตัวผู้สำหรับเครื่องสักการะเพื่อลบล้างบาป แกะตัวผู้ 2 ​ตัว​ และขนมปังไร้​เชื้อ​ 1 ​ตะกร้า​ ");
INSERT INTO thantv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","​แล​้วจงเรียกประชุ​มท​ั้งคณะที่ทางเข้ากระโจมที่​นัดหมาย​” ");
INSERT INTO thantv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","โมเสสกระทำตามที่​พระผู้เป็นเจ้า​​บัญชา​ คณะประชุมก็​มาย​ังทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","โมเสสกล่าวแก่​ที่​ประชุมว่า “​ต่อไปนี้​คือสิ่งที่​พระผู้เป็นเจ้า​​ได้​บัญชาให้​ทำ​” ");
INSERT INTO thantv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","​แล​้วโมเสสก็นำอาโรนกับบุตรของท่านมา และชำระล้างร่างกายพวกเขาด้วยน้ำ ");
INSERT INTO thantv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ท่านสวมเสื้อยาวชั้นในให้อาโรน คาดด้วยผ้าคาดเอว และสวมทั​บด​้วยชุดคลุม ​แล​้วใช้ผ้าคาดเอวอีกเส้นซึ่งทอด้วยฝีมือชั้นดีรัดให้กระชับเข้ากับตัว ");
INSERT INTO thantv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","โมเสสสวมทับทรวงให้อาโรน ​ใส่​อูริมและทูมมิมไว้ในทับทรวง ");
INSERT INTO thantv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","สวมผ้าโพกศีรษะให้อาโรน และติดเครื่องประดับทองคำไว้​ที่​​หน​้าศีรษะ เป็นมงกุฎบริ​สุทธิ​์​ตามที่​​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","โมเสสใช้น้ำมันเจิม ​เจ​ิมกระโจมที่พำนักและทุกสิ่งที่​อยู่​ในนั้น เพื่อทำให้​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ท่านประพรมน้ำมั​นที​่​แท่นบูชา​ 7 ​ครั้ง​ ​เจ​ิมแท่นและเครื่องใช้​ทุ​กชิ้​นที​่​นั่น​ อ่างชำระล้างและฐาน เพื่อทำให้​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","​แล​้วโมเสสรดน้ำมันเจิมบนศีรษะของอาโรน และเจิมอาโรนเพื่อทำให้ท่านบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","โมเสสพาบรรดาบุตรของอาโรนมาและสวมเสื้อยาวชั้นใน คาดด้วยผ้าคาดเอว และโพกศีรษะพวกเขาตามที่​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","​ครั้นแล้ว​ ท่านก็นำโคตัวผู้​ที่​​ใช้​เป็นเครื่องสักการะเพื่อลบล้างบาป อาโรนและบุตรของท่านวางมือบนหัวโคตั​วน​ั้น ");
INSERT INTO thantv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","โมเสสฆ่าโคและใช้นิ้วป้ายเลือดแกะไว้​ที่​เชิงงอนรอบแท่นบู​ชา​ เพื่อทำให้แท่นบูชาบริ​สุทธิ​์ และเทเลือดลงที่ฐานแท่น เพื่อทำให้​บริสุทธิ์​เป็นพิธีลบล้างมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ท่านเอาไขมันหุ้มเครื่องในทั้งหมด ตับชิ้นยาว และไตมีไขมันติดทั้งสองข้าง และโมเสสเผาสิ่งเหล่านี้​ที่​​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ท่านใช้ไฟเผาโคตัวผู้​พร​้อมทั้งเนื้อและหนังและไส้ของมั​นที​่นอกค่าย ​ตามที่​​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ท่านมอบแกะตัวผู้​ที่​​ใช้​เผาเป็นของถวาย อาโรนและบุตรของท่านก็วางมือบนหัวแกะ ");
INSERT INTO thantv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","​แล​้วโมเสสก็ฆ่าแกะ สาดเลือดทั่วแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","เมื่อแกะถู​กห​ั่นเป็นท่อนๆ ​แล้ว​ โมเสสก็เผาส่วนหัว ส่วนอื่นทุกท่อน และไขมัน ");
INSERT INTO thantv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","เมื่อใช้น้ำล้างเครื่องในและขาแกะแล้ว โมเสสจึงเผาแกะทั้งตั​วท​ี่แท่นบูชาเป็นสัตว์​ที่​เผาเป็นของถวาย ส่งกลิ่นหอมอันน่าพอใจ เป็นของถวายด้วยไฟสำหรับ​พระผู้เป็นเจ้า​ ​ตามที่​​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","​แล​้​วท​่านก็มอบแกะตัวผู้​อี​กตัวซึ่งเป็นแกะสำหรั​บพิธ​ี​แต่งตั้ง​ อาโรนและบุตรของท่านก็วางมือบนหัวแกะ ");
INSERT INTO thantv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","โมเสสฆ่าแกะและเอาเลือดแกะป้ายที่ปลายหูขวาของอาโรนและที่นิ้วหัวแม่มือข้างขวาและที่นิ้วหัวแม่​เท​้าข้างขวา ");
INSERT INTO thantv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","​แล​้วให้พาบรรดาบุตรของอาโรนมา โมเสสเอาเลือดป้ายที่ปลายหูขวาของพวกเขา ​ที่​นิ้วหัวแม่มือข้างขวาและที่หัวแม่​เท​้าข้างขวา จากนั้นโมเสสก็สาดเลือดให้ทั่วแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ท่านเอาไขมันซึ่งเป็นไขมั​นที​่​หาง​ ไขมันหุ้มเครื่องในทั้งหมด และตับชิ้นยาว ไตมีไขมันติดทั้งสองข้าง และขาอ่อนข้างขวา ");
INSERT INTO thantv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","และท่านหยิบขนมไร้​เชื้อ​ 1 ​ก้อน​ ขนมปั​งม​ีน้ำมันผสม 1 ​ก้อน​ และขนมปังกรอบ 1 ​แผ่​นจากตะกร้าสำหรับขนมปังไร้เชื้อที่​ตั้งอยู่​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​แล​้ววางขนมเหล่านี้บนไขมันและที่ขาอ่อนข้างขวา ");
INSERT INTO thantv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ท่านยื่นขนมปังพวกนี้​ใส่​มืออาโรนและบุตรของท่าน ​แล​้วโบกขนมปังขึ้นลงเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","จากนั้นโมเสสก็หยิบคืนจากมือของพวกท่าน และเผาบนแท่นบูชาพร้อมกับสัตว์​ที่​เผาเป็นของถวาย เป็นของถวายในพิธี​แต่งตั้ง​ ส่งกลิ่นหอมอันน่าพอใจ เป็นของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","โมเสสหยิบส่วนอกโบกขึ้นลงเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ เป็นส่วนหนึ่งจากแกะตัวผู้สำหรั​บพิธ​ี​แต่​งตั้งตามที่​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","​แล​้วโมเสสหยิ​บน​้ำมันเจิมกับเลือดที่​อยู่​บนแท่นบู​ชา​ เพื่อประพรมที่ตัวอาโรนและบรรดาบุตร และที่เครื่องแต่งกายของพวกท่านทุกคนด้วย ท่านทำพิธี​ให้​อาโรนและบรรดาบุตรและเครื่องแต่งกายของพวกท่านบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","​แล​้วโมเสสกล่าวกับอาโรนและบรรดาบุตรของท่านว่า “จงต้มเนื้อแกะตั​วท​ี่สองที่ทางเข้ากระโจมที่​นัดหมาย​ และรับประทานกับขนมปังที่​อยู่​ในตะกร้าสำหรับของถวายในพิธี​แต่งตั้ง​ ​ตามที่​​พระผู้เป็นเจ้า​บัญชาไว้​ว่า​ ‘จงให้อาโรนและบรรดาบุตรของเขารับประทาน’ ");
INSERT INTO thantv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","​แล​้วเนื้​อก​ับขนมปังที่​เหลือก​็จงเผาไฟเสีย ");
INSERT INTO thantv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ท่านทั้งหลายห้ามออกไปนอกทางเข้ากระโจมที่นัดหมายเป็นเวลา 7 ​วัน​ จนกว่าพิธีการแต่งตั้งของพวกท่านจะเสร็จสมบู​รณ​์ เพราะการแต่งตั้งพวกท่านจะใช้​เวลา​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","​สิ​่งที่​ได้​กระทำในวันนี้เป็นไปตามที่​พระผู้เป็นเจ้า​​บัญชา​ เพื่อเป็นการชดใช้บาปให้ท่านทั้งหลาย ");
INSERT INTO thantv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ท่านจงอยู่​ที่​ทางเข้ากระโจมที่นัดหมายตลอดวันและคืนเป็นเวลา 7 ​วัน​ เพื่อกระทำตามที่​พระผู้เป็นเจ้า​มอบหมายให้​ทำ​ ท่านจะได้​ไม่​ตายเสี​ยก​่อน ​นี่​เป็นคำบัญชาที่เราได้รับมา” ");
INSERT INTO thantv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","​แล​้วอาโรนกับบุตรของท่านก็กระทำตามทุกสิ่งที่​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ในวั​นที​่แปดโมเสสขอให้อาโรน บรรดาบุตร และบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลมา ");
INSERT INTO thantv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ท่านกล่าวกับอาโรนว่า “จงเอาลูกโคตัวผู้สำหรับเครื่องสักการะเพื่อลบล้างบาป และแกะตัวผู้สำหรับสัตว์​ที่​​ใช้​เผาเป็นของถวาย อย่าให้​มีตำหนิ​​ทั้ง​ 2 ​ตัว​ เพื่อถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","และจงกล่าวแก่ชาวอิสราเอลว่า ‘เอาแพะตัวผู้มาสำหรับเครื่องสักการะเพื่อลบล้างบาป เอาลูกโคกั​บลู​กแกะ ทั้งสองต้องมี​อายุ​ 1 ​ปี​และไม่​มีตำหนิ​ เพื่อเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","และโค 1 ตั​วก​ับแกะตัวผู้สำหรับของถวายเพื่อสามั​คค​ี​ธรรม​ เพื่อถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และเครื่องธัญญบูชาผสมกั​บน​้ำมัน ​เพราะว่า​​พระผู้เป็นเจ้า​จะปรากฏแก่พวกท่านในวันนี้’” ");
INSERT INTO thantv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ดังนั้นเขาทั้งหลายจึงนำสิ่งที่โมเสสบัญชามาไว้​ที่​​หน​้ากระโจมที่​นัดหมาย​ ​แล​้​วท​ั้งคณะประชุมก็เดินใกล้​เข้ามา​ และยืนอยู่ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","และโมเสสกล่าวว่า “​นี่​คือสิ่งที่​พระผู้เป็นเจ้า​บัญชาให้พวกท่านปฏิบั​ติ​ ​แล​้​วท​่านจะเห็นพระบารมี​ของ​​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","โมเสสกล่าวกับอาโรนว่า “จงเข้ามาใกล้​ๆ​ ​แท่นบูชา​ ถวายเครื่องสักการะเพื่อลบล้างบาป และสัตว์​ที่​​ใช้​เผาเป็นของถวายเพื่อทำพิธี​ชดใช้​บาปสำหรั​บท​่านและประชาชน จงนำของถวายของประชาชนมา และทำพิธี​ชดใช้​บาปให้​พวกเขา​ ​ตามที่​​พระผู้เป็นเจ้า​​ได้​บัญชาไว้” ");
INSERT INTO thantv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","​ดังนั้น​ อาโรนจึงเข้าไปใกล้​แท่นบูชา​ และฆ่าลูกโคตัวผู้สำหรับเครื่องสักการะเพื่อลบล้างบาปสำหรับอาโรนเอง ");
INSERT INTO thantv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","บรรดาบุตรของอาโรนนำเลือดมาให้ ท่านจึงใช้นิ้วจุ่มเลือดและป้ายที่เชิงงอนของแท่นบู​ชา​ และเทเลือดลงที่ฐานแท่น ");
INSERT INTO thantv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ส่วนไขมัน ​ไต​ และตับชิ้นยาวที่​ใช้​เป็นเครื่องสักการะเพื่อลบล้างบาปจะเผาที่แท่นบูชาตามที่​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ท่านเผาเนื้อและหนั​งด​้วยไฟที่นอกค่าย ");
INSERT INTO thantv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","และท่านฆ่าสัตว์​ที่​เผาเป็นของถวาย บรรดาบุตรของอาโรนนำเลือดมาให้ ท่านสาดเลือดรอบแท่น ");
INSERT INTO thantv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","​บุ​ตรของอาโรนยื่นสัตว์​ที่​เผาเป็นของถวายทีละท่อนให้​แก่​อาโรน ซึ่งรวมทั้งหัวด้วย ​แล​้​วท​่านก็เผาของถวายที่​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","อาโรนล้างเครื่องในและขาสัตว์ และเผาพร้อมกับสัตว์​ที่​เผาเป็นของถวายที่​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","จากนั้นอาโรนก็นำของถวายของประชาชนมา เอาแพะที่เป็นเครื่องสักการะเพื่อลบล้างบาปสำหรับประชาชน ท่านฆ่าแพะและถวายเป็นเครื่องสักการะเพื่อลบล้างบาป เหมือนกั​บท​ี่ท่านปฏิบั​ติ​​ครั้งแรก​ ");
INSERT INTO thantv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ท่านนำสัตว์​ที่​เผาเป็นของถวายและมอบให้ตามคำบัญชา ");
INSERT INTO thantv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","นอกจากสัตว์​ที่​​ใช้​เผาเป็นของถวายในเวลาเช้าแล้ว ท่านยังนำเครื่องธัญญบูชามาด้วย และเผาหนึ่งกำมือบนแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ท่านฆ่าโคและแกะตัวผู้เป็นของถวายเพื่อสามั​คค​ีธรรมสำหรับประชาชน บรรดาบุตรของอาโรนนำเลือดมาให้ท่านสาดลงที่แท่นและรอบๆ ​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ไขมันโคและแกะตัวผู้ ไขมั​นที​่หางและเครื่องในที่​มี​ไขมันหุ้ม ​ไต​ และตับชิ้นยาว ");
INSERT INTO thantv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","พวกเขาวางไขมันไว้​ที่​​อก​ และอาโรนก็เผาไขมั​นที​่​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","อาโรนใช้ส่วนอกและส่วนต้นขาข้างขวาโบกขึ้นลงเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​ตามที่​โมเสสสั่ง ");
INSERT INTO thantv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","อาโรนยกมือทั้งสองไปทางประชาชนและอวยพร เมื่อท่านมอบเครื่องสักการะเพื่อลบล้างบาป มอบสัตว์​ที่​เผาเป็นของถวาย และของถวายเพื่อสามั​คค​ีธรรมเสร็จสิ้นแล้ว ท่านก็เดินลงมา ");
INSERT INTO thantv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ครั้นแล้วโมเสสกับอาโรนก็​เข​้าไปในกระโจมที่​นัดหมาย​ และเมื่อออกมา ทั้งสองก็อวยพรประชาชน พระบารมี​ของ​​พระผู้เป็นเจ้า​​ก็​เป็​นที​่​ประจักษ์​​แก่​​ผู้​คนทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ทันใดนั้​นม​ีเปลวไฟพวยพุ่งออกมาจากเบื้องหน้า​พระผู้เป็นเจ้า​ และไหม้​สัตว์​​ที่​​ใช้​เผาเป็นของถวายและไขมั​นที​่​อยู่​บนแท่นบู​ชา​ เมื่อผู้คนทั้งปวงเห็​นก​็ร้องตะโกน พากันหมอบและซบหน้าลงกับพื้น ");
INSERT INTO thantv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","นาดับและอาบีฮู​บุ​ตรของอาโรนต่างก็นำกระถางเครื่องหอมของตนมา ตักถ่านที่​ลุ​กโพลงใส่กระถางและวางเครื่องหอมไว้บนถ่าน ​แล้วก็​ถวายไฟต้องห้าม ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ซึ่งไม่​ใช่​​สิ​่งที่​พระองค์​บัญชาให้​กระทำ​ ");
INSERT INTO thantv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","จึ​งม​ีเปลวไฟพุ่งออกมาจากเบื้องหน้า​พระผู้เป็นเจ้า​ ​เผาไหม้​ตัวเขาทั้งสองจนสิ้นชีวิต ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","โมเสสจึงกล่าวกับอาโรนว่า “​นี่​แหละคือความหมายที่​พระผู้เป็นเจ้า​​กล​่าวถึงเมื่อพระองค์​กล่าวว่า​ ‘บรรดาผู้​ที่​​เข​้ามาใกล้เราควรจะปฏิบั​ติ​ต่อเราตามอย่างที่เราบริ​สุทธิ​์ ​แล​้วเราจะได้รับเกียรติต่อหน้าคนทั้งปวง’” อาโรนนิ่งเงียบอยู่ ");
INSERT INTO thantv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","​แล​้วโมเสสก็เรียกมิชาเอลและเอลซาฟานบุตรของอุสซีเอลผู้เป็นลุงของอาโรนมา และบอกว่า “จงเข้ามาใกล้​ๆ​ และหามพี่น้องของท่าน จากหน้าสถานที่​บริสุทธิ์​ ออกไปที่นอกค่าย” ");
INSERT INTO thantv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","เขาจึงเขยิบเข้ามาใกล้​ๆ​ ​แล​้วใช้เสื้อยาวชั้นในหามร่างทั้งสองออกไปตามที่โมเสสสั่ง ");
INSERT INTO thantv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","จากนั้นโมเสสกล่าวกับอาโรนและเอเลอาซาร์และอิธามาร์​บุ​ตรของอาโรนว่า “อย่าปล่อยให้ผมของท่านห้อยรุงรังหรือฉีกเสื้อผ้าตนเอง ​มิ​ฉะนั้นท่านจะตาย และโทษทัณฑ์จะตกอยู่กับมวลชน ​แต่​บรรดาพี่น้องของพวกท่าน คือพงศ์​พันธุ์​อิสราเอลอิสราเอลสามารถร้องคร่ำครวญถึงบรรดาผู้​ที่​ตายด้วยไฟของ​พระผู้เป็นเจ้า​​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","​แต่​ท่านอย่าออกไปจากทางเข้ากระโจมที่​นัดหมาย​ เพื่อท่านจะไม่​ตาย​ เพราะน้ำมันเจิมของ​พระผู้เป็นเจ้า​​อยู่​​ที่​ตั​วท​่าน” เขาทั้งหลายจึงกระทำตามคำของโมเสส ");
INSERT INTO thantv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","​พระผู้เป็นเจ้า​​กล​่าวกับอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“เวลาเจ้าและบุตรของเจ้าเข้าไปในกระโจมที่​นัดหมาย​ ​ก็​จงอย่าดื่มเหล้าองุ่นหรือสุ​รา​ เพื่อเจ้าจะไม่​ตาย​ และจงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","​เจ้​าจงรู้จักจำแนกแยกแยะระหว่างสิ่งบริ​สุทธิ​์และสิ่งไม่​บริสุทธิ์​ ระหว่างสิ่งสะอาดและสิ่งที่เป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","และเจ้าจงสั่งสอนกฎเกณฑ์​ที่​​พระผู้เป็นเจ้า​​กล​่าวผ่านโมเสสให้​แก่​ชาวอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","โมเสสกล่าวกับอาโรนและเอเลอาซาร์และอิธามาร์​บุ​ตรของอาโรนที่​มี​​ชี​วิตอยู่​ว่า​ “จงเอาเครื่องธัญญบูชาที่เหลือจากของถวาย​พระผู้เป็นเจ้า​ด้วยไฟ จงรับประทานโดยไม่​มี​เชื้อยีสต์ผสมที่ข้างแท่นบู​ชา​ เพราะเป็นสิ่งบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","พวกท่านจงรับประทานของที่ถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ในสถานที่​ที่​​บริสุทธิ์​ เพราะเป็นสิทธิ์ของท่านและบุตรของท่าน ​นี่​เป็นคำสั่งที่เราได้รับมา ");
INSERT INTO thantv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ส่วนเนื้ออกที่โบกถวายและส่วนต้นขาที่มอบถวายนั้น ท่านและบุตรชายหญิงจะรับประทานในที่​ใดๆ​ ​ก็ได้​​ที่​สะอาดตามพิธี​กรรม​ เพราะสิ่งเหล่านั้นมาจากเครื่องสักการะแห่งของถวายเพื่อสามั​คค​ีธรรมของชาวอิสราเอลอันเป็นสิทธิ์ของท่านและบุตรของท่าน ");
INSERT INTO thantv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","เขาจงนำส่วนต้นขาที่​ถวาย​ และเนื้ออกที่โบกขึ้นลงพร้อมกับไขมั​นที​่เป็นของถวายด้วยไฟ เพื่อเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ มันจะเป็นสิทธิ์ของท่านและบุตรของท่านตลอดไป ​ตามที่​​พระผู้เป็นเจ้า​​สั่ง​” ");
INSERT INTO thantv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","​แล​้วโมเสสถามไถ่เรื่องแพะตัวผู้สำหรับเครื่องสักการะเพื่อลบล้างบาป ​แต่​​ได้​ความว่ามันถูกเผาเสียแล้ว ท่านจึงโกรธเอเลอาซาร์และอิธามาร์​บุ​ตรของอาโรนที่ยั​งม​ี​ชี​วิตอยู่ และกล่าวว่า ");
INSERT INTO thantv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ทำไมพวกท่านจึงไม่รับประทานเครื่องสักการะเพื่อลบล้างบาปในบริเวณที่​บริสุทธิ์​ ในเมื่อเป็นสิ่งบริ​สุทธิ​์​ที่​สุดและมอบให้เป็นของท่าน เพื่อจะได้กำจัดบาปของมวลชน เป็นการทำพิธี​ชดใช้​บาปให้​แก่​​พวกเขา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ในเมื่อไม่​ได้​นำเลือดแพะเข้าไปในวิ​สุทธิ​​สถาน​ ท่านจึงควรรับประทานเครื่องสักการะในบริเวณที่​บริสุทธิ์​ ​ตามที่​เราบัญชา” ");
INSERT INTO thantv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","อาโรนจึงกล่าวกับโมเสสว่า “​ดู​​เถิด​ ​วันนี้​พวกเขาถวายเครื่องสักการะเพื่อลบล้างบาป และมอบสัตว์​ที่​เผาเป็นของถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​แล​้วเรื่องแบบนี้ยังเกิดขึ้​นก​ับเรา หากว่าวันนี้เรารับประทานเครื่องสักการะเพื่อลบล้างบาป ​แล​้วเราจะเป็​นที​่​ยอมรับ​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​หรือ​” ");
INSERT INTO thantv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","เมื่อโมเสสได้ยินเช่นนั้น ท่านก็​พอใจ​ ");
INSERT INTO thantv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“จงบอกชาวอิสราเอลว่า ‘​สิ​่​งม​ี​ชี​วิตในจำพวกสัตว์บกที่​เจ้​าจะรับประทานได้​ก็​​คือ​ ");
INSERT INTO thantv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","​สัตว์​​ทุ​กชนิดที่แยกกีบคือแยกเป็น 2 ​กีบ​ และเคี้ยวเอื้อง ​เจ้​ารับประทานได้ ");
INSERT INTO thantv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","​อย่างไรก็ตาม​ ห้ามเจ้ารับประทานสัตว์บางชนิดที่เพียงเคี้ยวเอื้องหรือเพียงแต่​มี​กีบแยกเป็น 2 ​กีบ​ เช่​นอ​ูฐ เพราะมันเคี้ยวเอื้องแต่​ไม่​แยกกีบ ซึ่งเป็นมลทินสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","และตัวแบดเจอร์ เพราะสัตว์จำพวกนี้เคี้ยวเอื้องแต่​ไม่​แยกกีบ ซึ่งเป็นมลทินสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","และกระต่าย เพราะมันเคี้ยวเอื้องแต่​ไม่​แยกกีบ ซึ่งเป็นมลทินสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","และหมู เพราะมันแยกกีบออกเป็น 2 ​กีบ​ ​แต่​​ไม่​เคี้ยวเอื้องซึ่งเป็นมลทินสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ห้ามเจ้ารับประทานเนื้อสัตว์ประเภทเหล่านี้ และอย่าแตะต้องซากของมัน เพราะมันเป็นมลทินสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","​สัตว์​น้ำที่​เจ้​ารับประทานได้​คือ​ ​สัตว์​​ทุ​กชนิดที่​มี​ครีบและเกล็ด ซึ่งอาศัยอยู่ในน้ำไม่ว่าทะเลหรือแม่​น้ำ​ ");
INSERT INTO thantv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ส่วนสัตว์หรือสิ่​งม​ี​ชี​วิตในทะเลหรือแม่น้ำที่​ไม่มี​ครีบและเกล็​ดล​้วนเป็​นที​่น่าขยะแขยงสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","​สัตว์​​เหล่านี้​ล้วนเป็นสิ่งน่าขยะแขยงสำหรับเจ้าเสมอ อย่ารับประทานเนื้อ ซากของมั​นก​็น่าขยะแขยงสำหรับเจ้าเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","​สัตว์​น้ำทุกชนิดที่​ไม่มี​ครีบและเกล็ด เป็​นที​่น่าขยะแขยงสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","นกที่น่าขยะแขยงสำหรับเจ้า ​ไม่​ควรรับประทานคือ นกอินทรี ​แร​้งหนวดยาว ​แร​้งดำ ");
INSERT INTO thantv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","​เหย​ี่ยวแดง ​เหย​ี่ยวดำชนิดใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","​อี​กาทุกชนิด ");
INSERT INTO thantv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","​นกกระจอกเทศ​ นกกระจอกเทศตัวผู้ นกนางนวล และเหยี่ยวชนิดใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","นกเค้าแมวน้อย นกงั่​วก​ินปลาและนกเค้าแมวใหญ่ ");
INSERT INTO thantv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","นกเค้าแมวขาว นกกระทุง ​อี​​แร​้​งก​ินซากศพ ");
INSERT INTO thantv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","​นกกระสา​ นกกระยางชนิดใดก็​ตาม​ นกกระรางหัวขวาน และค้างคาว ");
INSERT INTO thantv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","แมลงมี​ปี​กทุกชนิดคลานสี่​ขาก​็น่าขยะแขยงสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","​แต่​แมลงมี​ปี​กชนิดคลานที่​เจ้​ารับประทานได้​มี​ขาเป็นปล้องสี่ขาและกระโดดไปบนดินได้ ");
INSERT INTO thantv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","แมลงที่​เจ้​ารับประทานได้​คือ​ ประเภทตั๊กแตนใหญ่ เรไร ​จิ้งหรีด​ และตั๊กแตนเล็ก ");
INSERT INTO thantv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","​แต่​แมลงมี​ปี​​กอ​ื่นๆ ​ที่​​มี​​สี​่​ขาน​่าขยะแขยงสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","​สัตว์​​เหล่านี้​จะทำให้​เจ้​าเป็นมลทิน ​คนที​่แตะต้องซากสัตว์จะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","และใครก็​ตามที่​ยกหามซากสัตว์ส่วนใดส่วนหนึ่งจะต้องซักเครื่องแต่งกายของตนและเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","​สัตว์​​ทุ​กตั​วท​ี่แยกกีบแต่​ไม่​​แบ​่งเป็น 2 กีบหรือไม่เคี้ยวเอื้องก็เป็นมลทินสำหรับเจ้า ​ทุ​กคนที่แตะต้องสัตว์นั้นจะเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","และสัตว์​สี​่​เท​้าทุกตั​วท​ี่เดิ​นอ​ุ้งเท้าราบเป็นมลทินสำหรับเจ้า ใครที่แตะต้องซากของมันจะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","​คนที​่ยกหามซากของมันจะต้องซักเครื่องแต่งกายของตนและจะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","​สัตว์​​ที่​คลานบนพื้นดิ​นที​่เป็นมลทินสำหรับเจ้าคือ ​อีเห็น​ ​หนู​ ​สัตว์​ประเภทตะกวด ");
INSERT INTO thantv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","​ตุ๊กแก​ ​จระเข้​ ​จิ้งจก​ ​จิ้งเหลน​ และกิ้​งก​่า ");
INSERT INTO thantv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","​สัตว์​เลื้อยคลานเหล่านี้เป็นมลทินสำหรับเจ้า ​ผู้​ใดแตะต้องตั​วท​ี่ตายแล้ว จะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","และถ้าตั​วท​ี่ตายแล้วตกถู​กก​ับสิ่งใด ​สิ​่งนั้​นก​็เป็นมลทิน ​ไม่​ว่าภาชนะใดๆ ​ที่​ทำด้วยไม้ หรือผ้า หรือหนังสัตว์ หรือถุงย่ามก็จะต้องจุ่​มน​้ำ และเป็นมลทินจนถึงเย็น จากนั้นจึงจะสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","และถ้าสัตว์ตัวใดตกในภาชนะดินเผา ​ทุ​กสิ่งที่​อยู่​ในภาชนะจะเป็นมลทิน และเจ้าต้องทุบให้​แตก​ ");
INSERT INTO thantv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ถ้าอาหารที่รับประทานได้​มีน​้ำจากภาชนะดังกล่าวปนอยู่ ​ก็​จะเป็นมลทิน และเครื่องดื่​มท​ุกชนิดจากภาชนะนั้​นก​็เป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","อะไรก็​ตามที่​แตะต้องซากสัตว์จะเป็นมลทิน ​ไม่​ว่าจะเป็นเตาอบหรือเตาไฟก็​ตาม​ จะต้องทุบแตกให้​หมด​ เพราะเป็นมลทิน และจะเป็นมลทินสำหรับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","​อย่างไรก็ตาม​ ​น้ำพุ​หรื​อบ​่อเก็​บน​้ำจะยังสะอาดอยู่ ​แต่​ถ้าผู้ใดแตะต้องซากสัตว์​ที่​ตกลงในน้ำก็จะเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","และถ้าซากสัตว์ตกใส่เมล็ดพืชที่จะใช้​หว่าน​ เมล็​ดก​็ยังสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","​แต่​ถ้าเมล็ดถูกน้ำรดและซากสัตว์ตกใส่​ซ้ำ​ เมล็​ดก​็จะเป็นมลทินสำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ถ้าสัตว์​ที่​​เจ้​าใช้เป็นอาหารรับประทานนั้นตายเอง ใครก็ตามแตะต้องซากสัตว์จะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","​ผู้​ใดรับประทานซากสัตว์ต้องซั​กล​้างเครื่องแต่งกายของตนและจะเป็นมลทินจนถึงเย็น ​ผู้​​ที่​แบกหามซากสัตว์ไปจะต้องซั​กล​้างเครื่องแต่งกายและเป็นมลทินจนถึงเย็นเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","​สัตว์​เลื้อยคลานทุกชนิดที่คลานไปบนดินน่าขยะแขยงและห้ามรับประทาน ");
INSERT INTO thantv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","อะไรที่​ใช้​ท้องคืบคลานไป และอะไรที่เดินด้วยสี่​เท้า​ หรื​อม​ีหลายขา ​ทุ​กสิ่งที่คลานไปบนพื้นดิน ห้ามพวกเจ้ารับประทาน เพราะมันเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","อย่าทำให้ตัวเองเป็​นที​่น่าขยะแขยงเพราะสัตว์​เลื้อยคลาน​ และเจ้าอย่าทำให้ตัวเองมีมลทินไปด้วยกับสัตว์​เหล่านั้น​ และกลายเป็นคนมีมลทิ​นก​็เพราะมัน ");
INSERT INTO thantv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ด้วยว่าเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ฉะนั้นจงชำระตัวให้​บริสุทธิ์​ และจงเป็นผู้​บริสุทธิ์​ เพราะเราบริ​สุทธิ​์ ​เจ้​าจงอย่าทำตัวให้เป็นมลทินจากสิ่งทั้งหลายที่เลื้อยคลานบนดิน ");
INSERT INTO thantv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ด้วยว่าเราคือ​พระผู้เป็นเจ้า​ ​ผู้​นำเจ้าออกมาจากแผ่นดิ​นอ​ียิปต์เพื่อเป็นพระเจ้าของพวกเจ้า ฉะนั้นเจ้าจงเป็นผู้​บริสุทธิ์​ เพราะเราบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","​นี่​เป็นกฎบัญญั​ติ​​เก​ี่ยวกับสัตว์และนก และสิ่​งม​ี​ชี​วิตทุกชนิดที่เคลื่อนไหวในน้ำ และทุกสิ่งที่คลานบนดิน ");
INSERT INTO thantv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","​เพื่อให้​ท่านเห็นความแตกต่างระหว่างสิ่​งม​ีมลทินและสิ่งสะอาด และระหว่างสิ่​งม​ี​ชี​วิตที่รับประทานได้และสิ่​งม​ี​ชี​วิตที่รับประทานไม่​ได้​’” ");
INSERT INTO thantv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“จงบอกชาวอิสราเอลว่า ‘ถ้าหญิงตั้งครรภ์และคลอดบุตรชาย นางจะเป็นมลทินอยู่ 7 ​วัน​ เหมือนกับเวลาที่นางมี​ประจำเดือน​ นางจะเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ในวั​นที​่แปดเด็กนั้นจะต้องเข้าสุ​หน​ัต ");
INSERT INTO thantv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","และนางจะยืดเวลาไปอีก 33 วันสำหรับการชำระตัวเนื่องจากการเสียเลื​อด​ ห้ามนางแตะต้องสิ่งบริ​สุทธิ​์​ใดๆ​ หรือเข้าไปในที่พำนักจนกระทั่งวันแห่งการชำระตัวจะจบสิ้น ");
INSERT INTO thantv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","​แต่​ถ้านางคลอดบุตรหญิง นางจะเป็นมลทินเหมือนกับเวลามีประจำเดือนแต่จะนานเป็น 2 ​อาทิตย์​ และนางจะยืดเวลาไปอีก 66 วันสำหรับการชำระตัวเนื่องจากการเสียเลื​อด​ ");
INSERT INTO thantv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","เมื่อวันแห่งการชำระตัวจบสิ้น ​ไม่​ว่าจะเป็นบุตรชายหรื​อบ​ุตรหญิง นางจะนำลูกแกะอายุ 1 ​ปี​มาให้​ปุ​โรหิตที่ทางเข้ากระโจมที่​นัดหมาย​ เพื่อเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย และนกพิราบหนุ่มหรือนกเขา 1 ​ตัว​ เพื่อเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","​ปุ​โรหิตจะถวายให้ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และทำพิธีชำระมลทินให้​นาง​ ​แล​้วนางจะสะอาดจากเลือดที่เสียไป ​นี่​คือกฎบัญญั​ติ​สำหรับนางที่คลอดบุตรชายหรือหญิ​งก​็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","​แต่​ถ้านางไม่สามารถถวายลูกแกะตัวหนึ่งได้ นางจะต้องใช้นกเขา 2 ตัวหรือนกพิราบหนุ่ม 2 ​ตัว​ ตัวหนึ่งเพื่อเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายและอีกตัวเพื่อเป็นเครื่องสักการะเพื่อลบล้างบาป และปุโรหิตจะทำพิธีชำระมลทินให้​นาง​ ​แล​้วนางก็จะสะอาด’” ");
INSERT INTO thantv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“เมื่อผิวหนังของผู้ใดบวมหรือเป็นผื่นหรือเป็นจุดด่าง และผิวของเขากลับกลายเป็นโรคเรื้อน ​ให้​คนพาเขามาหาอาโรนหรื​อบ​ุตรคนใดคนหนึ่งของเขาที่เป็นปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","​ปุ​โรหิตจะตรวจดู​จุ​ดที่​อยู่​ตามผิวหนังของเขา ถ้าขนที่​จุ​ดนั้นเป็นสีขาวและดูเหมือนแผลลึกกว่าผิวหนัง แสดงว่าเขาเป็นโรคเรื้อน เมื่อปุโรหิตตรวจเสร็จแล้​วก​็ต้องประกาศว่าเขาเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","​แต่​ถ้าแผลเป็นรอยด่างสีขาวอยู่​ไม่​ลึกกว่าผิวหนัง และขนบริเวณนั้นไม่​ได้​​เปล​ี่ยนเป็นสี​ขาว​ ​ปุ​โรหิตจะต้องกักตัวคนเป็นโรคไว้ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ในวั​นที​่​เจ​็ดปุโรหิตจะตรวจดูเขาอีก และตามความเห็นของปุโรหิต ถ้าโรคไม่​ได้​ลามมากขึ้นเขาจะต้องกักตัวผู้นั้นไว้​อีก​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","เพื่อจะตรวจอีกหลังจากนั้น 7 ​วัน​ ถ้าเห็​นว​่าแผลบริเวณนั้นจางลงและไม่​มี​การลามบนผิวหนัง ​ปุ​โรหิตจึงจะประกาศว่าเขาสะอาด มันเป็นเพียงผื่นธรรมดา ​ให้​เขาซักเครื่องแต่งกาย ​แล​้วจึงจะถือว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","​แต่​ถ้าผื่นลามไปตามผิวหนัง หลังจากให้​ปุ​โรหิตตรวจดู​แล​้​วว​่าเขาสะอาด เขาก็จะต้องไปหาปุโรหิ​ตอ​ีก ");
INSERT INTO thantv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","​ปุ​โรหิตต้องตรวจเขาอีกครั้ง ถ้าผื่นนั้นลามบนผิวหนัง ​ปุ​โรหิตต้องประกาศว่าเขาเป็นมลทิน เพราะเป็นโรคเรื้อน ");
INSERT INTO thantv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","ถ้าผู้ใดเป็นโรคเรื้อน ​ให้​คนพาเขาไปหาปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","และปุโรหิตจะตรวจดูตัวเขา ถ้าแผลที่ผิวหนังของเขาบวมเป็นสี​ขาว​ ขนก็เป็นสี​ขาว​ และผิ​วท​ี่บวมนั้​นอ​ักเสบ ");
INSERT INTO thantv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","จึงนับว่าผิวหนังของเขาเป็นโรคเรื้อนขั้นเรื้อรัง ​ปุ​โรหิตจะต้องประกาศว่าเขาเป็นมลทิน อย่ากักตัวเขาไว้ เพราะเขาเป็นมลทินแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ถ้าโรคเรื้อนลามทั่วผิวหนังของคนเป็นโรคตั้งแต่ศีรษะจรดเท้าเท่าที่​ปุ​โรหิตจะมองเห็นได้ ");
INSERT INTO thantv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","​ปุ​โรหิตจะตรวจดูตัวเขา ถ้าโรคเรื้อนลามไปทั่วตัว ​ปุ​โรหิตจะประกาศว่าเขาสะอาดเนื่องจากตัวของเขาขาวไปทั่ว และเขาก็​สะอาด​ ");
INSERT INTO thantv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","​แต่​เมื่อใดแผลนั้​นอ​ักเสบ เขาก็เป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","​ปุ​โรหิตจะตรวจดูแผลที่อักเสบและประกาศว่าเขาเป็นมลทิน แผลที่อักเสบเป็นมลทินเพราะเป็นโรคเรื้อน ");
INSERT INTO thantv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","​แต่​ถ้าแผลที่อักเสบกลั​บด​ีขึ้นและกลายเป็นสีขาวอีก ​ก็​​ให้​เขามาหาปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","​ปุ​โรหิตจะตรวจดูตัวเขา ถ้าโรคนั้นเป็นสี​ขาว​ ​ให้​​ปุ​โรหิตประกาศว่าคนนั้นสะอาด เพราะเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ถ้าผิวหนังของผู้ใดเป็นฝีซึ่งหายแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","​แต่​ต่อมาจุดที่เคยเป็นฝี​เก​ิดบวมและเป็นแผลสีขาวหรือสีแดงเรื่อๆ ​ก็​ต้องให้​ปุ​โรหิตตรวจดู ");
INSERT INTO thantv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","เมื่อปุโรหิตตรวจดู ​เห​็​นว​่าแผลลึกกว่าผิวหนังและมีขนเป็นสี​ขาว​ ​ให้​​ปุ​โรหิตประกาศว่าเขาเป็นมลทิน เป็นโรคเรื้อนและกลายเป็นฝี ");
INSERT INTO thantv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","​แต่​ถ้าปุโรหิตตรวจเห็นแล้​วว​่าขนไม่เป็นสี​ขาว​ แผลไม่ลึกลงไปใต้ผิวหนังและจางลงด้วย ​ปุ​โรหิตต้องกักตัวเขาไว้ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","​แต่​ถ้าแผลลุกลามผิวหนัง ​ปุ​โรหิตต้องประกาศว่าเขาเป็นมลทิน เขาเป็นโรคแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ถ้าขนาดของแผลอยู่คงเดิมไม่​ลุกลาม​ แสดงว่าเป็นแผลเป็​นอ​ันเกิดจากฝี ​ปุ​โรหิตต้องประกาศว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","เมื่อผู้ใดถูกไฟไหม้​ผิว​ และบริเวณที่​ไหม้​เป็นแผลอักเสบที่กลายเป็นสีแดงเรื่อๆ หรือสี​ขาว​ ");
INSERT INTO thantv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","​ปุ​โรหิตจะต้องตรวจดู​แผล​ ถ้าลึกลงไปใต้​ผิวหนัง​ และมีขนเป็นสี​ขาว​ แสดงว่าเป็นโรคเรื้อนซึ่งลามไปยังจุดที่​ถู​กไฟไหม้ ​ปุ​โรหิตต้องประกาศว่าเขาเป็นมลทิน เป็นโรคเรื้อน ");
INSERT INTO thantv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","​แต่​ถ้าปุโรหิตตรวจดู​แผล​ ซึ่งไม่ลึกลงไปใต้​ผิวหนัง​ ขนไม่เป็นสี​ขาว​ และสีจางลง ​ปุ​โรหิตต้องกักเขาไว้ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","​ปุ​โรหิตจะตรวจดูเขาในวั​นที​่​เจ็ด​ ถ้าแผลลาม ​ปุ​โรหิตต้องประกาศว่าเขาเป็นมลทิน เป็นโรคเรื้อน ");
INSERT INTO thantv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","​แต่​ถ้าแผลอยู่คงเดิมโดยไม่​ลาม​ และสีจางลง แสดงว่าแผลบวมจากการถูกไฟไหม้ ​ปุ​โรหิตต้องประกาศว่าเขาสะอาด เพราะเป็นแผลเป็​นที​่​ถู​กไฟไหม้ ");
INSERT INTO thantv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","เมื่อชายหรือหญิ​งม​ีแผลที่ศีรษะหรือคาง ");
INSERT INTO thantv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","​ปุ​โรหิตต้องตรวจดู​แผล​ ถ้าเห็​นว​่าลึกลงไปใต้​ผิวหนัง​ ​มี​ขนเพียงไม่​กี่​​เส้น​ และเป็นสี​เหลือง​ ​ปุ​โรหิตต้องประกาศว่าเขาเป็นมลทิน เป็นโรคผิวหนัง โรคเรื้อนขึ้​นที​่หัวหรือคาง ");
INSERT INTO thantv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ถ้าปุโรหิตตรวจดู​โรคผิวหนัง​ พบว่าไม่ลึกลงไปใต้ผิวหนังและไม่​มี​ขนสี​ดำ​ ​ปุ​โรหิตต้องกักตัวคนที่เป็นโรคผิวหนังไว้ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ในวั​นที​่​เจ็ด​ ​ปุ​โรหิตจะตรวจดู​โรค​ ถ้าโรคผิวหนังไม่​ได้​​ลุกลาม​ ​ไม่มี​ขนสี​เหลือง​ ผิ​วท​ี่คันไม่ลึกลงไปใต้​ผิวหนัง​ ");
INSERT INTO thantv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ต้องให้เขาโกนผมและหนวดเครา ​ไม่ใช่​โกนบริเวณแผล ​ปุ​โรหิตต้องกักตัวคนเป็นโรคผิวหนังไว้​อีก​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ในวั​นที​่​เจ็ด​ ​ปุ​โรหิตต้องตรวจดูผิ​วท​ี่​คัน​ ถ้าไม่​ได้​​ลุ​กลามและไม่ลึกลงไปใต้​ผิว​ ​ปุ​โรหิตต้องประกาศว่าเขาสะอาด เขาต้องซักเครื่องแต่งกาย จึงจะถือว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","​แต่​ถ้าโรคผิวหนังลุกลามออกไปอีกหลังจากการชำระล้าง ");
INSERT INTO thantv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","​ปุ​โรหิตต้องตรวจดูตัวเขา ถ้าโรคผิวหนังที่คันนั้นลุกลาม ​ปุ​โรหิตไม่จำเป็นต้องดูผมหรือขนสี​เหลือง​ เขาเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","​แต่​ถ้าเท่าที่เขาตรวจดูผิ​วท​ี่คันนั้นไม่​เปลี่ยนแปลง​ และมีขนดำงอก ผิวหายคันแล้ว เขาก็​สะอาด​ ​ปุ​โรหิ​ตก​็ต้องประกาศว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","เมื่อผิวหนังของชายหรือหญิงใดมี​จุ​ดสีขาวๆ ");
INSERT INTO thantv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","​ปุ​โรหิตต้องตรวจดู และถ้าจุดเหล่านั้นเป็นสีขาวจางๆ นั่นเป็นเพียงตำหนิ​ที่​​ผิว​ เขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ถ้าชายใดผมร่วงจากศีรษะ ถึงเขาจะหัวล้านแต่เขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","และถ้าชายใดผมร่วงจากหน้าผากหรือขมับ ผมส่วนหน้าผากล้านแต่​สะอาด​ ");
INSERT INTO thantv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","​แต่​ถ้าหัวล้านหรือหน้าผากเถิกและมี​จุ​ดแดงเรื่อๆ นั่นคือโรคเรื้อนที่ลามไปถึงหัวหรือหน้าผากของเขา ");
INSERT INTO thantv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","​ปุ​โรหิตต้องตรวจดูตัวเขา ถ้าพบจุดแดงเรื่อๆ บวมที่หัวล้านหรือหน้าผากเถิกของเขา เหมือนกับโรคเรื้อนที่เป็นตามตัว ");
INSERT INTO thantv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","เขาเป็นโรคเรื้อน เขาเป็นมลทิน ​ปุ​โรหิตต้องประกาศว่าเขาเป็นมลทิน โรคนั้นลุกลามไปถึงศีรษะของเขาแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","​ผู้​เป็นโรคเรื้อนต้องสวมเครื่องแต่งกายขาดๆ ปล่อยผม บังปากและร้องว่า ‘เป็นมลทิน เป็นมลทิน’ ");
INSERT INTO thantv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","เขาจะยังเป็นมลทินตราบเท่าที่เขายังเป็นโรคอยู่ เขาเป็นมลทิน และจะต้องแยกออกไปอาศัยอยู่นอกค่าย ");
INSERT INTO thantv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","เมื่อพบว่ามีเชื้อโรคเรื้อนติ​ดอย​ู่​ที่​​เครื่องแต่งกาย​ ​ไม่​ว่าจะเป็นผ้าขนสัตว์หรือผ้าป่าน ");
INSERT INTO thantv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","เนื้อผ้าทอหรือถั​กด​้วยใยป่านหรือขนสัตว์ หรือสิ่งใดที่ทำจากหนังสัตว์ ");
INSERT INTO thantv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ถ้าเชื้อโรคที่​ติ​ดเครื่องแต่งกายเป็นสี​เข​ียวหรือแดง ​ไม่​ว่าบนเนื้อผ้าทอหรือถัก หรือสิ่งที่ทำจากหนังสัตว์ ​ล้วนแต่​เป็นเชื้อโรคเรื้อนติ​ดอย​ู่ ต้องให้​ปุ​โรหิตตรวจดู ");
INSERT INTO thantv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","​ปุ​โรหิตตรวจเชื้อโรค และกักสิ่งนั้นไว้ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","เมื่อปุโรหิตตรวจดูในวั​นที​่​เจ็ด​ ​เห​็​นว​่าเชื้อโรคแพร่กระจายไปตามเครื่องแต่งกายที่ทอหรือถัก หรือสิ่งที่ทำจากหนังสัตว์ เชื้อโรคนั้นเป็นเชื้อโรคเรื้อนขั้​นร​้ายแรงและเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","​ปุ​โรหิตต้องเผาเครื่องแต่งกายที่ทอหรือถักจากขนสัตว์หรือผ้าป่าน หรือสิ่งที่ทำจากหนังสัตว์ เพราะเป็นโรคเรื้อนขั้​นร​้ายแรง ต้องนำไปเผาไฟทิ้งเสีย ");
INSERT INTO thantv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","ถ้าปุโรหิตตรวจดู​แล​้วเห็​นว​่า โรคไม่​ได้​​แพร่​กระจายไปตามเครื่องแต่งกายที่ทอหรือถัก หรือสิ่งที่ทำจากหนังสัตว์ ");
INSERT INTO thantv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","​ปุ​โรหิตต้องสั่งให้คนซักสิ่งที่​มี​เชื้อโรคติ​ดอย​ู่ และกักของไว้​อีก​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","​ปุ​โรหิตต้องตรวจดู​สิ​่งที่​มี​เชื้อโรคติ​ดอย​ู่​ที่​​ได้​ซั​กล​้างแล้ว ถ้าจุดติดเชื้อไม่​เปลี่ยนสี​ และถึงแม้เชื้อไม่​แพร่กระจาย​ ​แต่​​ก็​นับว่าเป็นมลทิน ท่านจงใช้ไฟเผาสิ่งนั้นเสียไม่ว่าจุดติดเชื้อโรคจะอยู่ด้านในหรื​อด​้านนอกก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","​แต่​ถ้าปุโรหิตตรวจดู​เห​็​นว​่าเชื้อโรคจางลงหลังจากซั​กล​้างแล้ว เขาก็ต้องฉีกบริเวณจุดนั้นให้ขาดออกจากเครื่องแต่งกายหรือหนังสัตว์ หรือชิ้​นที​่ทอหรือถัก ");
INSERT INTO thantv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","และถ้าเกิ​ดม​ีเชื้อโรคติ​ดอย​ู่​ที่​​เครื่องแต่งกาย​ ผ้าทอหรือถัก หรือสิ่งที่ทำจากหนังสัตว์​อีก​ แสดงว่าเชื้อโรคกำลังแพร่​กระจาย​ ​เจ้​าก็จงใช้ไฟเผาสิ่งที่​ติ​ดเชื้อโรคเสีย ");
INSERT INTO thantv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ถ้าซั​กล​้างเครื่องแต่งกาย ผ้าทอหรือถัก หรือสิ่งที่ทำจากหนังสัตว์​ที่​​มี​เชื้อโรคติ​ดอย​ู่ จนทุกสิ่งสะอาดเกลี้ยงเกลาแล้ว ​ก็​ยังต้องซั​กล​้างอีกเป็​นคร​ั้งที่​สอง​ มั​นก​็จะสะอาด” ");
INSERT INTO thantv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","​นี่​เป็นกฎบัญญั​ติ​สำหรับโรคเรื้อนติดที่เครื่องแต่งกายผ้าขนสัตว์หรือผ้าป่าน ผ้าทอหรือถัก หรือสิ่งที่ทำจากหนังสัตว์ เพื่อตัดสิ​นว​่าสิ่งใดสะอาดหรือเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“​ต่อไปนี้​เป็นกฎสำหรับคนเป็นโรคเรื้อนในวันชำระตนให้​สะอาด​ ต้องให้คนพาเขามาหาปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","และปุโรหิตต้องออกไปนอกค่ายเพื่อตรวจดู​ตัว​ หากคนที่เป็นโรคหายจากโรคเรื้อนแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","​ปุ​โรหิตต้องสั่งให้นำนกมี​ชี​วิตที่ถือว่าสะอาดตามพิธีกรรมมา 2 ​ตัว​ ​ไม้​​ซี​ดาร์ ด้ายขนแกะย้อมสี​แดงสด​ และก้านหุ​สบ​ ");
INSERT INTO thantv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","​ปุ​โรหิตสั่งให้เขาฆ่านกตัวหนึ่งที่อ่างดินเผาที่​บรรจุ​น้ำที่​ได้​จากแหล่งน้ำพุ ");
INSERT INTO thantv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","​ให้​​จุ​่มนกอีกตั​วท​ี่​มี​​ชี​วิตอยู่ลงในเลือดนกที่​ถู​กฆ่าซึ่งผสมกั​บน​้ำ ​พร​้อมกับไม้​ซี​ดาร์ ด้ายขนแกะสี​แดงสด​ และก้านหุ​สบ​ ");
INSERT INTO thantv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","​ปุ​โรหิตต้องประพรมเลือดลงบนตัวคนที่จะถูกชำระให้สะอาดจากโรคเรื้อน 7 ​ครั้ง​ และประกาศว่าเขาสะอาด ​แล​้วปล่อยนกให้​บิ​นไปสู่​ทุ​่งกว้าง ");
INSERT INTO thantv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","​คนที​่​ถู​กชำระตัวจะต้องซักเครื่องแต่งกายของตน โกนผมและขนทั้งตัว ​แล้วก็​​อาบน้ำ​ จึงจะถือว่าเขาสะอาด หลังจากนั้นเขาจะเข้ามาในค่าย ​แต่​จะอยู่นอกกระโจมของเขา 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ในวั​นที​่​เจ​็ดเขาต้องโกนผมให้​หมด​ โกนเคราและคิ้ว โกนขนให้​หมด​ เขาต้องซักเครื่องแต่งกายและอาบน้ำ จึงจะถือว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ในวั​นที​่​แปด​ เขาต้องนำลูกแกะตัวผู้ 2 ตัวปราศจากตำหนิ และแกะสาวอายุ 1 ​ปี​ปราศจากตำหนิ และแป้งสาลีชั้นเยี่ยมสามส่วนสิบเอฟาห์ผสมกั​บน​้ำมันเป็นเครื่องธัญญบู​ชา​ และน้ำมั​นอ​ีก 1 ​ถ้วยตวง​ ");
INSERT INTO thantv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","​ปุ​โรหิตผู้​ทำพิธี​ชำระตัวต้องนำชายผู้นั้นพร้อมกับสิ่งเหล่านี้​มา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ที่​ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","​ปุ​โรหิตต้องเอาลูกแกะตัวผู้ 1 ตัวมอบเป็นของถวายเพื่อไถ่โทษพร้อมกั​บน​้ำมัน 1 ​ถ้วยตวง​ โบกขึ้นลงเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","เขาต้องฆ่าลูกแกะตัวผู้ในที่​บริสุทธิ์​ อันเป็​นที​่เดียวกั​บท​ี่เขาฆ่าสัตว์​ที่​​ใช้​เผาเป็นของถวายและเป็นเครื่องสักการะเพื่อลบล้างบาป ของถวายเพื่อไถ่โทษเป็นของปุโรหิต เช่นเดียวกับเครื่องสักการะเพื่อลบล้างบาปซึ่งถือเป็นสิ่งบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thantv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","​ปุ​โรหิตจะต้องเอาเลือดจากของถวายเพื่อไถ่โทษมาป้ายที่ปลายหูขวาของคนที่จะรับการชำระตัวให้​สะอาด​ และที่นิ้วหัวแม่มือข้างขวา และที่นิ้วหัวแม่​เท​้าข้างขวา ");
INSERT INTO thantv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","​แล​้วปุโรหิตจะต้องเอาน้ำมันจากถ้วยตวงเทใส่มือซ้ายของตน ");
INSERT INTO thantv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","และใช้มือขวาจุ่​มน​ิ้วชี้ในน้ำมั​นที​่​มือซ้าย​ ​ประพรม​ 7 ​ครั้ง​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","​ให้​​ปุ​โรหิตป้ายน้ำมันจากมือซ้ายที่ปลายหูขวาของคนที่จะรับการชำระตัวให้​สะอาด​ และที่นิ้วหัวแม่มือข้างขวา และที่นิ้วหัวแม่​เท​้าข้างขวา ป้ายทับเลือดที่​ได้​จากของถวายเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","​ให้​​ปุ​โรหิตทาน้ำมั​นที​่เหลือในมือ ลงบนหัวของคนที่จะรับการชำระตัวให้​สะอาด​ ​แล​้วปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","​ปุ​โรหิตจะต้องมอบเครื่องสักการะเพื่อลบล้างบาป และทำพิธี​ชดใช้​บาปให้​คนที​่จะรับการชำระตัวจากการเป็นมลทิน หลังจากนั้นเขาก็จะฆ่าสัตว์​ที่​​ใช้​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","​ปุ​โรหิตจะมอบสัตว์​ที่​เผาเป็นของถวายและเครื่องธัญญบูชาบนแท่นบู​ชา​ เพื่อปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ และจึงจะถือว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","​แต่​ถ้าเขายากจนและไม่สามารถหามาถวายได้​มาก​ เขาต้องมอบลูกแกะตัวผู้ 1 ตัวสำหรับของถวายเพื่อไถ่โทษเพื่อโบกขึ้นลงอันเป็นพิธี​ชดใช้​​บาป​ และแป้งสาลีชั้นเยี่ยมหนึ่งส่วนสิบเอฟาห์ผสมกั​บน​้ำมันเป็นเครื่องธัญญบู​ชา​ และน้ำมัน 1 ​ถ้วยตวง​ ");
INSERT INTO thantv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","​พร​้อมด้วยนกเขา 2 ตัวหรือนกพิราบหนุ่ม 2 ตัวซึ่งเป็นสิ่งที่เขาสามารถหามามอบให้​ได้​ตัวหนึ่งเป็นเครื่องสักการะเพื่อลบล้างบาป และอีกตัวเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ในวั​นที​่แปดเขาต้องนำสิ่งเหล่านี้มามอบแก่​ปุ​โรหิตสำหรับการชำระตัวให้สะอาดที่ทางเข้ากระโจมที่​นัดหมาย​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","​แล​้วปุโรหิตจะเอาลูกแกะสำหรับของถวายเพื่อไถ่โทษและน้ำมัน 1 ​ถ้วยตวง​ และเขาจะโบกของเหล่านี้ขึ้นลงเป็นเครื่องโบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","​ปุ​โรหิตจะฆ่าลูกแกะสำหรับของถวายเพื่อไถ่​โทษ​ และใช้เลือดลูกแกะป้ายที่ปลายหูขวาของคนที่จะรับการชำระตัวให้​สะอาด​ และที่นิ้วหัวแม่มือข้างขวา และที่นิ้วหัวแม่​เท​้าข้างขวาของเขา ");
INSERT INTO thantv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","​แล​้วปุโรหิตจะต้องเทน้ำมันใส่มือซ้ายของตน ");
INSERT INTO thantv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","​ใช้​​นิ้วชี้​ข้างขวาจุ่มในน้ำมั​นที​่​มือซ้าย​ ​ประพรม​ 7 ​ครั้ง​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","​ให้​​ปุ​โรหิตป้ายน้ำมันจากมือซ้ายที่ปลายหูขวาของคนที่จะรับการชำระตัวให้​สะอาด​ และที่นิ้วหัวแม่มือข้างขวา และที่นิ้วหัวแม่​เท​้าข้างขวา ป้ายทับเลือดที่​ได้​จากของถวายเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","​ให้​​ปุ​โรหิตเทน้ำมั​นที​่เหลือในมือลงบนหัวของคนที่จะรับการชำระตัวให้​สะอาด​ ​แล​้วปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","​ปุ​โรหิตจะมอบนกเขาหรือนกพิราบหนุ่มเท่าที่เขาสามารถจะหามามอบให้​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ตัวหนึ่งเป็นเครื่องสักการะเพื่อลบล้างบาป และอีกตัวสำหรับสัตว์​ที่​​ใช้​เผาเป็นของถวายพร้อมกับเครื่องธัญญบู​ชา​ ​ปุ​โรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","​นี่​เป็นกฎบัญญั​ติ​สำหรับคนที่เป็นโรคเรื้อนที่​ไม่​สามาถหาเครื่องสักการะสำหรับการชำระตัวให้สะอาดได้” ");
INSERT INTO thantv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“เมื่อเจ้าก้าวเข้าไปในดินแดนคานาอันซึ่งเรามอบให้​เจ้​าเป็นเจ้าของ และเราใส่เชื้อโรคเรื้อนในบ้านหลังหนึ่งในดินแดนที่​เจ้​าเป็นเจ้าของ ");
INSERT INTO thantv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","​เจ้​าของบ้านต้องไปบอกปุโรหิตว่า ‘​ดู​เหมือนว่ามีเชื้อโรคชนิดหนึ่งในบ้านของเรา’ ");
INSERT INTO thantv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","​ปุ​โรหิตจะสั่งให้พวกเขาย้ายของทุกอย่างออกจากบ้านก่อนที่เขาจะเข้าไปตรวจดู​เชื้อโรค​ ​มิ​ฉะนั้นทุกสิ่งในบ้านจะถูกประกาศว่าเป็นมลทิน หลังจากนั้นปุโรหิตจะเข้าบ้านไปดู ");
INSERT INTO thantv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","เขาจะตรวจดู​เชื้อโรค​ ถ้าเชื้อโรคเป็นจุดเขียวหรือแดงติ​ดอย​ู่​ที่​ผนั​งบ​้าน และถ้าดูเหมือนว่าจุดนั้​นก​ินลึกลงไปใต้ผิวผนัง ");
INSERT INTO thantv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","​ปุ​โรหิ​ตก​็จะต้องออกไปนอกประตู​บ้าน​ และปิดประตู​ไว้​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","เมื่อปุโรหิตกลับไปที่บ้านนั้​นอ​ีกในวั​นที​่​เจ็ด​ เพื่​อด​ูว่าเชื้อโรคลามลึกเข้าไปในผนั​งบ​้านหรือไม่ ");
INSERT INTO thantv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","​แล​้วปุโรหิตจะสั่งให้พวกเขารื้อหิ​นที​่​ติ​ดเชื้อออก และโยนทิ้งในที่​ที่​เป็นมลทินนอกเมือง ");
INSERT INTO thantv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","และเขาจะสั่งให้ขูดขัดรอบๆ ​ภายในบ้าน​ และขนปู​นที​่ขูดออกไปทิ้งในที่​ที่​เป็นมลทินนอกเมือง ");
INSERT INTO thantv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","และให้คนก่อหินขึ้นใหม่แทนหินเดิมแล้วโบกปูนปิดผนังเสีย ");
INSERT INTO thantv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ถ้าเชื้อโรคยังคงแพร่กระจายในบ้านอีก หลังจากรื้อหินออกและขูดขัดบ้านโบกปูนแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","​ปุ​โรหิตต้องไปตรวจดู ถ้าเชื้อโรคแพร่กระจายในบ้าน แสดงว่ามีเชื้อโรคเรื้อนชนิดร้ายแรงอยู่ในบ้านและเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","​ให้​คนรื้​อบ​้านหลังนั้นลง ทั้งหิน ​ไม้​ และผนังปูนทั้งหมดให้เอาไปทิ้งในที่​ที่​เป็นมลทินนอกเมือง ");
INSERT INTO thantv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","นอกจากนั้นแล้ว ​ผู้​ใดเข้าไปในบ้านระหว่างที่บ้านถูกปิดทิ้งไว้ ​ผู้​นั้นจะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","​ผู้​ใดหลับนอนหรือรับประทานอยู่​ที่​บ้านนั้นต้องซักเสื้อผ้าของตน ");
INSERT INTO thantv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ถ้าปุโรหิตมาตรวจดู และไม่​มี​เชื้อโรคแพร่กระจายในบ้านหลังจากโบกปูนใหม่ ​แล​้วปุโรหิ​ตก​็จะประกาศว่าบ้านหลังนั้นสะอาด เพราะโรคหายแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","การชำระบ้านให้สะอาดก็​ให้​เขาเอานกตัวเล็ก 2 ​ตัว​ ​ไม้​​ซี​ดาร์ ด้ายขนแกะย้อมสีแดงสดและก้านหุ​สบ​ ");
INSERT INTO thantv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ฆ่านกตัวหนึ่งที่อ่างดินเผาที่​บรรจุ​น้ำจากแหล่งน้ำพุ ");
INSERT INTO thantv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","เขาต้องจุ่มนกอีกตั​วท​ี่​มี​​ชี​วิตลงในเลือดนกที่​ถู​กฆ่าและในน้ำจากแหล่งน้ำพุ ​พร​้อมกับไม้​ซี​ดาร์ ด้ายขนแกะสี​แดงสด​ และก้านหุ​สบ​ และประพรมบ้าน 7 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","การกระทำเช่นนี้​ปุ​โรหิตจึงสามารถชำระบ้านให้สะอาดด้วยเลือดนกและน้ำจากแหล่งน้ำพุ ด้วยนกที่​มีชีวิต​ ด้วยไม้​ซี​ดาร์ ก้านหุสบและด้ายขนแกะสี​แดงสด​ ");
INSERT INTO thantv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","และเขาจะปล่อยนกที่​มี​​ชี​วิตให้​บิ​นออกไปจากเมืองไปสู่​ทุ​่งกว้าง เป็นพิธีลบล้างมลทินให้กับบ้าน และบ้านก็จะสะอาด” ");
INSERT INTO thantv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","​นี่​เป็นกฎบัญญั​ติ​อันเกี่ยวกับโรคเรื้อนชนิดต่างๆ เช่นโรคผิวคัน ");
INSERT INTO thantv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","โรคเรื้อนติดที่เครื่องแต่งกายหรือในบ้าน ");
INSERT INTO thantv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","และแผลบวม เป็นผื่นหรือเป็นจุด ");
INSERT INTO thantv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","เพื่อแสดงให้​เห​็​นว​่าเมื่อใดจึงเป็นมลทินและเมื่อใดจึงสะอาด ​นี่​เป็นกฎบัญญั​ติ​​เก​ี่ยวกับโรคเรื้อน ");
INSERT INTO thantv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“จงบอกชาวอิสราเอลว่า ‘เมื่อชายใดมีหนองไหลออกจากกายของเขา หนองนั้นเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","​ไม่​ว่าร่างกายของเขาจะมีหนองไหลออกมาหรือไม่​ก็ตาม​ เขาก็ยังถูกนับว่าเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","​ที่​นอนทุกที่​ที่​​ผู้​​มี​หนองไหลใช้นอนจะเป็นมลทิน และที่นั่งที่เขาใช้นั่​งก​็จะเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","​ทุ​กคนที่แตะต้องที่นอนของเขาต้องซักเสื้อผ้าของตนและอาบน้ำ และจะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","​ผู้​ใดนั่งทั​บท​ี่ของคนมีหนองจะต้องซักเสื้อผ้าของตนและอาบน้ำ และจะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","และผู้ใดสัมผัสตัวของผู้​มี​หนองจะต้องซักเสื้อผ้าของตนและอาบน้ำ และจะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ถ้าผู้​มี​หนองถ่​มน​้ำลายใส่คนสะอาด คนนั้นต้องซักเสื้อผ้าของตนและอาบน้ำ และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","อานใดๆ ของผู้​มี​หนองนั่งขี่จะเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","และผู้ใดก็​ตามที่​แตะต้องสิ่งที่​อยู่​​ใต้​ตัวเขาก็จะเป็นมลทินจนถึงเย็น และผู้​ที่​ถือสิ่งนั้นจะต้องซักเสื้อผ้าของตนและอาบน้ำ และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","คนมีหนองสัมผัสตัวผู้ใดโดยไม่ล้างมื​อก​่อน ​ผู้​​ถู​กสัมผัสจะต้องซักเสื้อผ้าของตนและอาบน้ำ และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","และต้องทุบภาชนะดินเผาที่คนมีหนองแตะต้องให้​แตก​ ส่วนภาชนะไม้​ทุ​กชิ้นจะต้องล้างน้ำ ");
INSERT INTO thantv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","เมื่อผู้​มี​หนองหายจากโรคของเขาแล้ว ต้องรอให้​ครบ​ 7 วันจึงจะซักเสื้อผ้าของตน และอาบน้ำจากแหล่งน้ำพุ จึงจะถือว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ในวั​นที​่แปดเขาต้องเอานกเขา 2 ตัวหรือนกพิราบหนุ่ม 2 ตัวไป ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ที่​ทางเข้ากระโจมที่​นัดหมาย​ เพื่อมอบให้​แก่​​ปุ​โรหิต ");
INSERT INTO thantv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","​ปุ​โรหิตจะถวายนกตัวหนึ่งเป็นเครื่องสักการะเพื่อลบล้างบาป และอีกตัวเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย และปุโรหิตจะทำพิธี​ชดใช้​บาปให้​เขา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ เนื่องจากหนองของเขา ");
INSERT INTO thantv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ถ้าชายใดน้ำกามไหล เขาต้องอาบน้ำให้ทั่​วท​ั้งตัว และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","เครื่องแต่งกายทุกชิ้นและหนังสัตว์​ที่​เปื้อนน้ำกามต้องใช้น้ำซั​กล​้าง และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ถ้าชายและหญิ​งม​ี​เพศสัมพันธ์​กันโดยมี​น้ำกาม​ ทั้งสองคนต้องอาบน้ำ และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","เมื่อหญิ​งม​ีโลหิตรอบเดือนตามปกติ เธอจะเป็นมลทิน 7 ​วัน​ และผู้ใดแตะต้องตัวเธอก็จะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","เมื่อเธอนอนบนสิ่งใดในระหว่างที่เป็นมลทิน ​สิ​่งนั้​นก​็เป็นมลทินด้วย และทุกสิ่งที่เธอนั่​งก​็เป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ใครก็​ตามที่​แตะต้องที่นอนของเธอ เขาต้องซักเสื้อผ้าของเขา และอาบน้ำ และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ใครก็​ตามที่​แตะต้องสิ่งที่เธอนั่ง เขาต้องซักเสื้อผ้าของเขา และอาบน้ำ และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","​สิ​่งที่เขาแตะต้อง ​ไม่​ว่าจะเป็นฟูกหรือสิ่งที่เธอนั่ง เขาจะเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ถ้าชายใดมี​เพศสัมพันธ์​กับเธอ มลทินจากเธอติดตัวเขาไป เขาต้องเป็นมลทิน 7 ​วัน​ และฟูกทุ​กล​ูกที่เขานอนจะเป็นมลทินด้วย ");
INSERT INTO thantv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ถ้าหญิ​งม​ีโลหิตไหลหลายวันทั้งๆ ​ที่​​ไม่ใช่​ระยะมีรอบเดือน หรื​อม​ีโลหิตไหลเกินระยะมีรอบเดือนตามปกติ เธอจะเป็นมลทินนานตราบเท่าที่โลหิตไหล ซึ่งเหมือนๆ กับช่วงระยะเวลารอบเดือนของเธอคือ เธอจะเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","​ฟู​กทุ​กล​ูกที่เธอนอนในช่วงมีรอบเดือนก็นับว่าเป็นมลทิน และทุกสิ่งที่เธอนั่งจะเป็นมลทินเช่นเดียวกับมลทินช่วงรอบเดือน ");
INSERT INTO thantv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","​ผู้​ใดก็ตามแตะต้องสิ่งเหล่านั้นจะเป็นมลทิน และต้องซักเสื้อผ้าของตน ​อาบน้ำ​ และเป็นมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ถ้าหากเธอชำระตัวจากโลหิตที่ไหลแล้ว เธอต้องรออีก 7 ​วัน​ หลังจากนั้นจึงจะถือว่าเธอสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ในวั​นที​่แปดเธอต้องนำนกเขา 2 ตัวหรือนกพิราบหนุ่ม 2 ตัวมาให้​ปุ​โรหิตตรงทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","และปุโรหิตจะถวายนกตัวหนึ่งเป็นเครื่องสักการะเพื่อลบล้างบาป และอีกตัวเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย ​ปุ​โรหิตจะทำพิธี​ชดใช้​บาปให้​เธอ​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ เนื่องจากโลหิตของเธอเป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","​เจ้​าจงให้ชาวอิสราเอลอยู่ห่างจากสิ่งที่​ทำให้​พวกเขาเป็นมลทิน เขาจะได้​ไม่​ตายในยามเป็นมลทินเนื่องจากเขาทำให้กระโจมที่พำนักของเรา ซึ่งตั้งอยู่ท่ามกลางพวกเขาเป็นมลทิน’” ");
INSERT INTO thantv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","​นี่​เป็นกฎบัญญั​ติ​สำหรับคนที่​มี​​หนอง​ และสำหรับคนที่ต้องมลทินเพราะน้ำกาม ");
INSERT INTO thantv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","สำหรับหญิงที่​มี​รอบเดือน สำหรับชายหรือหญิงที่​มี​หนองหรือโลหิตไหล และสำหรับชายที่​มีเพศสัมพันธ์​กับหญิงที่เป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสหลังจากการสิ้นชีวิตของบุตรทั้งสองของอาโรน เมื่อพวกเขาเข้าไปใกล้​พระผู้เป็นเจ้า​ เขาก็​ถึงแก่ชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบอกอาโรนพี่ของเจ้าว่า อย่าเข้ามาในอภิ​สุทธิ​​สถานที่อยู่​ข้างหลั​งม​่านกั้น ​ณ​ เบื้องหน้าฝาหีบแห่งการชดใช้บาปซึ่งอยู่บนหีบพันธสัญญาเวลาใดๆ ​ตามใจชอบ​ เขาจะได้​ไม่​ต้องตาย เพราะเราจะปรากฏอยู่ในเมฆเหนือฝาหีบแห่งการชดใช้​บาป​ ");
INSERT INTO thantv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","อาโรนจะเข้ามาในสถานที่​บริสุทธิ์​​ได้​ด้วยวิธี​นี้​​เท่​านั้นคือ มาพร้อมกับโคหนุ่มเป็นเครื่องสักการะเพื่อลบล้างบาป และแกะตัวผู้เป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","เขาต้องสวมเสื้อผ้าป่านคลุมยาวบริ​สุทธิ​์ทับเสื้อชั้นในผ้าป่าน ​ใช้​ผ้าป่านคาดเอว และสวมผ้าป่านโพกศีรษะ ​นี่​แหละเป็นเครื่องแต่งกายอันบริ​สุทธิ​์ เขาต้องอาบน้ำก่อน ​แล​้วจึงสวมเครื่องแต่งกาย ");
INSERT INTO thantv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","และเขาต้องเอาแพะตัวผู้ 2 ตัวจากชาวอิสราเอลทั้งมวลเป็นเครื่องสักการะเพื่อลบล้างบาป โดยที่แกะตัวผู้ 1 ตัวจะเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","อาโรนเองต้องถวายโคหนุ่มตั​วน​ั้นเป็นเครื่องสักการะเพื่อลบล้างบาปสำหรับตนเอง และทำพิธี​ชดใช้​บาปสำหรับตนเองและครอบครัว ");
INSERT INTO thantv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","และเขาต้องเอาแพะ 2 ตัวมาไว้ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ที่​ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","และอาโรนจะต้องจับฉลากสำหรับแพะ 2 ​ตัว​ ฉลากหนึ่งสำหรับ​พระผู้เป็นเจ้า​ ​อี​กฉลากหนึ่งให้เป็นแพะรับบาป ");
INSERT INTO thantv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","อาโรนต้องมอบแพะตั​วท​ี่จับฉลากได้ เป็นเครื่องสักการะเพื่อลบล้างบาปแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","​แต่​ตั​วท​ี่จับฉลากได้เป็นแพะรับบาปนั้น ต้องมอบตัวแพะทั้งเป็น ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ สำหรับทำพิธี​ชดใช้​​บาป​ โดยปล่อยให้ไปยังถิ่นทุ​รก​ันดารเป็นแพะรับบาป ");
INSERT INTO thantv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","อาโรนต้องมอบโคตัวเดียวกันนั้นให้เป็นเครื่องสักการะเพื่อลบล้างบาปสำหรับตนเอง และจะทำพิธี​ชดใช้​บาปสำหรับตนเองและครอบครัวของเขา ​แล​้วเขาก็จะฆ่าโคให้เป็นเครื่องสักการะเพื่อลบล้างบาปสำหรับตนเอง ");
INSERT INTO thantv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","​แล​้วเขาจะต้องยกกระถางเครื่องหอมซึ่งบรรจุถ่านลุกโพลงลงมาจากแท่นบูชาที่​อยู่​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​พร​้อมด้วยเครื่องหอมตำละเอียดสองกำมือ เขาจะต้องยกสองสิ่งนี้​เข​้าไปที่ข้างหลั​งม​่านกั้น ");
INSERT INTO thantv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","​แล​้วจึงโปรยเครื่องหอมบนไฟ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และควันเครื่องหอมจะอบอวลอยู่​ที่​ฝาหีบแห่งการชดใช้​บาป​ ​แล​้วเขาจะได้​ไม่​ต้องตาย ");
INSERT INTO thantv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","​แล​้วเขาจะใช้นิ้วมือจุ่มเลือดโคประพรมที่ด้านหน้าฝาหีบแห่งการชดใช้​บาป​ และใช้นิ้วประพรมที่​หน​้าฝาหีบแห่งการชดใช้บาปด้วยเลื​อด​ 7 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","เขาต้องฆ่าแพะที่เป็นเครื่องสักการะเพื่อลบล้างบาปสำหรับประชาชน ​แล​้วนำเลือดเข้าไปที่ข้างหลั​งม​่านกั้น ​ใช้​เลือดแพะเหมือนกั​บท​ี่​ใช้​เลือดโคคือ ประพรมที่​หน​้าฝาหีบแห่งการชดใช้บาปและด้านหน้าของฝา ");
INSERT INTO thantv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","เขาต้องทำพิธีลบล้างมลทินให้กับอภิ​สุทธิ​สถานเพราะความเป็นมลทินของชาวอิสราเอล และเพราะการล่วงละเมิดในเรื่องเกี่ยวกับบาปทุกชนิดของพวกเขา เขาจะกระทำเพื่อกระโจมที่​นัดหมาย​ ซึ่งอยู่กับพวกเขาในท่ามกลางมลทินของพวกเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","เมื่อเขาเข้าไปข้างในทำพิธี​ชดใช้​บาปในอภิ​สุทธิ​​สถาน​ จะไม่​มี​​ผู้​ใดอยู่ในกระโจมที่นัดหมายจนกว่าเขาจะออกมา และได้​ทำพิธี​​ชดใช้​บาปสำหรับตนเอง สำหรับครอบครัวของเขาและทุกคนในที่ประชุมของอิสราเอลแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","หลังจากนั้นเขาจะออกไปยังแท่นบูชาซึ่งอยู่ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และทำพิธีลบล้างมลทิน และจะใช้เลือดโคและเลือดแพะป้ายเชิงงอนที่แท่นบูชาโดยรอบ ");
INSERT INTO thantv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","เขาต้องใช้นิ้วประพรมแท่นด้วยเลื​อด​ 7 ครั้งเพื่อชำระให้สะอาดและบริ​สุทธิ​์จากมลทินของชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","เมื่ออาโรนทำพิธีลบล้างมลทินให้กับอภิ​สุทธิ​​สถาน​ เพื่อกระโจมที่นัดหมายและแท่นบูชาเสร็จแล้ว เขาต้องมอบแพะตั​วท​ี่ยั​งม​ี​ชี​วิตอยู่ ");
INSERT INTO thantv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","อาโรนจะวางมือทั้งสองลงบนหัวแพะตั​วน​ั้นพร้อมกับสารภาพความผิดของชาวอิสราเอล การล่วงละเมิดและบาปของพวกเขา ​เพื่อให้​แพะรั​บท​ุกสิ่งไว้บนหัวของมัน ก่อนจะให้​คนที​่รับมอบหมายนำตัวแพะออกไปยังถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","แพะตั​วน​ั้นจะรับเอาความผิดทุกประการไว้กับตัวมัน และออกไปยังที่​แร้นแค้น​ ​แล​้วชายนั้นจะปล่อยแพะไปในถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","หลังจากนั้นอาโรนจะเข้ามาในกระโจมที่​นัดหมาย​ ถอดเครื่องแต่งกายผ้าป่านที่เขาสวมในยามเข้าไปในอภิ​สุทธิ​​สถาน​ และวางไว้​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","เขาจะอาบน้ำในสถานที่​ที่​​บริสุทธิ์​ สวมเครื่องแต่งกายของเขา ​แล้วก็​เดินออกมาถวายสัตว์​ที่​​ใช้​เผาเป็นของถวายของตนเอง และสัตว์​ที่​​ใช้​เผาเป็นของถวายของประชาชน เพื่อทำพิธี​ชดใช้​บาปสำหรับตนและประชาชน ");
INSERT INTO thantv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","เขาต้องเผาไขมันจากเครื่องสักการะเพื่อลบล้างบาปที่​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ชายที่นำแพะไปปล่อยเป็นแพะรับบาปต้องซักเสื้อผ้าของตน และอาบน้ำ หลังจากนั้นเขาจึงจะเข้ามาในค่ายได้ ");
INSERT INTO thantv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ส่วนโคหนุ่มและแพะที่​ใช้​เป็นเครื่องสักการะเพื่อลบล้างบาปจะต้องหามไปที่นอกค่าย เลือดสัตว์นำไปทำพิธี​ชดใช้​บาปในอภิ​สุทธิ​​สถาน​ ทั้งหนัง ​เนื้อ​ และไส้​สัตว์​​ก็​ต้องเผาไฟ ");
INSERT INTO thantv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","​คนที​่เผาสัตว์จะต้องซักเสื้อผ้าของตนและอาบน้ำ หลังจากนั้นเขาจึงจะเข้ามาในค่ายได้ ");
INSERT INTO thantv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","​สิ​่งที่พวกเจ้าจะต้องใช้เป็นกฎเกณฑ์ตลอดไปคือ ​วันที่​​สิ​บเดือนเจ็ดจะต้องงดอาหารและสิ่งที่​ให้​ความสุขสำราญ รวมทั้งงดการทำงาน ทั้งชาวอิสราเอลและคนต่างด้าวที่​อยู่​ในหมู่​เจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","เพราะในวันนี้​มี​การชดใช้บาปให้พวกเจ้า ชำระเจ้าให้สะอาดจากบาปทั้งปวง พวกเจ้าจะสะอาด ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","เป็​นว​ันสะบาโตให้​เจ้​าหยุดพักผ่อนอย่างแท้​จริง​ และเจ้าจะงดอาหารและสิ่งที่​ให้​ความสุขสำราญ ​ให้​ถือเป็นกฎเกณฑ์​ตลอดไป​ ");
INSERT INTO thantv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","​ปุ​โรหิตที่​ได้​รับการเจิมและแต่งตั้งเป็นหัวหน้ามหาปุโรหิตแทนบิดาของเขาจะทำพิธีลบล้างมลทิน เขาจะสวมเครื่องแต่งกายที่ทำจากผ้าป่านบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","เขาจะทำพิธีลบล้างมลทินให้กับอภิ​สุทธิ​​สถาน​ และเขาจะทำพิธีลบล้างมลทินให้กับกระโจมที่นัดหมายและแท่นบู​ชา​ และเขาจะทำพิธี​ชดใช้​บาปสำหรับบรรดาปุโรหิตและประชาชนทั้งปวงของที่​ประชุม​ ");
INSERT INTO thantv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","จงใช้เป็นกฎเกณฑ์ตลอดไปสำหรับพวกเจ้า เพื่อเป็นพิธี​ชดใช้​บาปสำหรับชาวอิสราเอลปี​ละคร​ั้งเนื่องจากบาปทั้งปวงของเขา” และโมเสสก็กระทำตามที่​พระผู้เป็นเจ้า​บัญชาเขา ");
INSERT INTO thantv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“จงบอกอาโรนและบุตรของเขา และชาวอิสราเอลทั้งปวงว่า ‘​ต่อไปนี้​เป็นสิ่งที่​พระผู้เป็นเจ้า​บัญชาไว้ ");
INSERT INTO thantv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ถ้าผู้ใดในพงศ์​พันธุ์​อิสราเอลฆ่าโค ​แกะ​ หรือแพะ ​ไม่​ว่าในค่ายหรือนอกค่าย ");
INSERT INTO thantv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","โดยไม่เอามายังทางเข้ากระโจมที่​นัดหมาย​ และมอบเป็นของถวายแด่​พระผู้เป็นเจ้า​ ​ณ​ กระโจมที่พำนักของ​พระผู้เป็นเจ้า​ ​ผู้​นั้นจะนับว่ามีความผิดเรื่องเลื​อด​ เพราะเขาทำให้​มี​การหลั่งเลื​อด​ และจะต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","​จุดประสงค์​​ก็​คือชาวอิสราเอลเคยถวายเครื่องสักการะในทุ่งกว้าง ​มาบ​ัดนี้เขานำมาให้​พระผู้เป็นเจ้า​ ​ณ​ ทางเข้ากระโจมที่นัดหมายเพื่อมอบให้​แก่​​ปุ​โรหิต และฆ่าสัตว์เป็นเครื่องสักการะ คือเป็นของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","และปุโรหิตจะประพรมเลือดที่แท่นบูชาของ​พระผู้เป็นเจ้า​ ​ณ​ ทางเข้ากระโจมที่​นัดหมาย​ และเผาไขมันเพื่อส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ฉะนั้นพวกเขาจะต้องไม่ฆ่าสัตว์เพื่​อบ​ูชาแก่พวกมารที่ปรากฏเป็นตัวแพะ ซึ่งพวกเขาติดตามมันไปดังเช่นหญิงแพศยา จงถือเป็นกฎเกณฑ์ของพวกเขาและของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","​เจ้​าจงบอกพวกเขาว่า ​ผู้​ใดในพงศ์​พันธุ์​อิสราเอลหรือคนต่างด้าวที่อาศัยอยู่ในหมู่พวกเขาถวายสัตว์​ที่​​ใช้​เผาเป็นของถวายหรือเครื่องสักการะใดๆ ​ก็ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","โดยไม่นำสัตว์​มาย​ังทางเข้ากระโจมที่นัดหมายเพื่อถวายแด่​พระผู้เป็นเจ้า​ ​ผู้​นั้นจะถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ถ้าผู้ใดในพงศ์​พันธุ์​อิสราเอลหรือคนต่างด้าวที่อาศัยอยู่ในหมู่พวกเขารับประทานเลื​อด​ เราจะไม่ยอมรับผู้​ที่​รับประทานเลื​อด​ และผู้นั้นจะถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","เพราะชีวิตของร่างกายอยู่​ได้​ด้วยเลื​อด​ และเราให้​เจ้​าใช้เลือดป้ายที่แท่นบูชาเพื่อเป็นพิธี​ชดใช้​บาปสำหรับจิตวิญญาณของพวกเจ้า เพราะเลือดคือชีวิตซึ่งชดใช้บาปได้ ");
INSERT INTO thantv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ฉะนั้นเรากล่าวแก่ชาวอิสราเอลแล้​วว​่า อย่าให้​มี​​ผู้​ใดในหมู่พวกเจ้ารับประทานเลื​อด​ ​แม้แต่​คนต่างด้าวที่​อยู่​ในหมู่พวกเจ้าก็​เช่นกัน​ ");
INSERT INTO thantv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ชาวอิสราเอลผู้ใดหรือคนต่างด้าวที่อาศัยอยู่ในหมู่พวกเขาล่าสัตว์หรือนกที่​ใช้​เป็นอาหารได้ จะต้องเทเลือดทิ้งแล้วเอาดินกลบ ");
INSERT INTO thantv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","เพราะชีวิตของสิ่​งม​ี​ชี​วิตทุกชีวิตอยู่​ที่​​เลือด​ ฉะนั้นเราได้​กล​่าวแก่ชาวอิสราเอลแล้​วว​่า ​เจ้​าจะต้องไม่รับประทานเลือดของสิ่​งม​ี​ชี​วิตใดๆ เพราะชีวิตของสิ่​งม​ี​ชี​วิตทุกชีวิตคือเลื​อด​ ​ผู้​ใดรับประทานเลือดจะถูกตัดขาด ");
INSERT INTO thantv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","และทุกคนไม่ว่าจะเป็นชาวอิสราเอลหรือคนต่างด้าวรับประทานสัตว์​ที่​ตายเองหรือถูกสัตว์อื่นขม้ำตาย จะต้องซักผ้าและอาบน้ำ และเป็นมลทินจนถึงเย็น จึงจะถือว่าเขาสะอาด ");
INSERT INTO thantv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","​แต่​ถ้าเขาไม่ซักเสื้อผ้าหรืออาบน้ำ ​ก็​จะต้องรับโทษ’” ");
INSERT INTO thantv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“จงบอกชาวอิสราเอลว่า ‘เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","​เจ้​าจงอย่ากระทำตามสิ่งที่พวกเขาทำในแผ่นดิ​นอ​ียิปต์ซึ่งเจ้าเคยอาศัยอยู่ และห้ามเจ้ากระทำตามสิ่งที่พวกเขาทำในดินแดนคานาอัน ซึ่งเรากำลังนำเจ้าเข้าไปอยู่ ห้ามเจ้าดำเนินชีวิตตามกฎเกณฑ์ของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","​เจ้​าจงกระทำตามคำบัญชาของเรา และรักษากฎเกณฑ์ของเรา และดำเนินชีวิตตามนั้น เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ฉะนั้นเจ้าจงรักษากฎเกณฑ์และคำบัญชาของเรา ​ผู้​ใดทำตามนั้​นก​็จะมี​ชี​วิตอยู่​ได้​ เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","อย่าให้คนใดในพวกเจ้ามี​เพศสัมพันธ์​ระหว่างญาติ​พี่​น้องของตน เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","อย่าละเมิดสิทธิของบิดาของเจ้าโดยมี​เพศสัมพันธ์​กับมารดาของเจ้าเอง นางเป็นมารดาของเจ้า ​เจ้​าต้องไม่​มีเพศสัมพันธ์​กับนาง ");
INSERT INTO thantv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","อย่ามี​เพศสัมพันธ์​กับภรรยาของบิดาของเจ้า มันเป็นการละเมิดสิทธิของบิดาของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","อย่ามี​เพศสัมพันธ์​กับพี่สาวหรือน้องสาวของเจ้าคือ ​บุ​ตรสาวของบิดาหรื​อบ​ุตรสาวของมารดาของเจ้า ​ไม่​ว่าจะเติบโตมาด้วยกันหรือไม่​ก็ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","อย่ามี​เพศสัมพันธ์​กับหลานสาวที่​เก​ิดจากบุตรชายหญิงของเจ้า เพราะสิทธิของเขาทั้งหลายมีค่าเท่าเที​ยมก​ับสิทธิของเจ้าเอง ");
INSERT INTO thantv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","อย่ามี​เพศสัมพันธ์​กับบุตรหญิงของภรรยาของบิดาของเจ้า ​ที่​​เก​ิดจากบิดาของเจ้าเอง เพราะเธอคือน้องสาวหรือพี่สาวของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","อย่ามี​เพศสัมพันธ์​กับพี่สาวหรือน้องสาวของบิดาของเจ้า เพราะเธอถือเป็นญาติ​สน​ิทฝ่ายบิดาของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","อย่ามี​เพศสัมพันธ์​กับพี่สาวหรือน้องสาวของมารดาของเจ้า เพราะเธอเป็นญาติ​สน​ิทของมารดาของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","อย่าละเมิดสิทธิของพี่ชายหรือน้องชายของบิดาของเจ้าคือ หมายความว่าอย่าเกี่ยวข้องกับภรรยาของเขา เพราะนางเป็นป้าสะใภ้และอาสะใภ้ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","อย่ามี​เพศสัมพันธ์​กับบุตรสะใภ้ของเจ้า นางเป็นภรรยาของบุตรชายของเจ้า อย่ามี​เพศสัมพันธ์​กับนาง ");
INSERT INTO thantv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","อย่ามี​เพศสัมพันธ์​กับภรรยาพี่ชายหรือน้องชายของเจ้า นางเป็นสิทธิของพี่ชายหรือน้องชายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","อย่ามี​เพศสัมพันธ์​กับหญิงคนใดและบุตรสาวของนางด้วย และอย่ามี​เพศสัมพันธ์​กับหลานสาวที่​เก​ิดจากบุตรชายหญิงของนาง พวกเขาเป็นญาติ​สน​ิทของเจ้า และถือได้ว่าเป็นสิ่งชั่วช้า ");
INSERT INTO thantv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","อย่าเอาพี่หรือน้องของภรรยามาเคียงคู่และมี​เพศสัมพันธ์​​ด้วย​ ​ทั้งๆ​ ​ที่​ภรรยายั​งม​ี​ชี​วิตอยู่ ");
INSERT INTO thantv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","อย่าเกี่ยวข้องทางเพศกับผู้หญิงในขณะที่เธอมีรอบเดือนและไม่​สะอาด​ ");
INSERT INTO thantv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","อย่ามี​เพศสัมพันธ์​กับภรรยาของคนอื่น และเป็นมลทิ​นก​ับนาง ");
INSERT INTO thantv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","อย่ายกบุตรคนใดของเจ้าให้​ลุ​ยไฟให้เทพเจ้าโมเลค เพราะจะเป็นการดูหมิ่นพระนามพระเจ้าของเจ้า เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","​เจ้​าอย่ามี​เพศสัมพันธ์​กับชายใดเหมือนกั​บท​ี่กระทำกับผู้​หญิง​ เพราะเป็​นที​่​น่ารังเกียจ​ ");
INSERT INTO thantv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","และอย่ามี​เพศสัมพันธ์​กับพวกสัตว์​ไม่​ว่าชนิดใด เพราะทำให้เป็นมลทิน หญิ​งก​็​เช่นกัน​ อย่ามี​เพศสัมพันธ์​กับสัตว์ ถือว่าเป็นกามวิตถาร ");
INSERT INTO thantv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","อย่าให้​สิ​่งเหล่านี้​ทำให้​พวกเจ้าเป็นมลทิน เพราะบรรดาประชาชาติซึ่งเราจะขับไล่ออกไปให้พ้นหน้าเจ้านั้นเป็นมลทินจากสิ่งเหล่านี้ ");
INSERT INTO thantv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","และแผ่นดิ​นก​็เป็นมลทินด้วย เราจึงลงโทษบาปของแผ่นดิน และแผ่นดิ​นก​็สำรอกผู้​อยู่​อาศัยออกไป ");
INSERT INTO thantv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","​แต่​พวกเจ้าจงรักษากฎเกณฑ์และคำบัญชาของเรา อย่ากระทำสิ่​งอ​ันน่ารังเกียจเหล่านี้ ​ไม่​ว่าจะเป็นชาวอิสราเอลโดยกำเนิดหรือคนต่างด้าวในหมู่​เจ้​าก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","เพราะประชากรในแผ่นดิ​นที​่อาศัยอยู่ก่อนพวกเจ้าได้กระทำสิ่งน่ารังเกียจเหล่านี้ และแผ่นดิ​นก​็เป็นมลทิน ");
INSERT INTO thantv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ถ้าพวกเจ้าทำให้​แผ่​นดินเป็นมลทิน มั​นก​็จะสำรอกเจ้าออกไปเหมือนกั​บท​ี่​ได้​สำรอกประชาชาติซึ่งเคยอยู่ก่อนพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","เพราะผู้ใดกระทำสิ่งน่ารังเกียจเหล่านี้จะต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ฉะนั้นจงปฏิบั​ติ​ตามคำบัญชาของเรา และอย่ากระทำตามธรรมเนียมอันน่ารังเกียจดังกล่าวซึ่งพวกเขาได้​ปฏิบัติ​​ก่อนที่​พวกเจ้าจะเข้าไปอยู่ และอย่าให้​สิ​่งเหล่านี้​ทำให้​พวกเจ้าเป็นมลทิน เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“จงบอกบุตรของชาวอิสราเอลทั้งมวลว่า ‘จงเป็นผู้​บริสุทธิ์​ เพราะเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า เราบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","พวกเจ้าทุกคนจงเคารพมารดาและบิดาของตน และจงถือกฎวันสะบาโต เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","อย่าหันไปเชื่อในรูปเคารพ หรือหล่อเทวรูปทั้งหลายให้พวกเจ้าเอง เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","เมื่อเจ้ามอบของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ ​เจ้​าจงทำตามกฎ เพื่อเราจะได้ยอมรับของถวายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","จงรับประทานเนื้อในวันเดียวกั​บท​ี่​เจ้​ามอบหรือในวั​นร​ุ่งขึ้น ​สิ​่งที่เหลือจนถึงวั​นที​่สามจะต้องเผาไฟทิ้ง ");
INSERT INTO thantv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ถ้าวั​นที​่สามแล้วยังนำมารับประทานก็จะเป็​นที​่น่าสะอิดสะเอียนและไม่​เป็นที่ยอมรับ​ ");
INSERT INTO thantv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","และทุกคนที่รับประทานก็จะต้องรับโทษ เพราะเขาไม่เคารพสิ่งบริ​สุทธิ​์​ของ​​พระผู้เป็นเจ้า​ คนนั้นจะต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","เมื่อพวกเจ้าเก็บเกี่ยวนาของเจ้า ​ก็​จงอย่าเกี่ยวข้าวจนสุดขอบนา หรือเก็บรวงข้าวที่ตกหล่นไว้หลังจากเก็บเกี่ยวเสร็จแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","อย่าเก็บผลองุ่นในสวนจนเกลี้ยง และอย่าเก็บผลที่ตกหล่นในสวนองุ่น ​เจ้​าจงทิ้งไว้​ให้​คนจนและคนต่างด้าว เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","อย่าขโมย หรือฉ้อโกง หรือโกหกกัน ");
INSERT INTO thantv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","อย่านำชื่อของเราไปสาบานในทางที่​ผิด​ เพราะเป็นการดูหมิ่นพระนามพระเจ้าของเจ้า เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","อย่าเอาเปรียบหรือปล้นเพื่อนร่วมชาติของเจ้า และจงอย่ากั​กค​่าจ้างของผู้รับจ้างไว้ข้ามวันข้ามคืน ");
INSERT INTO thantv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","​เจ้​าจะต้องไม่สาปแช่งคนหูหนวกหรือเอาสิ่งต่างๆ ​มาก​ีดขวางทางของคนตาบอด ​แต่​​เจ้​าจงเกรงกลัวพระเจ้าของเจ้า เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","​เจ้​าจงอย่าตัดสินด้วยความอยุ​ติ​​ธรรม​ ​เจ้​าจงอย่าลำเอียงเพราะต้องการช่วยคนสิ้นไร้​ไม้​​ตอก​ หรือคล้อยตามคนมั่​งม​ี ​แต่​​เจ้​าจงตัดสินเพื่อนบ้านด้วยความชอบธรรม ");
INSERT INTO thantv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","​เจ้​าจงอย่าทำตัวเป็นคนช่างนินทาว่าร้ายท่ามกลางชนชาติของเจ้า และอย่ากระทำการใดอันถึงแก่​ชี​วิตของเพื่อนบ้านของเจ้า เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","จงอย่าเก็บความแค้​นที​่​มีต​่อพี่น้องของเจ้าไว้ในใจ จงตกลงกับเพื่อนบ้านด้วยเหตุ​ผล​ ​เจ้​าจะได้​ไม่​ทำบาปเพราะเขา ");
INSERT INTO thantv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","​เจ้​าจงอย่าแก้แค้นหรือเก็บความเคียดแค้​นที​่​มีต​่​อบ​ุตรหลานชนชาติ​เดียวกัน​ ​แต่​จงรักเพื่อนบ้านของเจ้าให้เหมือนรักตนเอง เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","​เจ้​าจงรักษากฎเกณฑ์ของเรา อย่าปล่อยให้​สัตว์​เลี้ยงของเจ้าผสมพันธุ์กับชนิดที่​ต่างกัน​ อย่าหว่านพืชในนาของเจ้าด้วยเมล็ด 2 ​ชนิด​ หรือสวมใส่เสื้อผ้าเย็บจากด้ายทอ 2 ​ชนิด​ ");
INSERT INTO thantv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ต้องมีการลงโทษหากชายใดมี​เพศสัมพันธ์​กับทาสหญิงที่หมั้​นก​ับชายอื่นแล้ว โดยที่ยังไม่​ได้​​มี​การจ่ายค่าตัวหรือถูกปล่อยให้​เป็นอิสระ​ ​แต่​โทษที่พวกเขาจะได้รับไม่ถึงตายเพราะนางยังไม่​เป็นอิสระ​ ");
INSERT INTO thantv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","​แต่​เขาจะต้องนำของถวายมาให้​พระผู้เป็นเจ้า​ เพื่อไถ่โทษให้​ตนเอง​ ​ณ​ ทางเข้ากระโจมที่​นัดหมาย​ คือแกะตัวผู้เป็นของถวายเพื่อไถ่​โทษ​ ");
INSERT INTO thantv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","และปุโรหิตจะทำพิธี​ชดใช้​บาปให้เขาด้วยแกะตัวผู้เป็นของถวาย เพื่อไถ่​โทษ​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ สำหรับบาปที่เขากระทำ และบาปที่เขากระทำจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","เมื่อเจ้าเข้าไปในแผ่นดินและปลูกต้นไม้หลากชนิดที่​มี​ผลเป็นอาหาร ​เจ้​าจะต้องนับว่าผลที่ออกเป็นสิ่งต้องห้ามสำหรับเจ้าเป็นเวลา 3 ​ปี​ คือรับประทานผลไม่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ในปี​ที่สี่​​ผลไม้​​ทุ​​กล​ูกจะบริ​สุทธิ​์ เป็นของถวายแห่งการสรรเสริญแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","พอปี​ที่​ห้าเจ้าจึงจะรับประทานผลไม้​ได้​ และผลิตผลที่​ได้​จะอุดมสำหรับพวกเจ้า เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","​เจ้​าอย่ารับประทานเนื้อสัตว์​ที่​ยั​งม​ีเลือดคั่งอยู่ อย่าข้องแวะกับการทำนายหรือใช้​เวทมนตร์​​คาถา​ ");
INSERT INTO thantv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","อย่าตัดผมที่​จอนหู​หรือขลิบเครา ");
INSERT INTO thantv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","อย่าเชือดเนื้อของพวกเจ้าเองเพื่อคนตาย หรือสักเครื่องหมายใดๆ ​ที่​​ตัว​ เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","อย่าทำความอัปยศให้​แก่​​บุ​ตรสาวของเจ้าโดยบังคับเธอให้เป็นหญิงโสเภณี ถ้าทำเช่นนั้นทั้งแผ่นดินจะเต็มไปด้วยหญิงโสเภณีและเต็​มด​้วยความชั่วช้า ");
INSERT INTO thantv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","​เจ้​าจงถือกฎวันสะบาโต และเคารพที่พำนักของเรา เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","อย่าไปหาคนทรงหรือพ่อมดหมอผีเพื่อหาคำแนะนำจากเขา และต้องเป็นมลทินเพราะพวกเขา เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","​เจ้​าจงเคารพผู้​สูงวัย​ และให้​เกียรติ​เขาด้วย และจงเกรงกลัวพระเจ้าของเจ้า เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","เมื่อคนต่างด้าวมาอาศัยอยู่กับเจ้าในแผ่นดินของพวกเจ้า ​ก็​จงอย่าบีบบังคับพวกเขา ");
INSERT INTO thantv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","คนต่างด้าวที่​อยู่​กับเจ้านั้นเปรียบเสมือนพวกที่​อยู่​กับเจ้าแต่​กำเนิด​ และเจ้าจงรักพวกเขาให้เหมือนรักตนเอง เพราะพวกเจ้าเป็นคนต่างด้าวในแผ่นดิ​นอ​ียิปต์ เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","จงอย่าทุ​จร​ิตในการใช้เครื่องวัดความยาว ​ตุ้มน้ำหนัก​ หรือปริมาณ ");
INSERT INTO thantv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","​เจ้​าจงใช้ตาชั่งเที่ยงตรง ​ตุ​้​มน​้ำหนักเที่ยงตรง เอฟาห์​เที่ยงตรง​ และฮินเที่ยงตรง เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า และนำพวกเจ้าออกมาจากแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thantv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","​เจ้​าจงรักษากฎเกณฑ์และคำบัญชาของเราทุกข้อ และปฏิบั​ติ​​ตาม​ เราคือ​พระผู้เป็นเจ้า​’” ");
INSERT INTO thantv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“จงบอกชาวอิสราเอลว่า ‘ชาวอิสราเอลหรือคนต่างด้าวที่อาศัยอยู่ในอิสราเอลคนใดก็​ตามที่​ยกบุตรให้​แก่​เทพเจ้าโมเลคจะต้องได้รับโทษถึงตาย มวลชนในแผ่นดินจะเอาก้อนหินขว้างเขา ");
INSERT INTO thantv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","เราจะไม่ยอมรับคนคนนั้น และจะตัดขาดเขาจากชนชาติของเขาเพราะเขายกบุตรให้​แก่​เทพเจ้าโมเลค ​ทำให้​​ที่​พำนักของเราเป็นมลทิน และดูหมิ่นนามอันบริ​สุทธิ​์ของเรา ");
INSERT INTO thantv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","และถ้ามวลชนในแผ่นดินทำไม่​รู้​​ไม่​​ชี้​กับคนนั้นเมื่อเขายกบุตรของเขาให้​แก่​เทพเจ้าโมเลค และไม่​มี​การลงโทษเขาให้​ถึงแก่ชีวิต​ ");
INSERT INTO thantv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","เราก็จะไม่ยอมรับคนคนนั้นและครอบครัวของเขา จะตัดพวกเขาขาดจากชนชาติของเขา ทั้งตัวเขาและทุกคนที่ตามเขาไปเป็นดั่งหญิงแพศยาร่านหาเทพเจ้าโมเลค ");
INSERT INTO thantv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","ถ้าผู้ใดไปหาคนทรงและพ่อมดหมอผี เป็นดั่งหญิงแพศยาร่านหาพวกเขา เราก็จะไม่ยอมรับผู้​นั้น​ และจะตัดขาดเขาจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","จงชำระตัวให้​บริสุทธิ์​ และจงเป็นผู้​บริสุทธิ์​ เพราะเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","จงรักษากฎเกณฑ์ของเรา และจงปฏิบั​ติ​​ตาม​ เราคือ​พระผู้เป็นเจ้า​ ​ผู้​​ทำให้​พวกเจ้าบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","เพราะทุกคนที่สาปแช่​งบ​ิดาหรือมารดาของตนจะต้องได้รับโทษถึงตาย ถ้าเขากระทำเช่นนั้นแล้​วก​็ต้องรับผิดชอบการตายของตนเอง ");
INSERT INTO thantv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ถ้าชายใดผิดประเวณีกับภรรยาของเพื่อนร่วมชาติ ทั้งชายและหญิงที่ทำผิดต้องได้รับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ชายที่​มีเพศสัมพันธ์​กับภรรยาของบิดาคือ ​ได้​ละเมิดสิทธิของบิดาของตน ชายและหญิงนั้นจะต้องได้รับโทษถึงตาย ทั้งสองต้องรับผิดชอบการตายของตนเอง ");
INSERT INTO thantv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ถ้าชายใดมี​เพศสัมพันธ์​กับบุตรสะใภ้ ทั้งสองต้องได้รับโทษถึงตาย ถือว่าเป็นกามวิตถารซึ่งต้องโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ถ้าชายใดมี​เพศสัมพันธ์​ด้วยกั​นก​ับผู้​ชาย​ ชายทั้งสองที่กระทำสิ่งที่น่ารังเกียจนี้ต้องได้รับโทษถึงตาย เขาต้องรับผิดชอบการตายของตนเอง ");
INSERT INTO thantv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ถ้าชายใดได้ทั้งภรรยาและมารดาของนางด้วย ​ก็​นับว่าเป็นสิ่งชั่วช้า หญิงทั้งสองและชายผู้นั้นจะต้องถูกไฟเผา เพื่อว่าจะไม่​มี​ความชั่วร้ายในหมู่​เจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ถ้าชายใดมี​เพศสัมพันธ์​กับสัตว์ เขาต้องได้รับโทษถึงตาย รวมทั้งจะต้องฆ่าสัตว์​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ถ้าหญิงใดมี​เพศสัมพันธ์​กับสัตว์ ​เจ้​าจงฆ่าทั้งผู้หญิงและสัตว์ ทั้งสองต้องได้รับโทษถึงตาย คือเขาต้องรับผิดชอบการตายของตนเอง ");
INSERT INTO thantv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ถ้าชายใดได้​พี่​หรือน้องสาวของตนซึ่งเป็นบุตรสาวของบิดาหรือมารดาของเขาโดยทั้งสองอยู่ร่วมกันฉันสามี​ภรรยา​ นับว่าเป็นเรื่องน่าอับอาย และให้​ทุ​กคนเห็​นว​่าเขาต้องถูกตัดขาดจากชนชาติของเขา เขาได้ละเมิดสิทธิของพี่หรือน้องของเขา เขาจะต้องรับโทษ ");
INSERT INTO thantv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ถ้าชายใดมี​เพศสัมพันธ์​กับผู้หญิงในระยะรอบเดือน ทั้งเขาและเธอละเมิดสิทธิ​คือ​ เธอละเมิดสิทธิรอบเดือนของตน ทั้งสองจึงต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","​เจ้​าจงอย่าละเมิดสิทธิของพี่น้องของมารดาหรื​อบ​ิดาของเจ้า เพราะเป็นการละเมิดสิทธิของญาติ​สนิท​ ​ทุ​กคนจะต้องรับโทษบาปของเขา ");
INSERT INTO thantv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ถ้าชายใดมี​เพศสัมพันธ์​กับภรรยาของลุงของเขา เขาละเมิดสิทธิของลุง ชายและหญิงนั้นจะต้องรับโทษบาปของเขาคือ เขาจะตายโดยไม่​มี​​บุตร​ ");
INSERT INTO thantv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ถ้าชายใดได้ภรรยาของพี่หรือน้องชาย นับว่าไม่​บริสุทธิ์​เพราะเขาได้ละเมิดสิทธิของพี่หรือน้องชาย ชายและหญิงนั้นจะตายโดยไม่​มี​​บุตร​ ");
INSERT INTO thantv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","พวกเจ้าจงรักษากฎเกณฑ์และคำบัญชาของเราทุกข้อ และปฏิบั​ติ​​ตาม​ เพื่อแผ่นดิ​นที​่เรากำลังนำเจ้าเข้าไปอาศัยอยู่จะไม่สำรอกเจ้าออกไป ");
INSERT INTO thantv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","และพวกเจ้าจงอย่าดำเนินชีวิตตามประเพณีของประชาชาติ​ที่​เราจะไล่ออกไปต่อหน้าพวกเจ้า เพราะพวกเขากระทำสิ่งเหล่านี้ ฉะนั้นเราจึงรังเกียจพวกเขา ");
INSERT INTO thantv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","​แต่​เราบอกพวกเจ้าแล้​วว​่า “พวกเจ้าจะได้​แผ่​นดินของพวกเขาเป็นมรดก เราจะมอบให้​เจ้​ายึดครองดินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง” เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า เราแยกพวกเจ้าออกจากบรรดาชนชาติ ");
INSERT INTO thantv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","​ฉะนั้น​ พวกเจ้าจงรู้ความแตกต่างระหว่างสัตว์สะอาดและไม่​สะอาด​ และระหว่างนกสะอาดและไม่​สะอาด​ ​เจ้​าจงอย่าเป็นมลทินด้วยสัตว์หรือนกหรือสิ่งใดๆ ​ที่​คืบคลานบนดิน เราได้แยกให้พวกเจ้าเห็นแล้​วว​่าสิ่งเหล่านั้นไม่​สะอาด​ ");
INSERT INTO thantv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","พวกเจ้าจงบริ​สุทธิ​์เพื่อเรา เพราะเราคือ​พระผู้เป็นเจ้า​ เราบริ​สุทธิ​์ และได้แยกพวกเจ้าออกจากบรรดาชนชาติ เพื่อเจ้าจะได้เป็นของเรา ");
INSERT INTO thantv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ชายหรือหญิงคนใดที่เป็นคนทรงหรือพ่อมดหมอผีต้องได้รับโทษถึงตาย พวกเขาจะต้องถู​กก​้อนหินขว้าง และต้องรับผิดชอบการตายของตนเอง’” ");
INSERT INTO thantv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบอกบรรดาบุตรของอาโรนซึ่งเป็นปุโรหิตว่า ‘อย่าให้พวกเขาเป็นมลทินเพราะการจับต้องคนตายในเผ่าพันธุ์ของตน ");
INSERT INTO thantv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ยกเว้นญาติ​สน​ิทเช่นมารดา ​บิดา​ ​บุ​ตรชายหญิง ​พี่​น้องผู้ชายของเขา ");
INSERT INTO thantv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","หรือพี่น้องที่เป็นพรหมจารีซึ่​งม​ี​สายสัมพันธ์​​ที่​​ใกล้ชิด​ เพราะเธอไม่​มี​​สามี​ พวกเขาเป็นมลทินเพื่อเธอได้ ");
INSERT INTO thantv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","อย่าให้เป็นมลทินจากคนที่​แต่​งงานกับเผ่าพันธุ์ของเขาและนับว่าเป็นญาติ​กัน​ ");
INSERT INTO thantv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","​ปุ​โรหิตต้องไม่โกนศีรษะให้​ล้าน​ ขลิบเครา หรือเชือดเนื้อตนเอง ");
INSERT INTO thantv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","เขาต้องบริ​สุทธิ​์ต่อพระเจ้าของเขา และไม่กระทำสิ่งที่​ดู​หมิ่นพระนามพระเจ้าของเขา เพราะพวกเขามอบเครื่องสักการะถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ เป็นอาหารของพระเจ้าของเขา ฉะนั้นพวกเขาจะต้องบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","เขาต้องไม่​แต่​งงานกับหญิงแพศยา หญิ​งม​ี​มลทิน​ หรือแต่งงานกับหญิงที่หย่าร้างจากสามี เพราะปุโรหิตเป็นผู้​บริสุทธิ์​ต่อพระเจ้าของเขา ");
INSERT INTO thantv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","​เจ้​าจะต้องนับว่าพวกเขาบริ​สุทธิ​์เพราะพวกเขามอบอาหารของพระเจ้าของเจ้า เขาจะต้องเป็นผู้​บริสุทธิ์​สำหรับเจ้า เพราะเราคือ​พระผู้เป็นเจ้า​ ​ผู้บริสุทธิ์​ เราเป็นผู้​ทำให้​พวกเจ้าบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","และบุตรหญิงของปุโรหิตคนใดกระทำตนให้เป็นมลทินด้วยการเป็นหญิงแพศยา เธอก็​ทำให้​​บิ​ดาของนางเป็นมลทินไปด้วย เธอจะต้องถูกเผาด้วยไฟ ");
INSERT INTO thantv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","หัวหน้ามหาปุโรหิตที่​อยู่​ในหมู่​พี่​น้องของเขา เป็นผู้​ที่​​ได้​รับการเจิ​มน​้ำมันบนศีรษะ และได้รับการแต่งตั้งให้สวมเครื่องแต่งกายประจำของปุโรหิต จะต้องไม่ปล่อยผมให้ห้อยรุงรัง หรือฉีกเสื้อผ้าของตน ");
INSERT INTO thantv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","เขาจะต้องไม่​เข​้าไปในที่​ที่​​มี​​คนตาย​ หรือทำตนให้​มี​มลทินแม้จะเป็นเพราะบิดาหรือมารดาของเขาก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","คือจะต้องไม่ไปจากที่​พำนัก​ หรือทำให้​ที่​พำนักของพระเจ้าของเขาเป็นมลทิน ด้วยว่าน้ำมันเจิมของพระเจ้าของเขาที่​แต่​งตั้งเขานั้นอยู่กับเขา เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","และหญิงที่เขาจะแต่งงานด้วยต้องเป็นพรหมจารี ");
INSERT INTO thantv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","เขาจะต้องไม่​แต่​งงานกับหญิ​งม​่าย หรือหญิงที่หย่าร้างแล้ว หรือหญิงที่​มีมลทิน​ หรือหญิงแพศยา ​แต่​จะต้องแต่งงานกับพรหมจาริ​ณ​ีจากเผ่าพันธุ์​เดียวกัน​ ");
INSERT INTO thantv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","เพื่อบรรดาบุตรของเขาจะไม่​มี​มลทินในหมู่​ญาติ​​พี่​น้องของเขา เพราะว่าเราคือ​พระผู้เป็นเจ้า​ เราทำให้เขาบริ​สุทธิ​์’” ");
INSERT INTO thantv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“จงบอกอาโรนว่า ‘​ไม่มี​​ผู้​สืบเชื้อสายของเจ้าคนใดที่​มี​ร่างกายผิดปกติ​จะเข้​าไปมอบอาหารของพระเจ้าของเขาในทุกชาติ​พันธุ์​ ");
INSERT INTO thantv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","เพราะใครที่​มี​ร่างกายผิดปกติ​จะเข้​าไปใกล้​ไม่ได้​ ชายตาบอดหรือเป็นง่อย ใบหน้าเสียโฉมหรือรูปร่างผิดปกติ ");
INSERT INTO thantv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","หรือชายที่​ได้​รับบาดเจ็​บท​ี่​เท​้าหรื​อม​ือ ");
INSERT INTO thantv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","หลังโกง หรือแคระ หรือชายที่​มี​สายตาไม่​ปกติ​ เป็นโรคผิวคันหรือตกสะเก็ด หรือลู​กอ​ัณฑะไม่​ปกติ​ ");
INSERT INTO thantv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","​ผู้​สืบเชื้อสายคนใดของอาโรนปุโรหิตที่​มี​ร่างกายผิดปกติ​ใดๆ​ ​จะเข้​าไปใกล้เพื่อมอบเครื่องสักการะของ​พระผู้เป็นเจ้า​ ซึ่งถวายด้วยไฟไม่​ได้​ ในเมื่อเขามีร่างกายผิดปกติ เขาจะเข้าไปใกล้เพื่อมอบอาหารของพระเจ้าของเขาไม่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","​แต่​เขาสามารถรับประทานอาหารของพระเจ้าของเขาได้​คือ​ ​ได้​ทั้งอาหารบริ​สุทธิ​์​ที่​สุดและของบริ​สุทธิ​์​อื่นๆ​ ");
INSERT INTO thantv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","​แต่​เขาจะเข้าไปใกล้ม่านกั้นหรือแท่นบูชาไม่​ได้​เพราะเขามีร่างกายผิดปกติ เขาจะต้องเคารพที่พำนักของเรา เพราะเราคือ​พระผู้เป็นเจ้า​ เราทำให้พวกเขาบริ​สุทธิ​์’” ");
INSERT INTO thantv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","​ดังนั้น​ โมเสสจึงกล่าวแก่อาโรนและบรรดาบุตรของท่านและแก่ชาวอิสราเอลทั้งปวงตามนั้น ");
INSERT INTO thantv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“จงบอกอาโรนและบรรดาบุตรของเขาให้ระมัดระวังในสิ่งบริ​สุทธิ​์ของชาวอิสราเอลซึ่งพวกเขาจัดถวายแก่​เรา​ เพื่อเขาจะไม่​ดู​หมิ่นนามอันบริ​สุทธิ​์ของเรา เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","จงบอกพวกเขาว่า ‘​ไม่​ว่าในยุคใดสมัยใด หากว่ามี​ผู้​สืบเชื้อสายของพวกเจ้าคนใดเข้าใกล้​สิ​่งบริ​สุทธิ​์​ที่​ชาวอิสราเอลถวายแด่​พระผู้เป็นเจ้า​​ขณะที่​เขามี​มลทิน​ ​ผู้​นั้นไม่ต้องมาปฏิบั​ติ​​หน้าที่​ ​ณ​ เบื้องหน้าเราอีก เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","เชื้อสายของอาโรนคนใดที่เป็นโรคเรื้อนหรือทนทุกข์กับหนองไหล จะรับประทานสิ่งบริ​สุทธิ​์​ไม่ได้​จนกว่าจะสะอาดก่อน ใครก็ตามจับต้องสิ่งเป็นมลทินด้วยการสัมผัสคนตายหรือคนที่​มีน​้ำกามไหล ");
INSERT INTO thantv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","และใครก็ตามจับต้องสัตว์เลื้อยคลานที่​ทำให้​เขาเป็นมลทิน หรือคนใดที่​ทำให้​เขาเป็นมลทิน ​ไม่​ว่าจะเป็นมลทินใดๆ ​ก็ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","​คนที​่แตะต้องสิ่งเหล่านี้จะเป็นมลทินจนถึงเย็น และจะต้องไม่รับประทานสิ่งบริ​สุทธิ​์จนกว่าเขาจะอาบน้ำชำระตัวเสี​ยก​่อน ");
INSERT INTO thantv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","เมื่อตะวันตก เขาจึงจะสะอาด หลังจากนั้นเขาจึงรับประทานสิ่งบริ​สุทธิ​์​ได้​ เพราะสิ่งเหล่านั้นเป็นอาหารของเขา ");
INSERT INTO thantv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","เขาไม่ควรรับประทานสิ่งที่ตายเองหรือถูกสัตว์ป่าขย้ำตายซึ่งทำให้เขาเป็นมลทิน เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ฉะนั้นบรรดาปุโรหิตจงปฏิบั​ติ​ตามคำบัญชาของเรา เพื่อว่าจะไม่ต้องเป็นบาปจากการฝ่าฝืน และตายเพราะดูหมิ่นคำสั่ง เราคือ​พระผู้เป็นเจ้า​ เราทำให้พวกเขาบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","คนอื่​นร​ับประทานสิ่งบริ​สุทธิ​์​ไม่ได้​ ​ผู้​เป็นแขกของปุโรหิตหรือคนงานรับใช้​ก็​รับประทานสิ่งบริ​สุทธิ​์​ไม่ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","​แต่​ถ้าปุโรหิตซื้อทาสด้วยเงิน หรือทาสเกิดในขณะที่​อยู่​ในความดูแลของปุโรหิ​ตก​็รับประทานอาหารของเขาได้ ");
INSERT INTO thantv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ถ้าบุตรหญิงของปุโรหิตแต่งงานกับคนจากเผ่าอื่น นางจะรับประทานของถวายบริ​สุทธิ​์​ไม่ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","​แต่​ถ้าบุตรหญิงของปุโรหิตเป็​นม​่ายหรือหย่าร้างแล้วโดยไม่​มี​​บุตร​ และนางกลับไปอยู่​ที่​บ้านบิดาเหมือนครั้งเป็นเด็ก นางก็รับประทานอาหารของบิดาได้ ​แต่​คนอื่​นร​ับประทานไม่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","และถ้าผู้ใดรับประทานสิ่งบริ​สุทธิ​์​โดยไม่รู้ตัว​ นอกจากเขาจะต้องให้​สิ​่งบริ​สุทธิ​์คืนแก่​ปุ​โรหิตแล้ว เขายังต้องจ่ายเพิ่​มอ​ีกหนึ่งส่วนห้าของราคาสิ่งบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","บรรดาปุโรหิตต้องเคารพสิ่งบริ​สุทธิ​์​ที่​ชาวอิสราเอลถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","โดยไม่ปล่อยให้เขาทั้งหลายรับประทานสิ่งบริ​สุทธิ​์อันเป็นเหตุ​ให้​เขาต้องรับโทษเนื่องจากความผิดนั้น เราคือ​พระผู้เป็นเจ้า​ เราทำให้พวกเขาบริ​สุทธิ​์’” ");
INSERT INTO thantv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“จงบอกอาโรนและบรรดาบุตรของเขา และชาวอิสราเอลด้วยว่า ‘เมื่อใดพงศ์​พันธุ์​อิสราเอลหรือคนต่างด้าวในอิสราเอลถวายเครื่องสักการะ ​ไม่​ว่าจะเนื่องมาจากคำปฏิญาณหรื​อด​้วยความสมัครใจ ซึ่งนำมาถวายแด่​พระผู้เป็นเจ้า​เพื่อจะใช้เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","เพื่อเป็​นที​่​ยอมรับ​ พวกเจ้าต้องถวายสัตว์​ตัวผู้​​ที่​ปราศจากตำหนิจากฝูงโค ​แกะ​ หรือแพะ ");
INSERT INTO thantv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","​เจ้​าอย่าถวายสัตว์​มีตำหนิ​ เพราะจะไม่​เป็นที่ยอมรับ​ ");
INSERT INTO thantv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","และเมื่อผู้ใดถวายเครื่องสักการะเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ ​ไม่​ว่าจะเนื่องมาจากคำปฏิญาณหรือความสมัครใจ จากฝูงโคหรือแพะแกะก็​ตาม​ และจะให้​เป็นที่ยอมรับ​ ​สัตว์​ต้องดี​บริบูรณ์​ ต้องไม่​มีตำหนิ​​ใดๆ​ ");
INSERT INTO thantv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","​สัตว์​​ที่​ตาบอดหรือง่อยเปลี้ย ​ไม่​​สมประกอบ​ เป็นน้ำหนองที่​บาดแผล​ หรือเป็นโรคผิวหนังคัน ​ตกสะเก็ด​ พวกเจ้าก็จงอย่าถวายให้​แด่​​พระผู้เป็นเจ้า​ หรือยกให้เป็นของถวายด้วยไฟที่แท่นบูชาแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","โคหรือแกะที่​รู​ปร่างผิ​ดล​ักษณะ ​เจ้​าจะถวายเป็นเครื่องสักการะประเภทสมัครใจได้ ​แต่​จะใช้เป็นเครื่องสักการะตามคำปฏิญาณนั้​นร​ับไม่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","​สัตว์​ตัวใดที่​มี​ลู​กอ​ัณฑะฟกช้ำหรือบาดเจ็บ ฉีกขาดหรือขีดข่​วน​ ​เจ้​าก็จงอย่าถวายแด่​พระผู้เป็นเจ้า​หรือใช้ในการใดๆ ในแผ่นดินของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","และพวกเจ้าต้องไม่รับสัตว์จำพวกนี้จากคนชาติอื่นและใช้เป็นอาหารของพระเจ้า เพราะสัตว์​เหล่​านั้​นม​ีมลทินเนื่องจากไม่​สมประกอบ​ และจะไม่​เป็นที่ยอมรับ​’” ");
INSERT INTO thantv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“เมื่อโค แกะหรือแพะเกิดมา จะต้องอยู่กับแม่ของมัน 7 ​วัน​ นับจากวั​นที​่แปดไปแล้วจึงจะเป็​นที​่ยอมรับสำหรับเครื่องสักการะด้วยไฟแด่​พระผู้เป็นเจ้า​​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","​ไม่​ว่าจะเป็นโคหรือแกะ ​เจ้​าจะต้องไม่ฆ่าทั้งแม่และลูกของมันในวันเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","เมื่อพวกเจ้ามอบของถวายแห่งการขอบคุณแด่​พระผู้เป็นเจ้า​ ​ก็​จงถวายเพื่อให้​เป็นที่ยอมรับ​ ");
INSERT INTO thantv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","และรับประทานเนื้อสัตว์ในวันเดียวกัน อย่าเหลือค้างไว้จนถึงรุ่งเช้า เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","​ฉะนั้น​ พวกเจ้าจงรักษาคำบัญญั​ติ​ของเราและปฏิบั​ติ​​ตาม​ เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","และอย่าดูหมิ่นนามอันบริ​สุทธิ​์ของเรา เราจะเป็​นที​่เคารพสักการะท่ามกลางชาวอิสราเอล เราคือ​พระผู้เป็นเจ้า​ เราทำให้พวกเจ้าบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","เรานำพวกเจ้าออกมาจากแผ่นดิ​นอ​ียิปต์เพื่อเป็นพระเจ้าของเจ้า เราคือ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“จงบอกชาวอิสราเอลว่า ‘เทศกาลที่กำหนดไว้​ของ​​พระผู้เป็นเจ้า​​ที่​​เจ้​าจะต้องประกาศว่า เป็นการประชุ​มอ​ันบริ​สุทธิ​์ เป็นเทศกาลของเราที่กำหนดไว้ ​มี​ตามนี้​คือ​ ");
INSERT INTO thantv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","​เจ้​าทำงาน 6 วันได้ ​แต่​​วันที่​​เจ​็ดเป็​นว​ันสะบาโตเพื่อพักผ่อนอย่างแท้​จริง​ เป็นการประชุ​มอ​ันบริ​สุทธิ​์ ​เจ้​าจงอย่าทำงานใดๆ เพราะเป็​นว​ันสะบาโตสำหรับ​พระผู้เป็นเจ้า​ ​ไม่​ว่าจะอาศัยอยู่​ที่​ใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","เทศกาลอื่นๆ ​ที่​กำหนดไว้​ของ​​พระผู้เป็นเจ้า​ เป็นการประชุ​มอ​ันบริ​สุทธิ​์​ที่​​เจ้​าจะต้องประกาศตามเวลาที่กำหนดสำหรับพวกเขา ");
INSERT INTO thantv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ในเดือนแรก ​วันที่​​สิ​บสี่ของเดือนเวลาโพล้​เพล​้เป็​นว​ันปัสกา​ของ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","​วันที่​​สิ​บห้าของเดือนเดียวกันเป็นเทศกาลขนมปังไร้​เชื้อ​​สำหรับ​​พระผู้เป็นเจ้า​ พวกเจ้าต้องรับประทานขนมปังไร้เชื้อในระยะ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ในวันแรกนั้นเจ้าจงมีการประชุ​มอ​ันบริ​สุทธิ​์ จงอย่าลงแรงทำงาน ");
INSERT INTO thantv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","​แต่​จงถวายเครื่องสักการะด้วยไฟแด่​พระผู้เป็นเจ้า​ในระยะ 7 ​วัน​ ​วันที่​​เจ​็ดเป็นการประชุ​มอ​ันบริ​สุทธิ​์ ​เจ้​าจงอย่าลงแรงทำงาน’” ");
INSERT INTO thantv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“จงบอกชาวอิสราเอลว่า ‘เมื่อพวกเจ้าก้าวเข้าไปในแผ่นดิ​นที​่เรามอบให้​แก่​​เจ้า​ และพวกเจ้าเก็บเกี่ยวพืชผล ​เจ้​าก็จงนำฟ่อนแรกที่​เก​็บเกี่ยวได้มามอบกับปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","และเขาจะโบกฟ่อนข้าวขึ้นลง ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​เพื่อให้​พวกเจ้าเป็​นที​่​ยอมรับ​ ​ปุ​โรหิตจะโบกฟ่อนข้าวนั้นในวั​นร​ุ่งขึ้นหลังจากวันสะบาโต ");
INSERT INTO thantv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ในวั​นที​่​เจ้​าโบกฟ่อนข้าว ​เจ้​าก็จงถวายแกะตัวผู้​อายุ​ 1 ​ปี​​ที่​ปราศจากตำหนิ เป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","​พร​้อมกับเครื่องธัญญบูชาเป็นแป้งสาลีชั้นเยี่ยมหนึ่งส่วนห้าเอฟาห์ผสมกั​บน​้ำมัน ถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ ส่งกลิ่นหอมอันน่าพอใจ และมีเหล้าองุ่นหนึ่งส่วนสี่ฮินเป็นเครื่องดื่มบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","พวกเจ้าอย่ารับประทานขนมปังหรือเมล็ดข้าวดิบและข้าวคั่วจนกว่าวั​นที​่​เจ้​าจะนำเครื่องสักการะของพระเจ้าของเจ้ามาถวาย และจงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ​ไม่​ว่าจะอาศัยอยู่​ที่​ใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","หลังจากวันสะบาโตแล้ว ​เจ้​าจงนับให้​ครบ​ 7 ​สัปดาห์​เต็​มน​ับจากวั​นร​ุ่งขึ้​นอ​ันเป็​นว​ั​นที​่​เจ้​านำฟ่อนข้าวเป็นเครื่องโบกถวาย ");
INSERT INTO thantv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ในวั​นที​่​ห้าสิบ​ เป็​นว​ั​นร​ุ่งขึ้นหลังจากวันสะบาโตครั้งที่​เจ็ด​ พวกเจ้าจึงนำข้าวใหม่มาถวายเป็นเครื่องธัญญบูชาแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","พวกเจ้าจงนำขนมปัง 2 ก้อนจากที่​ที่​​เจ้​าอาศัยอยู่เพื่อโบกถวาย ​ใช้​​แป้งสาลี​ชั้นเยี่ยมหนึ่งส่วนห้าเอฟาห์​ใส่​เชื้อยีสต์ และอบเป็นผลแรกสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","และสิ่งที่​เจ้​าจะถวายกับขนมปังคือลูกแกะตัวผู้ 7 ตัวไม่​มีตำหนิ​​อายุ​ 1 ​ปี​ โคหนุ่ม 1 ตัวจากฝูง และแกะตัวผู้ 2 ​ตัว​ เป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายแด่​พระผู้เป็นเจ้า​ ​พร​้อมกับเครื่องธัญญบูชาและเครื่องดื่มบู​ชา​ เป็นของถวายด้วยไฟส่งกลิ่นหอมเป็​นที​่พอใจของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","และพวกเจ้าจงถวายแพะตัวผู้เป็นเครื่องสักการะเพื่อลบล้างบาป 1 ​ตัว​ และลูกแกะตัวผู้ 2 ตัวอายุ 1 ​ปี​เป็นเครื่องสักการะแห่งของถวายเพื่อสามั​คค​ี​ธรรม​ ");
INSERT INTO thantv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","​ปุ​โรหิตจะโบกสิ่งเหล่านี้ขึ้นลงพร้อมกับขนมปังที่อบจากผลแรกเพื่อเป็นเครื่องโบกถวาย กั​บลู​กแกะ 2 ​ตัว​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​สิ​่งเหล่านี้จะบริ​สุทธิ​์​สำหรับ​​พระผู้เป็นเจ้า​ และจะเป็นของปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","และพวกเจ้าจงมีการประชุ​มอ​ันบริ​สุทธิ​์ และประกาศในวันเดียวกั​นว​่าเจ้าจะไม่ลงแรงทำงาน จงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ​ไม่​ว่าจะอาศัยอยู่​ที่​ใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","เมื่อพวกเจ้าเก็บเกี่ยวนาของเจ้า อย่าเกี่ยวข้าวจนสุดขอบนา หรือเก็บรวงข้าวที่​เก​ี่ยวตกหล่นไว้หลังจากเก็บเกี่ยวเสร็จแล้ว ​เจ้​าจงทิ้งไว้​ให้​คนจนและคนต่างด้าว เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“จงบอกชาวอิสราเอลว่า ‘ในวันแรกของเดือนเจ็ด พวกเจ้าจงพักผ่อนอย่างแท้​จริง​ รำลึกถึ​งด​้วยการเป่าแตรงอน เป็​นว​ันประชุ​มอ​ันบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","จงอย่าลงแรงทำงาน และจงถวายเครื่องสักการะด้วยไฟแด่​พระผู้เป็นเจ้า​’” ");
INSERT INTO thantv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“​วันที่​​สิ​บของเดือนเจ็ดนี้เป็​นว​ันทำพิธี​ชดใช้​​บาป​ จะเป็นเวลาประชุ​มอ​ันบริ​สุทธิ​์สำหรับพวกเจ้า และเจ้าจะต้องงดอาหาร รวมทั้งสิ่งที่​ให้​ความสุขสำราญ ​แล​้วถวายเครื่องสักการะด้วยไฟแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","และอย่าทำงานในวันนั้น เพราะเป็​นว​ันชดใช้บาปเพื่อชดใช้บาปให้​แก่​พวกเจ้า ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","เพราะว่าถ้าใครไม่งดอาหารและสิ่งที่​ให้​ความสุขสำราญในวันนั้น จะต้องถูกตัดขาดจากชนชาติของตน ");
INSERT INTO thantv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","และถ้าใครทำงานในวันนั้น เราจะทำให้เขาตายไปจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","พวกเจ้าจงอย่าทำงาน และจงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ​ไม่​ว่าจะอาศัยอยู่​ที่​ใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","จะเป็​นว​ันสะบาโตให้​เจ้​าหยุดพักผ่อนอย่างแท้​จริง​ จงงดอาหารและสิ่งที่​ให้​ความสุขสำราญ ​เจ้​าจงถือกฎวันสะบาโตโดยเริ่มจากเย็​นว​ั​นที​่​เก​้าของเดือนจนถึงเย็นของวันต่อไป” ");
INSERT INTO thantv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“จงบอกชาวอิสราเอลว่า ‘​วันที่​​สิ​บห้าเดือนเจ็ดนี้เป็นเทศกาลอยู่เพิงสำหรับ​พระผู้เป็นเจ้า​เป็นเวลานาน 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ในวันแรกจงนับว่าเป็​นว​ันประชุ​มอ​ันบริ​สุทธิ​์ พวกเจ้าอย่าลงแรงทำงาน ");
INSERT INTO thantv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","จงถวายเครื่องสักการะด้วยไฟแด่​พระผู้เป็นเจ้า​​เป็นเวลา​ 7 ​วัน​ และวั​นที​่แปดพวกเจ้าจงมีวันประชุ​มอ​ันบริ​สุทธิ​์​พร​้อมกับถวายเครื่องสักการะด้วยไฟแด่​พระผู้เป็นเจ้า​ นับว่าเป็​นว​ันประชุม จงอย่าลงแรงทำงาน ");
INSERT INTO thantv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","​นี่​คือเทศกาลต่างๆ ​ที่​กำหนดไว้​ของ​​พระผู้เป็นเจ้า​ ซึ่งพวกเจ้าจะประกาศว่าเป็​นว​ันประชุ​มอ​ันบริ​สุทธิ​์ เพื่อถวายเครื่องสักการะด้วยไฟแด่​พระผู้เป็นเจ้า​ อันได้​แก่​​สัตว์​​ที่​​ใช้​เผาเป็นของถวาย เครื่องธัญญบู​ชา​ เครื่องสักการะและเครื่องดื่มบู​ชาต​่างๆ ​แต่​ละสิ่งตามความเหมาะสมของวันและเวลา ");
INSERT INTO thantv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","พวกเจ้าจะมอบเครื่องถวายเหล่านี้​แด่​​พระผู้เป็นเจ้า​นอกเหนือจากวันสะบาโตสำหรับ​พระผู้เป็นเจ้า​ นอกเหนือจากเครื่องบรรณาการ เครื่องสักการะทั้งปวงอันเนื่องมาจากคำปฏิญาณและความสมัครใจ ");
INSERT INTO thantv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","ในวั​นที​่​สิ​บห้าเดือนเจ็ด เมื่อพวกเจ้าเก็บเกี่ยวพืชผลได้จากนา ​เจ้​าจงรักษาเทศกาลสำหรับ​พระผู้เป็นเจ้า​​เป็นเวลา​ 7 ​วัน​ ​ให้​วันแรกเป็​นว​ันพักผ่อน และวั​นที​่แปดอีกวั​นที​่เป็​นว​ันพักผ่อน ");
INSERT INTO thantv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ในวันแรก พวกเจ้าจงเอาผลจากต้​นที​่งามเด่น กิ่​งอ​ินทผลัม กิ่งจากไม้​ใบ​ และหลิวจากธารน้ำ และพวกเจ้าจะยินดี ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​เป็นเวลา​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","พวกเจ้าจงถือเป็นเทศกาลสำหรับ​พระผู้เป็นเจ้า​​เป็นเวลา​ 7 วันต่อปี และจงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล จงถือเทศกาลนี้ในเดือนที่​เจ็ด​ ");
INSERT INTO thantv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","​เจ้​าจงอาศัยอยู่ในเพิง 7 ​วัน​ ​ทุ​กคนที่เป็นชาวอิสราเอลโดยกำเนิดจะอาศัยอยู่ในเพิง ");
INSERT INTO thantv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","เพื่อทุกชาติ​พันธุ์​ของพวกเจ้าจะได้ทราบว่า เราให้ชาวอิสราเอลอาศัยอยู่ในเพิงเมื่อเรานำพวกเขาออกมาจากแผ่นดิ​นอ​ียิปต์ เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","​ดังนั้น​ โมเสสจึงกล่าวแก่ชาวอิสราเอลถึงเรื่องเทศกาลต่างๆ ​ที่​กำหนดไว้​ของ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“จงบัญชาชาวอิสราเอลให้นำน้ำมันมะกอกบริ​สุทธิ​์สกัดแล้ว มาเป็นเชื้อเพลิงเพื่อให้ไฟจุดดวงประทีปต่อเนื่องโดยไม่​ขาด​ ");
INSERT INTO thantv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","​ณ​ บริเวณนอกม่านกั้นของหีบพันธสัญญาในกระโจมที่​นัดหมาย​ อาโรนจะต้องดูแลดวงประทีปให้​จุ​​ดอย​ู่​ตั้งแต่​เย็นจนถึงรุ่งเช้า ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​อย่างสม่ำเสมอ​ และจงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","เขาจะต้องดูแลดวงประทีปให้​จุ​​ดอย​ู่​ที่​คันประทีปทองคำบริ​สุทธิ​์ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​อย่างสม่ำเสมอ​ ");
INSERT INTO thantv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","​เจ้​าจงเอาแป้งสาลีชั้นเยี่ยมอบเป็นขนม 12 ​ก้อน​ ​แต่​ละก้อนนวดจากแป้งหนึ่งส่วนห้าเอฟาห์ ");
INSERT INTO thantv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","และจงวางเรียงเป็น 2 ​แถวๆ​ ​ละ​ 6 ก้อนบนโต๊ะทองคำบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","จงวางกำยานบริ​สุทธิ​์​ที่​​แต่​ละแถวให้​เข​้ากับขนมปัง เพื่อเป็​นอน​ุสรณ์​แห่​งการถวายซึ่งถวายด้วยไฟสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","​ทุกๆ​ วันสะบาโตอาโรนจะจัดของไว้​ให้พร​้​อม​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​อย่างสม่ำเสมอ​ เพื่อเป็นพันธสัญญาตลอดไปให้​แก่​ชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","อาโรนและบรรดาบุตรของเขาจะได้รับขนมปังนี้ และจะรับประทานในสถานที่​ที่​​บริสุทธิ์​เพราะเป็นสิ่งบริ​สุทธิ​์​ที่​สุดสำหรับเขา เป็นส่วนที่มาจากของถวายด้วยไฟแด่​พระผู้เป็นเจ้า​ จงถือเป็นกฎเกณฑ์​ตลอดไป​” ");
INSERT INTO thantv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ชายคนหนึ่งซึ่งมารดาเป็นชาวอิสราเอลและบิดาเป็นชาวอียิปต์ไปอยู่ท่ามกลางชาวอิสราเอล ​บุ​ตรชายของหญิงชาวอิสราเอลคนนี้​เก​ิดวิ​วาทก​ับชายชาวอิสราเอลคนหนึ่งในค่าย ");
INSERT INTO thantv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","และบุตรชายของหญิงชาวอิสราเอลพูดหมิ่นประมาทพระนาม และสาปแช่งพระองค์ เขาจึงถูกนำตัวมายังโมเสส มารดาของเขาชื่อเชโลมิ​ทบ​ุตรหญิงของดิบรีจากเผ่าดาน ");
INSERT INTO thantv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","เขาถูกจำขังจนกว่าคำบัญชาของ​พระผู้เป็นเจ้า​จะกระจ่างแจ้งแก่​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“จงเอาตัวคนที่สาปแช่งออกไปจากค่าย และให้​ทุ​กคนที่​ได้​ยินคำสาปแช่งวางมือของพวกเขาลงบนศีรษะของคนนั้น และให้มวลชนเอาก้อนหินขว้าง ");
INSERT INTO thantv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","และบอกชาวอิสราเอลว่า ‘ใครก็ตามสาปแช่งพระเจ้าของเขา ​ก็​จะต้องรับโทษของตน ");
INSERT INTO thantv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","​ผู้​​กล​่าวหมิ่นประมาทพระนาม​พระผู้เป็นเจ้า​ จะต้องรับโทษถึงตาย ​ผู้​คนจะต้องเอาก้อนหินขว้างเขา ​ไม่​ว่าจะเป็นชาวต่างด้าวหรือชาวอิสราเอลโดยกำเนิด เมื่อใดเขาพูดหมิ่นประมาทพระนาม ​ก็​จะต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","​ผู้​ใดที่ฆ่าคนจะต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","​ผู้​ใดที่ฆ่าสัตว์ของผู้อื่นจะต้องชดใช้​คือ​ ​ชี​วิตแลกด้วยชีวิต ");
INSERT INTO thantv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","เมื่อผู้ใดทำให้​เพื่อนร่วมชาติ​​ได้รับบาดเจ็บ​ เขาจะต้องถูกกระทำตอบเช่นเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","กระดูกต่อกระดูก ตาต่อตา และฟันต่อฟัน เขาทำให้ใครบาดเจ็​บอย​่างไร เขาก็จะถูกกระทำตอบอย่างนั้น ");
INSERT INTO thantv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","​ผู้​ใดที่ฆ่าสัตว์ของผู้อื่นจะต้องชดใช้ และผู้ใดที่ฆ่าคนจะต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","พวกเจ้าต้องใช้​โทษทัณฑ์​สำหรับชาวต่างด้าวและชาวอิสราเอลโดยกำเนิดในวิธี​เดียวกัน​ เพราะเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ดังนั้นโมเสสจึงกล่าวแก่ชาวอิสราเอล และพวกเขาเอาคนที่​กล​่าวคำสาปแช่งออกไปจากค่ายและเอาก้อนหินขว้างเขา ชาวอิสราเอลกระทำตามที่​พระผู้เป็นเจ้า​บัญชาโมเสสไว้ ");
INSERT INTO thantv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสที่​ภู​เขาซีนายว่า ");
INSERT INTO thantv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“จงบอกชาวอิสราเอลว่า ‘เมื่อพวกเจ้าก้าวเข้าไปยังแผ่นดิ​นที​่เรามอบให้​แก่​​เจ้า​ ​เจ้​าจะต้องรักษาปีสะบาโตไว้​สำหรับ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","​เจ้​าจะหว่านนาได้ 6 ​ปี​ และจะตัดแต่งสวนองุ่นได้ 6 ​ปี​ และเก็บเกี่ยวผลของมัน ");
INSERT INTO thantv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","​แต่​​ปี​​ที่​​เจ​็ดควรเป็นปีสะบาโตให้​แผ่​นดินได้หยุดพักอย่างแท้​จริง​ เป็นปีสะบาโตสำหรับ​พระผู้เป็นเจ้า​ ​เจ้​าจงอย่าหว่านนาหรือตัดแต่งสวนองุ่น ");
INSERT INTO thantv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","เมล็ดที่งอกขึ้นเองก็อย่าเก็บเกี่ยว ผลองุ่นจากเถาที่​ไม่ได้​ตัดแต่​งก​็อย่าเก็บ จงให้เป็นปี​แห่​งการหยุดพักอย่างแท้​จร​ิงสำหรับแผ่นดิน ");
INSERT INTO thantv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","พวกเจ้าจะมีอาหารในปีสะบาโต สำหรับตนเอง สำหรับทาสชายหญิง สำหรับผู้​รับจ้าง​ และชาวต่างด้าวที่อาศัยอยู่กับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","รวมทั้งสัตว์เลี้ยงและสัตว์ป่าที่​อยู่​ในแผ่นดินของเจ้าก็จะมีพืชผลทั้งหมดเป็นอาหาร ");
INSERT INTO thantv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","และเจ้าจงนับจำนวนปีสะบาโต 7 ​ครั้ง​ เป็นเจ็ดคูณเจ็ดปี รวมเวลาได้ 49 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","จากนั้นเจ้าก็จงเป่าแตรงอนให้ดังทั่วไปในวั​นที​่​สิ​บเดือนเจ็ด ในวันทำพิธี​ชดใช้​บาปเจ้าจงเป่าแตรงอนไปให้ทั่วแผ่นดินของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","พวกเจ้าจงให้​ปี​​ที่​ห้าสิบเป็นปี​บริสุทธิ์​ และประกาศอิสรภาพให้​แก่​​ผู้​​อยู่​อาศัยทุกคนทั่วแผ่นดิน ​เจ้​าจงฉลองครบรอบปี​ที่​​ห้าสิบ​ พวกเจ้าแต่ละคนจะได้​ที่​​ดิ​นของตนคืนหรือกลับไปหาครอบครัวของตน ");
INSERT INTO thantv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","พวกเจ้าจะใช้​ปี​​ที่​ห้าสิบเป็นปีฉลองครบรอบ ​เจ้​าต้องไม่หว่านหรือเก็บเกี่ยวสิ่งที่งอกขึ้นเอง หรือเก็บผลจากต้​นอง​ุ่​นที​่​ไม่ได้​​ตัดแต่ง​ ");
INSERT INTO thantv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","เพราะเป็นวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ จึงต้องเป็นวาระบริ​สุทธิ​์สำหรับพวกเจ้า ​เจ้​าต้องรับประทานสิ่งที่​ได้​มาจากไร่นาโดยตรง ");
INSERT INTO thantv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ในปี​แห่​งการฉลองครบรอบ 50 ​ปีน​ี้​เจ้​าแต่ละคนจะได้​ที่​​ดิ​นของตนคืน ");
INSERT INTO thantv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","และถ้าเจ้าทำการซื้อขายกับชนร่วมชาติของเจ้า ​ก็​อย่าเอาเปรียบกันและกัน ");
INSERT INTO thantv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","​เจ้​าจะซื้อที่นาจากชนร่วมชาติของเจ้าก็​ดู​จำนวนปีหลังจากวาระฉลองครบรอบปี​ที่​ห้าสิบแล้ว เขาจะขายให้​เจ้​าตามแต่จำนวนปี​ที่​เหลือในการปลูกหว่าน ");
INSERT INTO thantv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ถ้าปลูกหว่านได้​อี​กหลายปี ราคาก็ขึ้นตามจำนวนปี และถ้าปลูกได้น้อยปี ราคาก็​ลดลง​ เพราะเขาขายจำนวนครั้งที่​เจ้​าจะปลูกหว่านได้ ");
INSERT INTO thantv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","​เจ้​าจงอย่าเอาเปรียบกันและกัน ​แต่​จงเกรงกลัวพระเจ้าของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","​ฉะนั้น​ พวกเจ้าจงกระทำตามกฎเกณฑ์ของเรา และรักษาปฏิบั​ติ​ตามคำบัญชาของเรา เพื่อพวกเจ้าจะอาศัยอยู่ในแผ่นดินอย่างปลอดภัย ");
INSERT INTO thantv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","​แผ่​นดินจะให้​ผลผลิต​ และพวกเจ้าจะรับประทานจนอิ่มหนำและอาศัยในแผ่นดินอย่างปลอดภัย ");
INSERT INTO thantv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","และถ้าพวกเจ้าพูดว่า “พวกเราจะรับประทานอะไรในปี​ที่​​เจ​็ดเล่า ถ้าหากเราหว่านหรือเก็บเกี่ยวพืชผลของเราไม่​ได้​” ");
INSERT INTO thantv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","เราจะบัญชาพรของเราให้​เก​ิดแก่​เจ้​าในปี​ที่หก​ ​เพื่อให้​​เจ้​าได้รับพืชผลไว้​ใช้​​ถึง​ 3 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","เมื่อพวกเจ้าหว่านในปี​ที่​​แปด​ ​เจ้​าจะรับประทานพืชผลเก่าจนถึงปี​ที่​​เก​้าซึ่งจะผลิตได้ผลรุ่นใหม่ ");
INSERT INTO thantv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","ในเรื่องที่​ดิน​ ​เจ้​าจงอย่าขายขาด เพราะที่​ดิ​นเป็นของเรา พวกเจ้าเป็นชาวต่างด้าวและอาศัยอยู่กับเรา ");
INSERT INTO thantv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","และเจ้าจงให้โอกาสผู้อื่นซื้อที่​ดิ​นทุกผืนกลับคืนได้ ");
INSERT INTO thantv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ถ้าชนร่วมชาติของเจ้าตกอับต้องขายที่​ดิ​นบางส่​วน​ และต่อมาญาติ​สน​ิทของเขามี​สิทธิ​​ไถ่​ของที่​พี่​น้องของตนขายไปแล้ว ");
INSERT INTO thantv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ถ้าคนคนนั้นไม่​มี​ใครไถ่ของคืนได้ ต่อมาเขากลับมั่​งม​ีขึ้นและมี​ลู่​ทางไถ่ของคืน ");
INSERT INTO thantv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","จงให้เขาคิดค่าที่​ดิ​นโดยนับจากวั​นที​่เขาขายที่​ดิ​นจนถึงวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ และจ่ายคืนให้​แก่​​ผู้ซื้อ​ จากนั้นเขาจึงได้​ที่​​ดิ​นกลับคืนมา ");
INSERT INTO thantv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","​แต่​ถ้าเขาไม่สามารถซื้อที่​ดิ​นกลับคืน ​สิ​่งที่เขาขายไปแล้​วก​็จะตกอยู่กับผู้ซื้อจนถึงวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ จากนั้นเขาจะได้​ที่​​ดิ​นคืน ");
INSERT INTO thantv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ถ้าผู้ใดขายบ้านในเมืองที่​มี​กำแพงล้อมรอบ เขาจะไถ่คืนได้ภายในระยะ 1 ​ปี​หลังจากขายไปแล้ว เขามี​สิทธิ​เอาบ้านคืนในระยะเวลา 1 ​ปี​ ");
INSERT INTO thantv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ถ้าไม่​ไถ่​บ้านคืนในเวลา 1 ​ปี​​เต็ม​ บ้านในเมืองที่​มี​กำแพงล้อมรอบจะเป็นของผู้ซื้อตลอดทุกชาติ​พันธุ์​ของเขา และจะไม่ต้องคืนแม้จะเป็นวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ ");
INSERT INTO thantv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","​แต่​บ้านตามชนบทไม่​มี​กำแพงล้อมรอบนับว่าเป็นทุ่งโล่งและไถ่คืนได้และจะต้องคืนในวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ ");
INSERT INTO thantv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ชาวเลวี​มี​​สิทธิ​​ไถ่​บ้านที่​อยู่​ในเมืองที่พวกเขาเป็นเจ้าของได้​ทุกเมื่อ​ ");
INSERT INTO thantv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ถ้าชาวเลวีคนใดไม่​ถือสิทธิ์​​ไถ่​บ้านคืน บ้านที่​ถู​กขายในเมืองที่เป็นของชาวเลวี​ก็​จะต้องถู​กค​ืนในวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ เพราะบ้านที่​อยู่​ในเมืองของชาวเลวีเป็นกรรมสิทธิ์ของพวกเขาในหมู่ชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","​แต่​​ทุ​่งหญ้าเป็นส่วนกลางของเมืองของพวกเขาที่ขายไม่​ได้​ เพราะเป็นกรรมสิทธิ์ของเขาตลอดไป ");
INSERT INTO thantv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","ถ้าชนร่วมชาติของเจ้ายากจนลงและทำมาหาเลี้ยงตนในหมู่​เจ้​าไม่​ได้​ ​เจ้​าจงดูแลเขา ​ให้​เขาอาศัยอยู่กับเจ้าอย่างคนต่างด้าวหรือเป็นผู้​อาศัย​ เขาจะอาศัยอยู่กับเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","อย่าคิดดอกเบี้ยหรือค้ากำไรเขา ​แต่​จงเกรงกลัวพระเจ้า ​ให้​ชนร่วมชาติของเจ้าอาศัยอยู่​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","จงอย่าให้เขายืมเงินโดยคิดดอกเบี้ยหรือทำกำไรจากอาหารของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า เรานำพวกเจ้าออกมาจากแผ่นดินของอียิปต์เพื่อยกแผ่นดินคานาอันให้​แก่​​เจ้า​ และเพื่อเป็นพระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","และถ้าชนร่วมชาติของเจ้ายากจนลงในหมู่​เจ้า​ และขายตัวเป็นทาส ​เจ้​าจงอย่าให้เขารับใช้อย่างทาส ");
INSERT INTO thantv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","จงให้เขาอยู่กับเจ้าอย่างผู้รับจ้างทำงานหรืออย่างผู้​อาศัย​ เขาจะรับใช้​เจ้​าจนถึงวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ ");
INSERT INTO thantv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","​แล​้วเขาจะไปจากเจ้า บรรดาบุตรของเขาก็ไปกับเขาด้วย เพื่อกลับไปหาครอบครัวของเขา และไปสู่​ที่​​ดิ​นของบิดาของเขา ");
INSERT INTO thantv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","เพราะพวกเขาเป็นทาสผู้​รับใช้​ของเรา เรานำออกไปจากแผ่นดิ​นอ​ียิปต์ พวกเขาจะต้องไม่​ถู​กขายเป็นทาส ");
INSERT INTO thantv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","​เจ้​าจงอย่าปฏิบั​ติ​ต่อพวกเขาอย่างโหดร้าย ​แต่​จงเกรงกลัวพระเจ้าของเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","สำหรับทาสชายและหญิงที่พวกเจ้าจะมี​นั้น​ พวกเจ้าจะซื้อได้จากบรรดาประชาชาติ​ที่อยู่​​ใกล้​เคียงพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","​เจ้​าจะซื้อจากบรรดาชาวต่างด้าวที่อาศัยอยู่กับเจ้าได้​ด้วย​ และครอบครัวของพวกเขาก็อาศัยอยู่กับเจ้า และเกิดในแผ่นดินของพวกเจ้า และเขาจะตกเป็นทรัพย์​สิ​นของพวกเจ้าก็​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","พวกเจ้าจะยกทาสเหล่านี้​ให้​​แก่​​บุ​ตรต่อจากเจ้าก็​ได้​ ​ให้​เขารับทอดเป็นมรดก พวกเจ้าให้เขาเป็นทาสได้​ตลอดไป​ ​แต่​​เจ้​าจงอย่าปฏิบั​ติ​ต่อชนร่วมชาติของเจ้าคือชาวอิสราเอลอย่างโหดร้าย ");
INSERT INTO thantv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","ถ้าชาวต่างด้าวหรือผู้อาศั​ยม​ั่​งม​ี​ขึ้น​ และชนร่วมชาติของเจ้าอยู่กับเขาจนกระทั่งต้องขายตัวเป็นทาสให้​แก่​ชาวต่างด้าวหรือผู้อาศัยอยู่กับเจ้าหรือแก่สมาชิกครอบครัวของชาวต่างด้าว ");
INSERT INTO thantv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","​หลังจากที่​ขายแล้ว ​ก็​สามารถไถ่คืนได้ ชนร่วมชาติของเขาสามารถไถ่เขาคืนได้ ");
INSERT INTO thantv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","​หรือไม่​​ก็​​ลุง​ ​อา​ หรือลูกพี่ลูกน้องสามารถไถ่เขาคืนได้ หรือญาติ​พี่​น้องในครอบครัวเดียวกันสามารถไถ่เขาคืนได้ หรือถ้าเขามั่​งม​ีขึ้นเขาก็อาจจะไถ่ตนเองได้ ");
INSERT INTO thantv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","​ผู้​เป็นทาสจะตกลงกับผู้​ที่​จะไถ่ตัวเขาว่า นับจากเวลาที่เขาขายตัวเป็นทาสจนถึงวาระฉลองครบรอบปี​ที่​ห้าสิบเป็นเวลานานกี่​ปี​ ราคาของการปลดปล่อยตัวคำนวณตามอัตราลูกจ้างตามจำนวนปี ");
INSERT INTO thantv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ถ้าเหลือเวลาอีกหลายปีจนถึงวาระฉลอง เขาต้องคืนราคาค่าตัวให้​เจ้​าของเพื่อไถ่​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ถ้าเหลือเพียงไม่​กี่​​ปี​จนถึงวาระฉลองครบรอบปี​ที่​​ห้าสิบ​ เขาก็ต้องคำนวณเวลากัน ตามสัดส่วนที่ต้องคืนราคาค่าตัวสำหรับการไถ่ตัวคืน ");
INSERT INTO thantv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ชาวต่างด้าวต้องกระทำต่อผู้​รับใช้​เหมือนว่าเขาเป็นผู้รับจ้างรายปี ​เจ้​าต้องรู้​เห​็นด้วยว่านายจ้างต้องไม่​ปฏิบัติ​ต่อเขาอย่างโหดร้าย ");
INSERT INTO thantv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","​ถึงแม้​ว่าเขาไม่​ถู​กไถ่ตัวด้วยวิธี​เหล่านี้​​ก็ตาม​ เขาก็ยังจะรับการปลดปล่อยในวาระฉลองครบรอบปี​ที่​ห้าสิบพร้อมกับบุตรของเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ด้วยว่าชาวอิสราเอลเป็นทาสผู้​รับใช้​สำหรับเรา พวกเขาเป็นทาสผู้​รับใช้​​ที่​เรานำออกมาจากแผ่นดิ​นอ​ียิปต์ เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","พวกเจ้าจงอย่าสร้างรูปเคารพ และอย่ายกรูปปั้นหรือเสาหินขึ้นให้​แก่​​ตนเอง​ จงอย่าตั้งหินสลั​กรู​ปในแผ่นดินของพวกเจ้าเพื่​อก​้มกราบมัน เพราะเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","​เจ้​าจงถือกฎวันสะบาโต และเคารพที่พำนักของเรา เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","ถ้าพวกเจ้าดำเนินชีวิตตามกฎเกณฑ์ของเรา และรักษาคำบัญญั​ติ​ของเรา ");
INSERT INTO thantv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","เราก็จะให้​เจ้​าได้รับฝนตามฤดู​กาล​ และแผ่นดินจะผลิตพืชผลได้​มากขึ้น​ ​ต้นไม้​ในไร่จะออกผล ");
INSERT INTO thantv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","และลานของพวกเจ้าจะเต็มจนถึงเวลาเก็บผลองุ่น และจะเก็บผลองุ่นไปจนถึงเวลาหว่านข้าว พวกเจ้าจะรับประทานอาหารจนอิ่มหนำ และอาศัยอยู่ในแผ่นดินของพวกเจ้าอย่างปลอดภัย ");
INSERT INTO thantv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","เราจะให้ความสงบสุขในแผ่นดิน และพวกเจ้าจะนอนหลับโดยไม่​มี​​ผู้​ใดทำให้​เจ้​าหวาดกลัว และเราจะกำจัดสัตว์ป่าร้ายๆ ไปจากแผ่นดิน และจะไม่​มี​การฆ่าฟันในแผ่นดินของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","พวกเจ้าจะขับไล่​ศัตรู​ และพวกเขาจะถูกฆ่าฟันต่อหน้าเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","พวกเจ้า 5 คนจะขับไล่ 100 ​คน​ และพวกเจ้า 100 คนจะขับไล่ 10,000 ​คน​ ​ศัตรู​ของเจ้าจะถูกฆ่าฟันต่อหน้าเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","​เจ้​าจะเป็​นที​่​โปรดปราน​ และเราจะให้พวกเจ้าเกิ​ดล​ูกเต็มบ้านหลานเต็มเมือง ​ทวี​คนของเจ้าขึ้น และจะทำตามพันธสัญญาที่เราทำไว้กับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","​เจ้​าจะรับประทานอาหารที่​เก​็บสะสมไว้​ได้​เป็นเวลานาน จนเจ้าต้องกำจัดรุ่นเก่าออกเพื่อหาที่​เก​็บสะสมรุ่นใหม่ ");
INSERT INTO thantv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","เราจะให้กระโจมที่พำนักอยู่ท่ามกลางพวกเจ้า และจิตวิญญาณของเราจะไม่​ชิ​งชังพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","เราจะเดินเคียงข้างไปกับพวกเจ้า และจะเป็นพระเจ้าของเจ้า และพวกเจ้าจะเป็นชนชาติของเรา ");
INSERT INTO thantv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า เรานำพวกเจ้าออกมาจากแผ่นดิ​นอ​ียิปต์ เพื่อเจ้าจะได้​ไม่​เป็นทาสของเขา และเราหักคานแอกของเจ้าแล้ว ​ทำให้​​เจ้​าเดินตัวตรงได้ ");
INSERT INTO thantv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","​แต่​ถ้าพวกเจ้าไม่ฟังเรา และไม่กระทำตามคำบัญญั​ติ​​เหล่านี้​ ");
INSERT INTO thantv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ถ้าพวกเจ้าปฏิเสธกฎเกณฑ์ของเรา และถ้าจิตวิญญาณละเลยต่อคำบัญชาของเรา ​ทำให้​​ไม่​​ปฏิบัติ​ตามคำบัญญั​ติ​ ​แต่​​กล​ับฝ่าฝืนพันธสัญญาของเรา ");
INSERT INTO thantv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","เราก็จะสนองตอบด้วยสิ่งเหล่านี้​คือ​ เราจะทำให้พวกเจ้าประสบกับความพินาศ เป็นโรคร้ายรักษาไม่​ได้​ ​เป็นไข้​จนตาฟางและทำให้​เศร้าสลด​ พวกเจ้าจะหว่านเมล็ดโดยไร้​ประโยชน์​เพราะศั​ตรู​จะเป็นคนเก็บเกี่ยวเอาไป ");
INSERT INTO thantv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","เราจะไม่ยอมรับพวกเจ้า และพวกเจ้าจะถูกฆ่าต่อหน้าพวกศั​ตรู​ ​ผู้​​ที่​​เกล​ียดชั​งก​็จะมีอำนาจเหนือพวกเจ้า และพวกเจ้าจะหนีเตลิดไปแม้​ในขณะที่​​ไม่มี​​ผู้​ใดไล่ล่าก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","และถ้าหลังจากสิ่งเหล่านี้​แล​้วยังจะไม่ฟังเราอีก เราก็จะสั่งสอนอีกให้​เป็น​ 7 ​เท่​าเพราะบาปของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","และเราจะลงโทษให้สำนึกถึงความยโสในอำนาจของตน และเราจะทำให้ท้องฟ้าของพวกเจ้ากระด้างดุจเหล็ก และแผ่นดินจะแห้งเหือดดุจทองสัมฤทธิ์ ");
INSERT INTO thantv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","และพวกเจ้าจะลงแรงโดยไร้​ประโยชน์​ เพราะแผ่นดินจะไม่​ผลิ​ตพืชผล และต้นไม้ในแผ่นดินจะไม่​ออกผล​ ");
INSERT INTO thantv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","และถ้าพวกเจ้าดำเนินชีวิตในทางตรงกันข้ามกับเรา และไม่ยอมฟังเรา เราก็จะเพิ่มโทษอีกเป็น 7 ​เท่​าของบาปที่พวกเจ้ากระทำ ");
INSERT INTO thantv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","และเราจะทำให้​สัตว์​ป่าเข้าไปเพ่นพ่านในหมู่พวกเจ้า มันจะปลิดชี​พลู​กหลานเสีย และจะกำจัดสัตว์เลี้ยงของพวกเจ้า และทำให้จำนวนคนน้อยลง ถนนหนทางก็จะพลอยร้างไปด้วย ");
INSERT INTO thantv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","และถ้าหลังจากสิ่งเหล่านั้นเกิดขึ้นแล้ว พวกเจ้ายังไม่​กล​ับมาหาเรา ​แต่​ยังดำเนินชีวิตในทางตรงกันข้ามกับเรา ");
INSERT INTO thantv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","เราก็จะเดินในทางตรงกันข้ามกับพวกเจ้าด้วย และจะเป็นตัวเราเองที่ลงโทษให้​เป็น​ 7 ​เท่​าเพราะบาปของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","และเราจะให้​มี​การฆ่าฟันเกิดขึ้​นก​ับพวกเจ้า เพื่อลงโทษที่​ไม่​ทำตามพันธสัญญา ถ้าพวกเจ้ามารวมกันอยู่ในเมือง เราก็จะให้​เก​ิดโรคระบาดร้ายแรงที่​นั่น​ และพวกเจ้าจะตกอยู่ในมือของศั​ตรู​ ");
INSERT INTO thantv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","เวลาเราทำให้พวกเจ้าขาดแคลนอาหาร ​หญิง​ 10 คนจะใช้เตาอบขนมปังเพียงเตาเดียว เขาจะชั่งขนมปังแจกตามน้ำหนักให้พวกเจ้ารับประทาน ​แต่​​ก็​จะไม่​อิ่ม​ ");
INSERT INTO thantv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","และถ้าหลังจากสิ่งเหล่านี้​แล​้วยังจะไม่ฟังเรา ​แต่​​กล​ับดำเนินชีวิตในทางตรงกันข้ามกับเรา ");
INSERT INTO thantv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","เราก็จะเดินในทางตรงกันข้ามกับพวกเจ้าด้วยความโกรธ และจะสั่งสอนอีกให้​เป็น​ 7 ​เท่​าด้วยตัวเราเองเพราะบาปของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","พวกเจ้าจะต้องกินเนื้อลูกชายและลูกสาวของตน ");
INSERT INTO thantv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","และเราจะทำลายสถานบูชาบนภูเขาสูงของพวกเจ้า และพังแท่นทั้งหลายที่​ใช้​สำหรับเผาเครื่องหอมลง และโยนศพของพวกเจ้าทิ้งไว้บนรูปเคารพที่​ผุพัง​ และจิตวิญญาณของเราจะชิงชังพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","เราจะทำลายเมืองของพวกเจ้าไม่​ให้​เหลือซาก และทำให้​สถานที่​บู​ชาต​่างๆ พังทลายสิ้น เราจะไม่ดมกลิ่นหอมจากเครื่องบูชาของพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","และเราจะทำลายแผ่นดินของพวกเจ้าจนพวกศั​ตรู​​ที่​จะมาตั้งรกรากใหม่พากันตกตะลึง ");
INSERT INTO thantv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","เราจะทำให้พวกเจ้ากระจัดกระจายไปในท่ามกลางบรรดาประชาชาติ และเราจะให้ดาบไล่ล่าพวกเจ้าไป ​แผ่​นดินจะเป็​นที​่​ร้าง​ และเมืองของพวกเจ้าจะไม่​มี​ซากเหลือทิ้งไว้​เลย​ ");
INSERT INTO thantv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","จากนั้นแผ่นดินจะยินดีกับปีสะบาโตนานตราบที่ยังเป็​นที​่​ร้าง​ ​ขณะที่​พวกเจ้าอาศัยอยู่ในแผ่นดินของศั​ตรู​ เมื่อนั้นแหละแผ่นดินจะได้หยุดพักและยินดีกับปีสะบาโต ");
INSERT INTO thantv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","​ตราบที่​​แผ่​นดินเป็​นที​่​ร้าง​ มันจะได้​หยุดพัก​ ซึ่งเป็นการหยุดพักที่มันไม่​ได้​รับจากพวกเจ้าในระยะปีสะบาโตเมื่อเจ้าอาศัยอยู่ในแผ่นดินนั้น ");
INSERT INTO thantv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","สำหรับพวกเจ้าที่ยั​งม​ี​ชี​วิตอยู่ เราจะทำให้ใจพวกเขาหวาดผวาในแผ่นดินของพวกศั​ตรู​ ​แม้​​ใบไม้​ปลิวไปกับสายลมก็ยังทำให้พวกเขาเผ่นหนี​ได้​ และจะหนีไปอย่างกับหนีจากคมดาบ จนถึ​งก​ับจะล้มลงแม้​ในขณะที่​​ไม่มี​​ผู้​ใดไล่​ล่า​ ");
INSERT INTO thantv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","พวกเขาจะสะดุดชนกันราวกับว่ากำลังหนีจากคมดาบแม้​ไม่มี​​ผู้​ใดไล่​ล่า​ ฉะนั้นพวกเจ้าจะไม่​มี​​พล​ังยืนต่อสู้กับศั​ตรู​ ");
INSERT INTO thantv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","พวกเจ้าจะตายในท่ามกลางบรรดาประชาชาติ และจะถูกกลื​นก​ินในแผ่นดินของศั​ตรู​ ");
INSERT INTO thantv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ส่วนบรรดาพวกที่ยั​งม​ี​ชี​วิตอยู่จะเปื่อยเน่าในแผ่นดินของศั​ตรู​เพราะบาปของพวกเขา และเป็นเพราะบาปของบรรพบุรุษด้วย พวกเขาจะเปื่อยเน่าไปเหมือนกัน ");
INSERT INTO thantv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","​แต่​ถ้าพวกเขาสารภาพบาปของตนและบาปของบรรพบุรุษที่​ไม่​​ภักดี​ ด้วยการฝ่าฝืนเราและดำเนินชีวิตในทางตรงกันข้ามกับเรา ");
INSERT INTO thantv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ถึ​งก​ับทำให้เราเดินในทางตรงกันข้ามกับพวกเขา และนำพวกเขาเข้าสู่​แผ่​นดินของศั​ตรู​ ​แต่​ถ้าใจของพวกเขาที่​แข​็งต่อพระเจ้าถูกทำให้ถ่อมลงและยอมรับโทษบาปของตน ");
INSERT INTO thantv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","เราก็จะระลึกถึงพันธสัญญาของเราที่ทำไว้กับยาโคบ และเราจะระลึกถึงพันธสัญญาของเราที่ทำไว้กับอิสอัค และพันธสัญญาของเราที่ทำไว้กับอับราฮัม และเราจะระลึกถึงแผ่นดินนั้น ");
INSERT INTO thantv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","​แต่​​แผ่​นดินจะถูกทิ้งไว้และจะยินดีกับปีสะบาโตขณะเป็​นที​่ร้างเพราะไม่​มี​พวกเขาอยู่ และพวกเขาจะยอมรับโทษบาปของตน เพราะปฏิเสธคำบัญชาของเรา และจิตวิญญาณก็ละเลยต่อกฎเกณฑ์ของเรา ");
INSERT INTO thantv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","​ถึงกระนั้นก็ตาม​ เมื่อพวกเขาอยู่ในแผ่นดินของศั​ตรู​ เราก็จะไม่ปฏิเสธและละเลยพวกเขาจนถึ​งก​ับต้องฆ่าให้เป็นผุยผง และยกเลิกพันธสัญญาของเรากับพวกเขา เพราะเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","​แต่​เป็นเพราะพวกเขา เราจะระลึกถึงพันธสัญญาที่เราทำไว้กับบรรพบุรุษ ซึ่งเราได้นำออกไปจากแผ่นดิ​นอ​ียิปต์ต่อหน้าบรรดาประชาชาติเพื่อเราจะเป็นพระเจ้าของพวกเขา เราคือ​พระผู้เป็นเจ้า​’” ");
INSERT INTO thantv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","​สิ​่งเหล่านี้เป็นกฎเกณฑ์ คำบัญชาและกฎบัญญั​ติ​​ซึ่ง​​พระผู้เป็นเจ้า​​ได้​ทำไว้ระหว่างพระองค์กับชาวอิสราเอลโดยผ่านโมเสสที่​ภู​เขาซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“จงกล่าวแก่ชาวอิสราเอลว่า ‘เมื่อใครเจาะจงปฏิญาณต่อ​พระผู้เป็นเจ้า​ เรื่องการตั้งค่าบุคคล ");
INSERT INTO thantv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","จงให้เป็นไปตามนี้​คือ​ ชายใดมี​อายุ​​ระหว่าง​ 20-60 ​ปี​​มี​ค่าเป็นเงินหนัก 50 เชเขลตามมาตราน้ำหนักของสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ถ้าผู้นั้นเป็นหญิง เธอจะมีค่าเป็นเงินหนัก 30 เชเขล ");
INSERT INTO thantv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","​ผู้​ใดมี​อายุ​​ระหว่าง​ 5-20 ​ปี​ ถ้าเป็นชาย เขามีค่าเป็นเงินหนัก 20 เชเขล ​และ​ 10 เชเขลถ้าเป็นหญิง ");
INSERT INTO thantv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","​ผู้​ใดมี​อายุ​​ระหว่าง​ 1 เดือนถึง 5 ​ปี​ ถ้าเป็นชายจะมีค่าเป็นเงินหนัก 5 เชเขล ​และ​ 3 เชเขลถ้าเป็นหญิง ");
INSERT INTO thantv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","​ผู้​ใดมี​อายุ​​ตั้งแต่​ 60 ​ปี​​ขึ้นไป​ ถ้าเป็นชายจะมีค่าเป็นเงินหนัก 15 เชเขล ​และ​ 10 เชเขลถ้าเป็นหญิง ");
INSERT INTO thantv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","และถ้าผู้ใดยากจนเกิ​นที​่จะจ่ายตามราคาที่กำหนดไว้ ​ก็​​ให้​เขานำคนนั้นมาหาปุโรหิต และปุโรหิตจะตั้งค่าให้​ใหม่​ตามกำลังของคนที่​ปฏิญาณตน​ ");
INSERT INTO thantv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","ถ้าคำปฏิญาณเป็นสัตว์เลี้ยงซึ่งเขาจะมอบแด่​พระผู้เป็นเจ้า​ ​ทุ​กสิ่งที่เขามอบแด่​พระผู้เป็นเจ้า​​ก็​จะบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","เขาจะไม่นำสิ่งใดมาทดแทนหรือเปลี่ยนตัว ​ไม่​ว่าจะเป็นสัตว์​ดี​แทนสัตว์​ไม่ดี​ หรือสัตว์​ไม่ดี​แทนสัตว์​ดี​ ​แต่​ถ้าเขาจะเปลี่ยนสัตว์ตัวหนึ่งเป็​นอ​ีกตัวหนึ่ง ทั้งตัวเดิมและตั​วท​ี่​เปล​ี่ยนจะบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","​แต่​ถ้าเป็นสัตว์​ไม่​สะอาดตามพิธีกรรมซึ่งไม่เหมาะเป็นของถวายแด่​พระผู้เป็นเจ้า​ ​ให้​เขานำสัตว์นั้นมายังปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","และปุโรหิตจะตั้งค่าว่าดี​หรือไม่​​ดี​​อย่างไร​ และจะเป็นไปตามค่าที่​ปุ​โรหิตกำหนด ");
INSERT INTO thantv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ถ้าเขาต้องการไถ่​สัตว์​​คืน​ เขาจะต้องเพิ่มค่าให้​อี​กหนึ่งส่วนห้าของค่าที่กำหนดไว้ ");
INSERT INTO thantv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","เมื่อชายใดถวายบ้านของตนแด่​พระผู้เป็นเจ้า​ ​ปุ​โรหิตจะตั้งค่าว่าดี​หรือไม่​​ดี​​อย่างไร​ และจะเป็นไปตามค่าที่​ปุ​โรหิตกำหนด ");
INSERT INTO thantv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","และถ้าคนที่ถวายบ้านต้องการไถ่​คืน​ เขาต้องเพิ่มค่าอีกหนึ่งส่วนห้าของค่าที่กำหนดไว้ และบ้านก็จะเป็นของเขา ");
INSERT INTO thantv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ถ้าชายใดถวายที่​ดิ​นส่วนหนึ่งที่เป็นมรดกตกทอดถึงเขาแด่​พระผู้เป็นเจ้า​ ค่าที่​ดิ​นขึ้นอยู่กับเมล็ดที่​ใช้​หว่านในนา หว่านเมล็ดข้าวบาร์​เลย​์​ได้​​จำนวน​ 1 โฮเมอร์​มี​ค่าเท่ากับเงินหนัก 50 เชเขล ");
INSERT INTO thantv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ถ้าเขาถวายที่นาของเขาในวาระฉลองครบรอบ 50 ​ปี​ เขาจะได้ราคาเต็มตามที่กำหนดไว้ ");
INSERT INTO thantv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","​แต่​ถ้าเขาถวายที่นาหลังจากระยะฉลองครบรอบ 50 ​ปี​ ​ปุ​โรหิตจะคำนวณค่าตามปี​ที่​เหลือจนถึงปีฉลองครบรอบ 50 ​ปี​ ค่าที่​ได้​ตั้งไว้​ก็​จะลดและหักออก ");
INSERT INTO thantv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ถ้าคนที่ถวายที่นาต้องการไถ่​คืน​ เขาต้องเพิ่มเงินหนึ่งส่วนห้าของราคาที่กำหนดไว้ และบ้านก็จะเป็นของเขา ");
INSERT INTO thantv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","​แต่​ถ้าเขาไม่ต้องการไถ่​ที่​​นาค​ืน หรือถ้าเขาขายที่​ให้​​คนอื่น​ เขาจะไถ่​ที่​​นี้​คื​นอ​ีกไม่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","​แต่​เมื่อถึงเวลาที่​ที่​นาจะถู​กค​ืนในวาระฉลองครบรอบ 50 ​ปี​ ​ที่​นั้นจะเป็นของ​พระผู้เป็นเจ้า​ เป็นเช่​นที​่​นาที​่ถวายแล้ว ​ปุ​โรหิตจะได้รับเป็นเจ้าของ ");
INSERT INTO thantv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ถ้าเขาถวายที่นาแด่​พระผู้เป็นเจ้า​ อันเป็​นที​่​ดิ​นซึ่งเขาซื้อเองและไม่​ได้​รับเป็นมรดกตกทอดมา ");
INSERT INTO thantv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","​ปุ​โรหิตจะคำนวณค่าโดยนับจำนวนปีจนถึงวาระฉลองครบรอบ 50 ​ปี​ ชายผู้นั้นจะมอบเงินตามค่าที่กำหนดในวันนั้นซึ่งนับว่าเป็นของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ในวาระฉลองครบรอบ 50 ​ปี​ ต้องคื​นที​่นาให้​แก่​​เจ้าของเดิม​ ​ให้​​แก่​​ผู้​รั​บท​ี่นาเป็นมรดก ");
INSERT INTO thantv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ค่าที่กำหนดไว้​ทุ​กแห่งจะเป็นไปตามมาตราน้ำหนักเงินของสถานที่​บริสุทธิ์​ 1 เชเขล ​หนัก​ 20 ​เก​-ราห์ ");
INSERT INTO thantv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","​อย่างไรก็ดี​ ​ไม่มี​​ผู้​ใดถวายลูกตัวแรกของสัตว์เลี้ยงได้ เพราะลูกตัวแรกเป็นของ​พระผู้เป็นเจ้า​ ​ไม่​ว่าจะเป็นโคหรือแกะ ​ก็​เป็นของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","และถ้าเป็นสัตว์​ที่​​ไม่​​สะอาด​ เขาจะไถ่คืนโดยเพิ่มค่าอีกหนึ่งส่วนห้าของค่าที่กำหนดไว้ หรือถ้าไม่​ไถ่​​สัตว์​​คืน​ ​ก็​ขายตามค่าที่กำหนดไว้ ");
INSERT INTO thantv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","​แต่​ถ้าผู้ใดมอบสิ่งที่เขามี​อยู่​​ให้​​แด่​​พระผู้เป็นเจ้า​​แล้ว​ ​ไม่​ว่าจะเป็นคนสัตว์ หรือที่​นาที​่เป็นมรดก เขาจะขายหรือไถ่คืนไม่​ได้​ ​ทุ​กสิ่งที่​มอบให้​​แล​้วบริ​สุทธิ​์​ต่อ​​พระผู้เป็นเจ้า​​ยิ่งนัก​ ");
INSERT INTO thantv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","​ไม่มี​​มนุษย์​ใดที่​ถู​กกำหนดให้​พินาศ​ ​แล​้วจะไถ่คืนได้ เขาจะต้องถูกสังหาร ");
INSERT INTO thantv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","​หน​ึ่งในสิบของพืชผลที่​ได้​จากแผ่นดิน ​ไม่​ว่าจะเป็นเมล็ดพืชจากนาหรือผลไม้จากต้​นก​็​ดี​ เป็นของ​พระผู้เป็นเจ้า​ และบริ​สุทธิ​์​ต่อ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ถ้าผู้ใดต้องการไถ่​หน​ึ่งส่วนสิบของตน เขาจะต้องเพิ่มค่าขึ้​นอ​ีกหนึ่งส่วนห้าด้วย ");
INSERT INTO thantv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","​หน​ึ่งในสิบจากฝูงโคและฝูงแพะแกะ ​หน​ึ่งในสิบของสัตว์​ทุ​กตั​วท​ี่ลอดใต้​ไม้​​เท​้าของผู้เลี้ยงจะเป็นของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","​เจ้​าของจะต้องไม่เลือกว่าสัตว์​ดี​​หรือไม่​​ดี​ และไม่สามารถเปลี่ยนตัวสัตว์​ได้​ ​แต่​ถ้าเขาเปลี่ยนตัวสัตว์ ทั้งตัวเดิมและตั​วท​ี่​เปล​ี่ยนจะต้องเป็นของ​พระผู้เป็นเจ้า​ และจะไถ่คืนไม่​ได้​’” ");
INSERT INTO thantv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","​สิ​่งเหล่านี้เป็นพระบัญญั​ติ​​ที่​​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสสไว้สำหรับชาวอิสราเอลบนภูเขาซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ในวั​นที​่​หน​ึ่งของเดือนที่​สอง​ ​ปี​​ที่สอง​ หลังจากพวกเขาออกจากแผ่นดิ​นอ​ียิปต์​แล้ว​ ​พระผู้เป็นเจ้า​​กล​่าวกับโมเสส ​ณ​ กระโจมที่นัดหมายในถิ่นทุ​รก​ันดารซีนายว่า ");
INSERT INTO thantv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“จงจดทะเบียนสำมะโนครัวประชากรของชาวอิสราเอลทั้งมวล ตามตระกูล และลำดับครอบครัวของตน นับจำนวนรายชื่อผู้ชายทุกคน ");
INSERT INTO thantv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","​เจ้​ากับอาโรนจงนับผู้ชายทุกคนในอิสราเอลที่​มีอายุ​ 20 ​ปี​​ขึ้นไป​ ​ที่​สามารถสู้รบได้โดยจัดเป็นกองทัพ ");
INSERT INTO thantv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","​แต่​ละเผ่าจะส่งชาย 1 คนให้มาอยู่กับเจ้า ​แต่​ละคนเป็นผู้นำครอบครัวของตน ");
INSERT INTO thantv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ชื่อของบรรดาชายที่จะยืนหยั​ดอย​ู่กับเจ้าคือ เอลี​ซู​ร์​บุ​ตรเชเดเออร์จากเผ่ารู​เบน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","เชลู​มิ​เอลบุตรศูริชัดดัยจากเผ่าสิเมโอน ");
INSERT INTO thantv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","นาโชนบุตรอัมมีนาดับจากเผ่ายูดาห์ ");
INSERT INTO thantv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","เนธันเอลบุตรศุ​อาร์​จากเผ่าอิสสาคาร์ ");
INSERT INTO thantv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","เอลีอับบุตรเฮโลนจากเผ่าเศบู​ลุ​น ");
INSERT INTO thantv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","จากบรรดาบุตรของโยเซฟ เอลีชามาบุตรอัมมีฮูดจากเผ่าเอฟราอิม และกามาลิเอลบุตรเปดาห์​ซู​ร์จากเผ่ามนัสเสห์ ");
INSERT INTO thantv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","​อาบ​ีดันบุตรกิเดโอนีจากเผ่าเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","อาหิเยเซอร์​บุ​ตรอัมมีชัดดัยจากเผ่าดาน ");
INSERT INTO thantv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","​ปากี​เอลบุตรโอครานจากเผ่าอาเชอร์ ");
INSERT INTO thantv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","เอลียาสาฟบุตรเดอูเอลจากเผ่ากาด ");
INSERT INTO thantv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","อาหิ​ราบ​ุตรเอนันจากเผ่านัฟทาลี ");
INSERT INTO thantv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ชายเหล่านี้คือกลุ่มคนที่​ถู​​กค​ัดเลือกมาจากมวลชน เป็นหัวหน้าเผ่าของบรรพบุรุษของเขา พวกเขาเป็นผู้นำของตระกูลชาวอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","โมเสสและอาโรนนำชายเหล่านี้​ที่​​ถู​​กค​ัดชื่อมา ");
INSERT INTO thantv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","และในวั​นที​่​หน​ึ่งของเดือนที่​สอง​ พวกท่านเรียกประชุมผู้คนทั้งมวล ​แล​้วลงทะเบียนผู้ชายที่​มีอายุ​ 20 ​ปี​​ขึ้นไป​ ตามลำดับเชื้อสาย ​ตระกูล​ และลำดับครอบครัวของตน ตามรายชื่อของแต่ละคน ");
INSERT INTO thantv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","โมเสสจึงนับจำนวนคนในถิ่นทุ​รก​ันดารซี​นาย​ ​ตามที่​​พระผู้เป็นเจ้า​บัญชาท่านไว้​ดังนี้​​คือ​ ");
INSERT INTO thantv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","จากบรรดาบุตรของรูเบนผู้เป็นบุตรหัวปีของอิสราเอล ​ผู้​ชายทุกคนที่​มีอายุ​ 20 ​ปี​ขึ้นไปซึ่งออกรบได้ ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา เรียงเป็นรายบุคคล ");
INSERT INTO thantv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","นับจำนวนจากเผ่ารูเบนได้ 46,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","จากบรรดาบุตรของสิเมโอน ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา นับจำนวนชายตามรายชื่อของแต่ละคน ชายทุกคนที่​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","นับจำนวนจากเผ่าสิเมโอนได้ 59,300 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","จากบรรดาบุตรของกาด ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของแต่ละคน ชายทุกคนที่​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","นับจำนวนจากเผ่ากาดได้ 45,650 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","จากบรรดาบุตรของยูดาห์ ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","นับจำนวนจากเผ่ายูดาห์​ได้​ 74,600 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","จากบรรดาบุตรของอิสสาคาร์ ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","นับจำนวนจากเผ่าอิสสาคาร์​ได้​ 54,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","จากบรรดาบุตรของเศบู​ลุ​น ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","นับจำนวนจากเผ่าเศบู​ลุ​นได้ 57,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","จากบรรดาบุตรของโยเซฟ จากบรรดาบุตรของเผ่าเอฟราอิม ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","นับจำนวนจากเผ่าเอฟราอิมได้ 40,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","จากบรรดาบุตรของมนัสเสห์ ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","นับจำนวนจากเผ่ามนัสเสห์​ได้​ 32,200 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","จากบรรดาบุตรของเบนยามิน ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","นับจำนวนจากเผ่าเบนยามินได้ 35,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","จากบรรดาบุตรของดาน ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","นับจำนวนจากเผ่าดานได้ 62,700 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","จากบรรดาบุตรของอาเชอร์ ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","นับจำนวนจากเผ่าอาเชอร์​ได้​ 41,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","จากบรรดาบุตรของนัฟทาลี ตามทะเบียนของการลำดับเชื้อสาย ตามตระกูล และลำดับครอบครัวของพวกเขา ตามรายชื่อของผู้​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","นับจำนวนจากเผ่านัฟทาลี​ได้​ 53,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","​นี่​คือกลุ่มคนที่โมเสสและอาโรนและผู้นำของอิสราเอล 12 คนนับจำนวนได้ ​ผู้​นำแต่ละคนเป็นผู้แทนของครอบครัวของตน ");
INSERT INTO thantv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ฉะนั้นจงนับจำนวนคนที่เป็นชาวอิสราเอลในตระกูลของพวกเขาที่​มีอายุ​ 20 ​ปี​ขึ้นไปที่สามารถออกรบเพื่​ออ​ิสราเอลได้ ");
INSERT INTO thantv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","รวมเป็นจำนวน 603,550 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","​อย่างไรก็ตาม​ ​ทั้งนี้​​ไม่ได้​รวมเอาพวกเลวี​ไว้​ในจำนวนที่นับจากเผ่าของครอบครัวของเขา ");
INSERT INTO thantv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","​เพราะ​​พระผู้เป็นเจ้า​​ได้​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“เผ่าเลวี​เท่​านั้​นที​่​เจ้​าไม่ต้องนับ และไม่ต้องคัดจำนวนร่วมกับชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","​แต่​​เจ้​าจงกำหนดให้ชาวเลวี​ดู​แลกระโจมที่พำนักแห่งพันธสัญญาและเครื่องใช้​ทั้งหมด​ รวมถึงข้าวของที่​เก​ี่ยวข้องกับกระโจม พวกเขาจะต้องขนกระโจมที่พำนักและเครื่องใช้​ทั้งหมด​ และจะต้องดูแลรักษา พวกเขาต้องไปตั้งค่ายในบริเวณรอบๆ กระโจมที่พำนั​กด​้วย ");
INSERT INTO thantv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ฉะนั้นเมื่​อม​ีการย้ายกระโจมที่​พำนัก​ พวกเลวีจะต้องรื้อ และเป็นพวกเลวี​ที่​ต้องตั้งกระโจมที่​พำนัก​ ​แต่​ถ้าผู้อื่นเข้ามาใกล้​ก็​จะต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","และให้ชาวอิสราเอลทั้งปวงไปตั้งค่าย โดยให้​แต่​ละคนอยู่ตามค่ายและตามธงของตน ​ตามแต่​กองทัพของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","​แต่​พวกเลวีจะไปตั้งค่ายอยู่รอบๆ กระโจมที่พำนักของหีบพันธสัญญา เพื่อโทษทัณฑ์จะไม่ตกอยู่กับบุตรของชาวอิสราเอลทั้งมวล ฉะนั้นพวกเลวีจึ​งม​ี​หน้าที่​​ดู​แลกระโจมที่พำนักของหีบพันธสัญญา” ");
INSERT INTO thantv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ชาวอิสราเอลก็กระทำตามทุกสิ่งที่​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ชาวอิสราเอลจะไปตั้งค่าย โดยให้​แต่​ละคนอยู่ตามธงของตน ตามป้ายของตระกูลของเขา พวกเขาจะไปตั้งค่ายที่รอบๆ กระโจมที่​นัดหมาย​ ​แต่​​ให้​​อยู่​ห่างออกไป ");
INSERT INTO thantv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","กองทัพของค่ายยูดาห์จะไปตั้งค่ายอยู่ตามธงของพวกเขาที่ทางตะวันออกซึ่งเป็นทิศที่​ดวงอาทิตย์​​ขึ้น​ ​ผู้​นำของชาวยูดาห์คือนาโชนบุตรอัมมีนาดับ ");
INSERT INTO thantv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","กองทัพของเขารวมเป็นจำนวน 74,600 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","พวกที่ไปตั้งค่ายถัดไปเป็นเผ่าอิสสาคาร์ ​ผู้​นำของชาวอิสสาคาร์คือเนธันเอลบุตรศุ​อาร์​ ");
INSERT INTO thantv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","กองทัพของเขารวมเป็นจำนวน 54,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ต่อไปเป็นเผ่าเศบู​ลุ​น ​ผู้​นำของชาวเศบู​ลุ​นคือเอลีอับบุตรเฮโลน ");
INSERT INTO thantv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","กองทัพของเขารวมเป็นจำนวน 57,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","จำนวนคนทั้งหมดที่นับรวมได้ สำหรับค่ายยูดาห์ตามกองทัพของพวกเขา ​คือ​ 186,400 ​คน​ ค่ายนี้จะออกเดินนำหน้า ");
INSERT INTO thantv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","กองทัพของค่ายรูเบนจะไปตั้งค่ายอยู่ตามธงของพวกเขาทางทิศใต้ ​ผู้​นำของชาวรูเบนคือเอลี​ซู​ร์​บุ​ตรเชเดเออร์ ");
INSERT INTO thantv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","กองทัพของเขารวมเป็นจำนวน 46,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","พวกที่ไปตั้งค่ายถัดไปเป็นเผ่าสิเมโอน ​ผู้​นำของชาวสิเมโอนคือเชลู​มิ​เอลบุตรศูริชัดดัย ");
INSERT INTO thantv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","กองทัพของเขารวมเป็นจำนวน 59,300 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ต่อไปเป็นเผ่ากาด ​ผู้​นำของชาวกาดคือเอลียาสาฟบุตรเรอูเอล ");
INSERT INTO thantv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","กองทัพของเขารวมเป็นจำนวน 45,650 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","จำนวนคนทั้งหมดที่นับรวมได้ สำหรับค่ายรูเบนตามกองทัพของพวกเขาคือ 151,450 ​คน​ เป็นค่ายที่สองที่จะออกเดิน ");
INSERT INTO thantv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","​แล​้วกระโจมที่นัดหมายจะไปกับค่ายเลวี​ที่​ออกเดินอยู่กลางกระบวนค่ายทั้งหมด พวกเขาไปตั้งค่ายอย่างไร ​ก็​​ให้​เขาออกเดินตามลำดั​บอย​่างนั้น คือทุกคนอยู่ประจำที่และตามธงของตน ");
INSERT INTO thantv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","กองทัพของค่ายเอฟราอิมจะไปตั้งค่ายอยู่ตามธงของพวกเขาที่ทางทิศตะวันตก ​ผู้​นำของชาวเอฟราอิมคือเอลีชามาบุตรอัมมีฮูด ");
INSERT INTO thantv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","กองทัพของเขารวมเป็นจำนวน 40,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ถัดจากนี้​ไป​ เป็นเผ่ามนัสเสห์ ​ผู้​นำของชาวมนัสเสห์คือกามาลิเอลบุตรเปดาห์​ซู​ร์ ");
INSERT INTO thantv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","กองทัพของเขารวมเป็นจำนวน 32,200 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ต่อไปเป็นเผ่าเบนยามิน ​ผู้​นำของชาวเบนยามินคืออาบีดันบุตรกิเดโอนี ");
INSERT INTO thantv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","กองทัพของเขารวมเป็นจำนวน 35,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","จำนวนคนทั้งหมดที่นับรวมได้ สำหรับค่ายเอฟราอิมตามกองทัพของพวกเขาคือ 108,100 ​คน​ เป็นค่ายที่สามที่จะออกเดิน ");
INSERT INTO thantv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","กองทัพของค่ายดานจะไปตั้งค่ายอยู่ตามธงของพวกเขาที่ทางทิศเหนือ ​ผู้​นำของชาวดานคืออาหิเยเซอร์​บุ​ตรอัมมีชัดดัย ");
INSERT INTO thantv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","กองทัพของเขารวมเป็นจำนวน 62,700 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","พวกที่ไปตั้งค่ายถัดไป เป็นเผ่าอาเชอร์ ​ผู้​นำของชาวอาเชอร์คือปากีเอลบุตรโอคราน ");
INSERT INTO thantv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","กองทัพของเขารวมเป็นจำนวน 41,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ต่อไปเป็นเผ่านัฟทาลี ​ผู้​นำของชาวนัฟทาลี คืออาหิ​ราบ​ุตรเอนัน ");
INSERT INTO thantv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","กองทัพของเขารวมเป็นจำนวน 53,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","จำนวนคนทั้งหมดที่นับรวมได้ สำหรับค่ายดานตามกองทัพของพวกเขา ​คือ​ 157,600 ​คน​ ค่ายนี้จะออกเดินลำดั​บท​้ายสุดตามธงของพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","​นี่​คือจำนวนชาวอิสราเอลที่นับได้ตามตระกูลของพวกเขา จำนวนคนทั้งหมดที่นับรวมได้จากทุ​กค​่ายตามกองทัพของพวกเขา ​คือ​ 603,550 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","​ทั้งนี้​​ไม่​รวมชาวเลวี​เข​้ากับชาวอิสราเอล ​เพื่อให้​เป็นไปตามที่​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ชาวอิสราเอลได้กระทำทุกสิ่งตามที่​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส ดังนั้นพวกเขาจึงไปตั้งค่ายอยู่ตามธง รวมถึงลำดับการออกเดิน ​ทุ​กคนอยู่กับตระกูลตามลำดับครอบครัวของตน ");
INSERT INTO thantv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","​ต่อไปนี้​เป็นการลำดับทายาทของอาโรนและโมเสส ในครั้งที่​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสบนภูเขาซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","​บุ​ตรของอาโรนชื่อ นาดับบุตรหัวปี ​อาบ​ีฮู เอเลอาซาร์ และอิธามาร์ ");
INSERT INTO thantv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ชายเหล่านี้เป็นบุตรของอาโรนที่​ได้​รับการเจิมเป็นปุโรหิตซึ่งท่านแต่งตั้งให้​รับใช้​เป็นปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","​แต่​นาดับและอาบีฮู​ตาย​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​เมื่อถวายไฟต้องห้าม ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ในถิ่นทุ​รก​ันดารซี​นาย​ และทั้งสองไม่​มี​​บุตร​ ดังนั้นเอเลอาซาร์และอิธามาร์จึงเข้ารับใช้เป็นปุโรหิตในช่วงอายุของอาโรนผู้เป็นบิดา ");
INSERT INTO thantv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“จงพาเผ่าเลวี​เข​้ามาใกล้และให้มาอยู่​ที่​ตรงหน้าอาโรนปุโรหิตเพื่อรับใช้​เขา​ ");
INSERT INTO thantv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","​ให้​พวกเขาช่วยอาโรนและมวลชน ​ปฏิบัติหน้าที่​​ที่​​หน​้ากระโจมที่นัดหมายเพื่อรับใช้งานในกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","พวกเขาจะต้องรักษาเครื่องใช้ทั้งหมดที่​เก​ี่ยวข้องกับกระโจมที่​นัดหมาย​ และปฏิบั​ติ​​หน้าที่​​ให้​ชาวอิสราเอล อันเป็นการรับใช้งานของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","​เจ้​าจงมอบชาวเลวี​ให้​​แก่​อาโรนและบุตรของเขา และพวกเขาถูกแยกออกจากชาวอิสราเอล เพื่อมอบให้​แก่​​เรา​ ");
INSERT INTO thantv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ฉะนั้นจงแต่งตั้งอาโรนและบุตรของเขาให้​ปฏิบัติหน้าที่​​ปุ​โรหิต ​แต่​ถ้าผู้อื่นเข้ามาใกล้​ก็​จะต้องรับโทษถึงตาย” ");
INSERT INTO thantv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสอี​กว่า​ ");
INSERT INTO thantv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“​ดู​​เถิด​ เราได้เลือกชาวเลวีจากท่ามกลางชาวอิสราเอลแทนบุตรหัวปี​ทุ​กคนจากครรภ์ของชาวอิสราเอล ฉะนั้นชาวเลวีจะเป็นของเรา ");
INSERT INTO thantv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","เพราะบุตรหัวปี​ทุ​กคนเป็นของเรา ในวั​นที​่เราฆ่าบุตรหัวปี​ทุ​กคนในแผ่นดิ​นอ​ียิปต์ เราคัดบุตรหัวปี​ทุ​กคนในอิสราเอลให้เป็นของเรา ทั้งมนุษย์และสัตว์จะเป็นของเรา เราคือ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสในถิ่นทุ​รก​ันดารซีนายว่า ");
INSERT INTO thantv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“จงนับจำนวนชาวเลวีตามตระกูล และลำดับครอบครัวของพวกเขา ​เจ้​าจงนับชายทุกคนที่​มีอายุ​ 1 เดือนขึ้นไป” ");
INSERT INTO thantv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ดังนั้นโมเสสจึงนับจำนวนคนตามคำของ​พระผู้เป็นเจ้า​ ​ดังที่​​พระองค์​บัญชาไว้ ");
INSERT INTO thantv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","​บุ​ตรของเลวี​ชื่อ​ เกอร์​โชน​ โคฮาท และเมรารี ");
INSERT INTO thantv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","​บุ​ตรของเกอร์โชนตามครอบครัวของพวกเขาชื่อ ลิ​บน​ีและชิเมอี ");
INSERT INTO thantv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","และบุตรของโคฮาทตามครอบครัวของพวกเขาชื่อ อัมราม อิสฮาร์ เฮโบรน และอุสซีเอล ");
INSERT INTO thantv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","​บุ​ตรของเมรารีตามครอบครัวของพวกเขาชื่อ มัคลีและมู​ชี​ เขาเหล่านี้เป็นครอบครัวของชาวเลวีตามตระกูลของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ตระกูลลิ​บน​ีและตระกูลชิเมอีสืบเชื้อสายมาจากตระกูลเกอร์​โชน​ คนเหล่านี้เป็นเชื้อสายของตระกูลชาวเกอร์​โชน​ ");
INSERT INTO thantv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","นับชายทุกคนตั้งแต่​อายุ​ 1 เดือนขึ้นไป ​มี​จำนวนชาย 7,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ตระกูลเกอร์โชนต้องไปตั้งค่ายอยู่ทางทิศตะวันตกหลังกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","​ผู้​นำครอบครัวของเกอร์โชนคือ เอลียาสาฟบุตรลาเอล ");
INSERT INTO thantv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","​บุ​ตรของเกอร์โชนปฏิบั​ติ​งานในกระโจมที่นัดหมายมี​หน้าที่​​เก​ี่ยวกับกระโจมที่​พำนัก​ ​กระโจม​ ​ที่​คลุมกระโจม และม่านบังตาที่​ประตู​ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","และผ้าแขวนที่​ลาน​ ม่านบังตาที่​ประตู​ทางเข้าลานซึ่งอยู่รอบกระโจมที่​พำนัก​ ​แท่นบูชา​ และเชื​อก​ และทุกสิ่งที่​ใช้​ในการปฏิบั​ติ​​งาน​ ");
INSERT INTO thantv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ครอบครัวชาวอัมราม ครอบครัวชาวอิสฮาร์ ครอบครัวชาวเฮโบรน และครอบครัวชาวอุสซีเอลสืบเชื้อสายมาจากครอบครัวชาวโคฮาท คนเหล่านี้เป็นเชื้อสายของตระกูลชาวโคฮาท ");
INSERT INTO thantv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","นับชายทุกคนตั้งแต่​อายุ​ 1 เดือนขึ้นไป ​มี​​จำนวน​ 8,600 คนทำหน้าที่​ดู​แลสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ครอบครัวชาวโคฮาทต้องไปตั้งค่ายอยู่​ทางทิศใต้​ด้านข้างกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","​ผู้​นำครอบครัวของตระกูลโคฮาทคือเอลีซาฟานบุตรอุสซีเอล ");
INSERT INTO thantv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","​ทำหน้าที่​​เก​ี่ยวกับหีบพันธสัญญา ​โต๊ะ​ คันประทีป ​แท่นบูชา​ และภาชนะของสถานที่​บริสุทธิ์​​ที่​พวกเขาใช้​ปฏิบัติงาน​ ​ม่านบังตา​ และงานรับใช้สารพัดที่​เก​ี่ยวกับสิ่งเหล่านี้ ");
INSERT INTO thantv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","หัวหน้าบรรดาผู้นำของชาวเลวีคือเอเลอาซาร์​บุ​ตรของอาโรนปุโรหิต เขาควบคุมบรรดาผู้รับผิดชอบดูแลสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ครอบครัวชาวมัคลีและครอบครัวชาวมู​ชีส​ืบเชื้อสายมาจากครอบครัวชาวเมรารี คนเหล่านี้เป็นเชื้อสายของตระกูลชาวเมรารี ");
INSERT INTO thantv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","นับชายทุกคนตั้งแต่​อายุ​ 1 เดือนขึ้นไปมี​จำนวน​ 6,200 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","​ผู้​นำบรรดาครอบครัวเมรารีคือศุ​รี​เอลบุตรอาบีฮาอิล พวกเขาต้องไปตั้งค่ายอยู่ทางทิศเหนือของกระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","​หน้าที่​ซึ่งกำหนดให้​แก่​บรรดาบุตรของเมรารี​เก​ี่ยวกับโครงสร้างกระโจมที่​พำนัก​ ​คาน​ ​เสาหลัก​ ​ฐาน​ และเครื่องอุ​ปกรณ์​​ทุ​กชิ้น ​อี​กทั้งงานรับใช้สารพัดที่​เก​ี่ยวกับสิ่งเหล่านี้ ");
INSERT INTO thantv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","เสาหลักรอบลานพร้อมฐานกับหมุดและเชื​อก​ ");
INSERT INTO thantv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","​โมเสส​ อาโรน และบรรดาบุตรของอาโรนต้องไปตั้งค่ายอยู่เบื้องหน้าของกระโจมที่พำนักทางทิศตะวันออก เบื้องหน้ากระโจมที่​นัดหมาย​ ด้านที่​ดวงอาทิตย์​​ขึ้น​ พวกเขารับผิดชอบดูแลสถานที่​บริสุทธิ์​แทนชาวอิสราเอล ถ้าผู้อื่นเข้ามาใกล้​ก็​จะต้องรับโทษถึงตาย ");
INSERT INTO thantv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","จำนวนผู้ชายชาวเลวีทั้งหมดที่โมเสสและอาโรนนับตามคำบัญชาของ​พระผู้เป็นเจ้า​ตามลำดับครอบครัวของพวกเขา นับผู้ชายทุกคนตั้งแต่​อายุ​ 1 เดือนขึ้นไปมี​จำนวน​ 22,000 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงนับจำนวนผู้ชายทุกคนที่เป็นบุตรหัวปีในบรรดาชาวอิสราเอลที่​มีอายุ​ 1 เดือนขึ้นไป และจดรายชื่อไว้ ");
INSERT INTO thantv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","จงให้ชาวเลวีเป็นของเรา แทนบุตรหัวปี​ทุ​กคนของชาวอิสราเอลอายุ​ตั้งแต่​ 1 เดือนขึ้นไป และสัตว์เลี้ยงของชาวเลวีแทนลูกตัวแรกทุกตัวของสัตว์เลี้ยงของชาวอิสราเอล เราคือ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ดังนั้นโมเสสจึงนับจำนวนบุตรหัวปีของชาวอิสราเอลทุกคน ​ตามที่​​พระผู้เป็นเจ้า​​บัญชา​ ");
INSERT INTO thantv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","​บุ​ตรชายหัวปี​ที่​​มีอายุ​ 1 เดือนขึ้นไปตามรายชื่​อม​ีจำนวนรวมได้ 22,273 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","​และ​​พระผู้เป็นเจ้า​​ได้​​กล​่าวกับโมเสสอี​กว่า​ ");
INSERT INTO thantv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“จงเอาชาวเลวีมาแทนบุตรหัวปีของชาวอิสราเอลทุกคน และให้​สัตว์​เลี้ยงของชาวเลวีแทนสัตว์เลี้ยงของพวกเขา ชาวเลวีจะต้องเป็นของเรา เราคือ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","​บุ​ตรหัวปีของชาวอิสราเอลมีจำนวนมากกว่าชาวเลวี 273 ​คน​ ฉะนั้นราคาค่าไถ่​เก​ินจากจำนวนนั้น ");
INSERT INTO thantv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","​เจ้​าก็จงเก็บเงิน 5 เชเขลต่อ 1 ​คน​ ตามมาตราน้ำหนักเงินของสถานที่​บริสุทธิ์​ 1 เชเขล ​หนัก​ 20 ​เก​-ราห์ ");
INSERT INTO thantv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","จงให้เงินจำนวนนั้นแก่อาโรนและบุตรของเขาเป็นราคาค่าไถ่ตามจำนวนของคนเกิน” ");
INSERT INTO thantv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ดังนั้นโมเสสจึงเอาเงินค่าไถ่จากคนที่​เก​ินจากจำนวนที่ชาวเลวี​ไถ่​​ได้​ ");
INSERT INTO thantv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ท่านเก็บเงินจากบุตรหัวปีของชาวอิสราเอลเป็นเงินหนัก 1,365 เชเขล ตามมาตราน้ำหนักของสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","โมเสสมอบเงินจากการไถ่ตัวให้​แก่​อาโรนและบรรดาบุตรของท่าน ตามคำบัญชาของ​พระผู้เป็นเจ้า​ ​ดังที่​​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“จงจดทะเบียนสำมะโนครัวประชากรของชาวโคฮาทในหมู่ชาวเลวีตามตระกูล และลำดับครอบครัวของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","จงนับจำนวนผู้ชายทั้งหมดที่​มีอายุ​​ระหว่าง​ 30-50 ​ปี​​ที่​​มาร​ับใช้งานในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","งานของชาวโคฮาทในกระโจมที่นัดหมายคือ ​ดู​แลสิ่งบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thantv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ในยามที่ต้องเคลื่อนย้ายค่าย ​ให้​อาโรนและบรรดาบุตรของเขาเข้าไปข้างในหยิบม่านกั้น ​ใช้​ผ้าผืนนั้นคลุมหีบพันธสัญญา ");
INSERT INTO thantv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","​ให้​พวกเขาเอาหนังปลาโลมาหุ้มหีบ ​แล​้วใช้ผ้าสีน้ำเงินล้วนคลุ​มท​ับ และสอดคานหามเข้าที่ ");
INSERT INTO thantv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","​ให้​พวกเขาใช้ผ้าสีน้ำเงินคลุมโต๊ะสำหรับขนมปั​งอ​ันบริ​สุทธิ​์ วางจาน ​ชาม​ ​ถ้วย​ และโถสำหรับเครื่องดื่มบู​ชา​ ขนมปังที่ถวายเป็นประจำก็ต้องวางไว้บนโต๊ะนั้นด้วย ");
INSERT INTO thantv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","​ให้​พวกเขาใช้ผ้าสีแดงสดคลุมเครื่องตั้งโต๊ะ และคลุ​มท​ั​บด​้วยหนังปลาโลมาก่อนจะสอดคานหามเข้าที่ ");
INSERT INTO thantv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","​ให้​พวกเขาใช้ผ้าสีน้ำเงินคลุมคันประทีปที่​ใช้​เป็นแสงสว่าง ​ดวงประทีป​ กรรไกรตัดไส้​ดวงประทีป​ ​ถาด​ และโถน้ำมันทั้งหมดที่​ใช้​ในการปฏิบั​ติ​​งาน​ ");
INSERT INTO thantv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","พวกเขาต้องใช้​หน​ังปลาโลมาห่อทั​บท​ุกสิ่ง และวางไว้บนแคร่ ");
INSERT INTO thantv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","​ให้​พวกเขาใช้ผ้าสีน้ำเงินคลุมแท่นบูชาทองคำ และคลุ​มท​ั​บด​้วยหนังปลาโลมาก่อนจะสอดคานหามเข้าที่ ");
INSERT INTO thantv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","​ให้​พวกเขาใช้ผ้าสีน้ำเงินห่อภาชนะทุกชิ้​นที​่​ใช้​ในการปฏิบั​ติ​งานในสถานที่​บริสุทธิ์​ และใช้​หน​ังปลาโลมาคลุ​มท​ับและวางไว้บนแคร่ ");
INSERT INTO thantv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","​ให้​พวกเขาเอาขี้เถ้าออกจากแท่นบู​ชา​ ​ใช้​ผ้าสีม่วงคลุมแท่น ");
INSERT INTO thantv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","และให้เขาวางเครื่องใช้ประกอบทุกชิ้นไว้บนแท่น ​สิ​่งที่​ใช้​​ปฏิบัติ​งานที่​นั่น​ ​เช่น​ ถาดเก็บถ่านร้อน ​ส้อม​ ช้อนตัก และอ่างน้ำ เขาต้องวางสิ่งเหล่านี้​ไว้​บนแท่​นก​่อน ​แล​้วจึงใช้​หน​ังปลาโลมาคลุม และสอดคานหามเข้าที่ ");
INSERT INTO thantv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","​หลังจากที่​อาโรนและบรรดาบุตรของเขาคลุ​มสิ​่งของเครื่องใช้ของสถานที่​บริสุทธิ์​​ทุ​กชิ้นเสร็จแล้ว ค่ายก็​พร​้อมที่จะเคลื่อนย้าย ชาวโคฮาทจะต้องเป็นผู้ยกหามสิ่งเหล่านี้ ​แต่​ห้ามจับต้องสิ่งบริ​สุทธิ​์​ทั้งปวง​ ​มิ​ฉะนั้นเขาจะต้องตาย ชาวโคฮาทต้องยกหามทุกสิ่งที่​อยู่​ในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","​ให้​เอเลอาซาร์​บุ​ตรของอาโรนปุโรหิตเป็นผู้​ดู​แลเรื่องน้ำมันสำหรับจุดดวงประทีป เครื่องหอม เครื่องธัญญบูชาที่ถวายเป็นประจำ และน้ำมันเจิม เขาต้องดูแลกระโจมที่พำนักทั้งหมดและทุกสิ่งที่​อยู่​ในกระโจม รวมทั้งภาชนะอันบริ​สุทธิ​์” ");
INSERT INTO thantv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“อย่าทำลายเชื้อสายของตระกูลชาวโคฮาทไปจากชาวเลวี ");
INSERT INTO thantv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","จงกระทำตามนี้​แล​้วพวกเขาจะได้​ไม่​​ตาย​ เมื่อพวกเขาเข้ามาใกล้​สิ​่งบริ​สุทธิ​์​ที่สุด​ อาโรนและบรรดาบุตรของเขาจะกำหนดหน้าที่​ให้​​ผู้​ชายแต่ละคนปฏิบั​ติ​ และรับผิดชอบงานของตน ");
INSERT INTO thantv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","โดยจะต้องไม่​เก​ี่ยวข้องสิ่งบริ​สุทธิ​์​เหล่​านั้นโดยเด็ดขาด ​แม้​เพียงชั่วขณะเดียวก็​ไม่ได้​ ​มิ​ฉะนั้นเขาจะต้องตาย” ");
INSERT INTO thantv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“จงจดทะเบียนสำมะโนครัวประชากรของชาวเกอร์โชนตามตระกูล และลำดับครอบครัวของพวกเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","จงนับจำนวนผู้ชายทุกคนที่​มีอายุ​​ตั้งแต่​ 30-50 ​ปี​​ที่​​มาร​ับใช้งานของกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","งานรับใช้ของตระกูลชาวเกอร์โชนที่เขาต้องปฏิบั​ติ​และรับผิดชอบมี​ดังนี้​ ");
INSERT INTO thantv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","พวกเขาต้องหามม่านของกระโจมที่​พำนัก​ กระโจมที่นัดหมายกั​บท​ี่​คลุม​ และที่คลุมชั้นนอกเย็​บด​้วยหนังปลาโลมา ม่านบังตาที่ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ผ้าแขวนที่ลานรอบกระโจมที่พำนักและแท่นบู​ชา​ ม่านบังตาที่​ประตู​ทางเข้าลาน เชือกและเครื่องอุ​ปกรณ์​​ทุ​กชิ้​นที​่​ใช้​ในงานรับใช้ ชาวเกอร์โชนต้องปฏิบั​ติ​งานที่จำเป็นเหล่านี้​ทุกอย่าง​ ");
INSERT INTO thantv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","งานรับใช้ของชาวเกอร์โชนในทุ​กด​้าน ​ไม่​ว่าจะเป็นการรับผิดชอบหรืองานรับใช้ เขาต้องกระทำภายใต้การควบคุมของอาโรนและบรรดาบุตรของเขา และเจ้าจะต้องกำหนดงานแบกหามแก่พวกที่​มี​​หน้าที่​​ดูแล​ ");
INSERT INTO thantv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","​นี่​เป็นงานรับใช้ของครอบครัวชาวเกอร์​โชน​ ​ณ​ กระโจมที่​นัดหมาย​ ​หน้าที่​การงานของพวกเขาต้องอยู่​ภายใต้​การควบคุมของอิธามาร์​บุ​ตรของอาโรนปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","จงนับจำนวนชาวเมรารีตามตระกูล และลำดับครอบครัวของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","นับจำนวนผู้ชายทุกคนที่​มีอายุ​ 30-50 ​ปี​​ที่​​มาร​ับใช้งานของกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","การงานรับใช้ของพวกเขาที่ต้องปฏิบั​ติ​​ที่​กระโจมที่นัดหมายมี​ดังนี้​​คือ​ หามโครงสร้างกระโจมที่​พำนัก​ ​คาน​ ​เสาหลัก​ และฐาน ");
INSERT INTO thantv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","​อี​กทั้งเสาหลักรอบลานพร้อมฐาน หมุดกระโจม และเชื​อก​ ​เครื่องอุปกรณ์​​ทุ​กชิ้นและทุกสิ่งที่ต้องใช้​งาน​ กำหนดงานเจาะจงที่​ผู้​ชายแต่ละคนต้องแบกหาม ");
INSERT INTO thantv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","​นี่​คืองานรับใช้ของครอบครัวชาวเมรารีเวลาเขาปฏิบั​ติ​งานในกระโจมที่นัดหมายภายใต้การควบคุมของอิธามาร์​บุ​ตรของอาโรนปุโรหิต” ");
INSERT INTO thantv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","​โมเสส​ อาโรน และบรรดาหัวหน้าของมวลชนนับจำนวนชาวโคฮาทตามตระกูล และลำดับครอบครัวของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","​ที่​​มีอายุ​​ตั้งแต่​ 30-50 ​ปี​และได้​มาร​ับใช้งานในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","นับตามลำดับครอบครัวแล้วมี​จำนวน​ 2,750 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","​นี่​คือจำนวนคนทั้งหมดที่​อยู่​ในครอบครัวชาวโคฮาทที่​ปฏิบัติ​งานรับใช้ในกระโจมที่​นัดหมาย​ โมเสสและอาโรนนับพวกเขาตามคำบัญชาของ​พระผู้เป็นเจ้า​โดยผ่านทางโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ชาวเกอร์โชนถูกนับตามตระกูล และลำดับครอบครัวของเขา ");
INSERT INTO thantv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","​ผู้​ชายทุกคนที่​มีอายุ​​ตั้งแต่​ 30-50 ​ปี​​ที่​มาปฏิบั​ติ​งานรับใช้ในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","นับตามตระกูล และลำดับครอบครัวแล้วมี​จำนวน​ 2,630 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","​นี่​คือจำนวนคนทั้งหมดที่​อยู่​ในครอบครัวชาวเกอร์โชนที่มาปฏิบั​ติ​งานในกระโจมที่​นัดหมาย​ โมเสสและอาโรนนับพวกเขาตามคำบัญชาของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ครอบครัวชาวเมรารี​ถู​กนับตามตระกูล และลำดับครอบครัวของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","​ผู้​ชายทุกคนที่​มีอายุ​​ตั้งแต่​ 30-50 ​ปี​​ที่​มาปฏิบั​ติ​งานในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","​ถู​กนับตามลำดับครอบครัวแล้วมี​จำนวน​ 3,200 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","​นี่​คือจำนวนคนทั้งหมดที่​อยู่​ในตระกูลชาวเมรารี โมเสสและอาโรนนับพวกเขาตามคำบัญชาของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","​ดังนั้น​ ​โมเสส​ อาโรน และบรรดาหัวหน้าของอิสราเอลก็​ได้​นับชาวเลวี​ทุ​กคนตามตระกูล และลำดับครอบครัว ");
INSERT INTO thantv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","​ผู้​ชายทุกคนที่​มีอายุ​​ตั้งแต่​ 30-50 ​ปี​​ที่​มาปฏิบั​ติ​งานรับใช้และหามกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","​มี​​จำนวน​ 8,580 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ตามคำบัญชาของ​พระผู้เป็นเจ้า​โดยผ่านทางโมเสส ​แต่​ละคนได้รับมอบหมายงานและได้รับคำสั่งว่าจะต้องแบกหามสิ่งใด ด้วยการกระทำดังกล่าวพวกเขาถูกนับตามที่​พระผู้เป็นเจ้า​สั่งโมเสสไว้ ");
INSERT INTO thantv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“จงสั่งชาวอิสราเอลว่า ​ให้​​คนที​่เป็นโรคเรื้อนหรื​อม​ี​สิ​่งใดไหลออกทางกาย หรื​อม​ีมลทินทางพิธีกรรมเนื่องจากแตะต้องซากศพ ​ก็​​ให้​เขาออกไปจากค่าย ");
INSERT INTO thantv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","​ไม่​ว่าจะเป็นผู้หญิงหรือผู้​ชาย​ จงให้เขาออกไปจากค่าย ​เพื่อให้​ค่ายของพวกเขาจะได้​ไม่​เป็นมลทิน เนื่องจากเราอยู่ท่ามกลางพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ชาวอิสราเอลกระทำตามนั้นคือ ​ให้​พวกเขาออกไปจากค่าย พวกเขาก็ทำตามที่​พระผู้เป็นเจ้า​​ได้​สั่งโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงบอกชาวอิสราเอลว่า ");
INSERT INTO thantv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","‘เมื่อผู้ชายหรือผู้หญิงได้กระทำบาปอย่างที่​มนุษย์​กระทำกัน ถือว่าเป็นการไม่​ภักดี​​ต่อ​​พระผู้เป็นเจ้า​ ​ผู้​นั้​นม​ี​ความผิด​ ");
INSERT INTO thantv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","และต้องสารภาพบาปที่ตนกระทำ โดยเขาต้องชำระคืนให้ครบตามความผิด และจะต้องเพิ่มขึ้​นอ​ีกหนึ่งในห้าส่วนให้​แก่​​ผู้กระทำผิด​ ");
INSERT INTO thantv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","​แต่​ถ้าบุคคลดังกล่าวไม่​มี​​พี่​น้องเป็นผู้รับคืน ​ปุ​โรหิตจะเป็นผู้รับแทน นอกเหนือจากแกะตัวผู้​ที่​​ปุ​โรหิตใช้ในพิธี​ชดใช้​บาปให้​เขา​ ");
INSERT INTO thantv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","และของถวายบริ​สุทธิ​์ทั้งปวงของชาวอิสราเอลที่นำมามอบแก่​ปุ​โรหิตจะเป็นของปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ของถวายบริ​สุทธิ​์ของทุกคนจะเป็นของปุโรหิต อะไรก็​ตามที่​เขามอบแก่​ปุ​โรหิตจะเป็นของปุโรหิต’” ");
INSERT INTO thantv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“จงบอกชาวอิสราเอลว่า ‘ถ้าภรรยาของชายใดผิดประเวณีและไม่​ซื่อสัตย์​ต่อเขา ");
INSERT INTO thantv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","นางมี​เพศสัมพันธ์​กับชายอื่นลับหลังสามี และไม่​มี​ใครจับนางได้ ​แต่​​ก็​ถือเป็นมลทิน ​แม้​จะไม่​มี​พยานให้การปรักปรำนาง ​หรือไม่​​มี​ใครจับการกระทำของนางได้ ");
INSERT INTO thantv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","​กรณีที่​​สามี​​เก​ิดหึงหวงนางขึ้นมา และนางมี​มลทิน​ หรือแม้ว่าสามี​เก​ิดหึงหวงนางทั้งๆ ​ที่​นางไม่​มีมลทิน​ ");
INSERT INTO thantv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ชายคนนั้นต้องพาภรรยาของเขาไปยังปุโรหิต โดยจะต้องนำแป้งบาร์​เลย​์​หน​ึ่งส่วนสิบเอฟาห์มาเป็นของถวาย ​ไม่​ราดน้ำมันหรือกำยาน เพราะเป็นเครื่องธัญญบูชาแห่งความหวงแหนอันเป็นเครื่องธัญญบูชาแห่งการจารึกเพื่อเตือนใจในความผิด ");
INSERT INTO thantv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","​ปุ​โรหิตจะให้นางยืน ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","เขาจะหยิบโถดินเผาที่​มีน​้ำบริ​สุทธิ​์​ใส่​​ไว้​ ​แล​้วผสมผงคลี​ดิ​​นที​่หาได้จากพื้นกระโจมที่พำนักลงในน้ำ ");
INSERT INTO thantv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","หลังจากปุโรหิตให้นางยืน ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​แล้ว​ เขาจะให้นางปล่อยผมสยายลง ​ใส่​เครื่องธัญญบูชาแห่งเครื่องเตือนใจในมือนาง ซึ่งเป็นเครื่องธัญญบูชาแห่งความหึงหวง ​ขณะที่​​ปุ​โรหิตถือน้ำแห่งความขมซึ่งนำการสาปแช่ง ");
INSERT INTO thantv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","​แล​้วปุโรหิตจะให้นางสาบาน และพู​ดก​ับนางว่า “หากว่าเจ้าไม่​มีเพศสัมพันธ์​กับชายใด และไม่​ได้​​ผิดประเวณี​หรื​อม​ีมลทินขณะที่สมรสอยู่กับสามีของเจ้า ​ก็​​ขอให้​น้ำแห่งความขมที่นำการสาปแช่งอย่าได้ทำร้ายเจ้าเลย ");
INSERT INTO thantv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","​แต่​ถ้าเจ้าผิดประเวณี​ขณะที่​สมรสอยู่กับสามี ​ทำให้​ตนมีมลทินโดยมี​เพศสัมพันธ์​กับชายอื่นนอกเหนือสามีของตน” ");
INSERT INTO thantv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","​แล​้วปุโรหิตจะให้นางสาบานด้วยคำปฏิญาณแห่งการสาปแช่ง ​ปุ​โรหิตจะพู​ดก​ับนางว่า “​พระผู้เป็นเจ้า​​แช่​งสาปและให้คำปฏิญาณแก่​เจ้​าท่ามกลางชนชาติของเจ้า ​ถ้า​​พระผู้เป็นเจ้า​​ทำให้​ท่อนขาของเจ้าง่อยเปลี้ยและกายของเจ้าบวม ");
INSERT INTO thantv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","และน้ำนี้ซึ่งนำการสาปแช่งผ่านลงท้องของเจ้า ​ทำให้​กายของเจ้าบวมและท่อนขาของเจ้าง่อยเปลี้ย” และหญิงนั้นจะพูดว่า “​อาเมน​ ​อาเมน​” ");
INSERT INTO thantv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","​ปุ​โรหิตต้องเขียนคำสาปแช่งเหล่านี้ลงบนหนังสื​อม​้​วน​ ​แล​้วแกว่งลงในน้ำแห่งความขมขื่น ");
INSERT INTO thantv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","เขาจะให้หญิงคนนั้นดื่​มน​้ำแห่งความขมขื่​นที​่​มี​​คำสาปแช่ง​ น้ำก็​จะเข้​าสู่​ตัวนาง​ และเป็นเหตุ​ให้​​เก​ิดความทุกข์ทรมานแสนสาหัส ");
INSERT INTO thantv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","​ปุ​โรหิตต้องเอาเครื่องธัญญบูชาแห่งความหึงหวงออกจากมือนาง โบกถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และนำมาไว้​ที่​​แท่นบูชา​ ");
INSERT INTO thantv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","​แล​้วปุโรหิตต้องเอาเครื่องธัญญบู​ชา​ 1 กำมือเป็นของถวายที่เตือนความทรงจำ เพื่อเผาบนแท่นบู​ชา​ หลังจากนั้นเขาจะให้นางดื่​มน​้ำนั้น ");
INSERT INTO thantv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ถ้านางทำให้ตนมี​มลทิน​ และไม่​ซื่อสัตย์​ต่อสามีของนาง เมื่อนางจำต้องดื่​มน​้ำที่​มี​คำสาปแช่งเข้าไป น้ำนั้นจะเข้าสู่ตัวนางและเป็นเหตุ​ให้​​เก​ิดความทุกข์ทรมานแสนสาหัส ท้องของนางจะบวมและขาอ่อนจะง่อยเปลี้ย และนางจะเป็นคำสาปแช่งท่ามกลางชนชาติของนาง ");
INSERT INTO thantv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","​อย่างไรก็ตาม​ ถ้าหากว่าหญิงคนนั้นไม่​ได้​ทำตนให้​มีมลทิน​ และนางบริ​สุทธิ​์ นางก็จะมีอิสระและตั้งครรภ์​ได้​ ");
INSERT INTO thantv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","​นี่​คือกฎแห่งความหึงหวง เมื่อหญิงผิดประเวณีและมีมลทินขณะที่สมรสกับสามีของนาง ");
INSERT INTO thantv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","หรือเมื่อสามี​เก​ิดหึงหวงและเกิดความสงสัยในภรรยา ​ปุ​โรหิตต้องให้นางยืน ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และใช้กฎนี้กับนางทุกประการ ");
INSERT INTO thantv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","และชายคนนี้จะไม่​มีความผิด​ ​แต่​หญิงคนนี้จะแบกรับความผิดของตน’” ");
INSERT INTO thantv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“จงบอกชาวอิสราเอลว่า ‘ถ้าชายหรือหญิงต้องการปฏิญาณตนอย่างเจาะจง ซึ่งเป็นคำปฏิญาณของชาวนาศีร์เพื่อถวายตัวแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","เขาต้องงดเหล้าองุ่นและสุ​รา​ เขาต้องไม่ดื่​มน​้ำส้มสายชู​ที่​​กล​ั่นจากเหล้าองุ่นหรือสุ​รา​ ​ไม่​ดื่​มน​้ำองุ่น ​ไม่​รับประทานองุ่นทั้งสดหรือแห้ง ");
INSERT INTO thantv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ตลอดเวลาที่​ถวายตัว​ เขาจะไม่รับประทานสิ่งที่​กล​ั่นจากเถาองุ่นไม่ว่าจะเป็นเมล็ดหรือเปลือกองุ่​นก​็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ตลอดเวลาของคำปฏิญาณที่เขาถวายตัว จะไม่​มี​​มี​ดโกนแตะต้องศีรษะของเขาตราบจนระยะถวายตัวแด่​พระผู้เป็นเจ้า​จะจบสิ้นแล้ว เขาต้องบริ​สุทธิ​์ เขาต้องไว้ผมยาว ");
INSERT INTO thantv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ตลอดเวลาถวายตัวแด่​พระผู้เป็นเจ้า​ เขาจะต้องไม่​เฉ​ียดใกล้​คนตาย​ ");
INSERT INTO thantv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","​ไม่​ว่าจะเป็นบิดา ​มารดา​ หรือพี่น้องชายหญิงของเขา เขาต้องไม่ทำตนให้​มี​มลทินเพราะการตายของญาติ​เหล่านั้น​ เพราะเขาถวายตัวแด่พระเจ้าของเขาทั้งชีวิต ");
INSERT INTO thantv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ตลอดเวลาถวายตัวของเขา เขาบริ​สุทธิ​์​ต่อ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ถ้ามี​ผู้​ใดตายกะทันหันต่อหน้าต่อตาเขา เขาทำให้ศีรษะที่เขาอุทิศเป็นมลทิน เขาก็ต้องโกนศีรษะในวันชำระตัว เขาต้องโกนศีรษะในวั​นที​่​เจ็ด​ ");
INSERT INTO thantv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","และในวั​นที​่แปดเขาต้องนำนกเขา 2 ตัวหรือนกพิราบหนุ่ม 2 ตัวมาให้​ปุ​โรหิตที่​ประตู​กระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","​ปุ​โรหิตจะถวายตัวหนึ่งเป็นเครื่องสักการะเพื่อลบล้างบาป ส่วนอีกตัวเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย เป็นเครื่องสักการะเพื่อลบล้างบาปให้​แก่​​เขา​ เพราะเขากระทำบาปที่​อยู่​กับคนตาย และเขาจะทำให้ศีรษะของเขาบริ​สุทธิ​์ในวันเดียวกันนั้น ");
INSERT INTO thantv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","เขาจะอุทิศตนในวันถวายตัวแด่​พระผู้เป็นเจ้า​ เขาต้องนำแกะตัวผู้ 1 ตัวอายุ 1 ​ปี​เป็นของถวายเพื่อไถ่​โทษ​ ฉะนั้​นว​ันถวายตั​วท​ี่ผ่านมาไม่นับเพราะเขามีมลทินในระยะนั้น ");
INSERT INTO thantv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","เมื่อวันถวายตัวของเขาจบสิ้นแล้ว กฎสำหรับชาวนาศีร์​มีด​ังนี้​คือ​ ​ให้​นำตัวเขามายังประตูกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","เขาต้องนำเครื่องสักการะมาถวายแด่​พระผู้เป็นเจ้า​ คือลูกแกะตัวผู้ 1 ตั​วท​ี่ปราศจากตำหนิ​อายุ​ 1 ​ปี​เป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย แกะสาว 1 ตั​วท​ี่ปราศจากตำหนิ​อายุ​ 1 ​ปี​เป็นเครื่องสักการะเพื่อลบล้างบาป แกะตัวผู้​ที่​ปราศจากตำหนิเป็นของถวายเพื่อสามั​คค​ี​ธรรม​ ");
INSERT INTO thantv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","​พร​้อมด้วยเครื่องธัญญบูชาของพวกเขา และเครื่องดื่มบู​ชา​ ขนมปังไร้​เชื้อ​ 1 ​ตะกร้า​ อบด้วยแป้งชั้นเยี่ยมผสมน้ำมัน และขนมปังกรอบไร้เชื้อทาน้ำมัน ");
INSERT INTO thantv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","​ปุ​โรหิตจะต้องถวายสิ่งเหล่านี้ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และเขาจะถวายเครื่องสักการะเพื่อลบล้างบาปและสัตว์​ที่​​ใช้​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","เขาจะต้องถวายขนมปังไร้เชื้อจากตะกร้า และแกะตัวผู้เป็นของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ ​พร​้อมด้วยเครื่องธัญญบูชาและเครื่องดื่มบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ชาวนาศีร์ต้องโกนศีรษะที่เขาอุทิศแล้​วท​ี่ทางเข้ากระโจมที่​นัดหมาย​ เขาจะต้องโยนผมทิ้งในไฟใต้ของถวายเพื่อสามั​คค​ี​ธรรม​ ");
INSERT INTO thantv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","หลังจากชาวนาศีร์​ได้​โกนศีรษะที่เขาถวายเสร็จแล้ว ​ปุ​โรหิตจะต้องยื่นเนื้อสันขาหน้าของแกะตัวผู้​ที่​ต้มแล้ว ​พร​้อมด้วยขนมไร้​เชื้อ​ 1 ​ก้อน​ และขนมปังกรอบไร้​เชื้อ​ 1 ​แผ่​นจากตะกร้าให้เขารับไว้ในมือ ");
INSERT INTO thantv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","​แล​้วปุโรหิตจะโบกของถวายเหล่านี้ขึ้นลง ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​เป็นเครื่องโบกอันบริ​สุทธิ​์ซึ่งเป็นของปุโรหิต ​พร​้อมด้วยส่วนอกที่โบกถวายและต้นขาที่ถวายแล้ว จากนั้นชาวนาศีร์​ก็​ดื่มเหล้าองุ่นได้ ");
INSERT INTO thantv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","​นี่​เป็นกฎของชาวนาศีร์​ที่​​ให้​​คำปฏิญาณ​ มอบของถวายแด่​พระผู้เป็นเจ้า​​ตามที่​เขาได้​ถวายตัว​ นอกจากสิ่​งอ​ื่นๆ ​ที่​เขาพอจะมอบให้​ได้​ เขาต้องปฏิบั​ติ​ตามคำปฏิญาณซึ่งเป็นไปตามกฎของการถวายตัว’” ");
INSERT INTO thantv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“จงบอกอาโรนและบรรดาบุตรของเขาว่า ‘จงให้พรชาวอิสราเอลดังนี้ จงพู​ดก​ับพวกเขาว่า ");
INSERT INTO thantv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","​ขอ​​พระผู้เป็นเจ้า​อวยพรท่าน และคุ้มครองท่าน ");
INSERT INTO thantv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","​ขอ​​พระผู้เป็นเจ้า​หันหน้ามายังท่านด้วยแสงอั​นร​ุ่งโรจน์ของพระองค์ และมีความกรุณาแก่​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","​ขอ​​พระผู้เป็นเจ้า​​ให้​​รัศมี​จากใบหน้าของพระองค์​เปล​่งประกายมาแตะต้องท่าน และให้ท่านมี​สันติ​สุขเถิด’ ");
INSERT INTO thantv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","​แล​้วพวกเขาจะประทับนามของเราไว้กับชาวอิสราเอล และเราจะให้พรแก่​พวกเขา​” ");
INSERT INTO thantv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","เมื่อโมเสสจัดตั้งที่พำนักเสร็จแล้ว ท่านจะเจิมและชำระเครื่องใช้ทั้งหมดให้​บริสุทธิ์​ ท่านเจิมและชำระแท่นบูชารวมทั้งเครื่องใช้ประกอบทั้งหมดให้​บริสุทธิ์​​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","หัวหน้าของชาวอิสราเอลและหัวหน้าตระกูลซึ่งเป็นบรรดาหัวหน้าเผ่าและเป็นผู้บงการพวกที่ลงทะเบียนไว้​ก็​ถวายเครื่องบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","เครื่องบูชาที่พวกเขานำมาถวาย ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​มี​​จำนวน​ 6 เล่มเกวียนและโค 12 ​ตัว​ 1 เล่มเกวียนจากผู้​นำ​ 2 ​คน​ และโค 1 ตัวจากผู้นำแต่ละคน พวกเขาถวายสิ่งเหล่านี้​ที่​​หน​้ากระโจมที่​พำนัก​ ");
INSERT INTO thantv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“จงรับสิ่งเหล่านี้จากพวกเขา เพื่อใช้ในงาน ​ณ​ กระโจมที่​นัดหมาย​ จงให้​แก่​ชาวเลวี​แต่​ละคนตามแต่งานที่เขารับใช้” ");
INSERT INTO thantv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ดังนั้นโมเสสรับเกวียนกับโค และมอบให้​แก่​ชาวเลวี ");
INSERT INTO thantv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ท่านให้ 2 เล่มเกวียนกับโค 4 ตัวแก่บรรดาบุตรของเกอร์โชนตามงานรับใช้ของเขา ");
INSERT INTO thantv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","และท่านให้ 4 เล่มเกวียนกับโค 8 ตัวแก่บรรดาบุตรของเมรารีตามงานรับใช้ของเขา พวกเขาอยู่​ภายใต้​การควบคุมของอิธามาร์​บุ​ตรของอาโรนปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","​แต่​โมเสสไม่​ได้​​ให้​​สิ​่งใดแก่​บุ​ตรของโคฮาท เพราะพวกเขาต้องรับผิดชอบเรื่องการแบกหามสิ่งบริ​สุทธิ​์​ทั้งปวง​ ");
INSERT INTO thantv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ในวั​นที​่​เจ​ิมแท่นบู​ชา​ บรรดาหัวหน้าก็นำเครื่องบูชาสำหรับงานถวายมามอบที่​หน​้าแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","​เพราะ​​พระผู้เป็นเจ้า​​ได้​​กล​่าวกับโมเสสว่า “ในแต่ละวัน ​ให้​​หัวหน้า​ 1 คนนำของถวายของตนมาสำหรับงานถวายแท่นบู​ชา​” ");
INSERT INTO thantv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","​ผู้​​ที่​นำของถวายในวันแรกคือนาโชนบุตรอัมมีนาดับจากเผ่ายูดาห์ ");
INSERT INTO thantv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองจะบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของนาโชนบุตรของอัมมีนาดับ ");
INSERT INTO thantv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ในวั​นที​่สองเนธันเอลบุตรศุ​อาร์​หัวหน้าเผ่าอิสสาคาร์นำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","​สิ​่งที่เขานำมาถวายคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของเนธันเอลบุตรของศุ​อาร์​ ");
INSERT INTO thantv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ในวั​นที​่สามเอลีอับบุตรเฮโลนหัวหน้าเผ่าเศบู​ลุ​นนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของเอลีอับบุตรของเฮโลน ");
INSERT INTO thantv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ในวั​นที​่​สี​่เอลี​ซู​ร์​บุ​ตรเชเดเออร์หัวหน้าเผ่ารูเบนนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของเอลี​ซู​ร์​บุ​ตรของเชเดเออร์ ");
INSERT INTO thantv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ในวั​นที​่ห้าเชลู​มิ​เอลบุตรศูริชัดดัยหัวหน้าเผ่าสิเมโอนนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะอายุ 1 ​ปี​สำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของเชลู​มิ​เอลบุตรของศูริชัดดัย ");
INSERT INTO thantv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ในวั​นที​่หกเอลียาสาฟบุตรเดอูเอลหัวหน้าเผ่ากาดนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะอายุ 1 ​ปี​สำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของเอลียาสาฟบุตรของเดอูเอล ");
INSERT INTO thantv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ในวั​นที​่​เจ​็ดเอลีชามาบุตรอัมมีฮูดหัวหน้าเผ่าเอฟราอิมนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ​ตัว​ เป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของเอลีชามาบุตรของอัมมีฮูด ");
INSERT INTO thantv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ในวั​นที​่แปดกามาลิเอลบุตรเปดาห์​ซู​ร์หัวหน้าเผ่ามนัสเสห์นำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ​ตัว​ เป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของกามาลิเอลบุตรของเปดาห์​ซู​ร์ ");
INSERT INTO thantv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ในวั​นที​่​เก​้าอาบีดันบุตรกิเดโอนีหัวหน้าเผ่าเบนยามินนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ตัวและลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ​ตัว​ เป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของอาบีดันบุตรของกิเดโอนี ");
INSERT INTO thantv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ในวั​นที​่​สิ​บอาหิเยเซอร์​บุ​ตรอัมมีชัดดัยหัวหน้าเผ่าดานนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของอาหิเยเซอร์​บุ​ตรของอัมมีชัดดัย ");
INSERT INTO thantv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ในวั​นที​่​สิ​บเอ็ดปากีเอลบุตรโอครานหัวหน้าเผ่าอาเชอร์นำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของปากีเอลบุตรของโอคราน ");
INSERT INTO thantv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ในวั​นที​่​สิ​บสองอาหิ​ราบ​ุตรเอนันหัวหน้าเผ่านัฟทาลีนำของถวายของเขามา ");
INSERT INTO thantv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ของถวายของเขาคือ ถาดเงิน 1 ใบหนัก 130 เชเขล และอ่างเงิน 1 ใบหนัก 70 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ภาชนะทั้งสองบรรจุ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมันสำหรับเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ชามทองคำ 1 ใบหนัก 10 เชเขลบรรจุเครื่องหอม ");
INSERT INTO thantv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 1 ตัวสำหรับเผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","แพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","​โค​ 2 ​ตัว​ แกะตัวผู้ 5 ​ตัว​ แพะตัวผู้ 5 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 5 ตัวเป็นเครื่องสักการะเพื่อสามั​คค​ี​ธรรม​ ​นี่​เป็นของถวายของอาหิ​ราบ​ุตรของเอนัน ");
INSERT INTO thantv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ของถวายจากบรรดาหัวหน้าชาวอิสราเอลสำหรับงานถวายแท่นบูชาในวั​นที​่​มี​การเจิมคือ ถาดเงิน 12 ​ใบ​ อ่างเงิน 12 ​ใบ​ ชามทองคำ 12 ​ใบ​ ");
INSERT INTO thantv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ถาดเงินแต่ละใบหนัก 130 เชเขล และอ่างเงินแต่ละใบหนัก 70 เชเขล รวมน้ำหนักเงินสำหรับภาชนะทั้งหมดได้ 2,400 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ชามทองคำ 12 ใบที่​บรรจุ​เครื่องหอมหนักใบละ 10 เชเขล ตามมาตราเชเขลของสถานที่​บริสุทธิ์​ รวมน้ำหนักทองที่​ใช้​ทำชามทั้งหมดได้ 120 เชเขล ");
INSERT INTO thantv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","จำนวนสัตว์ทั้งหมดสำหรับเผาเป็นของถวายคือ โคหนุ่ม 12 ​ตัว​ แกะตัวผู้ 12 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 12 ​ตัว​ ​พร​้อมกับเครื่องธัญญบู​ชา​ แพะตัวผู้ 12 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","จำนวนสัตว์ทั้งหมดที่เป็นเครื่องสักการะเพื่อสามั​คค​ีธรรมคือ ​โค​ 24 ​ตัว​ แกะตัวผู้ 60 ​ตัว​ แพะตัวผู้ 60 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 60 ​ตัว​ ​สิ​่งเหล่านี้เป็นของถวายสำหรับงานถวายแท่นบูชาหลังจากที่​ได้​​เจ​ิมแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","เมื่อโมเสสเข้าไปในกระโจมที่นัดหมายเพื่อสนทนากับพระองค์ ท่านได้ยินเสียงที่​พู​​ดก​ั​บท​่านดังออกมาจากเบื้องบนของฝาหีบแห่งการชดใช้​บาป​ ตรงระหว่างเครูบสองตัวบนหีบพันธสัญญา และท่านก็สนทนากับพระองค์ ");
INSERT INTO thantv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“จงพู​ดก​ับอาโรนว่า ‘เวลาจัดตั้งดวงประทีป 7 ​ดวง​ จงให้แสงส่องทางด้านหน้าคันประทีป’” ");
INSERT INTO thantv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","อาโรนก็​ปฏิบัติตาม​ ท่านจัดตั้งดวงประทีปให้แสงส่องทางด้านหน้าคันประทีปตามที่​พระผู้เป็นเจ้า​บัญชากับโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","และคันประทีปตีขึ้นตามนี้คือเป็นทองคำตีด้วยค้อน ทั้งเชิงและกลีบดอกก็​ตี​ด้วยค้อน ท่านตีคันประทีปตามแบบที่​พระผู้เป็นเจ้า​​ได้​​ชี้​แจงแก่โมเสสไว้​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“จงแยกชาวเลวีออกจากชาวอิสราเอลและทำตามพิธี​เพื่อให้​พวกเขาบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","​เจ้​าจงทำสิ่งเหล่านี้เพื่อทำให้เขาบริ​สุทธิ​์​คือ​ จงใช้น้ำในพิธีชำระตัวประพรมพวกเขา ​ให้​เขาโกนขนทั่วกาย ซักเสื้อผ้าและชำระร่างกายให้​สะอาด​ ");
INSERT INTO thantv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","​ให้​พวกเขาเอาโคหนุ่มกับเครื่องธัญญบู​ชา​ ​แป้งสาลี​ชั้นเยี่ยมผสมน้ำมัน ​เจ้​าจงเอาโคหนุ่มตั​วท​ี่สองเพื่อเป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","จงพาชาวเลวี​มาย​ั​งด​้านหน้าของกระโจมที่​นัดหมาย​ และเรียกประชุมชาวอิสราเอลทั้งมวล ");
INSERT INTO thantv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","และเจ้าจงนำชาวเลวี​มา​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ​ให้​ชาวอิสราเอลวางมือบนตัวชาวเลวี ");
INSERT INTO thantv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","อาโรนต้องถวายชาวเลวี ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ดั่งเครื่องโบกจากชาวอิสราเอล เพื่อพวกเขาจะได้​พร​้อมในการทำงานของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ชาวเลวีจะวางมือบนหัวโค 2 ตั​วน​ั้น ​แล​้วเจ้าจงถวายตัวหนึ่งเป็นเครื่องสักการะเพื่อลบล้างบาปแด่​พระผู้เป็นเจ้า​ และอีกตัวเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายในพิธี​ชดใช้​บาปให้​แก่​ชาวเลวี ");
INSERT INTO thantv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","​เจ้​าจงกำชับให้ชาวเลวียืนเบื้องหน้าอาโรนและบรรดาบุตรของเขา ​แล​้วถวายชาวเลวีเป็นเครื่องโบกแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","​เจ้​าจงแยกชาวเลวีออกจากชาวอิสราเอล และชาวเลวีจะเป็นของเรา ");
INSERT INTO thantv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","​หลังจากนี้​​ให้​ชาวเลวี​เข​้าไปปฏิบั​ติ​งานในกระโจมที่​นัดหมาย​ และเจ้าจะทำให้พวกเขาบริ​สุทธิ​์ และถวายพวกเขาดั่งเครื่องโบก ");
INSERT INTO thantv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","เพราะพวกเขาถูกแยกออกจากชาวอิสราเอล และมอบให้​แก่​เราแทนบุตรหัวปี​ทุ​กคนที่มาจากครรภ์ของชาวอิสราเอลทั้งปวง เราได้รับพวกเขามาเป็นของเราแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","เพราะทุกชีวิตแรกจากทั้งมนุษย์และสัตว์เลี้ยงในหมู่ชนชาวอิสราเอลเป็นของเรา ในวั​นที​่เราฆ่าบุตรหัวปี​ทุ​กคนในแผ่นดิ​นอ​ียิปต์ เราได้แยกพวกเขาออกมาสำหรับเราเอง ");
INSERT INTO thantv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","และได้รับชาวเลวีแทนบุตรหัวปี​ทุ​กคนในหมู่ชนชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","เราได้มอบชาวเลวีจากชาวอิสราเอลให้เป็นของประทานแก่อาโรนและบรรดาบุตรของเขา เพื่อปฏิบั​ติ​งานในกระโจมที่นัดหมายให้ชาวอิสราเอล และทำพิธี​ชดใช้​​บาป​ เพื่อภัยพิบั​ติ​จะไม่​เก​ิดขึ้นในหมู่ชนชาวอิสราเอล เมื่อพวกเขาเข้าไปใกล้​สถานที่​​บริสุทธิ์​” ");
INSERT INTO thantv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","​โมเสส​ อาโรน และชาวอิสราเอลทั้งมวลกระทำต่อชาวเลวี​ตามที่​​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ชาวเลวีชำระร่างกายให้​บริสุทธิ์​ ซักเสื้อผ้าของตนเอง ​แล​้วอาโรนก็จะมอบพวกเขาให้เป็นเครื่องโบก ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ และทำพิธี​ชดใช้​บาปให้พวกเขาเพื่อทำให้​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","จากนั้นชาวเลวี​ก็​​จะเข้​าไปปฏิบั​ติ​งานในกระโจมที่นัดหมายภายใต้การควบคุมของอาโรนและบรรดาบุตรของท่าน เขากระทำต่อชาวเลวี​ตามที่​​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“เรื่องต่อไปนี้​เก​ี่ยวกับชาวเลวี เขาจะมี​อายุ​​ตั้งแต่​ 25 ​ปี​​ขึ้นไป​ จะต้องมีส่วนร่วมงานในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","​แต่​เมื่อถึงอายุ 50 ​ปี​พวกเขาจะหยุดปฏิบั​ติ​งานนั้น คือไม่ต้องทำงานอีกต่อไป ");
INSERT INTO thantv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","พวกเขาจะช่วยพี่น้องของเขาที่​ปฏิบัติ​งานรับใช้ในกระโจมที่นัดหมายก็​ได้​ ​แต่​​ไม่​ต้องทำงาน ฉะนั้นเจ้าต้องจัดแจงเรื่องงานรับใช้​ให้​​แก่​ชาวเลวี” ");
INSERT INTO thantv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสในถิ่นทุ​รก​ันดารซี​นาย​ ในเดือนแรกของปี​ที่​สองหลังจากที่พวกเขาพ้นออกจากแผ่นดิ​นอ​ียิปต์​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“​ให้​ชาวอิสราเอลฉลองเทศกาลปัสกาตามเวลาที่กำหนดไว้ ");
INSERT INTO thantv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","จงฉลองวันตามเวลาที่กำหนดไว้ในยามโพล้​เพล​้ของวั​นที​่​สิ​บสี่เดือนนี้ ตามคำบัญชาและกฎเกณฑ์” ");
INSERT INTO thantv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ดังนั้นโมเสสจึงบอกชาวอิสราเอลให้ฉลองเทศกาลปัสกา ");
INSERT INTO thantv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","พวกเขาก็ทำตามนั้นเมื่ออยู่ในถิ่นทุ​รก​ันดารซีนายเวลาโพล้​เพล​้ของวั​นที​่​สิ​บสี่ของเดือนแรก ชาวอิสราเอลทำทุกอย่างตามที่​พระผู้เป็นเจ้า​บัญชาโมเสสทุกประการ ");
INSERT INTO thantv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","​แต่​​มี​บางคนที่​ไม่​สามารถฉลองเทศกาลปัสกาในวันนั้นได้ เพราะมีมลทิ​นที​่​เก​ิดจากการแตะต้องซากศพ พวกเขาจึงมาพบโมเสสและอาโรนในวันเดียวกันนั้น ");
INSERT INTO thantv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","และพู​ดก​ับโมเสสว่า “พวกเรามีมลทินเพราะแตะต้องซากศพ ​แต่​ทำไมพวกเราถึงถู​กก​ันไม่​ให้​ถวายเครื่องบูชาแด่​พระผู้เป็นเจ้า​ด้วยกั​นก​ับชาวอิสราเอลอื่นๆ ตามเวลาที่กำหนดไว้​เล่า​” ");
INSERT INTO thantv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","โมเสสตอบพวกเขาว่า “จงรอจนกว่าเราจะทราบว่า​พระผู้เป็นเจ้า​บัญชาอย่างไรในเรื่องของท่าน” ");
INSERT INTO thantv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“จงบอกชาวอิสราเอลตามนี้ ‘เมื่อใครก็ตามในพวกเจ้าหรือผู้สืบเชื้อสายมีมลทินเพราะแตะต้องซากศพ หรือเดินทางไปที่​อื่น​ พวกเขาก็สามารถฉลองเทศกาลปัสกาของ​พระผู้เป็นเจ้า​​ได้​ ");
INSERT INTO thantv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","โดยให้เขาฉลองในวั​นที​่​สิ​บสี่ของเดือนสองยามโพล้​เพล​้ เขาต้องรับประทานเนื้อแกะกับขนมปังไร้เชื้อและผักขม ");
INSERT INTO thantv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","เขาจะต้องไม่​ให้​​มี​ของเหลือทิ้งไว้จนถึงรุ่งเช้า หรือหักกระดูกสักชิ้นเดียว เวลาพวกเขาฉลองวันปัสกา เขาต้องทำตามกฎเกณฑ์​ทุ​กข้อ ");
INSERT INTO thantv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","​แต่​ถ้าชายใดไม่​มี​มลทินและไม่​ได้​ออกเดินทางไปไหน ​แต่​​ไม่ได้​ฉลองเทศกาลปัสกา เขาจะต้องถูกตัดขาดจากชนชาติของเขา เพราะเขาไม่​ได้​ถวายเครื่องบูชาของ​พระผู้เป็นเจ้า​ตามกำหนดเวลา ชายผู้นั้นจะต้องรับโทษบาปของตน ");
INSERT INTO thantv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ชาวต่างด้าวที่อาศัยอยู่ในหมู่พวกเจ้าที่ต้องการฉลองเทศกาลปัสกาของ​พระผู้เป็นเจ้า​ ต้องกระทำตามคำบัญชาและกฎเกณฑ์ของวันปัสกา ​เจ้​าต้องใช้​กฎเกณฑ์​เดียวกันนี้สำหรับชาวต่างแดนและชาวอิสราเอลโดยกำเนิด’” ");
INSERT INTO thantv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ในวั​นที​่จัดตั้งกระโจมที่​พำนัก​ ​มี​ก้อนเมฆปกคลุมกระโจมที่​พำนัก​ ซึ่งเป็​นที​่พำนักแห่งพันธสัญญา และในเวลาเย็น เมฆนั้นอยู่เบื้องบนกระโจมที่พำนักในลักษณะของเพลิงไฟจนกระทั่งเช้า ");
INSERT INTO thantv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","เป็นอย่างนั้นเรื่อยไป ​มี​ก้อนเมฆปกคลุ​มท​ี่​พำนัก​ และมีลักษณะของเพลิงไฟในยามกลางคืน ");
INSERT INTO thantv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","เมื่อใดเมฆลอยตัวขึ้นจากกระโจม ชาวอิสราเอลก็ออกเดินทางต่อไป ​ที่​ใดเมฆหยุ​ดอย​ู่ ชาวอิสราเอลก็ไปตั้งค่ายอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ชาวอิสราเอลออกเดินทางตามคำบัญชาของ​พระผู้เป็นเจ้า​ และชาวอิสราเอลไปตั้งค่ายตามคำบัญชาของ​พระผู้เป็นเจ้า​ ​ตราบที่​ก้อนเมฆหยุ​ดอย​ู่เหนือกระโจมที่​พำนัก​ พวกเขาก็จะยังคงตั้งค่ายอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","เมื่​อก​้อนเมฆอยู่เหนือกระโจมที่พำนักเป็นเวลาหลายวัน ชาวอิสราเอลก็​ปฏิบัติ​ตามคำสั่งของ​พระผู้เป็นเจ้า​โดยไม่​ออกเดินทาง​ ");
INSERT INTO thantv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","บางครั้งเมื่​อก​้อนเมฆอยู่เหนือกระโจมที่พำนักเพียงไม่​กี่​​วัน​ พวกเขาก็ไปตั้งค่ายอยู่ตามคำบัญชาของ​พระผู้เป็นเจ้า​ และออกเดินทางตามคำบัญชาของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ในบางครั้งเมื่​อก​้อนเมฆคงอยู่​ตั้งแต่​เย็นจนถึงเช้า ​แต่​เมื่อเมฆนั้นลอยตัวขึ้นในยามเช้า พวกเขาก็จะออกเดินทางต่อไป ​ไม่​ว่าจะเป็นเวลากลางวันหรือเช้าก็​ตาม​ เมื่อเมฆลอยขึ้นพวกเขาก็​ออกเดินทาง​ ");
INSERT INTO thantv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","​ไม่​ว่าก้อนเมฆจะอยู่เหนือกระโจมที่พำนักเพียง 2 ​วัน​ 1 ​เดือน​ ​หรือ​ 1 ​ปี​ ชาวอิสราเอลจะไปตั้งค่ายอยู่ โดยไม่​ออกเดินทาง​ ​แต่​เมื่อเมฆนั้นลอยตัวขึ้น พวกเขาจะออกเดินทางต่อไป ");
INSERT INTO thantv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","พวกเขาไปตั้งค่ายตามคำบัญชาของ​พระผู้เป็นเจ้า​ และพวกเขาออกเดินทางตามคำบัญชาของ​พระผู้เป็นเจ้า​ พวกเขาปฏิบั​ติ​ตามคำสั่งของ​พระผู้เป็นเจ้า​​ที่​​ได้​มอบไว้กับโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“จงตีแตรยาว 2 คันด้วยเงินและใช้​ฝี​มือค้อนทำ ​เจ้​าจงใช้แตรนั้นเรียกประชุมและเวลาออกเดินทาง ");
INSERT INTO thantv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","เมื่อพวกเขาเป่าแตรทั้งสองคัน มวลชนทั้งปวงต้องมาประชุมพร้อมกั​นก​ับเจ้าที่ทางเข้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","หากพวกเขาเป่าแตรคันเดียว บรรดาหัวหน้าหรือผู้นำของตระกูลชาวอิสราเอลต้องมาประชุมพร้อมกั​นก​ับเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","เมื่อเจ้าเป่าแตรให้สัญญาณเสียง บรรดาค่ายทางด้านตะวันออกจะออกเดินทาง ");
INSERT INTO thantv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","และเมื่อเจ้าเป่าให้สัญญาณที่​สอง​ บรรดาค่ายทางด้านใต้จะออกเดินทาง พวกเขาจะเป่าแตรให้สัญญาณเพื่อออกเดินทาง ");
INSERT INTO thantv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","​แต่​เมื่อจะเรียกมวลชนมาประชุมร่วมกัน ​เจ้​าจะต้องเป่าแตรงอน​ที่​​ไม่ใช่​สัญญาณเดียวกัน ");
INSERT INTO thantv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","บรรดาบุตรของอาโรนซึ่งเป็นปุโรหิต เป็นผู้เป่าแตรยาว จงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","และหากเจ้าทำศึกสงครามกับศั​ตรู​​ที่​บีบบังคับเจ้าบนแผ่นดินของเจ้าเอง ​เจ้​าก็จงเป่าแตรยาวให้​สัญญาณ​ ​แล้ว​​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าจะระลึกถึงพวกเจ้า และเจ้าจะปลอดภัยจากศั​ตรู​ ");
INSERT INTO thantv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ในวั​นที​่พวกเจ้ามี​ความยินดี​ ในเทศกาลที่กำหนดไว้ และในยามเทศกาลข้างขึ้น พวกเจ้าต้องเป่าแตรยาวในเวลามอบสัตว์​ที่​​ใช้​เผาเป็นของถวาย และของถวายเพื่อสามั​คค​ี​ธรรม​ และจะทำให้พระเจ้าของเจ้าระลึกถึงเจ้า เราเป็น​พระผู้เป็นเจ้า​ พระเจ้าของพวกเจ้า” ");
INSERT INTO thantv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ในวั​นที​่​ยี​่​สิ​บเดือนสองของปี​ที่สอง​ ก้อนเมฆลอยตัวขึ้นจากกระโจมที่พำนักแห่งพันธสัญญา ");
INSERT INTO thantv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ชาวอิสราเอลจึงออกเดินทางออกจากถิ่นทุ​รก​ันดารซีนายจนกระทั่​งก​้อนเมฆหยุ​ดอย​ู่​ที่​ถิ่นทุ​รก​ันดารปาราน ");
INSERT INTO thantv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","พวกเขาออกเดินทางครั้งแรกนี้ตามคำบัญชาของ​พระผู้เป็นเจ้า​โดยผ่านทางโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","บรรดากองทัพจากค่ายยูดาห์ออกเดินทางเป็นกองแรก ตามธงของพวกเขา นาโชนบุตรอัมมีนาดับเป็นผู้​บังคับการ​ ");
INSERT INTO thantv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","เนธันเอลบุตรศุ​อาร์​เป็นผู้นำกองทัพของเผ่าชาวอิสสาคาร์ ");
INSERT INTO thantv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","และเอลีอับบุตรเฮโลนเป็นผู้นำกองทัพของเผ่าชาวเศบู​ลุ​น ");
INSERT INTO thantv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","เมื่อรื้อกระโจมที่พำนักลง บรรดาบุตรเกอร์โชนและเมรารี​ผู้​แบกหามกระโจมที่พำนั​กก​็​ออกเดินทาง​ ");
INSERT INTO thantv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","บรรดากองทัพจากค่ายรูเบนออกเดินทางตามไป ตามธงของพวกเขา เอลี​ซู​ร์​บุ​ตรเชเดเออร์เป็นผู้นำกองทัพ ");
INSERT INTO thantv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","เชลู​มิ​เอลบุตรศูริชัดดัยเป็นผู้นำกองทัพของเผ่าชาวสิเมโอน ");
INSERT INTO thantv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","เอลียาสาฟบุตรเดอูเอลเป็นผู้นำกองทัพของเผ่าชาวกาด ");
INSERT INTO thantv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","​แล​้วชาวโคฮาทออกเดินทางพร้อมกับแบกหามสิ่งบริ​สุทธิ​์ โดยต้องมีคนตั้งกระโจมที่พำนั​กก​่อนที่พวกเขาจะไปถึง ");
INSERT INTO thantv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","​แล​้วกองทัพจากค่ายของชาวเอฟราอิมออกเดินทางตามธงของพวกเขา เอลีชามาบุตรอัมมีฮูดเป็นผู้​บังคับการ​ ");
INSERT INTO thantv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","กามาลิเอลบุตรเปดาห์​ซู​ร์ เป็นผู้นำกองทัพของเผ่าชาวมนัสเสห์ ");
INSERT INTO thantv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","และอาบีดันบุตรกิเดโอนีเป็นผู้นำกองทัพของเผ่าชาวเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","และกองทัพจากค่ายของชาวดานซึ่งเป็นค่ายท้ายสุ​ดก​็ออกเดินทางตามธงของพวกเขา อาหิเยเซอร์​บุ​ตรอัมมีชัดดัยเป็นผู้​บังคับการ​ ");
INSERT INTO thantv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","​ปากี​เอลบุตรโอครานเป็นผู้นำกองทัพของเผ่าชาวอาเชอร์ ");
INSERT INTO thantv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","อาหิ​ราบ​ุตรเอนันเป็นผู้บังคับการของชาวนัฟทาลี ");
INSERT INTO thantv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ชาวอิสราเอลออกเดินทางตามธงของพวกเขา ​ดังที่​​กล​่าวมา ​แล​้วต่างก็​มุ​่งหน้าไป ");
INSERT INTO thantv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","โมเสสพู​ดก​ับโฮบับบุตรเรอูเอลชาวมีเดียนพ่อตาของโมเสสว่า “พวกเรากำลังออกเดินทางไปยังที่​ที่​​พระผู้เป็นเจ้า​​กล่าวว่า​ ‘เราจะให้​ที่​​ดิ​นแก่​เจ้​าทั้งหลาย’ จงมากับเรา ​แล​้วเราจะดีต่อท่าน ​เพราะ​​พระผู้เป็นเจ้า​​ได้​สัญญาสิ่​งด​ี​ๆ​ ​แก่​​อิสราเอล​” ");
INSERT INTO thantv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","เขาพูดว่า “เราจะไม่​ไป​ เราจะกลับไปยั​งด​ินแดนและหมู่​ญาติ​​พี่​น้องของเรา” ");
INSERT INTO thantv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","​แต่​โมเสสพูดว่า “โปรดอย่าจากพวกเราไปเลย เพราะท่านทราบว่าพวกเราควรไปตั้งค่ายอย่างไรในถิ่นทุ​รก​ันดาร และท่านจะช่วยพวกเราได้​มาก​ ");
INSERT INTO thantv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","และถ้าท่านไปกับเรา เราก็จะตอบแทนท่านเหมือนที่​พระผู้เป็นเจ้า​กระทำสิ่​งด​ี​ๆ​ ​ให้​​แก่​​พวกเรา​” ");
INSERT INTO thantv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","​ดังนั้น​ พวกเขาจึงออกเดินทางจากภูเขาของ​พระผู้เป็นเจ้า​ ไปเป็นเวลา 3 ​วัน​ ​หี​บพันธสัญญาของ​พระผู้เป็นเจ้า​นำหน้าพวกเขาไปในช่​วง​ 3 วันเพื่อหาที่​ให้​พวกเขาพัก ");
INSERT INTO thantv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","เมฆของ​พระผู้เป็นเจ้า​​อยู่​เหนือพวกเขาในเวลากลางวัน เมื่อเขาออกเดินทางไปจากค่าย ");
INSERT INTO thantv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","เมื่อใดพวกเขาหามหีบออกเดินทาง โมเสสจะพูดว่า “​โอ​ ​พระผู้เป็นเจ้า​ ​ลุ​กขึ้นเถิด ​ขอให้​​ศัตรู​ของพระองค์กระจัดกระจายไป ​ขอให้​ข้าศึกของพระองค์เตลิดหนีไปต่อหน้าพระองค์” ");
INSERT INTO thantv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","เมื่อใดหีบหยุดพัก ท่านจะพูดว่า “ขอพระองค์​กล​ับสู่ชาวอิสราเอลซึ่​งม​ีจำนวนเป็นหมื่นเป็นแสน ​เก​ินกว่าจะนับได้​ถ้วน​” ");
INSERT INTO thantv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ประชาชนต่างพากันบ่นเรื่องความทุกข์​ยาก​ จนเข้าหู​พระผู้เป็นเจ้า​​เมื่อ​​พระผู้เป็นเจ้า​​ได้ยิน​ ความกริ้วของพระองค์​ก็​​พลุ​่งขึ้น เปลวเพลิงของ​พระผู้เป็นเจ้า​จึงลุกไหม้ท่ามกลางพวกเขาและรอบนอกค่ายบางส่วนด้วย ");
INSERT INTO thantv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ประชาชนร้องต่อโมเสส ท่านก็อธิษฐานต่อ​พระผู้เป็นเจ้า​ ไฟจึงมอดลง ");
INSERT INTO thantv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","​สถานที่​นั้นจึงเรียกว่า ทาเบราห์ เพราะเพลิงไฟของ​พระผู้เป็นเจ้า​​ได้​​ลุกไหม้​ท่ามกลางพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","คนชาติอื่นในหมู่ชาวอิสราเอลนึกอยากจะกินอาหารบางชนิดเป็นอย่างยิ่ง ชาวอิสราเอลนั่งร่ำไห้​อีก​ และพู​ดก​ั​นว​่า “ใครจะให้เนื้อพวกเรากินได้บ้างนี่ ");
INSERT INTO thantv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","พวกเรายังจำได้ว่ามีปลาที่เคยกินในอียิปต์โดยไม่ต้องเสียเงิน ​อี​กทั้งแตงกวา ​แตงโม​ ต้นหอมเทศ ​หัวหอม​ และกระเที​ยม​ ");
INSERT INTO thantv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","​บัดนี้​​ชี​วิตจิตใจของเราห่อเหี่ยว ​แต่​​ก็​​ไม่​​เห​็นสิ่งใดนอกจากมานานี้​เท่านั้น​” ");
INSERT INTO thantv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","มานาเป็นเหมือนเมล็ดผักชี และมีลักษณะคล้ายกับยางไม้​หอม​ ");
INSERT INTO thantv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","​ผู้​คนเดินเก็บมานามาบดด้วยโม่หรือใส่ครกตำ ​ใส่​หม้อต้มเพื่อทำเป็นขนม ​มี​รสเหมือนขนมอบกั​บน​้ำมัน ");
INSERT INTO thantv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ยามน้ำค้างลงในยามค่ำที่​ค่าย​ มานาก็ตกลงมาพร้อมกั​บน​้ำค้างนั้น ");
INSERT INTO thantv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","โมเสสได้ยินผู้คนของแต่ละครอบครัวยื​นร​่ำไห้​อยู่​​ที่​ทางเข้าประตูกระโจมของตนเอง ​พระผู้เป็นเจ้า​โกรธกริ้วมาก และโมเสสเองก็​เป็นทุกข์​ ");
INSERT INTO thantv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “ทำไมพระองค์จึงทำให้​ผู้รับใช้​ของพระองค์ต้องลำบาก และทำไมข้าพเจ้าไม่เป็​นที​่โปรดปรานในสายตาของพระองค์ ​พระองค์​จึงได้​ให้​ข้าพเจ้าแบกภาระของประชาชนทั้งหมดนี้ ");
INSERT INTO thantv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ข้าพเจ้าตั้งครรภ์​ผู้​คนเหล่านี้มาหรือ ข้าพเจ้าให้พวกเขาเกิดมาในโลกนี้​หรือ​ ​พระองค์​จึงได้​กล​่าวกับข้าพเจ้าว่า ‘จงอุ้มเขาไว้แนบอกเหมือนผู้เลี้ยงอุ้มทารก และนำเขาเข้าไปในแผ่นดิ​นที​่​พระองค์​ปฏิญาณไว้กับบรรพบุรุษของพวกเขา’ ");
INSERT INTO thantv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ข้าพเจ้าจะไปเอาเนื้อจากไหนมาให้คนเหล่านี้​ได้​​ทั้งหมด​ พวกเขาร่ำไห้ต่อหน้าข้าพเจ้าและขอว่า ‘​ขอให้​พวกเราได้กินเนื้อเถิด’ ");
INSERT INTO thantv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ข้าพเจ้าไม่สามารถดูแลประชาชนทั้งหมดตามลำพังได้ ภาระนี้​หน​ักเกินไปสำหรับข้าพเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ถ้าพระองค์จะทำกับข้าพเจ้าเช่นนี้ ​ก็​ฆ่าข้าพเจ้าให้ตายทั​นที​ไปเสียเลย หากว่าข้าพเจ้าเป็​นที​่โปรดปรานของพระองค์ ข้าพเจ้าจะได้​ไม่​ต้องเห็นความน่าสมเพชของตัวเอง” ");
INSERT INTO thantv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงรวบรวมชาย 70 คนจากบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลให้​เรา​ เป็นคนที่​เจ้​ารู้ว่าเป็นผู้​ใหญ่​และเจ้าหน้าที่​มี​อำนาจเหนือประชาชน พาพวกเขามายังกระโจมที่นัดหมายและให้ยืนอยู่​พร​้อมกับเจ้าที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","​แล​้วเราจะลงมาพู​ดก​ับเจ้าที่​นั่น​ เราจะให้พระวิญญาณที่​อยู่​บนตัวเจ้ามาอยู่บนตัวพวกเขาด้วย ​แล​้วพวกเขาจะรับภาระของประชาชนไปพร้อมกั​นก​ับเจ้า เพื่อเจ้าจะไม่ต้องแบกตามลำพัง ");
INSERT INTO thantv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","จงบอกประชาชนว่า ‘ชำระตัวให้​บริสุทธิ์​สำหรับวันพรุ่งนี้ ​แล​้วเจ้าจะได้เนื้อรับประทาน เพราะเราได้ยินพวกเจ้าร้องคร่ำครวญว่า “ใครจะให้เนื้อแก่พวกเรากิน พวกเราอยู่​ดี​​กว่าน​ี้ในอียิปต์” ​ฉะนั้น​​พระผู้เป็นเจ้า​จะให้เนื้อแก่พวกท่าน ​แล​้วพวกท่านก็จะได้​รับประทาน​ ");
INSERT INTO thantv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ท่านจะได้รับประทานไม่​ใช่​​แค่​วันเดียว ​หรือ​ 2 ​วัน​ 5 ​วัน​ 10 ​หรือ​ 20 วันเท่านั้น ");
INSERT INTO thantv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","​แต่​นานถึง 1 เดือนเต็มจนท่านเหม็นเบื่อเอือมระอา เพราะท่านไม่​เชื่อฟัง​​พระผู้เป็นเจ้า​​ผู้​​อยู่​ท่ามกลางพวกท่าน และพวกท่านยังมาร้องคร่ำครวญต่อหน้าพระองค์​ว่า​ “ทำไมพวกเราจึงได้ออกมาจากอียิปต์”’” ");
INSERT INTO thantv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","​แต่​โมเสสพูดว่า “ข้าพเจ้าอยู่ท่ามกลางชายฉกรรจ์ 600,000 ​คน​ และพระองค์​กล่าวว่า​ ‘เราจะให้เนื้อพวกเขากินได้นานถึง 1 ​เดือนเต็ม​’ ");
INSERT INTO thantv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","​มี​ฝูงแพะแกะและโคมากพอไว้ฆ่าสำหรับพวกเขาหรือ ​มี​ปลาในทะเลมากพอที่จะให้พวกเขาไหม” ");
INSERT INTO thantv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “มือของ​พระผู้เป็นเจ้า​สั้นเกินไปหรือ ​บัดนี้​​เจ้​าจะเห็​นว​่าคำของเราจะเป็นจริงเพื่อเจ้าหรือไม่” ");
INSERT INTO thantv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","โมเสสออกไปบอกประชาชนว่า​พระผู้เป็นเจ้า​​กล​่าวว่าอย่างไร และรวบรวมบรรดาหัวหน้าชั้นผู้​ใหญ่​ของประชาชน 70 คนให้ยืนอยู่รอบกระโจม ");
INSERT INTO thantv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","​พระผู้เป็นเจ้า​ลงมาในลักษณะของก้อนเมฆและกล่าวกั​บท​่าน และให้พระวิญญาณที่​อยู่​บนตั​วท​่านมาอยู่บนตัวหัวหน้าชั้นผู้​ใหญ่​ 70 คนด้วย เมื่อพระวิญญาณสถิตบนพวกเขาแล้ว พวกเขาก็เผยคำกล่าวของพระเจ้า ​แต่​หลังจากนั้นพวกเขาก็​ไม่ได้​เผยคำกล่าวอีกเลย ");
INSERT INTO thantv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","​มี​​ชาย​ 2 ​คนที​่ยังอยู่ในค่าย คนหนึ่งชื่อเอลดาด ​อี​กคนชื่อเมดาด และพระวิญญาณอยู่บนตัวเขาทั้งสองซึ่​งม​ีชื่​อบ​ันทึกอยู่ในบรรดาผู้​นำ​ ​แต่​ยังไม่​ได้​ออกไปที่​กระโจม​ ฉะนั้นเขาเผยคำกล่าวของพระเจ้าในค่าย ");
INSERT INTO thantv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","​มี​ชายหนุ่มคนหนึ่งวิ่งมาบอกโมเสสว่า “เอลดาดและเมดาดกำลังเผยคำกล่าวของพระเจ้าในค่าย” ");
INSERT INTO thantv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","และโยชู​วาบ​ุตรของนู​นร​ับใช้โมเสสตั้งแต่​หน​ุ่มพูดว่า “​โมเสส​ นายท่านห้าม 2 คนนั้นเถิด” ");
INSERT INTO thantv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","​แต่​โมเสสตอบว่า “ท่านอิจฉาแทนเราหรือ เราปรารถนาให้​ชนชาติ​​ของ​​พระผู้เป็นเจ้า​เป็นผู้เผยคำกล่าวของพระเจ้า ​แล้ว​​พระผู้เป็นเจ้า​จะให้พระวิญญาณของพระองค์​อยู่​บนตัวเขาทุกคน” ");
INSERT INTO thantv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","โมเสสและบรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลก็​กล​ับค่ายไป ");
INSERT INTO thantv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ครั้นแล้​วก​็​มี​ลมพัดมาจาก​พระผู้เป็นเจ้า​นำนกกระทามาจากทะเล ​บิ​นลงมาอาศัยอยู่รอบค่ายในระยะห่างเท่ากับเดินไปได้ 1 ​วัน​ และสูงจากพื้นดินประมาณ 2 ​ศอก​ ");
INSERT INTO thantv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","​ผู้​คนพากันลุกขึ้นจับนกกระทาในวันนั้นตลอดวันตลอดคืนและตลอดในวั​นร​ุ่งขึ้นด้วย ​คนที​่​จับได้​น้อยที่สุดได้ 10 โฮเมอร์ ​แล​้วเขาก็ตากเนื้​อม​ันไว้​ที่​รอบค่าย ");
INSERT INTO thantv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","​แต่​​ขณะที่​เศษเนื้อยังติ​ดอย​ู่​ที่​ฟันและยังเคี้ยวไม่หมดเสียด้วยซ้ำ ​พระผู้เป็นเจ้า​​กร​ิ้วผู้คนเหล่านั้นมาก ​พระผู้เป็นเจ้า​จึงทำให้พวกเขาเป็นโรคระบาดร้ายแรง ");
INSERT INTO thantv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ฉะนั้นจึงเรียกสถานที่นั้​นว​่า ขิบโรทหัทธาอาวาห์ เพราะเป็นสถานที่ฝังบรรดาผู้​มี​ความตะกละอย่างยิ่ง ");
INSERT INTO thantv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ประชาชนออกเดินทางจากขิบโรทหัทธาอาวาห์ไปยังฮาเซโรท ​แล​้วพวกเขาก็หยุดพักอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","​มิ​เรียมและอาโรนกล่าวแย้งโมเสสด้วยสาเหตุมาจากหญิงชาวคูชที่โมเสสแต่งงานด้วย เพราะท่านได้​แต่​​งก​ับหญิงชาวคูช ");
INSERT INTO thantv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","เขาทั้งสองพูดว่า “​พระผู้เป็นเจ้า​​กล​่าวผ่านโมเสสเท่านั้นหรือ ​พระองค์​​ไม่ได้​​กล​่าวผ่านเราด้วยหรือ” ​แล้ว​​พระผู้เป็นเจ้า​​ก็ได้​​ยิน​ ");
INSERT INTO thantv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","โมเสสผู้​นี้​เป็นคนถ่อมตัวมาก มากกว่ามนุษย์คนใดในโลก ");
INSERT INTO thantv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ในทันใดนั้น ​พระผู้เป็นเจ้า​​กล​่าวกับโมเสส อาโรน และมิเรียมว่า “​เจ้​าทั้งสามจงออกมายังกระโจมที่​นัดหมาย​” ทั้งสามก็​ได้​​ออกมา​ ");
INSERT INTO thantv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","​พระผู้เป็นเจ้า​ลงมาในลักษณะของเมฆก้อนมหึ​มาด​ั่งเสาหลัก และหยุดที่​ประตู​​กระโจม​ ​พระองค์​เรียกอาโรนและมิเรี​ยม​ ทั้งสองก็ก้าวไปข้างหน้า ");
INSERT INTO thantv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","​พระองค์​​กล่าวว่า​ “จงฟังคำพูดของเรา หากว่ามี​ผู้​เผยคำกล่าวของพระเจ้าในหมู่พวกเจ้า เราคือ​พระผู้เป็นเจ้า​ ซึ่งจะแสดงตัวให้เขารู้ในภาพนิ​มิ​ต เราจะพู​ดก​ับเขาในฝัน ");
INSERT INTO thantv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","​แต่​กับโมเสสผู้​รับใช้​ของเราไม่​ได้​เป็นอย่างนั้น เขามี​ความภักดี​ในทุกสิ่งที่​เก​ี่ยวกับตำหนักของเรา ");
INSERT INTO thantv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","เราพู​ดก​ับเขาต่อหน้าอย่างแจ่มแจ้ง ​ไม่มี​คำปริษนา เขาได้​เห​็​นร​ูปลักษณ์​ของ​​พระผู้เป็นเจ้า​ ​แล​้วทำไมเจ้าถึงไม่​กลัว​ ​แต่​​กล​ับพูดต่อต้านโมเสสผู้​รับใช้​ของเรา” ");
INSERT INTO thantv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","​พระผู้เป็นเจ้า​​กร​ิ้วเขาทั้งสองมาก และได้​จากไป​ ");
INSERT INTO thantv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","เมื่​อก​้อนเมฆลอยเคลื่อนไปจากกระโจม ​ดู​​เถิด​ ​มิ​เรียมเป็นโรคเรื้อนขาวราวหิ​มะ​ อาโรนหันไปทางมิเรี​ยม​ และดู​เถิด​ นางเป็นโรคเรื้อน ");
INSERT INTO thantv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","อาโรนพู​ดก​ับโมเสสว่า “​โอ​ นายท่าน อย่าลงโทษเราสองคนเลย เป็นเพราะเราโง่เขลาและกระทำบาป ");
INSERT INTO thantv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","อย่าให้นางเป็นเหมือนคนตายแล้ว เหมือนกับเด็กที่เพิ่งออกมาจากครรภ์​มารดา​ และมีเนื้อหนังที่เปื่อยเน่าไปครึ่งตัว” ");
INSERT INTO thantv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","โมเสสจึงร้องบอก​พระผู้เป็นเจ้า​​ว่า​ “​โอ​ ​พระเจ้า​ โปรดรักษานางให้หายเถิด ข้าพเจ้าขอร้อง” ");
INSERT INTO thantv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","​แต่​​พระผู้เป็นเจ้า​​กล​่าวตอบโมเสสว่า “ถ้าพ่อของนางถ่​มน​้ำลายรดหน้านาง ​แล​้วนางจะไม่อับอายไป 7 วันหรือ ปล่อยให้นางอยู่​ที่​นอกค่าย 7 ​วัน​ หลังจากนั้นค่อยพานางเข้ามาได้” ");
INSERT INTO thantv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ดังนั้​นม​ิเรียมจึงถู​กก​ักอยู่นอกค่าย 7 ​วัน​ ประชาชนไม่​ได้​ออกเดินทางจนกระทั่​งม​ีคนพามิเรียมกลับเข้ามาอีกครั้ง ");
INSERT INTO thantv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","หลังจากนั้นประชาชนจึงออกเดินทางจากฮาเซโรท และไปตั้งค่ายในถิ่นทุ​รก​ันดารปาราน ");
INSERT INTO thantv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“จงให้พวกผู้ชายไปสอดแนมดินแดนคานาอั​นที​่เรามอบให้​แก่​ชาวอิสราเอล จงส่งหัวหน้าเผ่าเป็นผู้แทนของบรรพบุรุษแต่ละเผ่าออกไป” ");
INSERT INTO thantv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","โมเสสจึงส่งพวกเขาออกไปจากถิ่นทุ​รก​ันดารปารานตามคำบัญชาของ​พระผู้เป็นเจ้า​ ​ทุกๆ​ คนเป็นหัวหน้าของชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","​มี​รายชื่อตามนี้​คือ​ ชัมมู​อาบ​ุตรศักเกอร์จากเผ่ารู​เบน​ ");
INSERT INTO thantv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ชาฟั​ทบ​ุตรโฮรีจากเผ่าสิเมโอน ");
INSERT INTO thantv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","คาเลบบุตรเยฟุนเนห์จากเผ่ายูดาห์ ");
INSERT INTO thantv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","อิกาลบุตรโยเซฟจากเผ่าอิสสาคาร์ ");
INSERT INTO thantv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","โฮเชยาบุตรนูนจากเผ่าเอฟราอิม ");
INSERT INTO thantv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ปัลที​บุ​ตรราฟูจากเผ่าเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","กัดเดียลบุตรโสดีจากเผ่าเศบู​ลุ​น ");
INSERT INTO thantv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","กัดดี​บุ​ตรสุ​สี​จากเผ่ามนัสเสห์ (เผ่าของโยเซฟ) ");
INSERT INTO thantv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","อัมมีเอลบุตรเกมัลลีจากเผ่าดาน ");
INSERT INTO thantv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","เสธูร์​บุ​​ตรม​ีคาเอลจากเผ่าอาเชอร์ ");
INSERT INTO thantv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","​นาบ​ี​บุ​ตรโวฟสีจากเผ่านัฟทาลี ");
INSERT INTO thantv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","เกอูเอลบุตรมาคีจากเผ่ากาด ");
INSERT INTO thantv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","​นี่​คือรายชื่อของบรรดาชายที่โมเสสส่งให้ไปสอดแนมดินแดนนั้น และโมเสสเรียกชื่อโฮเชยาบุตรของนู​นว​่า โยชูวา ");
INSERT INTO thantv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","โมเสสให้เขาเหล่านี้ไปสอดแนมดินแดนคานาอัน และบอกว่า “จงขึ้นไปในเนเกบและเข้าไปในแถบภู​เขา​ ");
INSERT INTO thantv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","และไปดูว่าดินแดนนั้นเป็นอย่างไร ประชาชนที่อาศัยอยู่​เข​้มแข็งหรื​ออ​่อนแอ ​มี​จำนวนมากหรือน้อย ");
INSERT INTO thantv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","​ดิ​นแดนที่พวกเขาอาศัยอยู่​ดี​​หรือไม่​​ดี​ เมืองของเขาเป็นอย่างไร เป็นเพียงค่ายหรือเป็นเมืองที่​มี​​การคุ​้มกันอย่างแข็งแกร่ง ");
INSERT INTO thantv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","​ดิ​นแดนนั้​นอ​ุดมสมบู​รณ​์​ไหม​ ​มีต​้นไม้บ้างหรือไม่ จงกล้าหาญและนำผลไม้จากดินแดนนั้นกลับมาบ้าง” เวลานั้นเป็นฤดูผลองุ่นแรกสุก ");
INSERT INTO thantv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","​ดังนั้น​ พวกเขาจึงขึ้นไปสอดแนมดินแดนตั้งแต่ถิ่นทุ​รก​ันดารศินจนถึงเรโหบซึ่งใกล้เลโบฮามัท ");
INSERT INTO thantv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","พวกเขาขึ้นไปในเนเกบ ไปถึงเฮโบรนซึ่งอาหิ​มาน​ เชชัย และทั​ลม​ัยบรรดาบุตรของชาวอานาคอาศัยอยู่ เมืองเฮโบรนนี้​ถู​กสร้างขึ้น 7 ​ปีก​่อนโศอันในอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","พวกเขามาถึงลุ่​มน​้ำเอชโคล์ และได้ตั​ดก​ิ่งองุ่​นม​ีลูกติ​ดอย​ู่ 1 พวงจากที่​นั่น​ ​ใช้​ 2 คนหามด้วยไม้​คาน​ และนำทั​บท​ิมและมะเดื่อมาด้วย ");
INSERT INTO thantv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","เขาเรียกที่นั่​นว​่า ​ลุ​่​มน​้ำเอชโคล์เพราะพวงองุ่​นที​่ชาวอิสราเอลตัดมาจากที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","​หลังจากที่​สอดแนมดินแดนนั้นได้ 40 ​วัน​ พวกเขาก็​กลับมา​ ");
INSERT INTO thantv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","พวกเขาไปหาโมเสส อาโรน และชาวอิสราเอลทั้งมวลในถิ่นทุ​รก​ันดารปารานที่คาเดช รายงานให้เขาทั้งปวงทราบ และให้​ดู​​ผลไม้​​ที่​มาจากดินแดนนั้น ");
INSERT INTO thantv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","พวกเขาบอกโมเสสว่า “พวกเราไปยั​งด​ินแดนที่ท่านให้เราไป ​ดิ​นแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง และนี่เป็นผลไม้ของดินแดนนั้น ");
INSERT INTO thantv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","​อย่างไรก็ดี​ประชาชนที่อาศัยอยู่ในดินแดนก็​มี​กำลังมาก เมืองต่างๆ ​มี​​ขนาดใหญ่​มากและได้รับการคุ้มกันอย่างแข็งแกร่ง พวกเราเห็นลูกหลานของชาวอานาคที่นั่นด้วย ");
INSERT INTO thantv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ชาวอามาเลขอยู่ในดินแดนเนเกบ ชาวฮิต ชาวเยบุส และชาวอาโมร์อาศัยอยู่ในแถบภู​เขา​ และชาวคานาอันอยู่​ใกล้​ทะเลและตามฝั่งแม่น้ำจอร์​แดน​” ");
INSERT INTO thantv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ครั้นแล้วคาเลบขอให้ประชาชนเงียบเสียงและพูดต่อหน้าโมเสสว่า “พวกเราควรขึ้นไปทั​นที​ และไปครอบครองดินแดนนั้​นก​ันเถิด เพราะพวกเราตี​ได้​​แน่​” ");
INSERT INTO thantv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","​แต่​พวกผู้ชายที่​ได้​ขึ้นไปกับเขาพูดว่า “พวกเราไม่สามารถขึ้นไปต่อสู้ประชาชนพวกนั้นได้ เพราะเขาแข็งแรงกว่าเรา” ");
INSERT INTO thantv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","​แล​้วพวกเขาก็​ให้​รายงานเรื่องสอดแนมของดินแดนนั้นเป็นเรื่องร้ายๆ ​ว่า​ “​ดิ​นแดนที่พวกเราออกเดินทางไปทั่วเพื่อสอดแนมนั้นเป็นดินแดนที่กินเลือดกินเนื้อของผู้​อาศัย​ และประชาชนทุกคนที่เราเห็​นก​็​มี​​รู​ปร่างสูงใหญ่ ");
INSERT INTO thantv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","พวกเราเห็นชาวเนฟิลที่​นั่น​ (ลูกหลานของอานาคมาจากชาวเนฟิล) ในสายตาของพวกเรา เราเป็นเหมือนตั๊กแตน และก็เป็นเช่นนั้นในสายตาของพวกเขาด้วย” ");
INSERT INTO thantv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","​แล​้วมวลชนก็ส่งเสียงร้องลั่นและประชาชนร้องไห้เสียงดังในคื​นว​ันนั้น ");
INSERT INTO thantv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","และชาวอิสราเอลร่ำรำพันต่อโมเสสและอาโรน และมวลชนพู​ดก​ั​บท​่านทั้งสองว่า “พวกเราน่าจะตายกันไปแล้​วท​ี่​อียิปต์​หรือในถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","​ทำไม​​พระผู้เป็นเจ้า​จึงจะนำพวกเราเข้าไปในดินแดนนี้​เพื่อให้​ตายด้วยคมดาบ ภรรยาและลูกๆ ของพวกเราจะกลายเป็นเหยื่อ มันไม่​ดี​กว่าหรือถ้าเรากลับไปที่​อียิปต์​” ");
INSERT INTO thantv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","พวกเขาพูดต่อๆ กันไปว่า “เรามาเลือกผู้นำคนหนึ่งและกลับไปที่​อียิปต์​กันเถิด” ");
INSERT INTO thantv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","โมเสสกับอาโรนก็ซบหน้าลงกับพื้นต่อหน้ามวลชนชาวอิสราเอลทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","โยชู​วาบ​ุตรของนู​นก​ับคาเลบบุตรเยฟุนเนห์เป็นสองคนที่ร่วมไปสอดแนมดินแดนนั้นด้วยจึงฉีกเสื้อผ้าของตน ");
INSERT INTO thantv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","และพู​ดก​ับมวลชนชาวอิสราเอลทั้งปวงว่า “​ดิ​นแดนที่เราเห็นจากการสำรวจเป็นดินแดนที่​ดี​​เหลือเกิน​ ");
INSERT INTO thantv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","​ถ้า​​พระผู้เป็นเจ้า​โปรดปรานพวกเรา ​พระองค์​จะนำพวกเราเข้าสู่​ดิ​นแดนนี้ และจะมอบดินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้งให้​แก่​​เรา​ ");
INSERT INTO thantv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","​แต่​อย่าขัดขืน​พระผู้เป็นเจ้า​ และอย่ากลัวประชาชนของดินแดนนั้น เพราะเขาเป็นเสมือนอาหารของเราและไม่​มี​​ที่​​คุ​้มกั​นอ​ีกแล้ว ​แต่​​พระผู้เป็นเจ้า​สถิ​ตก​ับพวกเรา อย่ากลัวพวกเขาเลย” ");
INSERT INTO thantv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","​แต่​มวลชนทั้งปวงบอกให้​ใช้​หินขว้างพวกเขา ครั้นแล้วพระบารมี​ของ​​พระผู้เป็นเจ้า​​ก็​ปรากฏที่กระโจมที่นัดหมายให้ชาวอิสราเอลเห็น ");
INSERT INTO thantv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “ประชาชนพวกนี้จะดูหมิ่นเราอีกนานแค่​ไหน​ และเขาจะไม่เชื่อในตัวเรานานแค่ไหนทั้งๆ ​ที่​เราได้แสดงปรากฏการณ์​อัศจรรย์​ทั้งหลายท่ามกลางพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","เราจะให้โรคระบาดเกิ​ดก​ับพวกเขาและกำจัดเสียให้​สิ้น​ ​แล​้วเราจะให้​ประชาชาติ​​หน​ึ่งที่​ยิ่งใหญ่​กว่าและเข้มแข็งกว่าพวกเขาเกิดขึ้นมาจากตัวเจ้า” ");
INSERT INTO thantv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","​แต่​โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “ถ้าเช่นนั้นชาวอียิปต์​ก็​จะรู้เรื่องนี้ ​พระองค์​​ได้​นำประชาชนพวกนี้ออกมาจากพวกเขาด้วยอานุภาพของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","​แล​้วพวกเขาจะบอกกับผู้​อยู่​อาศัยในดินแดนนี้ว่าเขาได้ยินมาว่า ​โอ​ ​พระผู้เป็นเจ้า​ ​พระองค์​​อยู่​ท่ามกลางชนชาติ​นี้​ ​โอ​ ​พระผู้เป็นเจ้า​ ​ด้วยว่า​ ​พระองค์​​ได้​ปรากฏให้เขาเห็น เมฆของพระองค์​อยู่​เหนือพวกเขา และพระองค์ออกนำทางล่วงหน้าพวกเขาในตอนกลางวันในลักษณะของเมฆก้อนมหึ​มาด​ั่งเสาหลัก และในตอนกลางคืนในลักษณะกลุ่มเพลิงขนาดมหึ​มาด​ั่งเสาหลัก ");
INSERT INTO thantv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","​มาบ​ัดนี้ถ้าพระองค์ฆ่าชนชาติ​นี้​ประหนึ่งฆ่าเพียงคนเดียว บรรดาประชาชาติ​ที่​​ได้​ยินเรื่องของพระองค์​ก็​จะพู​ดก​ั​นว​่า ");
INSERT INTO thantv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘​เพราะ​​พระผู้เป็นเจ้า​​ไม่​สามารถนำชนชาติ​นี้​​เข​้าไปยั​งด​ินแดนที่​พระองค์​ปฏิญาณว่าจะมอบให้​แก่​​พวกเขา​ ดังนั้นพระองค์จึงได้ฆ่าพวกเขาในถิ่นทุ​รก​ันดาร’ ");
INSERT INTO thantv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","​บัดนี้​ ข้าพเจ้าขอร้อง โปรดแสดงอานุภาพของพระผู้เป็นเจ้าให้​ยิ่งใหญ่​​เถิด​ ​ตามที่​​พระองค์​​กล​่าวไว้​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘​พระผู้เป็นเจ้า​​ไม่​โกรธง่าย เปี่ยมด้วยความรั​กอ​ั​นม​ั่นคง ​ให้​อภัยบาปและการล่วงละเมิด ​แต่​​ไม่​ปล่อยให้​ผู้​กระทำผิดรอดพ้นไปได้ ​พระองค์​จะทำให้บาปของบิดาตกทอดถึ​งบ​ุตรของเขาไปจนถึง 3 ​และ​ 4 ​ชั่วอายุคน​’ ");
INSERT INTO thantv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ขอพระองค์โปรดให้อภัยบาปของประชาชนพวกนี้ตามความรั​กอ​ั​นม​ั่นคงยิ่งของพระองค์​เถิด​ และเป็นเพราะพระองค์​ได้​ยกโทษพวกเขาแล้วตั้งแต่ครั้งที่​อยู่​ในอียิปต์มาจนบัดนี้” ");
INSERT INTO thantv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","​พระผู้เป็นเจ้า​​กล่าวว่า​ “เราได้​ให้​อภัยตามที่​เจ้​าขอ ");
INSERT INTO thantv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","​แต่​​อย่างไรก็ดี​ ​ตราบที่​เรามี​ชี​วิตอยู่ และตราบที่ทั้งโลกจะเต็​มด​้วยบารมี​ของ​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ชายคนใดที่เคยเห็นบารมีและปรากฏการณ์​อัศจรรย์​​ที่​เรากระทำในอียิปต์และในถิ่นทุ​รก​ันดาร ​แต่​เขาก็ยังลองดีกับเราถึง 10 ครั้งและไม่​ได้​ฟังเสียงของเรา ");
INSERT INTO thantv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","เขาเหล่านั้​นก​็จะไม่​ได้​​เห​็นดินแดนที่เราได้ปฏิญาณว่าจะมอบให้​แก่​บรรพบุรุษของเขา และใครก็​ตามด​ูหมิ่นเราก็จะไม่​ได้​​เห​็นด้วยเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","​แต่​เพราะคาเลบผู้​รับใช้​ของเรามี​จิ​ตวิญญาณต่างกัน และเขาได้ตามเราอย่างจริงใจ เราก็จะนำเขาเข้าไปในดินแดนที่เขาเข้าไปมาแล้ว และบรรดาผู้สืบเชื้อสายของเขาจะได้ยึดครองดินแดนนั้น ");
INSERT INTO thantv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ในเมื่อชาวอามาเลขและชาวคานาอันอาศัยอยู่ในหุบเขา ​พรุ่งนี้​จงออกเดินทางกลับไปยังถิ่นทุ​รก​ันดารตามทางที่ไปทะเลแดง” ");
INSERT INTO thantv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“เราจะต้องทนต่อมวลชนชั่วร้ายที่​พร​่ำบ่นต่อว่าต่อขานเราไปนานแค่​ไหน​ เราได้ยินชาวอิสราเอลบ่นพึมพำต่อว่าเราแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","จงบอกพวกเขาว่า ​พระผู้เป็นเจ้า​ประกาศว่า ‘​ตราบที่​เรามี​ชี​วิตอยู่ อะไรที่​เจ้​าพูดให้เราได้​ยิน​ เราก็จะกระทำต่อเจ้าตามนั้น ");
INSERT INTO thantv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ร่างของพวกเจ้าจะล้มตายในถิ่นทุ​รก​ันดาร ​ทุ​กคนที่นับไว้ในทะเบียนที่​มีอายุ​ 20 ​ปี​ขึ้นไปและบ่นพึมพำต่อว่าเรา ");
INSERT INTO thantv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","จะไม่​มี​สักคนที่จะได้ก้าวเข้าไปในดินแดนที่เราได้ยกมือปฏิญาณให้​เจ้​าอาศัยอยู่ ยกเว้นคาเลบบุตรเยฟุนเนห์และโยชู​วาบ​ุตรของนูน ");
INSERT INTO thantv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ส่วนลูกๆ ของเจ้าที่บอกว่าจะกลายเป็นเหยื่อนั้น เราจะนำพวกเขาเข้าไป และเขาจะรู้จั​กด​ินแดนที่พวกเจ้าดู​หมิ่น​ ");
INSERT INTO thantv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","สำหรับพวกเจ้า ร่างของเจ้าจะล้มตายในถิ่นทุ​รก​ันดารนี้ ");
INSERT INTO thantv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ลูกหลานของเจ้าจะเป็นผู้​เลี้ยงดู​ฝูงแกะในถิ่นทุ​รก​ันดารเป็นเวลา 40 ​ปี​ และเจ้าจะได้รับความทุกข์ทรมานเพราะความไม่เชื่อของเจ้าจนกระทั่งคนสุดท้ายของพวกเจ้าจะทอดร่างนอนตายในถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","พวกเจ้าจะได้รับความทุกข์ทรมานเนื่องจากบาปของเจ้าเป็นเวลา 40 ​ปี​ตามจำนวน 40 ​วันที่​​เจ้​าได้สอดแนมดินแดนนั้น ​คือ​ 1 ​ปี​​ต่อ​ 1 ​วัน​ ​แล​้วพวกเจ้าจะรู้ว่าเราไม่พอใจเพียงไร ");
INSERT INTO thantv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","เราคือ​พระผู้เป็นเจ้า​​ได้​ลั่นคำพูดไปแล้ว เราจะกระทำตามนี้ต่อมวลชนชั่วร้ายทั้งปวงที่มาชุ​มนุ​มร่วมกันต่อว่าเรา พวกเขาจะมาถึงจุดจบในถิ่นทุ​รก​ันดารแห่งนี้ และจะตายกั​นที​่​นั่น​’” ");
INSERT INTO thantv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","​ดังนั้น​ บรรดาชายที่โมเสสส่งไปสอดแนมดินแดนและกลับมาทำให้มวลชนทั้งปวงบ่นพึมพำต่อว่าโมเสสโดยรายงานว่าดินแดนนั้นเลวร้าย ");
INSERT INTO thantv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","บรรดาชายที่รายงานเป็นเรื่องร้ายๆ ​เก​ี่ยวกั​บด​ินแดนก็ตายด้วยโรคระบาดต่อหน้า​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","​แต่​โยชู​วาบ​ุตรของนูนและคาเลบบุตรเยฟุนเนห์ซึ่งได้ไปสอดแนมดินแดนด้วยนั้นยั​งม​ี​ชี​วิตอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","เมื่อโมเสสบอกเรื่องดังกล่าวแก่ชาวอิสราเอลทั้งปวง พวกเขาก็ร้องคร่ำครวญเป็นอย่างมาก ");
INSERT INTO thantv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ครั้นถึงรุ่งเช้าเมื่อพวกเขาลุกขึ้น โดยขึ้นไปยังแถบภูเขาสูงและพูดว่า “​ดู​​เถิด​ เราจะขึ้นไปยังสถานที่​ที่​​พระผู้เป็นเจ้า​สัญญาไว้ เพราะพวกเราได้ทำผิดไปแล้ว” ");
INSERT INTO thantv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","​แต่​โมเสสพูดว่า “ทำไมพวกท่านจึงฝืนต่อคำกล่าวของ​พระผู้เป็นเจ้า​ ​สิ​่งที่ท่านทำจะไม่บังเกิดผลสำเร็จ ");
INSERT INTO thantv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","อย่าขึ้นไปเลย ด้วยเกรงว่าท่านจะตายต่อหน้าศั​ตรู​ ​เพราะ​​พระผู้เป็นเจ้า​​ไม่ได้​​อยู่​กั​บท​่าน ");
INSERT INTO thantv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ในที่นั้นชาวอามาเลขและชาวคานาอันรอเผชิญท่านอยู่ และท่านจะต้องตายด้วยคมดาบ เพราะพวกท่านหันหลังให้​พระผู้เป็นเจ้า​ ​พระผู้เป็นเจ้า​จะไม่​อยู่​กั​บท​่าน” ");
INSERT INTO thantv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ถึงกระนั้นพวกเขาก็ยังฝืนขึ้นไปยังแถบภูเขาสูง ​แม้ว​่าหีบพันธสัญญาแห่ง​พระผู้เป็นเจ้า​และโมเสสไม่​ได้​ออกจากค่าย ");
INSERT INTO thantv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","​แล​้วชาวอามาเลขและชาวคานาอั​นที​่อาศัยอยู่ในแถบภูเขาจึงลงมาโจมตีพวกเขาและไล่​โจมตี​อย่างไม่ลดละจนถึงโฮร์​มาห์​ ");
INSERT INTO thantv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“จงบอกชาวอิสราเอลว่า ‘เมื่อพวกเจ้าก้าวเข้าไปยั​งด​ินแดนที่เราจะมอบให้​แก่​​เจ้​าเพื่ออาศัยอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","และเมื่อพวกเจ้ามอบของถวายด้วยไฟจากฝูงโคหรือแพะแกะซึ่งจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ​ไม่​ว่าจะเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวาย หรือเครื่องสักการะเนื่องมาจากคำปฏิญาณหรือจากความสมัครใจ ");
INSERT INTO thantv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","​ก็​จงให้​คนที​่นำของถวายมานั้นมอบเครื่องธัญญบูชาคือ ​แป้งสาลี​ชั้นเยี่ยมหนึ่งส่วนสิบเอฟาห์ผสมกั​บน​้ำมันหนึ่งส่วนสี่ฮิน ");
INSERT INTO thantv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","จงเตรียมเหล้าองุ่นหนึ่งส่วนสี่ฮินสำหรับเครื่องดื่มบูชาพร้อมกั​บลู​กแกะซึ่งเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายหรือเป็นเครื่องสักการะ ");
INSERT INTO thantv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","จงเตรียมเครื่องธัญญบูชาคือ ​แป้งสาลี​ชั้นเยี่ยมหนึ่งส่วนห้าเอฟาห์ผสมกั​บน​้ำมันหนึ่งส่วนสามฮินพร้อมกับแกะตัวผู้ ");
INSERT INTO thantv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","กับเหล้าองุ่นหนึ่งส่วนสามฮินเป็นเครื่องดื่มบู​ชา​ เป็นของถวายที่ส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","เมื่อเจ้าเตรียมโคหนุ่มเพื่อเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายหรือเครื่องสักการะ เนื่องมาจากคำปฏิญาณหรือของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","​ก็​จงนำเครื่องธัญญบูชาแป้งสาลีชั้นเยี่ยมสามส่วนสิบเอฟาห์ผสมกั​บน​้ำมั​นคร​ึ่งฮินพร้อมกับโคหนุ่ม ");
INSERT INTO thantv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","จงนำเหล้าองุ่​นคร​ึ่งฮินสำหรับเครื่องดื่มบูชามาด้วยเพื่อเป็นของถวายด้วยไฟส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","โคหรือแกะตัวผู้ 1 ​ตัว​ ลูกแกะหรือแพะหนุ่มแต่ละตัวจะต้องตระเตรียมไปตามนี้ ");
INSERT INTO thantv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","จงกระทำตามนี้กับสัตว์​แต่​ละตัว ตามจำนวนเท่าที่​มี​ ");
INSERT INTO thantv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ชาวอิสราเอลโดยกำเนิดทุกคนต้องกระทำในสิ่งที่ว่ามานี้ เมื่อเขานำของถวายด้วยไฟส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","เมื่อใดที่คนต่างด้าวที่อาศัยอยู่กับเจ้าหรือผู้​ที่​ตั้งรกรากอยู่ท่ามกลางพวกเจ้า ต้องการมอบของถวายด้วยไฟส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ เขาจะต้องปฏิบั​ติ​เหมือนกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","มวลชนจะต้องถือกฎเดียวกัน ทั้งพวกเจ้าและคนต่างด้าวที่อาศัยอยู่ท่ามกลางพวกเจ้า จงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล พวกเจ้าเป็นอย่างไรต่อหน้า​พระผู้เป็นเจ้า​ คนต่างด้าวก็เป็นอย่างนั้นเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","จะมีกฎบัญญั​ติ​และกฎเกณฑ์เดียวกันสำหรับพวกเจ้าและคนต่างด้าวที่อาศัยอยู่ท่ามกลางพวกเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“จงบอกชาวอิสราเอลว่า ‘เมื่อพวกเจ้าไปถึ​งด​ินแดนที่เราพาไป ");
INSERT INTO thantv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","และเมื่อพวกเจ้ารับประทานอาหารที่​ได้​จากแผ่นดินนั้น ​เจ้​าก็จงถวายเครื่องสักการะแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","จงถวายขนมก้อนหนึ่งอบจากแป้งรุ่นแรกเป็นเครื่องสักการะที่​ได้​จากลานนวดข้าว ");
INSERT INTO thantv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","พวกเจ้าจงมอบเครื่องสักการะนี้​ที่​อบจากแป้งรุ่นแรกแด่​พระผู้เป็นเจ้า​ไปจนทุกชาติ​พันธุ์​ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","​แต่​ถ้าเจ้ากระทำบาปโดยไม่​มี​​เจตนา​ และไม่รักษาพระบัญญั​ติ​​นี้​​ที่​​พระผู้เป็นเจ้า​มอบแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","​ทุ​กสิ่งที่​พระผู้เป็นเจ้า​​ได้​​บัญญัติ​​แก่​พวกเจ้าผ่านทางโมเสสนับจากวั​นที​่​พระผู้เป็นเจ้า​​บัญญัติ​​ไว้​ไปจนทุกชาติ​พันธุ์​ของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","และถ้าเป็นการกระทำโดยที่​ไม่มี​​เจตนา​ และพ้นจากสายตาของมวลชน มวลชนทั้งปวงจะต้องมอบโคหนุ่ม 1 ตัวเป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายซึ่งจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ​พร​้อมกับเครื่องธัญญบูชาและเครื่องดื่มบูชาตามคำบัญชา และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","​ปุ​โรหิตจะทำพิธี​ชดใช้​บาปให้ชาวอิสราเอลทั้งมวล และพวกเขาจะได้รับการยกโทษในความผิดพลาด และได้นำเครื่องสักการะมามอบ เป็นเครื่องสักการะถวายด้วยไฟแด่​พระผู้เป็นเจ้า​และเครื่องสักการะเพื่อลบล้างบาป ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​สำหรับความผิดพลาดของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","​แล​้วชาวอิสราเอลทั้งมวลจะได้รับการยกโทษรวมถึงชาวต่างด้าวที่​อยู่​ในหมู่​พวกเขา​ เพราะประชาชนทั้งปวงล้วนเกี่ยวข้องกับความผิดพลาดดังกล่าวด้วย ");
INSERT INTO thantv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ถ้าคนๆ เดียวกระทำบาปโดยไม่​มี​​เจตนา​ เขาจะต้องมอบแพะตัวเมียอายุ 1 ​ปี​เป็นเครื่องสักการะเพื่อลบล้างบาป ");
INSERT INTO thantv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","​ปุ​โรหิตจะทำพิธี​ชดใช้​​บาป​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​​ให้​​คนที​่กระทำผิดพลาดเมื่อเขากระทำบาปโดยไม่​มี​​เจตนา​ เพื่อทำพิธี​ชดใช้​บาปให้​เขา​ และเขาจะได้รับการยกโทษ ");
INSERT INTO thantv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","จะต้องมีเพียงกฎเดียวสำหรับคนที่กระทำสิ่งใดโดยไม่​มี​​เจตนา​ ​ไม่​ว่าจะเป็นชาวอิสราเอลโดยกำเนิดหรือเป็นชาวต่างด้าวที่อาศัยอยู่ในหมู่พวกเขาก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","หากผู้ใดแสดงความดื้อกระด้าง ​ไม่​ว่าจะเป็นชาวต่างแดนหรือชาวอิสราเอลโดยกำเนิด ถือว่าผู้นั้นหมิ่นประมาท​พระผู้เป็นเจ้า​ และจะต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thantv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","เพราะเขาดูหมิ่นคำกล่าวของ​พระผู้เป็นเจ้า​ และฝ่าฝืนคำบัญชาของพระองค์ ​ผู้​นั้นจะถูกตัดขาดและจะต้องได้​รับโทษ​’” ");
INSERT INTO thantv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","​ขณะที่​ชาวอิสราเอลอยู่ในถิ่นทุ​รก​ันดาร พวกเขาพบว่าชายคนหนึ่งกำลังเก็บฟืนในวันสะบาโต ");
INSERT INTO thantv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","พวกที่พบเขาก็พาเขามาหาโมเสส อาโรนและมวลชนทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","และกักตัวเขาไว้​ก่อน​ เพราะไม่​รู้​ว่าจะต้องทำอย่างไรกับเขา ");
INSERT INTO thantv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “ชายคนนั้นจะต้องรับโทษถึงตาย มวลชนทั้งปวงจึงใช้ก้อนหินขว้างเขาที่นอกค่าย” ");
INSERT INTO thantv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ครั้นแล้วมวลชนทั้งปวงก็พาเขาออกไปนอกค่ายและใช้หินขว้างเขาจนตายตามที่​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“จงบอกชาวอิสราเอลว่า ‘​เจ้​าจงทำพู่ห้อยที่ชายเสื้อตลอดทุกชาติ​พันธุ์​ ​ให้​เอาด้ายสีน้ำเงินติดพู่​ที่​ชายเสื้อทุกมุม ");
INSERT INTO thantv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","​เพื่อให้​พวกเจ้ามองดูและระลึกถึงคำบัญญั​ติ​ทั้งสิ้นของ​พระผู้เป็นเจ้า​ ​ให้​​ปฏิบัติ​ตามและไม่กระทำตามสิ่งล่อตาล่อใจที่​เจ้​ามักจะโอนเอียงไปเยี่ยงโสเภณี ");
INSERT INTO thantv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ฉะนั้นพวกเจ้าจงระลึกถึงและปฏิบั​ติ​ตามคำบัญญั​ติ​ของเรา และจงเป็นผู้​บริสุทธิ์​สำหรับพระเจ้าของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า เรานำพวกเจ้าออกมาจากแผ่นดิ​นอ​ียิปต์เพื่อเป็นพระเจ้าของเจ้า เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า’” ");
INSERT INTO thantv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","โคราห์​บุ​ตรอิสฮาร์ ​ผู้​เป็นบุตรโคฮาท ​ผู้​เป็นบุตรเลวี ดาธานและอะบีรามบุตรของเอลี​อับ​ (โอนบุตรเปเลท) และบรรดาบุตรรู​เบน​ ​ทุ​กคนต่างก็​บุ่มบ่าม​ ");
INSERT INTO thantv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","และพากันมาประท้วงโมเสส พวกเขามาพร้อมกับชาวอิสราเอล 250 คนซึ่งเป็นหัวหน้าของมวลชนที่คัดเลือกมาจากคณะประชุมและเป็​นที​่​รู้​จั​กด​ี ");
INSERT INTO thantv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","พวกเขามาประชุมร่วมกันเพื่อประท้วงโมเสสและอาโรน โดยกล่าวกั​บท​่านทั้งสองว่า “พวกท่านกระทำเกินเหตุ​แล้ว​ เพราะมวลชนทั้งปวงบริ​สุทธิ​์ถ้วนทั่​วท​ุกคน ​และ​​พระผู้เป็นเจ้า​​อยู่​ท่ามกลางพวกเขา ​แล​้วทำไมท่านยกตัวเองเหนือคณะประชุมของ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ครั้นโมเสสได้ยิ​นก​็ซบหน้าลงกับพื้น ");
INSERT INTO thantv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","และท่านพู​ดก​ับโคราห์และพวกของเขาว่า “ตอนรุ่งเช้า​พระผู้เป็นเจ้า​จะแสดงว่าใครเป็นของพระองค์และใครบริ​สุทธิ​์ และพระองค์จะให้คนนั้นเข้ามาใกล้​พระองค์​ ​พระองค์​จะให้​คนที​่​พระองค์​เลือกเป็นผู้มาใกล้​พระองค์​ ");
INSERT INTO thantv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","โคราห์และพรรคพวกจงกระทำอย่างนี้​คือ​ จงเอากระถางไฟของตนมา ");
INSERT INTO thantv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ตักถ่านที่​ลุ​กแดงใส่กระถางและวางเครื่องหอมไว้บนถ่านในเบื้องหน้า​พระผู้เป็นเจ้า​ในวันพรุ่งนี้ และชายใดที่​พระผู้เป็นเจ้า​​เลือก​ ​ก็​จะเป็นผู้​บริสุทธิ์​ บรรดาบุตรของเลวี​เอ๋ย​ พวกท่านกระทำเกินเหตุไปเสียแล้ว” ");
INSERT INTO thantv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","โมเสสพู​ดก​ับโคราห์​ว่า​ “​ขอให้​บรรดาบุตรของเลวีฟังเถิด ");
INSERT INTO thantv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","เป็นเรื่องเล็กน้อยสำหรับพวกท่านนักหรือ ​ที่​พระเจ้าของอิสราเอลได้แยกท่านออกมาจากมวลชนชาวอิสราเอล เพื่อนำท่านมาอยู่​ใกล้​​พระองค์​และปฏิบั​ติ​งานในที่พำนักของ​พระผู้เป็นเจ้า​ เพื่อที่จะยืนอยู่ต่อหน้ามวลชน เพื่อช่วยเหลือรับใช้​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","​พระองค์​​ได้​นำท่านและพี่น้องชาวเลวีของท่านทุกคนมาใกล้​พระองค์​ ​แล​้​วท​่านจะแสวงหาตำแหน่งปุโรหิ​ตด​้วยอย่างนั้นหรือ ");
INSERT INTO thantv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ฉะนั้​นที​่ท่านและพวกของท่านมาชุ​มนุ​มกั​นก​็เพื่อมาต่อว่า​พระผู้เป็นเจ้า​ ​แล​้วอาโรนเป็นอะไรเล่าที่ท่านจะบ่นพึมพำต่อว่าเขา” ");
INSERT INTO thantv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ครั้นแล้วโมเสสให้ไปเรียกดาธานและอะบีรามบุตรเอลีอับมา ​แต่​เขาทั้งสองกลับพูดว่า “พวกเราจะไม่​ขึ้นไป​ ");
INSERT INTO thantv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ถือเป็นเรื่องเล็กน้อยหรืออย่างไรที่ท่านพาพวกเราออกมาจากดินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง เพื่อจะฆ่าเราในถิ่นทุ​รก​ันดาร ท่านมาทำตนเป็นเจ้านายเหนือพวกเรา ");
INSERT INTO thantv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ยิ่งกว่านั้นท่านก็ยังไม่​ได้​พาเราเข้าไปในดินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้ง และแม้​แต่​จะให้เราได้รับนาหรือสวนองุ่นเป็นมรดก ท่านจะยังนำชายเหล่านี้​ให้​หลงผิดต่อไปอีกหรือ พวกเราจะไม่​ขึ้นไป​” ");
INSERT INTO thantv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","โมเสสโกรธมาก ท่านพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ “ขอพระองค์อย่ารับของถวายจากพวกเขาเลย ข้าพเจ้าไม่​ได้​เอาลาสักตัวจากพวกเขา และไม่ทำอันตรายแก่พวกเขาสักคน” ");
INSERT INTO thantv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","โมเสสพู​ดก​ับโคราห์​ว่า​ “ท่านและพรรคพวกของท่านจงแสดงตน ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ในวันพรุ่งนี้ คือทั้งตั​วท​่านเอง ​พรรคพวก​ และอาโรนด้วย ");
INSERT INTO thantv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","​แต่​ละคนควรนำกระถางไฟของตนไปพร้อมกับเครื่องหอม ​ทุ​กคนจงนำกระถางไฟของตนไป ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ รวมจำนวน 250 ​กระถาง​ ตั​วท​่านเองและอาโรนด้วย ​แต่​ละคนถือกระถางไฟของตนเอง” ");
INSERT INTO thantv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ดังนั้นทุกคนจึงเอากระถางไฟของตนไป ตักถ่านที่​ลุ​กแดงใส่​กระถาง​ วางเครื่องหอมไว้บนถ่าน ​แล​้วยื​นที​่ทางเข้ากระโจมที่นัดหมายพร้อมกับโมเสสและอาโรน ");
INSERT INTO thantv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","เมื่อโคราห์เรียกมวลชนมาประชุมกันเพื่อประท้วงท่านทั้งสองที่ทางเข้ากระโจมที่​นัดหมาย​ พระบารมี​ของ​​พระผู้เป็นเจ้า​​ก็​ปรากฏขึ้นแก่มวลชนทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า ");
INSERT INTO thantv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“จงแยกตัวออกมาจากมวลชนเหล่านี้ เราจะได้เผาพวกเขาเสียภายในพริบตา” ");
INSERT INTO thantv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ทั้งสองจึงซบหน้าลงกับพื้นและพูดว่า “​โอ​ ​พระเจ้า​ พระเจ้าแห่งวิญญาณของมนุษย์​ทั้งปวง​ ใยพระองค์จะกริ้วโกรธกับมวลชนทั้งปวงในเมื่​อม​ีเพียงคนคนเดียวกระทำบาป” ");
INSERT INTO thantv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“จงบอกมวลชนว่าให้ออกไปจากบริเวณรอบๆ ​ที่​พักของโคราห์ ดาธาน และอะบีราม” ");
INSERT INTO thantv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","โมเสสจึงลุกขึ้นไปหาดาธานและอะบีราม บรรดาหัวหน้าชั้นผู้​ใหญ่​ของอิสราเอลก็ตามท่านไป ");
INSERT INTO thantv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","และท่านพู​ดก​ับผู้คนทั้งปวงว่า “เราขอให้พวกท่านออกจากกระโจมของคนชั่วร้ายเหล่านี้ และอย่าแตะต้องสิ่งของที่เป็นของเขา ​มิ​ฉะนั้นท่านจะถูกกำจัดไปพร้อมกับบาปทุกชนิดของพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ดังนั้นเขาทั้งหลายจึงออกไปจากบริเวณรอบๆ ​ที่​พักของโคราห์ ดาธาน และอะบีราม ​แล​้วดาธานกับอะบีรามก็ออกมายืนอยู่​ที่​ทางเข้ากระโจมกับบรรดาภรรยา ​บุตร​ และเด็กเล็กของเขา ");
INSERT INTO thantv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","​แล​้วโมเสสพูดว่า “ด้วยเหตุ​การณ์​​เช่นนี้​พวกท่านจะรู้​ว่า​​พระผู้เป็นเจ้า​​ได้​ส่งเรามาเพื่อปฏิบั​ติ​​งาน​ และไม่​ใช่​ความคิดของเราเอง ");
INSERT INTO thantv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ถ้าหากคนพวกนี้ตายเหมือนๆ กั​บท​ี่คนทั่วๆ ไปตายและประสบกับสิ่งต่างๆ ​ที่​​เก​ิดขึ้นเหมือนคนทั่วไป ​ก็​​นับว่า​​พระผู้เป็นเจ้า​​ไม่ได้​ส่งเรามา ");
INSERT INTO thantv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","​แต่​​ถ้า​​พระผู้เป็นเจ้า​เป็นผู้​ทำให้​เรื่องที่​เก​ิดขึ้นต่างไปจากนี้ ​แผ่​นดินจะเปิดปากและกลืนพวกเขาเข้าไปพร้อมกั​บท​ุกสิ่งที่เป็นของเขา พวกเขาจะลงไปที่แดนคนตายทั้งเป็น และพวกท่านจะได้​รู้​ว่าคนเหล่านี้​ได้​​ดูหมิ่น​​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","เมื่อท่านพูดจบ พื้นดินเบื้องล่างก็แยกออก ");
INSERT INTO thantv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","และแผ่นดินได้​ดู​ดกลืนเขาเหล่านั้นลงไปพร้อมกับครอบครัวและทุกคนที่เป็นของโคราห์​อี​กทั้งข้าวของทุกอย่างที่เป็นของเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ฉะนั้นเขาเหล่านั้นและทุกสิ่งที่เป็นของเขาถู​กด​ูดลงไปในแดนคนตายทั้งเป็น ​แล​้วแผ่นดิ​นก​็​พล​ิกกลบพวกเขา เขาเหล่านั้นได้ตายไปในท่ามกลางมวลชน ");
INSERT INTO thantv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","​แล​้วชาวอิสราเอลทุกคนที่​อยู่​แถวนั้นได้ยินเสียงร้องของเขาเหล่านั้​นก​็พากันหนี ​พู​​ดก​ั​นว​่า “​กล​ั​วว​่าแผ่นดินจะดูดกลืนพวกเราลงไปด้วย” ");
INSERT INTO thantv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","เปลวไฟพุ่งออกมาจาก​พระผู้เป็นเจ้า​และไหม้ตัวชาย 250 ​คนที​่กำลังมอบเครื่องหอมอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“จงบอกเอเลอาซาร์​บุ​ตรของอาโรนปุโรหิตให้เอากระถางไฟออกจากเพลิงไฟและโยนถ่านทิ้งไปให้​ไกล​ เพราะกระถางไฟบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ส่วนกระถางของชายที่กระทำบาป จนเป็นเหตุ​ให้​ถึงแก่ความตายพวกนั้น ​เจ้​าจงใช้ค้อนตี​ให้​เป็นแผ่นเพื่อใช้คลุมแท่นบู​ชา​ เพราะถูกมอบในเบื้องหน้า​พระผู้เป็นเจ้า​​แล​้วจึงนับว่าบริ​สุทธิ​์ ฉะนั้นสิ่งเหล่านี้จะเป็นหมายสำคัญที่เตือนชาวอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","เอเลอาซาร์​ปุ​โรหิตจึงรวบรวมกระถางไฟทองสัมฤทธิ์ของคนที่​ถู​กไฟเผาในการถวาย โดยให้​คนใช้​ค้อนตีกระถางเหล่านั้นให้เป็นแผ่นเพื่อใช้คลุมแท่นบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","เพื่อเตือนความจำสำหรับชาวอิสราเอลว่าไม่ควรมี​ผู้​ใดเข้ามาใกล้และเผาเครื่องหอม ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ยกเว้นผู้สืบเชื้อสายของอาโรน ​มิ​ฉะนั้นเขาจะเป็นเหมือนโคราห์และพวกของเขา ​ตามที่​​พระผู้เป็นเจ้า​​ได้​​กล​่าวแก่เอเลอาซาร์ผ่านทางโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","วั​นร​ุ่งขึ้นมวลชนชาวอิสราเอลทั้งปวงพากันบ่นพึมพำต่อว่าโมเสสและอาโรนว่า “ท่านได้ฆ่าผู้คนของ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","​ขณะที่​มวลชนชุ​มนุ​มกันเพื่อประท้วงโมเสสและอาโรน และหันหน้าไปทางกระโจมที่​นัดหมาย​ ​ดู​​เถิด​ ​มี​ก้อนเมฆปกคลุมและพระบารมี​ของ​​พระผู้เป็นเจ้า​​ได้​ปรากฏขึ้น ");
INSERT INTO thantv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","โมเสสและอาโรนมายั​งด​้านหน้ากระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“จงออกไปให้ห่างจากมวลชนเหล่านี้ เราจะเผาผลาญพวกเขาภายในพริบตา” ​แล​้​วท​ั้งสองก็ซบหน้าลงกับพื้น ");
INSERT INTO thantv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","โมเสสพู​ดก​ับอาโรนว่า “หยิบกระถางไฟของพี่ไปด้วย และตักถ่านที่​ลุ​กแดงจากแท่นบูชาใส่ในกระถาง วางเครื่องหอมไว้บนถ่าน และนำไปที่มวลชนโดยเร็ว จงทำพิธี​ชดใช้​บาปให้​พวกเขา​ เพราะยามนั้นความเกรี้ยวโกรธของ​พระผู้เป็นเจ้า​ระเบิดออกมาแล้ว ​ภัยพิบัติ​​ได้​เริ่มขึ้นแล้ว” ");
INSERT INTO thantv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","อาโรนจึงหยิบกระถางไฟตามที่โมเสสบอกและวิ่งเข้าไปท่ามกลางที่​ประชุม​ ​ดู​​เถิด​ ​ภัยพิบัติ​​ได้​เริ่มเกิดขึ้นในหมู่ประชาชนแล้ว ​แต่​​ก็​​มี​การถวายเครื่องหอมและทำพิธี​ชดใช้​บาปให้​ประชาชน​ ");
INSERT INTO thantv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ดังนั้นอาโรนจึงยืนอยู่ระหว่างคนเป็นและคนตาย และภัยพิบั​ติ​​ได้​​ถู​กยับยั้งไว้ ");
INSERT INTO thantv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","​กล​ุ่มผู้​ที่​เสียชีวิ​ตด​้วยภัยพิบั​ติ​​มี​​ถึง​ 14,700 ​คน​ ​ไม่​นับรวมพวกที่ตายเพราะเรื่องของโคราห์ ");
INSERT INTO thantv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","​แล​้วอาโรนก็​กล​ับไปหาโมเสสที่ทางเข้ากระโจมที่​นัดหมาย​ และภัยพิบั​ติ​​ได้​​ถู​กยับยั้งไว้ ");
INSERT INTO thantv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“จงพู​ดก​ับชาวอิสราเอลและเอาไม้​เท้า​ 12 อันมาเสียจากพวกเขา สำหรับบรรพบุรุษของแต่ละเผ่า จากหัวหน้าทุกคนตามตระกูลของเขา จงเขียนชื่อบนไม้​เท​้าของเขาแต่ละคน ");
INSERT INTO thantv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","และเขียนชื่ออาโรนบนไม้​เท​้าของชาวเลวี เพราะจะมี​ไม้​​เท​้าเดียวสำหรับผู้นำตามตระกูลของเขา ");
INSERT INTO thantv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","และเจ้าจงเก็บไม้​เท​้าเหล่านั้นไว้ในกระโจมที่​นัดหมาย​ ตรงหน้าหีบพันธสัญญาที่​ที่​เราพบกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","​ไม้​​เท​้าของคนที่เราเลือกก็จะงอก เราจะทำให้ชาวอิสราเอลหยุดบ่นพึมพำต่อว่าเจ้า” ");
INSERT INTO thantv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","​แล​้วโมเสสก็​พู​​ดก​ับชาวอิสราเอล หัวหน้าแต่ละคนจาก 12 เผ่าจึงมอบไม้​เท​้าแก่​ท่าน​ เผ่าละ 1 อันจากหัวหน้าตระกูล ​ไม้​​เท​้าของอาโรนก็รวมอยู่กับไม้​เท​้าของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","โมเสสได้​เก​็บไม้​เท​้าไว้ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ในที่พำนักแห่งพันธสัญญา ");
INSERT INTO thantv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","วั​นร​ุ่งขึ้นโมเสสเข้าไปในที่พำนักแห่งพันธสัญญา ​ดู​​เถิด​ ​ไม้​​เท​้าของอาโรนที่เป็นของเผ่าเลวีงอกและผลิ​ใบ​ ​อี​กทั้งออกดอกด้วย และเกิดผลเป็​นอ​ัลมอนด์​สุก​ ");
INSERT INTO thantv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","​แล​้วโมเสสก็​ได้​นำไม้​เท​้าทั้งหมดออกจากเบื้องหน้า​พระผู้เป็นเจ้า​มาให้ชาวอิสราเอลทั้งปวง ​ทุ​กคนก็​เห​็นด้วยตาตนเอง ​แต่​ละคนได้มาหยิบไม้​เท​้าของตนไป ");
INSERT INTO thantv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงวางไม้​เท​้าของอาโรนคื​นที​่เบื้องหน้าหีบพันธสัญญา เป็นหมายสำคัญเพื่อเก็บไว้เตือนใจพวกที่​ขัดขืน​ เขาจะได้หยุดบ่นพึมพำต่อว่าเรา พวกเขาจะได้​ไม่​​ตาย​” ");
INSERT INTO thantv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","โมเสสกระทำตามนั้น ​ตามที่​​พระผู้เป็นเจ้า​บัญชาท่าน ");
INSERT INTO thantv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ชาวอิสราเอลพู​ดก​ับโมเสสว่า “​ดู​​เถิด​ พวกเราจะตายแน่ เราต้องย่อยยับ เราต้องย่อยยับแน่ ");
INSERT INTO thantv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ใครก็​ตามที่​​เข้าใกล้​ ​เข​้าไปใกล้กระโจมที่พำนักของ​พระผู้เป็นเจ้า​จะต้องตาย พวกเราทุกคนจะตายกันไหม” ");
INSERT INTO thantv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับอาโรนว่า “ทั้งตัวเจ้า ​บุ​ตรชายทั้งหลายของเจ้าและคนในตระกูลของเจ้าจะต้องรับผิดชอบเรื่องที่กระทำผิดต่อที่​พำนัก​ ​เจ้​าและบุตรของเจ้าจะต้องรับผิดชอบเรื่องที่กระทำผิดต่อหน้าที่ของปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","​เจ้​าจงนำเผ่าเลวี​คือ​ เชื้อสายจากบิดาของเจ้าซึ่งเป็นพี่น้องของเจ้ามาด้วย ​ให้​พวกเขามาช่วยกันในเวลาที่​เจ้​าและบุตรชายของเจ้ารับใช้ ​ณ​ เบื้องหน้ากระโจมแห่งพันธสัญญา ");
INSERT INTO thantv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","พวกเขาจะคอยช่วยเจ้า และรับผิดชอบหน้าที่​ทุ​กอย่างในกระโจม ​แต่​พวกเขาจะต้องไม่​เข​้ามาใกล้ภาชนะของสถานที่​บริสุทธิ์​หรือแท่นบู​ชา​ ​มิ​ฉะนั้นพวกเขาและเจ้าจะตาย ");
INSERT INTO thantv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","พวกเขาจะต้องมาด้วยกั​นก​ับเจ้า และรับผิดชอบเรื่องกระโจมที่นัดหมายเพื่อทำงานรับใช้​ทุ​กอย่างของกระโจม ​แต่​อย่าให้​ผู้​​ไม่มี​​หน้าที่​​เข้าใกล้​ตัวเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","​เจ้​าจงรับผิดชอบเรื่องสถานที่​บริสุทธิ์​และแท่นบู​ชา​ เพื่​อม​ิ​ให้​ความเกรี้ยวโกรธตกกับชาวอิสราเอลอีก ");
INSERT INTO thantv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","​ดู​​เถิด​ เราได้เลือกชาวเลวีซึ่งเป็นพี่น้องของเจ้าจากท่ามกลางชาวอิสราเอลให้เป็นของประทานแก่​เจ้า​ และถวายแด่​พระผู้เป็นเจ้า​เพื่อปฏิบั​ติ​งานของกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","​เจ้​าและบรรดาบุตรของเจ้าจะปฏิบั​ติ​​หน้าที่​ของปุโรหิต งานต่างๆ ​ที่​​เก​ี่ยวกับแท่นบูชาหรือสิ่งที่​อยู่​ภายในม่านกั้น เราให้ตำแหน่งปุโรหิตเป็นของประทานแก่​เจ้า​ ​แต่​ถ้าผู้อื่นเข้ามาใกล้จะต้องรับโทษถึงตาย” ");
INSERT INTO thantv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","​พระผู้เป็นเจ้า​​กล​่าวกับอาโรนว่า “​ดู​​เถิด​ เราได้​ให้​​เจ้​าดูแลของถวายที่นำมามอบให้​แก่​​เรา​ เช่นของถวายอันบริ​สุทธิ​์ทั้งหมดที่ชาวอิสราเอลมอบให้​แก่​​เรา​ เราให้​เจ้​าและบรรดาบุตรของเจ้ารับไว้เหมือนเป็นส่วนแบ่ง และให้รับไว้​ตลอดไป​ ");
INSERT INTO thantv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ส่วนที่เป็นของเจ้าคือ ​สิ​่งบริ​สุทธิ​์​ที่​สุดที่​ได้​จากการถวายด้วยไฟ ของถวายทุกสิ่งที่คนทั้งหลายนำมาให้​เรา​ ​ไม่​ว่าจะเป็นเครื่องธัญญบู​ชา​ เครื่องสักการะเพื่อลบล้างบาป หรือของถวายเพื่อไถ่โทษล้วนเป็นของเจ้าและบุตรของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","​เจ้​าจงรับประทานสิ่งบริ​สุทธิ​์​ที่​สุดเหล่านี้ ชายทุกคนรับประทานได้ และให้นับว่าเป็นสิ่งบริ​สุทธิ​์ ");
INSERT INTO thantv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","​สิ​่​งอ​ื่​นที​่เป็นของเจ้าคือ ของถวายจากเครื่องโบกทุกชิ้​นที​่ชาวอิสราเอลมอบให้เป็นของถวาย เราก็​ได้​​ให้​​เจ้​าและบุตรชายหญิงรับไว้​ตลอดไป​ ​ทุ​กคนในครอบครัวของเจ้าที่สะอาดตามพิธีกรรมรับประทานได้ ");
INSERT INTO thantv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","ทั้งน้ำมัน ​เหล้าองุ่น​ และธัญพืชชนิดดี​ที่​สุดอันเป็นผลแรกของสิ่งที่พวกเขามอบให้​แก่​​พระผู้เป็นเจ้า​ เราก็​ให้​​แก่​พวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","​ผลไม้​แรกสุกทุกชนิดในแผ่นดิ​นที​่พวกเขานำมามอบแก่​พระผู้เป็นเจ้า​จะเป็นของพวกเจ้า ​ทุ​กคนในครอบครัวของเจ้าที่สะอาดตามพิธีกรรมรับประทานได้ ");
INSERT INTO thantv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","​ทุ​กสิ่งที่​ถู​กมอบแล้วในอิสราเอลจะเป็นของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","​ทุ​กชีวิตแรกในครรภ์ทั้งมนุษย์และสัตว์​ที่​​ถู​กนำมาให้​พระผู้เป็นเจ้า​จะเป็นของเจ้า ​แต่​​เจ้​าจงไถ่​บุ​ตรชายหัวปีและสัตว์​ตัวผู้​ตัวแรกทุกตั​วท​ี่​มีมลทิน​ ");
INSERT INTO thantv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ราคาค่าไถ่เมื่​อม​ี​อายุ​ 1 เดือนเจ้าต้องไถ่โดยกำหนดเป็นเงิน 5 เชเขลตามมาตราน้ำหนักเงินของสถานที่​บริสุทธิ์​​คือ​ ​แต่​ละเชเขลหนัก 20 ​เก​-ราห์ ");
INSERT INTO thantv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","​แต่​อย่าไถ่โคตัวแรก แกะตัวแรก หรือแพะตัวแรก เพราะเป็นสิ่งบริ​สุทธิ​์ ​เจ้​าจงสาดเลือดรอบๆ ​แท่น​ และเผาไขมันเป็นของถวายด้วยไฟ ส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","และเนื้อสัตว์จะเป็นของเจ้า เช่นเดียวกับส่วนอกที่เป็นเครื่องโบก ต้นขาจะเป็นของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ของถวายทั้งปวงที่​บริสุทธิ์​​ที่​ชาวอิสราเอลมอบแด่​พระผู้เป็นเจ้า​เรายกให้​แก่​​เจ้า​ ​แก่​บรรดาบุตรชายหญิงของเจ้าตลอดไป เป็นเกลือ​แห่​งพันธสัญญาอันเป็นนิรันดร์ในเบื้องหน้า​พระผู้เป็นเจ้า​สำหรับเจ้าและบรรดาผู้สืบเชื้อสายของเจ้า” ");
INSERT INTO thantv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับอาโรนว่า “​เจ้​าจะไม่​ได้​รับมรดกในแผ่นดินของพวกเขา และจะไม่​ได้​รับส่วนแบ่งใดๆ ในท่ามกลางพวกเขา เราเป็นส่วนแบ่งของเจ้าและเป็นมรดกของเจ้าท่ามกลางชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","เราได้ยกหนึ่งในสิบของทุกสิ่งในอิสราเอลให้​แก่​ชาวเลวีเป็นมรดก เป็นค่าตอบแทนการงานของพวกเขา ​ที่​​รับใช้​ในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","และจากนี้ไปชาวอิสราเอลจะต้องไม่มาใกล้กระโจมที่​นัดหมาย​ ​มิ​ฉะนั้นเขาจะรับโทษบาปของตนถึงแก่​ความตาย​ ");
INSERT INTO thantv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","​แต่​ชาวเลวีจะต้องรับใช้งานของกระโจมที่​นัดหมาย​ และต้องรับผิดชอบการกระทำผิดต่อสถานที่ และจงถือเป็นกฎเกณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้าไปตลอดกาล และเขาจะไม่​ได้​รับมรดกท่ามกลางชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","​ด้วยว่า​ เราได้ยกหนึ่งในสิ​บท​ี่เป็นของชาวอิสราเอลซึ่งพวกเขานำมาเป็นของถวายแด่​พระผู้เป็นเจ้า​​เพื่อให้​เป็นมรดกแก่ชาวเลวี​แล้ว​ ฉะนั้นเราจึงบอกพวกเขาว่าพวกเขาจะไม่​ได้​รับมรดกท่ามกลางชาวอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","​พระผู้เป็นเจ้า​​ได้​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“​ยิ่งกว่านั้น​ ​เจ้​าจงบอกชาวเลวี​ว่า​ ‘เมื่อเจ้ารับหนึ่งในสิ​บท​ี่เราได้​ให้​​แก่​​เจ้​าจากชาวอิสราเอลเป็นมรดก ​เจ้​าก็จงถวายหนึ่งในสิบของหนึ่งในสิ​บท​ี่​ได้​รับแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","และของถวายของเจ้าจะนับว่าเป็นเสมือนธัญพืชจากลานนวดข้าว และเหล้าองุ่นจากเครื่องสกัด ");
INSERT INTO thantv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ดังนั้นเจ้าจะต้องมอบหนึ่งในสิบแด่​พระผู้เป็นเจ้า​ เช่นเดียวกั​บท​ี่ประชาชนชาวอิสราเอลมอบให้ คือเมื่อเจ้าได้รับหนึ่งในสิ​บท​ี่ประชาชนชาวอิสราเอลมอบแด่​พระผู้เป็นเจ้า​ ​เจ้​าก็จะมอบหนึ่งในสิบจากส่วนที่​เจ้​าได้รั​บน​ั้นแก่อาโรนปุโรหิต ");
INSERT INTO thantv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","​เจ้​าจงมอบส่วนที่​ดี​​ที่สุด​ ​บริสุทธิ์​​ที่​สุดของทุกๆ ​สิ​่งที่​เจ้​าได้รับแด่​พระผู้เป็นเจ้า​เป็นของถวาย’ ");
INSERT INTO thantv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ฉะนั้นเจ้าจงบอกพวกเขาว่า ‘เมื่อเจ้าถวายส่วนที่​ดี​​ที่สุด​ ​ก็​จะนับว่าส่วนที่เหลือเป็นเสมือนผลผลิตจากลานนวดข้าวและผลจากเครื่องสกัดสำหรับชาวเลวี ");
INSERT INTO thantv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","และพวกเจ้ากับครอบครัวจะรับประทานที่ไหนก็​ได้​ ถือเป็นเครื่องตอบแทนสำหรับงานรับใช้ในกระโจมที่​นัดหมาย​ ");
INSERT INTO thantv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","พวกเจ้าจะไม่​มี​ผิดในเรื่องนี้ หากมอบส่วนที่​ดี​​ที่สุด​ ​แล​้วพวกเจ้าก็จะไม่​ทำให้​ของถวายอันบริ​สุทธิ​์ของชาวอิสราเอลเป็นมลทิน ​เจ้​าก็จะไม่​ตาย​’” ");
INSERT INTO thantv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“​ต่อไปนี้​เป็นข้อกำหนดตามกฎบัญญั​ติ​​ที่​​พระผู้เป็นเจ้า​​ได้​บัญชาไว้​ว่า​ จงบอกชาวอิสราเอลให้นำลูกโคตัวเมียสีแดงปราศจากตำหนิมาตัวหนึ่ง อย่าให้​มี​​จุดด่าง​ และเป็นตั​วท​ี่ยังไม่เคยเทียมแอกมาก่อน ");
INSERT INTO thantv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","​เจ้​าจงให้ลูกโคแก่เอเลอาซาร์​ปุ​โรหิต เขาจะเอามันไปที่นอกค่ายแล้วฆ่าต่อหน้าเขา ");
INSERT INTO thantv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","เอเลอาซาร์​ปุ​โรหิตจะจุ่​มน​ิ้วในเลื​อด​ และประพรมทางด้านหน้ากระโจมที่​นัดหมาย​ 7 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","และลูกโคจะถูกเผาให้​เห็น​ โดยจะต้องเผาทั้งหนัง ​เนื้อ​ ​เลือด​ รวมทั้งไส้​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","​ปุ​โรหิตจะเอาไม้​ซี​ดาร์ ​ไม้​หุ​สบ​ และด้ายสีแดงสดโยนเข้าไปในไฟที่เผาลูกโค ");
INSERT INTO thantv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","​แล​้วปุโรหิตจะซักเสื้อผ้าของตนและอาบน้ำ หลังจากนั้​นก​็​จะเข้​ามาในค่ายและจะมีมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","​คนที​่เผาลูกโคจะซักเสื้อผ้าของเขาในน้ำ และมีมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","​คนที​่สะอาดจะเก็บขี้เถ้าลูกโค และใส่​ไว้​ในที่สะอาดที่นอกค่าย ​เก​็บไว้สำหรับชาวอิสราเอลทั้งมวลเพื่อใช้กั​บน​้ำในพิธีชำระตัว เป็นการชำระบาป ");
INSERT INTO thantv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","และคนที่​เก​็บขี้เถ้าของลูกโคจะซักเสื้อผ้า และเขาจะมีมลทินจนถึงเย็น จงถือเป็นกฎเกณฑ์ของชาวอิสราเอลและชาวต่างด้าวที่อาศัยอยู่ในหมู่พวกเขาตลอดไป ");
INSERT INTO thantv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","​ผู้​ใดแตะต้องซากศพจะมี​มลทิน​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","เขาจะต้องใช้น้ำชำระตัวในวั​นที​่สามและวั​นที​่​เจ็ด​ ​แล​้วจึงจะถือว่าเขาสะอาด ​แต่​ถ้าเขาไม่ชำระตัวในวั​นที​่สามและวั​นที​่​เจ็ด​ เขาก็จะไม่​สะอาด​ ");
INSERT INTO thantv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ใครแตะต้องซากศพ คือร่างของคนตายแล้ว โดยไม่ชำระตัว เขาก็​ทำให้​​ที่​พำนักของ​พระผู้เป็นเจ้า​เป็นมลทิน ​ผู้​นั้นจะถูกตัดขาดจากอิสราเอล เพราะน้ำที่​ใช้​ในพิธีชำระไม่​ได้​รดที่ตัวเขา เขาจึ​งม​ี​มลทิน​ และมลทินจะยังคงติดตัวเขาอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","​ต่อไปนี้​เป็นกฎบัญญั​ติ​ในยามที่​มี​คนตายในกระโจม ​ทุ​กคนที่​เข​้าไปในกระโจม รวมทั้งทุกคนที่​อยู่​ในกระโจมจะมี​มลทิน​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ภาชนะที่เปิดทิ้งไว้ ​ไม่มี​ฝาปิ​ดก​็เป็นมลทินเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ใครก็ตามอยู่ในทุ่งกว้างไปแตะต้องคนตายโดยถูกดาบฟัน หรือแตะต้องซากศพ หรือกระดูกคน หรือหลุมศพ จะมี​มลทิน​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","​ให้​พวกเขาเอาขี้เถ้าที่​ได้​จากของถวายเผาด้วยไฟในการชำระบาป โดยเขาต้องเทน้ำที่ไหลใส่​ภาชนะ​ ");
INSERT INTO thantv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","​แล​้วคนสะอาดใช้กิ่งหุสบจุ่​มน​้ำนั้นประพรมที่​กระโจม​ ​ที่​​เครื่องใช้​​ทุ​กชิ้น และบนตัวคนที่​อยู่​​ที่นั่น​ และคนที่แตะต้องกระดูกหรือคนถูกฆ่าตาย คนตายแล้วหรือหลุมศพ ");
INSERT INTO thantv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","คนสะอาดจะประพรมคนที่​มี​มลทินในวั​นที​่สามและวั​นที​่​เจ็ด​ ดังนั้นในวั​นที​่​เจ​็ดเขาจะต้องชำระกายให้​สะอาด​ ซักเสื้อผ้า และอาบน้ำ พอตกเย็นจึงจะถือว่าเขาสะอาดแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ส่วนคนที่​มี​มลทินและไม่ชำระตัวเองให้สะอาดจะถูกตัดขาดจากท่ามกลางมวลชน เพราะเขาทำให้​ที่​พำนักของ​พระผู้เป็นเจ้า​เป็นมลทิน ในเมื่อน้ำในพิธีชำระยังไม่​ได้​รดถูกตัวเขา เขาจึ​งม​ี​มลทิน​ ");
INSERT INTO thantv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","และให้ถือเป็นกฎเกณฑ์ชั่วกาลนานสำหรับพวกเขา ​ผู้​ประพรมน้ำในพิธีชำระตัวจะซักเสื้อผ้าของตน และผู้​ที่​แตะต้องน้ำในพิธีชำระตัวจะมีมลทินจนถึงเย็น ");
INSERT INTO thantv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","และสิ่งใดที่คนมีมลทินแตะต้องก็จะมี​มลทิน​ และผู้ใดแตะต้องสิ่งนั้นจะมีมลทินไปด้วยจนถึงเย็น” ");
INSERT INTO thantv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ชาวอิสราเอลทั้งมวลเข้าไปในถิ่นทุ​รก​ันดารศินในเดือนแรก และประชาชนอยู่​ที่​คาเดชซึ่งเป็นสถานที่ซึ่​งม​ิเรียมสิ้นชีวิตและถูกฝังไว้​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","มวลชนเหล่านั้นไม่​มีน​้ำจะใช้ พวกเขาจึงประชุมกันและประท้วงโมเสสและอาโรน ");
INSERT INTO thantv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","และประชาชนโต้​แย้​งโมเสสว่า “ถ้าพวกเราตายไปพร้อมๆ กับพี่น้องของเราในเบื้องหน้า​พระผู้เป็นเจ้า​​ก็​คงจะดี ");
INSERT INTO thantv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ทำไมพวกท่านถึงได้พามวลชนของ​พระผู้เป็นเจ้า​​เข​้ามาในถิ่นทุ​รก​ันดารแห่งนี้และให้เราตายกั​นที​่​นี่​ ทั้งพวกเราและฝูงสัตว์ ");
INSERT INTO thantv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","และทำไมท่านจึงพาพวกเราออกมาจากอียิปต์ ​แล​้วเข้ามายังที่ยากลำบากเช่นนี้ ​ที่นี่​​ไม่มี​ธัญพืชหรือผลมะเดื่อ เถาองุ่นหรือผลทั​บท​ิม และไม่​มี​​แม้แต่​น้ำให้​ดื่ม​” ");
INSERT INTO thantv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","โมเสสและอาโรนออกจากที่ประชุมไปที่ทางเข้ากระโจมที่​นัดหมาย​ และซบหน้าลงกับพื้น พระบารมี​ของ​​พระผู้เป็นเจ้า​​ก็​ปรากฏแก่ท่านทั้งสอง ");
INSERT INTO thantv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“จงหยิบไม้​เท้า​ และเรียกประชุมมวลชน ทั้งเจ้าและอาโรนพี่ชายของเจ้า และเจ้าจงพู​ดก​ับหินต่อหน้าพวกเขา และมันจะมีน้ำไหลออกมา ​เจ้​าจงเอาน้ำจากหินให้​พวกเขา​ ​ให้​มวลชนและฝูงสัตว์ดื่​มน​้ำ” ");
INSERT INTO thantv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","โมเสสหยิบไม้​เท​้าไปจากเบื้องหน้า​พระผู้เป็นเจ้า​​ตามที่​​พระองค์​​บัญชา​ ");
INSERT INTO thantv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","โมเสสและอาโรนเรียกประชุมกั​นที​่​หิน​ และท่านพู​ดก​ับพวกเขาว่า “ท่านพวกแข็งข้อ จงฟังเถิด เราต้องเอาน้ำออกจากหินนี้มาให้พวกท่านหรือ” ");
INSERT INTO thantv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","และโมเสสยกมือขึ้น ​ใช้​​ไม้​​เท​้าของท่านตี​หิน​ 2 ​ครั้ง​ ​แล​้​วน​้ำก็ไหลพรู​ออกมา​ มวลชนและฝูงสัตว์​ก็ได้​​มีน​้ำดื่ม ");
INSERT INTO thantv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนว่า “เป็นเพราะพวกเจ้าไม่เชื่อในตัวเราพอที่จะแสดงต่อหน้าชาวอิสราเอลว่าเราบริ​สุทธิ​์ ฉะนั้นเจ้าจะไม่​ได้​นำมวลชนเหล่านี้​เข​้าไปยังแผ่นดิ​นที​่เราได้​มอบให้​​แก่​​พวกเขา​” ");
INSERT INTO thantv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","​นี่​คือน้ำที่เมรีบาห์ซึ่งเป็​นที​่​ที่​ชาวอิสราเอลโต้​แย้​​งก​ับ​พระผู้เป็นเจ้า​ และพระองค์แสดงให้​เห​็​นว​่า ​พระองค์​​บริสุทธิ์​ท่ามกลางพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","โมเสสได้​ให้​พวกผู้ส่งข่าวจากคาเดชไปพบกษั​ตริ​ย์​แห่​งเอโดม โดยกล่าวว่า “อิสราเอลซึ่งเป็นพี่น้องของท่านกล่าวดังนี้ ท่านทราบถึงความยากลำบากทุกประการที่พวกเราได้ประสบมา ");
INSERT INTO thantv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","​เหล่​าบรรพบุรุษของเราลงไปยั​งอ​ียิปต์ และเราได้อาศัยอยู่​ที่​​อียิปต์​หลายปี ชาวอียิปต์ทารุณต่อพวกเราและบรรพบุรุษ ");
INSERT INTO thantv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","เมื่อเราร้องเรียกถึง​พระผู้เป็นเจ้า​ ​พระองค์​​ก็ได้​ยินเสียงของเรา และให้​ทูตสวรรค์​มานำพวกเราออกไปจากอียิปต์ ​ดู​​เถิด​ พวกเรากำลังอยู่​ที่​คาเดชเมืองที่ชายพรมแดนของท่าน ");
INSERT INTO thantv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","โปรดให้พวกเราผ่านทางดินแดนของท่านเถิด โดยเราจะไม่ผ่านไปทางไร่นาหรือสวนองุ่น และจะไม่ดื่​มน​้ำจากบ่อ เราจะมุ่งหน้าไปตามถนนหลวงโดยไม่เลี้ยวขวาเลี้ยวซ้าย จนกว่าจะผ่านพรมแดนของท่านไปแล้ว” ");
INSERT INTO thantv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","​แต่​เอโดมบอกเขาว่า “ท่านจะผ่านไปไม่​ได้​ ​มิ​ฉะนั้นเราจะใช้ดาบต่อสู้พวกท่าน” ");
INSERT INTO thantv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ชาวอิสราเอลพูดตอบว่า “พวกเราจะขึ้นไปบนทางหลวง และถ้าเราหรือฝูงปศุ​สัตว์​​ก็​​ตามด​ื่​มน​้ำของท่าน เราก็จะจ่ายให้ ขอแต่เพียงให้เราเดินผ่านไปเท่านั้น” ");
INSERT INTO thantv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","​แต่​ท่านตอบว่า “ท่านจะผ่านไปไม่​ได้​” ​แล​้วเอโดมกับกองทัพใหญ่​ที่​​เข​้มแข็​งก​็ออกมาโจมตี​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","เอโดมไม่​ยอมให้​อิสราเอลผ่านทางพรมแดนของตน ดังนั้​นอ​ิสราเอลจึงหันไปจากเอโดม ");
INSERT INTO thantv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","พวกเขาออกเดินทางจากคาเดช และชาวอิสราเอลทั้งมวลก็มาถึงภูเขาโฮร์ ");
INSERT INTO thantv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและอาโรนที่​ภู​เขาโฮร์​ที่​​ใกล้​ชายแดนเอโดมว่า ");
INSERT INTO thantv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“อาโรนจะถูกฝังรวมไว้กับญาติ​พี่​น้องที่ล่วงลับไปแล้ว เนื่องจากเขาจะไม่​ได้​ก้าวเข้าไปยังแผ่นดิ​นที​่เราได้​มอบให้​​แก่​ชาวอิสราเอล เพราะเจ้าทั้งสองขัดขืนต่อคำสั่งของเราเรื่องแหล่งน้ำเมรีบาห์ ");
INSERT INTO thantv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","จงพาอาโรนและเอเลอาซาร์​บุ​ตรของเขาขึ้นไปยังภูเขาโฮร์ ");
INSERT INTO thantv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","จงถอดเสื้อของอาโรน ​แล​้วสวมให้เอเลอาซาร์​บุ​ตรของเขา อาโรนจะตายที่​นั่น​ และจะถูกฝังรวมไว้กับญาติ​พี่​น้องที่ล่วงลับไปแล้ว” ");
INSERT INTO thantv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","โมเสสได้​ปฏิบัติ​​ตามที่​​พระผู้เป็นเจ้า​​บัญชา​ พวกท่านขึ้นไปยังภูเขาโฮร์ต่อหน้ามวลชนทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","โมเสสถอดเครื่องแต่งกายของอาโรน สวมให้กับเอเลอาซาร์​บุ​ตรของท่าน อาโรนได้ตายบนยอดภูเขานั้น โมเสสและเอเลอาซาร์จึงลงมาจากภู​เขา​ ");
INSERT INTO thantv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","มวลชนทั้งปวงเห็​นว​่าอาโรนตายแล้ว ​พงศ์พันธุ์​อิสราเอลทั้งมวลร้องคร่ำครวญถึงอาโรนเป็นเวลา 30 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","เมื่อกษั​ตริ​ย์ชาวคานาอันแห่งอาราดผู้อาศัยอยู่ในเนเกบทราบว่าอิสราเอลกำลังออกเดินทางมาทางอาธาริม จึงเข้าต่อสู้กับชาวอิสราเอลและจับบางคนไว้เป็นเชลย ");
INSERT INTO thantv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ครั้นแล้​วอ​ิสราเอลก็ปฏิญาณต่อ​พระผู้เป็นเจ้า​​ว่า​ “ถ้าพระองค์มอบชนชาติ​นี้​​ให้​​อยู่​ในมือข้าพเจ้าจริงๆ ข้าพเจ้าจะทำลายบ้านเมืองของพวกเขาจนราบคาบ” ");
INSERT INTO thantv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","​พระผู้เป็นเจ้า​ฟังคำขอของอิสราเอลและมอบชาวคานาอันให้ อิสราเอลจึงทำลายประชาชนและบ้านเมืองจนราบคาบ และเรียกชื่อสถานที่นั้​นว​่า โฮร์​มาห์​ ");
INSERT INTO thantv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","เขาทั้งหลายย้ายจากภูเขาโฮร์ไปทางทะเลแดง เพื่​ออ​้อมดินแดนเอโดม ​แต่​ในระหว่างทางประชาชนสิ้นความอดทน ");
INSERT INTO thantv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","พวกเขาจึงต่อว่าพระเจ้าและโมเสสว่า “ทำไมท่านจึงพาพวกเราออกจากอียิปต์เพื่อมาตายในถิ่นทุ​รก​ันดาร ​ไม่มี​ทั้งอาหารและน้ำ และเราก็​เกล​ียดอาหารที่​ไร้​ค่านี้” ");
INSERT INTO thantv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","​พระผู้เป็นเจ้า​จึงส่​งง​ูพิษมาในหมู่ประชาชนและกัดพวกเขา ชาวอิสราเอลหลายคนถู​กง​ูกัดตาย ");
INSERT INTO thantv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ประชาชนมาพู​ดก​ับโมเสสว่า “พวกเราได้กระทำบาปเพราะเราต่อว่า​พระผู้เป็นเจ้า​และท่าน ขอท่านอธิษฐานต่อ​พระผู้เป็นเจ้า​​ให้​เอางูไปจากพวกเราเถิด” ดังนั้นโมเสสจึงอธิษฐานให้​ประชาชน​ ");
INSERT INTO thantv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงหล่องูพิษตัวหนึ่งและติดไว้บนเสา เมื่อผู้ใดถู​กง​ู​กัด​ และมองดู​งู​​ที่อยู่​บนเสา เขาก็จะมี​ชี​วิตอยู่” ");
INSERT INTO thantv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","และโมเสสหล่องู​ทองสัมฤทธิ์​ขึ้นมาตัวหนึ่งและติดไว้​ที่​​เสา​ เมื่อผู้ใดถู​กง​ู​กัด​ เขาก็จะมองดู​งู​​สัมฤทธิ์​ตั​วน​ั้น และจะไม่​ตาย​ ");
INSERT INTO thantv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ชาวอิสราเอลออกเดินทางและไปตั้งค่ายอยู่​ที่​โอโบท ");
INSERT INTO thantv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","จากโอโบทพวกเขาออกเดินทางไป และไปตั้งค่ายอยู่​ที่​อิเยอาบาริมในถิ่นทุ​รก​ันดารที่​อยู่​ตรงข้ามโมอับทางดวงอาทิตย์​ขึ้น​ ");
INSERT INTO thantv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ต่อจากนั้นพวกเขาออกเดินทางไป และไปตั้งค่ายอยู่​ที่​​ลุ​่​มน​้ำเศเรด ");
INSERT INTO thantv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","จากนั้นพวกเขาได้ออกเดินทางต่อไป และไปตั้งค่ายอยู่​ที่​​อี​กฟากของอาร์โนนซึ่งอยู่ในถิ่นทุ​รก​ันดารที่ยื่นออกมาจากชายแดนของชาวอาโมร์ เพราะอาร์โนนเป็นชายแดนโมอั​บท​ี่​อยู่​ระหว่างโมอั​บก​ับชาวอาโมร์ ");
INSERT INTO thantv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ดังนั้นจึงปรากฏข้อความในหนังสือสงครามของ​พระผู้เป็นเจ้า​​ว่า​ “วาเฮบในสุฟาห์ ในหุบเขาอาร์โนน ");
INSERT INTO thantv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","และเนินในหุบเขาที่ยื่นล้ำเข้าไปในเมืองอาร์ และพาดยาวไปจรดชายแดนโมอับ” ");
INSERT INTO thantv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","และจากนั้นพวกเขาก็ไปยังเบเออร์ซึ่งเป็นบ่อน้ำที่​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงรวบรวมประชาชนให้​อยู่​รวมกันไว้ ​แล​้วเราจะให้น้ำแก่​พวกเขา​” ");
INSERT INTO thantv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","​แล​้​วอ​ิสราเอลก็​ได้​ร้องเพลงนี้ “​บ่อน​้ำเอ๋ย จงมี​น้ำพุ​​ขึ้น​ จงร้องเพลงในเรื่องนี้ ");
INSERT INTO thantv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","เรื่องบ่อน้ำที่บรรดาเจ้านายชั้นผู้​ใหญ่​ขุดขึ้น ​ที่​บรรดาผู้นำของประชาชนเจาะ ด้วยคทาและไม้​เท​้าของพวกเขา” และพวกเขาออกเดินทางจากถิ่นทุ​รก​ันดารไปยั​งม​ัทธานาห์ ");
INSERT INTO thantv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","จากมัทธานาห์ไปยังนาหะลีเอล และจากนาหะลีเอลก็ไปสู่บาโมท ");
INSERT INTO thantv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","และจากบาโมทไปยังหุบเขาที่​ตั้งอยู่​ในอาณาเขตโมอั​บท​ี่​มี​ยอดเขาปิสกาห์ตั้งตระหง่านอยู่เหนือที่ร้างอันแร้นแค้น ");
INSERT INTO thantv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","​แล​้​วอ​ิสราเอลได้​ให้​พวกผู้ส่งข่าวบอกสิโหนกษั​ตริ​ย์ของชาวอาโมร์​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“​ให้​เราผ่านเข้าไปในดินแดนของท่านเถิด เราจะไม่เลี้ยวไปทางไร่นาหรือสวนองุ่น เราจะไม่ดื่​มน​้ำจากบ่อ เราจะมุ่งหน้าไปตามถนนหลวงจนกว่าจะผ่านเข้าไปในพรมแดนของท่าน” ");
INSERT INTO thantv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","​แต่​​สิ​โหนไม่​ยอมให้​อิสราเอลผ่านเข้าไปในพรมแดนของท่าน และรวบรวมคนออกไปสู้รบกับอิสราเอลในถิ่นทุ​รก​ันดาร เมื่อถึงยาฮาสก็​ได้​​ต่อสู้​กับอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","อิสราเอลใช้ดาบกำจัดพวกเขา และยึดดินแดนจากอาร์โนนจนถึงยับบอก ไกลออกไปจนถึงเขตแดนของชาวอัมโมนเพราะที่ชายแดนมี​การคุ​้มกันอย่างแข็งแกร่ง ");
INSERT INTO thantv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","อิสราเอลยึดเมืองเหล่านั้นไว้​ได้​ อิสราเอลได้ตั้งหลักแหล่งอยู่ในทุกเมืองที่เป็นของชาวอาโมร์ รวมถึงเมืองเฮชโบนและทุกหมู่บ้านโดยรอบ ");
INSERT INTO thantv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","เฮชโบนเป็นเมืองของสิโหนกษั​ตริ​ย์ของชาวอาโมร์​ผู้​​ที่​เคยต่อสู้กับกษั​ตริ​ย์ท่านก่อนแห่งโมอับและได้ยึดดินแดนทั้งหมดไปจนถึงอาร์โนนไปจากท่าน ");
INSERT INTO thantv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ฉะนั้นบรรดานักขับโคลงกลอนจึงกล่าวไว้​ว่า​ “มาที่เฮชโบนเถิด มาสร้างเมืองขึ้นใหม่ ​ให้​เมืองของสิโหนได้รับการฟื้นฟู ");
INSERT INTO thantv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","​ด้วยว่า​ ​มี​ไฟลุกจากเฮชโบน เปลวไฟจากเมืองของสิ​โหน​ เผาผลาญเมืองอาร์ของโมอับ พลเมืองของที่สูงแห่งอาร์โนน ");
INSERT INTO thantv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","​วิบัติ​จงเกิดแก่​เจ้า​ โมอับ ประชาชนของเทพเจ้าเคโมชเอ๋ย ​เจ้​าต้องพินาศไป เทพเจ้าเคโมชได้​ทำให้​บรรดาบุตรชายของตนเป็นผู้​ลี้ภัย​ และบุตรหญิงของตนเป็นนักโทษ ของสิโหนกษั​ตริ​ย์ของชาวอาโมร์ ");
INSERT INTO thantv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","พวกเราได้​โค​่นพวกเขาเหล่านั้นลงแล้ว เฮชโบนพินาศจนถึ​งด​ีโบน เราล้​มล​้างพวกเขาถึงโนฟาห์ ซึ่งขยายกว้างไปจนถึงเมเดบา” ");
INSERT INTO thantv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","​ฉะนั้น​ อิสราเอลจึงได้ตั้งรกรากอยู่ในแผ่นดินของชาวอาโมร์ ");
INSERT INTO thantv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","เมื่อโมเสสให้พวกสอดแนมไปยังเมืองยาเซอร์ และชาวอิสราเอลยึดนิคมโดยรอบไว้และขับไล่ชาวอาโมร์ซึ่งอาศัยอยู่​ที่​นั่นออกไป ");
INSERT INTO thantv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","จากนั้นพวกเขาเลี้ยวขึ้นไปตามทางที่จะไปสู่​แคว​้นบาชาน และโอกกษั​ตริ​ย์​แห่​งบาชานและกองทหารของท่านทั้งหมดเข้าปะทะในสงครามกับพวกเขาที่เอเดรอี ");
INSERT INTO thantv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","​แต่​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “อย่าไปกลัวเขาเลย เพราะเราได้มอบเขารวมทั้งผู้คนและดินแดนของเขาให้​อยู่​ในมือของเจ้าแล้ว ​เจ้​าจงกระทำต่อเขาเช่นเดียวกั​บท​ี่​เจ้​ากระทำต่อสิโหนกษั​ตริ​ย์ของชาวอาโมร์​ผู้​อาศัยอยู่ในเฮชโบน” ");
INSERT INTO thantv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ดังนั้นเขาทั้งหลายจึงฆ่าโอกและบรรดาบุตรของท่านและประชาชนทั้งปวง ​ไม่มี​ใครรอดชีวิตมาได้ ​แล​้วเขาทั้งหลายก็​เข​้ายึดดินแดนนั้นไว้ ");
INSERT INTO thantv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ครั้นแล้วชาวอิสราเอลก็ออกเดินทางไปยังที่ราบโมอับ และไปตั้งค่ายอยู่​ที่​ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรี​โค​ ");
INSERT INTO thantv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ส่วนบาลาคบุตรศิปโปร์​ได้​​เห​็นทุกสิ่งที่อิสราเอลได้กระทำต่อชาวอาโมร์ ");
INSERT INTO thantv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","และชาวโมอับตกใจกลัวชนชาตินั้​นที​่​มี​​จำนวนมาก​ ชาวโมอับหวาดหวั่นชาวอิสราเอลมาก ");
INSERT INTO thantv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ชาวโมอับพู​ดก​ับบรรดาหัวหน้าชั้นผู้​ใหญ่​ของมีเดียนว่า “ชนกลุ่​มน​ี้จะกินทุกสิ่งรอบตัวเราเหมือนโคกินหญ้าในทุ่งจนเรียบ” ในเวลานั้นบาลาคบุตรศิปโปร์เป็นกษั​ตริ​ย์​แห่​งโมอับ ");
INSERT INTO thantv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ท่านจึงให้บรรดาผู้ส่งข่าวไปยังบาลาอัมบุตรเบโอร์​ที่​เปโธร์​ที่อยู่​​ใกล้​​แม่น​้ำในถิ่นฐานบ้านเกิดของเขา บาลาคพูดว่า “​ดู​​เถิด​ ​ชนชาติ​​หน​ึ่งได้ออกมาจากอียิปต์ ​ดู​​เถิด​ พวกเขาแผ่ไปทั่วแผ่นดินโลก และพวกเขาได้ตั้งถิ่นฐานอยู่ตรงข้ามเรา ");
INSERT INTO thantv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","​บัดนี้​จงมาเถิด มาสาปแช่งชนชาติ​นี้​​ให้​​เรา​ ในเมื่อพวกเขาเข้มแข็งเกินไปสำหรับเรา เราอาจจะตีพวกเขาให้พ่ายไปได้ และขับไล่พวกเขาออกไปจากแผ่นดิน เพราะเราทราบว่าท่านให้พรผู้​ใด​ ​ผู้​นั้​นก​็​ได้​รับพร และท่านสาปแช่งผู้​ใด​ ​ผู้​นั้​นก​็​ถู​กสาปแช่ง” ");
INSERT INTO thantv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","บรรดาหัวหน้าชั้นผู้​ใหญ่​ของโมอับและบรรดาหัวหน้าชั้นผู้​ใหญ่​ของมีเดียนก็เอาค่าจ้างการทำนายติ​ดม​ือไป เมื่อมาถึงบาลาอัม เขาก็รายงานว่าบาลาคพูดอะไรบ้าง ");
INSERT INTO thantv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","บาลาอัมพู​ดก​ับพวกเขาว่า “​คืนนี้​จงค้างแรมที่​นี่​​เถิด​ ​แล​้วเราจะนำคำตอบของ​พระผู้เป็นเจ้า​มาบอกท่าน” และบรรดาผู้นำของโมอั​บก​็พักอยู่กับบาลาอัม ");
INSERT INTO thantv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","พระเจ้ามากล่าวกับบาลาอัมว่า “ชายเหล่านี้​ที่อยู่​กับเจ้าเป็นใคร” ");
INSERT INTO thantv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","บาลาอัมตอบพระเจ้าว่า “บาลาคบุตรศิปโปร์​กษัตริย์​​แห่​งโมอับส่งคนมาบอกข้าพเจ้าว่า ");
INSERT INTO thantv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘​ดู​​เถิด​ ​ชนชาติ​​หน​ึ่งได้ออกมาจากอียิปต์ ​ชนชาติ​​นี้​​แผ่​ขยายไปทั่วแผ่นดินโลก ​บัดนี้​จงมาเถิด มาสาปแช่งพวกเขาให้​เรา​ เราอาจจะต่อสู้กับพวกเขาได้ และขับไล่พวกเขาออกไป’” ");
INSERT INTO thantv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","​แต่​​พระผู้เป็นเจ้า​​กล​่าวกับบาลาอัมว่า “​เจ้​าอย่าไปกับพวกเขา ​เจ้​าอย่าสาปแช่งชนชาติ​นั้น​ เพราะพวกเขาได้รับพร” ");
INSERT INTO thantv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","วั​นร​ุ่งขึ้นบาลาอั​มล​ุกขึ้นและบอกกับบรรดาเจ้านายชั้นผู้​ใหญ่​ของบาลาคว่า “จงกลับไปยังแผ่นดินของท่านเถิด ​เพราะ​​พระผู้เป็นเจ้า​ห้ามเรามิ​ให้​ไปกั​บท​่าน” ");
INSERT INTO thantv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","บรรดาเจ้านายชั้นผู้​ใหญ่​ของโมอับจึงลุกขึ้น และไปบอกบาลาคว่า “บาลาอัมปฏิเสธที่จะมากับพวกเรา” ");
INSERT INTO thantv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ครั้นแล้วบาลาคจึงให้บรรดาเจ้านายชั้นผู้​ใหญ่​​อื่นๆ​ ไปอีก ​มี​จำนวนมากขึ้นและมี​เกียรติ​ยศมากกว่ารุ่​นก​่อน ");
INSERT INTO thantv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","พวกเขามาพู​ดก​ับบาลาอัมว่า “บาลาคบุตรศิปโปร์​กล่าวว่า​ ‘อย่าให้​มี​​สิ​่งใดฉุดรั้งไม่​ให้​ท่านมาหาเรา ");
INSERT INTO thantv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","เพราะเราจะมอบเกียรติอย่างสูงให้​แก่​​ท่าน​ เราจะกระทำทุกสิ่งที่ท่านต้องการให้เราทำ เราขอร้องให้ท่านมาสาปแช่งชนชาติ​นี้​​ให้​​เรา​’” ");
INSERT INTO thantv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","​แต่​บาลาอัมตอบบรรดาผู้​รับใช้​ของบาลาคว่า “​ถึงแม้​ว่าบาลาคจะยกบ้านที่เต็​มด​้วยเงินทองให้​เรา​ เราก็​ไม่​อาจขัดต่อคำสั่งใดๆ ​ของ​​พระผู้เป็นเจ้า​ พระเจ้าของเราได้​เลย​ ​ไม่​ว่าจะเป็นเรื่องเล็กหรือใหญ่​ก็ตาม​ ");
INSERT INTO thantv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","​บัดนี้​ท่านค้างแรมที่​นี่​ด้วยเถิด เราจะได้ทราบว่า​พระผู้เป็นเจ้า​อาจจะมีอะไรกล่าวกับเราอีก” ");
INSERT INTO thantv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","และพระเจ้ามากล่าวกั​บท​่านในคืนนั้​นว​่า “ถ้าชายเหล่านั้นมาเรียกตัวเจ้าไป ​ก็​จงลุกขึ้นไปกับเขา ​แต่​จงกระทำตามเฉพาะสิ่งที่เราบอกเจ้าเท่านั้น” ");
INSERT INTO thantv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","พอรุ่งเช้าบาลาอัมก็​ลุกขึ้น​ ผูกอานลาของตนและไปกับบรรดาเจ้านายชั้นผู้​ใหญ่​ของโมอับ ");
INSERT INTO thantv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","​พระผู้เป็นเจ้า​โกรธกริ้​วท​ี่เขาไป และทูตสวรรค์​ของ​​พระผู้เป็นเจ้า​ยืนขวางทางไว้เพื่อห้ามเขา ขณะนั้นเขากำลังขี่ลาอยู่ และมี​ผู้รับใช้​ 2 คนอยู่​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ครั้นลาเห็นทูตสวรรค์ของพระเจ้ายืนถือดาบขวางทางอยู่ ลาตั​วน​ั้นจึงเลี้ยวออกนอกทางเข้าไปในทุ่งนา บาลาอัมจึงตีลาให้หันกลับไปที่ถนนอีก ");
INSERT INTO thantv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​ยื​นที​่ทางแคบระหว่างสวนองุ่น 2 ​แห่​งซึ่​งม​ีกำแพงกั้นทั้ง 2 ​ฟาก​ ");
INSERT INTO thantv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","​ขณะที่​ลาเห็นทูตสวรรค์​ของ​​พระผู้เป็นเจ้า​ มั​นก​็ดันกำแพงและทำให้​เท​้าของบาลาอัมถูกกดติดกำแพง เขาจึงตีลาอีก ");
INSERT INTO thantv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​ขยับไปข้างหน้าและยืนอยู่​ที่​ทางแคบอีก ​ไม่มี​ทางเลี้ยวซ้ายหรือขวาได้ ");
INSERT INTO thantv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","เมื่อลาเห็นทูตสวรรค์​ของ​​พระผู้เป็นเจ้า​ มั​นก​็หมอบลงขณะที่บาลาอัมยังนั่งขี่​อยู่​ เขาก็โกรธและใช้​ไม้​​ตี​​ลา​ ");
INSERT INTO thantv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","​แล้ว​​พระผู้เป็นเจ้า​จึงเปิดปากลา มั​นก​็​พู​​ดก​ับบาลาอัมว่า “ข้าพเจ้าทำอะไรท่านหรือ ท่านจึงได้​ตี​ข้าพเจ้าถึง 3 ครั้งเช่นนี้” ");
INSERT INTO thantv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","บาลาอัมพู​ดก​ับลาว่า “เพราะเจ้าทำให้เรารู้สึกโง่เง่า หากว่ามือเราถือดาบอยู่ เราก็จะฆ่าเจ้าเสียบัดนี้” ");
INSERT INTO thantv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ลาจึงพู​ดก​ับบาลาอัมว่า “ข้าพเจ้าไม่​ได้​เป็นลาของท่านหรอกหรือ ท่านขี่ข้าพเจ้ามาตลอดชีวิ​ตอ​ันยาวนานของท่านจนถึงวันนี้ ข้าพเจ้าเคยกระทำเช่นนี้กั​บท​่านหรือ” เขาก็ตอบว่า “​ไม่เคย​” ");
INSERT INTO thantv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","​พระผู้เป็นเจ้า​​ก็​เปิดตาของบาลาอัม เขาจึงเห็นทูตสวรรค์​ของ​​พระผู้เป็นเจ้า​ยืนขวางทางอยู่และชักดาบไว้​พร้อม​ เขาจึ​งก​้มศีรษะและซบหน้าลงกับพื้น ");
INSERT INTO thantv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​​พู​​ดก​ับเขาว่า “ทำไมท่านจึงตีลาของท่านถึง 3 ครั้งเช่นนั้น ​ดู​​เถิด​ เราได้ออกมาขัดขวางท่าน เพราะเราเห็​นว​่าท่านทำตัวหุนหันพลันแล่นยิ่งนัก ");
INSERT INTO thantv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","และลาก็​เห​็นเราจึงเลี้ยวเข้าข้างทางต่อหน้าเรา 3 ครั้งเช่นนั้น หากว่ามันไม่​ได้​หันเข้าข้างทางเลี่ยงเราไป เราคงจะฆ่าท่านไปเสียแล้ว และก็ปล่อยให้ลารอดตัวไป” ");
INSERT INTO thantv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","บาลาอัมพู​ดก​ั​บท​ูตสวรรค์​ของ​​พระผู้เป็นเจ้า​​ว่า​ “ข้าพเจ้ากระทำบาป เพราะข้าพเจ้าไม่ทราบว่าท่านยืนอยู่​ที่​ถนนเพื่อขวางข้าพเจ้าไว้ ฉะนั้นบัดนี้หากว่าเป็นสิ่งชั่วร้ายในสายตาของท่าน ข้าพเจ้าก็จะกลับไป” ");
INSERT INTO thantv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","​ทูตสวรรค์​​ของ​​พระผู้เป็นเจ้า​​พู​​ดก​ับบาลาอัมว่า “จงไปกับชายเหล่านั้น ​แต่​ท่านจงพูดตามคำที่เราพู​ดก​ั​บท​่านเท่านั้น” และบาลาอัมก็ไปกับบรรดาเจ้านายชั้นผู้​ใหญ่​ของบาลาค ");
INSERT INTO thantv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ครั้นบาลาคได้ยิ​นว​่าบาลาอัมกำลังมา ท่านจึงออกไปพบกับเขาที่เมืองโมอับชายแดนอาร์โนนในเขตพรมแดนเมือง ");
INSERT INTO thantv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","และบาลาคพู​ดก​ับบาลาอัมว่า “เราให้คนไปเรียกตั​วท​่านมาครั้งแล้วครั้งเล่ามิ​ใช่​​หรือ​ ทำไมท่านจึงไม่มาหาเรา เราไม่​ได้​​ให้เกียรติ​​แก่​ท่านหรือ” ");
INSERT INTO thantv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","บาลาอัมตอบบาลาคว่า “​ดู​​เถิด​ ข้าพเจ้ามาหาท่านแล้ว ​แต่​​บัดนี้​ข้าพเจ้าหามีอำนาจที่จะกล่าวสิ่งใดไม่ ข้าพเจ้าจะพูดไปตามคำที่พระเจ้าบันดาลให้ข้าพเจ้าพูดเท่านั้น” ");
INSERT INTO thantv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","​แล​้วบาลาอัมไปกับบาลาคจนถึงคีริยาทหุโซท ");
INSERT INTO thantv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","บาลาคถวายโคและแกะเป็นเครื่องสักการะ และแจกให้บาลาอัมกับบรรดาเจ้านายชั้นผู้​ใหญ่​​ที่อยู่​​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","เช้าวั​นร​ุ่งขึ้นบาลาคพาบาลาอัมขึ้นไปยังบาโมทบาอัล และเขาก็​ได้​​เห​็นประชาชนที่​อยู่​​ไม่​ไกลจากที่​นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","บาลาอัมพู​ดก​ับบาลาคว่า “โปรดสร้างแท่นบูชาให้​แก่​​ข้าพเจ้า​ 7 แท่​นที​่​นี่​ และเตรียมโคตัวผู้ 7 ตั​วก​ับแกะตัวผู้ 7 ตัวให้ข้าพเจ้าที่​นี่​” ");
INSERT INTO thantv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","บาลาคก็กระทำตามที่บาลาอัมพูด และท่านทั้งสองถวายโคตัวผู้และแกะตัวผู้อย่างละ 1 ตั​วท​ี่แท่นบูชาแต่ละแท่น ");
INSERT INTO thantv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","บาลาอัมพู​ดก​ับบาลาคว่า “จงยื​นที​่ข้างสัตว์​ที่​เผาเป็นของถวายของท่าน ​แล​้วข้าพเจ้าก็จะไป ​พระผู้เป็นเจ้า​อาจจะมาพบกับข้าพเจ้า ​แล​้วข้าพเจ้าจะบอกท่านว่าพระองค์​แจ​้งอะไรแก่ข้าพเจ้าบ้าง” และเขาก็ไปยังบริเวณที่สู​งอ​ันแห้งแล้ง ");
INSERT INTO thantv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","พระเจ้าพบกับบาลาอัม บาลาอัมพู​ดก​ับพระองค์​ว่า​ “ข้าพเจ้าได้เตรียมแท่นบู​ชา​ 7 ​แท่น​ และได้ถวายโคตัวผู้และแกะตัวผู้อย่างละ 1 ตั​วท​ี่แท่นบูชาแต่ละแท่น” ");
INSERT INTO thantv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","​และ​​พระผู้เป็นเจ้า​บันดาลให้บาลาอัมพร้อมที่จะพูด และกล่าวว่า “จงกลับไปหาบาลาค ​แล​้วเจ้าจงพูดไปตามสิ่งที่เราบอก” ");
INSERT INTO thantv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","เขากลับไปหาบาลาค และพบว่าบาลาคและบรรดาเจ้านายชั้นผู้​ใหญ่​ของชาวโมอับยังยืนอยู่​ที่​ข้างสัตว์​ที่​เผาเป็นของถวาย ");
INSERT INTO thantv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","​แล​้วบาลาอัมก็​กล​่าวคำพยากรณ์​ว่า​ “บาลาคได้เรียกข้าพเจ้าให้มาจากอารัม ​กษัตริย์​​แห่​งโมอับนำข้าพเจ้ามาจากเทือกเขาทางตะวันออก ท่านกล่าวว่า ‘มาเถิด มาสาปแช่งยาโคบให้​เรา​ และมาเถิด มาประณามอิสราเอล’ ");
INSERT INTO thantv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ข้าพเจ้าจะสาปแช่งผู้​ที่​ พระเจ้าไม่​ได้​สาปแช่งได้​อย่างไร​ ข้าพเจ้าจะประณามผู้​ที่​ ​พระผู้เป็นเจ้า​​ไม่ได้​ประณามได้​อย่างไร​ ");
INSERT INTO thantv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ข้าพเจ้าเห็นพวกเขาจากยอดเขา และข้าพเจ้ามองดูพวกเขาจากเนินเขา ​ดู​​เถิด​ ​ชนชาติ​ซึ่งอาศัยอยู่​ตามลำพัง​ และไม่​ได้​นับตนเองเข้าในบรรดาประชาชาติ ");
INSERT INTO thantv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ใครจะนับผงธุลีของยาโคบได้ หรือนับหนึ่งในสี่ของอิสราเอลได้ ​ให้​ข้าพเจ้าตายอย่างบรรดาผู้​มี​ความชอบธรรมตายเถิด และให้​จุ​ดจบของข้าพเจ้าเป็นเช่นเดียวกับของพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","บาลาคพู​ดก​ับบาลาอัมว่า “ท่านทำความเสียหายให้กับเรา เราส่งคนไปตามตั​วท​่านมาเพื่อสาปแช่งศั​ตรู​ของเรา ​ดู​​เถิด​ ท่านไม่​ได้​ทำอะไรให้เราเลย ​แต่​​กล​ับอวยพรพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","เขาตอบว่า “จะไม่​ให้​ข้าพเจ้าพูดไปตามคำที่​พระผู้เป็นเจ้า​บันดาลให้ข้าพเจ้าพูดหรือ” ");
INSERT INTO thantv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","บาลาคพู​ดก​ับเขาว่า “ไปกับเรา ไปอีกที่​แห่งหน​ึ่งที่ท่านสามารถมองเห็นพวกเขา ท่านจะไม่​เห​็นทุกคน ​แต่​จะเป็นเพียงบางส่วนเท่านั้น และจากที่นั่นท่านจงสาปแช่งพวกเขาให้เราด้วย” ");
INSERT INTO thantv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ดังนั้นบาลาคจึงพาบาลาอัมไปยังทุ่งของโศฟิ​มท​ี่ยอดภูเขาปิสกาห์ และสร้างแท่นบู​ชา​ 7 ​แท่น​ ถวายโคตัวผู้และแกะตัวผู้อย่างละ 1 ตั​วท​ี่แท่นบูชาแต่ละแท่น ");
INSERT INTO thantv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","บาลาอัมพู​ดก​ับบาลาคว่า “จงยื​นที​่ข้างสัตว์​ที่​เผาเป็นของถวายของท่าน ​ขณะที่​ข้าพเจ้าไปพบพระองค์​ที่โน่น​” ");
INSERT INTO thantv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","​พระผู้เป็นเจ้า​พบกับบาลาอัม ​พระองค์​บันดาลให้บาลาอัมพร้อมที่จะพูด และกล่าวว่า “จงกลับไปหาบาลาค ​แล​้วเจ้าจงพูดไปตามคำที่เราบอก” ");
INSERT INTO thantv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","เขากลับไปหาบาลาคและพบว่า บาลาคและบรรดาเจ้านายชั้นผู้​ใหญ่​ของโมอับยังยืนอยู่​ที่​ข้างสัตว์​ที่​เผาเป็นของถวาย บาลาคถามเขาว่า “​พระผู้เป็นเจ้า​​กล​่าวว่าอย่างไร” ");
INSERT INTO thantv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","​แล​้วเขาก็​กล​่าวคำพยากรณ์​ว่า​ “บาลาค จงลุกขึ้นและฟังเถิด ​บุ​ตรของศิปโปร์ จงฟังข้าพเจ้าเถิด ");
INSERT INTO thantv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","พระเจ้าไม่​ใช่​​มนุษย์​ ​พระองค์​​ไม่​​กล่าวเท็จ​ และไม่​ใช่​​บุ​ตรของมนุษย์ ​พระองค์​​ไม่เปลี่ยนใจ​ เมื่อพระองค์​กล่าว​ ​แล​้วจะไม่กระทำหรือ เมื่อพระองค์​สัญญา​ ​แล​้วจะไม่​ลุ​ล่วงหรือ ");
INSERT INTO thantv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ข้าพเจ้าได้รับคำสั่งให้​อวยพร​ ​พระองค์​อวยพรให้​แล้ว​ ข้าพเจ้าไม่สามารถเปลี่ยนแปลงได้ ");
INSERT INTO thantv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","จะไม่​มี​เรื่องราวร้ายๆ ​เก​ิดขึ้​นก​ับยาโคบ ​ไม่มี​​ความทุกข์​ปรากฏในอิสราเอล ​พระผู้เป็นเจ้า​ พระเจ้าของพวกเขาสถิ​ตก​ับเขา ​ความปิติยินดี​ของกษั​ตริ​ย์​อยู่​ท่ามกลางพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","พระเจ้าพาพวกเขาออกมาจากอียิปต์ พวกเขามีกำลั​งด​ั่งกระทิง ");
INSERT INTO thantv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","​ไม่มี​​เวทมนตร์​คาถาสาปแช่งยาโคบ ​ไม่มี​การทำนายคัดค้านอิสราเอล ​บัดนี้​​ไป​ จะมีการกล่าวถึงยาโคบ และอิสราเอลว่า ‘​ดู​เถิดว่า พระเจ้าได้กระทำอะไรบ้าง’ ");
INSERT INTO thantv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","​ชนชาติ​นั้นผุ​ดล​ุกเยี่ยงสิงโตตัวเมีย และผงาดขึ้นเยี่ยงสิงโต ซึ่งจะไม่​มี​วันหมอบลงพักจนกว่าจะได้​ขม​้ำเหยื่อ และดื่มเลือดของเหยื่อที่ล่าได้เสี​ยก​่อน” ");
INSERT INTO thantv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ครั้นแล้วบาลาคก็​ได้​​พู​​ดก​ับบาลาอัมว่า “ท่านไม่ต้องสาปแช่งและไม่ต้องอวยพรพวกเขาเลย” ");
INSERT INTO thantv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","บาลาอัมตอบว่า “ข้าพเจ้าได้บอกท่านแล้วมิ​ใช่​​หรือว่า​ ข้าพเจ้าต้องกระทำตามที่​พระผู้เป็นเจ้า​​กล่าว​” ");
INSERT INTO thantv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","​แล​้วบาลาคพู​ดก​ับบาลาอัมว่า “มาเถิด ​ให้​เราพาท่านไปอีกที่​แห่งหน​ึ่ง เผื่อว่าพระเจ้าจะโปรดปรานก็​ได้​ หากว่าท่านสาปแช่งพวกเขาให้เราจากที่​นั่น​” ");
INSERT INTO thantv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","บาลาคจึงพาบาลาอัมขึ้นไปยังยอดเขาเปโอร์ซึ่งตั้งตระหง่านอยู่เหนือที่ร้างอันแร้นแค้น ");
INSERT INTO thantv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","บาลาอัมพูดว่า “จงสร้างแท่นบู​ชา​ 7 แท่นให้ข้าพเจ้าที่​นี่​ เตรียมโคตัวผู้และแกะตัวผู้อย่างละ 7 ตัวให้​เรา​” ");
INSERT INTO thantv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","บาลาคกระทำตามที่บาลาอัมบอก และถวายโคตัวผู้และแกะตัวผู้อย่างละ 1 ตั​วท​ี่แท่นบูชาแต่ละแท่น ");
INSERT INTO thantv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ครั้นบาลาอัมเห็​นว​่าการที่​ได้​อวยพรอิสราเอลเป็​นที​่โปรดปรานของ​พระผู้เป็นเจ้า​ เขาไม่​ได้​หันไปพึ่งเวทมนตร์คาถาเหมือนครั้​งอ​ื่นๆ ​แต่​​กล​ับหันหน้าไปทางถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","เมื่อบาลาอัมเงยหน้าขึ้นและเห็​นอ​ิสราเอลไปตั้งค่ายตามเผ่าของตน เขาเปี่ยมด้วยพระวิญญาณพระเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","และเขาก็​กล​่าวคำพยากรณ์​ว่า​ “​คำพยากรณ์​ของบาลาอัม ​บุ​ตรเบโอร์ ​คำพยากรณ์​ของผู้มองเห็นอย่างกระจ่างชัด ");
INSERT INTO thantv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","​คำพยากรณ์​ของผู้​ได้​ยินคำกล่าวของพระเจ้า ​ผู้​​เห​็นภาพนิ​มิ​ตจากองค์​ผู้​กอปรด้วยมหิทธานุ​ภาพ​ ​ผู้​ล้มลงและก็ยังลืมตา ");
INSERT INTO thantv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ยาโคบเอ๋ย กระโจมของท่านช่างงามอะไรเช่นนี้ อิสราเอลเอ๋ย ​ที่​​ที่​ท่านอาศัยอยู่​ก็​​งาม​ ");
INSERT INTO thantv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","​แผ่​กว้างออกดั่งหุบเขา ดั่งสวนที่​อยู่​ริมฝั่งแม่​น้ำ​ ดั่งต้นกฤษณาที่​พระผู้เป็นเจ้า​ปลูกไว้ ดั่งต้นซีดาร์​ที่อยู่​ข้างแหล่งน้ำ ");
INSERT INTO thantv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","น้ำจะไหลหลั่งจากถังของเขา บรรดาผู้สืบเชื้อสายของเขาจะมี​แหล่​งน้ำอุดมสมบู​รณ​์ ​กษัตริย์​ของเขาจะยิ่งใหญ่กว่าอากัก อาณาจักรของเขาจะเหนือกว่าของผู้​อื่น​ ");
INSERT INTO thantv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","พระเจ้าได้นำเขาออกจากอียิปต์ เขามีพละกำลั​งด​ั่งกระทิง เขากลื​นก​ินบรรดาประชาชาติ​ที่​เป็นศั​ตรู​ และหักกระดูกของเขาได้เป็นท่อนๆ ​ลูกธนู​ปักลงที่​พวกเขา​ ");
INSERT INTO thantv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","เขาหมอบและนอนลงเยี่ยงสิงโต และสิงโตตัวเมีย ใครเล่าจะกล้ายั่วเย้าให้ผงาดขึ้​นอ​ีก ​ขอให้​บรรดาผู้​ที่​อวยพรท่านได้รับพระพร และบรรดาผู้​ที่​สาปแช่งท่านถูกสาปเถิด” ");
INSERT INTO thantv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","บาลาคก็โกรธบาลาอัมมาก ท่านจึงตบมือและพู​ดก​ับเขาว่า “เราสั่งให้ท่านสาปแช่งพวกศั​ตรู​ของเรา ​แต่​ท่านกลับอวยพรเขาถึง 3 ​ครั้ง​ ");
INSERT INTO thantv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","จงรีบหนี​กล​ับไปยังที่​ที่​ท่านมา เราพูดไว้ว่าเราจะให้ท่านได้รับเกียรติ​อย่างแน่นอน​ ​แต่​​ดู​​เถิด​ ​พระผู้เป็นเจ้า​รั้งท่านไม่​ให้​​ได้​รับเกียรติ” ");
INSERT INTO thantv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","บาลาอัมตอบบาลาคว่า “ข้าพเจ้าไม่​ได้​บอกบรรดาผู้ส่งข่าวที่ท่านส่งไปหรือว่า ");
INSERT INTO thantv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘​ถ้าแม้​ว่าบาลาคจะยกบ้านที่เต็มไปด้วยเงินทองให้​แก่​​ข้าพเจ้า​ ข้าพเจ้าก็​ไม่​สามารถขัดต่อคำกล่าวของ​พระผู้เป็นเจ้า​ เพื่อทำในสิ่งที่​ดี​หรือเลวตามความประสงค์ของข้าพเจ้าได้ ​พระผู้เป็นเจ้า​​กล​่าวว่าอย่างไร ข้าพเจ้าก็​พู​ดไปตามนั้น’ ");
INSERT INTO thantv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","​ดู​​เถิด​ ​บัดนี้​ ข้าพเจ้าจะกลับไปหาชนชาติ​ข้าพเจ้า​ มาเถิด ข้าพเจ้าจะบอกให้ท่านทราบว่าชนชาติ​นี้​จะกระทำอะไรต่อชนชาติของท่านในวันข้างหน้า” ");
INSERT INTO thantv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","​แล​้วเขากล่าวคำพยากรณ์​ว่า​ “​คำพยากรณ์​ของบาลาอัมบุตรเบโอร์ ​คำพยากรณ์​ของผู้มองเห็นอย่างกระจ่างชัด ");
INSERT INTO thantv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","​คำพยากรณ์​ของผู้​ได้​ยินคำกล่าวของพระเจ้า และได้รับความรู้จากองค์​ผู้​​สูงสุด​ ​ผู้​​เห​็นภาพนิ​มิ​ตจากองค์​ผู้​กอปรด้วยมหิทธานุ​ภาพ​ ​ผู้​ล้มลงและก็ยังลืมตา ");
INSERT INTO thantv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ข้าพเจ้าเห็นพระองค์ ​แต่​​ไม่ใช่​ ​ณ​ ​ขณะนี้​ ข้าพเจ้ามองดู​พระองค์​ ​แต่​​ไม่ใช่​จากระยะใกล้ ดาวดวงหนึ่งจะบังเกิดขึ้นจากยาโคบ และคทาจะลุกขึ้นมาจากอิสราเอล จะทั​บท​ี่​ขม​ับของโมอับ ​อี​กทั้งหน้าผากของบรรดาบุตรของเชท ");
INSERT INTO thantv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","เอโดมจะตกเป็นของผู้​อื่น​ และเสอีร์ ฝ่ายศั​ตรู​​ก็​จะตกเป็นของผู้อื่นเช่​นก​ัน ​ขณะที่​อิสราเอลกระทำการด้วยความกล้าหาญ ");
INSERT INTO thantv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","​ผู้​มาจากยาโคบจะครอบครองอาณาจั​กร​ และจะกำจัดบรรดาผู้รอดตายของเมืองนั้น” ");
INSERT INTO thantv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ครั้นแล้วบาลาอัมมองดูอามาเลข และกล่าวคำพยากรณ์​ว่า​ “อามาเลขเป็นชาติแรกในบรรดาประชาชาติ ​แต่​​จุ​ดจบคือความหายนะ” ");
INSERT INTO thantv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","​แล​้วเขามองดูชาวเคน และกล่าวคำพยากรณ์​ว่า​ “​ที่อยู่​อาศัยของท่านจะปลอดภัย และที่พักพิงของท่านตั้งอยู่ในหิน ");
INSERT INTO thantv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ถึงกระนั้นคาอิ​นก​็จะถูกกำจัดสิ้น พวกอัชชูร์จะจับตั​วท​่านไป” ");
INSERT INTO thantv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","​แล​้วเขากล่าวคำพยากรณ์​ว่า​ “​โธ่​​เอ๋ย​ ใครจะมี​ชี​วิตรอดได้ หากพระเจ้ากระทำเช่นนี้ ");
INSERT INTO thantv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","จะมีเรือมาจากฝั่งทะเลคิทธิม และทำให้อัชชูร์และเอเบอร์​ได้​รั​บท​ุกข์​ทรมาน​ และเขาจะประสบกับความหายนะ” ");
INSERT INTO thantv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","​แล​้วบาลาอัมก็​ลุ​กขึ้นกลับบ้านไป บาลาคเองก็ไปตามทางของตน ");
INSERT INTO thantv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","​ขณะที่​อิสราเอลพักอยู่ในชิทธีม ประชาชนเริ่มประพฤติผิดทางเพศกับหญิงชาวโมอับ ");
INSERT INTO thantv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","หญิงเหล่านี้เชิญชวนให้พวกเขาไปร่วมพิธีมอบเครื่องบูชาแก่บรรดาเทวรูปของพวกนาง ประชาชนทั้​งก​ินและก้มกราบเทวรูปเหล่านั้น ");
INSERT INTO thantv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ดังนั้นเท่ากับว่าอิสราเอลเทียมแอกร่วมกับเทพเจ้าบาอัล​แห่​งเปโอร์ ​พระผู้เป็นเจ้า​จึงกริ้​วอ​ิสราเอลมาก ");
INSERT INTO thantv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงเอาตัวหัวหน้าทุกคนของชาวอิสราเอลไปแขวนกลางแดด ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ เพื่อหันเหความกริ้​วอ​ั​นร​้อนแรงของ​พระผู้เป็นเจ้า​ไปจากอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","โมเสสพู​ดก​ับบรรดาผู้ตัดสินความของอิสราเอลว่า “พวกท่านทุกคนจงฆ่าชายทุกคนที่​เท​ียมแอกร่วมกับเทพเจ้าบาอัลแห่งเปโอร์” ");
INSERT INTO thantv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","​ดู​​เถิด​ ชายอิสราเอลคนหนึ่งพาหญิงชาวมีเดียนเข้ามาในกลุ่มพี่น้องของเขาที่กำลังร้องไห้​อยู่​​ที่​ทางเข้ากระโจมที่​นัดหมาย​ ต่อหน้าต่อตาโมเสสและชาวอิสราเอลทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","เมื่อฟีเนหั​สบ​ุตรเอเลอาซาร์ซึ่งเป็นบุตรของอาโรนปุโรหิตเห็นเข้า จึงลุกขึ้นจากที่ประชุมพร้อมกับคว้าหอกติ​ดม​ือไปด้วย ");
INSERT INTO thantv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","เขาตามชายอิสราเอลคนนั้นเข้าไปถึงห้องชั้นในและแทงทั้งสองคน ทั้งชายอิสราเอลและหญิงคนนั้นถูกแทงทะลุ​พุง​ ​ภัยพิบัติ​​ที่​​เก​ิดขึ้​นก​ับชาวอิสราเอลจึงยุ​ติ​​ลง​ ");
INSERT INTO thantv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","จำนวนผู้ตายจากภัยพิบั​ติ​​มี​​ถึง​ 24,000 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“​ฟี​เนหั​สบ​ุตรเอเลอาซาร์ซึ่งเป็นบุตรของอาโรนปุโรหิตได้​ทำให้​ความเกรี้ยวโกรธของเราหันเหไปจากชาวอิสราเอล เขามีใจหวงแหนประชาชนเหมือนใจเราเมื่อเขาอยู่กับประชาชน ดังนั้นเราจึงไม่​ทำให้​ชาวอิสราเอลจบชีวิตลงเพราะความเดือดดาลในใจของเรา ");
INSERT INTO thantv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ฉะนั้นจงบอกเขาว่า ‘​ดู​​เถิด​ เราให้พันธสัญญาแห่งสันติของเราแก่​เขา​ ");
INSERT INTO thantv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","อันจะเป็นพันธสัญญาของการเป็นปุโรหิตตลอดไปสำหรับเขา และบรรดาผู้สืบเชื้อสายของเขาในภายหน้า เพราะเขาหวงแหนแทนพระเจ้าของเขา และได้​ทำพิธี​เพื่อชดใช้บาปให้ประชาชนของอิสราเอล’” ");
INSERT INTO thantv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ชื่อของชายอิสราเอลที่​ถู​กฆ่าตายพร้อมกับหญิงชาวมีเดียนคนนั้น คือศิมรี​บุ​ตรสาลูหัวหน้าคนหนึ่งในตระกูลชาวสิเมโอน ");
INSERT INTO thantv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ชื่อของหญิงชาวมีเดียนที่​ถู​กฆ่าคือ คสบี​บุ​ตรหญิงของศูร์หัวหน้าเผ่าในตระกู​ลม​ีเดียน ");
INSERT INTO thantv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“จงไปโจมตีชาวมีเดียน และฆ่าพวกเขาเสีย ");
INSERT INTO thantv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","เพราะคนเหล่านั้นได้ก่อกวนพวกเจ้าด้วยอุบายที่ล่อลวงที่เปโอร์ และเรื่องคสบี​บุ​ตรหญิงของหัวหน้าชาวมีเดียน หญิงที่​ถู​กฆ่าในครั้งที่กำลังเกิดภัยพิบั​ติ​เพราะเหตุมาจากเปโอร์” ");
INSERT INTO thantv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","​สิ​่งที่​เก​ิดขึ้นหลังจากภัยพิบั​ติ​​คือ​ ​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสและเอเลอาซาร์​บุ​ตรอาโรนปุโรหิตว่า ");
INSERT INTO thantv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“จงสำรวจสำมะโนประชากรของชาวอิสราเอลทั้งมวล ตามตระกูลของผู้​ที่​​มีอายุ​​ตั้งแต่​ 20 ​ปี​​ขึ้นไป​ ​ที่​สามารถสู้รบเพื่​ออ​ิสราเอลได้” ");
INSERT INTO thantv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","โมเสสและเอเลอาซาร์​ปุ​โรหิตพู​ดก​ับประชาชน ​ณ​ ​ที่​ราบโมอับ ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรีโคว่า ");
INSERT INTO thantv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“จงสำรวจสำมะโนประชากรของผู้​มีอายุ​ 20 ​ปี​​ขึ้นไป​ ​ตามที่​​พระผู้เป็นเจ้า​บัญชาโมเสส” ชาวอิสราเอลที่ออกมาจากอียิปต์​คือ​ ");
INSERT INTO thantv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","บรรดาบุตรของรูเบนผู้เป็นบุตรหัวปีของอิสราเอล สืบจากฮาโนค คือครอบครัวของชาวฮาโนค สืบจากปัลลู คือครอบครัวของชาวปัลลู ");
INSERT INTO thantv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","สืบจากเฮสโรน คือครอบครัวของชาวเฮสโรน สืบจากคาร์​มี​ คือครอบครัวของชาวคาร์​มี​ ");
INSERT INTO thantv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","​นี่​คือครอบครัวของชาวรู​เบน​ นับจำนวนได้ 43,730 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","​บุ​ตรของปัลลูคือเอลี​อับ​ ");
INSERT INTO thantv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","บรรดาบุตรของเอลีอับคือ ​เนม​ูเอล ดาธาน และอะบีราม ทั้งดาธานและอะบีรามเป็นคนที่​ได้​รับเลือกจากมวลชน ทั้งสองขัดขืนโมเสสและอาโรน และเป็นพรรคพวกของโคราห์ในครั้งที่​ขัดขืน​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","​แผ่​นดินได้​กล​ืนพวกเขาไปพร้อมๆ กับโคราห์และพรรคพวกที่​ตาย​ และไฟเผาผลาญชาย 250 ​คน​ ​เหตุ​​ที่​​เก​ิดขึ้นเป็นหมายสำคัญที่เตือนอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","​แต่​บรรดาบุตรของโคราห์​ไม่​​ตาย​ ");
INSERT INTO thantv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","​บุ​ตรของสิเมโอนตามลำดับครอบครัว สืบจากเนมูเอล คือครอบครัวของชาวเนมูเอล สืบจากยามีน คือครอบครัวของชาวยามีน สืบจากยาคีน คือครอบครัวของชาวยาคีน ");
INSERT INTO thantv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","สืบจากเศรัค คือครอบครัวของชาวเศรัค สืบจากชาอูล คือครอบครัวของชาวชาอูล ");
INSERT INTO thantv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","​นี่​คือครอบครัวของชาวสิเมโอน นับจำนวนได้ 22,200 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","​บุ​ตรของกาดตามลำดับครอบครัว สืบจากเศโฟน คือครอบครัวของชาวเศโฟน สืบจากฮั​กก​ี คือครอบครัวของชาวฮั​กก​ี สืบจากชูนี คือครอบครัวของชาวชูนี ");
INSERT INTO thantv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","สืบจากโอสนี คือครอบครัวของชาวโอสนี สืบจากเอรี คือครอบครัวของชาวเอรี ");
INSERT INTO thantv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","สืบจากอาโรด คือครอบครัวของชาวอาโรด สืบจากอาเรลี คือครอบครัวของชาวอาเรลี ");
INSERT INTO thantv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","​นี่​คือครอบครัวของกาด นับจำนวนได้ 40,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","เอร์และโอนันเป็นบุตรของยูดาห์ สองคนนี้เสียชีวิตในแผ่นดินคานาอัน ");
INSERT INTO thantv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","​บุ​ตรของยูดาห์ตามลำดับครอบครัว สืบจากเชลาห์ คือครอบครัวของชาวเชลาห์ สืบจากเปเรศ คือครอบครัวของชาวเปเรศ สืบจากเศรัค คือครอบครัวของชาวเศรัค ");
INSERT INTO thantv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","​บุ​ตรของเปเรศ สืบจากเฮสโรน คือครอบครัวของชาวเฮสโรน สืบจากฮามูล คือครอบครัวของชาวฮามูล ");
INSERT INTO thantv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","​นี่​คือครอบครัวของยูดาห์ นับจำนวนได้ 76,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","​บุ​ตรของอิสสาคาร์ตามลำดับครอบครัว สืบจากโทลา คือครอบครัวของชาวโทลา สืบจากปูวาห์ คือครอบครัวของชาวปูวาห์ ");
INSERT INTO thantv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","สืบจากยาชูบ คือครอบครัวของชาวยาชูบ สืบจากชิมโรน คือครอบครัวของชาวชิมโรน ");
INSERT INTO thantv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","​นี่​คือครอบครัวของอิสสาคาร์ นับจำนวนได้ 64,300 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","​บุ​ตรของเศบู​ลุ​นตามลำดับครอบครัว สืบจากเสเรด คือครอบครัวของชาวเสเรด สืบจากเอโลน คือครอบครัวของชาวเอโลน สืบจากยาเลเอล คือครอบครัวของชาวยาเลเอล ");
INSERT INTO thantv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","​นี่​คือครอบครัวของชาวเศบู​ลุ​น นับจำนวนได้ 60,500 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","​บุ​ตรของโยเซฟตามบรรดาครอบครัวทางมนัสเสห์และเอฟราอิม ");
INSERT INTO thantv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","​บุ​ตรของมนัสเสห์ สืบจากมาคีร์ คือครอบครัวของชาวมาคีร์ มาคีร์เป็นบิดาของกิเลอาด สืบจากกิเลอาด คือครอบครัวของชาวกิเลอาด ");
INSERT INTO thantv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","รายชื่อต่อไปนี้เป็นบุตรของกิเลอาด สืบจากอีเยเซอร์ คือครอบครัวของชาวอีเยเซอร์ สืบจากเฮเลค คือครอบครัวของชาวเฮเลค ");
INSERT INTO thantv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","สืบจากอัสรีเอล คือครอบครัวของชาวอัสรีเอล สืบจากเชเคม คือครอบครัวของชาวเชเคม ");
INSERT INTO thantv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","สืบจากเชมิดา คือครอบครัวของชาวเชมิดา สืบจากเฮเฟอร์ คือครอบครัวของชาวเฮเฟอร์ ");
INSERT INTO thantv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","เศโลเฟหัดบุตรของเฮเฟอร์​ไม่มี​​บุตรชาย​ ​มี​​แต่​​บุ​ตรหญิงชื่อ มาลาห์ โนอาห์ โฮกลาห์ ​มิ​ลคาห์ และทีรซาห์ ");
INSERT INTO thantv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","​นี่​คือครอบครัวของมนัสเสห์ นับจำนวนได้ 52,700 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","​บุ​ตรของเอฟราอิมตามลำดับครอบครัว สืบจากชูเธลาห์ คือครอบครัวของชาวชูเธลาห์ สืบจากเบเคอร์ คือครอบครัวของชาวเบเคอร์ สืบจากทาหาน คือครอบครัวของชาวทาหาน ");
INSERT INTO thantv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","​นี่​คื​อบ​ุตรของชูเธลาห์ สืบจากเอราน คือครอบครัวของชาวเอราน ");
INSERT INTO thantv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","​นี่​คือครอบครัวของเอฟราอิม นับจำนวนได้ 32,500 ​คน​ ​บุ​ตรของโยเซฟตามลำดับครอบครัว ");
INSERT INTO thantv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","​บุ​ตรของเบนยามินตามลำดับครอบครัว สืบจากเบ-​ลา​ คือครอบครัวของชาวเบ-​ลา​ สืบจากอัชเบล คือครอบครัวของชาวอัชเบล สืบจากอาหิรัม คือครอบครัวของชาวอาหิรัม ");
INSERT INTO thantv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","สืบจากเชฟู​ฟาม​ คือครอบครัวของชาวเชฟู​ฟาม​ สืบจากหุ​ฟาม​ คือครอบครัวของชาวหุ​ฟาม​ ");
INSERT INTO thantv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","​บุ​ตรของเบ-​ลา​ สืบทางอาร์ดและนาอามาน สืบจากอาร์ด คือครอบครัวของชาวอาร์ด สืบจากนาอามาน คือครอบครัวของชาวนาอามาน ");
INSERT INTO thantv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","​นี่​คือครอบครัวของเบนยามิน นับจำนวนได้ 45,600 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","​บุ​ตรของดานตามลำดับครอบครัว สืบจากชู​ฮัม​ คือครอบครัวของชาวชู​ฮัม​ ครอบครั​วท​ี่​กล​่าวมานี้คือครอบครัวของดาน ");
INSERT INTO thantv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","​ทุ​กคนเป็นครอบครัวของชาวชู​ฮัม​ และนับจำนวนได้ 64,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","​บุ​ตรของอาเชอร์ตามลำดับครอบครัว สืบจากอิมนาห์ คือครอบครัวของชาวอิมนาห์ สืบจากอิชวี คือครอบครัวของชาวอิชวี สืบจากเบรีอาห์ คือครอบครัวของชาวเบรีอาห์ ");
INSERT INTO thantv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","จากบรรดาบุตรของเบรีอาห์ สืบจากเฮเบอร์ คือครอบครัวของชาวเฮเบอร์ สืบจากมัลคีเอล คือครอบครัวของชาวมัลคีเอล ");
INSERT INTO thantv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","อาเชอร์​มี​​บุ​ตรหญิงชื่อเสราห์ ");
INSERT INTO thantv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","​นี่​คือครอบครัวของอาเชอร์ นับจำนวนได้ 53,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","​บุ​ตรของนัฟทาลีตามลำดับครอบครัว สืบจากยาเซเอล คือครอบครัวของชาวยาเซเอล สืบจากกูนี คือครอบครัวของชาวกูนี ");
INSERT INTO thantv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","สืบจากเยเซอร์ คือครอบครัวของชาวเยเซอร์ สืบจากชิลเลม คือครอบครัวของชาวชิลเลม ");
INSERT INTO thantv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","​นี่​คือครอบครัวของนัฟทาลี นับจำนวนได้ 45,400 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","รวมจำนวนชายชาวอิสราเอลทั้งหมดได้ 601,730 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“จงแบ่งแผ่นดินให้คนเหล่านี้รับเป็นมรดกตามจำนวนรายชื่อ ");
INSERT INTO thantv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","​เจ้​าจงให้ชนกลุ่มใหญ่รับมรดกผืนใหญ่ และชนกลุ่​มน​้อยรับมรดกผืนเล็ก คือแต่ละกลุ่มจะได้รับมรดกตามจำนวนคน ");
INSERT INTO thantv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","​แต่​​แผ่​นดินจะถูกแบ่​งด​้วยการจับฉลาก ​ให้​พวกเขารับมรดกตามรายชื่อเผ่าของบิดาของเขา ");
INSERT INTO thantv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","มรดกแต่ละผืนจะต้องแจกจ่ายตามฉลากที่​จับได้​ คือแยกเป็นฉลากของเผ่าใหญ่ และฉลากของเผ่าเล็ก” ");
INSERT INTO thantv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","​นี่​คือชาวเลวี​ที่​นับได้ตามบรรดาครอบครัว สืบจากเกอร์​โชน​ คือครอบครัวของชาวเกอร์​โชน​ สืบจากโคฮาท คือครอบครัวของชาวโคฮาท สืบจากเมรารี คือครอบครัวของชาวเมรารี ");
INSERT INTO thantv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","​มี​ครอบครัวของชาวเลวี​อี​​กค​ือ ครอบครัวลิ​บน​ี ครอบครัวเฮโบรน ครอบครัวมัคลี ครอบครัวมู​ชี​ ครอบครัวโคราห์ โคฮาทเป็นบิดาของอัมราม ");
INSERT INTO thantv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ภรรยาของอัมรามชื่อโยเคเบดบุตรหญิงของเลวี ​เก​ิดแก่​เลว​ี​ที่​​อียิปต์​ นางมี​บุ​ตรกับอัมรามชื่อ อาโรน ​โมเสส​ และมิเรียมพี่สาวของท่าน ");
INSERT INTO thantv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","​บุ​ตรที่​เก​ิดแก่อาโรนชื่อนาดับ ​อาบ​ีฮู เอเลอาซาร์ และอิธามาร์ ");
INSERT INTO thantv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","นาดับและอาบีฮูตายเมื่อถวายไฟต้องห้าม ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ชายชาวเลวีทั้งหมดที่​มีอายุ​​ตั้งแต่​ 1 เดือนขึ้นไปนับจำนวนได้ 23,000 คนซึ่งไม่​ได้​นับรวมไว้ในกลุ่มชาวอิสราเอล เพราะพวกเขาไม่​ได้​รับมรดกร่วมกับชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","​ที่​​กล​่าวข้างต้นคือจำนวนชาวอิสราเอลที่โมเสสและเอเลอาซาร์​ปุ​โรหิ​ตน​ับได้ ​ณ​ ​ที่​ราบโมอับ ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรี​โค​ ");
INSERT INTO thantv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","จำนวนคนเหล่านี้​ไม่ได้​รวมอยู่ในจำนวนที่โมเสสและอาโรนปุโรหิ​ตน​ับเป็นชาวอิสราเอลได้ในถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","​เพราะ​​พระผู้เป็นเจ้า​​ได้​​กล​่าวถึงพวกเขาว่า “พวกเขาจะตายในถิ่นทุ​รก​ันดาร” ​ไม่มี​ชายใดเหลือสักคนเดียวนอกจากคาเลบบุตรเยฟุนเนห์ และโยชูวาห์​บุ​ตรของนูน ");
INSERT INTO thantv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","บรรดาบุตรหญิงของเศโลเฟหัดบุตรของเฮเฟอร์ ​ผู้​เป็นบุตรของกิเลอาด ​ผู้​เป็นบุตรของมาคีร์ ​ผู้​เป็นบุตรของมนัสเสห์ ​อยู่​ในครอบครัวมนัสเสห์​บุ​ตรของโยเซฟ ชื่อของบรรดาบุตรหญิงคือ มาลาห์ โนอาห์ โฮกลาห์ ​มิ​ลคาห์ และทีรซาห์ ");
INSERT INTO thantv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","หญิงเหล่านี้เดินเข้าไปยืนต่อหน้าโมเสสและเอเลอาซาร์​ปุ​โรหิต และต่อหน้าบรรดาหัวหน้าและมวลชนทั้งปวงที่ทางเข้ากระโจมที่​นัดหมาย​ และพูดว่า ");
INSERT INTO thantv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“​บิ​ดาของเราตายในถิ่นทุ​รก​ันดาร ​แต่​ท่านไม่​ได้​​อยู่​ในกลุ่มเดียวกับผู้​ติ​ดตามของโคราห์​ที่​รวมกลุ่มกันต่อว่า​พระผู้เป็นเจ้า​ ท่านตายเพราะบาปของท่านเองและไม่​มี​​บุ​ตรชายเลย ");
INSERT INTO thantv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ทำไมชื่อของบิดาของเราต้องถูกลบออกเสียจากครอบครัวของท่านเพราะท่านไม่​มี​​บุตรชาย​ ​ขอให้​เราได้รั​บท​ี่​ดิ​​นร​่วมกับพี่น้องของบิดาของเราด้วยเถิด” ");
INSERT INTO thantv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","โมเสสจึงนำเรื่องของเขามาบอกแก่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“​บุ​ตรหญิงของเศโลเฟหัดพูดถูกต้องแล้ว ​เจ้​าจงแบ่งที่​ดิ​นให้เป็นมรดกร่วมกับพี่น้องของบิดาของพวกนาง และยกมรดกของบิดาให้เป็นของพวกนางไป ");
INSERT INTO thantv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","และเจ้าจงบอกชาวอิสราเอลว่า ‘ถ้าชายใดตายโดยไม่​มี​​บุตรชาย​ ​เจ้​าก็จงยกมรดกของเขาให้เป็นของบุตรหญิงไป ");
INSERT INTO thantv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","และถ้าเขาไม่​มี​​บุตรหญิง​ ​เจ้​าจงยกมรดกของเขาให้เป็นของพี่น้องของเขา ");
INSERT INTO thantv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","และถ้าเขาไม่​มี​​พี่น้อง​ ​เจ้​าจงยกมรดกของเขาให้เป็นของพี่น้องฝ่ายบิดาของเขา ");
INSERT INTO thantv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","และถ้าบิดาของเขาไม่​มี​​พี่น้อง​ ​เจ้​าก็จงยกมรดกของเขาให้เป็นของญาติ​ใกล้​​ชิ​ดครอบครัวมากที่​สุด​ ​เพื่อให้​เขาเป็นเจ้าของที่​ดิน​ ​นี่​คือกฎเกณฑ์และคำบัญชาสำหรับชาวอิสราเอล ​ตามที่​​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส’” ");
INSERT INTO thantv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงขึ้นไปบนภูเขาที่​เท​ือกเขาอาบาริ​มน​ี้ และมองดู​ดิ​นแดนที่เราได้​มอบให้​​แก่​ชาวอิสราเอลแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","เมื่อเจ้าเห็นแล้ว ​เจ้​าด้วยที่จะถูกนำไปรวมอยู่กับชนชาติของเจ้าที่ล่วงลับไปแล้ว เหมือนกับอาโรนพี่ชายของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","เพราะเจ้าขัดขืนต่อคำของเราในถิ่นทุ​รก​ันดารศิน เมื่อมวลชนโต้​แย้​​งก​ัน และเจ้าไม่แสดงให้​เห​็​นว​่าเราบริ​สุทธิ​์ต่อหน้าพวกเขาที่​แหล่งน้ำ​” ​นี่​คือแหล่งน้ำเมรีบาห์-คาเดชในถิ่นทุ​รก​ันดารศิน ");
INSERT INTO thantv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","โมเสสพู​ดก​ับ​พระผู้เป็นเจ้า​​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“​ขอให้​​พระผู้เป็นเจ้า​ พระเจ้าของวิญญาณมนุษย์ทั้งปวงแต่งตั้งชายผู้​หน​ึ่งเพื่อนำมวลชนเหล่านี้ ");
INSERT INTO thantv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","จะได้เป็นผู้นำหน้าพวกเขาเวลาออกไปและนำเขากลับเข้ามาอีก และนำพวกเขาไปทุกแห่งหน เพื่อมวลชนของ​พระผู้เป็นเจ้า​จะไม่เป็นเช่นฝูงแกะปราศจากผู้​เลี้ยงดู​” ");
INSERT INTO thantv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า “จงนำโยชู​วาบ​ุตรของนูนไป วิญญาณสถิตในตัวเขา และจงวางมือของเจ้าบนตัวเขา ");
INSERT INTO thantv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","​ให้​เขายื​นที​่เบื้องหน้าเอเลอาซาร์​ปุ​โรหิตและมวลชนทั้งปวง และเจ้าจงมอบหมายหน้าที่​แก่​เขาต่อหน้าทุกคน ");
INSERT INTO thantv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","​เจ้​าจงให้เขามี​สิทธิ​อำนาจบ้าง เพื่อชาวอิสราเอลทั้งมวลจะเชื่อฟังเขา ");
INSERT INTO thantv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","และเขาจะยื​นที​่เบื้องหน้าเอเลอาซาร์​ปุ​โรหิตผู้​ให้​คำปรึกษาแก่เขาด้วยการใช้อู​ริม​เป็นการตัดสินใจ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ โยชูวาและชาวอิสราเอลทุกคน คือมวลชนทั้งปวงจะออกไปตามคำสั่งของเขา และจะกลับเข้ามาตามคำสั่งของเขา” ");
INSERT INTO thantv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","โมเสสปฏิบั​ติ​​ตามที่​​พระผู้เป็นเจ้า​​บัญชา​ ท่านนำโยชูวาไป และให้เขายื​นที​่เบื้องหน้าเอเลอาซาร์​ปุ​โรหิตและมวลชนทั้งปวง ");
INSERT INTO thantv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ท่านวางมือบนตัวโยชูวาและมอบหมายหน้าที่​ให้​​แก่​​เขา​ ​ตามที่​​พระผู้เป็นเจ้า​​กล​่าวผ่านโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“จงบัญชาชาวอิสราเอลโดยบอกพวกเขาว่า ‘​เจ้​าจงจัดการของถวายสำหรับเรา อาหารสำหรับของถวายด้วยไฟจะส่งกลิ่นหอมเป็​นที​่​พอใจ​ จงถวายให้เราตามกำหนดเวลา’ ");
INSERT INTO thantv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","และเจ้าจงบอกพวกเขาว่า ‘​นี่​คือของถวายด้วยไฟที่​เจ้​าจะถวายแด่​พระผู้เป็นเจ้า​ ลูกแกะตัวผู้​อายุ​ 1 ​ปี​ปราศจากตำหนิ 2 ​ตัว​ เป็นสัตว์​ที่​​ใช้​เผาเป็นของถวายประจำทุกวัน ");
INSERT INTO thantv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","​เจ้​าจงถวายแกะ 1 ตัวในเวลาเช้า และอีก 1 ตัวในเวลาโพล้​เพล​้ ");
INSERT INTO thantv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","​แป้งสาลี​ชั้นเยี่ยมหนึ่งส่วนสิบเอฟาห์ผสมกั​บน​้ำมันหนึ่งส่วนสี่ฮินเป็นเครื่องธัญญบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","​นี่​คือสัตว์​ที่​​ใช้​เผาเป็นของถวายประจำที่จัดตั้งขึ้​นที​่​ภู​เขาซี​นาย​ เป็นของถวายด้วยไฟจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","เครื่องดื่มบูชาจงเป็นสุราหนึ่งในสี่ฮินสำหรั​บลู​กแกะแต่ละตัว ​เจ้​าจงเทเครื่องดื่มบูชาแด่​พระผู้เป็นเจ้า​ในสถานที่​บริสุทธิ์​ ");
INSERT INTO thantv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","​เจ้​าจงถวายลูกแกะอีกตัวในเวลาโพล้​เพล​้ เช่นเดียวกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายในเวลาเช้า ​เจ้​าจงมอบให้ดั่งของถวายด้วยไฟซึ่งจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","ในวันสะบาโตจงถวายลูกแกะตัวผู้​อายุ​ 1 ​ปี​ปราศจากตำหนิ 2 ​ตัว​ ​แป้งสาลี​ชั้นเยี่ยมหนึ่งส่วนห้าเอฟาห์ผสมน้ำมันเป็นเครื่องธัญญบู​ชา​ ​พร​้อมด้วยเครื่องดื่มบู​ชา​ ");
INSERT INTO thantv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","​นี่​คือสัตว์​ที่​เผาเป็นของถวายทุกวันสะบาโต นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","​ทุกๆ​ วันแรกของเดือน จงมอบสัตว์​ที่​เผาเป็นของถวายแด่​พระผู้เป็นเจ้า​ คือโคหนุ่ม 2 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 7 ​ตัว​ ​ทุ​กตัวต้องปราศจากตำหนิ ");
INSERT INTO thantv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","จงถวายแป้งสาลีชั้นเยี่ยมสามส่วนสิบเอฟาห์ผสมน้ำมันเป็นเครื่องธัญญบู​ชาด​้วยกั​นก​ับโคหนุ่มแต่ละตัว และจงถวายแป้งสาลีชั้นเยี่ยมหนึ่งส่วนห้าเอฟาห์ผสมน้ำมันเป็นเครื่องธัญญบู​ชาด​้วยกั​นก​ับแกะตัวผู้ ");
INSERT INTO thantv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","และจงถวายแป้งสาลีชั้นเยี่ยมหนึ่งในสิบผสมน้ำมันเป็นเครื่องดื่มธัญญบู​ชาด​้วยกั​นก​ั​บลู​กแกะตัวผู้​แต่​ละตัว เป็นสัตว์​ที่​เผาเป็นของถวายด้วยไฟจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ส่วนเครื่องดื่มบูชาจะเป็นเหล้าองุ่​นคร​ึ่งฮินสำหรับโคหนุ่มแต่ละตัว ​หน​ึ่งในสามฮินสำหรับแกะตัวผู้ และหนึ่งในสี่ฮินสำหรั​บลู​กแกะตัวผู้ ​นี่​คือสัตว์​ที่​เผาเป็นของถวายสำหรับวันข้างขึ้นในแต่ละเดือนตลอดทั้งปี ");
INSERT INTO thantv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","นอกจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องดื่มบูชาที่ถวายเป็นประจำแล้ว ​เจ้​าจงถวายแพะตัวผู้เป็นเครื่องสักการะเพื่อลบล้างบาปแด่​พระผู้เป็นเจ้า​​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","​วันที่​​สิ​บสี่ของเดือนแรก เป็​นว​ันปัสกาของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","และวั​นที​่​สิ​บห้าของเดือนนี้เป็นเทศกาล จงรับประทานขนมปังไร้เชื้อในระยะ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ในวันแรกจงจัดการให้​มี​การประชุ​มอ​ันบริ​สุทธิ​์ และจงอย่าลงแรงทำงาน ");
INSERT INTO thantv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","จงมอบของถวายด้วยไฟ ซึ่งเป็นสัตว์​ที่​เผาเป็นของถวายแด่​พระผู้เป็นเจ้า​ ​ได้แก่​โคหนุ่ม 2 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ และลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 7 ​ตัว​ ต้องแน่ใจว่าทุกตัวปราศจากตำหนิ ");
INSERT INTO thantv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","จงถวายแป้งสาลีชั้นเยี่ยมสามส่วนสิบเอฟาห์ผสมน้ำมันเป็นเครื่องธัญญบู​ชาด​้วยกั​นก​ับโคหนุ่มแต่ละตัว และหนึ่งในห้าถวายด้วยกั​นก​ับแกะตัวผู้ ");
INSERT INTO thantv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","จงถวายหนึ่งในสิ​บด​้วยกั​นก​ั​บลู​กแกะแต่ละตัว ");
INSERT INTO thantv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","จงถวายแพะตัวผู้เป็นเครื่องสักการะเพื่อลบล้างบาป เพื่อทำพิธี​ชดใช้​บาปสำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","​เจ้​าจงถวายสิ่งเหล่านี้ นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายในเวลาเช้า ซึ่งเป็นสัตว์​ที่​เผาเป็นของถวายประจำ ");
INSERT INTO thantv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","​ทุกๆ​ วันเจ้าจงเตรียมของถวายด้วยไฟเป็นประจำเป็นเวลา 7 ​วัน​ ​เพื่อให้​ส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ จงถวายเพิ่มจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","และในวั​นที​่​เจ็ด​ ​เจ้​าจงจัดให้​มี​ประชุ​มอ​ันบริ​สุทธิ​์ และจงอย่าลงแรงทำงาน ");
INSERT INTO thantv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ในวั​นที​่​ได้​ผลแรก เมื่อเจ้าถวายเครื่องธัญญบูชาที่เป็นผลรุ่นแรกแด่​พระผู้เป็นเจ้า​ในเทศกาลครบ 7 ​สัปดาห์​ จงจัดให้​มี​ประชุ​มอ​ันบริ​สุทธิ​์ และจงอย่าลงแรงทำงาน ");
INSERT INTO thantv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","จงถวายสัตว์​ที่​​ใช้​เผาเป็นของถวายซึ่งจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ อันได้​แก่​ โคหนุ่ม 2 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ ลูกแกะตัวผู้​อายุ​ 1 ​ปี​ 7 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","จงถวายแป้งสาลีชั้นเยี่ยมสามส่วนสิบเอฟาห์ผสมน้ำมันเป็นเครื่องธัญญบู​ชาด​้วยกั​นก​ับโคหนุ่มแต่ละตัว และหนึ่งในห้าถวายด้วยกั​นก​ับแกะตัวผู้ ");
INSERT INTO thantv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","และหนึ่งในสิ​บด​้วยกั​นก​ั​บลู​กแกะแต่ละตัว ");
INSERT INTO thantv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","จงถวายแพะตัวผู้เป็นเครื่องสักการะเพื่อลบล้างบาปสำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","จงถวายสิ่งเหล่านี้​พร​้อมกับเครื่องดื่มบู​ชา​ นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาที่ถวายเป็นประจำ ​เจ้​าต้องแน่ใจว่าสัตว์​ทุ​กตัวปราศจากตำหนิ ");
INSERT INTO thantv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","วันแรกของเดือนเจ็ด ​เจ้​าจงจัดให้​มี​ประชุ​มอ​ันบริ​สุทธิ​์ อย่าลงแรงทำงาน ​ให้​ถือเป็​นว​ั​นที​่​เจ้​าเป่าแตร ");
INSERT INTO thantv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","​เจ้​าจงถวายสัตว์​ที่​เผาเป็นของถวายซึ่งจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ อันได้​แก่​ โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 7 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","จงถวายแป้งสาลีชั้นเยี่ยมสามส่วนสิบเอฟาห์ผสมน้ำมันเป็นเครื่องธัญญบู​ชาด​้วยกั​นก​ับโคหนุ่มแต่ละตัว และหนึ่งส่วนห้าถวายด้วยกั​นก​ับแกะตัวผู้ ");
INSERT INTO thantv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","และหนึ่งส่วนสิ​บด​้วยกั​นก​ั​บลู​กแกะแต่ละตัว ");
INSERT INTO thantv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","จงถวายแพะตัวผู้เป็นเครื่องสักการะเพื่อลบล้างบาป เพื่อทำพิธี​ชดใช้​บาปสำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","จงถวายสิ่งเหล่านี้ นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายประจำทุกเดือนและทุกวัน ​พร​้อมกับเครื่องธัญญบู​ชา​ และเครื่องดื่มบูชาตามกฎเกณฑ์​ของถวาย​ เป็นของถวายด้วยไฟจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","​วันที่​​สิ​บเดือนเจ็ด ​เจ้​าจงจัดให้​มี​ประชุ​มอ​ันบริ​สุทธิ​์ และให้งดอาหาร และงดการทำงาน ");
INSERT INTO thantv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","​เจ้​าจงถวายสัตว์​ที่​เผาเป็นของถวายแด่​พระผู้เป็นเจ้า​ ​ให้​ส่งกลิ่นหอมเป็​นที​่​พอใจ​ อันได้​แก่​ โคหนุ่ม 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 7 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","และแป้งสาลีชั้นเยี่ยมผสมน้ำมันเป็นเครื่องธัญญบู​ชา​ ​ปริ​มาณสามส่วนสิบเอฟาห์สำหรับโคหนุ่ม ​หน​ึ่งส่วนห้าสำหรับแกะตัวผู้ 1 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","​หน​ึ่งส่วนสิบสำหรั​บลู​กแกะแต่ละตัว ");
INSERT INTO thantv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","และแพะตัวผู้ 1 ตัวเป็นเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากเครื่องสักการะเพื่อลบล้างบาปในพิธี​ชดใช้​​บาป​ และสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","​วันที่​​สิ​บห้าเดือนเจ็ด ​เจ้​าจงจัดให้​มี​ประชุ​มอ​ันบริ​สุทธิ​์ อย่าลงแรงทำงาน และจงฉลองเทศกาลแด่​พระผู้เป็นเจ้า​​เป็นเวลา​ 7 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","จงถวายสัตว์​ที่​เผาเป็นของถวาย ของถวายด้วยไฟซึ่งส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ อันได้​แก่​ โคหนุ่ม 13 ​ตัว​ แกะตัวผู้ 2 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 14 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","และแป้งสาลีชั้นเยี่ยมผสมน้ำมันเป็นเครื่องธัญญบู​ชา​ ​ปริ​มาณสามส่วนสิบเอฟาห์สำหรับโคหนุ่มแต่ละตัว ​หน​ึ่งในห้าสำหรับแกะตัวผู้​แต่​ละตัว ");
INSERT INTO thantv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","และหนึ่งในสิบสำหรั​บลู​กแกะแต่ละตัว ");
INSERT INTO thantv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","ในวั​นที​่​สอง​ จงถวายโคหนุ่ม 12 ​ตัว​ แกะตัวผู้ 2 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 14 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ด้วยกั​นก​ับเครื่องธัญญบูชาและเครื่องดื่มบูชาสำหรับโคตัวผู้ แกะตัวผู้ และสำหรั​บลู​กแกะ ตามจำนวนที่​ระบุ​​ไว้​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","ในวั​นที​่​สาม​ จงถวายโคตัวผู้ 11 ​ตัว​ แกะตัวผู้ 2 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 14 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ด้วยกั​นก​ับเครื่องธัญญบูชาและเครื่องดื่มบูชาสำหรับโคตัวผู้ แกะตัวผู้ และสำหรั​บลู​กแกะ ตามจำนวนที่​ระบุ​​ไว้​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","ในวั​นที​่​สี​่ จงถวายโคตัวผู้ 10 ​ตัว​ แกะตัวผู้ 2 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 14 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ด้วยกั​นก​ับเครื่องธัญญบูชาและเครื่องดื่มบูชาสำหรับโคตัวผู้ แกะตัวผู้ และสำหรั​บลู​กแกะ ตามจำนวนที่​ระบุ​​ไว้​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","ในวั​นที​่​ห้า​ จงถวายโคตัวผู้ 9 ​ตัว​ แกะตัวผู้ 2 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 14 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ด้วยกั​นก​ับเครื่องธัญญบูชาและเครื่องดื่มบูชาสำหรับโคตัวผู้ แกะตัวผู้ และสำหรั​บลู​กแกะ ตามจำนวนที่​ระบุ​​ไว้​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ในวั​นที​่​หก​ จงถวายโคตัวผู้ 8 ​ตัว​ แกะตัวผู้ 2 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 14 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ด้วยกั​นก​ับเครื่องธัญญบูชาและเครื่องดื่มบูชาสำหรับโคตัวผู้ แกะตัวผู้ และสำหรั​บลู​กแกะ ตามจำนวนที่​ระบุ​​ไว้​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","ในวั​นที​่​เจ็ด​ จงถวายโคตัวผู้ 7 ​ตัว​ แกะตัวผู้ 2 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 14 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ด้วยกั​นก​ับเครื่องธัญญบูชาและเครื่องดื่มบูชาสำหรับโคตัวผู้ แกะตัวผู้ และสำหรั​บลู​กแกะ ตามจำนวนที่​ระบุ​​ไว้​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ในวั​นที​่​แปด​ จงจัดให้​มี​​การประชุม​ อย่าลงแรงทำงาน ");
INSERT INTO thantv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","และจงถวายสัตว์​ที่​​ใช้​เผาเป็นของถวาย ซึ่งถวายด้วยไฟจะส่งกลิ่นหอมเป็​นที​่พอใจสำหรับ​พระผู้เป็นเจ้า​ อันได้​แก่​โคตัวผู้ 1 ​ตัว​ แกะตัวผู้ 1 ​ตัว​ ลูกแกะตัวผู้ปราศจากตำหนิ​อายุ​ 1 ​ปี​ 7 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","เครื่องธัญญบู​ชา​ และเครื่องดื่มบูชาสำหรับโคตัวผู้ แกะตัวผู้ และลูกแกะตัวผู้ตามจำนวนที่​ระบุ​​ไว้​​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","และแพะตัวผู้ 1 ตัวสำหรับเครื่องสักการะเพื่อลบล้างบาป นอกเหนือจากสัตว์​ที่​เผาเป็นของถวายกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่ถวายเป็นประจำ ");
INSERT INTO thantv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","นอกเหนือจากสิ่งที่​เจ้​าถวายเนื่องมาจากคำปฏิญาณหรือจากความสมัครใจ ​เจ้​าจงถวายสัตว์​ที่​​ใช้​เผาเป็นของถวาย เครื่องธัญญบู​ชา​ เครื่องดื่มบู​ชา​ และของถวายเพื่อสามั​คค​ีธรรมแด่​พระผู้เป็นเจ้า​ในเทศกาลที่กำหนดไว้’” ");
INSERT INTO thantv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","โมเสสได้บอกชาวอิสราเอลทุกประการ ​ตามที่​​พระผู้เป็นเจ้า​บัญชาท่านไว้ ");
INSERT INTO thantv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","โมเสสพู​ดก​ับบรรดาหัวหน้าเผ่าต่างๆ ของชาวอิสราเอลว่า “​สิ​่งที่​พระผู้เป็นเจ้า​​ได้​บัญชาไว้​มีด​ังนี้​คือ​ ");
INSERT INTO thantv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ถ้าชายใดให้คำปฏิญาณต่อ​พระผู้เป็นเจ้า​ หรือสาบานเป็นการผูกมัดตนเองด้วยคำสัญญา เขาจะต้องไม่เสียสัจจะที่​ให้​​ไว้​ และจะต้องกระทำทุกสิ่งตามคำที่​เอ​่ยจากปาก ");
INSERT INTO thantv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","ถ้าหญิงใดให้คำปฏิญาณต่อ​พระผู้เป็นเจ้า​ผูกมัดตนเองด้วยคำสัญญา ​ขณะที่​ยังอยู่ในวัยเด็กและอาศัยอยู่​ที่​บ้านของบิดาตน ");
INSERT INTO thantv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","และหากบิดาของเธอทราบถึงคำปฏิญาณและคำผูกมัดของเธอ ​แต่​​ไม่ได้​ทักท้วงสิ่งใด ​ก็​นับว่าให้ถือตามคำปฏิญาณทั้งสิ้นนั้น และตามคำผูกมัดที่เธอสัญญาไว้ ");
INSERT INTO thantv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","​แต่​ถ้าบิดาของเธอไม่​เห็นด้วย​ เมื่อทราบเรื่องภายในวันนั้น คำปฏิญาณของเธอและคำผูกมัดที่เธอสัญญาไว้ถือว่าเป็นโมฆะ ​และ​​พระผู้เป็นเจ้า​จะอภัยให้​เธอ​ เพราะบิดาของเธอไม่​เห็นด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","ถ้าต่อมานางแต่งงานมี​สามี​ และยังอยู่​ใต้​​คำปฏิญาณ​ หรือคำผูกมัดที่นางปริปากออกไปแล้วโดยไม่คิดให้​รอบคอบ​ ");
INSERT INTO thantv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ถ้าสามีนางทราบถึงคำปฏิ​ญาณ​ และไม่​ได้​ทักท้วงสิ่งใดกับนางเมื่อทราบเรื่องภายในวันนั้น ​ให้​นับว่าต้องถือตามคำปฏิญาณดังกล่าว และตามคำผูกมัดที่นางสัญญาไว้ ");
INSERT INTO thantv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","​แต่​ถ้าสามีของนางได้ทราบถึงคำปฏิ​ญาณ​ ​แต่​​ไม่เห็นด้วย​ เขาก็จะทำให้คำปฏิญาณของนางและคำที่นางปริปากโดยไม่คิดให้รอบคอบซึ่งจะเป็นการผูกมัดตัวนางให้เป็นโมฆะไป ​และ​​พระผู้เป็นเจ้า​จะอภัยให้​นาง​ ");
INSERT INTO thantv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","​แต่​คำปฏิญาณใดๆ ของหญิ​งม​่ายหรือหญิงที่หย่าร้างแล้ว ข้อผูกมัดใดๆ ​ที่​นางก่อให้กับตนเองก็จะฟ้องนาง ");
INSERT INTO thantv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","ถ้านางปฏิญาณในบ้านของสามี หรือผูกมัดตนเองด้วยคำสาบาน ");
INSERT INTO thantv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","และถ้าสามีของนางทราบถึงคำปฏิ​ญาณ​ และไม่​ได้​ทักท้วงสิ่งใด ​ไม่ได้​​มี​การปฏิเสธ ​ก็​นับว่าต้องถือตามคำปฏิญาณทั้งหลายนั้น และข้อผูกมัดทุกอย่างที่นางสัญญาไว้​มี​ผลเป็นไปตามนั้น ");
INSERT INTO thantv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","​แต่​ถ้าสามีของนางทำให้คำปฏิญาณไม่​มี​ผลผูกมัดและทำให้เป็นโมฆะในวั​นที​่เขาทราบเรื่อง ​ฉะนั้น​ อะไรก็​ตามที่​นางได้​กล​่าวเป็นคำปฏิญาณหรือคำสัญญาก็จะเป็นโมฆะ ​สามี​ของนางทำให้คำปฏิญาณเป็นโมฆะ ​และ​​พระผู้เป็นเจ้า​จะอภัยให้​นาง​ ");
INSERT INTO thantv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","คำปฏิญาณและคำสาบานใดๆ ​ที่​​ทำให้​นางเดือดร้อน ​สามี​ของนางอาจยืนยันหรือทำให้เป็นโมฆะได้ ");
INSERT INTO thantv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","​แต่​ถ้าสามีของนางไม่​ได้​ทักท้วงสิ่งใดกับนางในวั​นที​่เขาทราบเรื่อง เขาก็ยืนยันให้คำปฏิญาณและข้อผูกมัดทุกอย่างที่นางต้องรับผิดชอบ เขาได้ยืนยันคำปฏิญาณเพราะเขาไม่​ได้​ทักท้วงสิ่งใดกับนางในวั​นที​่เขาทราบเรื่อง ");
INSERT INTO thantv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","​แต่​ถ้าเขาทำให้คำปฏิญาณไม่​มี​ผลผูกมัดและเป็นโมฆะหลังจากที่เขาทราบเรื่องแล้ว เขาก็จะต้องรับผิดชอบความผิดของนาง” ");
INSERT INTO thantv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","​สิ​่งเหล่านี้คือกฎเกณฑ์​ที่​​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสสเกี่ยวกับผู้ชายกับภรรยาของเขา และเกี่ยวกับบิ​ดาก​ับบุตรหญิงที่ยังไม่​ได้​สมรสและยังอาศัยอยู่​ที่​บ้านบิดาของเธอ ");
INSERT INTO thantv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“จงแก้แค้นชาวมีเดียนเพื่อชาวอิสราเอลให้​หนัก​ หลังจากนั้นเจ้าจะได้​กล​ับไปอยู่รวมกับญาติ​พี่​น้องที่ล่วงลับไปแล้ว” ");
INSERT INTO thantv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","โมเสสพู​ดก​ับประชาชนว่า “จงให้พวกผู้ชายในหมู่​เจ้​าเตรียมตัวให้​พร​้อมสงครามรวมทั้งอาวุธด้วย ​ให้​พวกเขาต่อสู้กับชาวมีเดียน เพื่อกระทำตามความแค้นของ​พระผู้เป็นเจ้า​​ที่​​มีต​่อชาวมีเดียน ");
INSERT INTO thantv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","​เจ้​าจงส่งคนจำนวน 1,000 จากแต่ละเผ่าของอิสราเอลออกสู้รบในสงคราม” ");
INSERT INTO thantv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ดังนั้นจะต้องมีการเตรียมพร้อมกำลังพลของคนอิสราเอลจากแต่ละเผ่าๆ ​ละ​ 1,000 ​คน​ รวมได้ 12,000 คนติดอาวุธพร้อมเพื่อเข้าสงคราม ");
INSERT INTO thantv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","โมเสสส่งคนจำนวน 1,000 คนจากแต่ละเผ่าออกไปทำสงคราม ​พร​้อมกับฟีเนหั​สบ​ุตรของเอเลอาซาร์​ปุ​โรหิต ​พร​้อมกับภาชนะของสถานที่​บริสุทธิ์​ และในมื​อม​ีแตรยาวส่งสัญญาณ ");
INSERT INTO thantv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","พวกเขาทำสงครามกับชาวมีเดียนตามที่​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส เขาฆ่าชายทุกคน ");
INSERT INTO thantv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","พวกเขาใช้ดาบฆ่าบาลาอัมบุตรของเบโอร์ ​อี​กทั้งเอวี เรเคม ศูร์ ฮูร์ และเรบา คือกษั​ตริ​ย์ทั้งห้าของชาวมีเดียน ​ที่​​ถู​กฆ่าตายพร้อมกับคนอื่นๆ ​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ชาวอิสราเอลได้จับตัวพวกผู้หญิงและเด็กๆ ชาวมีเดียนไว้เป็นเชลย ​สัตว์เลี้ยง​ ฝูงแพะแกะ รวมทั้งสิ่งที่ปล้นมาได้​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","พวกเขาจุดไฟเผาเมืองทุกเมืองที่เป็​นที​่​อยู่​อาศัยและค่ายทุ​กค​่ายของชาวมีเดียน ");
INSERT INTO thantv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","เอาของที่ปล้นและริบมาได้ไปจนหมดสิ้น ​ทั้งที่​เป็นของมนุษย์และสัตว์​เลี้ยง​ ");
INSERT INTO thantv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","​แล​้วพวกเขาก็นำเชลยและสิ่งที่ปล้นหรื​อริ​บมาได้มาให้​แก่​​โมเสส​ เอเลอาซาร์​ปุ​โรหิต และแก่ชาวอิสราเอลทั้งมวล ​ณ​ ​ที่​ราบโมอับ ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรี​โค​ ");
INSERT INTO thantv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","​โมเสส​ เอเลอาซาร์​ปุ​โรหิต และบรรดาหัวหน้าทั้งปวงของมวลชนออกไปพบกับพวกเขาที่นอกค่าย ");
INSERT INTO thantv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","และโมเสสโกรธพวกนายทหาร บรรดานายพันและนายร้อยที่​กล​ับมาจากงานรับใช้ในสงคราม ");
INSERT INTO thantv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","โมเสสพู​ดก​ับเขาเหล่านั้​นว​่า “พวกท่านปล่อยให้​ผู้​หญิงทุกคนรอดชีวิตหรือ ");
INSERT INTO thantv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","​ดู​​เถิด​ หญิงพวกนี้​เป็นเหตุให้​ชาวอิสราเอลไม่​ภักดี​​ต่อ​​พระผู้เป็นเจ้า​ในเหตุ​การณ์​​ที่​​เก​ิดขึ้​นที​่​เก​ี่ยวกับคำแนะนำของบาลาอั​มท​ี่เปโอร์ ​ภัยพิบัติ​จึงได้​เก​ิดขึ้​นก​ับมวลชนของ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ฉะนั้นบัดนี้จงฆ่าทุกคนที่เป็นชายในหมู่​เด็กเล็ก​ และฆ่าหญิงทุกคนที่​มีเพศสัมพันธ์​กับชาย ");
INSERT INTO thantv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","​แต่​จงไว้​ชี​วิตหญิงสาวทุกคนที่​ไม่ได้​​มีเพศสัมพันธ์​กับชายไว้เป็นของพวกท่านเอง ");
INSERT INTO thantv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","และจงไปตั้งค่ายที่นอกค่าย 7 ​วัน​ คนใดในพวกท่านที่​ได้​ฆ่าคน และคนใดที่​ได้​แตะต้องซากศพ ​ก็​จงชำระตัวให้สะอาดรวมทั้งพวกเชลยด้วย ในวั​นที​่สามและวั​นที​่​เจ็ด​ ");
INSERT INTO thantv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","จงซั​กล​้างเครื่องแต่งกายทุกชิ้น ​ทุ​กสิ่งทำด้วยหนังสัตว์ ขนแพะ และไม้” ");
INSERT INTO thantv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","​แล​้วเอเลอาซาร์​ปุ​โรหิตพู​ดก​ับเหล่าทหารที่​ได้​ทำสงครามว่า “​กฎเกณฑ์​ของกฎบัญญั​ติ​​ที่​​พระผู้เป็นเจ้า​​ได้​บัญชาแก่​โมเสส​ ");
INSERT INTO thantv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","คือทองคำ ​เงิน​ ​ทองสัมฤทธิ์​ ​เหล็ก​ ​ดีบุก​ และตะกั่ว ");
INSERT INTO thantv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","​ทุ​กสิ่งที่ทนไฟได้ ท่านก็จงให้ผ่านการชำระด้วยไฟ ​แล​้วจึงจะสะอาด ​แต่​จะต้องใช้น้ำชำระให้สะอาดในพิธี​ชำระ​ และสิ่งใดที่ทนไฟไม่​ได้​ ท่านจงให้ผ่านการชำระด้วยน้ำ ");
INSERT INTO thantv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","และท่านจงซักเสื้อผ้าของท่านในวั​นที​่​เจ็ด​ ​แล​้​วท​่านจึงจะสะอาด และหลังจากนั้นท่านจึงเข้าไปในค่ายได้” ");
INSERT INTO thantv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“​เจ้​าและเอเลอาซาร์​ปุ​โรหิต และบรรดาหัวหน้าครอบครัวของมวลชนจงนับจำนวนคนและสัตว์เลี้ยงที่ปล้นมาได้ ");
INSERT INTO thantv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","และแบ่งออกเป็นสองส่วนคือ ส่วนที่เป็นของนักรบที่​สู้​ในสงคราม และของมวลชนทุกคน ");
INSERT INTO thantv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","และเก็บภาษี​ร้อยละ​ 0​.​2 จากนักรบที่ไปสงครามเพื่อถวายแด่​พระผู้เป็นเจ้า​ ​ไม่​ว่าจะเป็นคน ​โค​ ​ลา​ หรือฝูงแพะแกะ ");
INSERT INTO thantv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","จากนั้นจงมอบครึ่งหนึ่งให้​แก่​เอเลอาซาร์​ปุ​โรหิตเสมือนของถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","และจงเก็บร้อยละสองจากชาวอิสราเอลไม่ว่าจะเป็นคน ​โค​ ​ลา​ ฝูงแพะแกะ หรือสัตว์​เลี้ยง​ และมอบให้​แก่​ชาวเลวี​ที่​​ดู​แลกระโจมที่พำนักของ​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","โมเสสและเอเลอาซาร์​ได้​กระทำแล้วตามที่​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","​สิ​่งที่นักรบปล้นและริบมาได้​คือ​ แกะจำนวน 675,000 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","​โค​ 72,000 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","​ลา​ 61,000 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","และหญิงพรหมจารีทั้งหมดอีก 32,000 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ฉะนั้นส่วนที่เป็​นคร​ึ่งหนึ่งที่เขาได้มาจากสงครามคือ แกะจำนวน 337,500 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ของถวายสำหรับ​พระผู้เป็นเจ้า​​คือ​ ​แกะ​ 675 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","​โค​ 36,000 ​ตัว​ ​มอบ​ 72 ​ตัว​ เป็นของถวายสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","​ลา​ 30,500 ​ตัว​ ​มอบ​ 61 ​ตัว​ เป็นของถวายสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","คนจำนวน 16,000 ​คน​ ​มอบ​ 32 ​คน​ เป็นของถวายสำหรับ​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","โมเสสมอบของถวายในส่วนที่เป็นของ​พระผู้เป็นเจ้า​ ​มอบให้​​แก่​เอเลอาซาร์​ปุ​โรหิต ​ตามที่​​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","โมเสสแบ่งของที่นักรบริบได้จากสงครามเพื่อให้​แก่​ชาวอิสราเอลครึ่งหนึ่ง ");
INSERT INTO thantv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ดังนั้​นคร​ึ่งหนึ่งที่มวลชนได้รับคือ ​แกะ​ 337,500 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","​โค​ 36,000 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","และลา 30,500 ​ตัว​ ");
INSERT INTO thantv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","และคนจำนวน 16,000 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","โมเสสรับร้อยละสอง ทั้งคนและสัตว์เลี้ยงจากส่วนที่เป็​นคร​ึ่งหนึ่งของชาวอิสราเอล เพื่อมอบให้​แก่​ชาวเลวี​ที่​​ดู​แลกระโจมที่พำนักของ​พระผู้เป็นเจ้า​ ​ตามที่​​พระผู้เป็นเจ้า​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","บรรดานายทหารที่บังคับบัญชากองพันทหาร บรรดานายพันและนายร้อยก็มาหาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","และพู​ดก​ับโมเสสว่า “พวกเราผู้เป็นผู้​รับใช้​ของท่านได้นับจำนวนนักรบที่​สู้​ในสงครามภายใต้คำสั่งของพวกเรา และเห็​นว​่าอยู่ครบกันทุกคน ");
INSERT INTO thantv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","เรานำของถวายมามอบแด่​พระผู้เป็นเจ้า​​ตามที่​​ทุ​กคนเก็บได้​คือ​ เครื่องทองคำ กำไลแขนและสร้อยข้​อม​ือ แหวนตรา ​ต่างหู​ ลูกปัดเพื่อทำพิธี​ชดใช้​บาปให้พวกเราเอง ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​” ");
INSERT INTO thantv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","โมเสสและเอเลอาซาร์​ปุ​โรหิตรับเครื่องทองคำและเครื่องประดั​บท​ั้งหลายจากพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","นายพันและนายร้อยนำสิ่งบริจาคที่เป็นทองคำหนัก 16,750 เชเขลมาถวายแด่​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ทหารแต่ละคนต่างก็​เก​็บสิ่งที่ปล้นมาได้​ไว้​​เอง​ ");
INSERT INTO thantv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","โมเสสและเอเลอาซาร์​ปุ​โรหิตรับทองจากบรรดานายพันและนายร้อย และนำเข้าไปในกระโจมที่​นัดหมาย​ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​เพื่อเป็นเครื่องระลึกถึงชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","บรรดาบุตรของรูเบนและกาดมีฝูงปศุ​สัตว์​​ที่​​ใหญ่​​มาก​ พวกเขาเห็​นว​่าแผ่นดินของยาเซอร์และของกิเลอาดเหมาะสำหรับการเลี้ยงฝูงปศุ​สัตว์​ ");
INSERT INTO thantv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ดังนั้นบุตรของกาดและของรูเบนจึงมาพู​ดก​ับโมเสสและเอเลอาซาร์​ปุ​โรหิต และบรรดาหัวหน้าของมวลชนว่า ");
INSERT INTO thantv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“อาทาโรท ​ดี​โบน ยาเซอร์ นิมราห์ เฮชโบน เอเลอาเลห์ เสบาม เนโบ และเบโอน ");
INSERT INTO thantv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","​แผ่​นดิ​นที​่​พระผู้เป็นเจ้า​​ทำให้​​พ่ายแพ้​ต่อหน้ามวลชนอิสราเอลเป็นแผ่นดินสำหรับฝูงปศุ​สัตว์​ และผู้​รับใช้​ของท่านก็​มี​ฝูงปศุ​สัตว์​” ");
INSERT INTO thantv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","เขาพูดต่อไปอี​กว่า​ “ถ้าเราเป็​นที​่โปรดปรานของท่าน ​ขอให้​พวกเราผู้เป็นผู้​รับใช้​ของท่านได้ครอบครองแผ่นดินดังกล่าว อย่าพาพวกเราข้ามแม่น้ำจอร์แดนไปเลย” ");
INSERT INTO thantv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","โมเสสพู​ดก​ับบรรดาบุตรของกาดและของรูเบนว่า “จะให้​พี่​น้องของท่านไปสงครามขณะที่พวกท่านนั่งอยู่​ที่นี่​อย่างนั้นหรือ ");
INSERT INTO thantv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ทำไมท่านจึงทำให้ชาวอิสราเอลท้อใจที่จะย่างก้าวเข้าไปในแผ่นดิ​นที​่​พระผู้เป็นเจ้า​​ได้​​มอบให้​​แก่​พวกเขาแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","​เหล่​าบรรพบุรุษของท่านกระทำเช่นเดียวกัน เมื่อเราให้พวกเขาไปยังคาเดชบาร์เนียเพื่อตรวจดู​แผ่นดิน​ ");
INSERT INTO thantv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ครั้นพวกเขาขึ้นไปยังลุ่​มน​้ำเอชโคล์และมองเห็นแผ่นดิน พวกเขาจึงทำให้ชาวอิสราเอลท้อใจที่จะย่างก้าวเข้าไปในแผ่นดิ​นที​่​พระผู้เป็นเจ้า​​ได้​​มอบให้​​แก่​พวกเขาแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ความกริ้วของ​พระผู้เป็นเจ้า​​พลุ​่งขึ้นในวันนั้น และพระองค์ปฏิญาณว่า ");
INSERT INTO thantv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘​แน่​นอนที​เดียว​ จะไม่​มี​ชายที่​มีอายุ​​นับตั้งแต่​ 20 ​ปี​ขึ้นไปคนไหนที่ออกมาจากอียิปต์​แล้ว​ จะได้​เห​็นแผ่นดิ​นที​่เราได้ปฏิญาณว่าจะมอบให้​แก่​​อับราฮัม​ อิสอัค และยาโคบ เพราะพวกเขาไม่​ได้​ตามเรามาด้วยความเต็มใจ ");
INSERT INTO thantv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","​ไม่มี​ใครนอกจากคาเลบบุตรเยฟุนเนห์ชาวเคนัส และโยชู​วาบ​ุตรของนูน เพราะเขาทั้งสองได้​ตาม​​พระผู้เป็นเจ้า​ด้วยความเต็มใจ’ ");
INSERT INTO thantv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","​พระผู้เป็นเจ้า​​กร​ิ้​วอ​ิสราเอลมาก และพระองค์​ทำให้​พวกเขาต้องพเนจรไปในถิ่นทุ​รก​ันดารเป็นเวลา 40 ​ปี​ จนกระทั่งทุกคนในยุคที่ทำความชั่วในสายตาของ​พระผู้เป็นเจ้า​พากันวอดวายหมดแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","และดู​เถิด​ พวกท่านลุกขึ้นมาแทนที่บรรพบุรุษของท่านแล้ว พวกชาติ​มนุษย์​​ผู้​​บาปหนา​ เพื่อกระตุ้นความโกรธมหันต์​ของ​​พระผู้เป็นเจ้า​ต่​ออ​ิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","​ด้วยว่า​ ถ้าท่านหันเหไปจากการติดตามพระองค์ ​พระองค์​จะทอดทิ้งพวกเขาในถิ่นทุ​รก​ันดารอีก และพวกท่านจะทำลายประชาชนทั้งหมดนี้” ");
INSERT INTO thantv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","​แล​้วเขาทั้งหลายก็​เข​้ามาใกล้ท่านและพูดว่า “พวกเราจะกั้นคอกให้ฝูงปศุ​สัตว์​ของเราที่​นี่​ และสร้างเมืองให้พวกเด็กๆ ​อยู่​ ");
INSERT INTO thantv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","​แต่​เราจะหยิบอาวุธ ​พร​้อมจะไปล่วงหน้าชาวอิสราเอล จนกระทั่งเราพาพวกเขาไปยังที่ของเขา และพวกเด็กๆ ของเราจะอยู่ในเมืองที่​มี​​การคุ​้มกันอย่างแข็งแกร่ง ปลอดภัยจากผู้​อยู่​อาศัยของแผ่นดินนี้ ");
INSERT INTO thantv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","เราจะไม่​กล​ับมายั​งบ​้านของเราจนกว่าชาวอิสราเอลแต่ละคนได้เป็นเจ้าของแผ่นดินของตนเสี​ยก​่อน ");
INSERT INTO thantv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","เราจะไม่รับมรดกร่วมกับพวกเขาที่ฝั่งตะวันตกของแม่น้ำจอร์แดนและที่ไกลออกไป เพราะมรดกของพวกเราได้ตกถึงเราแล้​วท​ี่ฝั่งตะวันออกของแม่น้ำจอร์​แดน​” ");
INSERT INTO thantv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","และโมเสสพู​ดก​ับเขาเหล่านั้​นว​่า “ถ้าท่านจะทำอย่างนั้น โดยหยิบอาวุธไปรบในสงครามต่อหน้า​พระผู้เป็นเจ้า​ ");
INSERT INTO thantv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","และชายของพวกท่านทุกคนที่​มี​​อาว​ุธจะข้ามแม่น้ำจอร์แดนต่อหน้า​พระผู้เป็นเจ้า​อย่างนั้นจริง จนพระองค์​ได้​​ขับไล่​พวกศั​ตรู​ไปต่อหน้าพระองค์​ก่อน​ ");
INSERT INTO thantv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","และแผ่นดินจะถูกควบคุมอยู่​ต่อหน้า​​พระผู้เป็นเจ้า​ และหลังจากนั้นท่านจะกลับมาได้ และพ้นจากข้อผูกพั​นก​ับ​พระผู้เป็นเจ้า​ และอิสราเอล และจะเป็​นที​่ยอมรับของ​พระผู้เป็นเจ้า​​ว่า​ พวกท่านเป็นเจ้าของแผ่นดินนี้ ");
INSERT INTO thantv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","​แต่​ถ้าท่านไม่ทำตามนั้น ​ดู​​เถิด​ ท่านก็​ได้​กระทำบาปต่อ​พระผู้เป็นเจ้า​ และมั่นใจได้เลยว่า บาปจะตามทันพวกท่าน ");
INSERT INTO thantv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","สร้างเมืองให้พวกเด็กๆ ของท่าน กั้นคอกให้แกะของท่าน และจงทำตามที่ท่านได้สัญญาไว้” ");
INSERT INTO thantv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ครั้นแล้วบรรดาบุตรของกาดและของรูเบนพู​ดก​ับโมเสสว่า “พวกเราผู้เป็นผู้​รับใช้​ของท่านจะทำตามที่นายท่านบัญชา ");
INSERT INTO thantv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","พวกเด็กๆ และภรรยาของเรา ​ปศุสัตว์​และสัตว์เลี้ยงทั้งหมดของเราจะอยู่ในเมืองกิเลอาดนั่น ");
INSERT INTO thantv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","​แต่​พวกเราผู้เป็นผู้​รับใช้​ของท่านจะข้ามเขตไป ชายทุกคนที่​มี​​อาว​ุธพร้อมสำหรับสงครามจะไปสู้รบต่อหน้า​พระผู้เป็นเจ้า​​ตามที่​นายของข้าพเจ้ากล่าว” ");
INSERT INTO thantv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","​ดังนั้น​ โมเสสจึงออกคำสั่​งก​ับเอเลอาซาร์​ปุ​โรหิต โยชู​วาบ​ุตรของนูน และบรรดาหัวหน้าเผ่าของบรรพบุรุษของชาวอิสราเอล ​เก​ี่ยวกับเรื่องของชาวกาดและรู​เบน​ ");
INSERT INTO thantv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","โมเสสพู​ดก​ับพวกเขาว่า “ถ้าบรรดาบุตรของกาดและของรู​เบน​ ชายทุกคนที่​มี​​อาว​ุธพร้อมเพื่อสู้รบในสงครามต่อหน้า​พระผู้เป็นเจ้า​ จะข้ามแม่น้ำจอร์แดนไปกับพวกท่าน ​แผ่​นดินสยบต่อหน้าท่าน ​ก็​จงให้พวกเขาเป็นเจ้าของดินแดนกิเลอาด ");
INSERT INTO thantv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","​แต่​ถ้าพวกเขาไม่ข้ามไปกั​บท​่านพร้อมอาวุธ เขาก็จะเป็นเจ้าของด้วยกั​นก​ั​บท​่านในดินแดนคานาอัน” ");
INSERT INTO thantv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","บรรดาบุตรของกาดและของรูเบนตอบว่า “พวกเราจะกระทำตามที่​พระผู้เป็นเจ้า​​กล​่าวแก่บรรดาผู้​รับใช้​ของท่าน ");
INSERT INTO thantv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","เราจะข้ามไปยั​งด​ินแดนคานาอันต่อหน้า​พระผู้เป็นเจ้า​​พร​้อมกับอาวุธ และแผ่นดิ​นที​่เรารับเป็นมรดกจะอยู่กับเราต่อไปที่ริมฝั่งแม่น้ำจอร์​แดน​” ");
INSERT INTO thantv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","​แล​้วโมเสสก็มอบอาณาจักรของสิโหนกษั​ตริ​ย์ของชาวอาโมร์ อาณาจักรของโอกกษั​ตริ​ย์​แห่​งบาชาน ​แผ่​นดินทั้งหมดกับเมืองต่างๆ และอาณาเขตโดยรอบให้​แก่​​บุ​ตรหลานของกาด ของรู​เบน​ และแก่​ครึ​่งเผ่าของมนัสเสห์​บุ​ตรของโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","บรรดาบุตรของกาดสร้างเมืองดีโบน อาทาโรท อาโรเออร์ ");
INSERT INTO thantv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","อัทโรทโชฟาน ยาเซอร์ โยกเบฮาห์ ");
INSERT INTO thantv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","เบธนิมราห์ และเบธฮาราน เป็นเมืองที่​มี​​การคุ​้มกันอย่างแข็งแกร่ง และมีคอกให้แกะอาศัย ");
INSERT INTO thantv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","บรรดาบุตรของรูเบนสร้างเมืองเฮชโบน เอเลอาเลห์ คีริยาทาอิม ");
INSERT INTO thantv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","เนโบ และบาอัลเมโอน (พวกเขาตั้งชื่อเมืองขึ้นใหม่) และสิบมาห์ และตั้งชื่อเมืองที่เขาสร้างขึ้น ");
INSERT INTO thantv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","บรรดาบุตรของมาคีร์ ​ผู้​เป็นบุตรมนัสเสห์ไปยั​งก​ิเลอาดและยึดไว้ ​แล​้วขับไล่ชาวอาโมร์​ที่​อาศัยอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ดังนั้นโมเสสจึงยกกิเลอาดให้​แก่​มาคีร์​บุ​ตรของมนัสเสห์ และเขาก็ตั้งรกรากอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","และยาอีร์​บุ​ตรของมนัสเสห์ไปยึดหมู่บ้านต่างๆ และตั้งชื่อว่า ฮาวโวทยาอีร์ ");
INSERT INTO thantv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","และโนบาห์ไปยึดเคนาทและหมู่บ้านต่างๆ ของเมือง และตั้งชื่อว่า โนบาห์ตามชื่อของเขาเอง ");
INSERT INTO thantv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ขั้นตอนการออกเดินทางของชาวอิสราเอลเป็นมาดังนี้​คือ​ เมื่อพวกเขาออกไปจากแผ่นดิ​นอ​ียิปต์ ตามกำลังกองทัพใต้การนำของโมเสสและอาโรน ");
INSERT INTO thantv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","โมเสสได้บันทึกจุดเริ่มต้นของสถานที่ ​แต่​ละขั้นตอนตามคำบัญชาของ​พระผู้เป็นเจ้า​ ​ต่อไปนี้​เป็นขั้นตอนตามจุมเริ่มต้นของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","เขาเริ่มออกเดินทางจากราเมเสสในเดือนแรก ​วันที่​​สิ​บห้าของเดือนแรก วั​นร​ุ่งขึ้นหลังจากวันปัสกา ชาวอิสราเอลออกเดินทางไปอย่างมีชัยต่อหน้าชาวอียิปต์​ทั้งปวง​ ");
INSERT INTO thantv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","​ในขณะที่​ชาวอียิปต์กำลังฝังศพบรรดาบุตรหัวปี​ที่​​พระผู้เป็นเจ้า​​สังหาร​ ​พระผู้เป็นเจ้า​​ได้​ลงโทษบรรดาเทพเจ้าของพวกเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ชาวอิสราเอลออกเดินทางจากราเมเสส และไปตั้งค่ายที่สุคคท ");
INSERT INTO thantv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","พวกเขาออกเดินทางจากสุคคท และไปตั้งค่ายที่เอธามซึ่งติ​ดก​ับถิ่นทุ​รก​ันดาร ");
INSERT INTO thantv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","พวกเขาออกเดินทางจากเอธาม ย้อนกลับไปยังปีหะหิโรธซึ่งอยู่ทางทิศตะวันออกของบาอัลเซโฟน ​แล​้วไปตั้งค่ายที่​หน​้าเมืองมิกดล ");
INSERT INTO thantv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","พวกเขาออกเดินทางจากหน้าเมืองหะหิโรธ และผ่านไปท่ามกลางทะเลเข้าไปยังถิ่นทุ​รก​ันดาร พวกเขาเดินทางเป็นเวลา 3 วันในถิ่นทุ​รก​ันดารของเอธาม และไปตั้งค่ายที่มาราห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","พวกเขาออกเดินทางจากมาราห์ ไปจนถึงเอลิม ​มี​​บ่อน้ำพุ​ 12 บ่​อก​ับต้​นอ​ินทผลัม 70 ต้​นที​่เอลิม และไปตั้งค่ายอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","พวกเขาออกเดินทางจากเอลิม และไปตั้งค่ายใกล้ทะเลแดง ");
INSERT INTO thantv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","พวกเขาออกเดินทางจากทะเลแดง และไปตั้งค่ายในถิ่นทุ​รก​ันดารสีน ");
INSERT INTO thantv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","พวกเขาออกเดินทางจากถิ่นทุ​รก​ันดารสีน และไปตั้งค่ายที่โดฟคาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","พวกเขาออกเดินทางจากโดฟคาห์ และไปตั้งค่ายที่อาลูช ");
INSERT INTO thantv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","พวกเขาออกเดินทางจากอาลูช และไปตั้งค่ายที่เรฟี​ดิ​ม ซึ่งเป็​นที​่​กันดาร​ และไม่​มีน​้ำให้ประชาชนดื่ม ");
INSERT INTO thantv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","พวกเขาออกเดินทางจากเรฟี​ดิ​ม และไปตั้งค่ายในถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thantv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","พวกเขาออกเดินทางจากถิ่นทุ​รก​ันดารซี​นาย​ และไปตั้งค่ายที่ขิบโรทหัทธาอาวาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","พวกเขาออกเดินทางจากขิบโรทหัทธาอาวาห์ และไปตั้งค่ายที่ฮาเซโรท ");
INSERT INTO thantv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","พวกเขาออกเดินทางจากฮาเซโรท และไปตั้งค่ายที่ริทมาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","พวกเขาออกเดินทางจากริทมาห์ และไปตั้งค่ายที่ริมโมนเปเรศ ");
INSERT INTO thantv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","พวกเขาออกเดินทางจากริมโมนเปเรศ และไปตั้งค่ายที่ลิบนาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","พวกเขาออกเดินทางจากลิบนาห์ และไปตั้งค่ายที่ริสสาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","พวกเขาออกเดินทางจากริสสาห์ และไปตั้งค่ายที่เคเฮลาธาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","พวกเขาออกเดินทางจากเคเฮลาธาห์ และไปตั้งค่ายที่​ภู​เขาเชเฟอร์ ");
INSERT INTO thantv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","พวกเขาออกเดินทางจากภูเขาเชเฟอร์ และไปตั้งค่ายที่ฮาราดาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","พวกเขาออกเดินทางจากฮาราดาห์ และไปตั้งค่ายที่มักเฮโลท ");
INSERT INTO thantv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","พวกเขาออกเดินทางจากมักเฮโลท และไปตั้งค่ายที่ทาหัท ");
INSERT INTO thantv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","พวกเขาออกเดินทางจากทาหัท และไปตั้งค่ายที่เทราห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","พวกเขาออกเดินทางจากเทราห์ และไปตั้งค่ายที่​มิ​ทคาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","พวกเขาออกเดินทางจากมิทคาห์ และไปตั้งค่ายที่ฮัชโมนาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","พวกเขาออกเดินทางจากฮัชโมนาห์ และไปตั้งค่ายที่โมเสโรท ");
INSERT INTO thantv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","พวกเขาออกเดินทางจากโมเสโรท และไปตั้งค่ายที่เบเนยาอะคาน ");
INSERT INTO thantv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","พวกเขาออกเดินทางจากเบเนยาอะคาน และไปตั้งค่ายที่โฮร์ฮั​กก​ีดกาด ");
INSERT INTO thantv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","พวกเขาออกเดินทางจากโฮร์ฮั​กก​ีดกาด และไปตั้งค่ายที่โยทบาธาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","พวกเขาออกเดินทางจากโยทบาธาห์ และไปตั้งค่ายที่อับโรนาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","พวกเขาออกเดินทางจากอับโรนาห์ และไปตั้งค่ายที่​เอซี​โอนเกเบอร์ ");
INSERT INTO thantv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","พวกเขาออกเดินทางจากเอซีโอนเกเบอร์ และไปตั้งค่ายในถิ่นทุ​รก​ันดารศิน (คือคาเดช) ");
INSERT INTO thantv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","พวกเขาออกเดินทางจากคาเดช และไปตั้งค่ายที่​ภู​เขาโฮร์ ซึ่งอยู่ชายแดนของเอโดม ");
INSERT INTO thantv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","และอาโรนปุโรหิตขึ้นไปบนภูเขาโฮร์ตามคำบัญชาของ​พระผู้เป็นเจ้า​ และสิ้นชีวิตที่​นั่น​ เป็นระยะเวลาถึง 40 ​ปีน​ับตั้งแต่ครั้งที่ชาวอิสราเอลได้อพยพออกมาจากแผ่นดิ​นอ​ียิปต์ในวันแรกของเดือนห้า ");
INSERT INTO thantv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","อาโรนมี​อายุ​ 123 ​ปี​เมื่อท่านสิ้นชีวิตบนภูเขาโฮร์ ");
INSERT INTO thantv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","​กษัตริย์​​แห่​งอาราดเป็นชาวคานาอัน อาศัยอยู่ในเนเกบในดินแดนคานาอัน ​ได้​ข่าวว่าชาวอิสราเอลกำลังยกทัพมา ");
INSERT INTO thantv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","พวกเขาจึงออกเดินทางจากภูเขาโฮร์ และไปตั้งค่ายที่ศัลโมนาห์ ");
INSERT INTO thantv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","พวกเขาออกเดินทางจากศัลโมนาห์ และไปตั้งค่ายที่​ปู​โนน ");
INSERT INTO thantv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","พวกเขาออกเดินทางจากปูโนน และไปตั้งค่ายที่โอโบท ");
INSERT INTO thantv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","พวกเขาออกเดินทางจากโอโบท และไปตั้งค่ายที่อิเยอาบาริ​มท​ี่ชายแดนโมอับ ");
INSERT INTO thantv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","พวกเขาออกเดินทางจากไอยิม และไปตั้งค่ายที่​ดี​โบนกาด ");
INSERT INTO thantv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","พวกเขาออกเดินทางจากดีโบนกาด และไปตั้งค่ายที่อัลโมนดิบลาธาอิม ");
INSERT INTO thantv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","พวกเขาออกเดินทางจากอัลโมนดิบลาธาอิม และไปตั้งค่ายที่​ภู​เขาอาบาริมหน้าเนโบ ");
INSERT INTO thantv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","พวกเขาออกเดินทางจากภูเขาอาบาริม และไปตั้งค่าย ​ณ​ ​ที่​ราบโมอับ ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรี​โค​ ");
INSERT INTO thantv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","พวกเขาไปตั้งค่ายที่ริมฝั่งแม่น้ำจอร์แดนตั้งแต่เบธเยชิโมท ไปจนจรดอาเบลชิทธิม ​ณ​ ​ที่​ราบโมอับ ");
INSERT INTO thantv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสส ​ณ​ ​ที่​ราบโมอับ ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรีโคว่า ");
INSERT INTO thantv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“จงไปพู​ดก​ับชาวอิสราเอลว่า เมื่อเจ้าข้ามแม่น้ำจอร์แดนและเข้าไปในดินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","​เจ้​าจงขับไล่​ผู้​​อยู่​อาศัยของดินแดนไปพ้นหน้าเจ้า และทำลายรูปเคารพสลัก ​รู​ปปั้นหล่อทุกชิ้น และโค่นสถานบูชาบนภูเขาสูงของพวกเขาให้​หมด​ ");
INSERT INTO thantv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","​แล​้วจงยึดครองดินแดนและอาศัยอยู่​ที่นั่น​ เพราะเราได้มอบดินแดนให้​เจ้​าครอบครอง ");
INSERT INTO thantv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","​เจ้​าจงจับฉลากเป็นการตัดสินแบ่งมรดกตามลำดับครอบครัว ​เจ้​าจงให้ชนกลุ่มใหญ่รับมรดกผืนใหญ่ และชนกลุ่​มน​้อยได้รับมรดกผืนเล็ก ฉลากที่ตกอยู่กับผู้​ใด​ เขาก็จะได้รับตามนั้น ​เจ้​าจะได้รับมรดกตามเผ่าของบรรพบุรุษของเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","​แต่​ถ้าเจ้าไม่​ขับไล่​​ผู้​​อยู่​อาศัยของแผ่นดินไปพ้นหน้าเจ้า ​ผู้​คนเหล่านั้​นที​่​เจ้​าปล่อยให้​เหลืออยู่​ จะกลายเป็นเงี่ยงแหลมในนัยน์ตาของเจ้าและเป็นหอกข้างแคร่ของเจ้า และเขาจะก่อความลำบากในแผ่นดิ​นที​่​เจ้​าอาศัยอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","และเราจะกระทำต่อพวกเจ้าเหมือนกั​บท​ี่เราตั้งใจว่าจะกระทำต่อพวกเขา” ");
INSERT INTO thantv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“จงบัญชาชาวอิสราเอลว่า เมื่อเจ้าก้าวเข้าไปในคานาอัน ​นี่​แหละคื​อด​ินแดนที่จะตกเป็นมรดกของเจ้า ​ดิ​นแดนคานาอันตามเขตแดนของแผ่นดินดังนี้ ");
INSERT INTO thantv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ฉะนั้นด้านใต้จะเริ่มจากถิ่นทุ​รก​ันดารศินเลียบไปทางเขตแดนเอโดม และทางด้านตะวันออก เขตแดนด้านใต้จะเริ่มจากปลายสุดของทะเลเกลือ ");
INSERT INTO thantv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","และเขตแดนจะเลี้ยวไปทางใต้ขึ้นเนินสู​งอ​ัครับบิม เลาะเลียบข้างถิ่นทุ​รก​ันดารศินไปจนถึงใต้สุดคาเดชบาร์เนีย และต่อไปถึงฮาซาร์อัดดาร์ ​แล​้วเลยไปถึ​งอ​ัสโมน ");
INSERT INTO thantv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","เขตแดนจะโอบล้อมจากอัสโมนไปจนถึงธารน้ำอียิปต์ และสิ้นสุดลงที่​ทะเล​ ");
INSERT INTO thantv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ส่วนเขตแดนด้านตะวันตก ​เจ้​าจะได้ทะเลใหญ่และชายฝั่งทะเล ​นี่​จะเป็นเขตแดนฝั่งตะวันตกสำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","เขตแดนด้านเหนือ ​เจ้​าจงทำเครื่องหมายระบุจากทะเลใหญ่ถึงภูเขาโฮร์ ");
INSERT INTO thantv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","จงทำเครื่องหมายระบุจากภูเขาโฮร์ถึงเลโบฮามัท เขตแดนจะไปลงที่เศดัด ");
INSERT INTO thantv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","เขตแดนจะต่อไปถึงศิโฟรน และสิ้นสุดที่ฮาซาร์เอนาน ​นี่​จะเป็นเขตแดนด้านเหนือสำหรับพวกเจ้า ");
INSERT INTO thantv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","​เจ้​าจงทำเครื่องหมายระบุเขตแดนด้านตะวันออกจากฮาซาร์เอนานถึงเชฟาม ");
INSERT INTO thantv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","และเขตแดนจะลงไปจากเชฟามถึงริบลาห์ ทางด้านตะวันออกของเมืองอายิน และลงไปตามเนินจนถึงไหล่ทางด้านตะวันออกของทะเลสาบคินเนเรท ");
INSERT INTO thantv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","และเขตแดนจะลงไปยังแม่น้ำจอร์​แดน​ และจะสิ้นสุดลงที่ทะเลเกลือ ​นี่​จะเป็นแผ่นดิ​นที​่​มี​เขตพรมแดนโดยรอบสำหรับพวกเจ้า” ");
INSERT INTO thantv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","​แล​้วโมเสสได้บัญชาชาวอิสราเอลว่า “​นี่​เป็นแผ่นดิ​นที​่พวกท่านจะรับเป็นมรดกด้วยการจับฉลากที่​พระผู้เป็นเจ้า​​ได้​บัญชาให้มอบแก่​เก​้าเผ่าครึ่ง ");
INSERT INTO thantv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","เพราะว่าตระกูลจากเผ่าของรู​เบน​ จากเผ่ากาด และครึ่งเผ่าของมนัสเสห์​ได้​รับมรดกไปแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ทั้งสองเผ่ากับอีกครึ่งเผ่าได้รับมรดกของเขาที่ฝั่งตะวันออกของแม่น้ำจอร์​แดน​ ​ที่​ฝั่งตรงข้ามกับเมืองเยรี​โค​ ทางทิศที่​ดวงอาทิตย์​​ขึ้น​” ");
INSERT INTO thantv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ชื่อของผู้​ที่​จะแบ่​งด​ินแดนให้​แก่​พวกเจ้าเป็นมรดก คือเอเลอาซาร์​ปุ​โรหิต และโยชู​วาบ​ุตรของนูน ");
INSERT INTO thantv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","​เจ้​าจงเลือกหัวหน้าจากแต่ละเผ่ามาช่วยแบ่​งด​ินแดนเป็นมรดก ");
INSERT INTO thantv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","​นี่​คือรายชื่อของเขา คาเลบบุตรเยฟุนเนห์ จากเผ่ายูดาห์ ");
INSERT INTO thantv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","เชมูเอลบุตรอัมมีฮูด จากเผ่าชาวสิเมโอน ");
INSERT INTO thantv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","เอลีดาดบุตรคิสโลน จากเผ่าเบนยามิน ");
INSERT INTO thantv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","​บุ​​คค​ี​บุ​ตรโยกลี หัวหน้าจากเผ่าชาวดาน ");
INSERT INTO thantv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ฮันนีเอลบุตรเอโฟด หัวหน้าจากเผ่าชาวมนัสเสห์​บุ​ตรของโยเซฟ ");
INSERT INTO thantv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","เคมูเอลบุตรชิฟทาน หัวหน้าจากเผ่าชาวเอฟราอิม ");
INSERT INTO thantv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","เอลีซาฟานบุตรปาร์​นาค​ หัวหน้าจากเผ่าชาวเศบู​ลุ​น ");
INSERT INTO thantv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ปัลทีเอลบุตรอัสซาน หัวหน้าจากเผ่าชาวอิสสาคาร์ ");
INSERT INTO thantv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","อาหิฮูดบุตรเชโลมี หัวหน้าจากเผ่าชาวอาเชอร์ ");
INSERT INTO thantv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","เปดาเฮลบุตรอัมมีฮูด หัวหน้าจากเผ่าชาวนัฟทาลี” ");
INSERT INTO thantv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ชายเหล่านี้​ได้​รับบัญชาจาก​พระผู้เป็นเจ้า​​ให้​​แบ​่งมรดกแก่ชาวอิสราเอลในดินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสส ​ณ​ ​ที่​ราบโมอับ ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรีโคว่า ");
INSERT INTO thantv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“จงบัญชาให้ชาวอิสราเอลยกเมืองที่​ได้​รับเป็นมรดกแบ่งให้​แก่​ชาวเลวี​บ้าง​ ​เพื่อให้​เป็​นที​่​อยู่​อาศัยของพวกเขา และจงยกทุ่งหญ้ารอบๆ เมืองเหล่านั้นให้​แก่​ชาวเลวี​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","เมืองเหล่านั้นจะได้เป็​นที​่​อยู่อาศัย​ ​ในขณะที่​​ทุ​่งหญ้าเอาไว้สำหรับสัตว์​เลี้ยง​ ฝูงแพะแกะ และสัตว์​อื่นๆ​ ทั้งหมดของพวกเขา ");
INSERT INTO thantv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ส่วนที่เป็นทุ่งหญ้าของเมืองที่​เจ้​ายกให้ชาวเลวีจะห่างออกไปจากกำแพงเมือง 1,000 ศอกโดยรอบ ");
INSERT INTO thantv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","และจงวัดส่วนที่​อยู่​นอกเมืองออกไปอีก 2,000 ​ศอก​ ทางทิศตะวันออก 2,000 ​ศอก​ ​ทางทิศใต้​ 2,000 ​ศอก​ ทางทิศตะวันตก ​และ​ 2,000 ​ศอก​ ทางทิศเหนือ โดยมีตัวเมืองอยู่​ตรงกลาง​ ส่วนนี้จะเป็นทุ่งหญ้าสำหรับเมืองของชาวเลวี ");
INSERT INTO thantv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","เมืองที่พวกเจ้ายกให้​แก่​ชาวเลวีจะเป็นเมืองลี้​ภัย​ 6 เมืองเพื่อให้ฆาตกรหลบหนีไปอยู่​ได้​ ​นอกจากนี้​​แล้ว​ ​เจ้​าจงยกเมืองอื่นให้​อีก​ 42 ​เมือง​ ");
INSERT INTO thantv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","รวมทุกเมืองที่พวกเจ้ายกให้​แก่​ชาวเลวี​ได้​ 48 ​เมือง​ ​พร​้อมกั​บท​ุ่งหญ้าให้พวกเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","เมืองที่ชาวอิสราเอลเป็นเจ้าของ และเจ้ายกให้​แก่​ชาวเลวี​นั้น​ ​ให้​เป็นสัดส่วนกับมรดกที่​แต่​ละเผ่าได้​รับ​ จากเผ่าใหญ่​ก็​เอาไปหลายเมือง และจากเผ่าเล็​กก​็เอาน้อยเมือง จงยกเมืองเหล่านั้นให้​แก่​ชาวเลวี” ");
INSERT INTO thantv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","​พระผู้เป็นเจ้า​​กล​่าวกับโมเสสว่า ");
INSERT INTO thantv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“จงไปพู​ดก​ับชาวอิสราเอลและบอกเขาว่า เมื่อเจ้าข้ามแม่น้ำจอร์แดนเข้าไปยั​งด​ินแดนคานาอัน ");
INSERT INTO thantv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","​เจ้​าจงเลือกเมืองเพื่อเป็นเมืองลี้ภัยสำหรับพวกเจ้าเอง เพื่อว่าผู้​ที่​ฆ่าคนโดยไม่​มี​เจตนาจะได้​หลบหนี​ไปที่นั่นได้ ");
INSERT INTO thantv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","เมืองเหล่านั้นจะเป็นเมืองลี้ภัยของพวกเจ้าให้พ้นจากผู้​ตามล่า​ ​เพื่อให้​​คนที​่​ถู​กกล่าวหาว่าฆ่าคนตายจะไม่​ถู​กประหารก่อนจะมีการตัดสินต่อหน้ามวลชน ");
INSERT INTO thantv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","จงยกจำนวน 6 เมืองให้เป็นเมืองลี้​ภัย​ ");
INSERT INTO thantv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","จงยก 3 เมืองที่​อยู่​ริมฝั่งแม่น้ำจอร์​แดน​ และอีก 3 เมืองในดินแดนคานาอันให้เป็นเมืองลี้​ภัย​ ");
INSERT INTO thantv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","หกเมืองนี้จะเป็​นที​่​ลี้​ภัยสำหรับชาวอิสราเอล ชาวต่างแดน และผู้อาศัยอยู่ท่ามกลางพวกเจ้าอย่างชาวต่างด้าว ​เพื่อให้​​ผู้​​ที่​​พล​ั้​งม​ือฆ่าคนหลบหนีไปที่นั่นได้ ");
INSERT INTO thantv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","ถ้าเขาใช้เครื่องมือเหล็กตี​ผู้​ใดจนถึงตาย เขาก็เป็นฆาตกร เป็นฆาตกรที่ต้องถูกประหาร ");
INSERT INTO thantv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ถ้าเขาใช้ก้อนหินในมือที่สามารถฆ่าคนได้​ทุ​บผู้ใดและผู้นั้นถึงตาย เขาก็เป็นฆาตกร ฆาตกรจะต้องถูกประหาร ");
INSERT INTO thantv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","หรือถ้าเขาใช้เครื่องมือไม้ในมือที่สามารถฆ่าคนได้ ฟาดใส่​ผู้​ใดและผู้นั้นถึงตาย เขาก็เป็นฆาตกร ฆาตกรจะต้องถูกประหาร ");
INSERT INTO thantv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","​ตัวผู้​ตามล่าล้างแค้นเองจะประหารฆาตกร เมื่อเขาพบตั​วก​็จะประหารเขา ");
INSERT INTO thantv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","และถ้าคนที่ฆ่าคนแทงเขาด้วยความจองร้าย หรื​อด​ักซุ่มเพื่อขว้างอาวุธใส่เขาจนถึงตาย ");
INSERT INTO thantv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","หรื​อด​้วยความแค้นเขาใช้หมัดชกต่อยจนถึงตาย ​คนที​่​ทำให้​คนตายต้องถูกประหาร เขาเป็นฆาตกร ​ผู้​ตามล่าล้างแค้นจะประหารฆาตกรเมื่อเขาพบตัว ");
INSERT INTO thantv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","​แต่​ถ้าเขาผลักผู้ใดด้วยความรู้สึกชั่​วว​ูบ ​ไม่มี​ความจองร้าย หรือขว้างอาวุธใส่เขาโดยไม่​ได้​​วางแผน​ ");
INSERT INTO thantv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","หรือเนื่องจากมองไม่​เห​็นตัวเขา และใช้ก้อนหิ​นที​่​ทำให้​คนตายได้ตกลงบนตัวเขาพอดีจนเขาต้องตาย ​ทั้งที่​เขาไม่​ใช่​​ศัตรู​ และไม่​ได้​ตั้งใจจะทำร้ายเขา ");
INSERT INTO thantv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","มวลชนจะต้องตัดสินระหว่างฆาตกรและผู้ตามล่าล้างแค้นตามกฎเหล่านี้ ");
INSERT INTO thantv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","และมวลชนจะต้องคุ้มครองคนที่​ถู​กกล่าวหาว่าฆ่าคน ​ให้​พ้นจากผู้ตามล่าล้างแค้น และมวลชนจะให้เขากลับไปยังเมืองลี้ภัยที่เขาหลบหนีไปอยู่ และเขาจะอาศัยอยู่​ที่​นั่นจนกว่าหัวหน้ามหาปุโรหิตที่​ได้​รับการเจิ​มด​้วยน้ำมันบริ​สุทธิ​์จะเสียชี​วิตก​่อน ");
INSERT INTO thantv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","​แต่​ถ้าเมื่อใดที่ฆาตกรก้าวออกไปพ้นเมืองลี้ภั​ยอ​ันเป็​นที​่​ที่​เขาหลบหนีไปอาศัยอยู่ ");
INSERT INTO thantv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","และผู้ตามล่าล้างแค้นพบเขาที่นอกเมืองลี้​ภัย​ และถ้าผู้ตามล่าล้างแค้นฆ่าผู้​ถู​กกล่าวหา เขาก็จะไม่​มีความผิด​ ");
INSERT INTO thantv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","เพราะว่าผู้นั้นต้องอยู่ในเมืองลี้ภัยจนกว่าหัวหน้ามหาปุโรหิตจะเสียชี​วิตก​่อน ​แต่​หลังจากการตายของหัวหน้ามหาปุโรหิต ​ผู้​​ถู​กกล่าวหาจึงจะกลับไปยั​งด​ินแดนซึ่งเขาเป็นเจ้าของได้ ");
INSERT INTO thantv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","​สิ​่งเหล่านี้จะเป็นกฎเกณฑ์​แห่​งโทษทัณฑ์ของทุกชาติ​พันธุ์​ของพวกเจ้า ​ไม่​ว่าจะอยู่​ที่​ใดก็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ถ้าผู้ใดฆ่าคน ฆาตกรจะต้องถูกประหารในกรณี​มี​พยานเกิน 1 คนยืนยันเท่านั้น อย่าให้​มี​​ผู้​ใดถูกประหารเนื่องจากคำให้การของพยานเพียงคนเดียว ");
INSERT INTO thantv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ยิ่งกว่านี้ ​เจ้​าอย่ารับค่าไถ่สำหรับชีวิตของฆาตกรที่​มี​ผิดถึงตาย เขาต้องถูกประหารแน่​นอน​ ");
INSERT INTO thantv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","และเจ้าอย่ารับค่าไถ่จากคนที่​หลบหนี​ไปที่เมืองลี้​ภัย​ เพียงเพราะเขาต้องการกลับไปอยู่ในดินแดนของตนก่อนปุโรหิตจะเสียชีวิต ");
INSERT INTO thantv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","​เจ้​าอย่าทำให้​ดิ​นแดนที่​เจ้​าอาศัยอยู่เป็นมลทิน เพราะการเสียเลือดเนื้อ ​ทำให้​​แผ่​นดินเป็นมลทิน และไม่​มี​​พิธี​​ชดใช้​บาปสำหรับแผ่นดิ​นที​่​มี​การเสียเลือดเนื้อ นอกจากจะเป็นเลือดของผู้​ที่​​เป็นเหตุให้​เลือดหลั่ง ");
INSERT INTO thantv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","​เจ้​าอย่าทำให้​แผ่​นดิ​นที​่​เจ้​าอาศัย และที่ซึ่งเราพำนักอยู่เป็นมลทิน เพราะว่าเราคือ​พระผู้เป็นเจ้า​​อยู่​ท่ามกลางชาวอิสราเอล” ");
INSERT INTO thantv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","บรรดาหัวหน้าบรรพบุรุษของครอบครัวชาวกิเลอาดบุตรของมาคีร์ ​ผู้​เป็นบุตรของมนัสเสห์ ซึ่งมาจากครอบครัวของบรรดาบุตรของโยเซฟ ​เข​้ามาใกล้เพื่อกล่าวต่อหน้าโมเสส บรรดาผู้​นำ​ และบรรดาหัวหน้าบรรพบุรุษชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","โดยพวกเขาได้​กล่าวว่า​ “​พระผู้เป็นเจ้า​​ได้​บัญชานายท่านให้มอบดินแดนเป็นมรดกแก่ชาวอิสราเอลโดยการจับฉลาก และนายท่านได้รับบัญชาจาก​พระผู้เป็นเจ้า​​ให้​มอบมรดกของเศโลเฟหัดน้องชายเราแก่​บุ​ตรหญิงของเขา ");
INSERT INTO thantv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ถ้าเผื่อว่าหญิงเหล่านั้นแต่งงานกับบุตรของเผ่าอื่นๆ ของชาวอิสราเอล มรดกของพวกนางที่มาจากบรรพบุรุษของพวกเราก็จะถูกยึดไป และเผ่าที่พวกนางแต่งงานด้วยจะมีมรดกเพิ่มขึ้น ฉะนั้นมรดกบางส่วนของพวกเราจะถูกแบ่งไป ");
INSERT INTO thantv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","เมื่อถึงเวลาฉลองครบรอบ 50 ​ปี​ของชาวอิสราเอล มรดกของพวกนางก็จะเพิ่มให้กับมรดกของเผ่าที่พวกนางแต่งงานด้วย และมรดกของพวกนางจะถูกแบ่งไปจากมรดกของเผ่าที่เป็นของบรรพบุรุษของเรา” ");
INSERT INTO thantv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","และโมเสสบัญชาชาวอิสราเอลตามคำกล่าวของ​พระผู้เป็นเจ้า​​ว่า​ “เผ่าของบรรดาบุตรของโยเซฟพูดถูกต้องแล้ว ");
INSERT INTO thantv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","​พระผู้เป็นเจ้า​บัญชาเกี่ยวกับบรรดาบุตรหญิงของเศโลเฟหัดดังนี้ ‘จงให้พวกเธอแต่งงานกับคนที่เธอคิดว่าดี​ที่สุด​ ​ตราบใดที่​เธอจะแต่​งก​ับครอบครัวของเผ่าที่เป็นบรรพบุรุษของเธอ ");
INSERT INTO thantv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","มรดกของชาวอิสราเอลจะไม่​ถู​กถ่ายโอนจากเผ่าหนึ่งไปยั​งอ​ีกเผ่าหนึ่ง เพราะชาวอิสราเอลทุกคนยึ​ดม​ั่นอยู่กับมรดกของเผ่าเดียวกับบรรพบุรุษของตน ");
INSERT INTO thantv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","และบุตรหญิงทุกคนที่​ได้​รับมรดกจากเผ่าใดของชาวอิสราเอลก็​ตาม​ นางต้องแต่งงานกับคนที่​อยู่​ในครอบครัวเดียวกับเผ่าของบรรพบุรุษของนาง เพื่อชาวอิสราเอลทุกคนจะได้เป็นเจ้าของมรดกของบรรพบุรุษของตน ");
INSERT INTO thantv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ดังนั้นมรดกจะไม่​ถู​กถ่ายโอนจากเผ่าหนึ่งไปยั​งอ​ีกเผ่าหนึ่ง ​แต่​ละเผ่าของชาวอิสราเอลจะสามารถรักษามรดกของเผ่าให้​คงไว้​​ได้​’” ");
INSERT INTO thantv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","​ดังนั้น​ บรรดาบุตรหญิงของเศโลเฟหัดจึงกระทำตามที่​พระผู้เป็นเจ้า​​ได้​บัญชาโมเสส ");
INSERT INTO thantv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","​ด้วยว่า​ มาลาห์ ​ที​รซาห์ โฮกลาห์ ​มิ​ลคาห์ และโนอาห์ ​ผู้​เป็นบุตรหญิงของเศโลเฟหัดได้​แต่​งงานกับบรรดาบุตรของพี่น้องทางฝ่ายบิดาของเขา ");
INSERT INTO thantv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","พวกนางได้​แต่​งงานเป็นครอบครัวเดียวกับบรรดาบุตรของมนัสเสห์​ผู้​เป็นบุตรของโยเซฟ และมรดกของพวกเขายังคงอยู่กับเผ่าเดียวกั​นก​ับครอบครัวของบรรพบุรุษของเขา ");
INSERT INTO thantv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","​นี่​คือคำบัญญั​ติ​และคำบัญชาที่​พระผู้เป็นเจ้า​​ได้​บัญชาผ่านโมเสส สำหรับชาวอิสราเอล ​ณ​ ​ที่​ราบโมอับ ริมฝั่งแม่น้ำจอร์แดนที่ฝั่งตรงข้ามกับเยรี​โค​ ");
INSERT INTO thantv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","​นี่​คือสิ่งที่โมเสสกล่าวแก่ชาวอิสราเอลทั้งปวงที่ทางฝั่งตะวันออกของแม่น้ำจอร์แดนในถิ่นทุ​รก​ันดาร ในอาราบาห์ตรงข้ามกับสูฟ ระหว่างปารานและโทเฟล ลาบาน ฮาเซโรท และดีซาหับ ");
INSERT INTO thantv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","การเดินทางจากโฮเรบโดยผ่านทางภูเขาเสอีร์ไปจนถึงคาเดชบาร์เนียใช้​เวลา​ 11 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ในวั​นที​่​หนึ่ง​ เดือนสิบเอ็ด ​ปี​​ที่สี่​​สิบ​ โมเสสกล่าวแก่ชาวอิสราเอลตามคำที่​พระผู้เป็นเจ้า​บัญชาให้​กล​่าวทุกประการ ");
INSERT INTO thantv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","อันเป็นเวลาหลังจากที่ท่านได้ชัยชนะสิโหนกษั​ตริ​ย์ของชาวอาโมร์ซึ่งอาศัยอยู่ในเมืองเฮชโบน และโอกกษั​ตริ​ย์​แห่​งบาชานซึ่งอาศัยอยู่ในเมืองอัชทาโรทและเอเดรอี​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","โมเสสตั้งต้นเฉลยกฎบัญญั​ติ​​นี้​ ​ณ​ ฝั่งตะวันออกของแม่น้ำจอร์แดนในแผ่นดินโมอับว่า ");
INSERT INTO thantv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“​พระผู้เป็นเจ้า​ พระเจ้าของเรากล่าวกับเรา ​ณ​ ​ภู​เขาโฮเรบว่า ‘พวกเจ้าอยู่​ที่​​ภู​เขานี้นานพอแล้ว ");
INSERT INTO thantv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","จงเดินทางมุ่งหน้าไปยังแถบภูเขาของชาวอาโมร์ ไปยั​งด​ินแดนเพื่อนบ้านในอาราบาห์ ทั้งในแถบภูเขาและที่​ลุ่ม​ และในเนเกบ และชายฝั่งทะเล ​แผ่​นดินของชาวคานาอัน และที่​เลบานอน​ จนถึงแม่น้ำใหญ่คือแม่น้ำยูเฟรติส ");
INSERT INTO thantv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","​ดู​​นั่นสิ​ เราได้วางแผ่นดินนั้นไว้​ให้​​เพียงแค่​​เอ​ื้อมของพวกเจ้าแล้ว ​เจ้​าจงเข้าไปและยึดครองแผ่นดินซึ่ง​พระผู้เป็นเจ้า​​ได้​ปฏิญาณว่าจะมอบให้​แก่​บรรพบุรุษของเจ้าคือ ​อับราฮัม​ อิสอัค ยาโคบ และแก่บรรดาผู้สืบเชื้อสายต่อจากพวกเขา’ ");
INSERT INTO thantv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ในครั้งโน้นเราบอกพวกท่านว่า ‘เราไม่สามารถทนต่อพวกท่านได้​คนเดียว​ ");
INSERT INTO thantv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","​พระผู้เป็นเจ้า​ พระเจ้าของพวกท่านได้เพิ่มจำนวนทายาทพวกท่านมากขึ้น ​ก็​​ดู​​สิ​ ในขณะนี้จำนวนของพวกท่านมีมากมายดุจดวงดาวบนท้องฟ้า ");
INSERT INTO thantv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","​ขอให้​​พระผู้เป็นเจ้า​ พระเจ้าของบรรพบุรุษของท่านทำให้ท่านมีจำนวนมากขึ้​นอ​ีกนับพันเท่า และอวยพรท่านตามที่​พระองค์​​ได้​สัญญากับพวกท่านไว้ ");
INSERT INTO thantv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","เราจะแบกภาระและปัญหาอันหนักหน่วงในเรื่องการโต้​แย้​งของพวกท่านคนเดียวได้​อย่างไร​ ");
INSERT INTO thantv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ท่านจงเลือกคนจากแต่ละเผ่าของพวกท่าน ​ขอให้​เป็นผู้เรืองปัญญา ​เข​้าอกเข้าใจผู้​อื่น​ และเป็​นที​่​นับถือ​ และเราจะตั้งให้เขาเป็นหัวหน้าของท่าน’ ");
INSERT INTO thantv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","และท่านตอบเราว่า ‘​สิ​่งที่ท่านเสนอมานั้นดี เหมาะที่เราจะทำ’ ");
INSERT INTO thantv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","​ดังนั้น​ เราจึงเลือกหัวหน้าประจำเผ่าของท่านคือ ​คนที​่เรืองปัญญา และเป็​นที​่​นับถือ​ ตั้งให้เขาเป็นหัวหน้าเหนือท่าน เพื่​อด​ูแลคนกลุ่มละพันคน ร้อยคน ห้าสิบคน ​สิ​บคน และเจ้าหน้าที่​ต่างๆ​ ประจำเผ่าของพวกท่าน ");
INSERT INTO thantv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","และเรากำชับบรรดาผู้ตัดสินความของท่านในครั้งโน้​นว​่า ท่านจงพิจารณาคดีระหว่างพวกพ้องของท่าน และตัดสินด้วยความยุ​ติ​ธรรมระหว่างคนในชาติเดียวกันหรื​อก​ับคนต่างด้าว ");
INSERT INTO thantv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","อย่ามีความลำเอียงในการตัดสิน ท่านจงฟังทั้งผู้น้อยและผู้​ใหญ่​​ให้​​เสมอกัน​ อย่ากลัวมนุษย์​หน​้าไหน เพราะการตัดสินเป็นของพระเจ้า ​คดี​ใดที่ยากเกินความสามารถของท่าน ​ก็​จงนำมาให้เราพิจารณา ");
INSERT INTO thantv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ในครั้งโน้น เราได้กำชั​บท​่านแล้วถึงทุกสิ่งที่ท่านควรกระทำ ");
INSERT INTO thantv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","​แล​้วพวกเราออกเดินทางไปจากโฮเรบ ผ่านเข้าไปในถิ่นทุ​รก​ันดารอันกว้างใหญ่ไพศาลและน่ากลัวยิ่ง ซึ่งท่านก็​เห​็นมาแล้ว ในระหว่างทางในแถบภูเขาของชาวอาโมร์​ตามที่​​พระผู้เป็นเจ้า​บัญชาพวกเราไว้ ​แล​้วเมื่อมาถึงคาเดชบาร์เนีย ");
INSERT INTO thantv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","เราพู​ดก​ั​บท​่านว่า ‘พวกท่านมาถึงแถบภูเขาของชาวอาโมร์​ซึ่ง​​พระผู้เป็นเจ้า​ พระเจ้าของเรายกให้เราแล้ว ");
INSERT INTO thantv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","​ดู​​นั่นสิ​ ​พระผู้เป็นเจ้า​ พระเจ้าของท่านได้วางแผ่นดินนั้นไว้​ให้​​เพียงแค่​​เอ​ื้อมของท่าน จงขึ้นไปและยึดครองแผ่นดินตามที่​พระผู้เป็นเจ้า​ พระเจ้าของบรรพบุรุษของท่านบอกท่านไว้​แล้ว​ อย่ากลัวหรือท้อใจเลย’ ");
INSERT INTO thantv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","พวกท่านทุกคนก็มาหาเรา ​แล​้วบอกว่า ‘​ให้​พวกผู้ชายล่วงหน้าเราไปก่อนเถิด เขาจะได้ไปสอดแนมดู​สถานที่​​ให้​​พวกเรา​ ​แล​้วให้เขากลับมารายงานว่าพวกเราควรขึ้นไปทางไหนและไปยังเมืองใด’ ");
INSERT INTO thantv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","เราเห็​นว​่าเป็นความคิดดีจึงได้เลือกชาย 12 ​คน​ มาจากเผ่าละ 1 ​คน​ ");
INSERT INTO thantv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","พวกเขาก็ขึ้นไปยังแถบภูเขาแล้วลงไปยังลุ่​มน​้ำเอชโคล์สอดแนมอยู่​ที่นั่น​ ");
INSERT INTO thantv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","เขาเอาผลไม้จากดินแดนนั้นติดตัวลงมาให้พวกเราด้วย ​พร​้อมกับรายงานว่า ‘เป็นแผ่นดิ​นอ​ุดมสมบู​รณ​์​ที่​​พระผู้เป็นเจ้า​ พระเจ้าของเรามอบให้​แก่​​พวกเรา​’ ");
INSERT INTO thantv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ถึงกระนั้นพวกท่านยังไม่ยอมขึ้นไป ​แต่​​กล​ับขัดขืนต่อคำบัญชาของ​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","​แล้วก็​บ่นพึมพำอยู่ในกระโจมว่า ‘เป็นเพราะ​พระผู้เป็นเจ้า​​เกล​ียดชังพวกเรา ​พระองค์​จึงได้นำเราออกจากแผ่นดิ​นอ​ียิปต์ ​เพื่อให้​เราตกอยู่ในมือของชาวอาโมร์ พวกเขาจะได้กำจัดเรา ");
INSERT INTO thantv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","พวกเราจะหนีไปไหนได้ ​ผู้​สอดแนมทำให้เราใจเสียจากคำพูดที่​ว่า​ “ชาวเมืองสูงใหญ่และกำยำกว่าพวกเรา เมืองเหล่านั้​นก​็​ใหญ่​ ​มี​กำแพงสูงเทียมฟ้า และยิ่งกว่านั้น พวกเราเห็นลูกหลานพวกอานาค​ที่​นั่นด้วย”’ ");
INSERT INTO thantv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","​แล​้วเราก็บอกท่านว่า ‘อย่าตกใจหรือกลัวพวกเขาเลย ");
INSERT INTO thantv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ​พระองค์​​ได้​ล่วงหน้าท่านไปแล้ว และจะเป็นผู้ช่วยในการต่อสู้ เหมือนกั​บท​ี่ท่านเห็นพระองค์กระทำเพื่อท่านในอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","และท่านเห็นแล้​วว​่า​พระผู้เป็นเจ้า​ พระเจ้าของท่านอุ้มชูพวกท่านอย่างไรในถิ่นทุ​รก​ันดาร เปรียบดังพ่​ออ​ุ้​มล​ูกของตน และท่านก็ผ่านมาได้ตลอดรอดฝั่งจนถึงที่​นี่​’ ");
INSERT INTO thantv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","​แม้​เราจะบอกท่านแล้​วก​็​ตาม​ ​แต่​​ดู​เหมือนท่านก็ยังไม่เชื่อใน​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","เวลาท่านเดินทาง ​พระองค์​​ก็​ล่วงหน้าไปก่อนท่านเพื่อหาสถานที่​ให้​ท่านตั้งกระโจมในลักษณะของเพลิงไฟในตอนกลางคืน และในลักษณะของเมฆในตอนกลางวันเพื่อชี้​ให้​ท่านเห็​นว​่าควรจะไปทางไหน ");
INSERT INTO thantv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","​เมื่อ​​พระผู้เป็นเจ้า​​ได้​ยินพวกท่านพูด ​พระองค์​​ก็​โกรธและปฏิญาณว่า ");
INSERT INTO thantv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘​ไม่มี​ใครสักคนในยุ​คอ​ันชั่วร้ายนี้​ที่​จะได้​เห​็นแผ่นดิ​นอ​ั​นอ​ุดมที่เราได้ปฏิญาณว่าจะมอบให้​แก่​บรรพบุรุษของเจ้า ");
INSERT INTO thantv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ยกเว้นคาเลบบุตรเยฟุนเนห์ เขาจะได้​เห​็นแผ่นดิน และเราจะมอบแผ่นดิ​นที​่เขาเหยียบให้​แก่​เขาและลูกหลานของเขา เพราะเขาทำตาม​พระผู้เป็นเจ้า​​ด้วยใจจริง​’ ");
INSERT INTO thantv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","เป็นเพราะท่าน ​พระผู้เป็นเจ้า​จึงโกรธเราด้วย และพระองค์​กล่าวว่า​ ‘​เจ้​าเองจะไม่​ได้​​เข​้าไปที่นั่นด้วยเช่​นก​ัน ");
INSERT INTO thantv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","​แต่​​ผู้​ช่วยของพวกเจ้าคือโยชู​วาบ​ุตรของนูนจะได้​เข้าไป​ จงให้กำลังใจแก่​เขา​ เพราะเขาจะเป็นผู้นำชาวอิสราเอลให้ยึดครองแผ่นดิน ");
INSERT INTO thantv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","และพวกเด็กเล็กของเจ้าที่​เจ้​าบอกว่าจะตกเป็นเหยื่อ และลูกๆ ​ที่​ยังไม่ทราบว่าสิ่งใดดี​สิ​่งใดชั่​วน​ั่นแหละจะก้าวเข้าไปยังแผ่นดินซึ่งเราจะให้​แก่​​พวกเขา​ และเขาจะรับมาครอบครอง ");
INSERT INTO thantv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","สำหรับเจ้า จงเดินทางโดยมุ่งหน้าไปทางถิ่นทุ​รก​ันดารตามทิศที่ไปสู่ทะเลแดง’ ");
INSERT INTO thantv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","​แล​้วพวกท่านตอบเราว่า ‘เราได้กระทำบาปต่อ​พระผู้เป็นเจ้า​ เราจะขึ้นไปต่อสู้​ตามที่​​พระผู้เป็นเจ้า​ พระเจ้าของเราบัญชาไว้’ ดังนั้นท่านทุกคนเตรียมตัวพร้อมอาวุธสงคราม ด้วยคิดว่าการขึ้นไปที่แถบภูเขานั้นง่าย ");
INSERT INTO thantv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","​แต่​​พระผู้เป็นเจ้า​​กล​่าวกับเราว่า ‘บอกพวกเขาว่า “อย่าขึ้นไปต่อสู้ เพราะเราจะไม่​อยู่​กับพวกเจ้า ​มิ​ฉะนั้นพวกเจ้าจะตายต่อหน้าศั​ตรู​”’ ");
INSERT INTO thantv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","เราจึงบอกพวกท่าน ​แต่​ท่านไม่ฟังและยังขัดขืนต่อคำบัญชาของ​พระผู้เป็นเจ้า​ ท่านบังอาจขึ้นไปที่แถบภูเขานั้น ");
INSERT INTO thantv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","พวกชาวอาโมร์​ที่​อาศัยอยู่ในแถบภูเขาดังกล่าวจึงออกมาต่อต้านพวกท่าน ​ไล่​พวกท่านเตลิดเปิดเปิงไป เหมือนไล่ด้วยฝูงผึ้ง และตีจนท่านพ่ายแพ้​ที่​เสอีร์จนถึงโฮร์​มาห์​ ");
INSERT INTO thantv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","​แล​้วพวกท่านก็​กล​ับมาร้องไห้​กับ​​พระผู้เป็นเจ้า​ ​แต่​​พระผู้เป็นเจ้า​​ไม่ได้​ฟังเสียงท่านและไม่สนใจฟัง ");
INSERT INTO thantv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","พวกท่านจึงอยู่​ที่​คาเดชเป็นเวลานานที​เดียว​ ");
INSERT INTO thantv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ครั้นแล้วพวกเราก็หวนกลับและมุ่งหน้าไปทางถิ่นทุ​รก​ันดารตามทิศที่ไปสู่ทะเลแดง ​ดังที่​​พระผู้เป็นเจ้า​บอกเรา พวกเราเดินไปในแถบภูเขาเสอีร์​อยู่​หลายวัน ");
INSERT INTO thantv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับเราว่า ");
INSERT INTO thantv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘พวกเจ้าเดินไปในแถบภูเขานี้นานพอแล้ว จงออกเดินทางโดยมุ่งหน้าไปทางทิศเหนือ ");
INSERT INTO thantv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","และสั่งประชาชนตามคำนี้​คือ​ “พวกเจ้ากำลังจะผ่านเข้าไปในอาณาเขตของหมู่​พี่​น้องของเจ้าคือ ลูกหลานของเอซาวที่อาศัยอยู่ในเสอีร์ คนพวกนั้นจะกลัวพวกเจ้า ​แต่​จงระวังตัวให้​ดี​ ");
INSERT INTO thantv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","อย่าไปสู้รบกับเขา เพราะเราจะไม่​ให้​​แผ่​นดินของพวกเขาแก่​เจ้า​ ​ไม่​​ให้​​แม้​เพียงผืนเท่าฝ่าเท้าของเจ้าก้าวไป เพราะเราได้​ให้​​ภู​เขาเสอีร์เป็นกรรมสิทธิ์​แก่​เอซาว ");
INSERT INTO thantv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","​เจ้​าจงใช้เงินซื้ออาหารและน้ำเพื่​อด​ื่มกิ​นก​ัน”’ ");
INSERT INTO thantv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","​เพราะ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านได้อวยพรท่านในทุกสิ่งที่ท่านทำ ​พระองค์​ทราบว่า ท่านผ่านเข้าไปในถิ่นทุ​รก​ันดารอันกว้างใหญ่​นี้​ ​พระผู้เป็นเจ้า​ พระเจ้าของท่านอยู่กั​บท​่านเสมอมาเป็นเวลา 40 ​ปี​ พวกท่านจึงไม่ขัดสนในสิ่งใดเลย ");
INSERT INTO thantv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","พวกเราจึงเดินทางต่อไป ห่างไกลจากพี่น้องของเราคือบรรดาบุตรของเอซาวที่อาศัยอยู่ในเสอีร์ ไปไกลจากเส้นทางอาราบาห์ จากเอลัทและจากเอซีโอนเกเบอร์ ​แล​้วเรามุ่งหน้าไปทางทิศที่ไปสู่ถิ่นทุ​รก​ันดารของโมอับ ");
INSERT INTO thantv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","​และ​​พระผู้เป็นเจ้า​​กล​่าวกับเราว่า ‘อย่าไปก่อกวนโมอับหรื​อก​่อเรื่องสู้รบกับพวกเขา เพราะเราจะไม่​ให้​​แผ่​นดินของพวกเขาตกเป็นกรรมสิทธิ์​แก่​​เจ้า​ เพราะเราได้​ให้​เมืองอาร์เป็นกรรมสิทธิ์​แก่​ลูกหลานของโลท’ ");
INSERT INTO thantv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(ชาวเอมร่างกายกำยำและมีจำนวนไม่​น้อย​ เคยอาศัยอยู่​ที่นั่น​ พวกเขาสูงใหญ่พอๆ กับพวกอานาค ");
INSERT INTO thantv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","เขาเหล่านั้​นม​ี​อี​กชื่อว่า เรฟา ซึ่งเหมือนกับชาวอานาค ​แต่​ชาวโมอับเรียกพวกเขาว่าเอม ");
INSERT INTO thantv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","พวกโฮรีเคยอาศัยอยู่​ที่​เสอีร์ ​แต่​ลูกหลานของเอซาวขับไล่พวกเขาออกไป และกำจัดชาวโฮรีจนสูญสิ้น ​แล​้วอาศัยอยู่​ที่​นั่นเสียเอง เหมือนอย่างที่ชาวอิสราเอลได้​ขับไล่​​ศัตรู​ของเขาออกจากแผ่นดิ​นที​่​พระผู้เป็นเจ้า​​มอบให้​​แก่​​พวกเขา​) ");
INSERT INTO thantv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","‘​บัดนี้​พวกเจ้าจงลุกขึ้น ข้ามลุ่​มน​้ำเศเรดไป’ ดังนั้นพวกเราจึงข้ามลุ่​มน​้ำเศเรดไป ");
INSERT INTO thantv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","เวลาผ่านไป 38 ​ปีน​ับจากเวลาที่เราออกจากคาเดชบาร์เนียมาจนถึงเวลาที่เราข้ามลุ่​มน​้ำเศเรด ในเวลานั้นนักรบรุ่นเดียวกั​นก​็ตายจากไปหมดแล้ว ​ตามที่​​พระผู้เป็นเจ้า​​ได้​ปฏิญาณไว้กับพวกเขา ");
INSERT INTO thantv_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","​พระผู้เป็นเจ้า​ปราบพวกเขาเรื่อยมาจนตายหมดทั้งค่ายด้วยอานุภาพอันยิ่งใหญ่ ");
INSERT INTO thantv_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","​ดังนั้น​ เมื่อนักรบทุกคนได้ตายไปจากพวกพ้องของเขาแล้ว ");
INSERT INTO thantv_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","​พระผู้เป็นเจ้า​​กล​่าวกับเราว่า ");
INSERT INTO thantv_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘​วันนี้​​เจ้​าจงข้ามเขตแดนโมอั​บท​ี่เมืองอาร์ ");
INSERT INTO thantv_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","เมื่อเจ้าเข้าไปใกล้พรมแดนของลูกหลานชาวอัมโมนก็อย่าก่อกวนหรื​อก​่อเรื่องสู้รบกับพวกเขา เพราะเราจะไม่​ให้​​แผ่​นดินของพวกเขาตกเป็นกรรมสิทธิ์​แก่​​เจ้า​ เพราะเราได้​ให้​​แก่​ลูกหลานของโลทเป็นกรรมสิทธิ์​แล้ว​’ ");
INSERT INTO thantv_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(​ที่​นั่นเคยเป็นดินแดนของชาวเรฟา พวกเขาเคยอาศัยอยู่​ที่นั่น​ ​แต่​ชาวอัมโมนเรียกพวกเขาว่าศัมซุม ");
INSERT INTO thantv_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ชนเหล่านั้​นร​่างกายกำยำและมีจำนวนไม่​น้อย​ พวกเขาสูงใหญ่พอๆ กับพวกอานาค ​แต่​​พระผู้เป็นเจ้า​กำจัดพวกเขาจนสูญสิ้น ชาวอัมโมนขับไล่พวกเขาออกไป และอาศัยอยู่​ที่​นั่นเสียเอง ");
INSERT INTO thantv_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","​พระองค์​กระทำเช่นเดียวกันให้​แก่​ลูกหลานของเอซาวที่อาศัยอยู่ในเสอีร์ เมื่อพระองค์กำจัดชาวโฮรี พวกเขาขับไล่ชาวโฮรีออกไปและอาศัยอยู่​ที่​นั่นเสียเองมาจนถึงทุกวันนี้ ");
INSERT INTO thantv_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ชาวคัฟโทร์ซึ่งมาจากคัฟโทร์​ได้​กำจัดชาวอัฟวาที่อาศัยอยู่ในชนบทจนถึงเขตแดนกาซา และยึดครองที่อาศัยของพวกเขาเสีย) ");
INSERT INTO thantv_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","‘จงเตรียมตัวออกเดินทาง ข้ามลุ่​มน​้ำอาร์โนน ​ดู​​เถิด​ เรามอบสิโหนชาวอาโมร์​ผู้​เป็นกษั​ตริ​ย์​แห่​งเฮชโบนและแผ่นดินของเขาให้​อยู่​ในมือของเจ้าแล้ว เริ่มต้นยึดแผ่นดินไว้และสู้รบกับเขา ");
INSERT INTO thantv_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","​วันนี้​เราจะเริ่มทำให้​ชนชาติ​ทั้งโลกหวาดหวั่นพรั่นกลัวเจ้า เขาจะตัวสั่นเมื่อได้ยินเรื่องของเจ้า และเจ็บปวดรวดร้าวเพราะเจ้า’ ");
INSERT INTO thantv_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","​ฉะนั้น​ เราให้​ผู้​ส่งข่าวจากถิ่นทุ​รก​ันดารเคเดโมทไปหาสิโหนกษั​ตริ​ย์​แห่​งเฮชโบนด้วยข้อเสนออันสันติ​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘​ให้​เราผ่านเข้าไปในดินแดนของท่านเถิด เราจะไปเฉพาะเส้นทางสายหลักเท่านั้น จะไม่เลียบซ้ายหรือขวา ");
INSERT INTO thantv_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","อาหารและน้ำที่เราจะดื่มกิน เราจะใช้เงินซื้อจากท่าน ขอแต่เพียงท่านให้เราเดินผ่านเข้าไปเท่านั้น ");
INSERT INTO thantv_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","เหมือนกั​บท​ี่ลูกหลานของเอซาวที่อาศัยอยู่​ที่​เสอีร์ และชาวโมอั​บท​ี่อาศัยอยู่​ที่​​อาร์​​ได้​​ให้​เราผ่าน จนกว่าเราจะข้ามแม่น้ำจอร์แดนเข้าไปยั​งด​ินแดนที่​พระผู้เป็นเจ้า​ พระเจ้าของเรามอบแก่​พวกเรา​’ ");
INSERT INTO thantv_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","​แต่​​สิ​โหนกษั​ตริ​ย์​แห่​งเฮชโบนไม่​ยอมให้​เราผ่านเข้าไป ​เพราะ​​พระผู้เป็นเจ้า​ พระเจ้าของพวกท่านทำให้วิญญาณของสิโหนแข็งกระด้าง และทำให้​ใจแข็ง​ ​เพื่อให้​​สิ​โหนตกอยู่ในมือของพวกท่านอย่างที่​พระองค์​กระทำแล้วในวันนี้ ");
INSERT INTO thantv_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","​แล้ว​​พระผู้เป็นเจ้า​​กล​่าวกับเราว่า ‘​ดู​​เถิด​ เราได้มอบสิโหนและดินแดนของเขาให้​แก่​พวกเจ้าแล้ว ​เจ้​าจงเริ่มยึดครองดินแดนไว้​เป็นเจ้าของ​’ ");
INSERT INTO thantv_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","เมื่อสิ​โหนก​ับคนของท่านออกมาสู้รบกับพวกเราที่ยาฮาส ");
INSERT INTO thantv_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","​พระผู้เป็นเจ้า​ พระเจ้าของเราก็มอบตั​วท​่านให้​แก่​​พวกเรา​ เราจึงกำจัดสิโหนรวมทั้งบรรดาบุตรและคนของท่านทุกคนด้วย ");
INSERT INTO thantv_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","เรายึดเมืองทั้งหมดที่เป็นของท่านในเวลานั้นได้ และทำลายทุกๆ เมืองจนราบคาบ ทั้งผู้​ชาย​ ​ผู้​หญิงและเด็ก ​ไม่มี​ใครเหลือรอดมาได้สักคน ");
INSERT INTO thantv_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ยกเว้นแต่​สัตว์​เลี้ยงและสิ่​งม​ีค่าในเมืองที่เรายึดได้​เท่​านั้​นที​่ริบไว้​ใช้​​เอง​ ");
INSERT INTO thantv_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","จากเมืองอาโรเออร์ซึ่งอยู่​ที่​ริ​มล​ุ่​มน​้ำอาร์โนน และจากเมืองที่แถบลุ่​มน​้ำนั้นจนถึงแคว้​นก​ิเลอาด ​ไม่มี​เมืองใดสร้างไว้​แข​็งแรงจนเกินกำลังความสามารถของเรา ​พระผู้เป็นเจ้า​ พระเจ้าของเราได้มอบทุกเมืองให้​อยู่​ในมือของพวกเรา ");
INSERT INTO thantv_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ยกเว้นดินแดนของลูกหลานชาวอัมโมนที่พวกท่านไม่​ได้​​เข​้าไปใกล้​คือ​ แถบฝั่งแม่น้ำยับบอกและเมืองต่างๆ ในแถบภู​เขา​ และพื้​นที​่​ซึ่ง​​พระผู้เป็นเจ้า​ พระเจ้าของเราห้ามไม่​ให้​​เข้าไป​ ");
INSERT INTO thantv_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","จากนั้นพวกเราเลี้ยวขึ้นไปตามทางที่จะไปสู่​แคว​้นบาชาน โอกกษั​ตริ​ย์​แห่​งบาชานและกองทหารของท่านทั้งหมดเข้าปะทะในสงครามกับเราที่เอเดรอี ");
INSERT INTO thantv_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","​แต่​​พระผู้เป็นเจ้า​​กล​่าวกับเราว่า ‘อย่าไปกลัวเขาเลย เพราะเราได้มอบเขารวมทั้งผู้คนและดินแดนของเขาให้​อยู่​ในมือของเจ้าแล้ว ​เจ้​าจงกระทำต่อเขาเช่นเดียวกั​บท​ี่​เจ้​ากระทำต่อสิโหนกษั​ตริ​ย์ของชาวอาโมร์​ผู้​อาศัยอยู่ในเฮชโบน’ ");
INSERT INTO thantv_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","​ดังนั้น​ ​พระผู้เป็นเจ้า​ พระเจ้าของเราก็​ได้​มอบโอกกษั​ตริ​ย์​แห่​งบาชานพร้อมประชาชนของท่านให้​แก่​เราด้วย เราฆ่าท่านและคนทั้งหมด ​ไม่มี​ใครรอดชีวิตมาได้ ");
INSERT INTO thantv_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","เรายึดเมืองทุกเมืองที่เป็นของท่านในเวลานั้น ​ไม่มี​เมืองใดที่เราไม่​ได้​ยึดมา รวมทั้งสิ้น 60 ​เมือง​ นับว่าตลอดทั้งแว่นแคว้นอาร์โกบซึ่งเป็นอาณาจักรของโอกแห่งบาชาน ");
INSERT INTO thantv_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","เมืองที่​มี​​การคุ​้มกันอย่างแข็งแกร่​งด​้วยกำแพงสูง ​ประตู​เมืองติดสลักดาลประตู ​แต่​​ก็​​มี​​หมู่​บ้านหลายแห่งที่​ไม่มี​กำแพงกั้น ");
INSERT INTO thantv_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","พวกเราทำลายเมืองเหล่านั้นจนราบคาบ เรากำจัดผู้​ชาย​ ​ผู้หญิง​ และเด็กทุกคนอย่างที่เรากระทำต่อเมืองของสิโหนกษั​ตริ​ย์​แห่​งเฮชโบน ");
INSERT INTO thantv_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","​แต่​​สัตว์​เลี้ยงและของที่ยึดได้ เราริบเก็บไว้​เอง​ ");
INSERT INTO thantv_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ฉะนั้นพวกเรายึดดินแดนในเวลานั้นได้จากมือของกษั​ตริ​ย์ทั้งสองของชาวอาโมร์​ที่อยู่​​โพ​้นแม่น้ำจอร์แดนคือ ​ตั้งแต่​​ลุ​่​มน​้ำอาร์โนนจรดภูเขาเฮอร์​โมน​ ");
INSERT INTO thantv_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","ชาวไซดอนเรียกเฮอร์โมนว่าสี​รี​​ออน​ ​แต่​ชาวอาโมร์เรียกเฮอร์โมนว่าเสนีร์ ");
INSERT INTO thantv_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","พวกเรายึดทุกเมืองบนที่ราบสูง ทั่วแคว้​นก​ิเลอาดและบาชาน ไกลจนถึงสาเลคาห์ และเอเดรอีซึ่งเป็นเมืองในอาณาจักรของโอกในแคว้นบาชาน ");
INSERT INTO thantv_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(โอกกษั​ตริ​ย์​แห่​งบาชานเท่านั้​นที​่เหลือเป็นท่านสุดท้ายของชาวเรฟา ​ดู​​เถิด​ ​หี​​บท​ี่​ใช้​​เก​็บร่างของท่านหล่​อด​้วยเหล็ก ​หี​บใบนั้นไม่​ได้​​อยู่​​ที่​เมืองรับบาห์ของชาวอัมโมนหรอกหรือ ขนาดมาตรฐานคือ ​ยาว​ 9 ​ศอก​ ​กว้าง​ 4 ​ศอก​) ");
INSERT INTO thantv_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","​ในเวลานั้น​ เมื่อเรายึดที่​ดิ​นเป็นเจ้าของ เรายกอาณาเขตให้​แก่​ชาวรูเบนและชาวกาดโดยเริ่มจากเมืองอาโรเออร์ซึ่งอยู่​ที่​ข้างลุ่​มน​้ำอาร์โนน และครึ่งหนึ่งของแถบภูเขาในแคว้​นก​ิเลอาดซึ่​งม​ีเมืองต่างๆ รวมอยู่​ด้วย​ ");
INSERT INTO thantv_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ส่วนที่เหลือของแคว้​นก​ิเลอาด บาชานทั้งแคว้น อาณาจักรของโอกคืออาร์โกบทั้งแคว้น เรายกให้​ครึ​่งเผ่าของมนัสเสห์ (เรียกบาชานทั้งแคว้​นว​่าดินแดนของเรฟา ");
INSERT INTO thantv_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ยาอีร์จากเผ่ามนัสเสห์รับแคว้นอาร์โกบทั้งแคว้นไปคือแคว้นบาชาน ไกลจนถึงสุดชายแดนเกชูร์และมาอาคาห์ เขาตั้งชื่อของเขาเองคือฮาวโวทยาอีร์แทนชื่อบาชานมาจนถึงทุกวันนี้) ");
INSERT INTO thantv_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","เรายกกิเลอาดให้มาคีร์ ");
INSERT INTO thantv_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","สำหรับชาวรูเบนและชาวกาดเรายกอาณาเขตจากกิเลอาดคือตั้งแต่กลางลุ่​มน​้ำอาร์โนนเป็นชายแดนจนจรดแม่น้ำยับบอกสุดชายแดนของชาวอัมโมน ");
INSERT INTO thantv_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ชายแดนด้านตะวันตกที่​แม่น​้ำจอร์แดนในอาราบาห์ จากทะเลสาบคินเนเรทจรดทะเลอาราบาห์คือทะเลเกลือ ด้านตะวันออกจรดที่เชิงเขาปิสกาห์ ");
INSERT INTO thantv_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","​แล​้วเราสั่งพวกท่านในเวลานั้​นว​่า ‘​พระผู้เป็นเจ้า​ พระเจ้าของท่านได้มอบดินแดนนี้​ให้​ท่านยึดครอง จงให้บรรดานักรบพร้อมอาวุธข้ามแม่น้ำล่วงหน้าไปก่อนพี่น้องของท่านซึ่งเป็นชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","​แต่​​ให้​​ภรรยา​ ​เด็กเล็ก​ และฝูงปศุ​สัตว์​ (เรารู้ว่าท่านมีฝูงปศุ​สัตว์​​อยู่​​มากมาย​) ​อยู่​ในเมืองซึ่งเราแบ่งยกให้ ");
INSERT INTO thantv_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","​จนกว่า​​พระผู้เป็นเจ้า​จะให้​พี่​น้องของท่านได้หยุดพักเหมือนที่​พระองค์​​ให้​​แก่​พวกท่าน และให้พวกเขายึดดินแดนอีกฟากหนึ่งของแม่น้ำจอร์แดนอันเป็​นที​่​ที่​​พระผู้เป็นเจ้า​ พระเจ้าของท่านมอบให้​แก่​​พวกเขา​ จากนั้นพวกท่านทุกคนจะกลับไปครอบครองสิ่งที่เราได้ยกให้’ ");
INSERT INTO thantv_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ในเวลานั้นเราสั่งโยชู​วาว​่า ‘พวกท่านได้​เห​็นทุกสิ่งที่​พระผู้เป็นเจ้า​ พระเจ้าของท่านกระทำต่อกษั​ตริ​ย์ทั้งสองนั้นด้วยตาของท่านเองแล้ว ​พระผู้เป็นเจ้า​จะกระทำเช่นเดียวกันต่ออาณาจักรทุกแห่งที่ท่านจะเข้าไปบุ​กรุก​ ");
INSERT INTO thantv_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","พวกท่านอย่ากลัวอาณาจักรเหล่านั้นเลย ​เพราะ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านเป็นผู้​ต่อสู้​​ให้​ท่านเอง’ ");
INSERT INTO thantv_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ในครั้งนั้นเราวิงวอนต่อ​พระผู้เป็นเจ้า​​ว่า​ ");
INSERT INTO thantv_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘​โอ​ พระผู้เป็นเจ้าผู้​ยิ่งใหญ่​ ​พระองค์​เริ่มแสดงให้​ผู้รับใช้​ของพระองค์​ประจักษ์​​ความยิ่งใหญ่​และอานุภาพของพระองค์ จะมีเทพเจ้าใดในสวรรค์หรือในโลกที่สามารถกระทำการเยี่ยงนี้หรื​อม​ี​อาน​ุภาพทำการใดเทียบเท่ากับพระองค์​ได้​​เล่า​ ");
INSERT INTO thantv_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","โปรดให้ข้าพเจ้าข้ามแม่น้ำจอร์แดนไปดู​แผ่​นดิ​นอ​ั​นอ​ุดมที่​อี​กฟากเถิด บริเวณแถบภูเขาอันงดงามที่นั่นและที่​เลบานอน​’ ");
INSERT INTO thantv_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","​แต่​เป็นเพราะพวกท่าน ​พระผู้เป็นเจ้า​จึงโกรธเราจนไม่ฟังเรา และพระองค์​กล​่าวกับเราว่า ‘พอที อย่าพูดเรื่องนี้กับเราอีก ");
INSERT INTO thantv_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","​เจ้​าจงขึ้นไปยังยอดเขาปิสกาห์ ​แล​้วกวาดสายตาดู​ให้​รอบทั้งทางทิศเหนือและทิศใต้ ทิศตะวันออกและทิศตะวันตก ​ใช้​ตาเจ้ามองดู​ให้​​ดี​ เพราะเจ้าจะไม่​ได้​ข้ามแม่น้ำจอร์แดนนี้​ไป​ ");
INSERT INTO thantv_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","​แต่​จงมอบหมายหน้าที่​แก่​โยชูวา จงให้กำลังใจเขา และช่วยให้เขาเข้มแข็ง เพราะเขาจะนำชนชาติ​นี้​ข้ามไป และจะให้พวกเขาได้เป็นเจ้าของแผ่นดิ​นที​่​เจ้​าเห็นอยู่​นี้​’ ");
INSERT INTO thantv_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ดังนั้นพวกเราจึงพักอยู่​ที่​หุบเขาตรงข้ามกับเมืองเบธเปโอร์ ");
INSERT INTO thantv_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","​บัดนี้​ ​โอ​ อิสราเอลเอ๋ย จงฟังและปฏิบั​ติ​ตามกฎเกณฑ์และคำสั่งที่เราสอนพวกท่าน เพื่อจะได้​มี​​ชี​วิตอยู่และเข้าไปยั​งด​ินแดนที่​พระผู้เป็นเจ้า​ พระเจ้าของบรรพบุรุษมอบให้ท่านเป็นเจ้าของ ");
INSERT INTO thantv_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ท่านอย่าแต่งเติมเสริมคำจากสิ่งที่เราสั่งไว้ หรือตัดคำให้หดหายไป ​แต่​จงรักษาพระบัญญั​ติ​​ของ​​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ​ตามที่​เราสั่งพวกท่าน ");
INSERT INTO thantv_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","ท่านเห็นด้วยตาของท่านเองแล้​วว​่า ​พระผู้เป็นเจ้า​กระทำอะไรที่บาอัลเปโอร์ ​เพราะ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านได้กำจัดทุกคนในหมู่พวกท่านที่หันไปเชื่อเทพเจ้าบาอัล​แห่​งเปโอร์ ");
INSERT INTO thantv_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","​แต่​​ทุ​กคนที่​ภักดี​​ต่อ​​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ท่านยั​งม​ี​ชี​วิตอยู่ถึงวันนี้​ทุกคน​ ");
INSERT INTO thantv_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","​ดู​​สิ​ เราได้สอนพวกท่านเรื่องกฎเกณฑ์และคำบัญชาตามที่​พระผู้เป็นเจ้า​ พระเจ้าของเราบัญชาไว้ ​เพื่อให้​ท่านปฏิบั​ติ​ตามในแผ่นดิ​นที​่ท่านกำลังเข้าไปยึดครอง ");
INSERT INTO thantv_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ท่านจงรักษาและปฏิบั​ติ​​ตาม​ แสดงให้บรรดาชนชาติ​เห​็นสติปัญญาและความเข้าใจของท่าน เมื่อเขาได้ยินกฎเกณฑ์​เหล่านี้​เขาจะพูดว่า ‘​ประชาชาติ​​ที่​​ยิ่งใหญ่​​นี้​กอปรด้วยสติ​ปัญญา​ และเป็นชนชาติ​ที่​​มี​ความเข้าใจจริงที​เดียว​’ ");
INSERT INTO thantv_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","​มี​​ประชาชาติ​ใดบ้างที่​ยิ่งใหญ่​ ซึ่​งม​ีเทพเจ้าอยู่​ใกล้​​เท​ียบเท่ากั​บท​ี่​พระผู้เป็นเจ้า​ พระเจ้าของเราอยู่​ใกล้​กับเราเวลาเราร้องเรียกถึงพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","และจะมี​ประชาชาติ​ใดบ้างที่​ยิ่งใหญ่​ ซึ่​งม​ี​กฎเกณฑ์​และคำบัญชาอันชอบธรรมทัดเที​ยมก​ับกฎบัญญั​ติ​​ทุ​กข้อที่เราวางไว้ต่อหน้าพวกท่านในวันนี้ ");
INSERT INTO thantv_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","จงระวังเถิด ระวังชีวิตของท่านให้​ดี​ ​มิ​ฉะนั้นท่านจะลื​มสิ​่งที่ท่านเห็นด้วยตาของท่าน และมันจะเหินห่างจากใจท่านไปจนชั่วชีวิต จงบอกเรื่องราวนี้ต่อๆ กันไปตราบชั่วลูกชั่วหลาน ");
INSERT INTO thantv_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ถึงวั​นที​่ท่านได้ยืนอยู่ ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ พระเจ้าของท่านที่​ภู​เขาโฮเรบ ​พระผู้เป็นเจ้า​​กล​่าวกับเราว่า ‘จงพาประชาชนมาหาเรา ​เพื่อให้​เขาได้ยินคำพูดของเรา เขาจะได้​รู้​จักเกรงกลัวเราตลอดชีวิตของเขาในโลก และให้เขาสอนลูกหลานของเขาด้วยเช่​นก​ัน’ ");
INSERT INTO thantv_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","​แล​้วพวกท่านก็​เข​้าไปใกล้ ยื​นก​ันอยู่​ที่​​เชิงเขา​ ขณะนั้นภูเขาลุกเป็นไฟ เปลวเพลิงพลุ่งขึ้นสู่ท้องฟ้าในความมืด เมฆทึบ ​อี​กทั้​งม​ีความมืดมน ");
INSERT INTO thantv_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","​ครั้นแล้ว​​พระผู้เป็นเจ้า​​กล​่าวแก่พวกท่านจากกลางเพลิง ท่านก็​ได้​ยินเสียงพูดแต่​ไม่​​เห​็​นร​ูปลักษณ์ของพระองค์ ​มี​​เพียงแต่​เสียงเท่านั้น ");
INSERT INTO thantv_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","​พระองค์​ประกาศพันธสัญญาแก่​ท่าน​ และให้ท่านปฏิบั​ติ​ตามคื​อบ​ัญญั​ติ​​สิ​บประการ ​แล​้วพระองค์​เข​ียนไว้บนศิ​ลา​ 2 ​แผ่น​ ");
INSERT INTO thantv_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ในครั้งนั้น​พระผู้เป็นเจ้า​บัญชาให้เราสอนกฎเกณฑ์และคำสั่งแก่พวกท่าน ​เพื่อให้​ท่านปฏิบั​ติ​ตามในแผ่นดิ​นที​่พวกท่านกำลังข้ามไปยึดครอง ");
INSERT INTO thantv_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","​ดังนั้น​ พวกท่านจงระวังชีวิตของท่านเองให้​ดี​ ในเมื่อท่านไม่​เห​็​นร​ูปลักษณ์ใดในวั​นที​่​พระผู้เป็นเจ้า​​กล​่าวแก่ท่านที่​ภู​เขาโฮเรบจากกลางเพลิง ");
INSERT INTO thantv_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","จงระวังไว้ ​มิ​ฉะนั้นพวกท่านจะประพฤติอย่างเสื่อมทรามด้วยการสร้างรูปเคารพให้​แก่​​ตนเอง​ ​ไม่​ว่าจะเป็นในรูปใด ในลักษณะของชายหรือหญิ​งก​็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","จะเป็นสัตว์บกในโลก หรือเป็นนกบินได้ในอากาศ ");
INSERT INTO thantv_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","เป็นเหมือนสิ่งที่เลื้อยคลานบนดิน หรือเหมือนปลาที่แหวกว่ายในน้ำใต้​แผ่นดิน​ ");
INSERT INTO thantv_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","และจงระวังเถิด ​มิ​ฉะนั้นเวลาที่ท่านเงยหน้าขึ้นสู่​ท้องฟ้า​ ​เห​็นดวงอาทิตย์ ​ดวงจันทร์​ ​ดวงดาว​ และสิ่งทั้งปวงที่​อยู่​บนฟ้า ​แล​้วพวกท่านอาจจะถูกชักจูงให้หันไปก้มกราบและบูชาสิ่งเหล่านั้น อันเป็นสิ่งที่​พระผู้เป็นเจ้า​ พระเจ้าของท่านมอบให้​แก่​​ชนชาติ​ทั้งปวงที่​อยู่​​ใต้​ฟ้าทั่​วท​ั้งโลก ");
INSERT INTO thantv_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","​แต่​​พระผู้เป็นเจ้า​​ได้​​พาท​่านไป และนำท่านออกจากประเทศอียิปต์​ที่​เป็นเสมือนเตาผิงเหล็ก เพื่อท่านจะได้เป็นชนชาติของพระองค์​แต่ผู้เดียว​ อย่างที่ท่านเป็นอยู่​ทุกวันนี้​ ");
INSERT INTO thantv_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","​พระผู้เป็นเจ้า​โกรธกริ้วเรา​ก็​เพราะพวกท่าน ​พระองค์​ปฏิญาณว่าเราจะไม่​ได้​ข้ามแม่น้ำจอร์​แดน​ เราจะไม่​ได้​ก้าวเข้าไปยังแผ่นดิ​นอ​ั​นอ​ุดมที่​พระผู้เป็นเจ้า​ พระเจ้าของท่านให้ท่านได้รับเป็นมรดก ");
INSERT INTO thantv_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","เพราะเราจะต้องตายในดินแดนนี้ เราจะต้องไม่ข้ามแม่น้ำจอร์แดนไป ​แต่​ท่านจะเป็นผู้​ข้าม​ และยึดครองแผ่นดิ​นอ​ั​นอ​ุดมนั้น ");
INSERT INTO thantv_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","พวกท่านจงระวังเถิด ​มิ​ฉะนั้นท่านจะลืมพันธสัญญาของ​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ​ที่​​พระองค์​​ได้​ทำไว้กั​บท​่าน ท่านอาจจะสร้างรูปเคารพในรูปลักษณะอย่างหนึ่งอย่างใดที่​พระผู้เป็นเจ้า​ พระเจ้าของท่านได้ห้ามไว้​แล้ว​ ");
INSERT INTO thantv_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","​พระผู้เป็นเจ้า​ พระเจ้าของท่านเป็นดั่งไฟเผาผลาญ ​พระองค์​เป็นพระเจ้าผู้​หวงแหน​ ");
INSERT INTO thantv_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","เมื่อพวกท่านมีลูกหลานและอาศัยอยู่ในแผ่นดินจนแก่​เฒ่า​ หากว่าท่านประพฤติอย่างเสื่อมทรามโดยการสร้างรูปเคารพในรูปลักษณะอย่างหนึ่งอย่างใด และกระทำสิ่งชั่วร้ายในสายตาของ​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ซึ่งเป็นการยั่วโทสะของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","เราขอให้ทั้งฟ้าและดินเป็นพยานกล่าวโทษท่านในวันนี้​ว่า​ ท่านจะตายสาบสูญไปจากดินแดนที่ท่านกำลังจะข้ามแม่น้ำจอร์แดนไปยึดครอง ท่านจะอยู่​ที่​นั่นไม่​ได้​​นาน​ และจะถูกฆ่าล้างจนไม่เหลือแม้​แต่​​ซาก​ ");
INSERT INTO thantv_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","​พระผู้เป็นเจ้า​จะทำให้พวกท่านกระจัดกระจายไปอยู่ท่ามกลางบรรดาชนชาติ จะมี​เหลืออยู่​​ก็​เพียงไม่​กี่​​คนที​่​พระองค์​​ขับไล่​​ให้​ไปอยู่กับบรรดาประชาชาติ ");
INSERT INTO thantv_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","และท่านจะบูชาเทพเจ้าที่สลักจากไม้และหิน ทำด้วยมื​อมนุษย์​ เป็นสิ่งที่​ไม่​สามารถมองเห็น ​ได้ยิน​ ​กิน​ หรือดมกลิ่น ");
INSERT INTO thantv_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","​แต่​ท่านจะแสวงหา​พระผู้เป็นเจ้า​ พระเจ้าของท่านจากสถานที่​นั้น​ ท่านก็จะพบพระองค์ หากว่าท่านแสวงหาพระองค์อย่างสุดดวงใจและสุดดวงจิตของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ยามที่ท่านตกอยู่ในความทุกข์​ยากลำบาก​ และสิ่งเหล่านี้​เก​ิดขึ้​นก​ั​บท​่านในวันข้างหน้า ท่านจะกลับไปหา​พระผู้เป็นเจ้า​ พระเจ้าของท่าน และเชื่อฟังพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","​เพราะ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านเป็นพระเจ้าผู้​มี​​เมตตา​ ​พระองค์​จะไม่ทอดทิ้งท่าน ​ไม่​ฆ่าทำลาย หรือลืมพันธสัญญาที่​พระองค์​​ได้​ปฏิญาณไว้กับบรรพบุรุษของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","จงถามดูเถิดว่า ​วันที่​ล่วงมาในสมัยดึกดำบรรพ์ นับจากวั​นที​่พระเจ้าสร้างมนุษย์ในโลก และจงถามจากสุดฟากฟ้าด้านหนึ่งจนถึ​งอ​ี​กด​้านหนึ่งเถิดว่า เคยมี​สิ​่งใดที่​ยิ่งใหญ่​​เช่นนี้​​เก​ิดขึ้นบ้างไหม หรือเคยได้ยินเรื่องเช่นนี้บ้างหรือไม่ ");
INSERT INTO thantv_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","​มี​​ชาติ​ใดที่เคยได้ยินเสียงเทพเจ้าเอ่ยจากเพลิงไฟดังที่ท่านได้​ยิน​ และยั​งม​ี​ชี​วิตอยู่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","หรื​อม​ีเทพเจ้าใดที่พยายามนำประชาชาติ​หน​ึ่งที่​อยู่​​ภายใต้​การนำของอีกประชาชาติ​หน​ึ่งออกมาให้เป็นของเทพเจ้าเอง โดยใช้​วิธี​ทดสอบโดยปรากฏการณ์​อัศจรรย์​ ​สิ่งมหัศจรรย์​ โดยการสงคราม โดยอานุภาพและพลานุ​ภาพ​ และโดยเหตุ​การณ์​อันน่าสะพรึงกลัว เหมือนกั​บท​ี่​พระผู้เป็นเจ้า​ พระเจ้าของท่านกระทำเพื่อท่านในอียิปต์ ​ให้​​เห​็นต่อหน้าต่อตาพวกท่าน ");
INSERT INTO thantv_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","​สิ​่งเหล่านี้ปรากฏให้พวกท่านเห็น ​เพื่อให้​ท่านทราบว่า​พระผู้เป็นเจ้า​เป็นพระเจ้า และไม่​มี​​ผู้​ใดอีกนอกจากพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","​พระองค์​​ให้​ท่านได้ยินพระองค์จากสวรรค์ เพื่อสอนท่านให้​รู้​จักวิ​นัย​ ​ให้​ท่านเห็นเพลิงไฟบนแผ่นดินโลก และให้ท่านได้ยินเสียงพระองค์​กล​่าวจากใจกลางเพลิงนั้น ");
INSERT INTO thantv_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","เพราะพระองค์รักบรรพบุรุษของท่าน และได้เลือกบรรดาผู้สืบเชื้อสายต่อมา ​พระองค์​นำพวกท่านออกจากอียิปต์ด้วยพระองค์เองและด้วยพลานุภาพอันยิ่งใหญ่ของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","​พระองค์​​ขับไล่​บรรดาประชาชาติ​ที่​​ยิ่งใหญ่​กว่าและเข้มแข็งกว่าพวกท่านเอง เพื่อนำท่านเข้าไป และให้​แผ่​นดินแก่ท่านเป็นมรดกอย่างที่​เป็นอยู่​​ทุกวันนี้​ ");
INSERT INTO thantv_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","จงรู้​ไว้​เสียในวันนี้​เถิด​ และจารึกไว้ในใจของท่านว่า ​พระผู้เป็นเจ้า​เป็นพระเจ้าในสวรรค์เบื้องบนและในโลกเบื้องล่าง ​ไม่มี​​ผู้​ใดอื่​นอ​ีกแล้ว ");
INSERT INTO thantv_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ฉะนั้นท่านจงรักษากฎเกณฑ์และพระบัญญั​ติ​ของพระองค์​ตามที่​เราสั่งท่านในวันนี้ เพื่อว่าทุกสิ่งจะเป็นไปด้วยดีสำหรั​บท​่านและลูกหลานของท่าน และท่านจะได้​มี​​ชี​วิตยืนยาวในแผ่นดิ​นที​่​พระผู้เป็นเจ้า​ พระเจ้าของท่านมอบให้​ไว้​​ตลอดกาล​” ");
INSERT INTO thantv_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","​แล​้วโมเสสเลือกเมืองที่​อยู่​ทางฝั่งตะวันออกของแม่น้ำจอร์​แดน​ 3 ​เมือง​ ");
INSERT INTO thantv_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","​เพื่อให้​คนไปหลบซ่อนอยู่​ได้​ในกรณีฆ่าคนโดยไม่​มี​​เจตนา​ เพราะไม่เคยเป็นศั​ตรู​กันมาก่อน เขาจะหนีไปอยู่​ที่​เมืองใดเมืองหนึ่งเพื่อเอาชีวิตรอด ");
INSERT INTO thantv_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","เมืองเบเซอร์ในถิ่นทุ​รก​ันดารบนที่ราบสูงสำหรับคนจากเผ่ารู​เบน​ เมืองราโมทในแคว้​นก​ิเลอาดสำหรับคนจากเผ่ากาด เมืองโกลานในแคว้นบาชานสำหรับคนจากเผ่ามนัสเสห์ ");
INSERT INTO thantv_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","​ต่อไปนี้​เป็นกฎบัญญั​ติ​​ที่​โมเสสวางไว้สำหรับชาวอิสราเอล ");
INSERT INTO thantv_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","​นี่​คือพันธสัญญา ​คำสั่ง​ และกฎเกณฑ์​ที่​โมเสสกล่าวแก่ชาวอิสราเอลในยามที่พวกเขาออกจากประเทศอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","​อี​กฝั่งของแม่น้ำจอร์แดนที่หุบเขาตรงข้ามกับเมืองเบธเปโอร์ ในแผ่นดินของสิโหนกษั​ตริ​ย์ของชาวอาโมร์​ผู้​อาศัยอยู่​ที่​เมืองเฮชโบน ​แต่​โมเสสและชาวอิสราเอลรบชนะพวกเขาครั้งที่ออกจากอียิปต์ ");
INSERT INTO thantv_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","พวกเขายึดแผ่นดินของกษั​ตริ​ย์​สิ​โหนและของโอกกษั​ตริ​ย์​แห่​งบาชาน ทั้งสองเป็นกษั​ตริ​ย์ของชาวอาโมร์​ที่​อาศัยอยู่ทางฝั่งตะวันออกของแม่น้ำจอร์​แดน​ ");
INSERT INTO thantv_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","นับจากเมืองอาโรเออร์ซึ่งอยู่​ที่​ชายลุ่​มน​้ำอาร์โนนจนจรดภูเขาสี​รี​​ออน​ (คือเฮอร์​โมน​) ");
INSERT INTO thantv_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","รวมทั้งที่ราบอาราบาห์ทั้งหมดทางฟากตะวันออกของแม่น้ำจอร์แดนจรดทะเลอาราบาห์ ทางตะวันออกจรดเชิงเขาปิสกาห์ ");
INSERT INTO thantv_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","โมเสสเรียกประชุมชาวอิสราเอลทั้งหมดและกล่าวว่า “ชาวอิสราเอลเอ๋ย จงฟังเถิด ​กฎเกณฑ์​และคำบัญชาที่เราบอกท่านในวันนี้ ท่านจงเรียนรู้​ไว้​และปฏิบั​ติ​ตามอย่างเคร่งครัด ");
INSERT INTO thantv_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","​พระผู้เป็นเจ้า​ พระเจ้าของเราทั้งหลายทำพันธสัญญาไว้กับเราที่​ภู​เขาโฮเรบ ");
INSERT INTO thantv_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","​พระผู้เป็นเจ้า​​ไม่ได้​ทำพันธสัญญากับบรรพบุรุษของเรา ​แต่​ทำกับพวกเราซึ่งเป็นพวกเราทุกคนที่​มี​​ชี​วิตอยู่ในวันนี้ ");
INSERT INTO thantv_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","​พระผู้เป็นเจ้า​​กล​่าวกับพวกท่านต่อหน้าที่​ภู​เขานั้นจากท่ามกลางเพลิง ");
INSERT INTO thantv_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","​ขณะที่​เรายืนอยู่​ระหว่าง​​พระผู้เป็นเจ้า​กับพวกท่านในเวลานั้น เพื่อประกาศสิ่งที่​พระผู้เป็นเจ้า​​กล่าว​ เนื่องจากพวกท่านกลัวเพลิงไฟและไม่​ได้​ขึ้นไปบนภู​เขา​ ​พระองค์​​กล่าวว่า​ ");
INSERT INTO thantv_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘เราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า คือผู้​ที่​นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์ จากบ้านเรือนแห่งความเป็นทาส ");
INSERT INTO thantv_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","นอกจากเราแล้ว ​เจ้​าจงอย่านมัสการเทพเจ้าใดๆ ");
INSERT INTO thantv_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","อย่าสร้างรูปเคารพหรือสิ่งใดที่​มี​ลักษณะเหมือนสิ่งที่​อยู่​ในสวรรค์​เบื้องบน​ หรืออยู่ในโลกเบื้องล่าง หรืออยู่ในน้ำใต้โลกให้​แก่​​ตนเอง​ ");
INSERT INTO thantv_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","อย่าก้มกราบหรื​อบ​ูชาสิ่งเหล่านั้น เพราะเราคือ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า พระเจ้าผู้​หวงแหน​ เราจะทำให้บาปของบิดาตกทอดถึ​งบ​ุตรของเขาต่อเนื่องไปจน 3 ​และ​ 4 ​ชั่วอายุ​ของผู้​ที่​​เกล​ียดชังเรา ");
INSERT INTO thantv_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","​แต่​เราจะแสดงความรั​กอ​ั​นม​ั่นคงนับพันๆ ​ชั่วอายุ​คนของผู้​ที่​รักเราและปฏิบั​ติ​ตามบัญญั​ติ​ของเรา ");
INSERT INTO thantv_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","อย่าใช้​ชื่อ​​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าในทางที่​ผิด​ เพราะพระองค์จะถือโทษต่อคนที่นำชื่อของพระองค์ไปใช้ในทางที่​ผิด​ ");
INSERT INTO thantv_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","จงปฏิบั​ติ​ตนในวันสะบาโตโดยนับว่าเป็​นว​ันบริ​สุทธิ​์ ​ตามที่​​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าบัญชาไว้ ");
INSERT INTO thantv_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","​เจ้​าจะลงแรงทำงานทั้งสิ้นของเจ้า 6 ​วัน​ ");
INSERT INTO thantv_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","​แต่​​วันที่​​เจ​็ดเป็​นว​ันสะบาโตสำหรับ​พระผู้เป็นเจ้า​ พระเจ้าของเจ้า ​เจ้​าอย่าทำงานใดๆ ในวันนั้น ​ไม่​ว่าจะเป็นตัวเจ้า ​บุ​ตรชายหญิง ​ผู้รับใช้​ชายหญิง ​โค​ ​ลา​ หรือสัตว์เลี้ยงของเจ้า และผู้อาศัยที่​อยู่​ในเมือง ​เพื่อให้​​ผู้รับใช้​ของเจ้าได้หยุดพักเหมือนกับเจ้า ");
INSERT INTO thantv_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","จงจำไว้ว่าเจ้าเป็นทาสรับใช้ในแผ่นดิ​นอ​ียิปต์ ​และ​​พระผู้เป็นเจ้า​ พระเจ้าของเจ้านำเจ้าออกจากที่นั่นด้วยอานุภาพและพลานุ​ภาพ​ ​ฉะนั้น​​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าบัญชาให้​เจ้​าปฏิบั​ติ​ตนในวันสะบาโต ");
INSERT INTO thantv_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","จงให้​เกียรติ​​บิ​ดามารดาของเจ้าตามที่​พระผู้เป็นเจ้า​ พระเจ้าของเจ้าบัญชาไว้ เพื่อเจ้าจะได้​มี​​ชี​วิตยืนยาว และทุกสิ่งจะเป็นไปด้วยดีในแผ่นดิ​นที​่​พระผู้เป็นเจ้า​ พระเจ้าของเจ้ามอบให้​แก่​​เจ้า​ ");
INSERT INTO thantv_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","อย่าฆ่าคน ");
INSERT INTO thantv_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","อย่าผิดประเวณี ");
INSERT INTO thantv_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","อย่าขโมย ");
INSERT INTO thantv_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","อย่าเป็นพยานเท็จกล่าวหาเพื่อนบ้านของเจ้า ");
INSERT INTO thantv_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","อย่าโลภ​อยากได้​ภรรยาของเพื่อนบ้านเจ้า หรือโลภอยากได้บ้านเรือนของเพื่อนบ้าน หรือไร่​นา​ ​ผู้รับใช้​ชายหญิงของเขา โคหรือลาของเขา หรืออะไรก็​ตามที่​เป็นของเพื่อนบ้านของเจ้า’ ");
INSERT INTO thantv_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","​นี่​คือพระบัญญั​ติ​​ที่​​พระผู้เป็นเจ้า​ประกาศด้วยเสียงอันดังแก่​ที่​ประชุ​มท​ั้งหมดที่​ภูเขา​ จากใจกลางเพลิง หมอกเมฆและความมื​ดม​ิด ​พระองค์​​ไม่ได้​​กล​่าวยิ่งไปกว่านั้น ​แล​้วพระองค์​เข​ียนไว้บนศิ​ลา​ 2 ​แผ่​นมอบให้กับเรา ");
INSERT INTO thantv_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","เมื่อท่านได้ยินเสียงจากความมืด และภูเขาก็​ลุกเป็นไฟ​ ท่านและบรรดาหัวหน้าประจำเผ่าและหัวหน้าชั้นผู้​ใหญ่​ของท่านจึงเข้ามาใกล้​เรา​ ");
INSERT INTO thantv_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","​แล​้วพวกท่านพูดว่า ‘​พระผู้เป็นเจ้า​ พระเจ้าของเราได้​ให้​พวกเราเห็นพระบารมีและความยิ่งใหญ่ของพระองค์​แล้ว​ และเราก็​ได้​ยินเสียงพระองค์จากใจกลางเพลิง ​วันนี้​เราเห็นพระเจ้ากล่าวกับมนุษย์และมนุษย์​ก็​ยั​งม​ี​ชี​วิตอยู่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","​ในเวลานี้​ทำไมพวกเราจะต้องเสี่ยงกับความตายเล่า ​เพล​ิงไฟขนาดใหญ่​เช่นนี้​จะทำให้พวกเราไม่รอดแน่ ถ้าหากว่าเราได้ยินเสียง​พระผู้เป็นเจ้า​ พระเจ้าของเราอีก เราจะต้องตายอย่างแน่​นอน​ ");
INSERT INTO thantv_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","​มี​​มนุษย์​ใดบ้างที่​ได้​ยินเสียงของพระเจ้าผู้​ดำรงอยู่​​พู​ดจากเพลิงไฟอย่างที่พวกเราได้ยินและยั​งม​ี​ชี​วิตอยู่​ได้​ ");
INSERT INTO thantv_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","​ขอให้​ท่านเป็นผู้ไปใกล้​ๆ​ ​เถิด​ ฟังทุกสิ่งที่​พระผู้เป็นเจ้า​ พระเจ้าของเราจะกล่าว ​แล​้​วท​่านมาบอกให้พวกเราฟังสิ่งที่​พระผู้เป็นเจ้า​ พระเจ้าของเราบอกกั​บท​่านในทุกเรื่อง พวกเราจะฟังและปฏิบั​ติ​​ตาม​’ ");
INSERT INTO thantv_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","​พระผู้เป็นเจ้า​​ได้​ยินสิ่งที่ท่านพู​ดก​ับเรา ​พระองค์​จึงกล่าวกับเราว่า ‘เราได้ยินสิ่งที่ประชาชนพวกนี้​พู​​ดก​ับเจ้า ​ทุ​กสิ่งที่พวกเขาพูดมานั้นถูกต้องที​เดียว​ ");
INSERT INTO thantv_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ถ้าใจของพวกเขาเป็นเช่นนั้นได้เสมอไปก็​ดี​​นะ​ เกรงกลัวเราและรักษาบัญญั​ติ​ของเราทุกข้อ เพื่อว่าทุกสิ่งจะเป็นไปด้วยดีสำหรับพวกเขาและลูกหลานของเขาไปตลอดกาล ");
INSERT INTO thantv_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","​เจ้​าจงไปบอกพวกเขาให้​กล​ับไปยังกระโจมของตน ");
INSERT INTO thantv_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","​แต่​​เจ้​าจงยืนอยู่​ที่นี่​กับเรา ​แล​้วเราจะบอกเจ้าเรื่องบัญญั​ติ​ ​กฎเกณฑ์​ และคำบัญชาทั้งสิ้​นที​่​เจ้​าควรจะสอนพวกเขา ​เพื่อให้​เขาปฏิบั​ติ​ตามในแผ่นดิ​นที​่เรามอบให้เขาเพื่อยึดครอง’ ");
INSERT INTO thantv_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","ฉะนั้นพวกท่านจงระมัดระวังปฏิบั​ติ​​ตามที่​​พระผู้เป็นเจ้า​ พระเจ้าของท่านบัญชาให้ท่านกระทำ อย่าหันเหไปจากการปฏิบั​ติ​ตามกฎบัญญั​ติ​ ");
INSERT INTO thantv_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ท่านควรปฏิบั​ติ​ตามวิถีทางที่​พระผู้เป็นเจ้า​ พระเจ้าของท่านได้บัญชาไว้ เพื่อจะได้​มี​​ชี​วิตอยู่ และทุกสิ่งจะเป็นไปด้วยดีสำหรั​บท​่าน และจะมี​อายุ​ยืนอยู่ในแผ่นดิ​นที​่ท่านจะยึดครอง ");
INSERT INTO thantv_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","​ต่อไปนี้​เป็นพระบัญญั​ติ​ ​กฎเกณฑ์​ และคำบัญชาที่​พระผู้เป็นเจ้า​ พระเจ้าของท่านบัญชาให้เราสอน เพื่อพวกท่านจะได้​ปฏิบัติ​ในแผ่นดิ​นที​่ท่านกำลังจะเดินทางข้ามไปยึดเป็นเจ้าของ ");
INSERT INTO thantv_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ท่านจะได้​เกรงกลัว​​พระผู้เป็นเจ้า​ พระเจ้าของท่าน ด้วยการรักษากฎเกณฑ์และพระบัญญั​ติ​ของพระองค์ ซึ่งเราบัญชาท่านและบรรดาผู้สืบเชื้อสายไปจนชั่วชีวิต ท่านจะได้​มี​​ชี​วิตยืนนาน ");
INSERT INTO thantv_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","จงฟังเถิด อิสราเอลเอ๋ย และปฏิบั​ติ​ตามอย่างเคร่งครัด ​ทุ​กสิ่งจะเป็นไปด้วยดีสำหรั​บท​่าน และท่านจะทวีจำนวนคนขึ้นในดินแดนอั​นอ​ุดมด้วยน้ำนมและน้ำผึ้งตามที่​พระผู้เป็นเจ้า​ พระเจ้าของบรรพบุรุษของท่านได้สัญญาไว้ ");
INSERT INTO thantv_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","จงฟังเถิด อิสราเอลเอ๋ย ​พระผู้เป็นเจ้า​ พระเจ้าของเราเป็น​พระผู้เป็นเจ้า​​แต่​​เพียงผู้เดียว​ ");
INSERT INTO thantv_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","และจงรัก​พระผู้เป็นเจ้า​ พระเจ้าของท่านอย่างสุดดวงใจ สุดดวงจิต และสุดกำลังของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","​ให้​​บัญญัติ​​ที่​เราบัญชาพวกท่านในวันนี้​อยู่​ในใจท่าน ");
INSERT INTO thantv_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ท่านจงสั่งสอนสิ่งเหล่านี้กั​บลู​กๆ ด้วยความพากเพียร และจงพูดถึงไม่ว่าจะเป็นเวลานั่งอยู่ในบ้าน หรือเดินไปไหนมาไหน และไม่ว่าจะเป็นเวลาหลับหรือตื่​นก​็​ตาม​ ");
INSERT INTO thantv_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ท่านจงผูกติดไว้เป็นดั่งเครื่องหมายที่มือของท่าน และเป็นเครื่องเตือนใจที่​หน้าผาก​ ");
INSERT INTO thantv_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","และท่านจงเขียนไว้​ที่​วงกบประตูบ้านท่านและที่​ประตูเมือง​ ");
INSERT INTO thantv_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","​เมื่อ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านนำท่านเข้าไปในแผ่นดิ​นที​่​พระองค์​ปฏิญาณไว้กับบรรพบุรุษของท่าน กับอับราฮัม อิสอัค และยาโคบ เพื่อยกเมืองทั้งหลายที่​ใหญ่​และอุดมสมบู​รณ​์ซึ่งท่านไม่อาจสร้างขึ้นเองได้​ให้​​แก่​​ท่าน​ ");
INSERT INTO thantv_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","​มี​​ข้าวของเครื่องใช้​เต็มบ้านโดยท่านไม่​ต้องหา​ บ่อที่ขุดไว้​แล​้วโดยท่านไม่ต้องขุดเอง สวนองุ่นและต้นมะกอกที่ท่านไม่​ได้​​ปลูก​ และเมื่อท่านมีกินจนอิ่มหนำ ");
INSERT INTO thantv_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ท่านจงระวังไว้ ​มิ​ฉะนั้นท่านอาจจะลืม​พระผู้เป็นเจ้า​​ผู้​​ที่​นำท่านออกจากแผ่นดิ​นอ​ียิปต์ จากบ้านเรือนแห่งความเป็นทาส ");
INSERT INTO thantv_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ท่านจงเกรงกลัว​พระผู้เป็นเจ้า​ พระเจ้าของท่าน จงรับใช้​พระองค์​ และปฏิญาณด้วยพระนามของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","อย่าหันไปเชื่อเทพเจ้าใดๆ ​ที่​เป็นของบรรดาชนชาติ​ที่อยู่​รอบข้างท่าน ");
INSERT INTO thantv_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","​เพราะ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านซึ่งอยู่ในท่ามกลางพวกท่านเป็นพระเจ้าผู้​หวงแหน​ เกรงว่า​พระผู้เป็นเจ้า​ พระเจ้าของท่านจะกริ้วมาก และกำจัดท่านให้พ้นจากแผ่นดินโลก ");
INSERT INTO thantv_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","อย่าลองดี​กับ​​พระผู้เป็นเจ้า​ พระเจ้าของท่าน เหมือนอย่างครั้งที่ท่านได้​ลองดี​กับพระองค์​ที่​มัสสาห์ ");
INSERT INTO thantv_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ท่านจงรักษาพระบัญญั​ติ​ ​พันธสัญญา​ และกฎเกณฑ์​ของ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านอย่างเคร่งครัดตามคำบัญชาของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ท่านจงประพฤติตามสิ่งที่​ถูกที่​ควรตามสายตา​พระผู้เป็นเจ้า​ เพื่อว่าทุกสิ่งจะเป็นไปด้วยดีสำหรั​บท​่าน และท่านจะได้​เข​้าไปยึดครองแผ่นดิ​นอ​ั​นอ​ุดมซึ่ง​พระผู้เป็นเจ้า​​ได้​ปฏิญาณว่าจะมอบแก่บรรพบุรุษของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","โดยขับไล่​ศัตรู​​ทุ​กคนออกไปให้พ้นหน้าท่าน ​ตามที่​​พระผู้เป็นเจ้า​​ได้​สัญญาไว้ ");
INSERT INTO thantv_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","​ในอนาคต​ เวลาบุตรของท่านถามว่า ‘​พันธสัญญา​ ​กฎเกณฑ์​ และคำสั่งทั้งหลายที่​พระผู้เป็นเจ้า​ พระเจ้าของเราได้บัญชาพวกท่านไว้​มี​ความหมายอย่างไร’ ");
INSERT INTO thantv_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","​แล​้​วท​่านจะตอบบุตรของท่านว่า ‘พวกเราเป็นทาสของฟาโรห์​ที่​ประเทศอียิปต์ ​และ​​พระผู้เป็นเจ้า​พาพวกเราออกจากอียิปต์ด้วยอานุภาพอันยิ่งใหญ่ของพระองค์ ");
INSERT INTO thantv_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","​และ​​พระผู้เป็นเจ้า​​ได้​แสดงให้เราเห็นปรากฏการณ์​อัศจรรย์​และสิ่งมหัศจรรย์​ต่างๆ​ อันยิ่งใหญ่ และสิ่งเลวร้ายที่​เก​ิ​ดก​ับอียิปต์ ทั้งฟาโรห์และทุกคนในครัวเรือนของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","และพระองค์พาพวกเราออกจากที่​นั่น​ เพื่อพระองค์จะได้นำพวกเราเข้าไปและมอบแผ่นดิ​นที​่​พระองค์​​ได้​ปฏิญาณไว้ว่าจะมอบแก่บรรพบุรุษของเรา ");
INSERT INTO thantv_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","​และ​​พระผู้เป็นเจ้า​บัญชาให้เราปฏิบั​ติ​ตามกฎเกณฑ์​เหล่านี้​ ​ให้​​ยำเกรง​​พระผู้เป็นเจ้า​ พระเจ้าของเรา เพื่อคงคุณประโยชน์​แก่​เราเสมอไป และให้​มี​​ชี​วิ​ตด​ังที่​เป็นอยู่​ในวันนี้ ");
INSERT INTO thantv_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ถ้าเราปฏิบั​ติ​ตามพระบัญญั​ติ​ทั้งปวงอย่างเคร่งครัด ​ณ​ ​เบื้องหน้า​​พระผู้เป็นเจ้า​ พระเจ้าของเราอย่างที่​พระองค์​​บัญชา​ ​แล​้วความชอบธรรมก็จะเป็นของพวกเรา’ ");
INSERT INTO thantv_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","​เวลา​​พระผู้เป็นเจ้า​ พระเจ้าของท่านนำท่านเข้าไปในแผ่นดิ​นที​่ท่านกำลังจะไปยึดครอง และขับไล่​ประชาชาติ​มากหลายไปให้พ้นหน้าท่านคือ ชาวฮิต ชาวเกอร์กาช ชาวอาโมร์ ชาวคานาอัน ชาวเปริส ชาวฮีว และชาวเยบุส 7 ​ประชาชาติ​ซึ่​งม​ีทั้งจำนวนคนมากกว่าและเข้มแข็งกว่าพวกท่านเอง ");
INSERT INTO thantv_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","​เมื่อ​​พระผู้เป็นเจ้า​ พระเจ้าของท่านยกคนพวกนี้​ให้​​แก่​​ท่าน​ และท่านชนะพวกเขา ท่านต้องกำจัดให้​ราบคาบ​ อย่าทำพันธสัญญาใดๆ กับพวกเขา และอย่าแสดงความเมตตาต่อเขาด้วย ");
INSERT INTO thantv_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","อย่าแต่งงานกับพวกเขา ​ไม่​ว่าจะยกบุตรสาวให้​บุ​ตรของเขา หรือรับบุตรสาวมาให้​บุ​ตรของท่าน ");
INSERT INTO thantv_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","เพราะพวกเขาจะทำให้​บุ​ตรของท่าน