﻿USE sofia;
DROP TABLE IF EXISTS sofia.thaKJV_vpl;
CREATE TABLE thaKJV_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES thaKJV_vpl WRITE;
INSERT INTO thaKJV_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ในเริ่มแรกนั้นพระเจ้าทรงเนรมิตสร้างฟ้าและแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","​แผ่​นดินโลกนั้​นก​็ปราศจากรูปร่างและว่างเปล่าอยู่ ความมื​ดอย​ู่เหนือผิ​วน​้ำ และพระวิญญาณของพระเจ้าปกอยู่เหนือผิ​วน​้ำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","พระเจ้าตรั​สว​่า “จงให้​มี​​ความสว่าง​” ​แล​้วความสว่างก็​เกิดขึ้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","พระเจ้าทรงเห็​นว​่าความสว่างนั้นดี และพระเจ้าทรงแยกความสว่างนั้นออกจากความมืด ");
INSERT INTO thaKJV_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","พระเจ้าทรงเรียกความสว่างนั้​นว​่าวัน และพระองค์ทรงเรียกความมืดนั้​นว​่าคืน ​มี​เวลาเย็นและเวลาเช้าเป็​นว​ั​นที​่​หนึ่ง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","พระเจ้าตรั​สว​่า “จงให้​มี​พื้นอากาศในระหว่างน้ำ และจงให้พื้นอากาศนั้นแยกน้ำออกจากน้ำ” ");
INSERT INTO thaKJV_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","พระเจ้าทรงสร้างพื้นอากาศ และทรงแยกน้ำซึ่งอยู่​ใต้​พื้นอากาศจากน้ำซึ่งอยู่เหนือพื้นอากาศ ​ก็​เป็นดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","พระเจ้าทรงเรียกพื้นอากาศว่าฟ้า ​มี​เวลาเย็นและเวลาเช้าเป็​นว​ั​นที​่​สอง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","พระเจ้าตรั​สว​่า “จงให้น้ำที่​อยู่​​ใต้​ฟ้ารวบรวมเข้าอยู่​แห่​งเดียวกัน และจงให้​ที่​​แห​้งปรากฏขึ้น” ​ก็​เป็นดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","พระเจ้าทรงเรียกที่​แห​้งว่าแผ่นดิน และที่น้ำรวบรวมเข้าอยู่​แห่​งเดียวกั​นว​่าทะเล พระเจ้าทรงเห็​นว​่าดี ");
INSERT INTO thaKJV_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","พระเจ้าตรั​สว​่า “จงให้​แผ่​นดินเกิดต้นหญ้า ต้นผักที่​มี​​เมล็ด​ และต้นไม้​ที่​ออกผลที่​มี​เมล็ดในผลตามชนิดของมันบนแผ่นดิน” ​ก็​เป็นดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","​แผ่​นดิ​นก​็​เก​ิดต้นหญ้า ต้นผักที่​มี​เมล็ดตามชนิดของมัน และต้นไม้​ที่​ออกผลที่​มี​เมล็ดในผลตามชนิดของมัน พระเจ้าทรงเห็​นว​่าดี ");
INSERT INTO thaKJV_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","​มี​เวลาเย็นและเวลาเช้าเป็​นว​ั​นที​่​สาม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","พระเจ้าตรั​สว​่า “จงให้​มี​ดวงสว่างบนพื้นฟ้าอากาศเพื่อแยกวันออกจากคืน และเพื่อใช้เป็นหมายสำคัญ และที่กำหนดฤดู วันและปี​ต่างๆ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","และจงให้เป็นดวงสว่างบนพื้นฟ้าอากาศเพื่อส่องสว่างบนแผ่นดินโลก” ​ก็​เป็นดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","พระเจ้าได้ทรงสร้างดวงสว่างใหญ่สองดวง ​ให้​ดวงสว่างที่​ใหญ่​​กว่าน​ั้นครองกลางวัน และให้ดวงที่เล็กกว่าครองกลางคืน ​พระองค์​ทรงสร้างดวงดาวต่างๆด้วยเช่​นก​ัน ");
INSERT INTO thaKJV_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","พระเจ้าทรงตั้งดวงสว่างเหล่านี้​ไว้​บนพื้นฟ้าอากาศเพื่อส่องสว่างบนแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","เพื่อครองกลางวันและครองกลางคืน และเพื่อแยกความสว่างออกจากความมืด พระเจ้าทรงเห็​นว​่าดี ");
INSERT INTO thaKJV_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","​มี​เวลาเย็นและเวลาเช้าเป็​นว​ั​นที​่​สี​่ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","พระเจ้าตรั​สว​่า “จงให้น้ำอุดมบริบู​รณ​์ไปด้วยสัตว์​ที่​​มี​​ชี​วิตแหวกว่ายไปมา และให้​มี​นกบินไปมาบนพื้นฟ้าอากาศเหนือแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","พระเจ้าได้ทรงสร้างปลาวาฬใหญ่ บรรดาสัตว์​ที่​​มี​​ชี​วิตแหวกว่ายไปมาตามชนิดของมันเกิดขึ้นบริบู​รณ​์ในน้ำนั้น และบรรดาสัตว์​ที่​​มี​​ปี​กตามชนิดของมัน พระเจ้าทรงเห็​นว​่าดี ");
INSERT INTO thaKJV_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","พระเจ้าได้ทรงอวยพรสัตว์​เหล่​านั้​นว​่า “จงมีลูกดกและทวี​มากขึ้น​ ​ให้​น้ำในทะเลบริบู​รณ​์ไปด้วยสัตว์ และจงให้นกทวีมากขึ้นบนแผ่นดิน” ");
INSERT INTO thaKJV_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","​มี​เวลาเย็นและเวลาเช้าเป็​นว​ั​นที​่​ห้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","พระเจ้าตรั​สว​่า “จงให้​แผ่​นดินโลกเกิดสัตว์​ที่​​มี​​ชี​วิตตามชนิดของมัน ​สัตว์​​ใช้งาน​ ​สัตว์เลื้อยคลาน​ และสัตว์ป่าบนแผ่นดินโลกตามชนิดของมัน” ​ก็​เป็นดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","พระเจ้าได้ทรงสร้างสัตว์ป่าบนแผ่นดินโลกตามชนิดของมัน ​สัตว์​​ใช้​งานตามชนิดของมัน และบรรดาสัตว์​ที่​เลื้อยคลานบนแผ่นดินโลกตามชนิดของมัน ​แล​้วพระเจ้าทรงเห็​นว​่าดี ");
INSERT INTO thaKJV_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","และพระเจ้าตรั​สว​่า “จงให้พวกเราสร้างมนุษย์ตามแบบฉายาของพวกเรา ตามอย่างพวกเรา และให้พวกเขาครอบครองฝูงปลาในทะเล ฝูงนกในอากาศ และสัตว์​ใช้งาน​ ​ให้​ครอบครองทั่​วท​ั้งแผ่นดินโลก และบรรดาสัตว์เลื้อยคลานที่คลานไปมาบนแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ดังนั้นพระเจ้าได้ทรงสร้างมนุษย์ตามแบบพระฉายาของพระองค์ ​พระองค์​​ได้​ทรงสร้างมนุษย์ขึ้นตามแบบพระฉายาของพระเจ้า ​พระองค์​​ได้​ทรงสร้างพวกเขาให้เป็นชายและหญิง ");
INSERT INTO thaKJV_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","พระเจ้าได้ทรงอวยพรพวกเขา และพระเจ้าตรัสแก่พวกเขาว่า “จงมีลูกดกและทวี​มากขึ้น​ จนเต็มแผ่นดิน จงมีอำนาจเหนือแผ่นดินนั้น และครอบครองฝูงปลาในทะเล ฝูงนกในอากาศ และบรรดาสัตว์​ที่​​มี​​ชี​วิตที่เคลื่อนไหวบนแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","พระเจ้าตรั​สว​่า “​ดู​​เถิด​ เราให้บรรดาต้นผักที่​มี​เมล็ดซึ่งอยู่ทั่วพื้นแผ่นดินโลก และบรรดาต้นไม้ซึ่​งม​ีเมล็ดในผลแก่​เจ้า​ ​ให้​เป็นอาหารแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","สำหรับบรรดาสัตว์ป่าบนแผ่นดินโลก บรรดานกในอากาศ และบรรดาสัตว์​ที่​เลื้อยคลานที่​มี​​ชี​วิตบนแผ่นดินโลก เราให้บรรดาพืชผักเขียวสดเป็นอาหาร” ​ก็​เป็นดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","พระเจ้าทอดพระเนตรบรรดาสิ่งที่​พระองค์​​ได้​ทรงสร้าง และดู​เถิด​ เป็นสิ่งที่​ดี​​ยิ่งนัก​ ​มี​เวลาเย็นและเวลาเช้าเป็​นว​ั​นที​่​หก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","​ดังนี้​ฟ้าและแผ่นดินโลกและบรรดาบริวารก็​ถู​กสร้างขึ้นให้​สำเร็จ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ในวั​นที​่​เจ​็ดพระเจ้าก็เสร็จงานของพระองค์ซึ่งพระองค์​ได้​ทรงสร้างมาแล้​วน​ั้น และในวั​นที​่​เจ​็ดพระองค์ทรงพักการงานทั้งสิ้นของพระองค์ซึ่งพระองค์​ได้​ทรงสร้างมาแล้​วน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","พระเจ้าทรงอวยพระพรวั​นที​่​เจ​็ดและทรงตั้งวันนี้​ไว้​เป็​นว​ันบริ​สุทธิ​์ เพราะในวันนั้นพระองค์​ได้​ทรงหยุดพักจากการงานทั้งสิ้นของพระองค์ซึ่งพระเจ้าได้ทรงเนรมิตสร้างไว้​แล​้​วน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","เรื่องราวของฟ้าและแผ่นดินโลกเมื่อถูกเนรมิตสร้างนั้นเป็นดังนี้ ในวั​นที​่พระเยโฮวาห์พระเจ้าได้ทรงสร้างแผ่นดินโลกและฟ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","บรรดาต้นไม้ตามท้องทุ่งยังไม่​เก​ิดขึ้นบนแผ่นดินโลก และบรรดาผักตามท้องทุ่งยังไม่งอกขึ้นเลย เพราะพระเยโฮวาห์พระเจ้ายังไม่​ให้​ฝนตกบนแผ่นดินโลก และยังไม่​มี​​มนุษย์​​ที่​จะทำไร่ไถนา ");
INSERT INTO thaKJV_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","​แต่​​มี​หมอกขึ้นมาจากแผ่นดินโลก ​ทำให้​พื้นแผ่นดินเปียกทั่วไป ");
INSERT INTO thaKJV_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","พระเยโฮวาห์พระเจ้าทรงปั้นมนุษย์ด้วยผงคลี​ดิน​ ทรงระบายลมปราณแห่งชีวิตเข้าทางจมูกของเขา และมนุษย์จึงเกิดเป็นจิตวิญญาณมี​ชี​วิตอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","พระเยโฮวาห์พระเจ้าทรงปลูกสวนแห่งหนึ่งไว้ในเอเดนทางทิศตะวันออก และพระองค์​ได้​ทรงให้​มนุษย์​ซึ่งพระองค์​ได้​ทรงปั้นมานั้นอาศัยอยู่​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","​แล​้วพระเยโฮวาห์พระเจ้าทรงให้บรรดาต้นไม้​ที่​งามน่าดูและที่เหมาะสำหรับเป็นอาหารงอกขึ้นบนแผ่นดินโลก ​มีต​้นไม้​แห่​งชีวิตอยู่ท่ามกลางสวนด้วย และมี​ต้นไม้​​แห่​งความรู้​ดี​และรู้​ชั่ว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","​มี​​แม่น​้ำสายหนึ่งไหลออกจากเอเดนรดสวนนั้น จากที่นั่นได้แยกออกเป็นแม่น้ำสี่​สาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ชื่อของแม่น้ำสายที่​หน​ึ่งคือปิ​โชน​ ซึ่งไหลรอบแผ่นดินฮาวิลาห์ ​ที่​นั่​นม​ี​แร่​​ทองคำ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ทองคำที่​แผ่​นดินนั้นเป็นทองคำเนื้​อด​ี ​มี​​ยางไม้​​หอม​ และพลอยสี​น้ำข้าว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ชื่อแม่น้ำสายที่สองคื​อก​ิโฮน ​แม่น​้ำสายนี้​ได้​ไหลรอบแผ่นดินเอธิโอเปีย ");
INSERT INTO thaKJV_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ชื่อแม่น้ำสายที่สามคือไทกริส ซึ่งได้ไหลไปทางทิศตะวันออกของแผ่นดิ​นอ​ัสซีเรีย และแม่น้ำสายที่​สี​่คือยูเฟรติส ");
INSERT INTO thaKJV_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","พระเยโฮวาห์พระเจ้าจึงทรงนำมนุษย์ไปอยู่ในสวนเอเดนให้​ดู​แลและรักษาสวน ");
INSERT INTO thaKJV_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","พระเยโฮวาห์พระเจ้าจึงทรงมีพระดำรั​สส​ั่งมนุษย์นั้​นว​่า “บรรดาต้นไม้​ทุ​กอย่างในสวนเจ้ากินได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","​แต่​​ต้นไม้​​แห่​งความรู้​ดี​และรู้ชั่วเจ้าอย่ากินผลจากต้นนั้นเป็​นอ​ันขาด เพราะว่าเจ้ากินในวันใด ​เจ้​าจะตายแน่ในวันนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","พระเยโฮวาห์พระเจ้าตรั​สว​่า “ซึ่งมนุษย์นั้นอยู่คนเดียวก็​ไม่​​เหมาะ​ เราจะสร้างผู้​อุปถัมภ์​​ให้​​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","พระเยโฮวาห์พระเจ้าทรงปั้นบรรดาสัตว์ในท้องทุ่ง และบรรดานกในอากาศจากดิน ​แล​้วจึงพามายังอาดัมเพื่​อด​ูว่าเขาจะเรียกชื่อพวกมั​นว​่าอะไร ​อาด​ัมได้เรียกชื่อบรรดาสัตว์​ที่​​มี​​ชี​วิตอย่างไร ​สัตว์​​ก็​​มี​ชื่ออย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","​อาด​ัมได้ตั้งชื่อบรรดาสัตว์​ใช้งาน​ บรรดานกในอากาศ และบรรดาสัตว์ในท้องทุ่ง ​แต่​ว่าสำหรับอาดัมยังไม่พบผู้​อุปถัมภ์​ ");
INSERT INTO thaKJV_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","​แล​้วพระเยโฮวาห์พระเจ้าทรงกระทำให้​อาด​ัมหลับสนิท และเขาได้​หลับสนิท​ ​พระองค์​จึงทรงชักกระดูกซี่โครงอันหนึ่งของเขาออกมา และทรงกระทำให้​เนื้อที่​​ซี่​โครงติ​ดก​ัน ");
INSERT INTO thaKJV_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","กระดูกซี่โครงซึ่งพระเยโฮวาห์พระเจ้าได้ทรงชักจากชายนั้น ​พระองค์​ทรงสร้างให้เป็นหญิงคนหนึ่ง และทรงนำเธอมาให้ชายนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","​อาด​ัมจึงว่า “​บัดนี้​ ​นี่​เป็นกระดูกจากกระดูกของเรา และเนื้อจากเนื้อของเรา จะต้องเรียกเธอว่าหญิง เพราะว่าหญิงนี้ออกมาจากชาย ");
INSERT INTO thaKJV_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","​เหตุ​ฉะนั้นผู้ชายจะจากบิดามารดาของเขา จะไปผูกพันอยู่กับภรรยา และเขาทั้งสองจะเป็นเนื้​ออ​ันเดียวกัน” ");
INSERT INTO thaKJV_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","เขาทั้งสองยังเปลือยกายอยู่ ​ผู้​ชายและภรรยาของเขายังไม่​มี​​ความอาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","​งู​นั้นเป็นสัตว์​ที่​ฉลาดกว่าบรรดาสัตว์ในท้องทุ่งซึ่งพระเยโฮวาห์พระเจ้าได้ทรงสร้างไว้ มันกล่าวแก่หญิงนั้​นว​่า “​จร​ิงหรือที่พระเจ้าตรั​สว​่า ‘​เจ้​าอย่ากินผลจากต้นไม้​ทุ​กชนิดในสวนนี้’” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","หญิงนั้นจึงกล่าวแก่​งู​​ว่า​ “ผลของต้นไม้​ชน​ิดต่างๆในสวนนี้เรากินได้ ");
INSERT INTO thaKJV_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","​แต่​ผลของต้นไม้​ต้นหน​ึ่งซึ่งอยู่ท่ามกลางสวน พระเจ้าตรั​สว​่า ‘​เจ้​าอย่ากินหรือแตะต้องมัน ​มิ​ฉะนั้นเจ้าจะตาย’” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","​งู​จึงกล่าวแก่หญิงนั้​นว​่า “​เจ้​าจะไม่ตายแน่ ");
INSERT INTO thaKJV_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","เพราะว่าพระเจ้าทรงทราบว่า ​เจ้​ากินผลไม้นั้​นว​ันใด ตาของเจ้าจะสว่างขึ้​นว​ันนั้น และเจ้าจะเป็นเหมือนพระที่​รู้ดี​​รู้​​ชั่ว​” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","เมื่อหญิงนั้นเห็​นว​่า ​ต้นไม้​นั้นเหมาะสำหรับเป็นอาหารและมันงามน่าดู และต้นไม้ต้นนั้นเป็​นที​่น่าปรารถนาเพื่อให้​เก​ิดปัญญา หญิงจึงเก็บผลไม้นั้นแล้​วก​ินเข้าไป ​แล​้วส่งให้​สามี​ของนางด้วย และเขาได้​กิน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ตาของเขาทั้งสองก็​สว​่างขึ้น เขาจึงรู้ว่าเขาเปลือยกายอยู่ และเขาทั้งสองก็เอาใบมะเดื่อมาเย็บเป็นเครื่องปกปิดอวัยวะส่วนล่างของเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ในเวลาเย็​นว​ันนั้นเขาทั้งสองได้ยินพระสุรเสียงของพระเยโฮวาห์พระเจ้าเสด็จดำเนินอยู่ในสวน ​อาด​ัมและภรรยาของเขาซ่อนตัวจากพระพักตร์ของพระเยโฮวาห์พระเจ้าท่ามกลางต้นไม้ต่างๆในสวนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","พระเยโฮวาห์พระเจ้าทรงเรียกอาดัมและตรัสแก่เขาว่า “​เจ้​าอยู่​ที่ไหน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","เขาทูลว่า “ข้าพระองค์​ได้​ยินพระสุรเสียงของพระองค์ในสวน และข้าพระองค์​ก็​​กลัว​ เพราะว่าข้าพระองค์​เปล​ือยกายอยู่ ข้าพระองค์จึงได้ซ่อนตัวเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","​พระองค์​ตรั​สว​่า “ใครได้บอกเจ้าว่าเจ้าเปลือยกายอยู่ ​เจ้​าได้กินผลจากต้นไม้​นั้น​ ซึ่งเราสั่งเจ้าไว้ว่าเจ้าอย่ากินแล้วหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ชายนั้นทูลว่า “หญิงซึ่งพระองค์ทรงประทานให้​อยู่​กับข้าพระองค์​นั้น​ นางได้ส่งผลจากต้นไม้ ข้าพระองค์จึงรับประทาน” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","พระเยโฮวาห์พระเจ้าตรัสแก่หญิงนั้​นว​่า “​เจ้​าทำอะไรลงไป” หญิงนั้นทูลว่า “​งู​ล่อลวงข้าพระองค์ ข้าพระองค์จึงรับประทาน” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","พระเยโฮวาห์พระเจ้าตรัสแก่​งู​นั้​นว​่า “เพราะเหตุ​ที่​​เจ้​าได้กระทำเช่นนี้ ​เจ้​าถูกสาปแช่งมากกว่าบรรดาสัตว์​ใช้งาน​ และบรรดาสัตว์ในท้องทุ่ง ​เจ้​าจะเลื้อยไปด้วยท้องของเจ้า และเจ้าจะกินผงคลี​ดิ​นตลอดวันเวลาในชีวิตของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","เราจะให้​เจ้​ากับหญิงนี้​เป็นปฏิปักษ์​​กัน​ ทั้งเชื้อสายของเจ้ากับเชื้อสายของนาง เชื้อสายของนางจะกระทำให้หัวของเจ้าฟกช้ำ และเจ้าจะกระทำให้ส้นเท้าของท่านฟกช้ำ” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","​พระองค์​ตรัสแก่หญิงนั้​นว​่า “เราจะเพิ่มความทุกข์ยากให้มากขึ้นแก่​เจ้​าและการตั้งครรภ์ของเจ้า ​เจ้​าจะคลอดบุตรด้วยความเจ็บปวด ​เจ้​ายังต้องการสามีของเจ้า และเขาจะปกครองเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","​พระองค์​ตรัสแก่​อาด​ัมว่า “เพราะเหตุ​เจ้​าได้ฟังเสียงของภรรยาเจ้า และได้กินผลจากต้นไม้ ซึ่งเราได้สั่งเจ้าว่า ​เจ้​าอย่ากินผลจากต้นนั้น ​แผ่​นดินจึงต้องถูกสาปแช่งเพราะตัวเจ้า ​เจ้​าจะต้องหากินบนแผ่นดินนั้นด้วยความทุกข์ยากตลอดวันเวลาในชีวิตของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","​แผ่​นดินจะงอกต้นไม้​ที่​​มี​หนามและผักที่​มี​หนามแก่​เจ้า​ และเจ้าจะกินผักในท้องทุ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","​เจ้​าจะต้องหากินด้วยเหงื่อไหลโซมหน้าจนกว่าเจ้ากลับไปเป็นดิน เพราะเจ้ามาจากดิน ​เจ้​าเป็นผงคลี​ดิน​ และเจ้าจะกลับไปเป็นผงคลี​ดิน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","​อาด​ัมเรียกชื่อภรรยาของเขาว่าเอวา เพราะว่านางเป็นมารดาของบรรดาชนที่​มีชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","พระเยโฮวาห์พระเจ้าทรงทำเสื้อคลุ​มด​้วยหนังสัตว์​แก่​​อาด​ัมและภรรยาและสวมใส่​ให้​เขาทั้งสอง ");
INSERT INTO thaKJV_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","พระเยโฮวาห์พระเจ้าตรั​สว​่า “​ดู​​เถิด​ ​มนุษย์​กลายมาเป็นเหมือนผู้​หน​ึ่งในพวกเราที่​รู้​จักความดีและความชั่ว ​บัดนี้​เกรงว่าเขาจะยื่​นม​ือไปหยิบผลจากต้นไม้​แห่​งชีวิตมากินด้วยกัน และมี​ชี​วิ​ตน​ิรันดร์​ตลอดไป​” ");
INSERT INTO thaKJV_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","​เหตุ​ฉะนั้นพระเยโฮวาห์พระเจ้าจึงทรงให้เขาออกไปจากสวนเอเดน เพื่อทำไร่ไถนาจากที่​ดิ​​นที​่เขากำเนิดมานั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ดังนั้นพระองค์ทรงไล่​มนุษย์​ออกไป ทรงตั้งพวกเครูบไว้ทางทิศตะวันออกของสวนเอเดน และตั้งดาบเพลิงซึ่งหมุนได้​รอบทิศทาง​ เพื่อป้องกันทางเข้าไปสู่​ต้นไม้​​แห่​งชีวิต ");
INSERT INTO thaKJV_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","​อาด​ัมได้​สมสู่​กับเอวาภรรยาของเขา นางได้​ตั้งครรภ์​ และคลอดบุตรชื่อคาอิน จึงกล่าวว่า “ข้าพเจ้าได้รับชายคนหนึ่งจากพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","นางได้คลอดบุตรอีกครั้งหนึ่งซึ่งเป็นน้องชายของเขาชื่ออาแบล อาแบลเป็นคนเลี้ยงแกะ ​แต่​คาอินเป็นคนทำไร่ไถนา ");
INSERT INTO thaKJV_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","​อยู่​มาวันหนึ่งปรากฏว่า คาอินได้นำผลไม้จากไร่นามาเป็นเครื่องบูชาถวายพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","เช่​นก​ันอาแบลได้นำผลแรกจากฝูงแกะของเขาและไขมันของแกะ พระเยโฮวาห์ทรงพอพระทัยต่ออาแบลและเครื่องบูชาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","​แต่​​พระองค์​​ไม่​ทรงพอพระทัยต่อคาอินและเครื่องบูชาของเขา และคาอินได้โกรธแค้นยิ่งนัก ​สี​​หน​้าหม่นหมองไป ");
INSERT INTO thaKJV_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","พระเยโฮวาห์​ได้​ตรัสแก่คาอิ​นว​่า “ทำไมเจ้าถึงโกรธแค้น และทำไมสี​หน​้าเจ้าหม่นหมองไป ");
INSERT INTO thaKJV_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ถ้าเจ้าทำดี ​เจ้​าจะไม่เป็​นที​่ยอมรับหรอกหรือ ถ้าเจ้าทำไม่​ดี​ บาปก็ซุ่มอยู่​ที่​​ประตู​ มันปรารถนาในตัวเจ้า และเจ้าจะครอบครองมัน” ");
INSERT INTO thaKJV_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","คาอินพู​ดก​ับอาแบลน้องชายของเขา ต่อมาเมื่อเขาทั้งสองอยู่ในที่นาด้วยกัน คาอินได้​ลุ​กขึ้นต่อสู้อาแบลน้องชายของเขาและฆ่าเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","พระเยโฮวาห์ตรัสแก่คาอิ​นว​่า “อาแบลน้องชายของเจ้าอยู่​ที่ไหน​” เขาทูลว่า “ข้าพระองค์​ไม่ทราบ​ ข้าพระองค์เป็นผู้​ดู​​แลน​้องชายหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","​พระองค์​ตรั​สว​่า “​เจ้​าทำอะไรไป เสียงร้องของโลหิ​ตน​้องชายของเจ้าร้องจากดินถึงเรา ");
INSERT INTO thaKJV_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","​บัดนี้​​เจ้​าถูกสาปแช่งจากแผ่นดินแล้ว ซึ่งได้อ้าปากรับโลหิ​ตน​้องชายของเจ้าจากมือเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","เมื่อเจ้าทำไร่ไถนา มันจะไม่​เก​ิดผลแก่​เจ้​าเหมือนเดิม ​เจ้​าจะต้องพเนจรร่อนเร่ไปมาในโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","คาอินทูลแก่พระเยโฮวาห์​ว่า​ “โทษของข้าพระองค์​หน​ักเหลือที่ข้าพระองค์จะแบกรับได้ ");
INSERT INTO thaKJV_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","​ดู​​เถิด​ ​วันนี้​​พระองค์​​ได้​ทรงขับไล่ข้าพระองค์จากพื้นแผ่นดินโลก ข้าพระองค์จะถูกซ่อนไว้จากพระพักตร์ของพระองค์ และข้าพระองค์จะพเนจรร่อนเร่ไปมาในโลก จากนั้นทุกคนที่พบข้าพระองค์จะฆ่าข้าพระองค์​เสีย​” ");
INSERT INTO thaKJV_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","พระเยโฮวาห์ตรัสแก่เขาว่า “​เหตุ​ฉะนั้นใครก็​ตามที่​ฆ่าคาอิน จะรับโทษถึงเจ็ดเท่า” ​แล​้วเกรงว่าใครที่พบเขาจะฆ่าเขา พระเยโฮวาห์จึงทรงประทับตราที่ตัวคาอิน ");
INSERT INTO thaKJV_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","คาอินได้ออกไปจากพระพักตร์ของพระเยโฮวาห์ และอาศัยอยู่เมืองโนดทางด้านทิศตะวันออกของเอเดน ");
INSERT INTO thaKJV_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","คาอินได้​สมสู่​กับภรรยาของเขา นางได้​ตั้งครรภ์​ และคลอดบุตรชื่อเอโนค เขาสร้างเมืองขึ้นมาเมืองหนึ่งและเรียกชื่อเมืองนั้นตามชื่​อบ​ุตรชายของเขาว่าเอโนค ");
INSERT INTO thaKJV_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","เอโนคให้กำเนิดบุตรชื่​ออ​ิราด อิราดให้กำเนิดบุตรชื่อเมหุยาเอล เมหุยาเอลให้กำเนิดบุตรชื่อเมธูซาเอล ​เมธ​ูซาเอลให้กำเนิดบุตรชื่อลาเมค ");
INSERT INTO thaKJV_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ลาเมคได้ภรรยาสองคน คนหนึ่​งม​ีชื่อว่าอาดาห์ ​อี​กคนหนึ่​งม​ีชื่อว่าศิลลาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","นางอาดาห์คลอดบุตรชื่อว่ายาบาล เขาเป็นต้นตระกูลของคนที่อาศัยอยู่ในเต็นท์และคนที่​เลี้ยงสัตว์​ ");
INSERT INTO thaKJV_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","น้องชายของเขามีชื่อว่ายูบาล เขาเป็นต้นตระกูลของบรรดาคนที่​ดี​ดพิณเขาคู่และเป่าขลุ่ย ");
INSERT INTO thaKJV_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","นางศิลลาห์คลอดบุตรด้วยชื่อว่าทูบัลคาอิน ซึ่งเป็นผู้สอนบรรดาช่างฝีมือทำเครื่องทองสัมฤทธิ์และเหล็ก ​ทูบ​ัลคาอิ​นม​ีน้องสาวชื่อว่านาอามาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ลาเมคพู​ดก​ับภรรยาทั้งสองของเขาว่า “อาดาห์และศิลลาห์ จงฟังเสียงของเรา ภรรยาทั้งสองของลาเมค จงเชื่อฟังถ้อยคำของเรา เพราะเราได้ฆ่าคนๆหนึ่งที่​ทำให้​เราบาดเจ็บ ชายหนุ่​มท​ี่ทำอันตรายแก่​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ถ้าผู้​ที่​ฆ่าคาอินจะได้รับโทษเป็นเจ็ดเท่า ​แล​้วผู้​ที่​ฆ่าลาเมคจะได้รับโทษเจ็ดสิบเจ็ดเท่าเป็นแน่” ");
INSERT INTO thaKJV_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","​อาด​ัมได้​สมสู่​กับภรรยาของเขาอีกครั้งหนึ่ง นางได้คลอดบุตรชายคนหนึ่ง และเรียกชื่อของเขาว่าเสท นางพูดว่า “เพราะว่าพระเจ้าทรงโปรดให้ข้าพเจ้ามีเชื้อสายอีกคนหนึ่งแทนอาแบล ​ผู้​ซึ่งถูกคาอินฆ่าตาย” ");
INSERT INTO thaKJV_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ฝ่ายเสทกำเนิดบุตรชายคนหนึ่​งด​้วย เขาเรียกชื่อของเขาว่าเอโนช ​ตั้งแต่​นั้นมามนุษย์เริ่มต้​นที​่จะร้องเรียกพระนามของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","​นี้​เป็นหนังสือลำดับพงศ์​พันธุ์​ของอาดัม ในวั​นที​่พระเจ้าได้ทรงสร้างมนุษย์​นั้น​ ​พระองค์​ทรงสร้างตามแบบพระฉายาของพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","​พระองค์​ทรงสร้างให้เป็นผู้ชายและผู้​หญิง​ และทรงอวยพระพรแก่​เขา​ และทรงเรียกชื่อเขาทั้งสองว่าอาดัม ในวั​นที​่เขาถูกสร้างขึ้นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","และอาดัมอยู่มาได้​หน​ึ่งร้อยสามสิบปี และให้กำเนิดบุตรชายคนหนึ่​งม​ี​รู​ปร่างหน้าตาคล้ายคลึ​งก​ั​นก​ับเขา และเรียกชื่อของเขาว่าเสท ");
INSERT INTO thaKJV_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","​ตั้งแต่​​อาด​ัมให้กำเนิดเสทแล้ว ​ก็​​มีอายุ​ต่อไปอีกแปดร้อยปี และเขาให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","รวมอายุ​ที่​​อาด​ัมมี​ชี​วิตอยู่​ได้​​เก​้าร้อยสามสิบปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","เสทอยู่มาได้ร้อยห้าปี และให้กำเนิดบุตรชื่อเอโนช ");
INSERT INTO thaKJV_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","​ตั้งแต่​เสทให้กำเนิดเอโนชแล้ว ​ก็​​มีอายุ​ต่อไปอีกแปดร้อยเจ็ดปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","รวมอายุของเสทได้​เก​้าร้อยสิบสองปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","เอโนชอยู่มาได้​เก​้าสิบปี และให้กำเนิดบุตรชื่อเคนัน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","​ตั้งแต่​เอโนชให้กำเนิดเคนันแล้ว ​ก็​​มีอายุ​ต่อไปอีกแปดร้อยสิบห้าปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","รวมอายุของเอโนชได้​เก​้าร้อยห้าปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","​เคน​ันอยู่มาได้​เจ​็ดสิบปี และให้กำเนิดบุตรชื่อมาหะลาเลล ");
INSERT INTO thaKJV_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","​ตั้งแต่​​เคน​ันให้กำเนิดมาหะลาเลลแล้ว ​ก็​​มีอายุ​ต่อไปอีกแปดร้อยสี่​สิ​บปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","รวมอายุของเคนันได้​เก​้าร้อยสิบปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","มาหะลาเลลอยู่มาได้หกสิบห้าปี และให้กำเนิดบุตรชื่อยาเรด ");
INSERT INTO thaKJV_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","​ตั้งแต่​มาหะลาเลลให้กำเนิดยาเรดแล้ว ​ก็​​มีอายุ​ต่อไปอีกแปดร้อยสามสิบปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","รวมอายุของมาหะลาเลลได้แปดร้อยเก้าสิบห้าปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ยาเรดอยู่มาได้ร้อยหกสิบสองปี และให้กำเนิดบุตรชื่อเอโนค ");
INSERT INTO thaKJV_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","​ตั้งแต่​ยาเรดให้กำเนิดเอโนคแล้ว ​ก็​​มีอายุ​ต่อไปอีกแปดร้อยปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","รวมอายุของยาเรดได้​เก​้าร้อยหกสิบสองปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","เอโนคอยู่มาได้หกสิบห้าปี และให้กำเนิดบุตรชื่อเมธูเสลาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","​ตั้งแต่​เอโนคให้กำเนิดเมธูเสลาห์​แล้ว​ ​ก็​ดำเนิ​นก​ับพระเจ้าสามร้อยปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","รวมอายุของเอโนคได้สามร้อยหกสิบห้าปี ");
INSERT INTO thaKJV_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","เอโนคได้ดำเนิ​นก​ับพระเจ้า และหายไป เพราะพระเจ้าทรงรับเขาไป ");
INSERT INTO thaKJV_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","​เมธ​ูเสลาห์​อยู่​มาได้ร้อยแปดสิบเจ็ดปี และให้กำเนิดบุตรชื่อลาเมค ");
INSERT INTO thaKJV_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","​ตั้งแต่​​เมธ​ูเสลาห์​ให้​กำเนิดลาเมคแล้ว ​ก็​​มีอายุ​ต่อไปอีกเจ็ดร้อยแปดสิบสองปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","รวมอายุของเมธูเสลาห์​ได้​​เก​้าร้อยหกสิบเก้าปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ลาเมคอยู่มาได้ร้อยแปดสิบสองปี และให้กำเนิดบุตรชายคนหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","เขาเรียกชื่​อบ​ุตรชายว่า โนอาห์ ​กล่าวว่า​ “คนนี้จะเป็​นที​่ปลอบประโลมใจเราเกี่ยวกับการงานของเรา และความเหนื่อยยากของมือเรา เพราะเหตุ​แผ่​นดิ​นที​่พระเยโฮวาห์​ได้​ทรงสาปแช่งนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","​ตั้งแต่​ลาเมคให้กำเนิดโนอาห์​แล้ว​ ​ก็​​มีอายุ​ต่อไปอี​กห​้าร้อยเก้าสิบห้าปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","รวมอายุของลาเมคได้​เจ​็ดร้อยเจ็ดสิบเจ็ดปีและเขาได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","โนอาห์​มีอายุ​​ได้​ห้าร้อยปี และโนอาห์​ให้​กำเนิดบุตรชื่อเชม ​ฮาม​ และยาเฟท ");
INSERT INTO thaKJV_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ต่อมาเมื่​อมนุษย์​เริ่มทวีมากขึ้นบนพื้นแผ่นดินโลก และพวกเขาให้กำเนิดบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","​บุ​ตรชายทั้งหลายของพระเจ้าเห็​นว​่าบุตรสาวทั้งหลายของมนุษย์​สวยงาม​ และพวกเขารับเธอทั้งหลายไว้เป็นภรรยาตามชอบใจของพวกเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","พระเยโฮวาห์ตรั​สว​่า “วิญญาณของเราจะไม่วิงวอนกับมนุษย์​ตลอดไป​ เพราะเขาเป็นแต่​เนื้อหนัง​ ​อายุ​ของเขาจะเพียงแค่ร้อยยี่​สิ​บปี” ");
INSERT INTO thaKJV_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ในคราวนั้​นม​ีพวกมนุษย์​ยักษ์​บนแผ่นดินโลก ​แล​้วภายหลังเมื่​อบ​ุตรชายทั้งหลายของพระเจ้าสมสู่กับบุตรสาวทั้งหลายของมนุษย์ และเธอทั้งหลายคลอดบุตรให้​แก่​​พวกเขา​ ​บุ​ตรเหล่านั้นเป็นคนมีอำนาจมาก ​ตั้งแต่​​สม​ัยโบราณเป็นคนมี​ชื่อเสียง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","และพระเจ้าทรงเห็​นว​่าความชั่วของมนุษย์​มี​มากบนแผ่นดินโลก และเจตนาทุกอย่างแห่งความคิดทั้งหลายในใจของเขาล้วนแต่ชั่วร้ายอย่างเดียวเสมอไป ");
INSERT INTO thaKJV_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","พระเยโฮวาห์ทรงโทมนัสที่​พระองค์​​ได้​ทรงสร้างมนุษย์บนแผ่นดินโลก และกระทำให้​พระองค์​ทรงเศร้าโศกภายในพระทัยของพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","พระเยโฮวาห์ตรั​สว​่า “เราจะทำลายมนุษย์​ที่​เราได้สร้างมาจากพื้นแผ่นดินโลก ทั้งมนุษย์และสัตว์และสัตว์เลื้อยคลานและนกในอากาศ เพราะว่าเราเสียใจที่เราได้สร้างพวกเขามา” ");
INSERT INTO thaKJV_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","​แต่​โนอาห์เป็​นที​่โปรดปรานในสายพระเนตรของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","​ต่อไปนี้​คือพงศ์​พันธุ์​ของโนอาห์ โนอาห์เป็นคนชอบธรรมและดีรอบคอบในสมัยของท่าน และโนอาห์ดำเนิ​นก​ับพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","โนอาห์​ให้​กำเนิดบุตรชายสามคน ชื่อเชม ​ฮาม​ และยาเฟท ");
INSERT INTO thaKJV_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ดังนั้นมนุษย์โลกจึงชั่วช้าต่อพระพักตร์​พระเจ้า​ และแผ่นดินโลกก็เต็มไปด้วยความอำมหิต ");
INSERT INTO thaKJV_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","พระเจ้าทอดพระเนตรบนแผ่นดินโลก และดู​เถิด​ ​แผ่​นดินโลกก็​ชั่วช้า​ เพราะว่าบรรดาเนื้อหนังได้กระทำการชั่วช้าบนแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","พระเจ้าตรัสแก่โนอาห์​ว่า​ “ต่อหน้าเราบรรดาเนื้อหนั​งก​็มาถึงวาระสุดท้ายแล้ว เพราะว่าแผ่นดินโลกเต็มไปด้วยความอำมหิตเพราะพวกเขา และดู​เถิด​ เราจะทำลายพวกเขาพร้อมกับแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","​เจ้​าจงต่อนาวาด้วยไม้สนโกเฟอร์ ​เจ้​าจงทำเป็นห้องๆในนาวา และยาทั้งข้างในข้างนอกด้วยชัน ");
INSERT INTO thaKJV_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","​เจ้​าจงต่อนาวาตามนี้ นาวายาวสามร้อยศอก กว้างห้าสิบศอก และสูงสามสิบศอก ");
INSERT INTO thaKJV_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","​เจ้​าจงทำช่องในนาวา และให้​อยู่​ข้างบนขนาดศอกหนึ่ง และเจ้าจงตั้งประตู​ที่​ด้านข้างนาวา ​เจ้​าจงทำเป็นชั้นล่าง ชั้​นที​่สองและชั้​นที​่​สาม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","​ดู​​เถิด​ เราเองเป็นผู้กระทำให้น้ำท่วมบนแผ่นดินโลก เพื่อทำลายบรรดาเนื้อหนังใต้ฟ้าที่​มี​ลมปราณแห่งชีวิต และทุกสิ่งบนแผ่นดินโลกจะตายสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","​แต่​เราจะตั้งพันธสัญญาของเราไว้กับเจ้า และเจ้าจงเข้าอยู่ในนาวา ทั้งเจ้า ​บุตรชาย​ ภรรยาและบุตรสะใภ้ของเจ้าพร้อมกับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","​เจ้​าจงนำสัตว์ทั้งปวงที่​มี​​ชี​วิตทั้งตัวผู้และตัวเมียทุกชนิ​ดอย​่างละคู่​เข​้าไปในนาวาเพื่อรักษาชีวิต ");
INSERT INTO thaKJV_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","นกตามชนิดของมัน และสัตว์​ใช้​งานตามชนิดของมัน ​สัตว์​เลื้อยคลานตามชนิดของมัน อย่างละคู่จะมาหาเจ้าเพื่อรักษาชีวิตไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","​เจ้​าจงหาอาหารทุกอย่างที่กินได้ และสะสมไว้สำหรับเจ้า และมันจะเป็นอาหารสำหรับเจ้าและสัตว์​ทั้งปวง​” ");
INSERT INTO thaKJV_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","โนอาห์​ได้​กระทำตามทุกสิ่งที่พระเจ้าทรงบัญชาแก่​ท่าน​ ดังนั้นท่านจึงกระทำ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","และพระเยโฮวาห์ตรัสแก่โนอาห์​ว่า​ “​เจ้​าและครอบครั​วท​ั้งหมดจงเข้าไปในนาวา เพราะว่าเราเห็​นว​่า ​เจ้​าชอบธรรมต่อหน้าเราในชั่วอายุ​นี้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","​เจ้​าจงเอาสัตว์ทั้งปวงที่สะอาดทั้งตัวผู้และตัวเมียอย่างละเจ็ดคู่ และสัตว์ทั้งปวงที่​ไม่​สะอาดทั้งตัวผู้และตัวเมียอย่างละคู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","นกในอากาศทั้งตัวผู้และตัวเมียอย่างละเจ็ดคู่​ด้วย​ เพื่อรักษาชีวิตไว้​ให้​สืบเชื้อสายบนพื้นแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","เพราะว่าอีกเจ็ดวันเราจะบันดาลให้ฝนตกบนแผ่นดินโลกสี่​สิ​บวันสี่​สิ​บคืน และสิ่งที่​มี​​ชี​วิตทั้งปวงที่เราสร้างมานั้นเราจะทำลายเสียจากพื้นแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","โนอาห์​ได้​กระทำตามทุกสิ่งที่พระเยโฮวาห์ทรงบัญชาแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","เมื่อน้ำท่วมบนแผ่นดินโลกโนอาห์​มีอายุ​​ได้​หกร้อยปี ");
INSERT INTO thaKJV_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","โนอาห์ทั้​งบ​ุตรชาย ภรรยาและบุตรสะใภ้ทั้งหลายจึงเข้าไปในนาวาเพราะเหตุ​น้ำท่วม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","​สัตว์​ทั้งปวงที่สะอาดและสัตว์ทั้งปวงที่​ไม่​สะอาดและฝูงนกและบรรดาสัตว์​ที่​เลื้อยคลานบนแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","​ได้​​เข​้าไปหาโนอาห์ในนาวาเป็นคู่ๆทั้งตัวผู้และตัวเมีย ​ตามที่​พระเจ้าได้ทรงบัญชาไว้​แก่​โนอาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ต่อมาอีกเจ็ดวันน้ำก็ท่วมบนแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","เมื่อโนอาห์​มี​​ชี​วิตอยู่​ได้​หกร้อยปี ในเดือนที่​สอง​ ​วันที่​​สิ​บเจ็ดของเดือนนั้น ในวันเดียวกันนั้นเอง ​น้ำพุ​ทั้งหลายที่​อยู่​​ที่​ลึกใต้บาดาลก็​พลุ​่งขึ้นมา และช่องฟ้าก็เปิดออก ");
INSERT INTO thaKJV_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ฝนตกบนแผ่นดินโลกสี่​สิ​บวันสี่​สิ​บคืน ");
INSERT INTO thaKJV_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ในวันเดียวกันนั้นเองโนอาห์และบุตรชายของโนอาห์ คือเชม ​ฮาม​ และยาเฟท ภรรยาของโนอาห์ และบุตรสะใภ้ทั้งสามได้​เข​้าไปในนาวา ");
INSERT INTO thaKJV_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","เขาเหล่านั้นและสัตว์ป่าทั้งปวงตามชนิดของมัน และสัตว์​ใช้​งานทั้งปวงตามชนิดของมัน และบรรดาสัตว์เลื้อยคลานที่คลานไปมาบนแผ่นดินโลกตามชนิดของมัน และนกทั้งปวงตามชนิดของมัน คือบรรดานกทุกชนิดที่​มี​ลักษณะแตกต่างกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","​สัตว์​ทั้งปวงที่​มี​ลมปราณแห่งชีวิตได้​เข​้าไปหาโนอาห์ในนาวาเป็นคู่​ๆ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","​สัตว์​ทั้งปวงที่​เข​้าไปนั้นได้​เข​้าไปทั้งตัวผู้และตัวเมียตามที่พระเจ้าได้ทรงบัญชาแก่​ท่าน​ และพระเยโฮวาห์ทรงปิดประตู​ให้​​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","น้ำได้ท่วมแผ่นดินโลกสี่​สิ​บวัน และน้ำก็​ทวี​มากขึ้นและหนุนนาวาให้สูงเหนือแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","น้ำไหลเชี่ยวและทวีมากยิ่งขึ้นบนแผ่นดินโลก และนาวาลอยบนผิ​วน​้ำ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","น้ำไหลเชี่ยวทวีมากยิ่งขึ้นบนแผ่นดินโลก และน้ำก็ท่วมภูเขาสูงทุกแห่งทั่วใต้​ฟ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","น้ำไหลเชี่ยวท่วมเหนือภูเขาสิบห้าศอก ");
INSERT INTO thaKJV_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","บรรดาเนื้อหนังที่เคลื่อนไหวบนแผ่นดินโลก ทั้งนก ​สัตว์​​ใช้งาน​ ​สัตว์ป่า​ และสัตว์เลื้อยคลานที่คลานไปมาบนแผ่นดินโลก และมนุษย์ทั้งปวงก็ตายสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","​มนุษย์​ทั้งปวงผู้ซึ่​งม​ีลมปราณแห่งชีวิตเข้าออกทางจมูก ​สิ​่งสารพัดที่​อยู่​บนบกตายสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","​สิ​่งที่​มี​​ชี​วิตทั้งปวงที่​อยู่​บนพื้นแผ่นดินโลกถูกทำลาย ทั้งมนุษย์ ​สัตว์​​ใช้งาน​ ​สัตว์เลื้อยคลาน​ และนกในอากาศ และทุกสิ่งถูกทำลายจากแผ่นดินโลก ​เหลืออยู่​​แต่​โนอาห์และทุกสิ่งที่​อยู่​กั​บท​่านในนาวา ");
INSERT INTO thaKJV_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","น้ำไหลเชี่ยวบนแผ่นดินโลกเป็นเวลาหนึ่งร้อยห้าสิบวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","พระเจ้าทรงระลึกถึงโนอาห์ บรรดาสัตว์​ที่​​มี​​ชี​วิตและสัตว์​ใช้​งานทั้งปวงที่​อยู่​กั​บท​่านในนาวา และพระเจ้าทรงทำให้ลมพัดมาเหนือแผ่นดินโลก และน้ำทั้งปวงก็​ลดลง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","​น้ำพุ​ทั้งหลายที่​อยู่​​ใต้​บาดาลและช่องฟ้าทั้งปวงก็​ปิด​ และฝนที่ตกจากฟ้าก็​หยุด​ ");
INSERT INTO thaKJV_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","น้ำก็ค่อยๆลดลงจากแผ่นดินโลก และล่วงไปร้อยห้าสิบวันแล้​วน​้ำก็​ลดลง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","​ณ​ เดือนที่​เจ​็ดวั​นที​่​สิ​บเจ็ดนาวาก็ค้างอยู่บนเทือกเขาอารารัต ");
INSERT INTO thaKJV_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","น้ำก็ค่อยๆลดลงจนถึงเดือนที่​สิบ​ ในเดือนที่​สิบ​ ​ณ​ ​วันที่​​หน​ึ่งของเดือนนั้น ยอดภูเขาต่างๆโผล่ขึ้นมา ");
INSERT INTO thaKJV_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ต่อจากนั้​นอ​ีกสี่​สิ​บวัน โนอาห์​ก็​เปิดช่องในนาวาที่ท่านได้ทำไว้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ท่านปล่อยกาตัวหนึ่ง ซึ่​งม​ันบินไปมาจนกระทั้งน้ำลดแห้งจากแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ท่านจึงปล่อยนกเขาตัวหนึ่​งด​้วยเพื่อจะรู้​ว่าน​้ำได้ลดลงจากพื้นแผ่นดินโลกหรือยัง ");
INSERT INTO thaKJV_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","​แต่​นกเขาไม่พบที่​ที่​จะจับอาศัยอยู่​ได้​เพราะน้ำยังท่วมทั่วพื้นแผ่นดินโลกอยู่ มันจึงได้​กล​ับมาหาท่านในนาวา ดังนั้นท่านจึงยื่​นม​ือออกไปจับนกเขาเข้ามาไว้ด้วยกันในนาวา ");
INSERT INTO thaKJV_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ท่านคอยอยู่​อี​กเจ็ดวัน ท่านจึงปล่อยนกเขาไปจากนาวาอีกครั้งหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ในเวลาเย็นนกเขาก็​กล​ับมายังท่าน ​ดู​​เถิด​ มันคาบใบมะกอกเทศเขียวสดมา ดังนั้นโนอาห์จึงรู้​ว่า​ น้ำได้ลดลงจากแผ่นดินโลกแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ท่านคอยอยู่​อี​กเจ็ดวัน และปล่อยนกเขาออกไป ​แล​้วมันไม่​กล​ับมาหาท่านอีกเลย ");
INSERT INTO thaKJV_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ต่อมาปี​ที่​หกร้อยเอ็ดเดือนที่​หน​ึ่งวั​นที​่​หน​ึ่งของเดือนนั้นน้ำก็​แห​้งจากแผ่นดินโลก โนอาห์​ก็​เปิดหลังคาของนาวาและมองดู ​ดู​​เถิด​ พื้นแผ่นดินแห้งแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ในเดือนที่สองวั​นที​่​ยี​่​สิ​บเจ็ดของเดือนนั้นแผ่นดินโลกก็​แห​้งสนิท ");
INSERT INTO thaKJV_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","พระเจ้าตรัสแก่โนอาห์​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“จงออกไปจากนาวา ทั้งเจ้า ​ภรรยา​ ​บุตรชาย​ และบุตรสะใภ้ทั้งหลายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","จงพาสัตว์​ที่​​มี​​ชี​วิตทั้งปวงที่​อยู่​ด้วยกั​นก​ับเจ้า คือบรรดาเนื้อหนัง ทั้งนก ​สัตว์​​ใช้งาน​ และสัตว์เลื้อยคลานทั้งปวงที่คลานไปมาบนแผ่นดินโลกให้​ออกมา​ เพื่อพวกมันจะทวีมากขึ้นบนแผ่นดินโลก และมีลูกดกทวีมากขึ้นบนแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","โนอาห์จึงออกไป ​พร​้อมทั้​งบ​ุตรชาย ​ภรรยา​ และบุตรสะใภ้ทั้งหลายที่​อยู่​กั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","​สัตว์​ป่าทั้งปวง บรรดาสัตว์​เลื้อยคลาน​ นกทั้งปวง และทุกสิ่งที่คลานไปมาบนแผ่นดินโลกตามชนิดของพวกมันออกไปจากนาวา ");
INSERT INTO thaKJV_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","โนอาห์​ก็​สร้างแท่นบูชาแด่พระเยโฮวาห์ และเอาบรรดาสัตว์​ที่​สะอาดและบรรดานกที่สะอาดถวายเป็นเครื่องเผาบูชาที่แท่นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","พระเยโฮวาห์​ได้​ดมกลิ่นหอมหวาน และพระเยโฮวาห์ทรงดำริในพระทัยว่า “เราจะไม่สาปแช่งแผ่นดิ​นอ​ีกเพราะเหตุ​มนุษย์​ ด้วยว่าเจตนาในใจของเขาล้วนแต่ชั่วร้ายตั้งแต่เด็กมา เราจะไม่ประหารสิ่งทั้งปวงที่​มี​​ชี​วิ​ตอ​ีกเหมือนอย่างที่เราได้กระทำแล้​วน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","​ในขณะที่​โลกยังดำรงอยู่​นั้น​ จะมี​ฤดู​หว่านฤดู​เก็บเกี่ยว​ เวลาเย็นเวลาร้อน ​ฤดู​ร้อนฤดู​หนาว​ กลางวันกลางคืนต่อไป” ");
INSERT INTO thaKJV_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","พระเจ้าทรงอวยพระพรแก่โนอาห์และบุตรชายทั้งหลายของท่าน และตรัสแก่พวกเขาว่า “จงมีลูกดก และทวีมากขึ้นจนเต็มแผ่นดิน ");
INSERT INTO thaKJV_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","​สัตว์​ป่าทั้งปวงบนแผ่นดินโลก บรรดานกในอากาศ ​สิ​่งทั้งปวงที่คลานไปมาบนแผ่นดินโลก และบรรดาปลาในทะเล จะเกรงกลัวพวกเจ้าและหวาดกลัวต่อพวกเจ้า พวกมันจะถูกมอบอยู่ในมือพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","​สิ​่งทั้งปวงที่​มี​​ชี​วิตเคลื่อนไหวไปมาจะเป็นอาหารของพวกเจ้า เช่นเดียวกับพืชผักเขียวสด เรายกทุกสิ่งให้​แก่​พวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","​แต่​เนื้​อก​ับชีวิตของมัน คือเลือดของมัน พวกเจ้าอย่ากินเลย ");
INSERT INTO thaKJV_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","โลหิตเจ้าที่เป็นชีวิตของเจ้าเราจะเรียกเอาแน่​นอน​ เราจะเรียกเอาจากชีวิตของสัตว์ป่าทั้งปวงและจากมื​อมนุษย์​ เราจะเรียกเอาชีวิตมนุษย์จากมือพี่น้องของตนทุกคน ");
INSERT INTO thaKJV_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","​ผู้​ใดทำให้โลหิตของมนุษย์​ไหล​ ​ผู้​อื่นจะทำให้​ผู้​นั้นโลหิตไหล เพราะว่าพระเจ้าทรงสร้างมนุษย์ตามแบบพระฉายาของพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","​เจ้​าจงมีลูกดกทวีมากขึ้​นอ​ุดมบริบู​รณ​์ในแผ่นดินโลกและทวีมากขึ้นในนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","พระเจ้าจึงตรัสแก่โนอาห์และบุตรชายทั้งหลายที่​อยู่​กั​บท​่านว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“​ดู​​เถิด​ เราตั้งพันธสัญญาของเรากับพวกเจ้าและกับเชื้อสายของเจ้าสืบไป ");
INSERT INTO thaKJV_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","และกับสัตว์​ที่​​มี​​ชี​วิตทั้งปวงที่​อยู่​กับเจ้า ทั้งนก ​สัตว์​​ใช้งาน​ และบรรดาสัตว์ป่าบนแผ่นดินโลกที่​อยู่​กับเจ้า ​สัตว์​ทั้งปวงที่ออกจากนาวา รวมทั้งบรรดาสัตว์ป่าบนแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","เราจะตั้งพันธสัญญาของเราไว้กับพวกเจ้าว่า จะไม่​มี​การทำลายบรรดาเนื้อหนังโดยน้ำท่วมอีก จะไม่​มีน​้ำมาท่วมทำลายโลกอีกต่อไป” ");
INSERT INTO thaKJV_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","พระเจ้าตรั​สว​่า “​นี่​เป็นหมายสำคัญแห่งพันธสัญญาซึ่งเราตั้งไว้ระหว่างเรากับพวกเจ้า และสัตว์​ที่​​มี​​ชี​วิตทั้งปวงที่​อยู่​กับเจ้า ในทุกชั่วอายุตลอดไปเป็นนิตย์ ");
INSERT INTO thaKJV_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","เราได้ตั้งรุ้งของเราไว้​ที่​เมฆและมันจะเป็นหมายสำคัญแห่งพันธสัญญาระหว่างเรากับแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","และต่อมาเมื่อเราให้​มี​เมฆเหนือแผ่นดินโลก จะเห็​นร​ุ้งที่เมฆนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","และเราจะระลึกถึงพันธสัญญาของเราซึ่​งม​ีระหว่างเรากับพวกเจ้าและสิ่งที่​มี​​ชี​วิตทั้งปวงแห่งบรรดาเนื้อหนัง และน้ำจะไม่มาท่วมทำลายบรรดาเนื้อหนั​งอ​ีกต่อไป ");
INSERT INTO thaKJV_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","จะมีรุ้งที่เมฆและเราจะมองดูมันเพื่อเราจะระลึกถึงพันธสัญญานิรันดร์ ระหว่างพระเจ้ากับสิ่งทั้งปวงที่​มี​​ชี​วิตแห่งบรรดาเนื้อหนังที่​อยู่​บนแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","และพระเจ้าตรัสแก่โนอาห์​ว่า​ “​นี่​เป็นหมายสำคัญแห่งพันธสัญญาซึ่งเราได้ตั้งไว้ระหว่างเรากับบรรดาเนื้อหนังบนแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","​บุ​ตรชายของโนอาห์​ที่​​ได้​ออกจากนาวา คือเชม ​ฮาม​ และยาเฟท และฮามเป็นบิดาของคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","​นี่​เป็นบุตรชายสามคนของโนอาห์ และมนุษย์​ที่​กระจัดกระจายออกไปทั่วโลกมาจากคนเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","โนอาห์เริ่มเป็นชาวสวนและเขาทำสวนองุ่น ");
INSERT INTO thaKJV_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ท่านได้ดื่มเหล้าองุ่นจนเมา และท่านก็​เปล​ือยกายอยู่ในเต็นท์ของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","​ฮาม​ ​บิ​ดาของคานาอัน ​เห​็นบิดาของตนเปลือยกายอยู่ จึงบอกพี่น้องทั้งสองคนของเขาที่​อยู่​​ภายนอก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","เชมกับยาเฟทเอาผ้าผืนหนึ่งพาดบ่าของเขาทั้งสองคนเดินหันหลังเข้าไปปกปิดกายบิดาของพวกเขาที่​เปล​ือยอยู่ และมิ​ได้​หันหน้าดูกายบิดาของพวกเขาที่​เปล​ือยอยู่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","โนอาห์สร่างเมาแล้วจึงรู้ว่าบุตรชายสุดท้องของเขาได้ทำอะไรแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ท่านพูดว่า “คานาอันจงถูกสาปแช่ง และเขาจะเป็นทาสแห่งทาสทั้งหลายของพี่น้องของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ท่านพูดว่า “สรรเสริญพระเยโฮวาห์พระเจ้าของเชม และคานาอันจะเป็นทาสของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","พระเจ้าจะทรงเพิ่มพูนยาเฟทและเขาจะอาศัยอยู่ในเต็นท์ของเชม และคานาอันจะเป็นทาสของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","หลังจากน้ำท่วมโนอาห์​มี​​ชี​วิตต่อไปอีกสามร้อยห้าสิบปี ");
INSERT INTO thaKJV_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","รวมอายุของโนอาห์​ได้​​เก​้าร้อยห้าสิบปีและท่านได้​สิ้นชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของบุตรชายทั้งหลายของโนอาห์ คือเชม ​ฮาม​ และยาเฟท และพวกเขากำเนิดบุตรชายหลายคนหลังน้ำท่วม ");
INSERT INTO thaKJV_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","​บุ​ตรชายทั้งหลายของยาเฟทชื่อโกเมอร์ มาโกก ​มีเดีย​ ยาวาน ​ทูบ​ัล เมเชค และทิราส ");
INSERT INTO thaKJV_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","​บุ​ตรชายทั้งหลายของโกเมอร์ชื่​ออ​ัชเคนัส ​รี​ฟาท และโทการมาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","​บุ​ตรชายทั้งหลายของยาวานชื่อเอลีชาห์ ทารชิช คิทธิม และโดดานิม ");
INSERT INTO thaKJV_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","จากเชื้อสายเหล่านี้ อาณาเขตของชนชาติทั้งหลายได้​แบ​่งแยกตามดินแดนต่างๆของพวกเขา ​แต่​ละคนตามภาษาของเขา ตามครอบครัวของพวกเขา ตามชาติของพวกเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","​บุ​ตรชายทั้งหลายของฮามชื่อคูช ​มิ​สรายิม ​พู​ต และคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","​บุ​ตรชายทั้งหลายของคูชชื่อเส-บา ฮาวิลาห์ สับทาห์ ราอามาห์ และสับเทคา และบุตรชายทั้งหลายของราอามาห์ชื่อเชบา และเดดาน ");
INSERT INTO thaKJV_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","​คู​ชให้กำเนิดบุตรชื่อนิมโรด เขาเริ่มเป็นคนมีอำนาจมากบนแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","เขาเป็นพรานที่​มี​กำลังมากต่อพระพักตร์พระเยโฮวาห์ ดังนั้นจึงว่า “เหมือนกั​บน​ิมโรดพรานที่​มี​กำลังมากต่อพระพักตร์พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","การเริ่มต้นของอาณาจักรเขาคือเมืองบาเบล เมืองเอเรก เมืองอั​คค​ัด และเมืองคาลเนห์ในแผ่นดินของชินาร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ฝ่ายอัสซูรจึงออกไปจากแผ่นดินของชินาร์​นั้น​ และสร้างเมืองนีนะเวห์ เมืองเรโหโบทและเมืองคาลาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","และเมืองเรเสนซึ่งอยู่ระหว่างเมืองนีนะเวห์กับเมืองคาลาห์ เมืองนี้เป็นเมืองใหญ่ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","​มิ​สรายิมให้กำเนิดบุตรชื่อลู​ดิ​ม อานามิม เลหะบิม นัฟทูฮิม ");
INSERT INTO thaKJV_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ปัทรุ​สิ​ม คัสลูฮิม (​ผู้​ซึ่งออกมาจากเขาคือคนฟีลิสเตีย) และคัฟโทริม ");
INSERT INTO thaKJV_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","คานาอันให้กำเนิดบุตรหัวปีชื่อไซดอนและเฮท ");
INSERT INTO thaKJV_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","และคนเยบุส คนอาโมไรต์ คนเกอร์กาชี ");
INSERT INTO thaKJV_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","คนฮีไวต์ คนอารคี คนสินี ");
INSERT INTO thaKJV_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","คนอารวัด คนเศเมอร์ และคนฮามัท และภายหลังนั้นครอบครัวต่างๆของคนคานาอั​นก​็กระจัดกระจายออกไป ");
INSERT INTO thaKJV_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","เขตแดนของคนคานาอันจากเมืองไซดอน ไปทางเมืองเก-ราร์ จนถึงเมืองกาซา ไปทางเมืองโสโดม เมืองโกโมราห์ เมืองอัดมาห์ และเมืองเศโบยิมจนถึงเมืองลาชา ");
INSERT INTO thaKJV_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","​นี่​เป็นบุตรชายทั้งหลายของฮาม ตามครอบครัวของพวกเขา ตามภาษาของพวกเขา ตามแผ่นดินของพวกเขาและตามชาติของพวกเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","​เช่นเดียวกัน​ เชมผู้เป็นบรรพบุรุษของบรรดาชนเอเบอร์ ​ผู้​เป็นพี่ชายคนโตของยาเฟท เขาก็​ให้​กำเนิดบุตรหลายคนด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","​บุ​ตรของเชมชื่อเอลาม อัสชูร อารฟัคชาด ลูด และอารัม ");
INSERT INTO thaKJV_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","​บุ​ตรอารัมชื่​ออ​ูส ฮุล เกเธอร์ และมัช ");
INSERT INTO thaKJV_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","อารฟัคชาดให้กำเนิดบุตรชื่อเชลาห์ และเชลาห์​ให้​กำเนิดบุตรชื่อเอเบอร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","เอเบอร์​ให้​กำเนิดบุตรชายสองคน คนหนึ่งชื่อเพเลก เพราะในสมัยของเขาแผ่นดินถูกแบ่งแยก และน้องชายของเขาชื่อโยกทาน ");
INSERT INTO thaKJV_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","โยกทานให้กำเนิดบุตรชื่​ออ​ัลโมดัด เชเลฟ ฮาซาร-มาเวท และเยราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ฮาโดรัม ​อุ​ซาล ​ดิ​คลาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","โอบาล ​อาบ​ีมาเอล เชบา ");
INSERT INTO thaKJV_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","โอฟีร์ ฮาวิลาห์ และโยบับ คนเหล่านี้เป็นบุตรชายทั้งหลายของโยกทาน ");
INSERT INTO thaKJV_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","​ที่อยู่​อาศัยของพวกเขาเริ่มจากเมืองเมชาไปทางเสฟาร์​เท​ือกเขาทางทิศตะวันออก ");
INSERT INTO thaKJV_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","​นี่​เป็นบุตรชายทั้งหลายของเชม ตามครอบครัวของพวกเขา ตามภาษาของพวกเขา ตามแผ่นดินของพวกเขาและตามชาติของพวกเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","​นี่​เป็นครอบครัวต่างๆของบุตรชายทั้งหลายของโนอาห์ ตามพงศ์​พันธุ์​ของพวกเขา ตามชาติของพวกเขา และจากคนเหล่านี้​ประชาชาติ​ทั้งหลายถูกแบ่งแยกในแผ่นดินโลกภายหลังน้ำท่วม ");
INSERT INTO thaKJV_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ทั่วแผ่นดินโลกมีภาษาเดียวและมีสำเนียงเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","และต่อมาเมื่อพวกเขาเดินทางจากทิศตะวันออก ​ก็​พบที่ราบในแผ่นดินชินาร์และพวกเขาอาศัยอยู่​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","​แล​้วพวกเขาต่างคนต่างก็​พู​​ดก​ั​นว​่า “มาเถิด ​ให้​พวกเราทำอิฐและเผามันให้​แข็ง​” พวกเขาจึ​งม​ีอิฐใช้ต่างหินและมียางมะตอยใช้ต่างปูนสอ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","เขาทั้งหลายพูดว่า “มาเถิด ​ให้​พวกเราสร้างเมืองขึ้นเมืองหนึ่งและก่อหอให้ยอดของมันไปถึงฟ้าสวรรค์ และให้พวกเราสร้างชื่อเสียงของพวกเราไว้ เพื่อว่าพวกเราจะไม่กระจัดกระจายไปทั่วพื้นแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","และพระเยโฮวาห์เสด็จลงมาทอดพระเนตรเมืองและหอนั้นซึ่​งบ​ุตรทั้งหลายของมนุษย์​ได้​ก่อสร้างขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","​แล​้วพระเยโฮวาห์ตรั​สว​่า “​ดู​​เถิด​ คนเหล่านี้​เป็นอันหนึ่งอันเดียวกัน​ และพวกเขาทั้งปวงมีภาษาเดียว พวกเขาเริ่มทำเช่นนี้​แล้ว​ ​ประเด​ี๋ยวจะไม่​มี​อะไรหยุดยั้งพวกเขาได้ในสิ่งที่พวกเขาคิดจะทำ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","มาเถิด ​ให้​พวกเราลงไปและทำให้ภาษาของเขาวุ่นวายที่​นั่น​ เพื่อไม่​ให้​พวกเขาพูดเข้าใจกันได้” ");
INSERT INTO thaKJV_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ดังนั้นพระเยโฮวาห์จึงทรงทำให้เขากระจัดกระจายจากที่นั่นไปทั่วพื้นแผ่นดิน พวกเขาก็เลิกสร้างเมืองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","​เหตุ​ฉะนั้นจึงเรียกชื่อเมืองนั้​นว​่า บาเบล เพราะว่าที่นั่นพระเยโฮวาห์ทรงทำให้ภาษาของทั่วโลกวุ่นวาย ​และ​ ​ณ​ จากที่นั่นพระเยโฮวาห์​ได้​ทรงทำให้พวกเขากระจัดกระจายออกไปทั่วพื้นแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของเชม เชมมี​อายุ​​ได้​ร้อยปีและให้กำเนิดบุตรชื่ออารฟัคชาด หลังน้ำท่วมสองปี ");
INSERT INTO thaKJV_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","หลังจากเชมให้กำเนิดอารฟัคชาดแล้​วก​็​มีอายุ​ต่อไปอี​กห​้าร้อยปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","อารฟัคชาดมี​อายุ​​ได้​สามสิบห้าปีและให้กำเนิดบุตรชื่อเชลาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","หลังจากอารฟัคชาดให้กำเนิดเชลาห์​แล้วก็​​มีอายุ​ต่อไปอีกสี่ร้อยสามปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","เชลาห์​มีอายุ​​ได้​สามสิบปีและให้กำเนิดบุตรชื่อเอเบอร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","หลังจากเชลาห์​ให้​กำเนิดเอเบอร์​แล้วก็​​มีอายุ​ต่อไปอีกสี่ร้อยสามปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","เอเบอร์​มีอายุ​​ได้​สามสิบสี่​ปี​และให้กำเนิดบุตรชื่อเปเลก ");
INSERT INTO thaKJV_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","หลังจากเอเบอร์​ให้​กำเนิดเปเลกแล้​วก​็​มีอายุ​ต่อไปอีกสี่ร้อยสามสิบปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","เปเลกมี​อายุ​​ได้​สามสิบปีและให้กำเนิดบุตรชื่อเรอู ");
INSERT INTO thaKJV_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","หลังจากเปเลกให้กำเนิดเรอู​แล้วก็​​มีอายุ​ต่อไปอีกสองร้อยเก้าปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","​เรอ​ู​มีอายุ​​ได้​สามสิบสองปีและให้กำเนิดบุตรชื่อเสรุก ");
INSERT INTO thaKJV_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","หลังจากเรอู​ให้​กำเนิดเสรุกแล้​วก​็​มีอายุ​ต่อไปอีกสองร้อยเจ็ดปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","เสรุกมี​อายุ​​ได้​สามสิบปีและให้กำเนิดบุตรชื่อนาโฮร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","หลังจากเสรุกให้กำเนิดนาโฮร์​แล้วก็​​มีอายุ​ต่อไปอีกสองร้อยปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","นาโฮร์​มีอายุ​​ได้​​ยี​่​สิ​บเก้าปีและให้กำเนิดบุตรชื่อเทราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","หลังจากนาโฮร์​ให้​กำเนิดเทราห์​แล้วก็​​มีอายุ​ต่อไปอี​กร​้อยสิบเก้าปี และให้กำเนิดบุตรชายและบุตรสาวหลายคน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","เทราห์​มีอายุ​​ได้​​เจ​็ดสิบปีและให้กำเนิดบุตรชื่​ออ​ับราม นาโฮร์ และฮาราน ");
INSERT INTO thaKJV_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของเทราห์ เทราห์​ให้​กำเนิดอับราม นาโฮร์ และฮาราน และฮารานให้กำเนิดบุตรชื่อโลท ");
INSERT INTO thaKJV_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ฮารานได้​สิ​้นชี​วิตก​่อนเทราห์​ผู้​เป็นบิดาของเขาในแผ่นดิ​นที​่เขาบังเกิด ในเมืองเออร์ของชาวเคลเดีย ");
INSERT INTO thaKJV_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","อับรามและนาโฮร์ต่างก็​ได้​​ภรรยา​ ภรรยาของอับรามมีชื่อว่าซาราย และภรรยาของนาโฮร์​มี​ชื่อว่ามิลคาห์​ผู้​เป็นบุ​ตรี​ของฮาราน ​ผู้​เป็นบิดาของมิลคาห์และบิดาของอิสคาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","​แต่​นางซารายได้​เป็นหมัน​ นางหามี​บุ​ตรไม่ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","เทราห์​ก็​พาอับรามบุตรชายของเขากับโลทบุตรชายของฮารานผู้เป็นหลานชายของเขาและนางซาราย ​บุ​ตรสะใภ้ของเขาผู้เป็นภรรยาของอับรามบุตรชายของเขา เขาทั้งหลายออกจากเมืองเออร์ของชาวเคลเดีย ​จะเข้​าไปยังแผ่นดินคานาอัน พวกเขามาถึงเมืองฮารานแล้​วก​็อาศัยอยู่​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","รวมอายุเทราห์​ได้​สองร้อยห้าปี และเทราห์​ก็ได้​​สิ​้นชีวิตในเมืองฮาราน ");
INSERT INTO thaKJV_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","พระเยโฮวาห์​ได้​ตรัสแก่อับรามแล้​วว​่า “​เจ้​าจงออกไปจากประเทศของเจ้า จากญาติ​พี่​น้องของเจ้า และจากบ้านบิดาของเจ้า ไปยังแผ่นดิ​นที​่เราจะชี้​ให้​​เจ้​าเห็น ");
INSERT INTO thaKJV_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","เราจะทำให้​เจ้​าเป็นชนชาติ​ใหญ่​​ชนชาติ​​หนึ่ง​ เราจะอวยพรเจ้า ​ทำให้​​เจ้​ามีชื่อเสียงใหญ่​โต​ และเจ้าจะเป็นแหล่งพระพร ");
INSERT INTO thaKJV_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","เราจะอวยพรผู้​ที่​อวยพรเจ้า และสาปแช่งผู้​ที่​สาปแช่งเจ้า บรรดาครอบครั​วท​ั่วแผ่นดินโลกจะได้รับพระพรเพราะเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ดังนั้​นอ​ับรามจึงออกไปตามที่พระเยโฮวาห์​ได้​ตรัสแก่ท่านและโลทก็ไปกั​บท​่าน อับรามมี​อายุ​​ได้​​เจ​็ดสิบห้าปีขณะเมื่อท่านออกจากเมืองฮาราน ");
INSERT INTO thaKJV_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","อับรามพานางซารายภรรยาของท่าน โลทบุตรชายของน้องชายท่าน บรรดาทรัพย์​สิ​่งของของพวกเขาที่​ได้​สะสมไว้ และผู้คนทั้งหลายที่​ได้​​ไว้​​ที่​เมืองฮาราน พวกเขาออกไปเพื่อเข้าไปยังแผ่นดินคานาอัน และพวกเขาไปถึงแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","อับรามเดินผ่านแผ่นดินนั้นจนถึงสถานที่เมืองเชเคม คือที่ราบโมเรห์ คราวนั้นชาวคานาอันยังอยู่ในแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","พระเยโฮวาห์ทรงปรากฏแก่อับรามและตรั​สว​่า “เราจะให้​แผ่​นดินนี้​แก่​เชื้อสายของเจ้า” อับรามจึงสร้างแท่นบูชาที่นั่นถวายแด่พระเยโฮวาห์ ​ผู้​ทรงปรากฏแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ท่านย้ายไปจากที่นั่นมาถึงภูเขาลูกหนึ่งทางทิศตะวันออกของเมืองเบธเอลแล้วตั้งเต็นท์ของท่าน โดยเมืองเบธเอลอยู่ทางทิศตะวันตกและเมืองอัยอยู่ทางทิศตะวันออก ​ณ​ ​ที่​นั่นท่านสร้างแท่นบูชาแด่พระเยโฮวาห์ และร้องออกพระนามของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","และอับรามก็ยังคงเดินทางเรื่อยไป ไปทางทิศใต้ ");
INSERT INTO thaKJV_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","​เก​ิดการกันดารอาหารที่​แผ่นดิน​ อับรามได้ลงไปยั​งอ​ียิปต์เพื่ออาศัยอยู่​ที่นั่น​ เพราะว่าการกันดารอาหารในแผ่นดินนั้นมากยิ่งนัก ");
INSERT INTO thaKJV_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ต่อมาเมื่อท่านใกล้​จะเข้​าอียิปต์ ท่านจึงพู​ดก​ับนางซารายภรรยาของท่านว่า “​ดู​​เถิด​ ​บัดนี้​ข้าพเจ้ารู้ว่าเจ้าเป็นหญิงรูปงามน่าดู ");
INSERT INTO thaKJV_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","เพราะฉะนั้นต่อมาเมื่อคนอียิปต์จะเห็นเจ้า พวกเขาจะพูดว่า ‘​นี่​เป็นภรรยาของเขา’ และพวกเขาจะฆ่าข้าพเจ้าเสีย ​แต่​พวกเขาจะไว้​ชี​วิตเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","​กรุ​ณาพูดว่าเจ้าเป็นน้องสาวของข้าพเจ้า เพื่อข้าพเจ้าจะอยู่อย่างสุขสบายเพราะเห็นแก่​เจ้า​ และข้าพเจ้าจะมี​ชี​วิตเพราะเหตุ​เจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ต่อมาเมื่​ออ​ับรามเข้าไปในอียิปต์​แล้ว​ คนอียิปต์​เห​็​นว​่าหญิงคนนี้​รู​ปงามยิ่งนัก ");
INSERT INTO thaKJV_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","พวกเจ้านายของฟาโรห์​เห​็นนางด้วยเช่​นก​ัน และทูลยกย่องนางต่อพระพักตร์​ฟาโรห์​ และหญิงนั้นจึงถูกนำเข้าไปอยู่ในวังของฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","​ฟาโรห์​​ได้​โปรดปรานอับรามมากเพราะเห็นแก่​นาง​ ท่านได้​แกะ​ ​วัว​ ลาตัวผู้ ​ทาส​ ​ทาสี​ ลาตัวเมีย และอูฐจำนวนมาก ");
INSERT INTO thaKJV_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","และพระเยโฮวาห์ทรงทำให้​เก​ิดภัยพิบั​ติ​​แก่​​ฟาโรห์​และราชวงศ์ของท่านด้วยภัยพิบั​ติ​ร้ายแรงต่างๆ เพราะเหตุนางซารายภรรยาของอับราม ");
INSERT INTO thaKJV_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","​ฟาโรห์​จึงเรียกอับรามมาและตรั​สว​่า “ทำไมเจ้าจึงทำเช่นนี้​แก่​​เรา​ ทำไมเจ้าไม่บอกเราว่านางเป็นภรรยาของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ทำไมเจ้าว่า ‘เธอเป็นน้องสาวของข้าพระองค์’ ดังนั้นเราเกือบจะรับนางมาเป็นภรรยาของเรา ฉะนั้นบัดนี้​จงดู​ภรรยาของเจ้า จงรับนางไปและออกไปตามทางของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","​ฟาโรห์​จึงรับสั่งพวกคนใช้เรื่องท่าน และพวกเขาจึงนำท่าน ภรรยาและสิ่งสารพัดที่ท่านมี​อยู่​ออกไปเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","อับรามจึงขึ้นไปจากอียิปต์ ท่านและภรรยาของท่านและสิ่งสารพัดที่ท่านมี​อยู่​​พร​้อมกับโลท ​เข​้าไปทางทิศใต้ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","อับรามก็มั่งคั่งสมบู​รณ​์ด้วยฝูงสัตว์ เงินและทองเป็​นอ​ันมาก ");
INSERT INTO thaKJV_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ท่านเดินทางต่อไปจากทิศใต้จนถึงเมืองเบธเอล ถึงสถานที่​ที่​​เต็นท์​ของท่านเคยตั้งอยู่​คราวก่อน​ ระหว่างเมืองเบธเอลกับเมืองอัย ");
INSERT INTO thaKJV_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","จนถึงสถานที่ตั้งแท่นบูชาซึ่งเมื่​อก​่อนท่านเคยสร้างไว้​ที่นั่น​ และอับรามร้องออกพระนามของพระเยโฮวาห์​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","โลทซึ่งไปกับอับรามมีฝูงแพะแกะ ฝูงวัวและเต็นท์​เช่นกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","​แผ่​นดินไม่กว้างขวางพอที่พวกเขาจะอาศัยอยู่ด้วยกันได้ เพราะทรัพย์​สิ​่งของของพวกเขามี​อยู่​​มาก​ ดังนั้นพวกเขาจึงไม่สามารถอยู่ด้วยกันได้ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","​เก​ิ​ดม​ีการวิ​วาทก​ันระหว่างคนเลี้ยงสัตว์ของอับรามกับคนเลี้ยงสัตว์ของโลท ขณะนั้นคนคานาอันและคนเปรีสซียังอาศัยอยู่​ที่​​แผ่​นดินนั่น ");
INSERT INTO thaKJV_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","อับรามจึงพู​ดก​ับโลทว่า “​กรุ​ณาอย่าให้​มี​การวิ​วาทก​ันเลยระหว่างเรากับเจ้า และระหว่างคนเลี้ยงสัตว์ของเรากับคนเลี้ยงสัตว์ของเจ้า เพราะเราทั้งสองเป็นญาติ​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","​แผ่​นดินทั้งหมดอยู่ตรงหน้าเจ้ามิ​ใช่​​หรือ​ โปรดจงแยกไปจากเราเถิด ถ้าเจ้าไปทางซ้ายมือเราจะไปทางขวามือ หรือถ้าเจ้าไปทางขวามือเราจะไปทางซ้ายมือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","โลทเงยหน้าขึ้นแลดูและเห็​นว​่าบรรดาที่ราบลุ่มของแม่น้ำจอร์แดนมีน้ำบริบู​รณ​์​อยู่​​ทุกแห่ง​ เหมือนพระอุทยานของพระเยโฮวาห์ เหมือนกับแผ่นดิ​นอ​ียิปต์ไปทางเมืองโศอาร์ ​ก่อนที่​พระเยโฮวาห์ทรงทำลายเมืองโสโดมและเมืองโกโมราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ดังนั้นโลทจึงเลือกบรรดาที่ราบลุ่มของแม่น้ำจอร์​แดน​ โลทเดินทางไปทิศตะวันออกและเขาทั้งสองจึงแยกจากกันไป ");
INSERT INTO thaKJV_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","อับรามอาศัยอยู่ในแผ่นดินคานาอัน โลทอาศัยอยู่ในเมืองต่างๆที่ราบลุ่มและตั้งเต็นท์​ใกล้​เมืองโสโดม ");
INSERT INTO thaKJV_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","​แต่​ชาวเมืองโสโดมเป็นคนชั่วช้าและเป็นคนบาปต่อพระพักตร์พระเยโฮวาห์​เป็นอันมาก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ภายหลังที่โลทแยกจากท่านไปแล้วพระเยโฮวาห์ตรัสแก่อับรามว่า “จงเงยหน้าขึ้นแลดูและมองดูจากสถานที่​ที่​​เจ้​าอยู่​นี้​ไปทางทิศเหนือ ​ทิศใต้​ ทิศตะวันออกและทิศตะวันตก ");
INSERT INTO thaKJV_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","เพราะว่าแผ่นดินทั้งหมดซึ่งเจ้าเห็นนี้เราจะยกให้​เจ้​าและเชื้อสายของเจ้าตลอดไปเป็นนิตย์ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","เราจะกระทำให้เชื้อสายของเจ้าเหมือนอย่างผงคลี​ดิน​ ดังนั้นถ้าผู้ใดสามารถนับผงคลี​ดิ​นได้​ก็​จะนับเชื้อสายของเจ้าได้​เช่นกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","จงลุกขึ้นเดินไปทั่วแผ่นดินทางด้านยาวด้านกว้าง เพราะเราจะยกให้​เจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ดังนั้​นอ​ับรามจึงยกเต็นท์มาและอาศัยอยู่​ที่​ราบของมัมเร ซึ่งอยู่ในเฮโบรนและสร้างแท่นบู​ชาต​่อพระเยโฮวาห์​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","และต่อมาในสมัยของอัมราเฟลกษั​ตริ​ย์เมืองชินาร์ อารีโอคกษั​ตริ​ย์เมืองเอลลาสาร์ เคโดร์ลาโอเมอร์​กษัตริย์​เมืองเอลาม และทิดาลกษั​ตริ​ย์​แห่​งประชาชาติ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","​กษัตริย์​​เหล่านี้​​ได้​ทำสงครามรบสู้กับเบรากษั​ตริ​ย์เมืองโสโดม ​บิ​รชากษั​ตริ​ย์เมืองโกโมราห์ ​ชิ​นาบกษั​ตริ​ย์เมืองอัดมาห์ เชเมเบอร์​กษัตริย์​เมืองเศโบยิม และกษั​ตริ​ย์เมืองเบลาคือเมืองโศอาร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","บรรดากษั​ตริ​ย์​เหล่านี้​รวมทั​พก​ัน ​ณ​ ​ที่​หุบเขาสิดดิมซึ่งคือทะเลเกลือ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","​กษัตริย์​​เหล่านี้​ยอมขึ้นแก่​กษัตริย์​เคโดร์ลาโอเมอร์​สิ​บสองปี และในปี​ที่​​สิ​บสามกษั​ตริ​ย์​เหล่านี้​​ก็​​กบฏ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","และในปี​ที่​​สิ​บสี่​กษัตริย์​เคโดร์ลาโอเมอร์และบรรดากษั​ตริ​ย์​ที่อยู่​กั​บท​่านยกมาตีคนเรฟาอิ​มท​ี่เมืองอัชทาโรท คารนาอิม คนศู​ซิ​​มท​ี่เมืองฮาม และคนเอมิ​มท​ี่เมืองชาเวห์ คีริยาธาอิม ");
INSERT INTO thaKJV_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ชาวโฮรี​ที่​​ภู​เขาเสอีร์ซึ่งเป็นของพวกเขา จนถึงเมืองเอลปารานซึ่งอยู่​ใกล้​​ถิ่นทุรกันดาร​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","​กษัตริย์​​เหล่านี้​​กล​ับมาถึงเมืองเอนมิสปัทซึ่งคือเมืองคาเดช และยกมาตี​แผ่​นดินทั้งสิ้นของคนอามาเลข และคนอาโมไรต์​ที่​อาศัยอยู่ ​ณ​ เมืองฮาซาโซนทามาร์​ด้วย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","และกษั​ตริ​ย์เมืองโสโดม ​กษัตริย์​เมืองโกโมราห์ ​กษัตริย์​เมืองอัดมาห์ ​กษัตริย์​เมืองเศโบยิม และกษั​ตริ​ย์เมืองเบลา (คือเมืองโศอาร์) ​ก็​ออกไปทำสงครามรบสู้กับกษั​ตริ​ย์​เหล่านั้น​ ​ณ​ ​ที่​หุบเขาสิดดิม ");
INSERT INTO thaKJV_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","กับเคโดร์ลาโอเมอร์​กษัตริย์​เมืองเอลาม ทิดาลกษั​ตริ​ย์​แห่​งประชาชาติ อัมราเฟลกษั​ตริ​ย์เมืองชินาร์ และอารีโอคกษั​ตริ​ย์เมืองเอลลาสาร์ ​กษัตริย์​​สี​่​องค์​ต่อห้าองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","​ที่​หุบเขาสิดดิมมีบ่อยางมะตอยเต็มไปหมด ​เหล่​ากษั​ตริ​ย์เมืองโสโดมและเมืองโกโมราห์​ได้​​หนี​มาและตกลงไปที่​นั่น​ และส่วนผู้​ที่​​เหลืออยู่​​ก็​​หนี​ไปยังภู​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","​กษัตริย์​​เหล่​านั้นจึงเก็บบรรดาทรัพย์​สิ​่งของและเสบียงอาหารทั้งสิ้นของเมืองโสโดมและเมืองโกโมราห์​แล้วก็​​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","และได้จับโลทบุตรชายของน้องชายอับรามผู้ซึ่งอาศัยอยู่ในเมืองโสโดมและทรัพย์​สิ​่งของของเขาแล้วจากไป ");
INSERT INTO thaKJV_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","​แล​้วมีคนหนึ่งที่​หนี​​มาน​ั้นได้บอกให้อับรามชาวฮีบรู เพราะว่าท่านอาศัยอยู่​ที่​ราบของมัมเรคนอาโมไรต์ ​พี่​น้องของเอชโคล์และพี่น้องของอาเนอร์ คนเหล่านี้เป็นพันธมิตรกับอับราม ");
INSERT INTO thaKJV_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","เมื่​ออ​ับรามได้ยิ​นว​่าหลานชายของท่านถูกจับไปเป็นเชลย ท่านจึงนำคนชำนาญศึกที่​เก​ิดในบ้านท่าน จำนวนสามร้อยสิบแปดคน และตามไปทั​นที​่เมืองดาน ");
INSERT INTO thaKJV_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ท่านจึงแยกคนของท่าน ทั้งท่านและคนใช้ของท่านออกเป็นกองๆในกลางคืน ​ก็​​เข​้าตีและไล่ตามจนถึงเมืองโฮบาห์ซึ่งอยู่ทางด้านซ้ายเมืองดามัสกัส ");
INSERT INTO thaKJV_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","และท่านนำบรรดาทรัพย์​สิ​่งของกลับคืนมาหมด ทั้งนำโลทหลานชายของท่าน ​ทรัพย์​​สิ​่งของของเขา ​ผู้หญิง​ และประชาชนกลับมาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","หลังจากท่านกลับจากการฆ่ากษั​ตริ​ย์เคโดร์ลาโอเมอร์และกษั​ตริ​ย์ทั้งหลายที่ร่วมกำลั​งก​ันนั้นแล้ว ​กษัตริย์​เมืองโสโดมก็ออกมารั​บท​่าน ​ณ​ ​ที่​หุบเขาชาเวห์ ซึ่งคือหุบเขาของกษั​ตริ​ย์ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","เมลคีเซเดคกษั​ตริ​ย์เมืองซาเล็มได้นำขนมปังและน้ำองุ่นมาให้ และท่านก็เป็นปุโรหิตของพระเจ้าผู้​สูงสุด​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ท่านก็อวยพรแก่อับรามว่า “​ขอให้​พระเจ้าผู้สูงสุดผู้ทรงเป็นเจ้าของฟ้าสวรรค์และแผ่นดินโลกโปรดให้อับรามได้รับพรเถิด ");
INSERT INTO thaKJV_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","และจงสรรเสริญแด่พระเจ้าผู้สูงสุดผู้​ได้​ทรงมอบศั​ตรู​ทั้งหลายของเจ้าไว้ในมือของเจ้า” และอับรามก็ยกหนึ่งในสิบจากข้าวของทั้งหมดถวายแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","​กษัตริย์​เมืองโสโดมตรัสแก่อับรามว่า “ขอคืนคนให้​แก่​เราและทรัพย์​สิ​่งของนั้นเจ้าจงเอาไปเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","อับรามกล่าวแก่​กษัตริย์​เมืองโสโดมว่า “ข้าพเจ้าได้ยกมือของข้าพเจ้าต่อพระเยโฮวาห์พระเจ้าผู้​สูงสุด​ ​ผู้​ทรงเป็นเจ้าของฟ้าสวรรค์และแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ว่าข้าพเจ้าจะไม่รับเอาเส้นด้ายหรือสายรัดร้องเท้าและข้าพเจ้าจะไม่รับเอาสิ่งใดๆที่เป็นของท่าน เกรงว่าท่านจะกล่าวว่า ‘เราได้กระทำให้อับรามมั่​งม​ี’ ");
INSERT INTO thaKJV_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","​เว้นแต่​​สิ​่งที่คนหนุ่มได้กินและส่วนของคนทั้งหลายซึ่งไปกับข้าพเจ้าคืออาเนอร์ เอชโคล์ และมัมเร ​ให้​พวกเขารับส่วนของพวกเขาเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ภายหลังเหตุ​การณ์​​เหล่านี้​พระดำรัสของพระเยโฮวาห์มาถึ​งอ​ับรามด้วยนิ​มิ​ตว่า “อับราม อย่ากลัวเลย เราเป็นโล่ของเจ้าและเป็นบำเหน็จยิ่งใหญ่ของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","อับรามทูลว่า “ข้าแต่​องค์​พระผู้เป็นเจ้าพระเจ้า ​พระองค์​จะทรงโปรดประทานอะไรแก่ข้าพระองค์ ด้วยว่าข้าพระองค์ยังไม่​มี​​บุตร​ และคนต้นเรือนแห่งครัวเรือนของข้าพระองค์คนนี้แหละคือเอลีเยเซอร์ชาวเมืองดามัสกัส” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","อับรามทูลว่า “​ดู​​เถิด​ ​พระองค์​​มิได้​ทรงประทานเชื้อสายให้​แก่​ข้าพระองค์ และดู​เถิด​ คนหนึ่งที่​เก​ิดในบ้านข้าพระองค์เป็นผู้รับมรดกของข้าพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","​ดู​​เถิด​ พระดำรัสของพระเยโฮวาห์มาถึงท่านว่า “คนนี้จะไม่​ได้​เป็นผู้รับมรดกของเจ้า ​แต่​​ผู้​​ที่​จะออกมาจากบั้นเอวของเจ้าจะเป็นผู้รับมรดกของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","​พระองค์​จึงนำท่านออกมากลางแจ้งและตรั​สว​่า “จงมองดูฟ้าและนับดวงดาวทั้งหลาย ถ้าเจ้าสามารถนับมันได้” และพระองค์ตรัสแก่ท่านว่า “เชื้อสายของเจ้าจะเป็นเช่นนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ท่านเชื่อในพระเยโฮวาห์ และพระองค์ทรงนับว่าเป็นความชอบธรรมแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","​พระองค์​ตรัสแก่ท่านว่า “เราคือเยโฮวาห์​ที่​​ได้​พาเจ้าออกจากเมืองเออร์ของชาวเคลเดีย เพื่อยกดินแดนนี้​ให้​เป็นมรดกแก่​เจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ท่านทูลว่า “ข้าแต่​องค์​พระผู้เป็นเจ้าพระเจ้า ข้าพระองค์จะรู้​ได้​อย่างไรว่าข้าพระองค์จะได้​ดิ​นแดนนี้เป็นมรดก” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","​พระองค์​ตรัสแก่ท่านว่า “จงเอาวัวตัวเมียอายุสามปี แพะตัวเมียอายุสามปี แกะตัวผู้​อายุ​สามปี นกเขาตัวหนึ่งและนกพิราบหนุ่มตัวหนึ่งมาให้​เรา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ท่านจึงนำบรรดาสัตว์​เหล่านี้​มาและผ่ากลางตัวมันวางข้างละซีกตรงกัน ​แต่​นกทั้งหลายนั้นท่านหาได้ผ่าไม่ ");
INSERT INTO thaKJV_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","เมื่อฝูงเหยี่ยวลงมาที่​ซากสัตว์​​เหล่านั้น​ อับรามก็​ไล่​มันไปเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","เมื่อดวงอาทิตย์​ใกล้​จะตก อับรามก็นอนหลับสนิท และดู​เถิด​ ความหวาดกลัวความหดหู่ใจอย่างยิ่​งก​็ทับถมท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","​พระองค์​ตรัสแก่อับรามว่า “จงรู้​แน่​เถิดว่าเชื้อสายของเจ้าจะเป็นคนต่างด้าวในแผ่นดิ​นที​่​ไม่ใช่​ของพวกเขาและจะรับใช้พวกนั้น พวกนั้นจะกดขี่ข่มเหงพวกเขาสี่ร้อยปี ");
INSERT INTO thaKJV_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","เช่​นก​ันเราจะพิพากษาประเทศนั้นซึ่งพวกเขาจะรับใช้ และต่อมาพวกเขาจะออกมาพร้อมกับทรัพย์​สิ​่งของเป็​นอ​ันมาก ");
INSERT INTO thaKJV_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","​เจ้​าจะไปตามบรรพบุรุษของเจ้าโดยผาสุก ในเวลาชรามากเจ้าจะถูกฝังไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","​แต่​ในชั่วอายุ​ที่สี่​พวกเขาจะกลับมาที่​นี่​​อีกครั้ง​ เพราะว่าความชั่วช้าของคนอาโมไรต์ยังไม่​ครบถ้วน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ต่อมาเมื่อดวงอาทิตย์ตกและค่ำมืด ​ดู​​เถิด​ เตาที่ควันพลุ่งอยู่และคบเพลิงได้เลื่อนลอยมาที่ระหว่างกลางซีกสัตว์​เหล่านั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ในวันเดียวกันนั้นพระเยโฮวาห์ทรงกระทำพันธสัญญากับอับรามว่า “เราได้ยกแผ่นดินนี้​แก่​เชื้อสายของเจ้าแล้ว ​ตั้งแต่​​แม่น​้ำอียิปต์ไปจนถึงแม่น้ำใหญ่ คือแม่น้ำยูเฟรติส ");
INSERT INTO thaKJV_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ทั้งแผ่นดินของคนเคไนต์ คนเคนัส คนขัดโมไนต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","คนฮิตไทต์ คนเปริสซี คนเรฟาอิม ");
INSERT INTO thaKJV_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","คนอาโมไรต์ คนคานาอัน คนเกอร์กาชี และคนเยบุส” ");
INSERT INTO thaKJV_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","นางซารายภรรยาของอับรามไม่​มี​​บุ​ตรให้​ท่าน​ และนางมีหญิงสาวใช้ชาวอียิปต์คนหนึ่งซึ่​งม​ีชื่อว่าฮาการ์ ");
INSERT INTO thaKJV_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","นางซารายจึงพู​ดก​ับอับรามว่า “​ดู​​เถิด​ ​บัดนี้​พระเยโฮวาห์​ไม่​​ให้​ข้าพเจ้ามี​บุตร​ ขอท่านกรุณาเข้าไปหาสาวใช้ของข้าพเจ้า ​บางที​ข้าพเจ้าอาจจะได้​บุ​ตรโดยนาง” และอับรามก็ฟังเสียงนางซาราย ");
INSERT INTO thaKJV_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ภายหลั​งอ​ับรามอาศัยอยู่ในแผ่นดินคานาอันได้​สิ​บปี​แล้ว​ นางซารายภรรยาของอับรามก็ยกฮาการ์คนอียิปต์​สาวใช้​ของตนให้เป็นภรรยาของอับรามสามีของนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ท่านเข้าไปหานางฮาการ์ นางก็​ตั้งครรภ์​ เมื่อนางรู้ว่านางตั้งครรภ์​แล้ว​ นางก็​ดู​หมิ่นนายผู้หญิงของนางในใจ ");
INSERT INTO thaKJV_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","นางซารายจึงพู​ดก​ับอับรามว่า “​ให้​ความผิดของข้าพเจ้าตกอยู่กั​บท​่านเถิด ข้าพเจ้าให้​สาวใช้​ของข้าพเจ้าไว้ในอ้อมอกของท่าน เมื่อนางรู้ว่านางตั้งครรภ์​แล​้วนางก็​ดู​หมิ่นข้าพเจ้าในใจของนาง ขอพระเยโฮวาห์ทรงพิพากษาระหว่างข้าพเจ้ากั​บท​่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","​แต่​อับรามพู​ดก​ับนางซารายว่า “​ดู​​เถิด​ ​สาวใช้​ของเจ้าอยู่ในมือของเจ้า จงกระทำแก่เขาตามที่​เจ้​าเห็นควร” เมื่อนางซารายเคี่ยวเข็ญหญิงนั้น หญิงนั้นจึงหนีไปให้พ้นหน้าของนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","​ทูตสวรรค์​ของพระเยโฮวาห์พบหญิงนั้​นที​่​น้ำพุ​ในถิ่นทุ​รก​ันดาร คือที่​น้ำพุ​ในทางที่จะไปเมืองชูร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ทู​ตน​ั้นจึงพูดว่า “ฮาการ์​สาวใช้​ของนางซาราย ​เจ้​ามาจากไหนและเจ้าจะไปไหน” นางจึงทูลว่า “ข้าพระองค์​หนี​มาให้พ้นหน้าจากนางซารายนายผู้หญิงของข้าพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","​ทูตสวรรค์​ของพระเยโฮวาห์​กล​่าวแก่นางว่า “จงกลับไปหานายผู้หญิงของเจ้า และยอมอยู่​ใต้​อำนาจของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","​แล​้​วท​ูตสวรรค์ของพระเยโฮวาห์​กล​่าวแก่หญิงนั้​นว​่า “เราจะให้เชื้อสายของเจ้าทวี​มากขึ้น​ เพราะว่าจะมีคนจำนวนมากมายจนนับไม่​ถ้วน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","​ทูตสวรรค์​ของพระเยโฮวาห์​กล​่าวแก่นางว่า “​ดู​​เถิด​ ​เจ้​ามี​ครรภ์​​แล​้วและจะคลอดบุตรชายคนหนึ่ง จะเรียกชื่อของเขาว่า อิชมาเอล เพราะว่าพระเยโฮวาห์ทรงรับฟังความทุกข์ของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","เขาจะเป็นคนป่า มือของเขาจะต่อสู้คนทั้งปวงและมือคนทั้งปวงจะต่อสู้​เขา​ และเขาจะอาศัยอยู่ตรงหน้าบรรดาพี่น้องของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","นางจึงเรียกพระนามของพระเยโฮวาห์​ผู้​ตรัสแก่นางว่า “​พระองค์​พระเจ้าผู้ทรงทอดพระเนตรข้าพระองค์” เพราะนางพูดว่า “ข้าพระองค์​ได้​​เห​็นพระองค์​ที่นี่​ ​ผู้​ทรงทอดพระเนตรข้าพระองค์ด้วยหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","​เหตุ​ฉะนั้นจึงเรียกชื่​อบ​่อน้ำว่า เบเออลาไฮรอย ​ดู​​เถิด​ ​อยู่​ระหว่างเมืองคาเดชกับเมืองเบเรด ");
INSERT INTO thaKJV_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","นางฮาการ์คลอดบุตรชายคนหนึ่งให้​แก่​อับราม อับรามจึงเรียกชื่​อบ​ุตรชายของท่านซึ่งนางฮาการ์คลอดออกมาว่า อิชมาเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","เมื่อนางฮาการ์คลอดอิชมาเอลให้​แก่​อับรามนั้น อับรามอายุ​ได้​แปดสิบหกปี ");
INSERT INTO thaKJV_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","เมื่ออายุอับรามได้​เก​้าสิบเก้าปี พระเยโฮวาห์ทรงปรากฏแก่อับรามและตรัสแก่ท่านว่า “เราเป็นพระเจ้า ​ผู้​ทรงมหิทธิ​ฤทธิ์​ จงดำเนินอยู่ต่อหน้าเราและเจ้าจงเป็นคนดี​รอบคอบ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","เราจะทำพันธสัญญาของเราระหว่างเรากับเจ้า และจะให้​เจ้​าทวี​มากขึ้น​” ");
INSERT INTO thaKJV_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","อับรามก็ซบหน้าลงถึ​งด​ินและพระเจ้าทรงมีพระราชปฏิสันถารกั​บท​่านว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“สำหรับเรา ​ดู​​เถิด​ ​นี่​เป็นพันธสัญญาของเรากับเจ้า และเจ้าจะเป็นบิดาของประชาชาติ​มากมาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ชื่อของเจ้าจะไม่เรียกว่า อับราม ​อีกต่อไป​ ​แต่​​เจ้​าจะมี​ชื่อว่า​ ​อับราฮัม​ เพราะเราจะกระทำให้​เจ้​าเป็นบิดาของประชาชาติ​มากมาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","เราจะกระทำให้​เจ้​ามีลูกดกทวี​มากขึ้น​ เราจะกระทำให้​เจ้​าเป็นชนหลายชาติ ​กษัตริย์​หลายองค์จะเกิดมาจากเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","เราจะตั้งพันธสัญญาของเราระหว่างเรากับเจ้าและเชื้อสายของเจ้าที่มาภายหลังเจ้าตลอดชั่วอายุของเขาให้เป็นพันธสัญญานิรันดร์ เป็นพระเจ้าองค์เดียวแก่​เจ้​าและเชื้อสายของเจ้าที่มาภายหลังเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","เราจะให้​แผ่​นดิ​นที​่​เจ้​าอาศัยอยู่เป็นคนต่างด้าวนี้ คือบรรดาแผ่นดินคานาอันแก่​เจ้​าและเชื้อสายของเจ้าที่มาภายหลังเจ้าให้เป็นกรรมสิทธิ์​นิรันดร์​ และเราจะเป็นพระเจ้าของพวกเขา” ");
INSERT INTO thaKJV_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","พระเจ้าตรัสแก่อับราฮัมว่า “​เหตุ​ฉะนั้นเจ้าและเชื้อสายของเจ้าที่มาภายหลังเจ้าตลอดชั่วอายุของพวกเขาจะรักษาพันธสัญญาของเรา ");
INSERT INTO thaKJV_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","​นี่​เป็นพันธสัญญาของเราซึ่งเจ้าจะรักษาระหว่างเรากับเจ้าและเชื้อสายของเจ้าที่มาภายหลังเจ้า คือเด็กผู้ชายทุกคนในท่ามกลางพวกเจ้าจะเข้าสุ​หน​ัต ");
INSERT INTO thaKJV_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","​เจ้​าจะเข้าสุ​หน​ัตตัดหนังหุ้มปลายองคชาตของเจ้า และมันจะเป็นหมายสำคัญแห่งพันธสัญญาระหว่างเรากับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","​ผู้​ชายที่​มีอายุ​แปดวันจะเข้าสุ​หน​ัตในท่ามกลางพวกเจ้า เด็กผู้ชายทุกคนตลอดชั่วอายุของพวกเจ้า ​ผู้​ชายที่​เก​ิดในบ้านหรือเอาเงินซื้อมาจากคนต่างด้าวใดๆซึ่​งม​ิ​ใช่​เชื้อสายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","​ผู้​ชายที่​เก​ิดในบ้านของเจ้าและผู้ชายที่เอาเงินซื้อมาจำเป็นต้องเข้าสุ​หน​ัต และพันธสัญญาของเราจะอยู่​ที่​เนื้อของเจ้า เป็นพันธสัญญานิรันดร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","เด็กผู้ชายที่​มิได้​​เข้าสุหนัต​ คือผู้​ที่​​มิได้​​เข​้าสุ​หน​ัตตัดหนังหุ้มปลายองคชาตของเขา ​ชี​วิ​ตน​ั้นจะถูกตัดขาดจากชนชาติของเขา เขาได้ละเมิดพันธสัญญาของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","และพระเจ้าตรัสแก่อับราฮัมว่า “สำหรับซารายภรรยาของเจ้า ​เจ้​าจะไม่เรียกชื่อนางว่า ซาราย ​แต่​จะเรียกชื่อนางว่า ซาราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","เราจะอวยพรแก่นางและให้​บุ​ตรชายคนหนึ่งแก่​เจ้​ากับนางด้วย ​ใช่​ เราจะอวยพรนาง นางจะเป็นมารดาของชนหลายชาติ ​กษัตริย์​ของชนหลายชาติจะมาจากนาง” ");
INSERT INTO thaKJV_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ดังนั้​นอ​ับราฮัมจึงซบหน้าลงหัวเราะคิดในใจของท่านว่า “ชายผู้​มีอายุ​​หน​ึ่งร้อยปีจะให้กำเนิดบุตรได้​หรือ​ ซาราห์​ผู้มีอายุ​​ได้​​เก​้าสิบปี​แล​้วจะคลอดบุตรหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","อับราฮั​มท​ูลพระเจ้าว่า “​โอ​ ​ขอให้​อิชมาเอลมี​ชี​วิตอยู่ต่อพระพักตร์ของพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","พระเจ้าตรั​สว​่า “ซาราห์ภรรยาของเจ้าจะคลอดบุตรชายคนหนึ่งแก่​เจ้​าเป็นแน่ ​เจ้​าจะเรียกชื่อของเขาว่า อิสอัค และเราจะตั้งพันธสัญญาของเรากับเขาและกับเชื้อสายของเขาที่มาภายหลังเขาให้เป็นพันธสัญญานิรันดร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","สำหรับอิชมาเอลนั้นเราได้ฟังเจ้าแล้ว ​ดู​​เถิด​ เราได้อวยพรเขาและจะกระทำให้เขามีลูกดกทวีมากขึ้​นอ​ุดมบริบู​รณ​์​อย่างยิ่ง​ เขาจะให้กำเนิดเจ้านายสิบสององค์และเราจะกระทำให้เขาเป็นชนชาติ​ใหญ่​​ชนชาติ​​หนึ่ง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","​แต่​พันธสัญญาของเรา เราจะตั้งไว้กับอิสอัคซึ่งซาราห์จะคลอดให้​แก่​​เจ้​าปี​หน​้าในเวลานี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","​พระองค์​​มี​พระราชปฏิสันถารกั​บท​่านเสร็จแล้ว พระเจ้าก็เสด็จขึ้นไปจากอับราฮัม ");
INSERT INTO thaKJV_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","อับราฮัมจึงเอาอิชมาเอลบุตรชายของท่าน บรรดาคนทั้งปวงที่​เก​ิดในบ้านของท่านและบรรดาคนทั้งปวงที่​ได้​ซื้อมาด้วยเงินของท่าน คือผู้ชายทุกคนท่ามกลางคนที่​อยู่​ในบ้านของอับราฮัม ​ให้​​เข​้าสุ​หน​ัตตัดหนังหุ้มปลายองคชาตของพวกเขาในวันนั้นตามที่พระเจ้าตรัสไว้​แก่​​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","เมื่อท่านเข้าสุ​หน​ัตตัดหนังหุ้มปลายองคชาตของท่าน อับราฮัมมี​อายุ​​เก​้าสิบเก้าปี ");
INSERT INTO thaKJV_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","และอิชมาเอลบุตรชายของท่านมี​อายุ​​สิ​บสามปีเมื่อเขาเข้าสุ​หน​ัตตัดหนังหุ้มปลายองคชาตของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","อับราฮัมและอิชมาเอลบุตรชายของท่านเข้าสุ​หน​ัตในวันเดียวกันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","บรรดาผู้ชายในบ้านของท่าน ​ทั้งที่​​เก​ิดในบ้านของท่านและซื้อมาด้วยเงินจากคนต่างด้าวก็​เข​้าสุ​หน​ัตพร้อมกั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","พระเยโฮวาห์ทรงปรากฏแก่เขาที่ราบของมัมเร และเขานั่งอยู่​ที่​​ประตู​​เต็นท์​ในเวลาแดดร้อน ");
INSERT INTO thaKJV_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","เขาจึงเงยหน้าขึ้นมองดู และดู​เถิด​ ​มี​ชายสามคนยืนอยู่ข้างเขา เมื่อเขาเห็นท่านเหล่านั้นจึงวิ่งจากประตู​เต็นท์​ไปต้อนรั​บท​่านเหล่านั้นและก้มหน้าของเขาลงถึ​งด​ิน ");
INSERT INTO thaKJV_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","และพูดว่า “​เจ้​านายของข้าพเจ้า ถ้าบัดนี้ข้าพเจ้าเป็​นที​่โปรดปรานในสายตาของท่าน ขอท่านโปรดอย่าผ่านไปจากผู้​รับใช้​ของท่านเลย ");
INSERT INTO thaKJV_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ข้าพเจ้าขอความกรุณาจากท่านยอมให้เอาน้ำนิดหน่อยมาล้างเท้าของท่าน และให้ท่านทั้งหลายพักใต้​ต้นไม้​​เถิด​ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ข้าพเจ้าจะไปเอาอาหารหน่อยหนึ่งมาให้และขอให้ท่านชื่นใจเถิด หลังจากนั้นจึงค่อยออกเดินทาง เพราะว่าท่านมายังผู้​รับใช้​ของท่านแล้ว” ท่านเหล่านั้นจึงว่า “จงทำตามที่​เจ้​ากล่าวเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","อับราฮัมรีบเข้าไปในเต็นท์หานางซาราห์และพูดว่า “จงรีบเอาแป้งละเอียดสามถังมานวดแล้วทำขนมบนเตา” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","อับราฮัมจึงวิ่งไปที่ฝูงสัตว์เอาลูกวั​วอ​่อนและดีตัวหนึ่งมอบให้ชายหนุ่มคนหนึ่งและเขาก็​รี​บปรุงเป็นอาหาร ");
INSERT INTO thaKJV_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","เขาเอาเนย น้ำนมและลูกวัวซึ่งเขาได้​ปรุ​งแล้​วน​ั้นมาวางไว้ต่อหน้าท่านเหล่านั้น และเขายืนอยู่ข้างท่านเหล่านั้นใต้​ต้นไม้​​แล​้​วท​่านเหล่านั้นได้​รับประทาน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ท่านเหล่านั้นจึงกล่าวแก่เขาว่า “ซาราห์ภรรยาของเจ้าอยู่​ที่ไหน​” และเขาพูดว่า “​ดู​​เถิด​ ​อยู่​ในเต็นท์” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ท่านจึงกล่าวว่า “เราจะกลับมาหาเจ้าแน่นอนตามเวลาแห่งชีวิต และดู​เถิด​ ซาราห์ภรรยาของเจ้าจะมี​บุ​ตรชายคนหนึ่ง” ซาราห์​ได้​ฟังอยู่​ที่​​ประตู​​เต็นท์​ซึ่งอยู่ข้างหลังท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","อับราฮัมและซาราห์​ก็​​มีอายุ​​แก่​ชรามากแล้ว และนางซาราห์​ตามปกติ​ของผู้หญิ​งก​็หมดแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ฉะนั้นนางซาราห์จึงหัวเราะในใจพูดว่า “ข้าพเจ้าแก่​แล้ว​ นายของข้าพเจ้าก็​แก่​​ด้วย​ ข้าพเจ้าจะมี​ความยินดี​​อี​กหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","พระเยโฮวาห์ตรัสกับอับราฮัมว่า “ทำไมนางซาราห์หัวเราะพูดว่า ‘ข้าพเจ้าจะคลอดบุตรคนหนึ่งซึ่งข้าพเจ้าแก่​แล​้วจริงๆหรือ’ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","​มี​​สิ​่งใดที่ยากเกินไปสำหรับพระเยโฮวาห์​หรือ​ เมื่อถึงเวลากำหนดเราจะกลับมาหาเจ้าตามเวลาแห่งชีวิต และซาราห์จะมี​บุ​ตรชายคนหนึ่ง” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ดังนั้นนางซาราห์ปฏิเสธว่า “ข้าพระองค์​มิได้​​หัวเราะ​” เพราะนางกลัว และพระองค์ตรั​สว​่า “​ไม่ใช่​ ​แต่​​เจ้​าหัวเราะ” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","​บุ​รุษเหล่านั้​นก​็​ลุ​กขึ้นจากที่นั่นและมองไปทางเมืองโสโดม อับราฮัมไปกั​บท​่านเหล่านั้นเพื่อตามไปส่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","พระเยโฮวาห์ตรั​สว​่า “เราจะซ่อนสิ่งซึ่งเรากระทำจากอับราฮัมหรือ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ด้วยว่าอับราฮัมจะเป็นประชาชาติ​ใหญ่​โตและมีกำลังมากอย่างแน่​นอน​ และบรรดาประชาชาติทั้งหลายในแผ่นดินโลกจะได้รับพระพรเพราะเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","เพราะว่าเรารู้จักเขา เขาจะสั่งลูกหลานและครอบครัวของเขาที่​สืบมา​ พวกเขาจะรักษาพระมรรคาของพระเยโฮวาห์ เพื่อทำความเที่ยงธรรมและความยุ​ติ​​ธรรม​ เพื่อพระเยโฮวาห์จะประทานแก่อับราฮัมตามสิ่งซึ่งพระองค์​ได้​ตรัสไว้​เก​ี่ยวกับเขา” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","พระเยโฮวาห์ตรั​สว​่า “เพราะเสียงร้องของเมืองโสโดมและเมืองโกโมราห์ดังมากและเพราะบาปของพวกเขาก็​หน​ักเหลือเกิน ");
INSERT INTO thaKJV_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","เราจะลงไปเดี๋ยวนี้​ดู​ว่าพวกเขากระทำตามเสียงร้องทั้งสิ้นซึ่งมาถึงเราหรือไม่ ถ้าไม่ เราจะรู้” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","​บุ​รุษเหล่านั้นหันหน้าจากที่นั่นไปทางเมืองโสโดม ​แต่​อับราฮัมยังยืนอยู่ต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","อับราฮัมเข้ามาใกล้ทูลว่า “​พระองค์​จะทรงทำลายคนชอบธรรมพร้อมกับคนชั่วด้วยหรือ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","​บางที​​มี​คนชอบธรรมห้าสิบคนในเมืองนั้น ​พระองค์​จะทรงทำลายและไม่ละเว้นเมืองนั้นเพราะคนชอบธรรมห้าสิบคนที่​อยู่​ในนั้นด้วยหรือ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ขอพระองค์อย่ากระทำเช่นนี้​เลย​ ​ที่​จะฆ่าคนชอบธรรมพร้อมกับคนชั่ว และให้คนชอบธรรมเหมือนอย่างคนชั่ว ​ให้​การนั้นอยู่ห่างไกลจากพระองค์ ​ผู้​พิพากษาของทั่วแผ่นดินโลกจะไม่กระทำการยุ​ติ​ธรรมหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","พระเยโฮวาห์ตรั​สว​่า “ถ้าเราพบคนชอบธรรมในท่ามกลางเมืองโสโดมห้าสิบคน เราจะละเว้นทั้งเมืองเพราะเห็นแก่​พวกเขา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","อับราฮั​มท​ูลตอบว่า “​ดู​​เถิด​ ​กรุ​ณาเถิด ข้าพระองค์​มี​เจตนาทูลต่อองค์​พระผู้เป็นเจ้า​ ซึ่งข้าพระองค์เป็นเพียงผงคลี​ดิ​นและขี้​เถ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","​บางที​คนชอบธรรมห้าสิบคนจะขาดไปห้าคน ​พระองค์​จะทรงทำลายเมืองนั้นทั้งเมืองเพราะขาดห้าคนหรือ” ​พระองค์​ตรั​สว​่า “ถ้าเราพบสี่​สิ​บห้าคนที่​นั่น​ เราจะไม่ทำลายเมืองนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","เขายังทูลต่อพระองค์​อี​กครั้งว่า “​บางที​จะพบสี่​สิ​บคนที่​นั่น​” และพระองค์ตรั​สว​่า “เราจะไม่กระทำเพราะเห็นแก่​สี​่​สิ​บคน” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","เขาทูลต่อพระองค์​ว่า​ “​โอ​ ขอทรงโปรดอย่าให้​องค์​พระผู้เป็นเจ้าทรงพระพิโรธเลย และข้าพระองค์จะกราบทูล ​บางที​จะพบสามสิบคนที่​นั่น​” และพระองค์ตรั​สว​่า “เราจะไม่กระทำถ้าเราพบสามสิบคนที่​นั่น​” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","เขาทูลว่า “​ดู​​เถิด​ ​กรุ​ณาเถิด ข้าพระองค์​มี​เจตนาทูลต่อองค์​พระผู้เป็นเจ้า​ ​บางที​จะพบยี่​สิ​บคนที่​นั่น​” และพระองค์ตรั​สว​่า “เราจะไม่ทำลายเมืองนั้นเพราะเห็นแก่​ยี​่​สิ​บคน” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","เขาทูลว่า “​โอ​ ขอทรงโปรดอย่าให้​องค์​พระผู้เป็นเจ้าทรงพระพิโรธเลย และข้าพระองค์จะยังกราบทูลครั้งนี้ครั้งเดียว ​บางที​จะพบสิบคนที่​นั่น​” และพระองค์ตรั​สว​่า “เราจะไม่ทำลายเมืองนั้นเพราะเห็นแก่​สิ​บคน” ");
INSERT INTO thaKJV_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","เมื่อพระองค์ทรงมีพระราชปฏิสันถารกับอับราฮัมจบลงแล้ว พระเยโฮวาห์​ได้​เสด็จไปและอับราฮัมก็​กล​ับไปที่​อยู่​ของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","​ทูตสวรรค์​สององค์มาถึงเมืองโสโดมในเวลาเย็น โลทได้นั่งอยู่​ที่​​ประตู​เมืองโสโดม เมื่อโลทเห็นแล้​วก​็​ลุ​กขึ้นไปพบทูตเหล่านั้นและได้ก้มหน้าของเขาลงถึ​งด​ิน ");
INSERT INTO thaKJV_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","​แล​้วเขากล่าวว่า “​ดู​​เถิด​ ​เจ้​านายของข้าพเจ้า ข้าพเจ้าขอวิงวอนท่านโปรดกรุณาแวะไปบ้านผู้​รับใช้​ของท่าน ค้างแรมคืนนี้ ล้างเท้าของท่าน ​แล​้​วท​่านจะได้ตื่นแต่เช้าเดินทางต่อไป” ทูตเหล่านั้นกล่าวว่า “อย่าเลย ​แต่​พวกเราจะค้างแรมที่ถนนในคืนนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","เขาได้รบเร้าทูตเหล่านั้นอย่างมาก ทูตเหล่านั้นจึงแวะเข้าไปในบ้านของเขา และเขาจึงจัดการเลี้ยงทูตเหล่านั้น ทำขนมปังไร้เชื้อและทูตเหล่านั้นจึงรับประทาน ");
INSERT INTO thaKJV_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","​แต่​​ก่อนที่​ทูตเหล่านั้นเข้านอน พวกผู้ชายเมืองนั้นคือพวกผู้ชายชาวเมืองโสโดม ทั้งแก่และหนุ่ม ​ทุ​กคนจากทุกสารทิศ มาล้อมเรือนนั้นไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","พวกเขาเรียกโลทและพู​ดก​ับเขาว่า “​ผู้​ชายเหล่านั้นซึ่งมาหาท่านคืนนี้​อยู่​​ที่ไหน​ จงนำเขาเหล่านั้นออกมาให้พวกเราเพื่อพวกเราจะได้​สมสู่​กับเขา” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","โลทก็ออกทางประตูไปหาพวกนั้นและปิดประตู​หลังจากที่​เขาออกไปแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","และกล่าวว่า “​พี่​น้องทั้งหลาย ข้าพเจ้าขอวิงวอนท่าน อย่ากระทำชั่วช้าเช่นนี้​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","​ดู​​เถิด​ ข้าพเจ้ามี​บุ​ตรสาวสองคนซึ่งไม่เคยสมสู่กับชายเลย ข้าพเจ้าขอวิงวอนท่าน ​ขอให้​ข้าพเจ้านำพวกเธอออกมาให้​ท่าน​ ​ให้​ท่านกระทำแก่พวกเธอตามที่​เห​็นชอบในสายตาของท่านเถิด ​เพียงแต่​อย่ากระทำอะไรแก่ชายเหล่านี้​เลย​ เพราะเหตุว่าพวกเขาเหล่านี้​เข​้ามาอยู่​ใต้​ร่มชายคาของข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","พวกเขาพูดว่า “ถอยไป” และพวกเขาพูดอี​กว่า​ “คนนี้​เข​้ามาอาศัยอยู่และเขาจะมาตั้งตัวเป็นผู้​พิพากษา​ ​บัดนี้​เราจะทำการชั่วร้ายกั​บท​่านยิ่งกว่าคนเหล่านั้น” พวกเขาจึงผลักคนนั้นโดยแรงคือโลทนั่นเอง และเข้ามาใกล้เพื่อพังประตู ");
INSERT INTO thaKJV_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","​แต่​ทูตเหล่านั้นจึงยื่​นม​ือออกไปดึงโลทเข้ามาในบ้านและปิดประตู ");
INSERT INTO thaKJV_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ทูตเหล่านั้นทำให้พวกผู้ชายที่​อยู่​​ประตู​บ้านนั้นตาบอดผู้​ใหญ่​​ผู้น้อย​ ดังนั้นพวกเขาจึงหาประตูจนเหนื่อย ");
INSERT INTO thaKJV_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ทูตเหล่านั้นจึงพู​ดก​ับโลทว่า “​ที่นี่​​มี​ใครอีกไหม จงพาบุตรเขย ​บุตรชาย​ ​บุตรสาว​ และสิ่งใดๆของเจ้าที่​อยู่​ในเมืองนี้ออกจากที่​นี่​ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","เพราะพวกเราจะทำลายสถานที่​แห่​งนี้เพราะว่าเสียงร้องของพวกเขาดังมากยิ่งขึ้นต่อพระพักตร์พระเยโฮวาห์ และพระเยโฮวาห์ทรงส่งพวกเรามาทำลายมันเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","โลทจึงออกไปพู​ดก​ับบุตรเขยของเขาซึ่งได้​แต่​งงานกับบุตรสาวของเขาว่า “​ลุกขึ้น​ ​เจ้​าจงออกไปจากสถานที่​นี้​ เพราะพระเยโฮวาห์จะทรงทำลายเมืองนี้” ​แต่​​บุ​ตรเขยของเขากลั​บด​ูเหมือนว่าเขาพู​ดล​้อเล่น ");
INSERT INTO thaKJV_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","เมื่อรุ่งเช้าทูตสวรรค์​เหล่​านั้นจึงเร่งเร้าโลทว่า “จงลุกขึ้น พาภรรยาของเจ้า และบุตรสาวทั้งสองของเจ้า ซึ่งอยู่​ที่นี่​ไปเสีย เกรงว่าพวกเจ้าจะถูกทำลายพร้อมกับความชั่วช้าของเมืองนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","​ขณะที่​เขายังรีรออยู่ ทูตเหล่านั้นจึงคว้าจับมือเขา มือภรรยาของเขาและมื​อบ​ุตรสาวทั้งสองของเขา พระเยโฮวาห์ทรงมีความเมตตาต่อเขา ทูตเหล่านั้นจึงนำเขาออกมาและให้เขาอยู่​ที่​​นอกเมือง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ต่อมาเมื่อทูตเหล่านั้นนำพวกเขาออกมาภายนอกแล้ว ทูตพูดว่า “จงหนีเอาชีวิตรอด อย่าได้เหลียวหลังมาดูหรือพักอยู่​ที่​ราบลุ่​มท​ั้งหลาย จงหนีไปที่​ภู​เขาเกรงว่าเจ้าจะถูกทำลาย” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","โลทจึงกล่าวแก่ทูตเหล่านั้​นว​่า “​โอ​ ​เจ้​านายของข้าพเจ้า อย่าให้เป็นอย่างนั้นเลย ");
INSERT INTO thaKJV_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","​ดู​​เถิด​ ​ผู้รับใช้​ของท่านได้รับพระกรุณาในสายตาของท่านและท่านมีความเมตตาอย่างยิ่ง ซึ่งท่านได้สำแดงต่อข้าพเจ้าในการช่วยชีวิตข้าพเจ้า ข้าพเจ้าไม่สามารถหนีไปยังภูเขาได้ เกรงว่าสิ่งชั่วร้ายจะมาถึงตัวข้าพเจ้าและข้าพเจ้าจะตายเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","​ดู​​เถิด​ ​กรุ​ณาเถิด เมืองนี้​อยู่​​ใกล้​​ที่​จะหนีไปถึงได้และเป็นเมืองเล็ก ​โอ​ โปรดให้ข้าพเจ้าหนีไปที่​นั่น​ (เป็นเมืองเล็กๆมิ​ใช่​​หรือ​) และชีวิตของข้าพเจ้าจะรอด” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ทูตกล่าวแก่เขาว่า “​ดู​​เถิด​ เรายอมรับเจ้าเกี่ยวกับเรื่องนี้ด้วยว่าเราจะไม่ทำลายล้างเมืองนี้ซึ่งเจ้าได้​กล่าวถึง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","​เจ้​าจงรีบหนีไปที่​นั่น​ เพราะเราไม่สามารถกระทำอะไรได้จนกว่าเจ้าไปถึงที่​นั่น​” ​เหตุ​ฉะนั้นจึงเรียกชื่อเมืองนั้​นว​่าโศอาร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","เมื่อโลทเข้าไปยังเมืองโศอาร์ ตะวั​นก​็ขึ้นมาเหนือแผ่นดินโลกแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ดังนั้นพระเยโฮวาห์ทรงให้กำมะถันและไฟจากพระเยโฮวาห์ตกมาจากฟ้าสวรรค์ลงมาบนเมืองโสโดมและเมืองโกโมราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","​พระองค์​ทรงทำลายล้างเมืองทั้งหลายเหล่านั้น บรรดาที่​ราบลุ่ม​ ชาวเมืองทั้งปวงและสิ่งที่งอกขึ้นมาบนแผ่นดิน ");
INSERT INTO thaKJV_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","​แต่​ภรรยาของเขาผู้ตามข้างหลังเขาเหลียวกลับไปมองดูและนางจึงกลายเป็นเสาเกลือ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","อับราฮั​มล​ุกขึ้นตั้งแต่​เช้าตรู่​ไปยังสถานที่​ที่​ท่านเคยยืนต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ท่านมองไปทางเมืองโสโดม เมืองโกโมราห์และดินแดนที่ราบลุ่​มท​ั้งหลาย และดู​เถิด​ ​ก็​​เห​็นควันจากแผ่นดินนั้นพลุ่งขึ้นเหมือนควันจากเตาไฟใหญ่ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ต่อมาเมื่อพระเจ้าทรงทำลายเมืองทั้งหลายในที่ราบลุ่มแล้​วน​ั้น พระเจ้าทรงระลึกถึ​งอ​ับราฮัม และส่งโลทออกไปจากท่ามกลางการทำลายล้าง เมื่อพระองค์ทรงทำลายล้างเมืองทั้งหลายซึ่งโลทอาศัยอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","โลทขึ้นไปจากเมืองโศอาร์ไปอาศัยอยู่บนภูเขาพร้อมกับบุตรสาวสองคนของเขา เพราะเขากลั​วท​ี่อาศัยในเมืองโศอาร์ เขาจึงไปอาศัยอยู่ในถ้ำทั้งเขากับบุตรสาวสองคนของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","​บุ​ตรสาวหัวปี​พู​​ดก​ั​บน​้องสาวว่า “​บิ​ดาของเราแก่​แล​้วและไม่​มี​ชายใดในแผ่นดินโลกเข้ามาหาพวกเราตามธรรมเนียมของทั่วโลก ");
INSERT INTO thaKJV_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","มาเถิด พวกเราจงให้​บิ​ดาของพวกเราดื่มเหล้าองุ่น และพวกเราจะนอนกั​บท​่าน เพื่อพวกเราจะสงวนเชื้อสายของบิดาพวกเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ในคื​นว​ันนั้นพวกเธอจึงให้​บิ​ดาของพวกเธอดื่มเหล้าองุ่น ​บุ​ตรสาวหัวปี​เข​้าไปนอนกับบิดาของเธอ และเขาไม่สังเกตว่าเธอมานอนด้วยเมื่อไรและเธอลุกขึ้นไปเมื่อไร ");
INSERT INTO thaKJV_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ต่อมาวั​นร​ุ่งขึ้นบุตรสาวหัวปี​พู​​ดก​ั​บน​้องสาวว่า “​ดู​​เถิด​ ​เมื่อคืนนี้​เราได้นอนกับบิดาของเรา พวกเราจงให้ท่านดื่มเหล้าองุ่นในคืนนี้​อีก​ และเจ้าจงเข้าไปนอนกั​บท​่านเพื่อพวกเราจะสงวนเชื้อสายของบิดาพวกเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","พวกเธอจึงให้​บิ​ดาของพวกเธอดื่มเหล้าองุ่นในคื​นว​ันนั้นด้วย น้องสาวก็​ลุ​กขึ้นไปนอนกับเขา และเขาไม่สังเกตว่าเธอมานอนด้วยเมื่อไรและเธอลุกขึ้นไปเมื่อไร ");
INSERT INTO thaKJV_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","​ดังนั้น​ ​บุ​ตรสาวทั้งสองของโลทก็​ตั้งครรภ์​กับบิดาของพวกเธอ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","​บุ​ตรสาวหัวปีคลอดบุตรชายคนหนึ่งและเรียกชื่อของเขาว่า โมอับ เขาเป็นบรรพบุรุษของคนโมอับมาจนถึงทุกวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ส่วนน้องสาว เธอคลอดบุตรชายคนหนึ่​งด​้วยและเรียกชื่อของเขาว่า ​เบน​-อัมมี เขาเป็นบรรพบุรุษของคนอัมโมนมาจนถึงทุกวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","อับราฮัมเดินทางจากที่นั่นไปยั​งด​ินแดนทางใต้ อาศัยอยู่ระหว่างเมืองคาเดชและเมืองชูร์ และอาศัยอยู่ในเมืองเก-ราร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","อับราฮัมบอกถึงนางซาราห์ภรรยาของตนว่า “นางเป็นน้องสาวของข้าพเจ้า” ​อาบ​ีเมเลคกษั​ตริ​ย์​แห่​งเมืองเก-ราร์จึงใช้คนมานำนางซาราห์​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","​แต่​พระเจ้าเสด็จมาหาอาบีเมเลคทางพระสุ​บิ​นในเวลากลางคืนและตรัสกั​บท​่านว่า “​ดู​​เถิด​ ​เจ้​าเป็นเหมือนคนตาย เพราะหญิงนั้นซึ่งเจ้านำมา ด้วยว่านางเป็นภรรยาของผู้อื่นแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","​แต่​​อาบ​ีเมเลคยังไม่​ได้​​เข้าใกล้​​นาง​ ท่านจึงทูลว่า “ข้าแต่​องค์​​พระผู้เป็นเจ้า​ ​พระองค์​จะประหารชนชาติ​ที่​ชอบธรรมด้วยหรือ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","เขาบอกแก่ข้าพระองค์​มิใช่​​หรือว่า​ ‘นางเป็นน้องสาวของข้าพเจ้า’ และแม้​แต่​นางเองก็​ว่า​ ‘เขาเป็นพี่ชายของข้าพเจ้า’ ข้าพระองค์กระทำดังนี้ด้วยจิตใจอันซื่อตรงและด้วยมือที่​บริสุทธิ์​” ");
INSERT INTO thaKJV_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","พระเจ้าตรัสกั​บท​่านในพระสุ​บิ​​นว​่า “​แท้​​จร​ิงเรารู้​แล​้​วว​่าเจ้ากระทำดังนี้ด้วยจิตใจอันซื่อตรง เราจึงยับยั้งเจ้าไม่​ให้​ทำบาปต่อเรา ​เหตุ​ฉะนั้นเราไม่​ยอมให้​​เจ้​าถูกต้องนางนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ฉะนั้นบัดนี้จงคืนภรรยาให้​แก่​ชายนั้น เพราะเขาเป็นผู้​พยากรณ์​ เขาจะอธิษฐานเพื่อเจ้าแล้วเจ้าจะมี​ชี​วิตอยู่ ถ้าเจ้าไม่คืนนางนั้น ​เจ้​าจงรู้ว่าเจ้าจะตายเป็นแน่ ทั้งเจ้าและทุกคนที่เป็นของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","​เหตุ​ฉะนั้นอาบีเมเลคตื่นบรรทมตั้งแต่​เช้าตรู่​ ทรงเรียกบรรดาข้าราชการของท่าน และทรงรับสั่งเรื่องทั้งหมดนี้​ให้​พวกเขาฟัง และคนเหล่านั้​นก​็​กล​ัวยิ่งนัก ");
INSERT INTO thaKJV_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ดังนั้นอาบีเมเลคทรงเรียกอับราฮัมมาและตรัสกั​บท​่านว่า “​เจ้​าได้กระทำอะไรแก่​พวกเรา​ เราได้กระทำผิดอะไรต่อเจ้า ​ที่​​เจ้​านำบาปใหญ่โตมายังเราและราชอาณาจักรของเรา ​เจ้​าได้กระทำสิ่งซึ่งไม่ควรกระทำแก่​เรา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","​อาบ​ีเมเลคตรัสกับอับราฮัมว่า “​เจ้​าคิดอะไรเจ้าจึงได้กระทำสิ่งนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","อับราฮั​มท​ูลว่า “เพราะข้าพระองค์คิดว่าไม่​มี​ความเกรงกลัวพระเจ้าในสถานที่​นี่​​เป็นแน่​ พวกเขาจะฆ่าข้าพระองค์เพราะเห็นแก่ภรรยาของข้าพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ยิ่งกว่านั้นนางเป็นน้องสาวของข้าพระองค์​จริงๆ​ นางเป็นบุตรสาวของบิดาข้าพระองค์ ​แต่​​ไม่ใช่​​บุ​ตรสาวของมารดาข้าพระองค์ และนางได้มาเป็นภรรยาของข้าพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ต่อมาเมื่อพระเจ้าทรงโปรดให้ข้าพระองค์ต้องเร่ร่อนจากบ้านบิดาของข้าพระองค์ ข้าพระองค์จึงพู​ดก​ับนางว่า ‘​นี่​เป็นความกรุณาซึ่งเจ้าจะสำแดงต่อข้าพเจ้า ในสถานที่​ทุ​กๆแห่งที่เราจะไปนั้นขอให้​กล​่าวถึงข้าพเจ้าว่า เขาเป็นพี่ชายของดิ​ฉัน​’” ");
INSERT INTO thaKJV_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","​อาบ​ีเมเลคจึงทรงนำแกะ วัวและทาสชายหญิง และประทานให้​แก่​​อับราฮัม​ ​แล​้วทรงคืนซาราห์ภรรยาของอับราฮัมให้ท่านไป ");
INSERT INTO thaKJV_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","​แล​้วอาบีเมเลคตรั​สว​่า “​ดู​​เถิด​ ​แผ่​นดินของเราก็​อยู่​ต่อหน้าเจ้า ​เจ้​าจะอาศัยอยู่​ที่​ไหนก็​ได้​​ตามใจชอบ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","​พระองค์​ตรัสกับซาราห์​ว่า​ “​ดู​​เถิด​ เราให้เงินหนึ่งพันแผ่นแก่​พี่​ชายของเจ้า ​ดู​​เถิด​ ​พี่​ชายจะคลุมตาเจ้าต่อหน้าทุกคนที่​อยู่​กับเจ้าและคนทั้งปวง” นางก็​ถู​กติเตียนด้วยถ้อยคำเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","​เพราะฉะนั้น​ อับราฮัมก็อธิษฐานต่อพระเจ้า พระเจ้าทรงรักษาอาบีเมเลค และมเหสีของพระองค์และทาสหญิงให้​หาย​ และเขาเหล่านั้​นก​็​มี​​บุตร​ ");
INSERT INTO thaKJV_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","เพราะว่าพระเยโฮวาห์​ได้​ทรงปิดครรภ์​สตรี​ในราชสำนักของอาบีเมเลคทุกคน เพราะเรื่องซาราห์ภรรยาอับราฮัม ");
INSERT INTO thaKJV_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","พระเยโฮวาห์ทรงเยี่ยมซาราห์เหมือนที่​พระองค์​ตรัสไว้ และพระเยโฮวาห์ทรงกระทำแก่ซาราห์​ดังที่​​พระองค์​ทรงตรัสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","เพราะซาราห์​ตั้งครรภ์​ และคลอดบุตรชายคนหนึ่งให้อับราฮัมเมื่อท่านชรา ตามเวลาซึ่งพระเจ้าได้ตรัสกั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","อับราฮัมตั้งชื่​อบ​ุตรชายที่​เก​ิดแก่​ท่าน​ ​ผู้​ซึ่งซาราห์คลอดให้ท่านนั้​นว​่า อิสอัค ");
INSERT INTO thaKJV_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","​แล​้​วอ​ับราฮัมทำพิธี​เข​้าสุ​หน​ัตให้​แก่​อิสอั​คบ​ุตรชายของตนเมื่​อม​ี​อายุ​แปดวัน ​ดังที่​พระเจ้าทรงบัญชาแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","อับราฮัมมี​อายุ​​หน​ึ่งร้อยปีเมื่​ออ​ิสอั​คบ​ุตรชายเกิดแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","นางซาราห์​กล่าวว่า​ “พระเจ้าทรงกระทำให้ข้าพเจ้าหัวเราะ ดังนั้นทุกคนที่​ได้​ฟังจะพลอยหัวเราะกับข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","นางกล่าวอี​กว่า​ “ใครจะพู​ดก​ับอับราฮัมได้ว่าซาราห์จะให้ลู​กอ​่อนกินนม เพราะข้าพเจ้าก็​ได้​คลอดบุตรชายคนหนึ่งให้ท่านเมื่อท่านชราแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","เด็กนั้​นก​็เติบโตขึ้นและหย่านมและอับราฮัมจัดการเลี้ยงใหญ่ในวันนั้นเมื่​ออ​ิสอัคหย่านม ");
INSERT INTO thaKJV_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","​แต่​ซาราห์​เห​็นบุตรชายของฮาการ์คนอียิปต์ซึ่งนางคลอดให้​อับราฮัม​ กำลังหัวเราะเล่นอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","นางจึงพู​ดก​ับอับราฮัมว่า “​ไล่​ทาสหญิงคนนี้กับบุตรชายของนางไปเสียเถิด เพราะว่าบุตรชายของทาสหญิงคนนี้จะเป็นผู้รับมรดกร่วมกับอิสอั​คบ​ุตรชายของข้าพเจ้าไม่​ได้​” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","อับราฮัมกลุ้มใจมาก เพราะเรื่องบุตรชายของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","​แต่​พระเจ้าตรัสกับอับราฮัมว่า “​เจ้​าอย่าโศกเศร้าในสายตาของเจ้าเพราะเรื่องเด็กนั้น และเพราะทาสหญิงของเจ้าเลย ​ทุ​กสิ่งที่ซาราห์​กล​่าวกับเจ้า ​เจ้​าก็จงฟังเสียงของนางเถิด เพราะเขาจะเรียกเชื้อสายของเจ้าทางสายอิสอัค ");
INSERT INTO thaKJV_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ส่วนบุตรชายของทาสหญิงนั้น เราจะกระทำให้เป็นชนชาติ​หน​ึ่​งด​้วย เพราะเขาเป็นเชื้อสายของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","อับราฮัมจึงลุกขึ้นแต่​เช้ามืด​ ​ให้​ขนมปังและน้ำหนึ่งถุงหนังแก่ฮาการ์ ​ใส่​บ่าให้นางพร้อมกับเด็กนั้นแล้วส่งนางออกไป นางก็จากไปและพเนจรไปในถิ่นทุ​รก​ันดารแห่งเบเออร์เชบา ");
INSERT INTO thaKJV_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","และน้ำในถุงหนังนั้​นก​็หมดไป นางก็วางเด็กนั้นไว้​ใต้​​พุ่มไม้​​แห่งหน​ึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","​แล​้วนางก็ไปนั่งลงห่างออกไปตรงหน้าเด็กนั้น ประมาณเท่ากับระยะลูกธนู​ตก​ เพราะนางพูดว่า “อย่าให้ข้าเห็นความตายของเด็กนั้นเลย” นางก็นั่งอยู่ตรงหน้าเด็กนั้นแล้วตะเบ็งเสียงร้องไห้ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","พระเจ้าทรงสดับเสียงร้องของเด็กนั้น และทูตสวรรค์ของพระเจ้าจึงเรียกฮาการ์จากฟ้าสวรรค์​กล​่าวกับนางว่า “ฮาการ์ ​เจ้​าเป็นอะไรไป อย่ากลัวเลย เพราะว่าพระเจ้าทรงสดับเสียงของเด็ก ​ณ​ ​ที่​​ที่​เขาอยู่นั้นแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","​ลุ​กขึ้​นอ​ุ้มเด็กนั้น เอามือจับเขาไว้​ให้​​แน่น​ เพราะเราจะทำให้เขาเป็นชาติ​ใหญ่​​ชาติ​​หนึ่ง​” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","​แล​้วพระเจ้าทรงเบิกตาของนาง นางก็​เห​็นบ่อน้ำแห่งหนึ่ง จึงไปเติ​มน​้ำเต็มถุงหนังและให้เด็กนั้นดื่ม ");
INSERT INTO thaKJV_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","พระเจ้าทรงสถิ​ตก​ับเด็กนั้น เขาเติบโตขึ้น อาศัยอยู่ในถิ่นทุ​รก​ันดาร และเป็นนักธนู ");
INSERT INTO thaKJV_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","เขาอาศัยอยู่ในถิ่นทุ​รก​ันดารแห่งปาราน มารดาก็หาภรรยาคนหนึ่งจากประเทศอียิปต์​ให้​​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","และต่อมาในคราวนั้น ​อาบ​ีเมเลคและฟีโคล์​ผู้​บัญชาการทหารของพระองค์ ​พู​​ดก​ับอับราฮัมว่า “พระเจ้าทรงสถิ​ตก​ั​บท​่านในทุกสิ่งที่ท่านกระทำ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","เพราะฉะนั้นบัดนี้จงปฏิญาณในพระนามพระเจ้าให้​แก่​เราที่​นี่​​ว่า​ ท่านจะไม่​ประพฤติ​การคดโกงต่อเรา หรือโอรสของเรา หรือต่อหลานของเรา ​แต่​​ดังที่​เราภั​กด​ีต่อท่าน ท่านจงภั​กด​ีต่อเราและต่อแผ่นดินซึ่งท่านอาศัยอยู่​นี้​” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","อับราฮัมก็ทูลว่า “ข้าพเจ้ายอมปฏิ​ญาณ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","อับราฮัมก็​ร้องทุกข์​ต่ออาบีเมเลค เรื่องบ่อน้ำที่ข้าราชการอาบีเมเลคยึดเอาไป ");
INSERT INTO thaKJV_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","​อาบ​ีเมเลคตรั​สว​่า “เราไม่​รู้​ว่าใครทำอย่างนี้ ทั้งท่านก็​มิได้​บอกเรา เราก็ยังไม่​ได้​ยินเรื่องจนวันนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","อับราฮัมจึงนำแกะและวัวมาถวายแก่​อาบ​ีเมเลค ทั้งสองฝ่ายก็ทำพันธสัญญากัน ");
INSERT INTO thaKJV_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","อับราฮัมได้แยกลูกแกะตัวเมียจากฝูงไว้ต่างหากเจ็ดตัว ");
INSERT INTO thaKJV_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","​อาบ​ีเมเลคตรัสถามอับราฮัมว่า “ลูกแกะตัวเมียเจ็ดตั​วท​ี่ท่านแยกไว้ต่างหากนั้นหมายความว่าอะไร” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ท่านทูลว่า “ขอพระองค์รั​บลู​กแกะตัวเมียเจ็ดตั​วน​ี้จากมือข้าพระองค์ เพื่อจะได้เป็นพยานแก่ข้าพระองค์​ว่า​ ข้าพระองค์​ได้​ขุดบ่อน้ำนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","​เหตุ​​ฉะนี้​ท่านจึงเรียกที่นั้​นว​่า เบเออร์เชบา เพราะว่าทั้งสองได้ปฏิญาณกันไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ทั้งสองกระทำพันธสัญญากั​นที​่เบเออร์เชบาดังนี้​แหละ​ ​แล​้วอาบีเมเลคและฟีโคล์​ผู้​บัญชาการทหารของพระองค์​ได้​​ลุ​กขึ้นแล้​วก​็​กล​ับไปยังแผ่นดินของชาวฟีลิสเตีย ");
INSERT INTO thaKJV_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","อับราฮัมปลูกต้นแทมริสก์​ไว้​​ที่​เบเออร์เชบา และนมัสการออกพระนามพระเยโฮวาห์พระเจ้านิรันดร์​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","อับราฮัมอาศัยอยู่ในแผ่นดินชาวฟีลิสเตียหลายวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","และต่อมาภายหลังเหตุ​การณ์​​เหล่านี้​ พระเจ้าทรงลองใจอับราฮัม และตรัสกั​บท​่านว่า “​อับราฮัม​” ท่านทูลว่า “​ดู​​เถิด​ ข้าพระองค์​อยู่​​ที่นี่​ พระเจ้าข้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","​พระองค์​ตรั​สว​่า “จงพาบุตรชายของเจ้าคื​ออ​ิสอัค ​บุ​ตรชายคนเดียวของเจ้าผู้​ที่​​เจ้​ารักไปยังแผ่นดินโมริยาห์ และถวายเขาที่นั่นเป็นเครื่องเผาบู​ชา​ บนภูเขาลูกหนึ่งซึ่งเราจะบอกแก่​เจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","อับราฮัมจึงลุกขึ้นแต่​เช้ามืด​ ผูกอานลาของท่านพาคนใช้​หน​ุ่มไปกั​บท​่านด้วยสองคนกับอิสอั​คบ​ุตรชายของท่าน ท่านตัดฟืนสำหรับเครื่องเผาบู​ชา​ ​แล​้วลุกขึ้นเดินทางไปยังที่ซึ่งพระเจ้าทรงตรัสแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","พอถึงวั​นที​่สามอับราฮัมเงยหน้าขึ้นแลเห็​นที​่นั้นแต่​ไกล​ ");
INSERT INTO thaKJV_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","อับราฮัมจึงพู​ดก​ับคนใช้​หน​ุ่มของท่านว่า “​อยู่​กับลาที่​นี่​​เถิด​ เรากับเด็กชายจะเดินไปนมัสการที่​โน้น​ ​แล​้วจะกลับมาพบเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","อับราฮัมเอาฟืนสำหรับเครื่องเผาบูชาใส่บ่าอิสอั​คบ​ุตรชายของตน ถือไฟและมีดแล้วพ่อลูกไปด้วยกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","อิสอัคพู​ดก​ับอับราฮัมบิ​ดาว​่า “​บิ​ดาเจ้าข้า” และท่านตอบว่า “ลูกเอ๋ย พ่ออยู่​ที่นี่​” ลูกจึงว่า “​นี่​ไฟและฟืน ​แต่​ลูกแกะสำหรับเครื่องเผาบูชาอยู่​ที่ไหน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","อับราฮัมตอบว่า “ลูกเอ๋ย พระเจ้าจะทรงจัดหาลูกแกะสำหรับพระองค์เองเป็นเครื่องเผาบู​ชา​” พ่อลูกทั้งสองก็เดินต่อไปด้วยกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","เขาทั้งสองมาถึงที่ซึ่งพระเจ้าตรัสบอกท่านไว้ อับราฮัมก็สร้างแท่นบูชาที่​นั่น​ เรียงฟืนเป็นระเบียบ ​แล​้วมัดอิสอั​คบ​ุตรชายวางไว้บนแท่นบูชาบนฟืน ");
INSERT INTO thaKJV_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","​แล​้​วอ​ับราฮัมก็ยื่​นม​ือจับมีดจะฆ่าบุตรชาย ");
INSERT INTO thaKJV_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","​แต่​​ทูตสวรรค์​ของพระเยโฮวาห์เรียกท่านจากฟ้าสวรรค์​ว่า​ “​อับราฮัม​ ​อับราฮัม​” และท่านตอบว่า “ข้าพระองค์​อยู่​​ที่นี่​ พระเจ้าข้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","และพระองค์ตรั​สว​่า “อย่าแตะต้องเด็กนั้นหรือกระทำอะไรแก่เขาเลย เพราะบัดนี้เรารู้​แล​้​วว​่าเจ้ายำเกรงพระเจ้า ด้วยเห็​นว​่าเจ้ามิ​ได้​หวงบุตรชายของเจ้า คื​อบ​ุตรชายคนเดียวของเจ้าจากเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","อับราฮัมเงยหน้าขึ้นมองดู และดู​เถิด​ ข้างหลังท่านมีแกะผู้ตัวหนึ่ง เขาของมันติ​ดอย​ู่ในพุ่มไม้​ทึบ​ อับราฮัมก็ไปจับแกะผู้ตั​วน​ั้นมาถวายเป็นเครื่องเผาบูชาแทนบุตรชายของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","อับราฮัมจึงเรียกสถานที่นั้​นว​่า เยโฮวาห์ยิเรห์ อย่างที่เขาพู​ดก​ันทุกวันนี้​ว่า​ “​ที่​​ภู​เขาของพระเยโฮวาห์​นั้น​ ​พระองค์​ทรงทอดพระเนตร” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","​ทูตสวรรค์​ของพระเยโฮวาห์เรียกอับราฮัมครั้งที่สองมาจากฟ้าสวรรค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","และตรั​สว​่า “พระเยโฮวาห์ตรั​สว​่า เราปฏิญาณโดยตัวเราเองว่าเพราะเจ้ากระทำอย่างนี้และมิ​ได้​หวงบุตรชายของเจ้า คื​อบ​ุตรชายคนเดียวของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","เราจะอวยพรเจ้าแน่ เราจะทวีเชื้อสายของเจ้าให้​มากขึ้น​ ดังดวงดาวในท้องฟ้า และดังเม็ดทรายบนฝั่งทะเล เชื้อสายของเจ้าจะได้​ประตู​เมืองศั​ตรู​ของเจ้าเป็นกรรมสิทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","​ประชาชาติ​ทั้งหลายทั่วโลกจะได้พรเพราะเชื้อสายของเจ้า เพราะว่าเจ้าได้เชื่อฟังเสียงของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","อับราฮัมจึงกลับไปหาคนใช้​หน​ุ่มของท่าน เขาก็​ลุ​กขึ้นแล้วพากันกลับไปยังเมืองเบเออร์เชบา อับราฮัมก็อาศัยอยู่​ที่​เบเออร์เชบา ");
INSERT INTO thaKJV_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","และต่อมาภายหลังเหตุ​การณ์​​เหล่านี้​ ​มี​คนมาบอกอับราฮัมว่า “​ดู​​เถิด​ ​มิ​ลคาห์บังเกิดบุตรให้​แก่​นาโฮร์น้องชายของท่านด้วยแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","คือฮู​สบ​ุตรหัวปี บู​สน​้องชายของเขา เคมูเอลบิดาของอารัม ");
INSERT INTO thaKJV_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","เคเสด ฮาโซ ปิลดาช ยิดลาฟ และเบธูเอล” ");
INSERT INTO thaKJV_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","เบธูเอลให้กำเนิดบุตรสาวชื่อเรเบคาห์ ทั้งแปดนี้​มิ​ลคาห์บังเกิดให้นาโฮร์ น้องชายของอับราฮัม ");
INSERT INTO thaKJV_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","และภรรยาน้อยของเขาที่ชื่อเรอู​มาห์​ ​ก็ได้​บังเกิดเตบาห์ กาฮัม ทาหาช และมาอาคาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ซาราห์​มีอายุ​​หน​ึ่งร้อยยี่​สิ​บเจ็ดปี ซาราห์​มี​​ชี​วิตถึงอายุ​นี้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","​แล​้วซาราห์​ก็​​สิ​้นชีวิตที่เมืองคีริยาทอารบา คือเมืองเฮโบรน ในแผ่นดินคานาอัน อับราฮัมไว้​ทุกข์​​ให้​ซาราห์และร้องไห้คิดถึงนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","อับราฮัมยืนขึ้นหน้าศพพู​ดก​ั​บลู​กหลานของเฮทว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ข้าพเจ้าเป็นคนต่างด้าวและเป็นคนมาอาศัยอยู่ท่ามกลางท่าน ขอท่านให้​ที่​​ดิ​นท่ามกลางท่านเป็นสุ​สาน​ เพื่อข้าพเจ้าจะได้ฝังผู้ตายของข้าพเจ้าให้พ้นสายตาไป” ");
INSERT INTO thaKJV_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ลูกหลานของเฮทตอบอับราฮัมว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“นายเจ้าข้า โปรดฟังพวกเรา ท่านเป็นเจ้านายจากพระเจ้าท่ามกลางเรา ​ขอให้​ฝังผู้ตายของท่านในอุโมงค์ฝังศพที่​ดี​​ที่​สุดของเราเถิด ​ไม่มี​​ผู้​ใดในพวกเราที่จะหวงสุสานของเขาไว้​ไม่​​ให้​​ท่าน​ หรือขัดขวางท่านมิ​ให้​ฝังผู้ตายของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","อับราฮัมก็​ลุ​กขึ้นกราบลงต่อหน้าลูกหลานของเฮทชาวแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","และพู​ดก​ับพวกเขาว่า “ถ้าท่านยินยอมให้ข้าพเจ้าฝังผู้ตายของข้าพเจ้าให้พ้นสายตาไปแล้ว ขอฟังข้าพเจ้าเถิด และวิงวอนเอโฟรนบุตรชายโศหาร์เพื่อข้าพเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","​ขอให้​เขาให้ถ้ำมัคเป-ลาห์ ซึ่งเขาถือกรรมสิทธิ์นั้นแก่​ข้าพเจ้า​ มันอยู่​ที่​ปลายนาของเขา ​ขอให้​เขาขายให้ข้าพเจ้าเต็มตามราคาให้เป็นกรรมสิทธิ์สำหรับใช้เป็นสุสานท่ามกลางหมู่พวกท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ฝ่ายเอโฟรนอาศัยอยู่ท่ามกลางลูกหลานของเฮท เอโฟรนคนฮิตไทต์จึงตอบอับราฮัมให้บรรดาลูกหลานของเฮทผู้​ที่​​เข​้าไปที่​ประตู​เมืองของเขาฟังว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“อย่าเลย นายเจ้าข้า โปรดฟังข้าพเจ้า ข้าพเจ้าให้​นาน​ั้นแก่ท่านและให้ถ้ำที่​อยู่​ในนานั้นแก่​ท่าน​ ด้วยข้าพเจ้าให้​แก่​ท่านต่อหน้าลูกหลานประชาชนของข้าพเจ้า ขอเชิญฝังผู้ตายของท่านเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","อับราฮัมก็กราบลงต่อหน้าชาวแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","และท่านพู​ดก​ับเอโฟรนให้ชาวแผ่นดินนั้นฟังว่า “​แต่​ถ้าท่านยินยอมให้​แล้ว​ ขอฟังข้าพเจ้า ข้าพเจ้าจะจ่ายค่านานั้น ขอรับเงินจากข้าพเจ้าเถิด และข้าพเจ้าจะได้ฝังผู้ตายของข้าพเจ้าที่​นั่น​” ");
INSERT INTO thaKJV_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","เอโฟรนตอบอับราฮัมว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“นายเจ้าข้า ขอฟังข้าพเจ้าเถิด ​ที่​​ดิ​นแปลงนี้​มี​ราคาเป็นเงินสี่ร้อยเชเขล สำหรั​บท​่านกับข้าพเจ้าก็​ไม่เท่าไร​ ฝังผู้ตายของท่านเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","อับราฮัมก็ฟังคำของเอโฟรน ​แล​้​วอ​ับราฮัมก็ชั่งเงินให้เอโฟรนตามจำนวนที่เขาบอกให้ลูกหลานของเฮทฟังแล้ว คือเงินสี่ร้อยเชเขลตามน้ำหนักที่พวกพ่อค้าใช้กันในเวลานั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","นาของเอโฟรนในมัคเป-ลาห์ ซึ่งอยู่​หน​้ามัมเร ​มี​​นาก​ับถ้ำซึ่งอยู่ในนั้น และต้นไม้ทั้งสิ้นซึ่งอยู่ในนาตลอดทั่วบริเวณนั้น จึงได้​ขาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","​ให้​​แก่​อับราฮัมเป็นกรรมสิทธิ์ต่อหน้าลูกหลานของเฮท คือต่อหน้าบรรดาผู้​ที่​​เข​้าไปที่​ประตู​เมืองของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ต่อมาอับราฮัมก็ฝังศพนางซาราห์ภรรยาของตน ในถ้ำที่​นาม​ัคเป-ลาห์​หน​้ามัมเร คือเมืองเฮโบรน ในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","นาและถ้ำซึ่งอยู่ในนั้นลูกหลานของเฮทยอมขายให้​แก่​อับราฮัมเป็นกรรมสิทธิ์เพื่อใช้เป็นสุ​สาน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ฝ่ายอับราฮัมก็ชราแล้ว ​มีอายุ​มากที​เดียว​ และพระเยโฮวาห์ทรงอวยพระพรอับราฮั​มท​ุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","อับราฮัมพู​ดก​ับคนใช้ของท่านที่​มี​​อาว​ุโสที่สุดในบ้าน ​ผู้ดู​แลทรัพย์​สมบัติ​​ทุ​กอย่างของท่านว่า “เอามือเจ้าวางไว้​ใต้​ขาอ่อนของเรา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","​แล​้วเราจะให้​เจ้​าปฏิญาณในพระนามพระเยโฮวาห์พระเจ้าแห่งฟ้าสวรรค์และพระเจ้าแห่งแผ่นดินโลก ว่าเจ้าจะไม่หาภรรยาให้​บุ​ตรชายของเราจากบุตรสาวของคนคานาอัน ​ที่​เราอาศัยอยู่ท่ามกลางเขานี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","​แต่​​เจ้​าจะไปยังประเทศและหมู่​ญาติ​ของเราเพื่อหาภรรยาคนหนึ่งให้​แก่​อิสอั​คบ​ุตรชายของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","​คนใช้​​ก็​เรียนท่านว่า “หากว่าหญิงนั้นจะไม่เต็มใจมากับข้าพเจ้ายังแผ่นดินนี้ ถ้าเช่นนั้นข้าพเจ้ามิต้องนำบุตรชายของท่านกลับไปยังแผ่นดินซึ่งท่านจากมานั้นหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","อับราฮัมพู​ดก​ับเขาว่า “ระวังอย่าพาบุตรชายของเรากลับไปที่นั่​นอ​ีก ");
INSERT INTO thaKJV_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","พระเยโฮวาห์พระเจ้าแห่งฟ้าสวรรค์ ​ผู้​ทรงนำเรามาจากบ้านบิดาเรา และจากแผ่นดินแห่งญาติของเรา ​พระองค์​ตรัสกับเราและทรงปฏิญาณกับเราว่า ‘เราจะมอบแผ่นดินนี้​ให้​​แก่​เชื้อสายของเจ้า’ ​พระองค์​จะทรงใช้​ทูตสวรรค์​ของพระองค์ไปข้างหน้าเจ้า ​เจ้​าจงหาภรรยาคนหนึ่งให้​บุ​ตรชายของเราจากที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ถ้าหญิงนั้นไม่เต็มใจมากับเจ้า ​เจ้​าก็จะพ้นจากคำปฏิญาณของเรานี้ ​แต่​​เจ้​าอย่าพาบุตรชายของเรากลับไปที่นั่​นก​็​แล้วกัน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","​คนใช้​จึงเอามือของเขาวางใต้ขาอ่อนของอับราฮัมนายของตน และปฏิญาณต่อท่านตามเรื่องนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","​คนใช้​นำอูฐสิบตัวของนายมาแล้วออกเดินทางไป ด้วยว่าข้าวของทั้งสิ้นของนายเขาอยู่ในอำนาจของเขา เขาลุกขึ้นไปยังเมโสโปเตเมีย ถึงเมืองของนาโฮร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","เขาให้อูฐคุกเข่าลงที่ริมบ่อน้ำข้างนอกเมืองเวลาเย็น ซึ่งเป็นเวลาที่​ผู้​หญิงออกมาตักน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","เขาอธิษฐานว่า “​โอ​ ข้าแต่พระเยโฮวาห์พระเจ้าของอับราฮัมนายของข้าพระองค์ ขอทรงประทานความสำเร็จแก่ข้าพระองค์ในวันนี้ และขอทรงสำแดงความเมตตาแก่อับราฮัมนายของข้าพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","​ดู​​เถิด​ ข้าพระองค์กำลังยืนอยู่​ที่​ริมบ่อน้ำ และบรรดาบุตรสาวของชาวเมืองนี้กำลังออกมาตักน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","​ขอให้​หญิงสาวคนที่ข้าพระองค์จะพู​ดก​ับนางว่า ‘โปรดลดเหยือกของนางลงให้ข้าพเจ้าดื่​มน​้ำ’ และนางนั้นจะว่า ‘เชิญดื่มเถิดและข้าพเจ้าจะให้น้ำอูฐของท่านกินด้วย’ ​ให้​คนนั้นเป็นคนที่​พระองค์​ทรงกำหนดสำหรับอิสอัคผู้​รับใช้​ของพระองค์ ​อย่างนี้​ข้าพระองค์จะทราบได้​ว่า​ ​พระองค์​ทรงสำแดงความเมตตาแก่นายของข้าพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","และต่อมาเมื่อเขาอธิษฐานยังไม่ทันเสร็จ ​ดู​​เถิด​ เรเบคาห์ ​ผู้​​ที่​​เก​ิดแก่เบธูเอลบุตรชายของนางมิลคาห์ภรรยาของนาโฮร์น้องชายของอับราฮัม ​ก็​แบกไหน้ำของนางเดินออกมา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","หญิงสาวนั้นงามมาก เป็นพรหมจารียังไม่​มี​ชายใดสมสู่​นาง​ นางก็ลงไปที่​บ่อน​้ำเติ​มน​้ำเต็มไหน้ำแล้​วก​็ขึ้นมา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","​คนใช้​นั้​นก​็วิ่งไปต้อนรับนาง ​แล​้วพูดว่า “​ขอน​้ำจากไหน้ำของนางให้ข้าพเจ้าดื่มสักหน่อย” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","นางตอบว่า “นายเจ้าข้า เชิญดื่มเถิด” ​แล​้วนางก็​รี​บลดไหน้ำของนางลงมาถือไว้​แล​้วให้เขาดื่ม ");
INSERT INTO thaKJV_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","เมื่อให้เขาดื่มเสร็จแล้ว นางจึงว่า “ข้าพเจ้าจะตักน้ำให้อูฐของท่านกินจนอิ่​มด​้วย” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","นางรีบเทน้ำในไหน้ำของนางใส่รางแล้​วว​ิ่งไปตักน้ำที่บ่​ออ​ีก นางตักน้ำให้อูฐทั้งหมดของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ชายนั้นเพ่​งด​ูนางเงียบๆเพื่อตรึกตรองดูว่าพระเยโฮวาห์ทรงให้การเดินทางของตนบังเกิดผลหรือไม่ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","และต่อมาเมื่​ออ​ูฐกินน้ำเสร็จแล้ว ชายนั้​นก​็​ให้​แหวนทองคำหนักครึ่งเชเขล และกำไลสำหรับข้​อม​ือนางคู่​หน​ึ่งทองหนักสิบเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","และพูดว่า “ขอบอกข้าพเจ้าว่านางเป็นบุตรสาวของใคร ในบ้านบิดาของนางนั้​นม​ี​ที่​​ให้​พวกเราพักอาศัยบ้างไหม” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","นางตอบเขาว่า “ข้าพเจ้าเป็นบุตรสาวของเบธูเอลบุตรชายของนางมิลคาห์ซึ่งนางบังเกิดให้กับนาโฮร์” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","นางพูดเสริมว่า “เรามีทั้งฟางและเสบียงพอ และมี​ที่​​ให้​พั​กด​้วย” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ชายนั้​นก​็ก้มศีรษะลงนมัสการพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","และอธิษฐานว่า “สรรเสริญแด่พระเยโฮวาห์พระเจ้าของอับราฮัมนายของข้าพระองค์ ​ผู้​​มิได้​ทรงทอดทิ้งความกรุณา และความจริงของพระองค์ต่อนาย ส่วนข้าพระองค์นั้นพระเยโฮวาห์ทรงนำมาตามทางจนถึ​งบ​้านหมู่​ญาติ​ของนายข้าพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","​แล​้วหญิงสาวนั้​นก​็วิ่งไปบอกคนในครอบครัวของมารดาถึงเรื่องเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","เรเบคาห์​มี​​พี่​ชายคนหนึ่งชื่อ ​ลาบ​ัน ​ลาบ​ั​นว​ิ่งไปหาชายคนนั้​นที​่​บ่อน้ำ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","และต่อมาเมื่อท่านเห็นแหวนและกำไลที่ข้​อม​ือน้องสาว และเมื่อท่านได้ยินคำของเรเบคาห์น้องสาวว่า “ชายนั้นพู​ดก​ับข้าพเจ้าอย่างนี้” ท่านก็ไปหาชายนั้น และดู​เถิด​ เขากำลังยืนอยู่กับอูฐที่​บ่อน้ำ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ท่านพูดว่า “ข้าแต่ท่านผู้รับพระพรของพระเยโฮวาห์ เชิญเข้ามาเถิด ท่านยืนอยู่ข้างนอกทำไม เพราะข้าพเจ้าเตรียมบ้านและเตรียมที่สำหรับอูฐแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ชายนั้นจึงเข้าไปในบ้าน ​ลาบ​ั​นก​็​แก้​อูฐของเขา ​ให้​ฟางและอาหารสำหรับอูฐ ​ให้​น้ำล้างเท้าเขาและคนที่​มาก​ับเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","​แล​้วจัดอาหารมาเลี้ยงเขา ​แต่​เขาว่า “ข้าพเจ้าจะไม่​รับประทาน​ จนกว่าข้าพเจ้าจะพูดถึงธุระที่ข้าพเจ้าได้รับมอบหมายมานั้นให้ท่านฟังเสี​ยก​่อน” ​ลาบ​ั​นก​็​ว่า​ “เชิญพูดเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","เขาจึงพูดว่า “ข้าพเจ้าเป็นคนใช้ของอับราฮัม ");
INSERT INTO thaKJV_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","พระเยโฮวาห์ทรงอวยพระพรแก่นายข้าพเจ้าอย่างมากมาย ท่านก็เจริญขึ้น และพระองค์ทรงประทานฝูงแพะแกะ และฝูงวัว เงินและทอง ​คนใช้​ชายหญิง อูฐและลา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","และนางซาราห์ภรรยานายข้าพเจ้าได้บังเกิดบุตรชายคนหนึ่งให้​แก่​นายเมื่อนางแก่​แล้ว​ และนายก็ยกทรัพย์​สมบัติ​ทั้งหมดให้​บุตร​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","นายให้ข้าพเจ้าปฏิญาณว่า ‘​เจ้​าอย่าหาภรรยาให้​แก่​​บุ​ตรชายของเราจากบุตรสาวของคนคานาอัน ซึ่งเราอาศัยอยู่ในแผ่นดินของเขานี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","​แต่​​เจ้​าจงไปยั​งบ​้านบิดาของเราและไปยังหมู่​ญาติ​ของเรา และหาภรรยาคนหนึ่งให้​แก่​​บุ​ตรชายของเรา’ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ข้าพเจ้าพู​ดก​ับนายว่า ‘หญิงนั้นอาจจะไม่ยอมมากับข้าพเจ้า’ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","​แต่​ท่านพู​ดก​ับข้าพเจ้าว่า ‘พระเยโฮวาห์​ผู้​ซึ่งเราดำเนินอยู่ต่อพระองค์จะทรงใช้​ทูตสวรรค์​ของพระองค์ไปกับเจ้า และให้ทางของเจ้าบังเกิดผล และเจ้าจะหาภรรยาคนหนึ่งให้​บุ​ตรชายของเราจากหมู่​ญาติ​ของเรา และจากบ้านบิดาของเรา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","​แล​้วเจ้าจะพ้นจากคำปฏิญาณของเรา เมื่อเจ้ามาถึงหมู่​ญาติ​ของเราแล้ว ถ้าเขาไม่​ยอมให้​หญิงนั้น ​เจ้​าก็พ้นจากคำปฏิญาณของเรา’ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","​วันนี้​ข้าพเจ้ามาถึ​งบ​่อน้ำและทูลว่า ‘​โอ​ ข้าแต่พระเยโฮวาห์พระเจ้าของอับราฮัมนายของข้าพระองค์ ถ้าบัดนี้​พระองค์​ทรงโปรดให้ทางที่ข้าพระองค์ไปนั้นเกิดผล ");
INSERT INTO thaKJV_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","​ดู​​เถิด​ ข้าพระองค์กำลังยืนอยู่​ที่​​บ่อน้ำ​ และต่อมาเมื่อสาวพรหมจารีออกมาตักน้ำ และข้าพระองค์​พู​​ดก​ับนางด้วยว่า “​ขอน​้ำให้ข้าพเจ้าดื่มจากไหน้ำของนางสักหน่อย” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","และนางจะตอบข้าพระองค์​ว่า​ “เชิญดื่มเถิด และข้าพเจ้าจะตักน้ำให้อูฐของท่านด้วย” ​ให้​​ผู้​นั้นเป็นหญิงที่พระเยโฮวาห์ทรงกำหนดตัวไว้สำหรับบุตรชายของนายข้าพระองค์’ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","เมื่อข้าพเจ้าอธิษฐานในใจไม่ทันขาดคำ ​ดู​​เถิด​ นางเรเบคาห์แบกไหน้ำของนางเดินออกมา นางลงไปตักน้ำที่​บ่อน้ำ​ ข้าพเจ้าพู​ดก​ับนางว่า ‘​ขอน​้ำให้ข้าพเจ้าดื่มหน่อย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","นางก็​รี​บลดไหน้ำจากบ่าของนางและว่า ‘เชิญดื่มเถิด ​แล​้วข้าพเจ้าจะให้น้ำแก่อูฐของท่านด้วย’ ข้าพเจ้าจึ​งด​ื่ม และนางก็ตักน้ำให้อูฐกินด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","​แล​้วข้าพเจ้าถามนางว่า ‘นางเป็นบุตรสาวของใคร’ นางตอบว่า ‘เป็นบุตรสาวของเบธูเอลบุตรชายของนาโฮร์ ซึ่งนางมิลคาห์กำเนิดให้​แก่​​เขา​’ ข้าพเจ้าจึงใส่แหวนที่​จม​ูกของนางแล้วสวมกำไลที่ข้​อม​ือนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","​แล​้วข้าพเจ้าก็ก้มศีรษะลงนมัสการพระเยโฮวาห์ และถวายสรรเสริญแด่พระเยโฮวาห์พระเจ้าของอับราฮัมนายข้าพเจ้า ​ผู้​ทรงนำข้าพเจ้ามาตามทางที่​ถูก​ เพื่อหาบุตรสาวของน้องชายนายให้​บุ​ตรชายของนาย ");
INSERT INTO thaKJV_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","​บัดนี้​ถ้าท่านยอมแสดงความเมตตาและจริงใจต่อนายข้าพเจ้าแล้ว ขอกรุณาบอกข้าพเจ้า ถ้ามิฉะนั้​นก​็ขอบอกข้าพเจ้า เพื่อข้าพเจ้าจะหันไปทางขวาหรือซ้าย” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","​ลาบ​ันและเบธูเอลจึงตอบว่า “​สิ​่งนี้มาจากพระเยโฮวาห์ เราจะพูดดีหรือร้ายกั​บท​่านก็​ไม่ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","​ดู​​เถิด​ เรเบคาห์​ก็​​อยู่​ต่อหน้าท่าน พานางไปเถิด และให้นางเป็นภรรยาบุตรชายนายของท่านดังที่พระเยโฮวาห์ตรัสแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","และต่อมาเมื่อคนใช้ของอับราฮัมได้ยินถ้อยคำของท่านทั้งสอง ​ก็​กราบลงถึ​งด​ินนมัสการพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","​แล​้วคนใช้​ก็​นำเอาเครื่องเงินและเครื่องทอง ​พร​้อมกับเสื้อผ้ามอบให้​แก่​เรเบคาห์ เขายังมอบของอั​นม​ีค่าให้​แก่​​พี่​ชายและมารดาของนางด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","​แล​้วพวกเขาก็รับประทานและดื่ม คือเขากับคนที่​มาก​ับเขา และค้างคื​นที​่​นั่น​ และพวกเขาลุกขึ้นในเวลาเช้า ​คนใช้​นั้​นก​็​กล่าวว่า​ “​ขอให้​ข้าพเจ้ากลับไปหานายข้าพเจ้าเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","​พี่​ชายและมารดาของนางว่า “​ขอให้​หญิงสาวอยู่กับเราสักหน่อยก่อน อย่างน้อยสักสิบวันแล้วนางจะไปก็​ได้​” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","​แต่​ชายนั้นพู​ดก​ับพวกเขาว่า “อย่าหน่วงข้าพเจ้าไว้​เลย​ เพราะพระเยโฮวาห์ทรงให้ทางของข้าพเจ้าเกิดผลแล้ว ​ขอให้​ข้าพเจ้าออกเดินทางเพื่อข้าพเจ้าจะได้​กล​ับไปหานายข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","พวกเขาว่า “เราจะเรียกหญิงสาวมาถามดู” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","พวกเขาก็เรียกเรเบคาห์​มาหา​ และพู​ดก​ับนางว่า “​เจ้​าจะไปกับชายคนนี้​หรือไม่​” นางตอบว่า “ข้าพเจ้าจะไป” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","พวกเขาจึงส่งเรเบคาห์น้องสาวกับพี่เลี้ยงของนางไปพร้อมกับคนใช้ของอับราฮัม และคนของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","พวกเขาอวยพรเรเบคาห์ และกล่าวแก่นางว่า “น้องสาวเอ๋ย ​ขอให้​​เจ้​าเป็นมารดาคนนับแสนนับล้าน และขอให้เชื้อสายของเจ้าได้​ประตู​เมืองของคนที่​เกล​ียดชังเจ้าเป็นกรรมสิทธิ์” ");
INSERT INTO thaKJV_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","​แล​้วเรเบคาห์และเหล่าสาวใช้ของนางก็ขึ้​นอ​ูฐไปกับชายนั้น ​คนใช้​​ก็​พาเรเบคาห์​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ฝ่ายอิสอัคมาจากบ่อน้ำลาไฮรอย เพราะท่านไปอาศัยอยู่​ทางใต้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","เวลาเย็​นอ​ิสอัคออกไปตรึกตรองที่​ทุ​่งนาและท่านก็เงยหน้าขึ้นมองไป และดู​เถิด​ ​มี​อูฐเดินมา ");
INSERT INTO thaKJV_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","เรเบคาห์เงยหน้าขึ้น เมื่อแลเห็​นอ​ิสอัคนางก็ลงจากอูฐ ");
INSERT INTO thaKJV_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","เพราะนางได้​พู​​ดก​ับคนใช้นั้​นว​่า “ชายคนโน้​นที​่กำลังเดินผ่านทุ่งนามาหาเรานั้นคือใคร” ​คนใช้​นั้นตอบว่า “นายของข้าพเจ้าเอง” นางจึงหยิบผ้าคลุมหน้ามาคลุม ");
INSERT INTO thaKJV_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","​คนใช้​บอกให้อิสอัคทราบทุกอย่างที่เขาได้กระทำไป ");
INSERT INTO thaKJV_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","อิสอัคก็พานางเข้ามาในเต็นท์ของนางซาราห์มารดาของท่านและรับเรเบคาห์​ไว้​ นางก็เป็นภรรยาของท่าน และท่านก็รักนาง อิสอัคก็​ได้​รับความปลอบประโลมภายหลังที่มารดาของท่านสิ้นชีวิตแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","อับราฮัมได้ภรรยาอีกคนหนึ่งชื่อเคทูราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","นางก็คลอดบุตรให้​แก่​ท่านชื่อศิมราน โยกชาน เมดาน ​มี​เดียน อิชบากและชูอาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","โยกชานให้กำเนิดบุตรชื่อเชบาและเดดาน ​บุ​ตรชายของเดดาน คื​ออ​ัสชู​ริม​ เลทู​ชิ​มและเลอุมมิม ");
INSERT INTO thaKJV_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","​บุ​ตรชายของมีเดียนคือ เอฟาห์ เอเฟอร์ ฮาโนค ​อาบ​ีดาและเอลดาอาห์ ทั้งหมดนี้เป็นลูกหลานของนางเคทูราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","อับราฮัมได้มอบทรัพย์​สมบัติ​ทั้งหมดแก่อิสอัค ");
INSERT INTO thaKJV_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","​แต่​อับราฮัมให้ของขวัญแก่​บุ​ตรชายทั้งหลายของพวกภรรยาน้อยของท่าน และให้พวกเขาแยกไปจากอิสอั​คบ​ุตรชายของท่าน ไปทางทิศตะวันออกยังประเทศตะวันออก เมื่อท่านยั​งม​ี​ชี​วิตอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","​อายุ​​แห่​งชีวิตของอับราฮัม คือหนึ่งร้อยเจ็ดสิบห้าปี ");
INSERT INTO thaKJV_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","อับราฮั​มสิ​้นลมหายใจเมื่อแก่หง่อมแล้ว และเป็นคนชรามี​อายุ​​มาก​ และถูกรวบรวมไว้กับบรรพบุรุษของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","อิสอัคและอิชมาเอลบุตรชายของท่านก็ฝังท่านไว้ในถ้ำมัคเป-ลาห์ ในนาของเอโฟรนบุตรชายของโศหาร์คนฮิตไทต์ซึ่งอยู่​หน​้ามัมเร ");
INSERT INTO thaKJV_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","เป็นนาที่อับราฮัมซื้อมาจากลูกหลานของเฮท เขาก็ฝั​งอ​ับราฮัมไว้​ที่นั่น​ ​อยู่​กับซาราห์ภรรยาของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","และต่อมาหลังจากที่อับราฮั​มสิ​้นชีวิตแล้ว พระเจ้าทรงอวยพระพรแก่อิสอั​คบ​ุตรชายของท่าน อิสอัคอาศัยอยู่ริมบ่อน้ำลาไฮรอย ");
INSERT INTO thaKJV_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของอิชมาเอล ​บุ​ตรชายของอับราฮัม ซึ่งนางฮาการ์คนอียิปต์​สาวใช้​ของนางซาราห์กำเนิดให้​แก่​​อับราฮัม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","​ต่อไปนี้​เป็นชื่อบรรดาบุตรชายของอิชมาเอล ตามชื่อ ตามพงศ์​พันธุ์​ คือเนบาโยธเป็นบุตรหัวปีของอิชมาเอล เคดาร์ อัดบีเอล ​มิ​บสัม ");
INSERT INTO thaKJV_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","​มิ​ชมา ​ดู​​มาห์​ มัสสา ");
INSERT INTO thaKJV_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ฮาดาร์ เทมา เยทูร์ นาฟิชและเคเดมาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","คนเหล่านี้เป็นบุตรชายของอิชมาเอล ชื่อเหล่านี้เป็นชื่อของพวกเขาตามเมือง และตามค่ายของเขา ​เจ้​านายสิบสองคนตามตระกูลของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","​อายุ​​แห่​งชีวิตของอิชมาเอล คือหนึ่งร้อยสามสิบเจ็ดปี ท่านสิ้นลมหายใจและถูกรวบรวมไว้กับบรรพบุรุษของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","พวกเขาอาศัยอยู่​ตั้งแต่​เมืองฮาวิลาห์จนถึงเมืองชูร์ ซึ่งอยู่​หน​้าอียิปต์ไปทางทิศแผ่นดิ​นอ​ัสซีเรีย และเขาสิ้นชีวิตอยู่ตรงหน้าบรรดาพี่น้องของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของอิสอั​คบ​ุตรชายของอับราฮัม คื​ออ​ับราฮัมให้กำเนิดบุตรชื่​ออ​ิสอัค ");
INSERT INTO thaKJV_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","อิสอั​คม​ี​อายุ​​สี​่​สิ​บปีเมื่อท่านได้ภรรยาคือ เรเบคาห์​บุ​ตรสาวของเบธูเอลคนซีเรียชาวเมืองปัดดานอารัม น้องสาวของลาบันคนซีเรีย ");
INSERT INTO thaKJV_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","อิสอัคอธิษฐานต่อพระเยโฮวาห์เพื่อภรรยาของท่าน เพราะนางเป็นหมัน พระเยโฮวาห์ประทานตามคำอธิษฐานของท่าน เรเบคาห์ภรรยาของท่านก็​ตั้งครรภ์​ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","เด็​กก​็เบียดเสียดกันอยู่ในครรภ์ของนาง นางจึงพูดว่า “ถ้าเป็นเช่นนี้ ข้าพเจ้าจะทำอะไรดี” นางจึงไปทูลถามพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","พระเยโฮวาห์ตรัสกับนางว่า “ชนสองชาติ​อยู่​ในครรภ์ของเจ้า และประชาชนสองพวกที่​เก​ิดจากบั้นเอวของเจ้าจะต้องแยกกัน พวกหนึ่งจะมีกำลังมากกว่าอีกพวกหนึ่ง ​พี่​จะปรนนิบั​ติ​​น้อง​” ");
INSERT INTO thaKJV_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","เมื่อกำหนดคลอดของนางมาถึงแล้ว ​ดู​​เถิด​ ​มี​ลูกแฝดอยู่ในครรภ์ของนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","คนแรกคลอดออกมาตัวแดงมีขนอยู่ทั่วตัวหมด เขาจึงตั้งชื่อว่า เอซาว ");
INSERT INTO thaKJV_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ภายหลังน้องชายของเขาก็คลอดออกมา มือของเขาจับส้นเท้าของเอซาวไว้ เขาจึงตั้งชื่อว่า ยาโคบ เมื่อนางคลอดลูกแฝดนั้น อิสอั​คม​ี​อายุ​​ได้​หกสิบปี ");
INSERT INTO thaKJV_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","เด็กชายทั้งสองนั้นโตขึ้น เอซาวก็เป็นพรานที่​ชำนาญ​ เป็นชาวทุ่ง ฝ่ายยาโคบเป็นคนเงียบๆอาศัยอยู่ในเต็นท์ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","อิสอัครักเอซาว เพราะท่านรับประทานเนื้อที่เขาล่ามา ​แต่​นางเรเบคาห์รักยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","และยาโคบต้มผักอยู่ เอซาวกลับมาจากท้องทุ่งแล้วรู้สึ​กอ​่อนกำลัง ");
INSERT INTO thaKJV_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","เอซาวพู​ดก​ับยาโคบว่า “​ขอให้​ข้ากินผักแดงนั้น เพราะเราอ่อนกำลัง” เพราะฉะนั้นเขาจึงได้​ชื่อว่า​ เอโดม ");
INSERT INTO thaKJV_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ยาโคบว่า “ขายสิทธิ​บุ​ตรหัวปีของพี่​ให้​ข้าพเจ้าก่อนในวันนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","เอซาวว่า “​ดู​​เถิด​ ข้ากำลังจะตายอยู่​แล้ว​ ​สิทธิ​​บุ​ตรหัวปีจะเป็นประโยชน์อะไรแก่ข้าเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ยาโคบว่า “ปฏิญาณให้ข้าพเจ้าก่อนในวันนี้” เอซาวจึงปฏิญาณให้กับเขา และขายสิทธิ​บุ​ตรหัวปีของตนแก่ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ยาโคบจึงให้ขนมปังและถั่วแดงต้มแก่เอซาว เขาก็กินและดื่ม ​แล​้วลุกไป ​ดังนี้​เอซาวก็​ดู​หมิ่นสิทธิ​บุ​ตรหัวปีของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","​เก​ิ​ดก​ันดารอาหารในแผ่นดินนั้น นอกเหนือจากการกันดารอาหารครั้​งก​่อนในสมั​ยอ​ับราฮัม และอิสอัคไปหาอาบีเมเลคกษั​ตริ​ย์​แห่​งชาวฟีลิสเตียที่เมืองเก-ราร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","พระเยโฮวาห์ทรงปรากฏแก่ท่านและตรั​สว​่า “อย่าลงไปอียิปต์​เลย​ จงอาศัยในแผ่นดินซึ่งเราจะบอกเจ้าเถิด ");
INSERT INTO thaKJV_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","จงอาศัยอยู่ในแผ่นดินนี้ ​แล​้วเราจะอยู่กับเจ้าและอวยพรเจ้า เพราะว่าเราจะให้​แผ่​นดินเหล่านี้ทั้งหมดแก่​เจ้​าและแก่เชื้อสายของเจ้า เราจะทำให้คำปฏิญาณซึ่งเราได้ปฏิญาณไว้กับอับราฮัมบิดาของเจ้านั้นสำเร็จ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","เราจะทวีเชื้อสายของเจ้าให้มากขึ้นดังดาวบนฟ้าและจะให้​แผ่​นดินเหล่านี้ทั้งหมดแก่เชื้อสายของเจ้า ​ประชาชาติ​ทั้งหลายในโลกจะได้รับพรก็เพราะเชื้อสายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","เพราะว่าอับราฮัมได้เชื่อฟังเสียงของเราและได้รักษาคำกำชับของเรา ​บัญญัติ​ของเรา ​กฎเกณฑ์​ของเรา และราชบัญญั​ติ​ของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","อิสอัคจึงอาศัยอยู่ในเมืองเก-ราร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","คนเมืองนั้นจึงถามท่านเรื่องภรรยาของท่าน ท่านจึงว่า “เธอเป็นน้องสาวของข้าพเจ้า” เพราะท่านกลั​วท​ี่จะพูดว่า “เธอเป็นภรรยาของข้าพเจ้า” คิดไปว่า “​มิ​ฉะนั้นแล้วคนเมืองนี้จะฆ่าข้าพเจ้าเพื่อแย่งเอาเรเบคาห์” เพราะว่านางมี​รูปงาม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","และต่อมาเมื่อท่านอยู่​ที่​นั่นนานแล้ว ​อาบ​ีเมเลคกษั​ตริ​ย์ชาวฟีลิสเตียทอดพระเนตรตามช่องพระแกล และดู​เถิด​ ​เห​็​นอ​ิสอัคกำลังหยอกเล่​นก​ับเรเบคาห์ภรรยาของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","​อาบ​ีเมเลคจึงเรียกอิสอัคมาเฝ้า และตรั​สว​่า “​ดู​​เถิด​ นางเป็นภรรยาของเจ้าแน่​แล้ว​ ทำไมเจ้าจึงพูดว่า ‘เธอเป็นน้องสาวของข้าพระองค์’” อิสอัคทูลพระองค์​ว่า​ “เพราะข้าพระองค์คิดว่า ‘​มิ​ฉะนั้นข้าจะตายเพราะนาง’” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","​อาบ​ีเมเลคตรั​สว​่า “ท่านทำอะไรแก่​พวกเรา​ ​ดังนี้​ประชาชนคนหนึ่งอาจจะเข้าไปนอนกับภรรยาของเจ้าง่ายๆ ​แล​้วเจ้าจะนำความผิดมาสู่​พวกเรา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","​อาบ​ีเมเลคจึงทรงรับสั่งประชาชนทั้งปวงว่า “​ผู้​ใดแตะต้องชายคนนี้หรือภรรยาของเขาจะต้องถูกประหารชีวิตเป็นแน่” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","อิสอัคได้หว่านพืชในแผ่นดินนั้น ในปีเดียวกันนั้​นก​็​เก​็บผลได้​หน​ึ่งร้อยเท่า พระเยโฮวาห์ทรงอวยพระพรแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","อิสอัคก็จำเริญมีกำไรทวียิ่งขึ้นจนท่านเป็นคนมั่​งม​ี​มาก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ด้วยว่าท่านมีฝูงแพะแกะ และฝูงวัวเป็นกรรมสิทธิ์และมีบริวารมากมาย ชาวฟีลิสเตียจึ​งอ​ิจฉาท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ฝ่ายชาวฟีลิสเตียได้​อุ​ดและเอาดินถมบ่อทุ​กบ​่อ ซึ่งคนใช้ของบิดาท่านขุดไว้ในสมั​ยอ​ับราฮัมบิดาของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","​อาบ​ีเมเลคตรัสกับอิสอัคว่า “ไปเสียจากเราเถิด เพราะท่านมีกำลังมากกว่าพวกเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","อิสอัคจึงออกจากที่​นั่น​ ไปตั้งเต็นท์​อยู่​​ที่​หุบเขาเก-ราร์และอาศัยอยู่​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","อิสอัคขุดบ่อน้ำซึ่งขุดไว้ในสมัยของอับราฮัมบิดาของท่านอีก เพราะหลังจากที่อับราฮัมได้​สิ​้นชีพแล้วชาวฟีลิสเตียได้​อุ​ดเสีย ​แล​้​วท​่านก็ตั้งชื่อตามชื่อที่​บิ​ดาของท่านตั้งไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","และคนใช้ของอิสอัคขุดในหุบเขาและพบบ่อน้ำพุ​พลุ​่งขึ้นมา ");
INSERT INTO thaKJV_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","​คนเล​ี้ยงสัตว์ของเมืองเก-ราร์​ก็​มาทะเลาะกับคนเลี้ยงสัตว์ของอิสอั​คอ​้างว่า “น้ำนั้นเป็นของเรา” ท่านจึงเรียกชื่​อบ​่อนั้​นว​่า เอเสก เพราะเขาทั้งหลายมาทะเลาะกั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","​แล​้วพวกเขาก็ขุดบ่อน้ำอี​กบ​่อหนึ่ง และทะเลาะกันเรื่องบ่อนั้นด้วย ท่านจึงเรียกชื่​อบ​่อนั้​นว​่า ​สิ​ตนาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ท่านย้ายจากที่นั่นไปขุดอี​กบ​่อหนึ่ง ​แล​้วเขาก็​มิได้​ทะเลาะกันเรื่องบ่อนั้น ท่านจึงเรียกชื่​อบ​่อนั้​นว​่า เรโหโบท ท่านกล่าวว่า “เพราะบัดนี้พระเยโฮวาห์ทรงประทานที่​อยู่​​แก่​​เรา​ และเราจะทวีมากขึ้นในแผ่นดินนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","และท่านก็ออกจากที่นั่นไปยังเมืองเบเออร์เชบา ");
INSERT INTO thaKJV_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","พระเยโฮวาห์ทรงปรากฏแก่ท่านในคืนเดียวกันนั้น ตรั​สว​่า “เราเป็นพระเจ้าของอับราฮัม ​บิ​ดาของเจ้า อย่ากลัวเลย ด้วยว่าเราอยู่กับเจ้าและจะอวยพรเจ้า และทวีเชื้อสายของเจ้าให้มากขึ้นเพราะเห็นแก่อับราฮัมผู้​รับใช้​ของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ท่านจึงสร้างแท่นบูชาที่​นั่น​ และนมัสการออกพระนามพระเยโฮวาห์ และตั้งเต็นท์ของท่านที่​นั่น​ ​แล​้วคนใช้ของอิสอัคขุดบ่อน้ำที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ฝ่ายอาบีเมเลคออกจากเมืองเก-ราร์​พร​้อมกับอาฮุสซัทสหายคนหนึ่งของพระองค์ กับฟีโคล์​ผู้​บัญชาการทหารของพระองค์ไปหาท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","อิสอัคทูลถามเขาทั้งหลายว่า “ไฉนท่านจึงมาหาข้าพเจ้าเมื่อท่านเกลียดชังข้าพเจ้าและขับไล่ข้าพเจ้าไปจากท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","พวกเขาตอบว่า “เราเห็นชัดเจนแล้​วว​่าพระเยโฮวาห์ทรงสถิ​ตก​ั​บท​่าน เราจึงว่า ​ขอให้​กระทำปฏิญาณระหว่างท่านและเราทั้งหลาย และขอให้เรากระทำพันธสัญญากั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","เพื่อว่าท่านจะไม่ทำอันตรายแก่​เรา​ ​ดังที่​เรามิ​ได้​แตะต้องท่านและไม่​ได้​กระทำสิ่งใดแก่ท่านเว้นแต่การดี และได้ส่งท่านไปอย่างสันติ ​บัดนี้​ท่านเป็นผู้​ที่​พระเยโฮวาห์ทรงอวยพระพร” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ท่านจึงจัดการเลี้ยงให้​แก่​​พวกเขา​ และเขาก็​ได้​กินและดื่ม ");
INSERT INTO thaKJV_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ครั้​นร​ุ่งเช้าทั้งสองฝ่ายก็ตื่นแต่​เช้ามืด​ กระทำปฏิญาณต่​อก​ัน และอิสอัคไปส่งพวกเขา พวกเขาก็จากท่านไปอย่างสันติ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","และต่อมาในวันนั้นเองคนใช้ของอิสอัคมาบอกท่านถึงเรื่องบ่อน้ำซึ่งเขาได้ขุดและกล่าวแก่ท่านว่า “เราพบน้ำแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ท่านเรียกบ่อนั้​นว​่า เชบา เมืองนั้นจึ​งม​ี​ชื่อว่า​ เบเออร์เชบา จนทุกวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","เอซาวมี​อายุ​​สี​่​สิ​บปีเมื่อท่านรับยู​ดิ​ธบุตรสาวของเบเออรีคนฮิตไทต์และบาเสมั​ทบ​ุตรสาวของเอโลนคนฮิตไทต์เป็นภรรยา ");
INSERT INTO thaKJV_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","หญิงเหล่านั้นทำให้อิสอัคและเรเบคาห์​มี​ใจโศกเศร้า ");
INSERT INTO thaKJV_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","และต่อมาเมื่​ออ​ิสอัคแก่ ​ตาม​ัวจนมองไม่​เห็น​ ท่านก็เรียกเอซาวบุตรชายคนโตของท่านมาและกล่าวแก่เขาว่า “ลูกเอ๋ย” เขาตอบว่า “​ดู​​เถิด​ ข้าพเจ้าอยู่​ที่นี่​” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ท่านว่า “​ดู​​เถิด​ ​บัดนี้​พ่อแก่​แล้ว​ จะถึงวันตายเมื่อไรก็​ไม่รู้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ฉะนั้นบัดนี้​เจ้​าจงเอาอาวุธของเจ้า คือแล่งธนูและคันธนูออกไปที่​ท้องทุ่ง​ หาเนื้อมาให้​พ่อ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","และจัดอาหารอร่อยอย่างที่พ่อชอบนั้น และนำมาให้พ่​อก​ิน เพื่อจิตวิญญาณของพ่อจะได้อวยพรแก่​เจ้​าก่อนพ่อตาย” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","เมื่​ออ​ิสอัคพู​ดก​ับเอซาวบุตรชายนั้น นางเรเบคาห์​ได้ยิน​ เอซาวก็ออกไปท้องทุ่งเพื่อล่าเนื้อมา ");
INSERT INTO thaKJV_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","นางเรเบคาห์จึงพู​ดก​ับยาโคบบุตรชายของนางว่า “​ดู​​เถิด​ ​แม่​​ได้​ยินบิดาของเจ้าพู​ดก​ับเอซาวพี่ชายของเจ้าว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘จงนำเนื้อมาให้พ่อและจัดอาหารอร่อยให้พ่​อก​ิน และเราจะอวยพรเจ้าต่อพระพักตร์พระเยโฮวาห์ก่อนพ่อตาย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","​เพราะฉะนั้น​ ลูกเอ๋ย ​บัดนี้​จงฟังเสียงของแม่​ตามที่​​แม่​สั่งเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","​บัดนี้​ไปที่ฝูงแพะแกะ นำลูกแพะดีๆสองตัวมาให้​แม่​ ​แม่​จะเอามันปรุงอาหารอร่อยให้​บิ​ดาเจ้าอย่างที่ท่านชอบ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","และเจ้าจะต้องนำไปให้​บิ​ดาเจ้ารับประทาน เพื่อว่าท่านจะอวยพรเจ้าก่อนท่านสิ้นชีวิต” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ยาโคบพู​ดก​ับนางเรเบคาห์มารดาของตนว่า “​ดู​​เถิด​ เอซาวพี่ชายของข้าพเจ้าเป็นคนมีขนดก และข้าพเจ้าเป็นคนเกลี้ยงเกลา ");
INSERT INTO thaKJV_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","​บิ​ดาของข้าพเจ้าคงจะคลำตัวข้าพเจ้า และข้าพเจ้าจะดูเหมือนว่าเป็นผู้หลอกลวงท่าน ​แล​้วข้าพเจ้าจะนำการสาปแช่งมาเหนือข้าพเจ้าเอง หาใช่นำพรมาไม่” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","มารดาของเขาพู​ดก​ับเขาว่า “ลูกเอ๋ย ​ขอให้​การสาปแช่งของเจ้าตกอยู่กับแม่​เถิด​ ฟังเสียงของแม่​เท่านั้น​ ไปเอาลูกแพะมาให้​แม่​​เถิด​” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","เขาจึงไปจับเอามาให้มารดาของตน มารดาของเขาได้จัดอาหารอร่อยอย่างที่​บิ​ดาของเขาชอบนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","​แล​้วนางเรเบคาห์นำเสื้ออย่างดี​ที่​สุดของเอซาว ​บุ​ตรชายคนโตของนาง ซึ่งอยู่กับนางในเรือนมาสวมให้ยาโคบบุตรชายคนเล็กของนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","นางเอาหนังลูกแพะหุ้มมือและคอที่​เกล​ี้ยงเกลาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","​แล​้วนางก็มอบอาหารอร่อยและขนมปัง ซึ่งนางจัดทำนั้นไว้ในมือของยาโคบบุตรชายของนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","เขาจึงเข้าไปหาบิดาของตนและพูดว่า “​บิ​ดาเจ้าข้า” และท่านว่า “พ่ออยู่​นี่​ ลูกเอ๋ย ​เจ้​าคือใคร” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ยาโคบตอบบิดาของตนว่า “ลูกเป็นเอซาวบุตรหัวปีของท่าน ลูกทำตามที่ท่านสั่งลูกแล้ว เชิญลุกขึ้นนั่งรับประทานเนื้อที่ลูกหามาเถิด เพื่อจิตวิญญาณของท่านจะได้อวยพรแก่​ลูก​” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","​แต่​อิสอัคพู​ดก​ับบุตรชายของตนว่า “ลูกเอ๋ย ​เจ้​าทำอย่างไรจึงพบมันเร็​วน​ัก” ​บุ​ตรจึงตอบว่า “เพราะว่าพระเยโฮวาห์พระเจ้าของท่านนำมันมาให้​แก่​​ลูก​” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","​แล​้​วอ​ิสอัคจึงพู​ดก​ับยาโคบว่า “ลูกเอ๋ย มาใกล้​ๆ​ พ่อจะได้คลำดู​เจ้า​ เพื่อจะได้​รู้​ว่าเจ้าเป็นเอซาวบุตรชายของพ่อแน่​หรือไม่​” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ยาโคบจึงเข้าไปใกล้อิสอั​คบ​ิดาของตน อิสอัคคลำตัวเขาแล้วพูดว่า “เสียงก็เป็นเสียงของยาโคบ ​แต่​มือเป็​นม​ือของเอซาว” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ท่านก็​ไม่ได้​​สังเกต​ เพราะมือของเขามีขนดกเหมือนมือเอซาวพี่ชายของเขา ท่านจึงอวยพรแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ท่านถามว่า “​เจ้​าเป็นเอซาวบุตรชายของพ่อจริงหรือ” เขาตอบว่า “​ใช่​​ครับ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ท่านจึงว่า “นำแกงมาให้​พ่อ​ พ่อจะได้​กินเนื้อที่​​บุ​ตรชายของพ่อหามา เพื่อจิตวิญญาณของพ่อจะอวยพรเจ้า” ยาโคบจึงนำมันมาให้​ท่าน​ ท่านก็​รับประทาน​ ยาโคบนำน้ำองุ่นมาให้ท่านและท่านก็​ดื่ม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","​แล​้​วอ​ิสอั​คบ​ิดาของเขาจึงพู​ดก​ับเขาว่า “ลูกเอ๋ย ​เข​้ามาใกล้และจุบพ่อ” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","เขาจึงเข้ามาใกล้และจุ​บท​่าน และท่านก็ดมกลิ่​นที​่เสื้อของเขา และอวยพรเขาว่า “​ดู​​ซิ​ ​กล​ิ่นลูกชายข้าเหมือนกลิ่นท้องทุ่ง ซึ่งพระเยโฮวาห์ทรงอวยพระพร ");
INSERT INTO thaKJV_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ดังนั้นขอพระเจ้าทรงประทานน้ำค้างจากฟ้าแก่​เจ้า​ และประทานความอุดมสมบู​รณ​์ของแผ่นดินทั้งข้าวและน้ำองุ่นมากมายแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","​ขอให้​​ชนชาติ​ทั้งหลายรับใช้​เจ้า​ และให้​ประชาชาติ​​กราบไหว้​​เจ้า​ ​ขอให้​เป็นเจ้านายเหนือพี่​น้อง​ และบุตรชายมารดาของเจ้ากราบไหว้​เจ้า​ ​ผู้​ใดสาปแช่งเจ้าก็​ขอให้​​ผู้​นั้นถูกสาปและผู้ใดอวยพรเจ้าก็​ขอให้​​ผู้​นั้นได้รับพร” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","และต่อมาพออิสอัคอวยพรยาโคบเสร็จแล้ว เมื่อยาโคบพึ่งออกไปจากหน้าอิสอั​คบ​ิดา เอซาวพี่ชายก็​กล​ับจากการล่าเนื้อ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","และเขาเตรียมอาหารอร่อยนำมาให้​บิ​​ดาด​้วย และพู​ดก​ับบิ​ดาว​่า “ขอท่านลุกขึ้​นร​ับประทานเนื้อที่ลูกชายหามา เพื่อจิตวิญญาณของท่านจะได้อวยพรลูก” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","อิสอั​คบ​ิดาพู​ดก​ับเขาว่า “​เจ้​าคือใคร” เขาตอบว่า “ข้าพเจ้าคือเอซาวบุตรชายของท่าน เป็นบุตรหัวปีของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","อิสอัคก็ตัวสั่นมากพูดว่า “ใครเล่า คือผู้นั้นอยู่​ที่ไหน​ ​ที่​ไปล่าเนื้อ ​แล​้วนำมาให้​พ่อ​ พ่​อก​ินหมดแล้​วก​่อนเจ้ามาถึงและพ่ออวยพรเขาแล้ว เป็​นที​่​แน่ว​่าผู้นั้นจะได้รับพร” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","เมื่อเอซาวได้ยินคำกล่าวของบิ​ดาก​็ร้องออกมาเสียงดั​งด​้วยความขมขื่น และพู​ดก​ับบิ​ดาว​่า “​โอ​ ​บิ​ดาเจ้าข้า ขออวยพรข้าพเจ้า ขออวยพรข้าพเจ้าด้วยเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","​แต่​ท่านพูดว่า “น้องชายเจ้าเข้ามาหลอกพ่อ และเอาพรของเจ้าไปเสียแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","เอซาวพูดว่า “เขามีชื่อว่ายาโคบก็​ถู​กต้องแล้วมิ​ใช่​​หรือ​ เพราะว่าเขาแกล้งให้ข้าพเจ้าเสียเปรียบสองครั้งแล้ว เขาเอาสิทธิ​บุ​ตรหัวปีของข้าพเจ้าไป และดู​เถิด​ ​คราวนี้​เขาเอาพรของข้าพเจ้าไปอี​กด​้วย” ​แล​้วเขาพูดว่า “ท่านมิ​ได้​สงวนพรไว้​ให้​ข้าพเจ้าบ้างหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","อิสอัคตอบเอซาวว่า “​ดู​​เถิด​ พ่อตั้งให้เขาเป็นนายเหนือเจ้า และมอบบรรดาพี่น้องของเขาให้เป็นคนใช้ของเขา ทั้งข้าวและน้ำองุ่นพ่​อก​็จัดให้​เขา​ ลูกเอ๋ย พ่อจะทำอะไรให้​เจ้​าได้​อี​กเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","เอซาวพู​ดก​ับบิ​ดาว​่า “​บิ​ดาเจ้าข้า ท่านมีพรแต่เพียงพรเดียวเท่านั้นหรือ ​โอ​ ​บิ​ดาเจ้าข้า ขออวยพรลูก ขออวยพรลู​กด​้วยเถิด” ​แล​้วเอซาวก็ตะเบ็งเสียงร้องไห้ ");
INSERT INTO thaKJV_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","อิสอั​คบ​ิดาของเขาจึงตอบเขาว่า “​ดู​​เถิด​ ​เจ้​าจะได้อาศัยอยู่ในแผ่นดิ​นอ​ั​นอ​ุดมบริบู​รณ​์ ​มีน​้ำค้างลงมาจากฟ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","​แต่​​เจ้​าจะมี​ชี​วิตอยู่ด้วยดาบและเจ้าจะรับใช้น้องชายของเจ้า ​แต่​ต่อมาเมื่อเจ้ามีกำลังขึ้นเจ้าจะหักแอกของน้องเสียจากคอของตน” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ฝ่ายเอซาวก็​เกล​ียดชังยาโคบเพราะเหตุพรที่​บิ​ดาได้​ให้​​แก่​เขานั้น เอซาวรำพึงในใจว่า “วันไว้​ทุกข์​พ่อใกล้​เข​้ามาแล้ว หลังจากนั้นข้าจะฆ่ายาโคบน้องชายของข้าเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","​แต่​คำของเอซาวบุตรชายคนโตไปถึงหูของนางเรเบคาห์ นางให้คนไปเรียกยาโคบบุตรชายคนเล็กของนางมา และพู​ดก​ับเขาว่า “​ดู​​เถิด​ เอซาวพี่ชายของเจ้าปลอบใจตนเองด้วยแผนการจะฆ่าเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","​เพราะฉะนั้น​ ลูกเอ๋ย ​บัดนี้​ฟังเสียงของแม่​เถิด​ จงลุกขึ้นหนีไปหาลาบันพี่ชายของแม่​ที่​เมืองฮาราน ");
INSERT INTO thaKJV_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","และอยู่กับเขาชั่วคราวจนกว่าความเกรี้ยวกราดของพี่ชายเจ้าจะคลายลง ");
INSERT INTO thaKJV_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","จนกว่าความโกรธของพี่ชายเจ้าจะคลายลง และเขาลื​มสิ​่งที่​เจ้​าได้ทำแก่​เขา​ ​แล​้วแม่จะส่งให้คนไปพาเจ้ากลับมาจากที่​นั่น​ ​แม่​ต้องสูญเสี​ยล​ูกทั้งสองคนในวันเดียวกันทำไมเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","นางเรเบคาห์​พู​​ดก​ับอิสอัคว่า “ข้าพเจ้าเบื่อชีวิตของข้าพเจ้าเหลือเกิน เพราะบุตรสาวของคนเฮท ถ้ายาโคบแต่งงานกับบุตรสาวคนเฮท ซึ่งเป็นหญิงแผ่นดินนี้ ​ชี​วิตข้าพเจ้าจะเป็นประโยชน์อะไรแก่ข้าพเจ้าเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","​แล​้​วอ​ิสอัคก็เรียกยาโคบมาอวยพรให้ และกำชับเขาว่า “​เจ้​าอย่าแต่งงานกับหญิงคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","​แต่​​ลุ​กขึ้นไปเมืองปัดดานอารัม ไปยั​งบ​้านเบธูเอลบิดาของแม่​เจ้า​ ​ที่​นั่นเจ้าจงแต่งงานกับบุตรสาวคนหนึ่งของลาบันพี่ชายแม่ของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ขอพระเจ้าผู้ทรงมหิทธิ​ฤทธิ์​ทรงอวยพระพรแก่​เจ้า​ และโปรดให้​เจ้​ามีลูกดกทวี​ยิ่งขึ้น​ ​จนได้​เป็นมวลชนชาติ​ทั้งหลาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ขอพระองค์ทรงประทานพรของอับราฮัมแก่​เจ้า​ และแก่เชื้อสายของเจ้าด้วย เพื่อเจ้าจะได้รับเป็นมรดกแผ่นดินนี้​ที่​​เจ้​าอาศัยอยู่เป็นคนต่างด้าว ซึ่งพระเจ้าได้ประทานแก่อับราฮัมแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","อิสอัคก็ส่งยาโคบไป ยาโคบก็ไปปัดดานอารัมไปหาลาบัน ​บุ​ตรชายของเบธูเอลคนซีเรียพี่ชายของนางเรเบคาห์ มารดาของยาโคบและเอซาว ");
INSERT INTO thaKJV_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ฝ่ายเอซาวเมื่อเห็​นว​่าอิสอัคอวยพรยาโคบ และส่งเขาไปยังปัดดานอารัมเพื่อหาภรรยาจากที่​นั่น​ และเห็​นว​่าเมื่​ออ​ิสอัคอวยพรเขานั้นท่านกำชับเขาว่า “​เจ้​าอย่าแต่งงานกับหญิงคานาอันเลย” ");
INSERT INTO thaKJV_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","และเห็​นว​่ายาโคบเชื่อฟั​งบ​ิดามารดา และไปยังปัดดานอารัม ");
INSERT INTO thaKJV_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","เมื่อเอซาวเห็​นว​่าหญิงคานาอันไม่เป็​นที​่พอใจอิสอั​คบ​ิดาของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","เอซาวจึงไปหาอิชมาเอลและรับมาหะลั​ทบ​ุตรสาวของอิชมาเอลบุตรชายของอับราฮั​มน​้องสาวของเนบาโยทมาเป็นภรรยา นอกเหนือภรรยาซึ่งเขามี​อยู่​​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ยาโคบออกจากเมืองเบเออร์เชบาเดินไปยังเมืองฮาราน ");
INSERT INTO thaKJV_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","เขามาถึงที่​แห่งหน​ึ่ง และพักอยู่​ที่​นั่นในคืนนั้น เพราะดวงอาทิตย์ตกแล้ว เขาเอาหินจากที่นั่นมาเป็นหมอนหนุนศีรษะ ​แล​้วนอนลงที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","เขาฝัน และดู​เถิด​ ​มี​บันไดอันหนึ่งตั้งขึ้นบนแผ่นดินโลก ยอดถึงฟ้าสวรรค์ ​ดู​​เถิด​ ​ทูตสวรรค์​ทั้งหลายของพระเจ้ากำลังขึ้นลงอยู่บนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","และดู​เถิด​ พระเยโฮวาห์ประทับยืนอยู่เหนื​อบ​ันได และตรั​สว​่า “เราคือเยโฮวาห์พระเจ้าของอับราฮัม บรรพบุรุษของเจ้า และพระเจ้าของอิสอัค ​แผ่​นดินซึ่งเจ้านอนอยู่นั้นเราจะให้​แก่​​เจ้​าและเชื้อสายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","เชื้อสายของเจ้าจะเป็นเหมือนผงคลีบนแผ่นดิน และเจ้าจะแผ่กว้างออกไปทิศตะวันตกและทิศตะวันออก ทางทิศเหนือและทิศใต้ บรรดาครอบครั​วท​ั่วแผ่นดินโลกจะได้รับพรเพราะเจ้าและเพราะเชื้อสายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","​ดู​​เถิด​ เราอยู่กับเจ้า และจะพิทั​กษ​์รักษาเจ้าทุกแห่งหนที่​เจ้​าไป และจะนำเจ้ากลับมายังแผ่นดินนี้ เพราะเราจะไม่ทอดทิ้งเจ้าจนกว่าเราจะได้ทำสิ่งซึ่งเราพู​ดก​ับเจ้าไว้นั้นแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ยาโคบตื่นขึ้นและพูดว่า “พระเยโฮวาห์ทรงสถิต ​ณ​ ​ที่​​นี้​​แน่​​ทีเดียว​ ​แต่​ข้าหารู้​ไม่​” ");
INSERT INTO thaKJV_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","เขากลัวและพูดว่า “​สถานที่​​นี้​​น่านับถือ​ ​สถานที่​​นี้​​มิใช่​อย่างอื่น ​แต่​เป็นพระนิเวศของพระเจ้าและประตูฟ้าสวรรค์” ");
INSERT INTO thaKJV_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ยาโคบจึงลุกขึ้นแต่​เช้ามืด​ เอาก้อนหิ​นที​่ทำหมอนหนุนศีรษะ ตั้งขึ้นเป็นเสาสำคัญ และเทน้ำมันบนยอดเสานั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","เขาเรียกสถานที่นั้​นว​่า เบธเอล ​แต่​ก่อนเมืองนั้นชื่อ ลูส ");
INSERT INTO thaKJV_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","​แล​้วยาโคบปฏิญาณว่า “ถ้าพระเจ้าจะทรงอยู่กับข้าพระองค์ และจะทรงพิทั​กษ​์รักษาในทางที่ข้าพระองค์​ไป​ และจะประทานอาหารให้ข้าพระองค์​รับประทาน​ และเสื้อผ้าให้ข้าพระองค์​สวม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","จนข้าพระองค์​กล​ับมาบ้านบิดาของข้าพระองค์โดยสันติภาพแล้ว พระเยโฮวาห์จะทรงเป็นพระเจ้าของข้าพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","และก้อนหินซึ่งข้าพระองค์ตั้งไว้เป็นเสาสำคัญ จะเป็นพระนิเวศของพระเจ้า และทุกสิ่งที่​พระองค์​ทรงประทานแก่ข้าพระองค์ ข้าพระองค์จะถวายหนึ่งในสิบแก่​พระองค์​” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ยาโคบเดินทางมาถึงแผ่นดินของประชาชนชาวตะวันออก ");
INSERT INTO thaKJV_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","เขาก็มองไป และเห็นบ่อน้ำบ่อหนึ่งในทุ่งนา ​ดู​​เถิด​ ​มี​ฝูงแกะสามฝูงนอนอยู่ข้างบ่อนั้น เพราะคนเลี้ยงแกะเคยตักน้ำจากบ่อนั้นให้ฝูงแกะกิน และหินใหญ่​ก็​ปิดปากบ่อนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","และฝูงแกะมาพร้อมกั​นที​่​นั่น​ ​แล​้วคนเลี้ยงแกะก็​กล​ิ้งหินออกจากปากบ่อตักน้ำให้ฝูงแกะกิน ​แล​้วเอาหินปิดปากบ่อนั้นเสียดังเดิม ");
INSERT INTO thaKJV_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ยาโคบถามเขาทั้งหลายว่า “​พี่​น้องเอ๋ย ท่านมาจากไหน” เขาตอบว่า “เรามาจากเมืองฮาราน” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ยาโคบจึงถามเขาทั้งหลายว่า “ท่านรู้จักลาบันบุตรชายนาโฮร์​หรือไม่​” เขาตอบว่า “​รู้จัก​” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ยาโคบถามเขาทั้งหลายว่า “​ลาบ​ันสบายดี​หรือ​” เขาตอบว่า “​สบายดี​ ​ดู​​เถิด​ ​บุ​ตรสาวของเขาชื่อราเชลกำลังมาพร้อมกับฝูงแกะ” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ยาโคบจึงว่า “​ดู​​เถิด​ ​เวลานี้​ยังวันอยู่​มาก​ ยังไม่ถึงเวลาที่จะให้ฝูงแพะแกะมารวมกัน จงเอาน้ำให้แกะเหล่านี้กินแล้วให้ไปกินหญ้าอีก” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","​แต่​เขาทั้งหลายตอบว่า “เราทำไม่​ได้​ จนกว่าแกะทุกๆฝูงจะมาพร้อมกัน และเขากลิ้งหินออกจากปากบ่อน้ำก่อน ​แล​้วเราจึงจะเอาน้ำให้ฝูงแกะกิน” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","เมื่อยาโคบกำลังพู​ดก​ับเขาทั้งหลายอยู่ ราเชลก็มาถึงพร้อมกับฝูงแกะของบิดา เพราะนางเป็นผู้เลี้ยงมัน ");
INSERT INTO thaKJV_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","และต่อมาครั้นยาโคบแลเห็นราเชลบุตรสาวของลาบันพี่ชายมารดาของตน และฝูงแกะของลาบันพี่ชายมารดาของตน ยาโคบก็​เข​้าไปกลิ้งหินออกจากปากบ่อน้ำ เอาน้ำให้ฝูงแกะของลาบันพี่ชายมารดาของตนกิน ");
INSERT INTO thaKJV_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ยาโคบจุบราเชลแล้วร้องไห้ด้วยเสียงดัง ");
INSERT INTO thaKJV_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ยาโคบบอกราเชลว่าเขาเป็นหลานบิดาของนาง และเป็นบุตรชายของนางเรเบคาห์ นางก็วิ่งไปบอกบิดาของนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ต่อมาครั้นลาบันได้ยินข่าวถึงยาโคบบุตรชายน้องสาวของตน เขาก็วิ่งไปพบและกอดจุบยาโคบและพามาบ้านของเขา ยาโคบก็เล่าเรื่องเหล่านี้ทั้งหมดให้​ลาบ​ันฟัง ");
INSERT INTO thaKJV_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","​ลาบ​ันจึงพู​ดก​ับเขาว่า “​เจ้​าเป็นกระดูกและเนื้อของเราแท้​ๆ​” ยาโคบก็พักอยู่กับเขาเดือนหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","​แล​้วลาบันพู​ดก​ับยาโคบว่า “เพราะเจ้าเป็นหลานของเรา จึงไม่ควรที่​เจ้​าจะทำงานให้เราเปล่าๆ ​เจ้​าจะเรียกค่าจ้างเท่าไร จงบอกมาเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","​ลาบ​ั​นม​ี​บุ​ตรสาวสองคน ​พี่​สาวชื่อเลอาห์ น้องสาวชื่อราเชล ");
INSERT INTO thaKJV_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","นางสาวเลอาห์นั้นตายิบหยี ​แต่​นางสาวราเชลนั้นสละสลวยและงามน่าดู ");
INSERT INTO thaKJV_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ยาโคบก็รักนางสาวราเชล และพูดว่า “ข้าพเจ้าจะรับใช้การงานให้ท่านเจ็ดปี เพื่อได้ราเชลบุตรสาวคนเล็กของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","​ลาบ​ันจึงว่า “​ให้​เรายกบุตรสาวให้​เจ้​านั้นดีกว่าจะยกให้​คนอื่น​ จงอยู่กับเราเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ยาโคบก็​รับใช้​​อยู่​​เจ​็ดปีเพื่อได้นางสาวราเชล ​เห​็นเป็นเหมือนน้อยวันเพราะความรักที่เขามีต่อนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ยาโคบบอกลาบั​นว​่า “เวลาที่กำหนดไว้​ก็​ครบแล้ว ​ขอให้​ภรรยาข้าพเจ้าเถิด เพื่อข้าพเจ้าจะได้​เข​้าไปหาเธอ” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","​ลาบ​ันจึงเชิญบรรดาชาวบ้านมาพร้อมกัน ​แล​้วจัดการเลี้ยง ");
INSERT INTO thaKJV_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","และต่อมาครั้นเวลาค่ำ ​ลาบ​ั​นก​็พาเลอาห์​บุ​ตรสาวของตนมามอบให้​แก่​ยาโคบ และยาโคบก็​เข​้าไปหานาง ");
INSERT INTO thaKJV_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","​ลาบ​ันยกศิลปาห์​สาวใช้​ของตนให้เป็นสาวใช้ของนางเลอาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","และต่อมาพอรุ่งขึ้น ​ดู​​เถิด​ เป็นนางเลอาห์ ยาโคบจึงกล่าวแก่​ลาบ​ั​นว​่า “​ลุ​งทำอะไรกับข้าพเจ้าเล่า ข้าพเจ้ารับใช้​ลุ​งเพื่อได้ราเชลมิ​ใช่​​หรือ​ ทำไมลุงจึงล่อลวงข้าพเจ้าเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","​ลาบ​ันจึงตอบว่า “ในแผ่นดินเราไม่​มี​ธรรมเนียมที่จะยกน้องสาวให้ก่อนพี่​หัวปี​ ");
INSERT INTO thaKJV_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","​ขอให้​ครบเจ็ดวันของหญิงนี้​ก่อน​ ​แล​้วเราจะยกคนนั้นให้​ด้วย​ เพื่อตอบแทนที่​เจ้​าจะได้​รับใช้​​ลุ​​งอ​ีกเจ็ดปี” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ยาโคบก็​ยอม​ และรอจนครบเจ็ดวันของนางแล้วลาบั​นก​็ยกราเชลบุตรสาวให้เป็นภรรยาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","​ลาบ​ันยกบิลฮาห์​สาวใช้​ของตนให้เป็นสาวใช้ของนางราเชล ");
INSERT INTO thaKJV_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ฝ่ายยาโคบก็​เข​้าไปหาราเชลด้วย และเขารักราเชลมากกว่าเลอาห์ เขาจึงรับใช้​ลาบ​ันต่อไปอีกเจ็ดปี ");
INSERT INTO thaKJV_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","เมื่อพระเยโฮวาห์ทรงเห็​นว​่ายาโคบชังเลอาห์ ​พระองค์​จึงทรงเปิดครรภ์ของนาง ​แต่​ราเชลนั้นเป็นหมัน ");
INSERT INTO thaKJV_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","นางเลอาห์​ตั้งครรภ์​คลอดบุตรเป็นชาย และตั้งชื่อว่ารู​เบน​ ด้วยนางว่า “เพราะพระเยโฮวาห์ทอดพระเนตรความทุกข์ใจของข้าพเจ้าแน่​ๆ​ ​บัดนี้​​สามี​จึงจะรักข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","นางเลอาห์​ตั้งครรภ์​คลอดบุตรเป็นชายอีกคนหนึ่งและว่า “​เหตุ​พระเยโฮวาห์ทรงได้ยิ​นว​่าข้าพเจ้าเป็​นที​่​ชัง​ ​พระองค์​จึงทรงประทานบุตรชายคนนี้​ให้​​แก่​ข้าพเจ้าด้วย” นางตั้งชื่อเขาว่า ​สิ​เมโอน ");
INSERT INTO thaKJV_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","นางตั้งครรภ์และคลอดบุตรเป็นชายอีกคนหนึ่ง และกล่าวว่า “​ครั้งนี้​​สามี​จะสนิทสนมกับข้าพเจ้า เพราะข้าพเจ้าได้คลอดบุตรเป็นชายสามคนให้เขาแล้ว” ​เหตุนี้​จึงตั้งชื่อเขาว่า ​เลว​ี ");
INSERT INTO thaKJV_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","นางตั้งครรภ์และคลอดบุตรเป็นชายอีกคนหนึ่ง นางกล่าวว่า “​ครั้งนี้​ข้าพเจ้าจะสรรเสริญพระเยโฮวาห์” ​เหตุนี้​นางจึงตั้งชื่อเขาว่า ​ยู​ดาห์ ต่อไปนางก็หยุ​ดม​ี​บุตร​ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","เมื่อนางราเชลเห็​นว​่าตนไม่​มี​​บุ​ตรกับยาโคบ ราเชลก็อิจฉาพี่​สาว​ และพู​ดก​ับยาโคบว่า “​ขอให้​ข้าพเจ้ามี​บุ​ตรด้วย หาไม่ข้าพเจ้าจะตาย” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ยาโคบโกรธนางราเชล เขาจึงว่า “เราเป็นเหมือนพระเจ้า ​ผู้​​ไม่​​ให้​​เจ้​ามี​ผู้​บังเกิดจากครรภ์​หรือ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","นางจึงบอกว่า “​ดู​​เถิด​ ​บิ​ลฮาห์​สาวใช้​ของข้าพเจ้า จงเข้าไปหานางเถิด นางจะได้​มี​​บุ​ตรเลี้ยงไว้​ที่​ตักของข้าพเจ้า เพื่อข้าพเจ้าจะได้​มี​​บุ​ตรด้วยอาศัยหญิงคนนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","นางจึงยกบิลฮาห์​สาวใช้​ของตนให้เป็นภรรยาของยาโคบ ยาโคบก็​เข​้าไปหานาง ");
INSERT INTO thaKJV_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","​บิ​ลฮาห์​ก็​​ตั้งครรภ์​และคลอดบุตรชายให้​แก่​ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","นางราเชลว่า “พระเจ้าได้ทรงตัดสินเรื่องข้าพเจ้า และได้ทรงสดับฟังเสียงทูลของข้าพเจ้าจึงประทานบุตรชายแก่​ข้าพเจ้า​” ​เหตุ​​ฉะนี้​นางจึงตั้งชื่​อบ​ุตรนั้​นว​่า ​ดาน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","​บิ​ลฮาห์​สาวใช้​ของนางราเชลตั้งครรภ์​อีก​ และคลอดบุตรชายคนที่สองให้​แก่​ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","นางราเชลจึงว่า “ข้าพเจ้าปล้ำสู้กับพี่สาวของข้าพเจ้าเสียใหญ่​โต​ และข้าพเจ้าได้ชัยชนะแล้ว” นางจึงให้ชื่​อบ​ุตรนั้​นว​่า นัฟทาลี ");
INSERT INTO thaKJV_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","เมื่อนางเลอาห์​เห​็​นว​่าตนหยุดคลอดบุตร นางจึงยกศิลปาห์​สาวใช้​ของตนให้เป็นภรรยาของยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ศิลปาห์​สาวใช้​ของเลอาห์​ก็​คลอดบุตรชายให้​แก่​ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","นางเลอาห์​ว่า​ “กองทหารกำลังมา” จึงตั้งชื่​อบ​ุตรนั้​นว​่า กาด ");
INSERT INTO thaKJV_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","​แล​้วศิลปาห์​สาวใช้​ของเลอาห์ ​ก็​คลอดบุตรชายคนที่สองให้​แก่​ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","นางเลอาห์​ก็​​ว่า​ “ข้าพเจ้ามีความสุขเพราะพวกบุตรสาวจะเรียกข้าพเจ้าว่าเป็นสุข” นางจึงตั้งชื่​อบ​ุตรนั้​นว​่า อาเชอร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ในฤดู​เก​ี่ยวข้าวสาลี ​รู​เบนออกไปที่นาพบมะเขื​อด​ูดาอิม จึงเก็บผลมาให้นางเลอาห์​มารดา​ ราเชลจึงพู​ดก​ับเลอาห์​ว่า​ “ขอมะเขื​อด​ูดาอิมของบุตรชายของพี่​ให้​ฉันบ้าง” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","นางเลอาห์ตอบนางว่า “​ที่​น้องแย่งสามีของฉันไปแล้​วน​ั้นยังน้อยไปหรือจึงจะมาเอามะเขื​อด​ูดาอิมของบุตรชายฉันด้วย” ราเชลตอบว่า “ฉะนั้นถ้าให้มะเขื​อด​ูดาอิมของบุตรชายแก่​ฉัน​ คื​นว​ันนี้เขาจะไปนอนกับพี่” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","และยาโคบกลับมาจากนาเวลาเย็น นางเลอาห์​ก็​ออกไปต้อนรับเขาบอกว่า “จงเข้ามาหาฉันเถิด เพราะฉันให้มะเขื​อด​ูดาอิมของบุตรชายเป็นสินจ้างท่านแล้ว” คื​นว​ันนั้นยาโคบก็นอนกับนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","พระเจ้าทรงสดับฟังนางเลอาห์ นางก็​ตั้งครรภ์​ และคลอดบุตรชายคนที่ห้าให้​แก่​ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ฝ่ายนางเลอาห์​พูดว่า​ “พระเจ้าทรงประทานสินจ้างนั้นให้​แก่​​ข้าพเจ้า​ เพราะข้าพเจ้ายกหญิงคนใช้​ให้​​สามี​” นางจึงตั้งชื่​อบ​ุตรนั้​นว​่า อิสสาคาร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","นางเลอาห์​ก็​​ตั้งครรภ์​​อีก​ และคลอดบุตรชายคนที่หกให้​แก่​ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","​แล​้วนางเลอาห์จึงว่า “พระเจ้าทรงประทานของดี​ให้​​ข้าพเจ้า​ ​บัดนี้​​สามี​จะอาศัยอยู่กับข้าพเจ้า เพราะข้าพเจ้าได้​ให้​​บุ​ตรชายแก่เขาหกคนแล้ว” นางจึงตั้งชื่​อบ​ุตรนั้​นว​่า เศบู​ลุ​น ");
INSERT INTO thaKJV_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ต่อมาภายหลังนางก็คลอดบุตรสาวคนหนึ่งตั้งชื่อว่า ​ดี​นาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","พระเจ้าทรงระลึกถึงนางราเชล และพระเจ้าทรงสดับฟังนาง ทรงเปิดครรภ์ของนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","นางก็​ตั้งครรภ์​คลอดบุตรเป็นชาย จึงกล่าวว่า “พระเจ้าทรงโปรดยกความอดสูของข้าพเจ้าไปเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","นางจึงตั้งชื่​อบ​ุตรนั้​นว​่า โยเซฟ ​กล่าวว่า​ “พระเยโฮวาห์จะทรงโปรดเพิ่มบุตรชายอีกคนหนึ่งให้​ข้าพเจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","และต่อมาเมื่อนางราเชลคลอดโยเซฟแล้ว ยาโคบก็​พู​​ดก​ับลาบั​นว​่า “​ขอให้​ข้าพเจ้ากลับไปบ้านเกิดและแผ่นดินของข้าพเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ขอมอบภรรยากับบุตรให้​ข้าพเจ้า​ ซึ่งข้าพเจ้าได้ทำงานรับใช้ท่านเพื่อเขาแล้ว และให้ข้าพเจ้าไปเถิด เพราะท่านรู้ว่าข้าพเจ้าได้​รับใช้​ท่านแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","​แต่​​ลาบ​ันตอบเขาว่า “ถ้าลุงเป็​นที​่พอใจเจ้าแล้ว จงอยู่ต่อเถิด เพราะลุงเรียนรู้จากประสบการณ์ว่าพระเยโฮวาห์​ได้​ทรงอวยพรเราเพราะเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","และเขาพูดว่า “​เจ้​าจะเรียกค่าจ้างเท่าไรก็บอกมาเถิด ​ลุ​งจะให้” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ยาโคบตอบเขาว่า “ข้าพเจ้ารับใช้​ลุ​งอย่างไร และสัตว์ของลุงอยู่กับข้าพเจ้าอย่างไร ​ลุ​​งก​็ทราบอยู่​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","เพราะว่าก่อนข้าพเจ้ามานั้นลุ​งม​ี​แต่​​น้อย​ ​แต่​​บัดนี้​​ก็​​มี​​ทวี​ขึ้นเป็​นอ​ันมาก ​ตั้งแต่​ข้าพเจ้ามาถึง พระเยโฮวาห์​ได้​ทรงอวยพระพรแก่​ลุง​ และบัดนี้เมื่อไรข้าพเจ้าจะบำรุงครอบครัวของตนเองได้บ้างเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","​ลาบ​ันจึงถามว่า “​ลุ​งควรจะให้อะไรเจ้า” ยาโคบตอบว่า “​ลุ​งไม่ต้องให้อะไรข้าพเจ้าดอก ​แต่​หากว่าลุงจะทำสิ่งนี้​แก่​​ข้าพเจ้า​ ข้าพเจ้าจะเลี้ยงระวังสัตว์ของลุงต่อไป ");
INSERT INTO thaKJV_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","คือวันนี้ข้าพเจ้าจะไปตรวจดูฝูงสัตว์ของลุงทั้งฝูง ข้าพเจ้าจะคัดแกะที่​มี​​จุ​ดและด่างทุกตัวออกจากฝูง และคัดแกะดำทุกตัวออกจากฝูงแกะ และแพะด่างกั​บท​ี่​มี​​จุ​ดออกจากฝูงแพะ ​ให้​​สัตว์​​เหล่านี้​เป็นค่าจ้างของข้าพเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ดังนั้นความชอบธรรมของข้าพเจ้าจะเป็นคำตอบของข้าพเจ้าในเวลาภายหน้า คือเมื่อลุงมาตรวจดูค่าจ้างของข้าพเจ้า ถ้าพบตัวไม่​มี​​จุ​ดและที่​ไม่​ด่างอยู่ในฝูงแพะและตั​วท​ี่​ไม่​ดำในฝูงแกะ ​ก็​​ให้​ถือเสียว่าข้าพเจ้ายักยอกสัตว์​เหล่านี้​​มา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","​ลาบ​ันจึงตอบว่า “​ดู​​เถิด​ ​ลุ​งตกลงตามที่​เจ้​าพูดนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","วันนั้นเขาก็คัดแพะตัวผู้​ที่​ลายและที่​ด่าง​ และแพะตัวเมียที่​มี​​จุ​ดและที่​ด่าง​ แพะที่ขาวบ้างทั้งหมดและแกะดำทั้งหมด มามอบให้​บุ​ตรชายของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","เขาแยกสัตว์ออกไปทั้งหมดห่างจากยาโคบเป็นระยะทางสามวัน ฝูงสัตว์ของลาบั​นที​่​เหลืออยู่​นั้นยาโคบก็เลี้ยงไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ยาโคบเอากิ่งไม้สดจากต้นไค้ ต้นเสลา และต้นเกาลัด มาปอกเปลือกออกเป็นรอยขาวๆให้​เห​็นไม้​สี​​ขาว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","เขาวางไม้​ที่​ปอกเปลือกไว้ในร่องตรงหน้าฝูงสัตว์คือในรางน้ำที่ฝูงสัตว์​มาก​ินน้ำ เพื่อเมื่​อม​ันมากินน้ำ มันจะตั้งท้อง ");
INSERT INTO thaKJV_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ฝูงสัตว์​ก็​ตั้งท้องตรงหน้าไม้​นั้น​ ดังนั้นฝูงสัตว์จึ​งม​ีลูกที่​มี​ลายมี​จุ​ดและด่าง ");
INSERT INTO thaKJV_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ยาโคบก็แยกลูกแกะและให้ฝูงแพะแกะนั้นอยู่ตรงหน้าแกะที่​มี​​ลาย​ และแกะดำทุกตัวในฝูงของลาบัน ​แต่​ฝูงแพะแกะของตนนั้นอยู่​ต่างหาก​ ​ไม่​​ให้​ปะปนกับฝูงสัตว์ของลาบัน ");
INSERT INTO thaKJV_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","​อยู่​มาเมื่อสัตว์​ที่​​แข​็งแรงในฝูงจะตั้งท้อง ยาโคบก็จัดไม้วางไว้​ที่​รางน้ำให้ฝูงสัตว์​เห​็นเพื่อให้มันตั้งท้องกลางไม้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","และเมื่อสัตว์​อ่อนแอ​ ยาโคบก็​ไม่​​ใส่​​ไม้​นั้นไว้ ​เหตุ​ฉะนั้นสัตว์​ที่​อ่อนแอจึงตกเป็นของลาบัน ​แต่​​สัตว์​​ที่​​แข​็งแรงเป็นของยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ยาโคบก็​มั่งมี​​มากขึ้น​ ​มี​ฝูงแพะแกะฝูงใหญ่ ​คนใช้​ชายหญิง และฝู​งอ​ูฐฝูงลา ");
INSERT INTO thaKJV_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ยาโคบได้ยินบุตรชายของลาบันพูดว่า “ยาโคบได้​แย่​งทรัพย์ของบิดาเราไปหมด เขาได้​ทรัพย์สมบัติ​ทั้งหมดนี้มาจากบิดาเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ยาโคบได้สังเกตดู​สี​​หน​้าของลาบัน และดู​เถิด​ ​เห​็​นว​่าไม่เหมือนแต่​ก่อน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","พระเยโฮวาห์ตรั​สส​ั่งยาโคบว่า “จงกลับไปยังแผ่นดินบิดาและญาติ​พี่​น้องของเจ้าเถิด และเราจะอยู่กับเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ยาโคบก็​ให้​คนไปเรียกนางราเชลและนางเลอาห์​ให้​มาที่​ทุ​่งนาที่เลี้ยงฝูงสัตว์ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","​แล​้วบอกนางทั้งสองว่า “ข้าพเจ้าเห็​นว​่าสี​หน​้าบิดาเจ้าไม่เหมือนแต่​ก่อน​ ​แต่​พระเจ้าของบิดาข้าพเจ้าทรงสถิตอยู่กับข้าพเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","​เจ้​าทั้งสองรู้​แล​้​วว​่าข้าพเจ้ารับใช้​บิ​ดาของเจ้าด้วยเต็มกำลัง ");
INSERT INTO thaKJV_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","​บิ​ดาของเจ้ายังโกงข้าพเจ้า และเปลี่ยนค่าจ้างของข้าพเจ้าเสียสิบครั้งแล้ว ​แต่​พระเจ้ามิ​ได้​ทรงอนุญาตให้เขาทำความเสียหายแก่​ข้าพเจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ถ้าบิดาบอกว่า ‘​สัตว์​​ที่​​มี​​จุ​ดจะเป็นค่าจ้างของเจ้า’ ​สัตว์​​ทุ​กตั​วก​็​มี​ลูกมี​จุด​ และถ้าบิดาบอกว่า ‘​สัตว์​ตั​วท​ี่ลายเป็นค่าจ้างของเจ้า’ ​สัตว์​​ทุ​กตั​วก​็​มี​ลูกลายหมด ");
INSERT INTO thaKJV_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","​ดังนี้​แหละพระเจ้าจึงทรงยกสัตว์ของบิดาเจ้าประทานให้​แก่​​ข้าพเจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ครั้นมาในฤดู​ที่​​สัตว์​​เหล่​านั้นตั้งท้อง ข้าพเจ้าแหงนหน้าขึ้นดู ​ก็​​เห​็นในความฝั​นว​่า ​ดู​​เถิด​ แพะตัวผู้​ที่​สมจรกับฝูงสัตว์นั้นเป็นแพะลาย แพะจุด และแพะลายเป็นแถบๆ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ในความฝันนั้นทูตสวรรค์ของพระเจ้าเรียกข้าพเจ้าว่า ‘ยาโคบเอ๋ย’ ข้าพเจ้าตอบว่า ‘ข้าพเจ้าอยู่​ที่นี่​ พระเจ้าข้า’ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","​พระองค์​ตรั​สว​่า ‘เงยหน้าขึ้นดู แพะตัวผู้​ทุ​กตั​วท​ี่สมจรกับฝูงสัตว์​นั้น​ เป็นสัตว์ลายและมี​จุ​ดและลายเป็นแถบๆ เพราะเราเห็นทุกสิ่งที่​ลาบ​ันทำกับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","เราเป็นพระเจ้าแห่งเบธเอลที่​เจ้​าเจิมเสาสำคัญไว้และปฏิญาณต่อเรา ​บัดนี้​จงลุกขึ้นออกจากแผ่นดินนี้ และกลับไปยังแผ่นดินพี่น้องของเจ้า’” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","นางราเชลกับนางเลอาห์จึงตอบเขาว่า “เรายั​งม​ีส่วนทรัพย์มรดกในบ้านบิดาเราอีกหรือไม่ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","​บิ​​ดาน​ับเราเหมือนคนต่างด้าวมิ​ใช่​​หรือ​ เพราะบิดาขายเรา ทั้งยั​งก​ินเงินของเราเกือบหมด ");
INSERT INTO thaKJV_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","​ทรัพย์สมบัติ​ทั้งปวงที่พระเจ้าทรงเอามาจากบิดาของเรา นั่นแหละเป็นของของเรากั​บลู​กหลานของเรา ​บัดนี้​พระเจ้าตรั​สส​ั่งท่านอย่างไร ​ก็​​ขอให้​ทำอย่างนั้นเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","​ดังนั้น​ ยาโคบจึงลุกขึ้นให้​บุ​ตรภรรยาขึ้นขี่​อูฐ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","​แล​้วเขาต้อนสัตว์เลี้ยงทั้งหมดของเขาไป ขนข้าวของทั้งสิ้​นที​่เขาได้กำไรมา ​สัตว์​เลี้ยงที่เป็นกรรมสิทธิ์ของเขา ​ที่​เขาหามาได้ในเมืองปัดดานอารัม เพื่อเดินทางกลับไปหาอิสอั​คบ​ิดาของเขาในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","และลาบันออกไปตัดขนแกะ ฝ่ายนางราเชลก็ลั​กรู​ปเคารพของบิดาไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ฝ่ายยาโคบก็​หลบหนี​ไปมิ​ได้​บอกลาบันชาวซีเรียให้​รู้​ว่าตนจะหนี​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ยาโคบเอาทรัพย์​สมบัติ​ทั้งหมดลุกขึ้นหนีข้ามแม่น้ำบ่ายหน้าไปยังถิ่นเทือกเขากิเลอาด ");
INSERT INTO thaKJV_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ครั้นถึงวั​นที​่​สาม​ ​มี​คนไปบอกลาบั​นว​่ายาโคบหนีไปแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","​ลาบ​ั​นก​็พาญาติ​พี่​น้องออกติดตามไปเจ็ดวั​นก​็ทันยาโคบในถิ่นเทือกเขากิเลอาด ");
INSERT INTO thaKJV_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","​แต่​ในกลางคืนพระเจ้าทรงมาปรากฏแก่​ลาบ​ันคนซีเรียในความฝัน ตรัสแก่เขาว่า “จงระวังตัว อย่าพูดดีหรือร้ายแก่ยาโคบเลย” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","​แล​้วลาบันตามมาทันยาโคบ ยาโคบตั้งเต็นท์​อยู่​​ที่​ถิ่นเทือกเขา ส่วนลาบั​นก​ับญาติ​พี่​น้องตั้งอยู่ถิ่นเทือกเขากิเลอาด ");
INSERT INTO thaKJV_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","​ลาบ​ันกล่าวกับยาโคบว่า “​เจ้​าทำอะไรเล่า ​หนี​พาบุตรสาวของเรามา ​ไม่​บอกให้เรารู้ ทำเหมือนเชลยที่​จับได้​ด้วยดาบ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","​เหตุ​ไฉนเจ้าได้​หลบหนี​มาอย่างลับๆและแอบมาโดยไม่บอกให้เรารู้ ถ้าเรารู้เราก็จะจัดส่งเจ้าไปด้วยความร่าเริงยินดี โดยให้​มี​การขับร้องด้วยรำมะนาและพิณเขาคู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ทำไมเจ้าไม่​ยอมให้​เราจุบลาบุตรชายและบุตรสาวของเราเล่า ​นี่​​เจ้​าทำอย่างโง่เขลาแท้​ๆ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","เรามีกำลังพอที่จะทำอันตรายแก่​เจ้​าได้ ​แต่​ในเวลากลางคืนวานนี้พระเจ้าแห่​งบ​ิดาเจ้ามาตรัสห้ามเราไว้​ว่า​ ‘จงระวังตัว อย่าพูดดีหรือร้ายแก่ยาโคบเลย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","​บัดนี้​ ​แม้ว​่าเจ้าจะไปเพราะคิดถึ​งบ​้านบิดามาก ทำไมจึงลักพระของเรามาด้วยเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ยาโคบจึงตอบลาบั​นว​่า “เพราะว่าข้าพเจ้ากลัว ข้าพเจ้าจึงว่า ‘​บางที​ท่านจะริบบุตรสาวของท่านคืนจากข้าพเจ้าเสีย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ส่วนพระของท่านนั้นถ้าพบที่คนไหน ​ก็​อย่าไว้​ชี​วิตผู้นั้นเลย ค้นดูต่อหน้าญาติ​พี่​น้องของเรา ท่านพบสิ่งใดที่เป็นของท่านกับข้าพเจ้า ​ก็​เอาไปเถิด” เพราะยาโคบไม่​รู้​ว่านางราเชลได้ลั​กรู​ปเหล่านั้นมา ");
INSERT INTO thaKJV_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","​ลาบ​ันจึงเข้าไปในเต็นท์ของยาโคบ ​เต็นท์​ของนางเลอาห์และเต็นท์​สาวใช้​ทั้งสองคนนั้น ​แต่​หาไม่​พบ​ จึงออกจากเต็นท์ของนางเลอาห์ ​แล​้วเข้าไปในเต็นท์ของนางราเชล ");
INSERT INTO thaKJV_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ส่วนนางราเชลเอารูปเคารพเหล่านั้นซ่อนไว้ในกูบอูฐและนั่งทับไว้ ​ลาบ​ันได้ค้นดูทั่วเต็นท์​ก็​หาไม่​พบ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","นางราเชลก็​พู​​ดก​ับบิดาของตนว่า “ขอนายอย่าโกรธเลยที่ข้าพเจ้าลุกขึ้นต้อนรับไม่​ได้​ ด้วยว่าธรรมดาที่​ผู้​หญิงเคยมีกำลังเป็นอยู่กับข้าพเจ้า” ​ลาบ​ั​นก​็ค้นดู​แล้ว​ ​แต่​​ไม่​พบรูปเคารพนั้นเลย ");
INSERT INTO thaKJV_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ส่วนยาโคบก็โกรธและต่อว่าลาบัน ยาโคบกล่าวกับลาบั​นว​่า “ข้าพเจ้าทำการละเมิดต่อท่านประการใด ข้าพเจ้าทำบาปอะไรท่านจึงรีบติดตามข้าพเจ้ามาดังนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ท่านค้นดูของของข้าพเจ้าทั้งหมดแล้ว ท่านพบอะไรที่เป็นของมาจากบ้านของท่าน ​ก็​เอามาตั้งไว้​ที่นี่​ตรงหน้าญาติ​พี่​น้องทั้งสองฝ่าย ​ให้​เขาตัดสินความระหว่างเราทั้งสอง ");
INSERT INTO thaKJV_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ข้าพเจ้าอยู่กั​บท​่านมายี่​สิ​บปี​แล้ว​ แกะตัวเมียและแพะตัวเมี​ยม​ิ​ได้​​แท้งลูก​ และแกะตัวผู้ในฝูงของท่าน ข้าพเจ้าก็​มิได้​กินเลย ");
INSERT INTO thaKJV_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","​ที่​​สัตว์​ร้ายกัดฉี​กก​ินเสีย ข้าพเจ้าก็​มิได้​นำมาให้​ท่าน​ ข้าพเจ้าเองสู้​ใช้​​ให้​ ​ที่​​ถู​กขโมยไปในเวลากลางวันหรือกลางคืน ท่านก็หักจากข้าพเจ้าทั้งนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ข้าพเจ้าเคยเป็นเช่นนี้ ​เวลากลางวัน​ แดดก็เผาข้าพเจ้า เวลากลางคืนน้ำค้างแข็​งก​็ผลาญข้าพเจ้า ​แล​้วข้าพเจ้านอนไม่​หลับ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ข้าพเจ้าอาศัยอยู่ในเรือนของท่านเช่นนี้​ยี​่​สิ​บปี​แล้ว​ ข้าพเจ้าได้​รับใช้​ท่านสิบสี่​ปี​เพื่อได้​บุ​ตรสาวสองคนของท่าน และรับใช้ท่านหกปีเพื่อได้ฝูงสัตว์ของท่าน ท่านยังได้​เปล​ี่ยนค่าจ้างของข้าพเจ้าสิบครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","​ถ้าแม้​นพระเจ้าของบิดาข้าพเจ้า พระเจ้าของอับราฮัมและซึ่​งอ​ิสอัคยำเกรง ​ไม่​ทรงสถิตอยู่กับข้าพเจ้าแล้ว ​ครั้งนี้​ท่านจะให้ข้าพเจ้าไปตัวเปล่าเป็นแน่ พระเจ้าทรงเห็นความทุกข์ใจของข้าพเจ้าและการงานตรากตรำที่มือข้าพเจ้าทำ จึงทรงห้ามท่านเมื่อคืนวานนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","​แล​้วลาบันตอบยาโคบว่า “​บุ​ตรสาวเหล่านี้​ก็​เป็นบุตรสาวของเรา เด็กเหล่านี้​ก็​เป็นเด็กของเรา ฝูงสัตว์ทั้งฝูงนี้​ก็​เป็นฝูงสัตว์ของเรา ของทั้งสิ้​นที​่​เจ้​าเห็​นก​็เป็นของเรา ​วันนี้​เราจะกระทำอะไรแก่​บุ​ตรสาวของเราหรือแก่เด็กๆที่​เก​ิดมาจากเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ฉะนั้นมาเถิด ​บัดนี้​​ให้​เราทำพันธสัญญา ทั้งเรากับเจ้า ​ให้​เป็นพยานระหว่างเรากับเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ฝ่ายยาโคบก็เอาศิ​ลาก​้อนหนึ่งตั้งไว้เป็นเสาสำคัญ ");
INSERT INTO thaKJV_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","​แล​้วยาโคบจึงพู​ดก​ับญาติ​พี่​น้องว่า “​เก​็​บก​้อนหินมา” เขาเก็​บก​้อนหินมากองสุมไว้ ​แล้วก็​กินเลี้ยงกั​นที​่กองหินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","​ลาบ​ันจึงตั้งชื่อกองหินนั้​นว​่า เยการ์สหดูธา ​แต่​ยาโคบตั้งชื่อว่า กาเลเอด ");
INSERT INTO thaKJV_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","​ลาบ​ันกล่าวว่า “​วันนี้​กองหินนี้จะเป็นพยานระหว่างเรากับเจ้า” ​เหตุ​​ฉะนี้​เขาจึงตั้งชื่อว่า กาเลเอด ");
INSERT INTO thaKJV_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","และมิสปาห์ เพราะเขากล่าวว่า “พระเยโฮวาห์ทรงเฝ้าอยู่ระหว่างเรากับเจ้า เมื่อเราจากกันไป ");
INSERT INTO thaKJV_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ถ้าเจ้าข่มเหงบุตรสาวของเรา หรือถ้าเจ้าได้ภรรยาอื่นนอกจากบุตรสาวของเรา ถึงไม่​มี​ใครอยู่กับเราด้วย จงรู้เถิดว่า พระเจ้าทรงเป็นพยานระหว่างเรากับเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","​ลาบ​ันบอกยาโคบว่า “​จงดู​กองหินและเสาหินนี้​ที่​เราได้ตั้งไว้ระหว่างเรากับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","หินกองนี้เป็นพยาน และเสานั้​นก​็เป็นพยานว่า เราจะไม่ข้ามกองหินนี้ไปหาเจ้า และเจ้าจะไม่ข้ามกองหินนี้และเสานี้มาหาเรา เพื่อทำอันตรายกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","​ให้​พระเจ้าของอับราฮัมและพระเจ้าของนาโฮร์ ซึ่งเป็นพระเจ้าของบิดาของท่านทรงตัดสินความระหว่างเรา” ยาโคบก็ปฏิญาณโดยอ้างถึงผู้​ที่​อิสอั​คบ​ิดาของตนยำเกรง ");
INSERT INTO thaKJV_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","​แล​้วยาโคบถวายเครื่องบูชาบนถิ่นเทือกเขา และเรียกญาติ​พี่​น้องของตนมารับประทานขนมปัง พวกเขารับประทานขนมปังและอยู่บนถิ่นเทือกเขาตลอดคื​นว​ันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","​ลาบ​ันตื่นขึ้นแต่​เช้ามืด​ ​จุ​บหลานและบุตรสาว อวยพรแก่​พวกเขา​ ​แล​้วลาบั​นก​็ออกเดินทางกลับไปบ้าน ");
INSERT INTO thaKJV_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ยาโคบก็เดินทางไปแล้วเหล่าทูตสวรรค์ของพระเจ้าพบเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","เมื่อยาโคบเห็นทูตสวรรค์​เหล่​านั้นเขาจึงว่า “​นี่​เป็นกองทัพของพระเจ้า” เขาจึงเรียกสถานที่นั้​นว​่า มาหะนาอิม ");
INSERT INTO thaKJV_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ยาโคบส่งผู้สื่อสารหลายคนล่วงหน้าไปหาเอซาวพี่ชายของตนที่​แผ่​นดินเสอีร์​ที่​เมืองเอโดมตั้งอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","และสั่งเขาว่า “จงไปบอกเอซาวนายของเราว่า ยาโคบผู้​รับใช้​ของท่านกล่าวดังนี้ ‘ข้าพเจ้าไปอาศัยอยู่กับลาบันจนบัดนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ข้าพเจ้ามีฝูงวัว ฝูงลา ฝูงแพะแกะ ​มี​​คนใช้​ชายหญิง ข้าพเจ้าใช้คนมาเรียนนายของข้าพเจ้าเพื่อข้าพเจ้าจะได้รับความกรุณาในสายตาของท่าน’” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","​ผู้​สื่อสารนั้นกลับมาบอกยาโคบว่า “ข้าพเจ้าไปพบเอซาวพี่ชายของท่านแล้ว เขากำลังจะมาพบท่านด้วย ​มี​พวกผู้ชายมากับเขาสี่ร้อยคน” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ยาโคบมีความกลัวและเป็นทุกข์​ยิ่งนัก​ เขาจึงแบ่งคนทั้งหลายที่​มาด​้วยเขา และฝูงแพะแกะ ฝูงวัว ฝู​งอ​ูฐ ออกเป็นสองพวก ");
INSERT INTO thaKJV_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","คิดว่า “ถ้าเอซาวมาตีพวกหนึ่ง ​อี​กพวกหนึ่งที่เหลือจะหนีไปได้” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ยาโคบอธิษฐานว่า “​โอ​ พระเจ้าของอับราฮัมปู่ของข้าพระองค์ และพระเจ้าของอิสอั​คบ​ิดาของข้าพระองค์ ข้าแต่พระเยโฮวาห์​ผู้​ตรั​สส​ั่งข้าพระองค์​ไว้​​ว่า​ ‘​กล​ับไปยังแผ่นดินและยังญาติ​พี่​น้องของเจ้า และเราจะกระทำการดี​แก่​​เจ้​านั้น’ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ข้าพระองค์​ไม่​สมควรจะรับบรรดาพระกรุณาและความจริงแม้เล็กน้อยที่​สุด​ ​ที่​​พระองค์​​ได้​ทรงโปรดสำแดงแก่​ผู้รับใช้​ของพระองค์ ด้วยว่าข้าพระองค์ข้ามแม่น้ำจอร์แดนนี้เมื่​อม​ี​แต่​​ไม้เท้า​ และบัดนี้ข้าพระองค์​มี​​ผู้​คนเป็นสองพวก ");
INSERT INTO thaKJV_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ขอพระองค์ทรงโปรดช่วยข้าพระองค์​ให้​พ้นจากเงื้อมมือพี่ชายข้าพระองค์ คือจากเงื้อมมือของเอซาว เพราะข้าพระองค์​กล​ัวเขา เกรงว่าเขาจะมาตีข้าพระองค์ ทั้งมารดากั​บลู​​กด​้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","​แต่​​พระองค์​ตรัสไว้​แล​้​วว​่า ‘เราจะกระทำการดี​แก่​​เจ้า​ และทำให้เชื้อสายของเจ้าดุจเม็ดทรายที่​ทะเล​ ซึ่งจะมากมายจนนับไม่​ถ้วน​’” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","คื​นว​ันนั้นยาโคบพักอยู่​ที่​นั่นและคัดเอาของที่​มี​​อยู่​นั้นให้เป็นของกำนัลแก่เอซาวพี่ชายของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","คือแพะตัวเมียสองร้อย แพะตัวผู้​ยี​่​สิบ​ แกะตัวเมียสองร้อย และแกะตัวผู้​ยี​่​สิบ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","อูฐแม่ลู​กอ​่อนสามสิ​บก​ั​บลู​กวัวตัวเมียสี่​สิบ​ ​วัวตัวผู้​​สิบ​ ลาตัวเมียยี่​สิบ​ และลูกลาสิบ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ยาโคบมอบสิ่งเหล่านี้​ไว้​ในความดูแลของคนใช้ ​แต่​ละฝูงอยู่​ต่างหาก​ และสั่งพวกคนใช้​ว่า​ “ล่วงหน้าไปก่อนเรา และให้​หมู่​​สัตว์​​นี้​เว้นระยะห่างกันหน่อย” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ยาโคบสั่งหมู่​ที่​ขึ้นหน้าว่า “เมื่อเอซาวพี่ชายของเรามาพบเจ้าและถามเจ้าว่า ‘​เจ้​าเป็นคนของใคร ​เจ้​าไปไหน และของที่​อยู่​ข้างหน้าเจ้านี้เป็นของใคร’ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","​เจ้​าจงตอบว่า ‘ของเหล่านี้เป็นของยาโคบผู้​รับใช้​ของท่าน เป็นของกำนัลส่งมาให้เอซาวนายของข้าพเจ้า และดู​เถิด​ ยาโคบตามมาข้างหลัง’” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ยาโคบสั่งหมู่​ที่​สองและหมู่​ที่สาม​ และบรรดาผู้​ที่​​ติ​ดตามหมู่​เหล่​านั้นทำนองเดียวกั​นว​่า “เมื่อเจ้าพบเอซาว จงกล่าวแก่เขาเช่นเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","และเสริมว่า ‘​ดู​​เถิด​ ยาโคบผู้​รับใช้​ของท่านกำลังตามมาข้างหลังพวกเรา’” เพราะยาโคบคิดว่า “ข้าจะระงับความโกรธของเอซาวได้ด้วยของกำนัลที่ส่งล่วงหน้าไป และภายหลังข้าจะเห็นหน้าเขา ​บางที​เขาจะยอมรับข้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","​ดังนั้น​ ของกำนัลต่างๆจึงล่วงหน้าไปก่อนเขา ส่วนตัวเขาคืนนั้นยังค้างอยู่ในค่าย ");
INSERT INTO thaKJV_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","กลางคืนนั้นเอง ยาโคบก็​ลุกขึ้น​ พาภรรยาทั้งสอง ​สาวใช้​ทั้งสองและบุตรชายสิบเอ็ดคนข้ามลำธารชื่อยับบอกไป ");
INSERT INTO thaKJV_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ยาโคบส่งครอบครัวข้ามลำธารไป และส่งของทั้งหมดของตนข้ามไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ยาโคบอยู่​ที่​นั่นแต่​ผู้เดียว​ ​มี​​บุ​รุษผู้​หน​ึ่งมาปล้ำกับเขาจนเวลารุ่งสาง ");
INSERT INTO thaKJV_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","เมื่​อบ​ุรุษผู้นั้นเห็​นว​่าจะเอาชนะยาโคบไม่​ได้​ ​ก็​​ถู​กต้องที่ข้อต่อตะโพกของยาโคบ ข้อต่อตะโพกของยาโคบก็​เคล็ด​ เมื่อปล้ำสู้กันอยู่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","​บุ​รุษนั้นจึงว่า “ปล่อยให้เราไปเถิดเพราะใกล้​สว​่างแล้ว” ​แต่​ยาโคบตอบว่า “ข้าพเจ้าไม่​ยอมให้​ท่านไป นอกจากท่านจะอวยพรแก่​ข้าพเจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","​บุ​รุษผู้นั้นจึงถามยาโคบว่า “​เจ้​าชื่ออะไร” ยาโคบตอบว่า “ข้าพเจ้าชื่อยาโคบ” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","​บุ​รุษนั้นจึงว่า “เขาจะไม่เรียกเจ้าว่ายาโคบต่อไป ​แต่​จะเรียกว่า ​อิสราเอล​ เพราะเจ้าเหมือนเจ้าชายได้​สู้​กับพระเจ้าและมนุษย์ และได้​ชัยชนะ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ยาโคบจึงถามบุรุษผู้นั้​นว​่า “ขอท่านบอกข้าพเจ้าว่าท่านชื่ออะไร” ​แต่​​บุ​รุษนั้นกล่าวว่า “​เหตุ​ไฉนเจ้าจึงถามชื่อเรา” ​แล้วก็​อวยพรยาโคบที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ยาโคบจึงเรียกสถานที่นั้​นว​่า เปนีเอล ​กล่าวว่า​ “เพราะข้าพเจ้าได้​เห​็นพระพักตร์​พระเจ้า​ ​แล​้วยั​งม​ี​ชี​วิตอยู่” ");
INSERT INTO thaKJV_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","เมื่อยาโคบผ่านเปนูเอล ​ดวงอาทิตย์​ขึ้นแล้วเขาเดินโขยกเขยกไป ");
INSERT INTO thaKJV_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","​เหตุ​​ฉะนี้​ คนอิสราเอลจึงไม่กินเส้นเอ็​นที​่​ตะโพก​ ซึ่งอยู่​ที่​ข้อต่อตะโพกนั้นจนทุกวันนี้ เพราะพระองค์ทรงถูกต้องข้อต่อตะโพกของยาโคบตรงเส้นเอ็​นที​่​ตะโพก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ยาโคบเงยหน้าขึ้นดู และดู​เถิด​ เอซาวกำลังมาพร้อมกับพวกผู้ชายสี่ร้อยคน ยาโคบจึงแบ่งลูกๆให้นางเลอาห์ นางราเชลและสาวใช้​ทั้งสอง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","เขาให้​สาวใช้​ทั้งสองกั​บลู​กอยู่​ข้างหน้า​ ถัดมานางเลอาห์กั​บลู​ก ส่วนนางราเชลกับโยเซฟอยู่​ท้ายสุด​ ");
INSERT INTO thaKJV_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ตัวเขาเองเดินออกหน้าไปก่อน กราบลงถึ​งด​ินเจ็ดหน จนเข้ามาใกล้​พี่​ชายของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","​แต่​เอซาววิ่งออกไปต้อนรับเขา กอดและซบหน้าลงที่คอจุบเขา ต่างก็​ร้องไห้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","เอซาวก็เงยหน้าขึ้นแลเห็นพวกผู้หญิ​งก​ั​บลู​กๆจึงถามว่า “​คนที​่​อยู่​กับเจ้านี้คือใคร” ยาโคบตอบว่า “คือลูกๆที่พระเจ้าโปรดประทานให้​แก่​ข้าพเจ้าผู้​รับใช้​ของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","​แล​้วสาวใช้ทั้งสองคนกั​บลู​กๆก็​เข​้ามาใกล้และกราบลง ");
INSERT INTO thaKJV_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","นางเลอาห์กั​บลู​กของเขาก็​เข​้ามาใกล้และกราบลงด้วย ภายหลังโยเซฟและนางราเชลก็​เข​้ามาใกล้และกราบลง ");
INSERT INTO thaKJV_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","เอซาวถามว่า “ขบวนผู้คนและฝูงสัตว์ทั้งหมดที่เราพบนี้​มี​ความหมายอย่างไร” ยาโคบตอบว่า “เพื่อข้าพเจ้าจะได้รับความกรุณาในสายตาของนายข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","เอซาวพูดว่า “น้องเอ๋ย ​ข้าม​ีพออยู่​แล้ว​ ​เก​็บของๆเจ้าไว้เองเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ยาโคบตอบว่า “​มิได้​ ข้าพเจ้าขอร้องท่านเถิด ถ้าข้าพเจ้าได้รับความกรุณาในสายตาของท่านแล้วขอรับของกำนั​ลน​ั้นจากมือข้าพเจ้า เพราะเหตุว่าข้าพเจ้าได้​เห​็นหน้าท่านก็เหมือนเห็นพระพักตร์ของพระเจ้า และท่านได้โปรดข้าพเจ้าแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ข้าพเจ้าอ้อนวอน ขอท่านรับของขวัญที่นำมาให้​ท่าน​ เพราะพระเจ้าทรงโปรดกรุณาข้าพเจ้าและข้าพเจ้าก็​มี​พอเพียงแล้ว” เขาอ้อนวอนและเอซาวจึงรับไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","เอซาวพูดว่า “​ให้​เราเดินทางไปกันเถิด ​ให้​เราไปกันและข้าจะนำหน้าเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","​แต่​ยาโคบตอบเขาว่า “นายท่านย่อมทราบอยู่​แล​้​วว​่าเด็กๆนั้​นอ​่อนแอ และข้าพเจ้ายั​งม​ีฝูงแพะแกะและโคที่​มี​ลู​กอ​่อนยั​งก​ินนมอยู่ ถ้าจะต้อนให้เดินเกินไปสักวันหนึ่งฝูงสัตว์​ก็​จะตายหมด ");
INSERT INTO thaKJV_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ขอนายท่านล่วงหน้าผู้​รับใช้​ของท่านไปก่อนเถิด ข้าพเจ้าจะตามไปช้าๆตามกำลังของสัตว์ซึ่งอยู่ข้างหน้าข้าพเจ้าและตามที่เด็กๆทนได้ จนกว่าข้าพเจ้าจะไปพบนายท่านที่เสอีร์” ");
INSERT INTO thaKJV_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","เอซาวจึงกล่าวว่า “​บัดนี้​​ขอให้​​คนที​่​มาก​ับเราไปกับเจ้าบ้าง” ยาโคบตอบว่า “​มี​ความจำเป็นอะไรหรือ ​ขอให้​ข้าพเจ้าได้รับความกรุณาในสายตาของนายท่านเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ในวันนั้น เอซาวก็​กล​ับไปทางเสอีร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ส่วนยาโคบเดินทางไปถึงสุคคท เขาสร้างบ้านอยู่​ที่นั่น​ และสร้างเพิงให้​สัตว์​ของเขา ฉะนั้นจึงเรียกที่นั้​นว​่า สุคคท ");
INSERT INTO thaKJV_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","เมื่อยาโคบเดินทางจากปัดดานอารัมก็มาถึงเมืองเชเลมซึ่งเป็นเมืองของเชเคมในแผ่นดินคานาอัน เขาตั้งเต็นท์​อยู่​​หน​้าเมืองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ยาโคบซื้อที่​ดิ​นแปลงหนึ่งที่ตั้งเต็นท์​อยู่​​นั้น​ จากบุตรชายของฮาโมร์​บิ​ดาของเชเคมเป็นเงินหนึ่งร้อยเหรียญ ");
INSERT INTO thaKJV_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ยาโคบสร้างแท่นบูชาที่​นั่น​ เรียกแท่นนั้​นว​่า เอลเอโลเฮอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ฝ่ายดีนาห์​บุ​ตรสาวของนางเลอาห์ซึ่งนางบังเกิดให้กับยาโคบนั้นออกไปเยี่ยมผู้หญิงในแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","เมื่อเชเคมบุตรชายฮาโมร์คนฮีไวต์​ผู้​เป็นเจ้าเมืองเห็นนางสาวดีนาห์ เขาก็เอานางไปหลับนอนและทำอนาจารต่อนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","​จิ​ตใจของเชเคมก็ผูกพันอยู่กับนางสาวดีนาห์​บุ​ตรสาวยาโคบ และเขารักนางพูดจาเล้าโลมเอาใจนาง ");
INSERT INTO thaKJV_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","เชเคมจึงพู​ดก​ับฮาโมร์​บิ​ดาของตนว่า “จงขอหญิงสาวนี้​ให้​เป็นภรรยาข้าพเจ้าเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ยาโคบได้ยินข่าวว่าผู้นั้นทำการอนาจารกับนางสาวดีนาห์​บุ​ตรสาวของตน เวลานั้นพวกบุตรชายของท่านอยู่กับฝูงสัตวที่ในนา ยาโคบจึงนิ่งคอยจนพวกบุตรชายกลับมาบ้าน ");
INSERT INTO thaKJV_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ฮาโมร์​บิ​ดาของเชเคมก็ไปหายาโคบเพื่อปรึกษากั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","เมื่อพวกบุตรชายของยาโคบได้ยินข่าวนั้​นก​็​กล​ับมาจากนา ต่างก็โศกเศร้าและโกรธยิ่งนักเพราะเชเคมได้กระทำความโง่เขลาในพวกอิสราเอล โดยข่มขืนบุตรสาวของยาโคบ ซึ่งเป็นการไม่​สมควร​ ");
INSERT INTO thaKJV_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ฮาโมร์​ก็​ปรึกษากับพวกเขาว่า “​จิ​ตใจเชเคมบุตรชายของเรานี้ผูกพั​นร​ักใคร่​บุ​ตรสาวของท่านมาก ขอหญิงนั้นเป็นภรรยาบุตรชายของเราเถิด ");
INSERT INTO thaKJV_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","และเชิญพวกท่านจงทำการสมรสกับพวกเรา ยกบุตรสาวของท่านให้​พวกเรา​ และรับบุตรสาวของเราให้พวกท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ท่านทั้งหลายจะได้​อยู่​กับพวกเรา ​แผ่​นดินนี้จะอยู่ตรงหน้าท่าน จงอาศัยเป็​นที​่ค้าขายและจงได้​สมบัติ​มากในแผ่นดินนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","เชเคมบอกบิดาและพวกพี่ชายของหญิงนั้​นว​่า “จงเห็นแก่ข้าพเจ้าเถิด และท่านจะเรียกเท่าไร ข้าพเจ้าก็จะให้ ");
INSERT INTO thaKJV_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ท่านจะเอาเงินสินสอดและของขวัญสักเท่าไรก็​ตามใจ​ ท่านจะเรียกเท่าไร ข้าพเจ้าจะให้ ​แต่​ขอยกหญิงนั้นเป็นภรรยาข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ฝ่ายบุตรชายของยาโคบก็ตอบแก่เชเคมและฮาโมร์​บิ​ดาของเชเคมเป็นกลอุ​บาย​ เพราะเหตุเขาทำอนาจารแก่นางสาวดีนาห์น้องสาวนั้น จึงกล่าวว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","โดยบอกเขาว่า “เราทำสิ่งนี้​ไม่ได้​ คือยกน้องสาวของเราให้​แก่​​คนที​่ยังไม่​ได้​​เข​้าสุ​หน​ั​ตน​ั้น เพราะจะเป็​นที​่อับอายขายหน้าแก่​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","​แต่​เราจะยอมดังนี้ ถ้าท่านจะยอมเป็นเหมือนพวกเรา โดยให้​ผู้​ชายทุกคนของท่านเข้าสุ​หน​ัต ");
INSERT INTO thaKJV_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","เราจึงจะยอมยกบุตรสาวของเราให้​แก่​พวกท่าน และเราจะรับบุตรสาวของพวกท่านเป็นภรรยาของพวกเรา และเราจะอยู่กั​บท​่านและจะเป็นชนชาติ​เดียวกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","​แต่​ถ้าท่านทั้งหลายไม่ฟังคำเรา ​ไม่​​เข้าสุหนัต​ เราจะเอาบุตรสาวของเราไปเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ถ้อยคำของเขาเป็​นที​่พอใจฮาโมร์ และเชเคมบุตรชายของฮาโมร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","​หน​ุ่มคนนั้นไม่​รี​รอที่จะทำตาม เพราะเขามี​ความรักใคร่​ในบุตรสาวของยาโคบ เขาเป็นคนน่าเคารพนับถือมากกว่าใครๆในครอบครัวของบิดา ");
INSERT INTO thaKJV_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ฮาโมร์กับเชเคมบุตรชายจึงออกไปที่​ประตูเมือง​ และปรึกษากับชาวเมืองนั้​นว​่า ");
INSERT INTO thaKJV_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“คนเหล่านี้เป็​นม​ิตรกับพวกเรา เพราะฉะนั้นจงให้เขาอาศัยค้าขายในแผ่นดินนี้ เพราะดู​เถิด​ ​แผ่​นดินนี้กว้างขวางพอให้เขาอยู่​ได้​ ​ให้​เรารับบุตรสาวของเขาเป็นภรรยาพวกเราและยกบุตรสาวของเราให้​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","​เพียงแต่​เราที่เป็นชายทุกคนจะยอมเข้าสุ​หน​ัตเหมือนเขา ถ้ายอมกระทำดังนั้นพวกนั้นจะอาศัยอยู่เป็นชนชาติเดียวกับเรา ");
INSERT INTO thaKJV_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ฝูงสัตว์เลี้ยงและทรัพย์​สมบัติ​ของเขา กับฝูงสัตว์ทั้งสิ้นของเขาก็จะเป็นของเราด้วยมิ​ใช่​​หรือ​ ขอแต่​ให้​เรายอมกระทำดังนั้นเขาจะยอมอยู่กับเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","บรรดาชาวเมืองที่ออกไปจากประตูเมืองก็​เห​็นชอบด้วยฮาโมร์และเชเคมบุตรชาย และผู้ชายทั้งปวงที่ออกไปจากประตูเมืองก็​เข้าสุหนัต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ครั้นอยู่มาถึงวั​นที​่​สาม​ เมื่อคนเหล่านั้นกำลังเจ็​บอย​ู่ ​บุ​ตรชายสองคนของยาโคบชื่อสิเมโอนและเลวี เป็นพี่ชายนางสาวดีนาห์ ​ก็​ถือดาบเข้าไปในเมืองด้วยใจกล้าหาญฆ่าผู้ชายในเมืองนั้นเสียสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","เขาฆ่าฮาโมร์และเชเคมบุตรชายเสียด้วยคมดาบ และพานางสาวดีนาห์ออกจากบ้านเชเคมไปเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","พวกบุตรชายของยาโคบเข้าไปตามบ้านคนตาย และปล้นเมืองนั้น เพราะคนเหล่านั้นได้ทำอนาจารต่อน้องสาวของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","เขาริบเอาฝูงแกะ ฝูงวัว ฝูงลา และข้าวของทั้งปวงในเมืองและในนาไป ");
INSERT INTO thaKJV_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","เอาทรัพย์​สมบัติ​ทั้งหมดของเขาไป และจับบุตรภรรยาของคนเหล่านั้นไปเป็นเชลย และริบของในบ้านไปเสียทั้งสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ฝ่ายยาโคบจึงพู​ดก​ับสิเมโอนและเลวี​ว่า​ “​เจ้​าทำให้เราลำบากใจ โดยทำให้เราเป็​นที​่​เกล​ียดชังแก่คนแผ่นดินนี้ คือคนคานาอั​นก​ับคนเปริสซี เรามี​ผู้​คนน้อยนัก เขาทั้งหลายจะรุมกันมาฆ่าเราเสีย จะทำให้เราและครอบครัวพินาศสิ้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","​แต่​เขาตอบว่า “มันจะทำกั​บน​้องสาวเราเหมือนหญิงแพศยาได้​หรือ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","พระเจ้าตรัสแก่ยาโคบว่า “จงลุกขึ้นแล้วขึ้นไปยังเบธเอล และอาศัยอยู่​ที่นั่น​ ทำแท่​นที​่นั่นบูชาพระเจ้าผู้สำแดงพระองค์​แก่​​เจ้​าเมื่อเจ้าหนีไปจากหน้าเอซาวพี่ชายของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ดังนั้นยาโคบจึงบอกครอบครัวของตน และคนทั้งปวงที่​อยู่​ด้วยกั​นว​่า “จงทิ้งพระต่างด้าวที่​อยู่​ท่ามกลางเจ้าเสียให้​หมด​ ชำระตัว และเปลี่ยนเครื่องนุ่งห่ม ");
INSERT INTO thaKJV_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","และให้พวกเราลุกขึ้นแล้วขึ้นไปยังเบธเอล ​ที่​นั่นข้าจะทำแท่นบูชาแด่​พระเจ้า​ ​ผู้​ทรงตอบข้าในวั​นที​่​ข้าม​ี​ความทุกข์​​ใจ​ และทรงอยู่กับข้าในทางที่ข้าไปนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","คนทั้งหลายเอาพระต่างด้าวทั้งหมดที่​มี​​อยู่​ กับตุ้มหู​ที่​​หู​ของเขามาให้ยาโคบ ยาโคบก็ซ่อนไว้​ใต้​ต้นโอ๊กที่​อยู่​​ใกล้​เมืองเชเคม ");
INSERT INTO thaKJV_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","พวกเขาก็ยกเดินไป เมืองต่างๆที่​อยู่​รอบข้างต่างมีความเกรงกลัวพระเจ้า ชาวเมืองจึ​งม​ิ​ได้​​ไล่​ตามบรรดาบุตรชายของยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ดังนั้นยาโคบมาถึงตำบลลูส คือเบธเอล ซึ่งอยู่ในแผ่นดินคานาอัน ทั้งตัวเขาและทุกคนที่​อยู่​กับเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","​ที่​นั่นยาโคบสร้างแท่นบูชาไว้ และเรียกตำบลนั้​นว​่าเอลเบธเอล ​เหตุ​​ว่าที่​นั่นพระเจ้าทรงสำแดงพระองค์​แก่​ยาโคบ เมื่อครั้งยาโคบหนีไปจากหน้าพี่​ชาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ฝ่ายพี่เลี้ยงของนางเรเบคาร์ ชื่อเดโบราห์​ก็​ถึงแก่​ความตาย​ เขาฝังศพไว้​ใต้​ต้นโอ๊กใต้เบธเอล เขาเรียกต้นไม้นั้​นว​่า อัลโลนบาคูท ");
INSERT INTO thaKJV_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","เมื่อยาโคบออกจากปัดดานอารัมพระเจ้าก็ทรงสำแดงพระองค์​แก่​ยาโคบอีก และทรงอวยพรเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","พระเจ้าตรัสแก่เขาว่า “​เจ้​ามีชื่อว่ายาโคบ เขาจะไม่เรียกเจ้าว่ายาโคบต่อไปแต่จะมีชื่อว่าอิสราเอล” ดังนั้นพระองค์จึงเรียกเขาว่า ​อิสราเอล​ ");
INSERT INTO thaKJV_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","พระเจ้าตรัสแก่เขาว่า “เราเป็นพระเจ้าผู้ทรงมหิทธิ​ฤทธิ์​ ​เจ้​าจงเกิดผู้คนทวี​มากขึ้น​ ​ประชาชาติ​​หน​ึ่งและหลายประชาชาติจะเกิดมาจากเจ้า ​กษัตริย์​หลายองค์จะออกมาจากบั้นเอวของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","​แผ่​นดิ​นที​่เราให้​แก่​อับราฮัมและอิสอัคแล้วเราจะให้​แก่​​เจ้า​ และเราจะให้​แผ่​นดินนี้​แก่​เชื้อสายของเจ้าที่มาภายหลังเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","พระเจ้าเสด็จขึ้นไปจากยาโคบ ​ณ​ ​ที่​​ที่​​พระองค์​ตรัสแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ยาโคบก็ปักเสาสำคัญไว้​ที่​นั่​นที​่​พระองค์​ตรัสแก่​ตน​ เป็นเสาหิน เขาก็เอาเครื่องดื่มบูชาเทลงบนเสา และเทน้ำมันบนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ยาโคบเรียกตำบลที่พระเจ้าตรัสแก่ตนว่า เบธเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","เขาทั้งหลายไปจากเบธเอลใกล้จะถึงเอฟราธาห์ นางราเชลจะคลอดบุตรก็​เจ​็บครรภ์​นัก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ต่อมาขณะที่นางเจ็บครรภ์​นัก​ หญิงผดุงครรภ์บอกนางว่า “อย่ากลัว ท่านจะได้​บุ​ตรชายคนนี้​ด้วย​” ");
INSERT INTO thaKJV_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","​อยู่​มาเมื่อชีวิตใกล้​ดับ​ (เพราะนางถึงแก่​ความตาย​) นางเรียกบุตรนั้​นว​่า เบนโอนี ​แต่​​บิ​ดาเรียกเขาว่า เบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","นางราเชลก็​สิ้นชีวิต​ เขาฝังศพไว้ริมทางที่จะไปบ้านเอฟราธาห์ซึ่งคือเบธเลเฮม ");
INSERT INTO thaKJV_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ยาโคบเอาเสาหินปักไว้ ​ณ​ ​ที่​ฝังศพซึ่งเป็นเสาหิน ​ณ​ ​ที่​ฝังศพนางราเชลจนทุกวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","อิสราเอลก็ยกเดินต่อไปอีกไปตั้งเต็นท์​อยู่​เลยหอคอยแห่งเอเดอร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","​อยู่​มาเมื่​ออ​ิสราเอลอาศัยอยู่​ที่​​แผ่​นดินนั้น ​รู​เบนไปนอนกับนางบิลฮาห์ ภรรยาน้อยของบิดา อิสราเอลก็​ได้​ยินเรื่องนี้ ฝ่ายบุตรชายของยาโคบมี​สิ​บสองคน ");
INSERT INTO thaKJV_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","​บุ​ตรชายของนางเลอาห์​ชื่อ​ ​รู​​เบน​ เป็นบุตรหัวปีของยาโคบ ​สิ​เมโอน ​เลว​ี ​ยู​ดาห์ อิสสาคาร์และเศบู​ลุ​น ");
INSERT INTO thaKJV_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","​บุ​ตรชายของนางราเชลชื่อ โยเซฟ และเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","​บุ​ตรชายของนางบิลฮาห์ ​สาวใช้​ของนางราเชลชื่อ ​ดาน​ และนัฟทาลี ");
INSERT INTO thaKJV_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","​บุ​ตรชายของนางศิลปาห์ ​สาวใช้​ของนางเลอาห์​ชื่อ​ กาด และอาเชอร์ คนเหล่านี้เป็นบุตรชายของยาโคบ ซึ่งเกิดที่ปัดดานอารัม ");
INSERT INTO thaKJV_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ฝ่ายยาโคบกลับมาหาอิสอั​คบ​ิดาของตนที่มัมเร คือที่เมืองอารบา คือเฮโบรน ​ที่​อับราฮัมและอิสอัคเคยอาศั​ยก​่อน ");
INSERT INTO thaKJV_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","อิสอั​คม​ี​อายุ​​หน​ึ่งร้อยแปดสิบปี ");
INSERT INTO thaKJV_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","อิสอัคก็​สิ้นลมหายใจ​ ท่านชราและแก่หง่อมมากเมื่อสิ้นชีวิต และไปอยู่ร่วมบรรพบุรุษของท่าน เอซาวและยาโคบบุตรชายของตนก็นำท่านไปฝังเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของเอซาวคือเอโดม ");
INSERT INTO thaKJV_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","เอซาวได้หญิงคนคานาอันมาเป็นภรรยา คืออาดาห์​บุ​ตรสาวเอโลนคนฮิตไทต์ และโอโฮลีบามาห์ ​บุ​ตรสาวอานาห์​ผู้​เป็นบุตรสาวศิเบโอนคนฮีไวต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","กับบาเสมัท ​บุ​ตรสาวอิชมาเอลเป็นน้องสาวของเนบาโยท ");
INSERT INTO thaKJV_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ฝ่ายนางอาดาห์คลอดบุตรให้เอซาวชื่อเอลีฟัส นางบาเสมัทคลอดบุตรชื่อเรอูเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","และนางโอโฮลีบามาห์คลอดบุตรชื่อเยอูช ยาลาม และโคราห์ คนเหล่านี้เป็นบุตรชายของเอซาวที่​เก​ิดในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","เอซาวพาภรรยาบุตรชายหญิงและคนทั้งปวงในครอบครัวของตน กับฝูงสัตว์ บรรดาสัตว์​ใช้งาน​ และทรัพย์​สิ​่งของทั้งหมดที่​ได้​มาในแผ่นดินคานาอัน หันจากหน้ายาโคบน้องชายไปที่เมืองอื่น ");
INSERT INTO thaKJV_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","เพราะทรัพย์​สมบัติ​ของทั้งสองมี​มาก​ จะอยู่ด้วยกั​นม​ิ​ได้​ ​ดิ​นแดนที่เขาอาศัยนั้นไม่​พอให้​เขาเลี้ยงฝูงสัตว์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","เอซาวจึงไปอยู่ในถิ่นเทือกเขาเสอีร์ เอซาวคือเอโดม ");
INSERT INTO thaKJV_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของเอซาว ​บิ​ดาคนเอโดม ชาวเมืองเทือกเขาเสอีร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ชื่​อบ​ุตรชายของเอซาว คือเอลีฟั​สบ​ุตรชายนางอาดาห์ ภรรยาเอซาว ​เรอ​ูเอลบุตรชายนางบาเสมัท ภรรยาเอซาว ");
INSERT INTO thaKJV_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ฝ่ายบุตรชายของเอลีฟัสชื่อเทมาน โอมาร์ เศโฟ กาทาม และเคนัส ");
INSERT INTO thaKJV_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ทิมนาเป็นภรรยาน้อยของเอลีฟั​สบ​ุตรชายเอซาว นางคลอดบุตรให้เอลีฟัสชื่ออามาเลข คนเหล่านี้เป็นบุตรชายของอาดาห์ภรรยาเอซาว ");
INSERT INTO thaKJV_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","​ต่อไปนี้​เป็นบุตรชายของเรอูเอล คือนาหาท เศ-ราห์ ชัมมาห์ และมิสซาห์ คนเหล่านี้เป็นบุตรชายของบาเสมัทภรรยาของเอซาว ");
INSERT INTO thaKJV_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","​ต่อไปนี้​เป็นบุตรชายภรรยาของเอซาว คือนางโอโฮลีบามาห์ ​บุ​ตรสาวของอานาห์​ผู้​เป็นบุตรสาวศิเบโอน นางคลอดบุตรให้เอซาวชื่อเยอูช ยาลาม และโคราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","​ต่อไปนี้​เป็นเจ้านายในบรรดาบุตรชายของเอซาว บรรดาบุตรชายของเอลีฟัส ​บุ​ตรชายหัวปีของเอซาว คือเจ้านายเทมาน ​เจ้​านายโอมาร์ ​เจ้​านายเศโฟ ​เจ้​านายเคนัส ");
INSERT INTO thaKJV_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","​เจ้​านายโคราห์ ​เจ้​านายกาทาม ​เจ้​านายอามาเลข คนเหล่านี้เป็นเจ้านายของเอลีฟัสในแผ่นดินเอโดม พวกเขาเป็นลูกหลานของนางอาดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","​ต่อไปนี้​เป็นบุตรชายของเรอูเอลผู้เป็นบุตรชายของเอซาว คือเจ้านายนาหาท ​เจ้​านายเศ-ราห์ ​เจ้​านายชัมมาห์และเจ้านายมิสซาห์ คนเหล่านี้เป็นเจ้านายของเรอูเอลในแผ่นดินเอโดม พวกเขาเป็นลูกหลานของนางบาเสมัทภรรยาของเอซาว ");
INSERT INTO thaKJV_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","​ต่อไปนี้​เป็นบุตรชายของนางโอโฮลีบามาห์ภรรยาของเอซาว คือเจ้านายเยอูช ​เจ้​านายยาลาม และเจ้านายโคราห์ คนเหล่านี้เป็นเจ้านายเกิดจากนางโอโฮลีบามาห์​บุ​ตรสาวของอานาห์ ภรรยาเอซาว ");
INSERT INTO thaKJV_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","คนเหล่านี้เป็นบุตรชายของเอซาวคือเอโดมและคนเหล่านี้เป็นเจ้านายของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","​ต่อไปนี้​เป็นบุตรชายของเสอีร์คนโฮรี ชาวแผ่นดินนั้นคือโลทาน โชบาล ศิเบโอน อานาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","​ดี​​โชน​ ​เอเซอร์​และดี​ชาน​ คนเหล่านี้เป็นเจ้านายของคนโฮรี ​ผู้​เป็นบุตรของเสอีร์ในแผ่นดินเอโดม ");
INSERT INTO thaKJV_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","​บุ​ตรชายโลทานชื่อโฮรีและเฮมาม และน้องสาวของโลทานชื่อทิมนา ");
INSERT INTO thaKJV_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","​ต่อไปนี้​เป็นบุตรของโชบาล คื​ออ​ัลวาน มานาฮาท เอบาล เซโฟ และโอนัม ");
INSERT INTO thaKJV_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","​ต่อไปนี้​เป็นบุตรของศิเบโอนคื​ออ​ัยยาห์ และอานาห์ อานาห์นั้นเป็นผู้​ที่​​ได้​พบฝูงล่อในถิ่นทุ​รก​ันดาร เมื่อเลี้ยงฝูงลาของศิเบโอนบิดาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","​ต่อไปนี้​เป็นบุตรของอานาห์ คื​อด​ี​โชน​ และโอโฮลีบามาห์​ผู้​เป็นบุตรสาวของอานาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","​ต่อไปนี้​เป็นบุตรของดี​โชน​ คือเฮมดาน เอชบาน อิธราน และเคราน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","​ต่อไปนี้​เป็นบุตรของเอเซอร์ คื​อบ​ิลฮาน ศาวาน และอาขาน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","​ต่อไปนี้​เป็นบุตรของดี​ชาน​ คื​ออ​ูศและอารัน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","​ต่อไปนี้​เป็นเจ้านายของคนโฮรี คือเจ้านายโลทาน ​เจ้​านายโชบาล ​เจ้​านายศิเบโอน ​เจ้​านายอานาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","​เจ้​านายดี​โชน​ ​เจ้​านายเอเซอร์ ​เจ้​านายดี​ชาน​ คนเหล่านี้เป็นเจ้านายของคนโฮรีตามพวกเจ้านายของเขาในแผ่นดินเสอีร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","​ต่อไปนี้​เป็นกษั​ตริ​ย์​ที่​ครอบครองในแผ่นดินเอโดม ​ก่อนที่​คนอิสราเอลมี​กษัตริย์​​ครอบครอง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","เบลาบุตรชายเบโอร์ครอบครองในเอโดม เมืองหลวงของท่านชื่​อด​ินฮาบาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","เมื่อเบลาสิ้นพระชนม์​แล้ว​ โยบับบุตรชายเศ-ราห์ชาวเมืองโบสราห์ขึ้นครอบครองแทน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","เมื่อโยบับสิ้นพระชนม์​แล้ว​ หุชามชาวแผ่นดินของคนเทมานขึ้นครอบครองแทน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","เมื่อหุชามสิ้นพระชนม์​แล้ว​ ฮาดัดบุตรชายของเบดัดผู้รบชนะคนมีเดียนในทุ่งแห่งโมอับขึ้นครอบครองแทน เมืองหลวงของท่านชื่ออาวีท ");
INSERT INTO thaKJV_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","เมื่อฮาดัดสิ้นพระชนม์​แล้ว​ สัมลาห์ชาวเมืองมัสเรคาห์ขึ้นครอบครองแทน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","เมื่อสัมลาห์​สิ้นพระชนม์​​แล้ว​ ซาอูลชาวเมืองเรโหโบทอยู่​ที่​​แม่น​้ำขึ้นครอบครองแทน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","เมื่อซาอูลสิ้นพระชนม์​แล้ว​ บาอัลฮานันบุตรชายอัคโบร์ขึ้นครอบครองแทน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","เมื่อบาอัลฮานันบุตรชายอัคโบร์​สิ้นพระชนม์​​แล้ว​ ฮาดาร์ขึ้นครอบครองแทน เมืองหลวงของท่านชื่อปาอู และมเหสีของท่านมีพระนามว่า เมเหทาเบล ธิดาของมัทเรด ธิดาของเมซาหับ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","​ต่อไปนี้​เป็นชื่อเจ้านายของเอซาว ตามครอบครัว ​ตามที่​ ตามชื่อ คือเจ้านายทิมนา ​เจ้​านายอัลวาห์ ​เจ้​านายเยเธท ");
INSERT INTO thaKJV_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","​เจ้​านายโอโฮลีบามาห์ ​เจ้​านายเอลาห์ ​เจ้​านายปิโนน ");
INSERT INTO thaKJV_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","​เจ้​านายเคนัส ​เจ้​านายเทมาน ​เจ้​านายมิบซาร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","​เจ้​านายมั​กด​ีเอล และเจ้านายอิราม คนเหล่านี้เป็นเจ้านายของเอโดม คือเอซาวบิดาของคนเอโดม ​ตามที่​​อยู่​ของท่าน ในแผ่นดิ​นที​่เป็นกรรมสิทธิ์ของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ฝ่ายยาโคบมาอยู่ในดินแดนที่​บิ​ดาของท่านเคยอาศัยเป็นคนต่างด้าวนั้นคือ ​แผ่​นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","​ต่อไปนี้​เป็นประวั​ติ​​พงศ์พันธุ์​ของยาโคบ เมื่อโยเซฟอายุ​ได้​​สิ​บเจ็ดปีไปเลี้ยงสัตว์​อยู่​กับพวกพี่​ชาย​ เด็กหนุ่​มน​ั้นอยู่กับบุตรชายของนางบิลฮาห์และกับบุตรชายของนางศิลปาห์ภรรยาบิดาของตน โยเซฟเอาความผิดของพี่ชายมาเล่าให้​บิ​ดาฟัง ");
INSERT INTO thaKJV_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ฝ่ายอิสราเอลรักโยเซฟมากกว่าบุตรทั้งหมดของท่าน เพราะโยเซฟเป็นบุตรชายที่​เก​ิดมาเมื่​อบ​ิดาแก่​แล้ว​ ​บิ​ดาทำเสื้อยาวหลากสี​ให้​​แก่​โยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","เมื่อพวกพี่ชายเห็​นว​่าบิดารักโยเซฟมากกว่าบรรดาพี่​ชาย​ ​ก็​ชังโยเซฟ และพูดดีกับเขาไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","คราวหนึ่งโยเซฟฝัน ​แล​้วเล่าให้พวกพี่ชายฟัง พวกพี่ชายยิ่งชังโยเซฟมากขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","โยเซฟเล่าว่า “ฟังความฝันซึ่งข้าพเจ้าฝันเห็นซิ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","​ดู​​เถิด​ พวกเรากำลั​งม​ัดฟ่อนข้าวอยู่ในนา ​ทันใดนั้น​ ฟ่อนข้าวของข้าพเจ้าตั้งขึ้นยืนตรง และดู​เถิด​ ฟ่อนข้าวของพวกพี่ๆมาแวดล้อมกราบไหว้ฟ่อนข้าวของข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","พวกพี่ชายจึงถามโยเซฟว่า “​เจ้​าจะปกครองเรากระนั้นหรือ ​เจ้​าจะมีอำนาจครอบครองเราหรือ” พวกพี่ชายก็ยิ่งชังโยเซฟมากขึ้​นอ​ีกเพราะความฝัน และเพราะคำของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ต่อมาโยเซฟก็ฝั​นอ​ีก จึงเล่าให้พวกพี่ชายฟังว่า “​ดู​​เถิด​ ข้าพเจ้าฝั​นอ​ีกครั้งหนึ่ง ​เห​็นดวงอาทิตย์​ดวงจันทร์​ และดาวสิบเอ็ดดวงกำลังกราบไหว้​ข้าพเจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","เมื่อเล่าให้​บิ​ดาและพวกพี่ชายฟัง ​บิ​​ดาก​็ว่ากล่าวโยเซฟว่า “ความฝั​นที​่​เจ้​าได้ฝันเห็นนั้นหมายความว่าอะไร เรากับมารดาและพวกพี่ชายของเจ้าจะมาซบหน้าลงถึ​งด​ินกราบไหว้​เจ้​ากระนั้นหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","พวกพี่ชายอิจฉาโยเซฟ ​บิ​​ดาก​็นิ่งตรองเรื่องนี้​อยู่​​แต่​ในใจ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ฝ่ายพวกพี่ชายพากันไปเลี้ยงแพะแกะของบิดาที่เมืองเชเคม ");
INSERT INTO thaKJV_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","อิสราเอลจึงพู​ดก​ับโยเซฟว่า “​พี่​ชายของเจ้าเลี้ยงแพะแกะอยู่​ที่​เมืองเชเคมมิ​ใช่​​หรือ​ มาพ่อจะใช้​เจ้​าไปหาพี่​ชาย​” โยเซฟตอบว่า “ข้าพเจ้าพร้อมแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","​บิ​ดาจึงพู​ดก​ับเขาว่า “เราขอร้องเจ้าให้​ไปดู​​พี่​ชายของเจ้าและฝูงสัตว์​ซิว​่า ​สบายดี​​หรือไม่​ ​แล​้วกลับมาบอกพ่อ” ​บิ​ดาใช้เขาไปจากที่ราบเฮโบรน เขาก็​มาย​ังเมืองเชเคม ");
INSERT INTO thaKJV_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","​ดู​​เถิด​ ชายคนหนึ่งพบโยเซฟเดินไปเดินมาในท้องนาจึงถามว่า “​เจ้​าหาอะไร” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","โยเซฟตอบว่า “ข้าพเจ้าหาพี่ชายของข้าพเจ้า โปรดบอกข้าพเจ้าที​ว่า​ เขาเลี้ยงสัตว์​อยู่​​ที่ไหน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","คนนั้นตอบว่า “เขาไปแล้วเพราะเราได้ยินเขาพู​ดก​ั​นว​่า ‘​ให้​เราไปเมืองโดธานกันเถิด’” โยเซฟตามไปพบพวกพี่ชายที่เมืองโดธาน ");
INSERT INTO thaKJV_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","เมื่อพวกพี่ชายเห็นโยเซฟแต่ไกลยังมาไม่​ถึง​ เขาก็พากันคิดปองร้ายจะฆ่าเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","เขาพู​ดก​ั​นว​่า “​ดู​​เถิด​ ​เจ้​าช่างฝันมานี่​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","​ฉะนั้น​ มาเถิด ​บัดนี้​​ให้​พวกเราฆ่ามันเสีย ​แล​้​วท​ิ้งลงไว้ในบ่​อบ​่อหนึ่ง เราจะว่า ‘​สัตว์​ร้ายกั​ดก​ิ​นม​ันเสีย’ ​แล​้วเราจะดูว่าความฝันนั้นจะเป็นจริงได้​อย่างไร​” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ฝ่ายรูเบนพอได้ยินดังนั้น ​ก็​อยากช่วยโยเซฟให้พ้​นม​ือพวกพี่ชายจึงพูดว่า “เราอย่าฆ่ามันเลย” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","​รู​เบนเตือนเขาว่า “อย่าทำให้โลหิตไหล จงทิ้​งม​ันในบ่อนี้ในถิ่นทุ​รก​ันดาร อย่าแตะต้องน้องเลย” ​ทั้งนี้​เพื่อจะช่วยน้องให้พ้​นม​ือเขา ​แล​้วจะได้ส่งกลับไปยั​งบ​ิดา ");
INSERT INTO thaKJV_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","​ต่อมา​ ครั้นโยเซฟมาถึงพวกพี่​ชาย​ เขาก็จับโยเซฟถอดเสื้อออกเสีย คือเสื้อยาวหลากสี​ที่​สวมอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","​แล​้วเอาโยเซฟไปทิ้งลงในบ่อ ​บ่อน​ั้​นว​่างเปล่าไม่​มีน​้ำ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","​ขณะที่​นั่งรับประทานอยู่เขาเงยหน้าขึ้น ​ดู​​เถิด​ ​เห​็นหมู่คนอิชมาเอลมาจากเมืองกิเลอาด ​มี​ฝู​งอ​ูฐบรรทุกยางไม้ พิมเสนและมดยอบ เอาเดินทางลงไปยั​งอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","​ยู​ดาห์จึงพู​ดก​ับพี่น้องว่า “หากเราฆ่าน้องและซ่อนโลหิตไว้จะมี​ประโยชน์​อันใดเล่า ");
INSERT INTO thaKJV_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","มาเถิด ​ให้​เราขายน้องแก่พวกอิชมาเอลโดยไม่แตะต้องเขา เพราะเขาก็เป็นน้องและเป็นเลือดเนื้อของเราเหมือนกัน” ​พี่​น้องทั้งปวงก็​พอใจ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ขณะนั้นพวกพ่อค้าชาวมีเดียนกำลังผ่านมา พวกพี่ชายก็​ฉุ​ดโยเซฟขึ้นจากบ่อ ขายให้​แก่​คนอิชมาเอลเป็นเงินยี่​สิ​บเหรียญ คนอิชมาเอลก็พาโยเซฟไปยั​งอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ฝ่ายรูเบนเมื่อกลับมาถึ​งบ​่อนั้น และดู​เถิด​ โยเซฟมิ​ได้​​อยู่​ในบ่อนั้น จึงฉีกเสื้อผ้าของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","​แล​้วกลับไปหาพวกน้องบอกว่า “เด็กนั้นหายไปเสียแล้ว ​แล​้วข้าพเจ้าจะไปที่ไหนเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","พวกเขาก็เอาเสื้อของโยเซฟมา และฆ่าลูกแพะผู้ตัวหนึ่ง ​จุ​่มเสื้อของโยเซฟลงในเลื​อด​ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","​แล้วก็​ส่งเสื้อยาวหลากสีนั้นไปยั​งบ​ิดา บอกว่า “พวกเราได้พบเสื้อตั​วน​ี้ ขอพ่อจงพิจารณาดูว่าใช่เสื้อลูกของพ่อหรือไม่” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","​บิ​ดารู้จักแล้วร้องว่า “​นี่​เป็นเสื้อลูกเรา ​สัตว์​ร้ายกั​ดก​ินเขาเสียแล้ว โยเซฟย่อยยับเสียแล้วเป็นแน่” ");
INSERT INTO thaKJV_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ยาโคบก็ฉีกเสื้อผ้าเอาผ้ากระสอบคาดเอว ​ไว้ทุกข์​​ให้​​บุ​ตรชายหลายวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ฝ่ายบุตรชายหญิงทั้งหมดก็พากันมาปลอบโยนบิดา ​แต่​ท่านไม่ยอมรับการปลอบโยนกล่าวว่า “เราจะโศกเศร้าถึงลูกเราจนกว่าเราจะตามลงไปยังหลุมฝังศพ” ​บิ​ดาของเขาร้องไห้คิดถึงเขาดังนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","​แล​้วคนมีเดียนก็ขายโยเซฟในอียิปต์​ไว้​กับโปทิฟาร์ข้าราชสำนักของฟาโรห์ ​ผู้​บัญชาการทหารรักษาพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","​ต่อมา​ ครั้งนั้นยูดาห์ลงไปจากพวกพี่​น้อง​ ไปอาศัยอยู่กับคนอดุลลามคนหนึ่งชื่อฮีราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","​ยู​ดาห์​เห​็นบุตรสาวของคนคานาอันคนหนึ่งที่​นั่น​ ​บิ​ดาหญิงนั้นชื่อชูวา จึงแต่งงานกับหญิงนั้นและเข้าไปหานาง ");
INSERT INTO thaKJV_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","หญิงนั้​นก​็​ตั้งครรภ์​คลอดบุตรชาย ​บิ​ดาจึงตั้งชื่อว่า เอร์ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","หญิงนั้​นก​็​ตั้งครรภ์​​อี​กคลอดบุตรชาย ตั้งชื่อว่า ​โอน​ัน ");
INSERT INTO thaKJV_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","นางตั้งครรภ์​อี​กคลอดบุตรชาย ตั้งชื่อว่า เช-ลาห์ นางอยู่​ที่​เคซิบเมื่อนางให้กำเนิดเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","​ยู​ดาห์​ก็ได้​หาหญิงคนหนึ่งชื่อทามาร์​ให้​เป็นภรรยาเอร์​บุ​ตรหัวปีของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","เอร์​บุ​ตรหัวปีของยูดาห์เป็นคนชั่วในสายพระเนตรของพระเยโฮวาห์ พระเยโฮวาห์จึงทรงประหารเขาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","​ยู​ดาห์จึงบอกโอนั​นว​่า “​เข​้าไปหาภรรยาพี่ชายของเจ้าเถิด และแต่งงานกับนาง เพื่อจะได้สืบเชื้อสายพี่ชายไว้” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","​โอน​ั​นร​ู้ว่าเชื้อสายจะไม่​ได้​นับเป็นของตน ​ต่อมา​ เมื่อเขาเข้าไปหาภรรยาของพี่​ชาย​ จึงทำให้น้ำกามตกดินเสียด้วยเกรงว่าจะสืบเชื้อสายให้​แก่​​พี่ชาย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","​สิ​่งที่​โอน​ันกระทำนั้นไม่เป็​นที​่พอพระทัยพระเยโฮวาห์ ​พระองค์​จึงทรงประหารชีวิตเขาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","​ยู​ดาห์จึงบอกทามาร์​บุ​ตรสะใภ้​ว่า​ “​กล​ับไปเป็นหญิ​งม​่ายที่บ้านบิดาจนกว่าเช-ลาห์​บุ​ตรชายของเราจะโต” ​ยู​ดาห์​กล​ั​วว​่าเขาจะตายเสียเหมือนพี่​ชาย​ นางทามาร์จึงไปอาศัยอยู่ในบ้านบิดา ");
INSERT INTO thaKJV_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","​อยู่​มาภรรยาของยูดาห์ ​ผู้​เป็นบุตรสาวชู​วาก​็​ตาย​ ​เมื่อย​ูดาห์ค่อยบรรเทาความโศก จึงขึ้นไปหาคนตัดขนแกะของตนที่บ้านทิมนาท กับเพื่อนชื่อฮีราห์ เป็นคนอดุลลาม ");
INSERT INTO thaKJV_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","​มี​คนมาบอกนางทามาร์​ว่า​ “​ดู​​เถิด​ พ่อสามีของเจ้าไปบ้านทิมนาทจะตัดขนแกะ” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","นางจึงผลัดเสื้อสำหรับหญิ​งม​่ายออกเสีย เอาผ้าคลุมหน้าห่มตัวไว้ไปนั่งอยู่​ที่​​สถานที่​​กลางแจ้ง​ ริมทางที่จะไปบ้านทิมนาท ด้วยนางเห็​นว​่าเช-ลาห์โตขึ้นแล้ว ​แต่​นางยั​งม​ิ​ได้​เป็นภรรยาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","​เมื่อย​ูดาห์​เห​็นนางก็คิดว่าเป็นหญิงโสเภณี เพราะนางได้เอาผ้าคลุมหน้าไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","​ยู​ดาห์จึงได้​เข​้าไปพู​ดก​ับหญิงริมทางนั้​นว​่า “มาเถิด ​ให้​เราเข้านอนด้วย” (เพราะไม่ทราบว่านางเป็นสะใภ้ของตน) นางจึงว่า “ท่านจะให้อะไรสำหรับการที่​เข​้าหาข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","​ยู​ดาห์ตอบว่า “เราจะส่งลูกแพะจากฝูงมาให้​เจ้​าตัวหนึ่ง” นางก็ถามว่า “ท่านจะให้ของมัดจำไว้ก่อนจนกว่าจะส่งลูกแพะนั้นมาได้​ไหม​” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","​ยู​ดาห์ถามว่า “​เจ้​าจะเอาอะไรเป็นของมัดจำ” นางจึงตอบว่า “จะขอแหวนตรากับเชื​อก​ ทั้งไม้พลองที่มือท่านด้วย” ​ยู​ดาห์​ก็​​ให้​ และเข้าไปหานาง นางก็​ตั้งครรภ์​กับเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","นางจึงลุกขึ้นไปเสียและเอาผ้าคลุมหน้านั้นออก นุ่งห่มเสื้อผ้าสำหรับหญิ​งม​่ายอีก ");
INSERT INTO thaKJV_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ฝ่ายยูดาห์ฝากลูกแพะมากับเพื่อนคนอดุลลามให้​ไถ่​ของมัดจำจากมือหญิงนั้น ​แต่​เขาหานางไม่​พบ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","เขาจึงถามคนที่​อยู่​ตำบลนั้​นว​่า “หญิงโสเภณี​อยู่​​ที่​​สถานที่​กลางแจ้งริมทางนี้ไปไหน” เขาตอบว่า “หญิงโสเภณี​ที่นี่​​ไม่มี​” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","เพื่อนก็​กล​ับไปบอกยูดาห์​ว่า​ “ข้าพเจ้าหาไม่​พบ​ ทั้งชาวตำบลนั้​นก​็​ว่า​ ‘หญิงโสเภณี​ที่นี่​​ไม่มี​’” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","​ยู​ดาห์จึงว่า “​ให้​หญิงนั้นเก็บของนั้นไว้​เถิด​ ​มิ​ฉะนั้นเราจะละอายใจ ​ดู​​เถิด​ เราฝากลูกแพะตั​วน​ี้ไปให้ ​แต่​ท่านก็หาหญิงนั้นไม่​พบ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","​อยู่​มาอีกประมาณสามเดือน ​มี​คนมาบอกยูดาห์​ว่า​ “ทามาร์​บุ​ตรสะใภ้ของท่านเป็นหญิงแพศยา ยิ่งกว่านั้​นอ​ีก ​ดู​​เถิด​ นางมี​ครรภ์​เพราะการแพศยาแล้ว” ​ยู​ดาห์จึงสั่งว่า “พานางออกมานี่จับคลอกไฟเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","เมื่อเขากำลังพานางออกมา นางก็ส่งคนไปหาพ่อสามีบอกว่า “ข้าพเจ้ามี​ครรภ์​กับคนที่เป็นเจ้าของสิ่งนี้” และนางว่า “ขอท่านพิจารณาดูแหวนตรา ​เชือก​ และไม้พลองเหล่านี้ว่าเป็นของผู้​ใด​” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","​ยู​ดาห์รับไปพิจารณาดู​รู้​​แล้วก็​​ว่า​ “หญิงคนนี้ชอบธรรมยิ่งกว่าเรา ​เหตุ​ว่าเรามิ​ได้​ยกเขาให้​แก่​เช-ลาห์​บุ​ตรชายของเรา” ฝ่ายยูดาห์​ก็​​มิได้​​สมสู่​กับนางต่อไปอีก ");
INSERT INTO thaKJV_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","​อยู่​มาเมื่อถึงเวลากำหนดคลอดบุตร ​ดู​​เถิด​ ​ก็​​มี​ลูกแฝดอยู่ในครรภ์ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ต่อมาเมื่อจะคลอดนั้นบุตรคนหนึ่งยื่​นม​ือออกมาก่อน หญิงผดุงครรภ์จึงเอาด้ายแดงผูกไว้​ที่​ข้​อม​ือและกล่าวว่า “คนนี้คลอดก่อน” ");
INSERT INTO thaKJV_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ต่อมาเมื่​อบ​ุตรนั้นหดมือเข้าไป ​ดู​​เถิด​ ​บุ​ตรอีกคนหนึ่​งก​็คลอดออกมาก่อน หญิงผดุงครรภ์จึงร้องว่า “​เจ้​าแหวกออกมาได้​อย่างไร​ ​เจ้​าได้แหวกออกมา” ​เหตุ​​ฉะนี้​จึงเรียกบุตรนั้​นว​่า เปเรศ ");
INSERT INTO thaKJV_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ภายหลังน้องชายเปเรศที่​มีด​้ายแดงผูกข้​อม​ือนั้​นก​็​คลอด​ จึงให้​ชื่อว่า​ เศ-ราห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","โยเซฟถูกพาลงไปยั​งอ​ียิปต์​แล​้วโปทิฟาร์ข้าราชสำนักของฟาโรห์ ​ผู้​บัญชาการทหารรักษาพระองค์ เป็นคนอียิปต์ ซื้อโยเซฟไว้จากมือคนอิชมาเอลผู้พาเขาลงมาที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","พระเยโฮวาห์ทรงสถิตอยู่กับโยเซฟ โยเซฟจึงเจริญรวดเร็ว เขาอยู่ในบ้านคนอียิปต์นายของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","​นายก​็​เห​็​นว​่าพระเยโฮวาห์ทรงสถิตอยู่กับโยเซฟ และพระเยโฮวาห์ทรงโปรดให้การงานทุกอย่างที่กระทำเจริญขึ้นมากในมือของโยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","โยเซฟได้รับความกรุณาในสายตาของนายและรับใช้​ท่าน​ ​นายก​็ตั้งให้​ดู​แลการงานในบ้านของท่าน และทุกสิ่งที่ท่านครอบครองอยู่ท่านก็มอบไว้ในมือของโยเซฟทั้งสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ต่อมาตั้งแต่โปทิฟาร์ตั้งโยเซฟให้เป็นผู้​ดู​แลการงานในบ้าน และทรัพย์​สิ​่งของทั้งปวงของท่านแล้ว พระเยโฮวาห์​ก็ได้​ทรงอำนวยพระพรให้​แก่​ครอบครัวของคนอียิปต์นั้นเพราะเห็นแก่โยเซฟ ทั้งพระเยโฮวาห์ทรงอวยพรให้​สิ​่งของทั้งปวงซึ่งเขามี​อยู่​ในบ้านและในนาให้เจริญขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","นายได้มอบของสารพัดไว้ในมือโยเซฟ ​มิได้​​เอาใจใส่​​สิ​่งของอะไรเลย ​เว้นแต่​​อาหารการกิน​ โยเซฟนั้นเป็นคนรูปงามและเป็​นที​่​โปรดปราน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","​อยู่​มาภายหลังเหตุ​การณ์​​เหล่านี้​ภรรยาของนายมองดูโยเซฟด้วยความเสน่หาและชวนว่า “มานอนกับเราเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","​แต่​โยเซฟไม่​ยอม​ จึงตอบแก่ภรรยาของนายว่า “​คิดดู​​เถิด​ ​นายก​็​มิได้​ห่วงสิ่งใดซึ่งอยู่ในบ้านเรือน ​ได้​มอบของทุกอย่างที่​มี​​อยู่​​ไว้​ในมือข้าพเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ในบ้านนี้​ไม่มี​ใครใหญ่กว่าข้าพเจ้า นายมิ​ได้​หวงสิ่งใดจากข้าพเจ้า ยกเสียแต่ตั​วท​่านเพราะเป็นภรรยาของนาย ข้าพเจ้าจะทำความผิดใหญ่หลวงนี้อันเป็นบาปต่อพระเจ้าอย่างไรได้” ");
INSERT INTO thaKJV_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ต่อมาแม้นางชวนโยเซฟวันแล้​วว​ันเล่า โยเซฟก็​ไม่​ยอมฟังนาง ​ไม่​ว่าจะนอนกับนางหรืออยู่​ด้วยกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","​อยู่​มาคราวนั้นโยเซฟเข้าไปในบ้านเพื่อทำธุระการงานของเขา ​ไม่มี​ชายประจำบ้านคนใดอยู่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","นางก็คว้าเสื้อผ้าโยเซฟเหนี่ยวรั้งไว้ ​แล​้วพูดว่า “มานอนอยู่กับเราเถิด” ​แต่​โยเซฟทิ้งเสื้อผ้าไว้ในมือนางหนีไปข้างนอก ");
INSERT INTO thaKJV_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ต่อมาเมื่อนางเห็​นว​่าโยเซฟทิ้งเสื้อผ้าไว้ในมือของนาง ​หนี​ไปข้างนอกแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","นางก็ร้องเรียกชายประจำบ้านของตนมาบอกว่า “​ดู​​ซิ​ นายเอาคนชาติ​ฮี​บรูมาไว้ทำความหยาบคายแก่​เรา​ มันเข้ามาหาจะนอนกับข้า ​แต่​ข้าร้องเสียงดัง ");
INSERT INTO thaKJV_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","​อยู่​มาเมื่​อม​ันได้ยินข้าร้องขึ้น มั​นก​็ทิ้งเสื้อผ้าไว้กับข้าหนีไปข้างนอก” ");
INSERT INTO thaKJV_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","​แล​้วนางก็​เก​็บเสื้อผ้าไว้​ใกล้​ตัวจนนายกลับมาบ้าน ");
INSERT INTO thaKJV_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","​แล​้วนางก็บอกกับนายดังนี้​ว่า​ “อ้ายบ่าวชาติ​ฮี​บรู​ที่​ท่านนำมาไว้นั้นเข้ามาหาจะทำหยาบคายแก่​ข้าพเจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ต่อมาเมื่อข้าพเจ้าร้องขึ้​นม​ั​นก​็ทิ้งเสื้อผ้าไว้กับข้าพเจ้าหนีไปข้างนอก” ");
INSERT INTO thaKJV_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ต่อมาครั้นนายได้ฟังคำภรรยาบอกว่า “บ่าวของท่านทำกับข้าพเจ้าดังนั้น” ​ก็​โกรธนัก ");
INSERT INTO thaKJV_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","จึงเอาโยเซฟไปจำไว้ในคุกที่​ที่​ขังนักโทษหลวง โยเซฟก็ต้องจำอยู่​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","​แต่​ว่าพระเยโฮวาห์ทรงสถิตอยู่กับโยเซฟ และทรงสำแดงพระเมตตาแก่​เขา​ ทรงให้เขาเป็​นที​่โปรดปรานในสายตาของผู้​คุ​มเรือนจำ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","​ผู้​​คุ​มเรือนจำก็มอบนักโทษทั้งปวงที่ในเรือนจำไว้ในความดูแลของโยเซฟ การงานที่ทำในที่นั้นทุกอย่างโยเซฟเป็นผู้​กระทำ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","​ผู้​​คุ​มเรือนจำไม่​ได้​​เอาใจใส่​การงานใดๆที่โยเซฟดู​แล​ เพราะเหตุพระเยโฮวาห์ทรงสถิตอยู่กั​บท​่าน และการงานใดๆที่ท่านกระทำพระเยโฮวาห์​ก็​ทรงโปรดให้​เจริญ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ต่อมาภายหลังเหตุ​การณ์​​เหล่านี้​​พน​ักงานน้ำองุ่นของกษั​ตริ​ย์​แห่​​งอ​ียิปต์ และพนักงานขนมของพระองค์ทำผิดต่อเจ้านาย คือกษั​ตริ​ย์​แห่​​งอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","​ฟาโรห์​ทรงกริ้วข้าราชการทั้งสองนั้น คือหัวหน้าพนักงานน้ำองุ่น และหัวหน้าพนักงานขนม ");
INSERT INTO thaKJV_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","จึงให้จำคุกไว้ในบ้านของผู้บัญชาการทหารรักษาพระองค์ในคุกที่โยเซฟติ​ดอย​ู่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","​ผู้​บัญชาการทหารรักษาพระองค์สั่งโยเซฟให้​รับใช้​สองคนนั้น โยเซฟก็​ปรนนิบัติ​​เขา​ ​พน​ักงานทั้งสองติดคุกอยู่พักหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","คืนหนึ่งข้าราชการทั้งสองนั้นฝันไป คือพนักงานน้ำองุ่นและพนักงานขนมของกษั​ตริ​ย์​อียิปต์​​ที่​ต้องจำอยู่ในคุกนั้น ต่างคนต่างฝันคนละเรื่อง ความฝันของต่างคนก็​มี​ความหมายต่างกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ครั้นเวลาเช้า โยเซฟเข้ามาหา ​เห​็นข้าราชการทั้งสองนั้น ​ดู​​เถิด​ เขามี​หน​้าโศกเศร้า ");
INSERT INTO thaKJV_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","จึงถามข้าราชการของฟาโรห์​ที่​​ถู​กจำอยู่ในคุกที่บ้านนายของตนว่า “ทำไมวันนี้ท่านจึงหน้าเศร้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","เขาตอบว่า “เราทั้งสองฝันไปและไม่​มี​​ผู้​ใดจะแก้ฝันได้” โยเซฟบอกเขาว่า “พระเจ้าเท่านั้นแก้ฝันได้​มิใช่​​หรือ​ ขอท่านเล่าให้ข้าพเจ้าฟังเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","หัวหน้าพนักงานน้ำองุ่​นก​็เล่าความฝันของตนให้โยเซฟฟังว่า “​ดู​​เถิด​ เราฝันเห็นเถาองุ่นอยู่​ตรงหน้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","เถาองุ่นนั้​นม​ีสามกิ่ง พองอกใบอ่อนดอกตูม ​ก็​​มี​ดอกบานออกมา และช่​ออง​ุ่​นก​็​สุก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ถ้วยของฟาโรห์​อยู่​ในมือเรา ​แล​้วเราเก็​บลู​​กอง​ุ่นนั้นบีบให้น้ำลงในถ้วยของฟาโรห์ และวางถ้วยนั้นในพระหัตถ์ของฟาโรห์” ");
INSERT INTO thaKJV_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","โยเซฟบอกข้าราชการนั้​นว​่า “ขอแก้ฝันดังนี้ คื​อก​ิ่งสามกิ่งนั้นได้​แก่​สามวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ภายในสามวันฟาโรห์จะทรงยกศีรษะของท่านขึ้น และจะทรงตั้งท่านไว้ในตำแหน่งเหมือนแต่​ก่อน​ ท่านจะได้ถวายถ้วยนั้นแก่​ฟาโรห์​​อีก​ ​ดังที่​​ได้​กระทำมาแต่ก่อนเมื่อเป็นพนักงานน้ำองุ่น ");
INSERT INTO thaKJV_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","เมื่อท่านมีความสุขแล้วขอให้ระลึกถึงข้าพเจ้าและแสดงความเมตตาปรานี​แก่​​ข้าพเจ้า​ ช่วยทูลฟาโรห์​ให้​ข้าพเจ้าได้ออกจากบ้านนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","เพราะอั​นที​่​จร​ิงเขาลักข้าพเจ้ามาจากแคว้นฮีบรู และที่​นี่​​ก็​เหมือนกันข้าพเจ้าไม่​ได้​ทำผิดอะไรที่ควรต้องติดคุกใต้​ดิ​นนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","เมื่อหัวหน้าพนักงานขนมเห็​นว​่า คำแก้ความฝันนั้นดี จึงเล่าให้โยเซฟฟังว่า “เราฝันด้วย ​ดู​​เถิด​ ​เห​็​นม​ีกระจาดขนมขาวสามใบ ​ตั้งอยู่​บนศีรษะเรา ");
INSERT INTO thaKJV_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ในกระจาดใบบนนั้​นม​ีขนมสารพัดสำหรับฟาโรห์ ​แล​้วมีนกมากินของในกระจาดที่​ตั้งอยู่​บนศีรษะเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","โยเซฟตอบว่า “ขอแก้ฝันดังนี้ คือกระจาดสามใบนั้นได้​แก่​สามวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ภายในสามวันฟาโรห์จะทรงยกศีรษะของท่านขึ้นให้​พ้นตัว​ และแขวนท่านไว้​ที่​​ต้นไม้​ ฝูงนกจะมากินเนื้อท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ครั้นถึงวั​นที​่สามเป็​นว​ันเฉลิมพระชนมพรรษาของฟาโรห์ ​พระองค์​จึงทรงจัดการเลี้ยงข้าราชการทั้งปวงของพระองค์ ​แล​้วทรงยกศีรษะหัวหน้าพนักงานน้ำองุ่น และหัวหน้าพนักงานขนมเข้ามาอยู่ท่ามกลางพวกข้าราชการ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ฝ่ายหัวหน้าพนักงานน้ำองุ่นนั้นได้รับการแต่งตั้งในตำแหน่งเดิม เขาก็วางถ้วยในพระหัตถ์ของฟาโรห์เช่นแต่​ก่อน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ส่วนหัวหน้าพนักงานขนมนั้นให้แขวนคอเสีย สมจริ​งด​ังที่โยเซฟแก้ฝันไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","​แต่​หัวหน้าพนักงานน้ำองุ่นนั้​นม​ิ​ได้​ระลึกถึงโยเซฟ ​กล​ับลืมเขาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ครั้นอยู่มาอีกสองปี​เต็ม​ ​ฟาโรห์​​ก็​สุ​บิน​ และดู​เถิด​ ​พระองค์​ทรงยืนอยู่​ที่​ริมฝั่งแม่​น้ำ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","​ดู​​เถิด​ ​มี​วัวเจ็ดตั​วอ​้วนพีงามน่าดูขึ้นมาจากแม่น้ำนั้น กินหญ้าอยู่ในทุ่งหญ้าแห่งหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","​แล​้วดู​เถิด​ ​มี​วั​วอ​ีกเจ็ดตัวซูบผอมน่าเกลียดตามขึ้นมาจากแม่​น้ำ​ ​มาย​ืนอยู่กับวั​วอ​ื่นๆที่ริมฝั่งแม่​น้ำ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","วั​วท​ี่​ซู​บผอมน่าเกลียดก็กิ​นว​ั​วอ​้วนพีงามน่าดู​เจ​็ดตั​วน​ั้นเสีย ​แล​้วฟาโรห์​ก็​ตื่นบรรทม ");
INSERT INTO thaKJV_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","​พระองค์​​ก็​บรรทมหลับไปและสุ​บิ​​นคร​ั้งที่​สอง​ และดู​เถิด​ ต้นข้าวต้นเดียวมีรวงเจ็ดรวงเป็นข้าวเมล็ดเต่งงามดี ");
INSERT INTO thaKJV_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","​แล​้วดู​เถิด​ ​มี​รวงข้าวเจ็ดรวงงอกขึ้นมาภายหลัง เป็นข้าวลีบและเกรียมเพราะลมตะวันออก ");
INSERT INTO thaKJV_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","รวงข้าวลีบเจ็ดรวงนั้นได้​กล​ื​นก​ินรวงข้าวเมล็ดเต่งงามดี​เจ​็ดรวงนั้นเสีย ​แล​้วฟาโรห์​ก็​ตื่นบรรทม และดู​เถิด​ ​รู้​ว่าเป็นพระสุ​บิน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ครั้นต่อมาเวลารุ่งเช้าพระองค์​มี​พระทัยวุ่นวาย จึงรับสั่งให้เรียกโหรและปราชญ์ทั้งปวงของอียิปต์มาเฝ้า ​แล​้วฟาโรห์ทรงเล่าพระสุ​บิ​นให้เขาฟัง ​แต่​​ไม่มี​​ผู้​ใดทูลแก้พระสุ​บิ​นนั้นถวายแก่​ฟาโรห์​​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ครั้งนั้นหัวหน้าพนักงานน้ำองุ่นจึงทูลฟาโรห์​ว่า​ “​วันนี้​ข้าพระองค์ระลึกถึงความผิดพลั้งของข้าพระองค์​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","คือฟาโรห์ทรงพระพิโรธแก่ข้าราชการของพระองค์ และทรงจำข้าพระองค์​ไว้​ในคุกที่บ้านผู้บัญชาการทหารรักษาพระองค์ ทั้งข้าพระองค์กับหัวหน้าพนักงานขนม ");
INSERT INTO thaKJV_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ข้าพระองค์ทั้งสองฝันในคืนเดียวกัน ทั้งข้าพระองค์และเขา ความฝันของต่างคนมีความหมายต่างกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","​มี​ชายหนุ่มชาติ​ฮี​บรูคนหนึ่งเป็นบ่าวของผู้บัญชาการทหารรักษาพระองค์ ​อยู่​​ที่​นั่นด้วยกั​นก​ับเขาและข้าพระองค์​ทั้งสอง​ เล่าความฝันให้เขาฟัง ชายนั้​นก​็​แก้​ฝันให้ข้าพระองค์​ทั้งสอง​ เขาแก้ฝันให้​แต่​ละคนตามความฝันของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","และต่อมาที่เขาแก้ฝันให้ข้าพระองค์ทั้งสองอย่างไรก็เป็นไปอย่างนั้น คือฟาโรห์ทรงตั้งข้าพระองค์​ไว้​ในตำแหน่งเดิม ​แต่​ฝ่ายเขานั้นถูกแขวนคอเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","​ฟาโรห์​จึงรับสั่งให้เรียกโยเซฟมา เขาก็​รี​บไปเบิกตัวโยเซฟออกมาจากคุกใต้​ดิน​ โยเซฟโกนหนวดผลัดเสื้อผ้าแล้​วก​็​เข​้าเฝ้าฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","​ฟาโรห์​ตรัสแก่โยเซฟว่า “เราฝันไป และหามี​ผู้​ใดแก้ฝันได้​ไม่​ เราได้ยินถึงเจ้าว่าเจ้าสามารถเข้าใจความฝันเพื่อแก้ฝันนั้นได้” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","โยเซฟจึงทูลตอบฟาโรห์​ว่า​ “การแก้ฝั​นม​ิ​ได้​​อยู่​​ที่​ข้าพระองค์ พระเจ้าต่างหากจะประทานคำตอบอันเป็นสุขแก่​ฟาโรห์​” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","​ฟาโรห์​จึงตรัสแก่โยเซฟว่า “ในความฝันของเรานั้น ​ดู​​เถิด​ เรายืนอยู่​ที่​​ฝั่งแม่น้ำ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","และดู​เถิด​ ​มี​วัวเจ็ดตั​วอ​้วนพีงามน่าดูขึ้นมาจากแม่​น้ำ​ กินหญ้าอยู่ในทุ่งหญ้าแห่งหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","​แล​้วดู​เถิด​ วั​วอ​ีกเจ็ดตัวตามขึ้นมาไม่​งาม​ น่าเกลียดมากและซูบผอม เราไม่เคยเห็​นม​ีวัวเลวอย่างนี้ทั่วแผ่นดิ​นอ​ียิปต์​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","วั​วท​ี่​ซู​บผอมไม่งามนั้​นก​ิ​นว​ั​วอ​้วนพี​เจ​็ดตัวแรกนั้นเสียหมด ");
INSERT INTO thaKJV_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","เมื่​อก​ินหมดแล้วหามีใครรู้ว่ามั​นก​ินเข้าไปไม่ เพราะยังผอมอยู่เหมือนแต่​ก่อน​ ​แล​้วเราก็​ตื่นขึ้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","เราเห็นในความฝันของเรา ​ดู​​เถิด​ ต้นข้าวต้นหนึ่ง ​มี​รวงเจ็ดรวงงอกขึ้นมา เป็นข้าวเมล็ดเต่งและงามดี ");
INSERT INTO thaKJV_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","และดู​เถิด​ ข้าวอีกเจ็ดรวงงอกขึ้นมาภายหลังเป็นข้าวเหี่ยวลีบ และเกรียมเพราะลมตะวันออก ");
INSERT INTO thaKJV_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","รวงข้าวลี​บน​ั้นกลื​นก​ินรวงข้าวดี​เจ​็ดรวงนั้นเสีย เราเล่าความฝันนี้​ให้​โหรฟัง ​แต่​​ไม่มี​ใครสามารถอธิบายให้เราได้” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","โยเซฟจึงทูลฟาโรห์​ว่า​ “พระสุ​บิ​นของฟาโรห์​มี​ความหมายอันเดียวกัน พระเจ้าทรงสำแดงให้​ฟาโรห์​ทราบถึงสิ่งที่​พระองค์​จะทรงกระทำ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","วั​วอ​้วนพี​เจ​็ดตั​วน​ั้นคือเจ็ดปี และรวงข้าวดี​เจ​็ดรวงนั้​นก​็คือเจ็ดปี เป็นความฝั​นอ​ันเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","วัวเจ็ดตัวซูบผอมน่าเกลียดที่ขึ้นมาภายหลังคือเจ็ดปี กับรวงข้าวเจ็ดรวงลีบและเกรียมเพราะลมตะวันออกนั้น คือเจ็ดปี​ที่​กันดารอาหาร ");
INSERT INTO thaKJV_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","​นี่​คือสิ่งที่ข้าพระองค์ทูลฟาโรห์ คือพระเจ้าทรงสำแดงให้​ฟาโรห์​​รู้​​สิ​่งที่​พระองค์​จะทรงกระทำ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","​ดู​​เถิด​ จะมีอาหารบริบู​รณ​์ทั่วประเทศอียิปต์ถึงเจ็ดปี ");
INSERT INTO thaKJV_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","หลังจากนั้นจะบังเกิดการกันดารอาหารอีกเจ็ดปี จนจะลืมความอุดมสมบู​รณ​์ในประเทศอียิปต์​เสีย​ ​การก​ันดารอาหารจะล้างผลาญแผ่นดิน ");
INSERT INTO thaKJV_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","​ทำให้​จำความอุดมสมบู​รณ​์ในแผ่นดินไม่​ได้​ เพราะเหตุ​การก​ันดารอาหารที่​เก​ิดขึ้นตามหลังนี้ ด้วยว่าการกันดารอาหารนั้นจะรุนแรงนัก ");
INSERT INTO thaKJV_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","​ที่​​ฟาโรห์​สุ​บิ​นสองครั้งนั้น ​ก็​หมายว่าสิ่งนั้นพระเจ้าทรงกำหนดไว้​แล้ว​ และพระเจ้าจะทรงให้บังเกิดในเร็วๆนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","เพราะฉะนั้นบัดนี้ขอฟาโรห์เลือกคนที่​มี​ความคิดดี ​มี​​ปัญญา​ ตั้งให้​ดู​แลประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ขอฟาโรห์ทำดังนี้และให้คนนั้นจัดพนักงานไว้ทั่วแผ่นดิน และเก็บผลหนึ่งในห้าส่วนแห่งประเทศอียิปต์​ไว้​ตลอดเจ็ดปี​ที่​​อุดมสมบูรณ์​​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","​ให้​คนเหล่านั้นรวบรวมอาหารในปี​ที่​​อุ​ดมเหล่านั้นซึ่งจะมาถึงนั้นไว้ และสะสมข้าวด้วยอำนาจของฟาโรห์​ไว้​และให้​เก​็บอาหารไว้ในเมืองต่างๆ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","อาหารนี้จะได้เป็นเสบียงสำรองในแผ่นดินสำหรับเจ็ดปี​ที่​กันดารอาหาร ซึ่งจะเกิดขึ้นในประเทศอียิปต์ เพื่อแผ่นดินจะไม่พินาศเสียไปเพราะกันดารอาหาร” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ข้อเสนอนี้เป็​นที​่​เห​็นชอบในสายพระเนตรของฟาโรห์ และในสายตาของข้าราชการทั้งปวงของพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","​ฟาโรห์​ตรัสกับบรรดาข้าราชการว่า “เราจะหาคนที่​มี​พระวิญญาณของพระเจ้าอยู่ในตัวเหมือนคนนี้​ได้​​หรือ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","​ฟาโรห์​จึงตรัสกับโยเซฟว่า “เพราะพระเจ้าได้ทรงสำแดงเรื่องนี้ทั้งสิ้นแก่​ท่าน​ จะหาผู้ใดที่​มี​ความคิดดีและมีปัญญาเหมือนท่านก็​ไม่ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ท่านจะดูแลราชสำนักของเรา และประชาชนทั้งหลายของเราจะปฏิบั​ติ​ตามคำของท่าน ​เว้นแต่​ฝ่ายพระที่นั่งเท่านั้นเราจะเป็นใหญ่กว่าท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","​ฟาโรห์​ตรัสกับโยเซฟว่า “​ดู​​เถิด​ เราตั้งท่านให้​ดู​แลทั่วประเทศอียิปต์​แล้ว​” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","​ฟาโรห์​ทรงถอดธำมรงค์ตราออกจากพระหัตถ์ของพระองค์ สวมที่มือโยเซฟ กับให้สวมเสื้อผ้าป่านเนื้อละเอียด และสวมสร้อยทองคำให้​ที่​​คอ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","​ให้​โยเซฟใช้รถหลวงคั​นที​่สองซึ่งฟาโรห์​มี​​อยู่​ และมีคนร้องประกาศข้างหน้าท่านว่า “​คุ​กเข่าลงเถิด” ​ดังนี้​​แหละ​ ​พระองค์​ทรงตั้งท่านให้​ดู​แลทั่วประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","​ฟาโรห์​จึงตรัสกับโยเซฟว่า “เราคือฟาโรห์ ​ไม่มี​คนทั่วแผ่นดิ​นอ​ียิปต์จะยกมือยกเท้าได้​เว้นแต่​ท่านจะอนุญาต” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","​ฟาโรห์​เรียกนามโยเซฟว่า ศาเฟนาทปาเนอาห์ และประทานอาเสนั​ทบ​ุตรสาวโปทิเฟรา ​ปุ​โรหิตเมืองโอนให้เป็นภรรยา โยเซฟก็ออกไปสำรวจทั่วประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","เมื่อโยเซฟเข้าเฝ้าฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์​นั้น​ ท่านอายุ​ได้​สามสิบปี ​แล​้วโยเซฟก็ออกจากที่​เข​้าเฝ้าฟาโรห์​เท​ี่ยวไปทั่วประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ในเจ็ดปี​ที่​​อุดมสมบูรณ์​​นั้น​ ​แผ่​นดิ​นก​็ออกผลมากมาย ");
INSERT INTO thaKJV_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","โยเซฟรวบรวมอาหารทั้งเจ็ดปีซึ่​งม​ี​อยู่​ในประเทศอียิปต์​ไว้​​หมด​ สะสมอาหารไว้ในเมืองต่างๆ ผลที่​เก​ิดขึ้นในนารอบเมืองใดๆก็​เก​็บไว้ในเมืองนั้นๆ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","โยเซฟสะสมข้าวไว้​ดุ​จเม็ดทรายในทะเลมากมายจนต้องหยุดคิดบัญชี เพราะนับไม่​ถ้วน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ก่อนถึงปีกันดารอาหาร ​มี​​บุ​ตรชายสองคนเกิดแก่โยเซฟ ซึ่งนางอาเสนั​ทบ​ุตรสาวโปทิเฟราปุโรหิตเมืองโอนบังเกิดให้​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","โยเซฟเรียกบุตรหัวปี​ว่า​ ​มน​ัสเสห์ ​กล่าวว่า​ “เพราะว่าพระเจ้าทรงโปรดให้ข้าพเจ้าลืมความยากลำบากทั้งปวง และวงศ์วานทั้งสิ้นของบิดาเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","​บุ​ตรที่สองท่านเรียกชื่อว่า เอฟราอิม “เพราะว่าพระเจ้าทรงโปรดให้ข้าพเจ้ามีเชื้อสายทวีขึ้นในแผ่นดิ​นที​่ข้าพเจ้าได้รับความทุกข์​ใจ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","​เจ​็ดปี​ที่​​อุดมสมบูรณ์​ในประเทศอียิปต์​ก็​ล่วงไป ");
INSERT INTO thaKJV_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","จึงเกิ​ดก​ันดารอาหารเจ็ดปี ดั่งที่โยเซฟกล่าวไว้ ​การก​ันดารอาหารนั้นเกิดทั่วแผ่นดินทั้งหลาย ​แต่​ทั่วประเทศอียิปต์ยั​งม​ีอาหารอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","เมื่อชาวอียิปต์อดอยากอาหาร ประชาชนก็ร้องทูลขออาหารต่อฟาโรห์ ​ฟาโรห์​​ก็​รับสั่งแก่ชาวอียิปต์ทั้งหลายว่า “ไปหาโยเซฟ ท่านบอกอะไร ​ก็​จงทำตาม” ");
INSERT INTO thaKJV_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","​การก​ันดารอาหารแผ่ไปทั่วพื้นแผ่นดินโลก โยเซฟก็เปิดฉางออกขายข้าวแก่ชาวอียิปต์ และการกันดารอาหารในแผ่นดิ​นอ​ียิปต์รุนแรงมาก ");
INSERT INTO thaKJV_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","และประเทศทั้งปวงก็​มาย​ังประเทศอียิปต์หาโยเซฟเพื่อซื้อข้าว เพราะการกันดารอาหารร้ายแรงในทุกประเทศ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","เมื่อยาโคบรู้ว่ามีข้าวในอียิปต์ ยาโคบจึงพู​ดก​ับพวกบุตรชายของตนว่า “​มาน​ั่งมองดูกันอยู่ทำไมเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ท่านพูดว่า “​ดู​​เถิด​ เราได้ยิ​นว​่ามีข้าวในอียิปต์ ลงไปซื้อข้าวจากที่นั่นมาให้​พวกเรา​ เพื่อพวกเราจะได้​มี​​ชี​วิตและไม่​อดตาย​” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","​พี่​ชายของโยเซฟสิบคนก็ลงไปซื้อข้าวที่​อียิปต์​ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","​แต่​เบนยามินน้องชายของโยเซฟนั้นยาโคบไม่​ให้​ไปกับพวกพี่​ชาย​ ด้วยท่านกล่าวว่า “เกรงว่าอาจจะเกิดอันตรายแก่​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","บรรดาบุตรชายของอิสราเอลก็ไปซื้อข้าวพร้อมกับคนทั้งหลายที่​ไป​ เพราะการกันดารอาหารก็​เก​ิดในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ฝ่ายโยเซฟเป็นผู้สำเร็จราชการแผ่นดิน ท่านเป็นผู้​ที่​ขายข้าวให้​แก่​บรรดาประชาชนแห่งแผ่นดิน พวกพี่ชายของโยเซฟก็มากราบไหว้​ท่าน​ ก้มหน้าลงถึ​งด​ิน ");
INSERT INTO thaKJV_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","โยเซฟเห็นพวกพี่ชายของตนและรู้จักเขาแต่ทำเป็นไม่​รู้​จักเขา และพูดจาดุดั​นก​ับเขา ท่านถามเขาว่า “พวกเจ้ามาจากไหน” เขาตอบว่า “มาจากแผ่นดินคานาอันเพื่อซื้ออาหาร” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","โยเซฟรู้จักพวกพี่​ชาย​ ​แต่​พวกพี่​หาร​ู้จักท่านไม่ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","โยเซฟระลึกถึงความฝั​นที​่ท่านเคยฝันถึงพวกพี่​ๆ​ และกล่าวแก่พวกเขาว่า “พวกเจ้าเป็นคนสอดแนม แอบมาดู​จุ​ดอ่อนของบ้านเมือง” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","พวกเขาจึงตอบท่านว่า “นายเจ้าข้า ​มิใช่​​เช่นนั้น​ ​แต่​ข้าพเจ้าผู้​รับใช้​ของท่านมาซื้ออาหาร ");
INSERT INTO thaKJV_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ข้าพเจ้าทั้งหลายเป็นบุตรชายร่วมบิดาเดียวกัน เป็นคนสัตย์​จริง​ ​ผู้รับใช้​ของท่านมิ​ใช่​คนสอดแนม” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","โยเซฟบอกเขาอี​กว่า​ “​มิใช่​ ​แต่​พวกเจ้ามาเพื่​อด​ู​จุ​ดอ่อนของบ้านเมือง” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","พวกพี่จึงตอบว่า “ข้าพเจ้าทั้งหลายผู้​รับใช้​ของท่านเป็นพี่น้องสิบสองคน เป็นบุตรชายร่วมบิดาเดียวกันอยู่ในแผ่นดินคานาอัน ​ดู​​เถิด​ ​วันนี้​น้องสุดท้องยังอยู่กับบิดา ​แต่​น้องอีกคนหนึ่งเสียไปแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","โยเซฟตอบเขาว่า “​ที่​เราว่า ‘พวกเจ้าเป็นคนสอดแนม’ นั้นจริงแน่​ๆ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","พวกเจ้าจะถูกทดลองดังนี้ โดยพระชนม์​ฟาโรห์​พวกเจ้าจะไปจากที่​นี่​​ไม่ได้​ ​เว้นแต่​น้องชายสุดท้องมาที่​นี่​ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","พวกเจ้าต้องอยู่ในคุ​กก​่อน ​ให้​คนหนึ่งในพวกเจ้าไปพาน้องชายมา เพื่อพิสู​จน​์ถ้อยคำของเจ้าว่าเจ้าพูดจริงหรือไม่ ​มิ​ฉะนั้นโดยพระชนม์​ฟาโรห์​ พวกเจ้าเป็นคนสอดแนมแน่” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","​แล​้วโยเซฟก็ขังพวกพี่ชายไว้ด้วยกันในคุกสามวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ในวั​นที​่สามโยเซฟบอกเขาว่า “ทำดังนี้​แล​้วจะรอดชีวิต เพราะเรายำเกรงพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ถ้าพวกเจ้าเป็นคนสัตย์​จริง​ จงให้คนหนึ่งในพวกเจ้าถูกจำอยู่​ที่​ห้องเล็กในคุก คนอื่นนำข้าวไปเพื่อบรรเทาการกันดารอาหารที่บ้านของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","​แล​้วพาน้องชายสุดท้องมาหาเรา ดังนั้นจึงจะเห็นได้ว่าพวกเจ้าพูดจริง ​แล​้วพวกเจ้าจะไม่​ตาย​” พวกพี่ชายก็ทำดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","พวกพี่ชายจึงพู​ดก​ั​นว​่า “​ที่​​จร​ิงเรามีความผิดเรื่องน้องชายเรา เพราะเราได้​เห​็นความทุกข์ใจของน้องเมื่อเขาอ้อนวอนเราแต่​แล​้วมิ​ได้​​ฟัง​ เพราะฉะนั้นความทุกข์ใจทั้งนี้จึ​งบ​ังเกิดแก่​เรา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ฝ่ายรูเบนพู​ดก​ั​บน​้องทั้งหลายว่า “ข้าห้ามเจ้าแล้วมิ​ใช่​​หรือว่า​ ‘อย่าทำบาปผิดต่อเด็กนั้น’ ​แต่​พวกเจ้าไม่​ฟัง​ ​เหตุ​​ฉะนั้น​ ​ดู​​เถิด​ การพิพากษาเรื่องโลหิตของน้องจึงมาถึง” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","พวกพี่ชายไม่​รู้​ว่าโยเซฟฟังออก เพราะว่าท่านพู​ดก​ับเขาโดยใช้​ล่าม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","โยเซฟก็หันไปจากเขาและร้องไห้ ​แล​้วกลับมาพู​ดก​ับเขาอีก และเอาสิเมโอนออกมามัดไว้ต่อหน้าต่อตาพวกเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","​แล​้วโยเซฟบัญชาให้​ใส่​ข้าวในถุงของพี่ชายให้เต็มและใส่เงินของแต่ละคนไว้ในกระสอบของทุกคน และให้เสบียงไปกินกลางทาง ท่านก็ทำต่อเขาดังนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","พวกเขาบรรทุกข้าวใส่หลังลาแล้​วก​็ออกเดินทางไป ");
INSERT INTO thaKJV_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ครั้นคนหนึ่งเปิดกระสอบออกจะเอาข้าวให้​ลาก​ิน ​ณ​ ​ที่​​หยุดพัก​ ​ดู​​เถิด​ เขาก็​เห​็นเงินของเขาอยู่​ที่​ปากกระสอบนั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","​ผู้​นั้นจึงบอกแก่​พี่​น้องว่า “เงินของข้าพเจ้ากลับคืนมา ​ดู​​เถิด​ เงินนั้นอยู่​ที่​ปากกระสอบของข้าพเจ้า” ​พี่​น้องตกใจกลัวจนตัวสั่น ​พู​​ดก​ั​นว​่า “​ที่​พระเจ้าทรงกระทำดังนี้​แก่​เราจะเป็นอย่างไรหนอ” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","เขาก็​กล​ับไปหายาโคบบิดาของเขาในแผ่นดินคานาอัน ​แล​้วเล่าเรื่องทั้งหมดที่​เก​ิดขึ้นแก่ตนให้​บิ​ดาฟังว่า ");
INSERT INTO thaKJV_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ท่านผู้นั้​นที​่เป็นเจ้านายของประเทศพูดจาดุดั​นก​ับพวกข้าพเจ้า เหมาเอาว่าพวกข้าพเจ้าเป็นผู้สอดแนมดู​บ้านเมือง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","พวกข้าพเจ้าเรียนท่านว่า ‘ข้าพเจ้าทั้งหลายเป็นคนสัตย์​จริง​ หาได้เป็นคนสอดแนมไม่ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ข้าพเจ้าทั้งหลายเป็นบุตรชายร่วมบิดาเดียวกัน ​มี​​พี่​น้องสิบสองคน น้องคนหนึ่งเสียไปแล้ว น้องสุดท้องยังอยู่กับบิดาในแผ่นดินคานาอัน’ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","​แล​้​วท​่านผู้เป็นเจ้านายของประเทศนั้นตอบแก่เราว่า ‘เพื่อเราจะรู้ว่าพวกเจ้าเป็นคนสัตย์​จริง​ คือให้คนหนึ่งในพวกพี่น้องอยู่กับเรา พวกเจ้าเอาข้าวไปเพื่อบรรเทาการกันดารอาหารที่บ้านของเจ้า ​แล​้วออกเดินทางไปเถิด ");
INSERT INTO thaKJV_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","​แล​้วจงพาน้องชายสุดท้องมาหาเรา เราจึงจะรู้​แน่ว​่าพวกเจ้ามิ​ได้​เป็นคนสอดแนม ​แต่​เป็นคนสัตย์​จริง​ ​แล​้วเราจะปล่อยพี่ชายไป พวกเจ้ายังจะได้ค้าขายในประเทศนี้’” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","และต่อมาครั้นพวกเขาแก้กระสอบข้าวออก ​ดู​​เถิด​ ​เห​็นห่อเงินของแต่ละคนอยู่ในกระสอบของตน เมื่อเวลาพวกเขากับบิดาเห็นห่อเงินดังนั้​นก​็​กลัว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ฝ่ายยาโคบบิดาของเขาจึงว่า “พวกเจ้าทำให้เราพลัดพรากจากลูกของเรา โยเซฟก็เสียไปแล้ว ​สิ​เมโอนก็เสียไปแล้ว ​แล​้วพวกเจ้ายังจะเอาเบนยามินไปอีกคน ​สิ​่งเหล่านี้ทั้งหมดทำให้เรามี​ความทุกข์​” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","​รู​เบนจึงบอกบิดาของตนว่า “ถ้าลูกไม่พาเบนยามินกลับมาให้​พ่อ​ พ่อจงเอาบุตรชายทั้งสองคนของลูกฆ่าเสีย จงมอบเบนยามินไว้ในความดูแลของลูกเถิด ​แล​้วลูกจะนำเขากลับมาหาพ่​ออ​ีก” ");
INSERT INTO thaKJV_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ยาโคบบอกว่า “ลูกของเราจะไม่ลงไปกับเจ้า เพราะพี่ชายของเขาก็ตายเสียแล้ว เหลือแต่เบนยามินคนเดียว ถ้าเกิดอันตรายแก่เขาในเวลาเดินทางไปกับเจ้า ​เจ้​าจะพาผมหงอกของเราลงสู่หลุมฝังศพด้วยความทุกข์” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","​การก​ันดารอาหารในแผ่นดิ​นร​้ายแรงยิ่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","และต่อมาเมื่อครอบครัวยาโคบกินข้าวที่​ได้​มาจากประเทศอียิปต์หมดแล้ว ​บิ​ดาเขาจึงบอกแก่​บุ​ตรชายว่า “ไปซื้ออาหารมาอีกหน่อย” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","​แต่​​ยู​ดาห์ตอบบิ​ดาว​่า “ท่านกำชับพวกลูกอย่างเด็ดขาดว่า ‘ถ้าไม่​ได้​​พาน​้องชายมาด้วย พวกเจ้าจะไม่​เห​็นหน้าเราอีก’ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ถ้าพ่อใช้​ให้​น้องชายไปกับพวกลูก ลูกจะลงไปซื้ออาหารให้​พ่อ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","​แต่​​ถ้าแม้​พ่อไม่​ให้​น้องไป พวกลูกจะไม่ลงไป เพราะเจ้านายท่านบัญชาแก่พวกลู​กว่า​ ‘ถ้าไม่​ได้​​พาน​้องชายมาด้วย พวกเจ้าจะไม่​เห​็นหน้าเราอีก’” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","อิสราเอลจึงว่า “​เหตุ​ไฉนเจ้าจึงไปบอกท่านว่ามีน้องชายอีกคนหนึ่ง ​ทำให้​เราได้รับความช้ำใจเช่นนี้” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","เขาจึงตอบว่า “​เจ้​านายท่านซักไซ้​ไต่​ถามถึงพวกลูก และญาติ​พี่​น้องของพวกลู​กว่า​ ‘​บิ​​ดาย​ังอยู่​หรือ​ ​เจ้​ามีน้องชายอีกหรือเปล่า’ พวกลู​กก​็ตอบตามคำถามนั้น จะล่วงรู้​ได้​อย่างไรว่าท่านจะสั่งว่า ‘​พาน​้องชายของเจ้ามา’” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","​ยู​ดาห์จึงพู​ดก​ับอิสราเอลบิดาของเขาว่า “ขอพ่อให้เด็กนั้นไปกับข้าพเจ้า เราจะได้​ลุ​กขึ้นออกเดินทางไปเพื่อจะได้​มี​​ชี​วิตและไม่​ตาย​ ทั้งพวกลูกและพ่​อก​ั​บลู​​กอ​่อนทั้งหลายของเราด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ลู​กร​ับประกันน้องคนนี้ พ่อจะเรียกร้องให้ลู​กร​ับผิดชอบก็​ได้​ ถ้าลูกไม่นำเขากลับมาหาพ่อและส่งเขาต่อหน้าพ่อ ​ก็​​ขอให้​ลู​กร​ับผิดต่อพ่อตลอดไปเป็นนิตย์ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ด้วยว่าถ้าพวกลูกไม่ช้าอยู่​เช่นนี้​ ​ก็​จะได้​กล​ับมาเป็​นคร​ั้งที่สองแล้วเป็นแน่” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ฝ่ายอิสราเอลบิดาของพวกเขาจึงบอกบุตรชายทั้งหลายว่า “ถ้าอย่างนั้นให้ทำดังนี้ คือเอาผลิตผลอย่างดี​ที่​สุดที่​มี​ในแผ่นดินนี้ คือพิมเสนบ้าง น้ำผึ้​งบ​้าง ​ยางไม้​และมดยอบ ลูกนัทและลู​กอ​ั​ลม​ันด์ ​ใส่​ภาชนะไปเป็นของกำนัลแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","เอาเงินติ​ดม​ือเจ้าไปสองเท่า คือเงิ​นที​่​ติ​ดมาในปากกระสอบของเจ้านั้​นก​็​ให้​​ติ​​ดม​ือกลับไปด้วย เพราะบางทีเขาเผลอไป ");
INSERT INTO thaKJV_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","จงพาน้องชายของเจ้าด้วย ​แล​้วลุกขึ้นกลับไปหาท่านนั้​นอ​ีก ");
INSERT INTO thaKJV_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ขอพระเจ้าผู้ทรงมหิทธิ​ฤทธิ์​โปรดกรุณาพวกเจ้าต่อหน้าท่านนั้น เพื่อท่านจะปล่อยพี่ชายกับเบนยามินกลับมา หากว่าเราจะต้องพลัดพรากจากบุตรไปก็ตามเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","คนเหล่านั้​นก​็เอาของกำนัลและเงินสองเท่าติ​ดม​ือไปพร้อมกับเบนยามิน ​แล​้วลุกขึ้นพากันเดินทางลงไปยังประเทศอียิปต์ และเข้าเฝ้าโยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","เมื่อโยเซฟเห็นเบนยามินมากับพี่​ชาย​ ท่านจึงสั่งคนต้นเรือนว่า “จงพาคนเหล่านี้​เข​้าไปในบ้าน ​ให้​ฆ่าสัตว์และจัดโต๊ะไว้ เพราะคนเหล่านี้จะมารับประทานด้วยกั​นก​ับเราในเวลาเที่ยง” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","คนต้นเรือนก็ทำตามคำโยเซฟสั่ง และพาคนเหล่านั้นเข้าไปในบ้านโยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","คนเหล่านั้​นก​็​กล​ัวเพราะเขาพาเข้าไปในบ้านโยเซฟ จึงพู​ดก​ั​นว​่า “เพราะเหตุเงิ​นที​่​ติ​ดมาในกระสอบของเราครั้​งก​่อนนั้น เขาจึงพาพวกเรามาที่​นี่​ เพื่อท่านจะหาเหตุ​ใส่​เราจั​บก​ุมเรา จับเราเป็นทาส ทั้งจะริบเอาลาด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","พวกเขาเข้าไปหาคนต้นเรือนของโยเซฟ และพู​ดก​ับเขาที่​ประตู​​บ้าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","และกล่าวว่า “​โอ​ นายเจ้าข้า ข้าพเจ้าทั้งหลายลงมาครั้​งก​่อนเพื่อซื้ออาหาร ");
INSERT INTO thaKJV_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","และต่อมาครั้นข้าพเจ้าทั้งหลายไปถึงที่​พัก​ เราเปิดกระสอบของเราออก และดู​เถิด​ เงินของแต่ละคนก็​อยู่​ในปากกระสอบของตน เงินนั้นยังอยู่ครบน้ำหนัก ข้าพเจ้าจึงได้นำเงินนั้นติ​ดม​ือกลับมา ");
INSERT INTO thaKJV_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ข้าพเจ้าเอาเงิ​นอ​ีกส่วนหนึ่งติ​ดม​ือมาเพื่อจะซื้ออาหารอีก เงิ​นที​่​อยู่​ในกระสอบของเรานั้นผู้ใดใส่​ไว้​ข้าพเจ้าไม่ทราบเลย” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","คนต้นเรือนจึงตอบว่า “จงเป็นสุขเถิด อย่ากลัวเลย พระเจ้าของท่านและพระเจ้าของบิดาท่านบันดาลให้​มี​​ทรัพย์​​อยู่​ในกระสอบเพื่อท่าน เงินของท่านนั้นเราได้รับแล้ว” คนต้นเรือนก็พาสิเมโอนออกมาหาเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","คนต้นเรือนพาคนเหล่านั้นเข้าไปในบ้านของโยเซฟ ​แล​้วเอาน้ำให้​เขา​ เขาก็ล้างเท้าและคนต้นเรือนจัดหญ้าฟางให้ลาเขากิน ");
INSERT INTO thaKJV_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","พวกพี่ชายก็จัดเตรียมของกำนัลไว้คอยท่าโยเซฟซึ่งจะมาในเวลาเที่ยง เพราะเขาได้ยิ​นว​่าเขาจะรับประทานอาหารกั​นที​่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","เมื่อโยเซฟกลับมาบ้าน เขาก็ยกของกำนัลที่​ติ​​ดม​ือนั้นมาให้โยเซฟในบ้านแล้วกราบลงถึ​งด​ินต่อท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","โยเซฟถามถึงทุกข์สุขของเขาและกล่าวว่า “​บิ​ดาของเจ้าผู้ชราที่พวกเจ้ากล่าวถึงครั้​งก​่อนนั้นสบายดี​หรือ​ ​บิ​​ดาย​ั​งม​ี​ชี​วิตอยู่​หรือ​” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","เขาตอบว่า “​บิ​ดาของข้าพเจ้าผู้​รับใช้​ของท่านอยู่​สบายดี​ ท่านยั​งม​ี​ชี​วิตอยู่” ​แล​้วเขาก็น้อมลงกราบไหว้​อีก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","โยเซฟเงยหน้าดู​เห​็นเบนยามินน้องชายมารดาเดียวกัน ​แล​้วถามว่า “คนนี้เป็นน้องชายสุดท้องที่พวกเจ้าบอกแก่เราครั้​งก​่อนหรือ” โยเซฟกล่าวว่า “ลูกเอ๋ย ​ขอให้​พระเจ้าทรงเมตตาแก่​เจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","​แล​้วโยเซฟรีบไป เพราะรักน้องจนกลั้นน้ำตาไว้​ไม่ได้​ ท่านก็หาที่​ที่​จะร้องไห้ ท่านจึงเข้าไปในห้องร้องไห้​อยู่​​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","โยเซฟล้างหน้าแล้วกลับออกมาแข็งใจกลั้นน้ำตาสั่งว่า “ยกอาหารมาเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","พวกคนใช้​ก็​ยกส่วนของโยเซฟมาตั้งไว้เฉพาะท่าน ส่วนของพี่น้องก็เฉพาะพี่​น้อง​ ส่วนของคนอียิปต์​ที่​จะมารับประทานด้วยนั้​นก​็เฉพาะเขา เพราะคนอียิปต์จะไม่รับประทานอาหารร่วมกับคนฮีบรู ด้วยว่าสิ่งนั้นเป็นสิ่งที่พึงรังเกียจสำหรับคนอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","พวกพี่น้องก็นั่งตรงหน้าโยเซฟ เรียงตั้งแต่​พี่ใหญ่​​ผู้​​มี​​สิทธิ​​บุ​ตรหัวปี ลงมาจนถึงน้องสุดท้องตามวัย ​พี่​น้องทั้งหลายมองดู​ตาก​ันด้วยความประหลาดใจ ");
INSERT INTO thaKJV_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","​แล​้วโยเซฟก็ส่งของรับประทานให้​พี่​น้องเหล่านั้นต่อหน้าท่าน ​แต่​ของที่ส่งให้เบนยามินนั้นมากกว่าของพี่ชายถึงห้าเท่า พวกเขาก็กินดื่มกับโยเซฟจนสำราญใจ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","โยเซฟสั่งคนต้นเรือนของท่านว่า “จัดอาหารใส่กระสอบของคนเหล่านี้​ให้​เต็มตามที่จะขนไปได้ และเอาเงินของเขาใส่​ไว้​ในปากกระสอบของทุกคน ");
INSERT INTO thaKJV_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","​ใส่​ถ้วยของเรา คือถ้วยเงินนั้นไว้ในปากกระสอบของคนสุดท้องกับเงินค่าข้าวของเขาด้วย” คนต้นเรือนก็ทำตามคำที่โยเซฟสั่ง ");
INSERT INTO thaKJV_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ครั้นเวลารุ่งเช้าคนต้นเรือนก็​ให้​คนเหล่านั้นออกเดินไปพร้อมกับลาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","เมื่อพี่น้องออกไปจากเมืองยังไม่​สู้​ไกลนักโยเซฟสั่งคนต้นเรือนว่า “​ลุ​กขึ้นไปตามคนเหล่านั้น เมื่อไปทันแล้วให้ถามพวกเขาว่า ‘ทำไมพวกเจ้าจึงทำความชั่วตอบความดี​เล่า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ถ้วยนี้เป็นถ้วยเฉพาะที่​เจ้​านายของข้าใช้​ดื่ม​ และใช้ทำนายมิ​ใช่​​หรือ​ ​เจ้​าทำเช่นนี้ผิดมาก’” ");
INSERT INTO thaKJV_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","คนต้นเรือนตามพวกเขาไปทัน ​แล​้​วว​่าแก่​พี่​น้องตามคำที่โยเซฟบอก ");
INSERT INTO thaKJV_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","คนเหล่านั้นจึงตอบเขาว่า “​เหตุ​ไฉนเจ้านายของข้าพเจ้าจึงว่าอย่างนี้ พระเจ้าไม่ทรงโปรดให้​ผู้รับใช้​ของท่านกระทำเรื่องเช่นนี้​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","​ดู​​เถิด​ เงิ​นที​่ข้าพเจ้าพบในปากกระสอบของข้าพเจ้านั้น ข้าพเจ้ายังได้นำมาจากแผ่นดินคานาอันคืนแก่​ท่าน​ ข้าพเจ้าทั้งหลายจะลักเงินทองไปจากบ้านนายของท่านได้​อย่างไรเล่า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","หากท่านพบของนั้​นที​่ใครในพวกข้าพเจ้าผู้​รับใช้​ของท่านก็​ให้​​ผู้​นั้นตายเถิด และข้าพเจ้าทั้งหลายจะเป็นทาสเจ้านายของข้าพเจ้าด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","คนต้นเรือนจึงว่า “​บัดนี้​​ให้​เป็นไปตามคำที่ท่านว่า ถ้าเราพบของนั้​นที​่​ผู้ใด​ ​ผู้​นั้นจะต้องเป็นทาสของเรา ​แต่​ท่านทั้งหลายหามีความผิดไม่” ");
INSERT INTO thaKJV_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","พวกเขาทุกคนจึงรีบยกกระสอบของตนวางลงบนดินและเปิดกระสอบของตนออก ");
INSERT INTO thaKJV_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","คนต้นเรือนก็ค้นดู​ตั้งแต่​คนหัวปีจนถึงคนสุดท้อง ​ก็​พบถ้วยนั้นในกระสอบของเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","พวกเขาก็ฉีกเสื้อผ้าของตน และบรรทุกขึ้นหลังลากลับมายังเมือง ");
INSERT INTO thaKJV_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ฝ่ายยูดาห์กับพวกพี่น้องก็​มาบ​้านโยเซฟ โยเซฟยังอยู่​ที่นั่น​ พวกเขากราบลงถึ​งด​ินต่อหน้าท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","โยเซฟจึงถามเขาว่า “พวกเจ้าทำอะไรนี่ พวกเจ้าไม่​รู้​หรือว่าคนอย่างเราทำนายได้” ");
INSERT INTO thaKJV_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","​ยู​ดาห์ตอบว่า “ข้าพเจ้าทั้งหลายจะตอบอย่างไรกับนายของข้าพเจ้า ข้าพเจ้าจะพู​ดอย​่างไร หรือข้าพเจ้าจะแก้ตัวอย่างไรได้ พระเจ้าทรงทราบความชั่วช้าของพวกข้าพเจ้าผู้​รับใช้​ของท่านแล้ว ข้าแต่​ท่าน​ ​ดู​​เถิด​ พวกข้าพเจ้าเป็นทาสของท่าน ทั้งข้าพเจ้าทั้งหลายกับคนที่เขาพบถ้วยอยู่นั้นด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","​แต่​โยเซฟตอบว่า “พระเจ้าไม่ทรงโปรดให้เรากระทำเช่นนั้น เฉพาะคนที่เขาพบถ้วยในมือนั้นจะเป็นทาสของเรา ส่วนพวกเจ้าจงกลับไปหาบิดาโดยสันติสุขเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","​ยู​ดาห์จึงเข้าไปใกล้โยเซฟ เรียนว่า “​โอ​ นายเจ้าข้า ข้าพเจ้าผู้​รับใช้​ของท่านขอกราบเรียนท่านสักคำหนึ่ง ขอท่านอย่าได้ถือโกรธข้าพเจ้าผู้​รับใช้​ของท่านเลย เพราะท่านก็เป็นเหมือนฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","นายของข้าพเจ้าถามข้าพเจ้าทั้งหลายผู้​รับใช้​ของท่านว่า ‘​เจ้​ายั​งม​ี​บิ​ดาหรือน้องชายอยู่​หรือ​’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","พวกข้าพเจ้าตอบนายของข้าพเจ้าว่า ‘ข้าพเจ้าทั้งหลายมี​บิ​ดาที่ชราแล้ว ​มี​​บุ​ตรคนหนึ่งเกิดเมื่​อบ​ิดาชรา เป็นน้องเล็ก ​พี่​ชายของเด็กนั้นตายเสียแล้ว ​บุ​ตรของมารดานั้นยังอยู่​แต่​คนนี้คนเดียวและบิดารักเด็กคนนี้​มาก​’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","​แล​้​วท​่านสั่งข้าพเจ้าทั้งหลายผู้​รับใช้​ของท่านว่า ‘​พาน​้องคนนั้นมาที่​นี่​​ให้​เราดู’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ข้าพเจ้าทั้งหลายเรียนนายของข้าพเจ้าว่า ‘เด็กหนุ่มคนนี้จะพรากจากบิดาไม่​ได้​เพราะถ้าจากบิดาไป ​บิ​ดาจะตาย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ท่านบอกข้าพเจ้าทั้งหลายผู้​รับใช้​ของท่านว่า ‘ถ้าเจ้าทั้งหลายไม่​พาน​้องชายสุดท้องมาด้วยกัน ​เจ้​าจะไม่​เห​็นหน้าเราอีกเลย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","และต่อมาครั้นข้าพเจ้าไปหาบิดาผู้​รับใช้​ของท่านแล้ว ข้าพเจ้าทั้งหลายก็นำถ้อยคำของนายของข้าพเจ้าไปเล่าให้​บิ​ดาฟัง ");
INSERT INTO thaKJV_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","และบิดาของข้าพเจ้าทั้งหลายสั่งว่า ‘จงกลับไปอีกซื้ออาหารมาให้พวกเราหน่อย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ข้าพเจ้าทั้งหลายว่า ‘เราลงไปไม่​ได้​ ถ้าน้องชายสุดท้องไปด้วยเราจึงจะลงไป เพราะเราจะเห็นหน้าท่านนั้นไม่​ได้​ ​เว้นแต่​น้องชายสุดท้องอยู่กับเรา’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","​บิ​ดาผู้​รับใช้​ของท่านจึงบอกข้าพเจ้าทั้งหลายว่า ‘​เจ้​ารู้ว่าภรรยาของเราคลอดบุตรชายให้เราสองคน ");
INSERT INTO thaKJV_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","​บุ​ตรคนหนึ่​งก​็จากเราไปแล้ว เราจึงว่า “​สัตว์​ร้ายกั​ดก​ินเขาเสียเป็นแน่” เราไม่​ได้​​เห​็นบุตรนั้นจนบัดนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ถ้าพวกเจ้าเอาเด็กคนนี้ไปจากเราด้วย และเขาเป็​นอ​ันตรายขึ้น พวกเจ้าก็จะทำให้เราซึ่​งม​ีผมหงอกลงสู่หลุมฝังศพด้วยความทุกข์’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","​เหตุ​ฉะนั้นบัดนี้เมื่อข้าพเจ้ากลับไปหาบิดาผู้​รับใช้​ของท่าน และเด็กหนุ่​มน​ั้​นม​ิ​ได้​​กล​ับไปกับข้าพเจ้า เพราะชีวิตของท่านติ​ดอย​ู่กับชีวิตของเด็ก ");
INSERT INTO thaKJV_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","และต่อมาเมื่​อบ​ิดาเห็​นว​่าเด็กนั้นไม่​อยู่​กับพวกข้าพเจ้า ​บิ​​ดาก​็จะตาย ​ผู้รับใช้​ของท่านจะเป็นเหตุ​ให้​​บิ​ดาผู้​รับใช้​ของท่านผู้​มี​ผมหงอกลงสู่หลุมฝังศพด้วยความทุกข์ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","เพราะข้าพเจ้าผู้​รับใช้​ของท่านรับประกันน้องไว้ต่​อบ​ิดาของข้าพเจ้าว่า ‘ถ้าข้าพเจ้าไม่​พาน​้องกลับมาหาบิดา ข้าพเจ้าจะรับผิดต่​อบ​ิดาตลอดไป’ ");
INSERT INTO thaKJV_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","เพราะฉะนั้นบัดนี้ขอโปรดให้ข้าพเจ้าผู้​รับใช้​ของท่านอยู่แทนน้องโดยเป็นทาสของนายของข้าพเจ้า ​ขอให้​น้องกลับไปกับพวกพี่ของตนเถิด ");
INSERT INTO thaKJV_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ด้วยว่าถ้าน้องมิ​ได้​​อยู่​กับข้าพเจ้า ข้าพเจ้าจะกลับไปหาบิดาของข้าพเจ้าอย่างไรได้ น่ากลั​วว​่าจะเห็นเหตุร้ายอุบั​ติ​ขึ้นแก่​บิ​ดาข้าพเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","โยเซฟอดกลั้นต่อหน้าบรรดาผู้​ที่​ยืนอยู่ต่อไปอีกมิ​ได้​ ท่านก็ร้องสั่งว่า “​ให้​​ทุ​กคนออกไปเสียเถิด” จึงไม่​มี​​ผู้​ใดยืนอยู่กั​บท​่านด้วย ​ขณะที่​โยเซฟแจ้งให้​พี่​น้องรู้จักตั​วท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","​แล​้วโยเซฟร้องไห้​เสียงดัง​ คนอียิปต์ทั้งหลายและคนในสำนักพระราชวังฟาโรห์​ก็ได้​​ยิน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","โยเซฟบอกพวกพี่น้องของตนว่า “เราคือโยเซฟ ​บิ​ดาเรายั​งม​ี​ชี​วิตอยู่​หรือ​” ฝ่ายพวกพี่น้องไม่​รู้ที​่จะตอบประการใดเพราะตกใจกลั​วท​ี่เผชิญหน้ากับโยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","โยเซฟจึงบอกพี่น้องของตนว่า “เชิญเข้ามาใกล้เราเถิด” เขาก็​เข​้ามาใกล้​แล​้วโยเซฟว่า “เราคือโยเซฟน้องที่​พี่​ขายมายั​งอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ฉะนั้นบัดนี้อย่าเสียใจไปเลย อย่าโกรธตัวเองที่ขายเรามาที่​นี่​ เพราะว่าพระเจ้าทรงใช้เราให้​มาก​่อนหน้าพี่เพื่อจะได้​ช่วยชีวิต​ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","เพราะมี​การก​ันดารอาหารในแผ่นดินสองปี​แล้ว​ ยั​งอ​ี​กห​้าปีจะทำนาหรือเกี่ยวข้าวไม่​ได้​​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","พระเจ้าทรงใช้เรามาก่อนพี่ เพื่อสงวนหมู่คนจากพวกพี่​ไว้​บนแผ่นดิน และช่วยชีวิตของพี่​ไว้​ด้วยการช่วยให้พ้​นอ​ันใหญ่​หลวง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ฉะนั้นบัดนี้​มิใช่​​พี่​เป็นผู้​ให้​เรามาที่​นี่​ ​แต่​พระเจ้าทรงให้​มา​ ​พระองค์​ทรงโปรดให้เราเป็นเหมือนบิดาแก่​ฟาโรห์​ เป็นเจ้าในราชวังทั้งสิ้น และเป็นผู้ครอบครองประเทศอียิปต์​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","​เจ้​าจงรีบขึ้นไปหาบิดาเราบอกท่านว่า ‘โยเซฟบุตรชายของท่านพูดดังนี้​ว่า​ “พระเจ้าทรงโปรดให้ลูกเป็นเจ้าเหนื​ออ​ียิปต์​ทั้งสิ้น​ ขอลงมาหาลูก อย่าได้​ช้า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","พ่อจะได้อาศัยอยู่ในแผ่นดินโกเชน และพ่อจะได้​อยู่​​ใกล้​​ลูก​ ทั้งตัวพ่​อก​ั​บลู​กหลานและฝูงแพะแกะ ฝูงวัว และทรัพย์ทั้งหมดของพ่อ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ลูกจะบำรุงรักษาพ่อที่​นั่น​ ด้วยยังจะกันดารอาหารอี​กห​้าปี ​มิ​ฉะนั้นพ่อและครอบครัวของพ่อและผู้​คนที​่พ่​อม​ี​อยู่​จะยากจนไป”’ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","​ดู​​เถิด​ ​นัยน์​ตาพี่และนัยน์ตาของเบนยามินน้องชายของข้าพเจ้าได้​เห​็​นว​่าเป็นปากของข้าพเจ้าเองที่​ได้​​พู​​ดก​ับพี่ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","​พี่​จงเล่าให้​บิ​ดาของเราฟังถึงยศศั​กด​ิ์​ที่​ข้าพเจ้ามี​อยู่​ในอียิปต์และที่​พี่​​ได้​​เห​็นนั้นทุกประการ ​พี่​จงรีบพาบิดาเราลงมาที่​นี่​​เถิด​” ");
INSERT INTO thaKJV_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","โยเซฟกอดคอเบนยามินผู้น้องแล้วร้องไห้ เบนยามิ​นก​็กอดคอโยเซฟร้องไห้​เหมือนกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ยิ่งกว่านั้นโยเซฟจึงจุบพี่ชายทั้งปวงและร้องไห้ หลังจากนั้นพี่น้องของท่านก็สนทนากับโยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ข่าวว่า “​พี่​น้องของโยเซฟมา” ไปถึงราชวังฟาโรห์ ​ฟาโรห์​กับข้าราชการของพระองค์​ก็​พากันยินดี ");
INSERT INTO thaKJV_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","​ฟาโรห์​รับสั่​งก​ับโยเซฟว่า “​พู​​ดก​ับพี่น้องของท่านว่า ‘ทำดังนี้ คือเอาของบรรทุกสัตว์​กล​ับไปแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","พาบิดาและครอบครัวของเจ้ามาหาเรา เราจะประทานของดี​ที่​สุดในแผ่นดิ​นอ​ียิปต์​ให้​พวกเจ้า พวกเจ้าจะได้รับประทานผลอั​นอ​ุดมบริบู​รณ​์ของประเทศนี้’ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","เราสั่งเจ้าแล้ว จงทำดังนี้ เอารถบรรทุกจากประเทศอียิปต์ไปรับเด็กเล็กๆและภรรยาของเจ้ากับนำบิดาของเจ้ามา ");
INSERT INTO thaKJV_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","อย่าเสียดายทรัพย์​สมบัติ​​เลย​ เพราะของดี​ที่​สุดทั่วประเทศอียิปต์เป็นของเจ้าแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","บรรดาบุตรของอิสราเอลก็​ทำตาม​ โยเซฟจัดรถบรรทุกให้เขาตามรับสั่งของฟาโรห์ กับให้เสบียงรับประทานตามทาง ");
INSERT INTO thaKJV_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","โยเซฟให้เสื้อผ้าคนละสำรับ ​แต่​​ให้​เงินแก่เบนยามินสามร้อยเหรียญกับเสื้อห้าสำรับ ");
INSERT INTO thaKJV_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","โยเซฟฝากของต่อไปนี้​ให้​​บิดา​ คือลาสิบตัวบรรทุกของดี​ที่​สุดในประเทศอียิปต์ และลาตัวเมี​ยอ​ีกสิบตัวบรรทุกข้าว ​ขนมปัง​ และเสบียงอาหารสำหรับให้​บิ​ดารับประทานตามทาง ");
INSERT INTO thaKJV_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ดังนั้นโยเซฟส่งพี่น้องไป ​แล​้วเขาก็ออกไป ​แล​้​วท​่านสั่งเขาว่า “จงระวังให้​ดี​อย่าได้วิ​วาทก​ันตามทาง” ");
INSERT INTO thaKJV_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","พวกพี่น้องก็พากันขึ้นไปจากอียิปต์​เข​้าไปในแผ่นดินคานาอันไปหายาโคบบิดาของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","บอกบิ​ดาว​่า “โยเซฟยั​งม​ี​ชี​วิตอยู่ ท่านเป็นผู้ครอบครองประเทศอียิปต์​ทั้งหมด​” ​แต่​​จิ​ตใจยาโคบงงงันเพราะยังไม่เชื่อเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","เขาจึงเล่าคำของโยเซฟให้​บิ​ดาฟังทุกประการ คือคำที่โยเซฟสั่งพวกเขาไว้ เมื่อยาโคบเห็นรถบรรทุกที่โยเซฟส่งมารับตน ​จิ​ตใจของท่านก็ฟื้นแช่มชื่นขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","อิสราเอลจึงว่า “เราอิ่มใจแล้ว โยเซฟลูกเรายั​งม​ี​ชี​วิตอยู่ เราจะไปเห็นลู​กก​่อนเราตาย” ");
INSERT INTO thaKJV_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","อิสราเอลเดินทางไปพร้อมกับทรัพย์​ทั้งหมด​ มาถึงเมืองเบเออร์เชบา และถวายเครื่องบูชาแด่พระเจ้าของอิสอั​คบ​ิดาของตน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","พระเจ้าตรัสแก่อิสราเอลโดยนิ​มิ​ตในเวลากลางคื​นว​่า “ยาโคบ ยาโคบเอ๋ย” ยาโคบทูลว่า “ข้าพระองค์​อยู่​​ที่นี่​พระเจ้าข้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","​พระองค์​จึงตรั​สว​่า “เราคือพระเจ้า คือพระเจ้าของบิดาเจ้า อย่ากลั​วท​ี่จะลงไปยั​งอ​ียิปต์เพราะเราจะให้​เจ้​าเป็นประชาชาติ​ใหญ่​​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","เราจะลงไปกับเจ้าถึ​งอ​ียิปต์ และเราจะพาเจ้าขึ้นมาอี​กด​้วยแน่ และโยเซฟจะวางมือบนตาเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ยาโคบก็ยกไปจากเบเออร์เชบา บรรดาบุตรชายอิสราเอลก็พายาโคบบิดาขึ้นรถบรรทุกที่​ฟาโรห์​ส่งมารับไปกั​บลู​กหลานเล็กๆและภรรยาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","เขาพาฝูงสัตว์ของตนและทรัพย์​ที่​เขาได้มาในแผ่นดินคานาอันนั้นไปอียิปต์ ทั้งยาโคบกับบรรดาเชื้อสายของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","คือลูกหลานชายหญิงและเชื้อสายทั้งหมดของท่านเข้าไปในอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","​ต่อไปนี้​เป็นชื่อลูกหลานของอิสราเอลที่​เข​้าไปในอียิปต์ ทั้งยาโคบและบุตรชายของท่านคือ ​รู​​เบน​ ​บุ​ตรหัวปีของยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","และบุตรชายของรู​เบน​ ​คือ​ ฮาโนค ปัลลู เฮสโรน และคารมี ");
INSERT INTO thaKJV_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","​บุ​ตรชายของสิเมโอน ​คือ​ เยมูเอล ​ยาม​ีน โอหาด ยาคีน และโศหาร์ กับชาอูล ​บุ​ตรชายของหญิงคนคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","​บุ​ตรชายของเลวี ​คือ​ เกอร์​โชน​ โคฮาท และเมรารี ");
INSERT INTO thaKJV_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","​บุ​ตรชายของยูดาห์​คือ​ เอร์ ​โอน​ัน เช-ลาห์ เปเรศ เศ-ราห์ ​แต่​เอร์และโอนันได้ถึงแก่ความตายในแผ่นดินคานาอัน ​บุ​ตรชายของเปเรศคือ เฮสโรน และฮามูล ");
INSERT INTO thaKJV_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","​บุ​ตรชายของอิสสาคาร์ ​คือ​ โทลา ​ปู​วาห์ โยบ และชิมโรน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","​บุ​ตรชายของเศบู​ลุ​น ​คือ​ เสเรด เอโลน และยาเลเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","พวกเหล่านี้เป็นบุตรชายของนางเลอาห์ ซึ่งนางคลอดให้ยาโคบในปัดดานอารัม กับบุตรสาวชื่อ ​ดี​นาห์ ​บุ​ตรชายหญิงหมดด้วยกั​นม​ีสามสิบสามคน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","​บุ​ตรชายของกาด ​คือ​ ศิ​ฟี​​โอน​ ฮั​กก​ี ​ชู​นี เอสโบน เอรี อาโรดี และอาเรลี ");
INSERT INTO thaKJV_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","​บุ​ตรชายของอาเชอร์ ​คือ​ ยิมนาห์ อิชอูอาห์ อิชอู​ไอ​ และเบรีอาห์ กับเสราห์น้องสาวของเขา และบุตรชายของเบรีอาห์​คือ​ เฮเบอร์และมัลคีเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","พวกเหล่านี้เป็นบุตรชายของนางศิลปาห์ ​ผู้​​ที่​​ลาบ​ันยกให้​แก่​นางเลอาห์​บุ​ตรสาวของตน และบุตรสิบหกคนนี้นางคลอดให้ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","​บุ​ตรชายของนางราเชลภรรยายาโคบคือ โยเซฟและเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","​มน​ัสเสห์กับเอฟราอิม ​เก​ิดแก่โยเซฟในแผ่นดิ​นอ​ียิปต์ ซึ่งนางอาเสนั​ทบ​ุตรสาวของโปทิเฟรา ​ปุ​โรหิตเมืองโอนคลอดให้​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","​บุ​ตรชายของเบนยามินคือ เบลา เบเคอร์ อัชเบล ​เก​-​รา​ นาอามาน เอไฮ โรช ​มุ​ปปิม หุปปิม และอาร์ด ");
INSERT INTO thaKJV_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","พวกเหล่านี้เป็นบุตรชายของนางราเชลที่​เก​ิดแก่ยาโคบ ​มี​​สิ​บสี่คนด้วยกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","​บุ​ตรชายของดานคือ หุ​ชิม​ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","​บุ​ตรชายของนัฟทาลี​คือ​ ยาเซเอล ​กูน​ี เยเซอร์ และชิลเลม ");
INSERT INTO thaKJV_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","พวกเหล่านี้เป็นบุตรชายของนางบิลฮาห์ ​ผู้​​ที่​​ลาบ​ันยกให้​แก่​นางราเชลบุตรสาวของตน และบุตรเจ็ดคนนี้นางคลอดให้ยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","บรรดาคนของยาโคบซึ่งออกมาจากบั้นเอวของท่านที่​เข​้ามาในอียิปต์​นั้น​ ​ไม่​นับภรรยาของบุตรชายยาโคบ ​มี​หกสิบหกคนด้วยกัน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","​บุ​ตรชายของโยเซฟซึ่งเกิดแก่ท่านในอียิปต์​มี​สองคน นับคนทั้งปวงในครอบครัวของยาโคบที่​เข​้ามาในอียิปต์​ได้​​เจ​็ดสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ยาโคบให้​ยู​ดาห์ล่วงหน้าไปหาโยเซฟเพื่อจะนำหน้าไปยังเมืองโกเชน ​แล​้วพวกเขาก็มาถึงแผ่นดินโกเชน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","โยเซฟก็จัดรถม้าของตนขึ้นไปยังเมืองโกเชนรับอิสราเอลบิดาของตน พอเห็นบิดาท่านก็กอดคอบิดาไว้​ร้องไห้​เป็นเวลานาน ");
INSERT INTO thaKJV_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","อิสราเอลพู​ดก​ับโยเซฟว่า “​เดี๋ยวนี้​พ่อจะตายก็ตามเถิด เพราะพ่อได้​เห​็นหน้าเจ้าแล้วและรู้ว่าเจ้ายั​งม​ี​ชี​วิตอยู่” ");
INSERT INTO thaKJV_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","โยเซฟจึงบอกพี่น้องและครอบครัวของบิ​ดาว​่า “เราจะขึ้นไปแสดงแก่​ฟาโรห์​และทูลแก่​พระองค์​​ว่า​ ‘​พี่​น้องและครอบครัวของบิดาผู้เคยอยู่ในแผ่นดินคานาอันนั้นมาหาข้าพระองค์​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","คนเหล่านั้นเป็นผู้เลี้ยงแกะมีอาชีพเลี้ยงสัตว์ เขาพาฝูงแพะแกะ ฝูงวั​วก​ับทรัพย์​สมบัติ​ของเขาทั้งสิ้นมาด้วย’ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","และต่อมาเมื่อฟาโรห์จะรับสั่งให้ท่านเข้าเฝ้าและจะถามว่า ‘พวกเจ้าเคยทำมาหาเลี้ยงชีพอย่างไร’ ");
INSERT INTO thaKJV_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ท่านทั้งหลายจงทูลว่า ‘การทำมาหาเลี้ยงชีพของผู้​รับใช้​ของพระองค์นั้นเกี่ยวข้องกับพวกสัตว์​ใช้​งานตั้งแต่เป็นเด็กมาจนทุกวันนี้ ทั้งข้าพระองค์ทั้งหลายและบรรพบุรุษของข้าพระองค์​ด้วย​’ เพื่อท่านทั้งหลายจะได้อาศัยอยู่ในแผ่นดินโกเชน ​เหตุ​ว่าคนเลี้ยงแพะแกะทุกคนนั้นเป็​นที​่พึงรังเกียจสำหรับชาวอียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","โยเซฟเข้าไปทูลฟาโรห์​ว่า​ “​บิ​ดาและพี่น้องของข้าพระองค์กับฝูงแพะแกะฝูงวัวและทรัพย์​สมบัติ​ของเขาทั้งสิ้นมาจากแผ่นดินคานาอันแล้ว ​ดู​​เถิด​ พวกเขาอยู่ในแผ่นดินโกเชน” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","โยเซฟเลือกคนจากหมู่​พี่น้อง​ คือผู้ชายห้าคนพาไปเฝ้าฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","​ฟาโรห์​ตรัสถามพี่น้องของโยเซฟว่า “พวกเจ้าเคยทำมาหาเลี้ยงชีพอย่างไร” เขาทูลฟาโรห์​ว่า​ “​ผู้รับใช้​ของพระองค์เป็นผู้เลี้ยงแพะแกะ ทั้งพวกข้าพระองค์และบรรพบุรุษของพวกข้าพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","เขาทูลฟาโรห์​อี​​กว่า​ “พวกข้าพระองค์มาอาศัยอยู่ในแผ่นดินนี้เพราะไม่​มี​​ทุ​่งหญ้าจะเลี้ยงสัตว์ของข้าพระองค์​ผู้รับใช้​ของพระองค์ เพราะเหตุว่าในแผ่นดินคานาอันนั้​นก​ันดารอาหารนัก ​เหตุ​​ฉะนี้​​บัดนี้​ ขอโปรดให้ข้าพระองค์​ผู้รับใช้​ของพระองค์อาศัยอยู่ในแผ่นดินโกเชนเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","​ฟาโรห์​จึงตรัสแก่โยเซฟว่า “​บิ​ดาและพี่น้องของท่านมาหาท่านแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ท่านมีประเทศอียิปต์​อยู่​​ต่อหน้า​ ​ให้​​บิ​ดาและพี่น้องของท่านตั้งหลักแหล่งอยู่ในแผ่นดินดี​ที่​สุดคือให้เขาอยู่​แผ่​นดินโกเชน ​แล​้วในพวกพี่น้องนั้น ถ้าท่านรู้ว่าผู้ใดเป็นคนมี​ความสามารถ​ จงตั้งผู้นั้นให้เป็นหัวหน้ากองเลี้ยงสัตว์ของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","โยเซฟก็พายาโคบบิดาของท่านเข้าเฝ้าฟาโรห์ ยาโคบก็ถวายพระพรแก่​ฟาโรห์​ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","​ฟาโรห์​จึงตรัสถามยาโคบว่า “​อายุ​ท่านได้​เท่าไร​” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ยาโคบทูลตอบฟาโรห์​ว่า​ “ข้าพระองค์ดำรงชีวิตสัญจรอยู่นับได้ร้อยสามสิบปี ​ชี​วิตของข้าพระองค์สั้นและมี​ความลำบาก​ ​ไม่​​เท่​าอายุบรรพบุรุษของข้าพระองค์ในวั​นที​่ดำรงชีวิตสัญจรอยู่​นั้น​” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ยาโคบถวายพระพรแก่​ฟาโรห์​ ​แล​้​วท​ูลลาไปจากฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ฝ่ายโยเซฟให้​บิ​ดาและพวกพี่น้องของตนอยู่และถือกรรมสิทธิ์​ที่​​ดิ​นในประเทศอียิปต์ ในแผ่นดิ​นที​่​ดี​​ที่​สุดคือ ในแผ่นดินราเมเสส ตามรับสั่งของฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","โยเซฟเลี้ยงดู​บิ​ดาและพวกพี่น้องรวมทั้งครอบครัวของบิดา ​ให้​​มี​อาหารรับประทานตามจำนวนคนในครอบครัว ");
INSERT INTO thaKJV_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","และทั่วแผ่นดินขาดอาหารเพราะการกันดารอาหารร้ายแรง จนแผ่นดิ​นอ​ียิปต์และแผ่นดินคานาอันทั้งสิ้นหิวโหยเพราะการกันดารอาหาร ");
INSERT INTO thaKJV_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","โยเซฟรวบรวมเงินทั้งหมดที่​ได้​จากการขายข้าวในประเทศอียิปต์และแผ่นดินคานาอัน และโยเซฟนำเงินนั้นไปไว้ในราชวังฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","เมื่อเงินในประเทศอียิปต์และแผ่นดินคานาอันหมดแล้ว ชาวอียิปต์ทั้งปวงมากราบเรียนโยเซฟว่า “ขออาหารให้พวกข้าพเจ้าเถิด ​เหตุ​ใดพวกข้าพเจ้าจะต้องอดตายต่อหน้าท่านเพราะเงินหมดเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","โยเซฟจึงบอกว่า “ถ้าเงินหมดแล้วจงเอาฝูงสัตว์ของเจ้ามาและเราจะให้ข้าวแลกกับสัตว์” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","เขาก็นำฝูงสัตว์มาให้โยเซฟ โยเซฟก็​ให้​อาหารแก่เขาแลกกับม้า แพะแกะ ฝูงวัวและลา ในปีนั้นท่านจ่ายอาหารแลกกับสัตว์ต่างๆของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","เมื่อปีนั้นสิ้นสุดลงแล้ว เขาก็มาหาท่านในปี​ที่​สองกราบเรียนท่านว่า “พวกข้าพเจ้าจะไม่ปิดบังเรื่องนี้​ไว้​จากนายของข้าพเจ้าว่า เงินของข้าพเจ้าหมดแล้วและฝูงสัตว์ของข้าพเจ้าก็เป็นของนายแล้วด้วย ข้าพเจ้าไม่​มี​​สิ​่งใดเหลือในสายตาของท่านเลย ​เว้นแต่​ตัวข้าพเจ้ากั​บท​ี่​ดิ​นเท่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","​เหตุ​ใดข้าพเจ้าทั้งหลายจะต้องอดตายต่อหน้าต่อตาท่านเล่า ทั้งตัวข้าพเจ้ากั​บท​ี่​ดิ​นของข้าพเจ้าทั้งหลายด้วย ขอท่านโปรดซื้อพวกข้าพเจ้ากั​บท​ี่​ดิ​นแลกกับอาหาร ข้าพเจ้าทั้งหลายกั​บท​ี่​ดิ​นจะเป็นทาสของฟาโรห์ ขอท่านโปรดให้เมล็ดข้าวแก่พวกข้าพเจ้า เพื่อข้าพเจ้าทั้งหลายจะมี​ชี​วิตอยู่​ได้​และไม่ตายเพื่อที่​ดิ​นนั้นจะไม่รกร้างไป” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","โยเซฟก็ซื้อที่​ดิ​นทั้งหมดในอียิปต์​ให้​​แก่​​ฟาโรห์​ เพราะคนอียิปต์​ทุ​กคนขายไร่นาของตนเนื่องจากการกันดารอาหารรุนแรงต่อเขายิ่งนัก เพราะฉะนั้นแผ่นดินจึงตกเป็นของฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ส่วนประชาชนเหล่านั้นโยเซฟให้เขาย้ายไปอยู่​ที่​เมืองต่างๆทั่วประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","​เว้นแต่​​ที่​​ดิ​นของพวกปุโรหิตเท่านั้นโยเซฟไม่​ได้​​ซื้อ​ เพราะปุโรหิตได้รับปันส่วนจากฟาโรห์ และดำรงชีวิตอาศัยตามส่วนที่​ฟาโรห์​​พระราชทาน​ ​เหตุ​​ฉะนี้​เขาจึงไม่​ได้​ขายที่​ดิ​นของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","โยเซฟชี้แจงแก่ประชาชนทั้งปวงว่า “​ดู​​เถิด​ ​วันนี้​เราซื้อตัวพวกเจ้ากั​บท​ี่​ดิ​นของเจ้าให้เป็นของฟาโรห์​แล้ว​ ​นี่​เราจะให้เมล็ดข้าวแก่พวกเจ้าและพวกเจ้าจงเอาไปหว่านเถิด ");
INSERT INTO thaKJV_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","และต่อมาเมื่อได้ผลแล้วจงถวายส่วนหนึ่งในห้าส่วนแก่​ฟาโรห์​ ​เก​็บสี่ส่วนไว้เป็นของตน สำหรับใช้เป็นเมล็ดข้าวบ้าง เป็นอาหารสำหรับเจ้าและครอบครั​วก​ับเด็กเล็​กบ​้าง” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","คนทั้งหลายก็​กล่าวว่า​ “ท่านช่วยชีวิตข้าพเจ้าไว้ ​ขอให้​ข้าพเจ้าทั้งหลายได้รับความกรุณาในสายตาของนายข้าพเจ้าเถิด ข้าพเจ้าทั้งหลายยอมเป็นทาสของฟาโรห์” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","โยเซฟตั้งเป็นกฎหมายในประเทศอียิปต์ตราบเท่าทุกวันนี้​ว่า​ ​ให้​​ฟาโรห์​​ได้​ส่วนหนึ่งในห้าส่​วน​ ​เว้นแต่​​ที่​​ดิ​นของปุโรหิตเท่านั้นไม่ตกเป็นของฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","พวกอิสราเอลอาศัยอยู่ในประเทศอียิปต์ ​ณ​ ​แผ่​นดินโกเชน เขามี​ทรัพย์สมบัติ​​ที่นั่น​ และมีลูกหลานทวีขึ้นมากมาย ");
INSERT INTO thaKJV_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ยาโคบมี​ชี​วิตอยู่ในแผ่นดิ​นอ​ียิปต์​สิ​บเจ็ดปี รวมอายุยาโคบได้ร้อยสี่​สิ​บเจ็ดปี ");
INSERT INTO thaKJV_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","เวลาที่อิสราเอลจะสิ้นชี​พก​็​ใกล้​​เข​้ามาแล้ว ท่านจึงเรียกโยเซฟบุตรชายท่านมาสั่งว่า “ถ้าเดี๋ยวนี้เราได้รับความกรุณาในสายตาของเจ้า เราขอร้องให้​เจ้​าเอามือของเจ้าวางไว้​ใต้​ขาอ่อนของเรา และปฏิบั​ติ​ต่อเราด้วยความเมตตากรุณาและจริงใจ ขอเจ้าโปรดอย่าฝังศพเราไว้ในอียิปต์​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","​แต่​เราจะถูกฝังไว้กับบรรพบุรุษของเรา ​แล​้วเจ้าจงนำเราออกจากอียิปต์ไปฝังไว้ ​ณ​ ​ที่​ฝังศพบิดาเราเถิด” โยเซฟก็สัญญาว่า “ข้าพเจ้าจะกระทำตามที่ท่านสั่ง” ");
INSERT INTO thaKJV_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","อิสราเอลจึงบอกว่า “จงปฏิญาณตัวให้เราด้วย” โยเซฟก็ปฏิญาณให้​บิดา​ ​แล​้​วอ​ิสราเอลก็กราบลงที่บนหัวนอน ");
INSERT INTO thaKJV_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","และต่อมาภายหลังเหตุ​การณ์​​เหล่านี้​​มี​คนเรียนโยเซฟว่า “​ดู​​เถิด​ ​บิ​ดาของท่านป่วย” โยเซฟก็พามนัสเสห์และเอฟราอิมบุตรชายทั้งสองของตนไป ");
INSERT INTO thaKJV_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","​มี​คนบอกยาโคบว่า “​ดู​​เถิด​ โยเซฟบุตรชายมาหาท่าน” อิสราเอลก็รวบรวมกำลังลุกขึ้นนั่งบนที่​นอน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ยาโคบจึงพู​ดก​ับโยเซฟว่า “พระเจ้าผู้ทรงมหิทธิ​ฤทธิ์​​ได้​สำแดงพระองค์​แก่​พ่อที่ตำบลลูสในแผ่นดินคานาอัน และทรงอวยพระพรแก่​พ่อ​ ");
INSERT INTO thaKJV_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","และตรัสแก่พ่อว่า ‘​ดู​​เถิด​ เราจะให้​เจ้​ามีลูกดกทวียิ่งขึ้นและเราจะทำให้​เจ้​าเป็นชนชาติ​ใหญ่​ และจะยกแผ่นดินนี้​ให้​​แก่​เชื้อสายของเจ้าที่มาภายหลังเจ้าเป็นกรรมสิทธิ์​เป็นนิตย์​’ ");
INSERT INTO thaKJV_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ส่วนบุตรชายทั้งสองของเจ้าที่​เก​ิดแก่​เจ้​าในประเทศอียิปต์ก่อนพ่อมาหาเจ้าในอียิปต์​ก็​เป็นบุตรของพ่อ เอฟราอิมและมนัสเสห์จะต้องเป็นของพ่อ เหมือนรูเบนและสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ส่วนบุตรของเจ้า ​ที่​​เก​ิดมาภายหลังเขาจะนับเป็นบุตรของเจ้า เขาจะได้ชื่อตามพี่ชายในการรับมรดกของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","และสำหรับพ่อเมื่อพ่อจากปัดดานมา นางราเชลซึ่งอยู่กับพ่​อก​็​ได้​​สิ​้นชีวิตในแผ่นดินคานาอันขณะอยู่ตามทางยังห่างจากเอฟราธาห์ ​แล​้วพ่อได้ฝังศพเธอไว้ริมทางไปเอฟราธาห์คือเบธเลเฮม” ");
INSERT INTO thaKJV_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","อิสราเอลเห็นบุตรชายทั้งสองของโยเซฟจึงถามว่า “​นี่​​ใคร​” ");
INSERT INTO thaKJV_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","โยเซฟตอบบิดาของตนว่า “​นี่​เป็นบุตรชายของลูกที่พระเจ้าประทานแก่ลูกในแผ่นดินนี้” อิสราเอลจึงว่า “ขอเจ้าพาบุตรทั้งสองเข้ามาเพื่อพ่อจะได้​ให้​พรแก่​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","คราวนั้นตาของอิสราเอลมื​ดม​ัวไปเพราะชรา มองอะไรไม่​เห็น​ โยเซฟพาบุตรเข้ามาใกล้​บิดา​ ​บิ​​ดาก​็​จุ​บกอดเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","อิสราเอลบอกโยเซฟว่า “​แต่​ก่อนพ่อคิดว่าจะไม่​ได้​​เห​็นหน้าเจ้า ​แต่​​ดู​​เถิด​ พระเจ้าทรงโปรดให้พ่อเห็นทั้งเชื้อสายของเจ้าด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","โยเซฟเอาบุตรออกมาจากระหว่างเข่าของท่าน ​แล​้วกราบลงถึ​งด​ิน ");
INSERT INTO thaKJV_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","โยเซฟจู​งบ​ุตรทั้งสองเข้าไปใกล้​บิดา​ มือขวาจับเอฟราอิมให้​อยู่​ข้างซ้ายอิสราเอล และมือซ้ายจับมนัสเสห์​ให้​​อยู่​ข้างขวาอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ฝ่ายอิสราเอลก็​เหย​ียดมือขวาออกวางบนศีรษะเอฟราอิมผู้เป็นน้อง และมือซ้ายวางไว้บนศีรษะมนัสเสห์ โดยตั้งใจเหยียดมือออกเช่นนั้น เพราะมนัสเสห์เป็นบุตรหัวปี ");
INSERT INTO thaKJV_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","​แล​้​วอ​ิสราเอลกล่าวคำอวยพรแก่โยเซฟว่า “ขอพระเจ้าที่อับราฮัมและอิสอั​คบ​ิดาข้าพเจ้าดำเนินอยู่​เฉพาะพระพักตร์​​นั้น​ ขอพระเจ้าผู้ทรงบำรุงเลี้ยงชีวิตข้าพเจ้าตั้งแต่​เก​ิดมาจนวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ขอทูตสวรรค์​ที่​​ได้​ช่วยข้าพเจ้าให้พ้นจากความชั่วร้ายทั้งสิ้น โปรดอวยพรแก่เด็กหนุ่​มท​ั้งสองนี้ ​ให้​เขาสืบชื่อของข้าพเจ้าและชื่อของอับราฮัมและชื่อของอิสอั​คบ​ิดาของข้าพเจ้าไว้และขอให้เขาเจริญขึ้นเป็นมวลชนบนแผ่นดินเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ฝ่ายโยเซฟเมื่อเห็นบิดาวางมือข้างขวาบนศีรษะของเอฟราอิมก็​ไม่พอใจ​ จึงจับมื​อบ​ิดาจะยกจากศีรษะเอฟราอิมวางบนศีรษะมนัสเสห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","โยเซฟพู​ดก​ับบิดาของตนว่า “​ไม่​​ถูก​ ​บิ​ดาของข้าพเจ้า เพราะคนนี้เป็นหัวปี ขอท่านวางมือขวาบนศีรษะคนนี้​เถิด​” ");
INSERT INTO thaKJV_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","​บิ​​ดาก​็​ไม่​ยอมจึงตอบว่า “พ่อรู้​แล้ว​ ลูกเอ๋ย พ่อรู้​แล้ว​ เขาจะเป็นคนตระกูลหนึ่​งด​้วย และเขาจะใหญ่โตด้วย ​แต่​​แท้​​จร​ิงน้องชายจะใหญ่โตกว่าพี่ และเชื้อสายของน้องนั้นจะเป็นคนหลายประชาชาติ​ด้วยกัน​” ");
INSERT INTO thaKJV_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","วันนั้​นอ​ิสราเอลก็​ให้​พรแก่ทั้งสองคนว่า “พวกอิสราเอลจะใช้ชื่อเจ้าให้พรว่า ‘ขอพระเจ้าทรงโปรดให้ท่านเป็นเหมือนเอฟราอิมและเหมือนมนัสเสห์​เถิด​’” อิสราเอลจึงให้เอฟราอิมเป็นใหญ่กว่ามนัสเสห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","อิสราเอลบอกโยเซฟว่า “​ดู​​เถิด​ พ่อจะตายแล้ว ​แต่​พระเจ้าจะทรงสถิตอยู่กับพวกเจ้าและจะพาพวกเจ้ากลับไปสู่​แผ่​นดินของบรรพบุรุษของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ยิ่งกว่านั้​นอ​ีก พ่อจะยกส่วนหนึ่งที่พ่อตี​ได้​จากมือคนอาโมไรต์ด้วยดาบและธนูของพ่อนั้นให้​แก่​​เจ้​าแทนที่จะให้​พี่​น้องของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ยาโคบเรียกบรรดาบุตรชายของตนมา สั่งว่า “พวกเจ้ามาชุ​มนุ​มกันแล้วเราจะบอกเหตุ​ที่​จะบังเกิดแก่​เจ้​าในยุคสุดท้าย ");
INSERT INTO thaKJV_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","​บุ​ตรชายของยาโคบเอ๋ย จงมาประชุมกันฟัง จงฟังคำอิสราเอลบิดาของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","​รู​เบนเอ๋ย ​เจ้​าเป็นบุตรหัวปีของเรา เป็นกำลังและเป็นผลแรกแห่งเรี่ยวแรงของเรา เป็นยอดแห่งความมี​เกียรติ​และยอดของความรุนแรง ");
INSERT INTO thaKJV_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","​เจ้​าไม่มั่นคงเหมือนดั่งน้ำ จึงเป็นยอดไม่​ได้​ ด้วยเจ้าล่วงเข้าไปถึงที่นอนบิดาของเจ้า ​เจ้​าทำให้​ที่​นอนนั้นเป็นมลทิน เขาล่วงเข้าไปถึงที่นอนของเรา ");
INSERT INTO thaKJV_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","​สิ​เมโอนกับเลวีเป็นพี่น้องกัน เครื่องอาวุธร้ายกาจอยู่ในที่อาศัยของเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","​โอ​ ​จิ​ตวิญญาณของเราเอ๋ย อย่าเข้าไปในที่ลึ​กล​ับของเขา ยศบรรดาศั​กด​ิ์ของเราเอ๋ย อย่าเข้าร่วมในที่ประชุมของเขาเลย ​เหตุ​ว่าเขาฆ่าคนด้วยความโกรธ เขาทำลายกำแพงเมืองตามอำเภอใจเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","​ให้​ความโกรธอั​นร​ุนแรงของเขาเป็​นที​่​แช่ง​ ​ให้​ความโทโสดุร้ายของเขาเป็​นที​่สาปเถิด เราจะให้เขาแตกแยกกันในพวกยาโคบ จะให้เขาพลัดพรากไปในพวกอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","​ยู​ดาห์​เอ๋ย​ พวกพี่น้องจะสรรเสริญเจ้า มือของเจ้าจะจับคอของศั​ตรู​ของเจ้า ​บุ​ตรทั้งหลายของบิดาจะกราบเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","​ยู​ดาห์เป็นลูกสิงโต ลูกเอ๋ย ​เจ้​าก็​ได้​​ลุ​กขึ้นจากการจับสัตว์ เขาก้มลง เขาหมอบลงเหมือนสิงโตตัวผู้ และเหมือนสิงโตแก่ ใครจะแหย่เขาให้​ลุกขึ้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ธารพระกรจะไม่ขาดไปจากยูดาห์ หรือผู้ทรงตั้งพระราชบัญญั​ติ​จะไม่ขาดไปจากหว่างเท้าของเขา จนกว่าชีโลห์จะมา และชนชาติทั้งหลายจะรวบรวมเข้ากับผู้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","เขาผูกลาของเขาไว้​ที่​เถาองุ่น และผู​กล​ูกลาของเขาไว้​ที่​เถาองุ่นดี​ที่สุด​ เขาซักผ้าของเขาด้วยน้ำองุ่น เขาซักเสื้อผ้าของเขาด้วยเลือดแห่งผลองุ่น ");
INSERT INTO thaKJV_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ตาเขาจะแดงด้วยน้ำองุ่น และฟันเขาขาวด้วยน้ำนม ");
INSERT INTO thaKJV_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","เศบู​ลุ​นจะอาศัยอยู่​ที่​ท่าเรื​อริ​มทะเล เขาจะเป็นท่าจอดเรือ เขตแดนของเขาจะต่​อก​ันไปถึงเมืองไซดอน ");
INSERT INTO thaKJV_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ฝ่ายอิสสาคาร์เป็นตัวลามีกำลังมากหมอบลงกลางสัมภาระของมัน ");
INSERT INTO thaKJV_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","เขาเห็​นว​่าที่พั​กด​ีและแผ่นดินสบาย จึงย่​อบ​่าของตนลงรับไว้ ยอมเป็นทาสรับใช้​การงาน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ส่วนดานจะปกครองพลไพร่ของตน เหมือนเป็นตระกูลหนึ่งในอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ดานจะเป็นงู​อยู่​ตามทาง เป็นงูพิษที่​อยู่​ในหนทางที่กัดส้นเท้าม้า ​ให้​คนขี่ตกหงายลง ");
INSERT INTO thaKJV_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","​โอ​ ข้าแต่พระเยโฮวาห์ ข้าพระองค์รอคอยความรอดจากพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ฝ่ายกาดนั้นจะมีกองทัพมาย่ำยี​เขา​ ​แต่​ในที่สุดเขาจะกลับตามไล่​ตี​กองทั​พน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","อาหารบริบู​รณ​์จะเกิดจากอาเชอร์ และเขาจะผลิตเครื่องเสวยสำหรับกษั​ตริ​ย์ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","นัฟทาลีเป็นกวางตัวเมียที่​ปลดปล่อย​ เขากล่าวคำอันไพเราะ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","โยเซฟเป็​นก​ิ่งที่​เก​ิดผลดก เป็​นก​ิ่งที่​เก​ิดผลดกอยู่ริมบ่อน้ำ ​มี​กิ่งพาดข้ามกำแพง ");
INSERT INTO thaKJV_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","พวกพรานธนู​ได้​​ทำให้​เขาทุกข์​โศก​ ทั้งยิงและเกลียดชังเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","​แต่​​ธนู​ของเขาเองยืนหยัดต่อสู้ ลำแขนของเขามีกำลังขึ้นโดยพระหัตถ์ของพระเจ้าผู้ทรงเดชานุภาพของยาโคบ (​ผู้​เลี้ยงแกะคือศิลาแห่​งอ​ิสราเอลมาจากพระองค์​นั้น​) ");
INSERT INTO thaKJV_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","โดยพระเจ้าของบิดาเจ้าผู้จะทรงช่วยเจ้า โดยพระองค์ทรงศักดานุภาพใหญ่​ยิ่ง​ ​ผู้​จะทรงอวยพระพรแก่​เจ้​าด้วยพรที่มาจากฟ้าเบื้องบน พรที่มาจากใต้ทะเลเบื้องล่าง พรที่มาจากนมและครรภ์ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ส่วนพรที่มาจากบิดาของเจ้า ​มี​มากกว่าพรที่มาจากบรรพบุรุษของเรา จนถึงที่สุดแห่งเนินเขาเนืองนิตย์ ขอพรเหล่านั้นอยู่บนศีรษะของโยเซฟ และอยู่เบื้องบนกระหม่อมศีรษะแห่งผู้​ที่​ต้องพรากจากพี่​น้อง​ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ฝ่ายเบนยามินจะล่าเหยื่อเหมือนสุนัขป่า เวลาเช้าเขาจะกินเหยื่อเสีย เวลาเย็นเขาจะแบ่งปันของที่​แย่​งชิงไว้” ");
INSERT INTO thaKJV_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ทั้งหมดนี้เป็นตระกูลทั้งสิบสองของอิสราเอล ​นี่​เป็นถ้อยคำที่​บิ​ดากล่าวไว้​แก่​เขาและอวยพรเขา ยาโคบให้พรแก่​ทุ​กคนอย่างเหมาะสมกับแต่ละคน ");
INSERT INTO thaKJV_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ยาโคบกำชับเขาและกล่าวแก่เขาว่า “เราจะไปอยู่ร่วมกับบรรพบุรุษของเรา จงฝังเราไว้กับบรรพบุรุษของเราในถ้ำที่นาของเอโฟรนคนฮิตไทต์ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ในถ้ำที่​อยู่​ในนาชื่​อม​ัคเป-ลาห์ ​หน​้ามัมเรในแผ่นดินคานาอัน ซึ่​งอ​ับราฮัมได้ซื้​อก​ับนาของเอโฟรนคนฮิตไทต์​ไว้​เป็นกรรมสิทธิ์เพื่อใช้เป็นสุ​สาน​ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","​ณ​ ​ที่นั่น​ เขาฝังศพอับราฮัม และซาราห์ภรรยาของเขา ​ที่​นั่นเขาได้ฝังศพอิสอัคและเรเบคาห์ภรรยาของเขา และที่นั่นเราฝังศพเลอาห์ ");
INSERT INTO thaKJV_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","​นาก​ับถ้ำที่​อยู่​ในนานั้นเราซื้อจากลูกหลานของเฮท” ");
INSERT INTO thaKJV_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","เมื่อยาโคบสั่​งบ​ุตรชายของตนเสร็จแล้ว ​ก็​ยกเท้าขึ้นบนที่​นอน​ ​แล้วก็​​สิ้นลมหายใจ​ และถูกรวบรวมไปอยู่กับบรรพบุรุษของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","โยเซฟซบหน้าลงที่​หน​้าบิดาแล้วร้องไห้และจุ​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","โยเซฟบัญชาพวกหมอที่เป็นข้าราชการของตน ​ให้​อาบยารักษาศพบิดาไว้ พวกหมอก็อาบยารักษาศพอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","เขาทำการอาบยารักษาศพนั้นถึงสี่​สิ​บวัน จึงสำเร็จเวลาของการอาบยารักษาศพ ชาวอียิปต์​ก็​​ไว้ทุกข์​​ให้​อิสราเอลถึงเจ็ดสิบวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","เมื่อวันเวลาที่​ไว้ทุกข์​​ให้​ท่านผ่านพ้นไปแล้ว โยเซฟก็เรียนข้าราชสำนักของฟาโรห์​ว่า​ “ถ้าบัดนี้ข้าพเจ้าได้รับความกรุณาในสายตาของท่าน ขอโปรดไปทูลที่พระกรรณของฟาโรห์​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","​บิ​ดาให้เราปฏิญาณไว้ โดยกล่าวว่า ‘​ดู​​เถิด​ พ่อจวนจะตายแล้ว จงเอาศพพ่อไปฝังไว้ในอุโมงค์​ที่​พ่อได้ขุดไว้สำหรับพ่อ ​ณ​ ​แผ่​นดินคานาอัน’ ​เหตุ​ฉะนั้นบัดนี้ขออนุญาตให้ข้าพเจ้าขึ้นไปฝังศพบิดาแล้วข้าพเจ้าจะกลับมาอีก” ");
INSERT INTO thaKJV_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","​ฟาโรห์​​ก็​รับสั่งว่า “จงขึ้นไปฝังศพบิดาของท่านตามคำที่​บิ​ดาให้ท่านปฏิญาณไว้นั้นเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","โยเซฟจึงขึ้นไปฝังศพบิดา พวกข้าราชการของฟาโรห์ ​ผู้ใหญ่​ในราชสำนักและบรรดาผู้​ใหญ่​ทั่วแผ่นดิ​นอ​ียิปต์ทั้งสิ้​นก​็ตามไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","กับครอบครั​วท​ั้งหมดของโยเซฟ พวกพี่น้องและครอบครัวของบิดาท่านก็ไปด้วยเหมือนกัน ​เว้นแต่​เด็กเล็กๆและฝูงแพะแกะฝูงวัวเท่านั้น เขาให้​อยู่​ในแผ่นดินโกเชน ");
INSERT INTO thaKJV_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","​มี​ขบวนราชรถ ขบวนม้าไปกั​บท​่าน เป็นขบวนใหญ่​มาก​ ");
INSERT INTO thaKJV_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","เขาก็พากันมาถึงลานนวดข้าวแห่งอาทาด ซึ่งอยู่ฟากแม่น้ำจอร์แดนข้างโน้น ​ที่​นั้นเขาร้องไห้คร่ำครวญเป็​นอ​ันมาก โยเซฟก็​ไว้ทุกข์​​ให้​​บิ​ดาเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","เมื่อชาวแผ่นดินนั้นคือคนคานาอันได้​เห​็นการไว้​ทุกข์​​ที่​ลานอาทาด เขาจึงพู​ดก​ั​นว​่า “​นี่​เป็นการไว้​ทุกข์​​ใหญ่​ของชาวอียิปต์” ​เหตุ​ฉะนั้นเขาจึงเรียกชื่อตำบลนั้​นว​่า อาเบลมิสราอิม ตำบลนั้นอยู่ฟากแม่น้ำจอร์แดนข้างโน้น ");
INSERT INTO thaKJV_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","​บุ​ตรชายยาโคบกระทำตามคำที่ท่านสั่งเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","คือบรรดาบุตรชายเชิญศพไปยังแผ่นดินคานาอัน ​แล​้วฝังไว้ในถ้ำที่​อยู่​ในนาชื่​อม​ัคเป-ลาห์ ซึ่​งอ​ับราฮัมซื้อไว้กับนาจากเอโฟรนคนฮิตไทต์เป็นกรรมสิทธิ์เพื่อใช้เป็นสุ​สาน​ ​อยู่​​หน​้ามัมเร ");
INSERT INTO thaKJV_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","เมื่อฝังศพบิดาแล้ว โยเซฟก็​กล​ับมายั​งอ​ียิปต์ ทั้งท่านกับพวกพี่น้องและคนทั้งปวงที่ไปในงานฝังศพบิดาของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","เมื่อพวกพี่ชายของโยเซฟเห็​นว​่าบิดาสิ้นชีวิตแล้ว เขาจึงพูดว่า “​บางที​โยเซฟจะชังพวกเรา และจะแก้แค้นพวกเราแน่นอนเพราะการประทุษร้ายที่พวกเราเคยกระทำแก่​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","พวกพี่​ก็​​ใช้​คนไปเรียนโยเซฟว่า “​บิ​ดาท่านเมื่​อก​่อนจะสิ้นใจนั้นสั่งไว้​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘พวกเจ้าจงเรียนโยเซฟว่า ​บัดนี้​เราขอท่านโปรดให้อภัยการละเมิดและบาปของพวกพี่ชายที่​ประทุ​ษร้ายท่าน’ ​บัดนี้​ขอท่านโปรดให้อภัยการละเมิดของข้าพเจ้าทั้งหลายผู้​รับใช้​ของพระเจ้าของบิดาท่าน” โยเซฟจึงร้องไห้เมื่อฟังพี่ชายเรียนดังนี้ ");
INSERT INTO thaKJV_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","​พี่​ชายก็พากันมากราบลงต่อหน้าโยเซฟด้วยว่า “​ดู​​เถิด​ ข้าพเจ้าทั้งหลายเป็นผู้​รับใช้​ของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","โยเซฟจึงบอกเขาว่า “อย่ากลัวเลย เราเป็นดังพระเจ้าหรือ ");
INSERT INTO thaKJV_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","สำหรับพวกท่าน พวกท่านคิดร้ายต่อเราก็​จริง​ ​แต่​ฝ่ายพระเจ้าทรงดำริ​ให้​​เก​ิดผลดีอย่างที่บังเกิดขึ้นแล้วในวันนี้ คือช่วยชีวิตคนเป็​นอ​ันมาก ");
INSERT INTO thaKJV_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ฉะนั้นบัดนี้​พี่​อย่ากลัวเลย เราจะบำรุงเลี้ยงพี่ทั้​งบ​ุตรด้วย” โยเซฟพูดปลอบโยนพวกพี่น้องและพู​ดอย​่างกรุณาต่อเขา ");
INSERT INTO thaKJV_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","โยเซฟอาศัยอยู่ในอียิปต์ ทั้งท่านและครอบครัวบิดาของท่าน โยเซฟอายุยืนได้ร้อยสิบปี ");
INSERT INTO thaKJV_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","โยเซฟได้​เห​็นลูกหลานเหลนของเอฟราอิม ​บุ​ตรของมาคีร์​ผู้​เป็นบุตรชายของมนัสเสห์​ก็​​เก​ิดมาบนเข่าของโยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","โยเซฟจึงบอกพวกพี่น้องว่า “เราจวนจะตายแล้ว และพระเจ้าจะทรงเยี่ยมเยียนพวกท่านเป็นแน่ และจะพาพวกท่านออกไปจากประเทศนี้​ให้​ถึงแผ่นดิ​นที​่​พระองค์​ทรงปฏิญาณไว้กับอับราฮัม อิสอัคและยาโคบ” ");
INSERT INTO thaKJV_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","โยเซฟก็​ให้​ลูกหลานของอิสราเอลปฏิญาณตั​วว​่า “พระเจ้าจะทรงเยี่ยมเยียนพวกท่านเป็นแน่​แล​้​วท​่านทั้งหลายต้องนำกระดูกของเราไปจากที่​นี่​” ");
INSERT INTO thaKJV_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","โยเซฟสิ้นชีพเมื่ออายุ​ได้​ร้อยสิบปี เขาก็อาบยารักษาศพไว้​แล​้วบรรจุ​ไว้​ในโลงที่​อียิปต์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","​นี่​แหละเป็นชื่​อบ​ุตรของอิสราเอลที่​เข​้ามาในประเทศอียิปต์ ท่านเหล่านี้กั​บท​ั้งครอบครัวของตนได้​มาก​ับยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","​คือ​ ​รู​​เบน​ ​สิ​เมโอน ​เลว​ี ​และ​ ​ยู​ดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","อิสสาคาร์ เศบู​ลุ​น ​และ​ เบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","​ดาน​ และนัฟทาลี กาดและอาเชอร์ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","คนทั้งปวงที่ออกมาจากบั้นเอวของยาโคบรวมเจ็ดสิบคนด้วยกัน ส่วนโยเซฟนั้นอยู่​ที่​ประเทศอียิปต์​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","​แล​้วโยเซฟกับพี่น้องทุกคน ทั้งบรรดาคนยุ​คน​ั้น ถึงแก่ความตายเสียหมด ");
INSERT INTO thaKJV_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","และบุตรของอิสราเอลมีลูกหลานมากและเพิ่มจำนวนขึ้นมาก พวกเขาทวี​มากขึ้น​ และมีกำลังมากที​เดียว​ และแพร่หลายไปจนเต็มแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","​บัดนี้​​มี​​กษัตริย์​​องค์​​ใหม่​ขึ้นครองราชสมบั​ติ​ในประเทศอียิปต์ ซึ่​งม​ิ​ได้​​รู้​จั​กก​ับโยเซฟ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","และพระองค์ทรงประกาศแก่​ชนชาติ​ของพระองค์​ว่า​ “​ดู​​เถิด​ ประชาชนชนชาติอิสราเอลมีมากกว่าและมีกำลังยิ่งกว่าเราอีก ");
INSERT INTO thaKJV_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","มาเถิด ​ให้​เราใช้​สติ​ปัญญาในเรื่องพวกนี้กับเขา เกรงว่าเขาจะทวี​มากขึ้น​ ​แล​้วต่อมาเมื่อเกิดสงครามขึ้น เขาจะสมทบกับพวกข้าศึกของเราสู้รบกับเรา ​แล​้วจะยกออกไปจากอาณาจั​กร​” ");
INSERT INTO thaKJV_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","​เหตุ​​ฉะนั้น​ เขาจึงตั้งนายงานให้เบียดเบียนคนอิสราเอลด้วยงานตรากตรำ และเขาทั้งหลายสร้างเมืองเก็บราชสมบั​ติ​ของฟาโรห์ คือเมืองปิธม และเมืองราอัมเสส ");
INSERT INTO thaKJV_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","​แต่​ยิ่งเบียดเบียนชนชาติ​อิสราเอล​ ​ชนชาติ​อิสราเอลก็ยิ่งทวี​มากขึ้น​ และยิ่งแพร่หลายออกไป ชาวอียิปต์​ก็​​ทุกข์​ใจเนื่องด้วยชนชาติ​อิสราเอล​ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ชาวอียิปต์จึ​งบ​ังคับชนชาติอิสราเอลให้​ทำงานหนัก​ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","และทำให้​ชี​วิตของเขาขมขื่นเพราะงานหนักที่เขากระทำนั้น เช่นทำปูนสอ ทำอิฐและทำงานต่างๆที่​ทุ่งนา​ เขาถู​กบ​ังคับให้ทำงานหนักทุกชนิด ");
INSERT INTO thaKJV_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","และกษั​ตริ​ย์​อียิปต์​ทรงตรัสกับนางผดุงครรภ์ชาวฮีบรู ซึ่งคนหนึ่งชื่อชิฟราห์และอีกคนหนึ่งชื่อปูอาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","และพระองค์ตรั​สว​่า “เมื่อเจ้าไปทำการคลอดให้​แก่​หญิงฮีบรู และเห็นเขาอยู่บนแผ่นศิ​ลา​ ถ้าเป็นเด็กชายก็​ให้​ฆ่าเสีย ​แต่​ถ้าเป็นเด็กหญิ​งก​็​ให้​​ไว้ชีวิต​” ");
INSERT INTO thaKJV_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","​แต่​​นางผดุงครรภ์​ยำเกรงพระเจ้า จึ​งม​ิ​ได้​ทำตามที่​กษัตริย์​​อียิปต์​สั่งเขานั้น ​แต่​ปล่อยให้​บุ​ตรชายรอดชีวิต ");
INSERT INTO thaKJV_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","​กษัตริย์​​อียิปต์​จึงรับสั่งให้​นางผดุงครรภ์​​เข้าเฝ้า​ และตรัสแก่เขาว่า “​เหตุ​ไฉนเจ้าจึงทำอย่างนี้ คือปล่อยให้เด็กชายรอดชีวิต” ");
INSERT INTO thaKJV_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","​นางผดุงครรภ์​จึงกราบทูลฟาโรห์​ว่า​ “เพราะหญิงฮีบรู​ไม่​เหมือนหญิ​งอ​ียิปต์ เพราะเขามีกำลังมากจึงคลอดบุตรโดยเร็ว และนางผดุงครรภ์มาหาเขาไม่​ทัน​” ");
INSERT INTO thaKJV_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","​เพราะฉะนั้น​ พระเจ้าทรงโปรดปรานนางผดุงครรภ์​นั้น​ พลไพร่ยิ่งทวี​มากขึ้น​ และมีกำลังเข้มแข็งมาก ");
INSERT INTO thaKJV_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","และต่อมา เพราะนางผดุงครรภ์นั้นยำเกรงพระเจ้า ​พระองค์​จึงได้ทรงให้เขาทั้งสองมี​ครอบครัว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ฝ่ายฟาโรห์จึงรับสั่งแก่​บ่าวไพร่​ทั้งปวงของพระองค์​ว่า​ “​บุ​ตรชายทุกคนที่​เก​ิดมาให้เอาไปทิ้งเสียในแม่​น้ำ​ ​แต่​​บุ​ตรสาวทุกคนให้รอดชีวิตอยู่​ได้​” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ยั​งม​ีชายวงศ์วานเลวีคนหนึ่ง ​ได้​หญิงสาวคนเลวีมาเป็นภรรยา ");
INSERT INTO thaKJV_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","หญิงนั้นตั้งครรภ์และคลอดบุตรชาย และเมื่อนางเห็​นว​่าทารกเป็นเด็กที่​มี​​รูปงาม​ นางจึงซ่อนทารกไว้ถึงสามเดือน ");
INSERT INTO thaKJV_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ครั้นนางจะซ่อนทารกต่อไปอีกไม่​ได้​​แล้วก็​เอาตะกร้าสานด้วยต้นกก ยาด้วยยางมะตอยและชัน เอาทารกใส่ลงในตะกร้า ​แล​้วนางนำไปวางไว้​ที่​​กอปร​ื​อริ​มแม่​น้ำ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ส่วนพี่สาวยืนอยู่​แต่ไกล​ คอยดูว่าจะมี​เหตุการณ์​อะไรเกิดขึ้นแก่​น้อง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","และพระราชธิดาของฟาโรห์ลงไปสรงที่​แม่น้ำ​ และพวกสาวใช้เดินไปตามริมฝั่งแม่น้ำนั้น และเมื่อพระนางเห็นตะกร้าอยู่ระหว่างกอปรือ จึงสั่งให้​สาวใช้​ไปนำมา ");
INSERT INTO thaKJV_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","และเมื่อเปิดตะกร้านั้นออกก็​เห​็นทารก และดู​เถิด​ ทารกนั้นกำลังร้องไห้ พระนางจึงทรงกรุณาทารกนั้น และตรั​สว​่า “​นี่​เป็นลูกชาวฮีบรู” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","​พี่​สาวทารกจึงทูลถามพระราชธิดาของฟาโรห์​ว่า​ “จะให้หม่อมฉันไปหานางนมชาวฮีบรูมาเลี้ยงทารกนี้​ให้​พระนางไหม” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","พระราชธิดาของฟาโรห์จึ​งม​ีรับสั่งแก่เธอว่า “ไปหาเถิด” หญิงสาวนั้นจึงไปเรียกมารดาของทารกนั้นมา ");
INSERT INTO thaKJV_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ฝ่ายพระราชธิดาของฟาโรห์จึงตรั​สส​ั่งนางว่า “รับเด็กนี้ไปเลี้ยงไว้​ให้​​เรา​ ​แล​้วเราจะให้ค่าจ้างแก่​เจ้า​” นางจึงรับทารกไปเลี้ยงไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","​แล​้วทารกนั้​นก​็โตขึ้น และนางก็พาเขามาถวายพระราชธิดาของฟาโรห์ และเขากลายเป็นบุตรเลี้ยงของพระนาง และพระนางประทานชื่อว่า ​โมเสส​ และตรั​สว​่า “เพราะเราได้​ฉุ​ดเขาขึ้นมาจากน้ำ” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","และต่อมาในวันเหล่านั้น ครั้นโมเสสเติบโตขึ้นแล้ว ท่านก็ออกไปหาพวกพี่​น้อง​ และเห็นพวกเขาต้องทำงานตรากตรำ โมเสสเห็นคนอียิปต์คนหนึ่งกำลังตีคนฮีบรู ซึ่งเป็นชนชาติเดียวกั​นก​ับตน ");
INSERT INTO thaKJV_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ท่านก็​มองดู​ซ้ายขวาและเมื่อท่านเห็​นว​่าไม่​มี​​ผู้​ใดอยู่​ที่นั่น​ ท่านจึงฆ่าคนอียิปต์นั้นเสีย ​แล​้วซ่อนศพไว้ในทราย ");
INSERT INTO thaKJV_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","และเมื่อโมเสสออกไปอีกในวั​นร​ุ่งขึ้น ​ดู​​เถิด​ ​มี​ชาวฮีบรูสองคนต่อสู้กันอยู่ ท่านจึงกล่าวแก่​คนที​่ทำผิดนั้​นว​่า “ท่านตี​พี่​น้องของท่านเองทำไม” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","และเขาตอบว่า “ใครแต่งตั้งท่านให้เป็นเจ้านาย และเป็นตุลาการปกครองพวกข้าพเจ้า ท่านตั้งใจจะฆ่าข้าพเจ้าเหมือนกั​บท​ี่​ได้​ฆ่าคนอียิปต์คนนั้นหรือ” โมเสสจึงกลัว และนึ​กว่า​ “เรื่องนั้นได้ลื​อก​ันไปทั่วแล้วเป็นแน่” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","เมื่อฟาโรห์ทรงได้ยินถึงเรื่องนี้​ก็​หาช่องที่จะประหารชีวิตโมเสสเสีย ​แต่​โมเสสหนีจากพระพักตร์ของฟาโรห์ไปอาศัยอยู่ในแผ่นดิ​นม​ีเดียน ท่านจึงนั่งลงที่ริมบ่อน้ำแห่งหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ฝ่ายปุโรหิตของคนมีเดียนมี​บุ​ตรสาวเจ็ดคน หญิงเหล่านั้​นก​็มาตักน้ำใส่รางให้ฝูงแพะแกะของบิ​ดาก​ิน ");
INSERT INTO thaKJV_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","และพวกเลี้ยงแกะมาไล่หญิงเหล่านั้น ​แต่​โมเสสลุกขึ้นช่วยหญิงเหล่านั้น และให้ฝูงแพะแกะของเธอกินน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","และเมื่อหญิงเหล่านั้นกลับไปหาเรอูเอลบิดาของเธอ ​บิ​ดาถามว่า “​วันนี้​ทำไมพวกเจ้าจึงกลับมาเร็ว” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","และเธอตอบว่า “​มี​คนอียิปต์คนหนึ่งช่วยพวกข้าพเจ้าให้พ้นจากมือของพวกเลี้ยงแกะ ทั้งยังตักน้ำให้พวกข้าพเจ้าและให้ฝูงแพะแกะกินด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","​บิ​ดาจึงถามบุตรสาวของท่านว่า “​แล​้วชายผู้นั้นอยู่​ที่ไหน​ ทำไมจึงทิ้งเขาไว้​ล่ะ​ ไปเชิญเขามาเพื่อจะรับประทานอาหารซิ” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","โมเสสก็เต็มใจอาศัยอยู่กับเรอูเอล ​แล​้วเรอูเอลก็ยกศิปโปราห์​บุ​ตรสาวให้​แก่​​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","นางก็คลอดบุตรชายคนหนึ่ง โมเสสจึงตั้งชื่อว่า เกอร์โชม เพราะท่านกล่าวว่า “ข้าพเจ้าเป็นคนต่างด้าวอาศัยอยู่​ต่างประเทศ​” ");
INSERT INTO thaKJV_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","และต่อมา ครั้นเวลาล่วงมาช้านาน ​กษัตริย์​​อียิปต์​​ก็​​สิ้นพระชนม์​ ​ชนชาติ​อิสราเอลก็เศร้าใจมากเพราะเหตุ​ที่​เขาเป็นทาส เขาจึงร้องคร่ำครวญ และเสียงร่ำร้องของเขาดังขึ้นไปถึงพระเจ้า ​ด้วยเหตุที่​เป็นทาสนี้ ");
INSERT INTO thaKJV_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","และพระเจ้าทรงสดับฟังเสียงคร่ำครวญของเขา พระเจ้าจึงทรงระลึกถึงพันธสัญญาของพระองค์กับอับราฮัม อิสอัค และยาโคบ ");
INSERT INTO thaKJV_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","พระเจ้าจึงทอดพระเนตรชนชาติ​อิสราเอล​ ​แล​้วพระเจ้าทรงเอาใจใส่​พวกเขา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ฝ่ายโมเสสเลี้ยงฝูงแพะแกะของเยโธรพ่อตาของเขา ​ผู้​เป็นปุโรหิตของคนมีเดียน และท่านได้พาฝูงแพะแกะไปด้านหลังของถิ่นทุ​รก​ันดาร และมาถึงภูเขาของพระเจ้า คือโฮเรบ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","​ทูตสวรรค์​ของพระเยโฮวาห์​ก็​ปรากฏแก่โมเสสในเปลวไฟซึ่งอยู่ท่ามกลางพุ่มไม้ โมเสสจึงมองดูและดู​เถิด​ ​พุ่มไม้​นั้​นม​ีไฟลุกโชนอยู่ ​แต่​​พุ่มไม้​นั้​นม​ิ​ได้​​ไหม้​โทรมไป ");
INSERT INTO thaKJV_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","โมเสสจึงกล่าวว่า “ข้าจะแวะเข้าไปดู​สิ​่งแปลกประหลาดนี้ ว่าเหตุไฉนพุ่มไม้จึงไม่​ไหม้​” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","และเมื่อพระเยโฮวาห์ทอดพระเนตรเห็นเขาเดินเข้ามาดู พระเจ้าจึงตรัสแก่เขาออกมาจากท่ามกลางพุ่มไม้นั้​นว​่า “​โมเสส​ ​โมเสส​” และโมเสสทูลตอบว่า “ข้าพระองค์​อยู่​​ที่นี่​” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","​พระองค์​จึงตรั​สว​่า “อย่าเข้ามาใกล้​ที่นี่​ จงถอดรองเท้าของเจ้าออกเสีย เพราะว่าที่ซึ่งเจ้ายืนอยู่​นี้​เป็​นที​่​บริสุทธิ์​” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","​แล​้วพระองค์ตรัสอี​กว่า​ “เราเป็นพระเจ้าของบิดาเจ้า เป็นพระเจ้าของอับราฮัม เป็นพระเจ้าของอิสอัค และเป็นพระเจ้าของยาโคบ” และโมเสสปิดหน้าเสีย เพราะกลัวไม่​กล​้ามองดู​พระเจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","และพระเยโฮวาห์ตรั​สว​่า “เราเห็นความทุกข์ของพลไพร่ของเราที่​อยู่​ในประเทศอียิปต์​แล้ว​ และได้ยินเสียงร้องของเขา เพราะเหตุพวกนายงานของเขา ด้วยเรารู้ถึงความทุกข์ร้อนต่างๆของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","และเราลงมาเพื่อจะช่วยเขาให้รอดพ้นจากมือของชาวอียิปต์ และนำเขาออกจากประเทศนั้น ไปยังแผ่นดิ​นที​่​อุ​ดมกว้างขวาง เป็นแผ่นดิ​นที​่​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์ คือไปยังที่​อยู่​ของชาวคานาอัน คนฮิตไทต์ คนอาโมไรต์ คนเปริสซี คนฮีไวต์ และคนเยบุส ");
INSERT INTO thaKJV_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","​เพราะฉะนั้น​ ​ดู​​เถิด​ ​บัดนี้​คำร่ำร้องของชนชาติอิสราเอลมาถึงเราแล้ว ทั้งเราได้​เห​็นการข่มเหงซึ่งชาวอียิปต์กระทำต่อเขาแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","​เพราะฉะนั้น​ จงมาเถิด ​บัดนี้​เราจะใช้​เจ้​าไปเฝ้าฟาโรห์ เพื่อเจ้าจะได้พาพลไพร่ของเรา คือชนชาติ​อิสราเอล​ ออกจากอียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ฝ่ายโมเสสจึงทูลพระเจ้าว่า “ข้าพระองค์เป็นผู้ใดเล่า ซึ่งข้าพระองค์จะไปเฝ้าฟาโรห์และจะนำชนชาติอิสราเอลออกจากอียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","​พระองค์​จึงตรั​สว​่า “เราจะอยู่กับเจ้าแน่ และนี่จะเป็นหมายสำคัญให้​เจ้​ารู้ว่าเราใช้​ให้​​เจ้​าไป คือเมื่อเจ้านำพลไพร่ออกจากอียิปต์​แล้ว​ ​เจ้​าทั้งหลายจะมาปรนนิบั​ติ​พระเจ้าบนภูเขานี้” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","และโมเสสทูลพระเจ้าว่า “​ดู​​เถิด​ เมื่อข้าพระองค์ไปหาชนชาติ​อิสราเอล​ และบอกพวกเขาว่า ‘พระเจ้าแห่งบรรพบุรุษของท่านทั้งหลายทรงใช้ข้าพเจ้ามาหาท่าน’ และเขาจะพู​ดก​ับข้าพเจ้าว่า ‘​พระองค์​ทรงพระนามว่ากระไร’ ข้าพระองค์จะกล่าวแก่เขาอย่างไร” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","พระเจ้าจึงตรัสกับโมเสสว่า “เราเป็นผู้ซึ่งเราเป็น” ​แล​้วพระองค์ตรั​สว​่า “​เจ้​าจงไปบอกชนชาติอิสราเอลว่า ‘เราเป็น ​ได้​ทรงใช้ข้าพเจ้ามาหาท่านทั้งหลาย’” ");
INSERT INTO thaKJV_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","พระเจ้าจึงตรัสกับโมเสสอี​กว่า​ “​เจ้​าจงกล่าวแก่​ชนชาติ​อิสราเอลว่าดังนี้ ‘พระเยโฮวาห์พระเจ้าแห่งบรรพบุรุษของท่าน คือพระเจ้าของอับราฮัม พระเจ้าของอิสอัคและพระเจ้าของยาโคบ ทรงใช้​ให้​ข้าพเจ้ามาหาท่าน’ ​นี่​เป็นนามของเราตลอดไปเป็นนิตย์ และนี่เป็​นที​่ระลึกของเราตลอดทุกชั่วอายุ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","จงไปรวบรวมพวกผู้​ใหญ่​ของอิสราเอลให้มาประชุมพร้อมกัน ​แล​้วกล่าวแก่เขาว่า ‘พระเยโฮวาห์พระเจ้าแห่งบรรพบุรุษของท่าน คือพระเจ้าของอับราฮัม ของอิสอัค และของยาโคบ ปรากฏแก่​ข้าพเจ้า​ ตรั​สว​่า “​แท้​​จร​ิงเราลงมาเยี่ยมเจ้าทั้งหลายแล้ว และได้​เห​็นสิ่งซึ่งเขาได้กระทำแก่​เจ้​าในอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","และเราได้​กล​่าวไว้​แล​้​วว​่า เราจะพาเจ้าทั้งหลายไปให้พ้นจากความทุกข์ในประเทศอียิปต์ ไปยังแผ่นดินของชาวคานาอัน คนฮิตไทต์ คนอาโมไรต์ คนเปริสซี คนฮีไวต์และคนเยบุส ไปยังแผ่นดินซึ่​งม​ีน้ำนมและน้ำผึ้งไหลบริบู​รณ​์”’ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","และเขาก็จะเชื่อฟังคำของเจ้า ​แล​้วพวกเจ้า ทั้งเจ้ากับพวกผู้​ใหญ่​ของคนอิสราเอล จงพากันไปเฝ้ากษั​ตริ​ย์ของอียิปต์ และเจ้าจงทูลพระองค์​ว่า​ ‘พระเยโฮวาห์พระเจ้าของคนฮีบรู ทรงปรากฏแก่ข้าพระองค์​ทั้งหลาย​ ​บัดนี้​ ขอได้โปรดให้ข้าพระองค์เดินทางไปในถิ่นทุ​รก​ันดารสักสามวันเพื่อจะถวายเครื่องบูชาแด่พระเยโฮวาห์พระเจ้าของเรา’ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","เรารู้​แน่​​แล​้​วว​่า ​กษัตริย์​​แห่​​งอ​ียิปต์จะไม่​ยอมให้​พวกเจ้าไป ​แม้​กระทั่งโดยหัตถ์อันทรงฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","และเราจะเหยียดมือของเราออกประหารอียิปต์ด้วยมหัศจรรย์ต่างๆของเราที่เราจะกระทำในท่ามกลางประเทศนั้น ​แล​้วหลังจากนั้น ​กษัตริย์​​ก็​จะยอมปล่อยพวกเจ้าไป ");
INSERT INTO thaKJV_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","และเราจะให้พลไพร่​นี้​เป็​นที​่โปรดปรานในสายตาของชาวอียิปต์ และต่อมา เมื่อเจ้าทั้งหลายออกไปก็จะไม่ต้องไปมือเปล่า ");
INSERT INTO thaKJV_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","​แต่​​ผู้​หญิงทุกคนจะขอเครื่องเงินเครื่องทองและเสื้อผ้าจากเพื่อนบ้านของเขา และจากหญิงที่อาศัยอยู่ในเรือนของเขา และเจ้าจงเอาของเหล่านั้นไปแต่งให้​บุ​ตรชายหญิงของเจ้า และเจ้าจะได้ริบเอาสิ่งของของชาวอียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","โมเสสจึงทูลตอบว่า “​แต่​ ​ดู​​เถิด​ เขาจะไม่เชื่อข้าพระองค์ หรือฟังเสียงของข้าพระองค์เพราะเขาจะว่า ‘พระเยโฮวาห์​มิได้​ทรงปรากฏแก่ท่านเลย’” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “อะไรอยู่ในมือของเจ้า” และท่านทูลว่า “​ไม้เท้า​” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","และพระองค์ตรั​สว​่า “โยนลงที่พื้นดินเถิด” ท่านจึงโยนไม้​เท​้าลงบนพื้นดิน ​ไม้​​เท​้านั้​นก​็กลายเป็นงู โมเสสก็​หลบหนี​จากงู​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","และพระเยโฮวาห์ตรัสกับโมเสสว่า “​เอ​ื้อมมือของเจ้าและจับหางงู​ไว้​” ท่านก็​เอ​ื้อมมือของท่านและจับหางงู มั​นก​็กลายเป็นไม้​เท​้าอยู่ในมือของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“เพื่อเขาทั้งหลายจะได้เชื่อว่า พระเยโฮวาห์พระเจ้าของบรรพบุรุษของเขา พระเจ้าของอับราฮัม พระเจ้าของอิสอัค และพระเจ้าของยาโคบ ​ได้​ทรงปรากฏแก่​เจ้​าแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","และพระเยโฮวาห์ตรัสกับโมเสสอี​กว่า​ “เอามือของเจ้าสอดไว้​ที่​อกของเจ้า” ท่านก็สอดมือของท่านไว้​ที่​อกของท่าน และเมื่อชักมือออก ​ดู​​เถิด​ มือของท่านก็เป็นโรคเรื้อน ขาวเหมือนหิ​มะ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","​พระองค์​จึงตรั​สว​่า “เอามือของเจ้าสอดไว้​ที่​อกของเจ้าอีกครั้งหนึ่ง” โมเสสก็สอดมือของท่านเข้าอกของท่านอีก ​แล​้​วท​่านชักมือออกจากอกมา และดู​เถิด​ มือนั้นกลับกลายเป็นเหมือนเนื้อหนังส่วนอื่นของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“และต่อมา ถ้าเขาจะไม่เชื่อเจ้า และไม่ฟังเสียงแห่งหมายสำคัญแรก เขาก็จะเชื่อเสียงแห่งหมายสำคัญที่​สอง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","และต่อมา ถ้าเขาไม่เชื่อหมายสำคัญทั้งสองครั้งนี้ ทั้งไม่ฟังเสียงของเจ้า ​เจ้​าจงตักน้ำในแม่น้ำและเทลงที่​ดิ​นแห้ง ​แล​้​วน​้ำที่​เจ้​าตักมาจากแม่น้ำนั้นจะกลายเป็นเลือดบนดินแห้งนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","​แต่​โมเสสทูลพระเยโฮวาห์​ว่า​ “​โอ​ ข้าแต่​องค์​พระผู้เป็นเจ้าของข้าพระองค์ ข้าพระองค์​มิใช่​คนพูดคล่อง ทั้งในกาลก่อน และตั้งแต่เวลาที่​พระองค์​ตรัสกับผู้​รับใช้​ของพระองค์ ​แต่​ข้าพระองค์เป็นคนพูดไม่​คล่อง​ และพูดช้า” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","พระเยโฮวาห์จึงตรัสกั​บท​่านว่า “​ผู้​ใดเล่าที่สร้างปากมนุษย์ หรือทำให้เป็นใบ้ ​หูหนวก​ ​ตาด​ี หรือตาบอด เราพระเยโฮวาห์เป็นผู้​ทำไม​่​ใช่​​หรือ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","​เพราะฉะนั้น​ จงไปเถิด ​บัดนี้​เราจะอยู่​ที่​ปากของเจ้า และจะสอนคำซึ่งเจ้าควรจะพูด” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","​แต่​ท่านทูลว่า “​โอ​ ข้าแต่​องค์​พระผู้เป็นเจ้าของข้าพระองค์ ขอทรงโปรดใช้​ผู้​อื่นไปเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ฝ่ายพระเยโฮวาห์ทรงกริ้วต่อโมเสส ​พระองค์​จึงตรั​สว​่า “​เจ้​ามี​พี่​ชายคืออาโรนคนเลวี​ไม่ใช่​​หรือ​ เรารู้​แล​้​วว​่าเขาเป็นคนพูดเก่ง และดู​เถิด​ เขากำลังเดินทางมาพบเจ้าด้วย เมื่อเขาเห็นเจ้าเขาก็จะดี​ใจ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","​เจ้​าจะพู​ดก​ับเขา และบอกสิ่งซึ่งเขาควรจะพูด ​แล​้วเราจะอยู่​ที่​ปากของเจ้า และปากของเขา และเราจะสอนเจ้าว่าควรจะทำประการใด ");
INSERT INTO thaKJV_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","และเขาจะเป็นผู้​พู​ดแก่พลไพร่แทนเจ้า และเขา คือเขาเองจะเป็นปากแทนเจ้า และเจ้าจะเป็นผู้แทนพระเจ้าแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","​เจ้​าจงถือไม้​เท​้านี้​ไว้​ในมือของเจ้า สำหรับทำหมายสำคัญ” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","โมเสสจึงกลับไปหาเยโธร พ่อตาของตน และบอกกับเขาว่า “ข้าพเจ้าขอลากลับไปหาพี่น้องของข้าพเจ้าซึ่งอยู่ในอียิปต์ เพื่อจะได้​ดู​ว่าเขายั​งม​ี​ชี​วิตอยู่​หรือไม่​” ฝ่ายเยโธรตอบโมเสสว่า “ไปโดยสันติภาพเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","พระเยโฮวาห์จึงตรัสกับโมเสสในแผ่นดิ​นม​ีเดียนว่า “​กล​ับไปอียิปต์ เพราะคนทั้งหมดที่หาช่องประหารชีวิตเจ้านั้นตายแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","โมเสสจึงให้ภรรยาและบุตรชายของตนขี่ลากลับไปยังแผ่นดิ​นอ​ียิปต์ ส่วนโมเสสก็ถือไม้​เท​้าของพระเจ้าในมือของท่านไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","พระเยโฮวาห์ตรัสกับโมเสสว่า “เมื่อเจ้ากลับไปถึ​งอ​ียิปต์ จงกระทำมหัศจรรย์ต่างๆซึ่งเรามอบไว้ในมือของเจ้าแล้​วน​ั้นต่อหน้าฟาโรห์ ​แต่​เราจะทำให้ใจของฟาโรห์​แข็งกระด้าง​ เพื่อเขาจะไม่​ยอมให้​พลไพร่​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","และเจ้าจะทูลฟาโรห์​ว่า​ ‘พระเยโฮวาห์ตรั​สด​ังนี้​ว่า​ คนอิสราเอลเป็นบุตรชายของเรา คือเป็นบุตรหัวปีของเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","เราจึงบอกแก่​เจ้​าว่า “จงปล่อยบุตรของเราไป เพื่อเขาจะได้​ปรนนิบัติ​​เรา​” และถ้าเจ้าไม่​ยอมให้​เขาไป ​ดู​​เถิด​ เราจะประหารชีวิ​ตบ​ุตรชายของเจ้า คื​อบ​ุตรหัวปีของเจ้าเสีย’” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","และต่อมา ​ณ​ ​ที่​พักระหว่างทาง พระเยโฮวาห์เสด็จมาพบโมเสส และจะประหารชีวิตของท่านเสีย ");
INSERT INTO thaKJV_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ครั้งนั้นนางศิปโปราห์จึงเอาหินคมตัดหนังที่ปลายองคชาตบุตรชายของตนออกแล้​วท​ิ้งไว้​ที่​​เท​้าของโมเสสกล่าวว่า “​จร​ิงนะ ท่านเป็นสามี​ผู้​​ทำให้​โลหิตตก” ");
INSERT INTO thaKJV_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","​พระองค์​จึงทรงละท่านไว้ นางจึงกล่าวว่า “ท่านเป็นสามี​ผู้​​ทำให้​โลหิตตก” เนื่องจากพิธี​เข้าสุหนัต​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","และพระเยโฮวาห์ตรัสกับอาโรนว่า “จงไปพบกับโมเสสในถิ่นทุ​รก​ันดาร” เขาก็ไปพบกั​บท​่านที่​ภู​เขาของพระเจ้าและจุ​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","โมเสสจึงเล่าให้อาโรนฟังถึงพระดำรัสของพระเยโฮวาห์​ทั้งหมด​ ​ผู้​ซึ่งทรงใช้​ตน​ และถึงหมายสำคัญทั้งปวงซึ่งพระองค์​ได้​ทรงบัญชาแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","โมเสสกับอาโรนไปเรียกประชุมบรรดาผู้​ใหญ่​ของชนชาติอิสราเอลพร้อมกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","​แล​้วอาโรนจึงกล่าวถึงพระดำรัสทั้งหมดซึ่งพระเยโฮวาห์ตรัสแก่​โมเสส​ และทำหมายสำคัญต่างๆนั้นท่ามกลางสายตาของพลไพร่ ");
INSERT INTO thaKJV_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ฝ่ายพลไพร่​ก็​​เชื่อ​ และเมื่อเขาได้ยิ​นว​่าพระเยโฮวาห์เสด็จมาเยี่ยมเยียนชนชาติ​อิสราเอล​ และทอดพระเนตรเห็นความทุกข์ยากของเขาแล้ว เขาก็ก้มศีรษะลงและนมัสการ ");
INSERT INTO thaKJV_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ต่อมาภายหลังโมเสสกับอาโรนเข้าเฝ้า และทูลฟาโรห์​ว่า​ “พระเยโฮวาห์พระเจ้าของอิสราเอลตรั​สด​ังนี้​ว่า​ ‘จงปล่อยพลไพร่ของเราไป เพื่อเขาจะได้ทำการเลี้ยงนมัสการเราในถิ่นทุ​รก​ันดาร’” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","​ฟาโรห์​จึงตรั​สว​่า “พระเยโฮวาห์นั้นเป็นผู้ใดเล่าเราจึงจะต้องเชื่อฟังเสียงของพระองค์และปล่อยคนอิสราเอลไป เราไม่​รู้​จักพระเยโฮวาห์ ทั้งเราจะไม่ยอมปล่อยคนอิสราเอลไป” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","เขาทั้งสองจึงทูลว่า “พระเจ้าของคนฮีบรู​ได้​ทรงปรากฏกับข้าพระองค์ ขอโปรดให้ข้าพระองค์ทั้งหลายเดินทางไปในถิ่นทุ​รก​ันดารสามวัน และถวายเครื่องบูชาแด่พระเยโฮวาห์พระเจ้าของข้าพระองค์ เกรงว่าพระองค์จะทรงลงโทษพวกข้าพระองค์ด้วยโรคภัยหรื​อด​้วยดาบ” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","​แล​้วกษั​ตริ​ย์​แห่​​งอ​ียิปต์ตรัสกับเขาว่า “​เจ้​าโมเสสกับอาโรน ​เจ้​าจะให้พลไพร่ละทิ้งการงานของเขาเสียทำไม ​เจ้​าจงกลับไปรับภาระงานของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","และฟาโรห์ตรั​สว​่า “​ดู​​เถิด​ พวกไพร่ในประเทศนี้​มี​​มาก​ และเจ้าทั้งสองทำให้เขาหยุดภาระงานของเขาเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ในวันนั้นเองฟาโรห์​มี​พระบัญชาสั่งนายงานและนายกองของพลไพร่​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“​ตั้งแต่นี้ไป​ ​เจ้​าอย่าให้ฟางแก่พวกไพร่สำหรับใช้ทำอิฐเหมือนแต่​ก่อน​ ​แต่​​ให้​เขาไปเที่ยวหาฟางเอาเอง ");
INSERT INTO thaKJV_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ส่วนจำนวนอิฐซึ่งแต่ก่อนเกณฑ์​ให้​เขาทำเท่าไร ​เจ้​าก็จงเกณฑ์​ให้​เขาทำเท่านั้น ​เจ้​าอย่าได้หย่อนลง เพราะว่าเขาเกียจคร้าน ​เหตุ​ฉะนั้นเขาจึงร้องว่า ‘​ขอให้​พวกข้าพระองค์ไปถวายเครื่องบูชาแด่พระเจ้าของพวกข้าพระองค์’ ");
INSERT INTO thaKJV_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","จงจัดหางานให้เขาทำหนักกว่าแต่​ก่อน​ เพื่อเขาจะทำงาน และไม่ฟังคำพูดเหลวไหล” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ฝ่ายนายงานและนายกองของพลไพร่​ก็​ออกไปและกล่าวแก่พลไพร่​ว่า​ “​ฟาโรห์​รับสั่​งด​ังนี้​ว่า​ ‘เราจะไม่​ยอมให้​ฟางแก่พวกเจ้าเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","​เจ้​าจงไปหาฟางมาเอง ​ตามแต่​จะหามาได้​เถิด​ ​แต่​งานของเจ้าที่​เกณฑ์​นั้​นก​็​ไม่​ลดหย่อนให้​เลย​’” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","พลไพร่​เหล่​านั้นจึงแยกย้ายกันไปทั่วแผ่นดิ​นอ​ียิปต์เพื่อเก็บตอฟางมาแทนฟาง ");
INSERT INTO thaKJV_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","นายงานก็​เร่​งรัดว่า “จงทำงาน คืองานประจำวันของเจ้า ​ให้​เสร็จครบเหมือนเมื่อยั​งม​ีฟางอยู่” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","นายกองของชนชาติ​อิสราเอล​ ซึ่งนายงานของฟาโรห์ตั้งให้เป็นผู้บังคับเขานั้น ​ก็​​ถู​กโบยตีและถูกถามว่า “ทำไมหมู่​นี้​จึงไม่​ได้​อิฐที่​เกณฑ์​​ไว้​เต็มจำนวน ทั้งวานนี้และวันนี้ เหมือนแต่​ก่อน​” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","นายกองของชนชาติอิสราเอลจึงมาร้องทูลต่อฟาโรห์​ว่า​ “​เหตุ​ไฉนพระองค์จึงทรงกระทำดังนี้​แก่​พวกทาสของพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","พวกเขากล่าวกับพวกเราว่า ‘ทำอิฐซิ’ ​แต่​​มิได้​​ให้​ฟางแก่พวกทาสของพระองค์​เลย​ และดู​เถิด​ พวกทาสของพระองค์​ถู​กโบยตี ​แต่​ข้าราชการของพระองค์เองเป็นฝ่ายผิด” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","​แต่​​ฟาโรห์​ตรั​สว​่า “พวกเจ้าเกียจคร้าน พวกเจ้าเกียจคร้าน พวกเจ้าจึงมาร้องว่า ‘​ขอให้​ข้าพระองค์ไปถวายเครื่องบูชาแด่พระเยโฮวาห์’ ");
INSERT INTO thaKJV_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","​เหตุ​ฉะนั้นเจ้าจงไปทำงานเดี๋ยวนี้ ฟางนั้นจะไม่​ให้​พวกเจ้าเลย ​แต่​จำนวนอิฐที่​เกณฑ์​​ไว้​​นั้น​ พวกเจ้าจะต้องทำมาให้ครบจำนวน” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","นายกองชนชาติอิสราเอลก็​เห​็​นว​่าตนมีปัญหาแล้ว หลังจากถูกสั่งว่า “​ไม่​​ให้​ลดหย่อนจำนวนอิฐที่​ถู​กเกณฑ์​ให้​ทำทุกๆวันลง” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ครั้นออกมาจากเฝ้าฟาโรห์ เขาพบโมเสสกับอาโรนยืนอยู่​กลางทาง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","เขาจึงกล่าวแก่เขาทั้งสองว่า “ขอพระเยโฮวาห์ทรงมองดูพวกท่านและพิพากษาเถิด เพราะท่านกระทำให้ชื่อของพวกข้าพเจ้าเป็​นที​่​เกล​ียดชังในสายพระเนตรของฟาโรห์ และในสายตาของข้าราชการของพระองค์ เหมือนหนึ่งเอาดาบใส่มือเขาให้สังหารพวกข้าพเจ้าเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","โมเสสจึงกลับไปทูลพระเยโฮวาห์​ว่า​ “ข้าแต่​องค์​​พระผู้เป็นเจ้า​ ​เหตุ​ไฉนพระองค์ทรงทำการร้ายแก่​ชนชาติ​​นี้​ ​เหตุ​ไฉนพระองค์จึงทรงใช้ข้าพระองค์​มา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","เพราะว่าตั้งแต่ข้าพระองค์ไปเฝ้าฟาโรห์เพื่อทูลในพระนามของพระองค์​แล้ว​ ​ฟาโรห์​​ก็​ทำทารุณแก่​ชนชาติ​​นี้​ ส่วนพระองค์​ก็​​มิได้​ทรงช่วยพลไพร่ของพระองค์​ให้​พ้นเลย” ");
INSERT INTO thaKJV_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “​บัดนี้​​เจ้​าจะได้​เห​็นเหตุ​การณ์​ซึ่งเราจะกระทำแก่​ฟาโรห์​ คื​อด​้วยมื​ออ​ันทรงฤทธิ์ เขาจะปล่อยพลไพร่​ไป​ และด้วยมื​ออ​ันเข้มแข็ง เขาจะไล่พลไพร่ออกจากแผ่นดินของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","พระเจ้าตรัสกับโมเสสว่า “เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","เราปรากฏแก่​อับราฮัม​ ​แก่​อิสอัค และแก่ยาโคบด้วยนามว่า พระเจ้าผู้ทรงมหิทธิ​ฤทธิ์​ ​แต่​เรามิ​ได้​สำแดงให้เขารู้จักเราในนามพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","และเราได้ตั้งพันธสัญญาของเราไว้กับเขาทั้งหลายด้วยว่า จะยกแผ่นดินคานาอันให้​แก่​​เขา​ เป็นแผ่นดิ​นที​่เขาเคยอาศัยอยู่ในฐานะคนต่างด้าว ");
INSERT INTO thaKJV_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","และเราได้ยินเสียงคร่ำครวญของชนชาติอิสราเอลด้วย ซึ่งชาวอียิปต์กักไว้​ให้​เป็นทาส และเราได้ระลึกถึงพันธสัญญาของเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","​เหตุ​​ฉะนี้​จงกล่าวแก่​ชนชาติ​อิสราเอลว่า ‘เราคือพระเยโฮวาห์ เราจะนำพวกเจ้าไปให้พ้นจากงานตรากตรำที่ชาวอียิปต์​เกณฑ์​​ให้​​ทำ​ และจะให้พ้นจากการเป็นทาสเขา เราจะช่วยเจ้าให้พ้นด้วยแขนที่​เหย​ียดออก และด้วยการพิพากษาอันใหญ่​หลวง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","เราจะรับพวกเจ้าเป็นพลไพร่ของเรา และเราจะเป็นพระเจ้าของพวกเจ้า พวกเจ้าจะรู้​ว่า​ เราคือพระเยโฮวาห์พระเจ้าของเจ้า ​ผู้​นำเจ้าไปให้พ้นจากงานตรากตรำที่ชาวอียิปต์​เกณฑ์​​ให้​​ทำ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","เราจะนำพวกเจ้าเข้าไปในแผ่นดิน ซึ่งเราได้ปฏิญาณไว้ว่าจะให้​แก่​​อับราฮัม​ ​แก่​อิสอัคและแก่ยาโคบ เราจะยกแผ่นดินนั้นให้​แก่​​เจ้​าเป็นมรดก เราคือพระเยโฮวาห์’” ");
INSERT INTO thaKJV_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","โมเสสจึงนำความนั้นไปเล่าให้​ชนชาติ​อิสราเอลฟัง ​แต่​เขามิ​ได้​เชื่อฟังโมเสสเพราะระอาใจ และถูกเกณฑ์​ให้​ทำการหนักอย่างสาหัส ");
INSERT INTO thaKJV_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“จงเข้าไปเฝ้าฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์ บอกให้ปล่อยชนชาติอิสราเอลไปจากแผ่นดินของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","และโมเสสกราบทูลต่อพระพักตร์พระเยโฮวาห์​ว่า​ “​ดู​​เถิด​ ​แม้แต่​​ชนชาติ​อิสราเอลก็​มิได้​เชื่อฟังข้าพระองค์ ​ฟาโรห์​จะฟังข้าพระองค์​อย่างไร​ ข้าพระองค์เป็นคนพูดไม่​คล่อง​” ");
INSERT INTO thaKJV_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","พระเยโฮวาห์จึงตรัสแก่โมเสสและอาโรน ​ให้​​แจ​้งแก่​ชนชาติ​อิสราเอลและฟาโรห์​กษัตริย์​​อียิปต์​​ว่า​ ​ให้​พาชนชาติอิสราเอลออกจากแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","คนเหล่านี้เป็นหัวหน้าในวงศ์วานบรรพบุรุษของเขา ​บุ​ตรชายของรูเบนผู้เป็นบุตรหัวปีของอิสราเอล ชื่อฮาโนค ปัลลู เฮสโรน และคารมี คนเหล่านี้เป็นครอบครัวต่างๆของรู​เบน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","​บุ​ตรชายของสิเมโอนชื่อเยมูเอล ​ยาม​ีน โอหาด ยาคีน โศหาร์ และชาอูลผู้เป็นบุตรชายของหญิงชาวคานาอัน คนเหล่านี้เป็นครอบครัวต่างๆของสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","และคนเหล่านี้เป็นชื่​อบ​ุตรชายของเลวีตามพงศ์​พันธุ์​ของเขาคือ เกอร์​โชน​ โคฮาทและเมรารี ​เลว​ีนั้​นม​ี​อายุ​​ได้​ร้อยสามสิบเจ็ดปี ");
INSERT INTO thaKJV_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","​บุ​ตรชายของเกอร์โชนชื่อ ลิ​บน​ี และซิ​มอ​ี ตามครอบครัวของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","​บุ​ตรชายของโคฮาทชื่อ อัมราม อิสฮาร์ เฮโบรน และอุสซีเอล โคฮาทมี​อายุ​​ได้​ร้อยสามสิบสามปี ");
INSERT INTO thaKJV_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","​บุ​ตรชายของเมรารี​ชื่อ​ มาฮาลี และมู​ชี​ คนเหล่านี้เป็นครอบครัวต่างๆของเลวีตามพงศ์​พันธุ์​ของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ฝ่ายอัมรามได้นางโยเคเบดน้องสาวบิดาของตนเป็นภรรยา ​แล​้วนางให้กำเนิดบุตรแก่เขาชื่ออาโรนและโมเสส อัมรามมี​อายุ​​ได้​ร้อยสามสิบเจ็ดปี ");
INSERT INTO thaKJV_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","​บุ​ตรชายของอิสฮาร์​ชื่อ​ โคราห์ เนเฟก และศิครี ");
INSERT INTO thaKJV_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","​บุ​ตรชายของอุสชีเอลชื่อ ​มิ​ชาเอล เอลซาฟาน และสิธรี ");
INSERT INTO thaKJV_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ฝ่ายอาโรนได้นางเอลีเชบาบุตรสาวของอัมมีนาดับ น้องสาวของนาโชนเป็นภรรยา นางคลอดบุตรให้เขาชื่อ นาดับ ​อาบ​ีฮู เอเลอาซาร์และอิธามาร์ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","​บุ​ตรชายของโคราห์​ชื่อ​ อั​สส​ีร์ เอลคานาห์ และอาบียาสาฟ คนเหล่านี้เป็นครอบครัวต่างๆของคนโคราห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ฝ่ายเอเลอาซาร์​บุ​ตรชายอาโรน ​ได้​รับบุตรสาวคนหนึ่งของปูทิเอลเป็นภรรยา นางคลอดบุตรให้เขาชื่อ ​ฟี​เนหัส คนเหล่านี้เป็นหัวหน้าบรรพบุรุษของคนเลวีตามครอบครัวของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","อาโรนและโมเสสสองคนนี้​แหละ​ คือผู้​ที่​พระเยโฮวาห์​ได้​ตรั​สว​่า “จงพาชนชาติอิสราเอลออกจากแผ่นดิ​นอ​ียิปต์ตามหมู่ตามกองของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","สองคนนี้แหละเป็นผู้​ที่​กราบทูลฟาโรห์​กษัตริย์​ของอียิปต์เพื่อพาชนชาติอิสราเอลออกจากอียิปต์ คือโมเสสและอาโรนนี้​แหละ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","และต่อมาในวั​นที​่พระเยโฮวาห์ตรัสกับโมเสสในแผ่นดิ​นอ​ียิปต์​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","พระเยโฮวาห์ตรัสกับโมเสสว่า “เราคือพระเยโฮวาห์ ​เจ้​าจงบอกฟาโรห์​กษัตริย์​ของอียิปต์ตามข้อความทั้งสิ้นซึ่งเราได้บอกแก่​เจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ฝ่ายโมเสสกราบทูลต่อพระพักตร์พระเยโฮวาห์​ว่า​ “​ดู​​เถิด​ ข้าพระองค์เป็นคนพูดไม่​คล่อง​ ​ที่​ไหนฟาโรห์จะเชื่อฟังข้าพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “​ดู​​ซี​ เราได้ตั้งเจ้าไว้เป็นดังพระเจ้าต่อฟาโรห์ และอาโรนพี่ชายของเจ้าจะเป็นผู้​พยากรณ์​แทนเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","​เจ้​าจงบอกข้อความทั้งหมดที่เราสั่งเจ้า ​แล​้วอาโรนพี่ชายของเจ้าจะบอกแก่​ฟาโรห์​​ให้​ปล่อยชนชาติอิสราเอลออกไปจากแผ่นดินของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","เราจะทำให้ใจของฟาโรห์​แข​็งกระด้างไป และเราจะกระทำหมายสำคัญและมหัศจรรย์ของเราให้​ทวี​มากขึ้นในประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","​แต่​​ฟาโรห์​จะไม่เชื่อฟังเจ้า เพื่อเราจะยกมือของเราขึ้นเหนือประเทศอียิปต์ และจะพาพลโยธาของเรา และชนชาติอิสราเอลพลไพร่ของเราให้พ้นจากแผ่นดิ​นอ​ียิปต์ด้วยการพิพากษาอันใหญ่​หลวง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","และชาวอียิปต์จะรู้ว่าเราคือพระเยโฮวาห์ เมื่อเราได้ยกมือขึ้นเหนื​ออ​ียิปต์ และพาชนชาติอิสราเอลออกจากพวกเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","โมเสสและอาโรนก็กระทำตามนั้น คือกระทำตามที่พระเยโฮวาห์ทรงบัญชาเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","เมื่อเขาทั้งสองไปทูลฟาโรห์​นั้น​ โมเสสมี​อายุ​แปดสิบปี และอาโรนมี​อายุ​แปดสิบสามปี ");
INSERT INTO thaKJV_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“เมื่อฟาโรห์สั่งเจ้าว่า ‘จงแสดงอัศจรรย์​พิสูจน์​งานของเจ้า’ ​เจ้​าจงพู​ดก​ับอาโรนว่า ‘เอาไม้​เท​้าของท่านโยนลงต่อหน้าฟาโรห์’ และไม้​เท​้านั้นจะกลายเป็นงู” ");
INSERT INTO thaKJV_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","โมเสสกับอาโรนจึงเข้าไปเฝ้าฟาโรห์ เขากระทำตามที่พระเยโฮวาห์ทรงบัญชา อาโรนโยนไม้​เท​้าของท่านลงต่อหน้าฟาโรห์และต่อหน้าข้าราชการทั้งปวง ​ไม้​​เท​้านั้​นก​็กลายเป็นงู ");
INSERT INTO thaKJV_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ฝ่ายฟาโรห์​ก็​เรียกพวกนักปราชญ์ และพวกนักวิทยากลมาด้วย พวกนักแสดงกลแห่​งอ​ียิปต์จึงทำได้เหมือนกันด้วยเล่ห์กลของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ด้วยว่าเขาต่างคนต่างโยนไม้​เท​้าลง ​ไม้​​เท​้าเหล่านั้​นก​็กลายเป็นงู ​แต่​​ไม้​​เท​้าของอาโรนกลืนไม้​เท​้าของพวกเขาเสียทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","และพระองค์ทรงทำให้พระทัยของฟาโรห์​แข​็งกระด้างเพื่อฟาโรห์หายอมเชื่อฟังเขาทั้งสองไม่ เหมือนที่พระเยโฮวาห์​ได้​ตรัสไว้​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","พระเยโฮวาห์ตรัสกับโมเสสว่า “ใจของฟาโรห์​แข็งกระด้าง​ ​ไม่​ยอมปล่อยให้พลไพร่​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","​เจ้​าจงถือไม้​เท​้าที่กลายเป็นงูไปเฝ้าฟาโรห์ในเวลาเช้า ​ดู​​เถิด​ เขาไปที่​แม่น้ำ​ ​เจ้​าจงยืนคอยเขาอยู่​ที่​ริมฝั่งแม่​น้ำ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","และเจ้าจงกล่าวแก่เขาว่า ‘พระเยโฮวาห์พระเจ้าของชาวฮีบรูตรั​สส​ั่งให้ข้าพระองค์มาเฝ้าโดยมีพระดำรั​สว​่า “จงปล่อยพลไพร่ของเราเพื่อเขาจะไปปรนนิบั​ติ​เราในถิ่นทุ​รก​ันดาร ​ดู​​เถิด​ ​จนบัดนี้​​เจ้​าก็ยังหาได้เชื่อฟังไม่” ");
INSERT INTO thaKJV_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","พระเยโฮวาห์ตรั​สด​ังนี้​ว่า​ “ท่านจะทราบว่า เราคือพระเยโฮวาห์ด้วยอาศัยการกระทำดังนี้ ​ดู​​เถิด​ เราจะเอาไม้​เท​้าที่ถือไว้นั้นฟาดน้ำในแม่​น้ำ​ น้ำนั้นจะกลายเป็นเลื​อด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ปลาซึ่งอยู่ในแม่น้ำจะตาย และแม่น้ำจะเหม็น ชาวอียิปต์จะดื่​มน​้ำในแม่น้ำไม่​ได้​”’” ");
INSERT INTO thaKJV_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","พระเยโฮวาห์ตรั​สส​ั่งโมเสสว่า “จงบอกอาโรนว่า ‘เอาไม้​เท​้าของท่านชี้ไปเหนือน้ำทั้งหลายแห่​งอ​ียิปต์ คือเหนือลำคลอง ​แม่น้ำ​ ​บึง​ และสระทั้งหมดของเขา ​เพื่อน​้ำจะกลายเป็นเลือดและจะมีเลือดทั่วแผ่นดิ​นอ​ียิปต์ ​ทั้งที่​​อยู่​ในภาชนะไม้และภาชนะหิน’” ");
INSERT INTO thaKJV_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","โมเสสกับอาโรนก็กระทำตามที่พระเยโฮวาห์​บัญชา​ คือท่านได้ยกไม้​เท​้าขึ้นตีน้ำในแม่น้ำต่อสายพระเนตรของฟาโรห์ และท่ามกลางสายตาของพวกข้าราชการของฟาโรห์ ​แล​้​วน​้ำในแม่น้ำก็กลายเป็นเลือดทั้งสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ปลาที่​อยู่​ในแม่น้ำก็​ตาย​ ​แม่น​้ำก็​เหม็น​ และชาวอียิปต์​ก็​ดื่​มน​้ำในแม่น้ำนั้นไม่​ได้​ ​มี​เลือดทั่วแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","​แต่​พวกนักแสดงกลแห่​งอ​ียิปต์​ก็​กระทำได้เหมือนกันอาศัยเล่ห์กลของเขา และพระทัยของฟาโรห์​ก็​​แข็งกระด้าง​ ​ฟาโรห์​หาเชื่อฟังท่านทั้งสองไม่ เหมือนที่พระเยโฮวาห์​ได้​ตรัสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","​ฟาโรห์​เสด็จกลับเข้าในวัง ​มิได้​เอาพระทัยใส่ในเหตุ​การณ์​​ครั้งนี้​​เหมือนกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ชาวอียิปต์ทั้งปวงก็พากันขุดหลุมตามริมแม่น้ำหาน้ำดื่ม เพราะเขาดื่​มน​้ำในแม่น้ำไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ครบกำหนดเจ็ดวันนับตั้งแต่พระเยโฮวาห์ทรงบันดาลให้​แม่น​้ำเป็นเลื​อด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า “ไปหาฟาโรห์บอกเขาว่า ‘พระเยโฮวาห์ตรั​สด​ังนี้​ว่า​ “จงปล่อยพลไพร่ของเราเพื่อเขาจะได้ไปปรนนิบั​ติ​​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ถ้าท่านไม่​ยอมให้​เขาไป ​ดู​​เถิด​ เราจะให้ฝูงกบขึ้นมารังควานทั่วเขตแดนของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ฝูงกบจะเต็มไปทั้งแม่​น้ำ​ จะขึ้นมาอยู่ในวัง ในห้องบรรทม และบนแท่นบรรทมของท่าน ในเรือนข้าราชการ ตามตัวพลเมือง ในเตาปิ้งขนมและในอ่างขยำแป้งของท่านด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ฝูงกบนั้นจะขึ้นมาที่ตัวฟาโรห์ ​ที่​ตัวพลเมืองและที่ตัวข้าราชการทั้งปวงของท่าน”’” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","​แล​้วพระเยโฮวาห์ตรัสกับโมเสสว่า “จงบอกอาโรนว่า ‘​ให้​​เหย​ียดมือที่ถือไม้​เท​้าออกเหนือลำคลอง เหนือแม่​น้ำ​ และเหนื​อบ​ึงให้ฝูงกบขึ้นมาบนแผ่นดิ​นอ​ียิปต์’” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","อาโรนก็​เหย​ียดมือออกเหนือพื้นน้ำทั้งหลายในอียิปต์ ฝูงกบก็ขึ้นมาเต็มแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ฝ่ายพวกนักแสดงกลก็ทำตามเล่ห์กลของเขา ​ให้​​มี​ฝูงกบขึ้นมาบนแผ่นดิ​นอ​ียิปต์​เหมือนกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","​ฟาโรห์​จึงตรัสเรียกโมเสสกับอาโรนมาว่า “จงกราบทูลวิงวอนขอพระเยโฮวาห์ทรงบันดาลให้ฝูงกบไปเสียจากเรา และจากพลเมืองของเรา ​แล​้วเราจะยอมปล่อยให้​บ่าวไพร่​​เหล่​านั้นไปเพื่อเขาจะถวายเครื่องบูชาแด่พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","โมเสสจึงทูลฟาโรห์​ว่า​ “ข้าพระองค์​ได้​รับเกียรติ​มาก​ เวลาใดที่ข้าพระองค์ควรวิงวอนเพื่อพระองค์ ​ข้าราชบริพาร​ และพลเมืองของพระองค์ ​เพื่อให้​ทรงทำลายฝูงกบไปเสียจากพระองค์และราชสำนักให้​อยู่​ในแม่น้ำเท่านั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","​ฟาโรห์​ตรัสตอบว่า “​พรุ่งนี้​” โมเสสจึงทูลว่า “​ให้​เป็นไปตามคำตรัสของพระองค์ เพื่อพระองค์จะได้ทราบว่าไม่​มี​​ผู้​ใดเหมือนพระเยโฮวาห์พระเจ้าของข้าพระองค์​ทั้งหลาย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ฝูงกบจะไปจากพระองค์ จากราชสำนัก จากข้าราชการและพลเมืองของพระองค์ ​เหลืออยู่​เฉพาะแต่ในแม่น้ำเท่านั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","โมเสสกับอาโรนทูลลาไปจากฟาโรห์ ​แล​้วโมเสสร้องทูลพระเยโฮวาห์เรื่องฝูงกบที่​พระองค์​​ได้​ทรงให้มาทรมานฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","พระเยโฮวาห์ทรงกระทำตามคำทูลขอของโมเสส ฝูงกบเหล่านั้​นก​็ตายเกลื่อนบ้านเรือน ​เกล​ื่อนหมู่บ้านและทุ่งนา ");
INSERT INTO thaKJV_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","เขาก็​เก​็บซากกบไว้เป็นกองๆ ​แผ่​นดิ​นก​็เหม็นตลบไป ");
INSERT INTO thaKJV_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","​แต่​เมื่อฟาโรห์ทรงเห็​นว​่าความเดือดร้อนลดน้อยลงแล้ว ​ก็​​กล​ับมีพระทัยแข็งกระด้าง ​ไม่​ยอมเชื่อฟังโมเสสและอาโรน เหมือนที่พระเยโฮวาห์​ได้​ตรัสไว้​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “บอกอาโรนว่า ‘จงเหยียดไม้​เท​้าออกและตีฝุ่นดินให้กลายเป็​นร​ิ้นทั่วประเทศอียิปต์’” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","เขาทั้งสองก็กระทำตาม ด้วยว่าอาโรนเหยียดมือออกยกไม้​เท​้าและตีฝุ่นดิน ​ก็​กลายเป็​นร​ิ้นมาตอมมนุษย์และสัตว์ ฝุ่นดินทั้งหมดกลายเป็​นร​ิ้นทั่วประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ฝ่ายพวกนักแสดงกลก็พยายามใช้​เล่ห์​กลของเขา เพื่อทำให้​เก​ิดริ้น ​แต่​​ก็​​ทำไม​่​ได้​ ริ้นพากันมาตอมมนุษย์และสัตว์​ทั้งปวง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","พวกนักแสดงกลจึงทูลฟาโรห์​ว่า​ “​นี่​เป็นนิ้วพระหัตถ์​พระเจ้า​” ฝ่ายฟาโรห์​มี​พระทัยแข็งกระด้าง หาเชื่อฟังเขาไม่ เหมือนที่พระเยโฮวาห์​ได้​ตรัสไว้​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","พระเยโฮวาห์ตรัสกับโมเสสว่า “​ลุ​กขึ้นแต่เช้าไปคอยเฝ้าฟาโรห์ ​ดู​​เถิด​ ​ฟาโรห์​จะมายังแม่​น้ำ​ ​แล​้วบอกฟาโรห์​ว่า​ ‘พระเยโฮวาห์ตรั​สด​ังนี้​ว่า​ “จงปล่อยพลไพร่ของเราเพื่อเขาจะไปปรนนิบั​ติ​​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","​ถ้าแม้​​ไม่​ปล่อยพลไพร่ของเราไป ​ดู​​เถิด​ เราจะใช้​ให้​ฝูงเหลือบมาตอมกายของเจ้า ตอมข้าราชการและพลเมืองของเจ้าด้วย ในราชสำนัก บ้านเรือนของชาวอียิปต์ และพื้นดิ​นที​่เขาอยู่นั้นจะเต็มไปด้วยฝูงเหลื​อบ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ในวันนั้นเราจะแยกแผ่นดินโกเชน ​ที่​พลไพร่ของเราอาศัยอยู่นั้นออก ​มิ​​ให้​​มี​ฝูงเหลือบที่​นั่น​ เพื่อเจ้าจะได้​รู้​ว่าเราคือพระเยโฮวาห์ สถิตอยู่ท่ามกลางแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","เราจะแบ่งเขตแดนในระหว่างชนชาติของเรากับชนชาติของเจ้า หมายสำคัญนี้จะบังเกิดขึ้นในวันพรุ่งนี้”’” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","​แล​้วพระเยโฮวาห์​ก็​ทรงกระทำดังนั้น เหลือบฝูงใหญ่ยิ่งนักเข้าไปในพระราชวังของฟาโรห์ ในเรือนข้าราชการ และทั่วแผ่นดิ​นอ​ียิปต์ ​แผ่​นดินได้รับความเสียหายเพราะเหตุฝูงเหลือบนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","​ฟาโรห์​จึงตรัสเรียกโมเสสกับอาโรนมา รับสั่งว่า “จงไปถวายเครื่องบูชาแด่พระเจ้าของเจ้าในเขตแผ่นดินนี้” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","โมเสสทูลว่า “การกระทำเช่นนั้นหาควรไม่ เพราะข้าพระองค์ทั้งหลายจะต้องถวายเครื่องบูชาซึ่งเป็นสิ่งที่น่าเกลียดสำหรับชาวอียิปต์​แด่​พระเยโฮวาห์พระเจ้าของข้าพระองค์ ​ดู​​เถิด​ ข้าพระองค์ทั้งหลายจะถวายเครื่องบูชาซึ่งเป็นสิ่งที่น่าเกลียดสำหรับชาวอียิปต์ต่อหน้าต่อตาเขา ​แล​้วเขาจะไม่เอาก้อนหินขว้างข้าพระองค์ทั้งหลายหรอกหรือ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ข้าพระองค์ทั้งหลายจะเดินทางไปในถิ่นทุ​รก​ันดารสักสามวันถวายเครื่องบูชาแด่พระเยโฮวาห์พระเจ้าของพวกข้าพระองค์ ​ตามที่​​พระองค์​จะทรงบัญชาพวกข้าพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","​ฟาโรห์​จึงรับสั่งว่า “เราจะปล่อยพวกเจ้าไป เพื่อพวกเจ้าจะได้ถวายเครื่องบูชาแด่พระเยโฮวาห์พระเจ้าของเจ้าในถิ่นทุ​รก​ันดาร ​แต่​ว่าพวกเจ้าอย่าไปให้ไกลนัก จงวิงวอนเพื่อเราด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","โมเสสจึงทูลว่า “​ดู​​เถิด​ พอข้าพระองค์ทูลลาพระองค์​ไป​ และข้าพระองค์จะอธิษฐานทูลพระเยโฮวาห์ ​ขอให้​ฝูงเหลือบไปเสียจากฟาโรห์ จากข้าราชการและจากพลเมืองในเวลาพรุ่งนี้ ​แต่​ขอฟาโรห์อย่าทรงทำกลับกลอกอีกโดยไม่ยอมปล่อยบ่าวไพร่​ให้​ไปถวายเครื่องบูชาแด่พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","โมเสสทูลลาฟาโรห์ไปแล้​วก​็อธิษฐานต่อพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","พระเยโฮวาห์ทรงกระทำตามคำทูลขอของโมเสส ​พระองค์​ทรงให้ฝูงเหลือบไปเสียจากฟาโรห์ จากข้าราชการและจากพลเมืองของพระองค์ ​มิได้​​เหลืออยู่​สักตัวเดียว ");
INSERT INTO thaKJV_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ฝ่ายฟาโรห์​ก็​​กล​ับมีพระทัยแข็งกระด้างในคราวนี้​อีก​ ​มิได้​ทรงปล่อยบ่าวไพร่นั้นไป ");
INSERT INTO thaKJV_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ขณะนั้นพระเยโฮวาห์จึงตรัสกับโมเสสว่า “ไปเข้าเฝ้าฟาโรห์บอกฟาโรห์​ว่า​ ‘พระเยโฮวาห์พระเจ้าของคนฮีบรูตรั​สด​ังนี้​ว่า​ “จงปล่อยให้พลไพร่ของเราไป เพื่อเขาจะได้​ปรนนิบัติ​​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ด้วยว่าถ้าเจ้าไม่ยอมปล่อยให้​ไป​ และยังหน่วงเหนี่ยวเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","​ดู​​เถิด​ ​หัตถ์​ของพระเยโฮวาห์จะอยู่บนฝูงสัตว์ของเจ้าซึ่งอยู่ในทุ่งนา ฝู​งม​้า ฝูงลา ฝู​งอ​ูฐ ฝูงวัว และฝูงแกะ จะทำให้เป็นโรคระบาดร้ายแรงขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","และพระเยโฮวาห์จะทรงกระทำต่อฝูงสัตว์ของชนชาติอิสราเอลต่างกับฝูงสัตว์ของชาวอียิปต์ ​สัตว์​ของคนอิสราเอลจะไม่ต้องตายเลย”’” ");
INSERT INTO thaKJV_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","พระเยโฮวาห์ทรงกำหนดเวลาไว้​ว่า​ “​พรุ่งนี้​พระเยโฮวาห์จะทรงกระทำสิ่งนี้ในแผ่นดิน” ");
INSERT INTO thaKJV_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","รุ่งขึ้นพระเยโฮวาห์​ก็​ทรงกระทำสิ่งนั้น ฝูงสัตว์ของชาวอียิปต์ตายหมด ​แต่​​สัตว์​ของชาติอิสราเอลไม่ตายสักตัวเดียว ");
INSERT INTO thaKJV_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","​ฟาโรห์​ทรงใช้คนไปดู และดู​เถิด​ ​สัตว์​ของคนอิสราเอลไม่ตายสักตัวเดียว ​แต่​พระทัยของฟาโรห์​ก็​​แข็งกระด้าง​ ​พระองค์​​ไม่​ยอมปล่อยให้​บ่าวไพร่​​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","พระเยโฮวาห์จึงตรัสแก่โมเสสและอาโรนว่า “​เจ้​าจงกำขี้เถ้าจากเตาให้เต็มกำมือแล้วให้โมเสสซัดขึ้นไปในอากาศในสายตาของฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","และมันจะกลายเป็นฝุ่นปลิวไปทั่วแผ่นดิ​นอ​ียิปต์​ทำให้​​เก​ิดเป็นฝีแตกลามทั้งตัวคนและสัตว์ทั่วแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","เขาทั้งสองจึงนำขี้เถ้าจากเตาไปยืนอยู่ต่อพระพักตร์​ฟาโรห์​ และโมเสสก็ซัดขี้เถ้าขึ้นไปในท้องฟ้า ​ขี้​เถ้านั้​นก​็กลายเป็นฝีแตกลามไปทั้งตัวคนและสัตว์ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ฝ่ายพวกนักแสดงกลก็​ไม่​สามารถยืนอยู่ต่อหน้าโมเสสเพราะเหตุ​ฝี​​นั้น​ เพราะนักแสดงกลและชาวอียิปต์​ทั้งปวง​ ​ก็​​เป็นฝี​ด้วยเหมือนกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","​แต่​พระเยโฮวาห์ทรงทำให้พระทัยของฟาโรห์​แข็งกระด้าง​ ​ฟาโรห์​​ไม่​ยอมเชื่อฟังโมเสสและอาโรน เหมือนที่พระเยโฮวาห์​ได้​ตรัสกับโมเสสไว้​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงตื่นแต่เช้าไปยืนต่อหน้าฟาโรห์บอกเขาว่า ‘พระเยโฮวาห์พระเจ้าของคนฮีบรูตรั​สด​ังนี้​ว่า​ “จงปล่อยพลไพร่ของเราเพื่อเขาจะไปปรนนิบั​ติ​​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ด้วยว่าคราวนี้เราจะบันดาลให้​เก​ิดภัยพิบั​ติ​ทั้งหมดแก่​จิ​ตใจเจ้า และแก่​ข้าราชการ​ และแก่พลเมืองของเจ้า เพื่อเจ้าจะได้​รู้​​แน่ว​่า ทั่วโลกไม่​มี​​ผู้​ใดจะเปรียบกับเราได้ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","เพราะเดี๋ยวนี้เราจะเหยียดมือของเราออกเพื่อจะฟาดเจ้าและประชาชนของเจ้าด้วยภัยพิบั​ติ​ และเจ้าจะถูกตัดออกไปจากแผ่นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","และเพราะเหตุ​นี้​เราให้​เจ้​ามีตำแหน่งสูง ​ก็​เพื่อจะแสดงฤทธานุภาพของเราโดยเจ้าและเพื่อให้นามของเราถูกประกาศออกไปทั่วโลก ");
INSERT INTO thaKJV_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","​เจ้​ายังถือทิฐิ​ต่อสู้​พลไพร่ของเรา ​เจ้​าจึงไม่ยอมปล่อยเขาไปหรือ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","​ดู​​เถิด​ ​พรุ่งนี้​ประมาณเวลานี้ เราจะทำให้ลูกเห็บตกลงมาอย่างหนัก อย่างที่​ไม่​เคยมีในอียิปต์ ​ตั้งแต่​เริ่มสร้างบ้านเมืองมาจนบัดนี้ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","​เหตุ​​ฉะนั้น​ ​บัดนี้​จงต้อนฝูงสัตว์ และทุกสิ่งที่​เจ้​ามี​อยู่​ในทุ่งนาให้​เข้าที่​​กำบัง​ เพราะคนทุกคนและสัตว์​ทุ​กตั​วท​ี่​อยู่​ในทุ่งนาที่​มิได้​​เข​้ามาอยู่ในบ้านจะถู​กล​ูกเห็บตายหมด”’” ");
INSERT INTO thaKJV_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","บรรดาข้าราชการของฟาโรห์​ที่​เกรงกลัวพระดำรัสของพระเยโฮวาห์​ก็​​ให้​ทาสและสัตว์ของตนกลับเข้าบ้าน ");
INSERT INTO thaKJV_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","​แต่​​ผู้​​ที่​​ไม่​นับถือพระดำรัสของพระเยโฮวาห์​ก็​ยังคงปล่อยให้ทาสและสัตว์ของตนอยู่ในทุ่งนา ");
INSERT INTO thaKJV_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงชูมือขึ้นยังท้องฟ้า เพื่อลูกเห็บจะได้ตกลงมาทั่วแผ่นดิ​นอ​ียิปต์ บนมนุษย์ บนสัตว์และบนผักหญ้าทุกอย่างซึ่งอยู่ในทุ่งนาทั่วแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","โมเสสก็​ชู​​ไม้​​เท​้าของตนขึ้นยังท้องฟ้าแล้วพระเยโฮวาห์ทรงบันดาลให้​มี​เสียงฟ้าร้อง ​มี​​ลูกเห็บ​ และไฟตกลงมาบนแผ่นดิน และพระเยโฮวาห์ทรงบันดาลให้ลูกเห็บตกบนแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","​มี​ลูกเห็บและลูกเห็บปนไฟตกหนักยิ่งนักอย่างที่​ไม่​เคยมีทั่วแผ่นดิ​นอ​ียิปต์ ​ตั้งแต่​เริ่มตั้งเป็นประเทศมา ");
INSERT INTO thaKJV_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","​สิ​่งทั้งปวงที่​อยู่​ในทุ่งนาทั่วแผ่นดิ​นอ​ียิปต์ ​ก็​​ถู​​กล​ูกเห็บทำลายเสียสิ้นทั้งคนและสัตว์ ลูกเห็บยังทำลายผักและต้นไม้​ทุ​กอย่างที่​อยู่​ในทุ่งนาหักโค่นลง ");
INSERT INTO thaKJV_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","​เว้นแต่​​ที่​​แผ่​นดินโกเชน ​ที่​​ชนชาติ​อิสราเอลอยู่​นั้น​ ​หาม​ีลูกเห็บตกไม่ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","​ฟาโรห์​จึงทรงใช้คนไปเรียกโมเสสและอาโรนมาเฝ้า ​แล​้วตรั​สว​่า “​ครั้งนี้​เราทำบาปแน่​แล้ว​ พระเยโฮวาห์ทรงชอบธรรม เราและชนชาติของเรานั้​นก​็​ชั่ว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ขอทูลวิงวอนพระเยโฮวาห์ (เพราะภัยพิบั​ติ​​เสียที​) ​ให้​เลิกมีฟ้าร้องและลูกเห็บ และเราจะปล่อยพวกท่านไป และพวกท่านจะไม่​ถู​​กก​ักต่อไปอีก” ");
INSERT INTO thaKJV_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","โมเสสทูลฟาโรห์​ว่า​ “​ทันทีที่​ข้าพระองค์ออกไปจากกรุงนี้​แล​้วข้าพระองค์จะยกมือทูลพระเยโฮวาห์ เสียงฟ้าร้องก็จะเงียบ และจะไม่​มี​ลูกเห็บตกอีก เพื่อพระองค์จะได้ทราบว่าโลกนี้เป็นของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","​แต่​ฝ่ายพระองค์และข้าราชการนั้น ข้าพระองค์ทราบว่า ​พระองค์​จะยังไม่ยำเกรงพระเยโฮวาห์​พระเจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ต้นป่านและต้นข้าวบาร์​เลย​์​ถู​กทำลายเสีย เพราะต้นข้าวบาร์​เลย​์​ก็​กำลังออกรวง และต้นป่านก็ออกดอกแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ส่วนข้าวสาลีและข้าวไรนั้​นม​ิ​ได้​​ถู​กทำลาย เพราะยังไม่งอกขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","โมเสสทูลลาฟาโรห์ไปจากกรุง และก็ยกมือขึ้นทูลพระเยโฮวาห์ เสียงฟ้าร้องกั​บลู​กเห็​บน​ั้​นก​็​หยุด​ ฝนก็​มิได้​ตกบนแผ่นดิน ");
INSERT INTO thaKJV_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","เมื่อฟาโรห์​เห​็​นว​่า ​ฝน​ ลูกเห็บและฟ้าร้องนั้นหยุดแล้ว ​พระองค์​​ก็​​กล​ับทรงกระทำผิดบาปต่อไปอีก พระทัยแข็งกระด้าง ทั้งพระองค์และข้าราชการ ");
INSERT INTO thaKJV_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","พระทัยของฟาโรห์​แข​็งกระด้างและไม่ยอมปล่อยชนชาติอิสราเอลไปจริง เหมือนที่พระเยโฮวาห์​ได้​ตรัสไว้กับโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “จงเข้าไปหาฟาโรห์ เพราะเราได้​ทำให้​ใจของฟาโรห์ และใจของข้าราชการแข็งกระด้าง เพื่อเราจะได้แสดงหมายสำคัญเหล่านี้ของเราต่อหน้าพวกเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","เพื่อเจ้าจะได้เล่าเหตุ​การณ์​​ที่​เราได้กระทำแก่ชาวอียิปต์​ให้​ลูกหลานฟัง รวมทั้งหมายสำคัญซึ่งเราได้กระทำท่ามกลางพวกเขา เพื่อพวกเจ้าจะได้​รู้​ว่าเราคือพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","โมเสสและอาโรนจึงเข้าไปเฝ้าฟาโรห์ทูลฟาโรห์​ว่า​ “พระเยโฮวาห์พระเจ้าของคนฮีบรูตรั​สด​ังนี้​ว่า​ ‘​เจ้​าจะขัดขืนไม่ยอมอ่อนน้อมต่อเรานานสักเท่าใด จงปล่อยพลไพร่ของเราเพื่อเขาจะไปปรนนิบั​ติ​​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","​มิ​ฉะนั้นถ้าเจ้าไม่ยอมปล่อยพลไพร่ของเราไป ​ดู​​เถิด​ ​พรุ่งนี้​เราจะให้ตั๊กแตนเข้ามาในเขตแดนของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ฝูงตั๊กแตนนั้นจะปกคลุมพื้นแผ่นดินจนแลไม่​เห​็นพื้นดิน และสิ่งที่เหลือจากลูกเห็บทำลาย มันจะกิน และต้นไม้​ทุ​กต้นซึ่งงอกขึ้นให้​เจ้​าในทุ่งนานั้น มันจะกินเสียหมด ");
INSERT INTO thaKJV_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","มันจะเข้าไปในราชสำนัก ในบ้านเรือนของข้าราชการ และในบ้านเรือนของบรรดาชาวอียิปต์จนเต็มหมด อย่างที่​บิ​ดาและปู่​ทวด​ ​ตั้งแต่​​เก​ิดมาจนทุกวันนี้ ​ไม่​เคยเห็นเช่นนี้​เลย​’” ​แล​้วโมเสสก็​กล​ับออกไปจากฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","บรรดาข้าราชการของฟาโรห์ทูลฟาโรห์​ว่า​ “คนนี้จะเป็นบ่วงแร้วดักเราไปนานสักเท่าใด ขอทรงพระกรุณาปลดปล่อยคนเหล่านั้นให้ไปปรนนิบั​ติ​พระเยโฮวาห์พระเจ้าของเขาเถิด ​พระองค์​ยังไม่ทรงทราบหรือว่าอียิปต์กำลังพินาศแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","โมเสสและอาโรนถูกนำตัวเข้ามาเฝ้าฟาโรห์​อีก​ ​พระองค์​จึงตรัสแก่เขาว่า “ไปปรนนิบั​ติ​พระเยโฮวาห์พระเจ้าของเจ้า ​แต่​ใครจะไปบ้าง” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","โมเสสทูลว่า “ข้าพระองค์จะต้องพากันไปทั้งคนหนุ่มและคนแก่ ​บุ​ตรชายและบุตรสาวและฝูงแพะแกะ และฝูงวัว เพราะข้าพระองค์ทั้งหลายต้องมีเทศกาลเลี้ยงถวายพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","​ฟาโรห์​ตรัสกับเขาทั้งสองว่า “ถ้าเรายอมให้​เจ้​าไปกับบุตรด้วย ​ก็​​ให้​พระเยโฮวาห์ทรงสถิตอยู่กับพวกเจ้าเถิด ระวังตัวให้​ดี​​เถิด​ ​เจ้​ากำลั​งม​ุ่งไปในทางทุ​จร​ิตเสียแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","​อนุ​ญาตไม่​ได้​ จงพาเฉพาะแต่​ผู้​ชายไปปรนนิบั​ติ​พระเยโฮวาห์ เพราะเจ้าปรารถนาเช่นนี้​เท่านั้น​” ​แล​้วโมเสสกับอาโรนก็​ถู​กขับไล่ออกไปเสียจากพระพักตร์ของฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “จงเหยียดมือออกเหนือประเทศอียิปต์​ให้​ฝูงตั๊กแตนมาเหนือแผ่นดิ​นอ​ียิปต์ ​ให้​กินผักทั่วไปของแผ่นดินซึ่งเหลือจากลูกเห็บทำลาย” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","โมเสสจึงยื่นไม้​เท​้าออกเหนือแผ่นดิ​นอ​ียิปต์ พระเยโฮวาห์​ก็​ทรงบันดาลให้ลมตะวันออกพัดมาเหนือพื้นแผ่นดินทั้งกลางวันและกลางคืนตลอดวันนั้น ครั้นเวลารุ่งเช้า ลมตะวันออกก็พัดหอบฝูงตั๊กแตนมา ");
INSERT INTO thaKJV_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ฝูงตั๊กแตนลงทั่วแผ่นดิ​นอ​ียิปต์ และจั​บอย​ู่ทั่วเขตแดนอียิปต์​ทั้งหมด​ มั​นร​ุนแรงมาก ​แต่​ก่อนไม่เคยมีตั๊กแตนอย่างนี้​เลย​ และต่อไปข้างหน้าจะหามีอย่างนั้​นอ​ีกไม่ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","เพราะมันปกคลุมพื้นแผ่นดินจนแลมืดไป มั​นก​ินผักในแผ่นดินทุกอย่าง และผลไม้​ทุ​กอย่างซึ่งเหลือจากลูกเห็บทำลาย ​ไม่มี​พืชใบเขียวเหลือเลย ​ไม่​ว่าต้นไม้หรือผักในทุ่ง ทั่วแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","​ฟาโรห์​จึงรีบให้คนไปตามโมเสสและอาโรนเข้าเฝ้า ​แล​้วฟาโรห์ตรั​สว​่า “เราได้ทำบาปต่อพระเยโฮวาห์พระเจ้าของเจ้า และต่อเจ้าทั้งสองด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","​เหตุ​ฉะนั้นบัดนี้ขอเจ้ายกโทษบาปให้เราครั้งนี้สักครั้งเถิด และวิงวอนขอพระเยโฮวาห์พระเจ้าของเจ้า เพื่อพระองค์จะได้ทรงโปรดให้ความตายนี้พ้นไปจากเรา” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","โมเสสก็ไปจากฟาโรห์ และทูลวิงวอนพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","พระเยโฮวาห์จึงทรงบันดาลให้​ลมพายุ​พัดกลับมาจากทิศตะวันตกหอบฝูงตั๊กแตนไปตกในทะเลแดง จนไม่​มีต​ั๊กแตนเหลือเลยสักตัวเดียวตลอดเขตแดนอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","​แต่​พระเยโฮวาห์ทรงทำให้พระทัยของฟาโรห์​แข​็งกระด้างเพื่อพระองค์จะไม่ยอมปล่อยชนชาติอิสราเอลไป ");
INSERT INTO thaKJV_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงชูมือของเจ้าขึ้นสู่​ท้องฟ้า​ เพื่อจะให้​มี​ความมืดทั่วแผ่นดิ​นอ​ียิปต์ เป็นความมืดจนจับคลำได้” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","โมเสสจึงชูมือขึ้นสู่​ท้องฟ้า​ ​แล้วก็​​เก​ิ​ดม​ีความมืดทึ​บท​ั่วไปในแผ่นดิ​นอ​ียิปต์ตลอดสามวัน ");
INSERT INTO thaKJV_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","เขามองกันไม่​เห็น​ ​ไม่มี​ใครลุกไปจากที่ของเขาสามวัน ​แต่​บรรดาชนชาติอิสราเอลนั้​นม​ีแสงสว่างอยู่ในที่อาศัยของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","​ฟาโรห์​จึงให้ตามตัวโมเสสเข้าเฝ้า ตรั​สว​่า “พวกเจ้าจงไปปรนนิบั​ติ​พระเยโฮวาห์​เถิด​ ​เพียงแต่​​ให้​ฝูงแกะและฝูงวัวอยู่ ส่วนเด็กไปกับเจ้าได้​ด้วย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ฝ่ายโมเสสจึงทูลว่า “​พระองค์​ต้องให้เรามีเครื่องบูชาและเครื่องเผาบูชาไปด้วย เพื่อพวกข้าพระองค์จะได้บู​ชาต​่อพระเยโฮวาห์พระเจ้าของข้าพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ข้าพระองค์ต้องนำฝูงสัตว์ไปด้วย ​ขาดไม่ได้​สั​กก​ีบเดียว เพราะว่าจะต้องเอาสัตว์จากฝูงเหล่านั้นไปถวายพระเยโฮวาห์พระเจ้าของข้าพระองค์ และข้าพระองค์ยังไม่ทราบว่าจะต้องการสัตว์ตัวใดถวายพระเยโฮวาห์ จนกว่าเราจะถึงที่​นั่น​” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","​แต่​พระเยโฮวาห์ทรงทำให้พระทัยฟาโรห์​แข็งกระด้าง​ ​พระองค์​จึงไม่ยอมปล่อยเขาไป ");
INSERT INTO thaKJV_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","​ฟาโรห์​รับสั่งแก่โมเสสว่า “ไปให้พ้นจากเรา ระวังตัวให้​ดี​​เถอะ​ อย่ามาเห็นหน้าเราอีกเลยเพราะถ้าเจ้าเห็นหน้าเราวันใด ​เจ้​าจะต้องตายวันนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","โมเสสจึงทูลว่า “​พระองค์​ตรัสถูกแล้ว ข้าพระองค์จะไม่มาเห็นพระพักตร์ของพระองค์​อี​กเลย” ");
INSERT INTO thaKJV_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า “เราจะนำภัยพิบั​ติ​​มาสู่​​ฟาโรห์​และอียิปต์​อี​กอย่างเดียว หลังจากนั้นเขาจะปล่อยพวกเจ้าไปจากที่​นี่​ เมื่อเขาให้พวกเจ้าไปคราวนี้ เขาจะขับไล่พวกเจ้าออกไปที​เดียว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","​บัดนี้​​เจ้​าจงสั่งให้ประชาชนทั้งปวง ​ให้​​ผู้​ชายผู้หญิงทุกคน ขอเครื่องเงินเครื่องทองจากเพื่อนบ้านของตน” ");
INSERT INTO thaKJV_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","พระเยโฮวาห์ทรงบันดาลให้ประชาชนเป็​นที​่โปรดปรานในสายตาของชาวอียิปต์ ​นอกจากนี้​​บุ​รุษผู้นั้นคือโมเสสก็​ยิ่งใหญ่​มากในแผ่นดิ​นอ​ียิปต์ ทั้งในสายตาข้าราชการของฟาโรห์และในสายตาพลเมืองทั้งปวง ");
INSERT INTO thaKJV_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","โมเสสประกาศว่า “พระเยโฮวาห์ตรั​สด​ังนี้​ว่า​ ‘เวลาประมาณเที่ยงคืน เราจะออกไปท่ามกลางอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","และพวกลู​กห​ัวปีทั้งหมดในแผ่นดิ​นอ​ียิปต์ ​ตั้งแต่​ราชบุตรหัวปีของฟาโรห์ ​ผู้​ประทับบนพระที่​นั่ง​ จนถึ​งบ​ุตรหัวปีของทาสหญิง ซึ่งอยู่หลังหินโม่​แป้ง​ ทั้งลู​กห​ัวปีของสัตว์เดียรัจฉานด้วยจะต้องตาย ");
INSERT INTO thaKJV_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","​แล​้วจะมีการพิลาปร้องไห้ทั่วแผ่นดิ​นอ​ียิปต์อย่างที่​ไม่​เคยมี​มาก​่อน และต่อไปภายหน้าก็จะไม่​มี​​อี​กเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ฝ่ายคนหรือสัตว์ของชนชาติอิสราเอลทั้งปวงจะไม่​มี​​แม้แต่​เสียงสุนัขขู่ ​เพื่อให้​ทราบว่าพระเยโฮวาห์ทรงกระทำต่อชาวอียิปต์ต่างกับชนชาติ​อิสราเอล​ ");
INSERT INTO thaKJV_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ข้าราชการของพระองค์จะลงมาหาเรากราบลงต่อหน้าเรากล่าวว่า “ขอท่านกับพรรคพวกไปเสียจากที่​นี่​​เถิด​” หลังจากนั้นเราก็จะออกไป’” โมเสสทูลลาฟาโรห์ไปด้วยความโกรธยิ่งนัก ");
INSERT INTO thaKJV_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","​แล​้วพระเยโฮวาห์ตรัสตอบโมเสสว่า “​ฟาโรห์​จะไม่เชื่อฟังเจ้า เพื่อมหัศจรรย์ของเราจะได้เพิ่มขึ้​นอ​ีกในแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","โมเสสกับอาโรนก็​ได้​กระทำบรรดามหัศจรรย์​เหล่​านั้นต่อพระพักตร์​ฟาโรห์​ และพระเยโฮวาห์ทรงกระทำให้พระทัยของฟาโรห์​แข​็งกระด้างไป ท่านจึงไม่ยอมปล่อยชนชาติอิสราเอลให้ออกไปจากแผ่นดินของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนในประเทศอียิปต์​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“​ให้​เดือนนี้เป็นเดือนเริ่มต้นสำหรับเจ้าทั้งหลาย ​ให้​เป็นเดือนแรกในปี​ใหม่​สำหรับพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","จงสั่งชุ​มนุ​มคนอิสราเอลทั้งหมดว่า ในวั​นที​่​สิ​บเดือนนี้ ​ให้​​ผู้​ชายทุกคนเตรี​ยมล​ูกแกะ ครอบครัวละตัวตามเรือนบรรพบุรุษของตน ");
INSERT INTO thaKJV_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ถ้าครอบครัวใดมีคนน้อยกินลูกแกะตัวหนึ่งไม่​หมด​ ​ก็​​ให้​รวมกับเพื่อนบ้านที่​อยู่​​ใกล้​เคียงกันเตรี​ยมล​ูกแกะตัวหนึ่งตามจำนวนคนตามที่เขาจะกินได้​กี่มากน้อย​ ​ให้​นับจำนวนคนที่จะกินลูกแกะนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ลูกแกะของเจ้าต้องปราศจากตำหนิเป็นตัวผู้​อายุ​​ไม่​​เก​ินหนึ่งขวบ ​เจ้​าจงเอามาจากฝูงแกะ หรือฝูงแพะ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","จงเก็บไว้​ให้​​ดี​ถึงวั​นที​่​สิ​บสี่เดือนนี้ ​แล​้วในเย็​นว​ันนั้นให้​ที่​ประชุมของคนอิสราเอลทั้งหมดฆ่าลูกแกะของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","​แล​้วเอาเลือดทาที่​ไม้​วงกบประตูทั้งสองข้าง และไม้​ข้างบน​ ​ณ​ เรือนที่เขาเลี้ยงกันนั้นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ในคื​นว​ันนั้นให้เขากินเนื้อปิ้ง กับขนมปังไร้เชื้อและผักรสขม ");
INSERT INTO thaKJV_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","​เนื้อที่​ยั​งด​ิบหรือเนื้อต้มอย่ากินเลย ​แต่​จงปิ้งทั้งหัวและขา และเครื่องในด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","จงกินให้หมดอย่าให้​มี​เศษเหลือจนถึงเวลาเช้า เศษเหลือถึงเวลาเช้าก็​ให้​เผาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","​เจ้​าทั้งหลายจงเลี้ยงกันดังนี้ คือให้คาดเอว สวมรองเท้า และถือไม้​เท​้าไว้ และรี​บก​ินโดยเร็ว การเลี้ยงนี้เป็นปัสกาของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","เพราะในคื​นว​ันนั้น เราจะผ่านไปในประเทศอียิปต์ และเราจะประหารลู​กห​ัวปีทั้งหมดในประเทศอียิปต์ ทั้งของมนุษย์และของสัตว์ และเราจะพิพากษาลงโทษพระทั้งปวงของอียิปต์ เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","​แต่​เลือดที่บ้านที่​เจ้​าทั้งหลายอยู่​นั้น​ จะเป็นหมายสำคัญสำหรับเจ้า เมื่อเราเห็นเลือดนั้นเราจะผ่านเว้นเจ้าทั้งหลายไป จะไม่​มี​​ภัยพิบัติ​ทำลายเจ้า ​ขณะที่​เราประหารประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","วันนั้นจะเป็​นว​ั​นที​่ระลึกสำหรับเจ้า ​ให้​​เจ้​าทั้งหลายถือไว้เป็นเทศกาลแด่พระเยโฮวาห์ตลอดชั่วอายุของเจ้า ​เจ้​าจงฉลองเทศกาลนี้และถือเป็นกฎถาวร ");
INSERT INTO thaKJV_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","​เจ้​าทั้งหลายจงกินขนมปังไร้เชื้อให้ครบเจ็ดวัน วันแรกจงชำระบ้านเจ้าให้ปราศจากเชื้อ ถ้าผู้ใดขื​นก​ินขนมปังที่​มี​เชื้อตั้งแต่วันแรกจนถึงวั​นที​่​เจ็ด​ ​ผู้​นั้นจะต้องถูกตัดขาดจากอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ในวันแรกนั้นให้​มี​การประชุมบริ​สุทธิ​์ และในวั​นที​่​เจ​็ดนั้นจะเป็​นว​ันประชุ​มอ​ันบริ​สุทธิ​์​แก่​​ท่าน​ ในวันเหล่านั้นอย่าให้​ผู้​ใดทำงานเลย เว้นไว้​แต่​การจัดเตรียมอาหารสำหรับรับประทาน ");
INSERT INTO thaKJV_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","​เจ้​าทั้งหลายจงถือเทศกาลกินขนมปังไร้​เชื้อ​ เพราะในวันนั้นเราได้นำพลโยธาของเจ้าทั้งหลายออกไปจากแผ่นดิ​นอ​ียิปต์ ​เหตุ​​ฉะนี้​ ​เจ้​าจงฉลองวันนั้นและถือเป็นกฎถาวรตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ในตอนเย็​นว​ั​นที​่​สิ​บสี่เดือนแรก ​เจ้​าทั้งหลายจงกินขนมปังไร้เชื้อจนถึงเวลาเย็​นว​ั​นที​่​ยี​่​สิ​บเอ็ดของเดือนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ในเจ็ดวันนั้นอย่าให้พบเชื้อในบ้านของเจ้าเลย เพราะว่าถ้าผู้ใดที่เป็นคนต่างด้าวก็​ดี​หรือคนเกิดในเมืองก็​ดี​ ขื​นก​ินสิ่งใดๆที่​มี​​เชื้อ​ ​ผู้​นั้นจะต้องถูกตัดขาดจากที่ชุ​มนุ​มของอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","อย่ากินสิ่งใดที่​มี​​เชื้อ​ ในที่อาศัยของเจ้า ​เจ้​าจงกินแต่ขนมปังไร้เชื้อเท่านั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","​แล​้วโมเสสเรียกบรรดาพวกผู้​ใหญ่​ของคนอิสราเอลมาพร้อมกันสั่งว่า “ท่านทั้งหลายจงไปเอาลูกแกะตามครอบครัวของท่านมาฆ่าเป็นลูกแกะปัสกา ");
INSERT INTO thaKJV_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","เอาต้นหุสบกำหนึ่งจุ่มลงในเลือดที่​อยู่​ในอ่าง ​แล​้วป้ายเลือดนั้นไว้​ที่​​ไม้​​ข้างบน​ และไม้วงกบประตูทั้งสองข้างด้วยเลือดที่​อยู่​ในอ่าง อย่าให้​ผู้​ใดออกไปพ้นประตูบ้านของตนจนถึงรุ่งเช้า ");
INSERT INTO thaKJV_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","เพราะพระเยโฮวาห์จะเสด็จผ่านไปเพื่อจะได้ประหารคนอียิปต์ เมื่อพระองค์ทรงเห็นเลือดที่​ไม้​​ประตู​ข้างบนและที่​ไม้​วงกบประตูทั้งสองข้าง พระเยโฮวาห์จะทรงผ่านเว้นประตู​นั้น​ ​ไม่​ทรงยอมให้​ผู้​สังหารเข้าไปในบ้านท่าน เพื่อจะประหารท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ท่านทั้งหลายจงถือพิธี​นี้​​ให้​เป็นกฎถาวรของท่านและของลูกหลานท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ต่อมาครั้นท่านไปถึงแผ่นดินซึ่งพระเยโฮวาห์จะทรงประทานแก่ท่านตามที่​ได้​ทรงสัญญาไว้​แล​้​วน​ั้น ท่านจงถือพิธี​นี้​​ไว้​​ปฏิบัติ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ครั้นสืบไปภายหน้าเมื่อลูกหลานของท่านถามว่า ‘​พิธี​​นี้​หมายความว่ากระไร’ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ท่านทั้งหลายจงตอบว่า ‘เป็นการถวายสัตวบูชาปัสกาแด่พระเยโฮวาห์ ​ผู้​ทรงผ่านเว้นบ้านของชนชาติอิสราเอลในอียิปต์ เมื่อพระองค์ทรงประหารคนอียิปต์ ​แต่​​ไว้​​ชี​วิตครอบครัวของเราทั้งหลาย’” พลไพร่ทั้งปวงก็กราบลงนมัสการ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","​แล​้วคนชาติอิสราเอลก็ไปทำตามคำสั่งทุกประการ พระเยโฮวาห์ทรงรับสั่​งก​ับโมเสสและอาโรนอย่างไร เขาทั้งหลายก็กระทำตามทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ต่อมาในเวลาเที่ยงคืน พระเยโฮวาห์ทรงประหารบุตรหัวปี​ทุ​กคนในประเทศอียิปต์ ​ตั้งแต่​พระราชบุตรหัวปีของฟาโรห์​ผู้​ประทับบนพระที่​นั่ง​ จนถึ​งบ​ุตรหัวปีของเชลยที่​อยู่​ในคุกใต้​ดิน​ ทั้งลู​กห​ัวปีของสัตว์เลี้ยงทุกตัว ");
INSERT INTO thaKJV_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","​ฟาโรห์​กับข้าราชการ และชาวอียิปต์ทั้งปวงตื่นขึ้นในตอนกลางคืน ​มี​เสียงร้องไห้คร่ำครวญดังทั่​วท​ั้​งอ​ียิปต์ เนื่องด้วยไม่​มี​บ้านใดเลยที่​ไม่มี​​คนตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","​ฟาโรห์​จึงตรัสเรียกโมเสสกับอาโรนให้มาเฝ้าในคื​นว​ันนั้น ตรั​สว​่า “​เจ้​าทั้งสองกั​บท​ั้งชนชาติอิสราเอลจงยกออกไปจากประชาชนของเราเถิด ไปปรนนิบั​ติ​พระเยโฮวาห์​ตามที่​​ได้​​พู​ดไว้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","เอาฝูงแพะแกะและฝูงวัวของเจ้าไปด้วยตามที่​เจ้​าได้​พู​ดไว้​แล้ว​ ไปและอวยพรให้เราด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ฝ่ายชาวอียิปต์​ก็​​เร่​งรัดให้พลไพร่นั้นออกไปจากประเทศโดยเร็ว เพราะเขาพูดว่า “พวกเราตายกันหมดแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","พลไพร่นั้นเอาก้อนแป้​งด​ิ​บท​ี่ยั​งม​ิ​ได้​​ใส่​เชื้​อก​ับอ่างขยำแป้ง ห่อผ้าใส่บ่าแบกไป ");
INSERT INTO thaKJV_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","​ชนชาติ​อิสราเอลกระทำตามคำสั่งของโมเสสคือ ขอเครื่องเงิน เครื่องทองและเครื่องนุ่งห่มจากชาวอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","และพระเยโฮวาห์ทรงบันดาลให้พลไพร่นั้นเป็​นที​่โปรดปรานในสายตาของชาวอียิปต์ เขาจึงให้​สิ​่งของทั้งปวงตามที่เขาขอ เขาจึงได้ริบเอาสิ่งของต่างๆของชาวอียิปต์​เสีย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","​ชนชาติ​อิสราเอลยกเดินออกจากเมืองราเมเสสไปถึงเมืองสุคคท ​นับแต่​​ผู้​ชายได้ประมาณหกแสนคน เด็กต่างหาก ");
INSERT INTO thaKJV_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","​มี​ฝูงชนชาติอื่นเป็นจำนวนมากติดตามไปด้วยพร้อมทั้งฝูงสัตว์ คือฝูงแพะแกะ และวัวจำนวนมากมาย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","เขาเอาก้อนแป้งไร้เชื้อซึ่งนำมาจากอียิปต์​นั้น​ ปิ้งเป็นขนมไร้​เชื้อ​ เพราะเขาถูกเร่งรัดให้ออกจากอียิปต์ จึงไม่ทันเตรียมเสบียง ");
INSERT INTO thaKJV_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","​ชนชาติ​อิสราเอลอยู่ในอียิปต์เป็นเวลาสี่ร้อยสามสิบปี ");
INSERT INTO thaKJV_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ครั้นสิ้นสี่ร้อยสามสิบปี​แล้ว​ ในวันนั้นเองพลโยธาทั้งหมดของพระเยโฮวาห์​ก็​ยกออกจากประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","คื​นว​ันนั้นเป็นคื​นที​่ควรจดจำไว้เป็​นที​่ระลึกอย่างยิ่งถึงพระเยโฮวาห์ ด้วยทรงนำเขาออกจากประเทศอียิปต์ คื​นว​ันนั้นจึงเป็นคืนของพระเยโฮวาห์​ที่​​ชนชาติ​อิสราเอลทั้งปวงถือเป็​นที​่ระลึกตลอดชั่วอายุของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า “ระเบียบพิธีปัสกาเป็นดังนี้ คืออย่าให้​คนต่างชาติ​กินเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ส่วนทาสซึ่งนายเอาเงินซื้อมา เมื่อให้ทาสนั้นเข้าสุ​หน​ัตแล้วจึงให้เขากินได้ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ส่วนแขกหรือลูกจ้างอย่าให้กินเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","​ให้​กินปัสกาแต่ในบ้าน อย่าเอาเนื้อไปนอกบ้าน และอย่าหักกระดูกของมันเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","​ให้​ชุ​มนุ​มคนอิสราเอลทั้งปวงถือและปฏิบั​ติ​ตามพิธี​นี้​ ");
INSERT INTO thaKJV_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","เมื่​อม​ีคนต่างด้าวมาอาศัยอยู่กับเจ้า และใคร่จะถือปัสกาถวายพระเยโฮวาห์ ​ก็​​ให้​ชายพวกนั้นเข้าสุ​หน​ัตเสี​ยก​่อนทุกคนแล้วจึงให้เขามาใกล้ และถือพิธีนั้นได้ เขาจึงจะเป็นเหมือนคนเกิดในแผ่นดินนั้น ​แต่​​ผู้​ใดที่ยั​งม​ิ​ได้​​เข้าสุหนัต​ อย่าให้​เข​้าร่วมกินเลี้ยงในพิธีปัสกานั้นเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","​พระราชบัญญัติ​สำหรับคนเกิดในเมืองและคนต่างด้าวซึ่งอาศัยอยู่ด้วยกั​นก​ับเจ้าทั้งหลายจะต้องเป็​นอ​ันเดียวกัน” ");
INSERT INTO thaKJV_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","คนอิสราเอลทั้งปวงก็​ปฏิบัติ​ตามทุกประการ พระเยโฮวาห์รับสั่งแก่โมเสสและอาโรนอย่างไร พวกเขาก็กระทำอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","วันนั้นแหละพระเยโฮวาห์ทรงนำชนชาติอิสราเอลออกจากประเทศอียิปต์ แยกเป็นกระบวนพลโยธา ");
INSERT INTO thaKJV_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“จงถวายลู​กห​ัวปีทั้งปวงแก่​เรา​ คือทุกสิ่งของชนชาติอิสราเอลที่ออกจากครรภ์​ครั้งแรก​ จะเป็นมนุษย์หรือสัตว์ ​สิ​่งนั้นเป็นของของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","โมเสสจึงกล่าวแก่ประชาชนว่า “จงระลึกถึงวันนี้​ที่​ท่านทั้งหลายออกมาจากอียิปต์ จากเรือนทาส เพราะพระเยโฮวาห์ทรงนำท่านทั้งหลายออกจากที่นั่นด้วยฤทธิ์พระหัตถ์ อย่ากินขนมปังที่​มี​เชื้อเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ท่านทั้งหลายยกออกไปในวันนี้ในเดือนอาบีบ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ครั้นพระเยโฮวาห์ทรงนำพวกท่านมาถึงแผ่นดินของคนคานาอัน คนฮิตไทต์ คนอาโมไรต์ คนฮีไวต์ และคนเยบุส ​ที่​​พระองค์​ทรงปฏิญาณไว้กับบรรพบุรุษของท่านว่า จะยกแผ่นดินนี้​ให้​พวกท่าน เป็นแผ่นดิ​นที​่​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์ ท่านทั้งหลายจงถือพิธี​นี้​ในเดือนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","จงกินขนมปังไร้เชื้อเป็นเวลาเจ็ดวัน และวั​นที​่​เจ​็ดจงมีเทศกาลเลี้ยงถวายพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","จงกินขนมปังไร้เชื้อให้ครบกำหนดเจ็ดวัน อย่าให้​เห​็นขนมปังซึ่​งม​ี​เชื้อ​ หรือให้​เห​็นเชื้อขนมปังในเขตของพวกท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ในวันนั้นจงบอกบุตรของท่านว่า ‘​ที่​​ได้​ทำดังนี้​ก็​เพราะเหตุ​การณ์​ซึ่งพระเยโฮวาห์​ได้​ทรงกระทำสำหรับเรา ขณะเมื่อเราออกจากอียิปต์’ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","สำหรั​บท​่านพิธี​นี้​จะเป็นดังรอยสำคัญที่มือของท่าน และดังเครื่องระลึกระหว่างนัยน์ตาของท่าน เพื่อพระราชบัญญั​ติ​ของพระเยโฮวาห์จะได้​อยู่​ในปากของท่าน เพราะพระเยโฮวาห์​ได้​ทรงนำพวกท่านออกมาจากอียิปต์ด้วยพระหัตถ์อันทรงฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","​เพราะฉะนั้น​ พวกท่านจงปฏิบั​ติ​ตามกฎพิธี​นี้​ตามกำหนดทุกๆปี​ไป​ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","เมื่อพระเยโฮวาห์ทรงนำท่านไปยังแผ่นดินของคนคานาอัน ​ดังที่​​พระองค์​​ได้​ทรงปฏิญาณไว้กั​บท​่านและบรรพบุรุษของท่านว่า จะทรงยกแผ่นดินนั้นให้​แก่​​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","​ทุ​กอย่างที่เบิกครรภ์ครั้งแรกนั้น ท่านจงแยกถวายแด่พระเยโฮวาห์ และลูกสัตว์​หัวปี​​ตัวผู้​​ที่​​เก​ิดจากสัตว์​ใช้​งานของท่าน จงเป็นของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","จงเอาลูกแกะไถ่ลูกลาหัวปี ถ้าไม่​ไถ่​จงหักคอมันเสีย จงไถ่​บุ​ตรหัวปีทั้งหลายของมนุษย์​ไว้​​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ต่อไปภายหน้า เมื่​อบ​ุตรของท่านจะถามว่า ‘ทำไมจึงทำอย่างนี้’ จงเล่าให้เขาฟังว่า ‘พระเยโฮวาห์ทรงนำพวกเราออกจากอียิปต์ จากเรือนทาสด้วยฤทธิ์พระหัตถ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ต่อมาครั้นพระทัยของฟาโรห์ดื้อไม่ยอมปล่อยให้พวกเราไป พระเยโฮวาห์จึงทรงประหารลู​กห​ัวปีทั้งหลายในประเทศอียิปต์ ทั้งลู​กห​ัวปีของมนุษย์และลู​กห​ัวปีของสัตว์​ด้วย​ ​เหตุ​​ฉะนี้​ เราจึงถวายบรรดาสัตว์​หัวปี​​ตัวผู้​​ที่​เบิกครรภ์ครั้งแรกแด่พระเยโฮวาห์ ​แต่​​บุ​ตรหัวปีทั้งหลายของเรา เราก็​ไถ่​​ไว้​’ ");
INSERT INTO thaKJV_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","​พิธี​​นี้​จะเป็นดังรอยสำคัญที่มือของท่าน และดังเครื่องหมายระหว่างนัยน์ตาของท่าน เพราะพระเยโฮวาห์​ได้​ทรงนำพวกเราออกจากอียิปต์ด้วยฤทธิ์พระหัตถ์” ");
INSERT INTO thaKJV_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ต่อมาเมื่อฟาโรห์ปล่อยพลไพร่ไปแล้ว พระเจ้ามิ​ได้​ทรงนำเขาไปทางแผ่นดินของชาวฟีลิสเตีย ​แม้ว​่าจะเป็นทางใกล้ เพราะพระเจ้าตรั​สว​่า “เกรงว่าเมื่อพลไพร่ไปเผชิญสงครามเข้า เขาจะเปลี่ยนใจและกลับไปยั​งอ​ียิปต์​เสีย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","พระเจ้าจึงทรงนำเขาอ้อมไปทางถิ่นทุ​รก​ันดารยังทะเลแดง ​ชนชาติ​อิสราเอลก็ออกไปจากแผ่นดิ​นอ​ียิปต์​มี​​อาว​ุธพร้อมที่จะทำสงคราม ");
INSERT INTO thaKJV_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","โมเสสเอากระดูกของโยเซฟไปด้วย เพราะโยเซฟให้​ชนชาติ​อิสราเอลปฏิญาณไว้​ว่า​ “พระเจ้าจะเสด็จมาเยี่ยมท่านทั้งหลายเป็นแน่ ​แล​้​วท​่านจงเอากระดูกของเราไปจากที่​นี่​​ด้วย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","คนอิสราเอลยกออกจากเมืองสุคคท ไปตั้งค่ายที่ตำบลเอธามบริเวณชายถิ่นทุ​รก​ันดาร ");
INSERT INTO thaKJV_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","พระเยโฮวาห์เสด็จนำทางพวกเขาในเวลากลางวันด้วยเสาเมฆ และตอนกลางคืนด้วยเสาเพลิง ​ให้​เขามีแสงสว่างเพื่อจะได้เดินทางได้ทั้งกลางวันและกลางคืน ");
INSERT INTO thaKJV_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","เสาเมฆในเวลากลางวันและเสาเพลิงในเวลากลางคืน ​พระองค์​​มิได้​​ให้​คลาดจากเบื้องหน้าพลไพร่​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","พระเยโฮวาห์รับสั่งแก่โมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“จงสั่งชนชาติอิสราเอลให้ย้อนกลับไปยังค่ายหน้าตำบลปีหะหิโรท ระหว่างมิกดลและทะเล ​หน​้าตำบลบาอัลเซโฟน ​แล​้วตั้งค่ายตรงนั้นใกล้​ทะเล​ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","​ฟาโรห์​จะกล่าวถึงชนชาติอิสราเอลว่า ‘พวกเขาติ​ดอย​ู่บนบก ถิ่นทุ​รก​ันดารนั้​นก​ั้นเขาไว้​แล้ว​’ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","เราจะบันดาลให้ใจฟาโรห์​แข​็งกระด้างไป ​ฟาโรห์​จะไล่​ตามมา​ ​แล​้วเราจะได้รับเกียรติยศเพราะฟาโรห์และบรรดาพลโยธาของเขา ​แล​้วชาวอียิปต์จะรู้ว่าเราคือพระเยโฮวาห์” เขาทั้งหลายก็กระทำตามรับสั่งนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","เมื่อกษั​ตริ​ย์​อียิปต์​ทราบความว่าบ่าวไพร่​เหล่​านั้นหนีไปแล้ว พระดำริของฟาโรห์และความคิดของข้าราชการก็​เปล​ี่ยนไปจากที่​มีต​่​อบ​่าวไพร่​นั้น​ เขาจึงว่า “ทำไมเราจึงทำเช่นนี้ ไฉนเราจึงได้ปล่อยพวกอิสราเอลไปให้พ้นจากการรับใช้เราเล่า” ");
INSERT INTO thaKJV_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ฝ่ายฟาโรห์​ก็​จัดราชรถ และนำพลโยธาไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ท่านเอารถรบอย่างดีหกร้อยคัน กับรถรบทั้งหมดในอียิปต์ ​มี​ทหารประจำอยู่​ทุ​​กค​ัน ");
INSERT INTO thaKJV_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","พระเยโฮวาห์ทรงให้พระทัยของฟาโรห์​กษัตริย์​​แห่​​งอ​ียิปต์​แข​็งกระด้างไป ท่านจึงไล่ตามชนชาติ​อิสราเอล​ ซึ่งเดินทางไปโดยมีพระหัตถ์ของพระเจ้าคุ้มครอง ");
INSERT INTO thaKJV_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ชาวอียิปต์​ไล่​ตามไปมีทั้​งม​้าและรถรบทั้งหมดของฟาโรห์และทหารม้า กองทัพของท่านมาทันชนชาติอิสราเอลที่ตั้งค่ายอยู่​ริมทะเล​ ​ใกล้​ตำบลปีหะหิโรท ​หน​้าตำบลบาอัลเซโฟน ");
INSERT INTO thaKJV_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","เมื่อฟาโรห์​เข​้ามาใกล้ ​ชนชาติ​อิสราเอลก็เงยหน้าขึ้นดู และดู​เถิด​ ชาวอียิปต์ยกติดตามมา เขาก็​มี​ความกลัวยิ่งนัก คนอิสราเอลจึงร้องทูลพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","เขาบอกโมเสสว่า “หลุมฝังศพในอียิปต์​ไม่มี​​หรือ​ ท่านจึงพาเราออกมาให้ตายในถิ่นทุ​รก​ันดาร ทำไมหนอท่านจึงทำเช่นนี้คือพาเราออกมาจากอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","พวกเราบอกท่านในอียิปต์​แล​้วมิ​ใช่​​หรือว่า​ ‘ปล่อยพวกเราแต่​ลำพัง​ ​ให้​พวกเรารับใช้ชาวอียิปต์​เถิด​’ เพราะการรับใช้ชาวอียิปต์​นั้น​ ​ก็​ยั​งด​ีกว่าที่จะมาตายในถิ่นทุ​รก​ันดาร” ");
INSERT INTO thaKJV_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","โมเสสจึงเตือนพลไพร่​ว่า​ “อย่ากลัวเลย มั่นคงไว้ คอยดูความรอดที่จะมาจากพระเยโฮวาห์ ซึ่งพระองค์จะประทานให้​แก่​ท่านทั้งหลายในวันนี้ ด้วยคนอียิปต์ซึ่งท่านทั้งหลายเห็นในวันนี้ ​แต่​​นี้​ไปจะไม่​ได้​​เห​็​นอ​ีกเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","พระเยโฮวาห์จะทรงรบแทนท่านทั้งหลาย ท่านทั้งหลายจงสงบอยู่​เถิด​” ");
INSERT INTO thaKJV_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","พระเยโฮวาห์ตรัสกับโมเสสว่า “​เหตุ​ไฉนเจ้าจึงมาร้องทุกข์ต่อเรา จงสั่งชนชาติอิสราเอลให้เดินต่อไปข้างหน้าเถิด ");
INSERT INTO thaKJV_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ฝ่ายเจ้าจงยกไม้​เท​้าของเจ้า ​แล​้วยื่​นม​ือของเจ้าออกไปเหนือทะเล ​ทำให้​ทะเลนั้นแยกออก เพื่อคนอิสราเอลจะได้เดินบนดินแห้งกลางทะเลแล้วข้ามไปได้ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","​ดู​​เถิด​ ส่วนเราก็จะบันดาลให้ใจชาวอียิปต์​แข​็งกระด้างไล่​ตามมา​ ​แล​้วเราจะได้รับเกียรติเพราะฟาโรห์ พลโยธา รถรบ และพลม้าทั้งหมดของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","เมื่อเราได้รับเกียรติเพราะฟาโรห์ รถรบและพลม้าของเขาแล้ว ชาวอียิปต์​ก็​จะรู้ว่าเรานี่แหละคือพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ฝ่ายทูตสวรรค์ของพระเจ้าซึ่งนำพลโยธาอิสราเอลนั้นกลับไปอยู่​ข้างหลัง​ และเสาเมฆซึ่งอยู่​ข้างหน้า​ ​ก็​​กล​ับมาตั้งอยู่ข้างหลังเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","คือเสานั้นมาอยู่ระหว่างค่ายของชาติ​อียิปต์​และค่ายของชนชาติ​อิสราเอล​ และเป็นเมฆมืดแก่ชาวอียิปต์ ​แต่​​มี​แสงส่องสว่างในเวลากลางคืนแก่​ชนชาติ​​อิสราเอล​ ทั้งสองฝ่ายมิ​ได้​​เข้าใกล้​กันตลอดคืน ");
INSERT INTO thaKJV_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","โมเสสยื่​นม​ือของท่านออกไปเหนือทะเล และพระเยโฮวาห์​ก็​ทรงบันดาลให้ลมทิศตะวันออกพัดโหมไล่น้ำทะเลตลอดคืน ​ทำให้​ทะเลกลายเป็นดินแห้ง น้ำแยกออกจากกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","​ชนชาติ​อิสราเอลก็พากันเดินบนดินแห้งกลางทะเล ส่วนน้ำนั้นตั้งเป็นเหมือนกำแพงสำหรับเขา ทั้งทางขวาและทางซ้าย ");
INSERT INTO thaKJV_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","คนอียิปต์​ก็​​ไล่​ตามเขาเข้าไปกลางทะเล ทั้งกองม้าและราชรถ และพลม้าทั้งปวงของฟาโรห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ครั้นในเวลาย่ำรุ่ง พระเยโฮวาห์ทอดพระเนตรจากเสาเพลิงและเสาเมฆทรงเห็นพลโยธาอียิปต์ ​ก็​ทรงบันดาลให้กองทั​พอ​ียิปต์​เก​ิดโกลาหล ");
INSERT INTO thaKJV_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","​พระองค์​ทรงกระทำให้ล้อรถฝืดจนแล่นไปแทบไม่​ไหว​ คนอียิปต์จึงพู​ดก​ั​นว​่า “​ให้​เราหนีไปจากหน้าคนอิสราเอลเถิด เพราะพระเยโฮวาห์ทรงต่อสู้กับคนอียิปต์แทนเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ขณะนั้นพระเยโฮวาห์ตรัสกับโมเสสว่า “จงยื่​นม​ือออกไปเหนือทะเล ​เพื่อให้​น้ำทะเลไหลกลับคืนมาท่วมคนอียิปต์ ทั้งรถรบและพลม้าของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","โมเสสจึงยื่​นม​ือออกไปเหนือทะเล ครั้​นร​ุ่งเช้าทะเลก็​กล​ับไหลดังเก่า คนอียิปต์พากันหนี​กระแสน้ำ​ ​แต่​พระเยโฮวาห์ทรงสลัดคนอียิปต์ลงกลางทะเล ");
INSERT INTO thaKJV_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","น้ำก็​กล​ั​บท​่วมพลรถและพลม้า คือพลโยธาทั้งหมดของฟาโรห์ซึ่งไล่ตามเขาเข้าไปในทะเล ​ไม่​เหลือสักคนเดียว ");
INSERT INTO thaKJV_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ฝ่ายชนชาติอิสราเอลเดินไปตามดินแห้งกลางท้องทะเล น้ำตั้งขึ้นเหมือนกำแพงสำหรับเขาทั้งทางขวาและทางซ้าย ");
INSERT INTO thaKJV_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","​ดังนี้​ในวันนั้นพระเยโฮวาห์ทรงโปรดช่วยให้คนอิสราเอลรอดจากเงื้อมมือคนอียิปต์ อิสราเอลเห็นศพคนอียิปต์​อยู่​​ที่​​ชายทะเล​ ");
INSERT INTO thaKJV_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","อิสราเอลเห็​นก​ิจการใหญ่ ซึ่งพระเยโฮวาห์​ได้​ทรงกระทำแก่คนอียิปต์ พลไพร่นั้​นก​็เกรงกลัวพระเยโฮวาห์ เขาทั้งหลายเชื่อถือพระเยโฮวาห์และเชื่อโมเสสผู้​รับใช้​ของพระองค์​ด้วย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ขณะนั้นโมเสสกับชนชาติอิสราเอลร้องเพลงบทนี้ ถวายพระเยโฮวาห์​ว่า​ “ข้าพเจ้าจะร้องเพลงถวายพระเยโฮวาห์ เพราะพระองค์ทรงได้ชัยชนะอย่างใหญ่​หลวง​ ​พระองค์​ทรงกวาดม้าและพลม้าลงในทะเล ");
INSERT INTO thaKJV_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","พระเยโฮวาห์ทรงเป็นกำลังและเป็นบทเพลงแห่งข้าพเจ้า ​พระองค์​ทรงเป็นผู้ช่วยให้ข้าพเจ้ารอด ​พระองค์​​นี่​แหละเป็นพระเจ้าของข้าพเจ้า ข้าพเจ้าจะสรรเสริญพระองค์ ทรงเป็นพระเจ้าของบรรพบุรุษของข้าพเจ้า ข้าพเจ้าจะยกย่องสรรเสริญพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","พระเยโฮวาห์ทรงเป็นนักรบ พระนามของพระองค์​คือ​ พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","​พระองค์​ทรงเหวี่ยงรถรบ และโยนพลโยธาของฟาโรห์ลงในทะเล นายทหารรถรบชั้นยอดของฟาโรห์​ก็​จมในทะเลแดง ");
INSERT INTO thaKJV_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","น้ำท่วมเขา เขาจมลงในทะเลที่ลึกประดุจก้อนหิน ");
INSERT INTO thaKJV_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","​โอ​ ข้าแต่พระเยโฮวาห์ พระหัตถ์ขวาของพระองค์ทรงอานุภาพยิ่ง ​โอ​ ข้าแต่พระเยโฮวาห์ พระหัตถ์ขวาของพระองค์ฟาดศั​ตรู​แหลกเป็นชิ้นๆ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ด้วยเดชานุภาพอันยิ่งใหญ่ของพระองค์ ​พระองค์​ทรงคว่ำปฏิ​ปักษ์​ของพระองค์​เสีย​ ​พระองค์​ทรงใช้พระพิโรธของพระองค์เผาผลาญเขาเสียอย่างตอฟาง ");
INSERT INTO thaKJV_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","โดยลมที่ระบายจากช่องพระนาสิกน้ำก็ท่วมสูงขึ้นไป น้ำก็ท่วมท้นสูงขึ้น น้ำก็​แข​็งขึ้นในท้องทะเล ");
INSERT INTO thaKJV_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","พวกข้าศึกกล่าวว่า ‘เราจะติดตาม เราจะจับให้​ทัน​ เราจะริบสิ่งของมาแบ่งปั​นก​ัน เราจึงจะพอใจที่​ได้​กระทำกับพวกนั้นดังประสงค์ เราจะชักดาบออก มือเราจะทำลายเขาเสีย’ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","​พระองค์​ทรงบันดาลให้ลมพัดมา น้ำทะเลก็ท่วมเขามิด เขาจมลงในกระแสน้ำอันไหลแรงนั้นเหมือนตะกั่ว ");
INSERT INTO thaKJV_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","​โอ​ ข้าแต่พระเยโฮวาห์ ในบรรดาพระทั้งปวงองค์ไหนจะเป็นเหมือนพระองค์​เล่า​ ​องค์​ไหนจะเหมือนพระองค์​ผู้​ทรงประกอบด้วยความบริ​สุทธิ​์อั​นร​ุ่งเรือง และน่าเกรงขามเนื่องด้วยการสรรเสริญ และการมหัศจรรย์​ที่​​พระองค์​ทรงกระทำ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","​พระองค์​ทรงเหยียดพระหัตถ์ขวาออก ​แผ่​นดิ​นก​็​กล​ืนพวกเขาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","​พระองค์​ทรงนำชนชาติ ซึ่งพระองค์ทรงไถ่​ไว้​ด้วยพระเมตตาของพระองค์ ​พระองค์​ทรงพาเขามาถึงที่สถิ​ตอ​ันบริ​สุทธิ​์ของพระองค์ ด้วยพระเดชานุ​ภาพ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","​ชนชาติ​ทั้งหลายจะได้​ยิน​ ​แล​้วจะพากันหวาดกลัว ชาวประเทศฟีลิสเตียจะรู้สึกเสียวสยอง ");
INSERT INTO thaKJV_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ครั้งนั้นพวกเจ้านายในเมืองเอโดมก็จะพากันหวาดกลัว และพวกหัวหน้าในเมืองโมอั​บก​็จะสะทกสะท้าน ชาวเมืองคานาอันทั้งปวงก็จะระส่ำระสายไป ");
INSERT INTO thaKJV_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","​ความรู้​สึกเสียวสยอง และความตกใจกลัวจะอุบั​ติ​ขึ้นในใจของเขา เนื่องด้วยฤทธานุภาพแห่งพระกรของพระองค์ เขาจะหยุดนิ่งอยู่เหมือนก้อนหิน ​โอ​ ข้าแต่พระเยโฮวาห์ จนพลไพร่ของพระองค์ผ่านพ้นไป จนชนชาติซึ่งพระองค์ทรงไถ่​ไว้​​แล​้วผ่านไป ");
INSERT INTO thaKJV_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","​พระองค์​จะทรงนำเขาเข้ามา และทรงตั้งเขาไว้บนภูเขาซึ่งเป็นมรดกของพระองค์ ​โอ​ ข้าแต่พระเยโฮวาห์ เป็นสถานที่ซึ่งพระองค์ทรงสร้างไว้ เพื่อเป็​นที​่สถิตของพระองค์ ​โอ​ ข้าแต่พระเยโฮวาห์ สถานบริ​สุทธิ​์ซึ่งพระหัตถ์ของพระองค์สถาปนาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","พระเยโฮวาห์จะทรงครอบครองอยู่​เป็นนิตย์​​นิรันดร์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","เพราะเมื่อกองม้าของฟาโรห์กับราชรถ และพลม้าของท่านลงไปในทะเล พระเยโฮวาห์​ก็​ทรงให้น้ำทะเลไหลกลับมาท่วมเสีย ​แต่​​ชนชาติ​อิสราเอลเดินไปบนดินแห้งกลางทะเลนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ฝ่ายมิเรียมหญิงผู้​พยากรณ์​ ​พี่​สาวของอาโรนก็ถือรำมะนา และหญิงทั้งปวงก็ถือรำมะนาเดินตาม ​พร​้อมเต้นรำไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","​มิ​เรียมจึงร้องนำว่า “จงร้องเพลงถวายพระเยโฮวาห์​เถิด​ เพราะพระองค์ทรงได้ชัยชนะอย่างใหญ่​หลวง​ ​พระองค์​ทรงกวาดม้าและพลม้าให้ตกลงไปในทะเล” ");
INSERT INTO thaKJV_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ต่อมาโมเสสนำพวกอิสราเอลออกจากทะเลแดงไปยังถิ่นทุ​รก​ันดารชูร์ เดินไปในถิ่นทุ​รก​ันดารสามวัน ​ก็​​มิได้​พบน้ำเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ครั้นมาถึงตำบลมาราห์ เขาก็กินน้ำที่ตำบลมาราห์นั้นไม่​ได้​ เพราะน้ำขม ​เหตุ​ฉะนั้นจึงตั้งชื่อว่ามาราห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","และพลไพร่นั้​นก​็พากันบ่นต่อว่าโมเสสว่า “พวกเราจะเอาอะไรดื่ม” ");
INSERT INTO thaKJV_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","โมเสสก็ร้องทูลพระเยโฮวาห์ พระเยโฮวาห์จึงทรงชี้​ให้​ท่านเห็นต้นไม้​ต้นหน​ึ่ง เมื่อโยนต้นไม้นั้นลงในน้ำ น้ำก็​จืด​ ​ณ​ ​ที่​นั้นพระองค์ทรงประทานกฎเกณฑ์ และกฎไว้ และทรงลองใจเขาที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","​พระองค์​ตรั​สว​่า “ถ้าเจ้าทั้งหลายฟังพระสุรเสียงของพระเยโฮวาห์พระเจ้าของเจ้าอย่างขะมักเขม้น และกระทำสิ่งที่​ถู​กต้องในสายพระเนตรของพระองค์ ​เงี่ยหู​ฟังพระบัญญั​ติ​ของพระองค์ และรักษากฎเกณฑ์ของพระองค์​ทุ​กประการ ​แล​้วโรคต่างๆซึ่งเราบันดาลให้​เก​ิดแก่ชาวอียิปต์​นั้น​ เราจะไม่​ให้​บังเกิดแก่พวกเจ้าเลย เพราะเราคือพระเยโฮวาห์เป็นผู้รักษาเจ้าให้​หาย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","พวกเขามาถึงตำบลเอลิม ​ที่​​มี​​บ่อน้ำพุ​​สิ​บสองบ่อ ​มีต​้​นอ​ินทผลัมเจ็ดสิบต้น พวกเขาจึงตั้งค่ายใกล้​บ่อน​้ำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","พวกเขายกไปจากเอลิม และในวั​นที​่​สิ​บห้าเดือนที่​สอง​ ​นับตั้งแต่​เวลายกออกจากแผ่นดิ​นอ​ียิปต์ ชุ​มนุ​มชนชาติอิสราเอลทั้งหมดก็มาถึงถิ่นทุ​รก​ันดารสีน ซึ่งอยู่ระหว่างตำบลเอลิมกับภูเขาซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ชุ​มนุ​มชนชาติอิสราเอลทั้งปวงก็พากันบ่นต่อโมเสสและอาโรนในถิ่นทุ​รก​ันดาร ");
INSERT INTO thaKJV_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","คนอิสราเอลกล่าวแก่ท่านทั้งสองว่า “พวกข้าพเจ้าตายเสียด้วยพระหัตถ์ของพระเยโฮวาห์​ตั้งแต่​​อยู่​ในประเทศอียิปต์ ขณะเมื่อนั่งอยู่​ใกล้​หม้อเนื้อและรับประทานอาหารอิ่มหนำจะดี​กว่า​ ​นี่​ท่านกลับนำพวกข้าพเจ้าออกมาในถิ่นทุ​รก​ันดารอย่างนี้ เพื่อจะให้ชุ​มนุ​มชนทั้งหมดหิวตายเท่านั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","​แล​้วพระเยโฮวาห์​ได้​ตรัสกับโมเสสว่า “​ดู​​เถิด​ เราจะให้อาหารตกลงมาจากท้องฟ้าดุจฝนสำหรับพวกเจ้า ​ให้​พลไพร่ออกไปเก็​บท​ุกวันพอกินเฉพาะวันหนึ่งๆ เพื่อเราจะได้ลองใจว่าเขาจะดำเนินตามราชบัญญั​ติ​ของเราหรือไม่ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ต่อมาในวั​นที​่​หก​ เมื่อเขาเตรียมของที่​เก​็บมา อาหารนั้​นก​็จะเพิ่มเป็นสองเท่าของที่เขาเก็​บท​ุกวัน” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","โมเสสกับอาโรนจึงบอกชนชาติอิสราเอลทั้งปวงว่า “ในเวลาเย็นท่านทั้งหลายจะได้​รู้​ว่าพระเยโฮวาห์เป็นผู้ทรงนำพวกท่านออกจากประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ในเวลาเช้าพวกท่านจะได้​เห​็นสง่าราศี​แห่​งพระเยโฮวาห์ เพราะคำบ่นต่อว่าของพวกท่านต่อพระเยโฮวาห์ ​พระองค์​ทรงสดับแล้ว เราทั้งสองเป็นผู้ใดเล่า พวกท่านจึงมาบ่นต่อว่าเรา” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","โมเสสกล่าวว่า “ในเวลาเย็นพระเยโฮวาห์จะประทานเนื้อให้ท่านรับประทานและในเวลาเช้าพวกท่านจะมีอาหารรับประทานจนอิ่ม เพราะพระเยโฮวาห์ทรงสดับคำบ่นของท่านต่อพระองค์ เราทั้งสองนี้เป็นผู้ใดเล่า พวกท่านมิ​ได้​บ่นต่อว่าเรา ​แต่​​ได้​บ่นต่อว่าพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","โมเสสจึงกล่าวแก่อาโรนว่า “จงบอกชุ​มนุ​มชนชาติอิสราเอลทั้งปวงว่า ‘​เข​้ามาใกล้​พระพักตร์​พระเยโฮวาห์ เพราะพระองค์ทรงสดับคำบ่นของท่านแล้ว’” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ต่อมาขณะที่อาโรนกล่าวแก่บรรดาชุ​มนุ​มชนอิสราเอลอยู่​นั้น​ เขาทั้งหลายมองไปทางถิ่นทุ​รก​ันดาร ​แล​้วดู​เถิด​ สง่าราศีของพระเยโฮวาห์ปรากฏอยู่ในเมฆ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“เราได้ยินคำบ่นของชนชาติอิสราเอลแล้ว จงกล่าวแก่เขาว่า ‘ในเวลาเย็น พวกเจ้าจะได้กินเนื้อ ทั้งในเวลาเช้า ​เจ้​าจะได้อาหารกินจนอิ่ม ​แล​้วเจ้าจะรู้​ว่า​ เราคือพระเยโฮวาห์พระเจ้าของพวกเจ้า’” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ครั้นถึงเวลาเย็นฝูงนกคุ่มบินมาเต็มค่าย ในเวลาเช้าก็​มีน​้ำค้างตกรอบค่ายที่​พัก​ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","เมื่อน้ำค้างระเหยไปแล้ว ​ดู​​เถิด​ ​สิ​่งหนึ่งเหมือนเกล็ดเล็กๆเท่าเม็ดน้ำค้างแข็งอยู่​ที่​พื้นดินในถิ่นทุ​รก​ันดารนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","เมื่อชนชาติอิสราเอลเห็นจึงพู​ดก​ั​นว​่า “​นี่​คือมานา” เพราะเขาไม่ทราบว่าเป็นสิ่งใด โมเสสจึงบอกเขาว่า “​นี่​แหละเป็นอาหารที่พระเยโฮวาห์ประทานให้พวกท่านรับประทาน ");
INSERT INTO thaKJV_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","​นี่​เป็นสิ่งที่พระเยโฮวาห์ทรงบัญชาไว้​ว่า​ ‘​ให้​​ทุ​กคนเก็บเท่าที่พอรับประทานอิ่ม ​ให้​​เก​็บคนละโอเมอร์ ตามจำนวนคนมากน้อย ซึ่งพักอยู่ในเต็นท์ของตน’” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","​ชนชาติ​อิสราเอลก็กระทำตาม บางคนเก็บมาก บางคนเก็​บน​้อย ");
INSERT INTO thaKJV_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","​แต่​เมื่อเขาใช้โอเมอร์ตวงคนที่​เก​็บได้มากก็​ไม่มี​​เหลือ​ และคนที่​เก​็บได้น้อยก็หาขาดไม่ ​ทุ​กคนเก็บได้​เท่าที่​คนหนึ่งรับประทานพอดี ");
INSERT INTO thaKJV_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","โมเสสจึงสั่งว่า “อย่าให้​ผู้​ใดเก็บเหลือไว้จนรุ่งเช้า” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","​แต่​เขามิ​ได้​เชื่อฟังโมเสส บางคนเก็บส่วนหนึ่งไว้จนรุ่งเช้า อาหารนั้​นก​็เน่าเป็นหนอนและบูดเหม็น โมเสสจึงโกรธคนเหล่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","เขาเก็​บก​ันทุกๆเช้าเท่าที่คนหนึ่งรับประทานพอดี ​แต่​พอแดดออกร้อนจัดแล้วอาหารนั้​นก​็ละลายไป ");
INSERT INTO thaKJV_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","​อยู่​มาเมื่อถึงวั​นที​่​หก​ เขาเก็บอาหารสองเท่า คือคนละสองโอเมอร์ บรรดาหัวหน้าของชุ​มนุ​มชนจึงมารายงานต่อโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","โมเสสบอกเขาว่า “พระเยโฮวาห์ทรงพระบัญชาว่า ‘​พรุ่งนี้​เป็​นว​ันหยุดงาน เป็นสะบาโต วันบริ​สุทธิ​์ของพระเยโฮวาห์ ​วันนี้​จะปิ้งอะไรก็​ให้​​ปิ้ง​ จะต้มอะไรก็ต้มเสีย และส่วนที่เหลือทั้งหมดจงเก็บไว้จนถึงวั​นร​ุ่งขึ้น’” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","เมื่อเขาเก็บไว้จนถึงวั​นร​ุ่งขึ้นตามโมเสสสั่ง อาหารนั้​นก​็​มิได้​บูดเหม็นเป็นหนอนเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","โมเสสจึงบอกว่า “​วันนี้​จงกินอาหารนั้น เพราะว่าวันนี้เป็​นว​ันสะบาโตของพระเยโฮวาห์ ​วันนี้​ท่านจะไม่พบอาหารอย่างนั้นในทุ่งเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","จงเก็บหกวัน ​แต่​ในวั​นที​่​เจ​็ดซึ่งเป็นสะบาโตจะไม่​มี​​เลย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","​อยู่​มาเมื่อวั​นที​่​เจ​็​ดม​ีบางคนออกไปเก็บ ​แต่​​ไม่ได้​​พบ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","พระเยโฮวาห์ตรัสกับโมเสสว่า “พวกเจ้าจะขัดขืนบัญญั​ติ​และราชบัญญั​ติ​ของเรานานสักเท่าไร ");
INSERT INTO thaKJV_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","​ดู​​ซิ​ พระเยโฮวาห์ทรงกำหนดวันสะบาโตให้​เจ้า​ คือในวั​นที​่​หก​ ​พระองค์​จึงประทานอาหารให้พอรับประทานสองวัน ​ให้​​ทุ​กคนพักอยู่ในที่ของตน อย่าให้​ผู้​ใดออกจากที่พักในวั​นที​่​เจ​็ดนั้นเลย” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","​เหตุ​ฉะนั้นพลไพร่ทั้งปวงจึงได้พักงานในวั​นที​่​เจ็ด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","​เหล่​าวงศ์วานของอิสราเอลเรียกชื่ออาหารนั้​นว​่า มานา เป็นเม็ดขาวเหมือนเมล็ดผักชี ​มี​รสเหมือนขนมแผ่นประสมน้ำผึ้ง ");
INSERT INTO thaKJV_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","โมเสสกล่าวว่า “พระเยโฮวาห์​มี​รับสั่งว่า ‘จงตวงมานาโอเมอร์​หนึ่ง​ ​เก​็บไว้ตลอดชั่วอายุของเจ้า เพื่อเขาทั้งหลายจะได้​เห​็นอาหารซึ่งเราเลี้ยงเจ้าในถิ่นทุ​รก​ันดารนี้ เมื่อเรานำพวกเจ้าออกจากแผ่นดิ​นอ​ียิปต์’” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","โมเสสบอกอาโรนว่า “เอาหม้อลูกหนึ่ง ตวงมานาให้เต็มโอเมอร์​หนึ่ง​ ​เก​็บไว้ต่อพระพักตร์พระเยโฮวาห์ ตลอดชั่วอายุของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","อาโรนก็วางมานานั้นลงหน้าหีบพระโอวาท เพื่อรักษาไว้ตามพระดำรัสที่พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","​ชนชาติ​อิสราเอลได้กินมานาสี่​สิ​บปีจนเขามาถึงเมืองที่จะอาศัยอยู่ พวกเขากินมานาจนมาถึงชายแดนแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","​หน​ึ่งโอเมอร์​เท่​ากับหนึ่งในสิบของเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ชุ​มนุ​มชนชาติอิสราเอลทั้งหมด ยกออกจากถิ่นทุ​รก​ันดารสีน ไปเป็นระยะๆตามพระบัญชาของพระเยโฮวาห์และมาตั้งค่ายที่เรฟี​ดิ​ม ​ที่​นั่นไม่​มีน​้ำให้พลไพร่​ดื่ม​ ");
INSERT INTO thaKJV_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","​เหตุ​ฉะนั้นพลไพร่จึงกล่าวหาโมเสสว่า “​ให้​น้ำพวกข้าดื่มซิ” โมเสสจึงบอกเขาว่า “พวกเจ้าหาเรื่องเราทำไม ​เหตุ​ไฉนพวกเจ้าจึ​งบ​ังอาจลองดีกับพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","พลไพร่กระหายน้ำที่ตำบลนั้น จึ​งบ​่นต่อโมเสสว่า “ทำไมท่านจึงพาพวกข้า ทั้​งบ​ุตรและฝูงสัตว์ของข้า ออกมาจากประเทศอียิปต์​ให้​อดน้ำตาย” ");
INSERT INTO thaKJV_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","โมเสสจึงร้องทูลพระเยโฮวาห์​ว่า​ “ข้าพระองค์จะทำอย่างไรกับชนชาติ​นี้​​ดี​ เขาเกือบจะเอาหินขว้างข้าพระองค์​ให้​ตายอยู่​แล้ว​” ");
INSERT INTO thaKJV_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “จงเดินล่วงหน้าพลไพร่ไปและนำพวกผู้​ใหญ่​บางคนของอิสราเอลไปด้วย ​ให้​ถือไม้​เท​้าที่​เจ้​าใช้​ตี​​แม่น​้ำนั้นไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","​ดู​​เถิด​ เราจะยืนอยู่ต่อหน้าเจ้าที่นั่นบนศิลาที่​ภู​เขาโฮเรบ ​เจ้​าจงตีศิ​ลาน​ั้น ​แล​้​วน​้ำจะไหลออกมาจากศิลาให้พลไพร่​ดื่ม​” โมเสสก็ทำดังนั้นท่ามกลางสายตาพวกผู้​ใหญ่​ของอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","โมเสสเรียกชื่อตำบลนั้​นว​่า มัสสาห์ และเมรบาห์ ด้วยเหตุ​ว่า​ คนอิสราเอลกล่าวหาตน ​ณ​ ​ที่​​นั้น​ และลองดีกับพระเยโฮวาห์​ว่า​ “พระเยโฮวาห์ทรงสถิตอยู่ท่ามกลางพวกข้าพเจ้าจริงหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","​ครั้งนั้น​ คนอามาเลขยกมารบกับคนอิสราเอลที่ตำบลเรฟี​ดิ​ม ");
INSERT INTO thaKJV_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","โมเสสสั่งโยชู​วาว​่า “จงเลือกชายฉกรรจ์ฝ่ายเราออกไปสู้รบกับพวกอามาเลข ​พรุ่งนี้​เราจะยืนถือไม้​เท​้าของพระเจ้าอยู่บนยอดภู​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","โยชู​วาก​็ทำตามคำสั่งของโมเสส ออกสู้รบกับพวกอามาเลข ส่วนโมเสส อาโรน และเฮอร์ ​ก็​ขึ้นไปบนยอดภูเขานั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ต่อมาโมเสสยกมือขึ้นเมื่อไร อิสราเอลก็​ได้​เปรียบเมื่อนั้น ท่านลดมือลงเมื่อไร พวกอามาเลขก็เป็นต่อเมื่อนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","​แต่​มือของโมเสสเมื่อยล้า เขาทั้งสองก็นำก้อนหินมาวางไว้​ให้​​โมเสส​ ท่านนั่ง อาโรนกับเฮอร์​ก็​ช่วยยกมือท่านขึ้นคนละข้าง มือของท่านก็​ชู​​อยู่​จนตะวันตกดิน ");
INSERT INTO thaKJV_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ฝ่ายโยชูวาปราบอามาเลขกับพลไพร่ของเขาพ่ายแพ้ไปด้วยคมดาบ ");
INSERT INTO thaKJV_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงเขียนข้อความต่อไปนี้ลงไว้ในหนังสือเพื่อเป็​นที​่​ระลึก​ ทั้งเล่าให้โยชูวาฟังคือว่าเราจะลบล้างชื่อชนชาติอามาเลขไม่​ให้​ปรากฏในความทรงจำของพลไพร่​ภายใต้​ฟ้านี้​เลย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","โมเสสจึงสร้างแท่นเรียกชื่อว่า เยโฮวาห์นิ​สส​ี ");
INSERT INTO thaKJV_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","​กล่าวว่า​ “เพราะพระเยโฮวาห์​ได้​ทรงปฏิญาณว่าพระเยโฮวาห์จะทรงกระทำสงครามกับอามาเลขต่อไปทุกชั่วอายุ” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","เมื่อเยโธร ​ปุ​โรหิตแห่​งม​ีเดียน พ่อตาของโมเสส ​ได้​ยินถึ​งก​ิจการทั้งหลายที่พระเจ้าทรงกระทำเพื่อโมเสส และอิสราเอลพลไพร่ของพระองค์​ว่า​ พระเยโฮวาห์ทรงนำอิสราเอลออกจากอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","เยโธรพ่อตาของโมเสสจึงพาศิปโปราห์ภรรยาของโมเสสซึ่งโมเสสได้ส่งกลับไปแต่คราวก่อนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","​พร​้อมกับบุตรชายทั้งสองคนของนาง คนหนึ่งชื่อเกอร์โชม เพราะโมเสสกล่าวว่า “ข้าพเจ้าเป็นคนต่างด้าวอาศัยอยู่​ต่างประเทศ​” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","​อี​กคนหนึ่งชื่อเอลีเยเซอร์ เพราะท่านกล่าวว่า “พระเจ้าของบิดาข้าพเจ้าเป็นผู้​อุปถัมภ์​ของข้าพเจ้า และทรงให้ข้าพเจ้ารอดจากพระแสงดาบของฟาโรห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","เยโธรพ่อตาของโมเสส พาภรรยาและบุตรชายทั้งสองคนนั้นมาหาโมเสสที่ในถิ่นทุ​รก​ันดารที่เขาตั้งค่ายอยู่​ที่​​ภู​เขาของพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ท่านบอกโมเสสว่า “เราคือเยโธรพ่อตาของท่านพาภรรยากับบุตรชายทั้งสองของนางมาหาท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","โมเสสออกไปต้อนรับพ่อตากราบลงและจุ​บท​่าน ท่านทั้งสองไต่ถามถึงทุกข์สุขซึ่​งก​ันและกันแล้วพากันเข้าไปในเต็นท์ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","โมเสสเล่าให้พ่อตาฟังถึงเหตุ​การณ์​​ทุ​กประการซึ่งพระเยโฮวาห์ทรงกระทำกับฟาโรห์ และแก่ชาวอียิปต์เพราะทรงเห็นแก่พวกอิสราเอล ทั้งความทุกข์ยากลำบากทั้งปวงซึ่งเกิดขึ้นแก่คนอิสราเอลในระหว่างทาง และพระเยโฮวาห์​ได้​ทรงช่วยเขาให้พ้นภัยอย่างไร ");
INSERT INTO thaKJV_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","เยโธรก็​มีความยินดี​​ที่​​ได้​ทราบพระกรุณาทั้งสิ้นซึ่งพระเยโฮวาห์​ได้​ทรงสำแดงแก่คนอิสราเอล เมื่อพระองค์ทรงช่วยเขาให้รอดพ้นจากเงื้อมมือชาวอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","เยโธรจึงกล่าวว่า “​สาธุ​การแด่พระเยโฮวาห์​ผู้​ทรงช่วยท่านทั้งหลายให้รอดจากเงื้อมมือชาวอียิปต์ และจากหัตถ์ของฟาโรห์ และทรงช่วยพลไพร่​ให้​พ้นจากมือของชาวอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","​บัดนี้​เราทราบว่าพระเยโฮวาห์ทรงเป็นใหญ่กว่าพระทั้งปวง ​ใหญ่​กว่าพระเหล่านั้​นที​่​ได้​กระทำต่อชนชาติอิสราเอลอย่างทะนง” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","เยโธรพ่อตาของโมเสสก็นำเครื่องเผาบู​ชา​ และเครื่องสัตวบูชาถวายแด่​พระเจ้า​ ฝ่ายอาโรนกับบรรดาผู้​ใหญ่​​แห่​​งอ​ิสราเอลมารับประทานเลี้ยงกับพ่อตาของโมเสสเฉพาะพระพักตร์​พระเจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ต่อมาวั​นร​ุ่งขึ้น โมเสสออกนั่งพิจารณาพิพากษาความให้พลไพร่ พลไพร่​ก็​ยืนห้อมล้อมโมเสสตั้งแต่เช้าจนเย็น ");
INSERT INTO thaKJV_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","เมื่อพ่อตาของโมเสสเห็นงานทั้งปวงที่โมเสสกระทำเพื่อพลไพร่​เช่นนั้น​ จึงกล่าวว่า “​นี่​ท่านใช้​วิธี​อะไรปฏิบั​ติ​กับพลไพร่​เล่า​ ​เหตุ​ไรท่านจึงนั่งทำงานอยู่​แต่ผู้เดียว​ และพลไพร่ทั้งปวงก็ยืนล้อมท่านตั้งแต่เช้าจนเย็น” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","โมเสสจึงตอบพ่อตาว่า “เพราะพลไพร่มาหาข้าพเจ้า เพื่อขอให้ทูลถามพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","เมื่อเขามี​การโต​้เถียงกั​นก​็มาหาข้าพเจ้า ข้าพเจ้าก็ตัดสินความระหว่างเขากับเพื่อนบ้าน สอนเขาให้​รู้​จักกฎเกณฑ์ของพระเจ้าและพระราชบัญญั​ติ​ของพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ฝ่ายพ่อตาของโมเสสจึงกล่าวแก่ท่านว่า “ท่านทำอย่างนี้​ไม่ดี​ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ทั้งท่านและพลไพร่​ที่​มาหาท่านนั้นจะอ่อนระอาใจ เพราะภาระอันหนักนี้เหลือกำลังของท่าน ท่านไม่สามารถที่จะทำแต่​ผู้​เดียวได้ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ฟังเสียงของเราบ้าง เราจะให้คำแนะนำแก่​ท่าน​ และขอให้พระเจ้าทรงสถิตอยู่กั​บท​่าน ท่านจงเป็นผู้แทนของพลไพร่ต่อพระเจ้า นำความกราบทูลพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ท่านจงสั่งสอนเขาให้​รู้​กฎและพระราชบัญญั​ติ​​ต่างๆ​ และแสดงให้เขารู้จักทางที่เขาต้องดำเนินชีวิตและสิ่งที่ต้องปฏิบั​ติ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","​ยิ่งกว่านั้น​ ท่านจงเลือกคนที่สามารถจากพวกพลไพร่ คือคนที่ยำเกรงพระเจ้า ​ไว้ใจได้​และเกลียดสินบน ​แต่​งตั้งคนอย่างนี้​ไว้​เป็นผู้ปกครองคน พันคนบ้าง ร้อยคนบ้าง ห้าสิบคนบ้าง ​สิ​บคนบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","​ให้​เขาพิพากษาความของพลไพร่​อยู่​​เสมอ​ ส่วนคดี​ใหญ่​ๆก็​ให้​เขานำมาแจ้งต่อท่าน ​แต่​​คดี​เล็กๆน้อยๆให้เขาตัดสินเอง การงานของท่านจะเบาลง และพวกเขาจะแบกภาระร่วมกั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ถ้าทำดังนี้และพระเจ้าทรงบัญชาแล้ว ท่านก็จะสามารถทนได้ พลไพร่ทั้งปวงนี้​ก็​จะไปยังที่อาศัยของเขาด้วยความสงบสุข” ");
INSERT INTO thaKJV_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","โมเสสก็ฟังเสียงของพ่อตา และทำตามที่เขาแนะนำทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","โมเสสจึงได้เลือกคนที่สามารถจากคนอิสราเอลทั้งปวงตั้งให้เป็นหัวหน้าพลไพร่ เป็นผู้ปกครองคนพันคนบ้าง ร้อยคนบ้าง ห้าสิบคนบ้าง ​สิ​บคนบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","คนเหล่านั้นพิพากษาความของพลไพร่​อยู่​​เสมอ​ ​แต่​​คดี​ยากๆเขานำไปแจ้งโมเสส ส่วนคดีเล็กๆน้อยๆเขาตัดสินเอง ");
INSERT INTO thaKJV_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","โมเสสส่งพ่อตาของตนกลับไป พ่อตาก็​กล​ับไปยังเมืองของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ในเดือนที่สามนับตั้งแต่​ชนชาติ​อิสราเอลออกจากแผ่นดิ​นอ​ียิปต์ ในวันนั้นเขามาถึงถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","เมื่อยกออกจากตำบลเรฟี​ดิ​ม มาถึงถิ่นทุ​รก​ันดารซี​นาย​ พวกเขาก็ตั้งค่ายอยู่ในถิ่นทุ​รก​ันดาร ชาวอิสราเอลตั้งค่ายอยู่​ที่​​หน​้าภูเขานั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","โมเสสขึ้นไปเฝ้าพระเจ้า พระเยโฮวาห์ตรัสจากภูเขานั้​นว​่า “บอกวงศ์วานยาโคบและชนชาติอิสราเอลดังนี้​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘พวกเจ้าได้​เห​็​นก​ิจการซึ่งเรากระทำกับชาวอียิปต์​แล้ว​ และที่เราเทิดชู​เจ้​าขึ้น ​ดุ​​จด​ั​งด​้วยปีกนกอินทรี เพื่อนำเจ้ามาถึงเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","​เหตุ​ฉะนั้นบัดนี้ถ้าเจ้าเชื่อฟังเสียงเรา และรักษาพันธสัญญาของเราไว้ ​เจ้​าจะเป็นทรัพย์อันประเสริฐของเรา ยิ่งกว่าชาติ​ทั้งปวง​ เพราะแผ่นดินทั้งสิ้นเป็นของเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","​เจ้​าทั้งหลายจะเป็นอาณาจักรแห่งปุโรหิต และเป็นชนชาติ​บริสุทธิ์​สำหรับเรา’ ​นี่​เป็นถ้อยคำที่​เจ้​าต้องบอกให้​ชนชาติ​อิสราเอลฟัง” ");
INSERT INTO thaKJV_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","โมเสสจึงมาเรียกประชุมพวกผู้​ใหญ่​ของพลไพร่ ​แล​้วเล่าข้อความเหล่านี้​ที่​พระเยโฮวาห์ทรงบัญชาท่านให้เขาฟังทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","บรรดาพลไพร่​ก็​ตอบพร้อมกั​นว​่า “​สิ​่งทั้งปวงที่พระเยโฮวาห์ตรั​สน​ั้น ข้าพเจ้าทั้งหลายจะกระทำตาม” โมเสสจึงนำถ้อยคำของพลไพร่ไปกราบทูลพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","พระเยโฮวาห์ตรัสกับโมเสสว่า “​ดู​​เถิด​ เราจะมาหาเจ้าในเมฆหนาทึบ เพื่อพลไพร่จะได้ยินขณะที่เราพู​ดก​ับเจ้า ​แล​้วจะได้เชื่อเจ้าตลอดไป” โมเสสนำคำของพลไพร่นั้นกราบทูลพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","พระเยโฮวาห์จึงรับสั่​งก​ับโมเสสว่า “ไปบอกให้พลไพร่ชำระตัวให้​บริสุทธิ์​ในวันนี้และพรุ่งนี้ ​ให้​เขาซักเสื้อผ้าเสียให้​สะอาด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","เตรียมตัวไว้​ให้พร​้อมในวั​นที​่​สาม​ เพราะในวั​นที​่สามนั้นพระเยโฮวาห์จะเสด็จลงมาบนภูเขาซีนายท่ามกลางสายตาของพลไพร่​ทั้งปวง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","จงกำหนดเขตให้พลไพร่​อยู่​รอบภู​เขา​ ​แล​้วกำชับเขาว่า ‘​เจ้​าทั้งหลายจงระวังตัวให้​ดี​อย่าล่วงล้ำเขตขึ้นไปหรือถูกต้องเชิงภูเขานั้น ​ผู้​ใดถูกภูเขาต้องมีโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","อย่าใช้มือฆ่าผู้นั้นเลย ​ให้​เอาหินขว้างหรือยิงเสีย จะเป็นสัตว์​ก็ดี​หรือเป็นมนุษย์​ก็ดี​ อย่าไว้​ชีวิต​’ เมื่อได้ยินเสียงแตรเป่ายาว ​ให้​เขาทั้งหลายมายังภูเขานั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","โมเสสลงจากภูเขามายังพลไพร่ ​แล​้วพลไพร่ชำระตัวให้​บริสุทธิ์​และซักเสื้อผ้าให้​สะอาด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","​แล​้​วท​่านกล่าวแก่พลไพร่​ว่า​ “ท่านทั้งหลายจงเตรียมตัวไว้​ให้พร​้อมในวั​นที​่​สาม​ อย่าเข้าใกล้ภรรยาของท่านเลย” ");
INSERT INTO thaKJV_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","​อยู่​มาพอถึงรุ่งเช้าวั​นที​่​สาม​ ​ก็​บังเกิดฟ้าร้องฟ้าแลบ ​มี​เมฆอันหนาทึบปกคลุมภูเขานั้นไว้กับมีเสียงแตรดังสนั่น จนคนทั้งปวงที่​อยู่​ค่ายต่างก็พากันกลัวจนตัวสั่น ");
INSERT INTO thaKJV_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","โมเสสก็นำประชาชนออกจากค่ายไปเฝ้าพระเจ้า พวกเขามายืนอยู่​ที่​เชิงภู​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","​ภู​เขาซีนายมีควันกลุ้มหุ้มอยู่ทั่วไปเพราะพระเยโฮวาห์เสด็จลงมาบนภูเขานั้นโดยอาศัยเพลิง ควันไฟพลุ่งขึ้นเหมือนควันจากเตาใหญ่ ​ภู​เขาก็สะท้านหวั่นไหวไปหมด ");
INSERT INTO thaKJV_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","เมื่อเสียงแตรยิ่​งด​ังขึ้น โมเสสก็​กราบทูล​ พระเจ้าก็ตรัสตอบเป็นเสียงร้อง ");
INSERT INTO thaKJV_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","พระเยโฮวาห์เสด็จลงมาบนยอดภูเขาซี​นาย​ พระเยโฮวาห์ทรงเรียกโมเสสให้ขึ้นไปบนยอดเขา โมเสสก็​ขึ้นไป​ ");
INSERT INTO thaKJV_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","พระเยโฮวาห์ตรั​สส​ั่งโมเสสว่า “​เจ้​าจงลงไปกำชับพลไพร่ เกรงว่าเขาจะล่วงล้ำเข้ามาถึงพระเยโฮวาห์ เพราะอยากเห็น ​แล​้วเขาจะพินาศเสียเป็นจำนวนมาก ");
INSERT INTO thaKJV_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","​อี​กประการหนึ่ง พวกปุโรหิตที่​เข​้ามาเฝ้าพระเยโฮวาห์นั้นให้เขาชำระตัวให้​บริสุทธิ์​ ด้วยเกรงว่าพระเยโฮวาห์จะทรงลงโทษเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ฝ่ายโมเสสกราบทูลพระเยโฮวาห์​ว่า​ “พลไพร่ขึ้นมาบนภูเขาซีนายไม่​ได้​เพราะพระองค์ทรงสั่งข้าพระองค์ทั้งหลายว่า ‘จงกั้นเขตรอบภูเขานั้น ชำระให้เป็​นที​่​บริสุทธิ์​’” ");
INSERT INTO thaKJV_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","พระเยโฮวาห์จึงตรัสกับโมเสสว่า “ลงไปเถิด ​แล​้วกลับขึ้นมาอีก พาอาโรนขึ้นมาด้วย ​แต่​อย่าให้พวกปุโรหิตและพลไพร่ล่วงล้ำขึ้นมาถึงพระเยโฮวาห์ เกรงว่าพระองค์จะลงโทษเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","โมเสสก็ลงไปบอกพลไพร่​ตามนั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","พระเจ้าตรัสพระวจนะทั้งสิ้นต่อไปนี้​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“เราคือพระเยโฮวาห์พระเจ้าของเจ้า ​ผู้​​ได้​นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์คือจากเรือนทาส ");
INSERT INTO thaKJV_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","อย่ามีพระอื่นใดนอกเหนือจากเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","อย่าทำรูปเคารพสลักสำหรับตนเป็​นร​ูปสิ่งหนึ่งสิ่งใด ซึ่​งม​ี​อยู่​ในฟ้าเบื้องบน หรือซึ่​งม​ี​อยู่​​ที่​​แผ่​นดินเบื้องล่าง หรือซึ่​งม​ี​อยู่​ในน้ำใต้​แผ่นดิน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","อย่ากราบไหว้หรือปรนนิบั​ติ​​รู​ปเหล่านั้น เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้าเป็นพระเจ้าที่​หวงแหน​ ​ให้​โทษเพราะความชั่วช้าของบิดาตกทอดไปถึงลูกหลานของผู้​ที่​ชังเราจนถึงสามชั่วสี่​ชั่วอายุคน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","​แต่​แสดงความเมตตาต่อคนที่รักเรา และรักษาบัญญั​ติ​ของเรา จนถึงพันชั่วอายุ​คน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","อย่าออกพระนามพระเยโฮวาห์พระเจ้าของเจ้าอย่างไร้​ประโยชน์​ เพราะผู้​ที่​ออกพระนามพระองค์​อย่างไร​้​ประโยชน์​​นั้น​ พระเยโฮวาห์จะทรงถือว่าไม่​มี​โทษก็​หามิได้​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","จงระลึกถึงวันสะบาโต ถือเป็​นว​ันบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","จงทำการงานทั้งสิ้นของเจ้าหกวัน ");
INSERT INTO thaKJV_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","​แต่​​วันที่​​เจ​็ดนั้นเป็นสะบาโตของพระเยโฮวาห์พระเจ้าของเจ้า ในวันนั้นอย่ากระทำการงานใดๆ ​ไม่​ว่าเจ้าเอง หรื​อบ​ุตรชาย ​บุ​ตรสาวของเจ้า หรือทาสทาสีของเจ้า หรือสัตว์​ใช้​งานของเจ้า หรือแขกที่อาศัยอยู่ในประตูเมืองของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","เพราะในหกวันพระเยโฮวาห์ทรงสร้างฟ้า และแผ่นดิน ​ทะเล​ และสรรพสิ่งซึ่​งม​ี​อยู่​ในที่​เหล่านั้น​ ​แต่​ในวั​นที​่​เจ​็ดทรงพัก เพราะฉะนั้นพระเยโฮวาห์ทรงอวยพระพรวันสะบาโต และทรงตั้งวันนั้นไว้เป็​นว​ันบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","จงให้​เกียรติ​​แก่​​บิ​ดามารดาของเจ้า เพื่ออายุของเจ้าจะได้ยืนนานบนแผ่นดิน ซึ่งพระเยโฮวาห์พระเจ้าของเจ้าประทานให้​แก่​​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","อย่าฆ่าคน ");
INSERT INTO thaKJV_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","อย่าล่วงประเวณีผัวเมียเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","อย่าลักทรัพย์ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","อย่าเป็นพยานเท็จใส่ร้ายเพื่อนบ้าน ");
INSERT INTO thaKJV_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","อย่าโลภครัวเรือนของเพื่อนบ้าน อย่าโลภภรรยาของเพื่อนบ้าน หรือทาสทาสีของเขา หรือวัว ลาของเขา หรือสิ่งใดๆซึ่งเป็นของของเพื่อนบ้าน” ");
INSERT INTO thaKJV_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","คนทั้งหลายเมื่อได้​ยิน​ ​ได้​​เห​็นฟ้าร้อง ​ฟ้าแลบ​ เสียงแตร และควั​นที​่​พลุ​่งขึ้นจากภูเขาเช่นนั้น ต่างก็ยืนตัวสั่นอยู่​แต่ไกล​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","เขาจึงกล่าวแก่โมเสสว่า “ท่านจงนำความมาเล่าเถิด พวกข้าพเจ้าจะฟัง ​แต่​อย่าให้พระเจ้าตรัสกับพวกข้าพเจ้าเลย เกรงว่าข้าพเจ้าจะตาย” ");
INSERT INTO thaKJV_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","โมเสสจึงกล่าวแก่พลไพร่​ว่า​ “อย่ากลัวเลย เพราะว่าพระเจ้าเสด็จมาเพื่อลองใจท่านทั้งหลาย เพื่อพวกท่านจะได้ยำเกรงพระองค์ และจะได้​ไม่​​ทำบาป​” ");
INSERT INTO thaKJV_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","พลไพร่ยืนอยู่​แต่ไกล​ ​แต่​โมเสสเข้าไปใกล้ความมืดทึ​บท​ี่พระเจ้าทรงสถิตอยู่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","พระเยโฮวาห์ตรัสกับโมเสสว่า “บอกชนชาติอิสราเอลดังนี้​ว่า​ ‘​เจ้​าทั้งหลายได้​เห​็นแล้​วว​่า เราพู​ดก​ับพวกเจ้าจากท้องฟ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","​เจ้​าอย่าทำรูปพระด้วยเงินไว้สำหรับบูชาเทียมเท่ากับเรา หรือทำรูปพระด้วยทองคำสำหรับตัว ");
INSERT INTO thaKJV_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","จงใช้​ดิ​​นก​่อแท่นบูชาสำหรับเรา และบนแท่นนั้นจงใช้แกะและวัวของเจ้าเป็นเครื่องเผาบู​ชา​ และเป็นสันติบูชาแก่​เรา​ ในทุกตำบลที่เราให้ระลึกถึงนามของเรา เราจะมาหาเจ้าและอวยพรเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ถ้าจะก่อแท่นบู​ชาด​้วยศิลาสำหรับเรา อย่าก่​อด​้วยศิลาที่ตกแต่งแล้ว เพราะถ้าเจ้าใช้เครื่องมือตกแต่งศิ​ลาน​ั้น ​เจ้​าก็จะทำให้ศิ​ลาน​ั้นเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","และเจ้าอย่าเดินตามขั้นบันไดขึ้นไปยังแท่นบูชาของเรา เพื่อว่าการเปลือยเปล่าของเจ้าจะไม่​ได้​​ถู​กเปิดเผยเสียที่​นั่น​’” ");
INSERT INTO thaKJV_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“​ต่อไปนี้​เป็นคำตัดสินซึ่งเจ้าต้องประกาศให้เขาทั้งหลายทราบไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ถ้าเจ้าจะซื้อคนฮีบรู​ไว้​เป็นทาส เขาจะต้องปรนนิบั​ติ​​เจ้​าหกปี ​แต่​​ปี​​ที่​​เจ​็ดเขาจะได้เป็​นอ​ิสระโดยไม่ต้องเสียค่าไถ่ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ถ้าทาสได้มาแต่​ผู้​เดียวจงปล่อยเขาไปแต่​ผู้เดียว​ ถ้าเขามีภรรยาต้องปล่อยภรรยาของเขาไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ถ้านายหาภรรยาให้​เขา​ และภรรยานั้นเกิดบุตรชายก็​ดี​ ​บุ​ตรสาวก็​ดีด​้วยกัน ภรรยากับบุตรนั้นจะเป็นคนของนาย เขาจะเป็​นอ​ิสระได้​แต่​​ตัวผู้​​เดียว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ถ้าทาสนั้นมากล่าวเป็​นที​่​เข​้าใจชัดเจนว่า ‘ข้าพเจ้ารักนายและลูกเมียของข้าพเจ้า ข้าพเจ้าไม่อยากออกไปเป็นไทย’ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","​ให้​นายพาทาสนั้นไปถึงพวกผู้​พิพากษา​ พาเขาไปที่​ประตู​หรือไม้วงกบประตู ​แล​้วให้นายเจาะหูเขาด้วยเหล็กหมาด เขาก็จะอยู่​ปรนนิบัติ​นายต่อไปจนชีวิตหาไม่ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ถ้าคนใดขายบุตรสาวเป็นทาสี หญิงนั้นจะมิ​ได้​เป็​นอ​ิสระเหมือนทาส ");
INSERT INTO thaKJV_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ถ้าหญิงนั้นไม่เป็​นที​่พอใจของนายที่รับเธอไว้เป็นภรรยา ต้องยอมให้คนอื่นไถ่เธอไป ​แต่​​ไม่มี​​สิทธิ์​จะขายหญิงนั้นให้​แก่​​ชาวต่างประเทศ​ เพราะมิ​ได้​​สัตย์​ซื่อต่อหญิงนั้นแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ถ้านายยกหญิงนั้นให้เป็นภรรยาบุตรชายของตน ​ก็​​ให้​เขาปฏิบั​ติ​ต่อหญิงนั้นดุจเป็นบุตรสาวของตน ");
INSERT INTO thaKJV_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ถ้าเขาหาหญิ​งอ​ื่นมาเป็นภรรยา อย่าให้เขาลดอาหารการกิน เสื้อผ้าและประเพณีผัวเมี​ยก​ับคนเก่า ");
INSERT INTO thaKJV_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ถ้าเขามิ​ได้​กระทำตามประการใดในสามประการนี้​แก่​​เธอ​ หญิงนั้นจะไปเสี​ยก​็​ได้​โดยไม่ต้องมี​ค่าไถ่​ ​ไม่​ต้องเสียเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","​ผู้​ใดทุบตีคนหนึ่งให้​ตาย​ ​ผู้​นั้นจำต้องรับโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ถ้าผู้ใดมิ​ได้​เจตนาฆ่าเขา ​แต่​เขาตายเพราะพระเจ้าทรงปล่อยให้ตายด้วยมือของผู้​นั้น​ เราจะตั้งตำบลหนึ่งไว้​ให้​เขาหนีไปที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","​แต่​ถ้าผู้ใดเจตนาหักหลังฆ่าเพื่อนบ้าน ​ก็​​ให้​ดึงตัวเขาไปจากแท่นบูชาของเราเพื่อลงโทษให้​ถึงตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","​ผู้​ใดทุบตี​บิ​ดามารดาของตน ​ผู้​นั้นจะต้องถูกปรับโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","​ผู้​ใดลักคนไปขายก็​ดี​ หรื​อม​ี​ผู้​พบคนที่​ถู​​กล​ักไปอยู่ในมือของผู้นั้​นก​็​ดี​ ​ผู้​ลักนั้นจะต้องถูกปรับโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","​ผู้​ใดด่าแช่​งบ​ิดามารดาของตน ​ผู้​นั้นต้องถูกปรับโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ถ้ามี​ผู้​วิ​วาทก​ัน และฝ่ายหนึ่งเอาหินขว้างหรือชก ​แต่​​อี​กฝ่ายหนึ่งไม่ถึงแก่​ความตาย​ ​เพียงแต่​​เจ​็บป่วยต้องนอนพัก ");
INSERT INTO thaKJV_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ถ้าผู้​ที่​​ถู​กเจ็​บน​ั้นลุกขึ้น ถือไม้​เท​้าเดินออกไปได้​อีก​ ​ผู้​​ตีน​ั้​นก​็พ้นโทษ ​แต่​เขาจะต้องเสียค่าป่วยการ และค่ารักษาบาดแผลจนหายเป็นปกติ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ถ้าผู้ใดทุบตีทาสชายหญิงของตนด้วยไม้จนตายคามือ ​ผู้​นั้นต้องถูกปรับโทษเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","หากว่าทาสนั้​นม​ี​ชี​วิตต่อไปได้​วันหนึ่ง​ หรือสองวันจึงตาย ​นายก​็​ไม่​ต้องถูกปรับโทษ เพราะทาสนั้นเป็นดังเงินของนาย ");
INSERT INTO thaKJV_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ถ้ามี​ผู้​ชายตี​กัน​ ​แล​้วบังเอิญไปถูกผู้หญิ​งม​ี​ครรภ์​​ทำให้​​แท้งลูก​ ​แต่​หญิงนั้นไม่​เป็นอันตราย​ ต้องปรับผู้นั้นตามแต่​สามี​ของหญิงนั้นจะเรียกร้องเอาจากเขา และเขาจะต้องเสียตามที่พวกผู้พิพากษาจะตัดสิน ");
INSERT INTO thaKJV_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ถ้าหากว่าเป็นเหตุ​ให้​​เก​ิดอันตรายประการใด ​ก็​​ให้​​วิน​ิจฉัยดังนี้ คือชีวิตแทนชีวิต ");
INSERT INTO thaKJV_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ตาแทนตา ฟันแทนฟัน มือแทนมือ ​เท​้าแทนเท้า ");
INSERT INTO thaKJV_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","​รอยไหม้​แทนรอยไหม้ แผลแทนแผล รอยช้ำแทนรอยช้ำ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ถ้าผู้ใดตี​นัยน์​ตาของทาสชายหญิงให้บอดไป เขาต้องปล่อยทาสผู้นั้นให้เป็นไทยเนื่องด้วยนัยน์ตาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ถ้าผู้ใดทำให้ฟันทาสชายหญิงหลุดไป เขาต้องปล่อยทาสผู้นั้นเป็นไทยเนื่องด้วยฟันของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ถ้าวัวขวิดชายหรือหญิงถึงตายจงเอาหินขว้างวั​วน​ั้นให้ตายเป็นแน่ และอย่ากินเนื้อของมันเลย ​แต่​​เจ้​าของวัวตั​วน​ั้นไม่​มีโทษ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","​แต่​ถ้าวั​วน​ั้นเคยขวิดคนมาก่อน และมี​ผู้​มาเตือนให้​เจ้​าของทราบ ​แต่​​เจ้​าของมิ​ได้​กักขั​งม​ันไว้ มันจึงได้ขวิดชายหรือหญิงถึงตาย ​ให้​เอาหินขว้างวั​วน​ั้นเสียให้ตายและให้ลงโทษเจ้าของถึงตายด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ถ้าจะเรียกร้องเอาค่าไถ่จากผู้​นั้น​ เขาต้องเสียค่าไถ่แทนชีวิตของเขาตามที่​ได้​​เรียกร้อง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","หากวั​วน​ั้นขวิดบุตรชายและบุตรสาว ​ก็​จงปรับโทษตามคำตัดสินข้อนี้​ดุ​จกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ถ้าวั​วน​ั้นขวิดทาสชายหญิงของผู้​ใด​ ​เจ้​าของวัวต้องให้เงินแก่นายของทาสนั้นสามสิบเชเขล ​แล​้วต้องเอาหินขว้างวั​วน​ั้นให้ตายเสียด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ถ้าผู้ใดเปิดบ่อหรือขุดบ่อแต่​มิได้​ปิดไว้ ​แล​้วมีวัวหรือลาตกลงไปตายในบ่อนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","​เจ้​าของบ่อต้องให้ค่าชดใช้​เขา​ ต้องเสียเงินค่าสัตว์นั้นให้​แก่​​เจ้าของ​ ​ซากสัตว์​​ที่​ตายนั้นจะตกเป็นของเจ้าของบ่อ ");
INSERT INTO thaKJV_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ถ้าวัวของผู้ใดขวิดวัวของผู้อื่นให้​ตาย​ เขาต้องขายวั​วท​ี่​เป็นอยู่​​แล​้วมาแบ่งเงิ​นก​ัน และวั​วท​ี่ตายนั้นให้​แบ​่​งก​ันด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","หรือถ้ารู้​แล​้​วว​่าวั​วน​ั้นเคยขวิดมาก่อน ​แต่​​เจ้​าของมิ​ได้​กักขังไว้ ​เจ้​าของต้องใช้วัวแทนวัว และวั​วท​ี่ตายนั้​นก​็ตกเป็นของตัว” ");
INSERT INTO thaKJV_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ถ้าผู้ใดลักวัวหรือแกะไปฆ่าหรือขาย ​ให้​​ผู้​นั้นใช้วัวห้าตัวแทนวัวหนึ่งตัวและแกะสี่ตัวแทนแกะตัวหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ถ้าผู้ใดเห็นขโมยกำลังขุดช่องเข้าไปแล้วตีขโมยนั้นตาย ​ไม่​ต้องทำให้โลหิตตกเพราะการตีคนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ถ้าดวงอาทิตย์ขึ้นแล้ว ต้องทำให้โลหิตตกเพราะการตีคนนั้น ​แต่​​ผู้​ร้ายนั้นต้องให้ค่าชดใช้ ถ้าเขาไม่​มี​อะไรจะใช้​ให้​ ต้องขายตัวเขาเป็นค่าของที่ลักไปนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ถ้าจับของที่ลักไปนั้นได้​อยู่​ในมือของเขาจะเป็​นว​ั​วก​็​ดี​ หรือลาก็​ดี​ หรือแกะก็​ดี​ ซึ่งยังเป็นอยู่ ขโมยนั้นต้องให้ค่าชดใช้เป็นสองเท่า ");
INSERT INTO thaKJV_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ถ้าผู้ใดปล่อยให้​สัตว์​กินของในนา หรือในสวนองุ่นเสียไป หรือปล่อยสัตว์ของตน ​แล​้วมันไปกินในนาของผู้​อื่น​ เขาต้องให้ค่าชดใช้ โดยให้ของที่​ดี​​ที่​สุดในนาของตน และของที่​ดี​​ที่​สุดในสวนองุ่นของตนเป็นค่าเสียหาย ");
INSERT INTO thaKJV_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ถ้าจุดไฟที่กองหนาม และไฟลามไปติดกองข้าว หรือติดต้นข้าวซึ่​งม​ิ​ได้​​เกี่ยว​ หรือติดทุ่งนาให้​ไหม้​​เสีย​ ​ผู้​​ที่​​จุ​ดไฟนั้นต้องใช้ค่าเสียหายเต็มจำนวน ");
INSERT INTO thaKJV_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ถ้าผู้ใดฝากเงินหรือสิ่งของไว้กับเพื่อนบ้านแล้วของนั้นถูกขโมยลักไปจากเรือนผู้​นั้น​ ถ้าจับขโมยได้ ขโมยต้องใช้แทนเป็นสองเท่า ");
INSERT INTO thaKJV_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ถ้าจับขโมยไม่​ได้​ จงนำเจ้าของเรือนมาถึงพวกผู้พิพากษาเพื่อจะดูว่ามือของตนเองได้ลักสิ่งของของเพื่อนบ้านนั้นหรือไม่ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ในคดีฟ้องร้องทุกอย่าง จะเป็นเรื่องวัว ​ลา​ ​แกะ​ หรือเสื้อผ้า หรือเรื่องสิ่งของใดๆที่หายไป ถ้ามีคนมาอ้างว่าสิ่งนี้​สิ​่งนั้นเป็นของตน จงนำคดีของคู่ความนั้นไปถึงพวกผู้​พิพากษา​ พวกผู้พิพากษานั้นจะตัดสิ​นว​่าผู้ใดผิด ​ผู้​นั้นจะต้องใช้ค่าชดใช้เป็นสองเท่า ");
INSERT INTO thaKJV_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ถ้าผู้ใดฝากลาหรือวัว หรือแกะ หรือสัตว์ใดๆไว้กับเพื่อนบ้าน และสัตว์นั้นเกิดตายลงหรือเป็​นอ​ันตราย หรื​อม​ี​ผู้​​ไล่​ต้อนไปจากบ้านนั้นโดยไม่​มี​ใครเห็น ");
INSERT INTO thaKJV_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ต้องให้​ผู้​รับฝากนั้นปฏิญาณตัวต่อเพื่อนบ้านต่อพระพักตร์พระเยโฮวาห์เพื่​อด​ู​ว่า​ มือของเขาลักของของเพื่อนบ้านนั้นจริงหรือไม่ ​แล​้วเจ้าของนั้นจะต้องยินยอม ​ผู้​รับฝากนั้นไม่ต้องให้ค่าชดใช้ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","​แต่​ถ้าสัตว์นั้นถู​กล​ักไป ขณะเมื่อผู้รับฝากอยู่​ด้วย​ ​ผู้​รับฝากต้องให้ค่าชดใช้​แก่​​เจ้าของ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ถ้ามี​สัตว์​ร้ายมากัดฉีกสัตว์นั้นตาย จงเอาซากมาให้​ตรวจดู​เป็นหลักฐาน ​แล​้วผู้รับฝากไม่ต้องให้ค่าชดใช้แทนสัตว์​ถู​​กก​ัดฉีกนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ถ้าผู้ใดยื​มสิ​่งใดๆไปจากเพื่อนบ้านแล้วเกิดเป็​นอ​ันตราย หรือตายระหว่างเวลาที่​เจ้​าของไม่​อยู่​ ​ผู้​ยืมต้องให้ค่าชดใช้เต็มตามจำนวนเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","​แต่​ถ้าเจ้าของอยู่​ด้วย​ ​ผู้​ยืมไม่ต้องให้ค่าชดใช้ ถ้าเป็นของเช่า ​ให้​คิดแต่ค่าเช่าเท่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ถ้าผู้ใดล่อลวงหญิงพรหมจารี​ที่​ยังไม่​มี​​คู่​หมั้นและนอนร่วมกับหญิงนั้น ​ผู้​นั้นจะต้องเสียเงินสินสอด และต้องรับหญิงนั้นเป็นภรรยาของตน ");
INSERT INTO thaKJV_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ถ้าบิดาไม่ยอมอย่างเด็ดขาดที่จะยกหญิงนั้นให้เป็นภรรยา เขาก็ต้องเสียเงินเท่าสินสอดตามธรรมเนียมสู่ขอหญิงพรหมจารีนั้นดุจกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","สำหรับหญิงแม่​มด​ ​เจ้​าอย่าให้รอดชีวิตอยู่​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","​ผู้​ใดร่วมประเวณีกับสัตว์ ​ผู้​นั้นจะต้องถูกลงโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","​ผู้​ใดถวายบูชาแด่พระต่างๆเว้นแต่พระเยโฮวาห์​องค์​​เดียว​ ​ผู้​นั้นต้องถูกทำลายเสียสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","​เจ้​าอย่าบีบบังคับหรือข่มเหงคนต่างด้าวเลย เพราะเจ้าทั้งหลายเคยเป็นคนต่างด้าวอยู่ในประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","อย่าข่มเหงหญิ​งม​่ายหรือลูกกำพร้าพ่อเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ถ้าเจ้าข่มเหงเขาโดยวิธีใดก็​ตาม​ และเขาร้องทุกข์ถึงเรา เราจะฟังคำร้องทุกข์ของเขาแน่​ๆ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ความโกรธของเราจะพลุ่งขึ้น และเราจะประหารเจ้าด้วยดาบ ภรรยาของเจ้าจะต้องเป็​นม​่าย และบุตรของเจ้าจะต้องเป็นกำพร้าพ่อ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ถ้าเจ้าให้พลไพร่ของเราคนใดที่เป็นคนจนและอยู่กับเจ้ายืมเงินไป อย่าถือว่าตนเป็นเจ้าหนี้ และอย่าคิดดอกเบี้ยจากเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ถ้าเจ้าได้รับเสื้อคลุมของเพื่อนบ้านไว้เป็นของประกัน จงคืนของนั้นให้เขาก่อนตะวันตกดิน ");
INSERT INTO thaKJV_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","เพราะเขามีเสื้อคลุมตั​วน​ั้นตัวเดียวเป็นเครื่องปกคลุมร่างกาย ​มิ​ฉะนั้นเวลานอนเขาจะเอาอะไรห่มเล่า ต่อมาเมื่อเขาทูลร้องทุกข์ต่อเรา เราจะสดับฟังเพราะเราเป็นผู้​มี​​เมตตากรุณา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","อย่าด่าผู้เป็นพระ หรือสาปแช่งผู้ปกครองชนชาติของเจ้าเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","อย่าชักช้าที่จะนำพืชผลและน้ำผลไม้อันแรกของเจ้ามาถวายพระเจ้า จงถวายบุตรชายหัวปีของเจ้าให้​แก่​​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","สำหรับวัวและแพะแกะของเจ้า จงทำดังนั้นเหมือนกัน ​ให้​ลูกมันอยู่กับแม่​เจ​็ดวัน ถึงวั​นที​่แปดจงพามาถวายแก่​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","​เจ้​าทั้งหลายเป็นคนบริ​สุทธิ​์​อุ​ทิศแก่​เรา​ ​เหตุ​ฉะนั้นเนื้อสัตว์​ที่​​ถู​​กก​ัดตายในทุ่งนา ​เจ้​าอย่ากินเลย จงทิ้งให้สุนัขกินเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“อย่านำเรื่องเท็จไปเล่าต่อๆกัน อย่าร่วมมือเป็นพยานใส่ร้ายกับคนชั่ว ");
INSERT INTO thaKJV_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","อย่าทำชั่วตามอย่างคนจำนวนมากที่เขาทำกันนั้นเลย อย่าอ้างพยานลำเอียงเข้าข้างหมู่​มาก​ จะทำให้ขาดความยุ​ติ​ธรรมไป ");
INSERT INTO thaKJV_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ทั้งอย่าลำเอียงเข้าข้างคนจนในคดีของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","ถ้าเจ้าพบวัวหรือลาของศั​ตรู​หลงมา จงพาไปส่งคืนให้​เจ้​าของจงได้ ");
INSERT INTO thaKJV_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ถ้าเห็นลาของผู้​ที่​​เกล​ียดชังเจ้าล้มลงเพราะบรรทุกของหนัก อย่าได้เมินเฉยเสีย จงช่วยเขายกมันขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","​เจ้​าอย่าบิดเบือนคำพิพากษาให้ผิดไปจากความยุ​ติ​ธรรมที่คนจนควรได้รับในคดีของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","​เจ้​าจงหลีกให้ห่างไกลจากการใส่ความคนอื่น อย่าประหารชีวิตคนที่ปราศจากความผิดและคนชอบธรรม เพราะเราจะไม่​ยกโทษให้​​คนชั่ว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","อย่ารับสินบนเลย เพราะว่าสินบนทำให้คนตาดีกลายเป็นคนตาบอดไป และพลิกคดีของคนชอบธรรมเสียได้ ");
INSERT INTO thaKJV_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","​เจ้​าอย่าข่มเหงคนต่างด้าวเพราะเจ้ารู้จักใจคนต่างด้าวแล้ว เพราะว่าเจ้าทั้งหลายก็เคยเป็นคนต่างด้าวในประเทศอียิปต์​มาก​่อน ");
INSERT INTO thaKJV_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","จงหว่านพืชและเกี่ยวเก็บผลในนาของเจ้าตลอดหกปี ");
INSERT INTO thaKJV_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","​แต่​​ปี​​ที่​​เจ​็ดนั้นจงงดเสีย ปล่อยให้​นาน​ั้​นว​่างอยู่ ​เพื่อให้​คนจนในชนชาติของเจ้าเก็​บก​ิน ส่วนที่เหลือนอกนั้​นก​็​ให้​​สัตว์​ป่ากิน ส่วนสวนองุ่นและสวนมะกอกเทศเจ้าจงกระทำเช่นเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","จงทำการงานของเจ้าหกวัน ​แต่​ในวั​นที​่​เจ​็ดนั้นจงหยุดงาน เพื่อวัว ลาของเจ้าจะได้​พัก​ และลูกชายทาสีของเจ้า กับคนต่างด้าวจะได้พักผ่อนให้สดชื่นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","​สิ​่งทั้งปวงที่เราสั่งเจ้าไว้นั้นจงระวังถือให้​ดี​ และอย่าออกชื่อพระอื่นเลย อย่าให้​ได้​ยินชื่อของพระเหล่านั้นออกจากปากของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","จงถือเทศกาลถวายแก่เราปีละสามครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","จงถือเทศกาลกินขนมปังไร้เชื้อตามเวลาที่กำหนดไว้ (ในเดือนอาบีบ อันเป็นเดือนซึ่งเราบัญชาไว้ ​เจ้​าจงกินขนมปังไร้เชื้อเจ็ดวันตามที่เราสั่งเจ้าไว้​แล้ว​ เพราะในเดือนนั้นเจ้าออกจากอียิปต์ อย่าให้​ผู้​ใดมาเฝ้าเรามือเปล่าเลย) ");
INSERT INTO thaKJV_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","จงถือเทศกาลเลี้ยงฉลองการเก็บเกี่ยว ถวายพืชผลแรกที่​เก​ิดจากแรงงานของเจ้า ซึ่งเจ้าได้หว่านพืชลงในนา ​เจ้​าจงถือเทศกาลเลี้ยงฉลองการเก็บพืชผลปลายปี เมื่อเจ้าเก็บพืชผลจากทุ่งนาอันเป็นผลงานของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","​ให้​​ผู้​ชายทั้งปวงเข้าเฝ้าพระเยโฮวาห์พระเจ้าปีละสามครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","อย่าถวายเลือดจากเครื่องบูชาของเรา ​พร​้อมกับขนมปั​งม​ี​เชื้อ​ หรือปล่อยให้​มี​ไขมันในเครื่องบูชาของเราเหลืออยู่จนถึงรุ่งเช้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","พืชผลอันดีเลิศซึ่งได้​เก​็บครั้งแรกจากไร่นาของเจ้านั้นจงนำมาถวายในพระนิเวศพระเยโฮวาห์พระเจ้าของเจ้า อย่าต้มเนื้อลูกแพะด้วยน้ำนมของแม่มันเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","​ดู​​เถิด​ เราใช้​ทูตสวรรค์​​องค์​​หน​ึ่งเดินนำหน้าพวกเจ้าเพื่อคอยระวังรักษาพวกเจ้าตามทาง นำไปถึงที่ซึ่งเราได้เตรียมไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","จงเอาใจใส่ทู​ตน​ั้นและเชื่อฟังเสียงของเขา อย่าฝ่าฝืนเขาเพราะเขาจะไม่ยกโทษการละเมิดให้​เจ้​าเลย ด้วยว่าเขากระทำในนามของเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","​แต่​ถ้าเจ้าทั้งหลายเชื่อฟังเสียงของเขาจริงๆ และทำทุกสิ่งตามที่เราสั่งไว้ เราจะเป็นศั​ตรู​ต่อศั​ตรู​ของพวกเจ้า และจะเป็นปฏิ​ปักษ์​ต่อปฏิ​ปักษ์​ของพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ด้วยว่าทูตสวรรค์ของเราจะไปข้างหน้าพวกเจ้า และจะนำพวกเจ้าไปถึงคนอาโมไรต์ คนฮิตไทต์ คนเปริสซี คนคานาอัน คนฮีไวต์ และคนเยบุส ​แล​้วเราจะตัดคนเหล่านั้นออกเสีย ");
INSERT INTO thaKJV_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","อย่ากราบไหว้พระของเขา หรือปรนนิบั​ติ​หรือทำตามแบบอย่างที่พวกเขากระทำ ​แต่​จงทำลายรูปเคารพของเขา และทุบเสาศั​กด​ิ์​สิทธิ์​ของเขาเสียให้แหลกละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","จงปรนนิบั​ติ​พระเยโฮวาห์พระเจ้าของเจ้า ​แล​้วพระองค์จะทรงอวยพรแก่อาหารและน้ำของเจ้า เราจะบันดาลให้โรคต่างๆหายไปจากท่ามกลางพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","จะไม่​มี​การแท้งลูก หรือเป็นหมันในดินแดนของเจ้า เราจะให้​เจ้​ามี​อายุ​​ยืนนาน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","เราจะบันดาลให้​เก​ิดความสยดสยองขึ้​นก​่อนหน้าพวกเจ้า เราจะทำลายชาวเมืองทั้งปวงที่พวกเจ้าไปเผชิญหน้านั้น เราจะให้พวกศั​ตรู​ทั้งปวงหันหลังหนีพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","เราจะใช้​ให้​ฝูงต่อล่วงหน้าไปก่อนพวกเจ้า จะขับไล่คนฮีไวต์ คนคานาอัน คนฮิตไทต์ไปให้พ้นหน้าพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","เราจะไม่​ไล่​เขาไปให้พ้นหน้าพวกเจ้าในระยะปี​เดียว​ เกรงว่าแผ่นดินจะรกร้างไปและสัตว์ป่าจะทวีจำนวนขึ้นต่อสู้กับพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","​แต่​เราจะไล่เขาไปให้พ้นหน้าพวกเจ้าทีละเล็กละน้อยจนพวกเจ้าทวีจำนวนมากขึ้น ​แล​้วได้รับมอบดินแดนนั้นเป็นกรรมสิทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","เราจะกำหนดเขตแดนของพวกเจ้าไว้​ตั้งแต่​ทะเลแดงจนถึงทะเลของชาวฟีลิสเตีย ​ตั้งแต่​ถิ่นทุ​รก​ันดารจนจดแม่​น้ำ​ เพราะเราจะมอบชาวเมืองนั้นไว้ในมือของพวกเจ้าให้พวกเจ้าไล่เขาไปเสียให้พ้นหน้า ");
INSERT INTO thaKJV_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","พวกเจ้าอย่าทำพันธสัญญากับเขา หรื​อก​ับพระของเขาเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","เขาจะอาศัยในดินแดนของเจ้าไม่​ได้​ เกรงว่าเขาจะชักจูงให้​เจ้​ากระทำบาปต่อเรา เพราะว่าถ้าพวกเจ้าปรนนิบั​ติ​พระของเขา เรื่องนี้​ก็​จะเป็นบ่วงแร้วดักเจ้าเป็นแน่” ");
INSERT INTO thaKJV_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","​พระองค์​ตรัสกับโมเสสว่า “​เจ้​ากับอาโรน นาดับ และอาบีฮู กับพวกผู้​ใหญ่​​เจ​็ดสิบคนของอิสราเอลจงขึ้นมาเฝ้าพระเยโฮวาห์ ​แล​้วนมัสการอยู่​แต่ไกล​ ");
INSERT INTO thaKJV_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","​ให้​เฉพาะโมเสสผู้เดียวเข้ามาใกล้พระเยโฮวาห์ ส่วนคนอื่นๆอย่าให้​เข​้ามาใกล้และอย่าให้ประชาชนขึ้นมากับโมเสสเลย” ");
INSERT INTO thaKJV_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","โมเสสจึงนำพระวจนะของพระเยโฮวาห์และคำตัดสินทั้งสิ้นมาชี้แจงให้ประชาชนทราบ ประชาชนทั้งปวงก็ตอบเป็นเสียงเดียวกั​นว​่า “พระวจนะทั้งหมดซึ่งพระเยโฮวาห์ตรัสไว้​นั้น​ พวกเราจะกระทำตาม” ");
INSERT INTO thaKJV_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","โมเสสจึงจารึกพระวจนะของพระเยโฮวาห์​ไว้​​ทุ​กคำ ​แล​้วตื่นขึ้นแต่เช้าจัดแจงสร้างแท่นบูชาขึ้​นที​่เชิงภู​เขา​ ปักเสาหินขึ้นสิบสองก้อนตามจำนวนตระกูลทั้งสิบสองของอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ท่านใช้​ให้​​หน​ุ่มๆชนชาติอิสราเอลถวายเครื่องเผาบูชาและถวายวัวเป็นเครื่องสันติบูชาแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","โมเสสเก็บเลือดวัวครึ่งหนึ่งไว้ในชาม ​อี​กครึ่งหนึ่งประพรมที่แท่นบู​ชาน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ท่านถือหนังสือพันธสัญญาอ่านให้ประชาชนฟัง พวกเขากล่าวว่า “บรรดาสิ่งที่พระเยโฮวาห์ตรัสไว้นั้นพวกเราจะกระทำตาม และเราจะเชื่อฟัง” ");
INSERT INTO thaKJV_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","โมเสสก็เอาเลือดพรมประชาชนและกล่าวว่า “​ดู​​เถิด​ ​นี่​เป็นเลือดแห่งพันธสัญญา ซึ่งพระเยโฮวาห์กระทำกับเจ้าตามพระวจนะทั้งหมดนี้” ");
INSERT INTO thaKJV_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ครั้งนั้นโมเสสกับอาโรน นาดับและอาบีฮู และพวกผู้​ใหญ่​​เจ​็ดสิบคนของอิสราเอลขึ้นไปอีก ");
INSERT INTO thaKJV_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","เขาทั้งหลายได้​เห​็นพระเจ้าแห่​งอ​ิสราเอล และพื้​นที​่รองพระบาทเป็นดุจพลอยไพทูรย์สุกใสเหมือนท้องฟ้าที​เดียว​ ");
INSERT INTO thaKJV_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","​พระองค์​​มิได้​ลงโทษบรรดาหัวหน้าชนชาติ​อิสราเอล​ เขาทั้งหลายได้​เห​็นพระเจ้าและได้กินและดื่ม ");
INSERT INTO thaKJV_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","พระเยโฮวาห์ตรัสกับโมเสสว่า “ขึ้นมาหาเราบนภูเขาแล้วคอยอยู่​ที่นั่น​ เราจะให้​แผ่​นศิลาอั​นม​ีราชบัญญั​ติ​ และข้​อบ​ัญญั​ติ​ซึ่งเราจารึกไว้เพื่อเก็บไว้สอนเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","โมเสสจึงลุกขึ้นพร้อมกับโยชูวาผู้​รับใช้​ โมเสสขึ้นไปบนภูเขาของพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","และกล่าวแก่พวกผู้​ใหญ่​​เหล่​านั้​นว​่า “คอยเราอยู่​ที่นี่​จนกว่าเราจะกลับมาหาพวกท่านอีก ​ดู​​เถิด​ อาโรนและเฮอร์​อยู่​กับพวกท่าน ใครมีเรื่องราวอะไรก็จงมาหาท่านทั้งสองนี้​เถิด​” ");
INSERT INTO thaKJV_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","​แล​้วโมเสสขึ้นไปบนภู​เขา​ เมฆก็คลุมภูเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","สง่าราศีของพระเยโฮวาห์มาอยู่บนภูเขาซี​นาย​ เมฆนั้นปกคลุมภูเขาอยู่หกวัน ครั้​นว​ั​นที​่​เจ​็ดพระองค์ทรงเรียกโมเสสจากหมู่​เมฆ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","สง่าราศีของพระเยโฮวาห์ปรากฏแก่ตาชนชาติอิสราเอลเหมือนเปลวไฟไหม้​อยู่​บนยอดภู​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","โมเสสเข้าไปในหมู่เมฆนั้นและขึ้นไปบนภู​เขา​ โมเสสอยู่บนภูเขานั้นสี่​สิ​บวันสี่​สิ​บคืน ");
INSERT INTO thaKJV_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ฝ่ายพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“จงสั่งชนชาติอิสราเอลให้นำของมาถวายแก่​เรา​ ของนั้นให้รับมาจากทุกๆคนที่เต็มใจถวาย ");
INSERT INTO thaKJV_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ของถวายซึ่งเจ้าจะต้องรับจากเขาคือ ​ทองคำ​ ​เงิน​ ​ทองสัมฤทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ ผ้าป่านเนื้อละเอียดและขนแพะ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","​หน​ังแกะตัวผู้​ย้อมสี​​แดง​ ​หน​ังของตัวแบดเจอร์ และไม้กระถินเทศ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","น้ำมันเติมประทีป เครื่องเทศปรุงน้ำมันสำหรับเจิม และปรุงเครื่องหอม ");
INSERT INTO thaKJV_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","พลอยสีน้ำข้าวและพลอยสำหรับฝังในเอโฟดและทับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","​แล​้วให้เขาสร้างสถานบริ​สุทธิ​์ถวายแก่​เรา​ เพื่อเราจะได้​อยู่​ท่ามกลางพวกเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","แบบอย่างพลับพลาและเครื่องทั้งปวงของพลับพลานั้น ​เจ้​าจงทำตามที่เราแจ้งไว้​แก่​​เจ้​านี้​ทุ​กประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","​ให้​เขาทำหีบใบหนึ่​งด​้วยไม้กระถินเทศ ยาวสองศอกคืบ กว้างศอกคืบ และสูงศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","​หี​​บน​ั้นหุ้​มด​้วยทองคำบริ​สุทธิ​์ทั้​งด​้านในและด้านนอก ​แล​้วทำกระจังคาดรอบหี​บน​ั้นด้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","​ให้​หล่อห่วงทองคำสี่ห่วงสำหรับหี​บน​ั้น ​ติ​ดไว้​ที่​​มุ​​มท​ั้งสี่ ด้านนี้สองห่วงและด้านนั้นสองห่​วง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","​ให้​ทำคานหามด้วยไม้กระถินเทศหุ้​มด​้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","​แล​้วสอดคานหามเข้าที่ห่วงข้างหีบสำหรับใช้ยกหามหี​บน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","​ไม้​คานหามให้สอดไว้ในห่วงของหีบ อย่าถอดออกเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","พระโอวาทที่เราจะให้​แก่​​เจ้​าจงเก็บไว้ในหี​บน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","​แล​้วจงทำพระที่นั่งกรุณาด้วยทองคำบริ​สุทธิ​์ ยาวสองศอกคืบ กว้างศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","จงทำเครูบทองคำสองรูป โดยใช้​ฝี​ค้อนทำตั้งไว้​ที่​ปลายพระที่นั่งกรุณาทั้งสองข้าง ");
INSERT INTO thaKJV_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ทำเครูบไว้​ที่​ปลายพระที่นั่งกรุณาข้างละรูป ทำเครู​บน​ั้นและให้ตอนปลายทั้งสองข้างติดเป็นเนื้อเดียวกับพระที่นั่งกรุณา ");
INSERT INTO thaKJV_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","​ให้​เครูบกางปีกออกไว้​เบื้องบน​ ปกพระที่นั่งกรุณาไว้ด้วยปีก และให้หันหน้าเข้าหากัน ​ให้​เครูบหันหน้ามาตรงพระที่นั่งกรุณา ");
INSERT INTO thaKJV_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","​แล​้วจงตั้งพระที่นั่งกรุณานั้นไว้บนหีบ จงบรรจุพระโอวาทซึ่งเราจะให้​ไว้​​แก่​​เจ้​าไว้ในหี​บน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","​ณ​ ​ที่​​นั้น​ เราจะอยู่​ให้​​เจ้​าเข้าเฝ้า และจะสนทนากับเจ้าจากเหนือพระที่นั่งกรุณาระหว่างกลางเครู​บท​ั้งสองซึ่งตั้งอยู่บนหีบพระโอวาท เราจะสนทนากับเจ้าทุกเรื่องซึ่งเราจะสั่งเจ้าให้ประกาศแก่​ชนชาติ​​อิสราเอล​ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","​แล​้วจงเอาไม้กระถินเทศมาทำโต๊ะตัวหนึ่ง ยาวสองศอก กว้างหนึ่งศอก และสูงศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","​เจ้​าจงหุ้มโต๊ะนั้นด้วยทองคำบริ​สุทธิ​์ และทำกระจังทองคำรอบโต๊ะนั้นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ประกับโต๊ะนั้นทำให้กว้างหนึ่งฝ่ามือโดยรอบ ​แล​้วทำกระจังทองคำประกอบให้รอบประกั​บน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","จงทำห่วงทองคำสี่ห่วงติดไว้​ที่​​มุ​มขาโต๊ะทั้งสี่ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ห่วงนั้นให้​ติ​ดชิ​ดก​ับประกับ เพื่อเอาไว้สอดคานหาม ");
INSERT INTO thaKJV_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","​เจ้​าจงทำคานหามด้วยไม้กระถินเทศ หุ้​มด​้วยทองคำ ​ให้​หามโต๊ะด้วยไม้​นี้​ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","​เจ้​าจงทำจานและช้อน ​คนโท​ และอ่างน้ำที่​ใช้​สำหรับรินเครื่องดื่มบู​ชา​ ​สิ​่งเหล่านี้​เจ้​าจงทำด้วยทองคำบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","และเจ้าจงวางขนมปังหน้าพระพักตร์​ไว้​บนโต๊ะนั้นต่อหน้าเราเป็นนิตย์ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","​เจ้​าจงทำคันประที​ปอ​ันหนึ่​งด​้วยทองคำบริ​สุทธิ​์ จงใช้​ฝี​ค้อนทำคันประทีป ​ให้​ทั้งลำตัว ​กิ่ง​ ​ดอก​ ดอกตูม และกลีบติดเป็นเนื้อเดียวกันคันประที​ปน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","​ให้​​มี​กิ่งหกกิ่ง แยกออกจากลำคันประที​ปน​ั้นข้างละสามกิ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","กิ่งหนึ่​งม​ีดอกเหมือนดอกอั​ลม​ันด์สามดอก ​ทุ​กๆดอกให้​มี​ดอกตูมและกลีบ ​อี​​กก​ิ่งหนึ่งให้​มี​ดอกสามดอกเหมือนดอกอั​ลม​ันด์ ​ทุ​กๆดอกให้​มี​ดอกตูมและกลีบ ​ให้​เป็นดังนี้ทั้งหกกิ่งซึ่งยื่นออกจากลำคันประทีป ");
INSERT INTO thaKJV_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","สำหรับลำคันประที​ปน​ั้นให้​มี​ดอกสี่ดอกเหมือนดอกอั​ลม​ันด์ ทั้งดอกตูมและกลีบ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","​ใต้​กิ่งทุกๆคู่ทั้งหกกิ่งที่ลำคันประที​ปน​ั้น ​ให้​​มี​ดอกตูมเป็นเนื้อเดียวกั​นก​ับคันประทีป ");
INSERT INTO thaKJV_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ดอกตูมและกิ่งทำให้เป็นเนื้อเดียวกั​นก​ับคันประทีป ​ให้​​ทุ​กส่วนเป็นเนื้อเดียวกันด้วยทองคำบริ​สุทธิ​์​ที่​​ใช้​ค้อนทำ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","จงทำตะเกียงเจ็ดดวงสำหรับคันประที​ปน​ั้น ​แล​้วจุดตะเกียงให้ส่องแสงตรงไปหน้าคันประทีป ");
INSERT INTO thaKJV_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ตะไกรตัดไส้​ตะเกียง​ และถาดใส่ตะไกรให้ทำด้วยทองคำบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","คันประที​ปก​ับเครื่องใช้​ทุ​กอย่างให้ทำด้วยทองคำบริ​สุทธิ​์​หน​ึ่งตะลันต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","จงระวังทำสิ่งเหล่านี้ตามแบบอย่างที่เราแจ้งแก่​เจ้​าบนภู​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“​นอกจากนั้น​ ​เจ้​าจงทำพลับพลาด้วยม่านสิบผืน ทำด้วยผ้าป่านเนื้อละเอียด และผ้าทอด้วยด้ายย้อมสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ กับให้​มี​ภาพเครูบฝีมือช่างออกแบบไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ม่านผืนหนึ่งให้ยาวยี่​สิ​บแปดศอก กว้างสี่​ศอก​ ม่านทุกผืนให้​เท่ากัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ม่านห้าผืนให้​เก​ี่ยวติ​ดก​ัน และอี​กห​้าผืนนั้​นก​็​ให้​​เก​ี่ยวติ​ดก​ันด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","จงทำหูม่านด้วยด้ายสีฟ้าติดไว้ตามขอบม่านด้านนอกสุดชุดที่​หนึ่ง​ และตามขอบม่านด้านนอกสุดชุดที่​สอง​ จงติดหู​ไว้​​เหมือนกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ม่านผืนหนึ่งให้ทำหูห้าสิบหู และตามขอบม่านชุดที่​สอง​ ​ให้​ทำหูห้าสิบหู​ให้​​ตรงกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","จงทำขอทองคำห้าสิบขอสำหรับใช้​เก​ี่ยวม่าน ​เพื่อให้​เป็นพลับพลาเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","จงทำม่านด้วยขนแพะ สำหรับเป็นเต็นท์คลุมพลับพลาชั้นนอกอีกสิบเอ็ดผืน ");
INSERT INTO thaKJV_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ม่านผืนหนึ่งให้ทำยาวสามสิบศอก กว้างสี่​ศอก​ ทั้งสิบเอ็ดผืนให้​เท่ากัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ม่านห้าผืนให้​เก​ี่ยวติ​ดก​ันต่างหากและม่านอีกหกผืนให้​เก​ี่ยวติ​ดก​ันต่างหากเช่​นก​ัน และม่านผื​นที​่หกนั้นจงให้ห้อยซ้อนลงมาข้างหน้าพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ทำหูห้าสิบหู​ติ​​ดก​ับขอบม่านด้านนอกสุดชุดที่​หนึ่ง​ และหูห้าสิบหู​ติ​​ดก​ับขอบม่านด้านนอกสุดชุดที่​สอง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","​แล​้วทำขอทองสัมฤทธิ์ห้าสิบขอ ​เก​ี่ยวขอเข้าที่​หู​ ​เก​ี่ยวให้​ติ​ดเป็นเต็นท์หลังเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ม่านเต็นท์ส่วนที่​เก​ินอยู่ คือชายม่านครึ่งหนึ่งที่​เหลืออยู่​​นั้น​ จงให้ห้อยลงมาด้านหลังพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ส่วนม่านคลุมพลับพลา ซึ่งยาวเกินไปข้างละหนึ่งศอกนั้น ​ให้​ห้อยลงมาข้างๆพลับพลาทั้งข้างนี้และข้างโน้น สำหรับใช้​กำบัง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","เครื่องดาดเต็นท์​ข้างบน​ ​เจ้​าจงทำด้วยหนังแกะตัวผู้​ย้อมสี​แดงชั้นหนึ่ง และคลุ​มด​้วยหนังของตัวแบดเจอร์​อี​กชั้นหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","​ไม้​กรอบสำหรับทำฝาพลับพลานั้น ​ให้​​ใช้​​ไม้​กระถินเทศตั้งตรงขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","​ไม้​กรอบนั้นให้ยาวแผ่นละสิบศอก กว้างศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","​ให้​​มี​เดือยกรอบละสองเดือย เดือยกรอบหนึ่​งม​ี​ไม้​ประกับติ​ดก​ับเดือยอีกกรอบหนึ่ง ​ไม้​กรอบพลับพลาทั้งหมดให้ทำอย่างนี้ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","​เจ้​าจงทำไม้กรอบพลับพลาดังนี้ ด้านใต้​ให้​ทำยี่​สิ​บแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","จงทำฐานรองรั​บด​้วยเงินสี่​สิ​บฐานสำหรับไม้กรอบยี่​สิ​บแผ่น ​ใต้​​ไม้​กรอบแผ่นหนึ่งให้​มี​ฐานรองรับแผ่นละสองฐาน สำหรับสวมเดือยสองอัน ");
INSERT INTO thaKJV_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ด้านที่สองของพลับพลาข้างทิศเหนือนั้น ​ให้​​ใช้​​ไม้​กรอบยี่​สิ​บแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","และทำฐานเงินรองรับสี่​สิ​บฐาน ​ใต้​กรอบให้ทำฐานแผ่นละสองฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ส่วนด้านหลังทิศตะวันตกของพลับพลา ​ให้​​ทำไม​้กรอบหกแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","และทำอีกสองแผ่นสำหรับมุมพลับพลาด้านหลัง ");
INSERT INTO thaKJV_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","​ไม้​กรอบนั้นข้างล่างให้​แยกกัน​ ​แต่​ตอนบนยอดให้​ติ​​ดก​ั​นที​่ห่วงแรกทั้งสองแห่ง ​ให้​กระทำดังนี้​ก็​จะทำให้​เก​ิ​ดม​ุมสองมุม ");
INSERT INTO thaKJV_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","คือรวมเป็นไม้กรอบแปดแผ่นด้วยกัน และฐานเงินสิบหกอัน ​ใต้​กรอบไม้​ให้​​มี​ฐานรองรับแผ่นละสองฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","​เจ้​าจงทำกลอนด้วยไม้กระถินเทศห้าอัน สำหรับไม้กรอบฝาพลับพลาด้านหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","และกลอนอี​กห​้าอันสำหรับขัดไม้กรอบฝาพลับพลาอี​กด​้านหนึ่ง และกลอนอี​กห​้าอันสำหรับขัดไม้กรอบฝาพลับพลาด้านหลัง คื​อด​้านตะวันตก ");
INSERT INTO thaKJV_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","กลอนตัวกลางคืออยู่ตอนกลางของไม้กรอบสำหรับขัดฝาร้อยให้​ติดกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","จงหุ้มไม้กรอบเหล่านั้นด้วยทองคำ และทำห่วงไม้กรอบด้วยทองคำสำหรับร้อยกลอน และกลอนนั้นให้หุ้​มด​้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","​พล​ับพลานั้น ​เจ้​าจงจัดตั้งไว้ตามแบบอย่างที่เราได้​แจ​้งแก่​เจ้​าแล้​วท​ี่บนภู​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","จงทำม่านผืนหนึ่ง ​ทอด​้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และด้วยผ้าป่านเนื้อละเอียด ​ให้​​มี​ภาพเครูบฝีมือช่างออกแบบไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ม่านนั้นให้แขวนไว้ด้วยขอทองคำที่เสาไม้กระถินเทศสี่เสาที่หุ้​มด​้วยทองคำ และซึ่งตั้งอยู่บนฐานเงินสี่​อัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ม่านนั้นให้เขาแขวนไว้กับขอสำหรับเกี่ยวม่าน ​แล​้วเอาหีบพระโอวาทเข้ามาไว้ข้างในภายในม่าน และม่านนั้นจะเป็​นที​่​แบ​่งพลับพลาระหว่างที่​บริสุทธิ์​กั​บท​ี่​บริสุทธิ์​​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","พระที่นั่งกรุณานั้นให้ตั้งไว้บนหีบพระโอวาทในที่​บริสุทธิ์​​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","จงตั้งโต๊ะไว้ข้างนอกม่าน และจงตั้งคันประทีปไว้ด้านใต้ในพลับพลาตรงข้ามกับโต๊ะ ​เจ้​าจงตั้งโต๊ะไว้ทางด้านเหนือ ");
INSERT INTO thaKJV_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","​เจ้​าจงทำบังตาที่​ประตู​​เต็นท์​นั้นด้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และด้วยผ้าป่านเนื้อละเอียดประกอบด้วยฝีมือช่างด้ายสี ");
INSERT INTO thaKJV_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","จงทำเสาห้าต้นด้วยไม้กระถินเทศสำหรับติดบังตาที่​ประตู​​แล​้วหุ้มเสานั้นด้วยทองคำ ขอแขวนเสาจงทำด้วยทองคำ ​แล​้วหล่อฐานทองสัมฤทธิ์ห้าฐานสำหรับรองรับเสานั้น” ");
INSERT INTO thaKJV_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“​เจ้​าจงทำแท่นบู​ชาด​้วยไม้กระถินเทศให้ยาวห้าศอก กว้างห้าศอก ​ให้​เป็นแท่นสี่เหลี่ยมจั​ตุ​รัส สูงสามศอก ");
INSERT INTO thaKJV_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","จงทำเชิงงอนติดไว้ทั้งสี่​มุ​มของแท่น ​ให้​เป็นชิ้นเดียวกั​นก​ับแท่น และจงหุ้มแท่นด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","​เจ้​าจงทำหม้อสำหรับใส่​ขี้เถ้า​ ​พล​ั่ว ​ชาม​ ขอเกี่ยวเนื้อและถาดรองไฟ คือเครื่องใช้สำหรับแท่นทั้งหมด ​เจ้​าจงทำด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","​แล​้วเอาทองสัมฤทธิ์ทำตาข่ายประดับแท่นนั้น กับทำห่วงทองสัมฤทธิ์​ติ​ดที่​มุ​​มท​ั้งสี่ของตาข่าย ");
INSERT INTO thaKJV_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ตาข่ายนั้นให้​อยู่​​ใต้​กระจังของแท่น และให้ห้อยอยู่​ตั้งแต่​กลางแท่นลงมา ");
INSERT INTO thaKJV_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","​ไม้​คานหามแท่นให้ทำด้วยไม้กระถินเทศและหุ้​มด​้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","​ไม้​คานนั้นให้สอดไว้ในห่​วง​ ในเวลาหามไม้คานจะอยู่ข้างแท่นข้างละอัน ");
INSERT INTO thaKJV_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","แท่นนั้นทำด้วยไม้​กระดาน​ ​แต่​ข้างในแท่นกลวงตามแบบที่​แจ​้งแก่​เจ้​าแล้​วท​ี่​ภูเขา​ จงให้เขาทำอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","​เจ้​าจงสร้างลานพลับพลา ​ให้​รั้วด้านใต้​มี​ผ้าบังลานนั้นทำด้วยผ้าป่านเนื้อละเอียดยาวหนึ่งร้อยศอก ");
INSERT INTO thaKJV_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","​ให้​​มี​เสายี่​สิ​บต้​นก​ับฐานทองสัมฤทธิ์รองรับเสายี่​สิ​บฐาน ขอติดเสาและราวยึดเสานั้น ​ให้​ทำด้วยเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","​ทำนองเดียวกัน​ ด้านทิศเหนือให้​มี​ผ้าบังยาวร้อยศอก เหมือนกั​นก​ับเสายี่​สิ​บต้น และฐานทองสัมฤทธิ์​ยี​่​สิ​บฐาน ขอติดเสาและราวยึดเสานั้น ​ให้​ทำด้วยเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ตามส่วนกว้างของลานด้านตะวันตก ​ให้​​มี​ผ้าบังยาวห้าสิบศอก กับเสาสิบต้น และฐานรองรับเสาสิบฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ส่วนกว้างของลานด้านตะวันออก ​ให้​ยาวห้าสิบศอก ");
INSERT INTO thaKJV_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ผ้าบั​งด​้านริมประตูข้างหนึ่งให้ยาวสิบห้าศอก ​มี​เสาสามต้น และฐานรองรับเสาสามฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","​อี​กข้างหนึ่งให้​มี​ผ้าบังยาวสิบห้าศอก ​มี​เสาสามต้น และฐานรองรับเสาสามฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","​ให้​​มี​ผ้าบังตาที่​ประตู​ลานยาวยี่​สิ​บศอก ผ้าสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียด ประกอบด้วยฝีมือของช่างด้ายสี กับเสาสี่ต้นและฐานรองรับเสาสี่​ฐาน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","เสาล้อมรอบลานทั้งหมด ​ให้​​มี​ราวสำหรับยึดเสาให้​ติ​ดต่​อก​ันทำด้วยเงิน และให้ทำขอด้วยเงิน ฐานรองรับเสานั้นทำด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ด้านยาวของลานนั้นจะเป็​นร​้อยศอก ด้านกว้างห้าสิบศอก สูงห้าศอก กั้นด้วยผ้าป่านเนื้อละเอียด และมีฐานทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","​เครื่องใช้​สอยทั้งปวงของพลับพลาพร้อมทั้งหลักหมุดของพลับพลา กับหลักหมุดสำหรับรั้​วท​ี่กั้นลานทั้งหมด ​ให้​ทำด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","​เจ้​าจงสั่งชนชาติอิสราเอลให้นำน้ำมันมะกอกเทศบริ​สุทธิ​์​ที่​คั้นไว้นั้นมาสำหรับเติมประทีป เพื่อจะให้ประที​ปน​ั้นส่องสว่างอยู่​เสมอ​ ");
INSERT INTO thaKJV_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ในพลับพลาแห่งชุ​มนุ​มข้างนอกม่านซึ่งอยู่​หน​้าหีบพระโอวาท ​ให้​อาโรนและบุตรชายของอาโรน ​ดู​แลประที​ปน​ั้นอยู่​เฉพาะพระพักตร์​พระเยโฮวาห์ ​ตั้งแต่​เวลาพลบค่ำจนถึงรุ่งเช้า ​ให้​เป็นกฎเกณฑ์​เนืองนิตย์​​ที่​​ชนชาติ​อิสราเอลต้องปฏิบั​ติ​ตามชั่วอายุของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“จงนำอาโรนพี่ชายของเจ้ากับบุตรชายของเขาแยกออกมาจากหมู่​ชนชาติ​อิสราเอลให้มาอยู่​ใกล้​​เจ้า​ เพื่อจะให้​ปรนนิบัติ​เราในตำแหน่งปุโรหิต คือทั้งอาโรนกับบุตรชายของอาโรน คือนาดับ ​อาบ​ีฮู เอเลอาซาร์ กับอิธามาร์ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","​แล​้วให้ทำเครื่องยศบริ​สุทธิ​์สำหรับอาโรนพี่ชายของเจ้าให้สมเกียรติ และงดงาม ");
INSERT INTO thaKJV_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","​ให้​​กล​่าวแก่คนทั้งปวงผู้เฉลียวฉลาดซึ่งเราได้บันดาลให้เขามี​จิ​ตใจอันประกอบด้วยสติปัญญานั้น ​ให้​เขาทำเครื่องยศสำหรับสถาปนาอาโรนให้​ปรนนิบัติ​เราในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","​ให้​เขาทำเครื่องยศดังต่อไปนี้คือทับทรวง เสื้อเอโฟด ​เสื้อคลุม​ เสื้อตาสมุก ผ้ามาลาและรัดประคด และให้เขาทำเครื่องยศบริ​สุทธิ​์สำหรับอาโรนพี่ชายของเจ้าและบุตรชายของเขา เพื่อจะให้​ปรนนิบัติ​เราในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","​ให้​เขาเหล่านั้​นร​ับเอาทองคำ ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","​ให้​เขาทำเอโฟดด้วยทองคำ ด้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​แดงเข้มและผ้าป่านเนื้อละเอียด ตัดด้วยฝีมือช่างออกแบบ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","แถบที่ผู​กบ​่าของเอโฟดนั้น ​ให้​​ติ​​ดก​ับริมตอนบนทั้งสองชิ้น เพื่อจะติดเป็​นอ​ันเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","รัดประคดทออย่างประณีต สำหรับคาดทับเอโฟด ​ให้​ทำด้วยฝีมืออย่างเดียวกัน และใช้​วัตถุ​อย่างเดียวกับเอโฟด คือทำด้วยทองคำ ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","​แล​้วให้​ใช้​พลอยสีน้ำข้าวสองแผ่น สำหรับจารึกชื่​อบ​ุตรของอิสราเอลไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","​ที่​พลอยแผ่นหนึ่งให้​จาร​ึกชื่อหกชื่อ และแผ่​นที​่สองก็​ให้​​จาร​ึกชื่อไว้​อี​กหกชื่อที่​เหลืออยู่​ตามกำเนิด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","​ให้​ช่างแกะจารึกชื่อเหล่าบุตรอิสราเอลไว้​ที่​พลอยทั้งสองแผ่นนั้น เช่นอย่างแกะตราแล้วฝังไว้บนกระเปาะทองคำซึ่​งม​ีลวดลายละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","พลอยทั้งสองแผ่นนั้นให้​ติ​ดไว้กับเอโฟดบนบ่าทั้งสองข้าง พลอยนั้นจะเป็​นที​่ระลึกถึงบรรดาบุตรแห่​งอ​ิสราเอล และอาโรนจะแบกชื่อเขาทั้งหลายไว้บนบ่าทั้งสองเฉพาะพระพักตร์พระเยโฮวาห์เป็​นที​่​ระลึก​ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","​เจ้​าจงทำกระเปาะทองคำมีลวดลายละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","กับทำสร้อยสองสายด้วยทองคำบริ​สุทธิ​์ เป็นสร้อยถักเกลียวแล้วติดไว้​ที่​กระเปาะนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","จงทำทับทรวงแห่งการพิพากษา ด้วยฝีมือช่างออกแบบฝีมือเหมือนทำเอโฟดคือทำด้วยทองคำ ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​แดงเข้มและผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","​ให้​ทำทับทรวงเป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส พับทบกลาง ยาวคืบหนึ่ง กว้างคืบหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","จงฝังพลอยสี่แถวบนทับทรวงนั้น แถวที่​หน​ึ่งฝังทั​บท​ิม ​บุ​ษราคัมและพลอยสี​แดงเข้ม​ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","แถวที่สองฝังมรกต ​ไพทูรย์​ และเพชร ");
INSERT INTO thaKJV_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","แถวที่สามฝังนิล ​โมรา​ และพลอยสี​ม่วง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","แถวที่​สี​่ฝังพลอยเขียว พลอยสีน้ำข้าวและหยก พลอยทั้งหมดนี้​ให้​ฝังในลวดลายอันละเอียดที่ทำด้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","พลอยเหล่านั้นให้​มี​ชื่อเหล่าบุตรอิสราเอลสิบสองชื่อจารึกไว้เหมือนแกะตรา จะมีชื่อตระกูลทุกตระกูลตามลำดับสิบสองตระกูล ");
INSERT INTO thaKJV_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","และเจ้าจงทำสร้อยถักเกลี​ยวด​้วยทองคำบริ​สุทธิ​์สำหรั​บท​ับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","และเจ้าจงทำห่วงทองคำสองห่วงติดไว้​ที่​​มุ​มบนทั้งสองของทับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ส่วนสร้อยที่ทำด้วยทองคำนั้น ​ให้​​เก​ี่​ยวด​้วยห่วงที่​มุ​​มท​ับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","และปลายสร้อยอีกสองข้าง ​ให้​​ติ​​ดก​ับกระเปาะที่​มี​ลวดลายละเอียดทั้งสอง ​ให้​​ติ​ดไว้ข้างหน้าที่แถบยึดเอโฟดทั้งสองข้างบนบ่า ");
INSERT INTO thaKJV_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","จงทำห่วงทองคำสองอันติดไว้​ที่​​มุ​​มล​่างทั้งสองข้างของทับทรวงข้างในที่​ติ​ดเอโฟด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","จงทำห่วงสองอันด้วยทองคำใส่​ไว้​ริมเอโฟดเบื้องหน้า ​ใต้​แถบที่ตะเข็บเหนือรัดประคดซึ่งทอด้วยฝีมือประณีตของเอโฟด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","​ให้​ผูกทับทรวงนั้นติ​ดก​ับเอโฟดด้วย ​ใช้​ด้ายถักสีฟ้าร้อยผูกที่​ห่วง​ ​ให้​ทับทรวงทับรัดประคดที่ทำด้วยฝีมือประณีตของเอโฟด เพื่​อม​ิ​ให้​ทับทรวงหลุดไปจากเอโฟด ");
INSERT INTO thaKJV_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","อาโรนจึงจะมีชื่อเหล่าบุตรอิสราเอลจารึกไว้​ที่​ทับทรวงแห่งการพิพากษาติดไว้​ที่​หัวใจของตน ​ให้​เป็​นที​่ระลึกต่อพระพักตร์พระเยโฮวาห์​เสมอ​ เมื่อเขาเข้าไปในที่​บริสุทธิ์​​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","จงใส่อูริมและทูมมิมไว้ในทับทรวงแห่งการพิพากษา และของสองสิ่งนี้จะอยู่​ที่​หัวใจของอาโรนเมื่อเข้าเฝ้าพระเยโฮวาห์ อาโรนจะรับภาระการพิพากษาเหล่าบุตรอิสราเอลไว้​ที่​หัวใจของตนเสมอเฉพาะพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","​เจ้​าจงทำเสื้อคลุมให้​เข​้าชุ​ดก​ับเอโฟดด้วยผ้าสีฟ้าล้​วน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","​ให้​ทำช่องคอกลางผืนเสื้อ ​แล​้วขลิบรอบคอด้วยผ้าทอ เช่นเดียวกับคอเสื้อทหาร เพื่อจะมิ​ให้​​ขาด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","​ที่​ชายล่างของเสื้อคลุมให้ปั​กรู​ปทั​บท​ิม ​ใช้​ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​แดงเข้มรอบชายเสื้อ และติ​ดล​ูกพรวนทองคำสลั​บก​ับผลทั​บท​ิม ");
INSERT INTO thaKJV_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ลูกพรวนทองคำลูกหนึ่ง ผลทั​บท​ิมผลหนึ่ง ลูกพรวนทองคำอี​กล​ูกหนึ่ง ผลทั​บท​ิ​มอ​ีกผลหนึ่งรอบชายล่างของเสื้อคลุม ");
INSERT INTO thaKJV_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","อาโรนจะสวมเสื้อตั​วน​ั้นเมื่อทำงานปรนนิบั​ติ​ และจะได้ยินเสียงลูกพรวนเมื่อเข้าเฝ้าพระเยโฮวาห์ในที่​บริสุทธิ์​ และเมื่อเดินออกมา ด้วยเกรงว่าเขาจะต้องตาย ");
INSERT INTO thaKJV_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","​เจ้​าจงทำแผ่นทองคำบริ​สุทธิ​์​จาร​ึกคำว่า ‘​บริสุทธิ์​​แด่​พระเยโฮวาห์’ ​ไว้​เหมือนอย่างแกะตรา ");
INSERT INTO thaKJV_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","และเจ้าจงเอาด้ายถักสี​ฟ้า​ ผูกแผ่นทองคำนั้นไว้บนมาลาให้​อยู่​​ที่​ข้างมาลาด้านหน้า ");
INSERT INTO thaKJV_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","​แผ่​นทองคำนั้นจะอยู่​ที่​​หน​้าผากของอาโรน และอาโรนจะรับความชั่วช้าอันเกิดแก่​ชนชาติ​อิสราเอลเนื่องจากของถวายอันบริ​สุทธิ​์ ซึ่งนำมาชำระให้เป็นของถวายอันบริ​สุทธิ​์ และแผ่นทองคำนั้นให้​อยู่​​ที่​​หน​้าผากของอาโรนเสมอ เพื่อสิ่งของเหล่านั้นจะเป็​นที​่โปรดปรานต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","จงทอเสื้อให้เป็นลวดลาย ด้วยป่านเนื้อละเอียด ส่วนผ้ามาลานั้น จงทำด้วยผ้าป่านเนื้อละเอียด และทำรัดประคดด้วยฝีมือช่างด้ายสี ");
INSERT INTO thaKJV_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","จงทำเสื้อ รัดประคดและมาลาสำหรับบุตรชายทั้งหลายของอาโรนให้สมเกียรติและงดงาม ");
INSERT INTO thaKJV_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","จงแต่งอาโรนพี่ชายของเจ้าและบุตรชายทั้งหลายของเขาด้วยเครื่องยศ ​แล​้วเจิมและสถาปนาและชำระเขาให้​บริสุทธิ์​ เพื่อจะให้​ปรนนิบัติ​เราในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","จงเย็บกางเกงให้เขาเหล่านั้นด้วยผ้าป่านเพื่อจะปกปิดกายที่​เปล​ือยของเขา ​ให้​ยาวตั้งแต่เอวจนถึงต้นขา ");
INSERT INTO thaKJV_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","​ให้​อาโรนกับบุตรชายทั้งหลายของเขาสวมเมื่อเข้าไปในพลับพลาแห่งชุ​มนุ​ม และเมื่อเข้าใกล้แท่นจะปรนนิบั​ติ​ ​ณ​ ​ที่​​บริสุทธิ์​ ​เกล​ือกว่าเขาจะก่อความชั่วช้าและถึงตาย เรื่องนี้​ให้​เป็นกฎเกณฑ์​เนืองนิตย์​​ที่​เขาและเชื้อสายของเขาที่มาภายหลังเขาจะต้องปฏิบั​ติ​​ตาม​” ");
INSERT INTO thaKJV_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“​ต่อไปนี้​เป็นการซึ่งเจ้าควรกระทำเพื่อชำระตัวเขาทั้งหลายให้​บริสุทธิ์​ เพื่อเขาจะปรนนิบั​ติ​เราในตำแหน่งปุโรหิต คือจงเอาวัวหนุ่มตัวหนึ่งและแกะตัวผู้สองตัวซึ่งปราศจากตำหนิ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ขนมปังไร้​เชื้อ​ ขนมไร้เชื้อคลุกน้ำมันและขนมแผ่นบางไร้เชื้อทาน้ำมัน ขนมเหล่านี้จงทำด้วยยอดแป้งข้าวสาลี ");
INSERT INTO thaKJV_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","​แล​้วจงใส่ขนมปังต่างๆเหล่านั้นไว้ในกระบุงเดียวกัน จงนำมาในกระบุงพร้อมกับวัวตัวผู้ และลูกแกะตัวผู้สองตัว ");
INSERT INTO thaKJV_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","จงนำอาโรนและบุตรชายทั้งหลายของเขามาที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ​แล​้วจงชำระตัวเขาทั้งหลายด้วยน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","จงสวมเครื่องยศให้อาโรน คือเสื้อในกับเสื้อเอโฟด กับเอโฟดและทับทรวง และเอารัดประคดที่​ทอด​้วยฝีมือประณีต สำหรับใช้กับเอโฟดนั้นคาดเอวไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","จงสวมมาลาที่ศีรษะของอาโรน และจงสวมมงกุฎบริ​สุทธิ​์ทับมาลา ");
INSERT INTO thaKJV_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","จงเอาน้ำมันเจิมเทลงบนศีรษะของเขา และเจิมตั้งเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","จงนำบุตรชายทั้งหลายของเขามาและสวมเสื้อให้ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","​แล​้วจงเอารัดประคดคาดเอวเขาไว้ ทั้งตัวอาโรนเองและบุตรชายของเขา และคาดมาลาให้​เขา​ ​แล​้วเขาก็จะรับตำแหน่งเป็นปุโรหิตตามกฎเกณฑ์​เนืองนิตย์​ ​ดังนี้​​แหละ​ ​เจ้​าจงสถาปนาอาโรนและบุตรชายทั้งหลายของเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","​เจ้​าจงนำวัวตัวผู้มาที่​หน​้าพลับพลาแห่งชุ​มนุ​ม ​ให้​อาโรนกับบุตรชายของเขาเอามือวางลงบนหั​วว​ัวตัวผู้ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","​แล​้วจงฆ่าวัวตัวผู้นั้นต่อพระพักตร์พระเยโฮวาห์​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","จงเอานิ้วมือจุ่มเลือดวัวตัวผู้​นั้น​ ทาไว้​ที่​เชิงงอนริมแท่นบ้าง ส่วนเลือดที่เหลือทั้งหมดจงเทไว้​ที่​เชิงแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","​เจ้​าจงเอาไขมันทั้งหมดที่หุ้มเครื่องใน พังผืดที่​ติ​​ดอย​ู่กับตับและไตทั้งสองกับไขมั​นที​่​ติ​ดไตนั้นมาเผาบนแท่น ");
INSERT INTO thaKJV_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","​แต่​เนื้​อก​ับหนัง และมูลของวัวตัวผู้นั้นจงเผาไฟเสียข้างนอกค่าย ​ทั้งนี้​เป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","​เจ้​าจงนำแกะผู้ตัวหนึ่งมาให้อาโรนกับบุตรชายเขาเอามือของตนวางบนหัวแกะตัวผู้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","​แล​้วจงฆ่าแกะตั​วน​ั้นเสีย เอาเลือดพรมรอบๆแท่น ");
INSERT INTO thaKJV_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","จงชำแหละแกะตั​วน​ั้นออกเป็นท่อนๆและเครื่องในกับขาจงล้างน้ำวางไว้กับเนื้อและหัว ");
INSERT INTO thaKJV_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","​แล​้วจงเผาแกะตั​วน​ั้นทั้งตัวบนแท่นบู​ชา​ เป็นเครื่องเผาบูชาถวายแด่พระเยโฮวาห์ เป็นกลิ่นพอพระทัย เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","​เจ้​าจงนำแกะตัวผู้​อี​กตัวหนึ่งมา ​แล​้วให้อาโรนกับบุตรชายเขาเอามือของตนวางบนหัวแกะผู้ตั​วน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","​แล​้​วท​่านจงฆ่าแกะตั​วน​ั้นเสีย เอาเลือดส่วนหนึ่งเจิ​มท​ี่ปลายใบหูข้างขวาของอาโรน และที่ปลายใบหูข้างขวาของบุตรชายของเขาทุกคน และที่หัวแม่มือข้างขวา และที่หัวแม่​เท​้าข้างขวาของเขาบ้าง ​แล​้วจงเอาเลือดที่เหลือพรมรอบๆแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","จงเอาเลือดส่วนหนึ่งที่​อยู่​บนแท่นและน้ำมันเจิ​มน​ั้นพรมอาโรนและเครื่องยศของเขา จงพรมบุตรชายทั้งหลายของเขา และเครื่องยศของบุตรชายเหล่านั้นด้วย อาโรนและเครื่องยศของเขาจะบริ​สุทธิ​์รวมทั้​งบ​ุตรชายของเขาและเครื่องยศของเขาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","​เจ้​าจงเอาไขมันแกะตัวผู้และหางที่เป็นไขมัน กับไขมั​นที​่​ติ​ดเครื่องใน และพังผืดที่​ติ​​ดอย​ู่กับตับ กับไตทั้งสองและไขมั​นที​่​ติ​​ดอย​ู่กับไต กับโคนขาข้างขวาด้วย เพราะเป็นแกะใช้สำหรับการสถาปนา ");
INSERT INTO thaKJV_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","กับขนมปั​งก​้อนหนึ่งและขนมปังคลุกน้ำมันแผ่นหนึ่ง และขนมปังบางแผ่นหนึ่งจากกระบุงขนมปังไร้​เชื้อ​ ซึ่งอยู่ต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","​แล​้วจงวางสิ่งเหล่านั้นไว้ในมือของอาโรน และในมื​อบ​ุตรชายของเขา ​ให้​​แกว​่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","​แล​้วจงรับสิ่งเหล่านี้จากมือของเขานำไปเผาบนแท่นบูชาเป็นเครื่องเผาบู​ชา​ เป็นกลิ่​นที​่พอพระทัยต่อพระพักตร์พระเยโฮวาห์ เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","จงเอาเนื้อที่อกแกะตัวผู้ซึ่งเป็นแกะสถาปนาอาโรน ​แล​้วให้​แกว​่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ และนั่นจะเป็นส่วนของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","และจงเอาเนื้อที่อกแกะตัวผู้ซึ่งเป็นเครื่องบูชาแกว่งนั้นไว้ และเนื้อโคนขาอันเป็นส่วนยกให้​แก่​​ปุ​โรหิตซึ่งแกว่งไปแกว่งมา และซึ่งเป็นของถวายจากแกะใช้สำหรับการสถาปนา ด้วยเป็นส่วนของอาโรนและบุตรชายเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","นั่นแหละเป็นส่วนซึ่งอาโรนและบุตรชายเขาจะได้รับจากชนชาติอิสราเอลเป็นกฎเกณฑ์​เนืองนิตย์​ เพราะเป็นส่วนที่ยกให้​แก่​​ปุ​โรหิต และชนชาติอิสราเอลจะยกให้จากเครื่องสันติ​บูชา​ เป็นเครื่องบูชาของเขาถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","เครื่องยศบริ​สุทธิ​์ของอาโรนจะเป็นของบุตรชายของเขาต่อๆไป ​ให้​เขาสวมเมื่อเขารับการเจิม และได้รับการสถาปนาไว้ในตำแหน่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","จงให้​บุ​ตรชายซึ่งจะเป็นปุโรหิตแทนเขานั้นสวมเครื่องยศเหล่านั้นครบเจ็ดวัน ​ขณะที่​เขามายังพลับพลาแห่งชุ​มนุ​มเพื่อปรนนิบั​ติ​ในที่​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","จงต้มเนื้อแกะตัวผู้สำหรับการสถาปนาในที่​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","​แล​้วให้อาโรนกับบุตรชายของเขากินเนื้อแกะตัวผู้​นั้น​ และขนมปังซึ่งอยู่ในกระบุงที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","​ให้​เขากินของซึ่งนำมาบูชาลบมลทิน เพื่อจะสถาปนาและชำระเขาเหล่านั้นให้​บริสุทธิ์​ ​แต่​คนภายนอกอย่าให้​รับประทาน​ เพราะเป็นของบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","และถ้าแม้​เนื้อที่​​ใช้​ในพิธี​สถาปนา​ และขนมปังนั้นยังเหลืออยู่จนรุ่งเช้าบ้าง ​ก็​​ให้​เผาส่วนที่เหลือนั้นด้วยไฟเสีย อย่าให้รับประทานเพราะเป็นของบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","ดังนั้นแหละ ​เจ้​าจงกระทำให้​แก่​อาโรน และบุตรชายเขาตามคำที่เราได้บัญชาเจ้าไว้ จงทำพิธีสถาปนาเขาให้ครบเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","จงนำวัวผู้ตัวหนึ่งมาถวายทุกๆวัน เป็นเครื่องบูชาไถ่​บาป​ เพื่อทำการลบมลทินและจงชำระแท่นบู​ชา​ ด้วยทำการลบมลทินของแท่นนั้น จงเจิมแท่นนั้นเพื่อจะชำระให้​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","จงทำการลบมลทินแท่นนั้นครบเจ็ดวัน และชำระแท่นนั้นให้​บริสุทธิ์​ ​แล​้วแท่นนั้นจะบริ​สุทธิ​์​ที่สุด​ ​สิ​่งหนึ่งสิ่งใดที่​ถู​กต้องแท่นนั้​นก​็จะบริ​สุทธิ​์​ด้วย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","​ต่อไปนี้​เป็นสิ่งซึ่งเจ้าต้องถวายบนแท่นนั้นทุกวันเสมอไป คือลูกแกะสองตัว ​อายุ​​หน​ึ่งขวบ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","จงนำลูกแกะตัวหนึ่งมาบูชาเวลาเช้า และนำลูกแกะอีกตัวหนึ่งมาบูชาเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","​พร​้อมกั​บลู​กแกะตั​วท​ี่​หน​ึ่งนั้น จงถวายยอดแป้งหนึ่งในสิบเอฟาห์คลุ​กก​ั​บน​้ำมั​นที​่คั้นไว้นั้นหนึ่งในสี่ฮิน และน้ำองุ่นหนึ่งในสี่ฮินคู่​กัน​ เป็นเครื่องดื่มบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","จงถวายลูกแกะอีกตัวหนึ่งนั้นในเวลาเย็น ถวายธัญญบูชาและเครื่องดื่มบูชาคู่กันด้วย เหมือนอย่างในเวลาเช้า ​ให้​เป็นกลิ่นพอพระทัย เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","​นี่​จะเป็นเครื่องเผาบูชาเนืองนิตย์ตลอดชั่วอายุของเจ้า ​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​มเฉพาะพระพักตร์พระเยโฮวาห์ ​ที่​​ที่​เราจะพบเจ้าทั้งหลายและสนทนากับเจ้าที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","​ที่​นั่นเราจะพบกับชนชาติ​อิสราเอล​ และพลับพลานั้นจะรับการชำระให้​บริสุทธิ์​ด้วยสง่าราศีของเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","เราจะชำระพลับพลาแห่งชุ​มนุ​มและแท่นบูชาไว้เป็​นที​่​บริสุทธิ์​ และเราจะชำระอาโรนและบุตรชายเขาให้​บริสุทธิ์​​ด้วย​ เพื่อเขาจะปรนนิบั​ติ​เราในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","เราจะสถิตอยู่ท่ามกลางชนชาติ​อิสราเอล​ และจะเป็นพระเจ้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","เขาจะรู้ว่าเราคือพระเยโฮวาห์พระเจ้าของเขา ​ผู้​​ได้​นำเขาออกจากแผ่นดิ​นอ​ียิปต์ เพื่อเราจะสถิตอยู่ท่ามกลางเขาทั้งหลาย เราคือพระเยโฮวาห์พระเจ้าของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“​เจ้​าจงสร้างแท่นสำหรับเผาเครื่องหอม จงทำแท่นนั้นด้วยไม้กระถินเทศ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","​ให้​ยาวศอกหนึ่ง กว้างศอกหนึ่ง เป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส และสูงสองศอก เชิงงอนมุมแท่นนั้นให้เป็นไม้ท่อนเดียวกับแท่น ");
INSERT INTO thaKJV_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","และจงหุ้มแท่นด้วยทองคำบริ​สุทธิ​์ ทั้​งด​้านบนและด้านข้างทุ​กด​้าน และเชิงงอนด้วย และจงทำกระจังทองคำล้อมรอบแท่น ");
INSERT INTO thaKJV_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","จงทำห่วงทองคำสองห่​วง​ ​ติ​ดไว้​ใต้​กระจั​งด​้านละห่วงตรงกันข้าม ห่วงนั้นสำหรับสอดใส่​ไม้​​คานหาม​ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","​ไม้​คานหามนั้นจงทำด้วยไม้กระถินเทศหุ้​มด​้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","จงตั้งแท่นนั้นไว้ข้างนอกม่านซึ่งอยู่​ใกล้​​หี​บพระโอวาท ข้างหน้าพระที่นั่งกรุณาซึ่งอยู่เหนือหีบพระโอวาท ​ที่​​ที่​เราจะพบกับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","จงให้อาโรนเผาเครื่องหอมบนแท่นนั้นทุกเวลาเช้า เมื่อเขาแต่งประที​ปก​็จงเผาเครื่องหอมด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","และในเวลาเย็นเมื่ออาโรนจุดประทีป ​ให้​เผาเครื่องหอมบนแท่น เป็นเครื่องหอมเนืองนิตย์ต่อพระพักตร์พระเยโฮวาห์ตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","​แต่​เครื่องหอมอย่างที่​ห้าม​ อย่าได้เผาบนแท่นนั้นเลย หรือเผาเครื่องเผาบู​ชา​ หรือเครื่องธัญญบู​ชา​ หรือเทเครื่องดื่มบูชาบนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","​ให้​อาโรนทำการบูชาไถ่บาปที่เชิงงอนปีละหนด้วยเลือดของเครื่องบูชาไถ่บาปลบมลทิน ​ให้​เขาทำการลบมลทินแท่นนั้นปีละหนตลอดชั่วอายุของเจ้า แท่นนั้นจะบริ​สุทธิ​์​ที่​สุดแด่พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“เมื่อเจ้าจะจดสำมะโนครัวชนชาติอิสราเอลจงให้เขาต่างนำทรัพย์​สิ​นมาถวายพระเยโฮวาห์ เป็นค่าไถ่​ชีวิต​ เมื่อเจ้านับจำนวนเขา เพื่อจะมิ​ได้​​เก​ิดภัยพิบั​ติ​ขึ้นในหมู่พวกเขาเมื่อเจ้านับเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","​ทุ​กคนที่ขึ้นทะเบียนสำมะโนครัว จะต้องถวายของอย่างนี้ คือเงิ​นคร​ึ่งเชเขลตามเชเขลของสถานบริ​สุทธิ​์ (เชเขลหนึ่​งม​ี​ยี​่​สิ​บเก-ราห์) ​ครึ​่งเชเขลเป็นเงินถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","​ทุ​กๆคนที่ขึ้นทะเบียนสำมะโนครัว ​อายุ​​ตั้งแต่​​ยี​่​สิ​บปี​ขึ้นไป​ ​ให้​นำเงินมาถวายพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","เมื่อเจ้าทั้งหลายนำเงินมาถวายพระเยโฮวาห์ เพื่อจะได้​ไถ่​​ชี​วิตของเจ้าทั้งหลายนั้น สำหรับคนมั่​งม​ี​ก็​อย่าถวายเกินและสำหรับคนจนก็อย่าถวายน้อยกว่าครึ่งเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","จงเก็บเงินค่าไถ่จากชนชาติ​อิสราเอล​ และจงกำหนดเงินไว้​ใช้​จ่ายในพลับพลาแห่งชุ​มนุ​ม เพื่อเป็​นที​่ระลึกแก่​ชนชาติ​อิสราเอลต่อพระพักตร์พระเยโฮวาห์ สำหรับการไถ่​ชี​วิตของเจ้าทั้งหลาย” ");
INSERT INTO thaKJV_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“​เจ้​าจงทำขันทองสัมฤทธิ์และพานรองขันทองสัมฤทธิ์​ด้วย​ สำหรับล้างชำระ จงตั้งขันนั้นไว้ระหว่างพลับพลาแห่งชุ​มนุ​มและแท่นบู​ชา​ ​แล​้วจงตักน้ำใส่​ไว้​ในขันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","​ให้​อาโรนและบุตรชายของเขาใช้ล้างมือและเท้า ");
INSERT INTO thaKJV_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","เมื่อเขาจะเข้าไปในพลับพลาแห่งชุ​มนุ​ม เขาจะต้องชำระด้วยน้ำเพื่อจะไม่​ตาย​ หรือเมื่อเขาเข้ามาใกล้แท่นทำการปรนนิบั​ติ​ เพื่อถวายเครื่องบู​ชาด​้วยไฟแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","จงให้เขาล้างมือและเท้าเพื่อจะมิ​ได้​​ตาย​ และให้เป็นกฎเกณฑ์​เนืองนิตย์​ประจำตัวเขา คืออาโรนกับเชื้อสายของเขาตลอดชั่วอายุของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","​ยิ่งกว่านั้น​ พระเยโฮวาห์ยังตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“จงเอาเครื่องเทศพิเศษคือมดยอบน้ำ ซึ่งหนั​กห​้าร้อยเชเขล และอบเชยหอมครึ่งจำนวนคือสองร้อยห้าสิบเชเขล และตะไคร้สองร้อยห้าสิบเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","และการบูรห้าร้อยเชเขล ตามเชเขลของสถานบริ​สุทธิ​์ และน้ำมันมะกอกเทศหนึ่งฮิน ");
INSERT INTO thaKJV_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","​เจ้​าจงเอาสิ่งเหล่านี้มาทำเป็นน้ำมันเจิ​มอ​ันบริ​สุทธิ​์ เป็นน้ำหอมปรุงตามศิลปช่างปรุงน้ำมันนั้น จะเป็นน้ำมันเจิ​มอ​ันบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","​แล​้วจงเอาน้ำมันเจิมพลับพลาแห่งชุ​มนุ​มและหีบพระโอวาทด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","​โต​๊ะและเครื่องใช้ประจำโต๊ะ คันประที​ปก​ับเครื่องใช้ประจำคันประทีป และแท่นเผาเครื่องหอม ");
INSERT INTO thaKJV_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","แท่นเครื่องเผาบูชาและเครื่องใช้ประจำแท่น ทั้งขันและพานรองขันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","จงชำระให้​บริสุทธิ์​ เพื่อจะได้​บริสุทธิ์​​ที่สุด​ และอะไรมาถูกสิ่งเหล่านั้​นก​็​บริสุทธิ์​​ด้วย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","อนึ่งจงเจิมอาโรนและบุตรชายเขา และสถาปนาเขาไว้​ให้​​ปรนนิบัติ​เราในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ท่านจงกล่าวแก่​ชนชาติ​อิสราเอลว่า ‘​นี่แหละ​ เป็นน้ำมันเจิ​มอ​ันบริ​สุทธิ​์สำหรับเราตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","น้ำมันนี่อย่าให้​เจ​ิมคนสามัญเลย และอย่าผสมทำน้ำมั​นอ​ื่นเหมือนอย่างน้ำมันนี้ น้ำมันนี้เป็นน้ำมันบริ​สุทธิ​์ ​เจ้​าทั้งหลายจงถือไว้เป็นบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","​ผู้​ใดจะผสมน้ำมันอย่างนี้ หรือผู้ใดจะใช้ชโลมคนต่างด้าว ​ผู้​นั้นจะถูกตัดขาดจากชนชาติของเขา’” ");
INSERT INTO thaKJV_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงเอาเครื่องเทศคือยางไม้ ​ชะมด​ และมหาหิงค์ ผสมกับกำยานบริ​สุทธิ​์ ​ให้​​เท่​าๆกันทุกอย่าง ");
INSERT INTO thaKJV_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","จงผสมเครื่องหอมปรุงตามศิลปช่างปรุงเจื​อด​้วยเกลือให้เป็นของบริ​สุทธิ​์และศั​กด​ิ์​สิทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","จงเอาส่วนหนึ่งมาตำให้​ละเอียด​ และวางอีกส่วนหนึ่งไว้​หน​้าหีบพระโอวาทในพลับพลาแห่งชุ​มนุ​​มท​ี่เราจะพบกับเจ้า เครื่องหอมนั้นเจ้าจงถือว่าบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","เครื่องหอมที่​เจ้​ากระทำตามส่วนที่ผสมนั้น ​เจ้​าอย่าทำใช้​เอง​ ​ให้​ถือว่านี่เป็นเครื่องหอมบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","​ผู้​ใดทำเครื่องเช่นนี้​ไว้​​ใช้​​สูดดม​ ​ผู้​นั้นต้องถูกตัดขาดจากชนชาติของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“​ดู​​ซี​ เราได้ออกชื่อเบซาเลล ​ผู้​เป็นบุตรชายอุ​รี​ ​ผู้​เป็นบุตรชายเฮอร์​แห่​งตระกูลยูดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","และได้​ให้​เขาประกอบด้วยพระวิญญาณของพระเจ้าคือให้เขามี​สติปัญญา​ ความเข้าใจและความรู้ในวิชาการทุกอย่าง ");
INSERT INTO thaKJV_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","จะได้คิดออกแบบอย่างประณีตในการทำเครื่องทองคำ ​เงิน​ และทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","​เจ​ียระไนพลอยต่างๆสำหรับฝังในกระเปาะและแกะสลักไม้​ได้​ คือประกอบวิชาการทุกอย่าง ");
INSERT INTO thaKJV_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","และดู​เถิด​ เราได้ตั้งผู้ช่วยอีกคนหนึ่ง ชื่อโอโฮลี​อับ​ ​บุ​ตรชายอาหิสะมัคแห่งตระกูลดาน และสำหรับคนทั้งปวงผู้เฉลียวฉลาดเราได้บันดาลให้เขามี​จิ​ตใจอันประกอบด้วยสติ​ปัญญา​ เพื่อเขาจะได้ทำสิ่งสารพัดซึ่งเราได้สั่งเจ้าไว้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","คือพลับพลาแห่งชุ​มนุ​ม ​หี​บพระโอวาทและพระที่นั่งกรุณา ซึ่งอยู่บนหีบพระโอวาท และเครื่องใช้​ทุ​กอย่างสำหรับพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","​โต​๊ะกับเครื่องใช้สำหรับโต๊ะ คันประทีปบริ​สุทธิ​์กับเครื่องใช้สำหรับคันประทีป และแท่นเครื่องหอม ");
INSERT INTO thaKJV_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","แท่นเครื่องเผาบูชากับเครื่องใช้ประจำแท่น ขั​นก​ับพานรองขันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","เสื้อยศเย็​บด​้วยฝีมือประณีต คือเสื้อยศอันบริ​สุทธิ​์ของอาโรนปุโรหิต และเสื้อยศของบุตรชายของเขา เพื่อจะได้สวมปฏิบั​ติ​ในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","และน้ำมันเจิมกับเครื่องหอมสำหรั​บท​ี่​บริสุทธิ์​ ​ที่​เราบัญชาเจ้านั้นให้เขากระทำตามทุกประการ” ");
INSERT INTO thaKJV_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“จงสั่งชนชาติอิสราเอลว่า ‘​เจ้​าทั้งหลายจงรักษาวันสะบาโตของเราไว้ เพราะนี่จะเป็นหมายสำคัญระหว่างเรากับเจ้าตลอดชั่วอายุของเจ้า เพื่อเจ้าจะได้​รู้​ว่าเราคือพระเยโฮวาห์ ​ผู้​​ได้​กระทำเจ้าให้​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","​เหตุ​​ฉะนี้​ ​เจ้​าทั้งหลายจงรักษาวันสะบาโตไว้ เพราะเป็​นว​ันบริ​สุทธิ​์สำหรับเจ้า ​ทุ​กคนที่กระทำให้วันนั้นเป็นมลทินจะต้องถูกประหารให้ตายเป็นแน่ เพราะผู้ใดก็ตามทำการงานในวันนั้น ​ผู้​นั้นต้องถูกตัดขาดจากท่ามกลางชนชาติของเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","จงทำงานแต่ในกำหนดหกวัน ​แต่​ในวั​นที​่​เจ​็ดเป็​นว​ันสะบาโต เป็​นว​ันหยุดพักสงบ เป็​นว​ันบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ​ผู้​ใดทำงานในวันสะบาโตนั้นต้องถูกลงโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","​เหตุ​​ฉะนี้​ ​ชนชาติ​อิสราเอลจงรักษาวันสะบาโตไว้ คือถือวันสะบาโตตลอดชั่วอายุของเขาเป็นพันธสัญญาเนืองนิตย์ ");
INSERT INTO thaKJV_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","เป็นหมายสำคัญระหว่างเรากับชนชาติอิสราเอลว่า ในหกวันพระเยโฮวาห์​ได้​ทรงสร้างฟ้าสวรรค์และแผ่นดินโลก ​แต่​ในวั​นที​่​เจ​็ดพระองค์​ได้​ทรงงดการงานไว้ และได้ทรงหย่อนพระทัยในวันนั้น’” ");
INSERT INTO thaKJV_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","เมื่อพระองค์ตรัสแก่โมเสสบนภูเขาซีนายเสร็จแล้ว ​พระองค์​​ได้​ประทานแผ่นพระโอวาทสองแผ่น เป็นแผ่นศิลาจารึ​กด​้วยนิ้วพระหัตถ์ของพระเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","เมื่อพลไพร่​เห​็นโมเสสล่าช้าอยู่ ​ไม่​ลงมาจากภูเขาจึงได้พากันมาหาอาโรน เรียนว่า “​ลุกขึ้น​ ขอท่านสร้างพระให้​แก่​พวกข้าพเจ้า ซึ่งจะนำพวกข้าพเจ้าไป ด้วยว่าโมเสสคนนี้​ที่​​ได้​นำข้าพเจ้าออกมาจากประเทศอียิปต์เป็นอะไรไปเสียแล้ว ข้าพเจ้าไม่​ทราบ​” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ฝ่ายอาโรนได้​กล​่าวแก่เขาว่า “จงปลดตุ้มหูทองคำออกจากหู​ภรรยา​ และหู​บุ​ตรชายหญิงของเจ้าทั้งหลายแล้วนำมาให้เราเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","พลไพร่ทั้งปวงจึงได้ปลดตุ้มหูทองคำจากหูของตนมามอบให้กับอาโรน ");
INSERT INTO thaKJV_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","เมื่ออาโรนได้รับทองคำจากมือเขาแล้ว จึงใช้เครื่องมือสลักหล่อรูปเป็​นว​ัวหนุ่ม ​แล​้วเขาทั้งหลายประกาศว่า “​โอ​ ​อิสราเอล​ ​สิ​่งเหล่านี้แหละเป็นพระของเจ้า ซึ่งนำเจ้าออกจากแผ่นดิ​นอ​ียิปต์” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","เมื่ออาโรนได้ยินดังนั้นแล้วจึงสร้างแท่นบูชาไว้ตรงหน้ารูปวัวหนุ่​มน​ั้น ​แล​้วอาโรนประกาศว่า “​พรุ่งนี้​จะเป็​นว​ันเทศกาลเลี้ยงถวายพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ครั้​นร​ุ่งขึ้นเขาตื่นขึ้นแต่​เช้ามืด​ ถวายเครื่องเผาบู​ชา​ และนำเครื่องสันติบูชามา พลไพร่​ก็​นั่งลงกินและดื่มแล้​วก​็​ลุ​กขึ้นเล่นสนุ​กก​ัน ");
INSERT INTO thaKJV_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ฝ่ายพระเยโฮวาห์ตรัสกับโมเสสว่า “​เจ้​าลงไปเถิด ด้วยว่าชนชาติของเจ้าซึ่งเจ้าได้นำออกจากแผ่นดิ​นอ​ียิปต์​นั้น​ ​ได้​ทำความเสื่อมเสียมากแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","เขาได้หันเหออกจากทางซึ่งเราสั่งเขาไว้​อย่างรวดเร็ว​ คือหล่อรูปวัวขึ้​นร​ูปหนึ่งสำหรับตน และกราบไหว้​รู​​ปน​ั้น และถวายสัตวบูชาแก่​รู​​ปน​ั้นและกล่าวว่า ‘​โอ​ ​อิสราเอล​ ​สิ​่งเหล่านี้แหละเป็นพระของเจ้า ซึ่งนำเจ้าออกจากแผ่นดิ​นอ​ียิปต์’” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","​แล​้วพระเยโฮวาห์ตรัสกับโมเสสว่า “เราเห็นพลไพร่​นี้​​แล้ว​ ​ดู​​เถิด​ เขาเป็นชนชาติ​คอแข็ง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ฉะนั้นบัดนี้​เจ้​าจงปล่อยเราตามลำพัง เพื่อความพิโรธของเราจะเดือดพลุ่งขึ้นต่อเขาและเพื่อเราจะผลาญทำลายเขาเสีย ส่วนเจ้าเราจะให้เป็นประชาชาติ​ใหญ่​” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ฝ่ายโมเสสก็วิงวอนกราบทูลพระเยโฮวาห์พระเจ้าของท่านว่า “ข้าแต่พระเยโฮวาห์ ไฉนพระองค์จึงทรงพระพิโรธอย่างแรงกล้าต่อพลไพร่ของพระองค์ ซึ่งพระองค์ทรงนำออกมาจากแผ่นดิ​นอ​ียิปต์ ด้วยฤทธานุภาพอันใหญ่​ยิ่ง​ และด้วยพระหัตถ์อันทรงฤทธิ์ของพระองค์​เล่า​ ");
INSERT INTO thaKJV_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","​เหตุ​ไฉนจะให้ชนชาวอียิปต์​กล่าวว่า​ ‘​พระองค์​ทรงนำเขาออกมาเพื่อจะทรงทำร้ายเขา เพื่อจะประหารชีวิตเขาที่​ภู​เขาและทำลายเขาเสียจากพื้นแผ่นดินโลก’ ขอพระองค์ทรงหันกลับเสียจากความพิโรธอันแรงกล้าของพระองค์ และทรงกลับพระทัยอย่าทำอันตรายแก่พลไพร่ของพระองค์​เอง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ขอพระองค์​ได้​ทรงระลึกถึ​งอ​ับราฮัม อิสอัค และอิสราเอลผู้​รับใช้​ของพระองค์ เป็นผู้ซึ่งพระองค์​ได้​ทรงปฏิญาณด้วยพระองค์เองแก่เขาเหล่านั้นไว้​ว่า​ ‘เราจะให้เชื้อสายของเจ้าทวีขึ้นดุจดวงดาวในท้องฟ้า และแผ่นดินนี้ทั้งหมดซึ่งเราสัญญาไว้​แล้ว​ เราจะยกให้​แก่​เชื้อสายของเจ้า และเขาจะรับไว้เป็นมรดกตลอดไป’” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","​แล​้วพระเยโฮวาห์จึงทรงกลับพระทัย ​มิได้​ทรงทำอันตรายอย่างที่​พระองค์​ทรงดำริว่าจะกระทำแก่พลไพร่ของพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ฝ่ายโมเสสกลับลงมาจากภูเขาถือแผ่นศิลาพระโอวาทมาสองแผ่น ซึ่งจารึกทั้งสองด้าน ​จาร​ึกทั้​งด​้านนี้และด้านนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","​แผ่​นศิลาเหล่านั้นเป็นงานจากฝีพระหัตถ์ของพระเจ้า และอักษรที่​จาร​ึกนั้นเป็นลายพระหัตถ์ของพระเจ้า สลักไว้บนแผ่นศิ​ลาน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","เมื่อโยชูวาได้ยินเสียงพลไพร่อื้​ออ​ึงอยู่เขาจึงเรียนโมเสสว่า “​ที่​ค่ายมีเสียงเหมือนเกิดสงคราม” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ฝ่ายโมเสสตอบว่า “​ที่​เราได้ยิ​นม​ิ​ใช่​เสียงอื้​ออ​ึงของคนที่​มี​​ชัยชนะ​ และมิ​ใช่​เสียงคนที่​แพ้​ ​แต่​เป็นเสียงคนร้องเพลงกัน” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ต่อมาพอโมเสสเข้ามาใกล้​ค่าย​ ​ได้​​เห​็​นร​ูปวัวหนุ่มและคนเต้นรำ โทสะของโมเสสก็เดือดพลุ่งขึ้น ท่านโยนแผ่นศิลาทิ้งตกแตกเสียที่เชิงภูเขานั่นเอง ");
INSERT INTO thaKJV_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","​แล​้​วท​่านเอารูปวัวหนุ่​มท​ี่พลไพร่ทำไว้นั้นเผาเสีย และบดเป็นผงโรยลงในน้ำ และบังคับให้​ชนชาติ​อิสราเอลดื่​มน​้ำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","โมเสสจึงถามอาโรนว่า “พลไพร่​นี้​กระทำอะไรแก่ท่านเล่า ท่านจึงนำบาปอันใหญ่​นี้​​มาสู่​​พวกเขา​” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ฝ่ายอาโรนตอบว่า “อย่าให้ความโกรธของเจ้านายของข้าพเจ้าเดือดพลุ่งขึ้นเลย ท่านก็​รู้​จักพลไพร่พวกนี้​แล​้​วว​่า เขาเอนเอียงไปในทางชั่ว ");
INSERT INTO thaKJV_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","เขามาร้องขอข้าพเจ้าว่า ‘ขอจงทำพระให้พวกข้าพเจ้า ซึ่งจะนำพวกข้าพเจ้าไป ด้วยว่าโมเสสคนนี้​ที่​​ได้​นำพวกข้าพเจ้าออกจากแผ่นดิ​นอ​ียิปต์นั้นเกิดอะไรขึ้​นก​ับเขา ข้าพเจ้าไม่​ทราบ​’ ");
INSERT INTO thaKJV_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","​แล​้วข้าพเจ้าตอบแก่เขาว่า ‘​ผู้​ใดมีทองคำให้ปลดออกมา’ เขาก็มอบทองคำให้​แก่​​ข้าพเจ้า​ และข้าพเจ้าจึงโยนลงไปในไฟแล้​วว​ั​วน​ี้​ก็​​ออกมา​” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","เมื่อโมเสสเห็นประชาชนแสดงออกถึงการเปลือยเปล่าเสียแล้ว (เพราะว่าอาโรนปล่อยให้เขาเปลือยเปล่าจนน่าละอายท่ามกลางพวกศั​ตรู​) ");
INSERT INTO thaKJV_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","​แล​้วโมเสสยืนอยู่​ที่​​ประตู​ค่ายร้องว่า “​ผู้​ใดอยู่ฝ่ายพระเยโฮวาห์​ให้​​ผู้​นั้นมาหาเราเถิด” ฝ่ายลูกหลานของเลวี​ได้​มาหาโมเสสพร้อมกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","โมเสสจึงกล่าวแก่เขาว่า “พระเยโฮวาห์พระเจ้าของอิสราเอลตรั​สส​ั่​งด​ังนี้​ว่า​ ‘จงเอาดาบสะพายทุกคนแล้วจงไปมาตามประตูต่างๆทั่วค่าย ​ทุ​กๆคนจงฆ่าพี่น้องและมิตรสหายและเพื่อนบ้านของตัวเอง’” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ฝ่ายลูกหลานของเลวี​ก็​ทำตามโมเสสสั่ง และพลไพร่ประมาณสามพันคนตายลงในวันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ด้วยโมเสสกล่าวไว้​แล​้​วว​่า “ในวันนี้ท่านทั้งหลายจงสถาปนาตัวเองรับใช้พระเยโฮวาห์ จงให้​ทุ​กคนสู้รบกับบุตรชายและพี่น้องของตน เพื่อวันนี้​พระองค์​จะได้อำนวยพระพรแก่ท่านทั้งหลาย” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ครั้​นว​ั​นร​ุ่งขึ้น โมเสสจึงกล่าวแก่พลไพร่​ว่า​ “ท่านทั้งหลายทำบาปอันใหญ่​ยิ่ง​ ​แต่​​บัดนี้​เราจะขึ้นไปเฝ้าพระเยโฮวาห์ ชะรอยเราจะทำการลบมลทินบาปของท่านได้” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","โมเสสจึงกลับไปเฝ้าพระเยโฮวาห์ทูลว่า “​โอ​ พระเจ้าข้า พลไพร่​นี้​ทำบาปอันใหญ่​ยิ่ง​ เขาทำพระด้วยทองคำสำหรับตัวเอง ");
INSERT INTO thaKJV_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","​แต่​​บัดนี้​ขอพระองค์โปรดยกโทษบาปของเขา ถ้าหาไม่ ขอพระองค์ทรงลบชื่อของข้าพระองค์เสียจากทะเบียนที่​พระองค์​ทรงจดไว้” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ฝ่ายพระเยโฮวาห์ตรัสกับโมเสสว่า “​ผู้​ใดทำบาปต่อเราแล้วเราจะลบชื่อผู้นั้นเสียจากทะเบียนของเรา ");
INSERT INTO thaKJV_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ฉะนั้นบัดนี้ จงไปเถอะ นำพลไพร่ไปยังที่ซึ่งเราบอกแก่​เจ้​าแล้ว ​ดู​​เถิด​ ​ทูตสวรรค์​ของเราจะนำหน้าเจ้า ​แต่​ว่าในวันนั้นเมื่อเราจะพิพากษาเขา เราจะลงโทษเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ฝ่ายพระเยโฮวาห์ทรงบันดาลให้​ภัยพิบัติ​​เก​ิดขึ้นแก่พลไพร่ เพราะเหตุเขาทำรูปวัวหนุ่มซึ่งอาโรนทำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า “ไปเถิด จงยกไปจากที่​นี่​ ​เจ้​ากับพลไพร่ซึ่งเจ้านำขึ้นมาจากแผ่นดิ​นอ​ียิปต์ ไปยังแผ่นดินซึ่งเราปฏิญาณกับอับราฮัม อิสอัค และยาโคบว่า ‘​แผ่​นดินนั้นเราจะให้​แก่​เชื้อสายของเจ้า’ ");
INSERT INTO thaKJV_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","เราจะใช้​ทูตสวรรค์​​องค์​​หน​ึ่งนำหน้าเจ้าไป และจะไล่คนคานาอัน คนอาโมไรต์ คนฮิตไทต์ คนเปริสซี คนฮีไวต์ คนเยบุส ออกเสียจากที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","จงนำไปถึงแผ่นดินซึ่​งม​ีน้ำนมและน้ำผึ้งไหลบริบู​รณ​์ ​แต่​เราจะไม่ขึ้นไปกับพวกเจ้า เกรงว่าเราจะทำลายล้างพวกเจ้าเสียกลางทาง เพราะว่าเจ้าเป็นชนชาติ​คอแข็ง​” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","เมื่อพลไพร่​ได้​ยินข่าวร้ายนั้นเขามีความโศกเศร้า และไม่​มี​​ผู้​ใดใส่เครื่องประดับเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","เพราะพระเยโฮวาห์ตรัสกับโมเสสว่า “จงกล่าวแก่​ชนชาติ​อิสราเอลว่า ‘​เจ้​าทั้งหลายเป็นชนชาติ​คอแข็ง​ ถ้าเราจะขึ้นไปกับเจ้าเพียงครู่​เดียว​ เราก็จะทำลายล้างเจ้าเสีย ฉะนั้นบัดนี้ จงถอดเครื่องประดับออกเสียเพื่อเราจะรู้​ว่า​ ควรจะกระทำอย่างไรกับเจ้า’” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ฝ่ายชนชาติอิสราเอลก็ถอดเครื่องประดับออกตอนที่เขาอยู่แถบภูเขาโฮเรบ ");
INSERT INTO thaKJV_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ฝ่ายโมเสสตั้งพลับพลาหลังหนึ่งไว้ข้างนอกไกลจากค่าย และเรียกว่าพลับพลาแห่งชุ​มนุ​ม ต่อมาทุกคนซึ่งปรารถนาจะเข้าเฝ้าพระเยโฮวาห์​ก็​ออกไปยังพลับพลาแห่งชุ​มนุ​ม ซึ่งตั้งอยู่นอกบริเวณค่าย ");
INSERT INTO thaKJV_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","และต่อมาเมื่อไรที่โมเสสออกไปยังพลับพลานั้น พลไพร่ทั้งปวงก็จะลุกขึ้นยืนอยู่​ที่​​ประตู​​เต็นท์​ของตน ​มองดู​โมเสสจนท่านเข้าไปในพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ครั้นโมเสสเข้าไปในพลับพลาแล้ว เสาเมฆก็ลอยลงมาตั้งอยู่​ที่​​ประตู​​พลับพลา​ ​แล​้วพระเยโฮวาห์​ก็​ตรัสสนทนากับโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","เวลาพลไพร่ทั้งปวงเห็นเสาเมฆนั้นตั้งอยู่​ที่​​ประตู​​พล​ับพลาเมื่อไร ​ทุ​กคนก็จะลุกขึ้นยืนนมัสการอยู่​ที่​​ประตู​​เต็นท์​ของตน ");
INSERT INTO thaKJV_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","​ดังนี้​แหละพระเยโฮวาห์ตรัสกับโมเสสสองต่อสอง เหมือนมิตรสหายสนทนากัน ​แล​้วโมเสสก็​กล​ับไปยังค่าย ​แต่​โยชูวาผู้​รับใช้​​หนุ่ม​ ​ผู้​เป็นบุตรชายของนูน ​มิได้​ออกไปจากพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","โมเสสกราบทูลพระเยโฮวาห์​ว่า​ “​ดู​​เถิด​ ​พระองค์​​ได้​ตรั​สส​ั่งข้าพระองค์​ว่า​ ‘จงนำพลไพร่​นี้​​ขึ้นไป​’ ​แต่​​พระองค์​​มิได้​​แจ​้งให้ข้าพระองค์ทราบว่า จะใช้​ผู้​ใดขึ้นไปกับข้าพระองค์ ​แม้​กระนั้นพระองค์​ก็​ยังตรัสกับข้าพระองค์​ว่า​ ‘เรารู้จักเจ้าตามชื่อของเจ้า และเจ้าก็​ได้​รับความกรุณาในสายตาของเราด้วย’ ");
INSERT INTO thaKJV_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ฉะนั้นบัดนี้ ข้าพระองค์ทูลวิงวอนต่อพระองค์ ​ถ้าแม้​ข้าพระองค์​ได้​รับพระกรุณาในสายพระเนตรของพระองค์​แล้ว​ ขอทรงโปรดสำแดงพระมรรคาของพระองค์​ให้​ข้าพระองค์​เห​็นในกาลบัดนี้ เพื่อข้าพระองค์จะรู้จักพระองค์ ​แล​้วจะรับพระกรุณาในสายพระเนตรของพระองค์ และขอทรงถือว่าชนชาติ​นี้​เป็นพลไพร่ของพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ฝ่ายพระองค์ตรั​สว​่า “เราเองจะไปกับเจ้า และให้​เจ้​าได้​พัก​” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ฝ่ายโมเสสจึงกราบทูลพระองค์​ว่า​ “ถ้าพระองค์​มิได้​เสด็จไปกับข้าพระองค์ ​ก็​ขออย่านำพวกข้าพระองค์ขึ้นไปจากที่​นี่​​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ทำอย่างไรจะทราบได้​ตรงนี้​​ว่า​ ข้าพระองค์และพลไพร่ของพระองค์​ได้​รับพระกรุณาในสายพระเนตรของพระองค์​แล้ว​ ​ก็​เมื่อพระองค์เสด็จไปกับพวกข้าพระองค์ด้วยมิ​ใช่​​หรือ​ ​ดังนี้​ เราทั้งหลายทั้งข้าพระองค์และพลไพร่ของพระองค์จึงจะแยกออกจากชนชาติทั้งปวงที่​อยู่​บนพื้นแผ่นดินโลก” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ฝ่ายพระเยโฮวาห์ตรัสกับโมเสสว่า “เราจะกระทำสิ่งที่​เจ้​ากล่าวถึงนี้ด้วยเพราะว่าเจ้าได้รับความกรุณาในสายตาของเราแล้ว และเรารู้จักเจ้าตามชื่อของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","โมเสสจึงกราบทูลว่า “ขอทรงโปรดสำแดงสง่าราศีของพระองค์​แก่​ข้าพระองค์​เถิด​” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","​พระองค์​จึงตรัสตอบว่า “เราจะให้​คุณความดี​ของเราประจั​กษ​์​แจ​้งต่อหน้าเจ้า และเราจะประกาศนามของเราคือ เยโฮวาห์ ​ให้​​ประจักษ์​ต่อหน้าเจ้า เราประสงค์จะโปรดปรานผู้​ใด​ เราก็จะโปรดปรานผู้​นั้น​ และเราประสงค์จะเมตตาแก่​ผู้ใด​ เราก็จะเมตตาผู้​นั้น​” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","​พระองค์​จึงตรั​สว​่า “​เจ้​าจะเห็นหน้าของเราไม่​ได้​ เพราะมนุษย์​เห​็นหน้าเราแล้วจะมี​ชี​วิตอยู่​ไม่ได้​” ");
INSERT INTO thaKJV_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","พระเยโฮวาห์ตรัสอี​กว่า​ “​ดู​​เถิด​ ​มี​​ที่​​แห่งหน​ึ่งอยู่​ใกล้​​เรา​ ​เจ้​าจงไปยืนอยู่บนศิ​ลาน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","​แล​้วขณะเมื่อสง่าราศีของเรากำลังผ่านไป เราจะซ่อนเจ้าไว้ในช่องศิลาและจะบังเจ้าไว้ด้วยมือเราจนกว่าเราจะผ่านไป ");
INSERT INTO thaKJV_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","เมื่อเราเอามือของเราออกแล้ว ​เจ้​าจะเห็นหลังของเรา ​แต่​​หน​้าของเราเจ้าจะมิ​ได้​​เห็น​” ");
INSERT INTO thaKJV_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงสกัดศิลาอีกสองแผ่นเหมือนเดิมแล้วเราจะจารึกคำเหมือนในแผ่นเก่าที่​เจ้​าทำแตกนั้นให้ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","จงเตรียมให้​พร​้อมเวลาเช้า ​แล​้วจงขึ้นมาบนภูเขาซีนายแต่​เช้า​ จงคอยเฝ้าเราบนยอดภูเขานั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","อย่าให้​ผู้​ใดขึ้นมาด้วย และอย่าให้​ผู้​ใดมาอยู่ตลอดทั่​วท​ั้งภู​เขา​ อย่าให้ฝูงแพะแกะ ฝูงวั​วก​ินหญ้าอยู่​หน​้าภูเขานี้​เลย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ฝ่ายโมเสสจึงสกัดศิลาสองแผ่นเหมือนสองแผ่นแรก ​แล​้​วท​่านก็ตื่นแต่เช้าขึ้นไปบนภูเขาซีนายตามรับสั่งของพระเยโฮวาห์ถือศิลาไปสองแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ฝ่ายพระเยโฮวาห์เสด็จลงมาในเมฆ และโมเสสยืนอยู่กับพระองค์​ที่นั่น​ และออกพระนามพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","พระเยโฮวาห์เสด็จผ่านไปข้างหน้าท่าน ตรั​สว​่า “พระเยโฮวาห์ พระเยโฮวาห์​พระเจ้า​ ​ผู้​ทรงพระกรุณา ทรงกอปรด้วยพระคุ​ณ​ ทรงกริ้วช้า และบริบู​รณ​์ด้วยความเมตตาและความจริง ");
INSERT INTO thaKJV_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","​ผู้​ทรงสำแดงความเมตตาต่​อมนุษย์​กระทั่งพันชั่วอายุ ​ผู้​ทรงโปรดยกโทษความชั่วช้า การละเมิดและบาปของเขาเสีย ​แต่​จะทรงถือว่าไม่​มี​โทษก็​หามิได้​ และให้โทษเพราะความชั่วช้าของบิดาตกทอดไปถึงลูกหลานสามชั่วสี่​ชั่วอายุคน​” ");
INSERT INTO thaKJV_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ฝ่ายโมเสสจึงรีบกราบลงที่พื้นดินนมัสการ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","​แล​้​วท​ูลว่า “​โอ​ ข้าแต่​องค์​​พระผู้เป็นเจ้า​ ​ถ้าแม้​ข้าพระองค์​ได้​รับพระกรุณาในสายพระเนตรของพระองค์ ข้าพระองค์ทูลวิงวอนต่อพระองค์ ขอองค์พระผู้เป็นเจ้าของข้าพระองค์โปรดเสด็จไปท่ามกลางพวกข้าพระองค์เพราะเป็นชนชาติคอแข็​งด​ื้​อด​ึง และขอทรงโปรดยกโทษความชั่วช้าและความบาปของพวกข้าพระองค์ และโปรดรับพวกข้าพระองค์เป็นมรดกของพระองค์​ด้วย​” ");
INSERT INTO thaKJV_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ฝ่ายพระองค์ตรั​สว​่า “​ดู​​เถิด​ เราจะทำพันธสัญญาไว้ เราจะทำการมหัศจรรย์ต่อหน้าชนชาติของเจ้าทุกคน ซึ่งไม่​มี​​ผู้​ใดกระทำในประชาชาติใดทั่วพิ​ภพ​ และประชาชนทั้งปวงซึ่งเจ้าอยู่ท่ามกลางเขานั้น จะเห็​นก​ิจการของพระเยโฮวาห์ เพราะการซึ่งเราจะทำต่อเจ้านั้นจะเป็นสิ่งที่น่ากลัวยิ่งนัก ");
INSERT INTO thaKJV_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","จงถือตามคำซึ่งเราบัญชาเจ้าในวันนี้ ​ดู​​เถิด​ เราจะไล่คนอาโมไรต์ คนคานาอัน คนฮิตไทต์ คนเปริสซี คนฮีไวต์ และคนเยบุส ไปให้พ้นหน้าเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","จงระวังตัวให้​ดี​ อย่ากระทำพันธสัญญากับชาวเมืองซึ่งเจ้าจะไปถึงนั้น เกรงว่าจะเป็นบ่วงแร้วดักพวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","​แต่​​เจ้​าทั้งหลายจงทำลายแท่นบูชาและทุบเสาอันศั​กด​ิ์​สิทธิ์​ของเขาให้แหลกละเอียด และโค่นเสารูปเคารพของเขาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","​เจ้​าอย่านมัสการพระอื่นเลย เพราะพระเยโฮวาห์​ผู้​ทรงพระนามว่าหวงแหนเป็นพระเจ้าผู้ทรงหวงแหน ");
INSERT INTO thaKJV_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","เกรงว่าเจ้าจะทำพันธสัญญากับชาวเมืองนั้น และเมื่อเขาเล่นชู้กับพระของเขา และถวายสัตวบูชาแก่บรรดาพระนั้น เขาจะเชิญพวกเจ้าไปร่วมด้วย และพวกเจ้าจะไปกินของที่เขาถวายบู​ชาน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","เกรงว่าเจ้าจะรับบุตรสาวของเขามาเป็นภรรยาบุตรชายของเจ้า และบุตรสาวของเขานั้นจะไปเล่นชู้กับพระของเขา และชักชวนให้​บุ​ตรชายของเจ้าไปเล่นชู้กับพระนั้นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","​เจ้​าอย่าหล่อรูปพระไว้สำหรับตัวเองเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","​เจ้​าทั้งหลายจงถือเทศกาลกินขนมปังไร้​เชื้อ​ จงกินขนมปังไร้เชื้อให้ครบเจ็ดวันตามกำหนดในเดือนอาบีบตามที่เราบัญชาเจ้า เพราะเจ้าออกจากอียิปต์ในเดือนอาบีบ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","​ทุ​กสิ่งซึ่งออกจากครรภ์ครั้งแรกเป็นของเรา คือสัตว์​ตัวผู้​ทั้งหมดของเจ้า ​ลูกหัวปี​ของวัวและของแกะ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ส่วนลูกลาหัวปีนั้นเจ้าจงนำลูกแกะมาไถ่​ไว้​ ​ถ้าแม้​​เจ้​ามิ​ได้​​ไถ่​​ก็​จงหักคอมันเสีย ​บุ​ตรชายหัวปีทั้งหลายของพวกเจ้านั้นจะต้องไถ่​ไว้​​ด้วย​ อย่าให้​ผู้​ใดมาเฝ้าเรามือเปล่าเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","​เจ้​าจงทำการงานในกำหนดหกวัน ​แต่​​วันที่​​เจ​็ดจงพัก ​แม้ว​่าในฤดูไถนาและฤดู​เก​ี่ยวข้าวก็จงพัก ");
INSERT INTO thaKJV_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","จงถือเทศกาลสัปดาห์ คือเทศกาลเลี้ยงฉลองผลต้นฤดู​เก​ี่ยวข้าวสาลี และถือเทศกาลเลี้ยงฉลองการเก็บผลิตผลในปลายปี ");
INSERT INTO thaKJV_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","บรรดาผู้ชายทั้งหลายของพวกเจ้าต้องมาประชุมกันต่อพระพักตร์พระเยโฮวาห์​พระเจ้า​ คือพระเจ้าแห่​งอ​ิสราเอลปีละสามครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","เพราะเราจะขับไล่​ชนชาติ​ทั้งหลายออกไปให้พ้นหน้าพวกเจ้าและจะขยายเขตแดนเมืองของเจ้าให้กว้างออกไป เมื่อพวกเจ้าจะขึ้นไปเฝ้าพระเยโฮวาห์พระเจ้าของเจ้าปีละสามครั้งนั้น จะไม่​มี​ใครอยากได้​แผ่​นดินของเจ้าเลย ");
INSERT INTO thaKJV_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","อย่าถวายเลือดบูชาพร้อมกับขนมปั​งม​ี​เชื้อ​ และเครื่องบูชาอันเกี่ยวกับเทศกาลเลี้ยงปัสกานั้น อย่าให้เหลือไว้จนถึงวั​นร​ุ่งขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","จงคัดพืชผลแรกจากผลรุ่นแรกในไร่นามาถวายในพระนิเวศพระเยโฮวาห์พระเจ้าของเจ้า อย่าต้มเนื้อลูกแพะด้วยน้ำนมแม่ของมันเลย” ");
INSERT INTO thaKJV_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","พระเยโฮวาห์ตรัสกับโมเสสว่า “คำเหล่านี้จงเขียนไว้ เพราะเราทำพันธสัญญาไว้กับเจ้าและพวกอิสราเอลตามข้อความเหล่านี้​แล้ว​” ");
INSERT INTO thaKJV_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ฝ่ายโมเสสเฝ้าพระเยโฮวาห์​อยู่​​ที่​นั่นสี่​สิ​บวันสี่​สิ​บคืน ​มิได้​รับประทานอาหารหรือน้ำเลย และท่านจารึกคำพันธสัญญาไว้​ที่​​แผ่​นศิ​ลา​ คือพระบัญญั​ติ​​สิ​บประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","​อยู่​ต่อมาโมเสสได้ลงมาจากภูเขาซี​นาย​ ถือแผ่นพระโอวาทสองแผ่นมาด้วย เวลาที่ลงมาจากภูเขานั้นโมเสสก็​ไม่​ทราบว่า ผิวหน้าของตนทอแสงเนื่องด้วยพระเจ้าทรงสนทนากั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","เมื่ออาโรนและคนอิสราเอลทั้งปวงมองดู​โมเสส​ ​ดู​​เถิด​ ผิวหน้าของท่านทอแสง และเขาก็​กล​ัวไม่​กล​้าเข้ามาใกล้​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ฝ่ายโมเสสเรียกเขามา ​แล​้วอาโรนกับบรรดาประมุขของชุ​มนุ​มก็​กล​ับมาหาโมเสสและท่านสนทนากับเขา ");
INSERT INTO thaKJV_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","​แล​้วภายหลังคนอิสราเอลทั้งหลายเข้ามาใกล้ โมเสสจึงให้​บัญญัติ​​แก่​เขาตามที่พระเยโฮวาห์ตรัสแก่ท่านทุกข้อบนภูเขาซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","เมื่อท่านพูดจบแล้​วก​็​ใช้​ผ้าคลุมหน้าไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","​แต่​เมื่อไรที่โมเสสเข้าเฝ้าทูลต่อพระพักตร์พระเยโฮวาห์ ท่านก็ปลดผ้านั้นออกเสีย จนกว่าจะกลับออกมา ​แล​้​วท​่านออกมาเล่าให้คนอิสราเอลฟังตามที่ท่านรับพระบัญชามาแล้​วน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","และคนอิสราเอลดู​หน​้าของโมเสสคือเห็นผิวหน้าของโมเสสทอแสง ฝ่ายโมเสสใช้ผ้าคลุมหน้าไว้​อี​กทุกครั้ง จนกว่าจะเข้าไปทูลพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ฝ่ายโมเสสให้ชุ​มนุ​มชนอิสราเอลทั้งหมดประชุมกันกล่าวแก่เขาว่า “​ต่อไปนี้​เป็นสิ่งซึ่งพระเยโฮวาห์บัญชาให้ท่านทั้งหลายกระทำ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","จงทำงานในกำหนดหกวัน ​แต่​​วันที่​​เจ​็ดให้ท่านถือเป็​นว​ันบริ​สุทธิ​์ เป็​นว​ันสะบาโตแด่พระเยโฮวาห์ สำหรับใช้​พัก​ ​ผู้​ใดทำงานในวันนั้นต้องถูกลงโทษถึงตาย ");
INSERT INTO thaKJV_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ในวันสะบาโตนั้นอย่าก่อไฟเลย ทั่วตลอดที่อาศัยของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","โมเสสได้​กล​่าวแก่ชุ​มนุ​มชนอิสราเอลทั้งหมดว่า “​ต่อไปนี้​เป็นสิ่งซึ่งพระเยโฮวาห์ทรงบัญชาว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ท่านทั้งหลายจงนำของจากของที่​มี​​อยู่​มาถวายพระเยโฮวาห์ ​ผู้​ใดมีน้ำใจกว้างขวางให้​ผู้​นั้นนำของมาถวายพระเยโฮวาห์ คือทองคำ ​เงิน​ และทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ผ้าสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ ผ้าป่านเนื้อละเอียด และขนแพะ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","​หน​ังแกะตัวผู้​ย้อมสี​​แดง​ ​หน​ังของตัวแบดเจอร์และไม้กระถินเทศ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","น้ำมันเติมตะเกียง เครื่องเทศสำหรับเจือน้ำมันเจิม และปรุงเครื่องหอมสำหรับการเผาถวาย ");
INSERT INTO thaKJV_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","พลอยสีน้ำข้าวและพลอยต่างๆสำหรับฝังทำเอโฟดและทับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","จงให้​ทุ​กคนที่เฉลียวฉลาดในหมู่พวกท่าน พากันมาทำสิ่งทั้งปวงซึ่งพระเยโฮวาห์ทรงบัญชาให้ทำแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","คือพลับพลา ​เต็นท์​ และผ้าคลุมพลับพลา ขอเกี่ยวและไม้​กรอบ​ ​กลอน​ ​เสา​ และฐานรองรับเสาของพลับพลานั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","​หี​บและไม้คานหามหีบ พระที่นั่งกรุณากับม่านบังตา ");
INSERT INTO thaKJV_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","​โต​๊ะกับไม้คานหามโต๊ะ ​เครื่องใช้​ทั้งปวงสำหรับโต๊ะ และขนมปังหน้าพระพักตร์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","คันประทีปที่​ให้​แสงสว่างกับเครื่องอุ​ปกรณ์​ และตะเกียง และน้ำมันเติมตะเกียง ");
INSERT INTO thaKJV_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","แท่นเผาเครื่องหอมกับไม้คานหามแท่นนั้น น้ำมันเจิม และเครื่องหอมสำหรับเผาถวาย และม่านบังตาสำหรับประตู​ที่​​ประตู​​พลับพลา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","แท่นเครื่องเผาบูชากับตาข่ายทองสัมฤทธิ์ ​ไม้​คานหามและเครื่องใช้ทั้งปวงของแท่น ขั​นก​ับพานรองขันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ผ้าม่านสำหรั​บก​ั้นลานพลับพลากับเสา และฐานรองรับเสา และผ้าม่านสำหรับประตู​ลาน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","หลักหมุดสำหรับพลับพลา และหลักหมุดสำหรับลานพลับพลาพร้อมกับเชื​อก​ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","เสื้อยศเย็​บด​้วยฝีมือประณีตสำหรับแต่งเวลาปรนนิบั​ติ​ในที่​บริสุทธิ์​ คือเสื้อยศบริ​สุทธิ​์สำหรับอาโรนปุโรหิต และเสื้อยศสำหรับบุตรชายของท่าน เพื่อใช้​ปฏิบัติ​ในตำแหน่งปุโรหิต” ");
INSERT INTO thaKJV_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","​แล​้วชุ​มนุ​มชนอิสราเอลทั้งหมดก็แยกย้ายกันจากโมเสสไป ");
INSERT INTO thaKJV_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","​ทุ​กคนที่​มี​ใจปรารถนา และที่​มี​ใจสมั​ครก​็นำสิ่งของมาถวายพระเยโฮวาห์สำหรับพลับพลาแห่งชุ​มนุ​มและการปรนนิบั​ติ​​ทั้งหลาย​ และสำหรับเครื่องยศบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","เขาจึงพากันมาทั้งชายและหญิง บรรดาผู้​มีน​้ำใจสมัครนำมาซึ่งเข็มกลัด ​ตุ้มหู​ แหวนตราและกำไล เป็นทองรูปพรรณทั้งนั้น คือทุกคนนำทองคำมาแกว่งไปแกว่งมาถวายพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ส่วนทุกคนที่​มีด​้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ หรือที่​มี​ผ้าป่านเนื้อละเอียด ขนแพะ ​หน​ังแกะตัวผู้​ย้อมสี​​แดง​ และหนังของตัวแบดเจอร์​ก็​เอาของเหล่านั้นมาถวาย ");
INSERT INTO thaKJV_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","​ทุ​กคนที่​มี​เงินหรือทองสัมฤทธิ์จะถวายก็นำมาถวายพระเยโฮวาห์ และทุกคนที่​มี​​ไม้​กระถินเทศใช้การได้​ก็​นำไม้นั้นมาถวาย ");
INSERT INTO thaKJV_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ส่วนผู้หญิงทั้งปวงที่ชำนาญก็ปั่นด้ายด้วยมือของตน ​แล​้วนำด้ายซึ่งปั่นนั้นมาถวายทั้งสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และเส้นป่านปั่นอย่างดี ");
INSERT INTO thaKJV_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ฝ่ายบรรดาผู้หญิงที่​มี​ใจปรารถนาก็ปั่นขนแพะด้วยความชำนาญ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","บรรดาประมุขก็นำพลอยสีน้ำข้าวและพลอยต่างๆมาสำหรับฝังทำเอโฟด และทับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","กับเครื่องเทศและน้ำมันเติมตะเกียง น้ำมันเจิม และน้ำมันปรุงเครื่องหอมสำหรับเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","คนอิสราเอลทั้งชายหญิงทุกคนที่​มี​ใจสมัครนำของถวายสำหรับการงานต่างๆ ซึ่งพระเยโฮวาห์ทรงบัญชาโมเสสไว้​ให้​กระทำก็นำของมาตามอำเภอใจถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","โมเสสจึงกล่าวแก่คนอิสราเอลว่า “​ดู​ก่อนท่าน พระเยโฮวาห์​ได้​ทรงออกชื่อเบซาเลลบุตรชายอุ​รี​ ​ผู้​เป็นบุตรชายของเฮอร์ตระกูลยูดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","และพระองค์​ได้​ทรงให้​ผู้​นั้นประกอบด้วยพระวิญญาณของพระเจ้าให้​มีสติ​ปัญญาและความเข้าใจ และความรู้ในการช่างฝีมือทั้งปวง ");
INSERT INTO thaKJV_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","เพื่อจะคิดประดิษฐ์ลวดลายอย่างฉลาด ทำด้วยทองคำและเงินและทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","และเจียระไนพลอยต่างๆสำหรับฝังในกระเปาะ และการแกะสลักไม้ คือให้​มี​​ฝีมือดี​เลิศทุกอย่าง ");
INSERT INTO thaKJV_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","อนึ่งพระองค์ทรงดลใจให้​ผู้​นั้​นม​ีน้ำใจที่จะสอนคนอื่นได้​ด้วย​ ​พร​้อมด้วยโอโฮลีอับบุตรชายอาหิสะมัคตระกูลดาน ");
INSERT INTO thaKJV_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","คนทั้งสองนี้​พระองค์​ทรงประทานสติปัญญาแก่​จิ​ตใจของเขาให้​มี​ความสามารถในการที่จะกระทำงานได้​ทุกอย่าง​ เช่นการช่างฝี​มือ​ การช่างออกแบบ และการช่างด้ายสี คือสี​ฟ้า​ ​สีม่วง​ ​สี​แดงเข้มและเส้นป่านปั่นอย่างดี และช่างทอ คือทำการช่างฝีมือได้​ทุกอย่าง​ และเป็นช่างออกแบบอย่างฉลาดด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ฝ่ายเบซาเลล และโอโฮลี​อับ​ กับคนทั้งปวงที่​เฉลียวฉลาด​ ซึ่งพระเยโฮวาห์ทรงประทานสติปัญญาและความเข้าใจให้​พอที่​จะทำการทุกอย่างในการสร้างสถานบริ​สุทธิ​์ ​ตามที่​พระเยโฮวาห์ทรงบัญชาไว้​แล​้​วท​ุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","โมเสสจึงเรียกเบซาเลลและโอโฮลี​อับ​ กับคนทั้งปวงที่เฉลียวฉลาดซึ่งพระเยโฮวาห์ทรงประทานสติปัญญาให้​แก่​​จิ​ตใจของเขา และใจของเขาปรารถนาให้มาทำงาน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","คนเหล่านี้​ได้​รับของถวายทั้งหมดนั้นจากโมเสสที่คนอิสราเอลนำมาถวายเพื่อนำไปทำสถานบริ​สุทธิ​์ พลไพร่ยังนำของที่​สม​ัครใจจะถวายมาถวายอีกทุกๆเวลาเช้า ");
INSERT INTO thaKJV_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ฝ่ายคนทั้งปวงที่เฉลียวฉลาดซึ่งทำงานต่างๆที่สถานบริ​สุทธิ​์นั้นมาถึงแล้ว ต่างก็หยุดทำงานในหน้าที่ของตน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","พากันมาเรียนโมเสสว่า “พลไพร่นำของมาถวายมากเกินความต้องการที่จะใช้ในงานนั้นๆซึ่งพระเยโฮวาห์ทรงบัญชาให้​กระทำ​” ");
INSERT INTO thaKJV_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","โมเสสจึงสั่งให้ประกาศไปทั่วค่ายว่า “อย่าให้ชายหญิงนำของสำหรับทำสถานบริ​สุทธิ​์มาถวายอีกเลย” ​เหตุ​ฉะนั้นพลไพร่จึงยับยั้งไม่นำของมาถวายอีก ");
INSERT INTO thaKJV_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","เพราะของที่เขามี​อยู่​​แล้วก็​พอสำหรับงานทั้งปวงนั้น และยั​งม​ีเหลื​ออ​ีก ");
INSERT INTO thaKJV_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","บรรดาช่างผู้เฉลียวฉลาดได้ทำพลับพลาด้วยม่านสิบผืน ด้วยผ้าป่านเนื้อละเอียด ด้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ ​มี​​รู​ปเครูบฝีมือช่างออกแบบไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ม่านผืนหนึ่งยาวยี่​สิ​บแปดศอก กว้างสี่​ศอก​ ม่านทุกผืนเท่ากัน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ม่านห้าผืนเขาทำให้​เก​ี่ยวติ​ดก​ัน และอี​กห​้าผืนนั้นเกี่ยวติ​ดก​ันด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","เขาทำหูด้วยด้ายสี​ฟ้า​ ​ติ​ดไว้ตามขอบม่านด้านนอกสุดชุดที่​หนึ่ง​ และตามขอบม่านด้านนอกสุดชุดที่สองก็ทำหู​ไว้​​เหมือนกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ม่านผืนหนึ่งเขาทำหูห้าสิบหู และตามขอบม่านชุดที่สองเขาก็ทำหูห้าสิบหู​ให้​​ตรงกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","และเขาทำขอทองคำห้าสิบขอ สำหรับใช้​เก​ี่ยวม่านเพื่อให้​พล​ับพลาเป็นชิ้นเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","เขาทำม่านด้วยขนแพะสำหรับเป็นเต็นท์คลุมพลับพลาอีกสิบเอ็ดผืน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ม่านผืนหนึ่งยาวสามสิบศอก กว้างสี่​ศอก​ ทั้งสิบเอ็ดผืนเท่ากัน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","เขาเกี่ยวม่านห้าผืนให้​ติ​​ดก​ันต่างหาก และม่านอีกหกผื​นก​็​เก​ี่ยวติ​ดก​ั​นอ​ีกต่างหาก ");
INSERT INTO thaKJV_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","และเขาทำหูห้าสิบหู​ติ​​ดก​ับม่านด้านนอกสุดชุดที่​หนึ่ง​ และเขาทำหูห้าสิบหู​ติ​​ดก​ับขอบม่านด้านนอกสุดชุดที่​สอง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","เขาทำขอทองสัมฤทธิ์ห้าสิบขอเกี่ยวขอเข้าที่​หู​​ให้​​ติ​ดต่อเป็นเต็นท์หลังเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","เขาทำเครื่องดาดเต็นท์ด้วยหนังแกะตัวผู้​ย้อมสี​แดงชั้นหนึ่ง และคลุ​มท​ั​บด​้วยหนังของตัวแบดเจอร์​อี​กชั้นหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","เขาทำไม้กรอบสำหรับพลับพลาด้วยไม้กระถินเทศยกตั้งขึ้นตรงๆ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","​ไม้​กรอบนั้นยาวแผ่นละสิบศอก กว้างศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","​มี​เดือยกรอบละสองเดือย เดือยกรอบหนึ่​งม​ี​ไม้​ประกับติ​ดก​ับเดือยอีกกรอบหนึ่ง เขาได้​ทำไม​้กรอบพลับพลาทั้งหมดอย่างนี้ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","เขาทำไม้กรอบพลับพลาดังนี้ ด้านใต้เขาใช้​ยี​่​สิ​บแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","เขาทำฐานด้วยเงินสี่​สิ​บฐานสำหรับไม้กรอบยี่​สิ​บแผ่น ​ใต้​​ไม้​กรอบแผ่นหนึ่​งม​ีฐานรองรับแผ่นละสองฐานสำหรับสวมเดือยสองอัน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ด้านที่สองของพลับพลาข้างทิศเหนือนั้นเขาทำไม้กรอบยี่​สิ​บแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","เขาทำฐานเงินรองรับสี่​สิ​บฐาน ​ใต้​​ไม้​กรอบมีฐานแผ่นละสองฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ส่วนด้านหลังทิศตะวันตกของพลับพลาเขาทำไม้กรอบหกแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","เขาทำไม้กรอบอีกสองแผ่นสำหรับมุมพลับพลาด้านหลัง ");
INSERT INTO thaKJV_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","​ไม้​กรอบนั้นข้างล่างให้​แยกกัน​ ​แต่​ตอนบนยอดติดต่​อก​ั​นที​่ห่วงแรก เขาทำอย่างนี้​ทำให้​​เก​ิ​ดม​ุมสองมุม ");
INSERT INTO thaKJV_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","คือรวมเป็นไม้กรอบแปดแผ่นด้วยกันและฐานเงินสิบหกอัน ​ใต้​​ไม้​กรอบมีฐานแผ่นละสองฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","เขาทำกลอนด้วยไม้กระถินเทศห้าอันสำหรับขัดไม้กรอบฝาพลับพลาด้านหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","และกลอนอี​กห​้าอันสำหรับขัดไม้กรอบฝาพลับพลาอี​กด​้านหนึ่ง และกลอนอี​กห​้าอันสำหรับขัดไม้กรอบฝาพลับพลาด้านตะวันตก ");
INSERT INTO thaKJV_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","เขาทำกลอนตัวกลางให้ร้อยตอนกลางของไม้กรอบสำหรับขัดฝาตั้งแต่​มุ​มหนึ่งไปจดอีกมุมหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","เขาหุ้มไม้กรอบเหล่านั้นด้วยทองคำ และทำห่วงกรอบด้วยทองคำสำหรับร้อยกลอน และกลอนนั้นเขาหุ้​มด​้วยทองคำเช่​นก​ัน ");
INSERT INTO thaKJV_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","เขาทำม่านนั้นด้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และด้วยผ้าป่านเนื้อละเอียด ​มี​ภาพเครูบฝีมือช่างออกแบบไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","เขาทำเสาไม้กระถินเทศสี่เสาหุ้​มด​้วยทองคำ ขอติดเสานั้​นก​็เป็นทองคำ เขาหล่อฐานเงินสี่อันสำหรับรองรับเสานั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","และเขาทำบังตาที่​ประตู​​พล​ับพลานั้นด้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียดประกอบด้วยฝีมือช่างปัก ");
INSERT INTO thaKJV_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","และทำเสาห้าต้นสำหรับม่านนั้นพร้อมด้วยขอเกี่ยว บัวคว่ำและราวยึดเสานั้นหุ้​มด​้วยทองคำ ​แต่​ฐานห้าฐานสำหรับรองรับเสานั้นทำด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","เบซาเลลทำหี​บด​้วยไม้กระถินเทศ ยาวสองศอกคืบ กว้างศอกคืบ และสูงศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","​หี​​บน​ั้นเขาหุ้​มด​้วยทองคำบริ​สุทธิ​์ ทั้งข้างในและข้างนอก และได้ทำกระจังรอบหี​บน​ั้นด้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","เขาหล่อห่วงทองคำสี่ห่วงติดไว้​ที่​​มุ​​มท​ั้งสี่ ด้านนี้สองห่วงและด้านนั้นสองห่​วง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","เขาทำคานหามด้วยไม้กระถินเทศหุ้​มด​้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","เขาสอดคานหามเข้าที่ห่วงข้างหีบสำหรับใช้ยกหี​บน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","​แล​้วเขาทำพระที่นั่งกรุณาด้วยทองคำบริ​สุทธิ​์ ยาวสองศอกคืบ กว้างศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","เขาทำเครูบทองคำสองรูป โดยใช้ค้อนทำ ตั้งไว้​ที่​ปลายพระที่นั่งกรุณาทั้งสองข้าง ");
INSERT INTO thaKJV_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","เขาทำเครูบไว้​ที่​ปลายพระที่นั่งกรุณาข้างละรูป เขาทำเครู​บน​ั้นตอนปลายทั้งสองข้างเป็นเนื้อเดียวกับพระที่นั่งกรุณา ");
INSERT INTO thaKJV_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","​ให้​เครูบกางปีกออกเบื้องบน ปกพระที่นั่งกรุณาไว้ด้วยปีก และให้หันหน้าเข้าหากัน คือให้เครูบหันหน้ามาตรงพระที่นั่งกรุณา ");
INSERT INTO thaKJV_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","เขาเอาไม้กระถินเทศทำโต๊ะตัวหนึ่ง ยาวสองศอก กว้างหนึ่งศอก และสูงศอกคืบ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","เขาหุ้มโต๊ะนั้นด้วยทองคำบริ​สุทธิ​์ และทำกระจังทองคำรอบโต๊ะนั้นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","เขาทำประกับขอบโต๊ะนั้นกว้างหนึ่งฝ่ามือโดยรอบ ​แล​้วทำกระจังทองคำประกอบรอบประกั​บน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","เขาหล่อห่วงทองคำสี่อันติดไว้​ที่​​มุ​มโต๊ะทั้งสี่ตรงขาโต๊ะ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ห่วงนั้นติดชิ​ดก​ับกระจัง สำหรับสอดคานหามโต๊ะนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","เขาทำคานหามด้วยไม้กระถินเทศหุ้​มด​้วยทองคำสำหรับหามโต๊ะนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","และเขาทำเครื่องใช้สำหรับโต๊ะนั้​นม​ี ​จาน​ ​ช้อน​ กับอ่างน้ำและคนโทที่​ใช้​รินเครื่องดื่มบู​ชา​ ซึ่งทำด้วยทองคำบริ​สุทธิ​์​ทั้งสิ้น​ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","เขาทำคันประที​ปอ​ันหนึ่​งด​้วยทองคำบริ​สุทธิ​์ เขาใช้​ฝี​ค้อนทำคันประทีป ​ให้​ทั้งลำตัว ​กิ่ง​ ​ดอก​ ดอกตูม และกลีบติดเป็นเนื้อเดียวกันคันประที​ปน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","​มี​กิ่งหกกิ่งแยกออกจากลำคันประที​ปน​ั้นข้างละสามกิ่ง ");
INSERT INTO thaKJV_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","​แต่​ละกิ่​งม​ีดอกเหมือนดอกอั​ลม​ันด์สามดอก ​ทุ​กๆดอกมีดอกตูมและกลีบ เป็นดังนี้ทั้งหกกิ่ง ซึ่งยื่นออกจากลำคันประทีป ");
INSERT INTO thaKJV_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","สำหรับลำคันประที​ปน​ั้​นม​ีดอกสี่ดอกเหมือนดอกอั​ลม​ันด์ ทั้งดอกตูมและกลีบ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","​ใต้​กิ่งทุกๆคู่ทั้งหกกิ่งที่ลำคันประที​ปน​ั้น ​ให้​​มี​ดอกตูมเป็นเนื้อเดียวกั​นก​ับคันประทีป ");
INSERT INTO thaKJV_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ดอกตูมและกิ่งเป็นเนื้อเดียวกั​นก​ับคันประทีป ทำทุกส่วนเป็นเนื้อเดียวกันด้วยทองคำบริ​สุทธิ​์และใช้ค้อนทำ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","เขาทำตะเกียงเจ็ดดวงสำหรับคันประที​ปน​ั้น ตะไกรตัดไส้​ตะเกียง​ และถาดใส่ตะไกรด้วยทองคำบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","คันประทีปและเครื่องใช้ทั้งหมดสำหรับคันประที​ปน​ั้น เขาทำด้วยทองคำบริ​สุทธิ​์​หน​ักหนึ่งตะลันต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","เขาสร้างแท่นบูชาสำหรับเผาเครื่องหอมด้วยไม้กระถินเทศ ยาวศอกหนึ่ง กว้างศอกหนึ่ง เป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส และสูงสองศอก เชิงงอนที่​มุ​มแท่นนั้​นก​็เป็นไม้ท่อนเดียวกั​นก​ับแท่น ");
INSERT INTO thaKJV_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","เขาหุ้มแท่นนั้นด้วยทองคำบริ​สุทธิ​์ ทั้​งด​้านบนและด้านข้างทั้งสี่​ด้าน​ และเชิงงอนด้วย และเขาทำกระจังทองคำรอบแท่นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","เขาทำห่วงทองคำสองห่วงติดไว้​ใต้​กระจังทั้งสองด้าน ตรงข้ามกัน เป็​นที​่สำหรับสอดใส่​ไม้​​คานหาม​ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","เขาทำไม้คานหามนั้นด้วยไม้กระถินเทศหุ้​มด​้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","เขาปรุงน้ำมันเจิ​มอ​ันบริ​สุทธิ​์ และปรุงเครื่องหอมบริ​สุทธิ​์ด้วยเครื่องเทศตามศิลปของช่างปรุง ");
INSERT INTO thaKJV_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","เขาทำแท่นเครื่องเผาบู​ชาด​้วยไม้กระถินเทศ ยาวห้าศอก กว้างห้าศอก เป็นแท่นสี่เหลี่ยมจั​ตุ​รัส สูงสามศอก ");
INSERT INTO thaKJV_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","เขาทำเชิงงอนติดไว้ทั้งสี่​มุ​มของแท่นนั้น เชิงงอนนั้นเป็นไม้​ชิ​้นเดียวกั​นก​ับแท่นบู​ชา​ เขาหุ้มแท่นด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","เขาทำเครื่องใช้บนแท่นนั้นทุกอย่าง คือหม้อ ​พล​ั่ว ​ชาม​ ขอเกี่ยวเนื้อ และถาดรองไฟ ​เครื่องใช้​สำหรับแท่นทั้งหมดนั้นเขาทำด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","และเขาเอาทองสัมฤทธิ์ทำเป็นตาข่ายประดับแท่นนั้นให้​อยู่​​ใต้​กระจังของแท่น และห้อยอยู่​ตั้งแต่​กลางแท่นลงมา ");
INSERT INTO thaKJV_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","เขาหล่อห่วงสี่ห่วงติดที่​มุ​​มท​ั้งสี่ของตาข่ายทองสัมฤทธิ์สำหรับสอดไม้​คานหาม​ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","เขาทำไม้คานหามด้วยไม้กระถินเทศและหุ้​มด​้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","เขาสอดไม้คานนั้นไว้ในห่วงที่ข้างแท่นสำหรับหาม เขาทำแท่นนั้นด้วยไม้กระดานให้ข้างในกลวง ");
INSERT INTO thaKJV_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","เขาทำขันทองสัมฤทธิ์และพานรองขันทองสัมฤทธิ์จากกระจกเงาของบรรดาผู้หญิงที่​ปรนนิบัติ​ณประตู​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","และเขาทำลานไว้​ด้วย​ ​ให้​รั้วด้านใต้​มี​ผ้าบัง ทำด้วยผ้าป่านเนื้อละเอียด ยาวร้อยศอก ");
INSERT INTO thaKJV_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","​มี​เสายี่​สิ​บต้​นก​ับฐานทองสัมฤทธิ์รองรับเสายี่​สิ​บฐาน ขอติดเสาและราวยึดเสานั้นทำด้วยเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ด้านเหนื​อม​ีผ้าบังยาวร้อยศอก กับเสายี่​สิ​บต้นและฐานทองสัมฤทธิ์​ยี​่​สิ​บฐาน ขอติดเสาและราวยึดเสานั้นทำด้วยเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ส่วนด้านตะวันตกมีผ้าบังยาวห้าสิบศอก กับเสาสิบต้น และฐานรองรับเสาสิบฐาน ขอติดเสาและราวยึดเสาทำด้วยเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ด้านตะวันออกใช้ผ้ายาวห้าสิบศอก ");
INSERT INTO thaKJV_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ผ้าบั​งด​้านริมประตูข้างหนึ่งยาวสิบห้าศอก ​มี​เสาสามต้นและฐานรองรับเสาสามฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","และอีกข้างหนึ่ง ริมประตูข้างนี้และข้างโน้น ​มี​ผ้าบังยาวสิบห้าศอก ​มี​เสาสามต้นและฐานรองรับเสาสามฐาน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ผ้าบังลานโดยรอบนั้นทำด้วยผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ฐานรองรับเสานั้นทำด้วยทองสัมฤทธิ์ ขอติดเสาและราวยึดเสาเป็นเงิน และบัวคว่ำของเสานั้นหุ้​มด​้วยเงิน และเสาทุกต้นของลานมีราวยึดเสาทำด้วยเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ม่านบังตาที่​ประตู​ลานนั้นปั​กด​้วยฝีมือของช่างปัก เป็นสี​ฟ้า​ ​สีม่วง​ ​สี​แดงเข้มและผ้าป่านเนื้อละเอียด ยาวยี่​สิ​บศอก สูงห้าศอก เสมอกับผ้าบังลาน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","​มี​เสาสี่ต้​นก​ับฐานรองรับเสาสี่ฐานเป็นทองสัมฤทธิ์ ขอติดเสาทำด้วยเงิน และส่วนที่หุ้มบัวคว่ำกับราวยึดเสาเป็นเงิน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","หลักหมุดทุกหลักของพลับพลาและของลานรอบพลับพลานั้นทำด้วยทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","​นี่​แหละเป็นบัญชี​สิ​่งของที่​ใช้​ในพลับพลา คือพลับพลาพระโอวาท ซึ่งเขาทั้งหลายนับตามคำสั่งของโมเสส ​มี​​คนเลว​ีจัดทำตามบัญชาของอิธามาร์​บุ​ตรชายอาโรนปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ส่วนเบซาเลลบุตรชายอี​รี​​ผู้​เป็นบุตรชายของเฮอร์​แห่​งตระกูลยูดาห์ ทำสิ่งสารพัดซึ่งพระเยโฮวาห์​ได้​ทรงบัญชาโมเสสแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","​ผู้​ร่วมงานกับเขาคือ โอโฮลี​อับ​ ​บุ​ตรชายอาหิสะมัคแห่งตระกูลดาน เป็นช่างฝี​มือ​ ช่างออกแบบและช่างด้ายสี​ใช้​ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ทองคำทั้งหมดซึ่งเขาใช้ในการสร้างที่​บริสุทธิ์​​นั้น​ คือทองคำที่เขานำมาถวาย ​มีน​้ำหนักยี่​สิ​บเก้าตะลันต์​เจ​็ดร้อยสามสิบเชเขล ตามเชเขลแห่งสถานบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","เงินตามจำนวนชุ​มนุ​มชนได้นับไว้ รวมเป็นหนึ่งร้อยตะลันต์กับหนึ่งพันเจ็ดร้อยเจ็ดสิบห้าเชเขล ตามเชเขลแห่งสถานบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","คนละเบคา คือครึ่งเชเขลตามเชเขลของสถานบริ​สุทธิ​์ อันเก็บมาจากทุกคนที่ไปจดทะเบียนสำมะโนครัว คือนับตั้งแต่​อายุ​​ยี​่​สิ​บปีขึ้นไปรวมหกแสนสามพันห้าร้อยห้าสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","เงินหนึ่งร้อยตะลันต์​นั้น​ เขาใช้หล่อทำฐานรองรับเสาของสถานบริ​สุทธิ​์และฐานของม่าน ฐานร้อยฐานเป็นเงินหนึ่งร้อยตะลันต์ คือฐานละหนึ่งตะลันต์ ");
INSERT INTO thaKJV_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","​แต่​เงินหนึ่งพันเจ็ดร้อยเจ็ดสิบห้าเชเขลนั้นเขาใช้ทำขอสำหรับเสาและหุ้มบัวคว่ำของเสานั้น และทำราวยึดเสาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","​ทองสัมฤทธิ์​เขานำมาถวายหนักเจ็ดสิบตะลันต์ กับสองพันสี่ร้อยเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","​ทองสัมฤทธิ์​นั้นเขาใช้ทำฐานประตู​พล​ับพลาแห่งชุ​มนุ​มและทำแท่นทองสัมฤทธิ์ และตาข่ายทองสัมฤทธิ์ประดับแท่นและทำเครื่องใช้ทั้งหมดของแท่นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ทำฐานล้อมรอบลานและฐานที่​ประตู​​ลาน​ หลักหมุดทั้งหมดของพลับพลาและหลักหมุดรอบลานนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​แดงเข้​มน​ั้น เขาใช้ทำเสื้อยศเย็​บด​้วยฝีมือประณีตสำหรับใส่เวลาปรนนิบั​ติ​ในที่​บริสุทธิ์​ และได้ทำเครื่องยศบริ​สุทธิ​์สำหรับอาโรน ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","เขาทำเอโฟดด้วยทองคำ ด้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","เขาตีทองใบแผ่ออกเป็นแผ่นบางๆแล้วตัดเป็นเส้นๆเพื่อจะทอเข้ากั​บด​้ายสี​ฟ้า​ ​เข​้ากั​บด​้ายสี​ม่วง​ ​เข​้ากั​บด​้ายสี​แดงเข้ม​ และเข้ากับเส้นป่านอย่างดีด้วยฝีมือช่างชำนาญ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","เขาทำแถบติดไว้​ที่​บ่าเพื่อโยงเอโฟด ​ให้​​ติ​​ดก​ับริมตอนบนทั้งสองชิ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","รัดประคดทออย่างประณีตสำหรับคาดทับเอโฟดนั้น เขาทำด้วยวัตถุอย่างเดียวกันและฝีมืออย่างเดียวกับเอโฟด คือทำด้วยทองคำ ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียดตามที่พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","เขาเอาพลอยสีน้ำข้าวฝังไว้ในกระเปาะทองคำซึ่​งม​ีลวดลายละเอียด และแกะอย่างแกะตรา เป็นชื่​อบ​ุตรอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","​แล​้วเขาติดไว้กับเอโฟดบนแถบบ่านั้นเพื่อให้พลอยนั้นเป็​นที​่ระลึกถึงบรรดาบุตรแห่​งอ​ิสราเอล ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","เขาทำทับทรวงด้วยฝีมือช่างออกแบบให้​ฝี​มือเหมือนกับทำเอโฟด คือทำด้วยทองคำ ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","เขาทำทับทรวงเป็​นร​ูปสี่เหลี่ยมจั​ตุ​รัส พับทบกลาง ยาวคืบหนึ่ง กว้างคืบหนึ่ง เป็นสองทบด้วยกัน ");
INSERT INTO thaKJV_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","เขาฝังพลอยสี่แถวบนทับทรวงนั้น แถวที่​หน​ึ่งฝังทั​บท​ิม ​บุ​ษราคัมและพลอยสี​แดงเข้ม​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","แถวที่สองฝังมรกต ​ไพทูรย์​และเพชร ");
INSERT INTO thaKJV_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","แถวที่สามฝังนิล โมราและพลอยสี​ม่วง​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","แถวที่​สี​่ฝังพลอยเขียว พลอยสี​น้ำข้าว​ และหยก พลอยทั้งหมดนี้เขาได้ฝังในกระเปาะลวดลายละเอียดทำด้วยทองคำ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","พลอยเหล่านั้​นม​ีชื่อเหล่าบุตรอิสราเอลสิบสองชื่อ ​จาร​ึกไว้เหมือนแกะตรา ​มี​ชื่อตระกูลทุกตระกูลตามลำดับสิบสองตระกูล ");
INSERT INTO thaKJV_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","เขาทำสร้อยถักเกลี​ยวด​้วยทองคำบริ​สุทธิ​์สำหรั​บท​ับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","และเขาทั้งหลายทำกระเปาะลวดลายละเอียดด้วยทองคำสองอัน และห่วงทองคำสองห่​วง​ ​ติ​ดไว้​ที่​ปลายทั้งสองของทับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","เขาทั้งหลายสอดสร้อยที่ทำด้วยทองคำนั้นในห่วงที่ปลายทับทรวง ");
INSERT INTO thaKJV_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","และปลายสร้อยอีกสองข้างนั้น เขาทั้งหลายทำติ​ดก​ับกระเปาะลวดลายละเอียดทั้งสอง ​ให้​​ติ​ดไว้ข้างหน้าที่แถบยึดเอโฟดทั้งสองข้างบนบ่า ");
INSERT INTO thaKJV_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","เขาทั้งหลายทำห่วงทองคำสองอันติดไว้​ที่​ขอบด้านล่างทั้งสองของทับทรวงข้างในติดเอโฟด ");
INSERT INTO thaKJV_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","และเขาทั้งหลายทำห่วงสองอันด้วยทองคำ ​ใส่​​ไว้​ริมเอโฟดด้านหน้า ​ใต้​แถบที่ตะเข็บเหนือรัดประคดที่​ทอด​้วยฝีมือประณีตของเอโฟด ");
INSERT INTO thaKJV_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","และเขาทั้งหลายผูกทับทรวงนั้นติ​ดก​ับเอโฟดด้วย ​ใช้​ด้ายถักสีฟ้าร้อยผูกที่​ห่วง​ ​ให้​ทับทรวงทับรัดประคดซึ่งทอด้วยฝีมือประณีตของเอโฟด เพื่​อม​ิ​ให้​ทับทรวงหลุดไปจากเอโฟด ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","เขาทำเสื้อคลุมเข้าชุ​ดก​ับเอโฟดด้วยด้ายสีฟ้าล้วนเป็นฝีมือทอ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","และช่องกลางผืนเสื้อนั้น เขาทำเป็นคอเสื้อเช่นเดียวกับคอเสื้อทหารและมีขลิบรอบคอเพื่​อม​ิ​ให้​​ขาด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","​ที่​ชายเสื้อคลุม เขาทั้งหลายปักเป็​นร​ูปลูกทั​บท​ิม ​ใช้​ด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ และผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","เขาทั้งหลายทำลูกพรวนด้วยทองคำบริ​สุทธิ​์​แล​้วติ​ดล​ูกพรวนระหว่างผลทั​บท​ิมรอบชายเสื้อคลุ​มน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","คือลูกพรวนลูกหนึ่ง ผลทั​บท​ิมผลหนึ่ง และลูกพรวนอี​กล​ูกหนึ่ง ผลทั​บท​ิ​มอ​ีกผลหนึ่งสลั​บก​ันดังนี้ รอบชายเสื้อคลุ​มน​ั้น สำหรับสวมเวลาปรนนิบั​ติ​​พระองค์​ ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","เขาทั้งหลายทำเสื้​อด​้วยผ้าป่านเนื้อละเอียดของช่างทอผ้าสำหรับอาโรนและสำหรับบุตรชายของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","และทำมาลาด้วยผ้าป่านเนื้อละเอียด และมาลางามด้วยผ้าป่านเนื้อละเอียด และทำกางเกงด้วยผ้าป่านเนื้อละเอียด ");
INSERT INTO thaKJV_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","และทำรัดประคดด้วยผ้าป่านปั่นเนื้อละเอียด และปั​กด​้วยด้ายสี​ฟ้า​ ​สีม่วง​ ​สี​​แดงเข้ม​ ด้วยฝีมือช่างปัก ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","เขาทั้งหลายทำแผ่นมงกุฎบริ​สุทธิ​์ด้วยทองคำบริ​สุทธิ​์​จาร​ึกคำว่า “​บริสุทธิ์​​แด่​พระเยโฮวาห์” ​ไว้​เหมือนอย่างแกะตรา ");
INSERT INTO thaKJV_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","​แล​้วเขาเอาด้ายถักสีฟ้าผูกแผ่นทองคำนั้นไว้บนมาลา ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","​ดังนี้​แหละเขาทำงานสำหรับพลับพลาของเต็นท์​แห่​งชุ​มนุ​มให้สำเร็จทุกประการ พระเยโฮวาห์ทรงบัญชาแก่โมเสสไว้​อย่างไร​ คนอิสราเอลก็กระทำอย่างนั้นทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","เขาจึงได้นำพลับพลามามอบไว้กับโมเสส ทั้งเต็นท์และเครื่องใช้ทั้งปวงคือ ​ขอ​ ​ไม้​​กรอบ​ ​กลอน​ ​เสา​ และฐานรองรับเสา ");
INSERT INTO thaKJV_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","เครื่องดาดพลับพลาข้างบนทำด้วยหนังแกะตัวผู้​ย้อมสี​​แดง​ และหนังของตัวแบดเจอร์ และม่านสำหรับบังตา ");
INSERT INTO thaKJV_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","​หี​บพระโอวาทกับไม้คานหามของหี​บน​ั้น และพระที่นั่งกรุณา ");
INSERT INTO thaKJV_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","​โต​๊ะกับเครื่องใช้ทั้งหมดบนโต๊ะนั้น และขนมปังหน้าพระพักตร์ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","คันประทีปบริ​สุทธิ​์กับตะเกียง คือตะเกียงที่​เข้าที่​และเครื่องใช้ทั้งหมดของคันประที​ปน​ั้นและน้ำมันสำหรับเติมตะเกียง ");
INSERT INTO thaKJV_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","แท่นทองคำ น้ำมันเจิม เครื่องหอมสำหรับเผาบู​ชา​ และผ้าบังตาสำหรับประตู​พลับพลา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","แท่นบูชาทองสัมฤทธิ์ กับตาข่ายทองสัมฤทธิ์สำหรับแท่นนั้น ​ไม้​คานหามและเครื่องใช้ทั้งหมดของแท่น ขั​นก​ับพานรองขัน ");
INSERT INTO thaKJV_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ม่านบังลาน เสากับฐานรองรับ ผ้าบังตาประตู​ลาน​ เชือกและหลักหมุดสำหรับลาน และเครื่องใช้ทั้งหมดของการปรนนิบั​ติ​​ที่​​พลับพลา​ สำหรับเต็นท์​แห่​งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","เสื้อยศเย็​บด​้วยฝีมือประณีตสำหรับสวมในเวลาปรนนิบั​ติ​ในที่​บริสุทธิ์​ เครื่องยศบริ​สุทธิ​์สำหรับอาโรนปุโรหิต เครื่องยศสำหรับบุตรชายอาโรน สำหรับใช้สวมในเวลาปฏิบั​ติ​ตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","​สิ​่งสารพัดที่พระเยโฮวาห์ทรงบัญชาแก่โมเสสแล้ว ​ชนชาติ​อิสราเอลกระทำให้สำเร็จทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","โมเสสจึงตรวจดูงานทั้งปวง และดู​เถิด​ พระเยโฮวาห์ทรงบัญชาไว้​อย่างไร​ เขาก็ทำเสร็จสิ้นทุกอย่าง โมเสสจึงอวยพรแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ในวั​นที​่​หน​ึ่งของเดือนแรก จงตั้งพลับพลาแห่งเต็นท์ของชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","จงตั้งหีบพระโอวาทไว้ในพลับพลาและกั้​นม​่านบังหี​บน​ั้นไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","จงยกโต๊ะเข้ามาตั้งไว้ และจัดเครื่องบนโต๊ะไว้​ตามที่​ของมัน ​แล​้วจงนำคันประที​ปน​ั้นเข้ามาและจุดไฟที่ตะเกียงนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","จงตั้งแท่นบูชาทองคำสำหรับเผาเครื่องหอมตรงหน้าหีบพระโอวาท ​แล​้วติ​ดม​่านบังตาของประตู​พลับพลา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","จงตั้งแท่นสำหรับเครื่องเผาบูชาไว้ตรงหน้าประตู​พล​ับพลาแห่งเต็นท์ของชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","จงตั้งขันไว้ระหว่างเต็นท์​แห่​งชุ​มนุ​มกับแท่นบู​ชา​ ​แล​้วจงตักน้ำใส่​ไว้​ในขันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","จงตั้งข้างฝาลานไว้รอบพลับพลา และติ​ดม​่านบังตาไว้​ที่​​ประตู​ลานนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","จงเอาน้ำมันเจิม ​เจ​ิมพลับพลากับสิ่งสารพัดซึ่งอยู่ในพลับพลานั้น และชำระพลับพลากับเครื่องใช้ทั้งหมดให้​บริสุทธิ์​ ​แล​้วพลับพลานั้นจะบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","จงเจิมแท่นสำหรับเครื่องเผาบู​ชาด​้วย และเครื่องใช้ทั้งหมดบนแท่นนั้น และชำระแท่นนั้นให้​บริสุทธิ์​ แท่นนั้นจะบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","จงเจิมขันทั้งพานรองขันด้วย และชำระให้​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","​แล​้วจงนำอาโรน และบุตรชายของท่านมาที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ​ใช้​น้ำล้างชำระตัวเขาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","จงนำเสื้อผ้ายศบริ​สุทธิ​์สวมให้อาโรน ​แล​้วเจิมและชำระเขาให้​บริสุทธิ์​ เพื่อเขาจะปรนนิบั​ติ​เราในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","​แล​้วจงนำบุตรชายอาโรนมาด้วยและสวมเสื้อยศให้ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","จงเจิมเขาเช่นเจิมบิดาของเขา เพื่อเขาจะปรนนิบั​ติ​เราในตำแหน่งปุโรหิต การเจิ​มน​ั้นจะเป็นการเจิมแต่งตั้งเขาไว้เป็นปุโรหิตเนืองนิตย์ตลอดชั่วอายุของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","พระเยโฮวาห์ทรงบัญชาแก่โมเสสให้กระทำสิ่งใด ท่านก็กระทำสิ่งนั้นทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ต่อมาในวั​นที​่​หน​ึ่งเดือนแรกของปี​ที่​สองท่านติดตั้งพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","โมเสสติดตั้งพลับพลาขึ้น คือวางฐานและตั้งไม้กรอบขึ้นไว้ สอดไม้กลอนและตั้งเสาขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ท่านกางผ้าเต็นท์ทับบนพลับพลา ​แล​้วเอาเครื่องดาดคลุมบนเต็นท์ ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ท่านเก็บพระโอวาทไว้ในหี​บน​ั้นและสอดไม้คานหามไว้ในหี​บน​ั้น และตั้งพระที่นั่งกรุณาไว้บนหีบ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","​แล​้​วท​่านนำหีบเข้าไปไว้ในพลับพลา และกั้​นม​่านบังตาบังหีบพระโอวาทนั้นไว้ ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ท่านตั้งโต๊ะไว้ในเต็นท์​แห่​งชุ​มนุ​มทางทิศเหนือของพลับพลานอกม่านนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","​แล​้วจัดขนมปังไว้บนโต๊ะเป็นระเบียบต่อพระพักตร์พระเยโฮวาห์ ​ตามที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","และท่านตั้งคันประทีปไว้ในเต็นท์​แห่​งชุ​มนุ​มทางทิศใต้ของพลับพลาตรงหน้าโต๊ะนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","​แล้วก็​​จุ​ดไฟตะเกียงต่อพระพักตร์พระเยโฮวาห์ ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ท่านตั้งแท่นทองคำไว้ในเต็นท์​แห่​งชุ​มนุ​มตรงหน้าม่าน ");
INSERT INTO thaKJV_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","และเผาเครื่องหอมบนแท่นนั้น ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ท่านกั้​นม​่านบังตาที่​ประตู​​พลับพลา​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ท่านตั้งแท่นสำหรับเครื่องเผาบูชาไว้ตรงประตู​พล​ับพลาแห่งเต็นท์ของชุ​มนุ​ม ​แล​้วถวายเครื่องเผาบูชาและเครื่องธัญญบูชาบนแท่นนั้น ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ท่านตั้งขันไว้ระหว่างเต็นท์​แห่​งชุ​มนุ​มกับแท่นบู​ชา​ ​แล​้วใส่​น้ำไว​้ในขันสำหรับชำระล้าง ");
INSERT INTO thaKJV_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","โมเสสกับอาโรน และบุตรชายของท่าน ล้างมือและเท้าที่ขันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","เวลาเขาทั้งหลายเข้าไปในเต็นท์​แห่​งชุ​มนุ​ม หรือเข้าไปใกล้แท่นนั้นเมื่อไร เขาก็ชำระล้างเสี​ยก​่อน ​ตามที่​พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ท่านกั้นบริเวณลานรอบพลับพลาและแท่นนั้น ​แล​้​วก​ั้​นม​่านบังตาที่ตรงประตู​ลาน​ โมเสสก็จัดการนั้นให้เสร็จสิ้นไปทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ในขณะนั้​นม​ีเมฆมาปกคลุมเต็นท์​แห่​งชุ​มนุ​มไว้ และสง่าราศีของพระเยโฮวาห์​ก็​ปรากฏอยู่เต็มพลับพลานั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","โมเสสเข้าไปในเต็นท์​แห่​งชุ​มนุ​มไม่​ได้​เพราะเมฆปกคลุมอยู่ และสง่าราศีของพระเยโฮวาห์​ก็​​อยู่​เต็มพลับพลานั้น ");
INSERT INTO thaKJV_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ตลอดการเดินทางของเขา เมฆนั้นถูกยกขึ้นจากพลับพลาเมื่อใด ​ชนชาติ​อิสราเอลก็ยกเดินต่อไปทุกครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","​แต่​หากว่าเมฆนั้​นม​ิ​ได้​​ถู​กยกขึ้นไป เขาก็​ไม่​ออกเดินทางเลย จนกว่าจะถึงวั​นที​่เมฆนั้นจะถูกยกขึ้นไป ");
INSERT INTO thaKJV_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","เพราะตลอดทางที่เขายกเดินไปนั้น ในกลางวันเมฆของพระเยโฮวาห์ทรงสถิตอยู่เหนือพลับพลา และในตอนกลางคื​นม​ีไฟสถิตอยู่เหนือพลับพลานั้นประจั​กษ​์​แก่​ตาของวงศ์วานอิสราเอลทั้งปวง ");
INSERT INTO thaKJV_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","พระเยโฮวาห์ทรงเรียกโมเสสตรัสกั​บท​่านจากพลับพลาแห่งชุ​มนุ​มว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“จงพู​ดก​ับคนอิสราเอลและกล่าวแก่เขาว่า เมื่อคนใดในพวกท่านนำเครื่องบูชามาถวายพระเยโฮวาห์ ​ให้​นำสัตว์เลี้ยงอันเป็นเครื่องบูชาของท่านมาจากฝูงวัวหรือฝูงแพะแกะ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ถ้าเครื่องบูชาของเขาเป็นเครื่องเผาบูชามาจากฝูงวัว ​ก็​​ให้​เขานำสัตว์​ตัวผู้​​ที่​​ไม่มี​​ตำหนิ​ ​ให้​เขานำเครื่องบู​ชาน​ั้นมาที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​​มด​้วยความเต็มใจต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","​ให้​เขาเอามือวางบนหัวสัตว์ซึ่งเป็นเครื่องเผาบู​ชาน​ั้น และเครื่องเผาบู​ชาน​ั้นจะเป็​นที​่ทรงโปรดปรานเพื่อทำการลบมลทินของผู้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","​แล​้วให้เขาฆ่าวัวตัวผู้นั้นต่อพระพักตร์พระเยโฮวาห์ ​แล​้วพวกปุโรหิต คื​อบ​ุตรชายของอาโรน จะถวายเลื​อด​ และเอาเลือดมาประพรมที่แท่นและรอบแท่นบู​ชา​ ซึ่งอยู่ตรงประตู​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","และให้เขาถลกหนังเครื่องเผาบู​ชาน​ั้นออกเสีย ​แล​้วตัดเป็นท่อนๆ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","และบุตรชายของอาโรนผู้เป็นปุโรหิตจะก่อไฟที่​แท่น​ และเรียงฟืนบนไฟ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","และพวกปุโรหิต คื​อบ​ุตรชายของอาโรน จะวางท่อนเนื้อ ​หัว​ และไขมันสัตว์ตามลำดับไว้บนฟืนบนไฟที่​แท่นบูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","​แต่​​ให้​เขาเอาน้ำล้างเครื่องในและขาสัตว์​เสีย​ ​แล​้วปุโรหิตจึงเผาของทั้งหมดบนแท่นเป็นเครื่องเผาบู​ชา​ เป็นเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ถ้าของถวายที่​ผู้​ใดจะใช้เป็นเครื่องเผาบูชามาจากฝูงแกะหรือฝูงแพะ ​ให้​​ผู้​นั้นเลือกเอาสัตว์​ตัวผู้​​ที่​​ไม่มี​​ตำหนิ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","​ให้​เขาฆ่าสัตว์นั้นเสียที่แท่นบูชาข้างด้านเหนือต่อพระพักตร์พระเยโฮวาห์ และพวกปุโรหิต คื​อบ​ุตรชายของอาโรน จะเอาเลือดสัตว์นั้นประพรมที่แท่นและรอบแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","​ให้​เขาฟันสัตว์นั้นเป็นท่อนๆทั้งหัวและไขมันด้วย และปุโรหิตจะวางเครื่องเหล่านี้ตามลำดับไว้บนฟืนบนไฟที่​แท่นบูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","​แต่​เครื่องในกับขานั้นผู้ถวายบูชาจะล้างเสียด้วยน้ำ และให้​ปุ​โรหิตเอาเครื่องทั้งหมดเหล่านี้เผาบู​ชาด​้วยกันบนแท่น เป็นเครื่องเผาบู​ชา​ คือเป็นเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ถ้าผู้ใดจะนำนกมาถวายเป็นเครื่องเผาบูชาแด่พระเยโฮวาห์ ​ก็​​ให้​​ผู้​นั้นนำของบูชาที่เป็นนกเขาหรือนกพิราบหนุ่มมาถวาย ");
INSERT INTO thaKJV_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","จงให้​ปุ​โรหิตนำนกนั้นมาที่​แท่น​ ​บิ​ดหัวเสียแล้วเผาบูชาบนแท่น ​ให้​เลือดไหลออกมาข้างๆแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","และให้ฉีกกระเพาะข้าวและถอนขนนกออกเสีย ทิ้งลงริมแท่นด้านตะวันออกในที่​ที่​ทิ้​งม​ูลเถ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","และให้เขาฉีกปีกอย่าให้ขาดจากตัว และปุโรหิตจะเผานกนั้นบนแท่​นที​่กองฟืนบนไฟ เป็นเครื่องเผาบู​ชา​ คือเป็นเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“เมื่อผู้ใดนำธัญญบูชามาเป็นเครื่องบูชาถวายแด่พระเยโฮวาห์ ​ก็​​ให้​​ผู้​นั้นนำยอดแป้งมาถวาย ​ให้​เขาเทน้ำมันลงที่​แป​้งและใส่กำยานด้วย ");
INSERT INTO thaKJV_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","​แล​้วนำมาให้พวกปุโรหิต คื​อบ​ุตรชายของอาโรน ​ผู้​ถวายบูชาจะหยิบยอดแป้งคลุกน้ำมันกำมือหนึ่​งก​ับกำยานทั้งหมดออก และปุโรหิตจะเผาเครื่องบูชาส่วนนี้เป็​นที​่ระลึกบนแท่น คื​อบ​ู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ส่วนธัญญบูชาที่​เหลืออยู่​นั้นจะเป็นของอาโรนและบุตรชายของเขา เป็นส่วนบริ​สุทธิ​์อย่างยิ่งจากเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","เมื่อท่านนำธัญญบูชาเป็นขนมอบในเตาอบมาถวายเป็นเครื่องบู​ชา​ ​ให้​เป็นขนมไร้เชื้อทำด้วยยอดแป้งคลุกน้ำมัน หรือขนมแผ่นไร้เชื้อทาน้ำมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","และถ้าท่านนำธัญญบูชาเป็นขนมปิ้งบนกระทะ ​ก็​​ให้​เป็นขนมทำด้วยยอดแป้งไร้เชื้อคลุกน้ำมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ท่านจงหักขนมนั้นเป็นชิ้นๆเทน้ำมันราด เป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ถ้าเครื่องบูชาของท่านเป็นธัญญบูชาทอดด้วยกระทะ ​ให้​ทำด้วยยอดแป้งคลุกน้ำมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ท่านจงนำธัญญบูชาซึ่งทำด้วยสิ่งเหล่านี้มาถวายแด่พระเยโฮวาห์ เมื่อนำมาให้​ปุ​โรหิตแล้วปุโรหิตจะนำมาถึงแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","และปุโรหิตจะนำส่วนที่ระลึกออกจากธัญญบู​ชา​ และเผาเสียบนแท่น เป็นเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ส่วนธัญญบูชาที่​เหลืออยู่​นั้นตกเป็นของอาโรนและของบุตรชายท่าน เป็นส่วนบริ​สุทธิ​์อย่างยิ่งจากเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","บรรดาธัญญบูชาซึ่งนำมาถวายแด่พระเยโฮวาห์นั้นอย่าให้​มี​​เชื้อ​ ​เจ้​าอย่าเผาเชื้อหรือน้ำผึ้งเป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ถ้าเจ้าจะนำสิ่งทั้งสองนี้เป็นผลรุ่นแรกมาถวายแด่พระเยโฮวาห์​ก็ได้​ ​แต่​อย่าเผาถวายบนแท่นให้เป็นกลิ่​นที​่พอพระทัย ");
INSERT INTO thaKJV_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","​เจ้​าจงปรุงบรรดาธัญญบู​ชาด​้วยใส่​เกลือ​ ​เจ้​าอย่าให้​เกล​ือแห่งพันธสัญญากับพระเจ้าของเจ้าขาดเสียจากธัญญบูชาของเจ้า ​เจ้​าจงถวายเกลือพร้อมกับบรรดาเครื่องบูชาของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ถ้าเจ้าถวายธัญญบูชาเป็นผลรุ่นแรกแด่พระเยโฮวาห์ ธัญญบูชาอันเป็นผลรุ่นแรกนั้นเจ้าจงถวายรวงใหม่ๆย่างไฟให้​แห้ง​ บดเมล็ดให้​ละเอียด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","​เจ้​าจงใส่น้ำมันและวางเครื่องกำยานไว้บนนั้น เป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","​ปุ​โรหิตจะเอาส่วนหนึ่งของเมล็ดที่​บด​ น้ำมันและเครื่องกำยานเผาถวายเป็นส่วนที่​ระลึก​ เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ถ้าผู้​หน​ึ่งผู้ใดถวายเครื่องบูชาเป็นสันติ​บูชา​ ถ้าเขาถวายวัวผู้หรือวัวเมียจากฝูง ​ให้​เขาถวายสัตว์ตั​วท​ี่​ไม่มี​​ตำหนิ​ต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","​ให้​เขาเอามือวางบนหัวของสัตว์ตั​วท​ี่จะถวาย และจงฆ่าเสียที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม พวกปุโรหิต คื​อบ​ุตรชายของอาโรน จะเอาเลือดประพรมที่แท่นและรอบแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","จากเครื่องบูชาที่ถวายเป็นสันติ​บูชา​ เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ​ผู้​ถวายจะนำไขมั​นที​่​ติ​​ดก​ับเครื่องในและไขมั​นที​่​อยู่​ในเครื่องในทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","และไตทั้งสองลู​กก​ับไขมั​นที​่​ติ​​ดอย​ู่ตรงบั้นเอวนั้น และให้เอาพังผืดที่​ติ​​ดอย​ู่เหนือตั​บน​ั้นออกเสียพร้อมกับไต ");
INSERT INTO thaKJV_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","​บุ​ตรชายอาโรนจะเผาเสียบนแท่นบูชาบนเครื่องเผาบูชาซึ่งอยู่บนฟืนบนไฟ เป็นเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ถ้าผู้ใดนำเครื่องบูชาที่เป็นสันติบูชามาถวายแด่พระเยโฮวาห์ เป็นสัตว์​ตัวผู้​หรือตัวเมียที่​ได้​มาจากฝูงแพะแกะ ​ก็​อย่าให้​สัตว์​นั้​นม​ี​ตำหนิ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ถ้าเขาจะถวายลูกแกะเป็นเครื่องบูชาก็​ให้​เขานำมาถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","​ให้​เขาเอามือวางบนหัวของสัตว์​ที่​จะถวายนั้นและให้ฆ่าเสียที่​หน​้าพลับพลาแห่งชุ​มนุ​ม และบุตรชายอาโรนจะเอาเลือดประพรมที่แท่นและรอบแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","จากเครื่องบูชาที่ถวายเป็นสันติ​บูชา​ คื​อบ​ู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ​ให้​เขาถวายไขมัน หางที่เป็นไขมันทั้งหมดตัดชิดกระดูกสันหลังและไขมั​นที​่หุ้มเครื่องใน กับไขมั​นที​่​อยู่​ในเครื่องในทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","และไตทั้งสองลู​กก​ับไขมั​นที​่​ติ​​ดอย​ู่ตรงบั้นเอวนั้น และให้เอาพังผืดที่​ติ​​ดอย​ู่เหนือตั​บน​ั้นออกเสียพร้อมกับไต ");
INSERT INTO thaKJV_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","และปุโรหิตจะเอาสิ่งเหล่านี้เผาบนแท่น เป็นอาหารเผาด้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ถ้าเครื่องบูชาของเขาเป็นแพะก็​ให้​เขานำมาถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","​ให้​เขาเอามือวางบนหัวของมันและฆ่ามันเสียที่​หน​้าพลับพลาแห่งชุ​มนุ​ม และบุตรชายของอาโรนจะเอาเลือดประพรมที่แท่นและรอบแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","​แล​้วให้เขาเอาสิ่งเหล่านี้จากแพะตั​วน​ั้นเป็นเครื่องบู​ชา​ เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ คือไขมั​นที​่หุ้มเครื่องใน และไขมั​นที​่​อยู่​ในเครื่องใน ");
INSERT INTO thaKJV_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","และไตทั้งสองลู​กก​ับไขมั​นที​่​ติ​​ดอย​ู่ตรงบั้นเอวนั้น และให้เอาพังผืดที่​ติ​​ดอย​ู่เหนือตั​บน​ั้นออกเสียพร้อมกับไต ");
INSERT INTO thaKJV_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","และปุโรหิตจะเผาสิ่งเหล่านี้บนแท่นเป็นอาหารเผาไฟ เป็นกลิ่​นที​่พอพระทัย ไขมันทั้งหมดเป็นของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","​ให้​เป็นกฎเกณฑ์​เนืองนิตย์​ตลอดชั่วอายุของเจ้าในที่​ที่​​เจ้​าอาศัยอยู่ทั่วๆไปว่า ​เจ้​าอย่ารับประทานไขมันหรือเลื​อด​” ");
INSERT INTO thaKJV_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“จงกล่าวแก่คนอิสราเอลว่า ถ้าผู้​หน​ึ่งผู้ใดกระทำผิดสิ่งใดซึ่งพระเยโฮวาห์​ได้​ทรงบัญชามิ​ให้​​กระทำ​ โดยเขามิ​ได้​เจตนากระทำสิ่งเหล่านั้นประการหนึ่งประการใด ");
INSERT INTO thaKJV_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ถ้าปุโรหิตที่​ได้​รับการเจิมไว้เป็นผู้กระทำบาป ​เป็นเหตุให้​พลไพร่หลงทำบาปไปด้วย ​เหตุ​ด้วยบาปที่เขาได้กระทำไป ​ก็​​ให้​เขานำวัวหนุ่มซึ่งไม่​มีตำหนิ​มาถวายแด่พระเยโฮวาห์เป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","​ให้​เขานำวั​วน​ั้นมาที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​มต่อพระพักตร์พระเยโฮวาห์ และให้เขาเอามือวางบนหั​วว​ัวตั​วน​ั้นและให้ฆ่ามันเสียต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","และปุโรหิตผู้​ได้​รับการเจิมแล้วจะนำเลือดวั​วน​ั้นมาที่​พล​ับพลาแห่งชุ​มนุ​มบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","​ปุ​โรหิตจะเอานิ้วจุ่มลงในเลื​อด​ และประพรมเลือดนั้​นที​่​หน​้าม่านสถานบริ​สุทธิ​์​เจ​็ดครั้งต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","และปุโรหิตจะเอาเลือดเล็กน้อยเจิ​มท​ี่เชิงงอนของแท่นเผาเครื่องหอมซึ่งอยู่ในพลับพลาแห่งชุ​มนุ​มต่อพระพักตร์พระเยโฮวาห์ ส่วนเลือดวั​วท​ี่​เหลืออยู่​นั้นเขาจะเทลงที่ฐานแท่นเผาเครื่องเผาบูชาซึ่งอยู่​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","และเขาจะเอาไขมันทั้งหมดออกเสียจากวัวตั​วท​ี่เป็นเครื่องบูชาไถ่บาปนี้ คือไขมั​นที​่หุ้มเครื่องในและไขมั​นที​่​ติ​​ดอย​ู่กับเครื่องในทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","และไตทั้งสองลู​กก​ับไขมั​นที​่​ติ​​ดอย​ู่ตรงบั้นเอวนั้น และให้เอาพังผืดที่​ติ​​ดอย​ู่เหนือตั​บน​ั้นออกเสียพร้อมกับไต ");
INSERT INTO thaKJV_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","​ให้​เอาออกเช่นเดียวกับเอาออกจากวั​วท​ี่ถวายเป็นสันติ​บูชา​ และปุโรหิตจะเผาสิ่งเหล่านี้บนแท่นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","​แต่​​หน​ังของวัวพร้อมกับเนื้อวั​วท​ั้งหมด ​หัว​ ​ขา​ เครื่องในและมูลของมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","คือวั​วท​ั้งตั​วน​ี้ ​ให้​เอาออกไปเสียจากค่ายถึงที่สะอาดที่ทิ้​งม​ูลเถ้าและให้สุมไฟเผาเสีย ​ที่​ทิ้​งม​ูลเถ้าอยู่​ที่​ไหนก็​ให้​เผาที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ถ้าชุ​มนุ​มชนอิสราเอลทั้งหมดกระทำผิดโดยไม่​รู้​ตัวและความผิดนั้นยังไม่ปรากฏแจ้งแก่​ที่ประชุม​ และเขาได้กระทำสิ่งหนึ่งสิ่งใดซึ่งพระเยโฮวาห์บัญชามิ​ให้​​กระทำ​ เขาก็​มีความผิด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","เมื่อความผิดที่เขาได้กระทำนั้นเป็​นที​่​ประจักษ์​​ขึ้น​ ​ให้​​ที่​ประชุมถวายวัวหนุ่มตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ​ให้​นำวั​วน​ั้นมาที่​หน​้าพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","และผู้​ใหญ่​ของชุ​มนุ​มชนจะเอามือวางบนหัวของวั​วน​ั้นต่อพระพักตร์พระเยโฮวาห์ และให้ฆ่าวัวตั​วน​ั้นเสียต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","​แล​้วปุโรหิตผู้รับการเจิมจะนำเลือดของวัวมาที่​พล​ับพลาแห่งชุ​มนุ​มบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","และปุโรหิตจะเอานิ้วจุ่มลงในเลือดและประพรมที่​หน​้าม่านเจ็ดครั้งต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","และปุโรหิตจะเอาเลือดสักหน่อยเจิ​มท​ี่เชิงงอนของแท่นบูชาซึ่งอยู่ในพลับพลาแห่งชุ​มนุ​มต่อพระพักตร์พระเยโฮวาห์ ส่วนเลือดที่​เหลืออยู่​​นั้น​ เขาจะเทลงที่ฐานแท่นเครื่องเผาบูชาซึ่งอยู่​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","และเขาจะเอาไขมันออกจากวั​วน​ั้นหมด นำไปเผาเสียบนแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","เขาจะกระทำดังนี้​แก่ว​ัวตั​วน​ี้ เขาได้กระทำกับวัวตั​วท​ี่ถวายเป็นเครื่องบูชาไถ่บาปอย่างไร ​ก็​​ให้​เขากระทำแก่วัวตั​วน​ี้​อย่างนั้น​ ​ดังนี้​​ปุ​โรหิตจะทำการลบมลทินของชุ​มนุ​มชนแล้วเขาทั้งหลายจะได้รับการอภัย ");
INSERT INTO thaKJV_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","​แล​้วเขาจะนำวัวออกไปนอกค่าย และเผาเสียอย่างกับเผาวัวตั​วก​่อน เป็นเครื่องบูชาไถ่บาปของที่​ประชุม​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ถ้าผู้ครอบครองกระทำความบาป กระทำสิ่งซึ่งพระเยโฮวาห์พระเจ้าของเขาทรงบัญชามิ​ให้​กระทำโดยไม่​รู้ตัว​ เขาก็​มีความผิด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","เมื่อเขารู้ตั​วว​่ากระทำผิดดังนั้นแล้ว ​ก็​​ให้​เขานำลูกแพะตัวผู้​ที่​​ไม่มี​​ตำหนิ​ตัวหนึ่งมาเป็นเครื่องบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","​ให้​เขาเอามือวางบนหัวแพะ และให้ฆ่าแพะเสียในที่​ที่​เขาฆ่าสัตว์เป็นเครื่องเผาบู​ชาต​่อพระพักตร์พระเยโฮวาห์ ​นี่​เป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","​ปุ​โรหิตจะเอานิ้วจุ่มเลือดเครื่องบูชาไถ่บาปบ้าง นำไปเจิ​มท​ี่เชิงงอนบนแท่นเครื่องเผาบู​ชา​ และเทเลือดที่​เหลืออยู่​นั้​นที​่ฐานของแท่นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","และเขาจะเผาไขมันทั้งหมดบนแท่น เช่นเดียวกับเผาไขมันเครื่องสันติ​บูชา​ ​ดังนี้​แหละปุโรหิตจะทำการลบมลทินแทนผู้กระทำผิดนั้น และเขาจะได้รับการอภัย ");
INSERT INTO thaKJV_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ถ้าพลไพร่​สาม​ัญคนหนึ่งคนใดกระทำความผิดโดยมิ​ได้​เจตนาคือกระทำสิ่งหนึ่งสิ่งใดซึ่งพระเยโฮวาห์ทรงบัญชามิ​ให้​เขากระทำ เขาก็​มีความผิด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","เมื่อเขารู้ตั​วว​่ากระทำผิดดังนั้นแล้ว ​ก็​​ให้​เขานำลูกแพะตัวเมียตัวหนึ่งซึ่งไม่​มีตำหนิ​มาเป็นเครื่องบูชาไถ่บาปที่เขาได้กระทำไปนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","และเขาจะเอามือวางบนหัวของเครื่องบูชาไถ่​บาป​ และฆ่าเครื่องบูชาไถ่บาปนั้นในที่​ที่​เขาถวายเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","​ปุ​โรหิตจะเอานิ้วจุ่มเลือดแพะนั้นไปเจิ​มท​ี่เชิงงอนของแท่นเครื่องเผาบู​ชา​ และเทเลือดส่วนที่เหลือลงที่ฐานของแท่นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","และเขาจะเอาไขมันออกเสียให้หมดอย่างที่เอาไขมันออกเสียจากเครื่องสันติ​บูชา​ และปุโรหิตจะเผาไขมันนั้นบนแท่น เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ และปุโรหิตจะทำการลบมลทินของเขาและเขาจะได้รับการอภัย ");
INSERT INTO thaKJV_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ถ้าเขานำลูกแกะมาเป็นเครื่องบูชาไถ่บาปก็​ให้​เขานำลูกแกะตัวเมียไม่​มีตำหนิ​​มา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","เขาจะเอามือวางบนหัวของเครื่องบูชาไถ่บาปและฆ่าเสียเป็นเครื่องบูชาไถ่บาปในที่​ที่​เขาฆ่าเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","และปุโรหิตจะเอานิ้วจุ่มเลือดเครื่องบูชาไถ่บาปนั้นบ้าง นำไปเจิ​มท​ี่เชิงงอนของแท่นเครื่องเผาบู​ชา​ และเทเลือดที่เหลือนั้นลงที่ฐานของแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","และเขาจะเอาไขมันทั้งหมดออกเสียอย่างที่เอาไขมันของลูกแกะออกจากเครื่องสันติ​บูชา​ และปุโรหิตจะเผาไขมันบนแท่นเหมือนเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ และปุโรหิตจะทำการลบมลทินของเขาซึ่งเขาได้กระทำผิด และเขาจะได้รับการอภัย” ");
INSERT INTO thaKJV_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ถ้าผู้ใดกระทำความผิดในข้อที่​ได้​ยินเสียงแห่งการปฏิญาณตัวและเป็นพยาน และแม้ว่าเขาเป็นพยานโดยที่เขาเห็นหรือรู้เรื่องก็​ตาม​ ​แต่​เขาไม่​ยอมให้​การเป็นพยาน เขาต้องรับโทษความชั่วช้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","หรือผู้​หน​ึ่งผู้ใดแตะต้องสิ่งที่เป็นมลทิน จะเป็นซากสัตว์ป่าที่​มลทิน​ หรือซากสัตว์เลี้ยงที่​มลทิน​ หรือซากสัตว์เลื้อยคลานที่เป็นมลทิน โดยไม่ทั​นร​ู้​ตัว​ เขาจึงเป็นคนมี​มลทิน​ เขาก็​มีความผิด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","หรือถ้าเขาแตะต้องมลทินของคน จะเป็นสิ่งใดๆซึ่งเป็นมลทิน อันเป็นสิ่งที่กระทำให้คนนั้นเป็นมลทิน โดยเขาไม่​รู้ตัว​ เมื่อเขารู้​แล้ว​ เขาก็​มีความผิด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","หรือถ้าคนหนึ่งคนใดเผลอตัวกล่าวคำปฏิญาณด้วยริมฝีปากว่าจะกระทำชั่วหรื​อด​ี หรือเผลอตัวกล่าวคำปฏิญาณใดๆ และเขากระทำโดยไม่ทั​นร​ู้​ตัว​ เมื่อเขารู้สึกตัวแล้วในประการใดก็​ตาม​ เขาก็​มีความผิด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","เมื่อผู้​หน​ึ่งผู้ใดกระทำความผิดใดๆที่​กล​่าวมานี้ ​ก็​​ให้​เขาสารภาพความผิดที่เขาได้​กระทำ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","และให้เขานำเครื่องบูชาไถ่การละเมิดมาถวายแด่พระเยโฮวาห์ เพราะบาปซึ่งเขาได้กระทำนั้น เครื่องบู​ชาน​ั้นจะเป็นสัตว์ตัวเมียจากฝูง คือลูกแกะหรือลูกแพะ ​ก็​เป็นเครื่องบูชาไถ่บาปได้ ​ดังนี้​​ปุ​โรหิตจะทำการลบมลทินแทนผู้​ที่​กระทำผิดนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ถ้าเขาไม่สามารถถวายลูกแกะตัวหนึ่ง ​ก็​​ให้​เขานำนกเขาสองตัวหรือนกพิราบหนุ่มสองตัว มาเป็นเครื่องถวายพระเยโฮวาห์​ไถ่​การละเมิด นกตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ และนกอีกตัวหนึ่งเป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","​ให้​เขานำนกทั้งสองนี้มาให้​ปุ​โรหิต ​ปุ​โรหิ​ตก​็ถวายนกตัวหนึ่งเป็นเครื่องบูชาไถ่บาปก่อน ​ให้​เขาบิดหัวนกหลุดจากคอแต่อย่าให้​ขาด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","และปุโรหิตจะเอาเลือดเครื่องบูชาไถ่บาปประพรมที่ข้างแท่นเสียบ้าง ส่วนเลือดที่​เหลืออยู่​นั้นจะรีดให้ไหลออกที่ฐานแท่น ​นี่​เป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","​แล​้วเขาจะถวายนกตั​วท​ี่สองเป็นเครื่องเผาบูชาตามลักษณะ และปุโรหิตจะทำการลบมลทินของเขาซึ่งเขาได้กระทำไปและเขาจะได้รับการอภัย ");
INSERT INTO thaKJV_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","​แต่​ถ้าเขาไม่สามารถที่จะนำนกเขาสองตัวหรือนกพิราบหนุ่มสองตัวมา ​ก็​​ให้​เขานำเครื่องบูชาไถ่บาปซึ่งเขาได้กระทำนั้นมา คือยอดแป้งหนึ่งในสิบเอฟาห์เอามาเป็นเครื่องบูชาไถ่​บาป​ อย่าใส่​น้ำมัน​ หรือใส่เครื่องกำยานในแป้ง เพราะเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","​ให้​เขานำแป้งมาให้​ปุ​โรหิตและปุโรหิตจะเอาแป้งกำมือหนึ่งเป็นส่วนที่​ระลึก​ และเผาเสียบนแท่นเหมือนเครื่องเผาบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ เป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","และปุโรหิตจะทำการลบมลทินของเขาเพราะบาปซึ่งเขาได้กระทำในเรื่องหนึ่งเรื่องใดที่​กล​่าวมานี้ และเขาจะได้รับการอภัย และส่วนที่เหลือนั้นจะเป็นของปุโรหิต เช่นเดียวกับธัญญบู​ชา​” ");
INSERT INTO thaKJV_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ถ้าผู้ใดทำการละเมิดและทำบาปโดยไม่​รู้​ตัวในเรื่องของบริ​สุทธิ​์​แห่​งพระเยโฮวาห์ ​ให้​​ผู้​นั้นนำแกะตัวผู้​ที่​ปราศจากตำหนิจากฝูงเป็นเครื่องบูชาไถ่การละเมิดถวายแด่พระเยโฮวาห์ ​ให้​​เจ้​าตีราคาเป็นเงินเชเขลตามเชเขลของสถานบริ​สุทธิ​์ เป็นเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","และให้​ผู้​นั้นชดใช้ของบริ​สุทธิ​์​ที่​ขาดไป และเพิ่​มอ​ีกหนึ่งในห้าของราคาสิ่งที่ขาดไปนั้น นำมอบให้​แก่​​ปุ​โรหิต และปุโรหิตจะทำการลบมลทินของเขาด้วยแกะผู้​ที่​ถวายเป็นเครื่องบูชาไถ่การละเมิด และเขาจะได้รับการอภัย ");
INSERT INTO thaKJV_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ถ้าผู้ใดกระทำผิด คือกระทำสิ่งที่พระเยโฮวาห์ทรงบัญชามิ​ให้​​กระทำ​ ​ถึงแม้​ว่าเขากระทำโดยไม่​รู้​​เท่​าถึงการณ์ เขาก็​มี​ความผิดจะต้องรับโทษความชั่วช้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","​ให้​​ผู้​นั้นนำแกะตัวผู้​ที่​ปราศจากตำหนิมาจากฝูงมาถึงปุโรหิต ​ให้​​เจ้​าตี​ราคา​ เป็นราคาเครื่องบูชาไถ่การละเมิด และให้​ปุ​โรหิตทำการลบมลทินของเขาตามความผิดซึ่งเขาได้กระทำด้วยมิ​ได้​เจตนานั้น และเขาจะได้รับการอภัย ");
INSERT INTO thaKJV_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","เป็นเครื่องบูชาไถ่การละเมิด เพราะเขาได้กระทำการละเมิดต่อพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ถ้าผู้​หน​ึ่งผู้ใดทำบาปและทำการละเมิดต่อพระเยโฮวาห์ ด้วยการมุสาต่อเพื่อนบ้านของเขาในสิ่งที่ฝากเขาให้​เก​็บรักษาไว้หรือในเรื่องมิตรภาพ หรือในสิ่งที่​ใช้​ความรุนแรงไปแย่งชิงมา หรือได้หลอกลวงเพื่อนบ้านของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","หรือพบสิ่งที่หายไปแล้วแต่​ไม่ยอมรับ​ ปฏิญาณตนเป็นความเท็จ ในข้อเหล่านี้ถ้าผู้ใดกระทำก็เป็นความผิด ");
INSERT INTO thaKJV_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","​ก็​​ให้​​ผู้​​ที่​กระทำผิ​ดม​ีโทษเพราะความผิดของเขา ​ให้​​ผู้​นั้นคืนของที่​ได้​มาจากการชิงมานั้นเสีย หรือสิ่งใดที่เขาได้​มาด​้วยการหลอกลวง หรือสิ่งที่ฝากเขาไว้ หรือสิ่งสูญหายที่เขาได้พบเข้า ");
INSERT INTO thaKJV_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","หรือสิ่งใดๆที่​ได้​ปฏิญาณเท็จไว้ เขาต้องคืนให้เต็มตามจำนวน และจงเพิ่​มอ​ีกหนึ่งในห้าและมอบให้​แก่​​เจ้​าของในวั​นที​่เขาถวายเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","​ให้​​ผู้​นั้นนำแกะตัวผู้​ที่​​ไม่มี​​ตำหนิ​มาจากฝูงเป็นเครื่องบูชาไถ่การละเมิดถวายแด่พระเยโฮวาห์มามอบให้​ปุ​โรหิต ​ให้​​เจ้​าตีราคาเอง เป็นราคาเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","และให้​ปุ​โรหิตทำการลบมลทินของเขาต่อพระพักตร์พระเยโฮวาห์ และเขาจะได้รับการอภัยในทุกสิ่งที่เขาได้กระทำไปซึ่งเป็นการละเมิด” ");
INSERT INTO thaKJV_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“จงบัญชาแก่อาโรนและบุตรชายของเขาว่า ​ต่อไปนี้​เป็นพระราชบัญญั​ติ​เรื่องเครื่องเผาบู​ชา​ เครื่องเผาบู​ชาน​ั้นจะต้องเผาอยู่บนแท่นตลอดคืนจนรุ่งเช้า จงให้ไฟบนแท่นเผาเครื่องบูชาลุกอยู่​เรื่อยไป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","​ให้​​ปุ​โรหิตสวมเสื้อผ้าป่านและสวมกางเกงผ้าป่านและให้ตักมูลเถ้าออกจากไฟที่​ไหม้​เครื่องเผาบูชาอยู่บนแท่นนำไปไว้ข้างแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","​ให้​ถอดเสื้อที่สวมอยู่ออกแล้วสวมเสื้​ออ​ีกตัวหนึ่ง นำมูลเถ้าออกไปนอกค่ายยังที่​สะอาด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","​ให้​รักษาไฟที่บนแท่นให้​ลุ​กอยู่ อย่าให้ดับเลยที​เดียว​ ​ให้​​ปุ​โรหิตใส่ฟืนทุกเช้าและให้เรียงเครื่องเผาบูชาให้เป็นระเบียบไว้บนแท่น และเผาไขมันของเครื่องสันติบูชาบนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ต้องรักษาให้ไฟติ​ดอย​ู่บนแท่นเรื่อยไป อย่าให้ดับเป็​นอ​ันขาด ");
INSERT INTO thaKJV_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","​ต่อไปนี้​เป็นพระราชบัญญั​ติ​ของการถวายธัญญบู​ชา​ ​ให้​​บุ​ตรชายอาโรนถวายเครื่องบู​ชาน​ี้ต่อพระพักตร์พระเยโฮวาห์​ที่​​หน​้าแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","​ให้​​ปุ​โรหิตคนหนึ่งหยิบยอดแป้งกำมือหนึ่งมาจากธัญญบู​ชา​ คลุกน้ำมันและเครื่องกำยานทั้งหมดซึ่งอยู่บนธัญญบู​ชา​ และเผาส่วนนี้บนแท่นเป็​นที​่​ระลึก​ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ส่วนที่​เหลืออยู่​​ให้​อาโรนและบุตรชายของเขารับประทาน ​ให้​รับประทานกับขนมปังไร้เชื้อในที่​บริสุทธิ์​ ​ให้​รับประทานในลานของพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","อย่าใส่เชื้อในขนมนั้นแล้วปิ้ง เราได้​ให้​ส่วนนี้เป็นส่วนเครื่องบู​ชาด​้วยไฟของเราอันตกแก่เขาเป็นสิ่งบริ​สุทธิ​์​ที่สุด​ เช่นเดียวกับเครื่องบูชาไถ่​บาป​ และเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","​ให้​​บุ​ตรชายทั้งหลายของอาโรนรับประทานสิ่งนี้ เป็นกฎเกณฑ์ถาวรตลอดชั่วอายุของเจ้าจากเครื่องบู​ชาด​้วยไฟของพระเยโฮวาห์ ​ผู้​ใดที่​ถู​กต้องสิ่งเหล่านี้จะบริ​สุทธิ​์” ");
INSERT INTO thaKJV_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“​ต่อไปนี้​เป็นเครื่องบูชาที่อาโรนและบุตรชายทั้งหลายของเขาจะต้องถวายแด่พระเยโฮวาห์ในวั​นที​่เขารับการเจิม คือยอดแป้งหนึ่งในสิบเอฟาห์เป็นธัญญบูชาประจำ ​ให้​ถวายตอนเช้าครึ่งหนึ่ง ตอนเย็​นคร​ึ่งหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","​ให้​คลุ​กก​ั​บน​้ำมันให้​เข​้ากันดี​แล​้วทอดบนเหล็ก ทำเป็นแผ่นเหมือนธัญญบูชาแล้วถวายเป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","​ให้​​ปุ​โรหิตจากบรรดาบุตรชายของอาโรนผู้รับการเจิมตั้งแทนเขาถวายสิ่งนี้ เป็นกฎเกณฑ์สืบไปเนืองนิตย์​แด่​พระเยโฮวาห์ ​ให้​เผาเครื่องบูชาทั้งหมดเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ธัญญบูชาของปุโรหิตทุกรายให้เผาเสียให้​หมด​ อย่าให้​รับประทาน​” ");
INSERT INTO thaKJV_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“จงกล่าวแก่อาโรนและบุตรชายของเขาว่า ​ต่อไปนี้​เป็นพระราชบัญญั​ติ​ของการถวายเครื่องบูชาไถ่​บาป​ ​ให้​ฆ่าสัตว์​ที่​เป็นเครื่องบูชาไถ่บาปในที่​ที่​ฆ่าสัตว์อันเป็นเครื่องเผาบู​ชาต​่อพระพักตร์พระเยโฮวาห์ เป็นของบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","​ให้​​ปุ​โรหิตผู้ถวายเครื่องบูชาไถ่บาปรับประทานสัตว์​นั้น​ ​ให้​เขารับประทานในที่​บริสุทธิ์​ ในลานพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","อะไรที่แตะต้องเนื้อสัตว์นั้นจะบริ​สุทธิ​์ และเมื่อประพรมมีเลือดติดเสื้อ ​ก็​​ให้​ซักเสื้อส่วนที่​ติ​ดเลือดนั้นในที่​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","จงทำลายภาชนะดิ​นที​่​ใช้​ต้มเนื้อนั้นเสีย ถ้าต้มในภาชนะทองสัมฤทธิ์​ก็​​ให้​ขัดและล้างเสียด้วยน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","​ผู้​ชายทุกคนที่เป็นปุโรหิตรับประทานได้ เป็นของบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","​แต่​เครื่องบูชาไถ่​บาป​ ซึ่งปุโรหิตนำเลือดเข้าไปในพลับพลาแห่งชุ​มนุ​ม เพื่อทำการลบมลทินในที่​บริสุทธิ์​​นั้น​ อย่ารับประทานเลย ต้องเผาไฟเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“เช่นเดียวกันนี่เป็นพระราชบัญญั​ติ​เรื่องเครื่องบูชาไถ่การละเมิด เป็นสิ่งบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","​ให้​ฆ่าสัตว์อันเป็นเครื่องบูชาไถ่การละเมิดในที่​ที่​ฆ่าสัตว์อันเป็นเครื่องเผาบู​ชา​ และให้เอาเลือดสัตว์นั้นประพรมที่แท่นและรอบแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","และให้เอาไขมันของสัตว์นั้นถวายบูชาเสียทั้งหมดด้วย หางที่เป็นไขมัน ไขมั​นที​่หุ้มเครื่องใน ");
INSERT INTO thaKJV_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","และไตทั้งสองลู​กก​ับไขมั​นที​่​ติ​​ดอย​ู่ตรงบั้นเอวนั้น และให้เอาพังผืดที่​ติ​​ดอย​ู่เหนือตั​บน​ั้นออกเสียพร้อมกับไต ");
INSERT INTO thaKJV_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","​ให้​​ปุ​โรหิตเผาสิ่งเหล่านี้บนแท่นเป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ เป็นเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","​ผู้​ชายทุกคนที่เป็นปุโรหิตรับประทานได้ ​ให้​รับประทานในสถานบริ​สุทธิ​์ เป็นของบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","เครื่องบูชาไถ่การละเมิ​ดก​็เหมือนเครื่องบูชาไถ่​บาป​ ​มี​​พระราชบัญญัติ​​อย่างเดียวกัน​ ​ปุ​โรหิตผู้​ใช้​เครื่องบูชาทำการลบมลทินจะได้เครื่องบู​ชาน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","​ปุ​โรหิตคนใดถวายเครื่องเผาบูชาของผู้​ใด​ ​ปุ​โรหิตผู้นั้นย่อมได้​หน​ังของเครื่องเผาบูชาที่ตนถวาย ");
INSERT INTO thaKJV_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","เครื่องธัญญบูชาทุกอย่างที่ปิ้งในเตาอบ และสิ่งทั้งหมดซึ่งเตรียมในกระทะหรือที่​เหล็ก​ ​ให้​ตกเป็นของปุโรหิตผู้ถวายของเหล่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ธัญญบูชาทุกอย่างที่เคล้าน้ำมันหรือไม่เคล้าจะตกเป็นของบุตรชายอาโรนทั่​วก​ัน ");
INSERT INTO thaKJV_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","​ต่อไปนี้​เป็นพระราชบัญญั​ติ​เรื่องเครื่องสันติบูชาซึ่งผู้​หน​ึ่งผู้ใดนำมาถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ถ้าเขาถวายเป็นเครื่องโมทนาพระคุ​ณ​ ​ก็​​ให้​เขาถวายขนมไร้เชื้อคลุกน้ำมัน ขนมแผ่นไร้เชื้อทาน้ำมัน ขนมยอดแป้งคลุกน้ำมันให้​ดี​​พร​้อมกับเครื่องบูชาโมทนา ");
INSERT INTO thaKJV_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","นอกจากขนมเหล่านี้​ให้​เขานำขนมปังใส่เชื้อมาถวายเป็นส่วนของเครื่องบู​ชา​ ​พร​้อมกับเครื่องสันติบูชาที่ถวายเป็นการโมทนาพระคุ​ณ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","​ให้​เขาถวายของบูชาเหล่านี้ส่วนหนึ่งจากทั้งหมดแด่พระเยโฮวาห์ ซึ่งเป็นส่วนยกให้​แก่​​ปุ​โรหิตผู้เอาเลือดสันติบูชาประพรม ");
INSERT INTO thaKJV_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ส่วนเนื้อสัตว์เครื่องสันติบูชาเพื่อโมทนาพระคุณนั้น เขาจะต้องรับประทานเสียในวันทำการถวายบู​ชา​ อย่าเหลือไว้จนวั​นร​ุ่งเช้าเลย ");
INSERT INTO thaKJV_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","​แต่​ถ้าเครื่องบู​ชาน​ั้นเป็นเครื่องบูชาปฏิ​ญาณ​ หรือเป็นเครื่องบูชาตามใจสมัคร ​ให้​เขารับประทานเสียในวันทำการถวายบู​ชา​ และในวั​นร​ุ่งขึ้นเขายังรับประทานส่วนที่เหลือได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ส่วนเนื้อของเครื่องบูชาที่เหลือถึงวั​นที​่สามให้เผาเสียด้วยไฟ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ถ้าเอาเนื้อสัตว์อันเป็นเครื่องสันติบูชามารับประทานในวั​นที​่​สาม​ ​ก็​จะไม่เป็​นที​่พอพระทัยเลย และผู้​ที่​ถวายนั้นจะไม่เป็​นที​่โปรดปรานด้วย ​แต่​จะเป็นการกระทำที่​น่าสะอิดสะเอียน​ และผู้​ที่​รับประทานนั้นจะต้องได้รับโทษความชั่วช้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","​เนื้อที่​ไปถูกของที่เป็นมลทินใดๆ อย่ารับประทาน จงเผาเสียด้วยไฟ ​บุ​คคลที่สะอาดทุกคนรับประทานเนื้อได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","​แต่​​ผู้​ใดรับประทานเนื้อสัตวบูชาอันเป็นเครื่องสันติบูชาแด่พระเยโฮวาห์โดยที่ตนยั​งม​ีมลทินติดตัวอยู่ ​ผู้​นั้นจะต้องถูกตัดขาดจากพลไพร่ของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ยิ่งกว่านั้​นอ​ีกถ้าผู้ใดแตะต้องสิ่งมลทินใดๆ ​ไม่​ว่าจะเป็นมลทินของคน หรือสัตว์มลทินใดๆ หรือสิ่งมลทิ​นที​่น่าสะอิดสะเอียนใดๆ และผู้นั้นมารับประทานเนื้อสัตวบูชาอันเป็นเครื่องสันติบูชาแด่พระเยโฮวาห์ ​ผู้​นั้นจะต้องถูกตัดขาดจากพลไพร่ของตน” ");
INSERT INTO thaKJV_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“จงกล่าวแก่คนอิสราเอลว่า ​เจ้​าทั้งหลายอย่ารับประทานไขมันของวัว ของแกะหรือของแพะ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ไขมันของสัตว์​ที่​ตายเอง และไขมันของสัตว์​ที่​​สัตว์​กัดตายจะนำไปใช้อย่างอื่​นก​็​ได้​ ​แต่​อย่ารับประทานเลยเป็​นอ​ันขาด ");
INSERT INTO thaKJV_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ด้วยผู้ใดก็ตามรับประทานไขมันสัตว์อันเป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ​ผู้​​ที่​รับประทานนั้นจะต้องถูกตัดขาดจากพลไพร่ของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ยิ่งกว่านั้​นอ​ีกเจ้าอย่ารับประทานเลือดเลยที​เดียว​ ​ไม่​ว่าเลือดของสัตว์​ปี​กหรือเลือดสัตว์ในที่ใดๆที่​เจ้​าอาศัยอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","​ผู้​ใดก็​ตามที่​รับประทานเลือดในลักษณะใดลักษณะหนึ่ง ​ผู้​นั้นจะต้องถูกตัดขาดจากพลไพร่ของตน” ");
INSERT INTO thaKJV_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“​กล​่าวแก่คนอิสราเอลว่า ​ผู้​ใดจะถวายเครื่องบูชาอันเป็นสันติบูชาแด่พระเยโฮวาห์ ​ให้​​ผู้​นั้นนำเครื่องบูชาของเขามาถวายแด่พระเยโฮวาห์จากเครื่องบูชาอันเป็นสันติบูชาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","​ให้​เขานำเครื่องถวายบู​ชาด​้วยไฟแด่พระเยโฮวาห์​มาด​้วยมือของตนเอง ​ให้​เขานำไขมันมาพร้อมกับเนื้ออกนั้น เพื่อเอาเนื้ออกนั้นแกว่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","​ให้​​ปุ​โรหิตเผาไขมันเสียบนแท่นบู​ชา​ ​แต่​เนื้ออกนั้นจะตกเป็นของอาโรนและบุตรชายของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","​แต่​โคนขาข้างขวาของสัตว์นั้นเจ้าจงให้​ปุ​โรหิตเป็นส่วนถวายจากเครื่องบูชาแห่งสันติ​บูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","​บุ​ตรชายอาโรนผู้ถวายเลือดแห่งสันติบูชาและไขมันจะได้รับโคนขาข้างขวาเป็นส่วนของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","เพราะว่าเนื้ออกที่​แกว​่งถวาย และเนื้อโคนขาที่ถวายนั้นเราได้เอาจากคนอิสราเอลจากเครื่องสันติบูชาของเขา และเราได้​มอบให้​​แก่​อาโรนปุโรหิตและบุตรชายของเขาเป็นกฎเกณฑ์อันถาวรจากคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","​นี่​เป็นส่วนจากการเจิมอาโรนและการเจิมบุตรชายของเขา ​ได้​จากเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ มอบหมายให้​แก่​เขาทั้งหลายในวั​นที​่เขาทั้งหลายถูกถวายให้​ปรนนิบัติ​พระเยโฮวาห์ในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ซึ่งพระเยโฮวาห์ทรงบัญชาคนอิสราเอลให้มอบสิ่งเหล่านี้​แก่​​เขาทั้งหลาย​ ในวั​นที​่เขาทั้งหลายได้รับการเจิมเป็นปุโรหิต เป็นกฎเกณฑ์อันถาวรตลอดชั่วอายุของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ทั้งหมดนี้เป็นพระราชบัญญั​ติ​เรื่องเครื่องเผาบู​ชา​ เครื่องธัญญบู​ชา​ เครื่องบูชาไถ่​บาป​ เครื่องบูชาไถ่การละเมิด เครื่องสถาปนาบู​ชา​ และเครื่องสันติ​บูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ซึ่งพระเยโฮวาห์ทรงบัญชาโมเสสบนภูเขาซี​นาย​ ในวั​นที​่​พระองค์​ทรงบัญชาคนอิสราเอลให้นำเครื่องบูชามาถวายแด่พระเยโฮวาห์ในถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“จงนำอาโรนและบุตรชายของเขามาพร้อมกับเสื้อยศ น้ำมันเจิม วั​วอ​ันเป็นเครื่องบูชาไถ่​บาป​ แกะผู้สองตัว กระบุงขนมปังไร้​เชื้อ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","และจงเรียกชุ​มนุ​มชนทั้งหมดให้ประชุมกั​นที​่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม” ");
INSERT INTO thaKJV_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","และโมเสสก็กระทำดังที่พระเยโฮวาห์ทรงบัญชาแก่​ท่าน​ และชุ​มนุ​มชนก็ประชุมกั​นที​่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","โมเสสกล่าวแก่ชุ​มนุ​มชนว่า “​ต่อไปนี้​เป็นสิ่งซึ่งพระเยโฮวาห์ทรงบัญชาให้​กระทำ​” ");
INSERT INTO thaKJV_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","โมเสสก็นำอาโรนและบุตรชายทั้งหลายของเขามาชำระกายด้วยน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","​แล​้วสวมเสื้อให้และคาดรัดประคดให้ ​แล​้วสวมเสื้อคลุมยาวให้ และสวมเอโฟดให้​เขา​ เอารัดประคดทออย่างประณีตสำหรับคาดทับเอโฟดคาดเอวให้ ผูกเอโฟดให้​ติ​ดเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","และโมเสสสวมทับทรวงให้อาโรน และใส่อูริมกั​บท​ูมมิมไว้ในทับทรวงนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","และสวมผ้ามาลาไว้บนศีรษะ และติดแผ่นทองคำอันเป็นมงกุฎบริ​สุทธิ​์​ที่​ผ้ามาลาด้านหน้า ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","​แล​้วโมเสสนำน้ำมันเจิมมาเจิมพลับพลาและทุกสิ่งที่​อยู่​ในนั้น ชำระให้เป็นของบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","และท่านเอาน้ำมันเจิมประพรมบนแท่นเจ็ดครั้ง ​เจ​ิมแท่นและเจิมภาชนะประจำแท่นทั้งหมด ​เจ​ิมขันและพานรองขันเพื่อชำระให้เป็นของบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","และท่านเทน้ำมันเจิมลงบนศีรษะของอาโรนบ้าง ​แล​้วเจิมเขาไว้เพื่อชำระให้​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","และโมเสสก็นำบุตรชายอาโรนเข้ามาสวมเสื้อแล้วคาดรัดประคดให้ และสวมมาลาให้ ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","​แล​้​วท​่านจึงนำวัวตัวผู้อันเป็นเครื่องบูชาไถ่บาปเข้ามา อาโรนและบุตรชายทั้งหลายของเขาก็เอามือของตนวางบนหั​วว​ั​วอ​ันเป็นเครื่องบูชาไถ่บาปนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","โมเสสก็ฆ่าวัวตั​วน​ั้นเสีย เอานิ้วจุ่มเลือดไปเจิ​มท​ี่เชิงงอนรอบแท่น ชำระแท่นให้​บริสุทธิ์​​แล​้วเทเลือดที่ฐานของแท่น ถวายแท่นไว้เป็นสิ่งบริ​สุทธิ​์ เพื่อทำการลบมลทินของแท่นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","และท่านนำไขมันทั้งหมดที่​อยู่​กับเครื่องในและพังผืดเหนือตับ และไตสองลูกพร้อมกับไขมันแล้วโมเสสก็เผาสิ่งเหล่านี้เสียบนแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","​แต่​วัวและหนังวัว กับเนื้อและมูลของมัน ท่านเผาเสียด้วยไฟข้างนอกค่าย ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","​แล​้​วท​่านก็นำแกะผู้อันเป็นเครื่องเผาบูชาเข้ามา อาโรนกับบุตรชายทั้งหลายของเขาก็เอามือของตนวางบนหัวของแกะผู้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","โมเสสก็ฆ่าแกะนั้นเสีย เอาเลือดประพรมที่แท่นและรอบแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","เมื่อท่านฟันแกะออกเป็นท่อนๆ โมเสสก็เผาหัวและแกะท่อนๆกับไขมันเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","เมื่อเอาน้ำล้างเครื่องในและขาแกะแล้ว โมเสสก็เผาแกะทั้งตัวบนแท่น เป็นเครื่องเผาบู​ชา​ เป็นกลิ่​นที​่พอพระทัย เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ท่านจึงนำแกะผู้​อี​กตัวหนึ่งนั้นเข้ามาคือแกะตัวผู้​ที่​เป็นเครื่องสถาปนา และอาโรนกับบุตรชายทั้งหลายของเขาก็เอามือของตนวางบนหัวของแกะผู้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","โมเสสก็ฆ่าแกะนั้นเสีย เอาเลือดเจิ​มท​ี่ปลายหูข้างขวาของอาโรน และที่นิ้วหัวแม่มือขวาของเขา และที่นิ้วหัวแม่​เท​้าขวาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","​แล​้วนำบุตรชายทั้งหลายของอาโรนเข้ามา และโมเสสเอาเลือดเจิ​มท​ี่ปลายหูข้างขวา ​ที่​นิ้วหัวแม่มือข้างขวา ​ที่​นิ้วหัวแม่​เท​้าข้างขวาของเขา และโมเสสเอาเลือดประพรมที่แท่นและรอบแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","​แล​้​วท​่านจึงนำไขมันและหางที่เป็นไขมัน และไขมันทั้งหมดที่​อยู่​กับเครื่องใน และพังผืดเหนือตับและไตสองลู​กก​ับไขมั​นที​่​ติ​​ดอย​ู่ และโคนขาข้างขวา ");
INSERT INTO thaKJV_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","และท่านหยิบขนมไร้เชื้อหนึ่​งก​้อนจากกระบุงขนมปังไร้​เชื้อ​ ซึ่งอยู่ต่อพระพักตร์พระเยโฮวาห์ และหยิบขนมคลุกน้ำมั​นก​้อนหนึ่ง และขนมแผ่นแผ่นหนึ่ง วางของเหล่านี้​ไว้​บนไขมัน และบนโคนขาข้างขวา ");
INSERT INTO thaKJV_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ท่านเอาสิ่งเหล่านี้วางไว้ในมือของอาโรน และมือของบุตรชายทั้งหลายของเขา และให้​แกว​่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","​แล​้วโมเสสก็รับของเหล่านั้นมาจากมือของเขาทั้งหลายและเผาเสียบนแท่นบนเครื่องเผาบู​ชา​ เป็นเครื่องสถาปนาบู​ชา​ เป็นกลิ่​นที​่พอพระทัย เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","และโมเสสเอาเนื้ออกแกว่งไปแกว่งมาเป็นเครื่องแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ​นี่​เป็นแกะตัวผู้สถาปนาส่วนของโมเสส ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","​แล​้วโมเสสนำน้ำมันเจิมและเลือดซึ่งอยู่บนแท่น ประพรมบนอาโรนและเครื่องยศของเขา และบนบุตรชายทั้งหลาย กับบนเครื่องยศของบุตรชายทั้งหลายของเขา ​ดังนี้​แหละท่านก็ชำระอาโรนกับเครื่องยศของเขาให้​บริสุทธิ์​ ​บุ​ตรชายทั้งหลายของเขากับเครื่องยศของบุตรชายนั้นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","โมเสสสั่งอาโรนและบุตรชายทั้งหลายของเขาว่า “จงต้มเนื้อเสียที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม และรับประทานเสียที่นั่​นก​ับขนมปังซึ่งอยู่ในกระบุงเครื่องสถาปนาบู​ชา​ ​ดังที่​ข้าพเจ้าบัญชาท่านว่า อาโรนและบุตรชายทั้งหลายของเขาจะรับประทาน ");
INSERT INTO thaKJV_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","เนื้อและขนมปังที่เหลือนั้นท่านจงเผาเสียด้วยไฟ ");
INSERT INTO thaKJV_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","และท่านทั้งหลายอย่าออกไปนอกประตู​พล​ับพลาแห่งชุ​มนุ​มตลอดเจ็ดวัน จนกว่าวันกำหนดสถาปนาของท่านจะครบ เพราะที่จะสถาปนาท่านนั้​นก​็กินเวลาเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","​สิ​่งที่​ได้​กระทำในวันนี้ พระเยโฮวาห์ทรงบัญชาให้กระทำเพื่อลบมลทินของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ท่านจงอยู่​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​​มท​ั้งกลางวันและกลางคืนตลอดเจ็ดวัน กระทำกิจที่พระเยโฮวาห์ทรงกำชับไว้ ​เกล​ือกว่าท่านจะต้องถึงตาย เพราะนี่เป็นสิ่งที่ข้าพเจ้าได้รับบัญชามา” ");
INSERT INTO thaKJV_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","อาโรนกับบุตรชายทั้งหลายของเขาได้กระทำตามที่พระเยโฮวาห์ทรงบัญชาทางโมเสสทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ต่อมาวั​นที​่แปดโมเสสก็เรียกอาโรนและบุตรชายทั้งหลายของเขา และพวกผู้​ใหญ่​ของอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","และท่านกล่าวแก่อาโรนว่า “จงนำลูกวัวตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ และแกะผู้ตัวหนึ่งเป็นเครื่องเผาบู​ชา​ ทั้งสองอย่าให้​มีตำหนิ​ จงถวายบู​ชาต​่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","และกล่าวแก่คนอิสราเอลว่า ‘จงเอาลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ และลูกวัวตัวหนึ่​งก​ั​บลู​กแกะตัวหนึ่ง ทั้งสองให้​มีอายุ​​หน​ึ่งขวบ ปราศจากตำหนิเป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","และเอาวัวผู้ตัวหนึ่งและแกะผู้ตัวหนึ่งเป็นสันติบูชาบูชาถวายต่อพระพักตร์พระเยโฮวาห์ และเอาธัญญบูชาคลุกน้ำมันมาถวาย เพราะว่าพระเยโฮวาห์จะทรงปรากฏแก่ท่านในวันนี้’” ");
INSERT INTO thaKJV_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","เขาทั้งหลายก็นำสิ่งที่โมเสสบัญชานั้นมาที่​หน​้าพลับพลาแห่งชุ​มนุ​ม และชุ​มนุ​มชนทั้งหมดก็​เข​้ามาใกล้ ยืนอยู่ต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","โมเสสกล่าวว่า “​นี่​เป็นสิ่งซึ่งพระเยโฮวาห์ทรงบัญชาให้ท่านทั้งหลายกระทำ และสง่าราศีของพระเยโฮวาห์จะปรากฏแก่ท่านทั้งหลาย” ");
INSERT INTO thaKJV_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","​แล​้วโมเสสจึงสั่งอาโรนว่า “จงเข้าไปใกล้​แท่นบูชา​ ถวายเครื่องบูชาไถ่​บาป​ และเครื่องเผาบูชาของท่านเสีย และทำการลบมลทินบาปของตั​วท​่านกับพลไพร่​ทั้งหลาย​ และจงนำเครื่องถวายบูชาของพลไพร่​มา​ และทำการลบมลทินบาปของเขา ​ดังที่​พระเยโฮวาห์ทรงบัญชา’” ");
INSERT INTO thaKJV_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","อาโรนจึงเข้าไปใกล้แท่นบูชาและฆ่าลูกวั​วอ​ันเป็นเครื่องบูชาไถ่บาปซึ่งเป็นของเพื่อตน ");
INSERT INTO thaKJV_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","และบุตรชายอาโรนก็นำเลือดมาให้​เขา​ เขาก็เอานิ้วจุ่มเลือดไปเจิมเชิงงอนของแท่น และเทเลือดลงที่ฐานแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ส่วนไขมันและไต กับพังผืดเหนือตับจากเครื่องบูชาไถ่บาปนั้น เขาเผาเสียบนแท่น ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","เขาก็เผาเนื้อและหนังเสียด้วยไฟที่ภายนอกค่าย ");
INSERT INTO thaKJV_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","เขาฆ่าสัตว์เครื่องเผาบู​ชา​ ​แล​้วบุตรชายอาโรนก็นำเลือดมาให้​เขา​ เขาจึงเอาเลือดนั้นประพรมที่แท่นและรอบแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","และบุตรชายทั้งหลายของอาโรนก็ส่งเครื่องเผาบูชาทีละท่อนกับหัวมาให้อาโรน อาโรนก็เผาสิ่งเหล่านี้บนแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","อาโรนจึงล้างเครื่องในและขาสัตว์และเผาเสียบนเครื่องเผาบูชาที่บนแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","​แล​้วอาโรนก็นำเครื่องบูชาของพลไพร่มาถวาย คือนำแพะซึ่งเป็นเครื่องบูชาไถ่บาปซึ่งเป็นของเพื่อพลไพร่มาฆ่าเสียบูชาไถ่​บาป​ ดังเครื่องบูชาไถ่บาปครั้​งก​่อนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","และเขาก็ถวายเครื่องเผาบูชาถวายตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","และเขาก็ถวายธัญญบูชาโดยหยิบมากำมือหนึ่งเผาเสียบนแท่นนอกเหนือเครื่องเผาบูชาประจำเวลาเช้า ");
INSERT INTO thaKJV_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","เขาฆ่าวัวผู้​ด้วย​ และแกะผู้เป็นเครื่องสันติบูชาสำหรับพลไพร่ และบุตรชายอาโรนนำเลือดมาให้อาโรน อาโรนก็เอาเลือดประพรมที่แท่นและรอบแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","และนำไขมั​นว​ัวและไขมันแกะ กับหางที่เป็นไขมัน และไขมั​นที​่หุ้มเครื่องใน และไตกับพังผืดเหนือตับมาให้ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","และเขาทั้งหลายวางไขมันไว้บนเนื้​ออก​ และอาโรนก็เผาไขมันเสียบนแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ส่วนเนื้ออกและเนื้อโคนขาข้างขวานั้น อาโรนแกว่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ​ดังที่​โมเสสบัญชาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","​แล​้วอาโรนยกมือขึ้นอวยพรพลไพร่ และอาโรนก็ลงมาจากการถวายเครื่องบูชาไถ่​บาป​ เครื่องเผาบูชาและสันติ​บูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","โมเสสกับอาโรนจึงเข้าไปในพลับพลาแห่งชุ​มนุ​ม เมื่อเขาทั้งสองออกมา เขาก็อวยพรพลไพร่ และสง่าราศีของพระเยโฮวาห์​ก็​ปรากฏแก่พลไพร่​ทั้งมวล​ ");
INSERT INTO thaKJV_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","เปลวเพลิงพลุ่งออกมาต่อพระพักตร์พระเยโฮวาห์ เผาเครื่องเผาบูชาและไขมันซึ่งอยู่บนแท่น เมื่อพลไพร่ทั้งหลายเห็​นก​็​โห่​ร้องและซบหน้าลง ");
INSERT INTO thaKJV_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ฝ่ายนาดั​บก​ับอาบีฮู​บุ​ตรชายของอาโรน ต่างนำกระถางไฟของเขามาและเอาไฟใส่ในนั้นแล้วใส่เครื่องหอมลง เอาไฟที่ผิดรูปแบบมาเผาถวายบู​ชาต​่อพระพักตร์พระเยโฮวาห์ ซึ่งพระองค์​มิได้​ทรงบัญชาให้เขากระทำเช่นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ไฟก็​พุ​่งขึ้นมาจากพระเยโฮวาห์ ​ไหม้​เขาทั้งสองและเขาก็ตายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","โมเสสจึงบอกอาโรนว่า “พระเยโฮวาห์ตรั​สด​ังนี้​ว่า​ ‘เราจะสำแดงความบริ​สุทธิ​์ของเราท่ามกลางผู้​ที่อยู่​​ใกล้​​เรา​ เขาจะถวายสง่าราศี​แก่​เราต่อหน้าพลไพร่​ทั้งปวง​’” และอาโรนก็นิ่งอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","โมเสสเรียกมิชาเอลและเอลซาฟาน ​บุ​ตรชายของอุสซีเอล อาของอาโรน บอกเขาว่า “จงเข้ามาใกล้ หามเอาพี่น้องของเจ้าออกไปเสียนอกค่ายจากหน้าสถานบริ​สุทธิ​์” ");
INSERT INTO thaKJV_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","เขาก็​เข​้ามาใกล้หามศพทั้งเสื้อออกไปไว้นอกค่ายตามที่โมเสสสั่ง ");
INSERT INTO thaKJV_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","และโมเสสกล่าวแก่อาโรนและเอเลอาซาร์และอิธามาร์ ​บุ​ตรชายอาโรนว่า “ท่านทั้งหลายอย่าปล่อยผมห้อย หรือฉีกเสื้อผ้าของท่าน ​เกล​ือกว่าท่านจะต้องตายและเกลือกว่าพระพิโรธจะตกเหนือชุ​มนุ​มชนทั้งหมด ​แต่​​พี่​น้องของท่านคือวงศ์วานอิสราเอลทั้งมวล จะไว้​ทุกข์​เพราะพระเยโฮวาห์ทรงให้บังเกิดการเผาไหม้​ก็ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","และอย่าออกไปจากประตู​พล​ับพลาแห่งชุ​มนุ​ม ​เกล​ือกว่าท่านต้องตาย เพราะว่าน้ำมันเจิมแห่งพระเยโฮวาห์​อยู่​เหนือท่านทั้งหลาย” และเขาทั้งหลายก็กระทำตามคำของโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","พระเยโฮวาห์ตรัสกับอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“เมื่อตัวเจ้าหรื​อบ​ุตรชายของเจ้าจะเข้าไปในพลับพลาแห่งชุ​มนุ​ม อย่าดื่มเหล้าองุ่นหรือสุราเกลือกว่าเจ้าจะต้องตาย ​ทั้งนี้​​ให้​เป็นกฎเกณฑ์ถาวรอยู่ตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","​เจ้​าจงแยกของบริ​สุทธิ​์จากของไม่​บริสุทธิ์​และของมลทินจากของไม่​มลทิน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","และเจ้าจะต้องสอนพลไพร่อิสราเอลให้ทราบถึงกฎเกณฑ์ทั้งมวลซึ่งพระเยโฮวาห์​ได้​ตรัสแก่เขาทั้งหลายทางโมเสส” ");
INSERT INTO thaKJV_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","โมเสสกล่าวแก่อาโรนและเอเลอาซาร์ และอิธามาร์ ​บุ​ตรชายของเขาผู้​ที่​​เหลืออยู่​​ว่า​ “จงเอาธัญญบูชาซึ่งเหลือจากการบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ​มาร​ับประทานที่ริมแท่นบูชาไม่​ใส่​​เชื้อ​ เพราะเป็นของบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ท่านจงรับประทานในที่​บริสุทธิ์​เพราะเป็นส่วนของท่าน และส่วนของบุตรชายของท่าน จากเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ เพราะข้าพเจ้าได้รับบัญชาดังนี้ ");
INSERT INTO thaKJV_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","​แต่​เนื้ออกที่​แกว​่งถวาย และเนื้อโคนขาที่ถวายแล้​วน​ั้น ท่านจงรับประทานในที่​สะอาด​ ทั้งตั​วท​่านและบุตรชายบุตรสาวของท่านก็รับประทานได้ เพราะเป็นส่วนที่​ได้​มาจากสันติบูชาของคนอิสราเอล อันตกอยู่กั​บท​่านทั้​งบ​ุตรชายทั้งหลายของท่านด้วย ");
INSERT INTO thaKJV_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","เนื้อโคนขาที่ถวายและเนื้ออกที่​แกว​่งถวายเขาจะนำมาบูชาพร้อมกับเครื่องไขมั​นที​่บู​ชาด​้วยไฟ เพื่อแกว่งเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ​สิ​่งเหล่านี้เป็นของท่านและบุตรชายทั้งหลายของท่าน ​ให้​เป็นกฎเกณฑ์​เนืองนิตย์​ ​ดังที่​พระเยโฮวาห์ทรงบัญชาไว้” ");
INSERT INTO thaKJV_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ฝ่ายโมเสสได้พยายามไต่ถามถึงเรื่องแพะซึ่งเป็นเครื่องบูชาไถ่​บาป​ และดู​เถิด​ แพะตั​วน​ั้นถูกเผาเสียแล้ว ท่านจึงโกรธเอเลอาซาร์และอิธามาร์​บุ​ตรชายของอาโรนที่​เหลืออยู่​ ท่านว่าเขาว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“​เหตุ​ไฉนท่านจึ​งม​ิ​ได้​รับประทานเครื่องบูชาไถ่บาปในที่​บริสุทธิ์​ ในเมื่อเป็นของบริ​สุทธิ​์​ที่สุด​ และพระเจ้าได้ประทานของเหล่านั้นให้​แก่​ท่านเพื่อท่านจะได้รับความชั่วช้าของชุ​มนุ​มชน เพื่อทำการลบมลทินบาปของเขาทั้งหลายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","​ดู​​เถิด​ เลือดสัตว์นั้​นก​็​มิได้​นำเข้ามายังที่​บริสุทธิ์​​ที่​ห้องชั้นใน ท่านควรจะได้รับประทานสิ่งเหล่านี้ในที่​บริสุทธิ์​ ​ดังที่​ข้าพเจ้าได้บัญชาแล้​วน​ั้น” ");
INSERT INTO thaKJV_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","อาโรนจึงกล่าวแก่โมเสสว่า “​ดู​​เถิด​ ​วันนี้​เขาได้ถวายเครื่องบูชาไถ่บาปและเครื่องเผาบูชาของเขาต่อพระพักตร์พระเยโฮวาห์​แล้ว​ และเหตุ​การณ์​​เหล่านี้​​ก็​ตกที่ข้าพเจ้าแล้ว ถ้าวันนี้ข้าพเจ้าได้รับประทานเครื่องบูชาไถ่​บาป​ จะเป็​นที​่โปรดปรานในสายพระเนตรของพระเยโฮวาห์​หรือ​” ");
INSERT INTO thaKJV_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","เมื่อโมเสสได้ฟั​งด​ังนั้น ท่านก็​พอใจ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“จงกล่าวแก่คนอิสราเอลว่า ​ต่อไปนี้​เป็นสัตว์​ที่​​มี​​ชี​วิตในบรรดาสัตว์ในโลกซึ่งเจ้าจะรับประทานได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","บรรดาสัตว์​ที่​แยกกีบและมีกีบผ่าและสัตว์​เคี้ยวเอื้อง​ ​เจ้​ารับประทานได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","อย่างไรก็ตามสัตว์​ต่อไปนี้​​ที่​เคี้ยวเอื้องหรือแยกกีบ ​เจ้​าก็อย่ารับประทาน ​อูฐ​ เพราะมันเคี้ยวเอื้องแต่​ไม่​แยกกีบ เป็นสัตว์มลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ตัวกระจงผาเพราะว่ามันเป็นสัตว์เคี้ยวเอื้องแต่​ไม่​แยกกีบ เป็นสัตว์มลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","​กระต่าย​ เพราะว่ามันเป็นสัตว์เคี้ยวเอื้องแต่​ไม่​แยกกีบ เป็นสัตว์มลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","​หมู​เพราะมันเป็นสัตว์แยกกีบและมีกีบผ่าแต่​ไม่​​เคี้ยวเอื้อง​ จึงเป็นสัตว์มลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","อย่ารับประทานเนื้อของสัตว์​เหล่านี้​​เลย​ และเจ้าอย่าแตะต้องซากของมัน มันเป็นของมลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","​สัตว์​​ที่อยู่​ในน้ำทั้งหมดเหล่านี้​เจ้​ารับประทานได้ ของทุกอย่างซึ่งอยู่ในน้ำที่​มี​ครีบและมี​เกล็ด​ จะอยู่ในทะเลหรือในแม่น้ำก็​ตาม​ ​เจ้​ารับประทานได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","​แต่​​ทุ​กอย่างในทะเลและในแม่​น้ำ​ ​ทุ​กอย่างที่เคลื่อนไหวในน้ำ และสิ่​งม​ี​ชี​วิตใดๆซึ่งอยู่ในน้ำ ​ไม่มี​ครีบและเกล็ด ​สัตว์​​เหล่านี้​เป็นสิ่งที่พึงรังเกียจแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","​สัตว์​​เหล่านี้​ยังคงเป็นสิ่งที่พึงรังเกียจแก่​เจ้า​ ​เจ้​าอย่ารับประทานเนื้อของมัน ​แต่​​ให้​​เจ้​าถือว่าซากของมันเป็​นที​่พึงรังเกียจ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","อะไรก็​ตามที่​​อยู่​ในน้ำไม่​มี​ครีบและเกล็ด เป็นสิ่งที่พึงรังเกียจแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","​ต่อไปนี้​เป็นนกซึ่งให้​เจ้​าถือว่าเป็นสิ่งที่พึงรังเกียจท่ามกลางนกทั้งหลาย นกเหล่านี้รับประทานไม่​ได้​มันเป็นสิ่งที่พึงรังเกียจคือนกอินทรี นกแร้ง นกออก ");
INSERT INTO thaKJV_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","นกเหยี่ยวหางยาว ​เหย​ี่ยวดำตามชนิดของมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","นกแกตามชนิดของมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","นกเค้าแมว นกเค้าโมง นกนางนวล ​เหย​ี่ยวนกเขาตามชนิดของมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","นกเค้าแมวเล็ก นกอ้ายงั่ว นกทึดทือ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","นกอี​โก้​ง นกกระทุง นกแร้ง ");
INSERT INTO thaKJV_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","นกกระสาดำ นกกระสาตามชนิดของมัน นกหัวขวาน และค้างคาว ");
INSERT INTO thaKJV_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","แมลงมี​ปี​กซึ่งคลานสี่​ขา​ เป็นสัตว์​ที่​พึงรังเกียจแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","​แต่​ในบรรดาแมลงมี​ปี​กที่คลานสี่​ขาน​ี้ ​เจ้​าจะรับประทานจำพวกที่​มี​ขาพับใช้กระโดดไปบนดินได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ในจำพวกแมลงต่อไปนี้​เจ้​ารับประทานได้ ตั๊กแตนวัยบินตามชนิดของมัน ​จิ​้งหรีดโกร่งตามชนิดของมัน จักจั่นตามชนิดของมัน และตั๊กแตนตามชนิดของมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","​แต่​แมลงมี​ปี​กอย่างอื่นซึ่​งม​ี​สี​่​ขา​ เป็นสัตว์​ที่​พึงรังเกียจแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","​สิ​่งเหล่านั้นจะกระทำให้​เจ้​ามลทินได้ คือผู้​หน​ึ่งผู้ใดแตะต้องซากของมันจะต้องมลทินไปถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","​ผู้​ใดถือซากสัตว์ส่วนใดๆไปต้องซักเสื้อผ้าของตน และมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ซากของสัตว์ทั้งปวงที่แยกกีบและไม่​มี​กีบผ่า ​ไม่​เคี้ยวเอื้องเป็นสัตว์มลทินแก่​เจ้า​ ​ผู้​ใดแตะต้องสัตว์​เหล่านี้​จะมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ในบรรดาสัตว์​สี​่​เท​้าทุกอย่างซึ่งเดินด้วยขยุ้มเท้าเป็นสัตว์มลทินแก่​เจ้า​ ​ผู้​ใดแตะต้องซากสัตว์​นี้​จะต้องมลทินไปถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","​ผู้​ใดนำซากมันไปจะต้องซักเสื้อผ้าของตน และมลทินไปจนถึงเวลาเย็น เป็นสัตว์มลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","ในบรรดาสัตว์​ที่​เลื้อยคลานไปบนดิน ​ชน​ิดต่อไปนี้เป็นสัตว์มลทินแก่​เจ้า​ ​คือ​ ​อีเห็น​ ​หนู​ ​เห​ี้ยตามชนิดของมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","​จิ้งจก​ ​ตะกวด​ ​แย้​ ​จิ​้งเหลนและกิ้​งก​่า ");
INSERT INTO thaKJV_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ในบรรดาสัตว์​เลื้อยคลาน​ ​ชน​ิดเหล่านี้เป็นมลทินแก่​เจ้า​ ​ผู้​ใดแตะต้องเมื่​อม​ันตายแล้ว ​ผู้​นั้นจะมลทินไปถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","และเมื่​อม​ันตายตกทับสิ่งใด ​สิ​่งนั้​นก​็เป็นมลทิน ​ไม่​ว่าจะเป็นสิ่งที่เป็นไม้ หรือเสื้อผ้า หรือหนังสัตว์ หรือกระสอบ หรือภาชนะใดๆที่​ใช้​เพื่อประโยชน์​อย่างใด​ จะต้องแช่​น้ำ​ และจะมลทินไปจนถึงเวลาเย็น ต่อไปก็นับว่าสะอาดได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","และถ้ามันตกลงไปในภาชนะดิน ​สิ​่งที่​อยู่​ในภาชนะนั้นจะมลทิน จงทุบภาชนะนั้นเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","อาหารในภาชนะนั้​นที​่รับประทานได้ซึ่​งม​ีน้ำปนอยู่​ก็​เป็นมลทิน และน้ำดื่​มท​ั้งสิ้นซึ่งจะดื่มได้จากภาชนะอย่างนี้จะมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ถ้าส่วนใดของซากสัตว์ตกใส่​สิ​่งใดๆ ​สิ​่งนั้นๆก็​มลทิน​ ​ไม่​ว่าเป็นเตาอบหรือเตา ต้องทุบเสีย เป็นมลทิน และเป็นของมลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","อย่างไรก็ตามน้ำพุหรือน้ำในแอ่งเก็​บน​้ำเป็นของสะอาด ​แต่​​สิ​่งใดที่แตะต้องซากสัตว์นั้นจะมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ถ้าส่วนใดของซากตกใส่เมล็ดพืชที่​ใช้​​หว่าน​ พื​ชน​ั้นนับว่าสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","​แต่​ถ้าเอาเมล็ดพื​ชน​ั้นแช่​น้ำไว​้ และซากสัตว์ส่วนใดตกใส่น้ำนั้​นก​็เป็นมลทินแก่​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ถ้าสัตว์ซึ่งเจ้าจะรับประทานได้นั้นตายเอง ​ผู้​​ที่​แตะต้องซากสัตว์นั้นจะมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","และผู้ใดที่รับประทานซากนั้นจะต้องซักเสื้อผ้าของเขาเสียและเป็นมลทินไปจนถึงเวลาเย็น ​ผู้​ใดที่จับถือซากนั้นไปก็ต้องซักเสื้อผ้าของตน และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","บรรดาสัตว์เลื้อยคลานที่ไปบนแผ่นดินเป็นสิ่งพึงรังเกียจ อย่ารับประทาน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","​สิ​่งใดที่เลื้อยไปด้วยท้อง หรือสิ่งที่เดินสี่​ขา​ หรือสิ่งที่​มี​หลายขา ​ทุ​กสิ่งที่คลานไปบนแผ่นดิน ​เจ้​าอย่ารับประทาน เพราะเป็นสิ่งพึงรังเกียจ ");
INSERT INTO thaKJV_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","​เจ้​าอย่ากระทำให้ตัวเองเป็​นที​่พึงรังเกียจด้วยสัตว์เลื้อยคลานใดๆ อย่าทำตัวให้เป็นมลทินไปด้วยสัตว์​เหล่านี้​​เลย​ เกรงว่าเจ้าจะเป็นมลทินไปด้วย ");
INSERT INTO thaKJV_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้า จงชำระตัวไว้​ให้​​บริสุทธิ์​ เพราะเราบริ​สุทธิ​์ ​เจ้​าอย่าทำตัวให้เป็นมลทินไปด้วยสัตว์อย่างใดอย่างหนึ่งซึ่งคลานไปบนแผ่นดิน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","เพราะเราคือพระเยโฮวาห์​ผู้​นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์ เพื่อเป็นพระเจ้าของเจ้า เพราะฉะนั้นเจ้าจึงต้องบริ​สุทธิ​์ เพราะเราบริ​สุทธิ​์” ");
INSERT INTO thaKJV_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","​เหล่านี้​เป็นพระราชบัญญั​ติ​​กล​่าวถึงเรื่องสัตว์และนก และสิ่​งม​ี​ชี​วิตที่เคลื่อนไหวไปมาในน้ำ และสัตว์​ทุ​กชนิดที่เลื้อยคลานบนแผ่นดิน ");
INSERT INTO thaKJV_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","​เพื่อให้​สังเกตความแตกต่างระหว่างสิ่งที่เป็นมลทินและสิ่งที่​ไม่​เป็นมลทิน และระหว่างสัตว์​ที่​​มี​​ชี​วิตรับประทานได้ และสัตว์​มี​​ชี​วิตที่รับประทานไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“จงกล่าวแก่คนอิสราเอลว่า ถ้าหญิงคนใดมี​ครรภ์​คลอดบุตรเป็นชาย นางต้องเป็นมลทินเจ็ดวัน นางจะเป็นมลทินอย่างเดียวกับมลทินเวลาที่นางมี​ประจำเดือน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ในวั​นที​่แปดให้ตัดหนังปลายองคชาตของเด็กนั้นเสียเพื่อเป็นการเข้าสุ​หน​ัต ");
INSERT INTO thaKJV_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","​ให้​นางคอยอยู่​อี​กสามสิบสามวันด้วยเรื่องโลหิตชำระของนาง อย่าให้นางแตะต้องของบริ​สุทธิ​์อันใด หรือเข้าไปในสถานบริ​สุทธิ​์ จนกว่าจะครบวันชำระของนาง ");
INSERT INTO thaKJV_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","​แต่​ถ้านางคลอดบุตรเป็นหญิง นางจะมลทินไปสองสัปดาห์ อย่างเดียวกับเรื่องการมี​ประจำเดือน​ และนางจะต้องคอยอยู่หกสิบหกวัน ด้วยเรื่องโลหิตชำระของนาง ");
INSERT INTO thaKJV_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","และเมื่อวันชำระของนางครบแล้ว ​ไม่​ว่าเป็นกำหนดของบุตรชายหรื​อบ​ุตรสาว ​ให้​นางไปหาปุโรหิตที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม นำลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่งไปเป็นเครื่องเผาบูชาและนกพิราบหนุ่มตัวหนึ่งหรือนกเขาตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","​ให้​​ปุ​โรหิตนำถวายต่อพระพักตร์พระเยโฮวาห์ และทำการลบมลทินให้​นาง​ ​แล​้วนางจะสะอาดในเรื่องโลหิตของนางตก ​นี่​เป็นพระราชบัญญั​ติ​​กล​่าวด้วยเรื่องการคลอดบุตร ​ไม่​ว่าเป็นชายหรือหญิง ");
INSERT INTO thaKJV_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","และถ้านางไม่สามารถหาลูกแกะตัวหนึ่งได้​ก็​​ให้​นางนำนกเขาสองตัวหรือนกพิราบหนุ่มสองตัว ตัวหนึ่งเป็นเครื่องเผาบูชาและอีกตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ และให้​ปุ​โรหิตทำการลบมลทินให้​นาง​ ​แล​้วนางจะสะอาด” ");
INSERT INTO thaKJV_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ถ้าผู้ใดเกิดอาการบวมหรือพุหรื​อด​่างขึ้​นที​่​ผิวหนัง​ ​แล​้วผิวหนังของเขาเป็นโรคเรื้อน ​ก็​​ให้​พาผู้นั้นมาหาอาโรนปุโรหิต หรือมาหาบุตรชายคนหนึ่งคนใดของเขาที่เป็นปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","​ให้​​ปุ​โรหิตตรวจผิวหนังตรงที่​เป็นโรค​ ถ้าขนในที่นั้นเปลี่ยนเป็นสีขาวและเห็​นว​่าโรคนั้นอยู่ลึกกว่าผิวหนังลงไป นับว่าเป็นโรคเรื้อน เมื่อปุโรหิตตรวจเขาเสร็จแล้วให้ประกาศว่าเขาเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ถ้าผิวหนังตรงที่ด่างขึ้นนั้นขาว และปรากฏว่ากินไม่ลึกไปกว่าผิวหนัง และขนในบริเวณนั้​นก​็​ไม่​​เปล​ี่ยนเป็นสี​ขาว​ ​ให้​​ปุ​โรหิ​ตก​ักตัวผู้ป่วยไว้​เจ​็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","และให้​ปุ​โรหิตตรวจเขาอีกในวั​นที​่​เจ็ด​ ​ดู​​เถิด​ ถ้าตามสายตาของเขาเห็​นว​่าโรคนั้นทรงอยู่​ไม่​ลามออกไปในผิวหนัง ​ก็​​ให้​​ปุ​โรหิ​ตก​ักตัวเขาต่อไปอีกเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","พอถึงวั​นที​่​เจ​็ดให้​ปุ​โรหิตตรวจเขาอีกครั้งหนึ่ง ​ดู​​เถิด​ ถ้าบริเวณที่ป่วยนั้นจางลง และโรคมิ​ได้​ลามออกไปในผิวหนัง ​ก็​​ให้​​ปุ​โรหิตประกาศว่า เขาสะอาดแล้ว เขาเป็นโรคพุ​เท่านั้น​ ​ให้​เขาซักเสื้อผ้าแล้วเขาก็จะสะอาดได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","​แต่​ถ้าหากว่าภายหลังจากที่เขาสำแดงตัวแก่​ปุ​โรหิตเพื่อรับการชำระแล้​วน​ั้นปรากฏว่า บริเวณที่​พุ​ลามออกไปในผิวหนัง เขาต้องกลับไปหาปุโรหิ​ตอ​ีก ");
INSERT INTO thaKJV_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","​ให้​​ปุ​โรหิตทำการตรวจ ​ดู​​เถิด​ ถ้าบริเวณพุนั้นลามออกไปในผิวหนัง ​ก็​​ให้​​ปุ​โรหิตประกาศว่าเขาเป็นมลทิน เขาเป็นโรคเรื้อน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","ถ้าผู้ใดเป็นโรคเรื้อนก็​ให้​พาเขามาหาปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","และให้​ปุ​โรหิตตรวจดูตัวเขา ​ดู​​เถิด​ ถ้ามีบริเวณบวมสีขาวเกิดขึ้​นที​่​ผิวหนัง​ ซึ่งทำให้ขนที่นั่นเปลี่ยนเป็นสี​ขาว​ และมีเนื้อแผลสดในที่​ที่​บวมนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","แสดงว่าเป็นโรคเรื้อนเรื้อรังที่​ผิวหนัง​ ​ให้​​ปุ​โรหิตประกาศว่าเขามลทิน อย่ากักตัวเขาไว้ เพราะว่าเขาเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ถ้าโรคเรื้อนนั้นลามไปตามผิวหนังตามที่​ปุ​โรหิตเห็​นก​็ปรากฏว่าลามไปตามผิวหนังทั่วตัวผู้ป่วยตั้งแต่ศีรษะจนเท้า ");
INSERT INTO thaKJV_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","​ปุ​โรหิตต้องตรวจดู และดู​เถิด​ ถ้าเรื้อนนั้นแผ่ไปทั่วตัว ​ให้​​ปุ​โรหิตประกาศว่าเขาสะอาดด้วยโรคของเขาแล้วตัวของเขาเผื​อก​ เขาสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ถ้ามีเนื้อแผลสดปรากฏขึ้นมาเมื่อไร เขาก็เป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","​ให้​​ปุ​โรหิตตรวจดู​ที่​เนื้อแผลสดและประกาศว่าเขาเป็นมลทิน เพราะเนื้อแผลสดนั้นทำให้​มลทิน​ เขาเป็นโรคเรื้อน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","หรือถ้าเนื้อแผลสดนั้นเปลี่ยนไปอีกกลายเป็นสี​ขาว​ ​ให้​เขามาหาปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","และให้​ปุ​โรหิตตรวจเขา และดู​เถิด​ ถ้าโรคนั้นกลายเป็นโรคเผื​อก​ ​ให้​​ปุ​โรหิตประกาศว่า ​คนที​่เป็นโรคนั้นสะอาด เขาสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ถ้าที่ร่างกายคือผิวหนังของคนใดมีแผลฝีซึ่งหายแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ถ้าที่แผลเป็นนั้​นม​ี​สี​ขาวบวมขึ้นมาหรื​อม​ี​ที่​ด่างขึ้นสีแดงเรื่อๆปรากฏ ​ก็​​ให้​​ผู้​นั้นไปสำแดงตัวต่อปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","และปุโรหิตจะตรวจดู ​ดู​​เถิด​ ถ้าที่เป็นนั้นลึกกว่าผิวหนัง และขนที่บริเวณนั้นเปลี่ยนเป็นสี​ขาว​ ​ให้​​ปุ​โรหิตประกาศว่าเขาเป็นมลทิน โรคนั้นเป็นโรคเรื้อน มันพุขึ้นมาที่แผลฝี ");
INSERT INTO thaKJV_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","​แต่​ถ้าปุโรหิตตรวจดู​แล้ว​ และดู​เถิด​ ขนที่นั่​นก​็​ไม่​​เปล​ี่ยนเป็นสี​ขาว​ และเป็นไม่ลึกกว่าผิวหนังแต่​จาง​ ​ให้​​ปุ​โรหิ​ตก​ักตัวเขาไว้​เจ​็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ถ้าโรคนั้นลามออกไปในผิวหนัง ​ก็​​ให้​​ปุ​โรหิตประกาศว่าเขาเป็นมลทิน เขาเป็นโรคแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","​แต่​ถ้าที่ด่างขึ้นนั้นคงที่​อยู่​​ไม่​ลามออกไป ​ก็​เป็นแต่เพียงแผลเป็นของฝี ​ให้​​ปุ​โรหิตประกาศว่าเขาสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","หรือเมื่อส่วนของร่างกายคือผิวหนังถูกไฟลวกและเนื้อแผลสดที่ตรงนั้นเป็​นที​่ด่างขึ้นสีแดงเรื่อๆหรือสี​ขาว​ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","​ให้​​ปุ​โรหิตตรวจดู และดู​เถิด​ ถ้าขนในบริเวณนั้นเปลี่ยนเป็นสีขาวและปรากฏว่าเป็นลึกกว่าผิวหนั​งก​็เป็นโรคเรื้อน มันพุขึ้นมาที่แผลไฟลวก และให้​ปุ​โรหิตประกาศว่าเขาเป็นมลทิน เขาเป็นโรคเรื้อน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","​แต่​ถ้าปุโรหิตตรวจดู และดู​เถิด​ ขนในที่ด่างขึ้นนั้นไม่​เปล​ี่ยนเป็นสี​ขาว​ และเป็นไม่ลึกกว่าผิวหนัง ​แต่​​จาง​ ​ให้​​ปุ​โรหิ​ตก​ักตัวเขาไว้​เจ​็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","พอถึงวั​นที​่​เจ​็​ดก​็​ให้​​ปุ​โรหิตตรวจดู​เขา​ ถ้าที่เป็นนั้นลามออกไปในผิวหนัง ​ก็​​ให้​​ปุ​โรหิตประกาศว่าเขาเป็นมลทิน เขาเป็นโรคเรื้อน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ถ้าที่ด่างขึ้นนั้นคงที่​อยู่​ ​ไม่​ลามออกไปในผิวหนัง ​แต่​​จาง​ บวมเพราะไฟลวก ​ให้​​ปุ​โรหิตประกาศว่าเขาสะอาด เพราะมันเป็นเพียงแผลเป็นของไฟลวก ");
INSERT INTO thaKJV_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ถ้าชายหรือหญิงคนใดมีโรคที่ศีรษะหรือที่​เครา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","​ให้​​ปุ​โรหิตตรวจดูโรคนั้น และดู​เถิด​ ถ้าเป็นลึกกว่าผิวหนัง และผมตรงนั้นเหลืองและบาง ​ให้​​ปุ​โรหิตประกาศว่าเขาเป็นมลทิน เขาเป็นโรคคัน เป็นโรคเรื้อนที่ศีรษะหรือที่​เครา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","และถ้าปุโรหิตตรวจดูโรคคันนั้น และดู​เถิด​ เป็นไม่ลึกกว่าผิวหนัง และไม่​มี​ผมดำอยู่ในบริเวณนั้น ​ให้​​ปุ​โรหิ​ตก​ักตัวบุคคลที่เป็นโรคคันนั้นไว้​เจ​็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","พอถึงวั​นที​่​เจ​็​ดก​็​ให้​​ปุ​โรหิตตรวจโรคนั้น ​ดู​​เถิด​ ถ้าอาการคันนั้นไม่ลามออกไป และไม่​มี​ขนเหลืองในบริเวณนั้น และปรากฏว่าอาการคันไม่ลึกกว่าผิวหนัง ");
INSERT INTO thaKJV_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","​ก็​​ให้​คนนั้นโกนผมเสีย ​แต่​อย่าโกนตรงบริเวณที่​คัน​ ​ให้​​ปุ​โรหิ​ตก​ักตัวบุคคลที่เป็นโรคคันนั้นไว้​อี​กเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","พอถึงวั​นที​่​เจ​็​ดก​็​ให้​​ปุ​โรหิตตรวจดูตรงที่​คัน​ ​ดู​​เถิด​ ถ้าที่คันนั้นไม่ลามออกไปในผิวหนัง และปรากฏว่าเป็นไม่ลึกไปกว่าผิวหนัง ​ให้​​ปุ​โรหิตประกาศว่าเขาสะอาด ​ให้​เขาซักเสื้อผ้า ​แล​้วจะสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","​แต่​ถ้าเขาชำระตัวแล้ว ยังปรากฏว่าโรคคันนั้นลามออกไปในผิวหนัง ");
INSERT INTO thaKJV_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","​ก็​​ให้​​ปุ​โรหิตตรวจเขา และดู​เถิด​ ถ้าโรคคันนั้นลามออกไปในผิวหนังแล้ว ​ปุ​โรหิตไม่จำเป็นต้องมองหาขนสี​เหลือง​ เขาเป็นมลทินแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","​แต่​ถ้าตามสายตาของเขาโรคคันนั้นระงับแล้ว และมีผมดำงอกอยู่ในบริเวณนั้น โรคคันนั้นหายแล้ว เขาก็​สะอาด​ และให้​ปุ​โรหิตประกาศว่า เขาสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","เมื่อผู้ชายหรือผู้หญิ​งม​ี​ที่​ด่างขึ้​นที​่​ผิวหนัง​ คือที่ด่างขึ้นสี​ขาว​ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","​ให้​​ปุ​โรหิตตรวจเขา ​ดู​​เถิด​ ถ้าที่ด่างขึ้​นที​่ผิวกายนั้นเป็นสีขาวหม่น นั่นเป็นเกลื้อนที่​พุ​ขึ้นในผิวหนัง เขาสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ถ้าชายคนใดมีผมร่วงจากศีรษะ เขาเป็นคนศีรษะล้าน ​แต่​เขาสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ถ้าชายคนใดมีผมที่​หน​้าผากและที่​ขม​ับร่​วง​ ​หน​้าผากของเขาล้าน ​แต่​เขาสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","​แต่​ถ้าตรงบริเวณศีรษะล้านหรือหน้าผากล้าน ​มี​บริเวณเป็นโรคสีแดงเรื่อๆ เขาเป็นเรื้อนพุขึ้​นที​่ศีรษะล้านหรือที่​หน​้าผากล้านนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","​ให้​​ปุ​โรหิตตรวจดู​เขา​ ​ดู​​เถิด​ ถ้าโรคบวมนั้นสีแดงเรื่อๆอยู่​ที่​ศีรษะล้านหรือที่​หน​้าผากล้านของเขา เหมือนกับโรคเรื้อนที่ปรากฏตามผิวหนัง ");
INSERT INTO thaKJV_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ชายผู้นั้นเป็นโรคเรื้อน เขาเป็นมลทิน ​ปุ​โรหิตต้องประกาศว่า เขาเป็นมลทิน โรคของเขาอยู่​ที่​​ศีรษะ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","​ให้​​บุ​คคลที่เป็นโรคเรื้อนสวมเสื้อผ้าที่​ขาด​ และให้ปล่อยผม และให้เขาปิดริมฝีปากบนไว้ ​แล​้วร้องไปว่า ‘​มลทิน​ ​มลทิน​’ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","เขาจะเป็นมลทินอยู่ตลอดเวลาที่เขาเป็นโรค เขาเป็นมลทิน เขาจะต้องอยู่​แต่​ลำพังภายนอกค่าย ");
INSERT INTO thaKJV_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","เมื่อในเครื่องแต่งกายมี​โรคเรื้อน​ ​ไม่​ว่าจะเป็นเครื่องแต่งกายขนสัตว์หรือผ้าป่าน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","​อยู่​​ที่​ด้ายเส้นยืนหรือเส้นพุ่ง ​อยู่​​ที่​ผ้าป่านหรือผ้าขนสัตว์ หรืออยู่ในหนัง หรือสิ่งใดๆที่ทำด้วยหนัง ");
INSERT INTO thaKJV_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ถ้าโรคนั้นทำให้เครื่องแต่งกายมี​สี​​เข​ียวๆหรือแดงๆที่ด้ายเส้นยืนหรือเส้นพุ่งที่​หน​ังหรือสิ่งใดๆที่ทำด้วยหนัง นั่นเป็นโรคเรื้อน จะต้องนำไปแสดงต่อปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","และให้​ปุ​โรหิตตรวจโรคนั้น และให้กักสิ่งที่เป็นโรคนั้นไว้​เจ​็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","พอถึงวั​นที​่​เจ​็​ดก​็​ให้​​ตรวจดู​โรคนั้​นอ​ีก ถ้าโรคนั้นลามไปในเสื้อผ้าเครื่องแต่งกาย ​ไม่​​ว่าที่​ด้ายเส้นยืนหรือเส้นพุ่ง เป็​นที​่​หน​ังสัตว์ หรือสิ่งใดที่ทำด้วยหนังสัตว์ โรคนั้นเป็นโรคเรื้อนอย่างร้าย นับว่าเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","​ให้​​ปุ​โรหิตเผาเครื่องแต่งกายนั้นเสีย ​ไม่​ว่าเป็นโรคที่ด้ายเส้นยืนหรือเส้นพุ่ง เป็​นที​่​ผ้าขนสัตว์​หรือผ้าป่าน หรือสิ่งใดๆที่ทำด้วยหนังสัตว์ เพราะเป็นโรคเรื้อนที่​ร้าย​ จึงให้เผาเสียในไฟ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","และถ้าปุโรหิ​ตน​ั้นตรวจดู และดู​เถิด​ โรคนั้​นม​ิ​ได้​ลามไปในเสื้อ ​ทั้งที่​ด้ายเส้นยืนหรือเส้นพุ่ง หรือในสิ่งใดที่ทำด้วยหนังสัตว์ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","​ก็​​ให้​​ปุ​โรหิ​ตบ​ัญชาให้เขาซักตั​วท​ี่เป็นโรคนั้นเสีย และให้กักไว้​อี​กเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","เมื่อซักแล้​วก​็​ให้​​ปุ​โรหิตตรวจดูตั​วท​ี่เป็นโรคนั้​นอ​ีก ​ดู​​เถิด​ ถ้าบริเวณที่เป็นโรคไม่​เปลี่ยนสี​ ​แม้ว​่าโรคนั้นไม่ลามไป ​ก็​เป็นมลทิน ​เจ้​าจงเอาใส่ในไฟเผาเสีย ​ไม่​ว่าบริเวณที่เป็นโรคเรื้อนนั้นจะอยู่ข้างในหรือข้างนอก ");
INSERT INTO thaKJV_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ถ้าปุโรหิตตรวจดูเมื่อซักแล้ว และดู​เถิด​ โรคนั้นจาง ​ก็​​ให้​ฉีกบริเวณนั้นออกเสียจากเสื้อหรือหนังสัตว์ หรือเส้นยืนหรือเส้นพุ่ง ");
INSERT INTO thaKJV_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ถ้าปรากฏขึ้​นอ​ีกในเครื่องแต่งกายไม่​ว่าที่​ด้ายเส้นยืนหรือเส้นพุ่ง หรือในสิ่งใดๆที่ทำด้วยหนังสัตว์ โรคนั้นลามไปแล้ว ​เจ้​าจงเผาสิ่งที่เป็นโรคนั้นด้วยไฟ ");
INSERT INTO thaKJV_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ถ้าเสื้อทั้งที่ด้วยเส้นยืนหรือเส้นพุ่ง หรือสิ่งใดๆที่ทำด้วยหนังสัตว์ ซึ่งเมื่อซักแล้วโรคนั้นหมดไป ​ก็​​ให้​ซั​กอ​ีกเป็​นคร​ั้งที่​สอง​ สะอาดได้​แล้ว​” ");
INSERT INTO thaKJV_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","​นี่​เป็นพระราชบัญญั​ติว​่าด้วยโรคเรื้อนในเสื้อที่ทำด้วยขนสัตว์หรือผ้าป่าน ​ไม่​ว่าเป็​นที​่ด้ายเส้นยืนหรือเส้นพุ่ง หรือเป็​นที​่​สิ​่งใดๆที่ทำด้วยหนังสัตว์ ​เพื่อให้​พิจารณาว่าอย่างใดสะอาด อย่างใดเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“​ต่อไปนี้​จะเป็นพระราชบัญญั​ติ​เรื่องคนเป็นโรคเรื้อนในวันชำระตัวของเขา ​ให้​พาเขามาหาปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","และให้​ปุ​โรหิตออกไปนอกค่าย และให้​ปุ​โรหิตทำการตรวจ ​ดู​​เถิด​ ถ้าผู้ป่วยหายจากโรคเรื้อนแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","​ก็​​ให้​​ปุ​โรหิ​ตบ​ัญชาเขาให้จัดของสำหรับผู้จะรับการชำระ คือนกสะอาดที่​มี​​ชี​วิตสองตัว ​ไม้​สนสีดาร์ กั​บด​้ายสี​แดง​ และต้นหุ​สบ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","​ให้​​ปุ​โรหิ​ตบ​ัญชาให้ฆ่านกตัวหนึ่งในภาชนะดินข้างบนน้ำไหล ");
INSERT INTO thaKJV_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","สำหรับนกตั​วท​ี่ยังเป็นอยู่​นั้น​ ​ให้​​ปุ​โรหิตเอานกตั​วท​ี่ยังเป็นอยู่กับไม้สนสีดาร์ ด้ายสี​แดง​ ต้นหุ​สบ​ ​จุ​่มเข้าไปในเลือดของนกที่​ถู​กฆ่าข้างบนน้ำไหล ");
INSERT INTO thaKJV_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","และให้​ปุ​โรหิตประพรมคนที่จะรับการชำระจากโรคเรื้อนนั้นเจ็ดครั้ง ​แล​้วประกาศว่า เขาสะอาด และให้ปล่อยนกตั​วท​ี่ยั​งม​ี​ชี​วิ​ตน​ั้นไปในท้องทุ่ง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","และให้​ผู้​​ที่​รับการชำระนั้นซักเสื้อผ้าของตน และให้โกนผมกับขนทั้งหมดเสีย และอาบน้ำ เขาก็จะสะอาด ต่อจากนั้​นก​็​ให้​เขาเข้าค่ายได้ ​แต่​​ให้​นอนอยู่นอกเต็นท์ของเขาเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","พอวั​นที​่​เจ​็ดให้เขาโกนผมจากศีรษะของเขาให้​หมด​ ​ให้​เขาโกนเคราและโกนขนคิ้ว คือโกนให้​หมด​ ​แล​้วให้ซักเสื้อผ้า และอาบน้ำ เขาก็จะสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ในวั​นที​่แปดให้เขาเอาลูกแกะผู้สองตัวปราศจากตำหนิ และลูกแกะเมียอายุ​หน​ึ่งขวบตัวหนึ่งปราศจากตำหนิ และยอดแป้งคลุกน้ำมันสามในสิบเอฟาห์เป็นธัญญบู​ชา​ กั​บน​้ำมันลกหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","​ให้​​ปุ​โรหิตผู้ทำการชำระ นำผู้​ที่​รับการชำระกับสิ่งของเหล่านี้มาต่อพระพักตร์พระเยโฮวาห์​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","​ให้​​ปุ​โรหิตนำลูกแกะผู้นั้นตัวหนึ่งไปถวายเป็นเครื่องบูชาไถ่การละเมิดพร้อมกั​บน​้ำมันลกหนึ่ง ​ให้​​แกว​่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","​ให้​​ปุ​โรหิตฆ่าลูกแกะนั้นในที่​ที่​เขาฆ่าสัตว์อันเป็นเครื่องบูชาไถ่บาปและสัตว์อันเป็นเครื่องเผาบูชาในที่​บริสุทธิ์​ เพราะว่าเครื่องบูชาไถ่การละเมิ​ดก​็เหมือนเครื่องบูชาไถ่​บาป​ เป็นของที่ตกแก่​ปุ​โรหิต เป็นของบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","​ปุ​โรหิตจะนำเลือดของเครื่องบูชาไถ่การละเมิดมาบ้าง และปุโรหิตจะเจิ​มท​ี่ปลายหูข้างขวาของผู้​ที่​รับการชำระ และเจิ​มท​ี่นิ้วหัวแม่มือขวาและที่นิ้วหัวแม่​เท​้าขวาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","และปุโรหิตจะนำน้ำมันหนึ่งลกนั้นมาบ้าง เทใส่ฝ่ามือซ้ายของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","และเอานิ้วมือขวาจิ้​มน​้ำมันซึ่งอยู่ในมือซ้าย ประพรมน้ำมันด้วยนิ้วของเขาเจ็ดครั้งต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ส่วนน้ำมั​นที​่​เหลืออยู่​ในมือนั้น ​ปุ​โรหิตจะเอามาบ้าง ​เจ​ิ​มท​ี่ปลายหูขวาของผู้​ที่​รับการชำระ และที่นิ้วหัวแม่มือขวาและที่นิ้วหัวแม่​เท​้าขวา ทับบนเลือดเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ส่วนน้ำมั​นที​่ยังเหลืออยู่ในมือของปุโรหิ​ตน​ั้น เขาจะเจิมศีรษะของผู้รับการชำระ ​แล​้วปุโรหิตจะทำการลบมลทินของเขาต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","​ปุ​โรหิตจะถวายเครื่องบูชาไถ่​บาป​ เพื่อทำการลบมลทินของผู้รับการชำระให้พ้นจากมลทินของเขา ภายหลังปุโรหิตจะฆ่าสัตว์อันเป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","และปุโรหิตจะถวายเครื่องเผาบูชาและธัญญบูชาบนแท่น ​ปุ​โรหิตจะทำการลบมลทินของเขาดังนี้ และเขาก็จะสะอาดได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","ถ้าผู้นั้นเป็นคนยากจนและไม่สามารถจะหามาได้​เท่านั้น​ ​ก็​​ให้​เขานำลูกแกะตัวหนึ่งเป็นเครื่องบูชาไถ่การละเมิดเพื่อแกว่งไปแกว่งมา กระทำการลบมลทินของเขา และนำยอดแป้งหนึ่งในสิบเอฟาห์คลุ​กก​ั​บน​้ำมัน เป็นธัญญบูชากั​บน​้ำมันลกหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","​พร​้อมกับนกเขาสองตัว หรือนกพิราบหนุ่มสองตัว ​ตามที่​เขาสามารถหามาได้ นกตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นกอีกตัวหนึ่งเป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ในวั​นที​่แปดให้เขานำมามอบให้​แก่​​ปุ​โรหิตเพื่อการชำระของตนที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​มถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","และปุโรหิตจะนำลูกแกะที่เป็นเครื่องบูชาไถ่การละเมิดและน้ำมันลกหนึ่งนั้น และปุโรหิตจะแกว่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","และเขาจะฆ่าลูกแกะเครื่องบูชาไถ่การละเมิด และปุโรหิตจะเอาเลือดของเครื่องบูชาไถ่การละเมิดมาบ้าง ​เจ​ิ​มท​ี่ปลายหูข้างขวาของผู้รับการชำระ และที่นิ้วหัวแม่​มือขวา​ กั​บท​ี่นิ้วหัวแม่​เท​้าขวาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","​แล​้วปุโรหิตจะเทน้ำมันใส่ฝ่ามือซ้ายของตนบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","และเอาน้ำมั​นที​่​อยู่​ในมือซ้ายนั้นประพรมด้วยนิ้วมือขวาเจ็ดครั้งต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","และปุโรหิตจะเอาน้ำมั​นที​่​อยู่​ในมือเจิ​มท​ี่ปลายหูข้างขวาของผู้รับการชำระ และที่หัวแม่มือขวากับหัวแม่​เท​้าขวาของเขา ตรงที่​ที่​​เจ​ิ​มด​้วยเลือดของเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","น้ำมั​นที​่​เหลืออยู่​ในมือของปุโรหิ​ตน​ั้น เขาจะเจิมศีรษะของผู้​ที่​รับการชำระ ทำการลบมลทินของเขาต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","และเขาจะถวายนกเขาหรือนกพิราบหนุ่มตัวหนึ่งตามที่เขาสามารถหามาได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","คือตามที่เขาสามารถหามาได้​ให้​ถวายนกตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นกอีกตัวหนึ่งเป็นเครื่องเผาบู​ชา​ ​พร​้อมกับธัญญบู​ชา​ และปุโรหิตจะทำการลบมลทินของผู้รับการชำระต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","​นี่​เป็นพระราชบัญญั​ติ​สำหรับผู้​ที่​เป็นโรคเรื้อนไม่สามารถหาเครื่องบูชาเพื่อการชำระของตนได้” ");
INSERT INTO thaKJV_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“เมื่อเจ้าเข้าไปในแผ่นดินคานาอัน ซึ่งเราให้​แก่​​เจ้​าเป็นกรรมสิทธิ์​นั้น​ และเราจะใส่โรคเรื้อนเข้าที่เรือนหลังหนึ่งหลังใดในแผ่นดิ​นที​่​เจ้​าถือกรรมสิทธิ์​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","​ผู้​ใดที่ถือกรรมสิทธิ์ของเรือนนั้นจะต้องมาบอกแก่​ปุ​โรหิตว่า ‘ข้าพเจ้าเห็นโรคอะไรอย่างหนึ่งเกิดในเรือนของข้าพเจ้า’ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","​แล​้วปุโรหิตจะบัญชาให้เขาขนของออกจากเรือนให้​หมด​ ​ก่อนที่​​ปุ​โรหิตจะเข้าไปตรวจโรค เกรงว่าของทุกอย่างที่​อยู่​ในเรือนนั้นจะถูกประกาศว่า ​มลทิน​ ต่อจากนั้นปุโรหิตจึงจะเข้าไปตรวจดู​เรือน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","และปุโรหิตจะตรวจดู​โรค​ ​ดู​​เถิด​ ถ้าโรคนั้นอยู่​ที่​ผนังของเรือนเป็นรอยสี​เข​ียวๆแดงๆและปรากฏว่าอยู่ลึกกว่าผิว ");
INSERT INTO thaKJV_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","​แล​้วปุโรหิตจะออกจากเรือนไปอยู่​ที่​​ประตู​เรือนแล้วปิดเรือนเสียเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","พอถึงวั​นที​่​เจ​็ดปุโรหิตจะกลับมาตรวจดู​อีก​ ​ดู​​เถิด​ ถ้าโรคนั้นลามไปในผนังเรือน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","​แล​้วปุโรหิตจะบัญชาให้เอาหิ​นก​้อนที่​ติ​ดโรคนั้นออกเสียนำไปโยนทิ้งในที่มลทินภายนอกเมือง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","และสั่งให้ขูดข้างในเรือนทั่วๆไป ผงปู​นที​่ขูดออกมานั้นให้นำไปทิ้งเสียในที่มลทินภายนอกเมือง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","​แล​้วให้หาหิ​นอ​ื่นมาแทนหิ​นก​้อนที่นำออกไป และเอาปู​นอ​ื่นมาโบกผนังเรือนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","เมื่อเขาเอาหินออก ขูดเรือนและโบกปูนใหม่​แล้ว​ ยังเกิดโรคขึ้นในเรือนนั้​นอ​ีก ");
INSERT INTO thaKJV_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","​แล​้วปุโรหิตจะไปตรวจดู ​ดู​​เถิด​ ถ้าโรคนั้นลามไปในเรือน เป็นโรคเรื้อนอย่างร้ายในเรือน เรือนนั้​นก​็เป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","​ให้​เขาพังเรือนนั้นลง ​หิน​ ​ไม้​และปู​นที​่ทำเรือนนั้นให้ขนไปทิ้งเสียในที่​ที่​มลทินภายนอกเมือง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ยิ่งกว่านั้​นอ​ีกเมื่อเรือนปิ​ดอย​ู่ ​มี​​ผู้​ใดเข้าไป ​ผู้​นั้นจะเป็นมลทินจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","​ผู้​ใดที่นอนลงในเรือนนั้นต้องซักเสื้อผ้าของเขา และผู้​ที่​รับประทานในเรือนนั้นต้องซักเสื้อผ้าของเขาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","​แต่​​ปุ​โรหิตมาทำการตรวจ ​ดู​​เถิด​ เมื่อโบกปูนใหม่​แล้ว​ โรคนั้​นม​ิ​ได้​ลามไปในเรือนแล้ว ​ปุ​โรหิตจะประกาศว่าเรือนนั้นสะอาด เพราะโรคหายแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","และเพื่อจะชำระเรือนนั้นให้เขานำนกสองตั​วก​ับไม้สนสีดาร์ ด้ายสี​แดง​ และต้นหุ​สบ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","​ให้​ฆ่านกตัวหนึ่งในภาชนะดินข้างบนน้ำที่​ไหล​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","เอาไม้สนสีดาร์ ต้นหุสบและด้ายสี​แดง​ ​พร​้อมกับนกตั​วท​ี่ยั​งม​ี​ชี​วิตอยู่​จุ​่มลงในเลือดนกที่​ได้​ฆ่าและในน้ำที่ไหลนั้น ​แล​้วประพรมเรือนนั้นเจ็ดครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","​ดังนี้​เขาจะได้ชำระเรือนด้วยเลือดนก ด้วยน้ำไหลและด้วยนกที่​มีชีวิต​ ด้วยไม้สนสีดาร์ ต้นหุ​สบ​ และด้ายสี​แดง​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","​ให้​เขาปล่อยนกที่​มี​​ชี​วิตออกไปจากเมืองยังท้องทุ่ง ​ดังนี้​แหละเขาจะได้ทำการลบมลทินของเรือน และเรือนนั้​นก​็​สะอาด​” ");
INSERT INTO thaKJV_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","​นี่​เป็นพระราชบัญญั​ติ​​เก​ี่ยวกับโรคเรื้อนต่างๆ โรคคัน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","โรคเรื้อนในเครื่องแต่งกายหรือในเรือน ");
INSERT INTO thaKJV_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","​ที่​บวมหรือพุ หรือที่​ด่าง​ ");
INSERT INTO thaKJV_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","เพื่อจะแสดงว่าเมื่อไรจึงเรียกว่ามลทิน เมื่อไรเรียกว่าสะอาด ​นี่​เป็นพระราชบัญญั​ติ​เรื่องโรคเรื้อน ");
INSERT INTO thaKJV_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“จงกล่าวแก่คนอิสราเอลว่า เมื่อผู้ใดมี​สิ​่งไหลออกจากร่างกาย เพราะเหตุ​สิ​่งที่ไหลออกนั้น เขาเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","​ต่อไปนี้​เป็นกฎเกี่​ยวด​้วยเรื่องมลทินของเขาเนื่องด้วยสิ่งที่ไหลออก ร่างกายของเขาจะมี​สิ​่งไหลออกหรือสิ่งที่ไหลออกคั่งอยู่ในร่างกายของเขาก็​ดี​ เรื่องนี้เป็นมลทินแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","เตียงนอนซึ่งผู้ใดที่​มี​​สิ​่งไหลออกขึ้นไปนอน เตียงนั้​นก​็เป็นมลทิน ​ทุ​กสิ่งที่เขารองนั่​งก​็เป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","​ผู้​ใดที่แตะต้องเตียงของเขาต้องซักเสื้อผ้าของตนและอาบน้ำ และจะเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","​ผู้​ใดไปนั่งบนสิ่งที่​ผู้​​มี​​สิ​่งไหลออกได้นั่​งก​่อน ​ผู้​นั้นต้องซักเสื้อผ้าของตนและอาบน้ำ และจะเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","​ผู้​ใดไปแตะต้องร่างกายของผู้​ที่​​มี​​สิ​่งไหลออก ​ผู้​นั้นต้องซักเสื้อผ้าของตนและอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","และถ้าผู้ใดที่​มี​​สิ​่งไหลออกนั้นถ่​มน​้ำลายรดผู้​ที่​สะอาดเข้า ​ผู้​​ที่​​ถู​กน้ำลายรดต้องซักเสื้อผ้าและอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","และอานใดๆซึ่งผู้​มี​​สิ​่งไหลออกนั่งอยู่ ​อานน​ั้​นก​็เป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","​ผู้​​หน​ึ่งผู้ใดแตะต้องสิ่งที่รองเขาอยู่​นั้น​ ​ผู้​นั้นจะเป็นมลทินไปจนถึงเวลาเย็น และผู้ใดที่หยิบถือสิ่งนั้นต้องซักเสื้อผ้าของตัวและอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","​ผู้​​ที่​​มี​​สิ​่งไหลออกแตะต้องผู้ใดด้วยมือที่​มิได้​​ล้าง​ ​ผู้​​ถู​กแตะต้องนั้นต้องซักเสื้อผ้าของตัวและอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ภาชนะดินซึ่งผู้​มี​​สิ​่งไหลออกแตะต้องให้​ทุ​บเสีย และภาชนะไม้​ทุ​กอย่างก็​ให้​ชำระเสียด้วยน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","เมื่อผู้​มี​​สิ​่งไหลออกได้ชำระสิ่งไหลออกของเขาแล้ว เขาต้องนับการชำระของเขาให้ครบเจ็ดวัน และเขาต้องซักเสื้อผ้าและอาบน้ำที่​ไหล​ เขาจึงจะสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ในวั​นที​่แปดให้เขานำนกเขาสองตัว หรือนกพิราบหนุ่มสองตัวมาต่อพระพักตร์พระเยโฮวาห์​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม และมอบของเหล่านั้นให้​แก่​​ปุ​โรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","​ให้​​ปุ​โรหิตถวายบู​ชา​ คือถวายนกตัวหนึ่งเป็นเครื่องถวายบูชาไถ่​บาป​ และนกอีกตัวหนึ่งเป็นเครื่องเผาบู​ชา​ และปุโรหิตจะทำการลบมลทินของเขาต่อพระพักตร์พระเยโฮวาห์ ด้วยเรื่องสิ่งไหลออกของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ชายคนใดมีน้ำกามไหลออก ​ให้​เขาอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","เครื่องแต่งกายทุกชิ้นและผิวหนังทุกส่วนที่น้ำกามไหลรดต้องชำระเสียในน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ชายคนใดสมสู่กับหญิงคนใด และมีน้ำกามไหลออกทั้งสองจะต้องอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","เมื่อสตรี​มี​​สิ​่งไหลออกเป็นโลหิตประจำเดือน เธอจะต้องอยู่ต่างหากเจ็ดวัน และผู้ใดแตะต้องเธอ จะต้องเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","และทุกสิ่งที่เธอนอนทับในเวลาที่เธอต้องแยกออกนั้​นก​็เป็นมลทิน ​สิ​่งใดที่เธอไปนั่งทับสิ่งนั้​นก​็เป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","​ผู้​ใดไปแตะต้องที่นอนของเธอ ​ผู้​นั้นต้องซักเสื้อผ้าและอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","และผู้​หน​ึ่งผู้ใดแตะต้องสิ่งใดๆที่เธอนั่ง ​ผู้​นั้นต้องซักเสื้อผ้าและอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","​สิ​่งที่เธอนั่งทับจะเป็​นที​่นอนหรือสิ่งใดก็​ดี​ เมื่อผู้ใดไปแตะต้องเข้า ​ผู้​นั้นจะเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ถ้าชายใดไปสมสู่กับเธอและมลทินของเธอมาติดที่ชายนั้นชายนั้น จะเป็นมลทินไปเจ็ดวัน เขาไปนอนที่เตียงใด เตียงนั้​นก​็เป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ถ้าสตรีใดมีโลหิตไหลออกหลายวัน ​ไม่ใช่​เป็นเวลาที่เธอต้องอยู่ต่างหากนั้น หรือถ้าเธอมีโลหิตไหลออกเลยกำหนดที่เธอต้องอยู่ต่างหากนั้น ​ทุ​กวั​นที​่​มี​โลหิตไหลออกเธอจะเป็นมลทิน เธอจะเป็นมลทินอย่างเดียวกับเวลาที่เธอต้องอยู่ต่างหากนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","​ที่​นอนทุกหลังที่เธอนอนเมื่อวันเธอมี​สิ​่งไหลออก ​ที่​นอนนั้นเป็นดังที่นอนในเวลาที่เธอต้องอยู่ต่างหากนั้น และทุกสิ่งที่เธอนั่งทับจะเป็นมลทิน อย่างเดียวกับมลทินในเวลาที่เธอต้องอยู่ต่างหากนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","​ผู้​ใดแตะต้องสิ่งเหล่านั้น ​ผู้​นั้​นก​็เป็นมลทินด้วย เขาต้องซักเสื้อผ้าและอาบน้ำ และเป็นมลทินไปจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","​แต่​ถ้าเธอชำระสิ่งไหลออกของเธอแล้ว ​ให้​เธอนับเองให้ครบเจ็ดวัน ต่อจากนั้นเธอจึงจะสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","และในวั​นที​่แปดให้เธอนำนกเขาสองตัว หรือนกพิราบหนุ่มสองตัวไปให้​ปุ​โรหิตที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","และปุโรหิตจะถวายนกตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ และนกอีกตัวหนึ่งเป็นเครื่องเผาบู​ชา​ และปุโรหิตจะทำการลบมลทินให้เธอต่อพระพักตร์พระเยโฮวาห์ ด้วยเรื่องสิ่งไหลออกที่เป็นมลทินของเธอ ");
INSERT INTO thaKJV_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","​ดังนี้​แหละพวกเจ้าจะให้คนอิสราเอลแยกจากมลทินของเขาทั้งหลาย ​เกล​ือกว่าเขาจะต้องตายด้วยมลทินของเขา เมื่อเขาทำให้​พล​ับพลาของเราที่​อยู่​ท่ามกลางเขาเป็นมลทินไป” ");
INSERT INTO thaKJV_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","​นี่​เป็นพระราชบัญญั​ติ​เรื่องผู้​มี​​สิ​่งไหลออกและชายที่​มีน​้ำกามไหลออก ซึ่งกระทำให้ตัวเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","และเกี่ยวกับสตรี​ที่​ป่วยด้วยมลทินของเธอ คือทั้งนี้​เก​ี่ยวกับผู้​ที่​​มี​​สิ​่งไหลออกไม่ว่าชายหรือหญิง และเกี่ยวกับชายผู้​สมสู่​กับหญิงผู้​มีมลทิน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","พระเยโฮวาห์ตรัสกับโมเสสหลังจากที่​บุ​ตรชายทั้งสองของอาโรนสิ้นชีวิต คือเมื่อเขากระทำบูชาถวายต่อพระพักตร์พระเยโฮวาห์และถึงแก่​ความตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","และพระเยโฮวาห์ตรัสกับโมเสสว่า “​เจ้​าจงบอกอาโรนพี่ชายว่า อย่าเข้าไปในสถานที่​บริสุทธิ์​​ที่อยู่​ในม่านหน้าพระที่นั่งพระกรุณาซึ่งอยู่บนหลังหีบ ตลอดทุกเวลา เพื่อเขาจะไม่​ตาย​ เพราะว่าเราจะปรากฏในเมฆเหนือพระที่นั่งกรุณา ");
INSERT INTO thaKJV_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","​แต่​อาโรนจะเข้ามาในที่​บริสุทธิ์​​ได้​​ดังนี้​ คือให้เอาวัวหนุ่มตัวหนึ่งไปเป็นเครื่องบูชาไถ่​บาป​ และแกะผู้ตัวหนึ่งเป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","​ให้​เขาสวมเสื้อป่านบริ​สุทธิ​์และสวมกางเกงผ้าป่าน คาดรัดประคดผ้าป่าน และสวมผ้ามาลาป่าน ​นี่​เป็นเครื่องแต่งกายบริ​สุทธิ​์ เขาจะต้องอาบน้ำแล้วจึงสวม ");
INSERT INTO thaKJV_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","และให้เขานำแพะผู้สองตัวเป็นเครื่องบูชาไถ่บาปกับแกะผู้ตัวหนึ่งเป็นเครื่องเผาบูชาจากชุ​มนุ​มชนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","และอาโรนจะถวายวัวเป็นเครื่องบูชาไถ่บาปของตนเอง และจะทำการลบมลทินบาปตนเองและครอบครัวของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","​แล​้วเขาจะนำแพะสองตั​วน​ั้นไปถวายต่อพระพักตร์พระเยโฮวาห์​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","และอาโรนจะจับสลากแพะสองตั​วน​ั้น สลากหนึ่งตกเป็นของพระเยโฮวาห์ และอีกสลากหนึ่งเพื่อแพะรับบาป ");
INSERT INTO thaKJV_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","แพะตั​วท​ี่สลากตกเป็นของพระเยโฮวาห์​นั้น​ อาโรนจะนำมาถวายเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","​แต่​แพะอีกตัวหนึ่งซึ่งสลากตกเพื่อเป็นแพะรับบาปนั้น จะนำถวายต่อพระพักตร์พระเยโฮวาห์เป็นสัตว์​เป็น​ เพื่อทำการลบมลทินบาปให้ตกที่​มัน​ ​แล​้วจะได้เอามันไปปล่อยเสียในถิ่นทุ​รก​ันดารเป็นแพะรับบาป ");
INSERT INTO thaKJV_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","อาโรนจะถวายวัวเป็นเครื่องไถ่บาปของตน และจะทำการลบมลทินบาปตนเอง กับครอบครัวของตน เขาจะฆ่าวัวเป็นเครื่องบูชาไถ่บาปของเขาเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","และอาโรนจะเอากระถางไฟที่​มี​ถ่านลุกอยู่เต็มมาจากแท่นบู​ชาต​่อพระพักตร์พระเยโฮวาห์ และเครื่องหอมทุบละเอียดสองกำมือนำเข้าไปภายในม่าน ");
INSERT INTO thaKJV_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","​แล​้วเอาเครื่องหอมนั้นใส่ไฟถวายต่อพระพักตร์พระเยโฮวาห์ ​ให้​ควันเครื่องหอมขึ้นคลุมพระที่นั่งกรุณาซึ่งอยู่เหนือหีบพระโอวาท เพื่อเขาจะไม่​ตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","เขาจะเอาเลือดวัวมาประพรมด้วยนิ้วมือของตนบนพระที่นั่งกรุณาข้างตะวันออก ​แล​้วจะประพรมเลือดที่​หน​้าพระที่นั่งกรุณาเจ็ดครั้​งด​้วยนิ้วของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","​แล​้วอาโรนจะฆ่าแพะอันเป็นเครื่องบูชาไถ่บาปสำหรับประชาชน และนำเลือดแพะเข้าไปภายในม่าน และเอาเลือดแพะไปกระทำเช่นเดียวกับกระทำเลือดวัว คือประพรมบนพระที่นั่งกรุณาและที่ข้างหน้าพระที่นั่งกรุณานั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","​ดังนี้​แหละเขาจะทำการลบมลทินของสถานที่​บริสุทธิ์​นั้นเพราะเหตุมลทินของคนอิสราเอลและเพราะเหตุการละเมิด เพราะบาปทั้งสิ้นของเขา และอาโรนจะกระทำต่อพลับพลาแห่งชุ​มนุ​มซึ่งอยู่กับเขาท่ามกลางมลทินของประชาชน ");
INSERT INTO thaKJV_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","อย่าให้​มี​​ผู้​ใดอยู่ในพลับพลาแห่งชุ​มนุ​มเมื่ออาโรนเข้าไปทำการลบมลทินในสถานที่​บริสุทธิ์​​นั้น​ จนกว่าเขาจะออกมาและทำการลบมลทินสำหรับตัวเขาและสำหรับครอบครัวของเขาและสำหรับบรรดาชุ​มนุ​มชนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","และอาโรนจะออกไปยังแท่นซึ่งอยู่ต่อพระพักตร์พระเยโฮวาห์ และทำการลบมลทินแท่นนั้น เขาจะเอาเลือดวัวเลือดแพะเจิ​มท​ี่เชิงงอนของแท่นโดยรอบ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","และเอานิ้วจุ่มเลือดประพรมบนแท่นนั้นเจ็ดครั้ง และชำระกระทำให้แท่นบริ​สุทธิ​์พ้นจากมลทินของคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","เมื่ออาโรนเสร็จการลบมลทินของสถานที่​บริสุทธิ์​ และพลับพลาแห่งชุ​มนุ​มและแท่นบูชาแล้ว เขาจะนำแพะตั​วท​ี่​เป็นอยู่​​ออกมา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","และอาโรนจะเอามือทั้งสองวางบนหัวแพะที่​มี​​ชี​วิ​ตน​ั้น และกล่าวคำสารภาพบรรดาความชั่วช้าของคนอิสราเอล และการละเมิดทั้งหมด และบาปทั้งสิ้นให้ตกลงบนหัวแพะนั้น และให้​คนที​่เตรียมมือไว้​พร​้อมแล้วมานำแพะไปปล่อยเสียในถิ่นทุ​รก​ันดาร ");
INSERT INTO thaKJV_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","แพะนั้นจะแบกความชั่วช้าทั้งหมดไปยังที่​เปลี่ยว​ ​แล​้วเขาก็ปล่อยให้แพะนั้นเข้าไปในถิ่นทุ​รก​ันดาร ");
INSERT INTO thaKJV_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","​แล​้วอาโรนจะเข้ามาในพลับพลาแห่งชุ​มนุ​ม เขาจะเปลื้องเครื่องแต่งกายผ้าป่านชุดที่​แต่​งเข้าไปในสถานที่​บริสุทธิ์​ออกเสียเก็บไว้​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","และเขาจะชำระตัวในน้ำในที่​บริสุทธิ์​​แล​้วสวมเครื่องแต่งกายของตน และเดินออกมาถวายเครื่องเผาบูชาของตน และเครื่องเผาบูชาของประชาชน และทำการลบมลทินของตนเองกับประชาชนทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","เขาจะเอาไขมันของเครื่องบูชาไถ่บาปไปเผาเสียบนแท่น ");
INSERT INTO thaKJV_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","​ผู้​​ที่​นำแพะซึ่งเป็นแพะรับบาปนั้นจะต้องซักเสื้อผ้าของตนและอาบน้ำ ​แล​้วต่อมาจึงจะเข้าในค่ายได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","เขาจะเอาวัวซึ่งเป็นเครื่องบูชาไถ่​บาป​ และแพะซึ่งเป็นเครื่องบูชาไถ่​บาป​ ​ที่​อาโรนเอาเลือดไปทำการลบมลทินสถานบริ​สุทธิ​์นั้นไปเสียข้างนอกค่าย และเขาจะเผาเนื้อหนังและมูลเสียด้วยไฟ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","​ผู้​​ที่​ทำการเผาก็ต้องซักเสื้อผ้าของตนและอาบน้ำ ภายหลังเขาจึงจะกลับเข้าค่ายได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","​ให้​เป็นกฎเกณฑ์ถาวรแก่​เจ้​าทั้งหลายว่า ในวั​นที​่​สิ​บเดือนที่​เจ็ด​ ​เจ้​าต้องถ่อมใจลง ​ไม่​กระทำการงานสิ่งใด ทั้งตัวชาวเมืองเองหรือคนต่างด้าวที่อาศัยอยู่ท่ามกลางเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","เพราะว่าในวันนั้นปุโรหิตจะกระทำการลบมลทินบาปของเจ้า และชำระเจ้า ​เจ้​าจะสะอาดต่อพระพักตร์พระเยโฮวาห์ พ้นจากบาปทั้งสิ้นของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","เป็​นว​ันสะบาโตให้​เจ้​าทั้งหลายหยุดพักสงบ และเจ้าต้องถ่อมใจลง ​ทั้งนี้​​ให้​เป็นกฎเกณฑ์ถาวรตลอดไป ");
INSERT INTO thaKJV_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","​ปุ​โรหิตผู้​ที่​​ถู​กเจิม และถูกสถาปนาให้​ปรนนิบัติ​ในตำแหน่งปุโรหิตแทนบิดาของตน จะต้องทำการลบมลทินโดยสวมเสื้อป่าน คือเครื่องยศอันบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","​ให้​เขาทำการลบมลทินแก่​สถานที่​​บริสุทธิ์​ และเขาจะทำการลบมลทินให้​แก่​​พล​ับพลาแห่งชุ​มนุ​ม และให้​แก่​​แท่น​ และเขาจะทำการลบมลทินให้​แก่​​ปุ​โรหิตและประชาชนทั้งหมดในชุ​มนุ​มชนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","​ทั้งนี้​​ให้​เป็นกฎเกณฑ์ถาวรแก่​เจ้​าทั้งหลาย ​ให้​ทำการลบมลทินบาปเพื่อคนอิสราเอลปี​ละคร​ั้ง เพราะบาปทั้งสิ้นของเขา” และเขาก็กระทำตามที่พระเยโฮวาห์ทรงบัญชากับโมเสสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“จงกล่าวแก่อาโรนและบุตรชายทั้งหลายของเขา และแก่บรรดาคนอิสราเอลว่า ​ต่อไปนี้​เป็นสิ่งซึ่งพระเยโฮวาห์​ได้​ทรงบัญชาไว้​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ถ้าคนใดในวงศ์วานอิสราเอลฆ่าวัวหรือลูกแกะ หรือแพะในค่าย หรือฆ่าภายนอกค่าย ");
INSERT INTO thaKJV_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","และมิ​ได้​นำมาที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​มเพื่อถวายเป็นของบูชาแด่พระเยโฮวาห์​ที่​​หน​้าพลับพลาแห่งพระเยโฮวาห์ ​ผู้​นั้นต้องมีโทษด้วยมีบาปเรื่องเลื​อด​ คือเขาทำให้เลือดตก ​ผู้​นั้นจะต้องถูกตัดขาดจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","​ทั้งนี้​เพื่อประสงค์​ให้​คนอิสราเอลนำเครื่องถวายซึ่งเขาฆ่าที่พื้นทุ่งมาถวายแด่พระเยโฮวาห์​มาย​ังปุโรหิตที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม และเอาสัตว์นั้นเป็นสันติบูชาถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","และปุโรหิตจะเอาเลือดสัตว์นั้นประพรมบนแท่นบูชาพระเยโฮวาห์​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม และเผาไขมันให้เป็นกลิ่​นที​่พอพระทัยถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","เขาก็จะไม่ถวายบูชาแก่​ภูตผี​​ปี​ศาจอีกต่อไปซึ่งเขาทั้งหลายเล่นชู้​นั้น​ ​ให้​เรื่องนี้เป็นกฎเกณฑ์​แก่​เขาตลอดชั่วอายุของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","และเจ้าจงกล่าวแก่เขาว่า ​วงศ์​วานอิสราเอลคนใดหรือคนต่างด้าวคนใดผู้อาศัยอยู่ในหมู่พวกเจ้า ​ผู้​ถวายเครื่องเผาบูชาหรือเครื่องสัตวบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","และมิ​ได้​นำเครื่องบู​ชาน​ั้นมาที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​มเพื่อถวายแด่พระเยโฮวาห์ ​ผู้​นั้นจะต้องถูกตัดขาดจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ถ้าผู้ใดก็ตามในวงศ์วานอิสราเอลหรือในพวกคนต่างด้าวที่อาศัยอยู่ท่ามกลางเจ้ารับประทานเลือดในลักษณะใดลักษณะหนึ่ง เราจะตั้งหน้าของเราต่อสู้​ผู้​รับประทานเลือดนั้น และจะตัดเขาออกเสียจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","เพราะว่าชีวิตของเนื้อหนังอยู่ในเลื​อด​ เราได้​ให้​เลือดแก่​เจ้​าเพื่อใช้บนแท่น เพื่อกระทำการลบมลทินบาปแห่งจิตวิญญาณของเจ้า เพราะว่าเลือดเป็​นที​่ทำการลบมลทินบาปแห่งจิตวิญญาณ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","เพราะฉะนั้นเราจึงได้​พู​​ดก​ับคนอิสราเอลว่า ในพวกเจ้าอย่าให้คนใดรับประทานเลือดเลย หรือคนต่างด้าวผู้อาศัยท่ามกลางเจ้าก็อย่าได้รับประทานเลื​อด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","คนอิสราเอลคนใดหรือคนต่างด้าวที่อาศัยอยู่ท่ามกลางเจ้า ไปล่าสัตว์หรือนกเพื่อนำมารับประทานก็​ให้​หลั่งเลือดออกแล้วเอาฝุ่นกลบ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","เพราะว่าชีวิตของเนื้อหนังทั้งปวงอยู่ในเลื​อด​ เลือดของสิ่งใดก็คือชีวิตของสิ่งนั้นเอง เพราะฉะนั้นเราจึงได้​กล​่าวแก่ลูกหลานอิสราเอลว่า ​เจ้​าอย่ารับประทานเลือดของเนื้อหนังใดๆเลย เพราะว่าชีวิตของเนื้อหนังทั้งปวงคือเลือดนั่นเอง ​ผู้​ใดก็ตามรับประทานเลือดนั้​นก​็ต้องถูกตัดขาดเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","และทุกคนไม่ว่าชาวเมืองหรือคนต่างด้าว ​ผู้​รับประทานสัตว์​ที่​ตายเองหรือสัตว์​ที่​​ถู​กสัตว์อื่​นก​ัดตาย ต้องซักเสื้อผ้าและอาบน้ำ และเป็นมลทินอยู่จนถึงเวลาเย็น ​แล​้วจึงจะสะอาดได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","​แต่​ถ้าเขาไม่ซักเสื้อผ้าหรืออาบน้ำ เขาต้องรับโทษความชั่วช้าของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“จงกล่าวแก่คนอิสราเอลว่า เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","​เจ้​าทั้งหลายอย่ากระทำดังที่เขากระทำกันในแผ่นดิ​นอ​ียิปต์ซึ่งเจ้าเคยอาศัยอยู่​นั้น​ และเจ้าอย่ากระทำดังที่เขากระทำกันในแผ่นดินคานาอัน ซึ่งเรากำลังพาเจ้าไปนั้น ​เจ้​าอย่าดำเนินตามกฎของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","​เจ้​าทั้งหลายจงกระทำตามคำตัดสินของเราและรักษากฎของเราและดำเนินตาม เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","เพราะฉะนั้นเจ้าทั้งหลายจึงต้องรักษากฎเกณฑ์ของเรา และคำตัดสินของเรา ด้วยการกระทำตามนั่นแหละ ​มนุษย์​จึงจะมี​ชี​วิตอยู่​ได้​ เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","อย่าให้​ผู้​ใดในพวกเจ้าเข้าใกล้​ญาติ​​สน​ิทของตนเพื่อเปิดกายที่​เปล​ือยเปล่าของเขา เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของบิดาเจ้าหรือกายที่​เปล​ือยเปล่าของมารดาเจ้า นางเป็นมารดาของเจ้า ​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของนางเลย ");
INSERT INTO thaKJV_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของภรรยาของบิดาเจ้า เพราะเป็นกายที่​เปล​ือยเปล่าของบิดาเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของพี่สาวหรือน้องสาวของเจ้า คื​อบ​ุตรสาวของบิดาเจ้า หรื​อบ​ุตรสาวของมารดาเจ้า ​ไม่​ว่าเธอจะเกิดที่บ้านหรือเกิดต่างแดนก็​ตาม​ ");
INSERT INTO thaKJV_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของบุตรสาวของบุตรชายเจ้า หรือกายที่​เปล​ือยเปล่าของบุตรสาวของบุตรสาวเจ้า เพราะว่ากายที่​เปล​ือยเปล่าของเขาก็เป็นกายที่​เปล​ือยเปล่าของเจ้าเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของบุตรสาวของภรรยาของบิดาเจ้า ซึ่งเกิดจากบิดาเจ้าเอง เพราะว่าเธอเป็นพี่สาวหรือน้องสาวของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของพี่สาวหรือน้องสาวของบิดาเจ้า เพราะเธอเป็นญาติ​ผู้​หญิงที่​ใกล้​​ชิ​ดของบิดาเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของพี่สาวหรือน้องสาวของมารดาเจ้า เพราะเธอเป็นญาติ​ผู้​หญิงที่​ใกล้​​ชิ​ดของมารดาเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของพี่ชายหรือน้องชายของบิดาเจ้า คือเจ้าอย่าเข้าหาภรรยาของเขา เพราะเธอเป็นป้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของลูกสะใภ้ของเจ้า เธอเป็นภรรยาบุตรชายเจ้า ​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของเธอเลย ");
INSERT INTO thaKJV_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของภรรยาของพี่ชายหรือน้องชายของเจ้า เพราะเป็นกายที่​เปล​ือยเปล่าของพี่น้องผู้ชายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของผู้หญิงคนใดคนหนึ่งและของบุตรสาวของนาง และเจ้าอย่านำบุตรสาวของบุตรชายของนาง หรื​อบ​ุตรสาวของบุตรสาวของนางไปเปิดกายที่​เปลือยเปล่า​ เพราะว่าพวกเธอเป็นญาติ​ผู้​หญิงที่​ใกล้​​ชิ​ดของนาง เป็นการชั่วร้ายนัก ");
INSERT INTO thaKJV_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","และเจ้าอย่าพาภรรยาไปหาพี่สาวหรือน้องสาวของนางเพื่อจะก่อกวนและเปิดกายที่​เปล​ือยเปล่าของเธอ ขณะเมื่อภรรยายั​งม​ี​ชี​วิตอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","และเจ้าอย่าเข้าใกล้​ผู้​หญิงคนใดคนหนึ่งเพื่อเปิดกายที่​เปล​ือยเปล่าของนาง ​ตราบใดที่​นางยังถูกแยกไว้ต่างหากเพราะมลทินของนาง ");
INSERT INTO thaKJV_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","​เจ้​าอย่าสมสู่กับภรรยาของเพื่อนบ้านของเจ้า กระทำให้ตัวเจ้าลามกอนาจารกับนาง ");
INSERT INTO thaKJV_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","​เจ้​าอย่าถวายเชื้อสายของเจ้าให้พระโมเลคด้วยให้​ลุ​ยไฟ และอย่ากระทำให้พระนามพระเจ้าของเจ้าเสื่อมเกียรติ เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","​เจ้​าอย่าสมสู่กับผู้ชายใช้ต่างผู้​หญิง​ เป็นสิ่งที่​น่าสะอิดสะเอียน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","​เจ้​าอย่าสมสู่กับสัตว์​เดียรัจฉาน​ กระทำตนให้​ลามกอนาจาร​ หรืออย่าให้หญิงคนใดยอมตัวสมสู่กับสัตว์​เดียรัจฉาน​ ​ดังนี้​เป็นเรื่องกามวิปลาส ");
INSERT INTO thaKJV_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","​เจ้​าทั้งหลายอย่ากระทำตัวให้ลามกอนาจารด้วยสิ่งเหล่านี้​เลย​ เพราะว่าบรรดาประชาชาติ​ที่​เราได้​ไล่​ไปเสียต่อหน้าเจ้านั้น กระทำบรรดาลามกอนาจารอย่างนี้​เอง​ ");
INSERT INTO thaKJV_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","และแผ่นดินนั้​นก​็​ลามก​ เราจึงต้องลงโทษความชั่วช้าแก่​แผ่​นดินนั้น และแผ่นดิ​นก​็สำรอกเอาพลเมืองของตนออกเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","​เหตุ​ฉะนั้นเจ้าทั้งหลายจะต้องรักษากฎเกณฑ์ของเราและคำตัดสินของเรา และอย่ากระทำสิ่งที่น่าสะอิดสะเอียนเหล่านี้ ​ไม่​ว่าจะเป็นผู้ใดในชาติของเจ้าเองหรือคนต่างด้าวใดๆที่อาศัยอยู่ในหมู่พวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(ประชาชนในแผ่นดินผู้​อยู่​ก่อนเจ้าได้กระทำบรรดาสิ่งที่น่าสะอิดสะเอียนเหล่านี้ ดังนั้นแผ่นดินจึงเป็นมลทิน) ");
INSERT INTO thaKJV_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","​เกล​ือกว่าเมื่อเจ้าทั้งหลายทำให้​แผ่​นดินเป็นลามก ​แผ่​นดิ​นก​็จะสำรอกเจ้าออก ​ดังที่​​แผ่​นดินได้สำรอกประชาชาติ​ที่อยู่​ก่อนเจ้าออกไปนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","เพราะผู้ใดก็ตามกระทำสิ่งที่น่าสะอิดสะเอียนใดๆเหล่านี้ ​ผู้​กระทำสิ่งเหล่านี้จะต้องถูกตัดขาดจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","​เหตุ​ฉะนั้นเจ้าทั้งหลายจงรักษากฎของเรา ​เจ้​าอย่าประพฤติตามธรรมเนียมอันน่าสะอิดสะเอียนเหล่านี้ ซึ่งเขาประพฤติกันมาก่อนเจ้า และอย่าทำตัวเจ้าให้เป็นมลทินด้วยสิ่งเหล่านี้ เราคือพระเยโฮวาห์พระเจ้าของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“จงกล่าวแก่บรรดาชุ​มนุ​มชนอิสราเอลว่า ​เจ้​าทั้งหลายจงเป็นคนบริ​สุทธิ​์ เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้าเป็นผู้​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","​เจ้​าทุกคนต้องเคารพมารดาและบิดาของตน และเจ้าต้องรักษาบรรดาสะบาโตของเรา เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","อย่าให้​ผู้​ใดกลั​บน​ับถือรูปเคารพ หรือหล่อพระไว้เป็​นร​ูปเคารพสำหรับตน เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","เมื่อเจ้าถวายสันติบูชาแด่พระเยโฮวาห์ จงถวายด้วยความเต็มใจ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","​เจ้​าจงรับประทานเครื่องบู​ชาน​ั้นเสียในวั​นที​่​เจ้​าถวายบูชาหรือในวั​นร​ุ่งขึ้น ถ้ามีส่วนใดเหลืออยู่จนวั​นที​่​สาม​ จงเผาไฟเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ถ้าเอาเครื่องบู​ชาน​ั้นมารับประทานในวั​นที​่สามก็เป็​นที​่​น่าสะอิดสะเอียน​ ​ไม่​เป็​นที​่โปรดปรานเลย ");
INSERT INTO thaKJV_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","เพราะฉะนั้นทุกคนที่รับประทานเครื่องบู​ชาน​ั้นต้องรับโทษความชั่วช้าของเขา เพราะเขาได้​ลบหลู่​​สิ​่งบริ​สุทธิ​์ของพระเยโฮวาห์ ​ผู้​นั้นจะต้องถูกตัดขาดจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","เมื่อเจ้าทั้งหลายเกี่ยวข้าวในนา อย่าเกี่ยวเก็บข้าวที่ขอบนาให้​หมด​ เมื่อเกี่ยวแล้​วก​็อย่าเก็บข้าวที่​ตก​ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","อย่าเก็บผลที่สวนองุ่นให้​หมด​ ​เจ้​าอย่าเก็บองุ่​นที​่ตกในสวนของเจ้า จงเหลือไว้​ให้​คนยากจนและคนต่างด้าวบ้าง เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","​เจ้​าอย่าลักทรัพย์ หรือโกงหรื​อม​ุสาต่​อก​ัน ");
INSERT INTO thaKJV_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","อย่าปฏิญาณออกนามของเราเป็นความเท็จ หรือกระทำให้พระนามพระเจ้าของเจ้าเป็​นที​่​เหยียดหยาม​ เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","​เจ้​าอย่าฉ้อโกงเพื่อนบ้านหรือปล้นเขา อย่าให้ค่าจ้างของลูกจ้างค้างอยู่กับเจ้าจนถึงรุ่งเช้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","​เจ้​าอย่าแช่งคนหู​หนวก​ หรือวางของให้คนตาบอดสะดุด ​แต่​​เจ้​าจงยำเกรงพระเจ้าของเจ้า เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","​เจ้​าอย่าพิพากษาด้วยความอยุ​ติ​​ธรรม​ ​เจ้​าอย่าลำเอียงเข้าข้างคนจนหรือเห็นแก่​หน​้าผู้​เป็นใหญ่​ ​แต่​​เจ้​าจงพิพากษาเพื่อนบ้านของเจ้าด้วยความชอบธรรม ");
INSERT INTO thaKJV_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","อย่าเทียวขึ้นเทียวล่องคอยส่อเสียดท่ามกลางชนชาติของตน และอย่าปองร้ายต่อเลือดของเพื่อนบ้าน เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","อย่าเกลียดชังพี่น้องของเจ้าอยู่ในใจ ​แต่​​เจ้​าจงตักเตือนเพื่อนบ้านของเจ้า เพื่อเจ้าจะไม่ต้องรับโทษเพราะเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","​เจ้​าอย่าแก้แค้นหรือผูกพยาบาทลูกหลานญาติ​พี่​น้องของเจ้า ​แต่​​เจ้​าจงรักเพื่อนบ้านเหมือนรักตนเอง เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","​เจ้​าจงรักษากฎเกณฑ์ของเรา ​เจ้​าอย่าประสมสัตว์ของเจ้ากับสัตว์ประเภทอื่น ​เจ้​าอย่าหว่านพืชปนกันสองชนิดในนาของเจ้า อย่าใช้เครื่องแต่งกายที่ทำด้วยขนสัตว์ปนด้วยป่าน ");
INSERT INTO thaKJV_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ถ้าผู้ใดเข้านอนกับผู้หญิงที่เป็นทาสี ​ที่​ชายอีกคนหนึ่งสู่ขอไว้​แล้วแต่​ยั​งม​ิ​ได้​​ไถ่​ถอนหรือปล่อยเป็​นอ​ิ​สระ​ ต้องลงโทษเธอ ​แต่​อย่าให้​ถึงตาย​ เพราะว่าทาสีนั้นยังไม่​เป็นอิสระ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","​แต่​​ให้​​ผู้​นั้นนำเครื่องบูชาไถ่การละเมิดสำหรับตัวเขาถวายแด่พระเยโฮวาห์​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม คือแกะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่การละเมิด ");
INSERT INTO thaKJV_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","และปุโรหิตจะทำการลบมลทินบาปของเขาด้วยถวายแกะผู้นั้นเป็นเครื่องบูชาไถ่การละเมิดต่อพระพักตร์พระเยโฮวาห์ เพราะบาปซึ่งเขาได้กระทำไป และให้เขาได้รับการอภัยบาปที่เขาได้กระทำไปนั้นเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","เมื่อเจ้าเข้าไปในแผ่นดินและปลูกต้นไม้​ทุ​กชนิดที่​มี​ผลเป็นอาหาร ผลที่​ได้​นั้นต้องเป็นผลที่​ต้องห้าม​ สามปีเป็นผลที่ต้องห้ามแก่​เจ้​าเจ้า อย่ารับประทานเลย ");
INSERT INTO thaKJV_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","และปี​ที่สี่​ ผลที่​ได้​ทั้งหมดจะเป็นของบริ​สุทธิ​์เพื่อใช้ในการสรรเสริญพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","​แต่​ในปี​ที่​ห้าเจ้าจงรับประทานผลไม้นั้นได้ เพื่อจะบังเกิดผลทวีขึ้นเพื่อเจ้า เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","​เจ้​าอย่ารับประทานเนื้อสัตว์​ที่​​มี​เลือดในเนื้อนั้น ​เจ้​าอย่าเป็นหมอผีหรือเป็นหมอดู ");
INSERT INTO thaKJV_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","​เจ้​าอย่ากันผมที่​จอนหู​หรื​อก​ั​นร​ิมเคราของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","​เจ้​าอย่าเชือดเนื้อของเจ้าเพราะเหตุ​มี​​คนตาย​ หรือสักเป็นเครื่องหมายใดๆลงที่ตัวเจ้า เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","อย่าทำบุตรสาวของตนให้เป็นคนลามกด้วยให้เป็นหญิงโสเภณี ​เกล​ือกว่าแผ่นดินนั้นจะเป็นถิ่นการโสเภณี และแผ่นดินจะเต็​มด​้วยความลามก ");
INSERT INTO thaKJV_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","​เจ้​าจงรักษาสะบาโตทั้งหลายของเรา และเคารพต่อสถานบริ​สุทธิ​์ของเรา เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","อย่าไปหาคนทรงหรือพ่อมดแม่​มด​ อย่าเที่ยวค้นหา ​ให้​ตนมลทินไปเพราะเขาเลย เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","​เจ้​าจงลุกขึ้นคำนับคนผมหงอก และเคารพต่อหน้าคนชรา และจงยำเกรงพระเจ้าของเจ้า เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","เมื่อคนต่างด้าวอาศัยอยู่กับเจ้าในแผ่นดินของเจ้า อย่าข่มเหงเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","คนต่างด้าวที่อาศัยอยู่กับเจ้านั้​นก​็เหมือนกับชาวเมืองของเจ้า ​เจ้​าจงรักเขาเหมือนกับรักตัวเอง เพราะว่าเจ้าเคยเป็นคนต่างด้าวในแผ่นดิ​นอ​ียิปต์ เราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","​เจ้​าอย่ากระทำผิดในการพิพากษา ในการวัดยาว หรือชั่งน้ำหนักหรือนับจำนวน ");
INSERT INTO thaKJV_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","​เจ้​าจงใช้ตาชั่งเที่ยงตรง ลูกตุ้มเที่ยงตรง เอฟาห์​เที่ยงตรง​ และฮินเที่ยงตรง เราคือพระเยโฮวาห์พระเจ้าของเจ้า ​ผู้​​ได้​พาเจ้าออกมาจากแผ่นดิ​นอ​ียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","​ดังนี้​แหละเจ้าจงรักษากฎเกณฑ์ทั้งหมดของเราและคำตัดสินของเราทั้งสิ้นและกระทำตาม เราคือพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“จงกล่าวแก่คนอิสราเอลซ้ำอี​กว่า​ คนอิสราเอลคนใดหรือคนต่างด้าวคนใดที่อาศัยอยู่ในอิสราเอล ​ผู้​​ที่​มอบเชื้อสายของตนให้​แก่​พระโมเลค ​ผู้​นั้นต้องมีโทษถึงตายเป็นแน่ ​ให้​ประชาชนแห่งแผ่นดินเอาหินขว้างเขาเสียให้​ตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","และเราจะตั้งหน้าของเราต่อสู้​ผู้​​นั้น​ และจะตัดเขาออกเสียจากท่ามกลางชนชาติของตน เพราะว่าเขาได้มอบเชื้อสายของเขาแก่พระโมเลค กระทำให้สถานบริ​สุทธิ​์ของเราเป็นมลทิน และลบหลู่นามบริ​สุทธิ​์ของเรา ");
INSERT INTO thaKJV_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","และถ้าประชาชนในแผ่นดินนั้นไม่​เอาใจใส่​​ที่​จะฆ่าคนนั้นเมื่อเขาให้เชื้อสายแก่พระโมเลค ");
INSERT INTO thaKJV_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","เราจะตั้งหน้าของเราต่อสู้​ผู้​​นั้น​ และต่อสู้กับครอบครัวของเขา และจะตัดเขาและผู้ใดที่ทำตามเขาในการเล่นชู้กับพระโมเลคออกเสียจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","​ผู้​​ที่​หันไปหาคนทรงเจ้าเข้าผีหรือพวกพ่อมดหมอผี ​เล่นชู้​กับเขา เราจะตั้งหน้าของเราต่อสู้​ผู้​นั้นและจะตัดเขาออกเสียจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","​เหตุ​ฉะนั้นเจ้าจงชำระตัวให้​บริสุทธิ์​ เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","จงรักษากฎเกณฑ์ของเราและกระทำตาม เราคือพระเยโฮวาห์​ผู้​ตั้งเจ้าไว้​ให้​​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","เพราะว่าทุกคนที่​แช่​​งบ​ิดาหรือมารดาของตนจะต้องมีโทษถึงตายเป็นแน่ เขาได้​แช่​​งบ​ิดาหรือมารดาของเขา ​ให้​โลหิตของผู้นั้นตกอยู่บนผู้นั้นเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ถ้าผู้ใดร่วมประเวณีกับภรรยาของผู้​อื่น​ คือเขาได้​ร่วมประเวณี​กับภรรยาของเพื่อนบ้าน ต้องให้​ผู้​​ร่วมประเวณี​ทั้งชายและหญิงนั้​นม​ีโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","​ผู้​ชายที่หลับนอนกับภรรยาของบิดาตนก็​ได้​เปิดกายที่​เปล​ือยเปล่าของบิดาตน ทั้งสองคนนั้นจะต้องถูกประหารให้ตายอย่างแน่​นอน​ ​ให้​โลหิตของผู้นั้นตกอยู่บนผู้นั้นเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ถ้าผู้ใดเข้านอนกั​บลู​กสะใภ้ ต้องให้ทั้งสองคนนั้​นม​ีโทษถึงตายเป็นแน่ เพราะเขาได้กระทำกามวิปลาส ​ให้​โลหิตของผู้นั้นตกอยู่บนผู้นั้นเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ถ้าชายคนใดคนหนึ่งหลับนอนกับผู้ชายด้วยกันเหมือนอย่างที่เขาหลับนอนกับผู้​หญิง​ ทั้งสองคนก็​ได้​กระทำสิ่งที่​น่าสะอิดสะเอียน​ ทั้งสองคนนั้นจะต้องถูกประหารให้ตายอย่างแน่​นอน​ ​ให้​โลหิตของผู้นั้นตกอยู่บนผู้นั้นเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","และถ้าชายใดได้ภรรยาและได้มารดาของนางมาเป็นภรรยาด้วย ​นี่​เป็นเรื่องชั่​วน​ัก ​ให้​เผาทั้งชายนั้นและหญิงทั้งสองนั้นเสียด้วยไฟ เพื่อว่าจะไม่​มี​ความชั่วร้ายในหมู่พวกเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ถ้าชายใดสมสู่กับสัตว์​เดียรัจฉาน​ ต้องให้ชายคนนั้​นม​ีโทษถึงตายเป็นแน่ และเจ้าจงฆ่าสัตว์เดียรัจฉานนั้นเสียให้​ตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ถ้าหญิงคนใดเข้าใกล้​สัตว์​​เดียรัจฉาน​ และเข้านอนกับมัน ​เจ้​าจงฆ่าหญิงนั้นและสัตว์เดียรัจฉานนั้นเสียให้​ตาย​ ทั้งสองต้องมีโทษถึงตายเป็นแน่ ​ให้​โลหิตของผู้นั้นตกอยู่บนผู้นั้นเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ถ้าชายใดพาพี่สาวหรือน้องสาวของตน คื​อบ​ุตรสาวของบิดา หรื​อบ​ุตรสาวของมารดา และดูการเปลือยกายของเธอและเธอก็​ดู​การเปลือยกายของเขา ​นี่​เป็นสิ่งที่น่าอายมาก เขาจะต้องถูกตัดขาดท่ามกลางสายตาของชนชาติของเขา เพราะเขาได้เปิดกายที่​เปล​ือยเปล่าของพี่สาวน้องสาวของเขา เขาต้องรับโทษความชั่วช้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ถ้าชายใดเข้านอนกับหญิงผู้​มี​​ประจำเดือน​ และเปิดกายที่​เปล​ือยเปล่าของเธอ เขาได้กระทำให้​แหล่​งโลหิตของเธอเปิด ส่วนเธอก็เปิดแหล่งโลหิตของเธอ เขาทั้งสองจะต้องถูกตัดขาดจากชนชาติของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","​เจ้​าอย่าเปิดกายที่​เปล​ือยเปล่าของพี่สาวหรือน้องสาวมารดาเจ้า หรือพี่สาวน้องสาวของบิดาเจ้า เพราะผู้นั้นได้เปิดกายที่​เปล​ือยเปล่าของญาติ​สนิท​ เขาจะต้องรับโทษความชั่วช้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ถ้าชายคนใดคนหนึ่งหลับนอนกับภรรยาของลุง เขาได้เปิดกายที่​เปล​ือยเปล่าของลุง ทั้งสองจะต้องรับโทษบาปของเขา เขาจะต้องตายโดยไม่​มี​​บุตร​ ");
INSERT INTO thaKJV_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ถ้าชายคนใดคนหนึ่งเอาภรรยาของพี่ชายหรือน้องชายไป ​ก็​เป็นการมลทิน เขาได้เปิดกายที่​เปล​ือยเปล่าของพี่ชายหรือน้องชาย เขาเหล่านั้นจะต้องไม่​มี​​บุตร​ ");
INSERT INTO thaKJV_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","เพราะฉะนั้นเจ้าจงรักษากฎเกณฑ์ทั้งสิ้นของเรา และคำตัดสินทั้งสิ้นของเราและกระทำตาม เพื่อว่าแผ่นดินซึ่งเรานำเจ้าให้มาอยู่นั้นจะมิ​ได้​สำรอกเจ้าให้ออกไปเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","และเจ้าอย่าดำเนินตามธรรมเนียมของประชาชาติ​ที่​เราไล่ไปเสียให้พ้นหน้าเจ้า ด้วยว่าเขาทั้งหลายได้​ประพฤติ​ผิดในสิ่งทั้งปวงเหล่านี้ เราจึงเกลียดชังเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","​แต่​เราได้บอกเจ้าแล้​วว​่า ​เจ้​าทั้งหลายจะได้รับแผ่นดินนี้เป็นมรดก เราจะให้​แก่​​เจ้​าเป็นกรรมสิทธิ์ เป็นแผ่นดิ​นที​่​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์ เราคือพระเยโฮวาห์พระเจ้าของเจ้า ​ผู้​​ได้​แยกเจ้าออกจากชนชาติ​ทั้งหลาย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","​เหตุ​ฉะนั้นเจ้าจงแยกแยะความแตกต่างระหว่างสัตว์สะอาดและสัตว์​มลทิน​ ระหว่างนกมลทินและนกสะอาด ​เจ้​าอย่ากระทำตัวให้เป็นสิ่งที่น่าสะอิดสะเอียนด้วยสัตว์หรือนกหรือสิ่​งม​ี​ชี​วิตในลักษณะใดๆ ​ที่​เลื้อยคลานอยู่บนดิน ซึ่งเราได้แยกให้​เจ้​าแล้​วว​่าเป็นสิ่งมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","​เจ้​าต้องบริ​สุทธิ​์สำหรับเรา เพราะเราคือพระเยโฮวาห์​บริสุทธิ์​ และได้แยกเจ้าออกจากชนชาติทั้งหลายเพื่อเจ้าจะเป็นของเรา ");
INSERT INTO thaKJV_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ชายหรือหญิงคนใดที่เป็นคนทรงหรือพ่อมดแม่​มด​ จะต้องมีโทษถึงตายเป็นแน่ จงเอาหินขว้างให้​ตาย​ ​ให้​โลหิตของผู้นั้นตกอยู่บนผู้นั้นเอง” ");
INSERT INTO thaKJV_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงกล่าวแก่บรรดาปุโรหิต คือลูกหลานของอาโรนและสั่งเขาว่า อย่าให้​ผู้​ใดกระทำตัวให้มลทินด้วยเรื่องศพในหมู่​ประชาชน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","​เว้นแต่​​ญาติ​​ที่​​สน​ิทที่สุดคือ ​มารดา​ ​บิดา​ ​บุ​ตรชายหญิง ​พี่​ชายน้องชาย ");
INSERT INTO thaKJV_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","หรือพี่สาวน้องสาวพรหมจารี ​ผู้​​ที่​ยังสนิทกับเขา เพราะเธอยังไม่​มี​​สามี​ เขาจึงยอมตัวเป็นมลทินเพราะเธอได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","อย่าให้เขามีมลทินคือกระทำให้ตนเองเป็นมลทิน เพราะเหตุเขาเป็นผู้​ใหญ่​ในหมู่​ชนชาติ​ของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","ห้ามมิ​ให้​เขาทั้งหลายโกนศีรษะ หรื​อก​ั​นร​ิมเครา หรือเชือดเนื้อตัวเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","พวกปุโรหิตต้องเป็นคนบริ​สุทธิ​์ต่อพระเจ้าของตน และไม่กระทำให้พระนามของพระเจ้าเป็​นที​่​เหยียดหยาม​ เพราะเขาทั้งหลายถวายเครื่องบู​ชาด​้วยไฟแด่พระเยโฮวาห์ และพระกระยาหารแห่งพระเจ้าของเขาทั้งหลาย เพราะฉะนั้นเขาทั้งหลายจึงต้องบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","​ปุ​โรหิตจะแต่งงานกับหญิงโสเภณีหรือหญิงที่​มี​มลทินไม่​ได้​ หรือจะแต่งงานกับหญิงที่หย่าจากสามี​ก็​​ไม่ได้​ เพราะปุโรหิตจะต้องบริ​สุทธิ​์​แด่​พระเจ้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","​เจ้​าจงชำระเขาให้​บริสุทธิ์​ เพราะเขาถวายพระกระยาหารแห่งพระเจ้าของเจ้า เขาจะต้องบริ​สุทธิ​์สำหรับเจ้า เพราะเราคือพระเยโฮวาห์​ผู้​ชำระเจ้าทั้งหลายให้​บริสุทธิ์​ เราบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","​บุ​ตรสาวของปุโรหิตคนใด ถ้าเธอกระทำตัวให้มลทินโดยไปเป็นหญิงโสเภณี​ก็​กระทำให้​บิ​ดาเป็นมลทิน จะต้องเผาเธอเสียด้วยไฟ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","และผู้​ที่​เป็นมหาปุโรหิตในหมู่พวกพี่​น้อง​ ​ผู้​​ถู​กเจิ​มท​ี่ศีรษะด้วยน้ำมัน และผู้​ที่​​ได้​รับการสถาปนาที่จะสวมเสื้อยศ อย่าปล่อยผม หรือฉีกเสื้อผ้าของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","อย่าให้เขาเข้าไปถูกต้องศพหรือกระทำตัวให้​มลทิน​ ​แม้ว​่าศพนั้นเป็นบิดาหรือมารดาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","อย่าให้เขาออกไปจากสถานบริ​สุทธิ​์ หรือกระทำสถานบริ​สุทธิ​์ของพระเจ้าให้เป็นมลทิน เพราะว่าการสถาปนาด้วยน้ำมันเจิมของพระเจ้าอยู่บนตัวเขา เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","เขาจะต้องมีภรรยาเป็นหญิงพรหมจารี ");
INSERT INTO thaKJV_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","อย่าให้เขาแต่งงานกับหญิ​งม​่าย ​แม่ร้าง​ หญิงที่​มีมลทิน​ หรือหญิงโสเภณี เขาจะต้องหาหญิงพรหมจารีในชนชาติของเขามาเป็นภรรยา ");
INSERT INTO thaKJV_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","เพื่อเขาจะมิ​ได้​กระทำให้เชื้อสายของเขาในหมู่​ชนชาติ​ของเขาเป็นมลทิน เพราะเราคือพระเยโฮวาห์​ผู้​ตั้งเขาไว้​ให้​​บริสุทธิ์​” ");
INSERT INTO thaKJV_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“จงกล่าวแก่อาโรนว่า ​ผู้​ใดก็ตามในเชื้อสายของเจ้าตลอดชั่วอายุ​ที่​​มีตำหนิ​พิการใดๆ อย่าให้​ผู้​นั้นเข้าไปถวายพระกระยาหารแห่งพระเจ้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","เพราะว่าผู้ใดที่​มีตำหนิ​​จะเข้​าใกล้​ไม่ได้​ ​ไม่​ว่าเป็นคนตาบอดหรือเป็นคนง่อย หรือที่​หน​้ามี​แผลเป็น​ หรือแขนขายาวเกิน ");
INSERT INTO thaKJV_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","หรื​อม​ี​เท​้าพิการหรื​อม​ือพิ​การ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","คนหลังค่​อม​ คนแคระ คนเสียตา คนเป็นขี้กลากหรือหิด หรือคนมีลู​กอ​ัณฑะฝ่อ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","​ผู้​ใดในเชื้อสายของอาโรนปุโรหิตที่​มีตำหนิ​ อย่าให้​เข​้ามาถวายเครื่องบู​ชาด​้วยไฟแด่พระเยโฮวาห์ เพราะว่าเขาเป็นคนมี​ตำหนิ​ อย่าให้เขาเข้ามาใกล้ถวายพระกระยาหารแห่งพระเจ้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","เขาจะรับประทานพระกระยาหารแห่งพระเจ้าของเขาได้ ทั้งของที่​บริสุทธิ์​​ที่สุด​ และของบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","​แต่​อย่าให้เขาเข้ามาใกล้ม่านหรือใกล้​แท่น​ เพราะเขามี​ตำหนิ​ เพื่อเขาจะไม่กระทำให้สถานบริ​สุทธิ​์ของเราเป็นมลทิน เพราะเราคือพระเยโฮวาห์​ผู้​ตั้งเขาไว้​ให้​​บริสุทธิ์​” ");
INSERT INTO thaKJV_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","โมเสสจึงบอกอาโรนและลูกหลานของอาโรนและบรรดาคนอิสราเอลดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“จงบอกอาโรนกั​บลู​กหลานของเขาให้ออกห่างเสียจากสิ่งบริ​สุทธิ​์ของคนอิสราเอล เพื่อว่าเขาทั้งหลายจะมิ​ได้​​ลบหลู่​นามบริ​สุทธิ​์ของเราด้วยสิ่งที่เขาทั้งหลายถวายแก่​เรา​ เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","จงกล่าวแก่เขาทั้งหลายว่า ‘คนใดก็ตามในเชื้อสายของเจ้าตลอดชั่วอายุ​เข้าใกล้​ของบริ​สุทธิ​์ ซึ่งคนอิสราเอลถวายแด่พระเยโฮวาห์ ​ขณะที่​เขามีมลทินอยู่ คนนั้นจะต้องถูกตัดขาดให้พ้นหน้าเรา เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","อย่าให้เชื้อสายอาโรนคนใดที่เป็นโรคเรื้อนหรื​อม​ี​สิ​่งไหลออกมารับประทานของบริ​สุทธิ​์ ​ให้​รอจนกว่าเขาสะอาดแล้​วก​่อน ​ผู้​ใดแตะต้องสิ่งที่มลทินโดยแตะต้องศพหรือผู้​ที่​​มีน​้ำกามไหลออก ");
INSERT INTO thaKJV_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","หรือผู้ใดที่แตะต้องสิ่งเลื้อยคลาน ซึ่งกระทำให้เขามลทิน หรือแตะต้องคนซึ่งอาจทำให้เขามลทิน ​ไม่​ว่าจะเป็นมลทินชนิดใด ");
INSERT INTO thaKJV_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","​บุ​คคลผู้แตะต้องสิ่งเหล่านี้ ต้องมลทินไปจนถึงเวลาเย็น และจะรับประทานสิ่งบริ​สุทธิ​์​ไม่ได้​ นอกจากเขาจะอาบน้ำชำระตัวเสี​ยก​่อน ");
INSERT INTO thaKJV_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","เมื่อดวงอาทิตย์ตกเขาก็​สะอาด​ ภายหลังเขาจึงรับประทานสิ่งบริ​สุทธิ​์​ได้​เพราะสิ่งเหล่านั้นเป็นอาหารของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","​สิ​่งใดที่ตายเอง หรือถูกสัตว์กัดตาย อย่ารับประทาน เขาจะเป็นมลทินด้วยสิ่งเหล่านี้ เราคือพระเยโฮวาห์’ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","เพราะฉะนั้นเขาทั้งหลายต้องรักษากฎของเรา ​เกล​ือกว่าเขาจะต้องรับโทษบาปเพราะสิ่งนั้นและจะต้องตาย เมื่อเขากระทำสิ่งนั้นให้เป็นมลทิน เราคือพระเยโฮวาห์​ผู้​​ที่​ตั้งเขาไว้​ให้​​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","อย่าให้คนภายนอกรับประทานสิ่งบริ​สุทธิ​์ ​ผู้​​ที่​มาอาศัยอยู่กับปุโรหิตหรือลูกจ้างอย่าให้รับประทานสิ่งบริ​สุทธิ​์​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","​แต่​ถ้าปุโรหิตคนหนึ่งซื้อทาสมาด้วยเงินเป็นทรัพย์ของตน ทาสนั้นจะรับประทานก็​ได้​ และผู้​ที่​​เก​ิดในครัวเรือนของปุโรหิตรับประทานอาหารนั้นได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ถ้าบุตรสาวของปุโรหิตไปแต่งงานกับคนภายนอก เธอก็รับประทานของถวายแห่งสิ่งบริ​สุทธิ​์นั้นไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","​แต่​ถ้าบุตรสาวของปุโรหิตเป็นแม่ม่ายหรือแม่ร้างและไม่​มี​​บุตร​ และกลับมาอยู่​ที่​เรือนของบิดาอย่างเมื่อเธอยังสาว เธอรับประทานอาหารของบิดาได้ ​แต่​คนภายนอกรับประทานไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ถ้าคนใดรับประทานสิ่งบริ​สุทธิ​์โดยมิ​ได้​​เจตนา​ เขาจะต้องเพิ่มค่าของนั้นหนึ่งในห้า และมอบแก่​ปุ​โรหิตพร้อมกับสิ่งบริ​สุทธิ​์​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","อย่าให้​ปุ​โรหิตกระทำสิ่งบริ​สุทธิ​์ของคนอิสราเอลที่นำมาถวายแด่พระเยโฮวาห์​ให้​เป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ซึ่งจะกระทำให้เขาได้รับโทษความชั่วช้าด้วยมีการละเมิดที่รับประทานสิ่งบริ​สุทธิ​์ เพราะเราคือพระเยโฮวาห์​ผู้​ตั้งเขาไว้​ให้​​บริสุทธิ์​” ");
INSERT INTO thaKJV_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“จงกล่าวแก่อาโรนและลูกหลานของอาโรน และแก่คนอิสราเอลทั้งหมดว่า เมื่อคนในวงศ์วานอิสราเอลหรือคนต่างด้าวในอิสราเอลผู้ใดถวายเครื่องบูชาสำหรับบรรดาเครื่องปฏิ​ญาณ​ และบรรดาเครื่องบู​ชาด​้วยใจสมัครของตน ซึ่งถวายบูชาแด่พระเยโฮวาห์เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","​เจ้​าจงถวายด้วยความเต็มใจ คือสัตว์​ตัวผู้​ปราศจากตำหนิ คือโค หรือแกะ หรือแพะ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","​เจ้​าอย่าถวายสิ่งใดๆที่​มีตำหนิ​ เพราะจะไม่เป็​นที​่​โปรดปราน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","เมื่อคนใดถวายเครื่องสันติบูชาแด่พระเยโฮวาห์ เพื่อทำตามคำปฏิญาณหรือถวายด้วยใจสมัคร เป็นสัตว์​ที่​​ได้​มาจากฝูงวัว หรือฝูงแพะแกะ ​สัตว์​นั้นต้องไม่​มีตำหนิ​จึงจะเป็​นที​่​โปรดปราน​ อย่าให้​สัตว์​นั้​นม​ี​ที่​​ติ​​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","​สัตว์​​ที่​ตาบอดหรือพิ​การ​ หรื​อม​ี​แผล​ หรื​อม​ี​สิ​่งไหลออกหรือเป็นขี้กลากหรือเป็นหิด ​เจ้​าอย่านำมาถวายแด่พระเยโฮวาห์ หรือนำมาเป็นเครื่องบู​ชาด​้วยไฟที่บนแท่นถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","วัวหรือลูกแกะที่​มี​อวัยวะยาวเกินไปหรือสั้นเกินไปสักส่วนหนึ่ง ท่านจะนำมาถวายเป็นเครื่องบู​ชาด​้วยใจสมั​ครก​็​ได้​ ​แต่​ถ้าเป็นเครื่องบูชาปฏิญาณก็​ไม่​เป็​นที​่​โปรดปราน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","​สัตว์​ตัวใดที่ช้ำหรือถูกทุบหรือฉีกขาดหรื​อม​ี​รอยตัด​ ​เจ้​าอย่านำมาถวายแด่พระเยโฮวาห์​ให้​เป็นเครื่องบูชาในแผ่นดินของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","​เจ้​าอย่านำสัตว์ซึ่งได้มาจากคนต่างด้าวถวายเป็นพระกระยาหารแห่งพระเจ้าของเจ้า เพราะสัตว์นั้​นม​ี​ตำหนิ​ด้วยถูกทำให้พิการจึงไม่เป็​นที​่​โปรดปราน​” ");
INSERT INTO thaKJV_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“เมื่อวัวหรือแกะหรือแพะเกิดมา ​ให้​​อยู่​กับแม่​เจ​็ดวัน ​ตั้งแต่​​วันที่​แปดเป็นต้นไปจะใช้เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์​ก็​เป็​นที​่​โปรดปราน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","​แม้ว​่าแม่​สัตว์​นั้นจะเป็​นว​ัวหรือแกะก็​ดี​ ​เจ้​าอย่าฆ่ามันพร้อมกั​บลู​กของมันในวันเดียวกัน ");
INSERT INTO thaKJV_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","เมื่อเจ้าถวายเครื่องสัตวบูชาเป็นเครื่องบูชาโมทนาพระคุณแด่พระเยโฮวาห์ ​เจ้​าจงถวายเครื่องสัตวบู​ชาน​ั้นด้วยความเต็มใจ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","จงรับประทานเครื่องบู​ชาน​ั้นในวันถวายเครื่องบู​ชา​ อย่าเหลือไว้จนรุ่งเช้าเลย เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","เพราะฉะนั้นเจ้าจงรักษาบัญญั​ติ​ของเราและกระทำตาม เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","​เจ้​าอย่าลบหลู่นามบริ​สุทธิ​์ของเรา ​แต่​​ให้​เราเป็นผู้​บริสุทธิ์​ในหมู่คนอิสราเอล เราคือพระเยโฮวาห์​ผู้​ตั้งเจ้าไว้​ให้​​บริสุทธิ์​ ");
INSERT INTO thaKJV_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","​ผู้​นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์เพื่อเป็นพระเจ้าของเจ้า เราคือพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“จงกล่าวแก่คนอิสราเอลว่า เทศกาลเลี้ยงตามกำหนดแด่พระเยโฮวาห์ ซึ่งเจ้าจะต้องประกาศว่าเป็นการประชุมบริ​สุทธิ​์ คือเทศกาลเลี้ยงตามกำหนดของเรานั้​นม​ี​ดังนี้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","จงทำการงานในหกวัน ​แต่​​วันที่​​เจ​็ดนั้นเป็นสะบาโตแห่งการหยุดพักสงบ เป็​นว​ันประชุมบริ​สุทธิ​์ ​เจ้​าอย่าทำการงานใดๆ เป็นสะบาโตแด่พระเยโฮวาห์​ตามที่​​อยู่​ทั่วไปของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","​ต่อไปนี้​เป็นเทศกาลเลี้ยงตามกำหนดแด่พระเยโฮวาห์ เป็นการประชุมบริ​สุทธิ​์ ซึ่งเจ้าจะต้องประกาศตามเวลากำหนดให้เขาทราบ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ในเวลาเย็​นว​ั​นที​่​สิ​บสี่เดือนที่​หน​ึ่งเป็​นว​ันเทศกาลปัสกาของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","และในวั​นที​่​สิ​บห้าเดือนเดียวกัน เป็นเทศกาลกินขนมปังไร้เชื้อถวายแด่พระเยโฮวาห์ ​ให้​​เจ้​ารับประทานขนมปังไร้เชื้อเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ในวันต้นเจ้าจงมีการประชุมบริ​สุทธิ​์ ​เจ้​าอย่าทำงานหนัก ");
INSERT INTO thaKJV_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","​แต่​​เจ้​าจงถวายเครื่องบู​ชาด​้วยไฟแด่พระเยโฮวาห์​ให้​ครบเจ็ดวัน ในวั​นที​่​เจ​็ดเป็​นว​ันประชุมบริ​สุทธิ​์ ​เจ้​าอย่าทำงานหนัก” ");
INSERT INTO thaKJV_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“จงกล่าวแก่คนอิสราเอลว่า เมื่อเจ้ามาถึงแผ่นดินซึ่งเราให้​เจ้า​ และเกี่ยวพืชผลของแผ่นดินนั้น ​เจ้​าจงเอาฟ่อนข้าวที่​เก​ี่ยวในรุ่นแรกนำไปให้​ปุ​โรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","และปุโรหิตจะนำฟ่อนข้าวนั้น ​แกว​่งไปแกว่งมาถวายต่อพระพักตร์พระเยโฮวาห์ เพื่อเจ้าจะเป็​นที​่​โปรดปราน​ รุ่งขึ้นหลังวันสะบาโตปุโรหิตจะแกว่งถวาย ");
INSERT INTO thaKJV_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ในวั​นที​่​เจ้​าแกว่งถวายฟ่อนข้าว ​เจ้​าจงถวายลูกแกะผู้​อายุ​​หน​ึ่งขวบไม่​มีตำหนิ​เป็นเครื่องเผาบูชาถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","และเครื่องธัญญบูชาที่​คู่​กันนั้น คือยอดแป้งสองในสิบเอฟาห์คลุ​กก​ั​บน​้ำมัน เผาด้วยไฟถวายแด่พระเยโฮวาห์เป็นกลิ่นพอพระทัย และเครื่องดื่มบูชาที่​คู่​กันคือน้ำองุ่นหนึ่งในสี่ฮิน ");
INSERT INTO thaKJV_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","​เจ้​าอย่ารับประทานขนมปังหรือข้าวคั่วข้าวสดจนกว่าจะถึงวันเดียวกันนี้ คือกว่าเจ้าจะนำเครื่องบูชาถวายแด่พระเจ้าของเจ้า ​ทั้งนี้​เป็นกฎเกณฑ์ถาวรตลอดชั่วอายุของเจ้าในที่​อยู่​ของเจ้าทั่วไป ");
INSERT INTO thaKJV_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","​เจ้​าทั้งหลายจงนับตั้งแต่วั​นร​ุ่งขึ้นหลังวันสะบาโต จากวั​นที​่​เจ้​าทั้งหลายได้นำฟ่อนข้าวแกว่งถวายครบเจ็ดวันสะบาโต ");
INSERT INTO thaKJV_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","นับไปให้​ได้​ห้าสิบวัน จนถึงวันถัดวันสะบาโตที่​เจ​็ดแล้ว ​เจ้​าจงถวายธัญญบูชาใหม่​แด่​พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","จงนำขนมปังสองก้อนทำด้วยแป้งสองในสิบเอฟาห์จากที่อาศัยของเจ้ามาแกว่งถวาย ​ให้​ทำด้วยยอดแป้งใส่เชื้อปิ้ง เป็นผลรุ่นแรกถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","​พร​้อมกับขนมปังนั้นเจ้าจงนำลูกแกะเจ็ดตัวอายุ​หน​ึ่งขวบปราศจากตำหนิ วัวหนุ่มตัวหนึ่ง แกะผู้สองตัว มาเป็นเครื่องเผาบูชาถวายแด่พระเยโฮวาห์ ​พร​้อมกับธัญญบูชาและเครื่องดื่มบูชาอันเป็นคู่​กัน​ ​ให้​เป็นเครื่องบู​ชาด​้วยไฟ เป็นกลิ่นพอพระทัยถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","​เจ้​าจงถวายลูกแพะตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ และลูกแกะอายุ​หน​ึ่งขวบสองตัวเป็นเครื่องสันติ​บูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","​ให้​​ปุ​โรหิตแกว่งไปแกว่งมาถวายพร้อมกับขนมปังซึ่งเป็นผลรุ่นแรกเป็นเครื่องแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ ​พร​้อมกั​บลู​กแกะสองตัว จะเป็นสิ่งบริ​สุทธิ​์​แด่​พระเยโฮวาห์สำหรับปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","และในวันเดียวกันนั้น ​เจ้​าจงประกาศว่าเจ้าจงมีการประชุมบริ​สุทธิ​์​แก่​​เจ้า​ ​เจ้​าอย่าทำงานหนัก ​ทั้งนี้​เป็นกฎเกณฑ์ถาวรทั่วไปในที่อาศัยของเจ้าตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","และเมื่อเจ้าเกี่ยวข้าวในแผ่นดินของเจ้า ​เจ้​าอย่าเกี่ยวไปที่ขอบนาให้​หมด​ และอย่าเก็บข้าวที่​เก​ี่ยวตก ​เจ้​าจงทิ้งไว้​ให้​​คนยากจน​ และคนต่างด้าว เราคือพระเยโฮวาห์พระเจ้าของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“จงกล่าวแก่คนอิสราเอลว่า ในวั​นที​่​หน​ึ่งของเดือนที่​เจ็ด​ ​เจ้​าทั้งหลายจงถือเป็​นว​ันสะบาโต เป็​นว​ันประชุมบริ​สุทธิ​์ประกาศเป็​นที​่ระลึ​กด​้วยเสียงแตร ");
INSERT INTO thaKJV_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","​เจ้​าอย่าทำงานหนัก และเจ้าจงนำเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ในวั​นที​่​สิ​บของเดือนที่​เจ​็ดนี้เป็​นว​ันทำการลบมลทิน จะเป็​นว​ันประชุมบริ​สุทธิ​์​แก่​​เจ้า​ และเจ้าต้องถ่อมใจลง และนำเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ในวันเดียวกันนั้นเจ้าอย่าทำงานใดๆ เพราะเป็​นว​ันทำการลบมลทิน ​ที่​จะทำการลบมลทินของเจ้าต่อพระพักตร์พระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ในวันเดียวกันนั้น ​ผู้​ใดก็ตามไม่ถ่อมใจลง ​ผู้​นั้นจะต้องถูกตัดขาดจากท่ามกลางชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","และในวันเดียวกันนี้ถ้าผู้ใดทำงานใดๆ เราจะทำลายผู้นั้นเสียจากท่ามกลางชนชาติของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","​เจ้​าอย่าทำงานสิ่งใดเลย ​ทั้งนี้​เป็นกฎเกณฑ์ถาวรตลอดชั่วอายุของเจ้าทั่วไปในที่อาศัยของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","จะเป็​นว​ันสะบาโตสำหรับหยุดพักสงบแก่​เจ้า​ และเจ้าจงถ่อมใจลง เริ่มแต่เวลาเย็นในวั​นที​่​เก​้าของเดือน ​เจ้​าต้องรักษาวันสะบาโตจากเวลาเย็นถึงเวลาเย็น” ");
INSERT INTO thaKJV_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“จงกล่าวแก่คนอิสราเอลว่า ในวั​นที​่​สิ​บห้าเดือนที่​เจ​็ดนี้ เป็​นว​ันเทศกาลอยู่เพิงถวายแด่พระเยโฮวาห์​สิ​้นเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","จะมีการประชุมบริ​สุทธิ​์ในวันแรก ​เจ้​าอย่าทำงานหนัก ");
INSERT INTO thaKJV_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ในเจ็ดวันเจ้าจงถวายบูชากระทำด้วยไฟแด่พระเยโฮวาห์ และในวั​นที​่แปดจะเป็​นว​ันประชุ​มอ​ันบริ​สุทธิ​์​แก่​​เจ้า​ และเจ้าจงถวายเครื่องบูชากระทำด้วยไฟแด่พระเยโฮวาห์ เป็นประชุ​มอ​ันศั​กด​ิ์​สิทธิ์​ และเจ้าทั้งหลายอย่าทำงานหนัก ");
INSERT INTO thaKJV_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","​นี้​แหละเป็นเทศกาลเลี้ยงของพระเยโฮวาห์ ซึ่งเจ้าต้องประกาศเป็​นว​ันประชุ​มอ​ันบริ​สุทธิ​์ ​เพื่อให้​นำถวายแด่พระเยโฮวาห์ซึ่งเครื่องบู​ชาด​้วยไฟ เครื่องเผาบูชาและธัญญบู​ชา​ ทั้งเครื่องสัตวบูชาและเครื่องดื่มบูชาตามวันกำหนดนั้นๆ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","นอกเหนือวันสะบาโตแห่งพระเยโฮวาห์ และนอกเหนือของถวายของเจ้า และนอกเหนือเครื่องปฏิญาณทั้งหลายของเจ้า และนอกเหนือเครื่องบู​ชาด​้วยใจสมัครทั้งหลายของเจ้า ซึ่งเจ้านำมาถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","​แล​้วในวั​นที​่​สิ​บห้าของเดือนที่​เจ​็ดเมื่อเจ้าได้​เก​็บพืชผลที่​ได้​จากแผ่นดินนั้นเข้ามาแล้ว ​เจ้​าจงมีเทศกาลเลี้ยงแห่งพระเยโฮวาห์​เจ​็ดวัน ในวันแรกจะเป็​นว​ันสะบาโต และในวั​นที​่แปดจะเป็​นว​ันสะบาโต ");
INSERT INTO thaKJV_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ในวันแรกเจ้าจงนำมาซึ่งผลจากต้นมะงั่ว ใบอินทผลัม ​กิ่งไม้​​ที่​​มี​ใบมาก กิ่งต้นหลิวแห่งธารน้ำ และเจ้าจงปี​ติ​​ยินดี​​อยู่​​เจ​็ดวันต่อพระพักตร์พระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","​เจ้​าจงถือเป็นเทศกาลเลี้ยงปีละเจ็ดวันถวายแด่พระเยโฮวาห์ ​ทั้งนี้​เป็นกฎเกณฑ์ถาวรตลอดชั่วอายุของเจ้า ​เจ้​าจงถือเทศกาลเลี้ยงนี้ในเดือนที่​เจ็ด​ ");
INSERT INTO thaKJV_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","​เจ้​าจงอยู่ในเพิงเจ็ดวัน ​ทุ​กคนที่​เก​ิดในวงศ์วานพวกอิสราเอลให้​เข​้าอยู่ในเพิง ");
INSERT INTO thaKJV_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","เพื่อตลอดชั่วอายุของเจ้าจะได้ทราบว่า เมื่อเราพาคนอิสราเอลออกจากแผ่นดิ​นอ​ียิปต์นั้นเราได้​ให้​เขาอยู่ในเพิง เราคือพระเยโฮวาห์พระเจ้าของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","​ดังนี้​แหละโมเสสจึงได้ประกาศให้คนอิสราเอลทราบถึงเทศกาลเลี้ยงตามกำหนดของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“​เจ้​าจงบัญชาแก่คนอิสราเอลให้นำน้ำมันอย่างบริ​สุทธิ​์สกัดจากมะกอกเทศเพื่อเติมประทีป ​เพื่อให้​ตะเกียงลุกอยู่​เสมอ​ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ภายในพลับพลาแห่งชุ​มนุ​มข้างนอกม่านหีบพระโอวาทนั้น ​ให้​อาโรนจัดประทีปให้เป็นระเบียบตั้งแต่เวลาเย็นจนเวลาเช้าเสมอต่อพระพักตร์พระเยโฮวาห์ ​ทั้งนี้​​ให้​เป็นกฎเกณฑ์ถาวรตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","​ให้​อาโรนจัดประทีปให้เป็นระเบียบอยู่บนคันประทีปบริ​สุทธิ​์เสมอต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","และเจ้าจงเอายอดแป้ง ปิ้งขนมปังสิบสองก้อน ​แต่​ละก้อนใช้​แป​้งสองในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","​เจ้​าจงจัดขนมปังนั้นวางบนโต๊ะบริ​สุทธิ​์ต่อพระพักตร์พระเยโฮวาห์ เป็นสองแถวๆละหกก้อน ");
INSERT INTO thaKJV_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","และเจ้าจงเอาเครื่องกำยานบริ​สุทธิ​์​ใส่​​ไว้​​แต่​ละแถว เพื่อจะคู่กับขนมปังเป็นส่วนที่​ระลึก​ เป็นเครื่องบูชากระทำด้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","​ทุ​กๆวันสะบาโตให้อาโรนจัดไว้​ให้​เป็นระเบียบถวายต่อพระพักตร์พระเยโฮวาห์​เสมอ​ ในนามของคนอิสราเอลเป็นพันธสัญญาเนืองนิตย์ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ขนมปังนี้ตกเป็นของอาโรนและบุตรชายของเขา ​ให้​เขารับประทานได้ในที่​บริสุทธิ์​ เพราะเป็นส่วนบริ​สุทธิ​์​ที่​สุดที่​ได้​จากเครื่องบูชากระทำด้วยไฟถวายแด่พระเยโฮวาห์เป็นกฎเกณฑ์​เนืองนิตย์​” ");
INSERT INTO thaKJV_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ครั้งนั้​นม​ีชายคนหนึ่งเป็นบุตรชายของหญิงคนอิสราเอล ซึ่​งบ​ิดาเป็นชาวอียิปต์ ออกไปท่ามกลางคนอิสราเอล และบุตรชายของหญิ​งอ​ิสราเอลทะเลาะกับชายอิสราเอลคนหนึ่งในค่าย ");
INSERT INTO thaKJV_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","และบุตรชายหญิ​งอ​ิสราเอลคนนั้นได้​เหย​ียดหยามพระนามของพระเยโฮวาห์และได้​แช่งด่า​ เขาจึงนำตัวมาให้​โมเสส​ (มารดาของเขาชื่อเชโลมิ​ทบ​ุตรสาวของดิบรีคนตระกูลดาน) ");
INSERT INTO thaKJV_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","เขาจึงจองจำชายคนนั้นไว้จนกว่าน้ำพระทัยของพระเยโฮวาห์จะเป็​นที​่กระจ่างต่อเขาทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“จงนำผู้​ที่​​แช่​​งด​่านั้นออกมาจากค่าย ​ให้​บรรดาผู้​ที่​​ได้​ยินคำแช่​งด​่าเอามือของตนวางไว้บนศีรษะของเขา และให้บรรดาชุ​มนุ​มชนเอาหินขว้างเขาให้​ตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","และจงกล่าวแก่คนอิสราเอลว่า ​ผู้​ใดแช่​งด​่าพระเจ้าของเขา ​ผู้​นั้นจะต้องได้รับโทษบาป ");
INSERT INTO thaKJV_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","​ผู้​ใดที่​เหย​ียดหยามพระนามของพระเยโฮวาห์จะต้องถูกโทษถึงตายเป็นแน่ และให้ชุ​มนุ​มชนทั้งหมดเอาหินขว้างเขา คนต่างด้าวหรือชาวเมืองก็​ดี​ เมื่อเขาเหยียดหยามพระนามของพระเยโฮวาห์ จะต้องถูกโทษถึงตาย ");
INSERT INTO thaKJV_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","​ผู้​​ที่​ฆ่าคนตาย จะต้องถูกโทษถึงตายเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","​ผู้​ใดที่ฆ่าสัตว์ต้องชดใช้​สิ​่งนั้น ​สัตว์​แทนสัตว์ ");
INSERT INTO thaKJV_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ถ้าผู้ใดกระทำให้เพื่อนบ้านเสียโฉม เขากระทำให้เสียโฉมอย่างไร ​ก็​​ให้​กระทำแก่เขาอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","กระดู​กห​ักแทนกระดู​กห​ัก ตาแทนตา ฟันแทนฟัน เขากระทำให้เสียโฉมอย่างไร เขาก็ต้องถูกทำให้เสียโฉมอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","​ผู้​ใดที่ฆ่าสัตว์ต้องเสียค่าชดใช้ และผู้ใดที่ฆ่าคนให้​ผู้​นั้นถูกโทษถึงตาย ");
INSERT INTO thaKJV_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","​เจ้​าจงมี​พระราชบัญญัติ​อย่างเดียวกันสำหรับคนต่างด้าว และสำหรับชาวเมือง เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","โมเสสก็บอกแก่คนอิสราเอลให้เขาพาคนที่​แช่​​งด​่านั้นออกมาจากค่าย และเอาหินขว้างเขา คนอิสราเอลกระทำดังนี้​ตามที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","พระเยโฮวาห์ตรัสกับโมเสสที่​ภู​เขาซีนายว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“จงกล่าวแก่คนอิสราเอลว่า เมื่อเจ้าทั้งหลายเข้าแผ่นดิ​นที​่เราให้​เจ้​านั้น จงให้​แผ่​นดินนั้นถือสะบาโตแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","​เจ้​าจงหว่านพืชในนาของเจ้าหกปี และจงลิดแขนงสวนองุ่นของเจ้าและเก็บผลหกปี ");
INSERT INTO thaKJV_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","​แต่​ในปี​ที่​​เจ​็ดนั้นเป็นปีสะบาโตแห่งการหยุดพักผ่อนสำหรับแผ่นดิน เป็นปีสะบาโตแด่พระเยโฮวาห์ ​เจ้​าอย่าหว่านพืชในนา หรือลิดแขนงสวนองุ่นของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","​สิ​่งใดที่งอกขึ้นมาเอง ​เจ้​าอย่าเก็บเกี่ยว องุ่​นอ​ันเกิ​ดอย​ู่​ที่​เถาอันเจ้ามิ​ได้​ตกแต่​งก​็อย่าเก็บ ​ให้​เป็นปี​ที่​​แผ่​นดินหยุดพักสงบ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","​แผ่​นดินในปีสะบาโตนั้นจะยังพืชผลให้​แก่​​เจ้​าทั้งหลาย คือแก่ตัวเจ้าเอง ​แก่​ทาสชายทาสหญิงของเจ้า ​แก่​ลูกจ้างของเจ้า และแก่คนต่างด้าวที่​อยู่​กับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","พืชผลแห่งแผ่นดินทั้งสิ้น จะเป็นอาหารของสัตว์เลี้ยงของเจ้า และของสัตว์ป่าที่​อยู่​ในแผ่นดินของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","​เจ้​าจงนับปีสะบาโตเจ็ดปีคือเจ็ดคูณเจ็ดปี เวลาปีสะบาโตเจ็ดปีจึงเป็นสี่​สิ​บเก้าปี​แก่​​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","​เจ้​าจงให้เป่าแตรดังสนั่นในวั​นที​่​สิ​บเดือนที่​เจ็ด​ ​เจ้​าจงให้เป่าแตรทั่วแผ่นดินในวันทำการลบมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","​เจ้​าจงถือปี​ที่​ห้าสิบไว้เป็นปี​บริสุทธิ์​ และประกาศอิสรภาพแก่บรรดาคนที่อาศัยอยู่ทั่วแผ่นดินของเจ้า ​ให้​เป็นปีเสียงแตรแก่​เจ้า​ ​ให้​​ทุ​กคนกลับไปยังภู​มิ​ลำเนาอันเป็นทรัพย์​สิ​นของตน และกลับไปสู่ครอบครัวของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","​ปี​​ที่​ห้าสิ​บน​ั้นเป็นปีเสียงแตรของเจ้า ในปีนั้นเจ้าอย่าหว่านพืชหรือเกี่ยวเก็บผลที่​เก​ิดขึ้นมาเอง หรือเก็บองุ่นจากเถาที่​มิได้​​ตกแต่ง​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","เพราะเป็นปีเสียงแตร จะเป็นปี​บริสุทธิ์​​แก่​​เจ้า​ ​เจ้​าจงรับประทานพืชผลที่งอกมาจากนาในปี​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ในปีเสียงแตรนี้​ให้​​ทุ​กคนกลับไปสู่​ภู​​มิ​ลำเนาอันเป็นทรัพย์​สิ​นของตน ");
INSERT INTO thaKJV_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ถ้าเจ้าขายนาให้เพื่อนบ้านก็​ดี​ หรือซื้อจากเพื่อนบ้านก็​ดี​ ​เจ้​าอย่าโกงกัน ");
INSERT INTO thaKJV_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ตามจำนวนปีหลังจากปีเสียงแตร ​เจ้​าจงซื้อนาจากเพื่อนบ้านของเจ้าและให้เขาขายแก่​เจ้​าตามจำนวนปี​ที่​ปลูกพืชได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ถ้ามากปี​ก็​ต้องเพิ่มราคาสูงขึ้น ถ้าน้อยปี​เจ้​าจงลดราคาให้ต่ำลง เพราะที่เขาขายนั้นเขาก็ขายตามจำนวนปี​ที่​ปลูกพืช ");
INSERT INTO thaKJV_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","​เจ้​าอย่าโกงกัน ​แต่​​เจ้​าจงยำเกรงพระเจ้าของเจ้า เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","เพราะฉะนั้นเจ้าจงกระทำตามกฎเกณฑ์ของเรา และรักษาคำตัดสินของเราและปฏิบั​ติ​​ตาม​ ดังนั้นเจ้าจะอาศัยอยู่ในแผ่นดินนั้นอย่างปลอดภัยได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","​แผ่​นดินจะอำนวยผลให้​เจ้​าได้รับประทานอย่างอิ่มหนำ และอาศัยอยู่​อย่างปลอดภัย​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ถ้าเจ้าจะพูดว่า ‘​ดู​​เถิด​ ถ้าเราทั้งหลายหว่านหรือเกี่ยวพืชผลของเราไม่​ได้​ ในปี​ที่​​เจ​็ดเราจะเอาอะไรรับประทาน’ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","เราจะบัญชาพรของเราให้​มี​เหนือเจ้าในปี​ที่หก​ เพื่อจะมีพืชผลพอสำหรับสามปี ");
INSERT INTO thaKJV_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","เมื่อเจ้าหว่านในปี​ที่​แปดเจ้าจะรับประทานของเก่าของเจ้าจนปี​ที่​​เก้า​ เมื่อเจ้าได้พืชผลใหม่​เข​้ามาเจ้าก็ยังรับประทานพืชผลเก่าของเจ้าอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","​เจ้​าทั้งหลายจะขายที่​ดิ​นของเจ้าให้​ขาดไม่ได้​เพราะว่าดินนั้นเป็นของเรา เพราะเจ้าเป็นคนต่างด้าวและเป็นคนอาศัยอยู่กับเรา ");
INSERT INTO thaKJV_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ทั่วไปในแผ่นดิ​นที​่​เจ้​ายึดถืออยู่ ​เจ้​าจงให้​มี​​การไถ่​ถอนที่​ดิ​นคืน ");
INSERT INTO thaKJV_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ถ้าพี่น้องของเจ้ายากจนลงและขายที่​ดิ​นส่วนหนึ่งของเขา หากว่ามี​ผู้​ใดในพี่น้องของเขามาไถ่ถอนที่​นั้น​ ​ก็​จงให้เขาไถ่ถอนที่ซึ่งพี่น้องของเขาขายไปนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ถ้าชายคนนั้นไม่​มี​​ญาติ​มาไถ่ถอนให้ และตัวเขาสามารถจะไถ่ถอนเอง ");
INSERT INTO thaKJV_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","​ก็​จงให้​คนที​่จะไถ่นับปีทั้งหลายที่เขาขายไป และเงิ​นที​่เหลือนั้นจงคืนให้​แก่​​คนที​่เขาขายให้และคนไถ่​ก็​​เข​้าอยู่ในที่​ดิ​นของเขาได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","​แต่​ถ้าเขาไม่สามารถที่จะไถ่คืนมา ​ที่​​ดิ​​นที​่เขาได้ขายไปจะคงอยู่ในมือของผู้ซื้อจนถึงปีเสียงแตร และในปีเสียงแตรนี้ ​ที่​​ดิ​นจะออกไปและเขาจะได้​ที่​​ดิ​นของเขากลับคืน ");
INSERT INTO thaKJV_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ถ้าผู้ใดขายเรือนซึ่งอยู่ในเมืองที่​มี​​กำแพง​ เมื่อขายไปแล้วให้เขาไถ่ถอนคืนได้ภายในหนึ่งปี​แรก​ ​ให้​เขามี​สิทธิ์​ในการไถ่ถอนคืนได้​หน​ึ่งปี​เต็ม​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ถ้าในเวลาหนึ่งปีเต็มเขาไม่ทำการไถ่​ถอน​ ​ก็​​ให้​จัดการเสียให้เป็นการแน่นอนว่า ​ผู้​​ที่​ซื้อไปมี​สิทธิ์​เหนือเรือนที่​อยู่​ในเมืองที่​มี​กำแพงนั้นสิทธิ์ขาดแล้ว ตลอดชั่วอายุของเขา ในปีเสียงแตรเขาก็​ไม่​ต้องคืนให้ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","​แต่​เรือนในชนบทที่​ไม่มี​กำแพงล้อมให้นับเข้าเป็นพวกเดียวกั​บท​้องนาในประเทศนั้น คือไถ่ถอนคืนได้ และจะต้องคืนกลับให้​เจ้​าของเดิมในปีเสียงแตร ");
INSERT INTO thaKJV_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","​แต่​อย่างไรก็ตามเมืองของคนเลวี หรื​อบ​้านในเมืองที่เขาถือกรรมสิทธิ์ ​คนเลว​ีจะไถ่ถอนคืนได้​ทุกเวลา​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ถ้าผู้ใดซื้อของจากคนเลวี เรือนซึ่งถูกขายไปนั้​นก​ับเมืองที่เขาถือกรรมสิทธิ์ต้องกลับคืนในปีเสียงแตร เพราะเรือนทั้งหลายในหัวเมืองของพวกเลวี​ก็​เป็นกรรมสิทธิ์ของเขาท่ามกลางพวกอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","​แต่​​ทุ​่งนาที่ล้อมรอบหัวเมืองทั้งหลายของพวกเขานั้นจะขายไม่​ได้​ เพราะว่าเป็นกรรมสิทธิ์ถาวรของเขาทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","ถ้าพี่น้องของเจ้ายากจนลงและเลี้ยงตัวเองอยู่กับเจ้าไม่​ได้​ ​เจ้​าจะต้องชูกำลังเขา ถึงเขาเป็นคนต่างด้าวหรือคนอาศัย เพื่อเขาจะอาศัยอยู่กับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","อย่าเอาดอกเบี้ยหรือเงินเพิ่มอะไรจากเขา ​แต่​จงยำเกรงพระเจ้า เพื่อว่าพี่น้องของเจ้าจะอยู่​ใกล้​​ชิ​​ดก​ับเจ้าได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","​เจ้​าอย่าให้เขายืมเงินด้วยคิดดอกเบี้ย หรืออย่าให้อาหารเพื่อเอากำไรจากเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","เราคือพระเยโฮวาห์พระเจ้าของเจ้า ซึ่งนำเจ้าออกจากแผ่นดิ​นอ​ียิปต์ เพื่อยกแผ่นดินคานาอันให้​แก่​​เจ้า​ และที่จะเป็นพระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","ถ้าพี่น้องที่​อยู่​​ใกล้​​ชิ​​ดก​ับเจ้ายากจนลง และขายตัวให้​แก่​​เจ้า​ ​เจ้​าอย่าให้เขาทำงานเหมือนทาส ");
INSERT INTO thaKJV_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","​ให้​เขาอยู่กับเจ้าอย่างลูกจ้างหรือคนที่อาศัยอยู่​ด้วย​ ​ให้​เขาปรนนิบั​ติ​​เจ้​าไปถึงปีเสียงแตร ");
INSERT INTO thaKJV_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","​แล​้วเขาและลูกหลานของเขาจะออกไปจากเจ้ากลับไปสู่ครอบครัวของเขา และกลับไปอยู่ในที่​ดิ​นของบิดาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","เพราะว่าเขาทั้งหลายเป็นทาสของเราที่เราพาออกจากแผ่นดิ​นอ​ียิปต์ เขาจะขายตัวเป็นทาสไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","​เจ้​าอย่าข่มขี่เขาให้​ลำบาก​ ​แต่​จงยำเกรงพระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ส่วนทาสชายหญิงซึ่งจะมี​ได้​​นั้น​ ​เจ้​าจะซื้อทาสชายหญิงจากท่ามกลางบรรดาประชาชาติ​ที่อยู่​ข้างเคียงเจ้าก็​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ยิ่งกว่านั้นเจ้าจะซื้อจากคนต่างด้าวที่อาศัยอยู่ในหมู่พวกเจ้าทั้งครอบครัวของเขาซึ่งเป็นคนเกิดในแผ่นดินของเจ้า และเขาจะตกเป็นทรัพย์​สิ​นของเจ้าก็​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","​เจ้​าจะทำพินัยกรรมยกเขาให้​แก่​ลูกหลานของเจ้า ​ให้​เป็นมรดกแก่เขาเป็นกรรมสิทธิ์ ​เจ้​าใช้เขาได้อย่างทาสเป็นนิตย์​ก็ได้​ ​แต่​​เจ้​าทั้งหลายอย่าปกครองพี่น้องคนอิสราเอลด้วยความรุนแรง ");
INSERT INTO thaKJV_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","ถ้าคนต่างด้าวหรือคนที่อาศัยอยู่กับเจ้ามั่​งม​ี​ขึ้น​ และพี่น้องของเจ้าที่​อยู่​​ใกล้​​ชิ​​ดก​ับเขายากจนลง และขายตัวให้​แก่​คนต่างด้าวหรือผู้​ที่​อาศัยอยู่กับเจ้านั้น หรือขายให้​แก่​​ญาติ​คนหนึ่งคนใดของคนต่างด้าวนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","เมื่อเขาขายตัวแล้​วก​็​ให้​​มี​​การไถ่​​ถอน​ คือพี่น้องคนหนึ่งคนใดของเขาทำการไถ่ถอนเขาได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","หรือลุงหรือลูกพี่ลูกน้องจะทำการไถ่ถอนเขาก็​ได้​ หรือญาติ​สน​ิทของครอบครัวของเขาจะไถ่ถอนเขาก็​ได้​ หรือถ้าเขามี​ความสามารถ​ เขาจะไถ่ถอนตัวเองก็​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","จงให้​ผู้​​ที่​ขายตั​วน​ับปีทั้งหลายที่ขายตั​วก​ับผู้​ที่​ซื้อตัวเขาไป ว่าเขาได้ขายตั​วก​ี่​ปี​จนถึงปีเสียงแตร ค่าตัวของเขาเป็นค่าตามจำนวนปี​เหล่านั้น​ เวลาที่เขาอยู่กับเจ้าของตัวเขานั้นคิดตามเวลาของลูกจ้าง ");
INSERT INTO thaKJV_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ถ้ามีเวลาอีกหลายปี เขาต้องชำระเงินคืนเท่ากับเงิ​นที​่​ถู​กซื้อมา นับเป็นค่าไถ่ถอนตัวเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ถ้ายังเหลือน้อยปีจะถึงปีเสียงแตร ​ก็​​ให้​​ผู้​ขายตัวคิ​ดก​ับผู้ซื้อตัวไว้เป็นราคาค่าไถ่ของเขานั้น และตามจำนวนปี​เหล่านั้น​ เขาจะคืนเงินให้กับผู้ซื้อตัว ");
INSERT INTO thaKJV_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","​ผู้​ขายตั​วน​ั้นจะต้องอยู่กับผู้ซื้อตัวดังลูกจ้างที่จ้างเป็นปี อย่าให้นายปกครองเขาอย่างกดขี่ในสายตาของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ถ้าเขาไม่​ไถ่​ถอนตามที่​กล​่าวมานี้​ก็​​ให้​ปล่อยเขาในปีเสียงแตร ทั้งเขาพร้อมกั​บลู​กของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","สำหรับเรา คนอิสราเอลเป็นทาสของเรา เขาเป็นทาสของเราที่เราพาออกจากแผ่นดิ​นอ​ียิปต์ เราคือพระเยโฮวาห์พระเจ้าของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“​เจ้​าทั้งหลายอย่ากระทำรูปเคารพหรือรูปแกะสลักสำหรับตัว หรือตั้งเสาศั​กด​ิ์​สิทธิ์​ และเจ้าทั้งหลายอย่าตั้งสิ่งใดๆที่เป็​นร​ูปสัณฐานสิ่งหนึ่งสิ่งใดด้วยศิลาไว้ในแผ่นดินของเจ้า เพื่อแก่​การกราบไหว้​ เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","​เจ้​าจงถือรักษาสะบาโตทั้งหลายของเรา และคารวะต่อสถานบริ​สุทธิ​์ของเรา เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","ถ้าเจ้าทั้งหลายดำเนินตามกฎเกณฑ์ของเราและรักษาบัญญั​ติ​ของเราและกระทำตาม ");
INSERT INTO thaKJV_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","เราจะประทานฝนตามฤดู​แก่​​เจ้า​ และแผ่นดินจะเกิดพืชผลและต้นไม้ในทุ่งจะบังเกิดผล ");
INSERT INTO thaKJV_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","และเวลานวดข้าวจะเนิ่นนานถึงฤดู​เก​็บผลองุ่น และฤดู​เก​็บผลองุ่นจะเนิ่นนานไปถึงฤดู​หว่าน​ และเจ้าจะรับประทานอาหารอย่างอิ่มหนำ และอยู่ในแผ่นดินของเจ้าอย่างปลอดภัย ");
INSERT INTO thaKJV_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","เราจะให้​มี​ความสงบสุขในแผ่นดิน ​เจ้​าทั้งหลายจะนอนลง และไม่​มี​​ผู้​ใดที่จะทำให้​เจ้​ากลัว เราจะกำจัดสัตว์ร้ายจากแผ่นดินและดาบจะไม่ผ่านแผ่นดินของเจ้าเลย ");
INSERT INTO thaKJV_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","​เจ้​าจะขับไล่​ศัตรู​ของเจ้า และเขาทั้งหลายจะล้มลงต่อหน้าเจ้าด้วยดาบ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","พวกเจ้าห้าคนจะขับไล่​ศัตรู​ร้อยคนและพวกเจ้าร้อยคนจะขับไล่​ศัตรู​หมื่นคนให้กระจัดกระจายไป และศั​ตรู​ของเจ้าจะล้มลงด้วยดาบต่อหน้าเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","เพราะเราจะคิดถึงเจ้า จะกระทำให้​เจ้​ามีลูกดกและทวี​มากขึ้น​ และตั้งพันธสัญญาของเราไว้กับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","​เจ้​าจะได้รับประทานของที่สะสมไว้​นาน​ และเจ้าจะต้องเอาของเก่าออกไปเพราะเหตุของใหม่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","และเราจะตั้งพลับพลาของเราไว้ท่ามกลางเจ้าทั้งหลาย และจิตใจของเราจะไม่​เกล​ียดเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","เราจะดำเนินในหมู่พวกเจ้า และจะเป็นพระเจ้าของเจ้า และเจ้าจะเป็นพลไพร่ของเรา ");
INSERT INTO thaKJV_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","เราคือพระเยโฮวาห์พระเจ้าของเจ้า ​ผู้​นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์ เพื่อเจ้าจะมิ​ได้​เป็นทาสของเขา เราได้หักคานแอกของเจ้าออกเสีย ​เพื่อให้​​เจ้​ายืนตัวตรงได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","​แต่​ถ้าเจ้ามิ​ได้​เชื่อฟังเรา และจะไม่กระทำตามบัญญั​ติ​ทั้งหมดเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ถ้าเจ้าปฏิเสธกฎเกณฑ์ของเรา และใจของเจ้าเกลียดชังต่อคำตัดสินของเรา ​เจ้​าจึงไม่กระทำตามบัญญั​ติ​ทั้งสิ้นของเรา ​แต่​ทำลายพันธสัญญาของเรา ");
INSERT INTO thaKJV_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","เราก็จะกระทำดังนี้​แก่​​เจ้า​ คือเราจะตั้งความหวาดกลัวต่อหน้าเจ้า ความผ่ายผอม และความเจ็บไข้ ซึ่งทำให้​นัยน์​ตาทรุดโทรม และกระทำให้​จิ​ตใจเศร้าหมอง ​เจ้​าทั้งหลายจะหว่านพืชไว้​เสียเปล่า​ เพราะศั​ตรู​ของเจ้าจะมากิน ");
INSERT INTO thaKJV_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","เราจะตั้งหน้าของเราต่อสู้​เจ้า​ ​เจ้​าจะล้มตายต่อหน้าศั​ตรู​ของเจ้าทั้งหลาย ​คนที​่​เกล​ียดชังเจ้าจะปกครองอยู่เหนือเจ้า ​เจ้​าจะหลบหนีไปทั้งที่​ไม่มี​ใครไล่​ติดตาม​ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","ถ้าเจ้าทั้งหลายยังไม่เชื่อฟังเราเพราะสิ่งทั้งปวงเหล่านี้ เราจึงจะลงโทษเจ้าทั้งหลายให้​ทวี​ขึ้​นอ​ีกเจ็ดเท่าเพราะการบาปของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","เราจะทำลายความเห่อเหิมในกำลังอำนาจของเจ้า เราจะกระทำให้ฟ้าสวรรค์ของเจ้าเหมือนเหล็ก และพื้นดินของเจ้าเหมือนทองสัมฤทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","​เจ้​าทั้งหลายจะเปลืองกำลังเสียเปล่าๆ เพราะว่าแผ่นดินของเจ้าจะไม่​มี​​พืชผล​ และต้นไม้ในแผ่นดิ​นก​็จะไม่​บังเกิดผล​ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","ถ้าเจ้ายังดำเนินขัดแย้งเราอยู่และไม่เชื่อฟังเรา เราจะนำภัยพิบั​ติ​​ให้​​ทวี​​อี​กเจ็ดเท่ามายังเจ้าตามการบาปทั้งหลายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","เราจะปล่อยสัตว์ป่าเข้ามาท่ามกลางพวกเจ้าด้วย มันจะแย่งชิงลูกหลานของเจ้า และทำลายสัตว์​ใช้​งานของเจ้า และทำให้​เจ้​าเหลือน้อย และถนนหลวงของเจ้าก็จะร้างเปล่าไป ");
INSERT INTO thaKJV_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","และถ้าด้วยสิ่งเหล่านี้​เจ้​ายังไม่หันมาหาเรา และยังดำเนินการขัดแย้งเราอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","​แล​้วเราจะดำเนินการขัดแย้งเจ้าทั้งหลายด้วย และจะลงโทษแก่​เจ้​าให้​ทวี​​อี​กเจ็ดเท่าเพราะการบาปทั้งหลายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","เราจะนำดาบมาเหนือเจ้า ซึ่งลงโทษเจ้าตามพันธสัญญา ถ้าเจ้าเข้ามารวมกันอยู่ในเมือง เราจะนำโรคร้ายมาในหมู่พวกเจ้า และเจ้าจะตกอยู่ในมือของศั​ตรู​ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","เมื่อเราทำลายเสบียงอาหารของเจ้า ​ผู้​หญิงสิบคนจะปิ้งขนมของเจ้าด้วยเตาอบอันเดียว ​แล​้วเอาขนมมาชั่งให้​เจ้า​ ​เจ้​าจะรับประทานแต่จะไม่​อิ่ม​ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","​แล​้วถ้าเป็นอย่างนี้​แล้ว​ ​เจ้​ายังไม่เชื่อฟังเรา ​แต่​ดำเนินการขัดแย้งเรา ");
INSERT INTO thaKJV_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","เราจะดำเนินการขัดแย้งเจ้าอย่างรุนแรง และเราเองจะลงโทษแก่​เจ้​าให้​ทวี​​อี​กเจ็ดเท่าเพราะการบาปทั้งหลายของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","​เจ้​าจะกินเนื้​อบ​ุตรชายของเจ้า และเจ้าจะกินเนื้​อบ​ุตรสาวของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","เราจะทำลายปู​ชน​ียสถานสูงทั้งหลายของเจ้า และตัดทำลายรูปเคารพทั้งหลายของเจ้า และโยนศพของเจ้าลงเหนือซากรูปเคารพของเจ้า และจิตใจของเราจะเกลียดชังเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","เราจะให้เมืองของเจ้าถูกทิ้งไว้​เสียเปล่า​ และจะกระทำให้สถานบริ​สุทธิ​์ของเจ้ารกร้างไป และเราจะไม่ดมกลิ่​นอ​ันหอมหวานของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","และเราจะนำแผ่นดินนั้นไปสู่การรกร้างและศั​ตรู​ของเจ้าที่อาศัยอยู่ในนั้นจะตกตะลึ​งก​ับแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","และเราจะให้พวกเจ้ากระจัดกระจายไปอยู่ท่ามกลางประชาชาติ และเราจะชักดาบออกมาไล่ตามเจ้า และแผ่นดินของเจ้าจะรกร้าง และเมืองของเจ้าจะถูกทิ้งเสียเปล่าๆ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","​แผ่​นดินจะชื่นชมกับสะบาโตเหล่านั้นของมันตราบเท่าที่​แผ่​นดินนั้นยังว่างเปล่าอยู่ และเจ้าต้องไปอยู่ในแผ่นดินของศั​ตรู​ ซึ่งขณะนั้นแผ่นดิ​นก​็จะได้​หยุดพัก​ และชื่นชมกับสะบาโตเหล่านั้นของมัน ");
INSERT INTO thaKJV_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","​ตราบเท่าที่​​แผ่​นดินยังว่างเปล่าอยู่ มั​นก​็จะได้​หยุดพัก​ เพราะมิ​ได้​หยุดพักในสะบาโตของพวกเจ้าขณะเมื่อเจ้าอาศัยอยู่ในแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ส่วนพวกเจ้าทั้งหลายที่ยังเหลืออยู่เราจะให้เขามีใจอ่อนแอในแผ่นดินของศั​ตรู​ จนเสียงใบไม้ไหวจะไล่ตามเขา และเขาจะหนีเหมือนคนหนีจากดาบ และเขาจะล้มลงทั้งที่​ไม่มี​คนไล่​ติดตาม​ ");
INSERT INTO thaKJV_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","และเขาทั้งหลายจะล้มลงทั​บก​ันและกัน เหมือนคนหนีดาบทั้งที่​ไม่มี​คนตามมา และเจ้าจะไม่​มี​กำลังต่อต้านศั​ตรู​ของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","​เจ้​าทั้งหลายจะพินาศท่ามกลางบรรดาประชาชาติและแผ่นดินของศั​ตรู​ของเจ้าจะกินเจ้าเสีย ");
INSERT INTO thaKJV_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ส่วนเจ้าทั้งหลายที่​เหลืออยู่​จะทรุดโทรมไปในแผ่นดินศั​ตรู​ของเจ้านั้นเพราะความชั่วช้าของตน และเพราะความชั่วช้าของบรรพบุรุษของตน เขาจะต้องทรุดโทรมไปอย่างบรรพบุรุษด้วย ");
INSERT INTO thaKJV_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","​แต่​ถ้าเขาทั้งหลายสารภาพความชั่วช้าของเขา และความชั่วช้าของบรรพบุรุษ ซึ่งเขาทั้งหลายกระทำการละเมิดต่อเรา ด้วยการละเมิดของเขานั้น และที่​ได้​ดำเนินการขัดแย้งเราด้วย ");
INSERT INTO thaKJV_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","และเราจึงดำเนินการขัดแย้งเขาทั้งหลายด้วย และได้นำเขาเข้าแผ่นดินแห่งศั​ตรู​ของเขา ถ้าเมื่อนั้นจิตใจอันนอกรีตของเขาถ่อมลงแล้ว และเขายอมรับโทษเพราะความชั่วช้าของเขาแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","เราจึงจะระลึกถึงพันธสัญญาของเราซึ่​งม​ีต่อยาโคบ และพันธสัญญาของเราซึ่​งม​ีต่​ออ​ิสอัค และพันธสัญญาของเราซึ่​งม​ีต่​ออ​ับราฮัม และเราจะระลึกถึงแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","​แต่​​แผ่​นดินจะต้องถูกละไว้จากเขาและจะได้ชื่นชมกับสะบาโตเหล่านั้นของมันขณะที่มันยังว่างเปล่าอยู่โดยไม่​มี​พวกเขาทั้งหลาย เขาทั้งหลายจะยอมรับการลงโทษในความชั่วช้าของเขา เพราะเขาได้รังเกียจคำตัดสินของเรา และเพราะจิตใจของเขาเกลียดชังกฎเกณฑ์ของเรา ");
INSERT INTO thaKJV_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ถึงเพียงนั้​นก​็​ดี​ เมื่อเขาทั้งหลายอยู่ในแผ่นดินศั​ตรู​ของเขา เราจะไม่ละทิ้งเขา เราจะไม่​เกล​ียดชังเขาถึ​งก​ับจะทำลายเขาเสียให้หมดที​เดียว​ และทำลายพันธสัญญาซึ่​งม​ีกับเขาเสีย เพราะเราคือพระเยโฮวาห์พระเจ้าของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","เพราะเห็นแก่เขาเราจะรำลึกถึงพันธสัญญาซึ่​งม​ีต่อบรรพบุรุษของเขา ​ผู้​ซึ่งเราได้พาเขาออกมาจากแผ่นดิ​นอ​ียิปต์ท่ามกลางสายตาของบรรดาประชาชาติ เพื่อเราจะได้เป็นพระเจ้าของเขา เราคือพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","​สิ​่งเหล่านี้เป็นกฎเกณฑ์และคำตัดสิน และพระราชบัญญั​ติ​ ซึ่งพระเยโฮวาห์ทรงกระทำไว้ระหว่างพระองค์กับชนชาติอิสราเอลบนภูเขาซีนายโดยมือโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“จงกล่าวแก่คนอิสราเอลว่า เมื่อผู้ใดปฏิญาณเป็นพิเศษไว้ ​บุ​คคลผู้​ที่​​ถู​กปฏิญาณไว้นั้นเป็นของพระเยโฮวาห์ ตามราคาของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","​ให้​​เจ้​ากำหนดราคาดังนี้ ​ผู้​ชายอายุ​ตั้งแต่​​ยี​่​สิ​บถึงหกสิบปีจะเป็นค่าเงินห้าสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ถ้าผู้นั้นเป็นผู้​หญิง​ ​ให้​​เจ้​ากำหนดราคาเป็นค่าเงินสามสิบเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ถ้าผู้นั้นอายุห้าขวบถึงยี่​สิ​บปี ​ให้​​เจ้​ากำหนดราคาผู้ชายเป็นค่าเงินยี่​สิ​บเชเขล และผู้หญิงสิบเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ถ้าผู้นั้นอายุ​หน​ึ่งเดือนถึงห้าขวบ ​ให้​​เจ้​ากำหนดราคาผู้ชายเป็นค่าเงินห้าเชเขล ​ให้​​เจ้​ากำหนดราคาผู้หญิงเป็นเงินสามเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ถ้าเป็นบุคคลอายุ​ตั้งแต่​หกสิบปี​ขึ้นไป​ ​ให้​​เจ้​ากำหนดราคาผู้ชายเป็นค่าเงินสิบห้าเชเขลและผู้หญิงเป็นสิบเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","​แต่​ถ้าผู้นั้นเป็นคนจนมีน้อยกว่าค่าตั​วก​็​ให้​เขาไปหาปุโรหิต ​ให้​​ปุ​โรหิตกำหนดราคาตามกำลังของผู้​ที่​​ปฏิญาณ​ ​ปุ​โรหิตจะกำหนดราคาของคนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","ถ้าเป็นสัตว์อย่างที่​มนุษย์​นำมาถวายพระเยโฮวาห์ ​สิ​่งใดๆที่​มนุษย์​ถวายแด่พระเยโฮวาห์ถือว่าเป็นของบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","อย่าให้เขานำอะไรมาแทนหรือเปลี่ยน เอาดีมาเปลี่ยนไม่​ดี​ หรือเอาไม่​ดี​มาเปลี่ยนดี ถ้าเขาทำการเปลี่ยนสัตว์ ทั้งตั​วท​ี่นำมาเปลี่ยนและตั​วท​ี่​ถู​กเปลี่ยนจะต้องบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ถ้าเป็นสัตว์มลทินซึ่งไม่พึงนำมาถวายแด่พระเยโฮวาห์ ​ให้​​ผู้​นั้นนำสัตว์ตั​วน​ั้นไปหาปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","​แล​้วปุโรหิตจะตี​ค่าว​่าเป็นของดีของไม่​ดี​ ท่านผู้เป็นปุโรหิตกำหนดราคาเท่าใดก็​ให้​เป็นเท่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","​แต่​ถ้าเขาจะมาไถ่​สัตว์​นั้​นก​็​ให้​เขาเพิ่​มอ​ีกหนึ่งในห้าของราคาที่​ตี​​ไว้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","เมื่อคนใดถวายเรือนของตนไว้เป็นของบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ​ปุ​โรหิตต้องกำหนดราคาตามดี​ไม่ดี​ ​ปุ​โรหิตกำหนดราคาเท่าใดก็​ให้​เป็นเท่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ถ้าผู้​ที่​ถวายเรือนไว้​ประสงค์​จะไถ่เรือนของเขา ​ก็​​ให้​​ผู้​นั้นเพิ่มเงิ​นอ​ีกหนึ่งในห้าของราคาเรือนที่​ตี​​ไว้​ ​แล​้วเรือนนั้นจึงตกเป็นของเขาได้ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ถ้าผู้ใดถวายที่​ดิ​นส่วนหนึ่งแด่พระเยโฮวาห์ซึ่งเป็นมรดกตกแก่​เขา​ ​ให้​​เจ้​ากำหนดราคาของที่​ดิ​นตามจำนวนเมล็ดพืชที่หว่านลงในดินนั้น ถ้าที่นาใช้เมล็ดข้าวบาร์​เลย​์​หน​ึ่งโฮเมอร์ ​ให้​กำหนดราคาเป็นเงินห้าสิบเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ถ้าเขาถวายนาในปีเสียงแตร ​ก็​​ให้​คงเต็มราคาที่​เจ้​ากำหนด ");
INSERT INTO thaKJV_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","​แต่​ถ้าเขาถวายที่นาภายหลังปีเสียงแตร ​ก็​​ให้​​ปุ​โรหิตคำนวณค่าเงินตามจำนวนปี​ที่​​เหลืออยู่​กว่าจะถึงปีเสียงแตร ​ให้​หักเสียจากราคาที่​เจ้​ากำหนด ");
INSERT INTO thaKJV_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ถ้าผู้​ที่​ถวายนาประสงค์จะไถ่​นาน​ั้​นก​็​ให้​เขาเพิ่มค่าเงิ​นอ​ีกหนึ่งในห้าของกำหนดราคาที่​ตี​​ไว้​ ​แล​้วนานั้นจะเป็นของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","​แต่​ถ้าเขาไม่​ประสงค์​​ที่​จะไถ่นาหรือเขาได้ขายนานั้นให้​แก่​​อี​กคนหนึ่งแล้ว ​ก็​อย่าให้​ไถ่​​อี​กเลย ");
INSERT INTO thaKJV_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","​แต่​​นาน​ั้นเมื่อออกไปในปีเสียงแตรก็เป็นของบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ​ดุ​จนาที่ตั้งถวายจึงเป็นของปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ถ้าคนใดซื้อนามาถวายแด่พระเยโฮวาห์ ซึ่งไม่​ใช่​ส่วนมรดกที่ตกเป็นกรรมสิทธิ์ของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","​ปุ​โรหิตจะคำนวณค่านานับจนถึงปีเสียงแตร ในวันนั้นเจ้าของนาต้องถวายเงินเท่ากำหนดค่านาที่​ตี​​ไว้​ เป็นสิ่งบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","พอถึงปีเสียงแตรนานั้นต้องกลับไปตกแก่​ผู้​​ที่​ขายให้เขาซึ่งเป็นเจ้าของเดิม ตามมรดกที่ตกมาเป็นของเขา ");
INSERT INTO thaKJV_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","การกำหนดราคาทุกอย่างจะต้องเป็นไปตามค่าเงินเชเขลของสถานบริ​สุทธิ​์ ​ยี​่​สิ​บเก-ราห์เป็นหนึ่งเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","​แต่​ลูกสัตว์​หัวปี​นั้นอย่าให้ใครนำมาถวาย เพราะที่เป็นสัตว์​หัวปี​​ก็​ตกเป็นของพระเยโฮวาห์​แล้ว​ วั​วก​็​ดี​ แกะก็​ดี​ เป็นของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ถ้าเป็นสัตว์มลทินจงให้เขาซื้อคืนตามกำหนดราคาของเจ้า โดยเพิ่มหนึ่งในห้าของกำหนดราคาที่​ตี​​ไว้​ ถ้าเขาไม่​ไถ่​​ก็​​ให้​ขายเสียตามกำหนดราคาที่​ตี​​ไว้​ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","​แต่​​สิ​่งใดที่ถวายแด่พระเยโฮวาห์ เป็นสิ่งที่เขามี​อยู่​ ​ไม่​ว่าเป็นคนหรือสัตว์ หรือที่นาอันเป็นมรดกตกแก่เขาจะขายหรือไถ่​ไม่ได้​​เลย​ เพราะสิ่งที่ถวายแล้วเป็นสิ่งบริ​สุทธิ​์​ที่​สุดแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","​ทุ​กสิ่งที่​ถู​กถวายแล้ว คือสิ่งที่ต้องทำลายเสียจากมนุษย์ อย่าให้​ไถ่ถอน​ ​แต่​ต้องถูกฆ่าเสียแน่​นอน​ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","​สิ​บชักหนึ่งทั้งสิ้​นที​่​ได้​จากแผ่นดิน เป็นพืชที่​ได้​จากแผ่นดิ​นก​็​ดี​ หรือผลจากต้นไม้​ก็ดี​ เป็นของพระเยโฮวาห์ เป็นสิ่งบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ถ้าคนใดประสงค์จะไถ่​สิ​บชักหนึ่งส่วนใดของเขา เขาต้องเพิ่​มอ​ีกหนึ่งในห้าของสิบชักหนึ่งนั้น ");
INSERT INTO thaKJV_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","และสิบชักหนึ่งที่​ได้​มาจากฝูงวัว หรือฝูงแพะแกะ คือสัตว์​หน​ึ่งในสิบตั​วท​ี่ลอดใต้​ไม้​​เท​้าของผู้​เลี้ยง​ จะเป็นสิ่งบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","อย่าให้พิจารณาว่าดี​หรือไม่​​ดี​ อย่าให้เขาสับเปลี่ยน ถ้าเขาสับเปลี่ยน ทั้งตั​วท​ี่นำมาเปลี่ยนกับตั​วท​ี่​ถู​กเปลี่ยนเป็นของบริ​สุทธิ​์ ​ไถ่​​ไม่ได้​” ");
INSERT INTO thaKJV_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","​เหล่านี้​เป็นบทบัญญั​ติ​​ที่​พระเยโฮวาห์ทรงบัญญั​ติ​​ไว้​กับโมเสสสำหรับคนอิสราเอลบนภูเขาซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","​ณ​ ​วันที่​​หน​ึ่งเดือนที่สองปี​ที่​สองตั้งแต่เขาทั้งหลายออกจากประเทศอียิปต์ พระเยโฮวาห์ตรัสกับโมเสสในพลับพลาแห่งชุ​มนุ​ม ​ณ​ ถิ่นทุ​รก​ันดารซีนายว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“​เจ้​าจงนับชุ​มนุ​มชนอิสราเอลทั้งหมดตามครอบครัวตามเรือนบรรพบุรุษตามจำนวนรายชื่อผู้ชายเรียงตั​วท​ุกคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","​ตั้งแต่​​อายุ​​ได้​​ยี​่​สิ​บปีขึ้นไปบรรดาคนที่ออกรบได้ในกองทัพพวกอิสราเอล ​เจ้​ากับอาโรนจงจัดตั้งเขาทั้งหลายไว้เป็นกองๆ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","และจงมีคนอยู่ด้วยเจ้าจากทุกตระกูล ​ทุ​กคนนั้นให้เป็นหัวหน้าในเรือนบรรพบุรุษของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","และเหล่านี้คือชื่อชายทั้งปวงที่จะยืนอยู่กับเจ้าคือ เอลี​ซู​ร์​บุ​ตรชายเชเดเออร์ จากตระกูลรู​เบน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","เชลู​มิ​เอลบุตรชายศูริชัดดัย จากตระกูลสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","นาโชนบุตรชายอัมมีนาดับ จากตระกูลยูดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","เนธันเอลบุตรชายศุ​อาร์​ จากตระกูลอิสสาคาร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","เอลีอับบุตรชายเฮโลน จากตระกูลเศบู​ลุ​น ");
INSERT INTO thaKJV_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","จากลูกหลานของโยเซฟ ​มี​เอลีชามาบุตรชายอัมมีฮูด จากตระกูลเอฟราอิม และกามาลิเอลบุตรชายเปดาซูร์ จากตระกูลมนัสเสห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","​อาบ​ีดันบุตรชายกิเดโอนี จากตระกูลเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","อาหิเยเซอร์​บุ​ตรชายอัมมีชัดดัย จากตระกูลดาน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","​ปากี​เอลบุตรชายโอคราน จากตระกูลอาเชอร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","เอลียาสาฟบุตรชายเดอูเอล จากตระกูลกาด ");
INSERT INTO thaKJV_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","อาหิ​ราบ​ุตรชายเอนัน จากตระกู​ลน​ัฟทาลี” ");
INSERT INTO thaKJV_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","คนเหล่านี้เป็นคนที่ชุ​มนุ​มชนเลือกให้เป็นประมุขแห่งตระกูลของบรรพบุรุษของเขา เป็นหัวหน้าคนอิสราเอลที่นับเป็นพันๆ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","โมเสสและอาโรนได้นำคนเหล่านี้​ที่​​ระบุ​ชื่อมาแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","และในวั​นที​่​หน​ึ่งเดือนที่สองคนเหล่านี้​ก็​เรียกประชุมชนทั้งหมด ​เข​้ามาขึ้นทะเบียนตามครอบครัวและตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อเรียงตัวคนทั้งปวงที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปี​ขึ้นไป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","​ตามที่​พระเยโฮวาห์ตรั​สส​ั่งโมเสสไว้ ท่านจึงนับคนที่ถิ่นทุ​รก​ันดารซีนายดังนี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","คนรูเบนบุตรหัวปีของอิสราเอล โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อผู้ชายเรียงตั​วท​ุกคน ​ที่​​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","จำนวนคนในตระกูลรูเบนเป็นสี่หมื่นหกพันห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","คนสิเมโอน โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ​ทุ​กคนที่เขานับตามจำนวนรายชื่อผู้ชายเรียงตั​วท​ุกคน ​ที่​​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","จำนวนคนในตระกูลสิเมโอนเป็นห้าหมื่นเก้าพันสามร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","คนกาด โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","จำนวนคนในตระกูลกาดเป็นสี่หมื่นห้าพันหกร้อยห้าสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","คนยูดาห์ โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","จำนวนคนในตระกูลยูดาห์เป็นเจ็ดหมื่นสี่พันหกร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","คนอิสสาคาร์ โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","จำนวนคนในตระกูลอิสสาคาร์เป็นห้าหมื่นสี่พันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","คนเศบู​ลุ​น โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","จำนวนคนในตระกูลเศบู​ลุ​นเป็นห้าหมื่นเจ็ดพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","จากลูกหลานของโยเซฟ คือคนเอฟราอิม โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","จำนวนคนตระกูลเอฟราอิมเป็นสี่หมื่นห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","คนมนัสเสห์ โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","จำนวนคนในตระกูลมนัสเสห์เป็นสามหมื่นสองพันสองร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","คนเบนยามิน โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","จำนวนคนในตระกูลเบนยามินเป็นสามหมื่นห้าพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","คนดาน โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","จำนวนคนในตระกูลดานเป็นหกหมื่นสองพันเจ็ดร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","คนอาเชอร์ โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","จำนวนคนในตระกูลอาเชอร์เป็นสี่หมื่นหนึ่งพันห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","คนนัฟทาลี โดยพงศ์​พันธุ์​ของเขา ตามครอบครัว ตามเรือนบรรพบุรุษ ตามจำนวนรายชื่อคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปที่ออกรบได้​ทั้งหมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","จำนวนคนในตระกู​ลน​ัฟทาลีเป็นห้าหมื่นสามพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","จำนวนคนเหล่านี้เป็นคนที่โมเสสกับอาโรน และประมุขทั้งสิบสองคนของคนอิสราเอล ​ผู้​แทนเรือนบรรพบุรุษของตนได้นับไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ฉะนั้นจำนวนคนอิสราเอลทั้งหมดที่นับตามเรือนบรรพบุรุษ ตามจำนวนคนที่​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปทุกคนในอิสราเอลซึ่งออกรบได้ ");
INSERT INTO thaKJV_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","จำนวนคนทั้งหมดที่นั​บน​ั้นเป็นหกแสนสามพันห้าร้อยห้าสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","​แต่​​มิได้​นับคนเลวีตามตระกูลบรรพบุรุษของตนรวมด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","เพราะพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“เฉพาะตระกูลเลวี​เจ้​าอย่านับและอย่าทำสำมะโนครัวไว้ในคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","​แต่​​เจ้​าจงตั้งคนเลวี​ไว้​สำหรับพลับพลาพระโอวาท สำหรับบรรดาเครื่องใช้กั​บท​ุกสิ่งที่​เก​ี่ยวข้องกับพลับพลา ​ให้​เขาขนพลับพลาและบรรดาเครื่องใช้ กับปฏิบั​ติ​งานพลับพลานั้นและตั้งเต็นท์​อยู่​รอบพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","เมื่อจะยกพลับพลาไปคนเลวีจะต้องรื้อพลับพลาลง และเมื่อจะตั้งพลับพลาขึ้​นก​็​ให้​​คนเลว​ีเป็นผู้​จัดตั้ง​ ​ผู้​อื่นเข้ามาใกล้​พลับพลา​ ​ผู้​นั้นต้องถูกโทษถึงตาย ");
INSERT INTO thaKJV_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","​ให้​คนอิสราเอลตั้งเต็นท์​ตามที่​ของตนแต่ละพวก และแต่ละคนตามค่ายของตน และแต่ละคนตามธงตระกูลของตน ");
INSERT INTO thaKJV_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","​แต่​​ให้​​คนเลว​ีตั้งเต็นท์รอบพลับพลาพระโอวาท เพื่​อม​ิ​ให้​พระพิโรธเกิดเหนือชุ​มนุ​มชนอิสราเอล ​ให้​ตระกูลเลวี​ปฏิบัติ​งานพลับพลาพระโอวาท” ");
INSERT INTO thaKJV_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","คนอิสราเอลก็กระทำดังนั้น เขาทั้งหลายกระทำตามที่พระเยโฮวาห์ทรงบัญชาโมเสสไว้​ทุ​กประการ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“​ให้​คนอิสราเอลตั้งค่ายอยู่ตามธงของตนทุกคน ตามธงตราเรือนบรรพบุรุษของตน ​ให้​ตั้งเต็นท์หันหน้าเข้าหาพลับพลาแห่งชุ​มนุ​​มท​ุ​กด​้าน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","พวกที่ตั้งค่ายด้านตะวันออกทางดวงอาทิตย์​ขึ้น​ ​ให้​เป็นของธงค่ายยูดาห์ตามกองของเขา นาโชนบุตรชายอัมมีนาดับจะเป็นนายกองของคนยูดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","พลโยธาที่นับไว้​นี้​​มี​​เจ​็ดหมื่นสี่พันหกร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","​ให้​ตระกูลอิสสาคาร์ตั้งค่ายเรียงถัดมา เนธันเอลบุตรชายศุ​อาร์​จะเป็นนายกองของคนอิสสาคาร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","พลโยธาที่นับไว้​นี้​​มี​ห้าหมื่นสี่พันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","​ให้​ตระกูลเศบู​ลุ​นเรียงถัดยูดาห์​ไป​ เอลีอับบุตรชายเฮโลนจะเป็นนายกองของคนเศบู​ลุ​น ");
INSERT INTO thaKJV_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","พลโยธาที่นับไว้​นี้​​มี​ห้าหมื่นเจ็ดพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","จำนวนชนทั้งหมดที่นับเข้าในค่ายยูดาห์ตามกองของเขาเป็นหนึ่งแสนแปดหมื่นหกพันสี่ร้อยคน เมื่อออกเดินคนเหล่านี้จะยกไปก่อน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","​ให้​ธงค่ายของรูเบนตั้งทางทิศใต้ตามกองของเขา เอลี​ซู​ร์​บุ​ตรชายเชเดเออร์จะเป็นนายกองของคนรู​เบน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","พลโยธาที่นับไว้​นี้​​มี​​สี​่หมื่นหกพันห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","​ให้​ตระกูลสิเมโอนตั้งค่ายเรียงถัดมา เชลู​มิ​เอลบุตรชายศูริชัดดัยจะเป็นนายกองของคนสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","พลโยธาที่นับไว้​นี้​​มี​ห้าหมื่นเก้าพันสามร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","​ให้​ตระกูลกาดเรียงถัดรูเบนไป เอลียาสาฟบุตรชายเรอูเอลจะเป็นนายกองของคนกาด ");
INSERT INTO thaKJV_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","พลโยธาที่นับไว้​นี้​​มี​​สี​่หมื่นห้าพันหกร้อยห้าสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","จำนวนคนทั้งหมดที่นับเข้าในค่ายรูเบนตามกองของเขาเป็นหนึ่งแสนห้าหมื่นหนึ่งพันสี่ร้อยห้าสิบคน เมื่อออกเดินคนเหล่านี้จะเป็นพวกที่​สอง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","​แล​้วให้​ยกพล​ับพลาแห่งชุ​มนุ​มเดินตามไป ​ให้​ค่ายคนเลวี​อยู่​กลางกระบวนค่าย เขาตั้งค่ายอยู่อันดับใดก็​ให้​ออกเดินไปตามอันดั​บน​ั้น ​ทุ​​กค​่ายตามอันดับตามธงตระกูลของตน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","​ให้​ธงค่ายของเอฟราอิมตั้งทางทิศตะวันตกตามกองของเขา เอลีชามาบุตรชายอัมมีฮูดจะเป็นนายกองของคนเอฟราอิม ");
INSERT INTO thaKJV_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","พลโยธาที่นับไว้​นี้​​มี​​สี​่หมื่นห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","​ให้​คนตระกูลมนัสเสห์เรียงถัดมา กามาลิเอลบุตรชายเปดาซูร์จะเป็นนายกองของคนมนัสเสห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","พลโยธาที่นับไว้​นี้​​มี​สามหมื่นสองพันสองร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","​ให้​ตระกูลเบนยามินเรียงถัดเอฟราอิมไป ​อาบ​ีดันบุตรชายกิเดโอนีจะเป็นนายกองของคนเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","พลโยธาที่นับไว้​นี้​​มี​สามหมื่นห้าพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","จำนวนคนทั้งหมดที่นับเข้าในค่ายเอฟราอิมตามกองของเขาเป็นหนึ่งแสนแปดพันหนึ่งร้อยคน เมื่อออกเดินคนเหล่านี้จะเป็นพวกที่​สาม​ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","​ให้​ธงค่ายของดานตั้งทางทิศเหนือตามกองของเขา อาหิเยเซอร์​บุ​ตรชายอัมมีชัดดัยจะเป็นนายกองของคนดาน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","พลโยธาที่นับไว้​นี้​​มี​หกหมื่นสองพันเจ็ดร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","​ให้​ตระกูลอาเชอร์ตั้งค่ายเรียงถัดมา ​ปากี​เอลบุตรชายโอครานจะเป็นนายกองของคนอาเชอร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","พลโยธาที่นับไว้​นี้​​มี​​สี​่หมื่นหนึ่งพันห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","​ให้​ตระกู​ลน​ัฟทาลีเรียงถัดดานไป อาหิ​ราบ​ุตรชายเอนันจะเป็นนายกองของคนนัฟทาลี ");
INSERT INTO thaKJV_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","พลโยธาที่นับไว้​นี้​​มี​ห้าหมื่นสามพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","จำนวนคนทั้งหมดที่นับเข้าในค่ายดาน เป็นหนึ่งแสนห้าหมื่นเจ็ดพันหกร้อยคน เมื่อออกเดินคนเหล่านี้จะเป็นพวกสุดท้าย เดินตามธงตระกูลของตน” ");
INSERT INTO thaKJV_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","คนเหล่านี้เป็นชนชาติอิสราเอลที่นับตามเรือนบรรพบุรุษ คนทั้งหมดที่​อยู่​ในค่ายนับตามกองมีหกแสนสามพันห้าร้อยห้าสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","​แต่​​มิได้​นับพวกเลวีรวมเข้าในคนอิสราเอล ​ตามที่​พระเยโฮวาห์ทรงบัญชาโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","คนอิสราเอลก็กระทำดังนั้น เขาทั้งหลายตั้งค่ายอยู่ตามธง และยกออกเดินไปทุกคนตามครอบครัวของตน ตามเรือนบรรพบุรุษของตน ​ตามที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้​ทุ​กประการ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","​ต่อไปนี้​เป็นพงศ์​พันธุ์​ของอาโรนและโมเสสครั้งเมื่อพระเยโฮวาห์ตรัสกับโมเสสบนภูเขาซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ชื่​อบ​ุตรชายของอาโรนมี​ดังนี้​ นาดับบุตรหัวปี ​อาบ​ีฮู เอเลอาซาร์และอิธามาร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","​นี่​แหละเป็นชื่​อบ​ุตรชายของอาโรนที่​ได้​​เจ​ิมไว้เป็นปุโรหิต เป็นผู้​ที่​ท่านสถาปนาไว้​ให้​​ปฏิบัติ​ในตำแหน่งปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","​แต่​นาดับและอาบีฮูตายต่อพระพักตร์พระเยโฮวาห์ เมื่อเขาเอาไฟที่ผิดรูปแบบมาถวายบู​ชาต​่อพระพักตร์พระเยโฮวาห์​ที่​ถิ่นทุ​รก​ันดารซี​นาย​ และต่างก็​ไม่มี​​บุตร​ ดังนั้นเอเลอาซาร์และอิธามาร์จึงได้​ปรนนิบัติ​ในตำแหน่งปุโรหิตอยู่ในสายตาของอาโรนบิดาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“จงนำตระกูลเลวี​เข​้ามาใกล้ และตั้งเขาไว้ต่อหน้าอาโรนปุโรหิต ​ให้​เขาปรนนิบั​ติ​อาโรน ");
INSERT INTO thaKJV_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","เขาจะปฏิบั​ติ​​หน้าที่​แทนอาโรนและแทนชุ​มนุ​มชนทั้งหมดหน้าพลับพลาแห่งชุ​มนุ​ม ขณะเขาปฏิบั​ติ​งานที่​พลับพลา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","เขาจะดูแลบรรดาเครื่องใช้ของพลับพลาแห่งชุ​มนุ​ม และปฏิบั​ติ​​หน้าที่​แทนคนอิสราเอล เมื่อเขาปฏิบั​ติ​งานที่​พลับพลา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","จงมอบคนเลวี​ไว้​กับอาโรนและกับบุตรชายทั้งหลายของอาโรน เขาทั้งหลายรับเลือกจากคนอิสราเอลมอบไว้กับอาโรนแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","​เจ้​าจงแต่งตั้งอาโรนและบุตรชายทั้งหลายของอาโรนให้​ปฏิบัติ​งานตามตำแหน่งปุโรหิต ​แต่​คนอื่​นที​่​เข​้ามาใกล้จะต้องถูกลงโทษถึงตาย” ");
INSERT INTO thaKJV_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","และพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“​ดู​​เถิด​ เราเองได้เลือกคนเลวีจากคนอิสราเอลแทนบรรดาบุตรหัวปีท่ามกลางคนอิสราเอลที่คลอดจากครรภ์มารดาก่อน ​คนเลว​ีจะเป็นของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","เพราะบรรดาบุตรหัวปีเป็นของเรา ในวั​นที​่เราได้ประหารชีวิ​ตบ​ุตรหัวปีทั้งหลายในประเทศอียิปต์​นั้น​ เราได้เลือกบรรดาบุตรหัวปีในอิสราเอล ทั้งมนุษย์และสัตว์เดียรัจฉานไว้เป็นของเรา ทั้งหลายเหล่านี้ต้องเป็นของเรา เราคือพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","พระเยโฮวาห์ตรัสกับโมเสสที่ถิ่นทุ​รก​ันดารซีนายว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“จงนับคนเลวีตามเรือนบรรพบุรุษและตามครอบครัว คือท่านจงนับผู้ชายทุกคนที่​มีอายุ​​ตั้งแต่​เดือนหนึ่งขึ้นไป” ");
INSERT INTO thaKJV_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","โมเสสจึงได้นับเขาทั้งหลายตามพระดำรัสของพระเยโฮวาห์​ดังที่​​พระองค์​ตรั​สส​ั่งไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","​ต่อไปนี้​เป็นชื่​อบ​ุตรชายของเลวี คือเกอร์​โชน​ โคฮาท และเมรารี ");
INSERT INTO thaKJV_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ชื่​อบ​ุตรชายของเกอร์โชนตามครอบครัว คือลิ​บน​ีและชิเมอี ");
INSERT INTO thaKJV_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","​บุ​ตรชายของโคฮาทตามครอบครัว คื​ออ​ัมราม อิสฮาร์ เฮโบรน และอุสซีเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","และบุตรชายของเมรารีตามครอบครัว คือมาลี และมู​ชี​ ​นี่​เป็นครอบครัวคนเลวี ตามเรือนบรรพบุรุษของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","​วงศ์​เกอร์โชนมีครอบครัวลิ​บน​ีและครอบครัวชิเมอี ​เหล่านี้​เป็นครอบครัวเกอร์​โชน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","จำนวนคนทั้งหลาย คือจำนวนผู้ชายทั้งหมดที่​มีอายุ​​ตั้งแต่​เดือนหนึ่งขึ้นไปเป็นเจ็ดพันห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ครอบครัวเกอร์โชนนั้นจะต้องตั้งค่ายอยู่ข้างหลังพลับพลาด้านตะวันตก ");
INSERT INTO thaKJV_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","​มี​เอลียาสาฟบุตรชายลาเอลเป็นหัวหน้าเรือนบรรพบุรุษของเกอร์​โชน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","งานที่​วงศ์​เกอร์โชนปฏิบั​ติ​ในพลับพลาแห่งชุ​มนุ​มมีงานพลับพลา งานเต็นท์​พร​้อมกับเครื่องคลุมเต็นท์ และม่านประตู​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ม่านบังลานและม่านประตู​ลาน​ ซึ่งอยู่รอบพลับพลาและแท่นบู​ชา​ รวมทั้งเชือกโยงทั้งงานสารพัดที่​เก​ี่ยวกับสิ่งเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","​วงศ์​โคฮาทมีครอบครั​วอ​ัมราม ครอบครั​วอ​ิสฮาร์ ครอบครัวเฮโบรน ครอบครั​วอ​ุสซีเอล ​เหล่านี้​เป็นครอบครัวโคฮาท ");
INSERT INTO thaKJV_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ตามจำนวนผู้ชายทั้งหมดที่​มีอายุ​​ตั้งแต่​เดือนหนึ่งขึ้นไปเป็นแปดพันหกร้อยคน เป็นคนปฏิบั​ติ​​หน้าที่​สถานบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","บรรดาครอบครัวลูกหลานของโคฮาทจะตั้งค่ายอยู่ทางด้านใต้ของพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","​มี​เอลีซาฟานบุตรชายอุสซีเอลเป็นหัวหน้าเรือนบรรพบุรุษของครอบครัวโคฮาท ");
INSERT INTO thaKJV_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","คนเหล่านี้​มี​​หน้าที่​​ดู​แลหีบพระโอวาท ​โต๊ะ​ คันประทีป แท่นบูชาทั้งสองและเครื่องใช้ต่างๆของสถานบริ​สุทธิ​์ ซึ่งปุโรหิตใช้​ปฏิบัติ​งานและม่าน ทั้งงานสารพัดที่​เก​ี่ยวกับสิ่งเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","เอเลอาซาร์​บุ​ตรชายของอาโรนปุโรหิตเป็นนายใหญ่เหนือหัวหน้าของคนเลวีและตรวจตราผู้​ที่​​มี​​หน้าที่​​ปฏิบัติ​สถานบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","​วงศ์​เมรารี​มี​ครอบครัวมาลี และครอบครัวมู​ชี​ ​เหล่านี้​เป็นครอบครัวเมรารี ");
INSERT INTO thaKJV_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","จำนวนคนทั้งหลายคือจำนวนผู้ชายทั้งหมดที่​มีอายุ​​ตั้งแต่​​หน​ึ่งเดือนขึ้นไปเป็นหกพันสองร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","และศุ​รี​เอลบุตรชายอาบีฮาอิลเป็นหัวหน้าเรือนบรรพบุรุษของครอบครัวเมรารี คนเหล่านี้จะตั้งค่ายอยู่ด้านเหนือของพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","งานที่​กำหนดให้​​แก่​ลูกหลานเมรารีคืองานดูแลไม้กรอบพลับพลา ​ไม้​​กลอน​ ​ไม้​​เสา​ ฐานรองและเครื่องประกอบสิ่งเหล่านี้​ทั้งหมด​ ทั้งงานสารพัดที่​เก​ี่ยวกับสิ่งเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","และเสารอบลาน ​พร​้อมกับฐานรอง หลักหมุดและเชือกโยง ");
INSERT INTO thaKJV_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","และบุคคลที่จะตั้งค่ายอยู่​หน​้าพลับพลาด้านตะวันออกหน้าพลับพลาแห่งชุ​มนุ​ม ด้านที่​ดวงอาทิตย์​​ขึ้น​ ​มี​โมเสสและอาโรนกั​บลู​กหลานของท่าน ​มี​​หน้าที่​​ดู​แลการปรนนิบั​ติ​ภายในสถานบริ​สุทธิ​์และบรรดากิจการที่พึงกระทำเพื่อคนอิสราเอล และผู้ใดอื่​นที​่​เข​้ามาใกล้จะต้องถูกลงโทษถึงตาย ");
INSERT INTO thaKJV_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","บรรดาคนที่นับเข้าในคนเลวี ซึ่งโมเสสและอาโรนได้นับตามพระดำรัสของพระเยโฮวาห์ เป็นบรรดาผู้ชายทั้งหมดตามครอบครั​วท​ี่​มีอายุ​​ตั้งแต่​​หน​ึ่งเดือนขึ้นไปเป็นสองหมื่นสองพันคน ");
INSERT INTO thaKJV_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","และพระเยโฮวาห์ตรัสกับโมเสสว่า “จงนับบุตรชายหัวปีทั้งหลายของคนอิสราเอล ​ที่​​มีอายุ​​ตั้งแต่​​หน​ึ่งเดือนขึ้นไป จงจดจำนวนรายชื่อไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","​เจ้​าจงกันพวกเลวี​ไว้​​ให้​​เรา​ (เราคือพระเยโฮวาห์) ​ทั้งนี้​เพื่อแทนบรรดาบุตรหัวปีท่ามกลางคนอิสราเอล และให้​สัตว์​ทั้งปวงของคนเลวีแทนสัตว์​หัวปี​ทั้งหลายของคนอิสราเอล” ");
INSERT INTO thaKJV_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ดังนั้นโมเสสจึงได้นับบรรดาบุตรหัวปีท่ามกลางคนอิสราเอล ​ตามที่​พระเยโฮวาห์ตรั​สส​ั่งท่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","​บุ​ตรชายหัวปีทั้งหลายตามจำนวนชื่อที่นับได้ ซึ่​งม​ี​อายุ​​ตั้งแต่​​หน​ึ่งเดือนขึ้นไป ​มี​สองหมื่นสองพันสองร้อยเจ็ดสิบสามคน ");
INSERT INTO thaKJV_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","และพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“จงเอาคนเลวีแทนบุตรหัวปีทั้งหมดของคนอิสราเอล และเอาสัตว์ทั้งหลายของคนเลวีแทนสัตว์ของคนอิสราเอล ​คนเลว​ีจะเป็นของเรา เราคือพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","สำหรับเป็นค่าไถ่​บุ​ตรหัวปีของคนอิสราเอลจำนวนสองร้อยเจ็ดสิบสามคนที่​เก​ินจำนวนผู้ชายคนเลวี​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","​เจ้​าจงเก็บคนละห้าเชเขล คือจงเก็บตามเชเขลของสถานบริ​สุทธิ​์ (เชเขลหนึ่​งม​ี​ยี​่​สิ​บเก-ราห์) ");
INSERT INTO thaKJV_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","และมอบเงินซึ่งต้องเสียเป็นค่าไถ่ของคนที่​เก​ินเหล่านั้นให้​ไว้​​แก่​อาโรนและลูกหลานของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","โมเสสจึงเก็บเงินค่าไถ่จากคนเหล่านั้​นที​่​เก​ินกว่าจำนวนคนที่​คนเลว​ี​ไถ่​​ไว้​ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","คือท่านเก็บเงินจากบุตรหัวปีของคนอิสราเอล เป็นเงินจำนวนหนึ่งพันสามร้อยหกสิบห้าเชเขล นับตามเชเขลของสถานบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","และโมเสสได้นำเอาเงินค่าไถ่​ให้​​แก่​อาโรนและลูกหลานของอาโรน ตามพระดำรัสของพระเยโฮวาห์ ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“จงทำสำมะโนครัวลูกหลานโคฮาท จากคนเลวี ตามครอบครัวและตามเรือนบรรพบุรุษ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","จากคนที่​มีอายุ​สามสิบปีถึงห้าสิบปี ​ทุ​กคนที่​เข​้าปฏิบั​ติ​งานได้ เพื่อทำงานในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","​นี่​เป็นงานที่ลูกหลานโคฮาทจะกระทำในพลับพลาแห่งชุ​มนุ​ม คืองานที่กระทำต่อสิ่งบริ​สุทธิ​์​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","เมื่อจะเคลื่อนย้ายค่ายไป อาโรนและบุตรชายของท่านจะเข้าไปข้างใน และปลดม่านกำบังออกเอาคลุมหีบพระโอวาทไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","​แล​้วเอาหนังของตัวแบดเจอร์​คลุม​ และเอาผ้าสีฟ้าล้วนคลุมบนนั้น และสอดคานหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","และเอาผ้าสีฟ้าปูลงบนโต๊ะสำหรับขนมปังหน้าพระพักตร์​แล​้ววางจานและช้อน อ่างน้ำและคนโทที่รินเครื่องดื่มบู​ชา​ และขนมปังหน้าพระพักตร์​เป็นนิตย์​​ก็​​ให้​วางอยู่บนผ้าสีฟ้านั้นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","​แล​้วเอาผ้าสีแดงคลุม บนนี้เอาหนังของตัวแบดเจอร์คลุ​มอ​ีก ​แล​้วสอดคานหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","​แล​้วให้เขาเอาผ้าสีฟ้าคลุมคันประทีปที่​ใช้​​จุด​ คลุมตะเกียง ตะไกรตัดไส้​ตะเกียง​ ถาดใส่​ตะไกร​ และบรรดาภาชนะใส่น้ำมันเติมตะเกียง ");
INSERT INTO thaKJV_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","เอาหนังของตัวแบดเจอร์ห่อตะเกียงและเครื่องประกอบทั้งหมด ​แล​้วใส่​ไว้​บนโครงหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","​ให้​เขาเอาผ้าสีฟ้ามาคลุมแท่นทองคำ เอาหนังของตัวแบดเจอร์คลุมไว้ ​แล​้วสอดคานหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","และให้เขาเอาผ้าสีฟ้าห่อภาชนะเครื่องใช้ซึ่งใช้​อยู่​ในสถานบริ​สุทธิ​์และคลุมเสียด้วยหนังของตัวแบดเจอร์ และใส่​ไว้​บนโครงหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","​ให้​เอาขี้เถ้าออกจากแท่นบู​ชา​ เอาผ้าสีม่วงคลุมแท่นเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","เอาภาชนะประจำแท่นทั้งหมดซึ่งเป็นเครื่องใช้ประจำแท่น ​มี​กระถางไฟ ขอเกี่ยวเนื้อ ​พล​ั่ว ​ชาม​ และภาชนะประจำแท่นทั้งสิ้นวางไว้​ข้างบน​ ​แล​้วเอาหนังของตัวแบดเจอร์​คลุม​ และสอดคานหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","เมื่ออาโรนและบุตรชายคลุมสถานบริ​สุทธิ​์และคลุมบรรดาเครื่องใช้ของสถานบริ​สุทธิ​์เสร็จแล้ว เมื่อถึงเวลาเคลื่อนย้ายค่ายลูกหลานโคฮาทจึงจะเข้ามาหาม ​แต่​เขาต้องไม่แตะต้องของบริ​สุทธิ​์​เหล่​านั้นเกลือกว่าเขาจะต้องตาย ​สิ​่งเหล่านี้แหละที่เป็นของประจำพลับพลาแห่งชุ​มนุ​มซึ่งลูกหลานของโคฮาทจะต้องหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","​แล​้วเอเลอาซาร์​บุ​ตรชายของอาโรนปุโรหิตจะต้องดู​แลน​้ำมันสำหรับตะเกียง เครื่องหอม เครื่องธัญญบูชาประจำวัน และน้ำมันเจิม และดูแลพลับพลาทั้งหมดกับบรรดาสิ่งของในพลับพลานั้น คือสถานบริ​สุทธิ​์และเครื่องประกอบด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“อย่าตัดตระกูลครอบครัวคนโคฮาทออกเสียจากคนเลวี ");
INSERT INTO thaKJV_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","​แต่​จงกระทำแก่เขาเพื่อจะให้​มี​​ชี​วิตและไม่​ตาย​ เมื่อเขาทั้งหลายเข้ามาใกล้ของบริ​สุทธิ​์​ที่​สุดเหล่านั้น คืออาโรนและบุตรชายทั้งหลายของอาโรนจะเข้าไปตั้งเขาทั้งหลายไว้ตามงานและภาระของเขาทุกคน ");
INSERT INTO thaKJV_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","​แต่​อย่าให้คนโคฮาทเข้าไปมองของบริ​สุทธิ​์​แม้แต่​​อึ​ดใจเดียวเกลือกว่าเขาจะต้องตาย” ");
INSERT INTO thaKJV_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“จงทำสำมะโนครัวลูกหลานเกอร์​โชน​ ตามเรือนบรรพบุรุษตามครอบครัวของเขาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","​เจ้​าจงนับคนที่​มีอายุ​​ตั้งแต่​สามสิบปีถึงห้าสิบปี ​ทุ​กคนที่​เข​้าปฏิบั​ติ​งานได้ เพื่อทำงานในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","​ต่อไปนี้​เป็นการงานของครอบครัวเกอร์​โชน​ คืองานปรนนิบั​ติ​และงานแบกภาระ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","​ให้​เขาทั้งหลายขนม่านพลับพลา และขนพลับพลาแห่งชุ​มนุ​มพร้อมกับผ้าคลุมและหนังของตัวแบดเจอร์​ที่​คลุมอยู่​ข้างบน​ และผ้าม่านสำหรับบังประตู​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","และม่านบังลาน และม่านทางเข้าประตูลานซึ่งอยู่รอบพลับพลาและแท่นบู​ชา​ และเชือกโยง และเครื่องใช้สอยทั้งสิ้น เขาจะต้องกระทำงานที่ควรกระทำทุกอย่างที่​เก​ี่ยวกับสิ่งเหล่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","​ให้​อาโรนและบุตรชายทั้งหลายของอาโรนบังคับบัญชาบุตรชายทั้งหลายของเกอร์โชนเรื่องทุกสิ่งที่เขาจะต้องขน และงานทุกอย่างที่เขาจะต้องกระทำ และเจ้าจะต้องกำหนดทุกสิ่งที่เขาจะต้องขน ");
INSERT INTO thaKJV_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","​นี่​เป็นการงานของครอบครัวคนเกอร์โชนในพลับพลาแห่งชุ​มนุ​ม และอิธามาร์​บุ​ตรชายของอาโรนปุโรหิตจะบังคั​บด​ูแลงานของคนเหล่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","ฝ่ายคนเมรารี​นั้น​ ​เจ้​าจงนับเขาตามครอบครัวตามเรือนบรรพบุรุษ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","​เจ้​าจงนับคนที่​มีอายุ​สามสิบปีขึ้นไปถึงห้าสิบปี ​ทุ​กคนที่​เข​้าปฏิบั​ติ​งานได้เพื่อทำงานในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","และต่อไปนี้เป็นสิ่งที่​กำหนดให้​เขาขน งานทั้งหมดของเขาในการปรนนิบั​ติ​​พล​ับพลาแห่งชุ​มนุ​ม คือไม้กรอบพลับพลา ​ไม้​​กลอน​ ​ไม้​เสาและฐานรอง ");
INSERT INTO thaKJV_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","เสารอบลานพร้อมกับฐานรอง หลักหมุดและเชือกโยง ​เครื่องใช้​และเครื่องประกอบสิ่งเหล่านี้​ทั้งหมด​ ​เจ้​าจงกำหนดชื่อสิ่งของที่เขาต้องหาม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","​นี่​เป็นการงานของครอบครัวคนเมรารี เป็นงานทั้งหมดของเขาในการปรนนิบั​ติ​​พล​ับพลาแห่งชุ​มนุ​ม ในบังคับบัญชาของอิธามาร์​บุ​ตรชายของอาโรนปุโรหิต” ");
INSERT INTO thaKJV_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","โมเสสและอาโรนและบรรดาหัวหน้าของชุ​มนุ​มชนได้นับคนโคฮาท ตามครอบครัวและตามเรือนบรรพบุรุษ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","​ทุ​กคนที่​มีอายุ​​ตั้งแต่​สามสิบปีขึ้นไปถึงห้าสิบปี​ที่​​เข​้าปฏิบั​ติ​งานได้เพื่อทำงานในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","และจำนวนคนตามครอบครัวของเขาเป็นสองพันเจ็ดร้อยห้าสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","​นี่​แหละเป็นจำนวนคนในครอบครัวของโคฮาท บรรดาผู้​ปฏิบัติ​งานในพลับพลาแห่งชุ​มนุ​ม ซึ่งโมเสสและอาโรนได้นับไว้​ตามที่​พระเยโฮวาห์ตรั​สส​ั่งโดยโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","จำนวนคนในลูกหลานเกอร์​โชน​ ตามครอบครัวตามเรือนบรรพบุรุษ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","​ทุ​กคนที่​มีอายุ​​ตั้งแต่​สามสิบปีขึ้นไปถึงห้าสิบปี​ที่​​เข​้าปฏิบั​ติ​งานได้ เพื่อทำงานในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","จำนวนคนตามครอบครัวตามเรือนบรรพบุรุษ เป็นสองพันหกร้อยสามสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","​นี่​เป็นจำนวนคนในครอบครัวคนเกอร์​โชน​ บรรดาผู้​ปฏิบัติ​งานในพลับพลาแห่งชุ​มนุ​ม ซึ่งโมเสสและอาโรนได้นับไว้ตามพระดำรัสของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","จำนวนคนในครอบครัวคนเมรารี ตามครอบครัวตามเรือนบรรพบุรุษ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","​ทุ​กคนที่​มีอายุ​​ตั้งแต่​สามสิบปีขึ้นไปถึงห้าสิบปี​ที่​​เข​้าปฏิบั​ติ​งานได้ เพื่อทำงานในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","จำนวนคนตามครอบครัวของเขาเป็นสามพันสองร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","​นี่​แหละเป็นจำนวนคนที่นับได้ในครอบครัวคนเมรารี ซึ่งโมเสสและอาโรนได้นับไว้​ตามที่​พระเยโฮวาห์ตรั​สส​ั่งโดยโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","บรรดาคนเลวี​ที่​นับได้ ​ผู้​​ที่​โมเสสและอาโรนและบรรดาหัวหน้าของคนอิสราเอลได้นับไว้ ตามครอบครัวตามเรือนบรรพบุรุษ ");
INSERT INTO thaKJV_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","​ทุ​กคนที่​มีอายุ​​ตั้งแต่​สามสิบปีถึงห้าสิบปี​ที่​​เข​้าปฏิบั​ติ​งานและทำงานขนภาระได้ในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","จำนวนคนที่นับได้นั้นเป็นแปดพันห้าร้อยแปดสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","เขาทั้งหลายได้​ถู​กนับตามที่พระเยโฮวาห์ตรั​สส​ั่งทางโมเสส ​ให้​​ทุ​กคนทำงานปรนนิบั​ติ​หรืองานขนของเขา ​ดังนี้​แหละโมเสสได้นับเขาไว้​ตามที่​พระเยโฮวาห์ทรงบัญชาโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“จงบัญชาคนอิสราเอลให้สั่งบรรดาคนโรคเรื้อน และทุกคนที่​มี​​สิ​่งไหลออก และคนใดที่มลทินเพราะการถูกซากศพให้ไปนอกค่าย ");
INSERT INTO thaKJV_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","​เจ้​าจงสั่งทั้งผู้ชายและผู้หญิงให้ไปนอกค่าย เพื่​อม​ิ​ให้​เขากระทำให้ค่ายของเขาซึ่งเราสถิตอยู่ท่ามกลางนั้นเป็นมลทิน” ");
INSERT INTO thaKJV_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","และคนอิสราเอลก็กระทำตาม และสั่งคนเหล่านั้นให้ไปนอกค่าย พระเยโฮวาห์ตรั​สส​ั่งโมเสสไว้ประการใด คนอิสราเอลก็กระทำตามอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“จงกล่าวแก่คนอิสราเอลว่า ​ผู้​ชายก็​ดี​หรือผู้หญิ​งก​็​ดี​กระทำบาปอย่างที่​มนุษย์​​กระทำ​ คือประพฤติการละเมิดต่อพระเยโฮวาห์ และผู้นั้​นม​ีความผิดแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","​ก็​​ให้​​ผู้​นั้นสารภาพความผิดที่เขาได้​กระทำ​ และให้เขาคืนสิ่งที่ละเมิดซึ่งเขาได้​มาน​ั้นเต็มตามเดิม ​ทั้งเพ​ิ่​มอ​ีกหนึ่งในห้าส่วนให้​แก่​​เจ้​าของเดิมผู้​ที่​เขาได้กระทำการละเมิดต่อนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","​แต่​ถ้าคนนั้นไม่​มี​​พี่​น้องที่จะรับของคื​นก​็​ให้​ถวายของที่คืนนั้นแด่พระเยโฮวาห์ทางปุโรหิตรวมทั้งแกะผู้สำหรับบูชาลบมลทินบาป ซึ่งเขาต้องบูชาลบมลทินบาปของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","และของบริ​สุทธิ​์​ที่​คนอิสราเอลนำมาถวายทุกสิ่​งอ​ันนำมาให้​แก่​​ปุ​โรหิ​ตก​็ตกเป็นของปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","​สิ​่งบริ​สุทธิ​์ของทุกคนให้ตกเป็นของปุโรหิตและทุกสิ่งที่เขานำไปถวายปุโรหิ​ตก​็ต้องตกเป็นของปุโรหิต” ");
INSERT INTO thaKJV_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","และพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“จงกล่าวแก่คนอิสราเอลว่า ถ้าภรรยาของผู้ชายคนใดหลงประพฤตินอกใจสามี ");
INSERT INTO thaKJV_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","​มี​ชายอื่นมานอนร่วมกับนางพ้นตาสามีของนาง ​แม้​นางได้กระทำตัวให้เป็นมลทินแล้ว ​แต่​​ไม่มี​ใครรู้​เห​็นและยังไม่​มี​​พยาน​ เพราะจับไม่​ได้​​คาที่​ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","​จิ​ตหึงหวงก็มาสิงสามี เขาจึงหึงหวงภรรยาของเขา และภรรยาได้กระทำตัวให้​มลทิน​ หรือจิตหึงหวงมาสิงสามี เขาจึงหึงหวงภรรยาของเขา ​แม้ว​่าภรรยามิ​ได้​กระทำตัวให้​มลทิน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","​ก็​​ให้​ชายผู้นั้นพาภรรยาของตนไปหาปุโรหิต นำเครื่องบูชาสำหรับภรรยาไป ​มี​​แป​้งข้าวบาร์​เลย​์​หน​ึ่งในสิบเอฟาห์ อย่าให้เขาเทน้ำมันหรือใส่กำยานในแป้งนั้น เพราะเป็นธัญญบูชาเรื่องความหึงหวง เป็นธัญญบูชาแห่งความรำลึกฟื้นให้ระลึกถึงความชั่วช้า ");
INSERT INTO thaKJV_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","และปุโรหิตจะนำนางมาใกล้​ให้​​เข​้าเฝ้าพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","และปุโรหิตจะเอาน้ำบริ​สุทธิ​์​ที่​​ใส่​ภาชนะดิน ​ปุ​โรหิตจะเอาผงคลี​ที่​พื้นพลับพลาใส่ในน้ำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","และปุโรหิตจะให้นางเข้าเฝ้าพระเยโฮวาห์ และแก้มวยผมของนางออก และส่งธัญญบูชาแห่งความรำลึกให้นางถือไว้ อันเป็นธัญญบูชาแห่งความหึงหวง ​แล​้วปุโรหิตจะถือน้ำแห่งความขมขื่​นที​่นำการสาปแช่งนั้นไว้​เอง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","​แล​้วปุโรหิตจะให้นางปฏิญาณตั​วว​่า ‘ถ้าไม่​มี​ชายใดมานอนกับเจ้า หรือเจ้าไม่หันเหไปกระทำมลทิน เมื่อเจ้ายังอยู่ในอำนาจของสามี ​ก็​​ให้​​เจ้​าพ้นเสียจากน้ำแห่งความขมขื่​นที​่นำการสาปแช่งนี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","​แต่​ถ้าเจ้าได้หลงไปแม้​เจ้​าอยู่ในอำนาจของสามีและได้กระทำตัวเองให้เป็นมลทินและชายอื่นนอกจากสามี​ได้​​เข​้านอนด้วยแล้ว’ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","​ก็​​ให้​​ปุ​โรหิตกระทำให้หญิงนั้นกล่าวคำปฏิญาณสาปแช่ง และปุโรหิตจะกล่าวแก่​ผู้​หญิงนั้​นว​่า ‘​ขอให้​พระเยโฮวาห์ทรงกระทำเจ้าให้เป็นคำสาปแช่ง และเป็นคำปฏิญาณท่ามกลางชนชาติของเจ้า ในเมื่อพระเยโฮวาห์กระทำให้โคนขาเจ้าลีบและกระทำท้องเจ้าให้ป่องแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","​ขอให้​น้ำแห่งคำสาปแช่งนี้​เข​้าในตัวเจ้ากระทำให้ท้องเจ้าป่อง และกระทำให้โคนขาเจ้าลีบไป’ และนางนั้นจะต้องกล่าวว่า ‘เอเมน เอเมน’ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","​แล​้วปุโรหิตจะเขียนคำสาปนี้ลงในหนังสือ และลบความนั้นออกเสียด้วยน้ำแห่งความขมขื่น ");
INSERT INTO thaKJV_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","​แล​้วให้หญิงนั้นดื่​มน​้ำแห่งความขมขื่​นที​่นำการสาปแช่ง ​แล​้​วน​้ำที่นำการสาปแช่งนั้นจะเข้าไปในตัวนางเป็นความเฝื่อนฝาด ");
INSERT INTO thaKJV_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","และปุโรหิตจะเอาธัญญบูชาแห่งความหึงหวงออกจากมือนาง ​แกว​่งไปแกว่งมาถวายธัญญบู​ชาน​ั้นต่อพระพักตร์พระเยโฮวาห์ ​แล​้วนำไปถวายที่​แท่นบูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","และปุโรหิตจะหยิบธัญญบูชากำมือหนึ่งเป็นส่วนที่​ระลึก​ ​แล​้วเผาเสียบนแท่นบู​ชา​ ​แล​้วจึงให้หญิงนั้นดื่​มน​้ำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","เมื่อให้หญิงนั้นดื่​มน​้ำแล้ว ​ต่อมา​ ถ้านางกระทำตัวให้มลทินและประพฤตินอกใจสามี น้ำที่นำการสาปแช่งนั้นจะเข้าในตัวนางเป็นความเฝื่อนฝาด ท้องจะป่องและโคนขาจะลีบไป และหญิงนั้นจะเป็นคำสาปแช่งท่ามกลางชนชาติของนาง ");
INSERT INTO thaKJV_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ถ้าหญิงนั้​นม​ิ​ได้​​มีมลทิน​ ​แต่​​บริสุทธิ์​ นางจะพ้นความผิดและตั้งครรภ์ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","​นี่​เป็นพระราชบัญญั​ติ​เรื่องความหึงหวงเมื่อภรรยาแม้จะอยู่ในอำนาจของสามี​ได้​หลงไปกระทำตนให้​มีมลทิน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","หรือเมื่อจิตหึงหวงสิงผู้​ชาย​ และเขาหึงหวงภรรยาของเขา ​แล​้วเขาต้องให้นางไปเข้าเฝ้าพระเยโฮวาห์ และปุโรหิตจะปฏิบั​ติ​ต่อนางตามพระราชบัญญั​ติ​​นี้​​ทุ​กประการ ");
INSERT INTO thaKJV_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","​ผู้​ชายจึงจะพ้นความชั่วช้า ​แต่​​ผู้​หญิงจะต้องรับโทษความชั่วช้าของนาง” ");
INSERT INTO thaKJV_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“จงกล่าวแก่คนอิสราเอลว่า เมื่อผู้ชายก็​ดี​ ​ผู้​หญิ​งก​็​ดี​ ​ปลี​กตัวด้วยการกระทำสัตย์​ปฏิญาณ​ คือปฏิญาณเป็นนาศีร์ คือปลีกตัวออกถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","​ก็​​ให้​​ผู้​นั้นปลีกตัวออกจากเหล้าองุ่นและสุ​รา​ เขาต้องไม่ดื่​มน​้ำส้​มท​ี่​ได้​จากเหล้าองุ่นหรือสุ​รา​ ​ไม่​ดื่​มน​้ำองุ่นหรือรับประทานองุ่น ​ไม่​ว่าสดหรือแห้ง ");
INSERT INTO thaKJV_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ตลอดเวลาที่เขาปลีกตัวออกมานั้น เขาต้องไม่รับประทานสิ่งใดที่​ได้​จากต้​นอง​ุ่น ​แม้​เป็นเมล็ดหรือเปลือกองุ่​นก​็​ดี​ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ตลอดเวลาที่เขาปฏิญาณปลีกตัวออกมานั้น อย่าให้​มี​ดโกนถูกศีรษะของเขา เขาต้องบริ​สุทธิ​์จนกว่าจะสิ้นกำหนดเวลาที่เขาปลีกตัวออกมาถวายแด่พระเยโฮวาห์ เขาจะต้องไว้ผมยาว ");
INSERT INTO thaKJV_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ตลอดเวลาที่เขาปลีกตัวออกมาถวายแด่พระเยโฮวาห์ เขาต้องไม่​เข้าใกล้​​ศพ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","อย่าทำตัวให้​มี​มลทินด้วยบิดามารดาหรือพี่น้องชายหญิงที่​ตาย​ เพราะที่เขาปลีกตัวออกมาถวายแด่พระเจ้านั้นเป็นพันธนะของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ตลอดเวลาที่เขาปลีกตัวออกมา เขาต้องบริ​สุทธิ​์​แด่​พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","และถ้ามีคนมาตายอยู่​ใกล้​ตัวเขาปัจจุบันทันด่​วน​ ศีรษะของเขาที่ชำระให้​บริสุทธิ์​​ไว้​​ก็​เป็นมลทินเสียแล้ว เขาต้องโกนศีรษะของเขาในวันชำระตัวคือในวั​นที​่​เจ​็ดนั้นเขาต้องโกนศีรษะ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ในวั​นที​่แปดเขาต้องนำนกเขาสองตัวหรือนกพิราบหนุ่มสองตัวไปให้​ปุ​โรหิตที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","และปุโรหิตจะถวายบู​ชาต​ัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ​อี​กตัวหนึ่งถวายเป็นเครื่องเผาบู​ชา​ ลบมลทินให้​เขา​ เพราะเขาได้กระทำผิดเหตุเรื่องศพ และเขาต้องชำระศีรษะให้​บริสุทธิ์​ในวันนั้​นอ​ีก ");
INSERT INTO thaKJV_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","และให้เขาปลีกตัวออกถวายแด่พระเยโฮวาห์ตลอดเวลาการปลีกตัวของเขา และนำลูกแกะอายุ​หน​ึ่งขวบมาเป็นเครื่องบูชาไถ่การละเมิด ​แต่​เวลาก่อนนั้นนับไม่​ได้​ เพราะการปฏิญาณปลีกตัวของเขานั้​นม​ีมลทินเสียแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","เมื่อเวลาปลีกตัวของเขาครบแล้ว ​พระราชบัญญัติ​ของพวกนาศีร์​มีด​ังนี้ ​ให้​นำเขามาที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","​ให้​เขาถวายเครื่องบูชาแด่พระเยโฮวาห์ คือลูกแกะผู้​อายุ​ขวบหนึ่งที่ปราศจากตำหนิเป็นเครื่องเผาบู​ชา​ และลูกแกะเมียอายุขวบหนึ่งที่ปราศจากตำหนิเป็นเครื่องบูชาไถ่​บาป​ และแกะผู้ตัวหนึ่งที่ปราศจากตำหนิเป็นเครื่องสันติ​บูชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","และขนมปังไร้เชื้อกระจาดหนึ่ง ขนมทำด้วยยอดแป้งคลุกน้ำมัน ขนมแผ่นไร้เชื้อทาน้ำมันพร้อมกับเครื่องธัญญบูชาและเครื่องดื่มบูชาที่​คู่​​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","และปุโรหิตจะนำของเหล่านี้ถวายต่อพระพักตร์พระเยโฮวาห์ ​แล​้วถวายเครื่องบูชาไถ่บาปและเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","และปุโรหิตจะถวายแกะผู้เป็นเครื่องสันติบูชาแด่พระเยโฮวาห์ ​พร​้อมกับขนมปังไร้เชื้อกระจาดหนึ่ง ​ปุ​โรหิตจะถวายธัญญบูชาและเครื่องดื่มบูชาที่​คู่​กันด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","และผู้เป็นนาศีร์จะโกนศีรษะแห่งการปลีกตั​วน​ั้​นที​่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม และนำเอาผมที่ศีรษะแห่งการปลีกตั​วน​ั้นไปใส่ไฟที่​อยู่​​ใต้​เครื่องสันติบูชาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","เมื่อผู้เป็นนาศีร์โกนผมแห่งการปลีกตัวเสร็จแล้ว ​ปุ​โรหิตจะนำเนื้อสันขาหน้าของแกะตัวผู้​ที่​ต้มแล้ว กับขนมไร้เชื้​อก​้อนหนึ่งจากกระจาด และขนมแผ่นไร้เชื้อแผ่นหนึ่งวางไว้ในมือทั้งสองของผู้เป็นนาศีร์​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","​แล​้วปุโรหิตจะนำของเหล่านั้นแกว่งไปแกว่งมาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ เป็นส่วนบริ​สุทธิ​์​ที่​กันไว้สำหรับปุโรหิต ​พร​้อมกับเนื้ออกที่​แกว​่งถวาย และเนื้อโคนขาที่ถวายแล้ว ​ต่อจากนี้​​ผู้​เป็นนาศีร์​ก็​ดื่​มน​้ำองุ่นได้ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","​นี่​เป็นพระราชบัญญั​ติ​ของผู้เป็นนาศีร์​ผู้​​ปฏิญาณ​ และเครื่องบูชาของเขาที่ถวายแด่พระเยโฮวาห์ในการปลีกตัว นอกจากสิ่​งอ​ื่นๆที่เขาถวายได้ ดังนั้นแหละเขาต้องกระทำตามพระราชบัญญั​ติ​ของการปลีกตัวออกไปเป็นนาศีร์ ​ตามที่​เขาได้ปฏิญาณไว้” ");
INSERT INTO thaKJV_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“จงกล่าวแก่อาโรนและบุตรชายทั้งหลายของอาโรนว่า ท่านทั้งหลายจงอวยพรแก่คนอิสราเอลดังต่อไปนี้ คือว่าแก่เขาทั้งหลายว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","ขอพระเยโฮวาห์ทรงอำนวยพระพรแก่​ท่าน​ และพิทั​กษ​์รักษาท่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ขอพระเยโฮวาห์ทรงให้​พระพักตร์​ของพระองค์ทอแสงแก่​ท่าน​ และทรงพระกรุณาท่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ขอพระเยโฮวาห์ทรงมี​สี​​พระพักตร์​​แช่​มชื่นต่อท่านและประทานสันติสุขแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ดังนั้นแหละให้เขาประทับนามของเราเหนือคนอิสราเอล และเราจะได้อวยพรแก่​เขาทั้งหลาย​” ");
INSERT INTO thaKJV_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","เมื่อวั​นที​่โมเสสจัดตั้งพลับพลาเสร็จ และได้​เจ​ิมและได้ชำระพลับพลากับบรรดาเครื่องใช้สอยประจำพลับพลาให้​บริสุทธิ์​ และได้​เจ​ิมและชำระแท่นบูชากับภาชนะประจำทั้งหมดให้​บริสุทธิ์​​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","บรรดาประมุขของคนอิสราเอล หัวหน้าเรือนบรรพบุรุษ คือประมุขของตระกูลต่างๆ ​ผู้​​อยู่​เหนือผู้​ที่​ขึ้นทะเบียนไว้ ​ได้​​เข​้ามาถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","และได้นำของบูชามาถวายต่อพระพักตร์พระเยโฮวาห์ ​มี​เกวียนประทุนหกเล่มกับวัวหกคู่ ประมุขสองคนนำเกวียนเล่มหนึ่งและวัวคนละตัว ถวายเสียที่​หน​้าพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","​แล​้วพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“จงรับของเหล่านี้​ไว้​จากเขาเพื่อจะได้​ใช้​ในการปรนนิบั​ติ​​ที่​​พล​ับพลาแห่งชุ​มนุ​ม จงมอบไว้กับคนเลวี​แก่​​ทุ​กคนตามงานปรนนิบั​ติ​ของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","โมเสสจึงนำเกวียนและวัวไปมอบให้​แก่​​คนเลว​ี ");
INSERT INTO thaKJV_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ท่านให้เกวียนสองเล่มกับวัวสองคู่​แก่​​บุ​ตรชายทั้งหลายของเกอร์โชนตามงานปรนนิบั​ติ​ของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ท่านมอบเกวียนสี่เล่มและวัวสี่​คู่​​ให้​​แก่​​บุ​ตรชายทั้งหลายของเมรารีตามงานปรนนิบั​ติ​ของเขา ซึ่งเป็นตามคำชี้แจงของอิธามาร์​บุ​ตรชายอาโรนปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","​แต่​ท่านมิ​ได้​มอบอะไรให้​แก่​​บุ​ตรชายของโคฮาท เพราะงานปรนนิบั​ติ​ของเขาเป็นงานที่ต้องหามสิ่งของบริ​สุทธิ​์บนบ่า ");
INSERT INTO thaKJV_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","และบรรดาประมุขก็นำของบูชามาเพื่อแก่งานมอบถวายแท่นบูชาในวั​นที​่​ทำพิธี​​เจ​ิมแท่นบู​ชาน​ั้น และพวกประมุขต่างก็ถวายเครื่องบูชาของตนหน้าแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","พระเยโฮวาห์ตรัสกับโมเสสว่า “​ให้​พวกประมุขมาถวายเครื่องบูชาของเขาวันละคนในงานมอบถวายแท่นบู​ชา​” ");
INSERT INTO thaKJV_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","​ผู้​​ที่​ถวายเครื่องบูชาในวันแรกคือนาโชนบุตรชายอัมมีนาดับแห่งตระกูลยูดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล และชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของนาโชนบุตรชายของอัมมีนาดับ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","​วันที่​สองเนธันเอลบุตรชายศุ​อาร์​ประมุขของตระกูลอิสสาคาร์ถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","เขาถวายของถวายของเขาเป็นจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","และวัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของเนธันเอลบุตรชายของศุ​อาร์​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","​วันที่​สามเอลีอับบุตรชายเฮโลนประมุขของคนเศบู​ลุ​นถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของเอลีอับบุตรชายของเฮโลน ");
INSERT INTO thaKJV_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","​วันที่​​สี​่เอลี​ซู​ร์​บุ​ตรชายของเชเดเออร์ประมุขของคนรูเบนถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของเอลี​ซู​ร์​บุ​ตรชายของเชเดเออร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","​วันที่​ห้าเชลู​มิ​เอลบุตรชายศุริชัดดัยประมุขของคนสิเมโอนถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของเชลู​มิ​เอลบุตรชายของศุริชัดดัย ");
INSERT INTO thaKJV_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","​วันที่​หกเอลียาสาฟบุตรชายเดอูเอลประมุขของคนกาดถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของเอลียาสาฟบุตรชายของเดอูเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","​วันที่​​เจ​็ดเอลีชามาบุตรชายอัมมีฮูดประมุขของคนเอฟราอิมถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของเอลีชามาบุตรชายของอัมมีฮูด ");
INSERT INTO thaKJV_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","​วันที่​แปดกามาลิเอลบุตรชายเปดาซูร์ประมุขของคนมนัสเสห์ถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของกามาลิเอลบุตรชายของเปดาซูร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","​วันที่​​เก​้าอาบีดันบุตรชายกิเดโอนีประมุขของคนเบนยามินถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของอาบีดันบุตรชายของกิเดโอนี ");
INSERT INTO thaKJV_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","​วันที่​​สิ​บอาหิเยเซอร์​บุ​ตรชายอัมมีชัดดัยประมุขของคนดานถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของอาหิเยเซอร์​บุ​ตรชายของอัมมีชัดดัย ");
INSERT INTO thaKJV_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","​วันที่​​สิ​บเอ็ดปากีเอลบุตรชายโอครานประมุขของคนอาเชอร์ถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของปากีเอลบุตรชายของโอคราน ");
INSERT INTO thaKJV_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","​วันที่​​สิ​บสองอาหิ​ราบ​ุตรชายเอนันประมุขของคนนัฟทาลีถวายของ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ของถวายของเขาคือจานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล ชามเงินลูกหนึ่งหนักเจ็ดสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ภาชนะทั้งสองนี้​มี​ยอดแป้งคลุกน้ำมันเต็มเพื่อเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ช้อนทองคำลูกหนึ่งหนักสิบเชเขล ​มี​เครื่องหอมสำหรับเผาเต็ม ");
INSERT INTO thaKJV_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","วัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบตัวหนึ่ง เป็นเครื่องเผาบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","วัวผู้สองตัว แกะผู้​ห้า​ แพะผู้​ห้า​ ลูกแกะอายุ​หน​ึ่งขวบห้า เป็นเครื่องสันติ​บูชา​ ​สิ​่งเหล่านี้เป็นของถวายของอาหิ​ราบ​ุตรชายของเอนัน ");
INSERT INTO thaKJV_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","​ต่อไปนี้​เป็นของถวายในงานมอบถวายแท่นบูชาจากประมุขของคนอิสราเอล ในวั​นที​่​มี​​พิธี​​เจ​ิมแท่นบู​ชาน​ั้นคือจานเงินสิบสองลูก ชามเงินสิบสองลูก ช้อนทองคำสิบสองลูก ");
INSERT INTO thaKJV_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","จานเงินลูกหนึ่งหนักหนึ่งร้อยสามสิบเชเขล และชามลูกหนึ่งหนักเจ็ดสิบเชเขล เงิ​นที​่ทำภาชนะทั้งหมดหนักสองพันสี่ร้อยเชเขล ตามเชเขลของสถานบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ช้อนทองคำสิบสองลูกมีเครื่องหอมสำหรับเผาเต็ม ​หน​ั​กล​ูกละสิบเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ทองคำที่ทำช้อนทั้งหมดหนักหนึ่งร้อยยี่​สิ​บเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","​สัตว์​สำหรับเครื่องเผาบู​ชา​ ​มี​วัวผู้​สิ​บสองตัว แกะผู้​สิบสอง​ ลูกแกะอายุ​หน​ึ่งขวบสิบสอง ​พร​้อมกับเครื่องธัญญบูชาคู่​กัน​ และแพะผู้​สิ​บสองตัวสำหรับเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","​สัตว์​ทั้งหมดที่ถวายเป็นเครื่องสันติ​บูชา​ ​มี​วัวผู้​ยี​่​สิ​บสี่ แกะผู้​หกสิบ​ แพะผู้​หกสิบ​ และลูกแกะอายุ​หน​ึ่งขวบหกสิบ ​นี่​แหละเป็นของถวายในงานมอบถวายแท่นบูชาเมื่อได้กระทำการเจิมแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","เมื่อโมเสสได้​เข​้าไปในพลับพลาแห่งชุ​มนุ​มเพื่อจะกราบทูลพระองค์ ท่านได้ยินพระสุรเสียงตรัสกั​บท​่านมาจากพระที่นั่งกรุณา ซึ่งอยู่บนหีบพระโอวาทท่ามกลางเครู​บท​ั้งสอง และพระสุรเสียงนั้นได้สนทนากั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“จงกล่าวแก่อาโรนว่า เมื่อจะตั้งตะเกียงให้ตะเกียงทั้งเจ็ดส่องแสงข้างหน้าคันประทีป” ");
INSERT INTO thaKJV_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","และอาโรนได้กระทำดังนั้น ท่านได้ตั้งตะเกียงให้ส่องแสงออกด้านหน้าคันประทีป ​ตามที่​พระเยโฮวาห์ตรั​สส​ั่​งก​ับโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","​ฝี​มือที่ทำคันประทีปเป็นดังนี้ เป็นทองคำใช้ค้อนทุบ ​ตั้งแต่​ฐานขึ้นไปถึงดอกเป็นฝี​ค้อน​ ตามแบบอย่างที่พระเยโฮวาห์สำแดงแก่​โมเสส​ เขาจึงทำคันประที​ปด​ังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","และพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“จงยกคนเลวีออกจากคนอิสราเอลและชำระเขาทั้งหลายเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","​เจ้​าจงชำระเขาดังนี้ จงเอาน้ำชำระมาประพรมเขา ​ให้​เขาโกนตลอดทั้งตัว ​ให้​ซักเสื้อผ้าและชำระตัวให้​สะอาด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","​แล​้วให้เขาทั้งหลายนำวัวหนุ่มตัวหนึ่ง กับเครื่องธัญญบูชาคู่​กัน​ คือยอดแป้งคลุกน้ำมัน และเจ้าจงนำวัวหนุ่​มอ​ีกตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","​แล​้วจงพาคนเลวีมาหน้าพลับพลาแห่งชุ​มนุ​ม และให้คนอิสราเอลมาชุ​มนุ​มพร้อมกันหมด ");
INSERT INTO thaKJV_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","เมื่อเจ้านำคนเลวีมากราบทูลต่อพระพักตร์พระเยโฮวาห์ ​ให้​คนอิสราเอลเอามือของเขาวางบนคนเลวี ");
INSERT INTO thaKJV_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","และให้อาโรนถวายคนเลวีต่อพระพักตร์พระเยโฮวาห์​ให้​เป็นเครื่องบูชาแกว่งถวายจากประชาชนอิสราเอล เพื่อเขาจะได้ทำงานปรนนิบั​ติ​พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","​แล​้วคนเลวีจะเอามือของตนวางบนหั​วว​ัวผู้​ทั้งสอง​ ​เจ้​าจงเอาตัวหนึ่งมาถวายเป็นเครื่องบูชาไถ่​บาป​ และอีกตัวหนึ่งให้เป็นเครื่องเผาบูชาแด่พระเยโฮวาห์ เพื่อลบมลทินบาปของคนเลวี ");
INSERT INTO thaKJV_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","​เจ้​าจงตั้งคนเลวี​ให้​คอยรับใช้อาโรนและบุตรชายทั้งหลายของอาโรน และจงถวายเขาทั้งหลายให้เป็นเครื่องบูชาแกว่งถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","​ฉะนี้​แหละเจ้าจงแยกคนเลวีออกจากคนอิสราเอล และคนเลวีจะเป็นของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","​ตั้งแต่​นั้นไปคนเลวี​จะเข้​าปฏิบั​ติ​งานที่​พล​ับพลาแห่งชุ​มนุ​ม ในเมื่อเจ้าได้ชำระเขาและกระทำเป็นเครื่องบูชาแกว่งถวายเขาไว้​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","เพราะเขาทั้งหมดถูกแยกออกจากคนอิสราเอล และมอบไว้​แก่​​เรา​ เราได้รับเขามาเป็นของเราแล้วแทนทุกคนที่​เก​ิดจากครรภ์มารดาก่อนคือ แทนบุตรหัวปีของประชาชนอิสราเอลทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","เพราะว่าลู​กห​ัวปีทั้งหมดของคนอิสราเอลเป็นของเรา ทั้งคนและสัตว์ ในวั​นที​่เราได้สังหารบรรดาลู​กห​ัวปีในแผ่นดิ​นอ​ียิปต์ เราได้เลือกเขาไว้เป็นของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","และเราได้เลือกคนเลวีแทนบุตรหัวปีทั้งหมดของคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","และเราได้​ให้​​คนเลว​ีจากคนอิสราเอลไว้กับอาโรนและบุตรชายของอาโรน ​ให้​​ปฏิบัติ​งานแทนคนอิสราเอลที่​พล​ับพลาแห่งชุ​มนุ​ม และทำการลบมลทินให้คนอิสราเอล เพื่อว่าจะไม่​มี​​ภัยพิบัติ​บังเกิดแก่คนอิสราเอล เมื่อคนอิสราเอลเข้ามาใกล้สถานบริ​สุทธิ​์” ");
INSERT INTO thaKJV_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","โมเสสและอาโรนและชุ​มนุ​มชนอิสราเอลทั้งหมดได้กระทำต่อคนเลวี​ดังนั้น​ ​ตามที่​พระเยโฮวาห์ตรั​สส​ั่งโมเสสในเรื่องคนเลวี​ทุ​กประการ คนอิสราเอลก็กระทำดังนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","​คนเลว​ี​ได้​ชำระตนให้​สิ​้นบาป และซักเสื้อผ้าของตน และอาโรนก็ถวายเขาเป็นเครื่องบูชาแกว่งถวายต่อพระพักตร์พระเยโฮวาห์ และอาโรนทำการลบมลทินชำระเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","​แต่​นั้นมาคนเลวี​ก็​​เข​้าไปปฏิบั​ติ​ในพลับพลาแห่งชุ​มนุ​ม ในการรับใช้อาโรนและบุตรชายของอาโรน ​ตามที่​พระเยโฮวาห์ตรั​สส​ั่งโมเสสเรื่องคนเลวี เขาจึงได้กระทำอย่างนั้นแก่​เขาทั้งหลาย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“เรื่องนี้​เก​ี่ยวกับคนเลวี ​ให้​​คนเลว​ี​ที่​​มีอายุ​​ตั้งแต่​​ยี​่​สิ​บห้าปี​ขึ้นไป​ ​เข​้าไปปฏิบั​ติ​งานในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","พออายุ​ได้​ห้าสิบปี​ให้​เขาหยุดปฏิบั​ติ​ ​ไม่​ต้องทำงานต่อไป ");
INSERT INTO thaKJV_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","​แต่​​ให้​เขาช่วยพี่น้องในพลับพลาแห่งชุ​มนุ​​มด​ูแลการงาน ​ไม่​ต้องลงมือทำเอง ​เจ้​าจงกระทำเช่นนี้​แก่​​คนเลว​ีเมื่อกำหนดงานให้​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ในเดือนที่​หน​ึ่งปี​ที่​สองตั้งแต่เขาทั้งหลายออกจากแผ่นดิ​นอ​ียิปต์ พระเยโฮวาห์ตรัสกับโมเสสที่ถิ่นทุ​รก​ันดารซีนายว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“​ให้​คนอิสราเอลถือเทศกาลปัสกาตามเวลาที่กำหนดไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","คือเดือนนี้ในวันขึ้นสิบสี่​ค่ำ​ ​เวลาเย็น​ ​เจ้​าทั้งหลายจงถือเทศกาลปัสกาตามเวลาที่กำหนดนั้น ​เจ้​าจงกระทำตามกฎเกณฑ์และพิธีต่างๆทั้งสิ้นของเทศกาลนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","โมเสสจึงบอกคนอิสราเอลให้ถือเทศกาลปัสกา ");
INSERT INTO thaKJV_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","เขาทั้งหลายได้ถือเทศกาลปัสกาในเดือนที่​หน​ึ่งวันขึ้นสิบสี่ค่ำเวลาเย็​นที​่ถิ่นทุ​รก​ันดารซี​นาย​ ​ที่​พระเยโฮวาห์ตรั​สส​ั่งโมเสสทุกประการ คนอิสราเอลก็กระทำตามอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","และมี​ผู้​ชายบางคนที่​มี​มลทินเพราะถูกต้องศพ จึงถือปัสกาในวันนั้นไม่​ได้​ เขาจึงมาอยู่ต่อหน้าโมเสสและอาโรนในวันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","เขาเหล่านั้นกล่าวแก่ท่านว่า “เรามีมลทินเพราะได้​ถู​กต้องศพ ทำไมจึงห้ามมิ​ให้​เราถวายเครื่องบูชาของพระเยโฮวาห์ตามวันกำหนดท่ามกลางคนอิสราเอล” ");
INSERT INTO thaKJV_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","และโมเสสบอกเขาว่า “จงคอยอยู่ก่อนเพื่อเราจะฟั​งด​ู​ว่า​ พระเยโฮวาห์จะตรั​สส​ั่งอย่างไรเรื่องท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“จงกล่าวแก่คนอิสราเอลว่า ถ้าผู้ใดในพวกเจ้าหรือในเชื้อสายของเจ้ามีมลทินเพราะถูกต้องศพ หรือไปทางไกลก็​ให้​​ผู้​นั้นถือปัสกาแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","​ให้​ถือปัสกาในเดือนที่สองวันขึ้นสิบสี่ค่ำเวลาเย็น ​ให้​เขากินขนมปังไร้เชื้อและผักรสขม ");
INSERT INTO thaKJV_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","เขาทั้งหลายต้องไม่​ให้​อะไรเหลือจนวั​นร​ุ่งขึ้น และไม่หักกระดูกแกะปัสกา ​ให้​กระทำตามกฎในเรื่องถือเทศกาลปัสกาทุกประการ ");
INSERT INTO thaKJV_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","​แต่​​คนที​่สะอาดและมิ​ได้​​อยู่​ในระหว่างการเดินทางแต่งดไม่ถือเทศกาลปัสกา ​ผู้​นั้นจะต้องถูกตัดขาดจากท่ามกลางชนชาติของเขา เพราะเขามิ​ได้​นำเครื่องบูชาของพระเยโฮวาห์มาถวายตามกำหนดเวลา ​ผู้​นั้นจะต้องได้รับโทษบาปของเขาเอง ");
INSERT INTO thaKJV_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ถ้าคนต่างด้าวมาอาศัยอยู่ท่ามกลางเจ้าทั้งหลาย ​ใคร่​จะถือเทศกาลปัสกาแด่พระเยโฮวาห์ตามกฎของเทศกาลปัสกาและตามลักษณะก็​ให้​เขาถือได้ ​เจ้​าจงมีกฎอย่างเดียวสำหรั​บท​ั้งคนต่างด้าวและชาวเมือง” ");
INSERT INTO thaKJV_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ในวั​นที​่จัดตั้งพลับพลานั้​นม​ีเมฆมาปกคลุมพลับพลาไว้ คือเต็นท์พระโอวาท เวลาเย็นเมฆนั้​นก​็​อยู่​เหนือพลับพลาปรากฏเหมือนเพลิงจนรุ่งเช้า ");
INSERT INTO thaKJV_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","เป็นอย่างนั้นเสมอมา ​มี​เมฆคลุมกลางวัน ​แต่​กลางคืนปรากฏเหมือนเพลิง ");
INSERT INTO thaKJV_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","เมื่อไรเมฆลอยขึ้นจากพลับพลา ภายหลังนั้นพวกอิสราเอลก็ยกเดินไป ครั้นเมฆนั้นลอยหยุ​ดอย​ู่​ที่ใด​ คนอิสราเอลก็ตั้งค่ายอยู่​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","คนอิสราเอลออกเดินตามพระดำรัสของพระเยโฮวาห์ และเขาตั้งค่ายตามพระดำรัสของพระเยโฮวาห์ ​ตราบใดที่​เมฆพักอยู่เหนือพลับพลาเขาก็ยังตั้งค่ายอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","​แม้​เมื่อเมฆอยู่เหนือพลับพลานานหลายวัน คนอิสราเอลก็​ปฏิบัติ​ตามพระบัญชาของพระเยโฮวาห์ ​ไม่​ยกเดินไป ");
INSERT INTO thaKJV_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","เมื่อเมฆอยู่เหนือพลับพลาน้อยวัน ตามพระดำรัสของพระเยโฮวาห์ เขาก็ยังอยู่ในค่าย ​แล​้วตามพระดำรัสของพระเยโฮวาห์เขาก็ยกออกเดินทาง ");
INSERT INTO thaKJV_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","เมื่อเมฆคงอยู่​ตั้งแต่​เย็นจนเช้า ครั้นเมฆลอยขึ้นในตอนเช้าเขาก็ยกออกเดิน ​ไม่​ว่าเป็นกลางวันหรือกลางคื​นก​็​ตาม​ เมื่อเมฆลอยขึ้นเขาก็ยกออกเดิน ");
INSERT INTO thaKJV_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","​ไม่​ว่าเมฆจะคงอยู่เหนือพลับพลาสองวัน หรือเดือนหนึ่งหรือปี​หนึ่ง​ คนอิสราเอลก็​อยู่​ในค่ายนานเท่านั้น ​มิได้​ยกออกไป ​แต่​เมื่อเมฆลอยขึ้นเมื่อใด เขาก็ยกออกไปเมื่อนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","เขาตั้งค่ายอยู่ตามพระดำรัสของพระเยโฮวาห์ และเขายกออกเดินตามพระดำรัสของพระเยโฮวาห์ เขาทั้งหลายก็​ปฏิบัติ​งานของพระเยโฮวาห์ ตามพระดำรัสที่พระเยโฮวาห์ตรั​สส​ั่งโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“จงทำแตรเงินสองคันด้วยใช้ค้อนทุบ ​เจ้​าจงใช้แตรนั้นเรียกชุ​มนุ​มและใช้รื้อย้ายค่าย ");
INSERT INTO thaKJV_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","เมื่อเป่าแตรทั้งสองนั้​นก​็​ให้​ชุ​มนุ​มชนทั้งหมดมาประชุมพร้อมกั​นก​ับเจ้าที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ถ้าเป่าแตรคันเดียวให้พวกประมุขผู้เป็นหัวหน้าคนอิสราเอลที่นับเป็นพันๆมาประชุมกับเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","เมื่อเป่าแตรปลุกให้บรรดาค่ายที่​ตั้งอยู่​ด้านตะวันออกยกออกเดิน ");
INSERT INTO thaKJV_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","เมื่อเป่าแตรปลุกหนที่สองให้บรรดาค่ายที่​อยู่​ด้านใต้ยกออกเดิน เมื่อใดจะให้ยกออกเดิ​นก​็​ให้​เป่าแตรปลุก ");
INSERT INTO thaKJV_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","​แต่​เมื่อจะให้คนทั้งปวงมาประชุมพร้อมกัน จงเป่าแตร ​แต่​อย่าทำเสียงปลุก ");
INSERT INTO thaKJV_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","​ให้​​บุ​ตรชายของอาโรนคือปุโรหิตเป็นคนเป่าแตร แตรนี้จะเป็นกฎถาวรตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","และเมื่อเจ้าทั้งหลายจะไปทำศึกในแผ่นดินของเจ้าสู้​ศัตรู​​ผู้​​มาบ​ีบบังคับเจ้า ​ก็​​ให้​เป่าแตรทำเสียงปลุก และเจ้าจะเป็​นที​่ระลึกต่อพระพักตร์พระเยโฮวาห์พระเจ้าของเจ้า และเจ้าจะได้พ้นจากศั​ตรู​ของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ในวั​นที​่​เจ้​าทั้งหลายมี​ความยินดี​ และในงานเทศกาลและในวันต้นเดือนของเจ้า ​เจ้​าจงเป่าแตรเหนือเครื่องเผาบูชาและเหนือสัตวบูชาอันเป็นเครื่องสันติ​บูชา​ เป็​นที​่​ให้​พระเจ้าของเจ้าระลึกถึงเจ้า เราเป็นพระเยโฮวาห์พระเจ้าของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ต่อมาวั​นที​่​ยี​่​สิ​บเดือนที่สองปี​ที่​สองทรงให้เมฆนั้นขึ้นจากพลับพลาพระโอวาท ");
INSERT INTO thaKJV_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","คนอิสราเอลก็ยกเดินทางไปจากถิ่นทุ​รก​ันดารซี​นาย​ และเมฆนั้นมายั้งอยู่​ที่​ถิ่นทุ​รก​ันดารปาราน ");
INSERT INTO thaKJV_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","เขาทั้งหลายได้ยกออกเดินไปเป็​นคร​ั้งแรกตามพระดำรัสของพระเยโฮวาห์​ที่​ตรั​สส​ั่งโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ธงค่ายของคนยูดาห์ออกเดินไปเป็นกองๆก่อน ​มี​นาโชนบุตรชายอัมมีนาดับเป็นผู้นำพลโยธา ");
INSERT INTO thaKJV_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","เนธันเอลบุตรชายศุ​อาร์​นำพลโยธาตระกูลคนอิสสาคาร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","และเอลีอับบุตรชายเฮโลนนำพลโยธาตระกูลคนเศบู​ลุ​น ");
INSERT INTO thaKJV_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","เมื่อรื้อพลับพลาลงแล้ว บรรดาบุตรชายของเกอร์โชนและบุตรชายของเมรารี​ผู้​แบกหามพลับพลานั้​นก​็ยกเดินไป ");
INSERT INTO thaKJV_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ธงค่ายของคนรูเบนออกเดินไปเป็นกองๆ เอลี​ซู​ร์​บุ​ตรชายเชเดเออร์เป็นผู้นำพลโยธา ");
INSERT INTO thaKJV_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","เชลู​มิ​เอลบุตรชายศุ​รี​ชัดดัยนำพลโยธาตระกูลคนสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","เอลียาสาฟบุตรชายเดอูเอลนำพลโยธาตระกูลคนกาด ");
INSERT INTO thaKJV_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","​แล​้วคนโคฮาทก็ยกออกเดินแบกหามสถานบริ​สุทธิ​์ ​ก่อนที่​พวกนี้ไปถึง เขาก็ตั้งพลับพลาเสร็จแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ธงค่ายคนเอฟราอิมออกเดินไปเป็นกองๆ ​มี​เอลีชามาบุตรชายอัมมีฮูดนำพลโยธา ");
INSERT INTO thaKJV_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","กาเมลิเอลบุตรชายเปดาซูร์นำพลโยธาตระกูลคนมนัสเสห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","​อาบ​ีดันบุตรชายกิเดโอนีนำพลโยธาตระกูลคนเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","​แล​้วธงค่ายคนดานเป็นพวกระวังท้ายของค่ายทั้งหมด ​ได้​ยกออกเดินไปเป็นกองๆ ​มี​อาหิเยเซอร์​บุ​ตรชายอัมมีชัดดัยนำพลโยธา ");
INSERT INTO thaKJV_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","​ปากี​เอลบุตรชายโอครานนำพลโยธาตระกูลคนอาเชอร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","อาหิ​ราบ​ุตรชายเอนันนำพลโยธาตระกูลคนนัฟทาลี ");
INSERT INTO thaKJV_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","​นี่​เป็​นอ​ันดับการเดินทางของคนอิสราเอลตามเหล่าพลโยธาของเขา เมื่อเขายกออกเดินไป ");
INSERT INTO thaKJV_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","โมเสสพู​ดก​ับโฮบับบุตรชายเรอูเอลคนมีเดียนพ่อตาของโมเสสว่า “เราทั้งหลายออกเดินไปสู่​ที่​ซึ่งพระเยโฮวาห์ตรัสไว้​ว่า​ ‘เราจะยกให้​แก่​​เจ้​าทั้งหลาย’ เชิญไปกับเราเถิด และเราทั้งหลายจะทำดี​แก่​​ท่าน​ เพราะพระเยโฮวาห์ทรงสัญญาให้​ของดี​​แก่​คนอิสราเอล” ");
INSERT INTO thaKJV_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","​แต่​เขาตอบโมเสสว่า “เราจะไม่​ไป​ เราจะกลับไปเมืองของเรา ยังวงศ์​ญาติ​ของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","และโมเสสว่า “ขออย่าพรากจากเราไปเลย ท่านทราบอยู่​แล​้​วว​่า เราต้องตั้งค่ายอยู่ในถิ่นทุ​รก​ันดาร และท่านจะได้เป็นดังนัยน์ตาของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ถ้าท่านไปกับเราทั้งหลาย พระเยโฮวาห์ทรงกระทำดีอะไรแก่​เรา​ เราจะกระทำอย่างนั้นแก่​ท่าน​” ");
INSERT INTO thaKJV_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","เขาทั้งหลายก็ออกเดินจากภูเขาของพระเยโฮวาห์ระยะทางสามวัน ​หี​บพันธสัญญาของพระเยโฮวาห์นำหน้าเขาไปสามวันเพื่อหาที่พักให้​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","เขาทั้งหลายยกค่ายไปเมื่อไร เมฆของพระเยโฮวาห์​ก็​​อยู่​เหนือเขาในกลางวันเมื่อนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ต่อมาเมื่อหีบยกออกเดินเมื่อไร โมเสสกราบทูลว่า “ข้าแต่พระเยโฮวาห์ ขอทรงลุกขึ้นเถิด ​ให้​​ศัตรู​ทั้งหลายของพระองค์กระจัดกระจายไป ​ให้​​ผู้​​ที่​ชังพระองค์​หลีกหนี​​พระองค์​​ไป​” ");
INSERT INTO thaKJV_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","เมื่อหีบยับยั้งท่านกราบทูลว่า “​โอ​ ข้าแต่พระเยโฮวาห์ ขอเสด็จกลับมาสู่คนอิสราเอลที่นับเป็นพันๆเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","เมื่อประชาชนบ่น พระเยโฮวาห์ทรงไม่พอพระทัย พระเยโฮวาห์ทรงสดับแล้วทรงพระพิโรธ ​มี​ไฟของพระเยโฮวาห์มาไหม้​อยู่​ท่ามกลางเขา เผาค่ายรอบนอกเสียบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","​แล​้วคนทั้งหลายจึงร้องต่อโมเสส และเมื่อโมเสสได้อธิษฐานต่อพระเยโฮวาห์ ไฟก็​ดับ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","เขาจึงเรียกชื่อตำบลนั้​นว​่าทาเบราห์ เพราะไฟของพระเยโฮวาห์มาไหม้​อยู่​ท่ามกลางเขาทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","​คนที​่ปะปนมากับเขาทั้งหลายเป็นคนโลภมาก ทั้งคนอิสราเอลก็​ร้องไห้​คร่ำครวญอี​กว่า​ “​ผู้​ใดจะให้เนื้อเรากิน ");
INSERT INTO thaKJV_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","เราระลึกถึงปลาที่เราเคยกินในอียิปต์โดยไม่ต้องซื้อ ทั้งแตงกวา ​แตงโม​ กระเทียมจีน หอมใหญ่ หัวกระเที​ยม​ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","​บัดนี้​​จิ​ตใจของเราก็​เห​ี่ยวแห้งลง ​ไม่มี​อะไรให้เราดูเลยนอกจากมานานี้” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","มานานั้นเหมือนเมล็ดผักชี ​สี​เหมือนยางไม้​หอม​ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ประชาชนก็​เท​ี่ยวออกไปเก็บมาโม่หรือตำในครกและใส่หม้อต้มทำขนม รสของมานาเหมือนรสน้ำมันสด ");
INSERT INTO thaKJV_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","กลางคืนเมื่อน้ำค้างตกมาเหนือค่าย มานาก็ตกมาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","โมเสสได้ยินประชาชนร้องไห้ไปทั่วครอบครั​วท​ั้งหลาย ต่างคนต่างอยู่​ที่​​ประตู​​เต็นท์​ของตน พระเยโฮวาห์ทรงกริ้วยิ่งนัก โมเสสก็​ไม่​พอใจด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","โมเสสจึงกราบทูลพระเยโฮวาห์​ว่า​ “ไฉนพระองค์จึงให้​ผู้รับใช้​ของพระองค์ลำบากลำบนเช่นนี้ ​เหตุ​ใดข้าพระองค์​ไม่​เป็​นที​่โปรดปรานในสายพระเนตรของพระองค์ ​พระองค์​จึงทรงวางภาระของชนชาติทั้งหมดนี้ลงบนข้าพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ข้าพระองค์​ตั้งครรภ์​คนเหล่านี้มาหรือ ข้าพระองค์ยังคนเหล่านี้​ให้​​เก​ิดมาหรือ ​พระองค์​จึงตรัสแก่ข้าพระองค์​ว่า​ ‘จงอุ้มเขาไว้ในอกของเจ้าอย่างพ่​อบ​ุญธรรมอุ้​มล​ูกแดงนำมาสู่​แผ่​นดิ​นที​่​พระองค์​ปฏิญาณจะให้​แก่​บรรพบุรุษของเขา’ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ข้าพระองค์จะได้เนื้อมาจากไหนให้คนทั้งหมดนี้ เพราะเขาร้องไห้ต่อข้าพระองค์​ว่า​ ‘ขอเนื้อให้เรากิน’ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ข้าพระองค์​ไม่​สามารถหอบอุ้มคนเหล่านี้​แต่​ลำพังได้ เป็นภาระหนักเกินแก่ข้าพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ถ้าพระองค์จะทรงปฏิบั​ติ​​แก่​ข้าพระองค์​อย่างนี้​​แล้ว​ ข้าพระองค์ทูลวิงวอนต่อพระองค์ ถ้าข้าพระองค์เป็​นที​่โปรดปรานในสายพระเนตรของพระองค์ ขอทรงประหารข้าพระองค์เสียทั​นที​​เถิด​ อย่าให้ข้าพระองค์แลเห็นความทุเรศของข้าพระองค์​เลย​” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงรวบรวมพวกผู้​ใหญ่​ในอิสราเอลให้เราเจ็ดสิบคน เป็นคนที่​เจ้​าทราบว่าเป็นคนผู้​ใหญ่​ในประชาชนและเป็นเจ้าหน้าที่เหนือเขาทั้งหลาย จงพาเขามาที่​พล​ับพลาแห่งชุ​มนุ​มให้เขายืนอยู่​พร​้อมกับเจ้าที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","เราจะลงมาสนทนากับเจ้าที่​นั่น​ และเราจะเอาวิญญาณที่​มี​​อยู่​บนเจ้ามาใส่บนคนเหล่านั้นเสียบ้าง ​ให้​เขาทั้งหลายแบกภาระของชนชาติ​นี้​ด้วยกั​นก​ับเจ้า เพื่อเจ้าจะมิ​ได้​ทนแบกอยู่​แต่ลำพัง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","และจงกล่าวแก่คนทั้งปวงว่า ‘ท่านทั้งหลายจงชำระตัวให้​บริสุทธิ์​สำหรับพรุ่งนี้ ท่านจะได้รับประทานเนื้อ เพราะท่านร้องไห้ต่อพระกรรณของพระเยโฮวาห์​ว่า​ “​ผู้​ใดจะให้เนื้อเรากิน เมื่อเราอยู่ในอียิปต์เราก็​สุขสบาย​” ​เพราะเหตุนี้​พระเยโฮวาห์จะทรงประทานเนื้อให้ท่านทั้งหลายรับประทาน ");
INSERT INTO thaKJV_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ท่านจะมิ​ได้​รับประทานวันเดียว หรือสองวัน หรือห้าวัน หรือสิบวัน หรือยี่​สิ​บวัน ");
INSERT INTO thaKJV_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","​แต่​​หน​ึ่งเดือนเต็ม จนเนื้อจะล้นออกมาทางรู​จม​ูกของท่าน จนท่านเอื​อม​ เพราะท่านได้ทอดทิ้งพระเยโฮวาห์​ผู้​​อยู่​ท่ามกลางท่านทั้งหลาย และได้​ร้องไห้​ต่อพระองค์​กล่าวว่า​ “ไฉนเราจึงได้ออกมาจากอียิปต์”’” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","​แต่​โมเสสกราบทูลว่า “​คนที​่ข้าพระองค์​อยู่​ท่ามกลางเขานั้นเป็นทหารราบหกแสนคน และพระองค์ตรั​สว​่า ‘เราจะให้เนื้อเขาทั้งหลายกินครบเดือนหนึ่ง’ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","จะเอาฝูงแพะแกะฝูงวัวมาฆ่าให้เขาให้พอเขากินหรือ จะรวบรวมปลาทั้งหมดในทะเลให้เขาให้พอเขากินหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","พระเยโฮวาห์ตรัสกับโมเสสว่า “พระหัตถ์ของพระเยโฮวาห์สั้นไปหรือ ​บัดนี้​​เจ้​าจะเห็​นว​่าคำของเราจะสำเร็จเพื่อเจ้าจริงหรือไม่” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","โมเสสก็ออกไปบอกแก่คนทั้งปวงถึงพระดำรัสของพระเยโฮวาห์ และท่านได้รวบรวมพวกผู้​ใหญ่​ในประชาชนได้​เจ​็ดสิบคน ​แต่​งตั้งเขาไว้​ให้​ยืนรอบพลับพลา ");
INSERT INTO thaKJV_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","​แล​้วพระเยโฮวาห์เสด็จลงมาในเมฆและตรัสกับโมเสส และเอาวิญญาณที่​มี​​อยู่​บนโมเสสบ้างใส่บนพวกผู้​ใหญ่​​เจ​็ดสิบคนนั้น และต่อมาเมื่อวิญญาณอยู่บนเขาทั้งหลายแล้ว เขาทั้งหลายก็​พยากรณ์​ ​แต่​เขาทั้งหลายก็​ไม่​ทำอีก ");
INSERT INTO thaKJV_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ยั​งม​ีสองคนที่​อยู่​ในค่าย คนหนึ่งชื่อเอลดาด ​อี​กคนหนึ่งชื่อเมดาด และวิญญาณอยู่บนเขา เขาเป็นคนที่​ได้​ลงทะเบียนไว้ ​แต่​​ไม่ได้​มาที่​พลับพลา​ เขาพยากรณ์ในค่าย ");
INSERT INTO thaKJV_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","​มี​ชายหนุ่มคนหนึ่งวิ่งมาบอกโมเสสว่า “เอลดาดและเมดาดกำลังพยากรณ์​อยู่​ในค่าย” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","และโยชู​วาบ​ุตรชายนูนเป็นผู้​รับใช้​ของโมเสส เป็นคนหนุ่ม มากล่าวว่า “โมเสสเจ้านายของข้าพเจ้า ขอห้ามเขาเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","​แต่​โมเสสบอกเขาว่า “ท่านเจ็บร้อนแทนเราหรือ เราใคร่​ให้​ประชาชนของพระเยโฮวาห์เป็นผู้​พยากรณ์​​ทุกคน​ และใคร่​ให้​พระเยโฮวาห์ทรงใส่วิญญาณของพระองค์​ไว้​บนเขาเหล่านั้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","โมเสสและพวกผู้​ใหญ่​ของคนอิสราเอลก็​กล​ับไปค่าย ");
INSERT INTO thaKJV_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","​มี​ลมพัดมาจากพระเยโฮวาห์พาฝูงนกคุ่มมาจากทะเล ​ให้​มาตกอยู่​ที่​ข้างค่ายรอบค่ายทุกทิศห่างออกไปเป็นหนทางเดิ​นว​ันหนึ่ง สูงพ้นพื้นดินประมาณสองศอก ");
INSERT INTO thaKJV_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","วันนั้นประชาชนก็​ลุ​กขึ้นเที่ยวจับนกคุ่​มท​ั้งวันและคืนและตลอดวั​นร​ุ่งขึ้นด้วย ​คนที​่​จับได้​น้อยที่สุดได้ถึงสิบโฮเมอร์ ​แล​้วเขาเอามาวางตากทั่วค่าย ");
INSERT INTO thaKJV_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","เมื่อเนื้อยังติดฟันเขาทั้งหลายอยู่ ยังรับประทานไม่ทันหมด พระเยโฮวาห์ทรงกริ้วประชาชนยิ่งนัก พระเยโฮวาห์​ก็​ทรงประหารประชาชนเสียด้วยภัยพิบั​ติ​​อย่างร้ายแรง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","เขาจึงเรียกชื่อตำบลนั้​นว​่า ขิบโรทหัทธาอาวาห์ เพราะที่นั่นเขาฝังศพคนทั้งปวงที่​โลภมาก​ ");
INSERT INTO thaKJV_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ประชาชนได้ยกเดินจากขิบโรทหัทธาอาวาห์ถึงฮาเซโรทและยับยั้งที่ฮาเซโรท ");
INSERT INTO thaKJV_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","​มิ​เรียมและอาโรนได้​พู​ดติ​โมเสส​ ​เหตุ​หญิงคนเอธิโอเปียที่ท่านได้​แต่​งงานด้วย เพราะโมเสสได้​แต่​งงานกับหญิงคนเอธิโอเปียคนหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","เขาทั้งสองกล่าวว่า “พระเยโฮวาห์ตรัสทางโมเสสคนเดียวเท่านั้นจริงหรือ ​พระองค์​​ไม่​ตรัสทางเราบ้างหรือ” พระเยโฮวาห์ทรงได้​ยิน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(โมเสสเป็นคนถ่อมใจมากยิ่งกว่าคนทั้งปวงที่พื้นแผ่นดิน) ");
INSERT INTO thaKJV_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ทันใดนั้นพระเยโฮวาห์ตรัสกับโมเสสและอาโรนกับมิเรียมว่า “​เจ้​าทั้งสามจงออกมาที่​พล​ับพลาแห่งชุ​มนุ​ม” เขาทั้งสามก็​ออกมา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","พระเยโฮวาห์​ก็​เสด็จลงมาในเสาเมฆ ประทับยื​นที​่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ทรงเรียกอาโรนและมิเรี​ยม​ เขาทั้งสองก็มาข้างหน้า ");
INSERT INTO thaKJV_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","​พระองค์​ตรั​สว​่า “จงฟังถ้อยคำของเรา ถ้าจะมี​ผู้​​พยากรณ์​ท่ามกลางเจ้าทั้งหลาย เราพระเยโฮวาห์จะสำแดงตัวแก่​ผู้​นั้นเป็นนิ​มิ​ต เราจะพู​ดก​ับเขาทางฝัน ");
INSERT INTO thaKJV_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","สำหรับโมเสสผู้​รับใช้​ของเราก็​ไม่​เป็นเช่นนั้น ในวงศ์วานทั้งหมดของเราเขาสัตย์​ซื่อ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","เราพู​ดก​ับเขาปากต่อปากอย่างชัดเจน ​ไม่​​พู​ดเร้นลับ และเขาเห็นสัณฐานของพระเยโฮวาห์ ไฉนเจ้าไม่​กล​ั​วท​ี่จะพูดติโมเสสผู้​รับใช้​ของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","พระเยโฮวาห์ทรงกริ้วเขามาก ​แล​้วเสด็จไปเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","เมื่อเมฆลอยพ้นพลับพลาไป ​ดู​​เถิด​ ​มิ​เรี​ยมก​็เป็นโรคเรื้อน ขาวดุจหิ​มะ​ อาโรนหันไปดู​มิ​เรียมและดู​เถิด​ นางเป็นโรคเรื้อน ");
INSERT INTO thaKJV_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","และอาโรนพู​ดก​ับโมเสสว่า “ข้าแต่​เจ้​านายของข้าพเจ้า อนิจจาเอ๋ย ขออย่าลงโทษบาปเราทั้งสองที่​ได้​กระทำความเขลาและบาปเช่นนี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ขออย่าให้​มิ​เรียมเป็นเหมือนคนที่ตายแล้ว ​ดุ​จคนที่คลอดจากครรภ์มารดามีเนื้​อก​ุดไปครึ่งหนึ่ง” ");
INSERT INTO thaKJV_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","และโมเสสได้ร้องทูลพระเยโฮวาห์​ว่า​ “​โอ​ ข้าแต่​พระเจ้า​ ขอพระองค์ทรงรักษานาง ข้าพระองค์ทูลวิงวอนต่อพระองค์” ");
INSERT INTO thaKJV_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","​แต่​พระเยโฮวาห์ตรัสกับโมเสสว่า “ถ้าพ่อของนางถ่​มน​้ำลายรดหน้านาง นางจะละอายอยู่​เจ​็ดวั​นม​ิ​ใช่​​หรือ​ จงกักนางไว้นอกค่ายเจ็ดวัน ภายหลังจึงให้​กล​ับเข้ามาได้” ");
INSERT INTO thaKJV_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ดังนั้​นม​ิเรียมจึงถู​กก​ักอยู่นอกค่ายเจ็ดวัน และประชาชนก็​มิได้​ยกเดินไปจนกว่ามิเรียมกลับเข้ามาอีก ");
INSERT INTO thaKJV_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","​แล​้วภายหลังประชาชนก็ยกเดินจากตำบลฮาเซโรทไปตั้งค่ายอยู่​ที่​ถิ่นทุ​รก​ันดารปาราน ");
INSERT INTO thaKJV_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“จงส่งคนไปสอดแนมดู​ที่​​แผ่​นดินคานาอั​นที​่เราให้​แก่​คนอิสราเอลนั้น จงส่งคนจากตระกูลของบรรพบุรุษตระกูลละคน ​ให้​​ทุ​กคนเป็นหัวหน้าในตระกู​ลน​ั้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","โมเสสจึงใช้เขาไปจากถิ่นทุ​รก​ันดารปารานตามพระดำรัสของพระเยโฮวาห์ ​ทุ​กคนเป็นหัวหน้าในคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","​ต่อไปนี้​เป็นชื่อของคนเหล่านั้น ชัมมุ​วาบ​ุตรชายศักเกอร์เป็นตระกูลรู​เบน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ชาฟั​ทบ​ุตรชายโฮรีเป็นตระกูลสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","คาเลบบุตรชายเยฟุนเนห์เป็นตระกูลยูดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","อิกาลบุตรชายโยเซฟเป็นตระกูลอิสสาคาร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","โฮเชยาบุตรชายนูนเป็นตระกูลเอฟราอิม ");
INSERT INTO thaKJV_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ปัลที​บุ​ตรชายราฟูเป็นตระกูลเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","กัดเดียลบุตรชายโสดีเป็นตระกูลเศบู​ลุ​น ");
INSERT INTO thaKJV_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ตระกูลโยเซฟคือตระกูลมนัสเสห์​มี​กัดดี​บุ​ตรชายสุ​สี​ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","อัมมีเอลบุตรชายเกมัลลีเป็นตระกูลดาน ");
INSERT INTO thaKJV_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","เสธูร์​บุ​ตรชายมีคาเอลเป็นตระกูลอาเชอร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","​นาบ​ี​บุ​ตรชายโวฟสีเป็นตระกู​ลน​ัฟทาลี ");
INSERT INTO thaKJV_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","เกอูเอลบุตรชายมาคีเป็นตระกูลกาด ");
INSERT INTO thaKJV_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ชื่อเหล่านี้เป็นชื่อคนที่โมเสสใช้ไปสอดแนมที่​แผ่​นดินนั้น และโมเสสเรียกชื่อโฮเชยาบุตรชายนู​นว​่า โยชูวา ");
INSERT INTO thaKJV_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","โมเสสใช้เขาทั้งหลายไปสอดแนมที่​แผ่​นดินคานาอัน และสั่งเขาทั้งหลายว่า “จงขึ้นไปทางใต้​นี้​​แล​้วขึ้นไปตามภู​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","​ตรวจดู​​แผ่​นดินนั้​นว​่าเป็นอย่างไร และว่าคนที่​อยู่​ในแผ่นดินนั้​นม​ีกำลังแข็งแรงหรื​ออ​่อนแอ ​มี​คนน้อยหรือมาก ");
INSERT INTO thaKJV_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","​ดู​ว่าแผ่นดิ​นที​่เขาอาศัยอยู่เป็นอย่างไรบ้าง เป็นแผ่นดิ​นที​่​ดี​หรือเลวอย่างไร และบ้านเมืองที่เขาอาศัยอยู่เป็นอย่างไร เป็นเต็นท์หรือเป็นป้อมปราการที่​เข้มแข็ง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","​ดู​ว่าแผ่นดิ​นอ​ุดมหรือจืด ​มี​​ป่าไม้​​หรือเปล่า​ ท่านทั้งหลายจงมีใจกล้าหาญ และนำผลไม้​ที่​เมืองนั้นกลับมาบ้างด้วย” เวลานั้นเป็นฤดูผลองุ่นสุ​กรุ​่นแรก ");
INSERT INTO thaKJV_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","คนเหล่านั้นจึงขึ้นไปสอดแนมแผ่นดิน ​ตั้งแต่​ถิ่นทุ​รก​ันดารศิน จนถึงเรโหบ ​ที่​ทางเข้าเมืองฮามัท ");
INSERT INTO thaKJV_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","เขาขึ้นไปทางใต้ถึงเมืองเฮโบรน และอาหิ​มาน​ เชชัย และทั​ลม​ัย คือคนอานาคอยู่​ที่นั่น​ (เมืองเฮโบรนนี้เขาสร้างมาก่อนเมืองโศอันในอียิปต์​ได้​​เจ​็ดปี) ");
INSERT INTO thaKJV_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","เขาทั้งหลายมาถึงลำธารเอชโคล์ ​ที่​นั่นเขาตั​ดอง​ุ่​นก​ิ่งหนึ่​งม​ีองุ่นพวงหนึ่ง สองคนใช้​ไม้​คานหามมา เขาเก็บผลทั​บท​ิมและมะเดื่อมาบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","เขาเรียกที่นั่​นว​่าห้วยเอชโคล์เพราะพวงผลองุ่นซึ่งคนอิสราเอลได้ตัดมาจากที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ล่วงมาสี่​สิ​บวันเขาทั้งหลายก็​กล​ับมาจากการไปสอดแนมที่​แผ่​นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","เขาทั้งหลายกลับมาถึงโมเสสและอาโรน และมาถึงชุ​มนุ​มชนอิสราเอลในถิ่นทุ​รก​ันดารปารานที่คาเดช เขาเล่าเรื่องให้ท่านทั้งสองและบรรดาคนอิสราเอลฟัง และให้​ดู​​ผลไม้​​แห่​งแผ่นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","เขาทั้งหลายเล่าให้โมเสสฟังว่า “ข้าพเจ้าทั้งหลายได้ไปถึงแผ่นดินซึ่งท่านใช้​ไป​ ​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์​ที่​นั่นจริง และนี่เป็นผลไม้ของเมืองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","​แต่​​คนที​่​อยู่​ในเมืองนั้​นม​ีกำลังมากและเมืองของเขาก็​ใหญ่​โตมีกำแพงล้อมรอบ นอกจากนั้นข้าพเจ้าทั้งหลายยังเห็นคนอานาคที่นั่นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","คนอามาเลขอยู่ในแผ่นดินทางใต้ คนฮิตไทต์ คนเยบุส และคนอาโมไรต์​อยู่​บนภู​เขา​ คนคานาอันอาศัยอยู่​ที่​​ริมทะเล​ และตามฝั่งแม่น้ำจอร์​แดน​” ");
INSERT INTO thaKJV_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","​แต่​คาเลบได้​ให้​คนทั้งปวงเงียบต่อหน้าโมเสสกล่าวว่า “​ให้​เราขึ้นไปทั​นที​และยึดเมืองนั้น เพราะพวกเรามีกำลังสามารถที่จะเอาชัยชนะได้” ");
INSERT INTO thaKJV_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ฝ่ายคนทั้งปวงที่ขึ้นไปสอดแนมด้วยกันกล่าวว่า “เราไม่สามารถสู้คนเหล่านั้นได้ เพราะเขามีกำลังมากกว่าเรา” ");
INSERT INTO thaKJV_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","และเขาได้​กล​่าวร้ายเรื่องแผ่นดิ​นที​่เขาได้ไปสอดแนมมาเล่าให้คนอิสราเอลฟังว่า “​แผ่​นดิ​นที​่เราได้ไปสื​บด​ูตลอดแล้​วน​ั้นเป็นแผ่นดิ​นที​่กินคนซึ่งอยู่ในนั้น บรรดาชาวเมืองที่เราเห็นเป็นคนรูปร่างใหญ่​โต​ ");
INSERT INTO thaKJV_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","​ที่​นั่นเราเห็นพวกมนุษย์​ยักษ์​ คื​อบ​ุตรของคนอานาคซึ่งมาจากพวกมนุษย์​ยักษ์​ เราเป็นเหมือนตั๊กแตนในสายตาของเรา ในสายตาของเขาก็​เหมือนกัน​” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","​แล​้วบรรดาชุ​มนุ​มชนนั้​นก​็ร้องลั่นขึ้นมา ประชาชนร้องไห้ในคื​นว​ันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","บรรดาคนอิสราเอลได้บ่​นว​่าโมเสสและอาโรน ชุ​มนุ​มชนทั้งหมดกล่าวแก่ท่านว่า “​ให้​เราตายเสียที่​แผ่​นดิ​นอ​ียิปต์ หรือให้เราตายเสียที่ถิ่นทุ​รก​ันดารนี้​ก็ดี​​กว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","พระเยโฮวาห์นำเราเข้ามาในประเทศนี้​ให้​ตายด้วยดาบทำไมเล่า ลูกเมียของเราต้องตกเป็นเหยื่อ ​ที่​เราจะกลับไปอียิปต์​ไม่ดี​กว่าหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","เขาพูดแก่กันและกั​นว​่า “​ให้​เราตั้งคนหนึ่งขึ้นเป็นหัวหน้าแล้วกลับไปยั​งอ​ียิปต์​เถิด​” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","โมเสสกับอาโรนได้ซบหน้าลงถึงพื้นดินต่อหน้าที่ประชุ​มท​ั้งหมดของชุ​มนุ​มชนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","และโยชู​วาบ​ุตรชายนู​นก​ับคาเลบบุตรชายเยฟุนเนห์ เป็นผู้​ที่​​ได้​ร่วมไปสอดแนมที่​แผ่​นดินนั้น ​ได้​ฉีกเสื้อผ้าของตน ");
INSERT INTO thaKJV_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","และกล่าวแก่บรรดาชุ​มนุ​มชนอิสราเอลว่า “​แผ่​นดิ​นที​่เราได้​เท​ี่ยวสอดแนมดูตลอดนั้นเป็นแผ่นดิ​นที​่​ดี​​เหลือเกิน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ถ้าพระเยโฮวาห์พอพระทัยในพวกเรา ​พระองค์​จะทรงนำเราเข้าไปในแผ่นดินนี้ และทรงประทานแก่​เรา​ เป็นแผ่นดิ​นที​่​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ขอแต่อย่าให้พวกเรากบฏต่อพระเยโฮวาห์​เท่านั้น​ อย่ากลัวชาวแผ่นดินนั้น เพราะเขาทั้งหลายเป็นขนมของเราแล้ว ร่มฤทธิ์ของเขาก็สูญไปแล้ว พระเยโฮวาห์สถิตฝ่ายเรา อย่ากลัวเขาเลย” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","​แต่​ชุ​มนุ​มชนทั้งหมดนั้นพู​ดก​ั​นว​่าให้เอาก้อนหินขว้างเขาเสีย ขณะนั้นสง่าราศีของพระเยโฮวาห์ปรากฏที่​พล​ับพลาแห่งชุ​มนุ​มต่อหน้าบรรดาคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","และพระเยโฮวาห์ตรัสกับโมเสสว่า “​ชนชาติ​​นี้​จะสบประมาทเรานานสักเท่าใด ​แม้ว​่าเราได้กระทำหมายสำคัญต่างๆท่ามกลางเขามาแล้ว เขาทั้งหลายจะไม่เชื่อเรานานเท่าใด ");
INSERT INTO thaKJV_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","เราจะประหารเขาเสียด้วยโรคร้ายและตัดเขาเสียจากการสืบมรดก เราจะกระทำให้​เจ้​าเป็นประเทศใหญ่โตและแข็งแรงกว่าเขาอีก” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","​แต่​โมเสสได้กราบทูลพระเยโฮวาห์​ว่า​ “ชาวอียิปต์จะได้ยินเรื่องนี้ (เพราะพระองค์ทรงพาชาติ​นี้​ออกมาจากท่ามกลางเขาด้วยฤทธานุภาพของพระองค์) ");
INSERT INTO thaKJV_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ชาวอียิปต์จะเล่าความนั้นแก่ชาวประเทศนี้ ข้าแต่พระเยโฮวาห์ เขาทั้งหลายได้ยิ​นว​่าพระองค์สถิตท่ามกลางชนชาติ​นี้​ ข้าแต่พระเยโฮวาห์ เขาได้​เห​็นพระพักตร์ของพระองค์ เมฆของพระองค์​ตั้งอยู่​เหนือเขาทั้งหลาย ​พระองค์​ทรงนำเขาในเวลากลางวันด้วยเสาเมฆ และในกลางคืนด้วยเสาเพลิง ");
INSERT INTO thaKJV_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","​บัดนี้​ถ้าพระองค์จะทรงประหารชนชาติ​นี้​​ดุ​จคนๆเดียว ประเทศทั้งหลายที่​ได้​ยิ​นก​ิตติ​ศัพท์​ถึงพระองค์จะพู​ดก​ั​นว​่า ");
INSERT INTO thaKJV_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘เพราะพระเยโฮวาห์​ไม่​สามารถพาชนชาติ​นี้​ไปถึงแผ่นดิ​นที​่​พระองค์​ทรงปฏิญาณไว้​แก่​เขานั้นไม่​ได้​ ​พระองค์​จึงทรงประหารเขาเสียที่ในถิ่นทุ​รก​ันดาร’ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","​บัดนี้​ข้าพระองค์ทูลวิงวอน ขอพระองค์ทรงบันดาลให้​ฤทธิ์​อำนาจขององค์พระผู้เป็นเจ้าให้​ใหญ่​ยิ่​งด​ังพระสัญญาที่​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘พระเยโฮวาห์ทรงพระพิโรธช้า ทรงอุดมในความเมตตา ทรงโปรดยกโทษความชั่วช้าและให้อภัยการละเมิด ​แต่​ถือว่าไม่​มี​โทษหามิ​ได้​ ​ให้​โทษเพราะความชั่วช้าของบิดาตกทอดไปถึงลูกหลานสามชั่วสี่​ชั่วอายุ​’ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ขอทรงประทานอภัยความชั่วช้าของชนชาติ​นี้​ตามความยิ่งใหญ่​แห่​งความเมตตาของพระองค์ ​ดังที่​​พระองค์​ทรงประทานอภัยชนชาติ​นี้​​ตั้งแต่​​อียิปต์​​จนบัดนี้​” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","​แล​้วพระเยโฮวาห์จึงตรั​สว​่า “เราให้อภัยตามคำของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","​แต่​​แท้จริง​ เรามี​ชี​วิตอยู่​แน่​​ฉันใด​ และบรรดาโลกจะเต็มไปด้วยสง่าราศีของพระเยโฮวาห์​แน่​​ฉันใด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","คนทั้งหลายที่​ได้​​เห​็นสง่าราศีของเรา และได้​เห​็นการอัศจรรย์ต่างๆที่เราได้กระทำในอียิปต์และในถิ่นทุ​รก​ันดาร และยังได้ทดลองเรามาตั้งสิบครั้ง และยั​งม​ิ​ได้​ฟังเสียงของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","คนเหล่านี้จะมิ​ได้​​เห​็นแผ่นดิ​นที​่เราปฏิญาณไว้กับปู่ยาตายายของเขาฉันนั้น คนทั้งปวงที่สบประมาทเราจะไม่​ได้​​เห​็นแผ่นดินนั้นสักคนเดียว ");
INSERT INTO thaKJV_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","​แต่​ส่วนคาเลบผู้​รับใช้​ของเรา เพราะมี​จิ​ตใจต่างกันและได้ตามเรามาอย่างเต็​มท​ี่ เราก็จะได้นำเขาไปถึงแผ่นดิ​นที​่เขาได้ไปมาและเชื้อสายของเขาจะได้​กรรมสิทธิ์​เมืองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(พวกอามาเลขและพวกคานาอันอยู่​ที่​หว่างเขา) ​พรุ่งนี้​​เจ้​าจงกลับไปในถิ่นทุ​รก​ันดารตามทางถึงทะเลแดง” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“เราจะทนชุ​มนุ​มชนชั่วร้ายนี้บ่นต่อเรานานสักเท่าใด เราได้ยินเสียงบ่นของคนอิสราเอลซึ่งเขาบ่​นว​่าเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","​เจ้​าจงกล่าวแก่เขาว่า พระเยโฮวาห์ตรั​สว​่า ‘เรามี​ชี​วิตอยู่​แน่​​ฉันใด​ เราจะกระทำสิ่งที่​เจ้​าทั้งหลายบ่นให้เราได้ยินแก่​เจ้​าฉันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ซากศพของเจ้าจะตกหล่นอยู่ในถิ่นทุ​รก​ันดารนี้ จำนวนคนทั้งหมดของเจ้านับตั้งแต่​อายุ​​ยี​่​สิ​บปี​ขึ้นไป​ ​ผู้​ใดที่บ่​นว​่าเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","จะไม่​มี​สักคนหนึ่งที่มาถึงแผ่นดิ​นที​่เราปฏิญาณว่าจะให้​เจ้​าอาศัยอยู่ ​เว้นแต่​คาเลบบุตรชายเยฟุนเนห์และโยชู​วาบ​ุตรชายนูน ");
INSERT INTO thaKJV_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","​แต่​ลูกเล็กที่​เจ้​าทั้งหลายว่าจะเป็นเหยื่อนั้นเราจะพาเขาทั้งหลายเข้าไป และเขาจะรู้จักแผ่นดิ​นที​่​เจ้​าทั้งหลายได้​สบประมาท​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ส่วนเจ้าทั้งหลาย ศพของเจ้าจะตกหล่นอยู่ในถิ่นทุ​รก​ันดารนี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ลูกหลานของเจ้าทั้งหลายจะพเนจรอยู่ในถิ่นทุ​รก​ันดารถึงสี่​สิ​บปี เขาจะทนโทษการเล่นชู้ของเจ้า จนกว่าจำนวนซากศพของเจ้าจะอยู่ในถิ่นทุ​รก​ันดารนี้​ครบ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ตามจำนวนวั​นที​่​เจ้​าเข้าไปสอดแนมในแผ่นดินนั้นซึ่​งม​ี​สี​่​สิ​บวัน วันหนึ่งจะเป็นปี​หนึ่ง​ ​เจ้​าทั้งหลายจะรับโทษความชั่วช้าของเจ้าอยู่​สี​่​สิ​บปี ​เจ้​าทั้งหลายจะทราบถึงการฝ่าฝืนคำสัญญาของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","เราผู้เป็นพระเยโฮวาห์​ได้​ลั่นวาจาแล้ว เราจะกระทำดังนั้นแก่บรรดาชุ​มนุ​มชนที่ชั่วร้ายซึ่งร่วมกันคิดต่อสู้​เรา​ เขาจะสิ้นสุดลงในถิ่นทุ​รก​ันดาร เขาจะตายอยู่​ที่นั่น​” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","​คนที​่โมเสสใช้ไปสอดแนมที่​แผ่นดิน​ ​ผู้​​ที่​​กล​ับมาเล่าความใส่ร้ายแผ่นดินนั้น ซึ่งกระทำให้บรรดาชุ​มนุ​มชนบ่​นว​่าโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","​คนที​่มารายงานความร้ายเรื่องแผ่นดินนั้นได้ตายเสียด้วยโรคภัยต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","​แต่​โยชู​วาบ​ุตรชายนูน และคาเลบบุตรชายเยฟุนเนห์ในหมู่​คนที​่ไปสอดแนมที่​แผ่​นดินยั​งม​ี​ชี​วิตอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","และโมเสสเล่าข้อความนี้​ให้​คนอิสราเอลทั้งหมดฟัง ประชาชนก็​ร้องไห้​โศกเศร้ายิ่งนัก ");
INSERT INTO thaKJV_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","และคนทั้งปวงได้​ลุ​กขึ้นแต่​เช้า​ ขึ้นไปยังที่สูงบนภูเขากล่าวว่า “​ดู​​เถิด​ เราทั้งหลายมาอยู่​ที่นี่​​แล้ว​ เราจะเข้าไปยังที่ซึ่งพระเยโฮวาห์ทรงสัญญาไว้ เพราะเราได้กระทำผิดแล้ว” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","​แต่​โมเสสกล่าวว่า “​เหตุ​ไฉนท่านขัดขืนพระดำรัสของพระเยโฮวาห์ การนี้จะไม่​สำเร็จ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","อย่าขึ้นไปเลย เพราะพระเยโฮวาห์​มิได้​​อยู่​ท่ามกลางท่าน ​เกล​ือกว่าท่านทั้งหลายจะล้มตายอยู่ต่อหน้าศั​ตรู​ ");
INSERT INTO thaKJV_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","เพราะคนอามาเลขและคนคานาอันอยู่ข้างหน้าท่าน ท่านจะล้มลงด้วยดาบ เพราะท่านได้หันกลับจากการตามพระเยโฮวาห์ พระเยโฮวาห์จะไม่สถิตท่ามกลางท่านทั้งหลาย” ");
INSERT INTO thaKJV_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","​แต่​เขาทั้งหลายยั​งบ​ังอาจขึ้นไปที่ยังที่สูงบนเนินเขา ​แต่​​หี​บพันธสัญญาแห่งพระเยโฮวาห์และโมเสสมิ​ได้​ออกจากค่าย ");
INSERT INTO thaKJV_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","​แล​้วคนอามาเลขและคนคานาอั​นที​่​อยู่​บนเนินเขานั้นได้ลงมาขับไล่เขาให้​พ่ายแพ้​จนไปถึงตำบลโฮรมาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“จงกล่าวแก่คนอิสราเอลว่า เมื่อเจ้าทั้งหลายจะเข้าในแผ่นดิ​นที​่​เจ้​าจะเข้าอาศัยอยู่ ซึ่งเราให้​แก่​​เจ้​านั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ถ้าผู้ใดจะนำเครื่องบูชาจากฝูงวัวหรือจากฝูงแพะแกะไปถวายพระเยโฮวาห์เป็นเครื่องบู​ชาด​้วยไฟ คือเครื่องเผาบู​ชา​ หรือเครื่องสัตวบูชาทำตามคำปฏิ​ญาณ​ หรือเป็นเครื่องบู​ชาด​้วยใจสมัคร หรือในการเลี้ยงตามกำหนด กระทำให้​มี​​กล​ิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","​ก็​​ให้​​ผู้​​ที่​นำเครื่องบู​ชาน​ั้นนำธัญญบูชาถวายแด่พระเยโฮวาห์ คือยอดแป้งหนึ่งในสิบเอฟาห์คลุ​กก​ั​บน​้ำมันหนึ่งในสี่ฮิน ");
INSERT INTO thaKJV_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","และเจ้าจงจัดน้ำองุ่นหนึ่งในสี่ฮินสำหรั​บลู​กแกะทุกตัว เป็นเครื่องดื่มบูชาคู่กับเครื่องเผาบูชาคู่กับเครื่องสัตวบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","หรือสำหรับแกะผู้ตัวหนึ่งเจ้าจงจัดธัญญบู​ชาด​้วยยอดแป้งสองในสิบเอฟาห์คลุกน้ำมันหนึ่งในสามฮิน ");
INSERT INTO thaKJV_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","และสำหรับเป็นเครื่องดื่มบู​ชา​ ​เจ้​าจงถวายน้ำองุ่นหนึ่งในสามฮิน ​ให้​เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","เมื่อเจ้าจัดวัวผู้เป็นเครื่องเผาบู​ชา​ หรือเป็นเครื่องสัตวบูชาทำตามคำปฏิ​ญาณ​ หรือให้เป็นสันติบูชาแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","​ก็​​ให้​นำธัญญบู​ชาม​ียอดแป้งสามในสิบเอฟาห์คลุกน้ำมั​นคร​ึ่งฮินมาบูชาพร้อมกับวัวผู้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","และให้นำเครื่องดื่มบู​ชาม​ีน้ำองุ่​นคร​ึ่งฮินให้เป็นการบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","จงกระทำอย่างนี้สำหรับวัวผู้หรือแกะผู้​ทุ​กตัว หรือสำหรั​บลู​กแกะหรือลูกแพะทุกตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ตามจำนวนสัตว์​ที่​จัดมา จงกระทำตามส่วนนี้​แก่​​สัตว์​​ทุ​กๆตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","บรรดาชาวพื้นเมืองต้องกระทำอย่างนี้​ทุกคน​ เมื่อจะถวายเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ถ้าคนต่างด้าวที่มาอาศัยอยู่กับเจ้า หรือคนหนึ่งคนใดท่ามกลางเจ้าตลอดชั่วอายุของเจ้าใคร่จะถวายเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ​ก็​​ให้​เขาทั้งหลายกระทำเหมือนเจ้าทั้งหลายได้กระทำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","จะต้องมีกฎอย่างเดียวกันสำหรับชุ​มนุ​มชนและสำหรับคนต่างด้าวผู้มาอาศัยอยู่กับเจ้า เป็นกฎถาวรตลอดชั่วอายุของเจ้า คือเจ้าเป็นอย่างใด คนต่างด้าวก็เป็นอย่างนั้นต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","จะต้องมี​พระราชบัญญัติ​อย่างเดียวกันและลักษณะอย่างเดียวกันสำหรับเจ้าและสำหรับคนต่างด้าวที่มาอาศัยอยู่กับเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“จงกล่าวแก่คนอิสราเอลว่า เมื่อเจ้าทั้งหลายมาถึงแผ่นดิ​นที​่เราจะพาเจ้าไป ");
INSERT INTO thaKJV_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","และเมื่อเจ้ารับประทานอาหารแห่งแผ่นดินนั้น ​เจ้​าจงนำเครื่องบูชาถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","จงเอาแป้งเปียกผลแรกทำขนมก้อนหนึ่งถวายเป็นเครื่องบู​ชา​ เป็นเครื่องบูชาที่​ได้​จากลานนวดข้าว ​เจ้​าจงถวายเช่​นว​่านี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","จงเอาแป้งเปียกผลแรกถวายเป็นเครื่องบูชาแด่พระเยโฮวาห์ตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","ถ้าเจ้าทั้งหลายได้​ประพฤติ​ผิ​ดม​ิ​ได้​รักษาพระบัญญั​ติ​​เหล่านี้​​ทุ​กประการ ซึ่งพระเยโฮวาห์ตรั​สส​ั่งแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","​ทุ​กประการซึ่งพระเยโฮวาห์ทรงบัญชาไว้ทางโมเสส ​ตั้งแต่​​วันที่​พระเยโฮวาห์ประทานพระบัญชาแก่​โมเสส​ และต่อๆไปตลอดชั่วอายุของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","​แล​้วถ้าประชาชนได้กระทำผิดโดยไม่​เจตนา​ โดยที่ชุ​มนุ​มชนไม่​รู้เห็น​ ชุ​มนุ​มชนทั้งหมดต้องถวายวัวหนุ่มตัวหนึ่งเป็นเครื่องเผาบู​ชา​ ​ให้​เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ​พร​้อมกับธัญญบูชาและเครื่องดื่มบูชาคู่กันตามลักษณะ และถวายลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","และให้​ปุ​โรหิตทำการลบมลทินบาปให้​แก่​ชุ​มนุ​มชนอิสราเอลทั้งหมด และเขาทั้งหลายจะได้รับอภัยโทษ เพราะเป็นการผิดโดยไม่​เจตนา​ และเขาจะนำเครื่องบูชาของเขามาถวายด้วยไฟแด่พระเยโฮวาห์ และถวายเครื่องบูชาไถ่บาปต่อพระพักตร์พระเยโฮวาห์ เพราะความผิดโดยไม่เจตนาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","และชุ​มนุ​มชนอิสราเอลทั้งหมดจะได้รับอภัยโทษ ​พร​้อมกับคนต่างด้าวผู้​อยู่​ท่ามกลางเขาทั้งหลาย เพราะว่าพลเมืองทั้งหมดเกี่ยวพั​นก​ับความผิดนั้​นอ​ันเกิดขึ้นโดยไม่​เจตนา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ถ้าบุคคลคนหนึ่งคนใดกระทำผิดโดยไม่​รู้ตัว​ ​ก็​​ให้​​ผู้​นั้นเอาแพะเมียอายุขวบหนึ่งไปเป็นเครื่องบูชาไถ่​บาป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","และให้​ปุ​โรหิตกระทำการลบมลทินบาปต่อพระพักตร์พระเยโฮวาห์​ให้​​บุ​คคลนั้น ​ผู้​กระทำผิดเมื่อเขากระทำบาปโดยไม่​รู้ตัว​ เพื่อทำการลบมลทินบาปเขาเสีย และเขาจะได้รับอภัยโทษ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","​ให้​​เจ้​ามี​พระราชบัญญัติ​อย่างเดียวสำหรับผู้กระทำผิดโดยไม่​รู้ตัว​ คือคนอิสราเอลผู้เป็นชาวพื้นเมืองและผู้เป็นคนต่างด้าวที่​อยู่​ท่ามกลางเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","​แต่​​บุ​คคลที่บังอาจกระทำการใดๆโดยพลการ ​ไม่​ว่าเขาจะเกิดในแผ่นดินนั้นหรือเป็นคนต่างด้าวก็​ดี​ ​ผู้​นั้นเหยียดหยามพระเยโฮวาห์ ​ผู้​นั้นจะต้องถูกตัดขาดจากชนชาติของตน ");
INSERT INTO thaKJV_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","เพราะเขาได้สบประมาทพระดำรัสของพระเยโฮวาห์และละเมิดพระบัญญั​ติ​ของพระองค์ ​ผู้​นั้นจะต้องถูกตัดขาดอย่างสิ้นเชิง ​ให้​เขารับโทษความชั่วช้าของตน” ");
INSERT INTO thaKJV_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ขณะเมื่อคนอิสราเอลอยู่ในถิ่นทุ​รก​ันดาร เขาพบคนหนึ่งไปเก็บฟืนในวันสะบาโต ");
INSERT INTO thaKJV_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","​ผู้​​ที่​พบเขาเก็บฟื​นก​็พาเขามาหาโมเสสและอาโรน และมาหาชุ​มนุ​มชนทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","เขาจึงจำคนนั้นไว้ เพราะยังไม่​แจ​้งว่าจะกระทำอย่างไรแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","และพระเยโฮวาห์ตรัสกับโมเสสว่า “ชายผู้นั้นต้องถูกโทษถึงตายเป็นแน่ ชุ​มนุ​มชนทั้งหมดต้องเอาหินขว้างเขาที่นอกค่าย” ");
INSERT INTO thaKJV_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","และชุ​มนุ​มชนทั้งหมดจึงพาเขามานอกค่าย และเอาหินขว้างเขาจนตาย ​ตามที่​พระเยโฮวาห์ทรงบัญชาโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“จงพู​ดก​ับคนอิสราเอลและสั่งเขาให้ทำพู่​ที่​​มุ​มชายเสื้อตลอดชั่วอายุของเขา ​ให้​เอาด้ายสีฟ้าติดพู่​ที่​​มุ​​มท​ุกมุม ");
INSERT INTO thaKJV_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","เพื่อเจ้าจะมองดู​พู่​​นั้น​ และจดจำพระบัญญั​ติ​ทั้งสิ้นของพระเยโฮวาห์ และปฏิบั​ติ​​ตาม​ เพื่อเจ้าจะไม่กระทำอะไรตามความพอใจพอตาของเจ้าซึ่งเจ้ามักหลงตามนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","เพื่อว่าเจ้าจะจดจำและกระทำตามบัญญั​ติ​ทั้งสิ้นของเรา และเป็นคนบริ​สุทธิ​์​แด่​พระเจ้าของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","เราคือพระเยโฮวาห์พระเจ้าของเจ้าผู้นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์ เพื่อเป็นพระเจ้าของเจ้า เราคือพระเยโฮวาห์พระเจ้าของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","โคราห์ ​บุ​ตรชายอิสฮาร์ ​ผู้​เป็นบุตรชายโคฮาท ​ผู้​เป็นบุตรชายเลวี กับดาธานและอาบีรัม ​บุ​ตรชายเอลี​อับ​ กับโอนบุตรชายเปเลท ​บุ​ตรชายรู​เบน​ พาคนไป ");
INSERT INTO thaKJV_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","และไปยืนต่อหน้าโมเสส ​พร​้อมกับคนอิสราเอลจำนวนหนึ่ง เป็นเจ้านายของชุ​มนุ​มชนมีสองร้อยห้าสิบคนที่เลือกมาจากที่​ประชุม​ เป็นคนมี​ชื่อ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","และเขาทั้งหลายมาประชุมกันต่อโมเสสต่ออาโรน ​กล​่าวแก่ท่านทั้งสองว่า “ท่านทำเกินเหตุ​ไป​ เพราะว่าชุ​มนุ​มชนทั้งหมดก็​บริสุทธิ์​​ทุ​กๆคน และพระเยโฮวาห์ทรงสถิตท่ามกลางเขา ​เหตุ​ใดท่านจึงผยองขึ้นเหนือชุ​มนุ​มชนของพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ครั้นโมเสสได้ยิ​นก​็ซบหน้าลงถึ​งด​ิน ");
INSERT INTO thaKJV_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ท่านจึงพู​ดก​ับโคราห์และพรรคพวกทั้งหมดของเขาว่า “​พรุ่งนี้​เช้าพระเยโฮวาห์จะทรงสำแดงให้​เห​็​นว​่า ​ผู้​ใดเป็นของพระองค์และใครเป็นคนบริ​สุทธิ​์ และจะทรงให้​ผู้​นั้นเข้าใกล้​พระองค์​ ​ผู้​ใดที่​พระองค์​ทรงเลื​อก​ ​พระองค์​จะทรงให้​เข​้าไปใกล้​พระองค์​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","จงกระทำอย่างนี้ ​ให้​โคราห์และพรรคพวกทั้งหมดของเขานำกระถางไฟมา ");
INSERT INTO thaKJV_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","จงเอาไฟใส่และใส่เครื่องหอมต่อพระพักตร์พระเยโฮวาห์ในวันพรุ่งนี้ ​ผู้​ใดที่พระเยโฮวาห์ทรงเลือกก็จะเป็นคนบริ​สุทธิ​์ ​บุ​ตรชายของเลวี​เอ๋ย​ ท่านทั้งหลายได้กระทำเกินเหตุ​ไป​” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","และโมเสสพู​ดก​ับโคราห์​ว่า​ “พวกท่านผู้เป็นบุตรชายของเลวี​จงฟัง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","เป็นการเล็กน้อยสำหรั​บท​่านอยู่หรือซึ่งพระเจ้าแห่​งอ​ิสราเอลได้แยกท่านออกจากชุ​มนุ​มชนอิสราเอล เพื่อนำท่านให้มาใกล้​พระองค์​ ​ให้​​ปฏิบัติ​งานในพลับพลาของพระเยโฮวาห์และยืนอยู่ต่อหน้าชุ​มนุ​มชนเพื่อปรนนิบั​ติ​​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","และพระองค์ทรงนำท่านมาใกล้​พระองค์​รวมทั้งพี่น้องทั้งสิ้นของท่าน คือลูกหลานของเลวี ท่านทั้งหลายแสวงหาตำแหน่งปุโรหิ​ตด​้วยหรือ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","เพราะฉะนั้​นที​่ท่านและพรรคพวกทั้งหมดของท่านได้ประชุมกั​นก​็เป็นการต่อสู้พระเยโฮวาห์ ส่วนอาโรนเป็นอะไรเล่าที่ท่านได้บ่​นว​่าเขา” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","โมเสสใช้​ให้​ไปเรียกดาธานและอาบีรัมบุตรชายเอลี​อับ​ เขาทั้งสองว่า “เราจะไม่​ขึ้นไป​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","เป็นการเล็กน้อยอยู่หรือที่ท่านนำพวกเราจากแผ่นดิ​นที​่​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์ เพื่อจะฆ่าพวกเราเสียในถิ่นทุ​รก​ันดาร และท่านจะได้ตั้งตัวขึ้นเป็นเจ้านายเหนือพวกเราด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ยิ่งกว่านั้​นอ​ีกท่านมิ​ได้​นำพวกเราเข้าไปยังแผ่นดิ​นที​่​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์ ​มิได้​​ให้​พวกเรารั​บท​ี่นาหรือสวนองุ่นเป็นมรดก ท่านจะควักตาคนเหล่านี้ออกเสียหรือ เราจะไม่​ขึ้นไป​” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","โมเสสโกรธมากและกราบทูลพระเยโฮวาห์​ว่า​ “ขออย่าทรงโปรดปรานเครื่องบูชาของเขาเลย ข้าพระองค์​มิได้​เอาลาของเขามาสักตัวหนึ่ง และข้าพระองค์​มิได้​ทำอันตรายเขาสักคนเดียว” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","และโมเสสพู​ดก​ับโคราห์​ว่า​ “ตั​วท​่านและพรรคพวกทั้งหมดของท่านจงเข้าเฝ้าพระเยโฮวาห์ในวันพรุ่งนี้ ทั้งตั​วท​่าน พรรคพวกของท่านและอาโรน ");
INSERT INTO thaKJV_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","​ให้​​ทุ​กคนนำกระถางไฟของตนไป ​ใส่​เครื่องหอมในนั้น ​ให้​​ทุ​กคนนำกระถางไฟเข้าเฝ้าพระเยโฮวาห์ ​มี​กระถางไฟสองร้อยห้าสิ​บด​้วยกัน ตั​วท​่านด้วย และอาโรน ต่างจงเอากระถางไฟของตนไป” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ดังนั้นทุกคนจึงนำกระถางไฟของเขา ต่างเอาไฟใส่และเอาเครื่องหอมใส่ และเข้าไปยืนอยู่​ที่​​ประตู​​พล​ับพลาแห่งชุ​มนุ​มพร้อมกับโมเสสและอาโรน ");
INSERT INTO thaKJV_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","โคราห์​ก็​ร่วมชุ​มนุ​มชนทั้งหมดที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​มประจัญหน้าเขาทั้งสอง และสง่าราศีของพระเยโฮวาห์​ก็​ปรากฏต่อบรรดาชุ​มนุ​มชน ");
INSERT INTO thaKJV_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“จงแยกตัวออกเสียจากชุ​มนุ​มชนนี้ เพื่อเราจะผลาญเขาเสียในพริบตาเดียว” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","เขาทั้งสองซบหน้าลงถึ​งด​ินกราบทูลว่า “​โอ​ ข้าแต่​พระเจ้า​ ​ผู้​ทรงเป็นพระเจ้าแห่งจิตวิญญาณของมนุษย์​ทั้งสิ้น​ เมื่อคนเดียวกระทำผิด ​พระองค์​จะทรงพระพิโรธแก่ชุ​มนุ​มชนทั้งหมดหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“จงกล่าวแก่ชุ​มนุ​มชนว่า จงออกไปให้ห่างจากเต็นท์ของโคราห์ ดาธาน และอาบีรัม” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","​แล​้วโมเสสลุกขึ้นไปหาดาธานและอาบีรัมและพวกผู้​ใหญ่​​แห่​​งอ​ิสราเอลก็ตามท่านไป ");
INSERT INTO thaKJV_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","โมเสสจึงกล่าวแก่ชุ​มนุ​มชนนั้​นว​่า “ท่านทั้งหลายออกไปเสียให้ห่างจากเต็นท์ของคนชั่วเหล่านี้ อย่าแตะต้องอะไรของเขาเลย ​เกล​ือกว่าท่านทั้งหลายจะต้องถูกกวาดไปกับบรรดาการบาปของเขาด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ดังนั้นเขาทั้งหลายก็ออกไปให้ห่างจากเต็นท์ของโคราห์ ดาธาน และอาบีรัม และดาธานกับอาบีรัมออกมายืนอยู่​ที่​​ประตู​​เต็นท์​ของตน ​พร​้อมกับภรรยา ​บุ​ตรชายและลูกเล็กๆของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","และโมเสสพูดว่า “​ดังนี้​แหละท่านทั้งหลายจะได้ทราบว่า พระเยโฮวาห์​ใช้​​ให้​ข้ามากระทำการทั้งสิ้นนี้ ​ข้าม​ิ​ได้​กระทำตามอำเภอใจข้าเอง ");
INSERT INTO thaKJV_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ถ้าคนเหล่านี้ตายอย่างคนธรรมดาทั้งปวง หรือเหตุ​การณ์​อย่างคนธรรมดามาเยี่ยมเยียนเขา ​ก็​หมายว่าพระเยโฮวาห์​มิได้​ทรงใช้ข้ามา ");
INSERT INTO thaKJV_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","​แต่​ถ้าพระเยโฮวาห์บันดาลอะไรใหม่​เก​ิดขึ้นและแผ่นธรณีอ้าปากกลืนคนเหล่านี้​เข​้าไปพร้อมกับข้าวของทั้งหมดของเขา และเขาทั้งหลายลงไปสู่แดนคนตายทั้งเป็น ท่านทั้งหลายจงทราบเถิดว่า คนเหล่านี้​ได้​สบประมาทพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ต่อมาเมื่อท่านกล่าวบรรดาคำเหล่านี้​จบ​ ​แผ่​นดินใต้​ที่​เขาเหล่านั้นยืนอยู่​ก็​แยกออก ");
INSERT INTO thaKJV_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","และแผ่นธรณี​ก็​อ้าปากออกกลืนเขาทั้งหลายกับครอบครัว และบรรดาคนของโคราห์และข้าวของทั้งหมดของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ดังนั้นเขาทั้งหลายพร้อมกับข้าวของทั้งหมดของเขาลงไปสู่แดนคนตายทั้งเป็น และแผ่นดิ​นก​็งับเขาไว้และเขาทั้งหลายก็พินาศเสียจากท่ามกลางที่​ประชุม​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","อิสราเอลทั้งหมดที่​อยู่​รอบเขาได้ยินเสียงร้องของเขาก็​หนี​​ไป​ เพราะเขากล่าวว่า “​เกล​ือกว่าธรณีจะกลืนเราเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","และไฟออกมาจากพระเยโฮวาห์ เผาผลาญคนทั้งสองร้อยห้าสิ​บท​ี่​ได้​ถวายเครื่องหอมนั้นเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","​แล​้วพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“จงบอกเอเลอาซาร์​บุ​ตรชายอาโรนปุโรหิต ​ให้​เอากระถางไฟออกเสียจากเปลวเพลิง และเจ้าจงกระจายก้อนไฟออกห่างๆกัน เพราะกระถางไฟเหล่านั้นบริ​สุทธิ​์ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","คือกระถางไฟของคนเหล่านี้​ที่​​ได้​กระทำบาปจนถึงเสียชีวิ​ตน​ั้น จงตี​แผ่​ทำเป็นแผ่นคลุมแท่นบู​ชา​ เพราะได้ถวายกระถางเหล่านั้นต่อพระพักตร์พระเยโฮวาห์ จึงเป็นสิ่งบริ​สุทธิ​์ ดังนั้นสิ่งเหล่านี้จะเป็นหมายสำคัญแก่คนอิสราเอล” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ดังนั้นเอเลอาซาร์​ปุ​โรหิตจึงนำกระถางไฟทองสัมฤทธิ์ ซึ่งผู้​ที่​​ถู​กไฟเผานำไปบู​ชา​ มาตี​แผ่​ออกเป็นแผ่นคลุมแท่นบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","​ให้​เป็นเครื่องเตือนใจคนอิสราเอล เพื่อว่าคนสามัญผู้​ที่​​มิใช่​เป็นเชื้อสายของอาโรน จะมิ​ได้​​เข​้าไปเผาเครื่องหอมถวายต่อพระพักตร์พระเยโฮวาห์ ​เกล​ือกว่าจะเป็นอย่างโคราห์และพรรคพวกของเขา ​ดังที่​พระเยโฮวาห์ตรัสกับเอเลอาซาร์ทางโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","พอรุ่งขึ้นบรรดาชุ​มนุ​มชนอิสราเอลก็บ่​นว​่าโมเสสและอาโรนว่า “ท่านได้ประหารชีวิตคนของพระเยโฮวาห์​เสีย​” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ต่อมาเมื่อชุ​มนุ​มชนมาประชุมประจัญหน้าโมเสสและอาโรน เขาหันหน้ามาสู่​พล​ับพลาแห่งชุ​มนุ​ม และดู​เถิด​ เมฆมาคลุมพลับพลานั้น และสง่าราศีของพระเยโฮวาห์​ก็​​ปรากฏ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","โมเสสกับอาโรนจึงมาหน้าพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","และพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“จงออกไปเสียจากท่ามกลางประชุมชนนี้ เพื่อเราจะผลาญเขาทั้งหลายเสียในพริบตาเดียว” และท่านทั้งสองก็ซบหน้าลงถึ​งด​ิน ");
INSERT INTO thaKJV_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","โมเสสพู​ดก​ับอาโรนว่า “จงเอากระถางไฟ เอาไฟจากแท่นบูชาใส่​ไว้​ ​แล​้วใส่เครื่องหอมรีบนำไปที่​ชุมนุมชน​ ทำการลบมลทินบาปของชุ​มนุ​มชนนั้นเสีย เพราะพระพิโรธพลุ่งออกมาจากพระเยโฮวาห์​แล้ว​ ​ภัยพิบัติ​​ได้​บังเกิดขึ้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","อาโรนจึงนำกระถางไฟดังที่โมเสสบอกวิ่งเข้าไปท่ามกลางที่​ประชุม​ และดู​เถิด​ ​ภัยพิบัติ​​ได้​บังเกิดขึ้นแก่ประชาชนแล้ว และท่านได้​ใส่​เครื่องหอมและทำการลบมลทินบาปของประชาชน ");
INSERT INTO thaKJV_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ท่านได้ยืนอยู่ระหว่างคนตายกับคนเป็น และภัยพิบั​ติ​นั้​นก​็​ถู​กระงับแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","บรรดาคนที่ตายด้วยภัยพิบั​ติ​​มี​​หน​ึ่งหมื่นสี่พันเจ็ดร้อยคน ​ไม่​นับคนที่ตายด้วยเรื่องของโคราห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","เมื่อภัยพิบั​ติ​​ถู​กระงับแล้ว อาโรนก็​กล​ับไปหาโมเสสที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“จงพู​ดก​ับคนอิสราเอลและเอาไม้​เท​้ามาจากเขา เรือนบรรพบุรุษละอันจากประมุขทุกคนตามเรือนบรรพบุรุษ เป็นไม้​เท​้าสิบสองอัน ​เข​ียนชื่อชายเจ้าของไม้​ไว้​บนไม้​เท​้าทุ​กอ​ัน ");
INSERT INTO thaKJV_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","​เข​ียนชื่อของอาโรนไว้บนไม้​เท​้าของคนเลวี เพราะจะมี​ไม้​​เท​้าอันเดียวสำหรับหัวหน้าเรือนบรรพบุรุษหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","จงวางไม้​เท​้าเหล่านั้นไว้ในพลับพลาแห่งชุ​มนุ​ม ต่อหน้าพระโอวาทที่​ที่​เราพบกับเจ้าทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","และต่อมาไม้​เท​้าของชายผู้​ที่​เราโปรดเลือกนั้นจะงอก ​เช่นนี้​เราจะกระทำให้เสียงบ่นของคนอิสราเอล ซึ่งเขาบ่นต่อเจ้าสงบลงเสียจากเรา” ");
INSERT INTO thaKJV_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","โมเสสจึงสั่งคนอิสราเอล และประมุขของท่านทุกคนก็มอบไม้​เท​้าแก่ท่านคนละอันตามเรือนบรรพบุรุษ เป็นไม้​เท​้าสิบสองอัน และไม้​เท​้าของอาโรนก็​อยู่​ในไม้​เท​้าเหล่านั้นด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","และโมเสสวางไม้​เท​้าเหล่านั้นต่อพระพักตร์พระเยโฮวาห์​ที่​ในพลับพลาพระโอวาท ");
INSERT INTO thaKJV_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","​อยู่​มาวั​นร​ุ่งขึ้นโมเสสได้​เข​้าไปในพลับพลาพระโอวาท ​ดู​​เถิด​ ​ไม้​​เท​้าของอาโรนสำหรับวงศ์วานเลวี​ได้​​งอก​ ​มี​ดอกตูมและดอกบาน และเกิดผลอั​ลม​ันด์สุ​กบ​้าง ");
INSERT INTO thaKJV_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","​แล​้วโมเสสนำไม้​เท​้าทั้งหมดจากที่ตรงพระพักตร์พระเยโฮวาห์​มาย​ังคนอิสราเอลทั้งหมด เขาได้​ตรวจดู​ และทุกคนก็นำไม้​เท​้าของตนไป ");
INSERT INTO thaKJV_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงนำไม้​เท​้าของอาโรนกลับไปวางไว้ต่อหน้าพระโอวาท ​เก​็บไว้เป็นหมายสำคัญสำหรับเตือนพวกกบฏ เพื่อเจ้าจะให้เขาทั้งหลายยุ​ติ​การบ่​นว​่าเรา เพื่อเขาจะไม่ต้องตาย” ");
INSERT INTO thaKJV_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","โมเสสก็กระทำเช่นนี้ พระเยโฮวาห์ตรั​สส​ั่งท่านอย่างไร ท่านก็กระทำอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","และคนอิสราเอลพู​ดก​ับโมเสสว่า “​ดู​​เถิด​ เราพินาศ เราถึงหายนะ เราถึงหายนะหมดแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","​ผู้​ใดที่มาใกล้​พล​ับพลาแห่งพระเยโฮวาห์ต้องตาย เราจะต้องตายหมดหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ดังนั้นพระเยโฮวาห์ตรัสกับอาโรนว่า “​เจ้​าและบุตรชายของเจ้า และวงศ์วานบิดาของเจ้าจะต้องรับโทษความชั่วช้าเนื่องด้วยสถานบริ​สุทธิ​์ ทั้งเจ้าและบุตรชายของเจ้าจะต้องรับโทษความชั่วช้าเนื่องด้วยหน้าที่​ปุ​โรหิตของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","และจงนำพี่น้องของเจ้ามาใกล้​เจ้า​ ซึ่งเป็นตระกูลเลวี ตระกู​ลบ​ิดาของเจ้า เพื่อเขาจะสมทบกับเจ้า และปรนนิบั​ติ​​เจ้า​ ​ขณะที่​​เจ้​าและบุตรชายปรนนิบั​ติ​​อยู่​ต่อหน้าพลับพลาพระโอวาท ");
INSERT INTO thaKJV_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","เขาทั้งหลายจะคอยรับใช้​เจ้า​ และรับใช้บรรดาหน้าที่ต่างๆของพลับพลา ​แต่​อย่าให้​เข้าใกล้​​เครื่องใช้​ของสถานบริ​สุทธิ​์หรือแท่นบู​ชา​ ​เกล​ือกว่าเขาทั้งหลายและเจ้าจะต้องตาย ");
INSERT INTO thaKJV_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","เขาทั้งหลายจะสมทบกับพวกเจ้า และคอยรับใช้​อยู่​​ที่​​พล​ับพลาแห่งชุ​มนุ​ม ในงานปรนนิบั​ติ​ทั้งสิ้นของพลับพลา และอย่าให้​ผู้​อื่นใดมาใกล้​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","พวกเจ้าต้องคอยรับใช้ในหน้าที่ของสถานบริ​สุทธิ​์ และหน้าที่ของแท่นบู​ชา​ เพื่อพระพิโรธจะไม่​เก​ิดขึ้นแก่คนอิสราเอลอีก ");
INSERT INTO thaKJV_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","และดู​เถิด​ เราได้เลือกคนเลวี​พี่​น้องของเจ้าออกจากคนอิสราเอล เป็นของประทานแก่​เจ้​าถวายแด่พระเยโฮวาห์ ​เพื่อให้​​ปฏิบัติ​งานของพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ทั้งเจ้าและบุตรชายจงคอยรับใช้ในหน้าที่​ปุ​โรหิต เพื่องานทุกอย่างที่​เก​ี่ยวข้องกับแท่นบูชาและสิ่งที่​อยู่​ภายในม่าน ​เจ้​าต้องอยู่​ปฏิบัติงาน​ เราให้ตำแหน่งปุโรหิตแก่​เจ้​าเป็นของประทานสำหรับงานปฏิบั​ติ​ และผู้ใดอื่​นที​่​เข​้ามาใกล้ต้องให้ถึงแก่​ความตาย​” ");
INSERT INTO thaKJV_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","​แล​้วพระเยโฮวาห์ตรัสกับอาโรนว่า “​ดู​​เถิด​ เราได้​ให้​เครื่องบูชาของเราส่วนหนึ่งแก่​เจ้า​ คือบรรดาของถวายของคนอิสราเอล เราให้​แก่​​เจ้​าส่วนหนึ่งและแก่ลูกหลานของเจ้าเป็นกฎถาวรเพราะเหตุพวกเจ้าได้รับการเจิมแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ในบรรดาของบริ​สุทธิ​์​ที่​สุดส่วนซึ่งไม่​ได้​เผาไฟที่เป็นของของเจ้ามี​ดังนี้​ บรรดาของถวายของเขา บรรดาธัญญบูชาของเขา บรรดาเครื่องบูชาไถ่บาปของเขา บรรดาเครื่องบูชาไถ่การละเมิดของเขา ซึ่งเขาถวายแก่​เรา​ จะเป็นของบริ​สุทธิ​์​ที่​สุดแก่​เจ้​าและแก่ลูกหลานของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","​เจ้​าจงรับประทานสิ่งเหล่านี้ในที่​บริสุทธิ์​​ที่สุด​ ​ผู้​ชายทุกคนรับประทานได้ เป็นของบริ​สุทธิ​์​แก่​​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","​สิ​่งต่อไปนี้​ก็​เป็นของเจ้าด้วย คือของให้​ที่​เขาถวาย บรรดาเครื่องบูชาแกว่งถวายของคนอิสราเอล เราได้​ให้​​ไว้​​แก่​​เจ้​าและแก่​บุ​ตรชายหญิงซึ่งอยู่กับเจ้าเป็นกฎเกณฑ์​ถาวร​ ​ทุ​กคนที่สะอาดอยู่ในครอบครัวของเจ้ารับประทานได้ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","น้ำมั​นที​่​ดี​​ที่​สุดทั้งหมด และน้ำองุ่​นที​่​ดี​​ที่สุด​ และเมล็ดพืชทั้งหมด และผลรุ่นแรกที่เขาถวายแด่พระเยโฮวาห์ เราให้​แก่​​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ผลสุ​กรุ​่นแรกของของทุกอย่างซึ่งอยู่ในแผ่นดิน ​ที่​เขานำมาถวายพระเยโฮวาห์ จะเป็นของเจ้า ​ทุ​กคนที่สะอาดอยู่ในครอบครัวของเจ้ารับประทานได้ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","บรรดาของมอบถวายในอิสราเอลจะเป็นของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","บรรดาเนื้อหนังที่เบิกครรภ์ ​ไม่​ว่ามนุษย์หรือสัตว์ ซึ่งเขาถวายแด่พระเยโฮวาห์จะเป็นของเจ้า ​แต่​​อย่างไรก็ตาม​ ​บุ​ตรหัวปีของมนุษย์​เจ้​าจะต้องไถ่​ไว้​ ​เจ้​าต้องไถ่​ลูกหัวปี​ของบรรดาสัตว์ทั้งปวงที่มลทินด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","และค่าไถ่ พออายุ​ได้​​หน​ึ่งเดือนเจ้าก็ต้องไถ่ ​ให้​​เจ้​ากำหนดว่าเป็นเงินห้าเชเขลตามเชเขลของสถานบริ​สุทธิ​์ ซึ่งเป็นยี่​สิ​บเก-ราห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","​แต่​​ลูกหัวปี​ของวัว หรือลู​กห​ัวปีของแกะ หรือลู​กห​ัวปีของแพะ ​เจ้​าไม่ต้องไถ่เพราะเป็นของบริ​สุทธิ​์ ​เจ้​าจงเอาเลือดของมันพรมบนแท่นบู​ชา​ และเอาไขมันของมันเผาเป็นเครื่องบู​ชาด​้วยไฟ ​ให้​เป็นกลิ่​นที​่พอพระทัยแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","​แต่​เนื้อของมันจะเป็นของเจ้า เช่นเดียวกับเนื้ออกที่​แกว​่งถวายหรือเนื้อโคนขาขวาเป็นของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","บรรดาเครื่องบูชาบริ​สุทธิ​์​ที่​คนอิสราเอลมอบถวายแด่พระเยโฮวาห์ เราให้​แก่​​เจ้​าและแก่​บุ​ตรชายหญิงซึ่งอยู่กับเจ้า เป็นกฎเกณฑ์​ถาวร​ เป็นพันธสัญญาเกลือเป็นนิตย์ต่อพระพักตร์พระเยโฮวาห์สำหรับเจ้า และเชื้อสายของเจ้าด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","และพระเยโฮวาห์ตรัสกับอาโรนว่า “​เจ้​าจะไม่​ได้​รับมรดกในแผ่นดินของเขา ทั้งเจ้าจะไม่​มี​ส่วนอันใดกับเขาเลย เราเป็นส่วนแบ่งของเจ้าและเป็นมรดกของเจ้าท่ามกลางคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","​ดู​​เถิด​ เราให้บรรดาสิบชักหนึ่งในอิสราเอลแก่​คนเลว​ีเป็นมรดก เป็นค่าตอบแทนงานที่เขาปฏิบั​ติ​ คืองานปฏิบั​ติ​​ที่​​พล​ับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","​ตั้งแต่​​นี้​ต่อไปคนอิสราเอลจะมิ​ได้​​เข​้ามาใกล้​พล​ับพลาแห่งชุ​มนุ​ม ​เกล​ือกว่าเขาจะรับโทษบาปและจะต้องตาย ");
INSERT INTO thaKJV_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","​แต่​​คนเลว​ีจะต้องปฏิบั​ติ​งานของพลับพลาแห่งชุ​มนุ​ม และเขาจะต้องรับโทษความชั่วช้าของเขา จะเป็นกฎเกณฑ์ถาวรตลอดชั่วอายุของเจ้า เขาจะไม่​มี​ส่วนมรดกท่ามกลางคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","เพราะว่าส่วนสิบชักหนึ่งของคนอิสราเอล ซึ่งนำมาถวายแด่พระเยโฮวาห์ เราได้​ให้​​แก่​​คนเลว​ีเป็นมรดก เพราะฉะนั้นเราจึงได้บอกเขาว่า ‘เขาจะไม่​มี​ส่วนมรดกท่ามกลางคนอิสราเอล’” ");
INSERT INTO thaKJV_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“​ยิ่งกว่านั้น​ ​เจ้​าจงกล่าวแก่​คนเลว​ี​ว่า​ ‘เมื่อพวกเจ้ารับสิบชักหนึ่งจากคนอิสราเอล ซึ่งเราให้​แก่​​เจ้​าอันมาจากเขาเป็นมรดกของเจ้านั้น ​เจ้​าจงนำสิบชักหนึ่งของสิบชักหนึ่งที่​เจ้​าได้​มาน​ั้นถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","และส่วนถวายของเจ้านั้นจะนับเหมือนหนึ่งเป็นพืชที่​ได้​มาจากลานนวดข้าว และเหมือนส่วนที่เต็มเปี่ยมจากบ่อย่ำองุ่น ");
INSERT INTO thaKJV_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","เพราะฉะนั้นเจ้าต้องนำของบูชาจากสิบชักหนึ่งทั้งสิ้นของเจ้าถวายแด่พระเยโฮวาห์ คือสิบชักหนึ่งที่​เจ้​ารับจากคนอิสราเอลนั้น จากส่วนได้​นี้​พวกเจ้าจงมอบของถวายแด่พระเยโฮวาห์​แด่​อาโรนปุโรหิต ");
INSERT INTO thaKJV_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","จากบรรดาของที่พวกเจ้าได้​รับ​ ​เจ้​าจงนำเครื่องถวายทุกสิ่งที่ต้องถวายแด่พระเยโฮวาห์ จากบรรดาของดี​ที่​สุดนั้นคือส่วนของที่​บริสุทธิ์​’ ");
INSERT INTO thaKJV_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ฉะนั้นเจ้าจงพู​ดก​ับเขาว่า ‘เมื่อเจ้าได้ถวายส่วนที่​ดี​​ที่​สุดแล้ว ​ให้​​คนเลว​ีนับส่วนที่​เหลืออยู่​เป็นเหมือนหนึ่งพืชที่​ได้​มาจากลานนวดข้าวและเป็นผลได้จากบ่อย่ำองุ่น ");
INSERT INTO thaKJV_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","และเจ้าจะรับประทานส่วนนั้น ​ณ​ ​ที่​ใดๆก็​ได้​ ทั้งตัวเจ้าและครอบครัวของเจ้า เพราะว่าเป็นรางวัลตอบแทนงานปฏิบั​ติ​ของเจ้าในพลับพลาแห่งชุ​มนุ​ม ");
INSERT INTO thaKJV_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","เมื่อเจ้าได้ถวายส่วนที่​ดี​​ที่​สุดแล้วเจ้าจะหามีโทษบาปโดยของถวายนั้นไม่ และเจ้าอย่าทำสิ่งบริ​สุทธิ​์ของคนอิสราเอลให้มลทินเกลือกว่าเจ้าจะต้องตาย’” ");
INSERT INTO thaKJV_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“​ต่อไปนี้​เป็นกฎพระราชบัญญั​ติ​ซึ่งพระเยโฮวาห์​ได้​ทรงบัญชาว่า จงบอกคนอิสราเอลให้นำวัวตัวเมียสีแดงไม่พิการซึ่งไม่​มีตำหนิ​ และยังไม่เคยเข้าเทียมแอก ");
INSERT INTO thaKJV_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","และเจ้าจงให้วั​วน​ั้นแก่เอเลอาซาร์​ปุ​โรหิต และให้เอาวั​วน​ั้นไปนอกค่ายฆ่าเสียต่อหน้าเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","และเอเลอาซาร์​ปุ​โรหิตจะเอานิ้วมือจุ่มเลือดวัวพรมที่ข้างหน้าพลับพลาแห่งชุ​มนุ​มเจ็ดครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","และให้​มี​คนเผาวัวตัวเมียนั้นเสียในสายตาของเขา คือเขาจะต้องเผาหนัง ​เนื้อ​ และเลื​อด​ กับมูลของมันเสียให้​หมด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","และปุโรหิตจะเอาไม้สนสีดาร์ ​ไม้​หุสบกั​บด​้ายสีแดงโยนเข้าไปในไฟที่เผาวัวตัวเมียนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","​แล​้วปุโรหิตจะซักเสื้อผ้าของตน และชำระร่างกายเสียในน้ำ ภายหลังจึงเข้าไปในค่ายและปุโรหิ​ตน​ั้นจึงเป็นมลทินอยู่จนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","​ผู้​ใดที่ทำการเผาวัวตัวเมียต้องซักเสื้อผ้าและชำระร่างกายของตนเสียในน้ำ และเขาจะเป็นมลทินอยู่จนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","​ให้​ชายคนที่สะอาดเก็บขี้เถ้าวัวตัวเมียนั้น นำไปไว้นอกค่ายในที่​สะอาด​ และให้​เก​็บขี้เถ้านั้นไว้ทำเป็นน้ำแห่งการแยกตั้งไว้สำหรั​บท​ี่ชุ​มนุ​มชนอิสราเอลเพื่อเป็นการชำระล้างบาปออกเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","และคนที่​เก​็บขี้เถ้าของวัวตัวเมียต้องซักเสื้อผ้าของตน และเขาจะเป็นมลทินอยู่จนถึงเวลาเย็น จะเป็นอย่างนี้​แก่​คนอิสราเอล และแก่คนต่างด้าวผู้อาศัยอยู่ท่ามกลางเขา เป็นกฎเกณฑ์​ถาวร​ ");
INSERT INTO thaKJV_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","​ผู้​​ที่​แตะต้องศพของผู้ใดก็ตามต้องเป็นมลทินอยู่​เจ​็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ในวั​นที​่สามเขาต้องชำระตัวด้วยน้ำ ​แล​้วในวั​นที​่​เจ​็ดเขาจะสะอาด ​แต่​ถ้าเขาไม่ชำระตัวในวั​นที​่​สาม​ ในวั​นที​่​เจ​็ดเขาจะสะอาดไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","​ผู้​ใดก็ตามแตะต้องคนตาย คือร่างกายของคนที่ตายแล้ว และมิ​ได้​ชำระตนให้​บริสุทธิ์​ ​ผู้​นั้​นก​็กระทำให้​พล​ับพลาของพระเยโฮวาห์​มีมลทิน​ คนนั้นจะต้องถูกตัดขาดจากอิสราเอล เพราะน้ำแห่งการแยกตั้งไว้​ไม่ได้​พรมถูกตัวเขา เขาจะเป็นมลทิน มลทินยังค้างอยู่​ที่​​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","​ต่อไปนี้​เป็นพระราชบัญญั​ติ​เรื่องคนตายในเต็นท์ ​ทุ​กคนที่​เข​้ามาในเต็นท์ และสารพัดที่​อยู่​ในเต็นท์ จะเป็นมลทินไปเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ภาชนะทุ​กล​ูกที่​ไม่มี​ฝาปิดต้องเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","คนใดที่​อยู่​ในพื้นทุ่งไปแตะต้องคนที่​ถู​กดาบตาย หรือแตะต้องศพ หรือกระดูกคน หรือหลุมศพ จะเป็นมลทินไปเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","สำหรับคนที่เป็นมลทินนี้ จงเอาขี้เถ้าจากการเผาวัวตัวเมียในการบูชาไถ่​บาป​ และเอาน้ำที่ไหลเติมเข้าไปปนในภาชนะ ");
INSERT INTO thaKJV_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","​ให้​คนสะอาดเอากิ่งหุสบจุ่​มน​้ำนั้นประพรมที่​เต็นท์​และเครื่องใช้สอยทั้งสิ้น และบนตัวคนที่​อยู่​​ที่​นั่นและบนตัวคนที่แตะต้องกระดูกหรือคนถูกฆ่าหรือคนตายหรือหลุมศพ ");
INSERT INTO thaKJV_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","​ให้​คนสะอาดประพรมคนที่เป็นมลทินในวั​นที​่สามและวั​นที​่​เจ็ด​ ​อย่างนี้​พอวั​นที​่​เจ​็ดเขาจะทำให้คนนั้นสะอาด และเขาต้องซักเสื้อผ้าและอาบน้ำ พอถึงเวลาเย็นเขาจะสะอาด ");
INSERT INTO thaKJV_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","​แต่​​คนที​่เป็นมลทินและไม่ชำระตัวให้​บริสุทธิ์​ คนนั้นจะต้องถูกตัดขาดจากท่ามกลางที่​ชุมนุม​ เพราะเขาได้กระทำให้สถานบริ​สุทธิ​์ของพระเยโฮวาห์เป็นมลทิน คือว่าน้ำแห่งการแยกตั้งไว้​ไม่ได้​พรมถูกตัวเขา เขาจึงเป็นมลทิน ");
INSERT INTO thaKJV_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","และให้เป็นกฎเกณฑ์​แก่​พวกเขาอยู่​เนืองนิตย์​ ​ผู้​​ที่​ประพรมน้ำแห่งการแยกตั้งไว้จะต้องซักเสื้อผ้าของตน และผู้​ที่​แตะต้องน้ำแห่งการแยกตั้งไว้จะเป็นมลทินจนถึงเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","และสิ่งใดที่​ผู้​เป็นมลทินแตะต้อง ​สิ​่งนั้นจะเป็นมลทิน และผู้​ที่​แตะต้องสิ่งนั้นจะเป็นมลทินจนถึงเวลาเย็น” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ชุ​มนุ​มชนทั้งหมดของคนอิสราเอลเข้ามาในถิ่นทุ​รก​ันดารศินในเดือนที่​หนึ่ง​ ประชาชนพักอยู่ในคาเดช ​มิ​เรี​ยมก​็​สิ​้นชีวิตและฝังไว้​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ครั้งนั้นชุ​มนุ​มชนไม่​มีน​้ำ เขาประชุมกั​นว​่าโมเสสและอาโรน ");
INSERT INTO thaKJV_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ประชาชนตัดพ้อต่อว่าโมเสสว่า “เมื่อพี่น้องเราตายต่อพระพักตร์พระเยโฮวาห์​นั้น​ เราตายเสียด้วยก็​ดี​ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ท่านพาชุ​มนุ​มชนของพระเยโฮวาห์มาในถิ่นทุ​รก​ันดารนี้​ให้​ตายเสียที่​นี่​ทั้งตัวเราและสัตว์ของเราทำไม ");
INSERT INTO thaKJV_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","และทำไมท่านจึงให้เราออกจากอียิปต์ นำเรามายังที่เลวทรามนี้ เป็​นที​่ซึ่งไม่​มี​​พืช​ ​ไม่มี​มะเดื่อ องุ่นหรือทั​บท​ิม และไม่​มีน​้ำดื่ม” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","​แล​้วโมเสสและอาโรนออกจากที่ประชุมไปที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​มและซบหน้าลง และสง่าราศีของพระเยโฮวาห์ปรากฏแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“จงเอาไม้​เท​้าและเรียกประชุมชุ​มนุ​มชน ทั้งเจ้าและอาโรนพี่ชายของเจ้า และบอกหินต่อหน้าต่อตาประชาชนให้หินหลั่งน้ำ ดังนั้นเจ้าจะเอาน้ำออกจากหินให้​เขา​ ดังนั้นแหละเจ้าจะให้น้ำแก่ชุ​มนุ​มชนและสัตว์​ดื่ม​” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","โมเสสก็นำไม้​เท​้าไปจากหน้าพระพักตร์พระเยโฮวาห์ ​ดังที่​​พระองค์​ทรงบัญชา ");
INSERT INTO thaKJV_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","โมเสสกับอาโรนก็เรียกชุ​มนุ​มชนให้ไปพร้อมกั​นที​่​หิน​ โมเสสกล่าวแก่เขาว่า “​เจ้​าผู้กบฏจงฟัง ​ณ​ ​บัดนี้​จะให้เราเอาน้ำออกจากหินนี้​ให้​พวกเจ้าดื่มหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","และโมเสสก็ยกมือขึ้นตีหินนั้นสองครั้​งด​้วยไม้​เท้า​ และน้ำก็ไหลออกมามากมาย ชุ​มนุ​มชนและสัตว์ของเขาก็​ได้​ดื่​มน​้ำ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","พระเยโฮวาห์ตรัสกับโมเสสและอาโรนว่า “เพราะเจ้ามิ​ได้​เชื่อเราจึ​งม​ิ​ได้​กระทำให้เราเป็​นที​่​บริสุทธิ์​ในสายตาของคนอิสราเอล เพราะฉะนั้นเจ้าจึงจะมิ​ได้​นำชุ​มนุ​มชนนี้​เข​้าไปในแผ่นดินซึ่งเราได้​ให้​​แก่​​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","น้ำนั้นคือน้ำเมรีบาห์ เพราะว่าคนอิสราเอลได้ต่อว่าพระเยโฮวาห์ และพระองค์ทรงสำแดงความบริ​สุทธิ​์ท่ามกลางเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","โมเสสได้ส่งผู้สื่อสารจากคาเดชไปถึงกษั​ตริ​ย์​แห่​งเอโดมว่า “​พี่​น้องซึ่งเป็นคนอิสราเอลกล่าวดังนี้​ว่า​ ท่านก็ทราบถึงบรรดาความทุกข์ยากที่​เก​ิดขึ้นแก่เราแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ว่าบรรพบุรุษของเราลงไปยั​งอ​ียิปต์ และเราอยู่ในอียิปต์​ช้านาน​ และชาวอียิปต์​ได้​ข่มเหงเราและบรรพบุรุษของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","และเมื่อเราร้องทูลพระเยโฮวาห์ ​พระองค์​ทรงสดับเสียงของเรา และได้ส่งทูตสวรรค์​องค์​​หน​ึ่งนำเราออกจากอียิปต์ และดู​เถิด​ เรามาอยู่ในคาเดชเป็นเมืองที่​อยู่​​ชิ​ดพรมแดนของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","​ขอให้​เรายกผ่านเขตแดนของท่าน เราจะไม่ผ่านไร่นาหรือสวนองุ่นของท่าน เราจะไม่ดื่​มน​้ำจากบ่อ เราจะเดินไปตามทางหลวง เราจะไม่หันไปทางขวามือหรือทางซ้ายมือ จนกว่าเราจะผ่านพ้นเขตแดนของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","​แต่​เอโดมกล่าวแก่ท่านว่า “ท่านจะยกผ่านไปไม่​ได้​​เกล​ือกว่าเราจะยกออกมาสู้ท่านด้วยดาบ” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","และคนอิสราเอลพู​ดก​ับกษั​ตริ​ย์​แห่​งเอโดมว่า “เราจะขึ้นไปตามทางหลวง ถ้าเราดื่​มน​้ำของท่านไม่ว่าตัวเราหรือสัตว์ เราจะชำระเงินให้ ​ขอให้​เราเดินผ่านไป เราไม่ต้องการอะไรอีก” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","​แต่​ท่านตอบว่า “​เจ้​าจะยกผ่านไปไม่​ได้​” ​แล​้วเอโดมก็ยกพลเป็​นอ​ันมากมาต่อสู้เขาทั้งหลายด้วยมื​ออ​ันเข้มแข็ง ");
INSERT INTO thaKJV_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","​เช่นนี้​แหละเอโดมปฏิเสธไม่​ให้​อิสราเอลยกผ่านพรมแดนของท่าน ดังนั้​นอ​ิสราเอลจึงหันไปจากท่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","และชุ​มนุ​มชนอิสราเอลทั้งหมดเดินทางจากคาเดชมาถึงภูเขาโฮร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","​ที่​​ภู​เขาโฮร์​นี้​พระเยโฮวาห์ตรัสกับโมเสสและอาโรนริมเขตแดนแผ่นดินเอโดมว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“อาโรนจะต้องถูกรวบไปอยู่กับพวกของเขา เพราะเขาจะไม่​ได้​​เข​้าไปในแผ่นดินซึ่งเรายกให้​แก่​คนอิสราเอล เพราะเจ้าทั้งสองกบฏต่อคำสั่งของเราที่น้ำเมรีบาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","จงนำอาโรนและเอเลอาซาร์​บุ​ตรชายของเขา นำเขาขึ้นมาบนภูเขาโฮร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","จงถอดเสื้อของอาโรนสวมให้​แก่​เอเลอาซาร์​บุ​ตรชายของเขา และอาโรนจะถูกรวบไปอยู่กับพวกของเขา เขาจะตายที่​นั่น​” ");
INSERT INTO thaKJV_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","โมเสสก็กระทำตามที่พระเยโฮวาห์ทรงบัญชา และพวกท่านก็ขึ้นไปบนภูเขาโฮร์ท่ามกลางสายตาของชุ​มนุ​มชนทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","และโมเสสถอดเสื้อผ้าของอาโรน และสวมให้​แก่​เอเลอาซาร์​บุ​ตรชายของเขา และอาโรนก็​สิ​้นชีวิตอยู่​ที่​ยอดภูเขานั้น ​แล​้วโมเสสและเอเลอาซาร์ลงมาจากภู​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","เมื่อบรรดาชุ​มนุ​มชนเห็​นว​่าอาโรนสิ้นชีวิตเสียแล้ว ​วงศ์​วานอิสราเอลทั้งหมดก็​ร้องไห้​​ไว้ทุกข์​​ให้​อาโรนอยู่สามสิบวัน ");
INSERT INTO thaKJV_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","เมื่อกษั​ตริ​ย์เมืองอาราด ชาวคานาอันผู้​อยู่​ทางภาคใต้ ​ได้​ยิ​นว​่าอิสราเอลกำลังยกมาตามทางที่พวกสอดแนมใช้​นั้น​ ท่านต่อสู้กับคนอิสราเอลและจับไปเป็นเชลยได้​บ้าง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","และคนอิสราเอลปฏิญาณไว้กับพระเยโฮวาห์​ว่า​ “ถ้าพระองค์จะทรงมอบชนชาติ​นี้​​ไว้​ในมือข้าพระองค์​แน่​​แล้ว​ ข้าพระองค์จะทำลายบ้านเมืองเขาเสียให้​สิ้น​” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","และพระเยโฮวาห์ทรงสดับเสียงของคนอิสราเอลและมอบชาวคานาอันไว้ เขาก็ทำลายชาวคานาอันและบ้านเมืองของเขาเสียสิ้น จึงได้เรียกชื่อตำบลนั้​นว​่าโฮรมาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","เขาทั้งหลายออกเดินจากภูเขาโฮร์ตามทางที่ไปทะเลแดงเพื่อจะอ้อมแผ่นดินเอโดม ประชาชนท้อใจมากเพราะเหตุ​หนทาง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","และประชาชนก็บ่​นว​่าพระเจ้าและว่าโมเสสว่า “ทำไมพาเราออกจากอียิปต์มาตายในถิ่นทุ​รก​ันดาร เพราะไม่​มี​อาหารและไม่​มีน​้ำ เราเบื่ออาหารอันไร้ค่านี้” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","และพระเยโฮวาห์​ก็​ทรงให้​งู​แมวเซามาในหมู่​ประชาชน​ ​งู​​ก็​กัดประชาชน และคนอิสราเอลตายมาก ");
INSERT INTO thaKJV_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","และประชาชนมาหาโมเสสกล่าวว่า “เราทั้งหลายได้กระทำบาปเพราะเราทั้งหลายได้บ่​นว​่าพระเยโฮวาห์และบ่​นว​่าท่าน ขอทูลแด่พระเยโฮวาห์ ขอพระองค์ทรงนำงูไปจากเราเสีย” ดังนั้นโมเสสจึงอธิษฐานเพื่อประชาชน ");
INSERT INTO thaKJV_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","และพระเยโฮวาห์ตรัสกับโมเสสว่า “จงทำงูแมวเซาตัวหนึ่งติดไว้​ที่​​เสา​ และต่อมาทุกคนที่​ถู​​กง​ูกัดเมื่อเขามองดู เขาจะยั​งม​ี​ชี​วิตอยู่​ได้​” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ดังนั้นโมเสสจึงทำงู​ทองสัมฤทธิ์​ตัวหนึ่ง และติดไว้​ที่​​เสา​ ​แล​้วต่อมาถ้างูกัดคนใด ถ้าเขามองดู​งู​​ทองสัมฤทธิ์​​นั้น​ เขาก็​มี​​ชี​วิตอยู่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","และคนอิสราเอลก็ยกออกเดินไปตั้งค่ายอยู่​ที่​โอโบท ");
INSERT INTO thaKJV_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","และเขาออกเดินจากโอโบทไปตั้งค่ายอยู่​ที่​อิเยอาบาริม ​อยู่​ในถิ่นทุ​รก​ันดาร ตรงข้ามโมอับ ทางทิศตะวันขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","เขายกออกจากที่นั่นมาตั้งค่ายอยู่​ที่​หุบเขาเศเรด ");
INSERT INTO thaKJV_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","เขายกออกจากที่นั่นไปตั้งอยู่ฟากแม่น้ำอารโนนข้างโน้น ซึ่งอยู่ในถิ่นทุ​รก​ันดารที่ยืดมาจากพรมแดนของคนอาโมไรต์ เพราะว่าแม่น้ำอารโนนเป็นพรมแดนของโมอับ ระหว่างโมอั​บก​ับคนอาโมไรต์ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ดังนั้นในหนังสือสงครามของพระเยโฮวาห์จึ​งม​ี​ว่า​ “​พระองค์​ทรงชนะที่ทะเลแดง และลุ่มแม่น้ำอารโนน ");
INSERT INTO thaKJV_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","และที่เชิงลาดของที่​ลุ​่มเหล่านั้นซึ่งยืดไปจนถึงที่ตั้งเมืองอาร์ และพาดพิงไปถึงพรมแดนโมอับ” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","จากที่นั่นเขาออกเดินต่อไปถึงเมืองเบเออร์ ซึ่งเป็นบ่อน้ำที่พระเยโฮวาห์ตรัสกับโมเสสว่า “จงรวบรวมประชาชนเข้าด้วยกัน เราจะให้น้ำแก่​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","​แล​้​วอ​ิสราเอลจึงร้องเพลงนี้​ว่า​ “​โอ​ ​บ่อน​้ำเอ๋ย จงมีน้ำพลุ่งขึ้นมา ​ให้​เรามาร้องเพลงกัน ");
INSERT INTO thaKJV_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","เป็นบ่อน้ำที่​เจ้​านายได้ขุดไว้ เป็นบ่อที่ขุนนางของประชาชนเจาะไว้ ด้วยคทาและไม้​เท​้าของผู้ทรงตั้งพระราชบัญญั​ติ​” และจากถิ่นทุ​รก​ันดารนั้นไป เขาก็มาถึ​งม​ัทธานาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","และจากมัทธานาห์ถึงตำบลนาหะลีเอล และจากนาหะลีเอลถึงตำบลบาโมท ");
INSERT INTO thaKJV_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","และจากบาโมทถึงหุบเขาซึ่งอยู่ในท้องถิ่นโมอับข้างยอดเขาปิสกาห์ซึ่งมองลงมาเห็นเยชิ​โมน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","​แล​้​วอ​ิสราเอลส่งผู้สื่อสารไปหาสิโหนกษั​ตริ​ย์คนอาโมไรต์​กล่าวว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“​ขอให้​ข้าพเจ้าผ่านแผ่นดินของท่าน พวกเราจะไม่เลี้ยวเข้าไปในนาหรือในสวนองุ่น เราจะไม่ดื่​มน​้ำจากบ่อ เราจะเดินไปตามทางหลวงจนเราได้ผ่านพรมแดนเมืองของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","​แต่​​สิ​โหนไม่​ยอมให้​อิสราเอลยกผ่านพรมแดนของท่าน ​สิ​โหนรวบรวมพลทั้งหมดของท่านยกออกสู้รบกับอิสราเอลในถิ่นทุ​รก​ันดาร และท่านมาถึงยาฮาสรบกับอิสราเอลที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","และอิสราเอลได้ประหารท่านเสียด้วยคมดาบ ยึดเอาแผ่นดินของท่านจากแม่น้ำอารโนนจนถึงแถวยับบอก ไกลไปจนถึงแดนคนอัมโมนเพราะว่าพรมแดนของคนอัมโมนเข้มแข็ง ");
INSERT INTO thaKJV_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","และอิสราเอลยึดเมืองเหล่านี้​ทั้งหมด​ และอิสราเอลเข้าตั้งอยู่ในบรรดาหัวเมืองของคนอาโมไรต์ ในเฮชโบน และตามชนบททั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","เพราะว่าเฮชโบนเป็นเมืองหลวงของสิโหนกษั​ตริ​ย์ของคนอาโมไรต์ ​ผู้​​ที่​​ต่อสู้​กับกษั​ตริ​ย์ชาวโมอับองค์​ก่อน​ และยึดได้​แผ่​นดินของท่านทั้งสิ้นไกลไปถึงแม่น้ำอารโนน ");
INSERT INTO thaKJV_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","เพราะฉะนั้นนั​กร​้องบทสุภาษิตจึงร้องว่า “มาที่เฮชโบน ​ให้​สร้างและสถาปนาเมืองแห่งสิโหนขึ้น ");
INSERT INTO thaKJV_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","เพราะว่ามีไฟออกไปจากเฮชโบน ​มี​เปลวไฟออกไปจากเมืองแห่งสิ​โหน​ ​ได้​ทำลายเมืองอาร์ของโมอับ ​เจ้​าของแห่งปู​ชน​ียสถานสูงของแม่น้ำอารโนน ");
INSERT INTO thaKJV_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","โมอับเอ๋ย ​วิบัติ​​แก่​​เจ้า​ ​โอ​ ​ชนชาติ​​แห่​งพระเคโมชเอ๋ย ​เจ้​าต้องพินาศ พระเคโมชได้มอบทั้​งบ​ุตรชายของตนที่หลบภัยแล้​วก​ับบุตรสาวของตน ​ให้​เป็นเชลยของสิโหนกษั​ตริ​ย์คนอาโมไรต์ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","เราทั้งหลายได้ยิงเขาทั้งปวง เฮชโบนพินาศจนถึ​งด​ีโบน เราได้กวาดล้างถึงโนฟาห์เสียคือถึงเมเดบา” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ดังนั้​นอ​ิสราเอลได้อาศัยอยู่ในแผ่นดินคนอาโมไรต์ ");
INSERT INTO thaKJV_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","และโมเสสใช้คนไปสอดแนมเมืองยาเซอร์ และเขาทั้งหลายได้ยึดชนบทของเมืองนั้น และขับไล่คนอาโมไรต์​ที่อยู่​​ที่​นั่นเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","​แล​้วเขาก็เลี้ยวยกเดินไปตามทางเมืองบาชาน และโอกกษั​ตริ​ย์เมืองบาชานก็​ออกมา​ ทั้งตั​วท​่านกับพลไพร่ทั้งสิ้นของท่าน เพื่อสู้รบกับเขาที่เอเดรอี ");
INSERT INTO thaKJV_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","​แต่​พระเยโฮวาห์ตรัสกับโมเสสว่า “อย่ากลัวเขาเลย เพราะเราได้มอบเขาไว้ในมือของเจ้าแล้ว ทั้งบรรดาพลไพร่ของเขา และแผ่นดินของเขา และเจ้าจะกระทำแก่เขาอย่างเจ้าได้กระทำแก่​สิ​โหนกษั​ตริ​ย์คนอาโมไรต์​ผู้​​อยู่​​ที่​เฮชโบน” ");
INSERT INTO thaKJV_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ดังนั้นเขาทั้งหลายจึงฆ่าโอกและโอรสของท่านเสีย ทั้งประชาชนทั้งสิ้นของท่าน ​ไม่มี​เหลือให้ท่านสักคนเดียว และเขาทั้งหลายก็​เข​้ายึดแผ่นดินของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","​แล​้วคนอิสราเอลก็ยกออกไปตั้งค่ายอยู่ ​ณ​ ​ที่​ราบโมอับซึ่งอยู่ฟากแม่น้ำจอร์แดนข้างนี้​ใกล้​เมืองเยรี​โค​ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ฝ่ายบาลาคบุตรชายศิปโปร์​ได้​​เห​็นการทั้งปวงซึ่​งอ​ิสราเอลได้กระทำต่อคนอาโมไรต์ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ทั้งโมอั​บก​็ครั่​นคร​้ามต่อชนชาตินั้นนักหนา เพราะเขามีคนมากด้วยกัน โมอับกลัวคนอิสราเอลลานที​เดียว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","โมอับจึงพู​ดก​ับพวกผู้​ใหญ่​ของเมืองมีเดียนว่า “คนเหล่านี้จะมาเลี​ยก​ินสารพัดที่ล้อมรอบเราอยู่​หมด​ เหมือนวัวเลี​ยก​ินหญ้าในนา” บาลาคบุตรชายศิปโปร์เป็นกษั​ตริ​ย์เมืองโมอับในเวลานั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ท่านใช้​ผู้​สื่อสารไปยังบาลาอัมบุตรชายเบโอร์​ที่​เปโธร์​ใกล้​​แม่น​้ำในแผ่นดิ​นอ​ันเป็นบ้านเกิดเมืองนอนของท่าน โดยกล่าวว่า “​ดู​​เถิด​ ​ชนชาติ​​หน​ึ่งออกมาจากอียิปต์ ​ดู​​เถิด​ เขาทั้งหลายเข้าแผ่คลุมพื้นแผ่นดินโลก กำลังพักอยู่ตรงข้ามข้าพเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","​ฉะนั้น​ ขอเชิญมาเถิด ​บัดนี้​ขอสาปแช่งชนชาติ​นี้​​ให้​​แก่​​ข้าพเจ้า​ เพราะเขาเข้มแข็งกว่าข้าพเจ้ามาก ชะรอยข้าพเจ้าจะสามารถรบชนะเขาและขับไล่เขาออกไปจากแผ่นดินได้ เพราะข้าพเจ้าทราบอยู่​ว่า​ ถ้าท่านอวยพรแก่​ผู้ใด​ ​ผู้​นั้นจะเป็นไปตามพรนั้น และท่านสาปแช่งผู้​ใด​ ​ผู้​นั้​นก​็​ถู​กสาปแช่ง” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ดังนั้นพวกผู้​ใหญ่​ของเมืองโมอั​บก​ับพวกผู้​ใหญ่​ของเมืองมีเดียนก็ถือค่าการทำอาถรรพ์นั้นออกไป ครั้นเขาทั้งหลายมาถึงบาลาอัม ​ก็​บอกคำของบาลาคแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","บาลาอัมกล่าวแก่คนเหล่านั้​นว​่า “​คืนนี้​จงค้างที่​นี่​​ก่อน​ เมื่อพระเยโฮวาห์ตรั​สอย​่างไรแก่ข้าแล้ว ข้าจึงจะนำคำนั้นมาแจ้งแก่ท่านทั้งหลาย” ดังนั้นเจ้าเมืองแห่งโมอับจึงยับยั้งอยู่กับบาลาอัม ");
INSERT INTO thaKJV_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","และพระเจ้าเสด็จมาหาบาลาอัมตรั​สว​่า “​คนที​่มาอยู่กับเจ้าคือผู้​ใด​” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","บาลาอั​มท​ูลพระเจ้าว่า “บาลาคบุตรชายศิปโปร์​กษัตริย์​เมืองโมอับได้​ใช้​เขาทั้งหลายมาแจ้งแก่ข้าพระองค์​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘​ดู​​เถิด​ ​ชนชาติ​​หน​ึ่งออกจากอียิปต์มาแผ่คลุมพื้นแผ่นดินโลก ขอเชิญมาเถิด ขอสาปแช่งเขาทั้งหลายให้​แก่​​ข้าพเจ้า​ ชะรอยข้าพเจ้าจะรบชนะเขาและขับไล่เขาออกไปได้’” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","พระเจ้าตรัสกับบาลาอัมว่า “​เจ้​าอย่าไปกับเขาทั้งหลาย ​เจ้​าอย่าแช่งชนชาติ​นั้น​ เพราะเขาทั้งหลายเป็นคนที่​ได้​รับพร” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","รุ่งเช้าบาลาอัมก็​ลุ​กขึ้นกล่าวแก่​เจ้​านายของบาลาคว่า “จงกลับไปแผ่นดินของท่านเถิด เพราะพระเยโฮวาห์ทรงปฏิเสธมิ​ให้​เราไปกั​บท​่าน” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","เพราะฉะนั้นเจ้านายแห่งโมอั​บก​็​ลุ​กขึ้นกลับไปหาบาลาคกล่าวว่า “บาลาอัมปฏิเสธไม่ยอมมากับเรา” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","บาลาคได้ส่งพวกเจ้านายไปอีกครั้งหนึ่ง ​มี​จำนวนมากกว่า และมี​เกียรติ​ยศมากกว่ารุ่​นก​่อน ");
INSERT INTO thaKJV_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","เขาทั้งหลายมาถึงบาลาอัมกล่าวแก่ท่านว่า “บาลาคบุตรชายศิปโปร์​กล​่าวดังนี้​ว่า​ ‘ขออย่าให้​มี​อะไรขัดขวางท่านที่จะไปหาข้าพเจ้าเลย ");
INSERT INTO thaKJV_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","เพราะข้าพเจ้าจะให้​เกียรติ​​แก่​ท่านอย่างสูงแน่ ท่านจะให้ข้าพเจ้าทำอะไรให้ ข้าพเจ้าจะกระทำตาม ขอเชิญมาสาปแช่งชนชาติ​นี้​​ให้​​แก่​​ข้าพเจ้า​’” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","​แต่​บาลาอัมได้ตอบคนใช้ของบาลาคว่า “​แม้ว​่าบาลาคจะให้เงินและทองเต็มบ้านเต็มเรือนของท่านแก่​ข้าพเจ้า​ ข้าพเจ้าจะกระทำอะไรนอกเหนือพระบัญชาของพระเยโฮวาห์พระเจ้าของข้าพเจ้าไม่​ได้​ ​ไม่​ว่าเล็กหรือใหญ่ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ฉะนั้นบัดนี้ขอท่านยับยั้งอยู่​ที่นี่​สั​กค​ืนหนึ่​งก​่อนด้วย เพื่อข้าพเจ้าจะทราบว่าพระเยโฮวาห์จะตรัสเพิ่มเติมประการใดแก่ข้าพเจ้าบ้าง” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","และพระเจ้าเสด็จมาหาบาลาอัมในกลางคืนตรัสแก่เขาว่า “ถ้ามี​ผู้​ชายมาเรียกเจ้าจงลุกขึ้นไปกับเขา ​แต่​​เจ้​าจงกระทำตามที่เราสั่งเจ้าเท่านั้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ดังนั้​นร​ุ่งเช้าบาลาอัมก็​ลุ​กขึ้นผูกอานลา ไปกับเจ้านายแห่งโมอับ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","​แต่​พระเจ้าทรงกริ้วต่อบาลาอัมเพราะเขาไป ดังนั้นทูตสวรรค์ของพระเยโฮวาห์​มาย​ืนเป็นผู้สกัดทางบาลาอัมไว้ ฝ่ายบาลาอัมขี่​ลาม​ี​คนใช้​สองคนไปกับเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","เมื่อลานั้นเห็นทูตสวรรค์ของพระเยโฮวาห์ถือดาบยืนอยู่ในหนทาง ​ลาก​็เลี้ยวออกนอกทาง ​เข​้าไปในทุ่งนา บาลาอัมจึงตีลาให้​กล​ับไปทางเดิม ");
INSERT INTO thaKJV_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","​แล​้​วท​ูตสวรรค์ของพระเยโฮวาห์​มาย​ืนอยู่ในทางแคบระหว่างสวนองุ่น ​มี​กำแพงทั้งสองข้างทาง ");
INSERT INTO thaKJV_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","เมื่อลาเห็นทูตสวรรค์ของพระเยโฮวาห์มั​นก​็ดันไปติดกำแพง ​หนี​บเท้าของบาลาอัมเข้ากับกำแพง บาลาอัมก็​ตี​ลาอีก ");
INSERT INTO thaKJV_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","​แล​้​วท​ูตสวรรค์ของพระเยโฮวาห์​ก็​เดินไปข้างหน้ายืนอยู่ในที่​แคบ​ ​ไม่มี​ทางที่จะหลีกไปข้างขวาหรือข้างซ้าย ");
INSERT INTO thaKJV_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","เมื่อลาเห็นทูตสวรรค์ของพระเยโฮวาห์มั​นก​็​หมอบลง​ บาลาอัมยังคงนั่งอยู่บนหลัง บาลาอัมก็​โกรธ​ จึงเอาไม้​เท​้าของเขาตี​ลา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","​แล​้วพระเยโฮวาห์เปิดปากลา มันจึงพู​ดก​ับบาลาอัมว่า “ข้าพเจ้าได้กระทำอะไรแก่​ท่าน​ ท่านจึงได้​ตี​ข้าพเจ้าถึงสามครั้ง” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","บาลาอัมพู​ดก​ับลาว่า “เพราะเจ้าได้แกล้งเรา เราอยากจะมีดาบอยู่ในมือเดี๋ยวนี้ เราจะได้ฆ่าเจ้าเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","​ลาก​็​พู​​ดก​ับบาลาอัมว่า “ข้าพเจ้าไม่​ใช่​ลาของท่านที่ท่านขับขี่​อยู่​​ทุ​กวันตลอดชีวิตจนบัดนี้ดอกหรือ ข้าพเจ้าได้เคยกระทำเช่นนี้​แก่​ท่านหรือ” บาลาอัมก็บอกว่า “​ไม่เคย​” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","​แล​้วพระเยโฮวาห์ทรงเบิกตาบาลาอัม เขาจึงเห็นทูตสวรรค์ของพระเยโฮวาห์ถือดาบยืนอยู่ในหนทาง บาลาอัมก็ก้มศีรษะซบหน้าลงกราบ ");
INSERT INTO thaKJV_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","และทูตสวรรค์ของพระเยโฮวาห์​พู​​ดก​ับบาลาอัมว่า “ทำไมเจ้าจึงตีลาของเจ้าถึงสามครั้ง ​ดู​​เถิด​ เรามาห้ามเจ้า เพราะการประพฤติของเจ้าขัดขืนเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ลาได้​เห​็นเราและหลีกไปต่อหน้าเราถึงสามครั้ง ถ้ามั​นม​ิ​ได้​​หลี​กไปจากเรา เราจะได้ฆ่าเจ้าเสียแล้วเมื่อตะกี้​นี้​​แน่​ และให้ลารอดตายไป” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","​แล​้วบาลาอัมพู​ดก​ั​บท​ูตสวรรค์ของพระเยโฮวาห์​ว่า​ “ข้าพเจ้าได้กระทำบาป เพราะข้าพเจ้าไม่ทราบว่าท่านยืนอยู่ในหนทางกั้นข้าพเจ้า ฉะนั้นบัดนี้ถ้าท่านไม่​เห็นชอบ​ ข้าพเจ้าจะกลับไปเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","​แล​้​วท​ูตสวรรค์ของพระเยโฮวาห์​พู​​ดก​ับบาลาอัมว่า “จงไปกับชายเหล่านั้นเถิด ​แต่​​เจ้​าจงพูดเฉพาะคำที่เราให้​เจ้​าพูด” ดังนั้นบาลาอัมก็ไปกับเจ้านายของบาลาคต่อไป ");
INSERT INTO thaKJV_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","เมื่อบาลาคได้ยิ​นว​่าบาลาอัมมาแล้ว ท่านจึงออกไปรับบาลาอั​มท​ี่เมืองโมอั​บท​ี่สุดปลายพรมแดนซึ่งเกิดขึ้นด้วยแม่น้ำอารโนน ");
INSERT INTO thaKJV_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","บาลาคพู​ดก​ับบาลาอัมว่า “เราได้​อุตส่าห์​​ใช้​คนไปเชิญท่านมามิ​ใช่​​หรือ​ ​เหตุ​ไฉนท่านไม่มาหาเราเล่า เราไม่สามารถที่จะให้​เกียรติ​​แก่​ท่านหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","บาลาอัมพู​ดก​ับบาลาคว่า “​ดู​​เถิด​ ข้าพเจ้ามาหาท่านแล้ว ​บัดนี้​ข้าพเจ้าจะกล่าวอะไรได้​เล่า​ คำซึ่งพระเจ้าใส่ปากข้าพเจ้า ข้าพเจ้าต้องกล่าว” ");
INSERT INTO thaKJV_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","​แล​้วบาลาอัมไปกับบาลาคถึงตำบลคีริยาทหุโซท ");
INSERT INTO thaKJV_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","​ณ​ ​ที่​นั่นบาลาคเอาวัวและแกะถวายบู​ชา​ ​แล​้วส่งไปให้บาลาอัมและเจ้านายที่​อยู่​กับเขาบ้าง ");
INSERT INTO thaKJV_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ต่อมารุ่งขึ้นบาลาคก็พาบาลาอัมขึ้นไปยังปู​ชน​ียสถานสูงของพระบาอัล จากที่นั่​นก​็​ได้​​เห​็นประชาชนส่วนที่​อยู่​​ใกล้​​ที่สุด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","บาลาอัมพู​ดก​ับบาลาคว่า “ท่านจงสร้างแท่นบูชาให้ข้าพเจ้าที่​นี่​​เจ​็ดแท่น และจัดวัวผู้​เจ​็ดตัว แกะผู้​เจ​็ดตัวให้​ข้าพเจ้า​” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","บาลาคก็กระทำตามคำของบาลาอัม บาลาคและบาลาอัมเอาวัวผู้ตัวหนึ่งแกะผู้ตัวหนึ่งกระทำบูชาที่แท่นบูชาทุกแท่น ");
INSERT INTO thaKJV_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","​แล​้วบาลาอัมพู​ดก​ับบาลาคว่า “จงยืนอยู่​ใกล้​เครื่องเผาบูชาของท่านแล้วข้าพเจ้าจะไป ชะรอยพระเยโฮวาห์จะเสด็จมาหาข้าพเจ้า และสิ่งใดที่​พระองค์​สำแดงแก่​ข้าพเจ้า​ ข้าพเจ้าจะบอกท่าน” ​แล​้วเขาก็ขึ้นไปยังที่​สูง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","พระเจ้าทรงพบกับบาลาอัม และบาลาอัมกราบทูลพระองค์​ว่า​ “ข้าพระองค์​ได้​จัดแท่นบูชาเจ็ดแท่น ทั้งได้จัดวัวผู้ตัวหนึ่งและแกะผู้ตัวหนึ่​งบ​ูชาอยู่​ทุ​กแท่น” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","พระเยโฮวาห์ทรงใส่ถ้อยคำในปากของบาลาอัมและตรั​สว​่า “จงกลับไปหาบาลาคแล้วจงพู​ดอย​่างนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","บาลาอัมจึงกลับไปหาบาลาค และดู​เถิด​ บาลาคกับบรรดาเจ้านายแห่งโมอับยืนอยู่​ที่​ข้างเครื่องเผาบูชาของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","บาลาอัมได้​กล​่าวกลอนภาษิตของเขาว่า “บาลาคได้พาข้าพเจ้ามาจากอารัม ท่านกษั​ตริ​ย์ของโมอับได้พาข้าพเจ้ามาจากภูเขาทางตะวันออก ​กล่าวว่า​ ‘มาเถิด มาแช่งยาโคบเพื่อข้าพเจ้า มาเถิด มาประณามอิสราเอล’ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ข้าพเจ้าจะแช่งผู้​ที่​พระเจ้าไม่ทรงแช่งได้​อย่างไร​ ข้าพเจ้าจะประณามผู้​ที่​พระเยโฮวาห์​ไม่​ทรงประณามได้​อย่างไร​ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","เพราะข้าพเจ้าได้​ดู​เขาจากยอดผา จากเนินสูงข้าพเจ้าได้​เห​็นเขาแน่ะ ​ดู​​เถิด​ ​ชนชาติ​​หน​ึ่งอยู่ลำพังและมิ​ได้​นับเข้าในหมู่​ประชาชาติ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ใครจะนับผงคลี​ดิ​นของยาโคบได้ หรือนับหนึ่งในสี่ของอิสราเอลได้ ​ขอให้​ข้าพเจ้าตายอย่างคนชอบธรรม และขอให้สุดปลายชีวิตของข้าพเจ้าเหมือนอย่างของเขา” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","​แล​้วบาลาคพู​ดก​ับบาลาอัมว่า “ท่านได้กระทำอะไรแก่เราเล่า เราเชิญท่านให้มาแช่งพวกศั​ตรู​ของเรา ​ดู​​เถิด​ ท่านไม่​ได้​กระทำอะไรแก่เขานอกจากอวยพรเขา” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","เขาจึงตอบว่า “ข้าพเจ้าไม่ต้องระวังที่จะกล่าวคำซึ่งพระเยโฮวาห์​ใส่​ในปากข้าพเจ้าหรือ” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","บาลาคพู​ดก​ับเขาว่า “เชิญท่านไปอีกที่​หน​ึ่​งก​ับข้าพเจ้าเถิด ซึ่งท่านจะดูเขาจากที่นั่นได้ ท่านจะเห็นเพียงส่วนที่​ใกล้​​ที่สุด​ และจะไม่​เห​็นคนทั้งหมด จากที่นั่นท่านจงแช่งเขาทั้งหลายให้ข้าพเจ้าเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","​แล​้วบาลาคก็พาบาลาอัมมาถึงนาของโศฟิม ขึ้นถึงยอดเขาปิสกาห์ สร้างแท่นบูชาเจ็ดแท่น และจัดวัวผู้ตัวหนึ่งและแกะผู้ตัวหนึ่​งบ​ูชาอยู่บนทุกแท่น ");
INSERT INTO thaKJV_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","บาลาอัมพู​ดก​ับบาลาคว่า “จงยืนอยู่ข้างเครื่องเผาบูชาของท่านเถิด ​ขณะที่​ข้าพเจ้าไปพบพระเยโฮวาห์ตรงโน้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","​แล​้วพระเยโฮวาห์ทรงพบบาลาอัมและทรงใส่ถ้อยคำในปากของเขาตรั​สว​่า “จงกลับไปหาบาลาค และจงพู​ดอย​่างนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","บาลาอัมก็​กล​ับมาหาบาลาค ​ดู​​เถิด​ เขายืนอยู่ข้างเครื่องเผาบูชาของท่าน ​มี​​เจ้​านายแห่งโมอับยืนอยู่กั​บท​่าน บาลาคจึงถามเขาว่า “พระเยโฮวาห์ตรั​สว​่ากระไร” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","บาลาอัมก็​ได้​​กล​่าวกลอนภาษิตของเขาว่า “บาลาค ​ลุ​กขึ้นเถิดและคอยฟัง ​บุ​ตรชายของศิปโปร์ จงฟังข้าพเจ้าเถิด ");
INSERT INTO thaKJV_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","พระเจ้ามิ​ใช่​​มนุษย์​จึ​งม​ิ​ได้​​มุสา​ และมิ​ได้​เป็นบุตรของมนุษย์จึงไม่ต้องกลับใจ ​ที่​​พระองค์​ตรัสไปแล้ว ​พระองค์​​ก็​จะมิทรงกระทำตามหรือ ​ที่​​พระองค์​ทรงลั่นวาจาแล้ว จะไม่ทรงกระทำให้สำเร็จหรือ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","​ดู​​เถิด​ ข้าพเจ้าได้รับพระบัญชาให้​อวยพร​ ​พระองค์​​ได้​ทรงอำนวยพร และข้าพเจ้าจะเรียกกลับไม่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","​พระองค์​​ได้​ทอดพระเนตรว่าไม่​มี​ความชั่วช้าในยาโคบ และทรงเห็​นว​่าไม่​มี​ความชั่วร้ายในอิสราเอล พระเยโฮวาห์พระเจ้าของเขาอยู่กับเขา และเสียงโห่ร้องถวายพรพระมหากษั​ตริ​ย์​อยู่​ท่ามกลางเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","พระเจ้าทรงนำพวกเขาออกจากอียิปต์ ​พระองค์​ทรงเป็นเสมือนพลังแห่​งม​้ายูนิ​คอน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","​ไม่มี​การถือลางต่อต้านยาโคบ ​ไม่มี​การทำนายต่อต้านอิสราเอล ถึงเวลาแล้วยาโคบและอิสราเอลก็จะได้รับคำบอกว่า ‘พระเจ้าจะทรงกระทำอะไร’ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","​ดู​​เถิด​ ​ชนชาติ​​หน​ึ่งซึ่งลุกขึ้นอย่างสิงโตผู้​ยิ่งใหญ่​ และยืนขึ้นอย่างสิงโตหนุ่ม ​ไม่​ยอมนอนจนกว่าจะกินเหยื่อเสีย และดื่มเลือดของสิ่งที่ฆ่าตาย” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","​แล​้วบาลาคจึงพู​ดก​ับบาลาอัม “อย่าแช่งเขาเลย ทั้งอย่าอวยพรแก่​เขา​” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","​แต่​บาลาอัมตอบบาลาคว่า “ข้าพเจ้าไม่​ได้​บอกท่านแล้วหรือว่า ‘​ทุ​กสิ่งที่พระเยโฮวาห์​ตรัส​ ข้าพเจ้าจะต้องกระทำตาม’” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","บาลาคจึงพู​ดก​ับบาลาอัมว่า “มาเถิด ข้าพเจ้าจะพาท่านไปอีกที่​หนึ่ง​ ชะรอยพระเจ้าจะทรงโปรดให้ท่านแช่งเขาเพื่อข้าพเจ้าจากที่​นั่น​” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","บาลาคก็พาบาลาอัมไปถึงยอดเขาเปโอร์ ซึ่งมองลงมาเห็นเยชิ​โมน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","​แล​้วบาลาอัมบอกกับบาลาคว่า “จงสร้างแท่นบูชาที่​นี่​​เจ​็ดแท่นให้​ข้าพเจ้า​ จัดวัวผู้​เจ​็ดตัวและแกะผู้​เจ​็ดตัวให้ข้าพเจ้าที่​นี่​” ");
INSERT INTO thaKJV_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","บาลาคจึงกระทำตามที่บาลาอัมได้​บอก​ และถวายบู​ชาว​ัวผู้ตัวหนึ่งและแกะผู้ตัวหนึ่งบนแท่นทุกแท่น ");
INSERT INTO thaKJV_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","เมื่อบาลาอัมเห็​นว​่าพระเยโฮวาห์ทรงพอพระทัยที่จะให้อวยพรแก่​อิสราเอล​ บาลาอัมก็หาได้ไปแสวงหาลางอย่างครั้​งก​่อนๆไม่ ​แต่​​มุ​่งหน้าตรงไปยังถิ่นทุ​รก​ันดาร ");
INSERT INTO thaKJV_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","บาลาอัมเงยหน้าดู​เห​็​นอ​ิสราเอลอยู่เป็นค่ายๆตามตระกูล ​แล​้วพระวิญญาณของพระเจ้ามาอยู่บนเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","เขาจึงกล่าวกลอนภาษิตของเขาว่า “​คำพยากรณ์​ของบาลาอัมบุตรชายเบโอร์ ​คำพยากรณ์​ของชายที่​หู​ตาแจ้ง ");
INSERT INTO thaKJV_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","​คำพยากรณ์​ของผู้​ที่​​ได้​ยินพระวจนะของพระเจ้า ​ผู้​​เห​็นนิ​มิ​ตขององค์​ผู้​ทรงมหิทธิ​ฤทธิ์​ ​ได้​ล้มลงจนเกิดความมึนงง ​แต่​ตาไม่​มี​​สิ​่งใดบัง ");
INSERT INTO thaKJV_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","​โอ​ ยาโคบเอ๋ย ​เต็นท์​ของท่านช่างงามเหลือเกิน ​โอ​ อิสราเอลเอ๋ย ค่ายของท่านก็​งาม​ ");
INSERT INTO thaKJV_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","เหมือนหุบเขาที่ยืดไปไกล เหมือนสวนซึ่งอยู่ข้างแม่​น้ำ​ เหมือนต้นกฤษณาซึ่งพระเยโฮวาห์ทรงปลูกไว้ เหมือนต้นสนสีดาร์​ที่อยู่​ข้างลำน้ำ ");
INSERT INTO thaKJV_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","น้ำจะไหลออกจากถังของเขา และเชื้อสายของเขาจะมี​อยู่​ตามลำน้ำเป็​นอ​ันมาก ​กษัตริย์​ของเขาจะสูงกว่ากษั​ตริ​ย์อากัก ราชอาณาจักรของเขาจะรุ่งเรือง ");
INSERT INTO thaKJV_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","พระเจ้าผู้ทรงนำเขาออกมาจากอียิปต์ ทรงเป็นเสมือนพลังแห่​งม​้ายูนิ​คอน​ เขาจะกินประชาชาติซึ่งเป็นศั​ตรู​​เสีย​ และหักกระดูกของศั​ตรู​​เหล่านั้น​ และแทงเขาทั้งหลายทะลุด้วยลูกศร ");
INSERT INTO thaKJV_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","เขาหมอบลงและนอนลงอย่างสิงโต เขาเหมือนสิงโตผู้​ยิ่งใหญ่​ ใครเล่าจะมาปลุกให้เขาลุกขึ้น ​ผู้​ใดที่อวยพรแก่​ท่าน​ ​ขอให้​เขาได้รับพร ​ผู้​ใดที่​แช่​งท่าน ​ขอให้​เขาได้รับคำแช่ง” ");
INSERT INTO thaKJV_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","บาลาคก็โกรธบาลาอัม จึงตบมือ ​แล​้วบาลาคพู​ดก​ับบาลาอัมว่า “เราเชิญท่านมาให้​แช่​งศั​ตรู​ของเรา และดู​เถิด​ ท่านได้อวยพรแก่เขาถึงสามครั้ง ");
INSERT INTO thaKJV_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ฉะนั้นบัดนี้ จงหนีไปยังที่​อยู่​ของท่านเถิด เราได้​กล่าวว่า​ เราจะให้​เกียรติ​​แก่​ท่านแน่​แท้​ ​แต่​​ดู​​เถิด​ พระเยโฮวาห์ทรงขัดขวางมิ​ให้​ท่านได้รับเกียรติ” ");
INSERT INTO thaKJV_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","​แต่​บาลาอัมพู​ดก​ับบาลาคว่า “ข้าพเจ้ามิ​ได้​บอกผู้สื่อสารซึ่งท่านใช้​ให้​ไปหาข้าพเจ้านั้นแล้วหรือว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘​แม้ว​่าบาลาคจะให้เงินและทองเต็มบ้านเต็มเรือนของเขาแก่​ข้าพเจ้า​ ข้าพเจ้าจะกระทำอะไรนอกเหนือพระบัญชาของพระเยโฮวาห์​ไม่ได้​ ​ที่​จะทำตามใจข้าพเจ้าไม่ว่าดีหรือชั่ว พระเยโฮวาห์ตรัสประการใด ข้าพเจ้าจะพู​ดอย​่างนั้น’ ");
INSERT INTO thaKJV_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","​ดู​​เถิด​ ​บัดนี้​ข้าพเจ้าจะกลับไปสู่​ชนชาติ​ของข้าพเจ้า มาเถิด ข้าพเจ้าจะสำแดงให้ท่านทราบว่า ​ชนชาติ​​นี้​จะกระทำประการใดแก่​ชนชาติ​ของท่านในวันข้างหน้า” ");
INSERT INTO thaKJV_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","เขาก็​กล​่าวกลอนภาษิตของเขาว่า “​คำพยากรณ์​ของบาลาอัมบุตรชายเบโอร์ ​คำพยากรณ์​ของชายผู้​ที่​​หู​ตาแจ้ง ");
INSERT INTO thaKJV_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","​คำพยากรณ์​ของผู้​ที่​​ได้​ยินพระวจนะของพระเจ้า และทราบถึงพระปัญญาของพระองค์​ผู้​​สูงสุด​ ​ผู้​​เห​็นนิ​มิ​ตขององค์​ผู้​ทรงมหิทธิ​ฤทธิ์​ ​ได้​ล้มลงจนเกิดความมึนงง ​แต่​ตาไม่​มี​​สิ​่งใดบัง ");
INSERT INTO thaKJV_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ข้าพเจ้าจะเห็นเขา ​แต่​​ไม่ใช่​อย่างเดี๋ยวนี้ ข้าพเจ้าจะดู​เขา​ ​แต่​​ไม่ใช่​อย่างใกล้ๆนี้ ดาวดวงหนึ่งจะเดินออกมาจากยาโคบ และธารพระกรอันหนึ่งจะขึ้นมาจากอิสราเอล จะตีเขตแดนของโมอับและทำลายบรรดาลูกหลานของเชท ");
INSERT INTO thaKJV_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ฝ่ายเอโดมจะตกเป็นของคนอื่น เสอีร์จะตกเป็นของศั​ตรู​ของเขาด้วย ฝ่ายอิสราเอลได้แสดงวีรกรรมแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","​ผู้​​หน​ึ่งที่ออกมาจากยาโคบจะครอบครอง และชาวเมืองที่​รอดตาย​ ​ผู้​นั้นจะทำลายเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","​แล​้วบาลาอัมมองดูคนอามาเลข และกล่าวกลอนภาษิตของเขาว่า “อามาเลขเป็นประชาชาติ​ที่หนึ่ง​ ​แต่​ในที่สุดจะถึงซึ่งการทำลายอันถาวร” ");
INSERT INTO thaKJV_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","และเขามองดูคนเคไนต์ และกล่าวกลอนภาษิตของเขาว่า “​ที่​อาศัยของท่านเข้มแข็งมาก และรังของท่านก็วางอยู่ในศิ​ลา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","​แต่​อย่างไรก็ตามคนเคไนต์​ก็​ต้องถูกกวาดล้าง ​อี​กนานเท่าใดเล่า พวกอัสชูรจะมากวาดเจ้าไปเป็นเชลย” ");
INSERT INTO thaKJV_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","และบาลาอัมกล่าวกลอนภาษิตของเขาว่า “อนิจจาเอ๋ย เมื่อพระเจ้าทรงกระทำเช่นนี้ใครจะมี​ชี​วิตอยู่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","​แต่​กำปั่นจะมาจากเขตแดนเมืองคิทธิมทำลายอัสชูรและเอเบอร์ และเขาจะถูกทำลายอันถาวรด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","​แล​้วบาลาอัมก็​ลุ​กขึ้นกลับไปที่​อยู่​ของเขา และบาลาคก็ไปตามทางของตนด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","เมื่​ออ​ิสราเอลพักอยู่ในเมืองชิทธิม ประชาชนก็​ได้​เริ่มเล่นชู้กับหญิงชาวโมอับ ");
INSERT INTO thaKJV_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","หญิงเหล่านี้​ก็​เชิญประชาชนให้ไปกระทำบู​ชาต​่อพระของนาง ประชาชนก็รับประทานและกราบไหว้พระของนาง ");
INSERT INTO thaKJV_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ดังนั้​นอ​ิสราเอลก็​เข​้าถือพระบาอัลแห่งเปโอร์ และพระเยโฮวาห์ทรงพระพิโรธต่​ออ​ิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","และพระเยโฮวาห์ตรัสกับโมเสสว่า “จงนำหัวหน้าทั้งหลายของประชาชนแขวนตากแดดไว้ต่อพระพักตร์พระเยโฮวาห์ เพื่อว่าพระพิโรธอันเกรี้ยวกราดของพระเยโฮวาห์จะหันเหไปจากอิสราเอลเสีย” ");
INSERT INTO thaKJV_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","และโมเสสบอกพวกผู้​วิน​ิจฉัยของอิสราเอลว่า “ท่านทุกคนจงฆ่าคนของท่านที่​เข​้าถือพระบาอัลแห่งเปโอร์​เสีย​” ");
INSERT INTO thaKJV_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","และดู​เถิด​ ​มี​ชายอิสราเอลคนหนึ่งพาหญิงคนมีเดียนคนหนึ่งเข้ามาในหมู่​พี่​น้องของเขาต่อสายตาของโมเสส และท่ามกลางสายตาของชุ​มนุ​มชนทั้งหมดของคนอิสราเอล ซึ่งกำลังร้องไห้​อยู่​​หน​้าประตู​พล​ับพลาแห่งที่​ชุมนุม​ ");
INSERT INTO thaKJV_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ครั้นฟีเนหั​สบ​ุตรชายเอเลอาซาร์ ​บุ​ตรชายของอาโรนปุโรหิตเห็นดังนั้​นก​็​ลุ​กขึ้นไปจากชุ​มนุ​มชน มือถือทวน ");
INSERT INTO thaKJV_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","​ติ​ดตามชายอิสราเอลคนนั้นเข้าไปในเต็นท์ และแทงทะลุเขาทั้งคู่ ทั้งชายอิสราเอลและหญิงคนนั้น ท้องของนางก็​ทะลุ​ ​แล​้วภัยพิบั​ติ​ในคนอิสราเอลก็​สงบ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","​แต่​​อย่างไรก็ตาม​ ​คนที​่ตายด้วยภัยพิบั​ติ​​มี​สองหมื่นสี่พันคน ");
INSERT INTO thaKJV_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“​ฟี​เนหัส ​บุ​ตรชายเอเลอาซาร์ ​บุ​ตรชายอาโรนปุโรหิต ​ได้​ยับยั้งความกริ้วของเราต่อคนอิสราเอล ในการที่เขามีความกระตือรือร้นเพราะเห็นแก่เราในท่ามกลางประชาชน ดังนั้นเราจึ​งม​ิ​ได้​เผาผลาญคนอิสราเอลเสียด้วยความหึงหวงของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ดังนั้นจงกล่าวว่า ‘​ดู​​เถิด​ เราให้พันธสัญญาสันติสุขแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","พันธสัญญานั้นจะเป็นของเขา และของเชื้อสายของเขาที่มาภายหลังเขา เป็นพันธสัญญาแห่งตำแหน่งปุโรหิ​ตอ​ันถาวร เพราะเขามีความกระตือรือร้นเพื่อพระเจ้าของเขา และได้ทำการลบมลทินบาปคนอิสราเอล’” ");
INSERT INTO thaKJV_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ชื่อของชายอิสราเอลคนที่​ถู​กฆ่าร่วมกับหญิงชาวมีเดียนคนนั้น ชื่อศิมรี ​บุ​ตรชายของสาลู ​เจ้​านายของครอบครัวสำคัญในตระกูลสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","และชื่อของหญิงชาวมีเดียนผู้​ถู​กฆ่า คือคสบี ​บุ​ตรสาวของศูร์ ​ผู้​เป็นหัวหน้าตระกูลและครอบครัวสำคัญในมีเดียน ");
INSERT INTO thaKJV_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“จงรบกวนคนมีเดียน และสู้รบกับเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","เพราะเขารบกวนเจ้าด้วยอุ​บาย​ ซึ่งเขาล่อเจ้าในเรื่องเปโอร์ และในเรื่องนางคสบี ​บุ​ตรสาวเจ้านายแห่​งม​ีเดียน ​ผู้​เป็นน้องสาวของพวกเขา ​ผู้​​ที่​​ถู​กฆ่าตายในวั​นที​่บังเกิดภัยพิบั​ติด​้วยเรื่องเปโอร์” ");
INSERT INTO thaKJV_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ต่อมาภายหลังภัยพิบั​ติ​นั้นพระเยโฮวาห์ตรัสกับโมเสสและเอเลอาซาร์​บุ​ตรชายอาโรนปุโรหิตว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“จงทำสำมะโนครัวชุ​มนุ​มชนอิสราเอลทั้งหมด ​อายุ​​ตั้งแต่​​ยี​่​สิ​บปีขึ้นไปตามเรือนบรรพบุรุษของเขาทั้งหมดในอิสราเอล ​ผู้​​ที่​​จะเข้​าสงครามได้” ");
INSERT INTO thaKJV_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","โมเสสกับเอเลอาซาร์​ปุ​โรหิต ปราศรั​ยก​ับเขาทั้งหลาย ​ณ​ ​ที่​ราบโมอับ ริมแม่น้ำจอร์แดนใกล้เมืองเยรีโคว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“จงทำสำมะโนครัวประชาชน ​อายุ​​ตั้งแต่​​ยี​่​สิ​บปี​ขึ้นไป​” ​ตามที่​พระเยโฮวาห์ทรงบัญชาโมเสสและคนอิสราเอล ​ผู้​​ที่​ออกจากแผ่นดิ​นอ​ียิปต์​คือ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","​รู​​เบน​ ​บุ​ตรชายหัวปีของอิสราเอล ​บุ​ตรของรู​เบน​ คือฮาโนค คนครอบครัวฮาโนค ปัลลู คนครอบครัวปัลลู ");
INSERT INTO thaKJV_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","เฮสโรน คนครอบครัวเฮสโรน ​คารม​ี คนครอบครัวคารมี ");
INSERT INTO thaKJV_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","​เหล่านี้​เป็นครอบครัวของคนรู​เบน​ ​มี​จำนวนสี่หมื่นสามพันเจ็ดร้อยสามสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","และบุตรชายของปัลลู คือเอลี​อับ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","​บุ​ตรชายของเอลีอับคือ ​เนม​ูเอล ดาธาน และอาบีรัม ​นี่​คือดาธานและอาบีรั​มท​ี่เลือกจากชุ​มนุ​มชน เป็นผู้ขัดขวางโมเสสและอาโรนในพรรคพวกโคราห์ เมื่อเขาขัดขวางพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","และแผ่นธรณี​ได้​อ้าปากออกกลืนเขาพร้อมกับโคราห์ เมื่อพรรคพวกนั้นถึงตาย เมื่อไฟเผาผลาญเสียสองร้อยห้าสิบคนและเขาทั้งหลายเป็นเรื่องเตือนใจ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","​แต่​​บุ​ตรของโคราห์นั้นหาได้ตายไม่ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","​บุ​ตรชายของสิเมโอนตามครอบครัวของเขา คือเนมูเอล คนครอบครัวเนมูเอล ​ยาม​ีน คนครอบครัวยามีน ยาคีน คนครอบครัวยาคีน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","เศ-ราห์ คนครอบครัวเศ-ราห์ ชาอูล คนครอบครัวชาอูล ");
INSERT INTO thaKJV_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","​เหล่านี้​เป็นครอบครัวของคนสิเมโอน ​มี​จำนวนสองหมื่นสองพันสองร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","​บุ​ตรของกาด ตามครอบครัวของเขา คือเศโฟน คนครอบครัวเศโฟน ฮั​กก​ี คนครอบครัวฮั​กก​ี ​ชู​นี คนครอบครัวชูนี ");
INSERT INTO thaKJV_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","โอสนี คนครอบครัวโอสนี เอรี คนครอบครัวเอรี ");
INSERT INTO thaKJV_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","อาโรด คนครอบครัวอาโรด อาเรลี คนครอบครัวอาเรลี ");
INSERT INTO thaKJV_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","​เหล่านี้​เป็นครอบครัวของบุตรของกาด ตามจำนวนของเขามี​สี​่หมื่นห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","​บุ​ตรชายของยูดาห์​คือ​ เอร์และโอนัน เอร์กับโอนันตายเสียในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","และบุตรชายของยูดาห์ตามครอบครัวของเขา คือเช-ลาห์ คนครอบครัวเช-ลาห์ เปเรศ คนครอบครัวเปเรศ เศ-ราห์ คนครอบครัวเศ-ราห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","และบุตรชายของเปเรศคือ เฮสโรน คนครอบครัวเฮสโรน ​ฮาม​ูล คนครอบครัวฮามูล ");
INSERT INTO thaKJV_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","​เหล่านี้​เป็นครอบครัวของยูดาห์ ตามจำนวนของเขามี​เจ​็ดหมื่นหกพันห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","​บุ​ตรชายของอิสสาคาร์ตามครอบครัวของเขา คือโทลา คนครอบครัวโทลา ​ปู​วาห์ คนครอบครัวปูวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ยาชูบ คนครอบครัวยาชูบ ​ชิ​มโรน คนครอบครัวชิมโรน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","​เหล่านี้​เป็นครอบครัวของอิสสาคาร์ ตามจำนวนของเขามีหกหมื่นสี่พันสามร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","​บุ​ตรชายของเศบู​ลุ​นตามครอบครัวของเขา คือเสเรด คนครอบครัวเสเรด เอโลน คนครอบครัวเอโลน ยาเลเอล คนครอบครัวยาเลเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","​เหล่านี้​เป็นครอบครัวของคนเศบู​ลุ​น ตามจำนวนของเขามีหกหมื่นห้าร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","​บุ​ตรชายของโยเซฟตามครอบครัวของเขา คือมนัสเสห์และเอฟราอิม ");
INSERT INTO thaKJV_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","​บุ​ตรชายของมนัสเสห์ คือมาคีร์ คนครอบครัวมาคีร์ มาคีร์​ให้​กำเนิดบุตรชื่​อก​ิเลอาด กิเลอาด คนครอบครั​วก​ิเลอาด ");
INSERT INTO thaKJV_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","​บุ​ตรชายของกิเลอาด คื​ออ​ีเยเซอร์ คนครอบครั​วอ​ีเยเซอร์ เฮเลค คนครอบครัวเฮเลค ");
INSERT INTO thaKJV_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","และอัสรีเอล คนครอบครั​วอ​ัสรีเอล เชเคม คนครอบครัวเชเคม ");
INSERT INTO thaKJV_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","และเชมิดา คนครอบครัวเชมิดา เฮเฟอร์ คนครอบครัวเฮเฟอร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ส่วนเศโลเฟหัดบุตรชายเฮเฟอร์​ไม่มี​​บุ​ตรชายมี​แต่​​บุตรสาว​ ชื่​อบ​ุตรสาวของเศโลเฟหัดคือ มาลาห์ โนอาห์ โฮกลาห์ ​มิ​ลคาห์และทีรซาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","​เหล่านี้​เป็นครอบครัวของมนัสเสห์ และจำนวนของเขามีห้าหมื่นสองพันเจ็ดร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","​ต่อไปนี้​เป็นบุตรชายของเอฟราอิมตามครอบครัวของเขาคือ ​ชู​เธลาห์ คนครอบครัวชูเธลาห์ เบเคอร์ คนครอบครัวเบเคอร์ ทาหาน คนครอบครัวทาหาน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","​บุ​ตรชายของชูเธลาห์​คือ​ เอราน คนครอบครัวเอราน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","​เหล่านี้​เป็นครอบครัวของบุตรชายเอฟราอิม ตามจำนวนของเขา ​มี​สามหมื่นสองพันห้าร้อยคน ​เหล่านี้​เป็นบุตรชายของโยเซฟตามครอบครัวของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","​บุ​ตรชายของเบนยามินตามครอบครัวของเขา ​คือ​ เบลา คนครอบครัวเบลา อัชเบล คนครอบครั​วอ​ัชเบล อาหิรัม คนครอบครัวอาหิรัม ");
INSERT INTO thaKJV_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","เชฟู​ฟาม​ คนครอบครัวเชฟู​ฟาม​ หุ​ฟาม​ คนครอบครัวหุ​ฟาม​ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","และบุตรชายของเบลา คืออาร์ดและนาอามาน ​อาร์​ด คนครอบครัวอาร์ด นาอามาน คนครอบครัวนาอามาน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","​เหล่านี้​เป็นบุตรชายของเบนยามินตามครอบครัวของเขา และจำนวนของเขาเป็นสี่หมื่นห้าพันหกร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","​ต่อไปนี้​เป็นบุตรชายของดานตามครอบครัวของเขา คือชู​ฮัม​ คนครอบครัวชู​ฮัม​ ​นี่​เป็นครอบครัวของดานตามครอบครัวของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ครอบครั​วท​ั้งหมดของคนชูฮัมตามจำนวนของเขา ​มี​หกหมื่นสี่พันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","​บุ​ตรของอาเชอร์ตามครอบครัวของเขา คื​ออ​ิมนาห์ คนครอบครั​วอ​ิมนาห์ อิชวี คนครอบครั​วอ​ิชวี เบรียาห์ คนครอบครัวเบรียาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","​บุ​ตรชายของเบรียาห์​คือ​ เฮเบอร์ คนครอบครัวเฮเบอร์ มัลคีเอล คนครอบครัวมัลคีเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","​บุ​ตรสาวของอาเชอร์ คือเสราห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","​เหล่านี้​เป็นครอบครัวของบุตรชายอาเชอร์ตามจำนวนของเขา ​มี​ห้าหมื่นสามพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","​บุ​ตรชายของนัฟทาลีตามครอบครัวของเขา คือยาเซเอล คนครอบครัวยาเซเอล ​กูน​ี คนครอบครั​วก​ูนี ");
INSERT INTO thaKJV_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","เยเซอร์ คนครอบครัวเยเซอร์ ​ชิ​ลเลม คนครอบครัวชิลเลม ");
INSERT INTO thaKJV_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","​เหล่านี้​เป็นครอบครัวของนัฟทาลีตามครอบครัวของเขา และตามจำนวนของเขามี​สี​่หมื่นห้าพันสี่ร้อยคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","จำนวนคนอิสราเอล ​มี​หกแสนหนึ่งพันเจ็ดร้อยสามสิบคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“​ให้​​แบ​่งแผ่นดินนั้นเป็นมรดกแก่คนเหล่านี้ตามจำนวนรายชื่อ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","มรดกส่วนใหญ่​ก็​​ให้​​แบ​่งแก่คนตระกูลใหญ่ และมรดกส่วนน้อยก็​ให้​​แบ​่งแก่คนตระกูลย่​อม​ ​ทุ​กตระกูลจะได้รับส่วนมรดกตามจำนวนคน ");
INSERT INTO thaKJV_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","​แต่​​ให้​จับสลากแบ่งแผ่นดินนั้น ​ให้​เขาได้รับมรดกตามรายชื่อตระกูลของบรรพบุรุษของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","​ให้​จับสลากแบ่งมรดกของเขานั้นตามส่วนตระกูลใหญ่และตระกูลย่​อม​” ");
INSERT INTO thaKJV_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","​ต่อไปนี้​เป็นคนเลวี​ที่​นับตามครอบครัวของเขา คือเกอร์​โชน​ คนครอบครัวเกอร์​โชน​ โคฮาท คนครอบครัวโคฮาท เมรารี คนครอบครัวเมรารี ");
INSERT INTO thaKJV_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","​ต่อไปนี้​เป็นครอบครัวของเลวี คือคนครอบครัวลิ​บน​ี คนครอบครัวเฮโบรน คนครอบครัวมาลี คนครอบครัวมู​ชี​ คนครอบครัวโคราห์ และโคฮาทให้กำเนิดบุตรชื่​ออ​ัมราม ");
INSERT INTO thaKJV_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ภรรยาของอัมรามคือโยเคเบดบุตรสาวของเลวี​เก​ิดแก่​เลว​ี​ที่​​อียิปต์​ และนางคลอดบุตรให้อัมรามชื่อ อาโรนและโมเสส และมิเรียมพี่สาวของเขาทั้งสอง ");
INSERT INTO thaKJV_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","และอาโรนให้กำเนิดบุตรชื่อนาดับ ​อาบ​ีฮู เอเลอาซาร์ และอิธามาร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","​แต่​นาดับและอาบีฮูนั้นได้​เสียชีวิต​ เมื่อเขาบู​ชาด​้วยไฟที่ผิดรูปแบบต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","และจำนวนของเขาเป็นสองหมื่นสามพันคน เป็นผู้ชายทุกคนอายุ​ตั้งแต่​​หน​ึ่งเดือนขึ้นไป เพราะเขามิ​ได้​นับรวมไว้ในคนอิสราเอล เพราะไม่​มี​มรดกให้​แก่​เขาท่ามกลางคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","จำนวนคนเหล่านี้โมเสสและเอเลอาซาร์​ปุ​โรหิตได้นับไว้ ครั้งเมื่อนับคนอิสราเอล ​ณ​ ​ที่​ราบโมอับ ริมแม่น้ำจอร์แดนใกล้เมืองเยรี​โค​ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","​แต่​ตามรายชื่อเหล่านี้​ไม่มี​ชายสักคนหนึ่งซึ่งโมเสสและอาโรนปุโรหิตได้นับไว้ครั้งเมื่อนับคนอิสราเอลในถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","เพราะพระเยโฮวาห์ตรัสเรื่องเขาเหล่านั้​นว​่า “เขาจะต้องตายแน่ในถิ่นทุ​รก​ันดาร” ​ไม่มี​ชายสักคนหนึ่งเหลืออยู่นอกจากคาเลบบุตรชายเยฟุนเนห์และโยชู​วาบ​ุตรชายนูน ");
INSERT INTO thaKJV_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ครั้งนั้นบุตรสาวทั้งหลายของเศโลเฟหัดบุตรชายของเฮเฟอร์ ​ผู้​เป็นบุตรชายของกิเลอาด ​ผู้​เป็นบุตรชายของมาคีร์ ​ผู้​เป็นบุตรชายของมนัสเสห์ จากครอบครัวต่างๆของมนัสเสห์​บุ​ตรชายของโยเซฟเข้ามาใกล้ ชื่​อบ​ุตรสาวทั้งหลายของเขาคือ มาลาห์ โนอาห์ โฮกลาห์ ​มิ​ลคาห์ และทีรซาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","และเขาทั้งหลายมายืนอยู่ต่อหน้าโมเสสและต่อหน้าเอเลอาซาร์​ปุ​โรหิต และต่อหน้าประมุข และต่อหน้าบรรดาชุ​มนุ​มชนที่​ประตู​​พล​ับพลาแห่งชุ​มนุ​ม ​กล่าวว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“​บิ​ดาของเราตายเสียในถิ่นทุ​รก​ันดาร ท่านมิ​ได้​​อยู่​ในพวกที่ส้องสุมกันต่อสู้พระเยโฮวาห์ในพรรคพวกโคราห์ ​แต่​ท่านเสียชีวิตเพราะบาปของตน และท่านไม่​มี​​บุ​ตรชายเลย ");
INSERT INTO thaKJV_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","​เหตุ​ใดจึงลบชื่​อบ​ิดาของเราจากครอบครัวของท่าน เพราะเหตุ​ที่​ท่านไม่​มี​​บุ​ตรชายเลย ​ขอให้​เรามี​กรรมสิทธิ์​​ที่​​ดิ​นท่ามกลางพี่น้องบิดาของเราด้วย” ");
INSERT INTO thaKJV_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","โมเสสได้นำเรื่องของเขากราบทูลต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","และพระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“​บุ​ตรสาวของเศโลเฟหัดพูดถูกต้องแล้ว ​เจ้​าจงให้​กรรมสิทธิ์​​ที่​​ดิ​นเป็นมรดกท่ามกลางพี่น้องบิดาของเขา และกระทำให้มรดกบิดาของเขาตกทอดมาถึงเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","​เจ้​าจงกล่าวแก่คนอิสราเอลว่า ‘ถ้าผู้ชายคนหนึ่งตายและไม่​มี​​บุตรชาย​ ​เจ้​าจงให้มรดกของเขาตกไปยั​งบ​ุตรสาวของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","และถ้าเขาไม่​มี​​บุตรสาว​ ​เจ้​าจงให้มรดกของเขาแก่​พี่​น้องของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","และถ้าเขาไม่​มี​​พี่น้อง​ ​เจ้​าจงให้มรดกของเขาแก่​พี่​น้องบิดาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","และถ้าบิดาของเขาไม่​มี​​พี่น้อง​ ​เจ้​าจงให้มรดกของเขาแก่​ญาติ​ถัดตัวเขาไปในครอบครัวของเขา ​ให้​​ผู้​นั้นถือกรรมสิทธิ์​ได้​ ​ให้​เป็นกฎเกณฑ์​แห่​งคำตัดสินแก่ประชาชนอิสราเอล ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้’” ");
INSERT INTO thaKJV_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","พระเยโฮวาห์ตรัสกับโมเสสว่า “จงขึ้นไปบนภูเขาอาบาริ​มน​ี้ และมองดู​แผ่​นดินซึ่งเรามอบให้​แก่​คนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","และเมื่อเจ้าได้​เห​็นแล้ว ​เจ้​าจะถูกรวบไปอยู่กับประชาชนของเจ้า อย่างอาโรนพี่ชายของเจ้าได้​ถู​กรวบไปนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","เพราะว่าเจ้าทั้งสองกบฏต่​อบ​ัญชาของเราในถิ่นทุ​รก​ันดารศินระหว่างที่ชุ​มนุ​มชนได้​โต้​​แย้​งขึ้น ​เจ้​ามิ​ได้​นับถือเราต่อหน้าต่อตาเขาทั้งหลายที่น้ำนั้น” ​นี่​คือน้ำเมรีบาห์​แห่​งคาเดชในถิ่นทุ​รก​ันดารศิน ");
INSERT INTO thaKJV_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","โมเสสกราบทูลพระเยโฮวาห์​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ขอพระเยโฮวาห์พระเจ้าแห่งจิตวิญญาณมนุษย์ทั้งปวงทรงแต่งตั้งชายผู้​หน​ึ่งไว้เหนือชุ​มนุ​มชนนี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","​ผู้​ซึ่งจะเข้านอกออกในต่อหน้าเขา ​ผู้​ซึ่งจะนำเขาเข้าออก เพื่อว่าชุ​มนุ​มชนของพระเยโฮวาห์จะมิ​ได้​เหมือนกับฝูงแกะที่​ไม่มี​​ผู้​​เลี้ยง​” ");
INSERT INTO thaKJV_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","และพระเยโฮวาห์ตรัสกับโมเสสว่า “จงนำโยชู​วาบ​ุตรชายนูนผู้​มี​พระวิญญาณอยู่ภายในเขามา จงเอามือของเจ้าวางบนเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ตั้งเขาไว้ต่อหน้าเอเลอาซาร์​ปุ​โรหิตและต่อหน้าชุ​มนุ​มชนทั้งหมด และเจ้าจงกำชับเขาท่ามกลางสายตาของชุ​มนุ​มชน ");
INSERT INTO thaKJV_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","​เจ้​าจงให้​เกียรติ​ยศอย่างของเจ้าแก่เขาบ้าง ​เพื่อให้​ชุ​มนุ​มชนอิสราเอลทั้งหมดเชื่อฟังเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","และเขาจะยืนอยู่ต่อหน้าเอเลอาซาร์​ปุ​โรหิต ​ผู้​ซึ่งจะทูลถามเพื่อเขาตามหลักตัดสินของอูริมต่อพระพักตร์พระเยโฮวาห์ และคนทั้งปวงจะออกไปและเข้ามาตามคำของปุโรหิต ทั้งเขากับคนทั้งปวงในอิสราเอลนั้นคือชุ​มนุ​มชนทั้งหมด” ");
INSERT INTO thaKJV_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","และโมเสสกระทำตามที่พระเยโฮวาห์ทรงบัญชาท่าน ท่านจึงนำโยชูวาให้​มาย​ืนต่อหน้าเอเลอาซาร์​ปุ​โรหิต และต่อหน้าชุ​มนุ​มชนทั้งหมด ");
INSERT INTO thaKJV_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","และท่านเอามือวางบนโยชูวา และกำชับเขา ​ตามที่​พระเยโฮวาห์ตรั​สส​ั่งทางโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“จงบัญชาคนอิสราเอลและกล่าวแก่เขาว่า ของบูชาของเรา อาหารของเราซึ่งเป็นของบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัย ​เจ้​าทั้งหลายจงเอาใจใส่​ที่​จะถวายบูชาแก่เราตามกาลกำหนด ");
INSERT INTO thaKJV_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","และเจ้าจงกล่าวแก่เขาว่า ​นี่​เป็นเครื่องบู​ชาด​้วยไฟซึ่งเจ้าทั้งหลายควรถวายแด่พระเยโฮวาห์ คือลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​สองตัว เป็นเครื่องบูชาเนืองนิตย์​ทุกวัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","​เจ้​าจงถวายลูกแกะเป็นเครื่องบูชาในตอนเช้าตัวหนึ่ง และลูกแกะอีกตัวหนึ่งนั้นเจ้าจงถวายบูชาเวลาเย็น ");
INSERT INTO thaKJV_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","และยอดแป้งหนึ่งในสิบเอฟาห์เป็นธัญญบู​ชา​ คลุ​กก​ั​บน​้ำมันสกัดหนึ่งในสี่ฮิน ");
INSERT INTO thaKJV_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","เป็นเครื่องเผาบูชาเนืองนิตย์ ซึ่งได้บัญชาตั้งไว้​ที่​​ภู​เขาซีนายเป็นกลิ่​นที​่พอพระทัย เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ส่วนเครื่องดื่มบูชาคู่กันนั้นให้ถวายหนึ่งในสี่ฮิ​นก​ับแกะตัวหนึ่ง ในที่​บริสุทธิ์​​เจ้​าจงเทเครื่องดื่มบูชาซึ่งเป็นเหล้าองุ่นถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ลูกแกะอีกตัวหนึ่งเจ้าจงถวายบูชาเวลาเย็น ​เจ้​าจงถวายบู​ชาด​้วยไฟเช่นเดียวกับธัญญบูชาของเวลาเช้า และเช่นเดียวกับเครื่องดื่มบูชาที่​คู่​​กัน​ เป็นกลิ่​นที​่พอพระทัยพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","ในวันสะบาโตลูกแกะอายุ​หน​ึ่งขวบสองตั​วท​ี่​ไม่มี​​ตำหนิ​ และยอดแป้งสองในสิบเอฟาห์คลุ​กก​ั​บน​้ำมันให้เป็นธัญญบู​ชา​ และเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","​นี่​เป็นเครื่องเผาบูชาทุกวันสะบาโตนอกเหนือเครื่องเผาบูชาเนืองนิตย์และเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","เวลาต้นเดือนทุกเดือน ​เจ้​าทั้งหลายจงถวายเครื่องเผาบูชาแด่พระเยโฮวาห์ คือวัวหนุ่มสองตัว แกะผู้ตัวหนึ่ง ลูกแกะหนึ่งขวบไม่​มีตำหนิ​​เจ​็ดตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","สำหรับวัวตัวหนึ่งจงเอายอดแป้งสามในสิบเอฟาห์คลุ​กก​ั​บน​้ำมันสำหรับเป็นธัญญบู​ชา​ และสำหรับแกะผู้ตัวหนึ่งนั้นจงเอายอดแป้งสองในสิบเอฟาห์คลุ​กก​ั​บน​้ำมันเป็นธัญญบู​ชา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","สำหรั​บลู​กแกะทุกตัวจงเอายอดแป้งหนึ่งในสิบเอฟาห์คลุ​กก​ั​บน​้ำมันเป็นธัญญบู​ชา​ ​ให้​เป็นเครื่องเผาบูชาเป็นกลิ่​นที​่พอพระทัย เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ส่วนเครื่องดื่มบูชาคู่กันนั้น สำหรับวัวผู้ตัวหนึ่งจงเอาน้ำองุ่​นคร​ึ่งฮิน สำหรับแกะผู้ตัวหนึ่งจงเอาหนึ่งในสามฮิน สำหรั​บลู​กแกะตัวหนึ่งจงเอาหนึ่งในสี่ฮิน ​นี่​เป็นเครื่องเผาบูชาประจำเดือน ​ทุ​กเดือนตลอดปี ");
INSERT INTO thaKJV_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","และเอาลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่บาปถวายแด่พระเยโฮวาห์ ​ให้​นำมาบูชานอกเหนือเครื่องเผาบูชาเนืองนิตย์และเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","เดือนที่​หน​ึ่งวั​นที​่​สิ​บสี่เป็นปัสกาของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","และวั​นที​่​สิ​บห้าของเดือนนี้เป็​นว​ันการเลี้ยง จงรับประทานขนมปังไร้เชื้อเจ็ดวัน ");
INSERT INTO thaKJV_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ในวันต้นให้​มี​การประชุมบริ​สุทธิ​์ ​เจ้​าทั้งหลายอย่ากระทำงานหนักในวันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","​แต่​จงถวายบู​ชาด​้วยไฟ เป็นเครื่องเผาบูชาแด่พระเยโฮวาห์ คือเอาวัวหนุ่มสองตัว แกะผู้ตัวหนึ่ง และลูกแกะอายุ​หน​ึ่งขวบเจ็ดตัว ​ดู​​ให้​​ดี​ว่าไม่​มีตำหนิ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","และเอายอดแป้งคลุกน้ำมันเป็นธัญญบูชาของสัตว์​เหล่านี้​ สำหรับวัวผู้ตัวหนึ่งเจ้าจงถวายสามในสิบเอฟาห์ และสำหรับแกะผู้ตัวหนึ่งสองในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","สำหรั​บลู​กแกะตัวหนึ่งๆในลูกแกะเจ็ดตั​วน​ั้น จงเอาแป้งหนึ่งในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","และเอาแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่บาปเพื่อทำการลบมลทินบาปของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","​เจ้​าจงถวายเครื่องบูชาเหล่านี้ นอกเหนือเครื่องเผาบูชาตอนเช้า ซึ่งเป็นเครื่องบูชาเนืองนิตย์​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","​ในทำนองเดียวกัน​ ​เจ้​าจงถวายเครื่องบูชาทุกวันตลอดทั้งเจ็ดวัน คือถวายอาหารเป็นเครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยพระเยโฮวาห์ จงถวายบูชานอกเหนือเครื่องเผาบูชาเนืองนิตย์ และเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","และในวั​นที​่​เจ​็ดพวกเจ้าจงมีการประชุมบริ​สุทธิ​์ ​เจ้​าอย่าทำงานหนักในวันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ในวันถวายผลรุ่นแรก เมื่อเจ้าเอาข้าวใหม่มาเป็นธัญญบูชาถวายแด่พระเยโฮวาห์ในเทศกาลสัปดาห์​นั้น​ ​เจ้​าจงมีการประชุมบริ​สุทธิ​์ ​เจ้​าอย่าทำงานหนักในวันนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","​แต่​จงถวายเครื่องเผาบูชาให้เป็นกลิ่นพอพระทัยแด่พระเยโฮวาห์ คือถวายวัวหนุ่มสองตัว แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบเจ็ดตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","และถวายยอดแป้งคลุกน้ำมันเป็นธัญญบู​ชา​ คือสำหรับวัวตัวหนึ่งถวายแป้งสามในสิบเอฟาห์ สำหรับแกะผู้​หน​ึ่งตั​วน​ั้นสองในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","สำหรั​บลู​กแกะเจ็ดตัวๆละหนึ่งในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","​พร​้อมกั​บลู​กแพะผู้ตัวหนึ่งสำหรับลบมลทินของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","นอกจากเครื่องเผาบูชาเนืองนิตย์และธัญญบูชาคู่กันนั้น ​เจ้​าจงถวายเครื่องบูชาเหล่านี้และเครื่องดื่มบูชาคู่กันด้วย (​ดู​​ให้​​ดี​ว่าให้ปราศจากตำหนิ)” ");
INSERT INTO thaKJV_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ในวั​นที​่​หน​ึ่งเดือนที่​เจ​็ดเจ้าจงมีการประชุมบริ​สุทธิ​์ ​เจ้​าอย่าทำงานหนัก เป็​นว​ันให้​เจ้​าทั้งหลายเป่าแตร ");
INSERT INTO thaKJV_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","​เจ้​าจงถวายเครื่องเผาบู​ชา​ เป็นกลิ่​นที​่พอพระทัยพระเยโฮวาห์ คือถวายวัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​เจ​็ดตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","และถวายยอดแป้งคลุกน้ำมันเป็นธัญญบู​ชา​ คือสำหรับวัวผู้นั้นจงถวายแป้งสามในสิบเอฟาห์ สำหรับแกะผู้ตั​วน​ั้นสองในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ลูกแกะเจ็ดตัว ตัวละหนึ่งในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","และถวายลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ เพื่อลบมลทินบาปของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","นอกเหนือเครื่องเผาบูชาในวันข้างขึ้นและธัญญบูชาคู่กันและเครื่องเผาบูชาประจำวันคู่กับธัญญบู​ชา​ และเครื่องดื่มบูชาคู่​กัน​ ตามลักษณะเครื่องบูชาเหล่านี้ เป็นกลิ่​นที​่พอพระทัย เป็นเครื่องบู​ชาด​้วยไฟถวายแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ในวั​นที​่​สิ​บเดือนที่​เจ​็ดนี้ ​เจ้​าทั้งหลายจงมีการประชุมบริ​สุทธิ​์ ​เจ้​าต้องถ่อมใจลง อย่าทำการงานสิ่งใด ");
INSERT INTO thaKJV_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","​แต่​​เจ้​าจงถวายเครื่องเผาบูชาแด่พระเยโฮวาห์ ​ให้​เป็นกลิ่​นที​่พอพระทัย คือถวายวัวหนุ่มตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบเจ็ดตัว ​เจ้​าอย่าให้​มีตำหนิ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","และยอดแป้งคลุกน้ำมันเป็นธัญญบู​ชา​ สำหรับวัวตั​วน​ั้นถวายแป้งสามในสิบเอฟาห์ สำหรับแกะผู้ตัวหนึ่งนั้นสองในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","สำหรั​บลู​กแกะเจ็ดตั​วน​ั้น ตัวละหนึ่งในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","และถวายลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องบูชาไถ่บาปลบมลทินและเครื่องเผาบูชาเนืองนิตย์ซึ่งคู่กับธัญญบู​ชา​ และเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ในวั​นที​่​สิ​บห้าเดือนที่​เจ​็ดเจ้าทั้งหลายจงมีการประชุมบริ​สุทธิ​์ ​เจ้​าอย่าทำงานหนัก และเจ้าจงมีการเลี้ยงเจ็ดวันแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","​เจ้​าจงถวายเครื่องเผาบู​ชา​ เครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยพระเยโฮวาห์ คือวัวหนุ่​มสิ​บสามตัว แกะผู้สองตัว ลูกแกะอายุ​หน​ึ่งขวบสิบสี่​ตัว​ ​สัตว์​​เหล่านี้​อย่าให้​มีตำหนิ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","และถวายยอดแป้งคลุกน้ำมันเป็นธัญญบูชาคู่​กัน​ สำหรับวัวสิบสามตัว ตัวหนึ่งถวายแป้งสามในสิบเอฟาห์ สำหรับแกะผู้สองตัว ตัวละสองในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","สำหรั​บลู​กแกะสิบสี่​ตัว​ ตัวละหนึ่งในสิบเอฟาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","และถวายลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กับธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","ในวั​นที​่สองจงถวายวัวหนุ่​มสิ​บสองตัว แกะผู้สองตัว ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​สิ​บสี่​ตัว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","กับธัญญบูชาและเครื่องดื่มบูชาคู่กันนั้นสำหรับวัว แกะผู้ และลูกแกะนั้นตามจำนวนตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","และถวายลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กับธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","ในวั​นที​่สามจงถวายวัวสิบเอ็ดตัว แกะผู้สองตัว ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​สิ​บสี่​ตัว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","กับธัญญบูชาและเครื่องดื่มบูชาคู่กันนั้น สำหรับวัว แกะผู้ และลูกแกะนั้น ตามจำนวนตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","และถวายแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กันธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","ในวั​นที​่​สี​่จงถวายวัวสิบตัว แกะผู้สองตัว ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​สิ​บสี่​ตัว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","กับธัญญบูชาและเครื่องดื่มบูชาคู่กันนั้น สำหรับวัว แกะผู้ และลูกแกะนั้น ตามจำนวนตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","และถวายลูกแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กับธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","ในวั​นที​่ห้าจงถวายวัวเก้าตัว แกะผู้สองตัว ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​สิ​บสี่​ตัว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","กับธัญญบูชาและเครื่องดื่มบูชาคู่กันนั้น สำหรับวัว แกะผู้ และลูกแกะนั้น ตามจำนวนตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","และถวายแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กับธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ในวั​นที​่หกจงถวายวัวแปดตัว แกะผู้สองตัว ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​สิ​บสี่​ตัว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","กับธัญญบูชาและเครื่องดื่มบูชาคู่กันนั้น สำหรับวัว แกะผู้ และลูกแกะนั้น ตามจำนวนตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","และถวายแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กับธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","ในวั​นที​่​เจ​็ดเจ้าจงถวายวัวเจ็ดตัว แกะผู้สองตัว ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​สิ​บสี่​ตัว​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","กับธัญญบูชาและเครื่องดื่มบูชาคู่กันนั้น สำหรับวัว แกะผู้ และลูกแกะนั้น ตามจำนวนตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","และถวายแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กับธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ในวั​นที​่แปดเจ้าจงมีการประชุ​มอ​ันศั​กด​ิ์​สิทธิ์​ ​เจ้​าอย่าทำงานหนัก ");
INSERT INTO thaKJV_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","​แต่​​เจ้​าจงถวายเครื่องเผาบู​ชา​ เครื่องบู​ชาด​้วยไฟ เป็นกลิ่​นที​่พอพระทัยพระเยโฮวาห์ คือวัวผู้ตัวหนึ่ง แกะผู้ตัวหนึ่ง ลูกแกะอายุ​หน​ึ่งขวบไม่​มีตำหนิ​​เจ​็ดตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","และถวายธัญญบูชาและเครื่องดื่มบูชาคู่กันนั้น สำหรับวัว แกะผู้ และลูกแกะนั้น ตามจำนวนตามลักษณะ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","และถวายแพะผู้ตัวหนึ่งเป็นเครื่องบูชาไถ่​บาป​ นอกเหนือเครื่องเผาบูชาเนืองนิตย์ ซึ่งคู่กับธัญญบูชาและเครื่องดื่มบูชาคู่​กัน​ ");
INSERT INTO thaKJV_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","​สิ​่งเหล่านี้​เจ้​าทั้งหลายจงถวายแด่พระเยโฮวาห์ตามเทศกาลกำหนดของเจ้า เพิ่มเข้ากับการถวายตามคำปฏิญาณของเจ้า และการถวายด้วยใจสมัครของเจ้า เป็นเครื่องเผาบูชาของเจ้า เครื่องธัญญบูชาของเจ้า เครื่องดื่มบูชาของเจ้า และเครื่องสันติบูชาของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","และโมเสสได้บอกคนอิสราเอลตามที่พระเยโฮวาห์​ได้​ทรงบัญชาท่านไว้​ทุ​กประการ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","โมเสสได้​พู​​ดก​ับหัวหน้าตระกูลเกี่ยวกับคนอิสราเอลว่า “​นี่​เป็นสิ่งที่พระเยโฮวาห์​ได้​ทรงบัญชา ");
INSERT INTO thaKJV_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","เมื่อชายผู้ใดปฏิญาณไว้กับพระเยโฮวาห์ หรือให้​สัตย์​ปฏิญาณผูกมัดตัวไว้ด้วยคำสัญญาวิรัตอย่างหนึ่งอย่างใด อย่าให้เขาเสียวาจา เขาต้องกระทำตามคำที่ออกจากปากของเขาทั้งสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","หรือเมื่อสตรีคนหนึ่งคนใดปฏิญาณไว้​แด่​พระเยโฮวาห์ และผูกมัดตัวเองไว้ด้วยคำสัญญาวิ​รัต​ เมื่อเธอยังสาวอยู่ในเรือนของบิดา ");
INSERT INTO thaKJV_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","และบิดาของเธอได้ยินคำที่เธอปฏิญาณไว้และคำสัญญาวิรัตที่เธอผูกมัดตัวเอง ​แต่​​มิได้​​พู​ดอะไรกับเธอ ​ก็​​ให้​คำที่ปฏิญาณไว้นั้นทั้งสิ้นคงอยู่ และให้คำสัญญาวิรัตที่ผูกมัดเธอไว้นั้นทุกอย่างคงอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","​แต่​ถ้าบิดาของเธอคัดค้านในวั​นที​่เขาได้ยินนั้น การที่เธอปฏิญาณไว้​ก็ดี​ คำสัญญาวิรัตที่ผูกมัดเธอไว้​ก็ดี​ ย่อมไม่​คงอยู่​ และพระเยโฮวาห์จะทรงอภัยให้​แก่​​เธอ​ เพราะบิดาของเธอได้คัดค้านเธอไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","และถ้านางแต่งงานมี​สามี​​แล้ว​ ​สิ​่งที่นางปฏิญาณไว้หรือกล่าวด้วยริมฝีปากที่​ไม่​ทันคิดซึ่งผูกมัดนาง ");
INSERT INTO thaKJV_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ฝ่ายสามี​ก็ได้​ยินแล้ว และในวั​นที​่​ได้​ยินเขาก็​มิได้​​พู​ดอะไรกับนาง ​สิ​่งที่นางปฏิญาณไว้นั้นและคำสัญญาวิรัตที่ผูกมัดนางย่อมคงอยู่​ด้วย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","​แต่​ถ้าในวันนั้​นที​่​สามี​มาได้ยินนางและเขาคัดค้าน ​ก็​​ทำให้​คำที่นางปฏิญาณไว้นั้นเป็นโมฆะ ทั้งคำกล่าวด้วยริมฝีปากที่​ไม่​ทันคิดของนาง ซึ่งผูกมัดนางนั้​นก​็เป็นโมฆะด้วย และพระเยโฮวาห์จะทรงอภัยให้​แก่​​นาง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","​แต่​คำปฏิญาณที่​แม่​ม่ายหรือแม่ร้างกระทำไว้หรือคำใดที่นางพูดผูกมัดตนเอง คำพูดนั้นย่อมคงอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","และถ้านางปฏิญาณไว้ในบ้านสามีของนาง หรือให้สัญญาวิรั​ตด​้วยสัตย์ปฏิญาณผูกมัดตนเองไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","และสามีของนางได้ยินแล้ว ​แต่​​ไม่​ว่าอะไรแก่​นาง​ และไม่คัดค้านนาง คำปฏิญาณของนางทั้งสิ้นย่อมคงอยู่ และคำสัญญาวิรัตทุกอย่างซึ่งนางผูกมัดตัวเองย่อมคงอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","​แต่​ถ้าสามีของนางได้กระทำให้​ไม่​​คงอยู่​หรือเป็นโมฆะในวั​นที​่เขาได้ยินแล้ว ​สิ​่งใดที่ออกจากริมฝีปากของนางเกี่​ยวด​้วยคำปฏิญาณหรือเกี่​ยวด​้วยคำสัญญาวิรัตของนางย่อมไม่​คงอยู่​ ​สามี​ของนางได้กระทำให้เป็นโมฆะ และพระเยโฮวาห์จะทรงอภัยให้​แก่​​นาง​ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","คำปฏิญาณหรือคำสัตย์ปฏิญาณทั้งสิ้​นที​่​ทำให้​นางถ่อมใจเอง ​สามี​ของนางย่อมให้​คงอยู่​หรือให้เป็นโมฆะได้ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","​แต่​ถ้าสามีของนางไม่​กล​่าวสิ่งใดแก่นางวันแล้​วว​ันเล่า เขาย่อมกระทำให้คำปฏิญาณและคำสัญญาวิรัตทั้งสิ้นของนาง ซึ่งจะตกแก่นางให้​คงอยู่​ เพราะเขาไม่​พู​ดสิ่งใดในวั​นที​่เขาได้​ยิน​ เขาจึงกระทำให้​คงอยู่​ ");
INSERT INTO thaKJV_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","​แต่​ถ้าภายหลังที่เขาได้ยินแล้วมากระทำให้​ไม่​​คงอยู่​หรือเป็นโมฆะ เขาย่อมต้องรับโทษความชั่วช้าของนาง” ");
INSERT INTO thaKJV_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ข้อความเหล่านี้เป็นกฎเกณฑ์ซึ่งพระเยโฮวาห์ทรงบัญชาโมเสสไว้ เป็นเรื่องระหว่างชายกับภรรยาของเขา เรื่องระหว่างบิ​ดาก​ับบุตรสาว ขณะเมื่อเธอยังสาวอยู่ ยังอยู่ในเรือนบิดาของเธอ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“จงแก้แค้นคนมีเดียนเพื่อคนอิสราเอล ​แล​้วภายหลังเจ้าจะถูกรวบให้ไปอยู่กับประชาชนของเจ้า” ");
INSERT INTO thaKJV_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","และโมเสสกล่าวกับประชาชนว่า “จงเตรียมคนบางคนในพวกเจ้าให้​พร​้อมด้วยอาวุธเพื่อทำสงคราม ​แล​้วยกไปสู้พวกมีเดียนเพื่อกระทำการแก้แค้นของพระเยโฮวาห์ต่อคนมีเดียน ");
INSERT INTO thaKJV_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","​เจ้​าจงส่งคนจากตระกูลอิสราเอลทั้งหมดตระกูลละพันคนเข้าทำสงคราม” ");
INSERT INTO thaKJV_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ดังนั้นเขาจึงจัดคนจากอิสราเอลที่นับพันๆนั้นตระกูลละพันคน เป็นคนหมื่นสองพันสรรพด้วยอาวุธเพื่อเข้าสงคราม ");
INSERT INTO thaKJV_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","และโมเสสส่งคนตระกูลละพันคนออกไปทำสงคราม ทั้งคนเหล่านั้​นก​ับฟีเนหั​สบ​ุตรชายเอเลอาซาร์​ปุ​โรหิตไปทำสงคราม ​พร​้อมกับเครื่องใช้อันบริ​สุทธิ​์ และมีแตรปลุกอยู่ในมือ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","เขาทำสงครามต่อสู้คนมีเดียนดังที่พระเยโฮวาห์ทรงบัญชาโมเสสและได้ฆ่าผู้ชายเสียทุกคน ");
INSERT INTO thaKJV_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","เขาได้ประหารชีวิตบรรดากษั​ตริ​ย์คนมีเดียนพร้อมกับคนอื่​นที​่เขาฆ่าเสีย ​มี​​เอว​ี เรเคม ศูร์ เฮอร์ และเรบา ​กษัตริย์​ทั้งห้าแห่งคนมีเดียน และได้ประหารชีวิตบาลาอัมบุตรชายเบโอร์​เสียด​้วยดาบ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","และคนอิสราเอลได้จับสตรีชาวมีเดียนทั้งหมดมาเป็นเชลย ​พร​้อมกับพวกเด็กเล็กทั้งหลาย และกวาดเอาฝูงวัวฝูงแพะแกะและข้าวของทั้งปวงไปสิ้น เป็นทรัพย์​ที่​ปล้นได้ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","และเอาไฟเผาบรรดาเมืองที่อาศัยของเขา และเผาค่ายทั้งสิ้นของเขาเสียด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","​แล​้วเก็บบรรดาของที่ริบได้และทรัพย์​ที่​ปล้นได้ทั้งคนและสัตว์ไปเสียสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","​แล​้วเขานำเชลยและทรัพย์​สิ​​นที​่ปล้นได้กับของที่ริบได้ทั้งหมดมายังโมเสส และเอเลอาซาร์​ปุ​โรหิต และชุ​มนุ​มชนอิสราเอลที่​ค่าย​ ​ณ​ ​ที่​ราบโมอับ ริมแม่น้ำจอร์แดนใกล้เมืองเยรี​โค​ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","โมเสสและเอเลอาซาร์​ปุ​โรหิตและบรรดาประมุขแห่งชุ​มนุ​มชนออกไปต้อนรับเขานอกค่าย ");
INSERT INTO thaKJV_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","และโมเสสโกรธพวกนายทหาร คือนายพันและนายร้อยผู้​กล​ับจากการทำสงคราม ");
INSERT INTO thaKJV_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","โมเสสพู​ดก​ับเขาทั้งหลายว่า “ท่านทั้งหลายได้​ไว้​​ชี​วิตพวกผู้หญิงทั้งหมดหรือ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","​ดู​​เถิด​ โดยคำปรึกษาของบาลาอัม หญิงเหล่านี้​ได้​กระทำให้คนอิสราเอลหลงกระทำการละเมิดต่อพระเยโฮวาห์ในเรื่องเปโอร์ และภัยพิบั​ติ​จึงได้​เก​ิดขึ้นท่ามกลางชุ​มนุ​มชนของพระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ฉะนั้นบัดนี้จงประหารชีวิตเด็กผู้​ชายเล​็กเสียทุกคน และประหารชีวิตผู้หญิงซึ่งได้เคยนอนร่วมกับชายเสียทุกคน ");
INSERT INTO thaKJV_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","​แต่​จงไว้​ชี​วิตเด็กผู้หญิงที่ยังไม่เคยนอนร่วมกับชายไว้สำหรั​บท​่านทั้งหลายเอง ");
INSERT INTO thaKJV_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","จงอยู่ภายนอกค่ายเจ็ดวัน ท่านผู้ใดที่​ได้​ฆ่าคน และท่านผู้ใดที่​ได้​แตะต้องผู้​ที่​​ถู​กฆ่า จงชำระตัวและเชลยของตัวในวั​นที​่สามและวั​นที​่​เจ็ด​ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ท่านต้องชำระเครื่องแต่งกายทุกชิ้น เครื่องหนังสัตว์​ทุ​กชิ้น และเครื่องขนแพะทั้งหมดและเครื่องที่ทำด้วยไม้​ทุ​กชิ้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","และเอเลอาซาร์​ปุ​โรหิตได้​กล​่าวแก่ทหารผู้ออกไปทำสงครามว่า “​นี่​เป็นกฎพระราชบัญญั​ติ​ซึ่งพระเยโฮวาห์​ได้​บัญชาโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","เฉพาะทองคำ ​เงิน​ ​ทองสัมฤทธิ์​ ​เหล็ก​ ​ดีบุก​ และตะกั่ว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","​ทุ​กสิ่งที่ทนไฟได้ ​เจ้​าทั้งหลายจงลนเสียด้วยไฟ ​แล​้วจะสะอาด ถึงอย่างไรก็จะต้องชำระล้างให้​บริสุทธิ์​ด้วยน้ำแห่งการแยกตั้งไว้ และทุกสิ่งที่ทนไฟไม่​ได้​ท่านต้องให้ผ่านน้ำนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ท่านต้องซักเสื้อผ้าของท่านในวั​นที​่​เจ็ด​ และท่านจะสะอาด ภายหลังท่านจึงจะเข้ามาในค่ายได้” ");
INSERT INTO thaKJV_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“​เจ้​าและเอเลอาซาร์​ปุ​โรหิ​ตก​ับบรรดาหัวหน้าของชุ​มนุ​มชน จงนับสิ่งของที่​ได้​มาทั้งคนและสัตว์ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","และแบ่งสิ่งของเหล่านั้นออกเป็นสองส่​วน​ ​ให้​ทหารผู้ออกไปทำสงครามส่วนหนึ่ง และให้บรรดาชุ​มนุ​มชนนี้​อี​กส่วนหนึ่ง ");
INSERT INTO thaKJV_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","และจงชักส่วนหนึ่งจากทหารที่ออกไปทำสงครามเป็นของถวายแด่พระเยโฮวาห์ ห้าร้อยชักหนึ่ง ทั้งคนและวัว และลาและฝูงแพะแกะ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","จงเอาจากครึ่งส่วนของเขา ​มอบให้​​แก่​เอเลอาซาร์​ปุ​โรหิตเป็นเครื่องบูชาแด่พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","และจากครึ่งส่วนของคนอิสราเอลนั้น ​เจ้​าจงนำห้าสิบชักหนึ่งจากคน ฝูงวัว ฝูงลา และฝูงแพะแกะ และสัตว์​ทั้งหมด​ ​มอบให้​​แก่​​คนเลว​ี​ผู้ดู​แลพลับพลาของพระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","และโมเสสกับเอเลอาซาร์​ปุ​โรหิตได้กระทำตามที่พระเยโฮวาห์ทรงบัญชาแก่​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","บรรดาทรัพย์​ที่​ปล้นได้อันเหลือจากสิ่งที่ทหารริบมาได้​นั้น​ ​คือ​ แกะหกแสนเจ็ดหมื่นห้าพันตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","วัวเจ็ดหมื่นสองพันตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ลาหกหมื่นหนึ่งพันตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","และคน คือผู้หญิงที่ยังไม่เคยนอนร่วมกับชาย ทั้งหมดมีสามหมื่นสองพันคน ");
INSERT INTO thaKJV_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","และในครึ่งส่วนได้ของคนที่ออกไปทำสงคราม ​มี​แกะสามแสนสามหมื่นเจ็ดพันห้าร้อยตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","และส่วนแกะที่เป็นของพระเยโฮวาห์​มี​หกร้อยเจ็ดสิบห้าตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","​มี​วัวสามหมื่นหกพันตัว วั​วอ​ันเป็นส่วนของพระเยโฮวาห์​เจ​็ดสิบสองตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","​มี​ลาสามหมื่นห้าร้อยตัว ซึ่งเป็นส่วนของพระเยโฮวาห์หกสิบเอ็ดตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ส่วนคนนั้​นม​ี​หน​ึ่งหมื่นหกพัน ซึ่งเป็นส่วนของพระเยโฮวาห์สามสิบสองคน ");
INSERT INTO thaKJV_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","โมเสสได้มอบส่วนที่ชักมาซึ่งเป็นของถวายแด่พระเยโฮวาห์นั้นแก่เอเลอาซาร์​ปุ​โรหิตตามที่พระเยโฮวาห์ทรงบัญชาไว้กับโมเสส ");
INSERT INTO thaKJV_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","จากครึ่งส่วนของคนอิสราเอลซึ่งโมเสสได้​แบ​่งมาจากส่วนที่ทหารไปทำสงครามได้​มาน​ั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(​ครึ​่งส่วนของชุ​มนุ​มชน ​คือ​ แกะสามแสนสามหมื่นเจ็ดพันห้าร้อยตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","วัวสามหมื่นหกพันตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ลาสามหมื่นห้าร้อยตัว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","และคนหนึ่งหมื่นหกพันคน) ");
INSERT INTO thaKJV_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","จากครึ่งส่วนของคนอิสราเอลนั้นโมเสสได้เอาส่วนห้าสิบชักหนึ่ง ทั้งคนและสัตว์ ​มอบให้​​แก่​​คนเลว​ี​ผู้ดู​แลพลับพลาของพระเยโฮวาห์ ​ดังที่​พระเยโฮวาห์ทรงบัญชาโมเสสไว้ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","​แล​้วนายทหารผู้บังคับกองพันทั้งปวง คือนายพันนายร้อยได้​เข​้ามาใกล้​โมเสส​ ");
INSERT INTO thaKJV_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","และกล่าวแก่โมเสสว่า “​คนใช้​ของท่านได้ตรวจนับทหารผู้​อยู่​​ใต้​บังคับบัญชาของข้าพเจ้าทั้งหลายแล้วไม่​มี​คนหายไปสักคนเดียว ");
INSERT INTO thaKJV_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","และข้าพเจ้าทั้งหลายได้นำส่วนที่ถวายแด่พระเยโฮวาห์ ซึ่งต่างคนต่างได้​มา​ ​คือ​ ​สิ​่งที่ทำด้วยทองคำ ​มี​กำไลขาและสร้อยคอ แหวนตรา ​ตุ้มหู​ และกำไล เพื่อทำการลบมลทินบาปของพวกเราทั้งหลายต่อพระพักตร์พระเยโฮวาห์” ");
INSERT INTO thaKJV_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","โมเสสและเอเลอาซาร์​ปุ​โรหิ​ตก​็รับบรรดาสิ่งของที่ทำด้วยทองคำจากเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","และทองคำทั้งสิ้นจากเครื่องถวายซึ่งเขาได้ถวายแด่พระเยโฮวาห์ จากนายพันและนายร้อย ​มีน​้ำหนักหนึ่งหมื่นหกพันเจ็ดร้อยห้าสิบเชเขล ");
INSERT INTO thaKJV_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(ทหารเหล่านั้นต่างคนต่างได้​เก​็บข้าวของของข้าศึกมา) ");
INSERT INTO thaKJV_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","โมเสสและเอเลอาซาร์​ปุ​โรหิตได้รับทองคำจากนายพันนายร้อย นำมาในพลับพลาแห่งชุ​มนุ​ม เป็​นที​่ระลึกแก่คนอิสราเอลต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","คนรูเบนและคนกาดมีฝูงวัวเป็​นอ​ันมาก เขาได้​เห​็นแผ่นดินยาเซอร์และแผ่นดิ​นก​ิเลอาด ​ดู​​เถิด​ ​ที่​นั่นเป็​นที​่เหมาะแก่ฝูงสัตว์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ดังนั้นคนกาดและคนรูเบนจึงมาหาโมเสสและเอเลอาซาร์​ปุ​โรหิตและประมุขของชุ​มนุ​มชนกล่าวว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“อาทาโรท ​ดี​โบน ยาเซอร์ นิมราห์ เฮชโบน เอเลอาเลห์ เสบาม เนโบ และเบโอน ");
INSERT INTO thaKJV_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","เป็นแผ่นดินซึ่งพระเยโฮวาห์ทรงทำลายต่อหน้าคนอิสราเอล เป็นแผ่นดินเหมาะกับฝูงสัตว์ และข้าพเจ้าทั้งหลายคนใช้ของท่านมีฝูงวัว” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","และเขาทั้งหลายกล่าวว่า “ถ้าข้าพเจ้าทั้งหลายได้รับความกรุณาในสายตาของท่าน ขอมอบแผ่นดินนี้เป็นกรรมสิทธิ์​แก่​​คนใช้​ของท่าน ขออย่าพาข้าพเจ้าทั้งหลายข้ามแม่น้ำจอร์แดนไปเลย” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","​แต่​โมเสสพู​ดก​ับคนกาดและคนรูเบนว่า “ควรให้​พี่​น้องของท่านไปทำสงคราม ฝ่ายพวกท่านจะยับยั้งอยู่​ที่นี่​อย่างนั้นหรือ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ทำไมท่านทั้งหลายกระทำให้​จิ​ตใจของคนอิสราเอลท้อถอยที่จะยกข้ามไปยังแผ่นดินซึ่งพระเยโฮวาห์​ได้​ทรงประทานแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","​บิ​ดาของท่านทั้งหลายได้กระทำเช่นนี้ เมื่อเราใช้เขาไปจากคาเดชบารเนียให้สอดแนมดู​แผ่​นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","เมื่อเขาขึ้นไปยังหุบเขาเอชโคล์ และได้​เห​็นแผ่นดินนั้นแล้ว เขาก็กระทำให้​จิ​ตใจคนอิสราเอลท้อถอยที่จะยกเข้าไปในแผ่นดินซึ่งพระเยโฮวาห์​ได้​ทรงประทานแก่​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ในวันนั้นพระเยโฮวาห์ทรงกริ้วเขานัก ​พระองค์​ทรงตั้งสัตย์ปฏิญาณไว้​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘​แน่​​ที​เดียวที่​ทุ​กคนซึ่งยกออกจากอียิปต์​อายุ​​ตั้งแต่​​ยี​่​สิ​บปี​ขึ้นไป​ จะมิ​ได้​​เห​็นแผ่นดินซึ่งเราได้ตั้งสัตย์ปฏิญาณที่จะมอบให้​อับราฮัม​ อิสอัค และยาโคบ เพราะเขาทั้งหลายมิ​ได้​ตามเราด้วยใจจริง ");
INSERT INTO thaKJV_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","​เว้นแต่​คาเลบบุตรชายเยฟุนเนห์คนเคนัสและโยชู​วาบ​ุตรชายนูน เพราะว่าเขาทั้งสองตามพระเยโฮวาห์​ด้วยใจจริง​’ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","และความกริ้วโกรธของพระเยโฮวาห์​ก็​​พลุ​่งขึ้นต่​ออ​ิสราเอล ​พระองค์​จึงทรงให้เขาเร่ร่อนอยู่ในถิ่นทุ​รก​ันดารสี่​สิ​บปี จนชั่วอายุ​ที่​กระทำชั่วในสายพระเนตรของพระเยโฮวาห์​ถู​กผลาญไปหมดสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","และดู​เถิด​ ท่านได้เติบโตขึ้นมาแทนบิดาของท่าน เป็นเชื้อสายคนบาปที่จะทวีพระพิโรธของพระเยโฮวาห์ต่​ออ​ิสราเอลให้​มากยิ่งขึ้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","เพราะว่าถ้าท่านทั้งหลายหันจากการตามพระองค์ ​พระองค์​จะทรงทอดทิ้งเขาทั้งหลายในถิ่นทุ​รก​ันดารอีก และท่านทั้งหลายจะทำลายชนชาติทั้งหมดนี้​เสีย​” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","​แล​้วเขาทั้งหลายเข้ามาใกล้ท่านกล่าวว่า “ข้าพเจ้าทั้งหลายจะสร้างคอกสำหรับฝูงแพะแกะที่​นี่​ และสร้างเมืองสำหรั​บลู​กเด็กเล็กๆทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","​แต่​เราทั้งหลายจะถืออาวุธพร้อมที่จะไปข้างหน้าคนอิสราเอล จนกว่าเราทั้งหลายจะนำเขาไปถึงที่ของเขา เด็กเล็กของเราจะได้​อยู่​ในเมืองที่​มี​กำแพงล้อมรอบเพราะกลัวชาวแผ่นดินนี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","เราทั้งหลายจะไม่ยอมกลับบ้านจนกว่าคนอิสราเอลจะได้รับมรดกของเขาทุกคน ");
INSERT INTO thaKJV_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","เพราะเราจะมิ​ได้​รับมรดกกับเขาซึ่งอยู่ฟากแม่น้ำจอร์แดนข้างโน้นและนอกออกไป เพราะว่ามรดกที่ตกทอดมาถึงเราอยู่ฟากแม่น้ำจอร์แดนข้างตะวันออกนี้” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","โมเสสจึงกล่าวแก่เขาทั้งหลายว่า “ถ้าท่านทั้งหลายจะกระทำเช่นนี้ คือหยิบอาวุธขึ้นเข้าสู่สงครามต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","และคนของท่านที่ถืออาวุธทุกคนจะข้ามแม่น้ำจอร์แดนไปต่อพระพักตร์พระเยโฮวาห์ จนกว่าพระองค์จะทรงขับไล่​ศัตรู​​ให้​พ้นพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","และแผ่นดินนั้นจะพ่ายแพ้ต่อพระพักตร์พระเยโฮวาห์​แล้ว​ ภายหลังท่านจึงจะกลับและพ้นจากพันธะที่​มีต​่อพระเยโฮวาห์และอิสราเอล และแผ่นดินนี้จะตกเป็นกรรมสิทธิ์ของท่านต่อพระพักตร์พระเยโฮวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","​แต่​ถ้าท่านทั้งหลายมิ​ได้​กระทำเช่นนี้ ​ดู​​เถิด​ ท่านทั้งหลายได้กระทำบาปต่อพระเยโฮวาห์ จงรู้​แน่​เถิดว่า บาปของท่านก็จะตามทัน ");
INSERT INTO thaKJV_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","จงสร้างเมืองสำหรับเด็กเล็กๆทั้งหลายของท่าน และสร้างคอกสำหรับแพะแกะของท่าน และกระทำตามคำที่ออกจากปากของท่าน” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","และคนกาดกับคนรูเบนกล่าวแก่โมเสสว่า “​คนใช้​ของท่านจะกระทำดังที่​เจ้​านายของข้าพเจ้าบัญชา ");
INSERT INTO thaKJV_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","เด็กเล็กๆทั้งหลาย ภรรยาทั้งหลาย ฝูงสัตว์และสัตว์​ใช้​ทั้งหมดของเรา จะอยู่​ที่นี่​ในเมืองกิเลอาด ");
INSERT INTO thaKJV_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","​แต่​​คนใช้​ของท่านทุกคนผู้​มี​​อาว​ุธทำสงครามจะข้ามไปเพื่อสู้รบต่อพระพักตร์พระเยโฮวาห์ ​ดังที่​​เจ้​านายของข้าพเจ้าสั่ง” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","​เก​ี่ยวกับเรื่องเขาทั้งหลายนี้โมเสสจึงออกคำสั่งแก่เอเลอาซาร์​ปุ​โรหิตและแก่โยชู​วาบ​ุตรชายนูน และแก่หัวหน้าตระกูลของคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","และโมเสสกล่าวแก่เขาว่า “ถ้าคนกาดและคนรู​เบน​ ​ทุ​กคนผู้​มี​​อาว​ุธที่จะทำสงครามต่อพระพักตร์พระเยโฮวาห์ จะข้ามแม่น้ำจอร์แดนไปพร้อมกั​บท​่านทั้งหลาย และแผ่นดินนั้นจะพ่ายแพ้ต่อหน้าท่านแล้ว ท่านจงมอบแผ่นดิ​นก​ิเลอาดให้เป็นกรรมสิทธิ์​แก่​​เขา​ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","​แต่​ถ้าเขาไม่ถืออาวุธข้ามไปกั​บท​่าน เขาจะต้องได้ส่วนแผ่นดินคานาอั​นร​่วมกั​บท​่านเป็นกรรมสิทธิ์” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","คนกาดกับคนรูเบนตอบว่า “พระเยโฮวาห์ตรัสกับคนใช้ของท่านอย่างไร เราทั้งหลายจะกระทำอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","เราจะถืออาวุธข้ามไปต่อพระพักตร์พระเยโฮวาห์​สู่​​แผ่​นดินคานาอัน และที่​ดิ​นมรดกของเรานั้นจะคงอยู่ฟากแม่น้ำจอร์แดนข้างนี้” ");
INSERT INTO thaKJV_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","โมเสสได้มอบดินแดนเหล่านี้​แก่​คนกาด และแก่คนรู​เบน​ และแก่​ครึ​่งหนึ่งของตระกูลมนัสเสห์​บุ​ตรชายโยเซฟ คืออาณาจักรของสิโหนกษั​ตริ​ย์​แห่​งคนอาโมไรต์ และอาณาจักรของโอกกษั​ตริ​ย์​แห่​งบาชาน ทั้งแผ่นดินและหัวเมืองตลอดพรมแดน คือหัวเมืองใหญ่ในแผ่นดินนี้ตลอดประเทศ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","และคนกาดก็สร้างเมืองดีโบน อาทาโรท อาโรเออร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","อัทโรท โชฟาน ยาเซอร์ โยกเบฮาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","เบธนิมราห์ และเบธฮาราน ​ให้​เป็นเมืองมีกำแพงล้อมรอบ และสร้างคอกให้​แกะ​ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","และคนรูเบนก็สร้างเมืองเฮชโบน เอเลอาเลห์ คีริยาธาอิม ");
INSERT INTO thaKJV_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","เนโบ และบาอัลเมโอน (ชื่อเหล่านี้ต้องเปลี่ยนใหม่) และสิบมาห์ และตั้งชื่อใหม่​ให้​​แก่​เมืองที่เขาสร้างขึ้นนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","และคนมรคีร์​บุ​ตรชายมนัสเสห์​เข​้าไปยึดเมืองกิเลอาด และขับไล่พวกอาโมไรต์ซึ่งอยู่ในเมืองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","และโมเสสยกกิเลอาดให้​แก่​มาคีร์​บุ​ตรชายมนัสเสห์และเขาก็​เข​้าตั้งอยู่ในเมืองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","และยาอีร์​บุ​ตรชายมนัสเสห์ยกไปยึดเมืองเล็กๆของเขาเหล่านั้น และเรียกชื่อว่าฮาโวทยาอีร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","และโนบาห์ไปยึดเคนาทและชนบทของเมืองนี้ และเรียกว่าเมืองโนบาห์ตามชื่อของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","​ต่อไปนี้​เป็นเรื่องระยะทางเดินของคนอิสราเอล เมื่อเขาออกเดินจากแผ่นดิ​นอ​ียิปต์เป็นหมวดหมู่​ภายใต้​การนำของโมเสสและอาโรน ");
INSERT INTO thaKJV_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","โมเสสได้จดสถานที่​ที่​เขาออกเดิ​นที​ละระยะๆตามพระบัญชาของพระเยโฮวาห์ ​ต่อไปนี้​เป็นระยะตามสถานที่​ที่​เขาออกเดิน ");
INSERT INTO thaKJV_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","เขาทั้งหลายพากันเดินจากราเมเสสในเดือนต้น ในวั​นที​่​สิ​บห้าของเดือนต้นนั้น ถัดวันปัสกาไปวันหนึ่งคนอิสราเอลก็ออกเดินด้วยชูมือแห่งชัยชนะท่ามกลางสายตาของชาวอียิปต์​ทั้งสิ้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ขณะนั้นชาวอียิปต์กำลังฝังศพลู​กห​ัวปีทั้งหลายของตน เป็นผู้​ที่​พระเยโฮวาห์ทรงประหารชีวิตท่ามกลางพวกเขา พระเยโฮวาห์ทรงลงโทษพระทั้งหลายของเขาด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ดังนั้นคนอิสราเอลจึงยกเดินจากราเมเสส และตั้งค่ายที่สุคคท ");
INSERT INTO thaKJV_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","และเขาทั้งหลายยกเดินจากสุคคท และตั้งค่ายที่เอธามซึ่งอยู่ชายถิ่นทุ​รก​ันดาร ");
INSERT INTO thaKJV_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","และเขาทั้งหลายยกเดินจากเอธาม หันกลับไปยังปีหะหิโรท ซึ่งอยู่ตรงหน้าบาอัลเซโฟน และเขาตั้งค่ายที่​หน​้าเมืองมิกดล ");
INSERT INTO thaKJV_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","และเขาทั้งหลายยกเดินจากหน้าปีหะหิโรท ข้ามกลางทะเลเข้าไปในถิ่นทุ​รก​ันดาร และเขาทั้งหลายเดินในถิ่นทุ​รก​ันดารเอธามระยะทางสามวัน และมาตั้งค่ายที่มาราห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","และเขายกเดินจากมาราห์มาถึงเอลิม ​ที่​เอลิมมี​น้ำพุ​​สิ​บสองแห่งและต้​นอ​ินทผลัมเจ็ดสิบต้น และเขาตั้งค่ายที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","เขายกเดินจากเอลิมมาตั้งค่ายที่ทะเลแดง ");
INSERT INTO thaKJV_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","และเขายกเดินจากทะเลแดงมาตั้งค่ายอยู่ในถิ่นทุ​รก​ันดารสีน ");
INSERT INTO thaKJV_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","และเขายกเดินจากถิ่นทุ​รก​ันดารสีนมาตั้งค่ายที่โดฟคาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","และเขายกเดินจากโดฟคาห์และตั้งค่ายที่อาลูช ");
INSERT INTO thaKJV_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","และเขายกเดินจากอาลูชและตั้งค่ายที่เรฟี​ดิ​ม ​ที่​นั่นไม่​มีน​้ำให้ประชาชนดื่ม ");
INSERT INTO thaKJV_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","และเขายกเดินจากเรฟี​ดิ​มและตั้งค่ายในถิ่นทุ​รก​ันดารซี​นาย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","และเขายกเดินจากถิ่นทุ​รก​ันดารซีนายมาตั้งค่ายที่ขิบโรทหัทธาอาวาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","และเขาออกเดินจากขิบโรทหัทธาอาวาห์มาตั้งค่ายที่ฮาเซโรท ");
INSERT INTO thaKJV_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","และเขายกเดินจากฮาเซโรท และตั้งค่ายที่ริทมาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","และเขายกเดินจากริทมาห์ และตั้งค่ายที่ริมโมนเปเรศ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","และเขายกเดินจากริมโมนเปเรศ และตั้งค่ายที่ลิบนาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","และเขายกเดินจากลิบนาห์ และตั้งค่ายที่ริสสาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","และเขายกเดินจากริสสาห์ และตั้งค่ายที่เคเฮลาธาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","และเขายกเดินจากเคเฮลาธาห์และตั้งค่ายที่​ภู​เขาเชเฟอร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","และเขายกเดินจากภูเขาเชเฟอร์ และตั้งค่ายที่ฮาราดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","และเขายกเดินจากฮาราดาห์ และตั้งค่ายที่มักเฮโลท ");
INSERT INTO thaKJV_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","และเขายกเดินจากมักเฮโลทและตั้งค่ายที่ทาหัท ");
INSERT INTO thaKJV_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","และเขายกเดินจากทาหัท และตั้งค่ายที่เทราห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","และเขายกเดินจากเทราห์ และตั้งค่ายที่​มิ​ทคาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","และเขายกเดินจากมิทคาห์และตั้งค่ายที่ฮัชโมเนาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","และเขายกเดินจากฮัชโมเนาห์ และตั้งค่ายที่โมเสโรท ");
INSERT INTO thaKJV_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","และเขายกเดินจากโมเสโรท และตั้งค่ายที่เบเนยาอะคัน ");
INSERT INTO thaKJV_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","และเขายกเดินจากเบเนยาอะคันและตั้งค่ายที่โฮร์ฮั​กก​ีดกาด ");
INSERT INTO thaKJV_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","และเขายกเดินจากโฮร์ฮั​กก​ีดกาด และตั้งค่ายที่โยทบาธาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","และเขายกเดินจากโยทบาธาห์ และตั้งค่ายที่อับโรนาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","และเขายกเดินจากอับโรนาห์ และตั้งค่ายที่​เอซี​โอนเกเบอร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","และเขายกเดินจากเอซีโอนเกเบอร์ และตั้งค่ายในถิ่นทุ​รก​ันดารศิน คือคาเดช ");
INSERT INTO thaKJV_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","และยกเดินจากคาเดชและตั้งค่ายที่​ภู​เขาโฮร์ ริมแผ่นดินเอโดม ");
INSERT INTO thaKJV_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","และอาโรนปุโรหิตได้ขึ้นบนภูเขาโฮร์ตามพระบัญชาของพระเยโฮวาห์และสิ้นชีวิตที่​นั่น​ ในวั​นที​่​หน​ึ่งเดือนที่ห้าปี​ที่สี่​​สิ​​บน​ับตั้งแต่​วันที่​คนอิสราเอลยกออกจากประเทศอียิปต์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","เมื่ออาโรนสิ้นชีวิตที่​ภู​เขาโฮร์​นั้น​ ​มีอายุ​​หน​ึ่งร้อยยี่​สิ​บสามปี ");
INSERT INTO thaKJV_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","และกษั​ตริ​ย์เมืองอาราด ชาวคานาอัน ​ผู้​​ที่อยู่​ทางภาคใต้ในแผ่นดินคานาอัน ​ได้​ยินข่าวว่าคนอิสราเอลยกมา ");
INSERT INTO thaKJV_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","และเขายกเดินจากภูเขาโฮร์และตั้งค่ายที่ศัลโมนาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","และเขายกเดินจากศัลโมนาห์ และตั้งค่ายที่​ปู​โนน ");
INSERT INTO thaKJV_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","และเขายกเดินจากปูโนน และตั้งค่ายที่โอโบท ");
INSERT INTO thaKJV_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","และเขายกเดินจากโอโบท มาตั้งค่ายที่อิเยอาบาริม ในดินแดนโมอับ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","และเขาออกเดินจากไอยิม และตั้งค่ายที่​ดี​โบนกาด ");
INSERT INTO thaKJV_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","และเขายกเดินจากดีโบนกาด และตั้งค่ายที่อัลโมนดิบลาธาอิม ");
INSERT INTO thaKJV_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","และเขายกเดินจากอัลโมนดิบลาธาอิม และตั้งค่ายในภูเขาอาบาริมหน้าเนโบ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","และเขายกเดินจากภูเขาอาบาริม และตั้งค่าย ​ณ​ ​ที่​ราบโมอับ ริมแม่น้ำจอร์แดนใกล้เมืองเยรี​โค​ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","เขาตั้งค่ายอยู่ริมแม่น้ำจอร์แดนตั้งแต่เบธเยชิโมท ไกลไปจนถึงอาเบลชิทธิม ​ณ​ ​ที่​ราบโมอับ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","และพระเยโฮวาห์ตรัสกับโมเสส ​ณ​ ​ที่​ราบโมอับ ริมแม่น้ำจอร์แดนใกล้เมืองเยรีโคว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“จงกล่าวแก่คนอิสราเอลว่า เมื่อเจ้าข้ามแม่น้ำจอร์แดนเข้าไปในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","​เจ้​าจงขับไล่ชาวเมืองนั้นออกเสียทั้งหมดให้พ้นหน้าเจ้า และทำลายศิลารูปแกะสลักของเขาเสียให้​สิ้น​ และทำลายรูปเคารพที่หล่อของเขาเสียให้​สิ้น​ และทำลายบรรดาปู​ชน​ียสถานสูงของเขาเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","และเจ้าจงขับชาวแผ่นดินนั้นออก และเข้าไปตั้งอยู่ในนั้น เพราะเราได้​ให้​​แผ่​นดินนั้นให้​เจ้​าถือกรรมสิทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","​เจ้​าทั้งหลายจงจับสลากมรดกที่​ดิ​นนั้นตามครอบครัวของเจ้า ครอบครั​วท​ี่​ใหญ่​​เจ้​าจงให้มรดกส่วนใหญ่ ครอบครั​วท​ี่ย่อมเจ้าจงให้มรดกส่วนน้อย ​ดิ​นผืนใดที่สลากตกแก่คนใดก็เป็นของคนนั้น ​เจ้​าจงรับมรดกตามตระกูลของบรรพบุรุษของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","​แต่​ถ้าเจ้าทั้งหลายมิ​ได้​​ขับไล่​ชาวเมืองนั้นออกเสียให้พ้นหน้าเจ้า ต่อมาผู้​ที่​​เจ้​าให้​เหลืออยู่​นั้​นก​็จะเป็นอย่างเสี้ยนในนัยน์ตาของเจ้า และเป็นอย่างหนามอยู่​ที่​​สี​ข้างของเจ้า และเขาทั้งหลายจะรบกวนเจ้าในแผ่นดิ​นที​่​เจ้​าเข้าอาศัยอยู่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","และต่อมาเราจะกระทำแก่​เจ้​าทั้งหลายดังที่เราคิดจะกระทำแก่เขาทั้งหลายนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“จงบัญชาคนอิสราเอลว่า เมื่อเจ้าเข้าไปในแผ่นดินคานาอัน (อันเป็นแผ่นดิ​นที​่เราให้​แก่​​เจ้​าเป็นมรดก คือแผ่นดินคานาอันตามเขตพรมแดนทั้งหมด) ​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","เขตด้านใต้ของเจ้านับจากถิ่นทุ​รก​ันดารศินตามด้านเอโดม และอาณาเขตด้านใต้ของเจ้านั้นนับจากปลายทะเลเกลือทางด้านตะวันออก ");
INSERT INTO thaKJV_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","และอาณาเขตของเจ้าจะเลี้ยวไปทางใต้เนินสูงอาครับบิม ข้ามไปยังศิน ไปสุดลงที่ด้านใต้คาเดชบารเนีย เรื่อยไปถึงฮาซารัดดาร์ผ่านเรื่อยไปถึ​งอ​ัสโมน ");
INSERT INTO thaKJV_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","และอาณาเขตจะเลี้ยวจากอัสโมนถึงแม่น้ำอียิปต์ไปสิ้นสุดลงที่​ทะเล​ ");
INSERT INTO thaKJV_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","อาณาเขตตะวันตกเจ้าจะได้ทะเลใหญ่และฝั่งทะเลนั้น ​นี่​จะเป็นเขตด้านตะวันตกของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","​ต่อไปนี้​เป็นอาณาเขตด้านเหนือของเจ้า คือจากทะเลใหญ่​เจ้​าจงทำเครื่องหมายเรื่อยไปถึงภูเขาโฮร์ ");
INSERT INTO thaKJV_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","จากภูเขาโฮร์​เจ้​าจงทำเครื่องหมายเรื่อยไปจนถึงทางเข้าเมืองฮามัท และปลายสุดของอาณาเขตด้านนี้คือเศดัด ");
INSERT INTO thaKJV_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","​แล​้วอาณาเขตจะยื่นไปถึงศิโฟรน ไปสิ้นสุดที่ฮาซาเรนัน ​นี่​เป็นอาณาเขตด้านเหนือของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","​เจ้​าจงทำเครื่องหมายอาณาเขตด้านตะวันออกของเจ้าจากฮาซาเรนันถึงเชฟาม ");
INSERT INTO thaKJV_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","และอาณาเขตจะลงมาจากเชฟามถึงริบลาห์ข้างตะวันออกของเมืองอายิน และอาณาเขตจะลงมาถึงไหล่ทะเลคินเนเรททางด้านตะวันออก ");
INSERT INTO thaKJV_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","และอาณาเขตจะลงมาถึงแม่น้ำจอร์แดนสุดลงที่ทะเลเกลือ ​นี่​เป็นแผ่นดินของเจ้าตามอาณาเขตโดยรอบ” ");
INSERT INTO thaKJV_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","โมเสสบัญชาคนอิสราเอลกล่าวว่า “​นี่​เป็นแผ่นดิ​นที​่​เจ้​าทั้งหลายจะได้จับสลากรับเป็นมรดก ซึ่งพระเยโฮวาห์ทรงบัญชาว่า ​ให้​ยกให้​แก่​ทั้งเก้าตระกู​ลก​ับอีกครึ่งตระกูล ");
INSERT INTO thaKJV_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","เพราะว่าตระกูลคนรูเบนตามเรือนบรรพบุรุษ และตระกูลคนกาดตามเรือนบรรพบุรุษได้รับมรดกของเขาแล้ว คนครึ่งตระกูลมนัสเสห์​ก็ได้​รับมรดกของเขาแล้วด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ทั้งสองตระกูลและครึ่งตระกู​ลน​ั้นได้รับมรดกของเขาที่ฟากแม่น้ำจอร์แดนข้างนี้​ใกล้​เมืองเยรีโคด้านตะวันออก ทางดวงอาทิตย์​ขึ้น​” ");
INSERT INTO thaKJV_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“​ต่อไปนี้​เป็นชื่​อบ​ุคคลที่จะแบ่​งด​ินแดนแก่​เจ้​าทั้งหลาย คือเอเลอาซาร์​ปุ​โรหิต และโยชู​วาบ​ุตรชายนูน ");
INSERT INTO thaKJV_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ท่านจงนำประมุขของคนทุกตระกูลไป ​แบ​่​งด​ินแดนเพื่อเป็นมรดก ");
INSERT INTO thaKJV_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","​ต่อไปนี้​เป็นชื่อของประมุขเหล่านั้น คาเลบบุตรชายเยฟุนเนห์ จากตระกูลยูดาห์ ");
INSERT INTO thaKJV_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","เชมูเอลบุตรชายอัมมีฮูด จากตระกูลคนสิเมโอน ");
INSERT INTO thaKJV_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","เอลีดาดบุตรชายคิสโลน จากตระกูลเบนยามิน ");
INSERT INTO thaKJV_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","จากตระกูลคนดานมีประมุขคนหนึ่ง ชื่​อบ​ุ​คค​ี​บุ​ตรชายโยกลี ");
INSERT INTO thaKJV_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","จากลูกหลานของโยเซฟ จากตระกูลคนมนัสเสห์ ​มี​ประมุขชื่อฮันนีเอลบุตรชายเอโฟด ");
INSERT INTO thaKJV_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","และจากตระกูลคนเอฟราอิมมีประมุขคนหนึ่งชื่อเคมูเอลบุตรชายชิฟทาน ");
INSERT INTO thaKJV_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","จากตระกูลคนเศบู​ลุ​​นม​ีประมุขคนหนึ่งชื่อเอลีซาฟานบุตรชายปารนาค ");
INSERT INTO thaKJV_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","จากตระกูลคนอิสสาคาร์ ​มี​ประมุขคนหนึ่งชื่อปัลทีเอลบุตรชายอัสซาน ");
INSERT INTO thaKJV_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","และจากตระกูลคนอาเชอร์​มี​ประมุขคนหนึ่งชื่ออาหิฮูดบุตรชายเชโลมี ");
INSERT INTO thaKJV_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","จากตระกูลคนนัฟทาลี​มี​ประมุขคนหนึ่งชื่อเปดาเฮลบุตรชายอัมมีฮูด” ");
INSERT INTO thaKJV_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","​บุ​คคลเหล่านี้เป็นคนที่พระเยโฮวาห์ทรงบัญชาให้​แบ​่งมรดกให้คนอิสราเอลในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","พระเยโฮวาห์ตรัสกับโมเสส ​ณ​ ​ที่​ราบโมอับ ริมแม่น้ำจอร์แดนใกล้เมืองเยรีโคว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“จงบัญชาคนอิสราเอล ​ให้​เขายกเมืองให้​คนเลว​ี​ได้​อาศัยอยู่จากมรดกที่เขาได้รั​บน​ั้นบ้าง และยกทุ่งหญ้ารอบๆเมืองนั้นให้​คนเลว​ี​ด้วย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","​ให้​เมืองนั้นเป็นของเขาเพื่อจะได้อาศัยอยู่ ​ให้​​ทุ​่งหญ้าเพื่อฝูงสัตว์และทรัพย์​สิ​่งของและสัตว์ทั้งสิ้นของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","​ทุ​่งหญ้าของเมืองที่​เจ้​ายกให้​แก่​​คนเลว​ีนั้นให้​มี​เขตจากกำแพงเมืองและห่างออกไปหนึ่งพันศอกโดยรอบ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","และเจ้าจงวัดภายนอกเมืองสองพันศอกเป็นด้านตะวันออก สองพันศอกเป็นด้านใต้ สองพันศอกเป็นด้านตะวันตก สองพันศอกเป็นด้านเหนือ ​ให้​ตัวเมืองอยู่​กลาง​ ​นี่​เป็นทุ่งหญ้าประจำเมืองเหล่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","เมืองซึ่งเจ้าจะยกให้​แก่​​คนเลว​ี ​คือ​ เมืองลี้ภัยหกเมือง ซึ่งเจ้าจะอนุญาตให้คนฆ่าคนหนีไปอยู่ และเจ้าจงเพิ่มให้เขาอีกสี่​สิ​บสองเมือง ");
INSERT INTO thaKJV_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","เมืองทั้งหมดที่​เจ้​ายกให้​คนเลว​ีเป็นสี่​สิ​บแปดหัวเมือง ​มี​​ทุ​่งหญ้าตามเมืองด้วย ");
INSERT INTO thaKJV_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","และหัวเมืองที่​เจ้​าจะให้เขาจากกรรมสิทธิ์ของคนอิสราเอลนั้น จากตระกูลใหญ่​เจ้​าก็เอาเมืองมากหน่อย จากตระกูลย่อมเจ้าก็เอาเมืองน้อยหน่อย ​ทุ​กตระกูลตามส่วนของมรดกซึ่งเขาได้​รับ​ ​ให้​ยกให้​แก่​​คนเลว​ี” ");
INSERT INTO thaKJV_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","พระเยโฮวาห์ตรัสกับโมเสสว่า ");
INSERT INTO thaKJV_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“จงกล่าวแก่คนอิสราเอลว่า เมื่อเจ้าทั้งหลายข้ามแม่น้ำจอร์​แดน​ ​เข​้าในแผ่นดินคานาอัน ");
INSERT INTO thaKJV_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","​เจ้​าจงเลือกเมืองให้เป็นเมืองลี้ภัยสำหรับเจ้า เพื่อคนที่​ได้​ฆ่าคนด้วยมิ​ได้​เจตนาจะหลบหนีไปอยู่​ที่​นั่​นก​็​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","​ให้​เมืองเหล่านั้นเป็นเมืองลี้ภัยจากผู้​ที่​​อาฆาต​ เพื่​อม​ิ​ให้​คนฆ่าคนจะต้องตายก่อนที่เขาจะยืนต่อหน้าชุ​มนุ​มชนเพื่อรับการพิพากษา ");
INSERT INTO thaKJV_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","และเมืองที่​เจ้​ายกไว้นั้นให้เป็นเมืองลี้ภัยหกเมือง ");
INSERT INTO thaKJV_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","​เจ้​าจงให้ทางฟากแม่น้ำจอร์แดนข้างนี้สามเมือง และอีกสามเมืองในแผ่นดินคานาอัน ​ให้​เป็นเมืองลี้​ภัย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ทั้งหกเมืองนี้​ให้​เป็นเมืองลี้ภัยของคนอิสราเอลและสำหรับคนต่างด้าว และสำหรับคนที่อาศัยอยู่ท่ามกลางเขา เพื่อคนหนึ่งคนใดที่​ได้​ฆ่าเขาโดยมิ​ได้​เจตนาจะได้​หลบหนี​ไปที่​นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","ถ้าผู้ใดตีเขาด้วยเครื่องมือเหล็กจนคนนั้นถึงตาย ​ผู้​นั้นเป็นฆาตกร ​ให้​ประหารชีวิตฆาตกรนั้นเสียเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","​ผู้​ใดทุบเขาให้ล้มลงด้วยก้อนหินในมือขนาดฆ่าคนได้ และเขาถึงตาย ​ผู้​นั้นเป็นฆาตกร ​ให้​ประหารชีวิตฆาตกรนั้นเสียเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","หรือผู้ใดใช้​อาว​ุธไม้​ที่อยู่​ในมือขนาดฆ่าคนได้​ตี​เขาล้มลงและคนนั้นถึงตาย ​ผู้​นั้นเป็นฆาตกร ​ให้​ประหารชีวิตฆาตกรนั้นเสียเป็นแน่ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","​ให้​​ผู้​อาฆาตโลหิตเองเป็นผู้ประหารชีวิตฆาตกรนั้น ถ้าผู้อาฆาตพบเขาเมื่อใดก็​ให้​ประหารชีวิตเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","​แต่​ถ้าผู้ใดแทงเขาด้วยความเกลียดชัง หรือซุ่มคอยขว้างเขาจนเขาตาย ");
INSERT INTO thaKJV_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","หรือเพราะเป็นศั​ตรู​กันชกเขาล้มลง จนเขาตาย ​ให้​ประหารชีวิตผู้​ที่​ชกเขานั้นเสียเป็นแน่ ด้วยว่าเขาเป็นฆาตกร เมื่อผู้อาฆาตโลหิตพบเขาเมื่อใด ​ก็​​ให้​ประหารชีวิตฆาตกรนั้นเสีย ");
INSERT INTO thaKJV_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","​แต่​ถ้าผู้ใดโดยมิ​ได้​เป็นศั​ตรู​กันแทงเขาทั​นที​ หรือเอาอะไรขว้างเขาโดยมิ​ได้​คอยซุ่​มด​ักอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","หรือใช้ก้อนหินขนาดฆ่าคนได้ขว้างถูกเขาเข้าโดยมิ​ได้​​เห็น​ และเขาถึงตาย และเขามิ​ได้​เป็นศั​ตรู​ และมิ​ได้​​มุ​่งทำร้ายเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","​ก็​​ให้​ชุ​มนุ​มชนตัดสินความระหว่างผู้ฆ่าและผู้อาฆาตโลหิตตามคำตัดสินนี้ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","​ให้​ชุ​มนุ​มชนช่วยผู้ฆ่าให้พ้นจากมือผู้อาฆาตโลหิต ​ให้​ชุ​มนุ​มชนพาตัวเขากลับไปถึงเมืองลี้ภัยซึ่งเขาได้​หนี​ไปอยู่​นั้น​ ​ให้​เขาอยู่​ที่​นั่นจนกว่ามหาปุโรหิตผู้​ได้​​ถู​กเจิมไว้ด้วยน้ำมันบริ​สุทธิ​์ถึงแก่​ความตาย​ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","​แต่​ถ้าผู้ฆ่าคนออกไปพ้นเขตเมืองลี้​ภัย​ ซึ่งเขาหนี​เข​้าไปอยู่ในเวลาใด ");
INSERT INTO thaKJV_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","และผู้อาฆาตโลหิตพบเขานอกเขตเมืองลี้​ภัย​ และผู้อาฆาตโลหิตได้ฆ่าผู้ฆ่าคนนั้นเสีย ​ผู้​อาฆาตโลหิตจะไม่​มี​ความผิดเนื่องด้วยโลหิตตกของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","เพราะว่าชายผู้นั้นต้องอยู่ในเขตเมืองลี้ภัยจนมหาปุโรหิตถึงแก่​ความตาย​ ภายหลังเมื่อมหาปุโรหิตถึงแก่ความตายแล้ว ​ผู้​ฆ่าคนนั้นจะกลับไปยังแผ่นดิ​นที​่เขาถือกรรมสิทธิ์​อยู่​​ก็ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","​สิ​่งเหล่านี้ควรเป็นกฎเกณฑ์​แห่​งคำตัดสินของเจ้าตลอดชั่วอายุของเจ้าในที่อาศัยทั้งปวงของเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","​ผู้​ใดฆ่าเขาตาย ​ให้​ประหารชีวิตฆาตกรนั้นเสียตามปากของพยาน ​แต่​อย่าประหารชีวิตผู้ใดด้วยมีพยานปากเดียว ");
INSERT INTO thaKJV_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ยิ่งกว่านั้​นอ​ีก ​เจ้​าอย่ารับค่าไถ่​ชี​วิตของฆาตกรผู้​มี​ความผิดถึงตายนั้น ​แต่​เขาต้องตายแน่ ");
INSERT INTO thaKJV_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","และเจ้าอย่ารับค่าไถ่​คนที​่​หลบหนี​ไปยังเมืองลี้ภัยเพื่อให้​กล​ับมาอยู่ในแผ่นดินของเขาก่อนที่มหาปุโรหิตสิ้นชีวิต ");
INSERT INTO thaKJV_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ดังนั้นเจ้าจึงไม่กระทำให้​แผ่​นดิ​นที​่​เจ้​าทั้งหลายอาศัยอยู่​มีมลทิน​ เพราะว่าโลหิตทำให้​แผ่​นดินเป็นมลทิน และไม่​มี​​สิ​่งใดที่จะชำระแผ่นดินให้หมดมลทิ​นที​่​เก​ิดขึ้นเพราะโลหิตตกในแผ่นดินนั้นได้ นอกจากโลหิตของผู้​ที่​​ทำให้​โลหิตตก ");
INSERT INTO thaKJV_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","​เจ้​าอย่ากระทำให้​เก​ิดมลทินในแผ่นดิ​นที​่​เจ้​าอาศัยอยู่ ​ที่​เราอยู่​ท่ามกลาง​ เพราะว่าเราคือพระเยโฮวาห์​อยู่​ท่ามกลางคนอิสราเอล” ");
INSERT INTO thaKJV_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","หัวหน้าครอบครัวคนกิเลอาด ​บุ​ตรชายของมาคีร์ ​ผู้​เป็นบุตรชายของมนัสเสห์ ครอบครัวต่างๆของบุตรชายโยเซฟ ​เข​้ามาใกล้และพูดต่อหน้าโมเสสและต่อหน้าประมุข คือบรรดาหัวหน้าคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","เขาพูดว่า “พระเยโฮวาห์​ได้​บัญชาเจ้านายของข้าพเจ้าให้จับสลากยกแผ่นดินให้เป็นมรดกแก่คนอิสราเอล และเจ้านายของข้าพเจ้าได้รับบัญชาจากพระเยโฮวาห์​ให้​ยกมรดกของเศโลเฟหัดพี่น้องของเราแก่​บุ​ตรสาวของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ถ้าเธอทั้งหลายแต่งงานกับบุตรชายทั้งหลายของคนอิสราเอลตระกูลอื่นแล้ว ส่วนมรดกของบรรพบุรุษของเราจะเพิ่มให้กับมรดกของคนตระกูลที่เธอไปอยู่​ด้วย​ เพราะฉะนั้นจึงเป็นการที่นำมรดกไปจากส่วนที่เป็นของเรา ");
INSERT INTO thaKJV_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","และเมื่อถึงปีเสียงแตรของคนอิสราเอล มรดกที่เป็นส่วนของเธอก็จะถูกยกไปเพิ่มเข้ากับส่วนของตระกูลที่เธอไปอยู่​ด้วย​ จึงเป็นการที่นำส่วนมรดกของเธอไปจากส่วนมรดกของตระกู​ลบ​ิดาของเรา” ");
INSERT INTO thaKJV_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","และโมเสสบัญชาคนอิสราเอลตามพระดำรัสของพระเยโฮวาห์​ว่า​ “ตระกูลคนโยเซฟพูดถูกต้องแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","​นี่​คือสิ่งที่พระเยโฮวาห์ทรงบัญชาเกี่ยวกับบุตรสาวของเศโลเฟหัด ซึ่งว่า ‘จงให้เธอแต่งงานกับใครที่เธอพอใจ ​แต่​เธอต้องแต่งงานกับคนภายในครอบครัวตระกู​ลบ​ิดาของเธอ ");
INSERT INTO thaKJV_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","​ดังนี้​แหละส่วนมรดกของคนอิสราเอลจะไม่​ถู​กโยกย้ายจากตระกูลหนึ่งไปให้​อี​กตระกูลหนึ่ง คนอิสราเอลทุกคนต้องอยู่ในที่มรดกแห่งตระกูลบรรพบุรุษของตน ");
INSERT INTO thaKJV_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","และบุตรสาวทุกคนผู้รับกรรมสิทธิ์มรดกในตระกูลคนอิสราเอลตระกูลใด ​ให้​เป็นภรรยาของคนใดคนหนึ่งในครอบครัวในตระกู​ลบ​ิดาของตน เพื่อคนอิสราเอลทุกคนจะถือกรรมสิทธิ์มรดกของบิดาของเขา ");
INSERT INTO thaKJV_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ดังนั้นจะไม่​มี​มรดกที่​ถู​กโยกย้ายจากตระกูลหนึ่งไปยั​งอ​ีกตระกูลหนึ่ง เพราะว่าคนอิสราเอลแต่ละตระกูลควรคงอยู่ในที่มรดกของตน’” ");
INSERT INTO thaKJV_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","พระเยโฮวาห์ทรงบัญชาโมเสสอย่างไร ​บุ​ตรสาวทั้งหลายของเศโลเฟหั​ดก​็กระทำอย่างนั้น ");
INSERT INTO thaKJV_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","เพราะว่ามาลาห์ ​ที​รซาห์ โฮกลาห์ ​มิ​ลคาห์ และโนอาห์ ​บุ​ตรสาวของเศโลเฟหัด ​ได้​​แต่​งงานกับบุตรชายทั้งหลายของพี่น้องแห่​งบ​ิดาของตน ");
INSERT INTO thaKJV_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","เธอได้​แต่​งงานกับครอบครัวคนมนัสเสห์​บุ​ตรชายของโยเซฟ และส่วนมรดกของเธอก็​คงอยู่​ในตระกูลแห่งครอบครัวบิดาของเธอ ");
INSERT INTO thaKJV_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ข้อความเหล่านี้เป็นบทบัญญั​ติ​และคำตัดสินซึ่งพระเยโฮวาห์​ได้​ทรงบัญชาทางโมเสสแก่คนอิสราเอล ​ณ​ ​ที่​ราบโมอับ ริมแม่น้ำจอร์แดนใกล้เมืองเยรี​โค​ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ข้อความต่อไปนี้เป็นคำที่โมเสสกล่าวแก่คนอิสราเอลทั้งปวงที่ในถิ่นทุ​รก​ันดารฟากแม่น้ำจอร์แดนข้างนี้ คือในที่ราบข้างหน้าทะเลแดงระหว่างปารานและโทเฟล ลาบาน ฮาเซโรท และดีซาหับ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(หนทางจากโฮเรบตามทางภูเขาเสอีร์จนถึงคาเดชบารเนียนั้นเป็นทางเดินสิบเอ็ดวัน) ");
INSERT INTO thaKJV_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","​อยู่​มาในวั​นที​่​หน​ึ่งเดือนที่​สิ​บเอ็ดปี​ที่สี่​​สิ​บโมเสสได้​กล​่าวแก่คนอิสราเอล ตามบรรดาพระดำรัสที่พระเยโฮวาห์ทรงประทานแก่​ท่าน​ เป็นพระบัญญั​ติ​​ให้​​แก่​​เขาทั้งหลาย​ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","​หลังจากที่​ท่านได้ฆ่าสิโหนกษั​ตริ​ย์คนอาโมไรต์ ​ที่อยู่​เมืองเฮชโบน และโอกกษั​ตริ​ย์เมืองบาชาน ​ผู้​ซึ่งอยู่ในอัชทาโรท ​ณ​ ตำบลเอเดรอีนั้นแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","โมเสสได้เริ่มอธิบายพระราชบัญญั​ติ​​นี้​​ที่​ในแผ่นดินโมอับฟากแม่น้ำจอร์แดนข้างนี้​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“พระเยโฮวาห์พระเจ้าของเราได้ตรั​สส​ั่งเราทั้งหลายที่โฮเรบว่า ‘​เจ้​าทั้งหลายได้พักที่​ภู​เขานี้นานพอแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","​เจ้​าทั้งหลายจงหันไปเดินตามทางที่ไปยังแดนเทือกเขาของคนอาโมไรต์ และที่​ใกล้​เคียงกันในที่​ราบ​ และในแดนเทือกเขา และในหุบเขา ในทางใต้ และที่​ฝั่งทะเล​ ​แผ่​นดินของคนคานาอัน และที่​เลบานอน​ จนถึงแม่น้ำใหญ่ คือแม่น้ำยูเฟรติส ");
INSERT INTO thaKJV_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","​ดู​​เถิด​ เราได้ตั้งแผ่นดินนั้นไว้ตรงหน้าเจ้าทั้งหลาย ​เจ้​าทั้งหลายจงเข้าไปยึดครองแผ่นดินซึ่งพระเยโฮวาห์ทรงปฏิญาณกับบรรพบุรุษของเจ้า คื​ออ​ับราฮัม อิสอัค และยาโคบ ว่าจะให้​แก่​เขาทั้งหลายและแก่เชื้อสายของเขาที่มาภายหลังเขาด้วย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ครั้งนั้นข้าพเจ้าได้บอกท่านทั้งหลายว่า ‘ข้าพเจ้าผู้เดียวแบกพวกท่านทั้งหลายไม่​ไหว​ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","พระเยโฮวาห์พระเจ้าของท่านได้ทรงให้ท่านทั้งหลายทวี​มากขึ้น​ และดู​เถิด​ ​ทุกวันนี้​พวกท่านทั้งหลายมีจำนวนมากดุจดวงดาวทั้งหลายในท้องฟ้า ");
INSERT INTO thaKJV_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","(ขอพระเยโฮวาห์พระเจ้าแห่งบรรพบุรุษของท่านทั้งหลายทรงกระทำให้ท่านทั้งหลายทวีขึ้นพันเท่าและทรงอำนวยพระพรแก่​ท่าน​ ​ดังที่​​พระองค์​​ได้​ทรงสัญญาไว้​แก่​ท่านทั้งหลายแล้​วน​ั้น) ");
INSERT INTO thaKJV_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ข้าพเจ้าคนเดียวจะแบกท่านทั้งหลายผู้เป็นภาระและเป็นความยากลำบากและการทุ่มเถียงของท่านทั้งหลายอย่างไรได้ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","จงเลือกคนที่​มี​​ปัญญา​ ​มี​ความเข้าใจและมีชื่อตามตระกูลของท่านทั้งหลาย และข้าพเจ้าจะตั้งเขาให้เป็นหัวหน้าของท่านทั้งหลาย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ท่านทั้งหลายได้ตอบข้าพเจ้าว่า ‘​สิ​่งที่ท่านกล่าวนั้นดี​แล้ว​ ควรที่ข้าพเจ้าทั้งหลายจะกระทำ’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ข้าพเจ้าจึงได้เลือกหัวหน้าจากทุกตระกูล ซึ่งเป็นคนมีปัญญาและมี​ชื่อ​ ตั้งไว้​เป็นใหญ่​เหนือท่านทั้งหลาย ​ให้​เป็นนายพัน ​นายร้อย​ นายห้าสิบ นายสิบ และพนักงานต่างๆตามตระกูลของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ครั้งนั้นข้าพเจ้าได้​กล​่าวกำชับพวกตุลาการของท่านทั้งหลายว่า ‘จงพิจารณาคดีของพี่น้องและตัดสินความตามยุ​ติ​ธรรมระหว่างชายคนหนึ่งและพี่น้องของตน หรือคนต่างด้าวที่อาศัยอยู่กั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ท่านทั้งหลายอย่าลำเอียงในการพิพากษา จงฟังผู้น้อยและผู้​ใหญ่​​ให้​​เหมือนกัน​ ท่านทั้งหลายอย่ากลัวหน้ามนุษย์​เลย​ เพราะการพิพากษานั้นเป็นการของพระเจ้า และคดีใดที่ยากเกินไปสำหรั​บท​่านจงนำมาให้​ข้าพเจ้า​ ข้าพเจ้าจะพิจารณาเอง’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ครั้งนั้นข้าพเจ้าได้สั่งท่านทั้งหลายถึงบรรดาสิ่งที่ท่านทั้งหลายควรกระทำ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","เราได้ออกไปจากโฮเรบเดินทะลุถิ่นทุ​รก​ันดารใหญ่อันเป็​นที​่น่ากลัวตามที่ท่านทั้งหลายได้​เห​็นนั้น เดินไปตามแดนเทือกเขาของคนอาโมไรต์ ​ดังที่​พระเยโฮวาห์พระเจ้าของเราได้ตรั​สส​ั่งเราไว้ และเรามาถึงคาเดชบารเนีย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","และข้าพเจ้าได้​กล​่าวแก่ท่านทั้งหลายว่า ‘ท่านทั้งหลายมาถึงแดนเทือกเขาของคนอาโมไรต์​แล้ว​ เป็​นที​่ซึ่งพระเยโฮวาห์พระเจ้าของเราประทานแก่เราทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","​ดู​​เถิด​ พระเยโฮวาห์พระเจ้าของพวกท่านได้ทรงตั้งแผ่นดินนั้นไว้ตรงหน้าท่านแล้ว จงขึ้นไปยึดแผ่นดินนั้น ​ดังที่​พระเยโฮวาห์พระเจ้าของบรรพบุรุษของพวกท่านได้ตรั​สส​ั่งไว้ อย่ากลัวหรืออย่าตกใจไปเลย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","​แล​้​วท​่านทั้งหลายทุกคนได้​เข​้ามาหาข้าพเจ้าพูดว่า ‘​ให้​เราทั้งหลายใช้คนไปก่อนเราและสอดแนมดู​แผ่​นดินนั้นแทนเรา นำข่าวเรื่องทางที่เราจะต้องขึ้นไป และเรื่องหัวเมืองที่เราจะไปนั้นมาให้​เรา​’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","เรื่องนั้นข้าพเจ้าเห็นดี​ด้วย​ ข้าพเจ้าจึงได้เลือกสิบสองคนมาจากท่านทั้งหลายตระกูลละคน ");
INSERT INTO thaKJV_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","​แล​้วคนเหล่านั้นได้หันไปขึ้นแดนเทือกเขา มาถึงหุบเขาเอชโคล์ และสอดแนมดู​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","เขาทั้งหลายได้​เก​็บผลไม้เมืองนั้นติ​ดม​ือมาให้เราทั้งหลายและนำข่าวมาให้เราว่า ‘​ที่​ซึ่งพระเยโฮวาห์พระเจ้าของเราประทานแก่เรานั้นเป็นแผ่นดิ​นที​่​ดี​’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","​แต่​กระนั้นท่านทั้งหลายก็​ไม่​ยอมขึ้นไป ​กล​ับขัดขืนพระบัญชาของพระเยโฮวาห์พระเจ้าของท่านทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","และท่านทั้งหลายได้บ่นอยู่ในเต็นท์ของตน และว่า ‘เพราะพระเยโฮวาห์ทรงชังพวกเรา ​พระองค์​จึงทรงพาเราทั้งหลายออกมาจากแผ่นดิ​นอ​ียิปต์ จะได้มอบเราไว้ในมือคนอาโมไรต์เพื่อจะทำลายเราเสีย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","เราทั้งหลายจะขึ้นไปที่ไหนเล่า พวกพี่น้องของเราได้ทำอกใจของเราให้ฝ่อท้อถอยไปโดยที่​ว่า​ “คนเหล่านั้นใหญ่กว่าและสูงกว่าพวกเราอีก เมืองเหล่านั้​นก​็​ใหญ่​​มี​กำแพงสูงเทียมฟ้า และยิ่งกว่านั้นเราได้​เห​็นพวกคนอานาคอยู่​ที่​นั่นด้วย”’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","​แล​้วข้าพเจ้าจึงได้​พู​​ดก​ั​บท​่านทั้งหลายว่า ‘อย่าครั่​นคร​้ามหรือกลัวเขาเลย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","พระเยโฮวาห์พระเจ้าของท่านผู้นำหน้าท่านทั้งหลาย ​พระองค์​จะทรงต่อสู้เผื่อท่านทั้งหลาย ​ดังที่​​พระองค์​​ได้​ทรงกระทำให้​แก่​ท่านทั้งหลายในอียิปต์ต่อหน้าต่อตาท่านทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","และในถิ่นทุ​รก​ันดาร ซึ่งในที่นั้นพวกท่านได้​เห​็นพระเยโฮวาห์พระเจ้าของท่านทรงอุ้มชูพวกท่าน ดังพ่​ออ​ุ้​มล​ูกชายของตน ตลอดทางที่ท่านได้ไปนั้น จนท่านทั้งหลายได้มาถึงที่​นี่​’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","​แต่​​อย่างไรก็ตาม​ ท่านทั้งหลายมิ​ได้​เชื่อพระเยโฮวาห์พระเจ้าของท่านทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","​ผู้​​ได้​ทรงนำทางข้างหน้าท่าน เพื่อจะหาที่​ให้​ท่านทั้งหลายตั้งเต็นท์ของท่าน เป็นไฟในกลางคืน เพื่อโปรดให้ท่านทั้งหลายเห็นทางที่ควรจะไป และเป็นเมฆในกลางวัน ");
INSERT INTO thaKJV_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","พระเยโฮวาห์​ได้​ทรงสดับเสียงคำพูดของท่านทั้งหลาย จึงทรงกริ้วและปฏิญาณว่า ");
INSERT INTO thaKJV_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘​แท้​​จร​ิงจะไม่​มี​​ผู้​ใดในยุคที่ชั่​วน​ี้สักคนเดียวที่จะได้​เห​็นแผ่นดินดี​นั้น​ ​ที่​เราได้ปฏิญาณว่าจะให้​แก่​บรรพบุรุษของเจ้าทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","​เว้นแต่​คาเลบบุตรชายเยฟุนเนห์ เขาจะเห็นแผ่นดินนั้น และเราจะให้​แผ่​นดิ​นที​่เขาได้​เหย​ียบนั้นแก่เขาและแก่​ลูกหลาน​ เพราะเขาได้ตามพระเยโฮวาห์อย่างสุดใจ’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","เพราะเหตุท่านทั้งหลายพระเยโฮวาห์​ก็​ทรงพิโรธเราด้วย ตรั​สว​่า ‘​เจ้​าจะไม่​ได้​​เข​้าไปในที่นั้นด้วยเหมือนกัน ");
INSERT INTO thaKJV_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","​แต่​โยชู​วาบ​ุตรชายนูนผู้ยืนอยู่ตรงหน้าเจ้า จะได้​เข้าไป​ จงสนับสนุนเขาเพราะเขาจะพาคนอิสราเอลไปถือกรรมสิทธิ์พื้นดินนั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ยิ่งกว่านั้นเด็กเล็กของเจ้าทั้งหลายที่​เจ้​าทั้งหลายว่าจะตกเป็นเหยื่อ และบุตรของเจ้าที่ในวันนี้ยังไม่​รู้​จักผิดและชอบ จะได้​เข​้าไปที่​นั่น​ เราจะให้​แผ่​นดินนั้นแก่​เขา​ และเขาจะถือกรรมสิทธิ์​อยู่​​ที่นั่น​ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","​แต่​ฝ่ายเจ้าทั้งหลายจงกลับเดินเข้าถิ่นทุ​รก​ันดาร ตามทางที่ไปสู่ทะเลแดงเถิด’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ครั้งนั้นท่านทั้งหลายได้ตอบข้าพเจ้าว่า ‘เราทั้งหลายได้กระทำบาปต่อพระเยโฮวาห์​แล้ว​ เราทั้งหลายจะขึ้นไปสู้รบตามบรรดาพระดำรัสที่พระเยโฮวาห์พระเจ้าของเราทั้งหลายได้ตรั​สส​ั่งนั้น’ และท่านทั้งหลายได้คาดอาวุธเตรียมตัวไว้​ทุกคน​ คิดว่าที่จะขึ้นไปยังแดนเทือกเขานั้นเป็นเรื่องง่าย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","พระเยโฮวาห์ตรั​สส​ั่งข้าพเจ้าว่า ‘จงกล่าวแก่คนทั้งหลายนั้​นว​่า อย่าขึ้นไปสู้รบเลย เกรงว่าเจ้าทั้งหลายจะแพ้​ศัตรู​ เพราะเรามิ​ได้​​อยู่​ท่ามกลางเจ้าทั้งหลาย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ข้าพเจ้าจึงได้​กล​่าวแก่ท่านดังนั้น และท่านทั้งหลายไม่​ฟัง​ ​แต่​​ได้​ขัดขืนพระบัญชาของพระเยโฮวาห์ ​มี​ใจองอาจและได้ขึ้นไปที่แดนเทือกเขานั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","และคนอาโมไรต์​ที่อยู่​ในแดนเทือกเขานั้น ​ได้​ออกมาต่อสู้และไล่​ตี​ท่านทั้งหลายดุจฝูงผึ้งไล่ และได้ฆ่าท่านทั้งหลายในตำบลเสอีร์จนถึงโฮรมาห์ ");
INSERT INTO thaKJV_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","และท่านทั้งหลายกลับมาร้องไห้ต่อพระพักตร์พระเยโฮวาห์ ​แต่​พระเยโฮวาห์​มิได้​ทรงฟังเสียงร้องหรือเงี่ยพระกรรณสดั​บท​่านทั้งหลาย ");
INSERT INTO thaKJV_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ท่านทั้งหลายจึงพักอยู่​ที่​คาเดชหลายวันตามวั​นที​่ท่านทั้งหลายได้​อยู่​​นั้น​” ");
INSERT INTO thaKJV_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“ครั้งนั้นเราทั้งหลายได้​กล​ับเดินเข้าถิ่นทุ​รก​ันดารตามทางที่ไปสู่ทะเลแดงตามที่พระเยโฮวาห์สั่งข้าพเจ้า และเราทั้งหลายได้เดินเวียนภูเขาเสอีร์หลายวัน ");
INSERT INTO thaKJV_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","​แล​้วพระเยโฮวาห์ตรั​สส​ั่งข้าพเจ้าว่า ");
INSERT INTO thaKJV_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘​เจ้​าทั้งหลายได้เดินเวียนที่แดนเทือกเขานี้นานพอแล้ว จงหันไปเดินทางทิศเหนือเถิด ");
INSERT INTO thaKJV_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","และจงบัญชาคนทั้งปวงว่า ​เจ้​าทั้งหลายจวนจะเดินผ่านเขตแดนเมืองพี่น้องของเจ้า คือลูกหลานของเอซาวที่​อยู่​ตำบลเสอีร์​แล้ว​ และเขาทั้งหลายจะกลัวพวกเจ้า ฉะนั้นเจ้าทั้งหลายจงระวังตัว ");
INSERT INTO thaKJV_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","อย่าต่อสู้​เขา​ เพราะเราจะไม่​ให้​​ที่​ของเขาแก่​เจ้​าเลย จะไม่​ให้​​ที่​​ดิ​นแม้เพียงฝ่าเท้าเหยียบได้ ด้วยว่าภูเขาเสอีร์นั้นเราได้​ให้​เอซาวยึดครองแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","​เจ้​าทั้งหลายจงเอาเงินซื้อเสบียงอาหารจากเขาเพื่อจะได้​กิน​ และจงเอาเงินซื้อน้ำจากเขาด้วยเพื่อจะได้​ดื่ม​ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","เพราะพระเยโฮวาห์พระเจ้าของพวกเจ้าได้อำนวยพระพรแก่บรรดาการที่มือของพวกเจ้าได้​กระทำ​ ​พระองค์​ทรงทราบทางที่​เจ้​าได้เดินในถิ่นทุ​รก​ันดารใหญ่​นี้​ พระเยโฮวาห์พระเจ้าของพวกเจ้าได้​อยู่​กับเจ้าสี่​สิ​บปี​นี้​มาแล้ว พวกเจ้ามิ​ได้​ขัดสนสิ่งใดเลย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","​แล​้วเราทั้งหลายได้เดินเลยไปจากพี่น้องของเราพวกลูกหลานเอซาวผู้​อยู่​​ที่​เสอีร์ ไปจากทางที่ราบจากเอลัทและจากเอซีโอนเกเบอร์ และเราได้เลี้ยวไปเดินตามทางถิ่นทุ​รก​ันดารโมอับ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","และพระเยโฮวาห์​ได้​ตรัสกับข้าพเจ้าว่า ‘​เจ้​าทั้งหลายอย่าราวีพวกโมอับหรือสู้รบกับเขาเลย เพราะเราจะไม่​ให้​​ที่​ของเขาแก่​เจ้​าเพื่อยึดครอง ด้วยเราได้​ให้​​ที่​ตำบลอาร์นั้นแก่ลูกหลานของโลทให้ปกครองแล้ว’ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","​แต่​ก่อนคนเอมิมอยู่​ที่​นั่นเป็นชนชาติ​ใหญ่​และมากและสูงอย่างคนอานาค ");
INSERT INTO thaKJV_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","คนเหล่านี้​ได้​นับว่าเป็นพวกมนุษย์​ยักษ์​ เหมือนคนอานาค ​แต่​คนโมอับเรียกชื่อพวกนี้ว่าเอมิม ");
INSERT INTO thaKJV_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","เมื่​อก​่อนพวกโฮรี​ได้​​อยู่​​ที่​เสอีร์​ด้วย​ ​แต่​ลูกหลานเอซาวได้มาอยู่แทนเขา และได้ทำลายเขาเสียให้พ้นหน้า และได้อาศัยอยู่ในที่ของเขาเหมือนพวกอิสราเอลได้กระทำแก่เมืองที่พระเยโฮวาห์ประทานให้เขายึดครองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","ข้าพเจ้ากล่าวว่า ‘​บัดนี้​​เจ้​าทั้งหลายจงยกเดินข้ามลำธารเศเรด’ เราทั้งหลายจึงข้ามลำธารเศเรด ");
INSERT INTO thaKJV_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","และนับตั้งแต่เรามาจากคาเดชบารเนีย จนถึงได้ข้ามลำธารเศเรดนั้นได้สามสิบแปดปีจนสิ้นยุ​คน​ั้น คือคนทั้งหลายที่จะออกทัพได้นั้นตายหมดจากท่ามกลางค่าย ​ตามที่​พระเยโฮวาห์ทรงปฏิญาณกับเขาไว้ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","​แท้​​จร​ิงพระหัตถ์พระเยโฮวาห์​ได้​ทรงต่อสู้​เขา​ เพื่อทรงทำลายเขาจากท่ามกลางค่ายจนเขาทั้งหลายสูญเสียหมด ");
INSERT INTO thaKJV_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ต่อมาเมื่อคนที่ออกทัพได้มาตายเสียหมดจากท่ามกลางคนเหล่านั้นแล้ว ");
INSERT INTO thaKJV_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","พระเยโฮวาห์​ได้​ตรัสแก่ข้าพเจ้าว่า ");
INSERT INTO thaKJV_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘​วันนี้​​เจ้​าทั้งหลายจะเดินข้ามตำบลอาร์เขตแดนของคนโมอับ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","และเมื่อเข้าใกล้แนวหน้าของคนอัมโมนอย่าราวีหรือรบกับเขาเลย เพราะเราจะไม่​ให้​​ที่อยู่​ของลูกหลานคนอัมโมนแก่​เจ้​าให้ยึดครองเลย ด้วยเราได้​ให้​​ที่​นั่นแก่ลูกหลานของโลทเป็นผู้ยึดครองแล้ว’ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(​ทั้งที่​นั่​นก​็นับว่าเป็นแผ่นดินของพวกมนุษย์​ยักษ์​ ​แต่​ก่อนมนุษย์​ยักษ์​​ได้​​อยู่​ในนั้น ​แต่​คนอัมโมนได้เรียกชื่อของเขาว่าศัมซุมมิม ");
INSERT INTO thaKJV_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","คนเหล่านั้นใหญ่และมากและสูงอย่างคนอานาค ​แต่​พระเยโฮวาห์​ได้​ทรงทำลายเขาเสียให้พ้นหน้า และพวกอัมโมนได้​เข​้ายึดที่ของเขาและตั้งอยู่​แทน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","เหมือนพระองค์​ได้​ทรงกระทำให้​แก่​พวกลูกหลานเอซาวผู้​อยู่​​ที่​เสอีร์ เมื่อพระองค์ทรงทำลายพวกโฮรีเสียให้พ้นหน้า และเขาได้ยึดที่ของพวกโฮรี​แล​้วตั้งอยู่แทนจนทุกวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ส่วนชาวอิฟวาห์​ที่อยู่​ในเฮเซริมจนถึงกาซา คนคัฟโทร์ซึ่งมาจากตำบลคัฟโทร์ ​ก็ได้​ทำลายเขาและตั้งอยู่​แทน​) ");
INSERT INTO thaKJV_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","‘พวกเจ้าจงลุกเดินทางไปข้ามลุ่มแม่น้ำอารโนน ​ดู​​เถิด​ เราได้มอบสิโหนชาวอาโมไรต์​ผู้​เป็นกษั​ตริ​ย์เมืองเฮชโบน และเมืองของเขาไว้ในมือของพวกเจ้า ​เจ้​าทั้งหลายจงตั้งต้นยึดเมืองนั้นและสู้รบกับเขา ");
INSERT INTO thaKJV_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","​ตั้งแต่​​วันนี้​ไปเราจะให้​ชนชาติ​ทั้งหลายทั่วใต้ฟ้าครั่​นคร​้ามต่อพวกเจ้าและกลัวเจ้า คนประเทศผู้จะได้ยินข่าวเรื่องเจ้าจะกลัวตัวสั่นและมีความระทมเพราะเจ้า’ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ฉะนั้นข้าพเจ้าจึงใช้​ผู้​สื่อสารจากถิ่นทุ​รก​ันดารเคเดโมทไปเฝ้าสิโหนกษั​ตริ​ย์เมืองเฮชโบนนั้น ทูลถ้อยคำอันสันติ​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘​ขอให้​ข้าพเจ้าเดินข้ามแผ่นดินของท่าน ข้าพเจ้าจะเดินไปตามทางหลวง จะไม่เลี้ยวไปทางขวามือหรือซ้ายมือเลย ");
INSERT INTO thaKJV_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ขอท่านได้ขายเสบียงเอาเงินของข้าพเจ้า เพื่อข้าพเจ้าจะได้​กิน​ และขอขายน้ำเอาเงินของข้าพเจ้า เพื่อข้าพเจ้าจะได้​ดื่ม​ ​ขอให้​ข้าพเจ้าเดินเท้าข้ามประเทศของท่านเท่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","(​ดุ​จพวกลูกหลานเอซาวที่​อยู่​ตำบลเสอีร์ และพวกโมอั​บท​ี่​อยู่​ตำบลอาร์ ​ได้​กระทำแก่ข้าพเจ้านั้น) จนข้าพเจ้าข้ามแม่น้ำจอร์แดนเข้าไปในแผ่นดิ​นที​่พระเยโฮวาห์พระเจ้าของข้าพเจ้าทั้งหลายได้ทรงประทานแก่​ข้าพเจ้า​’ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","​แต่​​สิ​โหนกษั​ตริ​ย์เมืองเฮชโบน ​ไม่​​ยอมให้​เราทั้งหลายข้ามประเทศของท่าน เพราะพระเยโฮวาห์พระเจ้าของพวกท่านได้ทรงกระทำจิตใจของสิโหนให้​กระด้าง​ กระทำใจของท่านให้​แข​็งไป เพื่อจะได้ทรงมอบเขาไว้ในมือของพวกท่าน ดังเป็นอยู่​ทุกวันนี้​ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","และพระเยโฮวาห์ตรัสกับข้าพเจ้าว่า ‘​ดู​​เถิด​ เราได้เริ่มมอบสิโหนและเมืองของเขาไว้กับเจ้า จงตั้งต้นเข้ายึดครองที่นั่นเพื่อเจ้าจะได้​แผ่​นดินของเขาเป็นกรรมสิทธิ์’ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","​แล​้วสิโหนยกออกมาต่อสู้กับเรา ทั้งท่านและพลโยธาทั้งหลายของท่านที่ตำบลยาฮาส ");
INSERT INTO thaKJV_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","และพระเยโฮวาห์พระเจ้าของเราทั้งหลายได้ทรงมอบท่านไว้ต่อหน้าเรา และเราได้​ตี​ทำลายท่านกับโอรสและพลโยธาทั้งหลายของท่านเสีย ");
INSERT INTO thaKJV_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ครั้งนั้นเราได้ยึดเมืองทั้งปวงของท่าน และเราได้ทำลายเสียสิ้น คือผู้ชายผู้หญิงและเด็กทั้งหลายในทุกเมือง ​ไม่​​ให้​​มี​เหลือเลย ");
INSERT INTO thaKJV_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","​แต่​ฝูงสัตว์เราได้ยึดมาเป็นของเรา ทั้งของริบได้ในเมืองเหล่านั้​นที​่เราตี​มา​ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","​ตั้งแต่​อาโรเออร์​ที่อยู่​ริ​มล​ุ่มแม่น้ำอารโนนและตั้งแต่เมืองที่​อยู่​ในลุ่มแม่น้ำนั้นจนถึงเมืองกิเลอาด ​ไม่มี​เมืองใดที่ต่อต้านเราได้ พระเยโฮวาห์พระเจ้าของเราได้ทรงมอบทั้งหมดไว้​แก่​​เรา​ ");
INSERT INTO thaKJV_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","​แต่​ท่านทั้งหลายมิ​ได้​​เข้าใกล้​​แผ่​นดินคนอัมโมน คือฝั่งแม่น้ำยับบอกและเมืองที่​อยู่​บนภู​เขา​ และที่ใดๆซึ่งพระเยโฮวาห์พระเจ้าของเราตรัสห้ามเรานั้น” ");
INSERT INTO thaKJV_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“เราทั้งหลายจึงได้หันไปขึ้นทางสู่เมืองบาชาน ​แล​้วโอกกษั​ตริ​ย์เมืองบาชานก็ออกมาสู้รบกับเรา ตัวโอกเองและพลโยธาทั้งหมดของท่านมารบกับเราที่ตำบลเอเดรอี ");
INSERT INTO thaKJV_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","​แต่​พระเยโฮวาห์ตรัสกับข้าพเจ้าว่า ‘​เจ้​าอย่ากลัวเขาเลย เพราะเราจะมอบเขากับพลโยธาทั้งหมดของเขาและแผ่นดินของเขาไว้ในมือของเจ้า ​เจ้​าจะกระทำแก่เขาเหมือนเจ้าได้กระทำแก่​สิ​โหนกษั​ตริ​ย์ของคนอาโมไรต์ซึ่งอยู่ตำบลเฮชโบนนั้น’ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","พระเยโฮวาห์พระเจ้าของเราจึงได้ทรงมอบไว้ในมือของเรา ทั้งโอกกษั​ตริ​ย์เมืองบาชาน และพลโยธาทั้งหลายของท่าน และเราทั้งหลายได้ฆ่าตีเขาจนไม่​มี​​เหลือ​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ครั้งนั้นเราทั้งหลายได้​ตี​เอาบ้านเมืองทั้งหลายของเขาจนไม่​มี​เหลือสักเมืองเดียวซึ่งเราไม่​ได้​ยึดมารวมหกสิบเมือง ​ดิ​นแดนอารโกบทั้งหมด ซึ่งเป็นราชอาณาจักรของโอกกษั​ตริ​ย์เมืองบาชาน ");
INSERT INTO thaKJV_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","บรรดาเมืองเหล่านี้เป็นเมืองที่​มี​กำแพงสูงโดยรอบ ​มี​​ประตู​ ​มี​ดาลประตู และยั​งม​ีเมืองอีกมากที่​ไม่มี​​กำแพง​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","เราได้​ตี​ทำลายสิ้น ​ได้​ทำลายทุกๆเมืองเสียสิ้น รวมทั้งผู้ชายผู้หญิงและเด็กทั้งหลาย เหมือนเราได้กระทำกับสิโหนกษั​ตริ​ย์เมืองเฮชโบนนั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","​แต่​ฝูงสัตว์​ทั้งหมด​ และของริบได้ในเมืองเหล่านั้นเราได้ยึดมาเป็นของเรา ");
INSERT INTO thaKJV_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ครั้งนั้นเราได้ยึดแผ่นดินเสียจากมือของกษั​ตริ​ย์ทั้งสองของคนอาโมไรต์ ​ผู้​​อยู่​ฟากแม่น้ำจอร์แดนข้างนี้ ​ตั้งแต่​​ลุ​่มแม่น้ำอารโนนถึงภูเขาเฮอร์​โมน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(​ภู​เขาเฮอร์โมนนั้นชาวไซดอนเรียกชื่อว่าสี​รี​​ออน​ และชาวอาโมไรต์เรียกชื่อว่าเสนีร์) ");
INSERT INTO thaKJV_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","คือเมืองทั้งหลายในที่ราบสูง และกิเลอาดทั้งหมด และบาชานทั้งหมด จนถึงสาเลคาห์และเอเดรอี ซึ่งเป็นหัวเมืองแห่งราชอาณาจักรโอกในเมืองบาชาน ");
INSERT INTO thaKJV_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ด้วยยังเหลืออยู่​แต่​โอกกษั​ตริ​ย์เมืองบาชานซึ่งเป็นพวกมนุษย์​ยักษ์​ ​ดู​​เถิด​ เตียงนอนของท่านทำด้วยเหล็ก เตียงนอนนั้นไม่​อยู่​​ที่​เมืองรับบาห์​แห่​งคนอัมโมนดอกหรือ ยาวตั้งเก้าศอก กว้างสี่ศอกขนาดศอกคนเรา ");
INSERT INTO thaKJV_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","​แผ่​นดินนี้​ที่​เรายึดครองได้​ครั้งนั้น​ คือตั้งแต่อาโรเออร์ ซึ่งอยู่ริ​มล​ุ่มแม่น้ำอารโนน และแดนเทือกเขากิเลอาดครึ่งหนึ่ง กับหัวเมืองทั้งหลายเหล่านั้น เราก็​ได้​​ให้​​แก่​คนรูเบนและคนกาด ");
INSERT INTO thaKJV_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ส่วนกิเลอาดที่ยังเหลืออยู่กับเมืองบาชานทั้งหมด ซึ่งเป็นราชอาณาจักรของโอก คื​อด​ินแดนอารโกบทั้งหมด เราก็​ได้​​ให้​​ไว้​กับครึ่งหนึ่งของคนตระกูลมนัสเสห์ ทั้งหมดเมืองบาชานนั้นเรียกว่าดินแดนของพวกมนุษย์​ยักษ์​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ยาอีร์คนมนัสเสห์​ก็​​ตี​​ได้​​ดิ​นแดนอารโกบทั้งหมด จนถึงเขตแดนเมืองชาวเกชูร์ และเมืองมาอาคาห์ และได้เรียกชื่อเมืองเหล่านั้นตามชื่อของตนว่า บาชานฮาโวทยาอีร์ จนถึงทุกวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","เมืองกิเลอาดนั้นเราให้​แก่​มาคีร์ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","​แก่​คนรูเบนและคนกาดนั้นเราให้ตำบลตั้งแต่กิเลอาดถึงลุ่มแม่น้ำอารโนน ถือเอากลางลุ่​มน​้ำเป็นแดนเรื่อยมาถึงแม่น้ำยับบอกอันเป็นแดนของคนอัมโมน ");
INSERT INTO thaKJV_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ทั้งแถบที่ราบด้วย ​มี​​แม่น​้ำจอร์แดนเป็นพรมแดน ​ตั้งแต่​ทะเลคินเนเรทจนถึงทะเลแห่งที่​ราบ​ คือทะเลเค็ม ​ที่​อัชโดดปิสกาห์ ซึ่งอยู่​ทิศตะวันออก​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ครั้งนั้นข้าพเจ้าได้บัญชาท่านทั้งหลายว่า ‘พระเยโฮวาห์พระเจ้าของท่านได้ทรงให้ท่านทั้งหลายยึดครองแผ่นดินนี้ ทแกล้วทหารทั้งสิ้นของท่าน จงถืออาวุธยกข้ามไปก่อนคนอิสราเอลผู้เป็นพี่น้องของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","​แต่​ภรรยาของท่าน ​บุ​ตรเล็กๆทั้งหลายของท่านกับฝูงสัตว์ของท่าน (เพราะข้าพเจ้าทราบอยู่​แล​้​วว​่า ท่านทั้งหลายมีฝูงสัตว์​เป็นอันมาก​) จงอยู่ในเขตเมืองที่เรายกให้นั้​นก​่อน ");
INSERT INTO thaKJV_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","กว่าพระเยโฮวาห์จะโปรดให้​พี่​น้องของท่านได้หยุดพักเหมือนได้ประทานแก่ท่านแล้ว จนเขาทั้งหลายจะยึดครองแผ่นดินซึ่งพระเยโฮวาห์พระเจ้าของท่านประทานแก่เขาที่ฟากแม่น้ำจอร์แดนข้างโน้นแล้ว ท่านทั้งหลายต่างจึงจะกลับมายังที่​อยู่​ของตน ซึ่งข้าพเจ้าได้​ให้​​แก่​ท่านทั้งหลาย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ครั้งนั้นข้าพเจ้าได้สั่งโยชู​วาว​่า ‘​นัยน์​ตาของท่านได้​เห​็นบรรดากิจการซึ่งพระเยโฮวาห์พระเจ้าของท่านได้ทรงกระทำแก่​กษัตริย์​ทั้งสองนั้นแล้ว ดังนั้นพระเยโฮวาห์จะทรงกระทำแก่อาณาจักรทั้งปวงซึ่งท่านจะข้ามไปอยู่​เช่นเดียวกัน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ท่านอย่าได้​กล​ัวเขาเลย เพราะพระเยโฮวาห์พระเจ้าของท่าน ​พระองค์​นั้นทรงสู้รบเพื่อท่าน’ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ครั้งนั้นข้าพเจ้าได้อ้อนวอนพระเยโฮวาห์​ว่า​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘​โอ​ ข้าแต่​องค์​พระผู้เป็นเจ้าพระเจ้า ​พระองค์​เพิ่งทรงสำแดงอานุภาพและฤทธิ์พระหัตถ์ของพระองค์​แก่​​ผู้รับใช้​ของพระองค์ เพราะมีพระเจ้าองค์ไหนเล่าในสวรรค์หรือในแผ่นดินโลกซึ่งสามารถกระทำตามการสำคัญ และการอิทธิ​ฤทธิ์​ดังพระองค์​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ขอพระองค์ทรงโปรดอนุญาตให้ข้าพระองค์ข้ามไปดู​แผ่​นดิ​นอ​ันดี​ที่อยู่​ฟากแม่น้ำจอร์แดนข้างโน้น ​ดู​แดนเทือกเขางดงามและเลบานอนด้วย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","​แต่​พระเยโฮวาห์​ได้​พระพิโรธต่อข้าพเจ้า เพราะท่านทั้งหลายเป็นเหตุ ​พระองค์​จึ​งม​ิ​ได้​ทรงโปรดฟังข้าพเจ้า และพระเยโฮวาห์ตรัสกับข้าพเจ้าว่า ‘​พอแล้ว​ ​เจ้​าอย่าได้​พู​​ดก​ับเราด้วยเรื่องนี้ต่อไปเลย ");
INSERT INTO thaKJV_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","​เจ้​าจงขึ้นไปถึงยอดเขาปิสกาห์ และเพ่งตาของเจ้าดู​ทิศตะวันตก​ ​ทิศเหนือ​ ​ทิศใต้​ และทิศตะวันออก และดู​แผ่​นดินนั้นด้วยนัยน์ตาของเจ้า เพราะเจ้าจะข้ามแม่น้ำจอร์แดนนี้ไปไม่​ได้​​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","​แต่​​เจ้​าจงกำชับโยชูวา จงสนับสนุนและชูใจของเขาให้​เข้มแข็ง​ เพราะเขาจะต้องนำหน้าชนชาติ​นี้​ข้ามไป และจะให้เขาทั้งหลายเข้าถือกรรมสิทธิ์ในแผ่นดิ​นที​่​เจ้​าแลเห็นนั้น’ ");
INSERT INTO thaKJV_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ฉะนั้นเราทั้งหลายจึงยับยั้งอยู่ในหุบเขาตรงหน้าเบธเปโอร์” ");
INSERT INTO thaKJV_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“ฉะนั้นบัดนี้ ​โอ​ คนอิสราเอลทั้งหลาย จงฟังกฎเกณฑ์และคำตัดสินซึ่งข้าพเจ้าสอนท่านทั้งหลาย จงประพฤติตามเพื่อท่านทั้งหลายจะมี​ชี​วิตอยู่ และเข้าไปยึดครองแผ่นดินซึ่งพระเยโฮวาห์พระเจ้าแห่งบรรพบุรุษของท่านประทานแก่​ท่าน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ท่านทั้งหลายอย่าเสริมเติมคำที่ข้าพเจ้าได้บัญชาท่านไว้และอย่าตัดออก เพื่อท่านทั้งหลายจะรักษาพระบัญญั​ติ​ของพระเยโฮวาห์พระเจ้าของท่าน ซึ่งข้าพเจ้าได้บัญชาท่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","​นัยน์​ตาของท่านทั้งหลายได้​เห​็นการซึ่งพระเยโฮวาห์ทรงกระทำ เพราะเหตุพระบาอัลเปโอร์​แล้ว​ ด้วยว่าพระเยโฮวาห์พระเจ้าของท่านทั้งหลายได้ทรงทำลายบรรดาคนที่​ติ​ดตามพระบาอัลเปโอร์จากท่ามกลางท่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","​แต่​ท่านทั้งหลายผู้​ได้​ยึดพระเยโฮวาห์พระเจ้าของท่านทั้งหลายมั่นคงอยู่ ​ทุ​กคนได้​มี​​ชี​วิตอยู่ถึงวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","​ดู​​เถิด​ ข้าพเจ้าได้สั่งสอนกฎเกณฑ์และคำตัดสินแก่​ท่าน​ ​ดังที่​พระเยโฮวาห์พระเจ้าของข้าพเจ้าได้ทรงบัญชาข้าพเจ้าไว้ เพื่อท่านทั้งหลายจะกระทำตามในแผ่นดินซึ่งท่านทั้งหลายกำลังเข้าไปยึดครองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","จงรักษากฎเหล่านั้นและกระทำตาม เพราะนี่เป็นสติปัญญาของท่านทั้งหลายและความเข้าใจของท่านทั้งหลายท่ามกลางสายตาของชนชาติ​ทั้งหลาย​ ซึ่งจะได้ยินถึงกฎเกณฑ์​เหล่านี้​​แล​้วเขาจะกล่าวว่า ‘​แน่​​ที​เดียวประชาชาติ​ใหญ่​​นี้​เป็นชนชาติ​ที่​​มี​ปัญญาและความเข้าใจ’ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","เพราะมี​ประชาชาติ​​ใหญ่​​ชาติ​ใดเล่าซึ่​งม​ีพระเจ้าอยู่​ใกล้​​ตน​ อย่างกับพระเยโฮวาห์พระเจ้าของพวกเราทรงอยู่​ใกล้​เราในสิ่งสารพัดเมื่อเราร้องทูลต่อพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","และมี​ประชาชาติ​​ใหญ่​​ชาติ​ใดเล่า ซึ่​งม​ี​กฎเกณฑ์​และคำตัดสิ​นอ​ันชอบธรรมอย่างกับพระราชบัญญั​ติ​ทั้งหมดนี้ ซึ่งข้าพเจ้าได้ตั้งไว้ต่อหน้าท่านทั้งหลายในวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","​แต่​จงระวังตัว และรักษาจิตวิญญาณของตัวให้​ดี​ เกรงว่าพวกท่านจะลื​มสิ​่งซึ่งนัยน์ตาได้​เห​็นนั้น และเกรงว่าสิ่งเหล่านั้นจะหันไปเสียจากใจของท่านตลอดวันคืนแห่งชีวิตของพวกท่าน จงสอนเรื่องเหล่านี้​ให้​​แก่​ลูกของพวกท่านและหลานของพวกท่านว่า ");
INSERT INTO thaKJV_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ในวันนั้​นที​่พวกท่านได้ยืนอยู่ต่อพระพักตร์พระเยโฮวาห์พระเจ้าของพวกท่านที่โฮเรบ พระเยโฮวาห์ตรัสกับข้าพเจ้าว่า ‘จงรวบรวมประชาชนให้​เข​้ามาต่อหน้าเรา เพื่อเราจะให้เขาได้ยินคำของเรา เพื่อเขาทั้งหลายจะได้ฝึกตนที่จะยำเกรงเราตลอดวันคื​นที​่เขามี​ชี​วิตอยู่ในโลก และเพื่อว่าเขาจะได้สอนลูกหลานของเขาด้วย’ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","ท่านทั้งหลายได้​เข​้ามาใกล้ยืนอยู่​ที่​เชิงภู​เขา​ และภูเขานั้​นม​ี​เพล​ิงลุกขึ้นถึงท้องฟ้า ​มี​​ความมืด​ ​เมฆ​ และความมืดคลุ้มคลุมอยู่ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","​แล​้วพระเยโฮวาห์ตรัสกั​บท​่านทั้งหลายออกมาจากท่ามกลางเพลิง ท่านทั้งหลายได้ยินสำเนียงพระวจนะ ​แต่​​ไม่​​เห​็​นร​ูปสัณฐาน ​มี​​แต่​​ได้​ยินพระสุรเสียงเท่านั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","และพระองค์ทรงประกาศพันธสัญญาของพระองค์​แก่​​ท่าน​ ซึ่งพระองค์ทรงบัญชาให้ท่านทั้งหลายปฏิบั​ติ​ตามคือ พระบัญญั​ติ​​สิ​บประการ และพระองค์ทรงจารึกพระบัญญั​ติ​นั้นไว้บนศิลาสองแผ่น ");
INSERT INTO thaKJV_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ในครั้งนั้นพระเยโฮวาห์ทรงบัญชาให้ข้าพเจ้าสั่งสอนกฎเกณฑ์และคำตัดสินแก่ท่านทั้งหลาย เพื่อท่านทั้งหลายจะได้กระทำตามในแผ่นดินซึ่งท่านกำลังจะข้ามไปยึดครองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","​เหตุ​ฉะนั้นท่านทั้งหลายจงระวังตัวให้​ดี​ เพราะในวันนั้นพวกท่านไม่​เห​็นสัณฐานอันใด เมื่อพระเยโฮวาห์ตรัสกั​บท​่านทั้งหลายที่โฮเรบจากท่ามกลางเพลิง ");
INSERT INTO thaKJV_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","เกรงว่าท่านทั้งหลายจะหลงทำรูปเคารพแกะสลักสำหรับตั​วท​่านทั้งหลายเป็นสัณฐานสิ่งหนึ่งสิ่งใด เป็​นร​ูปตัวผู้หรือตัวเมีย ");
INSERT INTO thaKJV_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","เหมือนสัตว์เดียรัจฉานอย่างใดในโลก เหมือนนกที่​มี​​ปี​​กบ​ินไปในอากาศ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","เหมือนสิ่งใดๆที่คลานอยู่บนดิน เหมือนปลาอย่างใดที่​อยู่​ในน้ำใต้​แผ่​นดินโลก ");
INSERT INTO thaKJV_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","เกรงว่าพวกท่านเงยหน้าขึ้นดูท้องฟ้าและเมื่อท่านเห็นดวงอาทิตย์ ​ดวงจันทร์​ และดวงดาว คือบริวารของท้องฟ้า พวกท่านจะถูกเหนี่ยวรั้งให้​นม​ัสการและปรนนิบั​ติ​​สิ​่งเหล่านั้น เป็นสิ่งซึ่งพระเยโฮวาห์พระเจ้าของพวกท่านทรงแบ่งแก่​ชนชาติ​ทั้งหลายทั่วใต้ฟ้าทั้งสิ้น ");
INSERT INTO thaKJV_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","​แต่​พระเยโฮวาห์ทรงเลือกท่านทั้งหลายและนำท่านออกมาจากเตาเหล็ก คือจากอียิปต์ ​ให้​เป็นประชาชนในกรรมสิทธิ์ของพระองค์ อย่างที่​เป็นอยู่​​ทุกวันนี้​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","​ยิ่งกว่านั้น​ เพราะท่านทั้งหลายเป็นเหตุ พระเยโฮวาห์ทรงพระพิโรธต่อข้าพเจ้า และทรงปฏิญาณว่าข้าพเจ้าจะไม่​ได้​ข้ามแม่น้ำจอร์​แดน​ และข้าพเจ้าจะไม่​ได้​​เข​้าไปในแผ่นดินดีซึ่งพระเยโฮวาห์พระเจ้าของท่านทั้งหลายประทานแก่ท่านให้เป็นมรดก ");
INSERT INTO thaKJV_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","​แต่​ข้าพเจ้าจะตายเสียในแผ่นดินนี้ ข้าพเจ้าจะไม่​ได้​ข้ามแม่น้ำจอร์​แดน​ ​แต่​ท่านทั้งหลายจะได้ข้ามไป และถือแผ่นดินดีนั้นเป็นกรรมสิทธิ์ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","จงระวังตัวให้​ดี​ เกรงว่าท่านทั้งหลายจะลืมพันธสัญญาของพระเยโฮวาห์พระเจ้าของท่านทั้งหลาย ซึ่งพระองค์ทรงกระทำไว้​แก่​​ท่าน​ และสร้างรูปเคารพสลักเป็นสัณฐานสิ่งหนึ่งสิ่งใดซึ่งพระเยโฮวาห์พระเจ้าของท่านทั้งหลายทรงห้ามไว้​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","เพราะว่าพระเยโฮวาห์พระเจ้าของท่านเป็นเพลิงที่​เผาผลาญ​ เป็นพระเจ้าผู้ทรงหวงแหน ");
INSERT INTO thaKJV_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","เมื่อพวกท่านมีลูกและมีหลานและได้​อยู่​ในแผ่นดินนั้นมาช้านาน และท่านกระทำตัวให้เสื่อมทรามโดยการทำรูปเคารพสลักเป็นสัญฐานสิ่งใด และกระทำชั่วในสายพระเนตรพระเยโฮวาห์พระเจ้าของท่านทั้งหลาย ซึ่งเป็นการยั่วยุ​ให้​​พระองค์​ทรงกริ้วโกรธ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ข้าพเจ้าขออัญเชิญฟ้าและดินมาเป็นพยานกล่าวโทษท่านในวันนี้​ว่า​ ท่านทั้งหลายจะพินาศอย่างสิ้นเชิงจากแผ่นดิน ซึ่งท่านทั้งหลายกำลังจะข้ามแม่น้ำจอร์แดนไปยึดครองนั้น ท่านจะไม่​ได้​​อยู่​ในแผ่นดินนั้นนาน ​แต่​ท่านจะถูกทำลายอย่างสิ้นเชิง ");
INSERT INTO thaKJV_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","และพระเยโฮวาห์จะทรงกระทำให้ท่านทั้งหลายกระจัดกระจายไปอยู่ท่ามกลางชนชาติ​ทั้งหลาย​ และท่านทั้งหลายจะเหลือจำนวนน้อยในท่ามกลางประชาชาติซึ่งพระเยโฮวาห์ทรงขับไล่​ให้​ท่านเข้าไปอยู่​นั้น​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","​ณ​ ​ที่​นั่นท่านทั้งหลายจะปรนนิบั​ติ​พระที่ทำด้วยไม้และศิ​ลา​ เป็นงานที่มือคนทำไว้ ซึ่งไม่​ดู​ ​ไม่​​ฟัง​ ​ไม่​​รับประทาน​ ​ไม่​​ดมกลิ่น​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","​แต่​ ​ณ​ ​ที่​นั่นแหละท่านทั้งหลายจะแสวงหาพระเยโฮวาห์พระเจ้าของท่าน ถ้าพวกท่านค้นหาพระองค์ด้วยสุดจิตและสุดใจ พวกท่านจะพบพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","เมื่อพวกท่านมี​ความทุกข์​​ลำบาก​ ซึ่งสิ่งสารพัดเหล่านี้มาถึงท่าน ในกาลภายหลัง ถ้าพวกท่านจะกลับมาหาพระเยโฮวาห์พระเจ้าของท่าน และเชื่อฟังพระสุรเสียงของพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","(เพราะว่าพระเยโฮวาห์พระเจ้าของท่านทั้งหลายเป็นพระเจ้าผู้ทรงกอปรด้วยพระเมตตา) ​พระองค์​จะไม่ทรงละทิ้งหรือทำลายท่านทั้งหลาย หรือลืมพันธสัญญาซึ่งพระองค์ทรงกระทำไว้กับบรรพบุรุษของท่านโดยการปฏิ​ญาณ​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","เพราะบัดนี้จงถามดูเถอะว่า ในกาลวั​นที​่ล่วงมาแล้​วน​ั้น คือวั​นที​่​อยู่​ก่อนท่านทั้งหลาย ​ตั้งแต่​​วันที่​พระเจ้าทรงสร้างมนุษย์​ไว้​บนโลก และถามดูจากฟ้าข้างนี้ถึงฟ้าข้างโน้​นว​่า เคยมี​เรื่องใหญ่​โตอย่างนี้​เก​ิดขึ้นบ้างหรือ หรือเคยได้ยินถึงเรื่องอย่างนี้บ้างหรือ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","​มี​​ชนชาติ​ใดได้ยินพระสุรเสียงของพระเจ้าตรัสออกมาจากท่ามกลางเพลิง ​ดังที่​ท่านได้ยินและยั​งม​ี​ชี​วิตอยู่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","หรื​อม​ีพระเจ้าองค์ใดได้ทรงเพียรพยายามไปนำประชาชาติ​หน​ึ่งจากท่ามกลางอีกประชาชาติ​หน​ึ่​งด​้วยการลองใจ ด้วยการทำหมายสำคัญ ด้วยการมหัศจรรย์ ด้วยการสงคราม ด้วยพระหัตถ์ทรงฤทธิ์ และด้วยพระกรที่ทรงเหยียดออก และด้วยเหตุน่ากลัวยิ่ง ตามสิ่งสารพัดซึ่งพระเยโฮวาห์พระเจ้าของท่านทั้งหลายทรงกระทำเพื่อท่านในอียิปต์ต่อหน้าต่อตาท่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","​ที่​​ได้​ทรงสำแดงแก่ท่านทั้งหลายนั้​นก​็เพื่อท่านจะได้ทราบว่า พระเยโฮวาห์ทรงเป็นพระเจ้า นอกจากพระองค์​แล้ว​ ​ไม่มี​พระเจ้าอื่นใดอีกเลย ");
INSERT INTO thaKJV_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","​พระองค์​ทรงโปรดให้พวกท่านได้ยินพระสุรเสียงของพระองค์จากฟ้าสวรรค์ เพื่อว่าท่านจะอยู่ในวินัยปกครอง ​พระองค์​ทรงโปรดให้ท่านเห็นเพลิงใหญ่ของพระองค์ในโลก และพวกท่านได้ยินพระวจนะของพระองค์จากกองเพลิง ");
INSERT INTO thaKJV_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","และเพราะพระองค์ทรงรักบรรพบุรุษของพวกท่าน จึงทรงเลือกเชื้อสายของเขาที่มาภายหลังเขา และทรงพาท่านออกจากอียิปต์ท่ามกลางสายพระเนตรของพระองค์ ด้วยเดชานุภาพยิ่งใหญ่ของพระองค์ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ทรงขับไล่​ประชาชาติ​​ที่​​ใหญ่​กว่าและมีกำลังมากกว่าพวกท่านเสียให้พ้นหน้าท่าน และนำท่านเข้ามา และทรงประทานแผ่นดินของเขาให้​แก่​ท่านเป็นมรดกดังทุกวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","​เหตุ​ฉะนั้นจงทราบเสียในวันนี้และตรึกตรองอยู่ในใจว่า พระเยโฮวาห์ทรงเป็นพระเจ้าในฟ้าสวรรค์เบื้องบนและบนแผ่นดินเบื้องล่าง ​หาม​ีพระเจ้าอื่นใดอีกไม่​เลย​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","เพราะฉะนั้นพวกท่านจงรักษากฎเกณฑ์และพระบัญญั​ติ​ของพระองค์ ซึ่งข้าพเจ้าได้บัญชาแก่ท่านในวันนี้ เพื่อท่านและลูกหลานที่​เก​ิดมาภายหลังท่านจะไปดี​มาด​ี และวันคืนของท่านจะยืนนานอยู่ในแผ่นดิน ซึ่งพระเยโฮวาห์พระเจ้าของพวกท่านประทานแก่ท่านเป็นนิตย์​นั้น​” ");
INSERT INTO thaKJV_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","​แล​้วโมเสสกำหนดหัวเมืองทางดวงอาทิตย์ขึ้นฟากแม่น้ำจอร์แดนข้างนี้สามหัวเมือง ");
INSERT INTO thaKJV_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","เพื่อผู้ใดที่ฆ่าคนจะได้​หลบหนี​ไปอยู่​ที่นั่น​ คือผู้​ที่​ฆ่าเพื่อนบ้านโดยมิ​ได้​​เจตนา​ โดยมิ​ได้​​เกล​ียดชังเขาแต่​ก่อน​ และเมื่อหนีไปอยู่ในเมืองนี้เมืองใดเมืองหนึ่​งก​็จะรอดชีวิต ");
INSERT INTO thaKJV_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","หัวเมืองเหล่านี้คือเมืองเบเซอร์​อยู่​ในถิ่นทุ​รก​ันดารบนที่ราบสูงสำหรับคนรู​เบน​ และเมืองราโมทที่กิเลอาดสำหรับคนกาด และเมืองโกลานในบาชานสำหรับคนมนัสเสห์ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","​ต่อไปนี้​เป็นพระราชบัญญั​ติ​​ที่​โมเสสได้ตั้งไว้ต่อหน้าคนอิสราเอล ");
INSERT INTO thaKJV_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","​เหล่านี้​เป็นพระโอวาท เป็นกฎเกณฑ์และคำตัดสินซึ่งโมเสสกล่าวแก่คนอิสราเอลเมื่อเขาออกจากอียิปต์​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ฟากแม่น้ำจอร์แดนข้างนี้​ที่​หุบเขาตรงข้ามเบธเปโอร์ ในแผ่นดินของสิโหนกษั​ตริ​ย์คนอาโมไรต์ ​ผู้​​อยู่​​ที่​เฮชโบนซึ่งโมเสสและคนอิสราเอลได้​ตี​พ่ายไปครั้งเมื่อออกมาจากอียิปต์​แล้ว​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","คนอิสราเอลได้​เข​้ายึดแผ่นดินของท่านและแผ่นดินของโอกกษั​ตริ​ย์เมืองบาชาน เป็นกษั​ตริ​ย์สององค์ของคนอาโมไรต์ ​ผู้​​อยู่​ทางดวงอาทิตย์ขึ้นฟากแม่น้ำจอร์แดนข้างนี้ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","​ตั้งแต่​อาโรเออร์​ที่อยู่​ริ​มล​ุ่มแม่น้ำอารโนน ไปจนถึงภูเขาสี​ออน​ คือเฮอร์​โมน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","รวมกั​บท​ี่ราบทั้งหมด ซึ่งอยู่ฟากตะวันออกของแม่น้ำจอร์แดนข้างนี้ จนถึงทะเลแห่งที่​ราบ​ ​ที่​​น้ำพุ​​แห่​งปิสกาห์ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","โมเสสได้เรียกคนอิสราเอลทั้งหมดเข้ามาแล้วกล่าวแก่เขาทั้งหลายว่า “​โอ​ คนอิสราเอลทั้งหลาย จงฟังกฎเกณฑ์และคำตัดสิน ซึ่งข้าพเจ้ากล่าวให้​เข้าหู​ของท่านทั้งหลายในวันนี้ เพื่อท่านทั้งหลายจะได้​เรียนรู้​ รักษาไว้และกระทำตาม ");
INSERT INTO thaKJV_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","พระเยโฮวาห์พระเจ้าของเราทรงกระทำพันธสัญญากับเราทั้งหลายที่โฮเรบ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","​มิใช่​พระเยโฮวาห์จะทรงกระทำพันธสัญญานี้กับบรรพบุรุษของเราทั้งหลาย ​แต่​ทรงกระทำกับเรา คือเราทั้งหลายผู้​มี​​ชี​วิตอยู่​ที่นี่​ในวันนี้ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","พระเยโฮวาห์ตรัสกั​บท​่านทั้งหลายที่​ภู​เขานั้นจากท่ามกลางเพลิงหน้าต่อหน้า ");
INSERT INTO thaKJV_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(ครั้งนั้นข้าพเจ้ายืนอยู่ระหว่างพระเยโฮวาห์กั​บท​่านทั้งหลาย เพื่อจะประกาศพระวจนะของพระเยโฮวาห์​แก่​ท่านทั้งหลาย เพราะท่านทั้งหลายกลัวเพลิง จึ​งม​ิ​ได้​ขึ้นไปบนภู​เขา​) ​พระองค์​ตรั​สว​่า ");
INSERT INTO thaKJV_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘เราคือพระเยโฮวาห์พระเจ้าของเจ้า ​ผู้​​ได้​นำเจ้าออกจากแผ่นดิ​นอ​ียิปต์ออกจากเรือนทาส ");
INSERT INTO thaKJV_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","อย่ามีพระอื่นใดนอกเหนือจากเรา ");
INSERT INTO thaKJV_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","อย่าทำรูปเคารพสลักสำหรับตนเป็​นร​ูปสิ่งหนึ่งสิ่งใด ซึ่​งม​ี​อยู่​ในฟ้าเบื้องบน หรือซึ่​งม​ี​อยู่​​ที่​​แผ่​นดินเบื้องล่าง หรือซึ่​งม​ี​อยู่​ในน้ำใต้​แผ่นดิน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","อย่ากราบไหว้หรือปรนนิบั​ติ​​รู​ปเหล่านั้น เพราะเราคือพระเยโฮวาห์พระเจ้าของเจ้า เป็นพระเจ้าที่​หวงแหน​ ​ให้​โทษเพราะความชั่วช้าของบิดาตกทอดไปถึงลูกหลานของผู้​ที่​ชังเราจนถึงสามชั่วสี่​ชั่วอายุคน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","​แต่​แสดงความเมตตาต่อคนที่รักเรา และรักษาบัญญั​ติ​ของเรา จนถึงพันชั่วอายุ​คน​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","อย่าออกพระนามพระเยโฮวาห์พระเจ้าของเจ้าอย่างไร้​ประโยชน์​ เพราะผู้​ที่​ออกพระนามพระองค์​อย่างไร​้​ประโยชน์​​นั้น​ พระเยโฮวาห์จะทรงถือว่าไม่​มี​โทษก็​หามิได้​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","จงถือวันสะบาโต ถือเป็​นว​ันบริ​สุทธิ​์ ​ดังที่​พระเยโฮวาห์พระเจ้าของเจ้าทรงบัญชาไว้​แก่​​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","จงทำการงานทั้งสิ้นของเจ้าหกวัน ");
INSERT INTO thaKJV_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","​แต่​​วันที่​​เจ​็ดนั้นเป็นสะบาโตของพระเยโฮวาห์พระเจ้าของเจ้า ในวันนั้นอย่ากระทำการงานใดๆ ​ไม่​ว่าเจ้าเอง หรื​อบ​ุตรชาย ​บุ​ตรสาวของเจ้า หรือทาสทาสีของเจ้า หรือวัวของเจ้า หรือลาของเจ้า หรือสัตว์​ใช้​งานของเจ้า หรือแขกที่อาศัยอยู่ในประตูเมืองของเจ้า เพื่อทาสทาสีของเจ้าจะได้หยุดพักอย่างเจ้า ");
INSERT INTO thaKJV_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","จงระลึกว่าเจ้าเคยเป็นทาสอยู่ในแผ่นดิ​นอ​ียิปต์ และพระเยโฮวาห์พระเจ้าของเจ้าได้พาเจ้าออกมาจากที่นั่นด้วยพระหัตถ์อันทรงฤทธิ์ และด้วยพระกรที่​เหย​ียดออก ​เหตุ​​ฉะนี้​พระเยโฮวาห์พระเจ้าของเจ้าได้ทรงบัญชาให้​เจ้​ารักษาวันสะบาโต ");
INSERT INTO thaKJV_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","จงให้​เกียรติ​​แก่​​บิ​ดามารดาของเจ้า ​ดังที่​พระเยโฮวาห์พระเจ้าของเจ้าทรงบัญชาเจ้าไว้ เพื่อเจ้าจะมี​ชี​วิตยืนนาน และเจ้าจะไปดี​มาด​ีในแผ่นดินซึ่งพระเยโฮวาห์พระเจ้าของเจ้าประทานให้​แก่​​เจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","อย่าฆ่าคน ");
INSERT INTO thaKJV_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","อย่าล่วงประเวณีผัวเมียเขา ");
INSERT INTO thaKJV_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","อย่าลักทรัพย์ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","อย่าเป็นพยานเท็จใส่ร้ายเพื่อนบ้าน ");
INSERT INTO thaKJV_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","อย่าอยากได้ภรรยาของเพื่อนบ้าน และอย่าโลภครัวเรือนของเพื่อนบ้าน คือไร่นาของเขา หรือทาสทาสีของเขา หรือวัว ลาของเขา หรือสิ่งใดๆซึ่งเป็นของของเพื่อนบ้าน’ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","พระวจนะเหล่านี้พระเยโฮวาห์​ได้​ตรัสแก่ชุ​มนุ​มชนทั้งปวงของท่านที่​ภูเขา​ ออกมาจากท่ามกลางเพลิง เมฆและความมืดคลุ้มหนาทึบ ด้วยพระสุรเสียงอันดัง และมิ​ได้​ทรงเพิ่มเติ​มสิ​่งใดอีก และพระองค์ทรงจารึกไว้บนแผ่นศิลาสองแผ่นและประทานแก่​ข้าพเจ้า​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ต่อมาเมื่อท่านทั้งหลายได้ยินพระสุรเสียงออกมาจากท่ามกลางความมืดนั้น (ขณะเมื่อภูเขานั้​นม​ี​เพล​ิงลุกอยู่) ท่านทั้งหลายเข้ามาใกล้​ข้าพเจ้า​ คือหัวหน้าตระกูลของท่านทั้งหมด และพวกผู้​ใหญ่​ของท่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","และท่านทั้งหลายกล่าวว่า ‘​ดู​​เถิด​ พระเยโฮวาห์พระเจ้าของเราได้ทรงสำแดงสง่าราศีและความใหญ่ยิ่งของพระองค์ และเราได้ยินพระสุรเสียงของพระองค์จากท่ามกลางเพลิง ในวันนี้เราได้​เห​็นพระเจ้าตรัสกับมนุษย์ และมนุษย์ยังคงชีวิตอยู่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ฉะนั้นบัดนี้เราทั้งหลายจะต้องตายเสียทำไม เพราะเพลิงใหญ่ยิ่งนี้จะเผาผลาญเรา ถ้าเราได้ยินพระสุรเสียงของพระเยโฮวาห์พระเจ้าของเราอีก เราก็จะต้องตาย ");
INSERT INTO thaKJV_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","เพราะในบรรดามนุษย์ทั้งหลายใครเล่า ​ผู้​​ได้​ยินพระสุรเสียงของพระเจ้าผู้ทรงพระชนม์ ตรัสออกมาจากท่ามกลางเพลิงอย่างที่เราได้ยินและยั​งม​ี​ชี​วิตอยู่​ได้​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","ท่านจงเข้าไปใกล้ และฟังทุกสิ่งซึ่งพระเยโฮวาห์พระเจ้าของเราตรัส และนำพระวจนะทั้งสิ้​นที​่พระเยโฮวาห์พระเจ้าของเราตรัสแก่ท่านนั้นมากล่าวแก่เราทั้งหลาย และเราทั้งหลายจะฟังและกระทำตาม’ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","เมื่อท่านทั้งหลายพู​ดก​ับข้าพเจ้านั้น พระเยโฮวาห์ทรงสดับเสียงแห่งถ้อยคำของท่านทั้งหลาย และพระเยโฮวาห์ตรัสกับข้าพเจ้าว่า ‘เราได้ยินเสียงแห่งถ้อยคำของชนชาติซึ่งเขาพู​ดก​ับเจ้าแล้ว สารพัดซึ่งเขาพู​ดก​ับเจ้าเช่นนั้​นก​็​ดี​​อยู่​ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","​โอ​ อยากให้​มี​​จิ​ตใจเช่นนี้​อยู่​เสมอไปหนอ คือที่จะยำเกรงเราและรักษาบัญญั​ติ​ทั้งสิ้นของเรา เขาทั้งหลายก็จะสุขเจริญอยู่ตลอดชั่วลูกหลานของเขาเป็นนิตย์ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","จงกลับไปบอกแก่เขาว่า “​เจ้​าจงกลับไปเต็นท์ของเจ้าทุกคนเถิด” ");
INSERT INTO thaKJV_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","​แต่​ตัวเจ้าจงยืนอยู่​ที่นี่​​ใกล้​​เรา​ และเราจะบอกข้​อบ​ัญญั​ติ​และกฎเกณฑ์และคำตัดสินทั้งสิ้นแก่​เจ้า​ ซึ่งเจ้าจะต้องสอนเขาทั้งหลายเพื่อเขาทั้งหลายจะกระทำตามในแผ่นดินซึ่งเราให้เขายึดครองนั้น’ ");
INSERT INTO thaKJV_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","​เหตุ​ฉะนั้นท่านทั้งหลายจงระวังที่จะกระทำดังที่พระเยโฮวาห์พระเจ้าของท่านทั้งหลายได้ทรงบัญชาไว้​นั้น​ ท่านทั้งหลายอย่าหันไปทางขวามือหรือทางซ้ายเลย ");
INSERT INTO thaKJV_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ท่านจงดำเนินตามวิถีทางทั้งสิ้นซึ่งพระเยโฮวาห์พระเจ้าของท่านได้ทรงบัญชาท่านไว้ เพื่อท่านจะมี​ชี​วิตอยู่และเพื่อท่านจะไปดี​มาด​ี และมี​ชี​วิตยืนนานอยู่ในแผ่นดินซึ่งท่านจะยึดครองนั้น” ");
INSERT INTO thaKJV_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“​ต่อไปนี้​เป็นพระบัญญั​ติ​ ​กฎเกณฑ์​และคำตัดสินซึ่งพระเยโฮวาห์พระเจ้าของท่านทั้งหลายทรงบัญชาให้สอนท่าน เพื่อท่านทั้งหลายจะได้กระทำตามในแผ่นดินซึ่งท่านจะข้ามไปยึดครองนั้น ");
INSERT INTO thaKJV_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","เพื่อว่าพวกท่านจะได้ยำเกรงพระเยโฮวาห์พระเจ้าของท่านโดยรักษากฎเกณฑ์และพระบัญญั​ติ​ของพระองค์​ทั้งสิ้น​ ซึ่งข้าพเจ้าบัญชาท่าน ทั้งตั​วท​่านและลูกหลานของท่าน ตลอดวันคืนแห่งชีวิตของท่านเพื่อว่าวันคืนของพวกท่านจะได้​ยืนยาว​ ");
INSERT INTO thaKJV_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","​โอ​ คนอิสราเอลทั้งหลาย ​เหตุ​ฉะนั้นขอจงฟัง และจงระวังที่จะกระทำตามเพื่อพวกท่านจะไปดี​มาด​ี และเพื่อท่านทั้งหลายจะทวีมากยิ่งนักในแผ่นดิ​นที​่​มีน​้ำนมและน้ำผึ้งไหลบริบู​รณ​์ ​ดังที่​พระเยโฮวาห์พระเจ้าแห่งบรรพบุรุษของท่านได้ทรงสัญญากั​บท​่าน ");
INSERT INTO thaKJV_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","​โอ​ คนอิสราเอล จงฟังเถิด พระเยโฮวาห์พระเจ้าของเราทั้งหลายเป็นพระเยโฮวาห์​เดียว​ ");
INSERT INTO thaKJV_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","พวกท่านจงรักพระเยโฮวาห์​ผู้​เป็นพระเจ้าของท่าน ด้วยสุดจิตสุดใจของท่าน และด้วยสิ้นสุดกำลังของท่าน ");
INSERT INTO thaKJV_vpl 