﻿USE sofia;
DROP TABLE IF EXISTS sofia.tgp_vpl;
CREATE TABLE tgp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tgp_vpl WRITE;
INSERT INTO tgp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Reti nike mo vereuli na pin Iesu Kr̃isto, mahapin Abraham enia Supe David. ");
INSERT INTO tgp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham enia taman Isaac. Isaac enia taman Jacob, ale Jacob enia taman Judah tolu na voraina, ");
INSERT INTO tgp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah enia taman Perez peresi Zerah, ale tinara Tamar, Perez enia taman Hezron, ale Hezron enia taman Ram, ");
INSERT INTO tgp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram enia taman Amminadab, Amminadab enia taman Nahshon, ale Nahshon enia taman Salmon, ");
INSERT INTO tgp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ale Salmon enia taman Boaz, ale tinana Rahab, Boaz enia taman Obed, ale tinana Ruth, ale Obed enia taman Jesse, ");
INSERT INTO tgp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse enia taman Supe David, Supe David enia taman Solomon, ale tinana Bathshiba enia malepun Uriah sei, ");
INSERT INTO tgp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon enia taman Rehoboam. Rehoboam enia taman Abijah, ale Abijah enia taman Asaph, ");
INSERT INTO tgp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaph enia taman Jehoshaphat, Jehoshaphat enia taman Joram, Joram enia pin Uzziah, ");
INSERT INTO tgp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ale Uzziah enia taman Jotham, Jotham enia mahapin Ahaz, ale Ahaz enia taman Hezekiah, ");
INSERT INTO tgp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah enia taman Manasseh, Manasseh enia taman Amos, ale Amos enia taman Josiah, ");
INSERT INTO tgp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah enia pin Jechoniah tolu na tahisana, enira hasera purongo natu la pa lo mauri hin pongi atu mara Babylon la tauri na tavtavuin Israel la lavira la vano Babylon. ");
INSERT INTO tgp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hitahun rani atu mara Babylon la lavira la vano, ale pina mo vano sohen harihi: Jechoniah enia taman Shealtiel, ale Shealtiel enia taman Zerabbabel, ");
INSERT INTO tgp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerabbabel enia taman Abiud, Abiud enia taman Eliakim, ale Eliakim enia taman Azor, ");
INSERT INTO tgp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ale Azor enia taman Zadok, Zadok enia taman Achim, ale Achim enia taman Eliud, ");
INSERT INTO tgp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud enia taman Eleazar, Eleazar enia taman Matthan, ale Matthan enia taman Jacob, ");
INSERT INTO tgp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ale Jacob enia taman Joseph, Joseph enia tuan Mary, ale Iesu mo vora isan Mary, enia haratu la tovia Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ale mo sohena natu, pin Abraham mo tikeli Supe David mo tikeli 14, ale pin Supe David mo tikeli rani atu la vano Babylon mo tikeli 14, ale pina hin rani atu tamlohi la vano Babylon mo tikeli na rani Kr̃isto mo vora mo tikeli 14. ");
INSERT INTO tgp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ale reti vora non Iesu nor̃a Kr̃isto mo sohen harihi: Tinana Mary, la tapuhia vara i pa naroun Joseph, pani la sopo lo lahi pani o er̃i hitea vara Mary mo tau natuna moiso na suihan Tanume Tapu. ");
INSERT INTO tgp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph sei enia i pa tuan Mary, ale matan enia tamlohi vokevoke matea, mo sopo opoia vara i vai Mary i mahanuhanu, ale mo aleale malele vara i tinar̃ihia, ale tea la pa sopo levosahia. ");
INSERT INTO tgp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pani Joseph mo pa lo r̃omr̃omia, ale vahatea purongo, angelo non Moli God matea mo pala isana na mavuho, ale mo verea mara, “Joseph pin David, o sopo matahu vara o lavi Mary naroum. Hina rihirihi sei na lolona mo tai isan Tanume Tapu. ");
INSERT INTO tgp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I pa vasusui na natirihi lamane matea, ale o pa tau na hijana vara Iesu matan enia i pa juri na nona tamlohi na nora hehe.” ");
INSERT INTO tgp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","La hinau nike, la masese matan vara i mar̃ivisi na sava Moli God mo verea isana pr̃ovet tuai sei mara, ");
INSERT INTO tgp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Eh! Har̃ai maevo matea i pa pangepange, ale i pa vasusui na natuna lamane matea. La pa tau na hijana vara Immanuel.’ R̃aramin hija atu enia, ‘God mo lo toho isar̃a’. ");
INSERT INTO tgp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hitahuna Joseph mara mo turu, mo vai na sava angelo atu non Moli God mo lo verea, ale mo lavia narouna, ");
INSERT INTO tgp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","pani mo sopo juruvi peresia mo mai mo tikeli na rani mo vasusui na natuna lamane matea, ale mo tau na hijana vara Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ale nake, Iesu mo vora Bethlehem na jara tavera Judea na pongi Herod mo lo supe ea, ale mo sopo tuai, tamlohi lelevosahi mata vitusarasara hai matan Opae la mai Jerusalem, ");
INSERT INTO tgp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","la lo usia lara, “Nene natirihi atu mo vora vara i pa Supe nona Jew? Kama hite na vitusarasarana hin rani atu mo vele atuvano Opae, ale kama mai vara kama lotua.” ");
INSERT INTO tgp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Supe Herod mara mo rongo nora retiusia sei, enia tolu na tamlohi tari na lolon Jerusalem r̃omira la kaka matana. ");
INSERT INTO tgp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mo tovi na matavuhi matea nona moli nona pr̃is peresi na tamlohi vujangi mata leu nona tamlohi, ale mo usia isara mara, “Sava jara natu, nor̃a Kr̃isto i pa vora hinia?” ");
INSERT INTO tgp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","La r̃aramia lara, “Na vanuan Bethlehem na lolon Judea, matan pr̃ovet tuai matea mo ulia sohen harihi mara, ");
INSERT INTO tgp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bethlehem sei na jara tavera atu Judah, engko ko aulu ko jeu la haratu la lo aulu Judah. Tamlohi aulu matea i pa tai isam i pa tavui sipsip mata i kilau na noku tamlohi Israel.’” ");
INSERT INTO tgp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Moiso, Herod mo mele tovi r̃or̃oi na matavuhi matea peresi la tamlohi lelevosahi atu, matan vara i levosahi na rani tataholo la hite vitusarasara atu mo lo pala hinia. ");
INSERT INTO tgp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Moiso Herod mo r̃ulera la vano Bethlehem, ale mo verea mara, “Ha vano, ha ale mamahuni natirihi atu, ale vara ka hitea, ha mai ha vereau hinia, ale enau sohena a pa vano a lotua.” ");
INSERT INTO tgp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","La tamlohi lelevosahi atu la rongo la reti atu non supe moiso la turu la vano. Ale, la mele hite pa vitusarasara atu la lo hitea Opae, mo tiromara mo vano tataholo hin jara atu natirihi atu mo lo toho ea. ");
INSERT INTO tgp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","La tamlohi lelevosahi atu lara la hite vitusarasara atu, la avulahi la uloulo tavera matana. ");
INSERT INTO tgp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lara la unu hin ima atu la hite natirihi atu mo lo toho hinia peresi tinana Mary. La popovitoho isana, ale la lotua. La roi na nora tavtav, ale la sile na nora otori mata gold peresi la hasori r̃uhu atu frankincense peresi na myrrh isana. ");
INSERT INTO tgp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pani God mo retir̃oar̃oahai isan la tamlohi lelevosahi atu na mavuho matea vara la sopo mele hilu la vano isan Herod. Ale la mule na jarara na malele tinapua. ");
INSERT INTO tgp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","La tamlohi lelevosahi atu lara la mule, vahatea purongo, angelo non Moli God matea mo pala isan Joseph na mavuho matea, mo verea mara, “O turu! O lavi natirihi sei peresi tinana ha rovo ha sivo Egypt matan nakerihi Herod i pa ale natirihi sei vara i vilimateia. Ha lo toho atu Egypt i tikeli rani atu a pa mele vere kamim hinia vara ha er̃i mele hilu.” ");
INSERT INTO tgp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Vahatea purongo, Joseph mo turu mo lavi natirihi atu peresi tinana la malue la sivo Egypt hin vutepongi atu, ");
INSERT INTO tgp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","moiso, Joseph mo lo toho Egypt mo tikeli na rani Herod mo mate. Hinau nike, mo masese sohena usuri na sava pr̃ovet la verea tuai moiso lara Moli God mo verea mara, ‘Na tovi nar̃ihi natuku Egypt’. ");
INSERT INTO tgp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Moiso, Herod mara mo hitevosahia vara la tamlohi lelevosahi atu la halua, ale mo lolokoru patuna, ale mo sile na retileu matea vara nona tamlohi vuro la vilimatei na pipi lamane tari sei taunira mo rua teni taunira mo sivo atano na lolon Bethlehem peresi na jara la toho r̃alihia, Herod mo vaia usuri rani atu la tamlohi lelevosahi atu la verea. ");
INSERT INTO tgp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Moiso, sava hinau pr̃ovet Jeremiah mo verea mo masese sohen harihi mara, ");
INSERT INTO tgp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Na jara atu Ramah, tamlohi la lo tangi, ale la tangtangi tavera, Rachel mo lo tangisi na natuna, ale mo r̃ohu vara tea i nanau isana matan natuna la mate.’ ");
INSERT INTO tgp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pani na rani Herod mo mate, Joseph mo pa lo toho Egypt, ale hin rani atu, angelo matea non Moli God mo pala isana na mavuho matea, ");
INSERT INTO tgp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","angelo atu mo verea mara, “O turu! O lavi natirihi sei peresi tinana ha sahe Israel, matan la haratu sei la lo vaihitea vara la vilimatei natirihi sei la pete mate moiso.” ");
INSERT INTO tgp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ale Joseph mo lavi natirihi atu peresi tinana la sahe Israel. ");
INSERT INTO tgp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pani mara mo rongoa vara nake natun Herod, Archelaus mo lo tauri na suiha na lolon Judea, mo matahu vara i vano atu, ale mo mele lavi na retir̃oar̃oahai na nona mavuho tinapua matea vara i sahe Galilee. ");
INSERT INTO tgp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mo vano na taon tavera matea la tovia Nazareth, ale la tohoa atu vara sava pr̃ovet la verea tuai matan Kr̃isto i pa masese lara, ‘La pa tovia vara mara Nazareth’. ");
INSERT INTO tgp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hin rani atu John tamlohi paptijo mo pala mo tapulo retivujavujangi na jara hasetoho matan Judea. ");
INSERT INTO tgp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mo verea mara, “Ha posi na nomim hehe matan i pa sopo tuai suiha atu non God mo lo supe hinia i pa pala.” ");
INSERT INTO tgp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Matan enia haratu sei pr̃ovet Isaiah mo lo retireti hinia tuai sei mara, ‘Na jara hasetoho leona mo lo ulo mara: Ha tatamahuni na malele na mapumim matan Moli God i pa hahau hinia.’ ");
INSERT INTO tgp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ale rurun John la vaia na vulu camel, mo otioti na huri buluk; hana hinau enia hatpoha peresi na wai tau sugabag sei mo meji. ");
INSERT INTO tgp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hin rani atu la haratu la lo toho Jerusalem peresi na jara tari Judea, ale na jara r̃alihi na wai Jordan la lo vano vara la hitea, ");
INSERT INTO tgp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ale la taviti na nora hehe isana moiso John mo paptijo hinira na wai Jordan. ");
INSERT INTO tgp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pani John mara mo hitea vara Pharisee peresi na Sadducee matuvana la lo mai mata la paptijo, mo verea isara mara, “Kamim mata sasati! Hare mo retir̃oar̃oahai kamim vara ha rovo na aria tavera non God? ");
INSERT INTO tgp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ha vai na nomim vavahinau i vujangia vara ka posi varar̃uhu na nomim hehe. ");
INSERT INTO tgp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ha sopo r̃omaulu vara, ‘Kamam kama juri matan tamamam Abraham!’ matan na verea isamim, God i er̃i posi la vatu nike, la mai natun Abraham! ");
INSERT INTO tgp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Matan nakerihi, God mo lo tauri na rita matea moiso vara i tai na wari pahai. Vipahai tari atu la sopo vua r̃uhu, i pa taijovira, ale i pa pulahira na lolo hapu. ");
INSERT INTO tgp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Enau na lo paptijo hin la haratu la posi mata nora hehe na wai, pani i pa sopo tuai tamlohi matea i pa mai mo aulu jea hiniau, ale enau na sopo tataholo vara a uli nar̃ihi na asi eve palona. Enia i pa paptijo hin kamim na Tanume Tapu peresi na hapu. ");
INSERT INTO tgp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mo lo tauri na nona foko tavera na limana, ale i pa vasahi na nona jara ase na piri wit, ale i pa takonahi piri wit atu na nona pea, pani i pa suli na pahapaha piri wit na hapu sei tea i sopo er̃i vunia hin te rani.” ");
INSERT INTO tgp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Moiso Iesu mo tai Galilee mo vano na wai Jordan vara John i paptijo hinia. ");
INSERT INTO tgp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pani John mo vaihitea vara i horoa. Mo verea mara, “Mata sava ko mai isaku mata paptijo? Mo mele tataholo vara engko o paptijo hiniau!” ");
INSERT INTO tgp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu mo r̃aramia mara, “Nake mo tataholo vara o tinar̃ihia i vano sohena, matan vara r̃a er̃i vai vevuhi na malele hinau tari i tataholo la masese.” ");
INSERT INTO tgp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ale Iesu mara mo paptijo, mo lo maraha na wai, ale vahatea purongo tuka mo roi, moiso mo hite Tanumen God mo Tapu mo sinai atano mo tau isana sohena vomahe matea. ");
INSERT INTO tgp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ale vahatea leo matea mo reti na tuka mo verea mara, “Harihi enia Natuku, na opoia mo tavera, ale na avulahi tavera hinia.” ");
INSERT INTO tgp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Moiso, Tanume Tapu mo tiroman Iesu mo vano na jara hasetoho vara Tiapolo i vaihitea. ");
INSERT INTO tgp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ale Iesu mo tapuhoro na hanhani mata rani mo ngavulu vati peresi na pongi mo ngavulu vati, moiso mo mate hana. ");
INSERT INTO tgp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tiapolo mo mai isan Iesu matan vara i vaihitea, ale mo verea mara, “Vara engko Natun God, o vere la vatu sei la mai pereti.” ");
INSERT INTO tgp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pani Iesu mo r̃aramia mara, “Na Retiulia, God mo verea mara, ‘Tamlohi i sopo er̃i mauri na pereti purongo, pani na reti tari God mo verea.’” ");
INSERT INTO tgp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Moiso Tiapolo mo lavia mo sahe na taon tapu tavera sei Jerusalem, mo taua mo turu aulu na pingopingo Temple ea, ");
INSERT INTO tgp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ale mo verea isana mara, “Vara engko Natun God o kue, matan na Retiulia God mo verea mara, ‘Mo retileu isana nona angelo matam, matan vara la pa tauriho na limara, ale o pa sopo er̃i vujahi na palom hin te vatu.’” ");
INSERT INTO tgp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu mo r̃aramia mara, “La mele ulia na Retiulia God mo verea mara, ‘O sopo vaihite nom Moli God.’” ");
INSERT INTO tgp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ale Tiapolo mo mele lavi Iesu mo sahe aulu na vutivuti matea mo aulu jea, ale mo vujangia na jara tari na varama supe la lo tauri na suiha hinira peresi na nora tavtav tavera sei tamlohi la lo hasohasora matara. ");
INSERT INTO tgp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tiapolo mo verea isana mara, “Vara o popovitoho isaku, ale o lotuau a pa sileho hin la hinau tari sei.” ");
INSERT INTO tgp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Moiso, Iesu mo verea isana mara, “Setan, o vano! Matan na Retiulia God mo verea mara, ‘O pa lotu nom Moli God, ale o volitusi isana hasena purongo!’” ");
INSERT INTO tgp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Moiso, Tiapolo mo tinar̃ihi Iesu, ale vahatea purongo, angelo hai la mai isana Iesu la tuenia. ");
INSERT INTO tgp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nake Iesu mara mo rongoa vara la tau John na ima r̃ilangi, mo mele hilu mo vano Galilee. ");
INSERT INTO tgp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ale mo tinar̃ihi Nazareth mo vano mo lo toho Capernaum mariviti na tasi atu, na lolo jara matan Zebulun enia Naphtali, ");
INSERT INTO tgp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","matan vara retimangovi non pr̃ovet Isaiah sei mara, ");
INSERT INTO tgp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘La haratu na jara Zebulun enia Naphtali, peresi la haratu na tavalun tasi atu, peresi la haratu telesivo na wai Jordan, peresi Galilee jara tamlohi r̃or̃oha la lo toho ea, ");
INSERT INTO tgp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","la tamlohi atu la lo toho hin r̃or̃oha tavera atu la hite na malarani tavera atu, ale merana mo sasarami la haratu la lo toho na jara r̃or̃oha mata mateia.’ ");
INSERT INTO tgp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hin rani atu Iesu mo tapulo vara i retivujavujangi mo verea mara, “Ha posi na nomim hehe matan i pa sopo tuai, suiha atu non God sei mo supe hinia i pa pala.” ");
INSERT INTO tgp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu mo lo hahau na pahisa tasin Galilee, mo hite na vorai mo rua Simon la tovia Peter enia tasina Andrew la lo tara na tasi atu matan enira tamlohi aleale maji. ");
INSERT INTO tgp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ale Iesu mo verea mara, “Ha mai ha usuriau a pa vai kamim ha mai tamlohi aleale tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Vahatea la tau na nora tara, ale la usuria. ");
INSERT INTO tgp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iesu mo mele vano makomo, mo hite na vorai mo rua, James enia John, natun Zebedee. La lo toho na boti matea peresi tamara Zebedee. La lo tulai na nora tara, ale Iesu mo tovira vara la usuria. ");
INSERT INTO tgp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Vahatea la tinar̃ihi tamara na boti, ale la usuri Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu mo vano r̃alihi na jara Galilee mo lo vujangi na ima lotu nona Jew, mo lo retivujavujangi na Retir̃uhu matan mauri atu God mo aulu hinia isara. Iesu mo vai na tamlohi rojo peresi la haratu la majuejue mata rojoa la mele r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sorasoran Iesu mo vano na jara tari Syria. Tamlohi la lavi la haratu la rojo na rojoa matuvana la lo rongohaji na epera, hai la lo lavi na rani r̃ilangi matan tanume sasati mo lo toho hinira, hai la rave, hai la papao, Iesu mo vai mamahuni na nora rojoa tari. ");
INSERT INTO tgp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Vao tavera la tai Galilee, Decapolis, Jerusalem, Judea, ale na tavalu wai Jordan mo vano, la lo usuria. ");
INSERT INTO tgp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Matan Iesu mo hite na vao tamlohi la lo takonahi hin jara atu, ale mo sahe na vutivuti atu, ale mara mo sakele ea, nona tamlohi usuri la mai isana. ");
INSERT INTO tgp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Moiso mo tapulo retireti mo vujangira mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Avulahi r̃uhu isan la haratu la lo kilau isan God hasena mata hinau tari, matan mauri atu God mo supe hinia i pa nora. ");
INSERT INTO tgp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Avulahi r̃uhu isan la haratu la lo tangtangi matan God i pa nanaura. ");
INSERT INTO tgp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Avulahi r̃uhu isan la haratu la lo r̃omatano matan God i pa sile na varama isara. ");
INSERT INTO tgp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Avulahi r̃uhu isan la haratu la lo marohati, ale la lo mar̃ohu vara la vai na masalon God, matan enia i pa tuenira la vai na masalona, enira la pa masu. ");
INSERT INTO tgp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Avulahi r̃uhu isan la haratu la lo r̃omopoi na tinapua matan God i pa r̃omopoira. ");
INSERT INTO tgp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Avulahi r̃uhu isan la haratu mapura la vokevoke matan la pa hite God. ");
INSERT INTO tgp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Avulahi r̃uhu isan la haratu la lo tueni na tamlohi vara la sari tamata matan God i pa tovira natuna. ");
INSERT INTO tgp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Avulahi r̃uhu isan la haratu tamlohi la lo tipahira mata nora posposi tataholo, matan mauri atu God mo aulu hinia i pa nora. ");
INSERT INTO tgp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Avulahi r̃uhu isamim vara tamlohi la kali kamim teni vara la tipahi kamim teni la vere na retisasati tinatinapua hin kamim na retihaluhalu matan kamim noku tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ha uloulo, ha avulahi tavera matan nomim otori na tuka mo tavera mo sohena pr̃ovet tuai sei tiroma tamlohi la lo tipahira. ");
INSERT INTO tgp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kamim ka sohena solo mata varama, pani vara mejina i tihai i pa mele lavi na mejina sohena sava? I pa sopo mele r̃uhu matan te hinau, ale la pa pulahi nar̃ihia, ale tamlohi la pa hahau hinia. ");
INSERT INTO tgp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kamim ka sohena malarani mata varama. Vara te taon tavera i lo toho aulu na vutivuti i pa sopo er̃i luhu. ");
INSERT INTO tgp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ale tamlohi la sopo tauhoro na lamu hin te tanga, pani la kehohia aulu vara i sile na merana isana tamlohi tari na lolo ima. ");
INSERT INTO tgp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ale sohen haratu, ha vai na maurimim i memera i r̃uhu matan vara tamlohi la pa hite na nomim vavahinau r̃uhu ka lo vaira, ale la pa tahe aulu na hijan Tamamim na tuka. ");
INSERT INTO tgp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ha sopo r̃omr̃omia vara na mai vara a lavi nar̃ihi na leu teni sava pr̃ovet la verea. Na sopo mai vara a lavi nar̃ihira, pani vara hinau tari la pa masese hinira. ");
INSERT INTO tgp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Varar̃uhu na vere kamim hinia, i pa sopo te sope maki teni te reti hatea i er̃i tihai na Leu non God vavano hinau tari hinia la masese tiroma moiso tuka peresi na varama la pa tihai. ");
INSERT INTO tgp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Vara tea mo tope te retileu rihirihi matea na leu, ale mo lo vujangi na tinapua vara la vaia sohena, tamlohi atu i pa toho atano jea hin mauri atu God mo aulu hinia na tuka, pani vara tea mo lo oloolo na leu, ale mo lo vujangi na tinapua vara la oloolo na leu, tamlohi atu i pa lavi na hija aulu hin mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na vere kamim hinia, vara nomim posposi mo sopo tataholo varar̃uhu, i jue na posposi tataholo halu nona Pharisee peresi na tamlohi vujangi mata leu, ha pa sopo er̃i unu hin mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ka rongo na sava la verea isana tamlohi tuai lara, ‘Ha sopo vilimatei na tamlohi. Vara tea mo vilimatei te tamlohi i pa turu na aria.’ ");
INSERT INTO tgp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pani na verea isamim, vara ka lolokoru peresi na voraimim matea, ka levosahia moiso vara ha pa turu na aria, ale vara ha kali te voraimim hatea, ka levosahia moiso vara ha pa turu na court tavera nona Jew, ale vara ha vere na voraimim matea vara mo r̃ommate, ka levosahia moiso vara ha pa vano hin hapu atu na moruhapu. ");
INSERT INTO tgp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ale matana, vara ka lo lavi na nomim silesilea vara ha pa taua na votavota mata malamalai, ale vara ka r̃omr̃omia vara voraimim matea mo lolokoru hin kamim matan ka vai te hinau matea, ");
INSERT INTO tgp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ale ha tau na nomim silesilea atu na votavota mata malamalai, ale ha vano ha vai na tamata peresia tiroma, moiso ha pa mele mai vara ha sohai na nomim silesilea. ");
INSERT INTO tgp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Vara nomim meresahi mo opoia vara i tau kamim na court ha vaia i mai tapalamim matea vila na malele ka lo vano na court. Vara i vono i pa vai kamim ha vano na lima tamlohi aria, ale i pa tau kamim na lima tamlohi mata ima r̃ilangi, ale i pa tau kamim na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Varar̃uhu, na vere kamim hinia, ha pa sopo er̃i malue hin ima r̃ilangi atu i tikeli na rani ha voli vevuhi na nomim ave ka vaira. ");
INSERT INTO tgp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ka rongo na sava la verea moiso lara, ‘O sopo juruvi peresi te har̃ai mo sopo naroum’. ");
INSERT INTO tgp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pani na vere kamim hinia, vara tea mo kilau na har̃ai matea ale mo r̃omusuri hinia, mapuna mo pete vaivaileu peresia moiso. ");
INSERT INTO tgp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Vara matua matam mo hite te hinau mo vaiho ko opoia vara o vai na hehe, o julai nar̃ihia o pulahia. I pa mele r̃uhu jea vara te tavalu epem hatelete purongo i tihai hin haratu vara enira mo isoiso la pulahira na moruhapu. ");
INSERT INTO tgp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Vara marau limam mo vaiho ko opoia vara o vai na hehe, o tai rotoa o pulahia. I pa mele r̃uhu jea vara te tavalu epem hatelete purongo i tihai hin haratu vara enira mo isoiso la pulahira na moruhapu. ");
INSERT INTO tgp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","La ulia moiso vara tea mo opoia vara i r̃ohu hin narouna i pa er̃i sile na certificate matea mata i r̃ohu purongo hinia. ");
INSERT INTO tgp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pani enau na lo vere kamim hinia, vara mo sopo tataholo vara tea i r̃ohu hin narouna matan te hinau, pani vara narouna mo vai na posposi viriu peresi na tamlohi tinapua, ale vara te tamlohi tinapua i lahi peresi na har̃ai sohen haratu, tamlohi atu mo vaivaileu peresia. ");
INSERT INTO tgp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ka rongoa la verea isana pir̃a tuai lara, ‘O sopo tope na nom retitauhi, ale o pa turu na nom retitauhi ko vaia na hijan Moli’. ");
INSERT INTO tgp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pani enau na vere kamim hinia vara ha sopo vere na nomim retitauhi na hijan tuka matan tuka enia jara sakele mata suiha non God, ");
INSERT INTO tgp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ha sopo vere na nomim retitauhi na hijan varama matan varama enia jara palon God. Ha sopo vere na nomim retitauhi na hijan Jerusalem, matan haratu enia taon tavera non supe tavera atu. ");
INSERT INTO tgp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ale ha sopo vere na nomim retitauhi na patumim matan ha sopo er̃i vai te vulu hatea i lulu teni i viriha. ");
INSERT INTO tgp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Vara ha vere na nomim retitauhi ha verea purongo vara ‘io!’ teni ‘mo vono!’ Ha sopo mele vere te hinau i aulu hin haratu matan hinau tinapua mo tai isan Tiapolo. ");
INSERT INTO tgp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ka rongoa la verea tuai moiso lara, ‘Mata matea mata mata matea’ ale ‘Hur̃u matea mata hur̃u matea’. ");
INSERT INTO tgp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pani nake enau na lo vere kamim hinia vara ha sopo kele haratu mo komo kamim. Vara tea i vojai na tavalu esem o majinga hinia vara i mele vojai na tavalu esem tinapua. ");
INSERT INTO tgp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Vara tea mo reveho ko vano na court matan vara o sile na nom ruru isana, o silea peresi na nom ruru mata hamariri. ");
INSERT INTO tgp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Vara te tamlohi vuro mo lo ngurunguru hiniho vara o sapele na nona tanga mata kilometre matea, o sapelea mata kilometre i rua. ");
INSERT INTO tgp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Vara tea i usiho matan te nona opoia o silea, ale o sopo r̃ohu vara tea mo opoi te nom hinau tako. ");
INSERT INTO tgp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ka rongoa la verea moiso lara, ‘O opoi na tahisam!’ Ale lara, ‘O r̃ohu na nom meresahi!’ ");
INSERT INTO tgp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pani enau na lo vere kamim hinia vara, ha opoi na nomim meresahi, ale ha usiusi matan la haratu la lo tipahi kamim, ");
INSERT INTO tgp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","matan vara ha pa vai na vavahinau non la haratu la natun Tama varar̃uhu na tuka, matan enia mo vai na alo mo mera isana tamlohi r̃uhu peresi na tamlohi sasati, ale mo sile na usa isana tamlohi tataholo peresi na tamlohi lejileji. ");
INSERT INTO tgp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Matan vara ha lo opoi la haratu purongo sei la lo opoi kamim, ha pa sopo lavi na nomim otori isan God, ale la haratu la lo lavi na mania mata takis la lo opoi na tapalara purongo, ale ka hitea, la pa sopo lavi te volira matana. ");
INSERT INTO tgp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ale vara ha lo retioloolo isana tapalamim purongo, ka sopo vai te hinau r̃uhu i jeu na tamlohi r̃or̃oha matan enira la lo retioloolo isana tapalara purongo sohemim. ");
INSERT INTO tgp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ale matana, na lo verea vara tarea ha pa vai na hina tataholo sohen Tamamim na tuka mo tataholo r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Vara ka vai na hina r̃uhu na naho tamlohi, ha sopo vaia matan vara tamlohi la pa hasohaso kamim matana, matan vara ha vaia sohena, Tamamim na tuka i pa sopo sile na otori isamim. ");
INSERT INTO tgp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Vara ka silesile isana tamlohi tilavono, ha sopo tiv na tavue matana. Hinau atu tamlohi tapnetano la lo opoia mo tavera vara la lo vaia na naho tamlohi na ima lotu, ale na jingoima vara la pa hasohasora matana. Varar̃uhu, na verea isamim, enira la pete lavi na volira moiso. ");
INSERT INTO tgp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ale vara ha sile te hinau isana tilavono, ha sopo vaia vara tinapua i levosahia, ");
INSERT INTO tgp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","matan vara sava ka silea na jara luhu, Tamamim mo lo hite na sava ka lo vaia na jara luhu, ale enia i pa sile na otori isamim matana. ");
INSERT INTO tgp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Vara ka usiusi, ha sopo usiusi sohena tapnetano la lo vaia na ima lotu teni na jingoima vara tamlohi la pa hasohasora matana. Varar̃uhu, na verea isamim, enira la pete lavi na volira moiso. ");
INSERT INTO tgp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pani engko vara ko usiusi o sivo na lolo ima o pelati na matarua, ale o usiusi isan Tamam tea i sopo hiteho. Tamam mo lo hite na sava ko lo vaia hin jara luhu atu, moiso o pa lavi na nom otori matana. ");
INSERT INTO tgp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ale vara ha usiusi ha sopo verevere vono sohena tamlohi r̃or̃oha. La lo r̃omr̃omia vara nora god la pa r̃aramira matan nora reti mo matuvana. ");
INSERT INTO tgp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Matan haratu, ha sopo sohera matan Tamamim mo pete levosahi na nomim opoia moiso ka pa usia isana. ");
INSERT INTO tgp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ale ha usiusi sohen harihi: God Tamamam na tuka, kama opoia vara tamlohi tari la sile na oloolo tavera isam mata engko ko tapu, ");
INSERT INTO tgp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kama opoia vara nom suiha aulu mata supe i pala, o vai na masalom na varama i tataholo sohen ko lo vaia na tuka, ");
INSERT INTO tgp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","o sile kamam na hanhani matan nohorihi, ");
INSERT INTO tgp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","o r̃omi kamam mata nomam hehe, sohen kama lo r̃omi na hehe nona tamlohi tinapua, ");
INSERT INTO tgp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","o lavi nar̃ihi kamam na vaihite, o juri kamam hin Tiapolo. ");
INSERT INTO tgp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Matan vara ha r̃omi na tinapua na nora hehe la vaia isamim, Tamamim na tuka i pa r̃omi kamim mata nomim hehe. ");
INSERT INTO tgp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pani vara ha sopo r̃omi na tinapua, Tamamim i pa sopo r̃omi na nomim hehe. ");
INSERT INTO tgp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Na rani vara ka tapuhoro na hanhani ha sopo vai na nahomim la rara sohena tapnetano la lo vaia. Varar̃uhu, na verea isamim, enira la pete lavi na volira moiso. ");
INSERT INTO tgp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pani vara ko tapuhoro na hanhani, o hoje na nahom, o paspasi na patum hin te makomo wel, ");
INSERT INTO tgp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","matan vara tinapua la pa sopo levosahia vara ko tapuhoro na hanhani mata usiusi, pani matan vara haratu mo sopo tea i er̃i hitea enia Tamam sei, enia hasena i pa hite na sava ko lo vaia na jara luhu, moiso i pa sile na nom otori matana. ");
INSERT INTO tgp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ha sopo takonahi na tavtav na varama, matan pepe peresi r̃aeha la pa komora, ale tamlohi vavanaho la pa kauti na ima la unu vara la vanahora. ");
INSERT INTO tgp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pani ha takonahi na nomim tavtav aulu na tuka matan pepe peresi na r̃aeha la pa sopo er̃i komora, ale tamlohi vavanaho la pa sopo unu la vanahora, ");
INSERT INTO tgp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","matan mapum i pa lo toho tarea na jara nom tavtav mo lo toho ea. ");
INSERT INTO tgp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matam enia mo sohena glas niro matea mata epem. Vara matam mo niro mo r̃uhu, memera i pa mar̃ivisi na epem. ");
INSERT INTO tgp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pani vara matam mo sovsoha, epem tari la pa r̃or̃oha. Vara malarani na lolom mo sopo malarani, pani mo r̃or̃oha, r̃or̃oha atu i pa tavera jea. ");
INSERT INTO tgp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mo sopo tea i er̃i volitusi varar̃uhu isana tamlohi tavera tinapua i rua. I pa opoi matea i jeu haratu matea, teni i pa oloolo hin matea i jeu haratu matea. Ha pa sopo er̃i volitusi isan God na tavalu limam matea, ale na tavaluna tinapua ha volitusi isana mania! ");
INSERT INTO tgp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Na vere kamim hinia vara ha sopo r̃omkaka mata maurimim, ha sopo r̃omkaka vara sava ha pa hania, teni ha pa inu te sava, teni ha pa rua na sava. Sohena sava mauri mo sopo jeu na hanhani, ale epemim mo sopo jeu na ruru? ");
INSERT INTO tgp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ha to kilau sahe na maji avuavu na masapa! La sopo lalavo teni la vu na asitauni. La sopo takonahi na piri na ima piri, pani Tamamim na tuka mo lo kilaura. Sohena sava ka r̃om vara ka sopo r̃uhu jea i jeu na maji avuavu? ");
INSERT INTO tgp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","R̃omkaka, i er̃i vai kamim ha mauri i mele peravu? ");
INSERT INTO tgp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mo sopo r̃uhu vara ha lo r̃omkaka mata nomim ruru. Ha kilau vano sohena sava pa vira jala la lo ulua. La sopo voko vara lakolako na epera. ");
INSERT INTO tgp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pani na verea isamim vara supe Solomon peresi na nona tavtav tari peresi na nona ruru r̃uhu mo lo rura, la sopo r̃uhu sohen te vonara hatea. ");
INSERT INTO tgp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Vara God mo vai na hinau la ulua hasera na jara tavera la r̃uhu jea mata makomo rani purongo, pani pavuho la mate, ale la pulahira na hapu, pani ha lo levosahia, God i pa kilau mamahuni kamim i mele r̃uhu jea i jeu la vira jala sei. Mata sava nomim rasua mo rihirihi purongo? ");
INSERT INTO tgp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ha sopo r̃omkaka vara, ‘r̃a pa hani te sava hinau?’ teni ‘r̃a pa inu na sava?’ teni ‘r̃a pa ru te sava?’ ");
INSERT INTO tgp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Haratu sei la tamlohi r̃or̃oha la lo r̃omkaka matan la hinau tari sei. Tamamim na tuka mo levosahi na hinau tari ka opoira. ");
INSERT INTO tgp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pani ha ale mauri atu God mo aulu hinia tiroma peresi na nona posposi tataholo, ale hinau tari sei la pa nomim. ");
INSERT INTO tgp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ha sopo r̃omkaka matan pavuho, matan pavuho i pa hasena kilaua. Ale rani hatehateahi la pa lavi na nora hina r̃ilangi hasera. ");
INSERT INTO tgp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ha sopo ari na tinapua matan vara God i pa sopo ari kamim. ");
INSERT INTO tgp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Na sava malele ka lo ari na tinapua hinia, la pa ari kamim hinia sohena, vara nomim aria mo puhoni isana tinapua, God i pa vaia sohena isamim. ");
INSERT INTO tgp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ko er̃i hitevosahi na utauta rihirihi na matan voraim, pani mata sava ko sopo er̃i hitevosahi na masunga vipahai na matam? ");
INSERT INTO tgp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Teni o pa er̃i verea isan voraim sohena sava vara, ‘Tapala o tinar̃ihiau a lavi nar̃ihi na utauta rihirihi matea na matam!’ pani ko sopo hitevosahi na masunga vipahai na matam hasem? ");
INSERT INTO tgp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Engko tapnetano, o lavi nar̃ihi na masunga vipahai na matam hasem tiroma, matan vara o pa er̃i kilau i r̃uhu vara o lavi nar̃ihi na utauta rihirihi na matan voraim. ");
INSERT INTO tgp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ha sopo sile na hina tapu non God isana viriu, matan enira la pa posi la hatisatihiho, ale ha sopo sile na nomim hur̃utavila isana poi, matan la pa lo varasihira purongo. ");
INSERT INTO tgp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ha usia, ale la pa silea isamim, ha alea, ale ha pa vileia, ha r̃erengi, ale pelati i pa roi isamim. ");
INSERT INTO tgp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Haratu la usia la pa lavia, haratu la alea la pa vileia, ale la haratu la lo r̃erengi, pelati i pa roi isara. ");
INSERT INTO tgp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Teni te vonamim i pa er̃i sile na vatu isan natuna vara mo usia na pereti? ");
INSERT INTO tgp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Teni te vonamim i pa er̃i sile na mata isan natuna vara mo usia na maji tasi? ");
INSERT INTO tgp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Vara kamim tamlohi hehe ka levosahi na sava otori sei mo r̃uhu vara ha pa silea isana natumim, ka levosahia moiso vara posin Tamamim na tuka mo jeu na posposi tamlohi, ale i pa sile na otori r̃uhu isan la haratu la usia. ");
INSERT INTO tgp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ale matana, ha vaia isana tinapua sohena ka opoia vara la vaia isamim matan harihi mo mar̃ivisi na Leu non God peresi na reti nona pr̃ovet tuai. ");
INSERT INTO tgp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ha unu na matarua rihirihi, matan vao tavera la lo unu na matarua tavera, ale la lo usuri na malele mo tavera sei mo lo vano na talai non God, ale i pa komora. ");
INSERT INTO tgp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pani matarua atu mata unu na malele mata mauri mo rihirihi, malelena mo r̃ilangi, ale tupu visalete purongo la vileia. ");
INSERT INTO tgp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ha lo kilau mata pr̃ovet haluhalu! La pa mai sohena tamlohi tuetueni, pani na lolora la sohen viriu varavarahati matan la pa komo na nomim rasua. ");
INSERT INTO tgp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ha pa er̃i hitevosahira na nora vavahinau. Ha sopo er̃i vu na vua grape na talu kaulu teni vua fig na asi matemate. ");
INSERT INTO tgp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hin malele atu pahai r̃uhu tari la pa sile na vua r̃uhu, pani pahai sati i pa sile na vua sasati. ");
INSERT INTO tgp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pahai r̃uhu i sopo er̃i sile na vua sasati, ale pahai sati i sopo er̃i sile na vua r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pahai tari sei la sile vua sasati la pa taijovira, ale la pulahira na hapu. ");
INSERT INTO tgp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ha pa er̃i hitevosahi na pr̃ovet haluhalu na nora vavahinau. ");
INSERT INTO tgp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mo sopo tamlohi tari sei la lo toviau lara, ‘Moli! Moli!’ la pa lavi mauri atu God mo aulu hinia, pani la haratu purongo sei la lo oloolo hin Tamaku na tuka la pa unu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na rani mata aria, tamlohi matuvana la pa toviau vara, ‘Moli! Moli!’ La pa verea lara, ‘Kama lo retivujavujangi na hijam, ale na hijam kama lo titiu na tanume sasati, ale kama lo vai na hina mar̃urahi matuvana hinia.’ ");
INSERT INTO tgp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pani a pa verea isara vara, ‘Kamim, ka sopo noku tamlohi! Ha malue, kamim ka tamlohi tope na leu!’ ");
INSERT INTO tgp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ale vara tea mo rongo na noku reti, ale mo vaira, mo sohena tamlohi lelevosahi matea sei mo voro na imana na vatu. ");
INSERT INTO tgp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tavara mo jovi, ale wai mo tavei mo mai peresi na langi r̃ilangi la vili ima atu, pani mo sopo jovi matan mo voroa na vatu. ");
INSERT INTO tgp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ale vara tea mo rongo na noku reti, pani mo sopo vaira, mo sohena tamlohi rongorongo vono matea sei mo voro na imana na oneone. ");
INSERT INTO tgp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tavara mo jovi, ale wai mo tavei mo mai peresi na langi r̃ilangi la vili ima atu, ale ima atu mo jovi mo maroe.” ");
INSERT INTO tgp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hin rani atu Iesu mo vere harihi mo isoiso, vao atu la mar̃urahi tavera na nona vujangi, ");
INSERT INTO tgp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","matan mo vujangira sohena tamlohi aulu matea, mo sopo sohena nora tamlohi vujangi mata leu. ");
INSERT INTO tgp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hin rani atu Iesu mo lo sevuti na vutivuti atu, vao tavera jea la lo usuria. ");
INSERT INTO tgp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ale hin rani atu tamlohi lepros matea mo mai mo papaohi isana mo verea mara, “Moli, vara o opoia, o er̃i vaiau a vokevoke na noku rojoa.” ");
INSERT INTO tgp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu mo sohai na limana moiso mo tikelia, ale mo verea mara, “Enau na opoia. O vokevoke!” Vahatea purongo lepros atu mo tihai. ");
INSERT INTO tgp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Moiso Iesu mo verea isana mara, “O sopo vere hinau nike isan tea, pani o vano o hase vujangiho isana pr̃is vara ko mele r̃uhu, ale o sile na hina silesilea sohen Moses mo retileu hinia matan vara tamlohi tari la pa levosahia vara engko ko vokevoke moiso.” ");
INSERT INTO tgp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ale Iesu mo pa lo unu na vanuan Capernaum, captain mata tamlohi vuro matea mo mai isana mo usia r̃ilangi isana, ");
INSERT INTO tgp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","mara, “Moli, o tueniau, noku volitusi mo lo juruvi na ima, epena mo r̃ira, mo lo lavi na rani r̃ilangi tavera.” ");
INSERT INTO tgp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Moiso, Iesu mo verea isana mara, “A pa vano a vai na nona rojoa i tihai!” ");
INSERT INTO tgp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pani captain mata tamlohi vuro atu mo verea mara, “Moli, enau na sopo r̃uhu matan vara o unu na imaku, pani o verea purongo, ale noku volitusi i pa r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Matan enau sohem, na lo toho na ruhuruhu suiha aulu tinapua, ale la sileau na suiha vara a aulu na noku tamlohi vuro, vara a vere isan te hatea vara, ‘O vano!’ ale i pa vano, vara a vere isan te tinapua vara, ‘O mai!’ ale i pa mai, vara a verea isana noku volitusi vara, ‘O vai haranike!’ ale i pa vaia.” ");
INSERT INTO tgp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ale Iesu mara mo rongo hinau sei mo mar̃urahi tavera, ale mo posi mo verea isan vao atu la lo usuria mara, “Varar̃uhu na verea isamim vara na sopo lo tapai te rasua sohen harihi na lolon Israel. ");
INSERT INTO tgp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na verea, tamlohi matuvana na jara tari na varama la sopo Jew, la pa mai la sakele matavuhi na hanhani tavera peresi Abraham, Isaac enia Jacob hin mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pani tatua tahisan Abraham la pa pulahira na r̃or̃oha tavera, la pa tangi, ale la pa nar̃nar̃or̃i na hur̃ura.” ");
INSERT INTO tgp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ale Iesu mo verea isan captain atu mara, “O er̃i vano na imam natu. Ale i pa masese sohen ko rasua.” Vahatea nona volitusi mo mele r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu mo pa lo unu na iman Peter, ale mo hite vepalihan Peter mo lo juruvi na vata mo sereia. ");
INSERT INTO tgp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mo tauri na limana, ale seserei atu mo tihai moiso har̃ai atu mo mele turu mo vai na hanhani hani Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hin ravravi atu, tamlohi la lavi na tamlohi matuvana sei tanume sasati mo unu hinira la mai isan Iesu, ale mo reti purongo, ale nona reti atu mo titiu nar̃ihi na tanume sasati isara, ale mo vai na tamlohi rojo tari la r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ale sava pr̃ovet Isaiah mo verea moiso mo masese sei mara: ‘Mo lavi nar̃ihi na nor̃a rojoa, ale mo vair̃a r̃a r̃uhu.’ ");
INSERT INTO tgp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu mara mo hite na vao tavera atu la lo mai la lo turu porotia, ale mo verea isana nona tamlohi vara la pa usuria la vano roto na tasin Galilee. ");
INSERT INTO tgp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","La sopo lo vano tamlohi vujangi mata leu matea mo mai isana mara, “Tija, a pa usuriho na sava jara o pa vano ea!” ");
INSERT INTO tgp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu mo verea isana mara, “Viriu jala nora jara juruvi la lo toho, ale maji avuavu taura la lo toho, pani Natun Tamlohi mo sopo te jara vara i lo toho ea.” ");
INSERT INTO tgp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nona tamlohi usuri tinapua matea mara, “Tija, a pa mai, pani o tinar̃ihia vara a tavuni tamaku tako.” ");
INSERT INTO tgp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pani Iesu mo verea isana mara, “O usuriau! Haratu la mate la pa tavuni na nora mate!” ");
INSERT INTO tgp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ale Iesu mo pa lo vele hin boti atu, nona tamlohi usuri la usuria, ");
INSERT INTO tgp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ale hin rani atu la vano, ale langi tavera matea mo jovi hin tasi atu, ale mariviti suhusuhu la lo putehi na botira natu, pani Iesu mo lo juruvi, ");
INSERT INTO tgp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ale na nona tamlohi la vano isana la r̃ohaia lara, “Tija! O jurir̃a! R̃a lo pute!” ");
INSERT INTO tgp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pani Iesu mo verea isara mara, “Ka matahu mata sava? Nomim rasua mo rihirihi hajavua!” Ale mo turu mo reti r̃ilangi isana langi peresi tasi atu vara la tamata, ale hinau tari la tamata. ");
INSERT INTO tgp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ale la nona tamlohi atu la mar̃urahi tavera hinia lara, “Sava tamlohi nahai sohena, matan langi peresi na tasi sohena la oloolo hinia?” ");
INSERT INTO tgp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesu mo hoso na tavalu tasi atu mariviti hin jara tavera atu Gadarene, ale hin jara atu tamlohi mo rua tanume sasati la lo toho hinira, la tai na taptap la mai isana. La tupra rua atu enira la putu, ale la lo vaisati na tamlohi, ale la vai na tamlohi la matahu matan vara la lo hahau hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ale vahatea purongo, la ulo lara, “Natun God! Engko te nom sava isamam! Ko mai nakerihi matan vara o sile na talai isamam sei mo sopo lo ranina tataholo?” ");
INSERT INTO tgp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Vao poi tavera matea mo lo toho asau makomona hinira la lo susua, ");
INSERT INTO tgp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ale la tanume sasati atu la usia r̃ilangi isan Iesu lara, “Vara o tiu nar̃ihi kamam, o r̃ule kamam kama unu hin vao poi atuvano!” ");
INSERT INTO tgp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ale Iesu mo verea isara mara, “Ha vano!” Moiso la malue la vano la unu hin vao poi atu, ale vahatea purongo vao poi atu la maro la solesole la jovi na pesapesa atu la pute na tasi. ");
INSERT INTO tgp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Moiso tamlohi kilau na poi atu la maro la vano na taon tavera mariviti hin jara atu la vere na hinau tari la masese hin la tamlohi putu atu tanume sasati la lo toho hinira. ");
INSERT INTO tgp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ale hin rani atu tamlohi tari na nora taon tavera atu la mai vara la tapai Iesu, ale lara la hitea la usia r̃ilangi isana vara i malue na jarara. ");
INSERT INTO tgp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ale Iesu mo mele vele hin boti atu mo hilu mo vano roto na tasi mo hoso mariviti hin taon atu mo lo tohoa ea. ");
INSERT INTO tgp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ale hin rani atu, tamlohi hai la lavi na tamlohi papao matea na epana la mai isana, ale Iesu mara mo hitevosahi na rasua nona tapalan tamlohi papao atu, mo verea isana mara, “Natuku, r̃omim i r̃ilangi! Na r̃omiho mata nom hehe.” ");
INSERT INTO tgp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ale hin rani atu, tamlohi vujangi mata leu hai la lo toho atu la lo hasera r̃omr̃omia na r̃omira lara, “Tamlohi akerihi mo lo vaia sohena enia God.” ");
INSERT INTO tgp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pani Iesu mo levosahi na sava la tamlohi sei la lo r̃omr̃omia, ale mo verea mara, “Ka lo r̃omhehe na mapumim mata sava? ");
INSERT INTO tgp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sahara mo mele malum vara a verea isan tamlohi papao nike? ‘Enau na r̃omiho mata nom hehe!’ Teni vara a verea vara, ‘O turu! O hahau!’ ");
INSERT INTO tgp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pani matan vara ha pa levosahia vara Natun Tamlohi mo lavi na suiha vara i r̃omi na hehe nona tamlohi na varama, ha tapurongo!” Ale Iesu mo verea isan tamlohi papao atu mara, “Na vereho hinia, o turu, o viriviri na epam, ale o mule!” ");
INSERT INTO tgp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ale tamlohi papao atu mo turu mo mule. ");
INSERT INTO tgp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vao tamlohi atu lara la hitea, matahu mo sohonira, ale la tahe na hijan God matan enia mo sile na suiha sohen harihi isana tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu mo pa lo vano, mo hite na tamlohi matea mo lo lavi na mania mata takis mo lo sakele na jara mata voli na takis. Iesu mo verea isana mara, “Eh! O mai o usuriau!” Ale Matthew mo turu, mo usuria. ");
INSERT INTO tgp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hitahu Iesu peresi na nona tamlohi usuri la lo sakele la lo hanhani na iman Matthew, ale hin rani atu tamlohi mata lavi na mania mata takis peresi na tamlohi hehe tinapua matuvana sohera la lo sakele la lo hanhani peresira. ");
INSERT INTO tgp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisee atu lara la hitea, ale la usi na tamlohi usuri non Iesu lara, “Mata sava nomim tija mo lo hanhani matavuhi peresi la haratu la lo lavi na mania mata takis peresi la tamlohi hehe tinapua sei?” ");
INSERT INTO tgp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pani Iesu mara mo rongoa mo verea mara, “Haratu la sopo rojo la sopo opoi na doctor, pani la haratu la rojo la opoia. ");
INSERT INTO tgp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ha vano ha levosahi na r̃aramin Retiulia sei mo verea vara, ‘Na sopo opoi na malamalai, pani na opoia vara ha r̃omopoi na tinapua.’ Enau na sopo mai vara a tovi la haratu la tataholo moiso vara la mai noku tamlohi, pani na mai vara a tovi la haratu la hehe.” ");
INSERT INTO tgp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na rani matea tamlohi usuri non John tamlohi paptijo la mai isan Iesu la usia lara, “Mata sava kamam peresi na Pharisee na rani matuvana kama lo tau na rani mata tapuhoro na hanhani mata usiusi, pani nom tamlohi usuri la sopo tapuhoro na hanhani mata usiusi?” ");
INSERT INTO tgp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu mo r̃aramira mara, “Tavtavui tamlohi i pa lahi la sopo er̃i tapuhoro na hanhani mata usiusi hin rani atu la lo toho peresia. Pani vara nona meresahi la mai la lavi nar̃ihia isara, ale hin rani atu natu la pa tapuhoro na hanhani mata usiusi. ");
INSERT INTO tgp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Te tamlohi i sopo er̃i lavi te tavalu ruru paro hatea i silivi na ruru tuai hinia. Vara i vaia sohena, tavalu ruru paro atu i pa vaia i mar̃ari tavera i jeu haratu tiroma. ");
INSERT INTO tgp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te tamlohi i sopo er̃i titisi na waen paro i sivo na jara waen la vaia na huri nani tuai matan waen paro atu i pa sosohi i r̃ari jara waen atu, ale i pa komoa peresi waen atu matan i pa roro nar̃ihi. Waen paro mo tataholo na jara waen la vaia na huri nani paro purongo matan vara jara waen atu la vaia na huri nani peresi waen atu la pa toho i r̃uhu i tuai.” ");
INSERT INTO tgp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu mo pa lo vere harihi, ale vahatea tamlohi aulu matea mo mai isana, mo papaohi isana mo verea mara, “Venatuku mo mate nakerihi. O mai o tau na limam isana, ale i pa mele mauri.” ");
INSERT INTO tgp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu peresi na nona tamlohi usuri la turu la usuri tamlohi atu. ");
INSERT INTO tgp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","La lo vano, ale vahatea har̃ai matea mo rojo na rojo nona har̃ai tauni mo sangavulu r̃omana mo rua moiso mo mai na har̃ina mo tikeli na revurevu ruru non Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mo lo verea isana hasena mara, “Vara a er̃i tikeli na nona ruru purongo a pa mele r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ale Iesu mo posi isana mo hitea mo verea mara, “R̃omim i r̃ilangi! Nom rasua mo vaiho ko mele r̃uhu.” Ale har̃ai atu mo mele r̃uhu vahatea purongo. ");
INSERT INTO tgp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hin rani atu Iesu mara mo unu na iman pa tamlohi aulu atu, mo hite na tamlohi roro la lo roro na flute peresi na vao la lo tangtangi, ");
INSERT INTO tgp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","mo verea mara, “Ha malue! Har̃arihi sei mo sopo mate! Mo juruvi r̃omaliho purongo!” Tamlohi tari atu la manaluluhi Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pani lara la sohai vao atu la sahe na jingoima moiso, Iesu mo unu mo vano na pahisa vatan har̃arihi atu, mo tauri na limana, ale har̃arihi atu mo turu. ");
INSERT INTO tgp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ale sorasorahina mo vano r̃alihi na jara tari atu. ");
INSERT INTO tgp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Moiso Iesu mo lo malue hin jara atu, ale tamlohi matavuso mo rua la lo usuria la lo ulo lara, “Mahapin Supe David, o r̃omopoi kamam!” ");
INSERT INTO tgp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ale Iesu mara mo unu na ima matea, la matavuso atu la mai isana. Iesu mo usira mara, “Ka rasua vara a pa er̃i vai kamim ha r̃uhu?” La r̃aramia lara, “He'e Moli.” ");
INSERT INTO tgp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ale Iesu mo tikeli na matara mara, “Matan nomim rasua, i pa sohena isamim.” ");
INSERT INTO tgp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ale la matavuso atu la kilau, pani Iesu mo retir̃oar̃oahaira vara la pa sopo mele verea isan tea, ");
INSERT INTO tgp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","pani la malue la lo sorahia isana tamlohi tari sei la tapaira na jara tari atu. ");
INSERT INTO tgp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Iesu peresi na nona tamlohi la pa lo vano, ale vahatea purongo tamlohi hai la lavi na mengo matea mo mai isana mo mengo matan tanume sasati matea mo lo toho hinia. ");
INSERT INTO tgp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ale Iesu mara mo tiu nar̃ihi tanume sasati atu hinia, mengo atu mo retireti. Vao tavera atu la mar̃urahi tavera la lo verea lara, “Mo sopo lo te hinau sohen harihi i malue Israel mo tikeli nake.” ");
INSERT INTO tgp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pani Pharisee la verea lara, “Tamlohi tavera nona tanume sasati mo silea na suiha vara i tiu nar̃ihi na tanume sasati sohen harihi.” ");
INSERT INTO tgp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ale Iesu mo vano mo lo vujangi na nora ima lotu na taon tari peresi na vanua tari atu. Mo retivujavujangi na Retir̃uhu hin mauri atu God mo aulu hinia isara, ale mo vai la haratu la rojo peresi la haratu la majuejue mata rojoa la mele r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hin rani atu Iesu mo hite la vao tamlohi atu, mo r̃omopoira matan r̃omira la jovi la sohena natu mar̃ua. La sohena sipsip mo sopo te tavuira. ");
INSERT INTO tgp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mo verea isana nona tamlohi usuri mara, “Vua asitauni mo tavera jea, pani tamlohi isa la tupu visalete purongo. ");
INSERT INTO tgp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ha usi tamlohi tavera atu sei mo aulu na asitauni vara i r̃ule te tamlohi isa la vano na isana vara la vu na vua asitauni!” ");
INSERT INTO tgp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ale Iesu mo tovi na nona tamlohi usuri mo sangavulu r̃omana mo rua, mo silera na suiha vara la er̃i tiu na tanume lumiha sasati, ale vara la er̃i vai la haratu la rojo peresi la haratu la mar̃emar̃e mata rojoa la sopo mele rojo. ");
INSERT INTO tgp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hija vahar̃ule non Iesu mo sangavulu r̃omana mo rua enira nahai: Simon, haratu la tovia Peter, tasina Andrew, ale James enia John natun Zebedee, ");
INSERT INTO tgp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, Bartholomew, Thomas, Matthew haratu mo lo lavi na mania mata takis, ale James natun Alphaeus, Thaddeus, ");
INSERT INTO tgp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon mara Cana sei, enia tamlohi matea mata valum mata jarana, ale Judas Iscariot, haratu mo lo turuposi hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu mo r̃ule la tupu sangavulu r̃omana mo rua atu, mo retileu mara, “Ha toho asau na jara tamlohi r̃or̃oha, ale ha sopo unu hin te taon non Samaria hatea, ");
INSERT INTO tgp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ha vano isana tamlohin Israel purongo matan enira la sohena vao sipsip natu mar̃ua matea, ");
INSERT INTO tgp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ale ha vano ha retivujavujangi vara suiha atu non God mata supe i pa pala nohorihi. ");
INSERT INTO tgp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ha vai mamahuni la haratu la rojo, ha sauteterahi na mate, ha vai na tamlohi lepros la vokevoke, ha tiu nar̃ihi na tanume sasati, matan ka lavi purongoi na suiha vara ha er̃i vai na hinau, ale ha sopo lavi te volimim matana isan tea. ");
INSERT INTO tgp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ha sopo lavi te mania na nomim tanga korohi, ");
INSERT INTO tgp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ha sopo lavi te tanga mata nomim hahau, teni te ruru teni sabat teni te tihonimim tinapua hatea matan mo tataholo vara tamlohi jara la pa lo kilau kamim tamlohi voko. ");
INSERT INTO tgp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ale vara sava taon teni vanua ka unu hinia, ha usira hinia vara sava tamlohi enia tamlohi la lo r̃omaulu hinia, ale ha pa toho peresia i tikeli rani atu ha mele malue hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Vara ha unu hin te ima, ha sile na nomim ler̃uhu hinira. ");
INSERT INTO tgp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Vara ka avulahi hin ima atu, ha sopo tinar̃ihi na nomim ler̃uhu mata tamata, i pa lo toho isara, pani vara i vono, ha mele lavi nar̃ihi na nomim ler̃uhu mata tamata isara. ");
INSERT INTO tgp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Vara tea mo r̃ohu hin kamim teni vara la sopo tapurongo na nomim retisohai, ha malue hin ima atu teni taon atu, ale ha sar̃sar̃hi nar̃ihi na tangotango palomim isara. ");
INSERT INTO tgp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Varar̃uhu na verea isamim, aria non taon akerihi i pa tavera i jeu na aria non Sodom enia Gomorrah. ");
INSERT INTO tgp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ale nake natu, na lo r̃ule kamim sohena natu sipsip isana vao viriu jala, matan haratu, ha pa tamlohi patuha, ale ha sopo vai te hinau i sati isara. ");
INSERT INTO tgp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ha lo kilau matan tamlohi la pa reve kamim na court, ale la pa tamaji kamim na nora ima lotu. ");
INSERT INTO tgp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","La pa reve tahitahi kamim ha vano isana tamlohi aulu peresi na supe na jara tinatinapua matan vara la pa ari kamim mataku, ale i pa sile na masapa vara ha vereuli na nomim rasua hiniau isana tamlohi r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pani vara tea mo taurilati kamim ha sopo matahu vara ha pa vere na sava, teni ha pa verea sohena sava, matan hin rani atu ha pa lavi na sava retireti ha pa verea, ");
INSERT INTO tgp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","matan i pa sopo kamim ha pa retireti, pani Tanume Tapu sei mo tai isan Tamamim na tuka i pa vere kamim na sava ha pa verea. ");
INSERT INTO tgp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Vorai i pa turuposi hin voraina vara i mate. Tama i pa turuposi hin natuna. Natuvarihi la pa r̃ohu hin tamara peresi na tinara matan vara la taura na mate. ");
INSERT INTO tgp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tamlohi tari la pa tipahi kamim matan ka lo rasuau, pani haratu mo turu r̃ilangi mo tikeli na isoisona i pa juri. ");
INSERT INTO tgp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Vara la tipahi kamim na taon matea ha rovo ha vano na taon tinapua mo mariviti isana. Varar̃uhu na verea isamim, ha pa sopo lo isoiso r̃alihi na taon tari Israel, ale Natun Tamlohi i pa mele mai isamim. ");
INSERT INTO tgp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tamlohi usuri la sopo aulu la jeu na nora tija, ale slev la sopo aulu la jeu na nora tamlohi tavera. ");
INSERT INTO tgp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tamlohi usuri matea i pa avulahi vara i sohen nona tija, ale slev i sohen nona tamlohi tavera. Enau na patu tamlohi tavera mata ima, pani la verea vara patu tamlohi mata ima enia Beelzebul sei supe nona tanume sasati, ha lo levosahia vara la pa retisati hin kamim noku tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ha sopo matahunira. Mo sopo te hina luhu vara i pa sopo malue na jara tavera, ale hina luhu tari la pa pala na jara tavera. ");
INSERT INTO tgp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ha vere na sava na verea isamim na r̃or̃oha ha verea na malarani; ale ha pa retivujavujangi na jara tavera na sava na varavaramasa hinia isamim. ");
INSERT INTO tgp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ha sopo matahuni na tamlohi sei la pa tipahi kamim. La er̃i vilimatei na epemim, pani la pa sopo er̃i komo na maurimim. Pani ha matahuni God, matan enia i er̃i komo na maurimim peresi na tarapemim na moruhapu. ");
INSERT INTO tgp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tamlohi tari la levosahia vara ha er̃i voli te vakarakara i rua na selen matea purongo. Pani mo sopo te hatelete vara i jovi na lepa Tamamim na tuka mo sopo levosahia. ");
INSERT INTO tgp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ale Tamamim mo levosahia vara vulu mo visa la lo toho na patumim. ");
INSERT INTO tgp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Matan haratu, ha sopo matahu. Kamim ka aulu na nahon God ka jeu na vakarakara matuvana. ");
INSERT INTO tgp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ale vara tea i verea na naho tamlohi vara enia noku tamlohi, ale enau sohena a pa verea isan Tamaku na tuka vara enia noku. ");
INSERT INTO tgp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pani vara tea i verea vara mo r̃ohu hiniau na naho tamlohi, a pa verea na nahon Tamaku na tuka vara tamlohi atu mo r̃ohu hiniau. ");
INSERT INTO tgp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ha sopo r̃omr̃omia vara enau na mai na varama vara a sile na tamata. Na sopo mai vara a sile na tamata, pani matan vara a ase na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Matan na mai vara a vai na tamlohi i pa r̃ohu hin tamana, ale venatuna i pa r̃ohu hin tinana, ale narou natirihi i pa r̃ohu hin tinan tuana. ");
INSERT INTO tgp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nomim meresahi la pa tai na lolo vaomim. ");
INSERT INTO tgp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Haratu mo opoi tamana teni tinana teni na natuna peresi na venatun mo jeuau, enia mo sopo tataholo vara i mai noku tamlohi usuri. ");
INSERT INTO tgp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na verea vara te mo sopo soloti na nona talopeilopei i usuriau, enia mo sopo tataholo vara i mai noku tamlohi usuri. ");
INSERT INTO tgp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Vara tea mo opoi na maurina enia i pa vaitihaia, ale vara tea mo r̃ohu na maurina mataku, enia i pa vilei na mauri varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Haratu mo avulahi vara i lavi kamim, enia mo lo laviau, ale haratu mo laviau mo lavi haratu mo lo r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Haratu mo hitevosahi na pr̃ovet matea, ale mo avulahi mo lavia, enia i pa lavi na volina sohena pr̃ovet matea. Haratu mo hitevosahi na tamlohi tataholo matea, ale mo avulahi mo lavia, enia i pa lavi na otori sohen tamlohi tataholo atu. ");
INSERT INTO tgp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ale haratu mo hitevosahi na noku tamlohi usuri matea, ale mo silea na hina rihirihi matea sohena paniken wai hamar̃ir̃i matea isana, varar̃uhu na verea isamim, enia i pa lavi na nona otori matana.” ");
INSERT INTO tgp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu mara mo lo retileu isan la nona tamlohi usuri atu mo sangavulu r̃omana mo rua moiso, mo malue mo vano r̃alihi na nora taon tavera la lo toho hin jara atu vara i vujangira ale i retivujavujangira. ");
INSERT INTO tgp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John mo lo toho na ima r̃ilangi, ale mara mo rongo na sava Kr̃isto mo lo vaira, mo r̃ule na nona tamlohi usuri hai isana, ");
INSERT INTO tgp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","vara la usia isana lara, “Engko sei natu, haratu sei kama pa lo kilau matana, haratu sei God i pa r̃ulea i sinai? Teni kama pa mele saovi matan te mele tinapua?” ");
INSERT INTO tgp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu mo r̃aramira mara, “Ha vano ha vere John na sava ka rongoa, ale ka hitea. ");
INSERT INTO tgp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nake, matavuso la kilau, ale tamlohi papao la hahau, haratu lepros mo hatira la mele vokevoke, peropero la rongo, haratu la mate la turu na mauri, ale tilavono la lo rongo na Retir̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Vara la haratu la sopo r̃omrua hiniau, la pa avulahi tavera.” ");
INSERT INTO tgp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ale la tamlohi atu la pa lo tapulo malue, ale Iesu mo sorahi John isan vao atu mara, “Hin rani atu ka lo vano vara ha hite John, ka vano hin urata hasetoho atu vara ha hite te hinau sohena talu ere sei mo sopo r̃ilangi, ale langi mo serea mo lo hisuhisu teni mata sava? ");
INSERT INTO tgp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Sava tamlohi natu, ka vano vara ha hitea? Ka hite tamlohi atu mo ru te ruru r̃uhu? Ka levosahia vara tamlohi sei la lo ru na ruru sohen haratu enira la tamlohi tavtav purongo sei la lo toho na ima supe. ");
INSERT INTO tgp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ka lo vano vara ha hite na sava? Te pr̃ovet matea? Varar̃uhu enia pr̃ovet matea, enjora, pani mo jeu na pr̃ovet, ");
INSERT INTO tgp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Retiulia mo retireti hin John mara, ‘O lo levosahia vara, a pa r̃ule na noku vahar̃ule matea i tiroma hiniho vara i tatamahuni na hinau matam.’ ");
INSERT INTO tgp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Varar̃uhu na verea isamim, mo sopo lo tea i vora hin varama nike i jeu John tamlohi paptijo. Pani haratu enia tamlohi purongo hin la haratu la lavi mauri atu God mo aulu hinia, enia i pa aulu i jeu John na pongi hitahu. ");
INSERT INTO tgp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mo tapulo na rani non John tamlohi paptijo mo tikeli nake, tamlohi hai la lo opoia vara la tauri na suiha vara la aulu, ale vara la vere na masalon God vara mo vano sohena sava hin varama nike, ale tamlohi sasahati sohena la lo vaihitea vara la taurilati suiha atu, ");
INSERT INTO tgp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","matan pr̃ovet tari peresi na Leu non Moses la lo retimangovi tuai moiso mo tikeli na rani non John. Vara ha evia ha pa levosahia vara i pa pala sohena sava. ");
INSERT INTO tgp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ale vara ka avulahi vara ha rasua, John enia Elijah, pr̃ovet atu ka lo kilau matana, ");
INSERT INTO tgp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","haratu mo er̃i rongovosahia, o tapurongo! ");
INSERT INTO tgp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kamim nakerihi ka sohena natuvarihi sei la lo vai na roro na jara maket, ale la lo uloulo isara lara, ");
INSERT INTO tgp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kama roro na pue tangtangi, pani ka sopo velu! Kama lavi na vete mata r̃omi na tamlohi mate, pani ka sopo tangtangi!’ ");
INSERT INTO tgp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Na vere harihi matan John tamlohi paptijo mo sopo vano r̃alihi vara i lo hanhani teni i lo inuinu peresi na tamlohi, pani ka vara, ‘Tamlohi sei tanume sasati matea mo lo toho hinia!’ ");
INSERT INTO tgp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ale Natun Tamlohi mo lo hahau r̃alihi mo lo hanhani mo lo inu peresi na tamlohi, ale ka vara, ‘Tamlohi sei mo lo hanhani, ale mo lo inu hajavua. Enia tapala tamlohi la lo lavi na mania mata takis peresi la haratu la hehe.’ Vara ha sopo er̃i hitevosahi na lelevosahi kama lo vaia nake, ha pa er̃i hitevosahia na vuana hitahu.” ");
INSERT INTO tgp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ale Iesu mo tapulo hapuhi la taon atu sei mo lo vai na hina mar̃urahi tavera hinira matan tamlohi hinira la r̃ohu vara la tinar̃ihi na nora hehe la mai isan God, Iesu mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kamim tamlohin Chorazin, ha pa lavi na talai sasati tavera, ale kamim tamlohin Bethsaida sohena, ha pa lavi na talai sasati tavera! Matan, vara la hina mar̃urahi nike na vaira isamim na nomim taon la pa lo malue na taon non Tyre peresi Sidon, tamlohira la pete posi tuai moiso la vano isan God, ale la vujangia hin posposi matan tuai sei, la lo ru na parat paki, ale la tau na patmakovi na patura. ");
INSERT INTO tgp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pani na verea isamim, na rani mata aria tamlohin Tyre enia Sidon la pa malue i malum i jeu kamim. ");
INSERT INTO tgp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ale kamim tamlohin Capernaum ka r̃omi vara God i pa tahe kamim ha tikeli na tuka? Mo vono, ha pa sivo atano na varama mata mateia! Vara la hina mar̃urahi atu sei la lo malue na nomim taon la pa lo malue na taon non Sodom, nake taon atu mo pa lo turu! ");
INSERT INTO tgp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pani na verea isamim, na rani mata aria tamlohin Sodom la pa malue i malum i jeu kamim.” ");
INSERT INTO tgp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ale hin rani atu Iesu mo verea mara, “Enau na hasohasoho, Tamaku, Moli non tuka peresi na varama, matan ko jarohi la hinau tari nike isana tamlohi lelevosahi mata varama peresi na tamlohi la lavi na lelevosahi mata varama, pani ko vujangia isana tamlohi purongo. ");
INSERT INTO tgp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","He'e Tamaku, matan harihi mo lo usuri na nom masalo r̃omr̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tamaku mo sileau na hinau tari, ale mo sopo tea, pani enia hasena purongo mo levosahi Natuna. Ale haratu purongo mo levosahi Tama, enia Natuna peresi la haratu Natuna mo opoia vara i vujangia isara. ");
INSERT INTO tgp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Vara ka malokoloko matan nomim tetehi mo puhoni hajavua, ha mai isaku, ale a pa tueni kamim, ha pa lavi na mapu varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ha lavi na noku vujangi, ha lavia na maurimim, ale ha levosahi na malele isaku. Enau na malum, enau na r̃omatano, ale ha pa lavi na mapu varar̃uhu isaku. ");
INSERT INTO tgp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noku vujangi mo sopo puhoni, noku vavahinau mo salesale purongo.” ");
INSERT INTO tgp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na rani mata Sabbath matea, Iesu mo lo hahau roto te isa wit. Ale nona tamlohi usuri la lo tapulo vesi roto na wit, ale la lo hanira. ");
INSERT INTO tgp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pani Pharisee lara la hitera, la verea isan Iesu lara, “O to kilau vano, nom tamlohi usuri la lo vai na hinau matea mo sopo tataholo vara la vaia na Sabbath.” ");
INSERT INTO tgp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu mo verea isara mara, “Korong ka sopo lo evi na sava David peresi la haratu la lo toho peresia la vaia na rani la marohati. ");
INSERT INTO tgp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ale sohena sava mo unu hin ima ruru atu la lo lotu God ea, ale mo hani na pereti sei mo sopo tataholo vara enia teni nona tamlohi vara la hania matan enia mata pr̃is hasera? ");
INSERT INTO tgp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Teni korong ka sopo lo evi na Leu sohena sava na rani Sabbath, na lolo ima lotu, pr̃is na Temple la lo tope na Sabbath matan la sopo mapu matan la lo vai mamahuni na nora vavahinau, pani la pa sopo ori matana? ");
INSERT INTO tgp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na verea isamim, matea mo lo toho peresi kamim mo tavera jea na Temple. ");
INSERT INTO tgp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ale vara ha pa lo levosahi na r̃aramin hinau sei, ‘Na opoi na posposi r̃omopoi, mo sopo malamalai!’ Ha pa sopo ari la haratu la sopo ori. ");
INSERT INTO tgp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Matan Natun Tamlohi enia Moli mata Sabbath.” ");
INSERT INTO tgp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mo malue hin jara atu mo vano mo unu na nora ima lotu ea. ");
INSERT INTO tgp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ale tamlohi matea mo lo toho atu limana mo kuti. Ale la tamlohi atu la usia isana lara, “O pa tope na leu vara o vai mamahuni te tinapua na Sabbath teni mo vono?” La usia sohena matan vara la pa tuvaia hinia. ");
INSERT INTO tgp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu mo verea isara mara, “Hare vonamim matea pulana sipsip matea mo jovi hin te koko na Sabbath, i pa sopo tauria i sau nar̃ihia? ");
INSERT INTO tgp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka levosahia vara tamlohi mo aulu jea mo jeu na sipsip. Ale matana, mo r̃uhu vara r̃a vai na hina r̃uhu na Sabbath.” ");
INSERT INTO tgp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Moiso, mo verea isan tamlohi atu mara, “O r̃irahi na limam.” Ale tamlohi atu mo r̃irahia, ale mo r̃uhu sohena tapala limana. ");
INSERT INTO tgp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pani Pharisee la malue atu la matavuhi na jara matea vara la aleale malele matan vara la pa vilimatei Iesu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pani Iesu mo levosahi na sava la lo vaia, ale mo malue hin jara atu. Vao tavera la usuria, ale mo vai mamahuni vevuhira na nora rojoa, ");
INSERT INTO tgp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ale mo retileu vara la sopo vereuli na sava nakonako mo lo vaira. ");
INSERT INTO tgp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Harihi, enia matan vara reti sei pr̃ovet Isaiah mo verea vara la pa masese mara, ");
INSERT INTO tgp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘O kilau vano! Noku volitusi sei enia noku vir̃oni, enia haratu na opoi jea sei mapuku mo avulahi tavera hinia. A pa tau na Tanumeku hinia, ale enia i pa vereuli na noku posposi tataholo isana tamlohi r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I pa sopo vas teni i ulo r̃ilangi, teni la pa sopo rongo na leona vara i lo hase tahea na malele tavera. ");
INSERT INTO tgp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Enia i pa malum, i pa sopo kame te ere sei mo mahope moiso, teni i pa sopo vuni te vara kandeli, i tikeli pongi atu vara i pa vaitataholoi na hinau tari, ");
INSERT INTO tgp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ale tamlohi r̃or̃oha tinatinapu tari la pa lo r̃omtoho na hijana.’ ");
INSERT INTO tgp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Moiso, tamlohi hai la lavi na tamlohi matea tanume sasati matea mo unu hinia mo vaia mo matavuso mo mengo, ale la lavia mo mai isana, ale mo vai mamahunia vara i er̃i retireti, ale mo er̃i kilau. ");
INSERT INTO tgp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Moiso tamlohi tari la mar̃urahi tavera hinia lara, “Korong haranike natu, enia mahapin David sei, haratu God mo vir̃onia mata jurir̃a teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pani Pharisee lara la rongoa lara, “Tamlohi akerihi mo lo titiu nar̃ihi na tanume sasati na liman Beelzebul, supe nona tanume sasati tari!” ");
INSERT INTO tgp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Matan Iesu mo levosahi na r̃omira mo verea isara mara, “Vara na lolo jara matea supe la lo aseasehira hinia, i pa maroe, ale i pa sopo te taon tavera teni te vao ima vara i lo aseasehia hasena i pa er̃i turu. ");
INSERT INTO tgp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ale vara Setan mo lo titiu nar̃ihi na tanume sasati, enia mo lo aseasehia hasena. Ale jara atu mo lo tauri na suiha hinia i pa turu sohena sava? ");
INSERT INTO tgp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ale vara enau na lo titiu nar̃ihi na tanume sasati na suihan Beelzebul, ale na suihan hare natu te nomim tamlohi usuri la lo titiu nar̃ihira hinia? Matan mo sohena, enira la pa ari kamim. ");
INSERT INTO tgp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pani matan enau na lo titiu nar̃ihi na tanume sasati na suihan Tanumen God, ale mo r̃aramia vara suiha atu non God mata supe mo pete pala isamim moiso. ");
INSERT INTO tgp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ale sohena sava natu, tea i er̃i unu na iman te tamlohi suiha hatea vara i vanaho te nona hinahinau hinia, pani vara mo sopo liholatia tiroma? Ale vara i liholatia i pa er̃i tivesi vevuhi na imana. ");
INSERT INTO tgp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Haratu mo sopo turu peresiau, enia mo lo hasena vaia mo meresahi isaku, ale haratu mo sopo reve takonahi na tamlohi peresiau, enia mo lo levuti jalajalaira. ");
INSERT INTO tgp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Matana, na lo verea isamim vara hehe tari peresi na reti sati hin God tari, God i pa r̃omira, pani vara tea mo vere lejileji na Tanumena vara enia Tiapolo sohen ka lo vaia, God i pa sopo er̃i r̃omia. ");
INSERT INTO tgp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ale haratu mo lo vere lejileji Natun Tamlohi, God i pa r̃omia, pani haratu mo lo vere lejileji Tanume Tapu, enia, God i pa sopo er̃i r̃omia nake teni hin na pongi mo lo mai. ");
INSERT INTO tgp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Vipahai matea o er̃i hite usuria na namana, o vai vipahai atu i r̃uhu, namana i pa r̃uhu, o vai vipahai atu i sati, namana la pa sasati. ");
INSERT INTO tgp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kamim natu mata sasati! Ha pa er̃i vere te hinau r̃uhu sohena sava matan kamim ka sasati, matan sava ka lo verea mo vujangi na sava mo lo toho na mapumim. ");
INSERT INTO tgp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tamlohi r̃uhu matea mo pa lo vai na hina r̃uhu mata nona posposi r̃uhur̃uhu, ale tamlohi sasati matea mo pa lo vai na hina sati mata nona posposi sasati. ");
INSERT INTO tgp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na verea isamim, na rani tavera mata aria, tamlohi tari la pa r̃arami na nora reti rongorongo vono tari sei la verera moiso, ");
INSERT INTO tgp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","matan sava retireti ka verera, la pa vujangia vara ka tataholo na nahon God, ale matan sava retireti ka verera, la pa vujangia vara ka hehe na nahon God.” ");
INSERT INTO tgp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Moiso tatua tamlohi vujangi mata leu peresi na Pharisee, la r̃aramia lara, “Tija, kama opoia vara kama hite te matamata mar̃urahi isam!” ");
INSERT INTO tgp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pani Iesu mo r̃aramira mara, “Tamlohi nake, enira tamlohi sasati, la vaivaileu peresi na tinapua mo lahi moiso, la lo ale na matamata, pani matamata atu a pa silea isara enia sohen matamata atu God mo vaia hin pr̃ovet Jonah. ");
INSERT INTO tgp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sohen Jonah mo lo toho na lolo pangen maji tavera atu rani mo tolu peresi na vutepongi mo tolu, enau sohena, Natun Tamlohi, a pa toho na lolo lepa mata rani i tolu peresi na vutepongi i tolu. ");
INSERT INTO tgp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mara Nineveh la pa sauteterahi na rani aria tavera peresi pina nike, ale la pa verea vara mo hehe, matan enira la posi na maurira mata retivujavujangi non Jonah, pani ka levosahia, matea mo aulu jea hin Jonah mo lo toho nike, pani ka sopo rasua. ");
INSERT INTO tgp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Vesupe matan Sheba i pa sauteterahi na rani aria tavera peresi pina nike, ale i pa sile na talai isana, matan enia mo mai na jara asau na varama vara i tapurongo na reti lelevosahi non Solomon, ale nake matea mo aulu mo jeu Solomon mo lo toho nike. ");
INSERT INTO tgp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Hin rani atu vara te tanume lumiha mo malue hin te tamlohi, mo lo vano roto na jara mamasa vara i vilei te jara mapu, pani mara mo sopo vilei tea, ");
INSERT INTO tgp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mo verea mara, ‘A pa mele hilu, a vano na ima na tai ea’. Ale mara mo pala mo tapai ima atu mo vuruvuru, mo hitea vara la tivesia, ale la tau tataholoi na hinau tari na jarara. ");
INSERT INTO tgp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ale nake, mo vano vara i lavi na tanume lumiha tupu limaravrua tinapua sei la mele sati la jeua. La mai, ale la unu, la lo toho atu. Na lo verea vara i pa sati jea isan tamlohi atu i jeu tiroma. Ale i pa sohen haratu isan pina sasati nike, sei la lo r̃ohu hiniau!” ");
INSERT INTO tgp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mara mo pa lo retireti isana tamlohi, ale vahatea purongo, tinana peresi na tasina la lo turu na jingo ima, la lo usia vara la er̃i retireti peresia, ");
INSERT INTO tgp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ale tea mo verea isana mara, “O kilau vano sevano, tinam peresi na tasim la turu na jingo ima, la opoia vara la retireti peresiho.” ");
INSERT INTO tgp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pani Iesu mo r̃arami tamlohi atu mara, “Hare natu, enia tinaku? Ale hare natu, enia tasiku?” ");
INSERT INTO tgp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mo r̃irahi na limana mo vano tataholo isana nona tamlohi usuri mo verea mara, “La haranike, enira tinaku peresi na tasiku! ");
INSERT INTO tgp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Matan hare mo lo vai na masalon Tamaku na tuka enia tasiku, vetasiku, ale tinaku.” ");
INSERT INTO tgp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hitahu hin rani atu, Iesu mo malue na ima, ale mo sivo mo sakele na pahisa tasi. ");
INSERT INTO tgp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ale matan vao tavera la mai la lo turu porotia, Iesu mo vele na boti matea mo sakele hinia, ale vao tari sei la lo turu na oneone. ");
INSERT INTO tgp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Moiso mo verera na hinau matuvana na titileu mara, “Tamlohi hapor̃ahi matea mo vano vara i hapor̃ahi te piri. ");
INSERT INTO tgp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mo pa lo hapor̃ahi na piri, tatuara la jovi na malele, ale maji avuavu la mai la hani vevuhira. ");
INSERT INTO tgp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tatua piri la jovi na vatuvatu, lepa mo tavinvin purongo, ale la tuvu vahatea matan mo tavinvin, ");
INSERT INTO tgp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pani alo mara mo vele mo sulira, ale la mahoa matan la sopo wariha. ");
INSERT INTO tgp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tatua piri tinapua la jovi na livuha vipahai ngar̃ngar̃iha, ale la vipahai ngar̃ngar̃iha atu la ulua la punira. ");
INSERT INTO tgp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tatua piri tinapua la jovi na lepa r̃uhu la namaha, hai la tikeli vaha ngavu sangavulu hai vaha ngavulu limarave hai vaha ngavulu tolu hin haratu mo lo hapor̃ahira tiroma. ");
INSERT INTO tgp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Haratu mo peroha i tapurongo!” ");
INSERT INTO tgp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nona tamlohi usuri la mai la verea isana lara, “Mata sava ko lo retireti na titileu isara?” ");
INSERT INTO tgp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Moiso mo r̃aramira mara, “Isamim God mo majinga vara ha pa levosahi na hina luhu matan mauri atu God mo aulu hinia, pani isara, mo sopo majinga. ");
INSERT INTO tgp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Matan isan haratu mo lavi te lelevosahi na mapuna, God i pa sile na lelevosahi i lo masurere isana, pani isan haratu mo sopo te lelevosahi na mapuna, sava hinau mo rongoa, i pa tihai. ");
INSERT INTO tgp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na lo retireti na titileu isara matan harihi, matan la lo hitea, pani la pa sopo rongovosahia, la lo rongoa, pani la pa peropero, ale la pa sopo levosahia. ");
INSERT INTO tgp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Varar̃uhu, sava Isaiah mo reti mangovia hinia moiso mo masese hinira vara, ‘Ha pa rongoa, pani ha pa sopo er̃i levosahia, ale ha pa hitea, pani ha pa sopo er̃i rongovosahia. ");
INSERT INTO tgp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Matan mapura la mai la praprasa, perora la peroputu, ale matara la pelati, matan vara la pa sopo hite na matara, teni rongo na perora, ale la rongovosahi na mapura matan vara la er̃i posi la mai isaku matan vara a vai mamahuni na mapura na nora rojoa.’ ");
INSERT INTO tgp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pani la matamim sei, la avulahi tavera mata sava la er̃i hitea, ale peromim la er̃i rongovosahi na sava la lo rongoa. ");
INSERT INTO tgp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Varar̃uhu na verea isamim, tuai pr̃ovet matuvana peresi na tamlohi tataholo la opoia vara la er̃i hite na sava ka lo hitea, pani la sopo hitea, ale vara la rongo na sava ka lo rongoa, pani la sopo rongoa. ");
INSERT INTO tgp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ha tapurongo na r̃arami titileu matan tamlohi hapor̃ahi atu: ");
INSERT INTO tgp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vara tea mo rongo na reti matan mauri atu God mo aulu hinia, pani mapuna mo sopo levosahia, ale Tiapolo mo mai mo reve nar̃ihi na sava mo lavoa na mapuna. Haranike enia piri sei mo lavoa na malele. ");
INSERT INTO tgp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hin haratu mo lavoa na lepa r̃ilangi, haranike enia haratu sei mo rongo na Retir̃uhu, ale vahatea purongo mo lavia na avulahi, ");
INSERT INTO tgp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pani matan mo sopo te nona jara turu, mo turu makomona purongo, ale vara rani r̃ilangi mo mai teni la tipahia mata Retir̃uhu, vahatea purongo i pa rovo na nona rasua. ");
INSERT INTO tgp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Hin haratu mo lavoa na livuha vipahai ngar̃ngar̃iha, enia haratu mo rongo na Retir̃uhu, pani masalo mauri peresi na r̃omr̃omi tavtav mo turuhoro na Retir̃uhu, ale mo sopo namaha. ");
INSERT INTO tgp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pani hin haratu mo hapor̃ahia na lepa r̃uhu, enia haratu mo rongo na Retir̃uhu, ale mo rongovosahia. Enia mo namaha mo tavera, hin tea i pa tikeli vaha ngavu sangavulu hai mo tikeli vaha ngavulu limarave ale hai mo tikeli vaha ngavulu tolu hin haratu mo lo lavoa.” ");
INSERT INTO tgp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mo mele verera na titileu tinapua matea mara, “Mauri atu God mo aulu hinia, mo sohena tamlohi matea mo lo hapor̃ahi na piri r̃uhu na lolo isana, ");
INSERT INTO tgp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","pani na rani nona tamlohi voko la juruvi r̃omaliho, nona meresahi mo mai mo hapor̃ahi na piri r̃uvu hin isa wit atu moiso mo mele r̃ovo. ");
INSERT INTO tgp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ale lara la tuvu, ale la namaha r̃uvu sohena la pala. ");
INSERT INTO tgp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Moiso volitusi non tamlohi tavera mata ima la mai isana lara, ‘Tamlohi tavera, avei, kama r̃om vara ko hapor̃ahi na piri r̃uhu purongo na isam, pani sohena sava natu, r̃uvu la tuvu hinia?’ ");
INSERT INTO tgp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ale mo verea isara mara, ‘Noku meresahi matea mo vai hinau sei.’ Ale nona volitusi lara, ‘Ale ko opoia vara kama vano kama saputira?’ ");
INSERT INTO tgp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pani mo verea mara, ‘Mo vono! Mo sopo r̃uhu vara ha saputira matan ha pa er̃i saputi na wit peresira. ");
INSERT INTO tgp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ha tinar̃ihira la ulua jara matea vavano i tikeli na rani asitauni. Na rani asitauni a pa vere na tamlohi asitauni vara la saputi na r̃uvu tiroma, ale la otira matan vara la pa sulira, pani la pa takonahi na wit na noku ima wit.’” ");
INSERT INTO tgp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mo mele vere na titileu tinapua matea isara mara, “Mauri atu God mo aulu hinia mo sohena piri paka matea sei tamlohi matea mo lavia mo hapor̃ahi na isana. ");
INSERT INTO tgp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Piri atu enia mo rihirihi mo jeu na piri tari, pani vara mo ulua, mo mai mo tavera mo jeu na vipahai tari, ale maji avuavu na masapa la mai la vai na taura na rangarangana.” ");
INSERT INTO tgp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mo mele vere na titileu tinapua matea isara mara, “Mauri atu God mo aulu hinia mo sohena isi sei har̃ai matea mo lavia, ale mo hoia na flaua vavano isi sei mo vaia mo sohi.” ");
INSERT INTO tgp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Hinau tari nike, Iesu mo verea isan vao atu na titileu: varar̃uhu, mo sopo vere te hinau hatea isara vara mo sopo verea na titileu. ");
INSERT INTO tgp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Harihi mo mar̃ivisi na sava pr̃ovet la verea tuai sei vara, ‘A pa vujangi na tamlohi na titileu, a pa vereuli na sava la luhu na tapulo varama mo tikeli nake.’ ");
INSERT INTO tgp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ale mo malue hin vao atu mo unu na ima. Moiso nona tamlohi usuri la mai isana lara, “O to vere mamahuni kamam na titileu mata r̃uvu hin isa atu.” ");
INSERT INTO tgp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu mo r̃aramira mara, “Haratu mo lo hapor̃ahi na piri r̃uhu enia Natun Tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Isa sei enia varama, moiso piri r̃uhu enia la haratu sei la lavi mauri atu God mo aulu hinia, ale r̃uvu atu enia la haratu sei la tamlohi non haratu mo sasati, ");
INSERT INTO tgp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ale meresahi atu mo lo hapor̃ahira, enia Tiapolo. Asitauni enia pongi hitahu, ale tamlohi asitauni enira angelo. ");
INSERT INTO tgp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sohena la saputi na r̃uvu, ale la sulira na hapu, i pa sohena na pongi hitahu. ");
INSERT INTO tgp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Natun Tamlohi i pa r̃ule na nona angelo, ale la pa lavi nar̃ihi na hinau tari sei la lo vai na tamlohi la hehe peresi la haratu tarea la lo tope na leu na lolo jara sei enia mo aulu hinia, ");
INSERT INTO tgp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ale la pa pulahira la sulira hin jara atu mata hapu. Hin jara atu, la pa tangi, ale la pa ngar̃ngar̃ori na hur̃ura na rongohaji tavera. ");
INSERT INTO tgp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Moiso haratu la tataholo la pa mera sohena alo hin mauri atu na suihan Tamara. Haratu la peroha, ha tapurongo! ");
INSERT INTO tgp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mauri atu God mo aulu hinia mo sohena tavtav tavera matea, tamlohi matea mo jarohia na lepa matea, ale tamlohi tinapua matea mo tapaia, ale mo mele tavuhoroa. Moiso mo avulahi tavera, mo vano mo har̃ehi vevuhi na nona hinahinau matan vara i er̃i voli lepa atu. ");
INSERT INTO tgp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ale mele vahatea, mauri atu God mo aulu hinia mo sohena tamlohi ar̃ear̃ehi matea mo lo aleale hur̃utavila r̃uhu, ");
INSERT INTO tgp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ale enia mo vilei na hur̃utavila matea mo r̃uhur̃uhu jea, mo vano mo har̃ehi vevuhi na nona hinahinau, ale mo volia nona. ");
INSERT INTO tgp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ale mele vahatea, mauri atu God mo aulu hinia mo sohena tara sei la pulahia na tasi, ale maji tinatinapua tari la kali hinia. ");
INSERT INTO tgp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mara mo mar̃ivi, tamlohi la reve hosohia, ale la sakele la vir̃oni nar̃ihi na hina r̃uhu la sohonira na tanga, pani haratu la sati la pulahira. ");
INSERT INTO tgp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","I pa sohena na pongi hitahu. Angelo la pa mai la asehi la haratu la sasati hin la haratu la tataholo, ");
INSERT INTO tgp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ale la pa pulahira na jara mata hapu. Hin jara atu, la pa tangi, ale la pa hatihati na hur̃ura. ");
INSERT INTO tgp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ka lo rongovosahi la hinau sei?” La r̃aramia lara, “He'e.” ");
INSERT INTO tgp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ale mo verea isara mara, “Ale matana, tamlohi vujangi mata leu tari sei la lavi na lelevosahi mata usuri mauri atu God mo aulu hinia, enira la pa sohena tamlohi tavera mata ima matea sei mo lavi nar̃ihi na nona tavtav vara i vujangira isana tamlohi, hina paro peresi na hina tuai.” ");
INSERT INTO tgp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu mara mo isoiso hin la titileu atu, mo malue hin jara atu, ");
INSERT INTO tgp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","mo mai na jarana mo vujangira na nora ima lotu, ale la mar̃urahi hinia lara, “Tamlohi nike, mo lavi na nona lelevosahi epu, mo pa lavi na suiha vara i vai na hina r̃uhur̃uhu epu? ");
INSERT INTO tgp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pani enia mo sopo natun tamlohi tapatu atu? Ale tinana la tovia Mary, ale tasina sei, James, Joseph, Simon peresi Judas. ");
INSERT INTO tgp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ale vetasina tari la lo toho peresir̃a nike, sava jara natu, tamlohi nike mo pa lavi na suiha vara i vai la hinau sei hinia?” ");
INSERT INTO tgp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ale la lo r̃ohu hinia, pani Iesu mo verea isara mara, “Pr̃ovet matea i pa sopo er̃i lavi na oloolo na jarana teni na lolo imana.” ");
INSERT INTO tgp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ale mo sopo vai te hina r̃uhur̃uhu matuvana ea matan la sopo rasua. ");
INSERT INTO tgp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hin rani atu supe rihirihi Herod, mo rongo na roroan Iesu, ");
INSERT INTO tgp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ale mo verea isana nona volitusi mara, “Haranike enia John tamlohi paptijo sei! Enia mo mele sauteterahi na mateia, ale mo er̃i vai la hina mar̃urahi sei matana.” ");
INSERT INTO tgp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Matan Herod natu, mo tauri John, ale mo pesia, ale mo taua na ima r̃ilangi matan narouna Herodias, naroun tasina Philip, ");
INSERT INTO tgp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","matan John mo lo verea isana mara, “Mo sopo tataholo vara o lavia naroum.” ");
INSERT INTO tgp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hina purongo vara mo opoia vara i vilimateia, mo matahuni na tamlohi matan enira la rasua vara John enia pr̃ovet matea. ");
INSERT INTO tgp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pani na rani pongi vora non Herod mo mai, venatun Herodias mo velu na naho vao ea mo vai Herod mo avulahi tavera, ");
INSERT INTO tgp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","matana, enia mo vai na retitauhi r̃ilangi matea vara i pa silea na sava hinau mo usia isana. ");
INSERT INTO tgp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tinan har̃arihi atu mo retireti patuna, ale har̃arihi atu mo verea mara, “O sileau na patun John tamlohi paptijo na pusa peleti.” ");
INSERT INTO tgp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Supe Herod mo rongo mo sati, pani matan nona retitauhi na naho vao, mo retileu vara la vaia. ");
INSERT INTO tgp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mo r̃ule na nona tamlohi la tai roto na r̃alon John na ima r̃ilangi, ");
INSERT INTO tgp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ale la lavi na patuna na peleti matea la silea isan har̃arihi atu, ale mo lavia vano isan tinana. ");
INSERT INTO tgp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tamlohi usuri non John la mai la lavi na tarapena, ale la tavunia, ale la vano la verea isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu mara mo rongoa, mo malue mo vano mo vele na boti matea, mo vano na jara hasetoho matea vara i lo toho hasena. Pani na rani vao tamlohi lara la rongoa la malue na vanuara la hahau alea. ");
INSERT INTO tgp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mara mo sahe na jarauta, mo hite na vao tavera matea, ale mo r̃omopoira, ale mo vai mamahuni na nora tamlohi rojoa. ");
INSERT INTO tgp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ale mo lo ravravi nona tamlohi usuri la mai isana la verea lara, “Jara nike, enia jara hasetoho matea, ale pongi mo lo mai. O r̃ule vao sei la vano hin te vanua vara la voli te hara hinau matara hasera.” ");
INSERT INTO tgp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pani Iesu mo verea mara, “Mo vono, la lo toho, kamim ha vahanira.” ");
INSERT INTO tgp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","La verea isana lara, “Kama lo lavi na pereti mo lima purongo peresi na maji mo rua.” ");
INSERT INTO tgp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ale mo verea isara mara, “Ha lavira la mai isaku.” ");
INSERT INTO tgp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ale mo retileu isan la vao atu vara la sakele na r̃uvur̃uvu, ale mo lavi la pereti atu mo lima peresi la maji atu mo rua, mo tar̃a sahe aulu na tuka mo hasohaso God, ale mo vere meje matara, ale mo tope la pereti atu mo silea isana nona tamlohi usuri, ale nona tamlohi usuri la silea isan la vao atu. ");
INSERT INTO tgp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tamlohi tari la hanhani la masu. La sohoni na sope hanhani na tanga mo sangavulu r̃omana mo rua la mar̃ivi. ");
INSERT INTO tgp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ale la haratu la lo hanhani enira mariviti i tikeli tari vaha lima haratu la sopo evi na har̃ai peresi na natuvarihi. ");
INSERT INTO tgp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Vahatea purongo, mo aji na nona tamlohi usuri vara la vano tiroma hinia na tavul tasi, ale mo r̃ule vao atu la vano karahi. ");
INSERT INTO tgp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ale Iesu mara mo r̃ule vao atu la vano moiso, mo vele sahe na vutivuti matan vara i usiusi enia hasena. Ravravi mo mai enia hasena mo lo toho atu, ");
INSERT INTO tgp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","pani botira nakerihi mo vano asau moiso na jarauta, suhusuhu la lo vilia matan la lo songahi na langi. ");
INSERT INTO tgp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ale majou rani mo lo vele, Iesu mo mai isara, mo hahau na pusa tasi. ");
INSERT INTO tgp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pani na rani nona tamlohi usuri lara la hitea mo lo hahau na pusa tasi, la have na matara mo tatavera lara, “Eh, tanume matea!” la ulo na tangi matan la matahu. ");
INSERT INTO tgp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pani vahatea purongo Iesu mo reti isara mara, “Ha r̃omr̃ilangi! Enau sei, ha sopo matahu!” ");
INSERT INTO tgp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Moiso Peter mo r̃aramia mara, “Tija, vara engko sei, o retileu isaku vara a mai isam na pusa tasi.” ");
INSERT INTO tgp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesu mo verea mara, “O mai!” Ale Peter mo malue na boti mo hahau na pusa tasi mo lo vano isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pani mara mo hite na langi mo sere r̃ilangi, ale mo matahu, mo tapulo marun na tasi, mo ulo mara, “Tija, o juriau!” ");
INSERT INTO tgp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Vahatea purongo Iesu mo sohai na limana, ale mo tauria, mo verea isana mara, “Engko nom rasu mo rihirihi hajavua, mata sava ko r̃om rua?” ");
INSERT INTO tgp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ale lara la mele vele na boti, langi atu mo moti. ");
INSERT INTO tgp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Haratu la lo toho na boti la lotua lara, “Varar̃uhu, engko Natun God!” ");
INSERT INTO tgp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ale lara la vano na tavalu tasi, la hoso na jara Gennesaret. ");
INSERT INTO tgp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ale tamlohi hin jara atu lara la hitevosahia, la sohai na reti mo r̃alihi jara atu vara la lavi na nora tamlohi rojoa tari la mai isana, ");
INSERT INTO tgp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ale la usia r̃ilangi vara la pa tikeli purongoi na pingo nona ruru. Ale enira mo isoiso atu sei la tikelia la r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Moiso, Pharisee peresi na tamlohi vujangi mata leu la mai isan Iesu la tai Jerusalem lara, ");
INSERT INTO tgp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mata sava nom tamlohi usuri la lo tope na posposi nona vajiaha matan tuai? Matan enira la sopo hoje na limara tiroma moiso la pa hanhani.” ");
INSERT INTO tgp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu mo r̃aramira mara, “Ale mata sava ka lo tope na retileu non God matan ka lo usuri na posposi tamlohi? ");
INSERT INTO tgp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Matan God mo retileu mara, ‘O oloolo hin tamam peresi tinam!’ Ale mara, ‘Hare mo reti sati hin tamana teni tinana, i pa mate matana.’ ");
INSERT INTO tgp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pani ka verea kara, ‘Mo tataholo vara tea i verea isan tamana enia tinana vara sava tuetueni vara i er̃i silea isara, mo pete silea isan God moiso.’ ");
INSERT INTO tgp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ale enia mo sopo sile na oloolo isan tamana matan haratu. Ale matan ka lo usuri na posposi tamlohi, ka r̃ohu na reti non God. ");
INSERT INTO tgp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kamim tamlohi tapnetano! Isaiah mo retimangovi varar̃uhu hin kamim na rani mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘La tamlohi nike, la lo oloolo hiniau na hurira purongo, pani mapura la lo toho asau hiniau; ");
INSERT INTO tgp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","la lo vai vono na nora lotu, la lo vujangi na nora retileu lara retileu non God.’” ");
INSERT INTO tgp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ale Iesu mo tovi vao atu la mai isana mo verea isara mara, “Ha tapurongo, ale ha levosahia! ");
INSERT INTO tgp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sava mo unu na jingom mo sopo vaiho o lumiha, pani sava mo malue na jingom, enia mo vaiho ko lumiha.” ");
INSERT INTO tgp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Moiso nona tamlohi usuri la mai isana la verea lara, “Avei, ko sopo levosahia vara Pharisee la rongo mo sati na sava ko lo verea?” ");
INSERT INTO tgp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mo r̃aramira mara, “Vipahai tari haratu Tamaku na tuka mo sopo lavora i pa saputi nar̃ihira. ");
INSERT INTO tgp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ha sopo sahara vano isara. Enira la matavuso. La lo tiroma na tamlohi, pani la matavuso. Vara matavuso i tiroma na matavuso, la pa jovi hin te moru.” ");
INSERT INTO tgp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pani Peter mo verea isana mara, “O to vere mamahuni titileu sei isamam.” ");
INSERT INTO tgp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ale mo r̃aramia mara, “Kamim sohena, ka sopo lo levosahi? ");
INSERT INTO tgp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ka sopo levosahia vara sava ka hania mo unu na pangemim, ale ka mele hoti hinia? ");
INSERT INTO tgp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pani reti mo lo malue na jingo mo tapulo malue na mapu tamlohi, ale harihi mo vai na tamlohi mo lumiha. ");
INSERT INTO tgp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Matan hinau sohen harihi la lo malue na mapu tamlohi: r̃omr̃omi sasati, vilimatei, vaivaileu peresi na tinapua mo lahi moiso, posposi lumiha, vavanaho, tuetueni halu, reti sati na hija tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","La hinau sei la vai na tamlohi mo lumiha. Pani vara tea i hanhani peresi na limana mo sopo hojea, mo sopo vaia i lumiha.” ");
INSERT INTO tgp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ale Iesu mo malue hin jara atu, mo vano na jara tavera matan Tyre enia Sidon. ");
INSERT INTO tgp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ale vahatea hin jara atu, har̃ai mara Cana matea mo pala mo lo tangi mara, “O r̃omopoiau Moli, mahapin David! Tanume sasati matea mo sohoni venatuku mo vai komokomoa!” ");
INSERT INTO tgp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pani mo sopo r̃aramia hin te reti hatea. Ale nona tamlohi usuri la mai la usia r̃ilangi isana lara, “O r̃ulea i malue matan mo lo tangi usurir̃a.” ");
INSERT INTO tgp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mo r̃aramia mara, “Haratu mo r̃uleau, mo r̃uleau purongo mata sipsip matan Israel sei la jalio.” ");
INSERT INTO tgp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pani har̃ai atu mo mai mo papaohi na nahona mara, “Moli, o tueniau.” ");
INSERT INTO tgp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ale Iesu mo r̃aramia mara, “Mo sopo tataholo vara tea i lavi nar̃ihi na pereti hana natuvarihi i silea isana viriu.” ");
INSERT INTO tgp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Har̃ai atu mara, “He'e Moli, pani viriu la lo hani na utauta pereti sei la lo jovjovi na tep non nora tamlohi tavera.” ");
INSERT INTO tgp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Moiso Iesu mo r̃aramia mara, “Na verea, engko har̃ai matea, nom rasua mo tavera jea. I pa sohena sohen ko opoia.” Ale vahatea purongo, venatuna mo r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu mo mele vano mo hahau na pahisa tasin Galilee. Mo sahe aulu na vutivuti, ale mo lo sakele ea. ");
INSERT INTO tgp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Moiso vao tavera mo mar̃ivi la mai isana peresi na tamlohi hariju, matavuso, tamlohi papao, la haratu la mengo, ale vao matuvana tinapua, ale la taura na palona, moiso mo vai mamahunira, ");
INSERT INTO tgp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ale vao atu r̃omira mo sopo sakele matan mo vai na mengo la retireti, haratu la papao la r̃uhu, haratu la hariju la hahau, ale matavuso la kilau moiso vao atu la mar̃urahi tavera matana, ale la sile na hasohaso isan God matan Israel. ");
INSERT INTO tgp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Moiso Iesu mo tovi na nona tamlohi usuri la mai isana ale mara, “Enau na r̃omopoi la vao nike, matan la lo toho peresiau mata rani mo tolu moiso, ale mo sopo te hara hinau, ale na sopo opoia vara a r̃ulera la mule marohati, vara i vono la pa matemate na malelera.” ");
INSERT INTO tgp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ale nona tamlohi usuri la verea isana lara, “R̃a pa er̃i lavi te pereti i tataholo hin vao tavera nike na jara hasetoho sohen harihi epu?” ");
INSERT INTO tgp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Moiso Iesu mara, “Ka lo lavi na pereti mo visa?” Lara, “Mo limaravrua peresi na maji vavarihi mo visalete purongo.” ");
INSERT INTO tgp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Moiso mo vere vao atu vara la saksakele na lepa, ");
INSERT INTO tgp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ale mo lavi la pereti atu mo limaravrua peresi na maji moiso, mo vere meje isan God, ale mo topera, ale mo silera isana nona tamlohi usuri, ale tamlohi usuri la silera isan la vao atu. ");
INSERT INTO tgp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ale enira mo isoiso la hanhani la masu. Moiso la sohoni na sope hanhani na tanga mo limaravrua la mar̃ivi. ");
INSERT INTO tgp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Evi tamlohi purongo la hanhani mo tikeli tari vaha vati la sopo evi na har̃ai peresi na natuvarihi. ");
INSERT INTO tgp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Moiso hitahun haratu, mo r̃ule la vao atu la mlemle, mo vele na boti matea, ale mo vano na jara Magadan. ");
INSERT INTO tgp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ale Pharisee peresi na Sadducee la mai isana vara la vaihitea. La usia vara i vujangira hin te matamata tavera matan na tuka. ");
INSERT INTO tgp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iesu mo r̃aramira mara, “Vara mo ravravi, kara ‘Taro i pa r̃uhu matan telangi mo hahara!’ ");
INSERT INTO tgp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ale na r̃alavuho, ‘Taro i pa sati nohorihi matan telangi mo hahara, ale mo r̃or̃oha!’ Ka lo levosahia vara taro i pa sohena sava matan ka lo kilau na masapa, pani ka sopo er̃i hitevosahi na matamata matan rani nike ka lo toho hinia? ");
INSERT INTO tgp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Pina sasati nike, mo tamlohi vaivaileu, mo lo aleale matamata, pani i pa sopo lavi te matamata tinapua, pani matamata sei mo masese isan Jonah tuai.” Moiso mo malue isara mo vano. ");
INSERT INTO tgp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nona tamlohi usuri lara la kakau na tavalu tasi, la pa r̃omr̃omia vara la sopo lavi te pereti. ");
INSERT INTO tgp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ale Iesu mo verea isara mara, “Ha sopo r̃omaliho vara ha lo kilau mata isi sasati nona Pharisee peresi na Sadducee.” ");
INSERT INTO tgp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Moiso la tapulo sorahia isara hasera lara, “Eh, korong mo pa verea matan enr̃a r̃a sopo lavi te pereti teni?” ");
INSERT INTO tgp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pani Iesu mo levosahi na sava la lo verea, ale mo verea mara, “Kamim akerihi, nomim rasu mo rihirihi hajavua. Mata sava ka lo sorahia isamim hasemim vara mo sopo te pereti? ");
INSERT INTO tgp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ka sopo lo levosahia? Ka mele r̃omaliho hin la pereti atu mo lima matan vao atu mo tari vaha lima ale ka sohoni na sope hanhani na tanga mo visa hin rani atu? ");
INSERT INTO tgp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Teni ka r̃omaliho hin pereti atu mo limaravrua matan vao atu mo tari vaha vati ale tanga mo visa ka lavia isara? ");
INSERT INTO tgp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mo sohena sava natu, ka sopo levosahia vara enau na sopo retireti na pereti? Ha lo kilau na isi nona Pharisee peresi na Sadducee.” ");
INSERT INTO tgp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ale la pa levosahia natu, vara mo sopo verea vara la lo kilau mata isi mata pereti, pani mata vujangi nona Pharisee peresi na Sadducee. ");
INSERT INTO tgp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ale na rani Iesu mo mai na jara matan Caesarea Philippi, mo usi na nona tamlohi usuri mara, “Kamim ka lo rongo na tamlohi la lo verea vara Natun Tamlohi enia hare?” ");
INSERT INTO tgp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Moiso lara, “Hai la lo verea vara John tamlohi paptijo, tatuara lara Elijah, ale hai lara Jeremiah teni vonan la pr̃ovet atu matea.” ");
INSERT INTO tgp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mo verea isara mara, “Pani kamim ka lo verea vara enau hare?” ");
INSERT INTO tgp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter mo r̃aramia mara, “Engko natu pa Kr̃isto atu, Natun God sei mo mauri!” ");
INSERT INTO tgp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ale Iesu mo r̃aramia mara, “Simon natun Jonah, God mo ler̃uhu hiniho matan mo sopo tea hin varama nike i vujangia isam, pani Tamaku na tuka hasena mo vujangia isam. ");
INSERT INTO tgp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ale na verea isam, engko Peter sei r̃aramin hijam enia vatu, ale hin pulo vatu nike, a pa voro noku vao kalesia, hina purongo vara suiha non varama mata mateia mo r̃ilangi, pani i pa sopo er̃i turuhoroa. ");
INSERT INTO tgp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A pa sileho na kia matan mauri atu God mo aulu hinia, ale sava hinau ko horoa na varama, God na tuka mo horoa moiso, ale sava hinau ko tinar̃ihia na varama, God na tuka mo tinar̃ihia moiso.” ");
INSERT INTO tgp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Moiso, mo retileu isana nona tamlohi usuri vara la sopo sorahia isan tea vara enia natu, Kr̃isto atu. ");
INSERT INTO tgp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mo tapulo hin rani atu natu, Iesu mo tapulo vujangi na nona tamlohi usuri hinia vara enia i pa vano Jerusalem, ale i pa lavi na rongohaji isana tamlohi aulu peresi na moli nona pr̃is peresi na tamlohi vujangi mata leu, ale la pa vilimateia, ale hitahu na hatolu rani i pa mele turu. ");
INSERT INTO tgp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ale Peter mo tauri na limana mo revea vano hasena, mo reti r̃ilangi isana mara, “Moli, mo vono! Hinau atu i pa sopo er̃i masese isam!” ");
INSERT INTO tgp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pani Iesu mo posi mo verea isan Peter mara, “Setan, na sopo opoia vara a hiteho! Engko ko lo turuhoroau, matan engko ko sopo tau na r̃omim na hinahinau non God, pani na hinahinau nona tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Moiso Iesu mo verea isana nona tamlohi usuri mara, “Vara tea mo opoia vara i usuriau, i pa horo na masalona hasena, i lavi na nona talopeilopei, ale i usuriau. ");
INSERT INTO tgp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Matan haratu mo opoi na maurina mo tavera jea, i pa vaitihaia, pani haratu mo r̃ohu na maurina mataku, enia i pa tapai mauri varar̃uhu atu. ");
INSERT INTO tgp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sava hinau mo r̃uhu isan te tamlohi vara i lavi na hinau tari na varama, pani i vaitihai na maurina? Teni sava hinau natu, tamlohi i er̃i silea vara i mele lavi na maurina? ");
INSERT INTO tgp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Matan Natun Tamlohi i pa mai peresi na nona angelo na hasohason Tamana, moiso i pa voli tataholoi na tamlohi hatehateahi mata sava mo vaia na varama. ");
INSERT INTO tgp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Varar̃uhu na verea isamim, tatuamim la lo turu nike nakerihi, la pa sopo er̃i mate vavano la hite Natun Tamlohi i mai na nona suiha mata Supe.” ");
INSERT INTO tgp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ale mele rani mo limarave tinapua mo vano moiso, Iesu mo lavi Peter, James peresi tasina John, mo tiromara la vele sahe aulu na vutivuti tavera matea la toho hasera. ");
INSERT INTO tgp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ale epen Iesu mo mai mo tinapua na nahora, nahona mo mera sohena alo, ruruna la lulu sohena malarani, ");
INSERT INTO tgp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ale vahatea purongo, la hite Moses enia Elijah la pala la lo retireti peresi Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Moiso Peter mo verea isan Iesu mara, “Tija, mo r̃uhu matan r̃a lo toho nike, vara ko opoia a pa vai te ima ruru i tolu akerihi, matea nom, matea non Moses, ale matea non Elijah.” ");
INSERT INTO tgp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mo pa lo retireti, ale vahatea purongo telangi mera matea mo hovira, moiso leo matea mo malue hin telangi atu mara, “Harihi enia Natuku r̃uhur̃uhu, na opoia mo tavera jea, ha tapurongo isana!” ");
INSERT INTO tgp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nona tamlohi usuri lara la rongo leo sei, la jovi na nahora na matahu tavera. ");
INSERT INTO tgp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pani Iesu mo mai mo tikelira mo verea mara, “Ha turu, ha sopo matahu!” ");
INSERT INTO tgp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ale na rani la tar̃a sahe la sopo mele hite tea, pani la hite Iesu hasena. ");
INSERT INTO tgp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ale la pa lo sevuti na vutivuti, Iesu mo retileu isara mara, “Ha sopo vere na sava ka hitea vavano i tikeli na rani Natun Tamlohi i mele turu na mateia.” ");
INSERT INTO tgp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ale tamlohi usuri la usia lara, “Ale mata sava tamlohi vujangi mata leu la lo verea vara Elijah i pa mai tiroma?” ");
INSERT INTO tgp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mo r̃aramira mara, “Elijah i pa mai, ale i pa tau mamahuni na hinau tari. ");
INSERT INTO tgp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pani na verea isamim vara Elijah mo pete pala moiso, ale la sopo hitevosahia, pani la vai masalora isana. Ale sohen haratu la pa sile na rani r̃ilangi isan Natun Tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ale tamlohi usuri la pa rongovosahia natu, vara mo lo verera hin John tamlohi paptijo. ");
INSERT INTO tgp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ale lara la lo sevuti la mai isan vao atu, tamlohi matea mo mai isan Iesu mo papaohi na nahona, ");
INSERT INTO tgp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","mo verea mara, “Moli, o r̃omopoi hin natuku matan enia mo lo matemate, ale tarea mo lo lavi na rongohaji tavera matan hin te rani mo lo jovi na hapu teni wai. ");
INSERT INTO tgp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na pete lavia mo mai isana nom tamlohi usuri moiso, pani la sopo er̃i vai mamahunia.” ");
INSERT INTO tgp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ale Iesu mo r̃aramia mara, “Kamim mo sopo te nomim rasu hatea, kamim pina lejileji matea, a pa mele toho peresi kamim rani i visa? Na sopo levosahia vara a pa lavi na puhon nomim hinau i tikeli pangisa? O lavia i mai isaku!” ");
INSERT INTO tgp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ale Iesu mo reti r̃ilangi isan tanume sasati atu, ale mo malue hinia, ale vahatea purongo natuna mo r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Moiso hitahu, tamlohi usuri la mai na tavaluna la usia lara, “Mata sava kama sopo er̃i levuti nar̃ihia?” ");
INSERT INTO tgp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mo verea isara mara, “Matan nomim rasua mo rihirihi! Varar̃uhu na verea isamim, vara nomim rasua mo r̃ilangi sohena piri paka matea, ha pa er̃i verea isan vutivuti nike, vara ‘O juhati o vano sevano!’ Ale i pa juha. Ale sava natu, vara ha pa sopo er̃i vaia? ");
INSERT INTO tgp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Usiusi peresi na posposi tapuhoro na hanhani purongo i pa er̃i levuti nar̃ihi na tanume sasati sohen harihi i malue.” ");
INSERT INTO tgp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ale na rani la pa lo pulutahi Galilee, Iesu mo verea isara mara, “Natun Tamlohi mariviti vara la turuposi hinia natu vara i vano na lima tamlohi, ");
INSERT INTO tgp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ale la pa vilimateia, moiso i pa mele turu na hatolu rani.” Ale la rongo mo sati tavera matana. ");
INSERT INTO tgp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na rani la kakau Capernaum, haratu la lo lavi na makomo mania mata takis mata nora Temple la mai isan Peter lara, “Nom tija i pa voli na takis teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ale Peter mo r̃aramira mara, “He'e.” Ale mo lo unu na ima, ale Iesu mo retireti tiroma isana mara, “R̃omim mo sohena sava Simon? Supe mata varama la lo lavi na takis isan hare? Isana natura teni isana tamlohi tinapua?” ");
INSERT INTO tgp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ale na rani Simon mo verea mara, “Isana tinapua!” Iesu mo verea isana mara, “Ale vara sohen haratu, natura la materi na takis. ");
INSERT INTO tgp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pani matan vara r̃a sopo komo na r̃omira, o sivo na tasi, o pulahi na nom asi revereve, ale sava maji mo kali hinia tiroma, o roi na vavana, ale o pa hite na mania matea mo tataholo mata voli takis nor̃a enr̃a rua.” ");
INSERT INTO tgp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hin rani atu tamlohi usuri la mai isan Iesu lara, “Hare natu, enia i pa aulu jea hin mauri atu God mo aulu hinia?” ");
INSERT INTO tgp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Moiso mo tovi na natirihi matea vara i mai isana, ale mo turuhia na livuhara, ");
INSERT INTO tgp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","moiso mara, “Varar̃uhu na verea isamim, vara ha sopo posi mai sohen natirihi nike, ha pa sopo er̃i levosahi mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hare mo hase taua atano sohen natirihi nike, enia mo aulu jea hin mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hare mo lavi te natirihi sohen harihi na hijaku, enia mo lo laviau, ");
INSERT INTO tgp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","pani vara tea mo vaitihai na rasua non te vonan la natuvarihi nike la rasuau, i pa mele r̃uhu jea isana vara la pesi te vatu tavera na r̃alona la putehia na tasi puaha. ");
INSERT INTO tgp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Rani sasati i pa jovi na varama matan rasua i pa tihai. Matan tarea hina vaihite la pa lo mai, pani rani sasati isan haratu mo lo vaitihai na rasua nona tinapua. ");
INSERT INTO tgp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ale vara limam teni palom mo vaiho ko vano na hehe, o tai nar̃ihia o pulahia. Mo mele r̃uhu jea vara o unu hin mauri atu o papao teni o hariju, mo jeu haratu vara la pulahiho peresi na limam mo rua teni palom mo rua hin hapu atu mo sopo te isoisona. ");
INSERT INTO tgp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ale vara matam mo vaiho ko lo vano na hehe, o julai nar̃ihia o pulahia. Mo mele r̃uhu jea vara o unu hin mauri atu peresi na matam matelete, mo jeu haratu vara la pulahiho peresi na matam mo rua o vano hin hapu atu mo sopo te isoisona na moruhapu. ");
INSERT INTO tgp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ha lo kilau ha sopo hitelehilehi te vonan la natuvarihi nike, matan na verea isamim vara tarea na tuka, nora angelo, la haratu la lo kilaura, Tamaku na tuka mo tinar̃ihia vara la er̃i turu na nahona matara. ");
INSERT INTO tgp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Matan Natun Tamlohi mo mai vara i juri la haratu la jalio. ");
INSERT INTO tgp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ale nomim kilakilau mo sohena sava? Vara tamlohi matea pulana sipsip mo ngav sangavulu ale matea mo jalio, i pa sopo tau la haratu mo ngavulu limaravati mo limaravati na pahisa vutivuti atu tako ale i ale haratu mo jalio teni i vono? ");
INSERT INTO tgp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ale vara mo tapaia, varar̃uhu na verea isamim, mo avulahi tavera matana, mo jeu la haratu mo ngavulu limaravati mo limaravati sei la sopo jalio. ");
INSERT INTO tgp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mo sohena natu, mo sopo masalom Tamaku na tuka vara rasua non te vonan la natuvarihi nike i vano hina purongo. ");
INSERT INTO tgp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Vara voraim mo vai te hehe isam, o vano o vere na nona hehe isana kamim rua hasemim. Vara mo tapurongo isam, voraim i pa mele tapalam. ");
INSERT INTO tgp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pani vara mo r̃ohu vara i tapurongo, o lavi te hatea teni tupra rua tinapua la vano peresiho matan vara o pa er̃i turu na nora vereulia. ");
INSERT INTO tgp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ale vara mo r̃ohu vara i tapurongo hinira, o pa verea isana vao kalesia. Ale vara mo r̃ohu vara i tapurongo isana vao kalesia sohen tiroma, ale i pa sohena tamlohi r̃or̃oha isamim, ale ha r̃ohu hinia sohena tamlohi r̃or̃oha matea teni haratu mo lo lavi na takis. ");
INSERT INTO tgp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Varar̃uhu na verea isamim, sava kamim kalesia ka lo horoa na varama, God na tuka mo horoa moiso, ale sava ka tinar̃ihia na varama, God na tuka mo tinar̃ihia moiso. ");
INSERT INTO tgp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Na mele verea isamim vara te tupra rua na varama la majinga hin te hinau la usia, Tamaku na tuka i pa vaia sohena isara. ");
INSERT INTO tgp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Matan, vara te tupra rua teni tupu tolu la lo pulutahi na hijaku, enau na lo toho peresira.” ");
INSERT INTO tgp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Moiso Peter mo mai isana mo verea mara, “Tija, vara voraiku mo vai na hehe isaku, a pa r̃omi voraiku vaha visa? Vaha limaravrua teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu mo verea isana mara, “O pa sopo r̃omia vaha limaravrua purongo, pani vaha ngavulu limaravrua vaha limaravrua . ");
INSERT INTO tgp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Matan harihi, mauri atu God mo aulu hinia mo sohena supe matea mo opoia vara i tau mamahuni na ave non nona slev. ");
INSERT INTO tgp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na rani mo tapulo tau mamahuni na ave, la lavi vonara matea mo mai isana, mo ave na mania matea mo tataholo na voli tamlohi mata rani mo tari vaha sangavulu . ");
INSERT INTO tgp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ale matan i pa sopo er̃i voli nar̃ihia, nona tamlohi tavera mo retileu hinia vara la har̃ehia peresi narouna tolu na natuna peresi na nona hinau tari vara i spai na nona mania hinia. ");
INSERT INTO tgp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ale slev atu mo jovi na pauna, mo tangi mara, ‘O r̃omperavu isaku, ale a pa voli vevuhi na noku ave tari isam!’ ");
INSERT INTO tgp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ale tamlohi tavera non slev atu mo r̃omopoia, mo tinar̃ihia vara i vano purongo, ale mo tinar̃ihi na nona ave. ");
INSERT INTO tgp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pani na rani pa slev atu mara mo malue, mo vano mo tapai na slev tinapua matea non tamlohi tavera atu, ale slev sei mo ave isana na mania mo tataholo na voli tamlohi matea mata rani mo ngav sangavulu mo taurilatia, mo tapulo punia mara, ‘O voli na nom ave isaku!’ ");
INSERT INTO tgp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ale slev atu mo jovi na pauna mo tangi isana mara, ‘O r̃omperavu isaku, a pa voli nar̃ihi na noku ave isam.’ ");
INSERT INTO tgp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pa slev atu, mo r̃ohu hinia, ale mo vano mo taua na ima r̃ilangi vara i lo toho atu i tikeli rani atu i voli nar̃ihi vevuhi na nona ave. ");
INSERT INTO tgp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na rani la tapalan slev atu lara la hite na sava mo vaia, la rongo mo sati tavera, la vano la vereuli na hinau tari isan nora tamlohi tavera atu. ");
INSERT INTO tgp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Moiso nona tamlohi tavera mo tovi pa slev atu mo mai isana, mo verea isana mara, ‘Engko ko slev sasati matea ko putu tataholo. Na tinar̃ihi vevuhi na nom ave matan ko usia mo r̃ilangi isaku. ");
INSERT INTO tgp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ale ko sopo er̃i r̃omopoi na tapalam slev sohen enau na r̃omopoiho?’ ");
INSERT INTO tgp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Moiso nona tamlohi tavera atu mo lolokoru patuna, mo silea mo vano isana tamlohi ima r̃ilangi vara i toho atu vavano i voli nar̃ihi vevuhi na nona ave. ");
INSERT INTO tgp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tamaku na tuka i pa vaia sohen harihi isamim isoiso vara ha sopo r̃omi varar̃uhu na voraimim peresi na vevoraimim na mapumim.” ");
INSERT INTO tgp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ale Iesu mara mo vere la hinau atu mo isoiso, mo malue Galilee mo unu na jara matan Judea na tavalu vano wai Jordan. ");
INSERT INTO tgp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ale vao tavera la lo usuria, ale mo vai mamahuni na nora rojoa ea. ");
INSERT INTO tgp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pharisee la mai isana vara la vaihitea lara, “Mo tataholo usuri na leu vara tea i er̃i tipahi narouna matan te hinau?” ");
INSERT INTO tgp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pani Iesu mo r̃aramira mara, “Ka sopo lo evia vara haratu mo vaira na pongi tiroma mo vaira lamane peresi na har̃ai. ");
INSERT INTO tgp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ale mo verea mara, ‘Ale matana, tamlohi i pa tinar̃ihi tamana enia tinana, ale i sor̃otahi isan narouna, ale la pa epe matea?’ ");
INSERT INTO tgp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ale matana, la pa sopo mele tamlohi mo rua, pani epe matea purongo. Ale sava God mo sor̃otahia jara matea, te tamlohi i pa sopo mele asehia.” ");
INSERT INTO tgp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","La verea isana lara, “Mata sava natu, Moses mo retileu vara tea i er̃i sile na pepa mata r̃ohu hin narouna matan vara i tipahi narouna?” ");
INSERT INTO tgp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mo verea isara mara, “Moses mo tinar̃ihia vara ha pa er̃i tipahi na naroumim matan mapumim tamlohi hin Israel la r̃ilangi, pani na pongi tiroma mo sopo sohena. ");
INSERT INTO tgp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ale na lo verea isamim vara tea mo tipahi narouna, pani mo sopo matan te hinau tinapua, pani mata mo vaivaileu peresi te tinapua, ale vara haratu mo tipahia mo lahi na tinapua, enia mo vaivaileu peresi har̃ai atu.” ");
INSERT INTO tgp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nona tamlohi usuri la verea isana lara, “Vara mo sohena natu, isana tamlohi matea peresi narouna, i pa mele r̃uhu jea vara tea i sopo lahi.” ");
INSERT INTO tgp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pani mo verea isara mara, “Mo sopo tamlohi tari sei la pa er̃i lavi reti sei, pani haratu purongo sei God mo tinar̃ihira vara la lavi reti sei. ");
INSERT INTO tgp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Matan, te tamlohi la vora la povota moiso, ale tea tamlohi la votaira, ale tea la sopo lahi matan la hase tapuhira matan mauri atu God mo aulu hinia. Haratu mo er̃i lavi reti nike, i lavia.” ");
INSERT INTO tgp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ale tamlohi la lavi na natura la mai isana vara i tau na limana isara i usiusi matara, pani tamlohi usuri la reti r̃ilangi isara, ");
INSERT INTO tgp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","pani Iesu mara, “Ha tinar̃ihi na natuvarihi la mai isaku, ha sopo horora matan la haratu la sohera la pa lavi mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ale mo ler̃uhu hinira mo tau na limana hinira moiso mo malue hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ale hin rani atu, tamlohi matea mo mai isana mara, “Tija, sava hina r̃uhu natu, vara a vaia a pa lavi na mauri tui matana?” ");
INSERT INTO tgp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ale Iesu mo verea isana mara, “Mata sava ko lo usiau na sava mo r̃uhu? God purongo enia mo r̃uhu. Vara ko opoia vara o lavi na mauri, o toho usuri na retileu.” ");
INSERT INTO tgp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ale mo usia isana mara, “Sahara nakonako?” Iesu mo verea mara, “‘O sopo vilimatei na tamlohi, o sopo vaivaileu peresi na tinapua mo lahi, o sopo vavanaho, o sopo tuetueni na halu non tea, ");
INSERT INTO tgp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","o oloolo hin tamam enia tinam moiso’, ale ‘O opoi na tinapua sohen ko lo opoiho hasem’.” ");
INSERT INTO tgp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Uluvou atu mo verea mara, “La hinau tari sei na lo vaira moiso, pani sava natu, na sopo lo vaia?” ");
INSERT INTO tgp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu mo vere isana mara, “Vara o pa tataholo i r̃uhu, o vano, o har̃ehi vevuhi na nom tavtav, ale o sile na volina isana tamlohi tilavono, ale o pa lavi na tavtav na tuka; ale o mai, o usuriau.” ");
INSERT INTO tgp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pa tamlohi atu mara mo rongo retireti atu, mo malue, r̃omina mo sati matan nona tavtav mo tavera jea. ");
INSERT INTO tgp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Moiso Iesu mo verea isana nona tamlohi usuri mara, “Varar̃uhu na verea isamim, mo r̃ilangi jea vara tamlohi tavtav matea i er̃i lavi mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A mele verea isamim, vara i pa mele malum jea isana camel matea vara i major̃ole na koko niteli, mo jeu na tamlohi tavtav matea vara i er̃i lavi mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tamlohi usuri lara la rongo reti sei, la mar̃urahi tavera lara, “Hare natu, i pa er̃i juri?” ");
INSERT INTO tgp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pani Iesu mo kilau vano isara mara, “Isana tamlohi hinau atu i pa sopo te malelena, pani isan God hinau tari la maleleha.” ");
INSERT INTO tgp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Moiso Peter mo r̃aramia mara, “Ko hitea, kamam kama tinar̃ihi vevuhi na nomam hinau tari, ale kama usuriho. Sava natu, i pa nomam?” ");
INSERT INTO tgp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ale Iesu mo verea isara mara, “Varar̃uhu na verea isamim, hin varama paro atu vara Natun Tamlohi i sakele na nona jara sakele mata suiha merana mo tavera jea, kamim haratu ka lo usuriau ha pa sakele na jara sakele mata suiha mo sangavulu r̃omana mo rua, ha pa ari la tavtavuin Israel atu mo sangavulu r̃omana mo rua. ");
INSERT INTO tgp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ale tamlohi tari sei la malue la tau na imara, teni voraira, teni vevoraira, teni tamara, teni tinara, teni natura, teni nora lepa mata hijaku, God i pa silera la pa mele lavia vaha ngav sangavulu hin haratu la taua, ale la pa lavi na mauri tui hitahu, ");
INSERT INTO tgp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","pani tamlohi matuvana nake sei la lo aulu, la pa sopo aulu hin pongi atu mo lo mai, pani la haratu la sopo aulu nake, la pa aulu.” ");
INSERT INTO tgp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ale mauri atu God mo aulu hinia mo sohen harihi: tamlohi tavera mata ima matea mo malue na r̃alavuho jea matea vara i aleale tamlohi voko mata nona isa grape. ");
INSERT INTO tgp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ale tamlohi voko la majinga vara la pa voko mata volvoli mata rani matea, moiso mo r̃ulera la vano na nona isa grape. ");
INSERT INTO tgp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ale na matan alo mo limaravati na r̃alavuho mo malue mo vano mo hite te tamlohi la lo toho purongo na jara maket, ");
INSERT INTO tgp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ale mo verea isara mara, ‘Eh, kamim sohena, ha sivo na isa grape, ale a pa sile na sava mo tataholo vara ha pa lavia.’ ");
INSERT INTO tgp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Moiso la malue la vano hin isa atu. Ale tamlohi atu mo mele aleale tamlohi sohen tiroma; mo mele malue na livuha rani tataholo, ale mo mele malue na matan alo mo tolu na ravravi atu. ");
INSERT INTO tgp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ale na matan alo mo tikeli mo lima na ravravi hin rani atu, mo malue mo vano mo tapai te tamlohi la lo toho purongo, ale mo verea isara mara, ‘Eh, mata sava ka lo turu purongo nike mo tikeli nakerihi?’ ");
INSERT INTO tgp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","La verea isana lara, ‘Mo sopo tea i usi kamam vara kama voko nona.’ Mo verea isara mara, ‘Kamim sohena, ha vano na isa grape.’ Ale la vano. ");
INSERT INTO tgp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ale na ravravi jea mo verea isan nona patu tamlohi vara i tovi na tamlohi voko vara i silera na volira, ale vara i tapulo hin la haratu la pa voko hitahu, ale i sahe i tikeli la haratu la lo voko tiroma. ");
INSERT INTO tgp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ale na rani la haratu mo tovira vara la voko na matan alo mo lima na ravravi la mai, mo silera hatehateahi na volira mo tataholo mata voli rani matea. ");
INSERT INTO tgp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Moiso na rani la haratu mo tovira tiroma na r̃alavuho mata voko la mai, la lo r̃omr̃omia vara la pa lavi na mania i jeura, pani enira hatehateahi sohena, la lavi na volira mo tataholo mata voli rani matea. ");
INSERT INTO tgp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lara la lo lavia, la lo retireti vavarihi hin tamlohi tavera atu mata ima, ");
INSERT INTO tgp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","lara, ‘La haranike la pa mai hitahu la voko mata aoa matelete purongo, ale ko volira sohemam sei, kama slev nom na alo tavera mo tikeli nakerihi.’ ");
INSERT INTO tgp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pani mo r̃arami na vonara matea mara, ‘Tapala, na sopo vai te hinau i sati isam. Ko sopo majinga peresiau na volim mata rani matea teni mo vono? ");
INSERT INTO tgp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","O lavi na sava enia nom, ale o vano. Enau na opoia vara a sile na sava na silea isam i vano isan la haranike la pa voko hitahu. ");
INSERT INTO tgp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ko hitea mo sopo tataholo vara a vai na sava na noku mania sohen na opoia? Teni ko mereimerei matan posiku mo r̃uhu?’” ");
INSERT INTO tgp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ale Iesu mo mele verea mara, “Vao atu nake sei la lo aulu, la pa sopo aulu hin pongi atu mo lo mai, pani la haratu la sopo aulu, la pa aulu.” ");
INSERT INTO tgp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ale na rani Iesu mo pa lo sahe Jerusalem, mo tovi la nona tamlohi usuri atu mo sangavulu r̃omana mo rua mo tovira vano na tavul malele, ale mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ka hitea, r̃a lo sahe Jerusalem. Ale la pa turuposi hin Natun Tamlohi i pa vano na lima moli nona pr̃is peresi na tamlohi vujangi mata leu, ale la pa sile na talai isana vara i mate, ");
INSERT INTO tgp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ale la pa silea isana tamlohi r̃or̃oha vara la pa kerehia, ale la rupia na asi maja, ale vara la vosaea na talopeilopei, ale na hatolu rani i pa mele turu na mateia.” ");
INSERT INTO tgp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ale tinan la natun Zebedee, James enia John, mo mai isana tolu na natuna, ale mo papaohi na nahona vara i usia hin te hinau. ");
INSERT INTO tgp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ale Iesu mo verea isana mara, “Ko opoi na sava?” Mo r̃aramia mara, “Na opoia vara la natuku nike mo rua la sakele na pahisam vara ko tauri na nom suiha, matea na matuam, ale matea na maraum.” ");
INSERT INTO tgp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu mo r̃aramira mara, “Kamim ka sopo levosahi na sava ka lo usia. Ha er̃i lavi na rani r̃ilangi a pa lavia?” La r̃aramia lara, “Enjora, kama er̃i lavia.” ");
INSERT INTO tgp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mo verea isara mara, “Ha pa lavi na sava a pa lavi, pani matan vara ha pa sakele na matuaku teni na marauku, enia mo sopo noku vara a pa majinga hinia, pani enia non la haratu sei, Tamaku mo tatamahunia matara moiso.” ");
INSERT INTO tgp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ale na rani la tupu sangavulu tinapua atu lara la rongoa, la lolokoru hin la vorai atu mo rua. ");
INSERT INTO tgp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pani Iesu mo tovira la mai isana, ale mo verea mara, “Ka levosahia vara tamlohi aulu hin la haratu la tamlohi r̃or̃oha, la opoia tavera vara la pa lo aulu na nora tamlohi, ale ka levosahia sohena sava nora tamlohi tatavera la lo roro na nora suiha hinira. ");
INSERT INTO tgp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","I pa sopo sohena isamim, pani hare mo opoia vara i aulu jea hin kamim mo isoiso, enia i pa nomim volitusi, ");
INSERT INTO tgp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ale haratu mo opoia vara i pa tiromamim, enia i pa nomim slev, ");
INSERT INTO tgp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","mo sohena natu, Natun Tamlohi mo sopo sinai vara tamlohi la volitusi isana, mo vono, mo sinai vara enia i volitusi, ale vara i sile na maurina vara i volituhu na matuvana.” ");
INSERT INTO tgp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ale lara la lo malue Jericho, vao tavera matea la usuria. ");
INSERT INTO tgp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ale hin rani atu tamlohi matavuso mo rua la lo sakele na pahisa malele, ale lara la rongoa vara Iesu mo lo hahau na malele mariviti atu, la ulo aulu lara, “Moli, o r̃omopoi kamam, Natun David!” ");
INSERT INTO tgp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Vao atu la merusahira vara la toho malum, pani la mele ulo aulu mo tavera jea lara, “Moli, o r̃omopoi kamam, Natun David!” ");
INSERT INTO tgp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu mo turu, ale mo tovira la mai isana mara, “Ka opoi vara a vai na sava isamim?” ");
INSERT INTO tgp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","La verea isana lara, “Moli, kama opoia vara matamam la kilau.” ");
INSERT INTO tgp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Moiso Iesu mo r̃omopoira, mo tikeli na matara, ale vahatea purongo la er̃i hite, ale la usuria. ");
INSERT INTO tgp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ale lara la lo mai mariviti hin Jerusalem, la kakau taon sei Bethphage na pahisa Vuti talu Olive, moiso Iesu mo r̃ule na tamlohi usuri mo rua, ");
INSERT INTO tgp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","mo verea isara mara, “Ha vano hin vanua aturihi, ale vara ka lo unu ha pa hite na donki matea peresi natuna la lasira ea. Ha uli nar̃ihira, ale ha lavira la mai isaku. ");
INSERT INTO tgp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ale, vara tea mo vere te hinau isamim matana, ha pa verea vara, ‘Nomam tamlohi tavera mo opoira!’ ale vahatea i pa r̃ulera la mai.” ");
INSERT INTO tgp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Harihi sei, mo malue sohena matan vara sava hinau pr̃ovet mo verea moiso i pa masese sei mara, ");
INSERT INTO tgp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Ha verea isan la haratu la lo toho Zion vara: Nomim Supe mo lo mai isamim, mo r̃ommalum, ale mo lo sakele na donki matea, ale ha kilau vano, donki sei mo lo sakele hinia enia natu donki matea!’ ");
INSERT INTO tgp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ale la tamlohi usuri atu mo rua la vano la vai na sava Iesu mo verea isara moiso. ");
INSERT INTO tgp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","La lavi donki atu peresi na natuna, la tatavu na har̃in la donki atu na nora ruru hai, ale Iesu mo sakele hinira, ");
INSERT INTO tgp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","moiso, la vao tavera atu la vur̃angi na nora ruru na malele tavera atu, ale tatuara la tai na pere vipahai la vur̃angira hin malele atu. ");
INSERT INTO tgp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ale vao tavera atu la vano tiroma hinia peresi la haratu la lo usuria, la lo uloulo tavera lara, “Hasohaso God, matan natun David!” “‘Ale ler̃uhu hinia sei mo lo mai na hijan Moli God!’” “Hasohaso i sahe isan God na tuka sei mo aulu jea!” ");
INSERT INTO tgp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ale na rani mo unu Jerusalem tamlohi tari hin taon tavera atu la hutura hinia, la lo verea lara, “Hare nahai?” ");
INSERT INTO tgp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ale vao tavera atu lara, “Tamlohi nike, enia pr̃ovet Iesu, mara Nazareth hin Galilee.” ");
INSERT INTO tgp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ale Iesu mo unu na Temple, moiso mo levuti la haratu la lo ar̃ear̃ehi peresi la haratu la lo volvoli na lolo Temple, moiso mo tipovi na tepel non la haratu la lo jenjen mania peresi na jara sakele non la haratu la lo har̃ehi na vomahe. ");
INSERT INTO tgp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mo verea isara mara, “Retiulia mo verea vara, ‘Imaku la pa tovia ima usiusi.’ Pani kamim ka vaia mo mai jara luhu non la haratu sei la tatamahu moiso mata vili na tamlohi mata vavanaho.” ");
INSERT INTO tgp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Moiso matavuso peresi na tamlohi papao la mai isana na lolo Temple, ale mo vai mamahunira. ");
INSERT INTO tgp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pani moli mata pr̃is peresi na tamlohi vujangi mata leu lara la hite na hina mar̃urahi r̃uhur̃uhu mo lo vaira moiso, ale lara la mele rongo na natuvarihi la lo ulo aulu na Temple lara, “Hasohaso isan Natun David!” tamlohi tatavera atu la lolokoru. ");
INSERT INTO tgp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ale la verea isana lara, “Ko rongo na sava la lo verea?” Ale Iesu mo verea isara mara, “He'e! Kamim ka sopo lo evia na Retiulia hin te rani vara, ‘God engko ko tatamahu na nom hasohaso vara i pa malue na jingo natuvarihi peresi na pipi?’” ");
INSERT INTO tgp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hitahun haratu, mo malue isara, mo malue Jerusalem mo vano na taon matan Bethany, ale mo juruvi atu. ");
INSERT INTO tgp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na r̃alavuho, mo lo hilu vano Jerusalem, ale mo rongo mo marohati. ");
INSERT INTO tgp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ale mo hite na pulo fig matea na pahisa malele, mo vano mariviti, pani mo sopo hite te vuana hinia, pani rauna purongo. Ale mo reti isana mara, “O pa sopo er̃i mele lavi te vuam hin te rani!” Ale vahatea purongo pulo fig atu mo mahoa. ");
INSERT INTO tgp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na rani tamlohi usuri lara la hitea, la hutura lara, “Eh, mo sohena sava natu, pulo fig nike mo mahoa vahatelete purongo?” ");
INSERT INTO tgp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Moiso Iesu mo r̃aramira mara, “Varar̃uhu na verea isamim, vara te nomim rasua, ale ha sopo r̃om rua, kamim ha pa er̃i vaia sohen harihi na vaia isan pulo fig nike, ale ha pa er̃i verea isan vutivuti nike, vara, ‘O hase sauho aulu, o pulahiho na lolo tasi!’ Ale i pa masese. ");
INSERT INTO tgp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ale sava ka lo usia na usiusi, ha pa lavia, vara te nomim rasua.” ");
INSERT INTO tgp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu mo unu na Temple, ale mara mo lo vujangi na tamlohi, moli mata pr̃is peresi na tamlohi aulu matan Jerusalem la mai isana vara la usi te retiusia isana lara, “Ko lo vai la hinau nike na suihan hare? Hare mo sileho hin suiha sei?” ");
INSERT INTO tgp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu mo r̃aramira mara, “Enau sohena a pa usi kamim na retiusia matea, ale vara ha r̃aramiau, enau sohena a pa vereulia vara sava suiha nahai na lo vai la hinau sei hinia. ");
INSERT INTO tgp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Suiha atu John mo lo paptijo hinia mo tai epu? Mo tai na tuka, teni isana tamlohi?” Ale la lo sorasorahia isara lara, “Vara r̃a verea vara, ‘Mo tai na tuka!’ i pa verea isar̃a vara, ‘Mata sava ka sopo rasua?’ ");
INSERT INTO tgp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pani vara r̃a verea vara, ‘Mo tai isana tamlohi purongo!’ vao nike la pa parur̃a matan enira la verea vara John enia pr̃ovet varar̃uhu matea non God.” ");
INSERT INTO tgp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ale matana, la r̃arami Iesu lara, “Kama sopo levosahia.” Ale Iesu mo verea isara mara, “Enau sohena, a pa sopo vereuli kamim hinia vara sava suiha natu, na lo vai la hinau sei hinia. ");
INSERT INTO tgp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ha to r̃omr̃omia, tamlohi matea natuna mo rua. Ale mo verea isan matea tiroma mara, ‘Natuku, o pa vano o voko na isa grape nohorihi.’ ");
INSERT INTO tgp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ale uluvou atu mo r̃aramia mara, ‘Na r̃ohu!’ pani hitahu mo posi na r̃omina, ale mo vano. ");
INSERT INTO tgp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ale mo mele vano isan natuna tinapua atu, mo verea sohena. Ale mo r̃aramia mara, ‘A pa vano tata!’ pani mo pa sopo vano. ");
INSERT INTO tgp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sahara hin la haratu mo rua mo vai na masalon tamana?” Lara, “Haratu tiroma.” Iesu mo verea isara mara, “Enjora, varar̃uhu na verea isamim, haratu la lo lavi na takis peresi na har̃ai malele, la pa lavi mauri atu God mo aulu hinia tiroma hin kamim. ");
INSERT INTO tgp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Matan John mo pala isamim mo vujangi na malele posposi tataholo non God, ale ka sopo rasua, pani haratu la lo lavi na takis peresi na har̃ai malele la rasua. Hina purongo vara ka hitea, ka r̃ohu vara ha posi na r̃omimim vara ha rasu. ");
INSERT INTO tgp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ha mele tapurongo na titileu tinapua. Tamlohi tavera mata ima matea mo lavo na isa grape matea. Mo tiu na wor̃a matea r̃alihia, ale mo heli na koko varavarasi grape matea, ale mo voro na ima aulu matea mata kilakilau, ale mo opoia vara tea la pakaia, ale tamlohi hai la pakaia, moiso enia mo vano na jara tinapua matea mo vano asau. ");
INSERT INTO tgp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ale taro asitauni mo lo mai mariviti, mo r̃ule na nona slev la vano isan la tamlohi atu la lo pakai isa atu vara la lavi na r̃ungana. ");
INSERT INTO tgp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","La tamlohi atu la tauri na nona slev, la tamaji matea, la vilimatei matea, ale la parumatei matea. ");
INSERT INTO tgp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tamlohi tavera atu mo mele r̃ule na slev tinapua, evira mo jeu la haratu tiroma. Ale la tamlohi atu la vaia isara sohen la lo vaia tiroma. ");
INSERT INTO tgp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na isoisona, mo r̃ule natuna mo vano isara mara, ‘Korong la pa oloolo hin natuku!’ ");
INSERT INTO tgp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pani na rani la tamlohi atu lara la hite natuna, la verea isara hasera lara, ‘Nona korohi nakerihi. Ha mai, r̃a vilia, ale r̃a pa lavi na koruna.’ ");
INSERT INTO tgp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ale la tauria la pulahi nar̃ihia hin isa atu, ale la vilimateia atu. ");
INSERT INTO tgp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ale na usi kamim hinia vara na rani tamlohi isa atu i mele pala, i pa vai na sava isan la tamlohi atu la lo pakai na isana?” ");
INSERT INTO tgp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","La r̃arami Iesu lara, “I pa vilimatei la tamlohi sasati atu na malele r̃ilangi matea, ale i pa mele tinar̃ihia isana tamlohi tinapua vara la pa pakai matana, ale la pa silea na vuana na rani asitauni.” ");
INSERT INTO tgp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu mo verea isara mara, “Enjora, ka sopo lo evi hinau nike na Retitapu hin te rani? ‘Vatu atu tamlohi voro ima la lo tipahia, enia mo mai tapulo pulo vatu mata ima, haranike Moli God mo vaia, ale mo r̃uhu jea matan r̃a er̃i hitea.’ ");
INSERT INTO tgp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Matana, na lo verea isamim, jara oloolo atu ka lo turu hinia isan God sei mo supe mo aulu hin kamim Jew hasemim purongo hinia, God i pa lavi nar̃ihi oloolo sei isamim, i pa silea isana mara jara tinatinapua sei la pa vua na vua r̃uhu sei God mo opoia. ");
INSERT INTO tgp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ale haratu mo lo tialahalaha hin vatu atu, vatu atu i pa putputia, ale vara vatu atu mo jovi hin tea i pa lomolomoa.’” ");
INSERT INTO tgp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na rani moli mata pr̃is peresi na Pharisee lara la rongo titileu atu, la rongovosahia vahatea vara mo lo verera. ");
INSERT INTO tgp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pani hina purongo vara la lo aleale malele vara la taurilatia hinia, la matahuni la vao atu matan vao atu la rasua vara enia pr̃ovet matea. ");
INSERT INTO tgp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ale Iesu mo mele vere na titileu hai isara mara, ");
INSERT INTO tgp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ale mauri atu God mo aulu hinia mo sohen harihi: Supe matea mo tatamahu na hanhani tavera matea mata lahi non natuna, ");
INSERT INTO tgp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ale mo r̃ule na nona slev vara la vano la tovi la haratu sei la lo usira moiso vara la pa mai na hanhani tavera mata lahi sei, pani la r̃ohu vara la mai. ");
INSERT INTO tgp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ale mo mele r̃ule te slev tinapua, ale mo verea isara mara, ‘Ha vano isan la haratu r̃a usira tiroma, ha verea isara vara la mai natu, matan na tatamahuni na noku hanhani moiso, ale ka hitea, la vili na pulaku buluk hai peresi na natu buluk hai sei la r̃avisvis r̃uhu, hinau tari mo tatamahu moiso, ha mai na hanhani tavera mata lahi.’ ");
INSERT INTO tgp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pani la sopo tapurongo isara, ale la malue, matea mo vano na isana, matea mo vano na nona stoa, ");
INSERT INTO tgp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ale la hina tinapua atu la taurilati na nona slev la vailehilehira, ale la vilimateira. ");
INSERT INTO tgp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ale supe atu mo lolokoru, mo r̃ule na nona tamlohi vuro, ale la vano la vili la tamlohi atu la sopo juri, ale la suli jovjovi na nora taon tavera. ");
INSERT INTO tgp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ale mo verea isana nona slev mara, ‘Hanhani tavera mata lahi mo tatamahu moiso, pani haratu r̃a usira tiroma la sopo r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ale matana, ha vano na malele tavera, ha usi na sava tamlohi ka tapaira ea vara la mai na hanhani tavera mata lahi.’ ");
INSERT INTO tgp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Moiso la slev atu la vano na malele, ale la tovi matavuhi na tamlohi sasati, peresi na tamlohi r̃uhu, haratu la tapaira, ale ima lahi atu mo mar̃ivi na tamlohi atu la lo usira. ");
INSERT INTO tgp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pani na rani supe mo mai vara i hite la tamlohi atu la lo usira, mo hite na tamlohi matea atu mo sopo te nona ruru tataholo mata lahi. ");
INSERT INTO tgp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ale mo verea isana mara, ‘Tapala, ko pa unu nike sohena sava matan mo sopo te nom ruru mata lahi?’ Ale tamlohi atu nona hapu mo mate. ");
INSERT INTO tgp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Moiso supe atu mo verea isana nona slev mara, ‘Ha pesi pulutahi na palona peresi na limana, ha pulahia hin jara r̃or̃oha atu mata talai. Hin jara atu la pa tangtangi, ale la pa ngar̃ngar̃ori na hur̃ura mata rongohaji ea.’ ");
INSERT INTO tgp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Matan God mo tovi na tamlohi matuvana, pani mo vir̃oni na tupu visalete purongo.” ");
INSERT INTO tgp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Moiso Pharisee la vano la hatihia vara la pa vaihitea vara Iesu i kali hin te nona reti. ");
INSERT INTO tgp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ale la r̃ule na nora tamlohi usuri peresi na tamlohi non supe Herod la vano isana lara, “Tija kama levosahia vara engko ko lo varar̃uhu, ale ko lo vujangi na malele varar̃uhu mo usuri na masalon God mo tataholo, ale ko sopo r̃omr̃omi na r̃omi tamlohi purongo matan ko sopo tametame tea. ");
INSERT INTO tgp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","O to vere kamam hinia nakerihi vara mo tataholo vara tamlohi la voli na takis isana supe nona mara Rome teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pani matan Iesu mo levosahi na nora posposi vaisatihi na tinapua, mo verea mara, “Kamim tapnetano, ka lo vaihiteau mata sava? ");
INSERT INTO tgp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ha to sileau hin te selen mata takis hatea.” Ale la silea na selen mata takis matea. ");
INSERT INTO tgp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Moiso Iesu mo verea isara mara, “Ale ha to verea, niniun harepu peresi na hijana nahai?” ");
INSERT INTO tgp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lara, “Supe nona mara Rome.” Ale mo verea isara mara, “Ale vara mo sohena, ha sile na hinau non supe nona mara Rome isan supe nona mara Rome, ale hinau non God isan God.” ");
INSERT INTO tgp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Lara la rongoa sohena sava mo r̃aramira sei mo r̃uhur̃uhu jea, la hutura hinia, ale la malue la rovo hinia. ");
INSERT INTO tgp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Rani atu mo pa lo vano, ale Sadducee la mai isana. Vao sei la verea vara mo sopo te sauteterahi, ale la usia na retiusia matea, ");
INSERT INTO tgp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","lara, “Tija, Moses mara, ‘Vara te tamlohi mo mate mo sopo te natuna, tasina i pa lavi narouna mata i korohi te natun tavaina.’ ");
INSERT INTO tgp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ale vorai mo limaravrua la lo toho nike isamam, ale vora tiroma mo lahi, ale mo mate, pani mo sopo te natuna. Vora usuria mo lavi narouna. ");
INSERT INTO tgp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ale mo sohena isan nona vora usuria atu peresi na hatolura, mo sivo mo tikeli na halimaravruara. ");
INSERT INTO tgp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hitahura, har̃ai atu mo mate. ");
INSERT INTO tgp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ale, hin pongi atu tamlohi la pa sauteterahi hinia, matan enira mo isoiso la lahi hin har̃ai atu, i pa naroun sahara hinira?” ");
INSERT INTO tgp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ale Iesu mo r̃aramira mara, “R̃omimim mo sopo tataholo, matan ka sopo levosahi na Retitapu teni na suihan God. ");
INSERT INTO tgp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Matan na pongi hitahu na sauteterahi la pa sopo lahi teni la pa tulatulahi, pani la pa sohena angelo na tuka. ");
INSERT INTO tgp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ale hin vujangi sei mata sauteterahi, ka sopo lo evi na sava God mo verea isamim? ");
INSERT INTO tgp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Enau God non Abraham, God non Isaac, ale God non Jacob!’ God mo sopo verea vara enia God non la haratu la mate, pani non la haratu la mauri.” ");
INSERT INTO tgp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ale vao tavera atu lara la rongo na nona vujangi, la mar̃urahi tavera hinia. ");
INSERT INTO tgp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pani Pharisee lara la rongoa vara Iesu mo vuni na hapu non la vao Sadducee atu, Pharisee la pulutahi, ale la mai isana. ");
INSERT INTO tgp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ale vonara matea, enia tamlohi lelevosahi mata leu matea, ale mo usia na retiusia matea vara i vaihitea mara, ");
INSERT INTO tgp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tija, sava retileu natu, mo aulu mo jeu na retileu tari na Leu?” ");
INSERT INTO tgp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ale Iesu mo verea isana mara, “‘O pa opoi Moli nom God vevuhi na mapum, na maurim, ale na nom r̃omr̃omi tari’. ");
INSERT INTO tgp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Harihi natu, enia retileu atu mo aulu jea mo tiromara. ");
INSERT INTO tgp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Haruana mo sohen harihi, ‘O opoi na tahisam sohen ko lo opoiho hasem’. ");
INSERT INTO tgp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hin la retileu atu mo rua, vujangi tari mata Leu non Moses peresi na pr̃ovet la lo turu hinira.” ");
INSERT INTO tgp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ale hin rani atu Pharisee la pa lo pulutahi jara matea, Iesu mo usira na retiusia matea, ");
INSERT INTO tgp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","mara, “Ha to vereau na r̃omimim hin Kr̃isto? Enia mahapin hare?” Ale la verea isana lara, “Enia mahapin David.” ");
INSERT INTO tgp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mo verea isara mara, “Mo sohena sava natu, David, na suihan Tanume r̃uhu mo tovia Moli mara, ");
INSERT INTO tgp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Moli God mo verea isan noku Moli: O sakele na matuaku na jara oloolo nike, i tikeli pongi atu a tau na nom meresahi na ruhuruhu palom.’ ");
INSERT INTO tgp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Vara David mo tovia Moli, mo sohena sava natu, enia natun David?” ");
INSERT INTO tgp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ale, te vonara hatea mo sopo er̃i r̃aramia hin te reti hatea, ale mo tapulo hin rani atu, mo sopo tea i r̃omr̃ilangi vara i mele usi te retiusia isana. ");
INSERT INTO tgp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ale Iesu mo verea isan la vao atu peresi na nona tamlohi usuri mara, ");
INSERT INTO tgp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tamlohi vujangi mata leu peresi na Pharisee, enira natu, la haratu la lo vujangi na malele Retiulia sei Moses mo ulia vara mo lo vere na sava, ");
INSERT INTO tgp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","matana, mo r̃uhu vara ha vai na hinau tari la verea isamim, ale ha turu hinira, pani ha sopo vai na sava la lo vaira, matan la sopo vai na sava la lo retivujavujangi hinira. ");
INSERT INTO tgp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","La lo opoia hajavua vara la tau na hinau puhoni na mauri tamlohi, pani la r̃ohu vara la juhati na pulora vara la tuenira. ");
INSERT INTO tgp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hinau la lo vaira la vaira matan vara tamlohi la pa er̃i hitera, sohen la lo vai na nora sope puku mata Retiulia sei la lo lasira na patura la mele tavera, ale la vai na nora revurevu ruru la mele peravu jea. ");
INSERT INTO tgp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ale la opoia vara la lo sakele na jara sakele nona tamlohi tatavera na hanhani tavera, ale na jara sakele nona tamlohi aulu na lolo ima lotu, ");
INSERT INTO tgp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ale la opoi na rani tamlohi la tovira vara ‘tija’ ale la opoi na rani tamlohi la sile na retioloolo isara na jara maket. ");
INSERT INTO tgp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pani kamim ha pa sopo lavi na hija tija matan nomim Tija enia matelete, ale kamim vorai peresi na vevorai. ");
INSERT INTO tgp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ale ha sopo tovi te tamlohi na varama, ‘Tama’ matan Tamamim enia matelete purongo na tuka. ");
INSERT INTO tgp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sohen haratu ha sopo lavi na hija ‘tija’ matan nomim Tija enia Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Haratu mo aulu jea hin kamim, enia i pa nomim volitusi. ");
INSERT INTO tgp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Haratu mo hase tahea sahe aulu hin kamim, God i pa taua sivo atano, haratu mo hase taua sivo atano, God i pa tahea sahe aulu. ");
INSERT INTO tgp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Rani r̃ilangi tavera i pa mai isamim tamlohi vujangi mata leu peresi kamim Pharisee, kamim ka tapnetano, matan ka lo pelatihoro na malele vara tamlohi la sopo er̃i lavi mauri atu God mo aulu hinia. Matan kamim hasemim ka sopo unu, ale ka lo turuhoro la haratu la opoia vara la unu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","15","Rani r̃ilangi tavera i pa mai isamim, tamlohi vujangi mata leu, peresi kamim Pharisee, kamim ka tapnetano, matan ka lo hahau rotoroto na jara peresi na tasi vara ha vai te tamlohi hatea mo sopo mahapin Abraham i lavi na nomim rasua, ale na rani mo mai sohena vonamim matea, ka vaia mo mai natu moruhapu matea mo mele sati jea mo jeu kamim. ");
INSERT INTO tgp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Rani r̃ilangi tavera i pa mai isamim ka tamlohi tatavera matavuso, ka lo vujangia kara, vara tea mo vere na nona retitauhi na hija Temple, ka verea vara enia hina purongo, pani vara tea mo vere na nona retitauhi na gold mata Temple, haratu i pa mele r̃uhu vara i taurilati na nona retitauhi. ");
INSERT INTO tgp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ka matavuso rongorongo vono! Sava mo aulu jea? Gold teni Temple atu sei mo lo vai na gold mo tapu? ");
INSERT INTO tgp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ale ka lo verea vara, vara tea mo vere na nona retitauhi na hija jara silesilea isan God, kara enia hina purongo, pani vara tea mo vere na nona retitauhi na nona silesilea, i pa mele r̃uhu vara i taurilati na nona retitauhi. ");
INSERT INTO tgp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ka tamlohi matavuso! Sava mo aulu jea? Silesilea teni jara silesilea atu sei mo lo vai na silesilea mo tapu? ");
INSERT INTO tgp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ale haratu mo vere na nona retitauhi na hija jara silesilea, mo lo retitauhi na hinau tari hinia. ");
INSERT INTO tgp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Moiso haratu mo lo vere na nona retitauhi na hija Temple, mo retitauhi na hijana peresi God atu mo lo toho hinia. ");
INSERT INTO tgp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ale haratu mo retitauhi hin tuka, mo lo retitauhi na jara sakele mata suiha non God peresi God sei mo lo sakele ea. ");
INSERT INTO tgp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Rani r̃ilangi tavera i pa mai isamim, tamlohi vujangi mata leu, peresi kamim Pharisee, kamim ka tapnetano. Kamim ka avulahi vara ha lo sile na nomim tithe na hinau sohena: solat, oke peresi na watakres, pani ka lo kilau purongoi na hinau aulu mata leu sohena: aria tataholo, r̃omopoia peresi na vai vevuhi na nomim retitauhi tarea. Ha vai la harihi la sopo aulu jea, pani ha sopo r̃omaliho hin la haratu la mele aulu jea na nahon God. ");
INSERT INTO tgp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ka tamlohi tatavera matavuso! Ka lo spuni nar̃ihi na hina varihi la sati, pani ka lo r̃olomi jarohi na hina tavera la sasati! ");
INSERT INTO tgp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Rani r̃ilangi tavera i pa mai isamim, tamlohi vujangi mata leu, peresi kamim Pharisee. Kamim ka tapnetano, matan ka lo hoje na pahisa paniken peresi na peleti, pani na lolona mo mar̃ivi na posposi hanmarua peresi posposi r̃omr̃omi hasemim. ");
INSERT INTO tgp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ka Pharisee matavuso! Ha hoje na lolo paniken peresi na peleti tiroma matan vara pahisara la pa vokevoke. ");
INSERT INTO tgp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Rani r̃ilangi tavera i pa mai isamim, tamlohi vujangi mata leu, peresi kamim Pharisee. Kamim ka tapnetano! Matan kamim ka sohena ima taptap laem lulu, pani lolona mo mar̃ivi na sui tamlohi peresi na lumira. ");
INSERT INTO tgp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ale kamim sohena, la hite kamim sohen ka vokevoke, pani ka mar̃ivi na tapnetano peresi na vaivaileu. ");
INSERT INTO tgp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Rani r̃ilangi tavera i pa mai isamim, tamlohi vujangi mata leu, peresi kamim Pharisee. Kamim ka tapnetano! Matan ka voro na ima taptap nona pr̃ovet, ale ka lakolako na taptap tamlohi tataholo na storera la ulia na tapura, ");
INSERT INTO tgp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","kara, ‘Vara kama pa lo toho na pongi non la nomam tata, kama pa sopo tuenira vara la vili na pr̃ovet.’ ");
INSERT INTO tgp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ale matana, ka lo vereulia vara kamim ka natun la tamlohi atu la lo vili na pr̃ovet. ");
INSERT INTO tgp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ha vai mar̃ivisi na sava tamamim la tapulona, ");
INSERT INTO tgp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ka sohena mata! Ka natu mata sasati. Ha pa juri kamim sohena sava na talai mata moruhapu? ");
INSERT INTO tgp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Matan haratu, a pa r̃ule te pr̃ovet peresi te tamlohi lelevosahi tolu na tamlohi vujangi mata leu, tatuara ha pa vilimateira na talopeilopei, ale tatuara ha pa rupira na asi maja na nomim ima lotu, ale ha pa tipahira na taon tavera tari la pa vano ea, ");
INSERT INTO tgp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","matan haratu i pa sohen harihi: kamim ha pa lavi na talai mata r̃ae tari nona pr̃ovet tuai mo tapulo na r̃aen Abel, tamlohi tataholo atu, mo tikeli na r̃aen Zechariah natun Barachiah, haratu ka vilia na livuha jara tapu na lolo Temple peresi na jara mata silesilea atu. ");
INSERT INTO tgp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Varar̃uhu na verea isamim, la talai sei la pa pala isan pina nike.” Iesu mo mele verea mara, ");
INSERT INTO tgp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem o Jerusalem, taon tavera sei tamlohi tatavera la lo vilimatei na pr̃ovet hinia, ale la lo parumatei la haratu God mo r̃ulera isana. Ko sopo levosahia vara vaha visa moiso na opoia vara a hohovi na natum, sohena tina toa mo lo hohovi na natuna na ruhuruhu hapana, pani kamim tamlohi tatavera hinia ka r̃ohu! ");
INSERT INTO tgp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ko hitea, imam nike, i pa mai sohena jara hasetoho matea. ");
INSERT INTO tgp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Matan na verea isamim, ha pa sopo mele hiteau vavano i tikeli rani atu ha pa verea vara, ‘Ler̃uhu hin haratu mo lo mai na hijan Moli God’.” ");
INSERT INTO tgp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hitahu, Iesu mara mo lo malue na Temple non Jerusalem, nona tamlohi usuri la mai isana vara la verea vara la ima tavera atu la r̃uhu sohena sava. ");
INSERT INTO tgp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pani Iesu mo r̃aramira mara, “Ka hite la ima tari akerihi? Varar̃uhu na verea isamim vara i pa sopo te vatu hatea i pa lo toho aulu na vatu tinapua sei vara la pa sopo atu jovjovira!” ");
INSERT INTO tgp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hitahuna, Iesu mo lo sakele na vuti talu Olive, ale nona tamlohi usuri la mai r̃or̃o isana, la verea lara, “O to vere kamam hinia vara sava matamata natu, kama pa lo kilau matana, vara kama pa levosahia vara nom mele mai peresi na pongi hitahu mo pala.” ");
INSERT INTO tgp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu mo r̃aramira mara, “Ha lo kilau ha sopo tinar̃ihi tea i halu kamim, ");
INSERT INTO tgp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","matan tamlohi matuvana la pa mai na hijaku la pa verea vara enira natu pa Kr̃isto atu, la pa tikau leji na tamlohi matuvana. ");
INSERT INTO tgp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ale ha pa rongo na vuro peresi na sorasorahi vuro, pani ha sopo matahu matan harihi natu, i pa mai tiroma, pani pongi hitahu mo sopo lo pala. ");
INSERT INTO tgp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mara jara tavera tinatinapu la pa meresahi hinira, ale supe matea i pa meresahi na supe tinapua. Marua tavera i pa mai, ale mihi i pa hisuhi na jara matuvana. ");
INSERT INTO tgp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","La hinau tari sei la sohena tapulo rongohaji na epe har̃ai vara i lavilavi. ");
INSERT INTO tgp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ale la pa tauri kamim ha vano na rani r̃ilangi sati, la pa vilimatei kamim. Tamlohi tari na jara tavera na varama la pa hitesatihi kamim mata hijaku. ");
INSERT INTO tgp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Vao tavera la pa tinar̃ihi na nora rasua hin rani atu, ale la pa turuturuposi hinira, la pa hitesasatihira. ");
INSERT INTO tgp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ale pr̃ovet haluhalu matuvana la pa pala, la pa tikau leji na tamlohi matuvana. ");
INSERT INTO tgp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ale matan vaivaileu i pa tavera jea, opoia nona tamlohi matuvana la pa tihai. ");
INSERT INTO tgp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pani harepu mo lo turu r̃ilangi mo tikeli na pongi hitahu, i pa juri. ");
INSERT INTO tgp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ale tamlohi la pa retivujavujangi na Retir̃uhu matan mauri atu God mo aulu hinia isana mara jara tinatinapua na varama matan vara la pa levosahia, moiso pongi hitahu i pa pala. ");
INSERT INTO tgp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Vara ha hite hina lumiha sei God mo r̃ohu hinia, haratu sei pr̃ovet Daniel mo lo verea tuai moiso, vara mo turu na jara tapu na lolo Temple, hare mo lo evi reti nike i levosahi na r̃aramina, ");
INSERT INTO tgp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","mo r̃uhu vara la haratu la lo toho Judea la rovo la sahe na vutivuti. ");
INSERT INTO tgp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mo r̃uhu vara haratu mo lo toho aulu na pusa imana i pa sopo sevuti sivo na lolona vara i lavi nar̃ihi na nona hinahinau hinia, ");
INSERT INTO tgp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ale mo r̃uhu vara haratu mo lo voko na isa i pa sopo posi vara i ale na nona jaket. ");
INSERT INTO tgp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","I pa rani r̃ilangi isana har̃ai sei la pangepange peresi la haratu la pa lo vasusui na nora pipi hin rani atu! ");
INSERT INTO tgp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ha usiusi isan God vara nomim rovorovo i pa sopo jovi na taro hamariri teni na rani Sabbath. ");
INSERT INTO tgp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mo sopo lo te rani sohen rani r̃ilangi tavera atu, mo tapulo na pongi tiroma mo tikeli nake, ale i pa sopo mele tea sohena hin te rani. ");
INSERT INTO tgp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ale vara God i sopo lo vai la rani r̃ilangi atu evira la mele vejuveju, i pa sopo te tamlohi hatea i pa mauri. Pani matan la haratu God mo vir̃onira, enia i pa vai la rani atu evira la mele vejuveju. ");
INSERT INTO tgp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Moiso vara tea mo verea mara, ‘Ha kilau mai nike! Kr̃isto atu enia nahai, teni enia natu, sevano’ — mo vono, ha sopo rasua. ");
INSERT INTO tgp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Matan kr̃isto haluhalu peresi na pr̃ovet haluhalu la pa pala, ale la pa vai na matamata tatavera peresi na hinau mar̃urahi, matan vara la vaihitea vara la er̃i tikau leji la haratu Moli mo vir̃onira. ");
INSERT INTO tgp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ka hitea, mo sopo lo ranina tataholo pani na lo vere kamim hinia moiso. ");
INSERT INTO tgp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ale vara la verea isamim lara, ‘Ha kilau vano, enia natuvano na jara tano koru!’ — ha sopo vano atu! Teni vara la verea lara, ‘Ha kilau mai nike, enia nahai mo lo toho na lolo ima nike!’ — ha sopo rasua! ");
INSERT INTO tgp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Matan rani mata mele mai non Natun Tamlohi i pa mera sohena vaha sei mo vilasi, merana mo tai Opae mo sivo Marino. ");
INSERT INTO tgp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vara ko hite na karai la lo avu vano hin te jara, o pa levosahia vara te pahai mo mena atu. ");
INSERT INTO tgp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","La hinau r̃ilangi atu vara la vano moiso, ‘Vahatea purongo mera alo i pa tihai, vitu i pa sopo mele sile na memerana, vitusarasara la pa jovjovi na masapa, ale God i pa hutehi na suiha tari na tuka’. ");
INSERT INTO tgp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ale matamata matan Natun Tamlohi i pa pala na masapa aulu, ale tavtavui tari mata varama la pa tangi mata matahu, moiso la pa hite Natun Tamlohi i pa lo mai na telangi matan tuka na nona suiha peresi na merana tavera. ");
INSERT INTO tgp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","I pa r̃ule na nona angelo na tiv tavera mata trumpet matea, moiso la pa takonahi la haratu mo vir̃onira r̃alihi na varama na jara tari na masapa aulu na varama. ");
INSERT INTO tgp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ha lo levosahi na titileu mata vipahai fig: na rani rangana la lo sasar̃ira, ha pa levosahia vara taro mamasa mo lo mai. ");
INSERT INTO tgp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ale kamim sohena, vara ha hite la hinau nike, na lo verea isamim la lo tapulo masese, ha pa levosahia vara Natun Tamlohi mo lo mai mariviti moiso, mo lo turu na matarua. ");
INSERT INTO tgp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Varar̃uhu na verea isamim, vara pina nike sei mo lo mauri hin rani atu, la pa sopo er̃i tihai, vavano la hinau nike, la masese vevuhi tiroma. ");
INSERT INTO tgp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tuka enia varama la pa tihai, pani noku reti la pa sopo er̃i tihai hin te rani. ");
INSERT INTO tgp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pani rani atu tea i pa sopo er̃i levosahia vara enia sava rani teni aoa natu. Mo sopo te angelo na tuka, teni Natuna, pani Tama hasena purongo mo levosahia. ");
INSERT INTO tgp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hin rani atu Natun Tamlohi i pa mele mai, i pa sohena rani non Noah. ");
INSERT INTO tgp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Matan sohen hin pongi atu tuai wai tavera mo sopo lo lolovi na varama, tamlohi la lo vai na hanhani tavera, ale la lo vai na lahi, la lo tulatulahi vavano Noah mo unu na Ark. ");
INSERT INTO tgp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ale tamlohi la sopo levosahi na sava i pa mai mo sinai wai tatave tavera atu mo mai mo tivesi vevuhira. I pa sohen haratu hin pongi atu Natun Tamlohi i pa mele mai hinia. ");
INSERT INTO tgp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hin pongi atu, tamlohi mo rua la pa lo voko na isa, la pa lavi nar̃ihi matea, matea i pa lo toho. ");
INSERT INTO tgp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ale har̃ai mo rua la pa lo visi na flaua, la pa lavi nar̃ihi matea, matea i pa lo toho. ");
INSERT INTO tgp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ale matan haratu, ha tatamahu! Ka sopo levosahia vara sava rani natu, nomim Moli i pa mele mai hinia. ");
INSERT INTO tgp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ale ha lo levosahi hinau akerihi, vara tamlohi tavera mata ima matea i pa lo levosahi na sava aoa na vutepongi sei vara tamlohi vavanaho i pa mai hinia, i pa lo kilau, ale i pa sopo tinar̃ihia vara i unu na imana. ");
INSERT INTO tgp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ale matan haratu, kamim sohena ha tatamahu, matan ha pa sopo levosahi aoa atu Natun Tamlohi i pa mele mai hinia. ");
INSERT INTO tgp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Harepu natu, enia sohen volitusi lelevosahi matea, ale mo lo r̃omturu r̃ilangi tarea, vara nona tamlohi tavera mo vir̃onia vara i lo kilau na vao volitusi na imana matan vara i sile na hara hinau isara na rani tataholo? ");
INSERT INTO tgp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Avulahi tavera isan volitusi atu mo lo vai na sava nona tamlohi tavera mo verea hin rani atu vara i mele mai. ");
INSERT INTO tgp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Varar̃uhu, na verea isamim, tamlohi tavera atu i pa taua i aulu na nona hinahinau tari. ");
INSERT INTO tgp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pani vara volitusi sasati matea mo lo hase r̃omr̃omia vara, ‘Noku tamlohi tavera i pa sopo mai vila sei!’ ");
INSERT INTO tgp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Moiso mo tapulo tamaji na tatuana volitusi tinapua, ale mo lo hanhani, ale mo inu peresi la haratu la lo sasar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nona tamlohi tavera atu i pa pala na rani teni aoa sei volitusi atu mo sopo levosahia vara i pa pala hinia, ");
INSERT INTO tgp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ale i pa tai rotoa i taua peresi na tapnetano. Hin jara atu la pa tangtangi, ale la pa ngar̃ngar̃ori na hur̃ura mata rongohaji.” ");
INSERT INTO tgp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Hin pongi atu, mauri atu God mo aulu hinia i pa sohen har̃ai maevo mo sangavulu sei la lavi na nora lamu potele la vano vara la tapai na tamlohi i pa lahi. ");
INSERT INTO tgp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mo lima hinira la rongorongo vono, ale mo lima la lelevosahi. ");
INSERT INTO tgp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Matan la haratu la rongorongo vono lara la lavi na nora lamu potele, la sopo lavi te wel matara, ");
INSERT INTO tgp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","pani la haratu la lelevosahi la lavi na potele wel peresi na nora lamu potele. ");
INSERT INTO tgp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ale tamlohi vara i pa lahi mo sopo mai vila, ale la har̃ai maevo tari atu la tapulo peka, ale la juruvi. ");
INSERT INTO tgp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pani na livuha vutepongi la rongo na leo matea mo ulo mara, ‘Tamlohi i pa lahi nahai. Ha mai ha tapaia.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ale la har̃ai maevo atu la kilau, ale la tai nar̃ihi na korukoru pingo ruru na nora lamu potele vara lamu la mele memera i r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pani la haratu la rongorongo vono, la verea isan la haratu la lelevosahi lara, ‘Ha sile te nomim wel makomona isamam matan nomam lamu potele la lo tapulo mate.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pani la haratu la lelevosahi la r̃aramira lara, ‘Wel mo sopo tataholo hinir̃a mo isoiso. Ha vano na stoa ha voli te nomim!’ ");
INSERT INTO tgp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ale la pa lo vano vara la voli tea, tamlohi vara i pa lahi mo pala, ale la haratu la lo tatamahu la usuria la vano na hanhani lahi, ale la pelatihoro na matarua. ");
INSERT INTO tgp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mo sopo tuai la har̃ai maevo tinapua atu la pala lara, ‘Tamlohi tavera! Tamlohi tavera, o roi isamam!’ ");
INSERT INTO tgp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pani mo r̃aramira mara, ‘Varar̃uhu na verea isamim, na sopo levosahi kamim.’” ");
INSERT INTO tgp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iesu mo mele verea mara, “Matan hinau atu ha tatamahu, matan ka sopo levosahia vara sava rani teni aoa Natun Tamlohi i pa mele mai hinia.” ");
INSERT INTO tgp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mo mele verea mara, “I pa sohena tamlohi matea mo vano na nona hahau matea. Mo tovi na nona slev, ale mo tau na nona hinahinau na limara. ");
INSERT INTO tgp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Isan matea, mo silea na selen mo lima. Selen matea hinira, mo tataholo mata voli tamlohi matea mata voko mata rani i tari vahatea . Ale isan matea mo sile na selen mo rua, ale isan matea mo sile na selen matea. Mo silea isara mo tataholo na nora er̃ia, moiso mo malue mo vano na nona hahau. ");
INSERT INTO tgp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Haratu mo lo sile na selen mo lima isana tiroma, mo vano vahatea mo voko peresia, ale mo mele tikeli na selen mo lima tinapua. ");
INSERT INTO tgp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Haratu mo lo lavi na selen mo rua mo sohena mo mele tikeli na selen mo rua tinapua. ");
INSERT INTO tgp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pani haratu sei mo lo lavi na selen matea, mo vano mo heli na koko matea na lepa mo tavuni jarohi mania atu non nona tamlohi tavera. ");
INSERT INTO tgp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Rani matuvana la vano moiso, ale tamlohi tavera non la slev atu mo mele hilu vara i levosahia vara la vai na sava hin la mania atu. ");
INSERT INTO tgp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ale haratu mo lo lavi na selen mo lima mo juha mai isana, mo lavi na selen mo lima tinapua hin la haratu mo lo lavira tiroma mo verea mara, ‘Tamlohi tavera, ko sileau na selen mo lima; ale na mele vai na selen mo lima tinapua.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ale nona tamlohi tavera mo verea isana mara, ‘Ko vai na voko r̃uhu. Ko r̃omturu r̃ilangi na nom makomo hinau, ale nake a pa tauho o aulu na hinau mo mar̃ivi. O unu na avulahi tavera non nom tamlohi tavera.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ale haratu mo lo lavi na selen mo rua mo juha mai isana, mo lavi na selen mo rua tinapua hin la haratu mo lo lavira tiroma mo verea mara, ‘Tamlohi tavera, ko sileau na selen mo rua; ale na mele vai na selen mo rua tinapua.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ale nona tamlohi tavera mo verea isana mara, ‘Ko vai na voko r̃uhu. Ko r̃omturu r̃ilangi na nom makomo hinau, ale nake a pa tauho o aulu na hinau mo mar̃ivi. O unu na avulahi tavera non nom tamlohi tavera.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ale haratu mo lo lavi na selen matea mo juha mai isana mo verea mara, ‘Tamlohi tavera, na levosahia vara engko tamlohi r̃ilangi matea, ko lo lavi na vua pahai engko ko sopo lavoa. Ko lo takonahi na wit na jara engko ko sopo hapor̃ahi tea ea, ");
INSERT INTO tgp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ale na matahu, na vano na jarohi na nom mania na lepa. Nahai, o mele lavi na sava enia nom.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pani nona tamlohi tavera mo r̃aramia mara, ‘Engko tamlohi sasati, ko slev maloko vari. Ko r̃omi vara enau tamlohi r̃ilangi matea, ale na lo lavi na vua pahai na sopo lavoa, ale na lo takonahi na wit na jara na sopo hapor̃ahi tea ea? ");
INSERT INTO tgp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Vara mo sohena, i pa mele r̃uhu jea vara o lo tau na mania isana tamlohi bank matan vara a mele pala a pa er̃i lavi na noku mania peresi haratu makomona bank i pa mele silea aulu na noku mania.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ale mo verea isan te nona slev tinapua mara, ‘Ha lavi nar̃ihi selen atu isana, ha silea isan haratu mo lavi na selen mo sangavulu, ");
INSERT INTO tgp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","matan isan la haratu la lavi te hinau, la pa mele silera hin te hinau, ale i pa masurere isana. Pani isan haratu mo lekoleko, sava enia nona tiroma i pa lavi nar̃ihia. ");
INSERT INTO tgp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ale ha pulahi slev atu mo sopo r̃uhu hin te hinau hatea i vano na jara r̃or̃oha. Hin jara atu la pa tangtangi, ale la pa ngar̃ngar̃ori na hur̃ura mata hajhaji ea.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na rani vara Natun Tamlohi i mai na nona sasarami peresi na angelo tari, hin rani atu natu i pa sakele na nona jara sakele mata suiha nona Supe. ");
INSERT INTO tgp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mara jara tinatinapua na varama la pa turu na nahona moiso i pa asera hatehateahi sohena tavui sipsip matea mo lo ase na pulana sipsip na nani. ");
INSERT INTO tgp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ale i pa tau na sipsip na matuana, ale nani na marauna. ");
INSERT INTO tgp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ale i pa verea isan la haratu na matuana vara, ‘Ha mai, kamim sei Tamaku mo ler̃uhu hin kamim! Ha lavi mauri atu God mo aulu hinia sei mo tau mamahunia matamim tuai tiroma moiso mo pa vai na varama. ");
INSERT INTO tgp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Matan na marohati ka sileau na hanhani, na mar̃ohu ka sileau na inu, enau na vinano matea ka toviau na imamim, ");
INSERT INTO tgp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mo sopo te noku ruru ka sileau na ruru, na rojo ka mai ka rohiau, na lo toho na ima r̃ilangi, ale ka mai ka hiteau.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Moiso la tamlohi tataholo atu la pa r̃aramia vara, ‘Moli, nangisa kama hiteho ko marohati, ale kama vahaniho, teni ko mar̃ohu, ale kama sileho na wai? ");
INSERT INTO tgp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ale nangisa natu, kama pa hiteho ko vinano, ale kama toviho na imamam, teni ko malamala, ale kama ruruho? ");
INSERT INTO tgp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ale nangisa natu, kama hiteho ko rojo teni ko lo toho na ima r̃ilangi, ale kama rohiho?’ ");
INSERT INTO tgp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ale Supe i pa r̃aramira, vara ‘Varar̃uhu na verea isamim, na rani ko vaia te hinau mo r̃uhu isan te voraiku teni te vevorai rihirihi hatea, ko lo vaia isaku.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ale i pa verea isan la haratu na marauna vara, ‘Ha malue na nahoku, kamim ka lo toho na ruhuruhu lesati, ha unu na hapu matan tui tui atu na tatamahunia matan Tiapolo peresi na nona angelo sati, ");
INSERT INTO tgp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","matan na marohati, pani ka sopo sileau hin te hanhani, na mar̃ohu, pani ka sopo sileau hin te wai, ");
INSERT INTO tgp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","enau na vinano matea, pani ka sopo toviau na imamim, enau na malamala, pani ka sopo ruruau, na rojo, ale ka sopo mai vara ha rohiau, ale na lo toho na ima r̃ilangi, pani ka sopo mai isaku.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ale enira sohena la pa r̃aramia vara, ‘Moli, nangisa natu, kama hiteho ko marohati, teni ko mar̃ohu, teni ko vinano matea, teni ko malamala, teni ko rojo teni ko lo toho na ima r̃ilangi, ale kama sopo tueniho?’ ");
INSERT INTO tgp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ale i pa r̃aramira vara, ‘Varar̃uhu na verea isamim, matan ka sopo vai te hinau r̃uhu isan te voraiku rihirihi hatea ka sopo vaia isaku.’ ");
INSERT INTO tgp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ale la haratu, la pa vano la unu na talai matan tui tui, pani la haratu la tataholo la pa unu na mauri tui.’” ");
INSERT INTO tgp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu mara mo verea la hinau sei moiso mo verea isana nona tamlohi usuri mara, ");
INSERT INTO tgp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ka levosahia vara rani mo rua mo lo toho moiso rani Passover i pa mai, ale la pa sile Natun Tamlohi vara la vosaea na talopeilopei.” ");
INSERT INTO tgp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hin rani atu moli mata pr̃is peresi na tamlohi aulu nona tamlohi la pulutahi na ima tavera non pr̃is aulu sei, hijana Caiaphas, ");
INSERT INTO tgp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ale la hatihia jara matea vara la pa taurilati Iesu na malele halu vara la vilia. ");
INSERT INTO tgp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pani la verea lara, “I pa sopo na livuha hanhani Passover, matan vara i vono, tamlohi la pa lolokoru tavera, ale r̃a sopo er̃i vaira la toho malum.” ");
INSERT INTO tgp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ale hin rani atu Iesu mo lo toho Bethany na iman Simon, tamlohi lepros matea, ");
INSERT INTO tgp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iesu mo pa lo sakele na tepel ea, ale har̃ai matea mo mai isana, mo lo tauri na potele hasori matea la tovia alabaster, volina mo tavera jea, ale mo rengia na patuna. ");
INSERT INTO tgp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nona tamlohi usuri lara la hitea la lolokoru lara, “Mata sava mo lo surei komokomoa? ");
INSERT INTO tgp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Matan hinau sei o er̃i har̃ehia mata mania tavera, ale o silea isana tilavono.” ");
INSERT INTO tgp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pani Iesu mo levosahi na sava la lo verea, ale mo verea isara mara, “Mata sava ka lo ari har̃ai nike? Enia mo vai na hinau r̃uhur̃uhu matea isaku. ");
INSERT INTO tgp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Matan tilavono la pa lo toho peresi kamim tarea, pani enau a pa sopo toho peresi kamim tarea. ");
INSERT INTO tgp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Enia mo surei hasori nike na epeku matan vara i tatamahuni na epeku mata noku tavuni. ");
INSERT INTO tgp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Varar̃uhu na verea isamim, sava jara Retir̃uhu la pa sorahia ea na varama, la pa sorahi na sava mo vaia vara tamlohi la pa mele r̃omr̃omia.” ");
INSERT INTO tgp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ale vonan la tupu sangavulu r̃omana mo rua atu hijana Judas Iscariot mo vano isana moli mata pr̃is, ");
INSERT INTO tgp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","mo verea mara, “Ha pa sile na sava isaku vara a taua na limamim?” Ale la vuti la silea na silver selen mo ngavulu tolu. ");
INSERT INTO tgp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Moiso, mo tapulo hin rani atu mo tapulo aleale masapa vara i turuposi hinia. ");
INSERT INTO tgp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na rani tiroma mata hanhani tavera mata pereti mo sopo te isi hinia, tamlohi usuri la mai isan Iesu lara, “Ko opoia vara kama pa tatamahu epu vara o pa hani na Passover ea?” ");
INSERT INTO tgp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mo verea mara, “Ha unu na taon tavera, ale ha hite na tamlohi matea, ale ha verea isana vara, ‘Tija mo verea mara, noku rani mo mai mariviti, a pa hani na hanhani mata Passover peresi na noku tamlohi usuri na imam.’” ");
INSERT INTO tgp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ale nona tamlohi usuri la vaia sohena mo verea isara, ale la tatamahuni na hanhani Passover. ");
INSERT INTO tgp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ale na ravravi mo sakele na tepel peresi la tamlohi usuri tupu sangavulu r̃omana mo rua atu. ");
INSERT INTO tgp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ale la pa lo hanhani mo verea mara, “Varar̃uhu na verea isamim, vonamim matea i pa turuposi hiniau.” ");
INSERT INTO tgp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","La rongo mo sati, ale la tapulo verea isana enira hatehateahi lara, “Tija, enau teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mo r̃aramia mara, “Matea mo lo seri na pereti peresiau na pesin matea, i pa turuposi hiniau. ");
INSERT INTO tgp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Natun Tamlohi i pa vano na malele mata mateia sohen la ulia na Retiulia matana, pani rani r̃ilangi tavera isan haratu mo lo turuposi hin Natun Tamlohi. I pa mele r̃uhu jea isana vara tamlohi atu i sopo vora.” ");
INSERT INTO tgp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas haratu sei i pa turuposi hinia mo r̃aramia mara, “Tija, korong enau teni mo vono?” Iesu mo verea isana mara, “Engko ko hase vereho moiso.” ");
INSERT INTO tgp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ale lara la lo hanhani, Iesu mo lavi na pereti mo topea mo vere meje isan God matana, ale mo silea isana nona tamlohi usuri, ale mara, “Ha lavia, ha hania, enia epeku.” ");
INSERT INTO tgp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ale mo tauri na paniken matea, mara mo vere meje isan God, mo silea isara mara, “Ha inu hinia, kamim mo isoiso, ");
INSERT INTO tgp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","matan harihi enia r̃aeku mata retitauhi God mo vaia matan vara r̃aeku i pa roro matan vara i r̃omi na hehe nona tamlohi matuvana. ");
INSERT INTO tgp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na vere kamim hinia, enau a pa sopo mele inu waen nike i tikeli pongi atu a pa mele inua peresi kamim hin mauri atu Tamaku mo supe hinia.” ");
INSERT INTO tgp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lara la lalavete na vete matea moiso la malue la sahe na Vuti talu Olive. ");
INSERT INTO tgp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ale Iesu mo verea isara mara, “Kamim mo isoiso ha pa rovo hiniau nohorihi na vutepongi. Matan la ulia na Retiulia moiso vara, ‘A pa vilijovi na tavui sipsip ale sipsip la pa rovorovo.’ ");
INSERT INTO tgp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pani hitahu na noku sauteterahi, a pa vano tiroma hin kamim Galilee.” ");
INSERT INTO tgp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter mo r̃aramia mara, “Vara enira mo isoiso la rovo hiniho, enau a pa sopo er̃i rovo hiniho.” ");
INSERT INTO tgp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu mo verea mara, “Varar̃uhu na verea isam, hin vutepongi akerihi purongo, engko o pa vunvuniau vaha tolu, tiroma moiso toa vari i pa tarere.” ");
INSERT INTO tgp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter mo verea isana mara, “Vara a pa mate peresiho, a pa sopo vunvuniho!” Nona tamlohi usuri mo isoiso la verea sohena. ");
INSERT INTO tgp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Moiso, Iesu mo vano peresira na jara matea hijana Gethsemane, ale mo verea isana nona tamlohi usuri mara, “Ha sakele nike tako, a pa vano sevano a usiusi.” ");
INSERT INTO tgp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Moiso mo lavi Peter peresi la natun Zebedee atu mo rua John enia James, ale mo tapulo rongo mo sati, ale r̃omina mo sopo sakele. ");
INSERT INTO tgp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ale mo verea isara mara, “Mapuku mo rongo mo sati tavera vara i mate. Ha lo toho nike, ha lo kilau peresiau.” ");
INSERT INTO tgp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mo mele juha vano makomona, ale mo popovitoho na nahona na lepa, ale mo usiusi mara, “Tamaku, vara mo tataholo, o nar̃ihi rani r̃ilangi nike isaku, pani o sopo usuri na masaloku, o usuri na masalom purongo.” ");
INSERT INTO tgp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Moiso mo mele mai isana nona tamlohi usuri mo hitera la juruvi r̃omaliho. Mo verea isan Peter mara, “Kamim, ka sopo er̃i kilau peresiau mata aoa matea purongo? ");
INSERT INTO tgp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ha kilau, ha usiusi vara ha pa sopo er̃i jovi na rani vaihite sei la lo mai isamim, r̃omimim mo r̃uhu, pani na suihamim purongo ha sopo er̃i vaira.” ");
INSERT INTO tgp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mo mele sahe haruana vara i usiusi mara, “Tamaku, vara o sopo nar̃ihi paniken akerihi vavano a inua, o usuri na masalom.” ");
INSERT INTO tgp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ale mo mele mai isara mo hitera la juruvi r̃omaliho matan matara la puhoni. ");
INSERT INTO tgp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ale mo mele malue isara, mo vano mo mele usiusi hatoluna, mo mele verea la retireti atu tiroma mo lo verera. ");
INSERT INTO tgp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Moiso mo mai isana nona tamlohi usuri mo verea isara mara, “Ha pa juruvi, ale ha mapu hin te rani tinapua. Ka hitea, mariviti vara la turuposi hin Natun Tamlohi natu, ale i pa vano na lima tamlohi hehe. ");
INSERT INTO tgp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ha turu, r̃a lo vano! Ka hitea, tamlohi atu mo lo turuposi hiniau mo lo mai mariviti.” ");
INSERT INTO tgp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mo pa lo retireti, Judas mo pala, vonan la tupu sangavulu r̃omana mo rua atu matea peresi na vao tavera matea la tai isan moli mata pr̃is peresi na nora tamlohi aulu, ale la lo lavi na sita vuro peresi na maja. ");
INSERT INTO tgp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tamlohi turuposi atu mo pete verera na matamata matea moiso mara, “Haratu a pa pungosia, enia natu tamlohi atu; ha pa taurilatia.” ");
INSERT INTO tgp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ale mo mai isan Iesu vahatea mara, “Tija, mo r̃uhu!” Ale mo pungosia. ");
INSERT INTO tgp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu mo verea isana mara, “Tapala, o vai na sava ko mai vara o vaia.” Moiso la mai isana la tauria vara la taurilatia. ");
INSERT INTO tgp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ale vahatea purongo, vonan la haratu matea mo lo toho peresi Iesu mo r̃irahi na limana, mo reve nar̃ihi na nona sita vuro, ale mo langa na tavalu pero slev nona pr̃is aulu. ");
INSERT INTO tgp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Moiso Iesu mo verea isana mara, “O mele tau na nom sita na jarana. Matan haratu la lo lavi na sita vuro la pa mate na sita vuro. ");
INSERT INTO tgp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka sopo levosahia vara a er̃i tovi isan Tamaku vara i r̃ule na angelo i jeu 72,000, ale vahatea purongo la pa tingir̃a? ");
INSERT INTO tgp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pani sohena sava natu, hinau la pa masese sohena Retitapu mo verea vara i sohena?” ");
INSERT INTO tgp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hin rani atu Iesu mo verea isan vao atu mara, “Ka mai peresi na sita vuro peresi na maja sohena vara ka lo vano mata taurilati na tamlohi sasati matea? Tarea na lo sakele na lolo Temple na lo vujangi, pani ka sopo tauriau! ");
INSERT INTO tgp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pani la hinau sei la pala sohena matan vara Retitapu nona pr̃ovet tuai la pa masese.” Moiso nona tamlohi usuri tari la malue la rovo hinia. ");
INSERT INTO tgp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ale la haratu sei la lo taurilati Iesu la tiroma hinia mo vano na iman Caiaphas, enia pr̃is aulu, tamlohi vujangi mata leu peresi na nora tamlohi aulu la lo takonahi hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ale Peter mo lo usuria asau makomona, mo vano mo tikeli na rope iman pr̃is aulu atu, ale mo unu na lolona, ale mo lo sakele peresi na tamlohi kilau atu matan vara i pa hite na isoisona. ");
INSERT INTO tgp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ale moli mata pr̃is peresi na tamlohi tari tinapua mata council la lo aleale tamlohi vara la pa vere te retireti halu na sava Iesu mo lo vaia moiso matan vara la pa er̃i vilimateia matara, ");
INSERT INTO tgp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","pani mo sopo tea, hina purongo vara tamlohi halu mo mar̃ivi la turu na nahora. Hitahuna, mo rua la pala mai, ");
INSERT INTO tgp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","lara, “Tamlohi akerihi mo verea mara, ‘Enau a er̃i komo na Temple non God, ale a mele voroa na rani i tolu purongo.’” ");
INSERT INTO tgp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ale pr̃is aulu atu mo turu sahe mara, “O pa r̃aramia teni mo vono? Sava nahai la tamlohi nike, la lo retivuhesia matam?” ");
INSERT INTO tgp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pani Iesu mo lo turu tapanono. Ale pr̃is aulu mo verea isana mara, “Na usiho vara o retitauhi hin God mauri vara o vere kamam hinia vara engko natu, Kr̃isto atu Natun God?” ");
INSERT INTO tgp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu mo verea isana mara, “Engko ko pete verea moiso, pani na verea isam vara i pa sopo tuai o pa hite Natun Tamlohi i sakele na matua suiha na tuka, ale mo lo mai na telangi matan tuka.” ");
INSERT INTO tgp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Moiso pr̃is aulu mo r̃ari na nona ruru mara, “Mo lo vaia sohena enia God. R̃a sopo mele opoi te tamlohi tuetueni tinapua, ka pete rongo na nona reti hehe hin God nakerihi moiso. ");
INSERT INTO tgp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nomim aria i pa vano sohena sava?” La r̃aramia lara, “Mo tataholo vara i mate.” ");
INSERT INTO tgp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Moiso la litovi na nahona, la tuhia, ale hai la vojahia, ");
INSERT INTO tgp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","lara, “O reti mangovi isamam Kr̃isto, hare natu, mo tuhiho?” ");
INSERT INTO tgp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hinau atu mo lo vano, ale Peter mo lo sakele na jingoima na lolon ropen ima atu, ale slev har̃ai matea mo sinai isana mara, “Engko sohena, ko lo toho peresi Iesu mara Galilee atu!” ");
INSERT INTO tgp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pani mo vunvunia na nahon vao atu mara, “Enau na sopo levosahi na sava ko lo verea.” ");
INSERT INTO tgp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ale mara mo malue na matarua atu slev har̃ai tinapua matea mo hitea mo verea isan la haratu la lo turu mariviti isana mara, “Tamlohi nike, mo lo toho peresi Iesu mara Nazareth.” ");
INSERT INTO tgp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ale mele vahatea mo vunvunia na retitauhi matea mara, “Na sopo halu, na sopo levosahi tamlohi sei.” ");
INSERT INTO tgp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ale mo sopo tuai la haratu la lo turu ea la mai isan Peter lara, “Enjora, engko vonara matea matan leom mo vereuliho.” ");
INSERT INTO tgp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ale mo tapulo lesati hinia hasena moiso mo retitauhi mara, “Na sopo levosahi tamlohi sei.” Ale vahatea purongo toa vari matea mo tarere. ");
INSERT INTO tgp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Moiso Peter mo mele r̃omr̃omi na retireti non Iesu, “Toa i sopo lo tarere o pa vunvuniau vaha tolu.” Ale mo malue hin jara atu mo tangi r̃omina mo sati tavera. ");
INSERT INTO tgp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mo mele rani sahe na r̃alavuho jea, moli mata pr̃is tari peresi na tamlohi aulu nona tamlohi la pulutahi vara la vai nora r̃omr̃omi tavera vara la pa tau Iesu na mateia. ");
INSERT INTO tgp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ale la lihoa la tiroma hinia mo malue la taua na liman Pontius Pilate, tamlohi tavera matan Rome sei mo lo aulu hin Israel. ");
INSERT INTO tgp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Moiso Judas, haratu sei mo lo turuposi hinia mara mo hitea vara la pa sile na talai tavera isan Iesu, mo posi na r̃omina, ale mo mele lavi la silver selen atu mo ngavulu tolu mo hilu mo vano isana moli mata pr̃is peresi na tamlohi aulu, ");
INSERT INTO tgp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","mara, “Na vai na hehe matan na turuposi na r̃ae vokevoke.” Lara, “Kama sopo opoia vara kama levosahia, enia nom hinau.” ");
INSERT INTO tgp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ale mo pulahi la silver selen atu la sivo na lolo Temple, mo malue mo vano mo lihoa hasena. ");
INSERT INTO tgp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pani moli mata pr̃is la lavi la silver selen atu lara, “Vara r̃a mele taura na jara mania na Temple i pa tope na leu matan mania akerihi enia mania mata r̃ae.” ");
INSERT INTO tgp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ale la matavuhi la hatihia vara la pa lavi mania atu, la voli na lepa matea la tovia ‘Lepa non Potter’ matan vara la pa lo tavuni na tamlohi la sopo Jew hinia. ");
INSERT INTO tgp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Matana, lepa atu la tovi ‘Lepa mata R̃ae’ mo tikeli nake. ");
INSERT INTO tgp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ale sava reti pr̃ovet Jeremiah mo verea mo masese mara, ‘Ale la lavi na silver selen mo ngavulu tolu , voli mauri sei tatua natun Israel la hatihia vara mo tataholo hinia, ");
INSERT INTO tgp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ale la silera mata voli lepa non Potter sohen Moli God mo retileu hiniau’. ");
INSERT INTO tgp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Moiso Iesu mo turu na nahon tamlohi tavera matan Rome, ale tamlohi tavera atu mo usia isana mara, “Engko natu, Supe nona Jew?” Iesu mara, “Engko ko pete verea moiso.” ");
INSERT INTO tgp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pani moli mata pr̃is peresi na vajiahara sei la aulu lara la tuvaia hin te hinau, Iesu mo sopo r̃aramira. ");
INSERT INTO tgp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Moiso Pilate mo verea isana mara, “Ko sopo rongo na hinau matuvana sei la lo retivuhesia matam?” ");
INSERT INTO tgp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pani Iesu mo sopo r̃aramia, mo sopo r̃arami te tuvai hatelete, ale tamlohi tavera atu mo mar̃urahi tavera matana. ");
INSERT INTO tgp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hin rani atu, tarea na hanhani tavera, tamlohi tavera atu mo lo juri na tamlohi matea na ima r̃ilangi mo lo toho isana vao atu vara sava tamlohi vao atu mo opoia vara i pa juria. ");
INSERT INTO tgp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ale hin rani atu tamlohi sasati matea la levosahi mamahunia hijana Barabbas mo lo toho na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ale la tamlohi tavera atu lara la pulutahi moiso, Pilate mo verea isara mara, “Ka opoia vara a teri hare, Barabbas teni Iesu sei la tovia Kr̃isto?” ");
INSERT INTO tgp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mo vere haratu matan mo levosahia moiso vara la tau Iesu na limana mata nora mereimerei purongo. ");
INSERT INTO tgp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mo sopo haratu purongo, pani na rani mo pa lo sakele na nona jara sakele mata aria, narouna mo sohai na retisohai matea isana mara, “O sopo tikeli tamlohi vokevoke sei, matan r̃omiku mo sopo sakele matan noku mamavuho hinia nahapani mo sasati.” ");
INSERT INTO tgp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ale moli mata pr̃is peresi na vajiahara sei la aulu la haluhalu vao atu vara la usi Barabbas vara la pa komo Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tamlohi tavera atu mo mele verea isara mara, “Sahara hinira mo rua ka opoia vara a juria nomim?” Ale lara, “Barabbas!” ");
INSERT INTO tgp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate mo verea isara mara, “Vara sohena a pa vai na sava isan Iesu haratu la tovia Kr̃isto?” Enira mo isoiso lara, “Vosaea na talopeilopei!” ");
INSERT INTO tgp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ale mo verea mara, “Mata sava? Mo vai na sava hina sati?” Pani la mele ngara lara, “Ha vosaea na talopeilopei!” ");
INSERT INTO tgp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ale na rani Pilate mo hitea vara i pa sopo er̃i jeu na r̃omira, ale mara mo hitea vara tamlohi la tapulo lolokoru moiso pani mo hitea vara i pa sopo er̃i vaira la toho malum, mo lavi na wai, ale mo javulahi na limana na nahon vao atu mo verea mara, “Enau na vokevoke na r̃aen tamlohi nike: enia nomim hinau.” ");
INSERT INTO tgp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tamlohi tari hin vao atu la r̃aramia lara, “R̃aena i pa toho hin kamam peresi na natumam!” ");
INSERT INTO tgp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Moiso mo vai Barabbas mo materi usuri na r̃omira, ale nona tamlohi vuro la rupi Iesu na asi maja, moiso la lavia vara la vosaea na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Moiso tamlohi vuro non tamlohi tavera atu la lavi Iesu mo sivo na jara tavera matea na lolo patu ima non tamlohi tavera atu, ale la tovi matavuhi na tamlohi vuro matuvana la mai la turu na nahona, ");
INSERT INTO tgp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ale la nar̃ihi na nona ruru, la rua na ruru peravu matea majhina mo perpel, ");
INSERT INTO tgp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ale la viriviri na r̃ongor̃ongo matea la vaia na kaulu la taua na patuna, ale la tau na mavuro matea na matua limana, ale la popovitoho na nahona la lo vaivaia lara, “Ha kilaua! Supe nona Jew.” ");
INSERT INTO tgp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Moiso la litovia la lavi nar̃ihi mavuro atu, ale la lo hamaji na patuna hinia. ");
INSERT INTO tgp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ale lara la vaivaia mo isoiso, la nar̃ihi pa ruru peravu atu la mele rua na nona ruru, ale la tiroma hinia vara la vano la vosaea na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","La pa lo malue na malele, ale tamlohi vuro la tapai na tamlohi matea Simon mara Cyrene. La ngurunguru hinia vara i lavi na talopeilopei non Iesu. ");
INSERT INTO tgp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Moiso na rani la kakau na jara matea hijana Golgotha, — r̃aramin Golgotha enia Jara Sui Patu Tamlohi ");
INSERT INTO tgp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","la sile Iesu na waen la hohoia peresi na hinau matea mo hohona vara i inua, pani mara mo inu mo rongoa mo r̃ohu vara i inua. ");
INSERT INTO tgp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ale lara la vosaea na talopeilopei moiso, la asehi na nona ruru isara na nora roro matea. ");
INSERT INTO tgp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Moiso la sakele la lo kilaua la lo saovia hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","La vosae na retiaria matea aulu na patuna mo verea mara, Haranike nahai enia Iesu Supe nona Jew ");
INSERT INTO tgp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hin rani atu la vosae na tamlohi vili na tamlohi mata vavanaho mo rua tinapua na talopeilopei peresia, matea na matuana ale matea na marauna. ");
INSERT INTO tgp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ale la haratu la lo hahau roto jara atu la lo vaivaia, la lo pulapulahi na patura isana ");
INSERT INTO tgp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","lara, “Engko sei vara o pa komo na Temple, ale a pa mele voroa na rani i tolu purongo, o hasem juriho! Vara engko Natun God, o sevuti hin talopeilopei sei!” ");
INSERT INTO tgp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ale moli mata pr̃is peresi na tamlohi vujangi mata leu peresi na tamlohi aulu sohena la vaivaia lara, ");
INSERT INTO tgp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mo lo juri na tamlohi tinapua: mo sopo er̃i juria hasena. Enia Supe non Israel, r̃a hitea vara i sevuti nakerihi na talopeilopei, ale r̃a pa er̃i rasua. ");
INSERT INTO tgp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Enia mo tau na nona rasu hin God, mo r̃uhu vara God i pa juria nakerihi vara na masalona, matan mo lo verea mara, ‘Enau Natun God.’” ");
INSERT INTO tgp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ale la tamlohi mata vili na tamlohi mata vavanaho atu sohena la vaivaia hin malele atu. ");
INSERT INTO tgp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ale na livuha rani r̃or̃oha tavera matea mo tavuni na jara tari mo tikeli na matan alo mo tolu na ravravi. ");
INSERT INTO tgp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","mariviti na matan alo mo tolu na ravravi, Iesu mo ulo aulu na leo r̃ilangi matea mara, “Eli, Eli, lema sabatani?” R̃aramina, ‘Noku God, noku God, mata sava ko rovo hiniau?’ ");
INSERT INTO tgp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ale tamlohi hai la lo turu mariviti atu la rongoa lara, “Tamlohi nike, mo lo tovi Elijah.” ");
INSERT INTO tgp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ale vahatea purongo, vonara matea mo maro vano mo lavi na tavalu ruru matea la r̃ur̃unia na waen hohona, ale mo sohaia na mavuro mo sahe isana vara i inua. ");
INSERT INTO tgp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pani tatuara lara, “O lo saovi tako, r̃a pa hitea vara Elijah i pa sinai i juria teni i vono!” ");
INSERT INTO tgp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ale Iesu mo mele ulo r̃ilangi na leo tavera matea, ale maromarona mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ale vahatea purongo, ruru tavera atu na lolo Temple mo mar̃ari mo rua mo tapulo aulu mo tikeli atano. Ale lepa mo hisu, ale vatu la mavua. ");
INSERT INTO tgp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ale taptap la roi moiso, ale tapuhi matuvana non God sei la mate moiso la mele turu, ");
INSERT INTO tgp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ale la malue na tapura hitahu na sauteterahi non Iesu, ale la unu Jerusalem la pala isana tamlohi matuvana ea. ");
INSERT INTO tgp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na rani captain mata tamlohi vuro peresi la haratu la lo kilau saovi Iesu, lara la hite na mihi, ale sava mo masese, la mar̃urahi tavera jea lara, “Varar̃uhu, tamlohi nike, enia Natun God!” ");
INSERT INTO tgp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hin rani atu, har̃ai matuvana sei la tai Galilee la lo usuri Iesu la lo tuenia la lo turu asau la lo kilaua. ");
INSERT INTO tgp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mary Magdalene peresi Mary tinan James enia Joseph, ale tinan la natun Zebedee, James enia John, la lo toho hin vao atu. ");
INSERT INTO tgp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mo lo ravravi tamlohi tavtav matea mo tai Arimathea mo mai hijana Joseph, enia sohena tamlohi usuri non Iesu matea. ");
INSERT INTO tgp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Enia mo vano mo hite Pilate mo usia vara i er̃i lavi na tarapen Iesu. Ale Pilate mo retileu vara la silea isana. ");
INSERT INTO tgp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Moiso Joseph mo lavi tarape atu, mo leputia na ruru lulu matea mo vokevoke, ");
INSERT INTO tgp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ale mo taua na tapuna paro sei mo taia na vatu. Mo kuresi horo na vatu tavera matea na mataruan tapu atu, ale mo mele vano. ");
INSERT INTO tgp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary tinapua atu peresi Mary Magdalene la lo toho atu la lo sakele na tavalu taptap. ");
INSERT INTO tgp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mo mele rani sahe, hin rani atu mo usuri na rani mata Tatamahu mata Passover, moli mata pr̃is peresi na Pharisee la pulutahi na nahon Pilate. ");
INSERT INTO tgp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ale lara, “Tamlohi tavera, kama r̃omr̃omia vara tamlohi halu atu mo verea na rani mo pa lo mauri mara, ‘Rani i tolu i vano moiso, a pa mele turu’. ");
INSERT INTO tgp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Matana, o retileu vara la turuhoro na tapuna i tikeli na hatolu rani, vara i vono, nona tamlohi usuri la pa vano la vanaho na tarapena, ale la pa verea isana tamlohi vara, ‘Mo mele turu na nona mateia.’ Ale halu atu hitahu i pa mele sati jea i jeu haratu tiroma.” ");
INSERT INTO tgp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate mo verea isara mara, “Kamim nomim tamlohi kilau hai, ha vano ha kilau mamahunia sohena ha er̃i vaia.” ");
INSERT INTO tgp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ale la vano la kaluti horo na vatu mataruan taptap atu, ale la tau na tamlohi kilau la lo kilaua. ");
INSERT INTO tgp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabbath mo isoiso, ale mariviti vara i rani na r̃alavuho na Sunday, ale Mary Magdalene peresi Mary tinapua atu matea la vano vara la hitea na tapuna. ");
INSERT INTO tgp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vahatea purongo mihi tavera matea mo vili na jara, ale angelo non Moli God matea mo sevuti na tuka. Mo kuresi nar̃ihi vatu atu, ale mo lo sakele aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angelo atu mo memera sohena vaha, ale nona ruru mo lulu sohena katen. ");
INSERT INTO tgp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pa la tamlohi kilau atu la savaravara na matahu la jovi na lepa sohen la mate. ");
INSERT INTO tgp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angelo atu mo verea isan la har̃ai atu mara, “Ha sopo matahu! Na levosahia vara ka lo ale Iesu, haratu la vosaea na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Enia mo sopo toho nike. God mo sauteterahia moiso, mo mele mauri, mo sohen haratu Iesu mo verea vara i pa sohena. Ha mai, ha hite na jara sei la tau na tarapena ea. ");
INSERT INTO tgp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ha vila, ha vere na nona tamlohi usuri vara mo turu na mateia mo mele mauri, ale ha levosahia vara enia mo lo vano tiroma Galilee hin kamim. Ha vano atu, ha pa hitea ea. Hinau nike natu, na sinai vara a verea isamim.” ");
INSERT INTO tgp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pa la har̃ai la matahu, pani la avulahi tavera na rani la malue na tapuna, la maro vila vara la vano la verea isana nona tamlohi usuri. ");
INSERT INTO tgp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vahatea purongo Iesu mo tapaira mo sile na retioloolo isara. La vano mariviti isana, la popovitoho la tauri na palona, la lotua. ");
INSERT INTO tgp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Moiso Iesu mo verea mara, “Ha sopo matahu! Ha vere na noku tamlohi usuri vara la vano Galilee. La pa hiteau atu.” ");
INSERT INTO tgp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na rani la har̃ai atu la pa lo toho na malelera, ka levosahia, tamlohi vuro hai sei la lo kilau na tapuna, la vano la unu Jerusalem. La vere na hinau tari sei la masese isana moli mata pr̃is. ");
INSERT INTO tgp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ale matana, moli mata pr̃is lara la pulutahi peresi na vajiahara sei la aulu, la hatihia vara la pa sile te mania tavera luhu isana tamlohi vuro. ");
INSERT INTO tgp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","La verea isana tamlohi vuro lara, “Ha verea isana tamlohi tari vara tamlohi usuri non Iesu la mai na vutepongi la vanaho na tarapena na rani ka lo juruvi. ");
INSERT INTO tgp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Vara nomim tamlohi tavera i rongo hinau nike, kamam kama pa retireti isana. R̃omimim i sopo kaka hinia.” ");
INSERT INTO tgp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ale pa la tamlohi vuro atu la lavi pa mania atu la vaia sohen la verea isara. Ale Jew matuvana la pa lo vujangi na tatuara hin sorasorahina atu mo tikeli nake. ");
INSERT INTO tgp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ale la tamlohi usuri tupu sangavulu r̃omana matea atu non Iesu, la sahe na vutivuti matea Galilee, jara atu natu, Iesu mo verea vara i pa tapaira ea. ");
INSERT INTO tgp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ale lara la hitea, la lotua. Pani tatuara la lo r̃om rua. ");
INSERT INTO tgp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu mo mai isara, ale mo verea mara, “God mo sileau na suiha tari vara a aulu na tuka peresi na varama. ");
INSERT INTO tgp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ha vano isana mara jara tinatinapua na varama, ale ha vujangira vara la mai noku tamlohi usuri. Ha paptijo hinira na hijan Tama, Natuna peresi na Tanume Tapu, ");
INSERT INTO tgp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","moiso ha vujangira vara la taurilati na hinau tari sei na verea isamim moiso, ale ha lo levosahia, enau a pa toho peresi kamim tarea i tikeli na isoison pongi nike!” ");
INSERT INTO tgp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Harihi enia tapulo Retir̃uhu hin Iesu Kr̃isto, Natun God. ");
INSERT INTO tgp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sohen pr̃ovet Isaiah mo ulia mara, ‘Eh! Ko hitea? Na lo r̃ule na noku vahar̃ule vara i tiroma hiniho, i pa vai na malele la tataholo matam.’ ");
INSERT INTO tgp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Na jara hasetoho leona mo lo ulo mara: Ha vasahi na malelen Moli God! Ha tano na malelena i tataholo.’ ");
INSERT INTO tgp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ale John mo pala, mo lo paptijo na tamlohi na jara hasetoho matan Judea, mo lo retivujavujangi isana tamlohi vara la lavi na paptijo mata posi na hehe matan vara Moli i r̃omira. ");
INSERT INTO tgp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ale tamlohi tari na lolon Judea peresi Jerusalem, la lo vano vara la hite John, ale enia mo lo paptijo hin la haratu la lo taviti na nora hehe na wai Jordan. ");
INSERT INTO tgp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John mo ru na ruru la vaia na vulu camel, ale mo otioti na huri buluk; hana hinau enia hatpoha peresi na tau sugabag sei waina mo meji. ");
INSERT INTO tgp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ale mo lo retivujavujangi mara, “Tamlohi matea i pa mai hitahu hiniau mo aulu mo jeuau, enau na sopo tataholo vara a rautoho a lavi nar̃ihi na asi eve palona. ");
INSERT INTO tgp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Enau na lo paptijo hin kamim na wai purongo, pani enia i pa paptijo hin kamim na Tanume Tapu.” ");
INSERT INTO tgp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hin rani atu Iesu mo tai Nazareth na jara Galilee, mo mai atu ale John mo paptijo hinia na wai Jordan. ");
INSERT INTO tgp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesu mara mo malue na lolo wai, vahatea purongo tuka mo roi, ale John mo hite Tanume Tapu mo sinai atano sohena vomahe matea, ale mo tatau hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Leon God na tuka mo reti mara, “Engko Natuku r̃uhur̃uhu, enau na opoiho mo tavera jea, na avulahi tavera hiniho.” ");
INSERT INTO tgp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Vahatea purongo, Tanume Tapu mo tiroma hin Iesu vara i sahe na jara hasetoho. ");
INSERT INTO tgp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iesu mo lo toho atu mata rani mo ngavulu vati, Setan mo lo vaihitea. Iesu mo lo toho peresi na maji jala hin jara atu, ale angelo non God la lo matahia. ");
INSERT INTO tgp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mo sopo tuai, Supe Herod mo taurilati John, mo taua na ima r̃ilangi. Ale hitahuna, Iesu mo sivo Galilee, mo lo retivujavujangi na Retir̃uhu non God mara, ");
INSERT INTO tgp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Rani tataholo atu God mo lo vir̃onia mo mai moiso! Mauri atu God mo aulu hinia mo lo mai mariviti. Ha posi na nomim hehe, ale ha rasu Retir̃uhu nike!” ");
INSERT INTO tgp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na rani matea, Iesu mo lo hahau usuri na pahisa tasin Galilee, mo hite Simon enia tasina Andrew, la lo pulahi na tara matea na tasi matan enira tamlohi aleale maji. ");
INSERT INTO tgp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ale mo verea isara mara, “Ha mai ha usuriau. Enau a pa vai kamim ha mai tamlohi aleale tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Vahatea purongo, la tinar̃ihi na nora tara la usuria. ");
INSERT INTO tgp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesu mo mele hahau mo vano makomona, mo hite James natun Zebedee, enia tasina John la lo sakele na lolo botira, la lo tulai na nora tara. ");
INSERT INTO tgp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesu mo tovira ale vahatea purongo la tinar̃ihi tamara Zebedee na lolo botira peresi na nona volitusi ale la usuria. ");
INSERT INTO tgp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu tolu la tupu vati atu la sahe Capernaum, ale na Sabbath mo unu na ima lotu nona Jew, ale mo lo vujangira. ");
INSERT INTO tgp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","La haratu la lo tapurongo isana, la mar̃urahi tavera na nona vujangi, matan mo sopo vujangira sohena nora tamlohi vujangi mata leu matea pani sohena tamlohi matea nona vujangi mo sopo te retiusia matana. ");
INSERT INTO tgp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hin rani atu tamlohi matea tanume lumiha sasati matea mo lo toho hinia mo lo toho atu hin ima lotu atu, ale mo ulo isan Iesu mara, ");
INSERT INTO tgp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu mara Nazareth, ko opoia vara o vai na sava isamam? Ko mai vara o komo kamam teni! Enau na levosahia vara engko hare, engko haratu mo tapu non God!” ");
INSERT INTO tgp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pani Iesu mo savurahia mara, “Ha! O toho malum! O malue isana nakerihi!” ");
INSERT INTO tgp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ale tanume lumiha sasati atu mo hisuhi r̃ilangi na epen tamlohi atu moiso mo ulo aulu mo malue hinia. ");
INSERT INTO tgp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tamlohi tari hin ima lotu atu la mar̃urahi, ale la lo usiusira hasera hinia lara, “Avei, sava nahai? Vujangi paro matea peresi na suiha vahatea mo pala! Ka hitea mo retileu isana tanume lumiha sasati, ale vahatea purongo la oloolo hinia.” ");
INSERT INTO tgp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ale vahatea purongo retin la nona suiha atu mo r̃alihi na jara tari Galilee. ");
INSERT INTO tgp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ale Iesu mo malue hin ima lotu atu, mo vano mo unu na iman Simon enia Andrew, enia tolu James enia John. ");
INSERT INTO tgp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ale vepalihan Simon mo lo juruvi na vatana matan mo sereia mo tavera, ale la verea isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Moiso Iesu mo mai mo tauri na limana mo saua mo sakele, ale seserei atu mo rovo hinia, ale mo tapulo tatamahuni na hara hinau. ");
INSERT INTO tgp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na ravravin rani atu, tamlohi la lavi na tamlohi rojo tari peresi la haratu tanume sasati la lo toho hinira la mai isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tamlohi tari hin taon tavera atu la takonahi na mataruan ima atu. ");
INSERT INTO tgp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ale Iesu mo vai tihai na rojoa nona tamlohi matuvana, ale mo titiu nar̃ihi na tanume sasati matuvana. Mo sopo sile te masapa vara te tanume sasati i er̃i retireti matan enira la levosahia vara enia hare. ");
INSERT INTO tgp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na r̃alavuho jea mo pa lo r̃or̃oha, Iesu mo turu mo vano hasena na jara hasetoho matea vara i usiusi ea. ");
INSERT INTO tgp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ale Simon tolu la haratu la lo toho peresia la kilau alea, ");
INSERT INTO tgp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ale la tapaia la verea isana lara, “Eh! Tamlohi tari la lo aleho.” ");
INSERT INTO tgp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pani Iesu mo r̃aramira mara, “R̃a malue! R̃a vano hin te vanua tinapua matan vara a er̃i retivujavujangi na Retir̃uhu isara sohena, matan enau na tai na tuka na sinai na varama matan hinau atu natu.” ");
INSERT INTO tgp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iesu mo unu role na jara tari Galilee, mo lo retivujavujangi na nora ima lotu, ale mo lo titiu nar̃ihi na tanume sasati. ");
INSERT INTO tgp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tamlohi lepros matea mo mai isan Iesu, mo papaohi isana mo usia r̃ilangi mara, “Vara o opoia, o er̃i vaiau a mele vokevoke.” ");
INSERT INTO tgp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu mo r̃omopoia mo tavera, ale mo tau na limana hinia mara, “Na opoia. O mele vokevoke!” ");
INSERT INTO tgp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Vahatea purongo, lepros atu mo tihai, ale mo mele vokevoke. ");
INSERT INTO tgp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Moiso Iesu mo reti r̃ilangi isana, ale mo r̃ulea vano mara, ");
INSERT INTO tgp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“O tapurongo! O sopo vere te hinau isan tea, pani o vano o hase vujangiho isana pr̃is, ale o sile na nom otori sohen Moses mo retileu hinia matan vara la er̃i hitea vara ko mele vokevoke.” ");
INSERT INTO tgp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pani mo turu mo vano mo lo sorahia, ale nona sorasora mo vano r̃alihi, ale mo vaia Iesu i sopo er̃i mele unu hin te taon tamlohi la sopo levosahia, pani mo lo toho na jara hasetoho ale tamlohi la lo mai na jara tari vara la tapaia atu. ");
INSERT INTO tgp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Te rani la vano moiso Iesu mo mele vano Capernaum, ale mo sopo tuai tamlohi lo la verea lara mo mele mai na ima moiso. ");
INSERT INTO tgp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Vila r̃uhu purongo mo sopo mele te masapa na lolo ima teni na mataruana. Ale Iesu mo lo retivujavujangi na reti non God isara. ");
INSERT INTO tgp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ale, tamlohi tupu vati la ali na tamlohi papao matea mo mai. ");
INSERT INTO tgp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ale matan la sopo er̃i vano mariviti isana, la sahe aulu na pusa ima, la vai na marole matea mo sivo tataholo hinia, ale la tuhu pa tamlohi papao atu na epana mo sivo na nahon Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu mara mo hite na rasua hin hinau atu la lo vaia, mo verea isan tamlohi papao atu mara, “Natuku, na r̃omi na nom hehe.” ");
INSERT INTO tgp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pani tamlohi vujangi mata leu hai la lo sakele atu, la lo vereverea isara hasera lara, ");
INSERT INTO tgp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mata sava tamlohi nike mo lo retireti sohen haratu? Mo lo vaia sohena enia God. God hasena i er̃i r̃omi na hehe.” ");
INSERT INTO tgp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ale Iesu mara mo levosahia vara la lo usiusira hinia isara hasera ale, mo verea isara mara, “Mata sava ka lo r̃omr̃omi na hinau sohena? ");
INSERT INTO tgp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sava hinau mo mele malum vara a verea isan tamlohi papao nike, ‘Na r̃omi na nom hehe!’ teni a verea vara, ‘O turu! O viriviri na epam, o hahau!’ ");
INSERT INTO tgp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pani matan vara ha pa levosahia vara Natun Tamlohi mo lavi na suiha vara i r̃omi na hehe nona tamlohi na varama, ha tapurongo na sava a pa verea!” Moiso Iesu mo verea isan tamlohi papao atu mara, ");
INSERT INTO tgp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“O turu, o lavi na epam, o mule!” ");
INSERT INTO tgp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tamlohi papao atu mo turu vahatea, mo lavi na epana ale mo hahau mo malue na nahora, ale mo vaira enira mo isoiso la mar̃urahi ale la tahe na hijan God lara, “Hare mo pete hite te hinau sohen harihi moiso?” ");
INSERT INTO tgp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu mo mele sivo na pahisa tasi, ale tamlohi tari la lo mai isana, ale mo lo vujangira. ");
INSERT INTO tgp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ale mara mo lo hahau atu mo hite Levi natun Alphaeus mo lo sakele na jara mata lavi na takis, ale mo verea isana mara, “O usuriau!” Levi mo turu vahatea, mo usuria. ");
INSERT INTO tgp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hin vutepongi atu na iman Levi, Iesu mo lo hanhani peresi na tamlohi matuvana mata lavi na takis peresi na tamlohi hehe tolu na nona tamlohi usuri, matan tamlohi matuvana sohera la lo usuri Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pani tamlohi vujangi mata leu peresi na Pharisee lara la hite Iesu mo lo hanhani peresi na tamlohi hehe tolu na tamlohi mata lavi na takis, la vere isana nona tamlohi usuri, lara, “Mata sava mo lo hanhani peresi na tamlohi mata lavi na takis tolu na tamlohi hehe?” ");
INSERT INTO tgp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ale Iesu mara mo rongoa mo verea isara mara, “La haratu epera la lo r̃uhu la sopo opoi na doctor, pani la haratu la rojo purongo. Na sopo mai vara a tovi na tamlohi tataholo pani la haratu la hehe.” ");
INSERT INTO tgp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hin rani atu, tamlohi usuri non John tamlohi paptijo peresi na Pharisee la tapuhoro na hanhani mata usiusi. Tamlohi hai la mai isan Iesu, la usia lara, “Mata sava tamlohi usuri non John peresi la haratu la lo usuri na Pharisee la lo tapuhoro na hanhani mata usiusi, pani nom tamlohi usuri la sopo tapuhoro na hanhani?” ");
INSERT INTO tgp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ale Iesu mo verea isara mara, “Ka r̃omr̃omia vara la tamlohi atu sei la mai na lahi la pa tapuhoro na hanhani vara tamlohi lahi mo lo toho peresira? Vara tamlohi lahi mo lo toho peresira, la sopo er̃i tapuhoro na hanhani. ");
INSERT INTO tgp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pani rani matea mo lo mai vara la pa lavi nar̃ihi na tamlohi lahi isara. Hin rani atu natu, la pa tapuhoro na hanhani.” Iesu mo mele verea mara, ");
INSERT INTO tgp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Te tamlohi i sopo er̃i lavi te tavalu ruru paro hatea i silivi na ruru tuai hinia. Vara i vaia sohena, tavalu ruru paro atu i pa vaia i mar̃ari tavera i jeu haratu tiroma. ");
INSERT INTO tgp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Te tamlohi i sopo er̃i titisi na waen paro i sivo na jara waen la vaia na huri nani tuai matan waen paro atu i pa sosohi i r̃ari jara waen atu, ale i pa komoa peresi waen atu matan i pa roro nar̃ihi. Waen paro mo tataholo na jara waen la vaia na huri nani paro purongo.” ");
INSERT INTO tgp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na Sabbath matea, Iesu mo lo hahau role na isa wit matea tolu na nona tamlohi usuri, ale la lo tapulo vesi roto na pere wit. ");
INSERT INTO tgp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ale Pharisee la verea isan Iesu lara, “Eh! Mata sava la lo vai na hinau matea mo sopo tataholo vara la vaia na Sabbath?” ");
INSERT INTO tgp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ale Iesu mo verea isara mara, “Avei, korong ka sopo lo evi na sava supe David tolu na nona tamlohi la vaia hin rani atu la vejuveju ale la marohati, ");
INSERT INTO tgp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ale sohena sava mo unu na Iman God na rani non Abiathar enia mo lo pr̃is aulu, moiso mo lavi pereti atu sei mo tapu pr̃is hasera la er̃i hania. David mo hania, ale mo silea isan la haratu la lo toho peresia?” ");
INSERT INTO tgp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ale mo verea isara mara, “God mo tau na Sabbath vara i tueni na tamlohi, mo sopo taua vara tamlohi la lo toho mata Sabbath. ");
INSERT INTO tgp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Matan haratu, Natun Tamlohi enia mo Moli mata Sabbath.” ");
INSERT INTO tgp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na Sabbath tinapua matea, Iesu mo mele unu na ima lotu nona Jew matea, ale tamlohi lima kuti matea mo lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ale meresahi non Iesu la lo kilau Iesu vara i pa vai mamahuni tamlohi atu na Sabbath teni, matan vara la pa tuvaia matana. ");
INSERT INTO tgp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu mo verea isan tamlohi lima kuti atu mara, “O mai nike!” ");
INSERT INTO tgp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ale mo verea isara mara, “Na Sabbath, mo tataholo vara r̃a tueni na tamlohi teni vara r̃a komo tea? Mo tataholo vara r̃a juri te mauri teni r̃a vilia?” Pani la r̃ohu vara la r̃aramia. ");
INSERT INTO tgp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu mo kilau r̃alihira na lolokoru, matan mapura mo r̃ilangi, ale mo verea isan tamlohi lima kuti atu mara, “O r̃irahi na limam.” Tamlohi atu mo vaia sohena ale limana atu mo mele r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pa la Pharisee atu la malue vahatea, la vano la tovi takonahi na tamlohi la lo usuri supe Herod, ale la aleale malele matan vara la pa vilimatei Iesu hinia. ");
INSERT INTO tgp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu tolu na nona tamlohi usuri la malue, la sivo na tasin Galilee, ale vao tavera matea mo usuria. La tai Galilee, Judea, ");
INSERT INTO tgp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumaea, hai la tai na tavalu wai Jordan, ale na jara r̃alihi Tyre enia Sidon. Vao tavera atu lara la rongo la hinau atu Iesu mo lo vaira, la mai isana. ");
INSERT INTO tgp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ale hin jara atu Iesu mo vere na nona tamlohi usuri vara la tau mamahuni te boti hatea matana matan vao tavera atu, vara i vono la pa tohoia, ");
INSERT INTO tgp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","matan Iesu mo vai tihai na rojoa nona tamlohi matuvana moiso, mo vai la haratu la rojo la lo vartohoi r̃alihia vara la tikelia. ");
INSERT INTO tgp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ale tanume lumiha sasati na tamlohi lara la hitea, la jovi sivo na nahona la ngara lara, “Engko Natun God!” ");
INSERT INTO tgp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pani Iesu mo reti r̃ilangi isara vara la sopo vereulia vara enia hare. ");
INSERT INTO tgp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Moiso, Iesu mo sahe aulu na vutivuti matea, ale mo tovi la haratu mo opoira, ale la mai isana. ");
INSERT INTO tgp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ale mo vir̃oni na tupu sangavulu r̃omana mo rua sei mo tovira vara la vahar̃ule, matan vara i pa r̃ulera la vano isana tamlohi mata retivujavujangira, ");
INSERT INTO tgp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ale mo silera na suiha mata titiu nar̃ihi na tanume sasati. ");
INSERT INTO tgp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mo vir̃oni la tupu sangavulu r̃omana mo rua atu sohen harihi: Simon sei Iesu mo tau na hijana vara Peter. ");
INSERT INTO tgp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James enia John natun Zebedee, Iesu mo silera na hija vara Boanerges' r̃aramina, ‘Natu Piri’ matan jingora mo lo tupali tarea. ");
INSERT INTO tgp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James natun Alphaeus, Thaddeus, Simon mara Cana enia tamlohi matea mata valum mata jarana, ");
INSERT INTO tgp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ale Judas Iscariot, haratu mo lo turuposi hinia. ");
INSERT INTO tgp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Moiso Iesu mo mele vano hin ima atu mo lo toho hinia. Mo sopo tuai vao tavera la mele mai la takonahi, ale la vaia mo sopo te masapa vara la er̃i hanhani. ");
INSERT INTO tgp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tavtavuin Iesu lara la rongoa, la vano vara la taurilatia matan la lo verea lara, “Hara sei, r̃omina mo tihai sei!” ");
INSERT INTO tgp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ale tamlohi vujangi mata leu sei la tai Jerusalem la lo verea lara, “Tamlohi sei, supe nona tanume sasati sei Beelzebul mo sohonia, ale mo lo titiu nar̃ihi na tanume sasati na suihana!” ");
INSERT INTO tgp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pani Iesu mo tovira mai isana ale mo verea mara, “Mo sohena sava natu Setan i er̃i mele levuti nar̃ihi Setan? ");
INSERT INTO tgp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jara tari sei supe la lo aseasehira hinira hasera la pa maroi, ale i pa sopo te taon tavera teni te vao ima vara i lo aseasehia hasena i pa er̃i turu. ");
INSERT INTO tgp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Vara vao ima matea i lo levuti na vaona, tamlohi hinia la pa er̃i toho r̃uhu sohena sava? ");
INSERT INTO tgp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ale Setan peresi na vaona vara la lo levlevutira hasera purongo, suihan Setan i pa turu sohena sava matan suihana i pa isoiso. ");
INSERT INTO tgp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ka hitea? Vara tamlohi matea mo opoia vara i unu na ima tamlohi suiha matea mata i vanaho te nona hinahinau, i pa lavi te asi hatea i pesi tamlohi suiha atu tako, moiso i pa lavi na nona hinahinau. ");
INSERT INTO tgp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Varar̃uhu, na verea isamim vara hehe tari tamlohi la lo vaira teni na nora retisasati hin God, God i pa r̃omira. ");
INSERT INTO tgp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pani hare mo lo vere lejileji Tanume Tapu, enia, God i pa sopo er̃i r̃omia hin te rani.” ");
INSERT INTO tgp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu mo lo verera hin la hinau sei matan la lo verea vara tanume sasati lumiha matea mo lo toho hinia. ");
INSERT INTO tgp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tinan Iesu peresi na voraina la pala hin ima atu, la lo turu na jingoima ale la sohai na reti sivo isan Iesu vara i mai i hitera. ");
INSERT INTO tgp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Vao matea mo lo sakele r̃alihi Iesu ale la verea isan Iesu lara, “Eh! Tinam peresi na voraim peresi na vevoraim la lo toho na jingoima la lo aleho!” ");
INSERT INTO tgp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pani Iesu mo r̃aramira mara, “Tinaku enia hare? Voraiku enira hare?” ");
INSERT INTO tgp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mo kilau r̃alihi la haratu la lo sakele r̃alihia mara, “Ka hitea? Tinaku peresi na voraiku enira nahai! ");
INSERT INTO tgp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sava tamlohi mo lo vai na masalon God, enia voraiku teni vetasiku teni tinaku.” ");
INSERT INTO tgp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na rani tinapua matea, Iesu mo lo vujangi na tamlohi na pahisa tasin Galilee. Hin rani atu vao tamlohi la lo mai la lo turu porotia. Ale matana, mo vele na boti matea mo lo sale hin tasi atu, ale mo sakele hinia. Vao tavera atu la lo toho na jarauta na pahisa tasi. ");
INSERT INTO tgp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu mo lo vujangira na titileu matuvana, ale mo lo vujangira mara, ");
INSERT INTO tgp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ha tapurongo! Tamlohi hapor̃ahi matea mo malue mo vano vara i hapor̃ahi na pulana piri wit. ");
INSERT INTO tgp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mo lo hapor̃ahira, pani hai la jovi na malele tavera, maji avuavu la mai la hani vevuhira. ");
INSERT INTO tgp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hai la jovi na vatuvatu, uluara la vila, matan tano mo sopo tavera. ");
INSERT INTO tgp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pani alo mara mo vele, la wit atu la nunu la mate mata warira la sopo sivo atano jea. ");
INSERT INTO tgp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hai la jovi na urata, pani urata atu mo rovira mo punira ale la sopo vua. ");
INSERT INTO tgp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pani hai la jovi na tano r̃uhu, hin tano r̃uhu atu la ulua. La ulua la vai na vuara, hai namara mo ngavulu tolu , hai mo ngavulu limarave , hai mo ngavulu sangavulu !” ");
INSERT INTO tgp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesu mo mele verea mara, “Haratu mo er̃i rongovosahia, o tapurongo!” ");
INSERT INTO tgp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hitahuna, mara mo lo toho enia hasena, tamlohi hai peresi la nona tamlohi usuri tupu sangavulu r̃omana mo rua atu la usia hin la titileu atu. ");
INSERT INTO tgp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ale Iesu mo verea isara mara, “God mo majinga hin kamim vara ha levosahi na r̃aramin mauri atu God mo aulu hinia, pani na lo vere la hinau nike na titileu vara a jarohira isana vinano, ");
INSERT INTO tgp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","matan vara Retiulia i masese sei mara, ‘La pa hite na sava na lo vaia, pani la pa sopo er̃i hitevosahia. La pa rongo na noku reti, pani la pa sopo er̃i rongovosahia. Matan, vara i vono, la pa posi mai isaku ale a pa r̃omira na nora hehe.’” ");
INSERT INTO tgp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesu mo verea isara mara, “Ka sopo rongovosahi titileu akerihi? Vara mo vono, sohena sava natu ha pa er̃i levosahi vevuhi na titileu tinapua? ");
INSERT INTO tgp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tamlohi hapor̃ahi na piri mo hapor̃ahi na reti non God. ");
INSERT INTO tgp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ale la haratu la jovi na malele tavera, hin rani atu tamlohi la rongora, Setan mo mai vahatea purongo ale mo lavi nar̃ihi la reti atu sei la lo toho na mapura. ");
INSERT INTO tgp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","La haratu la lo jovi na vatuvatu, enira la haratu sei lara la rongo na reti non God, la lavia vahatea purongo na avulahi. ");
INSERT INTO tgp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pani mo sopo te warira ale reti non God mo lo toho mata makomo rani purongo. Ale vara rani r̃ilangi la mai teni tamlohi la turuleji hinira mata reti non God, la jovi nar̃ihi vahatea purongo. ");
INSERT INTO tgp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ale la haratu la lo jovi na urata, enira la haratu sei la lo rongo na reti non God, ");
INSERT INTO tgp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pani r̃omkaka mata varama peresi na tavtav haluhalu ale masalora mata hinau tinatinapu mo unu hinira mo puni pa reti atu la lo lavia, ale mo sopo er̃i vua. ");
INSERT INTO tgp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ale la haratu la lo jovi na tano r̃uhu, enira la haratu sei la lo rongo na reti non God, ale la lavia na maurira ale la avulahi hinia. Mo vua mo tikeli mo ngavulu tolu , hai mo ngavulu limarave , ale hai la tikeli mo ngavulu sangavulu .” ");
INSERT INTO tgp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu mo mele verea isara mara, “Ka r̃om vara mo tataholo vara tea mo hasahi te lamu ale i taua na ruhuruhun te tanga teni te vata pani mo sopo na jara sakele mata lamu? ");
INSERT INTO tgp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hinau tari la lo luhu, la pa pala na jara tavera. Ale mo sopo te hinau luhu hatea vara i pa sopo pala na jara tavera. ");
INSERT INTO tgp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Vara tea te perona, i lo rongo na noku reti!” ");
INSERT INTO tgp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu mo mele verea isara mara, “Ha tapurongo na noku retireti i r̃uhu matan vara nomim lelevosahi i pa ulua i tavera. ");
INSERT INTO tgp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Haratu mo lo vaihitea vara i levosahi na noku reti, enia i pa er̃i mele levosahia i tavera i mar̃ivi jea. Pani haratu mo sopo tapurongo i r̃uhu, sava mo lo toho isana moiso la pa lavi nar̃ihia isana.” ");
INSERT INTO tgp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu mo mele verea mara, “Mauri atu God mo aulu hinia mo sohena piri vipahai tamlohi mo hapor̃ahira na lepa. ");
INSERT INTO tgp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Vara mo hapor̃ahira moiso, i pa sopo er̃i mele vai te hinau hinira. Tamlohi atu mo lo juruvi ale mo lo mele kilau na rani hatehateahi, ale piri atu mo tupali ale mo ulua pani tamlohi atu mo sopo levosahia vara mo pa sohena sohena sava. ");
INSERT INTO tgp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lepa atu hasena mo vai la piri atu la ulua. Tiroma la juliha, ale lahora la peravu, ale mo sopo tuai la vira, la vua. ");
INSERT INTO tgp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pani vara vuana la mena, tamlohi atu i pa vura na sita matan nora asitauni natu.” ");
INSERT INTO tgp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu mo mele verea mara, “A pa tovongi na sava hin mauri atu God mo aulu hinia, teni sava titileu natu i pa tataholo vara a vereulia hinia? ");
INSERT INTO tgp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mo sohena piri paka matea vara la lavoa na lepa, mo rihirihi mo jeu na piri pahai tari. ");
INSERT INTO tgp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pani vara mo ulua mo tavera mo jeu na vipahai tinatinapua tari, ale mo sohai na rangarangana tavera matan vara maji avuavu la er̃i vai na taura na malumaluna.” ");
INSERT INTO tgp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu mo lo vujangi na nona reti na titileu matuvana sohen harihi, matan vara la pa rongovosahira usuri na nora lelevosahi. ");
INSERT INTO tgp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iesu mo lo vujangi na vao tamlohi na titileu purongo, pani hitahu vara mo lo toho hasena peresi na nona tamlohi usuri, mo pa lo vereuli na r̃aramira isara. ");
INSERT INTO tgp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iesu mo lo toho hin boti atu, ale alo mara mo pa lo sivo vara i tihai, mo verea isara mara, “R̃a sua roto tasi nike, r̃a vano na tavaluna.” ");
INSERT INTO tgp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","La tinar̃ihi vao atu ale la vano, pani mo sopo enira hasera purongo, boti tinapua hai sohena la lo usurira. ");
INSERT INTO tgp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mo sopo tuai langi tavera matea mo sere, mo vai na suhusuhu la lo kamekame sivo na lolo boti, ale tungu mo lo mar̃ivi. ");
INSERT INTO tgp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pani Iesu mo lo juruvi na elunga matea na pulo boti. Ale nona tamlohi la r̃ohaia lara, “Tija! Ko sopo levosahia vara r̃a pa pute!” ");
INSERT INTO tgp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu mo kilau ale mo reti r̃ilangi isan langi atu, ale mo verea isan tasi atu mara, “Ha isoiso! Ha toho malum!” Vahatea purongo langi atu mo moti, ale tasi tavera atu mo tamata mo tamata. ");
INSERT INTO tgp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu mo verea isara mara, “Ka matahu tavera sohena mata sava? Mo sopo lo te nomim rasua teni?” ");
INSERT INTO tgp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ale matahu tavera mo sohonira ale la lo verea isara hasera lara, “Avei, sava tamlohi nahai? Mo reti purongo ale langi peresi na tasi la oloolo hinia!” ");
INSERT INTO tgp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu peresi na nona tamlohi la hoso na jara Gerasenes. ");
INSERT INTO tgp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lara la hoso na jarauta hin jara atu, tamlohi matea tanume lumiha sasati matuvana la lo toho hinia mo malue na taptap, mo sinai mo tapaia. ");
INSERT INTO tgp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tamlohi nike mo lo toho na taptap, ale tea i sopo er̃i pesia hin te asi teni te jen. ");
INSERT INTO tgp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hina purongo vara la pesi na limana peresi na palona na jen teni te aen, mo rotorotora mo kamekamera. Tea i sopo er̃i vaia i toho malum. ");
INSERT INTO tgp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na rani peresi na vutepongi hatehateahi, mo lo ulo r̃alihi na taptap peresi na vutivuti atu, ale mo lo tangi mo lo hasena tai na epena na vatu. ");
INSERT INTO tgp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ale mara mo hite Iesu mo pa lo toho asau, mo maro vano isana mo jovi papaohi na nahona. ");
INSERT INTO tgp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ale mo tangi na leo tavera matea mara, “Iesu Natun God Aulu Jea, engko te nom sava isaku? Na usiho na hijan God vara o sopo vailejilejiau!” ");
INSERT INTO tgp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mo pa verea sohena matan Iesu mo lo verea isana mara, “Tanume lumiha sasati, o malue isan tamlohi nike nakerihi!” ");
INSERT INTO tgp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu mo usia mara, “Eh, engko hijam hare?” Tanume sasati atu mo r̃aramia mara, “Hijaku enia Legion, matan kamam kama vao tavera jea!” ");
INSERT INTO tgp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tanume sasati atu mo usia r̃ilangi isan Iesu vara i sopo levuti nar̃ihira na jara Gerasenes. ");
INSERT INTO tgp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ale vao tavera mata poi matea la lo susua na pahisan vuti atu. ");
INSERT INTO tgp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ale tanume sasati atu la usia r̃ilangi isan Iesu lara, “O r̃ule kamam kama vano isana poi, o tinar̃ihi kamam kama unu hinira.” ");
INSERT INTO tgp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ale Iesu mo tinar̃ihira. La tanume lumiha sasati atu la malue isan pa tamlohi atu, la vano la unu isan la poi atu, evira korong mo tikeli tari vaha rua . Ale vao poi atu la solesole usuri pesapesa atu la jovi sivo na tasi ale la pute enira mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tavuin la poi atu la rovo la sahe la verea na lolon taon tavera atu peresi na jara r̃alihi ea. Ale tamlohi la maro la mai vara la hitea vara sava natu mo masese atu. ");
INSERT INTO tgp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ale la mai isan Iesu, pani lara la hite pa tamlohi atu sei tanume sasati la lo sohonia mo lo sakele ea ale mo ru na ruru, ale r̃omina mo mele r̃uhu moiso, matahu mo sohonira. ");
INSERT INTO tgp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ale la haratu sei la lo hite na sava mo masese la sorahi na sava mo masese isan tamlohi atu sei tanume sasati la lo toho hinia peresi la poi atu. ");
INSERT INTO tgp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ale la tapulo usia r̃ilangi isan Iesu vara i malue na jarara. ");
INSERT INTO tgp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu mo pa lo vele na boti, pa tamlohi atu sei tanume sasati la lo sohonia mo usia r̃ilangi isan Iesu vara i pa usuria. ");
INSERT INTO tgp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pani Iesu mo sopo tinar̃ihia pani mo verea isana mara, “O mule, o vano isana tapalam ale o verea na sava Moli God mo vaia matam, ale sohena sava mo r̃omopoiho mo tavera jea.” ");
INSERT INTO tgp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ale pa tamlohi atu mo mele hilu ale mo tapulo vereuli na sava Iesu mo vaia matana hin la taon atu mo sangavulu sei la tovia Decapolis. Ale tamlohi tari la mar̃urahi tavera hinia. ");
INSERT INTO tgp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ale Iesu mara mo mele hilu mo hoso na tavalun tasi atu, vao tamlohi tavera jea matea la mai la turu r̃alihia na pahisa tasi. ");
INSERT INTO tgp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tamlohi tavera matea na ima lotu nona tavtavuin Israel hin jara atu hijana Jairus, mo mai mara mo hite Iesu mo papaohi sivo na palona. ");
INSERT INTO tgp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jairus mo usia r̃ilangi isana mara, “Venatuku rihirihi, i sopo tuai i pa mate. O mai o tau na limam hinia matan vara i mele r̃uhu ale i mauri.” ");
INSERT INTO tgp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ale Iesu mo usuria. Ale vao tavera matea la lo usuria la lo tiatia hinira. ");
INSERT INTO tgp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ale har̃ai matea mo lo toho hin vao atu. Ale mo rojo na rojoa nona har̃ai mata tauni mo sangavulu r̃omana mo rua moiso. ");
INSERT INTO tgp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mo jalahi na mania tavera isana doctor matuvana moiso, ale la doctor atu la sopo er̃i tuenia, la sopo vaia i r̃uhu pani mo mele sati jea. ");
INSERT INTO tgp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mo rongo na tamlohi la lo sorahi Iesu ale mo mai na har̃in Iesu hin vao atu mo tikeli na pingopingo nona ruru. ");
INSERT INTO tgp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Matan r̃omina mara, “Vara a er̃i tikeli purongoi na nona ruru, noku rojoa i pa tihai!” ");
INSERT INTO tgp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ale vahatea purongo r̃ae atu sei mo lo maro mo mamasa, ale mo rongovosahia na epena vara nona rojoa mo tihai. ");
INSERT INTO tgp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ale Iesu sohena mo rongovosahia vara suiha mo malue hinia, ale mo posi vahatea isan vao atu ale mara, “Hare mo tikeli na noku ruru?” ");
INSERT INTO tgp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nona tamlohi usuri la verea lara, “Ko pa usia vara hare mo tikeliho sohena sava, ko sopo hitea vara vao nike la lo tiatia isam?” ");
INSERT INTO tgp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ale Iesu mo kilau r̃alihira vara i vileia vara hare natu, mo tikelia. ");
INSERT INTO tgp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pani har̃ai atu sei mo levosahi na sava mo lo masese isana mo mai isan Iesu na matahu, mo popovitoho na palona ale mo verea na hinau tari. ");
INSERT INTO tgp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu mo verea isana mara, “Venatuku, nom rasua mo vaiho ko mele r̃uhu. O vano na tamata ale nom rojoa i pa tihai jejeu.” ");
INSERT INTO tgp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu mo pa lo retireti isana har̃ai atu, tamlohi hai la tai na iman Jairus la mai la verea isan Jairus lara, “Venatum mo mate moiso, o sopo mele usi tamlohi vujangi vara i mai.” ");
INSERT INTO tgp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pani Iesu mara mo rongo na sava la lo verea mo verea isan Jairus mara, “O sopo matahu! O rasuau!” ");
INSERT INTO tgp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ale Iesu mo sopo tinar̃ihia vara tea i usuria pani Peter enia James peresi John tasin James. ");
INSERT INTO tgp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","La vano la pala na iman tamlohi tavera mata ima lotu nona Jew atu, ale Iesu mo hite na tamlohi la lo tangtangi, la lo tangi aulu, la lo vai na vavaore tavera. ");
INSERT INTO tgp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ale Iesu mara mo unu mo verea isara mara, “Mata sava ka lo vai na vavaore tavera, ale ka lo tangtangi? Har̃arihi nike mo sopo mate, mo juruvi r̃omaliho purongo.” ");
INSERT INTO tgp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ale tamlohi la manaluluhi Iesu, pani mo r̃ulera enira mo isoiso la malue. Ale mo lavi taman har̃arihi atu peresi tinana peresi na nona tamlohi usuri la unu sivo na jara har̃arihi atu mo lo toho ea. ");
INSERT INTO tgp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iesu mo tauri na liman har̃arihi atu mo verea mara, “Talitha kumi!” Ale r̃aramin reti nike enia ‘Venatuku, o turu!’ ");
INSERT INTO tgp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ale vahatea purongo har̃arihi atu sei taunina mo sangavulu r̃omana mo rua mo mele turu ale mo tapulo hahau. Ale mar̃urahi tavera mo sohoni tamana peresi tinana peresi na nona tamlohi usuri. ");
INSERT INTO tgp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu mo verea isara mo isoiso vara la sopo mele sorahia isan tea, ale mo verea isara vara la silea hin te hinau i hania. ");
INSERT INTO tgp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ale Iesu peresi na nona tamlohi usuri la malue hin jara atu la mai na nona taon, Nazareth. ");
INSERT INTO tgp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na Sabbath matea Iesu mo tapulo vujangi na ima lotu ea, ale vao tamlohi la rongo na nona vujangi la mar̃urahi tavera lara, “Tamlohi nike mo pa lavi la hinau nike epu? Ale nona lelevosahi mo pa tai epu? La hinau mar̃urahi nike la pa pala na limana sohena sava? ");
INSERT INTO tgp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mo sopo pa tamlohi voro ima nahai teni, natun Mary ale vorain James, Joses, Judas peresi Simon? Mo sopo vetasina nahai la lo toho peresir̃a?” La r̃ongo mo sati matan mo lo vai la hinau sei. ");
INSERT INTO tgp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pani Iesu mo verea isara mara, “Tamlohi jara tinapua la pa sile na oloolo isana pr̃ovet matea, pani i pa sopo er̃i lavi te oloolo na jarana tataholo teni na naho tahisana teni na naho voraina.” ");
INSERT INTO tgp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Iesu mo sopo vai te matamata tavera isana tahisana, pani mo tau na limana na tamlohi rojoa tupu visalete purongo, ale nora rojoa la tihai. ");
INSERT INTO tgp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iesu mo mar̃urahi matan la sopo rasua. Moiso mo vano na jara tinatinapua mo lo vujangi na tamlohi ea. ");
INSERT INTO tgp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mo tovi la tamlohi atu tupu sangavulu r̃omana mo rua la mai isana, ale mo r̃ulera la vano mo ruarua, ale mo silera na suiha vara la titiu nar̃ihi na tanume lumiha sasati na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iesu mo verea isara vara la sopo lavi te hinau na nora hahau sohena hanhani teni te tanga, teni te mania, pani tihonira purongo. ");
INSERT INTO tgp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","La pa ru na sabat pani la pa sopo mele lavi te harua rurura tinapua. ");
INSERT INTO tgp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iesu mo verea isara mara, “Sava ima ka lo toho hinia hin te vanua, ha lo toho atu i tikeli rani atu ka mele malue hin vanua atu. ");
INSERT INTO tgp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pani vara te vanua la r̃ohu hin kamim teni la sopo tapurongo isamim, ha sar̃sar̃hi nar̃ihi na tangotango palomim hin jara atu vara i vujangia vara God i pa arira.” ");
INSERT INTO tgp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ale la malue la vano la retivujavujangi na tamlohi vara la posi na hehe. ");
INSERT INTO tgp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","La titiu nar̃ihi na tanume sasati matuvana, ale la tau na wel na patu tamlohi rojoa matuvana ale nora rojoa la tihai. ");
INSERT INTO tgp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hin rani atu, supe Herod Antipas mo rongo na sorasora hin Iesu, matan tamlohi tari la lo sorahia. Hai la verea lara, “John tamlohi paptijo mo mele turu na mateia. Hinau atu natu mo vaia mo suiha vara i er̃i vai la matamata sei.” ");
INSERT INTO tgp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pani hai la verea lara Iesu enia Elijah, ale hai la verea lara enia pr̃ovet matea matan tuai. ");
INSERT INTO tgp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pani Herod mara mo rongoa mo verea mara, “John tamlohi paptijo! Pani enau natu na tai nar̃ihi na patuna, varar̃uhu mo mele turu na mateia!” ");
INSERT INTO tgp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Matan Herod natu sei mo r̃ule na tamlohi vuro vara la taurilati John, ale la pesia na ima r̃ilangi vara i vai Herodias, naroun tasina Philip i avulahi matan Herod mo lavia sohena narouna. ");
INSERT INTO tgp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Matan John mo lo verea isan Herod mara, “Usuri na leu mo sopo tataholo vara o lavi naroun tasim sohena naroum.” ");
INSERT INTO tgp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ale Herodias mo lo vaihitea vara i vilimatei John, pani i sopo er̃i vaia hasena. ");
INSERT INTO tgp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Matan Herod mo matahuni John matan mo levosahia vara John enia tamlohi tataholo matea mo tapu ale Herod mo lo matahia. Hina purongo vara John mo lo vaia mo lo r̃omkaka tavera, enia mo opoia vara i lo tapurongo na retireti non John. ");
INSERT INTO tgp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pani Herodias mo hite na masapa matea na hanhani tavera mata pongi vora non Herod. Herod mo usi na nona tamlohi aulu peresi na nona tamlohi tatavera mata vuro ale la haratu la lo aulu Galilee la mai hinia. ");
INSERT INTO tgp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Matan venatuna sei hijana Herodias mo unu mo velu ale mo vai Herod peresi la haratu la lo toho atu la avulahi tavera. Ale Herod mo verea isan venatuna mara, “O usiau hin te hinau ko opoia, ale a pa silea isam.” ");
INSERT INTO tgp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ale Herod mo retitauhi mara, “A pa sileho na sava hinau ko usia, hina purongo vara i tikeli na sope jara na lo aulu hinira.” ");
INSERT INTO tgp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Moiso mo malue mo vano isan tinana mo usia mara, “Nana, a pa usi na sava isana?” Ale tinana mara, “Na opoi na patun John tamlohi paptijo!” ");
INSERT INTO tgp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ale vahatea purongo mo mele unu mo verea isan Herod mara, “Na opoia vara o sileau nakerihi na patun John tamlohi paptijo hin te peleti hatea!” ");
INSERT INTO tgp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herod mo rongo mo sati tavera matana. Pani mo mahanuhanu vara i tope na nona retitauhi sei mo vaia na nahon la haratu la lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ale vahatea purongo mo r̃ule na nona tamlohi mata vilimatei na tamlohi matea vara i tai roto na patun John. Tamlohi atu mo vano na ima r̃ilangi ale mo tai roto na patuna, ");
INSERT INTO tgp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","moiso, mo lavi na patuna na peleti matea mo silea isan har̃ai atu. Ale har̃ai atu mo lavia mo silea isan tinana. ");
INSERT INTO tgp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tamlohi usuri non John lara la rongoa, la mai la lavi na tarapena, ale la taua na papa vatu matea. ");
INSERT INTO tgp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pa la tamlohi usuri atu Iesu mo lo r̃ulera la mele mai ale la vere vevuhi na sava la lo vaira ale la lo vujangira. ");
INSERT INTO tgp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ale Iesu mo verea isara mara, “R̃a malue hin vao nike r̃a vano hin te jara hasetoho r̃a mapu makomona tako.” Matan tamlohi mo mar̃ivi la lo mai ale la lo vano ale mo sopo te masapa vara la er̃i hanhani. ");
INSERT INTO tgp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ale la vele na boti matea la vano na jara hasetoho matea enira hasera. ");
INSERT INTO tgp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pani vao tavera mata taon matuvana la hitera la lo vano, ale la maro usurira na jarauta, ale la kakau tiroma hin jara atu la pa hoso ea. ");
INSERT INTO tgp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu mara mo hoso mo hite na vao tavera matea, ale mo r̃omopoira matan la sohena sipsip mo sopo te tavuira. Ale mo tapulo vujangira na hinau matuvana. ");
INSERT INTO tgp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Alo mo sivo moiso, ale nona tamlohi usuri la mai isana lara, “Moli jara hasetoho nahai, ale nake mo pongi moiso. ");
INSERT INTO tgp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","O r̃ulera la vano r̃alihi jara nike ale na vanua vara la voli te hara hinau.” ");
INSERT INTO tgp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pani Iesu mo r̃aramira mara, “Kamim purongo ha vahanira!” Pani lara, “Voli tamlohi mata rani ngavulu sangavulu rua mo sopo lo navu mata i voli te pereti vara i vahani vao tamlohi nike.” ");
INSERT INTO tgp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu mo usira mara, “Ha vano ha hitea vara ka lo lavi na hanhani mo visa.” La mele mai lara, “Pereti mo lima peresi na maji mo rua.” ");
INSERT INTO tgp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Moiso Iesu mo retileu vara la sakele na vao na talu r̃uvu. ");
INSERT INTO tgp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ale la sakele na vao mo tikeli mo ngavulu lima teni mo ngavulu sangavulu . ");
INSERT INTO tgp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","‘Moiso, Iesu mo lavi pa pereti atu mo lima peresi pa la maji atu mo rua mo tar̃a sahe na tuka mo vere meje isan God matara moiso mo topera mo silera isana nona tamlohi usuri vara la asera isana vao tamlohi hatehateahi atu. ");
INSERT INTO tgp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Enira mo isoiso la hanhani ale la masu mo r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","La sohoni na tanga mo sangavulu r̃omana mo rua na mesin la pereti atu mo lima peresi la maji atu mo rua. ");
INSERT INTO tgp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Evi tamlohi purongo sei la lo hani pereti atu mo tikeli mo tari vaha lima . ");
INSERT INTO tgp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Vahatea purongo atu Iesu mo vere na nona tamlohi usuri vara la vele na boti la vano tiroma na tavalu tasi na vanuan Bethsaida, ale Iesu mo lo r̃ule la vao atu vara la mule. ");
INSERT INTO tgp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Moiso, enia mo malue isara mo sahe aulu na vuti vara i usiusi. ");
INSERT INTO tgp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pongi mo mai ale pa boti mo lo toho na livuha tasi moiso, ale Iesu hasena mo lo toho na jarauta. ");
INSERT INTO tgp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ale mo hitera la lo vaihitea r̃ilangi vara la suahia boti atu matan la lo songahi na langi. Na toa tarere mo hahau na pusa tasi mo mai isara. Mo vano sohena vara i jeura, ");
INSERT INTO tgp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","pani lara la hitea mo lo hahau na pusa tasi, la r̃omi vara nunua matea, ale la uloulo ");
INSERT INTO tgp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","matan enira mo isoiso la hitea ale la matahu tavera. Pani vahatea purongo Iesu mo retireti isara mara, “Ha sopo matahu, enau sei!” ");
INSERT INTO tgp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ale mo vele sivo na lolo boti peresira, ale vahatea purongo langi atu mo moti. Ale la mar̃urahi tavera. ");
INSERT INTO tgp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pani la sopo lo hitevosahia vara Iesu enia hare, hina purongo na matamata sei Iesu mo lo vaia na suihana hin la maji atu peresi la pereti atu matan mapura la r̃ilangi mata la rasua. ");
INSERT INTO tgp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iesu tolu na nona tamlohi lara la vano roto na tasi la pala Gennesaret la sahe la hoso, ");
INSERT INTO tgp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ale lara la sevuti hin boti atu, vila r̃uhu purongo tamlohi hin jara atu la hitevosahi Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","La maro la vano na jara tari r̃alihi jara atu la lavi na tamlohi rojoa na epara la mai isana na sava jara la rongoa vara mo lo toho ea. ");
INSERT INTO tgp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ale na sava jara Iesu mo pala hinia, hina purongo vara hin te vanua, teni te taon tavera, teni na ima hasetoho, tamlohi la lavi na nora tamlohi rojoa la taura na jara maket, ale la lo usia r̃ilangi isana vara la er̃i tikeli na pingo nona ruru purongo. Ale tamlohi tari sei la tikelia, nora rojoa la tihai. ");
INSERT INTO tgp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na rani matea Pharisee peresi na tamlohi vujangi mata leu, la tai Jerusalem la mai isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","La mai ale la hitea vara tatua nona tamlohi usuri la lo hanhani pani la sopo hoje na limara tiroma sohena Leu non Moses mo verea. ");
INSERT INTO tgp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Matan Pharisee peresi na Jew tari, la sopo er̃i hanhani vara la sopo javulahi na limara tiroma, matan la lo usuri na posposi nona vajiaha matan tuai. ");
INSERT INTO tgp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ale la pa sopo er̃i hani te hinau la lavia na maket vara la sopo javulahi na limara tiroma. Hinau akerihi enia vonan la leu atu matuvana sei la lo usurira, sohena posposi mata hoje na paniken teni peleti teni jilivi teni pesin. ");
INSERT INTO tgp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ale Pharisee peresi na tamlohi vujangi mata leu la usia isan Iesu lara, “Mata sava nom tamlohi usuri la sopo usuri na posposi nona vajiaha matan tuai, matan la lo hanhani peresi na lumi limara?” ");
INSERT INTO tgp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu mo r̃aramira mara, “Kamim tamlohi tapnetano, Isaiah mo retimangovi varar̃uhu hin kamim sei hin haratu mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","‘La tamlohi nike la lo oloolo hiniau na nora retireti purongo, pani nora r̃omr̃omi mo pa lo toho asau hiniau. Nora lotu enia lotulotu vono purongo, ale la lo verea lara nora retileu enia retileu non God.’ ");
INSERT INTO tgp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ka lo r̃omr̃omi purongo na leu non God, ale ka lo usuri na vujangi nona tamlohi purongo.” ");
INSERT INTO tgp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ale mo verea mara, “Kamim ka r̃ohu na retileu non God matan vara ha pa taurilati na nomim posposi matan tuai. ");
INSERT INTO tgp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Matan Moses mo ulia na leu mara, ‘O oloolo hin tinam enia tamam!’ ale ‘Vara te tamlohi i retisasati hin tinana teni tamana ha vilimateia!’ ");
INSERT INTO tgp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pani kamim ka lo verea vara mo tataholo purongo vara tamlohi la sopo tueni na tamara teni tinara na nora vejuveju, ale ka lo verea kara, ‘Mo vono, a pa taurilati na mania na retitauhi hinia moiso vara a pa silea isan God.’ ");
INSERT INTO tgp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ale Ka lo horoa vara i sopo er̃i tueni tamana enia tinana. ");
INSERT INTO tgp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ka lo vai na leu non God mo lo mai hina purongo na nomim posposi matan tuai sei la silea isamim. Ale mele hinau matuvana sohena ka lo vaira.” ");
INSERT INTO tgp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ale Iesu mo mele tovi na tamlohi la mele mai isana, ale mo verea mara, “Kamim mo isoiso ha tapurongo i r̃uhu isaku, ale ha lo levosahi na noku reti. ");
INSERT INTO tgp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mo sopo te hinau hatea vara ha hania i sivo na lolomim i er̃i vai kamim ha lumiha na nahon God. Pani la hinau sasati sei la lo malue na mapumim, enira natu la lo vai kamim ka lumiha na nahon God.” ");
INSERT INTO tgp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","17","Moiso Iesu mo unu na ima matea vara i tinar̃ihi vao tamlohi atu, ale nona tamlohi usuri la usi na r̃aramin titileu atu isana. ");
INSERT INTO tgp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesu mo verea isara mara, “Kamim sohena, ka sopo rongovosahia? Ka sopo lo hitevosahia vara sava tamlohi la hania i sopo er̃i vaira la lumiha na nahon God. ");
INSERT INTO tgp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hanhani mo sopo sivo na mapumim. Mo sivo na pangemim purongo moiso mo mele malue.” Hin retireti akerihi Iesu mo lo verea vara hanhani tari la r̃uhu purongo. ");
INSERT INTO tgp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ale Iesu mo mele verea mara, “Sava mo lo malue na mapu tamlohi, enia natu i er̃i vai na tamlohi i lumiha na nahon God. ");
INSERT INTO tgp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Matan sava mo lo malue na mapu tamlohi enia: r̃omr̃omi hehe, posposi viriu, vavanaho, vilimatei na tamlohi, ");
INSERT INTO tgp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","vaivaileu peresi na tinapua mo lahi moiso, hanmarua, lejileji, haluhalu, posposi maji, mar̃ivi na mereimerei, retir̃er̃en, r̃omaulu, peresi na posposi rongorongo vono. ");
INSERT INTO tgp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","La hinau sasati nike natu, la lo malue na mapu tamlohi, ale la vaia mo lumiha na nahon God.” ");
INSERT INTO tgp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu mo malue Galilee mo vano na jara matan Tyre enia Sidon. Ale mo unu na ima matea mo sopo opoia vara tea i levosahia, pani mo sopo er̃i luhu. ");
INSERT INTO tgp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pani mo sopo tuai har̃ai matea sei venatuna tanume lumiha sasati matea mo sohonia, mo rongoa ale mo mai isana mo jovi na palona. ");
INSERT INTO tgp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Har̃ai atu enia har̃ai r̃or̃oha matea mara Syria Phonecia. Ale mo usia r̃ilangi vara i titiu nar̃ihi tanume sasati atu isan venatuna. ");
INSERT INTO tgp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ale Iesu mo verea isana mara, “Ha tinar̃ihi na natuvarihi la hanhani tiroma, matan mo sopo tataholo vara a lavi na hara pereti a pulahia isana viriu!” ");
INSERT INTO tgp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pani pa har̃ai mo r̃arami Iesu mara, “Ko varar̃uhu Moli, pani viriu sei la lo toho na ruhuruhu tep la lo hani na utauta hanhani hana natuvarihi sei la lo jovi sivo na lepa!” ");
INSERT INTO tgp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Moiso Iesu mara, “Nom r̃arami mo r̃uhu jea! O vano, tanume sasati atu mo malue hin venatum moiso!” ");
INSERT INTO tgp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Har̃ai atu mo turu mo mule, ale mo hite venatuna mo lo juruvi malum na vatana, ale tanume sasati atu mo malue isana moiso. ");
INSERT INTO tgp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu mo malue Tyre ale mo hahau vano na taon matan Sidon ale mo sivo na tasin Galilee, hin jara atu sei la lo tovia Decapolis. ");
INSERT INTO tgp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ale tamlohi la lavi na tamlohi matea mo mengo ale mo peropero mo mai isana, ale la usia r̃ilangi isana vara i tau na limana hinia. ");
INSERT INTO tgp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu mo lavi tamlohi atu mo vano hasena hin vao atu, mo tau na varangona na lolo perona, moiso mo lito sivo na varangona, ale mo tikeli na memen tamlohi atu na litona. ");
INSERT INTO tgp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iesu mo tar̃a sahe aulu na tuka, ale mo mapsoro mo verea na leora mara, “Ephphatha!” Ale r̃aramina enia ‘O roi!’ ");
INSERT INTO tgp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Vahatea purongo perona mo roi, ale memena mo retireti mo mera. ");
INSERT INTO tgp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu mo verea r̃ilangi isara vara la sopo sorahi hinau atu isan te tamlohi, pani mara mo verea mo r̃ilangi enira sohena la opoia mo tavera jea vara la vereulia. ");
INSERT INTO tgp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Matan la mar̃urahi tavera ale la lo verea lara, “Hinau tari mo lo vaira la r̃uhur̃uhu hajavua. Hina purongo vara la peropero mo vaira la rongo, teni vara la mengo mo vaira la retireti.” ");
INSERT INTO tgp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hin la rani atu, vao tavera matea mo mele toho peresi Iesu, ale mo sopo te hara hinau. Iesu mo tovi na nona tamlohi usuri la mai isana, ale mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Enau na r̃omopoi vao nike matan enira la lo toho peresiau mata rani mo tolu moiso, ale mo sopo te hanhani vara la pa hania. ");
INSERT INTO tgp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Vara a r̃ulera la mule marohati, la pa talekoleko na malele matan tatuara la tai asau r̃ove.” ");
INSERT INTO tgp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nona tamlohi usuri lara, “Pani r̃a pa vahani la tamlohi nike sohena sava hin jara hasetoho nike?” ");
INSERT INTO tgp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu mo usia isara mara, “Ka lo lavi na pereti mo visa?” Lara, “Mo limaravrua!” ");
INSERT INTO tgp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ale Iesu mo vere vao atu vara la sakele, moiso mo lavi la pereti atu mo limaravrua mo vere meje isan God matara, mo topera ale mo silera isana nona tamlohi usuri vara la aseasera isan vao atu, ale la vaia sohena. ");
INSERT INTO tgp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ale la vilei na maji vavarihi mo visalete purongo, ale Iesu mo vere meje matara ale mo verea isana nona tamlohi usuri vara la aseasera isan vao atu. ");
INSERT INTO tgp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tamlohi tari la hanhani vavano la masu. Hitahu nona tamlohi usuri la sohoni na sope hanhani na tanga mo limaravrua. ");
INSERT INTO tgp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Evi tamlohi korong mo tikeli tari vaha vati . Ale lara la hanhani moiso Iesu mo r̃ulera la mule. ");
INSERT INTO tgp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hitahu Iesu mo vele na boti matea peresi na nona tamlohi usuri la vano na jara matan Dalmanutha. ");
INSERT INTO tgp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee lara la rongoa vara Iesu mo pala atu, la mai vara la usi arearea hin te hinau, la opoia vara i vai te matamata matan na tuka vara i vujangia vara enia hare. ");
INSERT INTO tgp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pani Iesu mara mo rongoa mo mapsoro ale mara, “Kamim ka lo usi na matamata mata sava? Varar̃uhu na verea isamim vara enau a pa sopo vai te matamata vara kamim pin tamlohi nake ha pa hitea.” ");
INSERT INTO tgp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iesu mo malue isara ale mo vele hin pa boti atu, mo mele vano roto tasi atu. ");
INSERT INTO tgp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pani nona tamlohi usuri la r̃omaliho vara la lavi te pereti, ale la lo toho peresi na pereti matelete purongo na lolo boti. ");
INSERT INTO tgp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ale la pa lo vano roto tasi atu, Iesu mo retir̃oar̃oahaira mara, “Ha lo kilau mata isi nona Pharisee peresi Herod!” ");
INSERT INTO tgp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nona tamlohi usuri lara la rongoa la r̃omi vara mo lo verea sohena matan la sopo lavi te pereti. ");
INSERT INTO tgp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pani Iesu mo levosahi na sava mo lo toho na r̃omira, ale mo verea isara mara, “Mata sava ka lo sorahia vara ka sopo lavi te pereti? Ka sopo lo levosahia? Korong r̃omimim la pelati. ");
INSERT INTO tgp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matamim la vuso? Teni ka peropero? Ka sopo mele r̃omr̃omi na sava na lo vaira tiroma? ");
INSERT INTO tgp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Hin rani atu sei na lo ase na pereti mo lima isan la tamlohi atu mo tari vaha lima , ale tanga sope hanhani mo visa ka pa mele takonahira?” La r̃aramia lara, “Kama sohoni na tanga mo sangavulu r̃omana mo rua.” ");
INSERT INTO tgp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ale mo mele verea mara, “Hin rani atu na vahani na tamlohi mo tari vaha vati na pereti mo limaravrua, ale tanga mo visa ka pa mele takonahira?” Lara, “Mo limaravrua.” ");
INSERT INTO tgp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iesu mo mele verea isara mara, “Ka lo levosahi na sava na lo verea teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu peresi na nona tamlohi usuri lara la pala Bethsaida, tamlohi hai la lavi na tamlohi vuso matea la mai isana, ale la usia r̃ilangi isana vara i tikelia na limana. ");
INSERT INTO tgp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ale Iesu mo tauri na liman tamlohi atu mo tiroma hinia la malue hin vanua atu. Ale mara mo litovi na matana, ale mo tau na limana hinia moiso mo usia isana mara, “Ko hite te hinau?” ");
INSERT INTO tgp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tamlohi atu mo kilakilau r̃alihi ale mara, “Na hite na tamlohi, pani la sohena vipahai la lo hahau r̃alihi.” ");
INSERT INTO tgp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ale Iesu mo mele tau na limana na matana, moiso tamlohi atu mara mo mele roi na matana mo er̃i hite na hinau tari la memera. ");
INSERT INTO tgp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu mo verea isana mara, “O mule, pani o sopo hahau na vanua.” ");
INSERT INTO tgp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu peresi na nona tamlohi usuri la malue Galilee ale la sahe na vanua sei la lo toho na jara matan Caesarea Philippi. La pa lo hahau Iesu mo usi na nona tamlohi usuri mara, “Ka rongo na tamlohi la lo verea vara enau hare?” ");
INSERT INTO tgp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","La r̃aramia lara, “Tamlohi hai la verea vara engko John tamlohi paptijo, hai la verea vara engko Elijah. Hai la lo verea vara engko pr̃ovet matea.” ");
INSERT INTO tgp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Moiso Iesu mo pete usia isara mara, “Pani kamim, ka lo verea kara enau hare?” Peter mo r̃aramia mara, “Engko natu pa Kr̃isto atu!” ");
INSERT INTO tgp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ale Iesu mo verea r̃ilangi isara vara la sopo mele verea isan tea vara enia hare. ");
INSERT INTO tgp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesu mo tapulo verea isara mara Natun Tamlohi i pa lavi na rani r̃ilangi na hinau matuvana. Ale tamlohi aulu matan Israel peresi na pr̃is aulu, peresi na tamlohi vujangi mata leu la pa r̃ohu hinia, ale la pa vilimateia, pani i pa mele turu na hatolu rani. ");
INSERT INTO tgp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mara mo lo vere la hinau atu sohena, Peter mo lavi Iesu mo vano hasena, ale mo reti r̃ilangi isana vara i sopo retireti sohen haratu. ");
INSERT INTO tgp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pani Iesu mo posi mo kilau vano isana nona tamlohi usuri, mo reti r̃ilangi isan Peter mo verea mara, “O rovo isaku Setan. R̃omr̃omi atu mo tai isana tamlohi, mo sopo tai isan God.” ");
INSERT INTO tgp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ale Iesu mo tovi la vao atu peresi na nona tamlohi usuri vara la mai isana, ale mo verea mara, “Vara te vonamim hatea mo opoia vara i usuriau, o vaihitea vara o r̃omaliho na masalom moiso o soloti na nom talopeilopei ale o usuriau! ");
INSERT INTO tgp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Matan sava tamlohi vara mo opoia vara juri na maurina, i pa vaitihaia, pani hare vara mo vaitihai na maurina mataku peresi na Retir̃uhu i pa juri na maurina. ");
INSERT INTO tgp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sava hinau mo r̃uhu hinia vara o lavi na hinau tari matan varama nike, pani o pa vaitihai na maurim? ");
INSERT INTO tgp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sava hinau natu, o pa er̃i vaia vara o er̃i volituhu na maurim hinia? ");
INSERT INTO tgp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Matan sava tamlohi vara mo mahanuhanu hiniau peresi na noku retireti hin pina vaivaileu nike sei mo lejileji, enia sohena Natun Tamlohi i pa sopo avulahi hinia hin rani atu i pa mai peresi na nona angelo tapu peresi na mera tavera non Tamana.” ");
INSERT INTO tgp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesu mo mele verea isara mara, “Varar̃uhu na verea isamim vara tatuamim sei la lo turu nakerihi, la pa sopo lo mate la pa hite mauri atu God mo aulu hinia i mai na suihana tavera.” ");
INSERT INTO tgp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Rani mo limarave la vano moiso, ale Iesu mo lavi Peter, James peresi John, la sahe aulu na vutivuti enira hasera. Hin rani atu la hite na epen Iesu mo posi, ");
INSERT INTO tgp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ale la hite na nona ruru la mera hajavua, la lulu tinapua, la jeu na hinau lulu tari nike na varama. ");
INSERT INTO tgp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Moiso la hite pr̃ovet Elijah enia Moses la pala ale la lo sorasora peresi Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter mo verea isan Iesu mara, “Moli, mo r̃uhu matan kama lo toho akerihi. Mo r̃uhu r̃a vai te tent i tolu akerihi, matea nom, matea non Moses ale matea non pr̃ovet Elijah.” ");
INSERT INTO tgp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Matan Peter mo sopo levosahia vara i pa vere na sava matan la matahu hajavua. ");
INSERT INTO tgp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ale telangi matea mo mai mo hohovira, moiso la rongo na leo matea mo malue hinia mara, “Harihi enia Natuku sei na opoia mo tavera jea. Ha tapurongo isana!” ");
INSERT INTO tgp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Vahatea purongo la pa ale Moses enia Elijah pani la tihai, pani la hite Iesu hasena mo pa lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ale lara la lo sevuti na vutivuti, Iesu mo reti horora vara la sopo mele verea na sava la hitea isan te tamlohi vavano Natun Tamlohi i mele mauri na mateia. ");
INSERT INTO tgp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ale la sopo mele verea isan tea, pani la lo usia vara r̃aramin reti sei vara i pa mele turu na mateia enia sava. ");
INSERT INTO tgp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ale la usia isana lara, “Mata sava natu, tamlohi vujangi mata leu la verea lara, ‘Elijah i pa mai tiroma?’” ");
INSERT INTO tgp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu mo r̃aramira mara, “Varar̃uhu, Elijah i pa mai tiroma vara i vai tataholoi na hinau tari. Pani mata sava natu la ulia na Retiulia vara Natun Tamlohi i pa lavi na r̃ilangi ale la pa vailejlejia na nora hiter̃er̃esi? ");
INSERT INTO tgp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pani na verea isamim vara Elijah mo pete mai moiso, ale tamlohi la vailejlejia usuri na masalora sohena Retitapu mo lo verea.” ");
INSERT INTO tgp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iesu peresi la tupu tolu atu, lara la mele sevuti sivo na pulon vuti atu, la hite na tapalara tamlohi usuri peresi na vao tavera matea la lo turu r̃alihira, ale la hite na tamlohi vujangi mata leu hai la lo vasvasi peresira. ");
INSERT INTO tgp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ale la vao tamlohi atu lara la hite Iesu la hutura hinia, ale vahatea la avulahi la maro vano isana. ");
INSERT INTO tgp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu mo usi na nona tamlohi mara, “Eh! Kamim ka lo vauriuri na sava?” ");
INSERT INTO tgp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Vonara matea mo verea isan Iesu mara, “Tija, na lavi natuku na mai isam matan tanume mata mengo mo lo toho isana. ");
INSERT INTO tgp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vara mo vaia, mo lo pulahia atano na lepa, ale epena la lo r̃ira mo lo hatihati na hur̃una moiso jingona mo lo valval. Ale na usia isana nom tamlohi usuri vara la titiu nar̃ihi tanume sasati nike, pani la sopo er̃i vaia.” ");
INSERT INTO tgp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu mo r̃aramira mara, “Kamim nomim rasua mo sohena sava! A pa toho peresi kamim i tikeli pangisa? A pa tueni kamim i tikeli pangisa? Ha lavi uluvou atu i mai isaku!” ");
INSERT INTO tgp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Moiso la lavi uluvou atu mo mai isana, ale tanume sasati atu mara mo hite Iesu, mo tuatuahi pa uluvou atu mo jovi atano na lepa, ale mo lo makurekure, moiso valval jingona mo lo malue. ");
INSERT INTO tgp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu mo usia isan tamana mara, “Tanume sasati nike mo tapulo vaia nangisa?” Ale tamana mo r̃aramia mara, “Na rani mo lo natirihi. ");
INSERT INTO tgp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hin te rani mo vaia mo jovi na hapu teni na wai vara i vilimateia. Pani vara o er̃i vai te hinau, o r̃omopoi kamam, o tueni kamam.” ");
INSERT INTO tgp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu mara, “Ko verea vara a er̃i vaia! Vara te nom rasua o er̃i vai na hinau tari!” ");
INSERT INTO tgp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Vahatea tamana mo r̃aramia mara, “Na rasua, pani o nar̃ihi na noku r̃omkaka!” ");
INSERT INTO tgp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ale Iesu mara mo hite na vao matea la lo maro la mai vara la pa turu porotia matana, mo reti r̃ilangi isan tanume lumiha sasati atu mara, “Tanume mengo, na verea isam vara o malue isan uluvou sei nakerihi! O sopo mele unu hinia hin te rani!” ");
INSERT INTO tgp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tanume sasati atu mo ulo sasati, mo mele tuatuahia mo jovi sivo atano moiso mo malue hinia. Tamlohi la hitea sohena vara uluvou atu mo mate moiso, ale lara, “Eh, mo mate!” ");
INSERT INTO tgp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pani Iesu mo saua, ale mo mele turu. ");
INSERT INTO tgp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ale hitahu Iesu mara mo mele unu hin ima atu, nona tamlohi usuri la usia lara, “Mata sava natu, kamam kama sopo er̃i titiu nar̃ihi tanume sasati atu?” ");
INSERT INTO tgp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ale Iesu mo verea isara mara, “Tanume sasati sohen haratu, usiusi purongo i er̃i titiu nar̃ihia.” ");
INSERT INTO tgp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu peresi na nona tamlohi la malue hin jara atu, ale la hahau roto na jara Galilee, matan hin rani atu Iesu mo sopo opoia vara tea i levosahia vara mo lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Matan mo opoia vara i vujangi na nona tamlohi usuri hasera. Mo mele verea isara mara, “Tamlohi la pa turuposi hin Natun Tamlohi, ale la pa taua na lima tamlohi vara la vilimateia. Pani na hatolu rani i pa mele turu na mateia.” ");
INSERT INTO tgp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pani la sopo rongovosahi na sava hinau mo lo verea isara, ale la matahu vara la usi na r̃arami nona retireti. ");
INSERT INTO tgp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lara la kakau Capernaum, ale la unu na ima matea mata la pa toho hinia. Iesu mo usia isara mara, “Sava natu, ka lo sorahia na malele?” ");
INSERT INTO tgp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pani la sopo r̃aramia matan la lo vauriuri vara hare natu mo aulu jea hinira. ");
INSERT INTO tgp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ale Iesu mo sakele mo tovi la tupu sangavulu r̃omana mo rua atu la mai isana mara, “Vara tea mo opoia vara i aulu i jeu na tinapua, enia i pa hasena taua atano i jeu na volitusi nona tamlohi tari.” ");
INSERT INTO tgp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Moiso Iesu mo lavi na natirihi matea hin vao atu ale mo taua na livuhara. Moiso mo tulia mara, ");
INSERT INTO tgp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Vara tea mo lavi te natirihi sohen haranike na hijaku, enia mo lo laviau. Ale vara tea mo laviau, mo sopo laviau haseku, pani mo lo lavi Tamaku sei mo lo r̃uleau sohena.” ");
INSERT INTO tgp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John mo verea isan Iesu mara, “Tija, kama hite na tamlohi matea mo lo titiu nar̃ihi na tanume sasati na hijam, pani kama horoa vara i isoiso matan enia mo sopo tatuar̃a.” ");
INSERT INTO tgp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pani Iesu mo verea isara mara, “Ha sopo horoa, matan i pa sopo te tamlohi hatea vara mo lo vai na matamata tavera na hijaku i er̃i mele verelejlejiau hin te rani. ");
INSERT INTO tgp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Matan la haratu la sopo turuleji hinir̃a, enira nor̃a. ");
INSERT INTO tgp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Varar̃uhu na verea isamim, vara tea mo sile te paniken wai hamar̃ir̃i isamim matan ka tamlohi non Kr̃isto, varar̃uhu enia i pa lavi na otori matana!” ");
INSERT INTO tgp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pani vara tea mo vai na natirihi matea sohen harihi sei mo rasuau i jovi na hehe, i pa mele r̃uhu jea vara la lasi te vatu tavera na r̃alona, ale la putehia na tasi puaha. ");
INSERT INTO tgp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Vara limam mo lo vaiho ko lo vai na hehe, o tai nar̃ihia! I pa mele r̃uhu jea vara o lavi mauri atu na tuka peresi te limam hatelete purongo, mo jeu haratu vara o pa vano na hapu mata moruhapu sei mo sopo er̃i mate peresi na limam mo rua! ");
INSERT INTO tgp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Vara palom mo lo vaiho ko lo vai na hehe, o tai nar̃ihia! I pa mele r̃uhu jea vara o unu hin mauri atu na tuka peresi te palom hatelete purongo, mo jeu haratu vara la pulahiho peresi na palom mo rua na moruhapu. ");
INSERT INTO tgp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Vara matam mo lo vaiho ko lo vai na hehe, o hoti nar̃ihia! Mo mele r̃uhu jea vara o unu hin mauri atu God mo aulu hinia peresi te matam hatelete purongo, mo jeu haratu vara la pulahiho peresi na matam mo rua na moruhapu. ");
INSERT INTO tgp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Hin jara atu hulesira la sopo er̃i mate, ale hapu mo sopo mate hin te rani.’ ");
INSERT INTO tgp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Matan God i pa tau na hapu mata rani r̃ilangi na mauri tamlohi tari, matan vara i hani nar̃ihi na hehe na maurira sohena solo mo lo vai na mit mo sopo ranga. ");
INSERT INTO tgp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Solo mo r̃uhu, pani vara mejina mo tihai, ha pa er̃i vaia i mele meji sohena sava? Ha taurilati na r̃omimim mata r̃ohu na hehe, ale ha toho na tamata peresi kamim hatehateahi!” ");
INSERT INTO tgp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ale Iesu mo malue Capernaum, mo sivo na jara matan Judea, ale mo vano na tavalu wai Jordan na jara Opae hinia. Hin jara atu vao tamlohi la mele mai isana sohen tarea, ale mo lo vujangira sohen tarea. ");
INSERT INTO tgp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisee hai la mai isana la vaihitea hin retiusia akerihi lara, “Tamlohi i pa tope na leu vara mo r̃ohu hin narouna teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu mo r̃aramira mara, “Leu non Moses mo verea vara sava?” ");
INSERT INTO tgp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","La tamlohi atu la verea lara, “Moses mo majinga hinia mara i pa uli na certificate matea matana, moiso i pa er̃i r̃ule nar̃ihia i vano.” ");
INSERT INTO tgp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pani Iesu mo r̃aramira mara, “Moses mo pa uli leu atu matan patumim mo r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pani na pongi tiroma sei God mo vai na varama, ‘Mo vai na lamane peresi na har̃ai.’ ");
INSERT INTO tgp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mata hinau atu natu, tamlohi matea i pa sor̃otahi isan narouna, i pa malue isan tamana enia tinana. ");
INSERT INTO tgp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","La tupra rua atu la pa mai epe matelete purongo.’ Matan la sopo mele mo rua, pani la pa matea, ");
INSERT INTO tgp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","i pa sopo te tamlohi hatea i er̃i mele tauhasehira matan God mo sor̃otahira la mai matea moiso.’” ");
INSERT INTO tgp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ale hitahuna, Iesu mara mo lo toho hasena na ima peresi na nona tamlohi usuri, ale la mele usia hin pa vujangi atu. ");
INSERT INTO tgp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ale Iesu mo verea isara mara, “Vara te tamlohi mo r̃ohu hin narouna, moiso mo mele lavi na har̃ai tinapua, enia mo lo vaivaileu peresi har̃ai atu. ");
INSERT INTO tgp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ale vara te har̃ai mo r̃ohu hin tuana, moiso mo mele lahi isana tamlohi tinapua, enia mo lo vaivaileu peresi tamlohi atu.” ");
INSERT INTO tgp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na rani tinapua, tamlohi hai la lavi na natura la mai isan Iesu matan vara i tau na limana hinira, ale i ler̃uhu hinira, pani nona tamlohi usuri la lo horora. ");
INSERT INTO tgp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pani Iesu mara mo hitea mo lolokoru hinira, ale mo verea isara mara, “Ha tinar̃ihi na natuvarihi la mai isaku, ha sopo horora matan mauri atu God mo aulu hinia, enia non la haratu sei la sohera. ");
INSERT INTO tgp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Varar̃uhu na verea isamim vara te tamlohi mo sopo er̃i lavi mauri atu God mo aulu hinia sohen natirihi nike, enia i pa sopo er̃i unu hin mauri atu hin te rani.” ");
INSERT INTO tgp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Moiso Iesu mo tuli na natuvarihi na limana, ale mo tau na limana aulu na patura mo ler̃uhu hinira. ");
INSERT INTO tgp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na rani matea, Iesu mo pa tapulo vara i mele vano na nona hahau matea na jara tinapua matea, uluvou matea mo maro mo mai ale mo papaohi isan Iesu mo usia mara, “Tija r̃uhur̃uhu, a pa vai na sava natu vara a lavi na mauri tui hinia?” ");
INSERT INTO tgp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu mo verea mara, “Mata sava ko vereau vara na r̃uhu? God hasena mo r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Engko ko levosahi na leu, ‘O sopo vilimateia na tamlohi, o sopo vaivaileu peresi na tinapua mo lahi moiso, o sopo vavanaho, o sopo halu, o sopo retihalu hin tahisam, o sopo vai te halu mata vavanaho, moiso o oloolo hin tamam enia tinam.’” ");
INSERT INTO tgp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uluvou atu mo verea mara, “Tija, la leu tari atu na lo usurira na pa lo natirihi mo sinai mo kakau nake.” ");
INSERT INTO tgp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu mo kilau tataholo isan tamlohi atu na opoia, ale mo verea isana mara, “Ko pa lo vejuveju na hinau matea. O vano o har̃ehi vevuhi na nom hinau tari, ale o sile na maniana isana tilavono, ale o pa lavi na tavtav na tuka. Moiso, o pa mai, o usuriau!” ");
INSERT INTO tgp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pa tamlohi atu r̃omina mo jovi mata sava Iesu mo verea isana, matan enia tamlohi tavtav matea. ");
INSERT INTO tgp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu mo kilau r̃alihi, ale mo verea isana nona tamlohi usuri mara, “I pa r̃ilangi isan la haratu la tavtav vara la unu hin mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nona tamlohi usuri la mar̃urahi na nona reti matan la lo r̃omr̃omia lara God mo ler̃uhu na tamlohi tavtav. Iesu mo mele verea isara mara, “Natuvarihi, mo r̃ilangi jea vara tea i er̃i unu hin mauri atu God mo aulu hinia! ");
INSERT INTO tgp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mo mele malum jea vara camel i unu na koko niteli matea mo jeu haratu vara tamlohi tavtav matea i er̃i unu hin mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nona tamlohi la mar̃urahi tavera hinia, ale la lo usiusira hinia lara, “Hare natu, i pa er̃i juri?” ");
INSERT INTO tgp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu mo kilau tataholo isara mara, “Hinau tamlohi la sopo er̃i vaia, God i er̃i vaia. Matan God i er̃i vai na hinau tari.” ");
INSERT INTO tgp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Moiso Peter mo tapulo verea isan Iesu mara, “Kama tinar̃ihi na hinau tari vara kama usuriho!” ");
INSERT INTO tgp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ale Iesu mara, “Varar̃uhu, na verea isamim, vara tea mo tinar̃ihi na imana, teni tasina teni vetasina, teni tamama teni tinana teni te natuna, teni jarana, ale mo tinar̃ihira mataku teni mata Retir̃uhu, ");
INSERT INTO tgp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","enia i pa mele lavia nike nake na varama i vaha ngavulu sangavulu na imana, na voraina peresi na vetasina, tinana, peresi na natuna teni jarana, ale i pa lavi na rani r̃ilangi na lima tamlohi, pani na pongi hitahu i pa lavi na mauri tui. ");
INSERT INTO tgp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pani la haratu sei la lo r̃omr̃omia vara enira la aulu na tamlohi nake, la pa atano jea, ale la haratu sei la lo atano nake, la pa aulu hinira.” ");
INSERT INTO tgp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ale lara la lo vano na malele vara la sahe Jerusalem, Iesu mo lo vano tiroma, ale la haratu na har̃ina la mar̃urahi na nona reti, ale la tupu sangavulu r̃omana mo rua atu la matahu matan Iesu mo mele tapulo vere na sava i pa masese isana Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mo verea isara mara, “Ka hitea, r̃a lo sahe Jerusalem nahai, pani i pa sopo tuai la pa tau Natun Tamlohi na lima moli mata pr̃is peresi na tamlohi vujangi mata leu, ale la pa silea na talai vara i mate, moiso la pa taua na lima mara Rome. ");
INSERT INTO tgp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","La pa retikerekerehia, la pa litovia, la pa rupia na asi maja, ale la pa vilimateia. Pani na hatolu rani i pa mele turu na mateia.” ");
INSERT INTO tgp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ale James enia John natun Zebedee, la mai isan Iesu la verea isana lara, “Tija, kama opoi na hinau matea vara o pa vaia matamam.” ");
INSERT INTO tgp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu mara, “Ka opoia vara a vai na sava matamim?” ");
INSERT INTO tgp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","La verea lara, “Kamam kama opoia vara kama pa sakele na pahisam na nom rani suiha. Matea na matuam, ale matea na maraum.” ");
INSERT INTO tgp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ale Iesu verea isara mara, “Ka sopo levosahi na sava hinau ka lo usia. Kamim ha er̃i inu hin paniken atu mata rani r̃ilangi sei a pa inu hinia? Kamim ha er̃i lavi paptijo atu mata rongohaji sei a pa lavia?” ");
INSERT INTO tgp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","La r̃aramia lara, “Kama er̃i vaia.” Ale Iesu mo verea isara mara, “Ha pa inu hin paniken atu sei a pa inu hinia, ale ha pa lavi paptijo atu sei a pa lavia, ");
INSERT INTO tgp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","pani mo sopo noku hinau vara a pa verea vara hare natu i pa sakele na matuaku teni na marauku. God Tama mo tatamahuni la jara atu moiso matan la haratu sei mo vir̃onira moiso.” ");
INSERT INTO tgp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","La tupu sangavulu tinapua atu lara la rongo hinau atu la lolokoru hin James enia John. ");
INSERT INTO tgp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ale matana, Iesu mo tovi matavuhira mai isana mo verea isara mara, “Ka levosahia vara la haratu la lo aulu na tamlohi r̃or̃oha la lo r̃omr̃omira hasera purongo, ale la lo vailehilehi na tamlohi la lo toho na ruhuruhura. ");
INSERT INTO tgp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pani i pa sopo sohen haratu isamim. Vara te vonamim mo opoia vara i aulu hin kamim, enia i pa mai sohena nomim volitusi. ");
INSERT INTO tgp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ale vara tea mo opoia vara i tiroma, enia i pa mai sohena slev nona tamlohi tari. ");
INSERT INTO tgp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Matan hina purongo vara enau na Natun Tamlohi, na sopo mai vara tamlohi la volitusi isaku. Pani na mai vara a volitusi, ale vara a hase sile na mauriku vara i volituhu na tamlohi matuvana.” ");
INSERT INTO tgp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","La kakau Jericho, ale hitahu Iesu mara mo pa lo malue Jericho tolu na nona tamlohi usuri peresi na vao tavera matea, tamlohi matavuso matea hijana Bartimaeus natun Timaeus, mo lo sakele na pahisa malele, ale mo lo usi na mania isana tamlohi. ");
INSERT INTO tgp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ale mara mo rongoa vara Iesu mara Nazareth mo lo hahau hin jara atu, mo tapulo tangi aulu mara, “Iesu, natun Supe David, o r̃omopoiau!” ");
INSERT INTO tgp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pani tamlohi matuvana la merusahia lara i toho malum, pani mo mele ulo aulu jea mara, “Natun Supe David, o r̃omopoiau!” ");
INSERT INTO tgp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu mara mo rongoa mo turu atu, mo verea isara mara, “Ha verea i mai isaku!” Ale tamlohi la tovi matavuso atu lara, “Eh, r̃omim i sopo sati! O turu! Iesu mo toviho.” ");
INSERT INTO tgp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mo pulahi nar̃ihi na nona ruru hamariri, mo vai vilavila mo mai isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu mo usia mara, “Ko opoi na sava vara a vaia isam?” Matavuso atu mo r̃arami Iesu mara, “Tija, na opoia vara a er̃i kilau.” ");
INSERT INTO tgp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ale Iesu mara, “O vano! Nom rasua mo vaiho ko r̃uhu moiso.” Ale vahatea purongo matana la kilau, moiso mo usuri Iesu na malele. ");
INSERT INTO tgp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesu tolu na nona tamlohi usuri la lo usuri na malele mo sahe Jerusalem, ale la mai na vanua matan Bethphage peresi Bethany na pahisa vutivuti sei la tovia Vuti talu Olive. Iesu mo r̃ule na nona tamlohi usuri mo rua vara la vano tiroma hinira. ");
INSERT INTO tgp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Mo verea mara, “Ha vano hin vanua aturihi ale ha unu hinia, ale ha pa hite na natu donki matea la lihoa. Tea mo sopo lo sakele hinia hin te rani. Ha uli na asina, ale ha lavia i mai isaku. ");
INSERT INTO tgp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vara tea mo usi kamim vara, ‘Ka lo vai na sava?’ ha verea vara, ‘Moli mo opoia, ale i pa mele sohaia i mai nohorihi’.” ");
INSERT INTO tgp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","La vano hin vanua atu, moiso la hite natu donki atu mo lo toho na pahisa malele la lihoa na jingoima ima matea, ale la uli na asina. ");
INSERT INTO tgp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pani tamlohi hai sei la lo turu atu la usira lara, “Mata sava ka lo uli na asin natu donki sei?” ");
INSERT INTO tgp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","La r̃aramira sohen Iesu mo verea isara moiso, ale la tamlohi atu la tinar̃ihia vara la lavi natu donki atu i vano. ");
INSERT INTO tgp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","La lavia mo mai, la vur̃angi na nora ruru aulu na har̃in natu donki atu, ale Iesu mo sahe mo sakele hinia. ");
INSERT INTO tgp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tamlohi matuvana la vur̃angi na nora ruru na malele, ale hai la lo tai na rau pahai na pahisa malele la vur̃angira na malele vara natu donki atu i pa hahau hinia. ");
INSERT INTO tgp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tamlohi hai la lo hahau tiroma, hai la lo hitahu, ale Iesu mo lo toho na livuhara, ale la lo uloulo tavera lara, “Hasohaso God!” Ale “Ler̃uhu isan haratu sei mo lo mai na hijan Moli God”. ");
INSERT INTO tgp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Avulahi tavera mo lo mai mata rani suiha non tamar̃a Supe David mo pala.” “Hasohaso God aulu na tuka sei mo aulu jea!” ");
INSERT INTO tgp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu mo unu Jerusalem, ale mo unu na rope Temple. Ale mara mo vano r̃alihi mo hite na hinau tari moiso, ale matan pongi mo mai mariviti moiso mo malue mo vano Bethany peresi la nona tamlohi atu mo sangavulu r̃omana mo rua. ");
INSERT INTO tgp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na harua rani na r̃alavuho, la malue Bethany ale la lo vano, Iesu mo marohati. ");
INSERT INTO tgp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mo hite na vipahai fig matea mo lo turu asau na pahisa malele, ale mo hahau mo vano hinia vara i hitea vara te vuana, pani mo sopo te vuana, mo lo rauha purongo matan mo sopo lo taro mata i vua. ");
INSERT INTO tgp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iesu mo reti isan vipahai atu mara, “I pa sopo mele tea i er̃i mele hani te vuam hin te rani.” Ale nona tamlohi usuri la rongo reti atu mo lo verea isana. ");
INSERT INTO tgp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","La vano la mele tikeli Jerusalem moiso Iesu mo unu na rope Temple, mo tapulo levuti la haratu sei la lo har̃ehi na hinahinau peresi la haratu sei la lo voli na nora hinahinau. Iesu mo tarasahi na tep non la haratu la lo jeni na mania nona tamlohi sei la mai Jerusalem. Mo vano mo tohoi roiroi na palapala non la haratu la lo har̃ehi na vomahe. ");
INSERT INTO tgp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mo horo la haratu sei la opoia vara la lavi na nora hinahinau mata har̃ehira na lolo ropen Temple atu. ");
INSERT INTO tgp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ale Iesu mo vujangira mo verea isara mara, “Ka sopo lo levosahi na sava la ulia na Retiulia sei mo verea vara, ‘Imaku enia ima mata usiusi nona tamlohi tari na varama.’ Pani nake ka vaia mo mai sohena, ‘Papa tamlohi vili tamlohi mata mania matea’.” ");
INSERT INTO tgp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pr̃is aulu peresi na tamlohi vujangi mata leu lara la rongo na sava Iesu mo vaira na Temple, la tapulo aleale malele vara la vilimateia hinia. Pani la matahuni Iesu matan tamlohi tari la lo mar̃urahi tavera na nona vujangi. ");
INSERT INTO tgp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na ravravi Iesu enia tolu na nona tamlohi usuri la mele malue Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na r̃alavuho tinapua, lara la mele vano mar̃iviti hin pa vipahai fig atu, la hite na rauna la menumenu, ale lahona peresi na warina la koru moiso. ");
INSERT INTO tgp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter mo mele r̃omr̃omi pa reti atu non Iesu sei mo verea isan vipahai atu, ale mara, “Tija, o to kilau vano! Pa fig atu ko lo lesati hinia mo koru moiso.” ");
INSERT INTO tgp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Moiso Iesu mo r̃aramia mara, “Ha tau na nomim rasua hin God! ");
INSERT INTO tgp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Varar̃uhu na verea isamim, vara tea nona rasua mo r̃ilangi, ale mo sopo r̃omkaka hinia, i er̃i verea isan vuti tavera akerihi vara, ‘O hase taheho o sahe aulu, ale o pulahiho sivo na tasi tavera!’ ale i pa oloolo hinia! ");
INSERT INTO tgp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ha tapurongo isaku! Na verea vara sava hinau ka usia na nomim usiusi, vara ka rasua mo r̃ilangi i pa sohena. ");
INSERT INTO tgp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Pani vara ka lo usiusi, ha r̃omi na hehe nona tinapua sei la vaia isamim, ha r̃omira tiroma, matan vara Tamamim na tuka sohena i er̃i r̃omi na nomim hehe.” ");
INSERT INTO tgp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesu peresi na nona tamlohi usuri la mele unu Jerusalem, ale lara la lo hahau na lolo rope Temple, pr̃is aulu tolu na tamlohi vujangi mata leu peresi na tamlohi aulu tinapua hai la mai isana, moiso la reti isana lara, ");
INSERT INTO tgp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Sava suiha natu ko lo vai la hinau nike hinia teni hare mo sileho na suiha matana?” ");
INSERT INTO tgp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu mo verea isara mara, “A pa usi kamim na retiusia matea, ale vara ha r̃aramiau, enau a pa vere kamim hinia vara na lavi na suiha isan hare natu na lo vai la hinau nike hinia. ");
INSERT INTO tgp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ha to vereau hinia, paptijo non John mo tai isan God teni isana tamlohi?” ");
INSERT INTO tgp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ale la lo hasera sorasorahia lara, “Vara r̃a verea vara enia mo tai isan God, i pa usir̃a vara, ‘Mata sava natu, ka sopo rasu John?’ ");
INSERT INTO tgp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pani vara r̃a verea vara enia mo tai isana tamlohi, la vao nike la pa lo lolokoru hinir̃a.” La lo verea matan la matahu vara la pa vai la vao tamlohi atu la lolokoru ale la sopo er̃i mele vaira la toho malum, matan la vao atu la rasua vara John enia pr̃ovet varar̃uhu matea. ");
INSERT INTO tgp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Matan haratu, la tamlohi tatavera atu la r̃arami Iesu lara, “Kama sopo levosahia.” Ale Iesu mo verea isara mara, “Enau sohena, a pa sopo vere kamim hinia vara sava suiha natu, na lo vavahinau hinia.” ");
INSERT INTO tgp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ale na lolo rope Temple Iesu mo tapulo vujangi na titileu isara mara, “Tamlohi tavera matea mo lavo na isa mata grape matea. Mo vai na ropena, mo voro na jara mata lavi nar̃ihi na waena hinia. Mo voro na ima aulu matea mata kilau na isana. Ale mo sile isana atu vara tamlohi lalavo tinapua la pakaia, ale la lalavo hinia. Moiso pa tamlohi tavera atu mo vano na jara tinapua mata i tohoa ea. ");
INSERT INTO tgp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Taro mata vua grape la mena, ale pa tamlohi tavera atu mo r̃ule na nona volitusi matea mo vano vara i lavi na r̃ungana vuara. ");
INSERT INTO tgp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pani pa la tamlohi atu la tauri pa volitusi, la hamajia, moiso la r̃ulea mo vano lekoleko. ");
INSERT INTO tgp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tamlohi tavera atu mo mele r̃ule na volitusi tinapua matea. Mo vano, pani la hamajia na patuna, ale la vaimahanuhanu hinia. ");
INSERT INTO tgp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tamlohi tavera atu mo mele r̃ule na volitusi tinapua matea. Pani la vilimateia. Tamlohi tavera atu mo mele r̃ule te nona volitusi tinapua matuvana, pani hai la hamajira, ale hai la vilimateira vavano, ");
INSERT INTO tgp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","tamlohi tavera atu mo hitea vara natuna tataholo purongo mo pa lo toho. Enia mo opoia mo tavera jea, ale mo r̃omr̃omia mara, ‘Na levosahia vara a r̃ule natuku i sivo, la pa oloolo hinia.’ ");
INSERT INTO tgp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pani pa la tamlohi sasati atu la lo vereverera isara hasera lara, ‘Natuna tataholo nakerihi mo lo mai, vara r̃a vilimateia, r̃a pa lavi na koruna tari!’ ");
INSERT INTO tgp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","La tauria, ale la vilimateia moiso la pulahia mo sahe na jingoiman rope atu.” ");
INSERT INTO tgp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesu mo usia isara mara, “Ka r̃om vara tamlohi tavera atu i pa vai na sava? A verea tataholo isamim, i pa sinai i vilimateira enira mo isoiso, ale i pa sile isa atu isana tamlohi tinapua vara la mele pakaia. ");
INSERT INTO tgp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Varar̃uhu, ka sopo lo evi hinau nike na Retiulia? ‘Vatu atu tamlohi voro ima la lo tipahia, enia mo mai tapulo pulo vatu mata ima. ");
INSERT INTO tgp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hinau atu Moli God hasena mo vaia. Kama hitea vara mo r̃uhu jea.’” ");
INSERT INTO tgp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tamlohi tatavera non Jew la opoia vara la taurilatia matan la hitevosahia vara Iesu mo lo vere titileu atu matan vara i pisuhira, pani la matahu vara la tauria matan la vao atu. Matan haratu, la malue atu, ale la rovo. ");
INSERT INTO tgp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ale la r̃ule na Pharisee hai peresi na tamlohi hai non Herod Antipas la vano isan Iesu matan vara la vaihitea vara i ori hin te nona retireti. ");
INSERT INTO tgp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ale la mai isana la verea lara, “Tija, kama levosahia vara engko ko lo varar̃uhu, ale ko sopo tametame na r̃omr̃omi nona tamlohi, matan ko sopo usuri na kilakilau nona tamlohi isana tamlohi aulu, pani engko ko lo vujangi na malele tataholo non God usuri na retivarar̃uhu. Nomam retiusia isam nahai, mo tataholo vara tavtavuin Israel la voli na takis isana supe nona mara Rome teni mo vono? R̃a pa silea teni i toho?” ");
INSERT INTO tgp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pani Iesu mo levosahi na nora tapnetano, ale mo verea isara mara, “Mata sava ka lo vaihiteau sohena? Ha lavi te selen hatea i mai isaku a hitea.” ");
INSERT INTO tgp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ale la lavi matea la silea isana moiso mo usia isara mara, “Niniun hare nahai, ale hijan hare nahai la ulia hin selen nike?” Lara, “Nahon supe nona mara Rome.” ");
INSERT INTO tgp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ale Iesu mo verea isara mara, “Ale ha sile na hinau non supe nona mara Rome isan supe nona mara Rome, ale hinau non God isan God.” Ale lara la rongo mo r̃aramira sohena, la mar̃urahi tavera hinia. ");
INSERT INTO tgp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ale Sadducee hai la mai isan Iesu, enira vao matea na Jew sei la sopo rasua vara God i pa sauteterahi na tamlohi na mateia. La mai isana la usia na retiusia matea lara, ");
INSERT INTO tgp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tija, Moses mo ulia mara vara tamlohi lahi matea mo mate, pani narouna mo sopo vasusu, tasina i pa lavi na malepuna i mai narouna matan vara har̃ai atu i er̃i lavi te natun tavaina. ");
INSERT INTO tgp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tuai, vorai mo limaravrua la lo toho. Ale vora tiroma mo lavi na har̃ai matea, pani mo sopo lo te natuna, ale mo mate. ");
INSERT INTO tgp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Vora usuria mo pete lavi har̃ai atu, pani enia sohena mo mate, mo sopo te natuna. Hatolura mo pete lavia, ale mo mate mo sopo te natuna. ");
INSERT INTO tgp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mo sohena mo tikeli na vora hitahu, ale enira mo isoiso la mate. Har̃ai atu sohena mo mate, pani mo sopo te natuna. ");
INSERT INTO tgp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","O to vere kamam hinia vara har̃ai atu i pa naroun hare na pongi sauteterahi matan enia mo lahi isan la vorai atu enira mo isoiso.” ");
INSERT INTO tgp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu mo verea isara mara, “Nomim r̃omr̃omi mo sopo tataholo, matan ka sopo levosahi mamahuni na Retitapu teni na suihan God! ");
INSERT INTO tgp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Matan hin rani atu tamlohi la pa mele turu na mateia, la pa sopo mele lahi, pani la pa sohena angelo na tuka. ");
INSERT INTO tgp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pani hin vujangi sei mata sauteterahi na mateia, korong ka sopo lo evia matan vipahai rihirihi atu sei Moses mo hite na hapu mo lo hani hinia? God mo verea isan Moses mara, ‘Enau God non Abraham, God non Isaac, ale God non Jacob.’ ");
INSERT INTO tgp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God enia mo sopo God nona tamlohi mate, pani nona tamlohi mauri, matan isana, tamlohi tari la lo mauri. Kamim ka jalio mo tavera.” ");
INSERT INTO tgp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ale hin rani atu tamlohi vujangi mata leu matea mo mai mo lo tapurongo na vauriuri nona Sadducee, ale mo rongo sohena sava Iesu mo r̃aramira sei mo r̃uhu jea, ale mo usi Iesu hinia mara, “Sava leu natu mo aulu mo jeu na leu tari?” ");
INSERT INTO tgp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu mo r̃aramia mara, “Leu atu mo aulu mo jeu na leu tari enia vara, ‘Israel, ha tapurongo! Moli nor̃a God, enia Moli matelete. ");
INSERT INTO tgp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","O pa opoi Moli nom God vevuhi na mapum, na maurim, na r̃omim, peresi na suiham.’ ");
INSERT INTO tgp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ale haruana enia nahai, ‘O opoi na tahisam sohen ko lo opoiho hasem.’ Moiso mo sopo mele te leu tinapua i aulu i jeu la leu sei mo rua.” ");
INSERT INTO tgp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tamlohi vujangi mata leu atu mo verea mara, “Tija, ko varar̃uhu vara God enia matelete purongo, ale mo sopo mele te tinapua. ");
INSERT INTO tgp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ale mo tataholo vara r̃a opoi vevuhia na mapur̃a, na r̃omir̃a, na suihar̃a, ale vara r̃a opoia na tahisar̃a sohena r̃a lo opoir̃a haser̃a. La leu akerihi la aulu la jeu na maji tari mata malamalai r̃a lo sulira na nor̃a silesilea isan God usuri na leu.” ");
INSERT INTO tgp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu mara mo hitevosahi na lelevosahi non tamlohi akerihi, mo verea isana mara, “Engko ko lo toho mariviti moiso hin mauri atu God mo aulu hinia.” Ale hitahun haratu, mo sopo te vonara hatea i mele opoia vara i usia hin te retiusia hatea. ");
INSERT INTO tgp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na rani tinapua Iesu mo lo vujangi na tamlohi na lolo rope Temple, mo lo verea isara mara, “Sohena sava natu, tamlohi vujangi mata leu la lo verea vara Kr̃isto enia natun Supe David? ");
INSERT INTO tgp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na lo usia sohena matan tuai David mo retireti na suihan Tanume Tapu mo verea mara, ‘Moli God mo verea isan noku Moli mara: O sakele na matuaku, o lo sasaovi i mai i tikeli a tau na nom meresahi na ruhuruhu palom.’ ");
INSERT INTO tgp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David sohena mo tovia ‘Moli’. Vara mo sohen haratu, sohena sava natu, Kr̃isto enia natun David?” Ale vao tavera atu la avulahi tavera vara la lo tapurongo na nona vujangi. ");
INSERT INTO tgp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu mo lo vujangira mara, “Ha lo kilau na tamlohi vujangi mata leu. Matan la lo opoia vara tamlohi la hitera la lo hahau peresi na nora ruru peravu, ale la opoia vara tamlohi la lo popovitoho isara na jara maket. ");
INSERT INTO tgp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","La opoia vara la lo sakele nahonaho tarea na lolo ima lotu teni na rani matan te hanhani tavera. ");
INSERT INTO tgp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ale la lo haluhalu na har̃ai malepu mata voli nar̃ihi na imara na volina makomona purongo, pani la lo tatavu horo na nora posposi sasati na usiusi peravu na naho tamlohi. Matan hinau atu, nora talai i pa mele tavera jea.” ");
INSERT INTO tgp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu mo lo sakele mariviti na jara silesilea na Temple. Ale mo lo kilau na vao tamlohi la lo tau na nora mania. Tamlohi tavtav matuvana la tau na mania tavera hinia. ");
INSERT INTO tgp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mo sopo tuai mo hite na malepu tilavono matea mo mai, ale mo tau na nona mania, selen mo rua purongo. ");
INSERT INTO tgp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu mo tovi na nona tamlohi usuri la mai isana mara, “Varar̃uhu na verea isamim, malepu tilavono nike, mo taua mo jeu na tamlohi tinapua tari sei la lo tau na nora silesilea nike. ");
INSERT INTO tgp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Matan la haratu sei la silea mo tavera pani la levosahia vara nora tavtav tavera mo pa lo toho. Pani malepu tilavono nike mo sile vevuhi na sava mo lo toho mata maurina.” ");
INSERT INTO tgp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu mo pa lo malue na Temple, ale nona tamlohi usuri matea mo verea isana mara, “Tija, o to kilau vano sevano hin la vatu tavera sevano la voro na roro ima hinira, ale o to kilau la ima tatavera sevano!” ");
INSERT INTO tgp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ale Iesu mo verea isana mara, “Ko lo hite ima tavera nike? I pa sopo te vatu hatea i pa lo toho aulu na vatu tinapua vara la pa sopo atu jovjovira.” ");
INSERT INTO tgp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ale hitahu, Iesu mara mo lo sakele na pahisa Vuti talu Olive mo lo kilau sivo na Temple, Peter, James, John enia Andrew la mai r̃or̃o hasera, ale la usia lara, ");
INSERT INTO tgp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“O to vere kamam hinia, la hinau sei la pa masese pangisa? Ale sava matamata atu i pa mai tiroma vara kama pa levosahi mamahunia vara i sopo tuai natu la hinau tari natu la pa masese?” ");
INSERT INTO tgp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu mo verea isara mara, “Ha lo kilau i r̃uhu! Mo sopo r̃uhu vara tea i halu kamim. ");
INSERT INTO tgp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Matuvana la pa mai na hijaku. La pa verea vara, ‘Enau natu, tamlohi atu!’ ale la pa halu na tamlohi matuvana. ");
INSERT INTO tgp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ale vara ka rongo te vuro teni sorasora mata vuro, r̃omim i sopo kaka hin la hinau sei la pa mai tiroma, pani mo sopo isoisona. ");
INSERT INTO tgp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mara jara tavera tinatinapu la pa lo meresahi hinira, ale supe matea i pa meresahi na supe tinapua. Ale mihi i pa hisuhi na tatua jara na varama. Tamlohi la pa marohati na marua. Pani la hinau sei enira tapulona purongo. La hinau tari sei la sohena tapulo rongohaji na epe har̃ai vara i lavilavi. ");
INSERT INTO tgp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ha lo kilau! Tamlohi la pa tauri kamim la pa ari kamim. La pa hamaji kamim na ima lotu. Ha pa turu na naho tamlohi aulu nona gavman peresi na naho supe mataku. Enia i pa masapamim matea vara ha er̃i verea isara vara enau hare. ");
INSERT INTO tgp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Retir̃uhu atu la pa retivujavujangia na jara tari na varama tiroma, moiso isoisona i pa mai. ");
INSERT INTO tgp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ale vara la lavi kamim la vai kamim ka turu na nahora vara la vaihite kamim, ha sopo r̃omkaka na sava ha pa verea, pani ha pa vere na sava God i pa silea isamim, matan i pa sopo kamim ka lo retireti pani Tanumen God hin kamim. ");
INSERT INTO tgp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vorai matea i pa turuposi hin voraina vara i mate. Tama i pa turuposi hin natuna. Natuvarihi la pa turuposi na tamara peresi na tinara la pa vaira tamlohi la vilimateira. ");
INSERT INTO tgp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tamlohi tari la pa r̃ohu hin kamim mataku. Pani haratu mo turu r̃ilangi mo tikeli na isoisona i pa juri. ");
INSERT INTO tgp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Rani matea i pa mai ha pa hite hina lumiha atu God mo lo r̃ohu hinia i pa turu na jara tapu na lolo Temple. Hare mo evi harihi, i lo lelevosahi na r̃aramina! Hin rani atu, i pa r̃uhu vara tamlohi hin Judea la rovo la sahe na vutivuti. ");
INSERT INTO tgp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","I pa r̃uhu vara haratu mo lo toho na pusa ima, i sopo mele unu na lolo ima vara i lavi te hinau hinia, ");
INSERT INTO tgp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ale i pa r̃uhu vara haratu mo lo voko na isana i sopo mele posi i sivo mata i lavi na nona ruru na lepa. ");
INSERT INTO tgp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hin rani atu, i pa r̃ilangi jea isana har̃ai mo tau natuna, teni te har̃ai mo lo vasusui te natuna. ");
INSERT INTO tgp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ha usiusi vara rani atu i pa sopo masese na taro hamariri. ");
INSERT INTO tgp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Rani sati tavera atu i pa jeu na rani sati tamlohi la lo hitera mo tapulo hin rani atu God mo vai na varama mo tikeli nake i pa sopo mele te rani sasati i sohena hin te rani. ");
INSERT INTO tgp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vara Moli God i sopo vai rani r̃ilangi atu i vejuveju, i pa sopo tea i er̃i juri, pani mata nona tapuhi, la haratu sei mo vir̃onira i pa vai rani atu i vejuveju. ");
INSERT INTO tgp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Hin rani atu, vara tea mo verea isamim vara, ‘Ha kilau nike, Kr̃isto nahai!’ Teni tea i pa verea vara, ‘Ko hitea, enia nahai!’ Pani ha sopo rasura. ");
INSERT INTO tgp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Matan kr̃isto haluhalu peresi na tamlohi tapu haluhalu la pa mai. La pa vai na matamata tatavera. La pa vaihite la tamlohi atu God mo vir̃onira moiso vara la tinar̃ihi na nora rasua. ");
INSERT INTO tgp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ha lo kilau! Enau na lo vere kamim hinia tiroma moiso. ");
INSERT INTO tgp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Moiso hitahu hin rani sasati atu, ‘Alo i pa r̃or̃oha, ale vitu i pa sopo mele sile na merana.’ ");
INSERT INTO tgp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","‘Vitusarasara la pa jovjovi na masapa, ale suiha tari na masapa la pa hisu.’ ");
INSERT INTO tgp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hitahuna natu, tamlohi tari la pa hite na Natun Tamlohi mo lo mai na telangi na suiha tavera peresi na merana tavera. ");
INSERT INTO tgp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Natun Tamlohi i pa r̃ule na nona angelo la vano r̃alihi na varama vara la takonahi na nona tapuhi na jara tari na varama, ale aulu na masapa. ");
INSERT INTO tgp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ha levosahi na posi vipahai fig sei julina la mai la malum, ale mo tivu, ka levosahia vara rani mata hulihuli mo pala. ");
INSERT INTO tgp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","I pa sohena na pongi hitahu vara ka hite na hinau tari sei na lo vere kamim hinira moiso. Ha pa levosahia vara i sopo tuai Natun Tamlohi i pa pala. ");
INSERT INTO tgp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Varar̃uhu na verea isamim, pina akerihi nake i pa sopo lo mate vevuhi vavano la hinau tari akerihi la pa masese. ");
INSERT INTO tgp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tuka enia varama la pa tihai, pani noku reti la pa toho jejeu. ");
INSERT INTO tgp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mo sopo tea i levosahi rani tataholo atu teni matan alo matana, angelo na tuka sohena, la sopo levosahia teni Natun Tamlohi. God Tama hasena mo levosahia. ");
INSERT INTO tgp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ha lo kilau! Ha sopo juruvi! Matan ka sopo levosahia vara pongi atu i pa pala pangisa! ");
INSERT INTO tgp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I pa sohena tamlohi matea mo vano na nona hahau matea na jara tinapua matea, ale mo tau na imana na lima nona volitusi, ale la lo vai na nora vavahinau hatehateahi hinia. Ale mo vere haratu mo lo kilau na pelati mara, ‘O lo kilau tarea mata noku mele pala!’ ");
INSERT INTO tgp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Matan haratu, ha lo kilau! Matan ka sopo levosahia vara tamlohin ima sei i pa mele pala pangisa, i er̃i pala na ravravi teni na livuha pongi, teni na toa tarere teni na r̃alavuho, ha lo kilau! ");
INSERT INTO tgp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mo sopo r̃uhu vara ha hutu kamim na nona pala, ale i vilei kamim ka lo juruvi. ");
INSERT INTO tgp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sava na vere kamim hinia, na verea isamim kamim isoiso, ha lo kilau i r̃uhu mata nona rani pala!” ");
INSERT INTO tgp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rani mo rua mo lo toho vara i tikeli na pongi rani Passover peresi rani atu la lo hani na pereti hinia sei mo sopo te isi hinia. Pr̃is aulu peresi na tamlohi vujangi mata leu la lo aleale malele vara la pa tauri luhu Iesu hinia vara la vilimateia. ");
INSERT INTO tgp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Matan lara, “R̃a sopo er̃i vaia hin rani tavera sei matan tamlohi la pa levutir̃a.” ");
INSERT INTO tgp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu mo pa lo toho Bethany na iman Simon, tuai enia tamlohi lepros matea, ale lara la pa lo hanhani na tep, har̃ai matea mo sinai isana, mo lavi na potele hasori matea la vaia na lepa hijana alabaster, hasori r̃uhu mo lo toho na lolona la tovia nard ponana mo r̃uhu ale volina mo aulu jea. Har̃ai atu mo lavia mo kosahi na r̃alo potelena, ale mo rengia na patun Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tamlohi hai la lo toho atu la rongo mo sati matana, la lo verea isara hasera lara, “Mata sava mo rengi komokomoi hasori sei sohena? ");
INSERT INTO tgp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Volina mo sohena voli voko nona tamlohi matea mata tauni matea! Vara i har̃ehia i pa er̃i sile na volina isana tilavono.” La savurahi har̃ai atu. ");
INSERT INTO tgp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pani Iesu mo verea mara, “Eh, ha tinar̃ihi har̃ai sei. Mo lo vai na hina r̃uhu matea isaku. ");
INSERT INTO tgp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tamlohi tilavono la pa lo toho tarea isamim, ale vara ka opoia ha pa er̃i tuenira. Pani enau, a pa sopo toho tarea isamim. ");
INSERT INTO tgp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Har̃ai nike mo vai na sava i er̃i vaia isaku. Mo rengi na hasori na epeku mo vaia mo tatamahu mata noku tavuni mata noku mateia. ");
INSERT INTO tgp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Varar̃uhu na verea isamim, sava hinau har̃ai nike mo vaia isaku la pa sorahia na jara tari na varama mata r̃omr̃omia vara la vere na Retir̃uhu mataku.” ");
INSERT INTO tgp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariot, vonan la tupu sangavulu r̃omana mo rua atu matea, mo vano isana pr̃is aulu nona tavtavuin Israel, matan vara i tau Iesu na limara. ");
INSERT INTO tgp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pr̃is aulu la avulahi jea matana, ale la retitauhi vara la pa voli Judas matana. Judas mo tapulo aleale masapa vara i pa sile Iesu i vano isara hinia. ");
INSERT INTO tgp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na rani tiroma mata pereti sei mo sopo te isi hinia sei la lo sile na natu sipsip mata Passover sohen malamalai hinia, tamlohi usuri non Iesu la verea isana lara, “Eh! Ko opoia vara kama pa tatamahu mata hani na Passover epu?” ");
INSERT INTO tgp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mo r̃ule na nona tamlohi usuri tupra rua, mo verea isara mara, “Ha vano ha unu Jerusalem, ale ha pa hite na tamlohi matea mo lo soloti na jara wai tavera matea, ale ha usuria. ");
INSERT INTO tgp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ale sava ima i pa unu hinia, ha vere na tamlohin ima atu vara, ‘Tija mo usia mara, sava jara ko tatamahunia moiso mataku vara a pa hani na Passover hinia peresi na noku tamlohi?’ ");
INSERT INTO tgp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I pa vujangi kamim na jara matea mo lo toho aulu hin ima atu. Mo tatamahuni na hinau tari moiso. Ha tatamahuni na har̃a hinau ea.” ");
INSERT INTO tgp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","La tamlohi usuri tupra rua atu la malue la sivo hin taon tavera atu, ale hinau tari mo masese sohena Iesu mo verea, ale la tatamahuni na hanhani mata Passover ea. ");
INSERT INTO tgp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ale mara mo ravravi, Iesu mo sahe hin ima atu peresi la tupu sangavulu r̃omana mo rua atu. ");
INSERT INTO tgp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","La sakele r̃alihi na tep la lo hanhani, ale Iesu mara, “Varar̃uhu, vonamim matea i pa turuposi hiniau, enia vonamim matea sei mo lo hanhani peresiau nakerihi.” ");
INSERT INTO tgp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nona tamlohi la tapulo rongo mo sati, ale enira hatehateahi la lo usia isana lara, “Hare, enau teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu mo verea mara, “Vonamim matea la tupu sangavulu r̃omana mo rua, ale enia mo lo seseri peresiau nakerihi. ");
INSERT INTO tgp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Matan Natun Tamlohi i pa vano sohena Retiulia mo verea moiso matana. Pani rani sasati tavera isan tamlohi atu sei mo turuposi hiniau. I pa mele r̃uhu jea vara i sopo vora.” ");
INSERT INTO tgp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","La pa lo hanhani, Iesu mo lavi na pereti, mo vere meje matana, mo topea mo silea isana nona tamlohi ale mara, “Ha lavia. Harihi enia epeku!” ");
INSERT INTO tgp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mo mele lavi na paniken waen, mo vere meje isan God matana, moiso mo silea isara, ale enira isoiso la inua hinia. ");
INSERT INTO tgp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Moiso, mo verea isara mara, “Harihi enia r̃aeku sei i pa roro mata tamlohi matuvana matan vara i vai na retitauhi paro non God peresi na nona tamlohi i turu. ");
INSERT INTO tgp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Varar̃uhu na verea isamim, a pa sopo er̃i mele inu te waen i tikeli rani atu a pa mele inua peresi kamim hin mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","La lalavete na vete matea moiso, la malue la sahe na Vuti talu Olive. ");
INSERT INTO tgp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na malele Iesu mo verea isara mara, “Kamim mo isoiso ha pa rovo hiniau, matan Retiulia non God mo verea mara, ‘A pa vili na tavui sipsip. Sipsip la pa rovo.’ ");
INSERT INTO tgp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pani hitahu vara na mele turu na mateia, a pa vano tiroma hin kamim Galilee.” ");
INSERT INTO tgp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter mo verea isana mara, “Hina purongo vara enira mo isoiso la rovo hiniho, enau i vono!” ");
INSERT INTO tgp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu mo verea isan Peter mara, “Varar̃uhu na verea isam, o pa vunvuniau vaha tolu nohorihi na vutepongi, moiso toa i pa tarere vaha rua.” ");
INSERT INTO tgp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pani Peter mo reti r̃ilangi mara, “Vara a pa mate peresiho, i pa sohena! A pa sopo er̃i vunvuniho!” Enira mo isoiso la verea sohena. ");
INSERT INTO tgp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","La sahe na jara la tovia Gethsemane, Iesu mo verea isana nona tamlohi usuri mara, “Ha lo sakele nike tako. Enau a sahe a usiusi.” ");
INSERT INTO tgp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mo lavi Peter, James, John la vano peresia, ale mo tapulo rongo mo sati tavera jea, ale r̃omina mo sopo sakele. ");
INSERT INTO tgp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ale mo verea isara mara, “R̃omiku mo jovi tavera vara a mate matana. Ha lo toho peresiau, ha sopo juruvi!” ");
INSERT INTO tgp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mo mele vano makomona, mo jovi sivo na lepa mo usiusi isan God mara vara te malele tinapua, i pa sopo vano hin nona rani r̃ilangi nike. ");
INSERT INTO tgp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ale Iesu mara, “Tata! Tamaku! Ko er̃i vai na hinau tari. O lavi nar̃ihi na noku rani r̃ilangi nike, pani o sopo vaia sohena masaloku, pani sohena masalom.” ");
INSERT INTO tgp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mo mele sinai mo hite Peter la juruvi r̃omaliho. Mo verea isan Peter mara, “Simon, varar̃uhu ko lo juruvi? O sopo er̃i kilau peresiau matan te matan alo hatelete purongo? ");
INSERT INTO tgp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ha lo kilau! Ha lo usiusi, matan vara ha pa sopo jovi na vaihite. Tanumemim mo opoia vara i oloolo, pani masalomim mo r̃ilangi jea.” ");
INSERT INTO tgp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Moiso, mo mele sahe vara i usiusi, mo mele vere la nona reti atu tiroma. ");
INSERT INTO tgp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mo mele sinai, mo mele vileia vara la mele juruvi moiso, ale matan matara mo puhoni, la sopo er̃i r̃aramia. ");
INSERT INTO tgp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iesu mara mo mele mai hatoluna, mo verea isara mara, “Varar̃uhu ka pa lo juruvi, ka pa lo mapu? Mo isoiso natu, la tau Natun Tamlohi na lima tamlohi hehe natu. ");
INSERT INTO tgp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ha turu! R̃a vano! Ka hitea, noku meresahi mo lo mai moiso.” ");
INSERT INTO tgp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu mo pa lo retireti Judas vonan la tupu sangavulu r̃omana mo rua atu matea mo pala isara peresi na vao tavera matea, la mai la lo lavi na sita mata valum peresi na nalnal. Pr̃is aulu peresi na tamlohi vujangi mata leu peresi na vajiahara natu la r̃ulera la mai isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ale tamlohi atu mo lo turuposi hinia mo verera na matamata matea isara moiso mara, “Tamlohi atu a pa pungosia, enia tamlohi atu natu. Ha tauria, ha lavia i vano.” ");
INSERT INTO tgp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas mo kakau jara atu, mo vano isan Iesu mo verea mara, “Tija.” Ale mo pungosia. ");
INSERT INTO tgp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ale la tamlohi atu la mai la tauri Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pani vonara matea sei mo lo turu atu mo lavi na nona sita vuro mo langai nar̃ihi na pero volitusi non pr̃is aulu. ");
INSERT INTO tgp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu mo verea isara mara, “Ka mai peresi na sita peresi na nalnal sohena vara enau tamlohi vili tamlohi mata vavanaho matea? ");
INSERT INTO tgp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tarea na lo toho peresi kamim na lolo Temple na lo vujangi, pani ka sopo tauriau. Pani i pa sohen harihi matan vara Retiulia i pa masese mataku.” ");
INSERT INTO tgp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nona tamlohi la malue isana, ale la rovo. ");
INSERT INTO tgp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uluvou matea mo lo usuri Iesu, enia mo lavolavo purongo, ale la tauria, ");
INSERT INTO tgp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pani la lo taurilati na nona ruru purongo, ale mo tinar̃ihira mo rovo malamala. ");
INSERT INTO tgp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","La lavi Iesu mo vano na iman pr̃is aulu. Ale moli nona pr̃is tari peresi na vajiahara peresi na tamlohi vujangi mata leu la matavuhi jara matea. ");
INSERT INTO tgp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ale Peter mo lo usuri Iesu asau makomona mo sivo vahatea na lolo ropen iman pr̃is aulu atu. Mo lo sakele peresi la tamlohi kilau matan ima atu, la lo marijo na hapu. ");
INSERT INTO tgp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Moli nona pr̃is peresi la tamlohi tari mata council Aulu, la lo aleale tamlohi vara i vereuli te hinau hin Iesu matan vara la pa vilimateia matana, pani la sopo vilei tea. ");
INSERT INTO tgp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tamlohi matuvana la vai na retihalu hinia, pani nora retihalu la sopo matea. ");
INSERT INTO tgp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hai la turu sahe la retihalu hinia lara, ");
INSERT INTO tgp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kama rongoa mo verea mara, ‘Enau a pa viliroiroi Temple nike sei tamlohi la vaia na limara, moiso na rani i tolu purongo a pa mele voroa na hina tinapua sei tamlohi la sopo voroa na limara.’” ");
INSERT INTO tgp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pani mo sohen tiroma, nora r̃omr̃omi mo sopo matea. ");
INSERT INTO tgp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Moiso nora pr̃is aulu mo turu na livuhara, mo verea isan Iesu mara, “Mo sopo te nom retireti vara o verea matan la retireti nike? Sava nahai, la tamlohi nike la lo vereulia matam?” ");
INSERT INTO tgp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pani Iesu mo sopo langati na jingona, ale mo sopo r̃aramia. Pr̃is aulu atu mo mele usia vahatea mara, “Engko natu Kr̃isto atu, Natun God teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu mo r̃aramia mara, “Enau natu, ale ha pa hite Natun Tamlohi i pa sakele na tavalu liman God na jara mata suiha, ale ha pa hite Natun Tamlohi i mele mai na telangi matan tuka.” ");
INSERT INTO tgp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ale pr̃is aulu mara mo rongoa sohena, mo hasena r̃ari na nona ruru, ale mo verea mara, “Mata sava r̃a pa lo mele aleale retireti vara r̃a pa tuvaia hinia? Enia hasena mo verea! ");
INSERT INTO tgp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ka pete rongo sohena sava mo verea moiso vara enia God. Ha pa vai na sava?” Enira mo isoiso la verea lara i mate. ");
INSERT INTO tgp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hai la tapulo litovia, hai la tatavuhoro na nahona la tutuhia, ale la usia isana lara, “Vara engko pr̃ovet matea, o to verea vara hare natu mo tutuhiho?” Ale tamlohi kilau sohena lara la lavia mo vano la tutuhia. ");
INSERT INTO tgp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Hinau atu mo lo masese, Peter mo lo toho atano na lolo rope matan ima atu na jingoima. Ale volitusi har̃ai matea non pr̃is aulu mo mai, ");
INSERT INTO tgp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","mara mo hite Peter mo lo marijo, mo lo kilau mamahunia, ale mara, “Engko vonara matea ko lo usuri Iesu mara Nazareth!” ");
INSERT INTO tgp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pani Peter mo vunvunia, ale mara, “Na sopo levosahia teni a levosahi na sava ko lo verea.” Mo malue atu mo vano mo turu na mataruan rope atu, ale toa mo tarere. ");
INSERT INTO tgp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pa har̃ai atu mo mele hite Peter mo lo turu atu ale mo verea isana tamlohi mara, “Tamlohi aturihi enia vonara matea!” ");
INSERT INTO tgp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peter mo mele vunvunia. Ale tamlohi hai la lo turu atu la verea isan Peter lara, “Varar̃uhu engko vonara matea matan engko mara Galilee!” ");
INSERT INTO tgp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pani Peter mo tapulo lesati hinia hasena, mo varakali ale mo verea mara, “Na sopo levosahi tamlohi nike ka lo verea.” ");
INSERT INTO tgp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ale vahatea purongo, toa mo tarere haruana. Peter mo mele r̃omr̃omi na reti non Iesu sei mara, “Engko o pa vunvuniau vaha tolu, moiso toa i pa tarere vaha rua.” Moiso r̃omin Peter mo jovi tavera, ale mo tangi tavera. ");
INSERT INTO tgp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na r̃alavuho jea, moli mata pr̃is peresi na vajiahara tolu na tamlohi vujangi mata leu peresi na tamlohi mata council tari la matavuhi vara la vai te r̃omr̃omi. La lasi Iesu la lavia mo vano la taua na liman Pilate, tamlohi aulu nona gavman matan Rome. ");
INSERT INTO tgp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ale Pilate mo usia mara, “Engko Supe nona Jew?” Iesu mo verea mara, “He'e, mo sohen ko verea.” ");
INSERT INTO tgp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Moli nona pr̃is la tuvaia na retireti matuvana. ");
INSERT INTO tgp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate mo mele usi Iesu vahatea mara, “Mata sava ko sopo talaira? Ko hitea, la lo tuvaiho na hina sati matuvana!” ");
INSERT INTO tgp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pani Iesu mo sopo mele r̃aramia, ale Pilate mo mar̃urahi jea. ");
INSERT INTO tgp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tarea na hanhani tavera mata Passover, Pilate mo lo teri na tamlohi matea na ima r̃ilangi sei enira la opoia. ");
INSERT INTO tgp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vonara matea hin la haratu la lo toho na ima r̃ilangi hin rani atu, hijana Barabbas. Enia mo lo toho atu matan mo vilimateia na tamlohi matea na rani la turu mata valum mata jarara. ");
INSERT INTO tgp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Vao atu la mai isan Pilate ale la usia vara i mele vaia sohen tarea mo lo vaia isara. ");
INSERT INTO tgp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ale Pilate mo usia isara mara, “Ka opoia vara a tinar̃ihi Supe nona Jew nike teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Matan Pilate mo levosahia vara la pa lavi Iesu mo mai isana mata nora mereimerei purongo. ");
INSERT INTO tgp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pani moli nona pr̃is la haluhalu na tamlohi mata usi Pilate vara i teri Barabbas na jaran Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ale Pilate mo mele usia isara vahatea mara, “Vara i sohena, a pa vai na sava hin tamlohi nike sei ka lo tovia vara enia Supe nona Jew?” ");
INSERT INTO tgp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","La mele ngara lara, “O vosaea na talopeilopei!” ");
INSERT INTO tgp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate mo mele usira hinia mara, “Sava hinau natu mo vaia mo sati?” Pani la mele ngara mo r̃ilangi jea lara, “O vosaea na talopeilopei!” ");
INSERT INTO tgp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ale matan Pilate mo opoia vara i vai vao atu i avulahi, mo teri Barabbas sohen la usia. Ale mo retileu vara la rupi Iesu, moiso mo taua na lima tamlohi vuro nona mara Rome vara la vosaea na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","La tamlohi vuro atu la tiroma hin Iesu la unu na lolo nora patu ima mata vuro non Pilate. La tovi vevuhi na vao tamlohi vuro la mai na jara matea. ");
INSERT INTO tgp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","La mai la rua na ruru perpel matea, ale la viriviri na asi ngar̃ngar̃iha matea sohena rongorongo nona supe, ale la taua na patuna. ");
INSERT INTO tgp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","La tapulo salute isana la lo verea lara, “Tamlohi tavera, engko Supe nona Jew!” ");
INSERT INTO tgp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La lo tamaji na patuna na apo matea. La lo litovia, ale la lo popovitoho isana sohena vara la lo lotua. ");
INSERT INTO tgp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lara la kerehia moiso la mele lavi nar̃ihi pa ruru perpel atu isana, ale la mele rurua na nona ruru. Ale la tiroma hinia la vano vara la vosaea na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ale mara Cyrene matea, hijana Simon, enia tamana Alexander enia Rufus, mo pa lo tai purongo asau r̃ove na jara vutivuti mo lo sinai na malele, ale la ngurunguru hinia vara i soloti na talopeilopei non Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","La lavi Iesu mo sahe hin jara atu sei la tovia ‘Golgotha’, r̃aramin hija sei enia ‘Jara Sui Patu Tamlohi’. ");
INSERT INTO tgp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","La vaihitea vara la sile na waen la hoihoia peresi na myrrh, pani mo r̃ohu hinia. ");
INSERT INTO tgp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","La vosae Iesu na talopeilopei, moiso la tamlohi vuro atu la roro mata nona ruru na taes matan vara la vileia vara hare natu i pa lavi na sava nona ruru. ");
INSERT INTO tgp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Matan alo mo limaravati na r̃alavuho natu la vosaea na talopeilopei hinia. ");
INSERT INTO tgp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","La uli na reti matea mata nona aria na tavalu tapea matea la vosaea aulu na patuna mo verea vara, Supe Nona Jew ");
INSERT INTO tgp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","La vosae na tamlohi vili na tamlohi mata vavanaho tupra rua na tavalun Iesu. Matea na matuana, ale matea na marauna. ");
INSERT INTO tgp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","29","Tamlohi sei la lo hahau hin malele atu la lo tar̃a sahe la lo kerehia, ale la lo pulapulahi na patura, la lo verea lara, “Ko vara, vara o pa vilijovjovi na Temple, ale o er̃i mele voroa rani i tolu? ");
INSERT INTO tgp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Vara mo sohena, o hasem juriho o sevuti hin talopeilopei sei!” ");
INSERT INTO tgp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Moli nona pr̃is peresi na tamlohi vujangi mata leu sohena la lo vaivaia isara hasera lara, “Mo lo juri na tamlohi tinapua, pani enia i sopo er̃i hase juria! ");
INSERT INTO tgp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Vara engko Kr̃isto, Supe non Israel, o sevuti na talopeilopei nakerihi matan vara kama pa hitea ale kama rasuho!” La tamlohi atu sei la vosaera na pahisan Iesu sohena, la lo kerehia. ");
INSERT INTO tgp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na livuha rani, r̃or̃oha tavera mo jovi mo tavuni na jara tari, mo lo toho mo tikeli na matan alo mo tolu na ravravi. ");
INSERT INTO tgp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na matan alo mo tolu, Iesu mo tangi na ulo tavera matea mara, “Eloe, eloe, lema sabatani?” R̃aramina reti sei enia ‘Noku God, noku God, mata sava ko posi na nahom isaku?’ ");
INSERT INTO tgp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tamlohi hai la lo turu atu lara lo rongoa, lara, “Ka hitea! Mo lo tovi Elijah!” ");
INSERT INTO tgp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tamlohi matea mo maro mo vano mo lavi na tavalu ruru matea la r̃ur̃unia na waen hohona mo pesia na apo matea, ale mo sohaia sahe isan Iesu vara i inua. Vonara matea mara, “Tako, r̃a pa hitea vara Elijah i pa mai i lavi nar̃ihia na talopeilopei i sivo atano teni i vono.” ");
INSERT INTO tgp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu mo mele ulo tavera vahatea, ale maromarona mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ruru tavera atu mo lo toho horo na Jara Tapu atu na lolo Temple mo mar̃ari hasena tavaluna mo rua, mo mar̃ari mo tapulo aulu mo sivo atano. ");
INSERT INTO tgp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Moiso captain mata tamlohi vuro atu sei mo lo turu tataholo na nahon Iesu, mara mo hitea sohena sava mo mate mo verea mara, “Varar̃uhu, tamlohi nike enia Natun God tataholo!” ");
INSERT INTO tgp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Har̃ai hai la lo turu asau makomona la lo kilau vano na talopeilopei. La har̃ai sei la tupu tolu, Mary Magdalene, Salome, Mary tinan uluvou sei James peresi Joses. ");
INSERT INTO tgp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","La har̃ai sei la lo usuri Iesu na rani mo lo toho Galilee, ale la lo kilaua. Vao har̃ai matuvana sohena, enira tolu natu la lo usuria la sinai Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","La hinau sei la masese na Friday ravravi, enia rani mata tatamahu mata nora Sabbath. ");
INSERT INTO tgp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph mara Arimathea, enia tamlohi aulu matea mata nora council tavera, ale enia matea sei mo lo kilau toho matan mauri atu God mo aulu hinia vara i pala. Ale r̃omina mo r̃ilangi mo mai mo turu na nahon Pilate mo usia vara i lavi na tarapen Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate mo rongoa vara Iesu mo mate vila, moiso mo mar̃urahi tavera matana. Pilate mo tovi na nona captain mata tamlohi vuro matea, mo usia mara, “Varar̃uhu, Iesu mo pete mate moiso?” ");
INSERT INTO tgp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Captain atu mo vere Pilate hinia mara varar̃uhu mo mate moiso. Pilate mo verea isan Joseph mara i er̃i lavi na tarapen Iesu. ");
INSERT INTO tgp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph mo vano mo voli na ruru lulu matea. Mo juri na tarapen Iesu aulu na talopeilopei mo sivo atano. Mo leputia na ruru. Mo lavi na tarapen Iesu mo taua na papa vatu matea enia mo taia. Mo tai na pelatina vatu tavera matea vara mataruana. ");
INSERT INTO tgp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene enia Mary tinan Joses la hite jara atu la tau na tarapen Iesu ea. ");
INSERT INTO tgp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Saturday na ravravi jea na isoison rani mapu atu, Mary Magdalene, Mary tinan James enia Salome, la vano la voli te hasori r̃uhu vara la pa vano la taua na tarapen Iesu vara i mele rani sahe. ");
INSERT INTO tgp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sunday r̃alavuho jea alo mo pa lo tapulo vele purongo, la vano hin papa vatu atu. ");
INSERT INTO tgp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","La pa lo vano la lo vereverea isara lara, “Hare i pa tuenir̃a vara i kuresi nar̃ihi vatu atu na mataruan papa atu?” ");
INSERT INTO tgp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ale lara la tar̃a sahe aulu, la hite vatu tavera atu la pete kuresi nar̃ihia moiso. ");
INSERT INTO tgp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","La sahe la unu hin papa atu ale la hite na uluvou matea, mo ru na ruru lulu mo lo sakele na matuana, ale la hutura hinia. ");
INSERT INTO tgp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ale mo verea isara mara, “Ha sopo matahu! Ka lo ale Iesu mara Nazareth haratu sei la vosaea na talopeilopei? Mo turu na mateia moiso, enia mo sopo toho nike. Ha to hite na jara sei la taua hinia. ");
INSERT INTO tgp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pani ha vano ha verea isana nona tamlohi usuri peresi Peter, ha verera vara Iesu mo vano Galilee tiroma hin kamim moiso. Ha vano ha pa hitea ea sohen mo lo verea isamim tiroma moiso.” ");
INSERT INTO tgp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","La har̃ai atu lara la malue la rovo hin papa atu matan matahu mo sohonira ale la savaravara. La sopo vere te hinau isan tea matan la matahu. Ale la vere vevuhi na hinau tari isan Peter peresi na tapalana. Hitahuna Iesu mo r̃ulera la vano na varama, la vano Opae mo sivo mo tikeli Marino, la lavi nona Retir̃uhu tapu mata juri sei mo lo sile na mauri tui sei i sopo er̃i tihai hin te rani. Amen. ");
INSERT INTO tgp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu mo mele turu na Sunday na r̃alavuho jea, ale Mary Magdalene natu enia har̃ai tiroma mo hitea, enia natu Iesu mo titiu nar̃ihi na tanume sasati mo limaravrua isana. ");
INSERT INTO tgp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hitahu Mary mo vano mo verea isana nona tamlohi usuri sei la lo rongo mo sati ale la lo tangisia. ");
INSERT INTO tgp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pani lara la rongoa vara Mary mo hite Iesu mo mele mauri, la sopo rasua. ");
INSERT INTO tgp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hitahun la hinau atu Iesu mo mele pala isana tupra rua sei la lo hahau mata jara tinapua matea, pani la sopo hitevosahia matan mo posi na nahona. ");
INSERT INTO tgp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hitahuna lara la hitevosahia la mele hilu vilavila la sahe vara la verea isana tatuara, pani tea i sopo rasura. ");
INSERT INTO tgp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hitahuna Iesu mo pala isan la tupu sangavulu r̃omana matea atu lara la lo hanhani. Ale mo reti r̃ilangi isara matan mo sopo te nora rasua, ale mata r̃omira mo r̃ilangi jea. Mo reti r̃ilangi sohena matan la sopo rasu la haratu sei la hitea vara mo mele mauri. ");
INSERT INTO tgp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ale mo verea isara mara, “Ha vano na jara tari na varama, ale ha vereuli na noku Retir̃uhu isana tamlohi tari. ");
INSERT INTO tgp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sava tamlohi mo rasua ale mo paptijo, God i pa juria, pani haratu mo sopo rasua, God i pa aria. ");
INSERT INTO tgp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","God i pa sile la matamata tavera akerihi natu i usuri la haratu la rasuau: na hijaku la pa er̃i titiu nar̃ihi na tanume sasati, ale la pa er̃i retireti na leo paro tinapua, ");
INSERT INTO tgp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ale la pa tauri na mata sasati jea na limara, ale vara la inu te wai mata vilimatei na tamlohi la pa sopo er̃i mate matana. La pa tau na limara na tamlohi rojoa moiso ale nora rojoa i tihai.” ");
INSERT INTO tgp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iesu mara mo vere la hinau atu isara mo isoiso, God mo lavi nar̃ihia mo sahe aulu na tuka, ale mo sakele na jara mata suiha na matuan God. ");
INSERT INTO tgp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ale nona tamlohi usuri la vano la retivujavujangi na jara hatehateahi. Moli Iesu mo lo tuenira na nora vavahinau, ale mo vujangia vara nora reti mo tai isana na matamata matuvana. ");
INSERT INTO tgp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Enau Luke, na uli reti nike isam tamlohi tavera Theophilus. Tamlohi matuvana la vaihitea vara la uli na sorasora mata sava mo masese isar̃a mo tikeli nake, ");
INSERT INTO tgp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","sohen la sorasora atu r̃a lavia isan la haratu enira la hitea na matara, ale enira la volitusi mata reti non God mo tapulo na tapulona. ");
INSERT INTO tgp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ale matana, enau sohena, mo tataholo vara a uli na hinau tari sei la masese na tapulona mo sinai nake isam tamlohi tavera r̃uhur̃uhu Theophilus, matan enau sohena na usuri mamahuni la hinau sei mo tapulo na tapulona, ");
INSERT INTO tgp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","matan vara o pa er̃i levosahi mamahunia vara la hinau sei la lo vujangiho hinira moiso la varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na rani non Herod supe non Judea, pr̃is matea hijana Zechariah enia mo tai na vao pr̃is non Abijah, ale narouna sohena, enia mahapin Aaron, hijana Elizabeth. ");
INSERT INTO tgp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ale la tupra rua sei maurira la tataholo mo r̃uhu na nahon God. La lo oloolo mamahu na nona retileu peresi na leu tari, ale tea i sopo er̃i tuvaira hin te hinau. ");
INSERT INTO tgp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pani mo sopo te natura matan Elizabeth mo aroaro, ale la vajiaha moiso. ");
INSERT INTO tgp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na rani matea, hinau matea mo masese isana hin rani atu mo lo voko peresi na nona vao pr̃is na Temple non God. ");
INSERT INTO tgp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Vao pr̃is atu la vir̃onia usuri na nora posposi mata vir̃oni sohen la lo vaia tarea vara i unu na Temple non Moli vara i suli na hasori ea. ");
INSERT INTO tgp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ale rani tataholo mata suli na hasori mo mai, vao tavera mata lotu la lo pulutahi mata usiusi na jingoima. ");
INSERT INTO tgp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zechariah mo lo toho atu, ale angelo non Moli matea mo pala isana, mo turu na matua votavota mata suli na hasori. ");
INSERT INTO tgp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah mara mo hite angelo atu mo hutua, ale matahu tavera mo sohonia. ");
INSERT INTO tgp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pani angelo atu mo verea isana mara, “Zechariah, o sopo matahu! Nom usiusi God mo rongoa moiso, ale naroum Elizabeth i pa vasusui na natum lamane matea, ale o pa tau na hijana vara John. ");
INSERT INTO tgp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ale i pa vaiho o avulahi, o avulahi tavera jea, ale tamlohi matuvana sohena, la pa avulahi na nona rani vora, ");
INSERT INTO tgp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","matan God i pa silea na vavahinau matea mo aulu jea. I pa sopo inu na waen teni te wai r̃ilangi tinapua hin te rani, ale Tanume Tapu i pa mar̃ivisia i tapulo na lolo pangen tinana. ");
INSERT INTO tgp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ale enia i pa posi na natun Israel matuvana la mele mai isan Moli nora God. ");
INSERT INTO tgp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ale enia i pa vano tiroma hin Moli hin suiha atu Tanumen God mo silea isan pr̃ovet Elijah, matan vara i posi na r̃omr̃omi nona tama vara la r̃omr̃omi na natura, ale la haratu la sopo oloolo hin God la usuri na posposi nona tamlohi tataholo, matan vara i vai na vao tamlohi matea la tatamahu matan Moli.” ");
INSERT INTO tgp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ale Zechariah mo verea isan angelo atu mara, “Avei, sohena sava natu a pa er̃i levosahia vara i pa sohen ko lo verea? Matan enau na vajiaha moiso, ale taunin narouku mo jeu na rani mata nona tatape moiso.” ");
INSERT INTO tgp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ale angelo atu mo r̃aramia mara, “Enau Gabriel, haratu sei mo lo turu na nahon God, ale God mo r̃uleau vara a sinai isam vara a vereho hin retir̃uhu nike. ");
INSERT INTO tgp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ale nakerihi, o pa mengo, o sopo er̃i vere te reti vavano i tikeli rani atu i masese matan ko sopo rasu na noku reti, sei la pa masese na ranira tataholo.” ");
INSERT INTO tgp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ale vao tamlohi la lo saovi Zechariah na jingoima, ale la lo r̃omr̃omia vara mo pa lo toma na lolo Temple. ");
INSERT INTO tgp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ale mara mo malue, mo sopo er̃i retireti isara, ale la hitevosahia vara God mo vujangia na hinau matea na lolo Temple, ale mo lo vai na matamata nakonako isara, ale mo sopo er̃i retireti. ");
INSERT INTO tgp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ale nona rani mata vavahinau mo isoiso, ale mo mele mule. ");
INSERT INTO tgp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hitahun la rani atu, narouna Elizabeth mo tau natuna, ale mo luhu mata vitu mo lima mara, ");
INSERT INTO tgp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Moli mo r̃omr̃uhu isaku, mo lavi nar̃ihi na noku mahanuhanu mata aroaro na tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth mo epe puhoni mata vitu mo limarave moiso, ale God mo r̃ule pa angelo atu, Gabriel vara i sivo Nazareth, vanua matea hin Galilee, ");
INSERT INTO tgp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","mo sivo isana har̃ai maevo matea hijana Mary. La tauhoroa moiso vara i pa lahi vano isana tamlohi matea hijana Joseph, enia mahapin Supe David matea. ");
INSERT INTO tgp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel mo pala isana mara, “Ranir̃uhu isam, engko har̃ai matea God mo r̃omr̃uhu isam mo tavera jea! Moli mo lo toho peresiho.” ");
INSERT INTO tgp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pani Mary, r̃omina mo tuturahi hajavua hin retireti atu, ale mo vaihitea vara i levosahi na r̃aramin retioloolo atu. ");
INSERT INTO tgp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ale angelo atu mo verea isana mara, “O sopo matahu! Mary, matan na masalon God mo opoia vara i r̃uhu isam. ");
INSERT INTO tgp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ale mo tapulo nake, o pa tau natum, ale o pa tape na lamane matea, ale o pa tau na hijana vara Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Enia i pa tamlohi aulu jea, ale la pa tovia Natun God, sei mo aulu jea. Ale Moli God i pa silea na suiha nona supe non tamana Supe David. ");
INSERT INTO tgp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Enia i pa tauri na suiha vara i aulu na vaon Israel tui tui, ale i pa sopo te isoiso rani mata nona tauri na suiha.” ");
INSERT INTO tgp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary mo usia isan angelo atu mara, “Hinau atu i pa mai sohena sava, matan enau har̃ai maevo matea?” ");
INSERT INTO tgp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelo atu mo r̃aramia mara, “Tanume Tapu i pa mai hiniho, ale suihan God Aulu jea i pa hohoviho; ale matana, natirihi sei i pa vora i pa tapu, la pa tovia — Natun God. ");
INSERT INTO tgp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ale ko levosahia vara tahisam Elizabeth na nona vajiaha enia sohena, mo tau natuna lamane matea, ale vitu akerihi enia nona halimarave vitu isana har̃ai matea la verea vara enia har̃ai aroaro matea! ");
INSERT INTO tgp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Matan mo sopo te hinau hatea i r̃ilangi jea vara God i sopo er̃i vaia.” ");
INSERT INTO tgp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ale Mary mara, “Varar̃uhu enau har̃ai slev non God purongo. Na opoia vara hinau atu i mai isaku sohena ko verea.” Ale angelo atu mo mele malue mo vano. ");
INSERT INTO tgp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hitahun rani atu, Mary mo vele sahe na jara vutivuti, mo sivo vila na taon matea na lolon jara matan Judea. ");
INSERT INTO tgp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mo unu na iman Zechariah, ale mo vere na retioloolo isan Elizabeth. ");
INSERT INTO tgp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ale Elizabeth mara mo rongo na retioloolo non Mary, pipi atu na lolona mo hisu, ale Tanume Tapu mo mar̃ivisi Elizabeth, ");
INSERT INTO tgp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mo verea aulu mara, “Avulahi tavera jea isam mo jeu na har̃ai tinapua. God mo ler̃uhu hin natirihi sei mo lo toho na lolom. ");
INSERT INTO tgp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ale enau hare vara tinan noku Moli i er̃i mai vara i rohiau? ");
INSERT INTO tgp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Matan, vahatea purongo atu sei nara na rongo na nom retioloolo, pipi nike, na loloku mo hisu na avulahi. ");
INSERT INTO tgp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Avulahi tavera isam matan ko rasu Moli vara i pa vai na sava mo verea isam!” ");
INSERT INTO tgp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ale Mary mo verea mara, “Na r̃omiku na hasohaso God mo tavera jea, ");
INSERT INTO tgp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ale mauriku mo avulahi tavera hin God noku Jujuri, ");
INSERT INTO tgp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","matan mo kilau mai isaku nona har̃ai volitusi atano, ale mo tapulo nake, mahapi tari la pa verea vara avulahi tavera mo mai isaku, ");
INSERT INTO tgp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","matan haratu sei mo r̃ilangi jea mo vai na hinau tavera isaku, ale hijana mo tapu. ");
INSERT INTO tgp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ale nona r̃omopoia mo vano isana mahapi tari, isan la haratu sei la lo sile na oloolo tavera isana. ");
INSERT INTO tgp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Enia mo vujangi na nona suiha, mo leputi jalajalai la haratu la mangisi na mapura. ");
INSERT INTO tgp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mo lavi nar̃ihi la haratu la lo tauri na suiha nona supe, ale mo tahe la haratu r̃omira la atano la sahe aulu. ");
INSERT INTO tgp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mo sohoni la haratu la marohati na hina r̃uhu, pani mo r̃ule nar̃ihi la haratu la tavtav la vano lekoleko. ");
INSERT INTO tgp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mo tueni nona volitusi Israel, usuri na nona retitauhi mata nona r̃omopoia hinira, ");
INSERT INTO tgp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","matan mo retitauhi vara i pa r̃omopoi isan Abraham peresi na taniana na rani tui tui.” ");
INSERT INTO tgp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary mo lo toho atu isan Elizabeth mata vitu mo tolu, moiso mo pa mele mule vano na jarana. ");
INSERT INTO tgp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ale vitu non Elizabeth mo asi vara i lavlavi, ale mo vasusui na nona pipi lamane matea. ");
INSERT INTO tgp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ale tavtavuina peresi na tahisana la rongoa vara Moli mo r̃omr̃uhu tavera jea isana, ale la avulahi peresia. ");
INSERT INTO tgp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ale na halimaravtolu rani la mai vara la vai na nona tair̃alihi. Tatuara la lo opoia vara la tau na hijana vara Zechariah vara i lavi na hijan tamana, ");
INSERT INTO tgp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","pani tinana mo verea mara, “Mo vono, enia hijana John.” ");
INSERT INTO tgp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ale la verea isan Elizabeth lara, “Mo sopo te tavtavuim hijana i sohen haratu!” ");
INSERT INTO tgp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ale la vai na matamata hai isan tamana na limara vara sava hija natu, enia mo opoia vara i silea isana. ");
INSERT INTO tgp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ale Zechariah mo usia vara la lavi te hinau mata uliuli hinia i mai isana, ale la mar̃urahi tavera matan mo ulia mara, “Hijana enia John.” ");
INSERT INTO tgp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ale vahatea purongo memena mo mele materi, ale mo retireti mo hasohaso God. ");
INSERT INTO tgp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tahisara tari la hutura, ale la matahu, ale sorasora atu mo r̃alihi vevuhi na jara tari na jara vutivuti Judea. ");
INSERT INTO tgp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ale tamlohi tari sei la rongora la sopo levosahia vara natirihi atu i pa sava tamlohi pavuho natu matan liman Moli mo lo toho hinia. ");
INSERT INTO tgp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ale tamana, Zechariah, Tanume Tapu mo mar̃ivisia, ale mo retimangovi mara, ");
INSERT INTO tgp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Hasohaso tavera isan Moli God matan Israel, matan nake mo rohi na nona tamlohi vara i jurira, ");
INSERT INTO tgp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God mo siler̃a na Tamlohi Jujuri matea mo suiha tavera mo tai na iman nona volitusi supe David, ");
INSERT INTO tgp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sohena nona pr̃ovet tapu tuai la verea ");
INSERT INTO tgp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","lara vara i pa jurir̃a isana nor̃a meresahi, ale na liman la haratu sei la r̃ohu hinir̃a. ");
INSERT INTO tgp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mo mar̃ivisi na nona retitauhi tapu sei vara i pa r̃omi na nomam pua, ");
INSERT INTO tgp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","retitauhi atu mo silea isan tamar̃a Abraham vara i pa vaia, ");
INSERT INTO tgp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ale vara i jurir̃a isana nor̃a meresahi, ale i pa tuenir̃a vara r̃a volitusi isana i sopo te matahu isar̃a, ");
INSERT INTO tgp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na mauri tapu mo tataholo na nahona mata nor̃a rani tari. ");
INSERT INTO tgp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ale engko natuku, la pa toviho pr̃ovet non haratu mo aulu jea; matan engko o pa vano tiroma hin Moli, mata vai mamahuni na malelena, ");
INSERT INTO tgp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","o pa vere na tamlohi sohena sava God i pa jurira matan i pa r̃omi na nora hehe. ");
INSERT INTO tgp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","matan nor̃a God enia God mata r̃omi na tamlohi na nona r̃omr̃uhu, matan mai non nona Jujuri mo sohena alo mo vele aulu mo sinai isar̃a na tuka, ");
INSERT INTO tgp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","vara i mera isan la haratu la lo toho na r̃or̃oha, ale na liman mateia, matan vara i tiromar̃a na malele mata tamata.” ");
INSERT INTO tgp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ale pa natirihi atu mo ulua, ale Tanume Tapu na maurina mo suiha, ale mo lo toho na tano koru mo tikeli na rani mata nona pala na naho tamlohin Israel. ");
INSERT INTO tgp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hin pongi atu, supe nona mara Rome, enia Augustus, ale mo verea mara la evi vevuhi na tamlohi r̃alihi na jara tari sei enia mo lo tauri na suiha hinira na varama. ");
INSERT INTO tgp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Harihi enia tiroma evi na tamlohi hin pongi atu Quirinius, tamlohi aulu matea mara Rome mo lo aulu hin Syria. ");
INSERT INTO tgp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ale, tamlohi tari la vano na jarara tataholo vara la pa sile na hijara ea. ");
INSERT INTO tgp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ale Joseph mo malue Galilee na taon matan Nazareth mo sahe na taon non pin supe David sei Bethlehem na jara matan Judea, matan enia tahisan supe David, ");
INSERT INTO tgp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","vara i tau na hijana peresi Mary, har̃ai atu sei mo tauhoroa moiso mata lahi, ale mo tau natuna. ");
INSERT INTO tgp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ale hin pongi atu la pa lo toho atu, nona rani mo mai vara i lavilavi. ");
INSERT INTO tgp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ale mo vasui natuna vora tiroma lamane matea. Mo leputi mamahunia na ruru, ale mo taua sivo na puhoro r̃uvu hana maji palovati, matan mo sopo te mele masapa na lolon ima malele atu nona tamlohi la lo hahau. ");
INSERT INTO tgp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hin vutepongi atu, hin jara atu, na pahisan taon atu, tavui sipsip hai la lo toho saovi na pulara sipsip na jara r̃uvur̃uvu tavera. ");
INSERT INTO tgp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ale la pa hutura purongo, angelo non God matea mo pala isara, ale meran God mo merasahira, ale matahu mo sohoni vevuhi na epera. ");
INSERT INTO tgp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angelo atu mo verea isara mara, “Ha sopo matahu, matan enau na lavi na retir̃uhu mata avulahi tavera matea vara a silea isamim sei i pa nona tamlohi tari. ");
INSERT INTO tgp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Matan, nakerihi, natirihi matea mo vora isamim na taon non supe David, enia Kr̃isto sei i pa juri na tamlohi, nor̃a Moli. ");
INSERT INTO tgp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ha pa er̃i hitevosahia sohen harihi: ha pa hite na pipi matea, la leputia na ruru la taua mo lo juruvi na puhoro r̃uvu hana maji palovati.” ");
INSERT INTO tgp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ale, la pa hutura, vao angelo vuro na tuka la pala vahatea na har̃in pa angelo atu, ale la lo hasohaso God lara, ");
INSERT INTO tgp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hasohaso i sahe isan God na jarana aulu jea na tuka! Ale na varama, tamata i pa toho isan la haratu God mo avulahi hinira.” ");
INSERT INTO tgp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na rani la angelo atu la malue isara la sahe na tuka, la tavui sipsip atu la lo vereverea isara lara, “Ale r̃a vano, r̃a vano Bethlehem vara r̃a hite hinau sei Moli God mo lo verer̃a hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","La tamlohi atu la vano vilavila la tapai Mary enia Joseph, ale pa natirihi atu mo lo juruvi na r̃uvu na puhoro matea. ");
INSERT INTO tgp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lara la hitea, la vereuli na sava pa angelo atu mo lo verea isara matan natirihi atu. ");
INSERT INTO tgp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ale tamlohi tari sei la rongo la retireti atu, la mar̃urahi tavera na sava la tavui sipsip atu la verea isara. ");
INSERT INTO tgp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pani Mary mo tau mamahuni la hinau nike na r̃omina, ale mo lo r̃omr̃omira. ");
INSERT INTO tgp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ale pa la tavui sipsip atu la mele hilu vano isana pulara sipsip, la lo tahe na hijan God, ale la sile na hasohaso isana mata sava la rongoa, ale sava la hitea sohen la verea isara. ");
INSERT INTO tgp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mo kakau na halimaravtolu rani, vara i lavi na nona tair̃alihi, ale la tau na hijana vara Iesu, hija atu sei angelo atu mo lo silea tiroma moiso Mary mo pa tau natuna. ");
INSERT INTO tgp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ale mo kakau na rani mata malamalai matan vara i vai Joseph enia Mary la vokevoke usuri na Leu non Moses, la lavia mo sahe Jerusalem mata silea isan Moli God ");
INSERT INTO tgp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","sohen la ulia na leu non Moli God lara, ‘Lamane vora tiroma tari sei la malue na pangen tinara tiroma, enira la tapuhi non Moli God.’ ");
INSERT INTO tgp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ale la sile na malamalai usuri na sava leu non Moli God mo verea vara la vaia, ‘vomahe i rua teni te wepe i rua.’ ");
INSERT INTO tgp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ale hin pongi atu, mara Jerusalem matea, hijana Simon, enia tamlohi tataholo matea, ale r̃omina mo r̃ilangi mata lotu tarea. Mo lo kilau matan Jujuri non Israel, ale Tanume Tapu mo mar̃ivisia. ");
INSERT INTO tgp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tanume Tapu mo vujangia hinia moiso vara i pa sopo mate vavano i tikeli pongi atu i hite Kr̃isto non Moli God. ");
INSERT INTO tgp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ale Tanume Tapu mo vai na r̃omina vara i vano na lolo Temple, ale na rani taman Iesu enia tinana la lavia mo sinai matan vara la vai na posposi sei leu mo opoia, ");
INSERT INTO tgp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","mo tulia, ale mo sile na hasohaso isan God mara, ");
INSERT INTO tgp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Moli God, nake natu, na levosahia moiso vara o er̃i majinga hiniau nom volitusi, vara a mate na tamata matan nom retitauhi isaku mo masese, ");
INSERT INTO tgp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","matan mataku mo hite na nom Jujuri moiso, ");
INSERT INTO tgp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ko tatamahunia mata tamlohi tari, ");
INSERT INTO tgp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","enia malarani matea mata vuhesi God isana tamlohi r̃or̃oha tari, ale mata hasohaso nona nom tamlohin Israel.” ");
INSERT INTO tgp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taman Iesu enia tinana la mar̃urahi tavera na sava mo verea matana. ");
INSERT INTO tgp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ale Simon mo ler̃uhu hinira, ale mo verea isan tinana Mary mara, “God mo vir̃oni natirihi nike, vara i pa vai na tamlohi matuvana Israel la jovi, ale i pa tahe na tamlohi matuvana hinia, enia i pa matamata matea tamlohi la pa verelejlejia, ");
INSERT INTO tgp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","matan vara r̃omr̃omi nona tamlohi matuvana la pa mavuhesi, ale ko hitea, sita vuro i pa hoti na maurim tataholo.” ");
INSERT INTO tgp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pr̃ovet har̃ai matea mo lo toho atu hijana Anna, venatun Phanuel tavtavuin Asher. Enia mo vajiaha sasati moiso, mo lo toho peresi tuana mata tauni mo limaravrua purongo hin la rani atu mo pa lo har̃ai maevo, ");
INSERT INTO tgp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","moiso mo lo toho sohena har̃ai malepu matea mo tikeli na taunina mo ngavulu limaravtolu mo vati . Enia mo sopo lo malue hin Temple atu, mo lo lotu God na nona tapuhoro na hanhani peresi na nona usiusi tarea na rani peresi na vutepongi. ");
INSERT INTO tgp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ale mo sinai tataholo hinira atu, ale mo tapulo vere meje isan God. Mo retireti matan natirihi atu isan la haratu sei la lo kilau toho matan rani atu vara God i pa volituhu Jerusalem hinia. ");
INSERT INTO tgp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ale na rani Joseph enia Mary la vai vevuhi na sava leu non God mo opoia, la mele vano na jarara Galilee, na nora taon matan Nazareth. ");
INSERT INTO tgp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Natirihi atu mo ulua, mo mai mo r̃ilangi, ale r̃omina mo mar̃ivi na lelevosahi. Ale r̃omr̃uhu non God mo lo toho isana. ");
INSERT INTO tgp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na tauni hatehateahi tamana enia tinana la lo sahe Jerusalem mata Hanhani mata Passover. ");
INSERT INTO tgp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ale hin rani atu Iesu taunina mo tikeli mo sangavulu r̃omana mo rua, la mele sahe usuri na posposi sohen la lo vaia tarea matan Hanhani atu. ");
INSERT INTO tgp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ale na rani Hanhani atu mara mo isoiso, na malele la lo mele mule, uluvou atu Iesu mo pa lo toho Jerusalem. Tamana enia tinana la sopo levosahia, ");
INSERT INTO tgp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","pani mata rani matea la r̃omr̃omia vara mo lo hahau peresi na vaora, pani mo sopo tuai la tapulo alea isana tahisara peresi na tapalara na malele, ");
INSERT INTO tgp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ale lara la sopo hitea, la mele hilu la vano vara la alea Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","La alea, ale na hatolu rani la pa tapaia na lolo Temple, mo lo sakele na livuha tamlohi vujangi ea, mo lo tapurongo isara, ale mo lo usi na retiusia. ");
INSERT INTO tgp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ale tamlohi tari sei la rongoa la mar̃urahi tavera na nona lelevosahi peresi na nona r̃arami reti isara. ");
INSERT INTO tgp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ale tamana enia tinana lara la tapaia, la hutura tavera hinia. Ale tinana mo verea isana mara, “Natuku, mata sava ko vailehilehi kamam sohena? Enau tamam kama aleho vavano r̃omimam mo jovi tavera!” ");
INSERT INTO tgp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ale mo verea isara mara, “Ka lo aleau mata sava? Ka sopo levosahia vara enau a pa lo toho na iman tamaku?” ");
INSERT INTO tgp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pani la sopo levosahi na r̃aramin reti atu sei mo verea isara. ");
INSERT INTO tgp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ale mo usurira la sivo Nazareth, ale mo hase taua na ruhuruhu limara. Ale tinana mo tau mamahuni la hinau nike na r̃omina, ale mo lo r̃omr̃omira. ");
INSERT INTO tgp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ale Iesu mo ulua mo mai tamlohi, nona lelevosahi mo ulua, ale mo ulua na r̃omr̃uhu non God peresi na r̃omr̃omi nona tamlohi tari isana. ");
INSERT INTO tgp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na sangavulu r̃omana mo lima tauni, Tiberias Caesar, Supe nona mara Rome mo lo tauri na suiha, ale Pontius Pilate mo lo aulu hin Judea. Herod Antipas mo lo aulu hin Galilee, ale tasina Philip, mo lo kilau Ituraea peresi Trachonitis, ale Lisanias mo lo aulu hin Abilene, ");
INSERT INTO tgp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ale tataholo hin rani atu Annas peresi Caiaphas la lo pr̃is aulu, God mo sile na retisohai matea isan John natun Zechariah hin rani atu mo lo toho na jara tano koru. ");
INSERT INTO tgp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ale John mo hahau r̃alihi na jara tari Jordan, ale mo vano mo lo retivujavujangi isana tamlohi vara la lavi na paptijo mata posi na hehe matan vara Moli i r̃omira. ");
INSERT INTO tgp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sohen pr̃ovet Isaiah mo ulia mara, ‘Na jara hasetoho leon matea mo lo ulo mara: Ha vasahi na malelen Moli God! Ha tano na malelena i tataholo. ");
INSERT INTO tgp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","God i pa tavuni na vakoa tari, ale i pa mavalolohi na vutivuti tari la mai la tataholo i r̃uhu, ale kolekole la pa tataholo, ale malele morumoruha la pa tataholo, ");
INSERT INTO tgp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ale tamlohi tari la pa hite malele sei God i pa juri na tamlohi hinia.’ ");
INSERT INTO tgp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Vao tamlohi la lo mai mata paptijo isan John, ale mo lo verea isara mara, “Kamim mata sasati! Hare mo retir̃oar̃oahai kamim vara ha rovo na talai lolokoru non God mata hehe sei mo lo mai? ");
INSERT INTO tgp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ha namaha usuri na nomim posi na hehe. Ha sopo r̃omaulu vara, ‘Kamam kama juri matan tamamam Abraham!’, matan na verea tataholoi kamim hinia vara, God i er̃i vai la vatu nike la mai natun Abraham! ");
INSERT INTO tgp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Matan nakerihi, God mo lo ava na nona rita moiso mata wari. Matan, vipahai tari sei la sopo lavi na vuara r̃uhu, i pa tai jovjovira, ale i pa pulahira la vano na hapu.” ");
INSERT INTO tgp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ale vao atu la usia isana lara, “Vara mo sohena, kama pa vai na sava?” ");
INSERT INTO tgp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","John mo r̃aramira mara, “Vara nom ruru mo rua, o sile te hatea isan haratu mo sopo te nona ruru, ale haratu hana hinau mo matuvana, i vaia sohena.” ");
INSERT INTO tgp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tamlohi mata lavi na takis sohena, la mai isana mata paptijo, la verea isana lara, “Tija, kamam kama pa vai na sava?” ");
INSERT INTO tgp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ale mo verea isara mara, “Ha sopo lavi na mania i jeu na sava mo tataholo vara ha lavia.” ");
INSERT INTO tgp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Moiso, tamlohi vuro hai la usia lara, “Ale kamam, kama pa vai na sava?” Ale John mo verea isara mara, “Ha sopo vai na tamlohi la matahu mata lavi te mania isara, ha sopo tuvai na tamlohi na halu mata mania, ha avulahi na volimim.” ");
INSERT INTO tgp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ale matan tamlohi la lo kilau moiso mata rani pala non nora Kr̃isto, enira mo isoiso la lo r̃omr̃omia na mapura lara korong, John enia pa Kr̃isto atu. ");
INSERT INTO tgp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pani John mo r̃aramira mara, “Enau na lo paptijo hin kamim na wai purongo, pani tamlohi matea mo aulu jea hiniau mo lo mai, enau na sopo tataholo vara a uli nar̃ihi na asi eve palona. Enia i pa paptijo hin kamim na Tanume Tapu peresi na hapu. ");
INSERT INTO tgp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mo lo tauri na nona foko tavera na limana vara i vasahi na nona jara ase na piri wit, ale matan vara i takonahi piri wit atu na nona pea, pani i pa suli na pahapaha piri wit na hapu sei tea i sopo er̃i vunia hin te rani.” ");
INSERT INTO tgp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ale hin na reti tinatinapua matuvana John mo retir̃oar̃oahai na tamlohi, ale mo retivujavujangi na Retir̃uhu isara hinira. ");
INSERT INTO tgp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ale hin pongi atu John mo retihoro Herod tamlohi aulu non Judea, mata nona vaivaileu peresi Herodias, naroun tasina, ale mata hina sasati tinatinapua tari sei Herod mo lo vaira, ");
INSERT INTO tgp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ale aulu hin la hina sati atu mo lo vaira, Herod mo tau John na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pani hin pongi atu John mo sopo lo toho na ima r̃ilangi, tamlohi tari la lavi na paptijo, ale John mo paptijo hin Iesu. Ale Iesu mo pa lo usiusi, tuka mo maroi, ");
INSERT INTO tgp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ale Tanume Tapu mo sinai atano sohena vomahe matea, ale mo tau hinia; ale leon matea mo tai na tuka mara, “Engko Natuku r̃uhur̃uhu jea, enau na avulahi tavera jea hiniho.” ");
INSERT INTO tgp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Taunin Iesu mar̃iviti i ngavulu tolu moiso mo pa tapulo na nona vavahinau. Iesu la verea vara enia natun Joseph, Joseph, enia natun Heli, ");
INSERT INTO tgp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli, enia natun Matthat, Matthat, enia natun Levi, Levi, enia natun Melchi, Melchi, enia natun Jannai, Jannai, enia natun Joseph, ");
INSERT INTO tgp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph, enia natun Mattathias, Mattathias, enia natun Amos, Amos, enia natun Nahum, Nahum, enia natun Esli, Esli, enia natun Naggai, ");
INSERT INTO tgp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai, enia natun Maath, Maath, enia natun Mattathias, Mattathias, enia natun Semein, Semein, enia natun Josech, Josech, enia natun Joda, ");
INSERT INTO tgp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda, enia natun Joanan, Joanan, enia natun Rhesa, Rhesa, enia natun Zerabbabel, Zerabbabel, enia natun Shealtiel, Shealtiel, enia natun Neri, ");
INSERT INTO tgp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, enia natun Melchi, Melchi, enia natun Addi, Addi, enia natun Cosam, Cosam, enia natun Elmadam, Elmadam, enia natun Er, ");
INSERT INTO tgp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, enia natun Joshua, Joshua, enia natun Eliezer, Eliezer, enia natun Jorim, Jorim, enia natun Matthat, Matthat, enia natun Levi, ");
INSERT INTO tgp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi, enia natun Simeon, Simeon, enia natun Judah, Judah, enia natun Joseph, Joseph, enia natun Jonam, Jonam, enia natun Eliakim, ");
INSERT INTO tgp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim, enia natun Melea, Melea, enia natun Menna, Menna, enia natun Mattatha, Mattatha, enia natun Nathan, Nathan, enia natun David, ");
INSERT INTO tgp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David, enia natun Jesse, Jesse, enia natun Obed, Obed, enia natun Boaz, Boaz, enia natun Sala, Sala, enia natun Nahshon, ");
INSERT INTO tgp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon, enia natun Amminadab, Amminadab, enia natun Admin, Admin, enia natun Arni, Arni, enia natun Hezron, Hezron, enia natun Perez, Perez, enia natun Judah, ");
INSERT INTO tgp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah, enia natun Jacob, Jacob, enia natun Isaac, Isaac, enia natun Abraham, Abraham, enia natun Terah, Terah, enia natun Nahor, ");
INSERT INTO tgp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor, enia natun Serug, Serug, enia natun Reu, Reu, enia natun Peleg, Peleg, enia natun Eber, Eber, enia natun Shelah, ");
INSERT INTO tgp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah, enia natun Cainan, Cainan, enia natun Arphaxad, Arphaxad, enia natun Shem, Shem, enia natun Noah, Noah, enia natun Lamech, ");
INSERT INTO tgp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech, enia natun Methuselah, Methuselah, enia natun Enoch, Enoch, enia natun Jared, Jared, enia natun Mahalaleel, Mahalaleel, enia natun Cainan, ");
INSERT INTO tgp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan, enia natun Enos, Enos, enia natun Seth, Seth, enia natun Adam, Adam, enia natun God. ");
INSERT INTO tgp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ale Tanume Tapu mo mar̃ivisi Iesu, ale Iesu mo malue na wai Jordan, ale Tanume Tapu mo tiroma hinia mo vano na jara tano koru. ");
INSERT INTO tgp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tiapolo mo vaihite Iesu atu mata rani mo ngavulu vati. Hin la rani atu, Iesu mo sopo hani te hinau hatea, ale rani atu la isoiso Iesu mo marohati jea. ");
INSERT INTO tgp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tiapolo mo verea isana mara, “Vara engko Natun God, o vere vatu sei i mai pereti!” ");
INSERT INTO tgp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu mo r̃aramia mara, “Retiulia mo verea vara, ‘Tamlohi i pa sopo mauri na pereti purongo!’” ");
INSERT INTO tgp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ale Tiapolo mo lavi Iesu mo sahe aulu na masapa, ale vahatea purongo, mo vujangia na jara tari na varama sei supe la lo tauri na suiha hinira, ");
INSERT INTO tgp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ale mo verea isana mara, “A pa sileho na nora suiha peresi na nora hasohaso, matan hinau tari sei la lo toho na limaku, ale a er̃i silera isan hare na opoia. ");
INSERT INTO tgp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Vara o lotuau purongo, hinau tari sei la pa nom!” ");
INSERT INTO tgp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ale Iesu mo r̃aramia mara, “Retiulia mo verea vara, ‘O pa lotu Moli nom God, ale o pa volitusi isana hasena!’” ");
INSERT INTO tgp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ale Tiapolo mo lavi Iesu mo taua aulu na pusa Temple, ale mo verea isana mara, “Vara engko Natun God, o kue! ");
INSERT INTO tgp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","matan Retiulia mo verea vara, ‘God i pa retileu isana nona angelo vara la pa lo kilau mamahuniho, ");
INSERT INTO tgp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ale la pa tauriho na limara matan vara o sopo vujahi na palom hin te vatu.’” ");
INSERT INTO tgp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu mo r̃aramia mara, “Retiulia mo verea vara, ‘O pa sopo vaihite Moli nom God!’” ");
INSERT INTO tgp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ale na rani Tiapolo mo isoiso na nona vaihite isan Iesu, mo malue mo vano, pani mo lo kilau matan te masapa r̃uhu tinapua. ");
INSERT INTO tgp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu mo mele vano Galilee na suihan Tanume Tapu, ale sorasorahina mo r̃alihi jara atu. ");
INSERT INTO tgp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mo vujangi na tamlohi na nora ima lotu, ale tamlohi tari la hasohasoa. ");
INSERT INTO tgp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ale Iesu mo pala Nazareth, jara atu sei mo ulua ea. Ale sohena mo lo vaia tarea mo vano na nora ima lotu na Sabbath, ale mo turu na naho tamlohi mata i evi na Retiulia, ");
INSERT INTO tgp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ale la silea hin viriviri pepa atu sei Isaiah mo lo ulia, mo vuhesia ale mo vano hin jara atu sei mo opoia vara i evia, ale mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tanumen Moli mo lo toho hiniau matan enia mo vir̃oniau vara a vereuli na Retir̃uhu isana tilavono. Mo r̃uleau vara a vere na materi isan la haratu la lo taurilatira, ale vara a vai na tamlohi matavuso la kilau, ale vara a teri la haratu la lo toho na ruhuruhu tamlohi sasati, ");
INSERT INTO tgp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ale vara a vereulia vara nake enia pongi r̃omr̃uhu non Moli.” ");
INSERT INTO tgp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ale Iesu mo mele viriviri pepa atu, mo silea isan tamlohi atu mo lo silea isana, ale mo sakele. Tamlohi tari na lolon ima lotu atu matara la lo toho hinia, ");
INSERT INTO tgp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ale mo tapulo verea isara mara, “Nahapani natu Retitapu nike mo pa masese na peromim.” ");
INSERT INTO tgp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ale tamlohi tari la hasohasoa, la mar̃urahi na retir̃uhu mo lo verera, ale la verea lara, “Avei, tamlohi nike enia natun Joseph teni!” ");
INSERT INTO tgp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ale Iesu mo verea isara mara, “Na levosahi mamahunia vara ha pa vereau hin titileu sei mo verea vara, ‘Doctor, o hase vai mamahuniho!’ Ha pa verea vara, ‘Sava hina mar̃urahi kama rongoa vara ko lo vaia Capernaum, o vaia nike na jaram sohena!’” ");
INSERT INTO tgp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ale mo verea isara mara, “Varar̃uhu na verea isamim, vara mo sopo te pr̃ovet hatea i er̃i lavi na r̃omr̃uhu nona tamlohi na vanuana. ");
INSERT INTO tgp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pani, na varar̃uhu hin haratu na verea vara, ‘Malepu matuvana Israel la lo toho na rani non Elijah, hin rani atu usa mo sopo jovi mata tauni mo tolu vitu mo limarave, ale marua tavera mo voroi Israel, ");
INSERT INTO tgp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ale God mo sopo r̃ule Elijah i vano isan te vonara, pani isana har̃ai malepu matea mo lo toho Zarephath na jara Sidon. ");
INSERT INTO tgp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ale tamlohi lepros matuvana hin Israel la lo toho na rani non Elisha, God mo sopo vai mamahuni te vonara hatea pani Naaman purongo mara Syria matea.” ");
INSERT INTO tgp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ale lara la rongo la hinau atu Iesu mo lo verera, tamlohi tari na lolon ima lotu la lolokoru patura. ");
INSERT INTO tgp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","La turu la titiua vara i malue hin taon atu, ale la lavia mo vano na tavalu taon matan vara la pa pulahia na pesapesan vutivuti atu sei la voro na nora taon hinia. ");
INSERT INTO tgp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pani Iesu mo hahau roto na livuhara mo vano. ");
INSERT INTO tgp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ale Iesu mo sahe Capernaum, taon tavera matea Galilee. Mo lo vujangira na Sabbath, ");
INSERT INTO tgp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ale la haratu la rongoa la mar̃urahi tavera na nona vujangi, matan nona reti mo suiha. ");
INSERT INTO tgp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na lolon ima lotu atu tamlohi matea, tanume lumiha sasati matea mo lo toho hinia, mo ulo aulu r̃ilangi mara, ");
INSERT INTO tgp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aaah! Ko mai isamam mata sava, Iesu mara Nazareth? Ko mai vara o komo kamam? Na levosahia vara engko hare — haratu mo tapu non God!” ");
INSERT INTO tgp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pani Iesu mo merusahia mara, “O sopo retireti! O malue isan tamlohi sei!” Ale tanume sasati atu mo sar̃ihi tamlohi atu sivo atano na livuhan vao atu, ale mo malue hinia, pani mo sopo komo te epena. ");
INSERT INTO tgp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tamlohi tari la mar̃urahi matana, ale la lo hase vereverea isara lara, “Eh! Sava reti nahai? Matan na suiha nona retileu purongo, mo titiu nar̃ihi na tanume lumiha sasati la malue!” ");
INSERT INTO tgp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ale sorasorahina mo vano r̃alihi na jara tari ea. ");
INSERT INTO tgp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ale hitahun haratu, Iesu mo turu mo malue na ima lotu, mo vano na iman Simon Peter mo unu hinia. Hin rani atu vepalihan Peter mo rojo na seserei r̃ilangi matea, ale la usi Iesu matana vara i tuenia. ");
INSERT INTO tgp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu mo turu na pahisa vatana, mo kilau sivo isana, ale mo r̃ule nar̃ihi seserei atu, ale seserei atu mo malue isana, ale vahatea purongo mo turu mo tapulo tatamahuni na hara hinau. ");
INSERT INTO tgp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Alo mo lo tapulo majo, ale la haratu te tahisara la rojo na rojoa tinatinapua la lavira la mai isan Iesu, ale mo tau na limana hinira hatehateahi mo isoiso, ale nora rojoa la tihai. ");
INSERT INTO tgp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ale tanume sasati sohena la malue isana tamlohi matuvana la ulo lara, “Engko Natun God!” Pani Iesu mo merusahira, ale mo sopo tinar̃ihira vara la vere te hinau, matan la levosahia vara enia natu pa Kr̃isto atu. ");
INSERT INTO tgp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ale na rani tinapua na r̃alavuho, Iesu mo malue mo vano na jara hasetoho matea. Ale tamlohi la alea la mai isana, la opoia vara i lo toho peresira tako, ");
INSERT INTO tgp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","pani Iesu mo verea isara mara, “A pa vano na taon tinatinapua vara a retivujavujangi hin mauri atu God mo aulu hinia isara sohena na vaia isamim, matan God mo r̃uleau matana.” ");
INSERT INTO tgp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ale mo malue mo vano r̃alihi na jara Judea mo lo retivujavujangi na nora ima lotu. ");
INSERT INTO tgp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na rani matea, Iesu mo lo turu na pahisa tasin Galilee, vao tamlohi matuvana la lo turu porotia mata tapurongo na reti non God, ");
INSERT INTO tgp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ale mo hite na boti mo rua la seretahira na oneone, mo hite na tamlohin la boti atu la lo turu na jarauta, la lo hoje na nora tara. ");
INSERT INTO tgp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu mo vele na vonan la boti atu matea sei enia botin Simon Peter, mo usia vara i sohai nar̃ihia makomona na jarauta. Ale Iesu mo sakele na boti mo vujangi pa vao tamlohi atu. ");
INSERT INTO tgp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mara mo isoiso na nona retireti isara, mo verea isan Simon mara, “Eh, o sohai nar̃ihia i sivo na jara puaha, ale ha tuhu na nomim tara mata tarai te maji.” ");
INSERT INTO tgp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Moiso, Simon mo r̃aramia mara, “Tamlohi tavera, kama kalvono vutepongi jarohi, ale kama sopo tikeli tea, pani matan ko verea, a pa tuhu na tara.” ");
INSERT INTO tgp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ale lara la vaia sohena, la r̃alihi na takonahi maji, ale nora tara la tapulo mar̃ari. ");
INSERT INTO tgp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","La alovi na tapalara hin boti tinapua atu vara la mai la tuenira, ale la mai la sohoni la boti atu mo rua, mariviti vara la pute. ");
INSERT INTO tgp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pani Simon Peter mara mo hite hinau atu mo jovi sivo mo papaohi na paun Iesu mara, “O malue isaku Moli! Matan enau na tamlohi hehe matea!” ");
INSERT INTO tgp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Matan Simon Peter enira tolu la haratu la lo toho peresia la mar̃urahi tavera na maji la tikelira, ");
INSERT INTO tgp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ale James enia John sohena, enira natun Zebedee sei la tapalan Simon Peter na bisnis mata aleale maji. Ale Iesu mo verea isan Simon mara, “O sopo matahu! Mo tapulo nake, engko o pa tamlohi tara tamlohi!” ");
INSERT INTO tgp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ale lara la tahe na botira sahe na jarauta, la tinar̃ihi na hinau tari nora mata botira, ale la usuri Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ale na rani matea Iesu mo lo toho na taon tavera matea atu, tamlohi matea mo mai isana lepros mo hati vevuhi na epena, ale mara mo hite Iesu, mo jovi na nahona, mo tangi isan Iesu mara, “Moli, vara o majinga, o er̃i vaiau a vokevoke.” ");
INSERT INTO tgp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Moiso Iesu mo r̃irahi na limana mo tikelia mara, “Ale a vaia! O vokevoke!” Vahatea purongo lepros atu mo tinar̃ihia. ");
INSERT INTO tgp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu mo verea isana vara i sopo mele verea isan tea, pani mo verea mara, “O vano o hase vujangiho isan te pr̃is hatea, ale o sile te silesilea hatea mata nom vokevoke usuri na sava Moses mo retileu hinia, matan vara i er̃i verea vara engko ko mele r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pani nake natu sorasorahina mo mele tavera jea mo vano asau, ale vao tavera la lo mai vara la tapurongo na nona retireti, ale mo vai na nora rojoa la tihai. ");
INSERT INTO tgp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pani tarea Iesu mo lo vano hasena na jara hasetoho mata usiusi. ");
INSERT INTO tgp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ale na rani matea hin la rani atu, Iesu mo lo vujangi, Pharisee peresi na tamlohi vujangi mata leu, la lo sakele mariviti atu, enira la tai na vanua tari matan Galilee, Judea peresi Jerusalem. Ale suiha tavera non God mata titiu nar̃ihi na rojoa mo lo toho hinia. ");
INSERT INTO tgp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tamlohi la hutura matan tamlohi hai la lo lavi na tamlohi rojoa matea na epa matea, epena tari la mate, ale la lo aleale malele vara la lavia i unu sivo na nahon Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pani la sopo hite te malele vara la pa unu hinia, la vele sahe aulu na pusa ima la r̃ole na masapa matea, ale la tuhua na epana mo sivo atano na livuha vao tataholo na nahon Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ale Iesu mara mo hite na nora rasua, mo verea isan tamlohi rojoa atu mara, “Tapala, na r̃omiho mata nom hehe.” ");
INSERT INTO tgp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ale tamlohi vujangi mata leu peresi na Pharisee la tapulo usiusira lara, “Sava tamlohi nahai mo lo vaia sohena enia God? God hasena i er̃i r̃omi na hehe!” ");
INSERT INTO tgp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu mo levosahi na r̃omira ale mo r̃aramira mara, “Mata sava r̃omimim mo lo sati na sava na verea? ");
INSERT INTO tgp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sava natu, mo mele malum jea? Vara a verea isan tamlohi hariju nike vara, ‘Na r̃omi na nom hehe!’ teni ‘O turu! O hahau!’ ");
INSERT INTO tgp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pani matan vara ha er̃i levosahia vara Natun Tamlohi mo lavi na suiha mata r̃omi na hehe na varama, ha tapurongo na sava a pa verea!” Moiso Iesu mo verea isan tamlohi hariju atu mara, “Na verea isam, o turu, o lavi na epam, ale o mule!” ");
INSERT INTO tgp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vahatea purongo, mo turu na nahora, mo lavi na epana mo mule, ale mo lo hasohaso God. ");
INSERT INTO tgp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mar̃urahi tavera mo taurilatira, ale enira mo isoiso la hasohaso God, matahu mo sohonira lara, “Na verea! Mele hina mar̃urahi tinatinapua nahai r̃a lo hitera nakerihi!” ");
INSERT INTO tgp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hitahuni haratu, Iesu mo malue mo vano, ale mo hite na tamlohi mata lavi na takis matea, hijana Levi, mo lo sakele na jarana, ale mo verea isana mara, “O usuriau!” ");
INSERT INTO tgp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ale mo turu, mo tinar̃ihi vevuhi na nona voko tari mo usuri Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Moiso, Levi mo vai na hanhani tavera matea non Iesu na imana, ale takonahi tamlohi mata lavi na takis peresi na tamlohi tinapua hai la lo hanhani peresira na tep atu. ");
INSERT INTO tgp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ale Pharisee peresi na nora tamlohi vujangi mata leu hai la lo ngutungutu isana nona tamlohi usuri lara, “Mata sava ka lo hanhani ale ka lo inu peresi na tamlohi mata lavi na takis peresi na tamlohi hehe?” ");
INSERT INTO tgp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ale Iesu mo r̃aramira mara, “Haratu la sopo rojo la sopo opoi na doctor, pani haratu purongo sei la rojo. ");
INSERT INTO tgp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na sopo sinai matan vara a tovi la haratu la tataholo la posi, pani mata tamlohi hehe.” ");
INSERT INTO tgp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pharisee la verea isana lara, “Tamlohi usuri non John tamlohi paptijo la lo tapuhoro na hanhani hin te rani mata usiusi, ale tamlohi usuri nona Pharisee la lo vaia sohena, pani nom la lo hanhani la lo inu!” ");
INSERT INTO tgp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu mo r̃aramira mara, “Ha er̃i vai na tamlohi ka tovira mata mai na hanhani lahi la tapuhoro na hanhani vara tamlohi lahi mo lo toho peresira? ");
INSERT INTO tgp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pani rani mo lo mai vara la pa lavi nar̃ihi na tamlohi lahi isara, ale la pa tapuhoro na hanhani hin la rani atu natu.” ");
INSERT INTO tgp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu mo mele verera na titileu matea mara, “Mo sopo tea i r̃ari te nona ruru paro vara i lavi tavalu ruru atu i silivi horo na mar̃ari ruru tuai matea hinia. Vara i vaia sohena, i pa r̃ari ruru paro atu, ale tavalu ruru paro atu i pa sopo er̃i sor̃o i r̃uhu hin ruru tuai atu. ");
INSERT INTO tgp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ale mo sopo tea i tisi na waen paro i sivo na huri waen tuai. Vara i vaia sohena, waen paro atu i pa vali i sohi i kosahi huri waen tuai atu sei mo masa moiso, ale waen atu i pa roro nar̃ihi, ale huri atu i pa sopo mele r̃uhu matan te hinau. ");
INSERT INTO tgp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pani ha pa tisi na waen paro na lolo huri waen paro purongo matan mo malum. ");
INSERT INTO tgp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ale mo sopo tea vara i lo inu na waen tuai i opoi na waen paro, matan i pa verea vara, ‘Waen tuai mo meji.’” ");
INSERT INTO tgp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na Sabbath matea, Iesu mo pa lo hahau roto na isa wit matea, ale nona tamlohi usuri la vesi roto na perera hai, ale la savasavahira na limara, moiso la hanira. ");
INSERT INTO tgp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pani tatua Pharisee lara, “Eh! Mata sava ka lo vai na hinau matea mo sopo tataholo vara ha vaia na Sabbath?” ");
INSERT INTO tgp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu mo r̃aramira mara, “Ka sopo lo evi na sava David mo vaia hin rani atu mo marohati, enia peresi la haratu la lo toho peresia? ");
INSERT INTO tgp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ka evia ka hitea sohena sava mo unu na Tabernacle non God mo lavi na pereti tapu, pereti atu pr̃is hasera la er̃i hania, ale David mo hania mo silea isana tatuana la hania sohena.” ");
INSERT INTO tgp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ale Iesu mo vere isara mara, “Natun Tamlohi, enia Moli mata Sabbath.” ");
INSERT INTO tgp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na Sabbath tinapua matea, Iesu mo unu na lolo ima lotu, ale mo lo vujangi. Tamlohi matea mo lo toho atu matua limana mo rihirihi. ");
INSERT INTO tgp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ale tamlohi vujangi mata leu peresi na Pharisee la lo kilau Iesu vara i pa titiu nar̃ihi na rojo na Sabbath teni mo vono, matan vara la er̃i vilei te hinau mata pisuhia hinia. ");
INSERT INTO tgp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pani hina purongo vara Iesu mo levosahi na r̃omira, mo verea isan tamlohi lima rihirihi atu mara, “O mai o turu akerihi!” Ale tamlohi atu mo turu mo vano isana. ");
INSERT INTO tgp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ale Iesu mo verea isara mara, “Na lo usi kamim vara mo tataholo vara o vai na hina r̃uhu na Sabbath, teni vara o sile na rongohaji isan tea na Sabbath, teni vara o juri na mauri, teni vara o komoa?” ");
INSERT INTO tgp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mo kilau r̃alihira mo isoiso, moiso mo verea isan tamlohi atu mara, “O r̃irahi na limam!” Ale pa tamlohi atu mo vaia sohena, ale limana mo mele r̃uhu vevuhi. ");
INSERT INTO tgp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pani la Pharisee atu la lolokoru patura, la lo usiusira hinia lara, sava natu la pa er̃i vaia isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hin la rani atu Iesu mo malue isara, mo sahe aulu na vutivuti mata usiusi, mo usiusi rani isan God. ");
INSERT INTO tgp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ale na r̃alavuho mo tovi na nona tamlohi usuri, ale mo vir̃oni na tupu sangavulu r̃omana mo rua hinira, enira mo tovira vahar̃ule; ");
INSERT INTO tgp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon sei Iesu mo tau na hijana vara Peter, tasina Andrew, ale James enia John, Philip, Bartholomew, ");
INSERT INTO tgp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Thomas, James natun Alphaeus, Simon sei, enia tamlohi matea mata valum mata jarana, ");
INSERT INTO tgp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ale Judas natun James, ale Judas Iscariot sei mo lo turuposi hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ale Iesu mo sevuti mo sinai atano peresira, ale la turu na mavalolo matea. Ale vao nona tamlohi usuri tolu na vao tamlohi tinapua tavera jea matea la takonahi moiso, la tai na jara tari Judea, Jerusalem ale na pahisa tasi Tyre peresi Sidon, ");
INSERT INTO tgp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","sei la mai vara la rongo na nona retireti, ale matan vara i titiu nar̃ihi na nora rojoa. Ale la haratu sei tanume lumiha sasati mo lo vaira, Iesu mo vaira la mele r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ale enira mo isoiso la lo vaihitea vara la tikeli Iesu matan suiha tavera mo lo malue isana mo lo titiu nar̃ihi na nora rojoa tari. ");
INSERT INTO tgp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu mo tar̃a sahe isana nona tamlohi usuri mo verea mara, “Avulahi isamim sei ka tilavono, matan mauri atu God mo aulu hinia enia nomim. ");
INSERT INTO tgp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Avulahi isamim sei ka lo marohati nake, matan ha pa masu. Avulahi isamim sei ka lo tangi nake, matan ha pa mana. ");
INSERT INTO tgp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Avulahi isamim na rani sei tamlohi la r̃ohu hin kamim, teni la lo horo kamim, teni la lo veresatihi kamim, teni la lo vereleji kamim, matan ka tamlohi non Natun Tamlohi. ");
INSERT INTO tgp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hin la pongi atu ha pa avulahi tavera, ale ha kuekue na avulahi, matan ka levosahia vara nomim otori na tuka mo tavera jea; matan tuai tamara la vaia sohena moiso isana pr̃ovet. ");
INSERT INTO tgp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pani rani sasati isamim sei ka tavtav, matan ka lavi na volimim moiso. ");
INSERT INTO tgp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rani sasati isamim sei ka lo mana nake, matan ha pa tangtangi ale ha tangi. ");
INSERT INTO tgp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Rani sasati isamim na rani tamlohi la vere na retireti r̃uhu matamim, matan tuai tamara la vaia sohena moiso isana pr̃ovet haluhalu. ");
INSERT INTO tgp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pani na verea isamim nakerihi ka lo tapurongo vara ha opoi na nomim meresahi, ha vai na hina r̃uhu isan haratu mo r̃ohu hin kamim. ");
INSERT INTO tgp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ha ler̃uhu hin la haratu la lesati hin kamim, ha usiusi matan la haratu la lo vailehilehi kamim. ");
INSERT INTO tgp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Isan haratu mo vojahi na esem, o tinar̃ihia i mele vojahi na tavalu esem. Ale haratu mo reve nar̃ihi na nom ruru hamariri, o sopo horoa vara mo opoia vara i reve nar̃ihi na nom ruru. ");
INSERT INTO tgp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","O silea isana tamlohi tari sei la usia r̃ilangi isam, ale isan haratu mo reve nar̃ihi na nom hinau, o sopo ngurunguru hinia vara i mele sileho hinia. ");
INSERT INTO tgp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ale sava ka opoia vara tamlohi la vaia isamim, ha vaia sohena isara. ");
INSERT INTO tgp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Vara ha opoi la haratu la lo opoi kamim purongo, ka r̃om vara God i pa avulahi hin kamim? Matan tamlohi hehe sohena, la lo opoi la haratu la opoira. ");
INSERT INTO tgp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ale vara ha lo vai na hina r̃uhu isan la haratu la lo vai na hina r̃uhu isamim purongo, ka r̃om vara God i pa avulahi hin kamim? Matan tamlohi hehe sohena la lo vaia sohena. ");
INSERT INTO tgp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ale vara ha lo sile na mania isan la haratu sei ko levosahia vara la pa mele spaia, ka r̃om vara God i pa avulahi hin kamim? Matan tamlohi hehe sohena, la lo sile na mania isana tamlohi hehe matan vara la pa mele lavi na spaina tataholo. ");
INSERT INTO tgp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pani ha opoi na nomim meresahi, ale ha vai na hina r̃uhu, ha sile na mania vara tea mo usia, ha sopo r̃omr̃omia vara ha pa mele lavi na spaina. Matan nomim otori i pa tavera jea, ale kamim ha pa natun haratu mo aulu jea, matan enia mo r̃uhu isan la haratu mo sopo te vere meje isara, peresi la haratu la sasati. ");
INSERT INTO tgp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ha r̃omopoia sohena Tamamim mo lo r̃omopoia. ");
INSERT INTO tgp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ha isoiso na nomim ari na tamlohi tinapua, ale God i pa sopo ari kamim, ale ha isoiso na nomim sile na talai isana tamlohi tinapua, ale God i pa sopo sile na talai isamim, ha r̃omi na tinapua, ale God i pa r̃omi kamim, ");
INSERT INTO tgp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ha silesile, ale God i pa sile purongoia isamim, i pa silea i tavera jea i jeu na r̃omimim, i pa sar̃ihia, i hutehutehia, ale i lo masurere. Vara ka silea sohena sava, i pa mele silea sohena isamim.” ");
INSERT INTO tgp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu mo mele verera na titileu matea mara, “Matavuso matea i er̃i tiroma na matavuso tinapua? R̃a levosahia vara la pa jovi hin te koko. ");
INSERT INTO tgp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamlohi usuri matea mo sopo aulu na nona tamlohi vujangi, pani vara i levosahi vevuhi na sava mo lo vujangia, i pa sohen nona tamlohi vujangi atu. ");
INSERT INTO tgp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mata sava ko er̃i hitevosahi na utauta tapea rihirihi na matan voraim matea, pani ko sopo er̃i hitevosahi na laho pahai na matam? ");
INSERT INTO tgp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mo sohena sava natu ko er̃i verea isan voraim vara, ‘A er̃i nar̃ihi utauta tapea rihirihi sei na matam!’ pani ko sopo hitevosahi na laho pahai na matam hasem? Ko tapnetano! O nar̃ihi na laho pahai na matam hasem tiroma, ale o pa er̃i kilau i memera matan vara o er̃i lanar̃ihi na utauta tapea rihirihi na matan voraim. ");
INSERT INTO tgp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mo sopo te pulo vipahai r̃uhu hatea i er̃i sile na vua sasati, teni te pulo vipahai sasati i er̃i sile na vua r̃uhu, ");
INSERT INTO tgp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","matan, pulo vipahai hatehateahi o er̃i hitevosahira na vuara. Matan la sopo vu na fig na pahai ngar̃ngar̃iha, teni la sopo vu na grape na asikauli. ");
INSERT INTO tgp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tamlohi r̃uhu, hina r̃uhur̃uhu na mapuna i pa sile na hina r̃uhu, tamlohi sasati, hina sasati na mapuna i pa sile na hina sasati. Matan sava mo tavera na mapu tamlohi, haratu natu i pa malue na jingona. ");
INSERT INTO tgp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Mata sava ka lo toviau vara, ‘Moli! Moli!’ pani ka sopo vai na sava na verea isamim? ");
INSERT INTO tgp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sava tamlohi mo mai isaku, mo rongo na noku reti ale mo vaira, a pa vujangia isamim vara enia mo sohena sava: ");
INSERT INTO tgp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Enia mo sohena tamlohi matea mo lo voro na ima matea, mo heli na moru mo sivo atano na vatu matan vara i tau na pulo ima hinia. Ale na rani wai tavei mara mo vele, mo sari ima atu, pani mo sopo er̃i hisuhia matan mo voro mamahunia. ");
INSERT INTO tgp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pani haratu mo rongoa pani mo sopo vaia, mo sohena tamlohi matea mo voro na ima na lepa purongo, ale mo sopo te pulona r̃uhu. Ale wai tavei mara mo vele mo saria, vahatea purongo ima atu mo jovi, ale nona jovi atu mo tavera jea.” ");
INSERT INTO tgp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hitahun la nona titileu atu mo verea isana tamlohi, mo mele unu Capernaum. ");
INSERT INTO tgp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ale slev matea nona captain mata tamlohi vuro nona mara Rome matea mo rojo, mariviti vara i mate. Tamlohi tavera atu mo opoi volitusi atu mo tavera jea. ");
INSERT INTO tgp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ale pa captain atu mara mo rongo te hinau matan Iesu, mo r̃ule na vajiaha Jew hai la vano isana vara la usia vara i er̃i mai vara i titiu nar̃ihi na rojoa non nona volitusi atu. ");
INSERT INTO tgp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ale la mai isan Iesu, la lo usia r̃ilangi isana lara, “Tamlohi tavera sei enia tamlohi r̃uhu matea, mo tataholo vara o tuenia, ");
INSERT INTO tgp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","matan enia mo opoi na nor̃a tamlohi, ale enia natu mo voro na nomam ima lotu.” ");
INSERT INTO tgp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ale Iesu mo usurira. Mo pa lo mai mariviti na ima, ale pa captain atu mo r̃ule na tapalana hai la mai isana, la lo lavi na nona reti ale lara, “Moli, o sopo kalvono purongo, matan enau mo sopo tataholo vara o er̃i unu na imaku. ");
INSERT INTO tgp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Matan haratu, na sopo hitea vara i tataholo vara enau haseku a mai a usia isam. Pani vara o sile te reti hatea purongo, na levosahia vara noku volitusi i pa mele r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Matan enau sohena, enau tamlohi matea na lo toho na ruhuruhu suiha tamlohi tinapua matea, ale tamlohi vuro hai la lo toho na ruhuruhu suihaku: vara a verea isan matea vara, ‘O vano!’ i pa vano, ale isana tinapua vara, ‘O mai!’ i pa mai, ale vara a verea isan noku volitusi vara, ‘O vai haratu!’ i pa vaia.” ");
INSERT INTO tgp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu mara mo rongo la reti atu, mo mar̃urahi tavera hin tamlohi atu, ale mo posi vano isan vao atu sei la lo usuria, mo verea isara mara, “Varar̃uhu, na verea vara na sopo lo tapai te tamlohi nike Israel i lavi na rasua sohen tamlohi nike!” ");
INSERT INTO tgp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ale na rani la haratu sei tamlohi tavera atu mo lo r̃ulera isan Iesu la mele hilu vano na imana, la hitea vara pa volitusi atu mo pete r̃uhu moiso. ");
INSERT INTO tgp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mo sopo tuai usuri haratu, Iesu mo vano na taon matea hijana Nain, ale nona tamlohi usuri peresi na vao tavera matea la lo usuria. ");
INSERT INTO tgp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mara mo lo mai mariviti na mataruan taon atu, ale la hutura na tamlohi la lo ali na tamlohi mate matea, mo lo malue na taon, enia vorahese non tinana, ale har̃ai atu enia malepu matea. Vao tamlohi matan taon atu la lo usuria. ");
INSERT INTO tgp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ale mara mo hite har̃ai atu, Iesu mo r̃omopoia, ale mo verea isana mara, “O sopo tangi!” ");
INSERT INTO tgp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ale mo vano na vatan tamlohi mate atu, mara mo tau na limana hinia, la haratu la lo alia la turu vahatea. Ale mo verea mara, “Uluvou, o turu.” ");
INSERT INTO tgp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Moiso, tamlohi mate atu mo sakele, ale mo tapulo retireti, moiso Iesu mo silea isan tinana. ");
INSERT INTO tgp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Matahu mo sohoni na tamlohi tari, ale la hasohaso God lara, “Pr̃ovet aulu matea mo lo turu na livuhar̃a!” ale lara, “God mo rohi na nona tamlohi!” ");
INSERT INTO tgp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ale sorasorahina sei, mo vano asau mo r̃alihi na jara Judea peresi na jara tari r̃alihia. ");
INSERT INTO tgp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tamlohi usuri non John tamlohi paptijo, la sorahi la hinau tari sei isana. Moiso John ");
INSERT INTO tgp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","mo tovi na vonara mo rua la mai isana matan vara i r̃ulera la vano isan Moli vara la usia isana vara, “Engko natu haratu sei i pa mai, teni kama pa lo mele kilau matan te tinapua?” ");
INSERT INTO tgp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ale lara la kau isan Iesu lara, “John tamlohi paptijo mo r̃ule kamam kama mai isam mara, ‘Engko natu haratu sei i pa mai, teni kama pa lo mele kilau matan te tinapua?’” ");
INSERT INTO tgp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hin aoa atu, Iesu mo titiu nar̃ihi na rojoa na tamlohi matuvana, ale mo titiu nar̃ihi na tanume sasati matuvana, ale isan la haratu la matavuso mo vaira vara la er̃i kilau. ");
INSERT INTO tgp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ale Iesu mo r̃aramira mara, “Ha vano ha vere John na sava ka hitea, ale ka rongoa: matavuso la mele kilau, tamlohi papao la hahau, tamlohi lepros la vokevoke, peropero la rongo, haratu la mate la mauri, ale la haratu la tilavono la rongo na Retir̃uhu. ");
INSERT INTO tgp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ale avulahi isan la haratu la pa sopo r̃ohu hiniau hin te rani.” ");
INSERT INTO tgp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na rani vahar̃ule non John la mele hilu vano, Iesu mo tapulo retireti isan vao atu matan John mara, “Ka vano na jara tano koru vara ha hite na sava ea? Apo matea langi mo lo serea ea? ");
INSERT INTO tgp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pani sava natu ka vano vara ha er̃i hitea ea? Tamlohi matea mo ru na ruru r̃uhu matea ea? Ka levosahia vara la haratu la lo ru na ruru r̃uhu jea, la lo toho na jara Supe tavera purongo. ");
INSERT INTO tgp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sava natu ka opoia vara ha hitea ea? Pr̃ovet matea? Varar̃uhu, pani na verea isamim vara enia mo jeu na pr̃ovet. ");
INSERT INTO tgp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sava la ulia tuai matana mo verea vara, ‘Ha kilau nike! Na lo r̃ule na noku vahar̃ule na nahom, vara i vai na malelem i roi.’ ");
INSERT INTO tgp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Varar̃uhu na vere isamim vara la haratu la vora isana har̃ai, mo sopo tea i er̃i lavi na oloolo i jeu John, pani haratu mo hitahu hin mauri atu God mo aulu hinia, enia mo aulu jea mo jeu John.” ");
INSERT INTO tgp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na rani tamlohi tari peresi na tamlohi mata lavi na takis la rongo reti nike, la majinga vara sava God mo vaia mo tataholo, matan enira la lavi na paptijo non John moiso, ");
INSERT INTO tgp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","pani Pharisee peresi na tamlohi vujangi mata leu, la r̃ohu na masalon God matara, matan la sopo lavi na nona paptijo. ");
INSERT INTO tgp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu mo mele verea mara, “Na sopo levosahia vara a pa verea vara tamlohi matan nake la sohena sava? ");
INSERT INTO tgp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","La sohena natuvarihi la lo sakele na jara maket la lo uloulo isara hasera lara, ‘Kama roro na vete mata lahi, pani ka r̃ohu vara ha velu; ale kama lalavete na vete mata r̃omsati matea, pani ka sopo tangi.’ ");
INSERT INTO tgp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Matan John tamlohi paptijo mo mai, mo tapuhoro na pereti peresi na waen, ale kara, ‘Tanume sasati mo lo toho hinia!’ ");
INSERT INTO tgp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ale Natun Tamlohi mo mai, mo hanhani ale mo inu, ale kara, ‘Ha to kilaua! Hanhani jea matea, tamlohi drong matea, enia mo tapala peresi na tamlohi la lo lavi na takis peresi na tamlohi hehe!’ ");
INSERT INTO tgp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pani o pa er̃i hitevosahia vara malele lelevosahi non God mo tataholo mata vuana r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ale Pharisee matea mo usi Iesu vara i hanhani peresia, ale mo vano mo unu na iman Pharisee atu mo sakele na tep. ");
INSERT INTO tgp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ale atu, har̃ai malele matea hin taon atu mo levosahia vara Iesu mo lo hanhani na iman Pharisee atu, ale mo lavi na potele matea la vaia na alabaster, hasori r̃uhu mo lo toho hinia, ");
INSERT INTO tgp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","mo turu na har̃ina ale mo papaohi mo lo tangi na palona, ale mo tapulo kamoti na wai matana sei la jovi na palona na vuluna, ale mo lo pungosi na palona, mo rengi na hasori hinira. ");
INSERT INTO tgp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pa Pharisee atu sei mo lo usia vara i vano na imana mara mo hite hinau atu, mo verea isana hasena mara, “Vara tamlohi nike enia pr̃ovet matea, i pa levosahia vara sava har̃ai nahai mo lo tikelia, matan enia har̃ai hehe matea.” ");
INSERT INTO tgp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ale Iesu mo r̃arami tamlohi atu mara, “Simon, na opoia vara a vereho na hinau matea.” Ale mo r̃aramia mara, “Tija, o verea.” ");
INSERT INTO tgp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu mara, “Tamlohi matea, tamlohi la lo usi na mania isana moiso la pa mele spaia, tupra rua la ave na mania isana. Matea mo ave na denarii mo ngavulu sangavulu lima, matea mo ave na ngavulu lima. ");
INSERT INTO tgp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na rani la sopo er̃i mele spaia, tamlohi atu mo r̃omira mo r̃omaliho hinia. Ale, sahara hinira i pa opoi tamlohi atu i tavera jea?” ");
INSERT INTO tgp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon mo r̃aramia mara, “Korong haratu sei nona ave isana mo tavera jea.” Ale Iesu mo verea isana mara, “Nom kilakilau mo tataholo.” ");
INSERT INTO tgp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Moiso mo posi vano isan har̃ai atu, ale mo verea isan Simon mara, “Ko hite har̃ai nike? Na unu na imam, ko sopo sileau hin te wai vara a hoje na paloku hinia, pani enia mo hoje na paloku na wai matana, ale mo kamotira na vuluna. ");
INSERT INTO tgp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ko sopo pungosiau, pani mo tapulo hin haratu mo unu, mo sopo lo mapu mata pungosi na paloku. ");
INSERT INTO tgp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ko sopo rengi na wel na patuku, pani enia mo rengi na hasori r̃uhu jea na paloku. ");
INSERT INTO tgp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Matan harihi, na verea isam, varar̃uhu nona hehe mo matuvana, pani na r̃omira moiso matan nona opoia mo tavera jea. Pani haratu nona hehe mo sopo mar̃ivi jea, nona opoia mo sopo tavera.” ");
INSERT INTO tgp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ale mo verea isan har̃ai atu mara, “Na r̃omiho mata nom hehe.” ");
INSERT INTO tgp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ale la haratu la lo sakele peresia na tep, la tapulo vereverea isara hasera lara, “Sava tamlohi nahai, matan mo hitea vara i er̃i r̃omi na hehe?” ");
INSERT INTO tgp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mo verea isan har̃ai atu mara, “Nom rasua mo juriho; o vano o toho na tamata.” ");
INSERT INTO tgp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hitahun haratu Iesu mo lo vano toho na taon tavera peresi na vanua. Mo lo retivujavujangi ale mo lo sile na Retir̃uhu matan mauri atu God mo aulu hinia. Ale la nona tamlohi atu mo sangavulu r̃omana mo rua la lo toho peresia, ");
INSERT INTO tgp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ale peresi na har̃ai hai sei Iesu mo lo titiu nar̃ihi na tanume sasati isara peresi na nora rojoa: Mary la tovia Magdalene, enia natu, tanume sasati mo limaravrua la malue isana, ");
INSERT INTO tgp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","peresi Joanna, naroun Chuza, patu tamlohi mata kilau na iman supe Herod, peresi Susanna, enira peresi na vao matuvana tinapua la lo tueni Iesu peresi na nona tamlohi na nora tavtav purongo. ");
INSERT INTO tgp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ale na rani vao tavera la lo tapulo takonahi, ale tamlohi mata taon tari la lo mai isana, moiso Iesu mo vere na titileu matea mara, ");
INSERT INTO tgp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tamlohi hapor̃ahi piri matea mo vano vara i hapor̃ahi na piri. Mo lo hapor̃ahi na piri mo lo vano, tatuara la jovi na malele, ale tamlohi la varasi kosakosahira, ale maji avuavu la hanira. ");
INSERT INTO tgp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tatua piri la jovi na vatuvatu, ale na rani la ulua la mele mahoa matan mo sopo te heu i tikelira. ");
INSERT INTO tgp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ale tatua piri la jovi na livuha vipahai ngar̃ngar̃iha, ale vipahai ngar̃ngar̃iha la punira. ");
INSERT INTO tgp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ale tatua piri la jovi na lepa r̃uhu, ale la ulua la vua la namaha mo vaha ngavu sangavulu hin la haratu mo lo hapor̃ahira tiroma. Haratu mo er̃i rongovosahia, o tapurongo!” ");
INSERT INTO tgp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ale na rani nona tamlohi usuri lara la usia na r̃aramin titileu atu, ");
INSERT INTO tgp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","mo verea mara, “Isamim God mo tinar̃ihia vara ha pa levosahi na hina luhu matan mauri atu God mo aulu hinia, pani isana tamlohi tinapua enia mo lo toho na titileu matan vara Retitapu i pa masese: ‘La hite na sava na lo vaia pani la pa sopo hitevosahia, la pa rongo na sava na lo verea, pani la pa sopo rongovosahia.’ ");
INSERT INTO tgp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ale r̃aramin titileu atu enia nahai: Piri atu enia reti non God. ");
INSERT INTO tgp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","La haratu na malele enira la haratu la rongoa moiso, ale Tiapolo mo mai, mo lanar̃ihi reti atu na mapura matan vara la pa sopo er̃i rasua, ale vara la er̃i juri hinia. ");
INSERT INTO tgp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","La haratu na vatuvatu enira la haratu la rongo reti atu, la lavia na avulahi. Pani mo sopo te warira, la rasua mata makomo rani purongo, ale na rani vaihite, la jovi. ");
INSERT INTO tgp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","La haratu la jovi na livuha vipahai ngar̃ngar̃iha enira la haratu la rongo reti atu pani lara la vano, r̃omkaka peresi na r̃om tavtav peresi na masalo tamlohi mo punira, ale vuara la sopo jea. ");
INSERT INTO tgp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pani la haratu la jovi na lepa r̃uhu, enira la haratu la rongo reti atu, ale la tauria mo r̃ilangi na mapura r̃uhu na posposi varar̃uhu, ale la vua peresi na r̃omperavu. ");
INSERT INTO tgp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mo sopo te tamlohi vara i hasahi na nona lamu matea ale i povia hin te baket teni i taua na ruhuruhu vata matea, mo vono. Pani i pa kehoia aulu na jarana matan vara tea la unu na imana la pa hite na merana. ");
INSERT INTO tgp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Matan i pa sopo te hinau hatea i er̃i luhu vara i pa sopo pala, teni te hina luhu vara i pa sopo pala na jara tavera. ");
INSERT INTO tgp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ha lo levosahi na sava ka lo rongoa, matan isan haratu mo lavia, i pa mele lavia i tavera jea, ale isan haratu mo sopo te nona, hina purongo vara sava mo r̃omr̃omia vara mo lavi moiso, la pa lanar̃ihia isana.” ");
INSERT INTO tgp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ale tinana peresi na tasina la mai isana, pani la sopo er̃i mai mariviti isana matan vao tavera atu. ");
INSERT INTO tgp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hai la verea isana lara, “Tinam tolu na tasim la lo turu na jingoima, la opoia vara la hiteho.” ");
INSERT INTO tgp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pani Iesu mo r̃aramira mara, “Tinaku peresi na tasiku enira la haratu sei la rongo na reti non God ale la vaia.” ");
INSERT INTO tgp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na rani matea mo vele na boti matea tolu na nona tamlohi usuri, ale mo verea isara mara, “R̃a vano tavalu vano na tavalu tasin Galilee.” Ale la malue, ");
INSERT INTO tgp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ale la pa lo vano, ale Iesu mo juruvi r̃omaliho. Ale langi tavera matea mo jovi hin tasi atu, botira mo lo utua, mariviti la pute. ");
INSERT INTO tgp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ale nona tamlohi la vano la r̃ohaia lara, “Moli, Moli, r̃a lo tapulo tihai!” Ale mo turu mo reti savurahi langi atu peresi la leputi tavera atu ale la isoiso mo tamata. ");
INSERT INTO tgp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mo verea isara mara, “Nomim rasua mo lo toho epu?” Ale la matahu la mar̃urahi tavera hinia, la lo vereverea isara lara, “Sava tamlohi nahai? Enia mo reti purongo isana langi peresi na tasi, ale la oloolo hinia!” ");
INSERT INTO tgp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hitahun haratu la hapahapan la vano na jara mara Gerasenes, jara atu enia mo lo toho na tavalun Galilee. ");
INSERT INTO tgp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu mara mo sevuti na jarauta, tamlohi matea tanume sasati la lo toho hinia mo pala isana. Tuai moiso tamlohi atu mo lo malamala purongo, ale mo sopo toho na lolon te ima pani tarea mo lo toho na jara taptap. ");
INSERT INTO tgp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ale pa tamlohi atu mara mo hite Iesu, mo ulo aulu, ale mo mai mo jovi na nahon Iesu mo verea na leo tavera matea mara, “Engko te nom sava isaku, Iesu Natun God Aulu Jea? Na tangi isam, aah! O sopo vailejilejiau!” ");
INSERT INTO tgp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Matan mo retileu isan tanume lumiha sasati atu vara i malue hin tamlohi atu. Matan rani mo visa moiso tanume sasati atu mo lo sohoni tamlohi atu. Tamlohi la taurilatia ale la tau na jen na limana peresi na palona, pani mo lo roto la jen atu, ale tanume sasati atu mo tiroma hinia mo lo vano na jara hasetoho. ");
INSERT INTO tgp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu mo usia isana mara, “Hijam hare?” Ale mo verea mara, “Legion!” Hija atu mo verea matan tanume sasati matuvana jea la lo toho hin tamlohi atu. ");
INSERT INTO tgp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ale tanume sasati la tangi isana vara i pa sopo retileu isara vara la sivo hin koko tavera jea atu sei mo sivo atano jea na lolo varama mata mateia. ");
INSERT INTO tgp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hin jara atu vao poi matea la lo hanhani na pahisa vutivuti atu, ale la tanume sasati atu la tangi isana vara i tinar̃ihira la unu hinira, ale mo tinar̃ihira. ");
INSERT INTO tgp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ale la tanume sasati atu la malue hin tamlohi atu la unu hin pa vao poi atu, moiso vao poi atu la maro sevuti hin pesapesa atu la jovi sivo na tasi la pute. ");
INSERT INTO tgp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ale tamlohi kilau la poi atu lara la hite hinau atu mo masese, la rovo ale la sorahia na taon tavera peresi na jara r̃alihi atu. ");
INSERT INTO tgp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ale moiso tamlohi la vano vara la hite na sava mo masese, ale la kau isan Iesu la tapai pa tamlohi atu sei tanume sasati la lo malue hinia moiso mo lo sakele na palon Iesu, mo ruru ale r̃omina mo r̃uhu moiso, ale la matahu. ");
INSERT INTO tgp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ale la haratu sei la lo hite hinau atu la verea isara sohena sava tanume sasati la malue hin tamlohi atu. ");
INSERT INTO tgp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ale tamlohi tari r̃alihi hin jara atu Gerasenes la usia vara i malue isara, matan matahu tavera mo sohonira. Ale mo mele vele hin pa boti atu ale mo mele hilu. ");
INSERT INTO tgp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pa tamlohi atu sei tanume sasati la lo malue isana, mo usia r̃ilangi vara i usuria, pani Iesu mo r̃ulea mara, ");
INSERT INTO tgp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“O mule, ale o vereuli na sava God mo vaia matam.” Ale mo vano, mo retivujavujangi na jara tari hin taon tavera atu na sava Iesu mo vaia matana. ");
INSERT INTO tgp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ale na rani Iesu mo mele hilu, pa vao tamlohi atu la avulahi matan la lo saovia. ");
INSERT INTO tgp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ale hin jara atu, tamlohi matea hijana Jairus mo mai isana, enia tamlohi aulu hin ima lotu atu. Ale mo jovi na palon Iesu mo tangi isana vara i mai na imana, ");
INSERT INTO tgp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","matan venatuna vorahese matea, taunina mo sangavulu r̃omana mo rua, mariviti i mate. Ale Iesu mo lo vano, tamlohi la lo tiatia hinia. ");
INSERT INTO tgp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ale har̃ai matea, rojo nona har̃ai mo lo toho mo tuai isana mata tauni mo sangavulu r̃omana mo rua moiso, hina purongo vara mo jalahi vevuhi na nona mania isana Doctor, mo sopo tea i er̃i vai mamahunia. ");
INSERT INTO tgp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mo mai na har̃in Iesu, ale mo tikeli na revrevu nona ruru, ale vahatea purongo nona rojo mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ale Iesu mara, “Hare natu mo tikeliau?” Tamlohi tari lara enira mo vono, ale Peter mara, “Moli, vao nike la porotiho, la lo tiatia isam!” ");
INSERT INTO tgp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pani Iesu mara, “Tamlohi matea mo tikeliau, matan na rongovosahia vara suiha mo malue isaku.” ");
INSERT INTO tgp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ale na rani har̃ai atu mo hitea vara i sopo er̃i mele luhu, mo mai isana mo savaravara, mo jovi na nahona, ale mo vereulia na naho tamlohi vara mata sava natu mo tikelia, ale sohena sava Iesu mo vai na nona rojoa mo tihai vahatea purongo. ");
INSERT INTO tgp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ale Iesu mo verea isana mara, “Venatuku, nom rasua mo vaiho ko r̃uhu; o vano peresi na tamata.” ");
INSERT INTO tgp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na rani mo pa lo retireti, volitusi matea na iman tamlohi aulu atu mo mai isan tamlohi aulu atu mara, “Venatum mo tihai moiso; o sopo mele verea isan Tija sei.” ");
INSERT INTO tgp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pani Iesu mara mo rongo hinau atu mo verea isana mara, “O sopo matahu; o rasuau purongo ale venatum i pa r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ale na rani mo mai mo kau na iman pa tamlohi aulu atu, mo sopo tinar̃ihia vara tea i unu peresia, pani Peter purongo enia John, James, peresi taman har̃arihi atu enia tinana. ");
INSERT INTO tgp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ale tamlohi la lo tangi, ale la lo tangtangi matana, pani Iesu mo verea mara, “Ha sopo tangi matan enia mo sopo mate, pani mo lo juruvi purongo.” ");
INSERT INTO tgp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ale la manaluluhia matan la levosahia vara enia mo mate moiso. ");
INSERT INTO tgp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pani mo tauri na limana mo tovia mara, “Natirihi, o turu!” ");
INSERT INTO tgp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ale maurina mo mele unu hinia, ale mo turu vahatea. Iesu mo verea isara vara la silea hin te hinau vara i hania. ");
INSERT INTO tgp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ale tamana enia tinana la mar̃urahi tavera, pani mo verea isara vara la sopo mele vere te tamlohi hatea na sava mo masese. ");
INSERT INTO tgp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ale mo tovi la tupu sangavulu r̃omana mo rua atu la mai jara matea, ale mo silera na suiha vara la aulu na tanume sasati tari, ale vara la er̃i vai na rojoa la tihai, ");
INSERT INTO tgp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ale mo r̃ulera la vano vara la retivujavujangi hin mauri atu God mo aulu hinia, ale vara la vai mamahuni na tamlohi na nora rojoa. ");
INSERT INTO tgp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ale Iesu mo verea isara mara, “Ha vano lekoleko na malelemim, ha sopo lavi te tihonimim teni te tanga, teni te pereti, teni te mania, ale ha sopo lavi te ruru i rua. ");
INSERT INTO tgp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ale sava ima ka unu hinia, ha lo toho atu i tikeli na rani ka opoia vara ha mele malue hin taon atu. ");
INSERT INTO tgp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ale sava jara la r̃ohu vara la lavi kamim, vara ka malue hin taon atu, ha sar̃sar̃hi nar̃ihi na tangotango palomim sohena matamata matea matan God mo tipahira.” ");
INSERT INTO tgp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nona tamlohi la malue la vano na vanua tari, la retivujavujangi na Retir̃uhu, la vai na rojoa la tihai na jara tari la vano ea. ");
INSERT INTO tgp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hin rani atu, Herod Antipas natun supe Herod mo lo tamlohi aulu hin Judea, ale mo rongo la hinau atu la lo masese, r̃omina mo sopo sakele matan hai la lo verea lara John tamlohi Paptijo mo mele turu na mateia, ");
INSERT INTO tgp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ale hai lara Elijah mo mele pala, hai tinapua isara lara pr̃ovet matan tuai matea mo mele turu. ");
INSERT INTO tgp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod mara, “Enau na tairoto na patun John moiso, pani sava tamlohi nahai sei na lo rongo na sorasorahina?” Ale Herod mo opoia vara i hitea. ");
INSERT INTO tgp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na rani vahar̃ule non Iesu la mele pala, la vere na hinau tari la vaira isana. Ale mo lavira la malue la vano hasera na taon matea la tovia Bethsaida. ");
INSERT INTO tgp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","La vao atu lara la levosahia, la usuria ale mo avulahi hinira mo vujangira hin mauri atu God mo aulu hinia, ale mo vai na rojoa non la haratu la rojo la tihai. ");
INSERT INTO tgp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ravravi mo lo sivo, ale la tupu sangavulu r̃omana mo rua atu la mai la verea isana lara, “O r̃ule vao nike la vano la aleale hara hinau peresi na nora jara juruvi na vanua tari hin jara tavera nike, matan r̃a lo toho na jara hasetoho nahai.” ");
INSERT INTO tgp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pani mo verea isara mara, “Kamim natu ha silera hin te hinau vara la hania.” Lara, “Kama lo lavi na pereti mo lima peresi na maji mo rua purongo, avei ko lo verea vara kama pa vano mata voli te hinau han la tamlohi tari nike?” ");
INSERT INTO tgp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Matan evi tamlohi purongo korong mo tikeli tari vaha lima Iesu mo verea isana nona tamlohi usuri mara, “Ha vaira la sakele tamlohi mariviti i ngavulu lima na vao matea.” ");
INSERT INTO tgp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ale la vaia sohena, la vaira enira mo isoiso la sakele. ");
INSERT INTO tgp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ale Iesu mo lavi la pereti atu mo lima peresi la maji atu mo rua, mo tar̃a sahe aulu na tuka mo ler̃uhu hinira, moiso mo tope la pereti atu mo silea isana nona tamlohi usuri vara la taua na nahon la vao atu. ");
INSERT INTO tgp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ale tamlohi tari la hanhani la masu. Ale la takonahi na sope hanhani, la sohonia na tanga mo sangavulu r̃omana mo rua. ");
INSERT INTO tgp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na rani tinapua matea, Iesu mo lo usiusi enia hasena, ale nona tamlohi usuri la lo toho atu, ale mo usia isara mara, “La vao nike la lo verea lara enau hare?” ");
INSERT INTO tgp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ale la r̃aramia lara, “John tamlohi paptijo. Pani hai lara Elijah, ale tatuara lara pr̃ovet matea matan tuai mo mele turu.” ");
INSERT INTO tgp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Moiso mo verea isara mara, “Pani kamim kara enau hare?” Ale Peter mo r̃aramia mara, “Engko Kr̃isto non God!” ");
INSERT INTO tgp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ale mo horora vara la sopo mele vere hinau atu isan te tinapua hatea, ");
INSERT INTO tgp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","mara, “Natun tamlohi i pa lavi na rongohaji na hinau matuvana, ale tamlohi aulu hin Israel peresi na Moli mata pr̃is tolu na tamlohi vujangi mata leu, la pa r̃ohu hinia, la pa vilimateia, ale na hatolu rani i pa mele turu na mateia.” ");
INSERT INTO tgp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ale mo verea isara mo isoiso mara, “Vara tea mo opoia vara i usuriau, i r̃ohu na masalona, ale i soloti na nona talopeilopei tarea ale i usuriau. ");
INSERT INTO tgp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Matan sava tamlohi mo opoia vara i hase juri na maurina, maurina i pa tihai; pani sava tamlohi mo vaitihai na masalona mataku, i pa juri na maurina. ");
INSERT INTO tgp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Matan sava mo r̃uhu isana tamlohi matea vara i lavi vevuhi na hinau tari na varama, pani hitahu maurina i pa tihai? ");
INSERT INTO tgp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Matan hare mo mahanuhanu hiniau peresi na noku reti, Natun Tamlohi i pa mahanuhanu hinia hin rani atu vara i mai na hasohasona tolu na hasohason Tama peresi na angelo tapu. ");
INSERT INTO tgp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pani varar̃uhu na verea isamim, vara tatuamim la lo turu nakerihi akerihi la pa sopo hite na mate vavano la hite mauri atu God mo aulu hinia i pala.” ");
INSERT INTO tgp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ale korong rani mo limaravtolu mo vano moiso hin la nona retireti atu, Iesu mo lavi Peter, John peresi James la sahe aulu na vutivuti mata usiusi. ");
INSERT INTO tgp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ale mo lo usiusi, nahona mo posi, ale nona ruru merara la r̃ilangi jea mata kilaura. ");
INSERT INTO tgp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eh! Tamlohi mo rua la lo retireti peresia, Moses enia Elijah, ");
INSERT INTO tgp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","la pala na hasohaso tavera la lo sorahia na nona malue sei i pa masese Jerusalem i pa sopo tuai. ");
INSERT INTO tgp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ale Peter tolu na tapalana sei la lo toho peresia la malokoloko sati na juruvi, pani mara la hite na hasohasona peresi na tamlohi mo rua la lo turu peresia matara mo r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ale la tamlohi atu lara la lo malue isana, Peter mo verea isan Iesu mara, “Tamlohi tavera, mo r̃uhu jea matan kama lo turu akerihi nakerihi. Mo r̃uhu vara kama turuhi te tent i tolu akerihi, nom matea, matea non Moses, ale matea non Elijah!” Pani Peter mo sopo levosahi na sava mo lo verea. ");
INSERT INTO tgp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mo pa lo vere la hinau sei, telangi matea mo jovi tataholo isara, ale matahu tavera mo sohonira matan telangi atu mo hovira. ");
INSERT INTO tgp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ale leo matea mo malue hin telangi atu mara, “Haranike enia Natuku, haratu na vir̃onia; ha tapurongo isana!” ");
INSERT INTO tgp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Leo atu mara mo reti mo isoiso, Iesu hasena mo pa lo toho atu. Ale la nona tamlohi usuri atu la sopo mele vereverea, ale la sopo vere na sava la hitea isan tea hin la rani atu. ");
INSERT INTO tgp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mo mele rani sahe, lara la sevuti hin vutivuti atu moiso, vao tavera matea mo tapaira. ");
INSERT INTO tgp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ale moiso, tamlohi matea hin vao atu mo ulo mara, “Tija, na usia r̃ilangi isam vara o mai o hite natuku matan enia vorahese. ");
INSERT INTO tgp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tanume sasati matea mo sohonia, ale vahatea purongo mo ngara. Mo lo tuatuahia vavano valval jingona mo lo malue; mo lohilohi na epena tari, mo r̃ohu vara i malue hinia. ");
INSERT INTO tgp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na usia r̃ilangi isana nom tamlohi usuri vara la pa titiu nar̃ihia, pani la sopo er̃i vaia!” ");
INSERT INTO tgp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu mo r̃aramia mara, “Kamim mo sopo te nomim rasua, ka pina lejileji, na sopo levosahia vara a pa toho i tikeli pangisa isamim natu ha pa rongovosahi. O lavi natum i mai!” ");
INSERT INTO tgp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mo pa lo mai, tanume lumiha sasati atu mo mele vujahia sivo na lepa, ale mo tuatuahia. Pani Iesu mo savurahi tanume sasati atu, ale mo vai na epena tari la mele r̃uhu, moiso mo silea isan tamana. ");
INSERT INTO tgp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ale tamlohi tari la mar̃urahi tavera na suiha tavera non God. Pani la pa lo mar̃urahi na hinau tari sei mo lo vaira, Iesu mo verea isana nona tamlohi usuri mara, ");
INSERT INTO tgp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ha lo levosahi na sava a pa verea isamim: i pa sopo tuai la pa tau Natun Tamlohi na lima tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pani la sopo levosahi nona reti sei, God mo jorohia isara matan vara la pa sopo er̃i rongovosahia, pani la matahu vara la usia na r̃aramin reti atu. ");
INSERT INTO tgp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mo sopo tuai vauriuri matea mo malue isara vara hare isara enia mo aulu jea. ");
INSERT INTO tgp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pani Iesu mo levosahi na r̃omira, mo turu mo lavi na natirihi matea mo taua na pahisana, ");
INSERT INTO tgp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ale mo verea isara mara, “Vara tea mo lavi te natirihi sohen harihi na hijaku, enia mo laviau. Ale sava tamlohi mo laviau mo lavi haratu mo lo r̃uleau. Matan haratu mo atano jea hin kamim, enia natu mo aulu jea.” ");
INSERT INTO tgp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John mo r̃aramia mara, “Moli, kama hite na tamlohi matea mo lo titiu nar̃ihi na tanume sasati na hijam, ale kama vaihitea vara kama horoa matan enia mo sopo vonamam matea.” ");
INSERT INTO tgp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pani Iesu mo verea isana mara, “Ha sopo horoa, matan haratu mo sopo meresahi isamim enia tatuamim.” ");
INSERT INTO tgp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Rani mo lo mai mariviti vara i sahe na tuka, Iesu mo tau na r̃omina vara i sahe Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ale mo r̃ule na tamlohi hai la vano tiroma hinia, ale la vano la unu na vanua matea nona mara Samaria matan vara la pa tatamahu matana. ");
INSERT INTO tgp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pani la tamlohi atu la r̃ohu hinia matan mo tau na r̃omina vara i sahe Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ale nona tamlohi usuri sei James enia John lara la rongoa lara, “Moli, ko opoia vara kama usi na hapu na tuka i jovi sivo i sulira?” ");
INSERT INTO tgp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pani Iesu mo posi mo reti isara. ");
INSERT INTO tgp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ale la malue la vano na vanua tinapua. ");
INSERT INTO tgp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","La pa lo vano na malele, ale tamlohi matea mo verea isana mara, “A pa usuriho vano na sava jara ko vano ea.” ");
INSERT INTO tgp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ale Iesu mo verea isana mara, “Viriu jala enira nora jara juruvi mo lo toho, maji avuavu enira taura, pani Natun Tamlohi mo sopo te nona jara juruvi.” ");
INSERT INTO tgp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Isana tinapua mo verea mara, “O usuriau!” Pani tamlohi atu mara, “Moli, o tinar̃ihiau a vano a tavuni tamaku tako.” ");
INSERT INTO tgp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ale Iesu mo verea isana mara, “O tinar̃ihi la haratu la mate la tavuni na nora mate. Pani engko, o vano, o retivujavujangi mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ale mele tamlohi tinapua matea mo verea mara, “A pa usuriho Moli, pani o tinar̃ihia vara a vano a tulahi na tahisaku tako.” ");
INSERT INTO tgp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu mo verea isana mara, “Haratu mo sopo tau na r̃omina i r̃ilangi vara i tikeli na isoisona, mo sopo tataholo vara i unu hin mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hitahun haratu, Moli mo vir̃oni na tupu ngavulu limaravrua mo rua tinapua , ale mo r̃ulera la vano tiroma hinia, la vano mo rua rua na taon tari peresi na jara sei i pa vano ea i pa sopo tuai. ");
INSERT INTO tgp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ale Iesu mo verea isara mara, “Vua asitauni mo mar̃ivi hajavua pani tamlohi voko enira tupu visalete purongo. Matana, ha usiusi isan Moli mata asitauni vara i r̃ule na tamlohi voko la vano mata vu na nona asitauni. ");
INSERT INTO tgp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ha vano na malelemim; ha lo levosahia vara na lo r̃ule kamim ka lo vano sohena natu sipsip na livuha viriu jala. ");
INSERT INTO tgp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ha sopo lavi te tanga korohi, teni te tanga, teni te sabat, ale ha sopo sile na retioloolo isan tea na malele. ");
INSERT INTO tgp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sava ima ka unu hinia, tiroma ha verea vara, ‘Tamata i pa toho hin ima akerihi!’ ");
INSERT INTO tgp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ale vara tea hin ima atu mo avulahi hin kamim, nomim ler̃uhu i pa lo toho isana, pani vara mo vono, i pa mele hilu mai isamim. ");
INSERT INTO tgp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ale ha lo toho hin ima atu purongo, ale ha lavi na sava la silea mata inua peresi na hanhani, matan mo tataholo vara tamlohi voko i lavi na volina. Ha lo juruvi na ima matea purongo. ");
INSERT INTO tgp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Vara ka unu na taon matea, ale la lavi kamim, ha hani na sava la taua na nahomim. ");
INSERT INTO tgp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ha vai na nora rojoa la tihai, ale ha verea isara vara, ‘Mauri atu God mo aulu hinia mo mai mariviti isamim moiso.’ ");
INSERT INTO tgp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pani vara ka unu na taon matea, ale la r̃ohu hin kamim, ha sivo na nora malele tavera, ale ha verea vara, ");
INSERT INTO tgp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kama sar̃sar̃hi nar̃ihi na tangotango nomim taon na palomam sohena matamata matea na nahomim matan ka r̃ohu hin kamam, ale matana, God i pa r̃ohu hin kamim. Ha lo levosahia vara mauri atu God mo aulu hinia mo lo mai mariviti.’ ");
INSERT INTO tgp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Varar̃uhu na verea isamim, vara talai non Sodom i pa sopo r̃ilangi i tikeli na talai nona taon sohen harihi na rani mata aria. ");
INSERT INTO tgp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Rani sasati isam Chorazin! Rani sasati isam Bethsaida! Matan vara la hina mar̃urahi nike sei la vaira isamim la pa lo vaira hin Tyre enia Sidon, enira la pete posi moiso tuai, la ru na paraparati paki, ale la vuluvului na patmakovi moiso mata nora hehe. ");
INSERT INTO tgp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pani talai non Tyre enia Sidon i pa sopo r̃ilangi i tikeli na nomim talai na rani mata aria. ");
INSERT INTO tgp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ale engko Capernaum, ko r̃om vara God i pa taheho o sahe na tuka? I pa tauho sivo atano na varama mata mateia! ");
INSERT INTO tgp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Haratu sei mo tapurongo isamim mo tapurongo isaku, ale haratu mo r̃ohu hin kamim mo r̃ohu hiniau; ale haratu mo r̃ohu hiniau mo r̃ohu hin haratu sei mo lo r̃uleau.” ");
INSERT INTO tgp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hitahu la tupu ngavulu limaravrua mo rua atu la mele hilu mai isan Iesu na avulahi lara, “Moli, tanume sasati sohena, la oloolo hin kamam mata hijam!” ");
INSERT INTO tgp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ale Iesu mo verea isara mara, “Na hite Setan mo jovi sivo atano sohena vaha na masapa mo sari na varama. ");
INSERT INTO tgp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ha lo levosahia vara na sile kamim na suiha vara ha varasi na mata peresi na novu lepa peresi na suiha tari tinatinapua non Setan matan ha pa aulu hinira mo isoiso, ale i pa sopo te hinau hatelete hinira i er̃i komo kamim. ");
INSERT INTO tgp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Varar̃uhu, pani ha sopo avulahi matan tanume sasati la oloolo hin kamim; pani ha avulahi matan God mo uli na hijamim moiso na tuka!” ");
INSERT INTO tgp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na ranin hinau atu, Iesu mo avulahi na suihan Tanume Tapu ale mara, “Na vere meje isam Tama, Moli matan tuka peresi na varama, matan ko jarohi la hinau nike isana tamlohi lelevosahi peresi na tamlohi rongovosahi, ale ko vujangira isana natuvarihi purongo. Varar̃uhu Tama, ko avulahi hinia matan mo usuri na masalom r̃uhur̃uhu! ");
INSERT INTO tgp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tamaku mo sileau na hinau tari, ale mo sopo tea i levosahia vara Natuna enia hare pani Tama purongo, ale mo sopo tea i levosahi Tama pani Natuna purongo peresi na sava tamlohi Natuna mo vir̃onia vara i vujangia isana.” ");
INSERT INTO tgp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Moiso mo posi vano isana nona tamlohi usuri mo varavaramasa isara mara, “Avulahi isamim matan ka hite na sava ka lo hitea. ");
INSERT INTO tgp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Varar̃uhu na verea isamim, pr̃ovet peresi na supe matuvana la lo kilau vara la hite na sava ka lo hitea, ale vara la rongo na sava ka lo rongoa, pani la sopo rongoa.” ");
INSERT INTO tgp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ale na rani matea tamlohi lelevosahi mata leu matea mo turu vara i vaihite Iesu na retiusia matea sohen harihi, “Tija, a pa vai na sava natu, vara a lavi na mauri tui hinia?” ");
INSERT INTO tgp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu mo verea isana mara, “La uli na sava na Leu? Na nom kilakilau mo verea sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ale mo r̃aramia mara, “‘O opoi Moli nom God vevuhi na mapum, na maurim, na suiham peresi na r̃omim’; ale, ‘O opoi na tahisam sohen ko lo opoiho hasem’.” ");
INSERT INTO tgp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Moiso, Iesu mo verea isana mara, “Ko verea mo tataholo. O vaia sohena, ale o pa mauri matana.” ");
INSERT INTO tgp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tamlohi atu mo opoia vara i hasena vaia i tataholo na nahon Iesu, ale mo verea isan Iesu mara, “Ale, hare enia tahisaku?” ");
INSERT INTO tgp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu mo r̃aramia mara, “Ale na rani matea tamlohi matea mo tai Jerusalem mo lo sivo Jericho, ale tamlohi vili na tamlohi mata vavanaho hai la tauria la r̃ari nar̃ihi na nona ruru, la lavi nar̃ihi na nona mania, moiso la vilia la pulahia na malele mariviti i mate, ale la malue. ");
INSERT INTO tgp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ale mo sopo tuai pr̃is matea mo lo sevuti hin malele atu mo hitea, pani mara mo hite tamlohi atu mo hahau pahipahi hinia. ");
INSERT INTO tgp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ale sohen haratu purongo, tamlohi voko na Temple matea na vaon Levi mara mo mai hin jara atu mo hitea, ale mo hahau pahipahi hinia. ");
INSERT INTO tgp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pani hitahu, mara Samaria matea na nona hahau mo mai hin jara atu, ale mara mo hitea mo r̃omopoia. ");
INSERT INTO tgp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mo rautoho na pahisana, mo rengi na wel peresi na waen na matara maja, ale mo pesira, moiso mo taua aulu na har̃i pulana donki, ale mo lingia mo mai na ima mapu matea, mo lo kilaua atu. ");
INSERT INTO tgp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mele rani sahe tamlohi atu mo sile na tamlohin ima mapu atu na mania mo tataholo mata voko mata rani mo rua mara, ‘O lo kilaua, ale sava hinau ko jalahia matana, a pa mele spaia na rani na mele pala nike.’” ");
INSERT INTO tgp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ale Iesu mo usia isana mara, “Na r̃omim, sava tamlohi natu hin la haratu mo tolu enia tahisan tamlohi atu sei tamlohi vili na tamlohi mata vavanaho la tauria?” ");
INSERT INTO tgp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Moiso pa tamlohi atu mo r̃aramia mara, “Haratu mo r̃omopoia.” Ale Iesu mo verea isana mara, “O vano o vaia sohena.” ");
INSERT INTO tgp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ale na malelera la lo vano Jerusalem, Iesu mo unu na vanua matea, ale har̃ai matea hijana Martha mo avulahi vara i unu na imana. ");
INSERT INTO tgp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ale vetasina matea hijana Mary, mo sakele na palon Moli mo lo tapurongo na nona vujangi. ");
INSERT INTO tgp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pani Martha mo tiatia na nona tatamahu, ale mo mai isan Iesu mara, “Moli, ko sopo r̃omiau matan vetasiku mo rovo hiniau, ale enau haseku purongo na lo tatamahu? O verea isana vara i mai i tueniau!” ");
INSERT INTO tgp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pani Moli mo r̃aramia mara, “Martha, Martha engko ko r̃omkaka na hinau matuvana, ");
INSERT INTO tgp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pani hinau matea mo aulu jea. Mary mo vir̃oni na sava mo mele r̃uhu jea sei tea i pa sopo er̃i lavi nar̃ihia isana.” ");
INSERT INTO tgp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ale Iesu mo lo usiusi na jara matea, ale mara mo isoiso, nona tamlohi usuri matea mo verea isana mara, “Moli, o vujangi kamam mata usiusi sohen John tamlohi paptijo mo lo vujangi na nona tamlohi usuri hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ale Iesu mo verea isara mara, “Vara ka usiusi, ha verea vara: God Tama, kama opoia vara tamlohi tari la sile na oloolo tavera isam matan engko ko tapu. Kama opoia vara nom suiha aulu mata supe i pala. ");
INSERT INTO tgp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","O sile kamam na hanhani matan nohorihi, ");
INSERT INTO tgp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","O r̃omi kamam matan nomam hehe sohena kama lo r̃omi na hehe nona tinapua isamam. O lavi nar̃ihi kamam na hina vaihite.” ");
INSERT INTO tgp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ale mo verea isara mara, “R̃a levosahia vara, vara te tapalam mo mai isam na livuha vutepongi ale mo verea isam vara, ‘Tapala, o er̃i sileau hin te pereti i tolu, ale a pa mele spaia, ");
INSERT INTO tgp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","matan tapalaku matea mo pa pala purongo na nona hahau, ale mo sopo te sope hanhani vara a silea isana.’ ");
INSERT INTO tgp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ale na lolo ima o pa ulo isan tapalam na jingoima vara, ‘O sopo vaore, matarua mo pelati ale natuku la lo juruvi peresiau na vata. A sopo er̃i turu vara a sileho hin te hinau.’ ");
INSERT INTO tgp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Varar̃uhu na verea isamim, hina purongo vara enia tapalam matea, o pa sopo er̃i turu vara o silea hin te hinau hatea, pani o pa turu vara o sile na sava mo opoia matan mo lo ajiho matana. ");
INSERT INTO tgp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Varar̃uhu na verea isamim, ha usia, ale i pa mai isamim; ha alea, ale ha pa lavutia; ha r̃erengi, ale i pa roi isamim. ");
INSERT INTO tgp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Matan tamlohi tari sei la usia la lavia, ale haratu mo alea, mo lavutia, ale isan haratu mo lo r̃erengi, pelati i pa roi. ");
INSERT INTO tgp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ale sava tama isamim, vara natuna mo usia na maji matea, i pa turu i sile na mata sasati matea isana, pani mo sopo maji sei mo usia? ");
INSERT INTO tgp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Teni vara mo usia hin te esile toa, i pa turu i silea na novu lepa? ");
INSERT INTO tgp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Vara kamim sei ka sasati jea, pani ka levosahia sohena sava vara ha sile na otori r̃uhur̃uhu isana natumim, ha lo levosahia vara God Tama na tuka i pa sile na hinau mo r̃uhur̃uhu jea sohena Tanume Tapu, isan la haratu la usia!” ");
INSERT INTO tgp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na rani matea Iesu mo titiu nar̃ihi na tanume sasati matea sei mo vai na tamlohi matea mo mengo. Pa tanume sasati mara mo malue, pa mengo atu mo retireti, ale tamlohi la mar̃urahi tavera. ");
INSERT INTO tgp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pani tatuara lara, “Enia mo lo titiu nar̃ihi na tanume sasati na hijan Beelzebul, tamlohi tavera nona tanume sasati!” ");
INSERT INTO tgp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ale tatuara, matan la opoia vara la vaihitea, la ajia vara i vai te matamata mar̃urahi hatea i tai na tuka. ");
INSERT INTO tgp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pani matan Iesu mo levosahi na r̃omira mo verea isara mara, “Jara supe tari sei la patumasa na lolora la pa puru, ale patumasa na lolo ima matea i pa aseasera la jovi. ");
INSERT INTO tgp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ale, vara Setan sohena mo lo hase valum isana hasena matan enia mo vaiau na er̃i titiu nar̃ihi na nona tanume sasati, nona suiha mata supe i pa turu sohena sava? ");
INSERT INTO tgp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ale, vara na lo titiu nar̃ihi na tanume sasati na hijan Beelzebul, hare natu mo lo tueni na natumim na rani la lo titiu nar̃ihi na tanume sasati? Matan haratu, enira natu la pa nomim tamlohi aria. ");
INSERT INTO tgp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pani vara na lo titiu nar̃ihi na tanume sasati na suihan God, ka levosahia vara mauri atu God mo aulu hinia mo pala isamim. ");
INSERT INTO tgp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Vara tamlohi suiha matea sei mo tatamahu mata valum, enia mo lo matahi na imana tavera, nona tavtav la pa lo toho i r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pani vara tea mo mele suiha mo jeua mo mai mo valum peresia, ale mo jeua, enia i pa lavi nar̃ihi na nona hinahinau mata vuro sei mo lo tau na nona rasua hinira, ale i pa ase na nona tavtav. ");
INSERT INTO tgp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Haratu mo sopo turu peresiau enia mo lo turuleji hiniau, ale haratu mo sopo vilevilei peresiau mo lo levuti jalajalai. ");
INSERT INTO tgp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Vara te tanume lumiha sasati mo malue na tamlohi matea, mo vano r̃alihi na jara hasetoho mo lo aleale nona jara mapu, ale mara mo sopo hite tea mo verea mara, ‘A pa mele vano na imaku sei na tai ea!’ ");
INSERT INTO tgp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ale, mara mo mele mai mo hite imana atu la tivesia, ale la vai mamahunia. ");
INSERT INTO tgp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Moiso, mo mele vano mo lavi na tanume lumiha sasati mo limaravrua tinapua sei la sati la jeua, ale la unu hin ima atu ale la lo toho hinia. Ale hitahu, maurin tamlohi atu i pa sati i jeu tiroma.” ");
INSERT INTO tgp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu mo pa lo vere la hinau nike, har̃ai matea hin vao atu mo ulo isana mara, “Avulahi isan har̃ai atu mo tapeho ale mo kilauho!” ");
INSERT INTO tgp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iesu mo r̃aramia mara, “Avulahi i pa mele r̃uhu jea isan la haratu la rongo na reti non God ale la hahau hinira.” ");
INSERT INTO tgp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ale vao atu mara mo lo tavera jea Iesu mo tapulo verea isara mara, “Pina nike enia pina sasati matea. Mo lo ale na matamata, pani i pa sopo er̃i hite te matamata pani matamata non Jonah purongo. ");
INSERT INTO tgp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Matan sohen Jonah enia matamata matea isana mara Nineveh, Natun Tamlohi sohena isan pina nike. ");
INSERT INTO tgp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ale Vesupe non Sheba i pa turu na rani aria peresi na tamlohin pina nike nake, ale i pa verea vara talai non pina akerihi mo tataholo, matan enia mo tai na jara asau rove mo sinai vara i tapurongo na lelevosahi non Solomon; pani hinau matea mo mele aulu jea hin Solomon mo lo toho nike. ");
INSERT INTO tgp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","La tamlohi atu matan Nineveh la pa turu na rani aria peresi pina nike nake, ale la pa verea vara talai non pina nike mo tataholo, matan enira la posi mata retivujavujangi non Jonah; pani tamlohi matea mo aulu jea hin Jonah mo lo toho nike nake. ");
INSERT INTO tgp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mo sopo te tamlohi i hasahi na lamu, vara i taua na jara jarohi matea na lolo ima, teni i taua na ruhuruhun te tanga; pani i pa kehoia na jarana matan vara la haratu la unu na ima la pa hite na merana. ");
INSERT INTO tgp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matam enia lamu mata epem. Vara matam mo lo r̃uhu, epem tari la lo mar̃ivi na mera; pani vara matam mo sati, epem tari la pa mar̃ivi na r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Matan haratu, o lo kilau mamahu vara sava ko lo r̃om vara enia mera na lolom mo sopo mera varar̃uhu pani r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pani vara epem tari mo mar̃ivi na mera, ale mo sopo te r̃or̃oha hinia, i pa mera vevuhi sohena sasarami lamu matea sei mo lo sileho na merana.” ");
INSERT INTO tgp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu mo pa lo retireti, ale Pharisee matea mo usia vara i vano na imana i hanhani peresia, ale mo vano mo sakele na jara hanhani. ");
INSERT INTO tgp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisee atu mo hutua matan Iesu mo sopo javula tiroma vara i pa hanhani. ");
INSERT INTO tgp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ale Moli mo verea isana mara, “Kamim Pharisee ka lo hoje na paniken peresi na peleti na har̃ira, pani na lolomim ka mar̃ivi na hanmarua peresi na posposi sasati jea. ");
INSERT INTO tgp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kamim ka rongorongo vono! Haratu sei mo lo vai na har̃ina enia mo vai na lolona. ");
INSERT INTO tgp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pani ha sile na silesilea na avulahi isan la haratu la vejuveju, ale ha pa vokevoke vevuhi na maurimim tari. ");
INSERT INTO tgp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pani rani sasati isamim Pharisee! Matan ka lo sile na sangavulu solat, oke peresi na pere pahai tari, ale ka lo r̃omr̃omi purongo na hinau mo aulu na nahon God sohena nomim ariari, ale ka sopo opoi God. Pani i pa mele r̃uhu jea vara ha vaira enira mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Rani sasati isamim Pharisee! Matan ka opoi na jara sakele nona tamlohi aulu na lolo ima lotu, ale ka opoi vara tamlohi la lo sile na retioloolo isamim na jara maket. ");
INSERT INTO tgp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Rani sasati isamim Pharisee! Matan kamim, ka sohena taptap sei tamlohi la sopo levosahia vara enira taptap, ale tamlohi la hahau aulu hinira pani la sopo levosahia, ale mo vaira la lumiha matana.” ");
INSERT INTO tgp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tamlohi lelevosahi mata leu matea hin la haratu la lo turu atu mo r̃aramia mara, “Tija, sava ko lo verea ko vai mahanuhanu hin kamam sohera!” ");
INSERT INTO tgp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ale Iesu mara, “Rani sasati sohena isamim tamlohi lelevosahi mata leu! Matan ka tau na tetehi puhoni isana tamlohi la sopo er̃i lavira, ale te vonamim hatea mo sopo vai te hinau hatelete vara i tuenira. ");
INSERT INTO tgp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Rani sasati isamim! Matan ka voro na matamata mata r̃omr̃omi na pr̃ovet sei tamamim la vilira. ");
INSERT INTO tgp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Matan haratu, kamim ka nora tuetueni ale ka majinga na sava tamamim la vaira, matan enira la vilira ale kamim ka vai na matamata mata r̃omr̃omira na tapura. ");
INSERT INTO tgp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Matan haratu, God na nona lelevosahi mo verea mara, ‘A pa r̃ule te pr̃ovet peresi na vahar̃ule isara, la pa vilimatei te tatuara ale la tipahi te tatuara.’ ");
INSERT INTO tgp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Matana, r̃ae pr̃ovet tari sei mo roro mo tapulo na rani vavahinau hin varama nike, God i pa taua na liman pina nike nake, ");
INSERT INTO tgp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mo tapulo na r̃aen Abel mo tikeli na r̃aen Zechariah, hara sei mo mate na livuha votavota peresi na jara tapu na Temple. Varar̃uhu na verea isamim, God i pa sile na talai tavera isan pina nike nake. ");
INSERT INTO tgp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Rani sasati isamim tamlohi lelevosahi mata leu! Matan ka lo turuhoro na malele tamlohi vara la er̃i levosahi God, ale kamim sohena ka sopo levosahi God, ale ka lo turuhoro na tamlohi sei la opoia vara la levosahi God.” ");
INSERT INTO tgp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ale Iesu mara mo malue hin jara atu, Pharisee peresi na tamlohi vujangi mata leu, la tapulo area r̃ilangi, la jinea vara i mele vere te hinau matuvana, ");
INSERT INTO tgp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","la lo sasaovi r̃or̃o matana vara la er̃i tuvaia hin te hinau i pa verea. ");
INSERT INTO tgp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iesu mo pa lo vano makomona, ale vao tamlohi matuvana la lo takonahi la tiatia hajavua la lo tapulo turu aulu hinira hasera, ale Iesu mo tapulo verea isana nona tamlohi usuri mara, “Ha lo kilau mata isi nona Pharisee, isi sei enia posposi tapnetano. ");
INSERT INTO tgp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mo sopo te hinau vara la jarohia i pa sopo pala, teni te hina luhu vara la pa sopo levosahia. ");
INSERT INTO tgp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Matan haratu, sava ka verea na r̃or̃oha, la pa rongoa na malarani, ale sava ka varavaramasa hinia na jara luhu, la pa vereulia na jara tavera. ");
INSERT INTO tgp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","La tapalaku, varar̃uhu na verea isamim vara ha sopo matahuni la haratu la lo vilimatei na epemim, pani hitahu la sopo er̃i mele vai te hinau tinapua. ");
INSERT INTO tgp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pani a pa retir̃oar̃oahai kamim hin haratu vara ha pa matahunia: ha matahuni God sei matan enia mo lo tauri na suiha vara i vilimatei kamim, ale i er̃i pulahi kamim na moruhapu. Enia natu ha pa matahunia! ");
INSERT INTO tgp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tamlohi tari nike isar̃a la levosahia vara ha er̃i voli te vakarakara i lima na selen mo rua purongo, pani God mo sopo r̃omaliho hin te hatelete. ");
INSERT INTO tgp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Vulumim hatehateahi na patumim sohena, God mo sopo r̃omaliho hin te hatelete. Ha sopo matahu matan kamim ka mele aulu jea na vakarakara matuvana na nahon God. ");
INSERT INTO tgp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ale na verea isamim vara te vonamim hatea i verea vara enia noku na naho tamlohi, Natun Tamlohi sohena i pa verea vara enia nona na naho angelo non God, ");
INSERT INTO tgp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","pani haratu mo vunvunia vara enia noku na naho tamlohi, enau a pa vunvunia vara enia noku na naho angelo non God. ");
INSERT INTO tgp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ale tamlohi tari sei la lo veresatihi Natun Tamlohi, God i pa r̃omira, pani haratu mo veresatihi Tanume Tapu, God i pa sopo r̃omia. ");
INSERT INTO tgp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ale na rani vara tamlohi la lavi kamim na lolo nora ima lotu, teni na naho tamlohi aulu peresi la haratu la lo tauri na suiha, ha sopo r̃omkaka vara ha pa r̃aramira sohena sava teni vara ha pa vere na sava, ");
INSERT INTO tgp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","matan Tanume Tapu i pa vujangi na sava ha pa verea hin rani atu.” ");
INSERT INTO tgp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tamlohi matea hin vao atu mo verea isana mara, “Tija, o verea isan voraiku vara i ase na korun tamamam peresiau.” ");
INSERT INTO tgp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pani Iesu mo verea isana mara, “Tapala, na sopo sinai matan vara a ari teni a ase na nomim hinahinau.” ");
INSERT INTO tgp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ale Iesu mo verea isara mara, “Ha lo kilau, ha toho asau na posposi tari mata marohati na hinau mo sopo te nomim, matan mauri varar̃uhu enia mo sopo na sava nakonako ka lo lavira.” ");
INSERT INTO tgp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ale mo vere na titileu matea isara mara, “Tamlohi tavtav matea, isana la jea la matuvana hajavua i sopo er̃i vaira, ");
INSERT INTO tgp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ale mo lo hase r̃omr̃omia mara, ‘A pa vai na sava natu, matan mo sopo te jara vara a pa tau mamahuni la vua isaku nike hinia?’ ");
INSERT INTO tgp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ale mara, ‘Ale! Na levosahi na hinau matea a pa vaia, a pa kauti nar̃ihi la noku pea nike, ale a mele vorora la mele tavera jea, ale a pa takonahi na vua isaku peresi na noku hinahinau hinira. ");
INSERT INTO tgp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ale a pa verea isaku haseku vara, ‘Engko nom hinau r̃uhu mo mar̃ivi, ko takonahira la er̃i toho mata tauni matuvana: o mapu, o hanhani, o inu ale o avulahi.’ ");
INSERT INTO tgp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pani God mo verea isana mara, ‘Tamlohi rongorongo vono! Hin vutepongi akerihi purongo, a pa nar̃ihi na maurim, ale la hinau sei ko lo tatamahunira la pa sopo r̃uhu matan te hinau isam.’ ");
INSERT INTO tgp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","I pa sohena isan haratu sei mo lo takonahi na nona tavtav mata masalona, pani mo sopo r̃omr̃omia vara i tapala r̃uhu peresi God.” ");
INSERT INTO tgp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ale Iesu mo verea isana nona tamlohi usuri mara, “Matan haratu, na verea isamim, ha sopo r̃omkaka mata maurimim vara sava ha pa hania, teni na epemim vara sava ha pa rua. ");
INSERT INTO tgp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Matan mauri mo aulu jea, mo jeu na hanhani, ale epemim mo aulu jea, mo jeu na ruru. ");
INSERT INTO tgp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ha to r̃omr̃omi na maji avuavu, enira la sopo lavo teni la sopo vu, ale mo sopo te nora jara tatamahu teni te pea, pani God mo lo vahanira. Ka levosahia vara na nahon God kamim ka mele aulu jea na maji avuavu! ");
INSERT INTO tgp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ale sava tamlohi isamim na nona r̃omkaka i er̃i vai na maurina i mele peravu matan te aoa hatea? ");
INSERT INTO tgp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ale vara ha sopo er̃i vai te hina rihirihi hatea sohen haratu, mata sava natu ka lo r̃omkaka na hinau tari? ");
INSERT INTO tgp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ha to r̃omr̃omi na lili wai sohena sava la lo ulua, la sopo voko, la sopo tulai na nora ruru, pani na verea isamim vara ruru r̃uhur̃uhu non Solomon na nona tavtav tavera, la sopo r̃uhu sohena ruru non te lili wai hatea. ");
INSERT INTO tgp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pani vara God mo ru na r̃uvur̃uvu matan nahapani purongo, pani pavuho mo mahoa, ale la pulahia na hapu, mo sohena sava, ka r̃om vara God i pa sopo ruru kamim? Kamim akerihi, nomim rasua mo rihirihi hajavua! ");
INSERT INTO tgp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ale ha sopo ale na sava ha pa hania teni na sava ha pa inua, teni ha lo r̃omkaka. ");
INSERT INTO tgp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Matan la haratu la sopo levosahi God la lo ale la hinau atu, pani Tamamim mo levosahia vara ka opoira. ");
INSERT INTO tgp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pani ha ale mauri atu sei God mo lo silea sei enia mo supe hinia, ale enia i pa sile na hinau tinapua sei ka opoira peresia isamim. ");
INSERT INTO tgp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Natuvarihi, ha sopo matahu, matan Tamamim enia mo avulahi tavera vara i sile kamim hin mauri atu enia mo supe hinia. ");
INSERT INTO tgp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ha har̃ehi na nomim hinahinau, ale ha silesile isan la haratu la vejuveju hin te hinau. Ha vai na nomim tanga korohi sei la pa sopo er̃i r̃ovo hin te rani la mar̃ivi na tavtav matan tuka sei la pa lo toho tui tui ea. Mo sopo te tamlohi vavanaho ea teni te majmaj vara i er̃i komora atu. ");
INSERT INTO tgp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Matan sava jara nomim tavtav la lo toho ea, mapumim sohena la pa lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ha tatamahu matan Moli, ale ha vai na nomim lamu la lo hani, ");
INSERT INTO tgp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ale ha sohena tamlohi sei la lo saovi nora moli vara i pa mele mule na hanhani lahi matea matan vara la er̃i roi na matarua isana vahatea na rani mo pala ale mo r̃erengi. ");
INSERT INTO tgp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Avulahi tavera isana volitusi tari vara nora moli mo tapaira la pa lo kilau na rani mo pala. Varar̃uhu na verea isamim vara na nona avulahi tavera, moli atu i pa ru na ruru nona volitusi, ale i verera vara la sakele na jara hanhani, moiso i pa lavi na hara hinau i silea isara. ");
INSERT INTO tgp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vara mo pala na livuha vutepongi teni na toa tarere ale mo tapaira la pa lo kilau, la volitusi atu la pa avulahi tavera. ");
INSERT INTO tgp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pani ha lo levosahi harihi: vara moli mata ima i pa lo levosahia vara sava rani tataholo tamlohi vavanaho i pa pala hinia, i pa sopo malue na imana vara tamlohi vavanaho i er̃i unu na imana. ");
INSERT INTO tgp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kamim sohena, ha lo tatamahu, matan Natun Tamlohi i pa mai na rani ka r̃om vara i pa sopo mai hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ale Peter mara, “Moli, ko lo vere titileu nike nomam purongo teni nona tamlohi tari?” ");
INSERT INTO tgp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ale Moli mo verea mara, “Hare natu enia patu tamlohi lelevosahi matea sei mo lo turu r̃ilangi tarea mata kilau na iman nona moli? Ale nona moli mo taua mo aulu na imana matan vara i vahani na nona volitusi mata imana na rani hanhani tataholo. ");
INSERT INTO tgp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Avulahi tavera isan volitusi atu vara nona moli mo tapaia mo lo vaia sohena na rani mo pala. ");
INSERT INTO tgp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Varar̃uhu na verea isamim vara moli atu i pa tau volitusi atu i aulu na nona hinahinau tari. ");
INSERT INTO tgp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pani vara volitusi atu mo hase verea isana vara, ‘Noku moli mo sopo mai vila!’ Ale mo tapulo tamaji na volitusi har̃ai peresi na lamane, ale mo hanhani ale mo inu mo drong, ");
INSERT INTO tgp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","moli non volitusi atu i pa pala na rani mo sopo r̃om vara i pa pala hinia na aoa matea mo sopo levosahia, moiso i pa sile na talai tavera jea isana, ale i pa taua peresi la haratu la sopo r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ale sava volitusi sei mo levosahi na masalon nona moli pani mo sopo tatamahu teni mo sopo vavahinau usuri na masalon nona moli, enia i pa lavi na talai r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pani isan volitusi sei mo sopo levosahia vara mo vai na hinau mo sopo tataholo, nona talai i pa sopo r̃ilangi. Isana tamlohi tari sei God mo tau na hinau matuvana na limara, God mo lo kilau mata hinau matuvana jea la pa tai isara. ");
INSERT INTO tgp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na sinai vara a pulahi na hapu na varama mata ase na tamlohi vara hare i pa toho jejeu, ale na opoia jea vara mo lo tapulo hani moiso. ");
INSERT INTO tgp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A pa lavi na paptijo sasati matea mo lo toho na nahoku, ale enia tetehi puhoni matea moiso isaku, ale i pa sohena i tikeli rani atu na lavi vevuhia. ");
INSERT INTO tgp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka r̃om vara na sinai matan vara a sile na tamata na varama? Mo vono, pani vara a sile na patumasa. ");
INSERT INTO tgp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Matan mo tapulo nakerihi mo lo vano, vao ima matea tamlohi mo lima la pa patumasa, mo tolu la pa meresahi hin mo rua, ale mo rua la pa meresahi hin mo tolu. ");
INSERT INTO tgp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","La pa patumasa, tamana i pa meresahi isan natuna, natuna isan tamana, ale tinana i pa meresahi isan venatuna, ale venatuna isan tinana, har̃ai i pa meresahi isan tinan tuana, ale tinan tuana isan naroun natuna.” ");
INSERT INTO tgp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ale Iesu mo verea isan vao atu mara, “Vara ka hite na telangi matea mo lo vele Marino, ka verea vahatea vara, ‘Usa matea mo lo mai.’ Ale mo pala sohena. ");
INSERT INTO tgp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ale vara ka hite na langin tahuna mo lo sere kara, ‘Alo i pa tutuni sati!’ Ale mo pala sohena. ");
INSERT INTO tgp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka tapnetano! Ka levosahia vara ha er̃i verea vara i pa sohena sava na sava ka lo hitera na varama peresi na masapa, pani mata sava natu, ka sopo er̃i verea vara sava rani nahai r̃a lo toho hinia nake? ");
INSERT INTO tgp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ale mata sava natu ka sopo er̃i hase hitevosahi na sava mo tataholo? ");
INSERT INTO tgp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Vara ko lo vano na court, ale i pa mele r̃uhu vara o tapai haratu mo lo tau kamim na court na malele tako, ale o vaihitea vara o vai tataholoi hinau atu peresia tiroma; vara i vono, o pa turu na nahon tamlohi aria, ale i pa ariho o vano na lima tamlohi ima r̃ilangi, ale i pa tauho na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Varar̃uhu na verea isam, o pa sopo er̃i malue vavano o voli vevuhi na nom ave tari.” ");
INSERT INTO tgp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hin pongi atu, tamlohi hai la lo toho atu, la verea isan Iesu lara Pilate mo vilimatei na mara Galilee hai hin rani atu la lo sile na nora malamalai na Temple, ale r̃aera mo hoi peresi na r̃ae nora malamalai. ");
INSERT INTO tgp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ale mo r̃aramira mara, “Ka r̃om vara la mara Galilee atu la hehe mo jeu na mara Galilee tinapua matan la lavi na mateia sohena teni mo vono? ");
INSERT INTO tgp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mo vono, pani na verea isamim vara ha sopo posi, kamim mo isoiso ha pa tihai sohera. ");
INSERT INTO tgp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Teni la tupu sangavulu r̃omana mo limaravtolu atu sei taoa matan Siloam mo jovi mo vilimateira, ka r̃om vara enira la hehe mo jeu na tamlohi tari tinatinapua sei la lo toho Jerusalem? ");
INSERT INTO tgp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mo vono, pani na verea isamim, vara ha sopo posi, kamim sohena ha pa tihai sohera.” ");
INSERT INTO tgp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ale Iesu mo vere titileu akerihi mara, “Tamlohi matea mo lavo na pulo fig matea na isana, ale mo mai mo aleale vuana pani mo sopo hite tea. ");
INSERT INTO tgp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ale mo verea isan nona tamlohi voko mata isa mara, ‘Ko hitea, na mai tauni mo tolu moiso vara a hite te naman pulo fig akerihi ale na sopo hite tea. O tai jovia. Mo lo turuhoro na jara purongo.’ ");
INSERT INTO tgp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ale mo r̃aramia mara, ‘Tamlohi tavera, o mele tinar̃ihia hin tauni akerihi, a pa heli r̃alihia, ale a pa tau na te buluk i r̃alihia. ");
INSERT INTO tgp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ale tavalu tauni korong i pa vua, vara i sohena mo r̃uhu, pani vara mo vono, o er̃i tai jovia.’” ");
INSERT INTO tgp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na rani matea Iesu mo lo vujangi na ima lotu matea atu na Sabbath. ");
INSERT INTO tgp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ale har̃ai matea tanume sasati matea mo vai na har̃ina mo hoho mata tauni mo sangavulu r̃omana limaravtolu. Har̃ina mo hoho ale i sopo er̃i turu tataholo. ");
INSERT INTO tgp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na rani Iesu mo hitea, mo usia mo mai isana, mo verea isana mara, “Har̃ai, engko ko materi na nom rojoa.” ");
INSERT INTO tgp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ale mo tau na limana hinia; ale vahatea purongo har̃ina mo tataholo, ale har̃ai atu mo hasohaso God. ");
INSERT INTO tgp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pani patu tamlohi mata ima lotu atu mo lolokoru matan Iesu mo vai na rojoa mo tihai na Sabbath, ale mo verea isana tamlohi mara, “Rani mo limarave la lo toho mata vavahinau hinira. Ha sinai hin la rani atu matan vara i vai na nomim rojoa la tihai, mo sopo na rani Sabbath.” ");
INSERT INTO tgp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Moiso Moli mo r̃aramia mara, “Kamim ka tapnetano! Na levosahia vara kamim hatehateahi ka lo uli nar̃ihi na pulamim buluk teni donki na nora jara juruvi hin te Sabbath, ale ka lavia vano vara i inu te wai. ");
INSERT INTO tgp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ale ka r̃omi vara mo tataholo teni mo vono vara har̃ai akerihi venatun Abraham matea sei Setan mo lihoa mata tauni mo sangavulu r̃omana limaravtolu moiso, vara i er̃i materi na nona rani r̃ilangi na Sabbath?” ");
INSERT INTO tgp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ale mara mo lo vere la hinau atu, nona meresahi tari la mahanuhanu, ale tamlohi mo isoiso la avulahi na hina r̃uhur̃uhu tari sei mo lo vaira. ");
INSERT INTO tgp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Moiso Iesu mo verea mara, “Mauri atu God mo aulu hinia mo sohena sava? A pa verea vara mo sohena sava hinau? ");
INSERT INTO tgp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mo sohena piri paka matea tamlohi matea mo lavia mo pulahia purongo, ale mo ulua mo mai vipahai tavera matea; ale maji avuavu la lo vai na taura na rangarangana.” ");
INSERT INTO tgp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ale mo mele verea mara, “A pa mele verea vara mauri atu God mo aulu hinia mo sohena sava hinau? ");
INSERT INTO tgp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Enia mo sohena makomo isi sei har̃ai matea mo lavia mo hoia na paki flaua matea vavano isi mo vaia mo sosohi vevuhi.” ");
INSERT INTO tgp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu na nona hahau mo unu r̃ole na taon peresi na vanua mo lo vujangi, ale mo hahau mo lo vano Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ale tamlohi matea mo verea isana mara, “Moli, la haratu sei la pa juri, enira i pa tupu visalete purongo?” Ale mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ha vaihitea vara ha er̃i unu hin matarua rihirihi atu. Matan na verea, vao tavera la pa opoia vara la unu pani la pa sopo er̃i vaia. ");
INSERT INTO tgp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na rani tamlohi tavera mata ima mo turu mo pelati na matarua, ale kamim na jingoima ka tapulo r̃erengi na pelati kara, ‘Moli, o roi isamam!’ Ale i pa r̃arami kamim vara, ‘Na sopo levosahia vara ka tai epu!’ ");
INSERT INTO tgp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Moiso ha pa tapulo verea isana vara, ‘Pani kamam kama lo hanhani, ale kama lo inu peresiho, ale engko ko lo vujangi na malele tavera na nomam taon.’ ");
INSERT INTO tgp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pani i pa verea vara, ‘Na verea isamim, na sopo levosahia vara ka tai epu! Ha malue na nahoku, kamim tamlohi lejileji!’ ");
INSERT INTO tgp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na jara talai, la pa tangtangi ale la pa nar̃nar̃ori na hur̃ura na rani la hite Abraham, Isaac, Jacob peresi na pr̃ovet tari hin mauri atu God mo aulu hinia, pani kamim ka hase horo kamim hinia. ");
INSERT INTO tgp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ale tamlohi la pa tai Opae, Marino, Tahuna peresi Auta, ale la pa sakele na jara hanhani hin mauri atu God mo aulu hinia, ale la pulahi kamim. ");
INSERT INTO tgp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ale ha lo levosahia vara, tatuara sei la lo hitahu nake, la pa tiroma, ale tatuara la lo tiroma nake, la pa hitahu.” ");
INSERT INTO tgp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tataholo hin rani atu, Pharisee hai la mai la verea isana lara, “O rovo nike, matan Herod mo opoia vara i vilimateiho.” ");
INSERT INTO tgp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ale Iesu mo verea isara mara, “Ha vano ha verea isan pusi atu vara, ‘O levosahia vara nohorihi peresi pavuho enau a pa titiu nar̃ihi na tanume sasati, ale a pa vai na rojoa la tihai, ale na hatolu rani a pa isoiso na maleleku. ");
INSERT INTO tgp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hina purongo, a pa vano na maleleku nohorihi, pavuho peresi pongi tolu, matan i pa sopo tataholo vara pr̃ovet matea i mate na jingoiman Jerusalem!’ ");
INSERT INTO tgp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem, o Jerusalem, taon tavera sei mo vilimatei na pr̃ovet, ale mo paru la haratu God mo r̃ulera isana. Vaha visa moiso na opoia vara a takonahi na natum jara matea sohena toa har̃ai matea mo hovi na natuna na ruhuruhu hapana, pani ko r̃ohu! ");
INSERT INTO tgp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","O lo levosahia vara imam mo puru! Ale na verea isam vara engko o pa sopo mele hiteau i tikeli rani atu o pa verea vara, ‘Avulahi isan haratu mo lo mai na hijan Moli!’” ");
INSERT INTO tgp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na Sabbath matea, Iesu mo vano na ima tamlohi aulu matea na vao Pharisee, ale la tamlohi atu la lo kilau r̃or̃oia. ");
INSERT INTO tgp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ale tamlohi purapura matea mo lo toho atu na nahon Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu mo usi na Pharisee peresi na tamlohi lelevosahi mata leu mara, “Mo tataholo vara tea i vai na rojoa i tihai na Sabbath teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pani la sakele tapnono. Moiso Iesu mo tauri tamlohi atu mo vai na nona rojoa mo tihai, ale mo r̃ulea mo vano. ");
INSERT INTO tgp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Moiso mo usia isara mara, “Vara te vonamim hatea te natuna teni pulana buluk hatea mo jovi sivo atano hin te moru wel matea na rani Sabbath matea; hare natu i pa sopo reve nar̃ihia vila?” ");
INSERT INTO tgp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ale enira la sopo er̃i r̃arami la hinau nike. ");
INSERT INTO tgp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ale Iesu mo vere na titileu matea isan la haratu sei la usira la mai atu, matan mo hitea sohena sava la lo hase vir̃oni na jara sakele r̃uhu atu na tep, ale mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Na rani tamlohi matea mo usiho vara o mai na hanhani lahi, o sopo sakele na jara r̃uhu tako, matan ko sopo levosahia vara tamlohi lahi atu mo usi te tamlohi aulu tinapua mo aulu hiniho teni mo vono, ");
INSERT INTO tgp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ale haratu mo lo usi kamim tupra rua sei i pa mai isam i verea vara, ‘O sile na masapam isan tamlohi akerihi!’ Ale o pa mahanuhanu o sivo na jara sakele atano. ");
INSERT INTO tgp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pani vara la usiho, o vano o sakele na jara sakele nona tamlohi purongo tiroma, matan vara tamlohi lahi atu vara i mai isam i verea vara, ‘Tapala, o juha o sahe na jara matea mo mele r̃uhu!’ Moiso, matan haratu o pa lavi na oloolo na naho tamlohi tari sei la lo sakele hin jara hanhani atu peresiho. ");
INSERT INTO tgp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Matan tamlohi tari sei la hase taura aulu, God i pa taura atano, haratu mo hase taua atano, God i pa taua aulu.” ");
INSERT INTO tgp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu mo mele verea isan tamlohin ima atu mara, “Vara o vai na hanhani teni te hanhani tavera hatea, o sopo usi te tapalam teni te voraim, teni te tahisam teni la haratu la tavtav sei la lo toho mariviti isam, matan enira la pa mele usiho na imara matan vara la mele vaia sohena isam. ");
INSERT INTO tgp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pani vara o vai na hanhani tavera, o usi na tamlohi tilavono, haratu la kuti, haratu la papao peresi na matavuso, ");
INSERT INTO tgp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ale God i pa ler̃uhu hiniho matan enira la sopo er̃i mele spaia. God i pa voliho na rani mata sauteterahi na tamlohi tataholo.” ");
INSERT INTO tgp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Moiso, tamlohi matea mo lo sakele peresi Iesu hin tep atu, mara mo rongo la hinau nike, mo verea isan Iesu mara, “Avulahi isana tamlohi tari sei la pa hani pereti atu hin mauri atu God mo aulu hinia!” ");
INSERT INTO tgp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pani Iesu mo verea isana mara, “Na rani matea tamlohi tavera matea mo vai na hanhani tavera matea, ale mo usi na tamlohi matuvana la mai hinia. ");
INSERT INTO tgp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ale hin rani mata hanhani tavera atu mo r̃ule na nona volitusi isan la haratu mo usira moiso vara i verea isara vara, ‘Ha mai matan hinau tari la tatamahu moiso!’ ");
INSERT INTO tgp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pani enira mo isoiso la tapulo posi na r̃omira. Tiromara mo verea isana mara, ‘Na voli na lepa matea, ale a pa vano vara a hitea. O verea vara a pa sopo mai.’ ");
INSERT INTO tgp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ale mele tinapua mo verea mara, ‘Na voli na buluk mo sangavulu, ale a pa vano vara a lo kilau usurira. O verea vara a pa sopo mai.’ ");
INSERT INTO tgp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ale mele tinapua mo verea mara, ‘Na pa lahi na narouku matea, ale matan haratu a sopo er̃i mai.’ ");
INSERT INTO tgp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ale volitusi atu mo mai mo vere la hinau sei isan nona tamlohi tavera. Moiso tamlohi tavera atu mata ima mo lolokoru, ale mo verea isan nona volitusi mara, ‘O vano vila na malele tavera peresi na malele vavarihi hin taon tavera nike, ale o lavi la haratu la tilavono, haratu la kuti, haratu la matavuso peresi la haratu la papao.’ ");
INSERT INTO tgp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ale volitusi atu mo verea mara, ‘Tamlohi tavera, sava ko retileu hinia na vaia moiso, ale masapa mo pa lo toho na lolo ima.’ ");
INSERT INTO tgp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ale tamlohi tavera atu mo verea isan nona volitusi atu mara, ‘O vano asau na malele tavera peresi na pahisa malele, ale o haluhalu na tamlohi tari vara la mai la unu, matan na opoia vara imaku i mar̃ivi. ");
INSERT INTO tgp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Matan na verea isamim, i pa sopo te vonan te tamlohi atu na lo usira tiroma moiso vara la pa er̃i hatir̃oro hin te hinau hatea hin noku hanhani tavera nike.’” ");
INSERT INTO tgp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tataholo hin rani atu, vao tavera la lo toho peresia, ale Iesu mo posi mai isara mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Vara tea mo mai isaku, pani mo sopo r̃ohu hin tamana peresi tinana peresi na natuna, peresi na voraina peresi na vevoraina, teni mo sopo r̃ohu na maurina hasena, enia i pa sopo er̃i mai noku tamlohi usuri. ");
INSERT INTO tgp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sava tamlohi mo sopo soloti na nona talopeilopei ale i usuriau, enia i pa sopo er̃i mai noku tamlohi usuri. ");
INSERT INTO tgp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Matan sava tamlohi isamim natu, vara mo opoia vara i voro na ima aulu matea mata kilau vano asau, mo sopo sakele tiroma matan vara i evia vara nona mania mo tataholo mata i er̃i voro vevuhi ima aulu atu mata kilau vano asau teni mo vono? ");
INSERT INTO tgp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vara i vono, vara mo tau na pulona, pani mo sopo er̃i voro vevuhia, tamlohi tari sei la hitea la pa lo kerehia matana, ");
INSERT INTO tgp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","lara, ‘Tamlohi akerihi mo tapulo voro, pani mo sopo er̃i vaia vevuhia!’ ");
INSERT INTO tgp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Teni, sava supe natu, mo vano vara i vai na vuro peresi na supe tinapua matea, mo sopo sakele tiroma matan vara i hitea vara la nona tamlohi vuro atu tupu tari vaha sangavulu vara la r̃ilangi mata la turuhoro supe atu sei mo lo mai peresi na nona tamlohi vuro tupu tari vaha sangavulu rua . ");
INSERT INTO tgp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Vara mo vono, i pa r̃ule te tamlohi la vano isan nona meresahi atu vara mo pa lo toho asau vara la usia hin te malele mata i sari tamata. ");
INSERT INTO tgp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Matan haratu, te vonamim i sopo er̃i mai noku tamlohi usuri vara mo sopo tinar̃ihi na nona hinahinau tari. ");
INSERT INTO tgp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Niu la saoroia enia mo r̃uhu, pani vara mo sopo mele te ngar̃pulu hinia, ngar̃pulu i pa mele sivo hinia sohena sava? ");
INSERT INTO tgp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jamana mo sopo mele r̃uhu mata r̃avoa peresi te hinau. La pa pulahia purongo. Haratu mo er̃i rongovosahia, o tapurongo!” ");
INSERT INTO tgp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Moiso tamlohi lavi na mania mata takis peresi na tamlohi hehe, la lo mai isana vara la rongoa. ");
INSERT INTO tgp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pani Pharisee peresi na tamlohi vujangi mata Leu la lo reti vavarihi lara, “Tamlohi akerihi mo lo pulutahi peresi na tamlohi hehe, ale mo lo hanhani peresira.” ");
INSERT INTO tgp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ale Iesu mo verera hin titileu akerihi mara, ");
INSERT INTO tgp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hare isamim, vara pulana sipsip mo tikeli mo ngavulu sangavulu vara matea mo jalio, mo sopo mele vano vara i alea? I pa tinar̃ihi la haratu mo ngavulu limaravati mo limaravati la lo hanhani na jara tavera vavano i mele lavuti pa haratu mo lo tihai. ");
INSERT INTO tgp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ale mara mo hitea, i pa solotia na pilina na avulahi. ");
INSERT INTO tgp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Vara mo pala na imana, i pa tovi na tapalana peresi na tahisana la pulutahi peresia, ale i verea vara, ‘Ha avulahi peresiau matan na mele lavuti pa pulaku sipsip atu mo lo tihai.’ ");
INSERT INTO tgp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ale i pa sohen haratu natu, tuka i pa avulahi jea hin haratu matea sei mo mele posi, mo jeu la haratu mo ngavulu limaravati mo limaravati sei la tataholo la sopo jalio na malelera. ");
INSERT INTO tgp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Teni sava har̃ai vara nona selen mo sangavulu, pani mo vaitihai matea, mo sopo hasahi na lamu vara i tivesi na imana i alea vavano i lavutia? ");
INSERT INTO tgp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ale vara mo lavutia, i pa tovi na tapalana peresi na tahisana la pulutahi peresia, ale mo verea mara, ‘Ha avulahi peresiau matan na mele lavuti pa selen atu sei na lo vaitihaia!’ ");
INSERT INTO tgp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ale na verea isamim, vara i pa sohen haratu natu, avulahi tavera mo lo toho na naho angelo non God matan tamlohi hehe atu sei mo mele posi na nona hehe.” ");
INSERT INTO tgp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ale Iesu mo mele verea isara mara, “Tamlohi matea natuna mo rua. ");
INSERT INTO tgp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ale vora hitahu mo verea isan tamana mara, ‘Tata, o sileau hin korum atu sei enia r̃ungaku.’ Ale tamana mo ase na koruna isara tupra rua. ");
INSERT INTO tgp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mo sopo tuai, vora hitahu atu mo takonahi na nona hinahinau tari, ale mo vano vara i hitehite jara, ale mo jalahi vevuhi na nona tavtav na posposi rongorongo vono. ");
INSERT INTO tgp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ale mara mo jalahi vevuhi na nona mania, marua tavera matea mo pala hin jara tavera atu, ale mo vejuveju. ");
INSERT INTO tgp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ale mo vano mo voko isana tamlohi matea hin jara atu, ale tamlohi tavera atu mo r̃ulea vara i vano na isana i vahani na pulana poi. ");
INSERT INTO tgp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ale mo marohati mo tikeli na makina vahatea, ale mo opoia vara i hani te hanhani sei mo lo silea isana poi, pani tea mo sopo silea hin te hanhani. ");
INSERT INTO tgp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pani r̃omina mara mo mele mai, mo hase verea isana mara, ‘Tamlohi voko tari non tamaku, hara hinau mo mar̃ivi savulevule, pani enau na lo marohati mate nike. ");
INSERT INTO tgp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","A pa vano isan tamaku ale a verea isana vara, ‘Tata, na hehe isan tuka peresiho. ");
INSERT INTO tgp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na sopo mele tataholo vara o toviau natum. O vaiau sohena nom volitusi matea.’” ");
INSERT INTO tgp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ale mo turu mo mele vano isan tamana. Pani mo pa lo toho asau, ale tamana mo hitea ale mo r̃omia, ale mo maro vano isana mo rahoa, ale mo pungosia. ");
INSERT INTO tgp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Moiso, natirihi atu mo verea isan tamana mara, ‘Tata, na hehe isan tuka peresiho. Na sopo mele tataholo vara o toviau natum.’ ");
INSERT INTO tgp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pani tamana mo verea isana nona volitusi mara, ‘Ha lavi na noku ruru peravu r̃uhur̃uhu jea i mai ha rua hinia, ale ha tau te ring hatea na varangona, ale sabat na palona. ");
INSERT INTO tgp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ale ha lavi na natu buluk r̃avisvisi atu sei r̃a lo kilau mamahunia ha vilia, ale r̃a hania r̃a avulahi. ");
INSERT INTO tgp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Matan natuku nike mo mate moiso, ale mo mele mauri, mo jalio, ale na mele lavutia!’ Ale la tapulo vai na hanhani tavera na avulahi. ");
INSERT INTO tgp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ale natuna vora tiroma mo lo toho na isa, ale mara mo lo mai mariviti na ima mo rongo na vete, ale la lo velu, ");
INSERT INTO tgp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","moiso mo tovi na volitusi matea ale mo usia mara, ‘Ka lo vai na sava sei?’ ");
INSERT INTO tgp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ale mo verea isana mara, ‘Tasim mo mele pala, ale tamam mo vili pa natu buluk r̃avisvisi atu sei r̃a lo kilau mamahunia matan mo mele pala mo lo r̃uhu.’ ");
INSERT INTO tgp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pani mo lolokoru, ale mo r̃ohu vara i unu na ima. Tamana mo malue mo sinai mo usia vara i unu, ");
INSERT INTO tgp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","pani mo r̃arami tamana mara, ‘Ko hitea, la takonahi tauni nike enau na lo voko mate nom sohena slev matea, ale na sopo lo tope na nom retileu hin te rani, pani ko sopo sileau hin te natu nani hatelete matan vara a er̃i avulahi hinia peresi na tapalaku. ");
INSERT INTO tgp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pani natum akerihi mara mo pala, haratu sei mo lo jalahi vevuhi na korum na har̃ai malele, ale ko vili pa natu buluk r̃avisvis atu sei ko lo kilau mamahunia, matana.’ ");
INSERT INTO tgp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ale tamana mo verea isan natuna atu mara, ‘Natuku, engko ko lo toho peresiau tarea, ale hinau tari noku enira nom. ");
INSERT INTO tgp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mo tataholo vara r̃a vai na hanhani r̃a avulahi matana, matan tasim nike mo mate pani mo mele mauri; mo jalio ale na mele lavutia.’” ");
INSERT INTO tgp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu mo mele verea isana nona tamlohi usuri mara, “Na rani matea tamlohi tavtav matea, mo rongoa vara nona patu tamlohi sei mo lo kilau na nona hinahinau, mo lo roro purongo na nona hinahinau. ");
INSERT INTO tgp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ale mo tovi pa nona patu tamlohi atu, ale mo verea isana mara, ‘Sava nahai na lo rongoa matam? O sileau na nom puku mata kilau na mania matan engko ko isoiso sohena patu tamlohi.’ ");
INSERT INTO tgp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ale patu tamlohi atu mo hase verea isana mara, ‘A pa vai na sava, matan noku tamlohi tavera mo tau nar̃ihiau sohena patu tamlohi matea? Enau na sopo r̃ilar̃ilangi vara a er̃i heli na lepa, ale na mahanuhanu vara a usi na tuetueni. ");
INSERT INTO tgp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ale, na levosahi na sava a pa vaia nake, matan vara i tau nar̃ihiau ale tamlohi la pa avulahi mata laviau na imara.’ ");
INSERT INTO tgp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ale, mo tovi vevuhi la haratu la lo ave isan nona tamlohi tavera la mai matea matea. Ale mo verea isan haratu tiroma mara, ‘Nom ave isan noku tamlohi tavera mo visa?’ ");
INSERT INTO tgp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mara, ‘Na ave na litre wel, mo tari vaha tolu .’ Ale mo verea isana mara, ‘Ale o jarai nar̃ihi na nom ave, ale o ulia vara ko ave mo tari vaha hatea mo ngavulu sangavulu lima .’ ");
INSERT INTO tgp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ale mo verea isana tinapua mara, ‘Nom ave mo visa?’ Ale mo verea mara, ‘Na ave na piri wit, kilo mo tari vaha ngavulu tolu .’ Ale mo verea isana mara, ‘Ale o jarai nar̃ihi na nom ave, ale o ulia vara ko ave na piri wit, kilo mo tari vaha ngavulu rua mo vati .’ ");
INSERT INTO tgp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ale tamlohi tavera atu mo hitea vara nona patu tamlohi atu mo patuha na sava mo vaia, hina purongo vara mo lejileji. Matan tamlohi hin varama nike, enira la patuha na nora bisnis la lo vaira peresi na tamlohi tinapua na varama, mo jeu la haratu la natun malarani. ");
INSERT INTO tgp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ale na lo verea isamim, vara ha vai na nomim hinahinau nike na varama la tueni na tinapua ale ha tapala peresira. Hin malele nike, vara nomim hansohai hin varama nike mo isoiso, pa la tapalamim atu na tuka la pa avulahi hin kamim. ");
INSERT INTO tgp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Haratu mo er̃i turu r̃ilangi na hinau rihirihi purongo, i pa turu r̃ilangi na hinau matuvana, ale haratu mo lejileji na hinau rihirihi matea purongo, i pa lejileji na hinau matuvana. ");
INSERT INTO tgp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ale vara ka sopo er̃i turu r̃ilangi na tavtav matan varama nike, hare i pa er̃i tau na tavtav varar̃uhu na limamim? ");
INSERT INTO tgp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ale vara ka sopo er̃i turu r̃ilangi na hinau nona tinapua, hare i pa er̃i tau te hinau na limamim vara nomim? ");
INSERT INTO tgp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tea i sopo er̃i volitusi isana tamlohi tavera i rua, matan i pa opoi matea, ale i r̃ohu hin matea, teni i pa volitusi isan matea, ale i hitelehilehi matea. Ha sopo er̃i volitusi isan God peresi na mania.” ");
INSERT INTO tgp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee la opoi na mania, ale la haratu la lo toho atu, lara la rongo la hinau sei, la kerehia. ");
INSERT INTO tgp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ale Iesu mo verea isara mara, “Kamim ka la tamlohi atu sei la lo vai tataholoira hasera na naho tamlohi, pani God mo levosahi na mapumim. Matan sava tamlohi la lo r̃omr̃omia vara la aulu, enira hina niketa na nahon God. ");
INSERT INTO tgp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Leu non Moses peresi na sava pr̃ovet la verea la lo turu mo kakau na rani non John tamlohi paptijo, ale mo tapulo atu mo mai nake. Retir̃uhu matan mauri atu God mo aulu hinia, la lo retivujavujangi hinia, ale la lo ngurunguru na tamlohi vara la unu hinia. ");
INSERT INTO tgp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pani i pa mele malum vara tuka peresi na varama la tihai, mo jeu haratu vara tea i jarai nar̃ihi te sope leta hatea na lolo leu, ale suihana i mai hina purongo. ");
INSERT INTO tgp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tamlohi tari sei la r̃ohu hin naroura, ale la lahi na tinapua la vaivaileu, ale haratu sei mo lahi na har̃ai lahi matea mo rovo hin tuana, mo vaivaileu.” ");
INSERT INTO tgp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iesu mara, “Na rani matea tamlohi tavtav matea tarea mo lo ru na perpel peresi na ruru lulu malum, ale mo lo hani na hanhani r̃uhu tarea. ");
INSERT INTO tgp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ale na nona matarua, tamlohi la tau na tamlohi tilavono matea mo solasola vevuhi na epena hijana Lazarus, ");
INSERT INTO tgp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","mara mo lo toho atu tarea mo opoia vara i er̃i hani te sope hanhani na jara hanhani non tamlohi tavtav atu, pani mo vono. Aulu hin haratu, viriu la lo mai la lo r̃amesi na solana. ");
INSERT INTO tgp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hitahu pa tamlohi tilavono atu mo mate, ale angelo la lavi nar̃ihia vara i toho peresi Abraham. Pa tamlohi tavtav atu sohena mo mate, ale la tavunia, ");
INSERT INTO tgp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ale enia mo sivo na jara talai na varama mata mateia, ale na nona rongohaji tavera, ale mo kilau vano mo hite Abraham enia Lazarus la lo turu asau hinia. ");
INSERT INTO tgp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ale mo ulo mara, ‘Pua Abraham, o r̃omopoiau, ale o r̃ule Lazarus vara i vano i weti na pisuna na wai, ale i mai i taua na memeku vara i hamar̃ir̃ia, matan na lo rongohaji hajavua na pepe hapu nike.’ ");
INSERT INTO tgp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pani Abraham mara, ‘Natuku, o to r̃omr̃omia, na maurim, ko lo lavi na hinau r̃uhur̃uhu, pani Lazarus, mo lo lavi na hinau mo sati, pani nake enia mo lo nanau nike, ale engko ko lo lavi na rongohaji. ");
INSERT INTO tgp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ale mo sopo haratu purongo, pani masapa tavera matea mo lo toho na livuhar̃a, ale mo sopo te malele vara tea nike i er̃i vano sei isam, teni tea sei i er̃i mai nike isamam.’ ");
INSERT INTO tgp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ale mara, ‘Vara sohena, na lo tangi isam vara o r̃ulea i sivo na iman tamaku ");
INSERT INTO tgp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","matan enau tasiku mo lima, ale vara i retir̃oar̃oahaira. Vara i vono, enira sohena la pa sinai hin jara nike mata vailejileji na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pani Abraham mara, ‘Retiulia non Moses peresi na pr̃ovet la lo toho isara moiso; mo tataholo vara la tapurongo isara.’ ");
INSERT INTO tgp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ale mara, ‘Mo vono, pua Abraham, vara tea i tai nike na varama mata mateia i sivo isara, la pa posi.’ ");
INSERT INTO tgp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham mo verea isana mara, ‘Vara la sopo tapurongo isan Moses peresi na pr̃ovet, la pa sopo er̃i rasu tea vara i mele turu na varama mata mateia.’” ");
INSERT INTO tgp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ale Iesu mo verea isana nona tamlohi usuri mara, “Hinau vaihite mata hehe la pa lo mai tarea, pani rani sasati isan haratu mo lo lavira la mai. ");
INSERT INTO tgp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","I pa mele r̃uhu jea isana, vara la liho te vatu tavera na r̃alona, ale la pulahia na lolo tasi puaha. Matan i pa mele sati jea isana, vara i vai te vonan la natuvarihi nike la hehe. ");
INSERT INTO tgp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ha hase kilau mamahuni kamim! Vara voraim mo hehe, o reti isana, ale vara mo posi o r̃omia, ");
INSERT INTO tgp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ale vara mo hehe isam vaha limaravrua na rani matea, ale mo mele mai isam vaha limaravrua mo verea isam mara, ‘Na posi!’ o pa r̃omia.” ");
INSERT INTO tgp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nona vahar̃ule la verea isan Moli Iesu lara, “O vai na nomam rasu i tavera!” ");
INSERT INTO tgp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ale Moli Iesu mara, “Hina purongo vara nomim rasu mo sohena piri paka matea purongo, ha er̃i verea isan pulo hatapola nike vara, ‘O hase saputiho, o sivo o lavoho na tasi!’ Ale i pa oloolo hin kamim. ");
INSERT INTO tgp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sava nomim slev matea vara mo isoiso na nona voko na isa teni mo lo kilau na sipsip, i pa mai vara i sakele vahatea mata hanhani? ");
INSERT INTO tgp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ka levosahia vara i pa tatamahuni na hinau hani nona tamlohi tavera, ale i volitusi isana tako, moiso natu i pa hani na hana hinau. ");
INSERT INTO tgp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ale mo sopo te hinau vara nona tamlohi tavera mo sopo vere meje isana, matan enia mo lo vai na sava mo tataholo vara i pa vaia. ");
INSERT INTO tgp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mo sohena purongo, vara ka lo oloolo hiniau, mo tataholo vara ha verea vara, ‘Mo sopo tataholo vara kama lavi na hasohaso isam. Kamam volitusi sei kama lo vai na sava mo tataholo purongo vara kama vaira.’” ");
INSERT INTO tgp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na malelena mo lo vano Jerusalem, mo hahau na livuhan Samaria enia Galilee. ");
INSERT INTO tgp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mara mo lo unu na vanua matea, tamlohi lepros mo sangavulu la lo turu asau, ");
INSERT INTO tgp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","la ulo lara, “Iesu, tamlohi tavera, o r̃omi kamam!” ");
INSERT INTO tgp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mara mo hitera, mo verea isara mara, “Ha vano, ha vujangi kamim isana pr̃is.” Na rani la pa lo vano, lepros atu mo tihai na epera. ");
INSERT INTO tgp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Moiso vonara matea mara mo hitea vara mo vokevoke, mo mele hilu isan Iesu mo lo ulo aulu mo lo hasohaso God. ");
INSERT INTO tgp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mo jovi na nahona sivo na palon Iesu mo vere meje isan Iesu mata sava mo vaia isana, tamlohi akerihi enia mara Samaria matea. ");
INSERT INTO tgp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu mo usia isana mara, “Avei, na r̃om vara kamim tupu sangavulu? Tupu limaravati la haipu? ");
INSERT INTO tgp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tavasau akerihi hasena purongo mo mele hilu vara i sile na hasohaso isan God?” ");
INSERT INTO tgp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ale Iesu mo verea isan tamlohi atu mara, “O turu, o vano. Nom rasua mo vaiho ko r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na rani matea Pharisee la usi Iesu lara mauri atu God mo aulu hinia i pa mai pangisa. Ale Iesu mo r̃aramira mara, “Mauri atu God mo aulu hinia i pa sopo mai na matamata tavera vara ha er̃i hitera, ");
INSERT INTO tgp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","teni ha pa er̃i verea vara, ‘Ha kilau mai, enia nahai!’ teni ‘Enia sevano!’ matan mauri atu God mo aulu hinia mo lo toho na livuhamim.” ");
INSERT INTO tgp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ale mo verea isana nona tamlohi usuri mara, “Pongi matea mo lo mai ha pa marohati vara ha hite te rani hatea non Natun Tamlohi, pani ha pa sopo er̃i hitea. ");
INSERT INTO tgp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ale tamlohi la pa verea isamim vara, ‘Ha kilau vano, enia sevano!’ teni ‘Ha kilau mai, enia nahai!’ Pani ha sopo malue teni ha usurira. ");
INSERT INTO tgp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Matan sohena vaha mo vilasi na tavalu masapa mo vano na tavaluna, i pa sohena natu isan Natun Tamlohi na nona rani. ");
INSERT INTO tgp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pani tiromana enia i pa lavi na rani r̃ilangi matuvana, ale pina nike nake la pa tipahia. ");
INSERT INTO tgp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sava mo masese na pongi non Noah i pa sohena na rani non Natun Tamlohi. ");
INSERT INTO tgp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tuai tamlohi la lo hanhani, la lo inu, la lo lahi, ale la lo silesilera mata lahi mo tikeli rani atu Noah mo unu na aka. Ale wai tatave mo maro ale mauri tamlohi tari la sopo juri. ");
INSERT INTO tgp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","I pa sohena natu, sohen na pongi non Lot, tamlohi la lo hanhani, la lo inu, la lo volvoli, la lo ar̃ear̃ehi, la lo lalavo ale la lo voro na ima — ");
INSERT INTO tgp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","pani hin rani atu Lot mara mo malue Sodom, hapu peresi na vatu tutuni mata volkeno mo jovi na tuka sivo isara, ale enira mo isoiso la mate. ");
INSERT INTO tgp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ale i pa sohen haratu natu na rani Natun Tamlohi i pala. ");
INSERT INTO tgp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Hin rani atu, vara tea mo lo toho na jingoima, ale vara te nona hinahinau la lo toho na lolo ima, i pa sopo sivo vara i tau mamahunira, ale i pa sohena isan haratu mo lo toho na isa, i pa sopo posi vara i sivo na ima. ");
INSERT INTO tgp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ha to r̃omr̃omi naroun Lot! ");
INSERT INTO tgp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sava tamlohi mo opoia vara i hase juri na maurina, i pa vaitihaia, pani sava tamlohi mo vaitihai na maurina, i pa taurilatia. ");
INSERT INTO tgp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na verea isamim vara, hin vutepongi atu tamlohi mo rua la pa lo juruvi na vata matea, ale la pa lavi nar̃ihi matea, matea purongo i pa lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Har̃ai i rua la pa lo pete kosakosahi na piri wit jara matea, ale la pa lavi nar̃ihi matea, ale matea purongo i pa lo toho atu.” ");
INSERT INTO tgp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","37","Moiso nona tamlohi usuri la usia lara, “Moli la hinau sei la pa masese epu?” Mo r̃aramira mara, “Vara ko hite na karai la lo avu vano hin te jara, o pa levosahia vara pahai matea mo mena atu.” ");
INSERT INTO tgp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ale Iesu mo vere na titileu matea isara vara i vujangira vara la pa lo usiusi tarea, ale vara r̃omira la sopo jovi na sava la usia. ");
INSERT INTO tgp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mo verea mara, “Na taon tavera matea, tamlohi aria matea mo lo toho ea, mo sopo matahuni God teni vara i sile na oloolo isan te tamlohi tinapua hatea. ");
INSERT INTO tgp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ale har̃ai malepu matea sohena mo lo toho atu, mo lo mai tarea mo lo usia isana mara ‘O sile na talai mo tataholo vara noku meresahi i lavia.’ ");
INSERT INTO tgp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tiroma mo lo r̃ohu hinia, pani hitahu mo hase verea isana mara, ‘Hina purongo vara na sopo matahuni God teni a sile na oloolo isan tea, ");
INSERT INTO tgp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pani matan har̃ai malepu akerihi tarea mo lo areau mo sopo te isoisona, a pa silea na sava mo lo usia matan vara i sopo mele hotiau hinia.’” ");
INSERT INTO tgp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ale Moli mo mele verea mara, “Ha tapurongo na sava tamlohi ari hehe atu mo lo verea. ");
INSERT INTO tgp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ale ka r̃om vara God i pa sopo er̃i sile na sava sei nona tapuhi la lo usia isana tarea? ");
INSERT INTO tgp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na verea isamim, enia i pa sile na talai mo tataholo vara nora meresahi la lavia i vila purongo. Hina purongo hin haratu, vara Natun Tamlohi i mele mai, i pa vilei te rasua na varama teni i vono?” ");
INSERT INTO tgp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ale mo mele vere titileu akerihi isan la haratu sei la lo hase r̃omr̃omia vara enira la tataholo na nahon God, ale la lo hitelehilehi na tinapua: ");
INSERT INTO tgp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tamlohi mo rua la lo toho na lolo Temple, ale la lo usiusi, matea enia Pharisee matea, ale haratu matea enia tamlohi mata lavi na mania mata takis matea. ");
INSERT INTO tgp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee atu mo turu atu mo lo hase usiusi matana hasena mara, ‘God, na vere meje isam matan enau na sopo sohena tamlohi tinapua, haratu la lo ngurunguru mata mania, haratu la hehe, haratu la lo vaivaileu peresi na tinapua mo lahi moiso, teni sohen tamlohi mata lavi na mania mata takis akerihi. ");
INSERT INTO tgp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Enau na tapuhoro na hanhani vaha rua na wik matea; tarea na lo sile na sangavulu hinau tari na lo lavira.’ ");
INSERT INTO tgp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pani tamlohi mata lavi na mania mata takis atu mo turu asau, mo sopo er̃i tahe na matana i kilau sahe na tuka, pani mo vilivili na r̃umana mo verea mara, ‘God, o r̃omopoiau, enau tamlohi hehe matea!’ ");
INSERT INTO tgp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Varar̃uhu na verea isamim vara tamlohi akerihi mo mele mule mo tataholo na nahon God, pani mo sopo haratu matea. Matan tamlohi tari sei la lo hase tahera, God i pa taura la sivo atano, pani haratu mo hase tau atano God i pa tahea sahe aulu.” ");
INSERT INTO tgp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na rani matea, tama natuvarihi hai peresi na tinara la lavi na natura la mai isan Iesu vara i tau na limana hinira, ale i ler̃uhu hinira. Pani nona tamlohi usuri la tapulo horora. ");
INSERT INTO tgp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pani Iesu mo tovira vara la mai isana, ale mo verea isana nona tamlohi usuri mara, “Ha tinar̃ihi na natuvarihi la mai isaku, ha sopo horora! Matan mauri atu God mo aulu hinia enia nona tamlohi sohen la harihi. ");
INSERT INTO tgp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Varar̃uhu na verea isamim, vara sava tamlohi mo sopo lavi mauri atu God mo aulu hinia sohena natirihi matea, i pa sopo er̃i unu hinia hin te rani.” ");
INSERT INTO tgp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ale na rani matea tamlohi aulu matea mo usia isana mara, “Tija r̃uhu, a pa vai na sava natu vara a er̃i lavi na mauri tui hinia?” ");
INSERT INTO tgp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ale Iesu mo verea isana mara, “Mata sava ko toviau r̃uhu? God hasena mo r̃uhu, mo sopo mele te tamlohi tinapua i r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ko levosahi na retileu, ‘O sopo vaivaileu peresi na tinapua mo lahi moiso, o sopo vilimatei, o sopo vavanaho, o sopo tuetueni na halu, o oloolo hin tamam enia tinam’.” ");
INSERT INTO tgp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ale tamlohi aulu atu mo verea mara, “La hinau tari sei na tapulo vaira na pa lo uluvou purongo.” ");
INSERT INTO tgp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu mara mo rongoa, mo verea isana mara, “Hinau matea ko vejuveju hinia. O ar̃ehi vevuhi na nom hinahinau, ale o asea isana tilavono, ale hitahu tavtav na tuka i pa nom; ale o mai o usuriau!” ");
INSERT INTO tgp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pani tamlohi atu mara mo rongo la hinau sei mo rongo mo sati tavera, matan enia tamlohi tavtav tavera matea. ");
INSERT INTO tgp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu mara mo hitea vara mo rongo mo sati, mo verea mara, “Mo r̃ilangi hajavua vara tamlohi tavtav la unu hin mauri atu God mo aulu hinia! ");
INSERT INTO tgp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A pa verea vara mo mele malum jea vara camel matea i unu na koko niteli matea, mo jeu haratu vara tamlohi tavtav matea i unu hin mauri atu God supe hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ale la haratu la lo rongo la reti atu lara, “Avei, vara mo sohena, sava tamlohi natu i pa er̃i juri?” ");
INSERT INTO tgp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Pani mo verea isara mara, “Sava tamlohi la sopo er̃i vaira, God i er̃i vaira.” ");
INSERT INTO tgp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ale Peter mara, “Ko hitea, kama tinar̃ihi vevuhi na imamam ale kama usuriho.” ");
INSERT INTO tgp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ale Iesu mo verea isana mara, “Varar̃uhu na verea isamim, mo sopo te tamlohi hatea vara i tinar̃ihi na imana, teni narouna, teni te voraina, teni tamana enia tinana, teni natuna matan mauri atu God mo aulu hinia, ");
INSERT INTO tgp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","vara God i pa sopo volia nake na varama, i jeu na sava mo tinar̃ihira moiso, ale hitahu i pa lavi na mauri tui hin pongi atu mo lo mai.” ");
INSERT INTO tgp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ale Iesu mo tovi matavuhi la nona tupu sangavulu r̃omana mo rua atu, ale mo verea isara mara, “Ka levosahia vara r̃a lo sahe Jerusalem. Ale hinau tari sei pr̃ovet la ulia matan Natun Tamlohi la pa masese atu. ");
INSERT INTO tgp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Matan la pa silea i vano na liman la haratu la tamlohi r̃or̃oha, ale la pa kerehia, la pa vai na hina mahanuhanu isana, ale la litovia. ");
INSERT INTO tgp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ale la pa rupia na asi maja, moiso la pa vilimateia, ale na hatolu rani i pa mele turu.” ");
INSERT INTO tgp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pani la sopo levosahi te hinau hatea sei mo lo verea isara. La reti atu God mo jarohira isara, ale la sopo rongovosahi na sava mo lo verea. ");
INSERT INTO tgp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mara mo lo mai mariviti Jericho, tamlohi matavuso matea mo lo sakele na pahisa malele, mo lo usi na tuetueni. ");
INSERT INTO tgp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ale mara mo rongo na roroa vao tamlohi la lo hahau na pahisana, mo usia mara sava natu. ");
INSERT INTO tgp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","La verea isana lara, “Iesu mara Nazareth mo lo hahau roto jara nike.” ");
INSERT INTO tgp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ale mo ulo aulu mara, “Iesu, natun supe David, o r̃omopoiau!” ");
INSERT INTO tgp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ale la haratu la lo toho na nahona, la reti isana lara i toho malum. Pani mo mele ulo aulu mo r̃ilangi jea mara, “Natun David, o r̃omopoiau!” ");
INSERT INTO tgp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ale Iesu mo turu mo retileu mara la lavia i mai isana. Ale mara mo mai mariviti isana, mo usia isana mara, ");
INSERT INTO tgp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ko opoi vara a vai na sava isam?” Mo verea mara, “Moli, o tinar̃ihia vara a mele kilau.” ");
INSERT INTO tgp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ale Iesu mo verea isana mara, “O mele kilau, nom rasua mo vaiho ko r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ale vahatea purongo, mo mele kilau, ale mo usuria mo lo tahe na hijan God. Ale tamlohi tari lara la hitea, enira sohena la hasohaso God. ");
INSERT INTO tgp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu mo unu Jericho, ale mo lo vano vara i hahau roto jara atu. ");
INSERT INTO tgp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hin jara atu tamlohi matea hijana Zacchaeus, enia patu tamlohi matea mata lavi na mania mata takis, ale enia mo tavtav. ");
INSERT INTO tgp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Enia mo lo vaihitea vara i hite Iesu, matan enia pejulana matea purongo, ale vao atu la lo turuhoroa. ");
INSERT INTO tgp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ale matana, mo maro mo vano tiroma mo vele aulu na pulo sycamore matea vara i er̃i hitea, matan i pa sopo tuai Iesu i pa hahau hin malele atu. ");
INSERT INTO tgp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ale Iesu mara mo tikeli jara atu, mo tar̃a sahe, ale mo verea isana mara, “Zacchaeus, o vila. O sevuti matan a pa toho na imam nohorihi.” ");
INSERT INTO tgp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ale mo jurete vilavila sivo atano, ale mo avulahi tavera vara i lavia. ");
INSERT INTO tgp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ale tamlohi lara la hitea, la reti vavarihi lara, “Eh, mo lo vano vara i toho na ima tamlohi hehe matea.” ");
INSERT INTO tgp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ale Zacchaeus mo turu na naho tamlohi atu mo verea isan Moli mara, “Ko hitea Moli, nakerihi a pa sile na sope noku hinahinau isana tilavono. Ale vara na halu tea hin te hinau, a pa mele silea isana i aulu vaha vati!” ");
INSERT INTO tgp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ale Iesu mo verea isana mara, “Nahapani, juri mo mai hin ima nike, matan enia sohena enia natun Abraham matea. ");
INSERT INTO tgp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Matan Natun Tamlohi mo sinai vara i ale la haratu la jalio ale i jurira.” ");
INSERT INTO tgp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tamlohi lara la lo tapurongo hin la hinau nike, ale matan Iesu mo lo mai mariviti Jerusalem, mo tapulo vere na titileu matea isara, matan la lo r̃omr̃omia lara mariviti vara God i turu na suihana natu, ");
INSERT INTO tgp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","matan haratu mo verea isara mara, “Tamlohi aulu matea mo vano na jara asau tinapua matea, vara i tauri na suiha mata supe ea, ale mara i pa mele mai. ");
INSERT INTO tgp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pani tiromana, mo tovi na nona volitusi tupu sangavulu vara la mai isana, ale mo silera na selen mo tataholo na volvoli mata rani voko mo ngavulu sangavulu isara hatehateahi, ale mo verea isara mara, ‘Ha lavi mania akerihi; ha vavahinau peresia i tikeli rani atu vara a mele pala.’ ");
INSERT INTO tgp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pani nona tamlohi la r̃ohu hinia, moiso la r̃ule na tamlohi hai la lo usuria vara la vere vara, ‘Kama sopo opoia vara tamlohi nike i supe hin kamam.’ ");
INSERT INTO tgp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pani pa tamlohi aulu atu, mo vano mo tauri na suiha hin jara tinapua atu, moiso mo mele hilu mai na jarana. Ale mo tovi la nona volitusi atu, sei mo lo silera na mania matan mo opoia vara i levosahia vara la vai na sava hin mania atu mo lo silea isara. Mo opoia vara i levosahia vara la mele lavi na mania mo visa aulu hin haratu mo lo silea isara. ");
INSERT INTO tgp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tiromara mo mai, mo turu na nahona mo verea mara, ‘Moli na nom mania na mele vai mo vaha sangavulu tinapua hinia.’ ");
INSERT INTO tgp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ale mo verea isana mara, ‘Ko vaia mo r̃uhu jea, ko volitusi r̃uhu matea. Matan ko kilau mamahuni hinau rihirihi sei na taua na limam; ale a pa tauho vara o pa aulu na taon tavera i sangavulu.’ ");
INSERT INTO tgp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Harua tamlohi mo mai, mo verea mara, ‘Tamlohi tavera, na nom mania na mele vai mo vaha lima tinapua hinia.’ ");
INSERT INTO tgp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ale supe atu mo verea isana mara, ‘Ale engko o pa aulu na taon tavera i lima.’ ");
INSERT INTO tgp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Moiso mele volitusi tinapua matea mo mai mo verea mara, ‘Tamlohi tavera, nom mania nahai. Na jarohi mamahunia na tavalu ruru matea vara i lo toho r̃uhu hinia. ");
INSERT INTO tgp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Matan na matahuniho matan engko tamlohi r̃ilangi matea. Matan ko lo lavi na hinau tamlohi tinapua mo lo taua, ale ko lo vu na isa engko ko sopo lavoa.’ ");
INSERT INTO tgp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Supe atu mo verea isana mara, ‘Engko volitusi lejileji sati matea! A pa ariho usuri na nom retireti. Ko levosahia moiso vara enau tamlohi r̃ilangi matea, ale vara na lo lavi na hinau tamlohi tinapua mo lo taua, ale na lo vu na isa na sopo lavoa. ");
INSERT INTO tgp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mata sava ko sopo tau na noku mania na bank matan vara a mele mai a er̃i lavi noku mania sei peresi haratu bank mo lo vaia noku?’ ");
INSERT INTO tgp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ale mo verea isan la nona volitusi atu sei la lo turu mariviti atu mara, ‘Ha lavi nar̃ihi na mania isana, ha silea isan haratu mo lavi mo sangavulu!’ ");
INSERT INTO tgp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pani la verea isana lara, ‘Pani enia mo lavi mo sangavulu moiso!’ ");
INSERT INTO tgp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Supe atu mo verea mara, ‘Na verea isamim vara tamlohi tari sei la lo tauri te hinau moiso, la pa mele silea isara i aulu hin haratu la lo tauria tiroma. Pani isan la haratu la sopo tauri te hinau, la pa lavi nar̃ihi na sava la lo taurira moiso. ");
INSERT INTO tgp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pani isan la noku meresahi nike, sei la r̃ohu vara a nora supe; ha lavira la mai nike, ale ha vilimateira na nahoku.’” ");
INSERT INTO tgp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ale Iesu mara mo vere la hinau atu mo isoiso, mo mele vano na malelena, mo vele mo sahe Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iesu mara mo pa lo mai mariviti na taon matan Bethphage enia Bethany hin vutivuti atu sei la tovia Vuti talu Olive, mo r̃ule na nona tamlohi usuri mo rua la vano la tiroma hinira, ");
INSERT INTO tgp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","mara, “Ha vano, ha unu hin vanua sei na nahomim, ale vara ka lo unu, ha pa hite na natu donki matea la pesia mo lo turu atu; tea mo sopo lo vele i sakele hinia hin te rani. Ha uli nar̃ihia ale ha lavia i mai. ");
INSERT INTO tgp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Vara tea mo usia vara, ‘Mata sava ka lo uli nar̃ihia?’ Ha pa verea sohen harihi vara, ‘Moli mo opoia.’” ");
INSERT INTO tgp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ale la vano la tapai natu donki atu sohen Iesu mo lo verea isara. ");
INSERT INTO tgp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ale la pa lo uli nar̃ihia, tavuina mo usia isara mara, “Mata sava ka lo uli nar̃ihi natu donki sei?” ");
INSERT INTO tgp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ale lara, “Moli mo opoia.” ");
INSERT INTO tgp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ale la lavia mo mai isan Iesu, ale la vur̃angi na nora ruru tavera na har̃ina, ale la vai Iesu mo sakele hinia. ");
INSERT INTO tgp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ale mara mo lo hahau hinia mo lo vano, la pulahi na nora ruru na malele. ");
INSERT INTO tgp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ale Iesu mara mo lo mai mariviti hin jara atu na malele mo lo tapulo sevuti na Vuti talu Olive, vao nona tamlohi usuri la tapulo lalavete, ale la lo hasohaso God na leo tavera matea, mata sava vavahinau mata suiha la hitera moiso lara, ");
INSERT INTO tgp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Avulahi isan supe atu mo lo mai na hijan Moli. Tamata i toho na tuka ale oloolo tavera i vano isan God Aulu Jea!” ");
INSERT INTO tgp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pani tatua Pharisee hin vao atu la verea isan Iesu lara, “Tija, o reti isana nom tamlohi usuri mata sava la lo verea.” ");
INSERT INTO tgp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu mo r̃aramira mara, “Varar̃uhu na verea isamim, vara la toho malum, la vatu nike, la pa ulo aulu!” ");
INSERT INTO tgp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu mara mo pa lo mai mariviti ale mo hite taon tavera atu Jerusalem, mo tangisia, ");
INSERT INTO tgp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","mara, “Tahisaku, vara o pa lo levosahi na nom rohi hin rani akerihi, o pa hite na tamata, pani nakerihi, God mo vusohi na matam moiso. ");
INSERT INTO tgp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Matan i pa sopo tuai nomim meresahi la pa voro na vor̃a r̃alihiho, matan vara la pa piruho na jara tari. ");
INSERT INTO tgp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","La pa viliroiroiho, engko peresi na natum vahatea na lolo ropem, la pa ase vevuhi na vatu vor̃am tari matan ko sopo hitevosahi na rani God mo rohiho.” ");
INSERT INTO tgp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Moiso, Iesu mo unu na rope Temple, ale mo lo tapulo levuti nar̃ihi la haratu la lo ar̃ear̃ehi hinia, ");
INSERT INTO tgp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ale mo verea isara mara, “La ulia vara, ‘Imaku enia ima mata usiusi’, pani kamim ka vaia mo mai ‘jara luhu nona tamlohi vili na tamlohi mata vavanaho matea’.” ");
INSERT INTO tgp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hitahun haratu, na rani hatehateahi Iesu mo lo vujangi na lolo Temple. Tamlohi aulu nona pr̃is, tamlohi vujangi mata leu peresi na patu tamlohi tinapua hai, la aleale malele vara la vilimateia hinia, ");
INSERT INTO tgp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","pani la sopo hite te malele matan tamlohi tari la pa lo marohati hajavua mata nona retireti. ");
INSERT INTO tgp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na rani matea, Iesu mo pa lo vujangi na tamlohi na lolo Temple na retivujavujangi mata Retir̃uhu, ale tamlohi aulu nona pr̃is peresi na tamlohi vujangi mata leu, peresi na vajiahan Israel la mai isana, ");
INSERT INTO tgp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ale la verea isana lara, “O to vere kamam hinia, vara sava suiha nahai, ko lo vai la hinau nike hinia, teni ko lo vai la hinau nike na suihan hare?” ");
INSERT INTO tgp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mo r̃aramira mara, “Enau sohena, a pa usi kamim na retiusia matea, ale ha to verea isaku vara ");
INSERT INTO tgp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","paptijo non John mo tai na tuka teni isana tamlohi?” ");
INSERT INTO tgp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Moiso la sorasorahia isara lara, “Vara r̃a verea vara, ‘Mo tai na tuka!’ enia i pa verea vara ‘Mata sava ka sopo rasua?’ ");
INSERT INTO tgp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pani vara r̃a verea vara, ‘Isana tamlohi!’ tamlohi tari la pa parumateir̃a matan la r̃om vara John enia pr̃ovet matea.” ");
INSERT INTO tgp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ale matana la r̃aramia lara, “Kama sopo levosahia vara mo tai epu.” ");
INSERT INTO tgp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ale Iesu mo verea isara mara, “Vara sohena, enau sohena a pa sopo er̃i vere kamim hinia vara na lo vai la hinau nike na suihan hare.” ");
INSERT INTO tgp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ale, Iesu mo tapulo vere na tamlohi hin titileu akerihi mara, “Tamlohi tavera matea mo lavo na isa grape matea, ale tamlohi la lo pakaia isana. Ale enia mo vano na jara tinapua mo toho mo peravu ea. ");
INSERT INTO tgp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na rani asitauni mo mai, mo r̃ule na nona volitusi matea mo vano vara i lavi te vua asitauni isara. Pani la tamlohi atu la tamajia, ale la r̃ulea mo vano lekoleko. ");
INSERT INTO tgp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ale tamlohi tavera atu mo mele r̃ule na volitusi tinapua matea, pani la mele tamajia la vailejlejia, ale la mele r̃ulea mo vano lekoleko. ");
INSERT INTO tgp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ale tamlohi tavera atu, mo mele r̃ule na hatolura. Enia sohena la vili kitkitia, ale la tipahia. ");
INSERT INTO tgp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pa tamlohi tavera matan isa grape atu mara, ‘A pa vai na sava natu? Na levosahia, a pa r̃ule natuku r̃uhur̃uhu nike; korong la pa oloolo hinia.’ ");
INSERT INTO tgp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pani la tamlohi atu lara la hitea la hase verea isara lara, ‘Avei korong natuna nahai, r̃a vilimateia matan koruna i pa nor̃a.’ ");
INSERT INTO tgp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ale la pulahi nar̃ihia hin isa atu ale la vilimateia.” Ale Iesu mo usira mara, “Ka levosahia vara tamlohi tavera matan isa grape atu i pa vai na sava isan la tamlohi atu? ");
INSERT INTO tgp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I pa mai i vaikomokomora, ale i mele sile isa grape sei isan te tamlohi tinapua.” La tamlohi tavera atu lara la rongo la reti atu lara, “I pa sopo sohen haratu!” ");
INSERT INTO tgp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pani Iesu mo kilau vano tataholo isara mo verea mara, “Vara mo vono, r̃aramin reti sei la ulia tuai enia sava lara, ‘Vatu atu, tamlohi voro na ima la tipahia mo mai pulo vatu atu mata ima’? ");
INSERT INTO tgp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tamlohi tari vara la tialahalaha hin vatu atu, vatu atu i pa putputira, ale vara i jovi hin tea i pa lomolomoa.” ");
INSERT INTO tgp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tamlohi vujangi mata leu peresi na tamlohi aulu nona pr̃is la aleale malele vara la taurilatia hin rani atu purongo, matan la rongovosahia vara Iesu mo lo verea titileu atu matara, pani la matahuni na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Moiso la lo kilau r̃or̃ohia, ale la r̃ule hai vara la usuri r̃or̃ohia la lo tiasia vara i vere te hinau la er̃i taurilatia matana, ale la er̃i taua na lima tamlohi aulu matan Rome matana. ");
INSERT INTO tgp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Matan haratu, la usia lara, “Tija, kama levosahia vara nom reti peresi na nom vujangi la tataholo, ale ko sopo tametame tea, pani tarea ko lo vujangi na malele varar̃uhu non God. ");
INSERT INTO tgp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kama opoia vara kama usiho na retiusia matea. Mo tataholo vara kama sile na takis isan Supe nona mara Rome teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pani Iesu mo levosahi na nora halu, ale mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ha vujangiau hin te selen hatea mata takis. Niniun hare nakerihi, ale sava uliuli nahai hinia?” Lara, “Non Supe nona mara Rome.” ");
INSERT INTO tgp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iesu mo verea isara, “Vara sohena, ha sile Supe nona mara Rome na sava enia nona, ale isan God na sava enia non God.” ");
INSERT INTO tgp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ale la tamlohi atu la sopo er̃i pisuhia hin te hinau mo lo verea na naho tamlohi, pani la mar̃urahi tavera na nona r̃arami reti, ale la lo turu tapanono. ");
INSERT INTO tgp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadducee hai la mai isana, enira vao matea la sopo rasua vara God i pa sauteterahi na tamlohi, ");
INSERT INTO tgp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ale la usi na retiusia matea isana lara, “Tija, Moses mo ulia mara vara vorai tamlohi matea mo mate, enia narouna matea pani mo sopo te natuna, tamlohi atu i pa lavi na malepun voraina ale i pa tape te natun voraina. ");
INSERT INTO tgp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ale na rani matea, vorai mo limaravrua la lo toho. Vora tiroma mo lavi na narouna matea, ale mo mate mo sopo te natuna. ");
INSERT INTO tgp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ale vora usuria mo pete lavia, ");
INSERT INTO tgp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","moiso hatolura mo mele lavia, ale la tupu limaravrua atu la mate enira mo isoiso, pani la sopo tape te natuvarihi. ");
INSERT INTO tgp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hitahuna har̃ai atu mo mate. ");
INSERT INTO tgp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hin rani atu vara God i sauteterahi na tamlohi, har̃ai atu i pa naroun hare? O to verea isamam, matan enira tupu limaravrua la lahi hinia!” ");
INSERT INTO tgp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ale Iesu mo verea isara mara, “Nake na varama, tamlohi la lo lahi, ale la lo sile na har̃ai mata lahi, ");
INSERT INTO tgp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","pani la haratu God mo hitea vara la tataholo mata turu na sauteterahi na mateia mata unu hin pongi atu mo lo mai, enira la pa sopo lahi teni tea i pa sopo silera mata lahi, ");
INSERT INTO tgp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","matan la pa sopo er̃i mele mate hin te rani matan enira la pa sohena angelo, la natun God matan enira la natun sauteterahi atu. ");
INSERT INTO tgp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pani usuri r̃omr̃omi atu sei vara tamlohi la pa mele turu na mateia teni mo vono, Moses sohena mo ulia na Retiulia, sei mo verea hin rani atu God mo retireti isana hin vipahai atu mo lo pepe, Moses mo tovi Moli God mara, ‘God non Abraham, God non Isaac ale God non Jacob’. ");
INSERT INTO tgp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God enia mo sopo God nona tamlohi mate, pani nona tamlohi mauri, matan isana, tamlohi tari la lo mauri.” ");
INSERT INTO tgp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Moiso tatua tamlohi vujangi mata leu la r̃aramia lara, “Tija, ko verea ko varar̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mo sopo te vonara hatea i mele opoia vara i usia hin te retiusia hatea. ");
INSERT INTO tgp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pani Iesu mo mele verea isara mara, “Mo sohena sava natu la pa verea vara Kr̃isto enia natun supe David? ");
INSERT INTO tgp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Matan David hasena mo verea na puku non psalms mara, ‘Moli God mo verea isan noku Moli mara: O sakele na matuaku, ");
INSERT INTO tgp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","vavano a vai na nom meresahi la mai la toho na ruhuruhu palom.’ ");
INSERT INTO tgp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David mo tovia Moli, sohena sava natu enia mo pa natuna?” ");
INSERT INTO tgp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ale na peron vao atu la lo tapurongo mo verea isana nona tamlohi usuri mara, ");
INSERT INTO tgp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ha lo kilau mata tamlohi vujangi mata leu, sei la lo opoia vara la lo hahau r̃alihi peresi na ruru peravu mata hapahapa, ale la opoia vara la lo lavi na retioloolo na naho tamlohi na jara maket, ale la opoi na jara sakele la taura mata tamlohi aulu na ima lotu, ale la opoia vara la lo sakele na jara sakele nona tamlohi sei la tovira mata mai na hanhani tavera, ");
INSERT INTO tgp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ale ha lo kilau mata nora halu sei la lo lavi nar̃ihi na hinahinau tari nona har̃ai malepu hinia, ale la lo tavuhoro na nora vavahinau na usiusi peravu. La pa lavi na talai tavera i jeu na tinapua.” ");
INSERT INTO tgp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu mo kilau vano mo hite na tamlohi tavtav, la lo tau na nora silesilea na jara silesilea na lolo Temple. ");
INSERT INTO tgp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ale mo hite na har̃ai malepu tilavono matea, mo tau na selen mo rua. ");
INSERT INTO tgp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ale mo verea mara, “Varar̃uhu na verea isamim, har̃ai malepu tilavono nike mo taua mo jeu na tamlohi tavtav mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Matan sava la silea mo malue na nora tavtav tavera, pani sava enia mo silea, mo malue na nona tilavono, mo tau vevuhi na sava sei vara i pa er̃i tueni na maurina.” ");
INSERT INTO tgp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ale, la pa lo vereverea vara Temple atu mo r̃uhu sohena sava, ale sohena sava la tau mamahuni na vatu r̃uhur̃uhu hinia, ale sohena sava tamlohi hai la sile na silesilea r̃uhur̃uhu mata lakolakoa hinira, ale Iesu mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“La hinau sei ka lo hitera, pongi matea mo lo mai vara i pa sopo mele te vatu hatea, i lo sakele aulu na vatu tinapua sei matan la pa atu jovjovira.” ");
INSERT INTO tgp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ale la usia isana lara, “Tija, pangisa natu la hinau sei la pa masese, ale sava matamata natu i pa vujangia vara mariviti natu vara la hinau atu la pa masese?” ");
INSERT INTO tgp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ale mo verea mara, “Ha sopo tinar̃ihia vara tea i tikauleji kamim! Matan tamlohi matuvana la pa mai na hijaku lara, ‘Enau natu, Kr̃isto!’ ale ‘Nake natu nona rani pala mo lo mai mariviti!’ Pani ha sopo usurira! ");
INSERT INTO tgp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ale vara ka rongo vara jara tavera la lo vai na vuro, ale vara la lo vuro na lolo jarara hasera, ha sopo matahu matan la hinau atu, la pa masese tiroma, ale pongi hitahu, i pa sopo mai vahatea.” ");
INSERT INTO tgp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iesu mo mele verea isara mara, “Mara jara tavera tinatinapu la pa meresahi hinira, ale supe matea i pa meresahi na supe tinapua. ");
INSERT INTO tgp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mihi tavera la pa hisu na jara tinatinapua, ale marua peresi na rojoa tavera la pa vili na jara tinatinapua. Ale ha pa hite na hinau matahu tavera peresi na matamata tavera aulu na masapa. ");
INSERT INTO tgp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pani tiroma, hin la hinau nike, tamlohi la pa taurilati kamim, ale la pa tipahi kamim, la pa sile kamim isan la haratu la lo kilau na ima lotu peresi na ima r̃ilangi, ale la pa lavi kamim la turuhi kamim na naho supe peresi na patu tamlohi, matan ka lo lavi na hijaku. ");
INSERT INTO tgp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Enia masapa matea vara ha pa er̃i vereuliau na naho tamlohi. ");
INSERT INTO tgp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ha lo levosahia nake vara, ha sopo matahu vara ha pa r̃aramira sohena sava, ");
INSERT INTO tgp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","matan enau a pa sile kamim na reti tataholo, vara ha pa verera isana nomim meresahi, ale la pa sopo er̃i r̃aramira teni la er̃i verea vara ka lo halu. ");
INSERT INTO tgp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tamamim peresi na tinamim, voraimim, tahisamim peresi na tapalamim, enira sohena, la pa tau te vonamim vara la pa vilimateira. ");
INSERT INTO tgp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tamlohi tari la pa r̃ohu hin kamim mata hijaku. ");
INSERT INTO tgp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pani te vulumim hatea na patumim i pa sopo er̃i tihai purongo. ");
INSERT INTO tgp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mauri tui i pa nomim mata nomim turu r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pani vara ka hite na tamlohi vuro la r̃alihi Jerusalem, ka levosahia vara nona pongi maroi mo pala natu. ");
INSERT INTO tgp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ale la haratu la lo toho Judea, la pa rovo la sahe na vutivuti, ale la haratu la lo toho na lolon taon tavera atu la malue, ale ha pa horo la haratu la lo toho r̃alihi taon tavera atu vara la sopo unu hinia, ");
INSERT INTO tgp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","matan harihi, enira rani mata talai tavera matan vara sava la ulira moiso la pa masese. ");
INSERT INTO tgp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","I pa mele sati jea isana har̃ai sei la epe puhoni, teni la haratu la pa lo susui na natura. Matan rani sasati tavera na varama peresi na lolokoru tavera non God mata hehe, i pa jovi isan la tamlohi nike. ");
INSERT INTO tgp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","La pa vilimateira na sita vuro, ale la pa tiroma hinira sohena slev la vano na jara tinatinapua na varama. Ale la haratu la tamlohi r̃or̃oha, la pa varasi Jerusalem i tikeli isoiso rani atu sei God mo taua na limara moiso. ");
INSERT INTO tgp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ale matamata la pa pala na alo, na vitu peresi na vitusarasara. Ale na varama, tamlohi na jara tinatinapua la pa r̃omkaka tavera mata roroa tasi peresi na loloputuna. ");
INSERT INTO tgp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tamlohi la pa matemate mata nora matahu peresi na sava la levosahia vara la pa masese usuri na hinau la pa mai na varama, matan suiha la lo tauri na tuka peresi na masapa la pa malue na jarara. ");
INSERT INTO tgp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Moiso natu tamlohi tari la pa hite Natun Tamlohi i pala na telangi na suihana peresi na merana tavera. ");
INSERT INTO tgp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ale vara la hinau atu la lo lavi na jara, ha turu tataholo ha tar̃a sahe aulu matan nomim jujuri mo lo mai mariviti.” ");
INSERT INTO tgp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Moiso, Iesu mo verera na titileu matea mara, “Ha kilau usuri na pulo fig peresi na pulo pahai tari tinatinapua, ");
INSERT INTO tgp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","vara la tapulo sohai na perera ka hitevosahia vara taro alo mo lo mai mariviti moiso. ");
INSERT INTO tgp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ale mo sohena purongo, vara ka hite la hinau sei la lo mai, ka levosahia vara mauri atu God mo aulu hinia, mo lo mai mariviti. ");
INSERT INTO tgp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Varar̃uhu na verea isamim vara pina nike i pa sopo lo tihai vevuhi vavano hinau tari la masese. ");
INSERT INTO tgp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tuka peresi varama la pa tihai, pani noku retireti la pa sopo er̃i tihai. ");
INSERT INTO tgp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pani ha lo kilau! Mo sopo r̃uhu vara a tapai kamim ka lo toho purongo, teni ka lo drong, teni nomim r̃omkaka la lo taurilati kamim. Ha sopo tinar̃ihia vara pongi atu i pala isamim i sar̃umahi kamim. ");
INSERT INTO tgp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Matan i pa sar̃umahi na tamlohi tari la lo toho na varama. ");
INSERT INTO tgp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pani tarea ha lo kilau, ha lo usiusi vara ha pa er̃i jelu hin la hinau tari sei la pa masese, ale ha pa er̃i turu na nahon Natun Tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Rani tarea, Iesu mo lo vano mo lo vujangi na lolo Temple; moiso na ravravi mo lo hilu mo lo sahe na Vuti talu Olive, ale mo lo toho ea na vutepongi. ");
INSERT INTO tgp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ale na r̃alavuho jea, tamlohi tari la lo mai isana na Temple vara la tapurongo isana. ");
INSERT INTO tgp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hanhani tavera mata pereti atu mo sopo te isi hinia mo lo mai, haratu la tovia Passover. ");
INSERT INTO tgp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ale tamlohi aulu nona pr̃is peresi na tamlohi vujangi mata leu, la lo aleale malele vara la pa vilimatei Iesu hinia, matan la matahu vara la vaia na naho tamlohi. ");
INSERT INTO tgp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ale Setan mo sohoni Judas Iscariot, vonara matea hin la tupu sangavulu r̃omana mo rua atu. ");
INSERT INTO tgp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mo malue mo vano mo sorasora peresi na tamlohi aulu nona pr̃is peresi na patu police mata Temple. Matan la pa verea vara i pa turuposi hinia sohena sava matan vara i pa taua na limara. ");
INSERT INTO tgp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ale la avulahi, la hatihia vara la pa sile te mania isana. ");
INSERT INTO tgp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ale matana mo majinga hinia, moiso mo aleale masapa vara i pa turuposi hinia, vara i er̃i taua na limara hin te jara, mo sopo te vao tamlohi hinia. ");
INSERT INTO tgp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Moiso rani mata pereti sei mo sopo te isi hinia mo pala, enia rani atu la lo sile na natu sipsip mata Passover sohena malamalai isan God. ");
INSERT INTO tgp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Matana, Iesu mo r̃ule Peter enia John mara, “Ha vano ha tatamahu mata nor̃a hanhani mata Passover vara r̃a er̃i hania.” ");
INSERT INTO tgp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","La usia isana lara, “Ko opoia vara kama pa tatamahunia epu?” ");
INSERT INTO tgp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mo verea isara mara, “Ha tapurongo, vara ka lo unu na taon tavera, ha pa tapai na tamlohi matea mo lo utu na jara wai tavera matea. Ha usuria ha unu hin ima atu enia mo unu hinia, ");
INSERT INTO tgp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ale ha verea isan tamlohi tavera mata ima atu vara, ‘Tija mo verea isam mara, “Nene jara mata matavuhi na imam sei vara a er̃i hani na hanhani mata Passover peresi na noku tamlohi usuri ea?’” ");
INSERT INTO tgp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ale i pa vujangi kamim na jara tavera matea aulu na imana sei mo tatamahunia moiso, ha tatamahu atu.” ");
INSERT INTO tgp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ale la malue la vano la hitea mo tataholo sohen mo verea isara, ale la tatamahu mata Passover atu. ");
INSERT INTO tgp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ale aoa matan hanhani atu mo tataholo, Iesu mo sakele na jara hanhani na tep moiso, ale nona vahar̃ule la lo toho peresia. ");
INSERT INTO tgp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ale mo verea isara mara, “Na opoia mo tavera jea vara a hani Passover nike peresi kamim, moiso a pa lavi na rongohaji tavera. ");
INSERT INTO tgp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Matan na verea isamim, vara a pa sopo mele hania vavano i tikeli rani atu hinau tari la masese hin mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ale mo lavi na paniken matea ale mara mo vere meje moiso mo verea mara, “Ha lavia, ha asea isamim ha inua. ");
INSERT INTO tgp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Matan na verea isamim, vara a pa sopo mele inu waen akerihi vavano i tikeli rani atu, mauri atu God mo aulu hinia i mai.” ");
INSERT INTO tgp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Moiso, mo lavi na pereti, ale mara mo vere meje moiso, mo topetopea mo silea isara mara, “Harihi enia epeku sei na silea matamim. Ha lo vaia sohena mata r̃omr̃omiau hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ale lara la hanhani moiso, mo mele vaia sohena hin paniken waen atu mara, “Paniken nike, na lo sureia matamim, enia retitauhi paro sei na lo vaia na r̃aeku. ");
INSERT INTO tgp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pani ha tapurongo, haratu sei i pa turuposi hiniau, mo lo sahara na hanhani na tep peresiau nakerihi. ");
INSERT INTO tgp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Matan Natun Tamlohi i pa vano i usuri na masalon God, pani rani sasati isan haratu sei mo turuposi hinia.” ");
INSERT INTO tgp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Moiso, enira mo isoiso la tapulo usiusia isara hatehateahi vara sava tamlohi isara natu i pa vai hinau atu. ");
INSERT INTO tgp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pani mo sopo tuai, vauriuri matea mo malue isara vara hare natu enia i pa aulu hin mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ale Iesu mo verea isara mara, “Hin varama nike supe nona tamlohi r̃or̃oha la aulu na nora tamlohi peresi la haratu suiha mo lo toho na limara, ale la lo retileu isara tarea vara la vai na masalora, pani hina purongo vara la lo toho na ruhuruhura, la lo tovira lara ‘Tuetueni nona tamlohi’. ");
INSERT INTO tgp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pani i pa sopo sohena isamim: haratu enia mo opoia vara i aulu i jeu na tinapua, i pa hase taua atano sohena vora hitahu matea, ale haratu mo opoia vara i tiroma na tamlohi, i pa mai i lo volitusi. ");
INSERT INTO tgp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hare natu enia tamlohi tavera? Haratu mo sakele na tep teni haratu mo volitusi isana? Enia haratu mo sakele na tep. Pani enau na lo mai isamim sohena volitusi matea. ");
INSERT INTO tgp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kamim natu, ka lo toho peresiau na noku rani r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Matan haratu, na lo silea isamim sohen Tamaku mo silea isaku vara, ha pa aulu sohena supe, ");
INSERT INTO tgp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","matan vara ha pa hanhani ale ha inu na noku tep na rani vara na lo tauri na suiha, ale ha pa sakele na jara sakele nona supe mata ari la tavtavui tupu sangavulu r̃omana mo rua atu non Israel. ");
INSERT INTO tgp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, o lo levosahia vara Setan mo usia r̃ilangi vara i pa laviho matan vara i hutehutehiho sohena tamlohi mo lo asehi na piri wit, ");
INSERT INTO tgp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","pani na usiusi moiso matam matan vara nom rasua i pa sopo jovi, ale hin rani atu sei ko mele posi, o pa tueni na voraim vara la turu r̃ilangi.” ");
INSERT INTO tgp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter mo verea isana mara, “Moli, enau na tatamahu vara a vano peresiho na ima r̃ilangi, teni a mate matam.” ");
INSERT INTO tgp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu mo verea mara, “Varar̃uhu na verea isam Peter, toa i sopo lo tarere nohorihi vavano, i tikeli rani atu ko vunvunia vaha tolu vara ko sopo levosahiau.” ");
INSERT INTO tgp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ale Iesu mo verea isara mara, “Hin rani atu sei na r̃ule kamim ka vano ka sopo lavi te tanga korohi teni te tanga, teni te sabat — ka vejuveju hin te hinau teni mo vono?” Lara, “Mo vono.” ");
INSERT INTO tgp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mo verea isara mara, “Pani nake natu, haratu vara te nona tanga korohi teni te tanga i pa lavia. Ale haratu mo sopo lo te nona sita vuro, i pa ar̃ehi na nona ruru hamariri, ale i voli te hatea. ");
INSERT INTO tgp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Matan na verea isamim vara Retitapu nike i pa masese hiniau sei mo vara, ‘La evia peresi la haratu la lo tope na leu’. Matan sava la ulia mataku i pa masese.” ");
INSERT INTO tgp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ale la verea lara, “Eh Moli, sita vuro mo rua nahai moiso!” Ale mo verea mara, “Mo isoiso natu.” ");
INSERT INTO tgp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ale mo malue hin ima atu mo mele vano na Vuti talu Olive sohen mo lo vaia tarea, ale nona tamlohi usuri la usuria. ");
INSERT INTO tgp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ale mara mo kakau jara atu mo verea isara mara, “Ha usiusi matan vara ha pa sopo jovi na vaihite.” ");
INSERT INTO tgp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ale mo hahau vano makomona, mo papaohi atano, ale mo usiusi ");
INSERT INTO tgp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","mara, “Tata, vara ko opoia, o er̃i lavi nar̃ihi na noku rani r̃ilangi nakerihi, pani o sopo vai na masaloku, pani o vai na masalom purongo.” ");
INSERT INTO tgp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ale angelo matea mo pala isana mo tuenia vara i mele r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ale na nona r̃om sati tavera mo usiusi mo mele r̃ilangi jea; ale masmasuna mo hoi peresi na r̃ae mo tuturu sivo na lepa. ");
INSERT INTO tgp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ale mo mele turu na nona usiusi mo mai isana nona tamlohi usuri, mo hitera la juruvi r̃omaliho, matan la malokoloko tavera, matan r̃omira mo sati na sava i pa masese, ");
INSERT INTO tgp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ale mo verea isara mara, “Ka lo juruvi mata sava? Ha turu, ha usiusi matan vara ha pa sopo jovi na vaihite.” ");
INSERT INTO tgp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ale Iesu mo pa lo retireti, vao tavera matea mo pala, ale pa tamlohi atu sei la tovia Judas, enia vonara matea hin la tupu sangavulu r̃omana mo rua atu, mo lo tiroma hin vao atu, mo mai mariviti isan Iesu vara i pungosia, ");
INSERT INTO tgp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","pani Iesu mo verea isana mara, “Judas, o pa turuposi hin Natun Tamlohi na pungosi matea?” ");
INSERT INTO tgp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ale la haratu la lo toho r̃alihia, lara la hitevosahi na sava i pa masese lara, “Avei Moli, r̃a taira na sita vuro teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ale vonara matea mo langa nar̃ihi na peron volitusi non pr̃is aulu. ");
INSERT INTO tgp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pani Iesu mara, “Ha isoiso!” ale mo tikeli na perona, ale mo mele sor̃oa vano na patuna. ");
INSERT INTO tgp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Moiso, Iesu mo verea isana tamlohi aulu nona pr̃is peresi na police mata Temple, peresi na vajiahara sei la mai matana mara, “Ka mai peresi na sita vuro peresi na maja sohen ka lo vano mata taurilati na tamlohi vili na tamlohi mata vavanaho matea? ");
INSERT INTO tgp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tarea na lo toho peresi kamim na lolo Temple pani ka sopo taurilatiau. Pani nakerihi enia nomim rani peresi na rani non suihan r̃or̃oha.” ");
INSERT INTO tgp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Moiso la taurilatia, la tiroma hinia la malue la vano na iman pr̃is aulu, ale Peter mo lo usurira asau makomona. ");
INSERT INTO tgp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ale lara la vai na hapu matea na livuha jara na lolon rope ima atu moiso, la sakele r̃alihia ale Peter mo vano mo sakele peresira. ");
INSERT INTO tgp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Moiso, volitusi har̃arihi matea mara mo hite Peter mo lo sakele atu, mo mele kilau mamahunia mara, “Tamlohi nike sohena, mo lo toho peresi Iesu.” ");
INSERT INTO tgp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pani Peter mo vunvunia mara, “Har̃ai, na sopo levosahia.” ");
INSERT INTO tgp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ale moiso, tamlohi tinapua matea mo hitea mo mele verea mara, “Engko vonara matea.” Pani Peter mo verea mara, “Tapala, enau mo vono.” ");
INSERT INTO tgp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ale korong mele aoa matea mo vano moiso, tamlohi tinapua matea mo mele verea mara, “Varar̃uhu sei, tamlohi nike enia mo lo toho peresia, matan enia mara Galilee matea.” ");
INSERT INTO tgp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pani Peter mara, “Tapala, na sopo levosahi na sava ko lo verea.” Ale mo pa lo verea toa mo tarere. ");
INSERT INTO tgp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ale Moli mo posi mo kilau vano isan Peter, ale Peter mo mele r̃omr̃omi na sava Moli mo verea isana mara, “Toa i sopo lo tarere, o pa vunvuniau vaha tolu.” ");
INSERT INTO tgp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ale mo malue mo sahe na jingoima mo tangi huruhuru. ");
INSERT INTO tgp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ale la haratu la lo taurilati Iesu la tamajia, ale la lo kerehia. ");
INSERT INTO tgp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","La pesihoro na matana ale la lo usia hinia lara, “O to retimangovi! Hare natu mo tutuiho?” ");
INSERT INTO tgp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ale la mele vere na hinau sati tinapua matuvana isana, ale la lo kalia. ");
INSERT INTO tgp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mara mo rani sahe, matavuhi nona vajiahara la pulutahi peresi na tamlohi aulu nona pr̃is peresi na tamlohi vujangi mata leu. Ale la haratu la lo taurilatia la tiroma hinia mo vano isan nora matavuhi atu, ale la verea isana lara, ");
INSERT INTO tgp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Vara engko natu, Kr̃isto atu, o verea isamam!” Pani mo verea isara mara, “Vara a verea isamim, ha pa sopo rasua, ");
INSERT INTO tgp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ale vara a usi kamim hin te retiusia, ha pa sopo r̃aramiau. ");
INSERT INTO tgp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pani mo tapulo nake natu, Natun Tamlohi i pa sakele na tavalu suihan God.” ");
INSERT INTO tgp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ale matana, enira mo isoiso lara, “Engko natun God teni mo vono?” Moiso mo verea isara mara, “Ka pete verea moiso, enau natu.” ");
INSERT INTO tgp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Moiso, la verea lara, “R̃a pa mele opoi na sava vereulia tinapua! R̃a rongoa mo pete hase verea moiso vara enia Natun God.” ");
INSERT INTO tgp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Moiso enira mo isoiso la turu, ale la lavi Iesu mo vano isan Pilate. ");
INSERT INTO tgp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","La tapulo tuvaia lara, “Kama hite tamlohi nike mo lo tikauleji na nomam tamlohi, ale mo lo horo kamam vara kama sopo sile te takis isan supe matan Rome, ale enia mo lo verea vara enia natu, Kr̃isto, supe atu sei i pa mai.” ");
INSERT INTO tgp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ale Pilate mo usia isana mara, “Engko Supe nona Jew?” Ale mo r̃aramia mara, “Engko ko verea moiso.” ");
INSERT INTO tgp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Moiso Pilate mo verea isana tamlohi aulu nona pr̃is peresi vao tavera atu mara, “Na sopo vilei te hehe hin tamlohi nike.” ");
INSERT INTO tgp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pani la verea toho hinia mo r̃ilangi lara, “Enia mo vai na tamlohi la lo usuri na r̃omina, mo vujangira na jara tari Judea mo tapulo Galilee mo sinai mo kau nike.” ");
INSERT INTO tgp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate mara mo rongoa sohena, mo usia mara enia mara Galilee matea teni. ");
INSERT INTO tgp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ale Pilate mara mo levosahia vara Iesu mo tai na jara Galilee mo lo toho na ruhuruhun Herod, mo r̃ulea mo vano isana matan mo lo toho Jerusalem hin rani atu. ");
INSERT INTO tgp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na rani Herod mara mo hite Iesu, mo avulahi tavera matan tuai moiso, mo opoia vara i hitea matan mo lo rongo na sorasorahina, ale mo lo r̃omtau vara i pa hite Iesu i vai te matamata. ");
INSERT INTO tgp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ale mo usia na retiusia mo usia mo tuai, pani Iesu mo sopo r̃aramira. ");
INSERT INTO tgp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tamlohi aulu nona pr̃is peresi na tamlohi vujangi mata leu la lo turu na pahisana, la lo tuvaia mo r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ale Herod peresi na nona tamlohi vuro, la vaisatihia na nora retireti, ale la kerehia. Moiso la rua na ruru r̃uhur̃uhu, la r̃ulea mo mele vano isan Pilate. ");
INSERT INTO tgp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hin rani atu purongo, Herod mo tapala peresi Pilate. Pani tiroma enira tupra rua la meresahi. ");
INSERT INTO tgp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Moiso Pilate mo tovi matavuhi na tamlohi aulu nona pr̃is peresi na tamlohi aulu non Israel peresi na tamlohi, ");
INSERT INTO tgp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ale mo verea isara mara, “Ka lavi tamlohi nike mo mai isaku, ale ka verea vara enia mo lo tikauleji na tamlohi. Ale nara na kilau usuri na sava ka lo verea matana moiso, ale ha levosahia vara na sopo vileia vara tamlohi nike mo ori hin te hinau hatea sei ka lo tuvaia hinia. ");
INSERT INTO tgp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod sohena, mo sopo vilei te hinau, matan enia mo mele r̃ulea mai isar̃a. Ka hitea, mo sopo vai te hinau vara i pa mate matana. ");
INSERT INTO tgp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Matana, a pa sile na talai matea isana, moiso a pa tinar̃ihia vara i vano.” ");
INSERT INTO tgp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Pani la ulo enira mo isoiso vahatea lara, “O vilimatei tamlohi sei! Ale o sile Barabbas isamam!” ");
INSERT INTO tgp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas enia tamlohi matea la pulahia na ima r̃ilangi matan mo lo tiroma na tamlohi mata valum hin taon tavera atu, ale matan mo lo vilimatei na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate mo mele sile na retireti isara matan mo opoia vara i tinar̃ihi Iesu, ");
INSERT INTO tgp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","pani la lo ulo toho lara, “Ha vosaea na talopeilopei! Ha vosaea na talopeilopei!” ");
INSERT INTO tgp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ale Pilate mo mele sile na nona hatolu reti isara mara, “Mata sava? Mo vai na sava mo sati? Enau na sopo vilei te hinau vara i pa mate matana. Ale matana, a pa sile na talai matea isana moiso a tinar̃ihia vara i vano.” ");
INSERT INTO tgp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pani la lo ulo toho isana la lo usia lara la vosaea na talopeilopei. Ale nora reti mo vili na reti non Pilate. ");
INSERT INTO tgp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Matana, Pilate mo tinar̃ihia vara sava la usia i pa sohena. ");
INSERT INTO tgp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Matan la usia, mo tinar̃ihi pa tamlohi atu sei mo lo taua na ima r̃ilangi matan mo lo tiroma na tamlohi mata valum, ale matan enia mo lo vilimatei na tamlohi, pani mo sile Iesu vara i vano na masalora. ");
INSERT INTO tgp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ale la pa lo tiroma hinia mo lo malue, la taurilati na tamlohi matea hijana Simon mara Cyrene, enia mo tai asau r̃ove na jara vutivuti, ale la tau na talopeilopei isana matan vara i solotia, ale mo usuri Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ale vao tavera jea nona tamlohi peresi na har̃ai la lo tangisia, la lo tangtangi, ale la lo usuria. ");
INSERT INTO tgp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pani Iesu mo verea isara mara, “La venatun Jerusalem, ha sopo tangisiau, pani ha tangisi kamim hasemim peresi na natumim. ");
INSERT INTO tgp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Matan ha lo levosahia vara rani matea mo lo mai sei la pa verea vara, ‘Avulahi isana har̃ai aroaro, ale isan haratu la sopo tatape, ale isan la haratu la sopo lo vasusu hin te rani.’ ");
INSERT INTO tgp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hin rani atu, ‘Tamlohi la pa tangi isana vutivuti lara — ha jovjovi isamam! Ale isana pesapesa la pa verea lara — ha tavuni kamam!’ ");
INSERT INTO tgp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Matan vara, vara la vai la hinau nike na rani r̃uhu sei vipahai la lo ulua mo r̃uhu, i pa sohena sava hin rani atu mo koru?” ");
INSERT INTO tgp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tamlohi tinapua mo rua sei la tamlohi sasati, la tiromara la vano matan vara la pa vilimateira peresi Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ale lara la kakau jara atu sei la tovia ‘Sui Patu Tamlohi’ la vosaea hin jara atu na talopeilopei peresi la tamlohi sasati atu, matea na matuana, ale matea na marauna. ");
INSERT INTO tgp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ale Iesu mara, “Tata, o r̃omira matan la sopo levosahi na sava la lo vaia!” Ale tamlohi vuro atu la vai na roro matea mata hitea vara hare natu i pa lavi te nona ruru. ");
INSERT INTO tgp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tamlohi la lo turu atu, la lo kilaua, pani tamlohi aulu natu la lo kerehia lara, “Enia mo juri na tinapua! I to hase juria vara enia natu, Kr̃isto non God, hara sei God mo vir̃onia!” ");
INSERT INTO tgp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tamlohi vuro atu sohena la lo kerehia, la mai isana la sile na waen hohona isana vara i inua, ");
INSERT INTO tgp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ale lara, “Vara engko Supe nona Jew, o hase juriho!” ");
INSERT INTO tgp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","La uli na uliuli matea la taua aulu hinia, mo verea vara, Harihi Enia Supe Nona Jew ");
INSERT INTO tgp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Vonara matea hin la tamlohi sasati mo rua atu, la lo sevu na pahisana, mo kerehi Iesu mara, “Engko Kr̃isto atu teni mo vono? O hase juriho, ale o juri kamam!” ");
INSERT INTO tgp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pani tamlohi sasati tinapua atu matea mo merusahia mara, “Eh, ko sopo matahuni God? Ko sopo levosahia vara enr̃a r̃a lo toho na ruhuruhu talai nike peresia? ");
INSERT INTO tgp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Enr̃a mo tataholo vara r̃a lavia, matan enr̃a r̃a lavi na volvoli tataholo mata nor̃a vavahinau, pani tamlohi nike mo sopo vai te hina sati.” ");
INSERT INTO tgp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ale mo verea isan Iesu mara, “Iesu, o lo r̃omr̃omiau hin rani atu vara ko tauri na nom suiha mata supe.” ");
INSERT INTO tgp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ale Iesu mo verea isana mara, “Varar̃uhu, na verea isam, engko o pa toho peresiau hin jara avulahi atu Paradise nohorihi.” ");
INSERT INTO tgp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Matan alo mo sangavulu r̃omana mo rua na rani tavera, ale r̃or̃oha tavera mo tahavuni jara tavera atu mo tikeli na matan alo mo tolu na ravravi ");
INSERT INTO tgp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","matan mera alo mo tihai. Ale ruru tavera atu mo lo horo na jara tapu mo tapu jea na lolo Temple, mo mar̃ari mo rua. ");
INSERT INTO tgp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Moiso Iesu mo ulo aulu mara, “Tata, na tau na mauriku na limam!” Mara mo verea moiso maromarona mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ale captain mata tamlohi vuro mara mo hite la hinau sei la lo masese, mo hasohaso God mo verea mara, “Varar̃uhu. Tamlohi nike mo sopo vai te hina sati hatea.” ");
INSERT INTO tgp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ale vao tamlohi tari atu sei la lo pulutahi mata hite hinau akerihi, lara la hite la hinau sei la masese, la mule peresi na tangtangi tavera. ");
INSERT INTO tgp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ale tapalana tari, peresi la har̃ai atu sei la tapulo usuria Galilee, la lo turu asau makomona, la lo kilau la hinau akerihi. ");
INSERT INTO tgp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ale tamlohi matea hijana Joseph mo lo toho atu, mo tai na taon nona Jew la tovia Arimathea. Enia vonara matea na lolo council tavera non Israel, pani enia tamlohi r̃uhu matea posina mo tataholo, ");
INSERT INTO tgp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ale enia mo sopo avulahi na sava la hatihia teni na sava la vaira, enia mo tai Arimathea na jaran Judea, ale enia mo lo kilau matan rani atu God i pa tauri na suiha hinia. ");
INSERT INTO tgp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tamlohi atu mo vano vara i hite Pilate matan vara i usi na tarapen Iesu. ");
INSERT INTO tgp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mo juria sivo atano, ale mo viriviria na ruru lulu r̃uhu matea mata mate, ale mo taua na taptap matea la taia na pesapesa, ale mo sopo lo te tarape i juruvi hinia hin te rani. ");
INSERT INTO tgp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Rani atu enia Rani mata Tatamahu nona Jew, ale mariviti Sabbath i tapulo. ");
INSERT INTO tgp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","La har̃ai sei la lo usuria la tai Galilee la usuria vara la hitea vara la pa taua na sava taptap, ale la pa hitea vara la pa tau na tarapena sohena sava. ");
INSERT INTO tgp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Moiso, la mele mule, ale la tatamahuni na lai ponaha r̃uhu peresi na hasori mata taua na tarapena. Na Sabbath la mapu usuri na retileu non Moses. ");
INSERT INTO tgp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pani na Sunday na r̃alavuho jea, pa la har̃ai atu la vano na taptap, la lavi na lai ponaha r̃uhu sei la tatamahunira moiso. ");
INSERT INTO tgp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ale lara la kau na taptap la hite vatu tavera atu mata matarua la kuresi nar̃ihia moiso, ");
INSERT INTO tgp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","pani lara la unu la sopo hite na tarapen Moli Iesu, ");
INSERT INTO tgp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","r̃omira mo pa lo tihai, ale la pa hutura purongo, tamlohi mo rua la lo turu na pahisara, nora ruru la memera tavera. ");
INSERT INTO tgp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ale la matahu tavera, la popovi na nahora atano na lepa, ale la tamlohi atu la verea isara lara, “Mata sava ka lo ale na tamlohi mauri na jara mate? ");
INSERT INTO tgp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Enia mo sopo toho nike, pani mo mele turu moiso. Ka lo r̃omr̃omi na sava mo verea isamim hin rani atu mo pa lo toho Galilee, ");
INSERT INTO tgp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","mara Natun Tamlohi i pa vano na lima tamlohi sasati matan vara la pa vosaea na talopeilopei, ale i pa mele turu na hatolu rani.” ");
INSERT INTO tgp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ale la pa mele r̃omr̃omi na nona retireti, ");
INSERT INTO tgp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ale la malue na taptap la vano la vere na hinau tari isan la tupu sangavulu r̃omana matea atu, peresi la haratu la lo toho peresira. ");
INSERT INTO tgp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ale Mary Magdalene, Joanna, Mary tinan James peresi na har̃ai tinapua hai sei la lo toho peresira, enira natu la vere la hinau sei isan la vahar̃ule atu. ");
INSERT INTO tgp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pani la rongoa sohena sorasora rongorongo vono matea, ale la sopo rasura. ");
INSERT INTO tgp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pani Peter mo turu mo maro mo vano na taptap, mo riorio sivo mo hite na tavalu ruru lulu purongo la pa lo toho atu, ale mo mele mule mo mar̃urahi tavera na sava mo masese. ");
INSERT INTO tgp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tataholo hin rani atu, tamlohi mo rua isara, la lo vano na vanuan Emmaus, mariviti kilometre i sangavulu r̃omana matea hin Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ale la lo sorahi na hinau tari sei la masese Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","La pa lo retireti la lo sorahia, Iesu mo mai mo hahau peresira. ");
INSERT INTO tgp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pani la sopo hitevosahia matan God mo horora. ");
INSERT INTO tgp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ale mo verea isara mara, “Avei, sava sei ka lo sorahia na nomim hahau?” La turu vahatea ale nahora mo vujangia vara r̃omira mo sati. ");
INSERT INTO tgp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ale vonara matea, hijana Cleopas mo r̃aramia mara, “Avei, korong engko hasem purongo sei ko rohi Jerusalem, ale ko sopo levosahi na sava mo masese hin la rani akerihi sei la vano moiso?” ");
INSERT INTO tgp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ale Iesu mo verea isara mara, “Sava hinau natu?” Ale la verea isana lara, “Hinau la vaia isan Iesu mara Nazareth, enia pr̃ovet sei nona retireti peresi na suihana la r̃uhur̃uhu jea na nahon God, peresi na tamlohi tari. ");
INSERT INTO tgp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ale sohena sava nomam tamlohi aulu nona pr̃is peresi na tamlohi aulu la taua na liman Pilate, vara i sile na talai isana mata mate, ale la vosaea na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pani kama lo r̃omtoho vara enia natu, haratu sei i pa juri Israel. Pani mo sopo haratu purongo, nahapani enia hatolu rani usuri la hinau sei la masese. ");
INSERT INTO tgp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ale aulu hin haratu, nomam har̃ai hai, la vai kamam kama mar̃urahi jea. Enira la lo toho na tapuna na r̃alavuho jea. ");
INSERT INTO tgp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ale lara la sopo hite na tarapena, ale la mele hilu mai, la verea isamam vara la hite na angelo hai, ale la verea isara vara mo mele mauri. ");
INSERT INTO tgp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tatuamam la rongoa la vano na tapuna vara la hitea, ale la hitea mo tataholo sohen haratu la har̃ai atu la lo verea, ale la hitea varar̃uhu tarapen Iesu mo tihai.” ");
INSERT INTO tgp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ale Iesu mo verea isara mara, “Ka tamlohi rongorongo vono! Mapumim la r̃ilangi mata rasu na hinau tari pr̃ovet la verea moiso! ");
INSERT INTO tgp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mo mera purongo na sava la ulia lara Kr̃isto i pa lavi na rongohaji tiroma, moiso i pa lavi na hasohasona tavera.” ");
INSERT INTO tgp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ale Iesu mo tapulo vereuli na hinau tari sei Moses peresi na pr̃ovet la ulira na jara tari na Retitapu sei la vereulia vara maurina i pa sohena sava. ");
INSERT INTO tgp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ale lara la lo mai mariviti hin vanua atu sei la lo hahau matana, Iesu mo lo hahau o hitea sohena vara i pa jeu vanua atu, ");
INSERT INTO tgp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","pani la verea r̃ilangi isana lara, “O lo toho peresi kamam matan mo ravravi moiso, ale alo mo sakele na vuti moiso.” Ale mo usurira, mo lo toho peresira. ");
INSERT INTO tgp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","La sakele na tep, ale mo lavi na pereti mo ler̃uhu hinia, mo topea, moiso mo silea isara. ");
INSERT INTO tgp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ale vahatea purongo, matara la roi la hitevosahia, ale mo tihai isara. ");
INSERT INTO tgp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","La verea isara hasera lara, “Varar̃uhu sei matan mapur̃a la avulahi jea na rani Iesu mo lo retireti peresir̃a na malele sei mo vai na Retiulia la roi isara?” ");
INSERT INTO tgp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ale la turu vahatea la hilu, la mele vano Jerusalem, la tapai la tupu sangavulu r̃omana matea atu peresi la haratu la lo toho peresira la lo pulutahi na jara matea. ");
INSERT INTO tgp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ale la verea isan la tupra rua atu lara, “Varar̃uhu, Moli mo mele turu, mo pala isan Simon Peter moiso!” ");
INSERT INTO tgp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Moiso la tupra rua atu la pete vere na sava mo masese na malele, ale sohena sava la pa hitevosahia na rani mo tope na pereti. ");
INSERT INTO tgp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","La pa lo sorahi la hinau sei, Iesu mo turu na livuhara, mo verea isara mara, “Tamata i toho isamim!” ");
INSERT INTO tgp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pani la hutura hinia, la matahu tavera matan la r̃om vara la hite na tanume matea. ");
INSERT INTO tgp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Moiso mo verea isara mara, “Ka matahu mata sava? Ale r̃omkaka mo malue na mapumim mata sava? ");
INSERT INTO tgp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ha hite na limaku peresi na paloku vara enau varar̃uhu nahai. Ha tikeliau, ale ha levosahia, matan tanume mo sopo te epena soheku sohen ka lo hitea.” ");
INSERT INTO tgp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ale mara mo verea moiso, mo vujangi na limana peresi na palona isara. ");
INSERT INTO tgp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ale la sopo lo rasu na sava la hitera matan la mar̃urahi tavera hinia, ale mo verea isara mara, “Avei, te hanhani nike?” ");
INSERT INTO tgp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ale la silea na tavalu maji matea mo noha na wai tutuni, ");
INSERT INTO tgp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ale mo lavia mo hania na nahora. ");
INSERT INTO tgp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ale Iesu mo verea isara mara, “Reti nike enira noku reti sei na pete verea moiso isamim hin rani atu na pa lo toho peresi kamim, vara hinau tari sei la ulia na Leu non Moses peresi na Retiulia nona pr̃ovet peresi na puku non psalms la pa masese.” ");
INSERT INTO tgp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Moiso mo vai na r̃omira la roi matan vara la er̃i rongovosahi na Retitapu, ");
INSERT INTO tgp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ale mo verea isara mara, “La ulia sohen harihi lara, Kr̃isto i pa lavi na rongohaji moiso i mate, ale na hatolu rani i pa mele turu na mateia, ");
INSERT INTO tgp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ale la pa retivujavujangi na posi mata hehe, ale God i pa r̃omi na nora hehe na hijan Kr̃isto, la pa retivujavujangia i vano isana tamlohi mara jara tinatinapua tari i tapulo Jerusalem i vano. ");
INSERT INTO tgp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamim ka hite la hinau sei na matamim. ");
INSERT INTO tgp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ale ha levosahia vara na lo r̃ule na Tanume Tapu usuri na retitauhi non Tamaku isamim. Pani ha lo toho Jerusalem i tikeli rani atu suiha aulu matan na tuka i jovi hin kamim.” ");
INSERT INTO tgp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Moiso mo tiromara la malue la vano la tikeli Bethany, ale mo tahe na limana mo ler̃uhu hinira. ");
INSERT INTO tgp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mo pa lo ler̃uhu hinira, God mo lavi nar̃ihia mo sahe aulu na tuka. ");
INSERT INTO tgp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ale la lotua, la mele hilu la vano Jerusalem peresi na avulahi tavera, ");
INSERT INTO tgp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ale la vano la lo toho tarea na Temple mata hasohaso God ea. ");
INSERT INTO tgp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tuai tiroma, Reti atu mo pete toho moiso. Mo lo toho peresi God, ale Reti sei enia God tataholo. ");
INSERT INTO tgp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tuai tiroma, enia mo lo toho peresi God, ");
INSERT INTO tgp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ale hinia, God mo vai na hinau tari, mo sopo te hinau hatea vara mo sopo vaia hinia. ");
INSERT INTO tgp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pulo mauri mo lo toho isana. Mauri atu enia mo lavi na malarani mo mai isana tamlohi. ");
INSERT INTO tgp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Malarani atu mo sasarami na r̃or̃oha. R̃or̃oha atu mo sopo er̃i turuhoroa. ");
INSERT INTO tgp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God mo r̃ule na tamlohi matea mo mai, hijana John. ");
INSERT INTO tgp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Enia mo mai mo sohena tuetueni matea vara i vereuli na tamlohi hin malarani atu. Mo verea matan vara tamlohi tari la pa rasu malarani atu. ");
INSERT INTO tgp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tuetueni atu enia mo sopo malarani atu, pani enia mo mai vara i vereuli malarani atu. ");
INSERT INTO tgp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Malarani atu mo mai na varama, enia mo malarani varar̃uhu. Malarani varar̃uhu atu mo sile na malarani vara tamlohi tari la pa levosahia. ");
INSERT INTO tgp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hina purongo vara God mo vai na varama hinia, pani varama mo sopo hitevosahia. ");
INSERT INTO tgp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mo mai na nona varama, isan la tavtavuina tataholo, pani la r̃ohu hinia. ");
INSERT INTO tgp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pani isan la haratu la lavia, la rasu na hijana, ale enia mo tinar̃ihira vara enira la pa er̃i mai natun God. ");
INSERT INTO tgp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","La mai natun God mata masalon God hasena. La sopo mai natun God na posposi tamlohi mo vora teni na masalo tamlohi. ");
INSERT INTO tgp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Reti sei mo mai tamlohi, mo lo toho peresir̃a. Kama hite na hina r̃uhur̃uhu matuvana na maurina moiso, hina r̃uhur̃uhu matuvana non haratu hasena enia mo tai isan Tama, enia pulo r̃omr̃uhu, ale enia pulo retivarar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John mo ulo aulu mara, “Hara sei natu, na lo verea vara i pa mai hitahu hiniau, enia mo aulu hiniau, matan enia mo lo toho tiroma tuai hiniau.” ");
INSERT INTO tgp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Matan nona tavtav mo tavera, ale enr̃a mo isoiso r̃a lo lavi na nona otori r̃uhu matuvana, ale matana, nona r̃omr̃uhu mo lo mar̃ivisihir̃a la lo masurere hinir̃a, ");
INSERT INTO tgp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","matan Moses mo siler̃a na Leu, pani r̃omr̃uhu peresi na retivarar̃uhu la tai isan Iesu Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Te tamlohi mo sopo lo hite God hin te pongi, pani haratu enia God sei mo lo toho na tavalun Tama, enia mo vujangia isar̃a vara God enia mo sohena sava. ");
INSERT INTO tgp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hin rani atu tamlohi tatavera nona Jew la r̃ule na pr̃is peresi na tatua vao Levi enira tuetueni nona pr̃is la lo toho Jerusalem vara la mai la usia isan John vara, “Engko natu Kr̃isto atu teni mo vono?” Ale John mo r̃aramira, ");
INSERT INTO tgp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","mo sopo vunvunia, mo taviti isara mara, “Enau mo sopo Kr̃isto atu!” ");
INSERT INTO tgp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ale la usia isana lara, “Ale o to verea vara, engko hare? Engko Elijah teni mo vono?” Pani mo r̃aramira mara, “Mo vono, mo sopo enau.” La mele usia lara, “Engko natu, pr̃ovet atu teni mo vono?” Mo mele verea isara mara, “Mo vono.” ");
INSERT INTO tgp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ale la verea isana lara, “Engko hare? O vere kamam hinia matan kama pa er̃i r̃arami la haratu la lo r̃ule kamam. O to vere kamam hiniho vara engko hare.” ");
INSERT INTO tgp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John mo verea sohen pr̃ovet Isaiah mo vereamara, ‘Enau leo atu mo lo ulo na jara hasetoho, ha vasahi na malele matan vara Moli God i pa hahau hinia!’ ");
INSERT INTO tgp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ale tatuara la mai isana enira la tai na vao Pharisee. ");
INSERT INTO tgp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","La mele usi John hinia lara, “Kama rongoho moiso vara engko mo sopo Kr̃isto atu, teni Elijah teni pr̃ovet atu Moses mo verea vara i pa mai, ale vara mo sohena, mata sava ko lo paptijo na tamlohi?” ");
INSERT INTO tgp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John mo r̃aramira mara, “Paptijo nike, enau na lo vaia na wai purongo, pani matea mo lo turu na livuhamim moiso kamim ka sopo lo hitevosahia, ");
INSERT INTO tgp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","haratu sei i pa mai usuriau enia mo aulu hiniau, ale enau na sopo tataholo vara a uli nar̃ihi na asi eve palona.” ");
INSERT INTO tgp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","La hinau sei la masese na taon Bethany, tavalu vano na wai Jordan. Hin jara atu John mo lo paptijo na tamlohi ea. ");
INSERT INTO tgp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mo mele rani sahe, John mo hite Iesu mo lo hahau mo lo mai isana, mo verea isan vao atu mara, “Eh! Ha kilau vano sevano isan tamlohi sei mo lo mai. Enia natu, Natu Sipsip non God tataholo, enia natu, i pa lavi nar̃ihi na hehe nona tamlohi na varama. ");
INSERT INTO tgp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Enau na pete vere kamim hinia moiso vara, ‘Tamlohi matea i pa mai hitahu hiniau mo aulu jea hiniau!’ matan mo lo mauri mo lo toho moiso tiroma na noku pongi vora.’ ");
INSERT INTO tgp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Enau na sopo hitevosahia vara enia hare, pani enau na mai na lo paptijo na wai matan vara enia i pa pala isan Israel.” ");
INSERT INTO tgp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Moiso, John mo lo vereulia mara, “Na hite Tanumen God mo tai aulu na tuka sohena vomahe matea, mo tau hinia. ");
INSERT INTO tgp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tiroma na sopo hitevosahia vara enia hare, pani haratu sei mo r̃uleau vara a paptijo na wai mo vereau hinia mara, ‘Vara o hite na Tanume Tapu i sevuti i tau na tamlohi matea, tamlohi atu natu, ko lo kilau matana. Enia haratu i pa r̃ur̃uni na tamlohi na suihan Tanume Tapu.’ ");
INSERT INTO tgp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Matan na hitea moiso enau a er̃i verea kamim hinia vara varar̃uhu haranike natu, enia Natun God.” ");
INSERT INTO tgp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mo mele rani sahe, John mo lo turu atu mo lo sorasora peresi na nona tamlohi usuri mo rua hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Moiso, John mo hite Iesu mo lo hahau na tavalura, moiso John mo verea isara mara, “Ka hite tamlohi sevano, enia natu, enia Natu Sipsip non God tataholo.” ");
INSERT INTO tgp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tamlohi usuri non John lara la rongoa, la vano vahatea vara la pa usuri Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Moiso Iesu mo posi vano isara mo hite vara la lo usuria mara, “Ka opoi na sava?” La r̃aramia lara, “Rabbi, imam mo lo toho epu?” Ale r̃aramin hija nike ‘rabbi’ enia ‘tija’. ");
INSERT INTO tgp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Moiso mo verea isara mara, “Ha mai, ha pa hitea.” La vano enira tolu Iesu la hite jara atu Iesu mo lo toho ea. Matan alo mo vati na ravravi moiso, ale la lo toho peresia mo sinai mo ravravi jea. ");
INSERT INTO tgp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Vonara matea atu sei mo rongo John mo lo verera hin Iesu, ale mo usuria enia Andrew, vorain Simon Peter. ");
INSERT INTO tgp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hinau tiroma Andrew mo vaia mo vano vara i ale tavaina Simon vara i verea isana vara, “Kama hite tamlohi atu, enia natu pa Tamlohi Jujuri atu!” Tamlohi Jujuri na leon tavtavuin Israel r̃aramina enia ‘Kr̃isto’ na leo mara Greek. ");
INSERT INTO tgp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrew mo verea isana moiso mo lavia mo mai isan Iesu. Moiso Iesu mo verea isana mara, “Engko Simon natun John, pani nake a pa tau na hijam vara Cephas.” R̃aramin hija sei ‘Cephas’ enia ‘Peter’. ");
INSERT INTO tgp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mo mele rani sahe Iesu mo vano Galilee. Mo tapai Philip ea, ale mo verea isana mara, “O pa mai noku tamlohi o usuriau!” ");
INSERT INTO tgp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip mo tai hin taon sei Bethsaida, jaran Andrew enia Peter. ");
INSERT INTO tgp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip mo malue vara i ale Nathanael, moiso mo verea isana mara, “Kama tapai pa tamlohi tataholo atu sei Moses mo lo ulia na Leu, ale pr̃ovet sohena la uliuli matana vara i pa mai. Kama hitea enia mara Nazareth, natun Joseph, hijana Iesu.” ");
INSERT INTO tgp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pani Nathanael mara mo rongoa mo verea mara, “Nazareth! I vono! Sava hinau i r̃uhu i er̃i malue hin jara atu?” Philip mo r̃aramia mara, “O mai, o pa hitea engko hasem.” ");
INSERT INTO tgp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","La pa lo mai, Iesu mo hitera, mo verea isan Nathanael mara, “Varar̃uhu, na lo hite na tamlohi matea enia mahapin Israel tataholo matea, mo sopo te halu hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ale Nathanael mo usia mara, “Pani engko ko levosahiau sohena sava?” Iesu mo r̃aramia mara, “Hin rani atu Philip mo sopo lo vano matam, enau na pete hiteho moiso, ko lo sakele na malumalu pulo fig vipahai atu.” ");
INSERT INTO tgp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael mo r̃aramia mara, “Tija, engko Natun God tataholo! Engko Supe non Israel!” ");
INSERT INTO tgp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu mo r̃aramia mara, “Enau na verea purongo vara na hiteho ko lo sakele na pulo fig matea, moiso vahatea purongo ko rasuau, pani o pa mele hite na hina mar̃urahi matuvana, la pa jeu haratu sei ko lo hitera! ");
INSERT INTO tgp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Varar̃uhu na verea isamim mo isoiso, ha pa hite tuka i roi, moiso ha pa hite na angelo non God la pa lo mai, la pa lo sahe aulu, moiso la pa lo sevuti isan Natun Tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rani mo tolu mo vano moiso, ale tinan Iesu mo lo toho na lahi matea na taon matan Cana na jara Galilee. ");
INSERT INTO tgp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","La usi Iesu tolu na nona tamlohi usuri vara la pa mai hin lahi atu. ");
INSERT INTO tgp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pani hin rani atu waen mo isoiso, mo sopo mele tea. Tinan Iesu mo vere Iesu hinia mara, “Mara waen mo isoiso, mo sopo mele tea.” ");
INSERT INTO tgp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu mo r̃aramia mara, “Eh, nana, mo sopo te nor̃a hinau hinia, matan noku rani mo sopo lo mai.” ");
INSERT INTO tgp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tinana mo verea isan la tamlohi tuetueni hin jara atu mara, “Ha vai na sava hinau i pa verea isamim.” ");
INSERT INTO tgp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Moiso mo kilau vano mo hite na jara wai tatavera mo limarave la vaira na lepa; Jew la lo utu na wai loso mata nora lotu hinira. La er̃i tau na wai i tikeli 50 lita hinira hatehateahi. ");
INSERT INTO tgp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu mo verea isan la tamlohi tuetueni atu mara, “Ha mar̃ivisira na wai!” Ale la vaia sohena, ");
INSERT INTO tgp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ale mo verea isara mara, “Ha rengi tea, ha silea isana tamlohi tavera mata hanhani vara i inu rongorongoa.” Ale la vaia sohena mo verea. ");
INSERT INTO tgp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pa tamlohi sei mo lo kilau na hanhani mo rongoa vara waen, pani enia mo sopo levosahi te hinau hinia, pani tamlohi tuetueni purongo enira la levosahia, ale mo vano mo tovi pa tamlohi atu vara i pa lahi mo mai isana, ");
INSERT INTO tgp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mo verea isana mara, “Tarea na lahi, tamlohi lahi mo lo sile na waen r̃uhu mo memeje tiroma vara tamlohi la pa putu makomona hinia, moiso i pa sile na waen mo sopo r̃uhu jea, pani engko ko tau na waen r̃uhu sei vara r̃a pa inua hitahu!” ");
INSERT INTO tgp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Matamata tavera atu enia tiroma matamata tavera Iesu mo vaia, ale mo vaia na taon Cana na jara Galilee. Iesu mo vuhesi na nona suiha r̃uhur̃uhu isana nona tamlohi usuri ea, ale la tau na nora rasua hinia. ");
INSERT INTO tgp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hitahun haratu Iesu mo sahe Capernaum peresi tinana, la tasina tolu na nona tamlohi usuri, vara la pa toho atu te makomo rani. ");
INSERT INTO tgp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nake mo lo mai mariviti mata hanhani tavera nona Jew la tovia Passover, ale Iesu mo sahe Jerusalem matana. ");
INSERT INTO tgp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iesu mo unu na Temple mo hite na vao tamlohi matuvana la lo har̃ehi na buluk, sipsip peresi na vomahe mata malamalai ea. Ale mo hite na tamlohi mata jenjen mania la lo jeni na mania na mania mata silesilea na lolo Temple, la lo sakele na nora tep. ");
INSERT INTO tgp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Moiso mo vai na maja na oti asihai, mo levuti nar̃ihira peresi na pulara maji mo isoiso na lolon Temple atu. Mo jarai jovi na nora mania, ale mo tipovi na nora tep. ");
INSERT INTO tgp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Isan la haratu la lo har̃ehi na vomahe mo verea isara mara, “Ha lavi nar̃ihi la hinau nike! Ha sopo vai na Iman Tamaku ima ar̃ear̃ehi matea!” ");
INSERT INTO tgp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nona tamlohi usuri la hitea, la mele r̃omr̃omi na sava Retiulia mo verea mara, ‘Noku opoia mata imam mo tavera jea, ale mo joleau vara a kilaua’. ");
INSERT INTO tgp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ale tamlohi tavera nona Jew lara, “O pa er̃i vai te matamata hatea nakerihi vara kama pa levosahia vara engko natu, tamlohi tataholo sei vara o pa er̃i vai hinau sei?” ");
INSERT INTO tgp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu mo r̃aramira mara, “Ha kauti Temple nike, moiso na rani i tolu purongo, a pa mele turuhia.” ");
INSERT INTO tgp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Moiso tamlohi tatavera nona Jew atu la r̃aramia lara, “La voro Temple nike mata tauni mo ngavulu vati mo limarave , pani o pa mele turuhia na rani i tolu purongo sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pani Iesu mo lo retireti na epena sohena Temple matea. ");
INSERT INTO tgp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hin rani atu mo mele turu na mateia, nona tamlohi usuri la mele r̃omr̃omi nona retireti atu, ale la rasu na Retitapu peresi na retireti non Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hin rani atu Iesu mo lo toho Jerusalem na hanhani Passover, vao tavera la rasua vara enia tamlohi atu la lo kilau matana, matan la hite na matamata mo lo vaira. ");
INSERT INTO tgp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pani Iesu mo sopo rasura matan mo levosahi na sava mo lo toho na mapura. ");
INSERT INTO tgp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tea i sopo er̃i vereulia isana vara tamlohi la sohena sava. Enia mo levosahira moiso. ");
INSERT INTO tgp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ale tamlohi tavera matea na vao Pharisee hijana Nicodemus, enia tamlohi aulu matea nona Jew, ");
INSERT INTO tgp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","mo mai isan Iesu na vutepongi matea mo verea isana mara, “Tija, kama levosahia vara God mo r̃uleho vara o vujangi kamam, matan mo sopo te tamlohi hatea vara i er̃i vai na matamata vara God mo sopo toho isana.” ");
INSERT INTO tgp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu mo r̃aramia mara, “Varar̃uhu na vereho hinia, vara tamlohi la sopo lavi na vora paro tiroma, la pa sopo er̃i hitevosahi mauri atu God mo aulu hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus mo usia mara, “Pani tamlohi mo vajiaha moiso i pa mele vora sohena sava? I pa er̃i mele unu na pangen tinana vara i pa mele vora teni i vono?” ");
INSERT INTO tgp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu mo r̃aramia mara, “Varar̃uhu, varar̃uhu na verea isam vara te tamlohi i sopo vora na wai peresi na Tanumen God, i pa sopo er̃i unu hin mauri atu God mo aulu hinia. ");
INSERT INTO tgp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tamlohi la sile na mauri tamlohi isan natura, pani Tanumen God mo lo sile mauri atu mo tai isana. ");
INSERT INTO tgp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ha sopo mar̃urahi hin noku reti sei, na lo verea isam vara ha pa lavi vora paro atu mo tai na tuka. ");
INSERT INTO tgp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tanumen God hasena mo lo sile na mauri paro. Tanumen God mo sohena langi sei mo lo sere mo vano na jara mo opoia, ko rongoa, pani ko sopo levosahia vara mo tai epu teni na sava jara mo lo vano ea.” ");
INSERT INTO tgp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus mo usia mara, “La hinau sei la pa sohen haratu sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu mo r̃aramia mara, “Engko natu, tija nona tavtavuin Israel, pani ko sopo lo levosahi la hinau sei mata sava? ");
INSERT INTO tgp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Varar̃uhu na verea isam, kama lo vereuli na sava kama levosahira, matan kama hasemam hitera, pani ka sopo rasu nomam vereulia sei. ");
INSERT INTO tgp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Vara a vere kamim na hinau mata varama, pani ha sopo rasuau, ha pa rasuau sohena sava vara a vere kamim na hinau matan na tuka? ");
INSERT INTO tgp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tea mo sopo lo sahe na tuka, ale i mele sinai, pani Natun Tamlohi hasena, enia mo tai atu mo sinai nike. ");
INSERT INTO tgp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sohen tuai Moses mo tahe na mata mo vaia na bronze na tano koru, ale sohen haratu natu la pa tahe Natun Tamlohi aulu, ");
INSERT INTO tgp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","vara sava tamlohi mo tau na nona rasua isana, enia i pa lavi na mauri tui. ");
INSERT INTO tgp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Matan God mo opoi na tamlohi na varama sohen harihi: mo sile Natuna sei enia vorahese, vara sava tamlohi mo rasua i pa sopo vano na komo, pani i pa lavi na mauri tui. ");
INSERT INTO tgp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Matan God mo sopo r̃ule Natuna na varama vara i ari na tamlohi, mo vono. Mo r̃ulea vara i jurira hinia. ");
INSERT INTO tgp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Haratu mo rasu na Natun God enia i pa sopo lavi na talai, pani isan la haratu la sopo rasua, God mo pete tau na nora talai moiso matan la sopo rasu na hijan Natun God vorahese. ");
INSERT INTO tgp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pulo nora talai mo sohen harihi: matan malarani mo mai na varama, pani tamlohi la opoi na r̃or̃oha mo tavera mo jeu na malarani matan nora vavahinau la hehe. ");
INSERT INTO tgp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pani la haratu la lo vai na hehe la pa sopo er̃i mai na malarani, la r̃ohu vara la mai na malarani matan vara i vono, malarani i pa vuhesi na nora hehe. ");
INSERT INTO tgp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pani la haratu la lo oloolo na retivarar̃uhu na maurira, enira la pa mai na malarani, matan vara i vujangia vara nora vavahinau la tai isan God.” ");
INSERT INTO tgp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hitahun harihi, Iesu tolu na nona tamlohi usuri, la mai na jara Judea. Enia mo lo toho peresira makomona, ale mo lo paptijo na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Hin rani atu la sopo lo tau John na ima r̃ilangi, enia mo lo paptijo na tamlohi la lo mai isana na jara Aenon mariviti Salim mata wai mo mar̃ivi ea. ");
INSERT INTO tgp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hin rani atu tamlohi usuri non John la lo vasvas peresi na Jew matea mata nora posposi mata hoje vara la vokevoke. ");
INSERT INTO tgp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ale la mai isan John la verea isana lara, “Tija, pa tamlohi atu ko lo verea hin rani atu, na tavalu wai Opae Jordan, nakerihi mo lo paptijo na tamlohi, moiso tamlohi tari la lo marongia.” ");
INSERT INTO tgp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John mo r̃aramira mara, “Tea i sopo er̃i vai te hinau hatea, pani vara God mo tinar̃ihia, enia i pa er̃i vaia. ");
INSERT INTO tgp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamim ka levosahi na sava na pete verea isamim moiso vara enau, mo sopo Kr̃isto atu, pani God mo r̃uleau vara a mai tiroma hinia. ");
INSERT INTO tgp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ka sopo levosahia vara tamlohi i pa lahi natu, mo lahi na har̃ai, pani tapalan tamlohi atu mo avulahi vara mo rongo na leona, ale vara i turu mariviti isana. Enia natu, noku avulahi tavera mo vano sohena natu. ");
INSERT INTO tgp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Enia hijana i pa mai i mele aulu jea, pani hijaku i pa lo sivo atano jea. ");
INSERT INTO tgp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Haratu mo tai na tuka, enia mo aulu na tamlohi tari. Haratu mo tai na varama, enia non varama, ale enia mo er̃i vere na hinau na varama purongo. Pani haratu mo tai na tuka mo aulu na tamlohi tari. ");
INSERT INTO tgp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mo lo vere na sava mo hitera, mo rongora, pani tamlohi la sopo rasua. ");
INSERT INTO tgp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","La haratu la rasua enira la verea vara God enia varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Matan God mo r̃ule Natuna vara i vere na nona reti, matana, mo sile vevuhi na suiha Tanumena isana. ");
INSERT INTO tgp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tama sei, mo opoi Natuna, ale mo tau na hinau tari na limana vara i aulu hinira. ");
INSERT INTO tgp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Haratu mo rasu Natuna mo pete lavi na mauri tui moiso. Pani haratu mo sopo oloolo hin Natuna, i pa sopo er̃i lavi mauri tui atu, matan talai lolokoru non God mata hehe mo lo toho isana.” ");
INSERT INTO tgp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na rani Iesu mo levosahia vara Pharisee la rongoa moiso vara tamlohi la lo usuria, la jeu la haratu la lo usuri John, ");
INSERT INTO tgp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","mo r̃uhu vara ha levosahia vara Iesu hasena mo sopo paptijo na tamlohi, pani nona tamlohi usuri hasera la lo paptijo na tamlohi, ");
INSERT INTO tgp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ale matana, Iesu mo malue Judea mo mele vano Galilee. ");
INSERT INTO tgp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hin rani atu mo lo hahau roto Samaria, ");
INSERT INTO tgp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","mo hahau mo mai Samaria na taon matan Sychar mariviti hin lepa atu sei tuai Jacob mo silea isan natuna Joseph. ");
INSERT INTO tgp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Wel atu Jacob mo helia tuai mo pa lo toho ea, ale Iesu mo sakele na tavaluna matan mo hahau jara peravu mo malokoloko. Ale na livuha rani, tamlohi usuri non Iesu la vano vara la voli te hanhani na taon. Har̃ai mara Samaria matea mo mai vara i utu te wai na wel. Iesu mo usia isana mara, “O er̃i utu te maku wai?” ");
INSERT INTO tgp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Har̃ai atu mo r̃aramia mara, “Engko Jew matea, ale enau har̃ai mara Samaria! Vara sava engko ko usiau vara a utu te mam wai?” Mo usia sohena matan mara Judea peresi na mara Samaria la lo hitelehilehira. ");
INSERT INTO tgp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Moiso Iesu mo r̃aramia mara, “Engko ko sopo levosahi na sava God mo opoia vara i silea isam. Ale engko ko sopo levosahia vara harepu nahai mo lo usiho na wai mata i inua. Vara o pa lo levosahia, o pa usiau na wai sei mo sile na mauri.” ");
INSERT INTO tgp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ale har̃ai atu mo usia isana mara, “Tapala, mo sopo te nom baket, ale wel sei mo sivo atano. O pa er̃i utu wai atu mo sile na mauri epu? ");
INSERT INTO tgp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Pimam Jacob mo heli wel sei matamam, moiso enia peresi na vaona peresi na pulana maji palovati tari la inu hinia. Engko o pa er̃i jeu na sava Jacob mo vaia?” ");
INSERT INTO tgp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu mo r̃aramia mo verea mara, “Tamlohi tari la lo inu wai sei la pa mele mar̃ohu. ");
INSERT INTO tgp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pani la haratu vara la inu na wai a pa silea, la pa sopo er̃i mele mar̃ohu na rani sei la pa mai. Wai atu a pa silea enia patu wai sei mo sile na mauri tui.” ");
INSERT INTO tgp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ale har̃ai atu mo r̃aramia mara, “Tapala, o sileau a inu wai atu matan vara a sopo mele mar̃ohu vara a pa mele mai hin wel nike.” ");
INSERT INTO tgp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ale Iesu mo verea isana mara, “O vano o lavi tuam i mai.” ");
INSERT INTO tgp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Har̃ai atu mo r̃aramia mara, “Enau mo sopo te tuaku.” Iesu mo verea isana mara, “Ko verea ko varar̃uhu, mo sopo te tuam. ");
INSERT INTO tgp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Engko ko lahi, ale tuam mo lima moiso, ale nake tamlohi atu ko lo toho peresia enia mo sopo tuam tataholo. Haratu ko verea mo varar̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ale har̃ai atu mo verea isana mara, “Moli, na hitevosahia vara engko pr̃ovet matea. ");
INSERT INTO tgp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pimam la lo lotu na vutivuti nike, pani kamim Jew ka vara Jerusalem purongo enia jara tataholo vara tamlohi la lo lotu ea.” ");
INSERT INTO tgp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ale Iesu mo verea isana mara, “O rasuau, pongi matea mo lo mai vara ha pa sopo mele lotu Tama hin vutivuti nike teni Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamim mara Samaria, ka sopo levosahia varar̃uhu vara ka lo lotu hare. Pani kamam Jew, kama levosahi God atu kama lo lotua. Hin na mahapi Jew God i pa juri na varama. ");
INSERT INTO tgp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pani pongi matea mo lo mai, ale mo tapulo moiso vara la haratu la lotu varar̃uhu, la pa lotu Tama sohena Tanumena mo vujangira na malele retivarar̃uhu. Tama mo lo ale na tamlohi sohen harihi vara la lotua. ");
INSERT INTO tgp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God enia Tanume, la haratu sei la lotu God la pa lotua sohena Tanumena i pa tiromara vara la pa usuri na malele retivarar̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Har̃ai atu mara, “Enau na levosahia vara Tamlohi Jujuri i pa mai, enia natu kama tovia Kr̃isto. Ale hin pongi atu vara i mai, i pa vere mamahuni na hinau tari isamam.” ");
INSERT INTO tgp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesu mo verea mara, “Enau natu, tamlohi atu mo lo toho jejeu. Na lo retireti isam nakerihi.” ");
INSERT INTO tgp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Vahatea atu, tamlohi usuri non Iesu la mele hilu, moiso la mar̃urahi tavera matan Iesu mo lo retireti peresi na har̃ai matea. Pani te vonara mo sopo usia vara, ‘Ko opoi na sava?’ teni ‘Mata sava ko lo retireti isan har̃ai nike?’ ");
INSERT INTO tgp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Moiso har̃ai atu mo tau nona jara wai, ale mo mele maro hilu mo vano na taon. Mo verea isana tamlohi mara, ");
INSERT INTO tgp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ha mai! Ha hite na tamlohi matea sei mo vereau na hinau tari na vaira moiso. Korong enia natu, Kr̃isto atu teni?” ");
INSERT INTO tgp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ale tamlohi tari hin taon atu la vano la hite Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","La hinau atu la lo vano, moiso tamlohi usuri non Iesu la lo verea isana lara, “Tija, o hani te hinau.” ");
INSERT INTO tgp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pani Iesu mo verera hinia mara, “Haku hinau kamim ka sopo levosahia te hinau hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nona tamlohi usuri la lo usiusira hinia lara, “Tea mo sile te hanhani isana teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pani Iesu mo verea isara mara, “Haku hinau, enia mata a vai na masalon God. Enia natu, mo r̃uleau, ale enau a pa vai vevuhi na nona vavahinau sei mo taua isaku vara a vaira. ");
INSERT INTO tgp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ha sopo verea vara vitu mo vati mo lo toho vara i tikeli na asitauni. Pani enau na lo vere kamim hinia vara ha to kilau vano, ha pa hite vara isa la jea la lo mena mata lavi na asitauni moiso. ");
INSERT INTO tgp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tamlohi asitauni la lo lavi na volira, mata la lo vu na vua mata mauri tui. La haratu la lo hapor̃ahi na piri peresi la haratu la lavi na vua asitauni la pa avulahi jea na jara matea. ");
INSERT INTO tgp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hin haratu reti nike mo varar̃uhu, ‘Hai la hapor̃ahi na piri, hai la lavi na vua asitauni.’ ");
INSERT INTO tgp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Enau na lo r̃ule kamim vara ha pa lavi na vua asitauni na isa sei tamlohi tinapua la vai na voko r̃ilangi ea moiso.” ");
INSERT INTO tgp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vao tavera mara Samaria hin taon atu la tau na nora rasua hin Iesu matan har̃ai atu mo vere mara, “Tamlohi nike, mo vereau na hinau tari na vaira moiso.” ");
INSERT INTO tgp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","La mai la usia isana vara i lo toho na taon nona mara Samaria. Ale mo lo toho ea mata rani mo rua. ");
INSERT INTO tgp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ale vao tavera mara Samaria la tau na nora rasua hin Iesu, mata sava la rongoa mo lo verea. ");
INSERT INTO tgp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","La verea isan har̃ai atu lara, “Kama sopo rasu Iesu matan la hinau atu ko lo verea isamam purongo, pani matan kama hasemam rongoa, ale kama levosahia mo r̃uhu vara enia natu, Jujuri mata Varama!” ");
INSERT INTO tgp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mo mele rani mo rua tinapua moiso, mo malue mo vano Galilee, ");
INSERT INTO tgp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","matan Iesu mo verea moiso vara tamlohi la pa oloolo na pr̃ovet na jara tari, pani mo sopo na jarara tataholo, ");
INSERT INTO tgp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ale mo sinai Galilee, ale mara Galilee atu la avulahi na nona mai matan la hite la hinau tari atu mo lo vaia Jerusalem na hanhani Passover ea matan enira sohena la sahe Jerusalem mata hanhani ea. ");
INSERT INTO tgp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ale hin rani atu mo lo toho Galilee, mo mele hilu mo vano Cana taon sei mo posi na wai mo mai waen ea tiroma. Ale tamlohi tavera matea atu Capernaum natuna mo rojo. ");
INSERT INTO tgp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pa tamlohi tavera mo rongo vara Iesu mo tai Judea mo mai Galilee moiso, mo vano vara i usia r̃ilangi vara i er̃i vai mamahuni natuna. ");
INSERT INTO tgp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu mo verea isan tamlohi tavera atu mara, “Kamim tamlohi, i pa sopo te nomim rasua vara ha sopo hite na matamata tavera peresi na hina mar̃urahi!” ");
INSERT INTO tgp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pani tamlohi atu, mo r̃aramia mara, “Moli! O er̃i mai vila? Vara i vono, natuku i pa mate!” ");
INSERT INTO tgp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu mo r̃aramia mara, “Natum i pa mauri. O mule, o vano isana!” Tamlohi atu mo rasu na sava Iesu mo verea isana, ale mo tapulo mule. ");
INSERT INTO tgp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te slev non tamlohi tavera atu la tapaia na malele, ale la verea isana lara, “Natum mo mele r̃uhu moiso!” ");
INSERT INTO tgp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mo usira mara, mo mele r̃uhu nangisa, ale la r̃aramia lara, “Seserei atu mo malue isana nanovi na matan alo matea.” ");
INSERT INTO tgp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Vahatea taman uluvou atu mo r̃omr̃omia vara matan alo matea nanovi Iesu mo verea isana mara, “Natun i pa mauri!” Ale tamlohi atu peresi na vao imana la tau na nora rasua hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Matamata tavera sei enia harua matamata Iesu mo vaia hin rani atu, hitahun haratu mo malue Judea mo vano Galilee. ");
INSERT INTO tgp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hitahun la hinau sei, Iesu mo sahe Jerusalem mata hanhani tavera matea nona Jew. ");
INSERT INTO tgp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na lolon Jerusalem paltungu tavera matea la vaia mata loloso mo lo toho ea na leon tavtavuin Israel la tovia Bethsaida. Mo lo toho mariviti na matarua matea mata sipsip sei la tauhasehira mata malamalai vara la lo unu na rope Temple atu. Paltungu atu la voro na palapala mo lima mo r̃alihia. ");
INSERT INTO tgp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Tamlohi matuvana la rojo, la haratu la matavuso, la haratu tavalu epera la mate, la haratu epera la mate, sohen la papao, la lo juruvi r̃alihi paltungu sei. ");
INSERT INTO tgp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na pahisan paltungu tavera atu, tamlohi matea tavalu epena mo mate mata tauni mo ngavulu tolu mo limaravtolu . ");
INSERT INTO tgp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ale Iesu mo hite tamlohi sei mo hitevosahia vara enia tavalu epena mo mate mata tauni matuvana moiso, ale mo usia isana mara, “Eh, ko opoia vara o r̃uhu teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ale tamlohi atu mo r̃aramia mara, “Tapala, mo sopo te tapalaku vara i pa er̃i tauau na lolo paltungu hin rani atu wai mo lo vali. Na vaihitea vara a pa sivo tiroma, pani tamlohi tinapua la lo sivo tiroma hiniau.” ");
INSERT INTO tgp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu mo verea isana mara, “O lavi na epam o hahau!” ");
INSERT INTO tgp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Vahatea tamlohi atu mo mele r̃uhu. Mo lavi na epana mo tapulo hahau r̃alihi. Rani atu hinau atu mo masese hinia, enia Sabbath matea. ");
INSERT INTO tgp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Moiso tamlohi tavera nona Jew la hite tamlohi atu mo lo r̃alihi mo lo lavi na epana, la verea isana lara, “Haranike Sabbath nahai! Tea i sopo er̃i lavi na epa i lo hahau na Sabbath!” ");
INSERT INTO tgp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pani mo r̃aramira mara, “Tamlohi atu mo vaiau na r̃uhu mo verea isaku vara a lavi na epaku a hahau.” ");
INSERT INTO tgp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","La usia isana lara, “Sava tamlohi natu, mo vereho vara o pa lavi na epam o hahau?” ");
INSERT INTO tgp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pani enia mo sopo levosahia vara Iesu enia hare, ale Iesu mo malue moiso mata vao hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hitahun haratu, Iesu mo tapai tamlohi atu na lolo Temple, ale mo verea isana mara, “Engko ko r̃uhu moiso, pani o sopo mele vai te hehe, vara i vono te hinau i mele sati jea i pa tikeliho.” ");
INSERT INTO tgp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ale tamlohi atu mo malue mo vano mo verea isana tamlohi tavera nona Jew mara Iesu natu, mo vaia mo r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ale matana, tamlohi tavera nona Jew la tapulo tipahi Iesu matan mo vai na hinau sohena na Sabbath. ");
INSERT INTO tgp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pani Iesu mo verea mara, “Tamaku mo lo vavahinau mo tikeli nakerihi, ale enau sohena na lo vavahinau.” ");
INSERT INTO tgp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ale matan haratu, tamlohi tavera nona Jew la vaihitea r̃ilangi vara la vilimateia. Mo sopo matan haratu vara mo lo tope na Sabbath purongo, pani matan mo lo verea vara God enia Tamana, retireti atu mo vaia enia mo tataholo hin God. ");
INSERT INTO tgp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu mo r̃aramira mara, “Varar̃uhu na verea, Natun Tama hasena i sopo er̃i vai te hinau hatea, pani haratu purongo sei mo hite Tamana mo lo vaia tiroma, ale enia i pa vaia. Matan sava hinau Tamana mo lo vaia, Natuna sohena i pa vaia. ");
INSERT INTO tgp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Matan Tama mo opoi Natuna, ale mo vujangia na hinau tari enia mo lo vaia. Tama i pa mele vujangi na hinau matuvana la jeu haranike isana matan vara ha pa mar̃urahi tavera. ");
INSERT INTO tgp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mo sohen Tama mo sauteterahi na mate mo silera na mauri, ale Natuna sohena i pa sile na mauri isan hare enia mo opoia. ");
INSERT INTO tgp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tama mo sopo ari te tamlohi, pani mo tau na aria mata tamlohi tari isan Natuna, ");
INSERT INTO tgp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","matan Tama mo opoia vara tamlohi tari la oloolo hin Natuna sohen la lo oloolo hinia. Vara tea mo sopo oloolo hin Natuna, mo sohena mo sopo oloolo hin Tama sei mo lo r̃ulea. ");
INSERT INTO tgp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Varar̃uhu na verea isamim, vara harepu mo rongo na noku reti, ale mo rasu haratu mo r̃uleau, enia mo pete lavi na mauri tui moiso, enia i pa sopo lavi na talai hin pongi atu, pani mo malue moiso na mateia, ale mo lavi na mauri. ");
INSERT INTO tgp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Varar̃uhu na verea isamim, pongi matea mo lo mai, mo pete mai moiso, vara mate la pa rongo na leon Natun God, moiso la haratu purongo sei la tapurongo isana, la pa mauri. ");
INSERT INTO tgp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ale matan Tama enia pulo mauri enia mo sile Natuna vara enia sohena, i pa lavi pulo mauri atu. ");
INSERT INTO tgp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Moiso, mo silea vara Natuna i lavi na suiha vara i ari na tamlohi, matan enia Natun Tamlohi. ");
INSERT INTO tgp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ale ha sopo mar̃urahi matan hinau sei! Matan pongi matea mo lo mai vara la haratu la lo toho na taptap la pa rongoa na leon Natun Tamlohi, ");
INSERT INTO tgp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ale la pa malue, la haratu la vai na hina r̃uhu la pa sauteterahi la vano na mauri, la haratu la lo vai na hina hehe la pa sauteterahi la lavi na talai. ");
INSERT INTO tgp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Enau haseku a sopo er̃i vai te hinau. Haratu mo lo r̃uleau, enia mo vereau vara a pa ari sohena sava. Enau na ari tataholo matan na lo oloolo hinia, ale na sopo vai na masaloku matan na lo vai na masalona. ");
INSERT INTO tgp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Vara a lo vereau enau haseku, tamlohi la pa sopo rasua vara na lo varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tamlohi tinapua matea mo lo vere na hinau varar̃uhu mataku. Ale na levosahia vara la hinau atu mo lo verera mataku enira la varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kamim ka r̃ule na tamlohi la vano isan John moiso, ale enia mo vereuli na retivarar̃uhu mataku isara, ");
INSERT INTO tgp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","pani na sopo turu na vereulia nona tamlohi mataku, pani na lo vere la hinau sei matan vara ha pa er̃i juri hinira. ");
INSERT INTO tgp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ale John enia lamu matea mo lo hani mo memera, ale kamim ka lo avulahi jea mata makomo rani na memerana. ");
INSERT INTO tgp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pani hinau matea mo mele r̃uhu jea, mo jeu vereulia atu John mo lo verea mataku. La hinau atu Tama mo silea isaku vara a vaira, enira natu, la vujangia vara Tama hasena mo lo r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ale Tama sei mo lo r̃uleau, enia mo lo vereau, pani kamim ka sopo lo rongo na leona teni hitea hin te rani. ");
INSERT INTO tgp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ale ka sopo lavi na nona reti na mapumim matan ka sopo rasu haratu mo lo r̃uleau na mai. ");
INSERT INTO tgp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kamim ka lo ale na Retiulia matan ka r̃omia vara hinira ha pa lavi na mauri tui. Retitapu sei la lo vereuliau, ");
INSERT INTO tgp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pani ka r̃ohu vara ha mai isaku mata mauri tui. ");
INSERT INTO tgp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Na sopo lavi na oloolo nona tamlohi mataku, ");
INSERT INTO tgp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","pani na levosahi kamim vara mo sopo te vonamim hatea i opoi God. ");
INSERT INTO tgp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na lo mai na suiha hijan Tamaku, pani ka lo tipahiau. Vara te tamlohi i mai na hijana hasena, kamim ha pa avulahi vara ha lavia. ");
INSERT INTO tgp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ha pa rasu sohena sava matan kamim, ka lo opoia vara tea i sile na oloolo isan te vonamim, ale ka sopo opoia vara God hasena i pa sile na oloolo isamim. ");
INSERT INTO tgp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ha lo levosahia vara enau a pa sopo retitalai hin kamim isan Tama! Pani Moses sei, ka lo tau na nomim r̃omtoho hinia, enia i pa retitalai hin kamim. ");
INSERT INTO tgp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Varar̃uhu, vara ha rasu Moses varar̃uhu, ha pa rasuau, matan enia mo uliuli mataku. ");
INSERT INTO tgp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pani vara ka sopo er̃i rasu na sava Moses mo ulia, ha pa er̃i rasu na noku reti sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hitahun la hinau sei, Iesu mo vano na tavalu tasin Galilee la tovia Tiberias. ");
INSERT INTO tgp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Vao tavera la lo usuria matan la hite na matamata tavera mo lo vaia isana tamlohi rojoa la mele r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ale matan vao atu Iesu tolu na nona tamlohi usuri la sahe aulu na vutivuti, ale la sakele ea. ");
INSERT INTO tgp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pongi Passover hanhani tavera nona Jew mo lo mai. ");
INSERT INTO tgp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hin rani atu, Iesu mo hite na vao tavera la lo mai isana, mo usia isan Philip mara, “R̃a pa lavi te hanhani epu vara r̃a pa vahani vevuhi la tamlohi nike hinia?” ");
INSERT INTO tgp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu mo verea sohena isan Philip vara i vaihitea matan enia mo levosahia moiso vara i pa vai na sava. ");
INSERT INTO tgp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip mo r̃aramia mara, “Voli tamlohi matea mata rani mo ngavulu sangavulu rua i sopo er̃i navu vara i vahanira hatehateahi na makomo pereti!” ");
INSERT INTO tgp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Vonara, tamlohi usuri non Iesu matea, hijan Andrew, enia tasin Simon Peter, mo verea isana mara, ");
INSERT INTO tgp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Natirihi matea nahai, mo lavi na pereti vavarihi mo lima la vaia na piri barley peresi na maji mo rua, pani haratu mo r̃uhu na sava isan la tamlohi nike?” ");
INSERT INTO tgp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu mo vere mara, “Ha vere na tamlohi tari la saksakele nike!” Mo verea sohena matan r̃uvur̃uvu r̃uhu hin jara atu mo mar̃ivi. Evi tamlohi purongo la lo sakele atu mo tikeli tari vaha lima . ");
INSERT INTO tgp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ale Iesu mo lavi pa la pereti atu mo vere meje isan God matara, moiso mo asease na pereti isan la haratu la lo sakele. Mo lavi la maji atu mo vaia sohena. Mo vahani na tamlohi, la hanhani sohen la opoia, la masu. ");
INSERT INTO tgp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hitahun haratu enira mo isoiso la masu, Iesu mo vere na nona tamlohi usuri vara la takonahi na sopesope hanhani vara tea i pa sopo sati purongo. ");
INSERT INTO tgp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tamlohi non Iesu, la sohoni na tanga tavera mo sangavulu r̃omana mo rua na sopesopen la pereti atu mo lima. ");
INSERT INTO tgp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hitahun matamata tavera atu Iesu mo vaia, tamlohi la tapulo verea vara, “Tamlohi nike, enia pr̃ovet atu Moses mo lo verea vara i pa sinai na varama!” ");
INSERT INTO tgp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Moiso Iesu mo hitevosahia vara la pa ngurunguru isana vara la pa tahea nora supe. Ale matana, mo rovo mo sahe aulu na vutivuti vara i toho enia hasena. ");
INSERT INTO tgp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hin ravravi atu tamlohi usuri non Iesu la sevuti sivo na tasin Galilee, ");
INSERT INTO tgp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","moiso la vele na boti matea, la tapulo sua roto na tasi matan Capernaum, ale mo r̃or̃oha moiso, Iesu mo sopo lo sinai isara, ");
INSERT INTO tgp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ale langi matea mo tapulo sere mo r̃ilangi, mo vaia mo tasiha. ");
INSERT INTO tgp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nona tamlohi la sua, la jeu na kilometre mo limarave moiso, ale la hite Iesu mo lo hahau na pusa tasi mo lo mai isara, la matahu tavera matana. ");
INSERT INTO tgp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pani Iesu mo verea isara mara, “Enau sei! Iesu! Ha sopo matahu!” ");
INSERT INTO tgp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nona tamlohi la opoia vara i vele na boti, ale vahatea purongo boti atu mo lo hoso hin jara atu la lo vano matana. ");
INSERT INTO tgp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mo mele rani sahe, la vao atu la lo toho na tavalu tasi boti mo tai isara, la levosahia vara mo sopo mele te boti tinapua i lo toho atu, la levosahia vara Iesu mo sopo vele hin boti rihirihi atu peresi na nona tamlohi usuri, pani enira hasera purongo la malue. ");
INSERT INTO tgp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hin rani atu, boti hai nona mara Tiberias la hoso mariviti hin jara atu Iesu mo lo vere meje mata hanhani ea. ");
INSERT INTO tgp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ale vahatea purongo, la levosahia vara Iesu peresi na nona tamlohi usuri la sopo toho atu. Ale la vele hin la boti atu la sivo Capernaum vara la ale Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ale la vano la tapaia na tavalu tasi, la usia isana lara, “Tija, ko pa mai nangisa?” ");
INSERT INTO tgp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu mo r̃aramira mara, “Varar̃uhu na verea isamim, ka sopo aleau mata matamata tavera ka lo hitera, pani matan ka lo hani vevuhi na hanhani ka opoia vara ha hanira. ");
INSERT INTO tgp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ha sopo kalvono mata hanhani sei i pa tihai purongo, pani ha vavahinau matan hanhani sei i pa sopo er̃i tihai ale i pa sile na mauri tui. Natun Tamlohi i pa sile kamim hin hanhani atu matan, Tama mo tinar̃ihia vara enia i vaia.” ");
INSERT INTO tgp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Vao atu la usia lara, “Sava hinau tataholo natu, God mo opoia vara kama pa vaia?” ");
INSERT INTO tgp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu mo r̃aramira mara, “Vavahinau sei God mo opoia mo sohen harihi: vara ha tau na nomim rasua hin haratu mo lo r̃ulea.” ");
INSERT INTO tgp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","La r̃aramia lara, “Sava matamata o pa vaia, matan vara kama pa tau na nomam rasua hiniho? Engko o pa vai na sava? ");
INSERT INTO tgp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pimam tuai la hani na mana na tano koru. Sohen la ulia na Retiulia vara, ‘Mo silera na pereti mo tai na tuka vara la hania’.” ");
INSERT INTO tgp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu mo verera hinia mara, “Varar̃uhu na verea isamim, Moses mo sopo sile na pereti mo tai na tuka isamim, pani Tamaku natu mo lo sile kamim na pereti varar̃uhu sei mo tai na tuka. ");
INSERT INTO tgp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pereti atu God mo silea enia haratu mo tai na tuka, matan vara i sile na mauri na varama.” ");
INSERT INTO tgp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ale la tamlohi atu la verea lara, “Moli, tarea o pa sile kamam hin pereti atu!” ");
INSERT INTO tgp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu mo r̃aramira mara, “Enau pereti atu mo lo sile na mauri! Vara tea i mai isaku i pa sopo er̃i mele marohati. Mo sopo tea vara i tau na nona rasua hiniau i pa mele mar̃ohu. ");
INSERT INTO tgp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na verea isamim moiso vara kamim ka hiteau, pani ka sopo lo rasuau! ");
INSERT INTO tgp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","La haratu enira mo isoiso Tama mo lo sileau hinira la pa mai isaku. Ale haratu mo mai isaku a pa sopo tipahia. ");
INSERT INTO tgp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Matan enau na sevuti na tuka vara a pa vai na masalon God. Na sopo mai vara a pa vai na masaloku haseku. ");
INSERT INTO tgp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hara nike masalon haratu mo lo r̃uleau, vara a sopo vaitihai te vonan la haratu mo lo sileau hinira, pani enau a pa sauteterahira na pongi hitahu. ");
INSERT INTO tgp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Masalon Tamaku mo sohen harihi, mo opoia vara la haratu la hite Natuna, la pa tau na nora rasua isana, ale vara la lavi na mauri tui. Ale na pongi hitahu, enau a pa sauteterahira.” ");
INSERT INTO tgp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ale tamlohi tavera nona Jew atu la tapulo ngutungutu matan mo verea vara, ‘Enau natu, pereti atu mo tai na tuka!’ ");
INSERT INTO tgp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ale la verea lara, “Avei, tamlohi akerihi, enia Iesu natun Joseph sei teni mo vono? Enr̃a r̃a levosahi tamana enia tinana, pani mo pa vere vara enia mo tai na tuka sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu mo verea isara mara, “Ha sopo mele ngutungutu! ");
INSERT INTO tgp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tama mo r̃uleau, ale masalon Tama hasena sei mo vai na tamlohi i er̃i mai isaku, vara i vono, i pa sopo tea i er̃i mai isaku. Pani vara tea i mai isaku, a pa sauteterahia na pongi hitahu. ");
INSERT INTO tgp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sava sei la uli na reti nona pr̃ovet tuai lara, ‘God i pa vujangira enira mo isoiso’. Ale la haratu la lo tapurongo hin Tama, la pa lavi na levosahi isana, enira la pa mai isaku. ");
INSERT INTO tgp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Haratu hasena sei mo tai isan God mo hite Tama atu. Mo sopo mele te tinapua vara i hite Tama hin te pongi. ");
INSERT INTO tgp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Varar̃uhu na verea vara la haratu la lo tau na nora rasua hiniau, la pete lavi na mauri tui moiso. ");
INSERT INTO tgp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Enau pereti atu mo lo sile na mauri! ");
INSERT INTO tgp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pimim tuai la hani na mana na tano koru, ale la mate. ");
INSERT INTO tgp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pani pereti atu mo lo tai na tuka mo sevuti matan vara tea vara i hania i pa sopo er̃i mate hin te pongi. ");
INSERT INTO tgp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Enau pereti mauri atu mo tai na tuka! Vara tea i hani pereti atu enia i pa mauri jejeu. Pereti mauri atu a pa silea isana tamlohi na varama, enia epeku.” ");
INSERT INTO tgp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ale, tamlohi tavera nona Jew atu la r̃ohu hin Iesu la tapulo vauriuri isara hasera lara, “Sohena sava natu, tamlohi nike i er̃i siler̃a na epena vara r̃a hania?” ");
INSERT INTO tgp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu mo verea isara mara, “Varar̃uhu na verea isamim, vara ha sopo hani na epen Natun Tamlohi, ale vara ha sopo inu na r̃aena, i pa sopo te mauri varar̃uhu hin kamim. ");
INSERT INTO tgp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pani haratu mo hani na epeku, mo inu na r̃aeku, enia mo pete lavi na mauri tui moiso, ale enau a pa sauteterahia na pongi hitahu. ");
INSERT INTO tgp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Epeku, enia hanhani varar̃uhu, ale r̃aeku, enia wai inu varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Vara tea i hani na epeku, ale i inu na r̃aeku, enia i pa toho hiniau, enau a pa toho hinia. ");
INSERT INTO tgp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tama sei mo r̃uleau, enia mo lo mauri, ale enau na lo mauri matana. Nake, tamlohi tari sei la haniau la pa mauri mataku. ");
INSERT INTO tgp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Pereti nike, mo tai na tuka mo sinai, mo sopo sohen haratu pimim la hania tuai matan enira la mate, pani hare mo hani pereti nike, i pa mauri jejeu.” ");
INSERT INTO tgp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu mo lo retivujavujangi na ima lotu nona Jew Capernaum na rani mo lo vere la hinau sei. ");
INSERT INTO tgp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nona tamlohi usuri matuvana la rongo nona reti atu lara, “Avei, hara sei mo lo vere na sava sei?” ");
INSERT INTO tgp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu mo levosahia vara nona tamlohi usuri la lo ngutungutu, ale mo usira mara, “Ka rongo hinau sei mo sati? ");
INSERT INTO tgp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","I pa sohena sava vara ha hite Natun Tamlohi i mele sahe na tuka sei mo tai ea mo sinai? ");
INSERT INTO tgp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tanumena enia natu, mo lo sile na mauri! Suiha tamlohi i sopo er̃i vai te hinau. Noku reti na lo verea isamim, la tai isan Tanume atu sei mo lo sile na mauri. ");
INSERT INTO tgp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pani te vonamim la sopo rasuau.” Iesu mo verea sohena matan na pongi tiroma mo levosahia moiso vara harepu i pa rasua, ale harepu i pa turuposi hinia. ");
INSERT INTO tgp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ale Iesu mo mele verea mara, “Matan haratu na verea isamim moiso vara, ‘I pa sopo tea i er̃i mai isaku vara Tama enia i sopo tinar̃ihia vara i mai tiroma’. ” ");
INSERT INTO tgp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Matan la hinau sei Iesu mo verera, nona tamlohi usuri matuvana la vahar̃i hinia, la sopo mele usuria. ");
INSERT INTO tgp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu mo usi la nona tamlohi usuri atu tupu sangavulu r̃omana mo rua mara, “Kamim sohena ha pa rovo hiniau?” ");
INSERT INTO tgp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter mo r̃aramia mara, “Moli, mo sopo mele te tamlohi vara kama pa er̃i vano isana. Nom reti la sile na mauri tui. ");
INSERT INTO tgp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kama rasuho, kama levosahia mo r̃uhu nake vara engko natu, tamlohi atu mo tapu non God!” ");
INSERT INTO tgp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu mo verea isana nona tamlohi mara, “Na vir̃oni kamim tupu sangavulu r̃omana mo rua pani vonamim matea enia tanume sasati matea!” ");
INSERT INTO tgp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu mo lo vere hinau sei matan Judas natun Simon Iscariot matan hitahu i pa halu na hijan Iesu, hina purongo hin haratu vara enia mo vonan la tupu sangavulu mo rua atu, tamlohi non Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Iesu mo hahau r̃alihi Galilee, pani mo sopo vano mariviti Judea matan tamlohi tavera nona Jew la opoia vara la vilimateia. ");
INSERT INTO tgp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hanhani tavera nona Jew la tovia Tabernacle, pongina mo lo mai mariviti. ");
INSERT INTO tgp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ale tasin Iesu la lo verea isana lara, “O vano Judea matan vara nom tamlohi usuri la pa er̃i hite na nom matamata tavera sei ko lo vaira. ");
INSERT INTO tgp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vara tamlohi matea mo opoia vara tamlohi la levosahia, i pa turu na naho tamlohi, i pa sopo jarohi na nona vavahinau. Vara ko lo vai la hinau atu varar̃uhu, mo r̃uhu vara o vai na nom vavahinau na naho tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tasina sohena la sopo lo rasua. ");
INSERT INTO tgp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pani Iesu mo r̃aramira mara, “Noku pongi mo sopo lo mai, pani kamim ka tatamahu na rani tari. ");
INSERT INTO tgp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tamlohi varama la pa sopo tipahi kamim, pani la pa tipahiau matan na lo vereuli na nora sasati la lo vaira. ");
INSERT INTO tgp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kamim hasemim, ha sahe hin hanhani tavera atu. A pa sopo sahe nakerihi matan noku pongi mo sopo lo pala vevuhi.” ");
INSERT INTO tgp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iesu mo vere hinau atu, ale mo lo toho atu Galilee. ");
INSERT INTO tgp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ale tasin Iesu la sahe hin hanhani tavera atu, Iesu mo pa lo sahe hitahu, tea mo sopo levosahia. ");
INSERT INTO tgp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hin hanhani tavera atu tamlohi tatavera nona Jew la lo ale Iesu lara, “Enia nene?” ");
INSERT INTO tgp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Vao tamlohi atu sohena la lo vasvas matana. Hai lara, “Iesu enia tamlohi r̃uhu matea.” Ale hai lara, “Enia mo lo halu na tamlohi.” ");
INSERT INTO tgp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pani tamlohi la matahuni na tamlohi tatavera nona Jew ea, ale la sopo sorahi Iesu na naho vao. ");
INSERT INTO tgp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na sope rani matan hanhani tavera atu, Iesu mo unu na Temple, ale mo tapulo vujangi. ");
INSERT INTO tgp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tamlohi tavera nona Jew la mar̃urahi hinia, ale lara, “Tamlohi nike, mo pa patuha sohena sava? Tea mo sopo vujangia!” ");
INSERT INTO tgp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu mo r̃aramira mara, “Enau na sopo vujangi na sava vara a haseku r̃omr̃omia. Sava na lo vujangia mo tai isan haratu mo lo r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Vara ha pa lo opoia varar̃uhu vara ha oloolo hin God, ha pa levosahia vara enau na lo vujangi na sava mo tai isan God, pani mo sopo isaku haseku. ");
INSERT INTO tgp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Haratu mo opoia vara tamlohi la sile na oloolo isana matan mo lo r̃omr̃omia vara nona retireti mo tai isana hasena enia hapahapa, pani haratu sei mo opoia vara i sile na oloolo isan haratu mo lo r̃ulea, enia tamlohi matea mo lo vere na varar̃uhu, ale mo sopo te hehe isana. ");
INSERT INTO tgp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses mo sile kamim na Leu teni mo vono? Pani mo sopo te vonamim hatea i oloolo hinia! Ka opoia vara ha vilimateiau mata sava?” ");
INSERT INTO tgp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Vao atu la r̃aramia lara, “Ko putu! Sava tanume mo unu hiniho mo vaiho ko r̃omia vara tea mo opoia vara i vilimateiho?” ");
INSERT INTO tgp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu mo r̃aramira mara, “Enau na vai na matamata tavera matea purongo, ale kamim mo isoiso ka mar̃urahi tavera hinia. ");
INSERT INTO tgp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses mo retileu vara ha pa tair̃alihi na natumim, pani retileu atu mo sopo tai isan Moses, mo tai isan pimim tuai atu Abraham, pani nake kamim ka lo tair̃alihi na natumim na Sabbath, ");
INSERT INTO tgp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ale vara ha tair̃alihi te tamlohi hatea na Sabbath matan vara ha pa sopo tope na Leu non Moses, mata sava ka lo lolokoru hiniau matan enau na lo vai na tamlohi rojoa epena tari la mele r̃uhu na Sabbath? ");
INSERT INTO tgp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ha sopo ari na tamlohi na nomim kilakilau purongo! Ha ari na malele tataholo.” ");
INSERT INTO tgp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mara Jerusalem hai, la lo verea lara, “Avei, mo sopo tamlohi nike natu, sei la lo vaihitea vara la pa vilimateia? ");
INSERT INTO tgp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pani enia nahai! Mo lo retireti isana naho vao, pani la sopo vere te hinau hatea isana, la tamlohi tavera nike la toma? Korong la pa hitevosahia vara enia natu, Kr̃isto atu? ");
INSERT INTO tgp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pani tamlohi nike, enr̃a r̃a levosahi na jarana, pani hare i pa levosahi na sava jara Kr̃isto i pa tai hinia?” ");
INSERT INTO tgp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu mo lo vujangi na lolo Temple atu, ale mo ulo mara, “Kamim ka r̃omi vara ka levosahiau, ale sava jara na tai ea. Enau na sopo mai na masaloku. Haratu mo r̃uleau enia mo varar̃uhu, pani kamim ka sopo levosahia. ");
INSERT INTO tgp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pani enau na levosahi haratu mo lo r̃uleau, matan enau na tai isana.” ");
INSERT INTO tgp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tatua tamlohi la vaihitea vara la taurilatia atu natu, pani pongina mo sopo lo masese. ");
INSERT INTO tgp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pani tamlohi matuvana hin vao atu la tau na nora rasua hinia lara, “Avei, vara Kr̃isto atu i pala, ka r̃omi vara enia i pa er̃i vai te matamata tavera i jeu tamlohi nike?” ");
INSERT INTO tgp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisee lara la rongo na vao atu la lo ngutungutu hin Iesu moiso la pulutahi peresi na moli pr̃is, ale la r̃ule na police mata Temple atu vara la taurilatia. ");
INSERT INTO tgp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pani Iesu mo verea isara mara, “Enau a pa mele toho isamim i peravu makomona purongo, moiso enau a pa sahe isan haratu mo lo r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ha pa aleau, pani ha pa sopo er̃i hiteau. Ha pa sopo er̃i vano na jara enau a pa vano ea.” ");
INSERT INTO tgp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ale tamlohi tavera nona Jew la lo usiusira hinia lara, “Enia i pa vano epu vara r̃a pa sopo er̃i tapaia? Korong i pa vano hin te jara tinapua sei nor̃a tamlohi la lo toho ea vara i vujangira peresi na mara Greek teni mo lo verea sohena sava sei?” ");
INSERT INTO tgp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","R̃aramin nona retireti atu, enia sava sei mo verea mara, “Ha pa aleau, pani ha pa sopo hiteau. Ha pa sopo er̃i vano na jara enau a pa vano ea.” ");
INSERT INTO tgp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Isoiso rani matan hanhani tavera atu, enia rani tavera matara, ale Iesu mo turu mo ulo aulu mara, “Vara tea mo mar̃ohu, i mai isaku i inu! ");
INSERT INTO tgp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Vara ha rasuau, i pa sohena Retitapu mo verea mara, ‘Wai mauri i pa roro malue na mapumim sohena wai roro matea’.” ");
INSERT INTO tgp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu mo lo retireti hin Tanume Tapu atu God i pa silea i pa sopo tuai isan la haratu la rasua. God mo sopo lo sile na Tanumena isan tea matan Iesu mo sopo lo turu na nona mateia. ");
INSERT INTO tgp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tatuan vao atu la rongo Iesu mo vere hinau sei, ale lara, “Avei, enia natu, pr̃ovet atu Moses mo lo verea!” ");
INSERT INTO tgp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tatuara lara, “Enia natu, Kr̃isto atu!” Pani tatuara la lo verea vara, “Kr̃isto atu i pa sopo er̃i tai Galilee! ");
INSERT INTO tgp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Retitapu mo sopo verea vara Kr̃isto atu i pa vora na vaon Supe David na vanua Bethlehem?” ");
INSERT INTO tgp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Vao tamlohi atu la tapulo hase asera matan Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tatuara la opoia vara la taurilatia, pani tea mo sopo tau na limana hinia. ");
INSERT INTO tgp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Police mata Temple la mele hilu lekoleko, la vano isana pr̃is tatavera peresi na Pharisee, ale Pharisee la usi na police lara, “Mata sava ka sopo lavi Iesu i mai nike?” ");
INSERT INTO tgp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","La r̃aramira lara, “Tea mo sopo lo vujangi i sohen tamlohi atu.” ");
INSERT INTO tgp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisee la kilau r̃alihi isara, ale lara, “Mo halu kamim sohera? ");
INSERT INTO tgp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Avei, tea hin la haratu la lo tauri na suiha teni te Pharisee la rasua? ");
INSERT INTO tgp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ka levosahia vara la jarar̃oha nike la sopo levosahi te hinau hatea na Leu. La lo toho na ruhuruhu lesati non God moiso.” ");
INSERT INTO tgp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hin rani atu, Nicodemus mo lo toho peresira matan enia mo lo sakele na nora pulutahi, nona tamlohi tatavera atu, enia natu, tamlohi tiroma mo mai isan Iesu. Mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Avei, nor̃a Leu mo vara r̃a sopo er̃i sile na talai isan te tamlohi vavano r̃a sakele r̃a rongo na nona retireti tiroma matan vara r̃a pa levosahi na sava mo vaia.” ");
INSERT INTO tgp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ale la verea isana lara, “Nicodemus, engko ko tai Galilee teni mo vono? O vano o evi na Retiulia! O sopo er̃i hitea vara te pr̃ovet hatea i pa tai Galilee!” ");
INSERT INTO tgp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ale tamlohi tari atu, la mele mule. ");
INSERT INTO tgp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pani Iesu mo hahau mo vano na vutivuti la tovia Vuti talu Olive. ");
INSERT INTO tgp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ale na r̃alavuho jea mo mele vano na Temple. Vao tamlohi la lo mai isana, mo sakele mo pa lo tapulo vujangira. ");
INSERT INTO tgp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ale Pharisee peresi na tamlohi vujangi mata leu la mai isana la taurilati na har̃ai matea la vileia mo lo juruvi peresi na tamlohi matea mo sopo tuana. La vaia mo turu na livuha vao, ");
INSERT INTO tgp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ale la verea isan Iesu lara, “R̃abai, har̃ai nike la taurilatia mo lo vaivaileu peresi na tamlohi matea mo sopo tuana. ");
INSERT INTO tgp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Leu non Moses mo vujangia vara har̃ai sohen haranike la pa parumateia! Pani, engko ko verea sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","La usi retiusia sei matan vara la vaihite Iesu vara sava reti i pa verea, ale la pa tau na talai hinia. Pani Iesu mo rautoho sivo atano, mo tapulo uliuli na varangona na lepa. ");
INSERT INTO tgp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","La lo area hin retiusia sei matan har̃ai atu, moiso mo turu mo verea mara, “Vara te vonamim mo sopo lo vai te hehe hin te rani, enia i parua tiroma!” ");
INSERT INTO tgp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ale mo mele rautoho mo mele uliuli na lepa. ");
INSERT INTO tgp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","La tamlohi atu la rovo hinia hatehateahi, vajiahara la tiroma. Hitahu Iesu enia har̃ai atu purongo la pa lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu mo turu mo usi har̃ai atu mara, “Tamlohi tari la haipu? Mo sopo tea vara i sile na talai isam?” ");
INSERT INTO tgp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Har̃ai atu mo r̃aramia mara, “Mo vono, tija.” Ale Iesu mo verea isana mara, “Enau sohena, a pa sopo sile na talai isam. O vano natu, ale nake o sopo mele vai na hehe!” ");
INSERT INTO tgp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Moiso Iesu mo mele retireti isana tamlohi, mo vere mara, “Enau malarani mata varama! Vara ha usuriau, ha pa sopo hahau na r̃or̃oha, ha pa lavi na malarani sei mo sile na mauri.” ");
INSERT INTO tgp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisee la reti isana lara, “Engko, ko lo vereuliho hasem, ale sava ko lo verea mo sopo varar̃uhu!” ");
INSERT INTO tgp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu mo r̃aramira mara, “Hina purongo vara na lo hase vereuliau, sava na lo verea mo varar̃uhu matan enau na levosahi na jara na tai ea, ale enau na levosahia vara na lo vano epu. Pani kamim ka sopo levosahia vara enau na tai epu teni sava jara na lo vano hinia. ");
INSERT INTO tgp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kamim ka lo ari na tamlohi na kilakilau nona tamlohi purongo, pani enau na sopo ari tea. ");
INSERT INTO tgp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pani vara a sile na aria, aria atu i pa tataholo matan mo sopo enau haseku a pa vaia. Pani enau Tama sei mo lo r̃uleau kama pa turu na jara matelete purongo. ");
INSERT INTO tgp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na nomim Leu la ulia lara, vara tamlohi tupra rua la vere na hinau matelete moiso mo varar̃uhu, o pa er̃i rasua. ");
INSERT INTO tgp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Enau na lo hase retivuhesiau, ale Tama sei mo lo r̃uleau, enia mo lo retivuhesiau.” ");
INSERT INTO tgp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","La usia lara, “Tamam mo lo toho epu?” Iesu mo r̃aramira mara, “Ka sopo levosahiau teni Tamaku! Vara ha pa lo levosahiau ha pa levosahi Tamaku.” ");
INSERT INTO tgp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu mo lo vere la reti atu hin rani atu mo lo vujangi hin jara atu tamlohi la lo tau mamahuni na nora silesilea hinia na Temple. Pani mo sopo tea i taurilatia matan pongina mo sopo lo mai. ");
INSERT INTO tgp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mele vahatea Iesu mo verea isara mara, “Enau a pa malue, ale kamim ha pa aleau, pani kamim ha sopo er̃i vano na jara enau na lo vano ea, moiso kamim ha pa mate na nomim hehe matan God i pa sopo r̃omira.” ");
INSERT INTO tgp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tamlohi tavera nona Jew la usiusira lara, “Avei, mo lo vai na r̃omina vara i pa vilimateia hasena matan enia mara, ‘Ha pa sopo er̃i usuriau ha vano hin jara atu enau na lo vano ea!’ teni sava?” ");
INSERT INTO tgp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu mo r̃aramira mara, “Kamim matan atano, pani enau na tai aulu. Kamim mata varama, pani enau mo vono. ");
INSERT INTO tgp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Na pete verea isamim moiso vara ha pa mate na nomim hehe vara ha sopo rasua vara enau haratu sei mo lo toho jejeu, ha pa mate na nomim hehe.” ");
INSERT INTO tgp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","La usia lara, “Engko hare?” Iesu mo r̃aramira mara, “Sava na lo verea isamim na pete verea isamim moiso na pongi tiroma. ");
INSERT INTO tgp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hinau matuvana a er̃i verea isamim matan vara a ari kamim matana, pani haratu mo lo r̃uleau, enia mo varar̃uhu, ale sava hinau mo lo verea isaku enia natu, na lo verea isana tamlohi na varama.” ");
INSERT INTO tgp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tea mo sopo lo levosahia vara Iesu mo lo vere na hinau matan Tama. ");
INSERT INTO tgp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iesu mo mele verea mara, “Hin pongi atu vara ha tahe Natun Tamlohi, ha pa levosahia vara enau natu, haratu mo lo toho jejeu. Ha pa levosahia vara enau haseku a pa sopo er̃i vai te hinau haseku, na lo vere na sava purongo, Tama mo vujangiau hinia. ");
INSERT INTO tgp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Haratu mo r̃uleau, enia mo lo toho peresiau. Tarea na lo usuri na masalona, ale enia i pa sopo tinar̃ihiau.” ");
INSERT INTO tgp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hin pongi atu Iesu mo lo vere la hinau sei, tamlohi matuvana la tau na nora rasua hinia. ");
INSERT INTO tgp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ale Iesu mo verea isana tamlohi tavera nona Jew atu la rasua ea mara, “Vara ha lo oloolo hin na noku vujangi, ha pa noku tamlohi usuri varar̃uhu, ");
INSERT INTO tgp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ale ha pa levosahi na retivarar̃uhu, moiso retivarar̃uhu atu i pa teri kamim.” ");
INSERT INTO tgp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","La r̃aramia lara, “Kamam mahapin Abraham tataholo! Kama sopo lo slev isan te tamlohi hatea, ko pa verea sohena sava vara kama pa materi?” ");
INSERT INTO tgp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ale Iesu mo r̃aramira mara, “Varar̃uhu na vere kamim hinia, haratu mo lo hehe enia slev non hehe! ");
INSERT INTO tgp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Slev mo sopo toho na lolo vao ima matea jejeu, pani Natuna i pa toho jejeu. ");
INSERT INTO tgp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ale vara Natuna i vai kamim ha materi, ha pa materi varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na levosahia vara kamim mahapin Abraham, pani ka lo opoia vara ha vilimateiau matan noku reti mo sopo toho na maurimim varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Enau na lo vere kamim na sava Tamaku mo vujangiau hinia, mo sohen kamim ka lo vai na sava tamamim mo lo vujangi kamim hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","La tamlohi atu la r̃aramia lara, “Abraham enia tamamam.” Iesu mo r̃aramira mara, “Vara kamim natun Abraham, ha pa vai na sava Abraham mo lo vaia. ");
INSERT INTO tgp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pani kamim ka opoia vara ha vilimateiau matan na lo vere kamim na retivarar̃uhu God mo sileau hinia. Abraham mo sopo vai te hinau sohena. ");
INSERT INTO tgp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pani kamim ka lo vai na hinau tataholo sohen tamamim mo lo vaia.” Ale la r̃aramia lara, “Pani kamam kama sopo natu malele! Kamam tamamam matea purongo, kama natun God!” ");
INSERT INTO tgp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu mo r̃aramira mara, “Vara God enia tamamim, kamim ha pa opoiau matan enau na tai isan God. Enia mo r̃uleau, ale enau na sopo mai na masaloku haseku. ");
INSERT INTO tgp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mata sava ka sopo er̃i levosahi na sava na lo verea isamim? Ka opoia vara ha peropero na sava na lo verea isamim? ");
INSERT INTO tgp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tamamim enia Tiapolo, kamim ka lo vai na masalona. Pongi tiroma enia tamlohi vilimatei na tamlohi, ale enia tamlohi halu. Mo sopo te hinau varar̃uhu hinia. Enia mo lo vere na masalona purongo, ale hinau tari mo verea enira halu. Mo sopo vara enia tamlohi halu purongo, pani enia tina halu. ");
INSERT INTO tgp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pani hinau tari na lo vere kamim hinia la varar̃uhu, pani kamim ka pa lo r̃ohu vara ha rasuau. ");
INSERT INTO tgp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Te vonamim i er̃i verea vara na vai te hehe? Vara na vere na varar̃uhu, ka sopo rasuau mata sava? ");
INSERT INTO tgp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Haratu enia non God i pa tapurongo na nona reti, pani kamim ka r̃ohu vara ha tapurongo matan ka sopo non God.” ");
INSERT INTO tgp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ale tamlohi tavera nona Jew la verea isan Iesu lara, “Kamam kama varar̃uhu hin haratu kama verea vara, engko mara Samaria matea, ale tanume sasati matea mo lo toho hiniho!” ");
INSERT INTO tgp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu mo r̃aramira mara, “Mo sopo te tanume sasati hiniau! Enau na lo oloolo hin Tamaku, pani kamim ka r̃ohu vara ha oloolo hiniau. ");
INSERT INTO tgp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Enau na sopo opoia vara a lavi na oloolo mataku haseku, mo vono, pani matea enia mo opoia vara a lavi na noku oloolo, ale enia natu, haratu i pa sile na aria. ");
INSERT INTO tgp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Varar̃uhu na vere kamim hinia, vara ha oloolo na noku reti, ha pa sopo er̃i mate!” ");
INSERT INTO tgp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tamlohi tavera nona Jew sei la lo toho atu la lo tapurongo hinia lara, “Nake natu, kama levosahia vara tanume sasati matea mo lo toho isam. Abraham mo mate moiso, ale la pr̃ovet atu tuai sohena. Mo sohena sava natu, ko pa verea vara, la haratu la lo oloolo na nom reti, la pa sopo er̃i mate? ");
INSERT INTO tgp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Engko ko aulu ko jeu tamamam Abraham? Enia mo mate, ale la pr̃ovet atu tuai sohena la mate. Engko ko r̃omi vara engko hare?” ");
INSERT INTO tgp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu mo r̃aramira mara, “Vara enau a lo hase tahe hijaku aulu, hijaku i pa sopo aulu varar̃uhu. Tamaku natu, enia mo lo tahe na hijaku aulu, enia haratu kamim ka lo tovia nomim God, ");
INSERT INTO tgp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ka lo verea, pani ka sopo levosahia varar̃uhu. Vara enau a verea vara na sopo levosahia, enau a pa tamlohi halu matea sohemim kamim mo isoiso, pani enau na levosahia, ale na lo vai na sava mo lo verea. ");
INSERT INTO tgp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tamamim Abraham mo avulahi tavera matan mo hite na noku pongi pala, ale mo avulahi matana.” ");
INSERT INTO tgp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ale la tamlohi tavera nona Jew atu la verea isana lara, “Pani engko taunim mo sopo lo tikeli ngavulu lima ! Ko pa hite Abraham sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu mo r̃aramira mara, “Varar̃uhu na verea isamim, Abraham mo sopo lo vora, enau na lo toho moiso, enau haratu mo lo toho jejeu.” ");
INSERT INTO tgp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","La rongo nona reti atu, la vilevilei vatu vara la pa paru Iesu, pani mo luhu hinira, ale mo malue hin Temple atu. ");
INSERT INTO tgp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu mo pa lo hahau, ale hin rani atu mo hite na tamlohi matea mo vora mo matavuso moiso. ");
INSERT INTO tgp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tamlohi usuri non Iesu la usia isana lara, “Avei, Tija, mata sava tamlohi nike mo vora matana mo vuso? Mata nona hehe teni hehe non tamana enia tinana?” ");
INSERT INTO tgp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu mo r̃aramira mara, “Mo vono, mo sopo mata nona hehe teni hehe non tamana teni tinana. Pani matan mo matavuso, ha pa er̃i hite God i vai na matamata tavera hinia. ");
INSERT INTO tgp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nake mo lo rani, r̃a pa vai na masalon haratu mo lo r̃uleau. Pongi mo lo mai, ale i pa sopo tea i er̃i vai te vavahinau hinia. ");
INSERT INTO tgp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ale nakerihi na pa lo toho na varama, enau na malarani mata varama.” ");
INSERT INTO tgp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesu mo vere reti atu moiso, mo litovi na lepa, mo hoi na lepa peresi na litona, ale mo jarai makamaka atu na matan tamlohi atu. ");
INSERT INTO tgp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ale mo verea isana mara, “O vano, o hoje nar̃ihi na lepa na paltungu Siloam!” Tamlohi atu mo vano na paltungu Siloam, r̃aramin hija atu enia ‘Haratu la r̃ulea’. Hin rani atu mo hoje nar̃ihi na lepa moiso mo er̃i kilau, ale mo mule. ");
INSERT INTO tgp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hin rani atu tahisana peresi la haratu la hitea la lo usiusira lara, “Avei, tamlohi sei natu, enia tamlohi sei tarea mo lo sakele mo lo usiusi teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tatuara lara, “Enia natu, tamlohi atu!” Ale tatuara lara, “Mo vono, pani mo sohen tamlohi atu.” Pani tamlohi atu hasena mo verea mara, “Enau sei, tamlohi atu!” ");
INSERT INTO tgp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","La usia lara, “Pani nake, ko pa kilau sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mo r̃aramira mara, “Tamlohi matea hijana Iesu, mo vai na makamaka mo jaraia na mataku, mo r̃uleau vara a vano a hoje nar̃ihia na paltungu Siloam. Vahatea atu na vaia na er̃i kilau.” ");
INSERT INTO tgp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","La usia lara, “Mo lo toho epu nakerihi?” Mo r̃aramira mara, “Na sopo levosahia.” ");
INSERT INTO tgp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Hin rani atu Iesu mo vai tamlohi atu mo r̃uhu na lepa peresi na litona, enia Sabbath matea. Tahisana la lavia mo vano isana Pharisee. ");
INSERT INTO tgp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pharisee la mele usia vara mo pa kilau sohena sava. Tamlohi atu mo r̃aramira mara, “Enia mo jarai na lepa na mataku moiso na hoje nar̃ihia, ale nake na er̃i kilau.” ");
INSERT INTO tgp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tatua Pharisee la verea isana lara, “Tamlohi nike, mo sopo tai isan God matan mo lo tope na Sabbath!” Pani tatuara la verea lara, “Sohena sava natu, tamlohi hehe matea i pa er̃i vai te matamata tavera sohen harihi?” Ale matana, Pharisee la patumasa, ");
INSERT INTO tgp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","la mele usi tamlohi atu lara, “Pani engko ko r̃omia vara tamlohi atu mo vaiho ko kilau, enia hare?” Mo r̃aramira mara, “Enia pr̃ovet matea!” ");
INSERT INTO tgp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pani la tamlohi tatavera atu nona Jew la r̃ohu vara la rasua vara tamlohi sei natu, matana mo matavuso tiroma. Ale, la vahar̃ule matan tamana enia tinana. ");
INSERT INTO tgp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ale, la mai moiso la usira lara, “Haranike natu, enia natumim sei ka verea vara mo vora mo vuso? Sohena sava mo pa kilau nake?” ");
INSERT INTO tgp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tamana enia tinana la r̃aramira lara, “Kama levosahia vara enia natumam, ale kama levosahia vara mo vora mo vuso, ");
INSERT INTO tgp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","pani kama sopo levosahia vara mo pa kilau sohena sava, teni hare mo vaia vara i er̃i kilau. Ha usia isana! Enia mo tamlohi moiso, ale enia hasena i pa verea.” ");
INSERT INTO tgp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Tamana enia tinana la verea sohena matan la matahuni na nora tamlohi tatavera nona Jew. Matan nora tamlohi tatavera la hatihia moiso vara la pa tipahi te tamlohi na nora ima lotu vara la lo verea vara, Iesu enia Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tamlohi tatavera la mele tovi pa tamlohi sei mo vuso tiroma mo mele sinai, la verea isana lara, “O reti tataholo na nahon God vara o pa vere na hinau varar̃uhu! Kama levosahia vara Iesu enia tamlohi hehe matea.” ");
INSERT INTO tgp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tamlohi atu mo r̃aramira mara, “Na sopo levosahia vara enia tamlohi hehe teni mo vono. Na levosahia vara tiroma na vuso, pani nake na kilau.” ");
INSERT INTO tgp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","La usia isana lara, “Mo vai na sava isam? Mo vai mamahuni na matam sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tamlohi atu mo r̃aramira mara, “Na pete verea isamim vahatea moiso, pani ka r̃ohu vara ha tapurongo. Ka opoia vara a mele verea mata sava? Kamim sohena ka opoia vara ha mai na nona tamlohi usuri?” ");
INSERT INTO tgp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","La kalia moiso, ale lara, “Engko nona tamlohi usuri! Kamam tamlohi usuri non Moses! ");
INSERT INTO tgp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kama levosahia vara God mo reti isan Moses, pani kama sopo levosahia vara harakerihi mo tai epu.” ");
INSERT INTO tgp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tamlohi atu mo r̃aramira mara, “Kamim ka tinapua! Tamlohi atu mo vai mamahuni na mataku, pani kamim ka sopo levosahia vara mo tai epu! ");
INSERT INTO tgp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","R̃a levosahia vara God mo lo tueni la haratu la opoia, ale la oloolo hinia. God mo sopo tueni na tamlohi hehe. ");
INSERT INTO tgp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tuai jea na tapulo varama mo tikeli nake hare mo rongoa vara te tamlohi mo mele vai mamahuni te tamlohi mo vora mo vuso vara i kilau. ");
INSERT INTO tgp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Vara tamlohi atu i sopo tai isan God, i pa sopo er̃i vai te hinau hatea sohen harihi.” ");
INSERT INTO tgp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","La r̃aramia lara, “Tarea engko ko tamlohi hehe na rani ko vora mo tikeli nake. Engko ko r̃omr̃omia vara o pa er̃i vujangi kamam hin te hinau hatea?” Ale la pulahi nar̃ihia la tipahia. ");
INSERT INTO tgp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu mo rongo hinau atu mo masese moiso mo vano vara i ale tamlohi atu, ale mo tapaia mo usia mara, “Engko ko rasu na Natun Tamlohi?” ");
INSERT INTO tgp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mo r̃aramia mara, “Moli, vara o vereau hinia vara enia hare, a pa tau na noku rasua hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu mo verea isana mara, “Engko ko hitea moiso, ale nakerihi enia mo lo retireti peresiho.” ");
INSERT INTO tgp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tamlohi atu mara, “Moli, na rasua.” Ale mo papaohi mo lotua. ");
INSERT INTO tgp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Moiso Iesu mo verea mara, “Na mai vara aria i mai na tamlohi na varama. Na mai nike, vara a roi na matavuso la kilau, ale vara a vai la haratu la er̃i kilau, matara la vuso.” ");
INSERT INTO tgp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pharisee la rongo Iesu mo vere hinau atu moiso, la usia lara, “Kamam kama matavuso?” ");
INSERT INTO tgp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu mo r̃aramira mara, “Vara ka vuso i pa sopo te nomim hehe, pani nake matan ka lo verea vara kamim ka lo kilau, kamim ha pa lo toho na nomim hehe.” ");
INSERT INTO tgp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Varar̃uhu na verea isamim, tamlohi vavanaho peresi la haratu la lo vili na tamlohi mata vavanaho, la lo vele palausi na vor̃a vara la unu na jara sipsip, la sopo unu na matarua vor̃a. ");
INSERT INTO tgp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pani haratu mo unu na matarua jara sipsip enia tavui sipsip tataholo. ");
INSERT INTO tgp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tamlohi kilau na matarua atu i pa roi na matarua matan vara tavui sipsip hasena i pa unu, ale sipsip la pa levosahi na leon tavuira moiso enia i tovi na pulana sipsip na hijara hatehateahi moiso i tiromara la malue. ");
INSERT INTO tgp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hin rani atu vara tavui sipsip mo tiroma na pulana sipsip tari vara la malue hin rope sipsip atu, enia mo tiromara, ale la usuria matan la rongovosahi na leona. ");
INSERT INTO tgp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","La pa sopo er̃i usuri te vinano hatea matan la pa sopo rongovosahi na leon vinano atu, pani la pa rovo hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu mo vere titileu atu isara, pani la sopo levosahi na sava mo lo verea isara. ");
INSERT INTO tgp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ale Iesu mo mele verea mara, “Varar̃uhu na verea isamim, enau matarua mata sipsip. ");
INSERT INTO tgp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tamlohi tari la mai tiroma hiniau, enira tamlohi vavanaho peresi la haratu la lo vili na tamlohi mata vavanaho, pani sipsip la pa sopo tapurongo isara. ");
INSERT INTO tgp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Enau matarua. Vara tea i unu hiniau, enia i pa juri, i pa er̃i unu, ale i pa mele malue vara i vilei na r̃uvur̃uvu r̃uhu mata hanhani. ");
INSERT INTO tgp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tamlohi vavanaho mo mai matan vara i pa vanaho i vilimatei, ale i komokomo purongo. Enau na mai vara haratu la unu hiniau, la pa lavi na mauri r̃uhur̃uhu jea. ");
INSERT INTO tgp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Enau tavui r̃uhu mata sipsip. Tavui r̃uhu mata kilau na sipsip mo tau na maurina mata pulana sipsip. ");
INSERT INTO tgp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tamlohi voko mata mania, enira la sopo sohena tavui sipsip matan mo sopo pulara sipsip ale hin rani atu vara la hite na wolf i mai, la pa rovo na sipsip, ale la pa sopo turuhoro na wolf sei enia viriu jala matea mo sati. Wolf i pa komora la rovorovo. ");
INSERT INTO tgp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tamlohi voko la rovo matan la sopo r̃omr̃omia vara la pa kilau na sipsip. ");
INSERT INTO tgp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Enau tavui r̃uhu mata sipsip. Enau na levosahi na pulaku sipsip, enira la levosahiau ");
INSERT INTO tgp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","sohena Tama mo levosahiau, ale enau na levosahi Tama, ale enau na sile na mauriku mata pulaku sipsip. ");
INSERT INTO tgp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tatua pulaku sipsip la sopo lo toho na lolon vor̃a nike. A pa lavira la mai sohera, ale la pa tapurongo na leoku. La pa mai matea, ale tavui sipsip i pa matelete. ");
INSERT INTO tgp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ale Tama mo opoiau matan enau na sile na mauriku matara, ale a pa mele er̃i lavia. ");
INSERT INTO tgp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mo sopo tea i er̃i lavi nar̃ihia isaku, pani enau na silea na masaloku purongo. Enau na lavi na suiha matan vara a silea, ale na lavi na suiha matan vara a mele lavia sohen Tamaku mo retileu vara a vaia.” ");
INSERT INTO tgp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tamlohi tatavera nona Jew atu la mele patumasa mata sava Iesu mo lo verea isara. ");
INSERT INTO tgp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Matuvana lara, “Tanume sati matea mo lo toho hinia! Mo putu! Mata sava ka lo tapurongo isana?” ");
INSERT INTO tgp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pani tatuara lara, “Vara tamlohi matea tanume sasati mo lo toho hinia i pa er̃i vere na hinau sohen harihi sohena sava? I pa sopo te tanume sasati i er̃i vai na matavuso vara i kilau!” ");
INSERT INTO tgp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hin rani atu na taro hamariri, hanhani tavera mata Dedication mo tapulo mata rani turuhi na Temple Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na rani matea Iesu mo lo hahau na lolo Temple hin jara atu la lo tovia Palapalan Solomon na roro ropen Temple atu, ");
INSERT INTO tgp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ale tamlohi tatavera nona Jew la r̃alihia la verea isana lara, “O pa vereuli kamam hiniho pangisa? Vara engko Kr̃isto atu, o vere tataholo kamam hinia!” ");
INSERT INTO tgp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu mo r̃aramira mara, “Na vere isamim moiso, pani ka r̃ohu vara ha rasuau. Hinau na vaira na hijan Tamaku, enira la vujangia vara enau hare. ");
INSERT INTO tgp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pani matan kamim mo sopo pulaku sipsip, ka sopo rasuau. ");
INSERT INTO tgp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Pulaku sipsip la rongovosahi na leoku, enau na levosahira, ale la pa usuriau. ");
INSERT INTO tgp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na silera na mauri tui, ale i pa sopo te hatea i er̃i tihai hin te rani, ale mo sopo tea i er̃i tuahi nar̃ihira na limaku. ");
INSERT INTO tgp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamaku natu, mo silera isaku, ale enia mo aulu jea mo sopo tea i sohena, ale mo sopo tea i er̃i tuahi nar̃ihira na liman Tama, ");
INSERT INTO tgp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ale enau na matea peresi Tama.” ");
INSERT INTO tgp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mele vahatea tamlohi tatavera nona Jew atu la lavi na vatu vara la pa parumatei Iesu hinira. ");
INSERT INTO tgp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pani mo verea isara mara, “Enau na vujangi kamim na hina r̃uhu matuvana Tama mo r̃uleau vara a vaira. Sahara hinira natu, ka opoia vara ha paruau matana?” ");
INSERT INTO tgp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","La tamlohi tatavera nona Jew atu la r̃aramia lara, “Kama sopo paruho matan te hinau r̃uhu ko vaia, pani matan engko tamlohi purongo ko lo hase vaiho ko sohen God matan ko lo retihehe vara engko God!” ");
INSERT INTO tgp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu mo r̃aramia mara, “Na nomim leu la ulia vara, ‘Na verea vara kamim god’. ");
INSERT INTO tgp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ale, kamim ha sopo er̃i tope na Retitapu sei mo verea vara God mo retireti isana tamlohi, ale mo tovira vara enira god. ");
INSERT INTO tgp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ale, mata sava ka lo vere lejilejiau vara na lo retihehe matan na lo verea vara enau Natun God? Pulon hinau sei Tama enia mo tauhasehiau mata masalona vara a pa vai la hinau sei. Enia natu, haratu mo lo r̃uleau na varama. ");
INSERT INTO tgp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Vara a sopo vai la hinau sei Tamaku mo lo vaira, ha sopo rasuau, ");
INSERT INTO tgp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","pani vara a vai na hinau Tama mo lo vaia, hina purongo vara ha sopo rasuau, pani mo r̃uhu vara ha rasu God matan la hina mar̃urahi sei na lo vaira. Matan hinau atu ha pa levosahia varar̃uhu vara Tama enia mo matea peresiau, ale enau na matea peresi Tama.” ");
INSERT INTO tgp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mele vahatea la opoia vara la taurilati Iesu, pani mo majuri na limara, ");
INSERT INTO tgp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ale mo vano roto na wai Jordan hin jara atu John mo lo paptijo ea tiroma. Hin rani atu Iesu mo lo toho atu, ");
INSERT INTO tgp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tamlohi matuvana la mai isana. La lo verea lara, “John mo sopo vai te matamata tavera hatea, pani hinau tari mo verea matan Iesu, enira la varar̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tamlohi matuvana la tau na nora rasua hin Iesu hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Tamlohi matea hijana Lazarus, mo rojo na vanuan Bethany. Vetasina mo rua, Mary enia Martha la lo toho peresia. Mary enia har̃ai atu sei mo lo surei na hasori na palon Moli peresi na patuna, ale mo kamoti na palona na vuluna. ");
INSERT INTO tgp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Vetasin Lazarus la sohai na reti isana lara, “Tija, tapalam r̃uhu sei Lazarus mo rojo tavera.” ");
INSERT INTO tgp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hin rani atu Iesu mo rongoa, mo verea mara, “Rojo atu, i pa sopo isoiso na mate, pani i pa sile na oloolo isan God, ale Natuna i pa lavi na oloolo matan haratu i pa vaia.” ");
INSERT INTO tgp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu mo opoi Martha enia vetasina peresi Lazarus. ");
INSERT INTO tgp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ale matan mo rongo vara mo rojo Iesu mo mele toho atu rani mo rua. ");
INSERT INTO tgp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hitahun haratu, mo verea isana nona tamlohi usuri mara, “Nake r̃a mele sahe Judea.” ");
INSERT INTO tgp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nona tamlohi usuri la r̃aramia lara, “Tija, mo r̃uhu, pani mo sopo tuai sei tamlohi tatavera atu nona Jew la opoia vara la pa parumateiho! Avei, ko opoia vara o pa mele vano atu?” ");
INSERT INTO tgp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu mo r̃aramia mara, “Matan alo mo visa na rani matea? Ka levosahia vara mo sangavulu r̃omana mo rua . Vara o hahau na rani o pa hite na mera alo, ale o pa sopo tialahalaha. ");
INSERT INTO tgp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pani vara o hahau na vutepongi o pa tialahalaha matan mo sopo te mera hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ale mo verea isara mara, “Tapalar̃a Lazarus mo lo juruvi, pani enau a pa vano vara a pa r̃ohaia.” ");
INSERT INTO tgp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nona tamlohi usuri la r̃aramia lara, “Tija, vara enia mo lo juruvi, enia i pa mele rongo i r̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu mo levosahia vara Lazarus mo mate, pani enira la lo r̃omr̃omia vara enia mo lo verea vara mo lo juruvi r̃omaliho purongo. ");
INSERT INTO tgp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Moiso Iesu mo vere tataholoia isara mara, “Lazarus mo mate, ");
INSERT INTO tgp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","na avulahi matamim matan na sopo toho atu matan nake masapa matea vara ha pa tau na nomim rasua hiniau, r̃a vano isana!” ");
INSERT INTO tgp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ale Thomas sei la lo tovia Havo, mo verea isan tamlohi usuri tinapua non Iesu atu mara, “Eh! Ha turu, r̃a vano! Enr̃a r̃a vano vara r̃a pa tolu mate peresi Moli.” ");
INSERT INTO tgp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na rani Iesu mo kakau Bethany, mo rongoa vara Lazarus la taua na papavatu rani mo vati moiso. ");
INSERT INTO tgp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Taon sei Bethany mo lo toho mariviti kilometre mo tolu, ale mele sopena asau hin Jerusalem, ");
INSERT INTO tgp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ale tamlohi tatavera nona Jew matuvana la mai isan Martha enia Mary, vara la tangtangi peresira matan tavaira mo tihai. ");
INSERT INTO tgp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Vahatea atu Martha mo rongoa vara Iesu mo pala, mo malue vano vara i tapaia, pani Mary mo lo toho na ima. ");
INSERT INTO tgp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha mo verea isan Iesu mara, “Tija, vara o pa lo toho nike tavaiku i pa sopo mate, ");
INSERT INTO tgp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","pani hina purongo hin haratu matan na levosahia vara God i pa vai na sava hinau vara o usia.” ");
INSERT INTO tgp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu mo verea isana mara, “Tavaim i pa mele mauri!” ");
INSERT INTO tgp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha mo r̃aramia mara, “Na levosahia vara i pa mele mauri na pongi hitahu hin rani atu vara tamlohi mate la mele turu.” ");
INSERT INTO tgp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu mo verea mara, “Enau pulo mauri, ale enau na sauteterahi na mateia, matan la haratu la rasuau la pa mauri, hina purongo vara la pa mate. ");
INSERT INTO tgp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Moiso la haratu la rasuau, la pa lo mauri, la pa sopo er̃i mate varar̃uhu. Martha, ko rasu hinau sei?” ");
INSERT INTO tgp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha mo r̃aramia mara, “He'e Moli! Na lo rasua vara engko natu, Kr̃isto, Natun God. Engko haratu kama lo kilau toho matana vara i pa mai na varama!” ");
INSERT INTO tgp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha mo retireti isan Iesu, moiso mo mele hilu vara i vere malumia isan Mary mara, “Tija mo mai, mo opoia vara i hiteho.” ");
INSERT INTO tgp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary mo rongoa, vahatea mo turu mo malue, mo vano isana. ");
INSERT INTO tgp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu mo sopo lo unu na vanua, mo pa lo toho hin jara atu Martha mo tapaia ea. ");
INSERT INTO tgp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na rani tamlohi tatavera nona Jew matuvana la lo nanau Mary na lolo ima, la hitea mo malue vilavila, ale la lo r̃omr̃omia vara mo vano vara i tangtangi na papa, ale la usuria. ");
INSERT INTO tgp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary mo vano hin jara atu Iesu mo lo toho ea. Mo hitea, ale vahatea mo papaohi na palona, mo verea mara, “Moli, vara o pa lo toho nike, tavaiku i pa sopo mate.” ");
INSERT INTO tgp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na rani Iesu mo hite Mary tolu na tamlohi tavera nona Jew la lo tangtangi, enia mo rongo mo sati hajavua. ");
INSERT INTO tgp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iesu mo usia mara, “Ka tau na tarapena epu?” La r̃aramia lara, “Moli, o mai vara o pa hitea.” ");
INSERT INTO tgp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu mo tangi. ");
INSERT INTO tgp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ale tamlohi tavera nona Jew lara, “Ka hitea, mo r̃omia mo tavera.” ");
INSERT INTO tgp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pani tatuara la verea lara, “Enia mo vai na vuso mo mele kilau, pani mo sopo er̃i vai Lazarus vara i sopo mate mata sava?” ");
INSERT INTO tgp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu mo mele r̃omia hajavua, ale mo vano na papa, enia papa matea la kuresi na vatu matea mo lo turuhoro na mataruana. ");
INSERT INTO tgp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu mo verera mara, “Ha kuresi nar̃ihi vatu sei!” Pani Martha mo verea mara, “Tija, engko ko levosahia vara nahapani enia havati pongin Lazarus, ale i pa ponaha.” ");
INSERT INTO tgp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesu mo r̃aramia mara, “Na verea isamim moiso, vara ha rasuau, ha pa hite na hina r̃uhur̃uhu matea na suihan God.” ");
INSERT INTO tgp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ale la kuresi nar̃ihi vatu atu, ale Iesu mo tar̃a sahe na tuka mo usiusi mara, “Tamaku, na vere meje isam matan ko lo tapurongo isaku. ");
INSERT INTO tgp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na levosahia vara tarea ko lo r̃arami na noku usiusi, pani na vere hinau nike, vara la tamlohi nike la pa rasua vara engko ko r̃uleau.” ");
INSERT INTO tgp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesu mo usiusi moiso, mo ulo mara, “Lazarus, o malue!” ");
INSERT INTO tgp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tamlohi atu mo mate moiso, mo malue hin papa atu. Limana peresi na palona la pesira na tavalu ruru lulu, la tavu na nahona na tavalu ruru matea. Iesu mo vere isana tamlohi mara, “Ha uli nar̃ihia vara i malue.” ");
INSERT INTO tgp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ale Jew matuvana la lo toho peresi Mary atu, la rasu Iesu matan la hite hinau atu mo vaia ea. ");
INSERT INTO tgp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pani tatuara la vano la hite na Pharisee, la vereuli na sava Iesu mo vaia isara. ");
INSERT INTO tgp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Moiso moli mata pr̃is tolu na Pharisee la tovi na matavuhi matea, la verea lara, “R̃a pa vai na sava? Tamlohi nike, mo vai na matamata tavera matuvana. ");
INSERT INTO tgp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Vara r̃a sopo horoa nakerihi, tamlohi tari la pa tau na nora rasua hinia. Vara i sohena mara Rome la pa mai la komo na nor̃a Temple tapu peresi na nor̃a tamlohi jara mo isoiso.” ");
INSERT INTO tgp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Vonara matea, Caiaphas enia pr̃is aulu hin tauni atu mo verea mara, “Ka sopo levosahi te hinau hatea, ");
INSERT INTO tgp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ka sopo hitevosahia vara i pa mele r̃uhu vara tamlohi matelete purongo i mate matan la tamlohi tari nike, mo jeu haratu vara tamlohi jara mo isoiso hin Israel la mate!” ");
INSERT INTO tgp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caiaphas mo sopo vere hinau sei hasena, pani matan hin tauni atu enia pr̃is aulu, ale mo lo retimangovia sohen God mo opoia vara Iesu i pa mate mata tamlohi jara tari hin Israel, ");
INSERT INTO tgp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","pani i pa sopo mate mata tamlohi jara tari hin Israel hasena, i pa mate mata tamlohi tari sei la natun God na sava jara la lo toho ea la pa mai matea. ");
INSERT INTO tgp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mo tapulo hin pongi atu vao atu la hatihia vara la pa vilimatei Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Matan hinau atu Iesu mo sopo mele hahau na jara tavera isana tamlohi tatavera nona Jew, pani mo vano asau na taon Ephraim enia mariviti na jara hasetoho tavera atu, ale mo lo toho atu peresi na nona tamlohi usuri. ");
INSERT INTO tgp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Rani Passover nona Jew mo lo mai mariviti. Tamlohi matuvana la lo toho r̃alihi hin jara atu la vano Jerusalem matan vara la vai na nora posposi mata onehi na hinahinau mata Passover. ");
INSERT INTO tgp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","La lo ale Iesu r̃alihi ea. Ale hin rani atu la lo toho na Temple la lo usiusira lara, “Avei, ka levosahia vara i pa mai mata hanhani tavera mata Passover teni i vono?” ");
INSERT INTO tgp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Haratu la moli mata pr̃is tolu na Pharisee la verea isana tamlohi lara vara la hite Iesu, la pa vereulia isara vara la pa taurilatia. ");
INSERT INTO tgp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Rani mo limarave mo lo toho vara i tikeli na rani Passover. Iesu mo mele sivo Bethany, taon atu sei Iesu mo lo vai Lazarus mo lo turu na mateia ea. ");
INSERT INTO tgp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","La tatamahu na hanhani matan Iesu. Martha natu, mo lo julai na hanhani, ale Lazarus enia vonara matea hin la haratu la lo sakele peresia atu. ");
INSERT INTO tgp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ale Mary mo lavi na potele hasori r̃uhu matea sohena sope lita matea, ale volina mo tavera jea, ale mo rengia na palon Iesu, ale mo kamotira na vuluna, ale ponana r̃uhu mo mar̃ivisi na lolo ima. ");
INSERT INTO tgp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tamlohi usuri non Iesu matea, hijana Judas Iscariot mo lo toho atu. Enia natu, i pa turuposi hin Iesu hitahu, ale mo usia mara, ");
INSERT INTO tgp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mata sava mo sopo har̃ehi hasori sei matan volina mo tataholo na voli tamlohi voko mata tauni matea, ale mania atu i pa er̃i vano isana tamlohi la tilavono?” ");
INSERT INTO tgp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pani Judas mo sopo r̃omi na tamlohi tilavono matan enia mo lo lavi na nora tanga mania, ale enia tamlohi vavanaho matea, ale hin te rani i pa vanaho hinia. ");
INSERT INTO tgp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iesu mo verea mara, “Ha sopo hitesatihia! Enia mo tauhasehia mata noku tavun. ");
INSERT INTO tgp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tamlohi tilavono la lo toho peresi kamim tarea, pani enau a pa sopo toho peresi kamim tarea.” ");
INSERT INTO tgp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na rani vao tamlohi tavera nona Jew atu la levosahia vara Iesu mo lo toho atu. La sopo opoia vara la hite Iesu hasena, pani vara la hite Lazarus sohena matan Iesu mo vaia mo mele turu na mateia. ");
INSERT INTO tgp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ale moli mata pr̃is la tau na r̃omira vara la pa vilimatei Lazarus, ");
INSERT INTO tgp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","matan la hite na Jew matuvana la lo rovo hinira, ale la lo tau na nora rasua hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Rani tinapua mo mele sahe, vao tavera la lo mai Jerusalem mata hanhani tavera mata Passover. Pa vao atu la rongoa vara Iesu i pa mai matan hanhani tavera atu moiso, ");
INSERT INTO tgp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","la lavi na rau viniu, ale la vano vara la tapaia. La lo ulo lara, ‘Moli, o juri nakerihi!’ ‘God o ler̃uhu hin haratu mo lo mai na hijan Moli God!’ ‘God o ler̃uhu na Supe non Israel!’ ");
INSERT INTO tgp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu mo vilei na natu donki matea, ale mo vele hinia sohena Retiulia mo verea, ");
INSERT INTO tgp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘Ha sopo matahu kamim tamlohi hin Zion, Nomim supe mo lo mai na har̃i natu donki.’ ");
INSERT INTO tgp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tiroma, tamlohi usuri non Iesu la sopo levosahia, pani la pa mele r̃omr̃omia hin pongi atu mo turu na nona mateia mo sahe na tuka. Hinau tari la masese la tataholo hin haratu la ulia na Retiulia vara la pa sohena. ");
INSERT INTO tgp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ale vao atu la pa lo toho peresi Iesu hin rani atu mo tovi Lazarus mo malue na papa, ale la lo sorahia. ");
INSERT INTO tgp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ale vao atu la tapaia matan la rongo matamata tavera atu mo lo vaia. ");
INSERT INTO tgp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pani Pharisee la lo vereverera hinia lara, “R̃a sopo er̃i vai te hinau hatea! Tamlohi tari na varama la lo usuri Iesu.” ");
INSERT INTO tgp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mara Greek hai tolu na tamlohi la sahe Jerusalem vara la lotu na rani mata Passover. ");
INSERT INTO tgp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Philip sohena, mara Bethsaida na jara Galilee mo lo toho ea. Mara Greek la vano isana la usia lara, “Tapala, kama opoia vara kama tapai Iesu.” ");
INSERT INTO tgp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip mo verea isan Andrew, ale enira tupra rua la vano isan Iesu la verea isana. ");
INSERT INTO tgp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu mo r̃aramia mara, “Pongi tataholo mo pala vara Natun Tamlohi i lavi na nona oloolo tavera. ");
INSERT INTO tgp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Varar̃uhu na verea isamim, vara piri wit matea i sopo jovi na lepa i mate atu, i pa sopo ulua, i pa lo toho atu purongo, pani vara i jovi i mate na lepa i pa er̃i ulua, ale i pa sile na vuana i mar̃ivi. ");
INSERT INTO tgp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Vara tea mo opoi na maurina, i pa vaitihaia. Vara i r̃ohu na maurina nake na varama enia i pa taurilatia pongi tui tui. ");
INSERT INTO tgp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Vara tea mo volitusi noku enia i pa usuriau. Noku volitusi i pa toho peresiau na sava jara enau na lo toho ea. Vara tea mo volitusi Tama i pa sile na oloolo isana. ");
INSERT INTO tgp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nake r̃omiku mo puhoni hajavua. A pa vere na sava? A pa vere vara, ‘Tamaku o juriau hin rani r̃ilangi sei?’ Pani mo vono, matan na lo mai na varama matan rani r̃ilangi sei. ");
INSERT INTO tgp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamaku, o tahe na hijam aulu.” Ale leo matea mo tai na tuka mo verea mara, “Enau na pete tahe na hijaku aulu moiso, ale a pa mele tahea aulu.” ");
INSERT INTO tgp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Vao tamlohi la lo turu atu la rongo leo atu, pani hai la lo r̃omr̃omia vara mo piri, hai la lo r̃omr̃omia vara angelo matea mo lo retireti isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Moiso, Iesu mo verera mara, “Leo atu mo sopo mai mataku, pani matamim. ");
INSERT INTO tgp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nake aria varama mo lo tapulo. Nake God mo tapulo vara i tipahi tamlohi tavera sasati atu matan varama nike. ");
INSERT INTO tgp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hin pongi atu vara la taheau aulu na lepa, a pa vai na tamlohi tari vara la mai isaku.” ");
INSERT INTO tgp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu mo lo vereulia vara i pa mate sohena sava. ");
INSERT INTO tgp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Vao tamlohi atu la verea isana lara, “Retiulia mo vujangia vara Kr̃isto atu enia i pa toho jejeu. Mo sohena sava natu, engko ko lo verea vara la pa tahe Natun Tamlohi aulu? Hare natu, enia Natun Tamlohi atu ko lo verea?” ");
INSERT INTO tgp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iesu mo r̃aramira mara, “Malarani i pa toho isamim mata makomo rani purongo. Ha hahau na merana matan nake mo lo rani, pani haratu mo lo hahau na r̃or̃oha i pa sopo levosahi na sava jara mo lo vano ea. ");
INSERT INTO tgp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ha rasu na malarani nake mo lo toho peresi kamim, ale kamim ha pa natu malarani!” Hitahun la hinau atu Iesu mo lo verera, mo malue mo vano mo sopo mele hahau na naho vao. ");
INSERT INTO tgp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hina purongo vara Iesu mo vai na matamata tavera matuvana na nahora, pani tamlohi la sopo tau na nora rasua hinia, ");
INSERT INTO tgp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","hinau sei mo masese sohena retireti non pr̃ovet Isaiah mo verea mara, ‘Moli God, hare mo rasu na nomam reti? Hare mo levosahi na suiha tavera non Moli God?’ ");
INSERT INTO tgp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Matan retireti sei, tamlohi la sopo er̃i rasua, matan Isaiah mo mele verea mara, ‘Enia mo vaira la matavuso, ale mo vai na mapura la r̃ilangi matan vara la pa sopo er̃i kilau na matara, ale vara la sopo er̃i levosahi na r̃omira, vara la pa posi mai isaku — matan vara enau a pa vaira la r̃uhu.’ ");
INSERT INTO tgp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah mo vere la hinau sei matan mo hitea vara Tamlohi Jujuri mo r̃uhur̃uhu jea sohena sava, ale mo vereulia. ");
INSERT INTO tgp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hina purongo hin haratu, tamlohi tauri na suiha nona Jew matuvana la rasua, pani matan la matahuni na Pharisee enira la sopo taviti na nora rasua hinia matan vara la verea, ale Pharisee la pa tipahira na nora ima lotu. ");
INSERT INTO tgp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Matan enira la r̃omr̃omi na hasohaso nona tamlohi mo jeu hasohaso atu God mo lo silea. ");
INSERT INTO tgp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pani Iesu mo ulo aulu mara, “Vara te tamlohi mo rasuau, mo sopo rasuau haseku, pani mo rasu haratu mo lo r̃uleau, ");
INSERT INTO tgp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","haratu mo hiteau, enia mo hite haratu mo lo r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Enau na mai na varama sohena malarani vara tamlohi tari la rasuau, la pa sopo mele toho na r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Enau mo sopo haratu sei i pa ari la haratu la sopo oloolo na noku vujangi. Enau na mai vara a juri na tamlohi hin varama nike, na sopo mai vara a sile na talai. ");
INSERT INTO tgp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pani na verea vara la haratu la lo r̃ohu hiniau peresi na noku vujangi vara nora hina aria mo lo toho moiso, na sava na verera moiso enira natu, la pa arira na pongi hitahu. ");
INSERT INTO tgp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na sopo retireti haseku, pani na lo vere na sava Tama sei mo lo r̃uleau mo retileu isaku vara a verea. ");
INSERT INTO tgp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Matan na levosahia vara vua nona retileu sei la pa sile na mauri tui, ale na lo vere tataholoi na sava Tama mo vereau hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ale rani mo tiroma na rani Passover mo lo mai, Iesu mo levosahia vara nona rani mo mai vara i malue na varama, ale vara i mele hilu sahe isan Tamana. Tarea mo lo opoi na nona tamlohi na rani mo lo toho hin varama nike, mo opoira mo tikeli na isoisona. ");
INSERT INTO tgp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","La pa lo hanhani na ravravi, Tiapolo mo posi na r̃omin Judas natun Simon Iscariot, vara i turuposi hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu mo levosahia vara Tama mo tau na hinau tari na limana, Iesu mo levosahia vara enia mo tai isan God, ale vara i pa mele sahe isan God, ale matan haratu, ");
INSERT INTO tgp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Iesu mo turu hin hanhani atu, mo lavi nar̃ihi na ruruna matea, ale mo lavi na ruru kamoti mo talihia na otiotina, ");
INSERT INTO tgp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ale mo tau na wai na pesin tavera matea moiso mo tapulo hoje na palo nona tamlohi usuri, ale mo kamotira peresi ruru kamoti atu mo lo talihia hinia. ");
INSERT INTO tgp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pani hin masapa atu Iesu mara i hoje na palon Simon Peter, Peter mo usia mara, “Tija, mata sava ko opoia vara o hoje na paloku?” ");
INSERT INTO tgp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu mo r̃aramia mara, “Nake engko ko sopo hitevosahi na sava na lo vaia, pani hitahu, o pa levosahia.” ");
INSERT INTO tgp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter mo verea mara, “Mo vono! Engko o pa sopo er̃i hoje na paloku hin te rani!” Iesu mo verea isana mara, “Vara a sopo hojeho, engko o pa sopo noku!” ");
INSERT INTO tgp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ale Simon Peter mo verea mara, “Tija, o sopo hoje na paloku purongo, pani limaku peresi na patuku sohena!” ");
INSERT INTO tgp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu mo r̃aramia mara, “Isan la haratu la loloso moiso, epera la vokevoke vevuhi moiso, la pa hoje na palora purongo. Ale kamim ka vokevoke moiso, pani vonamim matea mo vono.” ");
INSERT INTO tgp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu mo levosahia vara hare natu i pa turuposi hinia hin haratu mo verea mara, ‘vonamim matea.’ ");
INSERT INTO tgp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hitahun haratu Iesu mo hoje na palo nona tamlohi moiso, mo mele ru na nona ruru, ale mo mele sakele. Mo verea isara mara, “Ka levosahi na sava hinau na lo vaia matamim? ");
INSERT INTO tgp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ka lo toviau nomim tija, ale nomim tamlohi tavera. Haratu ka verea mo tataholo, matan ka lo retivarar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Vara enau na hoje na palomim, pani enau nomim tamlohi tavera, ale nomim tija, mo r̃uhu vara ha hojehoje na palomim isamim hasemim. ");
INSERT INTO tgp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Enau na lo vai na tovongi matea isamim, mo r̃uhu vara ha vaia isamim sohen enau na vaia isamim. ");
INSERT INTO tgp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Varar̃uhu na verea isamim vara slev la sopo aulu na nora tamlohi tavera moiso vahar̃ule la sopo aulu hin la haratu la lo r̃ulera. ");
INSERT INTO tgp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Vara ka levosahi la hinau sei moiso, God i pa ler̃uhu hin kamim vara ha vaira. ");
INSERT INTO tgp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na sopo retireti hin kamim mo isoiso. Na levosahi la haratu na vir̃onira moiso, pani matan vara sava hinau sei Retitapu mo lo verea i masese, mo verea mara, ‘Tamlohi atu mo lo hanhani peresiau, mo pete turuposi hiniau moiso!’ ");
INSERT INTO tgp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Na lo vere kamim hinia tiroma moiso i pa masese matan hin pongi atu vara i masese ha pa rasua vara enau natu, haratu mo lo toho jejeu. ");
INSERT INTO tgp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Varar̃uhu na verea isamim, vara tea mo lavi na noku vahar̃ule, enia mo lo laviau, vara tea mo laviau, enia mo lavi haratu mo lo r̃uleau.” ");
INSERT INTO tgp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu mo vere la haratu moiso, mo rongo r̃omina mo puhoni hajavua, mo verea isana nona tamlohi mara, “Varar̃uhu na verea isamim, vonamim matea i pa turuposi hiniau!” ");
INSERT INTO tgp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nona tamlohi usuri la lo hase kilakilaura matan la sopo levosahia vara mo lo vere hare. ");
INSERT INTO tgp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tamlohi usuri non Iesu matea mo olo vano na r̃uman Iesu hin hanhani atu, ale tamlohi atu natu Iesu mo opoia, ");
INSERT INTO tgp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","moiso Simon Peter mo tianaho na patuna isana vara i usia isan Iesu vara mo lo vere hare. ");
INSERT INTO tgp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ale nona tamlohi usuri atu mo olo vano na ruman Iesu, ale mo usia mara, “Tija, hare natu?” ");
INSERT INTO tgp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu mo r̃aramia mara, “A pa seri na tavalu pereti na wai pihi, ale a pa silea isana.” Moiso Iesu mo seri tavalu pereti atu mo silea isan Judas, natun Simon Iscariot. ");
INSERT INTO tgp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Vahatea purongo, Setan mo unu hin Judas. Iesu mo verea mara, “Judas, o vano o vai na sava ko opoi vara o pa vaia vila!” ");
INSERT INTO tgp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Te vonara mo sopo levosahi na r̃aramin reti atu Iesu mo lo verea isana. ");
INSERT INTO tgp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pani matan Judas mo lo tauri na tanga mania, hai la lo r̃omr̃omia vara Iesu mo lo r̃ulea vara i voli te hinau mata hanhani, hai la lo r̃omr̃omia vara Iesu mo r̃ulea vara i sile te mania isan la haratu la tilavono. ");
INSERT INTO tgp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas mo lavi tavalu pereti atu, ale mo malue vahatea. Mo r̃or̃oha moiso. ");
INSERT INTO tgp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas mo vano moiso, ale Iesu mo verea mara, “Nake God mo lo tahe na hijan Natun Tamlohi, ale enia i pa tahe na hijan God matana. ");
INSERT INTO tgp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Vara maurin Natun Tamlohi mo tahe na hijan God, God i pa hase tahe na hijana aulu vahatea. ");
INSERT INTO tgp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na natuku, enau a pa mele toho peresi kamim mata makomo rani. Ha pa aleau, pani ha pa sopo er̃i hiteau. Na lo vere isamim sohen haratu na pete verea isana tamlohi tavera nona Jew moiso nara, ‘Ha pa sopo er̃i vano hin jara atu enau na lo vano ea’. ");
INSERT INTO tgp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pani nake, na lo sile na retileu paro matea isamim. Ha pa opoiopoi kamim hatehateahi sohen enau na lo opoi kamim. ");
INSERT INTO tgp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Vara ha opoiopoi kamim, tamlohi tari la pa hitea la pa levosahia vara kamim ka noku tamlohi usuri varar̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter mo usia mara, “Tija, engko ko lo vano epu?” Iesu mo r̃aramia mara, “Nake o pa sopo er̃i usuriau na jara na lo vano ea, pani hitahu o pa usuriau.” ");
INSERT INTO tgp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter mo usia mara, “Tija, mata sava a sopo er̃i usuriho nakerihi? A er̃i mate matam!” ");
INSERT INTO tgp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu mo usia mara, “O er̃i mate mataku? Varar̃uhu na verea isam, engko o pa vunvuniau vaha tolu, moiso toa vari i pa tarere.” ");
INSERT INTO tgp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu mo verea isana nona tamlohi usuri mara, “Ha sopo matahu! Ha rasu God, ale ha rasuau sohena, ");
INSERT INTO tgp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","matan na iman Tamaku jara matuvana la lo toho ea. A pa sopo vereuli kamim hinia vara mo sopo varar̃uhu. A pa sahe vara a tatamahuni na jara matamim. ");
INSERT INTO tgp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Vara a tatamahunia i isoiso, a pa mele mai, a pa lavi kamim vara na sava jara na lo toho ea, kamim sohena ha pa toho ea. ");
INSERT INTO tgp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kamim ka levosahi na malelen jara atu enau na lo vano ea.” ");
INSERT INTO tgp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas mo verea mara, “Tija, kama sopo levosahi na jara ko lo vano ea. Kama pa levosahi na malele sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu mo verea mara, “Enau malele varar̃uhu, enau pulo hina varar̃uhu, enau pulo mauri! Vara i sopo mataku, te vonamim i pa sopo er̃i sahe isan Tama. ");
INSERT INTO tgp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Vara ha pa lo levosahiau, ha pa levosahi Tama, ale mo tapulo nake ka levosahia, ale ka hitea moiso.” ");
INSERT INTO tgp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip mo verea isana mara, “Tija, o vujangi kamam hin Tama! Haratu purongo kama opoia.” ");
INSERT INTO tgp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu mo r̃aramia mara, “Philip, na lo toho peresi kamim mo tuai moiso. Kamim ka sopo lo levosahia vara enau hare? Vara ka hiteau, ka hite Tama. Mo sohena sava natu, ka lo usia vara a vujangi kamim hin Tama? ");
INSERT INTO tgp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ka sopo rasua vara enau na matea peresi Tama, ale Tama enia mo matea peresiau? Sava na lo verea na sopo verea haseku. Tama sei mo lo toho hiniau, mo lo vai la nona matamata r̃uhur̃uhu atu. ");
INSERT INTO tgp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ha rasuau hin haratu na verea vara Tama enia mo matea peresiau, ale enau na matea peresi Tama. Pani vara i vono, ha rasu mata vavahinau hasera purongo. ");
INSERT INTO tgp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Varar̃uhu na verea isamim, vara ha rasuau, ha pa er̃i vai na sava hinau na lo vaira. Ha pa vai na hinau la pa jeuau, matan nake na lo mele hilu sahe isan Tama. ");
INSERT INTO tgp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ha usiau, ale enau a pa vai na sava ka usia na hijaku matan vara Natuna i pa sile na oloolo i sahe isan Tama. ");
INSERT INTO tgp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Vara ha usi te hinau na hijaku, a pa vaia.” ");
INSERT INTO tgp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Iesu mo verea isana nona tamlohi usuri mara, “Vara ha opoiau, ha pa vai na sava na lo retileu hinira. ");
INSERT INTO tgp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ale, a pa usi Tama vara i mele r̃ule na meramim matea isamim, i pa toho peresi kamim tui tui, ");
INSERT INTO tgp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","meramim atu enia Tanumena, ale i pa vujangi na hina varar̃uhu hin God. Tamlohi na varama la pa sopo er̃i lavi na Tanumena matan la pa sopo er̃i hitea teni la levosahia. Pani kamim ka levosahi na Tanumena matan enia mo lo toho peresi kamim, i pa lo toho hin kamim. ");
INSERT INTO tgp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","A pa sopo rovo hin kamim sohena natu mar̃ua, pani a pa mai isamim. ");
INSERT INTO tgp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","I pa sopo tuai, tamlohi varama la pa sopo er̃i mele hiteau, pani kamim ha pa hiteau, ale matan enau a pa mauri, kamim ha pa mauri. ");
INSERT INTO tgp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hin pongi atu ha pa levosahia vara enau na matea peresi Tama. Ha pa levosahia vara kamim ka matea peresiau, ale enau na matea peresi kamim. ");
INSERT INTO tgp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Haratu mo lavi na noku retileu, ale mo oloolo hinira enia haratu mo opoiau, ale Tamaku i pa opoia, ale enau sohena a pa opoia, ale a pa hase vujangiau isana.” ");
INSERT INTO tgp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Moiso Judas, mo sopo Judas Iscariot, mo reti mo usia mara, “Tija, r̃aramin nom reti sei vara o pa vujangiho isamam, pani i pa sopo isana tamlohi varama, enia sava?” ");
INSERT INTO tgp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu mo r̃aramia mara, “Vara tea mo opoiau, i pa oloolo hina noku reti, moiso Tamaku i pa opoia, kama pa mai isana, kama pa toho hinia. ");
INSERT INTO tgp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pani haratu mo sopo opoiau, mo sopo oloolo hina noku reti. Sava reti ka rongo na verea, la sopo noku, pani non Tamaku sei mo lo r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na lo vere kamim hin la hinau sei nake matan na pa lo toho peresi kamim. ");
INSERT INTO tgp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pani Tuetueni r̃uhu atu i pa mai, enia Tanume Tapu, Tama i pa r̃ulea i lavi na jaraku, enia i pa vujangi kamim na hinau tari, ale i pa vai kamim ha mele r̃omr̃omi na hinau tari na lo verea isamim moiso. ");
INSERT INTO tgp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na lo sile kamim na tamata, noku tamata atu, enau haseku a er̃i silea, mo sopo sohena tamata varama nike i er̃i silea. Ale ha sopo r̃omkaka, ha sopo matahu. ");
INSERT INTO tgp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ka pete rongoa, na verea isamim moiso vara a pa vano, ale a pa mele mai isamim. Vara ka opoiau varar̃uhu, ha pa avulahi matan enau na lo sahe isan Tama, matan Tama enia mo aulu jea hiniau. ");
INSERT INTO tgp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na lo vere la hinau nike tiroma isamim matan vara pongi atu vara i masese ha pa rasuau. ");
INSERT INTO tgp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A sopo er̃i retireti peravu isamim matan tamlohi tavera sasati matan varama nike mo lo mai, pani enia mo sopo lavi te suiha vara i aulu hiniau. ");
INSERT INTO tgp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pani vara tamlohi tari na varama la pa levosahia vara enau na opoi Tamaku, na lo vai na sava enia mo retileu vara a vaira. Ale ha turu, r̃a malue!” ");
INSERT INTO tgp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu mo verea isana nona tamlohi mara, “Enau asi grape varar̃uhu, ale Tamaku enia tamlohi isa. ");
INSERT INTO tgp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mo tai nar̃ihi vevuhi na rangaku sei la sopo vua hiniau. Pani hin haratu la lo vua, mo jalo na rangana vara i pa namaha i mar̃ivi. ");
INSERT INTO tgp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kamim ka vokevoke moiso mata sava na lo verea isamim moiso. ");
INSERT INTO tgp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ha toho hiniau, ale enau a pa lo toho hin kamim. Sohena ranga matea i sopo er̃i vua matan mo sopo sor̃otahi peresi na lahona, kamim ha pa sopo er̃i vua vara ha sopo toho hiniau. ");
INSERT INTO tgp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Enau pulo asi grape, ale kamim rangarangana, pani vara kamim ha sor̃otahi isaku, ale enau a lo sor̃otahi isamim, kamim ha pa vua i mar̃ivi, pani vara enau a sopo toho isamim, ha pa sopo er̃i vai te hinau hatea. ");
INSERT INTO tgp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Vara ha sopo toho hiniau, la pa pulahi kamim sohena ranga mahoa sei la takonahira, ale la pa sulira na hapu. ");
INSERT INTO tgp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Vara ha lo toho hiniau, ale vara noku reti i lo toho hin kamim, sava ka usia Tamaku i pa vaia nomim. ");
INSERT INTO tgp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tamaku mo lo lavi na oloolo tavera hin malele sei, vara ha vua tavera ka lo vujangia vara ka noku tamlohi usuri varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na lo opoi kamim sohen Tama mo opoiau. Ha toho na noku opoia. ");
INSERT INTO tgp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Vara ha oloolo na noku retileu, ha pa lo toho na noku opoia sohen enau na lo oloolo na retileu non Tamaku, ale na lo toho na nona opoia. ");
INSERT INTO tgp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na lo vere la hinau sei isamim vara ha pa avulahi tavera soheku. ");
INSERT INTO tgp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Noku retileu na lo verea isamim nakerihi, vara ha opoiopoi kamim sohen enau na lo opoi kamim tiroma mo mai nake. ");
INSERT INTO tgp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mo sopo tea nona opoia i jeu haranike: vara tea i tau na maurina mata tapalana. ");
INSERT INTO tgp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ale kamim ha pa tapalaku vara ha lo oloolo na sava na retileu hinia isamim. ");
INSERT INTO tgp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Slev la sopo levosahia vara nora tamlohi tavera mo lo vai na sava, ale enau na sopo mele retireti isamim sohena noku slev. Na tovi kamim tapalaku matan enau na vere vevuhi na sava Tamaku mo vereau hinia. ");
INSERT INTO tgp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kamim ka sopo vir̃oniau, pani enau na vir̃oni kamim matan vara ha pa vano ha vua na vua sei i pa lo toho jejeu. Ale sava hinau ka usia na hijaku, Tamaku i pa silea isamim. ");
INSERT INTO tgp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ale na retileu isamim vara ha opoiopoi kamim.” Iesu mo verea mara: ");
INSERT INTO tgp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Vara tamlohi varama la r̃ohu hin kamim, ha r̃omr̃omia vara la r̃ohu hiniau tiroma. ");
INSERT INTO tgp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Vara kamim tamlohi non varama, tamlohi hinia la pa opoi kamim. Pani kamim ka sopo tamlohi non varama, mo vono. Enau na vir̃oni nar̃ihi kamim vara ha pa tau na varama na har̃imim, ale matan haratu, tamlohi non varama la pa r̃ohu hin kamim. ");
INSERT INTO tgp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ha r̃omr̃omi na sava na lo vere kamim hinia moiso, ‘Slev mo sopo aulu i jeu na nona tamlohi tavera’. Vara tamlohi la vailejilejiau, la pa vailejileji kamim. Vara la oloolo na sava na verea, la pa oloolo na sava ka lo verera. ");
INSERT INTO tgp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tamlohi la pa vailejileji kamim matan ka lo lavi na hijaku, ale matan la sopo levosahi haratu sei mo lo r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Vara a sopo lo sinai a verea isara, enira la pa sopo ori na hehe, pani nake, la sopo er̃i verea vara mo sopo te nora hehe. ");
INSERT INTO tgp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Haratu sei mo r̃ohu hiniau, enia i pa r̃ohu hin Tamaku. ");
INSERT INTO tgp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Vavahinau sei na vaira, mo sopo lo te tamlohi i vaira hin te rani, vara la sopo lo hiteau a vai la hinau atu, la pa sopo ori na hehe, pani la hiteau na vai la hinau atu, ale la r̃ohu tavera hiniau peresi Tamaku. ");
INSERT INTO tgp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pani matan sava la pete ulia na nora leu moiso i pa masese, ale mo verea mara, ‘Tamlohi la r̃ohu tavera hiniau, pani mo sopo matan te hinau’. ");
INSERT INTO tgp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pani a pa r̃ule na Tuetueni r̃uhu matea i pa tai isan Tama i sinai isamim, enia Tanumena, i pa vujangi na hina varar̃uhu mo malue isan Tama, ale Tanumena i pa vereuliau. ");
INSERT INTO tgp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ale kamim sohena, ha pa vereuliau matan kamim ka lo toho peresiau na tapulo noku rani nike.” ");
INSERT INTO tgp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na lo vere kamim hin la hinau nike, matan vara ha sopo kali hin te hinau. ");
INSERT INTO tgp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","La pa tipahi kamim na ima lotu nona Jew. Ale pongi matea i pa mai, tamlohi la pa vilimatei kamim, ale matana, la pa r̃omr̃omia vara la lo vai na masalon God. ");
INSERT INTO tgp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","La pa vai hinau atu matan la sopo levosahi Tama teni enau. ");
INSERT INTO tgp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pani na lo vere hinau sei isamim nake, matan vara pongina i masese, ha pa r̃omr̃omi na sava na lo vere kamim hinia moiso. Tiroma na sopo vere la hinau nike, matan enau na lo toho peresi kamim, ");
INSERT INTO tgp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","pani nake na lo sahe isan haratu mo lo r̃uleau, ale mo sopo te vonamim i usiau hinia vara, ‘Ko lo haipu?’ ");
INSERT INTO tgp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mata sava na verea isamim, ale ka rongo mo sati tavera. ");
INSERT INTO tgp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pani na verea isamim, i pa mele r̃uhu isamim vara a malue. Vara a sopo malue, Tuetueni r̃uhu atu i pa sopo er̃i mai vara i tueni kamim. Vara a vano a pa r̃ule na Tanume Tapu i mai isamim. ");
INSERT INTO tgp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tanume Tapu i pa mai i tuvai na tamlohi na varama na sava mo hehe, ale na sava mo vokevoke, mata aria non God. ");
INSERT INTO tgp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ale i pa mai i tuvai na tamlohi na varama na sava mo hehe matan la sopo rasuau. ");
INSERT INTO tgp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ale i pa mai i tuvai na tamlohi na varama na sava mo vokevoke matan mauriku mo vokevoke, ale enau na lo sahe isan Tama ale kamim ha pa sopo er̃i mele hiteau nike, ");
INSERT INTO tgp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ale i pa mai i tuvai na tamlohi na varama mata aria non God matan mo pete ari haratu mo lo tauri na suiha non varama nike moiso. ");
INSERT INTO tgp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na opoia vara a vere kamim na hinau matuvana, pani nakerihi i pa r̃ilangi vara ha pa levosahira. ");
INSERT INTO tgp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pani hin pongi atu vara Tanume Tapu i mai, enia i pa vujangi na hina varar̃uhu, ale i pa tiroma hin kamim na malele varar̃uhu tari vara ha pa levosahira. Tanume Tapu mo sopo vere na hinau enia hasena, pani enia i pa vere kamim purongo na sava mo rongoa isaku. Moiso enia i pa vai kamim ha levosahi na sava i pa masese hitahu. ");
INSERT INTO tgp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tanume Tapu i pa vuhesia isamim vara enau na r̃uhur̃uhu jea sohena sava, i pa vaia sohen harihi: i pa lavi na noku reti vara i vuhesia isamim. ");
INSERT INTO tgp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hinau tari non Tama enia noku. Matan hinau atu na lo vere vara Tanume Tapu i pa lavi na noku reti, ale i vuhesia isamim. ");
INSERT INTO tgp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","I pa sopo tuai ha pa sopo mele hiteau, pani hitahun haratu, ha pa mele hiteau.” ");
INSERT INTO tgp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nona tamlohi usuri la lo vereverera hinia lara, “R̃aramin nona reti sei isar̃a enia sava sei enia mara, ‘I pa sopo tuai ha pa sopo hiteau, pani hitahun haratu ha pa mele hiteau mata makomo rani!’ teni ‘matan a pa mele sahe isan Tama?’” ");
INSERT INTO tgp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nona tamlohi usuri la lo mele usiusira hinia lara, “R̃aramin nona reti sei, ‘I pa sopo tuai!’ enia sava r̃a sopo levosahi na sava mo lo verea.” ");
INSERT INTO tgp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu mo levosahia vara la opoia vara la usia hin la hinau sei, ale mo verea isara mara, “Avei, ka lo usiusi kamim na r̃aramin noku reti sei, ‘I pa sopo tuai ha pa sopo hiteau, pani hitahun haratu, ha pa mele hiteau?’ ");
INSERT INTO tgp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Varar̃uhu na verea isamim vara ha pa tangi, moiso ha pa rongo i sati, pani tamlohi na varama la pa avulahi. Ha pa rongo i sati, pani hitahu ha pa avulahi. ");
INSERT INTO tgp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vara har̃ai mariviti vara i lavilavi, enia i pa rongohaji tavera, pani vara mo isoiso, mo r̃omaliho na rongohaji, ale mo avulahi matan mo vasusui na natirihi matea mo pala na varama. ");
INSERT INTO tgp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ale sohen haratu nake r̃omimim la lo sati, pani hitahu hin pongi atu vara a mele hite kamim, ha pa avulahi tavera, ale tea i pa sopo er̃i posi na nomim avulahi. ");
INSERT INTO tgp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Vara pongi atu i masese, ha pa sopo er̃i mele usiau hin te hinau. Varar̃uhu na verea isamim vara Tama i pa sile kamim na sava hinau ka usia na hijaku. ");
INSERT INTO tgp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mo tikeli nake ka sopo lo usi te hinau na hijaku, pani nake, ha pa usia na hijaku moiso i pa mai isamim matan vara ha pa avulahi jea. ");
INSERT INTO tgp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Na lo retireti na titileu isamim matan vara i vuhesi na sava na lo verea. Pani pongi matea mo lo mai, a pa vere tataholoi kamim hin Tama, ale a pa sopo mele titileu sohen haranike. ");
INSERT INTO tgp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hin pongi atu enau a pa sopo mele usia nomim matan kamim hasemim ha pa usi na hinau isan Tama na hijaku. ");
INSERT INTO tgp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Matan Tama mo opoi kamim matan ka opoiau, ale ka rasua vara enau na tai isana. ");
INSERT INTO tgp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na tai isan Tama na mai na varama, pani nake na lo malue na varama vara a mele hilu a sahe isan Tama.” ");
INSERT INTO tgp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nona tamlohi usuri lara, “Nakerihi ko reti tataholo isamam, ko sopo titileu. ");
INSERT INTO tgp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nake natu, kama levosahia vara engko ko levosahi na hinau tari, ale te i sopo er̃i usi te retiusia isam. Nake kama rasua vara engko ko tai isan God.” ");
INSERT INTO tgp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu mo r̃aramira mara, “Kamim ka rasuau varar̃uhu? ");
INSERT INTO tgp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Rani matea mo lo mai, ale nake mo masese moiso vara kamim mo isoiso ha pa rovorovo, enau haseku a pa lo toho, pani Tamaku i pa lo toho peresiau, ale a pa sopo toho haseku. ");
INSERT INTO tgp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na lo vere hinau sei isamim matan vara tamata i pa toho na mapumim mataku. Nake ka lo toho na varama kamim ha pa lavi na rani r̃ilangi, pani ha lo r̃omr̃ilangi matan enau na jeu na noku meresahi na varama moiso.” ");
INSERT INTO tgp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu mo vere la hinau sei moiso, mo tar̃a sahe aulu na tuka, mo verea mara, “Tamaku, pongi atu mo mai vara o tahe na hijan Natum aulu matan vara Natum i er̃i tahe na hijam aulu. ");
INSERT INTO tgp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ale matan ko sile na suiha isaku moiso vara a aulu na tamlohi tari matan vara a pa sile na mauri tui isan la haratu ko lo sileau hinira. ");
INSERT INTO tgp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mauri tui enia vara la levosahiho vara engko hasem God varar̃uhu, ale vara la levosahi Iesu Kr̃isto, haratu ko lo r̃ulea. ");
INSERT INTO tgp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Enau na vujangi la tamlohi nike na varama vara nom r̃uhur̃uhu mo sohena sava matan na vai vevuhi na hinau tari ko lo taura isaku vara a vaira. ");
INSERT INTO tgp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nake Tamaku, o mele taheau na noku suiha aulu peresiho na tuka i sohen haratu mo lo toho isaku tiroma varama mo sopo lo tapulo. ");
INSERT INTO tgp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Enau na vereuliho isan la tamlohi atu, engko ko lo sileau hinira na varama vara la pa levosahiho. Enira nom, moiso ko sileau hinira, ale la lo oloolo na nom reti. ");
INSERT INTO tgp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nake, la levosahia vara hinau tari ko sileau enira la tai isam. ");
INSERT INTO tgp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na vere na noku tamlohi moiso na sava ko lo vereau hinira vara a verea, ale la lavia. La levosahia mo r̃uhu vara enau na tai isam, moiso la rasua vara engko ko r̃uleau na mai. ");
INSERT INTO tgp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na lo usiusi matara, pani mo sopo matan la haratu non varama. Noku tamlohi enira nom, ale na lo usiusi matara matana. ");
INSERT INTO tgp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Hinau tari noku, enira nom moiso, ale na lavi na oloolo tavera matan la lo vereuliau. ");
INSERT INTO tgp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","I pa sopo tuai enau a sopo mele toho na varama, pani enira la lo pa toho na varama, ale enau na lo mai isam. Tama Tapu o pa tingira hin suiham atu ko lo silea isaku. Moiso la pa matea peresira hasera sohen engko peresiau r̃a matea. ");
INSERT INTO tgp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hin rani atu na lo toho peresira, na lo tingira hin suiha atu ko lo sileau hinia. Na lo kilaura, ale mo sopo te vonara hatea i tihai, pani tamlohi atu matea purongo sei mo lo vano na komo matan vara Retitapu i pa masese. ");
INSERT INTO tgp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na lo mai isam, pani na lo vere la hinau nike nake na lo toho na varama vara noku tamlohi, la pa er̃i avulahi tavera soheku matana. ");
INSERT INTO tgp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na silera na nom reti moiso, ale tamlohi non varama la r̃ohu hinira, matan enira la sopo tamlohi non varama, mo soheku, la r̃ohu hiniau matan enau na sopo non varama. ");
INSERT INTO tgp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tata, na sopo usiho vara o lavi nar̃ihi na noku tamlohi na varama, pani vara o tingira matan Tiapolo. ");
INSERT INTO tgp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Enira la sopo non varama, sohen enau na sopo non varama. ");
INSERT INTO tgp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","O tapuhira na retivarar̃uhu, nom reti enia varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Enau na lo r̃ulera vara la vano isana tamlohi r̃alihi na varama sohen engko ko r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Enau na tapuhiau haseku vara a vai na masalom purongo, matan vara la pa er̃i hitevosahia, ale la mai tamlohi non retivarar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Enau na sopo usiusi matan la noku tamlohi nike hasera, pani na lo usiusi mata tamlohi tari sei la pa tau na nora rasua hiniau na sava la pa lo verea mataku. ");
INSERT INTO tgp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na opoia vara enira mo isoiso la pa matea peresihira hatehateahi, sohen enau na lo matea peresiho, ale engko ko matea peresiau. Na opoia vara la pa matea peresir̃a, matan vara tamlohi hin varama nike, la pa rasua vara engko ko r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Suiha r̃uhur̃uhu atu ko lo sileau hinia, na pete silea isara moiso, matan vara la pa matea sohen enr̃a r̃a matea, ");
INSERT INTO tgp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","enau hinira, ale engko hiniau, matan vara la pa matea na hinau tari, matan vara tamlohi na varama la er̃i levosahia vara engko ko r̃uleau, ale ko lo opoira sohen ko opoiau. ");
INSERT INTO tgp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata, na opoia vara la haratu ko lo sileau hinira, la pa toho peresiau na jara na lo toho ea, matan vara la pa er̃i hite noku oloolo tavera atu sei ko lo sileau hinia, matan ko opoiau hin pongi atu varama mo sopo lo toho. ");
INSERT INTO tgp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata ko vokevoke, hina purongo vara tamlohi na varama la sopo levosahiho, enau na levosahiho, ale la tamlohi nike la levosahia vara engko ko r̃uleau. ");
INSERT INTO tgp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ale enau na verea isara vara engko ko sohena sava, ale a pa mele verea isara vara opoia atu ko opoiau hinia, i pa toho isara, ale enau a pa toho hinira.” ");
INSERT INTO tgp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu mo usiusi mo isoiso, enia tolu na nona tamlohi usuri, la vano roto na Vakoan Kidron na talu olive matea atu. ");
INSERT INTO tgp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tarea Iesu tolu na nona tamlohi usuri la lo pulutahi ea, ale Judas haratu mo lo turuposi hin Iesu mo levosahi jara atu. ");
INSERT INTO tgp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ale Judas mo vano hin talu olive atu peresi na tamlohi vuro hai nona mara Rome peresi na police mata Temple. Nora moli mata pr̃is peresi na Pharisee la r̃ulera. La lavi na hapu jilangi, lamu peresi na hinau mata valum, ale la mai isan Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu mo pete levosahi na sava i pa masese moiso, pani mo usi isara mara, “Ka lo ale hare?” ");
INSERT INTO tgp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ale Judas haratu mo lo turuposi hinia mo lo turu peresira atu. La r̃aramia lara, “Kama lo ale Iesu mara Nazareth!” Iesu mo verea isara mara, “Enau natu, haratu na lo toho jejeu!” ");
INSERT INTO tgp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Vahatea purongo enira mo isoiso la turu juha hinia, ale la jovi na lepa. ");
INSERT INTO tgp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu mo mele usia mara, “Ka lo ale hare?” La r̃aramia lara, “Kama lo ale Iesu mara Nazareth!” ");
INSERT INTO tgp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu mo r̃aramira mara, “Na pete verea moiso vara enau natu. Vara ka lo aleau, ha tinar̃ihi la tamlohi nike la vano!” ");
INSERT INTO tgp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Mo verea sohena matan vara nona reti atu mo lo verea tiroma i pa masese mara, ‘Enau na sopo vaitihai te vonara hatea hin la haratu ko lo sileau hinira’. ");
INSERT INTO tgp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ale Simon Peter enia nona sita vuro matea, ale mo reve nar̃ihi sita vuro atu mo langa na matua pero slev non pr̃is aulu atu, hijan slev atu enia Malchus. ");
INSERT INTO tgp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pani Iesu mo reti isan Peter mara, “O tau nar̃ihi na nom sita vuro! Vara sava, ko r̃om vara enau a pa sopo er̃i lavi rani r̃ilangi sei Tama mo lo sileau hinia?” ");
INSERT INTO tgp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ale vao tamlohi vuro matea nona mara Rome peresi nora commander peresi na police mata Temple nona Jew, la taurilati Iesu, ale la pesia. ");
INSERT INTO tgp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","La lavia mo vano tiroma isan Annas, enia palihan Caiaphas, pr̃is aulu hin tauni atu. ");
INSERT INTO tgp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas sei natu, mo lo verea isana tamlohi tatavera nona Jew mara, “I pa mele r̃uhu vara tamlohi matea purongo i mate mata tamlohi tari.” ");
INSERT INTO tgp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter peresi na tamlohi usuri tinapua non Iesu matea, la usurira la lavi Iesu mo vano isan Annas. Tamlohi non Iesu atu enia mo levosahi mamahuni pr̃is aulu atu, ale mo usuri Iesu mo sivo na lolo rope iman pr̃is aulu atu. ");
INSERT INTO tgp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pani Peter mo lo toho na jingoima mariviti na mataruan rope atu. Pani pa tamlohi usuri non Iesu atu mo mele malue, ale mo vano mo retireti peresi har̃arihi atu mo lo kilau na matarua rope. Mo tinar̃ihia vara Peter i unu hin rope atu, ");
INSERT INTO tgp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","pani mo usia isana mara, “Avei, engko ko sopo vonara matea sei la lo usuri tamlohi atu?” Peter mo r̃aramia mara, “Enau mo vono!” ");
INSERT INTO tgp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Slev peresi na police mata Temple la lo turu r̃alihi na hapu matea la vaia na valaji hapu mata hamariri. Peter sohena mo lo turu peresihira mo lo marijo. ");
INSERT INTO tgp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na lolo ima, pr̃is aulu atu mo lo usi Iesu mata nona tamlohi usuri peresi na nona vujangi. ");
INSERT INTO tgp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Pani Iesu mo r̃aramia mara, “Enau na lo retireti na jara tavera isana tamlohi na varama. Ale tarea, enau na lo vujangi na lolo ima lotu peresi na Temple sei Jew la lo pulutahi ea. Na sopo vere te hinau hatea vara tamlohi la sopo rongoa. ");
INSERT INTO tgp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mata sava ka lo usiau hinia? Ha usi la haratu la lo rongoau, la levosahi na hinau na lo verea!” ");
INSERT INTO tgp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu mo vere reti atu moiso police mata Temple matea mo vojaia, ale mo verea mara, “Ko r̃om vara o er̃i r̃arami na pr̃is aulu matea sohen haratu?” ");
INSERT INTO tgp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu mo r̃aramia mara, “Vara na vere te hinau mo sopo tataholo o verea! Pani vara mo vono, mata sava ko vojaiau?” ");
INSERT INTO tgp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ale Annas mo r̃ule Iesu mo vano isan Caiaphas, pr̃is aulu, pani la sopo lo uli nar̃ihi na asihai hinia. ");
INSERT INTO tgp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Haratu mo lo vano, pani Simon Peter mo pa lo turu mo lo marijo, ale la usia isana lara, “Avei, engko ko sopo nona tamlohi usuri matea?” Peter mo mele vunvunia mara, “Enau mo vono!” ");
INSERT INTO tgp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Slev matea non pr̃is aulu tahisan haratu sei Peter mo lo langa na perona, mo usia mara, “Mo sopo engko sei na hiteho na talu olive peresi tamlohi nike?” ");
INSERT INTO tgp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter mo mele vunvunia, ale vahatea purongo, toa vari matea mo tarere. ");
INSERT INTO tgp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na r̃alavuho jea natu, la lavi Iesu la malue na iman Caiaphas, la vano na ima tavera matea nona tamlohi tavera nona mara Rome. Pani la lo sasaovi na jingoima, matan la rasua vara tea i unu, enia i pa lumiha na nahon God, ale enia i pa sopo er̃i hani na Passover. ");
INSERT INTO tgp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilate mo malue mo usia mara, “Tamlohi nike, mo vai na sava hina sati?” ");
INSERT INTO tgp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","La r̃aramia lara, “Ko r̃om vara kama pa lavi tamlohi akerihi i mai isam vara enia mo sopo vai te hina hehe?” ");
INSERT INTO tgp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate mo verea isara mara, “Ha lavia, ale ha pa aria i usuri na nomim leu.” Vao tamlohi nona Jew atu la r̃aramia lara, “Pani nomim leu mo tapuhoro kamam vara kama er̃i tau te tamlohi na mateia.” ");
INSERT INTO tgp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ale sohen Iesu mo verea moiso vara nona mateia i pa sohena sava, mo lo mai vara i masese. ");
INSERT INTO tgp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate mo mele unu na lolon patu ima tavera atu, ale mo tovi Iesu mo vano isana, ale mo usia isana mara, “Avei, engko natu, Supe nona Jew?” ");
INSERT INTO tgp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu mo r̃aramia mara, “Retiusia sei mo tai isam hasem teni tea la verea isam mataku?” ");
INSERT INTO tgp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate mo r̃aramia mara, “Sava? Vara sava, enau Jew matea? Tahisam tataholo peresi na pr̃is aulu, enira natu, la laviho ko mai isaku. Ko vai na sava mo sati?” ");
INSERT INTO tgp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu mo r̃aramia mara, “Jara atu na lo tauri na suiha hinia mo sopo non varama nike, vara i sohena, noku tamlohi la pa valum moiso matan vara la turuhoroau vara a pa sopo er̃i vano na lima tamlohi tatavera nona Jew, pani mo vono, jara atu na lo tauri na suiha hinia mo sopo non varama nike.” ");
INSERT INTO tgp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate mo verea mara, “Varar̃uhu, engko Supe matea?” Iesu mo verea isana mara, “Engko ko lo verea vara enau Supe matea. Enau na vora hin varama nike matan vara a vere na retivarar̃uhu. Ale la haratu non varar̃uhu la levosahi na leoku.” ");
INSERT INTO tgp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate mo usia isan Iesu mara, “Retivarar̃uhu enia sava?” Hitahun haratu Pilate mo mele malue mo verea isan la Jew atu mara, “Tamlohi nike, na sopo hite te hinau i ori hinia vara a sile na talai isana. ");
INSERT INTO tgp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ale tarea na lo teri na tamlohi matea na nomim pongi Passover. Ale kamim ka opoia vara a teri na Supe nona Jew teni mo vono?” ");
INSERT INTO tgp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ale la r̃aramia la ulo lara, “Mo vono! Mo sopo enia. Kama opoi Barabbas.” Barabbas enia tamlohi valvalum matea ale enia mo r̃ohu na gavman non Rome. ");
INSERT INTO tgp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ale Pilate mo lavi Iesu mo retileu vara, la tamlohi vuro atu, la pa rupia na asi maja. ");
INSERT INTO tgp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tamlohi vuro la peri na rongorongo na asihai ngar̃ngar̃iha la taua na patuna, ale la liho na ruru peravu majhina mo perpel nona tamlohi aulu na pilina. ");
INSERT INTO tgp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","La mai isana la kerehia lara, “Engko Supe nona Jew, avei?” Ale la tutuhi na nahona. ");
INSERT INTO tgp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate mo mele malue, mo verea isana tamlohi tatavera nona Jew mara, “Ka hitea, na lavia mo mai isamim, matan ha pa levosahia vara enau na sopo er̃i vilei te hinau i ori hinia vara i lavi na talai matana.” ");
INSERT INTO tgp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ale Iesu mo malue peresi na r̃ongor̃ongo la vaia na asihai ngar̃ngar̃iha na patuna peresi na ruru peravu, majhina mo perpel. Ale Pilate mo verea isara mara, “Ka hitea, tamlohi atu nahai!” ");
INSERT INTO tgp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Moiso na rani moli nona pr̃is peresi na police mata Temple la hitea, la ulo lara, “Ha vosaea na talopeilopei! Ha vosaea na talopeilopei!” Pilate mo verea mara, “Kamim ha lavia, ha vosaea na talopeilopei kamim hasemim! Enau na sopo vilei te hinau hatea vara mo ori hinia.” ");
INSERT INTO tgp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tamlohi tatavera nona Jew atu la r̃aramia lara, “Kamam nomam leu matea mo verea vara i pa mate matan mo lo verea vara enia Natun God!” ");
INSERT INTO tgp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ale Pilate mara mo rongo reti atu mo mele matahu mo tavera, ");
INSERT INTO tgp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","moiso mo posi vara i mele unu hin nona patu ima tavera atu, ale mo hite Iesu, mo verea isana mara, “Engko ko tai epu?” Pani Iesu mo sopo r̃aramia. ");
INSERT INTO tgp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Moiso Pilate mo verea mara, “Ko sopo r̃aramiau mata sava? Ko sopo levosahia vara ko lo toho na suiha limaku vara o pa materi teni la vosaeho na talopeilopei vara a opoia?” ");
INSERT INTO tgp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu mo r̃aramia mara, “Vara God i sopo lo sileho na suiha, engko o sopo er̃i vai te hinau isaku, ale matan harihi, la haratu la sileau isam, nora hehe mo jeu na nom.” ");
INSERT INTO tgp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hitahun haratu Pilate mo tapulo vaihite vara i teri Iesu, pani vao atu mo mele ulo aulu lara, “Vara o teri tamlohi nike, engko ko sopo tapalan supe hin Rome! Vara tea i verea vara enia supe enia mo meresahi non supe hin Rome!” ");
INSERT INTO tgp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ale Pilate mara mo rongoa, mo tiroma hin Iesu la vano na jingoima, ale mo sakele na jara tamlohi ari la lo tovia, ‘Jara Pulutahi la tiua na vatu’ na leon tavtavuin Israel lara, ‘Gabbatha’. ");
INSERT INTO tgp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nake mo livuha rani moiso na rani mo tiroma na rani Passover. Pilate mo verea isana vao Jew atu mara, “Ka hitea! Nomim Supe nahai!” ");
INSERT INTO tgp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Vao atu la ulo aulu lara, “O vilimateia! O vilimateia! O vosaea na talopeilopei!” Pilate mo usia isara mara, “Avei, ka opoia vara a vosae nomim Supe na talopeilopei?” Moli pr̃is la r̃aramia lara, “Mo sopo te nomam Supe, pani Supe nona mara Rome enia nomam Supe!” ");
INSERT INTO tgp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ale Pilate mo tau Iesu na limara vara la pa vosaea na talopeilopei. La tauri Iesu la tiroma hinia, ");
INSERT INTO tgp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ale la lavi Iesu mo vano, ale enia mo hasena lavi na talopeilopei, mo malue la vano hin jara atu la tovia vara, ‘Jara Patusui Tamlohi’ na leon tavtavuin Israel la tovia Golgotha. ");
INSERT INTO tgp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hin jara atu natu la vosaea na talopeilopei peresi na tamlohi tinapua mo rua na tavaluna, Iesu na livuhara. ");
INSERT INTO tgp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate sohena mo uli na reti matea mo vosaea aulu hin talopeilopei atu mo verea mara, Iesu mara Nazareth Supe nona Jew ");
INSERT INTO tgp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jew matuvana la evia matan jara atu la vosae Iesu hinia, mo lo toho na pahisan taon tavera atu, ale mo ulia na leo tavtavuin Israel peresi na leo mara Rome peresi na leo mara Greek. ");
INSERT INTO tgp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ale moli nona pr̃is la vano isan Pilate lara, “Mata sava ko ulia vara, enia Supe nona Jew? I pa mele r̃uhu vara o ulia vara, enia mo lo verea vara enia Supe nona Jew!” ");
INSERT INTO tgp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pani Pilate mo r̃aramira mara, “Sava na ulia moiso i lo toho sohena!” ");
INSERT INTO tgp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tamlohi vuro la vosae Iesu na talopeilopei moiso, ale la asease na nona ruru isara tupu vati na sope ruru matea isara hatehateahi. Nona ruru tavera enia tavalu ruru matea purongo, mo sopo te sor̃osor̃o hinia, ");
INSERT INTO tgp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ale matana, la tamlohi vuro atu la vereverea isara lara, “R̃a sopo r̃arir̃aria. R̃a pa roro matana, vara r̃a pa hitea vara hare i pa lavia nona!” Haratu mo masese matan vara sava Retitapu mo verea i pa masese mara, ‘La aseasehi na noku ruru, la roro mata noku ruru’. Ale tamlohi vuro la vai na sava la hatihia moiso. ");
INSERT INTO tgp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tinan Iesu mo lo turu na tavalu nona talopeilopei peresi vetavain tinana, peresi Mary atu naroun Clopas, ale Mary Magdalene. ");
INSERT INTO tgp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Moiso Iesu mo hite tinana peresi tamlohi usuri atu mo opoia mo tavera, mo verea isan tinana mara, “Tamlohi nike, nake enia natum.” ");
INSERT INTO tgp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ale mo verea isan tamlohi usuri atu mara, “Enia nake tinam.” Mo tapulo hin rani atu, tamlohi atu mo lavia mo vano na imana. ");
INSERT INTO tgp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hitahun haratu, Iesu mo levosahia vara mo vai vevuhi na nona vavahinau, ale vara na sava hinau Retitapu mo verea moiso vara i pa masese mo verea mara, “Na mar̃ohu!” ");
INSERT INTO tgp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Potele waen hohona matea mo lo toho atu, ale la r̃ur̃uni na susupaheu hin waen hohona atu na ranga hyssop matea, ale la tahea mo sahe na jingona. ");
INSERT INTO tgp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hitahun haratu Iesu mo inu waen atu mo verea mara, “Hinau tari mo isoiso!” Mo rautoho moiso mo mate. ");
INSERT INTO tgp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ale matan vara i mele rani sahe i pa Sabbath matea peresi na Passover, enia rani aulu matea nona Jew. Jew la sopo opoia vara la tarape atu la lo sevu na talopeilopei hin rani atu, ale la vano la usia isan Pilate vara la kame na palora vara la mate vila, ale la pa er̃i suira. ");
INSERT INTO tgp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ale tamlohi vuro la kame na palon la tamlohi mo rua atu sei la lo vosaera na talopeilopei na tavalun Iesu tiroma. ");
INSERT INTO tgp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pani lara la mai isan Iesu, la hitea vara enia mo pete mate moiso, ale la pa sopo kame na palona. ");
INSERT INTO tgp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pani tamlohi vuro matea mo urai Iesu na rorona, ale r̃ae peresi na wai mo malue. ");
INSERT INTO tgp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kama levosahia vara hinau atu mo varar̃uhu matan haratu mo lo hitea mo vereulia vara mo varar̃uhu, ale nake kamim sohena, ha pa er̃i rasua. ");
INSERT INTO tgp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","La hinau sei la masese matan vara Retitapu i pa masese sei mo verea mara, ‘Te sui epena hatea i pa sopo moti.’ ");
INSERT INTO tgp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ale na jara tinapua na Retitapu mara, ‘La pa hitea hin haratu sei la urai na rorona na sari.’ ");
INSERT INTO tgp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tamlohi usuri non Iesu matea, Joseph mara Arimathea, mo jarohi na nona rasua hin Iesu matan mo matahu vara tamlohi tatavera nona Jew la pa sile na talai isana, ale mo vano isan Pilate mo usia vara i tinar̃ihi na tarapen Iesu vara i tavunia. Pilate mo tinar̃ihia, ale Joseph mo sui nar̃ihia na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pa Nicodemus sei mo lo mai isan Iesu na vutepongi, mo usuri Joseph. Mo lavi na tanga hasori r̃uhu matea la tovia myrrh peresi na aloes la hoihoira jara matea, puhonina mo jeu 25 kilo. ");
INSERT INTO tgp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","La tupra rua atu la tali r̃alihi na tarapen Iesu na ruru lulu peresi na hasori sei Jew la lo tavuni na nora mate peresia. ");
INSERT INTO tgp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mariviti hin jara atu sei la vosae Iesu na talopeilopei ea, lovuhai matea la lavo na vipahai mata lakolako mo r̃alihia mo lo toho atu. Ale papa vatu matea la sopo lo tau te tarape tamlohi hinia mo lo toho ea. ");
INSERT INTO tgp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","La tau na tarapen Iesu hin papa vatu atu matan mo lo toho mariviti atu, ale la vaia vilavila matan enia rani atu nona Jew mata tatamahu mata Passover. ");
INSERT INTO tgp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na nahonaho rani na r̃alavuho na rani tiroma mata wik, mo pa lo r̃or̃oha, ale Mary Magdalene mo vano hin papa atu. Ale mo hitea vara la kuresi nar̃ihi vatu tavera atu na matarua moiso, ale papa atu mo roi. ");
INSERT INTO tgp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mara mo hitea sohena, mo maro mo mai isan Simon Peter peresi tamlohi usuri atu Iesu mo opoia, ale mo verea isara mara, “La lavi nar̃ihi Tija na papa moiso! Kama sopo levosahia vara la taua epu!” ");
INSERT INTO tgp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peter peresi tamlohi usuri non Iesu tinapua atu la maro mata papa. ");
INSERT INTO tgp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","La maro pulupulu, pani tamlohi usuri non Iesu tinapua atu mo maro mo jeu Peter mo kakau na papa tiroma. ");
INSERT INTO tgp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mo rautoho mo riorio, ale mo hite te tavalu ruru la lo toho na lolo papa, pani mo sopo unu na lolo papa. ");
INSERT INTO tgp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hin rani atu Simon Peter mara mo kakau mo unu na papa, ale mo hite te tavalu ruru atu. ");
INSERT INTO tgp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ale enia mo hite tavalu ruru atu sei la lo tavu na nahon Iesu hinia, la pirura la lo toho hasera. ");
INSERT INTO tgp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tamlohi usuri non Iesu atu haratu mo lo kakau tiroma, mo unu na papa, ale mo hitea moiso mo rasua. ");
INSERT INTO tgp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hin rani atu, Peter peresi nona tamlohi tinapua atu, la sopo levosahia vara Retitapu mo verea vara Iesu i pa mele turu na mateia. ");
INSERT INTO tgp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ale la tamlohi usuri tupra rua atu la mele hilu la mule. ");
INSERT INTO tgp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary Magdalene mo lo turu na jingoiman papa atu mo lo tangi, mo lo tangi ale mo rautoho mara mo riorio sivo hin papa atu, ");
INSERT INTO tgp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","mo hite na angelo mo rua, la ru na ruru lulu la lo sakele na jara la tau na tarapen Iesu ea. Matea mo sakele na jara patuna, ale haruana mo sakele na jara palona. ");
INSERT INTO tgp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","La angelo atu la usi Mary lara, “Har̃ai, ko lo tangi mata sava?” Mo r̃aramira mara, “La lavi nar̃ihi na tarapen noku Tija! Na sopo levosahia vara la taua epu.” ");
INSERT INTO tgp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mary mo verea sohena mo isoiso mo posi mo hite Iesu mo lo turu atu, pani enia mo sopo hitevosahia vara enia Iesu. ");
INSERT INTO tgp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu mo usia mara, “Har̃ai, mata sava ko lo tangi? Ko lo ale hare?” Mary mo r̃omi vara enia tamlohi lovuhai, ale mo verea mara, “Tapala, vara engko ko nar̃ihi na tarapena, na opoia vara o vereau hinia, matan vara a er̃i vano a lavia.” ");
INSERT INTO tgp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ale Iesu mo verea isana mara, “Mary!” Mary mo posi mo verea isana mara, “Rabbi!” Ale r̃aramin ‘rabbi’ enia ‘tija’ na leon tavtavuin Israel. ");
INSERT INTO tgp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu mo verea isana mara, “O sopo tikeliau! Na sopo lo sahe isan Tata, pani o pa verea isana noku tamlohi vara enau na lo sahe isan Tamaku enia noku God, ale enia nomim God, ale Tamamim.” ");
INSERT INTO tgp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene mo mele hilu vano mo verea isana nona tamlohi usuri vara mo hite Moli. Mo verera na sava Iesu mo verea isana. ");
INSERT INTO tgp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nona tamlohi usuri la matahuni na tamlohi tatavera nona Jew, ale na ravravin rani atu la pelatihoro na lolo ima matea. Vahatea purongo Iesu mo pala na livuhara, mo verea isara mara, “Tamata i toho isamim!” ");
INSERT INTO tgp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ale mo vujangira na limana peresi na rorona, ale nona tamlohi usuri la avulahi tavera matan la hite Moli. ");
INSERT INTO tgp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu mo mele verea isara mara, “Tamata i toho isamim, enau na lo r̃ule kamim sohen Tama mo r̃uleau.” ");
INSERT INTO tgp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hitahun haratu Iesu mo soro na maromarona isara mo verea mara, “Ha lavi na Tanume Tapu! ");
INSERT INTO tgp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Vara ha r̃omi tea na nona hehe, God i pa r̃omia, pani vara ha sopo r̃omi tea na nona hehe, God i pa sopo r̃omia.” ");
INSERT INTO tgp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Hin rani atu Iesu mo pala isana nona tamlohi usuri, matea mo sopo toho peresira, enia Thomas la tovia ‘Havo’. ");
INSERT INTO tgp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ale tatua tamlohi usuri tinapua la verea isana lara, “Kama hite Moli!” Pani Thomas mara, “A pa rasua vara a hite na matara nila na limana, ale a majohoi na limaku na mataran sari atu mo lo unu na rorona.” ");
INSERT INTO tgp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ale wik matea mo vano moiso, nona tamlohi usuri la lo mele pulutahi, pani nake Thomas mo lo toho peresira. La pelatihoro, pani Iesu mo pala mo turu na livuhara mo verea mara, “Tamata i toho isamim!” ");
INSERT INTO tgp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ale mo verea isan Thomas mara, “O tau na pisum nike, ale o kilau usuri na limaku. O majohoi na limam na roroku. O isoiso na nom r̃om rua o rasu!” ");
INSERT INTO tgp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas mo r̃aramia mara, “Engko noku Moli, engko noku God!” ");
INSERT INTO tgp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu mara, “Thomas, engko ko rasua matan ko hiteau purongo teni mo vono? La haratu la sopo hiteau na matara, pani la tau na nora rasua hiniau, enira natu, la pa avulahi tavera.” ");
INSERT INTO tgp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu mo vai na matamata tavera matuvana tinapua na naho nona tamlohi usuri, pani enira mo isoiso la sopo ulira hin puku nike. ");
INSERT INTO tgp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pani na uli la haranike matan vara ha pa er̃i tau na nomim rasua hin Iesu vara enia Kr̃isto atu, Natun God. Vara ha tau nomim rasua hinia ha pa lavi na mauri varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hitahun haratu, sorasora matan Iesu mo vano sohen harihi: Iesu mo mele pala isana nona tamlohi usuri na pahisa tasi sei la tovia Tiberias teni Galilee. ");
INSERT INTO tgp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas la tovia ‘Havo’ enia Nathanael mara Cana atu Galilee la natun Zebedee, ale la vorai atu James enia John la lo toho atu peresi na nona tamlohi usuri mo rua tinapua. ");
INSERT INTO tgp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter mara, “Enau a sivo a tara maji!” Tatuara lara, “Kama pa usuriho!” La vele na botira la sivo, pani hin vutepongi atu, la sopo tikeli te maji hatea. ");
INSERT INTO tgp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mo mele rani sahe na r̃alavuho jea, Iesu mo lo turu na pahisa tasi, pani nona tamlohi usuri la sopo hitevosahia vara enia hare. ");
INSERT INTO tgp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iesu mo ulo mara, “La tapala, ka tikeli te maji teni mo vono?” La r̃aramia lara, “Mo vono!” ");
INSERT INTO tgp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ale mo verea isara mara, “Ha tuhu na nomim tara na matua botimim, ale ha pa tikeli te maji!” La vaia sohena, ale tara mo mar̃ivi na maji la sopo er̃i mele revea i unu na boti. ");
INSERT INTO tgp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tamlohi usuri atu Iesu mo opoia, mo verea isan Peter mara, “Eh, Moli sei!” Ale Simon Peter mara mo rongo vara Moli natu, mo mele ru na nona ruru sei mo lo talihia na pangena vara mo lo revereve, moiso mo kue na tasi. ");
INSERT INTO tgp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","La tamlohi usuri tinapua non Iesu atu na lolo boti la pa lo sua reve na tara mo mar̃ivi na maji mo lo usuri na boti na har̃ina. Ale jara atu la lo toho hinia mo mariviti 100 metre asau na jarauta. ");
INSERT INTO tgp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ale la hoso na jarauta, la hite te pereti ea, ale la hite te maji la lo toho na valaje hapu. ");
INSERT INTO tgp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu mo verea isana nona tamlohi usuri mara, “Ha lavi te maji sei ka pa taraira nakerihi i sinai.” ");
INSERT INTO tgp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter mo mele vele na boti, ale mo reve hosohi na tara. Evi maji mo tikeli 153, ale maji tatavera nakonako, pani tara atu mo sopo mar̃ari. ");
INSERT INTO tgp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu mo verea mara, “Ha mai, ha hanhani!” Pani la matahu mo sopo te tamlohi usuri vonara hatea i usia vara enia hare matan la levosahia vara enia Moli. ");
INSERT INTO tgp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu mo lavi na pereti, ale mo asea isana nona tamlohi usuri, ale mo vaia sohena na maji. ");
INSERT INTO tgp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Haranike enia hatolun nona pala isana nona tamlohi usuri hitahun rani atu, mo mele turu na nona mateia. ");
INSERT INTO tgp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ale Iesu tolu na nona tamlohi lara la hanhani moiso, mo usia mara, “Simon natun John, engko ko opoiau mo jeu la tamlohi nike?” Simon Peter mo r̃aramia mara, “He'e Moli, engko ko levosahia vara na opoiho.” Iesu mara, “O vahani na pulaku natu sipsip!” ");
INSERT INTO tgp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iesu mo mele usia vaha rua isan Peter mara, “Simon natun John, ko opoiau?” Peter mo r̃aramia mara, “He'e Moli, ko levosahia vara na opoiho.” Iesu mo r̃aramia mara, “O lo kilau na pulaku sipsip!” ");
INSERT INTO tgp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesu mo mele usia vaha tolu isan Peter mara, “Simon natun John, ko opoiau?” Nake, Peter mo rongo mo sati matan Iesu mo usia vaha tolu isana vara mo opoia. Ale mo r̃aramia mara, “Moli, engko ko levosahi na hinau tari. Ko levosahia vara na opoiho.” Iesu mo r̃aramia mara, “O vahani na pulaku sipsip. ");
INSERT INTO tgp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Varar̃uhu na vereho hinia, na pongi ko lo uluvou ko lo ruru hasem, ale ko lo vano na jara ko opoia, pani hin pongi atu vara o vajiaha, o pa sohai na limam, ale tamlohi tinapua la pa lihoho, ale la pa tiroma hiniho o vano na jara engko ko sopo opoia.” ");
INSERT INTO tgp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu mo verea matan vara i vereulia vara Peter i pa mate sohena sava, ale sohena sava nona mate i pa tahe na hijan God aulu. Hitahun haratu Iesu mo mele verea isan Peter mara, “O usuriau!” ");
INSERT INTO tgp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter mo posi mo kilau sivo mo hite tamlohi usuri atu Iesu mo opoia mo lo usurira. Enia pa nona tamlohi usuri atu sei mo lo sakele na tavalun Iesu na hanhani Passover, ale mo lo usia vara, “Tija, hare natu, i pa turuposi hiniho?” ");
INSERT INTO tgp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ale Peter mo hite nona tamlohi atu mo lo usurira, mo usi Iesu hinia mara, “Moli, enia i pa sohena sava?” ");
INSERT INTO tgp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu mo r̃aramia mara, “Vara enau a opoia vara enia i mauri i tikeli pongi atu a mele mai, mo sopo te nom hinau hinia, pani engko o usuriau!” ");
INSERT INTO tgp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ale sorasora atu la sorahia vara nona tamlohi usuri atu i pa sopo er̃i mate, pani Iesu mo sopo verea vara i pa sopo mate, mo vono. Enia mo verea purongo isan Peter mara, “Mo sopo te nom hinau hinia vara enau a opoia vara enia i mauri i tikeli pongi atu a mele mai.” ");
INSERT INTO tgp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Enau sei nona tamlohi usuri atu, ale enau natu na lo vereuli la hinau sei. Na lo ulira vara ha pa er̃i levosahia vara enau na lo vereulia ale la varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu mo vai na hinau tinapua matuvana, pani vara la uli vevuhira na puku, i pa sopo te masapa na varama matara. ");
INSERT INTO tgp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theophilus, na noku puku tiroma na uli na hinau tari Iesu mo tapulo vaira, ale mo lo vujangira ");
INSERT INTO tgp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mo kakau hin rani atu God mo lavi nar̃ihia, mo sahe aulu na tuka, sei tiromana mo sile na nona retileu hin Tanume Tapu isana nona vahar̃ule sei mo vir̃onira. ");
INSERT INTO tgp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hitahun na nona rongohaji, mo mele hase vujangia isara vara mo mele mauri na malele tinatinapua matuvana hin la rani atu, mo ngavulu vati atu sei mo lo sorahi mauri atu God mo aulu hinia isara. ");
INSERT INTO tgp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tiroma sei mo pa lo toho peresira mo verea mara, “Ha sopo malue Jerusalem pani ha lo saovi tako mata sava na pete verea isamim moiso sei vara Tama i pa r̃ule na Tanume Tapu, i mai isamim. ");
INSERT INTO tgp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Matan John tamlohi paptijo mo paptijo na wai, pani i pa sopo tuai ha pa paptijo na Tanume Tapu.” ");
INSERT INTO tgp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hin rani atu vahar̃ule la lo toho peresi Iesu, tarea la lo usia isana lara, “Moli, engko o pa turu na nom suiha mata supe aulu hin Israel pangisa?” ");
INSERT INTO tgp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu mo verea isara mara, “Mo sopo tinar̃ihia vara ha levosahi na ranin hinau sei Tama hasena mo taua usuri na masalona. ");
INSERT INTO tgp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pani kamim ha pa lavi na suiha hin rani atu vara Tanume Tapu i mai hin kamim, ale kamim ha pa noku tuetueni hin Jerusalem, na jara tari Judea, Samaria, i tikeli na isoiso jara tari na varama.” ");
INSERT INTO tgp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hitahun la hinau atu mo lo verera, ale lara la pa lo kilaua, palona mo tinar̃ihi na lepa mo lo sahe aulu, ale telangi matea mo lavi nar̃ihia mo tihai na nahora, ");
INSERT INTO tgp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ale la pa lo tar̃a la lo tar̃engia mo lo sahe na tuka, ale vahatea purongo, tamlohi mo rua la ru la ruru lulu jea la lo turu na pahisara, ");
INSERT INTO tgp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ale la verea lara, “Mara Galilee, mata sava ka lo turu nike, ka lo kilau sahe na tuka? Iesu akerihi sei God mo lavi nar̃ihia isamim, mo sahe na tuka, i pa mele sinai sohen harihi ka lo hitea mo lo sahe na tuka.” ");
INSERT INTO tgp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hin rani atu hinau atu mo masese vahar̃ule la lo toho na Vuti talu Olive mariviti kilometre matea hin Jerusalem, ale la mele hilu la vano Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ale lara la unu Jerusalem, la vele sahe aulu na jara tinapua matea hin ima atu sei la lo toho ea hin rani atu: Peter John James Andrew Philip Thomas Bartholomew Matthew James natun Alphaeus Simon sei, enia tamlohi matea mata valum mata jarana, peresi Judas natun James. ");
INSERT INTO tgp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Enira mo isoiso la tau na r̃omira mata usiusi jara matea tolu na har̃ai tinatinapua hai peresi Mary tinan Iesu tolu na tasin Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hin rani atu, Peter mo lo turu na livuhan la tamlohi rasua atu, ale vao atu mariviti i ngav sangavulu ngavulu rua la lo pulutahi hin jara atu, ale mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“La vorai, sava Retitapu mo verea vara i pa masese isan Judas, Tanume Tapu mo verea tiroma moiso na jingon supe David mara, enia i pa tiroma hin la haratu la pa taurilati Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Matan enia mo vir̃onia peresir̃a, ale enia vonar̃a matea na nor̃a vavahinau. ");
INSERT INTO tgp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ale tamlohi akerihi mo voli na lepa matea na voli nona hehe. Mo vele mo sahe na pesapesa, ale mo jovi patuna mo tiroma mo vujahi r̃ar̃ihi na pangena, ale tinena tari la mar̃ava. ");
INSERT INTO tgp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mara Jerusalem tari la rongoa, ale la tau na hijan jara atu vara Akeldama: na leora mo vara, ‘Lepa Mata R̃ae’. ");
INSERT INTO tgp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Matan David mo ulia na nona puku na psalm mara, ‘Ha tinar̃ihia vara jara nona toho i puru, ale i sopo tea i toho hinia’. Ale mo mele verea mara, ‘Ha vir̃oni te tamlohi tinapua i lavi na jarana’. ");
INSERT INTO tgp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ale nakerihi, r̃a pa mele vir̃oni te tamlohi tinapua hatea vara i lavi na jaran Judas, enia i pa tamlohi matea mo lo toho peresir̃a tarea hin rani atu Moli Iesu mo lo toho peresir̃a, ");
INSERT INTO tgp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mo tapulo hin rani atu sei John tamlohi paptijo mo tapulo paptijo mo mai mo tikeli rani atu Iesu mo mele sahe na tuka — enia i pa vonar̃a matea sei mo hite na nona sauteterahi.” ");
INSERT INTO tgp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","La vere na tupra rua, matea enia Joseph la tovia Barsabbas teni Justus, ale haruana enia Matthias. ");
INSERT INTO tgp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ale la usiusi lara, “Moli, engko ko levosahi na mapu tamlohi tari. O vujangi kamam hin haratu sei ko vir̃onia ");
INSERT INTO tgp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","vara enia i pa lavi na jaran Judas peresi na nona vavahinau, matan enia mo vano na nona talai.” ");
INSERT INTO tgp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ale la reve na hijara, ale mo jovi isan Matthias, ale Matthias mo mai vahar̃ule matea peresi la haratu mo sangavulu r̃omana matea. ");
INSERT INTO tgp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ranin Pentecost mo pala, la lo toho na jara matea enira mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ale vahatea purongo, la rongo na hinau matea sohena langi tavera matea mo lo sere, ale mo mar̃ivisi ima atu la lo sakele hinia. ");
INSERT INTO tgp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ale hinau hai sohena pepe hapu, la pala isara la sakele aulu na patura hatehateahi. ");
INSERT INTO tgp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ale enira mo isoiso, Tanume Tapu mo sohonira, ale la tapulo retireti na leo tinatinapua sohen Tanumen God mo tinar̃ihira hinia. ");
INSERT INTO tgp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hin rani atu, Jew matuvana na jara tari na varama sei r̃omira mo r̃ilangi mata nora rasua la lo toho atu Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ale vaore tavera atu, mo vai na vao tamlohi la mai jara matea, ale la hutura matan enira hatehateahi la rongora la lo retireti na leora. ");
INSERT INTO tgp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ale la hutura, la mar̃urahi tavera lara, “Avei, la tamlohi nike, la sopo mara Galilee nakonako? ");
INSERT INTO tgp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ale mata sava natu r̃a lo rongora la lo retireti na leo jarar̃a hatehateahi sei r̃a vora hinira? ");
INSERT INTO tgp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Enr̃a mara Pathian, Medes, Elamite ale mara Mesopotamia, Judea, Cappadocia, Pontus, Asia, ");
INSERT INTO tgp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia, Pamphylia, Egypt ale jara hai Libya na lolon Cyrene, ale hai la tai Rome. ");
INSERT INTO tgp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tatuar̃a Jew, tatuar̃a enira la tamlohi r̃or̃oha sei la lo usuri Moses, ale mara Crete peresi na mara Arabia — r̃a rongora la lo retireti na leor̃a. La lo vere na vavahinau r̃uhu mata suiha non God.” ");
INSERT INTO tgp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ale enira mo isoiso, la mar̃urahi la hutura, la lo vereverera hinia lara, “Matamata mata sava nahai?” ");
INSERT INTO tgp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pani tatuara la kerehira lara, “Hara sei, la drong na waen meji!” ");
INSERT INTO tgp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ale Peter peresi la tupu sangavulu r̃omana matea atu, la turu mai na nahora, ale mo ulo mo verea isara mara, “Mara Judea, ale mara Jerusalem tari, ha tapurongo! Ha levosahi mamahuni hinau nike! ");
INSERT INTO tgp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Matan la tamlohi nike la sopo drong sohen ka lo r̃omr̃omia, matan mo pa lo r̃alavuho purongo nahai. ");
INSERT INTO tgp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pani hinau nike pr̃ovet Joel mo verea moiso mara, ");
INSERT INTO tgp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God mo verea mara: Na pongi hitahu, a pa surei na Tanumeku na tamlohi tari, ale natumim peresi na venatumim la pa retimangovi, ale uluvoumim lamane la pa hite na hinau sohena mavuho a pa vujangia isara, ale vajiahamim a pa silera na mavuho; ");
INSERT INTO tgp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","hin pongi atu sohena, a pa surei na Tanumeku isana noku slev lamane peresi na slev har̃ai, ale la pa retimangovi. ");
INSERT INTO tgp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ale a pa vujangi na matamata mar̃urahi tavera aulu na masapa, ale matamata mata r̃ae, hapu peresi na asu hapu atano na varama, ");
INSERT INTO tgp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ale alo i pa posi i mai i r̃or̃oha, majhi vitu i pa hahara sohena r̃ae, la pa pala tiroma hin rani atu Moli i pa mele mai, rani tavera atu i pa r̃uhur̃uhu jea. ");
INSERT INTO tgp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ale rani matea i pa mai vara sava tamlohi la tau na nora rasu na hijan Moli la pa juri.’” ");
INSERT INTO tgp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ale Peter mo mele verea mara, “Tavtavuin Israel, ha tapurongo! Iesu mara Nazareth, tamlohi matea God mo taua na nahomim, mo lo vai na vavahinau mata suiha, matamata r̃uhur̃uhu tavera, peresi na matamata mar̃urahi sei God mo vaira na nahomim hin Iesu, sohen kamim mo isoiso ka levosahi mamahunia — ");
INSERT INTO tgp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","tamlohi atu, ka taua na lima tamlohi sasati, matan vara la pa vosaea na talopeilopei vara i mate, pani haratu mo pa lo usuri na r̃omr̃omi tavera non God, ale enia mo levosahia tiroma moiso vara i pa sohena. ");
INSERT INTO tgp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pani God mo sauteterahia, mo teria na liman mateia, matan mateia i pa sopo er̃i tauria na suihana. ");
INSERT INTO tgp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Matan supe David mo retireti matana mara, ‘Tarea na lo hite Moli na nahoku, matan enia mo lo toho na matuaku, enau a pa sopo hisu. ");
INSERT INTO tgp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Matan haratu mapuku mo avulahi, ale leoku mo uloulo na hasohasona! Epeku i pa toho na liman r̃omtoho, ");
INSERT INTO tgp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","matan engko God o pa sopo tinar̃ihia vara a toho na varama mata mateia, teni vara o tinar̃ihia vara nom tamlohi tapu i r̃ovo na taptap. ");
INSERT INTO tgp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Engko ko vujangiau moiso na malele mata mauri; engko o pa vaiau a avulahi tavera na nahom.’ ");
INSERT INTO tgp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","La vorai, na levosahi mamahunia vara a er̃i verea isamim, vara pua David mo mate ale la tavunia. Ale tapuna mo lo toho peresir̃a mo kakau nake. ");
INSERT INTO tgp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Matan David enia pr̃ovet matea, mo levosahia vara God mo vai na retitauhi matea peresia, vara mahapina matea, i pa sakele na nona jara sakele mata supe, ");
INSERT INTO tgp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David mo hiteulia tiroma moiso, ale mo verea mara Kr̃isto i pa sauteterahi, ale vara i pa sopo taua vara i lo toho na varama mata mateia teni vara epena i r̃ovo. ");
INSERT INTO tgp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iesu sei, God mo sauteterahia na mateia, ale kamam mo isoiso kama hitea. ");
INSERT INTO tgp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nake, God mo tahea mo sahe na matuana, vara i tauri na suiha tavera sei mo aulu jea mo jeu na tinapua na tuka, ale usuri na retitauhi non God Tama, mo lavi na Tanume Tapu, ale mo sureia hin kamam, sei ka lo rongoa ale ka lo hitea nakerihi. ");
INSERT INTO tgp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Matan David mo sopo lo sahe aulu na tuka, pani enia mo verea mara, ‘Moli, mo verea isan noku Moli: O sakele na matuaku, ");
INSERT INTO tgp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","i tikeli rani atu a vai na nom meresahi, la toho na ruhuruhu palom.’ ");
INSERT INTO tgp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Matan haratu, mo r̃uhu vara tamlohi tari Israel la levosahi mamahunia vara God mo vaia mo mai Moli! Ale mo vaia mo mai Kr̃isto, pa Iesu atu sei ka lo vosaea na talopeilopei!” ");
INSERT INTO tgp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lara la rongo na nona reti, r̃omira la jovi vahatea. Ale la verea isan Peter tolu na vahar̃ule tari atu lara, “La vorai, kama pa vai na sava?” ");
INSERT INTO tgp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ale Peter mo verea isara mara, “Ha posi! Ale ha paptijo kamim mo isoiso na hijan Iesu Kr̃isto, matan vara God i r̃omi na nomim hehe! Ale i pa sile purongoi kamim na Tanume Tapu. ");
INSERT INTO tgp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Matan retitauhi nike, enia nomim peresi na natumim, ale nona tamlohi tari sei la lo toho asau r̃ove, tamlohi mo isoiso sei Moli nor̃a God i pa tovira vara la mai isana.” ");
INSERT INTO tgp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ale Peter mo mele vujangira vavano, mo verea r̃ilangi isara mara, “Ha juri kamim hasemim hin pina lejileji nike!” ");
INSERT INTO tgp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ale evin la haratu sei la rasu na nona reti moiso la paptijo hin rani atu, la mai kalesia korong mariviti tari vaha tolu . ");
INSERT INTO tgp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ale la hase taura na vujangi nona vahar̃ule, ale la matavuhi mata hanhani tapu peresi na usiusi. ");
INSERT INTO tgp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ale matahu tavera mo sohoni na tamlohi tari matan vahar̃ule la vai na hina mar̃urahi tavera matuvana peresi na matamata tavera. ");
INSERT INTO tgp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ale tarea, tamlohi rasua tari la lo pulutahi jara matea, ale hinau tari enia nora enira mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ale la lo ar̃ehi na jarara peresi na nora hinahinau, ale la lo asera isan la haratu la vejuveju hin te hinau. ");
INSERT INTO tgp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ale na rani hatehateahi, la lo matavuhi na Temple, ale la lo lavi na hanhani tapu na lolo imara, ale na nora hanhani la vaia na avulahi peresi na hansohai. ");
INSERT INTO tgp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","La hasohaso God, ale tamlohi tari la avulahi hinira. Ale na rani hatehateahi tamlohi tinatinapu sei Moli mo jurira, la lo pulutahi peresira. ");
INSERT INTO tgp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Peter enia John la lo sahe na Temple na rani mata usiusi na matan alo mo tolu na ravravi. ");
INSERT INTO tgp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ale tamlohi hai, la lavi na tamlohi matea mo vora mo hariju moiso. La lavia matan vara la pa mele taua i juruvi sohen tarea na pahisa matarua matea na ropen Temple atu sei la tovia ‘Matarua R̃uhur̃uhu’ vara i mele usi na mania isan la haratu la lo unu na Temple ea. ");
INSERT INTO tgp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mara mo hite Peter peresi John la lo unu na Temple, mo usi na mania isara. ");
INSERT INTO tgp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ale Peter mo kilau tataholo sivo isana, ale John sohena mo vaia ale Peter mara, “O kilau kamam.” ");
INSERT INTO tgp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ale tamlohi hariju atu mo tar̃engira matan mo lo r̃omr̃omia mara la pa sile te hinau isana. ");
INSERT INTO tgp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pani Peter mo verea mara, “Mo sopo te noku silver teni gold, pani sava enia noku, a pa silea isam na hijan Iesu Kr̃isto mara Nazareth. O turu o hahau!” ");
INSERT INTO tgp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ale Peter mo sohai na matua limana mo tauria mo saua, ale vahatea purongo, varango palona peresi na jue palona la r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ale mo kue mo sahe aulu mo turu, ale mo tapulo hahau r̃alihi na palona, ale mo usurira la unu na lolo rope Temple. Mo lo hahau, mo lo kuekue ale mo lo hasohaso God. ");
INSERT INTO tgp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ale tamlohi mo isoiso la hitea mo lo hahau mo lo hasohaso God, ");
INSERT INTO tgp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ale la hitevosahia vara enia natu pa tamlohi atu sei mo lo sakele na ‘Matarua R̃uhur̃uhu’ mata Temple tarea mo lo usi na mania. Ale la mar̃urahi tavera na sava mo masese isana. ");
INSERT INTO tgp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mara mo pa lo keho hin Peter enia John, tamlohi tari la maro la mai isara hin jara atu sei la tovia Palapalan Solomon, ale la hutura tavera hinia. ");
INSERT INTO tgp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ale Peter mara mo hitera la lo mai mo verea isara mara, “Tavtavuin Israel, mata sava ka hutu kamim hin hinau nike, teni mata sava ka lo varoi kamam sohena, vara kama vai tamlohi akerihi mo mele hahau na nomam suiha teni matan nomam posposi tataholo? ");
INSERT INTO tgp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God non Abraham, God non Isaac, God non Jacob, God non nor̃a pua, mo tahe nona volitusi sei Iesu, hara sei ka taua na liman nor̃a tamlohi aulu, ale ka r̃ohu hinia na nahon Pilate hin rani atu mo opoia vara i teria. ");
INSERT INTO tgp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pani kamim, ka tipahi haratu sei mo tapu mo tataholo jea, ale ka usi Pilate vara i sile kamim na tamlohi vilimatei na tamlohi matea. ");
INSERT INTO tgp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ale ka vilimatei haratu enia pulo mauri, hara sei God mo sauteterahia na mateia. Hinau sei kamam kama hitea na matamam. ");
INSERT INTO tgp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ale tamlohi akerihi ka hitea ale ka levosahia, kama lo verea vara nona rasua na hijan Iesu natu mo vaia mo r̃ilangi. Rasua atu hin Iesu mo vai mamahuni na epena na nahomim mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ale la vorai, na levosahia vara ka sopo levosahi na sava ka vaira, sohen nomim tamlohi aulu la vaira. ");
INSERT INTO tgp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pani sava God mo verea tiroma moiso na jingo pr̃ovet tari, sei vara nona Kr̃isto i pa lavi na rongohaji sohena sava ale mo mar̃ivisia. ");
INSERT INTO tgp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Matan haratu, ha posi, ale ha posi mai isan God matan vara i jarai nar̃ihi na nomim hehe, ");
INSERT INTO tgp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","matan vara rani r̃uhur̃uhu mata suiha paro la mai isamim la tai na nahon Moli, ale i pa mele r̃ule Iesu vara i mele mai isamim sei God mo vir̃onia vara i nomim Kr̃isto, ");
INSERT INTO tgp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","enia i pa toho na tuka i tikeli rani atu God i mele vai tataholoi na hinau tari sohen mo verea na reti nona pr̃ovet tuai moiso. ");
INSERT INTO tgp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses mara, ‘Moli God i pa tahe na nomim pr̃ovet matea na voraimim soheku. Ha pa tapurongo na hinau tari i pa verea isamim.’ ");
INSERT INTO tgp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ale mo mele verea mara, ‘Tamlohi tari sei la r̃ohu vara la oloolo hin pr̃ovet atu God i pa langahi nar̃ihira na nona tamlohi ale i pa vilimateira.’ ");
INSERT INTO tgp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ale pr̃ovet tari sei la sile na nora retireti, mo tapulo isan Samuel peresi la haratu la pa mai hitahuna, enira sohena la pete retivujavujangi hin la rani nike moiso. ");
INSERT INTO tgp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kamim, ka natun la pr̃ovet atu tuai, ale ka natun retitauhi atu God mo vaia peresi na nomim pua, sei mo verea isan Abraham mara, ‘Ale na mahapim, vao tamlohi tari na varama la pa avulahi tavera hinia’. ");
INSERT INTO tgp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hin rani atu God mo sauteterahi nona volitusi mo r̃ulea mo mai isamim tiroma tavtavuin Israel, matan vara i ler̃uhu hin kamim i vai kamim ha posi na nomim posposi hehe.” ");
INSERT INTO tgp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ale Peter enia John la pa lo retireti isana tamlohi, pr̃is peresi na patu tamlohi nona police mata Temple peresi na Sadducee hai la mai isara. ");
INSERT INTO tgp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","La lolokoru tavera hinira matan la lo vujangi na tamlohi, ale matan la lo retivujavujangia vara God mo sauteterahi Iesu na mateia. ");
INSERT INTO tgp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ale la taurilatira, la taura na ima r̃ilangi mo tikeli na rani tinapua matan mo pete ravravi moiso. ");
INSERT INTO tgp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pani tamlohi matuvana hin la haratu la lo tapurongo isara, la rasua. Ale evin la tamlohi atu mariviti i tari vaha lima . ");
INSERT INTO tgp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ale mo mele rani sahe, nora tamlohi aulu peresi na vajiahara peresi na tamlohi vujangi mata leu, la matavuhi jara matea Jerusalem, ");
INSERT INTO tgp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","peresi Annas sei pr̃is aulu, ale Caiaphas, John, Alexander ale tamlohi tari sei la tai na vaon pr̃is aulu. ");
INSERT INTO tgp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ale la vaira la turu na livuhara, ale la tapulo usira lara, “Ka vai hinau atu na sava suiha teni na hijan hare?” ");
INSERT INTO tgp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ale Tanume Tapu mo sohoni Peter mo verea isara mara, “Tamlohi aulu peresi na vajiaha; ");
INSERT INTO tgp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","vara ka lo usi kamam vara kama vai na hina r̃uhu isan tamlohi hariju nike sohena sava, ");
INSERT INTO tgp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ale a pa verea i mera i r̃uhu isamim tari, ale isana tamlohi tari Israel, vara tamlohi nike mo r̃uhu na hija peresi na suihan Iesu Kr̃isto mara Nazareth sei ka lo vosaea na talopeilopei, pani God mo sauteterahia na mateia. ");
INSERT INTO tgp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu akerihi natu enia, ‘Vatu atu kamim tamlohi voro ima ka tipahia, enia mo mai pulo vatu mata ima.’ ");
INSERT INTO tgp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ale mo sopo mele te malele tinapua vara tea i er̃i juri hinia matan mo sopo mele te hija tinapua na varama vara God mo silea vara tamlohi la pa juri hinia.” ");
INSERT INTO tgp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ale lara la hite na turu r̃ilangi non Peter enia John, la mar̃urahi tavera matan la levosahia vara la tamlohi nike la sopo lavi te lelevosahi isara, ale la vara enira la tamlohi purongo purongo, ale la pa hitevosahia vara enira la lo toho peresi Iesu tiroma. ");
INSERT INTO tgp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pani lara la hite tamlohi atu sei mo mele r̃uhu mo lo turu na pahisara, la sopo er̃i mele vere te hinau sati vano isara. ");
INSERT INTO tgp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ale lara la retileu vara la malue na nora matavuhi, ale la tapulo sorasorahia isara — ");
INSERT INTO tgp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","lara, “R̃a pa vai na sava isan la tamlohi nike? Matan la vai na matamata tavera matea na naho tamlohi tari Jerusalem, ale r̃a sopo er̃i vunvunia. ");
INSERT INTO tgp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pani matan vara r̃a opoia vara r̃a horora vara la sopo mele retivujavujangia isana tamlohi, r̃a pa retir̃oar̃oahaira vara la sopo mele vujangi hin Iesu isan tea.” ");
INSERT INTO tgp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ale la tovira la mele mai la turu na nahora, ale la silera na reti r̃ilangi matea vara la sopo mele retireti teni la vujangi na hijan Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pani Peter peresi John la r̃aramira lara, “Vara ka hitea mo tataholo vara kama oloolo hin kamim, pani mo sopo hin God, ha to kilausuria; ");
INSERT INTO tgp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","matan kama sopo er̃i isoiso na nomam retireti na sava hina r̃uhu kama hitea, ale na sava kama rongoa moiso.” ");
INSERT INTO tgp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Matavuhi atu la mele sile na reti r̃ilangi tinapua hai isara, pani la tinar̃ihira la malue matan la sopo levosahia vara la pa sile na talai isara sohena sava matan vara la vaia vao tamlohi atu la pa lolokoru matan la lo hasohaso God matan matamata tavera atu. ");
INSERT INTO tgp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Matan matamata tavera atu mo masese hin tamlohi atu mo hariju mata tauni mo jeu mo ngavulu vati moiso. ");
INSERT INTO tgp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peter enia John lara la malue isara, la mele vano na vaora mata tamlohi rasua, ale la verera na hinau tari sei la pr̃is aulu atu peresi na vajiahara la verea isara. ");
INSERT INTO tgp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lara la rongo la hinau atu, enira mo isoiso la tahe na leora, la usiusi isan God na r̃omr̃omi matea purongo ale lara, “Moli aulu na hinau tari, engko ko vai na tuka peresi na varama, na tasi ale hinau tari sei la lo toho na lolora. ");
INSERT INTO tgp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ko verea tuai na Tanume Tapu na retireti non nom volitusi supe David nomam pua vara, ‘Mata sava tamlohi r̃or̃oha la lo lolokoru patura, ale mata sava tamlohi la lo hatihia vara la pa vai na hinau rongorongo vono? ");
INSERT INTO tgp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Matan supe mata varama la turu jara matea, ale tamlohi aulu la matavuhi jara matea, matan vara la turuleji hin Moli God peresi na nona Kr̃isto.’ ");
INSERT INTO tgp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Matan Herod enia Pontius Pilate, peresi na tamlohi r̃or̃oha, peresi na tavtavuin Israel la matavuhi jara matea hin taon tavera nike, la turuleji hin nom volitusi tapu Iesu, haratu ko vir̃onia mata juri na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Varar̃uhu hinau tari la masese usuri na masalom, peresi na nom r̃omr̃omi tavera sei ko taua vara i pa sohena tiroma moiso. ");
INSERT INTO tgp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ale nake Moli, o tapurongo na nora retireti leji, ale o vai na nom volitusi la vere na nom retisohai i sopo te matahu hinira, ");
INSERT INTO tgp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ale o sohai na suiha mata vai na rojoa i tihai, ale vara matamata tavera peresi na hinau mar̃urahi la pala na hijan nom volitusi tapu Iesu.” ");
INSERT INTO tgp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","La usiusi mo isoiso, ale jara atu sei la lo matavuhi ea mo hutehi, ale enira mo isoiso Tanume Tapu mo sohonira, ale mo tapulo hin rani atu mo vano, la retivujavujangi na retisohai non God, ale mo sopo te matahu hinira. ");
INSERT INTO tgp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Vao tamlohi rasua atu r̃omira mo matea purongo, ale mo sopo tea isara i er̃i verea vara nona hinau enia nona hasena, pani nora hinau tari enira nora mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Retivujavujangi non la vahar̃ule atu mata sauteterahi non Moli Iesu mo suiha. Ale God mo ler̃uhu hinira mo isoiso mo tavera jea ");
INSERT INTO tgp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","matan mo sopo tea isara i vejuveju hin te hinau, matan la haratu sei nora lepa teni imara, la ar̃ehira ale la lavi na volira, ");
INSERT INTO tgp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","moiso la taura na lima vahar̃ule, moiso la asera isan la haratu la vejuveju hin te hinau. ");
INSERT INTO tgp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ale vonara matea enia Joseph, tapala hijana vahar̃ule la silea isana enia Barnabas, r̃aramin hija sei enia ‘Tamlohi mata Retituetueni’, enia mara Cyprus matea mo tai na vao Levi na tavtavuin Israel. ");
INSERT INTO tgp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ale mo ar̃ehi na nona lepa matea, ale mo lavi na volina mo mai mo silea isana vahar̃ule. ");
INSERT INTO tgp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tamlohi tinapua matea sohena hijana Ananias peresi narouna Sapphira, la ar̃ehi na nora hinahinau. ");
INSERT INTO tgp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias mo taurilati na sope volin la nora hinau atu sei la lo ar̃ehira, ale narouna mo levosahia. Enia mo lavi na sopena mo silea isana vahar̃ule, ale mo verea mara volina enira mo isoiso natu. ");
INSERT INTO tgp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pani Peter mo verea mara, “Ananias, mata sava ko tinar̃ihi Setan mo sohoni na mapum mo vaiho ko halu Tanume Tapu moiso ko taurilati na sope voli lepa vara nom hasem? ");
INSERT INTO tgp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ko sopo lo ar̃ehia enia nom teni mo vono? Ale kora ko ar̃ehia moiso volina mo lo toho na limam vara o pa silea teni mo vono? Mata sava ko r̃omr̃omia vara o vai na hinau matea sohen harihi? Ko sopo halu kamam, pani ko lo halu God!” ");
INSERT INTO tgp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias mara mo rongo la reti atu, mo jovi sivo na lepa mo mate. Ale matahu mo sohoni enira mo isoiso sei la rongo hinau atu. ");
INSERT INTO tgp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ale uluvou hai la mai, la tatavua ale la alialia la vano la tavunia. ");
INSERT INTO tgp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ale aoa mo tolu mo vano moiso, narouna mo pete pala mo unu pani mo sopo levosahi te hinau na sava mo masese moiso. ");
INSERT INTO tgp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter mo verea isana mara, “O to vereau hinia, vara volin lepa atu enira mo isoiso nakerihi natu teni mo vono?” Sapphira mara, “He'e, volina natu.” ");
INSERT INTO tgp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ale Peter mo verea isana mara, “Mata sava kamim tupra rua ka hatihia vara ha pa vaihite na Tanumen Moli? O to kilau sahe, la tamlohi atu sei la lo tavuni tuam la lo mele mai, ale nakerihi sohena la pa pete alialiho!” ");
INSERT INTO tgp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Vahatea purongo, mo jovi na palon Peter mo mate. Ale la uluvou atu lara la unu na lolo ima la hitea, la alialia la vano la tavunia na pahisan tuana. ");
INSERT INTO tgp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Matahu tavera mo sohoni na vao kalesia tari peresi na tamlohi tari sei la lo rongo hinau atu sei mo masese. ");
INSERT INTO tgp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Matamata tavera matuvana peresi na hinau mar̃urahi la pala na liman la vahar̃ule atu na naho tamlohi. Ale enira mo isoiso la lo matavuhi jara matea na Palapalan Solomon. ");
INSERT INTO tgp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ale la haratu la sopo lo toho na lolo vaora, la matahu tavera vara la pulutahi peresira, pani tamlohi la sile na oloolo tavera isara. ");
INSERT INTO tgp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ale rani hatehateahi, tamlohi la lo tau na nora rasua hin Moli, vao har̃ai peresi na vao tamlohi la lo mai. ");
INSERT INTO tgp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ale tamlohi la lo tau na nora tamlohi rojoa na pahisa malele, la taura na vata teni na epa matan vara r̃or̃on Peter purongo i er̃i tikeli na epen te tatuara ale nora rojoa la tihai, vara i hahau i lo vano. ");
INSERT INTO tgp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vao tamlohi la lo tai na vanua varihi r̃alihi Jerusalem la lo lavi na nora tamlohi rojoa peresi la haratu tanume sasati mo sohonira la mai isara, ale enira mo isoiso nora rojoa la tihai. ");
INSERT INTO tgp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ale pr̃is aulu peresi la haratu la lo toho peresia enira Sadducee, ale enira la mar̃ivi na mereimerei, ale mo vaira la lolokoru. ");
INSERT INTO tgp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","La taurilati la vahar̃ule atu, la taura na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pani hin vutepongi atu, angelo non Moli matea mo sinai mo roi na pelatin ima r̃ilangi atu mo tiromara la malue, ale mo verea isara mara, ");
INSERT INTO tgp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ha vano, ale ha turu na lolo rope Temple, ale ha retivujavujangi na tamlohi na retisohai hin mauri nike!” ");
INSERT INTO tgp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ale lara la rongoa sohena, la vano la unu na rope Temple mo pa lo r̃ari na rani ale la tapulo vujangi. Ale pr̃is aulu peresi la haratu la lo toho peresia la pala na Temple, la tovi na council tavera nona tavtavuin Israel sei la tovia Sanhedrin matan vara la pa sakele. Ale la r̃ule na tamlohi hai la vano na ima r̃ilangi vara la lavi la vahar̃ule atu la mai isara. ");
INSERT INTO tgp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pani police mata Temple lara la pala na ima r̃ilangi, la sopo hitera, ale la mele hilu la vano la vereulia isara lara, ");
INSERT INTO tgp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kama hite na ima r̃ilangi mo pa lo loko mo r̃uhu, ale tamlohi kilau na ima r̃ilangi la lo turu na nora pelati, pani kamara kama roira, kama sopo hite tea na lolora.” ");
INSERT INTO tgp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tamlohi tavera nona police mata Temple peresi na moli nona pr̃is lara la rongoa sohena, la hutura tavera hinia matan la sopo levosahia vara i pa isoiso epu. ");
INSERT INTO tgp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pani tamlohi matea mo mai mo vereulia isara mara, “Eh! La tamlohi atu ka lo taura na ima r̃ilangi enira nahai la lo turu na lolo rope Temple, la lo vujangi na tamlohi!” ");
INSERT INTO tgp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ale tamlohi tavera nona police mata Temple peresi na nona police, la vano la lavi malumira la mai matan la matahu vara tamlohi la pa parura vara la vai na hinau r̃ilangi isara. ");
INSERT INTO tgp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","La lavira la mai la vaira la turu na nahon nora council tavera, ale pr̃is aulu mo usi na retiusia isara ");
INSERT INTO tgp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","mara, “Kama retihoro kamim moiso vara ha sopo mele retivujavujangi na hijan tamlohi atu. Ka hitea, nake Jerusalem mo mar̃ivi na nomim vujangi, ale ka opoia vara ha tau na r̃aen tamlohi nike isamam!” ");
INSERT INTO tgp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pani Peter peresi na vahar̃ule la r̃aramia lara, “Kama pa oloolo hin God hasena, mo sopo na tamlohi. ");
INSERT INTO tgp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","God non nor̃a pua tuai mo sauteterahi Iesu na mateia, mo vaia hitahu hin la rani atu sei ka vilimateia ka vosaea na talopeilopei. ");
INSERT INTO tgp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God mo tahea aulu na matuana mo vaia mo pulon mauri nike ale Jujuri matan vara i sile na masapa isan Israel vara la posi, ale i r̃omi na nora hehe. ");
INSERT INTO tgp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kamam kama hite vevuhi la hinau nike, ale Tanume Tapu sei God mo silea isan la haratu la lo oloolo hinia enia sohen mo hitea.” ");
INSERT INTO tgp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lara la rongoa sohena la lolokoru patura, ale la opoia vara la vilimateira. ");
INSERT INTO tgp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pani Pharisee matea hijana Gamaliel, enia tamlohi vujangi mata leu matea. Tamlohi la lo sile na oloolo isana matan la opoia, mo turu na naho council ale mo verea vara la tau nar̃ihira na jingoima tako. ");
INSERT INTO tgp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Moiso mo verea isan council atu mara, “La tavtavuin Israel, mo r̃uhu vara r̃a lo kilau i r̃uhu na sava r̃a opoia vara r̃a vaia isan la tamlohi nike. ");
INSERT INTO tgp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Matan tauni mo visa mo vano moiso nahai, Theudas mo turu mo verea mara enia tamlohi tavera matea, ale korong tamlohi mo ngavulu sangavulu vati la usuria. Pani hitahuna hai la vilimateia ale nona tamlohi la taskara, ale nona r̃omr̃omi atu mo mai hina purongo. ");
INSERT INTO tgp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ale hitahun haratu mara Galilee matea hijana Judas, mo turu hin rani atu la lo evi na tamlohi, ale mo vai na tamlohi la lo usuria mata valum. Enia sohena mo mate, ale nona tamlohi usuri tari la taskara. ");
INSERT INTO tgp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ale matan haratu, noku retituetueni isamim enia mo sohen harihi: vara ha toho asau hinira ha tinar̃ihira, matan vara r̃omr̃omi sei la lo vujangia teni hinau sei la lo vaia mo tai isana tamlohi purongo i pa mele mai hina purongo, ");
INSERT INTO tgp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","pani vara mo tai isan God, ha sopo er̃i horora, vara i vono ha pa hiteulia vara ka lo valum peresi God.” Ale la tatauri na nona r̃omr̃omi, ");
INSERT INTO tgp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ale la mele tovi na vahar̃ule la mele unu, ale la tamajira, moiso la verea isara vara la pa sopo mele retireti na hijan Iesu, ale la tinar̃ihira. ");
INSERT INTO tgp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","La vahar̃ule atu, la malue hin matavuhi tavera atu. La avulahi matan God mo hitea vara mo tataholo vara la lavi na rani r̃ilangi mata hijan Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ale na rani hatehateahi na lolo Temple peresi na imara, la lo vujangi ale la retivujavujangi na Retir̃uhu vara Iesu enia Kr̃isto atu tamlohi la lo kilau matana. ");
INSERT INTO tgp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hin rani atu evi tamlohi usuri non Iesu mo lo ulua, ale retireti matea mo malue isana Jew sei la retireti na leo mara Greek. Ale la sopo avulahi na Jew sei la lo retireti na leon tavtavuin Israel, matan tarea vara la ase na hanhani nora malepu la sopo lavi tea. ");
INSERT INTO tgp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ale la tupu sangavulu r̃omana mo rua atu la tovi matavuhi na tamlohi usuri la mai, ale lara, “Mo sopo tataholo vara kama tinar̃ihi na vujangi mata reti non God mata kilau na hamim hinau. ");
INSERT INTO tgp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pani ha vir̃oni mamahuni te vorai kalesia i limaravrua isamim tamlohi tari sei ka levosahia vara Tanume Tapu peresi na lelevosahi mo mar̃ivi hinira, ale r̃a pa taura la aulu hin la hinau sei. ");
INSERT INTO tgp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pani kamam kama pa tau na r̃omimam tari mata usiusi, ale na vavahinau mata Retir̃uhu.” ");
INSERT INTO tgp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tamlohi tari la avulahi hin r̃omr̃omi atu, ale la vir̃oni Stephen, tamlohi matea sei mo jea na nona rasua ale Tanume Tapu mo mar̃ivisia, la vir̃oni Philip, Prochorus, Nicanor, Timon, Parmenas peresi Nicolaus mara Antioch matea enia tamlohi r̃or̃oha matea pani mo usuri na nora rasua, moiso mo posi mo mai tamlohi kalesia matea. ");
INSERT INTO tgp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","La vao atu la vaira la turu na naho vahar̃ule, ale la vahar̃ule atu la tau na limara hinira, ale la usiusi matara. ");
INSERT INTO tgp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Reti non God mo lo vano, ale evi tamlohi usuri Jerusalem mo lo sahe aulu jea. Ale vao tavera matea mata pr̃is la lavi pa rasua atu ale la oloolo hinia. ");
INSERT INTO tgp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen, tamlohi matea sei mo mar̃ivi na hina r̃uhur̃uhu peresi na suiha God mo silea isana, mo vai na matamata tavera na naho tamlohi. ");
INSERT INTO tgp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pani tamlohi hai Jew na vao matea la tovia ‘Ima Lotu Nona Tamlohi Materi’. Hai la mara Cyrene, mara Alexandria, tatuara la tai Cilicia peresi Asia, la turu la vasi peresi Stephen. ");
INSERT INTO tgp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pani la sopo er̃i retihoro na lelevosahi sei Tanume Tapu mo silea isana vara mo retireti. ");
INSERT INTO tgp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ale la haluhalu na tamlohi hai vara la vere te hinau halu hin Stephen lara, “Kama rongoa mo retisati hin Moses enia God.” ");
INSERT INTO tgp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","La halu na tamlohi, peresi na vajiahara tolu na tamlohi vujangi mata leu, moiso la mai isan Stephen, la tauria ale la vaia mo turu na naho council. ");
INSERT INTO tgp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pa la tuetueni halu atu lara, “Tarea tamlohi nike mo lo retisati hin jara tapu nike peresi na leu. ");
INSERT INTO tgp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Matan kama rongoa mo verea mara Iesu mara Nazareth i pa komo jara nike, ale mo posi na posposi sei Moses mo lo silea mo sinai mo kakaur̃a nake.” ");
INSERT INTO tgp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tamlohi tari hin matavuhi atu sei la lo sakele atu, la hite na nahon Stephen mo posi sohena naho angelo matea. ");
INSERT INTO tgp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ale pr̃is aulu mo verea isan Stephen mara, “La hinau atu la varar̃uhu?” ");
INSERT INTO tgp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ale Stephen mara, “La vorai peresi na vajiaha, ha tapurongo na noku reti. God mata mera tavera mo pala isan nor̃a pua Abraham hin rani atu mo lo toho Mesopotamia, moiso mo pa vano mo toho Haran, ");
INSERT INTO tgp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ale mo verea isana mara, ‘O malue na jaram peresi na tahisam, ale o vano na jara matea enau a pa vujangia isam.’ ");
INSERT INTO tgp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ale mo malue na jara mara Chaldea, mo vano mo lo toho Haran. Hitahu, tamana mo mate, ale God mo tinar̃ihia atu mo taua hin jara nike nake r̃a lo toho hinia. ");
INSERT INTO tgp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pani mo sopo sile te tavaluna hatelete isana sohena koruna, pani mo retitauhi isana vara i pa silea isana sohena nona peresi na taniana sei la pa usuria, hina purongo vara mo sopo te natuna. ");
INSERT INTO tgp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pani God mo mele retireti isana sohen harihi mara, ‘Mahapim la pa vinano na jara tamlohi tinapua, ale tamlohi hin jara atu la pa vaira la slev, la pa vailejlejira mata tauni i ngavulu sangavulu vati. ");
INSERT INTO tgp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pani a pa sile na talai isan la haratu la lo slev nora, moiso hitahu la pa malue hin jara atu la mai la lotuau nike.’ ");
INSERT INTO tgp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ale mo sile Abraham na retitauhi mata tair̃alihi, ale Abraham mo mai taman Isaac, ale mo tair̃alihia na halimaravtolu rani nona vora, ale Isaac mo mai taman Jacob, ale Jacob enia taman la pua atu tupu sangavulu r̃omana mo rua. ");
INSERT INTO tgp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ale la pua atu, la mereimerei hin Joseph, la ar̃ehia mo sivo Egypt; pani God mo lo toho peresia ");
INSERT INTO tgp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","matan vara i pa juria na nona rani r̃ilangi tari, ale i tuenia na lelevosahi na nahon Pharaoh, supe non Egypt matan vara Pharaoh i avulahi hinia ale mo tahea vara i aulu Egypt peresi na hinau tari nona. ");
INSERT INTO tgp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Hin rani atu marua tavera matea mo vili na jara tari Egypt peresi Canaan na rani r̃ilangi. Ale nor̃a pua la sopo er̃i hite te hanhani. ");
INSERT INTO tgp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pani na rani Jacob mo rongoa vara hanhani mo lo toho Egypt, mo r̃ule na nor̃a pua la sivo, harihi enia nora tiroma hahau hin jara atu. ");
INSERT INTO tgp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ale na nora harua hahau la sivo atu, Joseph mo hase vuhesia isana voraina, ale Pharaoh mo pa levosahi na vaon Joseph natu. ");
INSERT INTO tgp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Moiso Joseph mo r̃ulera la mele sahe, ale la usi Jacob tamana peresi na tamlohi tari na ruhuruhuna sei enira mo isoiso mo ngavulu limaravrua mo lima vara la sinai. ");
INSERT INTO tgp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ale Jacob mo sivo Egypt mo pa mate atu, enia peresi na nor̃a pua, ");
INSERT INTO tgp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ale la lavi na suira la sahe la taura Shechem na papa sei Abraham mo volia isan natun Hamor atu Shechem. ");
INSERT INTO tgp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Pani rani mata retitauhi non God sei mo silea isan Abraham mo mai mariviti, tanian Abraham la mar̃ivi jea Egypt, ");
INSERT INTO tgp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","mo tikeli rani atu supe tinapua matea mo tauri na suiha Egypt, ale enia mo sopo opoia vara i levosahi na mahapin Joseph. ");
INSERT INTO tgp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mo haluhalu na tahisar̃a, ale mo vere na nor̃a pua vara la tau na natura la toho hasera na jara tavera matea matan vara la pa mate ea. ");
INSERT INTO tgp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Hin rani atu Moses mo vora, God mo avulahi hinia. Ale tamana la jarohia na ima mata vitu mo tolu, ");
INSERT INTO tgp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ale hin rani atu la lavia mo pala na jara tavera venatun Pharaoh mo tapaia mo korohia sohena natuna. ");
INSERT INTO tgp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ale la vujangia na lelevosahi tari nona mara Egypt, ale enia mo mai tamlohi r̃uhu matea mata retireti peresi na nona vavahinau. ");
INSERT INTO tgp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Na rani taunina mo ngavulu vati, r̃omina mo mai vara i vano i hite na tasina, mahapin Israel. ");
INSERT INTO tgp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Moses mara mo hite na mara Egypt matea mo lo vailejleji na tahisana matea, mo tueni tahisana atu mo vilimatei pa mara Egypt atu. ");
INSERT INTO tgp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses mo lo r̃omr̃omia vara tahisana la pa hitevosahia vara God mo r̃ulea mo mai isara vara i jurira, pani la sopo hitevosahi na sava mo lo vaia. ");
INSERT INTO tgp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ale mo mele rani sahe mo mele pala, ale mo hite na tamlohi tavtavuin Israel mo rua la lo vasvasi, ale mo vaihitea vara i tau na tamata isara mara, ‘La tapala, kamim vorai matea purongo, mata sava ka lo vailejleji kamim?’ ");
INSERT INTO tgp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pani tamlohi atu sei mo lo vailejleji na tahisana purongo, mo sohai nar̃ihi Moses, ale mo verea mara, ‘Hare mo vaiho ko aulu vara o er̃i ari kamam? ");
INSERT INTO tgp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ko opoia vara o mele viliau sohen ko vili mara Egypt atu nanovi teni?’ ");
INSERT INTO tgp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tamlohi atu mara mo verea sohena, Moses mo rovo mo vano mo vinano na jara mara Midia, ale hin jara atu mo mai tama matea natuna lamane mo rua. ");
INSERT INTO tgp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ale mele tauni mo ngavulu vati tinapua angelo matea mo pala isana na jara hasetoho na vutin Sinai na pepe hapu na pulo pahai matea mo lo hani. ");
INSERT INTO tgp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses mara mo hitea mo mar̃urahi hinia, ale mara mo mai mariviti vara i hite mamahunia, leon Moli God mo malue hinia mara, ");
INSERT INTO tgp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Enau God non nom pua, God non Abraham, God non Isaac peresi Jacob’. Ale Moses mo savaravara mo matahu vara i mele kilau vano. ");
INSERT INTO tgp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ale Moli God mo verea isana mara, ‘O lavi nar̃ihi na nom sabat matan jara sei ko lo turu hinia enia mo tapu. ");
INSERT INTO tgp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Enau na hite na rani r̃ilangi nona noku tamlohi sei la lo toho Egypt, ale na rongo na nora tangi, ale na sinai vara a lavi nar̃ihira. Ale o mai, a pa r̃uleho o sivo Egypt.’ ");
INSERT INTO tgp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moses akerihi natu sei la lo r̃ohu hinia lara, ‘Hare mo vaiho ko aulu vara o er̃i ari kamam? Tamlohi akerihi natu God mo r̃ulea sohena tamlohi aulu matea, ale tamlohi juri na tamlohi matea na liman angelo atu sei mo lo pala isana hin pulo pahai atu mo lo hani. ");
INSERT INTO tgp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tamlohi akerihi natu mo tiromara la malue, mo vai na hinau mar̃urahi peresi na matamata tavera na lolon Egypt, na Tasi Hahara, ale jara tano koru mata tauni mo ngavulu vati. ");
INSERT INTO tgp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses akerihi natu sei mo verea isana tavtavuin Israel mara, ‘God i pa turuhi na nomim pr̃ovet matea isana voraimim soheku’. ");
INSERT INTO tgp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tamlohi akerihi natu, mo lo toho na lolon vao atu na jara hasetoho peresi angelo atu sei mo lo retireti isana, peresi na nor̃a pua na vutin Sinai. Ale enia mo lavi na reti sei mo sile na mauri vara i silea isar̃a. ");
INSERT INTO tgp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pani nor̃a pua la r̃ohu vara la oloolo hinia, la tau nar̃ihia, ale na mapura la opoia jea vara la mele sivo Egypt, ");
INSERT INTO tgp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","la verea isan Aaron lara, ‘O vai te nor̃a god matan la pa tiroma hinir̃a. Pa Moses atu sei mo lo tiroma hinir̃a r̃a malue Egypt, r̃a sopo levosahia vara mo sopo mele pala mata sava.’ ");
INSERT INTO tgp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ale hin rani atu la vai na hinau matea mo tovongi na natu buluk matea, ale la sile na malamalai isana, ale la lo avulahi na nora vavahinau sei. ");
INSERT INTO tgp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pani matana, God mo vahar̃i isara ale mo tinar̃ihira vara la lotu na hinahinau tinatinapu na masapa, mo sohen la ulia moiso na puku nona pr̃ovet lara, ‘Varar̃uhu, kamim Israel ka lo sile na malamalai isaku na jara tano koru hin la tauni atu mo ngavulu vati? ");
INSERT INTO tgp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mo vono, r̃omimim tavera mo lo toho na nomim god na tent non Moloch, peresi Rephan god nona vitusarasara, peresi na tamasin te hinau ka vaira mata ha pa lotura. Ale matana, a pa r̃ule kamim ha vano ha toho asau na tavalun Babylon na ruhuruhura.’ ");
INSERT INTO tgp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ale nor̃a pua la lo toho peresi na Tabernacle na jara hasetoho, la vaia mo tataholo na sava God mo verea isan Moses mo usuri na sava mo hitea. ");
INSERT INTO tgp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hitahuna nor̃a pua, la pete lavia hin la rani atu la lo usuri Joshua sei mo lo tiromara na vuro isana tamlohi la sopo levosahi God. Ale God mo tipahira na nahon nor̃a pua mo kakau na rani non supe David, ");
INSERT INTO tgp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","enia God mo avulahi hinia, ale David mo usi God vara i voro te iman God non Jacob hatea. ");
INSERT INTO tgp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pani Solomon natu, mo pa voro ima atu. ");
INSERT INTO tgp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pani God Aulu Jea mo sopo toho na ima tamlohi la vaira, sohena pr̃ovet mo ulia vara Moli mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Moli mo verea: Tuka enia noku jara sakele mata suiha, ale varama enia jara paloku. Sava ima natu o pa er̃i voroa vara i pa imaku, teni sava jara enia noku jara mapu? ");
INSERT INTO tgp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ka r̃omi vara limaku mo sopo vai vevuhi la hinau nike?’ ");
INSERT INTO tgp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ka tamlohi patu r̃ilangi, mapumim la r̃or̃oha, ale ka peropero na varar̃uhu. Ka lo r̃ohu na Tanume Tapu tarea sohen nomim pua la lo vaia tiroma. ");
INSERT INTO tgp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sava pr̃ovet natu nomim pua la sopo tipahia? Ale la vilimatei la haratu sei la lo vereuli na mai non haratu mo tataholo jea sei nake ka turuleji hinia moiso, ale ka vilimateia. ");
INSERT INTO tgp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamim akerihi natu, ka sopo oloolo na leu non God sei mo silea isamim na lima angelo.” ");
INSERT INTO tgp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","La tamlohi atu sei la lo tapurongo isan Stephen lara la rongo la hinau atu, la lolokoru patura, la hatihati na hur̃ura matana. ");
INSERT INTO tgp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pani Tanume Tapu mo sohoni Stephen, ale mo tar̃a sahe aulu na tuka, ale mo hite na hasohason God, ale mo hite Iesu mo lo turu na matuan God. ");
INSERT INTO tgp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ale mo verea mara, “Ka hitea, na hite tuka mo roi, ale na hite Natun Tamlohi mo lo turu na matuan God.” ");
INSERT INTO tgp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pani la ulo na leo tavera matea ale la jongi na perora ale vahatea la kue la tauria. ");
INSERT INTO tgp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Moiso, la lavi nar̃ihia la vano na jingoiman taon tavera atu, la pulahia atano vara la pa parumateia. Ale la tamlohi atu sei la lo rongo na nona reti, la lanar̃ihi na nora ruru tavera matan vara la er̃i paruparu, ale la taura na palo uluvou matea hijana Saul. ");
INSERT INTO tgp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ale na rani la lo parua, Stephen enia mo lo usiusi mara, “Moli Iesu, o lavi na tanumeku.” ");
INSERT INTO tgp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ale mo jovi sivo na pauna mo ulo mara, “Moli, o sopo taurilatira matan hehe akerihi.” Mo vere hinau atu moiso, natu mo mate. ");
INSERT INTO tgp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ale Saul mo majinga na mateia non Stephen. Ale mo tapulo hin rani atu tamlohi la tipahi na vao kalesia Jerusalem la levuti jalajalaira la vano na jara tari Judea peresi Samaria, pani vahar̃ule purongo la pa lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tamlohi hai sei r̃omira mo r̃ilangi mata lotu God tarea la tavuni Stephen, ale la vai na tangi tavera matana. ");
INSERT INTO tgp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pani Saul, mo opoia vara i vaikomokomo na kalesia tari, mo lo unu jongi na tamlohi rasua na ima hatehateahi, mo reve tahitahi na tamlohi peresi na har̃ai ale mo taura na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ale la kalesia atu sei la lo levuti jalajalaira, la vano la lo retivujavujangi na Retir̃uhu. ");
INSERT INTO tgp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip mo sivo na taon tavera matan Samaria ale mo lo retivujavujangira hin Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ale vao tamlohi tari atu la lo tapurongo mamahu na sava mo lo verera, ale matan la hite na matamata tavera mo lo vaira. ");
INSERT INTO tgp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Matan tanume lumiha sasati la lo malue na tamlohi matuvana sei la lo toho hinira, ale lara la malue la lo ulo r̃ilangi, ale la haratu la r̃ira teni la papao la r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ale avulahi tavera mo lo toho hin taon tavera atu Samaria. ");
INSERT INTO tgp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tamlohi matea hijana Simon enia mo lo mahumahu na suihan tiapolo ale mo lo vai na hinau mar̃urahi tavera hin jara atu mo tuai moiso, mo lo verea vara enia tamlohi tavera matea. ");
INSERT INTO tgp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tamlohi tari la lo tapurongo hinia, mo tapulo na tamlohi purongo mo tikeli la haratu la aulu lara, “Tamlohi akerihi enia mo lavi suiha atu non God sei la lo verea vara mo tavera jea.” ");
INSERT INTO tgp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ale tamlohi la lo tapurongo mamahu isana matan la lo mar̃urahi na nona mahumahu tuai moiso mo mai. ");
INSERT INTO tgp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pani lara la rasu Philip matan mo lo retivujavujangi na Retir̃uhu matan mauri atu God mo aulu hinia, tamlohi peresi na har̃ai la tapulo lavi na paptijo na hijan Iesu Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon sohena mo rasua, ale hitahu na nona paptijo mo usuri Philip. Ale mara mo hite na matamata peresi na hinau mar̃urahi tavera mo lo vaira, mo hutua. ");
INSERT INTO tgp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ale la vahar̃ule atu Jerusalem lara la rongoa vara mara Samaria la lo lavi na reti non God, la r̃ule Peter enia John ");
INSERT INTO tgp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","la sivo isara la usiusi nora matan vara la pa er̃i lavi na Tanume Tapu, ");
INSERT INTO tgp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","matan enia mo sopo lo jovi isan te vonara hatea, pani enira la lavi na paptijo na hijan Moli Iesu purongo. ");
INSERT INTO tgp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ale Peter enia John la tau na limara hinira, ale la lavi na Tanume Tapu. ");
INSERT INTO tgp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon mara mo hitea vara Tanumen God mo lo mai na tamlohi vara la vahar̃ule atu la tau na limara hinira purongo, mo usia vara i er̃i silera hin te mania ");
INSERT INTO tgp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","mara, “Ha sileau hin suiha sei matan vara sava tamlohi na tau na limaku hinia enia sohena i pa lavi na Tanume Tapu.” ");
INSERT INTO tgp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pani Peter mo verea isana mara, “Mo r̃uhu vara nom mania i tihai peresiho matan ko r̃omi vara o er̃i voli na otori non God na mania. ");
INSERT INTO tgp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Engko o sopo er̃i lavi te tavalun hinau nike matan mapum mo sopo tataholo na nahon God. ");
INSERT INTO tgp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Matan haratu, o posi na nom r̃omr̃omi hehe, ale o usiusi isan God matana, matan vara i avulahi, i pa r̃omiho matan nom r̃omr̃omi sei. ");
INSERT INTO tgp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Matan na hitea ko mar̃ivi na mereimerei ale hehe mo taurilatiho.” ");
INSERT INTO tgp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ale Simon mo r̃aramia mara, “O usiusi mataku isan Moli matan vara sava sei ko verea moiso tea i sopo masese isaku.” ");
INSERT INTO tgp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ale hitahun la vereuli mamahuni la reti atu non Moli, Peter enia John la mele hilu sahe Jerusalem, ale la retivujavujangi na Retir̃uhu isana vanua mara Samaria matuvana na malelera la lo sahe. ");
INSERT INTO tgp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ale angelo matea mo verea isan Philip mara, “O turu o vano o sivo na malele sei mo tai Jerusalem mo lo vano Gaza.” Jara atu enia jara hasetoho matea. ");
INSERT INTO tgp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ale mo turu mo vano. Hin jara atu mo hite na mara Ethiopia matea mo povota, enia tamlohi aulu matea matan Candace, vesupe nona mara Ethiopia. Enia natu mo lo kilau na nona tavtav tari. Mo mai Jerusalem mata lotu, ");
INSERT INTO tgp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ale mo lo mele mule, mo lo sakele na nona kati, hos la lo revea mo lo evi na reti non pr̃ovet Isaiah. ");
INSERT INTO tgp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ale Tanumen God mo verea isan Philip mara, “O vano o hahau na pahisa nona kati.” ");
INSERT INTO tgp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ale Philip mo maro mo vano isana, ale mo rongoa mo lo evi na reti non pr̃ovet Isaiah, ale mo usia isana mara, “Ko levosahi na sava ko lo evia?” ");
INSERT INTO tgp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ale mo r̃aramia mara, “A pa levosahia sohena sava vara tea i sopo vujangiau hinia?” Ale mo usi Philip vara i vele i sahe i sakele peresia. ");
INSERT INTO tgp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jara rihirihi atu mo lo evia na Retitapu enia harihi, ‘La tiroma hinia sohena sipsip matea mo vano matan vara la vilimateia, ale sohena natu sipsip matea sei mo lo tapanono purongo vara tamlohi tai na vulu mo lo tai na vuluna, ale mo sopo vere te hinau hatea. ");
INSERT INTO tgp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na rani la vailejlejia mo sopo tea i turu vara i tuenia. Mo sopo te taniana vara i er̃i lavi na koruna. Matan la lavi nar̃ihi na maurina na varama.’ ");
INSERT INTO tgp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ale pa tamlohi atu sei la votaia mo usi Philip mara, “Isaiah enia mo lo retireti hin enia hasena teni mo lo vere te tamlohi tinapua?” ");
INSERT INTO tgp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ale Philip mo vereuli na Retir̃uhu hin Iesu isana mo tapulo hin jara rihirihi atu na Retitapu. ");
INSERT INTO tgp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ale lara la lo vano la mai na pahisa wai matea, ale pa tamlohi atu sei la votaia mara, “O to kilau vano, wai sevano! Mo sopo lo tataholo vara a lavi na paptijo?” ");
INSERT INTO tgp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","38","Ale mo verea mara nona kati i turu, ale enira rua la sevuti la sivo na wai, ale Philip mo paptijo hinia. ");
INSERT INTO tgp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ale mara mo malue na wai, Tanumen Moli mo lavi nar̃ihi Philip na nahona. Pa tamlohi atu mo sopo mele hitea pani na malelena mo lo vano mo avulahi tavera. ");
INSERT INTO tgp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ale Philip mo pa hutua purongo mo lo turu hin taon atu Azotus, ale mo retivujavujangi na Retir̃uhu atu peresi na taon tari sei na malelena vavano mo kakau Caesarea. ");
INSERT INTO tgp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Hin rani atu Jerusalem, Saul mo lo verea r̃ilangi vara i pa vilimatei na tamlohi usuri non Moli, ale matana mo vano isan pr̃is aulu. ");
INSERT INTO tgp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ale mo usia vara i uli te leta vara i lavira la sahe isana ima lotu nona Jew Damascus, mata usia vara la turu peresia vara la taurilati la haratu la lo usuri na malelen Kr̃isto, hina purongo vara tamlohi teni har̃ai. Ale vara i lihora i lavira la mele sahe Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saul mo lo sahe Damascus, mo pa lo mai mariviti, mera tavera matea mo tai na tuka mo er̃i tuntunia. ");
INSERT INTO tgp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mo jovi sivo na lepa, ale mo rongo na leo matea mo verea mara, “Saul! Saul! Mata sava ko lo tipahiau?” ");
INSERT INTO tgp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ale Saul mo usia mara, “Tamlohi tavera, engko hare?” Ale leo atu mo r̃aramia mara, “Enau sei Iesu! Haratu sei ko lo tipahia. ");
INSERT INTO tgp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pani nakerihi o turu, o vano o unu na lolon taon tavera atu ko lo mai matana, ale tamlohi matea i pa vereho na sava o pa vaia.” ");
INSERT INTO tgp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","La tamlohi atu sei la lo hahau peresi Saul la turu tapanono vahatea matan la rongo leo atu, pani la sopo hite na tamlohina. ");
INSERT INTO tgp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ale Saul mo mele turu, matana mo lo roi pani mo sopo er̃i hite te hinau. Nona tamlohi la tauri na limana la tiroma hinia la sahe Damascus. ");
INSERT INTO tgp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ale Saul mo matavuso mata rani mo tolu. Mo r̃ohu na hanhani peresi na wai hin la rani atu. ");
INSERT INTO tgp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tamlohi usuri matea hijana Ananias mo lo toho atu Damascus. Moli mo pala isana na hinau matea sohena mavuho mara, “Ananias!” Ananias mo r̃aramia mara, “Enau sei Moli!” ");
INSERT INTO tgp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Moli mo verea isana mara, “O turu o vano hin malele atu la tovia ‘Tataholo’ ale atu na iman Judas o usi na mara Tarsus matea hijana Saul, ale nakerihi mo lo usiusi, ");
INSERT INTO tgp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ale hinau matea sohena mavuho enia mo hite na tamlohi matea hijana Ananias mo mai mo tau na limana hinia matan vara i er̃i mele kilau.” ");
INSERT INTO tgp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pani Ananias mo r̃aramia mara, “Moli, tamlohi matuvana la vereau na sava hinau sasati tamlohi atu mo lo vaia isana nom tapuhi Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ale nahai nike mo lo lavi na suiha isana pr̃is aulu Jerusalem vara i taurilati la haratu la lo rasuho vara engko Moli!” ");
INSERT INTO tgp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pani Moli mo verea isana mara, “O vano matan enau na vir̃onia mata vavahinau matea vara enia i pa lavi na hijaku i vano isana tamlohi r̃or̃oha, ale isana supe, ale isana Jew. ");
INSERT INTO tgp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Matan enau a pa vujangia vara i pa lavi na rongohaji mata hijaku.” ");
INSERT INTO tgp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ale Ananias mo malue mo vano mo unu hin ima atu. Mo tau na limana hinia, ale mara, “Voraiku Saul, Moli Iesu sei mo lo pala isam hin malele sei ko lo mai hinia, mo r̃uleau na mai isam matan vara o er̃i mele kilau, ale Tanume Tapu i mar̃ivisiho.” ");
INSERT INTO tgp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Vahatea purongo hinau hai sohena langalanga maji la jovi na matan Saul, ale mo mele kilau, moiso mo turu ale la paptijo hinia; ");
INSERT INTO tgp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ale mara mo hanhani, mo mele suiha. Saul mo lo toho peresi na tamlohi usuri non Moli makomona atu Damascus. ");
INSERT INTO tgp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ale vila r̃uhu purongo, Saul mo tapulo retivujavujangi Iesu na ima lotu nona Jew mara, “Varar̃uhu Iesu enia Natun God.” ");
INSERT INTO tgp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ale tamlohi tari sei la rongoa la mar̃urahi tavera hinia lara, “Avei, mo sopo tamlohi nike natu sei mo lo vailejleji la haratu Jerusalem sei la lo verea vara Iesu enia Moli? Ale nona mai nike nake mo sopo matan vara i mele vaia sohena, matan vara i liho kamam ale i lavi kamam kama vano isana moli nona pr̃is Jerusalem?” ");
INSERT INTO tgp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pani suihan Saul mata retivujavujangi mo mai mo mele r̃ilangi jea, ale mo ari posposi na Jew sei la lo toho Damascus matan mo lo vujangi mamahunia vara Iesu enia Kr̃isto atu la lo kilau matana. ");
INSERT INTO tgp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mo sopo tuai, tamlohi tavera nona Jew atu Damascus la hatihia vara la pa vilimateia, ");
INSERT INTO tgp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pani Saul mo levosahi nora r̃omr̃omi luhu atu. La lo kilau na mataruan taon tavera atu na rani na vutepongi matan vara la pa er̃i vilimateia. ");
INSERT INTO tgp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pani na vutepongi matea, nona tamlohi usuri la tuhua na tanga matea na mar̃ole matea na roro ropen taon atu. ");
INSERT INTO tgp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ale hin rani atu, Saul mo pala Jerusalem mo vaihitea vara i pulutahi peresi na tamlohi usuri non Moli ea. Ale enira mo isoiso la matahunia matan la sopo rasua vara enia tamlohi usuri matea. ");
INSERT INTO tgp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pani Barnabas mo vano mo lavia mo mai isana vahar̃ule, ale mo vereulia isara sohena sava Saul mo hite Moli na malele, ale mo vereuli na sava Moli mo verea isana, ale sohena sava mo lo retivujavujangi r̃ilangi na hijan Iesu Damascus. ");
INSERT INTO tgp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ale tamlohi usuri la pa avulahi hinia natu vara i lo toho peresira, ale nona retivujavujangi Jerusalem na hijan Moli mo r̃ilangi jea. ");
INSERT INTO tgp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ale mo sorasora peresi na mara Jew atu sei la retireti na leo mara Greek, ale mo vasi peresira, pani la lo tiasia vara la vilimateia. ");
INSERT INTO tgp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ale vorai kalesia atu lara la levosahia, la lavia mo sivo Caesarea, ale la r̃ule nar̃ihia mo sahe Tarsus. ");
INSERT INTO tgp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Matan haratu, kalesia na jara tari Judea, Galilee peresi Samaria la toho na tamata, la ulua la r̃ilangi ale evira mo tavera. Ale na maurira la sile na oloolo isan Moli ale la lo toho na nanauhi non Tanume Tapu, ale la ulua mo tavera jea. ");
INSERT INTO tgp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ale, Peter mo lo hahau r̃alihi ale na malelena mo sivo isana tapuhi non Moli Lydda. ");
INSERT INTO tgp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Hin jara atu mo tapai na tamlohi papao matea hijana Aeneas sei mo lo juruvi na vatana mata tauni mo limaravtolu moiso. ");
INSERT INTO tgp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ale Peter mo verea isana mara, “Aeneas, Iesu Kr̃isto mo vai mamahuniho; o turu o vai na vatam.” Ale vahatea purongo mo turu. ");
INSERT INTO tgp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ale tamlohi tari Lydda peresi Sharon la hitea, ale la posi mai isan Moli. ");
INSERT INTO tgp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Hin rani atu tamlohi usuri har̃ai matea mo lo toho Joppa, hijana na leo Jew enia Tabitha, ale na leo mara Greek enia Dorcas. Tarea mo lo vai na vavahinau r̃uhu ale mo lo tueni na tilavono. ");
INSERT INTO tgp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Hin la rani atu mo rojo ale mo mate. Ale lara la hoje na tarapena moiso la taua mo juruvi na jara tinapua matea aulu hin ima atu. ");
INSERT INTO tgp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pani matan Lydda mo lo toho mariviti Joppa, tamlohi usuri atu lara la rongoa vara Peter mo lo toho atu, la r̃ule na tamlohi mo rua la vano isana vara la usia r̃ilangi vara, “Kama opoia mo tavera jea vara o mai nakerihi purongo.” ");
INSERT INTO tgp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ale Peter mo turu mo usurira la vano. Ale mara mo pala, la lavia mo sahe aulu isan Dorcas. Malepu tari la lo turu na pahisana la lo tangi, ale la lo vujangi na ruru peravu peresi te ruru tinatinapua Dorcas mo vaira na rani mo pa lo mauri. ");
INSERT INTO tgp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pani Peter mo r̃ulera enira mo isoiso vara la malue, ale mo papaohi mo usiusi, ale mo posi vano isan tarape atu mara, “Tabitha, o turu.” Ale mo roi na matana, ale mara mo hite Peter, mo sakele tataholo. ");
INSERT INTO tgp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ale mo sohai na limana vano isana ale mo saua. Moiso mo tovi na tapuhi peresi la har̃ai malepu atu vara la mai ale mo vujangia isara vara mo mele mauri. ");
INSERT INTO tgp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ale sorasorahina mo r̃alihi na jara tari Joppa, ale tamlohi matuvana la tau na nora rasua hin Moli. ");
INSERT INTO tgp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ale Peter mo lo toho atu Joppa mata rani matuvana peresi na tamlohi matea hijana Simon mo lo vavahinau na huri maji. ");
INSERT INTO tgp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Atu Caesarea tamlohi matea, hijana Cornelius, enia captain mata tamlohi vuro mo lo kilau na vao tamlohi vuro mara Rome matea evira mo ngavulu sangavulu mo limarave , ");
INSERT INTO tgp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","enia tamlohi matea r̃omina mo r̃ilangi mata lotu God, ale mo lo sile na oloolo isana tolu na vao imana, ale nona silesilea mo r̃uhu jea isana tamlohi, ale mo lo usiusi tarea isan God. ");
INSERT INTO tgp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Matan alo mariviti i tolu na ravravi matea, mo hite na hinau matea sohena mavuho matea, ale mo hite na angelo non God matea mo mai mo verea isana mara, “Cornelius!” ");
INSERT INTO tgp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ale mo kilaua na matahu tavera ale mara, “Eh, sava tamlohi tavera?” Ale mo verea isana mara, “Nom usiusi peresi na nom silesilea la sopo sahe aulu purongo na nahon God. ");
INSERT INTO tgp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ale nakerihi, o r̃ule te tamlohi la sivo Joppa la lavi Simon tapala hijana Peter. ");
INSERT INTO tgp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Enia mo lo toho peresi na tamlohi matea hijana Simon sei mo lo vavahinau na huri maji, ale imana mo lo toho na pahisa tasi.” ");
INSERT INTO tgp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angelo atu mara mo lo retireti isana moiso mo malue, ale Cornelius mo tovi na nona volitusi mo rua peresi na tamlohi vuro matea sei mo rasua mo tavera jea ale mo r̃ulera isan la haratu la lo volitusi isana, ");
INSERT INTO tgp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","mo vere na sava mo masese isana isara, ale mo r̃ulera la sivo Joppa. ");
INSERT INTO tgp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mo mele rani sahe la pa lo mai mariviti hin taon tavera atu, Peter mo sahe aulu na pusa ima na livuha rani mata usiusi. ");
INSERT INTO tgp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ale mo marohati, mo opoia vara i hani te hinau, pani la pa lo tatamahunia, hinau matea sohena mavuho mo taurilati na r̃omina, ");
INSERT INTO tgp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ale mo hite tuka la roi ale hinau matea sohena tavalu ruru tavera jea matea mo lo sinai atano, la tuhua mo lo sinai atano na varama hin la pingona atu mo vati. ");
INSERT INTO tgp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mo hite na maji tinatinapua matuvana, maji haraho peresi na maji avuavu la lo toho na lolona. ");
INSERT INTO tgp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ale leo matea mo malue mo verea isana mara, “O turu Peter; o vilimatei tea o hania!” ");
INSERT INTO tgp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pani Peter mara, “A sopo er̃i vaia sohena Moli; matan na sopo lo hani te hinau lumiha hatea sei leu mo horoa!” ");
INSERT INTO tgp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ale leo atu mo mele mai isana haruana mara, “Sava God mo vaia mo vokevoke, o sopo verea vara mo lumiha!” ");
INSERT INTO tgp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ale hinau sei mo masese sohena vaha tolu moiso, ale vahatea purongo mo mele sahe aulu na tuka. ");
INSERT INTO tgp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ale r̃omin Peter mara mo pa lo toho na r̃aramin hinau atu mo hitea, vahatea purongo, pa la tamlohi atu sei Cornelius mo lo r̃ulera la kakau na iman Simon la turu na get. ");
INSERT INTO tgp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ale la ulo la usia lara Simon matea tapala hijana Peter mo lo toho atu teni mo vono. ");
INSERT INTO tgp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter mo pa lo r̃omr̃omi hinau atu mo lo hitea, ale Tanume Tapu mo verea isana mara, “Nakerihi, tamlohi tupu tolu la lo aleho. ");
INSERT INTO tgp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","O turu, o sivo atano, r̃omim i sopo kaka hinira, ale o usurira matan enau sei na r̃ulera.” ");
INSERT INTO tgp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ale Peter mo sevuti sivo isara ale mo verea mara, “Enau natu haratu ko lo alea. Ka mai mata sava?” ");
INSERT INTO tgp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ale la verea lara, “Cornelius, enia captain mata tamlohi vuro matea, mo lo kilau na vao tamlohi vuro mara Rome matea, ale enia tamlohi tataholo matea sei mo lo sile na oloolo tavera isan God. Ale Jew la lo verea vara enia tamlohi r̃uhu matea; angelo tapu matea mo verea isana mara i vahar̃ule matam matan vara o mai na imana ale i pa rongo na sava o pa verea isana.” ");
INSERT INTO tgp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ale Peter mo usira vara la pa toho atu peresia hin rani atu. Mo mele rani sahe mo turu mo usurira, ale tatua vorai sei mara Joppa la vano peresia. ");
INSERT INTO tgp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mo mele rani sahe la unu Caesarea. Cornelius mo lo kilau matana moiso, ale mo tovi matavuhi na tahisana peresi na tavtavuina peresi na tapalana r̃uhur̃uhu la lo saovia. ");
INSERT INTO tgp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter mara mo unu, Cornelius mo tapaia, mo jovi sivo na palona ale mo lotua. ");
INSERT INTO tgp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pani Peter mo saua sahe aulu mara, “O turu, enau tamlohi matea sohem purongo!” ");
INSERT INTO tgp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mara mo lo retireti peresia mo unu mo hite na vao tavera la lo takonahi saovia. ");
INSERT INTO tgp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ale mo verea isara mara, “Kamim hasemim ka levosahia vara mo sopo tataholo vara Jew matea i pulutahi teni i rohi te tamlohi mara jara tinapua, pani God mo vujangia isaku vara a sopo tovi na tamlohi tinapua sohena tamlohi lumiha matea na nahon God. ");
INSERT INTO tgp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ale kara ka vahar̃ule mataku, na mai tataholo vahatea. Ale nake, na opoia vara a usia vara mata sava ka vahar̃ule mataku?” ");
INSERT INTO tgp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ale Cornelius mara, “Rani mo vati mo vano moiso, korong matan alo mo tolu natu na ravravi, na lo usiusi na imaku, ale vahatea purongo, tamlohi matea mo turu na nahoku mo ru na ruru la memera ");
INSERT INTO tgp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ale mo verea mara, ‘Cornelius, God mo sopo r̃omaliho na nom usiusi peresi na nom silesilea. ");
INSERT INTO tgp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ale matan haratu o r̃ule tea la sivo Joppa la usi na tamlohi matea hijana Simon tapala hijana Peter. Enia mo lo toho na iman Simon, tamlohi vavahinau na huri maji matea na pahisa tasi.’ ");
INSERT INTO tgp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ale na vahar̃ule matam vahatea, ale engko ko r̃omr̃uhu ko mai. Ale matana nakerihi, kamam mo isoiso kama lo toho na nahon God vara kama rongo vevuhi na sava mo retileu hinia isam vara o verea isamam.” ");
INSERT INTO tgp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ale Peter mo tapulo retireti mara, “Varar̃uhu, nake natu na pa levosahia vara God mo sopo tametame tea, ");
INSERT INTO tgp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","pani sava tamlohi na sava jara sei mo lo sile na oloolo isana, ale mo vai na hinau tataholo, enia mo avulahi hinia. ");
INSERT INTO tgp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ale ka levosahi retisohai atu sei mo lo silea isana tavtavuin Israel, mo retivujavujangi na Retir̃uhu mata tamata hin Iesu Kr̃isto enia Moli nona tamlohi tari. ");
INSERT INTO tgp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kamim ka levosahi vevuhi na sava mo masese Judea, mo tapulo Galilee hitahun paptijo atu John mo lo retivujavujangia ");
INSERT INTO tgp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","hin Iesu mara Nazareth sei God mo vir̃onia na Tanume Tapu ale peresi na suiha. Enia mo hahau r̃alihi mo lo vai na hina r̃uhu, mo vai na rojoa la tihai hin la haratu tiapolo mo lo vailejlejira matan God mo lo toho peresia. ");
INSERT INTO tgp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kamam kama hite vevuhi la hinau sei na matamam mo vaira Judea peresi Jerusalem. La vilimateia na talopeilopei matea, ");
INSERT INTO tgp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","pani God mo sauteterahia na hatolu rani, ale mo tinar̃ihia vara i pala, ");
INSERT INTO tgp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","mo sopo isana tamlohi tari, pani isamam sei God mo pete vir̃oni kamam moiso vara kama pa hitea. Hitahun haratu mo lo turu na mateia, kamam natu, kama hanhani ale kama inu peresia. ");
INSERT INTO tgp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Mo retileu isamam vara kama retivujavujangi na tamlohi ale vara kama retir̃oar̃oahaira vara enia natu haratu God mo vir̃onia vara i pa ari la haratu la mate peresi la haratu la lo mauri. ");
INSERT INTO tgp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pr̃ovet tari la vereulia vara sava tamlohi sei mo tau na nona rasua hinia, God i pa r̃omi na nona hehe na hijana. ");
INSERT INTO tgp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter mo pa lo vere la hinau atu, Tanume Tapu mo jovi isan la haratu enira mo isoiso sei la lo tapurongo na nona reti. ");
INSERT INTO tgp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tamlohi r̃or̃oha sei la lo usuri Peter, la mar̃urahi tavera matan God mo surei na Tanume Tapu isana tamlohi r̃or̃oha sohera. ");
INSERT INTO tgp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Matan la rongora la lo retireti na leo tinatinapua la lo tahe na hijan God, moiso Peter mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hare natu i er̃i horo na wai vara la tamlohi nike la sopo paptijo hinia? Matan enira sohena la lavi na Tanume Tapu soher̃a moiso.” ");
INSERT INTO tgp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ale mo retileu isara vara la pa paptijo na hijan Iesu Kr̃isto. Hitahun haratu, la usia vara i lo toho peresira makomona tako. ");
INSERT INTO tgp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ale, vahar̃ule peresi la vorai atu la lo toho r̃alihi Judea la rongoa vara tamlohi r̃or̃oha la lavi na reti non God. ");
INSERT INTO tgp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ale Peter mara mo sahe Jerusalem, Jew kalesia hai la verelejlejia lara, ");
INSERT INTO tgp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Avei, ko vano isana tamlohi r̃or̃oha, ale ko hanhani peresira.” ");
INSERT INTO tgp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pani Peter mo tapulo vereuli na sava mo masese mo tapulo na tapulona mara, ");
INSERT INTO tgp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Na lo toho na taon tavera matan Joppa na lo usiusi, ale hinau matea sohena mavuho matea mo pala isaku, ale na hite na hinau matea sohena tavalu ruru tavera jea matea mo lo sinai atano mo tai na tuka ale la tuhua hin la pingona atu mo vati mo sinai tataholo isaku. ");
INSERT INTO tgp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nara na kilau mamahunia, na hite na maji palo vati hai, maji jala hai, maji haraho hai peresi na maji avuavu tinatinapua hai sei la tapu mata hanira. ");
INSERT INTO tgp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ale na rongo na leo matea mo malue mo verea isaku mara, ‘O turu Peter; o vilimatei tea, ale o hanira!’ ");
INSERT INTO tgp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pani na verea nara, ‘A sopo er̃i vaia sohena Moli; matan na sopo lo hani te hinau lumiha hatea sei leu mo horoa.’ ");
INSERT INTO tgp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pani pa leo atu na tuka mo mele r̃aramiau haruana mara, ‘Sava na vaia mo vokevoke, o sopo er̃i verea vara mo lumiha.’ ");
INSERT INTO tgp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hinau atu mo masese sohena vaha tolu moiso, la hinau tari atu la pa mele sahe na tuka. ");
INSERT INTO tgp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Vahatea atu, tamlohi mo tolu la pala hin ima atu na lo toho ea, la r̃ulera Caesarea mataku. ");
INSERT INTO tgp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ale Tanumen God mo verea isaku mara a usurira, ale na sopo mele r̃omr̃omia vara enira la tamlohi tinapua. La tamlohi tupu limarave nike natu, la usuriau kama sahe, ale kama unu na iman tamlohi matea Caesarea. ");
INSERT INTO tgp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ale mo vereulia sohena sava mo hite angelo atu mo turu na lolo imana, ale mo verea isana mara, ‘O r̃ule tea la sivo Joppa, ale la lavi Simon sei tapala hijana Peter; ");
INSERT INTO tgp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ale i pa vereuli na retisohai matea sei o pa juri hinia, engko peresi na vao imam.’ ");
INSERT INTO tgp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nara na tapulo retireti, Tanume Tapu mo jovi hinira sohen mo vaia isar̃a tiroma. ");
INSERT INTO tgp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ale na mele r̃omr̃omi na reti non Moli sei mara, ‘John mo paptijo peresi na wai, pani God i pa paptijo hin kamim na Tanume Tapu.’ ");
INSERT INTO tgp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Vara God mo silera na otori sohen mo silea isar̃a hin rani atu r̃a rasu Moli Iesu Kr̃isto, enau sava tamlohi vara a er̃i horoa?” ");
INSERT INTO tgp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lara la rongo la hinau atu la sopo mele retireti, pani la hasohaso God lara, “Varar̃uhu, God mo tinar̃ihia vara tamlohi r̃or̃oha la er̃i posi, ale la lavi na mauri soher̃a.” ");
INSERT INTO tgp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ale hin rani atu, la haratu sei la lo tipahira Jerusalem usuri na mate non Stephen, la sahe asau la kakau na jara sohen Phoenicia, Cyprus peresi Antioch. La sopo vere retisohai sei isan te tinapua pani isana Jew sei la lo retireti na leon Israel purongo. ");
INSERT INTO tgp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pani tatuara enira mara Cyprus enia Cyrene sohena, ale lara la pala Antioch la verea isana tamlohi r̃or̃oha sei leora enia mara Greek, la lo retivujavujangi Moli Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Suihan Moli mo lo toho hinira, ale vao tavera sei la tamlohi r̃or̃oha la rasua, ale la posi mai isan Moli. ");
INSERT INTO tgp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Sorasora atu mara mo pala na vao kalesia Jerusalem, ale la r̃ule Barnabas mo sahe Antioch. ");
INSERT INTO tgp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mara mo pala mo hiteuli na vavahinau r̃uhur̃uhu non God isara, ale mo avulahi mo retituetuenira vara la lo toho r̃ilangi varar̃uhu isan Moli, ");
INSERT INTO tgp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","matan Barnabas enia tamlohi r̃uhu matea, Tanume Tapu mo mar̃ivi hinia, ale nona rasua mo r̃ilangi, ale matana, tamlohi matuvana la mele mai isan Moli. ");
INSERT INTO tgp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Matana, Barnabas mo vano Tarsus vara i ale Saul, ");
INSERT INTO tgp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ale mara mo tapaia, mo lavia mo sinai Antioch. Barnabas peresi Saul la lo pulutahi peresi vao kalesia atu, ale la vujangi na tamlohi matuvana ea mata tauni matea. Antioch natu, enia tiroma jara sei tamlohi rasua la lavi hija sei — kalesia ea. ");
INSERT INTO tgp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ale hin la rani atu pr̃ovet hai la tai Jerusalem la sahe Antioch. ");
INSERT INTO tgp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Vonara matea hijana Agabus mo turu, ale mo retimangovi na suihan Tanumen God mara marua tavera matea i pa jovi na varama, ale hinau atu mo masese hin rani atu Claudius mo lo supe nona mara Rome. ");
INSERT INTO tgp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ale matana, tamlohi usuri Antioch la hatihia vara la pa sile te tuetueni isana voraira peresi na vevoraira sei la lo toho Judea, la pa silea sohena vara la er̃i silea. ");
INSERT INTO tgp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ale la vaia sohena, la sile na nora tuetueni isan Barnabas enia Saul vara la pa silea isan la haratu la lo kilau na kalesia Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hin la rani atu, supe Herod Agrippa mo taurilati na kalesia hai vara i pa vaikomokomora. ");
INSERT INTO tgp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mo retileu vara la vilimatei James, tasin John na sita vuro. ");
INSERT INTO tgp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ale mara mo hitea vara Jew la avulahi hinia mo mele taurilati Peter sohena, harihi mo masese na rani Passover. ");
INSERT INTO tgp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mara mo tauria mo taua na ima r̃ilangi, mo taua na lima vao tamlohi vuro mo vati sei tupu vati na vao matea. Herod mo lo r̃omr̃omia vara i pa lavi Peter i malue vara i aria na naho tamlohi hitahu na Passover. ");
INSERT INTO tgp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ale Peter mo lo toho atu na ima r̃ilangi, pani vao kalesia Jerusalem la lo usiusi r̃ilangi isan God matana. ");
INSERT INTO tgp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ale hin vutepongi atu sei vara i rani sahe supe Herod i pa vaia i turu na aria, Peter mo lo juruvi na livuha tamlohi vuro mo rua, la liho na limana na jen, ale hai la lo turu na pelatin ima r̃ilangi atu. ");
INSERT INTO tgp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Vahatea purongo, angelo matea non Moli mo pala na pahisan Peter na lolon jara atu mo lo toho hinia na ima r̃ilangi, ale mera matea mo merasahi jara atu. Mo hoti Peter na rorona, ale mo r̃ohaia mara, “O turu vila.” Ale jen la jovi nar̃ihi na limana. ");
INSERT INTO tgp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ale angelo atu mo verea isana mara, “O ruru ale o ru na nom sabat!” Ale mo vaia sohena. Ale mo mele verea isana mara, “O tavuhoroho na nom ruru tavera, ale o usuriau.” ");
INSERT INTO tgp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ale Peter mo malue mo usuria. Mo sopo levosahia vara hinau atu angelo atu mo lo vaia enia hina varar̃uhu, pani mo lo r̃omr̃omia vara mo lo hite na hinau matea sohena mavuho matea. ");
INSERT INTO tgp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ale lara la jeu na tiroma vao tamlohi vuro peresi na harua vao tamlohi vuro sei la lo kilau na ima r̃ilangi, la sahe tataholo na pelati aen sei mata unu hin taon tavera atu. Pelati atu mo hasena roi matara, ale la malue la lo usuri na malele tavera matea, ale vahatea purongo, angelo atu mo tinar̃ihia. ");
INSERT INTO tgp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ale r̃omin Peter mara mo mele mai mo hasena verea mara, “Nakerihi na levosahi mamahunia vara Moli mo r̃ule na nona angelo vara i juriau na liman Herod peresi na hinau tari sei Jew la opoia vara i pa masese isaku.” ");
INSERT INTO tgp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mara mo levosahia, mo vano na iman Mary tinan John sei tapala hijana Mark. Ale tamlohi matuvana la lo pulutahi ea la lo usiusi. ");
INSERT INTO tgp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ale mara mo r̃ir̃ingi na pelatin rope ima atu, har̃arihi volitusi matea hijana Rhoda mo mai vara i roi. ");
INSERT INTO tgp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mara mo rongovosahi na leon Peter, na nona avulahi mo sopo roi na pelati pani mo maro mo mele unu na ima mo vereulia isara vara Peter mo lo turu na pelati. ");
INSERT INTO tgp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","La verea isana lara, “Ko to, ko putu teni?” Pani mo verea mo r̃ilangi mara mo varar̃uhu, ale enira la lo verea vara, “Enia nona angelo!” ");
INSERT INTO tgp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pani Peter mo lo r̃ir̃ingi ale enira lara la roi, la hitea ale la mar̃urahi tavera. ");
INSERT INTO tgp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pani mo vai na matamata na limana vara la toho malum, ale mo vereulia sohena sava Moli God mo nar̃ihia hin ima r̃ilangi atu. Ale mo verea mara, “Ha vere la hinau nike isan James peresi na vorair̃a.” Moiso mo malue mo vano na jara tinapua matea. ");
INSERT INTO tgp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na nahonaho rani tamlohi vuro tari na ima r̃ilangi atu la matahu tavera na sava mo masese isan Peter. ");
INSERT INTO tgp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Supe Herod mo pala isara atu, ale mo alea pani mo sopo hitea, ale mo usi na retiusia hai isan la tamlohi vuro atu sei la lo kilaua moiso mo retileu vara nona tamlohi vuro tinapua la lavira la vano la vilimateira. Moiso Herod mo sivo mo hahau roto Judea mo vano Caesarea vara i lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Supe Herod Agrippa mo lolokoru tavera na mara Tyre peresi Sidon, ale la mai isana na r̃omr̃omi matea, ale na rani Blastus patu volitusi non Herod mara mo majinga na r̃omira moiso, la usia vara la er̃i sari tamata peresi Herod matan hara hinau mo lo tai na jaran Supe. ");
INSERT INTO tgp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ale hin rani atu sei Herod mo taua moiso, mo ru na nona ruru peravu mata supe, mo sakele na jara sakele mata supe, ale mo sile na nona retireti isara. ");
INSERT INTO tgp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tamlohi la lo ulo lara, “Aaah! Leo god matea nahai, mo sopo leo tamlohi!” ");
INSERT INTO tgp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Vahatea purongo, angelo matea non Moli mo vilijovia matan mo sopo sile na hasohaso isan God, ale hulesi la hania mo mate. ");
INSERT INTO tgp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pani reti non God mo ulua mo vano mo vai na tamlohi matuvana tinapua la rasua. ");
INSERT INTO tgp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas enia Saul lara la vai vevuhi na sava la lo vano matana Jerusalem, la mele hilu matan Antioch la lavi John sei, tapala hijana Mark. ");
INSERT INTO tgp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Harihi enia hija pr̃ovet hai peresi na tamlohi vujangi Antioch: Barnabas, Simon la tovia ‘tamlohi viriha’, ale Lucius mara Cyrene, Manaen enia vorain Herod Antipas matea, vaona la korohia, ale Saul. ");
INSERT INTO tgp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na rani matea la tapuhoro na hanhani ale la pa lo lotu Moli, Tanume Tapu mo verea mara, “Ha tauhasehi Barnabas enia Saul mata noku voko atu na tovira matana.” ");
INSERT INTO tgp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hitahu na nora tapuhoro na hanhani peresi na usiusi, la tau na limara hinira ale la r̃ulera la vano na malelera. ");
INSERT INTO tgp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ale Barnabas enia Saul, Tanume Tapu mo r̃ulera la sivo Seleucia na pahisa tasi, ale la vele na boti hin jara atu, la sivo na Ureuren Cyprus. ");
INSERT INTO tgp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lara la hoso Salamis, la retivujavujangi na reti non God na ima lotu nona Jew. Ale John Mark mo lo usurira sohena nora tuetueni. ");
INSERT INTO tgp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lara la hahau roto ureure atu la kakau Paphos, la tataholo na tamlohi matea mo lo mahumahu na suihan tiapolo, enia Jew pr̃ovet haluhalu matea hijana Bar-Jesus, ");
INSERT INTO tgp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","enia mo lo toho peresi na tamlohi aulu matan Cyprus sei supe non Rome mo taua atu, hijana Sergius Paulus, enia tamlohi lelevosahi matea. Tamlohi aulu atu mo vahar̃ule matan Barnabas enia Saul matan mo opoia vara i rongo na reti non God. ");
INSERT INTO tgp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pani Elymas tamlohi mahumahu atu mo retihorora matan mo sopo opoia vara tamlohi aulu atu i rongo te reti na rasua non Saul enia Barnabas hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pani Saul sei tapala hijana Paul, Tanume Tapu mo mar̃ivisia ale Paul mo kilau tataholo isana, ");
INSERT INTO tgp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ale mara, “Engko natun Tiapolo, ko mar̃ivi na halu peresi posposi tope na leu, meresahi nona hinau tari sei la r̃uhu, o pa isoiso na nom vailejleji na malele varar̃uhu non Moli pangisa? ");
INSERT INTO tgp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ale nakerihi natu, liman Moli mo meresahi isam, ale o pa vuso, o pa sopo er̃i hite na mera alo matan te rani makomona.” Vahatea purongo, matana mo nini ale r̃or̃oha mo sohonia, ale mo aleale tamlohi vara tea i tauri na limana i tiroma hinia. ");
INSERT INTO tgp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tamlohi aulu atu mara mo hite hinau atu mo masese mo rasua, matan mo mar̃urahi tavera na vujangi matan Moli. ");
INSERT INTO tgp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Moiso, Paul peresi na tapalana la mele malue Paphos na boti matea la sahe matan Pamphylia. La hoso na taon matan Perga. John Mark mo tinar̃ihira atu natu, ale mo mele hilu mo sivo Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","La mele malue Perga la sahe la pala Antioch matan Pisidia, ale na rani Sabbath la vano la unu na ima lotu nona Jew la sakele. ");
INSERT INTO tgp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hitahun na evievi mata Leu non Moses peresi na reti nona pr̃ovet, patu tamlohi mata ima lotu mo sohai na retisohai isara mara, “La vorai, vara te nomim retisohai mata tueni na tamlohi, ha sinai ha silea.” ");
INSERT INTO tgp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ale Paul mo turu mo tahe na limana vara la tapurongo ale mara, “La tavtavuin Israel peresi kamim ka tamlohi r̃or̃oha sei ka lo sile na oloolo isan God, ha tapurongo: ");
INSERT INTO tgp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God nona tavtavuin Israel, mo vir̃oni na nor̃a pua, ale mo vaira la ulua r̃ilangi hin rani atu la lo toho Egypt. Ale mo jurira na suihana la malue na mauri slev. ");
INSERT INTO tgp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","God mo lavi na rani r̃ilangi isara na jara hasetoho mata tauni ngavulu vati . ");
INSERT INTO tgp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ale hitahun haratu, mo vaikomokomo na mara jara tinatinapua mo limaravrua Canaan, ale mo sile na nona tamlohi hin jara atu sohena koruna. ");
INSERT INTO tgp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","La hinau atu mariviti vara i lavi na tauni mo ngavulu sangavulu vati mo ngavulu lima . Hitahuna, mo silera na tamlohi ari mo tikeli na rani non pr̃ovet Samuel. ");
INSERT INTO tgp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Moiso, tamlohi la tangi matan vara te nora supe, ale God mo silera hin Saul natun Kish, tavtavuin Benjamin matea, ale enia mo aulu mata tauni mo ngavulu vati. ");
INSERT INTO tgp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pani God mo nar̃ihia sohena supe, ale mo tau David na jarana. God mo retireti matan David mara, ‘Na hite David natun Jesse vara r̃omina mo usuri na r̃omiku matan enia i pa vai na hinau tari na masaloku.’ ");
INSERT INTO tgp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ale mahapin David, Iesu natu, enia haratu sei God mo sohaia usuri na nona retitauhi hinia sohena Jujuri non Israel! ");
INSERT INTO tgp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hin la rani atu la tiroma na nona pala, John tamlohi paptijo mo lo retivujavujangi na tavtavuin Israel vara la vahar̃i na nora hehe, ale la posi mai isan God la paptijo. ");
INSERT INTO tgp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ale vavahinau non John mariviti vara i lo isoiso, mo verea vaha visa mara, ‘Ka r̃omi vara enau hare? Enau mo sopo tamlohi atu, pani ha lo levosahia vara haratu mo lo mai hitahu hiniau, enau na sopo tataholo vara a uli na asi eve palona.’ ");
INSERT INTO tgp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","La vorai, kamim sei natun Abraham peresi kamim tari sei ka tamlohi r̃or̃oha sei ka lo sile na oloolo isan God non Israel, retisohai matan juri akerihi, mo mai isar̃a mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tamlohin Jerusalem peresi na nora tamlohi aulu la mar̃ivisi na retimangovi hin haratu la sile na talai isan Iesu vara i mate. La sopo hitevosahia vara enia haratu sei pr̃ovet la lo uliuli matana, hina purongo vara la lo rongo na retireti nona pr̃ovet tarea na Sabbath. ");
INSERT INTO tgp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","La sopo er̃i tapai te malele vara i ori hinia, ale hina purongo hin haratu, la usi Pilate vara i vilimateia. ");
INSERT INTO tgp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ale lara la mar̃ivisi vevuhi na retimangovi mata nona mateia, la juria na talopeilopei, la taua na papa matea. ");
INSERT INTO tgp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pani God mo sauteterahia na mateia! ");
INSERT INTO tgp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ale mo pala vaha visa isan la haratu sei enira tolu la tai Galilee la sahe Jerusalem, enira natu la vere la hinau sei la hitera isana tavtavuin Israel. ");
INSERT INTO tgp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ale kama lo retivujavujangi kamim hin Retir̃uhu atu matan retitauhi sei God mo vai isana nor̃a pua, ");
INSERT INTO tgp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","vara retitauhi atu God mo mar̃ivisia isar̃a — natura hin haratu mo tahe Iesu sohen David mo ulia na harua psalm mara, ‘Engko Natuku, nahapani na vujangia vara enau Tamam.’ ");
INSERT INTO tgp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Enia hina varar̃uhu matea sei God mo tahe Iesu na mateia matan vara i pa sopo r̃ovo, hinau atu mo verea na Retitapu sei mara, ‘A pa sileho na ler̃uhu tapu peresi na retitauhi sei na vaia isan David.’ ");
INSERT INTO tgp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Matana, mo mele verea na psalm tinapua matea mara, ‘O pa sopo tinar̃ihia vara nom Tamlohi Tapu i hite na r̃ovo.’ ");
INSERT INTO tgp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Matan David, hitahun haratu mo vai na masalon God na nona rani, mo mate ale la tavunia peresi na tahisana, epena mo r̃ovo. ");
INSERT INTO tgp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pani haratu sei God mo lo tahea na mateia, epena i pa sopo hite na r̃ovo. ");
INSERT INTO tgp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Matan haratu, la vorai ha levosahia vara hinia, kama lo retivujavujangia vara God i pa r̃omi na hehe, ");
INSERT INTO tgp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ale vara sava tamlohi la tau na nora rasua hinia, la pa tataholo na nahon God, hinau sei Leu non Moses i sopo er̃i vaia hin te rani. ");
INSERT INTO tgp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ha lo kilau! Ha sopo tinar̃ihia vara retireti nona pr̃ovet la lo vere kamim, matan la verea lara, ");
INSERT INTO tgp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ha hitea la tamlohi kerekerehi, ha mar̃urahi tavera hinia ale ha tihai! Matan na lo vai na vavahinau matea na nomim rani, vavahinau atu ha sopo er̃i rasua, hina purongo vara tea la vereulia isamim.’” ");
INSERT INTO tgp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul enia Barnabas lara la lo malue na nora ima lotu, tamlohi la usia mo r̃ilangi isara vara la mele vere la hinau atu na tavalu wik na Sabbath. ");
INSERT INTO tgp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jew matuvana peresi la haratu sei la posi la lavi na rasua nona Jew la lo lotu na ima lotu la usuri Paul enia Barnabas, ale la tupra rua atu la verea isara vara la turu r̃ilangi usuri na r̃omr̃uhu non God. ");
INSERT INTO tgp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabbath atu mo usuria, mariviti tamlohi tari hin taon tavera atu la sinai vara la rongora la retivujavujangi na reti non Moli. ");
INSERT INTO tgp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pani Jew lara la hite vao atu, mereimerei mo mar̃ivisira, ale la tapulo vereleji na sava Paul mo lo verea isara, la lo retisatihia. ");
INSERT INTO tgp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paul enia Barnabas la r̃omr̃ilangi la r̃aramira lara, “God mo taua vara kama pa sile na Retir̃uhu isana tavtavuin Israel tiroma, pani matan ka r̃ohu hinia, ale matan ka hitea vara ka sopo tataholo vara ha lavi na mauri tui, kama pa silea isana tamlohi r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Matan Moli mo retileu hinia isamam hin haratu mo verea mara, ‘Enau na vai kamim sohena malarani isana tamlohi r̃or̃oha, vara ha lavi na reti mata juri i vano na isoiso varama.’” ");
INSERT INTO tgp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","La haratu sei la tamlohi r̃or̃oha lara la rongoa, la avulahi hinia ale la hasohaso na reti non Moli, ale la haratu sei God mo vir̃onira mata mauri tui la rasua. ");
INSERT INTO tgp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ale reti non Moli mo lo unu na jara tari hin jara tavera atu. ");
INSERT INTO tgp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pani tamlohi tavera nona Jew la reve takonahi na har̃ai aulu sei la lo sile na oloolo isan God peresi na tamlohi aulu matan taon tavera atu, ale la vai na vao matea la meresahi hin Paul enia Barnabas ale la tipahi nar̃ihira hin jara tavera atu. ");
INSERT INTO tgp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pani la sar̃sar̃hi nar̃ihi na tangotango palora matara ale la vano na taon tavera matan Iconium. ");
INSERT INTO tgp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ale tamlohi rasua atu la mar̃ivi na avulahi peresi na Tanume Tapu. ");
INSERT INTO tgp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na rani Paul enia Barnabas la lo toho Iconium, la unu na ima lotu nona Jew, ale la retivujavujangi peresi na suiha mo vaia vao tavera jea matea isana Jew peresi la haratu la tamlohi r̃or̃oha la rasua. ");
INSERT INTO tgp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pani Jew sei la sopo rasua, la ari posposi la haratu la tamlohi r̃or̃oha, ale la komo na r̃omira la meresahi isan Paul enia Barnabas. ");
INSERT INTO tgp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mo vaia la toho mo peravu atu, ale la retivujavujangi mo sopo te matahu hinira, ale la vereuli na r̃omr̃uhu non Moli. Ale Moli mo vujangia vara nona retisohai sei mo varar̃uhu matan mo sile na suiha isana nona vahar̃ule vara la er̃i vai na matamata tavera peresi na hinau mar̃urahi. ");
INSERT INTO tgp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pani tamlohi hin taon tavera atu la patumasa, hai la turu peresi la Jew atu, ale hai la turu peresi la vahar̃ule atu. ");
INSERT INTO tgp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Vao matea mata Jew peresi la haratu la tamlohi r̃or̃oha peresi na nora tamlohi tatavera la hatihia vara la pa vailejlejira, ale la pa parura, ");
INSERT INTO tgp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","pani Paul enia Barnabas lara la levosahia, la rovo la vano na jara tavera Lycaonia, ale isan la taon tavera atu Lystra enia Derbe peresi na jara r̃alihi ea, ");
INSERT INTO tgp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ale la retivujavujangi na Retir̃uhu ea. ");
INSERT INTO tgp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","La pa lo toho atu Lystra la mai tataholo na tamlohi papao matea, mo vora palona la sati ale mo sopo lo hahau na maurina. ");
INSERT INTO tgp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tamlohi atu mo lo tapurongo mo r̃uhu na retivujavujangi non Paul, ale Paul mo hitea ale mo hitevosahia vara enia mo rasua vara enia i er̃i r̃uhu. ");
INSERT INTO tgp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ale Paul mo verea isana na leo tavera matea mara, “O turu!” ale tamlohi atu mo turu tataholo mo tapulo hahau. ");
INSERT INTO tgp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ale vao atu lara la hite hinau atu Paul mo vaia, la ulo na leon Lycaonia lara, “La tamlohi nike enira god sei la tai na tuka la pala na epe tamlohi!” ");
INSERT INTO tgp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","La tapulo tovi Barnabas vara Zeus sei god nona mara Greek, ale Paul enia god sei Hermes matan enia mo lo sile na retireti. ");
INSERT INTO tgp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Temple non Zeus mo lo toho na jingoima ropen taon tavera atu. Ale nona pr̃is peresi na vao la lavi na buluk peresi na r̃ongor̃ongo la vaira na vira pahai, ale la lavira la vano na mataruan taon tavera atu, ale la tatamahu vara la pa vai na malamalai isan la vahar̃ule atu. ");
INSERT INTO tgp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pani Barnabas enia Paul lara la rongovosahi na sava la lo verea, la r̃ari na nora ruru ale la maro la vano na livuhan vao atu la lo ulo lara, ");
INSERT INTO tgp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“La tapala, ka lo vai la hinau sei mata sava? Kamam tamlohi sohemim purongo. Kama mai matan vara kama sile na Retir̃uhu isamim matan vara ha pa vahar̃i na hinau la sopo r̃uhu, ale ha posi mai isan God sei mo mauri mo vai na tuka, varama, tasi peresi na hinau tari sei la lo toho hinira. ");
INSERT INTO tgp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tuai mo tinar̃ihia vara la haratu la sopo levosahi God na jara tari la er̃i usuri na masalora, ");
INSERT INTO tgp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","pani mo vujangia vara enia mo lo mauri na hina r̃uhu mo lo vaira sohena usa mo jovi na masapa ale hanhani la r̃uhu, ale ka masu na hanhani ka avulahi matana.” ");
INSERT INTO tgp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pani hina purongo hin haratu, Paul enia Barnabas mariviti la sopo er̃i horo la vao atu vara la sopo vai na malamalai isara. ");
INSERT INTO tgp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pani Jew hai la tai Antioch peresi Iconium, la mai la posi na r̃omin la vao atu la meresahi hinira, ale la paru Paul ale la reve tahitahia mo malue hin taon tavera atu matan la r̃omi vara mo mate. ");
INSERT INTO tgp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pani tamlohi rasua lara la lo turu r̃alihia, Paul mo mele turu ale mo mele unu hin taon tavera atu. Ale na rani tinapua matana, Paul enia Barnabas la malue la vano matan Derbe. ");
INSERT INTO tgp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul enia Barnabas lara la retivujavujangi na taon tavera matan Derbe la vai na tamlohi usuri matuvana. La mele hilu la sivo Lystra, Iconium ale la mele sahe Antioch matan Pisidia, ");
INSERT INTO tgp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ale hin la jara atu la tueni na rasua nona tamlohi usuri. La retituetuenira vara la turu r̃ilangi na nora rasua, ale la vere mamahunia isara lara, “R̃a pa unu hin mauri atu God mo aulu hinia na malele rani r̃ilangi matuvana.” ");
INSERT INTO tgp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paul enia Barnabas la vir̃oni na patu tamlohi mata kilau na vao kalesia tari, ale na usiusi peresi na tapuhoro hanhani la taura na liman Moli sei la lo tau na nora rasua hinia. ");
INSERT INTO tgp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Moiso la mele sivo roto Pisidia vavano la tikeli Pamphylia. ");
INSERT INTO tgp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Hin jara atu la mele retivujavujangi Perga moiso la sivo Attalia. ");
INSERT INTO tgp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","La malue hin jara atu la vele na boti la vano Antioch matan Syria, jara atu sei la lo tapulo na nora hahau ea, jara sei la taura na liman r̃omr̃uhu non God ea matan voko sei la isoiso hinia natu. ");
INSERT INTO tgp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lara la pala, la tovi matavuhi na vao kalesia na jara matea, ale la vereuli vevuhi na sava God mo vaia isara ale sohena sava mo roi na malele mata rasua isan la haratu la tamlohi r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ale la lo toho peresi na tamlohi usuri Antioch mo peravu makomona. ");
INSERT INTO tgp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pani tamlohi hai la tai Judea la sinai la tapulo vujangi na kalesia vara, “Vara ha sopo tair̃alihi sohen leu non Moses mo verea, ha pa sopo er̃i juri!” ");
INSERT INTO tgp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul enia Barnabas lara la rongoa la sopo avulahi, la vauriuri tavera peresira matana. Ale vao kalesia atu la vir̃oni Paul enia Barnabas peresi na nora tamlohi hai, vara la sivo Judea matan la sahe Jerusalem vara la sorahia peresi na vahar̃ule tolu na tamlohi tatavera nona vao kalesia Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Vao kalesia Antioch la r̃ulera la sivo, ale lara la lo sivo la rohi Phoenicia peresi Samaria, ale la sorahia sohena sava la haratu la tamlohi r̃or̃oha la posi, ale vorai kalesia hin la jara atu la avulahi tavera matana. ");
INSERT INTO tgp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ale hin rani atu la kakau Jerusalem, kalesia tari, vahar̃ule peresi na vajiahara, la lavi Paul enia Barnabas na avulahi. Ale la vere vevuhi na sava God mo vaia na nora vavahinau. ");
INSERT INTO tgp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pani tamlohi rasua hai sei la tai na vao Pharisee, la turu lara, “Ha vujangi la haratu la tamlohi r̃or̃oha vara la pa tair̃alihi, ale la pa usuri na leu non Moses.” ");
INSERT INTO tgp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Vahar̃ule peresi na vajiahara la pulutahi vara la sorahi hinau sei. ");
INSERT INTO tgp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Retireti matuvana la vano moiso, Peter mo turu ale mara, “La vorai, ka levosahia vara tiroma God mo vir̃oniau vara a vano a retivujavujangi isan la haratu la tamlohi r̃or̃oha, matan vara la er̃i rongo na retisohai mata Retir̃uhu, ale la rasua. ");
INSERT INTO tgp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God sei mo levosahi na mapu tamlohi, mo vujangia vara enia mo avulahi hinira, matan enia mo sile na Tanume Tapu isara sohen mo lo silea isar̃a nike. ");
INSERT INTO tgp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Na nahon God, enr̃a r̃a sopo tinapua hinira, matan mo vai na mapura la vokevoke na rasua sohena. ");
INSERT INTO tgp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ale vara mo sohena, mata sava ka lo vaihite God, matan ka opoia vara ha tau na tetehi puhoni isana tamlohi usuri sei la tamlohi r̃or̃oha? Hinau sei, enr̃a teni nor̃a pua la sopo er̃i solotia! ");
INSERT INTO tgp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pani r̃a rasua vara God i pa jurir̃a na r̃omr̃uhu non Moli Iesu sohera.” ");
INSERT INTO tgp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ale r̃omr̃omi atu mo moti, ale tamlohi tari la tapurongo isan Barnabas enia Paul, la sorahi na matamata tavera peresi na hinau mar̃urahi sei God mo lo vaira na naho tamlohi la tamlohi r̃or̃oha. ");
INSERT INTO tgp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","La retireti mo isoiso, James mo turu mo verea mara, “La vorai, ha tapurongo isaku. ");
INSERT INTO tgp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ka rongoa Simon Peter mo verea moiso sohena sava God mo r̃ulea isana tamlohi r̃or̃oha vara i lavi nar̃ihi na nona tamlohi isara. ");
INSERT INTO tgp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ale reti nona pr̃ovet la majinga hin hinau sei sohen la ulia na Retiulia lara, ");
INSERT INTO tgp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Hitahun hinau sei a pa mele pala, ale a pa mele voro na jaran supe David sei mo jovi. A pa mele voroa hin la sopesopena sei la lo toho, ale a pa mele turuhia, ");
INSERT INTO tgp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","matan vara tamlohi tinatinapua na varama la pa hite Moli ea, la haratu sei la tamlohi r̃or̃oha sei, na tovira moiso vara la pa noku. Harihi enia sava Moli mo verea.’ ");
INSERT INTO tgp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Haratu sei mo lo vereuli la hinau nike tuai moiso. ");
INSERT INTO tgp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Matan haratu, noku kilakilau r̃a sopo mele sile te rani r̃ilangi tinapua isana tamlohi r̃or̃oha sei la lo posi la mai isan God, ");
INSERT INTO tgp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","pani mo r̃uhu vara r̃a uli te leta hatea mata i verea isara vara i horora vara la sopo hani na mit sei la silea isana tamasi moiso, ale vara la toho asau na mauri maji, ale vara la sopo hani te maji sei la punia, ale la sopo inu na r̃ae. ");
INSERT INTO tgp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Matan la leu nike non Moses la retivujavujangira na ima lotu nona Jew na taon tavera tari na Sabbath mata tauni mo visa moiso.” ");
INSERT INTO tgp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ale vahar̃ule peresi na vajiahara peresi na vao kalesia Jerusalem, la vir̃oni na tamlohi hai, ale la r̃ulera la sahe Antioch matan Syria peresi Paul enia Barnabas, vara la vereuli na r̃aramin r̃omr̃omi atu la lo hahau matana. La tamlohi atu la vir̃oni na patu tamlohi nona vao kalesia mo rua, Judas sei tapala hijana Barsabbas peresi Silas. ");
INSERT INTO tgp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Harihi enia leta atu la lo lavia peresira: “Retioloolo isamim la vorai kalesia Antioch, Syria peresi Cilicia sei ka tamlohi r̃or̃oha, mo tai isana vorai kalesia nike Jerusalem, peresi na vahar̃ule peresi na vajiaha sei la aulu na vao kalesia nike. ");
INSERT INTO tgp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kama levosahia vara tamlohi hai la tai nike la vano isamim ale la vai na r̃omimim la kaka na nora vujangi, pani kama sopo r̃ulera hin te hinau sohena. ");
INSERT INTO tgp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ale matana, kama hitea vara mo tataholo vara kama r̃ule la vahar̃ule sei Judas enia Silas peresi la vorai r̃uhur̃uhu sei Paul enia Barnabas isamim usuri na r̃omr̃omi kamam tari nike kama hatihia. ");
INSERT INTO tgp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paul enia Barnabas sei mariviti la mate matan Moli Iesu Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ale matana, kama lo r̃ule Judas enia Silas vara la pa vereuli na sava kama ulia hin leta nike na nahomim. ");
INSERT INTO tgp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Matan kama majinga peresi na Tanume Tapu vara i pa mele r̃uhu vara kama sopo mele tau te retileu r̃ilangi isamim, pani la retileu nike mo visalete purongo: ");
INSERT INTO tgp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Vara ha sopo hanhani na mit sei la silea isana tamasi moiso, ale vara ha sopo hani te maji sei la punia, ale ha sopo inu na r̃ae, ale vara ha toho asau na mauri maji. Vara ha sopo vai la hinau atu, i pa r̃uhu jea isamim. Enia natu, enr̃a vuho.” ");
INSERT INTO tgp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ale la vahar̃ule tupu vati atu la malue, vahatea la sahe Antioch. La tovi matavuhi na kalesia tari la mai jara matea atu, ale la evi leta atu isara. ");
INSERT INTO tgp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ale avulahi tavera mo jovi isana kalesia tari hin rani atu, lara la rongo retisohai r̃uhu atu. ");
INSERT INTO tgp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ale Judas enia Silas enira tupra rua la pr̃ovet, ale la retireti mo peravu isana kalesia vara la tueni na nora rasua vara i ulua i mele r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","La lo toho atu mata makomo rani moiso, la r̃ulera la mele sivo Jerusalem peresi na ler̃uhu nona kalesia isan la haratu sei la lo r̃ulera. ");
INSERT INTO tgp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Pani Paul enia Barnabas la lo toho Antioch, la lo vujangi, ale la retivujavujangi na reti non Moli peresi na tamlohi tinapua hai. ");
INSERT INTO tgp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Rani hai la vano moiso, ale Paul mo verea isan Barnabas mara, “R̃a mele sahe r̃a rohi na vorai hin la taon tavera tari sei r̃a lo retivujavujangi na reti non Moli ea, ale r̃a hitea vara la lo sohena sava.” ");
INSERT INTO tgp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas mo avulahi ale mo opoia vara i lavi John Mark. ");
INSERT INTO tgp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pani Paul mo r̃ohu r̃ilangi, matan John Mark mo rovo hinira tiroma Pamphylia ale mo sopo tuenira na nora vavahinau. ");
INSERT INTO tgp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","La sopo er̃i mai na r̃omr̃omi matelete mo vaia Barnabas mo lavi John Mark peresia ale la vele na boti la sahe Cyprus, ");
INSERT INTO tgp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","pani Paul mo vir̃oni Silas ale la malue peresi na ler̃uhu nona vorai kalesia lamane peresi na har̃ai. ");
INSERT INTO tgp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mo sahe roto Syria peresi Cilicia mo tueni na vao kalesia tari ea vara la turu r̃ilangi na nora rasua. ");
INSERT INTO tgp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul mo mele sahe mo mai Derbe, ale mo sahe Lystra. Hin jara atu mo tapai na uluvou matea enia tamlohi usuri matea, hijana Timothy, enia natun har̃ai Jew matea enia kalesia, pani tamana enia mara Greek matea. ");
INSERT INTO tgp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Vorai kalesia Lystra peresi Iconium la verea vara enia tamlohi r̃uhu matea. ");
INSERT INTO tgp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul mo opoia vara Timothy i usuria na nora hahau, ale mo lavia mo tair̃alihia matan la Jew atu la lo toho hin jara atu la levosahia vara tamana enia mara Greek matea. ");
INSERT INTO tgp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lara la lo vano na taon tavera hatehateahi, la lo vereuli na sava sei vahar̃ule peresi na vajiaha sei lo aulu na kalesia Jerusalem, la hatihia vara tamlohi r̃or̃oha la pa oloolo hinira. ");
INSERT INTO tgp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Matana, vao kalesia tari la mele ulua r̃ilangi na nora rasua, ale evira mo lo sahe aulu na rani hatehateahi. ");
INSERT INTO tgp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ale la sahe la hahau roto na jara tavera matan Phrygia peresi Galatia, matan Tanume Tapu mo horora vara la sopo sivo Asia mata la vere na retisohai non Moli ea. ");
INSERT INTO tgp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Lara la mai Mysia, la vaihitea vara la sahe na jara matan Bithynia, pani Tanumen Iesu mo horora, ");
INSERT INTO tgp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ale la mele hahau sivo roto Mysia moiso la sivo Troas. ");
INSERT INTO tgp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Hin vutepongi atu hinau matea sohena mavuho matea mo pala isan Paul. Mo hite na mara Macedonia matea mo lo turu atu mo lo usia r̃ilangi mara, “O mai Macedonia, o tueni kamam!” ");
INSERT INTO tgp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul mara mo hite mavuho atu moiso, kama turu vahatea, ale kama aleale malelemam vara kama vano Macedonia, kama levosahia vara God mo tovi kamam vara kama vano kama retivujavujangi na Retir̃uhu isara. ");
INSERT INTO tgp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ale kama vele na boti Troas kama sahe tataholo Samothrace, ale mo mele rani sahe kama hoso Neapolis, ");
INSERT INTO tgp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","moiso kama malue atu kama lo sahe Philippi, enia taon tavera matan Macedonia, jara mara Rome matea. Kama toho atu mata makomo rani. ");
INSERT INTO tgp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ale na Sabbath kama malue na mataruan taon tavera atu, kama vano makomona na pahisa wai matea. Kama r̃omi vara enia jara matea tamlohi la lo pulutahi mata usiusi ea, ale kama sakele hin jara atu ale kama lo sorasora peresi la har̃ai atu sei la lo pulutahi atu. ");
INSERT INTO tgp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Vonara matea, hijana Lydia enia mara Thyatira sei, enia taon tavera matea, enia mo lo vai na mania na ruru r̃uhu sei perpel, ale matan enia mo lo lotu God, mo lo tapurongo isamam. Ale God mo roi na mapuna vara i rasu na sava Paul mo lo verea. ");
INSERT INTO tgp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ale mo lavi na paptijo peresi na vao imana, ale hitahuna, mo usia r̃ilangi isamam mara, “Vara na nomim kilakilau ka hitea vara enau na lo turu r̃ilangi hin Moli, ha mai na imaku ale ha lo toho ea.” Ale mo verea mo r̃ilangi vavano kama majinga isana. ");
INSERT INTO tgp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kamara kama lo vano na jara mata usiusi, kama tapai na har̃arihi slev matea sei tanume sasati mata vere na hinau i pa masese mo lo toho hinia. Ale nona tamlohi tavera la lo lavi na mania tavera matana. ");
INSERT INTO tgp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mo lo usuri kamam peresi Paul, mo lo ulo aulu mara, “La tamlohi nike enira la volitusi non God sei mo Aulu Jea, enira la lo retivujavujangi kamim na malele mata juri.” ");
INSERT INTO tgp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ale mo lo vai hinau atu sohena mata rani matuvana moiso, ale Paul mo malokona, ale mo posi vano isana mo verea isan tanume sasati atu mara, “Na retileu isam na hijan Iesu Kr̃isto vara o malue hinia.” Ale vahatea purongo mo tinar̃ihia. ");
INSERT INTO tgp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pani nona tamlohi tavera lara la hitea vara malele mata nora mania mo pelati, la taurilati Paul enia Silas la reve tahitahira la sivo na jara maket, la vaira la turu na naho tamlohi aulu hin taon atu. ");
INSERT INTO tgp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Lara la lavira la mai la turu na naho tamlohi aria atu, la verea lara, “La mara Jew nike, la lo vai na r̃om tamlohi hin taon tavera nike la sopo sakele, ");
INSERT INTO tgp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ale la lo vujangi na tamlohi na posposi hai mo sopo tataholo vara enr̃a mara Rome r̃a lavira teni vara r̃a vaira!” ");
INSERT INTO tgp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Vao atu la tapulo turuleji hinira, ale la tamlohi aria atu la r̃ari nar̃ihi na ruru non Paul enia Silas, ale la retileu vara la hamajira na maja. ");
INSERT INTO tgp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hitahun haratu la hamaji komokomora, la pulahira na lolo ima r̃ilangi, ale la retileu vara tamlohi ima r̃ilangi i lo kilaura vara la sopo mele malue. ");
INSERT INTO tgp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mara mo lavi retileu atu sohena, mo pulahira sivo na jara matea na lolona vahatea. Ale mo sohoni na palora na koko tapea mo pilatira. ");
INSERT INTO tgp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Na livuha vutepongi, Paul enia Silas la pa lo usiusi ale la lo lalavete isan God, ale tamlohi tinapua na lolo ima r̃ilangi, la lo tapurongo hinira. ");
INSERT INTO tgp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Vahatea purongo, mihi tavera matea mo hisu, mo hisuhi ima r̃ilangi atu mo tikeli pulona vahatea, ale vahatea purongo pelati tari la roi, ale jen tari la jovi nar̃ihi hinira enira mo isoiso. ");
INSERT INTO tgp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tamlohi kilau na ima r̃ilangi mara mo turu mo hitea vara pelati tari la roi, mo reve nar̃ihi na nona sita mo tatamahu vara i pa vilia enia hasena, matan mo r̃omi vara la haratu la lo toho na lolo ima r̃ilangi la rovo moiso. ");
INSERT INTO tgp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pani Paul mo ulo aulu isana mara, “O sopo vaia! Matan kamam mo isoiso nahai kama lo toho!” ");
INSERT INTO tgp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tamlohi atu mo ulo mata lamu ale mo maro matan lolon ima r̃ilangi atu vahatea, ale mo jovi na palon Paul enia Silas na nona matahu. ");
INSERT INTO tgp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Moiso mo lavira la malue ale mo usia isara mara, “La tamlohi tavera, a pa vai na sava vara a er̃i juri hinia?” ");
INSERT INTO tgp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","La r̃aramia lara, “O tau na nom rasua hin Moli Iesu, ale o pa juri, engko peresi na vao imam.” ");
INSERT INTO tgp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ale la vere na reti non Moli isana peresi la haratu sei la lo toho peresira na lolo ima. ");
INSERT INTO tgp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ale hin vutepongi atu purongo mo lavira la vano mo hoje na matara maja isara, ale enia peresi na vao tari na imana la paptijo vahatea. ");
INSERT INTO tgp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ale pa tamlohi atu mo lo kilau na ima r̃ilangi mo lavira la sahe na imana, ale mo tau na hanhani na nahora ale mo avulahi tavera peresi na vao imana, matan enira la tau na nora rasua hin God. ");
INSERT INTO tgp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pani na nahonaho rani, la tamlohi aria atu la r̃ule na nora police vara la verea isan tamlohi atu mata kilau na ima r̃ilangi lara, “O tinar̃ihira!” ");
INSERT INTO tgp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pa tamlohi atu mata kilau na ima r̃ilangi, mo vere retireti atu isan Paul mara, “Tamlohi aria, la vahar̃ule vara a tinar̃ihi kamim. Ale matana, ha malue ha vano na tamata.” ");
INSERT INTO tgp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pani Paul mo verea isana police atu mara, “La tamlohi atu la hamaji kamam na naho tamlohi, la sopo usuri na posposi tataholo mata ari na tamlohi, hina purongo vara kama mara Rome, ale la pulahi kamam na ima r̃ilangi. Ale nake, la opoia vara la tinar̃ihi kamam tamlohi la sopo levosahia? Mo sopo te malele sohena. Ha vano ha verera hinia vara enira la pa mai nike, ale la nar̃ihi kamam.” ");
INSERT INTO tgp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","La police atu la vere la retireti atu isan la tamlohi aria atu. Ale la tamlohi aria atu lara la rongoa vara Paul enia Silas enira mara Rome, la matahu tavera matana. ");
INSERT INTO tgp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ale la mai la r̃omtuhutuhu isara. Ale la lavi nar̃ihira la usira r̃ilangi vara la malue hin taon tavera atu. ");
INSERT INTO tgp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lara la malue na ima r̃ilangi, la vano la unu na iman Lydia, ale lara la hite na vorai kalesia atu la retituetuenira moiso la malue. ");
INSERT INTO tgp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lara la hahau roto Amphipolis enia Apollonia moiso, la mai Thessalonica sei ima lotu nona Jew matea mo lo toho ea. ");
INSERT INTO tgp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ale usuri na posin Paul, mo lo matavuhi peresira mata Sabbath mo tolu, ale mo lo vereuli na Retitapu isana tamlohi ea. ");
INSERT INTO tgp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mo lo vereuli mamahuni na Retitapu na nona vujangi sohena sava Kr̃isto i pa lavi na rongohaji, ale i pa mele turu na mateia, ale mo verea mara, “Iesu akerihi natu sei na lo retivujavujangia isamim, enia Kr̃isto atu.” ");
INSERT INTO tgp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tatua Jew atu la rasua peresi na vao tavera mara Greek la lo lotu God peresi na har̃ai aulu matuvana, la avulahi vara la tapala peresi Paul enia Silas. ");
INSERT INTO tgp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pani tamlohi aulu nona Jew la mereimerei hinira, ale la lavi na tamlohi sasati hai hin vao tavera atu na jara maket, ale la vaira la mai vao meresahi matea, ale taon tavera atu mo tapulo roroa na leora. ");
INSERT INTO tgp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ale lara la sopo er̃i hite Paul enia Silas, la reve tahitahi Jason peresi na vorai kalesia hai, la vaira la turu na naho tamlohi aulu matan taon tavera atu, la ulo lara, “La tamlohi nike sei la lo posileji na varama, enira nahai la pala nike sohen la pete vaia na jara tinapua moiso, ");
INSERT INTO tgp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ale Jason mo avulahi hinira mo taura na imana! Enira mo isoiso la lo turuleji na retileu non supe nona mara Rome matan la lo vere na supe tinapua matea hijana Iesu!” ");
INSERT INTO tgp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ale tamlohi peresi na tamlohi aulu matan taon tavera atu lara la rongo la hinau sei, r̃omira la sopo sakele. ");
INSERT INTO tgp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","La tamlohi aulu atu matan taon tavera atu lara la lavi na mania mata volituhu non Jason peresi la vorai kalesia tinapua atu moiso, la tinar̃ihira. ");
INSERT INTO tgp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hin vutepongi atu purongo, kalesia la r̃ule Paul enia Silas la malue la vano Berea, ale lara la pala atu, la vano la unu na ima lotu nona Jew. ");
INSERT INTO tgp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ale Jew matan Berea enira tamlohi ale lelevosahi, la jeu la haratu Thessalonica, matan la lo opoia jea vara la tapurongo hin retisohai atu na rani hatehateahi, ale la lo kilau usuri mamahuni na Retitapu matan vara la hitea vara mo sohena teni mo vono. ");
INSERT INTO tgp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ale matana, vao tavera isara la rasua peresi na mara Greek aulu hai lamane peresi na har̃ai. ");
INSERT INTO tgp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pani Jew matan Thessalonica lara la rongoa vara Paul mo lo retivujavujangi na retisohai mata reti non God Berea, la mai ea sohena, ale la vai na vao matea matan vara la vai na r̃omi tamlohi la sati. ");
INSERT INTO tgp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ale vahatea purongo la vorai kalesia atu la r̃ule Paul mo sivo na tasi, pani Silas enia Timothy la lo toho atu Berea. ");
INSERT INTO tgp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","La haratu la lo tiroma hin Paul la lavia mo sivo la tikeli Athens, ale Paul mo verea isara mara la vere Silas enia Timothy la sinai isana vila, ale la vorai kalesia atu la malue la sahe matara. ");
INSERT INTO tgp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ale na rani Paul mo lo saovira Athens, r̃omina mo jovi tavera matan mo hite taon tavera atu mo mar̃ivi na tamasi. ");
INSERT INTO tgp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ale mo lo vano na ima lotu nona Jew vara i retivujavujangi isara peresi na tamlohi r̃or̃oha sei la lo lotu God ea, ale na rani hatehateahi mo lo vujangi na vao tamlohi sei la lo toho na jara maket. ");
INSERT INTO tgp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ale Paul mo mele sorasora peresi na tamlohi hai la lo usuri na vujangi non Epicurus peresi hai non Zeno sei la tovira Stoic, ale hai la lo usia lara, “Tamlohi rongorongo vono nike mo lo vere na sava nahai?” Tatuara lara, “Vara o tapurongo usuria, o pa hitea sohena vara mo lo vujangi na rasua paro matea.” La pa verea sohena matan Paul mo lo retivujavujangi na Retir̃uhu matan Iesu peresi na nona sauteterahi. ");
INSERT INTO tgp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ale la lavi Paul la vano na council nora sei hijana Areopagus, lara, “O er̃i vereuli kamam hin vujangi paro akerihi sei ko lo retivujavujangia? ");
INSERT INTO tgp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Matan ko lo vere na hinau paro hai nahai na peromam, ale kama opoia vara kama levosahi na r̃aramira.” ");
INSERT INTO tgp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mara Athens peresi na tamlohi mara jara tinatinapua sei la lo toho atu, tarea la lo opoia vara la lo sorahi na r̃omr̃omi paro sei la pa pala purongo. ");
INSERT INTO tgp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ale Paul mo turu na naho vao matan Areopagus atu ale mara: “Mara Athens, na hitea vara kamim ka r̃ilangi na sava ka lo rasua, ");
INSERT INTO tgp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","matan nara na lo hahau r̃alihi, ale na hite na nomim hinahinau mata lotu, ale na mele hite na uliuli matea mo lo toho na votavota vara, Isana god matea kama sopo levosahia Matan haratu a pa retivujavujangi kamim hin God atu sei ka lo lotua pani ka sopo levosahia. ");
INSERT INTO tgp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God atu sei mo vai na varama peresi na hinau tari hinia enia Moli matan na tuka peresi na varama, ale mo sopo toho na ima lotu sei tamlohi la lo vaira na limara, ");
INSERT INTO tgp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","teni tamlohi la sopo volitusi isana na limara sohena vara enia mo opoi te hinau isara, pani enia natu mo sile na mauri peresi na maromaro peresi na hinau tari isana tamlohi tari. ");
INSERT INTO tgp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ale na tamlohi matea mo vai na tamlohi mara jara tinatinapu tari vara la toho na jara tari na varama, mo tau na nora rani ale mo tau na jara sei vara la pa toho ea, ");
INSERT INTO tgp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","matan vara la pa ale God, ale la pa tarongo ale vara la tapaia, pani enia mo sopo toho asau hinir̃a hatehateahi. ");
INSERT INTO tgp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Matan hinia, enr̃a r̃a lo mauri, r̃a lo vavahinau ale r̃a lo toho, sohena nomim tamlohi lelevosahi hai la verea moiso lara, ‘Matan enr̃a sohena enr̃a taniana.’ ");
INSERT INTO tgp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ale matan enr̃a sei r̃a natun God, r̃a pa sopo r̃omr̃omia vara God enia hinau matea la vaia na gold teni silver teni vatu, teni te niniu tamlohi la vai mamahunia usuri na r̃omira. ");
INSERT INTO tgp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Matan haratu, hina purongo vara God mo lo kilau purongoi la haratu la lo toho na mauri r̃or̃oha, pani nake, mo lo retileu vara tamlohi tari na jara tari vara la pa vahar̃i na nora hehe, ");
INSERT INTO tgp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","matan enia mo tau na rani matea moiso vara i pa ari na varama usuri na nona posposi tataholo jea na lima tamlohi matea enia mo vir̃onia, ale mo vujangia mo memera isana tamlohi tari hin haratu mo sauteterahia na mateia.” ");
INSERT INTO tgp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ale lara la rongo na retireti matan sauteterahi atu, hai la tapulo vaivaia. Pani hai lara, “Kama pa mele tapurongo isam matan la hinau akerihi hin te rani.” ");
INSERT INTO tgp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ale Paul mo malue na naho tamlohin Areopagus atu. ");
INSERT INTO tgp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pani tamlohi hai la usuria ale la rasu na sava mo lo verera. Vonara matea hijana Dionysius, enia tamlohi matea hin council tavera atu Areopagus, ale har̃ai matea hijan Damaris, ale mele tamlohi tinapua hai peresira. ");
INSERT INTO tgp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hitahun haratu, Paul mo malue Athens mo sivo Corinth. ");
INSERT INTO tgp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ale mo tapala peresi na Jew matea hijana Aquila mara Pontus matea sei mo pa tai Italy purongo peresi narouna Priscilla, matan Claudius, supe matan Rome, mo retileu vara Jew tari la malue Rome, ");
INSERT INTO tgp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ale matan Paul, enia nona voko mo sohera la lo vai na tent, ale mo lo toho peresira mo lo voko peresira. ");
INSERT INTO tgp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ale na Sabbath hatehateahi, Paul mo lo retivujavujangi isana Jew peresi na mara Greek na nora ima lotu ale mo lo vaihitea vara la levosahia vara Iesu enia hare. ");
INSERT INTO tgp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas enia Timothy lara la tai Macedonia la pala, Paul mo tau vevuhi na nona rani mata retivujavujangi na reti non God, ale mo lo vereulia isana Jew tarea vara Iesu enia Kr̃isto atu la lo kilau matana. ");
INSERT INTO tgp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pani Jew lara la r̃ohu hinia, ale la verelejlejia. Paul mo vai na tovongi matea mo vujangi na nona r̃ohu hinira hin haratu mo sar̃sar̃hi nar̃ihi na tangotango na nona ruru ale mara, “R̃aemim i pa toho na patumim, mo sopo te noku hinau hinia! Mo tapulo nake, a pa vano isana tamlohi r̃or̃oha!” ");
INSERT INTO tgp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Moiso, Paul mo malue hin nora ima lotu atu mo vano mo unu na ima matea mo lo toho na pahisan ima lotu atu, enia iman Titius Justus, tamlohi r̃or̃oha matea pani enia mo lo lotu God. ");
INSERT INTO tgp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pani Crispus, tamlohi aulu mata ima lotu atu, enia peresi na vao imana sohena la rasu Moli. Mara Corinth tinapua hai sei la rongo hinau atu, la rasua, ale la lavi na paptijo sohera. ");
INSERT INTO tgp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ale Moli mo vujangi Paul na hinau matea sohena mavuho matea hin vutepongi atu, mo verea isana mara, “O sopo matahu, o retireti, o sopo puni na jingom, ");
INSERT INTO tgp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","matan enau na lo toho peresiho, ale tea i sopo er̃i tikeli na epem vara i komoho, matan noku tamlohi hin taon tavera nike la mar̃ivi.” ");
INSERT INTO tgp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Matan haratu, Paul mo lo toho atu mata tauni matea vitu mo limarave, mo lo vujangi na reti non God isara. ");
INSERT INTO tgp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ale hin rani atu Gallio mo lo aulu hin Achaia, Jew la pulutahi jara matea la vai na vao tavera matea, ale la turuleji hin Paul, la taurilatia la vaia mo turu na naho jara aria vara la aria ");
INSERT INTO tgp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","lara, “Tamlohi akerihi mo lo verea isana tamlohi vara la lotu God na malele matea mo sopo usuri na posposi sei leu non Moses mo lo verea.” ");
INSERT INTO tgp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul mo tatamahu vara i pa retireti pani Gallio mo verea isan la Jew atu mara, “Vara hinau akerihi enia mata tope na leu matea, teni matan te var̃en sasati, i pa tataholo vara a tapurongo isamim Jew matana, ");
INSERT INTO tgp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","pani matan enia mata nomim retireti peresi na hija tamlohi peresi na nomim leu, kamim purongo ha vai tataholoia. A pa sopo ari na hinau sohena.” ");
INSERT INTO tgp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ale mo vai na nona tamlohi la sohai nar̃ihira na nona jara aria. ");
INSERT INTO tgp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ale vao atu la taurilati Sosthenes, tamlohi aulu mata ima lotu nona Jew, ale la tapulo tamajia na naho jara aria atu purongo, pani Gallio mo sopo kilaura hinia. ");
INSERT INTO tgp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul mo mele toho Corinth mata rani matuvana moiso natu mo vere enr̃a vuho isana vorai peresi na vevorai kalesia atu. Ale mo vele na boti matea peresi Priscilla enia Aquila matan vara la vano Syria. Paul mo hiri nar̃ihi na vuluna hin rani atu la pa lo toho Cenchreae mata vujangia vara mo vai vevuhi na nona retitauhi. ");
INSERT INTO tgp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Na rani la pala Ephesus, Paul mo tinar̃ihi Priscilla enia Aquila la pa lo toho atu. Ale enia mo sahe mo unu na ima lotu nona Jew, ale mo retivujavujangi isara. ");
INSERT INTO tgp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mara Ephesus lara la usia vara i toho peravu isara, mo verea isara mara mo vono, ");
INSERT INTO tgp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","pani mo vere enr̃a vuho isara ale mara, “Vara na masalon God, a pa mele mai isamim.” Moiso la mele vele hin boti atu, la malue Ephesus. ");
INSERT INTO tgp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ale lara la hoso Caesarea, Paul mo sahe Jerusalem vara i sile na retioloolo isana vao kalesia ea tiroma, moiso mo pa sahe Antioch matan Syria. ");
INSERT INTO tgp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mo lo toho atu mata makomo rani, moiso mo mele malue mo sahe mo r̃alihi na jara matan Galatia enia Phrygia vara i vai na tamlohi usuri hin la jara atu la mele r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Hin pongi atu Jew matea hijana Apollos mara Alexandria mo pala Ephesus. Ale enia tamlohi sorasora r̃uhu matea mo levosahi mamahuni na Retitapu. ");
INSERT INTO tgp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mo lavi na nona levosahi matan Moli moiso, ale maurina mo lo vujangi na nona avulahi na nona retireti peresi na vujangi tataholo r̃uhu na hinahina varar̃uhu hin Moli, pani nona levosahi mo tikeli na paptijo non John purongo. ");
INSERT INTO tgp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mo tapulo na nona retireti na lolo ima lotu nona Jew mo sopo te matahu hinia. Pani Priscilla enia Aquila lara la rongoa, la tovi r̃or̃ohia vano hasena, ale la vere tataholoi na malelen God isana. ");
INSERT INTO tgp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Hitahu, Apollos mara mo opoia vara i sivo Achaia, vorai kalesia peresi na vevorai kalesia la retituetuenia vara i vaia. Ale la uli na leta matea isana vorai kalesia Achaia vara la lavia. Mara mo pala isan la haratu la rasua atu, mo tuenira mo tavera usuri na r̃omr̃uhu non Moli, ");
INSERT INTO tgp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","matan mo vilijovjovi vevuhi na r̃omr̃omi nona Jew na naho tamlohi. Ale mo vujangira usuri na Retitapu vara Kr̃isto atu enia Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ale hin rani atu Apollos mo lo toho Corinth, Paul mo hahau roto na uratan Asia mo pala Ephesus. Ale hin jara atu mo tapai na tamlohi usuri hai, ");
INSERT INTO tgp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ale mo verea isara mara, “Kamim ka lavi na Tanume Tapu hin rani atu ka tapulo rasua, teni mo vono?” La r̃aramia lara, “Mo vono, kama sopo lo rongoa vara te Tanume Tapu mo lo toho.” ");
INSERT INTO tgp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ale Paul mo verea mara, “Vara sohena, kamim ka paptijo na sava?” Lara, “Paptijo atu John mo lo vaia.” ");
INSERT INTO tgp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul mara, “Paptijo atu John mo lo vaia, enia paptijo mata vahar̃i na hehe, ale mo lo verea isana tamlohi vara la pa tau na nora rasua hin haratu mo lo mai hitahu hinia, enia mo lo vere Iesu sei.” ");
INSERT INTO tgp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Lara la rongo hinau atu, la paptijo na hijan Moli Iesu, ");
INSERT INTO tgp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ale Paul mara mo tau na limana hinira, Tanume Tapu mo mai hinira ale la tapulo retireti na leo tinatinapua, ale la lo retimangovi. ");
INSERT INTO tgp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Korong, enira tupu sangavulu r̃omana mo rua. ");
INSERT INTO tgp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ale Paul mo unu na ima lotu nona Jew, ale mo retivujavujangi mo sopo te matahu isana mata vitu mo tolu. Mo vere mamahunia vara mauri atu God mo aulu hinia mo sohena sava, ale mo vaira la hitevosahi na nona vujangi matan mauri atu. ");
INSERT INTO tgp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pani tatuara la lo turu r̃ilangi na r̃omira hasera, ale la r̃ohu vara la rasu. La verelejleji rasua atu na naho tamlohi. Ale Paul mo malue mo lavi la tamlohi usuri atu peresia. Na rani hatehateahi la lo pulutahi na ima matavuhi matan Tyrannus, ale mo lo retivujavujangira ea. ");
INSERT INTO tgp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Paul mo vaia sohena mata tauni mo rua matan haratu tamlohi tari sei la lo toho Asia, Jew peresi na tamlohi r̃or̃oha, la rongo na reti non Moli. ");
INSERT INTO tgp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God mo lo vai na matamata tavera tinatinapua na liman Paul. ");
INSERT INTO tgp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ale matana, hina purongo vara te ruru kamoti teni ruru mata voko purongo la tia na hur̃in Paul, ale vara la lavira la vano isana tamlohi rojoa, mo vai na nora rojoa la tihai, ale tanume sasati la malue hinira. ");
INSERT INTO tgp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ale pani Jew hai sohena, la lo titiu nar̃ihi na tanume sasati na taon la lo vano hinira, pani la vaihitea vara la vaia na hijan Moli Iesu isan la haratu sei tanume sasati la lo toho hinira, ale la verea sohen harihi lara, “Na lo retileu r̃ilangi isam na hijan Iesu sei Paul mo lo retivujavujangia vara o malue!” ");
INSERT INTO tgp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Vorai mo limaravrua la natun Jew matea hijana Sceva, enia mo lo hase verea vara enia pr̃is aulu matea, enira natu la lo vai la hinau nike. ");
INSERT INTO tgp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pani lara la vaia, tanume sasati matea mo r̃aramira mara, “Na levosahi Iesu, ale na levosahi Paul makomona, pani kamim sava tamlohi hin kamim?” ");
INSERT INTO tgp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pa tamlohi atu sei tanume sasati mo lo toho hinia mo kue matara mo hamajira vavano la levosahi, ale la hitea sohena la sopo er̃i mele vai te hinau, la turu la maro la rovo malamala, pani la loso na r̃aera la vano. ");
INSERT INTO tgp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jew tari peresi na tamlohi r̃or̃oha tari Ephesus la rongo sorasora akerihi, ale mo vaira la matahu enira mo isoiso. Ale hijan Moli Iesu mo lavi na hasohaso tavera matana. ");
INSERT INTO tgp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Matuvana hin la haratu sei la rasu Iesu, la sinai la turu nahonaho, la taviti na sava hehe la vaira. ");
INSERT INTO tgp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Vao tavera sei la lo mahumahu, la lavi na nora puku mata mahumahu la takonahira jara matea, ale la sulira na naho tamlohi tari. Lara la evi na volin la puku atu hatehateahi, evira mo isoiso mo tataholo na volvoli mata voko mata rani mo tari vaha ngavulu lima . ");
INSERT INTO tgp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Matan haratu, retisohai hin Moli mo ulua, ale suihana mo posi na mauri tamlohi matuvana. ");
INSERT INTO tgp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hitahun la hinau atu, Paul mo tau na r̃omina vara i sivo Jerusalem, ale vara i hahau roto Macedonia enia Achai. Mo verea mara, “Vara na sivo atu moiso, na opoia vara a vano a hite Rome.” ");
INSERT INTO tgp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mo r̃ule na nona tamlohi tuetueni mo rua, Timothy enia Erastus la vano Macedonia, pani enia mo mele toho atu Asia mata makomo rani. ");
INSERT INTO tgp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Hin la rani atu patumasa tavera matea Ephesus mo pala mata rasua hin Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mo tapulo na tamlohi matea hijana Demetrius, enia tamlohi matea mo lo vai na tamasi varihi mata nora Temple sei la tovia Artemis na silver. Ale enia peresi la haratu la lo vaira, la lo vai na mania tavera matana. ");
INSERT INTO tgp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Mo tovi matavuhi la tamlohi atu peresi la haratu la lo vavahinau na hinau mariviti i sohera, ale mara, “La tapala, ka levosahia vara nor̃a mauri tavtavi mo lo mai na nor̃a vavahinau. ");
INSERT INTO tgp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ale ka hitea ale ka rongoa vara Paul akerihi natu, mo lo vai na tamlohi vao tavera la lo rasua, ale nake la lo vahar̃i hin nor̃a god Artemis, matan mo lo verea isara mara god sei tamlohi la lo vaira na limara purongo, la sopo god varar̃uhu, ale mo sopo vujangia nike Ephesus purongo, pani na jara tari Asia sei mo lo vano ea. ");
INSERT INTO tgp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","I pa sopo sati purongo na nor̃a vavahinau mata tavtav, pani matan tamlohi la pa r̃omr̃omi purongo na temple non god har̃ai aulu sei Artemis, enia peresi na tamlohi na jara tari Asia peresi na varama sei la lo lotua, la pa rongo i sati matan hijana mo jovi.” ");
INSERT INTO tgp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lara la rongoa la lolokoru patura, ale la tapulo ngara lara, “Artemis nona mara Ephesus enia mo aulu jea!” ");
INSERT INTO tgp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Taon tavera atu mo mar̃ivi na uloulo, ale vao tavera atu la maro la vano na nora jara tavera mata matavuhi, la lo reve tahitahi Gaius enia Aristarchus, tamlohi mo rua mara Macedonia sei la lo usuri Paul na nona hahau. ");
INSERT INTO tgp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pani Paul mara mo opoia vara i unu hin jara matavuhi tavera atu, tamlohi usuri la horoa. ");
INSERT INTO tgp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mo sopo enira purongo pani tapalan Paul hai sohena, enira tamlohi aulu matan jara atu Asia, ale la sohai na retisohai matea isana la usia r̃ilangi vara i sopo unu hin jara matavuhi atu. ");
INSERT INTO tgp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Hin matavuhi atu, tamlohi hai la lo ngara mata hinau matea, hai la ngara na hinau tinapua matan matavuhi atu mo vaore hajavua, ale matuvana la sopo levosahia vara la lo matavuhi mata sava. ");
INSERT INTO tgp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tatuara hin vao atu la r̃omr̃omia vara enia matan Alexander, matan Jew hai la sohaia mo sahe na nahon matavuhi atu. Ale Alexander mo lo tahe na limana matan mo opoia vara i vere mamahunia na nahon vao atu, vara hinau nike Jew la sopo vaia. ");
INSERT INTO tgp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pani vao atu lara la hitea vara enia Jew matea, la mele tapulo uloulo, ale la taurilati uloulo atu mata aoa mo rua lara, “Artemis nona mara Ephesus enia mo aulu jea!” ");
INSERT INTO tgp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ale hitahun haratu, tamlohi tavera matan taon atu mara mo vaira la toho malum mo verea mara, “Mara Ephesus, sava tamlohi natu mo sopo levosahia vara taon matan Ephesus mo lo kilau mamahuni na temple non Artemis aulu peresi na vatuna sei mo jovi na tuka? ");
INSERT INTO tgp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Matan la hinau atu tea i sopo er̃i halu hinira, mo r̃uhu jea vara ha toho malum ha sopo rongorongo vono! ");
INSERT INTO tgp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Matan ka lavi la tamlohi nike la sinai nike, la sopo tamlohi mata vavanaho na temple teni la lo retisatihi nor̃a god har̃ai. ");
INSERT INTO tgp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ale, vara Demetrius peresi la haratu la lo vai voko akerihi, la rongo mo sati matan tea, ima aria mo lo roi, ale tamlohi aria la lo toho purongo, mo r̃uhu vara la usuri na malele leu ea. ");
INSERT INTO tgp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pani vara ka mele opoi te hinau aulu hinia, ha pa vai tataholoia na nor̃a matavuhi tavera hitahu. ");
INSERT INTO tgp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Matan vara i vono, tamlohi tavera matan Rome, la pa sile na talai isan matavuhi tavera nike matan mo vaore hajavua, ale mo sopo te retireti r̃uhu tea i er̃i verea matan matavuhi nike.” ");
INSERT INTO tgp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mara mo vere la hinau atu mo isoiso, mo r̃ulera la mule. ");
INSERT INTO tgp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Matavuhi tavera atu mara mo isoiso, Paul mo tovi na tamlohi usuri la mai jara matea. Ale mo retituetuenira moiso mo vere enr̃a vuho isara ale mo malue mo vano Macedonia. ");
INSERT INTO tgp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Na nona hahau mo lo vano mo retituetueni na kalesia na taon hatehateahi na malelena vavano mo pala Greece. ");
INSERT INTO tgp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Mo lo toho vitu mo tolu atu, ale Paul mo tatamahu vara i vele na boti matea i sivo Syria, pani matan mo rongoa vara Jew la hatihi moiso vara la pa vai te hinau isana, mo posi na r̃omina ale mo mele sahe mo hahau roto Macedonia. ");
INSERT INTO tgp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tamlohi hai la lo usuri Paul sohen: Sopater mara Berea natun Pyrrhus; Aristarchus enia Secundus mara Thessalonica, Gaius mara Derbe; Timothy, Tychicus enia Trophimus matan Asia. ");
INSERT INTO tgp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","La tamlohi nike la vano Troas tiroma vara la lo saovi kamam ea. ");
INSERT INTO tgp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Rani mata Passover la vano moiso, kama vele na boti matea Philippi, ale kama maro na tasi mata rani mo lima moiso, ale kama pa hoso isara Troas. Kama lo toho atu mata rani mo limaravrua. ");
INSERT INTO tgp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Na Sunday, kamara kama pulutahi jara matea mata hanhani non Moli, Paul mo tapulo vujangi na tamlohi, pani matan mo tau na r̃omina moiso vara i mele rani sahe i pa malue, mo vujangira vavano mo livuha vutepongi. ");
INSERT INTO tgp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kama lo sakele na jara matea mo aulu makomona na lolon ima atu kama lo toho hinia, ale lamu matuvana la lo hani hin jara atu, ");
INSERT INTO tgp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ale uluvou matea hijana Eutychus mo lo sakele na windoa matea, ale mo lo tapulo juruvi r̃omaliho, matan Paul mo retireti mo peravu. Ale mara mo juruvi r̃omaliho hin jara atu sei mo aulu sohena ima mo tolu, mo jovi sivo na lepa mo mate. ");
INSERT INTO tgp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pani Paul mo sivo isana mo rautoho, ale mo tapea na limana ale mara, “Ha sopo matahu, mo lo mauri.” ");
INSERT INTO tgp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Moiso Paul mo mele vele sahe aulu hin jara atu, ale mara mo tope na pereti ale la hania moiso, mo mele tapulo retireti peresira vavano mo rani, moiso mo malue isara. ");
INSERT INTO tgp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ale la lavi uluvou atu mo mule, ale la avulahi tavera matan mo lo r̃uhu purongo. ");
INSERT INTO tgp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kama vano tiroma na boti ale kama malue kama sivo Assos, matan vara kama pa tapai Paul ea, matan enia mo verea mara i pa hahau purongo i sivo atu, ale kama pa lingia atu. ");
INSERT INTO tgp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kamara kama tapai Paul Assos, mo vele na boti kama sivo Mitylene. ");
INSERT INTO tgp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kama malue atu ale mo mele rani sahe kama tikeli Chios, mo mele rani sahe kama pala Samos, ale mo mele rani sahe, kama tikeli Miletus. ");
INSERT INTO tgp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Matan Paul mo opoia vara i jeu Ephesus matan vara i sopo mele toho matan te rani atu Asia matan mo lo vaivila vara i sivo Jerusalem tiroma moiso i pa rani mata Pentecost. ");
INSERT INTO tgp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kama hoso Miletus ale Paul mo sohai na retisohai matea isana patu tamlohi mata vao kalesia Ephesus vara la sinai la tapaia atu. ");
INSERT INTO tgp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Lara la pala mo vere isara mara, “Kamim ka levosahi na mauriku hin rani atu na lo toho peresi kamim mo tapulo hin rani atu na tau na paloku Asia. ");
INSERT INTO tgp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Na volitusi non Moli na posposi r̃omatano peresi na tangi ale peresi na rani r̃ilangi sei la mai isaku na sava Jew la hatihia mataku. ");
INSERT INTO tgp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pani ka levosahi mamahunia vara hin la rani atu na sopo turu juha na noku retivujavujangi isamim matan te hinau sei vara i er̃i tueni kamim hinia. Ale na sopo turu juha hin te hinau na noku vujangi isamim na naho vao tamlohi teni na lolo ima hatehateahi, ");
INSERT INTO tgp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ale na lo retivuhesi isana Jew peresi na tamlohi r̃or̃oha mata vahar̃i na hehe la mai isan God na rasua hin nor̃a Moli Iesu. ");
INSERT INTO tgp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ale nakerihi, Tanume Tapu mo lo sohaiau vara a sivo Jerusalem, ale na sopo levosahi na sava i pa masese isaku atu, ");
INSERT INTO tgp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","pani Tanume Tapu mo pete retir̃oar̃oahaiau hinia moiso na taon tari sei na lo vano ea vara ima r̃ilangi peresi na noku tipahi la lo saoviau ea. ");
INSERT INTO tgp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pani mauriku i pa sopo r̃uhu matan te hinau isaku vara a sopo vai vevuhi na sava Moli Iesu mo taua na limaku, enia vavahinau sei mata vereuli na Retir̃uhu mata r̃omr̃uhu non God. ");
INSERT INTO tgp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ale nakerihi na lo vere tataholoia kamim hinia vara i pa sopo te vonamim hatea sei na lo hahau r̃alihi na lo retivujavujangi mauri atu God mo aulu hinia isana, i pa mele hiteau. ");
INSERT INTO tgp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Matan haratu, na lo verea vara mo sopo te noku hinau hinia na r̃aemim. ");
INSERT INTO tgp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Matan na sopo turu juha vara a sopo vereuli kamim na r̃omr̃omi tavera tari non God. ");
INSERT INTO tgp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ha hase kilau mamahuni kamim peresi na vao kalesia sei Tanume Tapu mo vai kamim ka aulu hinira, vara ha tiroma na vao kalesia non God sei mo volira na r̃aena. ");
INSERT INTO tgp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na levosahia, vara a malue isamim, tamlohi sasati sohena viriu jala la pa mai isamim, la pa komo na vao kalesia, ale la sopo er̃i r̃omr̃omira. ");
INSERT INTO tgp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mo sopo haratu purongo pani na lolomim tataholo te tamlohi la pa turu la vujangileji na retivarar̃uhu matan vara la pa lavi te nora tamlohi usuri isamim. ");
INSERT INTO tgp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Matan haratu, ha pa sopo peka, ha lo r̃omr̃omia vara, mata tauni mo tolu, tarea na lo retir̃oar̃oahai kamim hatehateahi peresi na wai mataku. ");
INSERT INTO tgp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ale nakerihi, na lo tau kamim na liman God matan vara ha pa sile na retisohai mata nona r̃omr̃uhu. Retisohai nike i er̃i tueni kamim vara ha r̃ilangi, ale i sile kamim na koruna peresi la haratu sei God mo tapuhira. ");
INSERT INTO tgp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ka levosahi mamahunia vara na sopo usi tea hin te silver, gold teni ruru. ");
INSERT INTO tgp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kamim ka levosahi mamahunia vara enau peresi la haratu sei la toho peresiau, kama lo hanhani na masumasuku purongo. ");
INSERT INTO tgp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Na noku tovongi na lo vujangi kamim hinia vara, vara ha lo vavahinau ha pa tueni la haratu la sopo r̃ilangi, ale ha r̃omr̃omi na reti non Moli Iesu sei enia hasena mo verea mara, ‘Avulahi tavera i pa vano isan haratu sei mo lo silea mo jeu haratu mo lavia.’” ");
INSERT INTO tgp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Mara mo vere la hinau atu moiso, mo papaohi sivo atano peresira ale mo usiusi. ");
INSERT INTO tgp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Enira mo isoiso la tapulo tangi aulu, la raho Paul ale la pungosia, ");
INSERT INTO tgp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","r̃omira mo pa sati jea matan mo verea mara la pa sopo er̃i mele hitea, moiso la usuria la sivo vara la taua na boti. ");
INSERT INTO tgp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kamara kama tinar̃ihira, kama malue vano na tasi, ale kama sivo tataholo na ureuren Cos, ale mo mele rani sahe kama pala Rhodes, ale kama malue atu kama hoso Patara. ");
INSERT INTO tgp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Hin jara atu kama tapai na boti matea, mo tatamahu vara i sivo Phoenicia, kama vele hinia ale kama malue vano na tasi. ");
INSERT INTO tgp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kama kilau vano na ureuren Cyprus mo lo sale vara i tihai na maraumam, ale kama lo sivo Syria, ale kama hoso Tyre matan boti atu i pa tinar̃ihi na nona lavlavi atu. ");
INSERT INTO tgp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ale kama ale na tamlohi usuri hin jara atu ale kama hitera, kama lo toho peresira mata rani mo limaravrua. La lo r̃area isan Paul lara Tanume Tapu mo verea isara vara i sopo tau na palona Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mo turu tetelehi na rani vara kama pa malue na boti, enira mo isoiso peresi na naroura, na natura, la usuri kamam kama malue hin taon tavera atu, ale kamara kama papaohi na oneone kama usiusi moiso, ");
INSERT INTO tgp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","kama vere enr̃a vuho isara hatehateahi moiso kama vele hin pa boti, ale enira la mele mule. ");
INSERT INTO tgp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kama mele tapulo na nomam hahau atu Tyre kama sivo kama hoso Ptolemais, ale kamara kama tulahi na vorai kalesia peresi na vevorai kalesia atu moiso, kama lo toho peresira mata rani matea. ");
INSERT INTO tgp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mo mele rani sahe, kama malue kama sivo kama hoso Caesarea, ale kama unu na iman Philip. Enia evangelist matea, enia deacon matea hin la haratu mo limaravrua, ale kama lo toho peresia. ");
INSERT INTO tgp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Venatuna mo vati la sopo lo lahi, ale la lo retimangovi. ");
INSERT INTO tgp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kama lo toho atu mata rani mo visa moiso, pr̃ovet matea hijana Agabus mo tai Judea mo sinai. ");
INSERT INTO tgp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Mo mai isamam, mo lavi na otin Paul, mo liho na limana peresi na palona hinia ale mara, “Tanume Tapu mo verea mara, ‘Hin malele akerihi natu, Jew matan Jerusalem la pa liho tamlohi atu sei otina nakerihi, ale la pa taua na lima tamlohi r̃or̃oha.’” ");
INSERT INTO tgp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kamam peresi la haratu la lo toho atu, kama rongo hinau atu sohena, kama verea r̃ilangi isan Paul vara i sopo sahe Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Moiso Paul mo verea mara, “Ka lo vai na sava nahai? Matan nomim tangi mo lo vaiau na lo rongo mo sati! Matan enau na tatamahu moiso vara la pa lihoau, ale vara a mate Jerusalem mata hijan Moli Iesu.” ");
INSERT INTO tgp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ale matan kama sopo er̃i horoa, kama sopo mele vere te hinau pani kamara, “R̃a pa usuri na masolon Moli purongo.” ");
INSERT INTO tgp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Hitahun la rani atu, kama tatamahu, ale kama sahe Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Tamlohi usuri mara Caesarea hai la usuri kamam, ale la lavi kamam la tau kamam na iman Mnason mara Cyprus, enia mo mai tamlohi usuri tuai moiso. ");
INSERT INTO tgp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hin rani atu kama pala Jerusalem, vorai peresi na vevorai kalesia la lavi kamam na avulahi tavera. ");
INSERT INTO tgp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mo mele rani sahe, Paul mo usuri kamam kama vano vara kama hite James peresi na vajiaha aulu na vao kalesia atu sei la lo toho atu. ");
INSERT INTO tgp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ale Paul mara mo sile na retioloolo isara moiso, mo tapulo vereuli mamahuni na hinau tari God mo vaia isana tamlohi r̃or̃oha na nona vavahinau. ");
INSERT INTO tgp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Lara la rongoa la hasohaso God moiso, la verea isana lara, “Ko levosahia vorai vara Jew mo tari vaha visa moiso la tau na nora rasu hin Iesu pani la pa lo turu r̃ilangi na leu non Moses. ");
INSERT INTO tgp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ale la rongoa moiso vara ko lo verea isana Jew tari sei la lo toho na jara tamlohi r̃or̃oha vara la sopo mele usuri na leu non Moses, ale ko verea isara vara la sopo tair̃alihi na natura teni vara la sopo usuri na posir̃a matan tuai. ");
INSERT INTO tgp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Vara mo sohena, r̃a pa er̃i vai na sava? La pa levosahia vara ko pala nike moiso. ");
INSERT INTO tgp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ale matana, o pa vai na sava kama pa verea isam nakerihi: nomam tamlohi tupu vati nahai, la vai na retitauhi isan God moiso matan vara la pa hiri pilopilo, ");
INSERT INTO tgp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","o lavira o vano peresira, o hase onehiho usuri na leu non Moses peresira, ale o voli na nora silesilea matan vara enira la er̃i hiri pilopilo. Moiso tamlohi tari la pa levosahia natu vara sava la lo rongoa matam enira hina purongo matan engko ko lo hahau usuri na leu. ");
INSERT INTO tgp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pani isana tamlohi r̃or̃oha sei la rasua, kama pete sohai na leta moiso peresi na nomam r̃omr̃omi vara la sopo hani na mit sei la silea isana tamasi moiso, ale la sopo inu na r̃ae, ale vara la sopo hani te maji sei la punia, ale vara la toho asau na mauri maji.” ");
INSERT INTO tgp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Moiso mo mele rani sahe, Paul mo lavi la tamlohi atu, ale enia mo hase vaia mo vokevoke peresira, moiso mo vano na Temple mo vereuli na isoiso rani mata nora retitauhi mata vokevoke isana pr̃is vara la pa sile na malamalai matara hatehateahi. ");
INSERT INTO tgp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","La rani mo limaravrua atu mariviti vara la isoiso, Jew hai matan Asia la hite Paul na lolo rope Temple. La halu na vao matea matan vara la pa taurilati Paul. ");
INSERT INTO tgp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","La lo uloulo lara, “Tavtavuin Israel! Ha tueni kamam! Tamlohi nike natu mo lo vujangi na tamlohi tari na jara tari vara la r̃ohu na nor̃a tamlohi, nor̃a leu ale jara tapu nike! Aulu hin haratu, mo lavi na tamlohi r̃or̃oha hai la unu na lolo rope Temple, ale mo vai jara tapu nike mo lumiha!” ");
INSERT INTO tgp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Matan hin rani atu purongo la hite Trophimus, mara Ephesus matea, mo lo toho peresi Paul Jerusalem, ale la lo r̃omr̃omia vara mo lavia mo unu na lolo rope Temple. ");
INSERT INTO tgp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ale tamlohi tari hin taon tavera atu la sopo mele sakele malum, ale tamlohi la maro jara matea, la tauri Paul ale la reve tahitahia mo malue na lolo Temple, ale vahatea purongo mataruana la pelati. ");
INSERT INTO tgp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ale la pa lo vaihitea vara la vilimateia. Pani retisohai matea mo tikeli na commander nona tamlohi vuro non Rome vara tamlohi tari la lo vai na vaore rongorongo vono Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Vahatea purongo commander atu mo lavi na tamlohi vuro peresi na captain la maro la sivo hin vao atu. Ale vao atu lara la hite commander atu mo mai peresi la tamlohi vuro atu, la sopo mele tamaji Paul. ");
INSERT INTO tgp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Moiso pa commander atu mo sinai mo taurilatia, ale mo retileu vara la lihoa na jen mo rua, moiso mo usia vara enia hare ale vara mo vai na sava mo sati. ");
INSERT INTO tgp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pani hai hin vao atu la lo ulo na hinau matea, hai la lo ulo na hinau tinapua, ale pa commander atu mara mo levosahia vara i pa sopo er̃i lavuti na retivarar̃uhu matan vaore atu, mo retileu vara la lavi Paul i unu na patu ima mata vuro Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ale lara la mai na jara sevsevuti hin patu ima mata vuro atu, tamlohi vuro la tauri Paul aulu na pilira matan vao atu la lo vaihitea mo r̃ilangi jea vara la vilimateia, ");
INSERT INTO tgp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","matan vao tamlohi atu la lo usuria la lo ngara lara, “Ha vilimateia!” ");
INSERT INTO tgp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ale lara la pa lo lavi Paul mo lo unu hin patu ima mata vuro atu, Paul mo verea isan commander atu mara, “A er̃i vere na hinau matea isam?” Commander atu mo hutua, mo r̃aramia mara, “Avei, engko ko levosahi na leo mara Greek? ");
INSERT INTO tgp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Engko mo sopo pa mara Egypt atu sei mo lo tiroma na vao mata valum naturihi, ale sei mo tiroma na tamlohi mata vili na tamlohi mo tari vaha vati la vano na jara tano koru?” ");
INSERT INTO tgp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul mo r̃aramia mara, “Mo vono! Enau Jew matea mara Tarsus hin Cilicia, enau matan taon aulu atu! O er̃i tinar̃ihia vara a retireti isan la tamlohi nike?” ");
INSERT INTO tgp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Commander atu mara mo tinar̃ihia, Paul mo turu hin jara sevsevuti atu, ale mo tahe na limana isan vao atu, ale lara la toho malum, mo retireti isara na leon tavtavuin Israel. ");
INSERT INTO tgp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ale Paul mara, “La vorai peresi na vajiaha, ha tapurongo na sava a pa verea mata noku vavahinau.” ");
INSERT INTO tgp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lara la rongoa vara mo lo retireti isara na leon tavtavuin Israel, la mele toho malum jea, ale mo verea mara, ");
INSERT INTO tgp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Enau Jew matea, na vora Tarsus hin Cilicia, pani na ulua hin taon tavera nike, na lavi na noku lelevosahi isan Gamaliel usuri na posposi tataholo mata leu nona nor̃a pua, ale na lo r̃ilangi hin God sohen kamim nahapani. ");
INSERT INTO tgp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Na lo tipahi na tamlohi hin rasua sei, hai la mate na noku vavahinau, na liho na lamane peresi na har̃ai na taura na ima r̃ilangi, ");
INSERT INTO tgp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","sohen pr̃is aulu peresi na tamlohi tari mata council la er̃i verea mataku. Na lavi na leta isara matan vara a lavia i vano isana vorair̃a Jew, Damascus. Ale na pa lo vano na maleleku matan vara a taurilatira ale a tiroma hinira la mai Jerusalem vara la lavi na talai nike, ");
INSERT INTO tgp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ale na pa lo vano mariviti Damascus, korong alo mo posi moiso, ale vahatea purongo, memera tavera matea mo sasari r̃alihiau. ");
INSERT INTO tgp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ale na jovi sivo na lepa na rongo na leo matea mo verea isaku mara, ‘Saul, Saul, mata sava ko lo tipahiau?’ ");
INSERT INTO tgp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ale na r̃aramia nara, ‘Tamlohi tavera, engko hare?’ Ale mo verea isaku mara, ‘Enau Iesu pa mara Nazareth atu sei ko lo tipahia!’ ");
INSERT INTO tgp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","La haratu la lo toho peresiau la hite memera atu, pani la sopo rongovosahi na leon haratu mo lo retireti isaku. ");
INSERT INTO tgp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ale na usia nara, ‘A pa vai na sava Moli?’ Ale Moli mo verea isaku mara, ‘O turu o vano Damascus, hin jara atu la pa vereho na hinau tari sei na vir̃oniho vara o pa vaira.’ ");
INSERT INTO tgp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ale matan na sopo mele er̃i kilau matan memera tavera atu, la haratu la lo toho peresiau la tiroma hiniau na vano Damascus. ");
INSERT INTO tgp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tamlohi matea hijana Ananias, mo lo lotu God tarea usuri na leu, ale Jew Damascus la verea vara enia tamlohi r̃uhu matea, ");
INSERT INTO tgp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","mo mai isaku, mo turu na pahisaku ale mo verea isaku mara, ‘Vorai Saul, o mele kilau!’ Ale vahatea purongo na kilau sahe na hitea. ");
INSERT INTO tgp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Moiso mo verea mara, ‘God nona nor̃a pua mo vir̃oniho moiso, vara o pa levosahi na masalona vara o pa hite haratu mo Tataholo Jea, ale vara o pa er̃i rongo na retileu matea na jingona, ");
INSERT INTO tgp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","matan engko, o pa nona tuetueni isana tamlohi tari na sava ko hitea ale sava ko rongoa. ");
INSERT INTO tgp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ale nakerihi, ko lo saovi na sava? O turu, o lavi na paptijo, ale God i pa hoje nar̃ihi na nom hehe, o tau na nom rasua na hijan Moli.’ ");
INSERT INTO tgp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Na rani na mele mai Jerusalem, ale na lo usiusi na lolo Temple, na hite na hinau matea sohena mavuho matea, ");
INSERT INTO tgp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ale na hite Moli mo lo verea isaku mara, ‘O vila, o malue Jerusalem vila matan la pa sopo er̃i lavi na nom vereulia mataku.’ ");
INSERT INTO tgp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na verea isana nara, ‘Pani Moli, enira hasera la er̃i verea vara enau natu, na lo tau la haratu la rasuho na ima r̃ilangi, ale na lo hamajira na ima lotu nona Jew tari. ");
INSERT INTO tgp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ale na rani nom tuetueni Stephen mo mate, na lo turu atu na majinga hinia, ale na lo kilau mamahuni na ruru non la haratu la lo vilia.’ ");
INSERT INTO tgp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ale mo verea isaku mara, ‘O malue Jerusalem, matan a pa r̃uleho o vano asau r̃ove isana tamlohi r̃or̃oha!’” ");
INSERT INTO tgp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Vao atu la lo tapurongo hinia mo tikeli reti sei Paul mo verea mara, ‘La haratu la tamlohi r̃or̃oha.’ Ale la ngaruhia lara, “Ha vilimateia! Mo sopo tataholo vara i lo mauri!” ");
INSERT INTO tgp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","La ngara ngara, ale la lo lanar̃ihi na nora ruru peravu, ale la lo pulahi na tangotango aulu na masapa, ");
INSERT INTO tgp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ale pa commander atu mo retileu vara la lavia i unu hin patu ima mata vuro atu. Mo vere na nona tamlohi vara la pa rupia na asi maja mata lavi na r̃arami nona retiusia, matan mo opoia vara i levosahia vara vao atu mo lo ngarahia mata sava. ");
INSERT INTO tgp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lara la r̃irahi Paul na jara mata tamaji na tamlohi moiso, Paul mo verea isana captain mata tamlohi vuro matea mo lo turu na pahisana mara, “Mo tataholo vara ha rupi na mara Rome matea na asi maja matea, pani ka sopo lo aria?” ");
INSERT INTO tgp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pa captain atu mara mo rongoa sohena, mo vano isan nona commander, ale mo verea isana mara, “Ko levosahi na sava ko lo tatamahu vara o vaia? Matan tamlohi nike enia mara Rome matea!” ");
INSERT INTO tgp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Pa commander atu mo mai mo usia isan Paul mara, “O to verea isaku, varar̃uhu vara engko mara Rome matea?” Ale Paul mo r̃aramia mara, “He'e.” ");
INSERT INTO tgp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ale commander atu mo r̃aramia mara, “Enau na jalahi na mania tavera matan vara a er̃i mai mara Rome matea.” Paul mara, “Pani enau, na vora mara Rome matea.” ");
INSERT INTO tgp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ale la haratu sei la lo tatamahu vara la pa rupia na asi maja, la turu juha hinia vahatea. Pa patu tamlohi vuro aulu atu mo matahu matan mo levosahia vara Paul enia mara Rome tataholo matea, ale enia natu mo verea vara la lihoa. ");
INSERT INTO tgp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mo mele rani sahe, ale matan pa patu tamlohi vuro aulu atu mo opoia vara i levosahia i r̃uhu vara Jew la lo tuvai Paul mata sava, mo uli nar̃ihia ale mo retileu vara moli nona pr̃is peresi na tamlohi tari mata council matan Jerusalem la mai jara matea. Ale mo lavi Paul ale mo vaia mo turu na nahora. ");
INSERT INTO tgp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ale Paul mo kilau tataholo isana tamlohi hin council atu, ale mara, “La vorai, na mauriku na nahon God mo tikeli nake, r̃omiku mo sopo kaka hin te hinau.” ");
INSERT INTO tgp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananias pr̃is aulu mara mo rongoa, mo verea mara la haratu la lo turu na pahisana la vojahia na jingona. ");
INSERT INTO tgp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ale Paul mo verea isana mara, “God i pa vojahiho, ko tapnetano! Ko sakele atu vara o ariau usuri na leu, moiso ko lo tope na leu na nom retileu vara la vojahiau.” ");
INSERT INTO tgp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","La haratu la lo turu mariviti la verea lara, “Ko r̃om vara mo tataholo vara o reti isan pr̃is aulu non God sohen haratu?” ");
INSERT INTO tgp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ale Paul mara, “La vorai, na sopo lo levosahia vara enia pr̃is aulu. Matan na levosahia vara Retiulia mo verea vara, ‘Ha sopo veresati na nomim tamlohi aulu’.” ");
INSERT INTO tgp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Moiso, Paul mo hitea vara sopen vao atu enia Sadducee, ale sopera enira Pharisee, ale mo ulo aulu isana tamlohin council atu mara, “La vorai, enau Pharisee matea, enau natu Pharisee. Na lo turu na aria matan na lo r̃omtoho na sauteterahi!” ");
INSERT INTO tgp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Mara mo verea sohena, vasvas matea mo malue isana Pharisee peresi na Sadducee ale vao atu la patumasa. ");
INSERT INTO tgp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Matan Sadducee la verea vara mo sopo te sauteterahi, teni te angelo teni te tanume, pani Pharisee la rasu la hinau sei. ");
INSERT INTO tgp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ale vao atu la vaore tavera, tamlohi vujangi mata leu na vao Pharisee la turu ale la verea mo r̃ilangi lara, “Kama sopo hite te hinau i sati isan tamlohi nike. I pa sohena sava vara te tanume r̃uhu teni te angelo mo lo retireti isana?” ");
INSERT INTO tgp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ale commander atu mara mo hitea, mo matahu vara la pa r̃arir̃ari Paul, ale mo retileu vara nona tamlohi vuro la sivo la lavi nar̃ihia na nora suiha, ale la mele lavia i vano i unu na patu ima mata vuro. ");
INSERT INTO tgp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Hin vutepongi atu Moli mo turu mariviti isan Paul ale mo verea mara, “O sopo matahu! Matan sohena nakerihi ko lo vereuliau nike Jerusalem, o pa vereuliau sohena Rome.” ");
INSERT INTO tgp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mo mele rani sahe, vao Jew matea la mai jara matea, la lihora na retitauhi matea vara la pa sopo tikeli te hanhani teni te wai vavano, la vilimatei Paul. ");
INSERT INTO tgp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Vao atu sei la vai retitauhi atu mo jeu mo ngavulu vati . ");
INSERT INTO tgp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","La vano isana pr̃is aulu peresi na vajiahara, ale lara, “Kama liho kamam na retitauhi matea vara kama pa sopo mele tikeli te hanhani teni te wai vavano kama vilimatei Paul. ");
INSERT INTO tgp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ale nakerihi kamim peresi na tamlohi council ha vahar̃ule matana isan patu tamlohi vuro aulu atu, vara i lavia i sinai isamim. Ale ha vaia sohena vara ha pa mele kilau usuri mamahuni na nona aria. Ale kama pa tatamahu vara kama vilia na malele, ale i pa sopo er̃i kakau nike.” ");
INSERT INTO tgp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pani natun vetasin Paul mara mo rongoa vara la pa luhu hinia, mo mai mo unu hin patu ima mata vuro atu mo vereulia isan Paul ");
INSERT INTO tgp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ale Paul mo tovi na captain matea hin la captian atu mara, “O lavi uluvou nike i sahe isan nom commander, ale uluvou nike i pa vere na hinau matea isana.” ");
INSERT INTO tgp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ale captain atu, mo lavia mo sahe isan nona commander ale mara, “Paul mo toviau mo usiau vara a lavi uluvou nike i mai isam, matan enia mo lavi na retisohai matea vara i pa silea isam.” ");
INSERT INTO tgp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Pa commander atu mo tauri na limana, ale mo lavia la sivo enira hasera, ale mo usia mara, “Sava natu ko opoia vara o verea isaku?” ");
INSERT INTO tgp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mo r̃aramia mara, “Jew la majinga moiso vara pavuho, la pa usiho vara o lavi Paul i sivo na council, vara la pa mele kilau usuri mamahuni na nona aria. ");
INSERT INTO tgp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pani o sopo tinar̃ihia vara la haluhaluho matana! Matan tamlohi mo jeu mo ngavulu vati la pa luhu la lo saovia. La lihora na retitauhi matea moiso vara la pa sopo tikeli te hanhani teni te wai vavano la vilimateia. Ale nakerihi la tatamahu moiso, la lo saovi na nom majinga purongo natu.” ");
INSERT INTO tgp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Moiso, commander atu mo r̃ule uluvou atu mo mele malue, ale mo verea isana mara, “O sopo mele vere tea hin hinau akerihi ko verea isaku.” ");
INSERT INTO tgp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Moiso, pa commander atu mo tovi na nona captain mo rua, ale mo verea isara mara, “Ha tatamahuni te tamlohi vuro i ngavulu sangavulu rua vara la sivo Caesarea nohorihi na matan alo i limaravati na vutepongi, peresi te hos i ngavulu limaravrua peresi na tamlohira, ale peresi te tamlohi vuro mata sari i ngavulu sangavulu rua . ");
INSERT INTO tgp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ha tatamahuni te hos non Paul vara i pa vele hinia, ale ha lavi mamahunia i sivo isan Felix tamlohi aulu matan Palestine.” ");
INSERT INTO tgp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Moiso mo uli leta nike isan Felix mara, ");
INSERT INTO tgp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Leta nike enau Claudius Lysias na lo uli na noku retioloolo mo vano isam Felix tamlohi aulu r̃uhur̃uhu. ");
INSERT INTO tgp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Tamlohi akerihi, Jew hai la taurilatia ale la tatamahu vara la pa vilia ale na sinai peresi na noku tamlohi vuro ale kama nar̃ihia, ale matan na levosahia vara enia mara Rome matea na lo matahia. ");
INSERT INTO tgp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Na lavia mo sivo na nora council matan na opoia vara a levosahi mamahunia vara la lo aria mata sava. ");
INSERT INTO tgp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Na hiteulia vara la lo tuvaia matan te hinau usuri na leu mata nora rasua, pani mo sopo matan te hinau vara i pa toho na ima r̃ilangi teni i mate matana. ");
INSERT INTO tgp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pani nara na levosahia vara la lo vai na malele matea vara la pa vilimateia, na r̃ulea mo mai nike isam vahatea. Ale na verea isan la haratu la lo aria vara la pa lavi na nora retiaria sei la lo aria hinia la verea isam.” ");
INSERT INTO tgp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ale la tamlohi vuro atu la vaia usuri na nona retileu. La lavi Paul mo sivo Antipatris hin vutepongi atu. ");
INSERT INTO tgp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mo mele rani sahe, la tinar̃ihia vara tamlohi vuro na hos purongo la sivo peresia. Ale enira la mele hilu la sahe na nora patu ima mata vuro Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","La tamlohi vuro na hos atu lara la pala Caesarea, la lavi Paul peresi pa leta atu la silea isan tamlohi aulu atu Felix. ");
INSERT INTO tgp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Tamlohi aulu atu mara mo evi leta atu moiso, mo usi Paul vara mo tai na sava jara, ale mara mo levosahia vara mo tai Cilicia, ");
INSERT INTO tgp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","mo verea mara, “A pa sileho na masapa vara o retireti hin rani atu vara nom meresahi la pala nike.” Moiso, mo retileu vara la pa pelati horo Paul na jara matea na lolo ima tavera, iman Herod Agrippa. ");
INSERT INTO tgp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ale rani mo lima la vano moiso, Ananias pa pr̃is aulu atu mo sinai peresi na vajiaha hai peresi na tamlohi retireti na leu matea hijana Tertullus, ale matan vara la sile na nora retiaria matan Paul isan tamlohi aulu atu Felix. ");
INSERT INTO tgp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ale lara la tovi Paul mo sinai moiso, Tertullus mo tapulo aria mara: “Tamlohi aulu Felix, kama lo toho na tamata mo peravu jea na ruhuruhum, ale hina paro r̃uhu hai la malue na jaramam usuri na nom kilakilau. ");
INSERT INTO tgp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kama lo vere la hinau nike na jara tari, ale na malele tari na nomam vere meje. ");
INSERT INTO tgp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Pani matan vara a sopo mele taurilatiho i peravu, na lo usia isam vara o tapurongo isamam makomona purongo usuri na nom r̃omr̃uhu. ");
INSERT INTO tgp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Matan kama tapaia vara tamlohi nike enia tamlohi lejileji matea, enia tamlohi matea mo lo vai na tamlohi la lo matavuhi mata vai na hina sati na jara tari Jew la lo toho ea na varama, ale enia patu tamlohi nona vao haluhalu matea la lo tovia lara vao mara Nazareth. ");
INSERT INTO tgp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Mo sopo haratu purongo, pani kama tauria hin rani atu mo lo vaihitea vara i vai na Temple i lumiha. ");
INSERT INTO tgp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","8","O pa er̃i tapai na retivarar̃uhu mata nomam aria isana hasena vara o usia.” ");
INSERT INTO tgp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ale, la Jew atu sei la lo tapurongo usuria, la tapulo verelejlejia, ale lara hinau tari sei Tertullus mo lo verera la varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Pa tamlohi aulu mara mo tahe na limana vara Paul i er̃i retireti, Paul mo r̃aramia mara: “Matan na levosahia vara engko ko lo toho sohena tamlohi aria matea matan jara nike tuai moiso mo mai, mo vaiau na sopo matahu vara a vere na noku retireti. ");
INSERT INTO tgp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ale vara ko opoia, o pa er̃i levosahia vara rani mo sopo lo jeu sangavulu r̃omana mo rua na sahe Jerusalem mata lotu. ");
INSERT INTO tgp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","La sopo tapaiau vara a lo vasvas peresi tea teni vara a lo tovi matavuhi na tamlohi matan vara la vai te hina sasati na lolo rope Temple, teni hin te ima lotu hatea teni na malele matan taon tavera atu Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ale la tamlohi nike, la sopo er̃i pisuhiau hin te hinau hatea hin la hinau nike la lo ariau vara na vaira. ");
INSERT INTO tgp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Pani na taviti vara na lo lotu God non nomam pua usuri na malele rasua hara sei la lo verea vara enia rasua haluhalu matea. Ale na lo rasu na hinau tari sei Moses peresi na pr̃ovet la ulia na Leu. ");
INSERT INTO tgp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Enau na lo tau na noku r̃omtoho isan God sohen la tamlohi nike vara i pa sauteterahi na tamlohi tari, la haratu la tataholo peresi la haratu la sopo tataholo. ");
INSERT INTO tgp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Matan hinau atu natu, mo lo vaiau na lo vaihitea tarea vara r̃omiku i pa sopo kaka hin te hinau isan God teni isana tamlohi. ");
INSERT INTO tgp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Tauni mo visa la vano moiso na sopo mele toho Jerusalem, ale na mele sinai ea peresi na otori nona noku tamlohi vara a silea isan la haratu la tilavono, ale vara a sile na noku silesilea mata malamalai, ");
INSERT INTO tgp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","sei na lo vaira hin rani atu la tapaiau na lolo rope Temple. Na pete vokevoke moiso usuri na nomam posposi, ale mo sopo te vao teni tea i lo vai na valum. ");
INSERT INTO tgp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Pani Jew hai matan Asia, i pa r̃uhu jea vara la lo toho akerihi na nahom nakerihi matan vara la tuvaiau hin te retiaria matan te hinau sati vara la er̃i verea mataku. ");
INSERT INTO tgp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O to usi la tamlohi nike vara sava hina sati natu, la hitea hiniau hin rani atu na lo turu na nahon council atu, ");
INSERT INTO tgp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","pani hinau matea purongo na ulo na verea na nahora nara, na lo turu nike na aria nahapani matan na rasu na sauteterahi nona mateia.” ");
INSERT INTO tgp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Moiso Felix, matan enia mo levosahi mamahuni na malele nora rasua mo r̃uhu, mo verea mara nora masapa mata sile na nora retireti mo isoiso, ale mo verea isara mara, “Sava rani vara patu tamlohi vuro aulu atu Lysias i sinai nike, a pa sile na noku r̃omr̃omi mata nomim aria.” ");
INSERT INTO tgp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ale mo retileu vara captain atu, i lo kilau mamahuni Paul na ima tavera atu purongo. Ale vara i sopo horoa na masalona, ale vara i sopo horo na tapalan Paul vara la opoia vara la mai la tuenia. ");
INSERT INTO tgp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Rani mo visa la vano moiso, Felix enia narouna Drusilla sei enia Jew matea, la pala. Ale mo vahar̃ule matan Paul vara la tapurongo hinia vara i verera hin rasua atu hin Iesu Kr̃isto. ");
INSERT INTO tgp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ale Felix mara mo rongo Paul mo lo sorahi na mauri tataholo, ale mata hase taurilatiho peresi na rani ari tavera sei mo lo mai, enia mo matahu tavera, ale mara, “O vano tako, ale vara te masapaku a pa mele vahar̃ule matam.” ");
INSERT INTO tgp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mo lo tapurongo hinia, pani mo lo r̃omtau vara Paul i pa silea hin te mania na har̃i tamlohi, ale matan haratu, mo vahar̃ule matana vaha visa vara i mai i sorasora peresia. ");
INSERT INTO tgp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Tauni mo rua la vano sohen haratu moiso, natu Porcius Festus mo pete lavi na jaran Felix, pani matan Felix mo opoia vara i vai na Jew la avulahi, mo tau Paul na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus mo pala Caesarea ale rani mo tolu tinapua la vano moiso, ale mo sahe Jerusalem. ");
INSERT INTO tgp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ale moli nona pr̃is peresi na tamlohi aulu nona Jew la lavi na nora retiaria hin Paul la vano isana. ");
INSERT INTO tgp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","La usia isana vara i vai na sava la opoia matan Paul, la usi Festus mo r̃ilangi vara i vahar̃ule vara i mai Jerusalem matan la hatihia moiso vara la pa luhu na malele vara la vilimateia. ");
INSERT INTO tgp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Moiso Festus mo r̃aramira mara la lo taurilatia Caesarea, ale enia i pa mele sivo atu i sopo tuai. ");
INSERT INTO tgp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mo verea mara, “Ale, mo r̃uhu vara nomim tamlohi tatavera la sivo atu peresiau, ale vara tamlohi akerihi mo vai te hinau mo sati, la pa er̃i sile na nora retiaria.” ");
INSERT INTO tgp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ale Festus mo mele toho Jerusalem mariviti rani i sangavulu, moiso mo pa sivo Caesarea. Ale mo mele rani sahe mo sakele na jara sakele mata aria, ale mo retileu vara la lavi Paul i mai isana. ");
INSERT INTO tgp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paul mara mo pala, la Jew atu sei la lo tai Jerusalem la lo sinai, la turu r̃alihia la lo tuvaia na hinau sasati hai sei la sopo er̃i vujangira vara la varar̃uhu. ");
INSERT INTO tgp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paul mo sile na nona retireti mata horora mara, “Na sopo vai te hinau i sati mata i vaiau a meresahi na leu nona Jew, teni na Temple, teni isana supe matan Rome.” ");
INSERT INTO tgp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pani Festus mo opoia vara i vai na Jew la avulahi, mo usia mara, “O pa avulahi vara o sahe Jerusalem vara o turu na aria na nahoku matan la hinau nike?” ");
INSERT INTO tgp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul mo r̃aramia mara, “Nakerihi na lo turu na jara tataholo moiso mata aria na naho jara sakele mata ari non supe matan Rome. Na sopo vai te hinau i sati isana Jew sohen engko ko levosahi mamahunia. ");
INSERT INTO tgp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Vara na vai te hinau mo tataholo vara a mate matana, na sopo r̃ohu na mate. Pani vara na lo vokevoke purongo, engko teni te hatea i sopo er̃i tauau na liman la tamlohi nike sei la opoia vara la vilimateiau. Na opoia vara a turu na nahon supe matan Rome!” ");
INSERT INTO tgp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus mo sorasora peresi na nona tamlohi tuetueni sei vara la sile te r̃omr̃omi hatea isana, moiso mo r̃aramia mara, “Ko opoia vara o turu na nahon supe matan Rome, ale isan supe matan Rome o pa vano.” ");
INSERT INTO tgp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Rani mo visa la vano moiso, harua supe Agrippa mo pala Caesarea peresi vetasina Bernice, matan vara la sile na nora oloolo isan Festus. ");
INSERT INTO tgp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Hin la rani atu la lo toho peresia, Festus mo vereuli na sorasora matan Paul isan supe atu matan vara i sile te retireti matana mara: “Felix mo tau na tamlohi matea mo lo toho na ima r̃ilangi. ");
INSERT INTO tgp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Na rani na lo toho Jerusalem, moli nona pr̃is peresi na vajiaha nona Jew la vereau hinia, la usiau vara a sile na talai isana. ");
INSERT INTO tgp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Na verea isara nara, mo sopo usuri na posposi nona mara Rome vara a sile te tamlohi na talai vara mo sopo lo lavi te masapa vara i turu nahonaho peresira